﻿USE sofia;
DROP TABLE IF EXISTS sofia.srp1865_vpl;
CREATE TABLE srp1865_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES srp1865_vpl WRITE;
INSERT INTO srp1865_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","U početku stvori Bog nebo i zemlju. ");
INSERT INTO srp1865_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","A zemlja beše bez obličja i pusta, i beše tama nad bezdanom; i duh Božji dizaše se nad vodom. ");
INSERT INTO srp1865_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","I reče Bog: Neka bude svetlost. I bi svetlost. ");
INSERT INTO srp1865_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","I vide Bog svetlost da je dobra; i rastavi Bog svetlost od tame. ");
INSERT INTO srp1865_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","I svetlost nazva Bog dan, a tamu nazva noć. I bi veče i bi jutro, dan prvi. ");
INSERT INTO srp1865_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Potom reče Bog: Neka bude svod posred vode, da rastavlja vodu od vode. ");
INSERT INTO srp1865_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","I stvori Bog svod, i rastavi vodu pod svodom od vode nad svodom; i bi tako. ");
INSERT INTO srp1865_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","A svod nazva Bog nebo. I bi veče i bi jutro, dan drugi. ");
INSERT INTO srp1865_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Potom reče Bog: Neka se sabere voda što je pod nebom na jedno mesto, i neka se pokaže suvo. I bi tako. ");
INSERT INTO srp1865_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","I suvo nazva Bog zemlja, a zborišta vodena nazva mora; i vide Bog da je dobro. ");
INSERT INTO srp1865_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Opet reče Bog: Neka pusti zemlja iz sebe travu, bilje, što nosi seme, i drvo rodno, koje rađa rod po svojim vrstama, u kome će biti seme njegovo na zemlji. I bi tako. ");
INSERT INTO srp1865_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","I pusti zemlja iz sebe travu, bilje, što nosi seme po svojim vrstama, i drvo, koje rađa rod, u kome je seme njegovo po njegovim vrstama. I vide Bog da je dobro. ");
INSERT INTO srp1865_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","I bi veče i bi jutro, dan treći. ");
INSERT INTO srp1865_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Potom reče Bog: Neka budu videla na svodu nebeskom, da dele dan i noć, da budu znaci vremenima i danima i godinama; ");
INSERT INTO srp1865_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","i neka svetle na svodu nebeskom, da obasjavaju zemlju. I bi tako. ");
INSERT INTO srp1865_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","I stvori Bog dva videla velika: videlo veće da upravlja danom, i videlo manje da upravlja noću, i zvezde. ");
INSERT INTO srp1865_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","I postavi ih Bog na svodu nebeskom da obasjavaju zemlju. ");
INSERT INTO srp1865_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","I da upravljaju danom i noću, i da dele svetlost od tame. I vide Bog da je dobro. ");
INSERT INTO srp1865_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","I bi veče i bi jutro, dan četvrti. ");
INSERT INTO srp1865_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Potom reče Bog: Neka vrve po vodi žive duše, i ptice neka lete iznad zemlje pod svod nebeski. ");
INSERT INTO srp1865_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","I stvori Bog kitove velike i sve žive duše što se miču, što provrveše po vodi po vrstama svojim, i sve ptice krilate po vrstama njihovim. I vide Bog da je dobro; ");
INSERT INTO srp1865_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","i blagoslovi ih Bog govoreći: Rađajte se i množite se, i napunite vodu po morima, i ptice neka se množe na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","I bi veče i bi jutro, dan peti. ");
INSERT INTO srp1865_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Potom reče Bog: Neka zemlja pusti iz sebe duše žive po vrstama njihovim, stoku i sitne životinje i zveri zemaljske po vrstama njihovim. I bi tako. ");
INSERT INTO srp1865_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","I stvori Bog zveri zemaljske po vrstama njihovim, i stoku po vrstama njenim, i sve sitne životinje na zemlji po vrstama njihovim. I vide Bog da je dobro. ");
INSERT INTO srp1865_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Potom reče Bog: Da načinimo čoveka po svom obličju, kao što smo mi, koji će biti gospodar od riba morskih i od ptica nebeskih i od stoke i od cele zemlje i od svih životinja što se miču po zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","I stvori Bog čoveka po obličju svom, po obličju Božjem stvori ga; muško i žensko stvori ih. ");
INSERT INTO srp1865_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","I blagoslovi ih Bog, i reče im Bog: Rađajte se i množite se, i napunite zemlju, i vladajte njom, i budite gospodari od riba morskih i od ptica nebeskih i od svih zveri što se miče po zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","I još reče Bog: Evo, dao sam vam sve bilje što nosi seme po svoj zemlji, i sva drveta rodna koja nose seme; to će vam biti za hranu. ");
INSERT INTO srp1865_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","A svim zverima zemaljskim i svim pticama nebeskim i svemu što se miče na zemlji i u čemu ima duša živa, dao sam svu travu da jedu. I bi tako. ");
INSERT INTO srp1865_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Tada pogleda Bog sve što je stvorio, i gle, dobro beše veoma. I bi veče i bi jutro, dan šesti. ");
INSERT INTO srp1865_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tako se dovrši nebo i zemlja i sva vojska njihova. ");
INSERT INTO srp1865_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","I svrši Bog do sedmog dana dela svoja, koja učini; i počinu u sedmi dan od svih dela svojih, koja učini; ");
INSERT INTO srp1865_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","i blagoslovi Bog sedmi dan, i posveti ga, jer u taj dan počinu od svih dela svojih, koja učini. ");
INSERT INTO srp1865_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","To je postanje neba i zemlje, kad postaše, kad Gospod Bog stvori zemlju i nebo, ");
INSERT INTO srp1865_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","I svaku biljku poljsku, dokle je još ne beše na zemlji, i svaku travku poljsku, dokle još ne nicaše; jer Gospod Bog još ne pusti dažda na zemlju, niti beše čoveka da radi zemlju, ");
INSERT INTO srp1865_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ali se podizaše para sa zemlje da natapa svu zemlju. ");
INSERT INTO srp1865_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","A stvori Gospod Bog čoveka od praha zemaljskog, i dunu mu u nos duh životni; i posta čovek duša živa. ");
INSERT INTO srp1865_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","I nasadi Gospod Bog vrt u Edemu na istoku; i onde namesti čoveka, kog stvori. ");
INSERT INTO srp1865_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","I učini Gospod Bog, te nikoše iz zemlje svakakva drveća lepa za gledanje i dobra za jelo, i drvo od života usred vrta i drvo od znanja dobra i zla. ");
INSERT INTO srp1865_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A voda tečaše iz Edema natapajući vrt, i odande se deliše u četiri reke. ");
INSERT INTO srp1865_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Jednoj je ime Fison, ona teče oko cele zemlje evilske, a onde ima zlata, ");
INSERT INTO srp1865_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","i zlato je one zemlje vrlo dobro; onde ima i bdela i dragog kamena oniha. ");
INSERT INTO srp1865_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","A drugoj je reci ime Geon, ona teče oko cele zemlje huske. ");
INSERT INTO srp1865_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","A trećoj je reci ime Hidekel, ona teče k asirskoj. A četvrta je reka Efrat. ");
INSERT INTO srp1865_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","I uzevši Gospod Bog čoveka namesti ga u vrtu edemskom, da ga radi i da ga čuva. ");
INSERT INTO srp1865_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","I zapreti Gospod Bog čoveku govoreći: Jedi slobodno sa svakog drveta u vrtu; ");
INSERT INTO srp1865_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ali s drveta od znanja dobra i zla, s njega ne jedi; jer u koji dan okusiš s njega, umrećeš. ");
INSERT INTO srp1865_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","I reče Gospod Bog: Nije dobro da je čovek sam; da mu načinim druga prema njemu. ");
INSERT INTO srp1865_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Jer Gospod Bog stvori od zemlje sve zveri poljske i sve ptice nebeske, i dovede k Adamu da vidi kako će koju nazvati, pa kako Adam nazove koju životinju onako da joj bude ime; ");
INSERT INTO srp1865_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","i Adam nadede ime svakom živinčetu i svakoj ptici nebeskoj i svakoj zveri poljskoj; ali se ne nađe Adamu drug prema njemu. ");
INSERT INTO srp1865_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","I Gospod Bog pusti tvrd san na Adama, te zaspa; pa mu uze jedno rebro, i mesto popuni mesom; ");
INSERT INTO srp1865_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","i Gospod Bog stvori ženu od rebra, koje uze Adamu, i dovede je k Adamu. ");
INSERT INTO srp1865_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","A Adam reče: Sada eto kost od mojih kosti, i telo od mog tela. Neka joj bude ime čovečica, jer je uzeta od čoveka. ");
INSERT INTO srp1865_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Zato će ostaviti čovek oca svog i mater svoju, i prilepiće se k ženi svojoj, i biće dvoje jedno telo. ");
INSERT INTO srp1865_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","A behu oboje goli. Adam i žena mu, i ne beše ih sramota. ");
INSERT INTO srp1865_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ali zmija beše lukava mimo sve zveri poljske, koje stvori Gospod Bog; pa reče ženi: Je li istina da je Bog kazao da ne jedete sa svakog drveta u vrtu? ");
INSERT INTO srp1865_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","A žena reče zmiji: Mi jedemo rod sa svakog drveta u vrtu; ");
INSERT INTO srp1865_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","samo rod s onog drveta usred vrta, kazao je Bog, ne jedite i ne dirajte u nj, da ne umrete. ");
INSERT INTO srp1865_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","A zmija reče ženi: Nećete vi umreti; ");
INSERT INTO srp1865_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","nego zna Bog da će vam se u onaj dan kad okusite s njega otvoriti oči, pa ćete postati kao bogovi i znati šta je dobro šta li zlo. ");
INSERT INTO srp1865_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","I žena videći da je rod na drvetu dobar za jelo i da ga je milina gledati i da je drvo vrlo drago radi znanja, uzabra rod s njega i okusi, pa dade i mužu svom, te i on okusi. ");
INSERT INTO srp1865_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tada im se otvoriše oči, i videše da su goli; pa spletoše lišća smokovog i načiniše sebi pregače. ");
INSERT INTO srp1865_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","I začuše glas Gospoda Boga, koji iđaše po vrtu kad zahladi; i sakri se Adam i žena mu ispred Gospoda Boga među drveta u vrtu. ");
INSERT INTO srp1865_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","A Gospod Bog viknu Adama i reče mu: Gde si? ");
INSERT INTO srp1865_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A on reče: Čuh glas Tvoj u vrtu, pa se poplaših, jer sam go, te se sakrih. ");
INSERT INTO srp1865_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","A Bog reče: Ko ti kaza da si go? Da nisi jeo s onog drveta što sam ti zabranio da ne jedeš s njega? ");
INSERT INTO srp1865_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","A Adam reče: Žena koju si udružio sa mnom, ona mi dade s drveta, te jedoh. ");
INSERT INTO srp1865_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","A Gospod Bog reče ženi: Zašto si to učinila? A žena odgovori: Zmija me prevari, te jedoh. ");
INSERT INTO srp1865_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tada reče Gospod Bog zmiji: Kad si to učinila, da si prokleta mimo svako živinče i mimo sve zveri poljske; na trbuhu da se vučeš i prah da jedeš do svog veka. ");
INSERT INTO srp1865_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I još mećem neprijateljstvo između tebe i žene i između semena tvog i semena njenog; ono će ti na glavu stajati a ti ćeš ga u petu ujedati. ");
INSERT INTO srp1865_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A ženi reče: Tebi ću mnoge muke zadati kad zatrudniš, s mukama ćeš decu rađati, i volja će tvoja stajati pod vlašću muža tvog, i on će ti biti gospodar. ");
INSERT INTO srp1865_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Pa onda reče Adamu: Što si poslušao ženu i okusio s drveta s kog sam ti zabranio rekavši da ne jedeš s njega, zemlja da je prokleta s tebe, s mukom ćeš se od nje hraniti do svog veka; ");
INSERT INTO srp1865_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Trnje i korov će ti rađati, a ti ćeš jesti zelje poljsko; ");
INSERT INTO srp1865_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Sa znojem lica svog ješćeš hleb, dokle se ne vratiš u zemlju od koje si uzet; jer si prah, i u prah ćeš se vratiti. ");
INSERT INTO srp1865_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","I Adam nadede ženi svojoj ime Jeva, zato što je ona mati svima živima. ");
INSERT INTO srp1865_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","I načini Gospod Bog Adamu i ženi njegovoj haljine od kože, i obuče ih u njih. ");
INSERT INTO srp1865_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","I reče Gospod Bog: Eto, čovek posta kao jedan od nas znajući šta je dobro šta li zlo; ali sada da ne pruži ruku svoju i uzbere i s drveta od života, i okusi, te do veka živi. ");
INSERT INTO srp1865_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","I Gospod Bog izagna ga iz vrta edemskog da radi zemlju, od koje bi uzet; ");
INSERT INTO srp1865_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","i izagnav čoveka postavi pred vrtom edemskim heruvima s plamenim mačem, koji se vijaše i tamo i amo, da čuva put ka drvetu od života. ");
INSERT INTO srp1865_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Iza toga Adam pozna Jevu ženu svoju, a ona zatrudne i rodi Kajina, i reče: Dobih čoveka od Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","I rodi opet brata njegovog Avelja. I Avelj posta pastir a Kajin ratar. ");
INSERT INTO srp1865_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","A posle nekog vremena dogodi se, te Kajin prinese Gospodu prinos od roda zemaljskog; ");
INSERT INTO srp1865_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","a i Avelj prinese od prvina stada svog i od njihove pretiline. I Gospod pogleda na Avelja i na njegov prinos, ");
INSERT INTO srp1865_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","a na Kajina i na njegov prinos ne pogleda. Zato se Kajin rasrdi veoma, i lice mu se promeni. ");
INSERT INTO srp1865_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Tada reče Gospod Kajinu: Što se srdiš? Što li ti se lice promeni? ");
INSERT INTO srp1865_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nećeš li biti mio, kad dobro činiš? A kad ne činiš dobro, greh je na vratima. A volja je njegova pod tvojom vlašću, i ti si mu stariji. ");
INSERT INTO srp1865_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Posle govoraše Kajin s Aveljem bratom svojim. Ali kad behu u polju, skoči Kajin na Avelja brata svog, i ubi ga. ");
INSERT INTO srp1865_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tada reče Gospod Kajinu: Gde ti je brat Avelj? A on odgovori: Ne znam; zar sam ja čuvar brata svog? ");
INSERT INTO srp1865_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","A Bog reče: Šta učini! Glas krvi brata tvog viče sa zemlje k meni. ");
INSERT INTO srp1865_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","I sada, da si proklet na zemlji, koja je otvorila usta svoja da primi krv brata tvog iz ruke tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kad zemlju uzradiš, neće ti više davati blaga svog. Bićeš potukač i begunac na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","A Kajin reče Gospodu: Krivica je moja velika da mi se ne može oprostiti. ");
INSERT INTO srp1865_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Evo me teraš danas iz ove zemlje da se krijem ispred Tebe, i da se skitam i potucam po zemlji, pa će me ubiti ko me udesi. ");
INSERT INTO srp1865_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","A Gospod mu reče: Zato ko ubije Kajina, sedam će se puta to pokajati. I načini Gospod znak na Kajinu da ga ne ubije ko ga udesi. ");
INSERT INTO srp1865_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","I otide Kajin ispred Gospoda, i naseli se u zemlji naidskoj na istoku prema Edemu. ");
INSERT INTO srp1865_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","I pozna Kajin ženu svoju, a ona zatrudne i rodi Enoha. I sazida grad i prozva ga po imenu sina svog Enoh. ");
INSERT INTO srp1865_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","A Enohu rodi se Gaidad; a Gaidad rodi Maleleila; a Maleleilo rodi Matusala; a Matusal rodi Lameha. ");
INSERT INTO srp1865_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","I uze Lameh dve žene: jednoj beše ime Ada a drugoj Sela. ");
INSERT INTO srp1865_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","I Ada rodi Jovila; od njega se narodiše koji žive pod šatorima i stoku pasu. ");
INSERT INTO srp1865_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","A bratu njegovom beše ime Juval; od njega se narodiše gudači i svirači. ");
INSERT INTO srp1865_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","A i Sela rodi Tovela, koji beše vešt kovati svašta od bronze i od gvožđa; a sestra Tovelu beše Noema. ");
INSERT INTO srp1865_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","I reče Lameh svojim ženama, Adi i Seli: Čujte glas moj, žene Lamehove, poslušajte reči moje: ubiću čoveka za ranu svoju i mladića za masnicu svoju. ");
INSERT INTO srp1865_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kad će se Kajin osvetiti sedam puta, Lameh će sedamdeset i sedam puta. ");
INSERT INTO srp1865_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","A Adam opet pozna ženu svoju, i ona rodi sina, i nade mu ime Sit, jer mi, reče, Bog dade drugog sina za Avelja, kog ubi Kajin. ");
INSERT INTO srp1865_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","I Situ se rodi sin, kome nadede ime Enos. Tada se poče prizivati ime Gospodnje. ");
INSERT INTO srp1865_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ovo je pleme Adamovo. Kad Bog stvori čoveka po obličju svom stvori ga. ");
INSERT INTO srp1865_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Muško i žensko stvori ih, i blagoslovi ih, i nazva ih čovek, kad biše stvoreni. ");
INSERT INTO srp1865_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","I požive Adam sto trideset godina, i rodi sina po obličju svom, kao što je on, i nadede mu ime Sit. ");
INSERT INTO srp1865_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","A rodiv Sita požive Adam osam stotina godina, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","tako požive Adam svega devet stotina trideset godina; i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","A Sit požive sto pet godina, i rodi Enosa; ");
INSERT INTO srp1865_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","a rodiv Enosa požive Sit osam stotina sedam godina, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","tako požive Sit svega devet stotina dvanaest godina; i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","A Enos požive devedeset godina, i rodi Kajinana; ");
INSERT INTO srp1865_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","a rodiv Kajinana požive Enos osam stotina petnaest godina, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","tako požive Enos svega devet stotina pet godina; i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","A Kajinan požive sedamdeset godina, i rodi Maleleila; ");
INSERT INTO srp1865_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","a rodiv Maleleila požive Kajinan osam stotina i četrdeset godina, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","tako požive Kajinan svega devet stotina deset godina; i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","A Maleleilo požive šezdeset pet godina, i rodi Jareda; ");
INSERT INTO srp1865_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","a rodiv Jareda požive Maleleilo osam stotina trideset godina, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","tako požive Maleleilo svega osam stotina devedeset pet godina; i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","A Jared požive sto i šezdeset i dve godine, i rodi Enoha; ");
INSERT INTO srp1865_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","a rodiv Enoha požive Jared osam stotina godina, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","tako požive Jared svega devet stotina šezdeset dve godine, i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","A Enoh požive šezdeset pet godina, i rodi Matusala; ");
INSERT INTO srp1865_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","a rodiv Matusala požive Enoh jednako po volji Božjoj trista godina, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","tako požive Enoh svega trista šezdeset pet godina; ");
INSERT INTO srp1865_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","i živeći Enoh jednako po volji Božjoj, nestade ga jer ga uze Bog. ");
INSERT INTO srp1865_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","A Matusal požive sto osamdeset sedam godina, i rodi Lameha; ");
INSERT INTO srp1865_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","a rodiv Lameha požive Matusal sedam stotina osamdeset dve godine, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","tako požive Matusal svega devet stotina i šezdeset i devet godina; i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","A Lameh požive sto osamdeset i dve godine, i rodi sina, ");
INSERT INTO srp1865_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","i nadede mu ime Noje govoreći: Ovaj će nas odmoriti od poslova naših i od truda ruku naših na zemlji, koju prokle Gospod. ");
INSERT INTO srp1865_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","A rodiv Noja požive Lameh pet stotina devedeset pet godina, rađajući sinove i kćeri; ");
INSERT INTO srp1865_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","tako požive Lameh svega sedam stotina sedamdeset sedam godina; i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","A Noju kad bi pet stotina godina, rodi Noje Sima, Hama i Jafeta. ");
INSERT INTO srp1865_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","A kad se ljudi počeše množiti na zemlji, i kćeri im se narodiše. ");
INSERT INTO srp1865_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Videći sinovi Božji kćeri čovečije kako su lepe uzimaše ih za žene koje hteše. ");
INSERT INTO srp1865_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","A Gospod reče: Neće se duh moj do veka preti s ljudima, jer su telo; neka im još sto dvadeset godina. ");
INSERT INTO srp1865_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","A beše tada divova na zemlji; a i posle, kad se sinovi Božji sastajahu sa kćerima čovečijim, pa im one rađahu sinove; to behu silni ljudi, od starine na glasu. ");
INSERT INTO srp1865_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","I Gospod videći da je nevaljalstvo ljudsko veliko na zemlji, i da su sve misli srca njihovog svagda samo zle, ");
INSERT INTO srp1865_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","pokaja se Gospod što je stvorio čoveka na zemlji, i bi mu žao u srcu. ");
INSERT INTO srp1865_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","I reče Gospod: Hoću da istrebim sa zemlje ljude, koje sam stvorio, od čoveka do stoke i do sitne životinje i do ptica nebeskih; jer se kajem što sam ih stvorio. ");
INSERT INTO srp1865_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ali Noje nađe milost pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ovo su događaji Nojevi: Noje beše čovek pravedan i bezazlen svog veka; po volji Božjoj svagda življaše Noje. ");
INSERT INTO srp1865_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","I rodi Noje tri sina: Sima, Hama i Jafeta. ");
INSERT INTO srp1865_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","A zemlja se pokvari pred Bogom, i napuni se zemlja bezakonja. ");
INSERT INTO srp1865_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","I pogleda Bog na zemlju, a ona beše pokvarena; jer svako telo pokvari put svoj na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","I reče Bog Noju: Kraj svakom telu dođe preda me, jer napuniše zemlju bezakonja; i evo hoću da ih zatrem sa zemljom. ");
INSERT INTO srp1865_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Načini sebi kovčeg od drveta gofera, i načini pregratke u kovčegu; i zatopi ga smolom iznutra i spolja. ");
INSERT INTO srp1865_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","I načini ga ovako; u dužinu neka bude trista lakata, u širinu pedeset lakata, i u visinu trideset lakata; ");
INSERT INTO srp1865_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","pusti dosta svetlosti u kovčeg; i krov mu svedi ozgo od lakta; i udari vrata kovčegu sa strane; i načini ga na tri boja: donji, drugi i treći. ");
INSERT INTO srp1865_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Jer evo pustiću potop na zemlju da istrebim svako telo u kome ima živa duša pod nebom; šta je god na zemlji sve će izginuti. ");
INSERT INTO srp1865_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ali ću s tobom učiniti zavet svoj: i ući ćeš u kovčeg ti i sinovi tvoji i žena tvoja i žene sinova tvojih s tobom. ");
INSERT INTO srp1865_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","I od svega živog, od svakog tela, uzećeš u kovčeg po dvoje, da sačuvaš u životu sa sobom, a muško i žensko neka bude. ");
INSERT INTO srp1865_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Od ptica po vrstama njihovim, od stoke po vrstama njenim, i od svega što se miče na zemlji po vrstama njegovim, od svega po dvoje neka uđe s tobom, da ih sačuvaš u životu. ");
INSERT INTO srp1865_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","I uzmi sa sobom svega što se jede, i čuvaj kod sebe, da bude hrane tebi i njima. ");
INSERT INTO srp1865_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","I Noje učini, kako mu zapovedi Bog, sve onako učini. ");
INSERT INTO srp1865_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","I reče Gospod Noju: Uđi u kovčeg ti i sav dom tvoj; jer te nađoh pravedna pred sobom ovog veka. ");
INSERT INTO srp1865_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Uzmi sa sobom od svih životinja čistih po sedmoro, sve mužjaka i ženku njegovu; a od životinja nečistih po dvoje, mužjaka i ženku njegovu, ");
INSERT INTO srp1865_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","takođe i od ptica nebeskih po sedam, mužjaka i ženku njegovu, da im se sačuva seme na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Jer ću do sedam dana pustiti dažd na zemlju za četrdeset dana i četrdeset noći, i istrebiću sa zemlje svako telo živo, koje sam stvorio. ");
INSERT INTO srp1865_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","I Noje učini sve što mu zapovedi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","A beše Noju šest stotina godina kad dođe potop na zemlju. ");
INSERT INTO srp1865_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","I uđe Noje u kovčeg i sinovi njegovi i žena njegova i žene sinova njegovih s njim radi potopa. ");
INSERT INTO srp1865_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Od životinja čistih i od životinja nečistih i od ptica i od svega što se miče po zemlji, ");
INSERT INTO srp1865_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","uđe k Noju u kovčeg po dvoje, muško i žensko, kao što beše Bog zapovedio Noju. ");
INSERT INTO srp1865_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","A u sedmi dan dođe potop na zemlju. ");
INSERT INTO srp1865_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Kad je bilo Noju šest stotina godina, te godine drugog meseca, sedamnaesti dan toga meseca, taj dan razvališe se svi izvori velikog bezdana, i otvoriše se ustave nebeske; ");
INSERT INTO srp1865_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","i udari dažd na zemlju za četrdeset dana i četrdeset noći. ");
INSERT INTO srp1865_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Taj dan uđe u kovčeg Noje i Sim i Ham i Jafet, sinovi Nojevi, i žena Nojeva i tri žene sinova njegovih s njima; ");
INSERT INTO srp1865_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","oni, i svakojake zveri po vrstama svojim, i svakojaka stoka po vrstama svojim, i šta se god miče po zemlji po vrstama svojim, i ptice sve po vrstama svojim, i šta god leti i ima krila, ");
INSERT INTO srp1865_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","dođe k Noju u kovčeg po dvoje od svakog tela, u kome ima živa duša, ");
INSERT INTO srp1865_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","muško i žensko od svakog tela uđoše, kao što beše Bog zapovedio Noju; pa Gospod zatvori za njim. ");
INSERT INTO srp1865_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","I bi potop na zemlji za četrdeset dana; i voda dođe i uze kovčeg, i podiže ga od zemlje. ");
INSERT INTO srp1865_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","I navali voda, i usta jako po zemlji, i kovčeg stade ploviti vodom. ");
INSERT INTO srp1865_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","I navaljivaše voda sve većma po zemlji, i pokri sva najviša brda što su pod celim nebom. ");
INSERT INTO srp1865_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Petnaest lakata dođe voda iznad brda, pošto ih pokri. ");
INSERT INTO srp1865_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tada izgibe svako telo što se micaše na zemlji, ptice i stoka, i zveri i sve što gamiže po zemlji, i svi ljudi. ");
INSERT INTO srp1865_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Sve što imaše dušu živu u nosu, sve što beše na suvom, pomre. ");
INSERT INTO srp1865_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","I istrebi se svako telo živo na zemlji, i ljudi i stoka i šta god gamiže i ptice nebeske, sve, velim, istrebi se sa zemlje; samo Noje osta i šta s njim beše u kovčegu. ");
INSERT INTO srp1865_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","I stajaše voda povrh zemlje sto pedeset dana. ");
INSERT INTO srp1865_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","A Bog se opomenu Noja i svih zveri i sve stoke što behu s njim u kovčegu; i posla Bog vetar na zemlju da uzbije vodu. ");
INSERT INTO srp1865_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","I zatvoriše se izvori bezdanu i ustave nebeske, i dažd s neba prestade. ");
INSERT INTO srp1865_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","I stade voda opadati na zemlji, i jednako opadaše posle sto pedeset dana; ");
INSERT INTO srp1865_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","te se ustavi kovčeg sedmog meseca dana sedamnaestog na planini Araratu. ");
INSERT INTO srp1865_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","I voda opadaše sve većma do desetog meseca; i prvog dana desetog meseca pokazaše se vrhovi od brda. ");
INSERT INTO srp1865_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","A posle četrdeset dana otvori Noje prozor na kovčegu, koji beše načinio; ");
INSERT INTO srp1865_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","i ispusti gavrana, koji jednako odletaše i doletaše dokle ne presahnu voda na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Pa pusti i golubicu da bi video je li opala voda sa zemlje. ");
INSERT INTO srp1865_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","A golubica ne našavši gde bi stala nogom svojom vrati se k njemu u kovčeg, jer još beše voda po svoj zemlji; i Noje pruživši ruku uhvati je i uze k sebi u kovčeg. ");
INSERT INTO srp1865_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","I počeka još sedam dana, po opet ispusti golubicu iz kovčega. ");
INSERT INTO srp1865_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","I pred veče vrati se k njemu golubica, i gle, u kljunu joj list maslinov, koji beše otkinula; tako pozna Noje da je opala voda sa zemlje. ");
INSERT INTO srp1865_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ali počeka još sedam dana, pa opet ispusti golubicu, a ona mu se više ne vrati. ");
INSERT INTO srp1865_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Šest stotina prve godine veka Nojevog prvi dan prvog meseca usahnu voda na zemlji; i Noje otkri krov na kovčegu, i ugleda zemlju suvu. ");
INSERT INTO srp1865_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A drugog meseca dvadeset sedmog dana beše sva zemlja suva. ");
INSERT INTO srp1865_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tada reče Bog Noju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Izađi iz kovčega ti i žena tvoja i sinovi tvoji i žene sinova tvojih s tobom; ");
INSERT INTO srp1865_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","sve zveri što su sa tobom od svakog tela, ptice i stoku i šta god gamiže po zemlji, izvedi sa sobom, neka se raziđu po zemlji, i neka se plode i množe na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","I iziđe Noje i sinovi njegovi i žena njegova i žene sinova njegovih s njim. ");
INSERT INTO srp1865_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sve zveri, sve sitne životinje, sve ptice i sve što se miče po zemlji po svojim vrstama iziđoše iz kovčega. ");
INSERT INTO srp1865_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","I načini Noje žrtvenik Gospodu, i uze od svake čiste stoke i od svih ptica čistih, i prinese na žrtveniku žrtve paljenice. ");
INSERT INTO srp1865_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","I Gospod omirisa miris ugodni, i reče u srcu svom: Neću više kleti zemlje s ljudi, što je misao srca čovečijeg zla od malena; niti ću više ubijati sve što živi, kao što učinih. ");
INSERT INTO srp1865_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Od sada dokle bude zemlje, neće nestajati setve ni žetve, studeni ni vrućine, leta ni zime, dana ni noći. ");
INSERT INTO srp1865_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","I Bog blagoslovi Noja i sinove njegove, i reče im: Rađajte se i množite se i napunite zemlju; ");
INSERT INTO srp1865_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","i sve zveri zemaljske i sve ptice nebeske i sve što ide po zemlji i sve ribe morske neka vas se boje i straše; sve je predano u vaše ruke. ");
INSERT INTO srp1865_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Šta se god miče i živi, neka vam bude za jelo, sve vam to dadoh kao zelenu travu. ");
INSERT INTO srp1865_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ali ne jedite mesa s dušom njegovom, a to mu je krv. ");
INSERT INTO srp1865_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Jer ću i vašu krv, duše vaše, iskati; od svake ću je zveri iskati; iz ruke samog čoveka, iz ruke svakog brata njegovog iskaću dušu čovečiju. ");
INSERT INTO srp1865_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ko prolije krv čovečiju, njegovu će krv proliti čovek; jer je Bog po svom obličju stvorio čoveka. ");
INSERT INTO srp1865_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Rađajte se dakle i množite se; narodite se veoma na zemlji i namnožite se na njoj. ");
INSERT INTO srp1865_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","I reče Bog Noju i sinovima njegovim s njim, govoreći: ");
INSERT INTO srp1865_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","A ja evo postavljam zavet svoj s vama i s vašim semenom nakon vas, ");
INSERT INTO srp1865_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","i sa svim životinjama, što su s vama od ptica, od stoke i od svih zveri zemaljskih što su s vama, sa svačim što je izašlo iz kovčega, i sa svim zverima zemaljskim. ");
INSERT INTO srp1865_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Postavljam zavet svoj s vama, te odsele neće nijedno telo poginuti od potopa, niti će više biti potopa da zatre zemlju. ");
INSERT INTO srp1865_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","I reče Bog: Evo znak zaveta koji postavljam između sebe i vas i svake žive tvari, koja je s vama do veka: ");
INSERT INTO srp1865_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Metnuo sam dugu svoju u oblake, da bude znak zaveta između mene i zemlje. ");
INSERT INTO srp1865_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Pa kad oblake navučem na zemlju, videće se duga u oblacima, ");
INSERT INTO srp1865_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","i opomenuću se zaveta svog koji je između mene i vas i svake duše žive u svakom telu, i neće više biti od vode potopa da zatre svako telo. ");
INSERT INTO srp1865_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Duga će biti u oblacima, pa ću je pogledati, i opomenuću se večnog zaveta između Boga i svake duše žive u svakom telu koje je na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","I reče Bog Noju: To je znak zaveta koji sam učinio između sebe i svakog tela na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","A behu sinovi Nojevi koji izađoše iz kovčega: Sim i Ham i Jafet; a Ham je otac Hanancima. ");
INSERT INTO srp1865_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","To su tri sina Nojeva, i od njih se naseli sva zemlja. ");
INSERT INTO srp1865_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","A Noje poče raditi zemlju, i posadi vinograd. ");
INSERT INTO srp1865_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","I napiv se vina opi se, i otkri se nasred šatora svog. ");
INSERT INTO srp1865_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","A Ham, otac Hanancima, vide golotinju oca svog, i kaza obojici braće svoje na polju. ");
INSERT INTO srp1865_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","A Sim i Jafet uzeše haljinu, i ogrnuše je obojica na ramena svoja, i idući natraške pokriše njom golotinju oca svog, licem natrag okrenuvši se da ne vide golotinje oca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","A kad se Noje probudi od vina, dozna šta mu je učinio mlađi sin, ");
INSERT INTO srp1865_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","i reče: Proklet da je Hanan, i da bude sluga slugama braće svoje! ");
INSERT INTO srp1865_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","I još reče: Blagosloven da je Gospod Bog Simov, i Hanan da mu bude sluga! ");
INSERT INTO srp1865_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Bog da raširi Jafeta da živi u šatorima Simovim, a Hanan da im bude sluga! ");
INSERT INTO srp1865_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","I požive Noje posle potopa trista pedeset godina. ");
INSERT INTO srp1865_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","A svega požive Noje devet stotina pedeset godina; i umre. ");
INSERT INTO srp1865_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","A ovo su plemena sinova Nojevih, Sima, Hama i Jafeta, kojima se rodiše sinovi posle potopa. ");
INSERT INTO srp1865_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Sinovi Jafetovi: Gomer i Magog i Madaj i Javan i Tovel i Meseh i Tiras. ");
INSERT INTO srp1865_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","A sinovi Gomerovi: Ashenas i Rifat i Togarma. ");
INSERT INTO srp1865_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","A sinovi Javanovi: Elisa i Tarsis, Kitim i Dodanim. ");
INSERT INTO srp1865_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Od njih se razdeliše ostrva narodna na zemljama svojim, svako po jeziku svom i po porodicama svojim, u narodima svojim. ");
INSERT INTO srp1865_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","A sinovi Hamovi: Hus i Mesrain, Fud i Hanan. ");
INSERT INTO srp1865_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","A sinovi Husovi: Sava i Avila i Savata i Regma i Savataka. A sinovi Regmini: Sava i Dedan. ");
INSERT INTO srp1865_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Hus rodi i Nevroda; a on prvi bi silan na zemlji; ");
INSERT INTO srp1865_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","beše dobar lovac pred Gospodom; zato se kaže: Dobar lovac pred Gospodom kao Nevrod. ");
INSERT INTO srp1865_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","A početak carstvu njegovom beše Vavilon i Oreh i Arhad i Halani u zemlji Senaru. ");
INSERT INTO srp1865_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Iz te zemlje izađe Asur, i sazida Nineviju i Rovot grad i Halah, ");
INSERT INTO srp1865_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","i Dasem između Ninevije i Halaha; to je grad velik. ");
INSERT INTO srp1865_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","A Mesrain rodi Ludeje i Enemeje i Laveje i Neftaleje, ");
INSERT INTO srp1865_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","i Patroseje i Hasmeje, odakle izađoše Filisteji i Gaftoreji. ");
INSERT INTO srp1865_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","A Hanan rodi Sidona, prvenca svog, i Heta, ");
INSERT INTO srp1865_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","i Jevuseja i Amoreja i Gergeseja, ");
INSERT INTO srp1865_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","i Eveja i Arukeja i Aseneja, ");
INSERT INTO srp1865_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","i Arvadeja i Samareja i Amateja. A posle se rasejaše plemena hananejska. ");
INSERT INTO srp1865_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","I behu međe hananejske od Sidona idući na Gerar pa do Gaze, i idući na Sodom i Gomor i Adamu i Sevojim pa do Dasa. ");
INSERT INTO srp1865_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","To su sinovi Hamovi po porodicama svojim i po jezicima svojim, u zemljama svojim i u narodima svojim. ");
INSERT INTO srp1865_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","I Simu rodiše se sinovi, najstarijem bratu Jafetovom, ocu svih sinova Everovih. ");
INSERT INTO srp1865_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sinovi Simovi behu: Elam i Asur i Arfaksad i Lud i Aram. ");
INSERT INTO srp1865_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","A sinovi Aramovi: Uz i Ul i Gater i Mas. ");
INSERT INTO srp1865_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","A Arfaksad rodi Salu, a Sala rodi Evera. ");
INSERT INTO srp1865_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","A Everu se rodiše dva sina: jednom beše ime Falek, jer se u njegovo vreme razdeli zemlja, a bratu njegovom ime Jektan. ");
INSERT INTO srp1865_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","A Jektan rodi Elmodada i Saleta i Sarmota i Jaraha, ");
INSERT INTO srp1865_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","i Odora i Evila i Deklu, ");
INSERT INTO srp1865_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","i Evala i Avimaila i Savu, ");
INSERT INTO srp1865_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","i Ufira i Evilu i Jovava; ti svi behu sinovi Jektanovi. ");
INSERT INTO srp1865_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","I življahu od Mase, kako se ide na Safir do gora istočnih. ");
INSERT INTO srp1865_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","To su sinovi Simovi po porodicama svojim i po jezicima svojim, u zemljama svojim i u narodima svojim. ");
INSERT INTO srp1865_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","To su porodice sinova Nojevih po plemenima svojim, u narodima svojim; i od njih se razdeliše narodi po zemlji posle potopa. ");
INSERT INTO srp1865_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","A beše na celoj zemlji jedan jezik i jednake reči. ");
INSERT INTO srp1865_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","A kad otidoše od istoka, nađoše ravnicu u zemlji senarskoj, i naseliše se onde. ");
INSERT INTO srp1865_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Pa rekoše među sobom: Hajde da pravimo ploče i da ih u vatri pečemo. I behu im opeke mesto kamena i smola zemljana mesto kreča. ");
INSERT INTO srp1865_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Posle rekoše: Hajde da sazidamo grad i kulu, kojoj će vrh biti do neba, da stečemo sebi ime, da se ne bismo rasejali po zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","A Gospod siđe da vidi grad i kulu, što zidahu sinovi čovečiji. ");
INSERT INTO srp1865_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","I reče Gospod: Gle, narod jedan, i jedan jezik u svih, i to počeše raditi, i neće im smetati ništa da ne urade šta su naumili. ");
INSERT INTO srp1865_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hajde da siđemo, i da im pometemo jezik, da ne razumeju jedan drugog šta govore. ");
INSERT INTO srp1865_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tako ih Gospod rasu odande po svoj zemlji, te ne sazidaše grada. ");
INSERT INTO srp1865_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Zato se prozva Vavilon, jer onde pomete Gospod jezik cele zemlje, i odande ih rasu Gospod po svoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ovo je pleme Simovo: beše Simu sto godina, kad rodi Arfaksada, druge godine posle potopa. ");
INSERT INTO srp1865_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","A rodiv Arfaksada požive Sim pet stotina godina, rađajući sinove i kćeri. ");
INSERT INTO srp1865_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","A Arfaksad požive trideset i pet godina, i rodi Salu; ");
INSERT INTO srp1865_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","a rodiv Salu požive Arfaksad četiri stotine i tri godine, rađajući sinove i kćeri. ");
INSERT INTO srp1865_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","A Sala požive trideset godina, i rodi Evera; ");
INSERT INTO srp1865_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","a rodiv Evera požive Sala četiri stotine i tri godine, rađajući sinove i kćeri. ");
INSERT INTO srp1865_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","A Ever požive trideset i četiri godine, i rodi Faleka; ");
INSERT INTO srp1865_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","a rodiv Faleka požive Ever četiri stotine i trideset godina, rađajući sinove i kćeri. ");
INSERT INTO srp1865_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","A Falek požive trideset godina, i rodi Ragava; ");
INSERT INTO srp1865_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","a rodiv Ragava požive Falek dvesta i devet godina, rađajući sinove i kćeri. ");
INSERT INTO srp1865_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","A Ragav požive trideset i dve godine, i rodi Seruha; ");
INSERT INTO srp1865_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","a rodiv Seruha požive Ragav dvesta i sedam godina, rađajući sinove i kćeri. ");
INSERT INTO srp1865_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","A Seruh požive trideset godina, i rodi Nahora; ");
INSERT INTO srp1865_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","a rodiv Nahora požive Seruh dvesta godina, rađajući sinove i kćeri. ");
INSERT INTO srp1865_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","A Nahor požive dvadeset i devet godina, i rodi Taru; ");
INSERT INTO srp1865_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","a rodiv Taru požive Nahor sto i devetnaest godina, rađajući sinove i kćeri. ");
INSERT INTO srp1865_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","A Tara požive sedamdeset godina, i rodi Avrama, Nahora i Arana. ");
INSERT INTO srp1865_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","A ovo je pleme Tarino: Tara rodi Avrama, Nahora i Arana; a Aran rodi Lota. ");
INSERT INTO srp1865_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","I umre Aran pre Tare oca svog na postojbini svojoj, u Uru haldejskom. ");
INSERT INTO srp1865_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","I oženi se Avram i Nahor, i ženi Avramovoj beše ime Sara a ženi Nahorovoj ime Melha, kći Arama oca Melhe i Jeshe. ");
INSERT INTO srp1865_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","A Sara beše nerotkinja, i ne imaše poroda. ");
INSERT INTO srp1865_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","I uze Tara sina svog Avrama i Lota sina Aronovog, unuka svog, i Saru snahu svoju, ženu Avrama sina svog; i pođoše zajedno iz Ura haldejskog da idu u zemlju hanansku, i dođoše do Harana, i onde se nastaniše. ");
INSERT INTO srp1865_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","I požive Tara svega dvesta i pet godina; i umre Tara u Haranu. ");
INSERT INTO srp1865_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","I reče Gospod Avramu: Idi iz zemlje svoje i od roda svog i iz doma oca svog u zemlju koju ću ti ja pokazati. ");
INSERT INTO srp1865_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I učiniću od tebe velik narod, i blagosloviću te, i ime tvoje proslaviću, i ti ćeš biti blagoslov. ");
INSERT INTO srp1865_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Blagosloviću one koji tebe uzblagosiljaju, i prokleću one koji tebe usproklinju; i u tebi će biti blagoslovena sva plemena na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tada pođe Avram, kao što mu kaza Gospod, i s njim pođe Lot. A beše Avramu sedamdeset i pet godina kad pođe iz Harana. ");
INSERT INTO srp1865_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","I uze Avram Saru ženu svoju i Lota sina brata svog sa svim blagom koje behu stekli i s dušama koje behu dobili u Haranu; i pođoše u zemlju hanansku, i dođoše u nju. ");
INSERT INTO srp1865_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","I pođe Avram tu zemlju do mesta Sihema i do ravnice moreške; a behu tada Hananeji u toj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","I javi se Gospod Avramu i reče: Tvom semenu daću zemlju ovu. I Avram načini onde žrtvenik Gospodu, koji mu se javio. ");
INSERT INTO srp1865_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Posle otide odande na brdo, koje je prema istoku od Vetilja, i onde razape šator svoj, te mu Vetilj beše sa zapada a Gaj s istoka; i onde načini Gospodu žrtvenik, i prizva ime Gospodnje. ");
INSERT INTO srp1865_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Odande otide Avram dalje idući na jug. ");
INSERT INTO srp1865_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ali nasta glad u onoj zemlji, te Avram siđe u Misir da se onde skloni; jer glad beše velika u onoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","A kad se približi da već uđe u Misir, reče Sari ženi svojoj: Gle, znam da si žena lepa u licu. ");
INSERT INTO srp1865_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Zato kad te vide Misirci reći će: Ovo mu je žena. Pa će me ubiti, a tebe će ostaviti u životu. ");
INSERT INTO srp1865_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nego hajde kaži da si mi sestra, te će meni biti dobro tebe radi i ostaću u životu uz tebe. ");
INSERT INTO srp1865_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","I kad dođe Avram u Misir, videše Misirci ženu da je vrlo lepa. ");
INSERT INTO srp1865_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","I videše je knezovi Faraonovi, i hvališe je pred Faraonom. I uzeše je u dvor Faraonov. ");
INSERT INTO srp1865_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","I on činjaše dobro Avramu nje radi, te imaše ovaca i goveda i magaraca i sluga i sluškinja i magarica i kamila. ");
INSERT INTO srp1865_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ali Gospod pusti velika zla na Faraona i na dom njegov radi Sare žene Avramove. ");
INSERT INTO srp1865_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Tada dozva Faraon Avrama i reče mu: Šta mi to učini? Zašto mi nisi kazao da ti je žena? ");
INSERT INTO srp1865_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Zašto si kazao: Sestra mi je? Te je uzeh za ženu. Sad eto ti žene, uzmi je, pa idi. ");
INSERT INTO srp1865_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","I Faraon zapovedi ljudima za nj, te ga ispratiše i ženu njegovu i šta god imaše. ");
INSERT INTO srp1865_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Tako otide Avram iz Misira gore na jug, on i žena mu i sve što imaše, takođe i Lot s njim. ");
INSERT INTO srp1865_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","A beše Avram vrlo bogat stokom, srebrom i zlatom. ");
INSERT INTO srp1865_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","I iđaše svojim putevima od juga sve do Vetilja, do mesta gde mu prvo beše šator, između Vetilja i Gaja, ");
INSERT INTO srp1865_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","do mesta, gde pre beše načinio žrtvenik; i onde prizva Avram ime Gospodnje. ");
INSERT INTO srp1865_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","A i Lot koji iđaše s Avramom imaše ovaca i goveda i šatora. ");
INSERT INTO srp1865_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","I zemlja ne mogaše ih nositi zajedno, jer blago njihovo beše veliko da ne mogoše živeti zajedno, ");
INSERT INTO srp1865_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","i beše svađa među pastirima Avramove stoke i pastirima Lotove stoke. A u to vreme živehu Hananeji i Ferezeji u onoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Pa Avram reče Lotu: Nemoj da se svađamo ja i ti, ni moji pastiri i tvoji pastiri; jer smo braća. ");
INSERT INTO srp1865_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nije li ti otvorena cela zemlja? Odeli se od mene. Ako ćeš ti na levo, ja ću na desno; ako li ćeš ti na desno ja ću na levo. ");
INSERT INTO srp1865_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tada Lot podiže oči svoje i sagleda svu ravnicu jordansku, kako celu natapaše reka, beše kao vrt Gospodnji, kao zemlja misirska, sve do Zagora, pre nego Gospod zatre Sodom i Gomor. ");
INSERT INTO srp1865_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","I Lot izabra sebi svu ravnicu jordansku, i otide Lot na istok; i razdeliše se jedan od drugog: ");
INSERT INTO srp1865_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Avram življaše u zemlji hananskoj, a Lot življaše po gradovima u onoj ravnici premeštajući svoje šatore do Sodoma. ");
INSERT INTO srp1865_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","A ljudi u Sodomu behu nevaljali, i grešahu Gospodu veoma. ");
INSERT INTO srp1865_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","A Gospod reče Avramu, pošto se Lot odeli od njega: Podigni sada oči svoje, pa pogledaj s mesta gde si na sever i na jug i na istok i na zapad. ");
INSERT INTO srp1865_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Jer svu zemlju što vidiš tebi ću dati i semenu tvom do veka. ");
INSERT INTO srp1865_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I učiniću da semena tvog bude kao praha na zemlji; ako ko uzmože izbrojati prah na zemlji, moći će izbrojati i seme tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ustani, i prolazi tu zemlju u dužinu i u širinu; jer ću je tebi dati. ");
INSERT INTO srp1865_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","I Avram diže šatore, i dođe i naseli se u ravnici mamrijskoj, koja je kod Hevrona, i onde načini žrtvenik Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","A kad beše Amarfal car senarski, Arion car elasarski, Hodologomor car elamski i Targal car gojimski, ");
INSERT INTO srp1865_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","zavojevaše na Valu cara sodomskog, i na Varsu cara gomorskog, i na Senara cara adamskog, i na Simovora cara sevojimskog i na cara od Valake, koja je sada Sigor. ");
INSERT INTO srp1865_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Svi se ovi skupiše u dolini sidimskoj koja je sada slano more. ");
INSERT INTO srp1865_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dvanaest godina behu služili Hodologomoru, pa trinaeste godine odmetnuše se. ");
INSERT INTO srp1865_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A četrnaeste godine dođe Hodologomor i carevi koji behu s njim, i pobiše Rafaje u Astarotu karnajimskom i Zuzeje u Amu i Omeje u polju kirijatajskom, ");
INSERT INTO srp1865_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","i Horeje u planini njihovoj Siru do ravnice faranske pokraj pustinje. ");
INSERT INTO srp1865_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Od tuda vrativši se dođoše u En-Mispat, koji je sada Kadis, i isekoše sve koji živehu u zemlji amaličkoj, i Amoreje koji živehu u Asason-Tamaru. ");
INSERT INTO srp1865_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Tada iziđe car sodomski i car gomorski i car adamski i car sevojimski i car od Valake, koje je sada Sigor, izađoše na njih u dolinu sidimsku, ");
INSERT INTO srp1865_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","na Hodologomora cara elamskog, i na Targala cara gojimskog, i na Amarfala cara senarskog, i na Arioha cara elasarskog, četiri cara na pet. ");
INSERT INTO srp1865_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","A u dolini sidimskoj beše mnogo rupa iz kojih se vadila smola; i pobeže car sodomski i car gomorski, i onde padoše, a šta osta pobeže u planinu. ");
INSERT INTO srp1865_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","I uzeše sve blago u Sodomu i Gomoru i svu hranu njihovu, i otidoše. ");
INSERT INTO srp1865_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Uzeše i Lota, sinovca Avramovog, i blago njegovo, i otidoše, jer živeše u Sodomu. ");
INSERT INTO srp1865_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","A dođe jedan koji beše utekao, te javi Avramu Jevrejinu, koji živeše u ravni Mamrija Amorejina, brata Esholu i brata Avnanu, koji behu u veri s Avramom. ");
INSERT INTO srp1865_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","A kad Avram ču da mu se zarobio sinovac, naoruža sluge svoje, trista osamnaest, koji se rodiše u njegovoj kući, i pođe u poteru do Dana. ");
INSERT INTO srp1865_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Onde razdelivši svoje udari na njih noću sa slugama svojim, i razbi ih, i otera ih do Hovala, koji je na levo od Damaska, ");
INSERT INTO srp1865_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","i povrati sve blago; povrati i Lota sinovca svog s blagom njegovim, i žene i ljude. ");
INSERT INTO srp1865_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","A car sodomski iziđe mu na susret kad se vrati razbivši Hodologomora i careve što behu s njim, u dolinu Savinu, koje je sada dolina careva. ");
INSERT INTO srp1865_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","A Melhisedek car salimski iznese hleb i vino; a on beše sveštenik Boga Višnjeg. ");
INSERT INTO srp1865_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","I blagoslovi ga govoreći: Blagosloven da je Avram Bogu Višnjem, čije je nebo i zemlja! ");
INSERT INTO srp1865_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","I blagosloven da je Bog Višnji, koji predade neprijatelje tvoje u ruke tvoje! I dade mu Avram desetak od svega. ");
INSERT INTO srp1865_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","A car sodomski reče Avramu: Daj meni ljude, a blago uzmi sebi. ");
INSERT INTO srp1865_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","A Avram reče caru sodomskom: Dižem ruku svoju ka Gospodu Bogu Višnjem, čije je nebo i zemlja, zaklinjući se: ");
INSERT INTO srp1865_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ni konca ni remena od obuće neću uzeti od svega što je tvoje, da ne kažeš: Ja sam obogatio Avrama; ");
INSERT INTO srp1865_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","osim što su pojeli momci, i osim dela ljudima koji su išli sa mnom, Esholu, Avnanu i Mamriju, oni neka uzmu svoj deo. ");
INSERT INTO srp1865_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Posle ovih stvari dođe Avramu reč Gospodnja u utvari govoreći: Ne boj se, Avrame, ja sam ti štit, i plata je tvoja vrlo velika. ");
INSERT INTO srp1865_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","A Avram reče Gospode, Gospode, šta ćeš mi dati kad živim bez dece, a pa kome će ostati moja kuća to je Elijezer ovaj Damaštanin? ");
INSERT INTO srp1865_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Još reče Avram: Eto meni nisi dao poroda, pa će sluga rođen u kući mojoj biti moj naslednik. ");
INSERT INTO srp1865_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","A gle, Gospod mu progovori: Neće taj biti naslednik tvoj, nego koji će izaći od tebe taj će ti biti naslednik. ");
INSERT INTO srp1865_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Pa ga izvede napolje i reče mu: Pogledaj na nebo i prebroj zvezde, ako ih možeš prebrojati. I reče mu: Tako će ti biti seme tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","I poverova Avram Bogu, a On mu primi to u pravdu. ");
INSERT INTO srp1865_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","I reče mu: Ja sam Gospod, koji te izvedoh iz Ura haldejskog da ti dam zemlju ovu da bude tvoja. ");
INSERT INTO srp1865_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","A on reče: Gospode, Gospode, po čemu ću poznati da će biti moja? ");
INSERT INTO srp1865_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","I reče mu: Prinesi mi junicu od tri godine i kozu od tri godine i ovna od tri godine i grlicu i golupče. ");
INSERT INTO srp1865_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","I on uze sve to, i raseče na pole, i metnu sve pole jednu prema drugoj; ali ne raseče ptice. ");
INSERT INTO srp1865_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","A ptice sletahu na te mrtve životinje; a Avram ih odgoniše. ");
INSERT INTO srp1865_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","A kad sunce beše na zalasku, uhvati Avrama tvrd san, i gle, strah i mrak velik obuze ga. ");
INSERT INTO srp1865_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","I Gospod reče Avramu: Znaj zacelo da će seme tvoje biti došljaci u zemlji tuđoj, pa će joj služiti, i ona će ih mučiti četiri stotine godina. ");
INSERT INTO srp1865_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ali ću suditi i narodu kome će služiti; a posle će oni izaći s velikim blagom. ");
INSERT INTO srp1865_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","A ti ćeš otići k ocima svojim u miru, i bićeš pogreben u dobroj starosti. ");
INSERT INTO srp1865_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A oni će se u četvrtom kolenu vratiti ovamo; jer gresima amorejskim još nije kraj. ");
INSERT INTO srp1865_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","A kad se sunce smiri i kad se smrče, gle, peć se dimljaše, i plamen ognjeni prolažaše između onih delova. ");
INSERT INTO srp1865_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Taj dan učini Gospod zavet s Avramom govoreći: Semenu tvom dadoh zemlju ovu od vode misirske do velike vode, vode Efrata, ");
INSERT INTO srp1865_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","kenejsku, kenezejsku i kedmonejsku, ");
INSERT INTO srp1865_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","i hetejsku i ferezejsku i rafajsku, ");
INSERT INTO srp1865_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","i amorejsku i hananejsku i gergesejsku i jevusejsku. ");
INSERT INTO srp1865_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ali Sara žena Avramova ne rađaše mu dece. A imaše robinju Misirku, po imenu Agara. ");
INSERT INTO srp1865_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Pa reče Sara Avramu: Gospod me je zatvorio da ne rodim; nego idi k robinji mojoj, ne bih li dobila dece od nje. I Avram prista na reč Sarinu. ");
INSERT INTO srp1865_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","I Sara žena Avramova uze Agaru Misirku robinju svoju, i dade je za ženu Avramu mužu svom posle deset godina otkako se nastani Avram u zemlji hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","I on otide k Agari, i ona zatrudne; a kad vide da je trudna, ponese se od gospođe svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","A Sara reče Avramu: Uvreda moja pade na tebe; ja ti metnuh na krilo robinju svoju, a ona videvši da je trudna ponese se od mene. Gospod će suditi meni i tebi. ");
INSERT INTO srp1865_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","A Avram reče Sari: Eto, robinja je tvoja u tvojim rukama, učini s njom šta ti je volja. I Sara je stade zlostavljati, te ona pobeže od nje. ");
INSERT INTO srp1865_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ali anđeo Gospodnji nađe je kod studenca u pustinji, kod studenca na putu u Sur. ");
INSERT INTO srp1865_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","I reče joj: Agaro, robinjo Sarina, otkud ideš, kuda li ideš? A ona reče: Bežim od Sare gospođe svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","A anđeo joj Gospodnji reče: Vrati se gospođi svojoj, i pokori joj se. ");
INSERT INTO srp1865_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Opet joj reče anđeo Gospodnji: Umnožiću veoma seme tvoje, da se neće moći prebrojati od množine. ");
INSERT INTO srp1865_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Još joj reče anđeo Gospodnji: Eto si trudna, i rodićeš sina, i nadeni mu ime Ismailo; jer je Gospod video muku tvoju. ");
INSERT INTO srp1865_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","A biće čovek ubica; ruka će se njegova dizati na svakog a svačija na njega, i nastavaće na pogledu svoj braći svojoj. ");
INSERT INTO srp1865_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tada Agara prizva ime Gospoda koji govori s njom: Ti si Bog, koji vidi. Jer govoraše: Zar još gledam iza Onog koji me vide? ");
INSERT INTO srp1865_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Toga radi zove se studenac onaj studenac Živoga koji me vidi; a on je između Kadisa i Varada. ");
INSERT INTO srp1865_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","I rodi Agara Avramu sina; i nadede Avram sinu svom, kog mu rodi Agara, ime Ismailo. ");
INSERT INTO srp1865_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","A beše Avramu osamdeset i šest godina kad mu Agara rodi Ismaila. ");
INSERT INTO srp1865_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","A kad Avramu bi devedeset i devet godina, javi mu se Gospod i reče mu: Ja sam Bog Svemogući, po mojoj volji živi, i budi pošten. ");
INSERT INTO srp1865_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","I učiniću zavet između sebe i tebe, i vrlo ću te umnožiti. ");
INSERT INTO srp1865_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","A Avram pade ničice. I Gospod mu još govori i reče: ");
INSERT INTO srp1865_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Od mene evo zavet moj s tobom da ćeš biti otac mnogim narodima. ");
INSERT INTO srp1865_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Zato se više nećeš zvati Avram nego će ti ime biti Avraam, jer sam te učinio ocem mnogih naroda; ");
INSERT INTO srp1865_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","daću ti porodicu vrlo veliku, i načiniću od tebe narode mnoge, i carevi će izaći od tebe. ");
INSERT INTO srp1865_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","A postavljam zavet svoj između sebe i tebe i semena tvog nakon tebe od kolena do kolena, da je zavet večan, da sam Bog tebi i semenu tvom nakon tebe; ");
INSERT INTO srp1865_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","i daću tebi i semenu tvom nakon tebe zemlju u kojoj si došljak, svu zemlju hanansku u državu večnu, i biću im Bog. ");
INSERT INTO srp1865_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","I reče Bog Avramu: Ti pak drži zavet moj, ti i seme tvoje nakon tebe od kolena do kolena. ");
INSERT INTO srp1865_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","A ovo je zavet moj između mene i vas i semena tvog nakon tebe koji ćete držati: da se obrezuju između vas sve muškinje. ");
INSERT INTO srp1865_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","A obrezivaćete okrajak tela svog, da bude znak zaveta između mene i vas. ");
INSERT INTO srp1865_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Svako muško dete kad mu bude osam dana da se obrezuje od kolena do kolena, rodilo se u kući ili bilo kupljeno za novce od kojih god stranaca, koje ne bude od semena tvog. ");
INSERT INTO srp1865_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Da se obrezuje koje se rodi u kući tvojoj i koje se kupi za novce tvoje; tako će biti zavet moj na telu vašem zavet večan. ");
INSERT INTO srp1865_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","A neobrezano muško, kome se ne obreže okrajak tela njegovog, da se istrebi iz naroda svog, jer pokvari zavet moj. ");
INSERT INTO srp1865_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","I još reče Bog Avramu: A Saru ženu svoju ne zovi je više Sara nego neka joj bude ime Saara. ");
INSERT INTO srp1865_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I ja ću je blagosloviti, i daću ti sina od nje; blagosloviću je, i biće mati mnogim narodima, i carevi narodima izaći će od nje. ");
INSERT INTO srp1865_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tada pade Avram ničice i nasmeja se govoreći u srcu svom: Eda će se čoveku od sto godina roditi sin? I Sari? Eda će žena od devedeset godina roditi? ");
INSERT INTO srp1865_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","I Avram reče Bogu: Neka živ bude Ismailo pred Tobom! ");
INSERT INTO srp1865_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","I reče Bog: Zaista Sara žena tvoja rodiće ti sina, i nadećeš mu ime Isak; i postaviću zavet svoj s njim da bude zavet večan semenu njegovom nakon njega. ");
INSERT INTO srp1865_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","A i za Ismaila uslišio sam te; evo blagoslovio sam ga, i daću mu porodicu veliku, i umnožiću ga veoma; i rodiće dvanaest knezova, i načiniću od njega velik narod. ");
INSERT INTO srp1865_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","A zavet svoj učiniću s Isakom kad ti ga rodi Sara, do godine u ovo doba. ");
INSERT INTO srp1865_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","I Bog izgovorivši otide od Avrama gore. ");
INSERT INTO srp1865_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","I Avram uze Ismaila sina svog i sve koji se rodiše u domu njegovom i koje god beše kupio za svoje novce, sve muškinje od domaćih svojih; i obreza okrajak tela njihovog u isti dan, kao što mu kaza Bog. ");
INSERT INTO srp1865_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","A beše Avramu devedeset i devet godina kad obreza okrajak tela svog. ");
INSERT INTO srp1865_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","A Ismailu sinu njegovom beše trinaest godina kad mu se obreza okrajak tela njegovog. ");
INSERT INTO srp1865_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","U jedan dan obreza se Avram i sin mu Ismailo, ");
INSERT INTO srp1865_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","i svi domašnji njegovi, rođeni u kući i kupljeni za novce od stranaca, biše obrezani s njim. ");
INSERT INTO srp1865_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Posle mu se javi Gospod u ravnici mamrijskoj kad seđaše na vratima pred šatorom svojim u podne. ");
INSERT INTO srp1865_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Podigavši oči svoje pogleda, i gle, tri čoveka stajaše prema njemu. I ugledavši ih potrča im u susret ispred vrata šatora svog, i pokloni se do zemlje; ");
INSERT INTO srp1865_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","i reče: Gospode, ako sam našao milost pred Tobom, nemoj proći sluge svog. ");
INSERT INTO srp1865_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Da vam donesem malo vode i operite noge, te se naslonite malo pod ovim drvetom. ");
INSERT INTO srp1865_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","I izneću malo hleba, te potkrepite srce svoje, pa onda pođite, kad idete pored sluge svog. I rekoše: Učini šta si kazao. ");
INSERT INTO srp1865_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","I Avram otrča u šator k Sari, i reče: Brže zamesi tri kopanje belog brašna i ispeci pogače. ");
INSERT INTO srp1865_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Pa otrča ka govedima i uhvati tele mlado i dobro, i dade ga momku da ga brže zgotovi. ");
INSERT INTO srp1865_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Pa onda iznese masla i mleka i tele koje beše zgotovio, i postavi im, a sam stajaše pred njima pod drvetom dokle jeđahu. ");
INSERT INTO srp1865_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","I oni mu rekoše: Gde je Sara žena tvoja? A on reče: Eno je pod šatorom. ");
INSERT INTO srp1865_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","A jedan između njih reče: Dogodine u ovo doba opet ću doći k tebi, a Sara će žena tvoja imati sina. A Sara slušaše na vratima od šatora iza njega. ");
INSERT INTO srp1865_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","A Avram i Sara behu stari i vremeniti, i u Sare beše prestalo šta biva u žena. ");
INSERT INTO srp1865_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Zato se nasmeja Sara u sebi govoreći: Pošto sam ostarela, sad li će mi doći radost? A i gospodar mi je star. ");
INSERT INTO srp1865_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tada reče Gospod Avramu: Što se smeje Sara govoreći: Istina li je da ću roditi kad sam ostarela? ");
INSERT INTO srp1865_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ima li šta teško Gospodu? Dogodine u ovo doba opet ću doći k tebi, a Sara će imati sina. ");
INSERT INTO srp1865_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","A Sara udari u bah govoreći: Nisam se smejala. Jer se uplaši. Ali On reče: Nije istina, nego si se smejala. ");
INSERT INTO srp1865_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Potom ustaše ljudi odande, i pođoše put Sodoma; a Avram pođe s njima da ih isprati. ");
INSERT INTO srp1865_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","A Gospod reče: Kako bih tajio od Avrama šta ću učiniti, ");
INSERT INTO srp1865_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","kad će od Avrama postati velik i silan narod, i u njemu će se blagosloviti svi narodi na zemlji? ");
INSERT INTO srp1865_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Jer znam da će zapovediti sinovima svojim i domu svom nakon sebe da se drže puteva Gospodnjih i da čine što je pravo i dobro, da bi Gospod navršio na Avramu šta mu je obećao. ");
INSERT INTO srp1865_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","I reče Gospod: Vika je u Sodomu i Gomoru velika, i greh je njihov grdan. ");
INSERT INTO srp1865_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Zato ću sići da vidim eda li sve čine kao što vika dođe preda me; ako li nije tako, da znam. ");
INSERT INTO srp1865_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","I ljudi okrenuvši se pođoše put Sodoma; ali Avram još stajaše pred Gospodom, ");
INSERT INTO srp1865_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","i pristupiv Avram reče: Hoćeš li pogubiti i pravednog s nepravednim? ");
INSERT INTO srp1865_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Može biti da ima pedeset pravednika u gradu; hoćeš li i njih pogubiti, i nećeš oprostiti mestu za onih pedeset pravednika što su u njemu? ");
INSERT INTO srp1865_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nemoj to činiti, ni gubiti pravednika s nepravednikom, da bude pravedniku kao i nepravedniku; nemoj; eda li sudija cele zemlje neće suditi pravo? ");
INSERT INTO srp1865_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","I reče Gospod: Ako nađem u Sodomu pedeset pravednika u gradu, oprostiću celom mestu njih radi. ");
INSERT INTO srp1865_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","A Avram odgovori i reče: Gle, sada bih progovorio Gospodu, ako i jesam prah i pepeo. ");
INSERT INTO srp1865_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Može biti pravednika pedeset manje pet, hoćeš li za onih pet potrti sav grad? Odgovori: Neću, ako nađem četrdeset i pet. ");
INSERT INTO srp1865_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","I stade dalje govoriti, i reče: Može biti da će se naći četrdeset. Reče: Neću radi onih četrdeset. ");
INSERT INTO srp1865_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Potom reče: Nemoj se gneviti, Gospode, što ću reći; može biti da će se naći trideset. I reče: Neću, ako nađem trideset. ");
INSERT INTO srp1865_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Opet reče: Gle sada bih progovorio Gospodu; može biti da će se naći dvadeset. Reče: Neću ih pogubiti za onih dvadeset. ");
INSERT INTO srp1865_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Najposle reče: Nemoj se gneviti, Gospode, što ću još jednom progovoriti; može biti da će se naći deset. Reče: Neću ih pogubiti radi onih deset. ");
INSERT INTO srp1865_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","I Gospod otide svršivši razgovor sa Avramom; a Avram se vrati na svoje mesto. ");
INSERT INTO srp1865_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","A uveče dođoše dva anđela u Sodom; a Lot seđaše na vratima sodomskim; i kad ih ugleda, ustade te ih srete, i pokloni se licem do zemlje, ");
INSERT INTO srp1865_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","i reče: Hodite, gospodo, u kuću sluge svog, i prenoćite i operite noge svoje; pa sutra rano kad ustanete pođite svojim putem. A oni rekoše: Ne, nego ćemo prenoćiti na ulici. ");
INSERT INTO srp1865_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ali on navali na njih, te se uvratiše k njemu i uđoše u kuću njegovu, i on ih ugosti, i ispeče hlebova presnih, i jedoše. ");
INSERT INTO srp1865_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","I još ne behu legli, a građani Sodomljani slegoše se oko kuće, staro i mlado, sav narod sa svih krajeva, ");
INSERT INTO srp1865_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","i vikahu Lota i govorahu mu: Gde su ljudi što dođoše sinoć k tebi? Izvedi ih k nama da ih poznamo. ");
INSERT INTO srp1865_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","A Lot iziđe k njima pred vrata zatvorivši vrata za sobom, ");
INSERT INTO srp1865_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","i reče im: Nemojte, braćo, činiti zla. ");
INSERT INTO srp1865_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Evo imam dve kćeri, koje još ne poznaše čoveka; njih ću vam izvesti, pa činite s njima šta vam je volja; samo ne dirajte u ove ljude, jer su zato ušli pod moj krov. ");
INSERT INTO srp1865_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","A oni rekoše: Hodi amo. Pa onda rekoše: Ovaj je sam došao amo da živi kao došljak, pa još hoće da nam sudi; sad ćemo tebi učiniti gore nego njima. Pa navališe jako na čoveka, na Lota, i stadoše istavljati vrata. ");
INSERT INTO srp1865_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","A ona dva čoveka digoše ruke, i uvukoše Lota sebi u kuću, i zatvoriše vrata. ");
INSERT INTO srp1865_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","A ljude što behu pred vratima kućnim ujedanput oslepiše od najmanjeg do najvećeg, te ne mogahu naći vrata. ");
INSERT INTO srp1865_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Tada ona dva čoveka rekoše Lotu: Ako imaš ovde još koga svog, ili zeta ili sina ili kćer, ili koga god svog u ovom gradu, gledaj nek idu odavde; ");
INSERT INTO srp1865_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","jer hoćemo da zatremo mesto ovo, jer je vika njihova velika pred Gospodom, pa nas posla Gospod da ga zatremo. ");
INSERT INTO srp1865_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","I iziđe Lot, i kaza zetovima svojim, za koje htede dati kćeri svoje, i reče im: Ustajte, idite iz mesta ovog, jer će sada zatrti Gospod grad ovaj. Ali se zetovima njegovim učini da se šali. ");
INSERT INTO srp1865_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","A kad zora zabele, navališe anđeli na Lota govoreći: Ustani, uzmi ženu svoju, i dve kćeri svoje koje su tu, da ne pogineš u bezakonju grada tog. ");
INSERT INTO srp1865_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","A on se stade ščinjati, te ljudi uzeše za ruku njega i ženu njegovu i dve kćeri njegove, jer ga beše žao Gospodu i izvedoše ga i pustiše ga iza grada. ");
INSERT INTO srp1865_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","I kad ih izvedoše napolje, reče jedan: Izbavi dušu svoju i ne obziri se natrag i u celoj ovoj ravni da nisi stao; beži na ono brdo da ne pogineš. ");
INSERT INTO srp1865_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","A Lot im reče: Nemoj, Gospode! ");
INSERT INTO srp1865_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Gle, sluga tvoj nađe milost pred Tobom, i milost je Tvoja prevelika koju mi učini sačuvavši mi život; ali ne mogu uteći na brdo da me ne stigne zlo i ne poginem. ");
INSERT INTO srp1865_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Eno grad blizu; onamo se može uteći, a mali je; da bežimo onamo; ta mali je, te ću ostati živ. ");
INSERT INTO srp1865_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","A on mu reče: Eto poslušaću te i zato, i neću zatrti grada, za koji reče. ");
INSERT INTO srp1865_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Brže beži onamo; jer ne mogu činiti ništa dok ne stigneš onamo. Zato se prozva onaj grad Sigor. ");
INSERT INTO srp1865_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","I kad sunce ogranu po zemlji, Lot dođe u Sigor. ");
INSERT INTO srp1865_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tada pusti Gospod na Sodom i na Gomor od Gospoda s neba dažd od sumpora i ognja, ");
INSERT INTO srp1865_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","i zatre one gradove i svu onu ravan, i sve ljude u gradovima i rod zemaljski. ");
INSERT INTO srp1865_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ali žena Lotova beše se obazrela idući za njim, i posta slan kamen. ");
INSERT INTO srp1865_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","A sutradan rano ustavši Avram, otide na mesto gde je stajao pred Gospodom; ");
INSERT INTO srp1865_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","i pogleda na Sodom i Gomor i svu okolinu po onoj ravni, i ugleda, a to se dizaše dim od zemlje kao dim iz peći. ");
INSERT INTO srp1865_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ali kad Bog zatiraše gradove u onoj ravni, opomenu se Bog Avrama, i izvede Lota iz propasti kad zatre gradove gde živeše Lot. ");
INSERT INTO srp1865_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","A Lot otide iz Sigora i stani se na onom brdu s dve kćeri svoje, jer se bojaše ostati u Sigoru; i živeše u pećini s dve kćeri svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","A starija reče mlađoj: Naš je otac star, a nema nikoga na zemlji da dođe k nama, kao što je običaj po svoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hajde da damo ocu vina neka se opije, pa da legnemo s njim, eda bismo sačuvale seme ocu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","I dadoše ocu vina onu noć; i došavši starija leže s ocem svojim, i on ne oseti ni kad ona leže ni kad ustade. ");
INSERT INTO srp1865_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","A sutradan reče starija mlađoj: Gle, noćas spavah s ocem svojim. Da mu damo vina i doveče, pa idi ti i lezi s njim, eda bismo sačuvale seme ocu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Pa i to veče dadoše ocu vina, i ustavši mlađa leže s njim, i on ne oseti ni kad ona leže ni kad ustade. ");
INSERT INTO srp1865_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","I obe kćeri Lotove zatrudneše od oca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","I starija rodi sina, i nadede mu ime Moav; od njega su Moavci do današnjeg dana. ");
INSERT INTO srp1865_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Pa i mlađa rodi sina, i nadede mu ime Ven-Amije; od njega su Amonci do današnjeg dana. ");
INSERT INTO srp1865_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","A Avram otide odande na jug, i stani se između Kadisa i Sura; i živeše kao došljak u Geraru. ");
INSERT INTO srp1865_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","I govoraše za ženu svoju Saru: Sestra mi je. A car gerarski Avimeleh posla te uze Saru. ");
INSERT INTO srp1865_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ali dođe Bog Avimelehu noću u snu, i reče mu: Gle, poginućeš sa žene koju si uzeo, jer ima muža. ");
INSERT INTO srp1865_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","A Avimeleh ne beše se nje dotakao, i zato reče: Gospode, eda li ćeš i pravedan narod pogubiti? ");
INSERT INTO srp1865_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nije li mi sam kazao: Sestra mi je? A i ona sama kaza: Brat mi je. Učinio sam u čistoti srca svog i u pravdi ruku svojih. ");
INSERT INTO srp1865_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Tada mu reče Bog u snu: Znam da si učinio u čistoti srca svog, zato te sačuvah da mi ne sagrešiš, i ne dadoh da je se dotakneš. ");
INSERT INTO srp1865_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","A sada vrati čoveku ženu njegovu, jer je prorok, i moliće se za te, te ćeš ostati živ. Ako li ne vratiš, znaj da ćeš umreti ti i svi tvoji. ");
INSERT INTO srp1865_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","I ujutru rano usta Avimeleh, i sazva sve sluge svoje, i kaza im sve ovo da čuju. I uplašiše se ljudi veoma. ");
INSERT INTO srp1865_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Tada Avimeleh dozva Avrama i reče mu: Šta si nam učinio? Šta li sam ti zgrešio, te navuče na me i na carstvo moje toliko zlo? Učinio si mi šta ne valja činiti. ");
INSERT INTO srp1865_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","I još reče Avimeleh Avramu: Šta ti je bilo, te si to učinio? ");
INSERT INTO srp1865_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","A Avram odgovori: Govorih: jamačno nema straha Božjeg u ovom mestu, pa će me ubiti radi žene moje. ");
INSERT INTO srp1865_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","A upravo i jeste mi sestra, kći oca mog; ali nije kći moje matere, pa pođe za me. ");
INSERT INTO srp1865_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","A kad me Bog izvede iz doma oca mog, ja joj rekoh: Učini dobro, i kaži za me gde god dođemo: Brat mi je. ");
INSERT INTO srp1865_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tada Avimeleh uze ovaca i goveda i sluga i sluškinja, te dade Avramu, i vrati mu Saru ženu njegovu. ");
INSERT INTO srp1865_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","I reče Avimeleh Avramu: Evo, zemlja ti je moja otvorena, živi slobodno gde ti je volja. ");
INSERT INTO srp1865_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A Sari reče: Evo dao sam tvom bratu hiljadu srebrnika; gle, on ti je očima pokrivalo pred svima koji budu s tobom; i to sve da ti je za nauku. ");
INSERT INTO srp1865_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","I Avram se pomoli Bogu, i isceli Bog Avimeleha i ženu njegovu i sluškinje njegove, te rađahu. ");
INSERT INTO srp1865_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Jer Gospod beše sasvim zatvorio svaku matericu u domu Avimelehovom radi Sare žene Avramove. ");
INSERT INTO srp1865_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","I Gospod pohodi Saru, kao što beše rekao i učini Gospod Sari kao što beše kazao. ");
INSERT INTO srp1865_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Jer zatrudne i rodi Sara Avramu sina u starosti njegovoj u isto vreme kad kaza Gospod. ");
INSERT INTO srp1865_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","I Avram nadede ime sinu koji mu se rodi, kog mu rodi Sara, Isak. ");
INSERT INTO srp1865_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","I obreza Avram sina svog Isaka kad bi od osam dana, kao što mu zapovedi Bog. ");
INSERT INTO srp1865_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","A Avramu beše sto godina kad mu se rodi sin Isak. ");
INSERT INTO srp1865_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","A Sara reče: Bog mi učini smeh; ko god čuje, smejaće mi se. ");
INSERT INTO srp1865_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","I reče: Ko bi rekao Avramu da će Sara dojiti decu? Ipak mu rodih sina u starosti njegovoj. ");
INSERT INTO srp1865_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","A kad dete doraste da se odbije od sise, učini Avram veliku gozbu onaj dan kad odbiše Isaka od sise. ");
INSERT INTO srp1865_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","I Sara vide sina Agare Misirke, koja ga rodi Avramu, gde se podsmeva; ");
INSERT INTO srp1865_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","pa reče Avramu: Oteraj ovu robinju sa sinom njenim, jer sin ove robinje neće biti naslednik s mojim sinom, s Isakom. ");
INSERT INTO srp1865_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","A to Avramu bi vrlo krivo radi sina njegovog. ");
INSERT INTO srp1865_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ali Bog reče Avramu: Nemoj da ti je krivo radi deteta i radi robinje tvoje. Šta ti je god kazala Sara, poslušaj; jer će ti se u Isaku seme prozvati. ");
INSERT INTO srp1865_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ali ću i od sina robinjinog učiniti narod, jer je tvoje seme. ");
INSERT INTO srp1865_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","I Avram ustav ujutru rano, uze hleba i mešinu vode, i dade Agari metnuvši joj na leđa, i dete, i otpusti je. A ona otišavši lutaše po pustinji virsavskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","A kad nesta vode u mešini, ona baci dete pod jedno drvo, ");
INSERT INTO srp1865_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","pa otide koliko se može strelom dobaciti, i sede prema njemu; jer govoraše: Da ne gledam kako će umreti dete. I sedeći prema njemu stade glasno plakati. ");
INSERT INTO srp1865_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","A Bog ču glas detinji, i anđeo Božji viknu s neba Agaru, i reče joj: Šta ti je Agaro? Ne boj se, jer Bog ču glas detinji odande gde je. ");
INSERT INTO srp1865_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ustani, digni dete i uzmi ga u naručje; jer ću od njega učiniti velik narod. ");
INSERT INTO srp1865_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","I Bog joj otvori oči, te ugleda studenac; i otišavši napuni mešinu vode, i napoji dete. ");
INSERT INTO srp1865_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","I Bog beše s detetom, te odraste, i živeše u pustinji i posta strelac. ");
INSERT INTO srp1865_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","A živeše u pustinji Faranu. I mati ga oženi iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","U to vreme reče Avimeleh i Fihol vojvoda njegov Avramu govoreći: Bog je s tobom u svemu što radiš. ");
INSERT INTO srp1865_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Zakuni mi se sada Bogom da nećeš prevariti mene ni sina mog ni unuka mog nego da ćeš dobro onako kako sam ja tebi činio i ti činiti meni i zemlji u kojoj si došljak. ");
INSERT INTO srp1865_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","A Avram reče: Hoću se zakleti. ");
INSERT INTO srp1865_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ali Avram prekori Avimeleha za studenac, koji uzeše na silu sluge Avimelehove. ");
INSERT INTO srp1865_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","A Avimeleh reče: Ne znam ko je to učinio; niti mi ti kaza, niti čuh do danas. ");
INSERT INTO srp1865_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tada Avram uze ovaca i goveda, i dade Avimelehu, i uhvati veru među sobom. ");
INSERT INTO srp1865_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","A Avram odluči sedam jaganjaca iz stada. ");
INSERT INTO srp1865_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","A Avimeleh reče Avramu: Šta će ono sedam jaganjaca što si odlučio? ");
INSERT INTO srp1865_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A on odgovori: Da primiš iz moje ruke ono sedam jaganjaca, da mi bude svedočanstvo da sam ja iskopao ovaj studenac. ");
INSERT INTO srp1865_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Otuda se prozva ono mesto Virsaveja, jer se onde zakleše obojica. ");
INSERT INTO srp1865_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tako uhvatiše veru na Virsaveji. Tada se diže Avimeleh i Fihol vojvoda njegov, i vratiše se u zemlju filistejsku. ");
INSERT INTO srp1865_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","A Avram posadi lug na Virsaveji, i onde prizva ime Gospoda Boga Večnog. ");
INSERT INTO srp1865_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","I Avram živeše kao došljak u zemlji filistejskoj mnogo vremena. ");
INSERT INTO srp1865_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Posle toga htede Bog okušati Avrama, pa mu reče: Avrame! A on odgovori: Evo me. ");
INSERT INTO srp1865_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","I reče mu Bog: Uzmi sada sina svog, jedinca svog milog, Isaka, pa idi u zemlju Moriju, i spali ga na žrtvu tamo na brdu gde ću ti kazati. ");
INSERT INTO srp1865_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","I sutradan rano ustavši Avram osamari magarca svog, i uze sa sobom dva momka i Isaka sina svog; i nacepavši drva za žrtvu podiže se i pođe na mesto koje mu kaza Bog. ");
INSERT INTO srp1865_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Treći dan podigavši oči svoje Avram ugleda mesto iz daleka. ");
INSERT INTO srp1865_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","I reče Avram momcima svojim: Ostanite vi ovde s magarcem, a ja i dete idemo onamo, pa kad se pomolimo Bogu, vratićemo se k vama. ");
INSERT INTO srp1865_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","I uzevši Avram drva za žrtvu naprti Isaku sinu svom, a sam uze u svoje ruke ognja i nož; pa otidoše obojica zajedno. ");
INSERT INTO srp1865_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Tada reče Isak Avramu ocu svom: Oče! A on reče: Šta je, sine! I reče Isak: Eto ognja i drva, a gde je jagnje za žrtvu? ");
INSERT INTO srp1865_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","A Avram odgovori: Bog će se, sinko, postarati za jagnje sebi na žrtvu. I iđahu obojica zajedno. ");
INSERT INTO srp1865_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","A kad dođoše na mesto koje mu Bog kaza, Avram načini onde žrtvenik, i metnu drva na nj, i svezavši Isaka sina svog metnu ga na žrtvenik vrh drva; ");
INSERT INTO srp1865_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","i izmahnu Avram rukom svojom i uze nož da zakolje sina svog. ");
INSERT INTO srp1865_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ali anđeo Gospodnji viknu ga s neba, i reče: Avrame! Avrame! A on reče: Evo me. ");
INSERT INTO srp1865_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","A anđeo reče: Ne diži ruku svoju na dete, i ne čini mu ništa; jer sada poznah da se bojiš Boga, kad nisi požalio sina svog, jedinca svog, mene radi. ");
INSERT INTO srp1865_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","I Avram podigavši oči svoje pogleda; i gle, ovan iza njega zapleo se u česti rogovima; i otišavši Avram uze ovna i spali ga na žrtvu mesto sina svog. ");
INSERT INTO srp1865_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","I nazva Avram ono mesto Gospod će se postarati. Zato se i danas kaže: Na brdu, gde će se Gospod postarati. ");
INSERT INTO srp1865_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","I anđeo Gospodnji opet viknu s neba Avrama. ");
INSERT INTO srp1865_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","I reče: Sobom se zakleh, veli Gospod: kad si tako učinio, i nisi požalio sina svog, jedinca svog, ");
INSERT INTO srp1865_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","zaista ću te blagosloviti i seme tvoje veoma umnožiti, da ga bude kao zvezda na nebu i kao peska na bregu morskom; i naslediće seme tvoje vrata neprijatelja svojih; ");
INSERT INTO srp1865_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","i blagosloviće se u semenu tvom svi narodi na zemlji, kad si poslušao glas moj. ");
INSERT INTO srp1865_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tada se Avram vrati k momcima svojim, te se digoše, i otidoše zajedno u Virsaveju, jer Avram živeše u Virsaveji. ");
INSERT INTO srp1865_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Posle toga javiše Avramu govoreći: Gle, i Melha rodi sinove bratu tvom Nahoru: ");
INSERT INTO srp1865_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uza prvenca i Vuza brata mu, i Kamuila, oca Aramovog, ");
INSERT INTO srp1865_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","i Hazada i Azava i Faldesa i Jeldafa i Vatuila. ");
INSERT INTO srp1865_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","A Vatuilo rodi Reveku. Osam ih rodi Melha Nahoru bratu Avramovom. ");
INSERT INTO srp1865_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","I inoča njegova, po imenu Revma, rodi i ona Taveka i Gama i Tohosa i Moha. ");
INSERT INTO srp1865_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","A požive Sara sto i dvadeset i sedam godina; to su godine veka Sarinog; ");
INSERT INTO srp1865_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","i umre Sara u Kirijat-Arvi, a to je Hevron, u zemlji hananskoj. I dođe Avram da ožali Saru i oplače. ");
INSERT INTO srp1865_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","A kad usta Avram od mrtvaca svog, reče sinovima Hetovim govoreći: ");
INSERT INTO srp1865_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Stranac sam i došljak kod vas; dajte mi da imam grob kod vas da pogrebem mrtvaca svog ispred očiju svojih. ");
INSERT INTO srp1865_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","A sinovi Hetovi odgovoriše Avramu govoreći mu: ");
INSERT INTO srp1865_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Čuj nas, gospodaru; ti si knez od Boga među nama; u najboljem grobu našem pogrebi mrtvaca svog; niko između nas neće ti zatvoriti grob svoj da ne pogrebeš mrtvaca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tada usta Avram i pokloni se narodu zemlje one, sinovima Hetovim; ");
INSERT INTO srp1865_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","i reče im govoreći: Ako hoćete da pogrebem mrtvaca svog ispred očiju svojih, poslušajte me, i govorite za mene Efronu sinu Sarovom, ");
INSERT INTO srp1865_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","neka mi da pećinu u Makpeli, koja je nakraj njive njegove; za novce neka mi je da među vama koliko vredi, da imam grob. ");
INSERT INTO srp1865_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","A Efron seđaše usred sinova Hetovih. Pa reče Efron Hetejin Avramu pred sinovima Hetovim, koji slušahu, pred svim koji ulažahu na vrata grada njegovog, govoreći: ");
INSERT INTO srp1865_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ne, gospodaru; čuj me: poklanjam ti njivu, i pećinu kod nje poklanjam ti: pred sinovima naroda svog poklanjam ti je, pogrebi mrtvaca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","A Avram se pokloni narodu zemlje one, ");
INSERT INTO srp1865_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","i reče Efronu pred narodom zemlje one govoreći: Ako si voljan čuj me; da ti dam šta vredi njiva, uzmi od mene, pa ću onda pogrepsti mrtvaca svog onde. ");
INSERT INTO srp1865_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","A Efron odgovori Avramu govoreći mu: ");
INSERT INTO srp1865_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Gospodaru, čuj me; zemlja vredi četiri stotine sikala srebra između mene i tebe; šta je to? Samo ti pogrebi mrtvaca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","A Avram čuvši Efrona izmeri mu srebro, koje reče pred sinovima Hetovim, četiri stotine sikala srebra, kako su išli među trgovcima. ");
INSERT INTO srp1865_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","I njiva Efronova u Makpeli prema Mamriji, njiva s pećinom koja je na njoj, i sva drveta na njivi i po međi njenoj unaokolo, ");
INSERT INTO srp1865_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","posta Avramova pred sinovima Hetovim, pred svima koji ulaze na vrata grada onog. ");
INSERT INTO srp1865_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Potom pogrebe Avram Saru ženu svoju u pećini na njivi Makpeli prema Mamriji, a to je Hevron, u zemlji hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","I potvrdiše sinovi Hetovi njivu i pećinu na njoj Avramu da ima grob. ");
INSERT INTO srp1865_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","A Avram beše star i vremenit, i Gospod beše blagoslovio Avrama u svemu; ");
INSERT INTO srp1865_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","i reče Avram sluzi svom najstarijem u kući svojoj, koji beše nad svim dobrom njegovim: Metni ruku svoju pod stegno moje, ");
INSERT INTO srp1865_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","da te zakunem Gospodom Bogom nebeskim i Bogom zemaljskim da nećeš dovesti žene sinu mom između kćeri ovih Hananeja, među kojima živim; ");
INSERT INTO srp1865_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","nego da ćeš otići u zemlju moju i u rod moj i dovesti ženu sinu mom Isaku. ");
INSERT INTO srp1865_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A sluga mu reče: i ako devojka ne htedbude poći sa mnom u ovu zemlju; hoću li odvesti sina tvog u zemlju iz koje si se iselio? ");
INSERT INTO srp1865_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","A Avram mu reče: Pazi da ne odvedeš sina mog onamo. ");
INSERT INTO srp1865_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Gospod Bog nebeski, koji me je uzeo iz doma oca mog i iz zemlje roda mog, i koji mi je rekao i zakleo mi se govoreći: Semenu ću tvom dati zemlju ovu, On će poslati anđela svog pred tobom da dovedeš ženu sinu mom odande. ");
INSERT INTO srp1865_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ako li devojka ne htedbude poći s tobom, onda da ti je prosta zakletva moja; samo sina mog nemoj odvesti onamo. ");
INSERT INTO srp1865_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","I metnu sluga ruku svoju pod stegno Avramu gospodaru svom, i zakle mu se za ovo. ");
INSERT INTO srp1865_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tada sluga uze deset kamila između kamila gospodara svog da ide, jer sve blago gospodara njegovog beše pod njegovom rukom; i otišavši dođe u Mesopotamiju do grada Nahorovog. ");
INSERT INTO srp1865_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","I pusti kamile da poležu iza grada kod studenca pred veče kad izlaze građanke da zahvataju vode; ");
INSERT INTO srp1865_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","i reče: Gospode Bože gospodara mog Avrama, daj mi sreću danas i učini milost gospodaru mom Avramu. ");
INSERT INTO srp1865_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Evo, ja ću stajati kod ovog studenca, a građanke će doći da zahvataju vode. ");
INSERT INTO srp1865_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kojoj devojci kažem: Nagni krčag svoj da se napijem, a ona reče: Na pij, i kamile ću ti napojiti; daj to da bude ona koju si namenio sluzi svom Isaku; i po tome da poznam da si učinio milost gospodaru mom. ");
INSERT INTO srp1865_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","I on još ne izgovori, a to Reveka, kći Vatuila sina Melhe žene Nahora brata Avramovog, dođe s krčagom na ramenu. ");
INSERT INTO srp1865_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","I beše vrlo lepa, još devojka, još je čovek ne beše poznao. Ona siđe na izvor, i natoči krčag, i pođe; ");
INSERT INTO srp1865_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","a sluga iskoči pred nju, i reče; daj mi da se napijem malo vode iz krčaga tvog. ");
INSERT INTO srp1865_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A ona reče: Na pij, gospodaru. I brže spusti krčag na ruku svoju, i napoji ga. ");
INSERT INTO srp1865_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","I kad ga napoji, reče: i kamilama ću tvojim naliti neka se napiju. ");
INSERT INTO srp1865_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","I brže izruči krčag svoj u pojilo, pa opet otrča na studenac da nalije, i nali svim kamilama njegovim. ");
INSERT INTO srp1865_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","A čovek joj se divljaše, i ćutaše, neće li poznati je li Gospod dao sreću putu njegovom ili nije. ");
INSERT INTO srp1865_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","A kad se kamile napiše, izvadi čovek zlatnu grivnu od po sikala i metnu joj oko čela, i dve narukvice metnu joj na ruke od deset sikala zlata. ");
INSERT INTO srp1865_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","I reče: Čija si kći? Kaži mi. Ima li u kući oca tvog mesta za nas da prenoćimo? ");
INSERT INTO srp1865_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","A ona mu reče: Ja sam kći Vatuila sina Melšinog, koga rodi Nahoru. ");
INSERT INTO srp1865_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Još reče: Ima u nas mnogo slame i piće i mesta za noćište. ");
INSERT INTO srp1865_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tada čovek savivši se pokloni se Gospodu, ");
INSERT INTO srp1865_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","i reče: Blagosloven da je Gospod Bog gospodara mog Avrama, što ne ostavi milost svoju i veru svoju prema gospodaru mom, i putem dovede me Gospod u dom rodbine gospodara mog. ");
INSERT INTO srp1865_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","A devojka otrča i sve ovo kaza u domu matere svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","A Reveka imaše brata, kome ime beše Lavan; i istrča Lavan k čoveku na studenac, ");
INSERT INTO srp1865_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","kako vide grivnu i narukvice na rukama sestre svoje i ču gde Reveka sestra mu reče: Tako mi kaza čovek; dođe k čoveku; a on stajaše kod kamila na studencu. ");
INSERT INTO srp1865_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","I reče: Hodi, koji si blagosloven od Gospoda; što bi stajao napolju? Spremio sam kuću, ima mesta i za kamile. ");
INSERT INTO srp1865_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","I dovede čoveka u kuću, i rastovari kamile; i dodaše slame i piće kamilama, i donesoše vode za noge njemu i ljudima što behu s njim; ");
INSERT INTO srp1865_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","i postaviše mu da jede; ali on reče: Neću jesti dokle ne kažem stvar svoju. A Lavan mu reče: Govori. ");
INSERT INTO srp1865_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tada reče: Ja sam sluga Avramov. ");
INSERT INTO srp1865_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","A Gospod je blagoslovio gospodara mog veoma, te je postao velik, i dao mu je ovaca i goveda, i srebra i zlata, i sluga i sluškinja, i kamila i magaraca. ");
INSERT INTO srp1865_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","I još Sara žena gospodara mog rodi sina gospodaru mom u starosti njegovoj, i on mu dade sve što ima. ");
INSERT INTO srp1865_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","A mene zakle gospodar moj govoreći: Nemoj dovesti sinu mom žene između kćeri ovih Hananeja, među kojima živim; ");
INSERT INTO srp1865_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","nego idi u dom oca mog i u rod moj, da dovedeš ženu sinu mom. ");
INSERT INTO srp1865_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","A ja rekoh gospodaru svom: Može biti da devojka neće hteti poći sa mnom. ");
INSERT INTO srp1865_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A on mi reče: Gospod, po čijoj volji svagda živeh, poslaće anđela svog s tobom, i daće sreću tvom putu da dovedeš ženu sinu mom od roda mog, iz doma oca mog. ");
INSERT INTO srp1865_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Onda će ti biti prosta zakletva moja, kad otideš u rod moj; ako ti je i ne dadu, opet će ti biti prosta zakletva moja. ");
INSERT INTO srp1865_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","I kad dođoh danas na studenac, rekoh: Gospode Bože gospodara mog Avrama, ako si dao sreću putu mom, kojim idem, ");
INSERT INTO srp1865_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","evo, ja ću stajati kod studenca: koja devojka dođe da zahvati vode, i ja joj kažem: Daj mi da se napijem malo vode iz krčaga tvog, ");
INSERT INTO srp1865_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","a ona mi odgovori: i ti pij i kamilama ću tvojim naliti; to neka bude žena koju je namenio Gospod sinu gospodara mog. ");
INSERT INTO srp1865_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ja još ne izgovorih u srcu svom, a dođe Reveka s krčagom na ramenu, i sišavši na izvor zahvati; i ja joj rekoh: Daj mi da se napijem. ");
INSERT INTO srp1865_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A ona brže spustivši sa sebe krčag reče: Na pij, i kamile ću ti napojiti. I kad se napih, napoji i kamile moje. ");
INSERT INTO srp1865_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","I zapitah je govoreći: Čija si kći? A ona odgovori: Ja sam kći Vatuila sina Nahorovog, kog mu rodi Melha. Tada joj metnuh grivnu oko čela i narukvice na ruke; ");
INSERT INTO srp1865_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","i padoh i poklonih se Gospodu, i zahvalih Gospodu Bogu gospodara mog Avrama, što me dovede pravim putem da nađem kćer brata gospodara svog za sina njegovog. ");
INSERT INTO srp1865_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ako ćete dakle učiniti ljubav i veru gospodaru mom, kažite mi; ako li nećete, kažite mi, da idem na desno ili na levo. ");
INSERT INTO srp1865_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","A Lavan i Vatuilo odgovarajući rekoše: Od Gospoda je ovo došlo; mi ti ne možemo kazati ni zlo ni dobro. ");
INSERT INTO srp1865_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Eto, Reveka je u tvojoj vlasti, uzmi je pa idi, i neka bude žena sinu tvog gospodara, kao što kaza Gospod. ");
INSERT INTO srp1865_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","A kad ču sluga Avramov reči njihove, pokloni se Gospodu do zemlje; ");
INSERT INTO srp1865_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","i izvadi zaklade srebrne i zlatne i haljine, i dade Reveci; takođe i bratu njenom i materi njenoj dade darove. ");
INSERT INTO srp1865_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Potom jedoše i piše on i ljudi koji behu s njim, i prenoćiše. A kad ujutru ustaše, reče sluga: Pustite me gospodaru mom. ");
INSERT INTO srp1865_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","A brat i mati njena rekoše: Neka ostane devojka kod nas koji dan, barem deset dana, pa onda neka ide. ");
INSERT INTO srp1865_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A on im reče: Nemojte me zadržavati, kad je Gospod dao sreću mom putu; pustite me da idem gospodaru svom. ");
INSERT INTO srp1865_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tada rekoše: Da zovemo devojku, i upitamo šta ona veli. ");
INSERT INTO srp1865_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","I dozvaše Reveku i rekoše joj: Hoćeš ići s ovim čovekom? A ona odgovori: Hoću. ");
INSERT INTO srp1865_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","I pustiše Reveku sestru svoju i dojkinju njenu sa slugom Avramovim i ljudima njegovim. ");
INSERT INTO srp1865_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","I blagosloviše Reveku i rekoše joj: Sestro naša, da se namnožiš na hiljade hiljada, i seme tvoje da nasledi vrata svojih neprijatelja! ");
INSERT INTO srp1865_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","I podiže se Reveka s devojkama svojim, i posedaše na kamile, i pođoše s čovekom; i sluga uzevši Reveku otide. ");
INSERT INTO srp1865_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","A Isak iđaše vraćajući se od studenca Živoga koji me vide jer življaše u južnom kraju; ");
INSERT INTO srp1865_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","a beše izašao Isak u polje pred veče da se pomoli Bogu; i podigavši oči svoje ugleda kamile gde idu. ");
INSERT INTO srp1865_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","I Reveka podigavši oči svoje ugleda Isaka, te skoči s kamile, ");
INSERT INTO srp1865_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","i reče sluzi: Ko je onaj čovek što ide preko polja pred nas? A sluga reče: Ono je gospodar moj. I ona uze pokrivalo i pokri lice. ");
INSERT INTO srp1865_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","I pripovedi sluga Isaku sve što je svršio. ");
INSERT INTO srp1865_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","I odvede je Isak u šator Sare matere svoje; i uze Reveku, i ona mu posta žena, i omile mu. I Isak se uteši za materom svojom. ");
INSERT INTO srp1865_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","A Avram uze drugu ženu, po imenu Heturu. ");
INSERT INTO srp1865_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","I ona mu rodi Zomrana i Joksana i Madana i Madijana i Jesvoka i Soijena. ");
INSERT INTO srp1865_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","A Joksan rodi Savana i Dedana. A Dedanovi sinovi biše Asurim i Latusim i Laomim. ");
INSERT INTO srp1865_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","A sinovi Madijanovi: Efar i Afir i Enoh i Avida i Eldaga. Svi behu deca Heturina. ");
INSERT INTO srp1865_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","A Avram dade sve što imaše Isaku; ");
INSERT INTO srp1865_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","a sinovima svojih inoča dade Avram dare, i opravi ih od Isaka sina svog još za života svog na istok, u istočni kraj. ");
INSERT INTO srp1865_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","I veka Avramovog što požive beše sto i sedamdeset i pet godina. ");
INSERT INTO srp1865_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","I onemoćav umre Avram u dobroj starosti, sit života, i bi pribran k rodu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","I pogreboše ga Isak i Ismailo u pećini makpelskoj na njivi Efrona sina Sara Hetejina, koja je prema Mamriji; ");
INSERT INTO srp1865_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","na njivi koju kupi Avram od sinova Hetovih, onde je pogreben Avram sa Sarom ženom svojom. ");
INSERT INTO srp1865_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","I po smrti Avramovoj blagoslovi Bog Isaka sina njegovog; a Isak živeše kod studenca Živoga koji me vidi. ");
INSERT INTO srp1865_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","A ovo je pleme Ismaila sina Avramovog, kog rodi Avramu Agara Misirka robinja Sarina, ");
INSERT INTO srp1865_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","i ovo su imena sinova Ismailovih, kako se zvahu u plemenima svojim; prvenac Ismailov Navajot, pa Kidar i Navdeilo i Masam, ");
INSERT INTO srp1865_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","i Masma i Duma i Masa, ");
INSERT INTO srp1865_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","i Hadar i Teman i Jetur i Nafis i Kedma. ");
INSERT INTO srp1865_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","To su sinovi Ismailovi, i to su im imena po selima i gradovima njihovim, dvanaest knezova nad svojim narodima. ");
INSERT INTO srp1865_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","A godine su veka Ismailovog sto i trideset i sedam godina. Posle onemoćav umre, i bi pribran k rodu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","I živehu od Evilata do Sura prema Misiru, kako se ide u Asiriju; i dopade mu prema svoj braći svojoj da živi. ");
INSERT INTO srp1865_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","A ovo je pleme Isaka sina Avramovog: Avram rodi Isaka; ");
INSERT INTO srp1865_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","a Isaku beše četrdeset godina kad se oženi Revekom, kćerju Vatuila Sirina iz Mesopotamije, sestrom Lavana Sirina. ");
INSERT INTO srp1865_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","I Isak se moljaše Gospodu za ženu svoju, jer beše nerotkinja; i umoli Gospoda, te zatrudne Reveka žena njegova. ");
INSERT INTO srp1865_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ali udarahu jedno o drugo deca u utrobi njenoj, te reče: Ako je tako, na šta sam? I otide da pita Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","A Gospod joj reče: Dva su plemena u utrobi tvojoj, i dva će naroda, izaći iz tebe; i jedan će narod biti jači od drugog naroda, i veći će služiti manjem. ");
INSERT INTO srp1865_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","I kad dođe vreme da rodi, a to blizanci u utrobi njenoj. ");
INSERT INTO srp1865_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","I prvi izađe crven, sav kao runo rutav, i nadeše mu ime Isav. ");
INSERT INTO srp1865_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","A posle izađe brat mu, držeći rukom za petu Isava; i nadeše mu ime Jakov. A beše Isaku šezdeset godina, kad ih rodi Reveka. ");
INSERT INTO srp1865_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","I deca odrastoše, i Isav posta lovac i ratar, a Jakov beše čovek krotak i bavljaše se u šatorima. ");
INSERT INTO srp1865_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I Isak milovaše Isava, jer rado jeđaše lov njegov; a Reveka milovaše Jakova. ");
INSERT INTO srp1865_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jednom Jakov skuva jelo, a Isav dođe iz polja umoran. ");
INSERT INTO srp1865_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","I reče Isav Jakovu: Daj mi da jedem to jelo crveno, jer sam umoran. Otuda se prozva Edom. ");
INSERT INTO srp1865_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","A Jakov mu reče: Prodaj mi danas prvenaštvo svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","A Isav odgovori: Evo, hoću da umrem, pa šta će mi prvenaštvo? ");
INSERT INTO srp1865_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","A Jakov reče: Zakuni mi se danas. I on mu se zakle; tako prodade svoje prvenaštvo Jakovu. ");
INSERT INTO srp1865_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","I Jakov dade Isavu hleba i skuvanog leća, i on se najede i napi, pa usta i otide. Tako Isav nije mario za prvenaštvo svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ali nasta glad u zemlji svrh prve gladi koja beše za vremena Avramovog; i Isak otide k Avimelehu caru filistejskom u Gerar. ");
INSERT INTO srp1865_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","I javi mu se Gospod i reče: Nemoj ići u Misir, nego sedi u zemlji koju ću ti kazati. ");
INSERT INTO srp1865_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Sedi u toj zemlji, i ja ću biti s tobom, i blagosloviću te; jer ću tebi i semenu tvom dati sve ove zemlje, i potvrdiću zakletvu, kojom sam se zakleo Avramu ocu tvom. ");
INSERT INTO srp1865_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I umnožiću seme tvoje da ga bude kao zvezda na nebu, i daću semenu tvom sve ove zemlje; i u semenu tvom blagosloviće se svi narodi na zemlji, ");
INSERT INTO srp1865_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","zato što je Avram slušao glas moj i čuvao naredbu moju, zapovesti moje i pravila moja i zakone moje. ");
INSERT INTO srp1865_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","I osta Isak u Geraru. ");
INSERT INTO srp1865_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","A ljudi u mestu onom pitahu za ženu njegovu, a on govoraše: Sestra mi je. Jer se bojaše kazati: Žena mi je; da me, veli, ne ubiju ovi ljudi radi Reveke, jer je lepa. ");
INSERT INTO srp1865_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","I kad provede mnogo vremena onde, dogodi se, te pogleda Avimeleh car filistejski s prozora, i vide Isaka gde se šali s Revekom ženom svojom. ");
INSERT INTO srp1865_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","I dozva Avimeleh Isaka i reče: Ta to ti je žena; kako si kazao: Sestra mi je? A Isak mu odgovori: Rekoh: da ne poginem s nje. ");
INSERT INTO srp1865_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","A Avimeleh reče: Šta si nam učinio? Lako je mogao ko od naroda ovog leći s tvojom ženom, te bi nas ti uvalio u greh. ");
INSERT INTO srp1865_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","I zapovedi Avimeleh svemu narodu svom govoreći: Ko se dotakne ovog čoveka ili žene njegove, poginuće. ");
INSERT INTO srp1865_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","I Isak stade sejati u onoj zemlji, i dobi one godine po sto, tako ga blagoslovi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","I obogati se čovek, i napredovaše sve većma, te posta silan. ");
INSERT INTO srp1865_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","I imaše ovaca i goveda i mnogo sluga; a Filisteji mu zaviđahu, ");
INSERT INTO srp1865_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","pa sve studence koje behu iskopale sluge oca njegovog za vremena Avrama oca njegovog zaroniše Filisteji, i zasuše ih zemljom. ");
INSERT INTO srp1865_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","I Avimeleh reče Isaku: Idi od nas, jer si postao silniji od nas. ");
INSERT INTO srp1865_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","I Isak otide, odande, i razape šatore u dolini gerarskoj, i nastani se onde. ");
INSERT INTO srp1865_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","I stade Isak otkopavati studence, koji behu iskopani za vremena Avrama oca njegovog, i koje zaroniše Filisteji po smrti Avramovoj; i prozva ih imenima koja im beše nadeo otac njegov. ");
INSERT INTO srp1865_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","I kopajući sluge Isakove u onom dolu nađoše studenac žive vode. ");
INSERT INTO srp1865_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ali se svađaše pastiri gerarski s pastirima Isakovim govoreći: Naša je voda. I nadede ime onom studencu Esek, jer se svadiše s njim. ");
INSERT INTO srp1865_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Posle iskopaše drugi studenac, pa se i oko njega svađaše, zato ga nazva Sitna. ");
INSERT INTO srp1865_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Tada se podiže odande, i iskopa drugi studenac, i oko njega ne bi svađe; zato ga nazva Rehovot, govoreći: Sad nam dade Gospod prostora da rastemo u ovoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","I otide odande gore u Virsaveju. ");
INSERT INTO srp1865_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","I istu noć javi mu se Gospod, i reče: Ja sam Bog Avrama oca tvog. Ne boj se, jer sam ja s tobom, i blagosloviću te i umnožiću seme tvoje Avrama radi sluge svog. ");
INSERT INTO srp1865_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","I načini onde žrtvenik, i prizva ime Gospodnje; i onde razape šator svoj; i sluge Isakove iskopaše onde studenac. ");
INSERT INTO srp1865_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","I dođe k njemu Avimeleh iz Gerara s Ohozatom prijateljem svojim i s Fiholom vojvodom svojim. ");
INSERT INTO srp1865_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","A Isak im reče: Što ste došli k meni, kad mrzite na me i oteraste me od sebe? ");
INSERT INTO srp1865_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","A oni rekoše: Videsmo zaista da je Gospod s tobom, pa rekosmo: Neka bude zakletva između nas, između nas i tebe; hajde da uhvatimo veru s tobom; ");
INSERT INTO srp1865_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","da nam ne činiš zla, kao što se mi tebe ne dotakosmo i kao što mi tebi samo dobro činismo, i pustismo te da ideš na miru, i eto si blagosloven od Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tada ih on ugosti; te jedoše i piše. ");
INSERT INTO srp1865_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","A sutradan ustavši rano, zakleše se jedan drugom, i otpusti ih Isak i otidoše od njega s mirom. ");
INSERT INTO srp1865_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Isti dan došavši sluge Isakove kazaše mu za studenac koji iskopaše, i rekoše mu: Nađosmo vodu. ");
INSERT INTO srp1865_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I nazva ga Saveja; otuda se zove grad onaj Virsaveja do današnjeg dana. ");
INSERT INTO srp1865_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","A kad bi Isavu četrdeset godina, uze za ženu Juditu, kćer Veoha Hetejina, i Vasematu kćer Elona Hetejina. ");
INSERT INTO srp1865_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","I one zadavahu mnogo jada Isaku i Reveci. ");
INSERT INTO srp1865_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kad Isak ostare i oči mu potamneše, te ne videše, dozva Isava starijeg sina svog, i reče mu: Sine! A on odgovori: Evo me. ");
INSERT INTO srp1865_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tada reče: Evo ostareo sam, ne znam kad ću umreti; ");
INSERT INTO srp1865_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","uzmi oružje svoje, tul i luk, i izađi u planinu, te mi ulovi lov; ");
INSERT INTO srp1865_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","i zgotovi mi jelo po mojoj volji, i donesi mi da jedem, pa da te blagoslovi duša moja dok nisam umro. ");
INSERT INTO srp1865_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","A Reveka ču šta Isak reče sinu svom Isavu. I Isav otide u planinu da ulovi lov i donese. ");
INSERT INTO srp1865_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","A Reveka reče Jakovu, sinu svom govoreći: Gle, čuh oca tvog gde govori s Isavom, bratom tvojim i reče: ");
INSERT INTO srp1865_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Donesi mi lov, i zgotovi jelo da jedem, pa da te blagoslovim pred Gospodom dok nisam umro. ");
INSERT INTO srp1865_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nego sada, sine, poslušaj me šta ću ti kazati. ");
INSERT INTO srp1865_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Idi sada k stadu i donesi dva dobra jareta, da zgotovim ocu tvom jelo od njih, kako rado jede. ");
INSERT INTO srp1865_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Pa ćeš uneti ocu da jede i da te blagoslovi dok nije umro. ");
INSERT INTO srp1865_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","A Jakov reče Reveci materi svojoj: Ali je Isav brat moj rutav, a ja sam gladak; ");
INSERT INTO srp1865_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","može me opipati otac, pa će se osetiti da sam ga hteo prevariti, te ću navući na se prokletstvo mesto blagoslova. ");
INSERT INTO srp1865_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","A mati mu reče: Neka prokletstvo tvoje, sine padne na mene; samo me poslušaj, i idi i donesi mi. ");
INSERT INTO srp1865_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tada otišavši uze i donese materi svojoj; a mati njegova zgotovi jelo kako jeđaše rado otac njegov. ");
INSERT INTO srp1865_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Pa onda uze Reveka najlepše haljine starijeg sina svog, koje behu u nje kod kuće, i obuče Jakova mlađeg sina svog. ");
INSERT INTO srp1865_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","I jarećim kožicama obloži mu ruke i vrat gde beše gladak. ");
INSERT INTO srp1865_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","I dade Jakovu sinu svom u ruke jelo i hleb što zgotovi. ");
INSERT INTO srp1865_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","A on uđe k ocu svom i reče: Oče. A on odgovori: Evo me; koji si ti, sine? ");
INSERT INTO srp1865_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","I Jakov reče ocu svom: Ja, Isav tvoj prvenac; učinio sam kako si mi rekao; digni se, posadi se da jedeš lov moj, pa da me blagoslovi duša tvoja. ");
INSERT INTO srp1865_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","A Isak reče sinu svom: Kad brže nađe, sine? A on reče: Gospod Bog tvoj dade, te izađe preda me. ");
INSERT INTO srp1865_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tada reče Isak Jakovu: Hodi bliže, sine da te opipam jesi li sin moj Isav ili ne. ");
INSERT INTO srp1865_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","I pristupi Jakov k Isaku ocu svom, a on ga opipa, pa reče: Glas je Jakovljev, ali ruke su Isavove. ");
INSERT INTO srp1865_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","I ne pozna ga, jer mu ruke behu kao u Isava brata njegovog rutave: Zato ga blagoslovi; ");
INSERT INTO srp1865_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","i reče mu: Jesi li ti sin moj Isav? A on odgovori: Ja sam. ");
INSERT INTO srp1865_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tada reče: A ti daj, sine, da jedem lov tvoj, pa da te blagoslovi duša moja. I dade mu, te jede; pa mu donese i vino te pi. ");
INSERT INTO srp1865_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Potom Isak, otac njegov reče mu: Hodi sine, celivaj me. ");
INSERT INTO srp1865_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","I on pristupi i celiva ga; a Isak oseti miris od haljina njegovih, i blagoslovi ga govoreći: Gle, miris sina mog kao miris od polja koje blagoslovi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Bog ti dao rose nebeske, i dobre zemlje i pšenice i vina izobila! ");
INSERT INTO srp1865_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Narodi ti služili i plemena ti se klanjala! Bio gospodar braći svojoj i klanjali ti se sinovi matere tvoje! Proklet bio koji tebe usproklinje, a blagosloven koji tebe uzblagosilja! ");
INSERT INTO srp1865_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","A kad Isak blagoslovi Jakova, i Jakov otide ispred Isaka oca svog, u taj čas dođe Isav brat njegov iz lova. ");
INSERT INTO srp1865_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Pa zgotovi i on jelo i unese ocu svom, i reče mu: Ustani, oče, da jedeš šta ti je sin ulovio, pa da me blagoslovi duša tvoja. ");
INSERT INTO srp1865_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A Isak otac njegov reče mu: Ko si ti? A on reče: Ja, sin tvoj, prvenac tvoj Isav. ");
INSERT INTO srp1865_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tada se prepade Isak, i reče: Ko? Da gde je onaj koji ulovi i donese mi lova, i od svega jedoh pre nego ti dođe, i blagoslovih ga? On će i ostati blagosloven. ");
INSERT INTO srp1865_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","A kad ču Isav reči oca svog, vrisnu glasno i ožalosti se veoma, i reče ocu svom: Blagoslovi i mene, oče. ");
INSERT INTO srp1865_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","A on mu reče: Dođe brat tvoj s prevarom, i odnese tvoj blagoslov. ");
INSERT INTO srp1865_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","A Isav reče: Pravo je što mu je ime Jakov, jer me već drugom prevari. Prvenaštvo mi uze, pa eto sada mi uze i blagoslov. Potom reče: Nisi li i meni ostavio blagoslov? ");
INSERT INTO srp1865_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","A Isak odgovori, i reče Isavu: Eto sam ga postavio tebi za gospodara; i svu braću njegovu dadoh mu da mu budu sluge; pšenicom i vinom ukrepih ga; pa šta bih sada tebi učinio, sine? ");
INSERT INTO srp1865_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","I Isav reče ocu svom: Eda li je samo jedan blagoslov u tebe, oče? Blagoslovi i mene, oče. I stade glasno plakati Isav. ");
INSERT INTO srp1865_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A Isak otac njegov odgovarajući reče mu: Evo, stan će ti biti na rodnoj zemlji i rosi nebeskoj ozgo. ");
INSERT INTO srp1865_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ali ćeš živeti od mača svog, i bratu ćeš svom služiti; ali će doći vreme, te ćeš pošto se naplačeš skršiti jaram njegov s vrata svog. ");
INSERT INTO srp1865_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","I Isav omrze ljuto na Jakova radi blagoslova, kojim ga blagoslovi otac, i govoraše u srcu svom: Blizu su žalosni dani oca mog, tada ću ubiti Jakova brata svog. ");
INSERT INTO srp1865_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","I kazaše Reveci reči Isava sina njenog starijeg, a ona poslavši dozva Jakova mlađeg sina svog, i reče mu: Gle, Isav brat tvoj teši se time što hoće da te ubije. ");
INSERT INTO srp1865_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nego, sine, poslušaj šta ću ti kazati; ustani i beži k Lavanu bratu mom u Haran. ");
INSERT INTO srp1865_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","I ostani kod njega neko vreme dokle prođe srdnja brata tvog, ");
INSERT INTO srp1865_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","dokle se gnev brata tvog odvrati od tebe, te zaboravi šta si mu učinio; a onda ću ja poslati da te dovedu odande. Zašto bih ostala bez obojice vas u jedan dan? ");
INSERT INTO srp1865_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","A Isaku reče Reveka: Omrzao mi je život radi ovih Hetejaka. Ako se Jakov oženi Hetejkom, kakvom između kćeri ove zemlje, na šta mi život? ");
INSERT INTO srp1865_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tada Isak dozva Jakova, i blagoslovi ga, i zapovedi mu i reče: Nemoj da se oženiš kojom između kćeri hananejskih. ");
INSERT INTO srp1865_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ustani, idi u Padan-Aram u dom Vatuila oca matere svoje, i odande se oženi između kćeri Lavana ujaka svog. ");
INSERT INTO srp1865_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","A Bog Svemogući da te blagoslovi, i da ti da veliku porodicu i umnoži te, da od tebe postane mnoštvo naroda, ");
INSERT INTO srp1865_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","i da ti da blagoslov Avramov, tebi i semenu tvom s tobom, da naslediš zemlju u kojoj si došljak, koju Bog dade Avramu. ");
INSERT INTO srp1865_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Tako opravi Isak Jakova, i on pođe u Padan-Aram k Lavanu sinu Vatuila Sirina, bratu Reveke matere Jakovljeve i Isavove. ");
INSERT INTO srp1865_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","A Isav vide gde Isak blagoslovi Jakova i opravi ga u Padan-Aram da se odande oženi, i gde blagosiljajući ga zapovedi mu i reče: Nemoj da se oženiš kojom između kćeri hananejskih, ");
INSERT INTO srp1865_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","i gde Jakov posluša oca svog i mater svoju, i otide u Padan-Aram; ");
INSERT INTO srp1865_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","i vide Isav da kćeri hananejske nisu po volji Isaku ocu njegovom. ");
INSERT INTO srp1865_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Pa otide Isav k Ismailu, i uze za ženu preko žena svojih Maeletu, kćer Ismaila sina Avramovog, sestru Naveotovu. ");
INSERT INTO srp1865_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","A Jakov otide od Virsaveje idući u Haran. ");
INSERT INTO srp1865_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I dođe na jedno mesto, i onde zanoći, jer sunce beše zašlo; i uze kamen na onom mestu, i metnu ga sebi pod glavu, i zaspa na onom mestu. ");
INSERT INTO srp1865_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I usni, a to lestve stajahu na zemlji a vrhom ticahu u nebo, i gle, anđeli Božji po njima se penjahu i silažahu; ");
INSERT INTO srp1865_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","i gle, na vrhu stajaše Gospod, i reče: Ja sam Gospod Bog Avrama oca tvog i Bog Isakov; tu zemlju na kojoj spavaš tebi ću dati i semenu tvom; ");
INSERT INTO srp1865_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","i semena će tvog biti kao praha na zemlji, te ćeš se raširiti na zapad i na istok i na sever i na jug, i svi narodi na zemlji blagosloviće se u tebi i u semenu tvom. ");
INSERT INTO srp1865_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","I evo, ja sam s tobom, i čuvaću te kuda god pođeš, i dovešću te natrag u ovu zemlju, jer te neću ostaviti dokle god ne učinim šta ti rekoh. ");
INSERT INTO srp1865_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","A kad se Jakov probudi od sna, reče: Zacelo je Gospod na ovom mestu; a ja ne znah. ");
INSERT INTO srp1865_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I uplaši se, i reče: Kako je strašno mesto ovo! Ovde je doista kuća Božja, i ovo su vrata nebeska. ");
INSERT INTO srp1865_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","I usta Jakov ujutru rano, i uze kamen što beše metnuo sebi pod glavu, i utvrdi ga za spomen i preli ga uljem. ");
INSERT INTO srp1865_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","I prozva ono mesto Vetilj, a pre beše ime onom gradu Luz. ");
INSERT INTO srp1865_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","I učini Jakov zavet, govoreći: Ako Bog bude sa mnom i sačuva me na putu kojim idem i da mi hleba da jedem i odela da se oblačim, ");
INSERT INTO srp1865_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","i ako se vratim na miru u dom oca svog, Gospod će mi biti Bog; ");
INSERT INTO srp1865_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","a kamen ovaj koji utvrdih za spomen biće dom Božji; i šta mi god daš, od svega ću deseto dati Tebi. ");
INSERT INTO srp1865_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Tada se podiže Jakov i otide u zemlju istočnu. ");
INSERT INTO srp1865_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","I obzirući se ugleda studenac u polju; i gle, tri stada ovaca ležahu kod njega, jer se na onom studencu pojahu stada, a veliki kamen beše studencu na vratima. ");
INSERT INTO srp1865_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Onde se skupljahu sva stada, te pastiri odvaljivahu kamen s vrata studencu i pojahu stada, i posle opet privaljivahu kamen na vrata studencu na njegovo mesto. ");
INSERT INTO srp1865_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","I Jakov im reče: Braćo, odakle ste? Rekoše: Iz Harana smo. ");
INSERT INTO srp1865_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A on im reče: Poznajete li Lavana sina Nahorovog? Oni rekoše: Poznajemo. ");
INSERT INTO srp1865_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","On im reče: Je li zdrav? Rekoše: Jeste, i evo Rahilje kćeri njegove, gde ide sa stadom. ");
INSERT INTO srp1865_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","I on reče: Eto još je rano, niti je vreme vraćati stoku; napojte stoku pa idite i pasite je. ");
INSERT INTO srp1865_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","A oni rekoše: Ne možemo, dokle se ne skupe sva stada, da odvalimo kamen s vrata studencu, onda ćemo napojiti stoku. ");
INSERT INTO srp1865_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Dok on još govoraše s njima, dođe Rahilja sa stadom oca svog, jer ona pasaše ovce. ");
INSERT INTO srp1865_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","A kad Jakov vide Rahilju kćer Lavana ujaka svog, i stado Lavana ujaka svog, pristupi Jakov i odvali kamen studencu s vrata, i napoji stado Lavana ujaka svog. ");
INSERT INTO srp1865_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","I poljubi Jakov Rahilju, i povikavši zaplaka se. ");
INSERT INTO srp1865_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","I kaza se Jakov Rahilji da je rod ocu njenom i da je sin Revečin; a ona otrča te javi ocu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","A kad Lavan ču za Jakova sina sestre svoje, istrča mu na susret, i zagrli ga i poljubi, i uvede u svoju kuću. I on pripovedi Lavanu sve ovo. ");
INSERT INTO srp1865_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","A Lavan mu reče: Ta ti si kost moja i telo moje. I osta kod njega ceo mesec dana. ");
INSERT INTO srp1865_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Tada reče Lavan Jakovu: Zar badava da mi služiš, što si mi rod? Kaži mi šta će ti biti plata? ");
INSERT INTO srp1865_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","A Lavan imaše dve kćeri: starijoj beše ime Lija, a mlađoj Rahilja. ");
INSERT INTO srp1865_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","I u Lije behu kvarne oči, a Rahilja beše lepog stasa i lepog lica. ");
INSERT INTO srp1865_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","I Jakovu omile Rahilja, te reče: Služiću ti sedam godina za Rahilju, mlađu kćer tvoju. ");
INSERT INTO srp1865_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","A Lavan mu reče: Bolje tebi da je dam nego drugom; ostani kod mene. ");
INSERT INTO srp1865_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","I odsluži Jakov za Rahilju sedam godina, i učiniše mu se kao nekoliko dana, jer je ljubljaše. ");
INSERT INTO srp1865_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","I reče Jakov Lavanu: Daj mi ženu, jer mi se navrši vreme, da legnem s njom. ");
INSERT INTO srp1865_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","I sazva Lavan sve ljude iz onog mesta i učini gozbu. ");
INSERT INTO srp1865_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","A uveče uze Liju kćer svoju i uvede je k Jakovu, i on leže s njom. ");
INSERT INTO srp1865_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","I Lavan dade Zelfu robinju svoju Liji kćeri svojoj da joj bude robinja. ");
INSERT INTO srp1865_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","A kad bi ujutru, gle, ono beše Lija; te reče Jakov Lavanu: Šta si mi to učinio? Ne služim li za Rahilju kod tebe? Zašto si me prevario? ");
INSERT INTO srp1865_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","A Lavan mu reče: Ne biva u našem mestu da se uda mlađa pre starije. ");
INSERT INTO srp1865_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Navrši nedelju dana s tom, pa ćemo ti dati i drugu za službu što ćeš služiti kod mene još sedam godina drugih. ");
INSERT INTO srp1865_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakov učini tako, i navrši s njom nedelju dana, pa mu dade Lavan Rahilju kćer svoju za ženu. ");
INSERT INTO srp1865_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","I dade Lavan Rahilji kćeri svojoj robinju svoju Valu da joj bude robinja. ");
INSERT INTO srp1865_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","I tako leže Jakov s Rahiljom; i voljaše Rahilju nego Liju, i stade služiti kod Lavana još sedam drugih godina. ");
INSERT INTO srp1865_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","A Gospod videći da Jakov ne mari za Liju, otvori njoj matericu, a Rahilja osta nerotkinja. ");
INSERT INTO srp1865_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","I Lija zatrudne, i rodi sina, i nadede mu ime Ruvim, govoreći: Gospod pogleda na jade moje, sada će me ljubiti muž moj. ");
INSERT INTO srp1865_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","I opet zatrudne, i rodi sina i reče: Gospod ču da sam prezrena, pa mi dade i ovog. I nadede mu ime Simeun. ");
INSERT INTO srp1865_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","I opet zatrudne, i rodi sina, i reče: Da ako se sada već priljubi k meni muž moj, kad mu rodih tri sina. Zato mu nadeše ime Levije. ");
INSERT INTO srp1865_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","I zatrudne opet, i rodi sina, i reče: Sada ću hvaliti Gospoda. Zato mu nadede ime Juda; i presta rađati. ");
INSERT INTO srp1865_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","A Rahilja videvši gde ne rađa dece Jakovu, pozavide sestri svojoj; i reče Jakovu: Daj mi dece, ili ću umreti. ");
INSERT INTO srp1865_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","A Jakov se rasrdi na Rahilju, i reče: Zar sam ja a ne Bog koji ti ne da poroda? ");
INSERT INTO srp1865_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","A ona reče: Eto robinje moje Vale, lezi s njom, neka rodi na mojim kolenima, pa ću i ja imati dece od nje. ");
INSERT INTO srp1865_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","I dade mu Valu robinju svoju za ženu, i Jakov leže s njom. ");
INSERT INTO srp1865_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","I zatrudne Vala, i rodi Jakovu sina. ");
INSERT INTO srp1865_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","A Rahilja reče: Gospod mi je sudio i čuo glas moj, te mi dade sina. Zato mu nadede ime Dan. ");
INSERT INTO srp1865_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","I Vala robinja Rahiljina zatrudne opet, i rodi drugog sina Jakovu; ");
INSERT INTO srp1865_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","a Rahilja reče: Borah se žestoko sa sestrom svojom, ali odoleh. I nadede mu ime Neftalim. ");
INSERT INTO srp1865_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","A Lija videvši gde presta rađati uze Zelfu robinju svoju i dade je Jakovu za ženu. ");
INSERT INTO srp1865_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","I rodi Zelfa robinja Lijina Jakovu sina; ");
INSERT INTO srp1865_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","i Lija reče: Dođe četa. I nadede mu ime Gad. ");
INSERT INTO srp1865_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Opet rodi Zelfa robinja Lijina drugog sina Jakovu; ");
INSERT INTO srp1865_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","i reče Lija: Blago meni, jer će me blaženom zvati žene. Zato mu nadede ime Asir. ");
INSERT INTO srp1865_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","A Ruvim iziđe u vreme žetve pšenične i nađe mandragoru u polju, i donese je Liji materi svojoj. A Rahilja reče Liji: Daj mi mandragoru sina svog. ");
INSERT INTO srp1865_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","A ona joj reče: Malo li ti je što si mi uzela muža? Hoćeš da mi uzmeš i mandragoru sina mog? A Rahilja joj reče: Neka noćas spava s tobom za mandragoru sina tvog. ");
INSERT INTO srp1865_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","I uveče kad se Jakov vraćaše iz polja, iziđe mu Lija na susret i reče: Spavaćeš kod mene, jer te kupih za mandragoru sina svog. I spava kod nje onu noć. ");
INSERT INTO srp1865_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","A Bog usliši Liju, te ona zatrudne, i rodi Jakovu petog sina. ");
INSERT INTO srp1865_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","I reče Lija: Gospod mi dade platu moju što dadoh robinju svoju mužu svom. I nadede mu ime Isahar. ");
INSERT INTO srp1865_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","I zatrudne Lija opet, i rodi Jakovu šestog sina; ");
INSERT INTO srp1865_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","i reče Lija: Dariva me Gospod darom dobrim; da ako se sada već priljubi k meni muž moj, jer mu rodih šest sinova. Zato mu nadede ime Zavulon. ");
INSERT INTO srp1865_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Najposle rodi kćer, i nadede joj ima Dina. ");
INSERT INTO srp1865_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ali se Gospod opomenu Rahilje; i uslišivši je otvori joj matericu. ");
INSERT INTO srp1865_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","I zatrudne, i rodi sina, i reče: Uze Bog sramotu moju. ");
INSERT INTO srp1865_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","I nadede mu ime Josif, govoreći: Neka mi doda Gospod još jednog sina. ");
INSERT INTO srp1865_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","A kad Rahilja rodi Josifa, reče Jakov Lavanu: Pusti me da idem u svoje mesto i u svoju zemlju. ");
INSERT INTO srp1865_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Daj mi žene moje, za koje sam ti služio, i decu moju, da idem, jer znaš kako sam ti služio. ");
INSERT INTO srp1865_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","A Lavan mu reče: Nemoj, ako sam našao milost pred tobom; vidim da me je blagoslovio Gospod tebe radi. ");
INSERT INTO srp1865_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","I još reče: Išti koliko hoćeš plate, i ja ću ti dati. ");
INSERT INTO srp1865_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","A Jakov mu odgovori: Ti znaš kako sam ti služio i kakva ti je stoka postala kod mene. ");
INSERT INTO srp1865_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Jer je malo bilo što si imao dokle ja ne dođoh; ali se umnoži veoma, jer te Gospod blagoslovi kad ja dođoh. Pa kad ću i ja tako sebi kuću kućiti? ");
INSERT INTO srp1865_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","I reče mu Lavan: Šta hoćeš da ti dam? A Jakov odgovori: Ne treba ništa da mi daš; nego ću ti opet pasti stoku i čuvati, ako ćeš mi učiti ovo: ");
INSERT INTO srp1865_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Da zađem danas po svoj stoci tvojoj, i odlučim sve što je šareno i s belegom, i sve što je crno između ovaca, i šta je s belegom i šareno između koza, pa šta posle bude tako, ono da mi je plata. ");
INSERT INTO srp1865_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tako će mi se posle posvedočiti pravda moja pred tobom kad dođeš da vidiš zaslugu moju: Šta god ne bude šareno ni s belegom ni crno između ovaca i koza u mene, biće kradeno. ");
INSERT INTO srp1865_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","A Lavan reče: Eto, neka bude kako si kazao. ");
INSERT INTO srp1865_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","I odluči Lavan isti dan jarce s belegom i šarene i sve koze s belegom i šarene, i sve na čem beše šta belo, i sve crno između ovaca, i predade sinovima svojim. ");
INSERT INTO srp1865_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","I ostavi daljine tri dana hoda između sebe i Jakova. I Jakov pasaše ostalu stoku Lavanovu. ");
INSERT INTO srp1865_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","I uze Jakov zelenih prutova topolovih i leskovih i kestenovih, i naguli ih do beline koja beše na prutovima. ");
INSERT INTO srp1865_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","I metaše naguljene prutove pred stoku u žlebove i korita kad dolažaše stoka da pije, da bi se upaljivala kad dođe da pije. ");
INSERT INTO srp1865_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","I upaljivaše se stoka gledajući u prutove, i šta se mlađaše beše s belegom, prutasto i šareno. ");
INSERT INTO srp1865_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","I Jakov odlučivaše mlad, i obraćaše stado Lavanovo da gleda u šarene i u sve crne; a svoje stado odvajaše i ne obraćaše ga prema stadu Lavanovom. ");
INSERT INTO srp1865_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","I kad se god upaljivaše stoka rana, metaše Jakov prutove u korita pred oči stoci da bi se upaljivala gledajući u prutove; ");
INSERT INTO srp1865_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","a kad se upaljivaše pozna stoka, ne metaše; tako pozne bivahu Lavanove a rane Jakovljeve. ");
INSERT INTO srp1865_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","I tako se taj čovek obogati vrlo, te imaše mnogo stoke i sluga i sluškinja i kamila i magaraca. ");
INSERT INTO srp1865_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","A Jakov ču gde sinovi Lavanovi govore: Jakov uze sve što beše našeg oca, i od onog što beše našeg oca steče sve ovo blago. ");
INSERT INTO srp1865_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","I vide Jakov gde lice Lavanovo nije prema njemu kao pre. ");
INSERT INTO srp1865_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","I Gospod reče Jakovu: Vrati se u zemlju otaca svojih i u rod svoj, i ja ću biti s tobom. ");
INSERT INTO srp1865_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","I poslavši Jakov dozva Rahilju i Liju u polje k stadu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","I reče im: Vidim gde lice oca vašeg nije prema meni kao pre; ali je Bog oca mog bio sa mnom. ");
INSERT INTO srp1865_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","I vi znate da sam služio ocu vašem kako sam god mogao; ");
INSERT INTO srp1865_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","a otac me je vaš varao i menjao mi platu deset puta; ali mu Bog ne dade da me ošteti; ");
INSERT INTO srp1865_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","kad on reče: Šta bude šareno neka ti je plata, onda se mladilo sve šareno; a kad reče: S belegom šta bude neka ti je plata, onda se mladilo sve s belegom. ");
INSERT INTO srp1865_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tako Bog uze stoku ocu vašem i dade je meni; ");
INSERT INTO srp1865_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","jer kad se upaljivaše stoka, podigoh oči svoje i videh u snu, a to ovnovi i jarci što skaču na ovce i koze behu šareni, s belegama prutastim i kolastim. ");
INSERT INTO srp1865_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","A anđeo Gospodnji reče mi u snu: Jakove! A ja odgovorih: Evo me. ");
INSERT INTO srp1865_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A on reče: Podigni sad oči svoje i gledaj, ovnovi i jarci što skaču na ovce i koze, šareni su, s belegama prutastim i kolastim; jer videh sve što ti čini Lavan. ");
INSERT INTO srp1865_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ja sam Bog od Vetilja, gde si prelio kamen i učinio mi zavet; ustani sada i idi iz ove zemlje, i vrati se na postojbinu svoju. ");
INSERT INTO srp1865_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tada odgovori Rahilja i Lija, i rekoše mu: Eda li još imamo kakav deo i nasledstvo u domu oca svog? ");
INSERT INTO srp1865_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nije li nas držao kao tuđinke kad nas je prodao? Pa je još i naše novce jednako jeo. ");
INSERT INTO srp1865_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Jer sve ovo blago što uze Gospod ocu našem, naše je i naše dece. Zato čini sve što ti je Gospod kazao. ");
INSERT INTO srp1865_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","I podiže se Jakov, i metnu decu svoju i žene svoje na kamile; ");
INSERT INTO srp1865_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","i odvede svu stoku svoju i sve blago što beše stekao, stoku koju beše stekao u Padan-Aramu, i pođe k Isaku ocu svom u zemlju hanansku. ");
INSERT INTO srp1865_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","A Lavan beše otišao da striže ovce svoje; i Rahilja ukrade idole ocu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","I Jakov otide kradom od Lavana Sirina ne javivši mu da hoće da ide. ");
INSERT INTO srp1865_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","I pobeže sa svim blagom svojim, i podiže se te pređe preko vode, i uputi se ka gori Galadu. ");
INSERT INTO srp1865_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","A treći dan javiše Lavanu da je pobegao Jakov. ");
INSERT INTO srp1865_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","I uze sa sobom braću svoju, i pođe za njim u poteru, i za sedam dana stiže ga na gori Galadu. ");
INSERT INTO srp1865_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ali Bog dođe Lavanu Sirinu noću u snu, i reče mu: Čuvaj se da ne govoriš s Jakovom ni lepo ni ružno. ");
INSERT INTO srp1865_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","I stiže Lavan Jakova; a Jakov beše razapeo šator svoj na gori, pa i Lavan takođe razape svoj s braćom svojom na gori Galadu. ");
INSERT INTO srp1865_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","I Lavan reče Jakovu: Šta učini te kradom pobeže od mene i odvede kćeri moje kao na mač otete? ");
INSERT INTO srp1865_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Zašto tajno pobeže i kradom otide od mene? Niti mi reče da te ispratim s veseljem i s pesmama, s bubnjevima i guslama? ");
INSERT INTO srp1865_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Niti mi dade da izljubim sinove svoje i kćeri svoje? Ludo si radio. ");
INSERT INTO srp1865_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mogao bih vam dosaditi; ali Bog oca vašeg noćas mi reče govoreći: Čuvaj se da ne govoriš s Jakovom ni lepo ni ružno. ");
INSERT INTO srp1865_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Idi dakle kad si se tako uželeo kuće oca svog; ali zašto ukrade bogove moje? ");
INSERT INTO srp1865_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","A Jakov odgovori i reče: Bojah se i mišljah hoćeš silom oteti kćeri svoje od mene. ");
INSERT INTO srp1865_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","A bogove svoje u koga nađeš, onaj neka ne živi više; pred našom braćom traži šta je tvoje u mene, pa uzmi. Jer Jakov nije znao da ih je ukrala Rahilja. ");
INSERT INTO srp1865_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","I uđe Lavan u šator Jakovljev i u šator Lijin i u šator dveju robinja, i ne nađe ih; i izašav iz šatora Lijina uđe u šator Rahiljin. ");
INSERT INTO srp1865_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","A Rahilja uze idole i sakri ih pod samar kamile svoje i sede ozgo; i Lavan pipaše po celom šatoru, i ne nađe. ");
INSERT INTO srp1865_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","A ona reče ocu svom: Nemoj se srditi, gospodaru, što ti ne mogu ustati, jer mi je šta u žena biva. Traživši dakle ne nađe idole svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","I Jakov se rasrdi, i stade koriti Lavana, i govoreći reče mu: Šta sam učinio, šta sam skrivio, te si me tako žestoko terao? ");
INSERT INTO srp1865_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Pipao si sav prtljag moj, pa šta si našao iz svoje kuće? Daj ovamo pred moju i svoju braću, neka rasude između nas dvojice. ");
INSERT INTO srp1865_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Evo dvadeset godina bih kod tebe: ovce tvoje i koze tvoje ne jaloviše se, a ovnova iz stada tvog ne jedoh. ");
INSERT INTO srp1865_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Šta bi zverje zaklalo nisam ti donosio, sam sam podmirivao; od mene si iskao što bi mi bilo ukradeno danju ili noću. ");
INSERT INTO srp1865_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Danju me ubijaše vrućina a noću mraz; i san mi ne padaše na oči. ");
INSERT INTO srp1865_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tako mi je bio dvadeset godina u tvojoj kući; služio sam ti četrnaest godina za dva kćeri tvoje i šest godina za stoku tvoju, i platu si mi menjao deset puta. ");
INSERT INTO srp1865_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Da nije Bog oca mog, Bog Avramov, i strah Isakov bio sa mnom, bi me zacelo otpustio prazna. Ali je Bog video nevolju moju i trud ruku mojih, pa te ukori noćas. ");
INSERT INTO srp1865_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","A Lavan odgovori Jakovu i reče: Ove su kćeri moje kćeri, i ovi su sinovi moji sinovi, i ova stoka moja stoka, i šta god vidiš sve je moje; pa šta bih učinio danas kćerima svojim ili sinovima njihovim koje rodiše? ");
INSERT INTO srp1865_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nego hajde da uhvatimo veru, ja i ti, da bude svedočanstvo između mene i tebe. ");
INSERT INTO srp1865_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","I Jakov uze kamen i utvrdi ga za spomen. ");
INSERT INTO srp1865_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","I reče Jakov braći svojoj; nakupite kamenja. I nakupiše kamenja i složiše na gomilu, i jedoše na gomili. ");
INSERT INTO srp1865_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","I Lavan ga nazva Jegar-Sahadut, a Jakov ga nazva Galed. ");
INSERT INTO srp1865_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","I reče Lavan: Ova gomila neka bude svedok između mene i tebe danas. Zato se prozva Galed. ");
INSERT INTO srp1865_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","A prozva se i Mispa, jer reče Lavan: Neka Gospod gleda između mene i tebe, kad ne uzmožemo videti jedan drugog. ");
INSERT INTO srp1865_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ako ucveliš kćeri moje i ako uzmeš žene preko mojih kćeri, neće čovek biti između nas nego gle Bog svedok između mene i tebe. ");
INSERT INTO srp1865_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","I još reče Lavan Jakovu: Gledaj ovu gomilu i gledaj ovaj spomenik, koji podigoh između sebe i tebe. ");
INSERT INTO srp1865_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Svedok je ova gomila i svedok je ovaj spomenik, da ni ja neću preći preko ove gomile k tebi ni ti k meni da nećeš preći preko ove gomile i spomenika ovog na zlo. ");
INSERT INTO srp1865_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bog Avramov i bogovi Nahorovi, bogovi oca njihovog, neka sude među nama. A Jakov se zakle strahom oca svog Isaka. ");
INSERT INTO srp1865_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","I Jakov prinese žrtvu na gori, i sazva braću svoju na večeru; i jedoše pa noćiše na gori. ");
INSERT INTO srp1865_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","A ujutru rano usta Lavan, i izljubi svoju unučad i kćeri svoje, i blagoslovi ih, pa otide, i vrati se u svoje mesto. ");
INSERT INTO srp1865_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","A Jakov otide svojim putem; i sretoše ga anđeli Božiji; ");
INSERT INTO srp1865_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","a kad ih ugleda Jakov, reče: Ovo je logor Božji. I prozva ono mesto Mahanaim. ");
INSERT INTO srp1865_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","I Jakov posla pred sobom glasnike k Isavu bratu svom u zemlju Sir, krajinu edomsku. ");
INSERT INTO srp1865_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I zapovedi im govoreći: Ovako kažite gospodaru mom Isavu: Sluga tvoj Jakov ovako kaže: Bio sam došljak kod Lavana i bavio se do sad. ");
INSERT INTO srp1865_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A imam volova i magaraca, ovaca i sluga, i sluškinja, i poslah da javim tebi gospodaru svom, eda bih našao milost pred tobom. ");
INSERT INTO srp1865_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","I vratiše se glasnici k Jakovu i rekoše mu: Idosmo do brata tvog Isava, i eto on ti ide na susret s četiri stotine momaka. ");
INSERT INTO srp1865_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","A Jakov se uplaši jako i zabrinu se; pa razdeli svoje ljude i ovce i goveda i kamile u dve čete. ");
INSERT INTO srp1865_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I reče: Ako Isav udari na jednu četu i razbije je, da ako druga uteče. ");
INSERT INTO srp1865_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","I reče Jakov: Bože oca mog Avrama i Bože oca mog Isaka, Gospode, koji si mi kazao: Vrati se u zemlju svoju i u rod svoj, i ja ću ti biti dobrotvor! ");
INSERT INTO srp1865_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nisam vredan tolike milosti i tolike vere što si učinio sluzi svom; jer samo sa štapom svojim pređoh preko Jordana, a sada sam gospodar od dve čete. ");
INSERT INTO srp1865_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Izbavi me iz ruke brata mog, iz ruke Isavove, jer se bojim da ne dođe i ubije mene i mater s decom. ");
INSERT INTO srp1865_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","A Ti si kazao: Zaista ja ću ti biti dobrotvor, i učiniću seme tvoje da bude kao peska morskog, koji se ne može izbrojati od množine. ");
INSERT INTO srp1865_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I zanoći onde onu noć, i uze šta mu dođe do ruke, da pošalje na dar Isavu bratu svom, ");
INSERT INTO srp1865_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","dvesta koza s dvadeset jaraca, dvesta ovaca s dvadeset ovnova, ");
INSERT INTO srp1865_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trideset kamila dojilica s kamiladima, četrdeset krava s desetoro teladi, dvadeset magarica s desetoro magaradi. ");
INSERT INTO srp1865_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","I predade ih slugama svojim, svako stado napose, i reče slugama: Idite napred preda mnom, ostavljajući dosta mesta između jednog stada i drugog. ");
INSERT INTO srp1865_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","I zapovedi prvom govoreći: Kad sretneš Isava, brata mog, pa te zapita: Čiji si? I kuda ideš? I čije je to što goniš pred sobom? ");
INSERT INTO srp1865_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A ti reci: Sluge tvog Jakova, a ovo šalje na dar gospodaru svom Isavu, a eto i sam ide za nama. ");
INSERT INTO srp1865_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Tako zapovedi i drugom i trećem i svima koji iđahu za stadom, i reče: Tako kažite Isavu kad naiđete na nj. ");
INSERT INTO srp1865_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","I još kažite: Eto, Jakov sluga tvoj ide za nama. Jer govoraše: Ublažiću ga darom koji ide preda mnom, pa ću mu onda videti lice, da ako me lepo primi. ");
INSERT INTO srp1865_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tako otide dar napred, a on prenoći onu noć kod čete svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","I po noći usta, i uze obe žene i dve robinje i jedanaestoro dece svoje; i prebrodi brod Javok. ");
INSERT INTO srp1865_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","A pošto njih uze i prevede preko potoka, preturi i ostalo što imaše. ");
INSERT INTO srp1865_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A kad osta Jakov sam, tada se jedan čovek rvaše s njim do zore. ");
INSERT INTO srp1865_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","I kad vide da ga ne može svladati, udari ga po zglavku u stegnu, te se Jakovu iščaši stegno iz zglavka, kad se čovek rvaše s njim. ");
INSERT INTO srp1865_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Pa onda reče: Pusti me, zora je. A Jakov mu reče: Neću te pustiti dokle me ne blagosloviš. ");
INSERT INTO srp1865_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","A čovek mu reče: Kako ti je ime. A on odgovori: Jakov. ");
INSERT INTO srp1865_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Tada mu reče: Odsele se nećeš zvati Jakov, nego Izrailj; jer si se junački borio i s Bogom i s ljudima, i odoleo si. ");
INSERT INTO srp1865_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","A Jakov zapita i reče: Kaži mi kako je tebi ime. A On reče: Što pitaš kako mi je ime? I blagoslovi ga onde. ");
INSERT INTO srp1865_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","I Jakov nadede ime onom mestu Fanuil; jer, veli, Boga videh licem k licu, i duša se moja izbavi. ");
INSERT INTO srp1865_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","I sunce mu se rodi kad prođe Fanuil, i hramaše na stegno svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Zato sinovi Izrailjevi ne jedu krajeve od mišića na zglavku u stegnu do današnjeg dana, što se Jakovu povrediše krajevi od mišića na zglavku u stegnu. ");
INSERT INTO srp1865_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","A Jakov podigavši oči svoje pogleda, a to Isav ide, i četiri stotine ljudi s njim. I razdeli decu uz Liju i uz Rahilju i uz dve robinje. ");
INSERT INTO srp1865_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","I namesti napred robinje i njihovu decu, pa Liju i njenu decu za njima, a najposle Rahilju i Josifa. ");
INSERT INTO srp1865_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","A sam prođe napred, i pokloni se do zemlje sedam puta dokle dođe do brata svog. ");
INSERT INTO srp1865_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","A Isav pritrča preda nj i zagrli ga i pade mu oko vrata i celiva ga, i obojica se zaplakaše, ");
INSERT INTO srp1865_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","i Isav podigavši oči ugleda žene i decu, pa reče: Ko su ti ono? A Jakov reče: Deca, koju Bog milostivo darova sluzi tvom. ");
INSERT INTO srp1865_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","I pristupiše robinje s decom svojom, i pokloniše se. ");
INSERT INTO srp1865_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Potom pristupi i Lija i deca njena, i pokloniše se; a najposle pristupi Josif i Rahilja, i pokloniše se. ");
INSERT INTO srp1865_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","A Isav reče: Šta će ti čitava vojska ona koju sretoh? A on reče: Da nađem milost pred gospodarem svojim. ");
INSERT INTO srp1865_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","A Isav reče: Ima, brate, u mene dosta; neka tebi šta je tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","A Jakov reče: Ne; ako sam sada našao milost pred tobom, primi dar iz moje ruke, jer videh lice tvoje kao da videh lice Božje, tako si me lepo dočekao. ");
INSERT INTO srp1865_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Primi dar moj, koji ti je doveden; jer me je obilato obdario Bog, i imam svega. I navali na nj, te primi. ");
INSERT INTO srp1865_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Posle reče Isav: Hajde da idemo, ići ću i ja s tobom. ");
INSERT INTO srp1865_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","A Jakov mu reče: Zna gospodar moj da su ova deca nejaka, i imam ovaca i krava dojilica, pa ako ih usteram jedan dan, poginuće mi sve stado. ");
INSERT INTO srp1865_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nego gospodar moj neka ide pred slugom svojim, a ja ću polako ići, koliko mogu deca i stoka, dokle dođem ka gospodaru svom u Sir. ");
INSERT INTO srp1865_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","A Isav reče: A ono da ti ostavim nekoliko ljudi što su sa mnom. A on reče: Na šta? Daj da nađem milost pred gospodarem svojim. ");
INSERT INTO srp1865_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","I tako Isav vrati se isti dan svojim putem u Sir. ");
INSERT INTO srp1865_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","A Jakov otide u Sokot, i onde načini sebi kuću a stoci svojoj načini staje; zato nazva ono mesto Sokot. ");
INSERT INTO srp1865_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Posle dođe Jakov zdravo u grad Sihem u zemlji hananskoj, vrativši se iz Padan-Arama, i namesti se prema gradu. ");
INSERT INTO srp1865_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","I kupi komad zemlje, gde razape šator svoj, od sinova Emora oca Sihemovog za sto novaca. ");
INSERT INTO srp1865_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","I načini onde žrtvenik, i nazva ga: Silni Bog Izrailjev. ");
INSERT INTO srp1865_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","A Dina kći Lijina, koju rodi Jakovu, izađe da gleda devojke u onom kraju. ");
INSERT INTO srp1865_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","A ugleda je Sihem, sin Emora Efejina, kneza od one zemlje, i uze je i leže s njom i osramoti je. ");
INSERT INTO srp1865_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","I prionu srce njegovo za Dinu kćer Jakovljevu, i devojka mu omile, i on joj se umiljavaše. ");
INSERT INTO srp1865_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","I reče Sihem Emoru ocu svom govoreći: Oženi me ovom devojkom. ");
INSERT INTO srp1865_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","A Jakov ču da je osramotio Dinu kćer njegovu; a sinovi njegovi behu u polju sa stokom njegovom, i Jakov oćute dokle oni ne dođu. ");
INSERT INTO srp1865_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","A Emor otac Sihemov iziđe k Jakovu da se razgovori s njim. ");
INSERT INTO srp1865_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","A kad dođoše sinovi Jakovljevi iz polja i čuše šta je bilo, žao bi ljudima vrlo i razgneviše se veoma, što učini sramotu Izrailju obležav kćer Jakovljevu, kako ne bi valjalo činiti. ");
INSERT INTO srp1865_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Tada im reče Emor govoreći: Sin moj Sihem srcem prionu za vašu kćer; podajte mu je za ženu. ");
INSERT INTO srp1865_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","I oprijateljite se s nama; kćeri svoje udajite za nas i kćerima našim ženite se. ");
INSERT INTO srp1865_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Pa živite s nama, i zemlja će vam biti otvorena; nastanite se i trgujte i držite baštine u njoj. ");
INSERT INTO srp1865_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","I reče Sihem ocu devojčinom i braći joj: Da nađem milost pred vama, i daću šta mi god kažete. ");
INSERT INTO srp1865_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ištite mi koliko god hoćete uzdarja i dara, ja ću dati šta god kažete; samo mi dajte devojku za ženu. ");
INSERT INTO srp1865_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","A sinovi Jakovljevi odgovoriše Sihemu i Emoru ocu njegovom prevarno, jer osramoti Dinu sestru njihovu. ");
INSERT INTO srp1865_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","I rekoše im: Ne možemo to učiniti ni dati sestre svoje za čoveka neobrezanog, jer je to sramota nama. ");
INSERT INTO srp1865_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nego ćemo vam učiniti po volji, ako ćete se izjednačiti s nama i obrezati sve muškinje između sebe. ");
INSERT INTO srp1865_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Onda ćemo udavati svoje kćeri za vas i ženićemo se vašim kćerima, i postaćemo jedan narod. ");
INSERT INTO srp1865_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ako li ne pristanete da se obrežete, mi ćemo uzeti svoju devojku i otići ćemo. ");
INSERT INTO srp1865_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","I po volji biše reči njihove Emoru i Sihemu sinu Emorovom. ");
INSERT INTO srp1865_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","I momak ne oklevaše učiniti to; jer mu kći Jakovljeva omile veoma; i on beše najviše poštovan između svih u kući oca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","I otide Emor i sin mu Sihem na vrata grada svog, i rekoše građanima govoreći: ");
INSERT INTO srp1865_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ovi ljudi hoće mirno da žive s nama, da se nastane u ovoj zemlji i da trguju po njoj; a evo zemlja je široka i za njih; pa ćemo se kćerima njihovim ženiti i svoje ćemo kćeri udavati za njih. ");
INSERT INTO srp1865_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ali će tako pristati da žive s nama i da postanemo jedan narod, ako se sve muškinje među nama obrežu, kao što su oni obrezani. ");
INSERT INTO srp1865_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Njihova stoka i njihovo blago i sva goveda njihova neće li biti naša? Složimo se samo s njima, pa će ostati kod nas. ");
INSERT INTO srp1865_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","I koji izlažahu na vrata grada njegovog, svi poslušaše Emora i Sihema sina njegovog; i obreza se sve muškinje, svi koji izlažahu na vrata grada njegovog. ");
INSERT INTO srp1865_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A treći dan kad oni behu u bolovima, uzeše dva sina Jakovljeva Simeun i Levije, braća Dinina, svaki svoj mač i uđoše slobodno u grad i pobiše sve muškinje. ");
INSERT INTO srp1865_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ubiše i Emora i sina mu Sihema oštrim mačem, i uzevši Dinu iz kuće Sihemove otidoše. ");
INSERT INTO srp1865_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Tada dođoše sinovi Jakovljevi na pobijene, i opleniše grad, jer u njemu bi osramoćena sestra njihova. ");
INSERT INTO srp1865_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","I uzeše ovce njihove i goveda njihova i magarce njihove, šta god beše u gradu i šta bod beše u polju. ");
INSERT INTO srp1865_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","I sve blago njihovo, i svu decu i žene njihove pohvataše i odvedoše, i šta god beše u kojoj kući. ");
INSERT INTO srp1865_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","A Jakov reče Simeunu i Leviju; smetoste me, i omraziste me narodu ove zemlje, Hananejima i Ferezejima; u mene ima malo ljudi, pa ako se skupe na me, hoće me ubiti te ću se istrebiti ja i dom moj. ");
INSERT INTO srp1865_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","A oni rekoše: Zar sa sestrom našom da rade kao s kurvom? ");
INSERT INTO srp1865_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","A Bog reče Jakovu: Ustani, idi gore u Vetilj i onde stani; i načini onde žrtvenik Bogu, koji ti se javio kad si bežao od Isava brata svog. ");
INSERT INTO srp1865_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","I Jakov reče porodici svojoj i svima koji behu s njim: Bacite tuđe bogove što su u vas, i očistite se i preobucite se; ");
INSERT INTO srp1865_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","pa da se dignemo i idemo gore u Vetilj, da načinim onde žrtvenik Bogu, koji me čuo u dan nevolje moje i bio sa mnom na putu kojim sam išao. ");
INSERT INTO srp1865_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","I dadoše Jakovu sve bogove tuđe koji behu u njihovim rukama, i oboce, koje imahu u ušima; i Jakov ih zakopa pod hrastom kod Sihema. ");
INSERT INTO srp1865_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Potom otidoše. A strah Božji dođe na gradove koji behu oko njih, te se ne digoše u poteru za sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","I Jakov i sva čeljad što beše s njim dođoše u Luz u zemlji hananskoj, a to je Vetilj. ");
INSERT INTO srp1865_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","I onde načini žrtvenik, i nazva ono mesto: Bog vetiljski, jer mu se onde javi Bog, kad je bežao od brata svog. ");
INSERT INTO srp1865_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tada umre Devora dojkinja Revečina, i pogreboše je ispod Vetilja pod hrastom, koji nazva Jakov Alon-Vakut. ");
INSERT INTO srp1865_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","I javi se Bog Jakovu opet, pošto iziđe iz Padan-Arama, i blagoslovi ga, ");
INSERT INTO srp1865_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","i reče mu Bog: Ime ti je Jakov; ali se odsele nećeš zvati Jakov, nego će ti ime biti Izrailj. I nadede mu ime Izrailj. ");
INSERT INTO srp1865_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","I još mu reče Bog: Ja sam Bog Svemogući; rasti i množi se; narod i mnogi će narodi postati od tebe, i carevi će izaći iz bedara tvojih. ");
INSERT INTO srp1865_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","I daću ti zemlju koju sam dao Avramu i Isaku, i nakon tebe semenu tvom daću zemlju ovu. ");
INSERT INTO srp1865_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Potom otide od njega Bog s mesta gde mu govori. ");
INSERT INTO srp1865_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","A Jakov metnu spomenik na istom mestu gde mu Bog govori, spomenik od kamena, i pokropi ga kropljenjem, i preli ga uljem. ");
INSERT INTO srp1865_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","I Jakov prozva mesto gde mu govori Bog Vetilj. ");
INSERT INTO srp1865_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","I otidoše od Vetilja. A kad im osta još malo puta do Efrate, porodi se Rahilja, i beše joj težak porođaj. ");
INSERT INTO srp1865_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","I kad se veoma mučaše, reče joj babica: Ne boj se, imaćeš još jednog sina. ");
INSERT INTO srp1865_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","A kad se rastavljaše s dušom te umiraše, nazva ga Venonija; ali mu otac nadede ime Venijamin. ");
INSERT INTO srp1865_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","I umre Rahilja, i pogreboše je na putu koji ide u Efratu, a to je Vitlejem. ");
INSERT INTO srp1865_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","I metnu Jakov spomenik na grob njen. To je spomenik na grobu Rahiljinom do današnjeg dana. ");
INSERT INTO srp1865_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Odatle otišavši Izrailj razape šator svoj iza kule migdol-ederske. ");
INSERT INTO srp1865_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","I kad Izrailj živeše u onoj zemlji, otide Ruvim i leže s Valom inočom oca svog. I to doču Izrailj. A imaše Jakov dvanaest sinova. ");
INSERT INTO srp1865_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Sinovi Lijini behu: Ruvim prvenac Jakovljev, i Simeun i Levije i Juda i Isahar i Zavulon; ");
INSERT INTO srp1865_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","a sinovi Rahiljini: Josif i Venijamin; ");
INSERT INTO srp1865_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","a sinovi Vale robinje Rahiljine: Dan i Neftalim; ");
INSERT INTO srp1865_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","a sinovi Zelfe robinje Lijine: Gad i Asir. To su sinovi Jakovljevi, koji mu se rodiše u Padan-Aramu. ");
INSERT INTO srp1865_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","I Jakov dođe k Isaku ocu svom u Mamriju u Kirijat-Arvu, koje je Hevron, gde Avram i Isak behu došljaci. ");
INSERT INTO srp1865_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","A Isaku beše sto i osamdeset godina; ");
INSERT INTO srp1865_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","i onemoćav umre Isak, i bi pribran k rodu svom star i sit života; i pogreboše ga Isav i Jakov sinovi njegovi. ");
INSERT INTO srp1865_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","A ovo je pleme Isavovo, a on je Edom. ");
INSERT INTO srp1865_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isav se oženi između kćeri hananejskih Adom kćerju Eloma Hetejina, i Olivemom kćerju Ane sina Sevegona Evejina, ");
INSERT INTO srp1865_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","i Vasematom kćerju Ismailovom, sestrom Naveotovom. ");
INSERT INTO srp1865_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","I rodi Ada Isavu Elifasa, a Vasemata rodi Raguila. ");
INSERT INTO srp1865_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","A Olivema rodi Jeusa i Jegloma i Koreja. To su sinovi Isavovi, koji mu se rodiše u zemlji hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","I Isav uze žene svoje i sinove svoje i kćeri svoje i sve domašnje svoje, i stada svoja i svu stoku svoju i sve blago svoje što beše stekao u zemlji hananskoj; pa otide u drugu zemlju daleko od Jakova brata svog. ");
INSERT INTO srp1865_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Jer im blago beše vrlo veliko, te ne mogahu živeti zajedno; niti ih zemlja gde behu došljaci mogaše nositi od množine stoke njihove. ");
INSERT INTO srp1865_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","I Isav živeše na planini Siru Isav je Edom. ");
INSERT INTO srp1865_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","A ovo je pleme Isava oca Edomcima na planini Siru. ");
INSERT INTO srp1865_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ovo su imena sinova Isavovih: Elifas sin Ade žene Isavove, i Ratuilo sin Vasemate žene Isavove. ");
INSERT INTO srp1865_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","A Elifasovi sinovi behu: Teman, Omar, Sofar, Gotom i Kenez. ");
INSERT INTO srp1865_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","A Tamna beše inoča Elifasu sinu Isavovom, i rodi Elifasu Amalika. To su sinovi Ade žene Isavove. ");
INSERT INTO srp1865_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","A ovo su sinovi Raguilovi: Nahot, Zare, Some i Moze. To behu sinovi Vasemate, žene Isavove. ");
INSERT INTO srp1865_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","A ovo su sinovi Oliveme kćeri Ane sina Sevegonovog, žene Isavove. Ona rodi Isavu Jeusa i Jegloma i Koreja. ");
INSERT INTO srp1865_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ovo su starešine sinova Isavovih: sinovi Elifasa prvenca Isavovog: starešina Teman, starešina Omar, starešina Sofar, starešina Kenez, ");
INSERT INTO srp1865_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","starešina Korej, starešina Gotim, starešina Amalik. To su starešine od Elifasa u zemlji edomskoj. To su sinovi Adini. ");
INSERT INTO srp1865_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","A sinovi Raguila sina Isavovog: starešina Nahot, starešina Zare, starešina Some, starešina Moze. To su starešine od Raguila u zemlji edomskoj. To su sinovi Vasemate žene Isavove. ");
INSERT INTO srp1865_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","A sinovi Oliveme žene Isavove: starešina Jeus, starešina Jeglom, starešina Korej: to su starešine od Oliveme kćeri Anine, žene Isavove. ");
INSERT INTO srp1865_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","To su sinovi Isavovi, i to su starešine njihove; a on je Edom. ");
INSERT INTO srp1865_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","A ovo su sinovi Sira Horejina, koji živehu u onoj zemlji: Lotan i Soval i Sevegon i Ana, ");
INSERT INTO srp1865_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","i Dison i Asar i Rison. To su starešine Horejima, sinovi Sirovi u zemlji edomskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","A sinovi Lotanovi behu Horije i Emam, a sestra Lotanova beše Tamna. ");
INSERT INTO srp1865_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","A ovo su sinovi Sovalovi: Golam i Manahat i Gevil i Sofar i Omar. ");
INSERT INTO srp1865_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","A ovo su sinovi Sevegonovi: Aije i Ana. A taj je Ana koji pronađe tople izvore u pustinji pasući magarice Sevegona oca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","A ovo su deca Anina: Dison i Olivema kći Anina. ");
INSERT INTO srp1865_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","A ovo su sinovi Disonovi: Amada i Asvan i Itran i Haran. ");
INSERT INTO srp1865_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","A ovo su sinovi Asarovi: Valam i Zavan i Akan. ");
INSERT INTO srp1865_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","A ovo su sinovi Risonovi: Uz i Aran. ");
INSERT INTO srp1865_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","I ovo su starešine Horejima: starešina Lotan, starešina Soval, starešina Sevegon, starešina Ana, ");
INSERT INTO srp1865_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","starešina Dison, starešina Asar, starešina Rison. To su starešine Horejima, kako im starešovahu u zemlji Siru. ");
INSERT INTO srp1865_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","A ovo su carevi koji carovaše u zemlji edomskoj pre nego se zacari car nad sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Carova u edomskoj Valak sin Veorov, a gradu mu beše ime Denava. ");
INSERT INTO srp1865_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","A kad umre Valak, zacari se na njegovo mesto Jovav sin Zarin od Vosore. ");
INSERT INTO srp1865_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","A kad umre Jovav, zacari se na njegovo mesto Asom od zemlje temanovske. ");
INSERT INTO srp1865_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","A kad umre Asom, zacari se na njegovo mesto Adad sin Varadov, koji iseče Madijane u polju moavskom, a gradu mu beše ime Geten. ");
INSERT INTO srp1865_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","A kad umre Adad, zacari se na njegovo mesto Samada, iz Masekasa. ");
INSERT INTO srp1865_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","A kad umre Samada, zacari se na njegovo mesto Saul iz Rovota na reci. ");
INSERT INTO srp1865_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","A kad umre Saul, zacari se na njegovo mesto Valenon sin Ahovorov. ");
INSERT INTO srp1865_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","A kad umre Valenon sin Ahovorov, zacari se na njegovo mesto Adar, a grad mu se zvaše Fogor, a ženi mu beše ime Meteveila, koja beše kći Matraide kćeri Mezevove. ");
INSERT INTO srp1865_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","I ovo su plemena starešinama od Isava po porodicama njihovim, po mestima njihovim, po imenima njihovim: starešina Tamna, starešina Gola, starešina Jeter, ");
INSERT INTO srp1865_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","starešina Olivema, starešina Ila, starešina Finon, ");
INSERT INTO srp1865_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","starešina Kenez, starešina Teman, starešina Mazar, ");
INSERT INTO srp1865_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","starešina Magedilo, starešina Zafoj: to su starešine edomske kako nastavahu u svojoj zemlji. Ovaj Isav bi otac Edomcima. ");
INSERT INTO srp1865_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","A Jakov živeše u zemlji gde mu je otac bio došljak, u zemlji hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ovo su događaji Jakovljevi. Josif kad beše momak od sedamnaest godina, pasaše stoku s braćom svojom, koju rodiše Vala i Zelfa žene oca njegovog; i donošaše Josif zle glasove o njima ocu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","A Izrailj ljubljaše Josifa najvećma izmeću svih sinova svojih, jer mu se rodio pod starost; i načini mu šarenu haljinu. ");
INSERT INTO srp1865_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","A braća videći gde ga otac ljubi najvećma između sve braće njegove, stadoše mrzeti na nj tako da mu ne mogahu lepu reč progovoriti. ");
INSERT INTO srp1865_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Uz to usni Josif san i pripovedi braći svojoj, te oni još većma omrznu na nj. ");
INSERT INTO srp1865_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Jer im reče: Da čujete san što sam snio: ");
INSERT INTO srp1865_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Vezasmo snoplje u polju, pa moj snop usta i ispravi se, a vaši snopovi iđahu unaokolo i klanjahu se snopu mom. ");
INSERT INTO srp1865_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tada mu braća rekoše: Da nećeš još biti car nad nama i zapovedati nam? Stoga još većma stadoše mrzeti na nj radi snova njegovih i radi reči njegovih. ");
INSERT INTO srp1865_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Posle opet usni drugi san, i pripovedi braći svojoj govoreći: Usnih opet san, a to se sunce i mesec i jedanaest zvezda klanjahu meni. ");
INSERT INTO srp1865_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A pripovedi i ocu svom i braći svojoj; ali ga otac prekori i reče mu: Kakav je to san što si snio? Eda li ćemo doći ja i mati tvoja i braća tvoja da se klanjamo tebi do zemlje? ");
INSERT INTO srp1865_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","I zaviđahu mu braća; ali otac njegov čuvaše ove reči. ");
INSERT INTO srp1865_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","A kad braća njegova otidoše da pasu stoku oca svog kod Sihema, ");
INSERT INTO srp1865_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","reče Izrailj Josifu: Ne pasu li braća tvoja stoku kod Sihema? Hajde da te pošaljem k njima. A on reče: Evo me. ");
INSERT INTO srp1865_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","A on mu reče: Idi, vidi kako su braća tvoja i kako je stoka, pa dođi da mi javiš. I opravi ga iz doline hevronske, i on otide put Sihema. ");
INSERT INTO srp1865_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","I čovek jedan nađe ga a on luta po polju; te ga zapita govoreći: Šta tražiš? ");
INSERT INTO srp1865_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","A on reče: Tražim braću svoju; kaži mi, molim te, gde su sa stokom? ");
INSERT INTO srp1865_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","A čovek reče: Otišli su odavde, jer čuh gde rekoše: Hajdemo u Dotaim. I otide Josif za braćom svojom, i nađe ih u Dotaimu. ");
INSERT INTO srp1865_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","A oni ga ugledaše iz daleka; i dok još ne dođe blizu njih, stadoše se dogovarati da ga ubiju, ");
INSERT INTO srp1865_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","i rekoše među sobom: Gle, evo onog što sne sanja. ");
INSERT INTO srp1865_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Hajde sada da ga ubijemo i da ga bacimo u koju od ovih jama, pa ćemo kazati: Ljuta ga je zverka izjela. Onda ćemo videti šta će biti od njegovih snova. ");
INSERT INTO srp1865_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ali Ruvim kad ču to, izbavi ga iz ruku njihovih rekavši: Nemojte da ga ubijemo. ");
INSERT INTO srp1865_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","I još im reče Ruvim: Nemojte krv prolivati; bacite ga u ovu jamu u pustinji, a ne dižite ruke na nj. A on ga htede izbaviti iz ruku njihovih i odvesti k ocu. ");
INSERT INTO srp1865_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","I kad Josif dođe k braći svojoj, svukoše s njega haljinu njegovu, haljinu šarenu, koju imaše na sebi. ");
INSERT INTO srp1865_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","I uhvativši ga baciše ga u jamu; a jama beše prazna, ne beše vode u njoj. ");
INSERT INTO srp1865_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Posle sedoše da jedu. I podigavši oči ugledaše, a to gomila Ismailjaca iđaše od Galada s kamilama natovarenim mirisavog korenja i tamjana i smirne, te nošahu u Misir. ");
INSERT INTO srp1865_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","I reče Juda braći svojoj: Kakva će biti korist što ćemo ubiti brata svog i zatajiti krv njegovu? ");
INSERT INTO srp1865_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Hajde da ga prodamo ovim Ismailjcima pa da ne dižemo ruke svoje na nj, jer nam je brat, naše je telo. I poslušaše ga braća njegova. ");
INSERT INTO srp1865_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Pa kad trgovci madijanski behu pored njih, oni izvukoše i izvadiše Josifa iz jame, i prodadoše Josifa Ismailjcima za dvadeset srebrnika; i oni odvedoše Josifa u Misir. ");
INSERT INTO srp1865_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","A kad se Ruvim vrati k jami, a to nema Josifa u jami; tada razdre haljine svoje, ");
INSERT INTO srp1865_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","pa se vrati k braći svojoj, i reče: Nema deteta; a ja kuda ću? ");
INSERT INTO srp1865_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tada uzeše haljinu Josifovu, i zaklavši jare zamočiše haljinu u krv, ");
INSERT INTO srp1865_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","pa onda poslaše šarenu haljinu ocu njegovom poručivši: Nađosmo ovu haljinu, vidi je li haljina sina tvog ili nije. ");
INSERT INTO srp1865_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","A on je pozna i reče: Sina je mog haljina; ljuta ga je zverka izjela; Josif je doista raskinut. ");
INSERT INTO srp1865_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","I razdre Jakov haljine svoje, i veza kostret oko sebe, i tužaše za sinom svojim dugo vremena. ");
INSERT INTO srp1865_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","I svi sinovi njegovi i sve kćeri njegove ustadoše oko njega tešeći ga, ali se on ne dade utešiti, nego govoraše: S tugom ću u grob leći za sinom svojim. Pa i njegov otac plakaše za njim. ");
INSERT INTO srp1865_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","A Madijani prodadoše ga u Misir Petefriju, dvoraninu Faraonovom, zapovedniku stražarskom. ");
INSERT INTO srp1865_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","A u to vreme dogodi se, te Juda otide od braće svoje i uvrati se kod nekog Odolamejca, kome ime beše Iras. ");
INSERT INTO srp1865_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","I onde vide Juda kćer nekog Hananejca, kome ime beše Sava, i uze je i leže s njom; ");
INSERT INTO srp1865_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","i ona zatrudne i rodi sina, kome nadede ime Ir. ");
INSERT INTO srp1865_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","I opet zatrudnevši rodi sina, kome nadede ime Avnan. ");
INSERT INTO srp1865_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","I opet rodi sina, i nadede mu ime Silom; a Juda beše u Hasvi kad ona toga rodi. ");
INSERT INTO srp1865_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","I Juda oženi prvenca svog Ira devojkom po imenu Tamara. ");
INSERT INTO srp1865_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ali Ir prvenac Judin beše nevaljao pred Gospodom, i ubi ga Gospod. ");
INSERT INTO srp1865_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","A Juda reče Avnanu: Uđi k ženi brata svog i oženi se njom na ime bratovo, da podigneš seme bratu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","A Avnan, znajući da neće biti njegov porod, kad leže sa ženom brata svog prosipaše na zemlju, da ne rodi dece bratu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ali Gospodu ne bi milo što činjaše, te ubi i njega. ");
INSERT INTO srp1865_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","I Juda reče Tamari snasi svojoj: Ostani udovicom u kući oca svog dokle odraste Silom sin moj. Jer govoraše: Da ne umre i on kao braća mu. I otide Tamara, i živeše u kući oca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A kad prođe mnogo vremena, umre kći Savina, žena Judina. I kad se Juda uteši, pođe u Tamnu k ljudima što mu strižahu ovce, sam s Irasom prijateljem svojim Odolamejcem. ");
INSERT INTO srp1865_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","I javiše Tamari govoreći: Eto svekar tvoj ide u Tamnu da striže ovce svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","A ona skide sa sebe udovičko ruho svoje, i uze pokrivalo i pokri lice, i sede na raskršće na putu koji ide u Tamnu. Jer vide da je Silom odrastao, a nju još ne udaše za nj. ");
INSERT INTO srp1865_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","A Juda kada vide, pomisli da je kurva, jer beše pokrila lice svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Pa svrnu s puta k njoj i reče joj: Pusti da legnem s tobom. Jer nije poznao da mu je snaha. A ona reče: Šta ćeš mi dati da legneš sa mnom? ");
INSERT INTO srp1865_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A on reče: Poslaću ti jare iz stada. A ona reče: Ali da mi daš zalog dokle ga ne pošalješ. ");
INSERT INTO srp1865_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","A on reče: Kakav zalog da ti dam? A ona reče: Eto, prsten i rubac, i štap što ti je u ruci. I on joj dade, te leže s njom, i ona zatrudne od njega. ");
INSERT INTO srp1865_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Posle ustavši Tamara otide i skide pokrivalo sa sebe i obuče udovičko ruho. ");
INSERT INTO srp1865_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","A Juda posla jare po prijatelju svom Odolamejcu da mu donese natrag od žene zalog. Ali je on ne nađe. ");
INSERT INTO srp1865_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Pa pitaše ljude po onom mestu gde je ona bila govoreći: Gde je ona kurva što je bila na raskršću na ovom putu? A oni rekoše: Nije ovde bilo kurve. ");
INSERT INTO srp1865_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","I vrati se k Judi i reče: Ne nađoh je, nego još rekoše meštani: Nije ovde bilo kurve. ");
INSERT INTO srp1865_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","A Juda reče: Neka joj, da se ne sramotimo; ja sam slao jare, ali je ti ne nađe. ");
INSERT INTO srp1865_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","A kad prođe do tri meseca dana, javiše Judi govoreći: Tamara snaha tvoja učini preljubu, i evo zatrudne od preljube. A Juda reče: Izvedite je da se spali. ");
INSERT INTO srp1865_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","A kad je povedoše, posla k svekru svom i poruči: S čovekom čije je ovo zatrudnela sam. I reče: Traži čiji je ovaj prsten i rubac i štap. ");
INSERT INTO srp1865_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","A Juda pozna i reče: Pravija je od mene, jer je ne dadoh sinu svom Silomu. I više ne leže s njom. ");
INSERT INTO srp1865_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","A kad dođe vreme da rodi, a to blizanci u utrobi njenoj. ");
INSERT INTO srp1865_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","I kad se porađaše, jedno dete pomoli ruku, a babica uze i veza mu crven konac oko ruke govoreći: Ovaj je prvi. ");
INSERT INTO srp1865_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ali on uvuče ruku, i gle izađe brat njegov, a ona reče: Kako prodre? Prodiranje neka ti bude. I nadeše mu ime Fares. ");
INSERT INTO srp1865_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","A posle izađe brat mu, kome oko ruke beše crveni konac, i nadeše mu ime Zara. ");
INSERT INTO srp1865_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","A Josifa odvedoše u Misir; i Petefrije dvoranin Faraonov, zapovednik stražarski, čovek Misirac, kupi ga od Ismailjaca, koji ga odvedoše onamo. ");
INSERT INTO srp1865_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","I Gospod beše s Josifom, te bi srećan, i živeše u kući gospodara svog Misirca. ");
INSERT INTO srp1865_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","I gospodar njegov vide da je Gospod s njim i da sve što radi Gospod vodi u napredak u ruci njegovoj. ");
INSERT INTO srp1865_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","I Josif steče milost u njega, i dvoraše ga; a najposle postavi ga nad celim domom svojim, i šta god imaše njemu dade u ruke. ");
INSERT INTO srp1865_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","A kad ga postavi nad domom svojim i nad svim što imaše, od tada Gospod blagoslovi dom toga Misirca radi Josifa; i blagoslov Gospodnji beše na svemu što imaše u kući i u polju. ");
INSERT INTO srp1865_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","I ostavi u Josifovim rukama sve što imaše, i ne razbiraše nizašta osim jela koje jeđaše. A Josif beše lepog stasa i lepog lica. ");
INSERT INTO srp1865_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","I dogodi se posle, te se žena gospodara njegovog zagleda u Josifa, i reče: Lezi sa mnom. ");
INSERT INTO srp1865_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","A on ne hte, nego reče ženi gospodara svog: Eto gospodar moj ne razbira nizašta šta je u kući, nego šta god ima dade meni u ruke. ");
INSERT INTO srp1865_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ni sam nije veći od mene u ovoj kući, i ništa ne krije od mene osim tebe, jer si mu žena; pa kako bih učinio tako grdno zlo i Bogu zgrešio? ");
INSERT INTO srp1865_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","I ona govoraše takve reči Josifu svaki dan, ali je ne posluša da legne s njom ni da se bavi kod nje. ");
INSERT INTO srp1865_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","A jedan dan kad dođe Josif u kuću da radi svoj posao, a ne beše nikoga od domašnjih u kući, ");
INSERT INTO srp1865_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ona ga uhvati za haljinu govoreći: Lezi sa mnom. Ali on ostavivši joj u rukama haljinu svoju pobeže i otide. ");
INSERT INTO srp1865_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","A kad ona vide gde joj ostavi u rukama haljinu svoju i pobeže, ");
INSERT INTO srp1865_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","viknu čeljad svoju, i reče im govoreći: Gledajte, doveo nam je čoveka Jevrejina da nas sramoti; dođe k meni da legne sa mnom, a ja povikah glasno; ");
INSERT INTO srp1865_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","a on kad ču gde vičem, ostavi haljinu svoju kod mene i pobeže i otide. ");
INSERT INTO srp1865_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","I ona ostavi haljinu njegovu kod sebe dok mu gospodar dođe kući. ");
INSERT INTO srp1865_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","A tada mu reče ovako govoreći: Sluga Jevrejin, koga si nam doveo, dođe k meni da me osramoti; ");
INSERT INTO srp1865_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","a ja povikah glasno, te on ostavi haljinu svoju kod mene i pobeže. ");
INSERT INTO srp1865_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","A kad gospodar njegov ču reči žene svoje gde mu reče: To mi je učinio sluga tvoj, razgnevi se vrlo. ");
INSERT INTO srp1865_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","I gospodar Josifov uhvati ga, i baci ga u tamnicu, gde ležahu sužnji carski: i bi onde u tamnici. ");
INSERT INTO srp1865_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ali Gospod beše s Josifom i raširi milost svoju nad njim i učini te omile tamničaru. ");
INSERT INTO srp1865_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","I poveri tamničar Josifu sve sužnje u tamnici, i šta je god trebalo onde činiti on uređivaše. ");
INSERT INTO srp1865_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","I tamničar ne nadgledaše ništa što beše u Josifovoj ruci, jer Gospod beše s njim; i šta god činjaše, Gospod vođaše u napredak. ");
INSERT INTO srp1865_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Posle toga dogodi se, te peharnik cara misirskog i hlebar skriviše gospodaru svom, caru misirskom. ");
INSERT INTO srp1865_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","I Faraon se razgnevi na ta dva dvoranina, na starešinu nad peharnicima i na starešinu nad hlebarima; ");
INSERT INTO srp1865_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","i baci ih u tamnicu u kući zapovednika stražarskog, gde Josif beše sužanj. ");
INSERT INTO srp1865_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","A zapovednik stražarski odredi im Josifa da ih služi; i behu dugo u tamnici. ");
INSERT INTO srp1865_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","I usniše san obojica u jednu noć, svaki po značenju svog sna za sebe, i peharnik i hlebar cara misirskog, koji behu sužnji u tamnici. ");
INSERT INTO srp1865_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","I sutradan kad dođe Josif k njima, pogleda ih, a oni behu vrlo neveseli. ");
INSERT INTO srp1865_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Pa zapita dvorane Faraonove, koji behu sužnji s njim u kući gospodara njegovog, i reče: Što ste danas lica neveselog? ");
INSERT INTO srp1865_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","A oni mu rekoše: San usnismo obojica, a nema ko da nam kaže šta znače. A Josif im reče: Šta znače, nije li u Boga? Ali pripovedite mi. ");
INSERT INTO srp1865_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","I starešina nad peharnicima pripovedi san svoj Josifu govoreći: Snih, a preda mnom čokot; ");
INSERT INTO srp1865_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","i na čokotu behu tri loze, i napupi i procvate, i grožđe na njemu uzre; ");
INSERT INTO srp1865_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","a u ruci mi beše čaša Faraonova, te pobrah zrelo grožđe i iscedih ga u čašu Faraonovu, i dodadoh čašu Faraonu. ");
INSERT INTO srp1865_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","A Josif mu reče: Ovo znači: tri su loze tri dana. ");
INSERT INTO srp1865_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Još tri dana, i Faraon brojeći svoje dvorane uzeće i tebe, i opet te postaviti u pređašnju službu, i opet ćeš mu dodavati čašu kao i pre dok si mu bio peharnik. ");
INSERT INTO srp1865_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ali nemoj zaboraviti mene kad budeš u dobru, učini milost i pomeni za me Faraonu, i izvedi me iz ove kuće. ");
INSERT INTO srp1865_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Jer su me ukrali iz zemlje jevrejske, a ovde nisam ništa učinio da me bace u ovu jamu. ");
INSERT INTO srp1865_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","A kad vide starešina nad hlebarima kako lepo kaza san, reče Josifu: i ja snih, a meni na glavi tri kotarice bele; ");
INSERT INTO srp1865_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","i u najgornjoj kotarici beše svakojakih kolača za Faraona, i ptice jeđahu iz kotarice na mojoj glavi. ");
INSERT INTO srp1865_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","A Josif odgovori i reče: Ovo znači: tri kotarice tri su dana. ");
INSERT INTO srp1865_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Još tri dana, i Faraon brojeći dvorane svoje izbaciće te i obesiće te na vešala, i ptice će jesti s tebe meso. ");
INSERT INTO srp1865_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","I kad dođe treći dan, to beše dan u koji se rodio Faraon, i učini Faraon gozbu svim slugama svojim, i naiđe među slugama svojim na starešinu nad peharnicima i na starešinu nad hlebarima; ");
INSERT INTO srp1865_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","i povrati starešinu nad peharnicima u službu da dodaje čašu Faraonu; ");
INSERT INTO srp1865_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","a starešinu nad hlebarima obesi, kao što kaza Josif. ");
INSERT INTO srp1865_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","I starešina nad peharnicima ne opomenu se Josifa, nego ga zaboravi. ");
INSERT INTO srp1865_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","A posle dve godine dana usni Faraon, a on stoji na jednoj reci. ");
INSERT INTO srp1865_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","I gle, iz reke izađe sedam krava lepih i debelih, i stadoše pasti po obali. ");
INSERT INTO srp1865_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","I gle, iza njih izađe iz reke sedam drugih krava, ružnih i mršavih, i stadoše pored onih krava na obali. ");
INSERT INTO srp1865_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","I ove krave ružne i mršave pojedoše onih sedam krava lepih i debelih. U tom se probudi Faraon. ");
INSERT INTO srp1865_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Pa opet zaspav usni drugom, a to sedam klasova izraste iz jednog stabla jedrih i lepih; ");
INSERT INTO srp1865_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","a iza njih isklija sedam klasova malih i šturih; ");
INSERT INTO srp1865_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","pa ovi klasovi mali pojedoše onih sedam velikih i jedrih. U tom se probudi Faraon i vide da je san. ");
INSERT INTO srp1865_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","I kad bi ujutru, on se zabrinu u duhu, i poslavši sazva sve gatare misirske i sve mudrace, i pripovedi im šta je snio; ali niko ne može kazati Faraonu šta znači. ");
INSERT INTO srp1865_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tada progovori starešina nad peharnicima Faraonu i reče: Danas se opomenuh greha svog. ");
INSERT INTO srp1865_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kad se Faraon rasrdi na sluge svoje i baci u tamnicu u kući zapovednika stražarskog mene i starešinu nad hlebarima, ");
INSERT INTO srp1865_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","usnismo jednu noć ja i on, svaki za sebe po značenju sna svog usnismo. ");
INSERT INTO srp1865_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","A onde beše s nama momče Jevrejče, sluga zapovednika stražarskog, i mi mu pripovedismo sne, a on nam kaza šta čiji san znači. ");
INSERT INTO srp1865_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","I zbi se kako nam kaza: mene povrati Faraon u službu, a onog obesi. ");
INSERT INTO srp1865_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tada Faraon posla po Josifa, i brže ga izvedoše iz tamnice, a on se obrija i preobuče se, te izađe pred Faraona. ");
INSERT INTO srp1865_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","A Faraon reče Josifu: Usnih san, pa mi niko ne ume da kaže šta znači; a za tebe čujem da umeš kazivati sne. ");
INSERT INTO srp1865_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","A Josif odgovori Faraonu i reče: To nije u mojoj vlasti, Bog će javiti dobro Faraonu. ");
INSERT INTO srp1865_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","I reče Faraon Josifu: Usnih, a ja stojim kraj reke na obali. ");
INSERT INTO srp1865_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","I gle, iz reke izađe sedam krava debelih i lepih, te stadoše pasti po obali. ");
INSERT INTO srp1865_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","I gle, iza njih izađe sedam drugih krava rđavih, i vrlo ružnih i mršavih, kakvih nisam video u celoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","I ove krave mršave i ružne pojedoše onih sedam debelih, ");
INSERT INTO srp1865_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","i kad im biše u trbuhu, ne poznavaše se da su im u trbuhu, nego opet behu onako ružne kao pre. U tom se probudih. ");
INSERT INTO srp1865_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Pa opet usnih, a to sedam klasova izraste iz jednog stabla jedrih i lepih; ");
INSERT INTO srp1865_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","a iza njih isklija sedam malih, tankih i šturih. ");
INSERT INTO srp1865_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","I ovi tanki klasovi proždreše onih sedam lepih. I ovo pripovedih gatarima, ali mi ni jedan ne zna kazati šta znači. ");
INSERT INTO srp1865_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","A Josif reče Faraonu: Oba su sna Faraonova jednaka; Bog javlja Faraonu šta je naumio. ");
INSERT INTO srp1865_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sedam lepih krava jesu sedam godina, i sedam lepih klasova jesu sedam godina; oba su sna jednaka. ");
INSERT INTO srp1865_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","A sedam krava mršavih i ružnih, što izađoše iza onih, jesu sedam godina; i sedam klasova sitnih i šturih biće sedam godina gladnih. ");
INSERT INTO srp1865_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","To je što rekoh Faraonu: Bog kaže Faraonu šta je naumio. ");
INSERT INTO srp1865_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Evo doći će sedam godina vrlo rodnih svoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","A iza njih nastaće sedam gladnih godina, gde će se zaboraviti sve obilje u zemlji misirskoj, jer će glad satrti zemlju, ");
INSERT INTO srp1865_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","te se neće znati to obilje u zemlji od gladi potonje, jer će biti vrlo velika. ");
INSERT INTO srp1865_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","A što je dva puta uzastopce Faraon snio, to je zato što je zacelo Bog tako naumio, i na skoro će to učiniti Bog. ");
INSERT INTO srp1865_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Nego sada neka potraži Faraon čoveka mudrog i razumnog, pa neka ga postavi nad zemljom misirskom. ");
INSERT INTO srp1865_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","I neka gleda Faraon da postavi starešine po zemlji, i pokupi petinu po zemlji misirskoj za sedam rodnih godina; ");
INSERT INTO srp1865_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","neka skupljaju od svakog žita za rodnih godina koje idu, i neka snesu pod ruku Faraonovu svakog žita u sve gradove, i neka čuvaju, ");
INSERT INTO srp1865_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","da se nađe hrane zemlji za sedam godina gladnih, kad nastanu, da ne propadne zemlja od gladi. ");
INSERT INTO srp1865_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","I ovo se učini dobro Faraonu i svim slugama njegovim. ");
INSERT INTO srp1865_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","I reče Faraon slugama svojim: Možemo li naći čoveka kakav je ovaj, u kome bi duh bio Božji? ");
INSERT INTO srp1865_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pa reče Faraon Josifu: Kad je tebi javio Bog sve ovo, nema nikoga tako mudrog i razumnog kao što si ti. ");
INSERT INTO srp1865_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ti ćeš biti nad domom mojim, i sav će ti narod moj usta ljubiti; samo ću ovim prestolom biti veći od tebe. ");
INSERT INTO srp1865_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","I još reče Faraon Josifu: Evo, postavljam te nad svom zemljom misirskom. ");
INSERT INTO srp1865_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","I skide Faraon prsten s ruke svoje i metnu ga Josifu na ruku, i obuče ga u haljine od tankog platna, i obesi mu zlatnu verižicu o vratu, ");
INSERT INTO srp1865_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","i posadi ga na kola koja behu druga za njegovim, i zapovedi da pred njim viču: Klanjajte se! I da ga je postavio nad svom zemljom misirskom. ");
INSERT INTO srp1865_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","I još reče Faraon Josifu: Ja sam Faraon, ali bez tebe neće niko maći ruke svoje ni noge svoje u svoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","I dade Faraon Josifu ime Psontomfanih, i oženi ga Asenetom kćerju Potifere sveštenika onskog. I pođe Josif po zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","A beše Josifu trideset godina kad izađe pred Faraona cara misirskog. I otišavši od Faraona obiđe svu zemlju misirsku. ");
INSERT INTO srp1865_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","I za sedam rodnih godina rodi zemlja svašta izobila. ");
INSERT INTO srp1865_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","I stade Josif kupiti za tih sedam godina svakog žita što beše po zemlji misirskoj, i snositi žito u gradove; u svaki grad snošaše žito s njiva koje behu oko njega. ");
INSERT INTO srp1865_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tako nakupi Josif žita vrlo mnogo koliko je peska morskog, tako da ga presta meriti, jer mu ne beše broja. ");
INSERT INTO srp1865_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","I dokle još ne nasta gladna godina, rodiše se Josifu dva sina, koje mu rodi Aseneta kći Potifere sveštenika onskog. ");
INSERT INTO srp1865_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","I prvencu nadede Josif ime Manasija, govoreći: Jer mi Bog dade da zaboravim svu muku svoju i sav dom oca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A drugom nadede ime Jefrem, govoreći: Jer mi Bog dade da rastem u zemlji nevolje svoje. ");
INSERT INTO srp1865_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ali prođe sedam godina rodnih u zemlji misirskoj; ");
INSERT INTO srp1865_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","i nasta sedam godina gladnih, kao što je Josif napred kazao. I beše glad po svim zemljama, a po svoj zemlji misirskoj beše hleba. ");
INSERT INTO srp1865_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ali najposle nasta glad i po svoj zemlji misirskoj, i narod povika k Faraonu za hleb; a Faraon reče svima Misircima: Idite k Josifu, pa šta vam on kaže ono činite. ");
INSERT INTO srp1865_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","I kad glad beše po svoj zemlji, otvori Josif sve žitnice, i prodavaše Misircima. I glad posta vrlo velika u zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","I iz svih zemalja dolažahu u Misir k Josifu da kupuju; jer posta glad u svakoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","A Jakov videći da ima žita u Misiru, reče sinovima svojim: Šta gledate jedan na drugog? ");
INSERT INTO srp1865_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I reče: Eto čujem da u Misiru ima žita; idite onamo te nam kupite otuda, da ostanemo živi i ne pomremo. ");
INSERT INTO srp1865_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","I desetorica braće Josifove otidoše da kupe žita u Misiru. ");
INSERT INTO srp1865_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","A Venijamina brata Josifovog ne pusti otac s braćom govoreći: Da ga ne bi zadesilo kako zlo. ");
INSERT INTO srp1865_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","I dođoše sinovi Izrailjevi da kupe žita s ostalima koji dolažahu; jer beše glad u zemlji hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","A Josif upravljaše zemljom, i prodavaše žito svemu narodu po zemlji. I braća Josifova došavši pokloniše mu se licem do zemlje. ");
INSERT INTO srp1865_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","A Josif ugledavši braću pozna ih; ali se učini da ih ne poznaje, i oštro im progovori i reče: Odakle ste došli? A oni rekoše: Iz zemlje hananske, da kupimo hrane. ");
INSERT INTO srp1865_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josif dakle pozna braću svoju; ali oni njega ne poznaše. ");
INSERT INTO srp1865_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","I opomenu se Josif snova koje je snio za njih; i reče im: Vi ste uhode; došli ste da vidite gde je zemlja slaba. ");
INSERT INTO srp1865_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","A oni mu rekoše: Nismo, gospodaru; nego sluge tvoje dođoše da kupe hrane. ");
INSERT INTO srp1865_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Svi smo sinovi jednog čoveka, pošteni ljudi, nikada nisu sluge tvoje bile uhode. ");
INSERT INTO srp1865_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A on im reče: Nije istina, nego ste došli da vidite gde je zemlja slaba. ");
INSERT INTO srp1865_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","A oni rekoše: Nas je bilo dvanaest braće, sluga tvojih, sinova jednog čoveka u zemlji hananskoj; i eno, najmlađi je danas kod oca našeg, a jednog nema više. ");
INSERT INTO srp1865_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","A Josif im reče: Kažem ja da ste vi uhode. ");
INSERT INTO srp1865_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Nego hoću da se uverim ovako: tako živ bio Faraon, nećete izaći odavde dokle ne dođe ovamo najmlađi brat vaš. ");
INSERT INTO srp1865_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Pošljite jednog između sebe neka dovede brata vašeg, a vi ćete ostati ovde u tamnici, pa ću videti je li istina šta govorite; inače ste uhode, tako živ bio Faraon. ");
INSERT INTO srp1865_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","I zatvori ih u tamnicu na tri dana. ");
INSERT INTO srp1865_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A treći dan reče im Josif: Ako ste radi životu, ovo učinite, jer se ja Boga bojim: ");
INSERT INTO srp1865_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ako ste pošteni ljudi, jedan brat između vas neka ostane u tamnici, a vi idite i odnesite žita koliko treba porodicama vašim. ");
INSERT INTO srp1865_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pa onda dovedite k meni najmlađeg brata svog da se posvedoče reči vaše i da ne izginete. I oni učiniše tako. ");
INSERT INTO srp1865_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","I rekoše jedan drugom: Doista se ogrešismo o brata svog, jer videsmo muku duše njegove kad nam se moljaše, pa ga se oglušismo; zato dođe na nas ova muka. ");
INSERT INTO srp1865_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","A Ruvim odgovori im govoreći: Nisam li vam govorio: Nemojte se grešiti o dete? Ali me ne poslušaste; i zato se evo traži od nas krv njegova. ");
INSERT INTO srp1865_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","A oni ne znahu da ih Josif razume, jer se s njim razgovarahu preko tumača. ");
INSERT INTO srp1865_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","A Josif okrete se od njih, i zaplaka se. Potom se opet okrete k njima, i progovori s njima, i uzevši između njih Simeuna veza ga pred njima. ");
INSERT INTO srp1865_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","I zapovedi Josif da im naspu vreće žita, pa i novce šta je koji dao da metnu svakome u vreću, i da im dadu brašnjenice na put. I tako bi učinjeno. ");
INSERT INTO srp1865_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","I natovarivši žito svoje na magarce svoje otidoše. ");
INSERT INTO srp1865_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","A jedan od njih otvoriv svoju vreću da nahrani magarca svog u jednoj gostionici, vide novce svoje ozgo u vreći. ");
INSERT INTO srp1865_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I reče braći svojoj: Ja dobih natrag novce svoje, evo ih u mojoj vreći. I zadrhta srce u njima i uplašiše se govoreći jedan drugom: Šta nam to učini Bog? ");
INSERT INTO srp1865_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","I došavši k Jakovu ocu svom u zemlju hanansku, pripovediše mu sve što im se dogodi, govoreći: ");
INSERT INTO srp1865_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Oštro govoraše s nama čovek, koji zapoveda u onoj zemlji, i dočeka nas kao uhode. ");
INSERT INTO srp1865_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","A kad mu rekosmo: Mi smo pošteni ljudi, nikad nismo bili uhode; ");
INSERT INTO srp1865_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","bilo nas je dvanaest braće, sinova oca našeg; jednog već nema, a najmlađi je danas kod oca našeg u zemlji hananskoj; ");
INSERT INTO srp1865_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","reče nam čovek, koji zapoveda u onoj zemlji: Ovako ću doznati jeste li pošteni ljudi: brata jednog između sebe ostavite kod mene, a šta vam treba za porodice vaše gladi radi, uzmite i idite. ");
INSERT INTO srp1865_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Posle dovedite k meni brata svog najmlađeg, da se uverim da niste uhode nego pošteni ljudi; brata ću vam vratiti, i moći ćete trgovati po ovoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","A kad izručivahu vreće svoje, gle, svakome u vreći behu u zavežljaju novci njegovi; i videvši zavežljaje novaca svojih uplašiše se i oni i otac im. ");
INSERT INTO srp1865_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","I reče im Jakov otac njihov: Potrste mi decu; Josifa nema, Simeuna nema, pa hoćete i Venijamina da uzmete; sve se skupilo na me. ");
INSERT INTO srp1865_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","A Ruvim progovori i reče ocu svom: Dva sina moja ubij, ako ti ga ne dovedem natrag; daj ga u moje ruke, i ja ću ti ga opet dovesti. ");
INSERT INTO srp1865_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","A on reče: Neće ići sin moj s vama, jer je brat njegov umro i on osta sam, pa ako bi ga zadesilo kako zlo na putu na koji ćete ići, svalili bi ste me stara s tugom u grob. ");
INSERT INTO srp1865_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ali glad beše vrlo velika u onoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Pa kad pojedoše žito koje behu doneli iz Misira, reče im otac: Idite opet, i kupite nam malo hrane. ");
INSERT INTO srp1865_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","A Juda mu progovori i reče: Tvrdo nam se zarekao onaj čovek govoreći: Nećete videti lice moje, ako ne bude s vama brat vaš. ");
INSERT INTO srp1865_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ako ćeš pustiti s nama brata našeg, ići ćemo i kupićemo ti hrane. ");
INSERT INTO srp1865_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ako li nećeš pustiti, nećemo ići, jer nam je rekao onaj čovek: Nećete videti lice moje, ako ne bude s vama brat vaš. ");
INSERT INTO srp1865_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","A Izrailj reče: Što mi to zlo učiniste i kazaste čoveku da imate još jednog brata? ");
INSERT INTO srp1865_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","A oni rekoše: Čovek je potanko raspitivao za nas i za rod naš govoreći: Je li vam jošte živ otac? Imate li još braće? A mi mu odgovorismo kako nas pitaše. Jesmo li mogli kako znati da će kazati: Dovedite brata svog? ");
INSERT INTO srp1865_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","I reče Juda Izrailju ocu svom: Pusti dete sa mnom, pa ćemo se podignuti i otići, da ostanemo živi i ne pomremo i mi i ti i naša deca. ");
INSERT INTO srp1865_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ja ti se jamčim za nj, iz moje ga ruke išti; ako ti ga ne dovedem natrag i preda te ne stavim, da sam ti kriv do veka. ");
INSERT INTO srp1865_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Da nismo toliko oklevali, do sada bismo se dva puta vratili. ");
INSERT INTO srp1865_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Onda reče Izrailj otac njihov: Kad je tako, učinite ovo: uzmite šta najlepše ima u ovoj zemlji u svoje vreće, i ponesite čoveku onom dar: malo tamjana i malo meda, mirisavog korenja i smirne, urme i badema. ");
INSERT INTO srp1865_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","A novaca ponesite dvojinom, i uzmite novce što behu ozgo u vrećama vašim i odnesite natrag, može biti da je pogreška. ");
INSERT INTO srp1865_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","I uzmite brata svog, pa ustanite i idite opet k onom čoveku. ");
INSERT INTO srp1865_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","A Bog Svemogući da vam da da nađete milost u onog čoveka, da vam pusti brata vašeg drugog i Venijamina; ako li ostanem bez dece, nek ostanem bez dece. ");
INSERT INTO srp1865_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tada uzevši dare i novaca dvojinom, uzevši i Venijamina, podigoše se i otidoše u Misir, i izađoše pred Josifa. ");
INSERT INTO srp1865_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","A Josif kad vide s njima Venijamina, reče čoveku koji upravljaše kućom njegovom: Odvedi ove ljude u kuću, pa nakolji mesa i zgotovi, jer će u podne sa mnom jesti ovi ljudi. ");
INSERT INTO srp1865_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","I učini čovek kako Josif reče, i uvede ljude u kuću Josifovu. ");
INSERT INTO srp1865_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","A oni se bojahu kad ih čovek vođaše u kuću Josifovu, i rekoše: Za novce koji pre behu metnuti u vreće naše vodi nas, dokle smisli kako će nas okriviti, da nas zarobi i uzme naše magarce. ");
INSERT INTO srp1865_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Pa pristupivši k čoveku koji upravljaše kućom Josifovom, progovoriše mu na vratima kućnim, ");
INSERT INTO srp1865_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","i rekoše: Čuj, gospodaru; došli smo bili i pre, i kupismo hrane; ");
INSERT INTO srp1865_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","pa kad dođosmo u jednu gostionicu i otvorismo vreće, a to novci svakog nas behu ozgo u vreći njegovoj, novci naši na meru; i evo smo ih doneli natrag; ");
INSERT INTO srp1865_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","a druge smo novce doneli da kupimo hrane; ne znamo ko nam metnu novce naše u vreće. ");
INSERT INTO srp1865_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","A on im reče: Budite mirni, ne bojte se; Bog vaš i Bog oca vašeg metnuo je blago u vreće vaše; novci su vaši bili u mene. I izvede im Simeuna. ");
INSERT INTO srp1865_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","I uvede ih čovek u kuću Josifovu, i donese im vode te opraše noge, i magarcima njihovim položi. ");
INSERT INTO srp1865_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","I pripraviše dar čekajući dokle dođe Josif u podne, jer čuše da će oni onde jesti. ");
INSERT INTO srp1865_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","I kad Josif dođe kući, iznesoše mu dar koji imahu kod sebe, i pokloniše mu se do zemlje. ");
INSERT INTO srp1865_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","A on ih zapita kako su, i reče: Kako je otac vaš stari, za koga mi govoriste? Je li jošte živ? ");
INSERT INTO srp1865_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","A oni rekoše: Dobro je sluga tvoj, otac naš; još je živ. I pokloniše mu se. ");
INSERT INTO srp1865_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","A on pogledavši vide Venijamina brata svog, sina matere svoje, i reče: Je li vam to najmlađi brat vaš za kog mi govoriste? I reče: Bog da ti bude milostiv, sinko! ");
INSERT INTO srp1865_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","A Josifu goraše srce od ljubavi prema bratu svom, te brže potraži gde će plakati, i ušavši u jednu sobu plaka onde. ");
INSERT INTO srp1865_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Posle umiv se izađe, i ustežući se reče: Dajte jelo. ");
INSERT INTO srp1865_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","I donesoše njemu najposle i Misircima koji obedovahu u njega, jer ne mogahu Misirci jesti s Jevrejima, jer je to nečisto Misircima. ");
INSERT INTO srp1865_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","A seđahu pred njim stariji po stareštvu svom a mlađi po mladosti svojoj. I zgledahu se od čuda. ");
INSERT INTO srp1865_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","I uzimajući jela ispred sebe slaše njima, i Venijaminu dopade pet puta više nego drugima. I piše i napiše se s njim. ");
INSERT INTO srp1865_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","I zapovedi Josif čoveku što upravljaše kućom njegovom govoreći: Naspi ovim ljudima u vreće žita koliko mogu poneti, i svakome u vreću metni ozgo novce njegove. ");
INSERT INTO srp1865_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","I čašu moju, čašu srebrnu, metni najmlađem u vreću odozgo i novce za njegovo žito. I učini kako mu Josif reče. ");
INSERT INTO srp1865_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","A ujutru kad svanu, otpustiše ljude s magarcima njihovim. ");
INSERT INTO srp1865_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","A kad izađoše iz mesta i još ne behu daleko, reče Josif čoveku što upravljaše kućom njegovom: Ustani, idi brže za onim ljudima, i kad ih stigneš reci im: Zašto vraćate zlo za dobro? ");
INSERT INTO srp1865_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nije li to čaša iz koje pije moj gospodar? I neće li po njoj zacelo poznati kakvi ste? Zlo ste radili što ste to učinili. ");
INSERT INTO srp1865_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","I on ih stiže, i reče im tako. ");
INSERT INTO srp1865_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","A oni mu rekoše: Zašto govoriš, gospodaru, takve reči? Sačuvaj Bože da sluge tvoje učine takvo šta! ");
INSERT INTO srp1865_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Eno smo ti doneli natrag iz zemlje hananske novce koje nađosmo ozgo u vrećama svojim, pa kako bismo ukrali iz kuće gospodara tvog srebro ili zlato? ");
INSERT INTO srp1865_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","U kog se između sluga tvojih nađe, onaj neka pogine, i svrh toga mi ćemo biti robovi gospodaru mom. ");
INSERT INTO srp1865_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","A on reče: Neka bude kako rekoste; ali u koga se nađe, onaj da mi bude rob, a vi ostali nećete biti krivi. ");
INSERT INTO srp1865_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","I brže poskidaše svi na zemlju vreće svoje, i razrešiše svaki svoju vreću. ");
INSERT INTO srp1865_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","A on stade tražiti počevši od najstarijeg, i kad dođe na najmlađeg, nađe se čaša u vreći Venijaminovoj. ");
INSERT INTO srp1865_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tada razdreše haljine svoje, i natovarivši svaki svoj tovar na svog magarca vratiše se u grad. ");
INSERT INTO srp1865_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","I dođe Juda s braćom svojom Josifu u kuću, dok on još beše kod kuće, i padoše pred njim na zemlju. ");
INSERT INTO srp1865_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","A Josif im reče: Šta ste to učinili? Zar niste znali da čovek kao što sam ja može zacelo doznati? ");
INSERT INTO srp1865_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tada reče Juda: Šta da ti kažemo, gospodaru? Šta da govorimo? Kako li da se pravdamo? Bog je otkrio zločinstvo tvojih sluga. Evo, mi smo svi robovi tvoji, gospodaru, i mi i ovaj u koga se našla čaša. ");
INSERT INTO srp1865_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","A Josif reče: Bože sačuvaj! Neću ja to; u koga se našla čaša on neka mi bude rob, a vi idite s mirom ocu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ali Juda pristupiv k njemu reče: Čuj me, gospodaru; dopusti da progovori sluga tvoj gospodaru svom, i neka se gnev tvoj ne raspali na slugu tvog, jer si ti kao sam Faraon. ");
INSERT INTO srp1865_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Gospodar moj zapita sluge svoje govoreći: Imate li oca ili brata? ");
INSERT INTO srp1865_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","A mi rekosmo gospodaru svom: Imamo starog oca i brata najmlađeg, koji mu se rodi u starosti; a njegov je brat umro, i on osta sam od matere svoje, i otac ga pazi. ");
INSERT INTO srp1865_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","A ti reče slugama svojim: Dovedite mi ga da vidim svojim očima. ");
INSERT INTO srp1865_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","I rekosmo gospodaru svom: Neće moći dete ostaviti oca svog; da ostavi oca svog, odmah će otac umreti. ");
INSERT INTO srp1865_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","A ti reče slugama svojim: Ako ne dođe brat vaš najmlađi, nećete videti lice moje. ");
INSERT INTO srp1865_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","A kad se vratismo k sluzi tvom a ocu mom, kazasmo mu reči gospodara mog. ");
INSERT INTO srp1865_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Posle reče nam otac: Idite opet, kupite nam hrane. ");
INSERT INTO srp1865_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","A mi rekosmo: Ne možemo ići, osim ako bude brat naš najmlađi s nama, onda ćemo ići, jer ne možemo videti lica onog čoveka, ako ne bude s nama brat naš najmlađi. ");
INSERT INTO srp1865_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","A sluga tvoj, otac moj, reče nam: Znate da mi je žena rodila dva sina. ");
INSERT INTO srp1865_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","I jedan od njih otide od mene, i rekoh: Zacelo ga je raskinula zverka; i do sada ga ne videh. ");
INSERT INTO srp1865_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ako i ovog odvedete od mene i zadesi ga kako zlo, svalićete me starog u grob s tugom. ");
INSERT INTO srp1865_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Pa sada da otidem k sluzi tvom, ocu svom, a ovo dete da ne bude s nama, kako je duša onog vezana za dušu ovog, ");
INSERT INTO srp1865_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","umreće kad vidi da nema deteta, te će sluge tvoje svaliti starog slugu tvog, a oca svog, s tugom u grob. ");
INSERT INTO srp1865_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","A tvoj se sluga podjemčio za dete ocu svom rekavši: Ako ti ga ne dovedem natrag, da sam kriv ocu svom do veka. ");
INSERT INTO srp1865_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Zato neka sluga tvoj ostane mesto deteta, da bude rob gospodaru mom, a dete neka ide s braćom svojom. ");
INSERT INTO srp1865_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Jer kako bih se vratio k ocu svom bez deteta, da gledam jade koji bi mi oca zadesili? ");
INSERT INTO srp1865_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Tada Josif ne mogući se uzdržati pred ostalima koji stajahu oko njega, povika: Izađite svi napolje. Tako ne osta niko kod njega kad se Josif pokaza braći svojoj. ");
INSERT INTO srp1865_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Pa briznu plakati tako da čuše Misirci, ču i dom Faraonov. ");
INSERT INTO srp1865_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","I reče Josif braći svojoj: Ja sam Josif; je li mi otac još u životu? Ali mu braća ne mogahu odgovoriti, jer se prepadoše od njega. ");
INSERT INTO srp1865_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","A Josif reče braći svojoj: Pristupite bliže k meni. I pristupiše; a on reče ja sam Josif brat vaš, kog prodadoste u Misir. ");
INSERT INTO srp1865_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","A sada nemojte žaliti niti se kajati što me prodadoste ovamo, jer Bog mene posla pred vama radi života vašeg. ");
INSERT INTO srp1865_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Jer je već dve godine dana glad u zemlji, a biće još pet godina, gde neće biti ni oranja ni žetve. ");
INSERT INTO srp1865_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","A Bog me posla pred vama, da vas sačuva na zemlji i da vam izbavi život izbavljenjem prevelikim. ");
INSERT INTO srp1865_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","I tako niste me vi opravili ovamo nego sam Bog, koji me postavi ocem Faraonu i gospodarem od svega doma njegovog i starešinom nad svom zemljom misirskom. ");
INSERT INTO srp1865_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Vratite se brže k ocu mom i kažite mu: Ovako veli sin tvoj Josif: Bog me je postavio gospodarem svemu Misiru, hodi k meni, nemoj oklevati. ");
INSERT INTO srp1865_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Sedećeš u zemlji gesemskoj i bićeš blizu mene, ti i sinovi tvoji i sinovi sinova tvojih, i ovce tvoje i goveda tvoja i šta je god tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I ja ću te hraniti onde, jer će još pet godina biti glad, da ne pogineš od gladi ti i dom tvoj i šta je god tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","A eto vidite očima svojim, i brat moj Venijamin svojim očima, da vam ja iz usta govorim. ");
INSERT INTO srp1865_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kažite ocu mom svu slavu moju u Misiru i šta ste god videli; pohitajte i dovedite ovamo oca mog. ");
INSERT INTO srp1865_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Tada pade oko vrata Venijaminu bratu svom i plaka. I Venijamin plaka o vratu njegovom. ");
INSERT INTO srp1865_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","I izljubi svu braću svoju i isplaka se nad njima. Potom se braća njegova razgovarahu s njim. ");
INSERT INTO srp1865_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","I ču se glas u kući Faraonovoj, i rekoše: Dođoše braća Josifu. I milo bi Faraonu i slugama njegovim; ");
INSERT INTO srp1865_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","i reče Faraon Josifu: Kaži braći svojoj: Ovako učinite: natovarite magarce svoje, pa idite i vratite se u zemlju hanansku, ");
INSERT INTO srp1865_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","pa uzmite oca svog i čeljad svoju, i dođite k meni, i daću vam najbolje što ima u zemlji misirskoj, i ješćete najbolje obilje ove zemlje. ");
INSERT INTO srp1865_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","A ti im zapovedi: Ovako učinite: uzmite sa sobom iz zemlje misirske kola za decu svoju i za žene svoje, i povedite oca svog i dođite ovamo; ");
INSERT INTO srp1865_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","a na pokućstvo svoje ne gledajte, jer šta ima najbolje u svoj zemlji misirskoj vaše je. ");
INSERT INTO srp1865_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","I sinovi Izrailjevi učiniše tako; i Josif im dade kola po zapovesti Faraonovoj; dade im i brašnjenice na put. ");
INSERT INTO srp1865_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","I svakome dade po dve haljine, a Venijaminu dade trista srebrnika i petore haljine. ");
INSERT INTO srp1865_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A ocu svom posla još deset magaraca natovarenih najlepših stvari što ima u Misiru, i deset magarica natovarenih žita i hleba i jestiva ocu na put. ");
INSERT INTO srp1865_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Tako opravi braću svoju, i pođoše; i reče im: Nemojte se koriti putem. ");
INSERT INTO srp1865_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tako se vratiše iz Misira, i dođoše u zemlju hanansku k Jakovu ocu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","I javiše mu i rekoše: Još je živ Josif, i zapoveda nad svom zemljom misirskom. A u njemu srce prenemože, jer im ne verovaše. ");
INSERT INTO srp1865_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ali kad mu kazaše sve reči Josifove, koje im je Josif rekao, i vide kola, koja posla Josif po oca, tada ožive duh Jakova oca njihovog; ");
INSERT INTO srp1865_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","i reče Izrailj: Dosta mi je kad je još živ sin moj Josif; idem da ga vidim dokle nisam umro. ");
INSERT INTO srp1865_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tada pođe Izrailj sa svim šta imaše, i došav u Virsaveju prinese žrtvu Bogu oca svog Isaka. ");
INSERT INTO srp1865_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","I Bog reče Izrailju noću u utvari: Jakove! Jakove! A on odgovori: Evo me. ");
INSERT INTO srp1865_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","I Bog mu reče: Ja sam Bog, Bog oca tvog; ne boj se otići u Misir; jer ću onde načiniti od tebe narod velik. ");
INSERT INTO srp1865_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ja ću ići s tobom u Misir, i ja ću te odvesti onamo, i Josif će metnuti ruku svoju na oči tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","I pođe Jakov od Virsaveje; i sinovi Izrailjevi posadiše Jakova, oca svog i decu svoju i žene svoje na kola koja posla Faraon po nj. ");
INSERT INTO srp1865_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","I uzeše stoku svoju i blago svoje što behu stekli u zemlji hananskoj; i dođoše u Misir Jakov i sva porodica njegova. ");
INSERT INTO srp1865_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Sinove svoje i sinove sinova svojih, kćeri svoje i kćeri sinova svojih, i svu porodicu svoju dovede sa sobom u Misir. ");
INSERT INTO srp1865_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","A ovo su imena dece Izrailjeve što dođoše u Misir: Jakov i sinovi njegovi. Prvenac Jakovljev Ruvim; ");
INSERT INTO srp1865_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","i sinovi Ruvimovi: Enoh, Faluj, Esron i Harmija. ");
INSERT INTO srp1865_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","A sinovi Simeunovi: Jemuilo, Jamin, Aod, Jahin, Soar i Saul, sin jedne Hananejke. ");
INSERT INTO srp1865_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Sinovi Levijevi: Girson, Kat i Merarije. ");
INSERT INTO srp1865_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Sinovi Judini: Ir, Avnan, Silom, Fares i Zara; a umrli behu Ir i Avnan u zemlji hananskoj, ali behu sinovi Faresovi Esrom i Jemuilo. ");
INSERT INTO srp1865_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Sinovi Isaharovi: Tola, Fuva, Jov, i Simron. ");
INSERT INTO srp1865_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sinovi Zavulonovi: Sered, Alon, i Ahojilo. ");
INSERT INTO srp1865_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","To su sinovi Lijini, koje rodi Jakovu u Padan-Aramu, i jošte Dina kći njegova. Svega duša, sinova njegovih i kćeri njegovih beše trideset i tri. ");
INSERT INTO srp1865_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Sinovi Gadovi: Sifon, Agije, Sunije, Esvon, Irije, Arodije i Arilije. ");
INSERT INTO srp1865_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Sinovi Asirovi: Jemna, Jesva, Jesvija i Verija, i sestra njihova Sara. A sinovi Verijini Hovor i Melhilo. ");
INSERT INTO srp1865_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","To su sinovi Zelfe, koju dade Lavan Liji kćeri svojoj, i ona ih rodi Jakovu, šesnaest duša. ");
INSERT INTO srp1865_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","A sinovi Rahilje žene Jakovljeve: Josif i Venijamin. ");
INSERT INTO srp1865_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","A Josifu se rodiše u Misiru od Asenete, kćeri Potifere sveštenika onskog: Manasija i Jefrem. ");
INSERT INTO srp1865_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","A sinovi Venijaminovi: Vela, Veher, Asvil, Gira, Naman, Ihije, Ros, Mupim, Upim i Arad. ");
INSERT INTO srp1865_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","To su sinovi Rahiljini što se rodiše Jakovu, svega četrnaest duša. ");
INSERT INTO srp1865_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","I sin Danov: Asom. ");
INSERT INTO srp1865_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","A sinovi Neftalimovi: Asilo, Gunije, Jeser i Silim. ");
INSERT INTO srp1865_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","To su sinovi Vale, koju dade Lavan Rahilji kćeri svojoj i ona ih rodi Jakovu; svega sedam duša. ");
INSERT INTO srp1865_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","A svega duša što dođoše s Jakovom u Misir, a izađoše od bedara njegovih, osim žena sinova Jakovljevih, svega duša beše šezdeset i šest. ");
INSERT INTO srp1865_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","I dva sina Josifova koji mu se rodiše u Misiru; svega dakle duša doma Jakovljevog, što dođoše u Misir, beše sedamdeset. ");
INSERT INTO srp1865_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","A Judu posla Jakov napred k Josifu, da mu javi da izađe preda nj u Gesem. I dođoše u zemlju gesemsku. ");
INSERT INTO srp1865_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","A Josif upreže u kola svoja, i izađe na susret Izrailju ocu svom u Gesem; i kad ga vide Jakov, pade mu oko vrata, i plaka dugo o vratu njegovom. ");
INSERT INTO srp1865_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","I reče Izrailj Josifu: Sada ne marim umreti kad sam te video da si jošte živ. ");
INSERT INTO srp1865_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","A Josif reče braći svojoj i domu oca svog: Idem da javim Faraonu; ali ću mu kazati: Braća moja i dom oca mog iz zemlje hananske dođoše k meni; ");
INSERT INTO srp1865_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","a ti su ljudi pastiri i svagda su se bavili oko stoke, i dovedoše ovce svoje i goveda svoja i šta god imaju. ");
INSERT INTO srp1865_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","A kad vas Faraon dozove, reći će vam: Kakvu radnju radite? ");
INSERT INTO srp1865_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","A vi kažite: Pastiri su bile sluge tvoje od mladosti, i mi i stari naši; da biste ostali u zemlji gesemskoj; jer su Misircima svi pastiri nečisti. ");
INSERT INTO srp1865_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","I otišavši Josif javi Faraonu i reče: Otac moj i braća moja s ovcama svojim i s govedima svojim i sa svim što imaju dođoše iz zemlje hananske, i evo ih u zemlji gesemskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","I uzevši nekolicinu braće svoje, pet ljudi, izvede ih pred Faraona. ");
INSERT INTO srp1865_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","A Faraon reče braći njegovoj: Kakvu radnju radite? A oni rekoše Faraonu: Pastiri su sluge tvoje, i mi i naši stari. ");
INSERT INTO srp1865_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Još rekoše Faraonu: Dođosmo da živimo kao došljaci u ovoj zemlji, jer nema paše za stoku tvojih sluga, jer je velika glad u zemlji hananskoj; a sada dopusti da žive u zemlji gesemskoj sluge tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","A Faraon reče Josifu: Otac tvoj i braća tvoja dođoše k tebi; ");
INSERT INTO srp1865_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","u tvojoj je vlasti zemlja misirska; na najboljem mestu u ovoj zemlji naseli oca svog i braću svoju, neka žive u zemlji gesemskoj; i ako koje znaš između njih da su vredni ljudi, postavi ih nad mojom stokom. ");
INSERT INTO srp1865_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Posle dovede Josif i Jakova oca svog i izvede ga pred Faraona, i blagoslovi Jakov Faraona. ");
INSERT INTO srp1865_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","A Faraon reče Jakovu: Koliko ti ima godina? ");
INSERT INTO srp1865_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Odgovori Jakov Faraonu: Meni ima sto i trideset godina, kako sam došljak. Malo je dana života mog i zli su bili, niti stižu vek otaca mojih, koliko su oni živeli. ");
INSERT INTO srp1865_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","I blagosloviv Jakov Faraona otide od Faraona. ");
INSERT INTO srp1865_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","A Josif naseli oca svog i braću svoju, i dade im dobro u zemlji misirskoj na najboljem mestu te zemlje, u zemlji rameskoj, kao što zapovedi Faraon. ");
INSERT INTO srp1865_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","I hranjaše Josif hlebom oca svog i braću svoju i sav dom oca svog do najmanjeg. ");
INSERT INTO srp1865_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ali nesta hleba u svoj zemlji, jer glad beše vrlo velika, i uzmuči se zemlja misirska i zemlja hananska od gladi. ");
INSERT INTO srp1865_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","I pokupi Josif sve novce što se nalažahu po zemlji misirskoj i po zemlji hananskoj za žito, koje kupovahu, i slagaše novce u kuću Faraonovu. ");
INSERT INTO srp1865_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","A kad nesta novca u zemlji misirskoj i u zemlji hananskoj, stadoše svi Misirci dolaziti k Josifu govoreći: Daj nam hleba; zašto da mremo kod tebe, što novaca nema? ");
INSERT INTO srp1865_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","A Josif im govoraše: Dajte stoku svoju, pa ću vam dati hleba za stoku, kad je nestalo novca. ");
INSERT INTO srp1865_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","I dovođahu stoku svoju k Josifu, i Josif im davaše hleba za konje i za ovce i za goveda i za magarce. Tako ih prehrani onu godinu hlebom za svu stoku njihovu. ");
INSERT INTO srp1865_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","A kad prođe ona godina, stadoše opet dolaziti k njemu druge godine govoreći: Ne možemo tajiti od gospodara svog, ali je novaca nestalo, i stoka koju imasmo u našeg je gospodara; i nije ostalo ništa da donesemo gospodaru svom osim telesa naših i njiva naših. ");
INSERT INTO srp1865_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Zašto da mremo na tvoje oči? Evo i nas i naših njiva; kupi nas i njive naše za hleb, da s njivama svojim budemo robovi Faraonu, i daj žita da ostanemo živi i ne pomremo i da zemlja ne opusti. ");
INSERT INTO srp1865_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tako pokupova Josif Faraonu sve njive u Misiru, jer Misirci prodavahu svaki svoju njivu, kad glad uze jako maha među njima. I zemlja posta Faraonova. ");
INSERT INTO srp1865_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","A narod preseli u gradove od jednog kraja Misira do drugog. ");
INSERT INTO srp1865_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Samo ne kupi svešteničke njive; jer Faraon odredi deo sveštenicima, i hranjahu se od svog dela, koji im dade Faraon, te ne prodaše svojih njiva. ");
INSERT INTO srp1865_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","A Josif reče narodu: Evo kupih danas vas i njive vaše Faraonu; evo vam seme, pa zasejte njive. ");
INSERT INTO srp1865_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A šta bude roda, daćete peto Faraonu, a četiri dela neka budu vama za seme po njivama i za hranu vama i onima koji su po kućama vašim i za hranu deci vašoj. ");
INSERT INTO srp1865_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","A oni rekoše: Ti si nam život sačuvao; neka nađemo milost pred gospodarem svojim da budemo robovi Faraonu. ");
INSERT INTO srp1865_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","I postavi Josif zakon do današnjeg dana za njive misirske da se daje peto Faraonu; samo njive svešteničke ne postaše Faraonove. ");
INSERT INTO srp1865_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","A deca Izrailjeva življahu u zemlji misirskoj u kraju gesemskom, i držahu ga, i narodiše se i namnožiše se veoma. ");
INSERT INTO srp1865_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","I Jakov požive u zemlji misirskoj sedamnaest godina; a svega bi Jakovu sto i četrdeset i sedam godina. ");
INSERT INTO srp1865_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","A kad se približi vreme Izrailju da umre, dozva sina svog Josifa, i reče mu: Ako sam našao milost pred tobom, metni ruku svoju pod stegno moje, i učini mi milost i veru, nemoj me pogrepsti u Misiru; ");
INSERT INTO srp1865_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","nego neka ležim kod otaca svojih; i ti me odnesi iz Misira i pogrebi me u grobu njihovom. A on reče: Učiniću kako si kazao. ");
INSERT INTO srp1865_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","I reče mu Jakov: Zakuni mi se. I on mu se zakle. I pokloni se Izrailj preko uzglavlja od odra svog. ");
INSERT INTO srp1865_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Posle javiše Josifu: Eno, otac ti je bolestan. A on povede sa sobom dva sina svoja, Manasiju i Jefrema. ");
INSERT INTO srp1865_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","I javiše Jakovu i rekoše: Evo sin tvoj Josif ide k tebi. A Izrailj se okrepi, te sede na postelji svojoj. ");
INSERT INTO srp1865_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","I reče Jakov Josifu: Bog Svemogući javi se meni u Luzu u zemlji hananskoj, i blagoslovi me; ");
INSERT INTO srp1865_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","i reče mi: Učiniću te da narasteš i namnožiš se; i učiniću od tebe mnoštvo naroda, i daću zemlju ovu semenu tvom nakon tebe da je njihova do veka. ");
INSERT INTO srp1865_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Sada dakle dva sina tvoja, što ti se rodiše u zemlji misirskoj pre nego dođoh k tebi u Misir, moji su, Jefrem i Manasija kao Ruvim i Simeun neka budu moji. ");
INSERT INTO srp1865_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","A deca koju rodiš posle njih, neka budu tvoja i neka se po imenu braće svoje zovu u nasledstvu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Jer kad se vratih iz Padana, umre mi Rahilja u zemlji hananskoj na putu, kad beše još malo do Efrate; i pogreboh je na putu u Efratu, a to je Vitlejem. ");
INSERT INTO srp1865_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","A vide Izrailj sinove Josifove, reče: Ko su ovi? ");
INSERT INTO srp1865_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","A Josif reče ocu svom: Moji sinovi, koje mi Bog dade ovde. A on reče: Dovedi ih k meni, da ih blagoslovim. ");
INSERT INTO srp1865_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","A oči behu Izrailju otežale od starosti, te ne mogaše dobro videti. A kad mu ih privede, celiva ih i zagrli. ");
INSERT INTO srp1865_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","I reče Izrailj Josifu: Nisam mislio da ću videti lice tvoje; a gle, Bog mi dade da vidim i porod tvoj. ");
INSERT INTO srp1865_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","A Josif odmače ih od kolena njegovih i pokloni se licem do zemlje. ");
INSERT INTO srp1865_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Pa ih uze Josif obojicu, Jefrema sebi s desne strane a Izrailju s leve, Manasiju pak sebi s leve strane a Izrailju s desne; i tako ih primače k njemu. ");
INSERT INTO srp1865_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","A Izrailj pruživši desnu ruku svoju metnu je na glavu Jefremu mlađem, a levu na glavu Manasiji, tako namestivši ruke navlaš, ako i jeste Manasija bio prvenac. ");
INSERT INTO srp1865_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","I blagoslovi Josifa govoreći: Bog, kome su svagda ugađali oci moji Avram i Isak, Bog, koji me je hranio od kako sam postao do današnjeg dana, ");
INSERT INTO srp1865_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Anđeo, koji me je izbavljao od svakog zla, da blagoslovi decu ovu, i da se po mom imenu i po imenu otaca mojih Avrama i Isaka prozovu, i da se kao ribe namnože na zemlji! ");
INSERT INTO srp1865_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","A Josif kad vide gde otac metnu desnu ruku svoju na glavu Jefremu, ne bi mu milo, pa uhvati za ruku oca svog da je premesti s glave Jefremove na glavu Manasijinu. ");
INSERT INTO srp1865_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","I reče Josif ocu svom: Ne tako, oče; ovo je prvenac, metni desnicu njemu na glavu. ");
INSERT INTO srp1865_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ali otac njegov ne hte, nego reče: Znam, sine, znam; i od njega će postati narod, i on će biti velik; ali će mlađi brat njegov biti veći od njega, i seme će njegovo biti veliko mnoštvo naroda. ");
INSERT INTO srp1865_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","I blagoslovi ih u onaj dan i reče: Tobom će Izrailj blagosiljati govoreći: Bog da te učini kao Jefrema i kao Manasiju. Tako postavi Jefrema pred Manasiju. ");
INSERT INTO srp1865_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Posle reče Izrailj Josifu: Evo ja ću skoro umreti; ali će Bog biti s vama i odvešće vas opet u zemlju otaca vaših. ");
INSERT INTO srp1865_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","I ja ti dajem jedan deo više nego braći tvojoj, koji uzeh iz ruku amorejskih mačem svojim i lukom svojim. ");
INSERT INTO srp1865_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Posle sazva Jakov sinove svoje i reče: Skupite se da vam javim šta će vam biti do posletka. ");
INSERT INTO srp1865_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Skupite se i poslušajte, sinovi Jakovljevi, poslušajte Izrailja oca svog. ");
INSERT INTO srp1865_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruvime, ti si prvenac moj, krepost moja i početak sile moje; prvi gospodstvom i prvi snagom. ");
INSERT INTO srp1865_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Navro si kao voda; nećeš biti prvi; jer si stao na postelju oca svog i oskvrnio je legav na nju. ");
INSERT INTO srp1865_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeun i Levije, braća, mačevi su im oružje nepravdi. ");
INSERT INTO srp1865_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","U tajne njihove da ne ulazi duša moja, sa zborom njihovim da se ne sastavlja slava moja; jer u gnevu svom pobiše ljude, i za svoje veselje pokidaše volove. ");
INSERT INTO srp1865_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Proklet da je gnev njihov, što beše nagao, i ljutina njihova, što beše žestoka; razdeliću ih po Jakovu, i rasuću ih po Izrailju. ");
INSERT INTO srp1865_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, tebe će hvaliti braća tvoja, a ruka će ti biti za vratom neprijateljima tvojim, i klanjaće ti se sinovi oca tvog. ");
INSERT INTO srp1865_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Laviću Juda! S plena si se vratio, sine moj; spusti se i leže kao lav i kao ljuti lav; ko će ga probuditi? ");
INSERT INTO srp1865_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Palica vladalačka neće se odvojiti od Jude niti od nogu njegovih onaj koji postavlja zakon, dokle ne dođe Onaj kome pripada, i Njemu će se pokoravati narodi. ");
INSERT INTO srp1865_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Veže za čokot magare svoje, i za plemenitu lozu mlade od magarice svoje; u vinu pere haljinu svoju i ogrtač svoj u soku od grožđa. ");
INSERT INTO srp1865_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Oči mu se crvene od vina i zubi bele od mleka. ");
INSERT INTO srp1865_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zavulon će živeti pokraj mora i gde pristaju lađe, a međa će mu biti do Sidona. ");
INSERT INTO srp1865_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isahar je magarac jak u kostima, koji leži u toru, ");
INSERT INTO srp1865_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","I vide da je počivanje dobro i da je zemlja mila, sagnuće ramena svoja da nosi, i plaćaće danak. ");
INSERT INTO srp1865_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan će suditi svom narodu, kao jedno između plemena Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan će biti zmija na putu i guja na stazi, koja ujeda konja za kičicu, te pada konj na uznako. ");
INSERT INTO srp1865_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Gospode, Tebe čekam da me izbaviš. ");
INSERT INTO srp1865_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","A Gad, njega će vojska savladati; ali će najposle on nadvladati. ");
INSERT INTO srp1865_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","U Asira će biti obilata hrana, i on će davati slasti carske. ");
INSERT INTO srp1865_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalim je košuta puštena, i govoriće lepe reči. ");
INSERT INTO srp1865_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josif je rodna grana, rodna grana kraj izvora, kojoj se ogranci raširiše svrh zida. ");
INSERT INTO srp1865_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ako ga i ucveliše ljuto i streljaše na nj, i biše mu neprijatelji strelci, ");
INSERT INTO srp1865_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Opet osta jak luk njegov i ojačaše mišice ruku njegovih od ruku jakog Boga Jakovljevog, odakle posta pastir, kamen Izrailju, ");
INSERT INTO srp1865_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Od silnog Boga oca tvog, koji će ti pomagati, i od Svemogućeg, koji će te blagosloviti blagoslovima ozgo s neba, blagoslovima ozdo iz bezdana, blagoslovima od dojaka i od materice. ");
INSERT INTO srp1865_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Blagoslovi oca tvog nadvisiše blagoslove mojih starih svrh brda večnih, neka budu nad glavom Josifovom i nad temenom odvojenog između braće. ");
INSERT INTO srp1865_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Venijamin je vuk grabljivi, jutrom jede lov, a večerom deli plen. ");
INSERT INTO srp1865_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ovo su dvanaest plemena Izrailjevih, i ovo im otac izgovori kad ih blagoslovi, svako blagoslovom njegovim blagoslovi ih. ");
INSERT INTO srp1865_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Potom im zapovedi i reče im: Kad se priberem k rodu svom, pogrebite me kod otaca mojih u pećini koja je na njivi Efrona Hetejina, ");
INSERT INTO srp1865_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","u pećini koja je na njivi makpelskoj prema Mamriji u zemlji hananskoj, koju kupi Avram s njivom u Efrona Hetejina da ima svoj grob. ");
INSERT INTO srp1865_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Onde pogrebe Avrama i Saru ženu njegovu, onde pogreboše Isaka i Reveku ženu njegovu, i onde pogreboh Liju. ");
INSERT INTO srp1865_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","A kupljena je njiva i pećina na njoj u sinova Hetovih. ");
INSERT INTO srp1865_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","A kad izgovori Jakov zapovesti sinovima svojim, diže noge svoje na postelju, i umre, i pribran bi k rodu svom. ");
INSERT INTO srp1865_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tada Josif pade na lice ocu svom, i plaka nad njim celujući ga. ");
INSERT INTO srp1865_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","I zapovedi Josif slugama svojim lekarima da mirisima pomažu oca njegovog; i lekari pomazaše mirisima Izrailja. ");
INSERT INTO srp1865_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","I navrši mu se četrdeset dana, jer toliko dana treba onim koje pomažu mirisima; i plakaše za njim Misirci sedamdeset dana. ");
INSERT INTO srp1865_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","A kad prođoše žalosni dani, reče Josif domašnjima Faraonovim govoreći: Ako sam našao milost pred vama, govorite Faraonu i recite: ");
INSERT INTO srp1865_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Otac me je moj zakleo govoreći: Evo, ja ću skoro umreti; u grobu mom, koji iskopah u zemlji hananskoj, onde me pogrebi. Pa sada da idem da pogrebem oca svog, a posle ću opet doći. ");
INSERT INTO srp1865_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","A Faraon mu reče: Idi, pogrebi oca svog kako te je zakleo. ");
INSERT INTO srp1865_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","I otide Josif da pogrebe oca svog; i s njim pođoše sve sluge Faraonove, starešine od doma njegovog i sve starešine od zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","I sav dom Josifov i braća njegova i dom oca njegovog; samo decu svoju i ovce svoje i goveda svoja ostaviše u zemlji gesemskoj. ");
INSERT INTO srp1865_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","A pođe s njim kola i konjanika toliko da beše vojska vrlo velika. ");
INSERT INTO srp1865_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","A kad dođoše na gumno Atadovo, koje je s one strane Jordana, plakaše onde mnogo i vrlo tužno; i Josif učini žalost za ocem svojim za sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","A ljudi iz one zemlje, Hananejci, kad videše plač na gumnu Atadovom, rekoše: U velikoj su žalosti Misirci. Zato prozvaše ono mesto s one strane Jordana Žalost misirska. ");
INSERT INTO srp1865_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","I učiniše mu sinovi njegovi kako im beše zapovedio. ");
INSERT INTO srp1865_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Odnesoše ga sinovi njegovi u zemlju hanansku, i pogreboše ga u pećini na njivi makpelskoj, koju kupi Avram da ima svoj grob u Efrona Hetejina prema Mamriji. ");
INSERT INTO srp1865_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","I pogrebavši oca svog vrati se Josif u Misir i braća njegova i svi koji behu izašli s njim da pogrebu oca njegovog. ");
INSERT INTO srp1865_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","A braća Josifova videći gde im otac umre, rekoše: Može biti da se Josif srdi na nas, pa će nam se osvetiti za sve zlo što mu učinismo. ");
INSERT INTO srp1865_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Zato poručiše Josifu: Otac tvoj zapovedi na samrti i reče: ");
INSERT INTO srp1865_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Ovako kažite Josifu: Molim te, oprosti braći svojoj bezakonje i greh, što ti pakostiše; sada oprosti bezakonje slugama Boga oca tvog. A Josif zaplaka se kad mu to rekoše. ");
INSERT INTO srp1865_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Posle dođoše i braća njegova i padoše pred njim i rekoše: Evo smo sluge tvoje. ");
INSERT INTO srp1865_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","A Josif im reče: Ne bojte se, zar sam ja mesto Boga? ");
INSERT INTO srp1865_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vi ste mislili zlo po me, ali je Bog mislio dobro, da učini šta se danas zbiva, da se sačuva u životu mnogi narod. ");
INSERT INTO srp1865_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ne bojte se dakle; ja ću hraniti vas i vašu decu. Tako ih uteši i oslobodi. ");
INSERT INTO srp1865_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Tako življaše Josif u Misiru s domom oca svog, i požive sto i deset godina. ");
INSERT INTO srp1865_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","I vide Josif sinove Jefremove do trećeg kolena; i sinovi Mahira sina Manasijinog rodiše se i odrastoše na kolenima Josifovim. ");
INSERT INTO srp1865_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","I reče Josif braći svojoj: Ja ću skoro umreti; ali će vas zacelo Bog pohoditi, i izvešće vas iz ove zemlje u zemlju za koju se zakleo Avramu, Isaku i Jakovu. ");
INSERT INTO srp1865_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","I zakle Josif sinove Izrailjeve i reče: Zaista će vas pohoditi Bog; a vi onda odnesite kosti moje odavde. ");
INSERT INTO srp1865_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Potom umre Josif, a beše mu sto i deset godina; i pomazavši ga mirisima metnuše ga u kovčeg u Misiru. ");
INSERT INTO srp1865_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ovo su imena sinova Izrailjevih koji dođoše u Misir, dođoše s Jakovom, svaki sa svojom porodicom: ");
INSERT INTO srp1865_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruvim, Simeun, Levije i Juda, ");
INSERT INTO srp1865_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isahar, Zavulon i Venijamin, ");
INSERT INTO srp1865_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan i Neftalim, Gad i Asir. ");
INSERT INTO srp1865_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","A svega beše ih od bedara Jakovljevih sedamdeset duša s Josifom, koji beše u Misiru. ");
INSERT INTO srp1865_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","A Josif umre i sva braća njegova i sav onaj naraštaj. ");
INSERT INTO srp1865_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","I sinovi Izrailjevi narodiše se i umnožiše se, i napredovaše i osiliše veoma, da ih se zemlja napuni. ");
INSERT INTO srp1865_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Tada nasta nov car u Misiru, koji ne znaše za Josifa; ");
INSERT INTO srp1865_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","i reče narodu svom: Gle, narod sinova Izrailjevih veći je i silniji od nas. ");
INSERT INTO srp1865_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nego hajde mudro da postupamo s njima, da se ne množe, i kad nastane rat da ne pristanu s neprijateljima našim i ne udare na nas i ne odu iz zemlje. ");
INSERT INTO srp1865_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","I postaviše nad njima nastojnike da ih muče teškim poslovima; i građaše narod Izrailjev Faraonu gradove Pitom i Ramesu. ");
INSERT INTO srp1865_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ali što ga više mučahu to se više množaše i napredovaše, da se grožahu od sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","I žestoko nagonjahu Misirci sinove Izrailjeve na poslove, ");
INSERT INTO srp1865_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","i zagorčavahu im život teškim poslovima, blatom i opekama i svakim radom u polju, i svakim drugim poslom, na koji ih žestoko nagonjahu. ");
INSERT INTO srp1865_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","I još zapovedi car misirski babicama jevrejskim, od kojih jednoj beše ime Sefora, a drugoj Fuva, ");
INSERT INTO srp1865_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","i reče: Kad babičite Jevrejke, i u porođaju vidite da je muško, ubijte ga, a kad bude žensko, nek ostane živo. ");
INSERT INTO srp1865_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ali se babice bojahu Boga, i ne činjahu kako im reče car misirski, nego ostavljahu decu u životu. ");
INSERT INTO srp1865_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","A car misirski dozva babice, i reče im: Zašto to činite, te ostavljate u životu mušku decu? ");
INSERT INTO srp1865_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","A babice rekoše Faraonu: Jevrejke nisu kao žene Misirke; jače su; dok im dođe babica, one već rode. ");
INSERT INTO srp1865_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","I Bog učini dobro babicama; i narod se umnoži i osili veoma; ");
INSERT INTO srp1865_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","i što se babice bojahu Boga, načini im kuće. ");
INSERT INTO srp1865_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Tada zapovedi Faraon svemu narodu svom govoreći: Svakog sina koji se rodi bacite u vodu, a kćeri sve ostavljajte u životu. ");
INSERT INTO srp1865_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","A neko od plemena Levijevog otide i oženi se kćerju Levijevom. ");
INSERT INTO srp1865_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","I ona zatrudne i rodi sina; i videći ga lepog krijaše ga tri meseca. ");
INSERT INTO srp1865_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","A kad ga ne može više kriti, uže kovčežić od site, i obli ga smolom i paklinom, i metnu dete u nj, i odnese ga u trsku kraj reke. ");
INSERT INTO srp1865_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A sestra njegova stade podalje da vidi šta će biti od njega. ");
INSERT INTO srp1865_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","A kći Faraonova dođe da se kupa u reci, i devojke njene hodahu kraj reke; i ona ugleda kovčežić u trsci, i posla dvorkinju svoju te ga izvadi. ");
INSERT INTO srp1865_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","A kad otvori, vide dete, i gle, dete plakaše; i sažali joj se, i reče: To je jevrejsko dete. ");
INSERT INTO srp1865_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Tada reče sestra njegova kćeri Faraonovoj: Hoćeš li da idem da ti dozovem dojkinju Jevrejku, da ti doji dete? ");
INSERT INTO srp1865_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","A kći Faraonova reče joj: Idi. I otide devojčica, i dozva mater detinju. ");
INSERT INTO srp1865_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","I kći Faraonova reče joj: Uzmi ovo dete, i odoj mi ga, a ja ću ti platiti. I uze žena dete i odoji ga. ");
INSERT INTO srp1865_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","A kad dete odraste, odvede ga ka kćeri Faraonovoj, a ona ga posini; i nadede mu ime Mojsije govoreći: Jer ga iz vode izvadih. ");
INSERT INTO srp1865_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","I kad Mojsije beše velik, izađe k braći svojoj, i gledaše nevolju njihovu. I vide gde nekakav Misirac bije čoveka Jevrejina između braće njegove. ");
INSERT INTO srp1865_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","I obazrev se i tamo i amo, kad vide da nema nikoga, ubi Misirca, i zakopa ga u pesak. ");
INSERT INTO srp1865_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","I sutradan izađe opet, a to se dva Jevrejina svađahu, i reče onom koji činjaše krivo: Zašto biješ bližnjeg svog? ");
INSERT INTO srp1865_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A on reče: Ko je tebe postavio knezom i sudijom nad nama? Hoćeš li da me ubiješ kao što si ubio Misirca? Tada se Mojsije uplaši i reče: Zaista se doznalo. ");
INSERT INTO srp1865_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","I Faraon čuvši za to tražaše da pogubi Mojsija. Ali Mojsije pobeže od Faraona i dođe u zemlju madijansku, i sede kod jednog studenca. ");
INSERT INTO srp1865_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","A sveštenik madijanski imaše sedam kćeri, i one dođoše i stadoše zahvatati vodu i nalivati u pojila da napoje stado oca svog. ");
INSERT INTO srp1865_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","A dođoše pastiri, i oteraše ih; a Mojsije usta i odbrani ih, i napoji im stado. ");
INSERT INTO srp1865_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","I one se vratiše k ocu svom Raguilu; a on reče: Što se danas tako brzo vratiste? ");
INSERT INTO srp1865_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","A one rekoše: Jedan Misirac odbrani nas od pastira, i nali nam i napoji stado. ");
INSERT INTO srp1865_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","A on reče kćerima svojim: Pa gde je? Zašto ostaviste tog čoveka? Zovite ga da jede. ");
INSERT INTO srp1865_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","I Mojsije se skloni da živi kod onog čoveka, i on dade Mojsiju kćer svoju Seforu. ");
INSERT INTO srp1865_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","I ona rodi sina, i on mu nadede ime Girsam, jer sam, reče, došljak u zemlji tuđoj. ");
INSERT INTO srp1865_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A posle mnogo vremena umre car misirski; i uzdisahu od nevolje sinovi Izrailjevi i vikahu; i vika njihova radi nevolje dođe do Boga. ");
INSERT INTO srp1865_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","I Bog ču uzdisanje njihovo, i opomenu se Bog zaveta svog s Avramom, s Isakom i s Jakovom. ");
INSERT INTO srp1865_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","I pogleda Bog na sinove Izrailjeve, i vide ih. ");
INSERT INTO srp1865_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","A Mojsije pasaše stado Jotoru tastu svom, svešteniku madijanskom, i odvede stado preko pustinje, i dođe na goru Božiju Horiv. ");
INSERT INTO srp1865_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","I javi mu se anđeo Gospodnji u plamenu ognjenom iz kupine. I pogleda, a to kupina ognjem gori a ne sagoreva. ");
INSERT INTO srp1865_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","I Mojsije reče: Idem da vidim tu utvaru veliku, zašto ne sagoreva kupina. ");
INSERT INTO srp1865_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","A Gospod kad ga vide gde ide da vidi, viknu ga Bog iz kupine, i reče: Mojsije! Mojsije! A on odgovori: Evo me. ");
INSERT INTO srp1865_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","A Bog reče: Ne idi ovamo. Izuj obuću svoju s nogu svojih, jer je mesto gde stojiš sveta zemlja. ");
INSERT INTO srp1865_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Još reče: Ja sam Bog oca tvog, Bog Avramov, Bog Isakov i Bog Jakovljev. A Mojsije zakloni lice svoje, jer ga strah beše gledati u Boga. ");
INSERT INTO srp1865_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","I reče Gospod: Dobro videh nevolju naroda svog u Misiru, i čuh viku njegovu od zla koje mu čine nastojnici, jer poznah muku njegovu. ");
INSERT INTO srp1865_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","I siđoh da ga izbavim iz ruku misirskih, i da ga izvedem iz one zemlje u zemlju dobru i prostranu, u zemlju gde mleko i med teče, na mesto gde su Hananeji i Heteji i Amoreji i Ferezeji i Jeveji i Jevuseji. ");
INSERT INTO srp1865_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","I sada evo vika sinova Izrailjevih dođe preda me, i videh muku, kojom ih muče Misirci. ");
INSERT INTO srp1865_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sada hajde da te pošaljem k Faraonu, da izvedeš narod moj, sinove Izrailjeve, iz Misira. ");
INSERT INTO srp1865_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","A Mojsije reče Bogu: Ko sam ja da idem k Faraonu i da izvedem sinove Izrailjeve iz Misira? ");
INSERT INTO srp1865_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","A Bog mu reče: Ja ću biti s tobom, i ovo neka ti bude znak da sam te ja poslao: kad izvedeš narod iz Misira, služićete Bogu na ovoj gori. ");
INSERT INTO srp1865_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","A Mojsije reče Bogu: Evo, kad otidem k sinovima Izrailjevim, pa im kažem: Bog otaca vaših posla me k vama, ako mi kažu: Kako Mu je ime? Šta ću im kazati? ");
INSERT INTO srp1865_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","A Gospod reče Mojsiju: Ja sam Onaj što jeste. I reče: Tako ćeš kazati sinovima Izrailjevim: Koji jeste, On me posla k vama. ");
INSERT INTO srp1865_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","I opet reče Bog Mojsiju: Ovako kaži sinovima Izrailjevim: Gospod Bog otaca vaših, Bog Avramov, Bog Isakov i Bog Jakovljev, posla me k vama; to je ime moje doveka, i to je spomen moj od kolena na koleno. ");
INSERT INTO srp1865_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Idi, i skupi starešine izrailjske, pa im reci: Gospod Bog otaca vaših javi mi se, Bog Avramov, Isakov i Jakovljev, govoreći: Doista obiđoh vas, i videh kako vam je u Misiru. ");
INSERT INTO srp1865_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Pa rekoh: Izvešću vas iz nevolje misirske u zemlju hananejsku i hetejsku i amorejsku i ferezejsku i jevejsku i jevusejsku, u zemlju gde teče mleko i med. ");
INSERT INTO srp1865_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","I oni će poslušati glas tvoj; pa ćeš ti i starešine izrailjske otići k caru misirskom, i reći ćete mu: Gospod Bog jevrejski srete nas, pa ti se molimo da izađemo tri dana hoda u pustinju da prinesemo žrtvu Gospodu Bogu svom. ");
INSERT INTO srp1865_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","A ja znam da vam neće dopustiti car misirski da izađete bez ruke krepke. ");
INSERT INTO srp1865_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ali ću pružiti ruku svoju, i udariću Misir svim čudesima svojim, koja ću učiniti u njemu: i posle će vas pustiti. ");
INSERT INTO srp1865_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","I učiniću da narod nađe ljubav u Misiraca, pa kad pođete, nećete poći prazni; ");
INSERT INTO srp1865_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","nego će svaka žena zaiskati u susede svoje i u domaćice svoje nakita srebrnog i nakita zlatnog i haljina; i metnućete na sinove svoje i na kćeri svoje, i oplenićete Misir. ");
INSERT INTO srp1865_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","A Mojsije odgovori i reče: Ali neće mi verovati ni poslušati glas moj; jer će reći: Nije ti se Gospod javio. ");
INSERT INTO srp1865_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","A Gospod mu reče: Šta ti je to u ruci? A on odgovori: Štap. ");
INSERT INTO srp1865_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","A Bog mu reče: Baci ga na zemlju. I baci ga na zemlju, a on posta zmija. I Mojsije pobeže od nje. ");
INSERT INTO srp1865_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","A Gospod reče Mojsiju: Pruži ruku svoju, pa je uhvati za rep. I pruži ruku svoju, i uhvati je, i opet posta štap u ruci njegovoj. ");
INSERT INTO srp1865_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","To učini, reče Gospod, da veruju da ti se javio Gospod Bog otaca njihovih, Bog Avramov, Bog Isakov i Bog Jakovljev. ");
INSERT INTO srp1865_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","I opet mu reče Gospod: Turi sada ruku svoju u nedra svoja. I on turi ruku svoju u nedra svoja; a kad je izvadi iz nedara, a to ruka mu gubava, bela kao sneg. ");
INSERT INTO srp1865_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","A Bog mu reče: Turi opet ruku svoju u nedra svoja. I opet turi ruku svoju u nedra svoja; a kad je izvadi iz nedara, a to opet postala kao i ostalo telo njegovo. ");
INSERT INTO srp1865_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Tako, reče Bog, ako ti ne uzveruju i ne poslušaju glas tvoj za prvi znak, poslušaće za drugi znak. ");
INSERT INTO srp1865_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ako li ne uzveruju ni za ta dva znaka i ne poslušaju glas tvoj, a ti zahvati vode iz reke, i prolij na zemlju, i pretvoriće se voda koju zahvatiš iz reke, i provrći će se u krv na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","A Mojsije reče Gospodu: Molim Ti se, Gospode, nisam rečit čovek, niti sam pre bio niti sam otkako si progovorio sa slugom svojim, nego sam sporih usta i sporog jezika. ");
INSERT INTO srp1865_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","A Gospod mu reče: Ko je dao usta čoveku? Ili ko može stvoriti nemog ili gluvog ili okatog ili slepog? Zar ne ja, Gospod? ");
INSERT INTO srp1865_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Idi dakle, ja ću biti s ustima tvojim, i učiću te šta ćeš govoriti. ");
INSERT INTO srp1865_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","A Mojsije reče: Molim Te, Gospode, pošlji onog koga treba da pošalješ. ");
INSERT INTO srp1865_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","I razgnevi se Gospod na Mojsija, i reče mu: Nije li ti brat Aron Levit? Znam da je on rečit; i evo on će te sresti, i kad te vidi obradovaće se u srcu svom. ");
INSERT INTO srp1865_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Njemu ćeš kazati i metnućeš ove reči u usta njegova, i ja ću biti s tvojim ustima i s njegovim ustima, i učiću vas šta ćete činiti. ");
INSERT INTO srp1865_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","I on će mesto tebe govoriti narodu, i on će biti tebi mesto usta, a ti ćeš biti njemu mesto Boga. ");
INSERT INTO srp1865_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","A taj štap uzmi u ruku svoju, njim ćeš činiti čudesa. ");
INSERT INTO srp1865_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","I otide Mojsije, i vrati se k Jotoru tastu svom, i reče mu: Pusti me da idem, da se vratim k braći svojoj u Misiru, da vidim jesu li još u životu. I reče Jotor Mojsiju: Idi s mirom. ");
INSERT INTO srp1865_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","I reče Gospod Mojsiju u zemlji madijanskoj: Idi, vrati se u Misir, jer su pomrli svi koji su tražili dušu tvoju. ");
INSERT INTO srp1865_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","I uze Mojsije ženu svoju i sinove svoje, i posadi ih na magarca, i pođe natrag u zemlju misirsku. I uze Mojsije štap Božji u ruku svoju. ");
INSERT INTO srp1865_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","I reče Gospod Mojsiju: Kad otideš i vratiš se u Misir, gledaj da učiniš pred Faraonom sva čudesa koja ti metnuh u ruku: a ja ću učiniti da mu otvrdne srce i ne pusti narod. ");
INSERT INTO srp1865_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","A ti ćeš reći Faraonu: Ovako kaže Gospod: Izrailj je sin moj, prvenac moj. ");
INSERT INTO srp1865_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","I kazah ti: Pusti sina mog da mi posluži. A ti ga ne hte pustiti; evo ja ću ubiti sina tvog, prvenca tvog. ");
INSERT INTO srp1865_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","I kad beše na putu u gostionici, dođe k njemu Gospod i htede da ga ubije. ");
INSERT INTO srp1865_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","A Sefora uze oštar nož, i obreza sina svog, i okrajak baci k nogama njegovim govoreći: Ti si mi krvav zaručnik. ");
INSERT INTO srp1865_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tada ga ostavi Gospod; a ona radi obrezanja reče: Krvav zaručnik. ");
INSERT INTO srp1865_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","A Gospod reče Aronu: Iziđi u pustinju na susret Mojsiju. I otide i srete ga na gori Božijoj, i poljubi ga. ");
INSERT INTO srp1865_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","I Mojsije kaza Aronu sve reči Gospodnje, za koje ga posla, i sve znake koje mu zapovedi. ");
INSERT INTO srp1865_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","I otidoše Mojsije i Aron, i skupiše sve starešine sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","I Aron kaza sve reči, koje beše rekao Gospod Mojsiju, a Mojsije učini znake pred narodom. ");
INSERT INTO srp1865_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","I narod verova; i razumeše da je Gospod pohodio sinove Izrailjeve i video nevolju njihovu; i savivši se pokloniše se. ");
INSERT INTO srp1865_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","A posle izađoše Mojsije i Aron pred Faraona, i rekoše mu: Ovako veli Gospod Bog Izrailjev: Pusti narod moj da mi praznuju praznik u pustinji. ");
INSERT INTO srp1865_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ali Faraon reče: Ko je Gospod da poslušam glas njegov i pustim Izrailja? Ne znam Gospoda, niti ću pustiti Izrailja. ");
INSERT INTO srp1865_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","A oni rekoše: Bog jevrejski srete nas; molimo ti se da otidemo tri dana hoda u pustinju da prinesemo žrtvu Gospodu Bogu svom, da ne pošalje na nas pomor ili mač. ");
INSERT INTO srp1865_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","A car misirski reče im: Mojsije i Arone, zašto odvlačite narod od rada njegovog? Idite na svoj posao. ");
INSERT INTO srp1865_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Još reče Faraon: Eto, naroda je mnogo u zemlji; a vi još hoćete da ostavlja svoje poslove. ");
INSERT INTO srp1865_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","I u isti dan zapovedi Faraon nastojnicima nad narodom i upraviteljima njegovim, i reče: ");
INSERT INTO srp1865_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Od sad nemojte davati narodu plevu za opeke kao do sada, neka idu sami i kupe sebi plevu. ");
INSERT INTO srp1865_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","A koliko su opeka do sad načinjali toliko izgonite i od sad, niti šta smanjite; jer besposliče, i zato viču govoreći: Da idemo da prinesemo žrtvu Bogu svom. ");
INSERT INTO srp1865_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Valja navaliti poslove na te ljude, pa će raditi i neće slušati lažljive reči. ");
INSERT INTO srp1865_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","I izašavši nastojnici narodni i upravitelji rekoše narodu govoreći: Tako veli Faraon: Ja vam neću davati plevu. ");
INSERT INTO srp1865_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Idite sami i kupite sebi plevu gde nađete, a od posla vam se neće popustiti ništa. ");
INSERT INTO srp1865_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","I raziđe se narod po svoj zemlji misirskoj da čupa strnjiku mesto pleve. ");
INSERT INTO srp1865_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","A nastojnici navaljivahu govoreći: Svršujte poslove svoje koliko dolazi na dan, kao kad je bilo pleve. ");
INSERT INTO srp1865_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","I upravitelji sinova Izrailjevih, koje postaviše nad njima nastojnici Faraonovi, dopadahu boja, i govoraše im se: Zašto ni juče ni danas ne načiniste onoliko opeka koliko vam je određeno, kao pre? ");
INSERT INTO srp1865_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","I otidoše upravitelji sinova Izrailjevih, i povikaše k Faraonu govoreći: Zašto činiš tako slugama svojim? ");
INSERT INTO srp1865_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Pleva se ne daje slugama tvojim, pa opet kažu nam: Gradite opeke. I evo biju sluge tvoje, a kriv je tvoj narod. ");
INSERT INTO srp1865_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","A on reče: Besposličite, besposličite, i zato govorite: Da idemo da prinesemo žrtvu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nego idite, radite; pleva vam se neće davati, a opeke da dajete na broj. ");
INSERT INTO srp1865_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","I upravitelji sinova Izrailjevih videše da je zlo po njih što im se kaza: Da ne bude opeka manje na dan. ");
INSERT INTO srp1865_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","I otišavši od Faraona sretoše Mojsija i Arona, koji iziđoše pred njih. ");
INSERT INTO srp1865_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Pa im rekoše: Gospod neka vas vidi i sudi, što nas omraziste Faraonu i slugama njegovim, i dadoste im mač u ruku da nas pobiju. ");
INSERT INTO srp1865_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","I Mojsije se vrati ka Gospodu i reče: Gospode, zašto si navukao to zlo na narod? Zašto si me poslao? ");
INSERT INTO srp1865_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Jer otkako iziđoh pred Faraona i progovorih u tvoje ime, još gore postupa s narodom ovim, a Ti ne izbavi narod svoj. ");
INSERT INTO srp1865_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","A Gospod reče Mojsiju: Sad ćeš videti šta ću učiniti Faraonu; jer pod rukom krepkom pustiće ih, i isteraće ih iz zemlje svoje pod rukom krepkom. ");
INSERT INTO srp1865_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Još govori Bog Mojsiju i reče mu: Ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I javio sam se Avramu, Isaku i Jakovu imenom Bog Svemogući, a imenom svojim, Gospod, ne bih im poznat. ");
INSERT INTO srp1865_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I učinih zavet svoj s njima da ću im dati zemlju hanansku, zemlju u kojoj behu došljaci, u kojoj življahu kao stranci. ");
INSERT INTO srp1865_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","I čuh uzdisanje sinova Izrailjevih, koje Misirci drže u ropstvu, i opomenuh se zaveta svog. ");
INSERT INTO srp1865_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Zato kaži sinovima Izrailjevim: Ja sam Gospod, i izvešću vas ispod bremena misirskih, i oprostiću vas ropstva njihovog, i izbaviću vas mišicom podignutom i sudovima velikim. ");
INSERT INTO srp1865_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I uzeću vas da mi budete narod, i ja ću vam biti Bog, te ćete poznati da sam ja Gospod Bog vaš, koji vas izvodim ispod bremena misirskih. ");
INSERT INTO srp1865_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Pak ću vas odvesti u svoju zemlju, za koju podigoh ruku svoju zaklinjući se da ću je dati Avramu, Isaku i Jakovu; i daću vam je u nasledstvo, ja Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","I Mojsije kaza tako sinovima Izrailjevim; ali ne poslušaše Mojsija od slabosti duha svog i od ljutog ropstva. ");
INSERT INTO srp1865_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","I Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Idi, kaži Faraonu, caru misirskom, neka pusti sinove Izrailjeve iz zemlje svoje. ");
INSERT INTO srp1865_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","A Mojsije progovori pred Gospodom i reče: Eto, sinovi Izrailjevi ne poslušaše me, a kako će me poslušati Faraon, kad sam neobrezanih usana? ");
INSERT INTO srp1865_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ali Gospod govori Mojsiju i Aronu, i zapovedi im da idu k sinovima Izrailjevim i k Faraonu, da izvedu sinove Izrailjeve iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ovo su poglavice u domovima otaca svojih: sinovi Ruvima, prvenca Izrailjevog: Enoh i Faluj, Asron i Harmija; to su porodice Ruvimove. ");
INSERT INTO srp1865_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","A sinovi Simeunovi: Jemuilo i Jamin i Aod i Ahin i Sar i Saul, sin neke Hananejke; to su porodice Simeunove. ");
INSERT INTO srp1865_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","A ovo su imena sinova Levijevih po porodicama njihovim: Girson i Kat i Merarije; a Levije požive sto i trideset i sedam godina. ");
INSERT INTO srp1865_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","A ovo su sinovi Girsonovi: Lovenije i Semej po porodicama svojim. ");
INSERT INTO srp1865_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","A sinovi Katovi: Amram i Isar i Hevron i Ozilo; a Kat požive sto i trideset i tri godine. ");
INSERT INTO srp1865_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","A sinovi Merarijevi: Molija i Musija. To su porodice Levijeve po lozama svojim. ");
INSERT INTO srp1865_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","A Amram se oženi Johavedom bratučedom svojom, i ona mu rodi Arona i Mojsija. A požive Amram sto i trideset i sedam godina. ");
INSERT INTO srp1865_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","A sinovi Isarovi behu: Korej i Nafek i Zehrija. ");
INSERT INTO srp1865_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","A sinovi Ozilovi: Misailo i Elisafan i Segrija. ");
INSERT INTO srp1865_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","A Aron se oženi Jelisavetom kćerju Aminadavovom, sestrom Nasonovom; i ona mu rodi Nadava i Avijuda i Eleazara i Itamara. ");
INSERT INTO srp1865_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","A sinovi Korejevi behu: Asir i Elkana i Avijasar. To su porodice Korejeve. ");
INSERT INTO srp1865_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","I Eleazar, sin Aronov, oženi se jednom od kćeri Futilovih, i ona mu rodi Finesa. To su poglavice između otaca levitskih po svojim porodicama. ");
INSERT INTO srp1865_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","To je Aron i Mojsije, kojima reče Gospod: Izvedite sinove Izrailjeve iz zemlje misirske u četama njihovim. ");
INSERT INTO srp1865_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","To su koji govoriše Faraonu, caru misirskom, da izvedu sinove Izrailjeve iz Misira; to je Mojsije i to je Aron. ");
INSERT INTO srp1865_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","I kad Gospod govoraše Mojsiju u zemlji misirskoj, ");
INSERT INTO srp1865_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","reče Gospod Mojsiju govoreći: Ja sam Gospod; kaži Faraonu caru misirskom sve što sam ti kazao. ");
INSERT INTO srp1865_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","I Mojsije reče pred Gospodom: Evo sam neobrezanih usana, pa kako će me poslušati Faraon? ");
INSERT INTO srp1865_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","I Gospod reče Mojsiju: Evo, postavio sam te da si Bog Faraonu; a Aron brat tvoj biće prorok tvoj. ");
INSERT INTO srp1865_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Govorićeš sve što ti zapovedim; Aron, pak, brat tvoj govoriće Faraonu da pusti sinove Izrailjeve iz zemlje svoje. ");
INSERT INTO srp1865_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","A ja ću učiniti da otvrdne srce Faraonu, te ću umnožiti znake svoje i čudesa svoja u zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","I neće vas ipak poslušati Faraon; a ja ću metnuti ruku svoju na Misir, i izvešću vojsku svoju, narod svoj, sinove Izrailjeve iz zemlje misirske sudovima velikim. ");
INSERT INTO srp1865_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","I poznaće Misirci da sam ja Gospod, kad dignem ruku svoju na Misir, i izvedem sinove Izrailjeve između njih. ");
INSERT INTO srp1865_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","I učini Mojsije i Aron, kako im zapovedi Gospod, tako učiniše. ");
INSERT INTO srp1865_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","A Mojsiju beše osamdeset godina, a Aronu osamdeset i tri godine, kad govorahu s Faraonom. ");
INSERT INTO srp1865_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","I reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Kad vam kaže Faraon i reče: Učinite kako čudo, onda reci Aronu: Uzmi štap svoj, i baci ga pred Faraona; te će se premetnuti u zmiju. ");
INSERT INTO srp1865_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","I izađoše Mojsije i Aron pred Faraona, i učiniše kako zapovedi Gospod; i baci Aron štap svoj pred Faraona i pred sluge njegove, i premetnu se u zmiju. ");
INSERT INTO srp1865_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","A Faraon dozva mudrace i vračare; te i vračari misirski učiniše tako svojim vračanjem. ");
INSERT INTO srp1865_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","I baciše svaki svoj štap, i premetnuše se štapovi u zmije; ali štap Aronov proždre njihove štapove. ");
INSERT INTO srp1865_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","I otvrdnu srce Faraonovo, i ne posluša ih, kao što beše kazao Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","I reče Gospod Mojsiju: Oteža srce Faraonovo; neće da pusti narod. ");
INSERT INTO srp1865_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Idi ujutru k Faraonu. Gle, on će izaći na vodu, pa stani prema njemu na obali, a štap koji se bio premetnuo u zmiju uzmi u ruku. ");
INSERT INTO srp1865_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","I reci mu: Gospod Bog jevrejski posla me k tebi da ti kažem: Pusti narod moj da mi posluži u pustinji. Ali ti eto još ne posluša. ");
INSERT INTO srp1865_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Zato Gospod ovako veli: Ovako ćeš poznati da sam ja Gospod: evo, udariću štapom što mi je u ruci po vodi što je u reci, i premetnuće se u krv. ");
INSERT INTO srp1865_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","I ribe u reci pomreće, i reka će se usmrdeti, i Misirci će se uzmučiti tražeći vode da piju iz reke. ");
INSERT INTO srp1865_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","I Gospod reče Mojsiju: Reci Aronu: Uzmi štap svoj, i pruži ruku svoju na vode misirske, na potoke, na reke i na jezera njihova i na sva zborišta voda njihovih; i premetnuće se u krv, i biće krv po svoj zemlji misirskoj, i po sudima drvenim i kamenim. ");
INSERT INTO srp1865_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","I učiniše Mojsije i Aron kako im zapovedi Gospod; i podigavši Aron štap svoj udari po vodi koja beše u reci pred Faraonom i slugama njegovim. I sva voda što beše u reci premetnu se u krv. ");
INSERT INTO srp1865_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","I pomreše ribe što behu u reci, i usmrde se reka tako da ne mogahu Misirci piti vode iz reke, i beše krv po svoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ali i vračari misirski učiniše tako svojim vračanjem; i srce Faraonu otvrdnu, te ih ne posluša, kao što beše kazao Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","I okrenuvši se Faraon otide kući svojoj, i ne mari ni za to. ");
INSERT INTO srp1865_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","A Misirci svi kopaše oko reke tražeći vode da piju; jer ne mogahu piti vode iz reke. ");
INSERT INTO srp1865_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","I navrši se sedam dana kako reku udari Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","I reče Gospod Mojsiju: Idi k Faraonu, i reci mu: Ovako veli Gospod: Pusti narod moj, da mi posluži. ");
INSERT INTO srp1865_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ako li nećeš pustiti, evo ću moriti svu zemlju žabama. ");
INSERT INTO srp1865_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","I reka će se napuniti žaba, i one će izaći i skakati tebi po kući i po kleti gde spavaš i po postelji tvojoj i po kućama sluga tvojih i naroda tvog i po pećima tvojim i po naćvama tvojim; ");
INSERT INTO srp1865_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","i na tebe i na narod tvoj i na sve sluge tvoje skakaće žabe. ");
INSERT INTO srp1865_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","I reče Gospod Mojsiju: Kaži Aronu: Pruži ruku svoju sa štapom svojim na reke i na potoke i na jezera, i učini nek izađu žabe na zemlju misirsku. ");
INSERT INTO srp1865_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","I pruži Aron ruku svoju na vode misirske, i izađoše žabe i pokriše zemlju misirsku. ");
INSERT INTO srp1865_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ali i vračari misirski učiniše tako svojim vračanjem, učiniše te izađoše žabe na zemlju misirsku. ");
INSERT INTO srp1865_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","A Faraon dozva Mojsija i Arona i reče: Molite Gospoda da ukloni žabe od mene i od naroda mog, pak ću pustiti narod da prinesu žrtvu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","A Mojsije reče Faraonu: Čast da ti je nada mnom! Dokle da mu se molim za te i za sluge tvoje i za narod tvoj da odbije žabe od tebe i iz kuća tvojih, i samo u reci da ostanu? ");
INSERT INTO srp1865_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","A on reče: Do sutra. A Mojsije reče: Biće kako si kazao, da poznaš da niko nije kao Gospod Bog naš. ");
INSERT INTO srp1865_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Otići će žabe od tebe i iz kuća tvojih i od sluga tvojih i od naroda tvog; samo će u reci ostati. ");
INSERT INTO srp1865_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","I otide Mojsije i Aron od Faraona; i zavapi Mojsije ka Gospodu za žabe koje beše pustio na Faraona. ");
INSERT INTO srp1865_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","A Gospod učini po reči Mojsijevoj; i pocrkaše žabe, i oprostiše ih se kuće i sela i polja. ");
INSERT INTO srp1865_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","I na gomile ih grtahu, da je smrdela zemlja. ");
INSERT INTO srp1865_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","A kad Faraon vide gde odahnu, otvrdnu mu srce, i ne posluša ih, kao što beše kazao Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","A Gospod reče Mojsiju: Kaži Aronu: Pruži štap svoj, i udari po prahu na zemlji, nek se pretvori u uši po svoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","I učiniše tako: Aron pruži ruku svoju sa štapom svojim, i udari po prahu na zemlji, i postaše uši po ljudima i po stoci, sav prah na zemlji pretvori se u uši po celoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","A gledaše i vračari misirski vračanjem svojim da učine da postanu uši, ali ne mogoše. I behu uši po ljudima i po stoci. ");
INSERT INTO srp1865_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","I rekoše vračari Faraonu: Ovo je prst Božji. Ali opet otvrdnu srce Faraonu, te ih ne posluša kao što beše kazao Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","A Gospod reče Mojsiju: Ustani rano i izađi pred Faraona, evo, on će izaći k vodi, pa mu reci: Ovako veli Gospod: Pusti narod moj da mi posluži. ");
INSERT INTO srp1865_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ako li ne pustiš narod moj, evo, pustiću na tebe i na sluge tvoje i na narod tvoj i na kuće tvoje svakojake bubine, i napuniće se bubina kuće misirske i zemlja na kojoj su. ");
INSERT INTO srp1865_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ali ću u taj dan odvojiti zemlju gesemsku, gde živi moj narod, i onde neće biti bubina, da poznaš da sam ja Gospod na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","I postaviću razliku između naroda svog i naroda tvog. Sutra će biti znak taj. ");
INSERT INTO srp1865_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","I učini Gospod tako, i dođoše silne bubine u kuću Faraonovu i u kuće sluga njegovih i u svu zemlju misirsku, da se sve u zemlji pokvari od bubina. ");
INSERT INTO srp1865_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","I Faraon dozva Mojsija i Arona, i reče im: Idite, prinesite žrtvu Bogu svom ovde u zemlji. ");
INSERT INTO srp1865_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","A Mojsije reče: Ne valja tako; jer bismo prineli na žrtvu Gospodu Bogu svom što je nečisto Misircima; a kad bismo prineli na žrtvu što je nečisto Misircima na oči njihove, ne bi li nas pobili kamenjem? ");
INSERT INTO srp1865_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tri dana hoda treba da idemo u pustinju da prinesemo žrtvu Gospodu Bogu svom, kao što nam je kazao. ");
INSERT INTO srp1865_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","A Faraon reče: Pustiću vas da prinesete žrtvu Gospodu Bogu svom u pustinji; ali da ne idete dalje; pa se molite za me. ");
INSERT INTO srp1865_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","A Mojsije reče: Evo ja idem od tebe, i moliću se Gospodu da otidu bubine od Faraona i od sluga njegovih i od naroda njegovog sutra; ali nemoj opet da prevariš, i da ne pustiš narod da prinese žrtvu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","I otide Mojsije od Faraona, i pomoli se Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","I učini Gospod po reči Mojsijevoj, te otidoše bubine od Faraona i od sluga njegovih i od naroda njegovog; ne osta ni jedna. ");
INSERT INTO srp1865_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ali opet otvrdnu srce Faraonovo, i ne pusti narod. ");
INSERT INTO srp1865_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Tada reče Gospod Mojsiju: Idi k Faraonu, i reci mu: Ovako veli Gospod Bog jevrejski: Pusti narod moj da mi posluži; ");
INSERT INTO srp1865_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ako li ih ne pustiš nego ih još staneš zadržavati, ");
INSERT INTO srp1865_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","evo, ruka Gospodnja doći će na stoku tvoju u polju, na konje, na magarce, na kamile, na volove i na ovce, s pomorom vrlo velikim. ");
INSERT INTO srp1865_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","A odvojiće Gospod stoku izrailjsku od stoke misirske; te od svega što je sinova Izrailjevih neće poginuti ništa. ");
INSERT INTO srp1865_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","I postavio je Gospod rok rekavši: Sutra će to učiniti na zemlji Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","I Gospod učini to sutradan, i sva stoka misirska uginu; a od stoke sinova Izrailjevih ne uginu nijedno. ");
INSERT INTO srp1865_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","I posla Faraon da vide, i gle, od stoke izrailjske ne uginu nijedno; ipak otvrdnu srce Faraonu, i ne pusti narod. ");
INSERT INTO srp1865_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Tada reče Gospod Mojsiju i Aronu: Uzmite pepela iz peći pune pregršti, i Mojsije neka ga baci u nebo pred Faraonom; ");
INSERT INTO srp1865_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","i postaće prah po svoj zemlji misirskoj, a od njega će postati kraste pune gnoja i na ljudima i na stoci po svoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","I uzeše pepela iz peći, i stadoše pred Faraona, i baci ga Mojsije u nebo, i postaše kraste pune gnoja po ljudima i po stoci. ");
INSERT INTO srp1865_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","I vračari ne mogoše stajati pred Mojsijem od krasta; jer behu kraste i na vračarima i na svim Misircima. ");
INSERT INTO srp1865_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","I Gospod učini te otvrdnu srce Faraonovo, i ne posluša ih, kao što beše kazao Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Posle reče Gospod Mojsiju: Ustani rano i izađi pred Faraona, i reci mu: Ovako veli Gospod Bog jevrejski: Pusti narod moj da mi posluži. ");
INSERT INTO srp1865_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Jer ću sada pustiti sva zla svoja na srce tvoje i na sluge tvoje i na narod tvoj, da znaš da niko nije kao ja na celoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Jer sada kad pružih ruku svoju, mogah i tebe i narod tvoj udariti pomorom, pa te ne bi više bilo na zemlji; ");
INSERT INTO srp1865_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ali te ostavih da pokažem na tebi silu svoju, i da se pripoveda ime moje po svoj zemlji. ");
INSERT INTO srp1865_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","I ti se još podižeš na moj narod, i nećeš da ga pustiš? ");
INSERT INTO srp1865_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Evo, sutra ću u ovo doba pustiti grad vrlo velik, kakvog nije bilo u Misiru otkako je postao pa dosada. ");
INSERT INTO srp1865_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Zato sada pošlji, te skupi stoku svoju i šta god imaš u polju, jer će pasti grad na sve ljude i na stoku što se zateče u polju i ne bude skupljeno u kuću, i izginuće. ");
INSERT INTO srp1865_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Koji se god između sluga Faraonovih poboja reči Gospodnje, on brže skupi sluge svoje i stoku svoju u kuću; ");
INSERT INTO srp1865_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","a koji ne maraše za reč Gospodnju, on ostavi sluge svoje i stoku svoju u polju. ");
INSERT INTO srp1865_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","I Gospod reče Mojsiju: Pruži ruku svoju k nebu, neka udari grad po svoj zemlji misirskoj, na ljude i na stoku i na sve bilje po polju u zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","I Mojsije pruži štap svoj k nebu, i Gospod pusti gromove i grad, da oganj skakaše na zemlju. I tako Gospod učini, te pade grad na zemlju misirsku. ");
INSERT INTO srp1865_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","A beše grad i oganj smešan s gradom silan veoma, kakvog ne beše u svoj zemlji misirskoj otkako je ljudi u njoj. ");
INSERT INTO srp1865_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","I pobi grad po svoj zemlji misirskoj šta god beše u polju od čoveka do živinčeta; i sve bilje u polju potre grad, i sva drveta u polju polomi. ");
INSERT INTO srp1865_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Samo u zemlji gesemskoj, gde behu sinovi Izrailjevi, ne beše grada. ");
INSERT INTO srp1865_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tada posla Faraon, te dozva Mojsija i Arona, i reče im: Sada zgreših; Gospod je pravedan, a ja i moj narod jesmo bezbožnici. ");
INSERT INTO srp1865_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Molite se Gospodu, jer je dosta, neka prestanu gromovi Božji i grad, pa ću vas pustiti, i više vas neće niko ustavljati. ");
INSERT INTO srp1865_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","A Mojsije mu reče: Kad izađem iza grada, raširiću ruke svoje ka Gospodu, a gromovi će prestati i grada neće više biti, da znaš da je Gospodnja zemlja. ");
INSERT INTO srp1865_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","A ti i sluge tvoje znam da se još nećete bojati Gospoda Boga. ");
INSERT INTO srp1865_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","I propade lan i ječam, jer ječam beše klasao, a lan se glavičio. ");
INSERT INTO srp1865_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","A pšenica i krupnik ne propade, jer beše pozno žito. ");
INSERT INTO srp1865_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","I Mojsije otišavši od Faraona iza grada raširi ruke svoje ka Gospodu, i prestaše gromovi i grad, i dažd ne padaše na zemlju. ");
INSERT INTO srp1865_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ali Faraon videvši gde presta dažd i grad i gromovi, stade opet grešiti, i srce mu otvrdnu i njemu i slugama njegovim. ");
INSERT INTO srp1865_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Otvrdnu srce Faraonu, te ne pusti sinove Izrailjeve, kao što beše kazao Gospod preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","A Gospod reče Mojsiju: Idi k Faraonu, jer sam ja učinio da otvrdne srce njegovo i srce sluga njegovih, da učinim ove znake svoje među njima, ");
INSERT INTO srp1865_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","i da pripovedaš sinovima svojim i unucima svojim šta učinih u Misiru i kakve znake svoje pokazah na njima, da biste znali da sam ja Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","I otide Mojsije i Aron k Faraonu, i rekoše mu: Ovako veli Gospod Bog jevrejski: Dokle ćeš se protiviti da se ne poniziš preda mnom? Pusti narod moj da mi posluži. ");
INSERT INTO srp1865_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Jer ako nećeš pustiti narod moj, evo sutra ću naneti skakavce na zemlju tvoju; ");
INSERT INTO srp1865_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","i pokriće svu zemlju da se neće videti zemlja, i poješće ostatak što se sačuvao, koji vam je ostao iza grada, i poješće sva drveta što vam rastu u polju. ");
INSERT INTO srp1865_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","I napuniće ih se kuće tvoje i kuće svih sluga tvojih i kuće svih Misiraca, šta nisu videli oci tvoji ni oci otaca tvojih, otkako su postali na zemlji do danas. I okrenuvši se otide od Faraona. ");
INSERT INTO srp1865_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","A sluge rekoše Faraonu: Dokle će nas taj mučiti? Pusti ih neka posluže Gospodu Bogu svom. Zar još ne vidiš gde propade Misir? ");
INSERT INTO srp1865_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","I dozvaše opet Mojsija i Arona pred Faraona, i reče im: Idite, poslužite Gospodu Bogu svom. A koji su što će ići? ");
INSERT INTO srp1865_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","A Mojsije reče: S decom svojom i sa starcima svojim ići ćemo, sa sinovima svojim i sa kćerima svojim, sa stokom svojom sitnom i krupnom ići ćemo, jer imamo praznik Gospodnji. ");
INSERT INTO srp1865_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","A on im reče: Tako bio Gospod s vama, kako ću vas ja pustiti s decom vašom! Vidite da zlo mislite. ");
INSERT INTO srp1865_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Neće biti tako; nego vi ljudi idite i poslužite Gospodu, jer to ištete. I otera ih od sebe Faraon. ");
INSERT INTO srp1865_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Tada reče Gospod Mojsiju: Pruži ruku svoju na zemlju misirsku, da dođu skakavci na zemlju misirsku i pojedu sve bilje po zemlji, šta god osta iza grada. ");
INSERT INTO srp1865_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","I pruži Mojsije štap svoj na zemlju misirsku, i Gospod navede ustoku na zemlju, te duva celi dan i celu noć; a kad svanu, donese ustoka skakavce. ");
INSERT INTO srp1865_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","I dođoše skakavci na svu zemlju misirsku, i popadaše po svim krajevima misirskim silni veoma, kakvih pre nikada nije bilo niti će kad biti onakvih. ");
INSERT INTO srp1865_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","I pokriše svu zemlju, da se zemlja ne viđaše, i pojedoše svu travu na zemlji i sav rod na drvetima, što osta iza grada, i ne osta ništa zeleno od drveta i od bilja poljskog u svoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tada Faraon brže dozva Mojsija i Arona, i reče: Zgreših Gospodu Bogu vašem i vama. ");
INSERT INTO srp1865_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ali mi još sada samo oprosti greh moj, i molite se Gospodu Bogu svom da ukloni od mene samo ovu smrt. ");
INSERT INTO srp1865_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","I otide Mojsije od Faraona, i pomoli se Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","I okrenu Gospod vetar od zapada vrlo jak, koji uze skakavce i baci ih u Crveno more, i ne osta nijedan skakavac u celoj zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ali Gospod učini te otvrdnu srce Faraonu, i ne pusti sinove Izrailjeve. ");
INSERT INTO srp1865_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","I reče Gospod Mojsiju: Pruži ruku svoju k nebu, i biće tama po zemlji misirskoj takva da će je pipati. ");
INSERT INTO srp1865_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","I Mojsije pruži ruku svoju k nebu, i posta gusta tama po svoj zemlji misirskoj za tri dana. ");
INSERT INTO srp1865_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ne viđahu jedan drugog, i niko se ne mače s mesta gde beše za tri dana; ali se kod svih sinova Izrailjevih videlo po stanovima njihovim. ");
INSERT INTO srp1865_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tada Faraon dozva Mojsija, i reče: Idite, poslužite Gospodu; samo stoka vaša sitna i krupna neka ostane, a deca vaša neka idu s vama. ");
INSERT INTO srp1865_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","A Mojsije reče: Treba da nam daš i šta ćemo prineti i sažeći na žrtvu Gospodu Bogu svom; ");
INSERT INTO srp1865_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","zato i stoka naša nek ide s nama, da ne ostane ni papka, jer između nje treba da uzmemo čim ćemo poslužiti Gospodu Bogu svom, a ne znamo kojim ćemo poslužiti Gospodu dokle ne dođemo onamo. ");
INSERT INTO srp1865_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ali Gospod učini te otvrdnu srce Faraonu, i ne hte ih pustiti. ");
INSERT INTO srp1865_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","I reče mu Faraon: Idi od mene, i čuvaj se da mi više ne dođeš na oči, jer ako mi dođeš na oči, poginućeš. ");
INSERT INTO srp1865_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","A Mojsije reče: Pravo si kazao; neću ti više doći na oči. ");
INSERT INTO srp1865_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","A Gospod reče Mojsiju: Još ću jedno zlo pustiti na Faraona i na Misir, pa će vas onda pustiti; pustiće sasvim, i još će vas terati. ");
INSERT INTO srp1865_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","A sada kaži narodu neka svaki čovek ište u suseda svog i svaka žena u susede svoje nakita srebrnih i nakita zlatnih. ");
INSERT INTO srp1865_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","I Gospod učini te narod nađe ljubav u Misiraca; i sam Mojsije beše vrlo velik čovek u zemlji misirskoj kod sluga Faraonovih i kod naroda. ");
INSERT INTO srp1865_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","I reče Mojsije: Ovako veli Gospod: Oko ponoći proći ću kroz Misir, ");
INSERT INTO srp1865_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","i pomreće svi prvenci u zemlji misirskoj, od prvenca Faraonovog, koji htede sedeti na prestolu njegovom, do prvenca sluškinje za žrvnjem, i od stoke šta je god prvenac. ");
INSERT INTO srp1865_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","I biće vika velika po svoj zemlji misirskoj, kakve još nije bilo niti će je kad biti. ");
INSERT INTO srp1865_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","A kod sinova Izrailjevih nigde neće ni pas jezikom svojim maći ni među ljudima ni među stokom, da znate da je Gospod učinio razliku između Izrailjaca i Misiraca. ");
INSERT INTO srp1865_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","I doći će sve te sluge tvoje k meni, i pokloniće mi se govoreći: Idi, i ti i sav narod koji je pristao za tobom. I onda ću izaći. I otide Mojsije od Faraona s velikim gnevom. ");
INSERT INTO srp1865_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","A Gospod reče Mojsiju: Neće vas poslušati Faraon, da bih umnožio čudesa svoja u zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","I Mojsije i Aron učiniše sva ova čudesa pred Faraonom, a Gospod učini te otvrdnu srce Faraonu, i ne pusti sinove Izrailjeve iz zemlje svoje. ");
INSERT INTO srp1865_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","I reče Gospod Mojsiju i Aronu u zemlji misirskoj govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ovaj mesec da vam je početak mesecima, da vam je prvi mesec u godini. ");
INSERT INTO srp1865_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kažite svemu zboru Izrailjevom i recite: Desetog dana ovog meseca svaki neka uzme jagnje ili jare, po porodicama, po jedno na dom; ");
INSERT INTO srp1865_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ako li je dom mali za jagnje ili jare, neka uzme k sebi suseda, koji mu je najbliži, s onoliko duša koliko treba da mogu pojesti jagnje ili jare. ");
INSERT INTO srp1865_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","A jagnje ili jare da vam bude zdravo, muško, od godine; između ovaca ili između koza uzmite. ");
INSERT INTO srp1865_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","I čuvajte ga do četrnaestog dana ovog meseca, a tada savkoliki zbor Izrailjev neka ga zakolje uveče. ");
INSERT INTO srp1865_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","I neka uzmu krvi od njega i pokrope oba dovratka i gornji prag na kućama u kojima će ga jesti. ");
INSERT INTO srp1865_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","I neka jedu meso iste noći, na vatri pečeno, s hlebom presnim i sa zeljem gorkim neka jedu. ");
INSERT INTO srp1865_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nemojte jesti sirovo ni u vodi kuvano, nego na vatri pečeno, s glavom i s nogama i s drobom. ");
INSERT INTO srp1865_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","I ništa nemojte ostaviti do jutra; ako li bi šta ostalo do jutra, spalite na vatri. ");
INSERT INTO srp1865_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","A ovako jedite: opasani, obuća da vam je na nogu i štap u ruci, i jedite hitno, jer je prolazak Gospodnji. ");
INSERT INTO srp1865_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Jer ću proći po zemlji misirskoj tu noć, i pobiću sve prvence u zemlji misirskoj od čoveka do živinčeta, i sudiću svim bogovima misirskim, ja Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","A krv ona biće vam znak na kućama, u kojima ćete biti; i kad vidim krv, proći ću vas, te neće biti među vama pomora, kad stanem ubijati po zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","I taj će vam dan biti za spomen, i praznovaćete ga Gospodu od kolena do kolena; praznujte ga zakonom večnim. ");
INSERT INTO srp1865_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sedam dana jedite hlebove presne, i prvog dana uklonite kvasac iz kuća svojih; jer ko bi god jeo šta s kvascem od prvog dana do sedmog, istrebiće se ona duša iz Izrailja. ");
INSERT INTO srp1865_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Prvi dan biće sveti sabor; tako i sedmi dan imaćete sveti sabor; nikakav posao da se ne radi u te dane, osim šta treba za jelo svakoj duši, to ćete samo gotoviti. ");
INSERT INTO srp1865_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","I držite dan presnih hlebova, jer u taj dan izvedoh vojske vaše iz zemlje misirske; držite taj dan od kolena do kolena zakonom večnim. ");
INSERT INTO srp1865_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Prvog meseca četrnaesti dan uveče počnite jesti presne hlebove pa do dvadeset prvog dana istog meseca uveče. ");
INSERT INTO srp1865_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Za sedam dana da se ne nađe kvasca u kućama vašim; jer ko bi god jeo šta s kvascem, istrebiće se ona duša iz zbora Izrailjevog, bio došljak ili rođen u zemlji. ");
INSERT INTO srp1865_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ništa s kvascem nemojte jesti, nego jedite hleb presan po svim stanovima svojim. ");
INSERT INTO srp1865_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","I sazva Mojsije sve starešine izrailjske, i reče im: Izberite i uzmite sebi jagnje ili jare po porodicama svojim, i zakoljite pashu. ");
INSERT INTO srp1865_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","I uzmite kitu isopa i zamočite je u krv, koja će biti u zdeli, i pokropite gornji prag i oba dovratka krvlju, koja će biti u zdeli, i nijedan od vas da ne izlazi na vrata kućna do jutra. ");
INSERT INTO srp1865_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Jer će izaći Gospod da bije Misir, pa kad vidi krv na gornjem pragu i na oba dovratka, proći će Gospod mimo ona vrata, i neće dati krvniku da uđe u kuće vaše da ubija. ");
INSERT INTO srp1865_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","I držite ovo kao zakon tebi i sinovima tvojim doveka. ");
INSERT INTO srp1865_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","I kad dođete u zemlju koju će vam dati Gospod, kao što je kazao, držite ovu službu. ");
INSERT INTO srp1865_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","I kad vam kažu sinovi vaši: Kakva vam je to služba? ");
INSERT INTO srp1865_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Recite: Ovo je žrtva za prolazak Gospodnji, kad prođe kuće sinova Izrailjevih u Misiru ubijajući Misirce, a domove naše sačuva. Tada narod savi glavu i pokloni se. ");
INSERT INTO srp1865_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","I otidoše i učiniše sinovi Izrailjevi, kako zapovedi Gospod preko Mojsija i Arona, tako učiniše. ");
INSERT INTO srp1865_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A oko ponoći pobi Gospod sve prvence u zemlji misirskoj od prvenca Faraonovog koji htede sedeti na prestolu njegovom do prvenca sužnja u tamnici, i šta god beše prvenac od stoke. ");
INSERT INTO srp1865_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tada usta Faraon one noći, on i sve sluge njegove i svi Misirci, i bi vika velika u Misiru, jer ne beše kuće u kojoj ne bi mrtvaca. ");
INSERT INTO srp1865_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","I dozva Mojsija i Arona po noći i reče: Ustajte, idite iz naroda mog i vi i sinovi Izrailjevi, i otidite, poslužite Gospodu, kao što govoriste. ");
INSERT INTO srp1865_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Uzmite i ovce svoje i goveda svoja, kao što govoriste, i idite, pa i mene blagoslovite. ");
INSERT INTO srp1865_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","I Misirci navaljivahu na narod da brže idu iz zemlje, jer govorahu: Izgibosmo svi. ");
INSERT INTO srp1865_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","I narod uze testo svoje još neuskislo, umotavši ga u haljine svoje, na ramena svoja. ");
INSERT INTO srp1865_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","I učiniše sinovi Izrailjevi po zapovesti Mojsijevoj, i zaiskaše u Misiraca nakita srebrnih i nakita zlatnih i haljina. ");
INSERT INTO srp1865_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","I Gospod učini, te narod nađe ljubav u Misiraca, te im dadoše; tako opleniše Misirce. ");
INSERT INTO srp1865_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","I otidoše sinovi Izrailjevi iz Ramese u Sohot, oko šest stotina hiljada pešaka, samih ljudi osim dece. ");
INSERT INTO srp1865_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","I drugih ljudi mnogo otide s njima, i stoke sitne i krupne vrlo mnogo. ");
INSERT INTO srp1865_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","I od testa koje iznesoše iz Misira ispekoše pogače presne, jer ne beše uskislo kad ih poteraše Misirci, te ne mogaše oklevati, niti spremiše sebi brašnjenice. ");
INSERT INTO srp1865_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","A baviše se sinovi Izrailjevi u Misiru četiri stotine i trideset godina. ");
INSERT INTO srp1865_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","I kad se navrši četiri stotine i trideset godina, u isti dan izađoše sve vojske Gospodnje iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ta se noć svetkuje Gospodu, u koju ih izvede iz Misira; to je noć Gospodnja, koju treba da svetkuju sinovi Izrailjevi od kolena na koleno. ");
INSERT INTO srp1865_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","I reče Gospod Mojsiju i Aronu: Ovo neka bude zakon za pashu: nijedan tuđin da je ne jede; ");
INSERT INTO srp1865_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","a svaki sluga vaš kupljen za novce, kad ga obrežete, onda neka je jede. ");
INSERT INTO srp1865_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Došljak ili najamnik da je ne jede. ");
INSERT INTO srp1865_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","U istoj kući da se jede, da ne iznesete mesa od nje iz kuće, i kosti da joj ne prelomite. ");
INSERT INTO srp1865_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Sav zbor Izrailjev neka čini tako. ");
INSERT INTO srp1865_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ako bi kod tebe sedeo tuđin i hteo bi svetkovati pashu Gospodnju, neka mu se obrežu sve muškinje, pa onda neka pristupi da je svetkuje, i neka bude kao rođen u zemlji; a niko neobrezan da je ne jede. ");
INSERT INTO srp1865_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Zakon jedan da je i rođenom u zemlji i došljaku koji sedi među vama. ");
INSERT INTO srp1865_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","I učiniše svi sinovi Izrailjevi kako zapovedi Gospod Mojsiju i Aronu, tako učiniše. ");
INSERT INTO srp1865_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","I taj dan izvede Gospod sinove Izrailjeve iz zemlje misirske u četama njihovim. ");
INSERT INTO srp1865_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Posveti mi svakog prvenca, šta god otvara matericu u sinova Izrailjevih, i od ljudi i od stoke; jer je moje. ");
INSERT INTO srp1865_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","I Mojsije reče narodu: Pamtite ovaj dan, u koji iziđoste iz Misira, iz doma ropskog, jer vas rukom krepkom izvede Gospod odande; neka se dakle ne jede ništa s kvascem. ");
INSERT INTO srp1865_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Danas izlazite, meseca Aviva; ");
INSERT INTO srp1865_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","pa kad te Gospod uvede u zemlju hananejsku i hetejsku i amorejsku i jevejsku i jevusejsku, za koju se zakleo ocima tvojim da će ti je dati, zemlju u kojoj teče mleko i med, tada da služiš službu ovu ovog meseca; ");
INSERT INTO srp1865_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","sedam dana jedi hlebove presne, a sedmi dan neka je praznik Gospodnji. ");
INSERT INTO srp1865_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Hlebovi presni da se jedu sedam dana, i da se ne vidi u tebe ništa s kvascem, niti da se vidi u tebe kvasac u celom kraju tvom. ");
INSERT INTO srp1865_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","I kazaćeš sinu svom u taj dan govoreći: Ovo je za ono što mi je učinio Gospod kad sam izlazio iz Misira. ");
INSERT INTO srp1865_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","I neka ti bude kao znak na ruci tvojoj i kao spomen pred očima tvojim, da ti zakon Gospodnji bude u ustima; jer te je rukom krepkom izveo Gospod iz Misira. ");
INSERT INTO srp1865_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Zato vrši zakon ovaj na vreme, od godine do godine. ");
INSERT INTO srp1865_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","I kad te uvede Gospod u zemlju hananejsku, kao što se zakleo tebi i tvojim ocima, i da ti je, ");
INSERT INTO srp1865_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","odvajaćeš Gospodu šta god otvara matericu, i od stoke tvoje šta god otvara matericu, šta je muško, da bude Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","A svako magare prvenče otkupi jagnjetom ili jaretom; ako li ga ne bi otkupio, slomi mu vrat. Ali svakog prvenca čovečjeg između sinova svojih otkupi. ");
INSERT INTO srp1865_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","A kad te zapita sin tvoj unapred govoreći: Šta je to? Reci mu: Rukom krepkom izvede nas Gospod iz Misira, iz doma ropskog. ");
INSERT INTO srp1865_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Jer kad otvrdnu Faraon, te nas ne hte pustiti, pobi Gospod sve prvence u zemlji misirskoj od prvenca čovečjeg do prvenca od stoke; zato prinosim Gospodu sve muško što otvara matericu, a svakog prvenca sinova svojih otkupljujem. ");
INSERT INTO srp1865_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","I to neka ti je kao znak na ruci i kao počeonik među očima tvojim, da nas je rukom krepkom izveo Gospod iz Misira. ");
INSERT INTO srp1865_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","A kad Faraon pusti narod, ne odvede ih Bog putem k zemlji filistejskoj, ako i beše kraći, jer Bog reče: Da se ne pokaje narod kad vidi rat, i ne vrati se u Misir. ");
INSERT INTO srp1865_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Nego Bog zavede narod putem preko pustinje na Crvenom Moru. A vojničkim redom iziđoše sinovi Izrailjevi iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","I Mojsije uze kosti Josifove sa sobom; jer beše zakleo sinove Izrailjeve rekavši: Zaista će vas pohoditi Bog, a tada iznesite kosti moje odavde sa sobom. ");
INSERT INTO srp1865_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Tako otišavši iz Sohota stadoše u logor u Etamu, nakraj pustinje. ");
INSERT INTO srp1865_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","A Gospod iđaše pred njima danju u stupu od oblaka vodeći ih putem, a noću u stupu od ognja svetleći im, da bi putovali danju i noću. ");
INSERT INTO srp1865_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","I ne uklanjaše ispred naroda stup od oblaka danju ni stup od ognja noću. ");
INSERT INTO srp1865_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Kaži sinovima Izrailjevim neka saviju i stanu u logor pred Pi-Airot između Migdola i mora prema Vel-Sefonu; prema njemu neka stanu u logor pokraj mora. ");
INSERT INTO srp1865_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Jer će Faraon reći za sinove Izrailjeve: Zašli su u zemlju, zatvorila ih je pustinja. ");
INSERT INTO srp1865_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I učiniću da otvrdne srce Faraonu, te će poći u poteru za vama, i ja ću se proslaviti na njemu i na svoj vojsci njegovoj, i Misirci će poznati da sam ja Gospod. I učiniše tako. ");
INSERT INTO srp1865_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","A kad bi javljeno caru misirskom da je pobegao narod, promeni se srce Faraonovo i sluga njegovih prema narodu, te rekoše: Šta učinismo, te pustismo Izrailja da nam ne služi? ");
INSERT INTO srp1865_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","I upreže u kola svoja, i uze narod svoj sa sobom. ");
INSERT INTO srp1865_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","I uze šest stotina kola izabranih i šta još beše kola misirskih, i nad svima vojvode. ");
INSERT INTO srp1865_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","I Gospod učini te otvrdnu srce Faraonu caru misirskom, i pođe u poteru za sinovima Izrailjevim, kad sinovi Izrailjevi otidoše pod rukom visokom. ");
INSERT INTO srp1865_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","I teravši ih Misirci stigoše ih, sva kola Faraonova, konjici njegovi i vojska njegova, kad behu u logoru na moru kod Pi-Airota prema Vel-Sefonu. ");
INSERT INTO srp1865_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","I kad se približi Faraon, podigoše sinovi Izrailjevi oči svoje a to Misirci idu za njima, i uplašiše se vrlo, i povikaše sinovi Izrailjevi ka Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","I rekoše Mojsiju: Zar ne beše grobova u Misiru, nego nas dovede da izginemo u pustinji? Šta učini, te nas izvede iz Misira. ");
INSERT INTO srp1865_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nismo li ti govorili u Misiru i rekli: Prođi nas se, neka služimo Misircima? Jer bi nam bolje bilo služiti Misircima nego izginuti u pustinji. ");
INSERT INTO srp1865_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","A Mojsije reče narodu: Ne bojte se, stanite pa gledajte kako će vas Gospod izbaviti danas; jer Misirce koje ste videli danas, nećete ih nikada više videti do veka. ");
INSERT INTO srp1865_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Gospod će se biti za vas, a vi ćete ćutati. ");
INSERT INTO srp1865_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","A Gospod reče Mojsiju: Što vičeš k meni? Kaži sinovima Izrailjevim neka idu. ");
INSERT INTO srp1865_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","A ti digni štap svoj i pruži ruku svoju na more, i rascepi ga, pa neka idu sinovi Izrailjevi posred mora suvim. ");
INSERT INTO srp1865_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","I gle, ja ću učiniti da otvrdne srce Misircima, te će poći za njima; i proslaviću se na Faraonu i na svoj vojsci njegovoj, na kolima njegovim i na konjicima njegovim. ");
INSERT INTO srp1865_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","I Misirci će poznati da sam ja Gospod, kad se proslavim na Faraonu, na kolima njegovim i na konjicima njegovim. ");
INSERT INTO srp1865_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","I podiže se anđeo Gospodnji, koji iđaše pred vojskom izrailjskom, i otide im za leđa; i podiže se stup od oblaka ispred njih, i stade im za leđa. ");
INSERT INTO srp1865_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","I došav među vojsku misirsku i vojsku izrailjsku beše onim oblak mračan a ovim svetljaše po noći, te ne pristupiše jedni drugima celu noć. ");
INSERT INTO srp1865_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","I pruži Mojsije ruku svoju na more, a Gospod uzbi more vetrom istočnim, koji jako duvaše celu noć, i osuši more, i voda se rastupi. ");
INSERT INTO srp1865_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","I pođoše sinovi Izrailjevi posred mora suvim, i voda im stajaše kao zid s desne strane i s leve strane. ");
INSERT INTO srp1865_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","I Misirci terajući ih pođoše za njima posred mora, svi konji Faraonovi, kola i konjici njegovi. ");
INSERT INTO srp1865_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","A u stražu jutarnju pogleda Gospod na vojsku misirsku iz stupa od ognja i oblaka, i smete vojsku misirsku. ");
INSERT INTO srp1865_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","I pobaca točkove kolima njihovim, te ih jedva vucijahu. Tada rekoše Misirci: Bežimo od Izrailja, jer se Gospod bije za njih s Misircima. ");
INSERT INTO srp1865_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","A Gospod reče Mojsiju: Pruži ruku svoju na more, neka se vrati voda na Misirce, na kola njihova i na konjike njihove. ");
INSERT INTO srp1865_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","I Mojsije pruži ruku svoju na more, i dođe opet more na silu svoju pred zoru, a Misirci nagoše bežati prema moru; i Gospod baci Misirce usred mora. ");
INSERT INTO srp1865_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","A vrativši se voda potopi kola i konjike sa svom vojskom Faraonovom, što ih god beše pošlo za njima u more, i ne osta od njih nijedan. ");
INSERT INTO srp1865_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","I sinovi Izrailjevi iđahu posred mora suvim; i stajaše im voda kao zid s desne strane i s leve strane. ");
INSERT INTO srp1865_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","I izbavi Gospod Izrailja u onaj dan iz ruku misirskih; i vide Izrailj mrtve Misirce na bregu morskom. ");
INSERT INTO srp1865_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","I vide Izrailj silu veliku, koju pokaza Gospod na Misircima, i narod se poboja Gospoda, i verova Gospodu i Mojsiju sluzi Njegovom. ");
INSERT INTO srp1865_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tada zapeva Mojsije i sinovi Izrailjevi ovu pesmu Gospodu, i rekoše ovako: Pevaću Gospodu, jer se slavno proslavi; konja i konjika vrže u more. ");
INSERT INTO srp1865_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Sila je moja i pesma moja Gospod, koji me izbavi; On je Bog moj, i slaviću Ga; Boga oca mog, i uzvišavaću Ga. ");
INSERT INTO srp1865_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Gospod je velik ratnik; ime mu je Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Kola Faraonova i vojsku njegovu vrže u more; izbrane vojvode njegove utopiše se u crvenom moru. ");
INSERT INTO srp1865_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Bezdani ih pokriše; padoše u dubinu kao kamen. ");
INSERT INTO srp1865_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Desnica Tvoja, Gospode, proslavi se u sili; desnica Tvoja, Gospode, satre neprijatelja. ");
INSERT INTO srp1865_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I mnoštvom veličanstva svog oborio si one koji ustaše na te; pustio si gnev svoj, i proždre ih kao slamu. ");
INSERT INTO srp1865_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Od daha nozdrva Tvojih sabra se voda; stade u gomilu voda koja teče; stinuše se vali usred mora. ");
INSERT INTO srp1865_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Neprijatelj reče: Teraću, stignuću, deliću plen; nasitiće ih se duša moja, izvući ću mač svoj, istrebiće ih ruka moja. ");
INSERT INTO srp1865_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ti dunu vetrom svojim, i more ih pokri, i utonuše kao olovo u dubokoj vodi. ");
INSERT INTO srp1865_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ko je kao Ti među silnima. Gospode? Ko je kao Ti slavan u svetosti, strašan u hvali, i da čini čudesa? ");
INSERT INTO srp1865_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ti pruži desnicu svoju, i proždre ih zemlja. ");
INSERT INTO srp1865_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Vodiš milošću svojom narod, koji si iskupio, vodiš krepošću svojom u stan svetosti svoje. ");
INSERT INTO srp1865_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Čuće narodi, i zadrhtaće; muka će spopasti one koji žive u zemlji filistejskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tada će se prepasti starešine edomske, junake moavske spopašće drhat, uplašiće se svi koji žive u hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Spopašće ih strah i trepet; od veličine ruke Tvoje zamuknuće kao kamen, dokle ne prođe narod Tvoj, Gospode, dokle ne prođe narod koji si zadobio. ");
INSERT INTO srp1865_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Odvešćeš ih i posadićeš ih na gori nasledstva svog, na mestu koje si sebi za stan spremio, Gospode, u svetinji, Gospode, koju su Tvoje ruke utvrdile. ");
INSERT INTO srp1865_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Gospod će carovati doveka. ");
INSERT INTO srp1865_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Jer uđoše konji Faraonovi s kolima njegovim i s konjicima njegovim u more, i Gospod povrati na njih vodu morsku; a sinovi Izrailjevi pređoše suvim posred mora. ");
INSERT INTO srp1865_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","I Marija proročica, sestra Aronova, uze bubanj u ruku svoju; a za njom iziđoše sve žene s bubnjevima i sviralama. ");
INSERT INTO srp1865_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","I otpevaše im Marija: Pevajte Gospodu, jer se slavno proslavi; konja i konjika vrže u more. ");
INSERT INTO srp1865_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Potom krenu Mojsije sinove Izrailjeve od Mora Crvenog, i pođoše u pustinju Sur; i tri dana išavši po pustinji ne nađoše vodu. ");
INSERT INTO srp1865_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Odande dođoše u Meru, ali ne mogoše piti vodu u Meri, jer beše gorka; otuda se prozva mesto Mera. ");
INSERT INTO srp1865_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tada stade narod vikati na Mojsija govoreći: Šta ćemo piti? ");
INSERT INTO srp1865_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","I Mojsije zavapi ka Gospodu, a Gospod mu pokaza drvo, te ga metnu u vodu, i voda posta slatka. Onde mu dade uredbu i zakon, i onde ga okuša. ");
INSERT INTO srp1865_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I reče: Ako dobro uzaslušaš glas Gospoda Boga svog, i učiniš što je pravo u očima Njegovim, i ako prigneš uho k zapovestima Njegovim i sačuvaš sve uredbe Njegove, nijednu bolest koju sam pustio na Misir neću pustiti na tebe; jer sam ja Gospod, lekar tvoj. ");
INSERT INTO srp1865_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","I dođoše u Elim, gde beše dvanaest izvora i sedamdeset palmi; i onde stadoše u logor kod vode. ");
INSERT INTO srp1865_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Od Elima se podigoše, i sav zbor sinova Izrailjevih dođe u pustinju Sin, koja je između Elima i Sinaja, petnaestog dana drugog meseca pošto iziđoše iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","I stade vikati sav zbor sinova Izrailjevih na Mojsija i na Arona u pustinji, ");
INSERT INTO srp1865_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","i rekoše im sinovi Izrailjevi: Kamo da smo pomrli od ruke Gospodnje u zemlji misirskoj, kad sedasmo kod lonaca s mesom i jeđasmo hleba izobila! Jer nas izvedoste u ovu pustinju da pomorite sav ovaj zbor glađu. ");
INSERT INTO srp1865_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","A Gospod reče Mojsiju: Evo učiniću da vam daždi iz neba hleb, a narod neka izlazi i kupi svaki dan koliko treba na dan, da ga okušam hoće li hoditi po mom zakonu ili neće. ");
INSERT INTO srp1865_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A šestog dana neka zgotove šta donesu, a neka bude dvojinom onoliko koliko nakupe svaki dan. ");
INSERT INTO srp1865_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","I reče Mojsije i Aron svim sinovima Izrailjevim: Doveče ćete poznati da vas je Gospod izveo iz zemlje misirske; ");
INSERT INTO srp1865_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","a sutra ćete videti slavu Gospodnju; jer je čuo viku vašu na Gospoda. Jer šta smo mi da vičete na nas? ");
INSERT INTO srp1865_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","I reče Mojsije: Doveče će vam dati Gospod mesa da jedete a ujutru hleba da se nasitite; jer je čuo Gospod viku vašu, kojom vičete na Nj. Jer šta smo mi? Nije na nas vaša vika nego na Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","I reče Mojsije Aronu: Kaži svemu zboru sinova Izrailjevih: Pristupite pred Gospoda, jer je čuo viku vašu. ");
INSERT INTO srp1865_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","I kad reče Aron svemu zboru sinova Izrailjevih, pogledaše u pustinju, i gle, slava Gospodnja pokaza se u oblaku. ");
INSERT INTO srp1865_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","I Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Čuo sam viku sinova Izrailjevih. Kaži im i reci: Doveče ćete jesti mesa, a sutra ćete se nasititi hleba, i poznaćete da sam ja Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","I uveče doleteše prepelice i prekriliše logor, a ujutru pade rosa oko logora; ");
INSERT INTO srp1865_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","a kad se diže rosa, a to po pustinji nešto sitno okruglo, sitno kao slana po zemlji. ");
INSERT INTO srp1865_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","I kad vide sinovi Izrailjevi, govorahu jedan drugom: Šta je ovo? Jer ne znahu šta beše. A Mojsije im reče: To je hleb što vam dade Gospod da jedete. ");
INSERT INTO srp1865_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","To je za šta zapovedi Gospod: kupite ga svaki dan koliko kome treba za jelo, po gomor na glavu, po broju duša vaših, svaki neka uzme za one koji su mu u šatoru. ");
INSERT INTO srp1865_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","I učiniše tako sinovi Izrailjevi; i nakupiše koji više koji manje. ");
INSERT INTO srp1865_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Pa meriše na gomor, i ne dođe više onom koji nakupi mnogo, niti manje onom koji nakupi malo, nego svaki nakupi koliko mu je trebalo da jede. ");
INSERT INTO srp1865_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","I reče im Mojsije: Niko da ne ostavlja od toga za sutra. ");
INSERT INTO srp1865_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ali ne poslušaše Mojsija, nego neki ostaviše od toga za sutra, te se ucrva i usmrde. I rasrdi se Mojsije na njih. ");
INSERT INTO srp1865_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tako ga kupljahu svako jutro, svaki koliko mu trebaše za jelo; a kad sunce ogrevaše, tada se rastapaše. ");
INSERT INTO srp1865_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","A u šesti dan nakupiše hleba dvojinom, po dva gomora na svakog; i dođoše sve starešine od zbora, i javiše Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","A on im reče: Ovo kaza Gospod: Sutra je subota, odmor svet Gospodu; šta ćete peći, pecite, i šta ćete kuvati, kuvajte danas; a šta preteče, ostavite i čuvajte za sutra. ");
INSERT INTO srp1865_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","I ostaviše za sutra, kao što zapovedi Mojsije, i ne usmrde se niti beše crva u njemu. ");
INSERT INTO srp1865_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","I reče Mojsije: Jedite to danas, jer je danas subota Gospodnja, danas nećete naći u polju. ");
INSERT INTO srp1865_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Šest ćete dana kupiti, a sedmi je dan subota, tada ga neće biti. ");
INSERT INTO srp1865_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","I u sedmi dan iziđoše neki od naroda da kupe, ali ne nađoše. ");
INSERT INTO srp1865_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","A Gospod reče Mojsiju: Dokle ćete se protiviti zapovestima mojim i zakonima mojim? ");
INSERT INTO srp1865_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Vidite, Gospod vam je dao subotu, zato vam daje šestog dana hleba na dva dana. Stojte svaki na svom mestu, i neka ne odlazi niko sa svog mesta u sedmi dan. ");
INSERT INTO srp1865_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","I počinu narod u sedmi dan. ");
INSERT INTO srp1865_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","I dom Izrailjev prozva taj hleb mana; a beše kao seme korijandrovo, beo, i na jeziku kao medeni kolači. ");
INSERT INTO srp1865_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","I reče Mojsije: Ovo je zapovedio Gospod: napuni gomor toga, neka se čuva od kolena do kolena vašeg, da vide hleb, kojim sam vas hranio u pustinji kad vas izvedoh iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","I reče Mojsije Aronu: Uzmi krčag i naspi pun gomor mane, i metni pred Gospoda da se čuva od kolena do kolena vašeg. ");
INSERT INTO srp1865_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","I ostavi ga Aron pred svedočanstvom da se čuva, kao što zapovedi Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","A sinovi Izrailjevi jedoše manu četrdeset godina dok ne dođoše u zemlju u kojoj će živeti; jedoše manu dok ne dođoše na među zemlje hananske. ");
INSERT INTO srp1865_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","A gomor je desetina efe. ");
INSERT INTO srp1865_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","I podiže se iz pustinje Sina sav zbor sinova Izrailjevih putem svojim po zapovesti Gospodnjoj, i stadoše u logor u Rafidinu; a onde ne beše vode da narod pije. ");
INSERT INTO srp1865_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","I narod se svađaše s Mojsijem govoreći: Daj nam vode da pijemo. A on im reče: Što se svađate sa mnom? Što kušate Gospoda? ");
INSERT INTO srp1865_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ali narod beše onde žedan vode, te vikaše narod na Mojsija, i govoraše: Zašto si nas izveo iz Misira da nas i sinove naše i stoku našu pomoriš žeđu? ");
INSERT INTO srp1865_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","A Mojsije zavapi ka Gospodu govoreći: Šta ću činiti s ovim narodom? Još malo pa će me zasuti kamenjem. ");
INSERT INTO srp1865_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","A Gospod reče Mojsiju: Prođi pred narod, i uzmi sa sobom starešine izrailjske, i štap svoj kojim si udario vodu uzmi u ruku svoju, i idi. ");
INSERT INTO srp1865_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","A ja ću stajati pred tobom onde na steni na Horivu; a ti udari u stenu, i poteći će iz nje voda da pije narod. I učini Mojsije tako pred starešinama izrailjskim. ");
INSERT INTO srp1865_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","A mesto ono prozva Masa i Meriva zato što se svađaše sinovi Izrailjevi i što kušaše Gospoda govoreći: Je li Gospod među nama ili nije? ");
INSERT INTO srp1865_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ali dođe Amalik da se bije s Izrailjem u Rafidinu. ");
INSERT INTO srp1865_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","A Mojsije reče Isusu: Izberi nam ljude, te izađi i bij se s Amalikom; a ja ću sutra stati na vrh brda sa štapom Božjim u ruci. ");
INSERT INTO srp1865_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","I učini Isus kako mu reče Mojsije, i pobi se s Amalikom; a Mojsije i Aron i Or izađoše na vrh brda. ");
INSERT INTO srp1865_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","I dokle Mojsije držaše u vis ruke svoje, pobeđivahu Izrailjci, a kako bi spustio ruke, odmah nadvlađivahu Amaličani. ");
INSERT INTO srp1865_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ali ruke Mojsiju otežaše, zato uzeše kamen i podmetnuše poda nj, te sede; a Aron i Or držahu mu ruke jedan s jedne strane a drugi s druge, i ne klonuše mu ruke do zahoda sunčanog. ");
INSERT INTO srp1865_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","I razbi Isus Amalika i narod njegov oštrim mačem. ");
INSERT INTO srp1865_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Potom reče Gospod Mojsiju: Zapiši to za spomen u knjigu, i kaži Isusu neka pamti da ću sasvim istrebiti spomen Amalikov ispod neba. ");
INSERT INTO srp1865_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Tada načini Mojsije oltar, i nazva ga: Gospod, zastava moja. ");
INSERT INTO srp1865_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","I reče: Što se ruka beše podigla na presto Gospodnji, Gospod će ratovati na Amalika od kolena do kolena. ");
INSERT INTO srp1865_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","A Jotor sveštenik madijanski, tast Mojsijev, ču sve što učini Gospod Mojsiju i Izrailju narodu svom, kako izvede Gospod Izrailja iz Misira; ");
INSERT INTO srp1865_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","i uze, Jotor tast Mojsijev, Seforu ženu Mojsijevu, koju beše poslao natrag, ");
INSERT INTO srp1865_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","i dva sina njena, od kojih jednom beše ime Girsam, jer reče: Tuđin sam u zemlji tuđoj, ");
INSERT INTO srp1865_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","a drugom beše ime Elijezer, jer, reče, Bog oca mog bi mi u pomoći i ote me od mača Faraonovog. ");
INSERT INTO srp1865_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","I pođe Jotor, tast Mojsijev, sa sinovima njegovim i sa ženom njegovom k Mojsiju u pustinju, gde beše u logoru pod gorom Božijom. ");
INSERT INTO srp1865_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","I poruči Mojsiju: Ja tast tvoj Jotor idem k tebi i žena tvoja i oba sina njena s njom. ");
INSERT INTO srp1865_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","I Mojsije izađe na susret tastu svom i pokloni mu se i celiva ga; i upitaše se za zdravlje, pa uđoše pod šator njegov. ");
INSERT INTO srp1865_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","I pripovedi Mojsije tastu svom sve što učini Gospod Faraonu i Misircima radi Izrailja, i sve nevolje, koje ih nalaziše putem, i kako ih izbavi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","I radovaše se Jotor svemu dobru što učini Gospod Izrailju izbavivši ga iz ruke misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","I reče Jotor: Blagosloven da je Gospod, koji vas izbavi iz ruke misirske, i iz ruke Faraonove, koji izbavi narod iz ropstva misirskog. ");
INSERT INTO srp1865_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sad vidim da je Gospod veći od svih bogova, jer čim se ponošahu onim ih samim nadvisi. ");
INSERT INTO srp1865_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","I uze Jotor, tast Mojsijev i prinese Bogu žrtvu paljenicu i prinos; i dođe Aron i sve starešine izrailjske, i jedoše s tastom Mojsijevim pred Bogom. ");
INSERT INTO srp1865_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","A sutradan sede Mojsije da sudi narodu; i stajaše narod pred Mojsijem od jutra do večera. ");
INSERT INTO srp1865_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","A tast Mojsijev gledajući sve šta radi s narodom, reče: Šta to radiš s narodom? Zašto sediš sam, a sav narod stoji pred tobom od jutra do večera. ");
INSERT INTO srp1865_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","A Mojsije reče tastu svom: Jer dolazi narod k meni da pita Boga. ");
INSERT INTO srp1865_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kad imaju šta među sobom, dolaze k meni, te im sudim i kazujem naredbe Božje i zakone Njegove. ");
INSERT INTO srp1865_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","A tast Mojsijev reče mu: Nije dobro šta radiš. ");
INSERT INTO srp1865_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Umorićeš se i ti i narod koji je s tobom; jer je to teško za tebe, nećeš moći sam vršiti. ");
INSERT INTO srp1865_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nego poslušaj mene; ja ću te svetovati, i Bog će biti s tobom; ti budi pred Bogom za narod, i stvari njihove javljaj Bogu; ");
INSERT INTO srp1865_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","i uči ih naredbama i zakonima Njegovim, i pokazuj im put kojim će ići i šta će raditi. ");
INSERT INTO srp1865_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","A iz svega naroda izaberi ljude poštene, koji se boje Boga, ljude pravedne, koji mrze na mito, pa ih postavi nad njima za poglavare, hiljadnike, stotinike, pedesetnike i desetnike; ");
INSERT INTO srp1865_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","oni neka sude narodu u svako doba; pa svaku stvar veliku neka javljaju tebi, a svaku stvar malu neka raspravljaju sami; tako će ti biti lakše, kad i oni stanu nositi teret s tobom. ");
INSERT INTO srp1865_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ako to učiniš, i Bog ti zapovedi, možeš se održati, i sav će narod doći mirno na svoje mesto. ");
INSERT INTO srp1865_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","I Mojsije posluša tasta svog, i učini sve što reče. ");
INSERT INTO srp1865_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","I izabra Mojsije iz svega Izrailja ljude poštene, i postavi ih za poglavare nad narodom, hiljadnike, stotnike, pedesetnike i desetnike. ");
INSERT INTO srp1865_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Koji suđahu narodu u svako doba, a stvari teške javljahu Mojsiju, a male stvari raspravljahu sami. ");
INSERT INTO srp1865_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Posle otpusti Mojsije tasta svog, koji se vrati u svoju zemlju. ");
INSERT INTO srp1865_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Prvog dana trećeg meseca, pošto izađoše sinovi Izrailjevi iz Misira, tog dana dođoše u pustinju sinajsku. ");
INSERT INTO srp1865_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Krenuvši se iz Rafidina dođoše u pustinju sinajsku, i stadoše u logor u pustinji, a logor načiniše Izrailjci onde pod gorom. ");
INSERT INTO srp1865_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","I Mojsije izađe na goru k Bogu; i povika mu Gospod s gore govoreći: Ovako kaži domu Jakovljevom, i reci sinovima Izrailjevim: ");
INSERT INTO srp1865_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Videli ste šta sam učinio Misircima i kako sam vas kao na krilima orlovim nosio i doveo vas k sebi. ");
INSERT INTO srp1865_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","A sada ako dobro uzaslušate glas moj i uščuvate zavet moj, bićete moje blago mimo sve narode, premda je moja sva zemlja. ");
INSERT INTO srp1865_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","I bićete mi carstvo svešteničko i narod svet. To su reči koje ćeš kazati sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","A Mojsije dođe i sazva starešine narodne; i kaza im sve ove reči koje mu Gospod zapovedi. ");
INSERT INTO srp1865_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","A sav narod odgovori složno i reče: Šta je god kazao Gospod činićemo. I Mojsije javi Gospodu reči narodne. ");
INSERT INTO srp1865_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","A Gospod reče Mojsiju: Evo, ja ću doći k tebi u gustom oblaku, da narod čuje kad ti stanem govoriti i da ti veruje do veka. Jer Mojsije beše javio Gospodu reči narodne. ");
INSERT INTO srp1865_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","I reče Gospod Mojsiju: Idi k narodu, i osveštaj ih danas i sutra, i neka operu haljine svoje; ");
INSERT INTO srp1865_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","i neka budu gotovi za treći dan, jer će u treći dan sići Gospod na goru sinajsku pred svim narodom. ");
INSERT INTO srp1865_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","A postavićeš narodu među unaokolo, i reći ćeš: Čuvajte se da ne stupite na goru i da se ne dotaknete kraja njenog; šta se god dotakne gore, poginuće; ");
INSERT INTO srp1865_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","toga da se niko ne dotakne rukom, nego kamenjem da se zaspe ili da se ustreli, bilo živinče ili čovek, da ne ostane u životu. Kad rog zatrubi otežući onda neka pođu na goru. ");
INSERT INTO srp1865_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","I Mojsije siđe s gore k narodu; i osvešta narod, i opraše haljine svoje. ");
INSERT INTO srp1865_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","I reče narodu: Budite gotovi za treći dan, i ne ležite sa ženama. ");
INSERT INTO srp1865_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","A treći dan kad bi ujutru, gromovi zagrmeše i munje zasevaše, i posta gust oblak na gori, i zatrubi truba veoma jako, da zadrhta sav narod koji beše u logoru. ");
INSERT INTO srp1865_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Tada Mojsije izvede narod iz logora pred Boga, i stadoše ispod gore. ");
INSERT INTO srp1865_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","A gora se sinajska sva dimiše, jer siđe na nju Gospod u ognju; i dim se iz nje podizaše kao dim iz peći, i sva se gora tresla veoma. ");
INSERT INTO srp1865_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","I truba sve jače trubljaše, i Mojsije govoraše a Bog mu odgovaraše glasom. ");
INSERT INTO srp1865_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","I Gospod sišavši na goru sinajsku, na vrh gore, pozva Mojsija na vrh gore; i izađe Mojsije. ");
INSERT INTO srp1865_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","A Gospod reče Mojsiju: Siđi, opomeni narod da ne prestupe međe da vide Gospoda, da ne bi izginuli od mene. ");
INSERT INTO srp1865_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","I sami sveštenici, koji pristupaju ka Gospodu, neka se osveštaju, da ih ne bi pobio Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","A Mojsije reče Gospodu: Neće moći narod izaći na goru sinajsku, jer si nas Ti opomenuo rekavši: Načini među gori i osveštaj je. ");
INSERT INTO srp1865_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","A Gospod mu reče: Idi, siđi, pa onda dođi ti i Aron s tobom; a sveštenici i narod neka ne prestupe međe da se popnu ka Gospodu, da ih ne bi pobio. ");
INSERT INTO srp1865_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","I siđe Mojsije k narodu, i kaza im. ");
INSERT INTO srp1865_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Tada reče Bog sve ove reči govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ja sam Gospod Bog tvoj, koji sam te izveo iz zemlje misirske, iz doma ropskog. ");
INSERT INTO srp1865_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Nemoj imati drugih bogova uza me. ");
INSERT INTO srp1865_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ne gradi sebi lik rezani niti kakvu sliku od onog što je gore na nebu, ili dole na zemlji, ili u vodi, ispod zemlje. ");
INSERT INTO srp1865_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Nemoj im se klanjati niti im služiti, jer sam ja Gospod Bog tvoj, Bog revnitelj, koji pohodim grehe otačke na sinovima do trećeg i do četvrtog kolena, onih koji mrze na mene; ");
INSERT INTO srp1865_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","a činim milost na hiljadama onih koji me ljube i čuvaju zapovesti moje. ");
INSERT INTO srp1865_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ne uzimaj uzalud ime Gospoda Boga svog; jer neće pred Gospodom biti prav ko uzme ime Njegovo uzalud. ");
INSERT INTO srp1865_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sećaj se dana od odmora da ga svetkuješ. ");
INSERT INTO srp1865_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Šest dana radi, i svršuj sve poslove svoje. ");
INSERT INTO srp1865_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","A sedmi je dan odmor Gospodu Bogu tvom; tada nemoj raditi nijedan posao, ni ti, ni sin tvoj, ni kći tvoja, ni sluga tvoj, ni sluškinja tvoja, ni živinče tvoje, ni stranac koji je među vratima tvojim. ");
INSERT INTO srp1865_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Jer je za šest dana stvorio Gospod nebo i zemlju, more i šta je god u njima; a u sedmi dan počinu; zato je blagoslovio Gospod dan od odmora i posvetio ga. ");
INSERT INTO srp1865_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Poštuj oca svog i mater svoju, da ti se produže dani na zemlji, koju ti da Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ne ubij. ");
INSERT INTO srp1865_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ne čini preljube. ");
INSERT INTO srp1865_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ne kradi. ");
INSERT INTO srp1865_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ne svedoči lažno na bližnjeg svog. ");
INSERT INTO srp1865_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ne poželi kuću bližnjeg svog, ne poželi ženu bližnjeg svog, ni slugu njegovog, ni sluškinju njegovu, ni vola njegovog, ni magarca njegovog, niti išta što je bližnjeg tvog. ");
INSERT INTO srp1865_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","I sav narod vide grom i munju i trubu gde trubi i goru gde se dimi; i narod videvši to uzmače se i stade izdaleka, ");
INSERT INTO srp1865_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","i rekoše Mojsiju: Govori nam ti, i slušaćemo; a neka nam ne govori Bog, da ne pomremo. ");
INSERT INTO srp1865_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","A Mojsije reče narodu: Ne bojte se, jer Bog dođe da vas iskuša i da vam pred očima bude strah Njegov da ne biste grešili. ");
INSERT INTO srp1865_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","I narod stajaše izdaleka, a Mojsije pristupi k mraku u kome beše Bog. ");
INSERT INTO srp1865_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","I Gospod reče Mojsiju: Ovako kaži sinovima Izrailjevim: videli ste gde vam s neba govorih. ");
INSERT INTO srp1865_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ne gradite uza me bogove srebrne, ni bogove zlatne ne gradite sebi. ");
INSERT INTO srp1865_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Oltar od zemlje načini mi, na kome ćeš mi prinositi žrtve svoje paljenice i žrtve svoje zahvalne, sitnu i krupnu stoku svoju. Na kome god mestu zapovedim da se spominje ime moje, doći ću k tebi i blagosloviću te. ");
INSERT INTO srp1865_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ako li mi načiniš oltar od kamena, nemoj načiniti od tesanog kamena; jer ako povučeš po njemu gvožđem, oskvrnićeš ga. ");
INSERT INTO srp1865_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Nemoj uz basamake ići k oltaru mom, da se ne bi otkrila golotinja tvoja kod njega. ");
INSERT INTO srp1865_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","A ovo su zakoni koje ćeš im postaviti: ");
INSERT INTO srp1865_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ako kupiš roba Jevrejina, šest godina neka ti služi, a sedme nek otide slobodan bez otkupa. ");
INSERT INTO srp1865_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ako bude došao inokosan, neka i otide inokosan; ako li bude imao ženu, neka ide i žena s njim. ");
INSERT INTO srp1865_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ako ga gospodar njegov oženi, i žena mu rodi sinove ili kćeri, žena s decom svojom neka bude gospodaru njegovom, a on neka otide sam. ");
INSERT INTO srp1865_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ako li rob reče tvrdo: Ljubim gospodara svog, ženu svoju i decu svoju, neću da idem da budem slobodan, ");
INSERT INTO srp1865_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","onda neka ga dovede gospodar njegov pred sudije i postavi na vratima ili kod dovratka, i onde neka mu gospodar probuši uho šilom, pa neka mu robuje doveka. ");
INSERT INTO srp1865_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ako ko proda kćer svoju da bude robinja, da ne odlazi kao robovi što odlaze. ");
INSERT INTO srp1865_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ako ne bude po volji gospodaru svom, i on je ne uzme za ženu, neka je pusti na otkupe; ali da nema vlasti prodati je u tuđ narod učinivši joj neveru. ");
INSERT INTO srp1865_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ako li je zaruči sinu svom, da joj učini po pravu koje imaju kćeri. ");
INSERT INTO srp1865_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ako li uzme drugu, da joj ne umali hrane ni odela ni zajednice. ");
INSERT INTO srp1865_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ako joj ovo troje ne učini, onda nek otide bez otkupa. ");
INSERT INTO srp1865_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Ko udari čoveka, te umre, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ako li ne bude hteo, nego mu ga Bog dade u ruke, odrediću ti mesto kuda može pobeći. ");
INSERT INTO srp1865_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ako bi ko namerno ustao na bližnjeg svog da ga ubije iz prevare, odvuci ga i od oltara mog da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ko udari oca svog ili mater svoju, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ko ukrade čoveka i proda ili se nađe u njegovim rukama, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ko opsuje oca svog ili mater svoju, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Kad se svade ljudi, pa jedan udari drugog kamenom ili pesnicom, ali onaj ne umre nego padne u postelju, ");
INSERT INTO srp1865_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ako se pridigne i izađe o štapu, da ne bude kriv onaj koji je udario, samo dangubu da mu naknadi i svu vidarinu da plati. ");
INSERT INTO srp1865_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ko udari roba svog ili robinju štapom tako da mu umre pod rukom, da je kriv; ");
INSERT INTO srp1865_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ali ako preživi dan ili dva, da nije kriv, jer je njegov novac. ");
INSERT INTO srp1865_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Kad se svade ljudi, pa koji od njih udari trudnu ženu tako da izađe iz nje dete, ali se ne dogodi smrt, da plati globu koliko muž ženin reče, a da plati preko sudija; ");
INSERT INTO srp1865_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ako li se dogodi smrt, tada ćeš uzeti život za život, ");
INSERT INTO srp1865_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","oko za oko, zub za zub, ruku za ruku, nogu za nogu, ");
INSERT INTO srp1865_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","užeg za užeg, ranu za ranu, modricu za modricu. ");
INSERT INTO srp1865_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ako ko udari po oku roba svog ili robinju svoju, te mu pokvari oko, da ga otpusti slobodnog za oko njegovo. ");
INSERT INTO srp1865_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","I ako izbije zub robu svom ili robinji svojoj, da ga pusti slobodnog za zub njegov. ");
INSERT INTO srp1865_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ako vo ubode čoveka ili ženu, te umre, da se vo zaspe kamenjem i da se ne jede meso od njega, a gospodar od vola da nije kriv. ");
INSERT INTO srp1865_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ali ako je vo pre bio bodač i gospodar njegov znao za to pa ga nije čuvao, te ubije čoveka ili ženu, vo da se zaspe kamenjem, i gospodar njegov da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ako mu se odredi da se otkupi, neka da otkup za život svoj, koliko mu se odredi. ");
INSERT INTO srp1865_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ako ubode sina ili kćer, da mu bude po istom zakonu. ");
INSERT INTO srp1865_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ako li roba ubode vo ili robinju, da da gospodaru njihovom trideset sikala srebra i vo da se zaspe kamenjem. ");
INSERT INTO srp1865_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ako ko otkrije jamu ili iskopa jamu a ne pokrije, pa upadne vo ili magarac, ");
INSERT INTO srp1865_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","da naknadi gospodar od jame i plati novcem gospodaru njihovom, a što je uginulo da je njegovo. ");
INSERT INTO srp1865_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ako vo jednog ubode vola drugom, te pogine, onda da prodadu vola živog i novce da podele, tako i ubijenog vola da podele. ");
INSERT INTO srp1865_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ako li se znalo da je vo pre bio bodač pa ga nije čuvao gospodar njegov, da da vola za vola, a ubijeni neka bude njemu. ");
INSERT INTO srp1865_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ko ukrade vola ili ovcu ili kozu, i zakolje ili proda, da vrati pet volova za jednog vola, a četiri ovce ili koze za jednu ovcu ili kozu. ");
INSERT INTO srp1865_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ako se lupež uhvati gde potkopava, te bude ranjen tako da umre, da ne bude kriv za krv onaj koji ga bude ubio; ");
INSERT INTO srp1865_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ali ako se bude sunce rodilo, da je kriv za krv. A lupež sve da naknadi; ako li ne bi imao, onda da se on proda za svoju krađu. ");
INSERT INTO srp1865_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ako se nađe šta je pokrao u njegovoj ruci živo, bio vo ili magarac ili ovca ili koza, da vrati dvostruko. ");
INSERT INTO srp1865_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ko potre njivu ili vinograd pustivši stoku svoju da pase po tuđoj njivi, da naknadi najboljim sa svoje njive i najboljim iz svog vinograda. ");
INSERT INTO srp1865_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ako izađe vatra i naiđe na trnje, pa izgori stog ili žito koje još stoji ili njiva, da naknadi onaj koji je zapalio. ");
INSERT INTO srp1865_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ako ko da bližnjemu svom novce ili posuđe na ostavu, pa se ukrade iz kuće njegove, ako se nađe lupež, da plati dvojinom; ");
INSERT INTO srp1865_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ako li se ne nađe lupež, onda gospodar od one kuće da stane pred sudije da se zakune da nije posegao rukom svojom na stvar bližnjeg svog. ");
INSERT INTO srp1865_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Za svaku stvar za koju bi bila raspra, ili za vola ili za magarca ili za ovcu ili za kozu, ili za haljinu, za svaku stvar izgubljenu, kad ko kaže da je njegova, pred sudije da dođe raspra obojice, pa koga osude sudije, onaj da vrati bližnjemu svom dvojinom. ");
INSERT INTO srp1865_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ako ko da bližnjemu svom da čuva magarca ili vola ili ovcu ili kozu ili kako god živinče, pa ugine ili ohrone, ili ga ko otera a da niko ne vidi, ");
INSERT INTO srp1865_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","zakletva Gospodnja neka bude između njih, da nije posegao rukom svojom na stvar bližnjeg svog, i gospodar od stvari neka pristane, a onaj da ne plati. ");
INSERT INTO srp1865_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ako li mu bude ukradeno, neka plati gospodaru njegovom. ");
INSERT INTO srp1865_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ako li ga bude rastrgla zverka da donese od njega svedodžbu, i da ne plati šta je rastrgnuto. ");
INSERT INTO srp1865_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ako ko uzme od bližnjeg svog živinče na poslugu, pa ohrone ili ugine, a gospodar mu ne bude kod njega, da plati. ");
INSERT INTO srp1865_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ako li gospodar bude kod njega, da ne plati. Ako li bude najmljeno, da plati samo najam. ");
INSERT INTO srp1865_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ko bi prevario devojku, koja nije zaručena, te bi spavao s njom, da joj da miraz i uzme je za ženu. ");
INSERT INTO srp1865_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","A ako mu je otac njen ne bi hteo dati, da da novaca koliko ide u miraz devojci. ");
INSERT INTO srp1865_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Veštici ne daj da živi. ");
INSERT INTO srp1865_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ko bi obležao živinče, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ko žrtvu prinosi bogovima drugim osim jedinog Gospoda, da se istrebi kao prokletnik. ");
INSERT INTO srp1865_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Došljaku nemoj činiti krivo niti ga ucveliti, jer ste bili došljaci u zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Nemojte ucveliti udovice i sirote. ");
INSERT INTO srp1865_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ako li koju ucveliš u čem god, i poviče k meni, čuću viku njenu, ");
INSERT INTO srp1865_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","i zapaliće se gnev moj, i pobiću vas mačem, pa će vaše žene biti udovice i vaša deca sirote. ");
INSERT INTO srp1865_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Kad daš u zajam novaca narodu mom, siromahu koji je kod tebe, nemoj mu biti kao kamatnik, ne udarajte na nj kamate. ");
INSERT INTO srp1865_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ako uzmeš u zalogu haljinu bližnjemu svom, vrati mu je pre nego sunce zađe; ");
INSERT INTO srp1865_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","jer mu je to sve odelo čim zaklanja telo svoje; u čem će spavati? Pa kad poviče k meni, ja ću ga čuti, jer sam milostiv. ");
INSERT INTO srp1865_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Nemoj psovati sudije, i starešini naroda svog ne govori ružno. ");
INSERT INTO srp1865_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Od letine svoje i od žitkih stvari svojih nemoj se zatezati da prineseš prvine; prvenca između sinova svojih meni da daš. ");
INSERT INTO srp1865_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tako čini s volom svojim i s ovcom i s kozom; sedam dana neka bude s majkom svojom, a osmog dana da ga daš meni. ");
INSERT INTO srp1865_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Bićete mi sveti ljudi; mesa u polju rastrgnuta ne jedite, bacite ga psima. ");
INSERT INTO srp1865_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ne iznosi lažnih glasova; ne pristaj s bezbožnikom da svedočiš krivo. ");
INSERT INTO srp1865_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ne idi za množinom na zlo, i ne govori na sudu povodeći se za većim brojem da se izvrne pravda. ");
INSERT INTO srp1865_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Siromahu u parnici njegovoj ne gledaj što je siromah. ");
INSERT INTO srp1865_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ako naiđeš na vola neprijatelja svog ili na magarca njegovog, gde je zalutao, odvedi ga k njemu. ");
INSERT INTO srp1865_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ako vidiš gde je nenavidniku tvom pao magarac pod teretom svojim, nemoj da ga ostaviš, nego mu pomozi. ");
INSERT INTO srp1865_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Nemoj izvrnuti pravde siromahu svom u parnici njegovoj. ");
INSERT INTO srp1865_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Reči lažne kloni se, i bezazlenog i pravog nemoj ubiti, jer neću opravdati bezbožnika. ");
INSERT INTO srp1865_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ne uzimaj poklona, jer poklon zaslepljuje okate i izvrće reči pravima. ");
INSERT INTO srp1865_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Došljake ne cveli, jer vi znate kakva je duša došljaku, jer ste bili došljaci u zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Šest godina zasejavaj zemlju svoju i sabiraj rod njen; ");
INSERT INTO srp1865_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","a sedme godine ostavi je neka počine, da jedu siromasi naroda tvog, a šta iza njih ostane neka jedu zveri poljske; tako radi i s vinogradom svojim i s maslinikom svojim. ");
INSERT INTO srp1865_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Šest dana radi poslove svoje, a u sedmi dan počini, da se odmori vo tvoj i magarac tvoj, i da odahne sin robinje tvoje i došljak. ");
INSERT INTO srp1865_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Držite se svega što sam vam kazao. Ne pominjite imena bogova tuđih, i da se ne čuje iz usta vaših. ");
INSERT INTO srp1865_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tri puta preko godine svetkuj mi: ");
INSERT INTO srp1865_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Praznik presnih hlebova drži; sedam dana jedi hlebove presne, kao što sam ti zapovedio, na vreme, meseca Aviva, jer si tada izašao iz Misira; i niko da ne izađe preda me prazan; ");
INSERT INTO srp1865_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","i praznik žetve prvina od truda tvog što poseješ u polju svom; i praznik berbe na svršetku svake godine, kad sabereš trud svoj s njive. ");
INSERT INTO srp1865_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tri puta preko godine sve muškinje tvoje da izlazi pred Gospoda Boga. ");
INSERT INTO srp1865_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Krv od žrtve moje ne prinosi uz hlebove kisele, i pretilina praznika mog da ne prenoći do jutra. ");
INSERT INTO srp1865_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Prvine od prvog roda zemlje svoje donesi u kuću Gospoda Boga svog. Nemoj kuvati jagnjeta u mleku majke njegove. ");
INSERT INTO srp1865_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Evo, ja šaljem anđela svog pred tobom da te čuva na putu, i da te odvede na mesto koje sam ti pripravio. ");
INSERT INTO srp1865_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Čuvaj ga se, i slušaj ga, nemoj da ga rasrdiš, jer vam neće oprostiti greh, jer je moje ime u njemu. ");
INSERT INTO srp1865_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nego ako ga dobro uzaslušaš i ustvoriš sve što kažem, ja ću biti neprijatelj tvojim neprijateljima i protivnik tvojim protivnicima. ");
INSERT INTO srp1865_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Jer će anđeo moj ići pred tobom i odvešće te u zemlju amorejsku i hetejsku i ferezejsku i hananejsku i jevejsku i jevusejsku, i ja ću ih istrebiti. ");
INSERT INTO srp1865_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nemoj se klanjati bogovima njihovim niti im služiti, ni činiti šta oni čine, nego ih sasvim obori i likove njihove sasvim izlomi. ");
INSERT INTO srp1865_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","I služite Gospodu Bogu svom, i On će blagosloviti hleb tvoj i vodu tvoju; i ukloniću bolest između vas. ");
INSERT INTO srp1865_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Neće biti pometkinje ni nerotkinje u zemlji tvojoj; i broj dana tvojih napuniću. ");
INSERT INTO srp1865_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Pustiću strah svoj pred tobom, i uplašiću svaki narod na koji dođeš, i obratiću k tebi pleći svih neprijatelja tvojih. ");
INSERT INTO srp1865_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Poslaću i stršljene pred tobom, da teraju Jeveje, Hananeje i Heteje ispred tebe. ");
INSERT INTO srp1865_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Neću ih oterati ispred tebe za jednu godinu, da ne opusti zemlja i da se zverje poljsko ne namnoži na tebe. ");
INSERT INTO srp1865_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pomalo ću ih odgoniti ispred tebe dokle se ne namnožiš i zauzmeš zemlju. ");
INSERT INTO srp1865_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","I postaviću međe tvoje od mora crvenog do mora filistejskog i od pustinje do reke; jer ću vama u ruke dati one koji žive u onoj zemlji da ih oteraš ispred sebe. ");
INSERT INTO srp1865_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Nemoj hvatati vere s njima ni s bogovima njihovim. ");
INSERT INTO srp1865_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Neka ne sede u zemlji tvojoj, da te ne navrate da se ogrešiš o mene, jer bi služio bogovima njihovim, i to bi ti bila zamka. ");
INSERT INTO srp1865_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","I reče Mojsiju: Izađi gore ka Gospodu ti i Aron i Nadav i Avijud i sedamdeset starešina Izrailjevih, i poklonite se izdaleka. ");
INSERT INTO srp1865_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","I Mojsije sam neka pristupi ka Gospodu, a oni neka ne pristupe; i narod neka ne ide na gore s njim. ");
INSERT INTO srp1865_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","I dođe Mojsije, i kaza narodu sve reči Gospodnje i sve zakone. I odgovori narod jednim glasom i rekoše: Činićemo sve što je rekao Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","I napisa Mojsije sve reči Gospodnje, i ustavši rano načini oltar pod gorom i dvanaest stupova za dvanaest plemena Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","I posla mladiće između sinova Izrailjevih, koji prinesoše žrtve paljenice i prinesoše teoce na žrtve zahvalne Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","I uzevši Mojsije polovinu krvi, metnu u zdele, a polovinu krvi izli na oltar. ");
INSERT INTO srp1865_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","I uze knjigu zavetnu i pročita narodu. A oni rekoše: Šta je god rekao Gospod činićemo i slušaćemo. ");
INSERT INTO srp1865_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","A Mojsije uze krv, i pokropi njom narod, i reče: Evo krv zaveta, koji učini Gospod s vama za sve reči ove. ");
INSERT INTO srp1865_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Potom otide gore Mojsije i Aron, Nadav i Avijud, i sedamdeset starešina Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","I videše Boga Izrailjevog, i pod nogama Njegovim kao delo od kamena safira i kao nebo kad je vedro. ");
INSERT INTO srp1865_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","I ne pruži ruke svoje na izabrane između sinova Izrailjevih, nego videše Boga, pa jedoše i piše. ");
INSERT INTO srp1865_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","I reče Gospod Mojsiju: Popni se k meni na goru, i ostani ovde, i daću ti ploče od kamena, zakon i zapovesti, koje sam napisao da ih učiš. ");
INSERT INTO srp1865_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Tada usta Mojsije s Isusom, koji ga služaše, i izađe Mojsije na goru Božiju. ");
INSERT INTO srp1865_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","A starešinama reče: Sedite tu dok se vratimo k vama; a eto Aron i Or s vama; ko bi imao šta, neka ide k njima. ");
INSERT INTO srp1865_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","I otide Mojsije na goru, a oblak pokri goru. ");
INSERT INTO srp1865_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","I beše slava Gospodnja na gori sinajskoj, i oblak je pokrivaše šest dana; a u sedmi dan viknu Mojsija ispred oblaka. ");
INSERT INTO srp1865_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","I slava Gospodnja beše po viđenju kao oganj koji sažiže na vrh gore pred sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","I Mojsije uđe usred oblaka, i pope se na goru; i osta Mojsije na gori četrdeset dana i četrdeset noći. ");
INSERT INTO srp1865_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","I Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Reci sinovima Izrailjevim da mi skupe prilog: od svakog koji drage volje da, uzmite prilog meni. ");
INSERT INTO srp1865_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","A ovo je prilog što ćete uzimati od njih, zlato i srebro i bronzu, ");
INSERT INTO srp1865_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","i porfiru i skerlet i crvac i tanko platno i kostret, ");
INSERT INTO srp1865_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","i kože ovnujske crvene obojene, i kože jazavičije, i drvo sitim, ");
INSERT INTO srp1865_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ulje za videlo, mirise za ulje pomazanja i za mirisavi kad, ");
INSERT INTO srp1865_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","kamenje onihovo i kamenje za ukivanje na oplećak i naprsnik. ");
INSERT INTO srp1865_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","I neka mi načine svetinju, da među njima nastavam; ");
INSERT INTO srp1865_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","kao što ću ti pokazati sliku od šatora i sliku od svih stvari njegovih, tako da načinite. ");
INSERT INTO srp1865_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Neka načine kovčeg od drveta sitima, u dužinu od dva lakta i po, a u širinu od podrug lakta, i u visinu od podrug lakta. ");
INSERT INTO srp1865_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","I pokuj ga čistim zlatom, iznutra i spolja pokuj ga; i ozgo mu načini zlatan venac unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","I salij mu četiri biočuga od zlata, i metni mu ih na četiri ugla, da mu s jedne strane budu dva biočuga i s druge strane dva biočuga. ");
INSERT INTO srp1865_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","I načini poluge od drveta sitima, i okuj ih u zlato. ");
INSERT INTO srp1865_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","I provuci poluge kroz biočuge s obe strane kovčegu, da se o njima nosi kovčeg; ");
INSERT INTO srp1865_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","u biočuzima na kovčegu neka stoje poluge, da se ne vade iz njih. ");
INSERT INTO srp1865_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Pa u kovčeg metni svedočanstvo, koje ću ti dati. ");
INSERT INTO srp1865_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","I načini zaklopac od čistog zlata, u dužinu od dva lakta i po, a u širinu od podrug lakta. ");
INSERT INTO srp1865_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","I načini dva heruvima zlatna, jednostavne ih načini, na dva kraja zaklopcu. ");
INSERT INTO srp1865_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","I načini heruvima jednog na jednom kraju a drugog heruvima na drugom kraju; na zaklopcu načinite dva heruvima na oba kraja. ");
INSERT INTO srp1865_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","I neka heruvimi rašire krila u vis da zaklanjaju krilima zaklopac, i neka budu licem okrenuti jedan drugom, prema zaklopcu neka su okrenuta lica heruvimima. ");
INSERT INTO srp1865_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","I metnućeš zaklopac ozgo na kovčeg, a u kovčeg ćeš metnuti svedočanstvo koje ću ti dati. ");
INSERT INTO srp1865_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I tu ću se sastajati s tobom i govoriću ti ozgo sa zaklopca između dva heruvima, koji će biti na kovčegu od svedočanstva, sve što ću ti zapovedati za sinove Izrailjeve. ");
INSERT INTO srp1865_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Načini i sto od drveta sitima, u dužinu od dva lakta, a u širinu od jednog lakta, a u visinu od podrug lakta. ");
INSERT INTO srp1865_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","I pokuj ga čistim zlatom, i načini mu venac zlatan unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","I načini mu oplatu unaokolo s podlanice, i načini zlatan venac oko oplate. ");
INSERT INTO srp1865_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","I načini mu četiri biočuga od zlata, i metni mu te biočuge na četiri ugla koji će mu biti kod četiri noge. ");
INSERT INTO srp1865_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Pod oplatom neka budu biočuzi, da u njima stoje poluge da se nosi sto. ");
INSERT INTO srp1865_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","A poluge načini od drveta sitima, i okuj ih zlatom da se o njima nosi sto. ");
INSERT INTO srp1865_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","I načini mu zdele i čaše i vedra i kotliće, kojima će se prelivati, a načinićeš ih od čistog zlata. ");
INSERT INTO srp1865_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","I metaćeš na sto hlebove, da su postavljeni svagda preda mnom. ");
INSERT INTO srp1865_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","I načini svećnjak od čistog zlata, jednostavan neka bude svećnjak; stup i grane i čašice, jabuke, i cvetovi neka budu u njega. ");
INSERT INTO srp1865_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","A šest grana neka mu izlazi sa strana, tri grane s jedne strane svećnjaka a tri grane s druge strane svećnjaka. ");
INSERT INTO srp1865_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tri čašice kao badem neka budu na jednoj grani i jabuka i cvet, i tri čašice kao badem i jabuka i cvet na drugoj grani; tako neka bude na šest grana što izlaze iz svećnjaka. ");
INSERT INTO srp1865_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","I na samom svećnjaku neka budu četiri čašice kao badem i jabuke i cvetovi. ");
INSERT INTO srp1865_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Jedna jabuka pod dve grane što izlaze iz njega, i jedna jabuka pod druge dve grane što izlaze iz njega, i jedna jabuka pod druge dve grane što izlaze iz njega; tako će biti pod šest grana što će izlaziti iz svećnjaka; ");
INSERT INTO srp1865_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","jabuke i grane njihove iz njega neka izlaze; sve jednostavno od čistog zlata. ");
INSERT INTO srp1865_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","I načinićeš mu sedam žižaka, i palićeš ih da svetle sa svake strane; ");
INSERT INTO srp1865_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","i usekači i spremice za gar neka budu od čistog zlata. ");
INSERT INTO srp1865_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Od talanta čistog zlata neka bude načinjen sa svim tim spravama. ");
INSERT INTO srp1865_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","I gledaj, te načini sve ovo po slici koja ti je pokazana na gori. ");
INSERT INTO srp1865_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","A šator ćeš načiniti od deset zavesa od tankog platna uzvedenog i od porfire i od skerleta i od crvca; i po njima da budu vezeni heruvimi. ");
INSERT INTO srp1865_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Jedan zaves neka bude dvadeset i osam lakata dug i četiri lakta širok; svi zavesi da budu jedne mere. ");
INSERT INTO srp1865_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pet zavesa neka se sastavljaju jedan s drugim, i pet drugih zavesa neka se sastavljaju jedan s drugim. ");
INSERT INTO srp1865_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","I načini petlje od porfire po kraju jednog zavesa, gde će se krajevi sastavljati, i tako načini po kraju drugog zavesa, gde će se krajevi sastavljati. ");
INSERT INTO srp1865_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Pedeset petalja načini na jednom zavesu, a pedeset petalja načini na kraju drugog zavesa, gde će se sastavljati s drugim, a petlje da budu jedna prema drugoj. ");
INSERT INTO srp1865_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","I načini pedeset kuka od zlata, da zapneš zavese jedan za drugi kukama, i tako će biti šator jedan. ");
INSERT INTO srp1865_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","I načini zavese od kostreti za naslon nad šatorom; jedanaest takvih zavesa načini. ");
INSERT INTO srp1865_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Zaves jedan neka bude trideset lakata dug, a širok četiri lakta; tih jedanaest zavesa da su jedne mere. ");
INSERT INTO srp1865_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","I sastavi pet zavesa zajedno, a šest ostalih zajedno, na dvoje ćeš previti šesti zaves s prednje strane naslonu. ");
INSERT INTO srp1865_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","I načini pedeset petalja na stražnjem kraju prvog zavesa, gde će se sastavljati, a pedeset petalja na kraju drugog zavesa, gde će se sastavljati. ");
INSERT INTO srp1865_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","I načini kuka bronzanih pedeset, i zapni kuke na petlje, i sastavi naslon, da bude jedno. ");
INSERT INTO srp1865_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","A što je više u zavesa na naslonu, polovina zavesa što pretiče, neka visi na stražnjoj strani šatoru. ");
INSERT INTO srp1865_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","I lakat s jedne strane a lakat s druge strane što ima više u dužinu u zavesa na naslonu, neka visi šatoru sa strane i tamo i amo, da ga zaklanja. ");
INSERT INTO srp1865_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","I načini pokrivač naslonu od koža ovnujskih crvenih obojenih, i svrh njega pokrivač od koža jazavičijih. ");
INSERT INTO srp1865_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","I načini za šator daske od drveta sitima, koje će stajati pravo. ");
INSERT INTO srp1865_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Deset lakata neka bude svaka daska duga a podrug lakta široka. ");
INSERT INTO srp1865_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Dva čepa neka budu na dasci, jedan prema drugom najednako; tako načini na svakoj dasci za šator. ");
INSERT INTO srp1865_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Tako načini daske za šator, dvadeset dasaka na južnoj strani. ");
INSERT INTO srp1865_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","A pod dvadeset dasaka načini četrdeset stopica od srebra: dve stopice pod jednu dasku za dva čepa njena, i dve stopice pod drugu dasku za dva čepa njena. ");
INSERT INTO srp1865_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","A na drugoj strani šatora prema severu dvadeset dasaka. ");
INSERT INTO srp1865_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Sa četrdeset stopica srebrnih, dve stopice pod jednu dasku i dve stopice pod drugu dasku. ");
INSERT INTO srp1865_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","A na zapadnoj strani šatora načini šest dasaka, ");
INSERT INTO srp1865_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","i dve daske na dva ugla od šatora. ");
INSERT INTO srp1865_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","I one neka se sastavljaju ozdo i neka se sastavljaju ozgo biočugom; tako neka bude u obe koje će biti na oba ugla. ");
INSERT INTO srp1865_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Tako će biti osam dasaka sa stopicama srebrnim, sa šesnaest stopica, dve stopice pod jednu dasku, a dve stopice pod drugu dasku. ");
INSERT INTO srp1865_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","I načini prevornice od drveta sitima, pet za daske na jednoj strani šatora, ");
INSERT INTO srp1865_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","i pet prevornica za daske na drugoj strani šatora, i pet prevornica za daske na zapadnoj strani šatora do oba ugla. ");
INSERT INTO srp1865_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","A srednja prevornica da ide preko srede dasaka od jednog kraja do drugog. ");
INSERT INTO srp1865_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","A daske okuj zlatom, i biočuge im načini od zlata, da se kroz njih provuku prevornice, a i prevornice okuj zlatom. ");
INSERT INTO srp1865_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tako ćeš podignuti šator po slici koja ti je pokazana na gori. ");
INSERT INTO srp1865_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","I načini zaves od porfire i od skerleta i od crvca i od tankog platna uzvedenog, i po njemu neka budu vezeni heruvimi. ");
INSERT INTO srp1865_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","I obesi ga o četiri stupa od drveta sitima, okovana zlatom, sa kukama zlatnim, na četiri stopice srebrne. ");
INSERT INTO srp1865_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","I obesi zaves o kuke, i unesi za zaves kovčeg od svedočanstva, da vam zaves rastavlja svetinju od svetinje nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","I metni zaklopac na kovčeg od svedočanstva u svetinji nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","I namesti sto pred zaves a svećnjak prema stolu na južnoj strani šatora, da sto stoji na severnoj strani. ");
INSERT INTO srp1865_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","I na vrata naslonu načinićeš zaves od porfire i od skerleta i od crvca i od tankog platna uzvedenog, vezen; ");
INSERT INTO srp1865_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","i za taj zaves načinićeš pet stupova od drveta sitima, koje ćeš okovati zlatom, sa kukama zlatnim, i salićeš za njih pet stopica od bronze. ");
INSERT INTO srp1865_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","I načini oltar od drveta sitima, pet lakata u dužinu i pet lakata u širinu, četvorouglast da bude oltar, tri lakta visok. ");
INSERT INTO srp1865_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","I na četiri ugla načini mu rogove, iz njega da izlaze rogovi, i okovaćeš ga u bronzu. ");
INSERT INTO srp1865_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","I načinićeš mu lonce za pepeo i lopatice i kotliće i viljuške i mašice; sve mu posuđe načini od bronze. ");
INSERT INTO srp1865_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","I načini mu rešetku od bronze kao mrežu, i načini u rešetke četiri biočuga od bronze na četiri ugla njena. ");
INSERT INTO srp1865_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","I metni je ispod oltara unaokolo, da bude rešetka do sredine oltara. ");
INSERT INTO srp1865_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Načini i poluge oltaru, poluge od drveta sitima, i okuj ih u bronzu. ");
INSERT INTO srp1865_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","I poluge da se provuku kroz biočuge, da budu poluge s dve strane oltaru, kad se nosi. ");
INSERT INTO srp1865_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Načinićeš ga od dasaka da bude iznutra šupalj; kao što ti je pokazano na gori tako neka načine. ");
INSERT INTO srp1865_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","I načinićeš trem šatoru na južnoj strani; zavesi tremu da budu od tankog platna uzvedenog, sto lakata u dužinu na jednoj strani. ");
INSERT INTO srp1865_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","I dvadeset stupova i pod njih dvadeset stopica od bronze, a kuke na stupovima i pasovi njihovi od srebra. ");
INSERT INTO srp1865_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Tako i sa zapadne strane da budu zavesi sto lakata dugi, i dvadeset stupova i dvadeset stopica od bronze, na stupovima kuke i njihovi pasovi od srebra. ");
INSERT INTO srp1865_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","A širina će tremu imati sa zapadne strane zavese od pedeset lakata, deset stupova za njih i deset stopica pod njih. ");
INSERT INTO srp1865_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","A na prednjoj strani prema istoku biće trem širok pedeset lakata. ");
INSERT INTO srp1865_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Od petnaest lakata neka budu zavesi na jednoj strani, i za njih tri stupa i tri stopice pod njih; ");
INSERT INTO srp1865_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","na drugoj strani zavesi od petnaest lakata, i tri stupa za njih i tri stopice pod njih. ");
INSERT INTO srp1865_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","A nad vratima od trema zaves od dvadeset lakata od porfire i od skerleta i od crvca i od tankog platna uzvedenog, vezen, i četiri stupa za nj, i pod njih četiri stopice. ");
INSERT INTO srp1865_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Svi stupovi u tremu unaokolo da budu opasani srebrom, i kuke da su im srebrne a stopice od bronze. ");
INSERT INTO srp1865_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","U dužinu će trem imati sto lakata, u širinu pedeset svuda, a u visinu pet lakata, da bude od tankog platna uzvedenog, a stopice od bronze. ");
INSERT INTO srp1865_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Sve posuđe u šatoru za svaku službu, i sve kolje u njemu i sve kolje u tremu da bude od bronze. ");
INSERT INTO srp1865_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","I ti zapovedi sinovima Izrailjevim da ti donesu ulja maslinovog čistog ceđenog za videlo, da bi žišci goreli svagda. ");
INSERT INTO srp1865_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","U šatoru od sastanka pred zavesom, koji će zaklanjati svedočanstvo, neka ih Aron i sinovi njegovi spremaju da gore od večera do jutra pred Gospodom. To neka je uredba večna kolenima njihovim među sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","A ti uzmi k sebi Arona, brata svog sa sinovima njegovim između sinova Izrailjevih da mi budu sveštenici, Aron i Nadav i Avijud i Eleazar i Itamar, sinovi Aronovi. ");
INSERT INTO srp1865_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","I načini svete haljine Aronu, bratu svom, za čast i diku. ");
INSERT INTO srp1865_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","I kaži svim ljudima veštim, koje sam napunio duha mudrosti, neka načine haljine Aronu, da se posveti da mi bude sveštenik. ");
INSERT INTO srp1865_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","A ovo su haljine što će načiniti: naprsnik i oplećak i plašt, košulja vezena, kapa i pojas. Te haljine svete neka naprave Aronu, bratu tvom i sinovima njegovim, da mi budu sveštenici, ");
INSERT INTO srp1865_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","i neka uzmu zlata i porfire i skerleta i crvca i tankog platna. ");
INSERT INTO srp1865_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","I neka načine oplećak od zlata i od porfire i od skerleta i od crvca i od tankog platna uzvedenog, vezen. ");
INSERT INTO srp1865_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Dve poramenice neka budu na njemu, koje će se sastavljati na dva kraja, da se drži zajedno. ");
INSERT INTO srp1865_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","A pojas na njemu neka bude naprave iste kao i on, od zlata, od porfire, od skerleta, od crvca i od tankog platna uzvedenog. ");
INSERT INTO srp1865_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","I uzmi dva kamena oniha, i na njima izreži imena sinova Izrailjevih, ");
INSERT INTO srp1865_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","šest imena njihovih na jednom kamenu, a šest imena ostalih na drugom kamenu po redu kako se koji rodio. ");
INSERT INTO srp1865_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Veštinom kamenarskom, kojom se režu pečati, izrezaćeš na ta dva kamena imena sinova Izrailjevih, i optoči ih zlatom unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","I metni ta dva kamena na poramenice oplećku, da budu kameni za spomen sinovima Izrailjevim, i Aron da nosi imena njihova pred Gospodom na oba ramena svoja za spomen. ");
INSERT INTO srp1865_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","I načini kopče od zlata. ");
INSERT INTO srp1865_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","I dva lanca od čistog zlata načini jednaka pletena, i obesi lance pletene o kopče. ");
INSERT INTO srp1865_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","I naprsnik sudski načini naprave vezene onakve kao oplećak, od zlata, od porfire, od skerleta, od crvca i od tankog platna uzvedenog načini ga. ");
INSERT INTO srp1865_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Neka bude četvorouglast i dvostruk, u dužinu s pedi i u širinu s pedi. ");
INSERT INTO srp1865_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","I udari po njemu drago kamenje, u četiri reda neka bude kamenje. U prvom redu: sardoniks, topaz i smaragd; ");
INSERT INTO srp1865_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","a u drugom redu: karbunkul, safir i dijamant; ");
INSERT INTO srp1865_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","a u trećem redu; ligur i ahat i ametist; ");
INSERT INTO srp1865_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","a u četvrtom redu: hrisolit, onih i jaspis; neka budu ukovani u zlato u svom redu. ");
INSERT INTO srp1865_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","I tih kamena s imenima sinova Izrailjevih biće dvanaest po imenima njihovim, da budu rezani kao pečat, svaki sa svojim imenom, za dvanaest plemena. ");
INSERT INTO srp1865_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","I na naprsnik metni lance jednake, pletene, od čistog zlata. ");
INSERT INTO srp1865_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","I dve grivne zlatne načini na naprsnik, i metni dve grivne na dva kraja naprsniku. ");
INSERT INTO srp1865_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Pa provuci dva lanca zlatna kroz dve grivne na krajevima naprsniku. ");
INSERT INTO srp1865_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","A druga dva kraja od dva lanca zapni za dve kopče, i metni na poramenice od oplećka spred. ");
INSERT INTO srp1865_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","I načini druge dve grivne zlatne, i metni ih na druga dva kraja naprsniku iznutra na strani koja je od oplećka. ");
INSERT INTO srp1865_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","I načini još dve zlatne grivne, i metni ih na poramenice od oplećka ozdo prema sastavcima njegovim, više pojasa na oplećku. ");
INSERT INTO srp1865_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tako neka vežu naprsnik grivne njegove za grivne na oplećku vrpcom od porfire, da stoji nad pojasom od oplećka, i da se ne odvaja naprsnik od oplećka. ");
INSERT INTO srp1865_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","I neka nosi Aron imena sinova Izrailjevih na naprsniku sudskom na srcu svom kad ulazi u svetinju za spomen pred Gospodom vazda. ");
INSERT INTO srp1865_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","I metni na naprsnik sudski Urim i Tumim, da bude na srcu Aronu kad ulazi pred Gospoda, i Aron će nositi sud sinova Izrailjevih na srcu svom pred Gospodom vazda. ");
INSERT INTO srp1865_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","I načini plašt pod oplećak sav od porfire. ");
INSERT INTO srp1865_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","I ozgo neka bude prorez u sredi, i neka bude optočen prorez svuda unaokolo trakom tkan, kao prorez u oklopa, da se ne razdre. ");
INSERT INTO srp1865_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","A po skutu mu načini šipke od porfire i od skerleta i od crvca svuda unaokolo, i među njima zlatna zvonca svuda unaokolo: ");
INSERT INTO srp1865_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Zvonce zlatno pa šipak, zvonce zlatno pa šipak po skutu od plašta svuda unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","I to će biti na Aronu kad služi, da se čuje glas kad ulazi u svetinju pred Gospoda i kad izlazi, da ne pogine. ");
INSERT INTO srp1865_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","I načini ploču od čistog zlata, i na njoj izreži kao na pečatu: Svetinja Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","I veži je vrpcom od porfire za kapu, spred na kapi da stoji. ");
INSERT INTO srp1865_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","I biće na čelu Aronovom, da nosi Aron grehe svetih prinosa koje prinesu sinovi Izrailjevi u svim darovima svojih svetih prinosa; biće na čelu njegovom vazda, da bi bili mili Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","I načini košulju od tankog platna izmetanog, i načini kapu od tankog platna, a pojas načini vezen. ");
INSERT INTO srp1865_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","I sinovima Aronovim načini košulje, i načini im pojase, i kapice im načini za čast i diku. ");
INSERT INTO srp1865_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Pa to obuci Aronu bratu svom i sinovima njegovim, i pomaži ih i napuni im ruke i posveti ih da mi budu sveštenici. ");
INSERT INTO srp1865_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","I načini im gaće lanene, da se pokrije golo telo; od bedara do dna stegna da budu. ");
INSERT INTO srp1865_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","I to neka je na Aronu i na sinovima njegovim kad ulaze u šator od sastanka ili kad pristupaju k oltaru da služe u svetinji, da ne bi noseći grehe poginuli. Ovo će biti uredba večna njemu i semenu njegovom nakon njega. ");
INSERT INTO srp1865_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Učinićeš im ovo kad ih staneš osveštavati da mi vrše službu svešteničku: uzmi tele i dva ovna zdrava, ");
INSERT INTO srp1865_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","i hlebove presne i kolače presne zamešene s uljem, i pogače presne namazane uljem, od brašna pšeničnog umesi ih. ");
INSERT INTO srp1865_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","I metni ih u jednu kotaricu, i prinesi ih u kotarici s teletom i s dva ovna. ");
INSERT INTO srp1865_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","I dovedi Arona i sinove njegove pred vrata šatora od sastanka, i umij ih vodom. ");
INSERT INTO srp1865_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","I uzevši haljine obuci Aronu košulju i plašt ispod oplećka i oplećak i naprsnik, i opaši ga pojasom od oplećka. ");
INSERT INTO srp1865_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","I metni mu kapu na glavu i svetu ploču na kapu. ");
INSERT INTO srp1865_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","I uzmi ulje za pomazanje, i izlij mu na glavu, i pomazaćeš ga. ");
INSERT INTO srp1865_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","I sinove njegove dovedi i obuci im košulje; ");
INSERT INTO srp1865_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","i opaši ih pojasima, Arona i sinove njegove, i metni im kape na glave, da imaju sveštenstvo uredbom večnom. Tako ćeš posvetiti ruke Aronu i sinovima njegovim. ");
INSERT INTO srp1865_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","I dovedi tele pred šator od sastanka, a Aron i sinovi njegovi neka metnu ruke teletu na glavu. ");
INSERT INTO srp1865_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","I zakolji tele pred Gospodom na vratima šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","I uzevši krvi od teleta pomaži rogove oltaru prstom svojim, a ostalu krv svu prolij na podnožje oltaru. ");
INSERT INTO srp1865_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","I uzmi sve salo po crevima, i mrežicu na jetri, i oba bubrega i salo oko njih, i zapali na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","A meso od teleta i kožu i balegu spali ognjem izvan logora; to je žrtva za greh. ");
INSERT INTO srp1865_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Potom uzmi ovna jednog, i na glavu ovnu neka metnu ruke svoje Aron i sinovi njegovi. ");
INSERT INTO srp1865_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","I zakolji ovna i uzmi krvi od njega i pokropi oltar unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","A ovna izudi, i operi drob i noge, i metni ih na udove njegove i na glavu. ");
INSERT INTO srp1865_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","I svega ovna zapali na oltaru; to je žrtva paljenica Gospodu, miris ugodan, žrtva ognjena Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Pa uzmi i drugog ovna, i neka mu metne Aron i sinovi njegovi ruke svoje na glavu. ");
INSERT INTO srp1865_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","I zakolji tog ovna, i uzmi krvi od njega i pomaži njom kraj od desnog uha Aronu i kraj od desnog uha sinovima njegovim, i palac u desne ruke njihove i palac u desne noge njihove, a ostalom krvlju pokropi oltar unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","I uzmi krvi koja bude na oltaru i ulja za pomazanje, i pokropi Arona i haljine njegove, i sinove njegove i haljine njihove, i biće svet on i haljine njegove i sinovi njegovi i haljine njihove. ");
INSERT INTO srp1865_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Potom uzmi salo od ovna i rep i salo što je po crevima i mrežicu na jetri i oba bubrega i salo oko njih, i desno pleće; jer je ovan posvetni; ");
INSERT INTO srp1865_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","i jedan hleb i jedan kolač s uljem i jednu pogaču iz kotarice u kojoj budu presni hlebovi pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","I to sve metni u ruke Aronu i u ruke sinovima njegovim, i obrći tamo i amo, da bude žrtva obrtana pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Po tom uzmi im to iz ruku, i zapali na oltaru svrh žrtve paljenice, da bude miris ugodan pred Gospodom; to je žrtva ognjena Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","I uzmi grudi od ovna posvetnog, koji bude za Arona, i obrtaćeš ih tamo i amo, da bude žrtva obrtana pred Gospodom; i to će biti tvoj deo. ");
INSERT INTO srp1865_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Tako ćeš osvetiti grudi od žrtve obrtane i pleće od žrtve podizane, šta je obrtano i šta je podizano od ovna posvetnog za Arona i za sinove njegove. ");
INSERT INTO srp1865_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","I to će biti Aronu i sinovima njegovim uredbom večnom od sinova Izrailjevih, jer je žrtva podizana. Kad je žrtva podizana sinova Izrailjevih od njihovih žrtava zahvalnih, žrtva podizana biće Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","A svete haljine Aronove neka budu sinovima njegovim nakon njega da se pomazuju u njima i da im se u njima posvećuju ruke. ");
INSERT INTO srp1865_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sedam dana neka ih oblači koji na njegovo mesto bude sveštenik između sinova njegovih, koji će ulaziti u šator od sastanka da služi u svetinji. ");
INSERT INTO srp1865_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","A ovna posvetnog uzmi i skuvaj meso od njega na mestu svetom. ");
INSERT INTO srp1865_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","I Aron i sinovi njegovi neka na vratima šatora od sastanka jedu meso od tog ovna i hleb što je u kotarici. ");
INSERT INTO srp1865_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Neka ga jedu oni za koje je bilo očišćenje da bi im se posvetile ruke da bi bili posvećeni; a drugi da ne jede, jer je stvar sveta. ");
INSERT INTO srp1865_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ako li bi ostalo šta mesa posvetnog ili hleba do jutra, onda što ostane sažeži ognjem, a da se ne jede, jer je stvar sveta. ");
INSERT INTO srp1865_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","I tako učini Aronu i sinovima njegovim po svemu što ti zapovedih; sedam dana svetićeš im ruke. ");
INSERT INTO srp1865_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","I svaki ćeš dan prinositi na žrtvu tele za greh radi očišćenja; i očistićeš oltar čineći očišćenje na njemu, i pomazaćeš ga da se osveti. ");
INSERT INTO srp1865_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sedam dana činićeš očišćenje na oltaru i osvetićeš ga, te će oltar biti svetinja nad svetinjama; šta se god dotakne oltara, biće sveto. ");
INSERT INTO srp1865_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","I ovo ćeš prinositi na oltaru: dva jagnjeta od godine svaki dan bez prekida. ");
INSERT INTO srp1865_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Jedno jagnje prinosi jutrom a drugo prinosi večerom, ");
INSERT INTO srp1865_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","i još desetinu efe pšeničnog brašna smešana s uljem ceđenim, kog da bude četvrt ina, i naliv vina, četvrt ina na jedno jagnje. ");
INSERT INTO srp1865_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","A drugo jagnje prinesi uveče; kao sa žrtvom jutarnjom i s nalivom njenim tako i s ovom čini da bude miris ugodan, žrtva ognjena Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","To neka bude žrtva paljenica svagda od kolena do kolena vašeg na vratima šatora od sastanka pred Gospodom, gde ću se sastajati s vama da govorim s tobom. ");
INSERT INTO srp1865_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","I onde ću se sastajati sa sinovima Izrailjevim, da se osvećuje slavom mojom. ");
INSERT INTO srp1865_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","I osvetiću šator od sastanka i oltar; i Arona i sinove njegove osvetiću da su mi sveštenici. ");
INSERT INTO srp1865_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I nastavaću među sinovima Izrailjevim, i biću im Bog. ");
INSERT INTO srp1865_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","I poznaće da sam ja Gospod Bog njihov, koji sam ih izveo iz zemlje misirske da nastavam među njima, ja Gospod Bog njihov. ");
INSERT INTO srp1865_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Još načini oltar kadioni, od drveta sitima načini ga. ");
INSERT INTO srp1865_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Dužina neka mu bude lakat, i širina lakat, četvorouglast da bude, i dva lakta visok; iz njega neka mu izlaze rogovi. ");
INSERT INTO srp1865_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","I pokuj ga čistim zlatom, ozgo sa strana unaokolo, i rogove njegove; i načini mu venac zlatan unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","I načini mu po dva biočuga zlatna ispod venca na dva ugla njegova s obe strane, i kroz njih ćeš provući poluge da se može nositi. ");
INSERT INTO srp1865_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","A poluge načini od drveta sitima, i okuj ih u zlato. ");
INSERT INTO srp1865_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","I metni ga pred zaves koji visi pred kovčegom od svedočanstva prema zaklopcu koji je nad svedočanstvom, gde ću se s tobom sastajati. ");
INSERT INTO srp1865_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","I neka kadi na njemu Aron kadom mirisnim; svako jutro neka kadi kad spremi žiške. ");
INSERT INTO srp1865_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","I kad zapali Aron žiške uveče, neka kadi; neka bude kad svagdašnji pred Gospodom od kolena do kolena vašeg. ");
INSERT INTO srp1865_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ne prinosite na njemu kad tuđi niti žrtvu paljenicu niti prinos; ni naliv ne lijte na njemu. ");
INSERT INTO srp1865_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Samo očišćenje neka čini nad rogovima njegovim Aron jednom u godini; krvlju od žrtve za greh u dan očišćenja jednom u godini činiće očišćenja na njemu od kolena do kolena vašeg; jer je to svetinja nad svetinjama Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Kad staneš brojati sinove Izrailjeve, između onih koji idu u broj svaki neka dade otkup za život svoj Gospodu, kad ih staneš brojati, da ne bi došlo na njih kakvo zlo kad ih staneš brojati. ");
INSERT INTO srp1865_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","A neka da svaki koji ide u broj pola sikla, po siklu svetom (a taj je sikal dvadeset novčića); pola sikla biće prilog Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ko god ide u boj, od dvadeset godina i više, neka da prilog Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Bogati da ne da više a siromah da ne da manje od po sikla, kad daju prilog Gospodu na očišćenje duša vaših. ");
INSERT INTO srp1865_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","I uzevši novce za očišćenje od sinova Izrailjevih ostavi ih za potrebu u šatoru od sastanka, i biće sinovima Izrailjevim spomen pred Gospodom za očišćenje duša vaših. ");
INSERT INTO srp1865_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Načini i umivaonicu od bronze i podnožje joj od bronze za umivanje; i metni je između šatora od sastanka i oltara, i nalij u nju vode. ");
INSERT INTO srp1865_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Da iz nje pere Aron i sinovi njegovi ruke svoje i noge svoje. ");
INSERT INTO srp1865_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kad idu u šator od sastanka, neka se umivaju vodom, da ne izginu, ili kad pristupaju k oltaru da služe i da pale žrtvu ognjenu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Tada neka peru ruke svoje i noge svoje da ne izginu. To neka im bude uredba večna Aronu i semenu njegovom od kolena do kolena. ");
INSERT INTO srp1865_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Uzmi mirisa najboljih: smirne najčistije pet stotina sikala i cimeta mirisavog pola toliko, dvesta pedeset, i iđirota takođe dvesta pedeset, ");
INSERT INTO srp1865_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","i kasije pet stotina merom svetom, i ulja maslinovog jedan in. ");
INSERT INTO srp1865_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","I od toga načini ulje za sveto pomazanje, ulje najbolje veštinom apotekarskom; to da bude ulje svetog pomazanja. ");
INSERT INTO srp1865_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","I njim pomaži šator od sastanka i kovčeg od svedočanstva, ");
INSERT INTO srp1865_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","i sto i sve sprave njegove, i svećnjak i sprave njegove, i oltar kadioni, ");
INSERT INTO srp1865_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","i oltar na kome se prinosi žrtva paljenica, i sve sprave njegove, i umivaonicu i podnožje njeno. ");
INSERT INTO srp1865_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Tako ćeš ih osvetiti, te će biti svetinja nad svetinjom, i šta ih se god dotakne biće sveto. ");
INSERT INTO srp1865_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Pomaži i Arona i sinove njegove, i osvetićeš ih da mi budu sveštenici. ");
INSERT INTO srp1865_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","A sinovima Izrailjevim kaži i reci: Ovo neka mi bude ulje svetog pomazanja od kolena do kolena vašeg. ");
INSERT INTO srp1865_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Telo čovečje neka se ne maže njim, niti pravite takvo ulje kakvo je ono; sveto je, neka vam bude sveto. ");
INSERT INTO srp1865_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ako li bi ko načinio tako ulje ili namazao njim drugog, istrebiće se iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","I reče Gospod Mojsiju: Uzmi mirisa, stakte, oniha i halvana mirisavog, i tamjana čistog, koliko jednog toliko drugog. ");
INSERT INTO srp1865_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","I od toga načini kad, sastavljen veštinom apotekarskom, čist i svet. ");
INSERT INTO srp1865_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","I istucavši ga nasitno, metaćeš ga pred svedočanstvom u šatoru od sastanka, gde ću se sastajati s tobom; to neka vam bude svetinja nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","A takav kad kakav načiniš nemojte sebi praviti; to neka ti je svetinja za Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ako li bi ko načinio takav da ga miriše, istrebiće se iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Gle, pozvah po imenu Veseleila sina Urije sina Orovog od plemena Judinog. ");
INSERT INTO srp1865_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","I napunih ga Duha Svetog, mudrosti i razuma i znanja i svake veštine, ");
INSERT INTO srp1865_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","da vešto izmišlja kako se šta može načiniti od zlata i od srebra i od bronze, ");
INSERT INTO srp1865_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","da ume rezati kamenje i ukivati, da ume tesati drvo, i svaki posao raditi. ");
INSERT INTO srp1865_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","I evo udružih s njim Elijava, sina Ahisamahovog od plemena Danovog, i svakom veštom čoveku u srce dadoh veštinu da izrade sve što sam ti zapovedio. ");
INSERT INTO srp1865_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Šator od sastanka, i kovčeg za svedočanstvo i zaklopac na nj, i sve sprave u šatoru, ");
INSERT INTO srp1865_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","i sto i sprave njegove, i svećnjak čisti sa svim spravama njegovim, i oltar kadioni, ");
INSERT INTO srp1865_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","i oltar za žrtvu paljenicu sa svim spravama njegovim, i umivaonicu i podnožje njeno, ");
INSERT INTO srp1865_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","i haljine službene i svete haljine Aronu svešteniku i haljine sinovima njegovim, da vrše službu svešteničku, ");
INSERT INTO srp1865_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","i ulje pomazanja, i kad mirisni za svetinju. Sve neka načine onako kako sam ti zapovedio. ");
INSERT INTO srp1865_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","A ti kaži sinovima Izrailjevim i reci: Ali subote moje čuvajte, jer je znak između mene i vas od kolena do kolena, da znate da sam ja Gospod koji vas posvećujem. ");
INSERT INTO srp1865_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Čuvajte dakle subotu, jer vam je sveta; ko bi je oskvrnio, da se pogubi; jer ko bi god radio kakav posao u nju, istrebiće se ona duša iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Šest dana neka se radi; a sedmi je dan subota, odmor, svet Gospodu; ko bi god radio posao u dan subotni, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Zato će čuvati sinovi Izrailjevi subotu praznujući subotu od kolena do kolena zavetom večnim. ");
INSERT INTO srp1865_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","To je znak između mene i sinova Izrailjevih doveka; jer je za šest dana stvorio Gospod nebo i zemlju, a u sedmi dan počinu i odmori se. ");
INSERT INTO srp1865_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","I izgovorivši ovo Mojsiju na gori sinajskoj, dade mu dve ploče svedočanstva, ploče kamene pisane prstom Božijim. ");
INSERT INTO srp1865_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","A narod videvši gde Mojsije za dugo ne silazi s gore, skupi se narod pred Arona, i rekoše mu: Hajde, načini nam bogove, koji će ići pred nama, jer tom Mojsiju koji nas izvede iz zemlje misirske ne znamo šta bi. ");
INSERT INTO srp1865_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","A Aron im reče: Poskidajte zlatne oboce što su u ušima žena vaših, sinova vaših i kćeri vaših, i donesite mi. ");
INSERT INTO srp1865_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","I poskida sav narod zlatne oboce što im behu u ušima, i donesoše Aronu. ");
INSERT INTO srp1865_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","A on uzevši iz ruku njihovih, sali u kalup, i načini tele saliveno. I rekoše: Ovo su bogovi tvoji, Izrailju, koji te izvedoše iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","A kad to vide Aron, načini oltar pred njim; i povika Aron, i reče: Sutra je praznik Gospodnji. ");
INSERT INTO srp1865_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","I sutradan ustavši rano prinesoše žrtve paljenice i žrtve zahvalne; i poseda narod, te jedoše i piše, a posle ustaše da igraju. ");
INSERT INTO srp1865_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","A Gospod reče Mojsiju: Idi, siđi, jer se pokvari tvoj narod, koji si izveo iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Brzo zađoše s puta, koji sam im zapovedio; načiniše sebi tele liveno, i pokloniše mu se, i prinesoše mu žrtvu, i rekoše: Ovo su bogovi tvoji, Izrailju, koji te izvedoše iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Još reče Gospod Mojsiju: Pogledah narod ovaj, i eto je narod tvrdog vrata. ");
INSERT INTO srp1865_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","I sada pusti me, da se raspali gnev moj na njih i da ih istrebim; ali od tebe ću učiniti narod velik. ");
INSERT INTO srp1865_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","A Mojsije se zamoli Gospodu Bogu svom, i reče: Zašto se, Gospode, raspaljuje gnev Tvoj na narod Tvoj, koji si izveo iz zemlje misirske silom velikom i rukom krepkom? ");
INSERT INTO srp1865_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Zašto da govore Misirci i kažu: Na zlo ih izvede, da ih pobije po planinama i da ih istrebi sa zemlje? Povrati se od gneva svog, i požali narod svoj oda zla. ");
INSERT INTO srp1865_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Opomeni se Avrama, Isaka i Izrailja, sluga svojih, kojima si se sobom zakleo i obrekao im: Umnožiću seme vaše kao zvezde na nebu, i zemlju ovu, za koju govorih, svu ću dati semenu vašem da je njihova doveka. ");
INSERT INTO srp1865_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","I ražali se Gospodu učiniti zlo narodu svom, koje reče. ");
INSERT INTO srp1865_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Tada se vrati Mojsije, i siđe s gore sa dve ploče svedočanstva u rukama svojim; i ploče behu pisane s obe strane, otud i odovud pisane. ");
INSERT INTO srp1865_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","I behu ploče delo Božje, i pismo beše pismo Božje, urezano na pločama. ");
INSERT INTO srp1865_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","A Isus čuvši viku u narodu, kad vikahu, reče Mojsiju; vika ubojna u logoru. ");
INSERT INTO srp1865_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","A on reče: Nije to vika kako viču koji su jači, niti je vika kako viču koji su slabiji, nego čujem viku onih koji pevaju. ");
INSERT INTO srp1865_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","I kad dođe blizu logora, ugleda tele i igre, te se razgnevi Mojsije, i baci iz ruku svojih ploče, i razbi ih pod gorom. ");
INSERT INTO srp1865_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Pa uze tele koje behu načinili i spali ga ognjem, i satre ga u prah, i prosu ga po vodi, i zapoji sinove Izrailjeve. ");
INSERT INTO srp1865_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","I reče Mojsije Aronu: Šta ti je učinio ovaj narod, te ga uvali u toliki greh? ");
INSERT INTO srp1865_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","A Aron mu reče: Nemoj se gneviti, gospodaru; ti znaš ovaj narod da je brz na zlo. ");
INSERT INTO srp1865_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Jer rekoše mi: Načini nam bogove, koji će ići pred nama, jer tom Mojsiju koji nas izvede iz zemlje misirske ne znamo šta bi. ");
INSERT INTO srp1865_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","A ja im rekoh: Ko ima zlata, neka ga skida sa sebe. I dadoše mi, a ja ga bacih u vatru, i izađe to tele. ");
INSERT INTO srp1865_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","A Mojsije videći narod go, jer ga ogoli Aron na sramotu pred protivnicima njegovim, ");
INSERT INTO srp1865_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","stade Mojsije na vrata od logora, i reče: K meni ko je Gospodnji. I skupiše se pred njega svi sinovi Levijevi. ");
INSERT INTO srp1865_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","I reče im: Ovako kaže Gospod Bog Izrailjev: Pripašite svaki svoj mač uz bedro svoje, pa prođite tamo i amo po logoru od vrata do vrata, i pobijte svaki brata svog i prijatelja svog i bližnjeg svog. ");
INSERT INTO srp1865_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","I učiniše sinovi Levijevi po zapovesti Mojsijevoj, i pogibe naroda u onaj dan do tri hiljade ljudi. ");
INSERT INTO srp1865_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Jer Mojsije reče: Posvetite danas ruke svoje Gospodu, svak na sinu svom i na bratu svom, da bi vam dao danas blagoslov. ");
INSERT INTO srp1865_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","A sutradan reče Mojsije narodu: Vi ljuto sagrešiste; zato sada idem gore ka Gospodu, eda bih ga umolio da vam oprosti greh. ");
INSERT INTO srp1865_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","I vrati se Mojsije ka Gospodu, i reče: Molim Ti se; narod ovaj ljuto sagreši načinivši sebi bogove od zlata. ");
INSERT INTO srp1865_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ali oprosti im greh: Ako li nećeš, izbriši me iz knjige svoje, koju si napisao. ");
INSERT INTO srp1865_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","A Gospod reče Mojsiju: Ko mi je zgrešio, onog ću izbrisati iz knjige svoje. ");
INSERT INTO srp1865_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","A sada idi, vodi taj narod kuda sam ti kazao. Evo, moj će anđeo ići pred tobom, a kad ih pohodim, pohodiću na njima greh njihov. ");
INSERT INTO srp1865_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","I Gospod bi narod zato što načiniše tele, koje sali Aron. ");
INSERT INTO srp1865_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","I reče Gospod Mojsiju: Idi, digni se odatle ti i narod, koji si izveo iz zemlje misirske, put zemlje za koju se zakleh Avramu, Isaku i Jakovu govoreći: Semenu tvom daću je. ");
INSERT INTO srp1865_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","I poslaću pred tobom anđela, i izagnaću Hananeje, Amoreje i Heteje i Ferezeje i Jeveje i Jevuseje. ");
INSERT INTO srp1865_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","I odvešće vas u zemlju gde teče mleko i med; jer neću sam ići s tobom zato što si narod tvrdovrat, pa bih te mogao satrti putem. ");
INSERT INTO srp1865_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","A narod čuvši ovu zlu reč ožalosti se, i niko ne metnu na se svog nakita. ");
INSERT INTO srp1865_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Jer Gospod reče Mojsiju: Kaži sinovima Izrailjevim: Vi ste narod tvrdovrat; doći ću časom usred tebe, i istrebiću te; a sada skini nakit svoj sa sebe, i znaću šta ću činiti s tobom. ");
INSERT INTO srp1865_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","I poskidaše sa sebe sinovi Izrailjevi nakite svoje kod gore Horiva. ");
INSERT INTO srp1865_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","A Mojsije uze šator i razape ga sebi iza logora daleko, i nazva ga šator od sastanka, i ko god tražaše Gospoda, dolažaše k šatoru od sastanka iza logora. ");
INSERT INTO srp1865_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","I kad Mojsije iđaše u šator, sav narod ustajaše, i svak stajaše na vratima svog šatora, i gledahu za Mojsijem dok ne uđe u šator. ");
INSERT INTO srp1865_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","A kad Mojsije ulažaše u šator, spuštaše se stup od oblaka i ustavljaše se na vratima od šatora, i Gospod govoraše s Mojsijem. ");
INSERT INTO srp1865_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","I sav narod videći stup od oblaka gde stoji na vratima od šatora, ustajaše sav narod, i svak se klanjaše na vratima od svog šatora. ");
INSERT INTO srp1865_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","I Gospod govoraše s Mojsijem licem k licu kao što govori čovek s prijateljem svojim. Potom se vraćaše Mojsije u logor, a sluga njegov Isus sin Navin, momak, ne izlažaše iz šatora. ");
INSERT INTO srp1865_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","I reče Mojsije Gospodu: Gledaj, Ti mi kažeš: Vodi taj narod. A nisi mi kazao koga ćeš poslati sa mnom, a rekao si: Znam te po imenu i našao si milost preda mnom. ");
INSERT INTO srp1865_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ako sam dakle našao milost pred Tobom, pokaži mi put svoj, da Te poznam i nađem milost pred Tobom; i vidi da je ovaj narod Tvoj narod. ");
INSERT INTO srp1865_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","I reče Gospod: Moje će lice ići napred, i daću ti odmor. ");
INSERT INTO srp1865_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","A Mojsije mu reče: Ako neće ići napred lice Tvoje, nemoj nas kretati odavde. ");
INSERT INTO srp1865_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Jer po čemu će se poznati da smo našli milost pred Tobom, ja i narod Tvoj? Zar ne po tome što Ti ideš s nama? Tako ćemo se razlikovati ja i narod Tvoj od svakog naroda na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","A Gospod reče Mojsiju: Učiniću i to što si kazao, jer si našao milost preda mnom i znam te po imenu. ");
INSERT INTO srp1865_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Opet reče Mojsije: Molim Te, pokaži mi slavu svoju. ");
INSERT INTO srp1865_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","A Gospod mu reče: Učiniću da prođe sve dobro moje ispred tebe, i povikaću po imenu: Gospod pred tobom. Smilovaću se kome se smilujem, i požaliću koga požalim. ");
INSERT INTO srp1865_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","I reče: Ali nećeš moći videti lice moje, jer ne može čovek mene videti i ostati živ. ");
INSERT INTO srp1865_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","I reče Gospod: Evo mesto kod mene, pa stani na stenu. ");
INSERT INTO srp1865_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","I kad stane prolaziti slava moja, metnuću te u raselinu kamenu, i zakloniću te rukom svojom dok ne prođem. ");
INSERT INTO srp1865_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Potom ću dignuti ruku svoju, i videćeš me s leđa, a lice se moje ne može videti. ");
INSERT INTO srp1865_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","I reče Gospod Mojsiju: Isteši sebi dve ploče od kamena kao što su bile prve, da napišem na tim pločama reči koje su bile na prvim pločama, koje si razbio. ");
INSERT INTO srp1865_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","I budi gotov za sutra da rano izađeš na goru sinajsku, i staneš preda me na vrh gore. ");
INSERT INTO srp1865_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ali neka niko ne ide s tobom, i niko neka se ne pokaže na svoj gori, ni ovce ni goveda da ne pasu blizu gore. ");
INSERT INTO srp1865_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","I istesa Mojsije dve ploče od kamena kao što su bile prve, i ustavši rano izađe na goru sinajsku, kao što mu zapovedi Gospod, i uze u ruku svoju dve ploče kamene. ");
INSERT INTO srp1865_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","A Gospod siđe u oblaku, i stade onde s njim, i povika po imenu: Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Jer prolazeći Gospod ispred njega vikaše: Gospod, Gospod, Bog milostiv, žalostiv, spor na gnev i obilan milosrđem i istinom. ");
INSERT INTO srp1865_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Koji čuva milost hiljadama, prašta bezakonja i nepravde i grehe, koji ne pravda krivoga, i pohodi grehe otačke na sinovima i na unucima do trećeg i četvrtog kolena. ");
INSERT INTO srp1865_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","A Mojsije brže savi glavu do zemlje i pokloni se, ");
INSERT INTO srp1865_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","i reče: Ako sam našao milost pred Tobom, Gospode, neka ide Gospod posred nas, jer je narod tvrdovrat: i oprosti nam bezakonje naše i greh naš, i uzmi nas za nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","A On reče: Evo postavljam zavet; pred celim narodom tvojim učiniću čudesa, koja nisu učinjena nigde na zemlji ni u kome narodu, i videćete delo Gospodnje sav narod, među kojim si, jer će biti strašno šta ću ja učiniti s tobom. ");
INSERT INTO srp1865_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Drži šta ti danas zapovedam; evo, ja ću izagnati ispred tebe Amoreje i Hananeje i Heteje i Ferezeje i Jeveje i Jevuseje. ");
INSERT INTO srp1865_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Čuvaj se da ne hvataš vere s onima koji žive u zemlji u koju ćeš doći, da ti ne budu zamka usred tebe. ");
INSERT INTO srp1865_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nego oltare njihove oborite, i likove njihove izlomite, i gajeve njihove isecite. ");
INSERT INTO srp1865_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Jer ne valja da se klanjaš drugom Bogu: jer se Gospod zove revnitelj, Bog je revnitelj. ");
INSERT INTO srp1865_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Nemoj hvatati vere s onima koji žive u onoj zemlji, da ne bi čineći preljubu za bogovima svojim i prinoseći žrtvu bogovima svojim pozvali te, i ti jeo žrtve njihove. ");
INSERT INTO srp1865_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","I da ne bi kćerima njihovim ženio sinove svoje, i da ne bi kćeri njihove čineći preljubu za bogovima svojim učinile da sinovi tvoji čine preljubu za bogovima njihovim. ");
INSERT INTO srp1865_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Livene bogove ne gradi sebi. ");
INSERT INTO srp1865_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Praznik presnih hlebova drži; sedam dana jedi presne hlebove, kao što sam ti zapovedio, na vreme, meseca Aviva, jer si tog meseca izašao iz Misira. ");
INSERT INTO srp1865_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Sve što otvara matericu moje je, i svako muško u stoci tvojoj što otvara matericu, goveče ili sitna stoka. ");
INSERT INTO srp1865_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ali magare koje otvori matericu otkupi jagnjetom ili jaretom; ako li ga ne bi otkupio, slomi mu vrat; i svakog prvenca između sinova svojih otkupi; i da se niko ne pokaže prazan preda mnom. ");
INSERT INTO srp1865_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Šest dana radi, a u sedmi dan počini, i od oranja i od žetve počini. ");
INSERT INTO srp1865_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Praznuj praznik sedmica, prvina žetve pšenične, i praznik berbe na svršetku godine. ");
INSERT INTO srp1865_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tri puta u godini da se svako muško između vas pokaže pred Gospodom Bogom Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Jer ću izagnati narode ispred tebe, i međe tvoje raširiću, i niko neće poželeti zemlje tvoje, kad staneš dolaziti da se pokažeš pred Gospodom Bogom svojim tri puta u godini. ");
INSERT INTO srp1865_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Nemoj prinositi krv od žrtve moje uz hlebove kisele, i da ne prenoći do jutra žrtva praznika pashe. ");
INSERT INTO srp1865_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Prvine od prvog roda zemlje svoje donesi u kuću Gospoda Boga svog; nemoj kuvati jare u mleku majke njegove. ");
INSERT INTO srp1865_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","I reče Gospod Mojsiju: Napiši sebi te reči; jer po tim rečima učinih zavet s tobom i s Izrailjem. ");
INSERT INTO srp1865_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","I Mojsije osta onde kod Gospoda četrdeset dana i četrdeset noći, hleba ne jedući ni vode pijući; i napisa Gospod na ploče reči zaveta, deset reči. ");
INSERT INTO srp1865_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","I kad Mojsije silažaše s gore sinajske, i držaše u ruci dve ploče svedočanstva silazeći s gore, ne znaše da mu koža na licu posta svetla dokle govoraše s njim. ");
INSERT INTO srp1865_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","I vide Aron i svi sinovi Izrailjevi Mojsija, a to mu se svetli koža na licu, i ne smeše pristupiti k njemu. ");
INSERT INTO srp1865_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ali ih zovnu Mojsije, i vratiše se k njemu Aron i svi glavari u zboru, i govori s njima Mojsije. ");
INSERT INTO srp1865_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Potom pristupiše svi sinovi Izrailjevi, i zapovedi im sve što mu kaza Gospod na gori sinajskoj. ");
INSERT INTO srp1865_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","A kad im Mojsije izgovori, zastre lice svoje pokrivalom. ");
INSERT INTO srp1865_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ali kad Mojsije dolažaše pred Gospoda da s Njim govori, skidaše pokrivalo dokle ne bi izašao; a izašavši kazivaše sinovima Izrailjevim šta mu se zapovedaše. ");
INSERT INTO srp1865_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Tada viđahu sinovi Izrailjevi lice Mojsijevo, gde se svetli koža na licu njegovom, te Mojsije opet zastiraše pokrivalom lice svoje dokle ne bi opet ušao da govori s Njim. ");
INSERT INTO srp1865_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Potom sabra Mojsije sav zbor sinova Izrailjevih, i reče im: Ovo je zapovedio Gospod da činite: ");
INSERT INTO srp1865_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Šest dana da se radi, a sedmi da vam je svet, subota počivanja Gospodnjeg; ko bi radio u taj dan, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Vatre ne ložite po stanovima svojim u dan subotni. ");
INSERT INTO srp1865_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Još reče Mojsije svemu zboru sinova Izrailjevih govoreći: Ovo je zapovedio Gospod i rekao: ");
INSERT INTO srp1865_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Skupite između sebe prilog Gospodu; ko god hoće drage volje, neka donese prilog Gospodu: zlato i srebro i bronzu, ");
INSERT INTO srp1865_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","i porfiru i skerlet i crvac i tanko platno i kostret, ");
INSERT INTO srp1865_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","i kože ovnujske crvene obojene i kože jazavičije i drvo sitim, ");
INSERT INTO srp1865_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","i ulje za videlo, i mirise za ulje pomazanja i za kad mirisni, ");
INSERT INTO srp1865_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","i kamenje onihovo, i kamenje za ukivanje po oplećku i po naprsniku. ");
INSERT INTO srp1865_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","I koji su god vešti među vama neka dođu da rade šta je zapovedio Gospod: ");
INSERT INTO srp1865_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Šator, i naslon njegov, i pokrivač njegov, i kuke njegove, i daske njegove, prevornice njegove, stupove njegove i stopice njegove, ");
INSERT INTO srp1865_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","kovčeg, i poluge njegove, i zaklopac, i zaves, ");
INSERT INTO srp1865_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","sto, i poluge njegove i sve sprave njegove, i hleb za postavljanje, ");
INSERT INTO srp1865_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","i svećnjak za videlo sa spravama njegovim, i žiške njegove, i ulje za videlo, ");
INSERT INTO srp1865_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","i oltar kadioni, i poluge njegove, i ulje pomazanja, i kad mirisni, i zaves na vrata od šatora, ");
INSERT INTO srp1865_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","oltar za žrtvu paljenicu, i rešetku njegovu od bronze, poluge njegove i sve sprave njegove, umivaonicu i podnožje njeno, ");
INSERT INTO srp1865_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","zavese za trem, stupove njegove i stopice njegove, i zaves na vrata od trema, ");
INSERT INTO srp1865_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","kolje za šator, i kolje za trem s užima njihovim. ");
INSERT INTO srp1865_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Haljine službene za službu u svetinji, i haljine svete Aronu svešteniku, i haljine sinovima njegovim za službu svešteničku. ");
INSERT INTO srp1865_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Tada otide sav zbor sinova Izrailjevih od Mojsija; ");
INSERT INTO srp1865_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","i vratiše se, svaki kog podiže srce njegovo i koga god duh pokrete dragovoljno, i donesoše prilog Gospodu za građenje šatora od sastanka i za svu službu u njemu i za haljine svete. ");
INSERT INTO srp1865_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Dolaziše ljudi i žene, ko god beše dragovoljnog srca, i donosiše spone i oboce i prstenje i narukvice i svakojake nakite zlatne; i svaki donese prilog zlata Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ko god imaše porfire, skerleta, crvca, tankog platna, kostreti, koža ovnujskih crvenih obojenih i koža jazavičijih, svaki donošaše. ");
INSERT INTO srp1865_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","I ko god prilagaše srebro ili bronzu, donošaše u prilog Gospodu; i u koga god beše drveta sitima, za svaku upotrebu u službi donošaše. ");
INSERT INTO srp1865_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","I sve žene vešte predoše svojim rukama, i donosiše šta napredoše za porfiru, skerlet, crvac i tanko platno. ");
INSERT INTO srp1865_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","I sve žene koje podiže srce njihovo i behu vešte, predoše kostret. ");
INSERT INTO srp1865_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","A glavari donosiše kamenje onihovo i kamenje za ukivanje po oplećku i po naprsniku, ");
INSERT INTO srp1865_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","i mirise i ulje za videlo i ulje za pomazanje i za kad mirisni. ");
INSERT INTO srp1865_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Svi ljudi i žene, koje podiže dragovoljno srce da donose šta treba za sve delo koje Gospod zapovedi preko Mojsija da se načini, donesoše sinovi Izrailjevi dragovoljni prilog Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Tada reče Mojsije sinovima Izrailjevim: Vidite, Gospod pozva po imenu Veseleila sina Urije sina Orovog od plemena Judinog, ");
INSERT INTO srp1865_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","i napuni ga duha Božijeg, mudrosti, razuma i znanja i veštine za svaki posao, ");
INSERT INTO srp1865_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","da vešto izmišlja kako se šta radi od zlata i srebra i od bronze, ");
INSERT INTO srp1865_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","da ume rezati kamenje i ukivati, da ume tesati drvo i raditi svaki posao vrlo vešto. ");
INSERT INTO srp1865_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","I dade mu u srce, njemu i Elijavu sinu Ahisamahovom od plemena Danovog, da mogu učiti druge. ");
INSERT INTO srp1865_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Napuni ih veštine da rade svaki posao, da kuju, tešu, vezu, i tkaju porfiru, skerlet, crvac i tanko platno, i da rade svakojake poslove vešto izmišljajući. ");
INSERT INTO srp1865_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","I stade raditi Veseleilo i Elijav i svi ljudi vešti, kojima beše Gospod dao mudrost i razum da umeju raditi svaki posao za službu u svetinji, i sve što je zapovedio Gospod. ");
INSERT INTO srp1865_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","I pozva Mojsije Veseleila i Elijava i sve ljude vešte, kojima Gospod dade mudrost u srce, koje god podiže srce njihovo da dođu da rade taj posao. ");
INSERT INTO srp1865_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","I uzeše od Mojsija sve priloge, koje donesoše sinovi Izrailjevi da se uradi delo za službu u svetinji. Ali još donošahu k njemu dragovoljne priloge svako jutro. ");
INSERT INTO srp1865_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Tada dođoše svi vešti ljudi, koji rađahu delo za svetinju, svaki od svog posla, koji rađahu, ");
INSERT INTO srp1865_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","i rekoše Mojsiju govoreći: Više donosi narod nego što treba da se uradi delo, koje je Gospod zapovedio da se uradi. ");
INSERT INTO srp1865_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","I zapovedi Mojsije da se oglasi po logoru govoreći: Ni čovek ni žena da ne donosi više priloge za svetinju. I zabrani se narodu da ne donosi. ");
INSERT INTO srp1865_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Jer beše svega dosta da se uradi sve delo, i još pretecaše. ");
INSERT INTO srp1865_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","I ljudi vešti između onih, koji radiše ovo delo, načiniše šator od deset zavesa od tankog platna uzvedenog i od porfire i od skerleta i od crvca, s heruvimima, vešto vezenim načiniše. ");
INSERT INTO srp1865_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","U dužinu beše jedan zaves od dvadeset i osam lakata a u širinu od četiri lakta; svi zavesi behu jedne mere. ");
INSERT INTO srp1865_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","I sastaviše pet zavesa jedan s drugim, i pet drugih zavesa sastaviše jedan s drugim. ");
INSERT INTO srp1865_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","I načiniše petlje od porfire po kraju prvog zavesa na onoj strani gde će se sastaviti s drugim; i tako načiniše na svakom zavesu po kraju gde će se sastaviti s drugim. ");
INSERT INTO srp1865_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Pedeset petalja načiniše na prvom zavesu, i pedeset petalja načiniše na kraju svakog zavesa gde se sastavlja s drugim; petlje behu jedna prema drugoj. ");
INSERT INTO srp1865_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","I načiniše pedeset zlatnih kuka, i sastaviše kukama zavese jedan s drugim; tako se šator sastavi. ");
INSERT INTO srp1865_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","I načiniše zavese od kostreti za naslon nad šatorom; jedanaest takvih zavesa načiniše. ");
INSERT INTO srp1865_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","U dužinu beše jedan zaves od trideset lakata a u širinu od četiri lakta; jedne mere beše svih jedanaest zavesa. ");
INSERT INTO srp1865_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","I sastaviše pet zavesa zajedno, a drugih šest zavesa zajedno. ");
INSERT INTO srp1865_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","I načiniše pedeset petalja po kraju jednog zavesa gde se sastavlja sa drugim, i pedeset petalja načiniše po kraju drugog zavesa da se sastavi. ");
INSERT INTO srp1865_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","I načiniše pedeset kuka od bronze da se sastavi naslon. ");
INSERT INTO srp1865_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","I načiniše pokrivač na naslon od koža ovnujskih crvenih obojenih, i pokrivač od koža jazavičijih ozgo. ");
INSERT INTO srp1865_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","I načiniše daske šatoru od drveta sitima, koje će stajati pravo. ");
INSERT INTO srp1865_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Daska beše duga deset lakata a podrug lakta široka svaka daska. ");
INSERT INTO srp1865_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Po dva čepa behu na dasci, jedan prema drugom; tako načiniše na svim daskama za šator. ");
INSERT INTO srp1865_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","A ovih dasaka za šator načiniše dvadeset dasaka za južnu stranu; ");
INSERT INTO srp1865_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","i četrdeset stopica srebrnih načiniše pod dvadeset dasaka, dve stopice pod jednu dasku za dva čepa njena, a dve stopice pod drugu dasku za dva čepa njena. ");
INSERT INTO srp1865_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Tako i na drugoj strani šatora, prema severu, načiniše dvadeset dasaka, ");
INSERT INTO srp1865_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","i četrdeset stopica srebrnih pod njih, dve stopice pod jednu dasku a dve stopice pod drugu dasku. ");
INSERT INTO srp1865_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","A na zapadnoj strani šatora načiniše šest dasaka; ");
INSERT INTO srp1865_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","i još dve daske načiniše na uglove šatoru s obe strane; ");
INSERT INTO srp1865_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","one behu sastavljene ozdo, i behu sastavljene ozgo biočugom; tako načiniše s obe strane na dva ugla. ");
INSERT INTO srp1865_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","I tako beše osam dasaka i šesnaest stopica njihovih srebrnih, po dve stopice pod svaku dasku. ");
INSERT INTO srp1865_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","I načiniše prevornice od drveta sitima: pet za daske na jednoj strani šatora, ");
INSERT INTO srp1865_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","i pet prevornica za daske na drugoj strani šatora, i pet prevornica za daske na zapadnoj strani šatora do oba ugla. ");
INSERT INTO srp1865_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","I načiniše prevornicu srednju da ide preko srede dasaka od jednog kraja do drugog. ");
INSERT INTO srp1865_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","A daske okovaše zlatom, i biočuge na njih načiniše od zlata, da u njima stoje prevornice, i okovaše zlatom prevornice. ");
INSERT INTO srp1865_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","I načiniše zaves od porfire i od skerleta i od crvca i od tankog platna uzvedenog, s heruvimima vešto vezenim načiniše ga. ");
INSERT INTO srp1865_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","I načiniše za nj četiri stupa od drveta sitima, i okovaše ih zlatom, a kuke na njima behu od zlata, i sališe im četiri stopice od srebra. ");
INSERT INTO srp1865_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","I načiniše zaves na vrata naslonu od porfire i od skerleta i od crvca i od tankog platna uzvedenog vezen, ");
INSERT INTO srp1865_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","i pet stupova za nj s kukama njihovim, i vrhove im i pojase okovaše zlatom, i pet stopica pod njih od bronze. ");
INSERT INTO srp1865_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","I načini Veseleilo kovčeg od drveta sitima, dva i po lakta dug i podrug lakta širok i podrug lakta visok. ");
INSERT INTO srp1865_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","I pokova ga čistim zlatom iznutra i spolja; i načini mu zlatan venac unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","I sali mu četiri biočuga od zlata na četiri ugla njegova: dva biočuga s jedne strane a dva s druge. ");
INSERT INTO srp1865_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","I načini poluge od drveta sitima, i okova ih zlatom. ");
INSERT INTO srp1865_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","I provuče poluge kroz biočuge s obe strane kovčegu, da se može nositi kovčeg. ");
INSERT INTO srp1865_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","I načini zaklopac od čistog zlata, u dužinu od dva i po lakta, a u širinu od podrug lakta. ");
INSERT INTO srp1865_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","I načini dva heruvima od zlata, jednostavne načini ih, na dva kraja zaklopcu, ");
INSERT INTO srp1865_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","jednog heruvima na kraju odovud, a drugog heruvima na kraju odonud; zaklopcu na oba kraja načini heruvime. ");
INSERT INTO srp1865_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","I u heruvima behu krila raširena u vis, i zaklanjahu krilima svojim zaklopac, i licem behu okrenuti jedan drugom, i gledahu prema zaklopcu heruvimi. ");
INSERT INTO srp1865_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","I načini sto od drveta sitima, u dužinu od dva lakta a u širinu od lakta, i od podrug lakta u visinu. ");
INSERT INTO srp1865_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","I pokova ga čistim zlatom, i načini mu venac zlatan unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","I načini mu oplatu s podlanice unaokolo, i načini venac zlatan uz oplatu unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","I sali mu četiri biočuga od zlata, i metnu biočuge na četiri ugla, koji mu behu na četiri noge. ");
INSERT INTO srp1865_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Prema oplati behu biočuzi, a u njima poluge, da se može nositi sto. ");
INSERT INTO srp1865_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","A poluge načini od drveta sitima, i okova ih zlatom, da se može nositi sto. ");
INSERT INTO srp1865_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","I načini od čistog zlata posuđe što se meće na sto: zdele i čaše i kotliće i vedra, kojim će se prelivati. ");
INSERT INTO srp1865_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","I načini svećnjak od čistog zlata, jednostavan načini svećnjak; stup mu i grane, čašice i jabuke i cvetovi izlažahu iz njega. ");
INSERT INTO srp1865_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Šest grana izlažahu mu sa strana; tri grane svećnjaka s jedne strane a tri grane svećnjaka s druge strane; ");
INSERT INTO srp1865_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","tri čašice kao badem na jednoj grani i jabuka i cvet, a tri čašice kao badem na drugoj grani i jabuka i cvet; tako na svih šest grana koje izlažahu iz svećnjaka. ");
INSERT INTO srp1865_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","A na samom svećnjaku behu četiri čašice kao badem sa svojim jabukama i cvetovima, ");
INSERT INTO srp1865_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","jedna jabuka beše pod dve grane iz njega, i jedna jabuka pod druge dve grane iz njega, i jedna jabuka pod druge dve grane iz njega; tako pod šest grana koje izlažahu iz njega. ");
INSERT INTO srp1865_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Jabuke njihove i grane im izlažahu iz njega, sve beše od čistog zlata jednostavno. ");
INSERT INTO srp1865_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","I načini mu sedam žižaka i usekače i spremice za gar od čistog zlata. ");
INSERT INTO srp1865_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Od talanta čistog zlata načini ga sa svim spravama njegovim. ");
INSERT INTO srp1865_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","I načini oltar kadioni od drveta sitima u dužinu od jednog lakta, i u širinu od jednog lakta, četvorouglast, i od dva lakta u visinu; iz njega izlažahu mu rogovi. ");
INSERT INTO srp1865_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","I pokova ga čistim zlatom ozgo i sa strane unaokolo, i rogove; i načini mu venac od zlata unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","I dva biočuga od zlata načini mu ispod venca na dva ugla njegova s obe strane, da u njima stoje poluge da se može nositi o njima. ");
INSERT INTO srp1865_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A poluge načini od drveta sitima, i okova ih zlatom. ");
INSERT INTO srp1865_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","I načini ulje za sveto pomazanje i čisti kad mirisni veštinom apotekarskom. ");
INSERT INTO srp1865_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","I načini od drveta sitima oltar za žrtve paljenice u dužinu od pet lakata, i u širinu od pet lakata, četvorouglast, visok tri lakta. ");
INSERT INTO srp1865_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","I načini mu na četiri ugla njegova rogove; iz njega izlažahu rogovi, i okova ga u bronzu. ");
INSERT INTO srp1865_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","I načini sve posuđe za oltar, lonce i lopatice i kotliće i viljuške i klešta; sve mu posuđe načini od bronze. ");
INSERT INTO srp1865_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","I načini oltaru rešetku kao mrežu od bronze ispod oltara unaokolo oda dna do sredine. ");
INSERT INTO srp1865_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","I sali četiri biočuga za četiri ugla rešetke bronzane, da se kroz njih provuku poluge. ");
INSERT INTO srp1865_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A poluge načini od drveta sitima, i okova ih u bronzu. ");
INSERT INTO srp1865_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","I provuče poluge kroz biočuge s obe strane oltara, da se može nositi, od dasaka načini ga šupljeg. ");
INSERT INTO srp1865_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","I načini umivaonicu bronzanu i podnožje joj bronzano od ogledala koja donošahu gomilama žene dolazeći na vrata šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","I načini trem na južnoj strani, i zavese tremu od tankog platna uzvedenog od sto lakata, ");
INSERT INTO srp1865_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","i dvadeset stupova za njih i dvadeset stopica pod njih od bronze, a kuke na stupove i prevornice od srebra. ");
INSERT INTO srp1865_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tako i na severnoj strani zavese od sto lakata, dvadeset stupova za njih i dvadeset stopica pod njih od bronze; a kuke na stupove i prevornice njihove od srebra; ");
INSERT INTO srp1865_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","a na zapadnoj strani zavese od pedeset lakata, deset stupova za njih i deset stopica njihovih od bronze, kuke na stupovima i pojaseve njihove od srebra; ");
INSERT INTO srp1865_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","a na prednjoj strani prema istoku zavese od pedeset lakata; ");
INSERT INTO srp1865_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","s jedne strane zavese od petnaest lakata, tri stupa za njih i tri stopice pod njih; ");
INSERT INTO srp1865_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","a s druge strane, do vrata od trema i otuda i odovuda, zavese od petnaest lakata, tri stupa za njih i tri stopice pod njih. ");
INSERT INTO srp1865_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Svi zavesi na tremu unaokolo behu od tankog platna uzvedenog; ");
INSERT INTO srp1865_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","a stopice pod stupovima od bronze, kuke na stupovima i pojasevi na njima od srebra; i vrhovi im behu srebrni; svi stupovi u tremu behu opasani srebrom. ");
INSERT INTO srp1865_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","A zaves na vratima od trema beše od porfire i od skerleta i od crvca i od tankog platna uzvedenog, vezen, u dužinu od dvadeset lakata a u visinu po širini pet lakata, kao i drugi zavesi u tremu. ");
INSERT INTO srp1865_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","I četiri stupa za nj, i četiri stopice pod njih od bronze, čepovi na njima od srebra i vrhovi im i pojasevi od srebra. ");
INSERT INTO srp1865_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","A sve kolje šatoru i tremu unaokolo beše od bronze. ");
INSERT INTO srp1865_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Te su stvari prebrojane za šator, šator od svedočanstva, koje je prebrojao po zapovesti Mojsijevoj Itamar, sin Arona sveštenika za službu levitsku. ");
INSERT INTO srp1865_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","A Veseleilo, sin Urije sina Orovog od plemena Judinog, načini sve to što zapovedi Gospod Mojsiju, ");
INSERT INTO srp1865_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","i s njim Elijav, sin Ahisamahov od plemena Danovog, drvodelja i vešt tkati i vesti po porfiri, po skerletu, po crvcu i po tankom platnu. ");
INSERT INTO srp1865_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","A svega zlata što otide na ovo delo, na sve delo za svetinju, koje zlato beše priloženo, svega ga beše dvadeset i devet talanata, sedam stotina i trideset sikala, po svetom siklu; ");
INSERT INTO srp1865_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","a srebra što dođe od zbora, sto talanata, i hiljada sedam stotina i sedamdeset i pet sikala, po svetom siklu; ");
INSERT INTO srp1865_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","pola sikla od glave, po siklu svetom, od svakog koji uđe u broj, od dvadeset godina i više, od šest stotina i tri hiljade i pet stotina i pedeset. ");
INSERT INTO srp1865_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Od sto talanata srebra sališe se stopice za svetinju i stopice za zaves; sto stopica od sto talanata, talanat na stopicu. ");
INSERT INTO srp1865_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A od hiljadu i sedam stotina i sedamdeset i pet sikala načini kuke na stupove, i okova im vrhove i opasa ih. ");
INSERT INTO srp1865_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","A bronze priložene beše sedamdeset talanata, i dve hiljade i četiri stotine sikala. ");
INSERT INTO srp1865_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","I od toga načini stopice na vratima šatora od sastanka, i bronzani oltar i rešetku bronzanu za nj, i sve sprave za oltar, ");
INSERT INTO srp1865_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","i stopice u tremu unaokolo, i stopice na vratima od trema, i sve kolje za šator i sve kolje za trem unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","A od porfire i skerleta i crvca načiniše haljine za službu, da se služi u svetinji; i načiniše svete haljine Aronu, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Načiniše oplećak od zlata, i od porfire i od skerleta i od crvca i od tankog platna uzvedenog. ");
INSERT INTO srp1865_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Istegliše listove od zlata, i isekoše žice, te izvezoše porfiru i skerlet i crvac i tanko platno vrlo vešto. ");
INSERT INTO srp1865_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Poramenice mu načiniše da se sastavljaju, da se sastavlja na dva kraja svoja. ");
INSERT INTO srp1865_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","I pojas na oplećku izlažaše od njega i beše iste naprave, od zlata i od porfire i od skerleta i od crvca i od tankog platna uzvedenog; kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","I ukovaše dva kamena oniha u zlato, i izrezaše na njima imena sinova Izrailjevih, kao što se režu pečati. ");
INSERT INTO srp1865_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","I udariše ih na poramenice od oplećka, da budu kameni za spomen sinovima Izrailjevim, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","I načiniše naprsnik vrlo vešte naprave kao što je naprava u oplećka, od zlata i od porfire i od skerleta i od crvca i od tankog platna uzvedenog; ");
INSERT INTO srp1865_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","četvorouglast i dvostruk načiniše naprsnik, u dužinu s pedi i u širinu s pedi, dvostruk. ");
INSERT INTO srp1865_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","I udariše po njemu četiri reda kamenja; u prvom redu: sardoniks, topaz i smaragd; ");
INSERT INTO srp1865_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","a u drugom redu: karbunkul, safir i dijamant; ");
INSERT INTO srp1865_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","a u trećem redu: ligur, ahat i ametist; ");
INSERT INTO srp1865_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","a u četvrtom redu: hrisolit, onih i jaspis, sve optočeno zlatom u svojim redovima. ");
INSERT INTO srp1865_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Tih kamena s imenima sinova Izrailjevih beše dvanaest prema njihovim imenima, rezani kao pečati, za dvanaest plemena, svako po svom imenu. ");
INSERT INTO srp1865_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","I načiniše na naprsnik lance jednake, pletene, od čistog zlata. ");
INSERT INTO srp1865_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","I načiniše dve kopče zlatne i dve grivne zlatne, i metnuše te dve grivne na dva kraja naprsniku, ");
INSERT INTO srp1865_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","i provukoše dva zlatna lanca kroz dve grivne na krajevima naprsniku, ");
INSERT INTO srp1865_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","a druga dva kraja od dva lanca zapeše za dve kopče, i pritvrdiše ih za poramenice na oplećku spred. ");
INSERT INTO srp1865_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","I načiniše još dve zlatne grivne, i metnuše ih na dva kraja naprsniku, na strani prema oplećku iznutra. ");
INSERT INTO srp1865_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","I načiniše još dve grivne zlatne, koje metnuše na dve poramenice na oplećku ozdo napred gde se sastavlja, više pojasa na oplećku. ");
INSERT INTO srp1865_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Tako privezaše naprsnik kroz grivne na njemu i grivne na oplećku vrpcom od porfire, da stoji svrh pojasa od oplećka i da se ne razdvaja naprsnik od oplećka, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","I načiniše plašt pod oplećak, tkan, sav od porfire. ");
INSERT INTO srp1865_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","I prorez na plaštu u sredi kao prorez na oklopu, i oko proreza oplatu da se ne razdre. ");
INSERT INTO srp1865_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","I načiniše po skutu od plašta šipke od porfire i od skerleta i od crvca i od tankog platna uzvedenog. ");
INSERT INTO srp1865_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","I načiniše zvonca od čistog zlata, i metnuše zvonca među šipke, po skutu od plašta unaokolo između šipaka. ");
INSERT INTO srp1865_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Zvonce pa šipak, zvonce pa šipak po skutu od plašta unaokolo, za službu, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","I načiniše košulje od tankog platna izmetanog Aronu i sinovima njegovim; ");
INSERT INTO srp1865_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","i kapu od tankog platna, i kapice kićene od tankog platna, i gaće platnene od tankog platna uzvedenog; ");
INSERT INTO srp1865_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","i pojas od tankog platna uzvedenog i od porfire i od skerleta i od crvca, vezen, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","I načiniše pločicu za sveto oglavlje od čistog zlata, i napisaše na njoj pismom kako se reže na pečatima: Svetinja Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","I pritvrdiše za nju vrpcu od porfire da se veže za kapu ozgo, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","I tako se svrši sav posao oko šatora i naslona od sastanka. I načiniše sinovi Izrailjevi sve; kako beše zapovedio Gospod Mojsiju, tako načiniše. ");
INSERT INTO srp1865_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","I donesoše k Mojsiju šator, naslon i sve sprave njegove, kuke, daske, prevornice, stupove i stopice, ");
INSERT INTO srp1865_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","i pokrivač od koža ovnujskih crvenih obojenih i pokrivač od koža jazavičijih, i zaves, ");
INSERT INTO srp1865_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","i kovčeg od svedočanstva i poluge za nj, i zaklopac, ");
INSERT INTO srp1865_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","sto sa svim spravama, i hleb za postavljanje, ");
INSERT INTO srp1865_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","svećnjak čisti, žiške njegove, žiške naređane, i sve sprave njegove, i ulje za videlo. ");
INSERT INTO srp1865_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","I oltar zlatni, i ulje pomazanja, i kad mirisni, i zaves na vrata od šatora. ");
INSERT INTO srp1865_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Oltar bronzani i rešetku bronzanu za nj, poluge njegove i sve sprave njegove, umivaonicu i podnožje njeno, ");
INSERT INTO srp1865_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","zavese za trem, stupove za njih i stopice njihove, i zaves na vrata od trema, uža njegova i kolje njegovo, i sve sprave za službu u šatoru, za šator od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Haljine za službu, da se služi u svetinji, haljine svete Aronu svešteniku i haljine sinovima njegovim, da vrše službu svešteničku. ");
INSERT INTO srp1865_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Sve kako beše zapovedio Gospod Mojsiju, onako uradiše sinovi Izrailjevi sve ovo delo. ");
INSERT INTO srp1865_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","I pogleda Mojsije sve to delo, i gle, načiniše ga, kao što beše zapovedio Gospod, tako ga načiniše; i blagoslovi ih Mojsije. ");
INSERT INTO srp1865_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","I Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Prvi dan prvog meseca podigni šator, šator od sastanka, ");
INSERT INTO srp1865_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","i metni onde kovčeg od svedočanstva, i zakloni ga zavesom. ");
INSERT INTO srp1865_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","I unesi sto, i uredi šta treba urediti na njemu; unesi i svećnjak, i zapali žiške na njemu. ");
INSERT INTO srp1865_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","I namesti zlatni oltar kadioni pred kovčegom od svedočanstva; i obesi zaves na vratima od šatora. ");
INSERT INTO srp1865_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","I metni oltar za žrtvu paljenicu pred vrata šatoru, šatoru od sastanka, ");
INSERT INTO srp1865_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","i metni umivaonicu između šatora od sastanka i oltara, i u nju nalij vode. ");
INSERT INTO srp1865_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","I podigni trem unaokolo, i metni zaves na vrata od trema. ");
INSERT INTO srp1865_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","I uzmi ulje pomazanja, i pomaži šator i sve što je u njemu, i osveti ga i sve sprave njegove, i biće svet. ");
INSERT INTO srp1865_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Pomaži i oltar za žrtvu paljenicu i sve sprave njegove, te ćeš osvetiti oltar, i oltar će biti svetinja nad svetinjom. ");
INSERT INTO srp1865_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Pomaži i umivaonicu i podnožje njeno, i osveti je. ");
INSERT INTO srp1865_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","I kaži Aronu i sinovima njegovim da pristupe na vrata šatora od sastanka, i umij ih vodom; ");
INSERT INTO srp1865_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","i obuci Arona u svete haljine i pomaži ga i osveštaj ga, da mi vrši službu svešteničku. ");
INSERT INTO srp1865_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","I sinovima njegovim zapovedi neka mi pristupe, i obuci im košulje. ");
INSERT INTO srp1865_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","I pomaži ih, kao što pomažeš oca njihovog, da mi vrše službu svešteničku; i pomazanje njihovo biće im, za večno sveštenstvo od kolena do kolena. ");
INSERT INTO srp1865_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","I učini Mojsije sve, kako mu zapovedi Gospod tako učini. ");
INSERT INTO srp1865_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","I podiže se šator druge godine prvog meseca prvi dan. ");
INSERT INTO srp1865_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","I Mojsije podiže šator, i podmetnu mu stopice, i namesti daske, i povuče prevornice, i ispravi stupove. ");
INSERT INTO srp1865_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Pa razape naslon nad šator, i metnu pokrivač na naslon ozgo, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","I uzevši svedočanstvo metnu ga u kovčeg, i provuče poluge na kovčegu, i metnu zaklopac ozgo na kovčeg. ");
INSERT INTO srp1865_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","I unese kovčeg u šator, i obesi zaves, te zakloni kovčeg sa svedočanstvom, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","I namesti sto u šatoru od sastanka na severnu stranu šatora pred zavesom, ");
INSERT INTO srp1865_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","i postavi na njemu hleb pred Gospodom kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","I namesti svećnjak u šatoru od sastanka, prema stolu na južnu stranu šatora. ");
INSERT INTO srp1865_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","I zapali žiške na njemu pred Gospodom, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","I namesti oltar zlatni u šatoru od svedočanstva pred zavesom. ");
INSERT INTO srp1865_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","I pokadi na njemu kadom mirisnim, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","I obesi zaves na vrata od šatora. ");
INSERT INTO srp1865_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","I oltar za žrtvu paljenicu namesti na vrata od šatora, šatora od sastanka, i prinese na njemu žrtvu paljenicu, i dar, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","I metnu umivaonicu između šatora od sastanka i oltara, i nali u nju vode za umivanje. ");
INSERT INTO srp1865_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","I praše iz nje ruke i noge svoje Mojsije i Aron i sinovi njegovi. ");
INSERT INTO srp1865_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Kad ulažahu u šator od svedočanstva i kad pristupahu k oltaru, umivahu se najpre, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","I podiže trem oko šatora i oltara, i metnu zaves na vrata tremu. Tako svrši Mojsije posao taj. ");
INSERT INTO srp1865_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tada oblak pokri šator od sastanka, i napuni se šator slave Gospodnje. ");
INSERT INTO srp1865_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","I ne mogaše Mojsije ući u šator od sastanka, jer beše na njemu oblak, i slave Gospodnje beše pun šator. ");
INSERT INTO srp1865_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","A kad se podizaše oblak sa šatora, tada polažahu sinovi Izrailjevi, dokle god putovahu. ");
INSERT INTO srp1865_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","A kad se ne podizaše oblak, onda ni oni ne polažahu do dana kad se podiže. ");
INSERT INTO srp1865_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Jer oblak Gospodnji beše na šatoru danju, a noću oganj beše na njemu pred očima svega doma Izrailjevog, dokle god putovahu. ");
INSERT INTO srp1865_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","I viknu Gospod Mojsija, i reče mu iz šatora od sastanka govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Kaži sinovima Izrailjevim, i reci im: Kad ko između vas hoće da prinese Gospodu žrtvu od stoke, prinesite žrtvu svoju od goveda ili od ovaca ili od koza. ");
INSERT INTO srp1865_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ako mu je žrtva paljenica od goveda, neka prinese muško, zdravo; na vratima šatora od sastanka neka je prinese drage volje pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","I neka metne ruku svoju na glavu žrtvi paljenici, i primiće mu se, i očistiće ga od greha. ");
INSERT INTO srp1865_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","I neka zakolje tele pred Gospodom, i neka sinovi Aronovi sveštenici prinesu krv, i pokrope oltar krvlju odozgo unaokolo, koji je pred vratima šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Potom neka se odre žrtva paljenica i neka se raseče na delove. ");
INSERT INTO srp1865_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","I sinovi Aronovi, sveštenici neka nalože oganj na oltaru, i metnu drva na oganj. ");
INSERT INTO srp1865_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Pa onda sinovi Aronovi sveštenici neka nameste delove, glavu i salo na drva na ognju, koji je na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","A creva i noge neka se operu vodom; i sveštenik neka zapali sve to na oltaru; to je žrtva paljenica, žrtva ognjena na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ako li bi hteo prineti žrtvu paljenicu od sitne stoke, od ovaca ili od koza, neka prinese muško, zdravo. ");
INSERT INTO srp1865_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","I neka se zakolje na severnoj strani oltara pred Gospodom, i sinovi Aronovi sveštenici neka pokrope krvlju oltar odozgo unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","I neka se raseče na delove s glavom i sa salom, i sveštenik neka to namesti na drva na ognju, koji je na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","A creva i noge neka se operu vodom; i sveštenik neka prinese sve to i neka zapali na oltaru; to je žrtva paljenica, žrtva ognjena na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ako li hoće da prinese pticu Gospodu na žrtvu paljenicu, neka prinese žrtvu od grlica ili od golubića. ");
INSERT INTO srp1865_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","I sveštenik neka je metne na oltar, i glavu neka joj zaseče noktom, i zapali na oltaru iscedivši joj krv niz oltar sa strane. ");
INSERT INTO srp1865_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","I neka joj izvadi volju s nečistotom i baci kraj oltara prema istoku gde je pepeo. ");
INSERT INTO srp1865_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","I neka je zadre za krila, ali da ne raskine; tako neka je sveštenik zapali na oltaru na drvima koja su na ognju; to je žrtva paljenica, žrtva ognjena na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","A kad ko hoće da prinese na žrtvu Gospodu dar, belo brašno neka bude žrtva njegova, i neka je polije uljem i metne na nju kad. ");
INSERT INTO srp1865_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","I neka je donese sinovima Aronovim sveštenicima, i neka sveštenik uzme tog brašna punu šaku i ulja i sav kad, i neka to zapali sveštenik na oltaru za spomen njen; to je žrtva ognjena na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","A šta ostane od tog dara, neka bude Aronu i sinovima njegovim; to je svetinja nad svetinjama između žrtava koje se pale Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ako li hoćeš da prineseš dar pečen u peći, neka budu pogače presne od belog brašna, zamešene s uljem, ili kolači presni, namazani uljem. ");
INSERT INTO srp1865_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ako li ti je dar pečeno šta u tavi, neka je od belog brašna bez kvasca zamešeno s uljem. ");
INSERT INTO srp1865_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Razlomi ga na delove, i polij uljem; to je dar. ");
INSERT INTO srp1865_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ako li ti je dar gotovljen u kotliću, neka je od belog brašna s uljem. ");
INSERT INTO srp1865_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","I donesi dar koji načiniš od toga Gospodu, i podaj ga svešteniku, i on će ga odneti na oltar; ");
INSERT INTO srp1865_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","i uzeće sveštenik od dara spomen njegov, i zapaliće ga na oltaru; to je žrtva ognjena na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","A šta ostane od dara, neka bude Aronu i sinovima njegovim; to je svetinja nad svetinjama između žrtava koje se pale Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Nijedan dar koji prinosite Gospodu da ne bude s kvascem; jer ni kvasac ni med ne treba da palite na žrtvu ognjenu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Samo u žrtvi od prvina možete prineti to Gospodu; ali na oltar ne mećite za ugodni miris. ");
INSERT INTO srp1865_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","A svaki dar koji prinosiš osoli solju, i nemoj ostaviti dar svoj bez soli zaveta Boga svog; sa svakim darom svojim prinesi soli. ");
INSERT INTO srp1865_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","A kad prinosiš dar od prvina Gospodu, klasove nove osuši na ognju, a šta istreš iz klasova novih prinesi na dar od prvina svojih. ");
INSERT INTO srp1865_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","I polij ga uljem i kad metni na nj; to je dar. ");
INSERT INTO srp1865_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","I sveštenik uzevši istrvenog žita i ulja sa svim kadom neka zapali spomen. To je žrtva ognjena Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Kad ko prinosi žrtvu zahvalnu, ako od goveda prinosi, muško ili žensko neka prinese zdravo pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","I neka metne ruku svoju na glavu žrtvi svojoj, i neka je sveštenik zakolje na vratima šatora od sastanka, i krvlju njenom neka sinovi Aronovi, sveštenici pokrope oltar odozgo unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Potom neka sveštenik prinese od žrtve zahvalne ono što se pali Gospodu, salo što pokriva creva i sve salo što je na njima; ");
INSERT INTO srp1865_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","i oba bubrega i salo što je na njima i na slabinama, i mrežicu što je na jetri, neka je izvadi s bubrezima. ");
INSERT INTO srp1865_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","I neka to zapale sinovi Aronovi na oltaru zajedno sa žrtvom paljenicom, koja bude na drvima na ognju. To je žrtva ognjena na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ako li od sitne stoke prinosi na žrtvu zahvalnu Gospodu, muško ili žensko neka prinese zdravo. ");
INSERT INTO srp1865_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ako prinosi jagnje na žrtvu, neka ga prinese pred Gospodom; ");
INSERT INTO srp1865_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","i neka metne ruku svoju na glavu žrtvi svojoj, i neka je zakolje pred šatorom od sastanka; i neka pokrope sinovi Aronovi krvlju njenom oltar odozgo unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Potom neka sveštenik prinese od žrtve zahvalne ono što se pali Gospodu, salo, ceo rep do leđa, salo što pokriva creva i sve salo što je na crevima; ");
INSERT INTO srp1865_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","i oba bubrega i salo što je na njima i na slabinama, i mrežicu na jetri, s bubrezima neka je izvadi; ");
INSERT INTO srp1865_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","i neka zapali sveštenik na oltaru; to je jelo od žrtve ognjene Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ako li prinosi kozu, neka je prinese pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","I neka joj metne ruku svoju na glavu, i neka je zakolje pred šatorom od sastanka, i neka sinovi Aronovi pokrope krvlju njenom oltar odozgo unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Potom neka sveštenik prinese od nje na žrtvu što se pali Gospodu, salo što pokriva creva i sve salo što je na crevima, ");
INSERT INTO srp1865_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","i oba bubrega, i salo što je na njima i na slabinama, i mrežicu na jetri, s bubrezima neka je izvadi; ");
INSERT INTO srp1865_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","i neka zapali sveštenik na oltaru; to je jelo od žrtve ognjene za ugodni miris. Sve je salo Gospodnje. ");
INSERT INTO srp1865_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Večan zakon neka vam bude od kolena do kolena u svim stanovima vašim: da ne jedete salo ni krv. ");
INSERT INTO srp1865_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Kaži sinovima Izrailjevim, i reci: Ako ko zgreši nehotice i učini štagod što je Gospod zabranio da se ne čini, ");
INSERT INTO srp1865_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ako sveštenik pomazani zgreši, te bude na greh narodu, neka za greh svoj koji je učinio prinese tele zdravo Gospodu na žrtvu za greh. ");
INSERT INTO srp1865_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","I dovedavši tele na vrata šatoru od svedočanstva pred Gospoda, neka metne ruku svoju teletu na glavu, i zakolje tele pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","I neka uzme sveštenik pomazani krvi od teleta, i unese je u šator od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","I neka zamoči sveštenik prst svoj u krv, i krvlju sedam puta pokropi pred Gospodom pred zavesom od svetinje. ");
INSERT INTO srp1865_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","I neka pomaže sveštenik tom krvlju rogove oltaru, na kome se kadi mirisima pred Gospodom u šatoru od sastanka, a ostalu krv od teleta svu neka izlije na podnožje oltaru, na kome se pale žrtve na vratima šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","I neka izvadi sve salo iz teleta za greh, salo što pokriva creva i sve salo što je na crevima; ");
INSERT INTO srp1865_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","i oba bubrega, i salo što je na njima i na slabinama, i mrežicu na jetri s bubrezima neka izvadi, ");
INSERT INTO srp1865_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","onako kako se vadi iz govečeta za žrtvu zahvalnu; i neka zapali sveštenik na oltaru, na kome se žrtva pali. ");
INSERT INTO srp1865_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","A kožu od teleta i sve meso s glavom i s nogama i creva i balegu, ");
INSERT INTO srp1865_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","i celo tele neka iznese napolje iz logora na čisto mesto, gde se prosipa pepeo, i neka ga spali ognjem na drvima; na mestu gde se prosipa pepeo neka se spali. ");
INSERT INTO srp1865_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ako li bi sav zbor sinova Izrailjevih zgrešio nehotice i ne bi zbor znao za to, i učinili bi štagod što je Gospod zabranio da se ne čini, te bi skrivili, ");
INSERT INTO srp1865_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","kad se dozna za greh koji su učinili, onda neka zbor prinese tele, žrtvu za greh, i neka ga dovedu pred šator od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","I starešine od zbora neka metnu teletu na glavu ruke svoje pred Gospodom, i sveštenik neka zakolje tele pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","I sveštenik pomazani neka unese krvi od teleta u šator od sastanka, ");
INSERT INTO srp1865_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","i neka sveštenik zamoči prst svoj u krv, i sedam puta pokropi pred Gospodom pred zavesom. ");
INSERT INTO srp1865_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","I tom krvlju neka pomaže rogove oltaru koji je pred Gospodom u šatoru od sastanka, a ostalu krv svu neka izlije na podnožje oltaru na kome se pali žrtva, na vratima šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","A sve salo izvadivši iz njega neka zapali na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","I s tim teletom neka čini onako kako čini s teletom za svoj greh, tako neka učini s njim; tako će ih sveštenik očistiti od greha, i oprostiće im se. ");
INSERT INTO srp1865_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","A tele neka iznese napolje iz logora, i spali ga kao i prvo tele; to je žrtva za greh svega zbora. ");
INSERT INTO srp1865_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ako li poglavar zgreši, i učini nehotice štagod što je Gospod Bog njegov zabranio da se ne čini, te skrivi, ");
INSERT INTO srp1865_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","kad dozna za greh svoj, koji je učinio, tada neka dovede na žrtvu jare muško, zdravo. ");
INSERT INTO srp1865_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","I neka metne ruku svoju jaretu na glavu, i sveštenik neka ga zakolje gde se kolje žrtva paljenica pred Gospodom; to je žrtva za greh. ");
INSERT INTO srp1865_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","I neka uzme sveštenik krvi od žrtve za greh na prst svoj, i pomaže rogove oltaru na kome se žrtva pali; a ostalu krv neka izlije na podnožje oltaru na kome se žrtva pali. ");
INSERT INTO srp1865_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","A sve salo neka zapali na oltaru kao salo od žrtve zahvalne; i tako će ga očistiti sveštenik od greha njegovog, i oprostiće mu se. ");
INSERT INTO srp1865_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ako li ko iz prostog naroda zgreši nehotice, i učini štagod što je Gospod zabranio da se ne čini, te skrivi, ");
INSERT INTO srp1865_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","kad dozna za greh svoj, koji je učinio, tada neka dovede na žrtvu jare žensko zdravo za greh, koji je učinio. ");
INSERT INTO srp1865_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","I neka metne ruku svoju na glavu žrtvi za greh, i neka je sveštenik zakolje na mestu gde se kolje žrtva paljenica. ");
INSERT INTO srp1865_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","I neka uzme sveštenik krvi od nje na prst svoj, I pomaže rogove oltaru na kome se pali žrtva; a ostalu krv svu neka izlije na podnožje oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","I sve salo iz nje neka izvadi kao što se vadi salo iz žrtve zahvalne, i neka ga zapali sveštenik na oltaru za ugodni miris Gospodu; a tako će ga očistiti od greha sveštenik, I oprostiće mu se. ");
INSERT INTO srp1865_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ako li bi doveo između ovaca na žrtvu za greh, neka dovede žensko zdravo. ");
INSERT INTO srp1865_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","I neka metne ruku svoju na glavu žrtvi za greh, i neka je sveštenik zakolje na mestu gde se kolje žrtva paljenica. ");
INSERT INTO srp1865_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","I neka uzme sveštenik krvi od žrtve za greh na prst svoj, i neka pomaže rogove oltaru na kome se pali žrtva; a ostalu krv svu neka izlije na podnožje oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","I sve salo neka izvadi kao što se vadi salo iz jagnjeta za žrtvu zahvalnu; i neka ga sveštenik zapali na oltaru za žrtvu ognjenu Gospodu; i tako će ga očistiti sveštenik od greha njegovog, koji je učinio, i oprostiće mu se. ");
INSERT INTO srp1865_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","I kad ko zgreši što čuje kletvu i bude joj svedok videvši ili čuvši, pa ne kaže, nosiće svoje bezakonje. ");
INSERT INTO srp1865_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ili kad se ko dotakne nečiste stvari, strva od nečiste zverke ili strva od nečistog živinčeta ili strva od nečiste životinje koja gamiže, ako i u neznanju učini, ipak će se oskvrniti, i biće kriv. ");
INSERT INTO srp1865_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ili kad se dotakne nečistote čovečije, bila nečistota njegova kakva mu drago, kojom se oskvrni, znajući ili ne znajući, kriv je. ");
INSERT INTO srp1865_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ili kad se ko zakune govoreći svojim ustima da će učiniti šta zlo ili dobro, a za koju god stvar za koju čovek govori zaklinjući se, znao ili ne znao, kriv je za jednu od tih stvari. ");
INSERT INTO srp1865_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Kad bude kriv za koju od tih stvari, neka prizna greh svoj. ");
INSERT INTO srp1865_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","I neka dovede na žrtvu Gospodu za greh, što je zgrešio, žensko od sitne stoke, jagnje ili jare, za greh; i sveštenik će ga očistiti od greha njegovog. ");
INSERT INTO srp1865_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ako li ne bi mogao prineti jagnjeta ili jareta, onda neka donese na žrtvu Gospodu za prestup, kojim je zgrešio, dve grlice ili dva golubiće, jedno na žrtvu za greh a drugo na žrtvu paljenicu. ");
INSERT INTO srp1865_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Neka donese svešteniku, a on neka prinese prvo ono što je za greh, i noktom neka mu zaseče glavu k šiji, ali da ne razdvoji. ");
INSERT INTO srp1865_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","I krvlju žrtve za greh neka pokropi strane oltaru; a šta ostane krvi neka se iscedi na podnožje oltaru. To je žrtva za greh. ");
INSERT INTO srp1865_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","A od drugog neka načini žrtvu paljenicu po običaju; tako će ga očistiti sveštenik od greha njegovog, koji je učinio, i oprostiće mu se. ");
INSERT INTO srp1865_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ako li ne bi mogao prineti ni dve grlice ili dva golubiće, onda neka za žrtvu za to što je zgrešio donese desetinu efe belog brašna da bude žrtva za greh, a neka ne dodaje ulja i ne meće kada, jer je žrtva za greh. ");
INSERT INTO srp1865_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","I kad donese k svešteniku, neka uzme sveštenik punu šaku za spomen njen, i neka zapali na oltaru pored žrtve ognjene Gospodu. To je žrtva za greh. ");
INSERT INTO srp1865_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","I očistiće ga sveštenik od greha, kojim se ogrešio u čem god od ovog, i oprostiće mu se; a ostatak će biti svešteniku kao od dara. ");
INSERT INTO srp1865_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Ko se prevari, te se ogreši nehotice o stvari posvećene Gospodu, neka prinese na žrtvu Gospodu za prestup svoj ovna zdravog s cenom, kojom ti proceniš svetu stvar na sikle srebrne, po siklima svetim, prema prestupu. ");
INSERT INTO srp1865_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","I tako koliko se ogrešio o svetu stvar neka naknadi, i na to još neka dometne peti deo, i neka da svešteniku; a sveštenik će ga očistiti ovnom prinesenim na žrtvu za prestup, i oprostiće mu se. ");
INSERT INTO srp1865_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ko zgreši i učini štagod što je Gospod zabranio da se ne čini, ako i nije znao, ipak je kriv, i nosiće svoje bezakonje. ");
INSERT INTO srp1865_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Neka dovede k svešteniku ovna zdravog s cenom kojom proceniš prestup; i očistiće ga sveštenik od greha njegovog, koji je učinio ne znajući, i oprostiće mu se. ");
INSERT INTO srp1865_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Prestup je; zgrešio je Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Kad ko zgreši i učini zlo delo Gospodu udarivši u bah bližnjemu svom za ostavu ili za stvar predanu u ruke ili otevši šta ili zanesavši bližnjeg svog, ");
INSERT INTO srp1865_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ili nađe izgubljeno šta, pa udari u bah, ili se krivo zakune za koju god stvar koju može čovek učiniti i ogrešiti se njom, ");
INSERT INTO srp1865_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","kad tako zgreši i skrivi, neka vrati šta je oteo ili prisvojio prevarom ili šta mu je bilo dano na ostavu ili šta je izgubljeno našao, ");
INSERT INTO srp1865_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ili za šta se zakleo krivo, neka plati celo i još dometne peti deo onome čije je; neka mu da onaj dan kad prinese žrtvu za svoj greh. ");
INSERT INTO srp1865_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","A na žrtvu za greh svoj neka prinese Gospodu ovna zdravog, sa cenom kojom proceniš krivicu neka ga dovede svešteniku. ");
INSERT INTO srp1865_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","I očistiće ga sveštenik pred Gospodom, i oprostiće mu se svaka stvar koju je učinio, te skrivio. ");
INSERT INTO srp1865_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Zapovedi Aronu i sinovima njegovim, i reci im: Ovo je zakon za žrtvu paljenicu: žrtva paljenica neka stoji na ognju na oltaru celu noć do jutra, i oganj na oltaru neka gori jednako. ");
INSERT INTO srp1865_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Sveštenik neka obuče svoju haljinu lanenu, i gaće lanene neka obuče na telo svoje, i neka zgrne pepeo kad oganj spali na oltaru žrtvu paljenicu, i neka ga izruči kod oltara. ");
INSERT INTO srp1865_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Potom neka svuče haljine svoje i obuče druge haljine, i neka iznese pepeo napolje iz logora na čisto mesto. ");
INSERT INTO srp1865_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","A oganj što je na oltaru neka gori na njemu, neka se ne gasi, nego neka sveštenik loži na oganj drva svako jutro, i neka namešta na nj žrtvu paljenicu, i neka pali na njemu salo od žrtava zahvalnih. ");
INSERT INTO srp1865_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Oganj neka jednako gori na oltaru, neka se ne gasi. ");
INSERT INTO srp1865_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","A ovo je zakon za dar: sinovi Aronovi neka ga prinose Gospodu pred oltarom. ");
INSERT INTO srp1865_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Uzevši šaku belog brašna i ulja od dara i sav kad koji bude na daru, neka zapali na oltaru spomen njegov na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","A šta preteče, neka jede Aron i sinovi njegovi; neka se jede bez kvasca na svetom mestu; u tremu šatora od sastanka neka jedu. ");
INSERT INTO srp1865_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Neka se ne mesi sa kvascem; to im dadoh da im bude deo od žrtava mojih ognjenih; to je svetinja nad svetinjama kao žrtva za greh i kao žrtva za prestup. ");
INSERT INTO srp1865_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Svako muško između sinova Aronovih neka to jede zakonom večnim od kolena do kolena od žrtava koje se pale Gospodu; šta se god dotakne toga, biće sveto. ");
INSERT INTO srp1865_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Ovo je žrtva Aronova i sinova njegovih, koju će prinositi Gospodu onaj dan kad se koji pomaže: desetinu efe belog brašna za dar svagdašnji, polovinu ujutru a polovinu uveče. ");
INSERT INTO srp1865_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","U tavi s uljem neka se gotovi; prženo neka se donese; i pržene komade dara neka prinese na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","I sveštenik između sinova njegovih, koji bude pomazan nakon njega, neka čini tako isto zakonom večnim; neka se pali Gospodu sve to; ");
INSERT INTO srp1865_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","i svaki dar sveštenikov neka se sav spali, a neka se ne jede. ");
INSERT INTO srp1865_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Kaži Aronu i sinovima njegovim, i reci: Ovo je zakon za žrtvu radi greha: na mestu gde se kolje žrtva paljenica, neka se kolje i žrtva za greh pred Gospodom; svetinja je nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Sveštenik koji prinese žrtvu za greh neka je jede; na svetom mestu neka se jede, u tremu od šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Šta se god dotakne mesa njenog, biće sveto; i ako ko pokapa krvlju njenom haljinu, ono što pokapa neka opere na svetom mestu. ");
INSERT INTO srp1865_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","I sud zemljani u kome bude kuvano neka se razbije; ako li je kuvano u sudu bronzanom, neka se istre i vodom opere. ");
INSERT INTO srp1865_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Svako muško između sveštenika neka to jede; svetinja je nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ali nijedna žrtva za greh, od koje se unese krv u šator od sastanka da se učini očišćenje od greha u svetinji, neka se ne jede, nego neka se ognjem sažeže. ");
INSERT INTO srp1865_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","A ovo je zakon za žrtvu radi prestupa; svetinja je nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Na kome se mestu kolje žrtva paljenica, na onom neka se kolje i žrtva za prestup; i krvlju njenom neka se pokropi oltar odozgo unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","A sve salo njeno neka se prinese, i rep i salo što pokriva creva, ");
INSERT INTO srp1865_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","i oba bubrega, i salo što je na njima i na slabinama, i mrežicu na jetri neka izvadi s bubrezima, ");
INSERT INTO srp1865_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","i neka zapali to sveštenik na oltaru na žrtvu ognjenu Gospodu; to je žrtva za prestup. ");
INSERT INTO srp1865_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Svako muško između sveštenika neka je jede; na svetom mestu neka se jede; svetinja je nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Žrtva je za prestup kao žrtva za greh, jedan je zakon za obe; koji sveštenik učini njom očišćenje, njegova je. ");
INSERT INTO srp1865_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","A kad sveštenik prinese čiju žrtvu paljenicu, koža od žrtve koju prinese njegova je. ");
INSERT INTO srp1865_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","I svaki dar pečen u peći ili zgotovljen u kotliću ili u tavi, onog je sveštenika koji ga prinese. ");
INSERT INTO srp1865_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","I svaki dar zamešen s uljem ili suv, svih je sinova Aronovih, kako jednog tako drugog. ");
INSERT INTO srp1865_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","A ovo je zakon za žrtvu zahvalnu, koja se prinese Gospodu: ");
INSERT INTO srp1865_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ako bi je ko prinosio da zahvali, neka prinese na žrtvu zahvalnu kolače bez kvasca zamešene s uljem i pogače bez kvasca namazane uljem, i belog brašna poprženog s tim kolačima zamešenim s uljem. ");
INSERT INTO srp1865_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Osim kolača hleb kiseli neka prinese za prinos svoj sa žrtvom zahvalnom, kojom zahvaljuje. ");
INSERT INTO srp1865_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","I od svega što prinosi neka prinese po jedno za žrtvu podignutu Gospodu; i to će biti onog sveštenika koji pokropi krvlju od žrtve zahvalne. ");
INSERT INTO srp1865_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","A meso od žrtve zahvalne, kojom se zahvaljuje, neka se pojede onaj dan kad se prinese; i neka ne ostaje ništa do jutra. ");
INSERT INTO srp1865_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ako li prinese žrtvu radi zaveta ili od volje, neka se jede onaj dan kad se prinese; ako šta ostane, neka se pojede sutradan. ");
INSERT INTO srp1865_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ako li šta mesa od te žrtve ostane do trećeg dana, neka se sažeže ognjem. ");
INSERT INTO srp1865_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ako li bi ko treći dan jeo mesa od žrtve zahvalne, neće biti ugodan onaj koji je prineo, niti će mu se ona primiti, nego će biti mrska, i ko bi je god jeo, nosiće greh svoj. ");
INSERT INTO srp1865_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","I meso koje bi se dotaklo čega nečistog, da se ne jede, nego neka se sažeže ognjem; a drugo meso može jesti ko je god čist. ");
INSERT INTO srp1865_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","A ko bi jeo mesa od žrtve zahvalne prinesene Gospodu, a ne bi bio čist, taj da se istrebi iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","I ko se dotakne čega nečistog, ili nečistog čoveka ili nečistog živinčeta, ili kog mu drago gada nečistog, pa jede mesa od žrtve zahvalne prinesene Gospodu, taj da se istrebi iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Kaži sinovima Izrailjevim, i reci: Ne jedite salo od vola ni od ovce ni od koze. ");
INSERT INTO srp1865_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Može se uzeti za svaku potrebu salo od živinčeta koje crkne ili ga zverka razdre; ali ga ne jedite; ");
INSERT INTO srp1865_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ko li bi jeo salo od stoke koju prinosi čovek na žrtvu ognjenu Gospodu, neka se istrebi iz naroda svog onaj koji jede. ");
INSERT INTO srp1865_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ni krv ne jedite u stanovima svojim ni od ptice niti od kog živinčeta. ");
INSERT INTO srp1865_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Svaki koji bi jeo kakvu krv, neka se istrebi iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Kaži sinovima Izrailjevim, i reci: Ko prinosi žrtvu svoju zahvalnu Gospodu, neka donese Gospodu prinos svoj od žrtve zahvalne. ");
INSERT INTO srp1865_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Svojim rukama neka donese šta se sažiže Gospodu, salo s grudima neka donese, i grudi neka se obrnu tamo i amo na žrtvu pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","A sveštenik neka zapali salo na oltaru, grudi pak neka budu Aronu i sinovima njegovim. ");
INSERT INTO srp1865_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","I desno pleće od svojih žrtava zahvalnih podajte svešteniku da bude žrtva podignuta. ");
INSERT INTO srp1865_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","A koji između sinova Aronovih prinese krv i salo od žrtve zahvalne, njemu neka bude desno pleće. ");
INSERT INTO srp1865_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Jer grudi što se obrću i pleće što se podiže uzeh od sinova Izrailjevih od svih njihovih žrtava zahvalnih, i dadoh Aronu svešteniku i sinovima njegovim zakonom večnim da se uzimaju od sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","To je pomazanog Arona i pomazanih sinova njegovih od ognjenih žrtava Gospodnjih od dana kad ih dovede da vrše službu svešteničku Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","To zapovedi Gospod da im od dana kad ih pomaza daju sinovi Izrailjevi zakonom večnim od kolena na koleno. ");
INSERT INTO srp1865_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","To je zakon za žrtvu paljenicu, za dar, za žrtvu radi greha i za žrtvu radi prestupa, i za osveštanje i za žrtvu zahvalnu, ");
INSERT INTO srp1865_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","što je Gospod zapovedio Mojsiju na gori sinajskoj kad zapovedi sinovima Izrailjevim u pustinji sinajskoj da prinose žrtve svoje Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Uzmi Arona i sinove njegove s njim i odelo i ulje pomazanja i tele za žrtvu radi greha i dva ovna i kotaricu presnih hlebova. ");
INSERT INTO srp1865_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","I saberi sav zbor pred vrata šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","I učini Mojsije kako mu zapovedi Gospod, i sabra se zbor pred vrata šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","I reče Mojsije zboru: Ovo je zapovedio Gospod da se učini. ");
INSERT INTO srp1865_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","I dovede Mojsije Arona i sinove njegove, i opra ih vodom. ");
INSERT INTO srp1865_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","I obuče mu košulju, i opasa ga pojasom, i ogrnu ga plaštom, i metnu mu svrh njega oplećak, i steže oko njega pojas od oplećka, i opasa ga njim. ");
INSERT INTO srp1865_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","I metnu na nj naprsnik, a na naprsnik metnu Urim i Tumim. ");
INSERT INTO srp1865_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Još mu metnu kapu na glavu, i na kapu metnu spred ploču zlatnu, krunu svetu, kao što zapovedi Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","I uze Mojsije ulje pomazanja, i pomaza šator i sve stvari u njemu, i osveti ih. ");
INSERT INTO srp1865_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","I pokropi njim oltar sedam puta, i pomaza oltar i sve sprave njegove, i umivaonicu i podnožje njeno, da se osveti. ");
INSERT INTO srp1865_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","I izli ulje pomazanja na glavu Aronu, i pomaza ga da se osveti. ");
INSERT INTO srp1865_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","I dovede Mojsije sinove Aronove, i obuče im košulje, i opasa ih pojasom, i veza im kapice na glave, kao što mu beše zapovedio Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","I dovede tele za greh, i Aron i sinovi njegovi metnuše ruke svoje na glavu teletu za greh. ");
INSERT INTO srp1865_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","I zakla ga Mojsije, i uzevši krvi njegove pomaza rogove oltaru unaokolo prstom svojim, i očisti oltar, a ostalu krv izli na podnožje oltaru, i osveti ga da se na njemu čini očišćenje od greha. ");
INSERT INTO srp1865_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","I uze sve salo što je na crevima, i mrežicu s jetre, i oba bubrega, i salo oko njih, i zapali Mojsije na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","A tele s kožom i s mesom i balegom spali ognjem iza logora, kao što beše Gospod zapovedio Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","I dovede ovna za žrtvu paljenicu, i Aron i sinovi njegovi metnuše ruke svoje na glavu ovnu; ");
INSERT INTO srp1865_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","i zakla ga Mojsije, i pokropi krvlju njegovom oltar odozgo unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","I isekavši ovna na delove zapali Mojsije glavu i delove i salo. ");
INSERT INTO srp1865_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","A creva i noge opra vodom, i tako spali Mojsije svega ovna na oltaru; i bi žrtva paljenica za ugodni miris, žrtva ognjena Gospodu, kao što beše Gospod zapovedio Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","I dovede drugog ovna, ovna za posvećenje; i Aron i sinovi njegovi metnuše ruke svoje na glavu ovnu. ");
INSERT INTO srp1865_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","I zaklavši ga Mojsije uze krvi njegove, i pomaza njom kraj desnog uha Aronu i palac desne ruke njegove i palac desne noge njegove. ");
INSERT INTO srp1865_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","I dovede Mojsije sinove Aronove, pa i njima pomaza istom krvlju kraj desnog uha i palac desne ruke i palac desne noge; a ostalu krv izli Mojsije po oltaru unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Potom uze salo i rep i sve salo što je na crevima, i mrežicu s jetre, i oba bubrega, i salo oko njih, i pleće desno, ");
INSERT INTO srp1865_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","a iz kotarice u kojoj stajahu presni hlebovi pred Gospodom uze jedan kolač presan i jedan kolač hleba s uljem i jednu pogaču, i metnu na salo i na pleće desno. ");
INSERT INTO srp1865_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","I metnu to sve Aronu u ruke, i sinovima njegovim u ruke, i obrnu tamo i amo za žrtvu obrtanu pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Posle uzevši to iz ruku njihovih Mojsije zapali na oltaru svrh žrtve paljenice; to je posvećenje na ugodni miris, žrtva ognjena Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","I uze Mojsije grudi, i obrnu ih tamo i amo za žrtvu obrtanu pred Gospodom; i od ovna posvetnog dopade Mojsiju deo, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","I uze Mojsije ulja za pomazanje i krvi koja beše na oltaru, i pokropi Arona i haljine njegove, i sinove njegove i haljine njihove s njim; i tako posveti Arona i haljine njegove, i sinove njegove i haljine njihove s njim. ");
INSERT INTO srp1865_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Potom reče Mojsije Aronu i sinovima njegovim: Kuvajte to meso na vratima šatora od sastanka, i onde ga jedite i hleb posvetni što je u kotarici, kao što sam zapovedio rekavši: Aron i sinovi njegovi neka jedu to. ");
INSERT INTO srp1865_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","A šta ostane mesa ili hleba, ognjem sažezite. ");
INSERT INTO srp1865_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","I ne izlazite s vrata šatora od sastanka sedam dana, dokle se ne navrše dani posvećenja vašeg, jer ćete se sedam dana posvećivati. ");
INSERT INTO srp1865_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Kako je bilo danas, tako je Gospod zapovedio da se čini, da biste se očistili od greha. ");
INSERT INTO srp1865_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Zato na vratima šatora od sastanka ostanite danju i noću za sedam dana, i izvršite šta je Gospod zapovedio da izvršite, da ne pomrete, jer mi je tako zapoveđeno. ");
INSERT INTO srp1865_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","I Aron i sinovi njegovi učiniše sve što beše Gospod zapovedio preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","A u osmi dan sazva Mojsije Arona i sinove njegove i starešine izrailjske. ");
INSERT INTO srp1865_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","I reče Aronu: Uzmi tele za žrtvu radi greha i ovna za žrtvu paljenicu, oba zdrava; i prinesi ih pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","A sinovima Izrailjevim kaži i reci: Uzmite jare za žrtvu radi greha, i tele i jagnje, oboje od godine dana, i zdravo, za žrtvu paljenicu. ");
INSERT INTO srp1865_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","I vola i ovna za žrtvu zahvalnu, da prinesete pred Gospodom, i dar s uljem zamešen, jer će vam se danas javiti Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","I uzeše šta zapovedi Mojsije, i donesoše pred šator od sastanka, i pristupivši sav zbor stadoše pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","I reče Mojsije: Učinite šta je zapovedio Gospod, i pokazaće vam se slava Gospodnja. ");
INSERT INTO srp1865_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","I reče Mojsije Aronu: Pristupi k oltaru, i prinesi žrtvu za greh svoj i žrtvu svoju paljenicu, i očisti od greha sebe i narod; i prinesi žrtvu narodnu i očisti ih od greha, kao što je zapovedio Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Tada Aron pristupi k oltaru i zakla tele za se. ");
INSERT INTO srp1865_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","I sinovi Aronovi dodaše mu krv, a on zamoči prst svoj u krv, i pomaza rogove oltaru; a ostalu krv izli na podnožje oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A salo i bubrege i mrežicu od jetre od žrtve za greh zapali na oltaru, kao što beše zapovedio Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","A meso i kožu sažeže ognjem iza logora. ");
INSERT INTO srp1865_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Potom zakla žrtvu svoju paljenicu, i sinovi Aronovi dodaše mu krv od nje, i pokropi njom oltar odozgo unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","I dodaše mu žrtvu paljenicu isečenu na delove zajedno s glavom, i zapali je na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","I opravši creva i noge od nje, zapali ih na oltaru svrh žrtve paljenice. ");
INSERT INTO srp1865_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Potom prinese žrtvu narodnu: uze jare za greh koje beše za narod, i zakla ga, i prinese za greh kao i prvo. ");
INSERT INTO srp1865_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Iza toga prinese i žrtvu paljenicu, i svrši po zakonu. ");
INSERT INTO srp1865_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Prinese i dar, i uzevši od njega punu šaku zapali na oltaru svrh jutarnje žrtve paljenice. ");
INSERT INTO srp1865_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Potom zakla vola i ovna na žrtvu zahvalnu za narod; i dadoše mu sinovi Aronovi krv, i pokropi njom oltar odozgo unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Pa mu dodaše i salo od vola, i od ovna rep, i salo što pokriva creva, i bubrege i mrežicu s jetre, ");
INSERT INTO srp1865_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","i metnuvši sve salo na grudi, i zapali salo na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","A grudi i desno pleće obrnu Aron tamo i amo na žrtvu obrtanu pred Gospodom, kao što beše Gospod zapovedio Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Tada podiže Aron ruke svoje prema narodu, i blagoslovi ih; i siđe svršivši žrtvu za greh i žrtvu paljenicu i žrtvu zahvalnu. ");
INSERT INTO srp1865_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Potom uđe Mojsije s Aronom u šator od sastanka, a kad opet izađoše blagosloviše narod; i slava se Gospodnja pokaza svemu narodu. ");
INSERT INTO srp1865_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Jer dođe oganj od Gospoda, i spali na oltaru žrtvu paljenicu i salo. I videvši to sav narod povika i pade ničice. ");
INSERT INTO srp1865_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","A sinovi Aronovi, Nadav i Avijud, uzevši svaki svoju kadionicu metnuše oganj u njih i na oganj metnuše kad, i prinesoše pred Gospodom oganj tuđ, a to im ne beše zapovedio. ");
INSERT INTO srp1865_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Tada dođe oganj od Gospoda i udari ih, te pogiboše pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Tada reče Mojsije Aronu: To je što je kazao Gospod govoreći: U onima koji pristupaju k meni biću svet i pred celim narodom proslaviću se. A Aron oćute. ");
INSERT INTO srp1865_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","A Mojsije pozva Misaila i Elisafana sinove Ozila strica Aronovog, i reče im: Hodite i iznesite braću svoju ispred svetinje napolje iz logora. ");
INSERT INTO srp1865_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","I pristupiše i iznesoše ih u košuljama njihovim napolje iz logora, kao što reče Mojsije. ");
INSERT INTO srp1865_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Tada reče Mojsije Aronu i Eleazaru i Itamaru, sinovima njegovim: Nemojte otkrivati glava svojih, ni haljina svojih razdirati, da ne izginete i da se Gospod ne razgnevi na sav zbor; nego braća vaša, sav rod Izrailjev, neka plače radi požara koji učini Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","I s vrata šatora od sastanka nemojte izlaziti, da ne izginete, jer je na vama ulje pomazanja Gospodnjeg. I učiniše po reči Mojsijevoj. ");
INSERT INTO srp1865_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","I Gospod reče Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Vino i silovito piće nemoj piti ti ni sinovi tvoji s tobom, kad ulazite u šator od sastanka da ne izginete. To neka vam je uredba večna od kolena na koleno. ");
INSERT INTO srp1865_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Da biste mogli raspoznavati šta je sveto šta li nije, i šta je čisto šta li nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","I da biste učili sinove Izrailjeve svim uredbama koje im je kazao Gospod preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","A Mojsije reče Aronu i Eleazaru i Itamaru sinovima njegovim koji ostaše: Uzimajte dar što ostane od ognjenih žrtava Gospodnjih, i jedite s hlebom presnim kod oltara, jer je svetinja nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Zato ćete ga jesti na svetom mestu, jer je deo tvoj i deo sinova tvojih od ognjenih žrtava Gospodnjih; jer mi je tako zapoveđeno. ");
INSERT INTO srp1865_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","A grudi od žrtve obrtane i pleće od žrtve podizane jedite na čistom mestu, ti i sinovi tvoji i kćeri tvoje s tobom; jer je taj deo dan tebi i sinovima tvojim od zahvalnih žrtava sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Pleće od žrtve podizane i grudi od žrtve obrtane donosiće se sa salom što se sažiže, da se obrne tamo i amo pred Gospodom, i biće tvoje i sinova tvojih s tobom zakonom večnim, kao što je zapovedio Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","I Mojsije potraži jare za greh; ali gle, beše izgorelo; zato se razgnevi na Eleazara i na Itamara sinove Aronove koji ostaše, i reče: ");
INSERT INTO srp1865_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Zašto ne jedoste žrtve za greh na svetom mestu? Svetinja je nad svetinjama, i dade vam je Gospod da nosite greh svega zbora, da bi se očistili od greha pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","A eto krv njena nije unesena u svetinju; valjaše vam je jesti na svetom mestu, kao što sam zapovedio. ");
INSERT INTO srp1865_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Tada reče Aron Mojsiju: Eto, danas prinesoše žrtvu svoju za greh i žrtvu svoju paljenicu pred Gospodom, i to mi se dogodi. A da sam danas jeo žrtve za greh, bi li bilo po volji Gospodu? ");
INSERT INTO srp1865_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Kad ču to Mojsije, prista na to. ");
INSERT INTO srp1865_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","I reče Gospod Mojsiju i Aronu govoreći im: ");
INSERT INTO srp1865_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Kažite sinovima Izrailjevim i recite: Ovo su životinje koje ćete jesti između svih životinja na zemlji: ");
INSERT INTO srp1865_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Šta god ima papke i papci su mu razdvojeni i preživa između životinja, to jedite. ");
INSERT INTO srp1865_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ali onih što samo preživaju ili što samo imaju papke razdvojene, ne jedite, kao što je kamila, jer preživa ali nema papke razdvojene; da vam je nečista; ");
INSERT INTO srp1865_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","i pitomi zec, jer preživa ali nema papke razdvojene; nečist da vam je. ");
INSERT INTO srp1865_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","I zec divlji, jer preživa ali nema papke razdvojene; nečist da vam je. ");
INSERT INTO srp1865_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","I svinja, jer ima papke razdvojene ali ne preživa; nečista da vam je; ");
INSERT INTO srp1865_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","mesa od njih ne jedite niti se strva njihovog dodevajte; jer vam je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","A između svega što je u vodi ovo jedite: Šta god ima pera i ljusku u vodi, po moru i po rekama, jedite. ");
INSERT INTO srp1865_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","A šta nema pera i ljusku u moru i u rekama između svega što se miče po vodi i živi u vodi, da vam je gadno. ");
INSERT INTO srp1865_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Gadno da vam je, mesa da im ne jedete, i na strv njihov da se gadite. ");
INSERT INTO srp1865_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Šta god nema pera i ljuske u vodi, to da vam je gadno. ");
INSERT INTO srp1865_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","A između ptica ove da su vam gadne i da ih ne jedete: orao i jastreb i morski orao, ");
INSERT INTO srp1865_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","eja i kraguj po svojim vrstama, ");
INSERT INTO srp1865_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","i svaki gavran po svojim vrstama, ");
INSERT INTO srp1865_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","i sovuljaga i ćuk i liska i kobac po svojim vrstama, ");
INSERT INTO srp1865_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","i buljina i gnjurac i ušara, ");
INSERT INTO srp1865_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","i labud i gem i svraka, ");
INSERT INTO srp1865_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","i roda i čaplja po svim vrstama, i pupavac i ljiljak. ");
INSERT INTO srp1865_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Šta god gamiže, a ima krila i ide na četiri noge, da vam je gadno. ");
INSERT INTO srp1865_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ali između svega što gamiže a ima krila i ide na četiri noge jedite šta ima stegna na nogama svojim, kojima skače po zemlji. ");
INSERT INTO srp1865_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Između njih jedite ove: arba po vrstama njegovim, salema po vrstama njegovim, argola po vrstama njegovim i agava po vrstama njegovim. ");
INSERT INTO srp1865_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","A što gamiže, a ima krila i četiri noge, da vam je gadno. ");
INSERT INTO srp1865_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","I o njih ćete se oskvrniti; ko se god dotakne mrtvog tela njihovog, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","I ko bi god nosio mrtvo telo njihovo, neka opere haljine svoje, i da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Svaka životinja koja ima papke ali nerazdvojene i ne preživa, da vam je nečista; ko ih se god dotakne, da je nečist. ");
INSERT INTO srp1865_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","I šta god ide na šapama između svih životinja četvoronožnih, da vam je nečisto; ko bi se dotakao strva njihovog, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","I ko bi nosio strv njihov, neka opere haljine svoje, i da je nečist do večera; to da vam je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","I između životinja koje pužu po zemlji da su vam nečiste: lasica i miš i kornjača po vrstama svojim, ");
INSERT INTO srp1865_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","i jež i gušter i tvor i puž i krtica. ");
INSERT INTO srp1865_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","To vam je nečisto između životinja koje pužu; ko ih se dotakne mrtvih, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","I svaka stvar na koju padne koje od njih mrtvo biće nečista, bila sprava drvena ili haljina ili koža ili torba, i svaka stvar koja treba za kakav posao, neka se metne u vodu, i da je nečista do večera, posle da je čista. ");
INSERT INTO srp1865_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","A svaki sud zemljani, u koji padne šta od toga, i šta god u njemu bude, biće nečist, i razbijte ga. ");
INSERT INTO srp1865_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","I svako jelo što se jede, ako na njega dođe onakva voda, da je nečisto, i svako piće što se pije u svakom takvom sudu, da je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","I na šta bi palo šta od tela njihovog mrtvog sve da je nečisto, i peć i ognjište da se razvali, jer je nečisto i neka vam je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","A studenac i ubao, gde se voda skuplja, biće čist; ali šta se dotakne strva njihovog, biće nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ako li šta od strva njihovog padne na seme, koje se seje, ono će biti čisto. ");
INSERT INTO srp1865_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ali ako bude polito seme vodom, pa onda padne šta od strva njihovog na seme, da vam je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","I kad ugine životinja od onih koje jedete, ko se dotakne strva njenog, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","A ko bi jeo od strva njenog, neka opere haljine svoje i da je nečist do večera; i ko bi odneo strv njen, neka opere haljine svoje, i da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","I sve što puže po zemlji, da vam je gadno, da se ne jede. ");
INSERT INTO srp1865_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Šta god ide na trbuhu i šta god ide na četiri noge ili ima više nogu između svega što puže po zemlji, to ne jedite, jer je gad. ");
INSERT INTO srp1865_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nemojte se poganiti ničim što gamiže i nemojte se skvrniti njima, da ne budete nečisti s njih. ");
INSERT INTO srp1865_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Jer ja sam Gospod Bog vaš; zato se osvećujte i budite sveti, jer sam ja svet; i nemojte se skvrniti ničim što puže po zemlji. ");
INSERT INTO srp1865_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Jer ja sam Gospod, koji sam vas izveo iz zemlje misirske da vam budem Bog; budite, dakle, sveti, jer sam ja svet. ");
INSERT INTO srp1865_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ovo je zakon za zveri i za ptice, i za sve životinje što se miču po vodi, i za svaku dušu živu, koja puže po zemlji. ");
INSERT INTO srp1865_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Da se raspoznaje nečisto od čistog i životinja koja se jede od životinje koja se ne jede. ");
INSERT INTO srp1865_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Kaži sinovima Izrailjevim, i reci: Kad žena zatrudni i rodi muško, nečista da je sedam dana; kao u dane kad se odvaja radi nemoći svoje, biće nečista. ");
INSERT INTO srp1865_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","A u osmi dan neka se obreže dete. ");
INSERT INTO srp1865_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","A ona još trideset i tri dana neka ostane čisteći se od krvi; ni jedne svete stvari da se ne dodeva i u svetinju da ne ide dok se ne navrše dani čišćenja njenog. ");
INSERT INTO srp1865_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","A kad rodi žensko, onda da je nečista dve nedelje dana, kao kad se odvaja radi nemoći svoje, i šezdeset i šest dana neka ostane čisteći se od krvi. ");
INSERT INTO srp1865_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","A kad se navrše dani čišćenja njenog radi sina ili radi kćeri, neka donese svešteniku na vrata šatora od sastanka jagnje od godine za žrtvu paljenicu, i golupče ili grlicu za žrtvu radi greha. ");
INSERT INTO srp1865_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","I sveštenik će prineti žrtvu pred Gospodom, i očistiće je od greha njenog; i tako će se očistiti od tečenja krvi svoje. To je zakon za ženu kad rodi muško ili žensko. ");
INSERT INTO srp1865_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ako li ne može dati jagnjeta, onda neka uzme dve grlice ili dva golubića, jedno za žrtvu paljenicu a drugo za žrtvu radi greha; i očistiće je sveštenik od greha njenog, i biće čista. ");
INSERT INTO srp1865_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Još reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Čovek u koga bi na koži tela njegovog bio otok ili krasta ili bubuljica, i bilo bi na koži tela njegovog nalik na gubu, neka se dovede k Aronu svešteniku ili ka kome sinu njegovom svešteniku. ");
INSERT INTO srp1865_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","I neka sveštenik vidi boljeticu na koži tela njegovog; ako dlaka na boljetici bude pobelela i boljetica bude na oči niža od ostale kože tela njegovog, onda je guba; pa kad ga vidi sveštenik proglasiće ga da je nečist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ako li bude bela bubuljica na koži tela njegovog i ne bude na oči niža od ostale kože niti dlaka na njoj pobelela, onda neka zatvori sveštenik za sedam dana čoveka sa takvom boljeticom. ");
INSERT INTO srp1865_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","A sedmog dana neka vidi sveštenik; ako opazi da je boljetica ostala kako je bila i nije se dalje razišla po koži, neka ga zatvori sveštenik opet za sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","I neka ga sveštenik opet vidi sedmog dana, pa ako opazi da se boljetica smanjila i nije se dalje razišla po koži; krasta je; i on neka opere haljine svoje i biće čist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ako li se dalje raširi krasta po koži njegovoj, pošto ga sveštenik vidi i proglasi da je čist, nanovo neka se pokaže svešteniku; ");
INSERT INTO srp1865_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ako vidi sveštenik da se krasta raširila po koži njegovoj, proglasiće sveštenik da je nečist; guba je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Kad je guba na čoveku, neka ga dovedu k svešteniku. ");
INSERT INTO srp1865_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","I sveštenik neka ga vidi; ako bude beo otok na koži i dlaka bude pobelela, ako bi i zdravo meso bilo na otoku, ");
INSERT INTO srp1865_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","guba je zastarela na koži tela njegovog; zato će ga sveštenik proglasiti da je nečist, i neće ga zatvoriti, jer je nečist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ako li se guba izaspe po koži i pokrije svu kožu čoveku od glave do pete, gde bi god sveštenik očima pogledao, ");
INSERT INTO srp1865_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kad sveštenik vidi da je guba pokrila svu kožu na njemu, proglasiće da je čovek čist, jer je sve pobelelo, pa je čist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ali ako se pokaže na njemu divlje meso, biće nečist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Pa kad sveštenik vidi divlje meso, proglasiće ga da je nečist; ono je divlje meso nečisto, guba je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","A kad bi se divlje meso promenilo i pobelelo, neka dođe k svešteniku. ");
INSERT INTO srp1865_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","I kad vidi sveštenik da je boljetica pobelela, sveštenik će proglasiti da je čist, čist je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kad u koga na koži bude čir, pa prođe, ");
INSERT INTO srp1865_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","a posle na mestu gde je bio čir izađe otok beo ili bubuljica bela i crvenkasta, neka se pokaže svešteniku. ");
INSERT INTO srp1865_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ako sveštenik vidi da je na oči niža od ostale kože i dlaka na njoj pobelela, proglasiće ga sveštenik da je nečist, guba je, izašla je iz čira. ");
INSERT INTO srp1865_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ako li sveštenik gledajući vidi da nije dlaka na njoj pobelela niti je niža od kože, nego se smanjila, onda će ga zatvoriti sveštenik za sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ako se raširi po koži, onda će ga sveštenik proglasiti da je nečist; bolest je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ako li ostane na svom mestu bubuljica i ne raširi se, ožiljak je od čira; zato će ga sveštenik proglasiti da je čist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ako se ko po koži ožeže ognjem, pa pošto se zaleči ostane bubuljica bela i crvenkasta ili samo bela, ");
INSERT INTO srp1865_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","neka ga vidi sveštenik; ako dlaka na bubuljici bude pobelela i ako na oči bude niža nego koža, guba je, izašla je iz ožegline; zato će ga sveštenik proglasiti da je nečist; guba je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ako li sveštenik vidi da na bubuljici nema bele dlake niti je niža od kože, nego se smanjila, zatvoriće ga za sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pa će je sedmog dana pogledati sveštenik; ako se bude raširila po koži, tada će ga sveštenik proglasiti da je nečist; guba je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ako li bubuljica bude ostala na svom mestu, i ne bude se raširila po koži, nego se smanjila, onda je rana od toga što se ožegao; zato će ga sveštenik proglasiti da je čist, jer je ožiljak od ožegline. ");
INSERT INTO srp1865_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ako u čoveka ili u žene bude boljetica na glavi ili na bradi, ");
INSERT INTO srp1865_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","sveštenik neka vidi boljeticu; ako na oči bude niža od ostale kože i na njoj dlaka žućkasta i tanka, sveštenik će proglasiti da je nečist; ospa je, guba na glavi ili na bradi; ");
INSERT INTO srp1865_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","a kad sveštenik vidi boljeticu, i opazi da na oči nije niža od ostale kože i da nema na njoj crne dlake, tada će zatvoriti sveštenik za sedam dana onog na kome je ospa. ");
INSERT INTO srp1865_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Pa kad sveštenik sedmi dan vidi, a ospa se nije dalje razišla niti dlaka na njoj požutela, niti je na oči ospa niža od kože, ");
INSERT INTO srp1865_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","tada neka se obrije, ali ospu da ne obrije, i sveštenik neka zatvori još za sedam dana onog na kome je ospa. ");
INSERT INTO srp1865_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","I sedmog dana neka sveštenik opet vidi ospu; ako opazi da se ospa nije dalje razišla po koži niti je na oči niža od ostale kože, tada će ga proglasiti sveštenik da je čist, pa neka opere haljine svoje, i biće čist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ako li se raširi ospa po koži, pošto bude proglašen da je čist, ");
INSERT INTO srp1865_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","tada neka ga vidi sveštenik; ako se bude raširila ospa po koži, neka više ne gleda sveštenik ima li žutih dlaka; nečist je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ako li opazi da je ospa ostala gde je bila i da je crna dlaka izrasla po njoj, zalečila se ospa, čist je, i sveštenik će proglasiti da je čist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Kad u čoveka ili u žene budu bubuljice po koži tela njihovog, bubuljice bele, ");
INSERT INTO srp1865_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","sveštenik neka vidi; ako na koži tela njegovog budu bele bubuljice male, bela je ospa, izašla po koži, čist je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Kome opadne kosa s glave, ćelav je, čist je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ako mu spreda opadne kosa s glave, pola je ćelav, i čist je. ");
INSERT INTO srp1865_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kad na glavi sasvim ćelavoj ili pola ćelavoj bude bela i crvenkasta boljetica, guba je, izašla na glavi svoj ćelavoj ili pola ćelavoj. ");
INSERT INTO srp1865_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","I neka ga vidi sveštenik; ako opazi da je beo i crvenkast otok na glavi svoj ćelavoj ili pola ćelavoj nalik na gubu po koži ostalog tela, ");
INSERT INTO srp1865_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","čovek je gubav, nečist je, i sveštenik će ga proglasiti da je nečist; guba mu je na glavi. ");
INSERT INTO srp1865_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","A gubavac na kome je ta bolest, neka ide u haljinama razdrtim i gologlav, i usta neka zastre, i neka viče: Nečist, nečist. ");
INSERT INTO srp1865_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Dokle je god bolest na njemu, neka bude nečist; nečist je, neka živi sam, iza logora neka mu bude stan. ");
INSERT INTO srp1865_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","I ako na haljini bude guba, na haljini vunenoj ili lanenoj, ");
INSERT INTO srp1865_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ili na osnovi ili na poučici od lana ili od vune, ili na koži, ili na čem god od kože, ");
INSERT INTO srp1865_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","i ako boljetica bude zelenkasta ili crvenkasta na haljini ili na koži ili na osnovi ili na poučici ili na čem god od kože, guba je, i neka se pokaže svešteniku. ");
INSERT INTO srp1865_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","I kad vidi sveštenik bolest, neka zatvori za sedam dana stvar na kojoj je guba. ");
INSERT INTO srp1865_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","I sedmog dana ako vidi da se dalje razišla bolest po haljini ili po osnovi ili po poučici ili po koži ili po čemu god od kože, ljuta je guba bolest, ona stvar je nečista. ");
INSERT INTO srp1865_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Zato neka spali onu haljinu ili osnovu ili poučicu od vune ili od lana, ili šta god bude od kože, na čem bude bolest; jer je ljuta guba, ognjem neka se spali. ");
INSERT INTO srp1865_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ako li opazi sveštenik da se bolest nije razišla po haljini ili po osnovi ili po poučici, ili po čemu god od kože, ");
INSERT INTO srp1865_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","tada neka zapovedi sveštenik da se opere ono na čem je bolest, pa onda neka zatvori opet za sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Pa neka vidi sveštenik pošto se opere stvar na kojoj je bolest, i ako opazi da bolest nije promenila boje svoje, ako se i ne bude dalje razišla, stvar je nečista, spali je ognjem; jer je ljuta guba na gornjoj ili na donjoj strani. ");
INSERT INTO srp1865_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ako li vidi sveštenik da se mesto smanjilo pošto je oprano, onda neka otkine od haljine ili od kože ili od osnove ili od poučice. ");
INSERT INTO srp1865_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ako li se opet pokaže na haljini ili na osnovi ili na poučici ili na čem god od kože, guba je koja se širi, ognjem spali ono na čem bude. ");
INSERT INTO srp1865_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","A haljinu ili osnovu ili poučicu ili šta mu drago od kože, kad opereš pa otide s njega ta bolest, operi još jednom, i biće čisto. ");
INSERT INTO srp1865_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ovo je zakon za gubu na haljini vunenoj ili lanenoj, ili na osnovi ili na poučici, ili na čem god od kože, kako se može znati je li šta čisto ili nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Ovo je zakon za gubavca kada se čisti: neka se dovede k svešteniku, ");
INSERT INTO srp1865_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","a sveštenik neka izađe iza logora; i ako vidi da je izlečena guba na gubavcu, ");
INSERT INTO srp1865_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","onda će zapovediti sveštenik onome koji se čisti da uzme dve ptice žive čiste, i drvo kedrovo i crvca i isopa. ");
INSERT INTO srp1865_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","I neka zapovedi sveštenik da se jedna ptica zakolje nad sudom zemljanim nad vodom živom. ");
INSERT INTO srp1865_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Pa neka uzme živu pticu i drvo kedrovo i crvac i isop, i sve to zajedno sa živom pticom neka zamoči u krv od ptice zaklane nad vodom živom. ");
INSERT INTO srp1865_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","I neka pokropi sedam puta onog koji se čisti od gube, i neka ga proglasi da je čist, i neka pusti živu pticu u polje. ");
INSERT INTO srp1865_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Tada koji se čisti neka opere haljine svoje i obrije sve dlake svoje, i neka se okupa u vodi, i biće čist; potom neka uđe u logor, ali da stoji napolju ne ulazeći u svoj šator sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","A u sedmi dan neka obrije sve dlake svoje, glavu i bradu i obrve nad očima, i sve dlake svoje neka obrije, i neka opere haljine svoje, pa neka se okupa u vodi i biće čist. ");
INSERT INTO srp1865_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","A u osmi dan neka uzme dva jagnjeta zdrava i jednu ovcu od godine zdravu i tri desetine efe belog brašna zamešenog s uljem za dar, i jedan log ulja. ");
INSERT INTO srp1865_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","A sveštenik koji ga čisti neka postavi onog koji se čisti zajedno s tim stvarima pred Gospodom na vratima šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","I uzevši sveštenik jedno jagnje neka ga prinese na žrtvu za prestup zajedno s logom ulja, i neka obrne tamo i amo pred Gospodom na žrtvu obrtanu. ");
INSERT INTO srp1865_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","A posle neka zakolje jagnje na mestu gde se kolje žrtva za greh i žrtva paljenica na svetom mestu, jer žrtva za prestup pripada svešteniku kao i žrtva za greh; svetinja je nad svetinjama. ");
INSERT INTO srp1865_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Tada neka sveštenik uzme krvi od žrtve za prestup i pomaže kraj desnog uha onome koji se čisti i palac desne ruke njegove i palac desne noge njegove. ");
INSERT INTO srp1865_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Potom neka uzme sveštenik od loga ulja i nalije na dlan svoj levi. ");
INSERT INTO srp1865_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Pa neka zamoči sveštenik prst od desne ruke svoje u ulje što mu je na levom dlanu, i neka pokropi uljem s prsta svog sedam puta pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","A ostalim uljem što mu je na dlanu neka pomaže sveštenik kraj desnog uha onome koji se čisti, i palac desne ruke njegove i palac desne noge njegove po krvi od žrtve za prestup. ");
INSERT INTO srp1865_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","A šta još ostane od ulja na dlanu svešteniku, onim neka namaže glavu onome koji se čisti, i tako će ga očistiti sveštenik pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Potom neka prinese sveštenik žrtvu za greh, i očistiće onog koji se čisti od svoje nečistote; a posle neka zakolje žrtvu paljenicu. ");
INSERT INTO srp1865_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","I neka prinese sveštenik žrtvu paljenicu zajedno s darom na oltaru; i tako će ga očistiti, i biće čist. ");
INSERT INTO srp1865_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ali ako je siromah, te ne može doneti toliko, onda neka uzme jedno jagnje za žrtvu radi prestupa da se prinese žrtva obrtana za očišćenje njegovo, i jednu desetinu efe belog brašna zamešenog s uljem za dar, i log ulja. ");
INSERT INTO srp1865_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","I dve grlice ili dva golubića, koje može priskrbiti, da bude jedno žrtva za greh a drugo žrtva paljenica. ");
INSERT INTO srp1865_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","I to neka donese u osmi dan svog čišćenja svešteniku na vrata šatora od sastanka pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Tada sveštenik neka uzme jagnje za prestup i log ulja, i to neka sveštenik obrne pred Gospodom za žrtvu obrtanu. ");
INSERT INTO srp1865_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","I neka zakolje jagnje za žrtvu radi prestupa, i uzevši sveštenik krvi od žrtve za prestup neka pomaže kraj desnog uha onome koji se čisti i palac desne ruke njegove i palac desne noge njegove. ");
INSERT INTO srp1865_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","I ulja neka nalije sveštenik na dlan svoj levi, ");
INSERT INTO srp1865_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","pa neka zamoči prst od desne ruke svoje u ulje što mu je na levom dlanu, i neka pokropi uljem s prsta svog sedam puta pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","I uljem što mu je na dlanu neka pomaže sveštenik kraj desnog uha onome koji se čisti, i palac desne ruke njegove i palac desne noge njegove po mestu gde je krv od žrtve za prestup. ");
INSERT INTO srp1865_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","A šta još ostane od ulja na dlanu svešteniku, onim neka namaže glavu onome koji se čisti, i tako će ga očistiti pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Tako neka učini i s jednom grlicom ili golupčetom od onih koje priskrbi. ");
INSERT INTO srp1865_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Šta je priskrbio, jedno će biti žrtva za greh a drugo žrtva paljenica s darom; i tako će sveštenik očistiti pred Gospodom onog koji se čisti. ");
INSERT INTO srp1865_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","To je zakon za gubavca koji ne može priskrbiti sve što treba za očišćenje. ");
INSERT INTO srp1865_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","I reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Kad dođete u zemlju hanansku, koju ću vam ja dati da je vaša, pa kad pustim gubu na koju kuću u zemlji koju ćete držati, ");
INSERT INTO srp1865_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","onda onaj čija je kuća neka dođe i javi svešteniku govoreći: Čini mi se kao da je guba na kući. ");
INSERT INTO srp1865_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","A sveštenik neka zapovedi da se isprazni kuća pre nego on dođe da vidi gubu, da se ne bi oskvrnilo šta je u kući; potom neka dođe sveštenik da vidi kuću. ");
INSERT INTO srp1865_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Pa kad vidi bolest, ako bude bolest na zidovima kućnim kao rupice zelenkaste ili crvenkaste i na oči niže od zida, ");
INSERT INTO srp1865_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","neka izađe sveštenik iz kuće one na vrata kućna, i zatvori kuću za sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Posle opet neka dođe sveštenik u sedmi dan, pa ako vidi da se bolest dalje razišla po zidovima kućnim, ");
INSERT INTO srp1865_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","zapovediće sveštenik da povade kamenje na kome je bolest i da ga bace iza grada na mesto nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","A kuću zapovediće da ostružu iznutra svuda unaokolo, i prah što sastružu da prospu iza grada na mesto nečisto, ");
INSERT INTO srp1865_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","i da uzmu drugo kamenje i uglave na mesto gde je bilo pređašnje kamenje; tako i blato drugo uzevši da oblepe kuću. ");
INSERT INTO srp1865_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ako se povrati bolest i opet izraste po kući, pošto se povadi kamenje i ostruže kuća i nanovo oblepi, ");
INSERT INTO srp1865_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","tada došav sveštenik ako vidi da se bolest razišla po kući, ljuta je guba na kući, nečista je. ");
INSERT INTO srp1865_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Neka se razruši ona kuća, kamenje i drva i sav lep od one kuće, i neka se iznese iza grada na mesto nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","A ko bi ušao u kuću onu dok je zatvorena, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","I ko bi spavao u onoj kući, neka opere haljine svoje; tako i ko bi jeo u onoj kući, neka opere haljine svoje. ");
INSERT INTO srp1865_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ako li sveštenik došav vidi da se nije bolest razišla po kući pošto je kuća nanovo oblepljena, neka proglasi sveštenik da je čista, jer se izlečila bolest. ");
INSERT INTO srp1865_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","I neka uzme da bi se kuća očistila dve ptice i drvo kedrovo i crvca i isopa, ");
INSERT INTO srp1865_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","i neka zakolje jednu pticu nad sudom zemljanim nad vodom živom. ");
INSERT INTO srp1865_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Pa neka uzme drvo kedrovo i isop i crvac i drugu pticu živu, i neka zamoči u krv od zaklane ptice i u vodu živu, i pokropi kuću sedam puta. ");
INSERT INTO srp1865_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","I tako će očistiti kuću onu krvlju ptičijom i vodom živom i pticom živom i drvetom kedrovim i isopom i crvcem. ");
INSERT INTO srp1865_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Pa onda neka pusti pticu živu iza grada u polje; i očistiće kuću, i biće čista. ");
INSERT INTO srp1865_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ovo je zakon za svaku gubu i za ospu, ");
INSERT INTO srp1865_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","za gubu na haljini i na kući, ");
INSERT INTO srp1865_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","i za otok i za krastu i za bubuljicu, ");
INSERT INTO srp1865_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","da se zna kad je ko nečist i kad je ko čist. To je zakon za gubu. ");
INSERT INTO srp1865_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Još reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Kažite sinovima Izrailjevim i recite im: Kome čoveku teče seme od tela njegovog, nečist je. ");
INSERT INTO srp1865_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","A ovakva je nečistota njegova od tog tečenja: ako ispusti telo njegovo tečenje svoje, ili se ustavi tečenje u telu njegovom, nečistota je na njemu. ");
INSERT INTO srp1865_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Svaka postelja na koju legne onaj kome teče seme, da je nečista; i sve na šta sedne, da je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","I ko se god dotakne postelje njegove, neka opere haljine svoje i neka se okupa u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","I ko sedne na ono na čemu je sedeo onaj kome teče seme, neka opere haljine svoje i neka se okupa u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","I ko se dotakne tela onog kome teče seme, neka opere haljine svoje i neka se okupa u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","I ako onaj kome teče seme pljune na čistog, on neka opere haljine svoje i neka se okupa u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","I svako sedlo na kome bi sedeo onaj kome teče seme, da je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","I ko bi se dotakao čega god što je bilo pod njim, da je nečist do večera; i ko bi šta takvo nosio, neka opere haljine svoje i okupa se u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","I koga bi se dotakao onaj kome teče seme ne opravši ruku svojih vodom, neka opere haljine svoje i okupa se u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","I sud zemljani kog bi se dotakao onaj kome teče seme, neka se razbije, a drveni sud neka se opere vodom. ");
INSERT INTO srp1865_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","A kad se onaj kome teče seme očisti od tečenja svog, neka broji sedam dana pošto se očisti, i neka opere haljine svoje i neka telo svoje opere vodom živom, i biće čist. ");
INSERT INTO srp1865_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","A u osmi dan neka uzme dve grlice ili dva golubića, i neka dođe pred Gospoda na vrata šatora od sastanka, i neka ih da svešteniku. ");
INSERT INTO srp1865_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","I sveštenik neka prinese jedno od njih na žrtvu za greh a drugo na žrtvu paljenicu; tako će ga očistiti sveštenik pred Gospodom od tečenja njegovog. ");
INSERT INTO srp1865_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","I čovek kome izađe seme kad spava sa ženom neka opere vodom celo telo svoje, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","I svaka haljina i svaka koža na kojoj bude takvo seme, neka se opere vodom i biće nečisto do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","I žena kod koje bude spavao takav čovek, i ona i on neka se okupaju u vodi i biće nečisti do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","A žena kad ima vreme, kad ide krv od tela njenog, neka se odvaja sedam dana, i ko je se god dotakne, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","I na šta god legne dok se odvaja, da je nečisto, i na šta god sedne, da je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","I ko se dotakne postelje njene, neka opere haljine svoje i neka se okupa u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","I ko se dotakne čega na čemu je ona sedela, neka opere haljine svoje i neka se okupa u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","I šta bi god bilo na postelji njenoj ili na čem je ona sedela, pa se ko dotakne toga, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","A ko bi spavao s njom te bi nečistota njena došla na nj, da je nečist sedam dana, i postelja na kojoj leži da je nečista. ");
INSERT INTO srp1865_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","A žena, od koje bi išla krv dugo vremena ili osim običnog vremena ili u obično vreme, ali duže, dokle god teče nečistota njena biće nečista kao u vreme kada se odvaja. ");
INSERT INTO srp1865_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Postelja na kojoj leži dokle joj god krv ide, da joj je kao postelja kad se odvaja; i na čem bi god sedela da je nečisto kao što je nečisto kad se odvaja. ");
INSERT INTO srp1865_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","I ko se god dotakne tih stvari, nečist je; zato neka opere haljine svoje i okupa se u vodi, i biće nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","A kad se očisti od tečenja krvi svoje, neka broji sedam dana, pa onda da je čista. ");
INSERT INTO srp1865_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","I u osmi dan neka uzme dve grlice ili dva golubića, i neka ih odnese svešteniku na vrata šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","I neka sveštenik prinese jedno na žrtvu za greh a drugo na žrtvu paljenicu, i očistiće je sveštenik pred Gospodom od tečenja nečistote njene. ");
INSERT INTO srp1865_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Tako ćete odlučivati sinove Izrailjeve od nečistota njihovih, da ne ginu s nečistota svojih skvrneći šator moj što je usred njih. ");
INSERT INTO srp1865_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","To je zakon za onog kome teče seme i kome izađe seme kad spava sa ženom te bude nečist, ");
INSERT INTO srp1865_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","i za ženu kad boluje od tečenja krvi svoje, i za svakog koji boluje od tečenja svog, bilo muško ili žensko, i za čoveka koji bi ležao sa nečistom. ");
INSERT INTO srp1865_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","I reče Gospod Mojsiju pošto pogiboše dva sina Aronova, a pogiboše kad pristupiše pred Gospoda, ");
INSERT INTO srp1865_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","i kaza Gospod Mojsiju: Reci Aronu, bratu svom, da ne ulazi u svako doba u svetinju za zaves pred zaklopac koji je na kovčegu, da ne pogine, jer ću se u oblaku nad zaklopcem javljati. ");
INSERT INTO srp1865_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","S ovim neka ulazi Aron u svetinju: s juncem za žrtvu radi greha i s ovnom za žrtvu paljenicu. ");
INSERT INTO srp1865_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Svetu košulju lanenu neka obuče, i gaće lanene neka su na telu njegovom, i neka se opaše pojasom lanenim i kapu lanenu neka metne na glavu; to su haljine svete, i neka opere telo svoje vodom, pa onda neka ih obuče. ");
INSERT INTO srp1865_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","A od zbora sinova Izrailjevih neka uzme dva jarca za žrtvu radi greha, i jednog ovna za žrtvu paljenicu. ");
INSERT INTO srp1865_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","I neka prinese Aron junca svog na žrtvu za greh i očisti sebe i dom svoj. ");
INSERT INTO srp1865_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Potom neka uzme dva jarca, i neka ih metne pred Gospoda na vrata šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","I neka Aron baci žreb za ta dva jarca, jedan žreb Gospodu a drugi žreb Azazelu. ");
INSERT INTO srp1865_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","I neka Aron prinese na žrtvu jarca na kog padne žreb Gospodnji, neka ga prinese na žrtvu za greh. ");
INSERT INTO srp1865_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","A jarca na kog padne žreb Azazelov neka metne živa pred Gospoda, da učini očišćenje na njemu, pa neka ga pusti u pustinju Azazelu. ");
INSERT INTO srp1865_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","I neka Aron prinese junca svog na žrtvu za greh i očisti sebe i dom svoj, i neka zakolje junca svog na žrtvu za greh. ");
INSERT INTO srp1865_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","I neka uzme kadionicu punu žeravice s oltara, koji je pred Gospodom, i pune pregršti kada mirisnog istucanog, i neka unese za zaves. ");
INSERT INTO srp1865_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","I neka metne kad na oganj pred Gospodom, da dim od kada zakloni zaklopac koji je na svedočanstvu; tako neće poginuti. ");
INSERT INTO srp1865_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Posle neka uzme krvi od junca i pokropi s prsta svog po zaklopcu prema istoku, a pred zaklopcem neka sedam puta pokropi tom krvlju s prsta svog. ");
INSERT INTO srp1865_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","I neka zakolje jarca na žrtvu za greh narodni, i neka učini s krvlju njegovom kao što je učinio s krvlju junčijom, i pokropi njom po zaklopcu i pred zaklopcem. ");
INSERT INTO srp1865_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","I tako će očistiti svetinju od nečistota sinova Izrailjevih i od prestupa njihovih u svim gresima njihovim; tako će učiniti i u šatoru od sastanka, koji je među njima usred nečistota njihovih. ");
INSERT INTO srp1865_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","A niko da ne bude u šatoru od sastanka kad on uđe da čini očišćenje u svetinji, dokle ne izađe i svrši očišćenje za se i za dom svoj i za sav zbor izrailjski. ");
INSERT INTO srp1865_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","A neka izađe k oltaru koji je pred Gospodom, i očisti ga; i uzevši krvi od junca i krvi od jarca neka pomaže rogove oltaru unaokolo; ");
INSERT INTO srp1865_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","i neka ga pokropi odozgo istom krvlju s prsta svog sedam puta; tako će ga očistiti i posvetiti ga od nečistota sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","A kad očisti svetinju i šator od sastanka i oltar, tada neka dovede jarca živog. ");
INSERT INTO srp1865_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","I metnuvši Aron obe ruke svoje na glavu jarcu živom, neka ispovedi nad njim sva bezakonja sinova Izrailjevih i sve prestupe njihove u svim gresima njihovim, i metnuvši ih na glavu jarcu neka ga da čoveku spremnom da ga istera u pustinju. ");
INSERT INTO srp1865_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","I jarac će odneti na sebi sva bezakonja njihova u pustinju; i pustiće onog jarca u pustinju. ");
INSERT INTO srp1865_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Potom neka opet uđe Aron u šator od sastanka i svuče haljine lanene koje je obukao kada je išao u svetinju, i onde neka ih ostavi. ");
INSERT INTO srp1865_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Pa neka opere telo svoje na svetom mestu i obuče svoje haljine; i izašav neka prinese svoju žrtvu paljenicu, i očisti sebe i narod. ");
INSERT INTO srp1865_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A salo od žrtve za greh neka zapali na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","A ko odvede jarca za Azazela, neka opere haljine svoje i okupa telo svoje u vodi, pa onda neka uđe u logor. ");
INSERT INTO srp1865_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","A junca za greh i jarca za greh, od kojih je krv unesena da se učini očišćenje u svetinji, neka iznesu napolje iz logora, i neka spale ognjem kože njihove i meso njihovo i balegu njihovu. ");
INSERT INTO srp1865_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","A ko ih spali, neka opere haljine svoje i okupa telo svoje u vodi, pa onda neka dođe u logor. ");
INSERT INTO srp1865_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","I ovo neka vam bude večna uredba: deseti dan sedmog meseca mučite duše svoje, i ne radite nikakav posao, ni domorodac ni došljak koji se bavi među vama. ");
INSERT INTO srp1865_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Jer u taj dan biva očišćenje za vas, da se očistite; bićete očišćeni od svih greha svojih pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","To neka vam je počivanje subotno, i mučite duše svoje po uredbi večnoj. ");
INSERT INTO srp1865_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","A sveštenik koji bude pomazan i koji bude osvećen da vrši službu svešteničku na mesto oca svog, on neka očišća obukavši se u haljine lanene, haljine svete. ");
INSERT INTO srp1865_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","I neka očisti svetinju svetu i šator od sastanka; i oltar neka očisti; i sveštenike i sav narod sabrani neka očisti. ");
INSERT INTO srp1865_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","I ovo neka vam je večna uredba da očišćate sinove Izrailjeve od svih greha njihovih jedan put u godini. I učini Mojsije kako mu zapovedi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Kaži Aronu i sinovima njegovim i svim sinovima Izrailjevim, i reci im: Ovo je zapovedio Gospod govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ko god od doma Izrailjevog zakolje vola ili jagnje ili kozu u logoru, ili ko god zakolje izvan logora, ");
INSERT INTO srp1865_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a ne dovede na vrata šatora od sastanka, da prinese prinos Gospodu pred šatorom Gospodnjim, kriv je za krv; zato da se istrebi onaj čovek iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Zato sinovi Izrailjevi neka dovedu žrtve svoje, koje bi klali u polju, neka ih dovedu Gospodu na vrata šatora od sastanka k svešteniku, i neka prinesu žrtve zahvalne Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","I sveštenik neka pokropi krvlju po oltaru Gospodnjem na vratima šatora od sastanka, i salo neka zapali na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","I neka više ne prinose žrtve svoje đavolima, za kojima oni čine preljubu. Ovo neka im bude zakon večan od kolena na koleno. ");
INSERT INTO srp1865_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Zato im reci: Ko bi god od doma Izrailjevog ili između stranaca koji se bave među njima prineo žrtvu paljenicu ili drugu žrtvu, ");
INSERT INTO srp1865_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","a ne bi je doveo na vrata šatora od sastanka da je prinese Gospodu, taj čovek da se istrebi iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","A ko bi god od doma Izrailjevog ili između stranaca koji se bave među njima jeo kakvu god krv, okrenuću lice svoje nasuprot onom čoveku koji bude jeo krv, i istrebiću ga iz naroda njegovog. ");
INSERT INTO srp1865_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Jer je duša telu u krvi; a ja sam vam je odredio za oltar da se čiste duše vaše; jer je krv što dušu očišća. ");
INSERT INTO srp1865_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Zato rekoh sinovima Izrailjevim: Niko između vas da ne jede krv; ni došljak koji se bavi među vama da ne jede krv. ");
INSERT INTO srp1865_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","I ko bi god između sinova Izrailjevih ili između došljaka koji se bave kod njih ulovio zverku ili pticu, koja se jede, neka iscedi krv iz nje, i zaspe je zemljom. ");
INSERT INTO srp1865_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Jer je duša svakog tela krv njegova, to mu je duša. Zato rekoh sinovima Izrailjevim: Krv ni jednog tela ne jedite, jer je duša svakog tela krv njegova. Ko bi je god jeo, da se istrebi. ");
INSERT INTO srp1865_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","A ko bi jeo meso od životinje koja crkne ili koju raskine zverka, bio domorodac ili došljak, neka opere haljine svoje i okupa se u vodi, i biće nečist do večera, a posle će biti čist. ");
INSERT INTO srp1865_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ako li ih ne opere, i tela svog ne okupa, nosiće bezakonje svoje. ");
INSERT INTO srp1865_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Još reče Gospod govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Kaži sinovima Izrailjevim, i reci im: Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Nemojte činiti šta se čini u zemlji misirskoj, u kojoj ste živeli, niti činite šta se čini u zemlji hananskoj, u koju vas vodim, i po uredbama njihovim nemojte živeti. ");
INSERT INTO srp1865_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Nego moje zakone vršite i moje uredbe držite živeći po njima. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Držite uredbe moje i zakone moje; ko ih vrši, živ će biti kroz njih. Ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Niko da ne pristupa k rodici svojoj po krvi, da ne otkrije golotinju njenu. Ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Golotinje oca svog ni golotinje matere svoje ne otkrij; mati ti je; ne otkrij golotinje njene. ");
INSERT INTO srp1865_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Golotinje žene oca svog ne otkrij; golotinja je oca tvog. ");
INSERT INTO srp1865_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Golotinje sestre svoje, kćeri oca svog ili kćeri matere svoje, koja je rođena u kući ili izvan kuće, ne otkrij golotinje njihove. ");
INSERT INTO srp1865_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Golotinje kćeri sina svog, ili kćeri kćeri svoje ne otkrij; jer je tvoja golotinja. ");
INSERT INTO srp1865_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Golotinje kćeri žene oca svog, koju je rodio otac tvoj, ne otkrij; sestra ti je. ");
INSERT INTO srp1865_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Golotinje sestre oca svog ne otkrij; jedna je krv sa ocem tvojim. ");
INSERT INTO srp1865_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Golotinje sestre matere svoje ne otkrij; jer je jedna krv s materom tvojom. ");
INSERT INTO srp1865_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Golotinje brata oca svog ne otkrij pristupajući k ženi njegovoj; strina ti je. ");
INSERT INTO srp1865_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Golotinje žene sina svog ne otkrij; snaha ti je, ne otkrij golotinje njene. ");
INSERT INTO srp1865_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Golotinje žene brata svog ne otkrij; golotinja je brata tvog. ");
INSERT INTO srp1865_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Golotinje žene i kćeri njene ne otkrij; kćeri sina njenog ni kćeri kćeri njene nemoj uzeti da otkriješ golotinju njihovu; jedna su krv; zlo je. ");
INSERT INTO srp1865_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Nemoj uzeti žene preko jedne žene, da je ucveliš otkrivajući golotinju drugoj za života njenog. ");
INSERT INTO srp1865_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","K ženi dokle se odvaja radi nečistote svoje ne idi da otkriješ golotinju njenu. ");
INSERT INTO srp1865_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Sa ženom bližnjeg svog ne lezi skvrneći se s njom. ");
INSERT INTO srp1865_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Od semena svog ne daj da se odnese Molohu, da ne oskvrniš imena Boga svog; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","S muškarcem ne lezi kao sa ženom; gadno je. ");
INSERT INTO srp1865_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Živinče nikakvo nemoj obležati skvrneći se s njim; i žena da ne legne pod živinče; grdilo je. ");
INSERT INTO srp1865_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Nemojte se skvrniti ni jednom ovom stvarju; jer su se svim tim stvarima oskvrnili narodi koje ću odagnati ispred vas. ");
INSERT INTO srp1865_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Jer se oskvrnila zemlja, i nevaljalstvo ću njeno pohoditi na njoj, i izmetnuće zemlja stanovnike svoje. ");
INSERT INTO srp1865_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Nego vi držite zakone moje i uredbe moje, i ne činite ni jednog ovog gada, ni domorodac ni došljak koji se bavi među vama; ");
INSERT INTO srp1865_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","jer sve ove gadove činiše ljudi u ovoj zemlji koji su bili pre vas, i zemlja je od toga oskvrnjena; ");
INSERT INTO srp1865_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","da ne izmetne zemlja vas, ako je oskvrnite, kao što je izmetnula narod koji je bio pre vas. ");
INSERT INTO srp1865_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Jer ko učini šta god od ovih gadova, istrebiće se iz naroda svog duše koje učine. ");
INSERT INTO srp1865_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Zato držite šta sam naredio da se drži, da ne činite šta od gadnih običaja koji su bili pre vas, i da se ne skvrnite o njih. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Kaži svemu zboru sinova Izrailjevih, i reci im: Budite sveti, jer sam ja svet, Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Svaki da se boji matere svoje i oca svog; i držite subote moje; ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ne obraćajte se k idolima, i bogove livene ne gradite sebi; ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","A kad prinosite žrtvu zahvalnu Gospodu, prinosite je drage volje. ");
INSERT INTO srp1865_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","U koji je dan prinesete, neka se jede, i sutradan; a šta ostane do trećeg dana, neka se ognjem sažeže. ");
INSERT INTO srp1865_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","A ako bi se šta jelo treći dan, gad je, neće biti ugodna. ");
INSERT INTO srp1865_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ko bi god jeo, nosiće svoje bezakonje, jer oskvrni svetinju Gospodnju; zato će se istrebiti ona duša iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","A kad žanjete rod zemlje svoje, nemoj požeti sasvim njivu svoju, niti pabirči po žetvi. ");
INSERT INTO srp1865_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ni vinograd svog nemoj pabirčiti, i nemoj kupiti zrna koja padnu po vinogradu tvom; nego ostavi siromahu i došljaku. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ne kradite; ne lažite i ne varajte bližnjeg svog. ");
INSERT INTO srp1865_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ne kunite se imenom mojim krivo; jer ćeš oskvrniti ime Boga svog. Ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ne zakidaj bližnjeg svog i ne otimaj mu; plata nadničarova da ne prenoći kod tebe do jutra. ");
INSERT INTO srp1865_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Nemoj psovati gluvog, ni pred slepca metati šta da se spotakne; nego se boj Boga svog; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ne činite nepravdu na sudu, ne gledajte što je ko siromah, niti se povodi za bogatim; pravo sudi bližnjemu svom. ");
INSERT INTO srp1865_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ne idi kao opadač po narodu svom, i ne ustaj na krv bližnjeg svog; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Nemoj mrzeti na brata svog u srcu svom; slobodno iskaraj bližnjeg svog, i nemoj trpeti greha na njemu. ");
INSERT INTO srp1865_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ne budi osvetljiv, i ne nosi srdnju na sinove naroda svog; nego ljubi bližnjeg svog kao sebe samog; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Uredbe moje držite; živinčeta svog ne puštaj na živinče druge vrste; ne zasevaj njive svoje dvojakim semenom, i ne oblači na se haljine od dvojakih stvari. ");
INSERT INTO srp1865_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ako bi ko obležao robinju, koja je isprošena ali nije otkupljena ni oslobođena, oboje da se šibaju, ali da se ne pogube; jer nije bila oslobođena. ");
INSERT INTO srp1865_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","I neka on prinese Gospodu žrtvu za prestup svoj na vrata šatora od sastanka, ovna za prestup. ");
INSERT INTO srp1865_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","I neka ga očisti pred Gospodom sveštenik ovnom prinesenim za prestup od greha koji je učinio; i oprostiće mu se greh njegov. ");
INSERT INTO srp1865_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","A kad dođete u zemlju i nasadite svakojakog voća, obrežite mu okrajak, rod njegov; tri godine neka vam je neobrezano, i ne jedite ga. ");
INSERT INTO srp1865_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A četvrte godine neka bude sav rod njegov posvećen u hvalu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pa tek pete godine jedite voće s njega, da bi vam se umnožio rod njegov. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ništa ne jedite s krvlju. Nemojte vračati, ni gatati po vremenu. ");
INSERT INTO srp1865_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ne strižite kosu svoju ukrug, ni grdite bradu svoju. ");
INSERT INTO srp1865_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Za mrtvacem ne režite telo svoje, ni udarajte na se kakve belege. Ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Nemoj skvrniti kćer svoju puštajući je da se kurva, da se ne bi zemlja prokurvala i napunila se bezakonja. ");
INSERT INTO srp1865_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Držite subote moje, i svetinju moju poštujte. Ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ne obraćajte se k vračarima i gatarima, niti ih pitajte, da se ne skvrnite o njih. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Pred sedom glavom ustani, i poštuj lice starčevo, i boj se Boga svog. Ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Ako je u tebe došljak u zemlji vašoj, ne čini mu krivo. ");
INSERT INTO srp1865_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ko je došljak među vama, neka vam bude kao onaj koji se rodio među vama, i ljubite ga kao sebe samog; jer ste i vi bili došljaci u zemlji misirskoj. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ne činite nepravde u sudu, ni merom za dužinu, ni merom za težinu, ni merom za stvari koje se sipaju. ");
INSERT INTO srp1865_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Merila neka su vam prava, kamenje pravo, efa prava, in prav. Ja sam Gospod Bog vaš, koji sam vas izveo iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Držite, dakle, sve uredbe moje i sve zakone moje, i vršite ih. Ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Još reci sinovima Izrailjevim: Ko god između sinova Izrailjevih ili između došljaka koji se bave u Izrailju, da od semena svog Molohu, neka se pogubi, narod u zemlji neka ga zaspe kamenjem. ");
INSERT INTO srp1865_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","I ja ću okrenuti lice svoje nasuprot takvom čoveku, i istrebiću ga iz naroda njegovog, što od semena svog dade Molohu, i zaprzni svetinju moju i oskvrni sveto ime moje. ");
INSERT INTO srp1865_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ako li narod kako god zatvori oči da ne vidi tog čoveka kad da od semena svog Molohu, i ne ubiju ga, ");
INSERT INTO srp1865_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ja ću okrenuti lice svoje nasuprot onom čoveku i nasuprot domu njegovom, i istrebiću ga, i sve koji za njim čine preljubu čineći preljubu za Molohom, iz naroda njihovog. ");
INSERT INTO srp1865_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","A ko se obrati k vračarima i k gatarima da čini preljubu za njima, okrenuću lice svoje na suprot njemu, i istrebiću ga iz naroda njegovog. ");
INSERT INTO srp1865_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Zato posvećujte se, i budite sveti, jer sam ja Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","I čuvajte uredbe moje i vršite ih. Ja sam Gospod koji vas posvećujem. ");
INSERT INTO srp1865_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ko opsuje oca svog ili mater svoju, da se pogubi; opsovao je oca svog ili mater svoju; krv njegova na nj. ");
INSERT INTO srp1865_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","A čovek koji učini preljubu s tuđom ženom, što je učinio preljubu sa ženom bližnjeg svog, da se pogubi i preljubočinac i preljubočinica. ");
INSERT INTO srp1865_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ko bi spavao sa ženom oca svog, otkrio je golotinju oca svog; oboje da se pogube; krv njihova na njih. ");
INSERT INTO srp1865_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ko bi spavao sa ženom sina svog, oboje da se pogube; učiniše sramotu; krv njihova na njih. ");
INSERT INTO srp1865_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ko bi muškarca obležao kao ženu, učiniše gadnu stvar obojica; da se pogube; krv njihova na njih. ");
INSERT INTO srp1865_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","I ko bi uzeo ženu i mater njenu, zlo je, ognjem da se spali i on i ona, da ne bude zla među vama. ");
INSERT INTO srp1865_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ko bi obležao živinče, da se pogubi; ubijte i živinče. ");
INSERT INTO srp1865_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","I ako bi žena legla pod živinče, ubij i ženu i živinče, neka poginu, krv njihova na njih. ");
INSERT INTO srp1865_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ko bi uzeo sestru svoju, kćer oca svog ili kćer matere svoje, video bi golotinju njenu i ona bi videla golotinju njegovu, sramota je; zato da se istrebe ispred sinova naroda svog; otkrio je golotinju sestre svoje, neka nosi bezakonje svoje. ");
INSERT INTO srp1865_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","I ko bi spavao sa ženom kad ima vreme i otkrio golotinju njenu otkrivši tečenje njeno, i ona bi otkrila tečenje krvi svoje, da se istrebe oboje iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Golotinje sestre matere svoje i sestre oca svog ne otkrij, jer bi otkrio svoju krv; neka nose bezakonje svoje. ");
INSERT INTO srp1865_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","A ko bi spavao sa ženom strica svog, otkrio bi golotinju strica svog, neka nose oboje greh svoj, neka pomru bez dece. ");
INSERT INTO srp1865_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ko bi uzeo ženu brata svog, ružno je, otkrio je golotinju brata svog; bez dece da budu. ");
INSERT INTO srp1865_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Čuvajte sve uredbe moje i sve zakone moje, i vršite ih, da vas zemlja ne izmetne, u koju vas vodim da živite u njoj. ");
INSERT INTO srp1865_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Nemojte živeti po uredbama naroda koje ću oterati ispred vas, jer su činili sve to, zato mi omrzoše. ");
INSERT INTO srp1865_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","I rekoh vam: Vi ćete naslediti zemlju njihovu i ja ću vam je dati u državu, zemlju u kojoj teče mleko i med. Ja sam Gospod Bog vaš koji vas odvojih od drugih naroda. ");
INSERT INTO srp1865_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Zato razlikujte stoku čistu od nečiste, i pticu čistu od nečiste, i nemojte skvrniti duša svojih stokom ili pticom ili čim god što puže po zemlji, što sam vam odvojio da je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","I bićete mi sveti, jer sam svet ja, Gospod, i odvojih vas od drugih naroda da budete moji. ");
INSERT INTO srp1865_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","A čovek ili žena, u kojima bi bio duh vračarski ili gatarski, da se pogube, kamenjem da se zaspu, krv njihova na njih. ");
INSERT INTO srp1865_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Još reče Gospod Mojsiju: Kaži sveštenicima sinovima Aronovim, i reci im: Za mrtvacem da se ne skvrni ni jedan u narodu svom, ");
INSERT INTO srp1865_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","osim za rodom svojim po krvi, za materom svojom ili za ocem svojim ili za sinom svojim ili za kćerju svojom ili za bratom svojim, ");
INSERT INTO srp1865_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ili za rođenom sestrom svojom, devojkom, koja nije imala muža; za njom se može oskvrniti. ");
INSERT INTO srp1865_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ako je oženjen, da se ne oskvrni za ženom svojom u narodu svom učinivši se nečist. ");
INSERT INTO srp1865_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Da se ne načine ćelavi čupajući kosu s glave svoje i da ne briju brade svoje, niti se režu po telu svom. ");
INSERT INTO srp1865_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Neka budu sveti Bogu svom, i neka ne skvrne ime Boga svog, jer prinose žrtve ognjene Gospodnje, hleb Boga svog, zato neka su sveti. ");
INSERT INTO srp1865_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Neka se ne žene ženom kurvom ili silovanom; ni puštenicom neka se ne žene; jer su sveti Bogu svom. ");
INSERT INTO srp1865_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","I tebi neka je svaki svet, jer prinosi hleb Boga tvog; svet neka ti je, jer sam ja svet, Gospod, koji vas posvećujem. ");
INSERT INTO srp1865_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","A kći sveštenička koja se oskvrni kurvajući se, skvrni oca svog, ognjem neka se spali. ");
INSERT INTO srp1865_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","A sveštenik najviši između braće svoje, kome se na glavu izlije ulje pomazanja i koji je posvećen da se oblači u svete haljine, neka ne otkriva glave svoje, i haljine svoje neka ne razdire. ");
INSERT INTO srp1865_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","I k mrtvacu ni jednom neka ne ide, ni za ocem svojim ni za materom svojom da se ne oskvrni. ");
INSERT INTO srp1865_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","I iz svetinje neka ne izlazi, da ne bi oskvrnio svetinju Boga svog, jer je na njenu venac, ulje pomazanja Boga njegovog; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","On neka se ženi devicom. ");
INSERT INTO srp1865_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Udovicom ili puštenicom ili silovanom ili kurvom da se ne ženi; nego devojkom iz naroda svog neka se oženi. ");
INSERT INTO srp1865_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","I neka ne skvrni seme naroda svog u narodu svom, jer sam ja Gospod, koji ga posvećujem. ");
INSERT INTO srp1865_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Kaži Aronu i reci: U koga bi iz semena tvog od kolena do kolena bila mana na telu, onaj neka ne pristupa da prinosi hleb Boga svog. ");
INSERT INTO srp1865_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Jer niko na kome bi bila mana ne valja da pristupa, ni slep, ni hrom, ni u koga bi bio koji ud preveć mali ili preveć veliki, ");
INSERT INTO srp1865_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ni u koga je slomljena noga ili ruka, ");
INSERT INTO srp1865_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ni grbav, ni drljav, ni ko ima bionu na oku, ni šugav, ni lišajiv, ni prosut. ");
INSERT INTO srp1865_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","U koga bi god iz semena Arona sveštenika bila kakva mana na telu, neka ne pristupa da prinosi žrtve ognjene Gospodu; mana je na njemu; da ne pristupa da prinosi hleb Boga svog. ");
INSERT INTO srp1865_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ali hleb Boga svog od stvari presvetih i od stvari svetih neka jede; ");
INSERT INTO srp1865_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ali za zaves neka ne ulazi; k oltaru neka se ne približuje, jer je mana na njemu, pa neka ne skvrni svetinje moje, jer sam ja Gospod koji ih posvećujem. ");
INSERT INTO srp1865_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","I Mojsije kaza to Aronu i sinovima njegovim i svim sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Kaži Aronu i sinovima njegovim da se čuvaju od svetih stvari sinova Izrailjevih, da ne bi oskvrnili sveto ime moje u onom što mi oni posvećuju; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Reci im: Ko bi god iz semena vašeg od kolena na koleno pristupio k svetim stvarima, koje bi posvetili sinovi Izrailjevi Gospodu, kad je nečistota njegova na njemu, taj neka se istrebi ispred lica mog; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ko bi god iz semena Aronovog bio gubav ili bi išlo seme od njega, neka ne jede svete stvari dokle ne bude čist; tako i koji bi se dotakao koga nečistog od mrtvog tela ili onog od koga je izašlo seme, ");
INSERT INTO srp1865_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ili ko bi se dotakao čega što gamiže po zemlji, od čega bi se oskvrnio, ili čoveka od kog bi se oskvrnio kakve mu drago nečistote njegove, ");
INSERT INTO srp1865_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ko bi se dotakao takvog čega, biće nečist do večera; zato neka ne jede svete stvari ako ne okupa telo svoje u vodi. ");
INSERT INTO srp1865_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","A kad zađe sunce, biće čist, i onda može jesti od svetih stvari; jer mu je hrana. ");
INSERT INTO srp1865_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mrcino ili šta raskine zverka neka ne jede, da se njim ne skvrni; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Tako neka drže šta sam uredio da se drži, da ne navuku na se greha i ne umru od njega oskvrnivši se. Ja sam Gospod koji ih posvećujem. ");
INSERT INTO srp1865_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Niko drugi da ne jede svete stvari, ni ukućanin sveštenikov ni nadničar da ne jede svete stvari. ");
INSERT INTO srp1865_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","A kad sveštenik kupi koga za novce, taj neka ih jede, i koji se rodi u kući njegovoj; oni neka jedu jelo njegovo. ");
INSERT INTO srp1865_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ali kći sveštenička kad se uda za čoveka drugog plemena, ona da ne jede od žrtava podignutih svetih stvari. ");
INSERT INTO srp1865_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","A kći sveštenička ako obudovi, ili je pusti muž, ako nema poroda, neka se vrati kući oca svog kao što je bila u detinjstvu svom, hleb oca svog neka jede; ali niko drugog plemena da ga ne jede. ");
INSERT INTO srp1865_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","A ko bi nehotice jeo svetu stvar, neka dometne peti deo i naknadi svešteniku svetu stvar. ");
INSERT INTO srp1865_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Da ne bi oskvrnili svete stvari sinova Izrailjevih, koje prinose Gospodu, ");
INSERT INTO srp1865_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","i da ne bi navlačili na njih kar za prestup jedući svete stvari njihove, jer sam ja Gospod, koji ih posvećujem. ");
INSERT INTO srp1865_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Kaži Aronu i sinovima njegovim i svim sinovima Izrailjevim i reci im: Ko god od doma Izrailjevog ili od stranaca koji su u Izrailju hoće da prinese žrtvu svoju po kakvom god zavetu svom, ili od dobre volje svoje dar, što se prinosi Gospodu na žrtvu paljenicu, ");
INSERT INTO srp1865_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","neka prinese drage volje muško zdravo od goveda ili od ovaca ili od koza. ");
INSERT INTO srp1865_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Na čem bi bila mana, ono ne prinosite, jer vam se ne bi primilo. ");
INSERT INTO srp1865_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","I kad ko hoće da prinese žrtvu zahvalnu Gospodu, izvršavajući zavet ili od svoje volje dajući dar, od goveda ili od sitne stoke, neka bude zdravo, da bi bilo primljeno; nikakve mane da nema na njemu. ");
INSERT INTO srp1865_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Slepo, ili kome je šta slomljeno ili odbijeno, ni gutavo, ni krastavo ni lišajivo, šta je takvo ne prinosite Gospodu, i ne mećite ih na oltar Gospodnji na žrtvu ognjenu. ");
INSERT INTO srp1865_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","A vola ili ovcu ili kozu sa udom kojim prevelikim ili premalim možeš prineti za dobrovoljni dar; ali za zavet neće se primiti. ");
INSERT INTO srp1865_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ujalovljeno uvrtanjem, tučenjem, kidanjem ili rezanjem, ne prinosite Gospodu; i ne činite to u zemlji svojoj. ");
INSERT INTO srp1865_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","I iz ruke tuđinske nemojte uzimati ni jedne stvari da prinesete hleb Bogu svom; jer je kvar njihov u njima; imaju manu, neće vam se primiti. ");
INSERT INTO srp1865_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Tele i jagnje i jare kad se omladi, neka bude sedam dana kod majke svoje, pa od osmog dana i posle biće ugodno za žrtvu ognjenu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","A kravu ni ovcu ni kozu ne koljite u jedan dan s mladetom njenim. ");
INSERT INTO srp1865_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","I kad prinosite Gospodu žrtvu radi hvale, prinesite je dragovoljno. ");
INSERT INTO srp1865_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Neka se jede istog dana, i ne ostavljajte ništa do jutra; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Zato držite zapovesti moje, i vršite ih; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","I nemojte skvrniti sveto ime moje, i ja ću se svetiti među sinovima Izrailjevim; ja sam Gospod, koji vas posvećujem. ");
INSERT INTO srp1865_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Koji sam vas izveo iz zemlje misirske da vam budem Bog; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Kaži sinovima Izrailjevim, i reci im: Praznici Gospodnji, koje ćete zvati sveti sabori, ovo su praznici moji: ");
INSERT INTO srp1865_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Šest dana radi, a sedmi dan, koji je subota za počivanje, neka bude sveti sabor, ne radite ni jedan posao; subota je Gospodnja po svim stanovima vašim. ");
INSERT INTO srp1865_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ovo su praznici Gospodnji, sabori sveti, na koje ćete se sabirati u vreme njihovo: ");
INSERT INTO srp1865_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Četrnaestog dana prvog meseca uveče, pasha je Gospodnja. ");
INSERT INTO srp1865_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","A petnaestog dana istog meseca praznik je presnih hlebova Gospodu; sedam dana jedite hlebove presne. ");
INSERT INTO srp1865_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Prvi dan neka vam bude sabor sveti, nikakav posao ropski ne radite. ");
INSERT INTO srp1865_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Nego za sedam dana prinosite Gospodu žrtve ognjene; a sedmi dan neka je sabor sveti; ne radite nijedan posao ropski. ");
INSERT INTO srp1865_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Kaži sinovima Izrailjevim, i reci im: Kad dođete u zemlju koju ću vam dati, i stanete žeti u njoj, tada donesite snop prvina od žetve svoje k svešteniku; ");
INSERT INTO srp1865_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","a on neka obrće snop pred Gospodom, da bi vam se primio; sutradan po suboti neka ga obrće sveštenik. ");
INSERT INTO srp1865_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","A isti dan kad budete obrtali snop, prinesite jagnje od godine dana zdravo na žrtvu paljenicu Gospodu; ");
INSERT INTO srp1865_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","i dar uza nj, dve desetine efe belog brašna zamešenog s uljem, da bude žrtva ognjena Gospodu na ugodni miris; i naliv uza nj, vina četvrt ina. ");
INSERT INTO srp1865_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","A hleba, ni zrna prženog ni zrna u klasu nemojte jesti do onog dana kad prinesete žrtvu Bogu svom; to da vam je večna uredba od kolena do kolena po svim stanovima vašim. ");
INSERT INTO srp1865_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Potom od prvog dana po suboti, od dana kad prinesete snop za žrtvu obrtanu, brojte sedam nedelja punih; ");
INSERT INTO srp1865_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","do prvog dana po sedmoj nedelji nabrojte pedeset dana; onda prinesite nov dar Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Iz stanova svojih donesite dva hleba za žrtvu obrtanu; od dve desetine efe belog brašna da budu, s kvascem neka budu pečeni; to su prvine Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","A s tim hlebom prinesite sedam jaganjaca od godine zdravih, i jedno tele i dva ovna, da bude žrtva paljenica Gospodu s darovima svojim i nalivima svojim, da bude žrtva ognjena na ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Zakoljite i jarca jednog za greh i dva jagnjeta od godine za žrtvu zahvalnu. ");
INSERT INTO srp1865_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","I sveštenik neka to obrne tamo i amo s hlebom od prvina i sa dva jagnjeta na žrtvu obrtanu pred Gospodom; i biće svete stvari Gospodu za sveštenika. ");
INSERT INTO srp1865_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","I saberite se u onaj dan, sabor sveti da vam je; nijedan posao ropski ne radite zakonom večnim po svim stanovima svojim od kolena do kolena. ");
INSERT INTO srp1865_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","A kad stanete žeti u zemlji svojoj, nemoj sasvim požnjeti njive svoje, ni pabirči po žetvi; ostavi siromahu i došljaku; ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Kaži sinovima Izrailjevim, i reci im: Prvi dan sedmog meseca neka vam je odmor, spomen trubni, sabor sveti. ");
INSERT INTO srp1865_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Nijedan posao ropski nemojte raditi, nego prinesite žrtvu ognjenu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","A deseti je dan tog meseca sedmog dan očišćenja; sabor sveti neka vam je, i mučite duše svoje, i prinesite Gospodu žrtvu ognjenu. ");
INSERT INTO srp1865_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","U taj dan nemojte raditi nijedan posao, jer je dan očišćenja, da se očistite pred Gospodom Bogom svojim. ");
INSERT INTO srp1865_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","A svaka duša koja se ne bi mučila u taj dan, da se istrebi iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","I svaku dušu koja bi radila kakav posao u taj dan, ja ću zatrti dušu onu u narodu njenom. ");
INSERT INTO srp1865_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ni jedan posao nemojte raditi; to da je večna uredba od kolena do kolena u svim stanovima vašim. ");
INSERT INTO srp1865_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Subota počivanja neka vam bude, i mučite duše svoje; devetog dana istog meseca kad bude veče, od večera do večera praznujte počinak svoj. ");
INSERT INTO srp1865_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Kaži sinovima Izrailjevim, i reci: Petnaestog dana sedmog meseca praznik je senica za sedam dana Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Prvi dan neka bude sabor sveti, nijedan posao ropski nemojte raditi. ");
INSERT INTO srp1865_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Za sedam dana prinosite žrtve ognjene Gospodu; osmi dan neka vam bude sabor sveti, i prinesite žrtve ognjene Gospodu; praznik je, nijedan posao ropski nemojte raditi. ");
INSERT INTO srp1865_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","To su praznici Gospodnji, koje ćete praznovati na saborima svetim da prinesete žrtve ognjene Gospodu: žrtvu paljenicu i dar i žrtvu zahvalnu i naliv, sve kad je čemu dan, ");
INSERT INTO srp1865_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","osim subota Gospodnjih i osim darova vaših i osim svih zaveta vaših i osim svih dobrovoljnih prinosa vaših, koje ćete davati Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ali petnaesti dan tog meseca sedmog, kad saberete rod zemaljski, praznujte praznik Gospodu sedam dana; u prvi je dan odmor i u osmi je dan odmor. ");
INSERT INTO srp1865_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","U prvi dan uzmite voća s lepih drveta, i grana palmovih i grana s gustih drveta i vrbe s potoka, i veselite se pred Gospodom Bogom svojim sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","I praznujte taj praznik Gospodu sedam dana svake godine zakonom večnim od kolena do kolena, sedmog meseca praznujte ga. ");
INSERT INTO srp1865_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","I pod senicama budite sedam dana, ko je god rođen u Izrailju neka bude pod senicama, ");
INSERT INTO srp1865_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","da bi znalo natražje vaše da sam ja učinio da žive pod senicama sinovi Izrailjevi kad sam ih izveo iz zemlje misirske. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","I Mojsije kaza praznike Gospodnje sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Zapovedi sinovima Izrailjevim neka ti donesu ulje maslinovo čisto, ceđeno, za videlo, da žišci gore vazda. ");
INSERT INTO srp1865_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Pred zavesom svedočanstva u šatoru od sastanka Aron će ih nameštati da gore od večera do jutra pred Gospodom vazda zakonom večnim od kolena do kolena. ");
INSERT INTO srp1865_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Na svećnjak čisti nameštaće žiške pred Gospodom vazda. ");
INSERT INTO srp1865_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","I uzmi belog brašna, i ispeci dvanaest kolača, svaki kolač da bude od dve desetine efe. ");
INSERT INTO srp1865_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","I postavi ih u dva reda, po šest u jedan red, na čistom stolu pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","I na svaki red metni kada čistog, da bude za svaki hleb spomen, žrtva ognjena Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Svake subote neka ih postavlja sveštenik pred Gospodom vazda uzimajući od sinova Izrailjevih zakonom večnim. ");
INSERT INTO srp1865_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","I biće Aronovi i sinova njegovih, koji će jesti na mestu svetom, jer im je svetinja nad svetinjama od ognjenih žrtava Gospodnjih zakonom večnim. ");
INSERT INTO srp1865_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","A izađe sin jedne Izrailjke, kome je otac bio Misirac, među sinove Izrailjeve, i svadi se u logoru sin žene Izrailjke s nekim Izrailjcem. ");
INSERT INTO srp1865_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","I psujući sin žene Izrailjke pohuli na ime Božije, te ga dovedoše k Mojsiju; a mati mu beše po imenu Salomita, kći Davrijina, od plemena Danovog. ");
INSERT INTO srp1865_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","I metnuše ga u zatvor dokle im se kaže šta će činiti s njim po reči Gospodnjoj. ");
INSERT INTO srp1865_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","A Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Izvedi tog psovača napolje iz logora, i neka svi koji su čuli metnu ruke svoje na glavu njegovu, i neka ga sav narod zaspe kamenjem. ");
INSERT INTO srp1865_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","A sinovima Izrailjevim kaži i reci: Ko bi god pohulio Boga svog, nosiće greh svoj. ");
INSERT INTO srp1865_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ko bi ružio ime Gospodnje, da se pogubi, sav narod da ga zaspe kamenjem; i došljak i domorodac koji bi ružio ime Gospodnje, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","I ko ubije čoveka, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","A ko ubije živinče, neka vrati drugo, živinče za živinče. ");
INSERT INTO srp1865_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","I ko rani bližnjeg svog, kako učini tako da mu bude: ");
INSERT INTO srp1865_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ulom za ulom, oko za oko, zub za zub; kako ošteti telo čoveku, onako da mu se učini. ");
INSERT INTO srp1865_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ko ubije živinče, da vrati drugo; ali ko ubije čoveka, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Zakon da vam je jedan, došljaku da bude kao i rođenom u zemlji. Jer sam ja Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","I Mojsije kaza sinovima Izrailjevim, a oni izvedoše psovača napolje iz logora, i zasuše ga kamenjem; i učiniše sinovi Izrailjevi kako Gospod zapovedi Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Još reče Gospod Mojsiju na gori sinajskoj govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Kaži sinovima Izrailjevim, i reci im: Kad dođete u zemlju koju vam ja dajem, neka praznuje zemlja subotu Gospodnju. ");
INSERT INTO srp1865_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Šest godina zasevaj njivu svoju, i šest godina reži vinograd svoj i sabiraj rod. ");
INSERT INTO srp1865_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","A sedma godina neka bude subota za odmor zemlji, subota Gospodnja; nemoj sejati u polju svom ni rezati vinograd svoj. ");
INSERT INTO srp1865_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Šta samo od sebe rodi iza žetve tvoje nemoj žeti, i grožđa u vinogradu svom nerezanom nemoj brati; neka bude godina odmora zemlji. ");
INSERT INTO srp1865_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ali šta rodi zemlja za počivanja svog, ono neka vam bude hrana, tebi i sluzi tvom i sluškinji tvojoj i najamniku tvom i ukućaninu tvom koji je kod tebe. ");
INSERT INTO srp1865_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","I stoci tvojoj i svim životinjama što su u tvojoj zemlji, sav rod njen neka bude hrana. ");
INSERT INTO srp1865_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","I nabroj sedam sedmina godina, sedam puta po sedam godina, tako da ti sedam sedmina godina bude četrdeset i devet godina. ");
INSERT INTO srp1865_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Tada zapovedi neka zatrubi truba deseti dan sedmog meseca, na dan očišćenja neka trubi truba po svoj zemlji vašoj. ");
INSERT INTO srp1865_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","I posvetite godinu pedesetu, i proglasite slobodu u zemlji svima koji žive u njoj; to neka vam je oprosna godina, i tada se vratite svaki na svoju baštinu, i svaki u rod svoj vratite se. ");
INSERT INTO srp1865_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Oprosna godina da vam je ta pedeseta godina; nemojte sejati, niti žanjite šta samo rodi te godine, niti berite grožđa u vinogradima nerezanim. ");
INSERT INTO srp1865_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Jer je oprosna godina; neka vam je sveta; sa svakog polja jedite rod njegov. ");
INSERT INTO srp1865_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Te godine oprosne vratite se svaki na svoju baštinu. ");
INSERT INTO srp1865_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","I ako prodaš šta bližnjemu svom ili kupiš šta od bližnjeg svog, ne varajte jedan drugog. ");
INSERT INTO srp1865_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Prema broju godina po oprosnoj godini kupuj od bližnjeg svog, i prema broju godina u koje ćeš brati rod neka ti prodaje. ");
INSERT INTO srp1865_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Što više bude godina to će cena biti veća onome što kupuješ, a što manje bude godina to će manja biti cena, jer ti se prodaje broj letina. ");
INSERT INTO srp1865_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Zato ne varajte jedan drugog, nego se bojte Boga svog; jer sam ja Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Držite uredbe moje i čuvajte zakone moje i vršite ih, pa ćete živeti u zemlji bez straha. ");
INSERT INTO srp1865_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","I zemlja će rađati rod svoj, i ješćete ga, i bićete siti, i živećete u njoj bez straha. ");
INSERT INTO srp1865_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","I ako biste rekli: Šta ćemo jesti sedme godine, eto nećemo sejati niti ćemo brati letinu? ");
INSERT INTO srp1865_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Pustiću blagoslov svoj na vas šeste godine, te će roditi za tri godine. ");
INSERT INTO srp1865_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","I sejaćete osme godine, a ješćete letinu staru do devete godine, dokle ne prispe rod njen, ješćete stari. ");
INSERT INTO srp1865_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ali da se zemlja ne prodaje za svagda, jer je moja zemlja, a vi ste došljaci i ukućani kod mene. ");
INSERT INTO srp1865_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Zato po svoj zemlji države vaše neka se otkupljuju zemlje. ");
INSERT INTO srp1865_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ako osiromaši brat tvoj i proda nešto od baštine svoje, a posle dođe ko od roda njegovog najbliži njemu da otkupi, neka otkupi šta brat njegov prodade. ");
INSERT INTO srp1865_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ako li ne bi imao nikoga da otkupi, nego bi se pomogao i zglavio koliko treba za otkup, ");
INSERT INTO srp1865_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","onda neka odbije godine otkako je prodao, pa šta ostane neka isplati onom kome je prodao, i tako neka opet dođe do svoje baštine. ");
INSERT INTO srp1865_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ako li nema koliko bi trebalo vratiti, onda ostaje stvar prodana u onog koji je kupio do godine oprosne, a oprosne godine ostaviće se, i on će se vratiti na svoju baštinu. ");
INSERT INTO srp1865_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ko proda kuću u kojoj se sedi u mestu ograđenom zidom, vlastan je otkupiti je dokle se ne navrši godina dana od kako je proda; celu godinu dana ima vlast otkupiti je. ");
INSERT INTO srp1865_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","A ako ne otkupi za godinu dana, onda ostaje kuća u mestu ograđenom zidom onom koji je kupio sasvim od kolena na koleno, i neće je ostaviti oprosne godine. ");
INSERT INTO srp1865_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","A kuće po selima, koje nisu ograđene zidom, neka se uzimaju kao njive, mogu se otkupiti, i godine oprosne vraćaju se. ");
INSERT INTO srp1865_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","A mesta levitska i kuće u mestima njihovim, svagda mogu otkupiti Leviti. ");
INSERT INTO srp1865_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ali ko kupi od Levita, neka oprosne godine ostavi kupljenu kuću i šta je imao u mestu; jer kuće po mestima levitskim jesu njihove među sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ali polje pod mestima njihovim da se ne prodaje; jer je njihovo dostojanje doveka. ");
INSERT INTO srp1865_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ako osiromaši brat tvoj i iznemogne ruka njegova pored tebe, prihvati ga, i kao stranac i došljak neka poživi uz tebe. ");
INSERT INTO srp1865_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Nemoj uzimati od njega kamate ni dobiti; nego se boj Boga, da bi poživeo brat tvoj uz tebe. ");
INSERT INTO srp1865_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Novaca nemoj mu davati na kamatu, niti mu hrane svoje pozaimaj radi dobiti. ");
INSERT INTO srp1865_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ja sam Gospod Bog vaš, koji sam vas izveo iz zemlje misirske da vam dam zemlju hanansku i da vam budem Bog. ");
INSERT INTO srp1865_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","I ako osiromaši brat tvoj kod tebe tako da ti se proda, nemoj ga držati kao roba; ");
INSERT INTO srp1865_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","kao najamnik i kao došljak neka bude kod tebe; do oprosne godine neka služi kod tebe. ");
INSERT INTO srp1865_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","A onda neka ide od tebe sa sinovima svojim, neka se vrati u rod svoj, i na baštinu otaca svojih neka se vrati. ");
INSERT INTO srp1865_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Jer su moje sluge, koje sam izveo iz zemlje misirske, neka se ne prodaju kao robovi. ");
INSERT INTO srp1865_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nemoj gospodariti nad njim žestoko, nego se boj Boga svog. ");
INSERT INTO srp1865_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","A rob tvoj i robinja tvoja što ćeš imati neka budu od onih naroda koji će biti oko vas, od njih kupujte roba i robinju. ");
INSERT INTO srp1865_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","I između stranaca koji budu kod vas, između njih kupujte i iz porodica onih koji budu kod vas, koji se rode u zemlji vašoj, i ti neka vam budu imanje. ");
INSERT INTO srp1865_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Oni će postati vaši i sinova vaših nakon vas, i biće vam dostojanje, da vam svaku službu vrše do veka; ali nad braćom svojom, sinovima Izrailjevim, niko nad bratom svojim da ne gospodari žestoko. ");
INSERT INTO srp1865_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ako li se obogati došljak ili gost koji živi s tobom, a brat tvoj osiromaši kod njega tako da se proda došljaku, koji živi s tobom, ili kome god od tuđeg roda, ");
INSERT INTO srp1865_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","kad se proda, može se otkupiti; ko god od braće njegove neka ga otkupi; ");
INSERT INTO srp1865_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ili stric njegov, ili sin strica njegovog neka ga otkupi, ili ko drugi od krvi njegove u rodu njegovom neka ga otkupi; ili ako se pomogne, neka se sam otkupi. ");
INSERT INTO srp1865_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Neka se proračuna s kupcem svojim od godine kad se prodao godine oprosne, da cena za koju se prodao dođe prema broju godina; kao nadničaru neka mu se računa vreme koje je odslužio. ");
INSERT INTO srp1865_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ako ostaje još mnogo godina, prema njima neka plati otkup od cene za koju je kupljen. ");
INSERT INTO srp1865_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ako li ostaje malo godina do oprosne godine, neka se proračuna s njim, i neka plati otkup prema tim godinama. ");
INSERT INTO srp1865_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kao najamnik godišnji neka bude u njega, i neka ne gospodari nad njim žestoko na tvoje oči. ");
INSERT INTO srp1865_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ako li se ovako ne otkupi, neka otide godine oprosne i on i sinovi njegovi s njim. ");
INSERT INTO srp1865_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Jer su sinovi Izrailjevi moje sluge, moje su sluge, koje sam izveo iz zemlje misirske; ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Nemojte graditi sebi idola ni likova rezanih, niti stupova podižite, ni kamena sa slikama mećite u svojoj zemlji da mu se klanjate; jer sam ja Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Držite subote moje, i svetinju moju poštujte; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ako uzživite po mojim uredbama, i zapovesti moje uzdržite i uščinite, ");
INSERT INTO srp1865_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","davaću vam dažd na vreme, i zemlja će rađati rod svoj, i drveta će u polju rađati rod svoj; ");
INSERT INTO srp1865_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","i vršidba će vam stizati berbu vinogradsku, a berba će vinogradska stizati sejanje, i ješćete hleb svoj do sitosti, i živećete bez straha u zemlji svojoj. ");
INSERT INTO srp1865_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Jer ću dati mir zemlji, te ćete spavati a neće biti nikoga da vas plaši; učiniću, te će nestati zle zveri iz zemlje, i mač neće prolaziti preko vaše zemlje. ");
INSERT INTO srp1865_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Nego ćete terati neprijatelje svoje, i padaće pred vama od mača. ");
INSERT INTO srp1865_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Vas će petorica terati stotinu, a vas stotina teraće deset hiljada, i padaće neprijatelji vaši pred vama od mača. ");
INSERT INTO srp1865_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","I obratiću se k vama, i učiniću vam da rastete, i umnožiću vas, i utvrdiću zavet svoj s vama. ");
INSERT INTO srp1865_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","I ješćete žito staro, od mnogo godina, i izasipaćete staro kad dođe novo. ");
INSERT INTO srp1865_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","I namestiću stan svoj među vama, i duša moja neće mrzeti na vas. ");
INSERT INTO srp1865_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I hodiću među vama, i biću vam Bog, i vi ćete biti moj narod. ");
INSERT INTO srp1865_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ja sam Gospod Bog vaš, koji vas izvedoh iz zemlje misirske da im ne robujete, i polomih palice jarma vašeg, i ispravih vas da hodite pravo. ");
INSERT INTO srp1865_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ako li me ne uzaslušate, i ne učinite sve ove zapovesti, ");
INSERT INTO srp1865_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ako povrgnete uredbe moje i duši vašoj omrznu zakoni moji da ne tvorite sve zapovesti moje, i raskinete zavet moj, ");
INSERT INTO srp1865_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","i ja ću vama učiniti ovo: Pustiću na vas strah, suvu bolest i vrućicu, koje će vam oči iskvariti i dušu ucveliti; i zaludu ćete sejati seme svoje, jer će ga jesti neprijatelji vaši. ");
INSERT INTO srp1865_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I okrenuću lice svoje nasuprot vama, i seći će vas neprijatelji vaši, i koji mrze na vas biće vam gospodari, i bežaćete kad vas niko ne tera. ");
INSERT INTO srp1865_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ako me ni tada ne stanete slušati, karaću vas još sedam puta više za grehe vaše. ");
INSERT INTO srp1865_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Potrću ponos sile vaše, i učiniću da nebo nad vama bude kao gvožđe, a zemlja vaša kao bronza. ");
INSERT INTO srp1865_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Snaga će se vaša trošiti uzalud, jer zemlja vaša neće rađati roda svog, i drveta po zemlji neće rađati roda svog. ");
INSERT INTO srp1865_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ako mi uzidete nasuprot i ne budete hteli slušati me, dodaću vam sedam puta više muka prema gresima vašim. ");
INSERT INTO srp1865_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Pustiću na vas zveri poljske, koje će vam decu izjesti, i stoku potrti i vas umaliti, i opusteće putevi vaši. ");
INSERT INTO srp1865_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Ako se ni od toga ne popravite, nego mi još uzidete nasuprot, ");
INSERT INTO srp1865_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","i ja ću vama ići nasuprot, i biću vas još sedam puta više za grehe vaše. ");
INSERT INTO srp1865_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Pustiću na vas mač, koji će osvetiti moj zavet; a kad se sležete u gradove svoje, tada ću pustiti pomor među vas, i bićete predani u ruke neprijatelju. ");
INSERT INTO srp1865_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","I kad vam slomim potporu u hlebu, deset će žena peći hleb vaš u jednoj peći, i davaće vam hleb vaš na meru, i ješćete a nećete se nasititi. ");
INSERT INTO srp1865_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ako me ni tako ne stanete slušati, nego mi uzidete nasuprot, ");
INSERT INTO srp1865_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","i ja ću vama s gnevom ići nasuprot, i sedam puta većma karaću vas za grehe vaše. ");
INSERT INTO srp1865_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","I ješćete meso od sinova svojih, i meso od kćeri svojih ješćete. ");
INSERT INTO srp1865_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Razvaliću visine vaše, i oboriću idole vaše, i metnuću trupove vaše na trupove gadnih bogova vaših, i mrziće duša moja na vas. ");
INSERT INTO srp1865_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I obratiću gradove vaše u pustoš, i razoriću svetinje vaše, i neću više mirisati mirisa vašeg. ");
INSERT INTO srp1865_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I opusteću zemlju da će joj se čuditi neprijatelji vaši, koji će živeti u njoj. ");
INSERT INTO srp1865_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","A vas ću rasejati po narodima, i učiniću da vas gone s golim mačem; i zemlja će vaša biti pusta i gradovi vaši raskopani. ");
INSERT INTO srp1865_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Tada će zemlji biti mile subote njene za sve vreme dokle bude pusta; i kad budete u zemlji svojih neprijatelja, zemlja će počivati, i biće joj mile subote njene. ");
INSERT INTO srp1865_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Za sve vreme dokle bude pusta počivaće, jer nije počivala u vaše subote, kad ste u njoj živeli. ");
INSERT INTO srp1865_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","A koji vas ostanu, metnuću strah u srca njihova u zemljama neprijatelja njihovih, te će ih goniti list kad šušne zaljuljavši se, i oni će bežati kao ispred mača, i padaće a niko ih neće terati. ");
INSERT INTO srp1865_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","I padaće jedan preko drugog kao od mača, a niko ih neće terati; i nećete se moći držati pred neprijateljima svojim. ");
INSERT INTO srp1865_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Nego ćete izginuti među narodima, i proždreće vas zemlja neprijatelja vaših. ");
INSERT INTO srp1865_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","A koji vas ostanu, čileće za bezakonje svoje u zemlji neprijatelja svojih, i za bezakonje otaca svojih čileće. ");
INSERT INTO srp1865_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ali ako priznadu bezakonje svoje i bezakonje otaca svojih po gresima, kojima mi grešiše i kojima mi idoše nasuprot, ");
INSERT INTO srp1865_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","te i ja njima idoh nasuprot i odvedoh ih u zemlju neprijatelja njihovih; ako se tada ponizi srce njihovo neobrezano, i bude im pravo što su pokarani za bezakonje svoje, ");
INSERT INTO srp1865_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","tada ću se opomenuti zaveta svog s Jakovom, i zaveta svog sa Isakom, i zaveta svog sa Avramom opomenuću se, i zemlje ću se opomenuti. ");
INSERT INTO srp1865_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Kada se zemlja oprosti njih i budu joj mile subote njene kad opusti s njih, i njima bude pravo što su pokarani za bezakonje svoje, jer sudove moje povrgoše i duši njihovoj omrzoše uredbe moje. ");
INSERT INTO srp1865_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","A zato ni onda kad budu u zemlji neprijatelja svojih neću ih povrći niti ću tako omrznuti na njih da ih potrem i raskinem zavet svoj sa njima; jer sam ja Gospod Bog njihov. ");
INSERT INTO srp1865_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nego ću se njih radi opomenuti zaveta sa starima njihovim, koje izvedoh iz zemlje misirske narodima na vidiku da im budem Bog, ja Gospod. ");
INSERT INTO srp1865_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ovo su uredbe i sudovi i zakoni, koje postavi Gospod između sebe i sinova Izrailjevih na gori sinajskoj preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Kaži sinovima Izrailjevim, i reci im: Kad ko zavetuje dušu svoju Gospodu, ti ga uceni: ");
INSERT INTO srp1865_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","A ovako ćeš ceniti: muško od dvadeset godina do šezdeset cenićeš pedeset sikala srebra, po siklu svetom. ");
INSERT INTO srp1865_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ako bude žensko, cenićeš trideset sikala. ");
INSERT INTO srp1865_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ako je od pet do dvadeset godina, cenićeš muško dvadeset sikala a žensko deset sikala. ");
INSERT INTO srp1865_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ako je od jednog meseca do pet godina, cenićeš muško pet sikala srebra, a žensko ćeš ceniti tri sikla srebra. ");
INSERT INTO srp1865_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ako li bude od šezdeset godina i više, ako je muško, cenićeš petnaest sikala, a žensko deset sikala. ");
INSERT INTO srp1865_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ako je siromah da ne može platiti cenu, onda neka dođe k svešteniku da ga uceni sveštenik, i prema onome što može dati koji se zavetovao, neka ga sveštenik uceni. ");
INSERT INTO srp1865_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ako bi zavetovao živinče od onih što se prinose Gospodu, šta god da Gospodu, sveto je. ");
INSERT INTO srp1865_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Da ga ne promeni ni dade drugo za ono, ni dobro za rđavo, ni rđavo za dobro; ako li bi kako promenio živinče, onda će biti sveto i ono i drugo koje je dao za ono. ");
INSERT INTO srp1865_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ako li bi zavetovao živinče nečisto od onih što se ne prinose Gospodu, neka se dovede živinče pred sveštenika; ");
INSERT INTO srp1865_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","i neka ga proceni sveštenik, bilo dobro ili rđavo; i kako ga proceni sveštenik, tako da bude. ");
INSERT INTO srp1865_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ako bi ga hteo otkupiti, neka na cenu tvoju dometne još peti deo. ");
INSERT INTO srp1865_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Kad bi ko zavetovao kuću svoju, da je sveta Gospodu, neka je proceni sveštenik, bila dobra ili rđava; kako je proceni sveštenik, tako da bude. ");
INSERT INTO srp1865_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ako bi onaj koji zavetuje hteo otkupiti kuću svoju, neka na cenu tvoju dometne još peti deo, pa neka je njegova. ");
INSERT INTO srp1865_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ako bi ko zavetovao Gospodu deo njive svoje, cenićeš je prema usevu: gomer ječma gde se poseje, cenićeš pedeset sikala srebra. ");
INSERT INTO srp1865_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ako bi od oprosne godine zavetovao njivu svoju, neka ostane po tvojoj ceni. ");
INSERT INTO srp1865_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ako li posle oprosne godine zavetuje njivu svoju, tada neka mu sveštenik proračuna novce prema broju godina koje ostaju do oprosne godine, i neka se odbije do tvoje cene. ");
INSERT INTO srp1865_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","I ako bi hteo otkupiti njivu svoju onaj koji je zavetuje, neka dometne na cenu tvoju još peti deo, i neka bude njegova. ");
INSERT INTO srp1865_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ali ako ne otkupi njive, i njiva se proda drugom, ne može se više otkupiti; ");
INSERT INTO srp1865_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","nego će ona njiva, kad se oprosti oprosne godine, biti sveta Gospodu, kao njiva zavetovana, sveštenikova neka bude. ");
INSERT INTO srp1865_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Ako li bi ko zavetovao Gospodu njivu kupljenu, koja nije dostojanje njegovo, ");
INSERT INTO srp1865_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","sveštenik neka mu proračuna cenu do godine oprosne, i neka u onaj dan da tu cenu da bude stvar sveta Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","A godine oprosne da se vrati njiva onome od koga je kupljena, čije je dostojanje ona njiva. ");
INSERT INTO srp1865_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","A svaka cena tvoja neka bude na sikle svete, a u siklu ima dvadeset novaca. ");
INSERT INTO srp1865_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ali prvina od stoke, koje su Gospodnje, niko da ne zavetuje, bilo goveče ili sitna stoka, jer je Gospodnje. ");
INSERT INTO srp1865_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ako li bi bilo od životinja nečistih, onda neka otkupi po tvojoj ceni dometnuv peti deo odozgo; ako li se ne otkupi, neka se proda po tvojoj ceni. ");
INSERT INTO srp1865_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ali ni jedna stvar zavetovana, šta ko zavetuje Gospodu od čega mu drago što ima, od ljudi ili od stoke ili od njive svoje, da se ne prodaje ni otkupljuje; svaka stvar zavetovana svetinja je nad svetinjama Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Živinče zavetovano, koje čovek zavetuje, da se ne otkupljuje, nego da se ubije. ");
INSERT INTO srp1865_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","I svaki desetak zemaljski od useva zemaljskog i od voća, Gospodnji je, svetinja je Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ali, ko bi hteo otkupiti šta desetka svog, neka na cenu dometne još peti deo. ");
INSERT INTO srp1865_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","I desetak od goveda i od sitne stoke, koje dođe pod štap pastirski deseto, da je sveto Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Da se ne bira dobro ni rđavo, da se ne menja; ako li bi se kako god promenilo, onda neka bude i ono i drugo promenjeno sveta stvar, i da se ne otkupi. ");
INSERT INTO srp1865_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ovo su zapovesti koje zapovedi Gospod Mojsiju za sinove Izrailjeve na gori sinajskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Još reče Gospod Mojsiju u pustinji sinajskoj u šatoru od sastanka prvi dan drugog meseca druge godine po izlasku njihovom iz zemlje misirske, govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Izbrojte sav zbor sinova Izrailjevih po porodicama njihovim i po domovima otaca njihovih i po imenima njihovim, sve muškinje, glavu po glavu, ");
INSERT INTO srp1865_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","od dvadeset godina i više, sve koji mogu ići na vojsku u Izrailju, izbrojte ih po četama njihovim ti i Aron; ");
INSERT INTO srp1865_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","a s vama neka bude po jedan čovek od svakog plemena, koji je poglavar u domu otaca svojih. ");
INSERT INTO srp1865_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","A ovo su imena ljudi koji će biti s vama: od plemena Ruvimovog Elisur sin Sedijurov; ");
INSERT INTO srp1865_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","od Simeunovog Salamilo sin Surisadajev; ");
INSERT INTO srp1865_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","od Judinog Nason sin Aminadavov; ");
INSERT INTO srp1865_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","od Isaharovog Natanailo sin Sogarov; ");
INSERT INTO srp1865_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","od Zavulonovog Elijav Sin Helonov; ");
INSERT INTO srp1865_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","od sinova Josifovih: od plemena Jefremovog Elisama sin Emijudov; od Manasijinog Gamalilo sin Fadasurov; ");
INSERT INTO srp1865_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","od Venijaminovog Avidan sin Gadeonijev; ");
INSERT INTO srp1865_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","od Danovog Ahijezer sin Amisadajev; ");
INSERT INTO srp1865_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","od Asirovog Fagailo sin Ehranov; ");
INSERT INTO srp1865_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","od Gadovog Elisaf sin Raguilov; ");
INSERT INTO srp1865_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","od Neftalimovog Ahirej sin Enanov. ");
INSERT INTO srp1865_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","To su koji se sazivahu na zbor, knezovi u plemenima otaca svojih, hiljadnici Izrailjevi. ");
INSERT INTO srp1865_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","I uze Mojsije i Aron te ljude, koji biše imenovani. ");
INSERT INTO srp1865_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","I sabraše sav zbor prvi dan drugog meseca, i prepisaše ih po porodicama njihovim i po domovima otaca njihovih i po imenima njihovim od dvadeset godina i više, glavu po glavu. ");
INSERT INTO srp1865_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Kako beše Gospod zapovedio Mojsiju, tako ih izbroja u pustinji sinajskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","I beše sinova prvenca Izrailjevog Ruvima, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbroja po imenima s glave na glavu sve muškinje od dvadeset godina i više, što mogaše ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","beše ih izbrojanih od plemena Ruvimovog četrdeset i šest hiljada i pet stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Sinova Simeunovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbroja po imenima s glave na glavu sve muškinje od dvadeset godina i više, što mogaše ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","beše ih izbrojanih od plemena Simeunovog pedeset i devet hiljada i tri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Sinova Gadovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","beše ih izbrojanih od plemena Gadovog četrdeset i pet hiljada, šest stotina i pedeset. ");
INSERT INTO srp1865_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Sinova Judinih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","beše ih izbrojanih od plemena Judinog sedamdeset i četiri hiljade i šest stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Sinova Isaharovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","beše ih izbrojanih od plemena Isaharovog pedeset i četiri hiljade i četiri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Sinova Zavulonovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","beše ih izbrojanih od plemena Zavulonovog pedeset i sedam hiljada i četiri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Od sinova Josifovih: sinova Jefremovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","beše ih izbrojanih od plemena Jefremovog četrdeset hiljada i pet stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Sinova Manasijinih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","beše ih izbrojanih od plemena Manasijinog trideset i dve hiljade i dvesta. ");
INSERT INTO srp1865_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Sinova Venijaminovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","beše ih izbrojanih od plemena Venijaminovog trideset i pet hiljada i četiri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Sinova Danovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","beše ih izbrojanih od plemena Danovog šezdeset dve hiljade i sedam stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Sinova Asirovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","beše ih izbrojanih od plemena Asirovog četrdeset i jedna hiljada i pet stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Sinova Neftalimovih, roda njihovog po porodicama njihovim i po domovima otaca njihovih, kad se izbrojaše po imenima od dvadeset godina i više svi što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","beše ih izbrojanih od plemena Neftalimovog pedeset i tri hiljade i četiri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ovo su oni koje Mojsije i Aron izbrojaše s knezovima izrailjskim, s dvanaest ljudi, koji behu po jedan za svaki dom otaca svojih. ");
INSERT INTO srp1865_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","I svega beše sinova Izrailjevih izbrojanih po domovima otaca svojih od dvadeset godina i više, svih što mogahu ići na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","beše ih izbrojanih šest stotina i tri hiljade i pet stotina i pedeset. ");
INSERT INTO srp1865_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ali Leviti po plemenu otaca svojih ne biše brojani među njih. ");
INSERT INTO srp1865_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Jer Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Plemena Levijevog nemoj brojati, niti broj njihov sastaviti sa sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Nego postavi Levite nad šatorom od svedočanstva i nad svim posuđem u njemu i nad svim što pripada njemu; oni neka nose šator i sve posuđe njegovo, neka služe u njemu, i staju oko šatora. ");
INSERT INTO srp1865_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","I kad se šator krene, neka ga slože Leviti; i kad šator stane, onda neka ga razapnu Leviti. A ko bi drugi pristupio da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","I sinovi Izrailjevi neka staju svaki u svom logoru i svaki kod svoje zastave po četama svojim. ");
INSERT INTO srp1865_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","A Leviti neka staju oko šatora od svedočanstva, da ne dođe gnev na zbor sinova Izrailjevih; i neka Leviti rade šta treba oko šatora od svedočanstva. ");
INSERT INTO srp1865_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","I učiniše sinovi Izrailjevi kako Gospod zapovedi, sve tako učiniše. ");
INSERT INTO srp1865_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Potom reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Sinovi Izrailjevi neka staju u oko svaki kod svoje zastave sa znakom doma otaca svojih, prema šatoru od sastanka unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","S istoka neka staje u oko zastava vojske Judine po četama svojim s vojvodom sinova Judinih Nasonom sinom Aminadavovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","a u vojsci njegovoj sedamdeset i četiri hiljade i šest stotina izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","A do njega neka staje u logor pleme Isaharovo s vojvodom sinova Isaharovih Natanailom, sinom Sogarovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","a u vojsci njegovoj pedeset i četiri hiljade i četiri stotine izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Pa onda pleme Zavulonovo s vojvodom sinova Zavulonovih Elijavom, sinom Helonovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","a u vojsci njegovoj pedeset i sedam hiljada i četiri stotine izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Svega izbrojanih u vojsci Judinoj sto i osamdeset i šest hiljada i četiri stotine po četama njihovim. Oni neka idu napred. ");
INSERT INTO srp1865_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","A zastava vojske Ruvimove po četama svojim neka bude s juga, s vojvodom sinova Ruvimovih Elisurom sinom Sedijurovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","a u vojsci njegovoj četrdeset i šest hiljada i pet stotina izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","A do njega neka staje u logor pleme Simeunovo s vojvodom sinova Simeunovih Salamilom sinom Surisadajevim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","a u vojsci njegovoj pedeset i devet hiljada i tri stotine izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Pa onda pleme Gadovo s vojvodom sinova Gadovih Elisafom, sinom Raguilovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","a u vojsci njegovoj četrdeset i pet hiljada i šest stotina i pedeset izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","A svega izbrojanih u vojsci Ruvimovoj sto i pedeset i jedna hiljada i četiri stotine i pedeset po četama njihovim. I oni neka idu drugi. ");
INSERT INTO srp1865_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Potom neka ide šator od sastanka s vojskom sinova Levijevih usred ostale vojske; kako u logor staju tako neka i idu, svaki svojim redom pod svojom zastavom. ");
INSERT INTO srp1865_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Zastava vojske Jefremove po četama svojim neka bude sa zapada, s vojvodom sinova Jefremovih Elisamom sinom Emijudovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","a u vojsci njegovoj četrdeset hiljada i pet stotina izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","A do njega pleme Manasijino s vojvodom sinova Manasijinih, Gamalilom, sinom Fadasurovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","a u njegovoj vojsci trideset i dve hiljade i dvesta izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Pa onda pleme Venijaminovo s vojvodom sinova Venijaminovih, Avidanom sinom Gadeonijevim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","a u vojsci njegovoj trideset i pet hiljada i četiri stotine izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","A svega izbrojanih u vojsci Jefremovoj sto i osam hiljada i sto po četama njihovim. I oni neka idu treći. ");
INSERT INTO srp1865_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Zastava vojske Danove po četama svojim neka bude sa severa s vojvodom sinova Danovih Ahijezerom, sinom Amisadajevim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","a u vojsci njegovoj šezdeset i dve hiljade i sedam stotina izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","A do njega neka staje u logor pleme Asirovo s vojvodom sinova Asirovih Fagailom, sinom Ehranovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","a u vojsci njegovoj četrdeset i jedna hiljada i pet stotina izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Za njima pleme Neftalimovo s vojvodom sinova Neftalimovih Ahirejem, sinom Enanovim; ");
INSERT INTO srp1865_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","a u njegovoj vojsci pedeset i tri hiljade i četiri stotine izbrojanih. ");
INSERT INTO srp1865_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","A svega izbrojanih u vojsci Danovoj sto i pedeset i sedam hiljada i šest stotina. I oni neka idu najposle uza zastave svoje. ");
INSERT INTO srp1865_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","To su sinovi Izrailjevi koji biše izbrojani po domovima otaca svojih. Svega izbrojanih u celoj vojsci po četama njihovim šest stotina i tri hiljade i pet stotina i pedeset. ");
INSERT INTO srp1865_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ali Leviti ne biše brojani među sinove Izrailjeve, kao što Gospod beše zapovedio Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","I učiniše sinovi Izrailjevi sve; kako zapovedi Gospod Mojsiju, tako stajahu u logor, i tako iđahu svaki po porodici svojoj i po domu otaca svojih. ");
INSERT INTO srp1865_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","A ovo je pleme Aronovo i Mojsijevo, kad Gospod govori s Mojsijem na gori sinajskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","I ovo su imena sinova Aronovih: prvenac Nadav, pa Avijud i Eleazar i Itamar. ");
INSERT INTO srp1865_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","To su imena sinova Aronovih, sveštenika, koji biše pomazani i posvećeni da vrše službu svešteničku. ");
INSERT INTO srp1865_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ali pogibe Nadav i Avijud pred Gospodom, kad prinesoše oganj tuđ pred Gospodom u pustinji sinajskoj; i ne imaše dece; zato Eleazar i Itamar otpravljahu službu svešteničku za života Arona, oca svog. ");
INSERT INTO srp1865_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","A Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Kaži neka pristupi pleme Levijevo, i postavi ga pred Aronom sveštenikom da mu služe, ");
INSERT INTO srp1865_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","i da rade za nj i za sav zbor pred šatorom od sastanka služeći šatoru, ");
INSERT INTO srp1865_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","i da čuvaju sve posuđe u šatoru od sastanka, i da straže za sinove Izrailjeve služeći šatoru. ");
INSERT INTO srp1865_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Pa ćeš dati Levite Aronu i sinovima njegovim; oni su darovani njemu između sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","A Arona i sinove njegove postavi da vrše svešteničku službu svoju; ako li bi ko drugi pristupio, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Evo uzeh Levite između sinova Izrailjevih za sve prvence što otvaraju matericu među sinovima Izrailjevim; zato će moji biti Leviti. ");
INSERT INTO srp1865_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Jer je moj svaki prvenac; od onog dana kada pobih sve prvence u zemlji misirskoj, posvetih sebi svakog prvenca u Izrailju od čoveka do živinčeta; moji će biti; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Još reče Gospod Mojsiju u pustinji sinajskoj govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Izbroj sinove Levijeve po domovima otaca njihovih, po porodicama njihovim, sve muškinje od meseca dana i više izbroj. ");
INSERT INTO srp1865_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","I Mojsije ih izbroja po zapovesti Gospodnjoj, kako mu bi zapoveđeno. ");
INSERT INTO srp1865_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","I behu sinovi Levijevi po imenu ovi: Girson i Kat i Merarije. ");
INSERT INTO srp1865_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","A ovo su imena sinova Girsonovih po porodicama njihovim: Lovenije i Semej. ");
INSERT INTO srp1865_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","A sinovi Katovi po porodicama svojim: Amram i Isar, Hevron i Ozilo. ");
INSERT INTO srp1865_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","A sinovi Merarijevi po porodicama svojim: Malije i Musije. To su porodice levitske po domovima otaca svojih. ");
INSERT INTO srp1865_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Od Girsona porodica Lovenijeva i porodica Semejeva. To su porodice Girsonove. ");
INSERT INTO srp1865_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","A izbrojanih među njima, kad se izbroja sve muškinje od meseca dana i više, beše ih izbrojanih svega sedam hiljada i pet stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Porodice Girsonove stajahu u logor iza šatora sa zapada. ");
INSERT INTO srp1865_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","A starešina od doma otačkog u porodicama Girsonovim beše Elisaf, sin Dailov. ");
INSERT INTO srp1865_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","A sinovi Girsonovi čuvahu u šatoru od sastanka šator i naslon, pokrivač njegov i zaves na vratima šatora od sastanka, ");
INSERT INTO srp1865_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","i zavese od trema i zaves na vratima od trema što je oko šatora i oko oltara, i uža njegova za svaku potrebu njegovu. ");
INSERT INTO srp1865_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","A od Kata beše porodica Amramova i porodica Isarova i porodica Hevronova i porodica Ozilova. To su porodice Katove. ");
INSERT INTO srp1865_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Svega muškinja od meseca dana i više beše na broj osam hiljada i šest stotina, koji služahu oko svetinje. ");
INSERT INTO srp1865_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Porodice sinova Katovih stajahu u logor pored šatora s juga. ");
INSERT INTO srp1865_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","A starešina od doma otačkog u porodicama Katovim beše Elisafan, sin Ozilov. ");
INSERT INTO srp1865_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","A oni čuvahu kovčeg i sto i svećnjak i oltar i posuđe u svetinji kojim služe, i zaves, i sve što pripada k njemu. ");
INSERT INTO srp1865_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","A starešina nad starešinama levitskim beše Eleazar, sin Arona sveštenika, postavljen nad onima koji čuvaju svetinju. ");
INSERT INTO srp1865_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","A od Merarija beše porodica Malijeva i porodica Musijeva. To su porodice Merarijeve. ");
INSERT INTO srp1865_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","I beše ih izbrojanih, kad se izbroja sve muškinje od meseca dana i više, šest hiljada i dvesta. ");
INSERT INTO srp1865_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","A starešina od doma otačkog u porodicama Merarijevim beše Surilo sin Avihejev; oni stajahu u logor pored šatora sa severa. ");
INSERT INTO srp1865_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","I sinovi Merarijevi čuvahu daske od šatora i prevornice njegove i stupce njegove i stopice njegove i sve sprave njegove i sve što k njemu pripada, ");
INSERT INTO srp1865_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","i stupce od trema unaokolo i stopice njihove i kolje i uža njihova. ");
INSERT INTO srp1865_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","A pred šatorom od sastanka s istoka stajahu u logor Mojsije i Aron i sinovi njegovi čuvajući svetinju za sinove Izrailjeve; a da ko drugi pristupi, poginuo bi. ");
INSERT INTO srp1865_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","A svega Levita kad ih izbroja Mojsije i Aron po zapovesti Gospodnjoj po porodicama njihovim, svega muškinja od mesec dana i više, beše dvadeset i dve hiljade. ");
INSERT INTO srp1865_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","I Gospod reče Mojsiju: Izbroj sve prvence muške među sinovima Izrailjevim od meseca dana i više, i saberi broj imena njihovih. ");
INSERT INTO srp1865_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","I uzmi Levite za mene (ja sam Gospod) mesto svih prvenaca među sinovima Izrailjevim, i stoku levitsku mesto svih prvenaca od stoke sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","I izbroja Mojsije kako mu zapovedi Gospod, sve prvence među sinovima Izrailjevim; ");
INSERT INTO srp1865_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","i svega prvenaca muških, kad se izbrojaše po imenima od jednog meseca i više, beše izbrojanih dvadeset i dve hiljade i dvesta i sedamdeset i tri. ");
INSERT INTO srp1865_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","I Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Uzmi Levite mesto svih prvenaca među sinovima Izrailjevim i stoku levitsku mesto stoke njihove, da budu moji Leviti; ja sam Gospod. ");
INSERT INTO srp1865_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A da se otkupe oni dvesta i sedamdeset i tri, što ima prvenaca među sinovima Izrailjevim više nego Levita, ");
INSERT INTO srp1865_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","uzmi po pet sikala od glave; uzmi po svetom siklu (a u taj sikal ide dvadeset gera). ");
INSERT INTO srp1865_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","I podaj te novce Aronu i sinovima njegovim, otkup za one koji prelaze broj njihov. ");
INSERT INTO srp1865_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","I uze Mojsije otkup od onih koji ostaše preko onih koji biše promenjeni za Levite. ");
INSERT INTO srp1865_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","I uze novce od prvenaca sinova Izrailjevih, hiljadu i trista i šezdeset i pet sikala, po svetom siklu. ");
INSERT INTO srp1865_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","I dade Mojsije taj otkup Aronu i sinovima njegovim po zapovesti Gospodnjoj, kao što zapovedi Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Još reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Izbroj sinove Katove između sinova Levijevih po porodicama njihovim i po domovima otaca njihovih. ");
INSERT INTO srp1865_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Od trideset godina i više do pedesete sve koji su za posao da mogu raditi poslove u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","A ovo će biti posao sinovima Katovim u šatoru od sastanka u svetinji nad svetinjama: ");
INSERT INTO srp1865_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kad polazi vojska, doći će Aron sa sinovima svojim, i skinuće zaves s vrata, i pokriće njim kovčeg od svedočanstva. ");
INSERT INTO srp1865_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Pa će po njemu prostreti pokrivač od koža jazavičijih, i odozgo će prostreti prostirač od same porfire, i provući će mu poluge. ");
INSERT INTO srp1865_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","I po stolu za hlebove postavljene neka prostru prostirač od porfire, i neka metnu na nj zdele i čaše i vedra i kotliće, i hleb svagda neka je na njemu. ");
INSERT INTO srp1865_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Pa vrh toga neka prostru prostirač od crvca, i neka pokriju pokrivačem od koža jazavičijih, i neka mu provuku poluge. ");
INSERT INTO srp1865_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","I neka uzmu prostirač od porfire i pokriju svećnjak i žiške njegove i usekače njegove lopatice njegove i sve sudove za ulje, kojima služe oko njega. ");
INSERT INTO srp1865_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","I neka ga sa svim spravama njegovim zaviju u pokrivač od koža jazavičijih, i metnu ga na poluge. ");
INSERT INTO srp1865_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","I po zlatnom oltaru neka prostru prostirač od porfire i pokriju ga pokrivačem od koža jazavičijih, i provuku mu poluge. ");
INSERT INTO srp1865_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","I nek uzmu sve sprave za službu, kojima služe u svetinji, i neka ih metnu u prostirač od porfire i zaviju u pokrivač od koža jazavičijih, i metnu na poluge. ");
INSERT INTO srp1865_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","I neka ometu pepeo s oltara i po oltaru prostru prostirač od skerleta, ");
INSERT INTO srp1865_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","i neka metnu na nj sve sprave njegove, kojima služe na njemu, mašice, viljuške, lopatice i kotliće i sve sprave za oltar, i neka ga pokriju pokrivačem od koža jazavičijih, pa mu provuku poluge. ");
INSERT INTO srp1865_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","I kad to svrši Aron i sinovi njegovi i zaviju svetinju i sve sprave za svetinju, da pođe vojska, onda neka dođu sinovi Katovi da nose, ali neka se ne dotaknu nijedne stvari svete, da ne poginu. To je posao sinova Katovih u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","A Eleazar, sin Arona sveštenika, neka se stara za ulje za videlo, i za kad mirisni, i za žrtvu svagdašnju, i za ulje pomazanja, neka pazi na sav šator i na sve što je u njemu, na svetinju i na posuđe njeno. ");
INSERT INTO srp1865_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","I reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Nemojte da se istrebi koleno porodica Katovih između Levita; ");
INSERT INTO srp1865_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","nego im učinite ovo da bi ostali živi i ne bi pomrli kad pristupaju k svetinji nad svetinjama: Aron i sinovi njegovi neka dođu i odrede svakome šta će koji raditi i šta će nositi. ");
INSERT INTO srp1865_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","A oni neka ne dolaze da gledaju kad se zavijaju svete stvari, da ne pomru. ");
INSERT INTO srp1865_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Izbroj i sinove Girsonove po domovima otaca njihovih i po porodicama njihovim. ");
INSERT INTO srp1865_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Od trideset godina i više do pedeset godina izbroj ih sve koji su za službu da mogu služiti u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ovo je posao porodicama Girsonovim šta će raditi i nositi: ");
INSERT INTO srp1865_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Neka nose zavese od naslona i šator od sastanka, pokrivač njegov i pokrivač od koža jazavičijih što je odozgo na njemu, i zaves na ulasku u šator od sastanka, ");
INSERT INTO srp1865_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","i zavese od trema i zaves na vratima od trema što je oko šatora i oko oltara, i uža njihova i sve posuđe za službu njihovu i šta god treba oko toga raditi neka rade. ");
INSERT INTO srp1865_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Po naredbi Aronovoj i sinova njegovih neka biva sva služba sinova Girsonovih za sve što će nositi i što će raditi, i ostavite im neka čuvaju sve što su dužni nositi. ");
INSERT INTO srp1865_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","To je služba porodica sinova Girsonovih u šatoru od sastanka; a Itamar sin Arona sveštenika neka upravlja njima. ");
INSERT INTO srp1865_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Izbroj i sinove Merarijeve po porodicama njihovim i po domovima otaca njihovih, ");
INSERT INTO srp1865_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","od trideset godina i više do pedeset godina izbroj ih sve koji su za službu da mogu služiti u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","A ovo im je dužnost nositi osim sve službe njihove u šatoru od sastanka: daske od šatora i prevornice njegove i stupce njegove i stopice njegove, ");
INSERT INTO srp1865_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","i stupce od trema unaokolo, i stopice njihove i kolje njihovo, i uža njihova, i sve sprave njihove, i šta god treba za te stvari; a poimence izbrojte sve sprave što će oni nositi. ");
INSERT INTO srp1865_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","To je služba porodica sinova Merarijevih što su dužni raditi u šatoru od sastanka pod rukom Itamara, sina Arona sveštenika. ");
INSERT INTO srp1865_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","I izbroja Mojsije i Aron s knezovima narodnim sinove Katove po porodicama njihovim i po domovima otaca njihovih, ");
INSERT INTO srp1865_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","od trideset godina i više do pedeset godina sve koji su za službu da mogu služiti u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","I beše ih izbrojanih po porodicama njihovim dve hiljade i sedam stotina i pedeset. ");
INSERT INTO srp1865_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","To su izbrojani iz porodica Katovih što behu za službu u šatoru od sastanka, koje izbroja Mojsije i Aron, kao što zapovedi Gospod preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","A sinova Girsonovih po porodicama njihovim i po domovima otaca njihovim i po domovima otaca njihovih beše izbrojanih, ");
INSERT INTO srp1865_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","od trideset godina i više do pedeset godina, svih što behu za službu da služe u šatoru od sastanka, ");
INSERT INTO srp1865_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","beše ih izbrojanih po porodicama njihovim i po domovima otaca njihovih dve hiljade i šest stotina i trideset. ");
INSERT INTO srp1865_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","To su izbrojani iz porodica sinova Girsonovih, što behu za službu u šatoru od sastanka, koje izbroja Mojsije i Aron po zapovesti Gospodnjoj. ");
INSERT INTO srp1865_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","A iz porodica sinova Merarijevih po porodicama njihovim i po domovima otaca njihovih beše izbrojanih, ");
INSERT INTO srp1865_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","od trideset godina i više do pedeset godina, svih što behu za službu da služe u šatoru od sastanka, ");
INSERT INTO srp1865_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","beše ih izbrojanih po porodicama njihovim tri hiljade i dvesta. ");
INSERT INTO srp1865_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","To su izbrojani iz porodica sinova Merarijevih, koje izbroja Mojsije i Aron kao što zapovedi Gospod preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","A svega beše izbrojanih Levita, koje izbroja Mojsije i Aron s knezovima Izrailjevim po porodicama njihovim i po domovima otaca njihovih, ");
INSERT INTO srp1865_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","od trideset godina i više do pedeset godina, što behu za službu da služe i da nose u šatoru od sastanka, ");
INSERT INTO srp1865_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","svega ih beše izbrojanih osam hiljada i pet stotina i osamdeset. ");
INSERT INTO srp1865_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kako Gospod zapovedi preko Mojsija, biše izbrojani, svaki za ono što treba da radi i da nosi; i izbrojani biše oni koje je Gospod zapovedio Mojsiju da se izbroje. ");
INSERT INTO srp1865_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Zapovedi sinovima Izrailjevim neka isteraju iz logora sve gubave i sve kojima teče seme i sve koji su se oskvrnili o mrtvaca, ");
INSERT INTO srp1865_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","bio čovek ili žena, isterajte, iza logora isterajte ih, da ne skvrne logora onima među kojima nastavam. ");
INSERT INTO srp1865_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","I učiniše tako sinovi Izrailjevi, i isteraše ih iz logora, kako Gospod kaza Mojsiju, tako učiniše sinovi Izrailjevi. ");
INSERT INTO srp1865_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Reci sinovima Izrailjevim: Čovek ili žena kad učini kakav greh ljudski, te zgreši Gospodu, i bude ona duša kriva, ");
INSERT INTO srp1865_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","tada neka priznadu greh koji su učinili, i ko je kriv neka vrati celo čim je kriv i nek dometne odozgo peti deo i da onome kome je skrivio. ");
INSERT INTO srp1865_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","I ako onaj nema nikoga kome bi pripala naknada za štetu, neka se da Gospodu i neka bude svešteniku osim ovna za očišćenje kojim će ga očistiti. ");
INSERT INTO srp1865_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Tako i svaki prinos između svih stvari koje posvećuju sinovi Izrailjevi i donose svešteniku, njegov neka bude; ");
INSERT INTO srp1865_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","i šta god ko posveti, neka je njegovo, i šta god ko da svešteniku, neka je njegovo. ");
INSERT INTO srp1865_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Kaži sinovima Izrailjevim i reci im: Čija bi žena zastranila te bi mu zgrešila, ");
INSERT INTO srp1865_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","i drugi bi je obležao, a muž njen ne bi znao, nego bi ona zatajila da se oskvrnila, i ne bi bilo svedoka na nju, niti bi se zatekla, ");
INSERT INTO srp1865_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","a njemu bi došla sumnja ljubavna, te bi iz ljubavi sumnjao na svoju ženu, a ona bi bila oskvrnjena; ili bi mu došla sumnja ljubavna te bi iz ljubavi sumnjao na svoju ženu, a ona ne bi bila oskvrnjena, ");
INSERT INTO srp1865_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","onda neka muž dovede ženu svoju k svešteniku, i neka donese za nju prinos njen, deseti deo efe brašna ječmenog, ali neka ga ne polije uljem i neka ne metne na nj kada, jer je prinos za sumnju ljubavnu, dar za spomen da se spomene greh. ");
INSERT INTO srp1865_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","I neka je sveštenik privede i postavi pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","I neka uzme sveštenik svete vode u sud zemljani; i praha s poda u šatoru neka uzme i uspe u vodu. ");
INSERT INTO srp1865_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","I postavivši sveštenik ženu pred Gospodom neka joj otkrije glavu i metne joj na ruke dar za spomen koji je dar za sumnju ljubavnu; a sveštenik neka drži u ruci svojoj gorku vodu, koja nosi prokletstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","I neka sveštenik zakune ženu, i reče joj: Ako nije niko spavao s tobom, i ako nisi zastranila od muža svog na nečistotu, neka ti ne bude ništa od ove vode gorke, koja nosi prokletstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ako li si zastranila od muža svog i oskvrnila se, i kogod drugi osim muža tvog spavao s tobom, ");
INSERT INTO srp1865_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","tada sveštenik zaklinjući ženu neka je prokune i reče ženi: Da te Gospod postavi za uklin i za kletvu u narodu tvom učinivši da ti bedro spadne a trbuh oteče. ");
INSERT INTO srp1865_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","I neka ti ova voda prokleta uđe u creva da ti oteče trbuh i da ti bedro spadne. A žena neka reče: Amin, amin. ");
INSERT INTO srp1865_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Tada neka napiše sveštenik te kletve u knjigu, i neka ih spere vodom gorkom. ");
INSERT INTO srp1865_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","I neka da ženi da se napije gorke vode proklete da uđe u nju voda prokleta i bude gorka. ");
INSERT INTO srp1865_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","I neka uzme sveštenik iz ruku ženi dar za sumnju ljubavnu, i obrne dar pred Gospodom i prinese ga na oltaru. ");
INSERT INTO srp1865_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","I neka uzme sveštenik u šaku od dara njenog spomen, i zapali na oltaru, pa onda neka da ženi vodu da popije. ");
INSERT INTO srp1865_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","A kad joj da vodu da pije, ako se bude oskvrnila i učinila neveru mužu svom, onda će ući voda prokleta u nju i postaće gorka, i trbuh će joj oteći i spasti bedro, i ona će žena postati uklin u narodu svom. ");
INSERT INTO srp1865_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ako li se ne bude oskvrnila žena, nego bude čista, neće joj biti ništa i imaće dece. ");
INSERT INTO srp1865_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ovo je zakon za sumnju ljubavnu, kad žena zastrani od muža svog i oskvrni se; ");
INSERT INTO srp1865_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ili kad kome dođe sumnja ljubavna te posumnja iz ljubavi na ženu svoju i postavi je pred Gospodom i svrši joj sveštenik sve po ovom zakonu. ");
INSERT INTO srp1865_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","I muž da je prost od greha, ali žena da nosi svoje bezakonje. ");
INSERT INTO srp1865_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Reci sinovima Izrailjevim, i kaži im: Kad čovek ili žena učini zavet nazirejski, da bude nazirej Gospodu, ");
INSERT INTO srp1865_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","neka se uzdržava od vina i silovitog pića, i neka ne pije octa vinskog ni octa od silovitog pića niti kakvog pića od grožđa i neka ne jede grožđa ni novog ni suvog. ");
INSERT INTO srp1865_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Dokle god traje njegovo nazirejstvo neka ne jede ništa od vinove loze, ni zrna ni ljuske. ");
INSERT INTO srp1865_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Dokle traje njegovo nazirejstvo, neka mu britva ne pređe preko glave; dokle se ne navrše dani za koje se učinio nazirej Gospodu, neka bude svet i neka ostavlja kosu na glavi svojoj. ");
INSERT INTO srp1865_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Dokle traju dani za koje se učinio nazirej Gospodu, neka ne pristupa k mrtvacu. ");
INSERT INTO srp1865_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ni za ocem svojim ni za materom svojom ni za bratom svojim ni za sestrom svojom, neka se za njima ne skvrni kad umru; jer je nazirejstvo Boga njegovog na glavi njegovoj. ");
INSERT INTO srp1865_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Dokle god traje nazirejstvo njegovo, svet je Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ako li bi ko umro do njega na prečac, te bi oskvrnio nazirejstvo glave njegove, neka obrije glavu svoju u dan čišćenja svog, sedmi dan neka je obrije. ");
INSERT INTO srp1865_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A osmi dan neka donese dve grlice ili dva golubića svešteniku na vrata šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","I sveštenik neka zgotovi od jednog žrtvu za greh a od drugog žrtvu paljenicu, i neka ga očisti od onog što je zgrešio kod mrtvaca; tako će posvetiti glavu njegovu u taj dan. ");
INSERT INTO srp1865_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","I neka odeli Gospodu dane nazirejstva svog, i donese jagnje od godine za krivicu; a pređašnji dani propadaju, jer mu se oskvrnilo nazirejstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","A ovo je zakon za nazireje: kad se navrše dani nazirejstva njegovog, neka dođe na vrata šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","I neka donese za žrtvu Gospodu jagnje muško od godine zdravo za žrtvu paljenicu, i jagnje žensko od godine zdravo za greh, i ovna zdravog za žrtvu zahvalnu. ");
INSERT INTO srp1865_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","I kotaricu hlebova presnih, kolača od belog brašna zamešanih s uljem, i pogača presnih namazanih uljem, s darom njihovim i s nalivom njihovim. ");
INSERT INTO srp1865_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","A to će sveštenik prineti pred Gospodom i učiniti žrtvu za greh njegov i žrtvu njegovu paljenicu. ");
INSERT INTO srp1865_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","A ovna će prineti na žrtvu zahvalnu Gospodu s kotaricom presnih hlebova; prineće sveštenik i dar njegov i naliv njegov. ");
INSERT INTO srp1865_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Tada nazirej neka obrije glavu svog nazirejstva na vratima šatora od sastanka; i uzevši kosu nazirejstva svog neka je metne u oganj koji je pod žrtvom zahvalnom. ");
INSERT INTO srp1865_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","I sveštenik neka uzme pleće kuvano od ovna i jedan kolač presan iz kotarice i jednu pogaču presnu, i neka metne na ruke nazireju, pošto obrije nazirejstvo svoje. ");
INSERT INTO srp1865_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","I sveštenik neka obrće te stvari na žrtvu obrtanu pred Gospodom; to je svetinja, koja pripada svešteniku osim grudi obrtanih i pleća podignutog; a posle toga nazirej može piti vino. ");
INSERT INTO srp1865_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","To je zakon za nazireja koji se zavetuje, i to je prinos njegov Gospodu za nazirejstvo njegovo, osim onog što bi više mogao učiniti; kakav mu bude zavet kojim se zavetuje, tako neka učini osim zakona svog nazirejstva. ");
INSERT INTO srp1865_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Reci Aronu i sinovima njegovim i kaži: Ovako blagosiljajte sinove Izrailjeve govoreći im: ");
INSERT INTO srp1865_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Da te blagoslovi Gospod i da te čuva! ");
INSERT INTO srp1865_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Da te obasja Gospod licem svojim i bude ti milostiv! ");
INSERT INTO srp1865_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Da Gospod obrati lice svoje k tebi i dade ti mir! ");
INSERT INTO srp1865_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","I neka prizivaju ime moje na sinove Izrailjeve, i ja ću ih blagosloviti. ");
INSERT INTO srp1865_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","I onaj dan kad Mojsije svrši i podiže šator, i kad ga pomaza i osveti sa svim posuđem njegovim i oltar sa svim posuđem njegovim, kad pomaza i osveti, ");
INSERT INTO srp1865_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","donesoše knezovi Izrailjevi, starešine u domovima otaca svojih, knezovi nad plemenima i poglavari od onih koji biše izbrojani, ");
INSERT INTO srp1865_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","donesoše prilog svoj pred Gospoda, šest kola pokrivenih i dvanaest volova, jedna kola dva kneza i po jednog vola svaki, i donesoše pred šator. ");
INSERT INTO srp1865_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","A Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Uzmi to od njih da bude za službu u šatoru od sastanka, i podaj Levitima, svakome prema službi njegovoj. ");
INSERT INTO srp1865_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","I uze Mojsije kola i volove, i dade ih Levitima. ");
INSERT INTO srp1865_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dvoja kola i četiri vola dade sinovima Girsonovim prema službi njihovoj. ");
INSERT INTO srp1865_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","A ostala četiri kola i osam volova dade sinovima Merarijevim prema službi njihovoj pod upravom Itamara, sina Arona sveštenika. ");
INSERT INTO srp1865_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","A sinovima Katovim ne dade ništa jer im posao beše služiti svetinji, i nošahu na ramenima. ");
INSERT INTO srp1865_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","I donesoše knezovi da se posveti oltar kad bi pomazan, donesoše knezovi priloge svoje pred oltar. ");
INSERT INTO srp1865_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","A Gospod reče Mojsiju: Jedan knez u jedan dan a drugi knez u drugi dan neka donose svoje priloge da se posveti oltar. ");
INSERT INTO srp1865_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","I prvi dan donese prilog svoj Nason, sin Aminadavov od plemena Judinog; ");
INSERT INTO srp1865_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","a prilog njegov beše jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala, po siklu svetom; a oboje puno brašna belog pomešanog s uljem za dar. ");
INSERT INTO srp1865_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Nasona sina Aminadavovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Drugi dan donese Natanilo, sin Sogarov, knez plemena Isaharovog, ");
INSERT INTO srp1865_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","donese prilog svoj: jednu zdelu srebrnu od sto i trideset sikala, jednu čašu srebrnu od sedamdeset sikala po siklu svetom, oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Natanaila sina Sogarovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Treći dan donese knez sinova Zavulonovih, Elijav sin Helonov; ");
INSERT INTO srp1865_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","njegov prilog beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Elijava, sina Helonovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Četvrti dan donese knez sinova Ruvimovih Elisur sin Sedijurov; ");
INSERT INTO srp1865_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Elisura, sina Sedijurovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Peti dan donese knez sinova Simeunovih, Salamilo, sin Surisadajev; ");
INSERT INTO srp1865_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Salamila sina Surisadajevog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Šesti dan donese knez sinova Gadovih, Elisaf sin Raguilov; ");
INSERT INTO srp1865_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Elisafa, sina Raguilovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Sedmi dan donese knez sinova Jefremovih Elisama, sin Emijudov; ");
INSERT INTO srp1865_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Elisame, sina Emijudovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Osmi dan donese knez sinova Manasijinih Gamalilo, sin Fadasurov; ");
INSERT INTO srp1865_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Gamalila, sina Fadasurovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Deveti dan donese knez sinova Venijaminovih Avidan sin Gadeonijev; ");
INSERT INTO srp1865_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Avidana, sina Gadeonijevog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Deseti dan donese knez sinova Danovih Ahijezer, sin Amisadajev; ");
INSERT INTO srp1865_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Ahijezera sina Amisadajevog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Jedanaesti dan donese knez sinova Asirovih Fagailo sin Ehranov; ");
INSERT INTO srp1865_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Fagaila, sina Ehranovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Dvanaesti dan donese knez sinova Neftalimovih Ahirej sin Enanov; ");
INSERT INTO srp1865_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","prilog njegov beše: jedna zdela srebrna od sto i trideset sikala, jedna čaša srebrna od sedamdeset sikala po siklu svetom, a oboje puno belog brašna pomešanog s uljem za dar; ");
INSERT INTO srp1865_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","jedna kadionica zlatna od deset sikala, puna kada; ");
INSERT INTO srp1865_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","jedno tele, jedan ovan, jedno jagnje od godine za žrtvu paljenicu; ");
INSERT INTO srp1865_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","jedan jarac za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","a za žrtvu zahvalnu dva vola, pet ovnova, pet jaraca, pet jaganjaca od godine. To bi prilog Ahireja, sina Enanovog. ");
INSERT INTO srp1865_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","To je prilog od knezova Izrailjevih da se posveti oltar pošto bi pomazan: dvanaest zdela srebrnih, dvanaest čaša srebrnih, dvanaest kadionica zlatnih; ");
INSERT INTO srp1865_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","svaka zdela srebrna od sto i trideset sikala, i svaka čaša od sedamdeset sikala; svega srebra u tim sudovima dve hiljade i četiri stotine sikala, po siklu svetom; ");
INSERT INTO srp1865_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","dvanaest kadionica zlatnih punih kada, svaka kadionica od deset sikala, po siklu svetom; svega zlata u kadionicama sto i dvadeset sikala; ");
INSERT INTO srp1865_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","svega stoke za žrtvu paljenicu dvanaest telaca, dvanaest ovnova, dvanaest jaganjaca od godine s darom svojim, i jaraca dvanaest za greh; ");
INSERT INTO srp1865_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","a svega stoke za žrtvu zahvalnu dvadeset i četiri vola, šezdeset ovnova, šezdeset jaraca, šezdeset jaganjaca od godine. To je prilog da se posveti oltar, pošto bi pomazan. ");
INSERT INTO srp1865_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","I kad Mojsije ulažaše u šator od sastanka da govori pred Bogom, tada čujaše glas gde mu govori sa zaklopca što beše na kovčegu od svedočanstva između dva heruvima; i govoraše mu. ");
INSERT INTO srp1865_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Kaži Aronu i reci mu: Kad zapališ žiške, sedam žižaka neka svetli napred, na svećnjaku. ");
INSERT INTO srp1865_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","I učini Aron tako, i zapali žiške da svetle spreda, na svećnjaku, kao što Gospod zapovedi Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","A svećnjak beše skovan od zlata, i stupac mu i cveće skovano; po prilici koju pokaza Gospod Mojsiju tako beše načinio svećnjak. ");
INSERT INTO srp1865_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Uzmi Levite između sinova Izrailjevih, i očisti ih. ");
INSERT INTO srp1865_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","A učini im ovo da ih očistiš: pokropi ih vodom očišćenja, a oni neka obriju sve telo svoje i operu haljine svoje, i očistiće se. ");
INSERT INTO srp1865_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Potom neka uzmu tele s darom uz njega, belim brašnom pomešanim s uljem; i drugo tele uzmi za greh. ");
INSERT INTO srp1865_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Pa dovedi Levite pred šator od sastanka, i sazovi sav zbor sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","I dovedi Levite pred Gospoda, i neka metnu sinovi Izrailjevi ruke svoje na Levite. ");
INSERT INTO srp1865_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","I Aron neka prinese Levite Gospodu za prinos od sinova Izrailjevih da vrše službu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","A Leviti neka metnu ruke svoje na glave teocima, pa prinesi jedno tele za greh a drugo na žrtvu paljenicu Gospodu da se očiste Leviti. ");
INSERT INTO srp1865_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","I postavi Levite pred Aronom i sinovima njegovim, i prinesi ih za prinos Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","I odvoj Levite između sinova Izrailjevih da budu moji Leviti. ");
INSERT INTO srp1865_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","A posle neka dođu Leviti da služe u šatoru od sastanka, kad ih očistiš i prineseš za prinos. ");
INSERT INTO srp1865_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Jer su meni dani između sinova Izrailjevih; za sve što otvara matericu, za sve prvence između sinova Izrailjevih uzeh njih. ");
INSERT INTO srp1865_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Jer je moj svaki prvenac između sinova Izrailjevih i od ljudi i od stoke; onaj dan kad pobih sve prvence u zemlji misirskoj, posvetio sam ih sebi. ");
INSERT INTO srp1865_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","A Levite uzeh za sve prvence sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","I dadoh Levite na dar Aronu i sinovima njegovim između sinova Izrailjevih, da služe mesto sinova Izrailjevih u šatoru od sastanka, i da budu otkup za sinove Izrailjeve, da ne bi dolazio pomor na sinove Izrailjeve, kad bi pristupali k svetinji sinovi Izrailjevi. ");
INSERT INTO srp1865_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","I učini Mojsije i Aron i sav zbor sinova Izrailjevih Levitima sve što zapovedi Gospod Mojsiju za Levite, tako im učiniše sinovi Izrailjevi. ");
INSERT INTO srp1865_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","I očistiše se Leviti, i opraše haljine svoje, i prinese ih Aron za prinos pred Gospodom, i očisti ih Aron da bi bili čisti. ");
INSERT INTO srp1865_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","A onda tek pristupiše Leviti da vrše službu svoju u šatoru od sastanka pred Aronom i pred sinovima njegovim; kao što zapovedi Gospod Mojsiju za Levite, tako im učiniše. ");
INSERT INTO srp1865_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","I opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","I ovo je za Levite: od dvadeset i pet godina i više neka stupaju u službu da služe u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","A kad kome bude pedeset godina, neka izlazi iz te službe i više neka ne služi. ");
INSERT INTO srp1865_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ali neka služi braći svojoj u šatoru od sastanka radeći šta treba raditi, a sam neka ne vrši službu. Tako učini Levitima za poslove njihove. ");
INSERT INTO srp1865_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Još reče Gospod Mojsiju u pustinji sinajskoj druge godine po izlasku njihovom iz zemlje misirske prvog meseca, govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Neka slave sinovi Izrailjevi pashu u određeno vreme. ");
INSERT INTO srp1865_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Četrnaestog dana ovog meseca uveče slavite je u određeno vreme, po svim zakonima i po svim uredbama njenim slavite je. ");
INSERT INTO srp1865_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","I reče Mojsije sinovima Izrailjevim da slave pashu. ");
INSERT INTO srp1865_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","I slavite pashu prvog meseca četrnaestog dana uveče u pustinji sinajskoj; kako beše Gospod zapovedio Mojsiju, sve onako učiniše sinovi Izrailjevi. ");
INSERT INTO srp1865_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","A behu neki koji se oskvrniše o mrtvaca te ne mogahu slaviti pashe onaj dan; i dođoše isti dan pred Mojsija i pred Arona; ");
INSERT INTO srp1865_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","i rekoše mu ljudi oni: Mi smo nečisti od mrtvaca; zašto da nam nije slobodno prineti žrtvu Gospodu u vreme zajedno sa sinovima Izrailjevim? ");
INSERT INTO srp1865_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","A Mojsije im reče: Stanite da čujem šta će zapovediti Gospod za vas. ");
INSERT INTO srp1865_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","A Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Kaži sinovima Izrailjevim i reci: Ko bi bio nečist od mrtvaca ili bi bio na dalekom putu između vas ili između vašeg natražja, neka slavi pashu Gospodu, ");
INSERT INTO srp1865_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","drugog meseca četrnaestog dana uveče neka je slave s presnim hlebom i s gorkim zeljem neka je jedu. ");
INSERT INTO srp1865_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Neka ne ostavljaju od nje ništa do jutra i kosti da joj ne prelome, po svemu zakonu za pashu neka je slave. ");
INSERT INTO srp1865_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","A ko je čist i nije na putu, pa bi propustio slaviti pashu, da se istrebi duša ona iz naroda svog, jer ne prinese Gospodu žrtve na vreme, greh svoj neka nosi onaj čovek. ");
INSERT INTO srp1865_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","I ako bi među vama živeo stranac i slavio bi pashu Gospodu, po zakonu i uredbi za pashu neka je slavi; a zakon da vam je jednak i strancu i onome ko se rodio u zemlji. ");
INSERT INTO srp1865_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","A u koji dan bi podignut šator, pokri oblak šator nad naslonom od svedočanstva; a uveče beše nad šatorom kao oganj do jutra. ");
INSERT INTO srp1865_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tako beše jednako: oblak ga zaklanjaše, ali noću beše kao oganj. ");
INSERT INTO srp1865_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","I kad bi se oblak podigao iznad šatora, tada polažahu sinovi Izrailjevi, a gde bi stao oblak, onde se zaustavljahu sinovi Izrailjevi. ");
INSERT INTO srp1865_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Po zapovesti Gospodnjoj polažahu sinovi Izrailjevi, i po zapovesti Gospodnjoj ustavljahu se; dokle god stajaše oblak nad šatorom, oni stajahu u logoru, ");
INSERT INTO srp1865_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","i kad oblak dugo stajaše nad šatorom, tada svršivahu sinovi Izrailjevi šta treba svršivati Gospodu i ne polažahu. ");
INSERT INTO srp1865_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","I kad oblak beše nad šatorom malo dana, po zapovesti Gospodnjoj stajahu u logoru i po zapovesti Gospodnjoj polažahu. ");
INSERT INTO srp1865_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kad bi, pak, oblak stajao od večera do jutra, a ujutro bi se podigao oblak, tada polažahu; bilo danju ili noću, kad bi se oblak podigao, oni polažahu. ");
INSERT INTO srp1865_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ako li bi dva dana ili mesec dana ili godinu oblak stajao nad šatorom, stajahu u logoru sinovi Izrailjevi i ne polažahu, a kako bi se podigao, oni polažahu. ");
INSERT INTO srp1865_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Po zapovesti Gospodnjoj stajahu u logor, i po zapovesti Gospodnjoj polažahu; i svršivahu šta treba svršivati Gospodu, kao što beše zapovedio Gospod preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Načini sebi dve trube od srebra, kovane da budu; njima ćeš sazivati zbor i zapovedati da polazi vojska. ");
INSERT INTO srp1865_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kad obe zatrube, tada neka se skuplja k tebi sav zbor na vrata šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","A kad jedna zatrubi, tada neka se skupljaju k tebi knezovi, glavari od hiljada Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","A kad zatrube potresajući, tada neka se kreće logor koji leži prema istoku. ");
INSERT INTO srp1865_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","A kad zatrubite drugi put potresajući, onda neka se kreće logor koji je na jugu; potresajući neka se trubi kad treba da pođu. ");
INSERT INTO srp1865_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","A kad sazivate zbor, trubite, ali ne potresajući. ");
INSERT INTO srp1865_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","A neka trube u trube sinovi Aronovi sveštenici; to da vam je uredba večna od kolena do kolena. ");
INSERT INTO srp1865_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","I kad pođete na vojsku u zemlji svojoj na neprijatelja koji udari na vas, trubite u trube potresajući; i Gospod Bog vaš opomenuće vas se, i sačuvaćete se od neprijatelja svojih. ");
INSERT INTO srp1865_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Tako i u dan veselja svog i na praznike svoje i početke meseca svojih trubite u trube prinoseći žrtve svoje paljenice i žrtve svoje zahvalne, i biće vam spomen pred Bogom vašim. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","I u dvadeseti dan drugog meseca druge godine podiže se oblak iznad šatora od svedočanstva. ");
INSERT INTO srp1865_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","I pođoše sinovi Izrailjevi svojim redom iz pustinje sinajske, i ustavi se oblak u pustinji faranskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Tako pođoše prvi put, kao što Gospod zapovedi preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","I pođe napred zastava vojske sinova Judinih u četama svojim; i nad vojskom njihovom beše Nason, sin Aminadavov; ");
INSERT INTO srp1865_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","a nad vojskom plemena sinova Isaharovih Natanailo, sin Sogarov; ");
INSERT INTO srp1865_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","a nad vojskom plemena sinova Zavulonovih Elijav, sin Helonov. ");
INSERT INTO srp1865_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","I složiše šator, pa pođoše sinovi Girsonovi i sinovi Merarijevi noseći šator. ");
INSERT INTO srp1865_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Potom pođe zastava vojske sinova Ruvimovih, a nad njihovom vojskom beše Elisur, sin Sedijurov, ");
INSERT INTO srp1865_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","a nad vojskom plemena sinova Simeunovih Salamilo, sin Surisadajev, ");
INSERT INTO srp1865_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","a nad vojskom plemena sinova Gadovih Elisaf sin Raguilov. ");
INSERT INTO srp1865_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","I pođoše sinovi Katovi noseći svetinju, da bi oni podigli šator dokle ovi dođu. ");
INSERT INTO srp1865_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Potom pođe zastava vojske sinova Jefremovih u četama svojim, a nad vojskom njihovom beše Elisama, sin Emijudov, ");
INSERT INTO srp1865_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","a nad vojskom plemena sinova Manasijinih Gamalilo sin Fadasurov, ");
INSERT INTO srp1865_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","a nad vojskom plemena sinova Venijaminovih Avidan sin Gadeonijev. ");
INSERT INTO srp1865_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Najposle pođe zastava vojske sinova Danovih u četama svojim, zadnja vojska, i nad vojskom njihovom beše Ahijezer, sin Amisadajev, ");
INSERT INTO srp1865_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","a nad vojskom plemena sinova Asirovih Fagailo, sin Ehranov, ");
INSERT INTO srp1865_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","a nad vojskom plemena sinova Neftalimovih Ahirej, sin Enanov. ");
INSERT INTO srp1865_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tim redom pođoše sinovi Izrailjevi u četama svojim, i tako iđahu. ");
INSERT INTO srp1865_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","A Mojsije reče Jovavu, sinu Raguilovom Madijaninu tastu svom: Idemo na mesto za koje reče Gospod: Vama ću ga dati. Hajde s nama, i dobro ćemo ti učiniti, jer je Gospod obećao Izrailju mnogo dobra. ");
INSERT INTO srp1865_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","A on mu reče: Neću ići, nego idem u svoju zemlju i u rod svoj. ");
INSERT INTO srp1865_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","A Mojsije reče: Nemoj nas ostaviti, jer znaš mesta u pustinji gde bismo mogli stajati, pa nam budi vođ. ");
INSERT INTO srp1865_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","I ako pođeš s nama kad dođe dobro koje će nam učiniti Gospod, učinićemo ti dobro. ");
INSERT INTO srp1865_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","I tako pođoše od gore Gospodnje, i iđahu tri dana, i kovčeg zaveta Gospodnjeg iđaše pred njima tri dana tražeći mesto gde bi počinuli. ");
INSERT INTO srp1865_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","I oblak Gospodnji beše nad njima svaki dan kad polažahu s mesta, gde behu u logoru. ");
INSERT INTO srp1865_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","I kad polažaše kovčeg, govoraše Mojsije: Ustani Gospode, i neka se razaspu neprijatelji Tvoji, i neka beže ispred Tebe koji mrze na Te. ");
INSERT INTO srp1865_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","A kad se ustavljaše, govoraše: Uvrati se, Gospode, k mnoštvu hiljada Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Posle stade se tužiti narod da mu je teško; a to ne bi po volji Gospodu; i kad Gospod ču, razgnevi se; i raspali se na njih oganj Gospodnji, i sažeže krajnje u logoru. ");
INSERT INTO srp1865_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tada zavapi narod k Mojsiju, a Mojsije se pomoli Gospodu, i ugasi se oganj. ");
INSERT INTO srp1865_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","I prozva se ono mesto Tavera, jer se raspali na njih oganj Gospodnji. ");
INSERT INTO srp1865_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","A svetina što beše među njima, beše vrlo lakoma, te i sinovi Izrailjevi stadoše plakati govoreći: Ko će nas nahraniti mesa? ");
INSERT INTO srp1865_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Opomenusmo se riba što jeđasmo u Misiru zabadava, i krastavaca i dinja i luka crnog i belog. ");
INSERT INTO srp1865_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","A sada posahnu duša naša, nema ništa osim mane pred očima našim. ");
INSERT INTO srp1865_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","A mana beše kao seme korijandrovo, a boja mu beše kao boja u bdela. ");
INSERT INTO srp1865_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","I izlažaše narod, te kupljahu, i meljahu na žrvnjima ili tucahu u stupama, i kuvahu u kotlu, ili mešahu pogače; a ukus joj beše kao ukus od novog ulja. ");
INSERT INTO srp1865_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","I kad padaše rosa po logoru noću, padaše s njom i mana. ");
INSERT INTO srp1865_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","I ču Mojsije gde narod plače u porodicama svojim, svaki na vratima od šatora svog; i Gospod se razgnevi vrlo, i Mojsiju bi teško. ");
INSERT INTO srp1865_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Pa reče Mojsije Gospodu: Zašto učini takvo zlo sluzi svom? I zašto ne nađoh milosti pred Tobom, nego metnu na me teret svega naroda ovog? ");
INSERT INTO srp1865_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Eda li ja začeh sav ovaj narod? Eda li ga ja rodih, kad mi kažeš: Iznesi ga u naručju svom, kao što nosi dojilja dete, u onu zemlju za koju si se zakleo ocima njihovim. ");
INSERT INTO srp1865_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Otkuda meni mesa da dam svemu ovom narodu? Jer plaču preda mnom govoreći: Daj nam mesa da jedemo. ");
INSERT INTO srp1865_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ne mogu ja sam nositi sav narod ovaj, jer je teško za mene. ");
INSERT INTO srp1865_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ako ćeš tako činiti sa mnom, ubij me bolje, ako sam našao milost pred Tobom, da ne gledam zlo svoje. ");
INSERT INTO srp1865_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","A Gospod reče Mojsiju: Saberi mi sedamdeset ljudi između starešina Izrailjevih, koje znaš da su starešine narodu i upravitelji njegovi, i dovedi ih k šatoru od sastanka, neka onde stanu s tobom. ");
INSERT INTO srp1865_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Tada ću sići i govoriti onde s tobom, i uzeću od duha koji je na tebi i metnuću na njih, da nose s tobom teret narodni i da ne nosiš ti sam. ");
INSERT INTO srp1865_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","A narodu reci: Pripravite se za sutra da jedete mesa, jer plakaste da Gospod ču, i rekoste: Ko će nas nahraniti mesa? Jer nam dobro beše u Misiru. Daće vam, dakle, Gospod mesa i ješćete. ");
INSERT INTO srp1865_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nećete jesti jedan dan, ni dva dana, ni pet dana, ni deset dana, ni dvadeset dana; ");
INSERT INTO srp1865_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","nego ceo mesec dana, dokle vam na nos ne udari i ne ogadi vam se, zato što odbaciste Gospoda koji je među vama i plakaste pred Njim govoreći: Zašto iziđosmo iz Misira? ");
INSERT INTO srp1865_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","A Mojsije reče: Šest stotina hiljada pešaka ima naroda, u kome sam, pa Ti kažeš: Daću im mesa da jedu ceo mesec dana. ");
INSERT INTO srp1865_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Eda li će im se poklati ovce i goveda da im dostane? Ili će im se pokupiti sve ribe morske da im bude dosta? ");
INSERT INTO srp1865_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","A Gospod reče Mojsiju: Zar ruka Gospodnja neće biti dovoljna? Videćeš hoće li biti šta ti rekoh ili neće. ");
INSERT INTO srp1865_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","I Mojsije iziđe i reče narodu reči Gospodnje; i sabra sedamdeset ljudi između starešina narodnih, i postavi ih oko šatora. ");
INSERT INTO srp1865_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","I Gospod siđe u oblaku i govori k njemu, i uzevši od duha koji beše na njemu metnu na onih sedamdeset ljudi starešina; i kad duh dođe na njih, prorokovahu, ali više nikad. ");
INSERT INTO srp1865_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","A dva čoveka ostaše u logoru, jednom beše ime Eldad, a drugom Modad, na koje dođe duh, jer i oni behu zapisani, ali ne dođoše k šatoru, i stadoše prorokovati u logoru. ");
INSERT INTO srp1865_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","I dotrča momak, te javi Mojsiju govoreći: Eldad i Modad prorokuju u logoru. ");
INSERT INTO srp1865_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","A Isus, sin Navin, sluga Mojsijev, jedan od momaka njegovih, reče govoreći: Mojsije, gospodaru moj, zabrani im. ");
INSERT INTO srp1865_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","A Mojsije mu odgovori: Zar zavidiš mene radi? Kamo da sav narod Gospodnji postanu proroci i da Gospod pusti duh svoj na njih! ");
INSERT INTO srp1865_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Potom se vrati Mojsije u logor sa starešinama Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Tada se podiže vetar od Gospoda, i potera od mora prepelice, i razasu ih po logoru na dan hoda odovuda i na dan hoda odonuda oko logora, na dva lakta od zemlje. ");
INSERT INTO srp1865_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","I ustavši narod ceo onaj dan i svu noć i ceo drugi dan kupljaše prepelice: i ko nakupi najmanje nakupi deset gomora; i povešaše ih sebi redom oko logora. ");
INSERT INTO srp1865_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ali meso još im beše u zubima, jošte ga ne pojedoše, a Gospod se razgnevi na narod i udari Gospod narod pomorom vrlo velikim. ");
INSERT INTO srp1865_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","I prozva se ono mesto Kivrot-Atava jer onde ukopaše narod koji se beše polakomio. ");
INSERT INTO srp1865_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","I pođe narod od Kivrot-Atave u Asirot, i stadoše u Asirotu. ");
INSERT INTO srp1865_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","I stadoše vikati Marija i Aron na Mojsija radi žene Madijanke, kojom se oženi, jer se oženi Madijankom. ");
INSERT INTO srp1865_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","I rekoše: Zar je samo preko Mojsija govorio Gospod? Nije li govorio i preko nas? I to ču Gospod. ");
INSERT INTO srp1865_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","A Mojsije beše čovek vrlo krotak mimo sve ljude na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","I odmah reče Gospod Mojsiju i Aronu i Mariji: Dođite vas troje u šator od sastanka. I otidoše njih troje. ");
INSERT INTO srp1865_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Tada siđe Gospod u stupu od oblaka, stade na vratima od šatora. I viknu Arona i Mariju, i dođoše oboje. ");
INSERT INTO srp1865_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","I reče im: Čujte sada reči moje: prorok kad je među vama, ja ću mu se Gospod javljati u utvari i govoriću s njim u snu. ");
INSERT INTO srp1865_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ali nije takav moj sluga Mojsije, koji je veran u svem domu mom. ");
INSERT INTO srp1865_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Njemu govorim iz usta k ustima, i on me gleda doista, a ne u tami niti u kakvoj prilici Gospodnjoj. Kako se dakle ne pobojaste vikati na slugu mog, na Mojsija? ");
INSERT INTO srp1865_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","I gnev se Gospodnji raspali na njih, i On otide. ");
INSERT INTO srp1865_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","I oblak se podiže sa šatora; i gle, Marija beše gubava, bela kao sneg. I Aron pogleda Mariju, a ona gubava. ");
INSERT INTO srp1865_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Tada reče Aron Mojsiju: Gospodaru, molim te, ne meći na nas greha ovog, jer ludo učinismo i zgrešismo. ");
INSERT INTO srp1865_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Nemoj da ova bude kao mrtvo dete, kome je meso pola trulo kad izlazi iz utrobe majke svoje. ");
INSERT INTO srp1865_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","I vapi Mojsije ka Gospodu govoreći: Bože, molim Ti se, isceli je. ");
INSERT INTO srp1865_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","A Gospod odgovori Mojsiju: Da joj je otac njen pljunuo u lice, ne bi li se stidela sedam dana? Neka bude odlučena sedam dana izvan logora, a posle neka bude opet primljena. ");
INSERT INTO srp1865_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Tako bi Marija odlučena izvan logora sedam dana; i narod ne pođe odande dokle Marija ne bi opet primljena. ");
INSERT INTO srp1865_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Posle toga narod je otišao iz Asirota i ulogorio se u pustinji Faran. ");
INSERT INTO srp1865_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","A potom pođe narod od Asirota, i stadoše u pustinji faranskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","I Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Pošlji ljude da uhode zemlju hanansku, koju ću dati sinovima Izrailjevim; po jednog čoveka od svakog plemena otaca njihovih pošljite, sve glavare između njih. ");
INSERT INTO srp1865_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","I posla ih Mojsije iz pustinje faranske po zapovesti Gospodnjoj; i svi ljudi behu glavari sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","A ovo su im imena: od plemena Ruvimovog Samuilo sin Zahurov; ");
INSERT INTO srp1865_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","od plemena Simeunovog Safat sin Surin; ");
INSERT INTO srp1865_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","od plemena Judinog Halev sin Jefonijin; ");
INSERT INTO srp1865_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","od plemena Isaharovog Igal sin Josifov; ");
INSERT INTO srp1865_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","od plemena Jefremovog Avsije sin Navin; ");
INSERT INTO srp1865_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","od plemena Venijaminovog Faltije sin Rafujev; ");
INSERT INTO srp1865_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","od plemena Zavulonovog Gudilo sin Sudin; ");
INSERT INTO srp1865_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","od plemena Josifovog, od plemena Manasijinog Gadije sin Susin; ");
INSERT INTO srp1865_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","od plemena Danovog Amilo sin Gamalin. ");
INSERT INTO srp1865_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Od plemena Asirovog Satur sin Mihailov; ");
INSERT INTO srp1865_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","od plemena Neftalimovog Navija sin Savin; ");
INSERT INTO srp1865_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","od plemena Gadovog Gudilo sin Mahilov. ");
INSERT INTO srp1865_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","To su imena ljudima koje posla Mojsije da uhode zemlju. I nazva Mojsije Avsija sina Navinog Isus. ");
INSERT INTO srp1865_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","I šaljući ih Mojsije da uhode zemlju hanansku reče im: idite ovuda na jug, pa iziđite na goru; ");
INSERT INTO srp1865_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","i vidite zemlju kakva je i kakav narod živi u njoj, je li jak ili slab, je li mali ili velik; ");
INSERT INTO srp1865_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","i kakva je zemlja u kojoj živi, je li dobra ili rđava; i kakva su mesta u kojima živi, eda li pod šatorima ili u tvrdim gradovima; ");
INSERT INTO srp1865_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","i kakva je sama zemlja, je li rodna ili nerodna, ima li u njoj drveta ili nema; budite slobodni, i uzmite roda one zemlje. A tada beše vreme prvom grožđu. ");
INSERT INTO srp1865_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","I otišavši uhodiše zemlju od pustinje sinske do Reova kako se ide u Emat. ");
INSERT INTO srp1865_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","I otidoše na jug, i dođoše do Hevrona, gde behu Ahiman i Sesije i Teliman, sinovi Enakovi. A Hevron beše sazidan na sedam godina pre Soana misirskog. ");
INSERT INTO srp1865_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Potom dođoše do potoka Eshola, i onde odsekoše lozu s grozdom jednim, i ponesoše ga dvojica na moci; tako i šipaka i smokava. ");
INSERT INTO srp1865_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","I prozva se ono mesto potok Eshol od grozda, koji onde odsekoše sinovi Izrailjevi. ");
INSERT INTO srp1865_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","I posle četrdeset dana vratiše se iz zemlje koju uhodiše. ");
INSERT INTO srp1865_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","I vrativši se dođoše k Mojsiju i Aronu i ka svemu zboru sinova Izrailjevih u pustinju faransku, u Kadis; i pripovediše njima i svemu zboru stvar, i pokazaše im rod one zemlje. ");
INSERT INTO srp1865_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","I pripovedajući im rekoše: Idosmo u zemlju u koju si nas poslao; doista teče u njoj mleko i med, i evo roda njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ali je jak narod koji živi u onoj zemlji, i gradovi su im tvrdi i vrlo veliki; a videsmo onde i sinove Enakove. ");
INSERT INTO srp1865_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Amalik živi na južnoj strani; a Heteji i Jevuseji i Amoreji žive u planini, a Hananeji žive na moru i na Jordanu. ");
INSERT INTO srp1865_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","A Halev utišavaše narod pred Mojsijem; i govoraše: hajde da idemo da je uzmemo, jer je možemo pokoriti. ");
INSERT INTO srp1865_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ali drugi ljudi koji idoše s njim govorahu: Ne možemo ići na onaj narod, jer je jači od nas. ");
INSERT INTO srp1865_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","I prosuše zao glas o zemlji koju uhodiše među sinovima Izrailjevim govoreći: Zemlja koju prođosmo i uhodismo zemlja je koja proždire svoje stanovnike, i sav narod koji videsmo u njoj jesu ljudi vrlo veliki. ");
INSERT INTO srp1865_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","Videsmo onde i divove, sinove Enakove, roda divovskog, i činjaše nam se da smo prema njima kao skakavci, takvi se i njima činjasmo. ");
INSERT INTO srp1865_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Tada se podiže sav zbor i stade vikati, i narod plakaše onu noć. ");
INSERT INTO srp1865_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","I vikahu na Mojsija i na Arona svi sinovi Izrailjevi; i sav zbor reče im: Kamo da smo pomrli u zemlji misirskoj ili da pomremo u ovoj pustinji! ");
INSERT INTO srp1865_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Zašto nas vodi Gospod u tu zemlju da izginemo od mača, žene naše i deca naša da postanu roblje? Nije li bolje da se vratimo u Misir? ");
INSERT INTO srp1865_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","I rekoše među sobom: Da postavimo starešinu, pa da se vratimo u Misir. ");
INSERT INTO srp1865_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Tada Mojsije i Aron padoše ničice pred svim zborom sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","A Isus sin Navin i Halev sin Jefonijin između onih što uhodiše zemlju razdreše haljine svoje, ");
INSERT INTO srp1865_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","i rekoše svemu zboru sinova Izrailjevih govoreći: Zemlja koju prođosmo i uhodismo, vrlo je dobra zemlja. ");
INSERT INTO srp1865_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ako smo mili Gospodu, On će nas odvesti u tu zemlju, i daće nam je; a to je zemlja u kojoj teče mleko i med. ");
INSERT INTO srp1865_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Samo se ne odmećite Gospoda, i ne bojte se naroda one zemlje; jer ih možemo pojesti; odstupio je od njih zaklon njihov, a s nama je Gospod, ne bojte ih se. ");
INSERT INTO srp1865_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Tada reče sav zbor da ih pobiju kamenjem; ali se pokaza slava Gospodnja svim sinovima Izrailjevim u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","I reče Gospod Mojsiju: Dokle će me vređati taj narod? Kad li će mi verovati posle tolikih znaka što sam učinio među njima? ");
INSERT INTO srp1865_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Udariću ga pomorom, i rasuću ga; a od tebe ću učiniti narod velik i jači od ovog. ");
INSERT INTO srp1865_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","A Mojsije reče Gospodu: Ali će čuti Misirci, između kojih si izveo ovaj narod silom svojom, ");
INSERT INTO srp1865_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","i reći će s ljudima ove zemlje, koji su čuli da si Ti, Gospode, bio usred naroda i da si se očima viđao, Gospode, i oblak tvoj da je stajao nad njima, i u stupu od oblaka da si išao pred njima danu i u stupu ognjenom noću; ");
INSERT INTO srp1865_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","pa kad pobiješ ovaj narod, sve do jednog, govoriće narodi, koji su čuli pripovest o Tebi, govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Nije mogao Gospod dovesti narod ovaj u zemlju koju im je sa zakletvom obećao, zato ih pobi u pustinji. ");
INSERT INTO srp1865_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Neka se, dakle, proslavi sila Gospodnja, kao što si rekao govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Gospod dugo čeka i obilan je milošću, prašta bezakonje i greh, ali ne pravda krivoga, nego pohodi bezakonje otačko na sinovima do trećeg i četvrtog kolena. ");
INSERT INTO srp1865_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Oprosti bezakonje ovom narodu radi velike milosti svoje, kao što si praštao narodu ovom od Misira dovde. ");
INSERT INTO srp1865_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","A Gospod reče: Praštam po reči tvojoj. ");
INSERT INTO srp1865_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ali tako ja živ bio, i tako sva zemlja bila puna slave Gospodnje, ");
INSERT INTO srp1865_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ti ljudi koji videše slavu moju i znake moje što sam učinio u Misiru i u ovoj pustinji, i kušaše me već deset puta, i ne poslušaše reči moje, ");
INSERT INTO srp1865_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","neće videti zemlje koju sa zakletvom obećah ocima njihovim, neće videti ni jedan od onih koji me uvrediše. ");
INSERT INTO srp1865_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","A slugu svog Haleva, u kome beše drugi duh i koji se sasvim mene držao, njega ću odvesti u zemlju u koju je išao, i seme će je njegovo naslediti. ");
INSERT INTO srp1865_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ali Amalik i Hananej sede u dolini, zato se sutra vratite natrag, i idite u pustinju k crvenom moru. ");
INSERT INTO srp1865_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Još reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Dokle će taj zli zbor vikati na me, čuo sam viku sinova Izrailjevih, koji viču na me. ");
INSERT INTO srp1865_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Kaži im: Tako ja živ bio, kaže Gospod, učiniću vam onako kako ste govorili i ja čuh. ");
INSERT INTO srp1865_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","U ovoj će pustinji popadati mrtva telesa vaša, i svi između vas koji su izbrojani u svem broju vašem od dvadeset godina i više, koji vikaste na me, ");
INSERT INTO srp1865_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","nećete ući u zemlju, za koju podigavši ruku svoju zakleh se da ću vas naseliti u njoj, osim Haleva, sina Jefonijinog i Isusa, sina Navinog. ");
INSERT INTO srp1865_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","A decu vašu, za koju rekoste da će postati roblje, njih ću odvesti, i oni će poznati zemlju za koju vi ne marite. ");
INSERT INTO srp1865_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","A vaša telesa mrtva će popadati u ovoj pustinji. ");
INSERT INTO srp1865_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","A deca vaša biće pastiri po pustinji četrdeset godina, i nosiće kar za preljube vaše, dokle ne ispropadaju telesa vaša u pustinji. ");
INSERT INTO srp1865_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Po broju dana, za koje uhodiste zemlju, četrdeset dana, za svaki dan po godinu, nosićete grehe svoje, četrdeset godina, i poznaćete da sam prekinuo s vama. ");
INSERT INTO srp1865_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ja Gospod rekoh, i tako ću učiniti svemu tom zboru zlom, koji se sabrao na me: u pustinji će propasti i tu pomreti. ");
INSERT INTO srp1865_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","A ljudi koje beše poslao Mojsije da uhode zemlju, i koji vrativši se pobuniše sav zbor da viče na nj, prosuvši zao glas o zemlji, ");
INSERT INTO srp1865_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ti ljudi, koji prosuše zao glas o zemlji, pomreše od pomora pred Gospodom; ");
INSERT INTO srp1865_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","a Isus, sin Navin i Halev, sin Jefonijin ostaše živi između ljudi koji su išli da uhode zemlju. ");
INSERT INTO srp1865_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","I Mojsije kaza sve ove reči svim sinovima Izrailjevim, i narod plaka veoma. ");
INSERT INTO srp1865_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","A sutradan ustavši pođoše navrh gore, i rekoše: Evo nas, idemo na mesto za koje je govorio Gospod, jer zgrešismo. ");
INSERT INTO srp1865_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ali Mojsije reče: Zašto prestupate zapovest Gospodnju? Od toga neće biti ništa. ");
INSERT INTO srp1865_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ne idite gore, jer Gospod nije među vama; nemojte da vas pobiju neprijatelji vaši. ");
INSERT INTO srp1865_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Jer je Amalik i Hananej tamo pred vama, i izginućete od mača, jer odustaviste Gospoda, pa neće ni Gospod biti s vama. ");
INSERT INTO srp1865_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ali oni, ipak, navališe da idu navrh gore; ali kovčeg zaveta Gospodnjeg i Mojsije ne izađoše iz logora. ");
INSERT INTO srp1865_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tada siđe Amalik i Hananej, koji življahu u onoj gori, i razbiše ih i baciše dori do Orme. ");
INSERT INTO srp1865_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Reci sinovima Izrailjevim i kaži im: Kad dođete u zemlju gde ćete nastavati, koju ću vam ja dati, ");
INSERT INTO srp1865_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","i stanete prinositi žrtvu ognjenu Gospodu, žrtvu paljenicu ili žrtvu zaveta radi ili od drage volje, ili o praznicima svojim, gotoveći miris ugodni Gospodu od krupne ili od sitne stoke, ");
INSERT INTO srp1865_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","tada ko prinese prinos svoj Gospodu, neka donese uza nj dar, desetinu efe belog brašna pomešanog s četvrtinom ina ulja. ");
INSERT INTO srp1865_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","I vina četvrt ina za naliv donesi uz žrtvu paljenicu ili uz drugu žrtvu, na svako jagnje. ");
INSERT INTO srp1865_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","A uz ovna donesi dar, dve desetine belog brašna pomešanog sa trećinom ina ulja, ");
INSERT INTO srp1865_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","i vina za naliv trećinu ina prinećeš za miris ugodni Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","A kad prinosiš tele na žrtvu paljenicu ili na žrtvu radi zaveta ili na žrtvu zahvalnu Gospodu, ");
INSERT INTO srp1865_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","onda neka se donese uz tele dar, tri desetine efe belog brašna pomešanog s po ina ulja, ");
INSERT INTO srp1865_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","i vina donesi za naliv po ina; to je žrtva ognjena za miris ugodni Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Tako neka bude uza svakog vola i uza svakog ovna i uza svako živinče između ovaca ili koza. ");
INSERT INTO srp1865_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Prema broju koliko prinesete, učinite tako uza svako, koliko ih bude. ");
INSERT INTO srp1865_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Svaki domorodac tako neka čini prinoseći žrtvu paljenicu za miris ugodni Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Tako ako bude među vama i došljak ili ko bi se bavio među vama, pa bi prineo žrtvu ognjenu za miris ugodni Gospodu, neka čini onako kako vi činite. ");
INSERT INTO srp1865_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Zbore! Vama i došljaku koji je među vama jedan da je zakon, zakon večan od kolena na koleno; došljak će biti kao i vi pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Jedan zakon i jedna uredba da bude vama i došljaku, koji je među vama. ");
INSERT INTO srp1865_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Kaži sinovima Izrailjevim i reci im: Kad dođete u zemlju, u koju ću vas ja odvesti, ");
INSERT INTO srp1865_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","pa stanete jesti hleb one zemlje, tada prinesite prinos Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Od prvina testa svog prinosite u prinos kolač, kao prinos od gumna tako ga prinosite. ");
INSERT INTO srp1865_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Od prvina testa svog dajte Gospodu prinos od kolena do kolena. ");
INSERT INTO srp1865_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","A kad biste pogrešili, te ne biste učinili svih ovih zapovesti, koje kaza Gospod Mojsiju, ");
INSERT INTO srp1865_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","sve što vam je zapovedio Gospod preko Mojsija, od dana kad zapovedi Gospod i posle od kolena do kolena, ");
INSERT INTO srp1865_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ako se bude učinilo pogreškom, da zbor ne zna, onda sav zbor neka prinese na žrtvu paljenicu za miris ugodni Gospodu tele s darom njegovim i s nalivom njegovim po uredbi, i jedno jare na žrtvu za greh. ");
INSERT INTO srp1865_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","I sveštenik neka očisti sav zbor sinova Izrailjevih, i oprostiće im se, jer je pogreška i oni donesoše pred Gospoda svoj prinos za žrtvu ognjenu Gospodu i prinos za greh svoj radi pogreške svoje. ");
INSERT INTO srp1865_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Oprostiće se svemu zboru sinova Izrailjevih i došljaku koji se bavi među njima, jer je pogreška svega naroda. ");
INSERT INTO srp1865_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ako li jedna duša zgreši ne znajući, neka prinese kozu od godine na žrtvu za greh. ");
INSERT INTO srp1865_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","I sveštenik neka očisti dušu koja bude zgrešila ne znajući pred Gospodom, i kad je očisti oprostiće joj se. ");
INSERT INTO srp1865_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","I za rođenog u zemlji sinova Izrailjevih i za došljaka, koji se bavi među vama, jedan zakon neka bude kad ko zgreši ne znajući. ");
INSERT INTO srp1865_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ali ko od sile zgreši između rođenih u zemlji ili između došljaka, on ruži Gospoda; neka se istrebi duša ona iz naroda svog. ");
INSERT INTO srp1865_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Jer prezre reč Gospodnju, i zapovest Njegovu pogazi; neka se istrebi ona duša; bezakonje je njeno na njoj. ");
INSERT INTO srp1865_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","A kad behu sinovi Izrailjevi u pustinji, nađoše jednog gde kupi drva u subotu. ");
INSERT INTO srp1865_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","I koji ga nađoše gde kupi drva, dovedoše ga k Mojsiju i k Aronu i ka svemu zboru. ");
INSERT INTO srp1865_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","I metnuše ga pod stražu, jer ne beše kazano šta će se činiti s njim. ");
INSERT INTO srp1865_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","A Gospod reče Mojsiju: Neka se pogubi taj čovek; neka ga zaspe kamenjem sav zbor iza logora. ");
INSERT INTO srp1865_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","I sav zbor izvede ga iza logora i zasuše ga kamenjem, i umre, kao što zapovedi Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Reci sinovima Izrailjevim i kaži im, neka udaraju rese po skutovima od haljina svojih od kolena do kolena, i nad rese neka meću vrpcu plavu. ");
INSERT INTO srp1865_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","I imaćete rese zato da se gledajući ih opominjete svih zapovesti Gospodnjih i tvorite ih, i da se ne zanosite za srcem svojim i za očima svojim, za kojima činite preljubu; ");
INSERT INTO srp1865_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","nego da pamtite i tvorite sve zapovesti moje, i budete sveti Bogu svom. ");
INSERT INTO srp1865_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ja sam Gospod Bog vaš, koji sam vas izveo iz zemlje misirske, da vam budem Bog. Ja sam Gospod Bog vaš. ");
INSERT INTO srp1865_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","A Korej, sin Isara sina Kata sina Levijevog, i Datan i Aviron sinovi Elijavovi, i Avnan sin Faleta sina Ruvimovog pobuniše se, ");
INSERT INTO srp1865_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","i ustaše na Mojsija, i s njima dvesta i pedeset ljudi između sinova Izrailjevih, glavara narodnih, koji se sazivahu na zbor i behu ljudi znatni. ");
INSERT INTO srp1865_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","I skupiše se na Mojsija i na Arona i rekoše im: Dosta nek vam je; sav ovaj narod, svi su sveti, i među njima je Gospod; zašto se vi podižete nad zborom Gospodnjim? ");
INSERT INTO srp1865_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Kad to ču Mojsije, pade ničice. ");
INSERT INTO srp1865_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Potom reče Koreju i svoj družini njegovoj govoreći: Sutra će pokazati Gospod ko je Njegov, i ko je svet, i koga je pustio k sebi, jer koga je izabrao onog će pustiti k sebi. ");
INSERT INTO srp1865_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ovo učinite: Uzmite kadionice, Korej sa svom družinom svojom. ");
INSERT INTO srp1865_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","I metnite sutra u njih ognja i metnite u njih kada pred Gospodom, i koga izbere Gospod onaj će biti svet. Dosta nek vam je, sinovi Levijevi! ");
INSERT INTO srp1865_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","I reče Mojsije Koreju: Čujte sinovi Levijevi! ");
INSERT INTO srp1865_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Malo li vam je što vas je Bog Izrailjev odvojio od zbora Izrailjevog pustivši vas k sebi da vršite službu u šatoru Gospodnjem i da stojite pred zborom i služite za nj? ");
INSERT INTO srp1865_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Pustio je k sebi tebe i svu braću tvoju, sinove Levijeve, s tobom, a vi tražite još i sveštenstvo? ");
INSERT INTO srp1865_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Zato ti i sva družina tvoja skupite se na Gospoda. Jer Aron šta je da vičete na nj? ");
INSERT INTO srp1865_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","I posla Mojsije da dozovu Datana i Avirona, sinove Elijavove. A oni odgovoriše: Nećemo da idemo. ");
INSERT INTO srp1865_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Malo li je što si nas izveo iz zemlje u kojoj teče mleko i med da nas pobiješ u ovoj pustinji, nego još hoćeš da vladaš nad nama? ");
INSERT INTO srp1865_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Jesi li nas odveo u zemlju gde teče mleko i med? I jesi li nam dao da imamo njive i vinograde? Hoćeš li oči ovim ljudima da iskopaš? Nećemo da idemo. ");
INSERT INTO srp1865_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Tada se rasrdi Mojsije vrlo, i reče Gospodu: Nemoj pogledati na dar njihov; nijednog magarca nisam uzeo od njih, niti sam kome od njih učinio kakvo zlo. ");
INSERT INTO srp1865_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Potom reče Mojsije Koreju: Ti i svi tvoji stanite sutra pred Gospodom, ti i oni i Aron. ");
INSERT INTO srp1865_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","I uzmite svaki svoju kadionicu, i metnite u njih kada, i stanite pred Gospodom svaki sa svojom kadionicom, dvesta i pedeset kadionica, i ti i Aron, svaki sa svojom kadionicom. ");
INSERT INTO srp1865_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","I uzeše svaki svoju kadionicu, i metnuvši u njih ognja metnuše u njih kada, i stadoše na vrata šatora od sastanka s Mojsijem i Aronom. ");
INSERT INTO srp1865_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","A Korej sabra na njih sav zbor na vrata šatora od sastanka; tada se pokaza slava Gospodnja svemu zboru. ");
INSERT INTO srp1865_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","I reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Odvojte se iz tog zbora, da ih odmah satrem. ");
INSERT INTO srp1865_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","A oni padoše ničice i rekoše: Bože, Bože duhovima i svakom telu! Ovaj jedan zgrešio, i na sav li ćeš se zbor gneviti? ");
INSERT INTO srp1865_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Reci zboru i kaži: Odstupite od šatora Korejevog i Datanovog i Avironovog. ");
INSERT INTO srp1865_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","I ustavši Mojsije otide k Datanu i Avironu, a za njim otidoše starešine Izrailjeve. ");
INSERT INTO srp1865_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","I reče zboru govoreći: Odstupite od šatora tih bezbožnika, i ne dodevajte se ničeg što je njihovo, da ne izginete sa svih greha njihovih. ");
INSERT INTO srp1865_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","I odstupiše sa svih strana od šatora Korejevog i Datanovog I Avironovog; a Datan i Aviron izašavši stadoše svaki na vrata od šatora svog sa ženama svojim i sa sinovima svojim i s decom svojom. ");
INSERT INTO srp1865_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Tada reče Mojsije: Ovako ćete poznati da me je Gospod poslao da činim sva ova dela, i da ništa ne činim od sebe: ");
INSERT INTO srp1865_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ako ovi pomru kao što mru svi ljudi, i ako budu pokarani kao što bivaju pokarani svi ljudi, nije me poslao Gospod; ");
INSERT INTO srp1865_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ako li šta novo učini Gospod, i zemlja otvori usta svoja i proždre ih sa svim što je njihovo, i siđu živi u grob, tada znajte da su ovi ljudi uvredili Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","A kad izgovori reči ove, rasede se zemlja pod njima, ");
INSERT INTO srp1865_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","i otvorivši zemlja usta svoja proždre ih, i domove njihove i sve ljude Korejeve i sve blago njihovo. ");
INSERT INTO srp1865_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","I tako siđoše sa svim što imahu živi u grob, i pokri ih zemlja i nesta ih iz zbora. ");
INSERT INTO srp1865_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","A svi Izrailjci koji behu oko njih pobegoše od vike njihove, jer govorahu: Da nas ne proždre zemlja. ");
INSERT INTO srp1865_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","I izađe oganj od Gospoda, i sažeže onih dvesta i pedeset ljudi koji prinesoše kad. ");
INSERT INTO srp1865_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Tada reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Kaži Eleazaru, sinu Arona sveštenika neka pokupi kadionice iz tog garišta, i ugljevlje iz njih neka razbaci, jer su svete; ");
INSERT INTO srp1865_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","kadionice onih koji ogrešiše duše svoje neka raskuju na ploče da se okuje oltar, jer kadiše njima pred Gospodom, zato su svete, i neka budu sinovima Izrailjevim znak. ");
INSERT INTO srp1865_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","I pokupi Eleazar sveštenik kadionice bronzane, kojima behu kadili oni što izgoreše, i raskovaše ih na okov oltaru ");
INSERT INTO srp1865_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","za spomen sinovima Izrailjevim, da ne pristupa niko drugi koji nije roda Aronovog da kadi pred Gospodom, da mu ne bude kao Koreju i družini njegovoj, kao što mu beše kazao Gospod preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","A sutradan vikaše sav zbor sinova Izrailjevih na Mojsija i na Arona govoreći: Pobiste narod Gospodnji. ");
INSERT INTO srp1865_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","A kad se stecaše narod na Mojsija i na Arona, pogledaše na šator od sastanka, a to oblak na njemu, i pokaza se slava Gospodnja. ");
INSERT INTO srp1865_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","I dođe Mojsije i Aron pred šator od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Uklonite se iz tog zbora da ih odmah potrem. A oni padoše ničice. ");
INSERT INTO srp1865_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","I reče Mojsije Aronu: Uzmi kadionicu, i metni u nju ognja s oltara, i metni kada, i idi brže ka zboru, i očisti ih; jer gnev žestok izađe od Gospoda, i pomor poče. ");
INSERT INTO srp1865_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","I uzevši Aron kadionicu, kao što mu reče Mojsije, otrča usred zbora, i gle, pomor već beše počeo u narodu; i okadiv očisti narod. ");
INSERT INTO srp1865_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","I stajaše među mrtvima i živima, i ustavi se pomor. ");
INSERT INTO srp1865_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","A onih koji pomreše od tog pomora beše četrnaest hiljada i sedam stotina, osim onih što izgiboše s Koreja. ");
INSERT INTO srp1865_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","I vrati se Aron k Mojsiju na vrata šatora od sastanka, kad se ustavi pomor. ");
INSERT INTO srp1865_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Potom reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Reci sinovima Izrailjevim, i uzmi od njih po jednu palicu od svakog doma otaca njihovih, od svih knezova njihovih, po domovima otaca njihovih, dvanaest palica, i ime svakog napiši na palici njegovoj. ");
INSERT INTO srp1865_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","A na palici Levijevoj napiši ime Aronovo, jer je svaka palica za jednog poglavara od doma otaca njihovih. ");
INSERT INTO srp1865_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","I ostavi ih u šatoru od sastanka pred svedočanstvom, gde se sastajem s vama. ");
INSERT INTO srp1865_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","I koga izaberem, njegova će palica procvetati; tako ću utišati pred sobom viku sinova Izrailjevih što viču na vas. ");
INSERT INTO srp1865_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Kad to reče Mojsije sinovima Izrailjevim, dadoše mu svi knezovi njihovi palice, svaki knez po palicu od doma oca svog, dvanaest palica, i palica Aronova beše među palicama njihovim. ");
INSERT INTO srp1865_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","I ostavi Mojsije palice pred Gospodom u šatoru od svedočanstva. ");
INSERT INTO srp1865_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","A sutradan dođe Mojsije u šator od svedočanstva, i gle, procvetala palica Aronova od doma Levijevog; beše napupila i cvetala, i bademi zreli na njoj. ");
INSERT INTO srp1865_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","I iznese Mojsije sve one palice ispred Gospoda k svim sinovima Izrailjevim, i razgledavši ih uzeše svaki svoju palicu. ");
INSERT INTO srp1865_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","A Gospod reče Mojsiju: Donesi opet palicu Aronovu pred svedočanstvo da se čuva za znak nepokornima, da prestane vika njihova na me, da ne izginu. ");
INSERT INTO srp1865_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","I učini Mojsije, kako mu zapovedi Gospod tako učini. ");
INSERT INTO srp1865_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Tada rekoše sinovi Izrailjevi Mojsiju govoreći: Pomresmo, propadosmo, svi propadosmo. ");
INSERT INTO srp1865_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ko se god približi k šatoru Gospodnjem gine; hoćemo li svi izginuti? ");
INSERT INTO srp1865_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","A Gospod reče Aronu: Ti i sinovi tvoji i dom oca tvog s tobom nosite grehe u svetinju; ti i sinovi tvoji s tobom nosite grehe sveštenstva svog. ");
INSERT INTO srp1865_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","I braću svoju, pleme Levijevo, pleme oca svog uzmi k sebi da budu uza te i služe ti; a ti ćeš i sinovi tvoji s tobom služiti pred šatorom od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Neka dobro slušaju zapovesti tvoje i rade šta treba u svem šatoru; ali k sudovima od svetinje k oltaru neka ne pristupaju, da ne izginu i oni i vi. ");
INSERT INTO srp1865_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Neka budu, dakle, uza te i neka rade sve što treba u šatoru od sastanka u svakoj službi u njemu; ali niko drugi da ne pristupi s vama. ");
INSERT INTO srp1865_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","A vi radite šta treba u svetinji i šta treba na oltaru, da više ne dođe gnev na sinove Izrailjeve. ");
INSERT INTO srp1865_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Jer evo, ja uzeh braću vašu Levite između sinova Izrailjevih, i vama su dani na dar za Gospoda, da vrše službu u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","A ti i sinovi tvoji s tobom vršite svešteničku službu svoju u svemu što pripada k oltaru i šta biva iza zavesa, i služite; sveštenstvo darovah vam, zato ko bi drugi pristupio, da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Još reče Gospod Aronu: Evo, dajem ti i prinose svoje što se uvis podižu, između svih stvari koje posvećuju sinovi Izrailjevi dajem ih tebi radi pomazanja i sinovima tvojim zakonom večnim. ");
INSERT INTO srp1865_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","To neka je tvoje od stvari posvećenih, koje se ne sažižu; svaki prinos njihov između svih darova njihovih i između svih prinosa za greh i svih prinosa za krivicu, koje mi donesu, svetinja nad svetinjama da je tvoja i sinova tvojih. ");
INSERT INTO srp1865_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","U svetinji ga jedi, sve muškinje neka ga jede, sveta stvar da ti je. ");
INSERT INTO srp1865_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Tvoje su, dakle, žrtve darova njihovih koje se u vis podižu; i svaku žrtvu sinova Izrailjevih koja se obrće tebi dajem i sinovima tvojim i kćerima tvojim s tobom zakonom večnim; ko je god čist u domu tvom, neka jede. ");
INSERT INTO srp1865_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Najbolje od ulja i najbolje od vina i žita, prvine koje daju Gospodu, tebi dajem. ");
INSERT INTO srp1865_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Prvine od svega što rodi u zemlji njihovoj, koje donesu Gospodu, tvoje neka budu; ko je god čist u domu tvom neka jede. ");
INSERT INTO srp1865_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Sve zavetovano Bogu i Izrailju, tvoje neka je. ");
INSERT INTO srp1865_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Šta god otvara matericu između svakog tela koje prinose Gospodu, i između ljudi i između stoke, tvoje da bude; ali prvenac čovečji neka se otkupljuje; i prvenac nečiste stoke neka se otkupljuje. ");
INSERT INTO srp1865_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","A otkup neka mu bude kad bude od meseca dana po tvojoj ceni pet sikala srebra, po siklu svetom; u njemu je dvadeset gera. ");
INSERT INTO srp1865_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","A prvenca od krave ili prvenca od ovce ili prvenca od koze ne daj da se otkupi; svete su stvari; krvlju njihovom pokropi oltar, i salo njihovo zapali, da bude žrtva ognjena za miris ugodni Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","A meso od njih da je tvoje, kao grudi što se obrću i kao pleće desno, da je tvoje. ");
INSERT INTO srp1865_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Sve prinose što se podižu od posvećenih stvari, što prinose sinovi Izrailjevi Gospodu, dajem tebi i sinovima tvojim i kćerima tvojim s tobom zakonom večnim; to će biti zavet osoljen, večan pred Gospodom tebi i semenu tvom s tobom. ");
INSERT INTO srp1865_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Još reče Gospod Aronu: U zemlji njihovoj da nemaš nasledstvo, ni dela među njima da nemaš; ja sam deo tvoj i tvoje nasledstvo među sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","A sinovima Levijevim evo dajem u nasledstvo sve desetke od Izrailja za službu njihovu što služe u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","A sinovi Izrailjevi neka više ne pristupaju k šatoru od sastanka, da se ne ogreše i ne izginu. ");
INSERT INTO srp1865_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Nego sami Leviti neka služe službu u šatoru od sastanka, i oni neka nose greh svoj zakonom večnim od kolena do kolena, pa da nemaju nasledstvo među sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Jer desetke sinova Izrailjevih, što će donositi Gospodu na žrtvu što se podiže, dajem Levitima u nasledstvo; toga radi rekoh za njih; među sinovima Izrailjevim da nemaju nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Reci Levitima i kaži im: Kad uzmete od sinova Izrailjevih desetak koji vam dadoh od njih za nasledstvo vaše, onda prinesite od njega prinos što se podiže Gospodu, deseto od desetog. ");
INSERT INTO srp1865_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","I primiće vam se prinos vaš kao žito s gumna i kao vino iz kace. ");
INSERT INTO srp1865_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Tako i vi prinosite prinos što se podiže Gospodu od svih desetaka svojih, koje ćete uzimati od sinova Izrailjevih, i dajite od njih prinos Gospodnji Aronu svešteniku. ");
INSERT INTO srp1865_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Od svega što vam se da prinosite svaki prinos što se podiže Gospodu, od svega što bude najbolje sveti deo. ");
INSERT INTO srp1865_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","I reci im: Kad prinesete najbolje od toga, tada će se primiti Levitima kao dohodak od gumna i kao dohodak od kace. ");
INSERT INTO srp1865_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","A jesti možete to na svakom mestu i vi i porodice vaše, jer vam je plata za službu vašu u šatoru od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","I nećete zato navući na se greha, kad stanete prinositi šta je najbolje, i nećete oskvrniti svete stvari sinova Izrailjevih, i nećete izginuti. ");
INSERT INTO srp1865_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Još reče Gospod Mojsiju i Aronu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Ovo je uredba i zakon što zapovedi Gospod govoreći: Reci sinovima Izrailjevim neka ti dovedu junicu crvenu zdravu, na kojoj nema mane, i koja još nije bila u jarmu; ");
INSERT INTO srp1865_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","i podajte je Eleazaru svešteniku, a on neka je izvede napolje iz logora da je zakolju pred njim. ");
INSERT INTO srp1865_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","I uzevši Eleazar krvi njene na prst svoj neka pokropi krvlju prema šatoru od sastanka sedam puta. ");
INSERT INTO srp1865_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Potom neka zapovedi da se spali junica pred njegovim očima; kožu njenu i meso njeno i krv njenu s balegom neka spale. ");
INSERT INTO srp1865_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","I sveštenik uzevši drveta kedrovog, isopa i crvca, neka baci u oganj gde gori junica. ");
INSERT INTO srp1865_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Potom neka opere haljine svoje i opere telo svoje vodom, pa onda neka uđe u logor, i neka bude sveštenik nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Tako i ko je spali, neka opere haljine svoje vodom, i telo svoje neka opere vodom, i neka bude nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","A čist čovek neka pokupi pepeo od junice i izruči ga iza logora na čisto mesto, da se čuva zboru sinova Izrailjevih za vodu očišćenja; to je žrtva za greh. ");
INSERT INTO srp1865_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","I onaj koji pokupi pepeo od junice neka opere haljine svoje, i neka bude nečist do večera. To neka je sinovima Izrailjevim i došljaku koji se bavi među njima večan zakon. ");
INSERT INTO srp1865_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ko se dotakne mrtvog tela čovečijeg, da je nečist sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","On neka se očisti onom vodom treći dan i sedmi dan, i biće čist; ako li se ne očisti treći dan i sedmi, neće biti čist. ");
INSERT INTO srp1865_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ko se dotakne mrtvog tela čovečijeg pa se ne očisti, onaj je oskrvnio šator Gospodnji; zato da se istrebi ona duša iz Izrailja; jer nije pokropljen vodom očišćenja, zato je nečist, i nečistota je njegova na njemu. ");
INSERT INTO srp1865_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ovo je zakon kad čovek umre u šatoru: Ko god uđe u onaj šator i ko god bude u šatoru, nečist da je sedam dana; ");
INSERT INTO srp1865_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","i svaki sud otkriven, koji ne bude dobro zaklopljen, nečist je. ");
INSERT INTO srp1865_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","I ko se god dotakne u polju posečenog mačem ili umrlog ili kosti čovečije ili groba, nečist da je sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","I neka za nečistog uzmu pepela od junice spaljene za greh, i neka naliju na nj vode žive u sud. ");
INSERT INTO srp1865_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Potom neka uzme čist čovek isopa i zamoči u onu vodu, i pokropi njom šator i sve sude i ljude koji su u njemu bili; tako i onog koji bi se dotakao kosti ili čoveka posečenog ili umrla ili groba. ");
INSERT INTO srp1865_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Čisti nečistog neka pokropi treći i sedmi dan; i kad ga očisti sedmi dan, neka opere haljine svoje i sebe neka opere vodom, i biće čist uveče. ");
INSERT INTO srp1865_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","A ko bude nečist pa se ne očisti, da se istrebi ona duša iz zbora; jer je svetinju Gospodnju oskvrnio, a nije pokropljen vodom očišćenja; nečist je. ");
INSERT INTO srp1865_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","I ovo neka im je zakon večan: i koji pokropi vodom očišćenja, neka opere haljine svoje; i ko se god dotakne vode očišćenja, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","I čega se god dotakne ko je nečist, da je nečisto; i ko se njega dotakne, da je nečist do večera. ");
INSERT INTO srp1865_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","I sinovi Izrailjevi, sav zbor njihov, dođoše u pustinju sinsku prvog meseca, i stade narod u Kadisu; i onde umre Marija, i bi pogrebena onde. ");
INSERT INTO srp1865_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","A onde nemaše zbor vode, te se skupiše na Mojsija i na Arona. ");
INSERT INTO srp1865_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","I svađaše se narod s Mojsijem, i govorahu: Kamo da smo pomrli kad pomreše braća naša pred Gospodom! ");
INSERT INTO srp1865_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Zašto dovedoste zbor Gospodnji u ovu pustinju da izginemo ovde i mi i stoka naša? ");
INSERT INTO srp1865_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","I zašto nas izvedoste iz Misira da nas dovedete na ovo zlo mesto, gde ne rodi ni žito ni smokva ni grožđe ni šipak, a ni vode nema za piće? ");
INSERT INTO srp1865_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","I dođe Mojsije i Aron ispred zbora na vrata šatora od sastanka, i padoše ničice; i pokaza im se slava Gospodnja. ");
INSERT INTO srp1865_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Uzmi štap, i sazovite zbor ti i Aron brat tvoj, i progovorite steni pred njima; te će dati vodu svoju; tako ćeš im izvesti vodu iz stene, i napojićeš zbor i stoku njihovu. ");
INSERT INTO srp1865_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","I Mojsije uze štap ispred Gospoda, kako mu zapovedi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","I sazvaše Mojsije i Aron zbor pred stenu, i on im reče: Slušajte odmetnici! Hoćemo li vam iz ove stene izvesti vodu? ");
INSERT INTO srp1865_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","I diže Mojsije ruku svoju i udari u stenu štapom svojim dva puta, i iziđe voda mnoga, te se napoji narod i stoka njihova. ");
INSERT INTO srp1865_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","A Gospod reče Mojsiju i Aronu: Što mi ne verovaste i ne proslaviste me pred sinovima Izrailjevim, zato nećete odvesti zbora tog u zemlju koju sam im dao. ");
INSERT INTO srp1865_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","To je voda od svađe, gde se svađaše sinovi Izrailjevi s Gospodom, i On se proslavi među njima. ");
INSERT INTO srp1865_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Iza toga posla Mojsije poslanike iz Kadisa k caru edomskom da mu kažu: Ovako kaže brat tvoj Izrailj: Ti znaš sve nevolje koje nas snađoše: ");
INSERT INTO srp1865_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Kako naši oci siđoše u Misir, i bejasmo u Misiru dugo vremena, i kako Misirci zlo činiše nama i ocima našim; ");
INSERT INTO srp1865_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","i vikasmo ka Gospodu, i Gospod ču glas naš, i posla anđela, koji nas izvede iz Misira; i evo smo u Kadisu, gradu na tvojoj međi. ");
INSERT INTO srp1865_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Pusti nas da prođemo kroz tvoju zemlju; nećemo ići preko polja ni preko vinograda, niti ćemo piti vode iz kog studenca; ići ćemo carskim putem, nećemo svratiti ni na desno ni nalevo dok ne pređemo među tvoju. ");
INSERT INTO srp1865_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","A Edom mu odgovori: Ne idi preko moje zemlje, da ne iziđem s mačem preda te. ");
INSERT INTO srp1865_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","A sinovi Izrailjevi rekoše mu: Ići ćemo utrenikom, i ako se napijemo vode tvoje, mi ili stoka naša, platićemo je; ništa više, samo da pešice prođemo. ");
INSERT INTO srp1865_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","A on im odgovori: Nećete proći. I iziđe Edom pred njih s mnogo naroda i s velikom silom. ");
INSERT INTO srp1865_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","I kad ne hte Edom dopustiti Izrailju da priđe preko međe njegove, Izrailj otide od njega. ");
INSERT INTO srp1865_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","I krenuvši se od Kadisa dođoše sinovi Izrailjevi, sav zbor njihov, ka gori Oru. ");
INSERT INTO srp1865_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","I Gospod reče Mojsiju i Aronu na gori Oru kod međe edomske govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aron valja da se pribere k rodu svom, jer neće ući u zemlju koju sam dao sinovima Izrailjevim, jer ne poslušaste zapovesti moje na vodi od svađe. ");
INSERT INTO srp1865_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Uzmi Arona i Eleazara sina njegovog, i izvedi ih na goru Or. ");
INSERT INTO srp1865_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","I svuci Aronu haljine njegove i obuci ih Eleazaru sinu njegovom, pa će se Aron pribrati i umreti onde. ");
INSERT INTO srp1865_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","I učini Mojsije kako zapovedi Gospod; i iziđoše na goru Or pred svim zborom. ");
INSERT INTO srp1865_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","I svuče Mojsije s Arona haljine njegove i obuče ih Eleazaru, sinu njegovom, i umre onde Aron navrh gore, a Mojsije i Eleazar siđoše s gore. ");
INSERT INTO srp1865_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","A kad vide sav zbor da umre Aron, plaka sav dom Izrailjev za Aronom trideset dana. ");
INSERT INTO srp1865_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","A kad ču Hananej, car aradski, koji življaše na jugu, da ide Izrailj putem kojim idoše uhode, on se pobi s njima i zarobi ih nekoliko. ");
INSERT INTO srp1865_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Tada se Izrailj zavetova Gospodu i reče: Ako daš ovaj narod meni u ruke, do temelja ću raskopati gradove njihove. ");
INSERT INTO srp1865_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","I usliši Gospod glas Izrailjev i dade mu Hananeje, a on zatre njih i gradove njihove, i prozva ono mesto Orma. ");
INSERT INTO srp1865_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Potom pođoše od gore Ora k Crvenom moru obilazeći zemlju edomsku, i oslabi duh narodu od puta. ");
INSERT INTO srp1865_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","I vikaše narod na Boga i na Mojsija: Zašto nas izvedoste iz Misira da izginemo u ovoj pustinji? Jer nema ni hleba ni vode, a ovaj se nikakvi hleb već ogadio duši našoj. ");
INSERT INTO srp1865_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","A Gospod pusti na narod zmije vatrene, koje ih ujedahu, te pomre mnogo naroda u Izrailju. ");
INSERT INTO srp1865_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Tada dođe narod k Mojsiju i rekoše: Zgrešismo što vikasmo na Gospoda i na tebe; moli Boga neka ukloni zmije od nas. I Mojsije se pomoli za narod. ");
INSERT INTO srp1865_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","I Gospod reče Mojsiju: Načini zmiju vatrenu, i metni je na motku, i koga ujede zmija, neka pogleda u nju, pa će ozdraviti. ");
INSERT INTO srp1865_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","I načini Mojsije zmiju od bronze, i metnu je na motku, i koga god ujede zmija on pogleda u zmiju od bronze, i ozdravi. ");
INSERT INTO srp1865_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Potom pođoše sinovi Izrailjevi, i stadoše u logor u Ovotu. ");
INSERT INTO srp1865_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","I iz Ovota otišavši stadoše u logor na brdima avarimskim u pustinji koja je prema moavskoj s istoka. ");
INSERT INTO srp1865_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Odande otišavši stadoše u logor u dolini Zaredu. ");
INSERT INTO srp1865_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","I odatle otišavši stadoše u logor na brdu na Arnonu, koji je u pustinji i izlazi od međe amorejske. Jer je Arnon međa moavska između Moavaca i Amorejaca. ");
INSERT INTO srp1865_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Zato se kaže u knjizi o ratovima Gospodnjim: Na Vajeva u Sufi i na potoke arnonske. ");
INSERT INTO srp1865_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Jer ti potoci, koji dopiru do mesta Ara, teku pokraj međe moavske. ");
INSERT INTO srp1865_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","A otuda dođoše k Viru; to je studenac za koji beše rekao Gospod Mojsiju: Skupi narod, i daću im vode. ");
INSERT INTO srp1865_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tada peva Izrailj pesmu ovu: Diži se, studenče; pripevajte ga; ");
INSERT INTO srp1865_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Studenče, koji kopaše knezovi, koji iskopaše poglavari narodni s onim koji postavi zakon, palicama svojim. A iz pustinje otidoše u Mantanail, ");
INSERT INTO srp1865_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","a iz Mantanaila, u Nadil, a iz Nadila u Vamot, ");
INSERT INTO srp1865_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","a iz Vamota u dolinu koja je u polju moavskom kod gore Fazge i gleda u pustinju. ");
INSERT INTO srp1865_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Tada posla Izrailj poslanike k Sionu, caru amorejskom govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Pusti da prođemo kroz tvoju zemlju, nećemo svrtati ni u polje ni u vinograd, niti ćemo piti vode iz studenaca; ići ćemo carskim putem dokle ne pređemo među tvoju. ");
INSERT INTO srp1865_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ali ne dade Sion Izrailju da prođe kroz zemlju njegovu, nego sabra Sion sav narod svoj, i izađe na Izrailja u pustinju, i dođe u Jasu, i pobi se s Izrailjem. ");
INSERT INTO srp1865_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ali ga iseče Izrailj oštrim mačem, i osvoji zemlju njegovu od Arona pa do Javoka, do sinova Amonovih, jer tvrda beše međa sinova Amonovih. ");
INSERT INTO srp1865_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","I uze Izrailj sva ona mesta i naseli se u svim gradovima amorejskim, u Esevonu i u svim selima njegovim. ");
INSERT INTO srp1865_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Jer Esevon beše grad Siona, cara amorejskog, koji beše prvi zavojštio na cara moavskog i beše mu uzeo svu zemlju njegovu do Arnona. ");
INSERT INTO srp1865_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Zato govore u priči: Hodite u Esevon, da se sagradi i podigne grad Sionov. ");
INSERT INTO srp1865_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Jer oganj izađe iz Esevona, plamen iz grada Sionovog, i spali Ar moavski i stanovnike na visini arnonskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Teško tebi, Moave; propao si, narode Hemosov; dao je sinove svoje koji utekoše i kćeri svoje u ropstvo Sionu, caru amorejskom. ");
INSERT INTO srp1865_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ali ih postreljasmo, propade Esevon do Devona, i potrsmo ih do Nofe, koja dopire do Medeve. ");
INSERT INTO srp1865_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","I tako živi Izrailj u zemlji amorejskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Potom posla Mojsije da uhode Jazir, i uzeše sela oko njega, i izagnaše Amorejce koji behu onde. ");
INSERT INTO srp1865_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Potom obrativši se pođoše u Vasan; i iziđe Og, car vasanski pred njih, on i sav narod njegov na boj u Edrajin. ");
INSERT INTO srp1865_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","A Gospod reče Mojsiju: Ne boj ga se; jer sam ga dao u tvoje ruke i sav narod njegov i zemlju njegovu; i učini mu kako si učinio Sionu, caru Amorejskom koji življaše u Esevonu. ");
INSERT INTO srp1865_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","I pobiše ga i sinove njegove i sav narod njegov, da ne osta nijedan, i osvojiše zemlju njegovu. ");
INSERT INTO srp1865_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Odatle se podigoše sinovi Izrailjevi, i stadoše u logor u polju moavskom s one strane Jordana prema Jerihonu. ");
INSERT INTO srp1865_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","I vide Valak, sin Seforov sve što učini Izrailj Amoreju. ");
INSERT INTO srp1865_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","I uplaši se Moav od naroda veoma; jer ga beše mnogo, i prituži Moavu od sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Pa reče Moav starešinama madijanskim: Sada će ova množina pojesti sve što je oko nas kao vo travu u polju. A Valak, sin Seforov beše u ono vreme car moavski. ");
INSERT INTO srp1865_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","I posla poslanike k Valamu, sinu Veorovom u Faturu, koja je na reci u zemlji naroda njegovog, govoreći: Evo narod iziđe iz Misira, evo prekrilo je zemlju, i stoji prema meni. ");
INSERT INTO srp1865_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Nego hodi, prokuni mi ovaj narod, jer je jači od mene, e da bih mu odoleo i pobio ga ili isterao iz zemlje ove; jer znam, koga blagosloviš biće blagosloven, a koga prokuneš biće proklet. ");
INSERT INTO srp1865_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","I otidoše starešine moavske i starešine madijanske noseći darove za vračanje; i dođoše k Valamu, i kazaše mu reči Valakove. ");
INSERT INTO srp1865_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","A on im reče: Ostanite ovde ovu noć, i odgovoriću vam kako mi Gospod kaže. I ostaše knezovi moavski kod Valama. ");
INSERT INTO srp1865_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","A Bog dođe k Valamu i reče mu: Kakvi su to ljudi kod tebe? ");
INSERT INTO srp1865_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","I reče Valam Bogu: Valak sin Seforov, car moavski, posla ih k meni govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Evo narod iziđe iz Misira i prekrili zemlju; nego hodi, prokuni mi ga, e da bih ga nadbio i oterao ga. ");
INSERT INTO srp1865_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","A Bog reče Valamu: Ne idi s njima, niti kuni taj narod, jer je blagosloven. ");
INSERT INTO srp1865_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","I ujutru ustavši Valam reče knezovima Valakovim; vratite se u svoju zemlju jer mi ne da Bog da idem s vama. ");
INSERT INTO srp1865_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","I ustavši knezovi moavski dođoše k Valaku, i rekoše: Ne hte Valam poći s nama. ");
INSERT INTO srp1865_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Tada opet posla Valak više knezova i veće od prvih. ");
INSERT INTO srp1865_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","I oni došavši k Valamu rekoše mu: Ovako veli Valak, sin Seforov: Nemoj se zatezati, molim te, nego dođi k meni. ");
INSERT INTO srp1865_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Jer ću te dobro darivati, i šta mi god kažeš činiću; zato dođi, molim te, prokuni mi ovaj narod. ");
INSERT INTO srp1865_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","A Valam odgovori i reče slugama Valakovim: Da mi da Valak kuću svoju punu srebra i zlata, ne bih mogao prestupiti reči Gospoda Boga svog da učinim šta malo ili veliko. ");
INSERT INTO srp1865_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ali opet ostanite ovde i vi ovu noć da vidim šta će mi sada kazati Gospod. ");
INSERT INTO srp1865_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","I dođe Bog noću k Valamu i reče mu: Kad su došli ti ljudi da te zovu, ustani, idi s njima, ali šta ti kažem ono da činiš. ");
INSERT INTO srp1865_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","A ujutru ustavši Valam osamari magaricu svoju, i pođe s knezovima moavskim. ");
INSERT INTO srp1865_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ali se razgnevi Bog što on pođe; i stade anđeo Gospodnji na put da mu ne da; a on seđaše na magarici svojoj i imaše sa sobom dva momka svoja. ");
INSERT INTO srp1865_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","A kad magarica vide anđela Gospodnjeg gde stoji na putu s golim mačem u ruci, svrnu magarica s puta i pođe preko polja. A Valam je stade biti da je vrati na put. ");
INSERT INTO srp1865_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","A anđeo Gospodnji stade na stazu među vinogradima, a beše zid i odovud i odonud. ");
INSERT INTO srp1865_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","I magarica videći anđela Gospodnjeg pribi se uz drugi zid, i pritište nogu Valamovu o zid; a on je stade opet biti. ");
INSERT INTO srp1865_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Potom anđeo Gospodnji otide dalje, i stade u tesnacu, gde ne beše mesta da se svrne ni nadesno ni nalevo. ");
INSERT INTO srp1865_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","I magarica videći anđela Gospodnjeg pade pod Valamom, a Valam se vrlo razljuti, i stade biti magaricu svojim štapom. ");
INSERT INTO srp1865_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Tada Gospod otvori usta magarici, te ona reče Valamu: Šta sam ti učinila, te me biješ već treći put? ");
INSERT INTO srp1865_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","A Valam reče magarici: Što mi prkosiš? Da imam mač u ruci, sad bih te ubio. ");
INSERT INTO srp1865_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","A magarica reče Valamu: Nisam li tvoja magarica? Jašeš me od kako sam postala tvoja do danas; jesam li ti kad tako učinila? A on reče: Nisi. ");
INSERT INTO srp1865_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Tada Gospod otvori oči Valamu, koji ugleda anđela Gospodnjeg gde stoji na putu s golim mačem u ruci. I on savi glavu i pokloni se licem svojim. ");
INSERT INTO srp1865_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","I reče mu anđeo Gospodnji: Zašto si bio magaricu svoju već tri puta? Evo ja iziđoh da ti ne dam, jer tvoj put nije meni po volji. ");
INSERT INTO srp1865_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Kad me ugleda magarica, ona se ukloni ispred mene već tri puta; a da se nije uklonila ispred mene, tebe bih već ubio, a nju bih ostavio u životu. ");
INSERT INTO srp1865_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","A Valam reče anđelu Gospodnjem: Zgrešio sam, jer nisam znao da ti stojiš preda mnom na putu; ako tebi nije po volji, ja ću se vratiti. ");
INSERT INTO srp1865_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","A anđeo Gospodnji reče Valamu: Idi s tim ljudima, ali samo ono govori što ti ja kažem. Tada Valam otide s knezovima Valakovim. ");
INSERT INTO srp1865_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","A kad ču Valak da ide Valam, iziđe mu na susret u grad moavski na međi arnonskoj nakraj međe. ");
INSERT INTO srp1865_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","I reče Valak Valamu: Nisam li slao k tebi i zvao te? Zašto mi ne dođe? Eda li te ne mogu darivati? ");
INSERT INTO srp1865_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","A Valam reče Valaku: Evo sam došao k tebi; ali hoću li moći šta govoriti? Šta mi Bog metne u usta, ono ću govoriti. ");
INSERT INTO srp1865_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","I otide Valam s Valakom, i dođoše u grad Uzot. ");
INSERT INTO srp1865_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","I nakla Valak volova i ovaca, i posla Valamu i knezovima, koji behu s njim. ");
INSERT INTO srp1865_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","A ujutru uze Valak Valama i odvede ga na visinu Valovu, i odande mu pokaza jedan kraj naroda. ");
INSERT INTO srp1865_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","I reče Valam Valaku: Načini mi ovde sedam oltara, i pripravi mi ovde sedam telaca i sedam ovnova. ");
INSERT INTO srp1865_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","I učini Valak kako mu reče Valam; i prinese Valak s Valamom na svakom oltaru po jedno tele i ovna. ");
INSERT INTO srp1865_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Pa reče Valam Valaku: Stoj kod svoje žrtve paljenice; a ja idem eda bih se sreo s Gospodom, pa šta mi javi kazaću ti. I on otide sam. ");
INSERT INTO srp1865_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","I srete Bog Valama, a on mu reče: Sedam oltara spremnih, i prinesoh po tele i ovna na svakom oltaru. ");
INSERT INTO srp1865_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","A Gospod metnu reči u usta Valamu, i reče vrati se k Valaku i tako mu reci. ");
INSERT INTO srp1865_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","I vrati se k njemu, a on stajaše kod žrtve svoje paljenice i svi knezovi moavski. ");
INSERT INTO srp1865_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","A on otvori priču svoju, i reče: Iz Arama dovede me Valak, car moavski s planine istočne, govoreći: Hodi, prokuni mi Jakova, hodi, naruži Izrailja. ");
INSERT INTO srp1865_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Kako bih kleo onog koga ne kune Bog? Ili kako bih ružio onog koga Gospod ne ruži? ");
INSERT INTO srp1865_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Jer svrh stena vidim ga, i s humova gledam ga. Gle, ovaj će narod nastavati sam, i s drugim narodima neće se pomešati. ");
INSERT INTO srp1865_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ko će izbrojati prah Jakovljev i broj od četvrti Izrailja? Da bih ja umro smrću pravedničkom, i kraj moj da bi bio kao njihov! ");
INSERT INTO srp1865_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Tada reče Valak Valamu: Šta to radiš od mene? Ja te dozvah da prokuneš neprijatelje moje, a gle, ti blagosiljaš jednako. ");
INSERT INTO srp1865_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","A on odgovori i reče: Zar neću paziti i govoriti ono što mi je Gospod metnuo u usta? ");
INSERT INTO srp1865_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Tada mu reče Valak: Hodi sa mnom na drugo mesto, odakle ćeš ga videti; samo mu kraj vidiš, a svega ga ne vidiš; prokuni mi ga odande. ");
INSERT INTO srp1865_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","I dovede ga u polje Zofim, navrh Fazge, i načini sedam oltara, i prinese na svakom oltaru po jedno tele i ovna. ");
INSERT INTO srp1865_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Tada Valam reče Valaku: Stoj tu kod žrtve svoje paljenice, a ja idem onamo na susret Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","I srete Gospod Valama, i metnu mu reč u usta, i reče: Vrati se k Valaku, i tako govori. ");
INSERT INTO srp1865_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","I dođe k njemu, a on stajaše kod žrtve svoje paljenice i s njim knezovi moavski; i reče Valak: Šta veli Gospod? ");
INSERT INTO srp1865_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","A on otvori priču svoju, i reče: Ustani Valače, i poslušaj, čuj me sine Seforov! ");
INSERT INTO srp1865_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Bog nije čovek da laže, ni sin čovečji da se pokaje. Šta kaže neće li učiniti, i šta reče neće li izvršiti? ");
INSERT INTO srp1865_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Gle, primih da blagoslovim; jer je On blagoslovio, a ja neću poreći. ");
INSERT INTO srp1865_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ne gleda na bezakonje u Jakovu ni na nevaljalstvo u Izrailju; Gospod je njegov s njim, i graja u njemu kao car kad nadvlada. ");
INSERT INTO srp1865_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Bog ga je izveo iz Misira, On mu je kao snaga jednorogova. ");
INSERT INTO srp1865_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Jer nema čini na Jakova ni vračanja na Izrailja; u ovo doba govoriće se o Jakovu i o Izrailju, što je učinio Bog. ");
INSERT INTO srp1865_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Evo, narod će ustati kao silan lav, i kao lavić skočiće; neće leći dokle ne pojede lov i popije krv pobijenih. ");
INSERT INTO srp1865_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Tada reče Valak Valamu: Nemoj ga ni kleti ni blagosiljati. ");
INSERT INTO srp1865_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","A Valam odgovori Valaku: Nisam li ti kazao da ću činiti šta mi god Gospod kaže? ");
INSERT INTO srp1865_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","A Valak reče Valamu: Hodi, odvešću te na drugo mesto; da ako Bogu bude volja da mi ga odande prokuneš. ");
INSERT INTO srp1865_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","I odvede Valak Valama navrh Fegora, koji gleda u pustinju. ");
INSERT INTO srp1865_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","I reče Valam Valaku: Načini mi ovde sedam oltara, i pripravi mi ovde sedam telaca i sedam ovnova. ");
INSERT INTO srp1865_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","I učini Valak kako reče Valam i prinese žrtvu po tele i ovna na svakom oltaru. ");
INSERT INTO srp1865_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","I videvši Valam da je Božja volja da blagosilja Izrailja, ne hte više ni ići kao pre po vračanje, nego se okrete licem k pustinji, ");
INSERT INTO srp1865_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","i podigavši oči svoje ugleda Izrailja gde stoji po plemenima svojim; i duh Božji dođe na nj. ");
INSERT INTO srp1865_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","I otvori priču svoju, i reče: Kaže Valam, sin Veorov; kaže čovek kome su otvorene oči. ");
INSERT INTO srp1865_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Kaže onaj koji čuje reči Božje, koji vidi utvaru Svemogućeg, koji kad padne otvorene su mu oči: ");
INSERT INTO srp1865_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Kako su lepi šatori tvoji, Jakove, i kolibe tvoje, Izrailju! ");
INSERT INTO srp1865_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Pružili su se kao potoci, kao vrtovi kraj reke, kao mirisava drveta koja je posadio Gospod, kao kedri na vodi. ");
INSERT INTO srp1865_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Poteći će voda iz vedra njegovog, i seme će njegovo biti među velikim vodama, i car će se njegov podignuti svrh Agaga, i carstvo će se njegovo uzvisiti. ");
INSERT INTO srp1865_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Bog ga je izveo iz Misira, i On mu je kao snaga jednorogova; poješće narode koji su mu neprijatelji, i kosti će njegove potrti, i strelama svojim postreljati ih. ");
INSERT INTO srp1865_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Spustio se, leži kao lavić i kao ljuti lav; ko će ga probuditi? Ko tebe blagosilja, biće blagosloven; a ko tebe kune, biće proklet. ");
INSERT INTO srp1865_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tada se razgnevi Valak na Valama, i pljesnu se rukama, i reče Valak Valamu: Dozvah te da prokuneš neprijatelje moje, a ti si ih blagoslovio eto već tri puta. ");
INSERT INTO srp1865_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Odlazi u svoje mesto; rekoh da ću te darivati, a eto Gospod ne da ti dara, ");
INSERT INTO srp1865_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","a Valam reče Valaku: Nisam li i poslanicima tvojim koje si poslao k meni rekao govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Da mi da Valak kuću svoju punu srebra i zlata, ne bih mogao prestupiti reči Gospodnje da učinim šta dobro ili zlo od sebe; šta kaže Gospod ono ću kazati. ");
INSERT INTO srp1865_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ja sada evo idem k narodu svom, ali da ti kažem šta će taj narod učiniti narodu tvom najposle. ");
INSERT INTO srp1865_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Potom otvori priču svoju, i reče: Kaže Valam sin Veorov, kaže čovek kome su otvorene oči, ");
INSERT INTO srp1865_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Kaže koji čuje reči Božje, i zna znanje o Višnjem, i koji vidi utvaru Svemogućeg i kad padne otvorene su mu oči. ");
INSERT INTO srp1865_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Vidim Ga, ali ne sad; gledam Ga, ali ne izbliza; izaći će zvezda iz Jakova i ustaće palica iz Izrailja, koja će razbiti knezove moavske i razoriti sve sinove Sitove. ");
INSERT INTO srp1865_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","I Edoma će osvojiti i Sira će osvojiti neprijatelji njegovi; jer će Izrailj raditi junački. ");
INSERT INTO srp1865_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","I vladaće koji je od Jakova, i zatrće ostatak od grada. ");
INSERT INTO srp1865_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","A ugleda Amalika, otvori priču svoju, i reče: Amalik je početak narodima, ali će najposle propasti. ");
INSERT INTO srp1865_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","A ugledavši Keneja, otvori priču svoju, i reče: Tvrd ti je stan, i na steni si savio gnezdo svoje; ");
INSERT INTO srp1865_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ali će biti izagnan Kenej; Asur će ga zarobiti. ");
INSERT INTO srp1865_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","I opet otvori priču svoju, i reče: Jaoh! Ko će biti živ kad to učini Bog! ");
INSERT INTO srp1865_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","I lađe iz zemlje Kitimske doploviće i dosadiće Asircima i dosadiće Jevrejima; ali će i sami propasti. ");
INSERT INTO srp1865_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Potom ustavši Valam otide, i vrati se u svoje mesto; i Valak otide svojim putem. ");
INSERT INTO srp1865_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","I življaše Izrailj u Sitimu, i narod stade činiti preljubu sa kćerima moavskim. ");
INSERT INTO srp1865_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","One pozivahu narod na žrtve svojih bogova, i narod jeđaše, i klanjaše se bogovima njihovim. ");
INSERT INTO srp1865_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","I Izrailj prionu uz Velfegora; i razgnevi se Gospod na Izrailja. ");
INSERT INTO srp1865_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","I reče Gospod Mojsiju: Uzmi sve knezove narodne, i obesi ih Gospodu prema suncu, da se odvrati gnev Gospodnji od Izrailja. ");
INSERT INTO srp1865_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","I reče Mojsije sudijama Izrailjevim: Pobijte svaki svoje koji su prionuli uz Velfegora. ");
INSERT INTO srp1865_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","I gle, jedan između sinova Izrailjevih dođe i dovede k braći svojoj jednu Madijanku na oči Mojsiju i na oči svemu zboru sinova Izrailjevih; a oni zaplakaše na vratima šatora od sastanka. ");
INSERT INTO srp1865_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","A kad to vide Fines, sin Eleazara sina Arona sveštenika, usta isred zbora i uze koplje u ruku; ");
INSERT INTO srp1865_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","i uđe za čovekom Izrailjcem u šator, i probode ih oboje, čoveka Izrailjca i onu ženu, kroz trbuh, i presta pogibija među sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","I izgibe ih od te pogibije dvadeset i četiri hiljade. ");
INSERT INTO srp1865_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Tada reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Fines, sin Eleazara sina Arona sveštenika odvrati gnev moj od sinova Izrailjevih otvorivši revnost za me među njima, da ne bih istrebio sinove Izrailjeve u revnosti svojoj. ");
INSERT INTO srp1865_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Zato mu kaži: Evo dajem mu svoj zavet mirni. ");
INSERT INTO srp1865_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","I imaće on i seme njegovo nakon njega zavet sveštenstva večnog, jer revnova za Boga svog i očisti sinove Izrailjeve. ");
INSERT INTO srp1865_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","A čoveku Izrailjcu ubijenom, koji bi ubijen s Madijankom, beše ime Zamrije, sin Salmanov, knez od doma oca svog od plemena Simeunovog. ");
INSERT INTO srp1865_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","A ubijenoj ženi Madijani beše ime Hazvija, kći Sura kneza narodnog u domu oca svog među Madijanima. ");
INSERT INTO srp1865_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","I reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Zavojštite na Madijane, i bijte ih; ");
INSERT INTO srp1865_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","jer oni zavojštiše na vas prevarama svojim, i pretvoriše vas Velfegorom i Hazvijom kćerju kneza madijanskog, sestrom svojom, koja bi ubijena u dan pogibije koja dođe s Fegora. ");
INSERT INTO srp1865_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","A posle te pogibije reče Gospod Mojsiju i Eleazaru, sinu Aronovom svešteniku govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Izbrojte sav zbor sinova Izrailjevih od dvadeset godina i više po domovima otaca njihovih, sve koji mogu ići na vojsku u Izrailju. ");
INSERT INTO srp1865_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","I reče im Mojsije i Eleazar sveštenik u polju moavskom na Jordanu prema Jerihonu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Da se izbroje od dvadeset godina i više, kako zapovedi Gospod Mojsiju i sinovima Izrailjevim, koji izađoše iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruvim beše prvenac Izrailjev; a sinovi Ruvimovi: od Enoha porodica Enohova; od Faluja porodica Falujeva; ");
INSERT INTO srp1865_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","od Asrona porodica Asronova, od Harmije porodica Harmijina. ");
INSERT INTO srp1865_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","To su porodice Ruvimove; a izbrojanih beše među njima četrdeset i tri hiljade i sedam stotina i trideset. ");
INSERT INTO srp1865_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Sin Falujev beše Elijav. ");
INSERT INTO srp1865_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","A sinovi Elijavovi: Namuilo i Datan i Aviron. Ovaj Datan i ovaj Aviron koji behu od onih što se sazivahu na zbor, ustaše na Mojsija i Arona u buni Korejevoj, kad beše buna na Gospoda; ");
INSERT INTO srp1865_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","i zemlja otvorivši usta svoja proždre njih i Koreja, i izgibe ta gomila, i spali ih oganj dvesta i pedeset ljudi, koji postaše ugled. ");
INSERT INTO srp1865_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","A sinovi Korejevi ne pogiboše. ");
INSERT INTO srp1865_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Sinovi Simeunovi po porodicama svojim: od Namuila porodica Namuilova; od Jamina porodica Jaminova; od Jahina porodica Jahinova; ");
INSERT INTO srp1865_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","od Zare porodica Zarina, od Saula porodica Saulova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","To su porodice Simeunove; od njih beše dvadeset i dve hiljade i dve stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","A sinovi Gadovi po porodicama svojim: od Sifona porodica Sifonova; od Agija porodica Agijeva; od Sunija i porodica Sunijeva; ");
INSERT INTO srp1865_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","od Azena porodica Azenova; od Irija porodica Irijeva; ");
INSERT INTO srp1865_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","od Aroda porodica Arodova; od Arilija porodica Arilijeva. ");
INSERT INTO srp1865_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","To su porodice sinova Gadovih, a među njima beše izbrojanih četrdeset hiljada i pet stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Sinovi Judini: Ir i Avnan; ali umreše Ir i Avnan u zemlji hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Behu, pak, sinovi Judini po porodicama svojim: od Siloma porodica Silomova; od Faresa porodica Faresova; od Zare porodica Zarina. ");
INSERT INTO srp1865_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","A sinovi Faresovi behu: od Asrona porodica Asronova; od Jamuila porodica Jamuilova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","To su porodice Judine, a među njima beše izbrojanih sedamdeset i šest hiljada i pet stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","A sinovi Isaharovi po porodicama svojim: od Tole porodica Tolina; od Fuve porodica Fuvina; ");
INSERT INTO srp1865_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","od Jasuva porodica Jasuvova; od Amrama porodica Amramova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","To su porodice Isaharove; a među njima beše izbrojanih šezdeset i četiri hiljade i tri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sinovi Zavulonovi po porodicama svojim: od Sareda porodica Saredova, od Alona porodica Alonova, od Alila porodica Alilova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","To su porodice Zavulonove, a među njima beše izbrojanih šezdeset hiljada i pet stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Sinovi Josifovi po porodicama svojim: Manasija i Jefrem; ");
INSERT INTO srp1865_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","sinovi Manasijini: od Mahira porodica Mahirova, a Mahir rodi Galada, od kog je porodica Galadova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ovo su sinovi Galadovi; od Ahijezera porodica Ahijezerova; od Heleka porodica Helekova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Od Esrila porodica Esrilova, od Sihema porodica Sihemova; ");
INSERT INTO srp1865_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","od Simaera porodica Simaerova; od Ofera porodica Oferova; ");
INSERT INTO srp1865_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","a Salpad sin Oferov nemaše sinove nego kćeri, kojima su imena Mala i Nuja i Egla i Melha i Tersa. ");
INSERT INTO srp1865_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","To su porodice Manasijine, a od njih beše izbrojanih pedeset i dve hiljade i sedam stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Sinovi, pak, Jefremovi po porodicama svojim: od Sutala porodica Sutalova; od Vehera porodica Veherova; od Tahana porodica Tahanova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","A ovo su sinovi Sutalovi: od Erana porodica Eranova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","To su porodice sinova Jefremovih; a među njima beše izbrojanih trideset i dve hiljade i pet stotina. To su sinovi Josifovi po porodicama svojim. ");
INSERT INTO srp1865_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","A sinovi Venijaminovi po porodicama svojim: od Vele porodica Velina; od Asvila porodica Asvilova; od Ahirama porodica Ahiramova; ");
INSERT INTO srp1865_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","od Sufama porodica Sufamova; od Ufama porodica Ufamova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","A Velini sinovi behu: Ader i Naman; od Adera porodica Aderova; od Namana porodica Namanova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","To su sinovi Venijaminovi po porodicama svojim, a među njima beše izbrojanih četrdeset i pet hiljada i šest stotina. ");
INSERT INTO srp1865_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","A ovo su sinovi Danovi po porodicama svojim: od Sameja porodica Samejeva; to je rod Danov po porodicama svojim. ");
INSERT INTO srp1865_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","U svim porodicama Samejevim beše izbrojanih šezdeset i četiri hiljade i četiri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Sinovi Asirovi po porodicama svojim: od Jamina porodica Jaminova; od Jesuja porodica Jesujeva: od Verija porodica Verijina. ");
INSERT INTO srp1865_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Sinovi Verijini: od Hovera porodica Hoverova; od Melhila porodica Melhilova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","A kćeri Asirovoj beše ime Sara. ");
INSERT INTO srp1865_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","To su porodice sinova Asirovih; a među njima beše izbrojanih pedeset i tri hiljade i četiri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Sinovi Neftalimovi po porodicama svojim: od Asila porodica Asilova; od Gunija porodica Gunijeva. ");
INSERT INTO srp1865_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Od Jesera porodica Jeserova; od Selima porodica Selimova. ");
INSERT INTO srp1865_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","To je rod Neftalimov po porodicama svojim, a među njima beše izbrojanih četrdeset i pet hiljada i četiri stotine. ");
INSERT INTO srp1865_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","To su izbrojani među sinovima Izrailjevim, šest stotina i jedna hiljada i sedam stotina i trideset. ");
INSERT INTO srp1865_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","A Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Tim neka se podeli zemlja u nasledstvo prema broju imena; ");
INSERT INTO srp1865_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","kojih ima više, podaj im veće nasledstvo, a kojih ima manje, njima manje; svi prema broju izbrojanih svojih neka imaju nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ali žrebom neka se podeli zemlja: po imenima plemena otaca svojih neka dobiju nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ždrebom neka se podeli svakome plemenu, bilo veliko ili malo. ");
INSERT INTO srp1865_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","A ovo su izbrojani između Levita po porodicama svojim: od Girsona porodica Girsonova; od Kata porodica Katova; od Merarija porodica Merarijeva. ");
INSERT INTO srp1865_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ovo su porodice Levijeve: porodica Lovenijeva, porodica Hevronova, porodica Melijeva, porodica Musijeva, porodica Korejeva. A Kat je rodeo Amrama. ");
INSERT INTO srp1865_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","A ime je ženi Amramovoj Johaveda, kći Levijeva, koja mu se rodila u Misiru; a ona rodi Amramu Arona i Mojsija, i Mariju sestru njihovu. ");
INSERT INTO srp1865_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","A Aronu se rodi Nadav i Avijud i Eleazar i Itamar. ");
INSERT INTO srp1865_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ali Nadav i Avijud pogiboše kad prinesoše tuđ oganj pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","I beše ih izbrojanih dvadeset i tri hiljade, svega muškinja od jednog meseca i više; i ne biše brojani među sinove Izrailjeve, jer im nije dano nasledstvo među sinovima Izrailjevim ");
INSERT INTO srp1865_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","To su izbrojani, kad Mojsije i Eleazar sveštenik izbrojaše sinove Izrailjeve u polju moavskom na Jordanu prema Jerihonu. ");
INSERT INTO srp1865_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","A među njima ne beše nijedan od onih koje izbrojaše Mojsije i Aron, sveštenik, kad brojaše sinove Izrailjeve u pustinji sinajskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Jer Gospod beše rekao za njih: Pomreće u pustinji. I ne osta ih ni jedan osim Haleva, sina Jefonijinog i Isusa sina Navinog. ");
INSERT INTO srp1865_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Tada dođoše kćeri Salpada, sina Ofera sina Galada sina Mahira sina Manasijinog, od plemena Manasije sina Josifovog, a imena im behu Mala, Nuja, Egla, Melha i Tersa. ");
INSERT INTO srp1865_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","I stadoše pred Mojsija i pred Eleazara sveštenika i ped knezove i sav zbor na vratima šatora od sastanka, i rekoše: ");
INSERT INTO srp1865_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Otac naš umre u pustinji, ali ne beše u društvu s onima koji se pobuniše na Gospoda u buni Korejevoj, nego umre od greha svog, a ne ostavi sinove. ");
INSERT INTO srp1865_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Zašto da se istrebi ime oca našeg iz porodice njegove zato što nije imao sina? Daj nam nasledstvo među braćom oca našeg. ");
INSERT INTO srp1865_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","I iznese Mojsije stvar njihovu pred Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","A Gospod reče Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Pravo govore, kćeri Salpadove; podaj im pravo da imaju nasledstvo među braćom oca svog, i prinesi nasledstvo oca njihovog na njih. ");
INSERT INTO srp1865_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","A sinovima Izrailjevim kaži i reci: Kad ko umre, a nema sina, onda prenesite nasledstvo njegovo na kćer njegovu; ");
INSERT INTO srp1865_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ako li ni kćeri nema, onda podajte nasledstvo njegovo braći njegovoj; ");
INSERT INTO srp1865_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ako li ni braće nema, onda podajte nasledstvo njegovo braći oca njegovog; ");
INSERT INTO srp1865_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ako li nema ni braću očevu, onda podajte nasledstvo njegovo onome ko mu je najbliži u rodu njegovom, i neka je njegovo. I to neka bude sinovima Izrailjevim zakon za suđenje, kako zapovedi Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Još reče Gospod Mojsiju: Iziđi na goru ovu avarimsku, i vidi zemlju koju sam dao sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","I kad je vidiš, pribraćeš se k rodu svom i ti, kao što se pribrao Aron, brat tvoj. ");
INSERT INTO srp1865_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Jer ne poslušaste reči moje u pustinji Sinu u svađi narodnoj, kad je trebalo da me proslavite na vodi pred očima njihovim. To je voda od svađe u Kadisu u pustinji Sinu. ");
INSERT INTO srp1865_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","I reče Mojsije Gospodu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Gospode Bože duhovima i svakom telu, postavi čoveka nad ovim zborom, ");
INSERT INTO srp1865_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","koji će izlaziti pred njima i koji će dolaziti pred njima, koji će ih izvoditi i opet dovoditi, da ne bi bio zbor Gospodnji kao ovce koje nemaju pastira. ");
INSERT INTO srp1865_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","A Gospod reče Mojsiju: Uzmi k sebi Isusa sina Navinog, čoveka u kome je duh moj, i metni ruku svoju na nj, ");
INSERT INTO srp1865_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","i izvedi ga pred Eleazara sveštenika i pred sav zbor, i podaj mu zapovesti pred njima. ");
INSERT INTO srp1865_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","I podaj mu od slave svoje, da ga sluša sav zbor sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","I neka staje pred Eleazara sveštenika da ga pita za sud Urim pred Gospodom; po zapovesti Njegovoj neka polaze i po zapovesti Njegovoj neka dolaze on i svi sinovi Izrailjevi s njim i sav zbor. ");
INSERT INTO srp1865_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","I učini Mojsije kako mu zapovedi Gospod; i uzevši Isusa postavi ga pred Eleazara sveštenika i pred sav zbor. ");
INSERT INTO srp1865_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","I metnu ruke svoje na nj, i dade mu zapovesti, kako beše zapovedio Gospod preko Mojsija. ");
INSERT INTO srp1865_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Zapovedi sinovima Izrailjevim, i reci im: Prinose moje, hleb moj, žrtve što mi se sažižu za ugodni miris, pazite da mi prinosite na vreme. ");
INSERT INTO srp1865_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Reci im dakle: Ovo je žrtva ognjena što ćete prinositi Gospodu: dva jagnjeta od godine zdrava, svaki dan na žrtvu paljenicu bez prestanka. ");
INSERT INTO srp1865_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Jedno jagnje prinesi ujutru, a drugo jagnje prinesi uveče. ");
INSERT INTO srp1865_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","I desetinu efe belog brašna za dar smešanog s četvrtinom ina čistog ulja. ");
INSERT INTO srp1865_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","To je žrtva paljenica svagdašnja, koja bi prinesena na gori sinajskoj za miris ugodni, žrtva ognjena Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","I naliv njen da bude četvrt ina na svako jagnje; u svetinji prinosi naliv dobrog pića Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","A drugo jagnje prinesi uveče; dar kao ujutru i naliv njegov prinesi za žrtvu ognjenu, za ugodni miris Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","A u subotu dva jagnjeta od godine zdrava, i dve desetine belog brašna smešanog s uljem za dar s nalivom njegovim. ");
INSERT INTO srp1865_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","To je subotna žrtva paljenica svake subote, osim svagdašnje žrtve paljenice i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","I u početak meseca svojih prinosite Gospodu žrtvu paljenicu, po dva teleta i jednog ovna i sedam jaganjaca od godine zdravih; ");
INSERT INTO srp1865_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","i tri desetine belog brašna pomešanog s uljem za dar na svako tele, i dve desetine belog brašna pomešanog s uljem za dar na ovna; ");
INSERT INTO srp1865_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","i po jednu desetinu belog brašna pomešanog s uljem za dar na svako jagnje; to je žrtva paljenica na ugodni miris, žrtva ognjena Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","A naliv njihov da bude vina po ina na tele, trećina ina na ovna, i četvrt ina na jagnje. To je žrtva paljenica u početak meseca, svakog meseca u godini. ");
INSERT INTO srp1865_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","I jarca jednog za greh, osim svagdašnje žrtve paljenice, prinosite Gospodu s nalivom njegovim. ");
INSERT INTO srp1865_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","A prvog meseca četrnaesti dan da je pasha Gospodu; ");
INSERT INTO srp1865_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","a petnaesti dan tog meseca praznik: sedam dana jedite presne hlebove. ");
INSERT INTO srp1865_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Prvi dan neka je sabor sveti; nikakav posao ropski ne radite. ");
INSERT INTO srp1865_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Nego prinesite Gospodu žrtvu paljenicu, dva teleta i jednog ovna i sedam jaganjaca od godine, sve da vam je zdravo; ");
INSERT INTO srp1865_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","a dar uz njih belog brašna pomešanog s uljem tri desetine uza svako tele i dve desetine uz ovna prinesite. ");
INSERT INTO srp1865_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Po jednu desetinu prinesite uza svako jagnje od onih sedam jaganjaca; ");
INSERT INTO srp1865_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","i jednog jarca za greh, radi očišćenja vašeg. ");
INSERT INTO srp1865_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","To prinesite osim jutarnje žrtve paljenice, koja je žrtva svagdašnja. ");
INSERT INTO srp1865_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Tako prinosite svaki dan za onih sedam dana, da bude jelo, žrtva ognjena na ugodni miris Gospodu, osim svagdašnje žrtve paljenice i njen naliv prinosite. ");
INSERT INTO srp1865_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","I sedmi dan da imate sveti sabor; posao ropski nijedan ne radite. ");
INSERT INTO srp1865_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","I na dan prvina, kad prinosite nov dar Gospodu posle svojih nedelja, da imate sabor sveti, nijedan posao ropski ne radite; ");
INSERT INTO srp1865_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","nego prinesite žrtvu paljenicu za ugodni miris Gospodu, dva teleta, jednog ovna sedam jaganjaca od godine; ");
INSERT INTO srp1865_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","i dar uz njih: belog brašna pomešanog s uljem po tri desetine uz tele, dve desetine uz ovna, ");
INSERT INTO srp1865_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","po jednu desetinu uza svako jagnje od onih sedam jaganjaca; ");
INSERT INTO srp1865_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","jednog jarca, radi očišćenja vašeg. ");
INSERT INTO srp1865_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Prinesite to, osim svagdašnje žrtve paljenice i dara njenog; a sve neka vam je zdravo s nalivom svojim. ");
INSERT INTO srp1865_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","A sedmog meseca prvi dan da imate sveti sabor; posao ropski nijedan ne radite; to da vam je trubni dan. ");
INSERT INTO srp1865_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","I prinesite žrtvu paljenicu za miris ugodni Gospodu, jedno tele, jednog ovna, sedam jaganjaca od godine zdravih; ");
INSERT INTO srp1865_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","a dar uz njih belog brašna smešanog s uljem tri desetine uz tele i dve desetine uz ovna, ");
INSERT INTO srp1865_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","i po jednu desetinu uz svako jagnje od sedam jaganjaca; ");
INSERT INTO srp1865_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","i jednog jarca za greh, radi očišćenja vašeg; ");
INSERT INTO srp1865_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","osim žrtve paljenice u početku meseca i dara njenog, i osim svagdašnje žrtve paljenice i dara njenog i naliva njihovih po uredbi njihovoj, za miris ugodni, za žrtvu ognjenu Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","I deseti dan tog meseca sedmog da imate sveti sabor; i mučite duše svoje; ne radite nikakav posao; ");
INSERT INTO srp1865_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","nego prinesite Gospodu za miris ugodni žrtvu paljenicu, jedno tele, jednog ovna, sedam jaganjaca od godine, a neka vam je zdravo; ");
INSERT INTO srp1865_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","i dar uz njih belog brašna pomešanog s uljem tri desetine uz tele, dve desetine uz ovna, ");
INSERT INTO srp1865_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","po jednu desetinu uza svako jagnje od onih sedam jaganjaca; ");
INSERT INTO srp1865_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","jarca jednog za greh, osim žrtve za greh radi očišćenja, i osim svagdašnje žrtve paljenice i dara njenog i naliva njihovih. ");
INSERT INTO srp1865_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","I petnaesti dan tog meseca sedmog da imate sveti sabor; nijedan posao ropski ne radite; nego praznujte praznik Gospodu sedam dana. ");
INSERT INTO srp1865_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","I prinesite žrtvu paljenicu, ognjenu žrtvu za ugodni miris Gospodu, trinaest telaca, dva ovna, četrnaest jaganjaca od godine, a neka su zdravi; ");
INSERT INTO srp1865_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","i dar uz njih brašna belog smešana s uljem po tri desetine uza svako tele od trinaest telaca, po dve desetine uza svakog ovna od ona dva ovna, ");
INSERT INTO srp1865_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","i po jednu desetinu uza svako jagnje od onih četrnaest jaganjaca; ");
INSERT INTO srp1865_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","i jednog jarca za greh, osim svagdašnje žrtve paljenice i dara njenog i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","A drugi deo dvanaest telaca, dva ovna, četrnaest jaganjaca od godine zdravih, ");
INSERT INTO srp1865_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","i dar njihov i naliv njihov, uz teoce, uz ovnove i uz jaganjce, po broju njihovom, kako je uređeno; ");
INSERT INTO srp1865_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","i jarca jednog za greh, osim svagdašnje žrtve paljenice i dara njenog i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","A treći dan jedanaest telaca, dva ovna i četrnaest jaganjaca od godine zdravih; ");
INSERT INTO srp1865_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","i darove njihove i nalive njihove, uz teoce, uz ovnove i uz jaganjce, po broju njihovom, kako je uređeno; ");
INSERT INTO srp1865_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","i jednog jarca za greh, osim svagdašnje žrtve paljenice i dara njenog i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","A četvrti dan deset telaca, dva ovna, četrnaest jaganjaca od godine zdravih; ");
INSERT INTO srp1865_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","i dar njihov i nalive njihove, uz teoce, uz ovnove i uz jaganjce, po broju njihovom, kako je uređeno; ");
INSERT INTO srp1865_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","i jednog jarca za greh, osim svagdašnje žrtve paljenice i dara njenog i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","A peti dan devet telaca, dva ovna, četrnaest jaganjaca od godine zdravih; ");
INSERT INTO srp1865_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","i dar njihov i nalive njihove, uz teoce, uz ovnove i uz jaganjce, po broju njihovom, kako je uređeno; ");
INSERT INTO srp1865_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","i jednog jarca za greh, osim svagdašnje žrtve paljenice i dara njenog i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","A šesti dan osam telaca, dva ovna, četrnaest jaganjaca od godine zdravih, ");
INSERT INTO srp1865_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","i dar njihov i nalive njihove, uz teoce, uz ovnove i uz jaganjce, po broju njihovom, kako je uređeno; ");
INSERT INTO srp1865_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","i jednog jarca za greh, osim svagdašnje žrtve paljenice i dara njenog i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","A sedmi dan sedam telaca, dva ovna, četrnaest jaganjaca od godine zdravih, ");
INSERT INTO srp1865_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","i dar njihov i nalive njihove, uz teoce, uz ovnove i uz jaganjce, po broju njihovom, kako je uređeno; ");
INSERT INTO srp1865_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","i jarca za greh, osim svagdašnje žrtve paljenice i dara njenog i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","A osmi dan da vam je praznik; nijedan posao ropski ne radite. ");
INSERT INTO srp1865_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Nego prinesite žrtvu paljenicu, žrtvu ognjenu za ugodni miris Gospodu, jedno tele, jednog ovna, sedam jaganjaca od godine zdravih. ");
INSERT INTO srp1865_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","I dar njihov i nalive njihove, uz tele, uz ovna i uz jaganjce, po broju njihovom, kako je uređeno; ");
INSERT INTO srp1865_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","i jednog jarca za greh, osim svagdašnje žrtve paljenice i dara njenog i naliva njenog. ");
INSERT INTO srp1865_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","To prinosite Gospodu na praznike svoje, osim onog što biste po zavetu ili od svoje volje prineli za žrtve paljenice ili darove ili nalive ili žrtve zahvalne. ");
INSERT INTO srp1865_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mojsije je ispričao sinovima Izrailjevim sve što je Gospod zapovedio Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","I kaza Mojsije sinovima Izrailjevim sve što zapovedi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","I reče Mojsije knezovima od plemena sinova Izrailjevih govoreći: Ovo je zapovedio Gospod. ");
INSERT INTO srp1865_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Kad koji čovek učini zavet Gospodu, ili se zakune vezavši se dušom svojom, neka ne pogazi reči svoje, nego neka učini sve što izađe iz usta njegovih. ");
INSERT INTO srp1865_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","A kad žena učini zavet Gospodu ili se veže u mladosti svojoj, dokle je u kući oca svog, ");
INSERT INTO srp1865_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","i čuje otac njen za zavet njen ili kako se vezala dušom svojom, pa joj otac ne reče ništa, onda da su tvrdi svi zaveti njeni, i sve čim je vezala dušu svoju da je tvrdo. ");
INSERT INTO srp1865_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ako li otac njen poreče to onaj dan kad čuje, zaveti njeni i čim je god vezala dušu svoju, ništa da nije tvrdo; i Gospod će joj oprostiti, jer otac njen poreče. ");
INSERT INTO srp1865_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Ako li se uda pa ima na sebi zavet ili izreče šta na usta svoja čim bi se vezala, ");
INSERT INTO srp1865_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","a muž njen čuvši ne reče joj ništa onaj dan kad čuje, onda da su tvrdi zaveti njeni, i tvrdo da je sve čim je vezala dušu svoju. ");
INSERT INTO srp1865_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Ako li muž njen kad čuje onaj dan poreče, ukida se zavet koji je bio na njoj ili što je izrekla na usta svoja te se vezala; i Gospod će joj oprostiti. ");
INSERT INTO srp1865_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","A zavet koji učini udovica ili puštenica, i sve čim veže dušu svoju, da joj je tvrdo. ");
INSERT INTO srp1865_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Ali ako bude u kući muža svog učinila zavet i za šta vezala dušu svoju zakletvom, ");
INSERT INTO srp1865_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","i muž njen čuvši oćuti i ne poreče, tada da su tvrdi svi zaveti njeni, i da je tvrdo sve za šta je vezala dušu svoju. ");
INSERT INTO srp1865_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ako li to poreče muž njen onaj dan kad čuje, svaki zavet koji bi izašao iz usta njenih i sve čim bi vezala dušu svoju da nije tvrdo; muž je njen porekao, i Gospod će joj oprostiti. ");
INSERT INTO srp1865_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Svaki zavet i sve za šta bi se vezala zakletvom da muči dušu svoju, muž njen potvrđuje i ukida. ");
INSERT INTO srp1865_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ako bi muž njen od dana do dana ćutao, onda potvrđuje sve zavete njene i sve za šta bi se vezala; potvrđuje, jer joj ne poreče u onaj dan kad ču. ");
INSERT INTO srp1865_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ako li poreče pošto čuje, sam će nositi greh njen. ");
INSERT INTO srp1865_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Ovo su naredbe, koje zapovedi Gospod Mojsiju za muža i ženu, za oca i kćer u mladosti njenoj, dokle je u kući oca svog. ");
INSERT INTO srp1865_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Osveti sinove Izrailjeve na Madijanima, pa ćeš se onda pribrati k rodu svom. ");
INSERT INTO srp1865_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","I Mojsije reče narodu govoreći: Opremite između sebe ljude na vojsku da idu na Madijane da učine osvetu Gospodnju na Madijanima, ");
INSERT INTO srp1865_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","po hiljadu od plemena, od svakog plemena Izrailjevog opremite na vojsku. ");
INSERT INTO srp1865_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","I dadoše od hiljada Izrailjevih po hiljadu od svakog plemena, dvanaest hiljada opremiše na vojsku. ");
INSERT INTO srp1865_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","I posla Mojsije po hiljadu od svakog plemena na vojsku, i s njima Finesa, sina Eleazara sveštenika, i u njega behu sudovi sveti i trube. ");
INSERT INTO srp1865_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","I zavojštiše na Madijane, kako zapovedi Gospod Mojsiju, i pobiše sve muškinje. ");
INSERT INTO srp1865_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Pobiše i careve madijanske, s drugima koje im pobiše, Evina i Rokoma i Sura i Ura i Rovoka, pet careva madijanskih, i Valama sina Veorovog ubiše mačem. ");
INSERT INTO srp1865_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","I zarobiše sinovi Izrailjevi žene Madijanke i decu njihovu, i zapleniše svu stoku njihovu, krupnu i sitnu, i sve blago njihovo. ");
INSERT INTO srp1865_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","A mesta njihova u kojima življahu i gradove njihove sve popališe ognjem. ");
INSERT INTO srp1865_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","I sve roblje i sav plen, ljude i stoku, uzeše; ");
INSERT INTO srp1865_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","i povedoše k Mojsiju i Eleazaru svešteniku i ka zboru sinova Izrailjevih, i roblje i ostali plen i dobit u logor na polju moavskom, koje je na Jordanu prema Jerihonu. ");
INSERT INTO srp1865_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","A Mojsije i Eleazar sveštenik i svi knezovi od zbora iziđoše im na susret iz logora. ");
INSERT INTO srp1865_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","I Mojsije se razgnevi na vojvode, na hiljadnike i stotinare, koji se vraćahu s vojske; ");
INSERT INTO srp1865_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","i reče im Mojsije: A što ostaviste u životu sve žene? ");
INSERT INTO srp1865_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ta one po reči Valamovoj navratiše sinove Izrailjeve da zgreše Gospodu s Fegora, te dođe ona pogibija na narod Gospodnji. ");
INSERT INTO srp1865_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Zato sada pobijte svu decu mušku, i sve žene pobijte, koje su poznale čoveka. ");
INSERT INTO srp1865_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","A devojke, koje ne poznaše čoveka, ostavite u životu. ");
INSERT INTO srp1865_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","A vi ostanite izvan logora sedam dana; svaki koji je ubio koga i koji se dotakao ubijenoga očistite se treći dan i sedmi dan, sebe i roblje svoje. ");
INSERT INTO srp1865_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","I sve haljine i sve stvari kožne i sve što je od kostreti i sve sudove drvene očistite. ");
INSERT INTO srp1865_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","I reče Eleazar sveštenik vojnicima, koji behu išli na vojsku: Ovo je naredba i zakon što je Gospod zapovedio Mojsiju: ");
INSERT INTO srp1865_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Zlato, srebro, bronzu, gvožđe, kositer i olovo, ");
INSERT INTO srp1865_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","šta god podnosi vatru, propustite kroz vatru, i očistiće se, ali pošto se očisti vodom očišćenja; a šta god ne podnosi vatru, propustite kroz vodu. ");
INSERT INTO srp1865_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","I operite haljine svoje sedmi dan, i bićete čisti; i onda ćete ući u logor. ");
INSERT INTO srp1865_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Izbroj sve što je zaplenjeno, ljude i stoku, ti i Eleazar sveštenik i poglavari od plemena narodnih. ");
INSERT INTO srp1865_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","I razdeli sve zaplenjeno na dvoje: na vojnike koji su išli na vojsku i na sav zbor. ");
INSERT INTO srp1865_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","I uzmi deo za Gospoda od vojnika koji su išli na vojsku, po jednu dušu od pedeset, i od ljudi i od goveda i od magaraca i od ovaca. ");
INSERT INTO srp1865_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Od njihove polovine to uzmite, i podajte Eleazaru svešteniku za prinos Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","I od polovine koja dopade sinovima Izrailjevim uzmi po jedno od pedeset, i od ljudi i od goveda i od magaraca i od ovaca i od svake stoke, i to podaj Levitima koji rade šta treba za šator Gospodnji. ");
INSERT INTO srp1865_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","I učini Mojsije i Eleazar sveštenik kako zapovedi Gospod Mojsiju. ");
INSERT INTO srp1865_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","I beše plena, što osta od plena koji zapleni vojska: šest stotina i sedamdeset i pet hiljada ovaca, ");
INSERT INTO srp1865_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","i sedamdeset i dve hiljade goveda, ");
INSERT INTO srp1865_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","i šezdeset i jedna hiljada magaraca, ");
INSERT INTO srp1865_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","i ženskinja što ne beše poznalo čoveka, svega trideset i dve hiljade duša. ");
INSERT INTO srp1865_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","A u polovini, u delu onih koji behu išli na vojsku, beše na broj tri stotine i trideset i sedam hiljada i pet stotina ovaca, ");
INSERT INTO srp1865_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","a od toga deo Gospodu beše šest stotina i sedamdeset i pet ovaca: ");
INSERT INTO srp1865_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","I trideset i šest hiljada goveda, a od toga deo Gospodu sedamdeset i dva; ");
INSERT INTO srp1865_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","i trideset hiljada i pet stotina magaraca, a od toga deo Gospodu šezdeset i jedan; ");
INSERT INTO srp1865_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","i šesnaest hiljada duša ljudskih, a od toga deo Gospodu trideset i dve duše. ");
INSERT INTO srp1865_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","I dade Mojsije Eleazaru svešteniku deo za prinos Gospodu, kao što mu zapovedi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","A od druge polovine, koja dopade sinovima Izrailjevim, koju uze Mojsije od ljudi koji behu išli na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","a i u toj polovini, koja dopade zboru, beše tri stotine i trideset i sedam hiljada i pet stotina ovaca, ");
INSERT INTO srp1865_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","trideset i šest hiljada goveda, ");
INSERT INTO srp1865_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trideset hiljada i pet stotina magaraca, ");
INSERT INTO srp1865_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","i šesnaest hiljada duša ljudskih. ");
INSERT INTO srp1865_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Od te polovine, koja dopade sinovima Izrailjevim, uze Mojsije po jedno od pedeset, i od ljudi i od stoke, i dade Levitima koji rade šta treba za šator Gospodnji, kao što mu Gospod zapovedi. ");
INSERT INTO srp1865_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","I pristupiše k Mojsiju vojvode, hiljadnici i stotinari, ");
INSERT INTO srp1865_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","i rekoše mu: Sluge tvoje prebrojaše vojnike koji behu pod našom rukom, i nijednog nije manje. ");
INSERT INTO srp1865_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Zato prinosimo Gospodu prinos, svaki što je ko zadobio, zlatnih zaklada, kopača, narukvica, prstena, obodaca i lančića, da bi se očistile duše naše pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","I uze Mojsije i Eleazar sveštenik od njih zlato, svakojake zaklade. ");
INSERT INTO srp1865_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","A beše svega zlata prinesenog, što prinesoše Mojsiju hiljadnici i stotinari, šesnaest hiljada i sedam stotina i pedeset sikala. ");
INSERT INTO srp1865_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","A vojnici zadržaše sebi šta koji beše zaplenio. ");
INSERT INTO srp1865_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","I uzevši Mojsije i Eleazar zlato od hiljadnika i stotinara, unesoše ga u šator od sastanka za spomen sinovima Izrailjevim pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","A sinovi Ruvimovi i sinovi Gadovi imahu vrlo mnogo stoke, i videše zemlju jazirsku i zemlju galadsku da je dobra za stoku. ");
INSERT INTO srp1865_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","I došavši sinovi Gadovi i sinovi Ruvimovi rekoše Mojsiju i Eleazaru svešteniku i knezovima od zbora govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atarot i Devon i Jazir i Namra i Esevon i Elealija i Sevama i Navav i Vean, ");
INSERT INTO srp1865_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ta je zemlja, koju Gospod pokori zboru izrailjskom, dobra za stoku, a sluge tvoje imaju stoke. ");
INSERT INTO srp1865_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ako smo, rekoše, našli milost pred tobom, neka se ta zemlja dade slugama tvojim u nasledstvo, nemoj nas voditi preko Jordana. ");
INSERT INTO srp1865_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","A Mojsije reče sinovima Gadovim i sinovima Ruvimovim: Braća će vaša ići na vojsku, a vi hoćete ovde da ostanete? ");
INSERT INTO srp1865_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Zašto obarate srce sinovima Izrailjevim da ne pređu u zemlju koju im je dao Gospod? ");
INSERT INTO srp1865_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Tako su učinili oci vaši, kad ih poslah iz Kadis-Varnije da uhode zemlju; ");
INSERT INTO srp1865_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","i otidoše do potoka Eshola, i uhodiše zemlju; i oboriše srce sinovima Izrailjevim da ne idu u zemlju koju im dade Gospod; ");
INSERT INTO srp1865_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","i razgnevi se onda Gospod, i zakle se govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Neće ti ljudi koji izađoše iz Misira, od dvadeset godina i više, videti zemlje za koju se zakleh Avramu, Isaku i Jakovu, jer se ne držaše mene sasvim, ");
INSERT INTO srp1865_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","osim Haleva, sina Jefonijinog Kenezeja i Isusa sina Navinog, jer se sasvim držaše Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","I razgnevi se Gospod na Izrailja, i učini te se potucaše po pustinji četrdeset godina, dokle ne pomre sav onaj naraštaj koji činjaše zlo pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","A vi sada izađoste na mesto otaca svojih, rod grešnih ljudi, da umnožavate žestinu gneva Gospodnjeg na Izrailja. ");
INSERT INTO srp1865_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ako se odvratite od njega, On će ga još ostaviti u pustinji, i tako ćete upropastiti sav onaj narod. ");
INSERT INTO srp1865_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","A oni pristupiše opet k njemu, i rekoše mu: Mi smo radi samo torove načiniti ovde za stada svoja i gradove za decu svoju. ");
INSERT INTO srp1865_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","A sami ćemo naoružani junački poći pred sinovima Izrailjevim, dokle ih ne odvedemo na njihovo mesto; a naša deca neka stoje u gradovima tvrdim radi stanovnika te zemlje. ");
INSERT INTO srp1865_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nećemo se vratiti kućama svojim dokle sinovi Izrailjevi ne prime svaki svoje nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Niti ćemo uzeti nasledstvo s njima s one strane Jordana ni dalje, ako nam dopadne nasledstvo s ove strane Jordana prema istoku. ");
INSERT INTO srp1865_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Tada im reče Mojsije; ako ćete učiniti tako i ići pod oružjem pred Gospodom na vojsku, ");
INSERT INTO srp1865_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ako svaki od vas pod oružjem pređe preko Jordana pred Gospodom, dokle ne otera ispred sebe neprijatelja svojih, ");
INSERT INTO srp1865_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","i dokle se ne pokori zemlja pred Gospodom, pa se onda vratite i ne zgrešite Gospodu ni Izrailju, onda će ova zemlja pripasti vama u nasledstvo pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ako li ne učinite tako, gle, zgrešićete Gospodu, i znajte da će vas greh vaš stići. ");
INSERT INTO srp1865_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Gradite sebi gradove za decu svoju i torove za stoku svoju; i šta je izašlo iz usta vaših, učinite. ");
INSERT INTO srp1865_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","I rekoše Mojsiju sinovi Gadovi i sinovi Ruvimovi govoreći: Sluge će tvoje učiniti kako gospodar naš zapoveda. ");
INSERT INTO srp1865_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Deca naša i žene naše, stada naša i sva stoka naša ovde će ostati u gradovima galadskim; ");
INSERT INTO srp1865_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","a sluge će tvoje preći svaki naoružan, da se bije pred Gospodom, kao što govori gospodar naš. ");
INSERT INTO srp1865_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Tada Mojsije zapovedi za njih Eleazaru svešteniku i Isusu sinu Navinom i glavarima od domova otačkih među sinovima Izrailjevim, ");
INSERT INTO srp1865_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","i reče im: Ako pređu sinovi Gadovi i sinovi Ruvimovi s vama preko Jordana, svi oružani, da se biju pred Gospodom, i kad vam bude zemlja pokorena, onda podajte njima zemlju galadsku u nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ako li ne pređu s vama pod oružjem, onda neka im bude nasledstvo među vama u zemlji hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","I odgovoriše sinovi Gadovi i sinovi Ruvimovi govoreći: Kako je Gospod kazao slugama tvojim tako ćemo učiniti. ");
INSERT INTO srp1865_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Preći ćemo pod oružjem pred Gospodom u zemlju hanansku, a naše nasledstvo da bude s ove strane Jordana. ");
INSERT INTO srp1865_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","I dade Mojsije sinovima Gadovim i sinovima Ruvimovim i polovini plemena Manasije sina Josifovog carstvo Siona, cara amorejskog i carstvo Oga, cara vasanskog, zemlju i gradove po međama njenim, gradove one zemlje unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","I sagradiše sinovi Gadovi Devon i Atarot i Aroir. ");
INSERT INTO srp1865_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","I Atrot-Sofan i Jazir i Jogveju, ");
INSERT INTO srp1865_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","i Vet-Nimru i Vet-Aran, gradove tvrde, i torove za stoku. ");
INSERT INTO srp1865_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","A sinovi Ruvimovi sagradiše Esevon i Elealiju i Kirijatajim, ");
INSERT INTO srp1865_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","i Navon i Valmeon predenuvši im imena, i Sivmu; i nadeše druga imena gradovima koje sagradiše. ");
INSERT INTO srp1865_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","A sinovi Mahira, sina Manasijinog otidoše u Galad, i uzeše ga, i izagnaše Amoreje koji behu onde. ");
INSERT INTO srp1865_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","I Mojsije dade Galad Mahiru sinu Manasijinom, koji se onde naseli. ");
INSERT INTO srp1865_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","I Jair, sin Manasijin otide i uze sela njihova i prozva ih sela Jairova. ");
INSERT INTO srp1865_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","I Navav otide i uze Kenat sa selima njegovim, i prozva ga Navav po imenu svom. ");
INSERT INTO srp1865_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ovo su putevi sinova Izrailjevih kad izađoše iz zemlje misirske u četama svojim pod upravom Mojsijevom i Aronovom. ");
INSERT INTO srp1865_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","I Mojsije popisa kako iziđoše i gde stajaše po zapovesti Gospodnjoj; i ovo su putevi njihovi kako putovaše. ");
INSERT INTO srp1865_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Pođoše iz Ramese prvog meseca petnaesti dan, sutradan posle pashe, i iziđoše sinovi Izrailjevi rukom podignutom pred očima svih Misiraca. ");
INSERT INTO srp1865_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","A Misirci pogrebavahu prvence koje pobi Gospod među njima, kad i na bogovima njihovim izvrši Gospod sudove. ");
INSERT INTO srp1865_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","I otišavši sinovi Izrailjevi iz Ramese stadoše u logor u Sohotu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","A iz Sohota otišavši stadoše u logor u Etamu, koji je na kraj pustinje. ");
INSERT INTO srp1865_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","A iz Etame otišavši saviše k Irotu, koji je prema Velsefonu i stadoše u logor pred Magdalom. ");
INSERT INTO srp1865_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","A od Irota otišavši pređoše preko mora u pustinju, i išavši tri dana preko pustinje Etama stadoše u logor u Meri. ");
INSERT INTO srp1865_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","A iz Mere otišavši dođoše u Elim, gde beše dvanaest studenaca i sedamdeset palmovih drveta, i onde stadoše u logor. ");
INSERT INTO srp1865_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","A iz Elima otišavši stadoše u logor kod Crvenog Mora. ");
INSERT INTO srp1865_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","I otišavši od Crvenog Mora stadoše u logor u pustinji Sinu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","A iz pustinje Sina otišavši stadoše u logor u Rafaku. ");
INSERT INTO srp1865_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","A iz Rafaka otišavši stadoše u logor u Elusu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","A iz Elusa otišavši stadoše u logor u Rafidinu, gde nemaše narod vode da pije. ");
INSERT INTO srp1865_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","A iz Rafidina otišavši stadoše u logor u pustinji sinajskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","A iz pustinje sinajske otišavši stadoše u logor u Kivrot-Atavi. ");
INSERT INTO srp1865_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","A iz Kivrot-Atave otišavši stadoše u logor u Asirotu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","A iz Asirota otišavši stadoše u logor u Ratamu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","A iz Ratama otišavši stadoše u logor u Remnon-Faresu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","A iz Remnon-Faresa otišavši stadoše u logor u Lemvonu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","A iz Lemvona otišavši stadoše u logor u Resanu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","A iz Resana otišavši stadoše u logor u Makelatu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","A iz Makelata otišavši stadoše u logor kod gore Safera. ");
INSERT INTO srp1865_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","A od gore Safera otišavši stadoše u logor u Haradu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","A iz Harada otišavši stadoše u logor u Makidotu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","A iz Makidota otišavši stadoše u logor u Katatu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","A iz Katata otišavši stadoše u logor u Taratu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","A iz Tarata otišavši stadoše u logor u Meteku. ");
INSERT INTO srp1865_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","A iz Meteka otišavši stadoše u logor u Aselmonu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","A iz Aselmona otišavši stadoše u logor u Mosirotu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","A iz Mosirota otišavši stadoše u logor u Vanakanu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","A iz Vanakana otišavši stadoše u logor na planini Gadadu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","A sa planine Gadada otišavši stadoše u logor u Etavati. ");
INSERT INTO srp1865_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","A iz Etavate otišavši stadoše u logor i Evronu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","A iz Evrona otišavši stadoše u logor u Gesion-Gaveru. ");
INSERT INTO srp1865_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","A iz Gesion-Gavera otišavši stadoše u logor u pustinji Sinu, a to je Kadis. ");
INSERT INTO srp1865_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","A iz Kadisa otišavši stadoše u logor kod gore Ora ne međi zemlje edomske. ");
INSERT INTO srp1865_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","I iziđe Aron sveštenik na goru Or po zapovesti Gospodnjoj, i umre onde četrdesete godine po izlasku sinova Izrailjevih iz zemlje misirske, prvi dan petog meseca. ");
INSERT INTO srp1865_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","A Aronu beše sto i dvadeset i tri godine kad umre na gori Oru. ");
INSERT INTO srp1865_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Tada ču Hananej, car aradski, koji življaše na jugu u zemlji hananskoj, da idu sinovi Izrailjevi. ");
INSERT INTO srp1865_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Potom otišavši od gore Ora stadoše u logor u Selmonu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","A iz Selmona otišavši stadoše u logor u Finonu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","A iz Finona otišavši stadoše u logor u Ovotu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","A iz Ovota otišavši stadoše u logor na humovima avarimskim na međi moavskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","A od tih humova otišavši stadoše u logor u Devon-Gadu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","A iz Devon-Gada otišavši stadoše u logor u Gelmon-Devlataimu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","A iz Gelmon-Devlataima otišavši stadoše u logor u planinama avarimskim prema Navavu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","A iz planina avarimskih otišavši stadoše u logor u polju moavskom na Jordanu prema Jerihonu. ");
INSERT INTO srp1865_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","I stajahu u logoru kraj Jordana od Esimota do Vel-Satima u polju moavskom. ");
INSERT INTO srp1865_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","I reče Gospod Mojsiju u polju moavskom na Jordanu prema Jerihonu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Kaži sinovima Izrailjevim i reci im: Kad pređete preko Jordana u zemlju hanansku, ");
INSERT INTO srp1865_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","oterajte od sebe sve koji žive u onoj zemlji, i potrite sve slike njihove rezane, i sve slike njihove livene potrite, i sve visine njihove oborite. ");
INSERT INTO srp1865_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","A kad ih isterate iz zemlje, naselite se u njoj; jer sam vama dao onu zemlju da je vaša. ");
INSERT INTO srp1865_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","I razdelite je u nasledstvo žrebom na porodice svoje; kojih ima više, njima veće nasledstvo podajte; a kojih ima manje, njima podajte manje nasledstvo; koje mesto kome žrebom dopadne, ono neka mu bude; na plemena otaca svojih razdelite nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ako li ne oterate od sebe onih koji žive u onoj zemlji, onda će oni koje ostavite biti trnje očima vašim i ostani vašim bokovima, i pakostiće vam u zemlji u kojoj ćete živeti. ");
INSERT INTO srp1865_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","I šta sam mislio učiniti njima, učiniću vama. ");
INSERT INTO srp1865_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Zapovedi sinovima Izrailjevim i reci im: Kad dođete u zemlju hanansku, ta će vam zemlja pripasti u nasledstvo, zemlja hananska s međama svojim. ");
INSERT INTO srp1865_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Južni kraj da vam je od pustinje Sina, uz među edomsku, i da vam je južna međa od brega slanog mora na istok; ");
INSERT INTO srp1865_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","i ta međa neka se savije od juga k Akravimu i ide do Sina, i neka se pruži od juga preko Kadis-Varnije, a otuda neka iziđe na selo Adar i ide do Aselmona; ");
INSERT INTO srp1865_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","potom neka se savije ta međa od Aselmona do potoka misirskog i ide do mora. ");
INSERT INTO srp1865_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","A zapadna međa da vam bude veliko more; to da vam je zapadna međa. ");
INSERT INTO srp1865_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","A severna međa ovo da vam bude: od velikog mora povucite sebi među do gore Ora; ");
INSERT INTO srp1865_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","a od gore Ora povucite sebi među kako se ide u Emat, i ta međa neka ide na Sedad; ");
INSERT INTO srp1865_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","i neka ide ta međa do Zefrona, i kraj neka joj bude kod sela Enana, to da vam bude severna međa. ");
INSERT INTO srp1865_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","A s istoka povucite sebi među od sela Enana do Sefama; ");
INSERT INTO srp1865_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","a od Sefama neka ide ta međa k Rivli, s istoka Ainu, i neka ide dalje ta međa dokle dođe do mora Hinerota k istoku; ");
INSERT INTO srp1865_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","i neka se spusti ta međa ka Jordanu, i neka izađe na slano more. Ta će zemlja biti vaša s međama svojim unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","I kaza Mojsije sinovima Izrailjevim govoreći: To je zemlja koju ćete dobiti u nasledstvo žrebom, za koju je zapovedio Gospod da je dobije devet plemena i po. ");
INSERT INTO srp1865_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Jer pleme sinova Ruvimovih po porodicama otaca svojih, i pleme sinova Gadovih po porodicama otaca svojih, i polovina plemena Manasijinog primiše svoje nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Ova dva plemena i po primiše nasledstvo svoje s ovu stranu Jordana prema Jerihonu s istočne strane. ");
INSERT INTO srp1865_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Opet reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Ovo su imena ljudi koji će vam razdeliti u nasledstvo zemlju: Eleazar sveštenik i Isus sin Navin. ");
INSERT INTO srp1865_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","I po jednog kneza iz svakog plemena uzmite da deli zemlju. ");
INSERT INTO srp1865_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","A ovo su imena tih ljudi: od plemena Judinog Halev sin Jefonijin, ");
INSERT INTO srp1865_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","od plemena sinova Simeunovih Samuilo sin Emijudov, ");
INSERT INTO srp1865_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","od plemena Venijaminovog Eldad sin Haslonov, ");
INSERT INTO srp1865_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","od plemena sinova Danovih knez Vokor sin Jeklinov, ");
INSERT INTO srp1865_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","od sinova Josifovih: od plemena sinova Manasijinih knez Anilo sin Sufidov, ");
INSERT INTO srp1865_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","od plemena sinova Jefremovih, knez Kamuilo sin Saftanov, ");
INSERT INTO srp1865_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","od plemena sinova Zavulonovih knez Elisafan sin Harnahov, ");
INSERT INTO srp1865_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","od plemena sinova Isaharovih knez Faltilo sin Ozainov, ");
INSERT INTO srp1865_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","od plemena sinova Asirovih knez Ahior sin Selemijin, ");
INSERT INTO srp1865_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","i od plemena Neftalimovog knez Fadailo sin Amijudov. ");
INSERT INTO srp1865_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ovima zapovedi Gospod da razdele nasledstvo sinovima Izrailjevim u zemlji hananskoj. ");
INSERT INTO srp1865_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Još reče Gospod Mojsiju u polju moavskom na Jordanu prema Jerihonu govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Zapovedi sinovima Izrailjevim neka dadu od nasledstva svog Levitima gradove, gde će živeti; i podgrađa oko gradova podajte im, ");
INSERT INTO srp1865_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","da u gradovima žive, a u podgrađima njihovim da im stoji stoka i imanje njihovo i sve životinje njihove. ");
INSERT INTO srp1865_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","A podgrađa koja date Levitima neka budu na hiljadu lakata daleko od zidova gradskih unaokolo. ");
INSERT INTO srp1865_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Zato izmerite iza svakog grada na istok dve hiljade lakata, i na jug dve hiljade lakata, i na zapad dve hiljade lakata, i na sever dve hiljade lakata, tako da grad bude u sredi. Tolika neka budu podgrađa njihova. ");
INSERT INTO srp1865_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","A od gradova koje date Levitima odvojte šest gradova za utočište, da onamo uteče ko bi koga ubio; i osim njih podajte im četrdeset i dva grada. ");
INSERT INTO srp1865_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Svega gradova, koje ćete dati Levitima da bude četrdeset i osam gradova, svaki sa svojim podgrađem. ");
INSERT INTO srp1865_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","A tih gradova što ćete dati od nasledstva sinova Izrailjevih, od onih koji imaju više podajte više, a od onih koji imaju manje podajte manje; svaki prema nasledstvu koje će imati neka da od svojih gradova Levitima. ");
INSERT INTO srp1865_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Još reče Gospod Mojsiju govoreći: ");
INSERT INTO srp1865_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Reci sinovima Izrailjevim i kaži im: Kad pređete preko Jordana u zemlju hanansku, ");
INSERT INTO srp1865_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","od gradova koji vam dopadnu odvojte gradove za utočište da u njih uteče krvnik koji ubije koga nehotice. ");
INSERT INTO srp1865_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","I ti će vam gradovi biti utočišta od osvetnika, da ne pogine krvnik dokle ne stane na sud pred zbor. ");
INSERT INTO srp1865_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","I tako od tih gradova koje date šest gradova biće vam utočišta. ");
INSERT INTO srp1865_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Tri takva grada podajte s ove strane Jordana, a tri grada podajte u zemlji hananskoj, ti gradovi neka budu utočišta. ");
INSERT INTO srp1865_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Sinovima Izrailjevim i došljaku i strancu, koji se bavi među njima, neka tih šest gradova budu utočišta, da uteče u njih ko god ubije koga nehotice. ");
INSERT INTO srp1865_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Ali ako gvožđem udari koga, te onaj umre, krvnik je, neka se pogubi takav krvnik. ");
INSERT INTO srp1865_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","I ako kamenom iz ruke, od kog može čovek poginuti, udari koga, te onaj umre, krvnik je, neka se pogubi takav krvnik. ");
INSERT INTO srp1865_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ili ako drvetom iz ruke, od kog može čovek poginuti, udari koga, te onaj umre, krvnik je, neka se pogubi takav krvnik. ");
INSERT INTO srp1865_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Osvetnik neka pogubi krvnika; kad ga udesi, neka ga pogubi. ");
INSERT INTO srp1865_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ako ga iz mržnje turi, ili se baci čim na nj navalice, te onaj umre, ");
INSERT INTO srp1865_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ili ako ga iz neprijateljstva udari rukom, te onaj umre, neka se pogubi takav ubica, krvnik je; osvetnik neka pogubi tog krvnika kad ga udesi. ");
INSERT INTO srp1865_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Ako li ga nehotice turi bez neprijateljstva, ili se baci na nj čim nehotice, ");
INSERT INTO srp1865_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ili kamenom od kog može čovek poginuti, ako se baci na nj nehotice, te onaj umre, a nije mu neprijatelj, niti mu traži zla, ");
INSERT INTO srp1865_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","tada da sudi zbor između ubice i osvetnika po ovom zakonu. ");
INSERT INTO srp1865_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","I zbor neka izbavi krvnika iz ruke osvetnikove i vrati ga u utočište njegovo, kuda je utekao, i onde neka ostane dokle ne umre poglavar sveštenički, koji je pomazan svetim uljem. ");
INSERT INTO srp1865_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ako krvnik kako god iziđe preko međe svog utočišta u koje je utekao, ");
INSERT INTO srp1865_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","i nađe ga osvetnik preko međe utočišta njegovog, ako krvnika ubije osvetnik, neće biti kriv za krv. ");
INSERT INTO srp1865_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Jer u utočištu svom valja da stoji dokle ne umre poglavar sveštenički; pa kad umre poglavar sveštenički, onda treba da se vrati krvnik u zemlju nasledstva svog. ");
INSERT INTO srp1865_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Ovo da vam je uredba za suđenje od kolena do kolena po svim stanovima vašim. ");
INSERT INTO srp1865_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ko bi hteo pogubiti čoveka, po svedocima neka pogubi krvnika; ali jedan svedok ne može svedočiti da se ko pogubi. ");
INSERT INTO srp1865_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ne uzimajte otkup za krvnika, koji zasluži smrt, nego neka se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Ni od onog ne uzimajte otkup koji uteče u utočište, da bi se vratio da živi u svojoj zemlji pre nego umre sveštenik; ");
INSERT INTO srp1865_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","da ne biste skvrnili zemlju u kojoj ste, jer krv ona skvrni zemlju, a zemlja se ne može očistiti od krvi koja se prolije na njoj drugačije nego krvlju onog koji je prolije. ");
INSERT INTO srp1865_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Zato ne skvrnite zemlje u kojoj nastavate i u kojoj ja nastavam, jer ja Gospod nastavam usred sinova Izrailjevih. ");
INSERT INTO srp1865_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Tada pristupiše starešine iz porodice sinova Galada sina Mahira sina Manasijinog od plemena sinova Josifovih, i rekoše pred Mojsijem i pred knezovima, glavarima od domova otačkih među sinovima Izrailjevim, ");
INSERT INTO srp1865_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","i govoriše: Gospodaru našem zapovedi Gospod da podeli žrebom zemlju u nasledstvo sinovima Izrailjevim; i gospodar naš ima zapovest od Gospoda da da nasledstvo Salpada, brata našeg kćerima njegovim. ");
INSERT INTO srp1865_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ako se one udadu za koga iz drugog plemena sinova Izrailjevih, onda će se nasledstvo njihovo otkupiti od nasledstva otaca naših i dodaće se nasledstvu onog plemena u koje se udadu, i tako će se deo naš okrnjiti. ");
INSERT INTO srp1865_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","I kad bude oprosna godina sinovima Izrailjevim, opet će ostati nasledstvo njihovo s nasledstvom onog plemena u koje se budu udale, i tako će od nasledstva plemena otaca naših ostati otkinuto nasledstvo njihovo. ");
INSERT INTO srp1865_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Tada zapovedi Mojsije sinovima Izrailjevim po zapovesti Gospodnjoj govoreći: Pravo govori pleme sinova Josifovih. ");
INSERT INTO srp1865_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ovo zapovedi Gospod za kćeri Salpadove i reče: Neka se udadu za koga im bude volja, ali u porodici plemena svog neka se udadu. ");
INSERT INTO srp1865_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Da se ne bi prenosilo nasledstvo sinova Izrailjevih od jednog plemena na drugo; jer će sinovi Izrailjevi držati svaki nasledstvo plemena otaca svojih. ");
INSERT INTO srp1865_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","I svaka kći u plemenima sinova Izrailjevih kojoj dopadne nasledstvo, neka se udaje za koga iz porodice plemena oca svog, da bi sinovi Izrailjevi držali svaki nasledstvo otaca svojih, ");
INSERT INTO srp1865_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","da se ne bi prenosilo nasledstvo od jednog plemena sinova Izrailjevih da drži svoje nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Kako zapovedi Gospod Mojsiju, tako učiniše kćeri Salpadove. ");
INSERT INTO srp1865_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Jer Mala i Tersa i Egla i Melha i Nuja, kćeri Salpadove, udadoše se za sinove stričeva svojih, ");
INSERT INTO srp1865_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","u porodice sinova Manasije sina Josifovog udadoše se, i osta nasledstvo njihovo u plemenu porodice oca njihovog. ");
INSERT INTO srp1865_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","To su zapovesti i zakoni, koje zapovedi Gospod preko Mojsija sinovima Izrailjevim u polju moavskom na Jordanu prema Jerihonu. ");
INSERT INTO srp1865_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Ovo su reči koje govori Mojsije svemu Izrailju s onu stranu Jordana, u pustinji, u polju prema Crvenom moru, između Farana i Tofola i Lovona i Asirota i Dizava, ");
INSERT INTO srp1865_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","jedanaest dana hoda od Horiva preko gore Sira do Kadis-Varnije. ");
INSERT INTO srp1865_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","A beše četrdesete godine prvi dan jedanaestog meseca, kad Mojsije kaza sinovima Izrailjevim sve što mu beše zapovedio Gospod da im kaže, ");
INSERT INTO srp1865_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","pošto ubi Siona, cara amorejskog koji življaše u Esevonu, i Oga cara vasanskog koji življaše u Astarotu i u Edrajinu. ");
INSERT INTO srp1865_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","S one strane Jordana u zemlji moavskoj poče Mojsije kazivati ovaj zakon govoreći: ");
INSERT INTO srp1865_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Gospod Bog naš reče nam na Horivu govoreći: Dosta ste bili na ovoj gori. ");
INSERT INTO srp1865_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Obrnite se i podignite se i idite ka gori amorejskoj i u svu okolinu njenu, u ravnice i u brda i u doline, i na jug i na bregove morske, u zemlju hanansku i na Livan i do reke velike, reke Efrata. ");
INSERT INTO srp1865_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Eto, dao sam vam zemlju, uđite u nju, i uzmite zemlju, za koju se zakleo Gospod ocima vašim, Avramu, Isaku i Jakovu, da će im je dati i semenu njihovom nakon njih. ");
INSERT INTO srp1865_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","I rekoh vam onda govoreći: Ne mogu vas nositi sam. ");
INSERT INTO srp1865_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Gospod Bog vaš umnožio vas je, i eto vas danas ima mnogo kao zvezda nebeskih. ");
INSERT INTO srp1865_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Gospod Bog otaca vaših da vas umnoži još hiljadu puta više, i da vas blagoslovi kao što vam je kazao. ");
INSERT INTO srp1865_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Kako bih ja sam nosio muke vaše, bremena vaša i raspre vaše? ");
INSERT INTO srp1865_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Dajte iz plemena svojih ljude mudre i vešte i poznate da vam ih postavim za starešine. ");
INSERT INTO srp1865_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Tada mi odgovoriste i rekoste: Dobro je da se učini šta si kazao. ");
INSERT INTO srp1865_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Tada uzevši starešine od plemena vaših, ljude mudre i poznate, postavih vam ih za starešine, za hiljadnike i stotinare i pedesetare i desetare i upravitelje po plemenima vašim. ");
INSERT INTO srp1865_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","I zapovedih onda sudijama vašim govoreći: Saslušavajte raspre među braćom svojom i sudite pravo između čoveka i brata njegovog i između došljaka koji je s njim. ");
INSERT INTO srp1865_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ne gledajte ko je ko na sudu, saslušajte i malog i velikog, ne bojte se nikoga, jer je sud Božiji, a stvar koja bi vam bila teška iznesite preda me da je čujem. ");
INSERT INTO srp1865_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","I zapovedih vam onda sve što ćete činiti. ");
INSERT INTO srp1865_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Potom otišavši od Horiva pređosmo svu onu pustinju veliku i strašnu, koju videste, idući ka gori amorejskoj, kao što nam zapovedi Gospod Bog naš, i dođosmo do Kadis-Varnije. ");
INSERT INTO srp1865_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Tada vam rekoh: Dođoste do gore amorejske, koju nam daje Gospod Bog naš. ");
INSERT INTO srp1865_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Gle, dao ti je Gospod Bog tvoj tu zemlju, idi i uzmi je, kao što ti je rekao Gospod Bog otaca tvojih; ne boj se i ne plaši se. ");
INSERT INTO srp1865_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","A vi svi dođoste k meni i rekoste: Da pošaljemo ljude pred sobom da nam uhode zemlju, i da nam jave za put kojim ćemo ići i za gradove u koje ćemo doći, ");
INSERT INTO srp1865_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","i to mi bi po volji, i uzeh između vas dvanaest ljudi, iz svakog plemena po jednog; ");
INSERT INTO srp1865_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","i oni se podigoše i izišavši na goru dođoše do potoka Eshola, i uhodiše zemlju; ");
INSERT INTO srp1865_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","i nabraše roda one zemlje i donesoše nam, i javiše nam govoreći: Dobra je zemlja, koju nam daje Gospod Bog naš. ");
INSERT INTO srp1865_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Ali ne hteste ići nego se suprotiste zapovesti Gospoda Boga svog. ");
INSERT INTO srp1865_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","I vikaste u šatorima svojim govoreći: Mrzi na nas Gospod, zato nas izvede iz zemlje misirske, da nas da u ruke Amorejcima i da nas potre. ");
INSERT INTO srp1865_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Kuda da idemo? Braća naša uplašiše srce naše govoreći: Narod je veći i viši od nas, gradovi su veliki i ograđeni do neba, pa i sinove Enakove videsmo ovde. ");
INSERT INTO srp1865_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","A ja vam rekoh: Ne plašite se i ne bojte ih se. ");
INSERT INTO srp1865_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Gospod Bog vaš, koji ide pred vama, On će se biti za vas onako kako vam je učinio u Misiru na vaše oči, ");
INSERT INTO srp1865_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","i u pustinji, gde si video kako te je nosio Gospod Bog tvoj, kao što čovek nosi sina svog, celim putem kojim ste išli dokle dođoste do ovog mesta. ");
INSERT INTO srp1865_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ali zato opet ne verovaste Gospodu Bogu svom, ");
INSERT INTO srp1865_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","koji iđaše pred vama putem tražeći vam mesto gde biste stali, iđaše noću u ognju da vam svetli putem kojim biste išli, a danju u oblaku. ");
INSERT INTO srp1865_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","I ču Gospod glas reči vaših, i razgnevi se i zakle se govoreći: ");
INSERT INTO srp1865_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Nijedan od ovog roda zlog neće videti ove dobre zemlje, za koju se zakleh da ću dati vašim ocima, ");
INSERT INTO srp1865_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","osim Haleva, sina Jefonijinog; on će je videti, i njemu ću dati zemlju po kojoj je išao, i sinovima njegovim, jer se sasvim držao Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Pa i na mene se razgnevi Gospod s vas; i reče: Ni ti nećeš ući onamo. ");
INSERT INTO srp1865_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Isus, sin Navin, koji te služi, on će ući onamo, njega utvrdi; jer će je on razdeliti sinovima Izrailjevim u nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","A deca vaša, za koju rekoste da će postati roblje, sinovi vaši, koji danas ne znaju ni šta je dobro ni šta je zlo, oni će ući onamo, i njima ću je dati i oni će je naslediti. ");
INSERT INTO srp1865_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Vi, pak, vratite se i idite u pustinju k Crvenom Moru. ");
INSERT INTO srp1865_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","A vi odgovoriste i rekoste mi: Sagrešismo Gospodu; ići ćemo i bićemo se sasvim kako nam je zapovedio Gospod Bog naš. I uzevši svaki svoje oružje hteste izaći na goru. ");
INSERT INTO srp1865_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","A Gospod mi reče: Kaži im: Ne idite i ne bijte se, jer nisam među vama, da ne izginete pred neprijateljima svojim. ");
INSERT INTO srp1865_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","I ja vam rekoh, ali ne poslušaste, nego se opreste zapovesti Gospodnjoj, i navaliste na goru. ");
INSERT INTO srp1865_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Tada iziđoše pred vas Amoreji, koji seđahu u onoj planini, i pognaše vas kao što čine pčele, i pobiše vas na Siru pa do Orme. ");
INSERT INTO srp1865_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","I vrativši se plakaste pred Gospodom, ali Gospod ne posluša glas vaš niti okrete uho svoje k vama. ");
INSERT INTO srp1865_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","I ostadoste u Kadisu dugo vremena dokle onde stajaste. ");
INSERT INTO srp1865_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Potom se vratismo, i idosmo u pustinju k Crvenom Moru, kao što mi zapovedi Gospod, i obilazismo goru Sir dugo vremena. ");
INSERT INTO srp1865_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","I reče mi Gospod: ");
INSERT INTO srp1865_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Dosta ste obilazili tu goru, obrnite se na sever. ");
INSERT INTO srp1865_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","I zapovedi narodu i reci: Sada ćete preći preko međe braće svoje, sinova Isavovih, koji žive u Siru; i oni će vas se bojati, ali se i vi dobro čuvajte. ");
INSERT INTO srp1865_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Nemojte zametati boja sa njima, jer vam neću dati zemlje njihove ni stope, jer sam dao Isavu goru Sir u nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Jela kupujte od njih za novce, i jedite; i vodu kupujte od njih za novce, i pijte. ");
INSERT INTO srp1865_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Jer te je Gospod Bog tvoj blagoslovio u svakom poslu ruku tvojih; i zna put tvoj po ovoj velikoj pustinji, i evo četrdeset godina beše s tobom Gospod Bog tvoj, i ništa ti nije nedostajalo. ");
INSERT INTO srp1865_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","I prođosmo braću svoju, sinove Isavove, koji žive u Siru, poljem od Elata i od Gesion-Gavera. I odande savivši udarismo preko pustinje moavske. ");
INSERT INTO srp1865_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","I Gospod mi reče: Nemoj pakostiti Moavcima ni zametati boja sa njima, jer ti neću dati zemlje njihove u nasledstvo; jer dadoh sinovima Lotovim u nasledstvo Ar. ");
INSERT INTO srp1865_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Pre življahu onde Emeji, narod velik i jak i visok kao Enakimi; ");
INSERT INTO srp1865_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","o njima se mislilo da su divovi kao i Enakimi; ali ih Moavci zvahu Emeji. ");
INSERT INTO srp1865_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","I Horeji življahu pre u Siru, ali ih sinovi Isavovi isteraše i istrebiše ispred sebe i naseliše se na njihovo mesto, kao što učini Izrailj u zemlji svog nasledstva koje mu dade Gospod.) ");
INSERT INTO srp1865_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","A sada ustanite i pređite preko potoka Zareda. I pređosmo preko potoka Zareda. ");
INSERT INTO srp1865_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","A vremena za koje idosmo od Kadis-Varnije pa dokle pređosmo preko potoka Zareda, beše trideset i osam godina, dokle ne izumre u logoru sav onaj naraštaj, ljudi za vojsku, kao što im se beše zakleo Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Jer i ruka Gospodnja beše protiv njih potirući ih iz logora dokle ne pomreše. ");
INSERT INTO srp1865_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","I kad svi ti ljudi za vojsku pomreše u narodu, ");
INSERT INTO srp1865_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","reče mi Gospod govoreći: ");
INSERT INTO srp1865_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Ti ćeš danas preći preko međe moavske kod Ara; ");
INSERT INTO srp1865_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","i doći ćeš blizu sinova Amonovih; nemoj im pakostiti ni zametati boja sa njima, jer ti neću dati zemlje amonske u nasledstvo, jer je dadoh sinovima Lotovim u nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(I za nju se mislilo da je zemlja divovska; u njoj pre življahu divovi, koje Amonci zvahu Zamzumi. ");
INSERT INTO srp1865_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Behu narod velik i jak i visok kao Enakimi; ali ih istrebi Gospod ispred njih, te oni preuzeše zemlju njihovu i naseliše se na njihovo mesto; ");
INSERT INTO srp1865_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","kao što učini sinovima Isavovim, koji življahu u Siru, jer istrebi Horeje ispred njih, i preuzeše zemlju njihovu i ostaše na njihovom mestu do danas. ");
INSERT INTO srp1865_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","I Aveje, koji življahu u Asirotu pa do Gaze, istrebiše Kaftoreji, koji izađoše od Kaftora, i naseliše se na njihovo mesto.) ");
INSERT INTO srp1865_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Ustanite, idite i pređite preko potoka Arnona; gle, dao sam ti u ruke Siona Amorejina, cara esevonskog i zemlju njegovu; počni uzimati nasledstvo i zavojšti na nj. ");
INSERT INTO srp1865_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Danas počinjem zadavati strah i trepet od tebe narodima pod celim nebom; koji god čuju za te, drhtaće i prepadaće se od tebe. ");
INSERT INTO srp1865_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","I poslah poslenike iz pustinje Kedamota k Sionu, caru esevonskom s mirnim rečima govoreći: ");
INSERT INTO srp1865_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Da pređem preko tvoje zemlje; upravo ću putem ići, neću svrtati ni nadesno ni nalevo. ");
INSERT INTO srp1865_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Hranu da mi daješ za novce da jedem, i vodu za novce da mi daješ da pijem, samo da prođem pešice, ");
INSERT INTO srp1865_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","kao što mi učiniše sinovi Isavovi koji žive u Siru, i Moavci, koji žive u Aru, dokle ne pređem preko Jordana u zemlju koju nam daje Gospod Bog naš. ");
INSERT INTO srp1865_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ali ne hte Sion, car esevonski pustiti da prođemo kroz njegovu zemlju, jer Gospod Bog tvoj učini te otvrdnu duh njegov i srce njegovo posta uporno, da bi ga predao u tvoje ruke, kao što se vidi danas. ");
INSERT INTO srp1865_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","I reče mi Gospod: Gledaj, počeh predavati tebi Siona i zemlju njegovu; počni uzimati zemlju njegovu da je naslediš. ");
INSERT INTO srp1865_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","I iziđe pred nas Sion i sav narod njegov na boj u Jasu. ");
INSERT INTO srp1865_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","I dade nam ga Gospod Bog naš, i ubismo ga sa sinovima njegovim i svim narodom njegovim. ");
INSERT INTO srp1865_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","I uzesmo tada sve gradove njegove, i pobismo ljude po svim tim gradovima, i žene i decu, ne ostavismo živog nijednog. ");
INSERT INTO srp1865_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Samo stoku zaplenismo za se i plen što beše po gradovima koje uzesmo. ");
INSERT INTO srp1865_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Od Aroira koji je na potoku Arnonu, i od grada koji je u dolini, pa do Galada ne beše grada koji bi nam odoleo: sve to dade nam Gospod Bog naš. ");
INSERT INTO srp1865_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Samo k zemlji sinova Amonovih nisi pristupio niti ka kome kraju na potoku Javoku, ni ka gradovima u gori niti kome mestu što je zabranio Gospod Bog naš. ");
INSERT INTO srp1865_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Potom obrativši se idosmo k Vasanu. I iziđe pred nas Og, car vasanski i sav narod njegov na boj u Edrajin. ");
INSERT INTO srp1865_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","I Gospod mi reče: Ne boj ga se, jer ga dadoh u tvoje ruke sa svim narodom njegovim i sa zemljom njegovom, da učiniš s njim onako kako si učinio sa Sionom carem amorejskim, koji seđaše u Esevonu. ");
INSERT INTO srp1865_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Tako nam dade Gospod Bog naš u ruke i Oga, cara vasanskog sa svim narodom njegovim, i razbismo ga i ne ostavismo mu nijednog živog. ");
INSERT INTO srp1865_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","I uzesmo tada sve gradove njegove; ne bi nijednog grada kog ne uzesmo, šezdeset gradova, sav kraj argovski, carstvo Oga u Vasanu. ");
INSERT INTO srp1865_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Svi ti gradovi behu utvrđeni zidom visokim, vratima i prevornicama, osim drugih mesta bez zidova vrlo mnogo. ");
INSERT INTO srp1865_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","I raskopasmo ih kao što učinismo Sionu, caru esevonskom, pobivši po svim mestima i ljude i žene i decu. ");
INSERT INTO srp1865_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","A svu stoku i plen po gradovima zaplenismo za se. ");
INSERT INTO srp1865_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Tako uzesmo onda zemlju iz ruku dvojice careva amorejskih, koja je s ove strane Jordana od potoka Arnona do gore Ermona, ");
INSERT INTO srp1865_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Sidonci zovu Ermon Sirion, a Amoreji ga zovu Senir,) ");
INSERT INTO srp1865_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Sva mesta u ravni i sav Galad i sav Vasan do Salhe i Edrajina, gradove carstva Oga u Vasanu. ");
INSERT INTO srp1865_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Jer samo Og car vasanski beše ostao od divova. Gle, odar njegov, odar gvozden, nije li u Ravi sinova Amonovih? Devet je lakata dug, a širok četiri lakta, lakta čovečija. ");
INSERT INTO srp1865_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Tako nasledismo tu zemlju onda; od Aroira, koji je na potoku Arnonu, i polovinu gore Galada s gradovima njenim dadoh sinovima Ruvimovim i Gadovim. ");
INSERT INTO srp1865_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","I ostatak Galada i sav Vasan, carstvo Ogovo, dadoh polovini plemena Manasijinog; sav kraj argovski po svemu Vasanu zvaše se zemlja divovska. ");
INSERT INTO srp1865_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair sin Manasijin uze sav kraj argovski do međe gesurske i mahatske; i prozva Vasansku svojim imenom: sela Jairova do današnjeg dana. ");
INSERT INTO srp1865_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","A Mahiru dadoh Galad. ");
INSERT INTO srp1865_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","A Ruvimovom plemenu i Gadovom plemenu dadoh od Galada do potoka Arnona, kako zahvata potok s međama, pa do potoka Javoka, gde je međa sinova Amonovih. ");
INSERT INTO srp1865_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","I polje i Jordan s međama od Hinerota do mora uz polje, do mora slanog, ispod Fazge prema istoku. ");
INSERT INTO srp1865_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","I zapovedih vam onda i rekoh: Gospod Bog vaš dao vam je ovu zemlju u nasledstvo; naoružani hajdete pred braćom svojom, sinovima Izrailjevim, ko je god za vojsku. ");
INSERT INTO srp1865_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","A žene vaše i deca vaša i stoka vaša (znam da imate mnogo stoke) neka ostanu u gradovima vašim, koje vam dadoh, ");
INSERT INTO srp1865_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","dokle ne smiri Gospod i braću vašu kao vas, da i oni naslede zemlju, koju će im Gospod Bog vaš dati s one strane Jordana; onda se vratite svaki na svoje nasledstvo, koje vam dadoh. ");
INSERT INTO srp1865_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","A Isusu onda zapovedih govoreći: Oči tvoje vide sve što je učinio Gospod Bog vaš sa ona dva cara; onako će Gospod učiniti sa svim carstvima u koja dođeš. ");
INSERT INTO srp1865_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Nemojte ih se bojati, jer će se Gospod Bog vaš biti za vas. ");
INSERT INTO srp1865_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","I molih se Gospodu onda govoreći: ");
INSERT INTO srp1865_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Gospode Bože! Ti si počeo pokazivati sluzi svom veličinu svoju i krepku ruku svoju, jer koji je Bog na nebu ili na zemlji koji bi tvorio dela kakva su Tvoja i u koga bi bila sila kakva je Tvoja? ");
INSERT INTO srp1865_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Daj mi da pređem i vidim zemlju dobru koja je preko Jordana i goru dobru, Livan. ");
INSERT INTO srp1865_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ali Gospod beše gnevan na me s vas, i ne usliši me, nego mi reče: Dosta; ne govori mi više za to. ");
INSERT INTO srp1865_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Popni se na vrh ove gore, i podigavši oči svoje na zapad i na sever i na jug i na istok, vidi očima svojim, jer nećeš preći preko Jordana. ");
INSERT INTO srp1865_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Nego podaj zapovesti Isusu, i utvrdi ga i ukrepi ga; jer će on preći pred narodom tim, i on će im razdeliti u nasledstvo zemlju koju vidiš. ");
INSERT INTO srp1865_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","I ostasmo u ovoj dolini prema Vet-Fegoru. ");
INSERT INTO srp1865_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","A sada, Izrailju, čuj uredbe moje i zakone, koje vas učim da tvorite, da biste poživeli i ušli u zemlju koju vam daje Gospod Bog otaca vaših i da biste je nasledili. ");
INSERT INTO srp1865_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ništa ne dodajte k reči koju vam ja zapovedam, niti oduzmite od nje, da biste sačuvali zapovesti Gospoda Boga svog koje vam ja zapovedam. ");
INSERT INTO srp1865_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Oči su vaše videle šta učini Gospod s Velfegora; jer svakog čoveka koji pođe za Velfegorom istrebi Gospod Bog tvoj između tebe. ");
INSERT INTO srp1865_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","A vi koji se držaste Gospoda Boga svog, vi ste svi živi danas. ");
INSERT INTO srp1865_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Gle, učio sam vas uredbama i zakonima, kao što mi zapovedi Gospod Bog moj, da biste tako tvorili u zemlji koju idete da je nasledite. ");
INSERT INTO srp1865_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Držite dakle i izvršujte ih, jer je to mudrost vaša i razum vaš pred narodima, koji će kad čuju sve ove uredbe reći: Samo je ovaj veliki narod mudar i razuman. ");
INSERT INTO srp1865_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Jer koji je veliki narod kome je Gospod blizu kao što je Gospod Bog naš kad Ga god zazovemo? ");
INSERT INTO srp1865_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","I koji je narod veliki koji ima uredbe i zakone pravedne kao što je sav ovaj zakon koji iznosim danas pred vas? ");
INSERT INTO srp1865_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Samo pazi na se i dobro čuvaj dušu svoju, da ne zaboraviš one stvari koje su videle oči tvoje, i da ne iziđu iz srca tvog dokle si god živ; nego da ih obznaniš sinovima svojim i sinovima sinova svojih. ");
INSERT INTO srp1865_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Onaj dan kad stajaste pred Gospodom Bogom svojim kod Horiva, kad mi Gospod reče: Saberi mi narod da im kažem reči svoje, kojima će se naučiti da me se boje dok su živi na zemlji, i da uče tome i sinove svoje; ");
INSERT INTO srp1865_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","kad pristupiste i stajaste pod gorom, a gora ognjem goraše do samog neba i beše na njoj tama i oblak i mrak; ");
INSERT INTO srp1865_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","i progovori Gospod k vama isred ognja; glas od reči čuste, ali osim glasa lik ne videste; ");
INSERT INTO srp1865_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","i objavi vam zavet svoj, koji vam zapovedi da držite, deset reči, koje napisa na dve ploče kamene. ");
INSERT INTO srp1865_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","I meni zapovedi onda Gospod da vas učim uredbama i zakonima da ih tvorite u zemlji u koju idete da je nasledite. ");
INSERT INTO srp1865_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Zato čuvajte dobro duše svoje; jer ne videste nikakav lik u onaj dan kad vam govori Gospod na Horivu isred ognja, ");
INSERT INTO srp1865_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","da se ne biste pokvarili i načinili sebi lik rezan ili kakvu god sliku od čoveka ili od žene, ");
INSERT INTO srp1865_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","sliku od kakvog živinčeta koje je na zemlji, ili sliku od kakve ptice krilate koja leti ispod neba; ");
INSERT INTO srp1865_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","sliku od čega što puže po zemlji, ili sliku od kakve ribe koja je u vodi pod zemljom; ");
INSERT INTO srp1865_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","i da ne bi podigavši oči svoje k nebu i videvši sunce i mesec i zvezde, svu vojsku nebesku, prevario se i klanjao im se i služio im; jer ih Gospod Bog tvoj dade svim narodima pod celim nebom; ");
INSERT INTO srp1865_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","a vas uze Gospod i izvede vas iz peći gvozdene, iz Misira, da mu budete narod nasledni, kao što se vidi danas. ");
INSERT INTO srp1865_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ali se Gospod razgnevi na me za vaše reči, i zakle se da neću preći preko Jordana ni ući u dobru zemlju, koju ti Gospod Bog tvoj daje u nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","I ja ću umreti u ovoj zemlji i neću preći preko Jordana; a vi ćete preći i naslediti onu dobru zemlju. ");
INSERT INTO srp1865_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Pazite da ne zaboravite zavet Gospoda Boga svog, koji učini s vama, i da ne gradite sebi lik rezani, sliku od koje god tvari, kao što ti je zabranio Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Jer je Gospod Bog tvoj oganj koji spaljuje i Bog koji revnuje. ");
INSERT INTO srp1865_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Kad izrodiš sinove i unuke, i ostarite u onoj zemlji, ako se pokvarite i načinite sliku rezanu od kakve tvari i učinite šta nije ugodno Gospodu Bogu vašem, dražeći Ga, ");
INSERT INTO srp1865_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","svedočim vam danas nebom i zemljom da će vas brzo nestati sa zemlje u koju idete preko Jordana da je nasledite, nećete biti dugo u njoj, nego ćete se istrebiti. ");
INSERT INTO srp1865_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Ili će vas rasejati Gospod među narode, i malo će vas ostati među narodima u koje vas odvede Gospod; ");
INSERT INTO srp1865_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","i služićete onde bogovima koje su načinile ruke čovečije, od drveta i od kamena, koji ne vide ni čuju, niti jedu ni mirišu. ");
INSERT INTO srp1865_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ali ako i onde potražiš Gospoda Boga svog, naći ćeš Ga, ako Ga potražiš svim srcem svojim i svom dušom svojom. ");
INSERT INTO srp1865_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Kad budeš u nevolji i sve te to snađe, ako se u poslednje vreme obratiš ka Gospodu Bogu svom, i poslušaš glas Njegov, ");
INSERT INTO srp1865_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Gospod je Bog tvoj milostiv Bog, neće te ostaviti ni istrebiti, jer neće zaboraviti zavet s ocima tvojim, za koji im se zakleo. ");
INSERT INTO srp1865_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Jer zapitaj sada za stara vremena, koja su bila pre tebe, od onog dana kad stvori Bog čoveka na zemlji, i od jednog kraja neba do drugog, je li kad bila ovakva stvar velika, i je li se kad čulo šta takvo? ");
INSERT INTO srp1865_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Je li kad čuo koji narod glas Božji gde govori isred ognja, kao što si ti čuo i ostao živ? ");
INSERT INTO srp1865_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ili, je li Bog pokušao da dođe te uzme sebi narod iz drugog naroda kušanjem, znacima i čudesima i ratom i rukom krepkom i mišicom podignutom i strahotama velikim, kao što je učinio sve to za vas Gospod Bog naš u Misiru na vaše oči? ");
INSERT INTO srp1865_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Tebi je to pokazano da poznaš da je Gospod Bog, i da nema drugog osim Njega. ");
INSERT INTO srp1865_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Dao ti je da čuješ glas Njegov s neba da bi te naučio, i pokazao ti je na zemlji oganj svoj veliki, i reči Njegove čuo si isred ognja. ");
INSERT INTO srp1865_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","I što mu mili behu oci tvoji, zato izabra seme njihovo nakon njih, i izvede te sam velikom silom svojom iz Misira, ");
INSERT INTO srp1865_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","da otera ispred tebe narode veće i jače od tebe, i da tebe uvede u njihovu zemlju i dade ti je u nasledstvo, kao što se vidi danas. ");
INSERT INTO srp1865_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Znaj dakle i pamti u srcu svom da je Gospod Bog, gore na nebu i dole na zemlji, nema drugog. ");
INSERT INTO srp1865_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","I drži uredbe Njegove i zapovesti Njegove, koje ti ja danas zapovedam, da bi dobro bilo tebi i sinovima tvojim nakon tebe, da bi ti se produžili dani na zemlji koju ti Gospod Bog tvoj daje zasvagda. ");
INSERT INTO srp1865_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Tada odeli Mojsije tri grada s ove strane Jordana prema istoku, ");
INSERT INTO srp1865_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","da bi bežao u njih krvnik koji ubije bližnjeg svog nehotice ne mrzevši pre na nj, i kad pobegne u koji od tih gradova, da bi ostao živ: ");
INSERT INTO srp1865_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Vosor u pustinji, na ravnici u zemlji plemena Ruvimovog, i Ramot u Galadu u plemenu Gadovom, Golan u vasanskoj u plemenu Manasijinom. ");
INSERT INTO srp1865_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ovo je zakon koji postavi Mojsije sinovima Izrailjevim. ");
INSERT INTO srp1865_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Ovo su svedočanstva i uredbe i zakoni, koje kaza Mojsije sinovima Izrailjevim kad iziđoše iz Misira, ");
INSERT INTO srp1865_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","s ove strane Jordana u dolini prema Vet-Fegoru u zemlji Siona cara amorejskog, koji življaše u Esevonu, kog ubi Mojsije i sinovi Izrailjevi kad iziđoše iz Misira, ");
INSERT INTO srp1865_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","i osvojiše zemlju njegovu i zemlju Oga, cara vasanskog, dva cara amorejska, koja je s one strane Jordana prema istoku, ");
INSERT INTO srp1865_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","od Aroira, koji je na potoku Arnonu, do gore Siona, a to je Ermon, ");
INSERT INTO srp1865_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","i sve polje s ove strane Jordana prema istoku do mora uz ravnicu pod Azdot-Fazgom. ");
INSERT INTO srp1865_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","I Mojsije sazva sav narod Izrailjev, i reče im: Čuj Izrailju uredbe i zakone, koje ću danas kazati da čujete, da ih naučite i držite ih i tvorite. ");
INSERT INTO srp1865_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Gospod Bog naš učini s nama zavet na Horivu. ");
INSERT INTO srp1865_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Nije s ocima našim učinio taj zavet, nego s nama, koji smo danas tu svi živi. ");
INSERT INTO srp1865_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Licem k licu govorio vam je Gospod na ovoj gori isred ognja; ");
INSERT INTO srp1865_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","ja tada stajah između Gospoda i vas, da vam javim reči Gospodnje, jer vas beše strah od ognja i ne iziđoste na goru; i reče: ");
INSERT INTO srp1865_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Ja sam Gospod Bog tvoj koji sam te izveo iz zemlje misirske, iz doma ropskog. ");
INSERT INTO srp1865_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Nemoj imati bogove druge do mene. ");
INSERT INTO srp1865_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Ne gradi sebi lik rezani, niti kakvu sliku od tvari koje su gore na nebu ili koje su dole na zemlji ili koje su u vodi ispod zemlje. ");
INSERT INTO srp1865_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Nemoj im se klanjati niti im služiti, jer sam ja Gospod Bog tvoj, Bog revnitelj, koji na sinovima pohodim bezakonja otaca njihovih do trećeg i do četvrtog kolena, onih koji mrze na me, ");
INSERT INTO srp1865_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","a činim milost na hiljadama onih koji me ljube i čuvaju zapovesti moje. ");
INSERT INTO srp1865_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Ne uzimaj uzalud ime Gospoda Boga svog, jer neće pred Gospodom biti prav ko uzme ime Njegovo uzalud. ");
INSERT INTO srp1865_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Drži dan od odmora i svetkuj ga, kao što ti je zapovedio Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Šest dana radi i svršuj sve poslove svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","A sedmi je dan odmor Gospodu Bogu tvom; nemoj raditi nikakav posao ni ti, ni sin tvoj ni kći tvoja, ni sluga tvoj ni sluškinja tvoja, ni vo tvoj ni magarac tvoj, niti koje živinče tvoje, ni došljak koji je kod tebe, da bi se odmorio sluga tvoj i sluškinja tvoja kao i ti. ");
INSERT INTO srp1865_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","I pamti da si bio rob u zemlji misirskoj, i Gospod Bog tvoj izvede te odande rukom krepkom i mišicom podignutom. Zato ti je Gospod Bog tvoj zapovedio da svetkuješ dan od odmora. ");
INSERT INTO srp1865_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Poštuj oca svog i mater svoju, kao što ti je zapovedio Gospod Bog tvoj, da bi se produžili dani tvoji i da bi ti dobro bilo na zemlji, koju ti dade Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Ne ubij. ");
INSERT INTO srp1865_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Ne čini preljube. ");
INSERT INTO srp1865_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Ne kradi. ");
INSERT INTO srp1865_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Ne svedoči lažno na bližnjeg svog. ");
INSERT INTO srp1865_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Ne poželi ženu bližnjeg svog, ne poželi kuću bližnjeg svog, ni njivu njegovu, ni slugu njegovog, ni sluškinju njegovu, ni vola njegovog, ni magarca njegovog, niti išta šta je bližnjeg tvog. ");
INSERT INTO srp1865_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Te reči izgovori Gospod svemu zboru vašem na gori isred ognja, oblaka i mraka, glasom velikim, i ništa više, nego ih napisa na dve ploče kamene koje mi dade. ");
INSERT INTO srp1865_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","A vi kad čuste glas isred tame, jer gora ognjem goraše, pristupiste k meni, svi glavari od plemena vaših i starešine vaše, ");
INSERT INTO srp1865_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","i rekoste: Gle, pokaza nam Gospod Bog naš slavu i veličinu svoju, i čusmo glas Njegov isred ognja; danas videsmo gde Bog govori s čovekom, i čovek osta živ. ");
INSERT INTO srp1865_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Pa sada zašto da pomremo? Jer će nas spaliti onaj oganj veliki; ako još čujemo glas Gospoda Boga svog, pomrećemo. ");
INSERT INTO srp1865_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Jer koje je telo čulo glas Boga Živoga gde govori isred ognja, kao mi, i ostalo živo? ");
INSERT INTO srp1865_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Idi ti, i saslušaj sve što će ti kazati Gospod Bog naš, pa onda ti kaži nama šta ti god kaže Gospod Bog naš, a mi ćemo slušati i tvoriti. ");
INSERT INTO srp1865_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","I Gospod ču glas od reči vaših kad vi govoraste, i reče mi Gospod: Čuh glas od reči tog naroda, koje rekoše tebi; šta rekoše dobro rekoše. ");
INSERT INTO srp1865_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","O, kad bi im bilo srce svagda tako da me se boje i drže sve zapovesti moje svagda, da bi bilo dobro njima i sinovima njihovim doveka. ");
INSERT INTO srp1865_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Idi, reci im: Vratite se u šatore svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","A ti stani ovde kod mene, i kazaću ti sve zapovesti i uredbe i zakone, koje ćeš ih naučiti da tvore u zemlji koju im dajem u nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Gledajte, dakle da činite onako kako vam je zapovedio Gospod Bog vaš, ne svrćite ni nadesno ni nalevo. ");
INSERT INTO srp1865_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Celim putem, koji vam je zapovedio Gospod Bog vaš, idite, da biste živi bili i da bi vam dobro bilo, i da bi vam se produžili dani u zemlji koju ćete naslediti. ");
INSERT INTO srp1865_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","A ovo su zapovesti i uredbe i zakoni, koje Gospod Bog vaš zapovedi da vas učim da ih tvorite u zemlji u koju idete da je nasledite, ");
INSERT INTO srp1865_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","da bi se bojao Gospoda Boga svog držeći sve uredbe Njegove i zapovesti Njegove, koje ti ja zapovedam, ti sin tvoj i unuk tvoj svega veka svog, da bi ti se produžili dani tvoji. ");
INSERT INTO srp1865_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Čuj dakle, Izrailju, i gledaj da tako činiš, da bi ti dobro bilo i da biste se umnožili veoma u zemlji u kojoj teče mleko i med, kao što ti je rekao Gospod Bog otaca tvojih. ");
INSERT INTO srp1865_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Čuj, Izrailju: Gospod je Bog naš jedini Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Zato ljubi Gospoda Boga svog iz svega srca svog i iz sve duše svoje i iz sve snage svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","I neka ove reči koje ti je zapovedam danas budu u srcu tvom. ");
INSERT INTO srp1865_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","I često ih napominji sinovima svojim, i govori o njima kad sediš u kući svojoj i kad ideš putem, kad ležeš i kad ustaješ. ");
INSERT INTO srp1865_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","I veži ih sebi na ruku za znak, i neka ti budu kao počeonik među očima. ");
INSERT INTO srp1865_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","I napiši ih na dovratnicima od kuće svoje i na vratima svojim. ");
INSERT INTO srp1865_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","A kad te uvede Gospod Bog tvoj u zemlju za koju se zakleo ocima tvojim Avramu, Isaku i Jakovu, da će ti je dati, u gradove velike i dobre, kojih nisi zidao. ");
INSERT INTO srp1865_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","I kuće pune svakog dobra, kojih nisi punio, i na studence iskopane, kojih nisi kopao, u vinograde i u maslinike, kojih nisi sadio, i staneš jesti i nasitiš se, ");
INSERT INTO srp1865_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","čuvaj se da ne zaboraviš Gospoda, koji te je izveo iz zemlje misirske, iz kuće ropske. ");
INSERT INTO srp1865_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Gospoda Boga svog boj se, i Njemu služi, i Njegovim se imenom kuni. ");
INSERT INTO srp1865_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ne idite za drugim bogovima između bogova drugih naroda, koji su oko vas. ");
INSERT INTO srp1865_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Jer je Bog revnitelj, Gospod Bog tvoj usred tebe, pa da se ne bi razgnevio Gospod Bog tvoj na te i istrebio te iz zemlje. ");
INSERT INTO srp1865_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Nemojte kušati Gospoda Boga svog kao što Ga kušaste u Masi. ");
INSERT INTO srp1865_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Držite dobro zapovesti Gospoda Boga svog i svedočanstva Njegova i uredbe Njegove, koje ti je zapovedio, ");
INSERT INTO srp1865_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","i čini što je pravo i dobro pred Gospodom, da bi ti bilo dobro i da bi ušao u dobru zemlju, za koju se zakleo Gospod ocima tvojim, i da bi je nasledio, ");
INSERT INTO srp1865_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","da bi oterao sve neprijatelje tvoje ispred tebe, kao što ti je rekao Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Pa kad te zapita posle sin tvoj govoreći: Kakva su to svedočanstva i uredbe i zakoni, što vam je zapovedio Gospod Bog naš? ");
INSERT INTO srp1865_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Onda kaži sinu svom: Bejasmo robovi Faraonovi u Misiru, i izvede nas Gospod iz Misira rukom krepkom, ");
INSERT INTO srp1865_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","i učini Gospod znake i čudesa velika i zla u Misiru na Faraonu i na svemu domu njegovom pred nama, ");
INSERT INTO srp1865_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","a nas izvede odande da nas uvede u zemlju za koju se zakleo ocima našim da će nam je dati. ");
INSERT INTO srp1865_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","I zapovedi nam Gospod da vršimo sve ove uredbe bojeći se Gospoda Boga svog, da bi nam bilo dobro svagda i da bi nas sačuvao u životu, kao što se vidi danas. ");
INSERT INTO srp1865_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","I biće nam pravda, ako uzdržimo i ustvorimo sve zapovesti ove pred Gospodom Bogom svojim kako nam je zapovedio. ");
INSERT INTO srp1865_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Kad te Gospod Bog tvoj uvede u zemlju u koju ideš da je naslediš, i otera ispred tebe narode mnoge, Heteje i Gergeseje i Amoreje i Hananeje i Ferezeje i Jeveje i Jevuseje, sedam naroda većih i jačih od tebe, ");
INSERT INTO srp1865_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","i preda ih Gospod Bog tvoj tebi, i ti ih razbiješ, potri ih, ne hvataj s njima vere, niti se smiluj na njih; ");
INSERT INTO srp1865_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","niti se prijatelji s njima; kćeri svoje ne daj za sina njihovog, niti kćeri njihove uzimaj za sina svog. ");
INSERT INTO srp1865_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Jer bi otpadila sina tvog od mene, i služio bi bogovima drugim, te bi se razgnevio Gospod na vas i potro vas brzo. ");
INSERT INTO srp1865_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Nego im ovo učinite: oltare njihove raskopajte, i likove njihove polomite, lugove njihove isecite, i rezane bogove njihove ognjem spalite. ");
INSERT INTO srp1865_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Jer si ti narod svet Gospodu Bogu svom, tebe je izabrao Gospod Bog tvoj da mu budeš narod osobit mimo sve narode na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Ne zato što bi vas bilo više nego drugih naroda prihvati vas Gospod i izabra vas; jer vas beše manje nego ikog drugog naroda; ");
INSERT INTO srp1865_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","nego što vas Gospod miluje i što drži zakletvu kojom se zakleo ocima vašim, zato vas je Gospod izveo rukom krepkom i izbavio vas iz kuće ropske, iz ruke Faraona, cara misirskog. ");
INSERT INTO srp1865_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","I tako znaj da je Gospod Bog tvoj Bog, Bog veran, koji drži zavet svoj i milost svoju do hiljadu kolena onima koji Ga ljube i drže zapovesti Njegove, ");
INSERT INTO srp1865_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","i plaća onima koji mrze na nj, svakome istrebljujući ga, i ne odgađa onome koji mrzi na nj, plaća svakome. ");
INSERT INTO srp1865_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Zato drži zapovesti i uredbe i zakone, koje ti danas ja zapovedam, da ih tvoriš. ");
INSERT INTO srp1865_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","I ako ove zakone uzaslušate i uzdržite i ustvorite i Gospod će Bog držati tebi zavet i milost, za koju se zakleo ocima tvojim; ");
INSERT INTO srp1865_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","i milovaće te i blagosloviće te i umnožiće te; blagosloviće plod utrobe tvoje i plod zemlje tvoje, žito tvoje i vino tvoje i ulje tvoje, plod goveda tvojih i stada ovaca tvojih u zemlji za koju se zakleo ocima tvojim da će ti je dati. ");
INSERT INTO srp1865_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Bićeš blagosloven mimo sve narode: neće biti u tebi ni muškog ni ženskog neplodnog, ni među stokom tvojom. ");
INSERT INTO srp1865_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","I ukloniće od tebe Gospod svaku bolest, od ljutih zala misirskih koja znaš neće nijedno pustiti na tebe, nego će pustiti na one koji mrze na te. ");
INSERT INTO srp1865_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","I istrebi sve narode koje ti Gospod Bog tvoj preda, neka ih ne požali oko tvoje, i nemoj služiti bogovima njihovim, jer bi ti to bila zamka. ");
INSERT INTO srp1865_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Ako bi rekao u srcu svom: Veći su ovi narodi od mene, kako ih mogu izgnati? ");
INSERT INTO srp1865_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Ne boj ih se; pamti dobro šta je učinio Gospod Bog tvoj s Faraonom i sa svim Misircima, ");
INSERT INTO srp1865_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","velika kušanja, koja videše oči tvoje, i znake i čudesa i ruku krepku i mišicu podignutu, kojom te izvede Gospod Bog tvoj; onako će učiniti Gospod Bog tvoj sa svim narodima od kojih bi se uplašio. ");
INSERT INTO srp1865_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","I stršljene će poslati Gospod Bog tvoj na njih dokle ne izginu koji bi ostali i sakrili se od tebe. ");
INSERT INTO srp1865_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ne plaši se od njih, jer je Gospod Bog tvoj usred tebe, Bog veliki i strašni. ");
INSERT INTO srp1865_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Gospod će Bog tvoj malo po malo potrti te narode ispred tebe; nećeš ih moći odjedanput istrebiti, da se ne bi umnožilo na tebe zverje poljsko. ");
INSERT INTO srp1865_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Ali će ih predati Gospod Bog tvoj tebi, i zatiraće ih zatiranjem velikim dokle se ne zatru. ");
INSERT INTO srp1865_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","I predaće careve njihove u tvoje ruke da zatreš ime njihovo pod nebom, neće se nijedan održati pred tobom, dokle ih ne potreš. ");
INSERT INTO srp1865_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Rezane bogove njihove spali ognjem, nemoj da se polakomiš na srebro ili zlato što je na njima i da ga uzmeš, da ti ne bude zamka, jer je gadno pred Gospodom Bogom tvojim. ");
INSERT INTO srp1865_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","I nemoj da uneseš gada u dom svoj, da ne budeš proklet kao i on, nego se gadi na nj i grozi se od njega, jer je prokleto. ");
INSERT INTO srp1865_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Držite i tvorite sve zapovesti koje vam ja zapovedam danas, da biste živi bili i umnožili se, i da biste ušli u zemlju za koju se Gospod zakleo ocima vašim, i da biste je nasledili. ");
INSERT INTO srp1865_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","I opominji se svega puta kojim te je vodio Gospod Bog tvoj četrdeset godina po pustinji, da bi te namučio i iskušao, da se zna šta ti je u srcu, hoćeš li držati zapovesti Njegove ili nećeš. ");
INSERT INTO srp1865_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","I mučio te je, glađu te morio; ali te je opet hranio manom za koju ti nisi znao ni oci tvoji, da bi ti pokazao da čovek ne živi o samom hlebu nego o svemu što izlazi iz usta Gospodnjih. ");
INSERT INTO srp1865_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Odelo tvoje ne ovetša na tebi niti noga tvoja oteče za ovih četrdeset godina; ");
INSERT INTO srp1865_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","zato poznaj u srcu svom da te Gospod Bog tvoj gaji kao što čovek gaji svoje dete. ");
INSERT INTO srp1865_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","I drži zapovesti Gospoda Boga svog hodeći putevima Njegovim i bojeći se Njega. ");
INSERT INTO srp1865_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Jer Gospod Bog tvoj uvešće te sada u dobru zemlju, u zemlju u kojoj ima dosta potoka i izvora i jezera, što izviru po dolinama i po brdima; ");
INSERT INTO srp1865_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","u zemlju izobilnu pšenicom i ječmom i vinovom lozom i smokvama i šipcima, zemlju izobilnu maslinom, od koje biva ulje, i medom; ");
INSERT INTO srp1865_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","u zemlju gde nećeš sirotinjski jesti hleba, gde ti neće ništa nedostajati; u zemlju gde je kamenje gvožđe i gde ćeš iz brda njenih seći bronzu. ");
INSERT INTO srp1865_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ješćeš i bićeš sit, pa blagosiljaj Gospoda Boga svog za dobru zemlju koju ti da. ");
INSERT INTO srp1865_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","I čuvaj se da ne zaboraviš Gospoda Boga svog bacivši u nemar zapovesti Njegove i zakone Njegove i uredbe Njegove, koje ti ja zapovedam danas. ");
INSERT INTO srp1865_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","I kad uzjedeš i nasitiš se, i dobre kuće načiniš i u njima staneš živeti, i kad se goveda tvoja i ovce tvoje naplode, ");
INSERT INTO srp1865_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","i kad ti se namnoži srebro i zlato, i šta god imaš kad ti se namnoži, ");
INSERT INTO srp1865_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","nemoj da se ponese srce tvoje i zaboraviš Gospoda Boga svog, koji te je izveo iz zemlje misirske, iz kuće ropske; ");
INSERT INTO srp1865_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","koji te je vodio preko one pustinje velike i strašne gde žive zmije vatrene i skorpije, gde je suša, a nema vode; koji ti je izveo vodu iz tvrdog kamena; ");
INSERT INTO srp1865_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","koji te je hranio u pustinji manom, za koju ne znaše oci tvoji, da bi te namučio i iskušao te, i najposle da bi ti dobro učinio. ");
INSERT INTO srp1865_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Niti govori u srcu svom; moja snaga, i sila moje ruke dobavila mi je ovo blago. ");
INSERT INTO srp1865_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Nego se opominji Gospoda Boga svog; jer ti On daje snagu da dobavljaš blago, da bi potvrdio zavet svoj, za koji se zakleo ocima tvojim, kao što se vidi danas. ");
INSERT INTO srp1865_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ako li zaboraviš Gospoda Boga svog, i pođeš za drugim bogovima i njima staneš služiti i klanjati se, svedočim vam danas da ćete zacelo propasti. ");
INSERT INTO srp1865_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Propašćete kao narodi koje Gospod potire ispred vas, jer ne poslušaste glas Gospoda Boga svog. ");
INSERT INTO srp1865_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Čuj, Izrailju! Ti danas prelaziš preko Jordana da uđeš i naslediš narode veće i jače od sebe, gradove velike i ograđene do neba. ");
INSERT INTO srp1865_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Velik i visok narod, sinove Enakove, koje znaš i za koje si slušao: ");
INSERT INTO srp1865_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Znaj dakle danas da je Gospod Bog tvoj, koji ide pred tobom, oganj koji spaljuje; On će ih istrebiti i On će ih oboriti pred tobom, i izgnaćeš ih i istrebiti brzo, kao što ti je kazao Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Kad ih Gospod Bog tvoj otera ispred tebe, nemoj da kažeš u srcu svom: Za pravdu moju uvede me Gospod u ovu zemlju da je nasledim; jer Gospod tera one narode ispred tebe za nevaljalstvo njihovo! ");
INSERT INTO srp1865_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ne ideš za pravdu svoju ni za čistotu srca svog da naslediš tu zemlju; nego za nevaljalstvo tih naroda Gospod Bog tvoj otera ih ispred tebe, i da održi reč za koju se zakleo ocima tvojim, Avramu, Isaku i Jakovu. ");
INSERT INTO srp1865_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Znaj, dakle, da ti Gospod Bog tvoj ne daje te dobre zemlje za pravdu tvoju da je naslediš, jer si tvrdovrat narod. ");
INSERT INTO srp1865_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Pamti i ne zaboravi kako si gnevio Gospoda Boga svog u pustinji; od onog dana kad iziđoste iz zemlje misirske pa dokle dođoste na ovo mesto, nepokorni bejaste Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","I kod Horiva razgneviste Gospoda, i od gneva htede vas Gospod da istrebi. ");
INSERT INTO srp1865_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Kad iziđoh na goru da primim ploče kamene, ploče zaveta, koji s vama učini Gospod, tada stajah na gori četrdeset dana i četrdeset noći hleba ne jedući ni vode pijući. ");
INSERT INTO srp1865_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","I dade mi Gospod dve ploče kamene, ispisane prstom Gospodnjim, na kojima behu reči sve koje vam izgovori Gospod na gori isred ognja na dan zbora vašeg. ");
INSERT INTO srp1865_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Posle četrdeset dana i četrdeset noći dade mi Gospod dve ploče kamene, ploče zavetne. ");
INSERT INTO srp1865_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","I reče mi Gospod: Ustani, siđi brže odavde; jer se pokvari narod tvoj koji si izveo iz Misira, siđoše brzo s puta koji im zapovedih, i načiniše sebi liven lik. ");
INSERT INTO srp1865_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Još mi reče Gospod govoreći: Pogledah ovaj narod, i eto je narod tvrdog vrata. ");
INSERT INTO srp1865_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Pusti me da ih istrebim i ime njihovo zatrem pod nebom; a od tebe ću učiniti narod jači i veći nego što je ovaj. ");
INSERT INTO srp1865_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","I ja se vratih i siđoh s gore, a gora ognjem goraše, i dve ploče zavetne behu mi u rukama. ");
INSERT INTO srp1865_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","I pogledah, a to zgrešiste Gospodu Bogu svom salivši sebi tele, i brzo siđoste s puta koji vam beše zapovedio Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Tada uzeh one dve ploče i bacih ih iz ruku svojih, i razbih ih pred vama. ");
INSERT INTO srp1865_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Potom padoh i ležah pred Gospodom kao pre, četrdeset dana i četrdeset noći, hleba ne jedući ni vode pijući, radi svih greha vaših, kojima se ogrešiste učinivši što je zlo pred Gospodom i razgnevivši Ga. ");
INSERT INTO srp1865_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Jer se bojah gneva i jarosti, kojom se beše Gospod razljutio na vas da vas istrebi; i usliši me Gospod i tada. ");
INSERT INTO srp1865_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Beše se Gospod i na Arona razgnevio veoma da ga htede ubiti; ali se molih tada i za Arona. ");
INSERT INTO srp1865_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","I uzeh greh vaš koji učiniste, tele, i sažegoh ga ognjem, i razbih ga i satrh ga u prah, i prosuh prah njegov u potok, koji teče s one gore. ");
INSERT INTO srp1865_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","I u Taveri i u Masi i u Kivrot-Atavi gneviste Gospoda. ");
INSERT INTO srp1865_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","I kad vas posla Gospod u Kadis-Varniju govoreći: Idite i uzmite tu zemlju koju sam vam dao, opet se suprotiste reči Gospoda Boga svog, i ne verovaste Mu i ne poslušaste glas Njegov. ");
INSERT INTO srp1865_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Nepokorni bejaste Gospodu od kad vas poznah. ");
INSERT INTO srp1865_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Zato padoh i ležah pred Gospodom četrdeset dana i četrdeset noći, jer beše rekao Gospod da će vas potrti. ");
INSERT INTO srp1865_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","I molih se Gospodu i rekoh: Gospode, Gospode! Nemoj potrti narod svoj i nasledstvo svoje, koje si izbavio veličanstvom svojim, koje si izveo iz Misira krepkom rukom. ");
INSERT INTO srp1865_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Opomeni se sluga svojih Avrama, Isaka i Jakova, ne gledaj na tvrđu naroda ovog, na nevaljalstvo njegovo i na grehe njegove; ");
INSERT INTO srp1865_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","da ne kažu koji žive u zemlji odakle si nas izveo: Nije ih mogao Gospod uvesti u zemlju koju im obeća, ili mrzeo je na njih, zato ih izvede da ih pobije u pustinji. ");
INSERT INTO srp1865_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Jer su Tvoj narod i Tvoje nasledstvo, koje si izveo silom svojom velikom i mišicom svojom podignutom. ");
INSERT INTO srp1865_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","U to vreme reče mi Gospod: Isteši dve poče od kamena kao što behu prve, i iziđi k meni na goru, i načini kovčeg od drveta. ");
INSERT INTO srp1865_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","I napisaću na tim pločama reči koje su bile na prvim pločama što si ih razbio, pa ćeš ih metnuti u kovčeg. ");
INSERT INTO srp1865_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Tako načinih kovčeg od drveta sitima, i istesah dve ploče od kamena, kao što behu prve, i iziđoh na goru s dvema pločama u rukama. ");
INSERT INTO srp1865_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","I napisa na tim pločama šta beše prvo napisao, deset reči, koje vam izgovori Gospod na gori isred ognja na dan zbora vašeg; i dade mi ih Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","I vrativši se siđoh s gore, i metnuh ploče u kovčeg koji načinih, i ostaše onde, kao što mi zapovedi Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","A sinovi Izrailjevi pođoše od Virota, sinova Jakanovih u Moseru. Onde umre Aron i onde bi pogreben; a Eleazar, sin njegov posta sveštenik na njegovo mesto. ");
INSERT INTO srp1865_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Odande otidoše u Gadgad, a od Gadgada u Jotvatu, zemlju gde ima mnogo potoka. ");
INSERT INTO srp1865_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","U to vreme odvoji Gospod pleme Levijevo da nose kovčeg zaveta Gospodnjeg, da stoje pred Gospodom i služe mu i da blagosiljaju u ime Njegovo do današnjeg dana. ");
INSERT INTO srp1865_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Zato nema pleme Levijevo deo ni nasledstvo s braćom svojom; Gospod je nasledstvo njegovo, kao što mu Gospod Bog tvoj kaza. ");
INSERT INTO srp1865_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","A ja stajah na gori kao pre, četrdeset dana i četrdeset noći; i usliši me Gospod i tada, i ne hte te Gospod zatrti, ");
INSERT INTO srp1865_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","nego mi reče Gospod: Ustani i idi pred narodom ovim da uđu u zemlju za koju sam se zakleo ocima njihovim da ću im je dati da je naslede. ");
INSERT INTO srp1865_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Sada, dakle, Izrailju, šta ište od tebe Gospod Bog tvoj, osim da se bojiš Gospoda Boga svog, da hodiš po svim putevima Njegovim i da Ga ljubiš i služiš Gospodu Bogu svom iz sveg srca svog i iz sve duše svoje, ");
INSERT INTO srp1865_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","držeći zapovesti Gospodnje i uredbe Njegove, koje ti ja danas zapovedam, da bi ti bilo dobro? ");
INSERT INTO srp1865_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Gle, Gospoda je Boga tvog nebo, i nebo nad nebesima, zemlja, i sve što je na njoj. ");
INSERT INTO srp1865_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Ali samo tvoji oci omileše Gospodu, i izabra seme njihovo nakon njih, vas između svih naroda, kao što se vidi danas. ");
INSERT INTO srp1865_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Zato obrežite srce svoje, i nemojte više biti tvrdovrati. ");
INSERT INTO srp1865_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Jer je Gospod Bog vaš Bog nad bogovima i Gospodar nad gospodarima, Bog veliki, silni i strašni, koji ne gleda ko je ko niti prima poklona; ");
INSERT INTO srp1865_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","daje pravicu siroti i udovici; i ljubi došljaka dajući mu hleb i odelo. ");
INSERT INTO srp1865_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Ljubite dakle došljaka, jer ste bili došljaci u zemlji misirskoj. ");
INSERT INTO srp1865_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Boj se Gospoda Boga svog, Njemu služi i Njega se drži, i Njegovim se imenom kuni. ");
INSERT INTO srp1865_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","On je hvala tvoja i On je Bog tvoj, koji tebe radi učini velike i strašne stvari, koje videše oči tvoje. ");
INSERT INTO srp1865_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Sedamdeset duša beše otaca tvojih kad siđoše u Misir; a sada učini ti Gospod Bog tvoj te vas ima mnogo kao zvezda nebeskih. ");
INSERT INTO srp1865_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Ljubi, dakle, Gospoda Boga svog, i izvršuj jednako šta je zapovedio da izvršuješ, i uredbe Njegove, i zakone Njegove i zapovesti Njegove. ");
INSERT INTO srp1865_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","I poznajte danas šta vaši sinovi ne znaju niti videše, karanje Gospoda Boga svog, veličanstvo Njegovo, krepku ruku Njegovu i mišicu Njegovu podignutu, ");
INSERT INTO srp1865_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","i znake Njegove i dela Njegova, šta učini usred Misira na Faraonu, caru misirskom i na svoj zemlji njegovoj, ");
INSERT INTO srp1865_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","i šta učini vojsci misirskoj, konjima i kolima njihovim, kako učini, te ih voda crvenog mora potopi kad vas terahu, i zatre ih Gospod do današnjeg dana, ");
INSERT INTO srp1865_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","i šta vama učini u pustinji dokle ne dođoste do ovog mesta, ");
INSERT INTO srp1865_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","i šta učini Datanu i Avironu, sinovima Elijava sina Ruvimovog, kako zemlja otvori usta svoja i proždre njih i porodice njihove i šatore njihove i sve blago njihovo što imahu, usred Izrailja. ");
INSERT INTO srp1865_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Jer vaše oči videše sva dela Gospodnja velika, koja učini. ");
INSERT INTO srp1865_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Zato držite sve zapovesti, koje vam ja danas zapovedam, da biste se ukrepili i nasledili zemlju, u koju idete da je nasledite; ");
INSERT INTO srp1865_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","i da bi vam se produžili dani u zemlji, za koju se zakle ocima vašim da će je dati njima i semenu njihovom, zemlju, u kojoj teče mleko i med. ");
INSERT INTO srp1865_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Jer zemlja u koju ideš da je naslediš nije kao zemlja misirska iz koje ste izišli, gde si sejao svoje seme i zalivao na svojim nogama kao vrt od zelja; ");
INSERT INTO srp1865_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","nego je zemlja u koju idete da je nasledite zemlja u kojoj su brda i doline, i natapa je dažd nebeski; ");
INSERT INTO srp1865_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","zemlja kojom se stara Gospod Bog tvoj i na koju su jednako obraćene oči Gospoda Boga tvog od početka godine do kraja. ");
INSERT INTO srp1865_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Zato ako dobro uzaslušate zapovesti, koje vam ja zapovedam danas, ljubeći Gospoda Boga svog i služeći mu svim srcem svojim i svom dušom svojom, ");
INSERT INTO srp1865_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","tada ću davati dažd zemlji vašoj na vreme, i rani i pozni i sabiraćeš žito svoje i vino svoje i ulje svoje; ");
INSERT INTO srp1865_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","i za stoku ću tvoju dati travu u polju tvom; i ješćeš i bićeš sit. ");
INSERT INTO srp1865_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Čuvajte se da se ne prevari srce vaše da se odmetne i služite tuđim bogovima i poklanjate im se; ");
INSERT INTO srp1865_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","da se ne bi razgnevio Gospod na vas i zatvorio nebo da ne bude dažda, i zemlja da ne da roda svog, te biste brzo izginuli u dobroj zemlji koju vam Gospod daje. ");
INSERT INTO srp1865_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Nego složite ove reči moje u srce svoje i dušu svoju, i vežite ih za znak sebi na ruku, i neka vam budu kao počeonik među očima vašim. ");
INSERT INTO srp1865_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","I učite sinove svoje govoreći o njima kad sediš u kući svojoj i kad ideš putem, i kad ležeš i kad ustaješ. ");
INSERT INTO srp1865_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","I napiši ih na dovratnicima doma svog i na vratima svojim, ");
INSERT INTO srp1865_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","da bi se umnožili dani vaši i dani sinova vaših po zemlji, za koju se zakleo Gospod ocima vašim da će im je dati, kao dani nebu nad zemljom. ");
INSERT INTO srp1865_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Jer ako dobro uzdržite sve ove zapovesti koje vam ja zapovedam da tvorite ljubeći Gospoda Boga svog, i hodeći svim putevima Njegovim i Njega se držeći, ");
INSERT INTO srp1865_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","tada će oterati Gospod sve ove narode ispred vas, i nasledićete narode veće i jače nego što ste sami. ");
INSERT INTO srp1865_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Svako mesto na koje stupi stopalo noge vaše, vaše će biti; od pustinje do Livana, i od reke, reke Efrata, do mora zapadnog biće međa vaša. ");
INSERT INTO srp1865_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Neće se niko održati pred vama; strah i trepet vaš pustiće Gospod Bog vaš na svu zemlju na koju stupite, kao što vam kaza. ");
INSERT INTO srp1865_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Gle, iznosim danas pred vas blagoslov i prokletstvo: ");
INSERT INTO srp1865_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Blagoslov, ako uzaslušate zapovesti Gospoda Boga svog, koje vam ja danas zapovedam; ");
INSERT INTO srp1865_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","a prokletstvo, ako ne uzaslušate zapovesti Gospoda Boga svog nego siđete s puta, koji vam ja danas zapovedam, te pođete za drugim bogovima, kojih ne poznajete. ");
INSERT INTO srp1865_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","I kad te uvede Gospod Bog tvoj u zemlju u koju ideš da je naslediš, tada izreci blagoslov onaj na gori Garizinu, a prokletstvo na gori Evalu. ");
INSERT INTO srp1865_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","One su s one strane Jordana, idući k zapadu, u zemlji Hananeja koji žive u ravni prema Galgalu kod ravnice moreške. ");
INSERT INTO srp1865_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Jer ćete preći preko Jordana da uđete u zemlju koju vam daje Gospod Bog vaš da je nasledite, i nasledićete je i nastavaćete u njoj. ");
INSERT INTO srp1865_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Gledajte, dakle, da tvorite sve ove uredbe i zakone koje ja danas iznosim pred vas. ");
INSERT INTO srp1865_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Ovo su uredbe i zakoni koje ćete držati i tvoriti u zemlji koju ti je Gospod Bog otaca tvojih dao da je naslediš, dokle ste god živi na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Raskopajte sasvim sva mesta u kojima su služili bogovima svojim narodi koje ćete naslediti, po visokim brdima i po humovima i pod svakim zelenim drvetom. ");
INSERT INTO srp1865_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Oborite oltare njihove i razbijte likove njihove, i lugove njihove popalite ognjem, i rezane bogove njihove izlomite, i istrebite ime njihovo sa onog mesta. ");
INSERT INTO srp1865_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Ne činite tako Gospodu Bogu svom. ");
INSERT INTO srp1865_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Nego Ga tražite u mestu koje izabere Gospod Bog vaš između svih plemena vaših sebi za stan da onde namesti ime svoje, i onamo idite. ");
INSERT INTO srp1865_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Onamo nosite žrtve svoje paljenice i druge žrtve svoje i desetke svoje i prinose ruku svojih i zavete svoje i dragovoljne prinose svoje i prvine stoke svoje krupne i sitne. ");
INSERT INTO srp1865_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","I jedite onde pred Gospodom Bogom svojim, i veselite se vi i porodice vaše svačim, za šta se prihvatite rukom svojom, čim te blagoslovi Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Ne činite kako mi sada ovde činimo, šta je kome drago. ");
INSERT INTO srp1865_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Jer još niste došli do odmora i nasledstva, koje ti daje Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Nego kad pređete preko Jordana, i stanete živeti u zemlji koju vam daje Gospod Bog vaš da je nasledite, i smiri vas od svih neprijatelja vaših unaokolo, te stanete živeti bez straha, ");
INSERT INTO srp1865_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","onda u mesto koje izabere Gospod Bog vaš da u njemu nastani ime svoje, donesite sve što vam ja zapovedam, žrtve svoje paljenice i druge žrtve svoje, desetke svoje i prinose ruku svojih i sve što bude najbolje u onome što zavetujete Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","I veselite se pred Gospodom Bogom svojim vi i sinovi vaši i kćeri vaše i sluge vaše i sluškinje vaše, i Levit koji je u mestu vašem, jer on nema deo ni nasledstvo s vama. ");
INSERT INTO srp1865_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Čuvaj se da ne prinosiš žrtava svojih paljenica na kome god mestu, koje ugledaš; ");
INSERT INTO srp1865_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","nego na onom mestu koje izabere Gospod Bog u jednom od tvojih plemena, onde prinosi žrtve svoje paljenice, i onde čini sve što ti zapovedam. ");
INSERT INTO srp1865_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Ali ćeš moći klati i jesti meso kako ti duša zaželi u svakom mestu svom po blagoslovu Gospoda Boga svog, koji ti da; čist i nečist može jesti kao srnu i jelena. ");
INSERT INTO srp1865_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Samo krv ne jedite; prolijte je na zemlju kao vodu. ");
INSERT INTO srp1865_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Nećeš moći jesti u mestu svom desetka od žita svog ni od vina svog ni od ulja svog, ni prvina od stoke svoje krupne i sitne, ni onog što zavetuješ; ni prinosa dragovoljnih, ni prinosa ruku svojih. ");
INSERT INTO srp1865_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Nego to jedi pred Gospodom Bogom svojim na mestu koje izabere Gospod Bog tvoj, ti, sin tvoj i kći tvoja i sluga tvoj i sluškinja tvoja, i Levit koji je u mestu tvom; i veseli se pred Gospodom Bogom svojim svačim za šta se prihvatiš rukom. ");
INSERT INTO srp1865_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Čuvaj se da ne ostaviš Levita dok si god živ na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Kad raširi Gospod Bog tvoj međe tvoje, kao što ti je kazao, ako kažeš: Da jedem mesa, kad duša tvoja želi da jede mesa, jedi mesa po svoj želji duše svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Ako bi bilo daleko od tebe mesto koje Gospod Bog tvoj izabere da onde namesti ime svoje, zakolji od stoke svoje krupne ili sitne, koju ti da Gospod, kao što sam ti zapovedio, i jedi u svom mestu po želji duše svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Kako se jede srna i jelen, onako jedi; i čist i nečist neka jede. ");
INSERT INTO srp1865_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Samo pazi da ne jedeš krv; jer je krv duša, pa ne jedi dušu s mesom. ");
INSERT INTO srp1865_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Ne jedi je; nego prolij na zemlju kao vodu. ");
INSERT INTO srp1865_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Ne jedi je, da bi dobro bilo tebi i sinovima tvojim nakon tebe, kad činiš ono što je ugodno Gospodu. ");
INSERT INTO srp1865_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Ali stvari svoje svete, koje imaš, i što zavetuješ, uzmi i dođi na mesto koje izabere Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","I prinesi žrtve svoje paljenice, meso i krv, na oltaru Gospoda Boga svog; krv pak od drugih žrtava tvojih neka se prolije na oltar Gospoda Boga tvog, a meso jedi. ");
INSERT INTO srp1865_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Čuvaj i slušaj sve ove reči koje ti ja zapovedam, da bi dobro bilo tebi i sinovima tvojim nakon tebe doveka kad činiš šta je dobro i pravo pred Gospodom Bogom tvojim. ");
INSERT INTO srp1865_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Kad istrebi Gospod Bog tvoj ispred tebe narode ka kojima ideš da naslediš zemlju njihovu, i nasledivši je kad se nastaniš u zemlji njihovoj, ");
INSERT INTO srp1865_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","čuvaj se da se ne uhvatiš u zamku pošavši za njima pošto se potru ispred tebe, i da ne potražiš bogove njihove, i kažeš: Kako su ovi narodi služili svojim bogovima, tako ću i ja činiti. ");
INSERT INTO srp1865_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Ne čini tako Gospodu Bogu svom; jer oni činiše svojim bogovima sve što je gadno pred Gospodom i na šta On mrzi; jer su i sinove svoje i kćeri svoje sažizali bogovima svojim. ");
INSERT INTO srp1865_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Šta vam god ja zapovedam sve držite i tvorite, niti šta dodajte k tome ni oduzmite od toga. ");
INSERT INTO srp1865_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Ako ustane među vama prorok ili koji sne sanja, i kaže ti znak ili čudo, ");
INSERT INTO srp1865_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","pa se zbude taj znak ili čudo koje ti reče, i on ti kaže: Hajde da idemo za drugim bogovima kojih ne znaš, i njima da služimo, ");
INSERT INTO srp1865_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","nemoj poslušati šta ti kaže taj prorok ili sanjač, jer vas kuša Gospod Bog vaš da bi se znalo ljubite li Gospoda Boga svog iz sveg srca svog i sve duše svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Za Gospodom Bogom svojim idite, i Njega se bojte; Njegove zapovesti čuvajte, i glas Njegov slušajte, i Njemu služite i Njega se držite. ");
INSERT INTO srp1865_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","A onaj prorok ili sanjač da se pogubi, jer vas je nagovarao da se odmetnete Gospoda Boga svog, koji vas izvede iz zemlje misirske i iskupi vas iz kuće ropske, i odvraćao od puta koji ti je zapovedio Gospod Bog tvoj da ideš njim; tako istrebi zlo iz sebe. ");
INSERT INTO srp1865_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Ako bi te podbadao brat tvoj, sin matere tvoje, ili sin tvoj ili kći tvoja, ili žena tvoja mila, ili prijatelj tvoj koji ti je kao duša tvoja, govoreći ti tajno: Hajde da služimo drugim bogovima, koje nisi znao ni ti ni oci tvoji, ");
INSERT INTO srp1865_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","između bogova drugih naroda koji su oko vas, blizu ili daleko od tebe, od jednog kraja zemlje do drugog, ");
INSERT INTO srp1865_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","ne pristaj s njim niti ga poslušaj; neka ga ne žali oko tvoje, i nemoj mu se smilovati niti ga taji, ");
INSERT INTO srp1865_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","nego ga ubij: tvoja ruka nek se prva digne na nj da ga ubiješ, pa onda ruka svega naroda. ");
INSERT INTO srp1865_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Zaspi ga kamenjem da pogine; jer te htede odvratiti od Gospoda Boga tvog, koji te je izveo iz zemlje misirske, iz kuće ropske; ");
INSERT INTO srp1865_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","da sav Izrailj čuje i boji se, i da se više ne učini tako zlo među vama. ");
INSERT INTO srp1865_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Ako za kakav grad svoj, koji ti Gospod Bog tvoj da da u njemu živiš, čuješ gde govore: ");
INSERT INTO srp1865_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","Iziđoše ljudi nevaljali između tebe i otpadiše sve koji žive u gradu njihovom, govoreći: Hajde da služimo drugim bogovima, kojih ne poznajete, ");
INSERT INTO srp1865_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","tada traži i raspitaj, izvidi dobro, pa ako bude istina i doista se učinila ona gadna stvar među vama, ");
INSERT INTO srp1865_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","pobij mačem sve koji žive u gradu onom, i zatri i njega i sve što bi u njemu bilo, i stoku mačem pobij. ");
INSERT INTO srp1865_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","I sav plen iz njega skupi nasred ulice njegove, spali ognjem i onaj grad i sav plen iz njega Gospodu Bogu svom, da bude gomila doveka i da se više ne sazida. ");
INSERT INTO srp1865_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","I neka ti od prokletih stvari ne prione ništa za ruku, eda bi se Gospod povratio od žestine gneva svog, učinio ti milost i smilovao se na te, i umnožio te, kao što se zakleo ocima tvojim, ");
INSERT INTO srp1865_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","kad slušaš glas Gospoda Boga svog držeći sve zapovesti Njegove, koje ti ja danas zapovedam, da bi činio šta je pravo pred Gospodom Bogom tvojim. ");
INSERT INTO srp1865_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Vi ste sinovi Gospoda Boga svog; nemojte se rezati niti brijati među očima za mrtvacem. ");
INSERT INTO srp1865_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Jer si narod svet Gospodu Bogu svom, i tebe izabra Gospod da si mu narod osobit između svih naroda na zemlji. ");
INSERT INTO srp1865_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Ne jedi ništa gadno. ");
INSERT INTO srp1865_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Ovo su životinje koje ćete jesti: goveče, ovcu, kozu, ");
INSERT INTO srp1865_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","jelena, srnu, bivola, divokozu, jednoroga i kozu kamenjaču; ");
INSERT INTO srp1865_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","i sve životinje koje imaju papke rascepljene na dvoje, i koje preživaju između životinja, njih jedite. ");
INSERT INTO srp1865_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Ali ne jedite one koje samo preživaju ili koje samo imaju papke rascepljene na dvoje, kao: kamilu, zeca, pitomog zeca, jer preživaju, a nemaju papke razdvojene; da vam je nečisto; ");
INSERT INTO srp1865_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","ni svinjče, jer ima razdvojene papke, ali ne preživa; da vam je nečisto; meso od njega ne jedite, i strva se njegovog ne dohvatajte. ");
INSERT INTO srp1865_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","A između onih što su u vodi, jedite ove: šta god ima pera i ljuske, jedite; ");
INSERT INTO srp1865_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","a što nema pera i ljuske, ne jedite; da vam je nečisto. ");
INSERT INTO srp1865_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Sve ptice čiste jedite; ");
INSERT INTO srp1865_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","a ove ne jedite: orla, ni jastreba, ni morskog orla, ");
INSERT INTO srp1865_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ni sokola, ni eju, ni kraguja po vrstama njihovim, ");
INSERT INTO srp1865_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","ni gavrana po vrstama njegovim, ");
INSERT INTO srp1865_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ni ćuka, ni sovuljagu, ni lisku, ni kopca po vrstama njegovim, ");
INSERT INTO srp1865_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ni buljinu, ni ražnja, ni labuda, ");
INSERT INTO srp1865_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","ni gema, ni svraku, ni gnjurca, ");
INSERT INTO srp1865_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ni rodu, ni čaplju po vrstama njenim, ni pupavca, ni ljiljka. ");
INSERT INTO srp1865_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","I sve bubine krilate da su vam nečiste; ne jedite ih. ");
INSERT INTO srp1865_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","I sve ptice čiste jedite. ");
INSERT INTO srp1865_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Ništa mrcino ne jedite; došljaku koji je kod tebe podaj neka jede, ili prodaj tuđinu; jer si narod svet Gospodu Bogu svom. Ne kuvaj jare u mleku matere njegove. ");
INSERT INTO srp1865_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Desetak daj od svega roda useva svog, što dođe s njive tvoje svake godine. ");
INSERT INTO srp1865_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","I jedi pred Gospodom Bogom svojim na mestu koje izabere da onde nastani ime svoje, desetak od žita svog, od vina svog i ulja svog, i prvine stoke svoje krupne i sitne, da se učiš bojati se Gospoda Boga svog svagda. ");
INSERT INTO srp1865_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Ako bi ti put bio dalek, te ne bi mogao odneti zato što je daleko od tebe mesto, koje izabere Gospod Bog tvoj da onde namesti ime svoje, kad te Gospod Bog tvoj blagoslovi, ");
INSERT INTO srp1865_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","onda učini u novac, i uzevši u ruku svoju otidi u mesto koje izabere Gospod Bog tvoj, ");
INSERT INTO srp1865_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","i za te novce uzmi šta zaželi duša tvoja, goveda, ovaca, vina ili drugog jakog pića, i šta god bi zaželela duša tvoja, pa jedi onde pred Gospodom Bogom svojim, i veseli se ti i dom tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Ali Levita koji bi bio u mestu tvom, nemoj ostaviti jer nema deo ni nasledstvo s tobom. ");
INSERT INTO srp1865_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Svake treće godine odvoj sav desetak od dohodaka svojih one godine, i ostavi ga u svom mestu. ");
INSERT INTO srp1865_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Pa neka dođu Leviti (jer nemaju deo ni nasledstvo s tobom) i došljaci i sirote i udovice što su u mestu tvom, i neka jedu i nasite se, da bi te blagoslovio Gospod Bog tvoj u svakom poslu ruku tvojih, koji bi radio. ");
INSERT INTO srp1865_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Svake sedme godine opraštaj. ");
INSERT INTO srp1865_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","A opraštanje da biva ovako: kome je ko dužan šta, neka oprosti šta bi mogao tražiti od bližnjeg svog; neka ne traži od bližnjeg svog i od brata svog, jer je opraštanje Gospodnje oglašeno. ");
INSERT INTO srp1865_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Od tuđina traži, ali šta bi imao u brata svog, ono neka mu oprosti ruka tvoja, ");
INSERT INTO srp1865_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","da ne bi bilo siromaha među vama, jer će te obilno blagosloviti Gospod u zemlji koju ti Gospod Bog tvoj da u nasledstvo da je tvoja. ");
INSERT INTO srp1865_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","Samo ako dobro uzaslušaš glas Gospoda Boga svog gledajući da činiš sve ove zapovesti, koje ti ja zapovedam danas, ");
INSERT INTO srp1865_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","blagosloviće te Gospod Bog tvoj, kao što ti je kazao, te ćeš davati u zajam mnogim narodima, a ni od koga nećeš uzimati u zajam, i vladaćeš mnogim narodima, a oni tobom neće vladati. ");
INSERT INTO srp1865_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Ako bude u tebe koji siromah između braće tvoje u kome mestu tvom, u zemlji tvojoj, koju ti daje Gospod Bog tvoj, nemoj da ti se stvrdne srce tvoje i da stisneš ruku svoju bratu svom siromahu. ");
INSERT INTO srp1865_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Nego otvori ruku svoju i pozajmi mu rado koliko mu god treba u potrebi njegovoj. ");
INSERT INTO srp1865_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Čuvaj se da ne bude kakvo nevaljalstvo u srcu tvom, pa da kažeš: Blizu je sedma godina, godina oprosna; i da oko tvoje ne bude zlo prema bratu tvom siromahu, pa da mu ne daš, a on zato da vapije ka Gospodu na te, i bude ti greh. ");
INSERT INTO srp1865_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Podaj mu, i neka ne žali srce tvoje kad mu daš; jer će za tu stvar blagosloviti tebe Gospod Bog tvoj u svakom poslu tvom i u svemu za šta se prihvatiš rukom svojom. ");
INSERT INTO srp1865_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Jer neće biti bez siromaha u zemlji; zato ti zapovedam i kažem: otvaraj ruku svoju bratu svom, nevoljniku i siromahu svom u zemlji svojoj. ");
INSERT INTO srp1865_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Ako ti se proda brat tvoj Jevrejin ili Jevrejka, neka ti služi šest godina, a sedme godine otpusti ga od sebe slobodnog. ");
INSERT INTO srp1865_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","A kad ga otpustiš od sebe slobodnog, nemoj ga otpustiti praznog. ");
INSERT INTO srp1865_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Daruj ga čim između stoke svoje i s gumna svog i iz kace svoje; podaj mu čim te je blagoslovio Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","I opominji se da si bio rob u zemlji misirskoj i da te je izbavio Gospod Bog tvoj; zato ti ja zapovedam ovo danas. ");
INSERT INTO srp1865_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Ako li ti kaže: Neću da idem od tebe, zato što te ljubi i dom tvoj, jer mu je dobro kod tebe, ");
INSERT INTO srp1865_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","tada uzmi šilo i probuši mu uho na vratima, i biće ti sluga doveka; i sluškinji svojoj učini tako. ");
INSERT INTO srp1865_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Nemoj da ti bude teško kad ga otpuštaš od sebe slobodna, jer je dvojinom onoliko koliko najamnik zaslužio u tebe za šest godina, da bi te blagoslovio Gospod Bog tvoj u svemu što radiš. ");
INSERT INTO srp1865_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Sve prvence u stoci svojoj krupnoj i sitnoj što bude muško, posveti Gospodu Bogu svom; ne radi na prvencu od krave svoje, i ne striži prvenca od ovaca svojih. ");
INSERT INTO srp1865_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Pred Gospodom Bogom svojim jedi ih ti i porodica tvoja svake godine na mestu koje izabere Gospod. ");
INSERT INTO srp1865_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Ako li na njemu bude mana, ako bude hromo ili slepo, ili koja god zla mana bude na njemu, ne kolji ga Gospodu Bogu svom. ");
INSERT INTO srp1865_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","U svom mestu pojedi ga; i čist i nečist neka jede kao srnu i jelena. ");
INSERT INTO srp1865_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Samo krv od njega ne jedi; prolij je na zemlju kao vodu. ");
INSERT INTO srp1865_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Drži mesec Aviv, te slavi pashu Gospodu Bogu svom, jer meseca Aviva izveo te je Gospod Bog tvoj iz Misira noću. ");
INSERT INTO srp1865_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","I zakolji pashu Gospodu Bogu svom, od krupne i sitne stoke, na mestu koje izabere Gospod da onde nastani ime svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Ne jedi s njom hleb kiseli; sedam dana jedi s njom presan hleb, hleb nevoljnički, jer si hiteći izašao iz zemlje misirske, pa da se opominješ dana kad si izašao iz Misira, dok si god živ. ");
INSERT INTO srp1865_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","I da se ne vidi u tebe kvasac za sedam dana nigde među granicama tvojim, i da ne ostane preko noć ništa do jutra od mesa koje zakolješ prvi dan uveče. ");
INSERT INTO srp1865_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Ne možeš klati pashe na svakom mestu svom koje ti da Gospod Bog tvoj; ");
INSERT INTO srp1865_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","nego na mestu koje izabere Gospod Bog tvoj da onde nastani ime svoje, onde kolji pashu uveče o sunčanom zahodu u isto vreme kad si pošao iz Misira. ");
INSERT INTO srp1865_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","A peci je i jedi na mestu koje izabere Gospod Bog tvoj; i sutradan vrativši se idi u svoje šatore. ");
INSERT INTO srp1865_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Šest dana jedi presne hlebove, a sedmi dan da je praznik Gospodnji, tada ne radi ništa. ");
INSERT INTO srp1865_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Sedam nedelja nabroj; kad stane srp raditi po letini, onda počni brojati sedam nedelja. ");
INSERT INTO srp1865_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Tada praznuj praznik nedelja Gospodu Bogu svom; šta možeš prinositi dragovoljno kako te bude blagoslovio Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","I veseli se pred Gospodom Bogom svojim ti i sin tvoj i kći tvoja i sluga tvoj i sluškinja tvoja, i Levit koji bude u mestu tvom, i došljak i sirota i udovica, što budu kod tebe, na mestu koje izabere Gospod Bog tvoj da onde nastani ime svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","I opominji se da si bio rob u Misiru, te čuvaj i tvori uredbe ove. ");
INSERT INTO srp1865_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Praznik senica praznuj sedam dana, kad zbereš s gumna svog i iz kace svoje. ");
INSERT INTO srp1865_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","I veseli se na praznik svoj ti i sin tvoj i sluga tvoj i sluškinja tvoja, i Levit i došljak i sirota i udovica, što budu u mestu tvom. ");
INSERT INTO srp1865_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Sedam dana praznuj praznik Gospodu Bogu svom na mestu koje izabere Gospod, kad te blagoslovi Gospod Bog tvoj u svakoj letini tvojoj i u svakom poslu ruku tvojih; i budi veseo. ");
INSERT INTO srp1865_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Tri puta u godini neka dođe svako muško pred Gospoda Boga tvog na mesto koje izabere: na praznik presnih hlebova, na praznik nedelja i na praznik senica, ali niko da ne dođe prazan pred Gospoda; ");
INSERT INTO srp1865_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","nego svaki s darom od onog što ima, prema blagoslovu Gospoda Boga tvog kojim te je darivao. ");
INSERT INTO srp1865_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Sudije i upravitelje postavi sebi po svim mestima koja ti da Gospod Bog tvoj po plemenima tvojim, i neka sude narodu pravo. ");
INSERT INTO srp1865_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Ne izvrći pravde i ne gledaj ko je ko; ne primaj poklona, jer poklon zaslepljuje oči mudrima i izvrće reči pravednima. ");
INSERT INTO srp1865_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Sasvim idi za pravdom, da bi bio živ i nasledio zemlju koju ti daje Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Ne sadi luga ni od kakvih drveta kod oltara Gospoda Boga svog, koji načiniš; ");
INSERT INTO srp1865_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","i ne podiži nikakav lik; na to mrzi Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Ne prinosi Gospodu Bogu svom ni vola ni jagnjeta ni jareta na kome ima mana ili kako god zlo; jer je gadno pred Gospodom Bogom tvojim. ");
INSERT INTO srp1865_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Ako se nađe kod tebe u kome od mesta tvojih, koja ti da Gospod Bog tvoj, čovek ili žena da učini zlo pred Gospodom Bogom tvojim prestupajući zavet Njegov, ");
INSERT INTO srp1865_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","i otide te služi drugim bogovima i klanja im se, ili suncu ili mesecu ili čemu god iz vojske nebeske, što nisam zapovedio, ");
INSERT INTO srp1865_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","i tebi se to javi i ti čuješ, onda raspitaj dobro; pa ako bude istina i doista se učinila ona gadna stvar u Izrailju, ");
INSERT INTO srp1865_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","izvedi onog čoveka ili onu ženu, koji učiniše ono zlo, na vrata svoja, čoveka onog ili ženu, i zaspi ih kamenjem da poginu. ");
INSERT INTO srp1865_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Na svedočanstvo dva ili tri čoveka da se pogubi onaj koga valja pogubiti; ali na svedočanstvo jednog čoveka da se ne pogubi. ");
INSERT INTO srp1865_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Svedoci neka prvi dignu ruke na nj da ga ubiju; a potom sav narod; tako izvadi zlo iz sebe. ");
INSERT INTO srp1865_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Kad ti bude teško rasuditi između krvi i krvi, između raspre i raspre, ili između rane i rane, oko kojih bude parnica u tvom mestu, tada ustani i idi u mesto koje izabere Gospod Bog tvoj; ");
INSERT INTO srp1865_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","i otidi k sveštenicima Levitima ili k sudiji koji onda bude, pa ih upitaj, i oni će ti kazati kako valja presuditi. ");
INSERT INTO srp1865_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","I učini onako kako ti kažu u mestu koje izabere Gospod, i gledaj da učiniš sasvim onako kako te nauče. ");
INSERT INTO srp1865_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Po zakonu kome te nauče, i po presudi, koju ti kažu, učini; ne odstupi od onog što ti kažu ni nadesno ni nalevo. ");
INSERT INTO srp1865_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Ako li bi se ko upro te ne bi hteo poslušati sveštenika koji onde stoji te služi Gospodu Bogu tvom, ili sudije, takav čovek da se pogubi; i izvadi zlo iz Izrailja, ");
INSERT INTO srp1865_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","da sav narod čuje i boji se, i unapred, da ne radi uporno. ");
INSERT INTO srp1865_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Kad uđeš u zemlju koju ti daje Gospod Bog tvoj da je naslediš, i naseliš se u njoj, ako kažeš: Da postavim sebi cara, kao što imaju svi narodi oko mene, ");
INSERT INTO srp1865_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","samo onog postavi sebi za cara, kog izabere Gospod Bog tvoj; između braće svoje postavi cara sebi; a nemoj postaviti nad sobom čoveka tuđina, koji nije brat tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Ali da ne drži mnogo konja, i da ne vraća narod u Misir da bi imao mnogo konja, jer vam je Gospod kazao: Ne vraćajte se više ovim putem. ");
INSERT INTO srp1865_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","I da nema mnogo žena, da se ne bi otpadilo srce njegovo, ni srebra ni zlata da nema vrlo mnogo. ");
INSERT INTO srp1865_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","A kad sede na presto carstva svog, neka prepiše sebi u knjigu ovaj zakon od sveštenika Levita; ");
INSERT INTO srp1865_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","i neka ga drži kod sebe i neka ga čita dok je živ, da se uči bojati se Gospoda Boga svog, držati sve reči ovog zakona i ove uredbe, i tvoriti ih; ");
INSERT INTO srp1865_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","da se ne bi podiglo srce njegovo iznad braće njegove, i da ne bi odstupilo od ove zapovesti ni nadesno ni nalevo, da bi dugo carovao on i sinovi njegovi u Izrailju. ");
INSERT INTO srp1865_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Sveštenici, Leviti i sve pleme Levijevo da nemaju deo ni nasledstvo s ostalim sinovima Izrailjevim; neka jedu ognjene žrtve Gospodnje i njegovo nasledstvo. ");
INSERT INTO srp1865_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Nasledstvo, dakle, da nemaju među braćom svojom: Gospod je nasledstvo njihovo, kao što im je kazao. ");
INSERT INTO srp1865_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","Ali ovo pripada sveštenicima od naroda, od onih koji prinesu žrtvu, bilo vola ili jagnje: da se daje svešteniku pleće i obe vilice i želudac. ");
INSERT INTO srp1865_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Prvine od žita svog, od vina svog i od ulja svog, i prvine od vune s ovaca svojih podaj mu. ");
INSERT INTO srp1865_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Jer njega izabra Gospod Bog tvoj između svih plemena tvojih da stoji i služi u ime Gospodnje on i sinovi njegovi doveka. ");
INSERT INTO srp1865_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","I kad dođe koji Levit iz kog god mesta tvog iz svega Izrailja, gde nastava, kad dođe po želji duše svoje u mesto koje izabere Gospod, ");
INSERT INTO srp1865_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","neka služi u ime Gospoda Boga svog kao i druga braća, njegova Leviti, koji onde stoje pred Gospodom. ");
INSERT INTO srp1865_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Neka jedu jednak deo, osim onog što bi koje prodao u porodici otaca svojih. ");
INSERT INTO srp1865_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Kad uđeš u zemlju koju ti Gospod Bog tvoj daje, ne uči se činiti gadna dela onih naroda. ");
INSERT INTO srp1865_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Neka se ne nađe u tebe koji bi vodio sina svog ili kćer svoju kroz oganj, ni vračar, ni koji gata po zvezdama, ni koji gata po pticama, ni uročnik, ");
INSERT INTO srp1865_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ni bajač, ni koji se dogovara sa zlim duhovima, ni opsenar ni koji pita mrtve. ");
INSERT INTO srp1865_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Jer je gad pred Gospodom ko god tako čini, i za takve gadove tera te narode Gospod Bog tvoj ispred tebe. ");
INSERT INTO srp1865_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Drži se sasvim Gospoda Boga svog. ");
INSERT INTO srp1865_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Jer ti narodi koje ćeš naslediti, slušaju gatare i vračare; a tebi to ne dopušta Gospod Bog tvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Proroka isred tebe, između braće tvoje, kao što sam ja, podignuće ti Gospod Bog tvoj; njega slušajte, ");
INSERT INTO srp1865_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","po svemu što si iskao od Gospoda Boga svog na Horivu na dan sabora svog govoreći: Da više ne čujem glas Gospoda Boga svog i da više ne gledam oganj taj veliki, da ne poginem. ");
INSERT INTO srp1865_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Zato mi reče Gospod: Dobro rekoše šta rekoše. ");
INSERT INTO srp1865_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Proroka ću im podignuti između braće njihove, kao što si ti, i metnuću reči svoje u usta njegova, i kazivaće im sve što mu zapovedim. ");
INSERT INTO srp1865_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","A ko god ne bi poslušao reči moje, koje će govoriti u moje ime, od toga ću ja tražiti. ");
INSERT INTO srp1865_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Ali prorok koji bi se usudio govoriti šta u moje ime što mu ja ne zapovedim da govori, ili koji bi govorio u ime drugih bogova, takav prorok da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Ako li kažeš u srcu svom: Kako ćemo poznati reč koje nije Gospod rekao? ");
INSERT INTO srp1865_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Šta bi prorok rekao u ime Gospodnje, pa se ne zbude i ne navrši se, to je reč koje nije rekao Gospod; nego je iz oholosti rekao onaj prorok, ne boj ga se. ");
INSERT INTO srp1865_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","Kad Gospod Bog tvoj potre narode kojih zemlju daje tebi Gospod Bog tvoj, i kad ih naslediš i nastaniš se po gradovima njihovim i po kućama njihovim, ");
INSERT INTO srp1865_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","odvoj tri grada usred zemlje svoje koju ti daje Gospod Bog tvoj da je naslediš, ");
INSERT INTO srp1865_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","načini put, i razdeli na troje krajeve zemlje svoje koju ti da Gospod Bog tvoj u nasledstvo, pa neka beži onamo svaki krvnik. ");
INSERT INTO srp1865_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","A ovako neka bude s krvnikom koji uteče onamo, da bi ostao živ: ko ubije bližnjeg svog nehotice, ne mrzevši pre na nj, ");
INSERT INTO srp1865_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","kao kad bi ko otišao s bližnjim svojim u šumu da seče drva, pa bi zamahnuo sekirom u ruci svojoj da poseče drvo, a ona bi spala s držalice i pogodila bi bližnjeg njegova tako da umre on neka uteče u koji od tih gradova da ostane živ, ");
INSERT INTO srp1865_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","da ne bi osvetnik poterao krvnika dok mu je srce raspaljeno i da ga ne bi stigao na dalekom putu i ubio ga, premda nije zaslužio smrt, jer nije pre mrzeo na nj. ");
INSERT INTO srp1865_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Zato ti zapovedam i velim: tri grada odvoj. ");
INSERT INTO srp1865_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","A kad raširi Gospod Bog tvoj međe tvoje kao što se zakleo ocima tvojim, i da ti svu zemlju koju je rekao dati ocima tvojim, ");
INSERT INTO srp1865_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","ako uzdržiš i ustvoriš sve ove zapovesti, koje ti ja danas zapovedam, da ljubiš Gospoda Boga svog i hodiš putevima Njegovim svagda, onda dodaj još tri grada osim ona tri, ");
INSERT INTO srp1865_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","da se ne proliva krv prava u zemlji tvojoj, koju ti Gospod Bog tvoj daje u nasledstvo, i da ne bude na tebi krv. ");
INSERT INTO srp1865_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","Ali ako ko mrzi na bližnjeg svog i vreba ga, i skoči na nj, i udari ga tako da umre, a on uteče u koji od tih gradova, ");
INSERT INTO srp1865_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","onda starešine mesta njegova neka pošalju i uzmu ga odande, i predadu ga u ruke osvetniku da se pogubi. ");
INSERT INTO srp1865_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","Neka ga ne žali oko tvoje nego skini krv pravu s Izrailja, da bi ti dobro bilo. ");
INSERT INTO srp1865_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","Ne pomiči međe bližnjeg svog koju postave stari u nasledstvu tvom koje dobiješ u zemlji koju ti Gospod Bog tvoj daje da je naslediš. ");
INSERT INTO srp1865_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Neka ne ustaje jedan svedok na čoveka ni za kako zlo i ni za kakav greh između svih greha koji se čine, nego na rečima dva ili tri svedoka da ostaje stvar. ");
INSERT INTO srp1865_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Ako bi ustao lažan svedok na koga da svedoči na njega da se odmeće Boga, ");
INSERT INTO srp1865_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","onda neka stanu ta dva čoveka, koji imaju tu raspru, pred Gospoda, pred sveštenike i pred sudije koje budu u to vreme; ");
INSERT INTO srp1865_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","i neka dobro ispitaju sudije, ako svedok onaj bude lažan svedok i lažno svedoči na brata svog, ");
INSERT INTO srp1865_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","učinite mu onako kako je on mislio učiniti bratu svom i izvadi zlo iz sebe, ");
INSERT INTO srp1865_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","da se ostali čuvši to boje, i unapred više ne čine tako zlo usred tebe. ");
INSERT INTO srp1865_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Neka ne žali oko tvoje: život za život, oko za oko, zub za zub, ruku za ruku, nogu za nogu. ");
INSERT INTO srp1865_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","Kad odeš na vojsku na neprijatelja svog i vidiš konje i kola i narod veći od sebe, nemoj se uplašiti od njih, jer je s tobom Gospod Bog tvoj, koji te je izveo iz zemlje misirske. ");
INSERT INTO srp1865_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","I kad pođete da se pobijete, neka pristupi sveštenik i progovori narodu, ");
INSERT INTO srp1865_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","i neka im kaže: Slušaj Izrailju! Vi polazite danas u boj na neprijatelje svoje, neka ne trne srce vaše, ne bojte se i ne plašite se, niti se prepadajte od njih. ");
INSERT INTO srp1865_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","Jer Gospod Bog vaš ide s vama i biće se za vas s neprijateljima vašim da vas sačuva. ");
INSERT INTO srp1865_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","Potom i vojvode neka progovore narodu, i kažu: Ko je sagradio novu kuću a nije počeo sedeti u njoj? Neka ide nek se vrati kući svojoj, da ne bi poginuo u boju, i drugi počeo sedeti u njoj. ");
INSERT INTO srp1865_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","I ko je posadio vinograd a još ga nije brao? Neka ide, nek se vrati kući svojoj, da ne bi poginuo u boju, i drugi ga brao. ");
INSERT INTO srp1865_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","I ko je isprosio devojku a još je nije odveo? Neka ide, nek se vrati kući svojoj, da ne bi poginuo u boju, i drugi je odveo. ");
INSERT INTO srp1865_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","Još i ovo neka kažu vojvode narodu: Ko je strašljiv i trne mu srce? Neka ide, nek se vrati kući svojoj, da ne bi trnulo srce braći njegovoj kao njemu. ");
INSERT INTO srp1865_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","I kad vojvode izgovore narodu, onda neka nameste glavare od četa pred narod. ");
INSERT INTO srp1865_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","Kad dođeš pod koji grad da ga biješ, prvo ga ponudi mirom. ");
INSERT INTO srp1865_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","Ako ti odgovori mirom i otvori ti vrata, sav narod koji se nađe u njemu neka ti plaća danak i bude ti pokoran. ");
INSERT INTO srp1865_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","Ako li ne učini mira s tobom nego se stane biti s tobom tada ga bij. ");
INSERT INTO srp1865_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","I kad ga Gospod Bog tvo