﻿USE sofia;
DROP TABLE IF EXISTS sofia.srnNT_vpl;
CREATE TABLE srnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES srnNT_vpl WRITE;
INSERT INTO srnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Disi na den afo fu Yesus Kristus. Yesus ben de wan bakapikin fu David, nanga fu Abraham. ");
INSERT INTO srnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ben de a p'pa fu Isak, Isak ben de a p'pa fu Yakob, èn Yakob ben de a p'pa fu Yuda nanga den brada fu en. ");
INSERT INTO srnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nanga Tamar Yuda kisi Peres nanga Sera. Peres ben de a p'pa fu Hesron, èn Hesron ben de a p'pa fu Aram. ");
INSERT INTO srnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ben de a p'pa fu Aminadab, Aminadab ben de a p'pa fu Nakson, èn Nakson ben de a p'pa fu Salmon. ");
INSERT INTO srnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nanga Rakab Salmon kisi Boas. Nanga Ruth Boas kisi Obed, èn Obed ben de a p'pa fu Isai. ");
INSERT INTO srnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai ben de a p'pa fu kownu David. David kisi Salomo nanga a frow fu Uria. ");
INSERT INTO srnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo ben de a p'pa fu Rekabeam, Rekabeam ben de a p'pa fu Abia, èn Abia ben de a p'pa fu Asa. ");
INSERT INTO srnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ben de a p'pa fu Yosafat, Yosafat ben de a p'pa fu Yoram, èn Yoram ben de a p'pa fu Usia. ");
INSERT INTO srnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ben de a p'pa fu Yotam, Yotam ben de a p'pa fu Akas, èn Akas ben de a p'pa fu Hiskia. ");
INSERT INTO srnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskia ben de a p'pa fu Manasa, Manasa ben de a p'pa fu Amon, èn Amon ben de a p'pa fu Yosia. ");
INSERT INTO srnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia ben de a p'pa fu Yekonya nanga den brada fu en. Ini a ten dati srudati fu Babiloniakondre ben teki a kondre fu den Dyusma abra, dan den tyari den Dyu gwe na Babiloniakondre. ");
INSERT INTO srnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baka di den tyari den gwe, Yekonya kisi Sealtiyel, èn Sealtiyel ben kisi Serubabel. ");
INSERT INTO srnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ben de a p'pa fu Abihud, Abihud ben de a p'pa fu Elyakim, èn Elyakim ben de a p'pa fu Asor. ");
INSERT INTO srnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ben de a p'pa fu Sadok, Sadok ben de a p'pa fu Akim, èn Akim ben de a p'pa fu Elihud. ");
INSERT INTO srnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud ben de a p'pa fu Eleasar, Eleasar ben de a p'pa fu Matan, èn Matan ben de a p'pa fu Yakob. ");
INSERT INTO srnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob ben de a p'pa fu Yosef, èn Yosef ben de a masra fu Maria. Maria ben de a m'ma fu Yesus, di den sma e kari Kristus. ");
INSERT INTO srnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","So wi e teri tin-na-fo afo fu Abraham kon miti David, nanga tin-na-fo afo fu David kon miti a ten di den feyanti fu den Dyusma ben tyari den gwe na Babiloniakondre. Dan fu a ten di den Dyusma ben de ini Babiloniakondre, kon miti a ten di a Mesias gebore, wi e teri tin-na-fo afo tu. ");
INSERT INTO srnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na so Yesus Kristus kon gebore. Maria, a m'ma fu Yesus, ben de fu trow nanga Yosef. Ma fosi den go libi makandra, Maria ben hori bere. Ma na a Santa Yeye ben meki dati psa. ");
INSERT INTO srnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Dan fu di Yosef ben de wan bun sma, a ben wani kibri Maria fu a syen di a bo kisi te sma bo yere a sani disi. Fu dat'ede a ben wani prati nanga en na wan safri fasi. ");
INSERT INTO srnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma di Yosef prakseri a sani dati, ne wan engel fu Masra sori ensrefi na en ini wan dren. A engel taigi en taki: “Yosef, bakapikin fu David, yu no abi fu frede fu teki Maria leki yu wefi. Bika na a Santa Yeye meki tak' a de nanga bere. ");
INSERT INTO srnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A sa kisi wan manpikin, di yu mus kari Yesus. Bika na En sa ferlusu En pipel fu den sondu.” ");
INSERT INTO srnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ala den sani disi psa, fu meki a sani san Masra ben meki a profeiti taki kon tru. A ben taki: ");
INSERT INTO srnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Luku, wan yongu uma di noiti no sribi nanga wan man ete, sa kisi bere. A sa kisi wan manpikin, di den sa kari Emanuel.” (Emanuel wani taki: Gado de nanga wi.) ");
INSERT INTO srnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Di Yosef wiki, a du san a engel fu Masra taigi en, a trow nanga Maria. ");
INSERT INTO srnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma a no sribi nanga en leki man nanga frow te leki Maria kisi a boi. Di A gebore Yosef kari En Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus gebore ini a foto Betlehem na ini a distrikti Yudea. Ini a ten dati kownu Herodes ben e rigeri Israelkondre. Ini a srefi pisten dati koniman di ben libi na a sei pe son e opo, kon na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dan den aksi den sma taki: “Pe a Kownu fu den Dyusma de, di gebore? Bika wi si wan spesrutu stari na a sei pe son e opo di e sori tak' A gebore. Dat' meki wi kon fu anbegi En.” ");
INSERT INTO srnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kownu Herodes skreki di a yere a sani dati. Ala den sma fu Yerusalem skreki tu. ");
INSERT INTO srnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dan Herodes meki ala den prenspari domri nanga den sabiman fu Gado wèt kon makandra. Dan a aksi den pe a Mesias bo gebore. ");
INSERT INTO srnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Den man taigi en taki: “Ini Betlehem na ini Yudea. Bika a profeiti ben skrifi taki: ");
INSERT INTO srnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betlehem ini Yudeakondre, yu na wan fu den moro prenspari foto mindri den foto fu Yuda. Bika na ini yu a fesiman sa kmoto, di sa tiri Mi pipel Israel.” ");
INSERT INTO srnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dan Herodes seni kari den koniman tapu wan kibri fasi, fu aksi den fin'fini oten den si a stari fu a fosi leisi. ");
INSERT INTO srnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Baka dati a taigi den taki: “Un go na Betlehem go suku alape pe a pikin de. Te un feni en, un mus kon taigi mi wantron, bika mi wani go fu anbegi En tu.” ");
INSERT INTO srnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Di den koniman arki san Herodes taki, den gwe. Ne den si a stari baka di den ben si na a sei pe son e opo. Den man ben prisiri srefsrefi di den si a stari. Ne a stari go na den fesi te kon miti a presi pe a pikin ben de. ");
INSERT INTO srnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Di den go ini a oso, den si a pikin nanga en m'ma Maria. Ne den fadon tapu den kindi èn den anbegi a pikin. Dan den puru den diri sani di den ben tyari gi a pikin kon na doro: gowtu, wierook, nanga mirre. ");
INSERT INTO srnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma Gado warskow den man ini wan dren fu no drai go moro na Herodes. So den teki wan tra pasi drai go baka na den kondre. ");
INSERT INTO srnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Di den koniman gwe, ne wan engel fu Masra, sori ensrefi na Yosef ini wan dren. A engel taki: “Opo, teki a pikin nanga en m'ma, dan un lowe go na Egipte. Un mus tan drape te leki mi sa taigi unu tak' un kan drai kon baka. Bika Herodes sa meki den suku a pikin fu kiri en.” ");
INSERT INTO srnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","So Yosef opo, a teki a pikin nanga en m'ma, dan a srefi neti dati den teki pasi go na Egipte. ");
INSERT INTO srnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Den tan drape te leki Herodes dede. Dan na so a sani san Masra ben meki a profeiti taki kon tru. A ben taki: Fu Egipte Mi kari Mi Manpikin. ");
INSERT INTO srnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma di Herodes kon ferstan tak' den koniman hori en na spotu, en ati teki faya. Dat' meki a seni srudati fu kiri ala pikin boi te nanga tu yari na ini Betlehem nanga a heri kontren drape. Bika di a aksi den, den koniman ben taigi en tak' na sowan pisten kba di den ben si a stari. ");
INSERT INTO srnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Di Herodes kiri den pikin, dan a sani san a profeiti Yeremia ben taki kon tru. A ben taki: ");
INSERT INTO srnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Furu krei nanga dyeme de fu yere ini Rama. Na Rachel e krei fu en pikin ede. A no wani fu sma trowstu en, bika den pikin no de moro. ");
INSERT INTO srnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Baka di Herodes dede, ne wan engel fu Masra kon sori ensrefi na Yosef na ini wan dren di a ben de ini Egipte ete. ");
INSERT INTO srnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A engel taki: “Opo, teki a pikin nanga en m'ma, dan un drai go baka na Israelkondre. Bika den sma di ben wani kiri a pikin, dede.” ");
INSERT INTO srnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","So Yosef opo, a teki a pikin nanga en m'ma, dan den go na Israel. ");
INSERT INTO srnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma di Yosef yere tak' Arkelaus ben tron kownu fu Yudea na a presi fu en p'pa Herodes, a kon frede fu go drape. Dan fu di Gado warskow en na ini wan dren, a go na a distrikti Galilea. ");
INSERT INTO srnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Di den doro drape, den go libi ini wan foto di den e kari Nasaret. Na so a sani san den profeiti ben taki kon tru. Den ben taki: Den o kari En wan Nasaretsma. ");
INSERT INTO srnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Someni yari na baka, Yohanes a Dopuman bigin preiki ini a Dreisabana fu Yudea. ");
INSERT INTO srnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","A taigi den sma taki: “Un drai un libi, bika her'esi Gado o bigin tiri libisma.” ");
INSERT INTO srnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A profeiti Yesaya ben taki fu Yohanes di a taki: Wan sma e bari wroko ini a dreisabana taki: Meki pasi klari gi Masra, puru ala boktuboktu gi En. ");
INSERT INTO srnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes ben e weri krosi di meki fu kameel-wiwiri, èn a ben e tai wan leribuba na en bere. A ben e nyan sprenka nanga bus'oni. ");
INSERT INTO srnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dan den sma fu Yerusalem, nanga den sma fu a heri distrikti Yudea, sosrefi den sma fu a heri kontren na a Yordanliba, hari go na Yohanes. ");
INSERT INTO srnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dan a dopu den ini a Yordanliba te den ben taki sortu sondu den du. ");
INSERT INTO srnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Furu fu den Fariseiman nanga Saduseiman kon na Yohanes fu teki dopu tu. Ma di a si den, a taigi den taki: “Un sneki unu! Suma gi un wan pingi fu lon gi a strafu fu Gado di de fu kon? ");
INSERT INTO srnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Efu trutru un drai un libi, meki a de fu si dan. ");
INSERT INTO srnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Un no mus prakseri tak' un kan taigi unsrefi taki: ‘Wi na bakapikin fu Abraham.’ Bika mi e taigi un taki: Gado kan meki den ston disi tron bakapikin fu Abraham. ");
INSERT INTO srnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A aksi de klar'klari kba na den rutu fu den bon. Ibri bon di no e gi bun froktu, den o kapu puru èn fringi go ini a faya. ");
INSERT INTO srnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mi e dopu unu nanga watra leki wan marki tak' un drai un libi. Ma a Wan di e kon na mi baka abi makti moro mi. Mi no warti srefi fu tyari En susu gi En fu A weri. Na En o dopu unu nanga a Santa Yeye èn nanga faya. ");
INSERT INTO srnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A hori En wrokosani na ini En anu fu wai a buba puru ini a aleisi. A aleisi A o poti na ini maksin, ma den buba A o bron na ini faya di no man dede.” ");
INSERT INTO srnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesus kmoto fu a distrikti Galilea go na Yohanes na a Yordanliba, fu Yohanes dopu En. ");
INSERT INTO srnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma Yohanes no ben wani dopu En. A taigi En taki: “Fa Yu kan kon na mi fu mi dopu Yu? Na Yu mus dopu mi!” ");
INSERT INTO srnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Yesus piki en taki: “Yu kan dopu Mi, bika a fiti fu un du ala sani soleki fa Gado wani.” Dan Yohanes dopu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Fa Yesus dopu, A kmoto wantron na ini a watra. Ne heimel opo, èn Yohanes si fa a Yeye fu Gado saka leki wan doifi kon tapu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dan wan sten kmoto fu heimel taki: “Disi na Mi Manpikin di Mi lobi. Mi abi prisiri nanga En.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Baka dati a Santa Yeye tyari Yesus go na ini a dreisabana fu didibri tesi En. ");
INSERT INTO srnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesus tan drape fotenti dei nanga fotenti neti sondro fu nyan. Baka dati angri bigin kiri En. ");
INSERT INTO srnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dan didibri go tesi Yesus. A taigi En taki: “Efu Yu na a Manpikin fu Gado, taigi den ston disi fu den tron brede.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma Yesus piki en taki: “A skrifi taki: Wan sma no sa libi fu brede wawan, ma fu ala wortu di Gado e taki.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Baka dati didibri tyari Yesus go na a santa foto Yerusalem, dan a poti En tnapu na a lantyi fu a daki fu a mamakerki fu den Dyu. ");
INSERT INTO srnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A taigi En taki: “Efu Yu na a Manpikin fu Gado, trowe Yusrefi go na gron. Bika a skrifi taki: Gado sa seni den engel fu En fu tyari Yu na tapu den anu, fu Yu no stotu Yu futu na wan ston.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Yesus piki en taki: “A skrifi tu taki: Yu no mus tesi Masra yu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Te fu kba didibri tyari Yesus go tapu wan bun hei bergi. A sori En ala den kondre fu grontapu, nanga a gudu fu den. ");
INSERT INTO srnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dan a taigi En taki: “Mi sa gi Yu ala den sani dati, efu Yu fadon tapu Yu kindi fu anbegi mi.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ne Yesus piki en taki: “Kmoto na Mi tapu, Satan! Bika a skrifi taki: Yu mus anbegi Masra yu Gado, èn na En wawan yu mus dini.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","So didibri gwe libi Yesus. Ne engel kon sorgu gi En. ");
INSERT INTO srnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Di Yesus yere tak' den poti Yohanes a Dopuman na ini straf'oso, A go na a distrikti Galilea. ");
INSERT INTO srnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A no tan ini Nasaret, ma A go libi ini Kafarnaum di ben de sei a Meer fu Galilea, ini a kontren fu den bakapikin fu Sebulon nanga Naftali. ");
INSERT INTO srnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na so a sani san a profeiti Yesaya ben taki kon tru. ");
INSERT INTO srnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","A ben taki: Un arki, sma fu Sebulon nanga Naftali, di e libi na a pasi di e go na se, ini a kontren di de na a tra sei fu a Yordanliba, un sma fu Galilea, pe furu sma e tan di no de Dyu: ");
INSERT INTO srnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Unu di e libi na ini dungru, si wan bigi faya. Unu di e libi ini a kondre pe un de fu dede, wan faya opo kon gi unu. ");
INSERT INTO srnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Bigin fu a ten dati, Yesus bigin taigi den sma taki: “Un drai un libi, bika her'esi Gado o bigin tiri libisma.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Di Yesus ben e waka na a syoro fu a Meer fu Galilea, A si tu fis'man di ben e fisi nanga den tyasneti. Den tu man disi ben de brada. A wan ben nen Simon, di den sma ben e kari Petrus, èn a trawan ben nen Andreas. ");
INSERT INTO srnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus taigi den taki: “Un kon waka nanga Mi, dan Mi o meki un tron fis'man fu libisma.” ");
INSERT INTO srnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wantron den man poti den tyasneti na wan sei, dan den bigin waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Di den waka pikinso moro fara, Yesus si tu tra brada, Yakobus nanga Yohanes. Den ben de ini wan boto nanga den p'pa Sebedeus e lapu den tyasneti. Dan Yesus kari den. ");
INSERT INTO srnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wantron den libi a boto nanga den p'pa, dan den bigin waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus waka ini heri Galilea, èn A gi den sma leri ini den Dyukerki. A ferteri den sma a Bun Nyunsu tak' Gado o bigin tiri libisma, èn A dresi ala sortu siki di den sma ben abi. ");
INSERT INTO srnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Dan a nyunsu fu Yesus panya go te na ini heri Siriakondre. So den tyari ala sma di ben siki tranga kon na Yesus: sma nanga ala sortu siki nanga hebi skin-ati, sma nanga takruyeye na den tapu, nanga sma di ben e kisi stoipi. Srefi sma di ben lan den ben tyari kon na Yesus. Dan Yesus meki ala den sma dati kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bun furu sma ben e waka na Yesus baka: sma fu Galilea, sma fu Dekapolis, sma fu Yerusalem, sma fu Yudea, nanga sma fu a tra sei fu a Yordanliba. ");
INSERT INTO srnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Di Yesus si ala den sma di ben e waka na En baka, A kren go sidon tapu wan bergi. Dan den sma di ben e teki leri fu En teki presi lontu En. ");
INSERT INTO srnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dan Yesus bigin leri den taki: ");
INSERT INTO srnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Blesi de tapu den sma di kon si tak' den abi Gado fanowdu, bika A e tiri den leki Kownu. ");
INSERT INTO srnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Blesi de tapu den sma di e sari, bika Gado sa trowstu den. ");
INSERT INTO srnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Blesi de tapu den sma di abi sakafasi, bika heri grontapu sa de fu den. ");
INSERT INTO srnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Blesi de tapu den sma di abi wan tranga angri fu de bun ini Gado ai, bika A sa gi den san den wani. ");
INSERT INTO srnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Blesi de tapu den sma di abi sari-ati nanga trawan, bika Gado sa abi sari-ati nanga den. ");
INSERT INTO srnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Blesi de tapu den sma di e dini Gado wawan, bika den sa si En. ");
INSERT INTO srnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Blesi de tapu den sma di e tyari freide kon na trawan mindri, bika Gado sa kari den En pikin. ");
INSERT INTO srnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Blesi de tapu den sma di trawan de na den baka fu du den ogri fu di den bun ini Gado ai, bika A e tiri den leki Kownu. ");
INSERT INTO srnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Blesi de na yu tapu te sma e broko yu saka, te den de na yu baka fu du yu ogri, èn te den e lei taki ala sortu takru fu yu, fu di yu e waka na Mi baka. ");
INSERT INTO srnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yu mus prisiri, yu mus breiti, bika wan bigi pai e wakti yu na heimel. Bika na so den ben du nanga den fosten profeiti tu.” ");
INSERT INTO srnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yu de leki sowtu gi den sma na grontapu. Ma efu sowtu lasi en tesi, fa a o kon sowtu baka? Yu no man du noti moro nanga en, dan fu trowe en gwe meki sma waka na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yu de leki wan faya gi den sma na grontapu. Wan foto di de na tapu wan bergi no kan tan kibri. ");
INSERT INTO srnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yu no e leti wan kokolampu, dan yu e poti en ondro wan embre. Ma yu e poti en tapu wan tafra fu a gi faya na ala sma ini a oso. ");
INSERT INTO srnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na so a faya fu yu mus de fu si gi trawan, fu den kan si den bun wroko fu yu. Dan den o gi yu P'pa na heimel bigi nen.” ");
INSERT INTO srnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yu no mus prakseri tak' Mi kon fu poti a wèt nanga den sani di den profeiti skrifi na wan sei. Mi no kon fu poti den na wan sei, ma Mi kon fu du san den e taki. ");
INSERT INTO srnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bika fu tru Mi e taigi un taki: Solanga heimel nanga grontapu sa de, no wan pikin pisi fu san skrifi ini a wèt sa puru. Ala san skrifi sa psa. ");
INSERT INTO srnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dat' meki a sma di e poti a moro pikin pisi srefi fu den wèt na wan sei, dan a e leri trawan fu du a srefi sani, a sma dati sa kisi a moro lagi presi na mindri den sma di Gado e tiri. Ma a sma di e du san den wèt e taki, èn a e leri trawan fu du a srefi sani, sa kisi wan hei presi na mindri den sma di Gado e tiri. ");
INSERT INTO srnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bika Mi e taigi un taki: Efu yu no e libi moro bun ini Gado ai moro den sabiman fu Gado wèt nanga den Fariseiman, dan noiti yu o man tron wan sma di Gado e tiri.” ");
INSERT INTO srnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Un yere tak' a wèt fu Moses leri den bigisma fu unu taki: ‘Un no mus kiri wan tra sma,’ èn owktu taki: ‘Krutubakra sa leisi strafu gi a sma di du a sani dati.’ ");
INSERT INTO srnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma Mi e taigi un taki: Suma ati e bron nanga en brada, sa fadon ini anu fu krutubakra. A sma di sa kari en brada ‘don kaw,’ o fadon ini anu fu a grankrutu, èn a sma di sa kari en brada ‘lawman,’ o feni ensrefi te ini a faya fu hel. ");
INSERT INTO srnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dat' meki efu yu e tnapu fesi a altari fu tyari wan offer gi Gado, ma yu memre tak' yu brada abi wan sani nanga yu, ");
INSERT INTO srnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","libi a offer let' drape dan yu go meki en bun nanga yu brada. Baka dati yu kan drai kon baka fu tyari a offer gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Efu wan sma di abi wan sani nanga yu, e tyari yu go na krutu, dan yu mus meki muiti fu meki en es'esi bun nanga en fosi un doro drape. Bika te un doro drape a sa gi yu abra na a krutubakra. Dan a dati sa gi yu abra na skowtu, di sa poti yu na ini straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Fu tru Mi e taigi yu taki: Yu no o kmoto drape solanga yu no pai te nanga a laste koprosensi.” ");
INSERT INTO srnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Un yere tak' a skrifi taki: ‘Yu no mus huru.’ ");
INSERT INTO srnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma Mi e taigi un taki: A sma di luku wan uma nanga a prakseri tak' a wani en, huru na ini en ati nanga a uma dati kba. ");
INSERT INTO srnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dat' meki efu yu let' ai meki yu sondu, diki en puru dan yu trowe en gwe. Bika a moro bun gi yu tak' wan pisi nomo fu yu skin e lasi, dan tak' yu feni yusrefi nanga yu heri skin ini hel. ");
INSERT INTO srnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Efu na yu let'anu meki yu sondu, kapu en puru dan yu trowe en gwe. Bika a moro bun gi yu tak' wan pisi nomo fu yu skin e lasi, dan tak' yu feni yusrefi nanga yu heri skin ini hel.” ");
INSERT INTO srnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“A skrifi tu taki: ‘Wan man di e prati nanga en frow, mus gi en wan brifi di e sori tak' a trow broko.’ ");
INSERT INTO srnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma Mi e taigi un taki: Wan man no mus broko trow nanga en frow sondro tak' a frow ben huru gi en. Efu a man du dati, a e meki tak' a frow libi wan huru libi efu a trow baka, èn a e meki a man di trow nanga en libi wan huru libi tu.” ");
INSERT INTO srnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Un yere tu tak' a wèt fu Moses leri den bigisma fu unu taki: ‘Yu no sa broko wan sweri di yu meki, ma yu sa du san yu sweri gi Masra.’ ");
INSERT INTO srnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma Mi e taigi un taki: Yu no mus meki sweri kwet'kweti. No sweri na heimel, bika heimel na a kownusturu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yu no mus sweri na grontapu, bika grontapu na a futubangi fu Gado. Yu no mus sweri na Yerusalem, bika Yerusalem na a foto fu a bigi Kownu. ");
INSERT INTO srnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","No sweri tu na yu ede, bika yu no kan meki no wan fu yu edewiwiri kon blaka noso weti. ");
INSERT INTO srnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","So dan, meki te yu e taki ‘iya,’ a tan ‘iya,’ èn meki te yu e taki ‘no,’ a tan ‘no.’ Bika ala san yu e taki moro leki dati, kmoto fu didibri.” ");
INSERT INTO srnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Un yere tak' a skrifi taki: ‘Efu wan sma naki wan trawan broko en ai, den mus broko a ai fu a sma dati baka. Èn efu wan sma naki wan trawan broko en tifi, den mus broko a tifi fu a sma dati baka.’ ");
INSERT INTO srnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma Mi e taigi un taki: No meki trobi nanga a sma di e du yu ogri. Efu wan sma naki yu na a let'sei fu yu fesi, drai a tra sei gi en tu. ");
INSERT INTO srnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Efu wan sma tyari yu go na krutu fu yu empi ede, gi en a dyakti fu yu tu. ");
INSERT INTO srnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Efu wan sma dwengi yu fu tyari a lai fu en wan kilometer, tyari en tu kilometer gi en. ");
INSERT INTO srnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Efu wan sma aksi yu wan sani, gi en san a aksi. Èn efu a wani leni wan sani fu yu, leni en.” ");
INSERT INTO srnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Un yere tak' a skrifi taki: ‘Yu mus lobi yu mati, èn yu mus hori yu feyanti na ati.’ ");
INSERT INTO srnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma Mi e taigi un taki: Lobi yu feyanti, èn begi gi den sma di de na yu baka fu du yu ogri. ");
INSERT INTO srnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dan so yu sa de wan trutru pikin fu yu P'pa di de na heimel. Bika A e meki a son opo gi den sma di e du ogri, nanga gi den sma di e du bun. A e meki alen kon gi den sma di bun ini En ai, nanga den sma di no bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bika efu yu lobi soso den sma di lobi yu, sortu pai yu abi? Bika srefi den man di e piki edemoni e du dati. ");
INSERT INTO srnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Efu yu e gi odi soso na den sma nanga san yu de bun, dan na wan aladei sani yu e du. Den sma di no sabi Gado e du a srefi sani. ");
INSERT INTO srnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ma yu mus bun dorodoro, soleki fa yu P'pa na heimel bun dorodoro.” ");
INSERT INTO srnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Sorgu tak' te yu e du tra sma wan bun, yu no e du en fu sma si. Noso yu no abi pai na yu P'pa di de na heimel. ");
INSERT INTO srnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Te yu e gi wan pôtisma wan sani, no du en nanga pranpran. Bika na so den hoigriman e du ini den kerki nanga tapu strati, soso fu sma kan gi den grani. Fu tru Mi e taigi un taki: Den kisi den pai kba. ");
INSERT INTO srnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma te yu e gi wan pôtisma wan sani, yu kruktu-anu no mus sabi san yu let'anu e du. ");
INSERT INTO srnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na so a e tan wan kibri sani. Dan yu P'pa di si san yu du, sa pai yu.” ");
INSERT INTO srnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Te yu e begi, yu no mus de leki den hoigriman. Bika den lobi fu tnapu begi ini den kerki nanga tapu uku fu strati fu sma kan si den. Fu tru Mi e taigi un taki: Den kisi den pai kba. ");
INSERT INTO srnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma te yu e begi, go na ini yu kamra èn tapu a doro. Dan yu e taki nanga yu P'pa di no wan sma e si. Ma yu P'pa di e si yu drape, sa pai yu. ");
INSERT INTO srnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Te yu e begi yu no mus begi langabere begi leki den sma di no sabi Gado. Bika den e prakseri tak' te den begi langa, den o kisi san den e aksi. ");
INSERT INTO srnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yu no mus begi leki den, bika yu P'pa sabi san yu abi fanowdu fosi yu aksi En. ");
INSERT INTO srnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ma disi na a fasi fa yu mus begi: Wi P'pa di de na heimel, Yu nen mus de santa. ");
INSERT INTO srnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kon tiri wi, meki Yu wani psa na grontapu soleki fa a e psa na heimel. ");
INSERT INTO srnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gi wi tide a nyanyan di wi abi fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gi wi pardon fu wi sondu, soleki fa wi e gi trawan pardon di du wi wan sani. ");
INSERT INTO srnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","No meki tesi kon na wi pasi, ma kibri wi fu didibri. Bika na Yu na a Kownu, èn ala makti nanga ala glori na fu Yu, fu têgo. Amen. ");
INSERT INTO srnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Bika efu yu e gi sma pardon di du yu wan sani, yu P'pa na heimel sa gi yu pardon tu. ");
INSERT INTO srnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma efu yu no e gi sma pardon, yu P'pa no sa gi yu pardon tu.” ");
INSERT INTO srnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesus taigi den moro fara taki: “Te yu e faste, yu no mus poti wan sari fesi leki den hoigriman. Bika den e masi den fesi soso fu sma kan si tak' den e faste. Fu tru Mi e taigi un taki: Den kisi den pai kba. ");
INSERT INTO srnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma te yu e faste, yu mus wasi yu fesi èn yu mus kan yu wiwiri. ");
INSERT INTO srnNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Sma no abi fu sabi tak' yu e faste, ma soso yu P'pa di no wan sma e si. Dan yu P'pa di e si san yu e du na wan kibri fasi, sa pai yu.” ");
INSERT INTO srnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yu no mus suku gudu dya na grontapu, pe kakalaka e nyan den, pe frustu e meki den pori gwe, èn pe fufuruman kan broko kon ini yu oso, fufuru den. ");
INSERT INTO srnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma meki yu gudu de na heimel, pe kakalaka no man nyan den, pe frustu no man meki den pori gwe, èn pe fufuruman no man broko kon ini yu oso, fufuru den. ");
INSERT INTO srnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bika pe yu gudu de, na drape yu ati o de tu. ");
INSERT INTO srnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yu ai de leki wan lampu di e tyari leti gi yu skin. Efu yu ai krin, yu heri libi o krin. ");
INSERT INTO srnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma efu yu ai dungru, dan yu heri libi o dungru. Sobun, efu a sani di mus tyari leti kon gi yu, tyari dungru kon, a no spotu dungru yu libi sa dungru. ");
INSERT INTO srnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","No wan sma kan wroko gi tu basi. Bika a sa hori a wan na ati, dan a lobi a trawan. Noso a sa lespeki a wan, ma a no teri a trawan. Yu no kan dini Gado makandra nanga den gudu fu grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Fu dat'ede Mi e taigi un taki: No broko yu ede nanga san yu o nyan noso dringi fu tan na libi, noso san yu o weri fu tapu a skin. A libi warti moro leki nyanyan, èn yu skin warti moro leki krosi. ");
INSERT INTO srnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Luku den fowru di e frei na loktu. Den no e prani, den no e koti, den no e kibri nyanyan ini maksin. Ma toku un P'pa na heimel e gi den nyanyan. Un no warti moro leki den fowru dan? ");
INSERT INTO srnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sortu wan fu unu kan meki tak' a e libi pikinso moro langa te a e broko en ede? ");
INSERT INTO srnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Fu sanede yu e broko yu ede nanga krosi? Luku fa den bromki e gro. Den no e wroko èn den no e meki krosi. ");
INSERT INTO srnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma Mi e taigi un taki: Wan bigi kownu leki Salomo srefi no ben man weri so moi leki den bromki disi. ");
INSERT INTO srnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","We, efu Gado e weri so moi krosi gi a grasi di e gro tide èn tamara sma e bron en, A no sa weri moro moi wan gi yu dan? Fa yu bribi pikin so? ");
INSERT INTO srnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dat'ede yu no mus broko yu ede nanga san yu o nyan, san yu o dringi, noso san yu o weri. ");
INSERT INTO srnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bika na sma di no sabi Gado e broko den ede nanga den sani disi. Ma yu P'pa na heimel sabi tak' yu abi ala den sani disi fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ma tapu a fosi presi yu mus suku fu de ondro a tiri fu Gado, èn fu libi bun ini En ai, dan A sa gi yu ala den sani disi tu. ");
INSERT INTO srnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","So, no broko yu ede nanga a dei fu tamara. Tamara sa abi en eigi broko-ede. Den broko-ede fu wan dei sari kba.” ");
INSERT INTO srnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“No krutu trawan, dan trawan no o krutu yu. ");
INSERT INTO srnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bika tapu a srefi fasi fa yu e krutu trawan, den o krutu yu baka. Èn a srefi marki san yu e teki fu krutu trawan, den o teki fu krutu yu baka. ");
INSERT INTO srnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Fa yu kan si a fini pisi udu ini a ai fu yu brada, ma yu no e si tak' wan postu de ini yu eigi ai? ");
INSERT INTO srnNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Fa yu kan taigi yu brada taki: ‘Kon meki mi puru a fini pisi udu ini yu ai,’ aladi yu abi wan postu na ini yu eigi ai? ");
INSERT INTO srnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yu hoigriman! Puru a postu ini yu eigi ai fosi, dan yu o man si krin fu kan puru a fini pisi udu ini a ai fu yu brada. ");
INSERT INTO srnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","No gi dagu den santa sani fu Gado, bika den o drai kon priti yu. Èn no trowe parelkrara gi agu, bika na trapu nomo den o trapu den nanga den futu.” ");
INSERT INTO srnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Begi, dan yu sa kisi. Suku, dan yu sa feni. Naki, dan doro sa opo gi yu. ");
INSERT INTO srnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bika a sma di e begi, e kisi. A sma di e suku, e feni. Èn a sma di e naki, doro e opo gi en. ");
INSERT INTO srnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Suma sa gi en pikin wan ston, efu a pikin aksi en wan brede? ");
INSERT INTO srnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Noso wan sneki efu a aksi en wan fisi? ");
INSERT INTO srnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Efu yu leki sondusma, sabi fa fu gi yu pikin bun sani, fa fu yu P'pa na heimel dan? A sa gi moro bun sani na den sma di e aksi En fu dati. ");
INSERT INTO srnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yu mus libi nanga trawan soleki fa yu wani tak' den mus libi nanga yu. Bika na dati Moses nanga den profeiti ben leri unu.” ");
INSERT INTO srnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Yu musu psa ini a smara doro. Bika a doro fu hel bigi èn a pasi fu en bradi. Furu sma e waka na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma a doro pikin di e tyari yu go na a têgo libi, èn a pasi fu en smara. Wantu sma nomo e feni a pasi dati.” ");
INSERT INTO srnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Yu mus luku bun nanga den sma di e du leki den na profeiti. Te den e kon na yu den e meki leki skapu, ma na inisei den de leki krasi tigri. ");
INSERT INTO srnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma yu kan sabi den na a fasi fa den e libi. Bika wan prasarabon no e gi droifi, èn wan makabon no e gi figa. ");
INSERT INTO srnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Wan bon di gesontu e gi bun froktu, ma wan bon di no gesontu no man gi bun froktu. ");
INSERT INTO srnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wan bon di gesontu no man gi froktu di no bun, èn wan bon di no gesontu, no man gi bun froktu. ");
INSERT INTO srnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ibri bon di no e gi bun froktu, den o kapu puru fringi go ini a faya. ");
INSERT INTO srnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Na so yu sa sabi den sma dati, na a fasi fa den e libi.” ");
INSERT INTO srnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“A no ala sma di e kari Mi: ‘Masra, Masra,’ sa kon na mindri den sma di Gado e tiri. Ma soso den sma di e du a wani fu Mi P'pa di de na heimel. ");
INSERT INTO srnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tapu a dei di Gado o leisi strafu gi libisma, furu sma o taigi Mi taki: ‘Masra, Masra, a no ini Yu nen wi ben gi sma Yu boskopu? A no ini Yu nen wi ben yagi takruyeye puru na tapu sma? A no ini Yu nen, wi ben du furu bigi sani?’ ");
INSERT INTO srnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma Mi sa taigi den na ala sma fesi taki: Kmoto na Mi fesi, un takru-ati sma. Noiti Mi ben sabi unu!” ");
INSERT INTO srnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesus taigi den sma taki: “Ibri sma di yere san Mi taki, èn di e du so, sa de leki wan koniman di bow en oso tapu tranga gron. ");
INSERT INTO srnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Alen fadon, frudu kon, winti wai naki na a oso skin, ma a oso no fadon bika a ben bow tapu tranga gron. ");
INSERT INTO srnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ma ala sma di yere Mi, ma den no e du san Mi taki, de leki wan donman di bow en oso tapu santi. ");
INSERT INTO srnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Di alen fadon, frudu kon, èn a winti wai naki na a oso skin, a oso fadon broko pis'pisi, èn noti fu en no tan.” ");
INSERT INTO srnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Di Yesus kba taki ala den sani disi, a bigi grupu sma no ben sabi san fu taki fu a leri fu En. ");
INSERT INTO srnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bika A no ben gi leri leki fa den sabiman fu Gado wèt ben e du, ma A ben du en leki a sma di kon nanga a leri. ");
INSERT INTO srnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Di Yesus saka kmoto fu a bergi, bun furu sma ben e waka na En baka. ");
INSERT INTO srnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne wan gwasiman kon na Yesus, a saka tapu en kindi na En fesi, dan a taigi En taki: “Masra, efu Yu wani, Yu kan meki mi skin kon bun baka.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus langa En anu fasi a man, dan A taki: “Iya, Mi wani. Kon betre!” A srefi momenti dati a man skin kon bun baka. ");
INSERT INTO srnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dan Yesus taigi a man taki: “Sorgu tak' yu no e ferteri no wan sma san psa nanga yu. Ma yu mus go na a Dyudomri, meki a si tak' yu kon betre. Dan fu sori ala sma tak' yu kon betre, yu mus tyari a offer gi Gado leki fa Moses skrifi tak' yu mus du.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Di Yesus doro na a foto Kafarnaum, wan Romeini ofisiri kon begi En wan sani. ");
INSERT INTO srnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","A taki: “Masra, a knekti fu mi didon na oso. A lan èn a abi hebi skin-ati.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus piki a man taki: “Mi sa go dresi en.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma a edeman piki en taki: “Masra, mi no warti fu Yu kon ini mi oso. Ma efu Yu taki wan wortu nomo, dan a knekti fu mi o kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bika mi srefi e wroko ondro trawan, èn mi abi srudati di de ondro mi. Efu mi taigi wan fu den taki: ‘Go drape,’ a e go. Efu mi taigi wan trawan taki: ‘Kon dya,’ a e kon. Efu mi taigi mi srafu taki: ‘Du disi,’ a e du en.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Di Yesus yere san a man taki, A ferwondru. Dan A taigi den sma di ben e waka na en baka taki: “Fu tru Mi e taigi un taki: Na ini heri Israelkondre Mi no feni no wan sma nanga sowan bigi bribi. ");
INSERT INTO srnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mi e taigi un taki: Te Gado o bigin tiri libisma, furu sma sa kmoto na ala sei fu grontapu fu sidon nyan makandra nanga Abraham, Isak nanga Yakob. ");
INSERT INTO srnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma den sma di ben mus de ondro a tiri fu Gado, den o fringi den go na dorosei ini a dungru. Drape den sa krei èn kaw den tifi.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dan Yesus taigi a ofisiri taki: “Yu kan go. A sa psa soleki fa yu e bribi.” A srefi ten dati a knekti kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Baka dati Yesus go na Petrus oso. Drape A si tak' a m'ma fu Petrus en frow ben didon nanga korsu. ");
INSERT INTO srnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ne Yesus fasi a uma na en anu, èn a korsu saka. Dan a uma opo go poti nyanyan nanga dringi gi Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Di neti tapu, den tyari furu sma di ben abi takruyeye na den tapu, kon na Yesus. Na taki wawan A ben taki, dan den takruyeye gwe libi den sma. A dresi ala den sikisma tu. ");
INSERT INTO srnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na so a sani san a profeiti Yesaya ben taki kon tru. A ben taki: A tyari den swakifasi fu wi, èn a teki wi siki na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Di Yesus si fa wan heri ipi sma ben e lontu En, A taigi den man fu en taki: “Meki un abra go na a tra sei fu a meer.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma dan wan sabiman fu Gado wèt kon na En. A taigi En taki: “Meister, mi sa go nanga Yu ala sei pe Yu e go.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus piki en taki: “Krab'dagu abi den olo, èn den pikinfowru abi den nesi. Ma a Manpikin fu Libisma no abi wan presi fu kanti En ede.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nomo wan tra man di ben e teki leri fu Yesus taigi En taki: “Masra, gi mi a okasi fu go beri mi p'pa fosi.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma Yesus piki en taki: “Kon nanga Mi, èn meki den dedewan beri den eigi dede.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dan Yesus go ini a boto èn den man fu En go na En baka. ");
INSERT INTO srnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma di den e koti abra, wantron so wan tranga winti bigin wai tapu a watra, tak' den skwala ben e naki go ini a boto. Ma Yesus ben e sribi. ");
INSERT INTO srnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ne den man go wiki En taki: “Masra, yepi wi! Wi e dede!” ");
INSERT INTO srnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus piki den taki: “Fu sanede un e frede so? A bribi fu un pikin!” Dan A opo, A bari a winti nanga a watra, èn wantron ala sani kon tiri. ");
INSERT INTO srnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Den man ferwondru. Den taki: “Suma na a man disi? Winti nanga watra srefi e du san A e taki!” ");
INSERT INTO srnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Di Yesus doro na abrasei ini a kontren fu den sma fu Gadara, tu man di ben abi takruyeye na den tapu, waka kon miti En. Den man disi ben kmoto ini a berpe, èn den ben ogri sote tak' no wan sma no ben man psa drape. ");
INSERT INTO srnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Dan den man bari taki: “Yu Manpikin fu Gado, san Yu wani nanga unu? Na kon Yu kon dyaso fu pina wi fosi a ten doro?” ");
INSERT INTO srnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Krosbei fu drape wan bigi ipi agu ben e nyan. ");
INSERT INTO srnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ne den takruyeye begi Yesus taki: “Efu Yu o yagi un puru na tapu den man, dan tangitangi, seni un go na ini den agu.” ");
INSERT INTO srnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus taigi den taki: “Kmopo fu dya!” Dan den takruyeye kmopo na den man tapu, go na ini den agu. Ne ala den agu lon saka fu a bergi go ini a meer, dan den dede ini a watra. ");
INSERT INTO srnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Den man di ben e luku den agu, lon gwe. Den lon go na ini a foto, dan den ferteri ala sani san den si, sosrefi san ben psa nanga den man di ben abi den takruyeye na den tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dan ala sma kmopo fu a foto go miti Yesus. Di den si En, den aksi En tangitangi fu A gwe libi a kontren fu den. ");
INSERT INTO srnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","So Yesus go ini wan boto, dan A koti a Meer fu Galilea abra go na a foto pe A ben e libi. Ne den sma tyari wan lanman na tapu wan bedi kon na En. ");
INSERT INTO srnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Di Yesus si a bribi fu den, A taigi a lanman taki: “Mi mati, no frede. Yu kisi pardon fu yu sondu.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma wantu fu den sabiman fu Gado wèt taki na ini densrefi taki: “Fa a man disi kan taki so? A e afrontu Gado!” ");
INSERT INTO srnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma Yesus ben sabi san den e prakseri, dat' meki A taigi den taki: “Fu sanede un e prakseri takru sani ini un ati? ");
INSERT INTO srnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bika san moro makriki? Fu taigi a man tak' a kisi pardon fu en sondu, noso fu taigi en fu a opo waka? ");
INSERT INTO srnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma Mi o sori unu tak' a Manpikin fu Libisma abi makti dya na grontapu fu gi sma pardon fu sondu.” Dan Yesus taigi a lanman taki: “Opo, teki yu bedi, dan yu go na oso.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ne a man opo, dan a go na en oso. ");
INSERT INTO srnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","We, di den sma si a sani dati, den kisi bigi lespeki gi Gado. Den gi Gado glori fu di A gi libisma sowan makti. ");
INSERT INTO srnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Di Yesus kmoto fu drape e gwe moro fara, A si wan man di ben nen Mateus. A ben sidon pe den sma ben mus kon pai edemoni. Yesus taigi en taki: “Kon nanga Mi!” Ne Mateus opo èn a bigin waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bakaten Yesus go nyan na Mateus oso. Furu fu den man di e piki edemoni, nanga tra sondusma, ben sidon e nyan makandra nanga Yesus nanga den man di ben e teki leri fu En. ");
INSERT INTO srnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Di den Fariseiman si a sani dati, den aksi den man fu Yesus taki: “Fu sanede a Meister fu unu e nyan makandra nanga den man di e piki edemoni, èn nanga den sondusma?” ");
INSERT INTO srnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ma di Yesus yere san den man aksi, A piki den taki: “Sma di gesontu no abi datra fanowdu, ma na sma di e siki abi datra fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Un go ondrosuku san Gado wani taki nanga a sani disi: Mi no wani den meti di un e tyari leki offer gi Mi, ma Mi wani fu un abi sari-ati nanga trawan. Mi no kon fu kari bun sma, ma Mi kon fu kari sondusma.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baka dati wantu fu den man di ben e teki leri fu Yohanes a Dopuman kon na Yesus, dan den aksi En taki: “Wi nanga den Fariseiman gwenti fu faste. Ma fu sanede den man fu Yu no e du dati?” ");
INSERT INTO srnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus piki den taki: “Sma di de na wan trow-oso no e sari solanga a trowmasra de drape nanga den. Ma a ten o kon tak' den o puru a trowmasra na den mindri. Dan den sa faste. ");
INSERT INTO srnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","No wan sma e lapu wan owru krosi nanga wan pisi nyun wan. Bika te a nyun wan o krempi, a o hari a owru wan priti èn a olo o kon moro bigi. ");
INSERT INTO srnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sosrefi yu no e poti win di no lepi ete na ini winsaka di kon owru kba, noso den saka o priti èn yu o lasi a win nanga den saka. Fu dat'ede yu e poti win di no lepi ete na ini nyun winsaka, fu ala tu kan tan bun.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus no ben kba taki nanga den man fu Yohanes ete, ne wan edeman fu den Dyu kon na En. A man fadon tapu en kindi fesi Yesus, dan a taigi En taki: “Masra, didyonsro mi umapikin dede. Ma efu Yu kon poti Yu anu na en tapu, a o libi baka.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","So Yesus opo, dan En nanga den man fu En go nanga a man. ");
INSERT INTO srnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma di den ben de na pasi, wan uma waka mindri den sma kon baka Yesus, dan a fasi a lantyi fu En krosi. Twarfu yari langa a uma disi ben e lasi brudu kba. ");
INSERT INTO srnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A ben prakseri taki: “Efu mi kan fasi En krosi nomo, mi o kon betre.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus drai luku a uma, dan A taigi en taki: “No frede, Mi pikin, a bribi fu yu meki yu kon betre.” A srefi momenti dati a uma kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Di Yesus doro na a oso fu a edeman, A si den sma di ben e prei dede-oso singi, nanga wan bigi grupu sma di ben e krei. ");
INSERT INTO srnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dan A taigi den sma taki: “Un kan gwe. A pikin no dede, na sribi a e sribi.” Ma den sma bigin lafu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Baka di den poti ala den sma na dorosei, Yesus go inisei pe a pikin ben didon. A hori en na en anu, dan a pikin opo. ");
INSERT INTO srnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A tori disi panya na ini a heri kontren drape. ");
INSERT INTO srnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Di Yesus kmoto fu drape e gwe moro fara, tu breniman bigin waka na En baka e bari taki: “Manpikin fu David, abi sari-ati nanga wi!” ");
INSERT INTO srnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Di Yesus go ini wan oso, den breniman kon na En. Dan Yesus aksi den taki: “Un e bribi tak' Mi kan du san un e aksi Mi?” Den piki taki: “Iya, Masra.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dan Yesus fasi den na den ai, A taki: “A sa psa soleki fa un e bribi.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ne den man ai opo èn den ben man si. Dan Yesus warskow den tranga taki: “Sorgu tak' no wan sma kon sabi a tori disi.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma den man gwe èn den ferteri san Yesus du gi den na ini a heri kontren drape. ");
INSERT INTO srnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Di den tu man ben e gwe, den sma tyari wan man kon na Yesus. A man disi no ben man taki fu di a ben abi wan takruyeye na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Baka di Yesus yagi a takruyeye puru na en tapu, a babawman bigin taki. A bigi grupu sma drape ferwondru. Den taki: “Noiti ete sowan sani psa na ini Israel.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma den Fariseiman taki: “Na a edeman fu den takruyeye e gi En makti fu yagi den takruyeye puru.” ");
INSERT INTO srnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus go na ala den foto nanga dorpu, èn A gi den sma leri ini den Dyukerki. A ferteri den sma a Bun Nyunsu tak' Gado o bigin tiri libisma, èn A dresi ala sortu siki di den sma ben abi. ");
INSERT INTO srnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Di Yesus si den bigi grupu sma na ala sei, A firi wan dipi sari gi den, bika den ben bruya èn den no ben abi wan sma fu luku den, neleki skapu di no abi sma fu tyari den go na wei. ");
INSERT INTO srnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dat' meki Yesus taigi den man di ben e teki leri fu En taki: “A nyanyan ini a gron lepi kba fu koti, èn a furu, ma nofo wrokoman no de. ");
INSERT INTO srnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Fu dat'ede un mus begi Masra di abi a gron, fu A seni moro wrokoman go ini a gron fu koti a nyanyan.” ");
INSERT INTO srnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus kari den twarfu man di ben e teki leri fu En kon. Dan A gi den makti fu yagi takruyeye puru na tapu sma, èn fu dresi ala sortu siki. ");
INSERT INTO srnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Disi na den nen fu den twarfu boskopuman fu Yesus: a fosi wan ben nen Simon, di den sma ben e kari Petrus, nanga en brada Andreas. Moro fara yu ben abi Yakobus a manpikin fu Sebedeus, nanga en brada Yohanes. ");
INSERT INTO srnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Dan yu ben abi Filipus nanga Bartolomeus, Tomas nanga Mateus, a man di ben piki edemoni, Yakobus a manpikin fu Alfeus, nanga Tadeus. ");
INSERT INTO srnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Dan yu ben abi ete Simon, fu a grupu fu den Seloten, nanga Yudas Iskariot, a man di seri Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na den twarfu man disi Yesus seni gwe èn A taigi den taki: “Un no mus go na den sma di no de Dyu, sosrefi un no mus go na den foto fu den Samariasma. ");
INSERT INTO srnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma un mus go na den sma fu Israel, bika den de leki skapu di lasi pasi. ");
INSERT INTO srnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Un go taigi den tak' her'esi Gado o bigin tiri libisma. ");
INSERT INTO srnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Un dresi sikisma, un wiki dedewan, un meki a skin fu den gwasiman kon bun baka, èn un yagi takruyeye puru na tapu sma. Un kisi a makti fu du den sani disi fu soso, un mus du den fu soso tu. ");
INSERT INTO srnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Un no mus tyari no wan moni te unu e gwe, ");
INSERT INTO srnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","sosrefi un no mus tyari wan saka fu te un de na pasi, noso tra krosi noso susu. Wan wakatiki srefi un no mus tyari. Bika a fiti tak' wan wrokoman kisi san a abi fanowdu.” ");
INSERT INTO srnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yesus taigi den man moro fara taki: “Te un doro ini wan foto noso wan dorpu, un mus suku wan sma di warti fu un kon ini en oso. Dan un mus tan ini a oso dati te leki un o gwe na wan tra presi. ");
INSERT INTO srnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te un go ini a oso dati, un mus winsi den sma tak' Gado sa blesi den. ");
INSERT INTO srnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Efu a sori tak' den sma fu a oso warti fu kisi a blesi fu unu, a blesi sa tan nanga den. Ma efu a sori tak' den sma no warti fu kisi a blesi fu unu, a sa drai kon baka na unu. ");
INSERT INTO srnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Èn efu a sori tak' den sma no wani meki un tan na den, noso den no wani arki san un e taki, dan un mus naki a santi puru na un futu te un e gwe libi a oso noso a foto dati. ");
INSERT INTO srnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Fu tru Mi e taigi un taki: Tapu a dei di Gado o krutu libisma, a strafu fu a foto disi sa hebi moro a strafu fu den foto Sodom nanga Gomora.” ");
INSERT INTO srnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Luku, Mi e seni unu leki skapu go na mindri den tigri. Dat' meki un mus de na ai, èn un no mus du no wan sma ogri. ");
INSERT INTO srnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Un luku bun nanga libisma. Bika den sa tyari un go na krutu, èn den o fon unu na ini den kerki fu den. ");
INSERT INTO srnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Fu Mi ede den o srepi un go na fesi granman nanga kownu. Dan un mus teki den okasi dati fu ferteri den, nanga den folku, fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Te den sma tyari un go na krutu, un no abi fu broko un ede fa un mus taki noso san un mus taki. Bika Gado o gi unu san un mus taki a yuru dati. ");
INSERT INTO srnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bika a no unu sa taki fu unsrefi, ma na a Yeye fu Gado un P'pa sa gi un den wortu fu un taki.” ");
INSERT INTO srnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Yesus taigi den boskopuman fu En moro fara taki: “Wan brada sa gi en eigi brada abra fu den kiri en. Wan p'pa sa du a srefi sani nanga en pikin. Pikin sa tron feyanti fu den m'ma nanga den p'pa, èn den o kiri den. ");
INSERT INTO srnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Fu Mi ede no wan sma no o man si un na ai. Ma Gado sa ferlusu a sma di sa hori doro te na a kba. ");
INSERT INTO srnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Te den sma fu a wan foto de na un baka fu du un ogri, un lowe go na wan tra foto. Bika fu tru Mi e taigi un taki: A Manpikin fu Libisma sa drai kon baka fosi un kba du un wroko ini ala den foto fu Israel. ");
INSERT INTO srnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Wan sma di e teki leri, no betre moro en leriman, èn wan knekti no hei moro en masra. ");
INSERT INTO srnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A mus de nofo gi a sma di e teki leri efu a kon de leki en leriman, èn a mus de nofo gi a knekti efu a kon de leki en masra. Efu den sma gi Mi leki a edeman fu a oso a nen fu Beelsebul, den sa gi un nen di takru moro dati.” ");
INSERT INTO srnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesus taigi den boskopuman fu En moro fara taki: “Un no mus frede libisma. Bika ala sani san de na dungru o kon na krin, èn ala sani di kibri o kon na doro. ");
INSERT INTO srnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Den sani di Mi e taigi unu na dungru, un mus taki den na a krin fu dei. San Mi e taigi unu safri, un mus bari na strati. ");
INSERT INTO srnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Un no abi fu frede libisma. Den kan kiri soso a skin, ma den no man kiri a sili. Ma un mus frede Gado di kan meki a skin nanga a sili go pori ini hel. ");
INSERT INTO srnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Un sabi tak' yu kan bai tu gadotyo gi wan sensi. Ma toku no wan fu den e dede sondro tak' Gado un P'pa sabi fu en. ");
INSERT INTO srnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gado sabi srefi omeni wiwiri yu abi na tapu yu ede. ");
INSERT INTO srnNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dat' meki un no mus frede, bika un warti moro leki furu gadotyo. ");
INSERT INTO srnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","So dan, a sma di e taigi trawan tak' a sabi Mi, Mi sa taigi Mi P'pa na heimel tak' Mi sabi en. ");
INSERT INTO srnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma a sma di e taigi trawan tak' a no sabi Mi, Mi sa taigi Mi P'pa na heimel tu tak' Mi no sabi en.” ");
INSERT INTO srnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Un no mus prakseri tak' Mi kon fu tyari freide na grontapu. Mi no kon fu tyari freide, ma na prati Mi kon fu prati. ");
INSERT INTO srnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi kon fu tyari prati na mindri wan man nanga en p'pa, na mindri wan uma nanga en m'ma, èn na mindri wan uma nanga en masra m'ma. ");
INSERT INTO srnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Den feyanti fu yu sa de yu eigi ososma. ");
INSERT INTO srnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Suma lobi en m'ma noso en p'pa moro Mi, no warti fu waka na Mi baka. Sosrefi a sma di lobi en manpikin noso en umapikin moro Mi, no warti fu waka na Mi baka. ");
INSERT INTO srnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","A sma di no de klar'klari fu nyan pina te fu dede srefi te a e waka na Mi baka, no warti fu de wan sma fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A sma di wani hori en libi, o lasi en. Ma a sma di e poti en libi na wan sei fu Mi ede, o feni en.” ");
INSERT INTO srnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Suma opo en doro gi unu, e opo en gi Mi. Èn suma opo en doro gi Mi, e opo en gi a Wan di seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Suma opo en doro gi wan profeiti, fu di a de wan profeiti, sa kisi a srefi pai di Gado o gi a profeiti fu En. Èn suma opo en doro gi wan sma di bun ini Gado ai, fu di a de wan sma di bun ini Gado ai, sa kisi a srefi pai di Gado o gi a sma di bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Fu tru Mi e taigi un taki: Efu yu gi wan sma wan kan kowru watra nomo, fu di a e teki leri fu Mi, dan Gado no sa fergiti fu pai yu, awinsi a sma dati no de wan prenspari sma.” ");
INSERT INTO srnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Di Yesus kba taigi den twarfu man di ben e teki leri fu En ala den sani disi san den mus fu du, A kmoto drape go na ini den foto fu den Dyu fu preiki èn fu gi den sma leri. ");
INSERT INTO srnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A pisten dati Yohanes a Dopuman ben de na straf'oso. Di a yere fu den wroko san a Mesias ben e du, a seni wantu man di ben e teki leri fu en fu go aksi Yesus taki: ");
INSERT INTO srnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Na Yu na a Man di bo kon, noso wi mus ferwakti wan tra sma?” ");
INSERT INTO srnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesus piki den taki: “Un go taigi Yohanes san un yere nanga san un si. ");
INSERT INTO srnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Un taigi en tak' breniman e si baka, lanman e waka, gwasiman skin e kon bun baka, èn dofuman e yere. Owktu dedesma e wiki baka, èn pôtisma e yere a Bun Nyunsu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Blesi de tapu a sma di no lasi bribi ini Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Di den man fu Yohanes ben e gwe, Yesus bigin ferteri a bigi grupu sma drape fu Yohanes. A taigi den taki: “Di un ben go na ini a dreisabana, san un ben go fu luku? Un no ben go fu luku fa a winti e wai a grasi! ");
INSERT INTO srnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","San un ben go luku dan? Wan man di weri diri krosi? Nono. Sma di e weri diri krosi e tan ini kownu-oso. ");
INSERT INTO srnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Fu sanede un go dan? Fu si wan profeiti? Iya, Mi e taigi unu: A de wan profeiti, ma a no dati wawan. ");
INSERT INTO srnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bika fu Yohanes a skrifi taki: Yere, Mi e seni Mi boskopuman go na Yu fesi, di sa meki a pasi klari gi Yu. ");
INSERT INTO srnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Fu tru Mi e taigi un taki: Fu ala sma di gebore, no wan no prenspari moro Yohanes a Dopuman. Ma toku a moro pikinwan na mindri den sma di Gado e tiri, prenspari moro en. ");
INSERT INTO srnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sensi a ten di Yohanes a Dopuman bigin fu preiki, te leki now, moro nanga moro sma e kon ondro a tiri fu Gado. Ma tra sma de di e meki muiti fu puru sma fu a pasi fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moses nanga den profeiti ben taki fu a fasi fa Gado bo tiri libisma, te leki a ten di Yohanes bigin preiki. ");
INSERT INTO srnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A de na unu efu un wani bribi en, ma di den taki tak' Elia bo kon baka, na fu Yohanes den ben taki. ");
INSERT INTO srnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Suma abi yesi, meki a yere!” ");
INSERT INTO srnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yesus taigi den sma moro fara taki: “Yu sabi fa Mi e si unu fu a ten disi? Unu e du leki pikin di e prei tapu wan pren, dan unu e bari gi den trawan taki: ");
INSERT INTO srnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Un prei poku gi unu, ma un no dansi. Un singi dede-oso singi gi unu, ma un no krei. ");
INSERT INTO srnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bika di Yohanes kon, a ben tan furu leisi sondro fu nyan èn a no ben e dringi win. Dan den taki: ‘Wan takruyeye de na en tapu.’ ");
INSERT INTO srnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A Manpikin fu Libisma kon, A e nyan èn A e dringi. Ma fu En den e taki: ‘Luku, a man disi na wan akanswari nanga wan sopiman. Na wan mati fu den man di e piki edemoni nanga fu den sondusma.’ Ma den sani san Gado e du, e sori tak' a koni fu En bun.” ");
INSERT INTO srnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Dan Yesus bigin sori finga na tapu den sma fu den foto pe A ben du moro furu fu den bigi sani, bika den sma dati no ben drai den libi kon na Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","A taki: “Un sma fu Korasin nanga Betsaida, un mus luku bun! Bika efu den bigi sani di psa na un mindri, ben psa na ini den foto Tirus nanga Sidon, someni langa den sma dati bo drai den libi. Den bo weri rowkrosi èn trowe asisi tapu den ede fu sori tak' den e sari. ");
INSERT INTO srnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mi e taigi un taki: Tapu a dei di Gado o krutu libisma, a strafu fu unu o hebi moro di fu den sma fu Tirus nanga Sidon. ");
INSERT INTO srnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Un sma fu Kafarnaum, un e prakseri tak' un o doro na heimel? Na ini dedekondre un o feni unsrefi! Bika efu den bigi sani di psa ini a foto fu unu ben psa ini a foto Sodom, a foto dati bo de ete te nanga a dei fu tide. ");
INSERT INTO srnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ma Mi e taigi un taki: Tapu a dei di Gado o krutu libisma, a strafu fu unu o hebi moro di fu den sma fu Sodom.” ");
INSERT INTO srnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dan Yesus begi taki: “P'pa, Yu di de Masra fu heimel nanga grontapu, Mi e taki Yu tangi tak' Yu kibri den sani disi meki den koniman nanga den leriman no ferstan den, ma dan Yu sori den na den sma di no sabi furu. ");
INSERT INTO srnNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iya, P'pa, bika na so Yu ben wani en.” ");
INSERT INTO srnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dan Yesus taigi den sma taki: “Mi P'pa gi Mi makti abra ala sani. Boiti a P'pa, no wan sma no sabi suma na a Manpikin. Èn no wan sma no sabi suma na a P'pa, boiti a Manpikin nanga den sma di a Manpikin wani fu sabi dati.” ");
INSERT INTO srnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yesus taigi den sma moro fara taki: “Un kon na Mi, un di weri fu tyari un hebi lai. Na Mi un sa feni rostu. ");
INSERT INTO srnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kon meki Mi tiri unu èn un teki leri fu Mi. Bika Mi abi safri nanga sakafasi maniri. Na Mi un sa feni rostu fu un sili. ");
INSERT INTO srnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bika Mi no o tiri unu nanga tranga, èn den sani di Mi o aksi fu unu, no hebi.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wan syatu pisten baka dati Yesus nanga den man fu En ben e waka ini wan aleisigron tapu a sabadei. Dan den man fu En bigin broko wantu ai aleisi e nyan, bika angri ben e kiri den. ");
INSERT INTO srnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Di den Fariseiman si a sani dati, den taigi Yesus taki: “Luku, den man fu Yu e du wan sani san a wèt no wani fu un du tapu a sabadei.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesus piki den taki: “Un no leisi san David du, di angri ben e kiri en nanga den man di ben de nanga en? ");
INSERT INTO srnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A go ini a oso fu Gado, dan a teki den brede san den ben poti aparti gi Gado. Dan en nanga den man fu en nyan den brede disi, di soso den domri ben kan nyan. ");
INSERT INTO srnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","A skrifi tu ini a wèt fu Moses tak' den domri e broko a wèt fu a sabadei te den e wroko ini a mamakerki. Ma Gado no e si dati leki wan sondu. ");
INSERT INTO srnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ma Mi e taigi un taki: Wan sma de dya di bigi moro a mamakerki. ");
INSERT INTO srnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gadowortu e taki: Mi no wani den meti di un e tyari leki offer gi Mi, ma Mi wani fu un abi sari-ati nanga trawan. Efu un ben sabi san dati wani taki, dan un no bo krutu sma di Gado no krutu. ");
INSERT INTO srnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bika a Manpikin fu Libisma na a basi fu a sabadei.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus kmoto fu drape, dan A go na ini a kerki fu den. ");
INSERT INTO srnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Now wan man ben drape di ben abi wan malengri anu. Wantu sma ben e suku wan sani fu kan tyari Yesus go na krutu. Dat' meki den aksi En taki: “Yu kan dresi wan sma tapu a sabadei sondro fu broko a wèt?” ");
INSERT INTO srnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma Yesus taigi den taki: “Efu yu ben abi wan enkri skapu nomo, dan a fadon ini wan olo tapu a sabadei, yu no bo grabu en hari puru? ");
INSERT INTO srnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","We, wan libisma warti bari moro wan skapu. Dat' meki a fiti fu du bun tapu a sabadei.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dan Yesus taigi a man di ben abi a malengri anu taki: “Langa yu anu!” Di a man langa en anu, a kon gesontu leki a trawan. ");
INSERT INTO srnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma den Fariseiman kmoto fu drape go kruderi makandra fa den ben kan kiri Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma fu di Yesus ben sabi san den ben wani du, A kmoto drape. Furu sma ben waka na En baka, èn A dresi ala den sikisma di ben de na den mindri. ");
INSERT INTO srnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Dan A warskow den tranga tak' den no mus taigi no wan sma san A du. ");
INSERT INTO srnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Na so den sani san a profeiti Yesaya ben taki kon tru. A ben taki: ");
INSERT INTO srnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Luku, disi na Mi knekti di Mi teki fu wroko gi Mi. Mi lobi En, èn Mi abi prisiri nanga En. Mi sa poti Mi Yeye na En tapu. A sa ferteri den folku den sani san Gado feni bun. ");
INSERT INTO srnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A no sa meki babari, noso hari taki nanga sma. No wan sma sa yere En sten na strati. ");
INSERT INTO srnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A no o meki En moro hebi gi den swaki wan, èn A no o puru a pikinso howpu di den abi ete, te leki A meki tak' san Gado feni bun wini a strei. ");
INSERT INTO srnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Den folku sa poti den fertrow na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Baka dati den tyari wan man di ben abi wan takruyeye na en tapu, kon na Yesus. A man disi no ben man si èn a no ben man taki. Dan Yesus dresi a man fu a ben kan si èn fu a ben kan taki baka. ");
INSERT INTO srnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ala den sma drape ben ferwondru sote. Den aksi makandra taki: “Na En sa de a Manpikin fu David?” ");
INSERT INTO srnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma di den Fariseiman yere fu a sani disi, den taki: “Na Beelsebul, a edeman fu den takruyeye, e gi En makti fu yagi den takruyeye puru.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma Yesus ben sabi san den e prakseri, so A taigi den taki: “Ibri kondre pe den sma e feti nanga densrefi, o broko. Prati o de tu ini den foto nanga den oso pe den sma e feti nanga densrefi. ");
INSERT INTO srnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","So, efu Satan e yagi tra didibri, fa a o man tan rigeri dan? Bika prati de ini en kondre. ");
INSERT INTO srnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Èn efu na Beelsebul e gi Mi a krakti fu yagi takruyeye, suma e gi den sma fu unu a krakti dati dan? Dat' meki na den srefi o sori unu tak' un no abi leti. ");
INSERT INTO srnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma efu na a Yeye fu Gado e gi Mi a krakti fu yagi den takruyeye, dan dati e sori tak' Gado bigin tiri libisma kba. ");
INSERT INTO srnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bika wan sma no kan broko go ini a oso fu wan tranga man fu fufuru en sani, efu a no tai en fosi. Baka te a tai en, dan fosi a o man teki en sani tyari gwe. ");
INSERT INTO srnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Suma no de na Mi sei, e suku fu broko Mi. Èn suma no e wroko makandra nanga Mi, e tyari prati. ");
INSERT INTO srnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dat' meki Mi e taigi un taki: Libisma kan kisi pardon fu ala sondu, awinsi den afrontu Gado srefi. Ma a sma di e afrontu a Santa Yeye, no o kisi pardon. ");
INSERT INTO srnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Efu wan sma taki takru fu a Manpikin fu Libisma, a sa kisi pardon. Ma efu wan sma taki takru fu a Santa Yeye, noiti a sa kisi pardon: no ini a ten disi, no ini a ten di e kon.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesus taigi den Fariseiman moro fara taki: “Efu yu taki wan bon bun, dan den froktu fu en mus bun tu. Ma efu yu taki wan bon no bun, dan en froktu no kan bun tu. Bika yu e sabi fa a bon de te yu si den froktu fu en. ");
INSERT INTO srnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Un sneki unu! Un takru sote tak' un no man taki no wan bun sani. Bika san furu wan sma ati, na dati a e taki. ");
INSERT INTO srnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wan bun sma e taki bun sani fu di en ati bun. Ma wan takru sma e taki takru sani fu di en ati takru. ");
INSERT INTO srnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma Mi e taigi un taki: Tapu a dei di Gado o krutu libisma, den sma sa mus gi frantwortu fu ala wortu di no ben de fanowdu fu taki. ");
INSERT INTO srnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bika san un ben taki kan meki tak' Gado no o strafu unu, noso a kan meki tak' Gado strafu unu.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dan wantu sabiman fu Gado wèt, nanga wantu Fariseiman aksi Yesus taki: “Meister, un wani fu Yu sori unu wan marki.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma Yesus piki den taki: “Soso takru-ati sma leki unu di no e du san Gado wani, e suku wan marki. Ma a wan enkri marki san un o kisi, na a wan fu a profeiti Yona. ");
INSERT INTO srnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bika soleki fa Yona ben de dri dei nanga dri neti ini a bere fu a bigi fisi, na so a Manpikin fu Libisma sa de dri dei nanga dri neti dipi na ondro gron. ");
INSERT INTO srnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tapu a bigi krutu dei, den sma fu Nineve sa tnapu makandra nanga unu fu a ten disi èn den o krutu unu. Bika den ben drai den libi di Yona tyari a boskopu gi den. Ma luku, wan sma de dya di bigi moro Yona. ");
INSERT INTO srnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tapu a dei dati, a uma di ben tiri a kondre Seba sa tnapu makandra nanga unu fu a ten disi èn a sa krutu unu. Bika a ben kmoto fu wan farawe kondre kon arki a koni fu Salomo. Ma luku, wan sma de dya di bigi moro Salomo.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Te wan takruyeye kmopo na tapu wan sma, a e go na a dreisabana fu suku wan presi fu rostu, ma a no e feni. ");
INSERT INTO srnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Dan a e taki: ‘Mi o drai go baka na mi oso pe mi kmopo.’ Te a drai kon, a e si tak' a tanpresi leigi, a krin, èn ala sani de tapu en presi. ");
INSERT INTO srnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dan a e gwe go teki seibi tra takruyeye kon di ogri moro en. Den e kon inisei, èn den e tan drape. So, te fu kba a kon moro takru gi a sma leki na a bigin. Na so a sa de nanga den takru-ati sma leki unu fu a ten disi.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Di Yesus ben e taki nanga a bigi grupu sma, den brada fu En nanga En m'ma ben de na dorosei. Den ben wani taki nanga En. ");
INSERT INTO srnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dan wan sma taigi Yesus taki: “Yere, Yu m'ma nanga den brada fu Yu de na dorosei. Den wani taki nanga Yu.” ");
INSERT INTO srnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus piki a man di tyari a boskopu kon taki: “Suma na Mi m'ma dan, èn suma na den brada fu Mi?” ");
INSERT INTO srnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ne Yesus sori go na tapu den man di ben e teki leri fu En, dan A taki: “Den na Mi m'ma nanga den brada fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bika ala sma di e du a wani fu Mi P'pa di de na heimel, na Mi brada, Mi sisa, nanga Mi m'ma.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A srefi dei dati, Yesus kmoto fu oso go sidon na a syoro fu a meer. ");
INSERT INTO srnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Di wan bigi grupu sma bigin lontu En, A opo go sidon ini wan boto. Ma ala den sma tan tnapu na syoro. ");
INSERT INTO srnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dan A bigin leri den furu sani nanga agersitori. A taigi den taki: “Arki, wan man ben go sai siri na ini en gron. ");
INSERT INTO srnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Di a e fringi den siri, wantu fadon tapu a pasi. Dan den pikinfowru kon nyan den. ");
INSERT INTO srnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tra siri fadon pe furu ston ben de ondro a doti. Den sproiti es'esi, bika den no ben abi furu doti. ");
INSERT INTO srnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma di a son kon faya, a bron den pransun. Den drei gwe fu di den rutu no ben beri go dipi ini a gron. ");
INSERT INTO srnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Trawan fu den siri fadon tapu gron pe makamaka grasi e gro. Di a makamaka grasi bigin gro, a no gi den siri okasi fu gro doro. ");
INSERT INTO srnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma tra siri fadon tapu bun doti. Den dati gi nyanyan: sonwan gi wan hondro, trawan siksitenti, trawan dritenti tron moro furu. ");
INSERT INTO srnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Suma abi yesi, meki a yere!” ");
INSERT INTO srnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Baka dati den man di ben e teki leri fu Yesus kon na En, dan den aksi En taki: “Fu sanede Yu e taki agersitori nanga den sma?” ");
INSERT INTO srnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus piki den taki: “A fasi fa Gado o tiri libisma na wan kibritori. Gado meki un kon ferstan a kibritori disi. Ma A no wani meki den tra sma ferstan en. ");
INSERT INTO srnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bika a sma di ferstan a sani disi, Gado o meki a ferstan en moro, èn a sa sabi bun furu. Ma a sma di no ferstan en, Gado o puru a pikinso san a ben ferstan. ");
INSERT INTO srnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na dat' meki Mi e taki agersitori nanga den. Bika den e luku, ma den no e si, èn den e arki, ma den no e yere èn den no e ferstan. ");
INSERT INTO srnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Den sani san a profeiti Yesaya ben taki, de fu si ini a libi fu den sma disi. A ben taki: Yere un o yere, ma un no o ferstan noti, èn luku un o luku, ma un no o si noti. ");
INSERT INTO srnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bika a pipel disi trangayesi. Den no wani arki moro, èn den tapu den ai. Noso den bo si nanga den ai, den bo yere nanga den yesi, èn den bo ferstan nanga den ati tak' den mus drai den libi fu Mi kan dresi den. ");
INSERT INTO srnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma blesi de na un tapu, bika unu e si èn unu e yere. ");
INSERT INTO srnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Fu tru Mi e taigi un taki: Furu profeiti nanga sma di bun ini Gado ai, ben angri fu si san unu e si, ma den no si en. Den ben angri fu yere san unu e yere, ma den no yere en.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Dan Yesus taigi den man fu En taki: “Disi na san a agersitori fu a man di ben go sai siri wani taki. ");
INSERT INTO srnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Te wan sma arki a boskopu fa Gado e tiri libisma, ma a no ferstan en, dan a de leki a siri di fadon tapu a pasi. Didibri e kon puru a boskopu di sai na ini en ati. ");
INSERT INTO srnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A siri di fadon pe furu ston de ondro a doti, na den sma di yere a boskopu, dan den teki en wantron nanga prisiri. ");
INSERT INTO srnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma a boskopu no e beri rutu. Dat' meki den e bribi fu wan syatu pisten nomo. Te sma e pina den èn te sma de na den baka fu du den ogri fu di den e bribi a boskopu, dan wantron den e lasi bribi. ");
INSERT INTO srnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A siri di fadon pe makamaka grasi e gro, na den sma di yere a boskopu, ma den e broko den ede nanga a libi èn grontapu gudu e hari den. Dati e meki tak' a boskopu no man du en wroko ini den ati. ");
INSERT INTO srnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A siri di fadon na tapu a bun doti, na sma di e ferstan a boskopu te den yere en. Leki fa a siri e gi nyanyan, na so den sma disi e gi nyanyan ini den libi tu, sonwan hondro, trawan siksitenti, nanga trawan dritenti leisi moro furu.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Dan Yesus gi den ete wan agersitori. A taki: “Un kan si a fasi fa Gado e tiri libisma leki wan man di ben sai bun siri ini en gron. ");
INSERT INTO srnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma di ala sma ben e sribi, a feyanti fu en kon sai grasi mindri a aleisi, dan a gwe. ");
INSERT INTO srnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Leki fa a aleisi bigin gro èn a bigin gi nyanyan, so a grasi gro tu. ");
INSERT INTO srnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dan den knekti fu a man go aksi en taki: ‘Masra, a no bun siri yu ben sai ini yu gron? Pe a grasi kmopo dan?’ ");
INSERT INTO srnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A man piki den taki: ‘Na wan feyanti du a sani dati.’ ");
INSERT INTO srnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Dan den knekti aksi en taki: ‘San un mus du? Un mus hari a grasi puru?’ Ma a man taigi den taki: ‘No, bika te unu e hari a grasi, un kan hari a aleisi tu. ");
INSERT INTO srnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Meki ala tu gro te leki a ten doro fu koti a aleisi. Dan mi o taigi den sma di o koti a aleisi fu puru a grasi fosi, tai en ini bosu, dan den bron en. Ma a aleisi den mus poti ini mi maksin.’ ” ");
INSERT INTO srnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus gi den a agersitori disi tu. A taki: “Un kan si a fasi fa Gado e tiri libisma, leki wan mosterdsiri di wan sma prani ini en gron. ");
INSERT INTO srnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A de a moro pikin siri san de, ma te a gro kon, a bigi moro ala den tra spesreibon di sma e prani. A e tron wan bon pe pikinfowru kan frei go meki den nesi.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A gi den wan tra agersitori taki: “Un kan si a fasi fa Gado e tiri libisma leki dyesi di wan frow teki poti ini bun furu blon. Dan a dyesi e meki ala a blon kon sweri.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus ferteri a bigi grupu sma ala den sani disi nanga agersitori. Tra fasi A no ben taki nanga den. ");
INSERT INTO srnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na so a sani san a profeiti ben taki kon tru. A ben taki: Mi sa leri den sma nanga agersitori. Mi sa tyari den sani kon na krin san ben kibri sensi di grontapu meki. ");
INSERT INTO srnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Baka dati Yesus seni a bigi grupu sma gwe, dan A go na oso. Dan den man fu En kon aksi En taki: “Yu kan taigi unu san a agersitori fu a grasi ini a gron wani taki?” ");
INSERT INTO srnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus piki den taki: “A Manpikin fu Libisma na a man di e sai a bun siri. ");
INSERT INTO srnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A gron na grontapu. Den bun siri na den sma di Gado e tiri. ");
INSERT INTO srnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A grasi na den sma di e waka na didibri baka. A feyanti di sai a grasi na didibri. A ten fu koti den lepi nyanyan na a kba fu a ten disi. Den sma di o koti den lepi nyanyan na den engel. ");
INSERT INTO srnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Leki fa den e tyari a grasi kon na wan fu bron ini faya, so a sa de na a kba fu a ten disi. ");
INSERT INTO srnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A Manpikin fu Libisma sa seni den engel fu En go mindri den sma di Gado e tiri. Den sa puru ala sani san e meki den sma sondu, nanga ala sma di e du kruktu. ");
INSERT INTO srnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Den engel sa fringi den go ini a faya onfu, pe den sa krei èn kaw den tifi. ");
INSERT INTO srnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma den sma di bun ini Gado ai, sa brenki leki a son te den P'pa na heimel o tiri libisma. Suma abi yesi, meki a yere!” ");
INSERT INTO srnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Un kan si a fasi fa Gado e tiri libisma, leki wan gudu di beri ini wan gron. Wan man feni en, èn a beri en baka. A breiti sote tak' a e go seri ala sani san a abi, èn a e bai a gron. ");
INSERT INTO srnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Un kan si a fasi fa Gado e tiri libisma, leki wan man di e suku moi parelkrara fu bai. ");
INSERT INTO srnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Di a feni wan san warti furu, a go seri ala sani san a abi, èn a bai en. ");
INSERT INTO srnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Un kan si a fasi fa Gado e tiri libisma, leki wan fis'neti san den fringi go ini se, èn san e fanga ala sortu fisi. ");
INSERT INTO srnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te a furu, den e hari en kon na syoro. Dan den sma e sidon puru ala fisi di bun fu nyan, poti ini baskita. Ma den wan san no bun fu nyan, den e trowe. ");
INSERT INTO srnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na so a sa de na a kba fu a ten disi. Den engel sa go fu puru den sma di no e du Gado wani na mindri den sma di bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dan den sa fringi den go ini a faya onfu, pe den sa krei èn kaw den tifi.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dan Yesus aksi den man fu En taki: “Un ferstan ala den sani disi?” Den piki: “Iya, Masra.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dan Yesus taigi den taki: “Ibri sabiman fu Gado wèt di e teki leri fu a fasi fa Gado e tiri libisma, de leki wan man di abi wan maksin fu pe a e tyari nyun sani nanga owru sani kon na doro.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Di Yesus kba taki den agersitori disi, A kmoto pe A ben de, ");
INSERT INTO srnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","dan A go na a foto pe A ben kweki. Drape A gi den sma leri ini a kerki fu den. Di den sma yere fa A e gi leri, den tnapu nanga opo mofo. Den taki: “Pe A feni a koni disi? Èn pe A feni a makti fu du den bigi sani? ");
INSERT INTO srnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A p'pa fu En na a temreman. A m'ma fu En na Maria, èn den brada fu En na Yakobus, Yosef, Simon nanga Yudas. ");
INSERT INTO srnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ala den sisa fu En e libi dya. Pe A kmopo nanga ala den sani disi dan?” ");
INSERT INTO srnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dat' meki den no ben wani yere noti fu En. Ma Yesus taigi den taki: “Ala sma e lespeki wan profeiti, boiti den sma fu a foto pe a kweki nanga den ososma fu en.” ");
INSERT INTO srnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","So Yesus no du furu bigi sani drape, bika den sma no ben e bribi. ");
INSERT INTO srnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ini a srefi pisten dati Herodes, a tiriman fu a distrikti Galilea, ben kisi fu yere san den sma e ferteri fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Dan a taigi den knekti fu en taki: “A mus de Yohanes a Dopuman, di kon na libi baka. Na dat' meki A abi makti fu du den bigi sani.” ");
INSERT INTO srnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodes taki so bika a ben trow nanga Herodias, a frow fu en brada Filipus. Ma Yohanes ben taigi en taki: “Yu no kan trow nanga en.” Dan Herodes meki den grabu Yohanes, bui en poti na ini straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A ben wani kiri en, ma a ben frede a folku, bika den ben e si Yohanes leki wan profeiti. ");
INSERT INTO srnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma tapu a friyari dei fu Herodes, a umapikin fu Herodias ben dansi gi Herodes nanga den sma di a ben kari. Herodes ben abi sowan prisiri nanga a pikin, ");
INSERT INTO srnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tak' a meki wan sweri. A taki: “Awinsi san a pikin sa aksi, mi sa gi en.” ");
INSERT INTO srnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dan a m'ma fu a pikin meki a aksi Herodes fu a gi en a ede fu Yohanes a Dopuman na ini wan preti. ");
INSERT INTO srnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes ben sari fu a sani disi. Ma fu di a ben meki a sweri na fesi ala den sma di ben de na tafra nanga en, a komanderi den srudati fu gi a pikin san a ben aksi. ");
INSERT INTO srnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","So a meki den kapu Yohanes ede puru ini a straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dan den tyari a ede ini wan preti kon gi a pikin, èn a pikin tyari en go gi en m'ma. ");
INSERT INTO srnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Baka dati den man di ben e teki leri fu Yohanes, kon teki a dedeskin tyari go beri. Dan den go taigi Yesus san psa. ");
INSERT INTO srnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Di Yesus yere tak' den kiri Yohanes, A kmoto fu pe A ben de, dan A teki wan boto go na wan presi pe En wawan ben kan de. Ma bun furu sma yere dati. So den libi den foto, dan den waka nanga futu go na En baka. ");
INSERT INTO srnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Di Yesus kmoto ini a boto, A si wan bigi grupu sma. Ne A kisi wan dipi sari gi den, èn A dresi ala den sikisma di ben de na den mindri. ");
INSERT INTO srnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Di a son bigin saka, den man fu Yesus kon na En, dan den taigi En taki: “Sma no e libi dya pe un de, èn a lati kba. Seni ala den sma gwe, fu den kan go bai nyanyan ini den dorpu.” ");
INSERT INTO srnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma Yesus piki den taki: “Den sma no abi fu gwe. Na unu mus gi den wan sani fu nyan.” ");
INSERT INTO srnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Den man fu En piki En taki: “Ala san un abi dya na feifi brede nomo, nanga tu fisi.” ");
INSERT INTO srnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesus taki: “Tyari den kon gi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dan A taigi ala den sma fu go sidon ini a grasi. A teki den feifi brede nanga den tu fisi, A luku go na heimel dan A blesi den. Baka dati A broko den brede, dan A gi den man fu En fu den prati gi den sma. ");
INSERT INTO srnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ala den sma nyan te den bere furu. Baka dati den man fu Yesus furu twarfu baskita nanga den pis'pisi di ben tan abra. ");
INSERT INTO srnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wan feifi dusun mansma so ben nyan. Umasma nanga pikin no ben teri ete. ");
INSERT INTO srnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesus taigi den man fu En fu den bigin go nanga a boto na a tra sei fu a meer. Dan En bo kon te A seni a bigi grupu sma gwe. ");
INSERT INTO srnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Baka di Yesus seni den gwe, A kren go tapu a bergi pe En wawan ben kan de fu begi. Di neti tapu na En wawan ben drape. ");
INSERT INTO srnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A ten dati a boto ben de fara fu a syoro kba, èn wan tranga winti ben e tyari bigi skwala kon na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma musudei mamanten Yesus waka tapu a watra go na den. ");
INSERT INTO srnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Di den man fu En si tak' A e waka tapu a watra, den skreki. Den bari fu frede taki: “Na wan takrusani!” ");
INSERT INTO srnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma Yesus taigi den wantron taki: “No lasi ati! Na Mi! Un no abi fu frede!” ");
INSERT INTO srnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dan Petrus taigi En taki: “Masra, efu na Yu, dan taigi mi meki mi waka tapu a watra kon na Yu.” ");
INSERT INTO srnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ne Yesus taigi en taki: “Kon!” So Petrus kmoto ini a boto, èn a bigin waka tapu a watra go na Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma di Petrus si den skwala, a kon frede dan a bigin sungu. Ne a bari: “Masra, yepi mi!” ");
INSERT INTO srnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wantron Yesus langa En anu grabu en. Dan A taigi en taki: “A bribi fu yu pikin! Fu sanede yu no e tan bribi Mi?” ");
INSERT INTO srnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Di den go ini a boto, a winti tapu fu wai. ");
INSERT INTO srnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ne den man fu Yesus fadon tapu den kindi na En fesi fu anbegi En. Den taki: “Fu tru, Yu na a Manpikin fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Di den doro na a tra sei fu a meer, den go na syoro na a kontren di den e kari Genesaret. ");
INSERT INTO srnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Fa den sma drape si tak' na Yesus, wantron den panya a boskopu ini a heri birti. Dan den sma tyari ala den sikisma kon na En. ");
INSERT INTO srnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Den begi En efu den sikisma ben kan fasi a lantyi fu En krosi nomo. Èn ala sma di fasi En ben kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Baka dati wantu Fariseiman nanga sabiman fu Gado wèt kmoto fu Yerusalem kon na Yesus. Dan den aksi En taki: ");
INSERT INTO srnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Fu sanede den man fu Yu no e du san den bigisma fu unu leri unu? ");
INSERT INTO srnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bika den no e wasi den anu fosi den nyan.” Yesus piki den taki: “Ma fu sanede unu e poti a wèt fu Gado na wan sei fu du san den bigisma fu unu leri unu? ");
INSERT INTO srnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bika Gado taki: ‘Un mus lespeki un m'ma nanga un p'pa.’ Moro fara A taki: ‘A sma di fluku en m'ma noso en p'pa, mus dede.’ ");
INSERT INTO srnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma unu e taki tak' efu wan sma taigi en m'ma nanga en p'pa taki: ‘Mi gi Gado ala sani san un ben kan kisi fu mi,’ dan a no abi fu lespeki den moro. ");
INSERT INTO srnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","So unu no e teri a wortu fu Gado moro, fu du san den bigisma fu unu ben leri unu. ");
INSERT INTO srnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Un hoigriman unu! Yesaya ben abi leti di a taki fu unu taki: ");
INSERT INTO srnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","A folku disi e gi Mi grani nanga den mofo, ma den no lobi Mi srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na fu soso den e anbegi Mi, bika den e leri den sma sani san libisma srefi meki.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesus kari ala den sma kon krosbei, dan A taigi den taki: “Arki Mi èn ferstan bun san Mi e taigi unu. ");
INSERT INTO srnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A no san wan sma e nyan, ma na san a sma e taki, e meki tak' a no krin ini Gado ai.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dan den man fu Yesus kon taigi En taki: “Yu sabi tak' den Fariseiman mandi di den yere san Yu taki?” ");
INSERT INTO srnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesus piki den taki: “Mi P'pa di de na heimel sa hari ala sani puru di A no ben prani. ");
INSERT INTO srnNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Un libi den. Den de leki breniman di wani tyari tra breniman waka. Ma efu wan breniman e tyari wan tra breniman waka, den ala tu o fadon ini wan olo.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ne Petrus aksi Yesus taki: “Taigi unu san a agersitori disi wani taki.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dan Yesus piki en taki: “Na ferstan un no man ferstan den sani ete di Mi e taki? ");
INSERT INTO srnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Un no man ferstan tak' ala sani san wan sma e nyan, e go na ini en bere, dan a e kmoto baka pe a mus kmoto? ");
INSERT INTO srnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma den sani san wan sma e taki, e kmoto ini en ati, èn na dati e meki tak' a no krin ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bika den sani san e kmoto ini a ati fu wan sma na takru prakseri, kiri, huru, takru lostu, fufuru, lei gi trawan, nanga taki takru fu trawan. ");
INSERT INTO srnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dati na den sani di e meki tak' wan sma no krin ini Gado ai. Ma fu nyan sondro tak' yu wasi yu anu fosi, no e meki tak' wan sma no krin ini Gado ai.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus kmoto drape, dan A go ini a kontren fu den foto Tirus nanga Sidon. ");
INSERT INTO srnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dan luku, wan Kananiti-uma fu a birti dati kon na Yesus. A bari taki: “Masra, Manpikin fu David, abi sari-ati nanga mi! Bika takruyeye e pina mi umapikin.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma Yesus no piki a uma noti. Dan den man fu En kon taigi En taki: “Seni a uma gwe, bika a e waka nomonomo na un baka e meki babari.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus piki taki: “Gado seni Mi kon soso gi den sma fu Israel, bika den de leki skapu di lasi pasi.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma a uma kon kindi na Yesus fesi, dan a taki: “Masra, yepi mi!” ");
INSERT INTO srnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ne Yesus piki en taki: “A no bun fu puru a brede na a mofo fu den pikin, trowe gi den dagu.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma a uma piki baka taki: “Masra, Yu abi leti. Ma den dagu srefi e nyan a sakasaka san e fadon fu a tafra fu den basi.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ne Yesus piki a uma taki: “Uma, a bribi fu yu bigi fu tru. Yu sa kisi san yu e aksi.” A srefi momenti dati a umapikin fu a frow kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Dan Yesus gwe fu drape. A waka na seisei fu a Meer fu Galilea, dan A kren go sidon tapu wan bergi. ");
INSERT INTO srnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Di A go sidon drape, wan bun bigi grupu sma kon na En. Den tyari sma kon poti na Yesus futusei di ben lan, di ben malengri, di ben breni, di ben babaw, nanga furu tra sikisma moro. Dan A dresi den. ");
INSERT INTO srnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ala den sma drape ben ferwondru, bika den si fa babawsma e taki baka, malengrisma e kon betre, lansma e waka baka èn brenisma e si. Dan den sma gi a Gado fu Israel glori. ");
INSERT INTO srnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus kari den man fu En kon, dan A taigi den taki: “Mi e sari den sma, bika na dri dei langa kba den de dya nanga Mi, èn den no abi noti fu nyan. Mi no wani seni den gwe sondro fu den nyan, bika den kan flaw na pasi.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Den man fu En piki En taki: “Pe wi o feni nofo brede fu gi sowan bigi grupu sma nyanyan? Bika sma no e libi ini a birti dya.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ne Yesus aksi den taki: “Omeni brede un abi?” Den taki: “Un abi seibi brede, nanga wantu pikin fisi.” ");
INSERT INTO srnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dan Yesus taigi ala den sma fu go sidon na gron. ");
INSERT INTO srnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A teki den seibi brede nanga den fisi. A taki Gado tangi, dan A broko den èn A gi den man fu En fu prati gi den sma. ");
INSERT INTO srnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ala den sma nyan te den bere furu. Dan den man fu Yesus furu seibi baskita nanga den pis'pisi di ben tan abra. ");
INSERT INTO srnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na fo dusun mansma ben nyan. Umasma nanga pikin no ben teri ete. ");
INSERT INTO srnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Baka di Yesus seni ala den sma gwe, A go ini a boto dan A go na a kontren fu Magadan. ");
INSERT INTO srnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Den Fariseiman nanga den Saduseiman ben kon na Yesus. Dan fu tesi En, den aksi En fu sori den wan marki di kmopo fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma Yesus piki den taki: “Efu mofoneti a heimel redi, dan unu sabi tak' tamara un o abi wan moi dei. ");
INSERT INTO srnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma efu mamanten a heimel redi èn a dungrudungru, dan un e sabi tak' alen o kon. Fa unu man luku loktu fu sabi fa a dei o de, ma unu no man ferstan den sani san un e si now? ");
INSERT INTO srnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Soso takru-ati sma leki unu, di no e du san Gado wani, e suku wan marki. Ma a wan enkri marki san un o kisi, na a marki fu Yona.” Dan Yesus waka gwe libi den. ");
INSERT INTO srnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Di den man fu Yesus koti a meer abra, den ben fergiti fu tyari brede. ");
INSERT INTO srnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ne Yesus taigi den taki: “Un mus luku bun nanga a dyesi fu den Fariseiman nanga den Saduseiman.” ");
INSERT INTO srnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dan den man bigin taki a tori nanga makandra. Den taki: “Na fu di un no tyari brede meki A taki so.” ");
INSERT INTO srnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma Yesus ben sabi san den e taki, dat' meki A taigi den taki: “A bribi fu un pikin! Fu sanede un e taigi makandra tak' brede no de? ");
INSERT INTO srnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Un ai no man opo ete? Un no e memre tak' nanga feifi brede Mi gi moro leki feifi dusun sma fu nyan? Un fergiti tu omeni baskita un ben furu di den sma kba nyan? ");
INSERT INTO srnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Un no e memre tak' nanga seibi brede Mi gi moro leki fo dusun sma fu nyan? Un fergiti tu omeni baskita un ben furu di den sma kba nyan? ");
INSERT INTO srnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Fa un no man ferstan tak' a no fu brede Mi ben taki, ma tak' un mus luku bun nanga a dyesi fu den Fariseiman nanga den Saduseiman!” ");
INSERT INTO srnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dan fosi den kon ferstan tak' A no ben taki fu dyesi fu meki brede, ma tak' den mus luku bun nanga a leri fu den Fariseiman nanga den Saduseiman. ");
INSERT INTO srnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Di Yesus doro ini a birti fu a foto Sesarea Filipi, A aksi den man fu En taki: “Suma den sma e taki tak' a Manpikin fu Libisma de?” ");
INSERT INTO srnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Den taigi En taki: “Son sma e taki: Yu na Yohanes a Dopuman. Tra sma e taki: Yu na Elia. Trawan baka e taki: Yu na Yeremia noso wan fu den tra profeiti.” ");
INSERT INTO srnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dan Yesus aksi den taki: “Ma unu, suma unu e taki tak' Mi de?” ");
INSERT INTO srnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ne Simon Petrus piki En taki: “Yu na a Mesias, a Manpikin fu a libi Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus piki en taki: “Simon, manpikin fu Yona, blesi de na yu tapu. Bika a no libisma tyari a sani disi kon na krin gi yu, ma na Mi P'pa di de na heimel. ");
INSERT INTO srnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dat' meki Mi o kari yu Petrus. Bika tapu a ston disi Mi sa bow Mi gemeente èn dede srefi no sa man wini en. ");
INSERT INTO srnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi sa gi yu a makti fu tyari sma kon ondro a tiri fu Gado. San yu no wani fu psa na grontapu, Gado no o meki psa, èn san yu wani fu psa na grontapu, Gado o meki psa.” ");
INSERT INTO srnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dan Yesus warskow den man fu En krin fu den no taigi no wan sma tak' En na a Mesias. ");
INSERT INTO srnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sensi a ten dati, Yesus bigin sori den man fu En tak' A mus go na Yerusalem. Drape A o nyan furu pina fu den fesiman fu a folku, fu den prenspari domri, nanga den sabiman fu Gado wèt. A sori den tak' sma o kiri En, ma tapu a di fu dri dei Gado o meki A kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma Petrus kari Yesus go na wan sei, dan a taigi En taki: “Masra, Yu no mus taki so! Gado no o meki den sani dati miti Yu srefsrefi.” ");
INSERT INTO srnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma Yesus drai taigi Petrus taki: “Kmoto na Mi tapu, Satan! Yu e tapu pasi gi Mi. Bika yu no e prakseri den sani fu Gado, ma na libisma sani yu e prakseri.” ");
INSERT INTO srnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dan Yesus taigi den man fu En taki: “Efu wan sma wani waka na Mi baka, a mus poti en eigi wani na wan sei. A mus de klar'klari fu nyan pina, èn a mus kon nanga Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bika a sma di wani tan libi fa a wani, o lasi en libi. Ma a sma di e poti en libi na wan sei fu Mi ede, o feni en. ");
INSERT INTO srnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bika san yu e wini efu yu kisi ala sani fu grontapu, ma yu lasi yu libi? Èn san wan sma o man gi fu kisi en libi baka? ");
INSERT INTO srnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bika a Manpikin fu Libisma o kon nanga a bigi makti fu En P'pa, makandra nanga den engel fu En, dan A o krutu ibri sma fu den sani san a ben du. ");
INSERT INTO srnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Fu tru Mi e taigi un taki: Son sma de dya na un mindri di no sa dede fosi den si a Manpikin fu Libisma kon fu tiri sma.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Siksi dei baka dati, Yesus teki Petrus nanga den tu brada Yakobus nanga Yohanes, tyari go na tapu wan hei bergi pe den wawan ben kan de. ");
INSERT INTO srnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dan let' na den fesi a skin fu Yesus kenki. En fesi ben brenki leki a son, èn En krosi ben kon weti tak' a e brenki leki wan krin faya. ");
INSERT INTO srnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dan wantron so Moses nanga Elia ben de fu si, e taki nanga Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ne Petrus taigi Yesus taki: “Masra, a bun tak' wi de dyaso. Efu Yu wani, mi kan meki dri tenti dya: wan gi Yu, wan gi Moses nanga wan gi Elia.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus no ben kba taki ete, di wan brenki wolku saka kon na den tapu. Dan wan sten taki kmopo ini a wolku taki: “Disi na Mi Manpikin di Mi lobi. Mi abi prisiri nanga En. Un mus arki san A e taki.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Di den man fu Yesus yere a sten, den skreki sote tak' den trowe densrefi langalanga na gron. ");
INSERT INTO srnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma Yesus go na den, A fasi den, dan A taigi den taki: “Opo, un no abi fu frede.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Di den opo den ai, den si Yesus wawan. ");
INSERT INTO srnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Di den e saka fu a bergi Yesus warskow den taki: “Un no mus taigi no wan sma san un si, te leki a Manpikin fu Libisma dede èn kon baka na libi.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dan den aksi En taki: “Fu sanede den sabiman fu Gado wèt e taki tak' Elia mus kon fosi a Mesias doro?” ");
INSERT INTO srnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus piki den taki: “Elia o kon fu tru, èn a o seti ala sani. ");
INSERT INTO srnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma Mi e taigi un taki: Elia kon kba, ma den no ben sabi tak' na en, dan den du nanga en san den ben wani. Na so a Manpikin fu Libisma o abi fu nyan pina fu den tu.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","So den man fu Yesus kon ferstan tak' A ben e taki fu Yohanes a Dopuman. ");
INSERT INTO srnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Di den doro pe a bigi grupu sma ben de, wan man kon na Yesus, a kindi na En fesi dan a taki: ");
INSERT INTO srnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Masra, abi sari-ati nanga a boi fu mi. A abi stoipi-siki èn a e pina srefsrefi. Furu leisi a e fadon ini faya noso watra. ");
INSERT INTO srnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi ben tyari en go na den man di e teki leri fu Yu, ma den no ben man dresi en.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus piki en taki: “Ai baya! Yu kan si tak' un no e bribi, èn tak' un ati takru. Olanga Mi mus tan nanga unu? Olanga Mi mus teki den sani disi fu unu ete?” Dan A taigi a man taki: “Tyari a boi kon gi Mi!” ");
INSERT INTO srnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ne Yesus bari a takruyeye èn a kmoto tapu a boi. A srefi momenti dati a boi kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Dan den man fu Yesus kon na En. Di den ben de den wawan nanga En, den aksi En taki: “Fu sanede un no ben man yagi a takruyeye puru tapu a boi?” ");
INSERT INTO srnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus piki den taki: “Bika a bribi fu unu no bigi nofo. Fu tru Mi e taigi un taki: Efu a bribi fu unu bigi leki wan mosterdsiri nomo, un kan taigi a bergi disi: ‘Kmopo dya go drape,’ èn a o kmopo go. Un o man du ala sani. ");
INSERT INTO srnNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ma den sortu takruyeye disi e kmoto soso te yu e begi èn faste.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Di den doro baka ini Galilea, Yesus taigi den man fu En taki: “Den o gi a Manpikin fu Libisma abra na ini anu fu sma. ");
INSERT INTO srnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Den o kiri En. Ma baka dri dei Gado o meki A kon na libi baka.” Di den yere dati, den sari srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Di Yesus nanga den man fu En doro na Kafarnaum, den man di ben piki moni fu a mamakerki go aksi Petrus efu a Meister fu en e pai a moni fu a mamakerki. Petrus piki den taki: “Iya, A e pai en.” ");
INSERT INTO srnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Di Petrus doro na oso, Yesus fosi aksi en taki: “Simon, san yu e prakseri fu a sani disi? Suma den kownu fu grontapu e meki pai edemoni? Den sma fu den eigi kondre, noso den sma fu tra kondre?” ");
INSERT INTO srnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus piki taki: “Den sma fu tra kondre.” Dan Yesus taigi en taki: “Dati wani taki den sma fu a kondre srefi no abi fu pai. ");
INSERT INTO srnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma fu den ati no bron na wi tapu, wi o pai en. Go na a meer go uku. Te yu opo a mofo fu a fosi fisi di yu kisi, yu o si wan solfrumoni ini en. Teki en, dan yu go pai a moni gi Mi nanga yu.” ");
INSERT INTO srnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A srefi momenti dati, den man fu Yesus kon aksi En taki: “Suma na a moro prenspari wan na mindri den sma di Gado e tiri?” ");
INSERT INTO srnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ne Yesus kari wan pikin kon, A poti en tnapu na den mindri, ");
INSERT INTO srnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","dan A taki: “Fu tru Mi e taigi un taki: Efu un no kenki a fasi fa unu e prakseri èn teki den maniri fu wan pikin, dan un no man tron wan sma di Gado e tiri. ");
INSERT INTO srnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","A sma di abi sakafasi leki a pikin disi, na a moro prenspari wan na mindri den sma di Gado e tiri. ");
INSERT INTO srnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A sma di opo en doro gi sowan pikin ini Mi nen, e opo en gi Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma a sma di e meki wan fu den pikinwan disi di e bribi ini Mi fadon ini sondu, mus luku bun! A bo moro bun gi en efu a ben sungu nanga wan bigi ston na en neki ini a moro dipi pisi fu a se. ");
INSERT INTO srnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Grontapu de fu sari fu den sani di e meki sma sondu. Sani o kon di wani meki sma sondu, ma a sma di e tyari den kon mus luku bun! ");
INSERT INTO srnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","So efu yu anu noso yu futu e meki yu sondu, kapu en puru dan yu trowe en gwe. A moro betre tak' yu malengri ma yu kisi a libi fu têgo, dan tak' den trowe yu nanga tu anu noso tu futu go ini a faya di noiti e dede. ");
INSERT INTO srnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Èn efu na yu ai e meki yu sondu, diki en puru dan yu trowe en gwe. A moro betre tak' yu kisi a libi fu têgo nanga wan ai, dan tak' den fringi yu go nanga ala tu ai ini a faya fu hel. ");
INSERT INTO srnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Luku bun tak' un no si no wan fu den pikinwan disi leki noti. Mi e taigi un taki: Den engel fu den de ala ten na fesi fu Mi P'pa di de na heimel. ");
INSERT INTO srnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bika a Manpikin fu Libisma kon fu ferlusu den sma di lasi pasi.” ");
INSERT INTO srnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“San un e prakseri fu a tori disi? Efu wan sma abi wan hondro skapu, dan a lasi wan fu den. San un denki tak' a o du? A sa libi den neigitenti-na-neigi (99) trawan ini den bergi pe den de, dan a e go suku a wan di lasi. ");
INSERT INTO srnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Fu tru Mi e taigi un taki: Efu a feni en, a e breiti moro nanga a skapu dati dan nanga den neigitenti-na-neigi trawan di no ben lasi. ");
INSERT INTO srnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","We, na so un P'pa na heimel no wani tak' wan fu den pikinwan disi mus go lasi.” ");
INSERT INTO srnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus taigi den moro fara taki: “Efu yu si tak' yu brada du wan sondu, go na en dan yu e sori en tapu en fowtu te yu nanga en wawan de. Efu a arki yu, yu meki tak' a e tan wan brada. ");
INSERT INTO srnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma efu a no wani arki yu, dan yu mus teki wan noso tu sma leki kotoigi nanga yu. Bika wan sani tru, efu tu noso dri kotoigi taki tak' na so a de. ");
INSERT INTO srnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Efu baka dati a no wani arki un ete, dan un mus taigi a gemeente. Èn efu a no wani arki srefi san a gemeente e taigi en, dan un mus si en leki wan sma di no sabi Gado, noso leki wan fu den man di e piki edemoni.” ");
INSERT INTO srnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Fu tru Mi e taigi un taki: San un no wani fu psa na grontapu, Gado no o meki psa, èn san un wani fu psa na grontapu, Gado o meki psa. ");
INSERT INTO srnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mi e taigi un ete wan leisi taki: Efu dya na grontapu tu fu unu e agri fu begi gi a srefi sani, awinsi san, dan Mi P'pa na heimel sa gi unu san un aksi En. ");
INSERT INTO srnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bika pe tu noso dri sma di e bribi ini Mi kon makandra, drape Mi de na den mindri.” ");
INSERT INTO srnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dan Petrus kon aksi Yesus taki: “Masra, omeni leisi mi mus gi mi brada pardon te a du mi wan sani? ");
INSERT INTO srnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Te nanga seibi leisi?” Yesus piki en taki: “Mi e taigi yu taki: A no seibi leisi nomo, ma seibitenti tron seibi leisi. ");
INSERT INTO srnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bika a fasi fa Gado e tiri den sma fu En, de leki wan kownu di seni kari ala den knekti fu en di ben mus pai en. ");
INSERT INTO srnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Di a du dati, den tyari wan man kon di ben mus pai en tin dusun gowtumoni. ");
INSERT INTO srnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma a man no ben man pai a paiman. Dat' meki a kownu teki a besroiti fu seri en nanga en frow, nanga den pikin fu en, nanga ala sani san a ben abi fu a kan kisi en moni baka. ");
INSERT INTO srnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ma a knekti fadon tapu en kindi, dan a begi a kownu taki: ‘Abi pasensi nanga mi. Mi o pai yu ala baka.’ ");
INSERT INTO srnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ne a kownu kisi sari-ati nanga a man. A meki a gwe èn a no ben abi fu pai a moni moro. ");
INSERT INTO srnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ma di a man dati e gwe, a miti nanga wan tra knekti di ben mus pai en wan hondro kopromoni. A grabu en na en neki, dan a taigi en taki: ‘Gi mi a moni san yu mus pai mi.’ ");
INSERT INTO srnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Now a tra knekti fadon tapu en kindi, dan a begi en taki: ‘Abi pasensi nanga mi. Mi sa pai yu baka.’ ");
INSERT INTO srnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ma a man di ben mus kisi a moni no ben wani. A tyari en go sroto, te leki a ben man pai a moni baka. ");
INSERT INTO srnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Di den tra knekti si san psa, a hati den. Dan den go ferteri a kownu. ");
INSERT INTO srnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ne a kownu seni kari a man, dan a taigi en taki: ‘Yu lagiman yu! Di yu begi mi tangitangi, mi taigi yu tak' yu no abi fu pai mi moro. ");
INSERT INTO srnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Fu sanede yu no sari a tra man leki fa mi sari yu?’ ");
INSERT INTO srnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ne a kownu ati bron nanga a man. A meki den grabu en, tyari gwe go strafu te leki a ben man pai ala a moni.” ");
INSERT INTO srnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Dan Yesus taigi den man fu En taki: “Na so Mi P'pa di de na heimel sa du nanga ibriwan fu unu, efu un no e gi trawan pardon nanga un heri ati.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Di Yesus kba taki den sani disi, A kmoto ini Galilea, dan A koti a Yordanliba abra go na Yudea. ");
INSERT INTO srnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Drape bun furu sma ben waka na En baka, èn A dresi ala den sikiwan na den mindri. ");
INSERT INTO srnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dan wantu Fariseiman kon na Yesus fu tesi En. Den aksi En taki: “Wan man kan broko trow nanga en frow fu ala sortu sani ede?” ");
INSERT INTO srnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus piki den taki: “Un no leisi san skrifi ini Gadobuku? A skrifi tak' sensi di Gado ben meki libisma, A meki den leki man nanga uma. ");
INSERT INTO srnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A skrifi moro fara taki: ‘Fu dat'ede wan man sa gwe libi en m'ma nanga en p'pa fu go libi nanga en frow. Dan den tu sma disi sa de leki wan enkri sma.’ ");
INSERT INTO srnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","So den no de tu sma moro, ma den de leki wan. Èn san Gado tyari kon na wan, libisma no mus prati.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dan den Fariseiman aksi En taki: “Ma fu sanede Moses skrifi tak' efu un e broko trow nanga un frow, dan un mus gi en wan brifi tak' a trow broko?” ");
INSERT INTO srnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus piki den taki: “A no ben de so ini a bigin. Ma fu di unu no wani du san Gado taki, meki Moses gi un pasi fu broko trow. ");
INSERT INTO srnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma Mi e taigi un taki: A man di broko trow sondro tak' en frow huru gi en, e libi wan huru libi efu a trow baka.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dan den man fu Yesus taigi En taki: “Efu na so a trow tori de, dan a moro betre fu no trow.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma Yesus taigi den taki: “A no ala sma kan ferstan a sani disi, ma soso den sma di Gado wani. ");
INSERT INTO srnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Son sma gebore na sowan fasi tak' den no man trow. Trawan de di na sma meki tak' den no man trow. Trawan de baka di no wani trow fu den kan wroko gi Gado di e tiri den leki Kownu. Suma man ferstan, meki a ferstan a sani disi.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Den sma ben tyari den pikin kon na Yesus fu A poti En anu na den tapu èn begi gi den. Ma den man fu Yesus bari den sma fu no du dati. ");
INSERT INTO srnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ne Yesus taigi den taki: “Meki den pikin kon na Mi. No tapu den, bika na sma leki den pikin disi, Gado e tiri.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Baka di Yesus poti En anu na den tapu, A gwe fu drape. ");
INSERT INTO srnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wan man kon na Yesus, dan a aksi En taki: “Meister, sortu bun mi mus du fu kan kisi a libi fu têgo?” ");
INSERT INTO srnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus piki en taki: “Fu sanede yu e aksi Mi san bun? Na Gado wawan bun. Ma efu yu wani kisi a libi fu têgo, dan yu mus hori den wèt fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A man aksi Yesus: “Sortu wan fu den?” Yesus piki en taki: “Yu no mus kiri trawan, yu no mus huru, yu no mus fufuru, yu no mus lei gi trawan, ");
INSERT INTO srnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","yu mus lespeki yu m'ma nanga yu p'pa, èn yu mus lobi tra sma soleki fa yu lobi yusrefi.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A yonkuman piki Yesus taki: “Ala den wèt disi mi e hori. San e mankeri mi ete?” ");
INSERT INTO srnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ne Yesus piki en taki: “Efu yu wani de bun sondro fowtu, go seri san yu abi, dan yu e prati a moni gi den pôtisma. So yu o abi wan gudu na heimel. Baka dati yu e kon waka na Mi baka.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Di a yonkuman yere san Yesus taki, a gwe nanga sari, bika a ben abi furu gudu. ");
INSERT INTO srnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dan Yesus taigi den man fu En taki: “Fu tru Mi e taigi un taki: A sa tranga gi wan guduman fu a poti ensrefi ondro a tiri fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi e taigi unu ete wan leisi taki: A moro makriki gi wan asaw fu psa ini wan nanai-olo, dan fu wan guduman poti ensrefi ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Di den man fu Yesus yere a sani dati, den ferwondru srefsrefi. Den aksi En taki: “Suma Gado o man ferlusu dan?” ");
INSERT INTO srnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus luku den man fu En, dan A taigi den taki: “Libisma no man du en, ma Gado kan du ala sani.” ");
INSERT INTO srnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dan Petrus taki: “Ma luku, wi libi ala sani san wi ben abi fu waka na Yu baka. Sortu pai Gado o gi wi dan?” ");
INSERT INTO srnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus piki den taki: “Fu tru Mi e taigi un taki: Te a Manpikin fu Libisma o meki ala sani kon nyun baka, dan A sa sidon tapu En kownusturu san e sori tak' A abi ala makti. Dan unu di waka na Mi baka sa sidon tapu twarfu kownusturu fu tiri den twarfu lo fu Israel. ");
INSERT INTO srnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Èn ibri sma di libi en oso, noso en brada nanga en sisa, noso en m'ma nanga en p'pa, noso en pikin nanga en gron fu Mi ede, sa kisi hondro tron so moro leki san a ben libi. Èn a sa kisi a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma furu fosiwan o tron lastewan, èn furu lastewan o tron fosiwan.” ");
INSERT INTO srnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Un kan si a fasi fa Gado e tiri libisma, leki wan man di abi wan gron. Fruku mamanten a go suku wrokoman fu kon wroko gi en ini en droifidyari. ");
INSERT INTO srnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A meki mofo nanga den wrokoman fu pai den wan deimoni, dan a seni den go ini en droifidyari. ");
INSERT INTO srnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Neigi yuru mamanten a man go na strati, dan a si tra wrokoman e tnapu na wowoyo di no ben feni wroko ete. ");
INSERT INTO srnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ne a man taigi den taki: ‘Un go wroko na ini mi droifidyari tu. Mi sa pai un san fiti.’ ");
INSERT INTO srnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","So den man go. Twarfu yuru nanga dri yuru bakadina a man go na strati baka, dan a du a srefi sani. ");
INSERT INTO srnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Di a go feifi yuru bakadina na strati, a miti tra wrokoman di ben tnapu drape ete. Dan a aksi den taki: ‘Fu sanede un tnapu heri dei dya sondro fu wroko?’ ");
INSERT INTO srnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Den man piki en taki: ‘Bika no wan sma kon aksi unu fu go wroko gi en.’ Ne a man taigi den taki: ‘Un go wroko tu na ini mi droifidyari.’ ");
INSERT INTO srnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Di neti tapu, a basi fu a droifidyari taigi en fesiman taki: ‘Kari den wrokoman, dan yu pai den. Bigin na den lastewan di kon wroko, go na den fosiwan.’ ");
INSERT INTO srnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Di den man kon di ben bigin wroko feifi yuru, den kisi a moni fu wan heri dei. ");
INSERT INTO srnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","So den man di ben bigin wroko fruku mamanten prakseri tak' den bo kisi moro furu. Ma ibriwan fu den kisi soso a moni fu wan dei. ");
INSERT INTO srnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Di den kisi a moni, den bigin krut'krutu nanga a basi. ");
INSERT INTO srnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Den taki: ‘Den man di kon leki laste, wroko wan yuru nomo. Ma unu ben wroko tranga heri dei ini a faya son. Dan fa yu kan gi den a srefi moni leki unu?’ ");
INSERT INTO srnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ma a man piki wan fu den taki: ‘Mi mati, mi no bedrigi yu. Un ben meki mofo tak' mi bo pai yu wan deimoni. ");
INSERT INTO srnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","So yu kan teki yu moni, dan yu gwe. Na mi wani gi den lastewan a srefi leki yu. ");
INSERT INTO srnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mi kan du nanga mi moni san mi wani. Na dyarusu yu e dyarusu fu di mi e du trawan bun?’ ” ");
INSERT INTO srnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dan Yesus taigi den sma taki: “Den lastewan sa tron den fosiwan, èn den fosiwan sa tron den lastewan.” ");
INSERT INTO srnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Di Yesus ben de na pasi fu go na Yerusalem, A kari den twarfu man fu En kon na wan sei, dan A taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Luku, un de na pasi fu go na Yerusalem. Drape den o gi a Manpikin fu Libisma abra na den prenspari domri nanga den sabiman fu Gado wèt. Den man dati sa teki a besroiti tak' A mus dede. ");
INSERT INTO srnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dan den o gi En abra na den sma di no de Dyu fu den teki En leki spot'popki. Den o wipi En èn den o spikri En na wan kroisi. Ma baka dri dei Gado o meki A kon na libi baka.” ");
INSERT INTO srnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Dan a frow fu Sebedeus nanga den tu boi fu en kon na Yesus. A kindi na En fesi fu aksi En wan sani. ");
INSERT INTO srnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Dan Yesus aksi en taki: “San yu wani?” A frow piki En taki: “Pramisi Mi tak' den tu boi disi fu mi, sa sidon na Yu let'anu sei nanga Yu kruktu-anu sei te Yu o rigeri leki Kownu.” ");
INSERT INTO srnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma Yesus piki den taki: “Un no sabi san un e aksi. Un sa man nyan a pina di Mi o abi fu nyan?” Den piki En taki: “Wi o man.” ");
INSERT INTO srnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dan Yesus taigi den taki: “Fu tru, un sa nyan a pina fu Mi, ma a no Mi e taki suma o sidon na Mi let'anu sei nanga Mi kruktu-anu sei. Mi P'pa libi den presi dati gi den sma di A wani fu sidon drape.” ");
INSERT INTO srnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Di den tra tin man yere a tori disi, den mandi nanga den tu brada. ");
INSERT INTO srnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dat' meki Yesus kari den alamala kon, dan A taigi den taki: “Un sabi tak' den tiriman fu den folku e rigeri abra den sma fu den, èn den sma di abi makti e dwengi den fu du san den wani. ");
INSERT INTO srnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma unu no mus du leki den. Efu wan fu unu wani de wan prenspari sma, dan a mus dini den trawan. ");
INSERT INTO srnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Èn a sma di wani de a fosiwan na un mindri, mus de leki wan srafu gi den trawan. ");
INSERT INTO srnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bika a Manpikin fu Libisma, no kon fu sma dini En. Ma A kon fu dini trawan èn fu gi En libi fu meki furu sma kon fri.” ");
INSERT INTO srnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Di Yesus nanga den man fu En kmopo fu Yeriko, bun furu sma ben waka na En baka. ");
INSERT INTO srnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dan luku, tu breniman ben sidon na seipasi. Di den yere tak' Yesus e psa, den bigin bari taki: “Masra, Manpikin fu David, abi sari-ati nanga wi!” ");
INSERT INTO srnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A heri grupu sma bari den fu den tapu den mofo, ma den man bigin bari moro tranga taki: “Masra, Manpikin fu David, abi sari-ati nanga wi!” ");
INSERT INTO srnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ne Yesus tan tnapu. A kari den breniman kon na En, dan A aksi den taki: “San un wani tak' Mi mus du gi unu?” ");
INSERT INTO srnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Den piki En taki: “Masra, un wani si.” ");
INSERT INTO srnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dan Yesus firi sari gi den breniman. A fasi den na den ai èn wantron den ben man si. Dan den bigin waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus nanga den man fu En ben kon krosbei fu Yerusalem. Di den doro na a dorpu Betfaga ini a birti fu a Oleifbergi, A seni tu man fu En go na fesi. ");
INSERT INTO srnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A taigi den taki: “Un go na a dorpu san de na un fesi. Leki fa un doro, un o si wan buriki san den sma tai drape. Wan yongu buriki o de nanga en. Lusu den, dan un tyari den kon gi Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Efu wan sma sa aksi unu wan sani, dan un mus taigi en taki: ‘Masra abi den fanowdu. Te A kba, A sa seni den wantron kon baka.’ ” ");
INSERT INTO srnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na so a sani san a profeiti ben taki kon tru. A ben taki: ");
INSERT INTO srnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Taigi den sma fu Yerusalem taki: Luku, un kownu e kon na unu nanga sakafasi. A e sidon tapu wan buriki, tapu wan yongu buriki. ");
INSERT INTO srnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dan den man fu Yesus go du san A taigi den. ");
INSERT INTO srnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Den tyari a buriki nanga en pikin kon, dan den bradi den krosi na den tapu, meki Yesus go sidon. ");
INSERT INTO srnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wan bun bigi grupu sma bradi den krosi tapu a pasi gi En. Trawan koti taki puru na den bon, dan den poti den tapu a pasi. ");
INSERT INTO srnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bun furu sma ben e waka na En fesi nanga na En baka, e bari taki: Hosana gi a Manpikin fu David! Blesi de tapu a Wan di e kon ini a nen fu Masra! Hosana! Prijse Gado di de na heimel! ");
INSERT INTO srnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Di Yesus doro na Yerusalem, a heri foto kon dyugudyugu. Den sma aksi taki: “Suma na En?” ");
INSERT INTO srnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Den sma di ben waka na Yesus baka, piki den taki: “Disi na Yesus fu Nasaret, a profeiti di kmopo fu Galilea.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Baka dati Yesus go ini a mamakerki fu den Dyu, dan A yagi ala den sma gwe di ben e bai sani noso seri sani drape. A drai den tafra tapu fu den man di ben e broko moni. A du a srefi sani nanga den sturu fu den man di ben e seri doifi. ");
INSERT INTO srnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yesus taigi den taki: “A skrifi taki: ‘Mi oso mus de wan presi fu begi.’ Ma unu e meki a tron wan nesi fu fufuruman.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dan den brenisma nanga sma di ben lan kon na Yesus ini a mamakerki èn A dresi den. ");
INSERT INTO srnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma den prenspari domri nanga den sabiman fu Gado wèt mandi di den si den wondru di Yesus ben e du, nanga a fasi fa den pikin ben e bari ini a mamakerki: “Hosana gi a Manpikin fu David!” ");
INSERT INTO srnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Dat' meki den aksi Yesus taki: “Yu no e yere san den pikin e taki?” Yesus piki den taki: “Iya, Mi e yere den. Ma noiti un no leisi tak' a skrifi taki: Yongu pikin nanga nyunyun pikin sa prijse yu soleki fa a fiti?” ");
INSERT INTO srnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dan Yesus gwe libi den. A kmoto ini Yerusalem, dan A go psa a neti na Betania. ");
INSERT INTO srnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Fruku mamanten di Yesus ben e drai go baka na Yerusalem, angri bigin kiri En. ");
INSERT INTO srnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dan A si wan figabon na sei pasi. A waka go na a bon, ma A no feni noti leki soso wiwiri. Ne Yesus taigi a bon taki: “Noiti moro yu sa gi froktu.” A srefi momenti dati a bon drei gwe. ");
INSERT INTO srnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Di den man fu Yesus si a sani dati, den ferwondru. Den aksi En taki: “Fa a du kon tak' a bon drei gwe so esi?” ");
INSERT INTO srnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus piki den taki: “Fu tru Mi e taigi un taki: Efu un e bribi sondro fu frede tak' a no o psa, un o man du san Mi du nanga a figabon. Ma a no dati wawan. Efu un taigi a bergi disi srefi taki: ‘Opo, go trowe yusrefi ini a se!’ a sa psa. ");
INSERT INTO srnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Efu un e bribi, un sa kisi ala sani san un o aksi Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Di Yesus doro na a mamakerki, A bigin gi den sma leri. Dan den prenspari domri nanga den fesiman fu a folku, kon aksi En taki: “Pe Yu feni a leti fu du den sani san Yu e du? Suma gi Yu a makti fu du den sani disi?” ");
INSERT INTO srnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus piki den taki: “Mi wani aksi un wan sani tu. Efu un piki Mi, dan Mi sa taigi unu suma gi Mi a makti fu du den sani san Mi e du.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dan A aksi den taki: “Suma ben gi Yohanes a makti fu dopu sma? Gado noso libisma?” Den man taki a tori nanga makandra. Den taki: “Efu un taki: ‘Na Gado,’ dan A o aksi unu: ‘Fu sanede un no ben bribi en dan?’ ");
INSERT INTO srnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma efu un taki: ‘Na libisma,’ dan den sma ati o bron na un tapu, bika den e si Yohanes leki wan profeiti.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","So den piki Yesus taki: “Un no sabi.” Ne Yesus taigi den taki: “We, dan Mi srefi no o taigi unu pe Mi feni a leti fu du den sani disi.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Dan Yesus taigi den taki: “San un e prakseri fu a tori disi? Wan man ben abi tu boi. A go na a fosiwan, dan a taigi en taki: ‘Mi boi, go wroko tide ini a droifidyari.’ ");
INSERT INTO srnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A boi piki taki: ‘Mi no wani.’ Ma bakaten en konsensi fon en, dan a go. ");
INSERT INTO srnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dan a p'pa go na a trawan, dan a taigi en a srefi sani. A dati piki en p'pa taki: ‘A bun, p'pa.’ Ma a no go.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dan Yesus aksi den man taki: “Sortu wan fu den tu boi du a wani fu den p'pa?” Den piki taki: “A fosi wan.” Ne Yesus taigi den taki: “Fu tru Mi e taigi un taki: Den man di e piki edemoni nanga den uma di e huru, sa kon fosi unu ondro a tiri fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bika Yohanes ben sori un fa un kan kon bun ini Gado ai, ma un no bribi en. Ma den man di e piki edemoni nanga den uma di e huru, bribi en. Un si dati, ma toku un no kenki un prakseri bakaten fu bribi en tu.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus taigi den man moro fara taki: “Un yere wan tra agersitori. Wan man ben prani droifibon ini en gron. A skotu en lontu, dan a mesre wan baki pe den ben kan masi den droifi te den lepi. Dan a meki wan wakti-oso san ben bow go na loktu. Baka dati a yuru a droifidyari gi tra sma, dan a go na wan tra kondre. ");
INSERT INTO srnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Di a ten doro fu piki den droifi, a seni wantu knekti fu en go teki den droifi san a ben mus kisi na den man di ben yuru a droifidyari. ");
INSERT INTO srnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma den man grabu den knekti. Den fon wan fu den, den kiri wan trawan èn den fringi ston na tapu a di fu dri. ");
INSERT INTO srnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Baka dati a man seni tra knekti go, moro furu leki a fosi leisi. Ma den man du den srefi sani nanga den tu. ");
INSERT INTO srnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Te fu kba, a man seni en manpikin go na den. A prakseri taki: ‘Den no sa du den sani dati nanga mi manpikin.’ ");
INSERT INTO srnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ma di den man di ben yuru a gron si a manpikin, den taigi makandra taki: ‘Na a boi disi o kisi a gron te en p'pa dede. Kon meki un kiri en, dan unu o kisi a gron.’ ");
INSERT INTO srnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","So den grabu a boi, den srepi en go na dorosei fu a droifidyari, dan den kiri en.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ne Yesus aksi den man taki: “San un e prakseri tak' a man di abi a droifidyari o du nanga den man te en srefi kon?” ");
INSERT INTO srnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Den man piki Yesus taki: “A o meki den takru-ati man disi dede wan moro hati dede. Dan a o yuru a droifidyari gi tra sma di sa gi en den droifi te a mus kisi den.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ne Yesus taigi den taki: “Un srefi leisi ini a Santa Buku taki: A ston di den mesreman feni tak' no bun, na a srefi ston dati tron a moro prenspari ston fu a heri oso. Disi na Masra wroko, èn un e ferwondru fu si dati. ");
INSERT INTO srnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Dat' meki Mi e taigi un taki: Gado no o tiri unu moro, ma A o tiri wan tra folku di e du En wani. ");
INSERT INTO srnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Suma fadon tapu a ston disi, o broko ala en bonyo. Èn efu a ston disi fadon na tapu wan sma, a o masi en tron wan doni.” ");
INSERT INTO srnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Di den prenspari domri nanga den Fariseiman yere den agersitori fu Yesus, den kon ferstan tak' na den A e taki. ");
INSERT INTO srnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dat' meki den ben wani grabu En, ma den ben frede fu ala den sma, bika den ben e si Yesus leki wan profeiti. ");
INSERT INTO srnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Dan Yesus bigin taki baka nanga den sma ini agersitori. A taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Un kan si a fasi fa Gado e tiri libisma, leki wan kownu di bo hori wan trow-oso gi en manpikin. ");
INSERT INTO srnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A seni den knekti fu en go kari den sma di a ben aksi fu kon na a trow-oso, ma den sma no ben wani kon. ");
INSERT INTO srnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","So a seni tra knekti fu go taigi den sma taki: ‘Arki, a nyanyan klari. Mi srakti den kaw nanga den tra fatu meti. Ala sani seti kba. Un kon na a trow-oso!’ ");
INSERT INTO srnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ma den sma no ben wani arki, èn den go du den eigi sani: a wan go na en gron, a trawan go na en wenkri. ");
INSERT INTO srnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Trawan fu den grabu den knekti, den fon den, dan den kiri den. ");
INSERT INTO srnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ne a kownu ati bron. A seni srudati fu go kiri den kiriman disi, èn fu bron a foto fu den. ");
INSERT INTO srnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dan a taigi den knekti fu en taki: ‘Ala sani seti kba gi a trow-oso, ma den sma di ben mus kon no ben warti fu mi kari den. ");
INSERT INTO srnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Un go na den uku fu den strati, dan un kari ala sma di un si drape fu kon na a trow-oso.’ ");
INSERT INTO srnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","So den knekti go na den strati, èn den tyari ala sma kon di den miti, bun wan nanga ogri wan. Èn den sma furu a presi pe a trow-oso ben hori. ");
INSERT INTO srnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ma di a kownu kon inisei fu luku den sma di kon, en ai fadon tapu wan man di no ben weri krosi di fiti fu go na wan trow-oso. ");
INSERT INTO srnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dan a kownu aksi en taki: ‘Mi mati, fa yu du kon dya sondro tak' yu weri krosi di fiti fu go na wan trow-oso?’ Ma a man no ben man piki en noti. ");
INSERT INTO srnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dan a kownu taigi den man fu en taki: ‘Tai en na en anu nanga en futu, dan un fringi en go na dorosei ini a dungru pe a sa krei èn kaw en tifi.’ ” ");
INSERT INTO srnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dan Yesus taigi den sma taki: “Gado e kari furu sma kon, ma A e teki wantu nomo.” ");
INSERT INTO srnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dan den Fariseiman gwe go kruderi fa den bo man kisi Yesus fu A taki wan sani san no bun. ");
INSERT INTO srnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","So den seni wantu man di ben e teki leri fu den go na Yesus, makandra nanga wantu man fu Herodes. Den aksi Yesus taki: “Meister, wi sabi tak' Yu na wan man di no e kori sma, èn Yu e leri unu a pasi fu Gado leki fa a de. Yu no abi bisi nanga san sma e taki fu Yu, èn ala sma na a srefi gi Yu. ");
INSERT INTO srnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ma taigi unu: San Yu e prakseri fu a tori disi? A fiti fu pai edemoni na a grankownu fu den Romeinisma, efu no?” ");
INSERT INTO srnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Yesus ben sabi tak' na kori den ben wani kori En. Dat' meki A taigi den taki: “Un hoigriman! Fu sanede un e pruberi fu tesi Mi? ");
INSERT INTO srnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sori Mi a moni san un mus pai.” Dan den sori Yesus a moni. ");
INSERT INTO srnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A aksi den taki: “Suma fesi nanga suma nen de na en tapu?” ");
INSERT INTO srnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Den piki En taki: “A di fu a grankownu.” Ne Yesus piki den taki: “Dan un gi a grankownu san na fu en, èn un gi Gado san na fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Di den man yere san Yesus taki, den ferwondru, dan den libi En èn den gwe. ");
INSERT INTO srnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A srefi dei dati, wantu Saduseiman kon na Yesus. Den man disi no ben e bribi tak' dedesma o kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Dan den taigi Yesus taki: “Meister, Moses ben leri unu tak' efu wan man dede sondro fu kisi pikin, dan en brada mus trow nanga a frow fu meki pikin gi en brada di dede. ");
INSERT INTO srnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Now seibi brada ben de na un mindri. A fosiwan trow, èn a dede. Fu di a no ben abi pikin, a libi en frow na baka gi en brada. ");
INSERT INTO srnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ma dan a srefi sani miti a di fu tu nanga a di fu dri brada te kon miti a di fu seibi. ");
INSERT INTO srnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Te fu kba, a frow srefi kon dede. ");
INSERT INTO srnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Te den dedesma o kon na libi baka, sortu wan fu den brada sa abi a frow disi leki en trow-uma? Bika den alamala ben trow nanga en.” ");
INSERT INTO srnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus piki den taki: “Un fowtu srefsrefi! Bika un no sabi san skrifi ini a Santa Buku, èn un no sabi a krakti fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Te den dedesma o kon na libi baka, den no sa trow nanga makandra. Bika den o de leki den engel na heimel. ");
INSERT INTO srnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Un no leisi dan san Gado taigi unu fu a tori efu libisma o kon na libi baka? ");
INSERT INTO srnNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Gado ben taki: ‘Mi na a Gado fu Abraham, Isak, nanga Yakob.’ So un e si tak' Gado a no Gado fu dedesma, ma fu sma di e libi.” ");
INSERT INTO srnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ala den sma di yere san Yesus taki ben ferwondru srefsrefi fu a fasi fa A ben e gi leri. ");
INSERT INTO srnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Di den Fariseiman yere tak' Yesus tapu a mofo fu den Saduseiman, den kon makandra. ");
INSERT INTO srnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dan wan fu den di ben sabi a wèt bun, kon na Yesus fu tesi En. A aksi En taki: ");
INSERT INTO srnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Meister, sortu wan fu den wèt na a moro prenspari wan?” ");
INSERT INTO srnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus piki en taki: “Yu mus lobi Masra, yu Gado, nanga yu heri ati, nanga yu heri sili, èn nanga yu heri ferstan. ");
INSERT INTO srnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A dati na a fosi wèt èn na a moro prenspari wan. ");
INSERT INTO srnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma wan trawan de di prenspari leki a fosiwan. A dati e taki: Yu mus lobi tra sma soleki fa yu lobi yusrefi. ");
INSERT INTO srnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ala sani san Moses nanga den profeiti leri unu, de ini den tu wèt disi.” ");
INSERT INTO srnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Di den Fariseiman ben de makandra, Yesus aksi den taki: ");
INSERT INTO srnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“San un e prakseri fu a Mesias? Suma pikin A de?” Den Fariseiman piki taki: “A de wan bakapikin fu David.” ");
INSERT INTO srnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus taigi den taki: “Dan fa a Santa Yeye kan meki David kari En ‘Masra’? ");
INSERT INTO srnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bika David ben taki: Masra Gado taigi mi Masra taki: Kon sidon na Mi let'anu sei te leki Mi poti den feyanti fu Yu ondro Yu futu. ");
INSERT INTO srnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","We, efu David kari a Mesias en Masra, dan fa A kan de en bakapikin dan?” ");
INSERT INTO srnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","No wan sma ben man piki En tapu a aksi disi. Èn sensi a dei dati no wan sma ben prefuru fu aksi En wan sani baka. ");
INSERT INTO srnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dan Yesus taigi den man fu En, nanga a bigi grupu sma di ben e waka na En baka, taki: ");
INSERT INTO srnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Den sabiman fu Gado wèt nanga den Fariseiman abi a wroko fu leri unu a wèt fu Moses. ");
INSERT INTO srnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dat' meki un mus du èn un mus hori unsrefi na ala sani san den e taigi unu fu du. Ma un no mus du den sani san den e du. Bika den e leri sma a wèt, ma den srefi no e du san a wèt e taki. ");
INSERT INTO srnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Den e dwengi sma fu hori den moro hebi pisi fu a wèt, ma den srefi no e broko den ede nanga den. ");
INSERT INTO srnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na soso sma ai sani den e du. Luku o bradi den e meki den banti san den e weri nanga den wortu fu Gado na en tapu! Luku o langa den e meki den franya na den krosi! ");
INSERT INTO srnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Den lobi fu sidon na den moro prenspari presi te den go nyan na sma oso. So tu den e sidon na den moro bun presi ini den kerki. ");
INSERT INTO srnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Den lobi te sma e gi den lespeki odi na wowoyo, èn te sma e kari den ‘leriman’. ");
INSERT INTO srnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma un no mus meki sma kari un ‘leriman’, bika un alamala na brada èn un abi wan enkri Leriman nomo. ");
INSERT INTO srnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Un no mus kari no wan sma dya na grontapu un ‘p'pa’, bika un abi wan enkri P'pa nomo èn dati na Gado di de na heimel. ");
INSERT INTO srnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Un no mus meki sma kari un ‘fesiman’, bika un abi wan enkri Fesiman nomo èn dati na a Mesias. ");
INSERT INTO srnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A moro prenspari sma na un mindri, mus dini den trawan. ");
INSERT INTO srnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bika a sma di e opo ensrefi, Gado o broko en saka. Èn a sma di e saka ensrefi, Gado o opo en.” ");
INSERT INTO srnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Un sabiman fu Gado wèt nanga Fariseiman, un mus luku bun! Un hoigriman unu! Un no wani kon ondro a tiri fu Gado, ma dan un e tapu pasi gi den sma di wani kon. ");
INSERT INTO srnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Un sabiman fu Gado wèt nanga Fariseiman, un mus luku bun! Un hoigriman unu! Unu e puru den oso na a anu fu den uma di masra dede kba, dan un e begi langabere begi fu sma denki tak' un bun. Fu dat'ede unu o kisi moro hebi strafu. ");
INSERT INTO srnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Un sabiman fu Gado wèt nanga Fariseiman, un mus luku bun! Un hoigriman unu! Bika un e waka heri grontapu lontu fu feni wan sma di wani teki a bribi fu unu. Ma te un feni en, un e meki tak' a kon tu tron moro ogri leki unsrefi, fu a kan go na hel pe unsrefi o go. ");
INSERT INTO srnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Un mus luku bun! Un de leki breniman di wani tyari trawan waka! Bika un e leri den sma taki: ‘A no abi trobi efu wan sma sweri tapu a Santa Presi, ma efu a sweri tapu a gowtu di de ini a Santa Presi, dan a mus du san a taki.’ ");
INSERT INTO srnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Un don èn un breni! San moro prenspari? A gowtu, noso a Santa Presi di e meki a gowtu kon santa? ");
INSERT INTO srnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Un e leri den sma tu taki: ‘A no abi trobi efu wan sma sweri tapu a altari, ma efu a sweri tapu a offer di de tapu a altari, dan a mus du san a taki.’ ");
INSERT INTO srnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Un breniman unu! San moro prenspari? A offer, noso a altari di e meki a offer kon santa? ");
INSERT INTO srnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","So efu wan sma e teki a altari sweri, a e sweri tu na a sani san de na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Efu wan sma e teki a Santa Presi sweri, a e sweri tu na a Wan di e libi ini a Santa Presi. ");
INSERT INTO srnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sosrefi efu wan sma e teki heimel sweri, a e sweri na a kownusturu fu Gado nanga a Wan di e sidon na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Un sabiman fu Gado wèt nanga Fariseiman, un mus luku bun! Un hoigriman unu! Bika un e gi Gado tin prosenti fu den moro pikin spesrei di un prani, ma un no e du den moro prenspari sani fu a wèt. Un no e krutu sma tapu wan leti fasi, un no abi sari-ati gi trawan, èn Gado nanga libisma no kan bow na un tapu. A bun fu du a wan sani, ma dan un mus du den tra sani tu. ");
INSERT INTO srnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Un de leki breniman di wani tyari trawan waka! Un e doro ala sani san un e dringi fu puru a moro pikin freifrei, ma dan un e swari wan heri asaw! ");
INSERT INTO srnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Un sabiman fu Gado wèt nanga Fariseiman, un mus luku bun! Un hoigriman unu! Un e wasi dorosei fu a kan nanga a preti, ma dan un e lai den nanga sani san un fufuru èn san un wani abi nomonomo. ");
INSERT INTO srnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Un breni Fariseiman! Un krin inisei fu a kan nanga a preti fosi, dan dorosei sa kon krin tu. ");
INSERT INTO srnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Un sabiman fu Gado wèt nanga Fariseiman, un mus luku bun! Un hoigriman unu! Un gersi grebi di krin moi na dorosei, ma fu inisei den lai nanga dedesma bonyo nanga ala sortu pori sani. ");
INSERT INTO srnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Na so a de nanga unu tu. Na dorosei un gersi sma di bun ini Gado ai, ma fu inisei un lai nanga hoigrifasi èn un no e lespeki a wèt.” ");
INSERT INTO srnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Un sabiman fu Gado wèt nanga Fariseiman, un mus luku bun! Un hoigriman unu! Bika un e meki moi grebi fu memre den profeiti nanga den sma di ben libi bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dan un e taki: ‘Efu na unu ben libi ini a ten fu den afo fu unu, un no bo yepi den fu kiri den profeiti.’ ");
INSERT INTO srnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ma nanga dati unu srefi e kotoigi tak' unu na bakapikin fu den sma di kiri den profeiti. ");
INSERT INTO srnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Go doro dan fu klari a wroko di den afo fu unu ben bigin. ");
INSERT INTO srnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Un sneki unu! Un takru sneki unu! Fa un kan prakseri tak' Gado no o krutu unu fu go na hel? ");
INSERT INTO srnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Un yere. Mi o seni profeiti gi unu, nanga koniman nanga trawan di o leri unu Gadowortu. Un o kiri sonwan fu den, èn trawan un o spikri na wan kroisi. Trawan baka un o wipi ini den kerki fu unu, èn un o go fu a wan foto na a trawan fu du den ogri. ");
INSERT INTO srnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dan so Gado o meki unu pai fu a brudu di fadon na gron fu ala den bun sma, bigin fu a bun man Abel, kon te na Sakarias, a manpikin fu Berekya, di den kiri mindri a altari nanga a Santa Presi fu a Oso fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Fu tru Mi e taigi un taki: Den sma fu a ten disi o pai fu ala den sani disi.” ");
INSERT INTO srnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Dan Yesus taki: “Ai, Yerusalem, Yerusalem, yu di e kiri den profeiti èn di e ston den sma kiri di Gado seni kon na yu! Mi kari den pikin fu yu someni leisi fu kon na Mi, soleki fa wan mamafowru e kari en pikin kon ondro en frei. Ma un no ben wani. ");
INSERT INTO srnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Luku, a oso fu unu o tan leigileigi na baka. ");
INSERT INTO srnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bika Mi e taigi un taki: Un no o si Mi moro te leki a dei di un taki: Blesi de tapu a Man di e kon ini a nen fu Masra.” ");
INSERT INTO srnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Baka di Yesus kba taki ala den sani disi, A kmoto ini a mamakerki. Di a gwe, den man fu En bigin sori En tapu den bigi oso di ben de ini a dyari fu a mamakerki. ");
INSERT INTO srnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ne Yesus taigi den taki: “Un e si ala den sani disi? Fu tru Mi e taigi un taki: Den alamala o broko te na gron. No wan ston o tan na tapu wan trawan.” ");
INSERT INTO srnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Baka dati Yesus ben sidon tapu a Oleifbergi, dan den man fu En kon den wawan na En. Den aksi En taki: “Masra, taigi unu: Oten a sani dati o psa? San o de a marki di o sori tak' Yu e kon baka, èn tak' a kba fu a ten disi doro?” ");
INSERT INTO srnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus piki den taki: “Un mus luku bun tak' no wan sma no kori unu! ");
INSERT INTO srnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bika furu sma o du leki den na Mi. Den o taki tak' den na a Mesias, èn den o kori furu sma. ");
INSERT INTO srnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Un o yere tak' kondre e feti èn tak' feti de fu broko, ma un no mus skreki, bika den sani disi mus fu psa. Ma dati a no a kba ete. ");
INSERT INTO srnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bika a wan folku o feti nanga a tra folku, èn a wan kondre o feti nanga a trawan. Na difrenti presi angriten o de èn a gron o seki hebi tu. ");
INSERT INTO srnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma ala den sani disi na soso a bigin fu a tranga ten di o kon. ");
INSERT INTO srnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Den o grabu unu, dan den o gi un abra na sma di o pina unu, èn di o kiri unu. Fu Mi ede no wan sma fu no wan folku o man si un na ai. ");
INSERT INTO srnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ini a ten dati furu sma o lasi bribi ini Mi, a wan sma o tyari a trawan gi lanti èn den no o man si makandra na ai. ");
INSERT INTO srnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Furu sma o du leki den na profeiti èn den o kori furu sma. ");
INSERT INTO srnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Libisma o kon takru sote, tak' furu sma no sa lobi trawan moro. ");
INSERT INTO srnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma Gado sa ferlusu a sma di sa hori doro te na a kba. ");
INSERT INTO srnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A Bun Nyunsu disi tak' Gado bigin tiri libisma, sa panya na heri grontapu fu ala folku kan kisi a okasi fu yere en. Dan fosi grontapu o kba.” ");
INSERT INTO srnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“A profeiti Daniel ben taki tak' den o poti wan groskin-sani ini a Santa Presi di o pori a heri mamakerki. Suma e leisi a sani disi mus suku fu ferstan en. Te un si a sani disi, ");
INSERT INTO srnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","dan den sma di de ini Yudea mus lon go na den bergi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","A sma di de tapu a daki fu en oso, no mus saka go na gron fu go teki sani ini en oso. ");
INSERT INTO srnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Èn a sma di de ini en gron, no mus drai go baka fu go teki en krosi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Den uma di de nanga bere, nanga den di abi pikin na bobi a pisten dati, o de fu sari. ");
INSERT INTO srnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Un mus begi tak' un no o abi fu lowe ini a kowruten noso tapu wan sabadei. ");
INSERT INTO srnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bika wan bigi pinaten o kon. Noiti ete sowan ten ben de sensi grontapu meki te leki now, èn noiti moro sowan ten o kon baka. ");
INSERT INTO srnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Efu Gado no ben syatu a ten disi, no wan sma bo tan na libi. Ma Gado o syatu a ten fu den sma ede di A ben teki gi Ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Efu wan sma sa taigi unu ini a ten dati taki: ‘Luku, a Mesias de dyaso,’ noso: ‘Luku, A de drape,’ no bribi en. ");
INSERT INTO srnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bika sma o kon di o du leki den na a Mesias, trawan o du leki den na profeiti. Den o du wondru èn den o meki un si bigi marki. Nanga dati den o suku fu kori den sma di Gado ben teki gi Ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Luku bun! Mi e warskow unu na fesi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Efu sma sa taigi unu taki: ‘Luku, a Mesias de ini a dreisabana,’ no go. Efu den sa taigi un taki: ‘Luku, a Mesias de ini wan kamra,’ no bribi den. ");
INSERT INTO srnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bika leki fa faya e koti na loktu na a wan sei èn a de fu si te na a tra sei, na so a sa de te a Manpikin fu Libisma o drai kon baka na grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dan Yesus taki: “Pe a dedeskin didon, na drape yu e si tingifowru.” ");
INSERT INTO srnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Let' na baka a pinaten fu den dei dati, a son o kon dungru èn a munkenki no o gi faya. Den stari o fadon kmoto na loktu, èn ala den makti di de na loktu o seki. ");
INSERT INTO srnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dan a marki di e sori tak' a Manpikin fu Libisma o kon, sa de fu si na heimel. Ala folku na grontapu sa bari krei te den si a Manpikin fu Libisma e kon tapu den wolku nanga krakti nanga bigi glori. ");
INSERT INTO srnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dan nanga a tranga babari fu wan tutu, A o seni den engel fu En go fu tyari den sma kon na wan di A ben teki gi Ensrefi. Den o tyari den kmoto fu den fo sei pe a winti e kmoto, fu a wan sei fu heimel go te na a tra sei. ");
INSERT INTO srnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Un teki wan figabon leki eksempre. Te a bigin sproiti èn a bigin gi nyun wiwiri, dan un sabi tak' a dreiten de fu kon. ");
INSERT INTO srnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na so un mus sabi tu tak' te un e si ala den sani disi, dan a ten de krosbei, a de let' na mofodoro. ");
INSERT INTO srnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Fu tru Mi e taigi un taki: Ala den sani disi o psa te den sma fu a ten disi de na libi ete. ");
INSERT INTO srnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wan dei heimel nanga grontapu no o de moro, ma den sani san Mi taki o tan fu têgo.” ");
INSERT INTO srnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“No wan sma sabi a dei nanga a yuru te a o psa. Den engel di de na heimel no sabi, èn a Manpikin srefi no sabi. Na a P'pa wawan sabi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Soleki fa a ben de ini a ten fu Noa, na so a sa de te a Manpikin fu Libisma o drai kon baka. ");
INSERT INTO srnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bika ini a ten fosi Gado sungu grontapu, den sma ben e nyan, den ben e dringi, èn trow ben e trow, te leki a dei di Noa go ini a bigi sipi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Den no ben sabi ete san e psa te leki a bigi frudu kon wasi den alamala gwe. Na so a o de te a Manpikin fu Libisma o drai kon baka. ");
INSERT INTO srnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A dei dati tu man sa de ini den gron e wroko. A wan den o tyari gwe, èn a trawan o tan na baka. ");
INSERT INTO srnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tu frow o mara na den miri. A wan den o tyari gwe, èn a trawan o tan na baka. ");
INSERT INTO srnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Fu dat'ede un mus tan na ai, bika un no sabi sortu dei un Masra o kon. ");
INSERT INTO srnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma un mus sabi disi: Efu a man di abi a oso, ben sabi sortu yuru na neti a fufuruman bo kon, a bo tan na ai èn a no bo meki a fufuruman broko kon ini en oso. ");
INSERT INTO srnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dat' meki un mus de klari, bika a Manpikin fu Libisma o drai kon baka na wan yuru di un no e ferwakti En.” ");
INSERT INTO srnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Suma na a koni knekti tapu san en masra kan bow? A de a wan di a poti fu luku den tra knekti fu en, fu gi den nyanyan tapu a yuru di fiti. ");
INSERT INTO srnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A o bun gi a knekti dati efu te en masra kon baka, a si tak' a e du en wroko soleki fa a fiti. ");
INSERT INTO srnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Fu tru Mi e taigi un taki: A masra sa poti en fu luku ala den sani san a abi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma efu a knekti na wan takru-ati sma, èn a prakseri taki: ‘A masra fu mi no o kon ete,’ ");
INSERT INTO srnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dan a bigin fon den tra knekti, èn a go nyan, dringi nanga sopiman, ");
INSERT INTO srnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","dan a masra fu en o kon tapu wan dei di a no ferwakti, èn tapu wan yuru di a no sabi. ");
INSERT INTO srnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A o meki den kapu en pis'pisi èn poti en pe den hoigriman de. Drape den sa krei èn kaw den tifi.” ");
INSERT INTO srnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesus taigi den sma taki: “A ten dati yu kan si a fasi fa Gado e tiri libisma leki tin yongu uma di teki den lampu, dan den go fu miti a trowmasra. ");
INSERT INTO srnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Feifi fu den ben don, ma den tra feifi ben koni. ");
INSERT INTO srnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bika den donwan ben tyari den lampu, ma den no ben teki oli nanga den. ");
INSERT INTO srnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma den koniwan ben tyari den lampu èn den ben abi moro oli ini wan kroiki. ");
INSERT INTO srnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Di a trowmasra tan langa fu kon, dan sribi bigin kiri den uma èn den fadon na sribi. ");
INSERT INTO srnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ma mindrineti wan sma bari taki: ‘Luku, a trowmasra e kon. Un waka go miti en!’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ne den yongu uma opo, èn den seti den lampu fu den kan bron bun. ");
INSERT INTO srnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dan den donwan aksi den koniwan taki: ‘Gi un pikinso oli, bika den lampu fu unu e dede.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ma den koniwan piki den taki: ‘Un no man, bika kande a oli san un abi no o sari gi un alamala. A moro betre un go na den wenkriman go bai gi unsrefi.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma a pisten di den gwe go bai a oli, a trowmasra doro. Den yongu uma di ben klari gwe nanga en na a trow-oso, dan a doro sroto. ");
INSERT INTO srnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pikinso moro lati, den feifi tra yongu uma doro tu. Den bari taki: ‘Masra, masra, opo a doro gi unu!’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma a trowmasra piki den taki: ‘Fu tru Mi e taigi unu, Mi no sabi unu!’ ” ");
INSERT INTO srnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dan Yesus taki: “Fu dat'ede unu mus tan na ai, bika un no sabi a dei noso a yuru.” ");
INSERT INTO srnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Yu kan si a fasi fa Gado o tiri libisma tu leki wan man di bo go na wan tra kondre. Fosi a man gwe, a kari den knekti fu en, dan a gi den a frantwortu fu ala en sani. ");
INSERT INTO srnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A man prati en moni gi den knekti na a fasi fa a sabi tak' den ben man wroko nanga en. Wan fu den a gi feifi gowtumoni, wan trawan a gi tu gowtumoni, èn a di fu dri a gi wan enkri gowtumoni. Baka dati a man gwe. ");
INSERT INTO srnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A wan di kisi den feifi gowtumoni gwe wantron go wroko nanga a moni èn a kisi feifi gowtumoni moro. ");
INSERT INTO srnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","A wan di kisi den tu gowtumoni du a srefi sani èn a kisi tu gowtumoni moro. ");
INSERT INTO srnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma a wan di kisi a wan gowtumoni go diki wan olo, dan a beri a moni di en masra ben gi en. ");
INSERT INTO srnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Baka wan heri pisten, a masra fu den knekti drai kon baka. Dan a kari den knekti fu den taigi en san den du nanga a moni. ");
INSERT INTO srnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A wan di ben kisi den feifi gowtumoni kon nanga ete feifi. A taki: ‘Masra, yu ben gi mi feifi gowtumoni. Luku, mi wroko feifi moro.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A masra taigi en taki: ‘Moi so, yu na wan bun knekti. Mi kan bow na yu tapu. Yu wroko bun nanga a pikinso di mi ben gi yu, now mi o gi yu furu fu wroko nanga en. Kon na a fesa di mi e hori.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","A wan di ben kisi den tu gowtumoni, kon na en masra tu. A taigi en taki: ‘Masra, yu ben gi mi tu gowtumoni. Luku, mi wroko tu moro.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A masra taigi en taki: ‘Moi so, yu na wan bun knekti. Mi kan bow na yu tapu. Yu wroko bun nanga a pikinso di mi ben gi yu, now mi o gi yu furu fu wroko nanga en. Kon na a fesa di mi e hori.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Dan a knekti kon di ben kisi a wan gowtumoni. A taki: ‘Masra, mi sabi tak' yu na wan man di no e meki spotu. Yu e koti pe yu no sai, èn yu e piki sani pe yu no prani. ");
INSERT INTO srnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dat' meki mi ben frede, so mi beri a moni fu yu. Luku, yu moni dya.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ne a masra piki en taki: ‘Yu takru lesi knekti yu! Yu ben sabi tak' mi e koti pe mi no sai, èn mi e piki sani pe mi no prani. ");
INSERT INTO srnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","So yu ben mus tyari mi moni go poti na bangi. Dan te mi ben drai kon baka, mi ben kan teki en nanga san kon na en tapu.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dan a man taigi den tra knekti fu en taki: ‘Un puru a gowtumoni na en anu, dan un gi a man di abi den tin gowtumoni. ");
INSERT INTO srnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bika ala sma di abi, o kisi moro, èn den o abi bun furu. Ma a sma di no abi, awinsi san a abi, den o puru na en anu. ");
INSERT INTO srnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A knekti disi no bun fu noti. Un fringi en go na dorosei ini a dungru. Drape a sa krei èn kaw en tifi.’ ” ");
INSERT INTO srnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Dan Yesus taigi den sma moro fara taki: “A Manpikin fu Libisma sa drai kon baka nanga glori makandra nanga ala den engel fu En. Dan A o go sidon tapu En kownusturu san e sori tak' A abi ala makti. ");
INSERT INTO srnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ala sma fu grontapu o kon na En fesi. Dan A o prati den ini tu grupu leki fa wan skapuman e prati den skapu fu den bokoboko. ");
INSERT INTO srnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Den skapu A o poti na En let'anu sei, èn den bokoboko A o poti na En kruktu-anu sei. ");
INSERT INTO srnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dan a Kownu sa taigi den sma na En let'anu sei taki: ‘Un kon, unu di Mi P'pa blesi. Kon teki den bun di Gado poti klari gi den sma di A e tiri, den bun di A ben poti klari sensi di A meki grontapu. ");
INSERT INTO srnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bika di angri ben kiri Mi, un gi Mi nyanyan. Di watra ben kiri Mi, un gi Mi fu dringi. Di Mi ben kon leki wan doroseisma, un gi Mi wan presi fu tan. ");
INSERT INTO srnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Di Mi no ben abi krosi, un gi Mi fu weri. Di Mi ben siki, un sorgu gi Mi. Di Mi ben de na straf'oso, un kon luku Mi.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dan den sma di bun ini Gado ai, sa aksi En taki: ‘Masra, oten wi si Yu nanga angri, dan wi gi Yu nyanyan? Oten wi si tak' watra ben kiri Yu, dan wi gi Yu fu dringi? ");
INSERT INTO srnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Oten Yu kon leki wan doroseisma, dan wi gi Yu wan presi fu tan? Oten wi si tak' Yu no ben abi krosi, dan wi gi Yu fu weri? ");
INSERT INTO srnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Oten Yu ben siki noso Yu ben de na straf'oso, dan un go luku Yu?’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dan a Kownu sa piki den taki: ‘Fu tru Mi e taigi un taki: Di un du en gi wan fu den sma fu Mi, awinsi a no ben de wan prenspari sma, un du en gi Mi.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ma A sa taigi den sma na En kruktu-anu sei taki: ‘Un kmoto na Mi fesi, bika a fluku fu Gado de na un tapu. Un go ini a faya san Gado meki klari gi didibri nanga den takruyeye fu en! A faya di e bron fu têgo! ");
INSERT INTO srnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bika di angri ben kiri Mi, un no gi Mi nyanyan. Di watra ben kiri Mi, un no gi Mi fu dringi. ");
INSERT INTO srnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Di Mi ben kon leki wan doroseisma, un no gi Mi wan presi fu tan. Di Mi no ben abi krosi, un no gi Mi fu weri. Di Mi ben siki, èn di Mi ben de na straf'oso, un no kon luku Mi.’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dan den sa piki En taki: ‘Masra, oten wi si Yu nanga angri, noso tak' watra ben kiri Yu? Oten Yu kon leki wan doroseisma? Oten wi si tak' Yu no ben abi krosi? Oten Yu ben siki, noso Yu ben de na straf'oso? Oten wi si Yu ini sowan nowtu dan wi no du noti?’ ");
INSERT INTO srnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dan A sa piki den taki: ‘Fu tru Mi e taigi un taki: Efu un no du en gi wan sma fu Mi, un no du en gi Mi tu, awinsi a sma dati no ben de wan prenspari sma.’ ” ");
INSERT INTO srnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Dan Yesus taki: “Den sma disi o go pe den o kisi strafu fu têgo. Ma den sma di bun ini Gado ai, o kisi a libi fu têgo.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Di Yesus kba taki ala den sani disi, A taigi den man fu En taki: ");
INSERT INTO srnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Un sabi tak' tra tamara wi o nyan Paska. Dan den o gi a Manpikin fu Libisma abra na ini anu fu trawan fu den spikri En na wan kroisi.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A srefi yuru dati, den prenspari domri nanga den fesiman fu a folku ben kon makandra ini a oso fu a grandomri Kayafas. ");
INSERT INTO srnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Drape den kruderi makandra fa den bo man kisi Yesus nanga wan triki fu den kan kiri En. ");
INSERT INTO srnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma den taki: “Un no mus grabu En tapu den dei fu a fesa, noso a folku o meki dyugudyugu.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesus ben de na Betania, na a oso fu wan man di den ben kari Gwasi Simon. ");
INSERT INTO srnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Di A ben e nyan, wan frow kon na En nanga wan albast batra di ben furu nanga wan bun diri oli. Dan a kanti a oli tapu a ede fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Di den man fu En si san a frow du, den mandi. Den taki: “Sanede a fermorsu a oli? ");
INSERT INTO srnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Un ben kan seri en gi furu moni èn prati a moni gi pôtisma.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma Yesus ben sabi san den taki, dat' meki A taigi den taki: “Sanede un e krutu a frow disi? Na wan bun sani a du gi Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pôtisma de ala ten nanga unu, ma Mi no o de ala ten nanga unu. ");
INSERT INTO srnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Di a kanti a oli tapu Mi skin, a meki Mi skin klari fu beri. ");
INSERT INTO srnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Fu tru Mi e taigi un taki: Ala sei fu grontapu pe sma sa ferteri a Bun Nyunsu disi, den sma o memre a frow fu a sani san a du gi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dan wan fu den twarfu man fu Yesus, di ben nen Yudas Iskariot, go na den prenspari domri. ");
INSERT INTO srnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","A aksi den taki: “Omeni un o pai mi efu mi gi Yesus abra na ini un anu?” Dan den gi en dritenti solfrumoni. ");
INSERT INTO srnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sensi a ten dati, Yudas bigin luru wan bun okasi fu gi Yesus abra na den. ");
INSERT INTO srnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tapu a fosi dei fu a fesa pe den e nyan brede san meki sondro dyesi, den man fu Yesus kon aksi En taki: “Pe Yu wani fu wi meki sani klari fu Yu kan nyan a Paska-nyanyan?” ");
INSERT INTO srnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus piki den taki: “Un go na sowan sma ini a foto, dan un taigi en taki: ‘A Meister seni taigi yu tak' a ten fu En de krosbei. Na yu oso A o kon nyan Paska nanga den man fu En.’ ” ");
INSERT INTO srnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Den man fu Yesus du san A taigi den, èn den meki a Paska-nyanyan klari. ");
INSERT INTO srnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Di neti tapu, Yesus nanga den twarfu man fu En teki presi sei a tafra. ");
INSERT INTO srnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dan di den e nyan, Yesus taigi den taki: “Fu tru Mi e taigi un taki: Wan fu unu o seri Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Den man fu En sari sote, èn wan fru wan den aksi En taki: “Masra, na mi?” ");
INSERT INTO srnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus piki den taki: “A wan di dopu en brede ini a srefi komki nanga Mi, na en o seri Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bika a Manpikin fu Libisma sa dede leki fa a ben skrifi fu En kba na fesi. Ma a man di seri En mus luku bun! A bo moro bun gi en efu noiti en m'ma ben meki en.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, a man di seri Yesus, aksi En taki: “Meister, na mi?” Yesus piki en taki: “Na leki fa yu taki.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Di den ben e nyan, Yesus teki wan brede, A blesi en, dan A broko en. Baka dati A gi den man fu En, dan A taki: “Un teki, dan un nyan. Disi na Mi skin.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dan Yesus teki wan kan nanga win, A taki Gado tangi fu en, dan A gi den man fu En. A taki: “Un alamala dringi fu a win. ");
INSERT INTO srnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bika disi na Mi brudu san o stampu a ferbontu di Gado meki. A o lon fu meki furu sma kisi pardon fu den sondu. ");
INSERT INTO srnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi e taigi un taki: Mi no o dringi win moro, te leki Mi o dringi nyun win nanga unu na heimel pe Mi P'pa e rigeri.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Baka di den singi fu gi Gado grani, den go na a Oleifbergi. ");
INSERT INTO srnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Di den ben de na pasi, Yesus taigi den man fu En taki: “Tide neti un alamala o gwe libi Mi. Bika a skrifi taki: ‘Mi o kiri a skapuman, dan ala den skapu o panya.’ ");
INSERT INTO srnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma te Mi kon baka na libi, Mi o go na un fesi na Galilea.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma Petrus taigi Yesus taki: “Noiti mi o gwe libi Yu, awinsi ala den trawan gwe!” ");
INSERT INTO srnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus piki en taki: “Fu tru Mi e taigi yu taki: Fosi kakafowru bari tide neti, yu o taki dri leisi tak' yu no sabi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma Petrus taki: “Awinsi mi mus dede nanga Yu, mi no o taki tak' mi no sabi Yu.” Dan ala den tra man fu En taki a srefi sani tu. ");
INSERT INTO srnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Baka dati Yesus nanga den man fu En go na wan presi di den e kari Getsemane. Drape A taigi den taki: “Un sidon dyaso. Mi o go pikinso moro fara fu go begi.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dan A teki Petrus, nanga Yakobus nanga Yohanes, den tu manpikin fu Sebedeus, fu go nanga En. Ne Yesus bigin firi sari èn A ben frede. ");
INSERT INTO srnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A taigi den dri man taki: “Mi abi sowan dipi sari tak' Mi no man tyari en. Un tan dya, hori wakti nanga Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dan Yesus go pikinso moro fara, A trowe Ensrefi langalanga na gron, dan A begi taki: “Mi P'pa, efu a kan, no meki Mi dringi fu a kan disi, no meki Mi nyan a pina. Ma a no san Mi wani, ma na san Yu wani musu psa!” ");
INSERT INTO srnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dan A drai kon baka na den man fu En èn A si tak' den e sribi. Ne A aksi Petrus taki: “Yu no ben man tan wan yuru na ai nanga Mi? ");
INSERT INTO srnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Un mus tan na ai, èn begi fu un no kon na ini tesi. Mi sabi tak' ati wani, ma skin no abi krakti.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dan Yesus go begi baka. A taki: “Mi P'pa, efu Mi mus dringi fu a kan disi, efu tra fasi no de, dan meki Yu wani psa!” ");
INSERT INTO srnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Di Yesus drai kon baka den ben e sribi baka, bika sribi ben moro den. ");
INSERT INTO srnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesus libi den safri, dan A go begi den srefi sani fu a di fu dri leisi. ");
INSERT INTO srnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Di A kba begi, A kon na den man fu En dan A taigi den taki: “Now un kan sribi èn rostu fu unu. Luku, a yuru doro kba. Den e gi a Manpikin fu Libisma abra na ini anu fu sondusma. ");
INSERT INTO srnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Opo, kon meki un gwe. Luku, a sma di seri Mi e kon kba.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus no ben kba taki ete, di Yudas, wan fu den twarfu man fu En, doro. Den prenspari domri nanga den fesiman fu a folku ben seni en kon nanga wan heri ipi sma di ben e tyari owru nanga tiki. ");
INSERT INTO srnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas ben meki mofo nanga den man taki: “Na a wan di mi o bosi, na En un mus grabu.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ne a waka kon na Yesus. A taigi En taki: “Meister, fa a e go nanga Yu?” Dan a bosi En. ");
INSERT INTO srnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Yesus taigi en taki: “Mi mati, san yu kon fu du?” Den man waka kon na Yesus, dan den grabu En hori. ");
INSERT INTO srnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ne wan fu den man di ben de nanga Yesus hari en owru, dan a kapu a yesi puru fu a knekti fu a grandomri. ");
INSERT INTO srnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma Yesus taigi en taki: “Poti yu owru gwe. A sma di e feti nanga owru, den o kiri nanga owru tu. ");
INSERT INTO srnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yu no sabi tak' Mi kan aksi Mi P'pa, dan wantron A sa seni moro leki twarfu legre engel kon fu yepi Mi? ");
INSERT INTO srnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma efu Mi du dati, dan fa den sani o kon tru di skrifi ini a Santa Buku, tak' na so a musu psa?” ");
INSERT INTO srnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dan Yesus taigi den sma taki: “Un kon nanga tiki nanga owru fu grabu Mi, neleki Mi na wan bigi ogriman. Ala dei Mi ben sidon e gi leri ini a mamakerki, ma un no grabu Mi. ");
INSERT INTO srnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma a ben musu psa so fu meki den sani di den profeiti ben skrifi kon tru.” Dan ala den man fu Yesus lon gwe libi En. ");
INSERT INTO srnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Den man di ben grabu Yesus, tyari En go na a grandomri Kayafas. Drape den sabiman fu Gado wèt nanga den fesiman fu a folku ben kon makandra. ");
INSERT INTO srnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma Petrus ben e waka fara na baka e kon te na a dyari fu a grandomri. Dan a go inisei go sidon mindri den waktiman fu a mamakerki fu si san o psa moro fara. ");
INSERT INTO srnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Den prenspari domri nanga ala den man fu a Grankrutu fu den Dyu, ben suku sma di ben wani lei gi Yesus fu den kan kiri En. ");
INSERT INTO srnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma den no feni noti, aladi furu sma ben go taki sani di no tru. Te fu kba, tu man go na fesi. ");
INSERT INTO srnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Den taki: “A man disi ben taki tak' A kan broko a Santa Presi fu Gado, dan A meki en baka ini dri dei.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ne a grandomri opo, dan a aksi Yesus taki: “Yu no e piki tapu san den man disi e taki fu Yu?” ");
INSERT INTO srnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma Yesus no piki noti. Dan a grandomri taigi En taki: “Sweri gi mi ini a nen fu a libi Gado: Taigi unu efu Yu na a Mesias, a Manpikin fu Gado?” ");
INSERT INTO srnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus piki en taki: “Na leki fa yu taki. Ma Mi e taigi un taki: Bigin fu now un o si a Manpikin fu Libisma sidon na a let'anu sei fu Gado di abi Makti. Dan un o si En te A e kon baka tapu den wolku.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Di Yesus taki a sani dati, a grandomri priti en krosi, dan a taki: “A e meki leki En na Gado! Un no abi kotoigi fanowdu moro. Luku, un srefi yere now fa A afrontu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","San na un besroiti?” Den tra krutubakra piki taki: “A fiti fu A dede!” ");
INSERT INTO srnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dan den spiti ini En fesi èn den naki En nanga kofu. Trawan baka naki En ini En fesi, ");
INSERT INTO srnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dan den taki: “Mesias, sori unu tak' yu na wan profeiti. Taigi unu suma naki Yu.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A pisten dati Petrus ben e sidon na dorosei ini a dyari. Dan wan frow di ben wroko drape kon taigi en taki: “Yu ben de nanga Yesus fu Galilea tu.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma Petrus lei na ala sma fesi taki: “Mi no sabi san yu e taki!” ");
INSERT INTO srnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dan Petrus opo waka go na a poort. Ma wan tra frow si en, dan a taigi den sma drape taki: “A man disi ben de nanga Yesus fu Nasaret.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma agen Petrus lei. A taki: “Mi e sweri gi unu. Mi no sabi a man!” ");
INSERT INTO srnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Baka wan syatu pisten, den tra sma di ben e tnapu drape waka go na Petrus, dan den taigi en taki: “A tru. Yu na wan fu den man tu. Wi e yere en na a fasi fa yu e taki.” ");
INSERT INTO srnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dan Petrus sweri baka èn a bigin fluku ensrefi taki: “Mi no sabi a man!” A srefi momenti dati wan kakafowru bari. ");
INSERT INTO srnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dan Petrus memre fa Yesus ben taigi en taki: “Fosi kakafowru bari, yu o taki dri leisi tak' yu no sabi Mi.” Dan Petrus go na dorosei, dan a bari wan krei. ");
INSERT INTO srnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Di dei opo, ala den prenspari domri nanga den fesiman fu a folku teki a besroiti fu kiri Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dan den tai En tyari go gi granman Pilatus. ");
INSERT INTO srnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudas, di ben seri Yesus, si tak' den ben wani kiri En, dan a kisi konsensi fonfon. So a tyari den dritenti solfrumoni go baka gi den prenspari domri nanga den fesiman fu a folku. ");
INSERT INTO srnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A taigi den taki: “Mi sondu, bika mi seri wan man di no du noti.” Ma den piki en taki: “Dati na yu problema. Un kba nanga a tori.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ne Yudas fringi a moni go ini a Santa Presi, dan a gwe go anga ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Den prenspari domri piki a moni, dan den taki: “Un no kan poti a moni disi ini a kisi pe sma e poti moni gi a mamakerki, bika na moni di pai fu kiri wan sma.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dan den teki a besroiti fu bai wan pisi gron di ben de fu a man di ben meki prapi. A gron dati den bo teki leki berpe gi doroseisma. ");
INSERT INTO srnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Fu dat'ede den e kari a gron dati Brudu Gron te leki a dei fu tide. ");
INSERT INTO srnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na so a sani san a profeiti Yeremia ben taki kon tru. A ben taki: “Den teki den dritenti solfrumoni di den sma fu Israel ben agri fu pai gi en, ");
INSERT INTO srnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","dan den bai a gron fu wan man di e meki prapi. Na dati Masra ben taigi mi fu du.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","So den man tyari Yesus go na granman Pilatus. Dan Pilatus aksi En taki: “Na Yu na a Kownu fu den Dyu?” Yesus piki en taki: “Na leki fa yu taki.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ma di den prenspari domri nanga den fesiman fu a folku ben kragi En, Yesus no piki noti. ");
INSERT INTO srnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatus aksi Yesus taki: “Yu no e yere ala den sani san den e taki fu Yu?” ");
INSERT INTO srnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Yesus no piki en tapu no wan sani. A sani dat' meki Pilatus ferwondru srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A ben de a gwenti te den ben hori a Paskafesa tak' a granman ben lusu wan straf'man di den Dyusma ben wani. ");
INSERT INTO srnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A ten dati wan man ben de na straf'oso di furu sma ben sabi. A ben nen Barabas. ");
INSERT INTO srnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dan fu di furu Dyusma ben drape, Pilatus aksi den taki: “Suma un wani tak' mi mus lusu gi unu? Barabas noso Yesus, di den e kari a Mesias.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus ben sabi heri bun tak' den ben tyari Yesus kon gi en fu di den ben dyarusu na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Di Pilatus ben sidon tapu a krutusturu, en frow seni taigi en taki: “No leisi strafu gi a man disi di no du noti. Bika a neti di psa mi nyan furu pina fu En ede ini wan dren.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma den prenspari domri nanga den fesiman fu a folku sutu faya gi a bigi grupu sma meki den aksi Pilatus fu lusu Barabas, èn fu kiri Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatus aksi den sma baka taki: “Sortu wan fu den tu man un wani tak' mi mus lusu?” Den sma taki: “Barabas.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dan Pilatus aksi den taki: “Dan san mi mus du nanga Yesus, di den e kari a Mesias?” Ne ala sma bari taki: “Spikri En na wan kroisi!” ");
INSERT INTO srnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatus aksi den baka taki: “Ma sortu ogri a man disi du?” Ma den sma bigin bari moro tranga taki: “Spikri En na wan kroisi!” ");
INSERT INTO srnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dan Pilatus si tak' noti no e yepi moro, ma tak' moro nanga moro den sma e meki opruru. Dat' meki a teki watra, dan a wasi en anu na ala den sma fesi. A taigi den taki: “Mi no abi noti fu du nanga a dede fu a man disi. San o psa na unu problema. Mi kba nanga a tori.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A heri folku piki en taki: “Meki a frantwortu fu En dede kon tapu wi nanga den bakapikin fu wi!” ");
INSERT INTO srnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Baka dati Pilatus lusu Barabas, dan a meki den wipi Yesus èn tyari En go spikri na wan kroisi. ");
INSERT INTO srnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Den srudati fu Pilatus tyari Yesus go ini a krutu-oso, dan den kari ala den tra srudati kon di ben drape. ");
INSERT INTO srnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Den puru En krosi, dan den weri wan redi mantel gi En. ");
INSERT INTO srnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Den brei wan banti fu makataki poti tapu En ede, dan den gi En wan tiki fu A hori ini En let'anu. Dan den fadon tapu den kindi na En fesi, èn den meki spotu nanga En taki: “Odi, Kownu fu den Dyu!” ");
INSERT INTO srnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Baka dati den spiti na En tapu, dan den teki a tiki na En anu, naki En tapu En ede. ");
INSERT INTO srnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Di den kba meki spotu nanga En, den puru a mantel, dan den weri En eigi krosi gi En baka. Dan den tyari En gwe fu go spikri na wan kroisi. ");
INSERT INTO srnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Di den ben de na pasi, den miti nanga wan man fu a foto Sirena di ben nen Simon. Dan den dwengi en fu a tyari a kroisi gi Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Di den doro na a presi san den e kari Golgota (dati wani taki: Dede-ede Presi), ");
INSERT INTO srnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","den gi Yesus win di ben moksi nanga wan bita sani. Ma di A tesi en, A no ben wani dringi en. ");
INSERT INTO srnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Baka di den spikri En na a kroisi, den hari a lot fu prati En krosi. ");
INSERT INTO srnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Di den kba, den saka sidon drape fu hori wakti gi En. ");
INSERT INTO srnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tap'sei fu En ede den ben skrifi fu sanede den kiri En. Den skrifi taki: “Disi na Yesus, a Kownu fu den Dyu.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Den srudati spikri tu fufuruman makandra nanga Yesus, wan na En let'anu sei, èn a trawan na En kruktu-anu sei. ");
INSERT INTO srnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Den sma di ben e waka psa, afrontu Yesus. Den seki den ede èn den taki: ");
INSERT INTO srnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“A no Yu bo broko a Santa Presi dan Yu meki en baka ini dri dei? We, efu na Yu na a Manpikin fu Gado, dan yepi Yusrefi! Saka kmopo fu a kroisi dan!” ");
INSERT INTO srnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Den prenspari domri nanga den sabiman fu Gado wèt makandra nanga den fesiman fu a folku ben meki spotu nanga En tu. Den taki: ");
INSERT INTO srnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A ben yepi trawan, ma A no man yepi Ensrefi! Efu na En na a Kownu fu Israel, meki A kmopo fu a kroisi now. Dan wi sa bribi En! ");
INSERT INTO srnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A poti En fertrow tapu Gado. We, efu Gado lobi En so, meki A yepi En now, bika A ben taki tak' En na a Manpikin fu Gado!” ");
INSERT INTO srnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tapu a srefi fasi den fufuruman di ben spikri makandra nanga En, ben kosi En tu. ");
INSERT INTO srnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Twarfu yuru brekten, a heri kondre kon dungru te leki dri yuru bakadina. ");
INSERT INTO srnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dan a yuru dati Yesus bari taki: “Eli, Eli, lama sabaktani?” Dati wani taki: Mi Gado, Mi Gado, fu sanede Yu gwe libi Mi? ");
INSERT INTO srnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Di wantu sma di ben tnapu drape yere a sani disi, den taki: “Na Elia A e kari.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wantron wan fu den lon go teki wan sponsu, dan a nati en nanga swa win. A fasi a sponsu na wan tiki, dan a langa en gi Yesus fu A dringi. ");
INSERT INTO srnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma den tra sma taki: “Wakti, meki un luku efu Elia o kon yepi En.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus bari ete wan leisi nanga tranga sten, dan En bro koti. ");
INSERT INTO srnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A srefi momenti dati a garden ini a Santa Presi priti langalanga na mindri fu loktu kon te na gron. A gron seki èn den ston priti. ");
INSERT INTO srnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Grebi opo tu, èn furu sma fu Gado di ben dede kba, kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Den kmopo ini den grebi, èn baka di Yesus kon na libi baka den go ini a santa foto Yerusalem pe den sori densrefi na furu sma. ");
INSERT INTO srnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Den srudati di ben hori wakti na Yesus, nanga a kapten fu den, firi fa a gron seki. Èn di den si den sani di psa, den bigin frede srefsrefi. Dan den taki: “Trutru, a man disi ben de a Manpikin fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Furu uma fu Galilea, di ben waka nanga Yesus fu sorgu gi En, ben drape tu. Den ben tnapu farawe e luku. ");
INSERT INTO srnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wantu fu den uma dati ben de Maria fu a foto Magdala, nanga Maria a m'ma fu Yakobus nanga Yosef, nanga a frow fu Sebedeus. ");
INSERT INTO srnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Di neti ben de fu tapu, wan guduman kon di ben nen Yosef. A ben de fu a foto Arimatea èn a ben de wan man di ben teki leri fu Yesus tu. ");
INSERT INTO srnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A go na Pilatus fu aksi en a dedeskin fu Yesus. Dan Pilatus seni taigi den srudati tak' den kan gi en. ");
INSERT INTO srnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","So Yosef teki a dedeskin fu Yesus, èn a domru en ini wan krin linnen krosi. ");
INSERT INTO srnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dan a poti a dedeskin ini a nyun grebi fu en di a ben meki den diki ini a bergiskin. Baka dati a lolo wan bigi ston na a mofo fu a grebi fu tapu en, dan a gwe. ");
INSERT INTO srnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria fu Magdala nanga a tra Maria, ben sidon a pisten dati na abrasei fu a grebi. ");
INSERT INTO srnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A tra dei fu en, den prenspari domri nanga den Fariseiman go makandra na Pilatus. A ben de wan sabadei. ");
INSERT INTO srnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Dan den taigi en taki: “Masra, wi memre tak' di a bedrigiman disi ben de na libi ete, A ben taki tak' baka dri dei A bo kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dat' meki wi e aksi yu fu meki srudati hori wakti na a grebi dri dei langa. Bika den man fu En kan kon fufuru a dedeskin, dan den go ferteri den sma tak' A kon na libi baka. A lei dati o bigi moro a fosi wan.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus taigi den taki: “Un kan teki srudati, ma unu srefi luku fa un o seti a wakti drape.” ");
INSERT INTO srnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","So den man go poti wan marki na a ston fu sma no kan puru en èn den poti srudati fu hori wakti. ");
INSERT INTO srnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Fruku mamanten, baka a sabadei, Maria fu Magdala nanga a tra Maria go luku a grebi fu Yesus. A ben de a fosi dei fu a wiki. ");
INSERT INTO srnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma wantron so, a gron bigin seki hebi fu di wan engel fu Masra saka kmoto na heimel. A engel go na a grebi, a lolo a bigi ston puru, dan a go sidon na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A fesi fu a engel ben gersi a faya di e koti na loktu, èn den krosi fu en ben weti leki katun. ");
INSERT INTO srnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Den srudati di ben e hori wakti skreki so tranga tak' den tan didon leki dedesma. ");
INSERT INTO srnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dan a engel taigi den uma taki: “No frede! Mi sabi tak' un e suku Yesus di den ben spikri na a kroisi. ");
INSERT INTO srnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A no dya, bika A kon baka na libi soleki fa A ben taki. Kon, luku a presi pe A ben didon. ");
INSERT INTO srnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dan un go es'esi go taigi den man fu En taki: ‘A kon na libi baka. Arki, A sa go na un fesi na Galilea. Drape un sa si En.’ Na disi mi kon fu taigi unu.” ");
INSERT INTO srnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Den uma gwe wantron fu a grebi. A skreki ben de ini den skin ete, ma den ben breiti srefsrefi. Den lon go es'esi fu go ferteri den man fu Yesus san a engel ben taki. ");
INSERT INTO srnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Di den ben de na pasi, ne Yesus waka miti den èn A taki den odi. Den uma waka go na En, den grabu den futu fu En èn den anbegi En. ");
INSERT INTO srnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dan Yesus taigi den taki: “No frede. Un go taigi den man fu Mi fu den go na Galilea. Drape den o si Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","A srefi pisten di den uma ben e go na den man fu Yesus, wantu fu den srudati ben go na a foto dan den ferteri den prenspari domri ala den sani di psa. ");
INSERT INTO srnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Den disi hori wan konmakandra nanga den fesiman fu a folku fu taki a tori. Dan den teki a besroiti fu gi den srudati furu moni, ");
INSERT INTO srnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","èn den taigi den taki: “Un mus ferteri den sma taki: ‘Neti yuru den man fu Yesus kon fufuru a dedeskin di un ben e sribi.’ ");
INSERT INTO srnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Efu Pilatus yere a tori, wi sa taki nanga en fu sorgu tak' a no strafu unu.” ");
INSERT INTO srnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","So den srudati teki a moni, dan den du san den man taigi den fu du. Den Dyusma e taki a tori disi te leki a dei fu tide. ");
INSERT INTO srnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Den erfu man fu Yesus go na Galilea na a bergi pe Yesus ben taigi den fu go. ");
INSERT INTO srnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Di den si En, den anbegi En, ma sonwan fu den no ben e bribi ete efu na Yesus trutru. ");
INSERT INTO srnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ne Yesus kon moro krosbei, dan A taigi den taki: “Gado gi Mi ala makti na ini heimel nanga grontapu. ");
INSERT INTO srnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Un go na ala folku fu grontapu. Un mus meki den kon tron sma di e teki leri fu Mi. Dopu den ini a nen fu a P'pa, a Manpikin nanga a Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Leri den fu du ala sani di Mi ben taigi unu. Arki, Mi de nanga unu ala dei te na a kba fu grontapu.”");
INSERT INTO srnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Disi na a Bun Nyunsu fu Yesus Kristus, a Manpikin fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A bigin soleki fa a profeiti Yesaya ben skrifi taki: Yere, Mi e seni Mi boskopuman go na Yu fesi, di sa meki a pasi klari gi Yu. ");
INSERT INTO srnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wan sma e bari wroko ini a dreisabana taki: Meki pasi klari gi Masra, puru ala boktuboktu gi En. ");
INSERT INTO srnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","A boskopuman disi ben de Yohanes a Dopuman. A ben de ini a dreisabana e bari a boskopu tak' den sma mus drai den libi èn teki dopu. Na sowan fasi Gado bo gi den pardon fu den sondu. ");
INSERT INTO srnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sma ben kmopo fu ala sei fu Yudea nanga Yerusalem kon na Yohanes. Dan a dopu den ini a Yordanliba te den ben taki sortu sondu den du. ");
INSERT INTO srnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes ben e weri krosi san ben meki fu kameel-wiwiri, èn a ben e tai wan leribuba na en bere. A ben e nyan sprenka nanga bus'oni. ");
INSERT INTO srnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A taigi den sma taki: “Baka mi a Wan di abi makti moro mi, e kon. Mi no warti srefi fu bukundu lusu En susu puru na En futu. ");
INSERT INTO srnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi ben dopu unu nanga watra, ma En o dopu unu nanga a Santa Yeye.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na a ten dati Yesus kmopo fu Nasaret ini a distrikti Galilea, go na Yohanes. Dan A meki Yohanes dopu En ini a Yordanliba. ");
INSERT INTO srnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A srefi momenti di Yesus kmopo ini a watra, A si fa heimel opo èn fa a Santa Yeye e saka leki wan doifi kon na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne wan sten kmopo fu heimel taki: “Yu na Mi Manpikin di Mi lobi. Mi abi prisiri nanga Yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dan wantron a Santa Yeye seni Yesus go na ini a dreisabana. ");
INSERT INTO srnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Fotenti dei langa Satan ben tesi En ini a dreisabana. Drape A tan na mindri den bus'meti, èn den engel ben sorgu gi En. ");
INSERT INTO srnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Baka di den kisi Yohanes poti na ini straf'oso, Yesus go na Galilea fu tyari a Bun Nyunsu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A taki: “A ten doro kba. Her'esi Gado o bigin tiri libisma. Un drai un libi èn bribi a Bun Nyunsu.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Di Yesus ben e waka na a syoro fu a Meer fu Galilea, A si Simon nanga en brada Andreas e fisi nanga den tyasneti. Den man disi ben de fis'man. ");
INSERT INTO srnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus taigi den taki: “Un kon waka nanga Mi, dan Mi o meki un tron fis'man fu libisma.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wantron den poti den tyasneti na wan sei, èn den bigin waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Di Yesus waka go pikinso moro fara, A si Yakobus nanga Yohanes, den tu manpikin fu Sebedeus. Den ben de ini den boto e lapu den tyasneti fu den. ");
INSERT INTO srnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Fa Yesus si den, A kari den kon. Dan den libi den p'pa Sebedeus nanga den wrokoman fu en ini a boto, èn den bigin waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Dan Yesus nanga den man fu En go na Kafarnaum. Tapu a sabadei, Yesus go wantron na ini a Dyukerki dan A bigin gi den sma leri. ");
INSERT INTO srnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Den sma no ben sabi san fu taki fu a leri fu En. Bika A no ben gi leri leki fa den sabiman fu Gado wèt ben e du, ma A ben du en leki a sma di kon nanga a leri. ");
INSERT INTO srnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A srefi momenti dati wan man ben de ini a kerki di ben abi wan takruyeye na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","A bari taki: “Yesus fu Nasaret, san Yu wani nanga unu? Na kon Yu kon fu puru un na pasi? Mi sabi suma na Yu. Yu na a Santa Wan fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Yesus bari en taki: “Tapu yu mofo èn kmopo na a man tapu!” ");
INSERT INTO srnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ne a takruyeye naki a man stoipi, èn nanga bigi babari a kmopo tapu a man. ");
INSERT INTO srnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ala den sma ben ferwondru. A wan ben aksi a trawan taki: “San na a sani disi? Na wan nyun leri nanga makti! A e taigi den takruyeye san den mus du, èn den e du san A taki.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wantron a nyunsu fu san Yesus du, panya ini a heri kontren fu Galilea. ");
INSERT INTO srnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Di Yesus kmopo ini a Dyukerki, A go langalanga na a oso fu Simon nanga Andreas. Yakobus nanga Yohanes go nanga En tu. ");
INSERT INTO srnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Now a m'ma fu a frow fu Simon ben didon nanga korsu. Fa Yesus doro, den sma taigi En taki a frow e siki. ");
INSERT INTO srnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus go na a frow, A hori en na en anu èn A meki a opo tnapu. Ne a korsu saka, dan a frow poti nyanyan nanga dringi gi den. ");
INSERT INTO srnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mofoneti di a son saka, den sma tyari ala den sma di ben siki, noso di ben abi takruyeye na den tapu, kon na Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ala den sma fu a foto ben kon tnapu na mofodoro fu a oso. ");
INSERT INTO srnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dan Yesus dresi furu sma di ben abi ala sortu siki, èn A puru furu takruyeye tapu sma. Ma A no ben gi den takruyeye primisi fu taki, bika den ben sabi suma na En. ");
INSERT INTO srnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Musudei mamanten Yesus opo dan A go na wan presi dorosei fu a foto pe sma no e libi. A go begi drape. ");
INSERT INTO srnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma Simon nanga den mati fu en, go suku pe Yesus de. ");
INSERT INTO srnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Di den feni En, den taki: “Ala sma e suku Yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Yesus taigi den taki: “Kon meki un go na den tra presi ini a birti dya, fu Mi kan preiki drape tu. Bika na fu dati ede Mi kon.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na so Yesus waka ini heri Galilea e preiki ini den Dyukerki èn A ben puru takruyeye tapu den sma. ");
INSERT INTO srnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wan dei wan gwasiman kon na Yesus. A saka go tapu en kindi, dan a begi En taki: “Masra, efu Yu wani, Yu kan meki mi skin kon bun baka.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus firi sari-ati gi a man. A langa En anu fasi a man, dan A taigi en taki: “Iya, Mi wani! Kon betre!” ");
INSERT INTO srnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A srefi momenti dati a man kon betre, èn en skin kon bun baka. ");
INSERT INTO srnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesus seni a man gwe wante, ma A warskow en taki: “Sorgu tak' yu no e ferteri no wan sma san psa nanga yu. Ma yu mus go na a Dyudomri, meki a si tak' yu kon betre. Dan fu sori ala sma tak' yu kon betre, yu mus tyari a offer gi Gado leki fa Moses skrifi tak' yu mus du te yu kon betre fu gwasi.” ");
INSERT INTO srnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma di a man gwe, a bigin ferteri na ala sei san ben psa nanga en. Dat' meki Yesus no ben man go moro ini wan foto fu sma si En. So A ben tan dorosei fu den foto, na presi pe sma no e libi. Ma toku sma ben kon na En fu ala sei. ");
INSERT INTO srnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Baka wantu dei Yesus drai go baka na Kafarnaum, dan den sma kisi fu yere tak' A de na oso. ");
INSERT INTO srnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Furu sma ben kon na En, tak' srefi na mofodoro presi no ben de moro fu sma tnapu. So Yesus preiki a wortu fu Gado gi den. ");
INSERT INTO srnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dan wantu sma kon nanga wan lanman na En. Fo man ben tyari en tapu wan matrasi. ");
INSERT INTO srnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma den no ben man doro na Yesus nanga a man, fu di den sma ben furu. Dat' meki den broko a daki opo tap'sei pe Yesus ben de. Baka di den puru wan pisi fu a daki, den saka a matrasi pe a man ben didon go na gron. ");
INSERT INTO srnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Di Yesus si a bribi fu den, A taigi a lanman taki: “Mi mati, yu kisi pardon fu yu sondu.” ");
INSERT INTO srnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma wantu sabiman fu Gado wèt ben sidon drape tu. Den ben taki na ini den ati taki: ");
INSERT INTO srnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Fa a man disi kan taki so? A e afrontu Gado! Na Gado wawan kan gi pardon fu sondu.” ");
INSERT INTO srnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma wantron Yesus ben sabi ini Ensrefi tak' na dati den e prakseri. Dan A aksi den taki: “Fu sanede sowan prakseri kon ini un ati? ");
INSERT INTO srnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","San moro makriki? Fu taigi a lanman tak' a kisi pardon fu en sondu, noso fu taigi en taki: ‘Opo, teki yu matrasi, dan yu waka.’ ");
INSERT INTO srnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma Mi o sori unu tak' a Manpikin fu Libisma abi makti dya na grontapu fu gi sma pardon fu sondu.” Dan Yesus taigi a lanman taki: ");
INSERT INTO srnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mi e taigi yu fu yu opo, teki yu matrasi, dan yu go na oso.” ");
INSERT INTO srnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ne a man opo. Wantewante a teki en matrasi, dan a waka fesi den alamala go na dorosei. Ala den sma ferwondru srefsrefi èn den gi Gado glori taki: “Noiti ete un si sowan sani!” ");
INSERT INTO srnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus kmopo ini a oso go baka na a Meer fu Galilea. Ala den sma ben go nanga En, dan A bigin gi den leri. ");
INSERT INTO srnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Di Yesus ben de na pasi, A si Lefi, a manpikin fu Alfeus. A ben sidon pe den sma ben mus kon pai edemoni. Yesus taigi en taki: “Kon nanga Mi!” Ne Lefi opo, èn a bigin waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bakaten Yesus go nyan na Lefi oso. Furu fu den man di e piki edemoni, nanga tra sondusma, ben sidon e nyan makandra nanga Yesus nanga den man fu En. Bika bun furu fu den sortu sma disi ben de ini a bigi grupu sma di ben e waka nanga Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Den sabiman fu Gado wèt di ben de fu a grupu fu den Fariseiman, si tak' Yesus ben e nyan makandra nanga sondusma nanga den man di e piki edemoni. Fu dat'ede den aksi den man fu Yesus taki: “Fu sanede A e nyan makandra nanga den man di e piki edemoni, èn nanga den sondusma?” ");
INSERT INTO srnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Di Yesus yere san den aksi, A piki den taki: “Sma di gesontu no abi datra fanowdu, ma na sma di e siki abi datra fanowdu. Mi no kon fu kari bun sma, ma Mi kon fu kari sondusma.” ");
INSERT INTO srnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","A pisten dati den man di ben e teki leri fu Yohanes, nanga den Fariseiman, ben e faste. Dan wantu sma kon na Yesus taki: “Den man fu Yohanes nanga di fu den Fariseiman e faste. Ma fu sanede den man fu Yu no e du dati?” ");
INSERT INTO srnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus piki den taki: “Den sma di kon na wan trow-oso no kan tan sondro fu nyan te a trowmasra de drape nanga den. Solanga a trowmasra de nanga den, den no kan faste. ");
INSERT INTO srnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma a ten o kon tak' den o puru a trowmasra na den mindri. Dan ini den dei dati den sa faste. ");
INSERT INTO srnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","No wan sma e lapu wan owru krosi nanga wan pisi nyun wan. Bika te a nyun wan o krempi, a o hari a owru wan priti èn a olo o kon moro bigi. ");
INSERT INTO srnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sosrefi yu no e poti win di no lepi ete na ini owru winsaka. Bika te a win o kari dyesi, den winsaka o priti. Dan yu o lasi a win nanga den winsaka. Dat' meki yu e poti win di no lepi ete, na ini nyun winsaka.” ");
INSERT INTO srnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tapu wan sabadei Yesus ben e waka psa ini wan aleisigron. Di den e waka psa, den man fu Yesus broko wantu taki aleisi. ");
INSERT INTO srnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dan den Fariseiman taigi Yesus taki: “Fu sanede den man fu Yu e du wan sani san a wèt no wani fu yu du tapu a sabadei?” ");
INSERT INTO srnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus piki den taki: “Noiti un no leisi san David du di a ben de ini nowtu, èn angri ben e kiri en nanga den man di ben de nanga en? ");
INSERT INTO srnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ini a ten di Abyatar ben de grandomri, David go ini a oso fu Gado dan a nyan den brede san den ben poti aparti gi Gado. Owktu A gi den man fu en meki den nyan. Ma no wan sma kan nyan den brede dati, boiti den domri.” ");
INSERT INTO srnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Dan A taigi den taki: “Gado meki a sabadei gi libisma, ma A no meki en leki wan strafu gi den. ");
INSERT INTO srnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","So, a Manpikin fu Libisma na a basi fu a sabadei.” ");
INSERT INTO srnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus go wan tra leisi baka ini wan Dyukerki. Drape wan man ben de di ben abi wan malengri anu. ");
INSERT INTO srnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Den man ben luru Yesus fu si efu A bo dresi a man tapu a sabadei. Nanga dati den ben kan tyari En go na krutu. ");
INSERT INTO srnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dan Yesus taigi a man nanga a malengri anu taki: “Kon tnapu dya pe ala sma kan si yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne A aksi den man taki: “San a wèt e taki un kan du tapu a sabadei? Bun noso ogri? Fu puru wan sma na dede, noso fu kiri en?” Ma den hori den mofo. ");
INSERT INTO srnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nanga atibron Yesus luku ala den sma di ben lontu En. Ma A ben firi sari fu a fasi fa den ben tranga den ati. Dan A taigi a man taki: “Langa yu anu!” A man langa en anu, dan a kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dan den Fariseiman gwe. Wantron den go taki nanga den bakaman fu Herodes fu suku wan fasi fu kiri Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus go nanga den man fu En na a Meer fu Galilea. Wan bigi grupu sma fu Galilea ben go tu. Sosrefi bigi grupu sma di ben kmopo fu Yudea, ");
INSERT INTO srnNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusalem nanga Idumea, nanga sma fu a tra sei fu a Yordanliba, nanga sma di ben e libi ini a birti fu Tirus nanga Sidon. Bika den ben yere fu den sani san Yesus du. ");
INSERT INTO srnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesus taigi den man fu En fu den poti wan boto klari, fu te a bigi grupu sma bo pusu tumsi kon na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bika A ben dresi furu sma. Dat' meki ala sma di ben abi wan siki ben pusu kon na En tapu, fu kan fasi En. ");
INSERT INTO srnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te den takruyeye ben si Yesus, den ben trowe densrefi na En fesi, dan den ben bari taki: “Yu na a Manpikin fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma Yesus ben warskow den tranga tak' den no mus taigi no wan sma suma na En. ");
INSERT INTO srnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus kren go tapu wan bergi, èn suma A ben wani, A kari kon na En. Den go na En, ");
INSERT INTO srnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","dan Yesus teki twarfu man fu tan waka nanga En. A bo seni den fu go preiki, ");
INSERT INTO srnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","èn A bo gi den makti fu puru takruyeye tapu sma. ");
INSERT INTO srnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Disi na den twarfu man di A teki: Simon, di A ben kari Petrus, ");
INSERT INTO srnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobus nanga Yohanes, den manpikin fu Sebedeus. Yesus ben kari den tu man dati Boanerges, san wani taki: pikin fu dondru. ");
INSERT INTO srnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Moro fara A teki: Andreas, Filipus, Bartolomeus, Mateus, Tomas nanga Yakobus, a manpikin fu Alfeus. Dan A teki Tadeus, Simon fu a grupu fu den Seloten, ");
INSERT INTO srnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nanga Yudas Iskariot, a man di seri En. ");
INSERT INTO srnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dan Yesus go na oso. Agen wan lo sma kon na En, tak' En nanga den man fu En no ben man feni wan okasi fu nyan. ");
INSERT INTO srnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Di den famiri fu Yesus yere dati, den go fu teki En. Bika sma ben e taki: “Yesus edesei no e wroko bun.” ");
INSERT INTO srnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Den sabiman fu Gado wèt, di ben kmopo kon fu Yerusalem, ben taki: “Na Beelsebul, a edeman fu den takruyeye, de na En tapu. Dat' meki A man puru takruyeye tapu sma.” ");
INSERT INTO srnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus kari den kon na En, dan A gi den wantu agersitori. A taki: “Fa Satan kan puru Satan? ");
INSERT INTO srnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Efu den sma ini wan kondre e feti nanga densrefi, a kondre dati o broko. ");
INSERT INTO srnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Èn efu den sma ini wan oso no man feni en nanga densrefi, den o panya. ");
INSERT INTO srnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","We, efu Satan e feti nanga ensrefi èn efu prati de ini en kondre, dan a no o man tan rigeri èn a makti fu en e kon na wan kba. ");
INSERT INTO srnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","No wan sma kan broko go ini a oso fu wan tranga man fu fufuru en sani, efu a no tai en fosi. Baka te a tai en, dan fosi a o man teki en sani tyari gwe. ");
INSERT INTO srnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Fu tru Mi e taigi un taki: Libisma kan kisi pardon fu ala sondu, srefi efu den ben afrontu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma a sma di e afrontu a Santa Yeye, noiti no o kisi pardon fu a sani dati. Fu têgo a sondu dati o de na en tapu.” ");
INSERT INTO srnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus taki so fu di den ben taki: “Wan takruyeye de na En tapu.” ");
INSERT INTO srnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Den brada fu Yesus nanga En m'ma kon na En. Den ben tnapu na dorosei, dan den seni kari En. ");
INSERT INTO srnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wan bigi grupu sma ben sidon lontu Yesus. Dan den taigi En taki: “Yere, Yu m'ma nanga den brada fu Yu de na dorosei. Den e seni kari Yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesus piki den taki: “Suma na Mi m'ma nanga den brada fu Mi dan?” ");
INSERT INTO srnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dan Yesus luku den sma di ben lontu En, A taki: “Unu na Mi m'ma nanga den brada fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bika ala sma di e du a wani fu Gado, na Mi brada, Mi sisa nanga Mi m'ma.” ");
INSERT INTO srnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wan tra leisi baka Yesus bigin fu gi den sma leri na sei a meer. Di wan bun bigi grupu sma bigin lontu En, A opo go sidon ini wan boto tapu a watra. Ma den sma tan tnapu na syoro. ");
INSERT INTO srnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dan A bigin leri den sma furu sani nanga agersitori. Di A e leri den, A taki: ");
INSERT INTO srnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Un arki! Wan man ben go sai siri na ini en gron. ");
INSERT INTO srnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Di a e fringi den siri, wantu fadon tapu a pasi. Dan den pikinfowru kon nyan den. ");
INSERT INTO srnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tra siri fadon pe furu ston ben de ondro a doti. Den sproiti es'esi, bika den no ben abi furu doti. ");
INSERT INTO srnNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma di a son kon faya, a bron den pransun. Den drei gwe fu di den rutu no ben beri go dipi ini a gron. ");
INSERT INTO srnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Trawan fu den siri fadon tapu gron pe makamaka grasi e gro. Di a makamaka grasi bigin gro, a no gi den siri okasi fu gro doro. A grasi kiri den, èn den no gi nyanyan. ");
INSERT INTO srnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma tra siri fadon tapu bun doti. Den dati sproiti, den gro èn den gi nyanyan: dritenti, siksitenti nanga wan hondro tron so moro furu.” ");
INSERT INTO srnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dan Yesus taki: “Suma abi yesi fu yere, meki a yere!” ");
INSERT INTO srnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Di Yesus wawan ben de, den twarfu man fu En nanga den tra sma di ben lontu en, aksi En fu A taigi den san den agersitori wani taki. ");
INSERT INTO srnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dan Yesus taigi den taki: “A fasi fa Gado o tiri libisma na wan kibritori. Gado meki un kon ferstan a kibritori disi. Ma den tra sma e yere a sani disi soso na ini agersitori. ");
INSERT INTO srnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dat' meki den e luku ma den no e si, èn den e arki ma den no e ferstan. Noso den bo drai den libi, èn kisi pardon fu den sondu.” ");
INSERT INTO srnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dan Yesus aksi den taki: “Un no e ferstan a agersitori disi? Dan fa un o man ferstan ala den tra agersitori? ");
INSERT INTO srnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A siri san a man e sai, dati na a wortu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A siri di fadon tapu a pasi, e taki fu den sma di e yere a boskopu. Ma leki fa den yere a wortu, so Satan e kon wantron, dan a e puru a boskopu san sai na ini den ati. ");
INSERT INTO srnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tra sma de leki a siri di fadon pe furu ston de ondro a doti. Te den sma disi yere a boskopu, den e teki en wantron nanga prisiri. ");
INSERT INTO srnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma a boskopu no e beri rutu. Dat' meki den e bribi fu wan syatu pisten nomo. Te sma e pina den èn te sma de na den baka fu du den ogri fu di den e bribi a boskopu, dan wantron den e lasi bribi. ");
INSERT INTO srnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yu abi tra sma di de leki den siri di fadon pe makamaka grasi e gro. Den e yere a boskopu, ");
INSERT INTO srnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma den e broko den ede nanga a libi. Grontapu gudu e hari den, èn den e angri fu abi tratra sani. Dati e meki tak' a boskopu no man du en wroko ini den ati. ");
INSERT INTO srnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Den siri di fadon tapu bun doti, na den sma di yere a boskopu, di bribi en, èn di gi nyanyan: dritenti, siksitenti nanga wan hondro tron so moro furu.” ");
INSERT INTO srnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dan Yesus taigi den taki: “Yu no e leti wan kokolampu fu poti ondro wan embre noso ondro wan bedi. Ma yu e poti en tapu wan tafra. ");
INSERT INTO srnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bika noti san de na dungru o tan na dungru, èn ala sani san kibri, o kon na doro. ");
INSERT INTO srnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Efu wan sma abi yesi fu yere, meki a yere!” ");
INSERT INTO srnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesus taki: “Un mus luku bun san un e arki! O moro un e du dati, o moro un o ferstan sani, èn un o ferstan moro srefi. ");
INSERT INTO srnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bika a sma di wani ferstan sani, Gado o meki a ferstan moro. Ma a sma di no wani ferstan sani, Gado o puru a pikinso san a ben ferstan.” ");
INSERT INTO srnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dan Yesus taigi den sma taki: “Yu kan si a fasi fa Gado e tiri libisma leki a siri san wan man e sai ini en gron. ");
INSERT INTO srnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ala dei a man e sribi èn a e wiki. A ten dati a siri e sproiti èn a e gro, sondro fu a man srefi sabi fa a e psa. ");
INSERT INTO srnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A gron srefi e gi froktu: a siri e sproiti, a e gro, baka dati a e gi bromki, dan a e gi froktu. ");
INSERT INTO srnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te den froktu kon lepi, wantron a man e piki den, fu di a ten fu piki den froktu doro.” ");
INSERT INTO srnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dan Yesus taki: “San Mi kan teki fu sori unu fa a tiri fu Gado de? Noso sortu agersitori Mi kan gi fu meki un ferstan fa a de?” ");
INSERT INTO srnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dan Yesus taki: “A tiri fu Gado de leki wan mosterdsiri san yu e sai. A mosterdsiri na a moro pikin siri fu grontapu. ");
INSERT INTO srnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma te yu prani en, èn a gro, a e tron a moro bigi spesreibon san sma e prani ini den dyari. A e gi bigi taki, èn den pikinfowru e meki den nesi na ini.” ");
INSERT INTO srnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus ben gi furu fu den sortu agersitori disi fu ferteri den sma a boskopu. A leri den te nanga pe den ben kan ferstan. ");
INSERT INTO srnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Soso nanga agersitori A ben e taki nanga den. Ma te En wawan ben de nanga den man fu En, dan A ben e brokobroko gi den san den agersitori wani taki. ");
INSERT INTO srnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Di neti tapu a dei dati, Yesus taigi den man fu En taki: “Kon meki un go na abrasei fu a meer.” ");
INSERT INTO srnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yesus ben de ini a boto kba. Den man fu En libi den tra sma na syoro, dan den go ini a boto. Den tyari En gwe, ma tra boto ben go tu. ");
INSERT INTO srnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dan wan bun tranga winti bigin wai. Den skwala ben naki kon ini a boto, tak' a heri boto ben bigin furu nanga watra. ");
INSERT INTO srnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Yesus ben didon nanga En ede tapu wan kunsu e sribi na bakasei fu a boto. Den man go wiki En, dan den aksi En taki: “Meister, Yu no abi bisi tak' wi e dede?” ");
INSERT INTO srnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus opo dan A bari a winti fu no wai moro, èn A taigi a watra taki: “A nofo! No seki moro!” Dan a winti tapu fu wai, èn ala sani kon tiri. ");
INSERT INTO srnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dan A aksi den man taki: “Sanede unu e frede? Na bribi un no e bribi?” ");
INSERT INTO srnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Den man ben ferwondru srefsrefi. Den taigi makandra taki: “Suma na a Man disi? Winti nanga watra srefi e du san A e taki!” ");
INSERT INTO srnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na so den doro na a tra sei fu a meer ini a kontren fu den sma fu Gerasa. ");
INSERT INTO srnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Fa Yesus kmopo ini a boto, wan man kmopo ini a berpe kon na En. A man disi ben abi takruyeye na en tapu ");
INSERT INTO srnNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","èn a ben e tan ini a berpe. No wan sma ben man tai en hori moro, wan keti srefi no ben yepi. ");
INSERT INTO srnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bika furu leisi den ben tai en nanga keti, èn den ben bui en na en futu. Ma a ben koti den keti èn a ben broko den bui. A man ben tranga sote tak' no wan sma no ben man nanga en. ");
INSERT INTO srnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dei nanga neti a ben waka lontu mindri den grebi èn tapu den bergi e meki babari e naki ensrefi nanga ston. ");
INSERT INTO srnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesus ben de farawe ete di a man si En. A lon go na Yesus, dan a trowe ensrefi na En fesi. ");
INSERT INTO srnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","A bari nanga tranga sten taki: “Yesus, Manpikin fu a Moro Hei Gado, san Yu wani nanga mi? Mi e begi Yu ini a nen fu Gado: No pina mi!” ");
INSERT INTO srnNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bika Yesus ben bari en taki: “Yu takruyeye, kmopo tapu a man!” ");
INSERT INTO srnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dan Yesus aksi en taki: “Fa yu nen?” A piki taki: “Mi nen na Hilahila, bika un furu.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dan a begi Yesus tangitangi fu A no yagi den puru ini a birti. ");
INSERT INTO srnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Now yu ben abi bun furu agu drape di ben e nyan tapu a bergiskin. ");
INSERT INTO srnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Den takruyeye begi Yesus taki: “Seni un go na den agu, fu un kan go na ini den.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","So Yesus meki den go. Den takruyeye kmopo tapu a man go na ini den agu. Dan den agu lon saka fu a bergi go ini a meer. Den ben de wan tu dusun agu so di dede ini a watra. ");
INSERT INTO srnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Den man di ben luku den agu, lon gwe. Den go ini a foto nanga den presi ini a kontren fu a foto, go ferteri san ben psa. So ala den sma kon fu si san psa. ");
INSERT INTO srnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Den go na Yesus, dan den si a man sidon drape di ben abi hilahila takruyeye na en tapu. A ben weri krosi èn a ben de ensrefi. Ne ala den sma kon frede. ");
INSERT INTO srnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Den sma di si fa ala sani waka, ferteri den tra sma san ben psa nanga a man di ben abi den takruyeye na en tapu, nanga san ben psa nanga den agu. ");
INSERT INTO srnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dan den sma bigin begi Yesus tangitangi fu A kmopo ini a birti fu den. ");
INSERT INTO srnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Di Yesus ben e go ini a boto, a man aksi En efu a kan go nanga En. ");
INSERT INTO srnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma Yesus no ben wani. A taigi en taki: “Go na oso na den sma fu yu, dan yu ferteri den ala sani san Gado du gi yu, èn fa A ben abi sari-ati nanga yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","So a man bigin waka ini a kontren san den ben kari Dekapolis e ferteri san Yesus du gi en. Èn ala den sma ben ferwondru. ");
INSERT INTO srnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus drai go baka nanga a boto na abrasei. Dan wan bigi grupu sma kon na En di A ben de na a syoro fu a meer. ");
INSERT INTO srnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ne wan fu den edeman fu a Dyukerki kon na En. A man disi ben nen Yairus. Di a si Yesus, a fadon tapu en kindi na En futu. ");
INSERT INTO srnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","A begi En tangitangi taki: “Masra, a umapikin fu mi de fu dede. Mi e begi Yu fu kon poti Yu anu na en tapu fu a kon betre èn tan na libi.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dan Yesus go nanga en. Wan heri ipi sma ben go nanga En tu, èn moro nanga moro den ben e kon na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na mindri den sma wan uma ben de di ben abi wan siki san ben meki tak' a e lasi brudu twarfu yari kba. ");
INSERT INTO srnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A uma disi miti furu sani na den someni datra pe a ben go. Ala moni san a ben abi a ben pai datra, ma noti no ben yepi. Moro nanga moro a ben go na baka. ");
INSERT INTO srnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A uma disi ben yere fu den sani san Yesus du. Dan a waka mindri den sma, kon baka Yesus èn a fasi En krosi, ");
INSERT INTO srnNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","bika a taki: “Efu mi kan fasi En krosi nomo, mi o kon betre.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Fa a fasi Yesus krosi, wantron a brudu tapu fu lon. A uma firi ini en skin tak' a kon betre fu a siki. ");
INSERT INTO srnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus firi wantron tak' krakti kmopo fu En. A drai luku den sma, dan A aksi taki: “Suma fasi Mi na mi krosi?” ");
INSERT INTO srnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Den man fu En piki taki: “Masra, Yu srefi e si fa someni sma e kwinsi Yu fu ala sei. Dan fa Yu kan aksi suma fasi Yu?” ");
INSERT INTO srnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesus luku lontu fu si suma ben fasi En. ");
INSERT INTO srnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A frow ben sabi tak' a kon betre, dat' meki a skreki te a e beifi. Dan a fadon tapu en kindi fesi Yesus èn a ferteri En ala sani san ben psa nanga en. ");
INSERT INTO srnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dan Yesus taigi en taki: “Mi pikin, a bribi fu yu meki yu kon betre. Yu kan go nanga kowru-ati. Yu kon betre fu a siki.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus ben e taki ete nanga a frow, di wantu sma kmopo na Yairus oso nanga a boskopu taki: “A umapikin fu yu dede. Yu no abi fu weri a Meister En ede moro.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma Yesus poti san den sma taki na wan sei. A taigi Yairus taki: “No lasi ati. Bribi nomo.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesus no meki no wan sma go nanga En ini a oso fu Yairus, boiti Petrus, Yakobus nanga Yohanes, a brada fu Yakobus. ");
INSERT INTO srnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Di den doro drape, Yesus go miti wan lo babari. Den sma ben e bari e krei. ");
INSERT INTO srnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus go na inisei dan A aksi den sma taki: “Fu sanede unu e krei e meki babari? A pikin no dede, ma na sribi a e sribi.” ");
INSERT INTO srnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Den sma bigin lafu Yesus. Ma Yesus seni den go na dorosei, dan A teki a m'ma nanga a p'pa fu a pikin, nanga den dri man fu En go ini a kamra pe a pikin ben e didon. ");
INSERT INTO srnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesus hori a pikin na en anu, dan A taigi en taki: “Talita kum!” Dati wani taki: “Pikin, Mi e taigi yu fu opo!” ");
INSERT INTO srnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wantron a pikin opo èn a bigin waka. A ben abi twarfu yari. Den sma di ben de ini a kamra ben ferwondru srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma Yesus taigi den krinkrin tak' den no mus taigi no wan sma san ben psa. Dan A taigi den fu den gi a pikin wan sani fu nyan. ");
INSERT INTO srnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus kmopo fu pe A ben de, dan A go na a foto pe A ben kweki. Den man di ben e teki leri fu En go nanga En. ");
INSERT INTO srnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Di a sabadei doro, Yesus bigin gi den sma leri na ini a Dyukerki. Furu fu den sma di yere En tnapu nanga opo mofo. Den taki: “Pe A kmopo nanga den sani disi? Fa A du abi sowan koni? Pe A feni a makti fu du den bigi sani? ");
INSERT INTO srnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na En na a temreman, a manpikin fu Maria. Na En na a brada fu Yakobus, Yosef, Yudas nanga Simon. Den sisa fu En e libi dyaso na un mindri.” Dat' meki den no ben wani yere noti fu En. ");
INSERT INTO srnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dan Yesus taigi den taki: “Ala sma e lespeki wan profeiti, boiti den sma fu a foto pe a kweki, en eigi famiri nanga den ososma fu en.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dat'ede A no ben man du no wan bigi sani drape. Tapu wantu sikisma nomo A poti anu fu dresi den. ");
INSERT INTO srnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A ferwondru fu di den sma no ben bribi. Na so Yesus go na den tra dorpu ini a kontren, e gi den sma leri. ");
INSERT INTO srnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A kari den twarfu man fu En kon, dan A seni den tu na tu fu go panya a Bun Nyunsu. A gi den makti fu yagi takruyeye puru na tapu sma. ");
INSERT INTO srnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A taigi den taki: “Un no mus tyari noti fu te un de na pasi, boiti wan wakatiki. Un no mus tyari brede, un no mus tyari wan saka, un no mus tyari moni tu. ");
INSERT INTO srnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Un mus weri wan susu na un futu, ma un no mus tyari tra krosi.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yesus taki moro fara: “Te un doro wan foto, suku wan presi fu tan. Dan un mus tan drape te leki un gwe libi a foto. ");
INSERT INTO srnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma efu un doro wan presi pe den no wani fu un tan na den oso, èn den no wani arki san un e taki, dan un mus gwe. Ma un mus naki a santi san de na un futu puru, fu meki den sma ferstan tak' un no e tyari frantwortu moro gi den.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na so den man gwe, dan den bari a boskopu tak' den sma mus drai den libi. ");
INSERT INTO srnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Den yagi furu takruyeye puru tapu sma, den lobi oli gi furu sma di ben e siki, èn den dresi den. ");
INSERT INTO srnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kownu Herodes ben yere fu Yesus, bika ala sei En nen ben bari. Son sma ben taki: “Na Yohanes a Dopuman kon na libi baka. Na dat' meki A abi makti fu du den bigi sani.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma tra sma ben taki: “Na Elia.” Trawan baka ben taki: “Na wan profeiti, leki den wan fu fosten.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Di Herodes yere fu Yesus, a taki: “Mi ben meki den kapu a ede fu Yohanes puru. A mus de tak' na en kon baka na libi.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","A ben de so tak' Herodes ben trow nanga Herodias, a frow fu en brada Filipus. Ma Yohanes ben taigi Herodes taki: “Yu no kan trow nanga yu brada frow.” Dat'ede Herodes ben meki den grabu Yohanes, bui en poti na ini straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias ben hori Yohanes na ati èn a ben wani kiri en. Ma a no ben man, ");
INSERT INTO srnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","bika Herodes ben frede Yohanes. A ben sabi en leki wan santa man di e libi bun ini Gado ai. Dat' meki a ben sorgu tak' Herodias no kisi san a ben wani. Herodes ben lobi fu arki te Yohanes ben e taki, awinsi fa den sani san a taki, ben fon en konsensi. ");
INSERT INTO srnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma tapu a dei di Herodes ben friyari, Herodias feni a okasi fu kisi san a ben wani. Herodes ben gi wan fesa a dei dati gi den bigiman fu kondre, den edeman fu a legre nanga den prenspari sma fu Galilea. ");
INSERT INTO srnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dan a umapikin fu Herodias kon na inisei. A bigin dansi gi Herodes nanga den sma di a ben kari kon. Ala sma ben lobi fa a e dansi. Dan Herodes taigi a pikin taki: “Yu kan aksi mi san yu wani. Mi o gi yu en.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A sweri gi en taki: “Awinsi san yu aksi mi, mi o gi yu, awinsi na afu fu a kondre pe mi e rigeri!” ");
INSERT INTO srnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A pikin go na dorosei, dan a go aksi en m'ma taki: “San mi mus aksi?” En m'ma taigi en taki: “Aksi a ede fu Yohanes a Dopuman.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A pikin go wantron baka na inisei na kownu, dan a taki: “Mi wani fu yu gi mi a ede fu Yohanes a Dopuman nownowde na ini wan preti.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes ben sari srefsrefi. Ma fu di a ben meki a sweri na fesi ala den sma di ben de na tafra nanga en, a no ben man drai mofo. ");
INSERT INTO srnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wantron Herodes seni wan fu den srudati di e hori wakti fu go tyari a ede fu Yohanes kon. A srudati go na ini a straf'oso, dan a kapu Yohanes ede puru. ");
INSERT INTO srnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A tyari a ede fu Yohanes kon ini wan preti gi a pikin, dan a pikin gi en m'ma a preti nanga a ede na ini. ");
INSERT INTO srnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Di den man di ben e teki leri fu Yohanes yere san psa, den go teki a dedeskin fu Yohanes tyari go beri. ");
INSERT INTO srnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Di den boskopuman fu Yesus drai kon baka, den ferteri Yesus ala sani san den du, nanga san den leri den sma. ");
INSERT INTO srnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Furu sma ben e go kon, tak' Yesus nanga den man no ben feni wan okasi fu nyan srefi. Dat' meki Yesus taigi den taki: “Kon meki un go na wan presi pe sma no e libi, dan un kan bro pikinso.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","So den teki wan boto go na wan presi pe sma no e libi, pe den wawan ben kan de. ");
INSERT INTO srnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma den sma si di den e gwe, èn furu fu den ben sabi pe den bo go. So den sma kmopo fu ala foto waka es'esi go drape, dan den doro fosi Yesus nanga den man fu En. ");
INSERT INTO srnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Di Yesus kmopo ini a boto, A si wan bun bigi grupu sma. Ne A kisi wan dipi sari gi den. Bika den ben de leki skapu di no abi sma fu tyari den go na wei. Dan A bigin leri den furu sani. ");
INSERT INTO srnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Di a ben kon lati kba, den man fu Yesus kon na En, dan den taigi En taki: “Sma no e libi dya pe un de, èn a kon lati kba. ");
INSERT INTO srnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Seni den sma gwe na den kampu nanga den dorpu ini a birti, fu den kan go bai sani fu den nyan.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma Yesus piki taki: “Na unu mus gi den sma wan sani fu nyan.” Den man piki taki: “Masra, dan un o abi tu hondro solfrumoni fanowdu fu bai nyanyan gi ala den sma disi!” ");
INSERT INTO srnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus taki: “Un go luku omeni brede un abi.” Di den go luku, den taki: “Un abi feifi brede nanga tu fisi.” ");
INSERT INTO srnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dan Yesus taigi den fu den meki den sma sidon tapu a grasi ini grupu grupu. ");
INSERT INTO srnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Den sma go sidon ini grupu fu wan hondro sma, nanga grupu fu feifitenti sma. ");
INSERT INTO srnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dan Yesus teki den feifi brede nanga den tu fisi, A luku go na heimel dan A blesi den. Baka dati A broko den brede, dan A gi den man fu En fu den prati gi den sma. Sosrefi A prati den tu fisi gi den sma. ");
INSERT INTO srnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ala den sma nyan te den bere furu. ");
INSERT INTO srnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Baka dati den man fu Yesus furu twarfu baskita nanga pis'pisi brede nanga fisi san ben tan abra. ");
INSERT INTO srnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na feifi dusun mansma ben de di nyan den brede. ");
INSERT INTO srnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wantron baka a sani disi, Yesus taigi den man fu En fu den bigin go nanga a boto na Betsaida, na a tra sei fu a meer. Dan En bo kon baka te A seni den sma gwe. ");
INSERT INTO srnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Baka di A seni den gwe, A kren go tapu a bergi fu go begi. ");
INSERT INTO srnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Di neti tapu, a boto ben doro kba na mindrisei fu a meer èn Yesus wawan ben de na syoro. ");
INSERT INTO srnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesus si fa den man ben meki muiti e pari fu a boto go na fesi, bika a winti ben wai tranga. Dan fruku mamanten fosi dei kon krin, A waka tapu a watra go na den. A ben wani waka psa. ");
INSERT INTO srnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma di den man si tak' A e waka tapu a watra, den prakseri tak' na wan takrusani. Dan den bari, ");
INSERT INTO srnNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","bika den alamala ben skreki di den si En. Ma Yesus taigi den wantron taki: “No lasi ati! Na Mi. Un no abi fu frede!” ");
INSERT INTO srnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dan Yesus go ini a boto, èn a winti tapu fu wai. Den man fu Yesus ben ferwondru srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bika nanga aladi A ben meki den feifi brede kon moro furu, te nanga now den no ben ferstan san Yesus ben wani sori den fu Ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Di den koti a meer abra, den doro ini a kontren di den ben kari Genesaret. Dan den go na syoro. ");
INSERT INTO srnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Di den kmopo ini a boto, wantron den sma si tak' na Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dan den panya a nyunsu ala sei tak' Yesus doro. Ala sei pe den ben yere tak' Yesus de, den ben opo den sikisma tyari go tapu matrasi na En. ");
INSERT INTO srnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Awinsi pe Yesus ben go, ini den dorpu, ini den foto noso na ini den kampu, den sma ben tyari sikisma go na En. Den ben poti den sikisma didon na den presi pe den ben hori wowoyo. Dan den begi Yesus efu den sikisma ben kan fasi a lantyi fu En krosi nomo. Èn ala sma di fasi En ben kon betre. ");
INSERT INTO srnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Den Fariseiman nanga wantu sabiman fu Gado wèt di ben kmopo kon fu Yerusalem, kon na Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dan den si wantu fu den man fu Yesus e nyan brede sondro fu wasi den anu tapu a fasi fa a gwenti ben de. ");
INSERT INTO srnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A ben de so tak' den Fariseiman nanga ala den tra Dyu, no ben go nyan fosi den wasi den anu tapu a fasi fa den bigisma ben leri den. ");
INSERT INTO srnNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Efu den ben bai wan sani na wowoyo, den ben e wasi en tapu wan spesrutu fasi, fosi den nyan en. Den ben abi wan lo tra gwenti san den ben e hori, soleki fa den afo ben leri den. Na so den ben e wasi den kan, den patu nanga den pan tapu wan spesrutu fasi. ");
INSERT INTO srnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dan den Fariseiman nanga den sabiman fu Gado wèt aksi Yesus taki: “Fu sanede den man fu Yu no e du san den bigisma fu unu ben leri unu? Bika den e nyan brede sondro fu wasi den anu tapu a fasi fa un gwenti.” ");
INSERT INTO srnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesus piki den taki: “Un hoigriman unu! Yesaya ben abi leti di a taki fu unu taki: A folku disi e gi Mi grani nanga den mofo, ma den no lobi Mi srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na fu soso den e anbegi Mi, bika den e leri den sma sani san libisma srefi meki. ");
INSERT INTO srnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Un e poti a wèt fu Gado na wan sei, dan un e du san libisma leri unu.” ");
INSERT INTO srnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesus taki moro fara: “Un sabi fu poti Gado wèt na wan sei, nomo fu kan hori den gwenti fu unu. ");
INSERT INTO srnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses skrifi taki: ‘Un mus lespeki un m'ma nanga un p'pa.’ Moro fara a skrifi taki: ‘A sma di fluku en m'ma noso en p'pa, mus dede.’ ");
INSERT INTO srnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma unu e leri den sma tak' efu wan man taigi en m'ma nanga en p'pa taki: Ala sani san un ben kan kisi fu mi, na ‘korban’ (dati wani taki: mi gi en na Gado), ");
INSERT INTO srnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","dan so un e gi a man pasi fu no du not'noti moro gi en m'ma nanga en p'pa. ");
INSERT INTO srnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na sowan fasi un no e teri a wortu fu Gado moro, fu un kan du san den bigisma fu unu ben leri unu. Èn un e du furu fu den sortu sani disi.” ");
INSERT INTO srnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus kari ala den sma agen fu kon na En, dan A taigi den taki: “Un alamala arki Mi èn ferstan bun san Mi e taki. ");
INSERT INTO srnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","A no san wan sma e nyan e meki tak' a no krin ini Gado ai. Ma na san e kmopo ini en ati kon na dorosei e meki tak' a no krin. ");
INSERT INTO srnNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Efu wan sma abi yesi fu yere, meki a yere!” ");
INSERT INTO srnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus libi den sma, dan A go na oso. Dan den man fu En aksi En san A ben wani taki nanga a agersitori disi. ");
INSERT INTO srnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesus piki den taki: “San! Unu srefi no man ferstan den sani di Mi e taki? Un mus ferstan tak' a no san wan sma e nyan e meki tak' a no krin ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bika nyanyan no e saka go ini wan sma ati, ma a e go ini en bere, èn a e kmopo baka pe a mus kmopo.” Na so Yesus sori den tak' ala nyanyan bun fu nyan. ");
INSERT INTO srnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesus taki moro fara: “Na den sani san kmopo ini wan sma ati e meki tak' a no krin ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bika den sani san e kmopo fu inisei, fu a ati fu wan sma, na takru prakseri, takru lostu, fufuru nanga kiri. ");
INSERT INTO srnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Moro fara: huru, bigi-ai, ogri-ati, kori fasi, yayolibi, dyarusu fasi, taki takru fu trawan, bigimemre nanga fu du lawlaw sani. ");
INSERT INTO srnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ala den takru sani disi e kmopo ini wan sma ati kon na doro, èn na dati e meki tak' wan sma no krin na ini Gado ai.” ");
INSERT INTO srnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus kmopo fu drape, dan A go na a kontren fu a foto Tirus. A go na wan sma oso, ma A no ben wani fu sma sabi pe A de. Ma toku sma kon sabi pe A e tan. ");
INSERT INTO srnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wan frow ben abi wan umapikin di ben abi wan takruyeye na en tapu. Di a yere pe Yesus de, wantron a go na En, dan a fadon tapu en kindi na En futu. ");
INSERT INTO srnNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A frow disi no ben de wan Dyusma. A ben gebore na ini Fenisia di ben de wan pisi fu Siriakondre. A begi Yesus fu puru a takruyeye na tapu en umapikin. ");
INSERT INTO srnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesus taigi en taki: “Den pikin mus kisi nyanyan fosi. Bika a no bun fu puru a brede na a mofo fu den pikin, trowe gi den dagu.” ");
INSERT INTO srnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma a frow piki En taki: “Masra, Yu abi leti. Ma srefi den dagu ondro a tafra e nyan a sakasaka san e fadon fu den brede fu den pikin.” ");
INSERT INTO srnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ne Yesus taigi en taki: “Fu di yu taki so, yu kan go na yu oso. A takruyeye kmopo tapu yu umapikin.” ");
INSERT INTO srnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Di a frow go na oso, a si tak' a pikin didon tapu a bedi, èn a takruyeye ben kmopo na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus drai kmopo ini a kontren fu Tirus, dan A waka psa ini Sidon nanga Dekapolis go na a Meer fu Galilea. ");
INSERT INTO srnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Den sma tyari wan man kon na En di ben dofu èn di no ben man taki so bun. Dan den begi Yesus fu poti En anu na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus puru a man mindri den sma kon na wan sei, dan A poti En finga go ini a man yesi. A poti pikin spiti na En finga, dan a fasi a man tongo. ");
INSERT INTO srnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesus luku go na loktu, dan A dyeme. A taigi a man taki: “Efata!” Dat' wani taki: Kon opo! ");
INSERT INTO srnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wantron a man ben kan yere, èn a ben kan taki bun. ");
INSERT INTO srnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dan Yesus komanderi den sma tak' den no mus taigi no wan sma. Ma o moro A ben taigi den fu no du en, o moro den ben panya a nyunsu. ");
INSERT INTO srnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Den sma ben ferwondru srefsrefi. Den taki: “Ala sani san a Man disi e du, A e du bun. A e meki dofusma yere, èn A e meki babawsma taki.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wan tra leisi wan bigi grupu sma ben kon agen na Yesus. Di Yesus si tak' den sma no ben abi noti moro fu nyan, A kari den man fu En kon dan A taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mi e sari den sma, bika na dri dei langa kba den de dya nanga Mi, èn den no abi noti fu nyan. ");
INSERT INTO srnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Efu Mi seni den gwe nanga angribere na oso, den kan flaw na pasi, bika sonwan fu den kmopo fu farawe kon dyaso.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dan den man piki En taki: “Fa un o feni nyanyan gi den sma? Bika sma no e libi ini a birti dya.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ne Yesus aksi den taki: “Omeni brede un abi?” Den taki: “Un abi seibi brede.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dan Yesus taigi ala den sma fu go sidon na gron. A teki den seibi brede, dan A taki Gado tangi. A broko den brede, dan A gi den man fu En fu den prati gi den sma. ");
INSERT INTO srnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Den ben abi wantu fisi tu. Baka di Yesus blesi den, A taigi den man fu En fu prati den fisi gi den sma tu. ");
INSERT INTO srnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Den alamala nyan te den bere furu. Dan di den piki den pis'pisi di ben libi ete, den furu seibi baskita. ");
INSERT INTO srnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na wan fo dusun sma so ben drape. Dan Yesus seni den sma gwe. ");
INSERT INTO srnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wantron baka dati Yesus nanga den man fu En go ini a boto dan den go na a kontren fu Dalmanuta. ");
INSERT INTO srnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Den Fariseiman kon na Yesus, kon krutu nanga En. Den ben wani fu A sori den wan marki di kmopo fu Gado, nomo fu tesi En. ");
INSERT INTO srnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus dyeme, dan A taki: “Fu sanede unu fu a ten disi wani si wan marki? Fu tru Mi e taigi un taki: Un no o kisi no wan enkri marki fu si.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dan Yesus waka gwe libi den. A go baka ini a boto, dan A koti go na abrasei. ");
INSERT INTO srnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Now den man ben fergiti fu tyari brede. Den ben abi wan brede nomo ini a boto. ");
INSERT INTO srnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus taigi den taki: “Un mus luku bun nanga a dyesi fu den Fariseiman, nanga a di fu Herodes.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dan den man bigin taki a tori nanga makandra. Den taki: “Na fu di un no abi brede meki A taki so.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Yesus ben sabi san den e taki, dat' meki A aksi den: “Fu sanede un e taki tak' brede no de? Na ferstan un no man ferstan ete? Na breni un breni? ");
INSERT INTO srnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Un abi ai, ma un no e si. Un abi yesi, ma un no e yere. Baka di Mi broko den feifi brede prati gi feifi dusun sma, omeni baskita nanga brede ben libi? Un kan memre ete?” Den man piki taki: “Iya, na twarfu baskita ben libi.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Èn baka di Mi broko den seibi brede prati gi den fo dusun sma, omeni baskita nanga brede ben libi?” Den man piki taki: “Seibi baskita ben libi.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dan Yesus taki: “Dan fa un ai no opo ete?” ");
INSERT INTO srnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na so den kon doro na Betsaida. Den sma tyari wan breniman kon na En, dan den begi Yesus fu A fasi a man fu a si baka. ");
INSERT INTO srnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus hori a man na en anu, tyari en go na dorosei fu a dorpu. A spiti ini a man ai, èn A poti En anu na den tapu. Dan Yesus aksi en taki: “Yu e si wan sani?” ");
INSERT INTO srnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A man piki taki: “Mi e si libisma, ma den gersi bon di e waka.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dan Yesus poti En anu ete wan leisi tapu den ai fu a man, dan a ben man si krin. Den ai fu en ben kon bun baka. Bigin fu a ten dati a man bigin si ala sani krin. ");
INSERT INTO srnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dan Yesus seni a man go na oso, ma A taigi en taki: “Yu no mus drai go baka ini a dorpu.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dan Yesus go nanga den man fu En na den dorpu ini a birti fu Sesarea Filipi. Di den de na pasi, A aksi den man fu En taki: “Suma den sma e taki tak' Mi de?” ");
INSERT INTO srnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Den man piki taki: “Son sma e taki: Yu na Yohanes a Dopuman. Tra sma e taki: Yu na Elia. Trawan baka e taki: Yu na wan fu den profeiti.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dan Yesus aksi den taki: “Ma unu, suma unu e taki tak' Mi de?” Petrus piki En taki: “Yu na a Mesias.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dan Yesus warskow den tak' den no mus taigi no wan sma a sani disi. ");
INSERT INTO srnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dan now Yesus bigin taigi den man fu En tak' a Manpikin fu Libisma o abi fu nyan furu pina. Den fesiman fu a folku, den prenspari domri, nanga den sabiman fu Gado wèt o poti En na wan sei. Sma o kiri En, ma baka dri dei A o kon baka na libi. ");
INSERT INTO srnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na so Yesus taigi den krin san o psa nanga En. Ma Petrus kari Yesus go na wan sei, dan a taigi En tak' A no mus taki sowan sani. ");
INSERT INTO srnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesus drai luku den tra man fu En, dan A bari Petrus taki: “Kmopo na Mi tapu, Satan! Bika yu no e prakseri den sani fu Gado, ma na libisma sani yu e prakseri.” ");
INSERT INTO srnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dan Yesus kari a bigi grupu sma nanga den man fu En kon na En. A taigi den taki: “Efu wan sma wani waka na Mi baka, a mus poti en eigi wani na wan sei. A mus de klar'klari fu nyan pina, èn a mus kon nanga Mi. ");
INSERT INTO srnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bika a sma di wani tan libi fa a wani, o lasi en libi. Ma a sma di e poti en libi na wan sei fu Mi ede nanga fu a Bun Nyunsu ede, sa kisi a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bika san yu e wini efu yu kisi ala sani fu grontapu, ma yu lasi a libi fu têgo? ");
INSERT INTO srnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Èn san wan sma o man gi fu kisi a libi fu têgo? ");
INSERT INTO srnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mi e taigi un taki: Den sma fu a ten disi no wani sabi not'noti fu Gado, èn den e tan du sondu. Efu wan fu den sa taki tak' a no sabi Mi, noso den sani san Mi e leri, dan te a Manpikin fu Libisma o drai kon baka nanga den santa engel èn nanga a bigi makti fu En P'pa, dan En srefi o taki tu tak' A no sabi a sma dati.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Dan Yesus taigi den taki: “Fu tru Mi e taigi un taki: Son sma de dya na un mindri di no sa dede fosi den si Gado kon nanga makti èn A bigin tiri libisma.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Siksi dei baka dati Yesus teki Petrus, Yakobus nanga Yohanes, tyari go na tapu wan hei bergi pe den wawan ben kan de. Dan let' na den fesi a skin fu Yesus kenki. ");
INSERT INTO srnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","En krosi ben kon so weti tak' a e brenki. Sma no de na grontapu di bo man meki sowan weti krosi. ");
INSERT INTO srnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dan wantron so Elia nanga Moses ben de fu si, èn den ben e taki nanga Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ne Petrus taigi Yesus taki: “Masra, a bun tak' un de dyaso. Meki un meki dri tenti: wan gi Yu, wan gi Moses nanga wan gi Elia.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petrus taki so, fu di a no ben sabi san fu taki. Bika en nanga den tu trawan ben skreki srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dan wan wolku saka kon na den tapu, èn wan sten taki kmopo ini a wolku taki: “Disi na Mi Manpikin di Mi lobi. Un mus arki san A e taki.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Di den luku lontu, den no si no wan sma tnapu drape moro nanga den, boiti Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Di den ben e saka fu a bergi, Yesus warskow den tak' den no mus taigi no wan sma san den si, solanga a Manpikin fu Libisma no ben dede èn kon baka na libi. ");
INSERT INTO srnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","So den hori a sani disi gi densrefi, ma den aksi densrefi san Yesus ben wani taki di A taigi den tak' A o kon baka na libi. ");
INSERT INTO srnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dan den aksi En taki: “Fu sanede den sabiman fu Gado wèt e taki tak' Elia mus kon fosi a Mesias doro?” ");
INSERT INTO srnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus piki den taki: “A tru tak' Elia o kon fosi fu seti ala sani. Ma san skrifi fu a Manpikin fu Libisma? A skrifi tak' A o nyan pina èn den o poti En na wan sei. ");
INSERT INTO srnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma Mi e taigi un taki: Elia kon, èn den du nanga en san den ben wani, soleki fa a ben skrifi fu en.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Di Yesus nanga den dri man go baka na den trawan, den si wan bigi grupu sma tnapu lontu den. Den man fu En ben hari taki nanga den sabiman fu Gado wèt. ");
INSERT INTO srnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Den sma ben tnapu nanga opo mofo di den si Yesus e kon. Wantron den waka miti En, dan den gi En odi. ");
INSERT INTO srnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ne Yesus aksi den man fu En taki: “Fu san unu nanga den man ben e hari taki so?” ");
INSERT INTO srnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dan wan man ini a grupu piki taki: “Meister, mi tyari a boi fu mi kon na Yu, bika a abi wan takruyeye na en tapu san e meki a no man taki. ");
INSERT INTO srnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Awinsi pe a sani kon na en tapu, let' drape a e fringi a boi na gron. Skuma e kmopo ini en mofo, a e kaw en tifi, dan a e kon steifi. Mi ben aksi den man di e teki leri fu Yu fu yagi en puru na en tapu, ma den no ben man.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dan Yesus taigi den sma taki: “Ai baya! Yu kan si tak' un no e bribi. O langa Mi mus tan nanga unu? O langa Mi mus teki den sani disi fu unu ete?” Dan A taigi a man taki: “Tyari a boi kon gi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dan den tyari a boi go na Yesus. Di a takruyeye si Yesus, wantron a naki a boi stoipi. A boi fadon na gron e lolo e puru skuma na ini en mofo. ");
INSERT INTO srnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus aksi a p'pa taki: “Olanga a sani disi e psa kba nanga a boi?” ");
INSERT INTO srnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A p'pa piki taki: “A sani disi e psa nanga en sensi a de wan pikin. Furu leisi a takruyeye meki a boi go na ini faya nanga watra nomo fu kiri en. Ma efu Yu ben sa man du wan sani, yepi unu! Abi sari-ati nanga unu!” ");
INSERT INTO srnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus taigi a man taki: “Yu no mus taki: Efu yu ben sa man! Bika a sma di e bribi kan du ala sani.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wantron a p'pa fu a boi bari taki: “Mi e bribi. Ma mi bribi swaki. Masra, yepi mi!” ");
INSERT INTO srnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Di Yesus si tak' moro nanga moro sma e kon tnapu drape, A bari a takruyeye fu kmopo tapu a boi. A taki: “Yu dofu èn babaw yeye yu, Mi e komanderi yu fu kmopo tapu a boi! Noiti moro yu mus drai kon baka na en!” ");
INSERT INTO srnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A takruyeye kmopo tapu a boi nanga bigi babari èn nanga hebi stoipi. Dan a boi tan didon leki wan dede. Dat' meki moro furu fu den sma ben taki tak' a dede. ");
INSERT INTO srnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Yesus teki a boi na en anu fu a opo tnapu. Dan a boi opo tnapu tu. ");
INSERT INTO srnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Baka dati Yesus go ini wan oso. Di den man fu Yesus wawan ben de nanga En, den aksi En taki: “Fu sanede un no ben man yagi a takruyeye puru tapu a boi?” ");
INSERT INTO srnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus piki den taki: “Soso nanga begi wawan yu kan yagi den sortu takruyeye disi puru.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Di den kmopo fu drape, den waka psa ini Galilea fu go moro fara. Ma Yesus no ben wani fu no wan sma sabi tak' A de drape, ");
INSERT INTO srnNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bika A ben e gi den man fu En leri. A taigi den taki: “Den o gi a Manpikin fu Libisma abra na ini anu fu sma di o kiri En. Ma dri dei baka te den kiri En, A o kon baka na libi.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma den man no ben ferstan san Yesus ben wani taki, èn den ben frede fu aksi En. ");
INSERT INTO srnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dan den doro na Kafarnaum. Di Yesus doro na oso, A aksi den man taki: “Fu san un ben taki nanga makandra di un ben de na pasi?” ");
INSERT INTO srnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma den no piki, bika di den ben de na pasi, den ben taki nanga makandra fu sortu wan fu den na a moro prenspari wan. ");
INSERT INTO srnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus go sidon, dan A kari den twarfu man kon. A taigi den taki: “Efu wan sma wani de a moro prenspari wan, a mus saka ensrefi ondro ala den trawan, èn a mus dini den ala.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dan A teki wan pikin poti tnapu na den mindri. A poti En anu lontu en, dan A taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“A sma di opo en doro gi sowan pikin ini Mi nen, e opo en gi Mi. Èn a sma di opo en doro gi Mi, no opo en gi Mi, ma a opo en gi a Wan di seni Mi kon.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dan Yohanes taigi Yesus taki: “Meister, un si wan man e yagi takruyeye puru na sma tapu na ini Yu nen. Un ben suku fu tapu en, bika a no de ini a grupu fu unu.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Yesus piki taki: “No tapu en. Bika wan sma di du wan bigi sani na ini Mi nen, no o man taki ogri fu Mi so gaw. ");
INSERT INTO srnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bika efu wan sma no e suku fu tapu a wroko fu unu, dan a de na un sei. ");
INSERT INTO srnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Fu tru Mi e taigi un taki: A sma di sa gi un wan kan watra ini a nen fu Kristus fu di un na sma di e teki leri fu En, sa kisi en pai fu dati.” ");
INSERT INTO srnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesus taki moro fara: “A sma di e meki wan fu den pikinwan disi di e bribi ini Mi fadon ini sondu, mus luku bun! A bo moro bun gi en efu den tai wan bigi ston na en neki èn fringi en go na ini a se. ");
INSERT INTO srnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Efu yu anu e meki yu sondu, kapu en puru. A moro betre tak' yu lasi yu wan sei anu, ma yu kisi a libi fu têgo, dan tak' den trowe yu nanga ala tu anu go ini a faya fu hel, di no man dede. ");
INSERT INTO srnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Drape den woron san e nyan den, noiti no e dede, èn a faya san e bron den noiti no e dede. ");
INSERT INTO srnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Èn efu yu futu e meki yu sondu, kapu en puru. A moro betre tak' yu lasi yu wan sei futu, ma yu kisi a libi fu têgo, dan tak' den trowe yu nanga ala tu futu go na ini hel. ");
INSERT INTO srnNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Drape den woron san e nyan den, noiti no e dede, èn a faya san e bron den noiti no e dede. ");
INSERT INTO srnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Efu yu ai e meki yu sondu, diki en puru. A moro betre tak' yu kon ondro a tiri fu Gado nanga wan ai, dan tak' den trowe yu nanga ala tu ai go na ini hel. ");
INSERT INTO srnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Drape den woron san e nyan den, noiti no e dede, èn a faya san e bron den noiti no e dede. ");
INSERT INTO srnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ala sma musu psa ini a faya fu kon de leki sowtu. ");
INSERT INTO srnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sowtu bun. Ma efu sowtu lasi en krakti, fa yu o man gi en tesi baka? Un mus de leki sowtu, èn un mus libi ini freide nanga makandra.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus kmopo fu drape, dan A go na a distrikti Yudea nanga a kontren abrasei fu a Yordanliba. Agen wan lo sma kon na En, èn A bigin gi den leri soleki fa A ben gwenti fu du. ");
INSERT INTO srnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dan wantu Fariseiman kon na En fu tesi En. Den aksi En taki: “Wan man kan broko trow nanga en frow?” ");
INSERT INTO srnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus aksi den taki: “San Moses skrifi tak' un kan du?” ");
INSERT INTO srnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Den taki: “Moses taki tak' wan man kan broko trow, ma a mus gi a frow wan brifi san e sori tak' a trow broko.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus piki taki: “Na fu di un no wani du san Gado taki, meki Moses skrifi a sani disi. ");
INSERT INTO srnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma na a bigin di Gado meki libisma, A meki den leki man nanga uma. ");
INSERT INTO srnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Dat'ede wan man sa gwe libi en m'ma nanga en p'pa fu go libi nanga en frow. ");
INSERT INTO srnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Dan den tu sma disi sa de leki wan enkri sma. So den no de tu sma moro, ma den de leki wan. ");
INSERT INTO srnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Èn san Gado tyari kon na wan, libisma no mus prati.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Di den go na oso, den man fu Yesus aksi En a tori disi baka. ");
INSERT INTO srnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dan Yesus taigi den taki: “A man di broko trow nanga en frow dan a trow baka, e huru gi en fosi frow. ");
INSERT INTO srnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Èn efu wan frow broko trow nanga en masra èn a trow baka, dan sowan frow e libi wan huru libi tu.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Den sma ben e tyari den pikin kon na Yesus fu A fasi den. Ma den man fu Yesus bari den. ");
INSERT INTO srnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Di Yesus si san den man e du, a mandi srefsrefi. A taigi den taki: “Meki den pikin kon na Mi. No tapu den, bika na sma leki den pikin disi, Gado e tiri. ");
INSERT INTO srnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Fu tru Mi e taigi un taki: Efu yu no kon na Gado leki wan pikin fu A tiri yu, dan noiti yu o man kon ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesus brasa den pikin, dan A poti anu na den tapu èn A blesi den. ");
INSERT INTO srnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Di Yesus ben e waka go moro fara, wan man lon kon na En. A saka kindi gi En, dan a aksi En taki: “Bun Meister, san mi mus du fu kisi a libi fu têgo?” ");
INSERT INTO srnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus piki en taki: “Fu sanede yu e taki tak' Mi bun? No wan sma bun, boiti Gado. ");
INSERT INTO srnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yu srefi sabi san a wèt fu Gado e taki: Yu no mus kiri, yu no mus huru, yu no mus fufuru, yu no mus lei gi trawan, yu no mus bedrigi sma, èn yu mus lespeki yu m'ma nanga yu p'pa.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A man piki taki: “Meister, sensi mi pikin mi hori ala den wèt disi.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Di Yesus luku a man, a firi wan lobi gi en. Dan A taigi en taki: “Wan sani libi ete fu yu du. Go seri den sani san yu abi, dan yu e prati a moni gi pôtisma. So yu o abi wan gudu na heimel. Baka dati yu e kon waka na Mi baka.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Di a man yere san Yesus taki, en fesi kenki. A gwe nanga sari bika a ben abi furu gudu. ");
INSERT INTO srnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus luku lontu, dan A taigi den man fu En taki: “A sa tranga gi sma di lai moni fu den poti densrefi ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Den man fu En ben ferwondru fu a sani san Yesus taki. Ma Yesus taki baka taki: “Mi pikin, a tranga fu kon ondro a tiri fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A moro makriki gi wan asaw fu psa ini wan nanai-olo, dan fu wan guduman poti ensrefi ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Den man ben ferwondru srefsrefi. Den taigi Yesus taki: “Suma Gado o man ferlusu dan?” ");
INSERT INTO srnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus luku den man fu En, dan A taigi den taki: “Libisma no man du en, ma Gado man. Bika Gado kan du ala sani.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dan Petrus bigin taigi Yesus taki: “Ma luku, wi libi ala sani san wi ben abi fu waka na Yu baka.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus piki en taki: “Fu tru Mi e taigi un taki: Ala sma di libi en oso, noso en brada nanga en sisa, noso en m'ma nanga en p'pa, noso en pikin nanga en gron fu Mi ede èn fu a Bun Nyunsu ede, o kisi den sani disi baka. ");
INSERT INTO srnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ini a libi disi Gado o gi den sma dati hondro tron so moro furu oso, brada nanga sisa, m'ma, pikin nanga gron. Ma sma o de na den baka fu du den ogri. Dan ini a ten san e kon, A o gi den a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma furu fosiwan o tron lastewan, èn furu lastewan o tron fosiwan.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Den ben de na pasi fu go na Yerusalem èn Yesus ben e waka na fesi. Den man fu Yesus ben ferwondru, èn den tra sma di ben waka nanga den ben frede. Dan Yesus kari den twarfu man fu En kon na wan sei, dan A bigin ferteri den san nanga san o miti En. ");
INSERT INTO srnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A taki: “Luku, un de na pasi fu go na Yerusalem. Drape den o gi a Manpikin fu Libisma abra na den prenspari domri nanga den sabiman fu Gado wèt. Den man dati sa teki a besroiti tak' A mus dede. Dan den o gi En abra na den sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Den o teki En leki spot'popki, den o spiti na En tapu, den o wipi En, dan den o kiri En. Ma baka dri dei, A o kon baka na libi.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobus nanga Yohanes, den tu manpikin fu Sebedeus, kon na Yesus. Den taki: “Meister, un ben sa wani fu Yu du a sani gi unu san un o aksi Yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus aksi den taki: “San un wani tak' Mi mus du gi unu?” ");
INSERT INTO srnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Den piki taki: “Un ben sa wani tak' te Yu sidon na tapu Yu kownusturu, Yu sa meki wan fu unu sidon na Yu let'anu sei, èn a trawan na Yu kruktu-anu sei.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma Yesus taigi den taki: “Un no sabi san un e aksi. Un sa man nyan a pina san Mi mus nyan? Un sa wani dede a dede san Mi mus dede?” ");
INSERT INTO srnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Den piki Yesus taki: “Iya, un sa man.” Yesus taigi den taki: “Un sa nyan a pina san Mi o nyan, èn un sa dede a dede san Mi o dede. ");
INSERT INTO srnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma a no Mi e taki suma o sidon na Mi let'anu sei noso na Mi kruktu-anu sei. Gado libi den presi dati gi den sma di A wani fu sidon drape.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Di den tra tin man yere a tori disi, den bigin mandi nanga Yakobus nanga Yohanes. ");
INSERT INTO srnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dat' meki Yesus kari den alamala kon, dan A taigi den taki: “Un sabi tak' den sma di e tiri den folku, e rigeri abra den. Èn den sma di abi makti e dwengi a folku fu du san den wani. ");
INSERT INTO srnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma unu no mus du leki den. Efu wan fu unu wani de wan prenspari sma na un mindri, dan a mus dini den trawan. ");
INSERT INTO srnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Èn a sma di wani de a fosiwan na un mindri, mus de leki wan srafu gi ala den trawan. ");
INSERT INTO srnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bika a Manpikin fu Libisma, no kon tu fu sma dini En. Ma A kon fu dini trawan èn fu gi En libi fu meki furu sma kon fri.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na so den doro na Yeriko. Dan di Yesus nanga den man fu En nanga wan bigi grupu sma gwe libi Yeriko, den miti nanga wan breniman di ben sidon na sei pasi. A man disi ben nen Bartimeus, èn en p'pa ben nen Timeus. ");
INSERT INTO srnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Di Bartimeus yere tak' na Yesus fu Nasaret e kon, a bigin bari taki: “Yesus, Manpikin fu David, abi sari-ati nanga mi!” ");
INSERT INTO srnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wan lo sma bari en fu a tapu en mofo, ma a bigin bari moro tranga taki: “Yesus, Manpikin fu David, abi sari-ati nanga mi!” ");
INSERT INTO srnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ne Yesus tan tnapu, dan A taigi den sma taki: “Un kari en kon.” Dan den sma kari en. Den taki: “Hori doro. Opo kon. A e kari yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeus puru en mantel, a dyompo opo, dan a go na Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus aksi en taki: “San yu wani tak' Mi mus du gi yu?” A breniman piki taki: “Masra, mi wani si.” ");
INSERT INTO srnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus piki en taki: “Yu kan go. A bribi fu yu meki yu kon betre.” Wantron a man bigin si, dan a waka a pasi go doro nanga Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus nanga den man fu En ben kon krosbei fu Yerusalem. Di den doro na den dorpu Betfaga nanga Betania ini a birti fu a Oleifbergi, A seni tu fu den man fu En go na fesi. ");
INSERT INTO srnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","A taigi den taki: “Un go na a dorpu san de na un fesi. Leki fa un e go ini a dorpu, un o si wan yongu buriki san den sma tai drape. Noiti ete wan sma ben sidon na en tapu. Un lusu en, dan un tyari en kon dya. ");
INSERT INTO srnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Efu wan sma sa aksi unu fu sanede un e lusu en, un mus piki taki: ‘Masra abi en fanowdu. Te A kba, A sa seni en wantron kon dya baka.’ ” ");
INSERT INTO srnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na so den man gwe, den feni a yongu buriki tai na a doro fu wan oso na sei strati, dan den lusu a buriki. ");
INSERT INTO srnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Wantu fu den sma di ben tnapu drape aksi den taki: “San un e du? Fu sanede un e lusu a buriki?” ");
INSERT INTO srnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Den man piki den sma leki fa Yesus taigi den, dan den sma libi den meki den gwe nanga a buriki. ");
INSERT INTO srnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Den tyari a buriki go gi Yesus, dan den bradi den krosi na en tapu. Dan Yesus go sidon na tapu. ");
INSERT INTO srnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Furu sma bradi den krosi tapu a pasi gi En. Trawan koti taki puru ini den gron, dan den poti den tapu a pasi. ");
INSERT INTO srnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Den sma di ben e waka na En fesi nanga na En baka, ben e bari taki: Hosana! Blesi de tapu a Wan di e kon ini a nen fu Masra! ");
INSERT INTO srnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Blesi fu a kownukondre fu un afo David, di de fu kon. Hosana! Prijse Gado di de na heimel! ");
INSERT INTO srnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Di Yesus doro na Yerusalem, A go ini a mamakerki dan A waka lontu e luku ala sani. Baka dati En nanga den twarfu man fu En go na Betania, bika a ben kon lati kba. ");
INSERT INTO srnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A tamara fu en, di den e drai kmopo fu Betania, angri bigin kiri Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Fu fara Yesus si wan figabon di ben lai nanga grun wiwiri. Dan A go na a bon fu luku efu A ben sa feni froktu na en fu nyan. Ma di A doro na a bon, A si den grun wiwiri nomo, bika a no ben de figaten. ");
INSERT INTO srnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dan Yesus taigi a bon taki: “Noiti moro wan sma sa man nyan wan froktu fu yu.” Den man fu En yere di A taki a sani dati. ");
INSERT INTO srnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Di Yesus doro baka ini Yerusalem, A go ini a mamakerki. Dan A bigin yagi ala den sma gwe di ben e bai sani noso seri sani drape. A drai den tafra tapu fu den man di ben e broko moni. A du a srefi sani nanga den sturu fu den man di ben e seri doifi. ");
INSERT INTO srnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A tapu ala sma di ben e teki a dyari fu a mamakerki leki boropasi fu syow sani psa. ");
INSERT INTO srnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dan Yesus taigi den sma taki: “A skrifi taki: ‘Mi oso mus de wan presi pe ala folku kan kon fu begi.’ Ma un meki a tron wan nesi fu fufuruman.” ");
INSERT INTO srnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Den prenspari domri nanga den sabiman fu Gado wèt yere san Yesus taki. So den bigin suku wan fasi fu kiri En. Den ben frede fu Yesus, bika ala den sma ben e arki a leri fu En nanga opo mofo. ");
INSERT INTO srnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Di a son bigin saka, Yesus nanga den man fu En kmopo ini a foto. ");
INSERT INTO srnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Fruku mamanten di den e waka psa a figabon, den si tak' a bon ben drei te na a rutu srefi. ");
INSERT INTO srnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus memre san Yesus ben taigi a figabon, dan a taigi Yesus taki: “Meister, luku. A figabon san Yu ben fluku, kon drei.” ");
INSERT INTO srnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dan Yesus taigi den taki: “Un mus abi bribi na ini Gado. ");
INSERT INTO srnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Fu tru Mi e taigi un taki: Efu yu no frede tak' san yu taki no o psa, ma yu e bribi tak' a o psa soleki fa yu taki, dan yu kan taigi a bergi disi: ‘Opo, go trowe yusrefi ini a se!’ èn a o psa. ");
INSERT INTO srnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Dat'ede Mi e taigi un taki: Awinsi san un aksi na ini begi, bribi tak' yu kisi en, dan a sa de fu yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dan Yesus taigi den moro fara taki: “Efu yu abi wan sani nanga wan tra sma, yu mus gi en pardon te yu e begi. Dan so yu P'pa di de na heimel kan gi yu pardon fu yu sondu tu. ");
INSERT INTO srnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ma efu yu no e gi pardon, dan yu P'pa di de na heimel no sa gi yu pardon tu fu yu sondu.” ");
INSERT INTO srnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na so den go baka na ini Yerusalem. Di Yesus e waka na ini a mamakerki, den prenspari domri, den sabiman fu Gado wèt nanga den fesiman fu a folku, kon na En. ");
INSERT INTO srnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Den aksi En taki: “Pe Yu feni a leti fu du den sani san Yu e du? Suma gi Yu a makti fu du den sani disi?” ");
INSERT INTO srnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus piki den taki: “Mi wani aksi unu wan sani fosi. Un mus piki Mi, dan Mi sa taigi unu suma gi Mi a makti fu du den sani san Mi e du.” ");
INSERT INTO srnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Dan A aksi den taki: “Suma ben gi Yohanes a makti fu dopu sma? Gado noso libisma? Un piki Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Den man taki a tori nanga makandra. Den taki: “Efu un taki: ‘Na Gado,’ dan A o aksi unu: ‘Fu sanede un no ben bribi en dan?’ ");
INSERT INTO srnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma na a tra sei un no kan taki tak' na libisma ben gi en a makti.” Fu taki leti, den man ben frede fu den sma, bika ala sma ben si Yohanes leki wan trutru profeiti. ");
INSERT INTO srnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","So den piki Yesus taki: “Un no sabi.” Ne Yesus taigi den taki: “We, dan Mi srefi no o taigi unu pe Mi feni a leti fu du den sani disi.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dan Yesus gi den wan agersitori. A taki: “Wan man ben prani droifibon na ini en gron. A skotu en lontu, dan a mesre wan baki pe den ben kan masi den droifi te den lepi. Dan a meki wan wakti-oso san ben bow go na loktu. Baka dati a yuru a droifidyari gi tra sma, dan a go na wan tra kondre. ");
INSERT INTO srnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Di a ten doro fu piki den droifi, a seni wan knekti fu go teki den droifi san a ben mus kisi fu den man di ben yuru a droifidyari. ");
INSERT INTO srnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma den man grabu en, den fon en, dan den seni en gwe nanga soso anu. ");
INSERT INTO srnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dan a man di abi a droifidyari seni wan tra knekti go, ma den naki en na en ede, èn den teki en leki wan figifutu. ");
INSERT INTO srnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dan a man seni ete wan knekti go, ma den kiri a knekti dati. Na so den man du nanga wan lo tra knekti fu a man. Den fon sonwan fu den, trawan den kiri. ");
INSERT INTO srnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","A man di abi a droifidyari, ben abi a manpikin fu en ete, di a ben lobi. Te fu kba a seni en go na den nanga a prakseri taki: ‘Den no sa du den sani dati nanga mi manpikin.’ ");
INSERT INTO srnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma den man di ben yuru a gron taigi makandra taki: ‘Na a boi disi o kisi a gron te en p'pa dede. Kon meki un kiri en, dan unu o kisi a gron.’ ");
INSERT INTO srnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","So den grabu a boi, dan den kiri en. Baka dati den srepi en go na dorosei fu a droifidyari.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Dan Yesus aksi den sma taki: “San un e prakseri tak' a man di abi a droifidyari o du? Mi e taigi unu: A o kon kiri den man di ben yuru a droifidyari, dan a o yuru en gi tra sma. ");
INSERT INTO srnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Un srefi leisi ini a Santa Buku taki: A ston di den mesreman feni tak' no bun, na a srefi ston dati tron a moro prenspari ston fu a heri oso. ");
INSERT INTO srnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Disi na Masra wroko, èn un e ferwondru fu si dati.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Den man ben kon ferstan tak' na gi den A koti wan odo nanga a agersitori disi. Dat' meki den ben wani grabu En, ma den ben frede den sma. So den libi En, dan den gwe. ");
INSERT INTO srnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dan den seni wantu Fariseiman nanga wantu fu den man fu Herodes, go fu kisi Yesus meki A taki wan sani san no bun. ");
INSERT INTO srnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Den man go na En, dan den taigi En taki: “Meister, un sabi tak' Yu na wan man di no e kori tra sma. Yu no abi bisi nanga san sma e taki fu Yu, èn ala sma na a srefi gi Yu. Yu e leri unu a pasi fu Gado leki fa a de.” Dan den aksi Yesus taki: “A fiti fu pai edemoni na a grankownu fu den Romeinisma, efu no? Un mus pai, efu un no mus pai?” ");
INSERT INTO srnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma Yesus si tak' na wan trapu den ben wani seti gi En. Dan A aksi den taki: “Fu sanede un e pruberi fu tesi Mi? Un gi Mi wan solfrumoni meki Mi luku en.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Den gi En wan solfrumoni, dan Yesus aksi den taki: “Suma fesi nanga suma nen de na en tapu?” Den piki taki: “A di fu a grankownu.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ne Yesus taigi den taki: “Dan un gi a grankownu san na fu en, èn un gi Gado san na fu Gado.” Den man ben ferwondru fu a fasi fa Yesus piki den. ");
INSERT INTO srnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wantu Saduseiman kon na Yesus fu aksi En wan sani. Den man disi no ben e bribi tak' dedesma o kon na libi baka. Den taki: ");
INSERT INTO srnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Meister, Moses ben skrifi tak' efu wan man trow, èn a dede libi en frow sondro fu den kisi pikin, dan en brada mus trow nanga a frow fu meki pikin gi en brada di dede. ");
INSERT INTO srnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Now seibi brada ben de. A fosiwan trow, ma a dede sondro fu libi wan pikin na baka. ");
INSERT INTO srnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dan a brada di waka na en baka, trow nanga a frow. Ma en srefi dede sondro fu kisi pikin. A srefi sani miti a di fu dri brada. ");
INSERT INTO srnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na so no wan fu den seibi brada kisi pikin nanga a frow. Te fu kba, a frow srefi kon dede.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dan den aksi Yesus taki: “Te den dedesma o kon na libi baka, sortu wan fu den brada sa abi a frow disi leki en trow-uma? Bika den alamala ben trow nanga en.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus piki den taki: “Let' dya un kan si tak' un fowtu srefsrefi. Bika un no sabi san skrifi ini a Santa Buku, èn un no sabi a krakti fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Te den dedesma o kon baka na libi, den no o trow nanga makandra. Bika den o de leki den engel na heimel. ");
INSERT INTO srnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Un no leisi dan san Moses skrifi fu a tori efu dedesma o kon na libi baka? Ini a tori fu a pikin bon di ben teki faya sondro fu bron, Gado taigi en taki: ‘Mi na a Gado fu Abraham, Isak, nanga Yakob.’ Na so un e si tak' dedesma o kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gado a no Gado fu dedesma, ma fu sma di e libi. Unu e meki wan bigi fowtu.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wan fu den sabiman fu Gado wèt ben kon drape, èn a yere fa den ben e taki. A ben feni tak' Yesus piki den man bun, dan a aksi En taki: “Sortu wan fu den wèt na a moro prenspari wan fu den alamala?” ");
INSERT INTO srnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus piki taki: “A moro prenspari wan na: Sma fu Israel, un arki! Masra un Gado, na En wawan na Masra. ");
INSERT INTO srnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yu mus lobi Masra, yu Gado, nanga yu heri ati, nanga yu heri sili, nanga yu heri ferstan èn nanga ala yu krakti. ");
INSERT INTO srnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A trawan di prenspari leki a fosiwan na: Yu mus lobi tra sma soleki fa yu lobi yusrefi. No wan tra wèt no de di prenspari moro den tu disi.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dan a sabiman fu Gado wèt piki taki: “Meister, Yu abi leti. Leki fa Yu taki, na Masra wawan na Gado, èn no wan trawan no de, boiti En. ");
INSERT INTO srnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Un mus lobi En nanga un heri ati, nanga un heri ferstan, èn nanga ala un krakti. Èn un mus lobi tra sma soleki fa un lobi unsrefi. Den sani disi moro prenspari moro leki fu bron wan meti gi Gado, noso iniwan tra sani san yu ben kan offer gi Gado.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A fasi fa a man piki, Yesus si tak' na wan man nanga ferstan. Dan Yesus taigi en taki: “A no libi furu moro fu yu kon ondro a tiri fu Gado.” Baka dati no wan sma ben prefuru fu aksi En wan sani. ");
INSERT INTO srnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Di Yesus ben e gi leri ini a mamakerki, A taki: “Fa den sabiman fu Gado wèt kan taki tak' a Mesias na wan bakapikin fu kownu David? ");
INSERT INTO srnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bika a Santa Yeye ben meki David srefi taki: Masra Gado taigi mi Masra taki: Kon sidon na Mi let'anu sei te leki Mi poti den feyanti fu Yu ondro Yu futu. ");
INSERT INTO srnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","We, efu David srefi kari a Mesias en Masra, dan fa A kan de en bakapikin dan?” Bun furu sma ben lobi arki te Yesus ben e gi leri. ");
INSERT INTO srnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ini a leri san A ben gi, A taki: “Un mus luku bun nanga den sabiman fu Gado wèt. Den lobi fu weri langa krosi e koiri, èn den lobi te sma e gi den lespeki odi na wowoyo. ");
INSERT INTO srnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Den lobi fu sidon na den moro bun presi ini den kerki, èn den wani sidon na den moro prenspari presi te den go nyan na sma oso. ");
INSERT INTO srnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Den e puru den oso na a anu fu den uma di masra dede kba, dan den e begi langabere begi fu sma denki tak' den bun. Dat' meki a strafu fu den o moro hebi.” ");
INSERT INTO srnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dan Yesus go sidon abrasei fu a kisi pe yu e poti moni gi a mamakerki. A ben luku fa someni sma e poti moni ini a kisi. Wan lo gudusma ben poti furu moni. ");
INSERT INTO srnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dan wan pôti frow kon poti tu kopromoni ini a kisi. Dati na pikinso moni nomo. A masra fu a frow disi ben dede kba. ");
INSERT INTO srnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dan Yesus kari den man di ben e teki leri fu En kon. A taigi den taki: “Fu tru Mi e taigi un taki: A pôti frow disi poti moro furu moni ini a kisi moro ala den tra sma. ");
INSERT INTO srnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bika ala den tra sma poti pikinso fu a furu moni san den abi, ma a pôti frow disi poti ala fu a pikinso moni san a ben abi fu sorgu gi ensrefi.” ");
INSERT INTO srnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Di Yesus e waka kmopo na ini a mamakerki, wan fu den man fu En taigi En taki: “Meister, luku fa den ston moi èn fa den oso bigi.” ");
INSERT INTO srnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dan Yesus taigi en taki: “Yu e si ala den bigi oso disi? Den alamala o broko te na gron. No wan ston o tan na tapu wan trawan.” ");
INSERT INTO srnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Baka dati Yesus go sidon tapu a Oleifbergi, na abrasei fu a mamakerki. Petrus, Yakobus, Yohanes, nanga Andreas wawan ben de nanga En. Dan den aksi En taki: ");
INSERT INTO srnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Masra, taigi unu: Oten a sani dati o psa? San o de a marki di o sori tak' den sani dati de fu psa?” ");
INSERT INTO srnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dan Yesus bigin taigi den taki: “Un mus luku bun tak' no wan sma no kori unu! ");
INSERT INTO srnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Furu sma o du leki den na Mi. Den o taki tak' den na a Mesias, èn den o kori furu sma. ");
INSERT INTO srnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Te un sa yere tak' kondre e feti èn tak' feti de fu broko, un no mus skreki. Den sani disi mus fu psa, ma dati a no a kba ete. ");
INSERT INTO srnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bika a wan folku o feti nanga a tra folku, èn a wan kondre o feti nanga a trawan. A gron o seki hebi na difrenti presi, èn angriten o de. Ma ala den sani disi na soso a bigin fu a tranga ten di o kon. ");
INSERT INTO srnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ma un mus luku bun, bika den sa tyari un go na krutu, èn den o fon unu na ini den kerki fu den. Fu Mi ede den o srepi unu go na fesi granman nanga kownu. Dan un mus teki den okasi dati fu ferteri den fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bika fosi grontapu kba, sma fu ala folku mus yere a Bun Nyunsu. ");
INSERT INTO srnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Te den kisi unu tyari go na krutu, un no abi fu broko un ede na fesi san un mus taki. Ma un mus taki san Gado o gi un fu taki a yuru dati. Bika a no unu sa taki fu unsrefi, ma a Santa Yeye sa meki un taki.” ");
INSERT INTO srnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dan Yesus taki moro fara: “Wan brada sa gi en eigi brada abra fu den kiri en. Wan p'pa sa du a srefi sani nanga en pikin. Pikin sa tron feyanti fu den m'ma nanga den p'pa, èn den o kiri den. ");
INSERT INTO srnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Fu Mi ede no wan sma no o man si un na ai. Ma Gado sa ferlusu a sma di sa hori doro te na a kba.” ");
INSERT INTO srnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Te un si tak' a groskin-sani di e pori ala sani, de pe a no mus de, dan den sma di de ini Yudea mus lon go na den bergi. (Suma e leisi a sani disi mus suku fu ferstan en.) ");
INSERT INTO srnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","A sma di de tapu a daki fu en oso, no mus saka go ini en oso fu go teki sani. ");
INSERT INTO srnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Èn a sma di de ini en gron, no mus drai go baka fu go teki en krosi. ");
INSERT INTO srnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Den uma di de nanga bere, nanga den di abi pikin na bobi a pisten dati, o de fu sari. ");
INSERT INTO srnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Un mus begi tak' a sani disi no o psa ini a kowruten. ");
INSERT INTO srnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bika ini den dei dati, wan bigi pinaten o kon. Kmopo na a bigin di Gado ben meki ala sani, kon te leki now, noiti sowan ten ben de. Èn noiti moro sowan ten o kon baka. ");
INSERT INTO srnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Efu Gado no ben syatu a ten disi, no wan sma bo tan na libi. Ma Gado syatu a ten fu den sma fu En ede, di A ben teki gi Ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Efu wan sma sa taigi unu ini a ten dati taki: ‘Luku, a Mesias de dyaso,’ noso: ‘Luku, A de drape,’ no bribi en. ");
INSERT INTO srnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sma o kon di o du leki den na a Mesias. Trawan o du leki den na profeiti. Den o du wondru èn den o meki un si marki. Nanga dati den o suku fu kori den sma di Gado ben teki gi Ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ma un dati mus luku bun! Mi e warskow unu na fesi.” ");
INSERT INTO srnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma ini den dei baka a pinaten dati, a son o kon dungru èn a munkenki no o gi faya. ");
INSERT INTO srnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Den stari o fadon kmopo na loktu, èn ala den makti di de na loktu o seki. ");
INSERT INTO srnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dan den sma o si a Manpikin fu Libisma e kon tapu den wolku nanga bigi krakti nanga glori. ");
INSERT INTO srnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dan A o seni den engel fu En go fu tyari den sma kon na wan di A ben teki gi Ensrefi. A o teki den fu den fo uku fu grontapu pe a winti e kmopo, èn fu a moro fara presi fu grontapu go te na a moro fara uku fu heimel. ");
INSERT INTO srnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Un teki wan figabon leki eksempre. Te a bigin sproiti èn a e bigin gi nyun wiwiri, dan un sabi tak' a dreiten de fu kon. ");
INSERT INTO srnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na so un mus sabi tu tak' te un si den sani disi e bigin psa, dan a ten de krosbei, a de let' na mofodoro. ");
INSERT INTO srnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Fu tru Mi e taigi un taki: Ala den sani disi o psa te den sma fu a ten disi de na libi ete. ");
INSERT INTO srnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wan dei heimel nanga grontapu no o de moro, ma den sani san Mi taki o tan fu têgo.” ");
INSERT INTO srnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“No wan sma sabi a dei noso a yuru te a o psa. Den engel di de na heimel no sabi, èn a Manpikin srefi no sabi. Na a P'pa wawan sabi. ");
INSERT INTO srnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Fu dat'ede un mus tan na ai, fu di un no sabi oten a yuru o doro. ");
INSERT INTO srnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Un mus si a sani leki wan man di go na wan tra kondre, dan a libi en oso gi den knekti fu en. A libi wroko gi alamala, san nanga san den mus du, èn a taigi a waktiman tak' a mus hori wakti. ");
INSERT INTO srnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","So un mus de na ai. Bika un no sabi oten a man di abi a oso o drai kon baka. Un no sabi efu a o kon na neti, mindrineti, musudei noso mamanten. ");
INSERT INTO srnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Un sorgu tak' te a drai kon baka, a no kon miti unu e sribi. ");
INSERT INTO srnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","San Mi e taigi unu, Mi e taigi ala sma: Un mus de na ai!” ");
INSERT INTO srnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A ben de tu dei fosi Paska nanga a fesa pe den e nyan brede san meki sondro dyesi. Den prenspari domri nanga den sabiman fu Gado wèt ben e suku wan fasi fa den bo man kisi Yesus nanga wan triki fu den kan kiri En. ");
INSERT INTO srnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ma den taki: “Un no mus grabu En tapu den dei fu a fesa, noso a folku o meki dyugudyugu.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus ben de na Betania, na a oso fu wan man di den ben kari Gwasi Simon. Di Yesus ben e nyan, wan frow kon na En nanga wan albast batra di ben furu nanga bun diri oli san ben meki fu nardus rutu. A frow broko a neki fu a batra, dan a kanti a oli tapu Yesus ede. ");
INSERT INTO srnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma wantu sma drape ben mandi nanga a frow. Den aksi makandra taki: “Sanede a frow fermorsu a oli? ");
INSERT INTO srnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Un ben kan seri en gi moro leki dri hondro solfrumoni, èn prati a moni gi pôtisma.” So den ben e krutu a frow. ");
INSERT INTO srnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Yesus taki: “Un libi en. Sanede un e krutu en? Na wan bun sani a du gi Mi. ");
INSERT INTO srnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pôtisma de ala ten nanga unu. Oten un wani, un kan du bun gi den. Ma Mi no o de ala ten nanga unu. ");
INSERT INTO srnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A frow du san a man. A lobi oli na Mi skin na fesi fu meki Mi klari fu den beri Mi. ");
INSERT INTO srnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Fu tru Mi e taigi un taki: Ala sei fu grontapu pe sma sa ferteri a Bun Nyunsu, den sma o memre a frow fu a sani san a du gi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dan Yudas Iskariot, di ben de wan fu den twarfu man fu Yesus, go na den prenspari domri fu gi Yesus abra na ini den anu. ");
INSERT INTO srnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Di den man yere san Yudas ben wani du, den ben breiti èn den pramisi en tak' den o gi en moni. Dan a bigin luru wan bun okasi fu gi Yesus abra na den. ");
INSERT INTO srnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na a fosi dei fu a fesa pe den e nyan brede san meki sondro dyesi, den sma ben mus srakti wan pikin skapu fu nyan Paska. Dan den man fu Yesus aksi en taki: “Pe Yu wani fu wi go meki sani klari fu Yu kan nyan a Paska-nyanyan?” ");
INSERT INTO srnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dan Yesus seni tu fu den man fu En fu go du wan sani gi En. A taki: “Un go ini a foto, dan wan man di e tyari wan watra-dyogo o kon miti unu. Un waka na en baka. ");
INSERT INTO srnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","A man o go ini wan oso. Dan un mus taigi a man di abi a oso taki: ‘A Meister seni aksi pe a kamra de, pe A kan nyan Paska nanga den man fu En.’ ");
INSERT INTO srnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dan a man o sori unu wan bigi kamra na sodro, di seti èn di abi ala sani kba. Drape un mus meki a Paska-nyanyan klari gi wi.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na so den man go na a foto èn ala sani waka soleki fa Yesus taki. Dan den meki a Paska-nyanyan klari. ");
INSERT INTO srnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Di neti tapu, Yesus kon nanga den twarfu man fu En. ");
INSERT INTO srnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Di den ben e nyan, Yesus taigi den taki: “Fu tru Mi e taigi un taki: Wan fu unu di e sidon nyan dyaso nanga Mi, o seri Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Den man bigin sari, dan wan fru wan den aksi En taki: “Masra, na mi?” ");
INSERT INTO srnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus piki den taki: “Na wan fu unu, a wan di e dopu en brede ini a srefi komki nanga Mi. ");
INSERT INTO srnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bika a Manpikin fu Libisma sa dede leki fa a ben skrifi fu En kba na fesi. Ma a man di seri En mus luku bun! A bo moro bun gi en efu noiti en m'ma ben meki en.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Di den ben e nyan, Yesus teki wan brede, A blesi en, dan A broko en. Baka dati A gi den man fu En, dan A taki: “Un teki. Disi na Mi skin.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dan Yesus teki wan kan nanga win, A taki Gado tangi fu en, dan A gi den man fu En. Dan den alamala dringi. ");
INSERT INTO srnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A taigi den taki: “Disi na Mi brudu san o stampu a ferbontu di Gado meki. A o lon gi furu sma. ");
INSERT INTO srnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Fu tru Mi e taigi un taki: Mi no o dringi win moro, te leki Mi o dringi nyun win pe Gado e rigeri.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Baka di den singi fu gi Gado grani, den go na a Oleifbergi. ");
INSERT INTO srnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Di den ben de na pasi, Yesus taigi den man fu En taki: “Un alamala o gwe libi Mi. Bika a skrifi taki: ‘Mi o kiri a skapuman, dan ala den skapu o panya.’ ");
INSERT INTO srnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma te Mi kon baka na libi, Mi o go na un fesi na Galilea.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma Petrus taigi Yesus taki: “Mi no o gwe libi yu, awinsi ala den trawan gwe!” ");
INSERT INTO srnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus piki en taki: “Fu tru Mi e taigi yu taki: Tide neti, fosi kakafowru bari tu leisi, yu o taki dri leisi tak' yu no sabi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma Petrus tan hori doro taki: “Awinsi mi mus dede nanga Yu, mi no o taki tak' mi no sabi Yu.” Dan ala den tra man taki a srefi sani. ");
INSERT INTO srnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Baka dati den go na wan presi san den e kari Getsemane. Drape Yesus taigi den man fu En taki: “Un sidon dyaso. Mi o go begi.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dan A teki Petrus, Yakobus nanga Yohanes go nanga En. A no ben man hori den firi fu En moro èn A ben frede. ");
INSERT INTO srnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A taigi den dri man taki: “Mi abi sowan dipi sari tak' Mi no man tyari en. Un tan dya nanga Mi. No sribi.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dan Yesus go pikinso moro fara. A fadon tapu En kindi na gron dan A begi fu Gado no meki A nyan a pina disi, efu a kan. ");
INSERT INTO srnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A taki: “P'pa, Yu na Mi P'pa. Noti no tranga gi Yu fu du. Puru a kan disi na Mi fesi, meki Mi no nyan a pina. Ma a no san Mi wani, ma na san Yu wani musu psa.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dan A drai kon baka na den man fu En, èn A si tak' den e sribi. A aksi Petrus taki: “Simon, na sribi yu e sribi? Yu no ben man tan wan yuru na ai? ");
INSERT INTO srnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Un mus tan na ai, èn begi fu un no kon na ini tesi. Mi sabi tak' ati wani, ma skin no abi krakti.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dan Yesus go begi baka, èn A taki den srefi wortu. ");
INSERT INTO srnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Di A drai kon baka na den man fu En, den ben e sribi baka, bika sribi ben moro den. So den no ben sabi san fu piki Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesus drai kon fu a di fu dri leisi, dan A taigi den taki: “Now un kan sribi èn rostu fu unu. A nofo. A yuru doro kba. Luku, den e gi a Manpikin fu Libisma abra na ini anu fu sondusma. ");
INSERT INTO srnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Opo, kon meki un gwe. Luku, a sma di seri Mi e kon kba.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus no ben kba taki ete, di Yudas, wan fu den twarfu man fu En, doro. Den prenspari domri, den sabiman fu Gado wèt nanga den fesiman fu a folku, ben seni en kon nanga wan grupu sma di ben e tyari owru nanga tiki. ");
INSERT INTO srnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas ben meki mofo nanga den man taki: “Na a wan di mi o bosi, na En un mus grabu. Ma un mus hori ai na En tapu te un e tyari En gwe.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Di Yudas doro, a waka wantron kon na Yesus. A taki: “Meister!” Dan a bosi En. ");
INSERT INTO srnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dan den man grabu Yesus hori. ");
INSERT INTO srnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma wan fu den sma di ben tnapu drape hari en owru, dan a kapu a yesi puru fu a knekti fu a grandomri. ");
INSERT INTO srnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus taigi den man taki: “Un kon nanga tiki nanga owru fu grabu Mi, neleki Mi na wan bigi ogriman. ");
INSERT INTO srnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ala dei Mi ben de nanga unu ini a mamakerki e gi leri, ma un no grabu Mi. Ma san skrifi ini a Santa Buku mus fu psa.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dan ala den man fu Yesus lon gwe libi En. ");
INSERT INTO srnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wan yonkuman ben drape di ben waka na Yesus baka. A no ben weri krosi na en skin, boiti a sribikrosi nanga san a ben domru en skin. Den man ben suku fu grabu en. ");
INSERT INTO srnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ma a libi a sribikrosi na ini den anu, dan a lon gwe nanga sososkin. ");
INSERT INTO srnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dan so den tyari Yesus go na a grandomri. Ala den prenspari domri, den fesiman fu a folku nanga den sabiman fu Gado wèt, ben kon makandra. ");
INSERT INTO srnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus ben waka fara na baka kon te na ini a dyari fu a grandomri. Dan a go sidon mindri den waktiman fu a mamakerki sei a faya fu teki waran. ");
INSERT INTO srnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Den prenspari domri nanga ala den man fu a Grankrutu fu den Dyu, ben suku sma fu kon taki wan sani san Yesus du fu den kan kiri En. Ma den no feni noti. ");
INSERT INTO srnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bika furu sma ben kon lei gi Yesus, ma den sani san den ben taki no ben de a srefi. ");
INSERT INTO srnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dan wantu sma kon lei gi Yesus. Den taki: “Un yere di A taki: ");
INSERT INTO srnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‘Mi o broko a Santa Presi disi san libisma meki, dan ini dri dei Mi o meki wan trawan san libisma no meki.’ ” ");
INSERT INTO srnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma srefi ini a sani disi san den taki, den no ben agri. ");
INSERT INTO srnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ne a grandomri opo tnapu mindri den tra man, dan a aksi Yesus taki: “Yu no e piki tapu san den man disi e taki fu Yu?” ");
INSERT INTO srnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma Yesus hori En mofo, A no piki. Dan a grandomri aksi En taki: “Na Yu na a Mesias? Na Yu na a Manpikin fu a Blesi Wan?” ");
INSERT INTO srnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dan Yesus piki taki: “Iya, na Mi na en. Èn un o si a Manpikin fu Libisma sidon na a let'anu sei fu Gado di abi Makti. Dan un o si En te A e kon baka tapu den wolku.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Di Yesus taki a sani dati, a grandomri priti en krosi, dan a taki: “Un no abi kotoigi fanowdu moro! ");
INSERT INTO srnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Un srefi yere fa A afrontu Gado. San na un besroiti?” Den alamala feni taki a fiti fu A dede. ");
INSERT INTO srnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dan wantu fu den man bigin spiti na En tapu. Den tapu En fesi, dan den naki En kofu. Den taigi En taki: “Sori un tak' Yu na wan profeiti.” Den waktiman fu a mamakerki naki En tu ini En fesi. ");
INSERT INTO srnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Di Petrus ben de na ondrosei na ini a dyari, wan frow di e wroko gi a grandomri kon. ");
INSERT INTO srnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Di a si Petrus e teki waran sei a faya, a luku en, dan a taigi en taki: “Yu ben de nanga Yesus fu Nasaret tu.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma Petrus lei taki: “Mi no sabi noti èn mi no e ferstan noti fu san yu e taki.” Dan a kmopo fu drape go na fes'sei pe a poort de. ");
INSERT INTO srnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Di a frow si en baka, a bigin taigi den sma drape taki: “A man disi na wan fu den man fu Yesus.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma Petrus lei baka. Baka wan syatu pisten den sma di ben tnapu drape taigi Petrus agen taki: “A tru. Yu na wan fu den, bika yu na fu Galilea.” ");
INSERT INTO srnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dan Petrus bigin fluku ensrefi, èn a sweri taki: “Mi no sabi a man san un e taki!” ");
INSERT INTO srnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A srefi momenti dati a kakafowru bari fu a di fu tu tron. Dan Petrus memre di Yesus ben taigi en taki: “Fosi kakafowru bari tu leisi, yu o taki dri leisi tak' yu no sabi Mi.” Dan Petrus bigin krei. ");
INSERT INTO srnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Fruku mamanten den prenspari domri, den fesiman fu a folku, den sabiman fu Gado wèt nanga den man fu a Grankrutu fu den Dyu, kon makandra fu taki san den o du. Dan den tai Yesus tyari go gi Pilatus. ");
INSERT INTO srnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus aksi En taki: “Na Yu na a Kownu fu den Dyu?” Yesus piki en taki: “Na leki fa yu taki.” ");
INSERT INTO srnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Den prenspari domri ben gi wan lo kragi fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dan Pilatus aksi Yesus taki: “Yu no e piki tapu san den man disi e taki fu Yu? Arki omeni kragi den e gi fu Yu.” ");
INSERT INTO srnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Yesus no piki moro fara, so Pilatus ben ferwondru. ");
INSERT INTO srnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ala yari tapu a Paskafesa, Pilatus ben gwenti fu lusu wan straf'man di den sma ben wani tak' a mus lusu. ");
INSERT INTO srnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Now wan man Barabas ben sroto makandra nanga den man di ben meki dyugudyugu, èn di ben kiri wan sma ini a dyugudyugu. ");
INSERT INTO srnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Den sma kon na fesi dan den bigin aksi Pilatus fu a lusu wan straf'man soleki fa a ben gwenti. ");
INSERT INTO srnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dan Pilatus aksi den taki: “Un wani fu mi lusu a Kownu fu den Dyu gi unu?” ");
INSERT INTO srnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A aksi den so, bika a kon si tak' den prenspari domri ben tyari Yesus kon gi en fu di den ben dyarusu na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma den prenspari domri sutu faya gi a bigi grupu sma fu den taigi Pilatus tak' a mus lusu Barabas na ini Yesus presi. ");
INSERT INTO srnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus aksi den sma baka taki: “Dan san mi mus du nanga a man di un e kari Kownu fu den Dyu?” ");
INSERT INTO srnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne den sma bari taki: “Spikri En na wan kroisi!” ");
INSERT INTO srnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus aksi den taki: “Ma sortu ogri a man disi du?” Ma den sma bigin bari moro tranga taki: “Spikri En na wan kroisi!” ");
INSERT INTO srnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dan fu di Pilatus ben wani du den sma wan prisiri, a lusu Barabas, dan a meki den wipi Yesus èn tyari En go spikri na wan kroisi. ");
INSERT INTO srnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Den srudati tyari Yesus go ini a krutu-oso, san den ben kari a Pretorium, dan den kari den tra srudati kon. ");
INSERT INTO srnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Den weri wan lila krosi gi En, dan den brei wan banti fu makataki poti tapu En ede. ");
INSERT INTO srnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dan den bigin gi En odi. Den taki: “Odi, Kownu fu den Dyu!” ");
INSERT INTO srnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Baka dati den bigin naki En nanga wan tiki tapu En ede. Den spiti na En tapu, dan den go na tapu den kindi fu gi En grani. ");
INSERT INTO srnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Di den kba meki spotu nanga En, den puru a lila krosi san den ben weri gi En, dan den weri En eigi krosi gi En baka. Dan den tyari En gwe fu go spikri na wan kroisi. ");
INSERT INTO srnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wan man ben kmopo na boiti e kon, dan den dwengi en fu tyari a kroisi fu Yesus. A man disi ben nen Simon, èn a ben de fu a foto Sirena. A ben de a p'pa fu Aleksander nanga Rufus. ");
INSERT INTO srnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dan den tyari Yesus go na a presi san den e kari Golgota. Golgota wani taki: Dede-ede Presi. ");
INSERT INTO srnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Den gi En win moksi nanga mirre fu A dringi, ma A no dringi en. ");
INSERT INTO srnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dan den spikri En na a kroisi. Baka dati den prati En krosi, ma den ben hari a lot fosi fu luku suma o teki sortu pisi fu a krosi. ");
INSERT INTO srnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A ben de neigi yuru mamanten di den spikri En na a kroisi. ");
INSERT INTO srnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Den ben skrifi fu sanede den spikri En. Den skrifi: “A Kownu fu den Dyu.” ");
INSERT INTO srnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Makandra nanga En den spikri tu fufuruman: wan na En let'anu sei, èn a trawan na En kruktu-anu sei. ");
INSERT INTO srnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na so san skrifi ini a Santa Buku kon tru. A skrifi taki: Den si en leki wan abani. ");
INSERT INTO srnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Den sma di ben e waka psa afrontu Yesus. Den seki den ede èn den taki: “Ai, a no Yu bo broko a Santa Presi dan Yu meki en baka ini dri dei? ");
INSERT INTO srnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","We, yepi Yusrefi! Saka kmopo fu a kroisi dan!” ");
INSERT INTO srnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Den prenspari domri makandra nanga den sabiman fu Gado wèt ben meki spotu nanga Yesus tu. Den taki: “A ben yepi trawan, ma A no man yepi Ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Efu Yu na a Mesias, a Kownu fu Israel, saka kmopo fu a kroisi now, meki un si. Dan wi sa bribi.” Den man di ben spikri makandra nanga En, ben kosi En tu. ");
INSERT INTO srnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Di twarfu yuru doro, a heri kondre kon dungru te leki dri yuru bakadina. ");
INSERT INTO srnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dan a yuru dati Yesus bari taki: “Elohi, Elohi, lama sabaktani?” Dati wani taki: Mi Gado, Mi Gado, fu sanede Yu gwe libi Mi? ");
INSERT INTO srnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Di wantu sma di ben tnapu drape yere a sani disi, den taki: “Arki! A e kari Elia.” ");
INSERT INTO srnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dan wan fu den lon go teki wan sponsu. A nati en nanga swa win, a fasi en na wan tiki, dan a langa en gi Yesus fu A dringi. A taki: “Wakti, meki un luku efu Elia o kon puru En na a kroisi.” ");
INSERT INTO srnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma Yesus bari nanga tranga sten, dan En bro koti. ");
INSERT INTO srnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dan a garden ini a Santa Presi priti langalanga na mindri fu loktu kon te na gron. ");
INSERT INTO srnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Di a kapten fu den srudati di ben tnapu e luku Yesus, si fa En bro koti, a taki: “Trutru, a Man disi ben de a Manpikin fu Gado!” ");
INSERT INTO srnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wantu frow ben tnapu fu fara e luku. Wantu fu den frow dati ben de: Salome, Maria fu a foto Magdala, nanga Maria a m'ma fu Yoses nanga Yakobus a yonguwan. ");
INSERT INTO srnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Di Yesus ben de na ini Galilea, den frow disi ben e waka na En baka, èn den ben e yepi En. Wan lo tra umasma ben drape tu di ben kon nanga En na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A ben de a dei fosi a sabadei èn neti ben de fu tapu. Tapu a dei dati den sma ben e meki ala sani klari gi a sabadei. ");
INSERT INTO srnNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Dan Yosef fu a foto Arimatea teki dek'ati go na Pilatus fu aksi en a dedeskin fu Yesus. A man disi ben de wan prenspari man fu a Grankrutu fu den Dyu èn a ben angri tu fu Gado kon tiri libisma. ");
INSERT INTO srnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus ben ferwondru tak' Yesus ben dede kba. A seni kari a kapten fu den srudati, dan a aksi en efu Yesus dede kba. ");
INSERT INTO srnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Di a kapten taigi en tak' A dede, Pilatus gi Yosef a dedeskin. ");
INSERT INTO srnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosef bai wan linnen krosi, a puru a skin fu Yesus na a kroisi, dan a domru en na ini. Baka dati a poti Yesus na ini wan grebi san den ben diki ini a bergiskin. Dan a lolo wan bigi ston na a mofo fu a grebi fu tapu en. ");
INSERT INTO srnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria fu Magdala nanga Maria, a m'ma fu Yoses, si pe Yosef poti a skin fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Baka a sabadei, Salome, Maria fu Magdala, nanga Maria a m'ma fu Yakobus, bai den sani di de fanowdu fu go sreka a dedeskin fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dan fruku mamanten tapu a fosi dei fu a wiki, di a son opo, den go na a grebi. ");
INSERT INTO srnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Den ben aksi makandra taki: “Suma sa lolo a ston puru fesi a grebi-olo gi unu?” ");
INSERT INTO srnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","A ston ben de wan bigi ston. Dan di den luku go na a grebi, den si tak' a ston lolo kmopo. ");
INSERT INTO srnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Di den go ini a olo, den si wan yongu man di ben weri weti krosi, sidon na a let'anu sei. Den skreki tak' den no ben sabi san fu taki. ");
INSERT INTO srnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dan a man taigi den taki: “Un no mus ferwondru. Na Yesus fu Nasaret di den ben spikri na a kroisi un e suku. A no dya, A kon baka na libi. Luku pe den ben poti en didon. ");
INSERT INTO srnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Un go na den man fu En, dan un taigi den nanga Petrus taki: Yesus go na un fesi na Galilea. Drape un sa si En, soleki fa A ben taigi unu.” ");
INSERT INTO srnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Den frow kmopo ini a grebi-olo, dan den lon gwe. Bika den ben beifi èn den ben ferwondru. Den no taigi no wan sma no wan sani, bika den ben frede. ");
INSERT INTO srnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Fruku mamanten fu a fosi dei fu a wiki, di Yesus kon baka na libi, A sori Ensrefi fosi na Maria fu Magdala. Yesus ben puru seibi takruyeye na tapu a frow disi. ");
INSERT INTO srnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dan Maria go taigi den man di ben waka nanga Yesus ala ten. Den man disi ben e sari èn den ben e krei. ");
INSERT INTO srnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma di Maria taigi den tak' Yesus e libi, èn tak' a si En, den no ben wani bribi. ");
INSERT INTO srnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Baka dati Yesus sori Ensrefi wan tra fasi na tu fu den man fu En di ben de na pasi e go na wan dorpu. ");
INSERT INTO srnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dan den man drai go baka go taigi den trawan, ma den trawan no ben bribi den man disi tu. ");
INSERT INTO srnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Te fu kba Yesus sori Ensrefi na den erfu man fu En di den ben sidon e nyan. Dan Yesus bigin puru wiwiri gi den tak' den no e bribi, èn tak' den trangayesi. Bika den no ben wani bribi den sma di si En baka di A kon baka na libi. ");
INSERT INTO srnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dan Yesus taigi den taki: “Un go na ala sei fu grontapu, èn ferteri ala sma a Bun Nyunsu. ");
INSERT INTO srnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","A sma di bribi èn teki dopu, sa kisi a libi fu têgo. Ma den sma di no wani bribi, o kisi strafu. ");
INSERT INTO srnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Fu sori tak' A de nanga den, Gado o gi den sma di e bribi makti fu du den marki disi: den o puru takruyeye tapu sma na ini Mi nen, èn den o taki na ini nyun tongo. ");
INSERT INTO srnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Den o hori sneki nanga den anu, èn awinsi den dringi wan sani san kan kiri den, noti no o psa nanga den. Den o poti anu tapu sikisma, dan den o kon betre.” ");
INSERT INTO srnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Baka di Masra Yesus kba taki nanga den, Gado teki En go na heimel. Drape A go sidon na Gado let'anu sei. ");
INSERT INTO srnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dan den man go ala sei go panya a Bun Nyunsu. Masra ben yepi den. A ben gi den makti fu du marki fu sori tak' san den e taki na tru.");
INSERT INTO srnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Masra Teofilus, Furu sma ben pruberi kba fu skrifi den sani san ben psa na un mindri, ");
INSERT INTO srnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","soleki fa den sma di ben si ala den sani sensi na a bigin èn di ben panya a boskopu, ben ferteri wi. ");
INSERT INTO srnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ma baka di misrefi go ondrosuku fin'fini fa ala sani ben waka sensi na a bigin, mi prakseri tak' a bo bun fu skrifi den sani soleki fa den ben psa, poti ini wan buku gi yu. ");
INSERT INTO srnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mi e du disi fu yu kon si tak' den sani san den ben leri yu, na tru. ");
INSERT INTO srnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ini den dei di Herodes ben de kownu fu Yudea, wan Dyudomri ben de di ben nen Sakarias. A ben de fu a grupu fu Abia. En frow Elisabet ben de wan bakapikin fu Aaron. ");
INSERT INTO srnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Den tu sma disi ben bun ini Gado ai, èn den ben hori densrefi na ala den komanderi fu Gado èn na san A ben wani tak' sma mus du. No wan sma ben man taki takru fu den. ");
INSERT INTO srnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma den no ben abi no wan pikin, bika Elisabet no ben man kisi pikin, èn den ala tu ben kon owru kba. ");
INSERT INTO srnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Now a ben de a ten tak' Sakarias ben mus du en wroko leki domri gi Gado, fu di a grupu fu en ben mus du a wroko a pisten dati. ");
INSERT INTO srnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Dan soleki fa a gwenti fu den domri ben de, den ben hari lot fu luku suma ben mus go na ini a Santa Presi fu Masra fu go bron switismeri. Di den hari a lot, a sori tak' na Sakarias ben mus go. ");
INSERT INTO srnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A yuru di a switismeri ben e bron, ala den sma ben de na prasi e begi. ");
INSERT INTO srnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dan wan engel fu Masra sori ensrefi na Sakarias. A engel ben tnapu na a let'sei fu a altari pe a switismeri ben e bron. ");
INSERT INTO srnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Di Sakarias si a engel, a skreki èn a kon frede. ");
INSERT INTO srnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma a engel taigi en taki: “Sakarias, no frede. Gado yere yu begi. Yu frow Elisabet o kisi wan manpikin èn yu mus kari en Yohanes. ");
INSERT INTO srnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yu o breiti èn prisiri nanga en, èn furu sma o prisiri tak' a kon gebore. ");
INSERT INTO srnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bika a o de wan prenspari man fu Masra. A no mus dringi win noso sopi. Na ini en mamabere srefi a o furu nanga a Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A o meki furu sma fu Israel drai kon baka na Masra den Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A o waka na Masra fesi tapu a srefi fasi èn nanga a srefi krakti fu Elia. A o meki tak' pratifasi no de moro na mindri pikin nanga den bigisma fu den. A o meki sma di tranga yesi, bigin libi leki den sma di bun ini Gado ai. Na so a o meki a folku klari gi Masra.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dan Sakarias aksi a engel taki: “Fa mi o sabi tak' a sani disi o psa? Bika mi owru kba, èn mi frow de tapu yari.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dan a engel piki en taki: “Mi na Gabriyel, a wan di e tnapu krosbei fu Gado. Na En seni mi kon na yu fu ferteri yu a bun nyunsu disi. ");
INSERT INTO srnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","We luku, den sani san mi taigi yu, o psa na a ten di Gado poti. Ma fu di yu no bribi san mi taigi yu, yu o babaw. Yu no o man taki te leki a dei tak' den sani disi psa.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A pisten dati den sma ben de na prasi e wakti Sakarias. Den ben ferwondru tak' Sakarias tan so langa ini a Santa Presi. ");
INSERT INTO srnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Di Sakarias kon na dorosei, a no ben man taki nanga den. So den sma kon ferstan tak' Gado ben sori en wan sani ini a Santa Presi. A meki wantu beweigi nanga en anu èn a tan babaw. ");
INSERT INTO srnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Di a ten kon kba san a ben mus du en wroko, a drai go baka na en oso. ");
INSERT INTO srnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Baka den dei dati en frow Elisabet hori bere. Feifi mun langa a no ben kmopo na ini en oso fu sma si en. ");
INSERT INTO srnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet taki: “Disi na san Gado du gi mi ini a ten di A sari mi. A puru a syen na mi tapu san mi ben abi mindri den sma.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Di Elisabet ben abi siksi mun bere, Gado seni a engel Gabriyel go na a foto Nasaret ini a distrikti Galilea. ");
INSERT INTO srnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A ben mus go na wan yongu uma di noiti no ben sribi nanga wan man ete. Soleki fa a pramisi ben de, dan Yosef bo trow nanga en. Yosef ben de wan bakapikin fu kownu David, èn a yongu uma ben nen Maria. ");
INSERT INTO srnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Di Gabriyel go ini a oso fu Maria, a taki en odi. Dan a taigi en taki: “Masra de nanga yu, èn a blesi fu Masra de na yu tapu.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Di Maria yere san a engel taki, a skreki tak' a bruya. A aksi ensrefi san a odi disi wani taki. ");
INSERT INTO srnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dan a engel taki: “Maria, no frede. Bika Gado sori yu En bun-ati. ");
INSERT INTO srnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Luku. Yu o hori bere, dan yu o kisi wan manpikin. Yu mus kari en Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A o de wan prenspari man, èn den o kari En a Manpikin fu a Moro Hei Gado. Masra Gado o meki A tron kownu na a presi fu En afo David. ");
INSERT INTO srnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A sa de a kownu fu a folku Israel fu têgo, èn noiti a tiri fu En o kba.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dan Maria taigi a engel taki: “Fa dati kan? Bika noiti ete mi sribi nanga wan man.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dan a engel piki en taki: “A Santa Yeye o kon na yu tapu, èn a krakti fu a Moro Hei Gado o saka kon tapu yu. Dat'ede den sa kari a santa pikin di o gebore a Manpikin fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Luku, Elisabet a famiri fu yu, owru kba. Ma en srefi de nanga bere fu kisi wan manpikin. Den ben taki a no man kisi pikin, ma na siksi mun kba di a abi bere. ");
INSERT INTO srnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bika noti no de san Gado no kan du.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dan Maria taki: “We, mi de na Masra anu. Meki ala sani psa nanga mi soleki fa yu taki.” Dan a engel gwe. ");
INSERT INTO srnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Baka dati Maria teki pasi go es'esi na wan foto san de ini den bergi fu a distrikti Yudea. ");
INSERT INTO srnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A go na Sakarias oso, dan a gi Elisabet odi. ");
INSERT INTO srnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Di Elisabet yere a odi fu Maria, a pikin dyompo ini en bere. Ne Elisabet kon furu nanga a Santa Yeye, ");
INSERT INTO srnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","dan a taki nanga tranga sten taki: “Fu ala den uma di de, Masra blesi yu moro wan fu den, èn a blesi fu Masra de tapu a pikin ini yu bere. ");
INSERT INTO srnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma fa mi du feni a bun disi, tak' a m'ma fu a Mesias kon luku mi? ");
INSERT INTO srnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bika luku, di mi yere a odi fu yu, a pikin dyompo fu prisiri ini mi bere. ");
INSERT INTO srnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A blesi fu Gado de na yu tapu fu di yu bribi tak' a sani san Masra taigi yu, o psa.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dan Maria taki: Nanga mi heri ati mi e opo a nen fu Masra, ");
INSERT INTO srnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","èn nanga ala sani san de na ini mi, mi e prisiri nanga Gado, mi Ferlusuman. ");
INSERT INTO srnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bika A prakseri mi, aladi mi na a moro lagi knekti fu En. Luku, bigin fu now ala sma o taki tak' blesi de na mi tapu. ");
INSERT INTO srnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bika Gado di abi Makti, du bigi sani gi mi èn a nen fu En santa. ");
INSERT INTO srnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A e sori sari-ati na ala den sma di e lespeki En, den sma di e libi nownow nanga den di o libi bakaten. ");
INSERT INTO srnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nanga a makti fu En, A du bigi wroko. A tyari bruya kon ini den prakseri fu den sma di abi bigimemre. ");
INSERT INTO srnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A meki den bigiman fu kondre lasi den makti, èn A opo den sma di trawan no e teri. ");
INSERT INTO srnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Den sma nanga angribere A gi nofo fu nyan, ma den guduman A seni gwe nanga soso anu. ");
INSERT INTO srnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Soleki fa A pramisi den bigisma fu unu A langa wan anu gi Israel, a folku di e dini En. Bika A memre tak' fu têgo A bo sori sari-ati na Abraham nanga den bakapikin fu en. ");
INSERT INTO srnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ben tan dri mun so na Elisabet, dan a drai go baka na en oso. ");
INSERT INTO srnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Di a yuru doro fu Elisabet meki a pikin, a kisi wan boi. ");
INSERT INTO srnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Den birtisma nanga den famiri fu en, ben yere fa Masra ben sori bigi sari-ati na Elisabet. So den ben prisiri nanga en. ");
INSERT INTO srnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Di a boi tapu aiti dei, den sma kon fu besnei a boi. Dan den ben wani gi a boi a nen fu en p'pa Sakarias. ");
INSERT INTO srnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma en m'ma taki: “Nono. Un mus kari en Yohanes.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma den taigi Elisabet taki: “No wan sma no de ini yu famiri di abi a nen dati.” ");
INSERT INTO srnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dan den sma meki wantu beweigi nanga den anu fu aksi Sakarias fa a wani tak' a pikin mus nen. ");
INSERT INTO srnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ne Sakarias aksi den sma wan sani fu skrifi na tapu. A skrifi taki: “A mus nen Yohanes.” Ala den sma ben ferwondru. ");
INSERT INTO srnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dan wantron so Sakarias ben man taki baka èn a bigin fu opo Gado nen. ");
INSERT INTO srnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ala den sma di ben libi ini a birti fu den, ben kisi bigi lespeki gi Gado. Èn ini a heri bergi presi fu Yudea den sma ben taki fu den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ala sma di yere ben teki den sani disi na prakseri. Den ben aksi densrefi taki: “San a pikin disi o tron?” Bika a ben de krin fu si tak' a krakti fu Gado ben de na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakarias kon furu nanga a Santa Yeye, dan a bigin taki san Gado gi en fu taki. A taki: ");
INSERT INTO srnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Mi e opo a nen fu Masra, a Gado fu Israel. Bika A langa wan anu gi En folku èn A ferlusu den. ");
INSERT INTO srnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A gi unu wan tranga Ferlusuman, di de wan bakapikin fu En knekti David, ");
INSERT INTO srnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","fu ferlusu unu puru ini a makti fu un feyanti nanga den sma di no lobi unu srefsrefi. Langaten na fesi A ben meki den santa profeiti fu En taki a sani disi kba. ");
INSERT INTO srnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Na so A sori sari-ati na den afo fu unu. A hori ensrefi na a santa ferbontu fu En. ");
INSERT INTO srnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bika A ben meki wan sweri nanga un afo Abraham ");
INSERT INTO srnNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tak' A bo ferlusu unu puru ini a makti fu un feyanti, fu un kan dini En sondro frede. ");
INSERT INTO srnNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Un o man dini En un heri libi langa tapu wan santa fasi, èn tapu wan fasi di bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Èn yu, mi pikin, den sa kari yu wan profeiti fu a Moro Hei Gado, bika yu sa waka na Masra fesi fu meki pasi klari gi En, ");
INSERT INTO srnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","fu meki en folku sabi tak' Gado o ferlusu den te A gi den pardon fu den sondu. ");
INSERT INTO srnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bika fu di Gado abi bigi sari-ati gi unu, dat' meki a Wan di o kmopo na heimel o kon na unu fu yepi unu. A o kon leki a son di e opo ");
INSERT INTO srnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","fu tyari leti kon gi den sma di de na dungru, di de na pasi fu go dede. Èn A o sori unu a pasi fu freide. ");
INSERT INTO srnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A boi ben e gro, èn moro nanga moro a Yeye ben gi en krakti. A ben e tan na ini a dreisabana te leki a dei di a sori ensrefi na den sma fu Israel. ");
INSERT INTO srnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ini a srefi ten dati grankownu Augustus ben seni wan boskopu go lontu ini ala den kondre di a ben e tiri, tak' ala sma mus go skrifi den nen na ini lantibuku. ");
INSERT INTO srnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Disi ben de a fosi leisi di den ben meki den sma skrifi den nen na ini lantibuku èn a psa ini a ten di Kwirinius ben de granman fu Siriakondre. ");
INSERT INTO srnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","So ala sma ben go skrifi den nen na ini a foto pe a famiri fu den ben kmopo. ");
INSERT INTO srnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Dan fu di Yosef ben de wan bakapikin fu David, a kmopo fu Nasaret na ini Galilea fu go na Betlehem na ini Yudea, bika na drape David ben gebore. ");
INSERT INTO srnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A go drape fu skrifi en nen nanga a di fu Maria, a frow nanga san a bo trow. A pisten dati Maria ben abi bere. ");
INSERT INTO srnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Di den ben drape, a yuru doro fu Maria kisi a pikin. ");
INSERT INTO srnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Dan a kisi en fosi boi. A domru En na ini krosi, dan a poti En didon ini wan baki pe meti e nyan, bika a oso pe yu ben kan yuru wan presi fu tan, ben furu kba. ");
INSERT INTO srnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ini a srefi kontren dati wantu skapuman ben de ini den wei e hori wakti te neti gi den skapu fu den. ");
INSERT INTO srnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dan wantron so wan engel fu Masra ben tnapu na den fesi, èn a glori fu Masra ben krin a heri presi pe den ben de. Den man ben frede srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma a engel taigi den taki: “No frede! Bika mi tyari wan bun nyunsu gi unu san o meki a heri folku prisiri. ");
INSERT INTO srnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tide a Ferlusuman gebore gi unu na ini a foto fu David. Na En na a Mesias, na En na Masra. ");
INSERT INTO srnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Disi na a marki: Te un go, un o si wan pikin di domru na ini krosi, èn a didon ini wan baki pe meti e nyan.” ");
INSERT INTO srnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dan wantron so wan heri ipi tra engel ben tnapu pe a fosi engel ben de. Den ben e prijse Gado taki: ");
INSERT INTO srnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Glori gi Gado di de na heimel, èn freide gi den sma na grontapu di Gado lobi.” ");
INSERT INTO srnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Di den engel gwe baka na heimel, den skapuman taigi makandra taki: “Kon meki un go na Betlehem fu go luku a sani san Masra seni taigi unu.” ");
INSERT INTO srnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Den man gwe es'esi, dan den feni Maria nanga Yosef, nanga a pikin di ben didon na ini a baki. ");
INSERT INTO srnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Di den si a pikin den ferteri ala sani san a engel ben taigi den fu a pikin. ");
INSERT INTO srnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ala sma di yere a tori ben ferwondru fu a sani san den skapuman taki. ");
INSERT INTO srnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria no fergiti den sani san den taki, ma a tan memre den. ");
INSERT INTO srnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Di den man e drai gwe baka, den ben e prijse Gado e gi En glori fu ala sani san den ben si nanga san den ben yere. Ala sani ben psa soleki fa a engel ben taigi den. ");
INSERT INTO srnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Di a pikin tapu aiti dei, den ben mus besnei En. Dan den gi En a nen Yesus. Bika fosi A ben de ini en mamabere, a engel ben taki tak' na so den mus kari En. ");
INSERT INTO srnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","A ten ben doro tak' den ben mus krin densrefi gi Gado soleki fa a wèt fu Moses e taki. Dan Yosef nanga Maria tyari Yesus go na Yerusalem fu poti En na ini Masra anu. ");
INSERT INTO srnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bika a skrifi na ini a wèt fu Masra taki: “Ala fosi manpikin un sa poti aparti gi Masra.” ");
INSERT INTO srnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A wèt fu Masra e taki moro fara tak' den ben mus tyari tu paskadoifi noso tu yongu doifi leki wan offer gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Now yu ben abi na ini Yerusalem wan man di ben nen Simeon. A man disi ben bun ini Gado ai. A ben hori ensrefi trutru na a Dyubribi, èn a Santa Yeye ben de na en tapu. A ben angri fu si a dei di Gado bo ferlusu Israel. ");
INSERT INTO srnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A Santa Yeye ben sori Simeon tak' a no bo dede solanga a no ben si a Mesias di Masra bo seni kon. ");
INSERT INTO srnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dan so a Santa Yeye ben meki Simeon go na ini a mamakerki fu den Dyu. Di Yosef nanga Maria tyari Yesus go drape fu du nanga En soleki fa a wèt e taki, ");
INSERT INTO srnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","dan Simeon teki a pikin tapu en anu èn a opo Gado nen. A taki: ");
INSERT INTO srnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Masra, now Yu kan meki Yu knekti dede ini freide leki fa Yu ben taki. ");
INSERT INTO srnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bika mi si a Ferlusuman ");
INSERT INTO srnNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","di Yu bo seni kon gi ala folku. ");
INSERT INTO srnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Neleki wan faya A o sori den sma di no sabi Yu, a pasi fu Yu, èn A o meki Yu pipel Israel kisi glori. ");
INSERT INTO srnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yosef nanga Maria ben ferwondru fu yere den sani san Simeon taki fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dan Simeon blesi den. A taigi Maria, a m'ma fu a pikin taki: “Luku, a pikin disi na wan marki di furu sma ini Israel o poti na wan sei. Na dati o broko den neki. Ma gi furu trawan A o tyari nyun libi kon. ");
INSERT INTO srnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na sowan fasi a sani san de ini den sma ati o kon na krin. Ma yu o abi dipi sari na ini yu ati.” ");
INSERT INTO srnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wan owru frow ben de ini a mamakerki tu. A ben nen Hana èn a ben de wan profeiti fu Gado. A p'pa fu en ben nen Fanuel èn a ben de fu a lo fu Aser. A frow disi no ben abi masra, bika seibi yari baka di a trow, en masra dede. ");
INSERT INTO srnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A ben abi aititenti-na-fo (84) yari, èn a ben tan ini a mamakerki e dini Gado dei nanga neti nanga faste èn begi. ");
INSERT INTO srnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A srefi ten di Simeon ben e taki nanga Yosef nanga Maria, Hana kon tnapu drape. Dan a bigin opo Gado nen owktu èn ala sma di ben ferwakti tak' Gado bo ferlusu Yerusalem, a ferteri fu a pikin disi. ");
INSERT INTO srnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Di Maria nanga Yosef du ala sani san den ben mus du, soleki fa a wèt fu Masra e taki, den drai go baka na Nasaret na ini Galilea, pe den ben e libi. ");
INSERT INTO srnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A pikin ben e gro èn A ben kon tranga. A ben kon koni moro nanga moro èn Gado ben sori En bun-ati. ");
INSERT INTO srnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ala yari a m'ma nanga a p'pa fu Yesus ben e go na Yerusalem fu nyan a Paskafesa. ");
INSERT INTO srnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Di Yesus tapu twarfu yari den go na a fesa soleki fa den ben gwenti. ");
INSERT INTO srnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baka di a fesa kba, den teki pasi fu drai go baka na oso. Yesus tan na baka ini Yerusalem. Ma En m'ma nanga En p'pa no ben sabi. ");
INSERT INTO srnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Fu di den ben prakseri tak' A ben de mindri den tra sma di ben e drai go baka na oso tu, den waka wan heri dei fosi den bigin aksi famiri nanga mati efu den ben si Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Di den no ben man feni En, den drai go baka na Yerusalem fu suku En. ");
INSERT INTO srnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dan tapu a di fu dri dei, den feni En na ini a mamakerki. Drape A ben e sidon na mindri den man di e gi leri. A ben e arki san den ben taki èn A ben e aksi den wantu sani. ");
INSERT INTO srnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ala sma di ben yere En, ben ferwondru fu a ferstan san A ben abi, nanga a fasi fa A ben piki den man. ");
INSERT INTO srnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Di Maria nanga Yosef si En, den no ben sabi san fu taki. Dan Maria taki: “Boi, fa Yu kan du a sani disi nanga unu? Luku fa mi nanga Yu p'pa ben e waka suku Yu, bika un ati ben de na dyompo.” ");
INSERT INTO srnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dan A piki den taki: “Fu sanede ben e un suku Mi? Na sabi un no sabi dan tak' Mi mus de na ini a oso fu Mi P'pa?” ");
INSERT INTO srnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma den no ben ferstan a piki san A ben piki den. ");
INSERT INTO srnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dan Yesus drai go baka na Nasaret nanga den, èn A ben du san den ben e taigi En. Ma Maria no fergiti no wan fu den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","So Yesus ben kon moro bigi èn A ben kon moro koni. Gado ben lobi En, èn den sma ben lobi En tu. ");
INSERT INTO srnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","A ben de tin-na-feifi yari kba tak' Tiberius ben de grankownu. A ten dati Pontius Pilatus ben de granman fu a distrikti Yudea. Herodes ben e tiri a distrikti Galilea. Filipus, a brada fu Herodes, ben e tiri Iturea nanga Trakonitus. Èn Lisanias ben e tiri Abilena. ");
INSERT INTO srnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kayafas nanga Anas ben de grandomri fu a Dyukerki. Ini a srefi yari dati Gado ben gi Yohanes, a manpikin fu Sakarias, wan boskopu di a ben de ini a dreisabana. ");
INSERT INTO srnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","So Yohanes ben waka ini a heri birti fu a Yordanliba e bari a boskopu tak' den sma mus drai den libi èn teki dopu. Na sowan fasi Gado bo gi den pardon fu den sondu. ");
INSERT INTO srnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ini a buku fu a profeiti Yesaya, a skrifi taki: Wan sma e bari wroko ini a dreisabana taki: Meki pasi klari gi Masra, puru ala boktuboktu gi En. ");
INSERT INTO srnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tapu ala den dipi olo, èn puru den bergi na pasi: pikinwan nanga bigiwan. No wan kronkron pasi mus de, èn den olo-olo pasi mus kon grati. ");
INSERT INTO srnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dan so ala sma sa si a Ferlusuman di Gado o seni kon. ");
INSERT INTO srnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dan Yohanes taigi a bigi ipi sma di ben kon na en fu teki dopu taki: “Un sneki unu! Suma gi un wan pingi fu lon gi a strafu fu Gado di de fu kon? ");
INSERT INTO srnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Efu trutru un drai un libi, meki a de fu si dan. No bigin fu taki na ini yu ati taki: ‘Wi na bakapikin fu Abraham.’ Bika mi e taigi un taki: Gado kan meki den ston disi tron bakapikin fu Abraham. ");
INSERT INTO srnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A aksi de klar'klari kba na den rutu fu den bon. Ibri bon di no e gi bun froktu, den o kapu puru èn fringi go ini a faya.” ");
INSERT INTO srnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dan den sma aksi en taki: “We, san un mus du dan?” ");
INSERT INTO srnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohanes piki den taki: “A sma di abi tu empi mus gi wan na a sma di no abi, èn a sma di abi nyanyan mus gi a sma di no abi.” ");
INSERT INTO srnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Den man di e piki edemoni ben kon fu teki dopu tu. Dan den aksi Yohanes taki: “Meister, san unu mus du?” ");
INSERT INTO srnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A piki den taki: “No teki moro moni leki san yu mus teki.” ");
INSERT INTO srnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Den srudati srefi aksi en taki: “Èn san un dati mus du?” A piki den taki: “No teki sma moni nanga tranga, èn no lei gi wan sma di no du noti. A moni san yu e kisi mus de nofo gi yu.” ");
INSERT INTO srnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dan fu di a folku ben abi bigi howpu, meki den aksi densrefi efu a no Yohanes na a Mesias. ");
INSERT INTO srnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dat' meki Yohanes taigi den taki: “Mi e dopu unu nanga watra, ma wan Man e kon di abi makti moro mi. Mi no warti srefi fu lusu en susu puru na En futu. Na En o dopu unu nanga a Santa Yeye èn nanga faya. ");
INSERT INTO srnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A hori En wrokosani na ini En anu fu wai a buba puru ini a aleisi. A aleisi A o poti na ini En maksin, ma den buba A o bron na ini faya di no man dede.” ");
INSERT INTO srnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nanga furu tra wortu Yohanes ben ferteri den sma a Bun Nyunsu. ");
INSERT INTO srnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A ben piri ai tu gi a tiriman Herodes fu di a ben trow nanga Herodias, a frow fu en brada, èn fu ala den tra ogri san a ben du. ");
INSERT INTO srnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Dan Herodes du wan moro bigi ogri di a poti Yohanes na straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wan dei di Yohanes ben e dopu sma, Yesus srefi go teki dopu. Dan di Yesus ben e begi, heimel opo ");
INSERT INTO srnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","èn a Santa Yeye saka leki wan libilibi doifi kon na En tapu. Ne wan sten taki kmopo fu heimel taki: “Yu na mi Manpikin di Mi lobi. Mi abi prisiri nanga Yu.” ");
INSERT INTO srnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus ben abi dritenti yari so di A bigin nanga En wroko. Den sma ben sabi En leki a manpikin fu Yosef. Yosef ben de a manpikin fu Eli. ");
INSERT INTO srnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ben de a manpikin fu Matat, èn Matat ben de a manpikin fu Lefi. Lefi ben de a manpikin fu Melki, èn Melki ben de a manpikin fu Yanai. Yanai ben de a manpikin fu Yosef, ");
INSERT INTO srnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","èn Yosef ben de a manpikin fu Matatias. Matatias ben de a manpikin fu Amos, èn Amos ben a manpikin fu Nahum. Nahum ben de manpikin fu Hesli, èn Hesli ben a manpikin fu Nagai. ");
INSERT INTO srnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ben de a manpikin fu Maat, èn Maat ben de a manpikin fu Matatias. Matatias ben de a manpikin fu Semeyin, èn Semeyin ben de a manpikin fu Yosek. Yosek ben de a manpikin fu Yoda, ");
INSERT INTO srnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","èn Yoda ben de a manpikin fu Yoanan. Yoanan ben de a manpikin fu Resa, èn Resa ben de a manpikin fu Serubabel. Serubabel ben de a manpikin fu Sealtiyel, èn Sealtiyel ben de a manpikin fu Neri. ");
INSERT INTO srnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ben de a manpikin fu Melki, èn Melki ben de a manpikin fu Adi. Adi ben de a manpikin fu Kosam, èn Kosam ben de a manpikin fu Elmadan. Elmadan ben de a manpikin fu Er, ");
INSERT INTO srnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","èn Er ben de a manpikin fu Yosua. Yosua ben de a manpikin fu Eliyeser, èn Eliyeser ben de a manpikin fu Yorim. Yorim ben de a manpikin fu Matat, èn Matat ben de a manpikin fu Lefi. ");
INSERT INTO srnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lefi ben de a manpikin fu Simeon, èn Simeon ben de a manpikin fu Yuda. Yuda ben de a manpikin fu Yosef, èn Yosef ben de a manpikin fu Yonan. Yonan ben de a manpikin fu Elyakim, ");
INSERT INTO srnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","èn Elyakim ben de a manpikin fu Melea. Melea ben de a manpikin fu Mena, èn Mena ben de a manpikin fu Matata. Matata ben de a manpikin fu Natan, èn Natan ben de a manpikin fu David. ");
INSERT INTO srnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David ben de a manpikin fu Isai, èn Isai ben de a manpikin fu Obed. Obed ben de a manpikin fu Boas, èn Boas ben de a manpikin fu Salma. Salma ben de a manpikin fu Nakson, ");
INSERT INTO srnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","èn Nakson ben de a manpikin fu Aminadab. Aminadab ben de a manpikin fu Admin, èn Admin ben de a manpikin fu Arni. Arni ben de a manpikin fu Hesron, èn Hesron ben de a manpikin fu Peres. Peres ben de a manpikin fu Yuda, ");
INSERT INTO srnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","èn Yuda ben de a manpikin fu Yakob. Yakob ben de a manpikin fu Isak, èn Isak ben de a manpikin fu Abraham. Abraham ben de a manpikin fu Tera, èn Tera ben de a manpikin fu Nakor. ");
INSERT INTO srnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor ben de a manpikin fu Serug, èn Serug ben de a manpikin fu Rehu. Rehu ben de a manpikin fu Peleg, èn Peleg ben de a manpikin fu Eber. Eber ben de a manpikin fu Sela, ");
INSERT INTO srnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","èn Sela ben de a manpikin fu Kenan. Kenan ben de a manpikin fu Arpaksad, èn Arpaksad ben de a manpikin fu Sem. Sem ben de a manpikin fu Noa, èn Noa ben de a manpikin fu Lamek. ");
INSERT INTO srnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ben de a manpikin fu Metusela, èn Metusela ben de a manpikin fu Henok. Henok ben de a manpikin fu Yered, èn Yered ben de a manpikin fu Mahalalel. Mahalalel ben de a manpikin fu Kenan, ");
INSERT INTO srnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","èn Kenan ben de a manpikin fu Enos. Enos ben de a manpikin fu Set, èn Set ben de a manpikin fu Adam. Adam ben de a manpikin fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Di Yesus kmopo fu a Yordanliba, A ben furu nanga a Santa Yeye. Dan a Yeye tyari En go na ini a dreisabana, ");
INSERT INTO srnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","pe didibri tesi En fotenti dei langa. A heri pisten dati Yesus no ben nyan noti, so baka den fotenti dei angri bigin kiri En. ");
INSERT INTO srnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ne didibri taigi En taki: “Efu Yu na a Manpikin fu Gado, taigi a ston disi fu a tron brede.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Yesus piki en taki: “A skrifi taki: Wan sma no sa libi fu brede wawan.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dan didibri tyari Yesus go na wan hei presi. Ini a pingi fu wan ai a sori En ala den kondre fu grontapu. ");
INSERT INTO srnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Didibri taigi En taki: “Mi o gi Yu ala a makti fu den kondre disi nanga a gudu di den abi. Na mi kisi a makti disi, èn mi e gi en na suma mi wani. ");
INSERT INTO srnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mi o gi Yu ala den sani disi, efu Yu anbegi mi.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yesus piki en taki: “A skrifi taki: Yu mus anbegi Masra yu Gado, èn na En wawan yu mus dini.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Baka dati didibri tyari Yesus go na Yerusalem, dan a poti En tnapu na a lantyi fu a daki fu a mamakerki fu den Dyu. A taigi En taki: “Efu Yu na a Manpikin fu Gado, trowe Yusrefi go na gron. ");
INSERT INTO srnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bika a skrifi taki: Gado sa seni den engel fu En fu kibri Yu. ");
INSERT INTO srnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Moro fara: Den sa tyari Yu na tapu den anu, fu Yu no stotu Yu futu na wan ston.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma Yesus piki en taki: “A skrifi owktu taki: Yu no mus tesi Masra yu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Di didibri kba tesi Yesus, a gwe fu luru wan tra okasi. ");
INSERT INTO srnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Di Yesus drai go baka na Galilea, A ben furu nanga a krakti fu a Yeye. Ini a heri kontren drape den sma ben e taki fu En. ");
INSERT INTO srnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A ben e gi leri na ini den kerki fu den, èn ala sma ben e gi En bigi nen. ");
INSERT INTO srnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dan Yesus go na Nasaret pe A ben kweki. Soleki fa A ben gwenti fu du tapu a sabadei, A go na a Dyukerki. A opo tnapu fu leisi ");
INSERT INTO srnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","dan den gi En a buku san a profeiti Yesaya ben skrifi. Di A opo a buku, A leisi a pisi pe skrifi taki: ");
INSERT INTO srnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","A Yeye fu Masra de na mi tapu, bika A poti mi fu tyari Bun Nyunsu gi den pôtiwan. A seni Mi fu taigi den sma di feyanti poti na strafu, tak' den o lusu. A seni mi fu meki breniman si baka, fu puru sma na ini katibo, ");
INSERT INTO srnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","èn fu taki tak' a ten doro fu Masra sori En bunfasi. ");
INSERT INTO srnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Dan Yesus tapu a buku, A gi en na a man di e wroko ini a Dyukerki, dan A go sidon. Ala den sma ini a kerki ben e luku En. ");
INSERT INTO srnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dan Yesus taigi den taki: “Tide a pisi disi fu a Santa Buku san un yere, kon tru.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ala den sma ben lobi fa A taki, èn den ben ferwondru fa A ben taki so moi. Dan den taki: “Tan, a no a boi fu Yosef?” ");
INSERT INTO srnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesus piki den taki: “Mi sabi tak' un o koti a odo gi Mi taki: ‘Datra, dresi yusrefi! Un yere san Yu du ini Kafarnaum. We, du den srefi sani dyaso ini Yu eigi foto.’ ");
INSERT INTO srnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Fu tru Mi e taigi un taki: Den sma fu wan foto no e teki san den eigi profeiti e taki. ");
INSERT INTO srnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A sani san Mi e taigi unu now tru. Ini a ten fu Elia dri nanga afu yari langa, alen no ben fadon èn wan bigi angriten ben de ini a heri kondre. A pisten dati furu uma di masra dede kba ben de ini Israel. ");
INSERT INTO srnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma Gado no seni Elia go na no wan fu den. A seni en go na a foto Sarepta ini a birti fu Sidon. Drape a ben mus go na wan frow di masra dede kba. ");
INSERT INTO srnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sosrefi ini a ten di a profeiti Elisa ben e libi, furu gwasiman ben de ini Israel. Ma Elisa no ben dresi no wan fu den, boiti Naaman, a man fu Siriakondre.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Di den sma ini a kerki yere san Yesus taki, den ati bron srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ne den opo, dan den teki Yesus pusu puru ini a foto. Den pusu En go te na a lantyi fu a bergi tapu san a foto fu den ben bow, fu fringi En go na gron. ");
INSERT INTO srnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma Yesus waka psa na den mindri, dan A gwe. ");
INSERT INTO srnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dan Yesus go na Kafarnaum, wan foto ini Galilea. Tapu a sabadei A ben e gi den sma leri. ");
INSERT INTO srnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Den sma ben ferwondru fu a fasi fa A ben e gi leri, bika A ben taki leki a sma di kon nanga a leri. ");
INSERT INTO srnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wan man ben de ini a Dyukerki di ben abi wan takruyeye na en tapu. A bari nanga tranga sten taki: ");
INSERT INTO srnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Woooi! Yesus fu Nasaret, san Yu wani nanga unu? Na kon Yu kon fu puru un na pasi? Mi sabi suma na Yu. Yu na a Santa Wan fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma Yesus bari en taki: “Tapu yu mofo, èn kmopo na a man tapu!” Dan a takruyeye fringi a man trowe na gron na mindri den sma pe a ben tnapu. Dan a kmopo tapu a man sondro fu du en wan ogri. ");
INSERT INTO srnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ala den sma ben ferwondru. Den taigi makandra taki: “San na a leri disi? Bika nanga makti nanga krakti A e komanderi den takruyeye, èn den e gwe!” ");
INSERT INTO srnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dan so a nen fu Yesus ben bari na ala sei ini a kontren dati. ");
INSERT INTO srnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Baka dati Yesus kmopo ini a Dyukerki, dan A go na a oso fu Simon. Now a m'ma fu a frow fu Simon ben didon nanga hebi korsu, so den aksi Yesus fu dresi en. ");
INSERT INTO srnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus go tnapu na en sei, dan A taigi a korsu fu libi a skin. Ne a korsu saka. Wantron a frow opo, dan a poti nyanyan nanga dringi gi den. ");
INSERT INTO srnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Di a son saka, den sma tyari ala den sikisma fu den di ben abi ala sortu siki, kon na Yesus. Wan fru wan A ben poti anu na den tapu èn A dresi den. ");
INSERT INTO srnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Owktu takruyeye ben kmopo tapu furu sma. Den ben e bari taki: “Yu na a Manpikin fu Gado.” Ma Yesus bari den. A no gi den okasi fu taki, bika den ben sabi tak' En na a Mesias. ");
INSERT INTO srnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Di dei broko Yesus go na wan presi dorosei fu a foto pe sma no e libi. Dan den sma go suku En. Di den feni En, den ben wani hori En fu A no gwe. ");
INSERT INTO srnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma A taigi den taki: “Mi mus go na den tra foto tu, fu tyari a Bun Nyunsu tak' Gado o bigin tiri libisma. Bika na fu a sani dati Gado seni Mi kon.” ");
INSERT INTO srnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","So A go preiki na ini den Dyukerki fu Yudea. ");
INSERT INTO srnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wan dei Yesus ben tnapu na a syoro fu a Meer fu Genesaret. Wan bigi grupu sma ben kon na En fu yere a wortu fu Gado. Ma den ben pusu fu kon tnapu te na fes'sei. ");
INSERT INTO srnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Dan Yesus si tu boto na syoro. Den fis'man ben kmopo ini den boto, èn den ben e wasi den fis'neti fu den. ");
INSERT INTO srnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dan A go ini a boto san ben de fu Simon. A aksi Simon fu go pikinso na mindri, no tumsi fara fu a syoro. Yesus saka sidon, dan A bigin gi den sma leri kmopo fu a boto. ");
INSERT INTO srnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Di Yesus kba taki, A taigi Simon taki: “Go moro na mindrisei èn fringi den fis'neti fu yu go ini a watra.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Simon piki En taki: “Meister, heri neti un wroko tranga, ma un no kisi noti. Ma fu di na Yu taki, dan mi sa fringi den go ini a watra.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dan den fringi den fis'neti go na watra. Di den ben mus hari den kon baka, den neti ben span nanga fisi tak' den ben suku fu priti. ");
INSERT INTO srnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dan den kari den fis'mati fu den di ben de ini a tra boto fu kon yepi den. Di den man kon, den lai ala den tu boto nanga fisi tak' den boto ben suku fu sungu. ");
INSERT INTO srnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Di Simon Petrus si san psa, a fadon na tapu en kindi na Yesus fesi, dan a taki: “Masra, kmopo pe mi de, bika mi na wan sondusma.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bika en nanga den trawan di ben de nanga en, ben ferwondru fu den someni fisi san den fanga. ");
INSERT INTO srnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobus nanga Yohanes, den tu fis'mati fu Simon, ben ferwondru tu. A p'pa fu den tu man disi ben nen Sebedeus. Dan Yesus taigi Petrus taki: “No frede. Bigin fu now yu o fanga libisma.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ne den hari den boto poti na syoro, den libi ala sani drape, dan den bigin fu waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Di Yesus ben de ini wan fu den foto, wan man ben drape di ben abi gwasi na en heri skin. Di a man si Yesus, a trowe ensrefi langalanga na gron, dan a begi En taki: “Masra, efu Yu wani, Yu kan meki mi skin kon bun baka.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus langa En anu fasi a man, dan A taki: “Iya, Mi wani. Kon betre!” A srefi momenti dati a man kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dan Yesus warskow a man taki: “Yu no mus taigi no wan sma. Ma yu mus go na a Dyudomri, meki a si tak' yu kon betre. Dan fu sori ala sma tak' yu kon betre, yu mus tyari a offer gi Gado leki fa Moses skrifi tak' yu mus du te yu kon betre fu gwasi.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma a nyunsu fu Yesus ben e panya moro nanga moro, èn bun furu sma kon fu arki san A e taki èn fu A dresi den siki fu den. ");
INSERT INTO srnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma Yesus ben lobi fu go na den presi pe En wawan ben kan de, fu go begi drape. ");
INSERT INTO srnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wan fu den dei di Yesus ben e gi leri, wantu Fariseiman nanga sabiman fu Gado wèt ben sidon drape e arki tu. Den man disi ben kmopo kon fu Yerusalem nanga ala den dorpu ini den distrikti Galilea nanga Yudea. A krakti fu Masra ben de ini Yesus fu A kan dresi sma. ");
INSERT INTO srnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ne wantu man tyari wan lanman na tapu wan bedi kon drape. Den ben suku fu tyari en go poti ini a oso fesi Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ma fu di furu sma ben drape, den no ben man psa go na inisei. So den tyari en go tapu a daki fu a oso. Den puru wan pisi fu a daki, dan den saka a man nanga a heri bedi kon mindri den sma let' na fesi Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Di Yesus si a bribi fu den, A taki: “Mi mati, yu kisi pardon fu yu sondu.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dan den sabiman fu Gado wèt nanga den Fariseiman bigin taki na ini densrefi taki: “San a man disi e prakseri fu ensrefi? A e afrontu Gado! Na Gado wawan kan gi pardon fu sondu.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma Yesus ben sabi san den e prakseri, dan A piki den taki: “Fu sanede un e prakseri so ini un ati? ");
INSERT INTO srnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","San moro makriki? Fu taigi a man tak' a kisi pardon fu en sondu, noso fu taigi en fu a opo waka? ");
INSERT INTO srnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma Mi o sori unu tak' a Manpikin fu Libisma abi makti dya na grontapu fu gi sma pardon fu sondu.” Dan Yesus taigi a lanman taki: “Mi e taigi yu fu yu opo, teki yu bedi, dan yu go na oso.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wantron a man opo tnapu let' na den fesi. A teki a sani na tapu san a ben e didon, dan a go na oso. Heri pasi a ben gi Gado grani. ");
INSERT INTO srnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ala sma ferwondru sote èn den gi Gado glori. Nanga bigi lespeki gi Gado den taki: “Tide un si tumsi ferwondru sani.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Baka di Yesus kmopo fu drape, A si wan man di e piki edemoni. A man disi ben nen Lefi, èn a ben sidon pe den sma ben mus pai edemoni. Yesus taigi en taki: “Kon nanga Mi!” ");
INSERT INTO srnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ne Lefi opo libi ala sani, èn a bigin waka na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dan Lefi hori wan bigi fesa gi Yesus na en oso. Wan lo man di e piki edemoni nanga tra sma ben de ini a fesa e nyan makandra nanga den. ");
INSERT INTO srnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dan den Fariseiman, nanga den sabiman fu Gado wèt di ben de fu a grupu fu den, bigin krutu gi den man fu Yesus. Den taki: “Fu sanede unu e nyan èn dringi nanga den man di e piki edemoni, èn nanga den sondusma?” ");
INSERT INTO srnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus piki den taki: “Sma di gesontu no abi datra fanowdu, ma na sma di e siki abi datra fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi no kon fu kari bun sma, ma Mi kon fu taigi sondusma fu den drai den libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wantu sma taigi Yesus taki: “Furu leisi den sma di e teki leri fu Yohanes a Dopuman, e faste èn den e begi. Den sma di e teki leri fu den Fariseiman e du a srefi sani. Ma den man fu Yu e nyan èn den e dringi.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus piki den taki: “Yu no kan meki den sma di kon na wan trow-oso tan sondro fu nyan, solanga a trowmasra de drape. ");
INSERT INTO srnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma a ten o kon tak' den o puru a trowmasra na den mindri. Dan ini den dei dati den sa faste.” ");
INSERT INTO srnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Moro fara Yesus gi den tu agersitori. A taki: “No wan sma e priti wan pisi fu wan nyun empi puru fu lapu wan owru wan. Bika efu a du dati, a o pori ala tu. A nyun wan o priti, èn a nyun pisi no o fiti tapu a owru empi. ");
INSERT INTO srnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sosrefi yu no e poti win di no lepi ete na ini owru winsaka. Bika te a win o kari dyesi, den winsaka o priti, dan a win o lon gwe èn yu o lasi den winsaka. ");
INSERT INTO srnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dat' meki yu mus poti win di no lepi ete, na ini nyun winsaka. ");
INSERT INTO srnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma no wan sma di dringi lepi win kba, wani fu dringi win di no lepi ete. Bika a e feni tak' a lepi win moro bun.” ");
INSERT INTO srnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tapu wan sabadei Yesus ben e waka psa ini den aleisigron. Dan den man fu En broko wantu taki aleisi, den griti den na ini den anu fu puru a buba, dan den nyan. ");
INSERT INTO srnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma wantu fu den Fariseiman taki: “Fu sanede un e du wan sani san a wèt no wani fu un du tapu a sabadei?” ");
INSERT INTO srnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus piki den taki: “Un no leisi san David du, di angri ben e kiri en nanga den man di ben de nanga en? ");
INSERT INTO srnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A go ini a oso fu Gado, a teki den brede san den ben poti aparti gi Gado, dan a nyan den, èn a gi den man fu en meki den nyan tu. Ma no wan sma kan nyan den brede dati, boiti den Dyudomri.” ");
INSERT INTO srnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dan Yesus taki moro fara: “A Manpikin fu Libisma na a basi fu a sabadei.” ");
INSERT INTO srnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tapu wan tra sabadei Yesus go na a Dyukerki, dan A gi den sma leri. Wan man di let'anu ben malengri ben drape tu. ");
INSERT INTO srnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Den sabiman fu Gado wèt nanga den Fariseiman ben luru Yesus fu si efu A bo dresi wan sma tapu a sabadei. Nanga dati den bo feni wan sani fu tyari En go na krutu. ");
INSERT INTO srnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma Yesus ben sabi san den e prakseri. Dan A taigi a man nanga a malengri anu taki: “Opo, kon tnapu dya pe ala sma kan si yu.” Dan a man opo go tnapu. ");
INSERT INTO srnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesus taigi den taki: “Mi wani aksi unu wan sani. San a wèt e taki un kan du tapu a sabadei? Bun noso ogri? Fu puru wan sma na dede, noso fu libi en meki a dede?” ");
INSERT INTO srnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dan Yesus luku ala den sma di ben de lontu En, dan A taigi a man taki: “Langa yu anu!” A man langa en anu, dan a kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Den man ben kuku fu atibron. So den bigin aksi makandra san den mus du nanga Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A pisten dati Yesus ben go na tapu wan bergi fu go begi. Heri neti A tan drape e begi Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Di dei broko A kari den man kon di ben e teki leri fu En. Dan Yesus puru twarfu na den mindri, èn A kari den En boskopuman. ");
INSERT INTO srnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A teki Simon, di A ben kari Petrus, nanga en brada Andreas. Moro fara A teki Yakobus, Yohanes, Filipus, Bartolomeus, ");
INSERT INTO srnNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus nanga Tomas. Dan A teki Yakobus a manpikin fu Alfeus, nanga Simon wan fu den Seloten, ");
INSERT INTO srnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas a manpikin fu Yakobus, nanga Yudas Iskariot, a man di seri Yesus bakaten. ");
INSERT INTO srnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus saka kmopo fu a bergi nanga den man, dan A tan tnapu na a futu fu a bergi. Bun furu sma di ben e teki leri fu En ben drape. Wan heri ipi sma di ben kmopo fu Yerusalem nanga ala sei fu Yudea ben drape tu. Moro fara yu ben abi sma fu den foto Tirus nanga Sidon, di de na sei a Bigi Se. ");
INSERT INTO srnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Den ben kon fu arki san Yesus e taki, èn fu A dresi den siki fu den. Sma di takruyeye ben e pina, ben kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ala sma ben suku fu fasi En, bika krakti ben kmopo fu En, èn A ben meki ala sma kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus luku den sma di e teki leri fu En, dan A taki: “Blesi de tapu unu leki pôtiwan, bika unu na sma di Gado e tiri. ");
INSERT INTO srnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Blesi de tapu unu di e psa angriten now, bika Gado o gi unu san un abi fanowdu. Blesi de tapu unu di e krei now, bika Gado o meki un lafu. ");
INSERT INTO srnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Blesi de na unu tapu te sma no man si un na ai, èn te den no wani sabi not'noti fu unu, èn te den e taki takru fu unu, e gi un pori nen fu a Manpikin fu Libisma ede. ");
INSERT INTO srnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Un mus breiti èn dyompo fu prisiri na a ten dati, bika a pai san un abi na heimel bigi. Bika na so den afo fu den ben du nanga den profeiti. ");
INSERT INTO srnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ma un guduman, un mus luku bun! Bika un dati abi ala sani san un wani kba. ");
INSERT INTO srnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Un di abi nofo nownow, un mus luku bun! Bika un o psa angriten. Un di e lafu nownow, un mus luku bun! Bika wan ten o kon tak' un o abi dipi sari, èn un o krei. ");
INSERT INTO srnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Un di sma e taki soso bun fu unu, un mus luku bun! Bika na so den afo fu den ben taki bun fu den man di ben du leki den na profeiti.” ");
INSERT INTO srnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ma Mi e taigi unu di e arki Mi taki: Yu mus lobi yu feyanti. Du bun gi den sma di no man si un na ai. ");
INSERT INTO srnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Blesi den sma di e fluku yu. Begi gi den sma di e du yu ogri. ");
INSERT INTO srnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Efu wan sma naki yu na yu wan seifesi, drai a trawan gi en. Efu wan sma teki yu empi, gi en yu ondrobosroko tu. ");
INSERT INTO srnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Efu wan sma aksi yu wan sani, gi en. Efu wan sma teki wan sani fu yu, no aksi en baka. ");
INSERT INTO srnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yu mus libi nanga trawan soleki fa yu wani tak' den mus libi nanga yu. ");
INSERT INTO srnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Efu yu lobi soso den sma di lobi yu, sortu blesi yu abi? Bika den sondusma srefi lobi den sma di lobi den. ");
INSERT INTO srnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Efu yu e du bun soso gi den sma di e du bun gi yu, sortu blesi yu abi? Den sondusma e du a srefi sani. ");
INSERT INTO srnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Èn efu yu e leni soso den sma di yu sabi tak' kan leni yu baka, sortu blesi yu abi? Den sondusma srefi e leni trawan fu kan kisi a srefi baka. ");
INSERT INTO srnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nono, yu mus lobi yu feyanti èn du bun gi den. Leni sma sondro fu prakseri tak' den mus yepi yu baka. Tapu sowan fasi yu pai na Gado o bigi, èn yu sa de trutru pikin fu a Moro Hei Gado. Bika Gado bun gi den sma di no sabi san na tangi nanga den takru-ati sma. ");
INSERT INTO srnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yu mus abi sari-ati soleki fa yu P'pa na heimel abi sari-ati.” ");
INSERT INTO srnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“No suku fowtu na trawan, dan trawan no o suku fowtu na yu. No krutu sma, dan sma no o krutu yu. Gi pardon, dan yu o kisi pardon tu. ");
INSERT INTO srnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gi na sma, dan yu o kisi baka, bun furu, iya bogobogo psa marki. Bika na a fasi fa yu e gi, na so yu o kisi baka.” ");
INSERT INTO srnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dan Yesus gi den wantu agersitori. A taki: “Wan breniman no kan tyari wan tra breniman waka, noso den ala tu o fadon ini wan olo. ");
INSERT INTO srnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wan sma di e teki leri no sabi moro a sma di e gi en leri. Ma te a sma leri ala sani kba, dan a o kon de leki a sma di gi en leri. ");
INSERT INTO srnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Fa yu kan si a fini pisi udu ini a ai fu yu brada, ma yu no e si tak' wan postu de ini yu eigi ai? ");
INSERT INTO srnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fa yu kan taigi yu brada taki: ‘Brada, kon meki mi puru a fini pisi udu ini yu ai,’ ma yu no e si a postu ini yu eigi ai? Yu hoigriman! Puru a postu ini yu eigi ai fosi, dan yu o man si krin fu kan puru a fini pisi udu ini a ai fu yu brada.” ");
INSERT INTO srnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Wan gesontu bon no e gi kruwa froktu, èn wan bon san siki no e gi bun froktu. ");
INSERT INTO srnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yu e sabi a bon te yu si den froktu fu en. Yu no man piki figa na wan prasarabon, èn yu no man piki droifi na brantimaka. ");
INSERT INTO srnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wan bun sma e du bun sani fu di en ati bun. Ma wan takru sma e du ogri sani fu di en ati takru. San furu wan sma ati, na dati a e puru kon na doro.” ");
INSERT INTO srnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Sanede un e kari Mi: ‘Masra, Masra,’ ma un no e du san Mi e taki? ");
INSERT INTO srnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mi o sori unu fa a sma de di e kon na Mi, èn di e arki èn du san Mi e taki. ");
INSERT INTO srnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","A de leki wan sma di e diki go bun dipi fu meki wan steifi ston fundamenti di a bow wan oso. Di wan bigi frudu kon, a watra fu a liba naki a oso. Ma a oso no seki, fu di a ben bow bun. ");
INSERT INTO srnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma wan sma di e yere, ma no e du san Mi e taki, de leki wan sma di bow wan oso tapu a gron sondro fu diki wan fundamenti. Di a watra fu a liba naki a oso, dan wantron so a heri oso broko fadon te na gron.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Baka di Yesus kba taigi a folku ala den sani disi, A go ini a foto Kafarnaum. ");
INSERT INTO srnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Now wan Romeini ofisiri ben abi wan knekti di a ben lobi furu. A man disi ben siki tranga, te fu dede. ");
INSERT INTO srnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Di a ofisiri yere fu Yesus, a seni wantu fesiman fu den Dyu go na En, fu aksi En fu kon dresi a knekti. ");
INSERT INTO srnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Den man go na Yesus, dan den aksi En tangitangi fu kon yepi a ofisiri. Den taki: “A man disi fiti fu Yu yepi en, ");
INSERT INTO srnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","bika a lobi a Dyu pipel, èn na en bow a kerki gi unu.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dan so Yesus go nanga den. Di A doro krosbei fu a oso, a ofisiri seni den mati fu en go na Yesus nanga a boskopu taki: “Masra, no weri Yusrefi bika mi no warti fu Yu kon ini mi oso. ");
INSERT INTO srnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Dat' meki mi no ben firi misrefi warti fu kon na Yu. Ma efu Yu taki wan wortu nomo, dan a knekti fu mi o kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bika mi srefi e wroko ondro trawan, èn mi abi srudati di de ondro mi. Efu mi taigi wan fu den taki: ‘Go drape,’ a e go. Efu mi taigi wan trawan taki: ‘Kon dya,’ a e kon. Efu mi taigi mi srafu taki: ‘Du disi,’ a e du en.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Di Yesus yere a sani disi, A ferwondru. Dan A drai taigi a bigi grupu sma di ben waka na En baka taki: “Mi e taigi un taki: Na ini heri Israelkondre Mi no feni no wan sma nanga sowan bigi bribi.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Di den mati di a ofisiri ben seni, drai go baka na ini a oso, den si tak' a knekti kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wan syatu pisten baka dati Yesus go na a foto Nain. Den man di ben e teki leri fu En, nanga wan bigi grupu tra sma, ben go nanga En. ");
INSERT INTO srnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Di Yesus doro krosbei fu a bigi doro fu a foto, A si den sma e tyari wan dede kmopo ini a foto fu go beri. A dedeman ben de a wan enkri manpikin fu wan frow di masra dede kba. Furu sma fu a foto ben waka baka a dede. ");
INSERT INTO srnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Di Masra si a frow, A kisi wan dipi sari gi en, dan A taigi en taki: “No krei.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesus waka go na a dede, A fasi a dragi, dan den dragiman tan tnapu. Dan Yesus taki: “Yonkuman, Mi e taigi yu taki: Opo!” ");
INSERT INTO srnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A dedeman opo sidon, èn a bigin taki. Dan Yesus langa en gi en m'ma. ");
INSERT INTO srnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ala den sma ben kisi bigi lespeki gi Gado, èn den gi En grani taki: “Wan bigi profeiti opo na un mindri.” Den taki moro fara: “Gado kon fu yepi En folku.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A nyunsu fu san Yesus du ben panya na heri Yudea nanga den kondre san de lontu en. ");
INSERT INTO srnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Den man di ben e teki leri fu Yohanes ben go ferteri en ala den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Dan Yohanes seni kari tu fu den kon na en, èn a seni den fu go aksi Masra taki: “Na Yu na a Man di bo kon, noso wi mus ferwakti wan tra sma?” ");
INSERT INTO srnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Di den man go na Yesus den taki: “Na Yohanes a Dopuman seni un kon na Yu, fu aksi efu Yu na a Man di bo kon, noso efu wi mus ferwakti wan tra sma.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A pisten dati Yesus ben e dresi furu sma fu ala sortu siki èn A ben puru takruyeye na den tapu. Furu sma di ben breni A ben meki kon si baka. ");
INSERT INTO srnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dan Yesus piki den man fu Yohanes taki: “Un go taigi Yohanes san un si nanga san un yere: Breniman e si baka, lanman e waka, gwasiman skin e kon bun baka èn dofuman e yere. Owktu dedesma e wiki baka èn pôtisma e yere a Bun Nyunsu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Blesi de tapu a sma di no lasi bribi ini Mi.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Di den boskopuman fu Yohanes drai go baka, Yesus bigin ferteri a bigi grupu sma drape fu Yohanes. A taki: “Di un ben go na ini a dreisabana, san un ben go luku? Un no ben go luku fa a winti e wai a grasi! ");
INSERT INTO srnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma san un ben go luku dan? Wan man di weri diri krosi? Nono. Sma di e weri bun diri krosi èn di e libi bigi e tan ini kownu-oso. ");
INSERT INTO srnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma dan san un ben go luku dan? Wan profeiti? Iya, Mi e taigi unu: A de wan profeiti, ma a no dati wawan. ");
INSERT INTO srnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bika fu Yohanes a skrifi taki: Yere, Mi e seni Mi boskopuman go na Yu fesi, di sa meki a pasi klari gi Yu. ");
INSERT INTO srnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mi e taigi un taki: Fu ala sma di gebore, Yohanes na a moro prenspari wan. Ma toku a moro pikinwan na mindri den sma di Gado e tiri, prenspari moro en.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ala den sma di yere san Yesus taki, sosrefi den man di e piki edemoni, ben taki tak' Gado e du sani nanga leti. Bika den ben meki Yohanes dopu den. ");
INSERT INTO srnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma den Fariseiman nanga den sabiman fu Gado wèt poti a sani san Gado ben wani du gi den na wan sei. Bika den no ben meki Yohanes dopu den. ");
INSERT INTO srnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Dan Yesus taki: “Leki san Mi kan si den sma fu a ten disi? Leki san den de? ");
INSERT INTO srnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Den e du leki pikin di e prei tapu wan pren, dan den e bari gi den trawan taki: Un prei poku gi unu, ma un no dansi. Un singi dede-oso singi gi unu, ma un no krei. ");
INSERT INTO srnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bika di Yohanes a Dopuman kon, a ben tan furu leisi sondro fu nyan èn a no ben e dringi win. Dan un taki: ‘Wan takruyeye de na en tapu.’ ");
INSERT INTO srnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A Manpikin fu Libisma kon, A e nyan èn A e dringi. Ma fu En un e taki: ‘Luku, a man disi na wan akanswari nanga wan sopiman. Na wan mati fu den man di e piki edemoni nanga fu den sondusma.’ ");
INSERT INTO srnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma den sma di koni e sori tak' a koni fu Gado bun.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wan fu den Fariseiman ben kari Yesus fu kon nyan na en oso. Yesus go, dan A teki presi sei a tafra. ");
INSERT INTO srnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wan uma ben libi ini a foto, èn ala sma ben sabi en leki wan sondusma. Di a uma kon sabi tak' Yesus de ini a oso fu a Fariseiman e nyan, a teki wan albast batra nanga mirre-oli na ini, dan a go drape. ");
INSERT INTO srnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A go tnapu baka Yesus na En futusei. A ben e krei. A nati Yesus futu nanga en watra-ai, dan a drei den nanga en edewiwiri. A bosi Yesus futu, dan a lobi a oli gi den. ");
INSERT INTO srnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Di a Fariseiman di ben kari Yesus kon, si a sani disi, a prakseri na ini en ati taki: “Efu a man disi ben de wan profeiti, A bo sabi suma na a frow disi di e fasi En. A bo sabi tak' a frow disi na wan sondusma.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dan Yesus taigi en taki: “Simon, Mi wani taigi yu wan sani.” Simon taki: “Meister, taki. Mi e arki.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus taki: “Tu man ben de di ben mus pai wan man di e leni sma moni. A wan ben mus pai feifi hondro solfrumoni èn a trawan ben mus pai feifitenti solfrumoni. ");
INSERT INTO srnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma di den no ben man pai, a man taigi den tak' den no abi fu pai moro.” Dan A aksi Simon taki: “Sortu wan fu den tu man disi o lobi a man moro furu?” ");
INSERT INTO srnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon piki taki: “Mi denki tak' na a man di ben abi a moro bigi paiman.” Yesus taki: “Yu piki bun.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesus drai luku a frow, dan a taigi Simon taki: “Yu e si a frow disi? Di Mi kon ini yu oso, yu no gi Mi watra fu Mi wasi Mi futu. Ma nanga en watra-ai a nati Mi futu, èn a drei den nanga en edewiwiri. ");
INSERT INTO srnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yu no gi Mi wan bosi. Ma sensi Mi kon inisei, a no tapu fu bosi Mi futu. ");
INSERT INTO srnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yu no lobi oli na Mi ede, ma a frow disi lobi mirre-oli gi Mi futu. ");
INSERT INTO srnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dat' meki Mi e taigi yu taki: A furu lobi di a sori, e sori tak' a kisi pardon fu en sondu, awinsi den ben furu. Ma wan sma di kisi pardon fu pikinso sondu, e sori pikinso lobi.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dan Yesus taigi a frow taki: “Frow, yu kisi pardon fu yu sondu.” ");
INSERT INTO srnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Den sma di ben de makandra nanga Yesus sei a tafra bigin taki ini densrefi taki: “San a man disi e prakseri fu Ensrefi, tak' A e gi sma pardon fu sondu?” ");
INSERT INTO srnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma Yesus taigi a frow taki: “Frow, a bribi fu yu yepi yu. Go nanga freide.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Baka dati, Yesus waka foto fu foto èn dorpu fu dorpu e tyari a Bun Nyunsu tak' Gado o tiri libisma. Den twarfu man fu En ben waka nanga En. ");
INSERT INTO srnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wantu uma ben de makandra nanga En. Yesus ben dresi den uma disi, èn A ben puru takruyeye na den tapu. Yu ben abi Maria, di sma ben sabi leki Maria fu Magdala. Seibi takruyeye ben kmopo na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Moro fara yu ben abi Yohana, a frow fu Kusas. Kusas ben hori ai tapu den tra wrokoman fu Herodes. Dan yu ben abi Susana tu nanga wan lo trawan moro. Den uma disi ben yepi Yesus nanga den man fu En, nanga san den ben abi. ");
INSERT INTO srnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sma ben kmopo fu ala den foto kon na Yesus. Di wan bun bigi grupu sma ben kon makandra, Yesus ferteri den wan agersitori. ");
INSERT INTO srnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","A taki: “Wan man ben go sai siri na ini en gron. Di a e fringi den siri, wantu fadon tapu a pasi. Den sma di waka psa trapu den, èn den pikinfowru kon nyan den. ");
INSERT INTO srnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tra siri fadon tapu gron di lai ston na ini. Den sproiti, ma den dede gwe baka, fu di a gron no ben abi nofo watra. ");
INSERT INTO srnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Trawan fu den siri fadon pe makamaka grasi e gro. A makamaka grasi ben sproiti makandra nanga den tra siri. Di den bigin gro, a makamaka grasi no gi den siri okasi fu gro doro. ");
INSERT INTO srnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma tra siri fadon tapu bun doti. Di a gro kon, a gi hondro tron so furu nyanyan.” Dan Yesus bari taki: “Suma abi yesi fu yere, meki a yere!” ");
INSERT INTO srnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Den man di ben e teki leri fu Yesus, aksi En san a agersitori disi wani taki. ");
INSERT INTO srnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dan Yesus taki: “A fasi fa Gado o tiri libisma na wan kibritori. Gado meki un kon ferstan a kibritori disi. Ma Mi e ferteri den tra sma den sani disi na ini agersitori. Dat' meki den e luku, ma den no e si, èn den e arki, ma den no e ferstan. ");
INSERT INTO srnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Meki Mi brokobroko a agersitori gi unu. A siri na a wortu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Den siri di fadon tapu a pasi na den sma di e yere a boskopu. Ma didibri e kon puru san den yere na ini den ati, fu den no bribi meki Gado ferlusu den. ");
INSERT INTO srnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Den siri di fadon tapu gron di lai ston na ini, na den sma di e teki a boskopu san den yere nanga prisiri. Ma a boskopu no e beri rutu. Den e bribi fu wan syatu pisten, dan te tesi kon na den pasi, den e drai baka. ");
INSERT INTO srnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Den siri di fadon pe makamaka grasi e gro, na den sma di e yere a boskopu. Ma a heri pisten di den de tapu a pasi, den e broko den ede nanga den problema fu a libi, nanga grontapu gudu, èn nanga den tra grontapu sani. Den sani disi e tapu den fu den no kan gro, èn den no man gi nyanyan. ");
INSERT INTO srnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Den siri di fadon tapu bun doti, na den sma di e arki a boskopu nanga wan bun ati èn nanga wan ati di wani. Den sma disi e hori san den yere, èn den e gi nyanyan fu di den e hori doro.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Dan Yesus taki moro fara: “No wan sma e leti wan kokolampu fu poti ondro wan bari, noso ondro wan bedi. Ma yu e poti en na tapu wan tafra fu ala sma di e kon inisei kan si a faya. ");
INSERT INTO srnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bika noti san de na dungru o tan na dungru. Èn ala sani san kibri o kon na krin, èn a o de fu si. ");
INSERT INTO srnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","So yu mus luku bun nanga sortu ati yu e arki. Bika a sma di e arki Mi nanga wan ati di wani, Gado o gi en moro sabi. Ma a sma di no e arki Mi, awinsi san a denki tak' a sabi, Gado o puru en.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Den brada fu Yesus nanga En m'ma ben kon na En, ma den no ben man go inisei fu di den sma ben furu tumsi. ");
INSERT INTO srnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dan den sma taigi En taki: “Yu m'ma nanga den brada fu Yu de na dorosei. Den wani si Yu.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ma Yesus piki den taki: “Mi m'ma nanga Mi brada na den sma di e arki a wortu fu Gado, èn di e du san den yere.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wan dei Yesus go ini wan boto nanga den man fu En. A taigi den taki: “Kon meki un go na abrasei fu a meer.” Dan den kmopo na syoro. ");
INSERT INTO srnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Di den e koti abra, Yesus fadon na sribi. Dan wan bun tranga winti bigin wai tapu a meer èn den ben de na nowtu, bika watra ben e kon ini a boto. ");
INSERT INTO srnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dan den man go wiki Yesus taki: “Meister, Meister, wi e dede!” Yesus opo dan A bari a winti nanga den skwala. So a winti tapu fu wai, èn a watra tapu fu seki. Ala sani kon tiri. ");
INSERT INTO srnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dan Yesus aksi den taki: “Pe a bribi fu unu de?” Den man kon frede èn den ferwondru. A wan taigi a trawan taki: “Suma na a Man disi tak' A e komanderi a winti nanga a watra èn den e du san A e taki!” ");
INSERT INTO srnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na so den doro ini a kontren fu den sma fu Gerasa, di de abrasei fu Galilea. ");
INSERT INTO srnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Di Yesus go na syoro, wan man fu a foto dati waka miti En. Takruyeye ben de tapu a man disi, èn na wan heri pisten kba a no ben weri krosi. A no ben e libi na ini wan oso, ma a ben e libi na ini den berpe. ");
INSERT INTO srnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Di a si Yesus, a bari èn a fadon tapu en kindi na En fesi. A bari nanga tranga sten taki: “Yesus, Manpikin fu a Moro Hei Gado, san Yu wani nanga mi? Mi e begi Yu: No pina mi!” ");
INSERT INTO srnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A taki so, bika Yesus ben komanderi a takruyeye fu kmopo tapu a man. A ben de so tak' furu leisi a takruyeye ben tyari en gwe sondro fu a wani. Den sma ben tai en nanga keti èn den ben bui en na en futu fu a no gwe, ma a ben koti den keti èn a takruyeye ben meki a go na presi pe furu sma no ben de. ");
INSERT INTO srnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dan Yesus aksi en taki: “Fa yu nen?” A piki taki: “Mi nen na Hilahila,” bika bun furu takruyeye ben de tapu a man. ");
INSERT INTO srnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dan den takruyeye begi Yesus fu A no seni den go ini a olo san no abi gron. ");
INSERT INTO srnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Now yu ben abi bun furu agu drape di ben e nyan na a bergiskin. Dan den takruyeye begi Yesus fu A meki den go ini den agu. So A meki den go. ");
INSERT INTO srnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ne den takruyeye kmopo tapu a man, go na ini den agu. Dan den agu lon saka fu a bergi go ini a meer, dan den dede. ");
INSERT INTO srnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Di den man di ben luku den agu si san psa, den lon gwe. Den go ini a foto nanga den presi ini a kontren fu a foto, go ferteri san ben psa. ");
INSERT INTO srnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","So ala den sma kon fu si san psa. Den go na Yesus, dan den si a man di ben abi den takruyeye fosi na en tapu, sidon na Yesus futusei. A ben weri krosi èn a ben de ensrefi. Ne ala den sma kon frede. ");
INSERT INTO srnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Den sma di si fa ala sani waka, ferteri den tra sma fa a man di ben abi den takruyeye na en tapu, ben kon fri. ");
INSERT INTO srnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ala sma fu a kontren fu Gerasa ben frede sote tak' den aksi Yesus tangitangi fu A gwe. So Yesus go baka ini a boto, dan A gwe. ");
INSERT INTO srnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma fosi Yesus gwe, a man aksi En efu a kan go nanga En. Ma Yesus seni en gwe. A taigi en taki: ");
INSERT INTO srnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Go baka na yu oso, èn ferteri den sma ala sani san Gado du gi yu.” So a man waka ini a heri foto, e ferteri san Yesus du gi en. ");
INSERT INTO srnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Di Yesus drai go baka na abrasei fu a meer, wan heri ipi sma ben tnapu e wakti En. ");
INSERT INTO srnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ne wan man Yairus kon na Yesus. Yairus ben de wan edeman fu a Dyukerki. A fadon tapu en kindi na Yesus futu, dan a begi En tangitangi fu kon na en oso, ");
INSERT INTO srnNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bika en wan enkri umapikin ben de fu dede. A pikin ben abi twarfu yari. Di Yesus ben de na pasi, wan heri ipi sma ben waka nanga En, e kwinsi En fu ala sei. ");
INSERT INTO srnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na mindri den sma wan uma ben de, di ben abi wan siki san ben meki tak' a e lasi brudu twarfu yari kba. No wan sma no ben man dresi en. ");
INSERT INTO srnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A uma waka mindri den sma kon baka Yesus, dan a fasi a ondrosei pisi fu En krosi. Wantron a kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dan Yesus aksi taki: “Suma na a sma di fasi Mi?” Ala den sma piki tak' a no den. Dan Petrus taki: “Ma Meister, someni sma e pusu e kwinsi Yu fu ala sei.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma Yesus piki taki: “Wan sma fasi Mi. Bika Mi firi tak' krakti kmopo fu Mi.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dan a frow kon ferstan tak' Yesus firi tak' a fasi En. Nanga beifi ati a kon na fes'sei, dan a fadon tapu en kindi fesi Yesus. Let' fesi ala sma a ferteri En fu sanede a ben fasi En, èn tak' wantewante a kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dan Yesus taigi en taki: “Mi pikin, a bribi fu yu meki yu kon betre. Yu kan go nanga kowru-ati.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus ben e taki ete nanga a frow, di wan sma fu Yairus kon na en nanga a boskopu taki: “A umapikin fu yu dede. Yu no mus weri a Meister En ede moro.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma di Yesus yere san a taki, A taigi Yairus taki: “No lasi ati. Bribi nomo, dan a sa kon betre.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Di Yesus doro na Yairus oso, A no meki no wan sma kon na inisei nanga En, boiti Petrus, Yohanes, Yakobus, nanga a m'ma nanga a p'pa fu a pikin. ");
INSERT INTO srnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ala sma ben e bari e krei fu di a pikin dede. Ma Yesus taki: “Un no krei. A pikin no dede. Na sribi a e sribi.” ");
INSERT INTO srnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma den sma bigin lafu En, bika den ben sabi tak' a pikin dede. ");
INSERT INTO srnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dan Yesus hori a pikin na en anu. A taki nanga tranga sten taki: “Pikin, opo!” ");
INSERT INTO srnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A pikin kisi libi baka, èn a opo tnapu wantron. Dan Yesus taigi den fu gi en wan sani fu nyan. ");
INSERT INTO srnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A m'ma nanga a p'pa fu a pikin no ben sabi san fu prakseri. Ma Yesus taigi den krin tak' den no mus taigi no wan sma san psa. ");
INSERT INTO srnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wan dei Yesus kari den twarfu man fu En kon na En, dan A gi den krakti nanga makti fu puru ala sortu takruyeye tapu sma èn fu dresi sikisma. ");
INSERT INTO srnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dan A seni den go fu panya a nyunsu tak' Gado bigin tiri libisma èn fu dresi sma. ");
INSERT INTO srnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A taigi den taki: “Te un e gwe, un no mus tyari noti fu te un de na pasi. Un no mus tyari wan wakatiki noso wan saka. Un no mus tyari nyanyan, moni noso tra krosi. ");
INSERT INTO srnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Efu wan sma wani fu un tan ini en oso, dan un mus tan drape te leki un go moro fara. ");
INSERT INTO srnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma efu no wan sma no wani fu un tan na ini den oso, dan un mus kmopo ini a foto dati. Un naki a santi fu a foto dati puru na un futu, fu meki den sma ferstan tak' un no e tyari frantwortu moro gi den.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","So den waka go na ala den dorpu. Ala presi pe den ben go, den ben panya a Bun Nyunsu èn den ben dresi sma. ");
INSERT INTO srnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Di Herodes, a tiriman fu Galilea, yere fu ala den sani di ben psa, a no ben sabi san a ben mus prakseri. Bika son sma ben taki tak' Yohanes ben kon baka na libi. ");
INSERT INTO srnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tra sma ben taki tak' Elia ben kon baka, èn trawan baka ben taki tak' wan fu den fosten profeiti ben kon baka na libi. ");
INSERT INTO srnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma Herodes taki: “Na mi meki den kapu Yohanes ede puru. Ma dan suma na a man disi fu san mi e yere?” So Herodes ben du muiti fu si Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Di den boskopuman fu Yesus drai kon baka, den ferteri En ala sani san den ben du. Dan Yesus tyari den go nanga En na a foto Betsaida, na wan presi pe den wawan ben kan de. ");
INSERT INTO srnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma di ala den sma kisi fu yere pe A de, den go na En baka. Yesus meki den kon na En, dan A bigin taki nanga den fu a fasi fa Gado o tiri libisma. A dresi sma tu di ben siki. ");
INSERT INTO srnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Di a son bigin saka, den twarfu man fu Yesus kon na En, dan den taigi En taki: “Seni ala den sma gwe fu den go suku wan presi fu sribi nanga wan sani fu nyan na ini den dorpu nanga den kampu ini a birti, bika sma no e libi dya pe un de.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ma Yesus taigi den taki: “Na unu mus gi den sma wan sani fu nyan.” Ma den taki: “Un abi feifi brede nomo, nanga tu fisi. Noso na go un mus go fu bai nyanyan gi ala den sma disi.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Den taki so bika na feifi dusun mansma so ben drape. Dan Yesus taigi den man fu En taki: “Un meki den go sidon ini grupu fu feifitenti sma.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","So den meki den sma go sidon soleki fa Yesus taki. ");
INSERT INTO srnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Dan Yesus teki den feifi brede nanga den tu fisi, A luku go na heimel èn A begi. Dan A broko den brede nanga den fisi, èn A gi den man fu En fu den prati gi a bigi grupu sma. ");
INSERT INTO srnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ala den sma nyan te den bere furu. Baka dati den man fu Yesus furu twarfu baskita nanga den pis'pisi di ben tan abra. ");
INSERT INTO srnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wan dei Yesus ben de En wawan e begi, èn den man fu En ben de nanga En. Dan Yesus aksi den taki: “Suma den bigi grupu sma e taki tak' Mi de?” ");
INSERT INTO srnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Den piki taki: “Son sma e taki: Yu na Yohanes a Dopuman. Tra sma e taki: Yu na Elia. Trawan baka e taki: Yu na wan fu den fosten profeiti di kon baka na libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dan Yesus aksi den taki: “Ma unu, suma unu e taki tak' Mi de?” Petrus piki En taki: “Yu na a Mesias di Gado seni kon.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dan Yesus warskow den krin tak' den no mus taigi no wan sma. ");
INSERT INTO srnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesus taki moro fara taki: “A Manpikin fu Libisma o abi fu nyan furu pina. Den fesiman fu a folku, den prenspari domri, nanga den sabiman fu Gado wèt o poti En na wan sei. Sma o kiri En, ma tapu a di fu dri dei Gado o meki A kon baka na libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dan Yesus taigi ala den sma taki: “Efu wan sma wani waka na Mi baka, a mus poti en eigi wani na wan sei. A mus de klar'klari ala dei fu nyan pina te fu dede srefi, èn a mus kon nanga Mi. ");
INSERT INTO srnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bika a sma di wani tan libi fa a wani, o lasi en libi. Ma a sma di e poti en libi na wan sei fu Mi ede, sa kisi a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bika san yu e wini efu yu kisi ala sani fu grontapu, ma yu lasi a libi fu têgo, noso yu pori yu libi? ");
INSERT INTO srnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ala sma di o taki tak' den no sabi Mi, noso den sani san Mi e leri, a Manpikin fu Libisma o taigi den owktu tak' A no sabi den te A drai kon baka nanga a bigi makti fu En, fu En P'pa nanga fu den santa engel. ");
INSERT INTO srnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mi e taigi unu wan tru sani: Son sma de dya na un mindri di no sa dede fosi den si fa Gado o bigin tiri libisma.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Aiti dei so baka di Yesus taki den sani disi, A teki Petrus, Yohanes nanga Yakobus go na tapu wan bergi fu go begi. ");
INSERT INTO srnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Di Yesus ben e begi, En fesi kenki èn En krosi kon weti tak' a e brenki. ");
INSERT INTO srnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dan wantron so tu man ben drape e taki nanga En. A ben de Moses nanga Elia. ");
INSERT INTO srnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Den ben e brenki, èn den ben e taki nanga Yesus fu a dede di A bo dede na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus, Yohanes nanga Yakobus ben fadon na sribi. Di den wiki, den si fa Yesus ben e brenki, èn den si den tu man di ben e taki nanga En. ");
INSERT INTO srnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Di Elia nanga Moses ben de fu gwe, Petrus taigi Yesus taki: “Meister, a bun tak' un dya. Meki un meki dri tenti: wan gi Yu, wan gi Moses nanga wan gi Elia.” Ma Petrus taki a sani disi sondro fu denki moro fara. ");
INSERT INTO srnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Di a ben e taki, wan wolku saka kon na den tapu. Di a wolku tapu den, den kon frede. ");
INSERT INTO srnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dan wan sten taki kmopo ini a wolku taki: “Disi na mi Manpikin, di Mi teki fu du Mi wani. Un mus arki san A e taki.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Di a sten e taki, den si Yesus wawan nanga den. Ini a ten dati den man fu Yesus no ferteri no wan sma san den ben si. Den ben hori den mofo. ");
INSERT INTO srnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A tamara fu en, di den saka kmopo fu a bergi, wan bigi grupu sma waka miti Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ne wan man ini a grupu bari taki: “Meister, mi e begi Yu fu kon luku a boi fu mi. Na en wawan mi abi. ");
INSERT INTO srnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wan yeye e kon na en tapu, dan wantron a e bigin bari. A yeye e gi en stoipi tak' skuma e kmopo ini en mofo. Te a yeye bigin pina en, a no wani libi en. ");
INSERT INTO srnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi ben aksi den man di e teki leri fu Yu fu yagi a yeye puru na en tapu, ma den no ben man.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dan Yesus taigi den sma taki: “Ai baya! Yu kan si tak' un no e bribi, èn tak' un ati takru. O langa Mi mus tan na un mindri fu teki den sani disi?” Dan A taigi a man taki: “Tyari yu manpikin kon dya.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Di a boi e waka kon, a takruyeye naki en stoipi fringi trowe na gron. Yesus komanderi a takruyeye fu kmopo ini a boi, dan a boi kon betre. Dan Yesus langa a boi baka gi en p'pa. ");
INSERT INTO srnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ala den sma ben tnapu nanga opo mofo di den si a fasi fa Gado bigi. A pisten di den sma ben e ferwondru ete fu ala den sani san Yesus ben e du, A taigi den man fu En taki: ");
INSERT INTO srnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Un no mus fergiti a sani san Mi o taigi un now: Den o gi a Manpikin fu Libisma abra na ini anu fu libisma.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma den man no ben ferstan san Yesus ben wani taki. A ben de wan kibritori gi den, di den no ben man ferstan. Ma den ben frede fu aksi Yesus san A ben wani taki. ");
INSERT INTO srnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wan pikin tak'taki ben de mindri den man fu Yesus, fu sortu wan fu den na a moro prenspari wan. ");
INSERT INTO srnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma Yesus ben sabi san den e prakseri, so A teki wan pikin poti tnapu na En sei. ");
INSERT INTO srnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dan A taigi den taki: “A sma di opo en doro gi sowan pikin ini Mi nen, e opo en gi Mi. Èn a sma di opo en doro gi Mi, e opo en gi a Wan di seni Mi kon. Bika a wan fu unu di saka ensrefi gi ala trawan, na en na a moro prenspari wan.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dan Yohanes taki: “Meister, un si wan man e yagi takruyeye puru na sma tapu na ini Yu nen. Un ben suku fu tapu en, bika a no de ini a grupu fu unu.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesus piki taki: “No tapu en. Bika efu wan sma no e suku fu tapu a wroko fu unu, dan a de na un sei.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A ten fu Yesus go baka na heimel ben kon krosbei, so A teki a besroiti fu go na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dan A seni wantu boskopuman go na En fesi. Den man go na wan fu den dorpu fu Samaria, fu seti sani gi Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma den sma no ben wani A tan drape, bika A ben de na pasi fu go na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Di Yakobus nanga Yohanes yere a sani disi, den taki: “Masra, Yu wani fu un taki fu faya kmopo na heimel fu bron den kiri?” ");
INSERT INTO srnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma Yesus drai, dan A piri ai gi den. ");
INSERT INTO srnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dan den go na wan tra dorpu. ");
INSERT INTO srnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Di den ben de na pasi, wan sma taigi Yesus taki: “Mi sa go nanga Yu ala sei pe Yu e go.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma Yesus piki en taki: “Krab'dagu abi den olo, èn pikinfowru abi den nesi. Ma a Manpikin fu Libisma no abi wan presi fu kanti En ede.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dan Yesus taigi wan tra sma taki: “Kon nanga Mi.” Ma a man piki taki: “Masra, gi mi a okasi fu go beri mi p'pa fosi.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dan Yesus taki: “Meki den dedewan beri den eigi dede. Ma yu mus go panya a nyunsu tak' Gado o tiri libisma.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dan ete wan tra sma taigi Yesus taki: “Masra, mi sa waka na yu baka, ma meki mi go bari den ososma fu mi adyosi fosi.” ");
INSERT INTO srnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma Yesus taigi en taki: “A sma di poti en futu na pasi kba, ma dan a e tan luku na baka, no fiti fu kon ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Baka dati Masra teki ete seibitenti-na-tu (72) tra man, dan A seni den tu na tu go na En fesi na ala den foto nanga presi pe En srefi bo go. ");
INSERT INTO srnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A taigi den taki: “A nyanyan ini a gron lepi kba fu koti, èn a furu, ma nofo wrokoman no de. Fu dat'ede un mus begi Masra di abi a gron, fu A seni moro wrokoman go ini a gron fu koti a nyanyan. ");
INSERT INTO srnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","So, un go. Mi e seni unu leki pikin skapu go na mindri den tigri. ");
INSERT INTO srnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Un no mus tyari portmoni, saka, noso susu. Èn un no mus tan taki tori na pasi. ");
INSERT INTO srnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te un go na ini wan sma oso, a fosi sani san un mus taki na: ‘A freide fu Gado mus de nanga unu.’ ");
INSERT INTO srnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Efu a sma di abi a oso na wan sma di lobi freide, dan a freide san un winsi en sa tan nanga en. Ma efu na wan sma di no lobi freide, dan a freide san un winsi en o drai kon baka na unu. ");
INSERT INTO srnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Te un go tan na wan sma oso, un mus tan drape. Nyan èn dringi san den gi unu, bika a fiti tak' wan wrokoman kisi en pai. Un no mus froisi fu a wan oso go na a trawan. ");
INSERT INTO srnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Efu den sma fu wan foto meki un kon ini a foto fu den, dan un mus nyan san den gi unu fu nyan. ");
INSERT INTO srnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dresi den sikiwan drape, dan un taigi den taki: ‘Her'esi Gado o bigin tiri libisma.’ ");
INSERT INTO srnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma efu un doro wan foto pe den sma no wani fu un tan drape, dan un mus go na tapu strati dan un taki: ");
INSERT INTO srnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Srefi a santi fu a foto fu unu wi e figi puru na wi futu. Ma un mus sabi tak' her'esi Gado o bigin tiri libisma.’ ");
INSERT INTO srnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mi e taigi un taki: Tapu a bigi dei, a strafu fu a foto disi o hebi moro a strafu fu a foto Sodom.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Dan Yesus taki: “Un sma fu Korasin nanga Betsaida, un mus luku bun! Bika efu den bigi sani di psa na un mindri, ben psa na ini den foto Tirus nanga Sidon, someni langa den sma dati bo drai den libi. Den bo weri rowkrosi èn sidon ini asisi fu sori tak' den e sari. ");
INSERT INTO srnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tapu a bigi krutu dei, a strafu fu unu o hebi moro di fu den sma fu Tirus nanga Sidon. ");
INSERT INTO srnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Un sma fu Kafarnaum, un e prakseri tak' un o doro na heimel? Na ini dedekondre un o feni unsrefi!” ");
INSERT INTO srnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dan Yesus taki: “A sma di e arki san un e taki, e arki Mi. Suma no wani arki san un e taki, no wani arki san Mi e taki. Èn suma no e arki Mi, no e arki a Wan di seni Mi kon.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Den seibitenti-na-tu (72) man ben prisiri di den drai kon baka. Den taigi Yesus taki: “Masra, te nanga den takruyeye srefi e du san un taki te un kari a nen fu Yu.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dan Yesus piki den taki: “Mi si fa Satan fadon fu loktu kon na gron, soleki fa faya e koti na loktu. ");
INSERT INTO srnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Luku, Mi gi unu makti fu trapu na tapu sneki nanga kruktutere. Mi gi un makti tu na tapu a heri legre fu didibri. Noti no sa du unu ogri. ");
INSERT INTO srnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ma un no mus prisiri fu di den takruyeye e du san un taki, ma un mus prisiri fu di un nen skrifi na ini heimel.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A srefi ten dati, a Santa Yeye furu Yesus nanga prisiri. Dan Yesus taki: “P'pa, Yu di de Masra fu heimel nanga grontapu, Mi e taki Yu tangi tak' Yu kibri den sani disi meki den koniman nanga den leriman no ferstan den, ma dan Yu sori den na den sma di no sabi furu. Iya, P'pa, bika na so Yu ben wani en.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesus taki: “Mi P'pa gi Mi makti abra ala sani. Boiti a P'pa, no wan sma no sabi suma na a Manpikin. Èn no wan sma no sabi suma na a P'pa, boiti a Manpikin nanga den sma di a Manpikin wani fu sabi dati.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dan Yesus kari den man fu En kon na wan sei. A taigi den taki: “Blesi de na un tapu, fu di un e si den sani san un e si now. ");
INSERT INTO srnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bika Mi e taigi un taki: Furu profeiti nanga kownu ben wani si san unu e si, ma den no si en. Èn den ben wani yere san unu e yere, ma den no yere en.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wan dei wan sabiman fu Gado wèt go na Yesus fu tesi En. A taki: “Meister, san mi mus du fu kan kisi a libi fu têgo?” ");
INSERT INTO srnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus piki en taki: “San skrifi ini a wèt fu Gado? San yu e leisi drape?” ");
INSERT INTO srnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A man piki taki: “A skrifi taki: Yu mus lobi Masra, yu Gado, nanga yu heri ati, nanga yu heri sili, nanga ala yu krakti, èn nanga yu heri ferstan. Èn yu mus lobi tra sma soleki fa yu lobi yusrefi.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus taigi en taki: “Yu piki bun. Du dati, dan yu o kisi a libi fu têgo.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma a man ben wani krin en fesi, dat' meki a aksi Yesus taki: “Ma suma na den tra sma?” ");
INSERT INTO srnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dan Yesus piki en taki: “Wan man ben kmopo fu Yerusalem e go na a foto Yeriko. Di a ben de na pasi, fufuruman grabu en. Den teki ala san a ben abi, den fon en te fu dede, dan den gwe libi en didon drape. ");
INSERT INTO srnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A ben de so tak' baka dati, wan Dyudomri ben psa na tapu a srefi pasi. Di a si a man, a koti abra go waka na a tra sei fu a pasi. ");
INSERT INTO srnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Owktu wan Lefitiman ben psa drape. Di a si a man, en srefi koti abra go waka na a tra sei. ");
INSERT INTO srnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Baka dati wan man fu Samaria kon psa. Di a doro krosbei, a si a man didon tapu a pasi, dan a firi sari gi en. ");
INSERT INTO srnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A go na a man, a krin den soro fu en nanga oli nanga win, dan a tai den. Baka dati a poti a man na tapu en eigi buriki. A tyari en go na wan oso pe yu ben kan yuru wan presi fu tan, dan a sorgu gi en. ");
INSERT INTO srnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A tra dei, fosi a man fu Samaria gwe, a gi a man di abi a presi tu solfrumoni. A taigi en taki: ‘Luku a man gi mi. Efu a moni no sari, dan te mi e drai kon baka mi sa pai yu.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dan Yesus aksi a sabiman fu Gado wèt taki: “Taigi Mi, sortu wan fu den dri man disi sori a man di den fufuruman grabu tak' a de wan sma di e lobi tra sma?” ");
INSERT INTO srnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A piki taki: “A wan di sori sari-ati gi a tra man.” Dan Yesus taigi en taki: “Go, dan yu du a srefi sani tu.” ");
INSERT INTO srnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus nanga den man di e teki leri fu En waka go moro fara. Di den doro na wan fu den dorpu, wan frow di ben nen Marta kari Yesus kon na en oso. ");
INSERT INTO srnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A ben abi wan sisa di nen Maria. Maria ben sidon na Yesus futusei e arki san Yesus ben e leri. ");
INSERT INTO srnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Marta ben e broko en ede nanga ala den sani san ben de fu du. Dan a go na Yesus èn a taigi En taki: “Masra, Yu no abi bisi tak' mi sisa e libi mi wawan fu du ala a wroko? Yu no kan taigi en fu a kon yepi mi?” ");
INSERT INTO srnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma Yesus piki en taki: “Marta, Marta. Yu e broko yu ede, èn yu e feti nanga someni sani. ");
INSERT INTO srnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ma na wan sani nomo de fanowdu. Èn Maria teki a bun sani dati, san no wan sma no man puru na en anu.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wan dei Yesus ben de na wan presi e begi. Baka di A kba begi, wan fu den man di e teki leri fu En, aksi En taki: “Masra, leri un begi, soleki fa Yohanes leri den man di e teki leri fu en.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dan Yesus taki: “Te yu e begi, yu mus taki: P'pa, Yu nen mus de santa. Kon tiri wi. ");
INSERT INTO srnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gi wi ala dei a nyanyan di wi abi fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gi wi pardon fu wi sondu, bika wi srefi e gi ala sma pardon di du wi wan sani. Èn no meki tesi kon na wi pasi.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Dan Yesus taki moro fara: “Kon un taki wan fu unu abi wan mati, dan yu go mindrineti na en go aksi en taki: ‘Mati, leni mi dri brede fu yu, ");
INSERT INTO srnNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bika wan mati fu mi di e go na wan presi, kon luku mi. Ma mi no abi noti fu gi en.’ ");
INSERT INTO srnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dan a mati fu yu bari kmopo fu en oso taki: ‘No ferferi mi. Mi doro sroto kba, èn mi nanga den pikin fu mi go didon kba. Mi no man opo fu gi yu brede.’ ");
INSERT INTO srnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mi e taigi yu taki: Awinsi a no ben wani opo fu gi yu san yu abi fanowdu fu di yu nanga en na mati, toku a o du en fu di yu e tan naki tapu en doro. ");
INSERT INTO srnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Dat'ede Mi e taigi un taki: Tan begi, dan yu sa kisi. Tan suku, dan yu sa feni. Tan naki, dan doro sa opo gi yu. ");
INSERT INTO srnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bika a sma di e tan begi, e kisi. A sma di e tan suku, e feni. Èn a sma di e tan naki, doro e opo gi en. ");
INSERT INTO srnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sortu p'pa de na un mindri di o gi en boi wan sneki, efu a boi aksi en wan fisi? ");
INSERT INTO srnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Noso wan kruktutere, efu a boi aksi en wan eksi? ");
INSERT INTO srnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","We, efu unu leki sondusma sabi fa fu gi un pikin bun sani, fa fu un P'pa di de na heimel dan? A sa gi a Santa Yeye na den sma di e aksi En fu dati.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wan dei Yesus ben e puru wan takruyeye di no ben man taki tapu wan man. Baka di a takruyeye gwe, a babawman bigin taki. A bigi grupu sma di ben drape ben ferwondru. ");
INSERT INTO srnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma sonwan fu den taki: “Na Beelsebul, a edeman fu den takruyeye, e gi En a makti fu yagi den takruyeye puru.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Trawan ben suku fu tesi Yesus. Den ben wani fu A sori den wan marki di kmopo fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma Yesus ben sabi san den e prakseri. A taigi den taki: “Ibri kondre pe den sma e feti nanga densrefi, o broko, èn a wan oso o fadon tapu a trawan. ");
INSERT INTO srnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Unu e taki tak' na Beelsebul e gi Mi krakti fu yagi den takruyeye puru. Ma efu Satan e feti nanga den tra didibri, fa a o man tan rigeri dan? ");
INSERT INTO srnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Efu na Beelsebul e gi Mi a krakti fu yagi takruyeye, suma e gi den sma fu unu a krakti dati dan? Dat' meki na den srefi o sori unu tak' un no abi leti. ");
INSERT INTO srnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma efu na Gado e gi Mi a krakti fu yagi den takruyeye, dan dati e sori tak' Gado bigin tiri libisma kba. ");
INSERT INTO srnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Te wan tranga man di abi ala en fetisani, e hori wakti gi en eigi oso, dan noti fu en no kan lasi. ");
INSERT INTO srnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma te wan sma di tranga moro en sa kon feti nanga en, èn wini en, dan a o teki ala den fetisani tapu san a trangaman ben e bow, èn a o prati den tra sani san a teki. ");
INSERT INTO srnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Suma no de na Mi sei, e suku fu broko Mi. Èn suma no e wroko makandra nanga Mi, e tyari prati.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Te wan takruyeye kmopo na tapu wan sma, a e go na dreisabana fu suku wan presi fu rostu. Te a no feni, dan a e taki: ‘Mi o drai go baka na mi oso pe mi kmopo.’ ");
INSERT INTO srnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Te a drai kon, a e si tak' a tanpresi krin èn ala sani de tapu en presi. ");
INSERT INTO srnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dan a e gwe go teki seibi tra takruyeye kon di ogri moro en. Den e kon inisei, èn den e tan drape. Te fu kba a kon moro takru gi a sma leki na a bigin.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Di Yesus ben e taki den sani disi, wan frow di ben de ini a bigi grupu sma, bari taigi En taki: “Blesi de tapu a m'ma di tyari Yu na ini en bere, èn di gi Yu bobi.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma Yesus piki en taki: “Iya, na so a de. Ma wan moro bigi blesi de tapu den sma di e arki Gadowortu èn di e du san a e taki.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Moro nanga moro sma ben e kon arki Yesus. Dan Yesus taki: “Unu fu a ten disi na takru-ati sma. Un wani tak' Mi mus sori un wan marki. Ma a wan enkri marki san un o kisi, na a wan fu Yona. ");
INSERT INTO srnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bika leki fa Yona ben de wan marki gi den sma fu a foto Nineve, na so a Manpikin fu Libisma sa de wan marki gi unu. ");
INSERT INTO srnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tapu a bigi krutu dei, a uma di ben tiri a kondre Seba sa tnapu makandra nanga unu fu a ten disi èn a sa krutu unu. Bika a ben kmopo fu wan farawe kondre kon arki a koni fu Salomo. Ma luku, wan sma de dya di bigi moro Salomo. ");
INSERT INTO srnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tapu a dei dati, den sma fu Nineve sa tnapu makandra nanga unu fu a ten disi èn den o krutu unu. Bika den ben drai den libi di Yona tyari a boskopu gi den. Ma luku, wan sma de dya di bigi moro Yona.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“No wan sma e leti wan kokolampu fu poti na ini wan kasi noso ondro wan embre. Ma yu e poti en na tapu wan tafra, fu ala sma di e kon na inisei kan si a faya. ");
INSERT INTO srnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yu ai de leki wan lampu di e tyari leti gi yu skin. Efu yu ai krin, yu heri libi krin. Ma efu yu ai dungru, dan yu heri libi dungru. ");
INSERT INTO srnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sorgu tak' a sani san mus tyari leti kon gi yu, no e tyari dungru. ");
INSERT INTO srnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","So efu yu heri libi krin, èn no wan dungru pisi no de, dan a o de neleki te a faya fu wan lampu e krin ala sani. Yu heri libi o krin fu tru.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Di Yesus ben e taki ete, wan fu den Fariseiman kari En kon na en oso fu kon nyan. Yesus go inisei, dan A teki presi sei a tafra. ");
INSERT INTO srnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A Fariseiman ferwondru di a si tak' Yesus bigin nyan sondro fu wasi En anu. ");
INSERT INTO srnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dan Masra taigi en taki: “Un Fariseiman e wasi dorosei fu a kan nanga a preti. Ma fu inisei, un lai gridi maniri nanga takru prakseri. ");
INSERT INTO srnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Un donman unu! Gado di meki dorosei, meki inisei tu. ");
INSERT INTO srnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Prati san un abi nanga pôtisma, dan ala sani o de krin gi unu. ");
INSERT INTO srnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ma un Fariseiman, un mus luku bun! Bika un e gi Gado tin prosenti fu den moro pikin spesrei di un prani. Ma un no e krutu sma tapu wan leti fasi, èn un no lobi Gado. A bun fu du a wan sani, ma dan un mus du a tra wan tu. ");
INSERT INTO srnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Un Fariseiman, un mus luku bun! Bika un lobi fu sidon na den moro prenspari presi na ini den kerki, èn un lobi te sma e gi un lespeki odi na wowoyo. ");
INSERT INTO srnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Un Fariseiman, un mus luku bun! Bika un de leki grebi di no de fu si. Den sma di e waka na den tapu, no sabi srefi tak' na tapu grebi den e waka.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wan fu den sabiman fu Gado wèt taigi Yesus taki: “Meister, efu Yu e taki so, Yu e afrontu unu tu.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Yesus piki en taki: “Un sabiman fu Gado wèt, un mus luku bun tu! Bika un e poti ala sortu wèt gi den sma di tranga fu hori. Ma un srefi no e broko un ede nanga den. ");
INSERT INTO srnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Un mus luku bun! Bika un e meki moimoi grebi gi den profeiti, ma na den afo fu unu ben kiri den. ");
INSERT INTO srnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","A sani san un e du, e sori tak' un e feni en bun san den afo fu unu ben du. Bika na den kiri, èn unu e meki den grebi. ");
INSERT INTO srnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dat' meki Gado ini En bigi koni ben taki: ‘Mi o seni profeiti nanga boskopuman go na den. Sonwan fu den, den o kiri, èn den o de na trawan baka fu du den ogri.’ ");
INSERT INTO srnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gado o meki unu di libi now pai fu a brudu fu ala den profeiti di lon sensi grontapu meki, ");
INSERT INTO srnNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","bigin fu a brudu fu Abel kon te na a brudu fu Sakarias di den kiri ini a Oso fu Gado mindri a altari nanga a Santa Presi. Iya, un kan sabi tak' Gado o meki un pai fu dati. ");
INSERT INTO srnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Un sabiman fu Gado wèt, un mus luku bun! Un no e gi den sma a sroto fu den ferstan den sani fu Gado. Un srefi no e meki muiti fu ferstan den, èn un tapu den sma di e pruberi fu du dati.” ");
INSERT INTO srnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Di Yesus ben e gwe fu a oso fu a Fariseiman, a ati fu den sabiman fu Gado wèt nanga den Fariseiman ben bita na En tapu. Espresi den ben aksi En ala sortu sani fu suku En mofo. ");
INSERT INTO srnNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Na so den ben seti trapu gi Yesus, fu A kan taki wan sani di no bun. ");
INSERT INTO srnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","A pisten dati dusundusun sma ben kon makandra. Den ben furu sote tak' den ben e kwinsi densrefi. Dan Yesus bigin taki ini a fosi presi nanga den man di ben e teki leri fu En. A taki: “Un mus luku bun nanga a dyesi fu den Fariseiman, sobun a hoigri maniri fu den. ");
INSERT INTO srnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ala sani san de na dungru o kon na krin, èn ala sani di kibri o kon na doro. ");
INSERT INTO srnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dat'ede efu yu ben taki wan sani na dungru, sma o yere en na a krin fu dei. Èn san yu ben taigi wan sma safri na ini en yesi na ini yu sribikamra, den o bari na strati. ");
INSERT INTO srnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mi mati, Mi e taigi un taki: Un no abi fu frede den sma di te den kiri yu, den no man du noti moro. ");
INSERT INTO srnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma Mi o taigi unu suma un mus frede. Un mus frede a Wan di baka te A kiri, A abi a makti fu trowe ini hel tu. Fu tru Mi e taigi un taki: Na En un mus frede! ");
INSERT INTO srnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Un sabi tak' yu kan bai feifi gadotyo gi tu koprosensi. Ma toku Gado e sorgu gi ibri wan fu den. ");
INSERT INTO srnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Iya, Gado sabi srefi omeni wiwiri yu abi na tapu yu ede. So un no mus frede, bika un warti moro leki furu gadotyo. ");
INSERT INTO srnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mi e taigi un taki: Efu wan sma e taigi trawan tak' a sabi Mi, dan a Manpikin fu Libisma o taki na fesi den engel fu Gado tak' A sabi en tu. ");
INSERT INTO srnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma a sma di e taigi trawan tak' a no sabi Mi, a Manpikin fu Libisma o taki na fesi den engel fu Gado tu tak' A no sabi en. ");
INSERT INTO srnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ala sma di e taki takru fu a Manpikin fu Libisma, kan kisi pardon fu dati. Ma a sma di e afrontu a Santa Yeye, no o kisi pardon. ");
INSERT INTO srnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Te den tyari yu go na krutu na ini den kerki fu den, noso na fesi den fesiman nanga den bigiman fu kondre, dan yu no abi fu broko yu ede fa yu o taki, noso san yu mus taki fu puru yusrefi. ");
INSERT INTO srnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bika a yuru dati a Santa Yeye sa taigi yu san yu mus taki.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wan sma ini a grupu taigi Yesus taki: “Meister, taigi mi brada tak' a mus prati a gudu nanga mi, san un p'pa libi na baka di a dede.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma Yesus piki en taki: “Mi mati, suma poti Mi leki krutubakra, noso fu prati a gudu gi yu nanga yu brada?” ");
INSERT INTO srnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dan Yesus taigi den sma taki: “Un mus luku bun nanga gridi maniri. Bika awinsi fa yu gudu psa marki, yu libi a no fu yu.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dan Yesus gi den wan agersitori. A taki: “A gron fu wan guduman ben gi furu nyanyan. ");
INSERT INTO srnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dan a man prakseri taki: ‘San mi mus du? Bika mi no abi presi fu poti ala den nyanyan di mi koti.’ ");
INSERT INTO srnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dan a taki: ‘Mi sabi san mi o du. Mi o broko den maksin fu mi, dan mi o meki moro bigi wan. Baka dati mi o poti ala a aleisi nanga den tra gudu fu mi drape. ");
INSERT INTO srnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dan mi o taigi misrefi taki: Ai, mi kibri nofo gudu gi furu yari. Now mi kan rostu. Mi o nyan, dringi èn prisiri.’ ");
INSERT INTO srnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma Gado taigi en taki: ‘Yu lawman! Tide neti srefi Mi o teki a libi fu yu. Dan suma o kisi ala den sani san yu ben kibri poti ini den maksin?’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dan Yesus taki: “Na disi e psa nanga a sma di e tyari furu gudu kon na wan gi ensrefi, ma di no gudu na Gado ai.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dan Yesus taigi den man di e teki leri fu En taki: “Dat'ede Mi e taigi un taki: No broko yu ede nanga san yu o nyan fu tan na libi, noso san yu o weri fu tapu a skin. ");
INSERT INTO srnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bika a libi warti moro leki nyanyan, èn a skin warti moro leki krosi. ");
INSERT INTO srnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Luku den tingifowru. Den no e prani, èn den no e koti. Den no abi maksin fu poti nyanyan. Ma toku Gado e gi den nyanyan. We, unu warti krinkrin moro den fowru! ");
INSERT INTO srnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sortu wan fu unu kan meki tak' a e libi pikinso moro langa te a e broko en ede? ");
INSERT INTO srnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Efu yu no man du sowan pikin sani, dan fu sanede yu e broko yu ede nanga den tra sani? ");
INSERT INTO srnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Luku fa den bromki e gro. Den no e wroko èn den no e meki krosi. Ma Mi e taigi un taki: Wan bigi kownu leki Salomo srefi no ben man weri so moi leki den bromki disi. ");
INSERT INTO srnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","We, efu Gado e weri so moi krosi gi a grasi di e gro tide èn tamara sma e bron en, A no sa weri moro moi wan gi yu? Fa un bribi pikin so? ");
INSERT INTO srnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","No broko un ede. No aksi unsrefi san yu o nyan noso san yu o dringi. ");
INSERT INTO srnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bika na den sma fu grontapu di no sabi Gado, e broko den ede nanga den sani disi. Ma a P'pa fu unu sabi tak' un abi den fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Un mus suku fu de ondro a tiri fu Gado, dan A sa gi un den sani disi tu.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Unu na wan pikin grupu, ma no frede! Bika un P'pa feni en bun fu un kon ondro a tiri fu En. ");
INSERT INTO srnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Un mus seri san un abi fu yepi den pôtisma. Un mus meki monisaka di no e kon owru, wan gudu na heimel di no e kba noiti. Drape fufuruman no man kon fufuru en, èn kakalaka no man nyan en. ");
INSERT INTO srnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bika pe yu gudu de, na drape yu ati o de tu.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Un mus sorgu tak' un tnapu klar'klari, èn tak' den lampu fu un leti. ");
INSERT INTO srnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Un mus de leki knekti di e wakti tapu den masra, di o drai kon baka fu wan trowfesa. Te a drai kon baka dan a naki, den kan opo a doro wantron gi en. ");
INSERT INTO srnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","A masra o blesi den knekti di de na ai te a kon baka. Fu tru Mi e taigi un taki: A masra o seti en krosi fu wroko. A o meki den knekti teki presi sei a tafra, dan a o kon gi den nyanyan. ");
INSERT INTO srnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Awinsi a masra kon mindrineti noso musudei, a o blesi den knekti di a kon miti na ai. ");
INSERT INTO srnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma un mus sabi disi: Efu a man di abi a oso ben sabi sortu yuru a fufuruman bo kon, a no bo meki a broko kon ini en oso. ");
INSERT INTO srnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na so un mus de klar'klari, bika a Manpikin fu Libisma o drai kon baka na wan yuru di un no ferwakti.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dan Petrus aksi En taki: “Masra, gi suma Yu e gi a agersitori disi? Gi unu wawan, noso gi ala den tra sma dyaso?” ");
INSERT INTO srnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Masra piki en taki: “Suma na a koni knekti tapu san en masra kan bow? Na a wan di a o poti fu luku den tra knekti, èn fu gi den a nyanyan san den mus kisi na a yuru di fiti. ");
INSERT INTO srnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A masra o blesi a knekti dati efu te a kon baka, a si tak' a e du en wroko soleki fa a fiti. ");
INSERT INTO srnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Fu tru Mi e taigi un taki: A masra sa poti en fu luku ala den sani san a abi. ");
INSERT INTO srnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma kon un taki a knekti prakseri taki: ‘A masra fu mi no o kon ete,’ dan a bigin fon den tra man nanga uma di e wroko gi en masra, èn a e nyan, dringi te leki a drungu. ");
INSERT INTO srnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Dan a masra fu en o kon tapu wan dei di a no ferwakti, èn tapu wan yuru di a no sabi. A o meki den kapu en pis'pisi, meki a kisi a srefi strafu leki den sma di no de fu fertrow. ");
INSERT INTO srnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A knekti di sabi san en masra wani, ma a no seti ensrefi èn a no du san en masra wani, o kisi bun hebi fonfon. ");
INSERT INTO srnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma a knekti di no sabi san en masra wani, no o kisi hebi strafu efu a du wan sani san fiti fu kisi strafu. Bika a sma di kisi furu, den o aksi fu gi furu. Èn a sma di kisi moro furu, den o aksi fu gi moro furu.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Mi kon fu sutu wan faya na grontapu, èn fu Mi sei a ben kan leti kba. ");
INSERT INTO srnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mi mus nyan wan hebi pina èn a sani dati de leki wan hebi lai na tapu Mi ati solanga a no psa. ");
INSERT INTO srnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Un no mus prakseri tak' Mi kon fu tyari freide na grontapu. Nono, na pratifasi o kon. ");
INSERT INTO srnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bika bigin fu now, pratifasi o de mindri den sma ini wan oso. Efu feifi sma de ini wan oso, tu no o agri nanga den dri trawan, èn den dri trawan no o agri nanga den tu. ");
INSERT INTO srnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A p'pa no o feni en nanga en boi, èn a boi no o feni en nanga en p'pa. A m'ma no o feni en nanga en umapikin, èn a umapikin no o feni en nanga en m'ma. A m'ma fu a boi no o feni en nanga a frow fu a boi, èn a frow fu a boi no o feni en nanga a m'ma fu a boi.” ");
INSERT INTO srnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dan Yesus taigi a bigi grupu sma taki: “Te un si tak' wolku e kmopo fu westsei, wantron un e taki: ‘Alen o kon.’ Èn a e kon tu. ");
INSERT INTO srnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te un si tak' a winti e wai kmopo fu a zuidsei, un e taki: ‘A o faya tide.’ Èn a e psa tu. ");
INSERT INTO srnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Un hoigriman! Un sabi luku efu alen o kon, noso efu a son o faya. Ma fu sanede un no man ferstan san e psa ini a ten disi? ");
INSERT INTO srnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Fu sanede un no wani du muiti fu kon ferstan san bun? ");
INSERT INTO srnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kon un taki wan sma di abi wan sani nanga yu, e tyari yu go na krutu. Dan yu mus meki muiti fu seti a tori te un de na pasi ete. Efu yu no du dati, a o tyari yu go na fesi krutubakra. Dan a krutubakra sa gi yu abra na skowtu di sa poti yu na ini straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Fu tru Mi e taigi yu taki: Yu no o kmopo drape solanga yu no pai te nanga a laste koprosensi.” ");
INSERT INTO srnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A srefi ten dati wantu sma kon taigi Yesus fa granman Pilatus kiri wantu man fu Galilea, meki den brudu moksi nanga a offer san den ben e tyari gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus piki den taki: “Un no mus prakseri tak' fu di den man disi dede sowan fasi, tak' den ben abi moro sondu moro den tra sma fu Galilea. ");
INSERT INTO srnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nono. A no de so kwet'kweti. Ma efu un no drai un libi, un alamala o dede leki den! ");
INSERT INTO srnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Èn di a hei wakti-oso na Siloam fadon kiri tin-na-aiti sma, san un prakseri? Un prakseri tak' den sma disi ben abi moro sondu moro den tra sma di e libi ini Yerusalem? ");
INSERT INTO srnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nono. A no de so kwet'kweti. Ma efu un no drai un libi, un alamala o dede leki den!” ");
INSERT INTO srnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dan Yesus gi wan agersitori. A taki: “Wan man ben abi wan figabon san a ben prani na ini en droifidyari. A man ben go fu piki froktu na a bon, ma a bon no ben abi froktu. ");
INSERT INTO srnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dan a taigi a man di e luku a droifidyari taki: ‘Luku, na dri yari kba mi e kon fu piki froktu na a figabon disi. Ma mi no e feni. Kapu en puru! Na fu soso a de dya e mangri a gron.’ ");
INSERT INTO srnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ma a man piki en taki: ‘Masra, libi a bon ete wan yari. Mi o diki lontu a bon, dan mi o krabu doti poti gi en. ");
INSERT INTO srnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Efu a yari san e kon a gi froktu, dan a bun. Ma efu a no gi, dan yu kan kapu en trowe.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tapu wan sabadei Yesus ben e gi leri na ini wan fu den Dyukerki. ");
INSERT INTO srnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dan now wan uma ben drape. Tin-na-aiti yari kba wan takruyeye ben meki en skin kon swaki. A uma disi ben kron, a no ben man tnapu let'opu srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Di Yesus si en, A kari en kon, dan A taigi en taki: “Frow, yu kon fri fu a sani san e swaki yu skin.” ");
INSERT INTO srnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesus poti En anu na en tapu, dan wantron a tnapu let'opu, èn a bigin gi Gado grani. ");
INSERT INTO srnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma a edeman fu a Dyukerki ben mandi di Yesus dresi wan sma tapu a sabadei. Dan a taigi ala den sma drape taki: “Siksi dei de ini wan wiki fu wroko. Un kon tapu wan fu den dei dati fu den dresi unu, ma no kon tapu a sabadei.” ");
INSERT INTO srnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma Masra piki en taki: “Un hoigriman! Tapu a sabadei un alamala e lusu un kaw nanga un buriki puru ini a pen fu tyari den go dringi. ");
INSERT INTO srnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","We, a uma disi na wan bakapikin fu Abraham. Luku, tin-na-aiti yari langa Satan ben tai en hori. So a fiti fu lusu a banti disi tapu a sabadei.” ");
INSERT INTO srnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Di Yesus taki so, ala den sma firi syen di no ben agri nanga san A ben du. Ma ala den tra sma ben breiti nanga ala den bigi sani san Yesus ben du. ");
INSERT INTO srnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Dan Yesus taki: “San Mi kan teki fu sori unu fa Gado e tiri libisma? Leki san un kan si en? ");
INSERT INTO srnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","A de leki wan mosterdsiri san wan sma prani ini en dyari. A gro tron wan bon, èn den pikinfowru meki den nesi na ini.” ");
INSERT INTO srnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus taki moro fara: “San Mi kan teki fu sori unu fa Gado e tiri libisma? ");
INSERT INTO srnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A de leki dyesi di wan frow e teki poti ini bun furu blon. Dan a dyesi e meki ala a blon kon sweri.” ");
INSERT INTO srnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus ben de na pasi e go na Yerusalem. A ben e waka psa ini den foto nanga den dorpu e gi den sma leri. ");
INSERT INTO srnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dan wan sma aksi En taki: “Masra, na wantu sma nomo Gado o ferlusu?” ");
INSERT INTO srnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesus piki en taki: “Meki ala muiti fu psa ini a smara doro. Bika Mi e taigi un taki: Furu sma o pruberi fu psa, ma den no o man. ");
INSERT INTO srnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te a man di abi a oso, opo go sroto a doro, dan un o tnapu na dorosei. Un o naki tapu a doro e taki: ‘Masra, opo a doro gi unu!’ Ma A o piki un taki: ‘Mi no sabi unu. Pe un kmopo?’ ");
INSERT INTO srnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dan un o taki: ‘Un ben nyan, dringi makandra nanga Yu, èn Yu ben gi leri na tapu den strati fu unu.’ ");
INSERT INTO srnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma A o piki un taki: ‘Un kmopo na mi fesi, un ogri-ati sma. Mi no sabi unu. Pe un kmopo?’ ");
INSERT INTO srnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dan un o krei èn kaw un tifi te un si Abraham, Isak, Yakob, nanga ala den profeiti na mindri den sma di Gado e tiri. Ma unu den o fringi poti na dorosei. ");
INSERT INTO srnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sma o kmopo na ala sei fu grontapu fu sidon nyan makandra nanga den sma di Gado e tiri. ");
INSERT INTO srnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Arki. Sonwan fu den lastewan o tron fosiwan, èn sonwan fu den fosiwan o tron lastewan.” ");
INSERT INTO srnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A srefi pisten dati, wantu Fariseiman kon na Yesus. Den taigi En taki: “Yu mus kmopo fu dyaso go na wan tra presi, bika Herodes wani kiri Yu.” ");
INSERT INTO srnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus piki den taki: “Un go taigi a awari dati gi Mi taki: Luku, tide nanga tamara Mi o yagi takruyeye puru na sma tapu, èn Mi o dresi sma. Tapu a di fu dri dei, Mi klari nanga Mi wroko. ");
INSERT INTO srnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ma tide, tamara nanga tra tamara Mi mus waka go moro fara. Bika a no fiti fu den kiri wan profeiti dorosei fu Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ai, Yerusalem, Yerusalem, yu di e kiri den profeiti èn di e ston den sma kiri di Gado seni kon na yu! Mi kari den pikin fu yu someni leisi fu kon na Mi, soleki fa wan mamafowru e kari en pikin kon ondro en frei. Ma un no ben wani. ");
INSERT INTO srnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Luku, a oso fu unu o tan leigileigi na baka. Mi e taigi un taki: Un no o si Mi moro te leki a dei di un taki: Blesi de tapu a Wan di e kon ini a nen fu Masra.” ");
INSERT INTO srnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wan dei Yesus go nyan na a oso fu wan fu den edeman fu den Fariseiman. Den man ben luru En fu luku efu A bo du wan sani, fu di a ben de wan sabadei. ");
INSERT INTO srnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Now wan man ben drape fesi Yesus di ben abi wan siki san ben meki en skin sweri. ");
INSERT INTO srnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dan Yesus aksi den sabiman fu Gado wèt nanga den Fariseiman taki: “San a wèt e taki? A fiti fu dresi wan sma tapu a sabadei, efu no?” ");
INSERT INTO srnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma den man no taki noti. So Yesus teki a man na en anu, A dresi en, dan A meki a man gwe. ");
INSERT INTO srnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dan Yesus aksi den taki: “Efu wan boi noso wan burkaw fu wan fu unu fadon go ini wan peti tapu a sabadei, a no wantewante un e go puru en?” ");
INSERT INTO srnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma den man no ben man piki En noti. ");
INSERT INTO srnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Di Yesus si fa den tra sma di ben kisi kari fu kon nyan, ben teki den moro prenspari presi sei a tafra, A gi den wan agersitori. A taki: ");
INSERT INTO srnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Te wan sma kari yu kon na wan trow-oso, no go sidon te na fes'sei. Bika kande a sma kari wan tra sma kon di hei moro yu. ");
INSERT INTO srnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Dan a sma di kari un fu kon nyan, o kon taigi yu taki: ‘Opo, meki a man disi sidon dya.’ Dati o de wan syen gi yu, èn yu o abi fu go sidon te na bakasei. ");
INSERT INTO srnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ma te wan sma kari yu fu kon nyan, go sidon na bakasei. Dan kande te a sma di e hori a fesa kon na inisei, a sa taigi yu taki: ‘Mi mati, kon moro na fes'sei.’ A sani dati o de wan grani gi yu na fesi ala den tra sma di de na tafra. ");
INSERT INTO srnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bika ibri sma di e opo ensrefi, den o broko en saka. Ma a sma di e saka ensrefi, den o opo en.” ");
INSERT INTO srnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dan now Yesus taigi a Fariseiman di ben kari En kon taki: “Te yu o kari sma fu kon nyan, awinsi na bakadina noso neti, dan yu no mus kari yu mati kon, noso den brada nanga den tra famiri fu yu, noso den gudusma fu yu birti. Bika wan tra leisi den kan gi yu wan kari tu. Na so yu o kisi pai baka fu san yu ben du. ");
INSERT INTO srnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma te yu o kari sma fu kon nyan, yu mus kari den pôtisma, den malengrisma, den lanman nanga den breniman. ");
INSERT INTO srnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Te yu du dati, blesi o de na yu tapu, fu di den sma disi no abi noti fu gi yu baka. Èn Gado o pai yu tapu a dei di den sma di libi bun ini En ai, o kon na libi baka.” ");
INSERT INTO srnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Di wan fu den sma di ben sidon na tafra nanga Yesus, yere san A taki, a taigi En taki: “Blesi de tapu a sma di o de ini a fesa te Gado o tiri libisma.” ");
INSERT INTO srnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dan Yesus piki en nanga wan agersitori. A taki: “Wan man bo hori wan bigi fesa èn a ben kari bun furu sma kon. ");
INSERT INTO srnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Di a yuru doro fu go na tafra, a seni en knekti fu go kari den sma taki: ‘Un kon! A tafra seti kba.’ ");
INSERT INTO srnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ma den alamala bigin taki tak' den no man kon moro. A fosi wan taki: ‘Mi bai wan gron, èn mi mus go nomonomo fu go luku en. Mi e begi yu fu no mandi nanga mi fu di mi no man kon moro.’ ");
INSERT INTO srnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wan trawan taki: ‘Mi bai tin burkaw, èn mi e go luku fu si efu den bun. Mi e begi yu fu no mandi nanga mi fu di mi no man kon moro.’ ");
INSERT INTO srnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wan trawan taki baka: ‘A no tumsi langa di mi trow nanga mi frow. Fu dat'ede mi no man kon moro.’ ");
INSERT INTO srnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","A knekti drai go baka, go taigi en masra san den man taki. Dan a masra ati bron. A taigi en knekti taki: ‘Go wantewante na tapu den strati nanga den pikinpikin pasi fu a foto. Tyari den pôtisma, den malengrisma, den breniman nanga den lanman kon dya.’ ");
INSERT INTO srnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Di a knekti go te a kon, a taki: ‘Masra, mi du kba san yu taigi mi. Ma presi de ete.’ ");
INSERT INTO srnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dan a masra taigi a knekti taki: ‘Go na den pasi fu den bakabini nanga den boiti presi, dan yu dwengi den sma fu kon. Bika mi oso mus furu. ");
INSERT INTO srnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yu kan bribi mi: No wan fu den sma di mi ben seni kari o tesi a nyanyan fu mi.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bun furu sma ben e waka na Yesus baka. Dan A drai taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Efu wan sma wani kon na Mi, a mus libi en m'ma nanga en p'pa, nanga en frow nanga en pikin. A mus libi en brada nanga en sisa tu. Iya, a mus poti en eigi libi na wan sei. Efu a no man du dati, dan a no man de wan sma di e teki leri fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Suma no de klar'klari fu nyan pina te fu dede srefi te a e waka na Mi baka, no man de wan sma di e teki leri fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bika ala sma di wani bow wan oso, e sidon fosi fu teri luku omeni moni a abi fanowdu. Na so a o si efu a abi nofo moni fu bow a oso. ");
INSERT INTO srnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Efu a no du dati, kande a no man klari a oso baka te a meki a fundamenti. Dan ala sma di psa o lafu en. ");
INSERT INTO srnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Den o taki: ‘A man disi bigin bow, ma a no man go doro.’ ");
INSERT INTO srnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wan tra eksempre. Efu wan kownu wani hari go miti wan tra kownu ini wan feti, dan a o sidon denki fosi efu nanga tin dusun srudati a o man go feti nanga a trawan, di abi tutenti dusun srudati. ");
INSERT INTO srnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Efu a si tak' a no man, dan a o seni wantu man fu go taki nanga a tra kownu gi en fu meki freide, te a tra kownu de moi fara ete. ");
INSERT INTO srnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","So, efu wan sma no man libi ala sani san a abi, a no man tron wan sma di e teki leri fu Mi.” ");
INSERT INTO srnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Dan Yesus taki: “Sowtu bun, ma efu sowtu lasi en tesi, fa yu o man gi en tesi baka? ");
INSERT INTO srnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A no bun gi a gron, èn a no bun gi a doti-ipi srefi. Den e fringi en trowe. Suma abi yesi fu yere, meki a yere!” ");
INSERT INTO srnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ala den man di e piki edemoni nanga den sondusma, ben e kon na Yesus fu arki san A e leri. ");
INSERT INTO srnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma den Fariseiman nanga den sabiman fu Gado wèt ben e knoru taki: “A man disi e meki den sondusma kon na En, èn A e nyan nanga den.” ");
INSERT INTO srnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dan Yesus gi den a agersitori disi. A taki: ");
INSERT INTO srnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Efu yu abi wan hondro skapu, èn wan fu den lasi, san yu o du? A no libi yu o libi den neigitenti-na-neigi (99) trawan ini a dreisabana, fu go suku a wan di lasi te leki yu feni en? ");
INSERT INTO srnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dan te yu feni en, yu o opo en nanga prisiri, poti na tapu yu skowru. ");
INSERT INTO srnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Te yu doro na oso, yu o kari ala den mati nanga den birtisma fu yu kon na wan, dan yu o taigi den taki: ‘Un prisiri nanga mi, bika mi feni a skapu fu mi di ben lasi.’ ");
INSERT INTO srnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","We, Mi e taigi un taki: Na so moro prisiri de na heimel fu a wan sondusma di drai en libi, dan fu den neigitenti-na-neigi bun sma di no abi fu drai den libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesus gi ete wan agersitori. A taki: “Efu wan uma abi tin solfrumoni, dan a lasi wan fu den, san a o du? A o leti wan lampu, sibi a oso, èn a o suku bun te leki a feni en. ");
INSERT INTO srnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te a feni en, a o kari den kompe nanga den birtisma fu en kon, dan a o taigi den taki: ‘Un prisiri nanga mi, bika mi feni a solfrumoni fu mi di ben lasi.’ ");
INSERT INTO srnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mi e taigi un taki: Na so den engel fu Gado e prisiri te wan sondusma drai en libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus taki moro fara: “Wan man ben abi tu boi. ");
INSERT INTO srnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A moro yongu wan taigi en p'pa taki: ‘P'pa, gi mi san mi mus kisi fu a gudu fu unu.’ Dan a p'pa prati a gudu fu en gi den tu boi. ");
INSERT INTO srnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wantu dei na baka, a moro yongu wan seri ala den sani teki a moni, dan a gwe na wan fara kondre. Drape a fermorsu ala en moni, fu di a ben libi wan yayolibi. ");
INSERT INTO srnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Di a kba fermorsu ala en moni, wan tranga angriten kon ini a kondre. A boi bigin pina, ");
INSERT INTO srnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","dan a go suku wroko. So a bigin wroko gi wan fu den sma fu a kondre. A sma dati seni en fu go luku den agu gi en na ini en gron. ");
INSERT INTO srnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Angri ben kiri a boi sote tak' a ben wani furu en bere nanga den buba san den agu ben e nyan, ma no wan sma no gi en. ");
INSERT INTO srnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Di a boi kisi ensrefi, a taki: ‘Mi p'pa abi someni wrokoman, èn den man dati abi bogobogo nyanyan. Ma mi e dede dya fu angri. ");
INSERT INTO srnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi o opo go baka na mi p'pa, dan mi o taigi en taki: P'pa, mi sondu na fesi Gado èn na fesi yu. ");
INSERT INTO srnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mi no warti fu de yu pikin moro. Teki mi leki wan fu den wrokoman fu yu.’ ");
INSERT INTO srnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Na so a boi opo, dan a drai go baka na en p'pa. A ben de fara ete di en p'pa si a e kon. Dan a p'pa firi sari gi en. A lon go miti a boi, a brasa en èn a bosi en. ");
INSERT INTO srnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dan a boi taigi en p'pa taki: ‘P'pa, mi sondu na fesi Gado èn na fesi yu. Mi no warti fu de yu pikin moro.’ ");
INSERT INTO srnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma a p'pa taigi den knekti fu en taki: ‘Un tyari a moro bun krosi kon es'esi dyaso, dan un weri en gi en. Un weri wan linga gi en na en finga, nanga susu na en futu. ");
INSERT INTO srnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Un go teki a pikin kaw san un ben kweki poti aparti, dan un srakti en meki un hori wan fesa. ");
INSERT INTO srnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bika a boi fu mi disi ben dede, ma now a e libi baka. A ben lasi, ma now mi feni en.’ Na so den bigin hori wan fesa. ");
INSERT INTO srnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","A pisten dati a moro bigi boi ben e wroko ini a gron. Di a kon krosbei fu a oso, a yere poku nanga dansi. ");
INSERT INTO srnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A kari wan fu den knekti kon, dan a aksi en taki: ‘San de fu du?’ ");
INSERT INTO srnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A piki en taki: ‘Yu brada kon baka na oso, èn yu p'pa meki den srakti a pikin kaw, bika a kisi en bunbun baka.’ ");
INSERT INTO srnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dan a brada ati bron. A no ben wani go na inisei. Dan en p'pa kon na dorosei kon aksi en tangitangi fu kon na inisei. ");
INSERT INTO srnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma a piki en p'pa taki: ‘Luku omeni yari mi wroko so tranga gi yu. Noiti mi no psa yu mofo. Ma noiti yu gi mi wan pikin bokoboko srefi fu mi hori wan fesa nanga den mati fu mi. ");
INSERT INTO srnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma a boi fu yu disi fermorsu yu gudu nanga den motyo. Dan di a kon baka, yu meki den srakti a pikin kaw gi en!’ ");
INSERT INTO srnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma a p'pa taigi en taki: ‘Mi boi, ala ten yu de nanga mi, èn ala sani fu mi, na fu yu tu. ");
INSERT INTO srnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma un ben musu fu hori wan fesa fu meki prisiri. Bika yu brada ben dede, ma now a e libi baka. A ben lasi, ma now mi feni en.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Dan Yesus gi den sma di ben e teki leri fu En wan agersitori. A taki: “Wan guduman ben abi wan man di ben e luku den gudu fu en. Dan a guduman kisi fu yere tak' a man ben e fermorsu en gudu. ");
INSERT INTO srnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A seni kari en, dan a taigi en taki: ‘San na den sani san mi e yere fu yu? Yu mus gi frantwortu fu san yu ben du nanga den gudu fu mi, bika yu no o luku den moro langa.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ne a man prakseri taki: ‘San mi mus du? Mi masra o puru a wroko na mi anu. Mi no man diki skopu, èn mi e syen fu go begi moni. ");
INSERT INTO srnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","We, mi sabi san mi o du fu den sma opo den oso gi mi te mi lasi mi wroko.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dan a seni kari ala den sma di mus pai en masra wan fru wan kon na en. A aksi a fosi wan taki: ‘Omeni yu mus pai mi masra?’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A man piki en taki: ‘Mi mus pai wan hondro bari oli.’ Dan a taigi a man taki: ‘Luku a papira dya san e sori omeni yu mus pai. Go sidon es'esi, dan yu skrifi tak' yu mus pai feifitenti bari oli.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Baka dati a aksi a di fu tu man taki: ‘Omeni yu mus pai mi masra?’ A man piki en taki: ‘Mi mus pai wan hondro saka aleisi.’ Dan a taigi a man dati taki: ‘Luku a papira dya san e sori omeni yu mus pai. Skrifi tak' yu mus pai aititenti saka aleisi.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","A man di ben luku den gudu, no du san bun, ma en masra prijse en fu a koni sani san a du. Na so a de. Den sma fu a grontapu disi e denki moro bun te den abi fu wroko nanga densrefi, moro den sma fu a leti. ");
INSERT INTO srnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Dat'ede Mi e taigi un taki: Du bun gi tra sma nanga den gudu fu grontapu. Bika te yu no o abi den sani dati moro, yu o abi wan oso fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Efu den kan fertrow yu nanga pikinpikin sani, dan den o man fertrow yu nanga bigi sani tu. Ma efu yu no de fu fertrow nanga pikinpikin sani, dan yu no o de fu fertrow nanga bigi sani tu. ");
INSERT INTO srnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","So, efu yu no ben de fu fertrow nanga grontapu gudu, dan suma sa fertrow yu nanga trutru gudu? ");
INSERT INTO srnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Èn efu yu no ben de fu fertrow nanga den sani fu wan tra sma, dan suma sa gi yu sani san de fu yu srefi? ");
INSERT INTO srnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wan knekti no kan wroko gi tu basi. Bika a sa hori a wan na ati, dan a lobi a trawan. Noso a sa lespeki a wan, ma a no o teri a trawan. Yu no kan dini Gado makandra nanga den gudu fu grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Di den Fariseiman yere san Yesus taki, den meki spotu nanga En, bika den ben lobi moni. ");
INSERT INTO srnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dan Yesus taigi den taki: “Un wani fu den sma si un leki sma di bun ini Gado ai, ma Gado sabi un ati. Bika san warti furu ini libisma ai, no warti noti gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses nanga den profeiti ben leri unu te leki Yohanes kon. Bigin fu a ten dati a Bun Nyunsu e preiki tak' Gado o tiri libisma, èn ala sma e du muiti fu kon ondro a tiri fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","We arki, a moro makriki fu broko heimel nanga grontapu, dan fu puru wan pikin pisi fu a wèt fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Iniwan man di broko trow nanga en frow, dan a trow nanga wan trawan, e libi wan huru libi. Èn efu wan man trow nanga wan frow di en masra broko trow nanga en, a e libi wan huru libi tu.” ");
INSERT INTO srnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus taki: “Yu ben abi wan guduman di ben e weri bun diri krosi, èn ala dei a ben e hori bigi fesa. ");
INSERT INTO srnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Èn yu ben abi wan pôtiman tu di ben nen Lasarus. A ben e didon na mofodoro fu a guduman oso, èn en heri skin ben lai nanga sorosoro. ");
INSERT INTO srnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A ben e angri fu furu en bere nanga san ben fadon fu a tafra fu a guduman. Te a ben e didon drape, den dagu ben e kon leki den soro fu en. ");
INSERT INTO srnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Baka wan pisten a pôtiman kon dede, dan den engel tyari en go na Abraham sei. A guduman dede tu, dan den beri en. ");
INSERT INTO srnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","A ben e nyan hebi pina na ini dedekondre. Di a opo en ai luku, a si Abraham farawe nanga Lasarus na en sei. ");
INSERT INTO srnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dan a bari gi Abraham taki: ‘Papa Abraham, sari mi! Seni Lasarus fu a go dopu en finga na ini pikin watra fu kon kowru mi tongo. Bika mi e nyan tumsi pen na ini a faya disi.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ma Abraham piki en taki: ‘Mi boi, memre tak' di yu ben e libi na grontapu yu ben abi en bun. Ma na soso ogri ben e miti Lasarus. Now Lasarus e kisi trowstu dyaso, èn yu e nyan pen. ");
INSERT INTO srnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Boiti dati, wan dipi olo e prati wi nanga unu. So awinsi un ben sa wani, no wan fasi no de fu wi kon na dat' sei. Èn unu fu dat' sei no man kon na wi.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Dan a guduman taki: ‘Papa, dan mi e begi yu fu seni Lasarus go na mi p'pa oso. ");
INSERT INTO srnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mi abi feifi brada. Meki a go warskow den bun, fu den no kon pina dya tu.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma Abraham taigi en taki: ‘Den brada fu yu abi den buku fu Moses nanga den profeiti. Meki den arki san den e taki.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma a man piki taki: ‘Nono, papa Abraham. Ma efu wan sma di dede kba go warskow den, den o drai den libi.’ ");
INSERT INTO srnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma Abraham taki: ‘Efu den no e arki Moses nanga den profeiti, dan den no o arki wan tra sma, awinsi a kon baka na libi.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus taigi den sma di e teki leri fu En taki: “Ala ten yu o abi sani san o wani meki yu du sondu. Ma a sma di e tyari den sani dati kon, mus luku bun! ");
INSERT INTO srnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A bo moro bun gi en efu den tai wan bigi ston na en neki èn fringi en go na ini a se, prefu a kori wan fu den pikinwan disi fu meki a sondu. ");
INSERT INTO srnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","So luku bun san yu e du! Efu yu brada sondu, bari en. Efu a sari fu san a du, yu mus gi en pardon. ");
INSERT INTO srnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Awinsi na seibi leisi ini wan dei a du yu wan sani, dan a kon taigi yu ala den seibi leisi tak' a e sari fu san a du, yu mus gi en pardon.” ");
INSERT INTO srnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dan den boskopuman fu Yesus taigi En taki: “Masra, gi un moro bribi.” ");
INSERT INTO srnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Masra piki den taki: “Efu a bribi fu unu ben bigi leki wan mosterdsiri nomo, un ben kan taigi a bon disi taki: ‘Rutu yusrefi puru, dan yu prani yusrefi ini a se.’ Èn a bo du san yu taki.” ");
INSERT INTO srnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kon un taki wan fu unu abi wan knekti di e wroko gron noso e luku skapu. Te a kon na oso, yu no e taigi en fu a kon nyan wantron. ");
INSERT INTO srnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nono, ma yu e taigi en taki: ‘Seti yu krosi fu wroko, bori mi nyanyan, dan yu tyari en kon gi mi. Te mi kba nyan nanga dringi, dan fosi yu kan go nyan nanga dringi.’ ");
INSERT INTO srnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yu prakseri tak' yu o abi fu taki a knekti tangi fu di a du san a ben mus du? Nono. ");
INSERT INTO srnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","We, na so un mus de tu. Baka te un du ala sani san den taigi un fu du, un mus taki: ‘Wi na knekti nomo di no warti noti. Na du un du san un ben mus fu du.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Di Yesus ben de na pasi fu go na Yerusalem, A waka psa ini den distrikti Galilea nanga Samaria. ");
INSERT INTO srnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dan di A doro na ini wan fu den dorpu, A si tin gwasiman di ben e waka miti En. Den man disi tan tnapu farawe, ");
INSERT INTO srnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dan den bari taki: “Yesus, Meister, abi sari-ati nanga unu!” ");
INSERT INTO srnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus luku den, dan A taki: “Go na den Dyudomri, meki den luku unu.” Di den man de na pasi e gwe, den kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Di wan fu den si tak' a kon betre, a drai kon baka èn nanga tranga sten a gi Gado grani. ");
INSERT INTO srnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A trowe ensrefi langalanga na gron na Yesus futu èn a taki En tangi. Ma a man disi ben de wan sma fu Samaria. ");
INSERT INTO srnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dan Yesus taki: “A no ala tin man kon betre? Pe den tra neigi de? ");
INSERT INTO srnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","A man disi a no wan Dyu. Fa a kan tak' na en wawan drai kon baka fu gi Gado grani?” ");
INSERT INTO srnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dan Yesus taigi a man taki: “Opo, dan yu gwe. A bribi fu yu meki yu kon betre.” ");
INSERT INTO srnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Den Fariseiman aksi Yesus oten Gado o bigin tiri libisma. Dan Yesus piki den taki: “Te Gado o bigin tiri libisma, no wan marki o de fu si na fesi. ");
INSERT INTO srnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yu no o man taki: ‘Luku en dyaso,’ noso: ‘Luku en drape.’ Bika a tiri fu Gado de let' dya na un mindri.” ");
INSERT INTO srnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dan A taigi den sma di e teki leri fu En taki: “Wan ten o kon pe un o angri fu si wan fu den dei fu a Manpikin fu Libisma. Ma un no o si en. ");
INSERT INTO srnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sma o taigi unu taki: ‘Luku En drape,’ noso: ‘Luku En dyaso.’ No go luku, èn no waka na den baka. ");
INSERT INTO srnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bika leki fa faya e koti èn a de fu si fu a wan sei fu heimel go te na a tra sei, na so a Manpikin fu Libisma o de te A e drai kon baka. ");
INSERT INTO srnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma fosi a sani dati psa, A mus nyan furu pina, èn den sma fu a ten disi o poti En na wan sei. ");
INSERT INTO srnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Soleki fa a ben de ini a ten fu Noa, na so a sa de te a Manpikin fu Libisma o drai kon baka. ");
INSERT INTO srnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ini den dei dati den sma ben e nyan, den ben e dringi èn trow ben e trow, te leki a dei di Noa go ini a bigi sipi. Dan a bigi frudu kon, èn a kiri ala den sma dati. ");
INSERT INTO srnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na so a ben de tu ini a ten di Lot ben e libi. Den sma ben e nyan èn den ben e dringi. Den ben e bai èn seri sani. Den ben e prani èn den ben e bow oso. ");
INSERT INTO srnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma a dei di Lot gwe libi Sodom, faya nanga kroiti fadon kmopo fu heimel leki alen èn a kiri ala den sma. ");
INSERT INTO srnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na so a o de te a Manpikin fu Libisma o drai kon baka fu ala sma si En. ");
INSERT INTO srnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tapu a dei dati a sma di de tapu a daki fu en oso, no mus saka go na gron fu teki sani ini en oso. Sosrefi a sma di de ini en gron, no mus drai go baka na en oso. ");
INSERT INTO srnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Un prakseri san psa nanga a frow fu Lot! ");
INSERT INTO srnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","A sma di e suku fu hori en libi, o lasi en. Ma a sma di e poti en libi na wan sei, o kisi en baka. ");
INSERT INTO srnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mi e taigi un taki: A neti dati tu sma o didon tapu wan bedi. Wan den o tyari gwe, èn a trawan o tan na baka. ");
INSERT INTO srnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tu frow o de na den miri e mara. Wan den o tyari gwe, èn a trawan o tan na baka. ");
INSERT INTO srnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tu man o de ini wan gron e wroko. Wan den o tyari gwe, èn a trawan o tan na baka.” ");
INSERT INTO srnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dan den man aksi Yesus taki: “Masra, pe den sani disi o psa?” Yesus piki den taki: “Pe a dedeskin didon, na drape yu e si tingifowru.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dan Yesus gi den sma fu En wan agersitori fu den kan ferstan tak' den mus tan begi sondro fu lasi ati. ");
INSERT INTO srnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A taki: “Yu ben abi wan krutubakra ini wan foto di no ben abi lespeki gi Gado, èn di no ben abi bisi nanga no wan sma. ");
INSERT INTO srnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ini a srefi foto dati wan frow ben e libi di en masra ben dede kba. Ala yuru a frow disi ben e go taigi a krutubakra taki: ‘Gi mi a leti san mi mus kisi tapu a sma di du kruktu nanga mi.’ ");
INSERT INTO srnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wan heri pisten a krutubakra no ben wani du dati. Ma bakaten a prakseri taki: ‘Mi no abi lespeki gi Gado, èn mi no abi bisi nanga no wan sma. ");
INSERT INTO srnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ma a frow disi e ferferi mi. Dat' meki mi o gi en leti, noso a o kon naki mi ini mi fesi.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dan Masra aksi den taki: “Un yere san a kruktu krutubakra disi taki? ");
INSERT INTO srnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","We, un denki tak' Gado no sa gi leti na den sma di A teki gi Ensrefi èn di e begi En dei nanga neti fu A yepi den? Un denki tak' A o meki den wakti? ");
INSERT INTO srnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi e taigi un taki: A o gi den leti her'esi. Ma te a Manpikin fu Libisma drai kon baka na grontapu, yu prakseri tak' A sa feni sma di e bribi trutru?” ");
INSERT INTO srnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Dan Yesus gi ete wan agersitori. A disi ben de gi den sma di ben prakseri fu densrefi tak' den bun ini Gado ai, èn di ben si tra sma leki noti. Yesus taki: ");
INSERT INTO srnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tu sma ben go na ini a mamakerki fu go begi. A wan ben de wan Fariseiman, a trawan ben de wan man di e piki edemoni. ");
INSERT INTO srnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A Fariseiman go tnapu e begi ini ensrefi. A taki: ‘Mi Gado, mi e taki Yu grantangi tak' mi no de leki den tra sma. Mi no e fufuru, mi no e libi kruktu, èn mi no e huru. Mi e taki Yu grantangi tu tak' mi no de leki a man drape di e piki edemoni. ");
INSERT INTO srnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tu leisi ini wan wiki mi e faste, èn fu ala sani san mi e kisi, mi e gi Yu tin prosenti.’ ");
INSERT INTO srnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ma a man di e piki edemoni ben tan tnapu fara, èn a no ben wani opo en ai luku go na heimel. Bika a hati en tak' a ben sondu. A taki: ‘Tye, mi Gado, abi sari-ati nanga mi, bika mi na wan sondusma.’ ");
INSERT INTO srnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mi e taigi un taki: Di a man disi drai go baka na oso, a ben kon bun ini Gado ai. Ma disi no psa nanga a trawan. Bika a sma di e opo ensrefi, Gado o broko en saka. Ma a sma di e saka ensrefi, Gado o opo en.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Den sma ben e tyari den pikin kon na Yesus, fu A fasi den. Di den man fu Yesus si san den sma e du, den bari den. ");
INSERT INTO srnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma Yesus kari den pikin kon na En. A taki: “Meki den pikin kon na Mi. No tapu den, bika na sma leki den pikin disi, Gado e tiri. ");
INSERT INTO srnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Fu tru Mi e taigi un taki: Efu yu no kon na Gado leki wan pikin fu A tiri yu, dan noiti yu o man kon ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Dan wan edeman fu den Dyu aksi Yesus taki: “Bun Meister, san mi mus du fu kisi a libi fu têgo?” ");
INSERT INTO srnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus piki en taki: “Fu sanede yu e taki tak' Mi bun? No wan sma bun, boiti Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yu srefi sabi san a wèt e taki: Yu no mus huru, yu no mus kiri, yu no mus fufuru, yu no mus lei gi trawan, èn yu mus lespeki yu m'ma nanga yu p'pa.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A man piki En taki: “Sensi mi pikin mi hori ala den wèt disi.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Di Yesus yere san a man taki, A taigi en taki: “Wan sani libi ete fu yu du. Seri ala sani san yu abi, dan yu e prati a moni gi den pôtisma. So yu o abi wan gudu na heimel. Baka dati yu e kon waka na Mi baka.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma di a man yere san Yesus taki, a firi tumsi sari, bika a ben gudu psa marki. ");
INSERT INTO srnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Di Yesus si dati, A taki: “A tranga gi sma di lai moni fu den poti densrefi ondro a tiri fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bika a moro makriki gi wan asaw fu psa ini wan nanai-olo, dan fu wan guduman poti ensrefi ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Den sma di yere san Yesus taki, aksi En taki: “Suma Gado o man ferlusu dan?” ");
INSERT INTO srnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus piki taki: “San libisma no man du, Gado kan du.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dan Petrus taki: “Luku, wi libi ala sani san wi ben abi fu waka na Yu baka.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus piki den taki: “Fu tru Mi e taigi un taki: Gado o pai ala sma di libi en oso, noso en frow noso en brada, den bigisma fu en noso en pikin, nomo fu meki tak' Gado kon tiri libisma. ");
INSERT INTO srnNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Gado o pai en someni tron moro furu na ini a libi disi. Èn ini a ten san e kon, A o gi en a libi fu têgo.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus kari den twarfu man fu En kon na wan sei, dan A taigi den taki: “Luku, un de na pasi fu go na Yerusalem. Ala sani san den profeiti ben skrifi tak' o psa nanga a Manpikin fu Libisma, o psa tu. ");
INSERT INTO srnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bika den o gi En abra na den sma di no de Dyu. Den o teki En leki spot'popki, den o kosi En, èn den o spiti na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Den o wipi En, dan den o kiri En. Ma tapu a di fu dri dei, A o kon baka na libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma den man no ben ferstan noti fu san Yesus taki. A ben dangra den, èn den no ben sabi fu san A ben taki. ");
INSERT INTO srnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","A ten di Yesus doro krosbei fu Yeriko, wan breniman ben sidon sei a pasi e begi moni. ");
INSERT INTO srnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Di a man yere wan bigi grupu sma e psa, a aksi san de fu du. ");
INSERT INTO srnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Den sma taigi en taki: “Yesus fu Nasaret e psa.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dan a man bari taki: “Yesus, Manpikin fu David, abi sari-ati nanga mi!” ");
INSERT INTO srnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Den sma di ben waka na fes'sei bari en fu a tapu en mofo. Ma a bigin bari moro tranga taki: “Yesus, Manpikin fu David, abi sari-ati nanga mi!” ");
INSERT INTO srnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ne Yesus tan tnapu dan A meki den tyari a man kon na En. Di a man kon krosbei, ");
INSERT INTO srnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Yesus aksi en taki: “San yu wani tak' Mi mus du gi yu?” A man piki taki: “Masra, mi wani si.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus piki en taki: “Yu sa si. A bribi fu yu meki yu kon betre.” ");
INSERT INTO srnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wantron a man bigin si, dan a bigin waka baka Yesus e gi Gado grani. Di ala den sma si san psa, den prijse Gado. ");
INSERT INTO srnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Dan Yesus waka go moro fara èn a psa ini a foto Yeriko. ");
INSERT INTO srnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Now yu ben abi wan man di ben nen Sakeus. Sakeus ben de a edeman fu den man di e piki edemoni, èn a ben gudu. ");
INSERT INTO srnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A ben meki muiti fu si suma na Yesus, ma a no ben man si En fu di a ben syatu èn den sma ben furu. ");
INSERT INTO srnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","So Sakeus lon go na fesi, dan a kren go na ini wan werder figabon fu a kan si Yesus te A bo psa drape. ");
INSERT INTO srnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Di Yesus doro drape A luku go ini a bon, dan a taigi Sakeus taki: “Sakeus, saka kon es'esi na gron, bika tide Mi mus tan na yu oso.” ");
INSERT INTO srnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeus saka es'esi kmopo ini a bon, èn nanga prisiri a meki Yesus kon na ini en oso. ");
INSERT INTO srnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma di den sma si dati, den bigin krut'krutu. Den taki: “A go tan na ini a oso fu wan sondusma.” ");
INSERT INTO srnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma Sakeus opo tnapu dan a taigi Masra taki: “Masra, yere. Afu fu san mi abi, mi o gi den pôtisma. Èn efu mi ben puru wan sani na wan sma anu nanga tranga, dan mi sa gi en fo tron so furu baka.” ");
INSERT INTO srnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dan Yesus taigi en taki: “Tide Gado ferlusu den sma fu a oso disi, fu di a man disi na wan bakapikin fu Abraham tu. ");
INSERT INTO srnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bika A Manpikin fu Libisma kon fu suku den sma di e go lasi, èn fu ferlusu den.” ");
INSERT INTO srnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Di den sma ben e arki san Yesus e taki, A gi den wan agersitori tu. Bika A ben de krosbei fu Yerusalem, èn den sma ben e prakseri tak' na nownow so Gado bo bigin tiri libisma. ");
INSERT INTO srnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A taki: “Wan man fu wan prenspari famiri ben go na wan farawe kondre fu den meki a tron kownu. Baka dati a bo drai kon baka na en kondre. ");
INSERT INTO srnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Fosi a gwe, a kari tin fu den knekti fu en kon, dan a gi den alamala wan moni. A taigi den taki: ‘Un wroko nanga a moni disi te leki mi kon baka.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ma den sma fu a kondre fu en no ben lobi en. Dat' meki den seni boskopu go na a tra kondre tak' den no wani a man disi leki den kownu. ");
INSERT INTO srnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Di a man tron kownu, a drai kon baka na en kondre. Dan a seni kari den knekti kon di a ben gi a moni. A ben wani sabi san den ben du nanga a moni san a ben gi den fu wroko. ");
INSERT INTO srnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A fosi wan kon, dan a taki: ‘Masra, yu gi mi wan moni. Mi wroko nanga en, èn a meki tin moro.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A kownu piki en taki: ‘Moi so, yu na wan bun knekti. Fu di yu ben wroko bun nanga a pikinso san mi gi yu, mi e gi yu makti abra tin foto.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dan a di fu tu knekti kon. A taki: ‘Masra, yu gi mi wan moni. Mi wroko nanga en, èn a meki feifi moro.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A kownu taigi en taki: ‘Dan yu o tiri feifi foto.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dan wan tra knekti kon. A taki: ‘Masra, luku a moni fu yu dya. Mi ben tai en ini wan saka-anyisa, dan mi kibri en. ");
INSERT INTO srnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bika mi ben frede fu yu, fu di yu na wan sma di no e meki spotu. Yu e puru san yu no poti, èn yu e koti san yu no prani.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dan a kownu piki en taki: ‘Yu takru knekti yu! Yu eigi mofo o strafu yu. Yu ben sabi tak' mi no e meki spotu. Yu sabi tak' mi e puru san mi no poti, èn tak' mi e koti san mi no prani. ");
INSERT INTO srnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","We, dan fu sanede yu no go poti mi moni na bangi? Dan te mi ben kon baka, mi ben kan go teki en nanga san kon na en tapu.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dan a kownu taigi den tra man di ben e tnapu drape taki: ‘Un puru a moni na en anu, dan un gi a man di abi den tin.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Den man piki kownu taki: ‘Masra, a abi tin kba!’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A kownu taki: ‘Mi e taigi un taki: Ala sma di abi, o kisi moro. Ma a sma di no abi, awinsi san a abi, den o puru na en anu.’ ");
INSERT INTO srnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dan a taki moro fara: ‘Un tyari den sma kon dya di no ben wani mi leki den kownu, dan un kiri den let' na mi fesi.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Di Yesus kba taki a sani disi, A waka na den fesi fu go na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dan di A doro krosbei fu den dorpu Betfaga nanga Betania, ini a birti fu a Oleifbergi, A seni tu fu den man fu En go na fesi. ");
INSERT INTO srnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","A taigi den taki: “Un go na a dorpu san de na un fesi. Te un doro ini a dorpu, un o si wan yongu buriki san den sma tai drape. Noiti ete wan sma ben sidon na en tapu. Un lusu en, dan un tyari en kon gi Mi. ");
INSERT INTO srnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Efu wan sma sa aksi un fu sanede un e lusu a buriki, un mus taki: ‘Masra abi en fanowdu.’ ” ");
INSERT INTO srnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Den tu man gwe, dan den feni a yongu buriki soleki fa Yesus taki. ");
INSERT INTO srnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Di den ben e lusu a buriki, den sma di ben abi en aksi den taki: “Fu sanede un e lusu a buriki?” ");
INSERT INTO srnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Den piki taki: “Masra abi en fanowdu.” ");
INSERT INTO srnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dan den tyari en go gi Yesus. Den bradi den krosi na tapu a buriki, dan den yepi Yesus kren go sidon na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Di A e rei gwe moro fara, den sma bradi den krosi tapu a pasi gi En. ");
INSERT INTO srnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Di A doro krosbei fu Yerusalem pe A ben mus saka a Oleifbergi, dan a bigi grupu sma di ben e teki leri fu En, bigin prisiri. Den prijse Gado nanga tranga sten fu ala den bigi sani san den si. ");
INSERT INTO srnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Den taki: Blesi de tapu a Kownu di e kon ini a nen fu Masra! Freide de na heimel. Gado mus kisi ala glori! ");
INSERT INTO srnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wantu Fariseiman di ben de na mindri a bigi grupu sma, taigi Yesus taki: “Meister, bari den sma fu Yu fu den hori den mofo!” ");
INSERT INTO srnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma A piki den taki: “Fu tru Mi e taigi unu: Efu den sma disi hori den mofo, den ston o bari a srefi sani.” ");
INSERT INTO srnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Di Yesus doro moro krosbei tak' A ben kan si a foto Yerusalem, A bigin krei gi en. ");
INSERT INTO srnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A taki: “Tye, un sma fu Yerusalem. Mi winsi tak' tide ete un ben kan ferstan san e tyari freide kon mindri unu nanga Gado! Ma now a kibri gi unu. ");
INSERT INTO srnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wan ten o kon pe den feyanti fu unu o lontu unu. Den o tapu unu fu ala sei, meki no wan sma no man go ini a foto noso kmopo na ini. ");
INSERT INTO srnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Den o figi unu nanga den pikin fu unu puru na grontapu. No wan ston o tan na tapu wan trawan, bika un no ben sabi a ten di Gado ben wani yepi unu.” ");
INSERT INTO srnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Di Yesus doro na Yerusalem, A go na ini a mamakerki dan A bigin yagi ala den sma gwe di ben e seri sani drape. ");
INSERT INTO srnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","A taigi den taki: “A skrifi taki: ‘Mi oso mus de wan presi fu begi.’ Ma unu meki a tron wan nesi fu fufuruman.” ");
INSERT INTO srnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ala dei Yesus ben e gi leri na ini a mamakerki. Den prenspari domri, den sabiman fu Gado wèt nanga den fesiman fu a folku, ben e suku wan fasi fu kiri En. ");
INSERT INTO srnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma den no ben man feni no wan fasi, bika nanga opo mofo a heri folku ben e arki san A ben e leri. ");
INSERT INTO srnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yesus ben e gi sma leri na ini a mamakerki, èn A ben e ferteri den a Bun Nyunsu. Wan fu den dei dati den prenspari domri, den sabiman fu Gado wèt nanga den fesiman fu a folku, kon na En. ");
INSERT INTO srnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Den aksi En taki: “Taigi unu, pe Yu feni a leti fu du den sani san Yu e du? Suma gi Yu a makti fu du den sani disi?” ");
INSERT INTO srnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A piki den taki: “Mi wani aksi un wan sani tu. Un taigi Mi: ");
INSERT INTO srnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Suma ben gi Yohanes a makti fu dopu sma? Gado noso libisma?” ");
INSERT INTO srnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dan den man taki a tori nanga makandra. Den taki: “Efu un taki: ‘Na Gado,’ dan A o aksi unu: ‘Fu sanede un no ben bribi en dan?’ ");
INSERT INTO srnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma efu un taki: ‘Na libisma,’ dan a heri folku o ston un kiri. Bika den e bribi tak' Yohanes ben de wan profeiti.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","So den piki taki: “Wi no sabi suma gi en a makti.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ne Yesus taigi den taki: “We, dan Mi srefi no o taigi unu pe Mi feni a leti fu du den sani san Mi e du.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dan Yesus ferteri a folku wan agersitori. A taki: “Wan man ben prani droifibon na ini en gron. A yuru a droifidyari gi tra sma, dan a gwe wan heri pisten na wan tra kondre. ");
INSERT INTO srnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Di a ten doro fu piki den droifi, a seni wan knekti go na den man di yuru a droifidyari, fu den gi en den droifi san en masra ben mus kisi. Ma den man fon en, dan den seni en gwe nanga soso anu. ");
INSERT INTO srnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dan a man di abi a droifidyari seni wan tra knekti go, ma den man fon a knekti disi tu. Den teki en leki wan figifutu, dan den seni en gwe nanga soso anu. ");
INSERT INTO srnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dan a man seni ete wan knekti go, a di fu dri. Ma den man gi a knekti disi mankeri, dan den srepi en puru ini a droifidyari. ");
INSERT INTO srnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dan a man di abi a droifidyari aksi ensrefi taki: ‘San mi mus du now? We, mi o seni a manpikin fu mi go, di mi lobi. Den no sa du den sani dati nanga en.’ ");
INSERT INTO srnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ma di den man di ben yuru a gron si a manpikin, den taigi makandra taki: ‘Na a boi disi o kisi a gron te en p'pa dede. Kon meki un kiri en, dan unu o kisi a gron.’ ");
INSERT INTO srnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","So den srepi a manpikin go na dorosei fu a droifidyari, dan den kiri en.” Dan Yesus aksi den sma taki: “San un e prakseri tak' a man di abi a droifidyari o du nanga den man? ");
INSERT INTO srnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mi e taigi unu: A o kon kiri den man di ben yuru a droifidyari, dan a o yuru en gi tra sma.” Di den sma yere a sani disi, den taki: “Disi no musu psa, kwet'kweti!” ");
INSERT INTO srnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma Yesus luku den, dan A taki: “A skrifi taki: A ston di den mesreman feni tak' no bun, na a srefi ston dati tron a moro prenspari ston fu a heri oso. San a sani disi wani taki?” ");
INSERT INTO srnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dan Yesus taki moro fara: “Ala sma di fadon tapu a ston disi, o broko ala den bonyo. Èn efu a ston disi fadon na tapu wan sma, a o masi en tron wan doni.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Den sabiman fu Gado wèt nanga den prenspari domri ben kon ferstan tak' na gi den A koti wan odo nanga a agersitori disi. Dat' meki den ben wani grabu En a srefi yuru dati, ma den ben frede a folku. ");
INSERT INTO srnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dan so den seti luru gi Yesus. Den seni sma fu go luku efu Yesus bo taki wan sani san no fiti, fu den kan gi En abra na ini anu fu a granman. Den man disi ben mus du leki den na sma di e libi leki fa Gado wani. ");
INSERT INTO srnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dan den man taigi Yesus taki: “Meister, un sabi tak' den sani san Yu e taki, nanga san Yu e leri, na tru sani. Yu no e wroko nanga fesi, ma Yu e leri unu a pasi fu Gado leki fa a de. ");
INSERT INTO srnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ma un wani aksi Yu wan sani: A fiti fu pai edemoni na a grankownu fu den Romeinisma, efu no?” ");
INSERT INTO srnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma Yesus si tak' na fasi den ben wani fasi En. Dat' meki A taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kon meki Mi si wan moni. Suma fesi nanga suma nen de na en tapu?” Den piki En taki: “A di fu a grankownu.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ne Yesus piki den taki: “Dan un gi a grankownu san na fu en, èn un gi Gado san na fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","So den man no ben man kisi Yesus fu A taki wan sani san no bun, fu a folku yere. Dan den hori den mofo, bika den ben ferwondru fu a fasi fa A piki den. ");
INSERT INTO srnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wantu Saduseiman kon na Yesus fu aksi En wan sani. Den man disi no ben e bribi tak' dedesma o kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Den taki: “Meister, Moses ben skrifi tak' efu wan man di abi wan brada trow, èn a dede sondro fu a kisi wan pikin, dan en brada mus trow nanga a frow fu meki pikin gi en brada di dede. ");
INSERT INTO srnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Now seibi brada ben de. A fosi wan trow, ma a dede sondro fu libi wan pikin na baka. ");
INSERT INTO srnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dan a brada di waka na en baka trow nanga a frow, ");
INSERT INTO srnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","dan a di fu dri, te leki ala den seibi brada ben trow nanga en. Ma den alamala dede sondro fu kisi wan pikin. ");
INSERT INTO srnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Te fu kba, a frow srefi kon dede.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Dan den aksi Yesus taki: “Te den dedesma o kon na libi baka, sortu wan fu den brada sa abi a frow disi leki en trow-uma? Bika ala seibi man ben trow nanga en.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus piki den taki: “Den sma fu a ten disi e trow nanga makandra. ");
INSERT INTO srnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma den sma di Gado feni warti fu opo baka na dede, èn libi ini a ten di e kon, no o trow nanga makandra. ");
INSERT INTO srnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Den no o dede moro, bika den o de leki den engel. Den o de pikin fu Gado, fu di den kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses srefi sori krinkrin tak' dedesma o kon baka na libi. Ini a tori fu a pikin bon di ben teki faya sondro fu bron, Moses kari Gado: a Gado fu Abraham, Isak, nanga Yakob. ");
INSERT INTO srnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ini Gado ai, den sma dati e libi. So un e si tak' Gado a no Gado fu dedesma, ma fu sma di e libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dan wantu fu den sabiman fu Gado wèt taigi Yesus taki: “Meister, Yu piki bun.” ");
INSERT INTO srnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Èn den no ben prefuru moro fu aksi En wan sani. ");
INSERT INTO srnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Dan Yesus aksi den sma taki: “Fa den sma kan taki tak' a Mesias na wan bakapikin fu kownu David? ");
INSERT INTO srnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bika David srefi skrifi ini wan fu den Psalm taki: Masra Gado taigi mi Masra taki: Kon sidon na Mi let'anu sei, ");
INSERT INTO srnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","te leki Mi meki den feyanti fu Yu tron Yu futubangi. ");
INSERT INTO srnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","We, efu David kari a Mesias en Masra, dan fa A kan de en bakapikin dan?” ");
INSERT INTO srnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A ten di a heri folku ben e arki san A e taki, Yesus taigi den sma di e teki leri fu En taki: ");
INSERT INTO srnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Un mus luku bun nanga den sabiman fu Gado wèt. Den lobi fu weri langa krosi e koiri, èn den lobi te sma e gi den lespeki odi na wowoyo. Den lobi fu sidon na den moro bun presi ini den kerki, èn den wani sidon na den moro prenspari presi te den go nyan na sma oso. ");
INSERT INTO srnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Den e puru den oso na a anu fu den uma di masra dede kba, dan den e begi langabere begi fu sma denki tak' den bun. Dat' meki a strafu fu den o moro hebi.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Di Yesus opo En ede luku, A si den guduman e poti moni ini a kisi pe yu e poti moni gi a mamakerki. ");
INSERT INTO srnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A si tu wan pôti frow di en masra dede kba, poti tu kopromoni ini a kisi. ");
INSERT INTO srnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dan Yesus taki: “Fu tru Mi e taigi un taki: A pôti frow disi poti moro furu moni ini a kisi moro ala den tra sma. ");
INSERT INTO srnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bika ala den tra sma poti pikinso fu a furu moni san den abi, ma a frow disi poti ala fu a pikinso san a ben abi fu sorgu gi ensrefi.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wantu sma ben taki fa a mamakerki ben meki nanga moi ston èn fa sma ben gi ala sortu sani fu moimoi a mamakerki. Dan Yesus taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Wan ten o kon tak' ala den sani san un e si dya, o broko te na gron. No wan ston o tan na tapu wan trawan.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dan den sma aksi En taki: “Meister, oten dati o psa? San o de a marki di o sori tak' den sani disi de fu psa?” ");
INSERT INTO srnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus piki den taki: “Un mus luku bun tak' un no meki sma kori unu! Bika furu sma o du leki den na Mi. Den o taki tak' den na a Mesias, èn tak' a ten de krosbei. Ma un no mus waka na den baka! ");
INSERT INTO srnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Te un sa yere tak' kondre e feti èn tak' dyugudyugu de, un no mus frede, bika den sani disi mus fu psa fosi. Ma dati no wani taki tak' na a kba doro.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dan Yesus taki moro fara: “A wan folku o feti nanga a tra folku, èn a wan kondre o feti nanga a trawan. ");
INSERT INTO srnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A gron o seki bun hebi, èn ini difrenti presi ala sortu takru siki nanga angriten o de. Frede sani nanga bigi ferwondru marki o de fu si na heimel. ");
INSERT INTO srnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma fosi den sani disi psa, den sma o grabu unu. Den o de na un baka nomonomo fu du un ogri. Den o krutu unu na ini den kerki fu den èn den o poti unu na ini straf'oso. Den o srepi unu go te na fesi kownu nanga granman fu Mi ede. ");
INSERT INTO srnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma dati o de wan okasi gi unu fu ferteri den fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","So un no abi fu seti unsrefi na fesi, fu prakseri san un mus taki fu yepi unsrefi. ");
INSERT INTO srnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bika Mi o gi un koni nanga den wortu fu taki, èn no wan fu den sma di e feti unu, o man piki na tapu san un taki, noso taki tak' a no de so. ");
INSERT INTO srnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Un eigi m'ma nanga p'pa, un brada nanga den tra famiri fu unu, nanga un mati, o gi un abra, dan den o kiri sonwan fu unu. ");
INSERT INTO srnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Fu Mi ede no wan sma no o man si un na ai. ");
INSERT INTO srnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma no wan edewiwiri fu yu srefi no o lasi. ");
INSERT INTO srnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Hori doro! Bika sowan fasi un o kibri un libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Te un si tak' srudati lontu Yerusalem, dan un mus sabi tak' a yuru fu a foto broko te na gron de krosbei. ");
INSERT INTO srnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dan den sma di de ini Yudea, mus lon go na den bergi. Den sma di de ini a foto, mus lowe kmopo na ini, èn den sma di de ini den gron, no mus drai go ini a foto. ");
INSERT INTO srnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bika ini den dei dati Gado o puru En atibron na tapu den sma, meki ala sani san den profeiti skrifi kon psa. ");
INSERT INTO srnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Den uma di de nanga bere, nanga den di abi pikin na bobi a pisten dati, o de fu sari. Bika bigi nowtu o de ini a kondre èn Gado o puru En atibron tapu a folku disi. ");
INSERT INTO srnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Den o kiri den nanga owru, èn den o kisi den tyari gwe na den kondre fu ala den tra folku. Dan sma di no de Dyu o du san den wani na ini Yerusalem, te leki a yuru doro fu den srefi kisi strafu.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Marki o de fu si na a son, a munkenki, nanga den stari. A fasi fa den hei skwala fu a se o bari, o meki den sma fu grontapu frede sote tak' den no sabi san fu du. ");
INSERT INTO srnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Soso frede fu den sani san o psa na grontapu, o meki den sma lasi ati. Bika ala den makti di de na loktu o seki. ");
INSERT INTO srnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dan den sma o si a Manpikin fu Libisma e kon na tapu wan wolku nanga krakti nanga glori. ");
INSERT INTO srnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Te den sani disi bigin fu psa, dan un mus opo tnapu èn opo un ede luku go na loktu. Bika a ten fu Gado ferlusu unu de krosbei.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dan Yesus gi den wan agersitori. A taki: “Un mus luku den figabon nanga ala den tra bon. ");
INSERT INTO srnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Te un e si tak' den bon e bigin gi nyun wiwiri, dan un sabi tak' a dreiten de fu kon. ");
INSERT INTO srnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na so un mus sabi tu tak' te den sani san Mi taigi unu e bigin fu psa, dan a yuru fu Gado tiri libisma de krosbei. ");
INSERT INTO srnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Fu tru Mi e taigi un taki: Ala den sani disi o psa te den sma fu a ten disi de na libi ete. ");
INSERT INTO srnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wan dei heimel nanga grontapu no o de moro, ma den sani san Mi taki, o tan fu têgo.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Un mus de na ai. No furu un prakseri nanga fesa nanga sopi. No broko un ede nanga fa un o sorgu gi unsrefi. Un mus de na ai, fu a dei te Mi o kon baka, no tapu unu leki wan krafana. ");
INSERT INTO srnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bika a dei dati o kon gi ala sma na heri grontapu. ");
INSERT INTO srnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dat' meki un mus de na ai ala ten. Un mus begi fu un kan kmopo na ini den sani san o psa, èn fu un man tnapu na fesi a Manpikin fu Libisma.” ");
INSERT INTO srnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Deiten Yesus ben e gi leri na ini a mamakerki. Ma te neti A ben e go na tapu a Oleifbergi, dorosei fu a foto. ");
INSERT INTO srnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Fruku mamanten a heri folku ben e kon na Yesus na ini a mamakerki fu arki san A e leri. ");
INSERT INTO srnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A fesa pe den e nyan brede san meki sondro dyesi, ben de krosbei. A fesa dati den e kari Paska. ");
INSERT INTO srnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Den prenspari domri nanga den sabiman fu Gado wèt ben e suku wan fasi fu puru Yesus na pasi, bika den ben frede a folku. ");
INSERT INTO srnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dan Satan go na ini a ati fu Yudas di den ben e kari Iskariot tu. A ben de wan fu den twarfu man fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dan so Yudas go taki nanga den prenspari domri nanga den edeman fu den man di e hori wakti gi a mamakerki, fa a ben kan gi Yesus abra na ini den anu. ");
INSERT INTO srnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Den ben breiti, èn den agri nanga makandra fu pai en. ");
INSERT INTO srnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas ben feni en bun. Dan a bigin luru wan bun okasi fu gi Yesus abra na den, sondro tak' a folku sabi. ");
INSERT INTO srnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","So a fesa doro pe den ben e nyan brede san meki sondro dyesi. Dan tapu a dei di den ben mus srakti wan pikin skapu fu nyan Paska, ");
INSERT INTO srnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus seni Petrus nanga Yohanes fu go du wan sani gi En. A taki: “Un gwe go meki ala sani klari fu un kan nyan a Paska-nyanyan.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Den aksi En taki: “Masra, pe Yu wani fu un meki sani klari?” ");
INSERT INTO srnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesus taigi den taki: “Arki. Te un go ini a foto, wan man di e tyari wan watra-dyogo o kon miti unu. Un waka na en baka, go ini a oso pe a e go, ");
INSERT INTO srnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","dan un taigi a man di abi a oso taki: ‘A Meister seni aksi pe a kamra de, pe A kan nyan Paska nanga den man fu En.’ ");
INSERT INTO srnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dan a man o sori unu wan bigi kamra na sodro, di abi ala sani kba. Drape un mus meki a Paska-nyanyan klari.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na so Petrus nanga Yohanes gwe, èn ala sani waka soleki fa Yesus taki. Dan den meki a Paska-nyanyan klari. ");
INSERT INTO srnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Di a yuru fu nyan a Paska-nyanyan doro, Yesus nanga den boskopuman fu En teki presi sei a tafra. ");
INSERT INTO srnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dan Yesus taigi den taki: “Mi ben angri sote fu nyan a Paska disi nanga unu, fosi Mi bigin nyan pina. ");
INSERT INTO srnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Fu tru Mi e taigi un taki: Mi no o nyan Paska moro te leki a sani san Paska wani taki kon tru, te Gado o tiri libisma.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dan Yesus teki wan kan, A taki Gado tangi, dan A taki: “Un teki en, dan un alamala dringi fu en. ");
INSERT INTO srnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bika Mi e taigi un taki: Bigin fu now Mi no o dringi win moro, te leki a ten doro pe Gado o tiri libisma.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Baka dati Yesus teki wan brede. Di A taki Gado tangi, A broko en, dan A gi den man fu En. A taki: “Disi na Mi skin, san Mi o gi abra fu un ede. Un mus tan du disi fu memre Mi.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Di den kba nyan, Yesus teki wan kan dan A taki: “A kan disi na a nyun ferbontu. A brudu fu Mi san o lon gi unu, o stampu a ferbontu disi. ");
INSERT INTO srnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ma un arki: A sma di o seri Mi, de dya nanga Mi na tafra. ");
INSERT INTO srnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bika a Manpikin fu Libisma sa dede leki fa a ben skrifi kba na fesi. Ma a man di seri En mus luku bun!” ");
INSERT INTO srnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dan den bigin aksi makandra sortu wan fu den sa du sowan sani. ");
INSERT INTO srnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Den man fu Yesus bigin krutu nanga makandra sortu wan fu den moro prenspari. ");
INSERT INTO srnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dan Yesus taigi den taki: “Den kownu fu den folku e basi den, èn den wan di abi makti, den sma e kari: sma di e du bun gi a folku. ");
INSERT INTO srnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma unu no mus de so. A moro prenspari sma na un mindri mus tyari ensrefi leki a moro pikinwan, èn a fesiman fu unu mus tyari ensrefi leki a sma di e dini trawan. ");
INSERT INTO srnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Suma moro prenspari? A sma di de na tafra, noso a sma di e poti a nyanyan tapu a tafra. Na a sma di de na tafra moro prenspari. Ma Mi de na un mindri leki a sma di e dini trawan. ");
INSERT INTO srnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Unu ben de ala ten nanga Mi di tesi ben miti Mi. ");
INSERT INTO srnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Dan soleki fa Mi P'pa gi Mi a leti fu rigeri, na so Mi e gi unu a srefi leti tu. ");
INSERT INTO srnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Unu o nyan èn dringi na Mi tafra te Mi sa rigeri leki Kownu, èn unu o sidon na tapu kownusturu fu tiri den twarfu lo fu Israel.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Dan Yesus taki: “Simon, Simon, luku bun! Satan kisi primisi fu seki unu leki fa yu e wai aleisi, fu a kan tesi a bribi fu unu. ");
INSERT INTO srnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma Mi begi gi yu fu yu no lasi bribi. Dan te yu drai kon baka na Mi, yu mus kraka den trawan.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dan Petrus taigi Yesus taki: “Masra, mi de klar'klari fu go nanga Yu na ini straf'oso, èn fu dede srefi nanga Yu!” ");
INSERT INTO srnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Yesus taki: “Petrus, Mi e taigi yu taki: Fosi kakafowru bari tide, yu o taki dri leisi tak' yu no sabi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesus aksi den taki: “Di Mi ben seni unu fu go panya a Bun Nyunsu, sondro fu un tyari moni, wan saka noso susu, un ben mankeri wan sani?” Den piki taki: “Nono, un no ben mankeri noti.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ne Yesus taki: “Ma now, a sma di abi moni mus tyari en, èn a mus tyari wan saka tu. A sma di no abi wan owru mus seri en dyakti fu bai wan. ");
INSERT INTO srnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bika a skrifi taki: ‘Den si en leki wan abani,’ èn Mi kan taigi unu tak' na dati o psa nanga Mi. Bika san skrifi fu Mi musu psa.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dan den man taigi En taki: “Masra, luku tu owru dyaso.” Yesus piki den taki: “A nofo!” ");
INSERT INTO srnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus kmopo na ini Yerusalem, dan A go na a Oleifbergi, soleki fa A ben gwenti. Den man di ben e teki leri fu En go nanga En. ");
INSERT INTO srnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Di Yesus doro drape A taigi den taki: “Un begi fu un no kon na ini tesi.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dan Yesus kmopo na den mindri, go pikinso moro fara. A kindi na gron dan A begi taki: ");
INSERT INTO srnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“P'pa, efu Yu wani, puru a kan disi na Mi fesi, meki Mi no nyan a pina disi. Ma a no san Mi wani, ma na san Yu wani musu psa.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dan wan engel kmopo fu heimel kon na En fu gi En krakti. ");
INSERT INTO srnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus ben frede te fu dede, dan A bigin begi moro tranga èn a sweti fu En ben dropu na gron leki brudu. ");
INSERT INTO srnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Di Yesus kba begi, A opo go na den man fu En, dan A si tak' den fadon na sribi soso fa den ben sari. ");
INSERT INTO srnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A aksi den taki: “Sanede un e sribi? Un opo, dan un begi fu un no kon na ini tesi.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus no ben kba taki ete, di wan bigi grupu sma doro. Yudas, wan fu den twarfu man fu Yesus, ben waka na den fesi. A waka kon na Yesus fu gi En wan bosi. ");
INSERT INTO srnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma Yesus aksi en taki: “Yudas, nanga wan bosi yu e seri a Manpikin fu Libisma?” ");
INSERT INTO srnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Di den man di ben de nanga Yesus si san bo psa, den taki: “Masra, un mus teki un owru feti nanga den?” ");
INSERT INTO srnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dan wan fu den kapu a let'sei yesi puru fu a knekti fu a grandomri. ");
INSERT INTO srnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma Yesus taki: “A nofo!” A fasi a yesi fu a man, dan a man kon betre. ");
INSERT INTO srnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesus taigi den prenspari domri, den edeman fu den man di e hori wakti gi a mamakerki, nanga den fesiman fu a folku di kon fu grabu En taki: “Un kon nanga tiki nanga owru, neleki un kon teki wan bigi ogriman. ");
INSERT INTO srnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ala dei Mi ben de nanga unu ini a mamakerki, ma un no grabu Mi. Ma disi na a yuru fu unu, pe a makti fu dungru e rigeri.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dan den grabu Yesus, tyari En go na a oso fu a grandomri. Petrus ben e waka fara na den baka e kon. ");
INSERT INTO srnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dan den man meki wan faya mindrisei fu a dyari, den go sidon nanga makandra èn Petrus go sidon na den mindri. ");
INSERT INTO srnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dan wan frow di ben wroko drape, si Petrus sidon sei a faya. A luku Petrus bun, dan a taki: “A man disi ben de nanga Yesus tu.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma Petrus lei taki: “Frow, mi no sabi En!” ");
INSERT INTO srnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wan syatu pisten baka dati, wan tra sma si Petrus, dan a taki: “Yu na wan fu den man fu En tu.” Ma Petrus taki: “No, a no mi!” ");
INSERT INTO srnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Baka wan yuru so, wan tra man ben hori nomonomo e taki: “A tru. A man disi ben de nanga En tu, bika en na fu Galilea.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma Petrus piki taki: “No, mi no sabi san yu e taki!” A srefi momenti di Petrus ben e taki, wan kakafowru bari. ");
INSERT INTO srnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dan Masra drai luku Petrus. Ne Petrus memre tak' Masra ben taigi en taki: “Fosi kakafowru bari tide, yu o taki dri leisi tak' yu no sabi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dan Petrus go na dorosei, dan a bari wan krei. ");
INSERT INTO srnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Den man di ben hori wakti gi Yesus, teki En leki spot'popki, èn den naki En. ");
INSERT INTO srnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Den tapu En ai nanga wan krosi, dan den taigi En taki: “Sori unu tak' Yu na wan profeiti. Taigi unu suma naki Yu.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dan den taki wan lo tra sani fu afrontu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Di dei opo, a Grankrutu fu den Dyu kon makandra, sobun den prenspari domri nanga den sabiman fu Gado wèt. Den tyari Yesus go na fesi den man disi, ");
INSERT INTO srnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","dan den taigi En taki: “Efu Yu na a Mesias, taigi un dan!” A piki den taki: “Awinsi Mi taigi unu, un no o bribi. ");
INSERT INTO srnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Èn awinsi Mi aksi un wan sani, un no o piki. ");
INSERT INTO srnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma bigin fu now, a Manpikin fu Libisma o sidon na a let'anu sei fu Gado di abi Makti.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dan den man aksi En taki: “Na Yu na a Manpikin fu Gado dan?” Yesus piki taki: “Na unu srefi e taki tak' Mi na En.” ");
INSERT INTO srnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dan den man taki: “Un no abi kotoigi fanowdu moro. Un srefi yere san A taki nanga En eigi mofo!” ");
INSERT INTO srnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ne a heri grupu opo, dan den tyari Yesus go na fesi Pilatus. ");
INSERT INTO srnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dan den bigin kragi En taki: “Un kon si tak' a man disi e drai a ede fu a pipel fu unu. A e taigi den tak' den no mus pai a grankownu edemoni èn tak' na En na a Mesias, a Kownu.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dan Pilatus aksi En taki: “Na Yu na a Kownu fu den Dyu?” Yesus piki en taki: “Na leki fa yu taki.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dan Pilatus taigi den prenspari domri nanga a bigi grupu sma drape taki: “Mi no feni no wan sani na a man disi fu strafu En.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma den tan hori doro taki: “A e sutu faya gi a folku ini heri Yudea nanga a leri fu En. A bigin na Galilea, dan now A doro te dya.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Di Pilatus yere san den taki, a aksi efu a man disi na fu Galilea. ");
INSERT INTO srnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Dan di a kon ferstan tak' A kmopo na ini a kontren pe Herodes ben abi fu taki, a seni En go na en. A pisten dati Herodes ben de na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Di Herodes si Yesus a ben breiti srefsrefi, bika wan heri pisten kba a ben wani si En. A ben yere fu En, èn a ben angri fu Yesus sori en wan marki. ");
INSERT INTO srnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes aksi Yesus wan lo sani, ma Yesus no piki en noti. ");
INSERT INTO srnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Den prenspari domri nanga den sabiman fu Gado wèt ben tnapu e kragi Yesus fayafaya. ");
INSERT INTO srnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dan Herodes nanga den srudati fu en, bigin broko Yesus saka èn den teki En leki spot'popki. A weri wan moi krosi gi En, dan a seni En go baka na Pilatus. ");
INSERT INTO srnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A srefi dei dati, Herodes nanga Pilatus tron mati. Ma fosi dati den ben e libi leki feyanti nanga densrefi. ");
INSERT INTO srnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dan now Pilatus kari den prenspari domri, a folku nanga den edeman fu a folku kon makandra. A taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Un tyari a man disi kon na mi tak' A e drai a folku ede. Ma luku, let' na un fesi mi aksi En, ma mi no feni noti fu den sani san un e taki fu En. ");
INSERT INTO srnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes srefi no feni noti, bika a seni En kon baka gi wi. Luku, A no du noti fu A mus dede. ");
INSERT INTO srnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Dat'ede mi o wipi En, dan mi o lusu En.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatus taki dati bika tapu a Paskafesa, a ben mus lusu wan straf'man gi den. ");
INSERT INTO srnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma den sma bari leki wan man taki: “Puru En na un tapu! Lusu Barabas gi unu!” ");
INSERT INTO srnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Den ben sroto a man disi fu wan dyugudyugu ini a foto, èn fu di a ben kiri wan sma. ");
INSERT INTO srnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Dan fu di Pilatus ben wani lusu Yesus, a taki baka nanga den sma. ");
INSERT INTO srnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma den ben e bari taki: “Spikri En na wan kroisi! Spikri En na wan kroisi!” ");
INSERT INTO srnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatus taki a di fu dri leisi nanga den. A aksi den taki: “Ma sortu ogri a man disi du? Mi no feni noti fu meki tak' A mus dede. Dat'ede mi o wipi En, dan mi o lusu En.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma den sma ben e tan bari bun tranga tak' den mus spikri En na wan kroisi. Te fu kba a ben abi fu yere den. ");
INSERT INTO srnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dan Pilatus teki a besroiti fu gi den san den wani. ");
INSERT INTO srnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A lusu a man san den ben wani, di ben sroto fu wan dyugudyugu èn fu di a ben kiri wan sma. Dan a gi Yesus abra fu den du nanga En san den wani. ");
INSERT INTO srnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Di den e tyari Yesus gwe, den grabu wan man Simon fu a foto Sirena, di ben kmopo na boiti e kon. Dan den poti a kroisi tapu en skowru fu a tyari en na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wan bun bigi grupu fu a folku ben e waka baka Yesus. Ini a grupu yu ben abi furu umasma, di ben e sari èn di ben e krei fu En ede. ");
INSERT INTO srnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ma Yesus drai taigi den taki: “Uma fu Yerusalem, un no krei fu Mi ede, ma un krei gi unsrefi nanga den pikin fu unu. ");
INSERT INTO srnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bika wan ten o kon pe sma o taki: ‘Den uma di no man kisi pikin, nanga den wan di no kisi pikin ete, abi koloku. Èn den uma di noiti gi pikin bobi, abi koloku tu.’ ");
INSERT INTO srnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dan den sma o bigin taigi den bergi taki: ‘Fadon na un tapu!’ Den o taigi den pikin bergi taki: ‘Kibri unu!’ ");
INSERT INTO srnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bika efu na disi den e du nanga a lala udu, san den sa du nanga a drei udu dan?” ");
INSERT INTO srnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Makandra nanga Yesus, den ben tyari tu abani gwe fu go kiri. ");
INSERT INTO srnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Di den doro na a presi san den e kari Dede-ede, den spikri Yesus na a kroisi. Den spikri den tu abani na wan kroisi tu: wan na En let'anu sei, èn a trawan na En kruktu-anu sei. ");
INSERT INTO srnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dan Yesus taki: “P'pa, gi den pardon, bika den no sabi san den e du.” Dan den hari a lot fu prati En krosi. ");
INSERT INTO srnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A folku ben tnapu e luku, èn den edeman fu den ben teki En meki spotu. Den taki: “A ben yepi trawan. We, meki A yepi Ensrefi efu En na a Mesias, efu En na a Wan di Gado teki fu du En wani!” ");
INSERT INTO srnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Den srudati teki En leki spot'popki tu. Den waka kon na En, dan den gi En swa win fu A dringi. ");
INSERT INTO srnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Dan den taki: “Efu Yu na a Kownu fu den Dyu, yepi Yusrefi!” ");
INSERT INTO srnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Den ben skrifi poti na En edesei: “Disi na a Kownu fu den Dyu.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wan fu den abani di ben anga na a kroisi, afrontu En taki: “A no Yu na a Mesias? We, yepi Yusrefi, dan Yu yepi unu tu!” ");
INSERT INTO srnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma a trawan bari en taki: “Yu no e frede Gado, no? Yu kisi a srefi strafu leki En. ");
INSERT INTO srnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","A strafu san un kisi fiti unu, bika disi na a paiman fu san un ben du. Ma a Man disi no du no wan ogri.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dan a abani taki: “Yesus, memre mi te Yu teki Yu presi leki Kownu.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus piki en taki: “Fu tru Mi e taigi yu: Tide srefi yu sa de nanga Mi na Paradeis.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Twarfu yuru ten so a heri kondre kon dungru te leki dri yuru bakadina, ");
INSERT INTO srnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","bika a son ben kon dungru. Dan a garden ini a Santa Presi priti na tu. ");
INSERT INTO srnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dan Yesus bari nanga tranga sten taki: “P'pa, na ini Yu anu Mi e poti Mi yeye.” Di Yesus taki dati, En bro koti. ");
INSERT INTO srnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Di a kapten fu den srudati si san psa, a gi Gado glori. A taki: “Fu tru, a Man disi ben de wan bun sma.” ");
INSERT INTO srnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A bigi grupu sma di ben kon fu luku a sani disi, drai go baka na oso di den si san psa. Den ben naki densrefi tapu den borsu fu sori tak' den e sari. ");
INSERT INTO srnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ala den sma di ben sabi Yesus, ben tnapu farawe e luku san e psa, so tu den frow di ben waka kmopo fu Galilea kon nanga En. ");
INSERT INTO srnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yu ben abi wan man Yosef di ben de wan fu den memre fu a Grankrutu fu den Dyu. A ben de wan bun sma èn a ben libi bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","A no ben agri nanga a besroiti san den ben teki èn nanga san den ben du. A man disi ben kmoto fu a Dyu foto Arimatea, èn a ben angri fu a ten doro pe Gado o tiri libisma. ");
INSERT INTO srnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A go na Pilatus, dan a aksi en a dedeskin fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Baka di a puru en na a kroisi, a domru en na ini wan linnen krosi, dan a poti en na ini wan grebi san den ben diki ini a bergiskin. Noiti ete wan sma ben beri drape. ");
INSERT INTO srnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A ben de a dei di den Dyusma ben e meki ala sani klari gi a sabadei di bo bigin. ");
INSERT INTO srnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Den frow di ben kmopo nanga Yesus na Galilea, waka baka Yosef. Den si a grebi èn fa Yosef poti a dedeskin didon na ini. ");
INSERT INTO srnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dan den drai go baka na oso èn den poti mirre nanga tra spesrei klari. Ma tapu a sabadei den rostu soleki fa a wèt e taki. ");
INSERT INTO srnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tapu a fosi dei fu a wiki, fruku mamanten, den frow go na a grebi nanga ala den spesrei san den ben poti klari. ");
INSERT INTO srnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Di den doro, den si tak' a ston ben lolo kmopo fesi a grebi-olo. ");
INSERT INTO srnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Di den go na inisei, den no si a dedeskin fu Masra Yesus. ");
INSERT INTO srnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Den no ben sabi san den mus prakseri. Dan wantron so den si tu man di ben weri brenki krosi, tnapu na den sei. ");
INSERT INTO srnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Den frow skreki srefsrefi, dan den saka den ai. Den man aksi den taki: “Fu sanede un e suku a libiwan na mindri den dedewan? ");
INSERT INTO srnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A no dya, ma A kon baka na libi. Un memre san A ben taigi unu di A ben de ini Galilea ete. ");
INSERT INTO srnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","A ben taki tak' den ben mus gi a Manpikin fu Libisma abra na ini anu fu den sondusma. Den ben mus spikri En na a kroisi, ma tapu a di fu dri dei A ben mus kon baka na libi.” ");
INSERT INTO srnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dan den memre san A ben taki. ");
INSERT INTO srnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Di den drai gwe baka fu a grebi, den go ferteri den erfu man fu Yesus nanga ala den trawan, san ben psa. ");
INSERT INTO srnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Den frow di ben go ferteri den boskopuman fu Yesus den sani disi, ben de: Maria fu a foto Magdala, Yohana, Maria di ben de a m'ma fu Yakobus, nanga wantu trawan moro. ");
INSERT INTO srnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ma den man ben si a sani san den frow taki leki wan lawlaw sani, èn den no bribi den. ");
INSERT INTO srnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma Petrus opo lon go es'esi na a grebi. Di a bukundu luku go na ini, a si soso den linnen krosi. Dan a drai go baka na oso, ma a ben ferwondru fu a sani di psa. ");
INSERT INTO srnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A srefi dei dati, tu fu den ben de na pasi fu go na a dorpu Emaus, san ben de wan erfu kilometer so fu Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Den ben e taki nanga makandra fu ala den sani di ben psa. ");
INSERT INTO srnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Di den ben e taki e kenki prakseri, Yesus srefi kon na den, dan A bigin waka nanga den. ");
INSERT INTO srnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ma den no ben si tak' na En, bika Gado ben tapu den ai. ");
INSERT INTO srnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dan A aksi den taki: “San un e waka e taki so nanga makandra?” Den man tan tnapu nanga wan sari fesi. ");
INSERT INTO srnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dan wan fu den, di ben nen Kleopas, piki En taki: “Na Yu wawan ini heri Yerusalem no yere san psa drape den dei di psa de?” ");
INSERT INTO srnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesus aksi den taki: “San psa?” Den piki taki: “Yu no yere san psa nanga Yesus fu Nasaret? A ben de wan profeiti. Tapu wan krakti fasi A ben du sani èn gi leri na fesi Gado nanga a heri folku. ");
INSERT INTO srnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma den prenspari domri nanga den edeman fu unu ben gi En abra fu den kiri En. Dan den spikri En na wan kroisi. ");
INSERT INTO srnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Un dati ben abi a howpu tak' na En na a Wan di bo ferlusu Israel. Ma tide meki dri dei kba di a sani dati psa. ");
INSERT INTO srnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma a no dati wawan, wantu frow fu a grupu fu unu ben meki un skreki. Fruku mamanten den ben go na a grebi, ");
INSERT INTO srnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ma den no feni a dedeskin fu En. Dan den kon taigi unu tak' den si engel di taigi den tak' A e libi. ");
INSERT INTO srnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wantu fu unu go luku, dan den go miti a grebi soleki fa den frow ben taki. Ma En srefi den no si.” ");
INSERT INTO srnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dan Yesus taigi den taki: “Un donman! Fa un no man bribi ala den sani ete san den profeiti taki? ");
INSERT INTO srnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A Mesias ben mus fu nyan ala den pina disi fosi A ben kan kisi En glori.” ");
INSERT INTO srnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dan A bigin brokobroko gi den san a Santa Buku ben taki fu En, kmopo fu san Moses nanga ala den profeiti ben skrifi. ");
INSERT INTO srnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Den ben doro krosbei fu a dorpu pe den bo go, dan Yesus du leki A bo waka go moro fara. ");
INSERT INTO srnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma den man aksi En tangitangi taki: “Tan nanga unu, bika a son e saka kba. Neti e tapu.” So A go na inisei dan A tan nanga den. ");
INSERT INTO srnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Di Yesus ben de nanga den na tafra, A teki a brede, A blesi en, A broko en, dan A langa en gi den. ");
INSERT INTO srnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dan fosi Gado opo den ai, dan den si tak' na Yesus. Ma dan A no ben de fu si moro. ");
INSERT INTO srnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Dan den taigi densrefi taki: “Na dat' meki un ben abi sowan switi firi di A ben e taki nanga unu na pasi, e brokobroko a Santa Buku gi unu.” ");
INSERT INTO srnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dan den opo wantron, drai go baka na Yerusalem. Den go miti den erfu man fu Yesus nanga den tra sma di ben drape nanga den. ");
INSERT INTO srnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Den sma dati taigi den taki: “A tru! Masra kon baka na libi! A sori Ensrefi na Simon.” ");
INSERT INTO srnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dan den tu man ferteri san ben psa na pasi, èn fa den kon si tak' na Yesus di A broko a brede. ");
INSERT INTO srnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Di den ben e taki a tori ete, Yesus srefi kon tnapu na den mindri. A taigi den taki: “Freide mus de nanga unu!” ");
INSERT INTO srnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Den ben skreki te fu dede, bika den ben prakseri tak' den e si wan yorka. ");
INSERT INTO srnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dan Yesus aksi den taki: “Fu sanede un e skreki so? Sanede un de nanga tu ati? ");
INSERT INTO srnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Luku Mi anu nanga Mi futu, dan un o si tak' na Mi srefi dya! Kon fasi Mi, dan un o si tak' na Mi, bika wan yorka no abi meti nanga bonyo soleki fa Mi abi.” ");
INSERT INTO srnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Di A taki dati, A sori den En anu nanga En futu. ");
INSERT INTO srnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Den man ben breiti, èn den ben ferwondru sote tak' den no ben man bribi. Ne Yesus aksi den taki: “Un abi wan sani dyaso fu nyan?” ");
INSERT INTO srnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dan den gi En wan pisi baka fisi. ");
INSERT INTO srnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","A teki en, dan A nyan en let' na den fesi. ");
INSERT INTO srnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dan A taigi den taki: “Disi na san Mi ben taigi unu, di Mi ben de nanga unu ete: Ala sani san skrifi fu Mi na ini a wèt fu Moses, nanga den buku fu den profeiti, èn ini den Psalm mus kon tru.” ");
INSERT INTO srnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dan A opo den ai fu den kan ferstan san skrifi ini a Santa Buku. ");
INSERT INTO srnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A taigi den taki: “A skrifi tak' a Mesias ben mus nyan pina èn dede, dan tapu a di fu dri dei A ben mus kon baka na libi. ");
INSERT INTO srnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Dan bigin na Yerusalem, den mus preiki ini En nen gi ala folku tak' den mus drai den libi fu kisi pardon fu den sondu. ");
INSERT INTO srnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Unu na kotoigi fu den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Arki, Mi o seni a sani kon gi unu san Mi P'pa ben pramisi. Ma un mus tan ini a foto te leki un kisi a krakti san o kmopo na heimel.” ");
INSERT INTO srnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dan A tyari den go te na Betania. A opo En anu, dan A blesi den. ");
INSERT INTO srnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Di A e blesi den, A opo go na heimel libi den. ");
INSERT INTO srnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Den anbegi En, dan nanga bigi prisiri den drai go baka na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ala yuru den ben de ini a mamakerki e opo Gado nen.");
INSERT INTO srnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na a bigin a Wortu ben de. A Wortu ben de nanga Gado èn a Wortu ben de Gado. ");
INSERT INTO srnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","A ben de nanga Gado sensi na a bigin. ");
INSERT INTO srnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nanga En Gado meki ala sani, èn noti san meki ben meki sondro En. ");
INSERT INTO srnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A libi ben de ini En èn a libi ben de a faya gi libisma. ");
INSERT INTO srnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A faya de fu si ini a dungru èn a dungru no ben man tapu en. ");
INSERT INTO srnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gado ben seni wan man kon di ben nen Yohanes. ");
INSERT INTO srnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A ben kon leki wan kotoigi fu ferteri fu a faya, fu meki tak' ala sma ben kan kon na bribi. ");
INSERT INTO srnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","En srefi no ben de a faya, ma a ben kon fu ferteri fu a faya. ");
INSERT INTO srnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A trutru faya di e gi faya na ala sma, ben de fu kon na grontapu. ");
INSERT INTO srnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A ben de na grontapu èn nanga En Gado ben meki grontapu, ma grontapu no ben sabi En. ");
INSERT INTO srnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A ben kon na den sma fu En, ma den sma fu En no ben wani En. ");
INSERT INTO srnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma ala sma di teki En èn di bribi ini En, A gi den dati a leti fu tron pikin fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Disi no e psa te yu m'ma e meki yu. A no e psa tu fu di a mansma wani en, noso fu di libisma wani en, ma na fu di Gado srefi e meki yu tron En pikin. ");
INSERT INTO srnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A Wortu tron libisma èn A ben libi na wi mindri. Wi si a glori fu En, di a P'pa ben gi En leki En enkri pikin. A glori fu En ben furu nanga bun-ati èn A e sori unu san na tru. ");
INSERT INTO srnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes ben ferteri fu En. A ben bari taki: “Disi na a Man di mi ben taki o kon na mi baka. A prenspari moro mi, bika A ben de fosi mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Fu di En bun-ati bigi psa marki, meki wi alamala kisi a wan blesi baka a trawan. ");
INSERT INTO srnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses ben gi wi a wèt, ma Yesus Kristus sori wi san na bun-ati nanga san na tru. ");
INSERT INTO srnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Noiti wan sma si Gado. Ma a wan enkri Manpikin di de nanga a P'pa, meki wi kon sabi En. ");
INSERT INTO srnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Disi na san Yohanes taki di den fesiman fu den Dyu ini Yerusalem ben seni domri nanga Lefitiman kon na en fu aksi taki: “Suma na yu?” ");
INSERT INTO srnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ne Yohanes no drai, ma a taigi den krin taki: “Mi a no a Mesias.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dan den aksi en taki: “Suma na yu dan? Yu na Elia?” A piki den taki: “No, a no mi.” Den aksi en baka taki: “Yu na a Profeiti?” A taki: “No.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dan den aksi en taki: “Suma na yu dan? Un mus abi wan sani fu piki den sma di seni un kon. San yu e taki fu yusrefi?” ");
INSERT INTO srnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanes piki den taki: “Mi na a sten di e bari wroko ini a dreisabana fu puru ala boktuboktu na pasi gi Masra, leki fa a profeiti Yesaya ben taki.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sonwan fu den man di den seni kon ben de Fariseiman. ");
INSERT INTO srnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Den aksi en taki: “Efu yu a no a Mesias, efu yu a no Elia noso a Profeiti, fu sanede yu e dopu sma dan?” ");
INSERT INTO srnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanes piki den taki: “Mi e dopu sma nanga watra. Ma let' na un mindri wan sma e tnapu di un no sabi. ");
INSERT INTO srnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Na En e kon na mi baka. Mi no warti srefi fu puru En susu na En futu.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A sani disi psa na Betania na a tra sei fu a Yordanliba pe Yohanes ben e dopu sma. ");
INSERT INTO srnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","A tra dei Yohanes si tak' Yesus e kon na en, dan a taki: “Luku, a Lam fu Gado di e puru a sondu fu grontapu! ");
INSERT INTO srnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na a man disi mi ben taki e kon na mi baka. A prenspari moro mi, bika A ben de fosi mi. ");
INSERT INTO srnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mi srefi no ben sabi En. Ma mi kon dopu sma nanga watra fu meki den sma fu Israel kon sabi En.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Dan Yohanes ferteri den sma taki: “Mi si fa a Yeye fu Gado saka kmoto na heimel leki wan doifi, kon sidon na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mi no ben sabi suma na En. Ma a Wan di seni mi kon fu dopu sma nanga watra, ben taigi mi taki: ‘A man tapu san yu o si a Yeye saka kon sidon, na a man dati o dopu sma nanga a Santa Yeye.’ ");
INSERT INTO srnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mi si tak' a sani dati psa èn fu dat'ede mi e taigi unu: Disi na a Manpikin fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A tra dei Yohanes ben tnapu drape baka nanga tu fu den man fu en. ");
INSERT INTO srnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Di a si Yesus e psa, a taigi den taki: “Luku, disi na a Lam fu Gado!” ");
INSERT INTO srnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Di den tu man yere san Yohanes taki, den waka go na Yesus baka. ");
INSERT INTO srnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus drai luku dan A si tak' den e waka na En baka. Ne A aksi den taki: “San un wani?” Den aksi En taki: “Rabi, pe Yu e tan?” (A wortu Rabi wani taki: Meister.) ");
INSERT INTO srnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesus piki den taki: “Kon nanga Mi, dan un sa si.” So den waka go nanga Yesus. Di den si pe A e tan, den psa a dei moro fara nanga En. A sani disi psa wan sani fu fo yuru bakadina. ");
INSERT INTO srnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wan fu den tu man di yere san Yohanes taki èn di bigin waka na Yesus baka, ben de Andreas, a brada fu Simon Petrus. ");
INSERT INTO srnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A fosi sani san Andreas du, a go suku en brada Simon, dan a taigi en taki: “Un feni a Mesias.” (Mesias wani taki: Kristus.) ");
INSERT INTO srnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dan a tyari Simon go na Yesus. Yesus luku Simon dan A taki: “Yu na Simon, a manpikin fu Yohanes. Bigin fu now yu nen o de Kefas.” (A nen Kefas na a srefi leki Petrus.) ");
INSERT INTO srnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A tra dei Yesus ben wani go na Galilea. Dan A miti Filipus. Yesus taigi en taki: “Kon nanga Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipus ben de fu Betsaida, a srefi foto leki Andreas nanga Petrus. ");
INSERT INTO srnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dan Filipus miti Natanael èn a taigi en taki: “Un feni a man. Na fu En Moses ben skrifi ini a wèt, èn den profeiti ben skrifi fu En ini den buku fu den. Na Yesus, a manpikin fu Yosef fu a foto Nasaret.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael aksi en taki: “Sortu bun sani kan kmoto fu Nasaret?” Filipus piki en taki: “Kon, dan yu sa si.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Di Yesus si Natanael e kon na En, A taki: “Disi na wan trutru sma fu Israel. A no abi no wan bedrigi fasi.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael aksi En taki: “Fa Yu du sabi mi?” Yesus piki en taki: “Fosi Filipus kari yu, Mi ben si kba fa yu e sidon na ondro a figabon.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dan Natanael taki: “Meister, Yu na a Manpikin fu Gado. Yu na a Kownu fu Israel.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus piki en taki: “Yu e bribi ini Mi fu di Mi taigi yu nomo tak' Mi ben si fa yu e sidon ondro a figabon? Mi e taigi yu taki: Yu o si sani di bigi moro disi.” ");
INSERT INTO srnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Dan A taigi en moro fara taki: “Fu tru Mi e taigi un taki: Un o si fa heimel opo èn fa den engel fu Gado e kren go na loktu èn saka kon na a Manpikin fu Libisma.” ");
INSERT INTO srnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tu dei baka dati wan trow-oso ben de na a foto Kana ini Galilea. A m'ma fu Yesus ben de na a trow-oso ");
INSERT INTO srnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","èn den ben kari Yesus nanga den man di ben e teki leri fu En kon tu. ");
INSERT INTO srnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Di ala a win kba, a m'ma fu Yesus taigi En taki: “Den no abi win moro.” ");
INSERT INTO srnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesus piki en taki: “Frow, fu sanede yu kon na Mi? Mi yuru no doro ete.” ");
INSERT INTO srnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dan En m'ma taigi den knekti taki: “Un mus du ala sani san A taigi unu fu du.” ");
INSERT INTO srnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Now a ben de so tak' siksi ston kroiki ben tnapu drape fu den Dyu wasi den anu leki fa a gwenti fu den ben de. Ibriwan fu den ben e teki aititenti (80) kon miti wan hondro nanga tutenti (120) liter watra. ");
INSERT INTO srnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus taigi den knekti taki: “Furu den kroiki nanga watra.” Dan den man furu den te na a lantyi. ");
INSERT INTO srnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Dan Yesus taigi den taki: “Un teki pikinso tyari go gi a edeman fu a fesa.” So den man du dati. ");
INSERT INTO srnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Di a edeman fu a fesa tesi a watra, a ben kon tron win. A no ben sabi pe a win disi kmopo, ma den knekti di ben puru a watra ben sabi. Dan a seni kari a trowmasra kon ");
INSERT INTO srnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","èn a taigi en taki: “Ala sma e prati a bun win fosi. Te den sma dringi nofo, dan den e kisi a win san no tesi so bun. Ma yu kibri a bun win fu prati en now!” ");
INSERT INTO srnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A sani disi san Yesus du na Kana ini Galilea ben de a fosi marki fu En. A sori den sma a glori fu En èn den man fu En bribi ini En. ");
INSERT INTO srnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Baka dati Yesus go na Kafarnaum nanga En m'ma, den brada fu En nanga den man di ben e teki leri fu En. Dan den tan wantu dei drape. ");
INSERT INTO srnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A Paskafesa fu den Dyu ben de fu kon, dat' meki Yesus go na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Di A go ini a mamakerki, A miti nanga sma di ben e seri kaw, skapu nanga doifi, nanga trawan di ben e sidon broko moni. ");
INSERT INTO srnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne A teki titei dan A meki wan wipi fu en. Dan A yagi ala den man, nanga den skapu nanga den kaw, kmopo ini a kerki. A trowe a moni na gron fu den man di ben e broko moni, dan A drai den tafra fu den tapu. ");
INSERT INTO srnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A taigi den man di ben e seri doifi taki: “Un puru ala den sani disi! No meki a oso fu Mi P'pa tron wan wowoyo!” ");
INSERT INTO srnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dan den man fu Yesus memre tak' a skrifi ini Gadowortu taki: “A e bron ini mi leki wan faya fu du ala muiti gi Yu oso.” ");
INSERT INTO srnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dan den fesiman fu den Dyu aksi Yesus taki: “Sori un nanga wan marki tak' Yu abi primisi fu du den sani disi.” ");
INSERT INTO srnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesus piki den taki: “Broko a Santa Presi disi puru, dan Mi o bow en baka ini dri dei.” ");
INSERT INTO srnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dan den Dyu piki En taki: “A teki fotenti-na-siksi (46) yari fu bow a Santa Presi disi. Fa Yu o man bow en baka ini dri dei?” ");
INSERT INTO srnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma di Yesus ben e taki fu a Santa Presi, A ben e taki fu En skin. ");
INSERT INTO srnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Baka di Yesus kon na libi baka, den man fu En memre tak' A ben taki a sani disi. Dan den bribi san skrifi ini a Santa Buku nanga den wortu di Yesus taki. ");
INSERT INTO srnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Furu sma bribi ini Yesus di den si den marki san A du na a Paskafesa di A ben de na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma Yesus no ben e fertrow den fu di A sabi fa libisma de. ");
INSERT INTO srnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","No wan sma ben abi fu ferteri En fu libisma, bika A ben sabi libisma ati. ");
INSERT INTO srnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wan Fariseiman ben de di ben nen Nikodemus. A ben de wan fu den edeman fu den Dyu. ");
INSERT INTO srnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wan neti a man disi kon na Yesus dan a taigi En taki: “Meister, wi sabi tak' na Gado seni Yu kon fu gi den sma leri. Bika no wan sma bo man du den marki san Yu e du, efu Gado no ben de nanga en.” ");
INSERT INTO srnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus piki en taki: “Fu tru Mi e taigi yu: Efu yu no kon gebore nyunyun, yu no man kon ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dan Nikodemus aksi En taki: “Fa wan sma di owru kba kan kon gebore baka? Yu no man go ini yu m'ma bere baka fu a meki yu ete wan leisi.” ");
INSERT INTO srnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus piki en baka taki: “Fu tru Mi e taigi yu: No wan sma kan kon ondro a tiri fu Gado efu a no kon gebore fu watra nanga a Yeye. ");
INSERT INTO srnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bika san libisma meki na libisma, ma san a Yeye e meki na yeye. ");
INSERT INTO srnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yu no mus ferwondru di Mi taigi yu tak' un mus kon gebore nyunyun. ");
INSERT INTO srnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A winti e wai go pe a wani. Yu e yere en, ma yu no sabi pe a kmopo nanga pe a e go. Na so a de tu te wan sma kon gebore fu a Yeye.” ");
INSERT INTO srnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Dan Nikodemus aksi En taki: “Fa a sani dati kan?” ");
INSERT INTO srnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus piki en taki: “Fa yu leki wan leriman fu Israel no sabi den sani disi? ");
INSERT INTO srnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Fu tru Mi e taigi yu taki: Wi sabi san wi e taki èn wi e ferteri san wi ben si. Ma toku un no e bribi san wi e taigi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Efu un no e bribi Mi te Mi e ferteri unu sani fu grontapu, dan fa un o bribi Mi te Mi e ferteri unu sani fu heimel? ");
INSERT INTO srnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","No wan sma de di opo go na heimel, boiti a wan di saka kmopo fu heimel. Dati na a Manpikin fu Libisma. ");
INSERT INTO srnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Soleki fa Moses ben opo a sneki go na loktu ini a dreisabana, na so den mus opo a Manpikin fu Libisma go na loktu tu, ");
INSERT INTO srnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","fu meki tak' ala sma di e bribi ini En sa abi a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bika Gado lobi libisma sote, tak' A gi En wan enkri Manpikin fu meki tak' ala sma di e bribi ini En, no mus go lasi, ma fu den abi a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bika Gado no seni En Manpikin kon na grontapu fu krutu libisma, ma fu A ferlusu den. ");
INSERT INTO srnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A sma di e bribi ini En, no o kisi strafu. Ma efu wan sma no e bribi ini En, dan a strafu de na en tapu kba. Bika a no bribi ini a wan enkri Manpikin fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na fu a sani disi den o kisi strafu: A faya kon na grontapu, ma sma ben lobi a dungru moro a faya, bika san den ben e du ben ogri. ");
INSERT INTO srnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","A sma di e du ogri, no lobi a faya srefsrefi èn a no e kon ini a faya, fu sma no kon sabi san a e du. ");
INSERT INTO srnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma a sma di e du den sani san tru, a dati e kon ini a faya, fu sori tak' san a e du na san Gado wani fu a du.” ");
INSERT INTO srnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Baka dati Yesus nanga den man fu En go na a kontren fu Yudea. A tan nanga den drape, èn A dopu sma. ");
INSERT INTO srnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohanes ben e dopu sma tu na Enon, krosbei fu a foto Salim, bika furu watra ben drape. Den sma ben go drape na en fu a dopu den. ");
INSERT INTO srnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A pisten dati Yohanes no ben de na straf'oso ete. ");
INSERT INTO srnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Dan den man fu Yohanes kisi trobi nanga wan Dyu fu a fasi fa yu mus krin yusrefi. ");
INSERT INTO srnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dan den kon na Yohanes èn den taigi en taki: “Meister, wan Man ben de na yu na a tra sei fu a Yordanliba èn yu ben ferteri unu suma na En. Now a Man dati e dopu sma tu èn ala sma e go na En.” ");
INSERT INTO srnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma Yohanes piki den taki: “No wan sma kan kisi wan sani, efu a no Gado na heimel gi en. ");
INSERT INTO srnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Un srefi yere di mi ben taki tak' mi a no Kristus, ma tak' Gado ben seni mi kon na En fesi. ");
INSERT INTO srnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A trowmisi na fu a trowmasra. A mati fu a trowmasra e tnapu arki nomo oten a trowmasra e kon, èn a e breiti te a yere en sten. A sani disi e meki mi breiti fu tru. ");
INSERT INTO srnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sma mus poti den ai moro nanga moro na En tapu, dan den puru den ai na mi tapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","A wan di kmoto na loktu bigi moro ala trawan. Ma a sma di de fu grontapu, na fu grontapu. Dat' meki a e si ala sani grontapu fasi. ");
INSERT INTO srnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A Wan di kmoto na heimel e ferteri fu san A si nanga san A yere, ma no wan sma e bribi san A e taki. ");
INSERT INTO srnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma te wan sma bribi san A taki, a e sori nanga dati tak' Gado abi leti. ");
INSERT INTO srnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bika a wan di Gado seni kon e ferteri san Gado taki, bika Gado gi En a Santa Yeye psa marki. ");
INSERT INTO srnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A P'pa lobi a Manpikin, èn A poti ala sani na ini En anu. ");
INSERT INTO srnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","A sma di e bribi ini a Manpikin, abi a libi fu têgo. Ma a sma di no wani du san a Manpikin e taki, no o kisi a libi, bika a atibron fu Gado e tan na en tapu. ");
INSERT INTO srnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Den Fariseiman ben kisi fu yere tak' moro furu sma e waka baka Yesus, èn tak' A e dopu moro furu sma leki Yohanes. ");
INSERT INTO srnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ma a no Yesus srefi ben e dopu den sma, ma na den man fu En. ");
INSERT INTO srnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Di A yere dati, A kmoto fu Yudea dan A drai go baka na Galilea. ");
INSERT INTO srnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma A ben musu psa ini Samaria. ");
INSERT INTO srnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Dan A doro na wan foto fu Samaria di den ben e kari Sikar. A ben de krosbei fu a pisi gron san Yakob ben gi en manpikin Yosef. ");
INSERT INTO srnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Drape a peti fu Yakob ben de. Yesus ben weri fu a langa waka san A ben waka, so A saka sidon na a peti. A ben de twarfu yuru ten so. ");
INSERT INTO srnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","A pisten di den man fu Yesus ben go ini a foto fu bai nyanyan, wan Samaria-uma kon na a peti fu teki watra. Dan Yesus taigi en taki: “Gi mi pikinso watra fu dringi.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A Samaria-uma piki En taki: “Fa Yu leki wan Dyu kan aksi mi leki wan Samaria-uma fu gi Yu pikin watra fu dringi?” Bika Dyusma no e bemui srefsrefi nanga Samariasma. ");
INSERT INTO srnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma Yesus piki en taki: “Efu yu ben sabi san Gado abi fu gi yu, èn efu yu ben sabi suma e aksi yu pikin watra, dan na yu bo aksi En pikin watra èn A bo gi yu watra san e gi libi.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A uma piki En taki: “Masra, a peti dipi èn Yu no abi embre. Dan pe Yu o feni a watra san e gi libi? ");
INSERT INTO srnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yu denki tak' Yu bigi moro wi afo Yakob? Na en libi a peti disi na baka gi wi. A ben dringi fu en, èn den boi nanga den meti fu en ben dringi fu a peti disi tu.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus piki en taki: “Ala sma di e dringi fu a watra disi, sa kisi dreineki baka. ");
INSERT INTO srnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma a sma di e dringi fu a watra san Mi o gi en, no o kisi dreineki noiti moro. Bika a watra dati o tron wan peti ini a sma, di e tan gi watra san o gi en a libi fu têgo.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dan a uma taigi En taki: “Masra, gi mi a watra dati fu watra no kiri mi moro. Dan mi no abi fu kon dya moro fu teki watra.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus taigi en taki: “Go kari yu masra kon.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A uma piki taki: “Mi no abi masra.” Yesus piki en taki: “Yu abi leti di yu taki tak' yu no abi masra. ");
INSERT INTO srnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bika na feifi man yu ben abi kba, èn a man di yu abi now, a no yu masra tu. So na wan tru sani yu taki.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dan a uma taki: “Masra, mi e si tak' yu na wan profeiti. ");
INSERT INTO srnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Den afo fu wi ben e anbegi Gado na tapu a bergi disi. Ma un Dyu e taki tak' na Yerusalem na a presi pe sma mus anbegi Gado.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dan Yesus piki en taki: “Uma, yu kan bribi Mi: A ten e kon tak' sma no o anbegi a P'pa tapu a bergi disi. Den no o anbegi En ini Yerusalem tu. ");
INSERT INTO srnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Un Samariasma no sabi san un e anbegi, ma wi sabi san wi e anbegi. Bika a Ferlusuman e kmopo fu den Dyu. ");
INSERT INTO srnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma a ten e kon, èn a de kba, pe den sma di e anbegi a P'pa trutru sa anbegi En nanga den yeye èn tapu wan tru fasi. Bika Gado wani sma di sa anbegi En tapu a fasi disi. ");
INSERT INTO srnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gado na yeye, èn den sma di e anbegi En mus anbegi En nanga den yeye èn tapu wan tru fasi.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dan a uma taki: “Mi sabi tak' a Mesias o kon, a wan di den e kari Kristus. Te A kon, A sa leri un ala sani.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ne Yesus piki en taki: “Na Mi di e taki nanga yu, na a man dati.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A srefi pisten dati den man fu Yesus doro èn den ben ferwondru fu si tak' A e taki nanga wan frow. Ma toku no wan fu den no aksi En taki: “San Yu wani nanga a frow?” noso: “Fu sanede Yu e taki nanga en?” ");
INSERT INTO srnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A frow libi en kroiki dan a go na a foto go taigi den sma taki: ");
INSERT INTO srnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kon nanga mi, kon luku wan sma di taigi mi ala sani di mi ben du! Kande na En na a Mesias.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dan den sma kmopo fu a foto kon na En. ");
INSERT INTO srnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A pisten dati den man fu Yesus taigi En taki: “Meister, kon nyan pikinso.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma Yesus piki den taki: “Mi abi sani fu nyan san un no sabi.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dan den man fu En aksi makandra efu wan sma ben tyari wan sani gi En fu A nyan. ");
INSERT INTO srnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Yesus taigi den taki: “Mi nyanyan na fu du a wani fu a Wan di seni Mi kon, èn fu klari a wroko di A gi Mi fu du. ");
INSERT INTO srnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Sma e taki: ‘Ete fo mun dan yu kan koti nyanyan.’ Ma Mi e taigi un taki: Opo un ai, luku den gron. A nyanyan lepi kba fu koti! ");
INSERT INTO srnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A sma di e koti a lepi nyanyan e kisi en pai, èn a e tyari den froktu kon na wan di o kisi a libi fu têgo. Dan so a sma di prani nanga a sma di koti kan breiti makandra. ");
INSERT INTO srnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A odo tru di e taki: A wan e prani, a trawan e koti. ");
INSERT INTO srnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Bika Mi seni unu fu go koti pe unu no ben prani. Trawan ben du a wroko, dan now unu e nyan a froktu fu a wroko fu den.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Fu di a frow go ferteri den sma tak' Yesus taigi en ala sani san a ben du, meki furu Samariasma fu a foto dati bribi na ini Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","So den kon na Yesus, dan den begi En fu tan na den. Dan A tan tu dei drape. ");
INSERT INTO srnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Furu tra sma kon na bribi di den yere san Yesus srefi taki. ");
INSERT INTO srnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dan den taigi a frow taki: “Un no e bribi moro nomo fu di yu kon ferteri unu. Now un yere nanga un eigi yesi èn un sabi trutru tak' disi na a Ferlusuman fu heri grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Baka den tu dei dati A kmoto fu drape go na Galilea. ");
INSERT INTO srnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesus srefi ben taki tak' sma no e lespeki wan profeiti ini a foto pe a kweki. ");
INSERT INTO srnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma di A doro ini Galilea, den sma drape teki En nanga opo anu. Bika den ben de na a Paskafesa ini Yerusalem èn den ben si san A du drape. ");
INSERT INTO srnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","So A kon doro baka na Kana ini Galilea, pe A ben meki a watra tron win. Drape wan man fu Kafarnaum ben de di ben e wroko gi kownu. A boi fu a man disi ben e siki. ");
INSERT INTO srnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Di a man yere tak' Yesus kmopo fu Yudea kon baka na Galilea, a go na En. Dan a begi En fu A kon dresi a boi fu en, bika a ben de fu dede. ");
INSERT INTO srnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus taigi en taki: “Solanga unu no si marki nanga wondru, un no e bribi.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma a man piki En taki: “Masra, kon nanga mi fosi mi boi dede.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Dan Yesus taigi en taki: “Yu kan go, a boi fu yu kon betre.” A man bribi san Yesus taigi en, dan a gwe. ");
INSERT INTO srnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Di a ben de na pasi ete, den knekti fu en waka kon miti en nanga a nyunsu tak' a boi fu en kon betre. ");
INSERT INTO srnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dan a man aksi den olati a boi ben kon betre. Den piki en taki: “Na esde brekten wan yuru so, a korsu wai.” ");
INSERT INTO srnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dan a p'pa memre tak' na a yuru dati Yesus ben taigi en tak' a boi fu en kon betre. A sani disi meki tak' en nanga den sma fu en oso kon bribi na ini Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Disi ben de a di fu tu leisi di Yesus sori den sma wan marki baka di A kmoto fu Yudea kon na Galilea. ");
INSERT INTO srnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baka dati Yesus go na Yerusalem, bika den Dyusma ben abi wan fesa. ");
INSERT INTO srnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na Yerusalem yu ben abi wan bigi ston peti nanga feifi gadri lontu en, di ben de krosbei fu a Skapupoort. Ini a tongo fu den Dyu den ben e kari en Betesda. ");
INSERT INTO srnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Furu sikisma ben e didon ini den gadri, soleki brenisma, lansma nanga malengrisma. Den ben e wakti fu a watra sek'seki. ");
INSERT INTO srnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bika wanwan leisi wan engel fu Masra ben e saka kon na ini a watra, dan a watra ben e sek'seki. A fosi sma di ben saka go ini a watra te a sek'seki, ben e kon betre, awinsi sortu siki a ben abi. ");
INSERT INTO srnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wan man ben drape di ben e siki dritenti-na-aiti (38) yari kba. ");
INSERT INTO srnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus si a man disi, èn fu di A ben sabi tak' a de wan heri pisten drape kba, meki A aksi en taki: “Yu wani kon betre?” ");
INSERT INTO srnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A sikiman piki En taki: “Masra, mi no abi no wan sma fu saka mi ini a watra te a e beweigi. Te fu mi doro drape, wan trawan koti mi fesi kba.” ");
INSERT INTO srnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dan Yesus taigi en taki: “Opo, teki yu matrasi, dan yu waka gwe.” ");
INSERT INTO srnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","A srefi momenti dati a man kon betre. A teki en matrasi, dan a waka gwe. A sani disi psa tapu wan sabadei. ");
INSERT INTO srnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Dan den fesiman fu den Dyu taigi a man di ben kon betre taki: “Tide na sabadei èn a wèt no wani fu yu tyari yu matrasi tapu a dei disi.” ");
INSERT INTO srnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma a man piki den taki: “A man di dresi mi, taigi mi fu teki mi matrasi dan mi waka gwe.” ");
INSERT INTO srnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dan den aksi en taki: “Suma na a man di taigi yu fu du dati?” ");
INSERT INTO srnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma a man di ben kon betre no ben sabi, bika wan bigi grupu sma ben drape èn Yesus ben gwe na den mindri. ");
INSERT INTO srnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Baka dati Yesus miti a man ini a mamakerki, dan A taigi en taki: “Arki, yu kon betre. Ma yu mus tapu nanga a sondu libi, noso wan moro takru sani o psa nanga yu.” ");
INSERT INTO srnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dan a man gwe go ferteri den fesiman fu den Dyu tak' na Yesus ben dresi en. ");
INSERT INTO srnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Fu dat'ede den fesiman fu den Dyu bigin fu de nomo na Yesus baka fu du En ogri, bika A ben du a sani disi tapu wan sabadei. ");
INSERT INTO srnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma Yesus taigi den taki: “Mi P'pa e wroko te nanga a dei fu tide. Dat' meki Mi e wroko tu.” ");
INSERT INTO srnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","So den Dyu fesiman ben e du moro furu muiti fu kiri Yesus. Bika A no ben broko a wèt fu sabadei wawan, ma A ben kari Gado En eigi P'pa tu. Tapu sowan fasi A ben taki tak' En nanga Gado na wan. ");
INSERT INTO srnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Dan Yesus taigi den taki: “Fu tru Mi e taigi un taki: A Manpikin no man du noti fu Ensrefi, ma A e du soso san A si tak' a P'pa e du. San a P'pa e du, na dati a Manpikin e du tu. ");
INSERT INTO srnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bika a P'pa lobi a Manpikin, èn A e sori En ala sani san Ensrefi e du. A o sori En moro bigi wroko leki disi di o meki unu ferwondru. ");
INSERT INTO srnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bika soleki fa a P'pa e meki dedesma opo baka èn A e gi den libi, na so a Manpikin e gi libi tu na suma A wani. ");
INSERT INTO srnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Moro fara a P'pa no e krutu no wan sma, ma A o meki a Manpikin krutu ala sani. ");
INSERT INTO srnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","A du dati fu ala sma gi a Manpikin grani, soleki fa den e gi a P'pa grani. A sma di no e gi a Manpikin grani, no e gi grani na a P'pa tu di seni En kon. ");
INSERT INTO srnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Fu tru Mi e taigi un taki: A sma di arki san Mi e taki, èn di bribi ini a Wan di seni Mi kon, abi a libi fu têgo. A no sa kon ondro a krutu, ma a kmoto fu dede kon na libi. ");
INSERT INTO srnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Fu tru Mi e taigi un taki: A ten e kon èn a de kba, pe den dedewan o yere a sten fu a Manpikin fu Gado, èn den wan di yere en o libi. ");
INSERT INTO srnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bika soleki fa a P'pa abi libi ini Ensrefi, na so A meki tak' a Manpikin abi libi ini Ensrefi tu. ");
INSERT INTO srnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A gi En makti tu fu krutu sma, bika En na a Manpikin fu Libisma. ");
INSERT INTO srnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Un no mus ferwondru fu a sani disi. Bika a ten e kon tak' ala den dedesma o yere En sten, ");
INSERT INTO srnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","dan den o opo kmoto fu den grebi. Den sma di ben du bun, o opo baka fu kisi a libi fu têgo. Ma den sma di ben du ogri, o opo baka fu kisi strafu. ");
INSERT INTO srnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mi no kan du noti fu Misrefi. Mi e krutu soleki fa Mi yere, èn Mi e krutu nanga leti, bika Mi no e suku fu du Mi eigi wani, ma fu du a wani fu a Wan di seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Efu Mi e taki fu Misrefi, a no abi warti. ");
INSERT INTO srnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma wan trawan de di e taki fu Mi, èn Mi sabi tak' san En e taki fu Mi tru. ");
INSERT INTO srnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Un ben seni aksi Yohanes èn a ben ferteri un san tru. ");
INSERT INTO srnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mi no abi libisma fanowdu fu taki fu Mi, ma Mi e taki disi fu Gado kan ferlusu unu. ");
INSERT INTO srnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanes ben de leki wan lampu di ben bron e gi faya, èn un ben prisiri fu wan pisten nanga a faya di a ben gi. ");
INSERT INTO srnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ma sani de di prenspari moro leki den sani san Yohanes ben taki fu Mi. Dati na den wroko di a P'pa gi Mi fu du. Na den wroko dati Mi e du, èn den e sori tak' a P'pa seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Èn a P'pa di seni Mi kon, na En ben taki fu Mi tu. Noiti un yere En sten èn noiti un si En. ");
INSERT INTO srnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A wortu fu En no e tan ini unu, fu di un no e bribi ini a Wan di A seni kon. ");
INSERT INTO srnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Un e ondrosuku Gadowortu, bika un e prakseri tak' na drape un o feni a libi fu têgo. A Wortu disi e taki fu Mi, ");
INSERT INTO srnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ma toku un no wani kon na Mi fu kisi a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mi no e suku grani fu libisma. ");
INSERT INTO srnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma Mi sabi fa un de. A lobi fu Gado no de ini unu. ");
INSERT INTO srnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi kon ini a nen fu Mi P'pa, ma un no wani Mi. Ma te wan tra sma kon ini en eigi nen, un o teki en. ");
INSERT INTO srnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Un e suku grani fu tra sma, ma un no e suku grani fu a wan enkri Gado. Fa un o man bribi dan? ");
INSERT INTO srnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Un no mus prakseri tak' Mi o tyari unu go krutu na a P'pa. Ma na Moses, a sma tapu san un poti un howpu, na en o krutu unu. ");
INSERT INTO srnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Efu un ben bribi Moses, un bo bribi Mi tu, bika a ben skrifi fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma efu un no e bribi san Moses skrifi, fa un o man bribi san Mi e taki?” ");
INSERT INTO srnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Baka dati Yesus go na a tra sei fu a Meer fu Galilea, di den e kari a Meer fu Tiberias tu. ");
INSERT INTO srnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wan bigi grupu sma ben e waka na En baka bika den ben si den marki di A ben du gi den sikisma. ");
INSERT INTO srnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dan Yesus kren go sidon tapu wan bergi nanga den man fu En. ");
INSERT INTO srnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Now a ben de so tak' a Paskafesa fu den Dyu ben de krosbei. ");
INSERT INTO srnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Di Yesus luku lontu, A si tak' wan heri ipi sma e kon na En. Dan A aksi Filipus taki: “Pe wi o bai brede fu den sma disi kan nyan?” ");
INSERT INTO srnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesus taki so fu yere san Filipus bo taki, bika A ben sabi kba san A ben wani du. ");
INSERT INTO srnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipus piki En taki: “Tu hondro solfrumoni no bo sari ete fu gi ala den sma disi wan pikin pisi brede.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dan Andreas, wan fu den man fu Yesus, di ben de a brada fu Simon Petrus, taigi En taki: ");
INSERT INTO srnNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wan boi de dya di abi feifi brede nanga tu fisi. Ma dati no sari gi someni sma.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Furu grasi ben de na a presi drape. Dan Yesus taki: “Meki den sma go sidon.” Ne den sma saka sidon. Wan feifi dusun mansma so ben de ini a grupu. ");
INSERT INTO srnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dan Yesus teki den brede, A taki Gado tangi, dan A prati den gi den sma di ben e sidon drape. A du a srefi sani nanga den fisi tu. Ala den sma ben kisi someni leki den wani. ");
INSERT INTO srnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Di den sma nyan te den bere furu, Yesus taigi den man fu En taki: “Piki ala den pis'pisi san libi ete, fu noti no lasi.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","So den piki den pis'pisi di ben libi ete fu den feifi brede baka di den sma nyan, èn den furu twarfu baskita. ");
INSERT INTO srnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Di den sma si a marki san Yesus du, den taki: “Fu tru, disi na a Profeiti di bo kon na grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesus si tak' den ben wani kon teki En nanga tranga fu poti En leki kownu, so A gwe libi den. A go baka na a bergi presi pe En wawan ben kan de. ");
INSERT INTO srnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Di neti tapu den man fu Yesus saka go na a meer. ");
INSERT INTO srnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Den go ini wan boto, dan den bigin koti abra go na Kafarnaum. A ben dungru kba èn Yesus no ben drai kon baka na den ete. ");
INSERT INTO srnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Dan wan hebi winti bigin wai èn den skwala kon hei. ");
INSERT INTO srnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Di den pari a boto wan feifi kilometer so, den si Yesus e waka tapu a watra e kon na a boto. Den man frede, ");
INSERT INTO srnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ma Yesus taigi den taki: “Na Mi! Un no abi fu frede.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Den ben wani teki En ini a boto, ma a srefi momenti dati a boto doro a syoro pe den ben wani go. ");
INSERT INTO srnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A tra dei fu en, a bigi grupu sma di ben de na a tra sei fu a meer ete, memre tak' na wan boto nomo ben drape. Den memre tu tak' Yesus no ben go nanga den man fu En ini a boto, ma tak' den man fu En ben gwe sondro En. ");
INSERT INTO srnNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma now tra boto ben kmopo fu Tiberias kon na a presi pe den ben nyan a brede baka di Masra ben taki tangi fu en. ");
INSERT INTO srnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","So di a bigi grupu sma si tak' Yesus nanga den man fu En no ben drape, den go ini den boto dati, dan den koti abra go na Kafarnaum fu go suku Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Di den feni En na abrasei fu a meer, den aksi En taki: “Meister, oten Yu kon dya?” ");
INSERT INTO srnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesus piki den taki: “Fu tru Mi e taigi un taki: Un no e suku Mi fu di un si den marki, ma fu di un furu un bere nanga brede. ");
INSERT INTO srnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Un no mus wroko fu kisi nyanyan san e pori gwe, ma un mus wroko fu kisi a nyanyan san no e pori èn san e gi a libi fu têgo. Dati na a nyanyan san a Manpikin fu Libisma o gi unu. Bika Gado a P'pa poti En stampu na En tapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dan den sma aksi En taki: “San un mus du? San na den wroko san Gado wani tak' un mus du?” ");
INSERT INTO srnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesus piki den taki: “A wroko san Gado wani tak' un mus du na disi: Un mus bribi ini a Wan di A seni kon.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dan den aksi En baka taki: “Sortu marki Yu o sori unu fu un kan bribi ini Yu? San Yu o du? ");
INSERT INTO srnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Den afo fu wi ben nyan mana ini a dreisabana, soleki fa a skrifi taki: ‘A gi den brede fu nyan di kmoto fu heimel.’ ” ");
INSERT INTO srnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dan Yesus taigi den taki: “Fu tru Mi e taigi unu: A no Moses ben gi un a brede di kmoto fu heimel, ma na Mi P'pa e gi un a trutru brede san e kmopo fu heimel. ");
INSERT INTO srnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bika a brede fu Gado na a Wan di saka kmopo fu heimel fu gi libi na ala sma fu grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dan den sma aksi En taki: “Masra, gi unu a brede disi ala dei.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus piki den taki: “Mi na a brede san e gi libi. Noiti moro angri o kiri a sma di e kon na Mi, èn noiti moro watra o kiri a sma di e bribi ini Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Leki fa Mi taigi un kba: Un e si Mi, ma toku un no e bribi. ");
INSERT INTO srnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ala den sma di a P'pa gi Mi, o kon na Mi, èn den sma di kon na Mi, noiti Mi o yagi gwe. ");
INSERT INTO srnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bika Mi no saka kmopo fu heimel fu du Mi eigi wani, ma fu du a wani fu a Wan di seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Èn disi na a wani fu a Wan di seni Mi kon, tak' Mi no lasi no wan fu den sma di A gi Mi, ma tak' Mi meki alamala kon na libi baka tapu a laste dei. ");
INSERT INTO srnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bika Mi P'pa wani tak' ala sma di e si a Manpikin, èn di e bribi ini En, sa kisi a libi fu têgo, èn Mi o meki den kon na libi baka tapu a laste dei.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Dan den Dyu bigin krut'krutu fu di A ben taki tak' En na a brede san saka kmopo fu heimel. ");
INSERT INTO srnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Den taki: “A no Yesus, a manpikin fu Yosef? Un sabi En m'ma nanga En p'pa. Fa a kan taki tak' A saka kmopo fu heimel?” ");
INSERT INTO srnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma Yesus piki den taki: “No krut'krutu nanga makandra. ");
INSERT INTO srnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","No wan sma kan kon na Mi, efu a P'pa di seni Mi, no hari en kon. Dan Mi sa meki a kon na libi baka tapu a laste dei. ");
INSERT INTO srnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A skrifi ini den buku fu den profeiti taki: ‘Gado srefi o gi ala sma leri.’ Ala sma di e arki a P'pa èn di e teki leri fu En, e kon na Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dati no wani taki tak' a sma si a P'pa, bika soso a Wan di kmoto fu Gado si a P'pa. ");
INSERT INTO srnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Fu tru Mi e taigi un taki: A sma di e bribi, abi a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mi na a brede san e gi libi. ");
INSERT INTO srnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Den afo fu unu ben nyan a mana ini a dreisabana, ma toku den dede. ");
INSERT INTO srnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma a sma di e nyan fu a brede disi di e saka kmopo fu heimel, no sa dede. ");
INSERT INTO srnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mi na a brede san e gi libi, di saka kmopo fu heimel. A sma di e nyan fu a brede disi, sa libi fu têgo. Èn a brede san Mi o gi en na Mi skin, san Mi o gi fu ala sma na grontapu kan feni libi.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dan den Dyu bigin krutu nanga makandra. Den taki: “Fa a Man disi kan gi un En skin fu nyan?” ");
INSERT INTO srnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ne Yesus taigi den taki: “Fu tru Mi e taigi unu: Efu un no nyan a skin èn efu un no dringi a brudu fu a Manpikin fu Libisma, dan un no abi libi na ini unu. ");
INSERT INTO srnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","A sma di e nyan Mi skin èn di e dringi Mi brudu, abi a libi fu têgo. Èn Mi sa meki a kon na libi baka tapu a laste dei. ");
INSERT INTO srnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bika Mi skin na trutru nyanyan èn Mi brudu na trutru dringi. ");
INSERT INTO srnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","A sma di e nyan Mi skin èn di e dringi Mi brudu, e tan wan nanga Mi èn Mi e tan wan nanga en. ");
INSERT INTO srnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","A P'pa di e libi seni Mi kon, èn soleki fa A gi Mi libi, na so Mi o gi libi tu na a sma di e nyan Mi skin. ");
INSERT INTO srnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Disi na a brede di saka kmoto fu heimel. Den afo fu unu ben nyan mana, ma toku den dede. Ma a sma di e nyan a brede disi, sa libi fu têgo.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus taki den sani disi di A ben e gi leri ini a Dyukerki na Kafarnaum. ");
INSERT INTO srnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Di den yere dati, furu fu den sma di ben e teki leri fu Yesus taki: “A leri disi tranga. Suma o man teki en?” ");
INSERT INTO srnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma Yesus ben sabi tak' den man fu En ben e krut'krutu abra a san disi. So A taigi den taki: “Na mandi un e mandi fu di Mi taki so? ");
INSERT INTO srnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","San un o du dan te un si a Manpikin fu Libisma e opo go na a presi pe A ben de fosi? ");
INSERT INTO srnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na a Yeye e gi libi, a skin na noti. Den sani san Mi taigi unu, na yeye sani èn den e gi libi. ");
INSERT INTO srnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma sonwan fu unu no e bribi.” Yesus ben sabi sensi na a bigin suma no bo bribi, nanga suma bo seri En. ");
INSERT INTO srnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Dan Yesus taki: “Fu dat'ede Mi taigi unu: No wan sma kan kon na Mi efu a no a P'pa meki a du dati.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sensi a pisten dati, furu fu den sma di ben e teki leri fu En, drai baka gi En. Den no waka moro langa nanga En. ");
INSERT INTO srnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dan Yesus aksi den twarfu man fu En taki: “Ma unu dan, un o gwe libi Mi tu?” ");
INSERT INTO srnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrus piki En taki: “Masra, na suma un o go dan? Na Yu abi wortu di e gi a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wi e bribi Yu, èn wi sabi tak' Yu na a Santa Wan fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dan Yesus piki den taki: “Unu na den twarfu man di Mi teki. Ma wan fu unu na wan didibri.” ");
INSERT INTO srnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesus ben e taki fu Yudas, a manpikin fu Simon Iskariot. Bika fu den twarfu man fu Yesus, Yudas ben de a wan di bo seri En. ");
INSERT INTO srnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Baka dati Yesus hari fu a wan presi go na a trawan ini Galilea. A no ben wani tan na Yudea, bika den fesiman fu den Dyu ben e suku fu kiri En. ");
INSERT INTO srnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma a ten fu den Dyu hori a Sukotfesa fu den, ben de krosbei. ");
INSERT INTO srnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Dan den brada fu Yesus taigi En taki: “Yu mus kmopo dya go na Yudea, meki den sma fu Yu si den sani san Yu e du. ");
INSERT INTO srnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bika no wan sma e du wan sani kibrifasi, efu a wani fu sma kon sabi en. Efu Yu e du den sani disi, dan meki heri grontapu kon sabi Yu!” ");
INSERT INTO srnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Den brada fu Yesus taki so, fu di den srefi no ben e bribi na ini En. ");
INSERT INTO srnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Dan Yesus piki den taki: “Un kan go oten un wani, ma a yuru fu Mi no doro ete. ");
INSERT INTO srnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Den sma fu grontapu no man mandi nanga unu. Ma Mi den no man si na ai, fu di Mi e taigi den tak' na ogri den e du. ");
INSERT INTO srnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Un kan go na a fesa. Mi no e go, bika a yuru fu Mi no doro ete.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Di A taigi den dati, A tan na Galilea. ");
INSERT INTO srnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Baka di den brada fu En go na a fesa, Yesus srefi go tu. Ma A go kibrifasi fu no wan sma sabi. ");
INSERT INTO srnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Den fesiman fu den Dyu ben e luku fu En tapu a fesa, èn den ben e aksi pe A de. ");
INSERT INTO srnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Den furu sma di ben drape ben e taki saf'safri fu En. Sonwan ben e taki tak' Yesus na wan bun sma, ma trawan ben feni tak' na kori A e kori den sma. ");
INSERT INTO srnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma no wan sma ben prefuru fu taki fu En meki ala sma yere, bika den ben frede den fesiman fu den Dyu. ");
INSERT INTO srnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Di afu fu den dei fu a fesa ben psa kba, Yesus go na a mamakerki dan A bigin gi den sma leri. ");
INSERT INTO srnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Den fesiman fu den Dyu ben ferwondru, èn den aksi taki: “Fa a Man disi du sabi someni sani sondro fu A kisi leri?” ");
INSERT INTO srnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus piki den taki: “Den sani di Mi e leri no kmoto fu Misrefi, ma fu a Wan di seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Efu wan sma wani du a wani fu Gado, dan a sa kon sabi efu a leri san Mi e gi, kmoto fu Gado noso efu Mi kon nanga Mi eigi leri. ");
INSERT INTO srnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Efu wan sma kon nanga en eigi leri, a e suku grani gi ensrefi. Ma a sma di e suku grani gi a wan di seni en kon, de fu fertrow èn a no e lei. ");
INSERT INTO srnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ben gi unu a wèt, ma no wan fu unu e du san a wèt e taki. Fu sanede un wani kiri Mi?” ");
INSERT INTO srnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Den sma taigi En taki: “Suma wani kiri Yu? Na wan takruyeye Yu abi na Yu tapu!” ");
INSERT INTO srnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus piki den taki: “Mi du wan wondru nomo, dan un alamala ferwondru. ");
INSERT INTO srnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Luku, Moses ben taigi un tak' un mus besnei den boi fu unu. A sani disi no ben kmoto fu ensrefi, ma fu den afo fu wi. Dat' meki un e besnei, awinsi na wan sabadei. ");
INSERT INTO srnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Efu un e besnei tapu a sabadei fu no broko a wèt fu Moses, dan fu sanede un ati e bron na Mi tapu fu di Mi meki wan sma kon betre tapu a sabadei? ");
INSERT INTO srnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Un no mus krutu wan sma fu san un si, ma un mus krutu tapu wan leti fasi.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sonwan fu den sma fu Yerusalem aksi taki: “A no En na a man di den wani kiri? ");
INSERT INTO srnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Luku, A e gi leri na ala sma fesi, èn no wan sma e taigi En wan sani. Kande den edeman kon si now trutru tak' En na a Mesias. ");
INSERT INTO srnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Un sabi pe a man disi kmoto, ma te a Mesias kon, no wan sma o sabi pe A kmoto.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dat' meki di Yesus ben e leri den sma ini a mamakerki, A bari taki: “Un sabi Mi èn un sabi pe Mi kmoto. Ma Mi no kon ini Mi eigi nen. Na a Trutru Wan seni Mi kon. Un no sabi En, ");
INSERT INTO srnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ma Mi sabi En, bika Mi kmopo na En èn na En seni Mi kon.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Di den yere dati, den suku fu grabu En. Ma no wan sma no fasi En, bika a yuru fu En no ben doro ete. ");
INSERT INTO srnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma furu fu den sma bigin bribi ini En. Den taki: “Te a Mesias kon, A o man meki un si moro marki leki a man disi?” ");
INSERT INTO srnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Den Fariseiman yere san den sma ben e taki saf'safri fu Yesus. Dat' meki den nanga den prenspari domri seni waktiman fu a mamakerki fu go grabu En. ");
INSERT INTO srnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Dan Yesus taki: “Wan syatu pisten nomo Mi o de ete nanga unu, dan Mi o drai go baka na a Wan di ben seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Un o suku Mi, ma un no o feni Mi. Bika pe Mi de, un no man kon.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Den fesiman fu den Dyu aksi makandra taki: “Pe a man disi o go dan, tak' un no o man feni En? Kande A o go na den Dyusma di panya go na tra kondre, dan A o gi den sma drape di no sabi Gado a leri fu En. ");
INSERT INTO srnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A taki tak' wi o suku En, ma un no o feni En, èn pe A de, un no man kon. San A wani taki nanga a sani dati?” ");
INSERT INTO srnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","A laste dei fu a Sukotfesa na a moro bigi dei. A dei dati Yesus opo tnapu dan A bari taki: “Efu watra e kiri wan sma, meki a kon na Mi fu dringi! ");
INSERT INTO srnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","A Santa Buku e taki: Liba fu watra di e gi libi, o lon kmoto inisei fu a sma di e bribi ini Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Di Yesus taki a sani dati, A ben e taki fu a Santa Yeye san den sma bo kisi di teki bribi ini En. Bika te leki a ten dati a Santa Yeye no ben kon ete, fu di Yesus no ben go na heimel ete. ");
INSERT INTO srnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Di den sma yere san Yesus taki, sonwan fu den taki: “Trutru, a man disi na a Profeiti!” ");
INSERT INTO srnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Trawan taki: “Disi na a Mesias!” Trawan baka taki: “A Mesias no o kmoto fu Galilea. ");
INSERT INTO srnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bika a Santa Buku e taki tak' a Mesias o de wan bakapikin fu David, èn A o kmoto fu Betlehem, a foto pe David ben e libi.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Na so prati ben kon mindri den sma fu Yesus ede. ");
INSERT INTO srnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sonwan fu den ben wani grabu En, ma no wan sma no fasi En. ");
INSERT INTO srnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Den waktiman drai go baka na den prenspari domri nanga den Fariseiman, dan den man dati aksi den taki: “Sanede un no tyari En kon?” ");
INSERT INTO srnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Den waktiman piki den taki: “Noiti ete wan man taki leki fa a man disi e taki.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dan den Fariseiman taigi den taki: “Na drai A drai un ede tu? ");
INSERT INTO srnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","No wan edeman fu unu èn no wan fu den Fariseiman e bribi ini En. ");
INSERT INTO srnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ma Gado sa fluku ala den sma disi di no sabi a wèt fu Moses!” ");
INSERT INTO srnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dan Nikodemus, wan fu den Fariseiman di ben kon wan leisi na Yesus, taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“A wèt fu unu e taki tak' un no kan leisi strafu gi wan sma efu un no arki fosi san a e taki èn ondrosuku san a e du.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Den piki en taki: “Yu na fu Galilea tu? Go ondrosuku Gadowortu, dan yu o si tak' no wan profeiti e kmoto fu Galilea.” ");
INSERT INTO srnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Baka dati ala sma go na den oso, ");
INSERT INTO srnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ma Yesus go na a Oleifbergi. ");
INSERT INTO srnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","A tra mamanten fruk'fruku A go baka na a mamakerki èn a heri folku kon na En. Dan Yesus go sidon èn A bigin gi den leri. ");
INSERT INTO srnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dan den sabiman fu Gado wèt nanga den Fariseiman tyari wan frow kon di den kisi di a ben e huru gi en masra. Den poti en mindri den sma di ben lontu Yesus, ");
INSERT INTO srnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","dan den taigi En taki: “Meister, den kisi a uma disi di a ben e huru gi en masra. ");
INSERT INTO srnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A wèt fu Moses e leri un tak' un mus ston sowan sma kiri. San Yu e taki fu a sani disi?” ");
INSERT INTO srnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Den ben aksi En a sani disi fu tesi En, fu di den ben e suku wan sani fu tyari En go na krutu. Ma Yesus boigi En ede, dan A bigin skrifi nanga En finga na gron. ");
INSERT INTO srnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Di den tan aksi En nomo, Yesus opo En ede dan A taigi den taki: “Meki a sma di noiti no du wan sondu, fringi a fosi ston naki en.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dan A saka En ede, èn A bigin skrifi na gron baka. ");
INSERT INTO srnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma di den yere dati, den gwe wan fru wan, te leki Yesus nanga a frow wawan ben tan na baka. Den owru wan ben de den fosi wan di gwe. ");
INSERT INTO srnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesus opo En ede dan A aksi a frow taki: “Frow, pe den man de? No wan fu den no krutu Yu?” ");
INSERT INTO srnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A frow piki taki: “Nono, Masra. No wan fu den.” Ne Yesus taigi en taki: “Dan Mi no e krutu yu tu. Yu kan go, ma yu mus tapu nanga a sondu libi.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wan tra leisi Yesus taigi den sma taki: “Mi na a faya fu grontapu. A sma di e waka na Mi baka, no sa waka ini dungru noiti moro, ma a sa abi a faya di e gi libi.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dan den Fariseiman taigi En taki: “Yu e taki gi Yusrefi. A sani san Yu taki no abi warti.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus piki den taki: “Awinsi Mi e taki gi Misrefi, a abi warti, bika Mi sabi pe Mi kmopo èn pe Mi o go. Ma un dati no sabi pe Mi kmopo noso pe Mi o go. ");
INSERT INTO srnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Un e krutu libisma fasi. Ma Mi no e krutu no wan sma. ");
INSERT INTO srnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma efu Mi e krutu wan sma, dan Mi e krutu tapu wan leti fasi. Bika Mi no de Mi wawan, ma a P'pa di seni Mi kon de nanga Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na ini un eigi wèt a skrifi taki: Efu tu sma e kotoigi fu wan sani, dan a sani tru. ");
INSERT INTO srnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mi e taki gi Misrefi, èn Mi P'pa di seni Mi kon, e taki fu Mi tu.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dan den aksi En taki: “Pe Yu P'pa de?” Yesus piki den taki: “Un no sabi Mi èn un no sabi Mi P'pa. Efu un ben sabi Mi, dan un bo sabi Mi P'pa tu.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesus taki den sani disi di A ben e gi den sma leri ini a mamakerki pe a kisi de pe yu mus poti moni. ");
INSERT INTO srnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Dan Yesus bigin taki baka nanga den sma. A taigi den taki: “Mi e gwe èn un o suku Mi. Un o dede sondro fu un kisi pardon fu un sondu. Pe Mi e go, un no man kon.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A sani disi meki den Dyusma taki: “Fu sanede A taki: ‘Pe Mi e go, un no man kon?’ Na kiri A o kiri Ensrefi?” ");
INSERT INTO srnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma Yesus taigi den taki: “Unu na fu dya, ma Mi na fu loktu. Unu na fu a grontapu disi, ma Mi a no fu a grontapu disi. ");
INSERT INTO srnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mi taigi un kba tak' un o dede sondro fu un kisi pardon fu un sondu. Bika efu un no e bribi tak' Mi de suma Mi de, dan un o dede ini un sondu.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dan den aksi En taki: “Suma na Yu dan?” Yesus piki den taki: “Na dati Mi taigi unu someni langa kba. ");
INSERT INTO srnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mi abi furu sani san Mi kan taki fu unu, nanga furu sani fu san Mi kan krutu unu. A Wan di seni Mi kon, na a Trutru Wan. Èn san Mi yere fu En, na dati Mi e taigi den sma na grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma den no ben ferstan tak' Yesus ben e taki nanga den fu a P'pa. ");
INSERT INTO srnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dan Yesus taigi den taki: “Baka te un opo a Manpikin fu Libisma na loktu, dan un o si tak' na Mi. Dan un o si tak' Mi no e du noti fu Misrefi, ma tak' Mi e taki soso san Mi P'pa leri Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A Wan di seni Mi kon de nanga Mi. A no libi Mi wawan, bika Mi e tan du san A lobi.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Di Yesus taki den sani disi, furu sma bigin bribi ini En. ");
INSERT INTO srnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dan Yesus taigi den Dyu di bribi ini En taki: “Efu un e tan du san Mi taki, dan un o de trutru sma fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Dan un sa sabi san na tru, èn na dati o meki un kon fri.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ma den sma taigi En taki: “Un na bakapikin fu Abraham. Noiti un ben de srafu fu wan sma. Fa Yu kan taki dan tak' un sa kon fri?” ");
INSERT INTO srnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesus piki den taki: “Fu tru Mi e taigi unu: Ibri sma di e sondu, na wan srafu fu sondu. ");
INSERT INTO srnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wan srafu no e tan fu têgo ini a famiri, ma a manpikin e tan fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Fu dat'ede efu a Manpikin meki un kon fri, dan un o fri fu tru. ");
INSERT INTO srnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi sabi tak' un na bakapikin fu Abraham. Ma un e suku fu kiri Mi, fu di un no wani teki san Mi e taki. ");
INSERT INTO srnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mi e ferteri unu san Mi si na Mi P'pa, ma unu e du san un yere fu un p'pa.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Den piki En taki: “Abraham na wi p'pa.” Yesus piki den baka taki: “Efu un ben de pikin fu Abraham, dan un bo du den sani san Abraham ben e du. ");
INSERT INTO srnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma now un e suku fu kiri Mi, Mi di ferteri unu den tru sani san Mi yere fu Gado. Abraham no bo du sowan sani. ");
INSERT INTO srnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ma unu e du san un p'pa e du.” Den taigi En now taki: “Na Gado wawan na wi P'pa. Wi a no doroseipikin.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesus taigi den taki: “Efu Gado ben de un P'pa, dan un bo lobi Mi, bika Mi kmopo fu Gado. Mi no kon fu Misrefi, ma na En seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Un sabi fu sanede un no e ferstan san Mi e taigi unu? Na fu di un no man teki san Mi e taki. ");
INSERT INTO srnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Didibri na un p'pa, èn un lobi fu du san a wani. Sensi na a bigin a de wan kiriman. A no man taki wan sani san tru, bika a no sabi san na tru. Te a e lei, a e taki leki fa en srefi de, bika a de wan leiman èn na en meki lei. ");
INSERT INTO srnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma fu di Mi e taki san na tru, meki un no e bribi Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Suma kan sori tak' Mi du wan sondu? Efu Mi e taki san tru, fu sanede un no e bribi Mi dan? ");
INSERT INTO srnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","A sma di de fu Gado, e arki san Gado e taki. Ma unu a no sma fu Gado, dat' meki un no e arki.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Den Dyusma taigi Yesus taki: “Un ben abi leti di un taki tak' Yu na wan Samariasma èn tak' Yu abi wan takruyeye na Yu tapu!” ");
INSERT INTO srnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ma Yesus piki den taki: “Mi no abi no wan takruyeye na Mi tapu. Mi e gi Mi P'pa grani, ma unu e broko Mi saka. ");
INSERT INTO srnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mi no e suku grani gi Misrefi. Wan Trawan de di e suku grani gi Mi, èn na En e krutu libisma. ");
INSERT INTO srnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Fu tru Mi e taigi un taki: A sma di e du san Mi taki, no sa dede noiti.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dan den Dyusma taigi En taki: “Now wi sabi trutru tak' Yu abi wan takruyeye na Yu tapu. Abraham nanga den profeiti dede. Ma Yu e taki tak' a sma di e du san Yu taki, no sa dede noiti. ");
INSERT INTO srnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yu denki tak' Yu bigi moro un afo Abraham? A dede, èn den profeiti srefi dede tu. San Yu e prakseri fu Yusrefi?” ");
INSERT INTO srnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus piki den taki: “Efu Mi e suku grani gi Misrefi, dan a no abi warti. A Wan di e gi Mi grani na Mi P'pa. Un e kari En un Gado, ");
INSERT INTO srnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ma un no sabi En. Mi sabi En, èn efu Mi ben sa taki tak' Mi no sabi En, dan Mi bo de wan leiman leki unu. Ma Mi sabi En èn Mi e du san A wani. ");
INSERT INTO srnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Un afo Abraham ben wakti nanga prisiri fu si a dei fu Mi. A si a dei dati èn a ben breiti.” ");
INSERT INTO srnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dan den Dyu taki: “Fa a kan tak' Yu si Abraham? Yu no abi feifitenti yari ete!” ");
INSERT INTO srnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus piki den taki: “Fu tru Mi e taigi un taki: Fosi Abraham gebore, Mi ben de!” ");
INSERT INTO srnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dan den sma teki ston fu fringi na En tapu, ma Yesus kibri fu den no si En, dan A kmoto ini a mamakerki. ");
INSERT INTO srnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Di Yesus e gwe moro fara, A si wan man di ben breni sensi a gebore. ");
INSERT INTO srnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dan den man fu En aksi En taki: “Meister, fu sanede a man disi gebore so? Na fu di a sondu, noso fu di en m'ma nanga en p'pa sondu?” ");
INSERT INTO srnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus piki den taki: “A no den sondu fu en, noso di fu en m'ma nanga en p'pa, meki a breni. Ma a sani disi psa fu sma kan si san Gado kan du gi en. ");
INSERT INTO srnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Solanga dei krin ete, wi mus du den wroko fu a Wan di seni Mi kon. Bika neti yuru e kon, dan no wan sma no o man wroko. ");
INSERT INTO srnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Solanga Mi de na grontapu, Mi na a faya fu grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Baka di Yesus taki a sani disi, A spiti na gron, A meki tokotoko fu en, dan A lobi a tokotoko gi den ai fu a man. ");
INSERT INTO srnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dan A taigi en taki: “Go wasi yusrefi ini a watra fu Siloam.” (Siloam wani taki: Seni.) Dan a man go wasi ensrefi. Di a e drai kon baka, a ben e si. ");
INSERT INTO srnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Den sma fu en birti, nanga trawan di ben sabi en leki wan begiman, aksi taki: “A no a man disi ben e sidon e begi moni?” ");
INSERT INTO srnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sonwan fu den taki: “Na en.” Trawan taki: “No, ma a gersi en.” Ne a man srefi taki: “Na mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dan den aksi en taki: “Fa a du kon dan tak' yu e si now?” ");
INSERT INTO srnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A piki den taki: “A man di den e kari Yesus, meki tokotoko lobi gi mi ai, dan A taigi mi fu go wasi misrefi ini a watra fu Siloam. So mi go wasi misrefi, dan mi ben kan si.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dan den sma aksi en taki: “Pe A de now?” A man piki taki: “Mi no sabi.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dan den tyari a man di ben breni go na den Fariseiman. ");
INSERT INTO srnNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A dei di Yesus meki a tokotoko dresi a man ai, ben de wan sabadei. ");
INSERT INTO srnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Dan den Fariseiman srefi aksi a man fa a du kon tak' a kan si. A man taigi den taki: “Yesus lobi tokotoko gi mi ai. Dan mi go wasi misrefi, èn now mi kan si.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dan sonwan fu den Fariseiman taki: “A no Gado seni a man disi kon, bika A no e hori a sabadei.” Ma trawan taki: “Fa wan sondusma kan du den marki disi?” A sani disi tyari prati kon na den mindri. ");
INSERT INTO srnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dan den aksi a breniman baka taki: “San yu e taki fu En? Na yu ai A dresi!” A man piki den taki: “En na wan profeiti.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Den fesiman fu den Dyu no ben wani bribi tak' a man ben breni, ma tak' a e si now, te leki den seni kari en m'ma nanga en p'pa kon. ");
INSERT INTO srnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Den aksi den taki: “A man disi na yu manpikin? A tru tak' a ben breni di a gebore? Fa a du kon tak' a e si now?” ");
INSERT INTO srnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Den piki taki: “Wi sabi tak' a man disi na wi manpikin èn tak' a ben breni sensi a gebore. ");
INSERT INTO srnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma fa a du kon tak' a e si now, wi no sabi. Èn wi no sabi tu suma dresi en ai fu a si. Aksi en, a bigi nofo fu taki gi ensrefi.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A m'ma nanga a p'pa taki so fu di den ben e frede den fesiman fu den Dyu. Bika den man dati ben meki mofo kba tak' efu wan sma sa taki tak' Yesus na a Mesias, den bo puru a sma dati ini a Dyukerki. ");
INSERT INTO srnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Fu dat'ede a m'ma nanga a p'pa piki den taki: “A bigi nofo. Aksi en.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","So den seni kari a breniman baka, dan den taigi en taki: “Gi Gado a grani! Bika un sabi tak' a man disi na wan sondusma.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A man piki den taki: “Efu a man na wan sondusma, dati mi no sabi. Ma wan sani mi sabi: Mi ben breni, ma now mi e si!” ");
INSERT INTO srnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Den man aksi en taki: “San A du nanga yu? Fa A du meki yu si?” ");
INSERT INTO srnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A piki den taki: “Mi taigi un kba, ma un no arki. Sanede un wani yere a sani ete wan leisi? Na tron un wani tron bakaman fu En tu?” ");
INSERT INTO srnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ne den kosi en, dan den taigi en taki: “Yu na wan bakaman fu En, ma wi na bakaman fu Moses. ");
INSERT INTO srnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Un sabi tak' Gado ben taki nanga Moses. Ma un no sabi pe a man disi kmoto.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dan a man piki den taki: “Na wan ferwondru sani tak' A dresi mi ai, ma un no sabi pe A kmoto. ");
INSERT INTO srnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wi sabi tak' Gado no e arki sondusma. Ma A e arki den sma di e lespeki En èn di e du san A wani. ");
INSERT INTO srnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Noiti a psa ete tak' wan sma opo den ai fu wan sma di gebore breni. ");
INSERT INTO srnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Efu a man disi no ben kmoto fu Gado, A no bo man du noti.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Den piki a man taki: “Yu gebore ini sondu, dan yu wani kon gi un leri?” Dan den yagi en gwe. ");
INSERT INTO srnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus ben kisi fu yere tak' den yagi a man. So di A miti en, A aksi en taki: “Yu e bribi ini a Manpikin fu Libisma?” ");
INSERT INTO srnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A man piki taki: “Masra, taigi mi suma na En, fu mi kan go bribi ini En.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus piki en taki: “Yu si En kba. Na a Wan di e taki nanga yu.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ne a man taki: “Masra, mi e bribi.” Dan a anbegi En. ");
INSERT INTO srnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Dan Yesus taki: “Mi kon na grontapu fu koti a krutu disi: Brenisma o kon si èn den sma di e si, o kon breni.” ");
INSERT INTO srnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wantu Fariseiman di ben drape nanga En, yere san A taki. Dan den aksi En taki: “Yu wani taigi un tak' un breni tu?” ");
INSERT INTO srnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesus piki den taki: “Efu un ben breni, dan un no bo abi sondu. Ma fu di un taki tak' un e si, meki un no e kisi pardon fu un sondu.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Fu tru Mi e taigi un taki: A sma di no psa na a doro fu kon ini a skapupen, ma di kren wan tra presi kon inisei, na wan fufuruman nanga wan abani. ");
INSERT INTO srnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A sma di e psa na a doro fu kon inisei, na a skapuman. ");
INSERT INTO srnNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A waktiman e opo a doro gi en, èn den skapu e arki en sten. A e kari den skapu fu en na den nen, èn a e tyari den go na dorosei. ");
INSERT INTO srnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Baka te a tyari ala den skapu fu en go na dorosei, a e waka na den fesi, dan den skapu e waka kon na en baka, bika den sabi en sten. ");
INSERT INTO srnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma den no bo waka baka wan sma di den no sabi. Den bo lon gwe fu di den no sabi en sten.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus ferteri den a agersitori disi, ma den no ben ferstan san A ben wani taki. ");
INSERT INTO srnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Dat' meki A taigi den baka taki: “Fu tru Mi e taigi unu: Mi na a doro fu den skapu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ala sma di ben kon na Mi fesi na fufuruman nanga abani, ma den skapu no arki den. ");
INSERT INTO srnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mi na a doro. Efu wan sma psa na Mi kon inisei, Mi sa ferlusu en. A sa go kon èn a sa feni nyanyan. ");
INSERT INTO srnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A fufuruman e kon soso fu fufuru, fu kiri, èn fu pori sani. Mi kon fu gi sma libi, èn fu sorgu tak' den abi en bogobogo. ");
INSERT INTO srnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mi na a bun skapuman. A bun skapuman de klari fu dede gi den skapu fu en. ");
INSERT INTO srnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma wan wrokoman di den yuru fu luku den skapu, no de leki a skapuman di abi den skapu. Te a si tak' wan tigri e kon, a e libi den skapu dan a lon gwe. So a tigri kan grabu wan skapu, dan a panya den trawan. ");
INSERT INTO srnNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A wrokoman e lon gwe bika na yuru den ben yuru en, èn a no abi firi gi den skapu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mi na a bun skapuman. Mi sabi den skapu fu Mi èn den skapu sabi Mi, ");
INSERT INTO srnNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","soleki fa a P'pa sabi Mi èn Mi sabi a P'pa. Èn Mi de klari fu dede gi den skapu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mi abi tra skapu tu san no de fu a skapupen disi. Mi mus tyari den kon tu. Den o arki Mi sten, dan den tu grupu skapu o tron wán, èn den o abi wán skapuman. ");
INSERT INTO srnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mi P'pa lobi Mi bika Mi e gi Mi libi abra fu dede, fu Mi teki en baka. ");
INSERT INTO srnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","No wan sma e teki Mi libi. Na Mi srefi e gi en abra. Mi abi makti fu gi Mi libi abra, èn Mi abi makti fu teki en baka. Disi na san Mi P'pa ben taigi Mi tak' Mi mus du.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Di Yesus taki den sani disi, wan prati kon baka na mindri den Dyu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Furu fu den taki: “Un no mus arki a man disi. A law èn A abi wan takruyeye na En tapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma trawan fu den taki: “Wan sma di abi wan takruyeye na en tapu, no e taki leki fa a man disi e taki. Èn wan takruyeye no man meki wan brenisma si baka.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A ben de a kowruten èn a ben de a ten fu a Hanukafesa na ini Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus ben e waka ini a mamakerki na a presi di den kari a Gadri fu Salomo. ");
INSERT INTO srnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Den fesiman fu den Dyu kon lontu En dan den taigi En taki: “Olanga Yu o hori unu ini a span ete? Taigi unu krin efu Yu na a Mesias.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesus piki den taki: “Mi taigi unu kba, ma un no e bribi. Den wondru san Mi e du ini a nen fu Mi P'pa e sori suma na Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma un no e bribi, bika unu a no skapu fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Den skapu fu Mi e arki Mi sten. Mi sabi den, èn den e waka na Mi baka. ");
INSERT INTO srnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi e gi den a libi fu têgo, èn noiti den o go lasi. No wan sma o man hari den puru na Mi anu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mi P'pa di gi Mi den, bigi moro ala sani. Èn no wan sma kan hari den puru na En anu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mi nanga a P'pa na wan.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dan den Dyu teki ston baka fu fringi na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma Yesus taigi den taki: “Mi meki un si someni bun wroko di Mi P'pa meki Mi du. Fu sortu wan fu den un wani ston Mi kiri?” ");
INSERT INTO srnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Den piki En taki: “A no fu wan bun wroko un wani ston Yu kiri, ma fu di Yu afrontu Gado. Bika Yu leki wan libisma e taki tak' Yu na Gado.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesus piki den baka taki: “A skrifi ini a wèt fu unu taki: ‘Mi taki tak' un na gado.’ ");
INSERT INTO srnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Un sabi tak' san skrifi ini a Santa Buku tan skrifi. So efu Gado kari den sma di yere En wortu ‘gado,’ ");
INSERT INTO srnNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","fa un kan taki tak' Mi e afrontu Gado fu di Mi taki tak' Mi na a Manpikin fu Gado? Na Gado poti Mi aparti dan A seni Mi kon na grontapu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Efu Mi no e du den wroko fu Mi P'pa, dan un no abi fu bribi Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma efu na dati Mi e du, dan un mus bribi den wroko, awinsi un no wani bribi Mi. Dan un o kon sabi krin tak' Mi P'pa de ini Mi, èn Mi de ini Mi P'pa.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dan den pruberi fu grabu En baka, ma den no feni En fu grabu. ");
INSERT INTO srnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Dan Yesus abra go baka na a tra sei fu a Yordanliba, na a presi pe Yohanes ben bigin dopu sma, dan A tan drape. ");
INSERT INTO srnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Furu sma kon na En. Den taki: “Yohanes no meki un si no wan marki. Ma ala san a ben taki fu a man disi kon tru.” ");
INSERT INTO srnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dan furu fu den sma drape bribi na ini Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wan man Lasarus ben e siki. A ben de fu a dorpu Betania, pe Maria nanga en sisa Marta ben e libi. ");
INSERT INTO srnNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","A Maria disi na a uma di ben kanti a switismeri-oli tapu Yesus, dan a drei den futu fu En nanga en edewiwiri. Na en brada Lasarus ben e siki. ");
INSERT INTO srnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","So den tu sisa seni boskopu gi Yesus taki: “Masra, a wan di Yu lobi so, e siki.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Di Yesus kisi a boskopu, A taki: “Dede a no a kba fu a siki disi, ma a psa fu Gado nanga En Manpikin kisi grani.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus ben lobi Marta, nanga en sisa, nanga Lasarus. ");
INSERT INTO srnNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ma di A yere tak' Lasarus e siki, A tan ete tu dei na a presi pe A ben de. ");
INSERT INTO srnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Baka den tu dei, A taigi den man fu En taki: “Kon meki un drai go baka na Yudea.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ne den man fu En taki: “Ma Meister, a no langa di den Dyu ben wani ston Yu kiri. Dan Yu wani drai go drape baka?” ");
INSERT INTO srnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesus piki den taki: “Twarfu yuru fu wan dei na deiten. Efu wan sma e waka deiten, a no e stotu en futu, bika a e si pe a e go. ");
INSERT INTO srnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma efu a e waka neti yuru, a e stotu en futu, bika ensrefi no abi faya.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Baka di Yesus taki a sani disi, A taigi den moro fara taki: “Un mati Lasarus e sribi, ma Mi e go wiki en.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dan den man fu En taigi En taki: “Ma Masra, efu a e sribi dan a o kon betre baka.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","San Yesus ben wani taki, na tak' Lasarus dede. Ma den man fu En ben ferstan tak' na sribi Lasarus e sribi. ");
INSERT INTO srnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ne A taigi den krin taki: “Lasarus dede. ");
INSERT INTO srnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma Mi breiti gi unu tak' Mi no ben drape, bika now a bribi fu unu kan kon moro tranga. Kon meki un go na en.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Wan fu den man fu Yesus di ben nen Tomas, ma den ben e kari en Didimus tu, taigi den trawan taki: “Kon meki un go, dan un dede nanga En.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Di Yesus doro, A kisi fu yere tak' Lasarus ben beri fo dei kba. ");
INSERT INTO srnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania ben de krosbei fu Yerusalem, a no ben doro dri kilometer srefi. ");
INSERT INTO srnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Furu fu den Dyusma ben kon na Marta nanga Maria fu trowstu den fu di den lasi den brada. ");
INSERT INTO srnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Di Marta yere tak' Yesus e kon, a waka go miti En. Ma Maria tan sidon na oso. ");
INSERT INTO srnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Dan Marta taigi Yesus taki: “Masra, efu Yu ben dya, mi brada no bo dede. ");
INSERT INTO srnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma aladi a dede kba, mi sabi tak' Gado o gi Yu ala san Yu e aksi En.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dan Yesus taigi en taki: “Yu brada o kon na libi baka.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta piki taki: “Mi sabi tak' a o kon na libi baka tapu a laste dei, te ala dedesma o opo baka.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus taki: “Na Mi e wiki dede èn na Mi e gi libi. A sma di e bribi na ini Mi sa libi, awinsi a dede. ");
INSERT INTO srnNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Èn iniwan sma di e libi èn di e bribi na ini Mi, no sa dede noiti moro. Yu e bribi dati?” ");
INSERT INTO srnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta piki En taki: “Iya Masra, mi e bribi tak' Yu na a Mesias, a Manpikin fu Gado di bo kon na grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Di Marta taki disi, a drai go kari en sisa Maria, dan a taigi en saf'safri taki: “A Meister doro. A seni kari yu.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Di Maria yere dati, a opo wantron go na Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesus no ben doro ini a dorpu ete. A ben tnapu ete pe Marta ben miti En. ");
INSERT INTO srnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Den Dyu di ben de nanga Maria ini a oso fu trowstu en, si fa a opo es'esi go na dorosei, dan den waka go na en baka. Den ben prakseri tak' na krei a e go krei na a grebi. ");
INSERT INTO srnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Di Maria doro pe Yesus ben de èn a si En, a fadon tapu en kindi na En futu, dan a taki: “Masra, efu Yu ben dya, mi brada no bo dede.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Di Yesus si fa Maria nanga den Dyu di kon nanga en e krei, A soktu dipi. Dan nanga dipi sari ");
INSERT INTO srnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A aksi den taki: “Pe un beri en?” Den piki En taki: “Masra, kon meki un sori Yu.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dan Yesus krei. ");
INSERT INTO srnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ne den Dyusma taki: “Ai, yu kan si tak' A ben lobi en.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma sonwan fu den taki: “Efu a Man disi ben man meki a breniman si baka, fa A no ben kan meki a man disi no dede?” ");
INSERT INTO srnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus soktu baka dan A waka go na a grebi. A ben de wan bergi-olo èn a mofo fu en ben tapu nanga wan ston. ");
INSERT INTO srnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dan Yesus taki: “Puru a ston!” Ma Marta, a sisa fu a wan di dede, taki: “Masra, a musu e smeri, bika na fo dei a dede kba.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma Yesus taigi en taki: “Mi no taigi yu tak' efu yu e bribi, yu o si a glori fu Gado?” ");
INSERT INTO srnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","So den puru a ston. Dan Yesus opo En ai go na loktu, A taki: “Mi P'pa, Mi e taki Yu tangi tak' Yu piki Mi begi. ");
INSERT INTO srnNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mi sabi tak' ala leisi Yu e piki Mi begi. Ma Mi e taki so fu den sma ede di tnapu lontu Mi, fu den bribi tak' na Yu seni Mi kon.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Baka di Yesus begi, A bari taki: “Lasarus, kon na dorosei!” ");
INSERT INTO srnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dan a man di ben dede kon na dorosei. En anu nanga en futu ben domru nanga dedekrosi èn en ede ben domru nanga wan anyisa. Dan Yesus taigi den taki: “Puru den sani na en skin, meki a go.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Furu fu den Dyusma di ben kon na Maria, bribi ini Yesus di den si san A du. ");
INSERT INTO srnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma wantu fu den go ferteri den Fariseiman san Yesus du. ");
INSERT INTO srnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Dan den prenspari domri nanga den Fariseiman kari a Grankrutu fu den Dyu kon na wan. Den aksi den taki: “San wi o du nanga a man disi, bika A e sori den sma someni marki. ");
INSERT INTO srnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Efu wi libi En meki A du san A wani, ala sma o bribi ini En. Dan den Romeinisma o kon broko a presi disi èn den o yagi a pipel.” ");
INSERT INTO srnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wan fu den man ben nen Kayafas. Na en ben de grandomri a yari dati. A taigi den taki: “Un no sabi noti! ");
INSERT INTO srnNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na ferstan un no man ferstan tak' a moro bun gi unu tak' wan man nomo dede gi a pipel, prefu ala sma dede?” ");
INSERT INTO srnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafas no ben taki a sani disi fu ensrefi, ma leki grandomri fu a yari dati, a ben e taki na fesi tak' Yesus bo dede gi a pipel fu Israel. ");
INSERT INTO srnNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma a no gi den wawan. A bo dede tu gi den tra pikin fu Gado di panya na grontapu, fu tyari den kon na wan. ");
INSERT INTO srnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bigin fu a dei dati den bigin kruderi fa den bo man kiri Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dat' meki Yesus no ben e waka fri moro na mindri den Dyu. A go na a foto Efraim, san de ini wan kontren krosbei fu a dreisabana. Dan A tan drape nanga den man fu En. ");
INSERT INTO srnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A Paskafesa fu den Dyu ben de krosbei. Dat' meki furu sma ben e hari kmopo fu den boiti presi go na Yerusalem, fu meki densrefi klari gi a Paskafesa fosi a bigin. ");
INSERT INTO srnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Den sma ben e luku efu den bo si Yesus. Di den ben de ini a mamakerki, a wan ben e aksi a trawan taki: “Yu prakseri tak' Yesus o kon na a fesa?” ");
INSERT INTO srnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bika den prenspari domri nanga den Fariseiman ben taigi den sma tak' efu den sabi pe Yesus de, dan den mus fu kon taigi den, fu den kan grabu En. ");
INSERT INTO srnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Siksi dei fosi a Paskafesa, Yesus doro na Betania pe Lasarus ben e tan, di A ben meki kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Drape den hori wan fesa gi Yesus. Marta ben e yepi nanga nyansani èn Lasarus ben de wan fu den sma di ben de na tafra nanga En. ");
INSERT INTO srnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Dan Maria teki wan afu liter diri switismeri-oli san ben meki fu nardus rutu. A kanti a oli na Yesus futu dan a drei den nanga en edewiwiri. A switi smeri fu a oli panya ini a heri oso. ");
INSERT INTO srnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ne Yudas Iskariot, a man fu Yesus di bo seri En bakaten, taki: ");
INSERT INTO srnNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Fu sanede un no seri a oli disi gi dri hondro solfrumoni, dan un prati a moni gi pôtisma?” ");
INSERT INTO srnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A no taki disi fu di a ben prakseri den pôtisma, ma fu di a ben de wan fufuruman. Na en ben hori a moni, èn a ben gwenti fu teki gi ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dan Yesus taki: “Un libi en. A ben kibri a oli disi fu meki Mi klari fu Mi beri. ");
INSERT INTO srnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pôtisma de ala ten nanga unu, ma Mi no o de ala ten nanga unu.” ");
INSERT INTO srnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wan bigi grupu Dyusma ben kon yere tak' Yesus de na Betania. So den go drape, ma a no fu Yesus wawan. Den ben wani si Lasarus tu, di A ben meki kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Dan den prenspari domri meki mofo fu kiri Lasarus tu, ");
INSERT INTO srnNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","bika fu en ede furu fu den Dyu ben libi den, dan den bribi ini Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","A tra dei fu en a bigi grupu sma di ben kon na a fesa yere tak' Yesus e kon na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","So den koti palmtaki, dan den waka go miti En. Den ben e bari taki: Hosana! Blesi de tapu a Wan di e kon ini a nen fu Masra! Blesi fu a Kownu fu Israel! ");
INSERT INTO srnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus si wan yongu buriki, dan A go sidon na en tapu. A psa leki fa a skrifi taki: ");
INSERT INTO srnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Sma fu Yerusalem, no frede! Luku, yu Kownu e kon. A e sidon tapu wan yongu buriki. ");
INSERT INTO srnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Di den sani disi psa, den man fu Yesus no ben ferstan ete san den ben wani taki. Ma baka di Yesus opo go na heimel, dan fosi den memre tak' den sani disi ben skrifi fu En, èn tak' den du den sani disi nanga En. ");
INSERT INTO srnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Di Yesus kari Lasarus kmoto fu a grebi meki a kon na libi baka, wan bigi grupu sma ben drape. Den sma dati ben e ferteri trawan fu a sani disi. ");
INSERT INTO srnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Fu dat'ede furu sma waka go miti En, bika den ben yere fu a marki san A ben meki den sma si. ");
INSERT INTO srnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ne den Fariseiman taigi makandra taki: “Un e si tak' noti san un du e yepi. Luku, heri grontapu e waka na En baka!” ");
INSERT INTO srnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na mindri den sma di ben go fu anbegi Gado na a Paskafesa, yu ben abi wantu Grikisma. ");
INSERT INTO srnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Den man disi go na Filipus, di ben kmoto fu Betsaida ini Galilea, dan den aksi en taki: “Masra, un wani si Yesus.” ");
INSERT INTO srnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dan Filipus go taigi Andreas, dan den ala tu go taigi Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus piki den taki: “A yuru doro tak' a Manpikin fu Libisma mus kisi grani. ");
INSERT INTO srnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Fu tru Mi e taigi un taki: Efu wan ai padi no fadon na gron dan a dede, a e tan wan ai padi. Ma efu a dede, dan a e gi furu nyanyan. ");
INSERT INTO srnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A sma di lobi en libi, o lasi en. Ma a sma di no lobi en libi dya na grontapu, e kibri en fu a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Efu wan sma e dini Mi, a mus waka na Mi baka. Dan pe Mi de, drape Mi knekti sa de tu. Efu wan sma e dini Mi, dan Mi P'pa sa gi en bigi nen. ");
INSERT INTO srnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Now Mi e sari. Mi no sabi san Mi mus taki. Mi kan aksi Mi P'pa fu puru Mi ini den sani di de fu kon, ma Mi kon fu psa den sani disi.” ");
INSERT INTO srnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dan Yesus taki: “P'pa, meki Yu nen kisi grani!” Ne wan sten taki kmoto fu heimel: “Mi gi en grani kba, èn Mi sa gi en grani baka.” ");
INSERT INTO srnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A bigi grupu sma di ben tnapu drape yere a sani. Sonwan fu den taki: “Na dondru bari.” Ma trawan fu den taki: “Na wan engel taki nanga En.” ");
INSERT INTO srnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dan Yesus taigi den taki: “A sten disi no taki fu Mi ede, ma a ben taki gi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Now a ten doro fu krutu grontapu. Now den o yagi a wan gwe di e basi a grontapu disi. ");
INSERT INTO srnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma te den opo Mi go na loktu, dan Mi sa hari ala sma kon na Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus taki a sani disi fu sori den sma fa A o dede. ");
INSERT INTO srnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ala den sma piki En taki: “A wèt e leri unu tak' a Mesias o tan fu têgo. Dan fa Yu kan taigi unu tak' den mus opo a Manpikin fu Libisma? Suma na a Manpikin fu Libisma dan?” ");
INSERT INTO srnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesus piki den taki: “A faya de wan syatu pisten na un mindri ete. Un waka solanga un abi faya, fu a dungru no tapu un na pasi. A sma di e waka ini a dungru no sabi pe a e go. ");
INSERT INTO srnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Un mus fertrow a faya solanga a de nanga unu, fu un kan de pikin fu a faya.” Di Yesus kba taki den sani disi, A gwe go kibri gi den. ");
INSERT INTO srnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aladi Yesus meki den sma si someni marki, toku den no ben wani bribi ini En. ");
INSERT INTO srnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Na so a sani san a profeiti Yesaya ben skrifi kon tru. A ben skrifi: Masra, no wan sma bribi a boskopu fu unu, èn no wan sma ferstan tak' a ben de Yu krakti. ");
INSERT INTO srnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Den sma no ben man bribi, bika Yesaya ben skrifi wan tra presi taki: ");
INSERT INTO srnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","A tapu den ai, èn A tranga den ati. Noso den bo si nanga den ai èn den bo ferstan nanga den ati tak' den mus drai den libi fu Mi kan dresi den. ");
INSERT INTO srnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya ben taki a sani disi bika a ben si a glori fu Yesus èn a ben taki fu En. ");
INSERT INTO srnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Toku furu fu den edeman srefi ben e bribi ini Yesus. Ma den no ben wani meki sma sabi, fu di den ben frede tak' den Fariseiman bo yagi den puru fu a Dyukerki. ");
INSERT INTO srnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bika den ben lobi te libisma e gi den grani, moro leki te Gado ben e gi den grani. ");
INSERT INTO srnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dan Yesus bari taki: “A sma di e bribi ini Mi, no e bribi ini Mi wawan, ma a e bribi tu ini a Wan di seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","A sma di e si Mi, e si a Wan di seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi kon na grontapu leki wan faya, fu meki tak' den sma di e bribi ini Mi no tan ini a dungru. ");
INSERT INTO srnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Efu wan sma arki san Mi e leri, ma a no e du san Mi taki, Mi no o krutu en. Bika Mi no kon fu krutu grontapu, ma fu ferlusu grontapu. ");
INSERT INTO srnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ma a sma di no wani Mi, èn di no e teki san Mi taki, abi wan sani di o krutu en. A wortu san Mi taki o krutu en tapu a laste dei. ");
INSERT INTO srnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bika Mi no taki fu Misrefi, ma a P'pa di seni Mi kon, taigi Mi san Mi mus taki èn san Mi mus leri den sma. ");
INSERT INTO srnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mi sabi tak' san Mi P'pa taki, e gi a libi fu têgo. Fu dat'ede Mi e taki leki fa a P'pa taigi Mi fu taki.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Fosi a Paskafesa doro, Yesus ben sabi tak' a ten doro fu A libi grontapu go na En P'pa. Èn A lobi den sma fu En di A ben lobi na grontapu, te na a kba. ");
INSERT INTO srnNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","A pisten di Yesus nanga den man fu En ben e nyan, dan didibri ben gi Yudas, a manpikin fu Simon Iskariot, a prakseri kba fu a seri En. ");
INSERT INTO srnNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus ben sabi tak' a P'pa ben poti ala sani na ini En anu. A ben sabi tak' A ben kmopo fu Gado èn tak' A bo drai go baka na En. ");
INSERT INTO srnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Dat' meki A opo, A puru En tap'sei krosi, dan A tai wan duku lontu En bere. ");
INSERT INTO srnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Baka dati A kanti watra na ini wan beki, dan A bigin wasi den futu fu den man fu En. Dan A drei den nanga a duku san ben tai lontu En bere. ");
INSERT INTO srnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Di a doro na Simon Petrus, a disi taigi En taki: “Masra, na wasi Yu wani wasi mi futu?” ");
INSERT INTO srnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus piki en taki: “Yu no man ferstan san Mi e du now, ma wan dei yu o sabi.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dan Petrus taki: “Masra, solanga mi e libi, Yu no sa wasi mi futu!” Ma Yesus piki en taki: “Efu Mi no wasi yu futu, yu no man de wan sma fu Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ne Simon Petrus piki En taki: “Masra, dan Yu no mus wasi mi futu wawan, ma mi anu nanga mi ede tu.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus taigi en taki: “A sma di wasi en skin, krin kba. A abi fu wasi en futu nomo. Un krin, ma a no un alamala.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus taki so bika A ben sabi kba suma bo seri En. Dat' meki A taigi den taki den alamala no krin. ");
INSERT INTO srnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Di A kba wasi den futu, A weri En tap'sei krosi, dan A go sidon na En presi baka. Dan A taigi den taki: “Un ferstan san Mi du gi unu? ");
INSERT INTO srnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Unu e kari Mi Meister nanga Masra, èn un abi leti, bika na dati Mi de tu. ");
INSERT INTO srnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Efu Mi leki un Masra nanga un Meister, wasi un futu, dan un mus wasi makandra futu tu. ");
INSERT INTO srnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bika Mi gi un wan eksempre, fu un kan du leki fa Mi ben du gi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Fu tru Mi e taigi un taki: Wan knekti no hei moro en masra, èn wan boskopuman no hei moro a wan di seni en. ");
INSERT INTO srnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Now di un sabi den sani disi, Gado sa blesi unu efu un du den. ");
INSERT INTO srnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","San Mi e taki no de gi un alamala. Mi sabi den sma di Mi ben teki. Ma a musu psa leki fa a skrifi ini a Santa Buku. A skrifi taki: ‘A wan di nyan Mi brede, opo en bakafutu fu trapu Mi.’ ");
INSERT INTO srnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mi e taigi un a sani disi na fesi, fu te a psa un kan bribi tak' Mi de suma Mi de. ");
INSERT INTO srnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Fu tru Mi e taigi un taki: A sma di opo en doro gi a wan di Mi seni, e opo en gi Mi. Èn a sma di opo en doro gi Mi, e opo en gi a Wan di seni Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Baka di Yesus taki den sani disi, A firi wan dipi sari, dan A taigi den taki: “Fu tru Mi e taigi unu: Wan fu unu o seri Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Den man fu En luku makandra ferwondru. Den no ben sabi suma A e taki. ");
INSERT INTO srnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wan fu den man fu Yesus, a wan di Yesus ben lobi, ben de let' na En sei. ");
INSERT INTO srnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Dan Simon Petrus sori en fu a aksi Yesus suma A e taki. ");
INSERT INTO srnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","So a man disi dribi go moro krosbei, dan a aksi Yesus taki: “Masra, suma na en?” ");
INSERT INTO srnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus piki en taki: “Mi o dopu a pisi brede disi ini a komki, dan Mi o langa en gi a sma dati.” So Yesus dopu a pisi brede ini a komki, dan A langa en gi Yudas, a manpikin fu Simon Iskariot. ");
INSERT INTO srnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Di Yudas teki a pisi brede, Satan kon ini en ati. Dan Yesus taigi en taki: “Opo, go du es'esi san yu wani du.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma no wan fu den trawan drape ben ferstan fu sanede Yesus taigi en a sani disi. ");
INSERT INTO srnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas ben de a man di ben e hori a moni gi den. Dat' meki sonwan fu den ben prakseri tak' Yesus seni en fu go bai den sani di ben de fanowdu fu hori a Paskafesa. Trawan fu den ben prakseri tak' Yesus seni en go fu gi den pôtisma wan sani. ");
INSERT INTO srnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","So Yudas teki a pisi brede, dan a gwe wantron. A ben de neti yuru. ");
INSERT INTO srnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Baka di Yudas gwe, Yesus taki: “A ten doro now tak' a Manpikin fu Libisma e kisi glori, èn so Gado e kisi glori tu. ");
INSERT INTO srnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Efu a Manpikin meki Gado kisi glori, dan Gado sa meki a Manpikin kisi glori tu. Èn A o du dati wantron. ");
INSERT INTO srnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mi pikin, na wan syatu pisten ete Mi de nanga unu. Un o suku Mi, ma Mi taigi unu a srefi sani san Mi ben taigi den Dyu: ‘Pe Mi e go, un no man kon.’ ");
INSERT INTO srnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Wan nyun sani Mi e komanderi un fu du: Un mus lobi makandra. Leki fa Mi ben lobi unu, na so un mus lobi makandra tu. ");
INSERT INTO srnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Efu un lobi makandra, dan ala sma o sabi tak' un na sma fu Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus aksi En taki: “Masra, pe Yu e go?” Yesus piki en taki: “Pe Mi e go, yu no man kon now nanga Mi. Ma baka wan pisten yu o kon tu.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Dan Petrus aksi En taki: “Masra, fu sanede mi no man kon now nanga Yu? Mi klari fu dede gi Yu.” ");
INSERT INTO srnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesus piki en taki: “Yu klari fu dede gi Mi? Fu tru Mi e taigi yu taki: Fosi kakafowru bari, yu o taki dri leisi tak' yu no sabi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Dan Yesus taigi den man fu En taki: “Un no abi fu sari so. Un e bribi ini Gado, so un mus bribi ini Mi tu. ");
INSERT INTO srnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ini a oso fu Mi P'pa yu abi furu presi fu tan. Efu a no ben de so, dan Mi bo taigi unu. Mi e go drape fu meki presi klari gi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Te Mi kba meki presi klari gi unu, dan Mi o drai kon teki unu, fu un kan de pe Mi de. ");
INSERT INTO srnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Un sabi fa fu kon na a presi pe Mi e go.” ");
INSERT INTO srnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dan Tomas taigi En taki: “Masra, un no sabi pe Yu e go. Fa un kan sabi a pasi dan?” ");
INSERT INTO srnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus piki taki: “Mi na a pasi, na Mi e sori san na tru, èn na Mi e gi libi. Sondro Mi no wan sma kan kon na a P'pa. ");
INSERT INTO srnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Efu un ben sabi Mi, dan un bo sabi Mi P'pa tu. Bigin fu now, un sabi En èn un si En.” ");
INSERT INTO srnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dan Filipus taigi En taki: “Masra, ala san un wani, na fu Yu sori unu a P'pa.” ");
INSERT INTO srnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesus piki en taki: “Filipus, luku o langa Mi de kba na unu, dan yu no sabi Mi ete? A sma di si Mi, si a P'pa tu. Fa yu kan aksi Mi dan fu Mi sori unu a P'pa? ");
INSERT INTO srnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Un no e bribi tak' Mi de ini a P'pa, èn a P'pa de ini Mi? San Mi e taki, Mi no e taki fu Misrefi. Ma a P'pa di e tan ini Mi, e du En wroko. ");
INSERT INTO srnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Un kan bribi Mi tak' Mi de ini a P'pa èn a P'pa de ini Mi. Ma efu un no wani bribi san Mi e taki, dan un mus bribi den wroko di Mi ben du. ");
INSERT INTO srnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Fu tru Mi e taigi un taki: A sma di e bribi ini Mi, sa du den srefi wondru di Mi du, èn a sa du moro bigi wan, bika Mi e go na a P'pa. ");
INSERT INTO srnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Awinsi san un aksi ini Mi nen, Mi sa du en, fu a Manpikin kan gi a P'pa glori. ");
INSERT INTO srnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Efu un aksi Mi wan sani ini Mi nen, Mi o du en.” ");
INSERT INTO srnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Efu un lobi Mi, un o du san Mi e komanderi un fu du. ");
INSERT INTO srnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dan Mi o aksi a P'pa meki A seni wan tra Trowstuman kon gi unu, di sa tan nanga unu fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dati na a Yeye di e sori san na tru. Den grontapusma no o man kisi En, bika den no e si En, èn den no sabi En. Ma un dati sabi En, bika A de na unu, èn A sa tan ini unu. ");
INSERT INTO srnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi no o libi un na baka leki pikin di no abi m'ma nanga p'pa. Mi o kon baka na unu. ");
INSERT INTO srnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wan syatu pisten ete, dan den grontapusma no o si Mi moro. Ma unu o si Mi, bika Mi e libi èn un o libi tu. ");
INSERT INTO srnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tapu a dei dati un sa kon sabi tak' Mi de ini Mi P'pa, èn tak' unu de ini Mi èn Mi de ini unu. ");
INSERT INTO srnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","A sma di du san Mi komanderi en fu du, dati na a sma di lobi Mi. Mi P'pa o lobi a sma di lobi Mi. Mi srefi o lobi en tu èn Mi o meki a kon sabi Mi trutru.” ");
INSERT INTO srnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dan Yudas aksi Yesus taki: “Masra, fu sanede Yu o meki unu kon sabi Yu, ma Yu no o meki grontapu sabi?” A man di aksi Yesus a sani disi, no ben de Yudas Iskariot. ");
INSERT INTO srnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesus piki en taki: “Efu wan sma lobi Mi, a sa hori ensrefi na den wortu fu Mi. Dan Mi P'pa sa lobi en, èn Mi nanga Mi P'pa o kon tan nanga en. ");
INSERT INTO srnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","A sma di no lobi Mi, no e hori ensrefi na den wortu fu Mi. Èn den sani san un e yere Mi taki, no e kmoto fu Misrefi, ma den kmoto fu a P'pa di seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mi ferteri un den sani disi now di Mi de dya nanga unu ete. ");
INSERT INTO srnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma a P'pa o seni a Trowstuman kon ini Mi nen. Dati na a Santa Yeye di o leri un ala sani èn di o meki un memre ala den sani di Mi ben taigi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Freide Mi e libi gi unu. A freide fu Mi, Mi e gi unu. A no a freide di grontapu e gi. Dat' meki un no mus sari èn un no mus frede. ");
INSERT INTO srnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Un yere di Mi taigi un taki: ‘Mi e gwe, ma Mi o drai kon baka na unu.’ Efu un ben lobi Mi, un bo breiti tak' Mi e go na a P'pa, bika a P'pa bigi moro Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi taigi un a sani disi na fesi, fu un kan bribi te a psa. ");
INSERT INTO srnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi no abi furu ten moro fu taki nanga unu, bika a wan di e basi grontapu e kon. A no abi makti moro Mi, ");
INSERT INTO srnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ma grontapu mus kon sabi tak' Mi lobi a P'pa èn tak' Mi e du ala sani leki fa A taigi Mi fu du.” Dan Yesus taki: “Opo, kon un kmoto fu dya.” ");
INSERT INTO srnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mi na a trutru droifibon, èn Mi P'pa na a gronman. ");
INSERT INTO srnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ala den taki fu Mi di no e gi nyanyan, A e koti puru. Èn A e krin ibri taki di e gi nyanyan, fu a kan gi moro furu. ");
INSERT INTO srnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Den sani san Mi taigi unu, meki un kon krin kba. ");
INSERT INTO srnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Un tan ini Mi, soleki fa Mi e tan ini unu. Leki fa a taki no man gi nyanyan fu ensrefi efu a no de na a droifibon, na so un no man gi nyanyan tu efu un no tan ini Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mi na a droifibon èn unu na den taki. A sma di e tan ini Mi èn Mi e tan ini en, e gi furu nyanyan. Bika sondro Mi un no man du noti. ");
INSERT INTO srnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A sma di no e tan ini Mi, gersi wan taki di den trowe. Te a drei, den sma e tyari den taki kon na wan, dan den trowe den ini a faya fu den bron. ");
INSERT INTO srnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma efu un e tan ini Mi, èn efu un tan du san Mi taigi unu, dan un kan aksi san un wani, èn un sa kisi en. ");
INSERT INTO srnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi P'pa sa kisi glori efu un e gi furu nyanyan, bika dati o sori tak' unu na sma fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Leki fa a P'pa lobi Mi, na so Mi ben lobi unu tu. Tan ini a lobi fu Mi! ");
INSERT INTO srnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Efu un e du san Mi komanderi un fu du, dan un o tan ini a lobi fu Mi, leki fa Mi e tan ini a lobi fu Mi P'pa, fu di Mi hori Misrefi na den komanderi fu En. ");
INSERT INTO srnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi taigi un den sani disi fu un kan abi a srefi prisiri san Mi abi, èn fu un prisiri fu tru.” ");
INSERT INTO srnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Na disi Mi e komanderi unu: Un mus lobi makandra leki fa Mi ben lobi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A moro bigi lobi san wan sma kan abi, na fu gi en libi abra gi den mati fu en. ");
INSERT INTO srnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Unu na Mi mati, efu un e du san Mi e komanderi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi no e kari un knekti moro, bika wan knekti no sabi san en masra e du. Ma Mi kari unu mati, bika Mi taigi unu ala sani san Mi P'pa taigi Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A no un ben teki Mi, ma na Mi teki unu. Mi poti unu fu un go èn fu un gi furu nyanyan san e tan. Dan Mi P'pa sa gi unu ala sani san un aksi En ini Mi nen. ");
INSERT INTO srnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na disi Mi e komanderi unu: Un mus lobi makandra.” ");
INSERT INTO srnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Efu den grontapusma no man si un na ai, dan un mus sabi tak' den no ben man si Mi na ai tu fosi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Efu un ben de fu grontapu, dan den grontapusma bo lobi unu leki wan fu den. Ma unu a no fu grontapu, bika Mi ben puru unu na mindri fu den grontapusma. Dat' meki den no man si un na ai. ");
INSERT INTO srnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Memre san Mi ben taigi unu: Wan knekti no hei moro en masra. Efu den ben de na Mi baka fu du Mi ogri, dan den o de na un baka fu du un ogri tu. Efu den ben hori densrefi na den wortu fu Mi, dan den sa hori densrefi tu na den wortu fu unu. ");
INSERT INTO srnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Den o du ala den sani disi nanga unu fu Mi nen ede, bika den no sabi a Wan di seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Efu Mi no ben kon taki nanga den, den no bo abi sondu. Ma now den no kan taki tak' den no ben sabi fu den sondu. ");
INSERT INTO srnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","A sma di no man si Mi na ai, no man si Mi P'pa na ai tu. ");
INSERT INTO srnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Efu Mi no ben du den wroko na den mindri san no wan tra sma no du, dan den no bo abi sondu. Ma now den si den wroko, ma toku den no man si Mi nanga Mi P'pa na ai. ");
INSERT INTO srnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Disi psa fu meki a sani san skrifi ini a wèt fu den, kon tru. A skrifi taki: ‘Fu soso den no man si Mi na ai.’ ");
INSERT INTO srnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Te a Trowstuman kon di Mi o seni kmoto fu a P'pa, A sa ferteri fu Mi. Dati na a Yeye di e sori san na tru èn di e kmoto fu a P'pa. ");
INSERT INTO srnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma unu srefi mus ferteri fu Mi tu, bika sensi na a bigin un ben de nanga Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Mi taigi un den sani disi fu un no lasi bribi. ");
INSERT INTO srnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Den o yagi un puru fu den kerki. Iya, wan ten o kon pe a sma di kiri unu o prakseri tak' a e dini Gado nanga dati. ");
INSERT INTO srnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Den o du disi fu di den no sabi a P'pa èn fu di den no sabi Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi taigi un ala den sani disi now, fu te den e psa, un kan memre tak' Mi ben taigi unu. Ma Mi no ben taigi unu na a bigin, fu di Mi ben de nanga unu.” ");
INSERT INTO srnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Now Mi e go na a Wan di ben seni Mi kon, ma no wan fu unu e aksi Mi pe Mi e go. ");
INSERT INTO srnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ma fu di Mi taigi unu den sani disi, meki un e sari. ");
INSERT INTO srnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mi e taigi unu tru tak' a moro bun gi unu efu Mi gwe. Bika efu Mi no go, dan a Trowstuman no o kon na unu. Ma efu Mi gwe, dan Mi o seni En kon gi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te A kon, A o sori den sma fu grontapu san na sondu, san bun ini Gado ai, nanga san Gado e krutu. ");
INSERT INTO srnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A o sori den san na sondu, fu di den no e bribi ini Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A o sori den san bun ini Gado ai, fu di Mi e go na a P'pa èn unu no o si Mi moro. ");
INSERT INTO srnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A o sori den san Gado e krutu, bika Gado krutu a wan kba di e basi a grontapu disi. ");
INSERT INTO srnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mi abi furu sani fu taigi unu ete, ma now a o hebi tumsi gi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma te a Yeye kon di e taki san na tru, A o sori unu a pasi fu sabi ala sani san tru. Bika A no sa taki fu Ensrefi, ma A sa taki san A yere, èn A sa taigi unu san de fu kon. ");
INSERT INTO srnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A sa gi Mi glori, bika ala sani san A sa ferteri unu, A abi fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ala san Mi P'pa abi, na fu Mi. Dat' meki Mi taigi unu taki: Ala sani san A sa ferteri unu, A abi fu Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ete wan syatu pisten, dan un no sa si Mi moro, ma pikinso baka dati, un o si Mi baka.” ");
INSERT INTO srnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dan sonwan fu den man fu Yesus aksi makandra san A ben wani taki di A taigi den tak' baka wan syatu pisten dan den no o si En moro, ma pikinso baka dati den o si En baka. Den aksi tu san A ben wani taigi den di A taki tak' A o go na a P'pa. ");
INSERT INTO srnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Den taki: “San na wan syatu pisten? San A wani taki nanga dati? Un no sabi san A e taki.” ");
INSERT INTO srnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus si tak' den ben wani aksi En wan sani. Dat' meki A taigi den taki: “Na aksi un e aksi unsrefi san Mi ben wani taki di Mi taigi unu: ‘Wan syatu pisten dan un no sa si Mi moro, ma pikinso baka dati, un o si Mi baka?’ ");
INSERT INTO srnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Fu tru Mi e taigi un taki: Un o krei èn un o bari, ma den grontapusma o breiti. Un o sari, ma a sari fu unu o tron prisiri. ");
INSERT INTO srnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Te a ten doro fu wan uma meki a pikin, a abi furu skin-ati. Ma te a pikin gebore, a no e prakseri a benawtu moro ini san a ben de, fu di a breiti tak' a tyari wan pikin kon na grontapu. ");
INSERT INTO srnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na so a de nanga unu tu. Nownow un e sari. Ma Mi o si un baka. Dan un o breiti, èn no wan sma o man pori a prisiri fu unu. ");
INSERT INTO srnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A ten dati un no o aksi Mi noti moro. Fu tru Mi e taigi un taki: Efu un aksi a P'pa wan sani ini Mi nen, A sa gi unu. ");
INSERT INTO srnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Te leki now un no ben aksi noti ini Mi nen. Aksi, dan unu sa kisi, fu un kan breiti srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mi ben taki ini agersitori nanga unu. Ma wan ten e kon pe Mi no o taki so moro. Dan Mi o ferteri unu krin fu Mi P'pa. ");
INSERT INTO srnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A ten dati, un srefi o aksi sani ini Mi nen. Mi no e taki tak' Mi o aksi a P'pa gi unu, ");
INSERT INTO srnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","bika a P'pa srefi lobi unu fu di un lobi Mi, èn fu di un bribi tak' Mi kmopo fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi ben kmopo fu a P'pa kon na grontapu. Now Mi e gwe libi grontapu fu drai go baka na a P'pa.” ");
INSERT INTO srnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dan den man fu En taki: “Now Yu e taki fu wi ferstan. Yu no e taki ini agersitori moro. ");
INSERT INTO srnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Now un kan si tak' Yu sabi ala sani èn a no de fanowdu fu wan sma aksi Yu wan sani. Fu a sani disi ede un e bribi tak' Yu kmoto fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesus piki den taki: “Now fosi un e bribi? ");
INSERT INTO srnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Luku, a yuru o kon èn a doro kba, tak' un o panya go waka un eigi pasi dan un libi Mi wawan. Ma toku Mi no de Mi wawan, bika a P'pa de nanga Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi ferteri un den sani disi fu un kan feni freide na Mi. Na grontapu den sma o pina unu. Ma hori dek'ati, bika Mi wini grontapu kba.” ");
INSERT INTO srnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Di Yesus kba taki den sani disi, A luku go na heimel dan A begi taki: “Mi P'pa, a yuru doro. Gi Yu Manpikin glori, fu a Manpikin kan gi Yu glori. ");
INSERT INTO srnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bika Yu ben gi En makti tapu ala sma na grontapu, fu A kan gi a libi fu têgo na ala den sma di Yu ben gi En. ");
INSERT INTO srnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Disi na a libi fu têgo, tak' den sma kon sabi Yu, a wan enkri tru Gado, nanga Yesus Kristus di Yu seni kon. ");
INSERT INTO srnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi gi Yu glori na grontapu fu di Mi klari a wroko san Yu ben gi Mi fu du. ");
INSERT INTO srnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mi P'pa, gi Mi a srefi glori now san Mi ben abi na Yu sei fosi grontapu ben meki. ");
INSERT INTO srnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mi meki den sma di Yu ben gi Mi na grontapu, kon sabi Yu. Den ben de fu Yu, ma Yu gi den na Mi, èn den hori densrefi na den wortu fu Yu. ");
INSERT INTO srnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Now den kon si tak' ala sani san Yu ben gi Mi, kmoto fu Yu. ");
INSERT INTO srnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bika Mi taigi den san Yu ben taigi Mi, èn den teki en. Den sabi trutru tak' Mi kmoto fu Yu, èn den bribi tak' na Yu seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mi e begi gi den. Mi no e begi gi den sma fu grontapu, ma gi den sma di Yu ben gi Mi, bika den na fu Yu. ");
INSERT INTO srnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ala san Mi abi na fu Yu, èn san na fu Yu, na fu Mi. Den sma fu Mi meki Mi kisi glori. ");
INSERT INTO srnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi no de langa moro na grontapu, ma den e tan na grontapu. Mi e kon na Yu. Santa P'pa, kibri den ini Yu nen di Yu ben gi Mi, fu den kan de wan leki fa Wi de wan. ");
INSERT INTO srnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Solanga Mi ben de nanga den, Mi ben kibri den ini a nen di Yu ben gi Mi. Mi luku den, èn no wan fu den no lasi, boiti a wan di ben mus go lasi fu meki a sani kon tru san skrifi ini a Santa Buku. ");
INSERT INTO srnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Now Mi e kon na Yu, ma Mi e taki den sani disi dya na grontapu fu den kan furu srefsrefi nanga a prisiri fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi ferteri den san Yu ferteri Mi. Fu dat'ede den sma fu grontapu no man si den na ai, fu di den no de fu grontapu leki fa Mi no de fu grontapu. ");
INSERT INTO srnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi no e begi fu Yu puru den na grontapu, ma fu Yu kibri den fu a ogriwan. ");
INSERT INTO srnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Den no de fu grontapu, leki fa Mi no de fu grontapu. ");
INSERT INTO srnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Den tru sani fu Yu mus meki den kon santa. Yu wortu tru. ");
INSERT INTO srnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Leki fa Yu seni Mi kon na grontapu, na so Mi seni den go na den sma fu grontapu tu. ");
INSERT INTO srnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na fu den ede Mi e poti Misrefi aparti gi Yu, fu den srefi kan de aparti gi Yu trutru. ");
INSERT INTO srnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mi no e begi gi den sma disi wawan, ma Mi e begi tu gi den sma di o teki bribi ini Mi te den sa ferteri den fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","P'pa, meki den alamala de wan, soleki fa Yu de ini Mi, èn Mi de ini Yu. Meki tu tak' den sa de ini Wi, fu grontapu kan bribi tak' na Yu seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi ben gi den a grani san Yu ben gi Mi, fu den kan de wan soleki fa Wi de wan. ");
INSERT INTO srnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi de wan nanga den, èn Yu de wan nanga Mi. Meki den de wan trutru. Dan grontapu sa sabi tak' na Yu seni Mi kon, èn tak' Yu lobi den soleki fa Yu lobi Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mi P'pa, Mi wani tak' den sma di Yu gi Mi sa de pe Mi de, fu den kan si a glori di Yu gi Mi. Bika Yu ben lobi Mi fosi grontapu ben meki. ");
INSERT INTO srnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mi P'pa, Yu e du sani nanga leti! Den sma fu grontapu no sabi Yu. Ma Mi sabi Yu, èn den man fu Mi sabi tak' na Yu seni Mi kon. ");
INSERT INTO srnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi meki den kon sabi Yu, èn Mi sa go doro fu meki den kon sabi Yu, fu a lobi di Yu abi gi Mi kan de ini den, èn Mi sa de wan nanga den.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Di Yesus kba begi, A go nanga den man fu En na a tra sei fu a Kidronkriki. Dan den go ini wan dyari drape. ");
INSERT INTO srnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas, a man di seri Yesus, ben sabi a dyari dati, bika furu leisi Yesus ben go drape nanga den man fu En. ");
INSERT INTO srnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","So Yudas go drape tu. Den prenspari domri nanga den Fariseiman ben seni wan grupu srudati nanga waktiman fu a mamakerki go nanga en. Den kon nanga lanteri, frambo nanga fetisani. ");
INSERT INTO srnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus ben sabi san bo miti En, so a waka kon na fesi dan A aksi den taki: “Suma un e suku?” ");
INSERT INTO srnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Den piki En taki: “Yesus fu Nasaret.” Yudas, a man di seri Yesus ben tnapu nanga den. Dan Yesus piki den taki: “Na Mi na En.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Di Yesus taki dati, den man go nanga baka dan den fadon na gron. ");
INSERT INTO srnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dan Yesus aksi den ete wan leisi taki: “Suma un e suku?” Den piki En taki: “Yesus fu Nasaret.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dan Yesus taigi den taki: “Mi taigi unu tak' na Mi na En. Efu na Mi un e suku, dan un meki den man disi gwe.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tapu sowan fasi a sani san Yesus ben taki kon tru. A ben taki: “Mi no lasi no wan fu den sma di Yu gi Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petrus ben abi wan owru na en. A hari en, dan a kapu a let'sei yesi puru fu a knekti fu a grandomri. A knekti disi ben nen Malkus. ");
INSERT INTO srnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma Yesus taigi Petrus taki: “Poti a owru na en presi. Mi mus fu nyan a pina san Mi P'pa gi fu Mi nyan.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dan a grupu srudati nanga a edeman fu den, nanga den waktiman fu a mamakerki grabu Yesus. Den bui En, ");
INSERT INTO srnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","dan den tyari En go fosi na Anas, a p'pa fu Kayafas frow. Kayafas ben de grandomri a yari dati. ");
INSERT INTO srnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na en ben gi den fesiman fu den Dyu a rai tak' a moro betre tak' wan man nomo dede gi a heri pipel. ");
INSERT INTO srnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrus nanga wan tra man fu Yesus, ben waka go na Yesus baka. A tra man disi ben sabi a grandomri. Dat' meki a go nanga Yesus ini a prasi fu a grandomri. ");
INSERT INTO srnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ma Petrus tan tnapu na dorosei na a poort. A tra man, di ben sabi a grandomri, drai go baka na dorosei. A taki nanga a uma di ben e hori wakti na a poort, dan a meki Petrus kon inisei. ");
INSERT INTO srnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dan a uma dati aksi Petrus taki: “Yu a no wan fu den man fu En tu?” Petrus piki taki: “A no mi!” ");
INSERT INTO srnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Den wrokoman nanga den waktiman fu a mamakerki ben meki wan faya fu di a ben kowru. Den ben tnapu e waran densrefi èn Petrus ben tnapu nanga den e teki waran tu. ");
INSERT INTO srnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Dan a grandomri aksi Yesus fu ferteri en fu den man fu En nanga fu a leri san A e gi. ");
INSERT INTO srnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesus piki en taki: “Mi ben taki fu ala sma yere. Ala leisi Mi ben e gi leri ini den kerki nanga a mamakerki, pe ala Dyusma e kon makandra. Noiti Mi no taki bakabaka. ");
INSERT INTO srnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Fu sanede un e aksi Mi dan? Aksi den sma di yere san Mi taigi den. Den sabi san Mi ben taki.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Di Yesus taki a sani disi, wan fu den waktiman fu a mamakerki di ben tnapu drape, naki En ini En fesi, dan a taki: “A no so Yu e taki nanga a grandomri!” ");
INSERT INTO srnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus piki en taki: “Efu Mi taki wan sani san no bun, dan yu mus sori Mi san no ben bun. Ma efu Mi taki leti, fu sanede yu naki Mi dan?” ");
INSERT INTO srnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dan leki fa den ben bui En tyari kon, na so Anas seni En go na grandomri Kayafas. ");
INSERT INTO srnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","A pisten dati Simon Petrus ben tnapu e teki waran. Dan den aksi en taki: “Yu a no wan fu den man fu En tu?” Ma a lei taki: “A no mi!” ");
INSERT INTO srnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wan fu den knekti fu a grandomri ben de famiri fu a man di Petrus ben kapu en yesi puru. Dan a aksi Petrus taki: “A no yu mi si nanga Yesus ini a dyari?” ");
INSERT INTO srnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma Petrus lei ete wan leisi tak' a no tru. Dan a srefi momenti dati kakafowru bari. ");
INSERT INTO srnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Fruk'fruku mamanten, den tyari Yesus fu Kayafas oso go na a krutu-oso. Ma den Dyusma no go inisei, bika den ben wani hori densrefi krin fu kan nyan Paska. ");
INSERT INTO srnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","So Pilatus kon na dorosei na den, dan a aksi den taki: “San un feni tak' a man disi du?” ");
INSERT INTO srnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Den piki en taki: “Efu A no ben de wan ogriman, un no bo tyari En kon gi yu!” ");
INSERT INTO srnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ne Pilatus taigi den taki: “Dan un teki En krutu nanga un eigi wèt.” Ma den fesiman fu den Dyu piki en taki: “Un no abi primisi fu kiri wan sma.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na so a sani kon tru san Yesus ben taki fu a fasi fa A bo dede. ");
INSERT INTO srnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dan Pilatus drai go baka ini a krutu-oso. A kari Yesus kon, dan a aksi En taki: “Na Yu na a Kownu fu den Dyu?” ");
INSERT INTO srnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus piki en taki: “Na yu srefi e taki disi? Noso na tra sma ben ferteri yu fu Mi?” ");
INSERT INTO srnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus taki: “Mi a no Dyu! Na Yu eigi folku nanga den prenspari domri tyari Yu kon gi mi. Sortu ogri Yu du?” ");
INSERT INTO srnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus piki en taki: “Mi a no wan kownu fu a grontapu disi. Efu a ben de so, dan den man fu Mi bo feti gi Mi, fu Mi no fadon ini anu fu den Dyu. Ma Mi a no wan kownu fu dya.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dan Pilatus aksi taki: “Dan a tru tak' Yu na wan kownu?” Yesus piki en taki: “Na leki fa yu taki: Mi na wan kownu. Fu a sani disi Mi ben gebore. Na fu disi Mi ben kon na grontapu, fu taigi den sma san na tru. Ala sma di lobi san na tru, e arki Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dan Pilatus taigi En taki: “Ma san na tru?” Baka di Pilatus taki a sani disi, a drai go baka na dorosei na den Dyusma. A taigi den taki: “Mi no feni no wan fowtu na a man disi. ");
INSERT INTO srnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma un abi a gwenti tak' mi e lusu wan straf'man gi unu tapu a Paskafesa. Un wani fu mi lusu a Kownu fu den Dyu gi unu?” ");
INSERT INTO srnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Den sma bari ete wan leisi taki: “Un no wani En! Na Barabas un wani!” Barabas ben de wan fufuruman. ");
INSERT INTO srnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Baka dati Pilatus teki Yesus, dan a meki den wipi En. ");
INSERT INTO srnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Den srudati brei wan banti fu makataki, poti tapu Yesus ede. Dan den weri wan lila krosi gi En. ");
INSERT INTO srnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Den waka miti En, dan den taki: “Odi, Kownu fu den Dyu!” Dan den naki En ini En fesi. ");
INSERT INTO srnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus go ete wan leisi na dorosei, dan a taigi den Dyusma taki: “Luku, mi o tyari En kon na dorosei gi unu, meki un si tak' Mi no feni no wan fowtu na En.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dan Yesus kon na dorosei. A ben weri a banti fu makataki nanga a lila krosi. Dan Pilatus taigi den sma taki: “Luku a man dya!” ");
INSERT INTO srnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Di den prenspari domri nanga den waktiman fu a mamakerki si Yesus, den bari taki: “Spikri En na wan kroisi! Spikri En na wan kroisi!” Pilatus taigi den taki: “Dan un srefi teki En go spikri na wan kroisi, bika mi no feni no wan fowtu na En.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Den Dyu piki en taki: “Un abi wan wèt san e taki tak' A mus dede, bika A kari Ensrefi a Manpikin fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Di Pilatus yere a sani disi, a kon moro frede. ");
INSERT INTO srnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A drai go baka ini a krutu-oso, dan a aksi Yesus taki: “Pe yu kmoto?” Ma Yesus no piki en. ");
INSERT INTO srnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dan Pilatus aksi en taki: “Yu no wani piki mi? Yu no sabi tak' mi abi a makti fu lusu Yu, noso fu spikri Yu na wan kroisi?” ");
INSERT INTO srnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus piki en taki: “Yu no bo abi makti na Mi tapu efu Gado no ben gi yu a makti dati. Fu dat'ede a sondu fu a man di gi Mi abra na yu moro bigi.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bigin fu a momenti dati Pilatus ben e suku wan fasi fu lusu Yesus. Ma den Dyusma bari taki: “Efu yu lusu a man disi, dan yu a no wan mati fu a grankownu. A sma di e kari ensrefi kownu, na wan feyanti fu a grankownu.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Di Pilatus yere san den sma taki, a meki den tyari Yesus go na dorosei. Dan a go sidon na tapu a krutusturu, di ben tnapu na a presi di den e kari: A Ston Presi. Ini Dyutongo den e kari en: Gabata. ");
INSERT INTO srnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A ben de twarfu yuru ten so fu a dei pe den Dyusma e meki densrefi klari fu nyan Paska. Dan Pilatus taigi den taki: “Luku, a Kownu fu unu dya!” ");
INSERT INTO srnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma den sma bari taki: “Un no wani En! Un no wani En! Spikri En na wan kroisi.” Pilatus piki den baka taki: “Un wani fu Mi spikri un Kownu na wan kroisi?” Den prenspari domri piki en taki: “Un no abi no wan tra kownu boiti a grankownu.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dan Pilatus gi Yesus abra na den fu den go spikri En na wan kroisi. ");
INSERT INTO srnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Den sma teki Yesus, dan den meki A tyari En eigi kroisi go na a presi san den e kari: Dede-ede Presi. Ini Dyutongo den e kari a presi: Golgota. ");
INSERT INTO srnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Drape den spikri En na a kroisi. Makandra nanga Yesus den spikri tu tra man tu, wan na ala tu sei fu En nanga Yesus na den mindri. ");
INSERT INTO srnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus meki den skrifi wan sani poti na a kroisi. Den skrifi: Yesus fu Nasaret, a Kownu fu den Dyu. ");
INSERT INTO srnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Furu Dyusma leisi a sani disi, bika a presi pe den spikri Yesus na a kroisi ben de krosbei fu a foto. A sani ben skrifi ini Dyutongo, Romeinitongo nanga Grikitongo. ");
INSERT INTO srnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dan den prenspari domri taigi Pilatus taki: “Yu no ben mus skrifi: ‘A Kownu fu den Dyu,’ ma yu ben mus skrifi: ‘A man disi taki: Mi na Kownu fu den Dyu.’ ” ");
INSERT INTO srnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ma Pilatus piki den taki: “San mi skrifi, tan skrifi!” ");
INSERT INTO srnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Baka di den srudati spikri Yesus na a kroisi, den teki En krosi dan den priti en na fo. Ibri srudati kisi wan pisi. Ma a langa ondrokrosi fu En no ben nai, a heri sani ben de fu wan pisi krosi nomo. ");
INSERT INTO srnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Dan den taigi makandra taki: “Kon un no priti en. Meki un hari a lot fu luku suma o kisi en.” Na so a sani kon tru san skrifi ini a Santa Buku taki: Den prati mi krosi gi densrefi, fu mi krosi den hari wan lot. Fu dat'ede den srudati ben du den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Di Yesus ben e anga na a kroisi, En m'ma nanga a sisa fu En m'ma ben tnapu drape. Maria, a frow fu Klopas, nanga Maria fu a foto Magdala, ben drape tu. ");
INSERT INTO srnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Wan fu den man fu Yesus, a wan di A ben lobi, ben tnapu sei a m'ma fu Yesus. Di Yesus si den, A taigi En m'ma taki: “Frow, teki en leki yu manpikin.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dan A taigi a man fu En taki: “Teki a frow disi leki yu m'ma.” Bigin fu a dei dati, a man fu Yesus teki en fu kon tan na en oso. ");
INSERT INTO srnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus ben sabi tak' A kba du ala sani. Dan fu meki a sani kon tru san skrifi na ini a Santa Buku, A taki: “Watra e kiri Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wan kroiki ben drape san ben furu nanga swa win. So den nati wan sponsu nanga a win, den fasi en na wan tiki fu wan hisopbon, dan den langa en go na Yesus mofo. ");
INSERT INTO srnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Di Yesus dringi a swa win, A taki: “A kba!” A anga En ede, dan En bro koti. ");
INSERT INTO srnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A dei dati den Dyu ben meki densrefi klari fu nyan wan spesrutu sabadei èn den no ben wani tak' den dedeskin tan anga na kroisi a dei dati. Dat' meki den aksi Pilatus fu broko den sma futu, dan den puru den na kroisi. ");
INSERT INTO srnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","So den srudati kon, dan den broko den futu fu den tu man di ben anga na kroisi nanga Yesus. ");
INSERT INTO srnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma di den doro na Yesus, den si tak' A dede kba. Dat' meki den no broko En futu. ");
INSERT INTO srnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma wan fu den srudati dyuku en lansri na Yesus seibere. Wantron brudu nanga watra lon kmoto na ini. ");
INSERT INTO srnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A sma di si a sani nanga en eigi ai, e ferteri fu en fu unu kan bribi tu. Un kan bribi san a e taki, bika a sabi tak' san a e ferteri tru. ");
INSERT INTO srnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Den sani disi psa fu meki a sani kon tru san skrifi ini a Santa Buku taki: “Den no sa broko no wan bonyo fu en.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na wan tra presi ini a Santa Buku a skrifi taki: “Den o luku a wan di den dyuku.” ");
INSERT INTO srnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Baka dati Yosef fu Arimatea aksi Pilatus efu a kan teki a dedeskin fu Yesus. A ben de wan man fu Yesus, ma a no ben meki tra sma sabi fu di a ben frede den fesiman fu den Dyu. Pilatus gi en pasi, dan a go teki a dedeskin tyari gwe. ");
INSERT INTO srnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, a man di ben kon na Yesus wan neti, ben go nanga en. A ben tyari wan dritenti kilo semprefisi moksi nanga mirre kon nanga en. ");
INSERT INTO srnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dan den tu man teki a dedeskin fu Yesus. Den domru en makandra nanga den switismeri na ini linnen krosi soleki fa den Dyusma gwenti fu beri wan dedesma. ");
INSERT INTO srnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Krosbei fu a presi pe den ben spikri Yesus na a kroisi, wan dyari ben de. Ini a dyari dati wan nyun grebi ben de pe no wan sma ben beri ete. ");
INSERT INTO srnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Dan fu di den Dyusma ben e meki densrefi klari gi a sabadei, meki den poti Yesus ini a grebi dati, bika a ben de krosbei. ");
INSERT INTO srnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tapu a fosi dei fu a wiki, fruk'fruku fosi a son opo, Maria fu Magdala go na a grebi. Dan a si tak' a ston ben kmoto na a grebimofo. ");
INSERT INTO srnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ne a lon go es'esi na Simon Petrus nanga a tra man di Yesus ben lobi. A taigi den taki: “Den puru a skin fu Masra na ini a grebi, èn un no sabi pe den poti En.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dan Petrus nanga a tra man fu Yesus opo go na a grebi. ");
INSERT INTO srnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ala tu ben e lon, ma a tra man ben e lon moro esi leki Petrus. Dat' meki a doro fosi na a grebi. ");
INSERT INTO srnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Di a bukundu luku, a si den linnen krosi didon drape, ma a no go inisei. ");
INSERT INTO srnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petrus, di doro na en baka, go ini a grebi. A si den linnen krosi didon drape, ");
INSERT INTO srnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma a anyisa di ben tapu a ede fu Yesus, no ben de na den. A ben lolo poti na wan sei. ");
INSERT INTO srnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dan a tra man fu Yesus, di ben doro leki fosiwan na a grebi, go inisei tu. Di a si tak' a grebi leigi, a bribi. ");
INSERT INTO srnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bika te leki a ten dati den no ben ferstan a pisi fu a Santa Buku ete san e taki tak' Yesus bo kon baka na libi. ");
INSERT INTO srnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dan den man fu Yesus drai go baka na oso. ");
INSERT INTO srnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma Maria ben tan tnapu na dorosei fu a grebi e krei. Di a e krei, a bukundu luku ini a grebi. ");
INSERT INTO srnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Dan a si tu engel nanga weti krosi sidon ini a grebi. Wan ben e sidon na a edesei èn a trawan ben e sidon na a futusei fu a presi pe a dedeskin fu Yesus ben didon. ");
INSERT INTO srnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dan den aksi en taki: “Frow, fu sanede yu e krei?” A piki den taki: “Sma kon puru mi Masra, èn mi no sabi pe den poti En.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Di a taki dati, a drai luku dan a si Yesus tnapu na en baka, ma a no ben sabi tak' na En. ");
INSERT INTO srnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesus aksi en taki: “Frow, fu sanede yu e krei? Suma yu e suku?” Maria ben prakseri tak' na a man di e krin a dyari. So a taigi En taki: “Masra, efu na yu tyari En gwe, taigi mi pe yu poti En, dan mi sa go teki En.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dan Yesus taki: “Maria!” Maria drai, dan a taki ini Dyutongo: “Rabuni!” (Dati wani taki: Meister.) ");
INSERT INTO srnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus taigi en taki: “No hori Mi, bika Mi no opo go na Mi P'pa ete. Ma go na den brada fu Mi, dan yu taigi den tak' Mi e go na Mi P'pa, di de a P'pa fu unu tu, èn Mi e go na Mi Gado, di de un Gado tu.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dan Maria fu Magdala go taigi den man fu Yesus tak' a si Masra, èn a ferteri den san Yesus taigi en. ");
INSERT INTO srnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A ben de a fosi dei fu a wiki ete. A neti dati den man fu Yesus ben de makandra. Den ben sroto den doro fu di den ben frede den fesiman fu den Dyu. Dan Yesus kon tnapu na den mindri èn A taigi den taki: “Freide mus de nanga unu!” ");
INSERT INTO srnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Di a taki dati, A sori den En anu nanga En seibere. Den man fu Yesus ben breiti srefsrefi di den si Masra. ");
INSERT INTO srnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dan Yesus taki ete wan leisi: “Freide mus de nanga unu. Soleki fa a P'pa seni Mi, na so Mi e seni unu tu.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Di A taki dati, A bro go na den tapu. Dan A taigi den taki: “Mi e gi unu a Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Den sma di un e gi pardon fu den sondu, sa kisi pardon. Ma den sma di un no e gi pardon fu den sondu, no sa kisi pardon.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas, wan fu den twarfu man fu Yesus di den ben e kari Didimus, no ben de nanga den di Yesus kon. ");
INSERT INTO srnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Den tra man taigi en taki: “Un si Masra.” Ma Tomas piki den taki: “Solanga mi no si den spikrimarki ini En anu, èn mi no sutu mi finga ini den spikri-olo tu, èn solanga mi no sutu mi anu ini En seibere, mi no e bribi.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Aiti dei na baka den man fu Yesus ben de makandra ini a oso baka èn Tomas ben de nanga den. Den doro ben sroto, ma toku Yesus kon tnapu na den mindri. A taki: “Freide mus de nanga unu!” ");
INSERT INTO srnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dan A taigi Tomas taki: “Luku Mi anu dya. Tyari yu finga kon. Langa yu anu, dan yu sutu en na Mi seibere. No degedege moro, ma bribi.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas piki En taki: “Mi Masra nanga mi Gado!” ");
INSERT INTO srnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Dan Yesus taigi en taki: “Yu e bribi fu di Yu si Mi. Ma blesi de tapu den sma di bribi sondro tak' den si.” ");
INSERT INTO srnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus meki den man fu En si furu tra marki di no skrifi ini a buku disi. ");
INSERT INTO srnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma den wan di skrifi dya, skrifi fu un kan bribi tak' Yesus na a Mesias, a Manpikin fu Gado, èn te un bribi dati, un sa kisi a libi fu têgo ini En nen. ");
INSERT INTO srnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Baka den sani disi, Yesus sori Ensrefi ete wan leisi na den man fu En na a Meer fu Tiberias. Na so a psa. ");
INSERT INTO srnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petrus, nanga Tomas di den e kari Didimus, ben drape. Natanael fu a foto Kana ini Galilea ben drape tu. Dan yu ben abi den manpikin fu Sebedeus nanga tu tra man fu Yesus ete. ");
INSERT INTO srnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Dan Simon Petrus taigi den taki: “Mi e go fisi.” Den piki en taki: “Dan un o go nanga yu.” Den gwe go teki wan boto, ma a neti dati den no fanga noti. ");
INSERT INTO srnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Di dei broko, Yesus ben e tnapu na syoro, ma den man fu En no ben sabi tak' na En. ");
INSERT INTO srnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dan Yesus aksi den taki: “Mati, un fanga wan sani?” Den piki taki: “Nono.” ");
INSERT INTO srnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ne A taigi den taki: “Fringi a neti na a let'sei fu a boto, dan un o fanga.” Di den man fringi a neti, den no ben man hari en kon fa fisi ben lai na ini. ");
INSERT INTO srnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dan a man fu Yesus, a wan di A ben lobi, taigi Petrus taki: “Na Masra!” Di Simon Petrus yere tak' na Masra, a weri en tap'sei krosi baka bika a ben puru en. Dan a dyompo go ini a watra. ");
INSERT INTO srnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma den tra man fu Yesus kon nanga a boto. Den srepi a neti nanga den fisi na den baka bika den no ben de fara fu syoro, kande wan hondro meter so. ");
INSERT INTO srnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Di den kon na syoro, den si fisi tapu wan faya, nanga brede. ");
INSERT INTO srnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dan Yesus taigi den taki: “Tyari wantu fisi kon di un fanga didyonsro.” ");
INSERT INTO srnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus go ini a boto, dan a hari a fis'neti kon na syoro. A ben lai nanga wan hondro nanga feifitenti-na-dri (153) bigi fisi. Ma aladi a ben lai nanga someni fisi, toku a no ben priti. ");
INSERT INTO srnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dan Yesus taigi den man taki: “Un kon nyan.” No wan fu den man ben prefuru fu aksi: “Suma na Yu?” Bika den ben sabi tak' na Masra. ");
INSERT INTO srnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ne Yesus kon, A teki a brede, dan A gi den. A du a srefi sani nanga den fisi tu. ");
INSERT INTO srnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Disi ben de a di fu dri tron di Yesus sori Ensrefi na den man fu En baka di A kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Di den kba nyan, Yesus aksi Simon Petrus taki: “Simon, manpikin fu Yohanes, yu lobi Mi moro den disi?” Petrus piki taki: “Iya Masra, Yu sabi tak' mi lobi Yu.” Dan Yesus taigi en taki: “Sorgu gi den pikinskapu fu Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dan Yesus aksi en baka taki: “Simon, manpikin fu Yohanes, yu lobi Mi trutru?” Petrus piki En taki: “Iya Masra, Yu sabi tak' mi lobi Yu.” Dan Yesus taigi en taki: “Luku den skapu fu Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dan Yesus aksi en a di fu dri leisi taki: “Simon, manpikin fu Yohanes, yu lobi Mi?” Petrus bigin sari di Yesus aksi en a di fu dri leisi efu a lobi En. Ne a piki En taki: “Masra, Yu sabi ala sani. Yu sabi tak' mi lobi Yu.” Dan Yesus taigi en taki: “Sorgu gi den skapu fu Mi. ");
INSERT INTO srnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Fu tru Mi e taigi yu taki: Di yu ben yongu ete, yu srefi ben weri yu krosi, èn yu ben e go pe yu wani. Ma te yu kon owru, yu sa langa yu anu, dan trawan o weri krosi gi yu èn den o tyari yu go pe yu no wani go.” ");
INSERT INTO srnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na so Yesus sori Petrus fa a bo dede, èn fa a sani disi bo gi Gado glori. Dan Yesus taigi Petrus taki: “Kon nanga Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Di Petrus drai luku na baka, a si tak' a man di Yesus ben lobi e waka kon na den baka. Na a man disi ben dribi go moro krosbei na Yesus di den ben e nyan, dan a ben aksi En taki: “Masra, suma na a sma di o seri Yu?” ");
INSERT INTO srnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Di Petrus si en, a aksi Yesus taki: “Masra, san o psa nanga en dan?” ");
INSERT INTO srnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus piki en taki: “No broko yu ede nanga dati. Efu Mi wani, Mi e meki a tan na libi te leki Mi drai kon baka. Ma yu mus kon nanga Mi.” ");
INSERT INTO srnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A nyunsu disi panya na mindri den bribisma tak' a man disi fu Yesus no bo dede. Ma Yesus no ben taki tak' a no o dede. A ben taki: “No broko yu ede nanga dati. Efu Mi wani, Mi e meki a tan na libi te leki Mi drai kon baka.” ");
INSERT INTO srnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na a man disi fu Yesus e ferteri den sani disi di psa. A skrifi den èn un sabi tak' san a e ferteri tru. ");
INSERT INTO srnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Furu tra sani de ete di Yesus du. Ma efu un ben skrifi den wan fru wan, dan mi denki tak' heri grontapu srefi no bo abi nofo presi fu hori ala den buku di bo skrifi.");
INSERT INTO srnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilus, ini a fosi buku di mi skrifi, mi ben ferteri yu fu ala den sani san Yesus ben du nanga san A ben leri, ");
INSERT INTO srnNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","te kon miti a dei di Gado teki En go na heimel. Ma fosi dati, A ben komanderi den man di A ben teki leki boskopuman fu En, san den ben mus du. A du dati nanga yepi fu a Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Baka di Yesus nyan pina èn dede, A sori Ensrefi na den man disi èn A du furu sani fu meki den kon si krin tak' A kon na libi baka. A du dati ini wan ten fu fotenti dei, èn A ferteri den fu a fasi fa Gado wani tiri libisma. ");
INSERT INTO srnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wan fu den dei dati, di Yesus ben e nyan makandra nanga den, A taigi den taki: “No gwe libi Yerusalem, ma un mus tan wakti tapu san mi P'pa ben pramisi unu. Mi ben taigi unu fu a pramisi dati kba. ");
INSERT INTO srnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanes ben e dopu sma nanga watra, ma baka wantu dei un sa dopu nanga a Santa Yeye.” ");
INSERT INTO srnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Di den ben de makandra nanga Yesus, den aksi En taki: “Masra, na now Yu o gi Israel en eigi kownu baka leki fa a ben de fosten?” ");
INSERT INTO srnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesus piki den taki: “Un no abi fu sabi a ten noso a yuru di a sani dati o psa. Na a P'pa abi makti èn na En o meki a psa oten A wani. ");
INSERT INTO srnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma unu o kisi krakti te a Santa Yeye kon na un tapu. Dan un sa de kotoigi fu Mi na ini Yerusalem, na ini heri Yudea nanga Samaria, èn te na den moro fara presi fu grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Baka di A taki den sani disi, Gado teki En go na heimel let' na den fesi. Dan wan wolku tapu En, èn den no ben kan si En moro. ");
INSERT INTO srnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Di den ben e luku go na loktu ete, fa A e gwe, dan wantron so tu man ini weti krosi ben tnapu na den sei. ");
INSERT INTO srnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Den man taigi den taki: “Un man fu Galilea, fu sanede un tnapu dyaso e luku go na loktu? A srefi Yesus disi, di Gado teki go na heimel, o drai kon baka tapu a srefi fasi fa un si tak' A go na heimel.” ");
INSERT INTO srnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dan den man kmopo fu a bergi di den e kari Oleifbergi, go baka na Yerusalem. A bergi disi no ben de fara fu Yerusalem. A no ben doro wan kilometer. ");
INSERT INTO srnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Di den doro ini a foto, den go na a kamra na sodro pe den ben e tan a ten dati. Den nen fu den man ben de: Petrus, Yohanes, Yakobus, Andreas, Filipus, nanga Tomas. Bartolomeus, Mateus, nanga Yakobus a manpikin fu Alfeus. Dan yu ben abi ete Simon fu a grupu fu den Seloten, nanga Yudas a manpikin fu Yakobus. ");
INSERT INTO srnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ala den man disi ben tan begi leki wan man makandra nanga Maria a m'ma fu Yesus, den brada fu En, nanga wantu tra umasma. ");
INSERT INTO srnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wan fu den dei dati, Petrus opo tnapu fu taki nanga den bribisma. A dei dati wan hondro nanga tutenti (120) sma so ben kon makandra. ");
INSERT INTO srnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Petrus taigi den taki: “Brada, a sani san skrifi ini a Santa Buku abra Yudas Iskariot ben musu fu psa. Langa ten na fesi, a Santa Yeye ben meki kownu David taki fu Yudas, di ben tyari den sma go grabu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas ben de wan fu unu, èn a ben kisi a srefi wroko fu du leki unu.” ");
INSERT INTO srnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nanga a moni di Yudas ben kisi fu a ogri di a du, a bai wan pisi gron. A fadon langalanga nanga fesi, en bere priti opo, èn en heri inibere kon na doro. ");
INSERT INTO srnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ala den sma fu Yerusalem kon yere a tori dati. Dat' meki den e kari a pisi gron dati na ini den eigi tongo: Akeldama. Dati wani taki: Brudu gron. ");
INSERT INTO srnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petrus taki moro fara taki: “A skrifi ini a buku fu den Psalm taki: Meki a oso fu en tan leigi, no meki no wan sma go libi drape. A skrifi tu taki: Meki wan tra sma du a wroko fu en. ");
INSERT INTO srnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Fu dat'ede un mus teki wan tra sma di kan ferteri makandra nanga wi, tak' Yesus opo baka na dede. A mus de wan sma di ben waka nanga unu sensi a pisten di Masra Yesus teki dopu na Yohanes, te kon miti a dei di Gado teki En go na heimel.” ");
INSERT INTO srnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","So den bribisma tyari tu man kon na fesi: Matias nanga Yosef. Den sma ben sabi Yosef tu leki Barsabas, èn tra sma ben kari en Yustus. ");
INSERT INTO srnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Dan den sma begi taki: “Masra, Yu sabi ala sma ati. Sori wi sortu wan fu den tu man disi Yu ben teki na fesi kba fu wroko leki Yu boskopuman na a presi fu Yudas, di libi a wroko fu go na a presi di fiti en.” ");
INSERT INTO srnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Baka dati den hari wan lot èn a lot fadon tapu Matias. So a tron wan boskopuman fu Yesus tu neleki den tra erfu man. ");
INSERT INTO srnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tapu a Pinksterdei ala den sma fu Yesus ben kon makandra. ");
INSERT INTO srnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dan wantron so den yere wan babari kmopo fu heimel leki te wan tranga winti e wai. A ben furu a heri oso pe den ben de. ");
INSERT INTO srnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne den si fa wan sani leki pikinpikin faya panya go tapu a ede fu ibriwan fu den. ");
INSERT INTO srnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dan ala den sma kon furu nanga a Santa Yeye èn den bigin taki ini tra tongo leki fa a Santa Yeye ben wani fu den taki. ");
INSERT INTO srnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A pisten dati yu ben abi Dyusma ini Yerusalem di ben kmopo na ala sei fu grontapu. Den sma disi ben hori densrefi trutru na a Dyubribi. ");
INSERT INTO srnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Di den yere a babari, wan bigi grupu kon makandra. Den no ben man ferstan fa a kan tak' iniwan fu den ben e yere fa den man ben e taki nanga den ini den eigi tongo. ");
INSERT INTO srnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Den ben ferwondru sote tak' den aksi taki: “Ala den man di e taki drape, a no sma fu Galilea? ");
INSERT INTO srnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Fa a du kon dan tak' wi alamala e yere san den e taki ini wi eigi tongo? ");
INSERT INTO srnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wi kmopo fu Partia, Media, Elam, Mesopotamia, Yudea, Kapadosia, Pontus nanga Asia. ");
INSERT INTO srnNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Trawan fu wi na fu Frigia, Pamfilia, Egipte, nanga den distrikti fu Libia ini a birti fu a foto Sirena. Sma de dya fu Roma tu, Dyusma nanga sma di kon teki a Dyubribi. ");
INSERT INTO srnNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Sosrefi sma fu Kreta nanga Arabia de dya tu. Èn un alamala e yere fa den e taki na ini un eigi tongo fu den bigi sani san Gado du.” ");
INSERT INTO srnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Den ben ferwondru sote èn den no ben sabi san den ben mus prakseri. A wan ben e aksi a trawan taki: “San a sani disi wani taki?” ");
INSERT INTO srnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma tra sma ben e meki spotu taki: “Na drungu den drungu.” ");
INSERT INTO srnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dan Petrus opo tnapu nanga den tra erfu boskopuman fu Yesus. A opo en sten èn a taigi den taki: “Un Dyusma di kmopo fu ala sei, nanga unu di e libi ini Yerusalem, un yere! Arki bun san mi o taigi unu, bika disi na wan sani san un mus sabi. ");
INSERT INTO srnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Den man disi no drungu soleki fa un denki, bika na neigi yuru mamanten un de. ");
INSERT INTO srnNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma san un e si dya, na san a profeiti Yowel ben taki kba. A ben taki: ");
INSERT INTO srnNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Na so Gado e taki: Na ini den laste dei Mi sa meki Mi Yeye kon tapu ala sma. Den manpikin nanga den umapikin fu unu sa taki leki profeiti. Den yonguwan fu unu Mi o sori sani, èn den owruwan fu unu Mi o gi dren. ");
INSERT INTO srnNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ini a ten dati Mi sa meki Mi Yeye kon tapu den man nanga den uma di e wroko gi Mi. Dan den sa taki leki profeiti. ");
INSERT INTO srnNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi o meki wondru de fu si na loktu, èn marki o de fu si na grontapu, soleki brudu, faya nanga furu smoko. ");
INSERT INTO srnNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A son o kon dungru èn a munkenki o kon redi leki brudu fosi a bigi prenspari dei fu Masra doro. ");
INSERT INTO srnNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dan Mi sa ferlusu ala sma di e kari a nen fu Masra.” ");
INSERT INTO srnNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petrus taigi den moro fara taki: “Un sma fu Israel, un arki san mi e taki. Na Gado srefi ben seni Yesus fu Nasaret kon. Dati ben de fu si ini den bigi sani, den wondru, nanga den marki di Gado meki A du na un mindri, leki fa un sabi. ");
INSERT INTO srnNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ma un tyari a Yesus disi gi sma di no sabi a wèt fu Gado, fu den spikri En kiri na wan kroisi. Bika na Gado srefi ben wani meki a psa so. ");
INSERT INTO srnNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ma dan Gado puru Yesus ini a pina fu dede, èn A meki A kon na libi baka. Bika dede no ben man hori En. ");
INSERT INTO srnNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David srefi ben taki fu Yesus di a taki: Mi sabi tak' Masra de ala ten nanga Mi. Fu di A e tnapu na Mi sei meki noti o psa nanga Mi. ");
INSERT INTO srnNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Dat' meki Mi e prisiri èn Mi e singi. Te Mi dede srefi, Mi sa abi howpu. ");
INSERT INTO srnNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bika Yu no o libi Mi na ini dedekondre, èn Yu no o meki a dedeskin fu Yu Santa Wan pori. ");
INSERT INTO srnNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yu sori Mi pasi fu libi, èn Mi o prisiri fu di Yu de nanga Mi.” ");
INSERT INTO srnNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Petrus taigi den moro fara taki: “Brada, mi kan taigi unu krinkrin tak' wi afo David dede kba èn den beri en. A grebi fu en de dya te nanga a dei fu tide. ");
INSERT INTO srnNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David ben de wan profeiti, èn a ben sabi tak' Gado ben pramisi en nanga wan sweri tak' A o poti wan bakapikin fu en leki kownu na ini en presi. ");
INSERT INTO srnNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Bika David ben si na fesi tak' a Mesias bo kon na libi baka di a ben taki tak' Gado no bo libi En na ini dedekondre, èn tak' A no bo meki a dedeskin fu En pori. ");
INSERT INTO srnNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Gado meki a Yesus disi kon baka na libi èn un alamala na kotoigi fu a sani dati. ");
INSERT INTO srnNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dan Gado teki En na heimel èn A gi En a moro hei presi na En let'anu sei. Gado gi En a Santa Yeye di A ben pramisi. Dan Yesus poti a Santa Yeye na wi tapu. Dati na san un e si èn san un e yere now. ");
INSERT INTO srnNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Bika David srefi no ben opo go na heimel, ma a taki: Masra Gado taigi mi Masra taki: Kon sidon na Mi let'anu sei, te leki Mi meki den feyanti fu Yu tron Yu futubangi. ");
INSERT INTO srnNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Fu dat'ede ala sma fu Israel mus sabi krin tak' Gado meki a Yesus disi, di unu spikri na wan kroisi, tron Masra nanga Mesias.” ");
INSERT INTO srnNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Di den sma yere a sani disi, den firi en srefsrefi. Dan den aksi Petrus nanga den tra boskopuman fu Yesus taki: “Brada, san un mus du dan?” ");
INSERT INTO srnNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus piki den taki: “Un mus drai un libi, èn un mus teki dopu ini a nen fu Yesus Kristus, fu un kisi pardon fu un sondu. Dan Gado sa gi unu a Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bika Gado pramisi fu gi a Santa Yeye na unu nanga den pikin fu unu, sosrefi na den sma di de farawe. Masra Gado o gi a Santa Yeye na ala sma di A kari kon na En.” ");
INSERT INTO srnNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nanga furu tra wortu Petrus taki nanga den fu Yesus èn a warskow den taki: “Un drai un libi kmopo na mindri den sma di no e du Gado wani srefsrefi.” ");
INSERT INTO srnNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","So den sma di bribi san Petrus taki teki dopu. Tapu a dei dati, wan dri dusun sma so kon ini a grupu fu den bribisma. ");
INSERT INTO srnNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Den ben e tan hori na a leri fu den boskopuman fu Yesus èn den ben e libi leki wan nanga makandra. Sosrefi den ben nyan èn begi nanga makandra tu. ");
INSERT INTO srnNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ala den sma ben kisi bigi lespeki gi Gado, èn den boskopuman fu Yesus ben du furu wondru èn den ben sori den sma furu marki fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ala den sma di ben teki bribi, ben e kon makandra èn den no ben e hori noti gi densrefi. ");
INSERT INTO srnNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Den ben e seri san den abi dan den prati a moni. Ibri sma ben kisi san a ben abi fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ala dei den bribisma ben e kon makandra ini a mamakerki. Den ben nyan na makandra oso nanga prisiri èn nanga wan krin ati. ");
INSERT INTO srnNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Den ben e prijse Gado, èn a heri folku ben e lespeki den. Ala dei Masra ben e tyari moro sma di A ferlusu, kon na a grupu. ");
INSERT INTO srnNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wan dei Petrus nanga Yohanes go na a mamakerki. A ben de dri yuru bakadina. A yuru dati den Dyusma ben gwenti fu go begi. ");
INSERT INTO srnNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na wan fu den doro fu a mamakerki, di den e kari A Moi Doro, wan man ben sidon di ben lan sensi a gebore. Ala dei sma ben e opo en tyari kon poti na a doro fu begi moni na den sma di ben e kon na a mamakerki. ");
INSERT INTO srnNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Di a man si Petrus nanga Yohanes e waka go na inisei, a aksi den wan pikin sani. ");
INSERT INTO srnNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ne Petrus nanga Yohanes luku en bun, dan Petrus taigi en taki: “Opo yu ede, luku unu!” ");
INSERT INTO srnNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dan a man luku den nanga a prakseri tak' a o kisi wan sani fu den. ");
INSERT INTO srnNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma Petrus taigi en taki: “Moni mi no abi, ma san mi abi mi o gi yu. Ini a nen fu Yesus Kristus fu Nasaret: Opo waka!” ");
INSERT INTO srnNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dan Petrus hori a man na en let'anu. A hari en opo èn a srefi momenti dati den futu fu a man kisi krakti. ");
INSERT INTO srnNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ne a dyompo opo tnapu, dan a bigin waka lontu. A waka go nanga den ini a mamakerki, èn a ben e dyompo e prijse Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ala sma si fa a ben e waka e prijse Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Dan den kon si tak' na a man di ben e sidon begi moni na A Moi Doro fu a mamakerki, èn den ben tnapu nanga opo mofo di den si san psa nanga en. ");
INSERT INTO srnNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A man ben tnapu nomo e anga na Petrus nanga Yohanes. Ala sma ben ferwondru èn den lon go na den ini a Gadri fu Salomo. ");
INSERT INTO srnNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Di Petrus si san e psa, a taigi den sma taki: “Sma fu Israel, fu sanede un e ferwondru fu a sani disi? Fu sanede un e luku leki na ini un eigi krakti un du a sani disi? Ma a no de so tak' na fu di wi e libi leki fa Gado wani, meki a man disi e waka now. ");
INSERT INTO srnNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A Gado fu wi afo Abraham, Isak nanga Yakob, meki En knekti Yesus kisi glori. Un gi En abra na Pilatus, èn srefi di a ben wani lusu En, un taigi en tak' un no wani En. ");
INSERT INTO srnNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Un no ben wani sabi not'noti fu a Santa Wan di bun ini Gado ai. Ma un aksi Pilatus fu lusu wan kiriman gi unu. ");
INSERT INTO srnNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","So un kiri a Wan di e sori unu a pasi fu libi, ma Gado meki A opo baka na dede. Wi na kotoigi fu a sani disi. ");
INSERT INTO srnNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A man disi, di un e si èn di un sabi, bribi ini a nen fu Yesus, èn a nen fu Yesus gi en krakti fu a kon betre. Na fu di a bribi ini a nen fu Yesus meki a kon betre, leki fa un alamala e si. ");
INSERT INTO srnNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","We, brada nanga sisa, mi sabi tak' unu nanga den edeman fu unu no ben sabi san un ben du. ");
INSERT INTO srnNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma tapu sowan fasi a sani kon tru tak' Gado bo meki En Mesias nyan pina, leki fa A ben meki ala den profeiti taki na fesi kba. ");
INSERT INTO srnNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","So, un drai un libi dan èn kon na Gado fu A puru un sondu na un tapu. ");
INSERT INTO srnNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dan Masra sa meki wan ten kon pe wi kan teki bro, èn A sa seni Yesus a Mesias kon, di A ben pramisi unu na fesi kba. ");
INSERT INTO srnNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ma Yesus mus tan na heimel te leki a ten doro pe Gado o meki ala sani kon nyun, leki fa A ben meki den santa profeiti taki langa na fesi kba. ");
INSERT INTO srnNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses srefi ben taki tu: ‘Masra Gado o seni wan tra profeiti leki mi kon gi unu. A o de wan fu un eigi sma. Un mus du ala sani san A taki. ");
INSERT INTO srnNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A sma di no wani arki san a profeiti dati e taki, den o kiri puru na mindri a folku.’ ");
INSERT INTO srnNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Na so Samuel nanga ala den tra profeiti di kon na en baka, ben taki fu a ten disi. ");
INSERT INTO srnNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Den sani san Gado ben taigi den profeiti, na fu unu, sosrefi a ferbontu di A ben meki nanga den afo fu unu. Bika Gado ben taigi Abraham taki: ‘Den bakapikin fu yu o de wan blesi gi ala sma na grontapu.’ ");
INSERT INTO srnNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Di Gado seni En Knekti, A seni En kon gi unu fosi fu blesi unu, meki ibriwan fu unu tapu nanga den ogri san a e du.” ");
INSERT INTO srnNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrus nanga Yohanes ben e taki ete nanga den sma, di den Dyudomri, den Saduseiman, nanga a kapten fu den waktiman fu a mamakerki kon na den. ");
INSERT INTO srnNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Den ben mandi bika Petrus nanga Yohanes ben e leri a folku tak' dedesma o kon na libi baka, fu di Yesus srefi ben kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","So den grabu den tyari go sroto te leki a tra mamanten, bika a ben de mofoneti kba. ");
INSERT INTO srnNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma furu fu den sma di yere a boskopu san Petrus nanga Yohanes taki, teki bribi, èn a grupu gro kon miti feifi dusun sma so. ");
INSERT INTO srnNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A tra mamanten den edeman fu den Dyu, den fesiman fu a folku, nanga den sabiman fu Gado wèt kon makandra ini Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","A grandomri Anas ben drape tu, makandra nanga Kayafas, Yohanes, Aleksander nanga tra famiriman fu a grandomri. ");
INSERT INTO srnNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dan den seni teki Petrus nanga Yohanes. Di den kon, den aksi den taki: “Nanga sortu krakti un dresi a man disi? Suma gi unu a makti fu du sowan sani?” ");
INSERT INTO srnNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dan Petrus, di ben furu nanga a Santa Yeye, piki den taki: “Un edeman nanga fesiman fu a folku, un arki. ");
INSERT INTO srnNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Efu un wani aksi wi tide fu a bun di wi du wan sikisma, èn fa a du kon tak' a kon betre, ");
INSERT INTO srnNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dan unu nanga a heri folku fu Israel mus sabi tak' a man disi kon betre ini a nen fu Yesus Kristus fu Nasaret. Unu ben spikri En na a kroisi, ma Gado meki A kon baka na libi. Na a nen fu Yesus meki tak' a man disi kan tnapu gesontu dya na un fesi. ");
INSERT INTO srnNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus na a ston di un leki wrokoman poti na wan sei, ma a tron a moro prenspari ston fu a heri oso. ");
INSERT INTO srnNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Na En wawan kan ferlusu unu. Bika Gado no gi den sma na grontapu no wan tra nen di sa meki tak' Gado ferlusu den.” ");
INSERT INTO srnNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Di den yere fa Petrus nanga Yohanes ben e taki sondro frede, den ferwondru. Bika den kon si tak' den na sma di no go na hei skoro èn di no kisi furu leri. Dan den kon si tak' den na sma di ben e waka nanga Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma fu di a man di kon betre ben tnapu drape nanga den, den no ben man taki noti. ");
INSERT INTO srnNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","So den man fu a Grankrutu seni den go na dorosei, dan den taki nanga makandra. ");
INSERT INTO srnNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Den taki: “San un mus du nanga den man disi? Bika ala sma dya na Yerusalem si tak' den du wan bigi marki, èn wi no kan taki tak' a no tru. ");
INSERT INTO srnNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma fu no meki moro furu sma yere fu a sani disi, wi o warskow den man trangatranga fu den no taki nanga no wan sma moro ini a nen disi.” ");
INSERT INTO srnNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dan den kari den kon inisei èn den komanderi den fu no taki nanga sma moro fu Yesus, noso leri den ini a nen fu En. ");
INSERT INTO srnNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ma Petrus nanga Yohanes piki den man taki: “San un denki moro bun ini Gado ai? Fu du san unu e taki, noso fu du san Gado e taki? ");
INSERT INTO srnNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bika wi no man kba taki fu den sani di wi ben si nanga san wi ben yere.” ");
INSERT INTO srnNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Den krutubakra warskow den ete wan leisi, dan den seni den gwe. Den no ben man feni wan fasi fu strafu den, bika ala sma ben e gi Gado grani fu a sani di psa. ");
INSERT INTO srnNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bika a man di ben kon betre tapu a ferwondru fasi disi, ben abi moro leki fotenti yari kba. ");
INSERT INTO srnNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Di Petrus nanga Yohanes lusu, den go ferteri den tra bribisma ala san den prenspari domri nanga den fesiman fu a folku taigi den. ");
INSERT INTO srnNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Di den bribisma yere den sani dati, den bigin begi Gado leki wan man taki: “Masra, na Yu meki heimel nanga grontapu, a se nanga ala sani san de na ini den. ");
INSERT INTO srnNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na Yu meki a Santa Yeye taigi wi afo David, Yu knekti, fu taki: San meki den sma di no sabi Gado e rigeri so? Fu sanede den e kruderi fu du sani di den no o man du? ");
INSERT INTO srnNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Den kownu fu grontapu e meki densrefi klari fu feti. Den tiriman fu kondre span anu makandra fu feti Masra nanga En Mesias. ");
INSERT INTO srnNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bika a tru tak' ini a foto disi Herodes nanga Pontius Pilatus, sma fu tra kondre nanga a pipel fu Israel ben span anu makandra fu kiri Yu santa knekti Yesus, di Yu poti leki Mesias. ");
INSERT INTO srnNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Den du ala sani leki fa Yu srefi ben seti en, bika nanga Yu makti Yu ben poti en so na fesi kba. ");
INSERT INTO srnNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Masra, yere fa den e taki tak' den o du sani nanga unu. Yepi den knekti fu Yu fu ferteri sma Yu boskopu sondro frede. ");
INSERT INTO srnNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sori Yu krakti èn dresi sma, meki wondru nanga marki psa ini a nen fu Yu santa knekti Yesus.” ");
INSERT INTO srnNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Di den sma kba begi, a presi pe den ben de seki. Dan ala den sma kon furu nanga a Santa Yeye èn den bigin ferteri a wortu fu Gado sondro frede. ");
INSERT INTO srnNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A grupu fu den bribisma ben de wan ini ala sani, èn no wan fu den ben prakseri fu hori san a abi gi ensrefi. Ala sma ben prati san a abi nanga tra sma. ");
INSERT INTO srnNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Den boskopuman fu Yesus ben e ferteri den sma tapu wan krakti fasi tak' den sabi tak' Masra Yesus opo baka na dede, èn wan bigi blesi ben de tapu ala sma. ");
INSERT INTO srnNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","No wan fu den bribisma ben e pina. Bika den sma di ben abi wan pisi gron noso wan oso ben seri en, èn den ben tyari a moni gi den boskopuman fu Yesus. Dan den man dati ben prati a moni gi den sma di ben abi en fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","So yu ben abi wan Lefitiman di ben kmopo fu Siprus. A man disi ben nen Yosef, ma den boskopuman fu Yesus ben e kari en Barnabas. (A nen Barnabas wani taki: A wan di e gi dek'ati.) ");
INSERT INTO srnNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yosef seri wan pisi gron di a ben abi, dan a tyari a moni kon gi den boskopuman fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wan man Ananias, nanga en frow Safira, seri wan pisi gron fu den tu. ");
INSERT INTO srnNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ma Ananias hori afu fu a moni na baka, èn en frow ben sabi dati. A tra moni a tyari go gi den boskopuman fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dan Petrus taigi en taki: “Ananias, fu sanede yu arki Satan dan yu bedrigi a Santa Yeye? Fu sanede yu hori afu fu a moni na baka di yu kisi fu a gron? ");
INSERT INTO srnNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fosi yu seri a gron, a ben de fu yu, èn baka di yu seri en, yu ben kan du san yu wani nanga a moni. Fa yu ben kan teki a besroiti dan fu du sowan sani? A no libisma yu bedrigi, ma na Gado.” ");
INSERT INTO srnNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Fa Ananias yere den sani dati, a fadon dede. Ala sma di yere san psa kisi bigi lespeki gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dan den yonkuman opo, den domru a dedeskin, dan den tyari en go beri. ");
INSERT INTO srnNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kande wan dri yuru so na baka, a frow fu Ananias kon inisei. A no ben sabi not'noti fu a sani di psa. ");
INSERT INTO srnNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ne Petrus aksi en taki: “Taigi mi, na disi na ala a moni di un kisi fu a gron di un seri?” A frow piki en taki: “Iya, na disi na ala a moni.” ");
INSERT INTO srnNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dan Petrus taigi en taki: “Fa yu nanga yu masra ben kan meki mofo fu bedrigi a Yeye fu Masra? Luku, den sma di beri yu masra de na mofodoro, èn den o tyari yu go beri tu.” ");
INSERT INTO srnNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Fa Petrus kba taki, so a frow fadon dede let' na en fesi. Di den yonkuman kon na inisei, den si tak' a frow dede tu. So den teki en tyari go beri sei en masra. ");
INSERT INTO srnNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A sani disi meki a heri gemeente nanga ala den tra sma di yere fu en, kisi bigi lespeki gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Den boskopuman fu Yesus ben du furu wondru na mindri fu a pipel, èn den sori den furu marki fu Gado. Ala den bribisma ben abi a gwenti fu kon makandra ini wan fu den gadri fu a mamakerki di ben nen: a Gadri fu Salomo. ");
INSERT INTO srnNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tra sma ben frede fu moksi nanga den bribisma, ma a pipel ben e lespeki den. ");
INSERT INTO srnNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A grupu fu den bribisma ben e kon moro bigi, fu di furu man nanga uma ben e teki bribi ini Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A ben de so tak' den ben tyari den sikisma tapu matrasi nanga papaya kon poti na strati, soso fu a schaduw fu Petrus ben kan fadon na den tapu te a e psa. ");
INSERT INTO srnNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Srefi den sma fu den foto lontu Yerusalem ben tyari sikisma kon, nanga sma di ben abi takruyeye na den tapu. Èn ala den sma dati ben kon betre. ");
INSERT INTO srnNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma a grandomri fu den Dyu nanga ala den Saduseiman di ben de nanga en, kon dyarusu tapu den boskopuman fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","So den grabu den tyari go poti ini straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma a neti dati wan engel fu Masra kon opo den doro fu a straf'oso, dan a tyari den go na dorosei. ");
INSERT INTO srnNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","A taigi den taki: “Go tnapu ini a mamakerki, dan un ferteri a folku ala den wortu disi di e gi libi.” ");
INSERT INTO srnNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Den man du san a engel taigi den. Di dei opo, den go ini a mamakerki dan den bigin gi den sma leri. Di a grandomri nanga den man fu en doro, a kari a Grankrutu kon makandra. Dati na a konmakandra fu ala den fesiman fu den Dyu. Dan den seni waktiman fu a mamakerki fu go teki den boskopuman fu Yesus kon fu straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ma di den opo a doro fu a straf'oso den no si den man drape. So den drai go baka go taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“A straf'oso ben sroto bun èn den waktiman ben tnapu tapu den presi, ma di wi opo den doro, no wan sma ben de inisei.” ");
INSERT INTO srnNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Di a kapten fu den waktiman nanga den prenspari domri yere a sani dati, den no ben sabi san den ben mus prakseri èn san bo psa moro fara. ");
INSERT INTO srnNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dan wan sma kon taigi den taki: “Den man di un ben sroto, de ini a mamakerki e gi den sma leri.” ");
INSERT INTO srnNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dan a kapten nanga den waktiman gwe go teki den. Ma den no tyari den kon nanga tranga, bika den ben frede tak' den sma bo fringi ston na den tapu. ");
INSERT INTO srnNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Den tyari den boskopuman fu Yesus kon na fesi a Grankrutu fu den Dyu, dan a grandomri taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Wi ben warskow unu trangatranga tak' un no mus gi den sma leri ini a nen fu Yesus. Ma luku, un furu heri Yerusalem nanga a leri fu unu, èn un wani meki wi tyari a nen tak' na wi kiri a man disi.” ");
INSERT INTO srnNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dan Petrus nanga den tra boskopuman fu Yesus taki: “Wi mus arki Gado moro leki libisma. ");
INSERT INTO srnNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Un spikri Yesus na wan kroisi, meki A dede. Ma a Gado fu wi afo meki A kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dan Gado gi En a moro hei presi na En let'anu sei. A meki A tron Fesiman nanga Ferlusuman, so den sma fu Israel kan drai den libi èn feni pardon fu den sondu. ");
INSERT INTO srnNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wi na kotoigi fu den sani disi. Èn a Santa Yeye di Gado gi den sma di e du En wani, na wan kotoigi tu.” ");
INSERT INTO srnNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Di den man fu a Grankrutu yere a sani disi, den kisi sowan atibron tak' den ben wani kiri den boskopuman fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ma wan fu den man opo, dan a taigi den fu tyari den boskopuman fu wan pisten go na dorosei. A ben de wan Fariseiman di ben nen Gamaliyel. A ben e leri den sma Gado wèt, èn a heri folku ben e lespeki en. ");
INSERT INTO srnNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dan Gamaliyel taigi den tra man taki: “Kondreman, un prakseri bun fosi un du den man disi wan sani. ");
INSERT INTO srnNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bika wan pisten di psa, wan man Tedas ben de di ben si ensrefi leki wan prenspari man. Wan fo hondro sma so ben waka na en baka. Ma den kiri en, èn den sma di ben waka na en baka panya go na ala sei. So a heri sani dede gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Baka dati ini a ten di lanti ben teri a pipel, wan man Yudas fu Galilea opo. Furu sma ben waka na en baka, ma en srefi dede tu èn den sma di ben waka na en baka panya. ");
INSERT INTO srnNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dat' meki mi wani gi un a rai fu no du den man disi noti. Libi den. Bika efu san den e leri nanga san den e du kmopo fu libisma, dan wan kba o kon na en. ");
INSERT INTO srnNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma efu na wan sani fu Gado, dan un no o man tapu den. Un mus luku bun tak' un no e feti nanga Gado.” Den man fu a Grankrutu teki san Gamaliyel taigi den. ");
INSERT INTO srnNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Den seni kari den boskopuman fu Yesus kon na inisei baka, den meki den fon den, dan den warskow den fu no leri den sma moro ini a nen fu Yesus. Baka dati den seni den gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Di den boskopuman fu Yesus gwe libi a Grankrutu, den ben breiti fu di Gado ben feni tak' den fiti fu kisi fonfon fu Yesus ede. ");
INSERT INTO srnNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Èn ala dei, sondro fu kba, den ben e gi den sma leri ini a mamakerki nanga ini den oso, èn den ferteri den a Bun Nyunsu tak' Yesus na a Mesias. ");
INSERT INTO srnNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Den bribisma ben kon moro furu èn den wan di ben e taki Grikitongo ben e krut'krutu tapu den wan di ben e taki Dyutongo. Den ben feni tak' den uma fu den di masra dede kba, no ben kisi a moni di den ben mus kisi ala dei fu bai den nyanyan. ");
INSERT INTO srnNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","So den twarfu boskopuman fu Yesus kari ala den bribisma kon makandra. Dan den taigi den taki: “A no de wan bun sani tak' wi no abi ten fu preiki a wortu fu Gado, fu di wi mus luku nomo tak' tra sani e waka bun. ");
INSERT INTO srnNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Brada nanga sisa, dat' meki un mus suku seibi man na un mindri di den sma sabi leki bun sma. Den mus koni èn den mus furu nanga a Santa Yeye, fu wi kan poti den fu du a wroko disi. ");
INSERT INTO srnNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dan wi fu wi sei sa go doro fu begi èn fu preiki a wortu fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ala den bribisma ben agri nanga a sani disi. So den teki seibi man na den mindri. Den man dati ben de Stefanus, di ben abi wan tranga bribi èn di ben furu nanga a Santa Yeye. Moro fara den teki Filipus, Prokorus, Nikanor, Timon, Parmenas nanga Nikolaus fu a foto Antiokia. A man disi no ben de wan Dyu, ma fosi a tron wan bribisma, a ben teki a Dyubribi. ");
INSERT INTO srnNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dan den tyari den seibi man disi gi den boskopuman fu Yesus, di begi gi den èn poti anu na den tapu. ");
INSERT INTO srnNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","So a wortu fu Gado ben panya go moro fara, èn a grupu fu den bribisma ini Yerusalem ben kon moro bigi. Bun furu Dyudomri srefi ben teki bribi ini Masra Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gado ben sori Stefanus En bun-ati psa marki èn A gi en krakti. So Stefanus bigin du wondru èn a sori a pipel bigi marki. ");
INSERT INTO srnNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma wantu sma ben feni tak' a leri fu Stefanus no bun. Den sma dati ben kmopo fu den foto Sirena nanga Aleksandria, èn den ben de fu a Dyukerki di ben nen: A Dyukerki fu den Libertijnsma. Makandra nanga tra Dyusma fu Silisia nanga a distrikti Asia, den man dati go na Stefanus fu hari taki nanga en. ");
INSERT INTO srnNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma den no ben man piki noti tapu den koni sani di a Yeye ben meki Stefanus taki. ");
INSERT INTO srnNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","So den pai wantu man fu ferteri lei fu Stefanus. Den man dati taki: “Un yere fa a afrontu Moses nanga Gado.” ");
INSERT INTO srnNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na so den tyari dyugudyugu mindri a pipel, den fesiman fu a folku, nanga den sabiman fu Gado wèt. Dan den grabu Stefanus èn den srepi en tyari go fesi a Grankrutu fu den Dyu. ");
INSERT INTO srnNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dan den tyari tra sma kon di ben lei gi Stefanus. Den taki: “A man disi no e kba fu taki takru fu a Santa Presi disi nanga a wèt fu Moses. ");
INSERT INTO srnNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bika wi yere fa a taki tak' Yesus fu Nasaret o broko a presi disi puru èn kenki den gwenti di Moses ben leri wi.” ");
INSERT INTO srnNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dan ala den man fu a Grankrutu di ben sidon fu krutu Stefanus, hori ai na en tapu èn den si fa en fesi ben gersi di fu wan engel. ");
INSERT INTO srnNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dan a grandomri aksi Stefanus taki: “A tru tak' yu taki den sani disi?” ");
INSERT INTO srnNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ne Stefanus piki en taki: “P'pa nanga brada, arki san mi o taki. Fosi wi afo Abraham go libi na Haran, a Gado fu glori sori Ensrefi na en di a ben e libi na Mesopotamia ete. ");
INSERT INTO srnNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A taigi en taki: ‘Libi yu kondre nanga yu famiri èn go na a kondre di Mi sa sori yu.’ ");
INSERT INTO srnNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","So Abraham gwe libi a kondre fu den Kaldeasma dan a go libi na Haran. Baka di en p'pa dede, Gado puru en fu drape dan A tyari en kon na a kondre pe unu e libi now. ");
INSERT INTO srnNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gado no gi en no wan pisi fu a kondre tak' na fu en, no wan pikin pisi srefi. Ma A pramisi en tak' a heri kondre sa de fu den bakapikin fu en, awinsi a no ben abi pikin ete. ");
INSERT INTO srnNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gado taigi en taki: ‘Den bakapikin fu yu o go libi leki doroseisma ini wan tra kondre. Drape den sma o teki den leki srafu, èn den o pina den fo hondro yari langa. ");
INSERT INTO srnNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ma Mi sa strafu a kondre di o meki den wroko leki srafu. Baka dati den o kmopo fu a kondre dati èn kon anbegi Mi ini a presi disi.’ ");
INSERT INTO srnNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dan Gado meki wan ferbontu nanga Abraham, èn A taigi en taki a mus besnei ala den mansma fu en leki marki tak' wan ferbontu meki. Dat' meki di Isak, a boi fu Abraham, kon gebore, a besnei en tapu a di fu aiti dei. Isak tron p'pa fu Yakob èn Yakob tron p'pa fu twarfu boi di tron den afo fu den lo fu Israel. ");
INSERT INTO srnNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ma den afo disi fu unu ben dyarusu tapu Yosef. Dat' meki den seri en gi sma di tyari en go leki srafu na Egipte. Ma Gado ben de nanga en. ");
INSERT INTO srnNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","A puru en ini ala en nowtu. A gi en koni èn A meki tak' Farao, a kownu fu Egipte, sori en bun-ati. Dan Farao poti en leki granman fu Egipte, nanga edeman fu ala sani san a ben abi. ");
INSERT INTO srnNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Baka dati wan angriten broko ini heri Egipte nanga Kanaankondre. Den sma bigin pina èn den afo fu wi no ben man feni noti fu nyan. ");
INSERT INTO srnNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ma di Yakob yere tak' nyanyan ben de ini Egipte, a seni den afo fu unu go drape fu a fosi leisi. ");
INSERT INTO srnNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Di den go a di fu tu leisi, Yosef taigi den brada fu en suma a de, èn Farao kon yere fu a famiri fu Yosef. ");
INSERT INTO srnNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dan Yosef seni teki en p'pa Yakob nanga ala en famiri kon. A famiri fu en ben abi seibitenti-na-feifi (75) sma. ");
INSERT INTO srnNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","So Yakob go na Egipte èn drape en nanga den afo fu wi tan te leki den dede. ");
INSERT INTO srnNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Den bakapikin fu den tyari den dedeskin kmoto fu Egipte go na Sikem. Drape den beri den ini a grebi di Abraham ben bai fu den manpikin fu Hemor nanga moni. ");
INSERT INTO srnNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Di a ten kon krosbei fu Gado du san A ben pramisi Abraham, a pipel fu wi ben kon furu ini Egipte. ");
INSERT INTO srnNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Dan wan tra Farao di no ben sabi Yosef, bigin tiri Egipte. ");
INSERT INTO srnNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A Farao dati kisi den bigisma fu wi nanga triki, èn a libi takru nanga den. A dwengi den fu poti den watrapikin na dorosei meki den dede. Tapu sowan fasi a pipel bo dede gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ini a ten dati Moses kon gebore èn a ben moi ini Gado ai. Dri mun langa den sorgu en na oso. ");
INSERT INTO srnNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Baka di den ben mus poti en na dorosei, a umapikin fu Farao teki en dan a kweki en leki en eigi pikin. ");
INSERT INTO srnNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses kisi leri ini ala koni fu den Egiptesma. A tron wan bun takiman èn a ben du bigi sani. ");
INSERT INTO srnNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Di a ben abi fotenti yari, a teki a besroiti fu go luku fa a ben e go nanga den brada fu en, den sma fu Israel. ");
INSERT INTO srnNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dan a si fa wan fu den e kisi fonfon fu soso. So a dyompo gi a wan di ben kisi a fonfon fu yepi en, èn a naki a man fu Egipte kiri fu pai en baka. ");
INSERT INTO srnNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses ben prakseri tak' den sma fu en bo ferstan tak' Gado seni en fu puru den na ini katibo. Ma den no ben ferstan a sani dati. ");
INSERT INTO srnNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A tra dei di Moses go baka na den sma fu en, a si fa tu fu den e feti. A go na den fu tapu a feti, èn a taigi den taki: ‘Unu na brada, fu sanede un e feti?’ ");
INSERT INTO srnNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ma a wan di ben meki a trobi, pusu Moses go na wan sei dan a taigi en taki: ‘Suma poti yu leki wi edeman nanga wi krutubakra? ");
INSERT INTO srnNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Na kiri yu wani kiri mi tu, leki fa yu kiri a man fu Egipte esde?’ ");
INSERT INTO srnNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Di a man taki a sani dati, Moses lowe gwe go tan leki wan doroseisma ini Midyankondre. Drape a kisi tu boi. ");
INSERT INTO srnNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Baka fotenti yari wan engel sori ensrefi na Moses ini a dreisabana krosbei fu a bergi Sinai. A sori ensrefi ini a faya fu wan pikin bon di ben e bron. ");
INSERT INTO srnNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ferwondru di a si a sani dati. Ma di a ben e waka go fu luku a sani moro bun, a yere a sten fu Masra taigi en taki: ");
INSERT INTO srnNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mi na a Gado fu den afo fu yu, a Gado fu Abraham, Isak nanga Yakob.’ Moses skreki tak' a beifi èn a no ben abi dek'ati fu go luku moro. ");
INSERT INTO srnNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dan Masra taigi Moses moro fara taki: ‘Puru yu susu na yu futu, bika a gron tapu san yu e tnapu na santa gron. ");
INSERT INTO srnNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi si bunbun fa den e pina Mi pipel ini Egipte èn Mi yere fa den e dyeme. Dat' meki Mi saka kon fu ferlusu den. So, kon dya, Mi o seni yu go baka na Egipte.’ ");
INSERT INTO srnNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","A srefi Moses disi, den sma poti na wan sei di den taki: ‘Suma poti yu leki edeman nanga krutubakra?’ Ma Gado poti en leki edeman nanga ferlusuman fu a pipel, nanga a yepi fu a engel di ben sori ensrefi ini a pikin bon di ben e bron. ");
INSERT INTO srnNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses du furu wondru nanga marki di a tyari den kmopo fu Egiptekondre, sosrefi di den abra a Redi Se, nanga di den ben de ini a dreisabana fotenti yari langa. ");
INSERT INTO srnNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Na a srefi Moses dati taigi a pipel fu Israel taki: ‘Gado o seni wan profeiti leki mi kon gi unu di sa kmopo na un mindri.’ ");
INSERT INTO srnNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na a Moses disi ben de nanga a pipel di den kon makandra ini a dreisabana. A ben de nanga den bigisma fu wi èn a ben de nanga a engel di ben taki nanga en tapu a bergi Sinai. Na en kisi wortu san e gi libi, fu gi unu. ");
INSERT INTO srnNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ma den bigisma fu unu no ben wani du san Moses taigi den. Den poti en na wan sei, èn ini den ati den ben angri fu go baka na Egipte. ");
INSERT INTO srnNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Dan den taigi Aaron taki: ‘Meki popki gi unu fu un anbegi leki gado, dan den sa tyari unu go moro fara. Bika un no sabi san psa nanga a man Moses di tyari unu kmopo fu Egiptekondre.’ ");
INSERT INTO srnNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","So den meki wan popki di ben gersi wan yongu kaw fu anbegi leki gado. Den tyari offer gi en èn den ben abi prisiri nanga san den srefi meki. ");
INSERT INTO srnNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ma Gado drai En baka gi den, èn A libi den fu dini den sani di de fu si na loktu. Ala den sani disi skrifi ini a buku fu den profeiti. Drape a skrifi taki: Sma fu Israel, na gi Mi un ben kiri meti? Na gi Mi un ben tyari offer den fotenti yari ini a dreisabana? ");
INSERT INTO srnNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nono! Un ben syow a tenti fu Molok nanga a stari fu Romfa. Un srefi meki den sani dati fu anbegi den. Fu dat'ede Mi sa tyari un gwe te psa Babilon. ");
INSERT INTO srnNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Di den bigisma fu unu ben de ini a dreisabana, den ben abi a tenti na den di ben kotoigi tak' Gado de nanga den. Gado ben taigi Moses fa a mus meki en, dan Moses meki en leki a eksempre di a si. ");
INSERT INTO srnNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Makandra nanga Yosua den bigisma fu unu tyari a tenti disi kon dya, di den ben kisi fu den bigisma fu den. Gado yagi den sma puru di ben libi ini a kondre disi, meki den afo fu unu teki en abra. Èn a tenti tan na den te leki a ten fu kownu David. ");
INSERT INTO srnNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Gado ben sori David bun-ati, dan David aksi En efu a ben kan bow wan oso gi En, a Gado fu Yakob. ");
INSERT INTO srnNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma a ben de Salomo di bow wan oso gi En. ");
INSERT INTO srnNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ma leki fa a profeiti taki, a Moro Hei Gado no e libi ini oso di libisma meki. A skrifi taki: ");
INSERT INTO srnNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Masra taki: Heimel na Mi kownusturu, èn grontapu na Mi futubangi. Sortu oso un o man bow gi Mi? Sortu presi un o man gi Mi fu Mi rostu? ");
INSERT INTO srnNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A no Mi srefi meki ala den sani disi? ");
INSERT INTO srnNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Un trangayesi sma unu! Un besnei, ma ini un ati un de leki sma di no sabi Gado. Un no wani arki Gado èn neleki den bigisma fu unu, un no wani du san a Santa Yeye e taki. ");
INSERT INTO srnNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Den bigisma fu unu ben de na baka ala den profeiti fu du den ogri. Den kiri srefi den man di ben taki na fesi tak' wan Sma o kon di bun ini Gado ai. Dan now un seri En èn un kiri En. ");
INSERT INTO srnNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Den engel ben tyari a wèt kon gi unu, ma un no du san a e taki.” ");
INSERT INTO srnNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Di den man fu a Grankrutu yere san Stefanus taki, den kisi sowan atibron tak' den bigin kaw den tifi. ");
INSERT INTO srnNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma Stefanus, di ben furu nanga a Santa Yeye, luku go na heimel. A si a glori fu Gado èn a si Yesus tnapu na a let'anu sei fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dan a taki: “Luku, mi e si heimel opo, èn mi e si a Manpikin fu Libisma tnapu na Gado let'anu sei.” ");
INSERT INTO srnNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ma ala den man bigin bari trangatranga, den tapu den yesi, èn den lon go na Stefanus tapu. ");
INSERT INTO srnNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Den srepi en go na dorosei fu a foto, dan den fringi ston na en tapu fu kiri en. Den kotoigi puru den dyakti poti na den futu fu wan yonkuman di ben nen Saulus. ");
INSERT INTO srnNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Di den e fringi ston na en tapu, Stefanus begi taki: “Masra Yesus, teki mi yeye.” ");
INSERT INTO srnNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ne a fadon tapu en kindi èn a bari: “Masra, gi den pardon fu a sondu disi.” Di a taki a sani disi, a dede. ");
INSERT INTO srnNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus ben feni en bun tak' den kiri Stefanus. Dan bigin fu a dei dati, sma ben de nomonomo baka den sma fu a gemeente na Yerusalem fu du den ogri. Dat' meki ala den bribisma panya go na den distrikti Yudea nanga Samaria. Soso den boskopuman fu Yesus ben tan na baka. ");
INSERT INTO srnNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nanga furu krei wantu man di ben e libi leki fa Gado wani, tyari a dedeskin fu Stefanus go beri. ");
INSERT INTO srnNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulus ben e suku fu broko a gemeente nanga tranga. A ben go ini ala den oso èn a ben srepi man nanga uma kon na dorosei, dan a ben tyari den go sroto. ");
INSERT INTO srnNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Den bribisma di lowe ben ferteri a Bun Nyunsu ala presi pe den go. ");
INSERT INTO srnNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","So a psa tak' Filipus go na a foto fu Samaria èn a ferteri den fu a Mesias. ");
INSERT INTO srnNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Furu sma ben arki san Filipus taki èn di den si den bigi marki di a du, den poti yesi arki en moro bun. ");
INSERT INTO srnNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bika takruyeye ben kmopo nanga bigi babari tapu furu sma, èn furu lanman nanga malengrisma ben kon betre. ");
INSERT INTO srnNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Dat' meki wan bigi prisiri kon ini a foto dati. ");
INSERT INTO srnNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma fosi dati, wan man di ben nen Simon ben e du tofruwroko ini a foto, èn a ben meki ala sma fu Samaria ferwondru. A ben taki fu ensrefi tak' en na wan prenspari sma. ");
INSERT INTO srnNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ala sma, pikinwan nanga bigiwan, ben e tan arki san Simon e taki, èn den ben e taki fu en taki: “A man disi abi san yu e kari a bigi krakti fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Den sma ben tan arki en bika a ben meki den ferwondru wan heri pisten kba nanga den tofruwroko fu en. ");
INSERT INTO srnNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ma di Filipus ferteri den a Bun Nyunsu fu Yesus Kristus nanga a fasi fa Gado wani tiri libisma, den bribi en, èn mansma nanga umasma teki dopu. ");
INSERT INTO srnNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon srefi bribi èn a teki dopu tu. Dan a tan waka na Filipus baka èn a ferwondru srefsrefi fu si den marki fu Gado di ben e psa, nanga ala den tra bigi sani. ");
INSERT INTO srnNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Di den boskopuman fu Yesus ini Yerusalem yere tak' den sma fu Samaria bribi a wortu fu Gado, den seni Petrus nanga Yohanes go drape. ");
INSERT INTO srnNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Di den doro, den begi gi den sma fu den kisi a Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bika den ben dopu ini a nen fu Masra Yesus, ma no wan fu den ben kisi a Santa Yeye ete. ");
INSERT INTO srnNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","So Petrus nanga Yohanes poti anu na den tapu èn den kisi a Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dan Simon langa moni gi den boskopuman fu Yesus di a si tak' den sma ben kisi a Santa Yeye te den ben poti anu na den tapu. ");
INSERT INTO srnNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","A taigi den taki: “Un gi mi a makti tu, fu sma kan kisi a Santa Yeye te mi poti anu na den tapu.” ");
INSERT INTO srnNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ma Petrus taigi en taki: “Yu nanga yu moni kan go na hel! Fa yu kan prakseri tak' yu kan bai san Gado e gi fu soso? ");
INSERT INTO srnNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yu no man teki prati ini a wroko disi, bika yu ati no de tapu a leti presi ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tapu nanga den takru denki disi, dan yu begi Gado efu A wani gi yu pardon fu a prakseri di kon ini yu ede. ");
INSERT INTO srnNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bika mi e si fa yu lai nanga wan bita dyarusu èn fa sondu tai yu ete.” ");
INSERT INTO srnNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dan Simon aksi taki: “Begi Masra gi mi tak' noti fu den sani san yu taki sa miti mi.” ");
INSERT INTO srnNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Baka di Petrus nanga Yohanes ferteri a wortu fu Masra èn kotoigi fu En, den drai go baka na Yerusalem. Di den ben de na pasi, den ferteri a Bun Nyunsu na furu dorpu ini Samaria. ");
INSERT INTO srnNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dan wan engel fu Masra taigi Filipus taki: “Tide bakadina yu mus go na a pasi di e waka fu Yerusalem go na Gasa.” Furu sma no e waka na tapu a pasi dati. ");
INSERT INTO srnNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","So Filipus go. Di a doro drape a si wan man fu Etiopia. A ben de wan eunuch èn a ben de wan prenspari man di ben luku den moni tori fu Kandaka, a frow di ben rigeri Etiopia. A man disi ben kmopo fu Yerusalem pe a ben go anbegi Gado, èn a ben sidon ini en wagi e leisi a buku fu a profeiti Yesaya. ");
INSERT INTO srnNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dan a Santa Yeye taigi Filipus taki: “Go waka sei a wagi dati.” ");
INSERT INTO srnNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","So Filipus lon go na a wagi, èn a yere fa a man e leisi ini a buku fu a profeiti Yesaya. Dan a aksi en taki: “Yu e ferstan san yu e leisi?” ");
INSERT INTO srnNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A man piki Filipus taki: “Fa mi kan ferstan en, efu no wan sma no de di kan tyari en kon na krin gi mi?” Dan a man aksi Filipus fu kon sidon na en sei ini a wagi. ");
INSERT INTO srnNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A pisi fu a Santa Buku di a ben leisi ben taki: Neleki wan skapu, den tyari En go srakti, èn soleki fa wan pikin skapu no e meki babari te den e puru den wiwiri na en skin, na so A no ben opo En mofo tu. ");
INSERT INTO srnNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Den broko En saka, èn den no gi En no wan leti. Sma no o man taki fu bakapikin fu En, bika den kiri En puru na grontapu. ");
INSERT INTO srnNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dan a man fu Etiopia aksi Filipus taki: “Taigi mi, fu suma Yesaya e taki? Fu ensrefi, noso fu wan tra sma?” ");
INSERT INTO srnNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dan Filipus bigin nanga a srefi pisi dati fu a Santa Buku fu ferteri en fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Di den rei moro fara den si wan kriki. Ne a man aksi Filipus taki: “Luku, watra dya. San e hori mi ete fu teki dopu?” ");
INSERT INTO srnNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipus taigi a man taki: “Efu yu e bribi nanga yu heri ati, yu kan dopu.” A man piki Filipus taki: “Mi e bribi tak' Yesus Kristus na a Manpikin fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","So a meki a wagi tan tnapu. Dan en nanga Filipus saka go ini a watra èn Filipus dopu en. ");
INSERT INTO srnNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Di den kmopo fu a watra, a Yeye fu Masra teki Filipus tyari gwe. A man no ben si en moro, ma nanga prisiri a gwe moro fara. ");
INSERT INTO srnNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipus ben feni ensrefi te ini a foto Asdod. Drape a ben waka lontu na ala foto e ferteri den sma a Bun Nyunsu te leki a doro na a foto Sesarea. ");
INSERT INTO srnNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma a pisten dati, Saulus ben taki nanga atibron ete tak' a o kiri den sma di e bribi ini Masra. A go na a grandomri, ");
INSERT INTO srnNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","dan a teki brifi fu tyari go na den Dyukerki fu a foto Damaskus. Drape a ben wani grabu man nanga uma di de fu a Nyun Pasi fu tyari den go sroto na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Di a doro krosbei fu Damaskus, wantron so wan krin faya fadon fu heimel lontu en. ");
INSERT INTO srnNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ne a fadon na gron dan a yere wan sten aksi en taki: “Saul, Saul, fu sanede yu de na Mi baka fu du Mi ogri?” ");
INSERT INTO srnNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulus aksi taki: “Masra, suma na Yu?” A sten piki en taki: “Mi na Yesus di yu e du ogri. ");
INSERT INTO srnNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ma opo tnapu, dan yu e go ini a foto. Drape yu o yere san yu mus du.” ");
INSERT INTO srnNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Den man di ben de nanga Saulus ben tan tnapu nanga opo mofo, bika den ben yere wan sten, ma den no ben si no wan sma. ");
INSERT INTO srnNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Di Saulus opo tnapu, a no ben man si, aladi en ai ben opo. Dan den man di ben de nanga en, hori en na en anu tyari go ini Damaskus. ");
INSERT INTO srnNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Dri dei langa Saulus no ben man si noti. A no nyan èn a no dringi no wan sani tu. ");
INSERT INTO srnNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ini Damaskus wan bribisma ben de di ben nen Ananias. Masra sori en wan sani. A si fa Masra e taigi en taki: “Ananias.” A piki taki: “Iya, Masra, dya mi de.” ");
INSERT INTO srnNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dan Masra taigi en taki: “Opo go na a oso fu Yudas di e libi ini a strati di den e kari: Langa-strati. Drape yu mus aksi fu wan man Saulus fu a foto Tarsus. A e begi nownow. ");
INSERT INTO srnNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mi sori en wan sani: a si fa wan man di nen Ananias kon inisei, dan a poti anu na en tapu fu a ben kan si baka.” ");
INSERT INTO srnNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ma Ananias taki: “Masra, someni sma ferteri mi kba fu a man disi, fa a du den sma fu Yu na Yerusalem someni ogri. ");
INSERT INTO srnNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Èn a kisi makti fu den prenspari domri fu grabu ala sma dya di e kari Yu nen.” ");
INSERT INTO srnNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ma Masra taigi Ananias taki: “Yu mus go, bika Mi teki a man disi fu wroko gi Mi. A sa meki sma kon yere fu Mi: sma di no de Dyu, den kownu fu den, nanga den sma fu Israel. ");
INSERT INTO srnNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi o sori en omeni pina a o abi fu nyan fu Mi nen ede.” ");
INSERT INTO srnNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","So Ananias go na a oso. A poti en anu tapu Saulus, dan a taigi en taki: “Brada Saul, Masra Yesus di sori Ensrefi na yu na pasi, seni mi kon fu yu kan si baka, èn fu yu kon furu nanga a Santa Yeye.” ");
INSERT INTO srnNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","A srefi momenti dati, wan sani leki buba fadon kmopo fu Saulus en ai èn a ben man si baka. Dan a opo èn a teki dopu. ");
INSERT INTO srnNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Baka dati a nyan èn a kisi krakti baka. Saulus tan wantu dei nanga den bribisma fu Damaskus, ");
INSERT INTO srnNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","dan wantron a bigin ferteri ini den Dyukerki tak' Yesus na a Manpikin fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ala sma di yere en, ferwondru srefsrefi. Den taki: “A no a man di ben e puru ala sma na pasi ini Yerusalem di ben kari a nen disi? A no kon a kon dya fu grabu den tyari go gi den prenspari domri?” ");
INSERT INTO srnNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ma moro nanga moro Saulus ben e sori den sma tapu wan krakti fasi tak' a tru tak' Yesus na a Mesias. Den Dyu di ben libi ini Damaskus, no ben sabi san den ben mus prakseri fu a sani disi. ");
INSERT INTO srnNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Baka wan pisten den Dyu meki mofo fu kiri en. ");
INSERT INTO srnNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dei nanga neti den ben hori wakti na den doro fu a foto fu kiri en. Ma Saulus ben kisi a sani disi fu yere. ");
INSERT INTO srnNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","So den man di ben e teki leri fu Saulus, teki en na neti dan den saka en ini wan baskita abra a stonskotu fu a foto. ");
INSERT INTO srnNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Di a doro na Yerusalem, a meki muiti fu kon mindri den bribisma, ma den ben frede fu en bika den no ben man bribi tak' a tron wan bribisma tu. ");
INSERT INTO srnNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ma Barnabas go yepi Saulus. A tyari en go na den boskopuman fu Yesus, dan a ferteri den fa Saulus ben si Masra na pasi, èn fa Masra ben taki nanga en. A ferteri den moro fara fa a ben taki sondro frede ini a nen fu Yesus nanga den sma ini Damaskus. ");
INSERT INTO srnNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","So Saulus tan na den bribisma ini Yerusalem. A ben e waka fri èn sondro frede a ben taki ini a nen fu Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A ben hari taki nanga den Dyusma di ben taki Grikitongo, ma den disi ben wani kiri en. ");
INSERT INTO srnNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Di den bribisma kisi a sani disi fu yere, den tyari Saulus go na a foto Sesarea. Fu drape den seni en go na a foto Tarsus. ");
INSERT INTO srnNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dan ala den bribisma fu Yudea, Galilea nanga Samaria ben libi ini freide. A bribi fu den ben kon moro tranga èn den ben abi bigi lespeki gi Gado. A Santa Yeye ben yepi den tu tak' moro nanga moro sma teki bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Di Petrus ben e waka lontu na ala presi, a doro tu na den sma fu Gado ini Lida. ");
INSERT INTO srnNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Drape a miti nanga wan lanman di ben nen Eneas. Aiti yari langa a man disi ben didon na bedi kba. ");
INSERT INTO srnNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus taigi en taki: “Eneas, Yesus Kristus e dresi yu. Opo, dan yu srefi meki yu bedi.” Ne Eneas opo wantron. ");
INSERT INTO srnNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dan ala sma fu Lida nanga a kontren fu Saron si en èn den teki bribi ini Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ini Yopa wan bribisma ben e libi di ben nen Tabita. Ini Grikitongo a nen dati na Dorkas. A ben e du furu bun sani èn a ben e yepi pôtisma. ");
INSERT INTO srnNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ini a ten dati, a kon siki èn a dede. Baka di den wasi a dedeskin, den poti en ini wan kamra na sodro. ");
INSERT INTO srnNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa no ben de fara fu Lida. Di den bribisma fu Yopa yere tak' Petrus de ini Lida, den seni tu man go na en. Den ben mus begi en efu a ben kan kon wantewante na den. ");
INSERT INTO srnNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","So Petrus opo go nanga den. Di a doro, den tyari en go na sodro na a kamra pe a dedeskin ben de. Ala den umasma di masra dede kba, ben kon tnapu lontu Petrus e krei. Den sori en ala den krosi di Dorkas ben meki di a ben de na libi ete. ");
INSERT INTO srnNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Baka di Petrus seni den alamala go na dorosei, a kindi èn a begi. Dan a drai taigi a dedeskin taki: “Tabita, opo!” Ne Tabita opo en ai, èn di a si Petrus, a opo sidon. ");
INSERT INTO srnNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petrus langa en anu gi en fu yepi en opo tnapu. Dan a kari den uma di masra dede kba, makandra nanga den tra sma fu Gado, fu sori den tak' Dorkas kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Heri Yopa yere fu a tori, èn furu sma teki bribi ini Masra Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Dan Petrus tan wan heri pisten ini Yopa na wan man Simon di ben e wroko meti buba tron leer. ");
INSERT INTO srnNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ini Sesarea wan man ben e libi di ben nen Kornelius. A ben de wan ofisiri fu a grupu srudati di den ben kari: A Grupu fu Italia. ");
INSERT INTO srnNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","A ben e suku fu libi leki fa Gado wani, èn en nanga ala den sma fu en oso ben e anbegi Gado. A ben lobi yepi den pôtisma èn a ben e begi ala yuru. ");
INSERT INTO srnNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","A ben de wan dri yuru bakadina so di Gado sori en wan sani. A si krinkrin fa wan engel fu Gado kon inisei dan a taigi en taki: “Kornelius.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelius tan luku a engel dan a bigin frede srefsrefi. Ne a aksi a engel taki: “Masra, san yu wani?” A engel piki taki: “Gado yere den begi fu yu, èn A memre san yu e du gi den pôtisma. ");
INSERT INTO srnNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Dan yu mus seni wantu man now go na Yopa, fu go kari wan man Simon kon, di den e kari Petrus tu. ");
INSERT INTO srnNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A e tan nanga a man Simon di e wroko meti buba tron leer. A oso fu a man dati de na sekanti.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Fa a engel di ben taki nanga en gwe, so a kari tu knekti fu en kon, nanga wan fu den srudati di ben mus hori wakti gi en èn di ben e suku fu libi leki fa Gado wani. ");
INSERT INTO srnNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Baka di a taigi den san den mus du, a seni den go na Yopa. ");
INSERT INTO srnNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A tra dei fu en den man ben doro krosbei fu a foto kba. A ben de twarfu yuru ten, èn Petrus ben kren go tap'sei fu a oso fu go begi. ");
INSERT INTO srnNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dan angri bigin kiri en èn a ben wani nyan wan sani. Di den e meki a nyanyan klari, Gado sori en wan sani. ");
INSERT INTO srnNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A si fa heimel opo, dan wan sani leki wan bigi sribikrosi di ben tai na den fo uku, e saka kon na gron. ");
INSERT INTO srnNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ini a krosi yu ben abi ala sortu meti di e waka tapu fo futu, meti di e kroipi, nanga ala sortu fowru di e frei na loktu. ");
INSERT INTO srnNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dan wan sten taigi en taki: “Petrus, opo. Srakti wan sani, dan yu e nyan.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma Petrus piki taki: “Nono, Masra, kwet'kweti! Noiti ete mi nyan wan sani san un leki Dyu no mus fu nyan, fu di a no bun ini Yu ai fu un nyan en.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dan a sten taki a di fu tu tron taki: “Efu Gado taki wan sani bun fu nyan, dan yu no kan taki moro tak' yu no kan nyan en.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Disi psa dri leisi, dan a sani opo go baka na heimel. ");
INSERT INTO srnNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A srefi pisten di Petrus e broko en ede san a sani wani taki di Gado sori en, den tu man di Kornelius ben seni, ben tnapu na mofodoro. Den ben aksi-aksi te den feni pe Simon e tan, ");
INSERT INTO srnNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","èn now den ben e kari aksi efu Simon, di den e kari Petrus tu, ben e tan drape. ");
INSERT INTO srnNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A srefi ten dati Petrus ben sidon e broko en ede ete abra san a si. Dan a Yeye taigi en taki: “Luku, dri man e suku yu. ");
INSERT INTO srnNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Opo go na gron, dan yu go nanga den sondro fu draidrai, bika na Mi seni den.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","So Petrus saka go na gron, dan a taigi den man taki: “Mi na a sma di un e suku. San tyari un kon?” ");
INSERT INTO srnNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Den man taigi Petrus taki: “Kornelius, wan ofisiri fu den Romeini srudati, seni un kon. Na wan man di bun ini Gado ai èn di e anbegi En. Ala den Dyusma sabi en leki wan bun man. Wan santa engel ben taigi en tak' a mus aksi yu fu kon na en oso fu a kan arki san yu abi fu taki.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","So Petrus aksi den fu kon inisei èn fu tan sribi drape. A tra dei fu en Petrus nanga wantu bribisma fu Yopa gwe nanga den. ");
INSERT INTO srnNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A dei na en baka den doro ini Sesarea. Drape Kornelius ben e wakti den kba, makandra nanga en famiri nanga den moro bun mati fu en di a ben kari. ");
INSERT INTO srnNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","A waka miti Petrus di a e kon inisei, dan Kornelius kindi na en fesi èn a gi en grani. ");
INSERT INTO srnNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma Petrus meki a opo tnapu. A taigi en taki: “Opo, bika mi na wan libisma leki yu srefi.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Dan a bigin taki nanga en èn den waka go inisei pe Petrus miti nanga ala den tra sma. ");
INSERT INTO srnNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A taigi den taki: “Un sabi tak' a wèt fu den Dyu e taki tak' den no mus moksi nanga tra sma èn den no mus go ini a oso fu wan sma di no de wan Dyu. Ma Gado meki mi kon ferstan tak' mi no kan taki tak' tra sma no santa noso den no bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Dat' meki mi no draidrai di yu seni kari mi kon. Ma now mi sa wani sabi fu sanede yu seni kari mi.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dan Kornelius taki: “Fo dei di psa mi ben de dya ini mi oso e begi. A ben de a srefi yuru disi, dri yuru bakadina. Ne mi si wan man ini wan brenki weti krosi tnapu na mi fesi. ");
INSERT INTO srnNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","A taigi mi taki: ‘Kornelius, Gado yere yu begi èn A memre san yu e du gi den pôtisma. ");
INSERT INTO srnNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dat' meki yu mus seni wan sma go na Yopa fu go kari Simon kon, di den e kari Petrus tu. A e tan ini a oso fu wan man Simon di e wroko meti buba tron leer, èn a oso fu en de na sekanti.’ ");
INSERT INTO srnNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","So mi seni sma kon wantron na yu, èn a bun tak' yu kon. Now wi alamala de dya na Gado fesi fu yere ala sani san Masra taigi yu fu taki.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dan Petrus bigin taki: “Now mi kon ferstan tak' ala sma na a srefi gi Gado, ");
INSERT INTO srnNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","èn tak' A e teki ibri sma di e anbegi En èn di e du san bun ini En ai, awinsi fu sortu folku a kmopo. ");
INSERT INTO srnNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Disi na a boskopu san Gado seni gi den sma fu Israel: Yesus Kristus tyari freide kon. Na En na Masra fu ala sma. ");
INSERT INTO srnNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Un sabi san psa ini heri Yudea. A bigin ini Galilea baka di Yohanes kari den sma fu teki dopu. ");
INSERT INTO srnNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Un sabi fu Yesus fu Nasaret, tak' Gado ben poti En Santa Yeye nanga En krakti na En tapu. A ben waka na ala sei e du bun èn A puru ala den sma di ben de ini a makti fu didibri, bika Gado ben de nanga En. ");
INSERT INTO srnNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wi na kotoigi fu ala den sani di A du ini Yerusalem nanga a kondre fu den Dyu. Den spikri En na wan kroisi fu A dede, ");
INSERT INTO srnNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ma baka dri dei, Gado meki A kon na libi baka èn A meki sma si En. ");
INSERT INTO srnNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A no ala sma si En, ma soso den sma di Gado ben teki na fesi kba fu ferteri fu En. Dati na wi di ben nyan èn dringi nanga En baka di A opo baka na dede. ");
INSERT INTO srnNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dan A komanderi wi fu preiki gi den sma èn fu taigi den tak' na En na a Wan di Gado poti fu krutu den libiwan nanga den dedewan. ");
INSERT INTO srnNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na fu En ala den profeiti ben taki, tak' ala sma di e bribi ini En e kisi pardon fu den sondu ini En nen.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus no ben kba taki ete, di a Santa Yeye kon tapu ala sma di ben e arki a boskopu. ");
INSERT INTO srnNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Den Dyu bribisma di ben kon nanga Petrus, ferwondru srefsrefi tak' den sma di no de Dyu kisi a Santa Yeye tu. ");
INSERT INTO srnNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Den yere fa den sma e taki ini tra tongo, èn fa den e prijse Gado. Dan Petrus taki: ");
INSERT INTO srnNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Suma kan tapu den sma disi fu teki dopu? Bika den kisi a Santa Yeye neleki wi.” ");
INSERT INTO srnNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dan Petrus taigi den tak' den mus dopu den sma ini a nen fu Yesus Kristus. Dan den sma aksi en fu tan wantu dei nanga den. ");
INSERT INTO srnNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Den boskopuman fu Yesus nanga den bribisma ini Yudea, ben kisi fu yere tak' den sma di no de Dyu bribi a wortu fu Gado tu. ");
INSERT INTO srnNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Di Petrus go na Yerusalem, den Dyusma di ben teki bribi no ben agri nanga san a ben du. ");
INSERT INTO srnNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Den taigi en taki: “Fa yu ben kan go ini a oso fu sma di no de Dyu, dan yu nyan nanga den?” ");
INSERT INTO srnNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dan Petrus bigin ferteri den a heri tori soleki fa a psa. ");
INSERT INTO srnNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","A taigi den taki: “Mi ben de ini Yopa e begi, dan Gado sori mi wan sani. Mi si fa wan sani leki wan bigi sribikrosi san ben tai na den fo uku, saka kmopo fu heimel let' na mi fesi. ");
INSERT INTO srnNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Di mi luku moro fini, mi si meti di e waka tapu fo futu, krasi meti, meti di e kroipi, nanga fowru di e frei na loktu. ");
INSERT INTO srnNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dan mi yere wan sten taigi mi taki: ‘Petrus, opo. Srakti wan sani, dan yu e nyan.’ ");
INSERT INTO srnNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ma mi taki: ‘Nono, Masra, kwet'kweti! Noiti ete mi poti wan sani na mi mofo san un leki Dyu no mus fu nyan, fu di a no bun ini Yu ai fu un nyan en.’ ");
INSERT INTO srnNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ma a sten di kmopo fu heimel taigi mi a di fu tu tron taki: ‘Efu Gado taki wan sani bun fu nyan, dan yu no kan taki moro tak' yu no kan nyan en.’ ");
INSERT INTO srnNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Dri leisi a sani disi psa. Baka dati ala sani hari go baka na heimel. ");
INSERT INTO srnNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Dan a srefi momenti dati dri man doro na a oso pe un ben e tan. Wan sma fu Sesarea ben seni den kon na mi. ");
INSERT INTO srnNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Dan a Yeye taigi mi tak' mi kan go nanga den man sondro fu draidrai. So mi nanga den siksi brada disi go na a oso fu a man di seni kari mi. ");
INSERT INTO srnNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Dan a man dati ferteri unu tak' a ben si wan engel tnapu ini en oso di taigi en taki: ‘Seni wan sma go na Yopa, fu go kari Simon kon di den e kari Petrus tu. ");
INSERT INTO srnNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A sa ferteri yu wan boskopu di sa meki tak' Gado sa ferlusu yu nanga ala den sma fu yu oso.’ ");
INSERT INTO srnNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Di mi bigin taki nanga den, a Santa Yeye kon na den tapu leki fa A ben kon na wi tapu ini a bigin. ");
INSERT INTO srnNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Dan mi memre fa Masra ben taki: ‘Yohanes ben e dopu sma nanga watra, ma unu o kisi dopu nanga a Santa Yeye.’ ");
INSERT INTO srnNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","So efu Gado gi den a srefi Santa Yeye leki unu di den bribi ini Masra Yesus Kristus, fa mi bo man tapu Gado dan?” ");
INSERT INTO srnNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Di den yere den sani disi, den ati kon kowru. Dan den gi Gado glori taki: “Gado e gi sma di no de Dyu a okasi tu fu drai den libi, meki den kisi a nyun fasi fu libi.” ");
INSERT INTO srnNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Baka di Stefanus dede, wan tranga ten kon gi den bribisma èn den panya go na ala sei. Den go te na Fenisia, Siprus nanga Antiokia, èn den ferteri soso Dyusma a Bun Nyunsu. ");
INSERT INTO srnNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma wantu fu den bribisma fu Siprus nanga Sirena di go na Antiokia, ferteri a Bun Nyunsu fu Masra Yesus owktu na sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Masra srefi ben yepi den tak' bun furu sma teki bribi, èn drai kon na Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Di a gemeente fu Yerusalem kisi a sani disi fu yere, den seni Barnabas go na Antiokia. ");
INSERT INTO srnNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Di a doro drape èn a si fa Gado sori den sma En bun-ati, a ben prisiri. Dan a gi den alamala dek'ati fu tan dini Masra nanga den heri ati. ");
INSERT INTO srnNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ben de wan bun man di ben furu nanga a Santa Yeye, èn a ben abi wan tranga bribi. Dan furu sma teki bribi ini Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dan Barnabas hari go na Tarsus fu go suku Saulus. Di a feni en, a tyari en go na Antiokia. ");
INSERT INTO srnNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wan heri yari langa den tan nanga den sma fu a gemeente èn den gi furu sma leri. Ini Antiokia den kari den bribisma fu a fosi leisi Kristensma. ");
INSERT INTO srnNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A srefi pisten dati, wantu profeiti ben kmopo fu Yerusalem kon na Antiokia. ");
INSERT INTO srnNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Dan a Santa Yeye meki wan fu den, di ben nen Agabus, opo taigi den sma tak' wan bigi angriten bo kon ini ala den kondre di den Romeinisma e tiri. A sani disi psa di a grankownu Klaudius ben e rigeri. ");
INSERT INTO srnNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","So den bribisma fu Antiokia teki a besroiti tak' ibriwan fu den bo gi san a man gi fu yepi den bribisma ini Yudea. ");
INSERT INTO srnNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Den du dati èn den meki Barnabas nanga Saulus tyari a moni gi den fesiman fu a gemeente. ");
INSERT INTO srnNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ini a srefi ten dati, kownu Herodes meki den grabu wantu sma fu a gemeente fu du den ogri. ");
INSERT INTO srnNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A meki den kapu Yakobus, a brada fu Yohanes, kiri. ");
INSERT INTO srnNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Di Herodes si tak' den Dyusma ben feni a sani disi bun, a meki den grabu Petrus tu. A sani disi psa di den Dyusma ben e hori a fesa pe den e nyan brede san meki sondro dyesi. ");
INSERT INTO srnNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Baka di a grabu en, a meki den sroto en nanga a prakseri fu leisi strafu gi en fesi a folku te a Paskafesa psa. A meki fo grupu srudati hori wakti gi en. Ibri grupu ben abi fo srudati. ");
INSERT INTO srnNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","So Petrus ben tan ini a straf'oso, ma a gemeente ben e tan begi Gado gi en. ");
INSERT INTO srnNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A neti fosi Herodes leisi strafu gi en, Petrus ben didon e sribi mindri tu srudati. Den ben bui en nanga tu keti, èn srudati ben e hori wakti fesi a doro fu a straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ma wantron so wan engel fu Masra ben tnapu na en sei èn wan faya ben krin a heri kamra. A dyuku Petrus na en sei fu a wiki, dan a taigi en taki: “Opo es'esi!” Dan den keti fadon kmopo fu en anu. ");
INSERT INTO srnNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","A engel taigi en taki: “Seti yu krosi, dan yu weri yu susu.” Di Petrus du san a taki, a engel taigi en moro fara taki: “Weri yu dyakti, dan yu waka kon na mi baka.” ");
INSERT INTO srnNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","So Petrus waka na en baka go na dorosei, ma a no ben ferstan ete tak' san a engel e du, e psa trutru. A ben prakseri tak' na sori Gado ben sori en wan sani. ");
INSERT INTO srnNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Di den waka psa den tu presi pe den srudati ben e hori wakti, den kon na a bigi isri doro pe yu e go ini a foto. A doro disi opo fu ensrefi. Di den kon na dorosei a engel waka wan strati fara nanga Petrus dan wantron so a gwe libi en. ");
INSERT INTO srnNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dan fosi Petrus kon si tak' a no dren a e dren. A taki: “Now mi sabi trutru tak' Masra seni En engel fu puru mi ini anu fu Herodes, nanga san den Dyusma ben wani tak' musu psa nanga mi.” ");
INSERT INTO srnNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Di a kon ferstan a sani disi, a go na a oso fu Maria, a m'ma fu Yohanes di den ben e kari Markus tu. Ini a oso furu bribisma ben kon makandra e begi. ");
INSERT INTO srnNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Di Petrus doro drape, a naki na a fesi doro. Dan Roda, a uma di ben wroko drape, kon luku suma na en. ");
INSERT INTO srnNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Di a yere tak' na Petrus en sten, a ben breiti sote tak' a lon go na inisei sondro fu opo a doro, dan a taigi den sma tak' Petrus de na a fesi doro. ");
INSERT INTO srnNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ma den taigi en taki: “Yu no de bun na yu ede.” Di Roda tan taigi den tak' Petrus de na mofodoro, den taki: “A mus de a engel fu en.” ");
INSERT INTO srnNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma Petrus ben tan naki tapu a doro. Di den opo a doro èn den si tak' na en, den no ben man bribi den ai. ");
INSERT INTO srnNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus sori den nanga en anu tak' den mus tan tiri. Dan a ferteri den fa Masra puru en ini a straf'oso. Baka dati a taigi den tak' den mus ferteri Yakobus nanga den tra bribisma san psa nanga en. Dan a kmopo fu drape go na wan tra presi. ");
INSERT INTO srnNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","A tra mamanten fu en wan bigi bruya ben de mindri den srudati. Den ben e aksi densrefi san psa nanga Petrus. ");
INSERT INTO srnNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes meki den suku en na ala sei, ma den no ben man feni en. Baka di a aksi den srudati san psa, a meki den tyari den gwe go kiri. Baka dati a gwe libi a distrikti Yudea, dan a go tan wan pisten ini a foto Sesarea. ");
INSERT INTO srnNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes ati ben e bron srefsrefi nanga den sma fu Tirus nanga Sidon. So den sma dati kon makandra, dan den seni wan grupu sma go na Herodes fu meki en bun nanga en. Bika den ben e kisi den nyanyan fu a kondre di Herodes ben e tiri. Den taki nanga Blastus, wan prenspari man ini a kownu-oso fu Herodes, dan den kisi en so fara fu yepi den. ");
INSERT INTO srnNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Dan Herodes meki wan dei fu taki nanga den. A ben weri en kownu krosi èn a ben sidon tapu en kownusturu. ");
INSERT INTO srnNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Den sma ben e bari taki: “Disi na a sten fu wan gado, a no libisma e taki drape.” ");
INSERT INTO srnNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","A srefi momenti dati, wan engel fu Masra naki Herodes fu di a no ben gi Gado a grani. Dan woron nyan en èn a dede. ");
INSERT INTO srnNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma a wortu fu Gado ben panya moro nanga moro. ");
INSERT INTO srnNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Baka di Barnabas nanga Saulus tyari a moni go na Yerusalem, den drai go baka na Antiokia. Den teki Yohanes, di den sma ben e kari Markus tu, fu go nanga den. ");
INSERT INTO srnNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ini a gemeente fu Antiokia, yu ben abi profeiti nanga leriman. Den man dati ben de: Barnabas nanga Simeon di den sma ben kari Blaka. Moro fara yu ben abi Lusius fu Sirena, Saulus, nanga Manaen di ben kweki makandra nanga a tiriman Herodes. ");
INSERT INTO srnNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Di den ben e faste èn anbegi Masra, a Santa Yeye taigi den taki: “Un puru Barnabas nanga Saulus na un mindri, fu den du a wroko di Mi kari den fu du.” ");
INSERT INTO srnNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Baka di den faste èn begi, den poti den anu na den tapu dan den meki den go. ");
INSERT INTO srnNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Na so a Santa Yeye seni Barnabas nanga Saulus go du a wroko. Den go na Selesia èn fu drape den teki wan sipi go na Siprus. ");
INSERT INTO srnNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Di den doro na a foto Salamis, den preiki a wortu fu Gado ini den Dyukerki, èn Yohanes ben yepi den nanga a wroko tu. ");
INSERT INTO srnNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Den waka tapu a heri eilanti te den doro a foto Pafos. Drape den miti nanga wan bonuman di ben nen Baryesus. A ben de wan Dyu èn a ben du leki en na wan profeiti. ");
INSERT INTO srnNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A ben e tan na a oso fu a granman Sergius Paulus. A man disi ben de wan koni man èn a ben angri fu yere a wortu fu Gado. So a seni kari Barnabas nanga Saulus kon. ");
INSERT INTO srnNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ma a bonuman disi, di den ben e kari Elimas tu ini wan tra tongo, no ben wani a sani dati èn a ben du ala muiti fu a granman no teki bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ma Saulus, di den ben e kari Paulus tu, ben furu nanga a Santa Yeye. A piri ai gi en, dan a taigi en taki: ");
INSERT INTO srnNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Yu pikin fu didibri yu! Yu feyanti fu ala san bun! Yu lai nanga ala sortu triki nanga bedrigi fasi. Oten yu o tapu fu drai den tru sani fu Masra? ");
INSERT INTO srnNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Luku, Masra o strafu yu. Yu o breni èn fu wan pisten yu no o man si a son.” A srefi momenti dati ala sani kon dungru gi en, dan a bigin fir'firi efu a bo feni wan sma fu hori en na en anu. ");
INSERT INTO srnNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Di a granman si san psa, a teki bribi. A leri fu Masra ben meki a ferwondru srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Baka dati Paulus nanga den man di ben de nanga en, kmopo fu Pafos dan den koti a se abra go na a foto Perga ini a distrikti Pamfilia. Drape Yohanes prati pasi nanga den, dan a drai go baka na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ma den trawan kmopo fu Perga, dan den hari go moro fara na a foto Antiokia ini Pisidia. Dan tapu a sabadei den go sidon ini a Dyukerki. ");
INSERT INTO srnNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Baka di den sma leisi kmopo fu a wèt fu Moses nanga den profeiti, den edeman fu a Dyukerki seni aksi Paulus nanga den sma di ben de nanga en taki: “Brada, efu un abi wan boskopu san o gi den sma dek'ati, dan un abi a okasi now.” ");
INSERT INTO srnNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","So Paulus opo tnapu, a sori den nanga en anu tak' den mus tan tiri, dan a taki: “Kondreman, nanga ala trawan di e anbegi Gado, un arki. ");
INSERT INTO srnNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","A Gado di wi leki Dyusma e dini, ben teki den afo fu wi fu tron En eigi pipel. Di den ben libi leki doroseisma ini Egiptekondre, A meki den tron wan bigi pipel. Baka dati A puru den fu drape nanga En bigi krakti. ");
INSERT INTO srnNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Fotenti yari langa Gado ben abi furu pasensi nanga den ini a dreisabana. ");
INSERT INTO srnNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Dan baka di A puru seibi folku na pasi di ben libi ini Kanaan, A gi den a kondre tak' na fu den. ");
INSERT INTO srnNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ala den sani disi ben teki wan fo hondro nanga feifitenti (450) yari. Baka dati Gado gi a pipel tiriman te kon miti a ten fu a profeiti Samuel. ");
INSERT INTO srnNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Dan den aksi fu wan kownu. So Gado gi den Saul, a manpikin fu Kis, di ben de fu a lo fu Benyamin. Saul tiri a pipel fotenti yari langa. ");
INSERT INTO srnNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Baka di Gado puru en, A poti David leki kownu. Na fu en Gado ben taki: ‘Mi lobi fa David, a pikin fu Isai, de. A o du ala sani san Mi wani.’ ");
INSERT INTO srnNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dan leki fa Gado ben pramisi, A meki Yesus, a Ferlusuman fu Israel, kmopo fu a famiri fu David. ");
INSERT INTO srnNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ma fosi Yesus bigin nanga en wroko, Yohanes ben e taigi a heri folku fu Israel tak' den mus drai den libi èn teki dopu. ");
INSERT INTO srnNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Di a wroko fu Yohanes ben de fu kba, a taigi den sma taki: ‘Mi a no a Mesias, leki fa unu e prakseri. Ma luku, wan sma e kon na Mi baka. Mi no warti srefi fu puru En susu na En futu.’ ");
INSERT INTO srnNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Brada, unu di de bakapikin fu Abraham, nanga un trawan di e anbegi Gado, a boskopu tak' Gado wani meki libisma kon fri, kon gi unu. ");
INSERT INTO srnNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Den sma fu Yerusalem nanga den edeman fu den, no ben si Yesus leki suma A de trutru. Di den leisi strafu gi En, den meki den wortu fu den profeiti kon tru di den e leisi ala sabadei. ");
INSERT INTO srnNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Èn aladi den no feni noti na En di sori tak' a fiti fu A dede, toku den aksi Pilatus fu kiri En. ");
INSERT INTO srnNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Dan baka di den du ala sani san ben skrifi fu En na fesi kba, den puru a dedeskin fu En na a kroisi poti na ini wan grebi. ");
INSERT INTO srnNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ma Gado meki A opo baka na dede. ");
INSERT INTO srnNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Dan A sori Ensrefi someni dei na den sma di ben kmopo nanga En fu Galilea kon na Yerusalem. Na den sma dati e ferteri a folku now fu En. ");
INSERT INTO srnNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Èn wi e ferteri unu a Bun Nyunsu tak' san Gado pramisi den afo fu wi, ");
INSERT INTO srnNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","na dati A meki kon tru gi wi leki bakapikin fu den, di A meki Yesus kon baka na libi. Dat' meki a di fu tu Psalm e taki: Yu na mi pikin, tide Mi tron yu P'pa. ");
INSERT INTO srnNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Gado meki Yesus kon na libi baka fu A no dede noiti moro. Na dati A ben taki nanga den wortu disi: Mi sa gi unu den santa blesi di de fu fertrow, san Mi ben pramisi David. ");
INSERT INTO srnNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Dat' meki a skrifi ini wan tra Psalm taki: ‘Yu no sa meki a dedeskin fu Yu Santa Wan pori.’ ");
INSERT INTO srnNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bika baka di David du ala sani gi den sma fu en ten leki fa Gado ben wani, a dede. Den poti a dedeskin fu en pe den afo fu en beri, èn a pori gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ma a dedeskin fu a Wan di Gado meki kon na libi baka, no pori. ");
INSERT INTO srnNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Brada, disi un mus sabi, tak' a boskopu di wi e tyari gi unu na tak' Yesus meki un kisi pardon fu un sondu. ");
INSERT INTO srnNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","A sani san Yesus du meki tak' Gado e si ala sma di e bribi, leki sma di bun ini En ai. A sani dati a wèt fu Moses no ben man du. ");
INSERT INTO srnNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Dat' meki un mus luku bun tak' san den profeiti ben taki, no miti unu. ");
INSERT INTO srnNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Wan fu den ben taki: Unu di e spotu nanga Mi, luku! Un ferwondru, dan un kmopo na Mi fesi. Bika Mi e du wan sani ini a ten fu unu, wan sani di un no o bribi, awinsi sma ben sa ferteri unu.” ");
INSERT INTO srnNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Di Paulus nanga Barnabas bo gwe, den sma begi den fu kon a tra sabadei baka fu ferteri den moro fu den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Baka di a konmakandra kba, furu Dyusma nanga furu sma di ben teki a Dyubribi èn di ben e anbegi Gado, waka na den baka di den e gwe libi a Dyukerki. Dan Paulus nanga Barnabas taigi den fu tan fertrow tapu a bun-ati fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tapu a tra sabadei, pikinso moro dan a heri foto ben kon makandra fu arki a wortu fu Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ma di den Dyusma si a bigi grupu sma, den kon dyarusu. Den bigin taki takru fu Paulus èn den taki tak' na lei a e lei. ");
INSERT INTO srnNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ma sondro frede Paulus nanga Barnabas taigi den taki: “Unu na den fosi sma di ben mus yere a wortu fu Gado. Ma fu di un no wani yere en srefsrefi, èn un feni tak' un no fiti fu kisi a libi fu têgo, meki wi e go now na den sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bika Masra ben komanderi wi taki: Mi poti yu leki wan leti gi den sma di no de Dyu, fu tyari ferlusu kon gi ala sma te na den moro fara uku fu grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","We, di den sma di no de Dyu yere a sani dati, den prisiri èn den gi Masra grani fu a wortu fu En. Ala sma di Gado ben wani fu kisi a libi fu têgo, teki bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","So a wortu fu Masra panya lontu ini a heri kontren drape. ");
INSERT INTO srnNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ma den Dyusma sutu faya gi den gudu uma di ben anbegi Gado, nanga gi den edeman fu a foto. Den meki den sma de na Paulus nanga Barnabas baka fu du den ogri, èn den yagi den puru fu a kontren drape. ");
INSERT INTO srnNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","So Paulus nanga Barnabas seki a santi puru na den futu leki wan marki tak' den no e tyari a frantwortu moro gi den. Dan den go na a foto Ikonium. ");
INSERT INTO srnNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma den bribisma fu a foto Antiokia ben prisiri srefsrefi èn den ben kon furu nanga a Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A srefi sani psa ini Ikonium tu. Paulus nanga Barnabas go ini a Dyukerki èn a fasi fa den ben e taki meki tak' furu Dyusma nanga sma di no de Dyu, teki bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ma den Dyusma di no ben wani teki bribi, sutu faya gi den sma di no de Dyu èn den meki den prakseri takru fu den bribisma. ");
INSERT INTO srnNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulus nanga Barnabas tan wan heri pisten drape. Den ben fertrow Masra èn sondro frede den ben preiki a boskopu fu a bun-ati fu Masra. Dan Masra meki den du wondru èn A meki den sori den sma marki, fu sori tak' den sani san den taki tru. ");
INSERT INTO srnNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ma dan wan prati kon na mindri den sma fu a foto. Sonwan ben de na a sei fu den Dyusma, trawan ben de na a sei fu den boskopuman fu Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Te fu kba den Dyusma nanga den sma di no de Dyu, makandra nanga den fesiman fu den, meki mofo fu fon den èn fu ston den kiri. ");
INSERT INTO srnNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ma di Paulus nanga Barnabas kisi a sani disi fu yere, den lowe go na Listra nanga Derba, tu foto fu a distrikti Likaonia. Drape ini den foto nanga den birti fu den, ");
INSERT INTO srnNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","den go doro fu preiki a Bun Nyunsu. ");
INSERT INTO srnNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yu ben abi wan man ini Listra di no ben man waka. Noiti a ben tnapu tapu en futu fu di a ben lan sensi a gebore. ");
INSERT INTO srnNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A man disi ben sidon e arki di Paulus ben e taki. Dan Paulus luku en trangatranga èn a si tak' a man ben abi bribi fu kon betre. ");
INSERT INTO srnNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","So a taigi en nanga tranga sten taki: “Opo tnapu tapu yu futu!” A man dyompo opo èn a bigin waka lontu. ");
INSERT INTO srnNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Di a bigi grupu sma si san Paulus du, den bari na ini Likaonia-tongo taki: “Den gado saka kon leki libisma na wi.” ");
INSERT INTO srnNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dan den kari Barnabas Seus, èn fu di na Paulus ben e taki den kari en Hermes. ");
INSERT INTO srnNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Dan a domri fu a tempel fu Seus, di ben de krosbei fu a foto, tyari kaw nanga bromki kon na den doro fu a foto. Makandra nanga ala den sma, a ben wani tyari offer gi den. ");
INSERT INTO srnNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ma di Barnabas nanga Paulus, den boskopuman fu Yesus, yere san den ben wani du, den no ben feni en bun srefsrefi. Dat' meki den priti den krosi èn den lon go na mindri den sma. ");
INSERT INTO srnNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Den bari taki: “Sma fu Listra, fu sanede un e du den sani disi? Wi na libisma leki unu! Wi kon fu ferteri unu a Bun Nyunsu tak' un mus drai un baka gi den soso sani disi fu kon na a libilibi Gado di meki heimel nanga grontapu, a se nanga ala den sani san de ini den. ");
INSERT INTO srnNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Fosten A ben meki ala folku go den eigi pasi. ");
INSERT INTO srnNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ma toku Gado meki un si suma A de nanga den bun sani di A e du. A e meki alen kmopo fu heimel, èn A e meki nyanyan gro kon na tapu en ten. A e gi un nofo fu nyan èn A e furu un ati nanga prisiri.” ");
INSERT INTO srnNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ma aladi den taki so, a ben tranga gi den fu tapu den sma fu no tyari offer gi den. ");
INSERT INTO srnNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ma baka dati wantu Dyusma kmopo fu Antiokia nanga Ikonium kon drai den sma ede. Den fringi ston tapu Paulus èn di den prakseri tak' a dede, den srepi en go na dorosei fu a foto. ");
INSERT INTO srnNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ma di den bribisma kon tnapu lontu en, a opo tnapu dan a go ini a foto. A tra dei Paulus nanga Barnabas go na a foto Derba. ");
INSERT INTO srnNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Di den preiki a Bun Nyunsu ini a foto dati èn den gi furu bribisma leri, den drai go baka na Listra, Ikonium, nanga Antiokia. ");
INSERT INTO srnNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Drape den meki den bribisma kon tranga ini bribi èn den gi den dek'ati fu tan ini a bribi. Den taigi den taki: “Wi o abi fu nyan furu pina fu kon ondro a tiri fu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na ini ibri gemeente den poti sma leki fesiman tu. Den begi èn den faste, dan den poti den ini Masra anu, bika na ini En den ben e bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Dan Paulus nanga Barnabas psa ini Pisidia, go na Pamfilia. ");
INSERT INTO srnNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Baka di den preiki a boskopu ini Perga, den go na Atalia. ");
INSERT INTO srnNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Drape den teki wan sipi go baka na Antiokia, pe a gemeente ben poti den ini Gado anu fu A yepi den du a wroko di den ben kba du now. ");
INSERT INTO srnNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Di den doro, den kari a gemeente kon na wan. Dan den ferteri den sma ala den sani di Gado meki den du, nanga fa A opo pasi gi den sma di no de Dyu, fu den kon na bribi tu. ");
INSERT INTO srnNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Dan den tan wan heri pisten nanga den bribisma drape. ");
INSERT INTO srnNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wantu man di kmopo fu Yudea bigin leri den bribisma taki: “Gado no o ferlusu unu efu un no besnei leki fa a wèt fu Moses e taki.” ");
INSERT INTO srnNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ma Paulus nanga Barnabas no ben agri nanga den srefsrefi. A sani disi tyari sowan dyugudyugu tak' den sma fu a gemeente taigi Paulus nanga Barnabas fu go makandra nanga wantu tra sma na Yerusalem, fu taki a tori disi nanga den boskopuman fu Yesus nanga den fesiman fu a gemeente drape. ");
INSERT INTO srnNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","So a gemeente seni den go èn den psa ini den distrikti Fenisia nanga Samaria. Drape den ferteri den bribisma fa den sma di no de Dyu teki bribi na ini Masra Yesus. Di den bribisma yere a sani dati, den ben breiti srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Di den doro ini Yerusalem, den bribisma, den boskopuman fu Yesus nanga den fesiman fu a gemeente, bari den wan odi. Dan Paulus nanga Barnabas ferteri den ala sani san Gado ben meki den du. ");
INSERT INTO srnNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ma wantu Fariseiman di ben teki bribi, opo tnapu dan den taki: “Den sma di no de Dyu musu besnei, èn sma mus leri den fu hori a wèt fu Moses.” ");
INSERT INTO srnNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","So den boskopuman fu Yesus nanga den fesiman fu a gemeente kon makandra fu taki a tori disi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ma den no ben man feni densrefi. Ne Petrus opo dan a taki: “Brada, un sabi tak' langa ten kba Gado ben teki mi puru na un mindri, fu go ferteri a Bun Nyunsu na den sma di no de Dyu fu den teki bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dan Gado, di sabi ala sma ati, gi den a Santa Yeye leki fa A ben gi unu, fu sori tak' sma di no de Dyu kan tron En sma tu. ");
INSERT INTO srnNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gi Gado, Dyusma nanga sma di no de Dyu na a srefi. Bika di den kon na bribi, A krin den ati fu ala sondu tu. ");
INSERT INTO srnNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Dan fu sanede un wani tesi Gado, fu poti wan hebi lai tapu den bribisma san wi nanga den afo fu wi no ben man tyari? ");
INSERT INTO srnNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ma wi e bribi tak' a bun-ati fu Masra Yesus ferlusu wi tapu a srefi fasi leki fa A ferlusu den.” ");
INSERT INTO srnNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Dan ala den sma tan tiri fu arki fa Barnabas nanga Paulus e ferteri fu ala den marki nanga den wondru di Gado meki den du mindri den sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Di den kba, Yakobus taki: “Brada, un arki mi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeon sori wi tak' sensi na a bigin Gado ben abi den sma di no de Dyu ini En prakseri, fu A kan puru sma na den mindri meki wan pipel gi Ensrefi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A sani disi e akruderi tu nanga san den profeiti skrifi. Den ben skrifi taki: ");
INSERT INTO srnNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bakaten Mi sa drai kon baka, dan Mi sa bow a oso fu kownu David di ben broko. San fadon broko, Mi sa meki bun, èn Mi sa meki a oso opo tnapu baka. ");
INSERT INTO srnNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Dan ala tra sma sa suku Masra, sosrefi den sma di no de Dyu di de Mi eigi pipel. ");
INSERT INTO srnNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Na so Masra taki, di e du den sani disi di A ben taki langa na fesi kba.” ");
INSERT INTO srnNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Dan Yakobus taki moro fara taki: “Fu dat'ede mi feni tak' un no mus trobi den sma di no de Dyu te den drai kon na Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ma un mus skrifi den tak' den no mus fasi noti san kon doti fu di sma ben gi en na tra gado, den no mus gi densrefi abra na takru lostu, den no mus nyan meti di kiri sondro tak' a brudu ben lon kmopo, èn den no mus nyan brudu. ");
INSERT INTO srnNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bika someni langa kba den e leisi èn preiki a wèt fu Moses tapu a sabadei ini den Dyukerki fu ibri foto.” ");
INSERT INTO srnNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Dan den boskopuman fu Yesus nanga den fesiman fu a gemeente, makandra nanga ala den bribisma, teki a besroiti fu teki wantu man na den mindri, dan den seni den makandra nanga Paulus nanga Barnabas go na Antiokia. Dan den teki Yudas di den sma ben e kari Barsabas tu, nanga Silas. Den sma fu a gemeente ben abi bigi lespeki gi den tu man disi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Den seni a brifi disi go nanga den: Gi den brada di no de Dyu ini Antiokia, Siriakondre nanga Silisia, Disi na wan brifi fu den boskopuman fu Yesus nanga den fesiman fu a gemeente. Leki brada wi e seni taki un odi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wi yere tak' wantu sma fu wi kon taki wantu sani drape. A sani disi tyari wan bruya kon na un mindri èn un no sabi san un mus prakseri now. Ma a no wi ben seni den. ");
INSERT INTO srnNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","So wi teki a besroiti leki wan man fu teki wantu man seni kon na unu, makandra nanga Barnabas nanga Paulus, den lobi brada fu wi, ");
INSERT INTO srnNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","di no ben abi trobi fu lasi den libi fu a nen fu wi Masra Yesus Kristus. ");
INSERT INTO srnNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Wi e seni Yudas nanga Silas kon. Den sa taigi unu den srefi sani di wi skrifi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","A Santa Yeye nanga wi ben feni en bun fu no poti wan moro hebi lai na un tapu leki den sani disi di de fanowdu: ");
INSERT INTO srnNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Un no mus nyan noti di ben offer na tra gado, un no mus nyan brudu, un no mus nyan meti di kiri sondro tak' a brudu lon kmopo, èn un no mus gi unsrefi abra na takru lostu. A o bun efu un no du den sani disi. Un tan bun. ");
INSERT INTO srnNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Di den kmopo fu drape, den go na Antiokia. Drape den kari ala bribisma kon na wan, dan den gi den a brifi. ");
INSERT INTO srnNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Di den leisi a brifi den alamala ben breiti, bika san skrifi ben de wan trowstu gi den. ");
INSERT INTO srnNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudas nanga Silas, di ben de profeiti tu, taigi den sma furu sani di trowstu den èn di gi den dek'ati. ");
INSERT INTO srnNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Baka di den tan wan heri pisten drape, den bribisma ben wani seni Yudas nanga Silas go baka na den sma di ben seni den kon, èn den winsi den tak' ala sani sa go bun nanga den. ");
INSERT INTO srnNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ma Silas teki a besroiti fu tan drape. ");
INSERT INTO srnNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus nanga Barnabas tan na Antiokia, èn makandra nanga furu trawan den ben e preiki èn leri den sma a wortu fu Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Baka wan pisten Paulus taigi Barnabas taki: “Kon meki un drai go baka na ibri foto pe un ben ferteri a wortu fu Masra, fu si fa a e go nanga den bribisma.” ");
INSERT INTO srnNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Dan Barnabas ben wani teki Yohanes tu, di den sma e kari Markus. ");
INSERT INTO srnNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ma Paulus no ben feni en bun, bika a ben gwe libi den di den ben de ini Pamfilia èn a no ben yepi den moro fara nanga a wroko. ");
INSERT INTO srnNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Di den no ben man feni densrefi kwet'kweti, den prati pasi. So Barnabas teki Markus, dan den teki wan sipi go na Siprus. ");
INSERT INTO srnNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ma Paulus teki Silas fu go nanga en. Dan baka di den bribisma poti den ini Masra anu fu A yepi den, den gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Dan Paulus go na Siriakondre nanga a distrikti Silisia pe a meki den gemeente kon tranga ini a bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus doro tu na den foto Derba nanga Listra. Drape a miti nanga wan bribisma di ben nen Timoteus. A m'ma fu en ben de wan Dyu di ben teki bribi, èn en p'pa ben de wan Grikisma. ");
INSERT INTO srnNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Den bribisma fu Listra nanga Ikonium ben sabi en leki wan bun man. ");
INSERT INTO srnNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus ben wani fu Timoteus go nanga en. So a teki en dan a besnei en fu den Dyu ede, bika den ben sabi tak' en p'pa ben de wan Grikisma. ");
INSERT INTO srnNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Di den psa ini den foto, den taigi den sma fu den besroiti di den boskopuman fu Yesus nanga den fesiman fu a gemeente ben teki na Yerusalem. Dan den aksi den fu hori densrefi na den besroiti disi. ");
INSERT INTO srnNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","So den gemeente kon tranga ini a bribi, èn ibri dei moro nanga moro sma ben teki bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulus nanga den trawan psa ini den distrikti Frigia nanga Galasia, ma a Santa Yeye no ben wani tak' den tyari a wortu fu Gado ini a distrikti Asia. ");
INSERT INTO srnNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Di den doro na a distrikti Misia, den ben meki muiti fu go na Bitinia, ma a Yeye fu Yesus no ben wani. ");
INSERT INTO srnNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","So den psa ini Misia dan den go na a foto Troas. ");
INSERT INTO srnNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A neti dati Gado sori Paulus wan sani. A si fa wan man fu Masedonia tnapu e begi en taki: “Abra kon na Masedonia fu yepi unu!” ");
INSERT INTO srnNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Di Paulus si a sani disi, wi suku okasi wantron fu go na Masedonia, bika un ben kon ferstan tak' na Gado e kari unu fu preiki a Bun Nyunsu gi den. ");
INSERT INTO srnNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","So un kmopo nanga wan sipi na Troas, dan un go langalanga na Samotraka. A tra dei fu en un go na a foto Neapolis. ");
INSERT INTO srnNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Fu drape un go na Filipi, a moro prenspari foto fu Masedonia. Den sma di ben libi drape ben de borgu fu Roma. Dan un tan wantu dei drape. ");
INSERT INTO srnNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tapu a sabadei un kmopo ini a foto go na libakanti, bika un ben ferwakti tak' un bo feni wan presi pe sma ben e kon makandra fu begi. Di un doro, un saka sidon dan un bigin taki nanga den umasma di ben kon makandra drape. ");
INSERT INTO srnNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wan fu den uma di ben arki unu, ben nen Lidia. A ben de fu a foto Tiatira èn a ben e seri purper krosi. A no ben de wan Dyusma, ma a ben e anbegi Gado. Dan Masra opo en ati fu a bribi san Paulus ben e taki. ");
INSERT INTO srnNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Baka di Lidia nanga ala sma fu en oso teki dopu, a aksi unu fu kon tan na en oso. A taki: “Efu un e si mi leki wan sma di e bribi trutru ini Masra, dan un kon tan ini mi oso.” A aksi unu a sani dati te leki un go. ");
INSERT INTO srnNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wan tra dei di wi ben e go baka na a presi pe den sma ben e begi, un miti nanga wan uma. A ben de wan srafu èn a ben abi wan yeye na en tapu di ben e meki tak' a si sani na fesi. Tapu sowan fasi a ben e wroko furu moni gi den basi fu en. ");
INSERT INTO srnNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","A frow disi ben e waka na wi nanga Paulus baka e bari taki: “Den man disi na knekti fu a Moro Hei Gado. Den e ferteri unu san un mus du fu Gado ferlusu unu.” ");
INSERT INTO srnNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A du a sani disi wan heri pisten te leki a kon ferferi Paulus. So a drai taigi a yeye taki: “Ini a nen fu Yesus Kristus, mi e komanderi yu fu kmopo na en tapu!” A srefi momenti dati a yeye gwe libi a frow. ");
INSERT INTO srnNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Di den basi fu a uma si tak' den no man meki moni moro nanga en, den grabu Paulus nanga Silas, dan den srepi den go na wowoyo pe den bigiman fu a foto ben e sidon. ");
INSERT INTO srnNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Den tyari den go na fesi den edeman disi dan den taki: “Den man disi na Dyu, èn den e tyari dyugudyugu ini a foto fu unu. ");
INSERT INTO srnNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wi leki Romeinisma no man agri nanga den sani san den e leri, èn wi no mag libi a fasi dati.” ");
INSERT INTO srnNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A bigi grupu sma drape bigin fu krutu Paulus nanga Silas tu. Ne den edeman priti a krosi puru na Paulus nanga Silas skin, dan den meki den fon den. ");
INSERT INTO srnNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Baka di den gi den wan bun fonfon, den srepi den go poti na straf'oso. Dan den taigi a man di ben e hori wakti na a straf'oso fu hori ai bun na den tapu. ");
INSERT INTO srnNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Di den taigi en dati, a man tyari Paulus nanga Silas go sroto te na bakasei fu a straf'oso, dan a keti den futu bun. ");
INSERT INTO srnNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ma kon miti mindrineti, Paulus nanga Silas ben e begi èn den ben e singi fu gi Gado grani. Den tra straf'man ben e arki den. ");
INSERT INTO srnNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dan wantron so a gron bigin seki so tranga tak' a straf'oso seki tapu en fundamenti. A srefi momenti dati ala den doro opo èn den bui fu ala den straf'man lusu. ");
INSERT INTO srnNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Di a man di e hori wakti na a straf'oso skreki wiki, a si tak' ala den doro fu a straf'oso opo. Ne a hari en owru fu kiri ensrefi, bika a ben prakseri tak' den straf'man lowe. ");
INSERT INTO srnNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ma Paulus bari nanga tranga sten taki: “No du yusrefi noti! Wi alamala dyaso.” ");
INSERT INTO srnNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A man aksi wan sma fu tyari faya kon, dan a lon go ini a kamra fu Paulus nanga Silas. Nanga beifi skin a fadon tapu en kindi na den fesi. ");
INSERT INTO srnNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Dan a tyari den go na dorosei èn a aksi den taki: “Masra, san mi mus du fu Gado ferlusu mi?” ");
INSERT INTO srnNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ne den taigi en taki: “Teki bribi ini Masra Yesus, dan Gado sa ferlusu yu nanga den sma fu yu oso.” ");
INSERT INTO srnNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Dan den ferteri a man nanga ala den sma fu en oso a wortu fu Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","A srefi yuru dati fu a neti, a man tyari den go dresi den soro fu a fonfon. Dan en nanga ala den sma fu en oso teki dopu wantron. ");
INSERT INTO srnNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Baka dati a tyari den go inisei dan a poti nyanyan gi den. A ben breiti srefsrefi tak' en nanga den sma fu en ben e bribi ini Gado now. ");
INSERT INTO srnNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Di dei opo, den edeman seni skowtu nanga a boskopu tak' Paulus nanga Silas kan lusu. ");
INSERT INTO srnNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","So a man di e hori wakti na a straf'oso taigi Paulus taki: “Den edeman seni a boskopu fu lusu unu. So un kan gwe. Un tan bun.” ");
INSERT INTO srnNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ma Paulus piki taki: “Wi na Romeinisma. Ma toku den fon unu fesi ala sma sondro fu tyari un go fesi krutu fosi, èn den tyari un go sroto. Dan now den wani lusu unu safri, sondro fu wan sma si. Dati no kan! Meki den srefi kon lusu unu.” ");
INSERT INTO srnNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Den skowtu drai go taigi den edeman san Paulus taki. Di den yere tak' Paulus nanga Silas na Romeinisma, den kon frede. ");
INSERT INTO srnNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","So den edeman go begi Paulus nanga Silas pardon. Dan den tyari den go na dorosei fu a straf'oso, èn den aksi den tangitangi fu kmopo ini a foto. ");
INSERT INTO srnNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Di Paulus nanga Silas kmopo fu a straf'oso, den go na a oso fu Lidia, pe den miti nanga den tra bribisma. Den gi den dek'ati, dan den gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulus nanga Silas psa ini den foto Amfipolis nanga Apolonia, dan den doro na a foto Tesalonika pe wan Dyukerki ben de. ");
INSERT INTO srnNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Dan soleki fa Paulus ben gwenti, a go ini a kerki èn dri sabadei baka makandra a gi den leri kmopo fu a Santa Buku. ");
INSERT INTO srnNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","A sori den krin tak' a Mesias ben mus nyan pina èn tak' a ben mus opo baka na dede. A taigi den taki: “A Yesus di mi e taki, na En na a Mesias.” ");
INSERT INTO srnNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wantu Dyusma bribi san Paulus nanga Silas taigi den, dan den bigin waka nanga den. Bun furu Grikisma di ben e anbegi Gado, teki bribi tu, nanga furu fu den prenspari umasma. ");
INSERT INTO srnNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ma tra Dyusma kon dyarusu tapu Paulus. Den go teki wantu sakasaka sma fu strati, dan den tyari wan lo sma kon na wan èn den meki dyugudyugu kon ini a foto. Den lon go na a oso fu Yason nanga a prakseri fu tyari Paulus nanga Silas kon na doro gi den sma. ");
INSERT INTO srnNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ma di den no feni den, den srepi Yason nanga wantu tra bribisma go fesi den edeman fu a foto, dan den bari taki: “Den man di e tyari dyugudyugu na heri grontapu, kon dyaso tu, ");
INSERT INTO srnNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","èn Yason meki den tan na en oso. Den alamala e broko den wèt fu a grankownu fu den Romeinisma, bika den e taki tak' wan tra kownu de, di den e kari Yesus.” ");
INSERT INTO srnNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Di den sma nanga den edeman fu a foto yere a sani disi, den bruya srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Dan den meki Yason nanga den tra bribisma pai moni fu den no koti strafu, dan den meki den go. ");
INSERT INTO srnNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Fa neti tapu, den bribisma seni Paulus nanga Silas go na Berea. Di den doro drape den go na a Dyukerki. ");
INSERT INTO srnNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Den Dyusma fu Berea no tapu den yesi leki fa den sma fu Tesalonika ben du. Ma nanga wan opo ati den ben arki a boskopu san Paulus tyari, èn ala dei den ben e ondrosuku a Santa Buku fu si efu den sani de so trutru. ");
INSERT INTO srnNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Furu fu den Dyusma teki bribi, sosrefi furu prenspari Griki umasma nanga furu Griki mansma tu. ");
INSERT INTO srnNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ma di den Dyusma fu Tesalonika yere tak' Paulus e tyari a wortu fu Gado ini Berea tu, den go sutu faya gi den sma drape tu fu meki dyugudyugu. ");
INSERT INTO srnNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Dan wantron den bribisma meki Paulus go na sekanti, ma Silas nanga Timoteus tan drape. ");
INSERT INTO srnNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Den sma di ben tyari Paulus gwe, go nanga en te na a foto Atena. Dan den drai go baka nanga a boskopu gi Silas nanga Timoteus tak' den mus kon na Paulus so esi leki den kan. ");
INSERT INTO srnNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Di Paulus ben e wakti tapu Silas nanga Timoteus ini Atena, a no ben switi gi en di a si fa a foto lai nanga popki di den sma ben e anbegi leki gado. ");
INSERT INTO srnNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Dat' meki a go na a Dyukerki fu taki nanga den Dyusma nanga den tra sma di ben e anbegi Gado. Ala dei a ben e go na wowoyo tu fu taki nanga den sma di a ben miti drape. ");
INSERT INTO srnNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dan wantu Epikurian nanga Stoika koniman hari taki nanga Paulus. Sonwan fu den taki: “San a man disi prakseri tak' a e kon leri unu?” Trawan fu den taki: “A gersi tak' a e gi leri fu gado di unu no sabi ete.” Bika a ben ferteri den a Bun Nyunsu fu Yesus èn tak' dedesma o kon na libi baka. ");
INSERT INTO srnNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Den tyari Paulus go na a Areopagus, dan den taigi en taki: “Un wani sabi moro fu a nyun leri di yu e tyari kon. ");
INSERT INTO srnNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Bika yu e ferteri wi sani di wi no sabi, èn wi wani sabi san den wani taki.” ");
INSERT INTO srnNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Now a ben de so tak' ala den sma fu Atena nanga den doroseisma di ben libi drape, no ben abi no wan tra sani fu du, leki fu taki fu nyun sani di den kisi fu yere. ");
INSERT INTO srnNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Dan Paulus opo tnapu fesi den man fu a Areopagus èn a taki: “Borgu fu Atena, ala sani e sori mi tak' un abi bigi lespeki gi furu gado. ");
INSERT INTO srnNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bika di mi waka lontu ini a foto e luku den sani san un e anbegi, mi ai fadon tu tapu wan altari pe a skrifi taki: Gi wan Gado di wi no sabi. A Gado di un e anbegi sondro fu un sabi En, na fu a Gado dati mi e ferteri unu. ");
INSERT INTO srnNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","A Gado di meki grontapu nanga ala sani di de na en tapu, na En na Masra fu heimel nanga grontapu. A no e libi ini tempel di libisma meki. ");
INSERT INTO srnNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","A no e mankeri noti tu, dat' meki A no abi sma fanowdu fu sorgu gi En. Bika na En srefi meki tak' ala sani e libi. A e gi den bro nanga ala sani san den abi fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Fu wan sma nomo A meki ala den folku fu libi na heri grontapu. A ben seti na fesi tu olanga den bo libi, nanga pe den bo libi. ");
INSERT INTO srnNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Gado du ala den sani disi fu libisma sa suku En èn fir'firi den pasi fu feni En. Bika A no de fara fu wi alamala. ");
INSERT INTO srnNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Na En meki tak' wi e libi èn beweigi, èn tak' wi de na grontapu. Leki fa sonwan fu un eigi powema-man taki: ‘Wi na pikin fu En.’ ");
INSERT INTO srnNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Fu di wi na En pikin, dan wi no mus prakseri tak' Gado na wan popki fu gowtu, solfru, noso ston di libisma prakseri èn meki nanga en eigi koni. ");
INSERT INTO srnNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Gado no e luku na den dei di wi no ben sabi En. Ma now A e taigi ala sma na heri grontapu tak' den mus fu drai den libi. ");
INSERT INTO srnNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bika Gado poti wan dei pe A o meki wan man krutu ala libisma fu grontapu tapu wan leti fasi. Fu sori tak' na En srefi poti a man disi, A meki a kon na libi baka di a dede.” ");
INSERT INTO srnNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sonwan fu den sma bigin meki spotu di Paulus taki fu wan sma di opo baka na dede. Ma trawan taigi en taki: “Un sa taki wan tra leisi fu a tori disi.” ");
INSERT INTO srnNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dan Paulus gwe libi den. ");
INSERT INTO srnNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ma wantu fu den sma bribi en èn den bigin waka na en baka. Yu ben abi wan man fu a Areopagus di ben nen Dionisius, wan uma di ben nen Damaris, nanga wantu tra sma moro. ");
INSERT INTO srnNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Dan Paulus kmopo fu Atena go na Korinte. ");
INSERT INTO srnNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Drape a miti nanga wan Dyusma di ben nen Akwila. Akwila ben gebore ini a distrikti Pontus, èn a no langa di en nanga en wefi Prisila ben kmopo fu Italiakondre kon, fu di a grankownu Klaudius ben yagi ala Dyusma puru fu Roma. Dan Paulus go luku den. ");
INSERT INTO srnNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Den sma disi ben e meki tenti, èn fu di Paulus ben e du a srefi wroko, meki a tan na den dan a wroko nanga den. ");
INSERT INTO srnNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ibri sabadei Paulus ben e go ini a Dyukerki pe a ben pruberi fu meki den Dyusma nanga den Grikisma kon ferstan tak' a abi leti. ");
INSERT INTO srnNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Di Silas nanga Timoteus kmopo kon fu Masedonia, Paulus teki ala en ten fu preiki, èn a sori den Dyusma krin tak' Yesus na a Kristus. ");
INSERT INTO srnNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ma di den no ben wani arki en moro èn den bigin taki takru fu en, Paulus seki a santi puru fu en krosi leki wan marki tak' a kba nanga den. Dan a taigi den taki: “Na un eigi fowtu efu un go lasi, a no mi frantwortu moro. Bigin fu now mi o go na den sma di no de Dyu.” ");
INSERT INTO srnNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dan Paulus kmopo fu drape go na a oso fu Titius Yustus, di ben de let' na sei a Dyukerki. A man dati no ben de wan Dyu, ma a ben e anbegi Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, di ben de a edeman fu a Dyukerki, nanga ala den sma fu en oso, teki bribi ini Masra Yesus. Furu tra sma fu Korinte kon na bribi tu di den yere a boskopu fu Paulus, dan den teki dopu. ");
INSERT INTO srnNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Dan wan neti Gado sori Paulus wan sani. A si fa Masra e taigi en taki: “Yu no abi fu frede! Tan taki nanga den sma, yu no mus tan tiri. ");
INSERT INTO srnNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mi de nanga yu èn no wan sma o man du yu ogri, bika Mi abi furu sma ini a foto disi.” ");
INSERT INTO srnNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","So Paulus tan libi wan yari nanga siksi mun drape èn a leri den sma a wortu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ma di Galio ben de granman fu a distrikti Akaya, den Dyusma opo leki wan man dan den grabu Paulus tyari en go na krutu. ");
INSERT INTO srnNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Den taigi Galio taki: “A man disi e pruberi fu meki den sma dini Gado tapu wan tra fasi leki fa a wèt e taki.” ");
INSERT INTO srnNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Dan leki fa Paulus ben wani opo en mofo fu taki, Galio taigi den Dyusma taki: “Un Dyusma, yere. Efu a man disi ben du wan hebi ogri noso wan tra sani di no bun, dan mi bo teki ten fu arki san un abi fu taki. ");
INSERT INTO srnNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ma fu di un no e agri abra wortu, nen, nanga san a wèt fu unu e taki, dan un srefi mus luku san un e du. Mi no wani koti krutu fu den sani disi.” ");
INSERT INTO srnNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Dan a yagi den puru na fesi en krutusturu. ");
INSERT INTO srnNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ne den alamala grabu Sostenes, a edeman fu a Dyukerki, èn den fon en let' fesi a krutusturu. Ma Galio no hati en ede nanga den srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus tan wan heri pisten ini Korinte ete, dan a gwe libi den bribisma. Makandra nanga Prisila nanga Akwila, a go na a foto Kenkrea. Drape a meki den krebi en ede leki wan marki tak' a ben pramisi Gado wan sani. Dan den teki wan sipi fu go na Siriakondre. ");
INSERT INTO srnNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","A sipi go fosi na a foto Efese. Drape Paulus prati pasi nanga Prisila nanga Akwila, dan a go na a Dyukerki fu taki nanga den Dyusma. ");
INSERT INTO srnNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Den sma aksi en fu tan moro langa, ma a no ben wani. ");
INSERT INTO srnNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ma di a e gwe, a taigi den taki: “Efu Gado wani, mi sa drai kon baka na unu.” Dan a kmopo na Efese nanga sipi. ");
INSERT INTO srnNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Di a doro na Sesarea, Paulus go na syoro èn a taki a gemeente odi. Dan a go na Antiokia ini Siriakondre. ");
INSERT INTO srnNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A tan wan pisten drape, dan a gwe baka. A waka lontu ini den distrikti Galasia nanga Frigia èn a meki den bribisma kon tranga ini a bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Dan wan Dyu fu a foto Aleksandria di ben nen Apolos kon doro ini Efese. A ben de wan koni man èn a ben sabi a Santa Buku tapu en tin finga. ");
INSERT INTO srnNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A ben kisi leri abra a Nyun Pasi, èn tapu wan krakti fasi a ben e leri sma fin'fini abra Yesus. Ma a ben sabi soso fu a dopu fu Yohanes. ");
INSERT INTO srnNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Sondro frede Apolos bigin taki na ini den Dyukerki. Ma di Prisila nanga Akwila kon yere san a e taki, den teki en tyari go na den oso, dan den leri en den sani fu Gado moro fini. ");
INSERT INTO srnNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Di Apolos ben wani go na Akaya, den bribisma fu Efese gi en dek'ati fu go. Den skrifi wan brifi gi den bribisma drape tak' den mus teki en nanga opo anu. Di a doro drape, a ben de wan bigi yepi gi den sma di ben tron bribisma fu di Gado ben sori den En bun-ati. ");
INSERT INTO srnNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Bika tapu wan krakti fasi a ben sori den Dyusma na ala sma fesi tak' den no abi leti. A ben sori den kmopo fu a Santa Buku tak' Yesus na a Mesias. ");
INSERT INTO srnNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","A srefi ten di Apolos ben de ini Korinte, Paulus psa ini den distrikti te a kon doro na Efese. Drape a miti wantu bribisma. ");
INSERT INTO srnNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","A aksi den taki: “Unu kisi a Santa Yeye di un teki bribi?” Den piki en taki: “No, un no ben sabi srefi tak' wan Santa Yeye de.” ");
INSERT INTO srnNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Dan Paulus aksi den taki: “Sortu dopu un kisi dan?” Den piki en taki: “Wi kisi a dopu fu Yohanes.” ");
INSERT INTO srnNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ne Paulus taigi den taki: “Yohanes ben dopu sma te den ben drai den libi, èn a taigi den tak' den mus teki bribi ini a Man di bo kon na en baka. A Man dati na Yesus.” ");
INSERT INTO srnNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Di den yere a sani dati, den teki dopu ini a nen fu Masra Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Baka dati Paulus poti en anu na den tapu dan a Santa Yeye kon na den tapu. Den bigin taki ini tra tongo èn den taki san Gado gi den fu taki. ");
INSERT INTO srnNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Den sma dati ben de nanga den twarfu so. ");
INSERT INTO srnNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Dri mun langa Paulus tan go na a Dyukerki drape. Sondro frede a ben e taki nanga den sma fu a fasi fa Gado wani tiri libisma, èn a ben e pruberi fu meki den ferstan tak' a abi leti. ");
INSERT INTO srnNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ma wantu fu den sma no ben wani bribi san Paulus taki. Den no ben wani arki srefsrefi. Na ala sma fesi den ben e taki takru fu a Nyun Pasi. Dat' meki Paulus libi den sma dati, dan a teki den bribisma tyari go ini wan skoro fu wan man di ben nen Tiranus. Drape a ben taki ala dei nanga den. ");
INSERT INTO srnNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tu yari langa Paulus du a sani dati. Na so ala sma ini a distrikti Asia, Dyusma nanga sma di no de Dyu, kon yere a wortu fu Masra. ");
INSERT INTO srnNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Gado ben meki Paulus du bun bigi sani. ");
INSERT INTO srnNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Dat' meki sma ben tyari anyisa nanga tra krosi fu en skin go gi den sikisma. Te den ben du dati, den sikisma ben kon betre èn takruyeye ben gwe libi den. ");
INSERT INTO srnNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wantu fu den Dyusma di ben waka fu a wan presi go na a trawan e yagi takruyeye puru tapu sma, ben pruberi tu fu yagi takruyeye puru ini a nen fu Masra Yesus. Den ben e taki: “Mi e komanderi yu fu gwe ini a nen fu Yesus, di Paulus e preiki.” ");
INSERT INTO srnNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Den man di ben du dati ben de den seibi manpikin fu Skefas, wan fu den prenspari domri fu den Dyu. ");
INSERT INTO srnNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ma a takruyeye piki den taki: “Yesus mi sabi, èn mi sabi suma na Paulus, ma suma na unu?” ");
INSERT INTO srnNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dan a man di ben abi a takruyeye na en tapu, dyompo go na den tapu dan a fon den alamala. A man ben tranga moro den, tak' nanga mankeri èn nanga sososkin den ben abi fu lon kmopo fu a oso. ");
INSERT INTO srnNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ala sma fu Efese, den Dyusma nanga den sma di no de Dyu, kon yere a tori disi. Den alamala kon frede èn den gi a nen fu Masra Yesus bigi grani. ");
INSERT INTO srnNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Furu fu den sma di kon na bribi, ben kon taki na ala sma fesi sortu sondu den ben du. ");
INSERT INTO srnNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Furu fu den sma di ben du bonuwroko tyari den buku fu den kon na wan, dan den bron den let' fesi ala sma. Den sma teri gi omeni moni den bo man seri den buku disi èn den teri feifitenti dusun solfrumoni. ");
INSERT INTO srnNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","So a wortu fu Masra ben panya moro nanga moro èn a ben sori tak' a abi krakti. ");
INSERT INTO srnNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Baka den sani disi, Paulus teki a besroiti fu psa ini den distrikti Masedonia nanga Akaya te a bo go na Yerusalem. A taki: “Baka te mi go drape, mi mus go na Roma tu.” ");
INSERT INTO srnNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Dan a seni Timoteus nanga Erastus, tu fu den man di ben wroko nanga en, fu bigin go na Masedonia. Ma en srefi tan wan pisten ete ini Asia. ");
INSERT INTO srnNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A srefi ten dati wan bigi dyugudyugu broko ini Efese abra a Nyun Pasi. ");
INSERT INTO srnNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","A bigin nanga wan solfrusmeti di ben nen Demetrius. A man disi ben e meki pikin solfru tempel fu a gado Artemis. Na so a ben e meki den smeti wroko furu moni nanga a sani disi. ");
INSERT INTO srnNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dan Demetrius kari ala den smeti nanga den sma di ben abi fu du nanga a wroko disi, kon na wan. A taigi den taki: “Brada, un alamala sabi tak' wi e meki moi moni nanga a wroko di wi e du. ");
INSERT INTO srnNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ma un srefi e si èn un yere fa a man Paulus drai bun furu sma prakseri. A no dya ini Efese wawan, ma pikinso moro dan na ini heri Asia tu. Bika a e meki den bribi tak' gado di meki nanga anu, a no trutru gado. ");
INSERT INTO srnNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","A sani disi o meki tak' a wroko san wi e du kisi pori nen, èn den sma no o teri Artemis moro, di ala sma fu Asia nanga heri grontapu e anbegi. A tempel fu a bigi gado Artemis no o abi no wan warti moro.” ");
INSERT INTO srnNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Di den man yere san Demetrius taki, den ati teki faya dan den bigin bari taki: “Artemis fu Efese bigi!” ");
INSERT INTO srnNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","A heri foto kon bruya èn den lon leki wan man go na a stadion. Den ben grabu Gayus nanga Aristarkus srepi go nanga den. Den tu man dati ben waka nanga Paulus èn den ben de fu Masedonia. ");
INSERT INTO srnNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus ben wani go fu taki nanga den sma, ma den bribisma tapu en fu a no go. ");
INSERT INTO srnNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wantu heihei lantiman fu a distrikti Asia di ben de mati fu Paulus, seni warskow en tu tak' a no mus prefuru fu go drape. ");
INSERT INTO srnNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A heri konmakandra ben bruya srefsrefi, bika a wan ben e bari disi èn a trawan ben e bari dati. Moro furu fu den sma no ben sabi fu sanede den ben kon makandra. ");
INSERT INTO srnNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Dan wantu fu den sma bari taigi Aleksander san na a problema. Den Dyusma ben pusu a man disi go na fesi fu taki gi den. Dan Aleksander sori den sma nanga en anu tak' den mus tan tiri, fu a taki san psa. ");
INSERT INTO srnNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ma di den si tak' en na wan Dyusma, den bari tu yuru langa taki: “Artemis fu Efese bigi!” ");
INSERT INTO srnNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Te fu kba a fesiman fu a foto meki den sma tan tiri. A taigi den sma taki: “Sma fu Efese, ala sma na grontapu sabi tak' na den sma fu Efese abi a frantwortu fu sorgu gi a tempel fu a bigi gado Artemis nanga a santa ston fu en di fadon kmopo na heimel. ");
INSERT INTO srnNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","No wan sma kan strei tak' a no tru. Dat' meki un mus hori unsrefi èn un no mus du noti sondro fu prakseri bun san un o du. ");
INSERT INTO srnNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bika un tyari den man kon dya sondro tak' den fufuru sani puru fu a tempel èn sondro tak' den taki takru fu a gado fu unu. ");
INSERT INTO srnNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","We, efu Demetrius nanga den tra smeti no man feni en nanga wan sma, meki den tyari en go na krutu. Bika krutu e hori èn granman de di e koti krutu. ");
INSERT INTO srnNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Efu un wani wan sani ete, dan un sa taki fu a sani dati te wi kon makandra soleki fa a wèt e taki. ");
INSERT INTO srnNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Den kan kragi wi fu a dyugudyugu di psa tide. Wi no o man gi frantwortu fu sanede un ben meki opruru, bika noti no de san un kan tyari kon na fesi fu sanede un du en.” ");
INSERT INTO srnNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nanga den wortu dati a man seni den sma go na oso. ");
INSERT INTO srnNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Di a dyugudyugu ben kba, Paulus seni kari den bribisma dan a taki nanga den fu gi den dek'ati. Baka dati a taki den adyosi, dan a hari go na Masedonia. ");
INSERT INTO srnNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A psa ini a heri kontren drape èn a taki furu nanga den bribisma fu gi den dek'ati. Baka dati a doro na Grikikondre. ");
INSERT INTO srnNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Drape a tan dri mun. Di a meki ensrefi klari fu go nanga sipi na Siriakondre, a kisi fu yere tak' den Dyusma ben e suku wan fasi fu kiri en. So a teki a besroiti fu psa ini Masedonia te a e drai go baka. ");
INSERT INTO srnNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Wantu bribisma go nanga Paulus. Den man dati ben de Sopater a manpikin fu Pirus, di kmopo fu a foto Berea, Aristarkus nanga Sekundus fu a foto Tesalonika, nanga Gayus fu a foto Derba. Moro fara yu ben abi Timoteus, nanga tu man fu a distrikti Asia di ben nen Tikikus nanga Trofimus. ");
INSERT INTO srnNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Den man disi go na un fesi dan den wakti unu na Troas. ");
INSERT INTO srnNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ma wi srefi wakti te leki a Paskafesa kba, dan fosi wi teki wan sipi kmopo fu Filipi go na Troas. Baka feifi dei wi doro na den tra brada, dan wi tan seibi dei drape. ");
INSERT INTO srnNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tapu a fosi dei fu a wiki, wi ben kon makandra fu broko brede. Dan Paulus bigin taki nanga den bribisma, èn fu di a bo gwe a tra dei, a taki nanga den te mindrineti. ");
INSERT INTO srnNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Wi ben de makandra ini wan bigi kamra na tap'sei fu wan oso. Furu oli lampu ben leti ini a kamra. ");
INSERT INTO srnNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Wan yonkuman di ben nen Etikus ben sidon tapu wan fensre-bangi. Dan fu di Paulus ben taki langa, a go ini wan dipi sribi dan a fadon go te na gron. Di den opo en puru na gron, a ben dede. A boi no tan na libi fu di yu ben mus kren dri trapu fu kon pe wi ben de. ");
INSERT INTO srnNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ma Paulus go na gron, a didon tapu a dedeskin èn a brasa en. Dan a taki: “Un no abi fu frede, bika a e libi.” ");
INSERT INTO srnNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Di a go baka na tap'sei, a broko brede dan a nyan nanga den. A taki nanga den te leki dei broko, dan a gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Den sma tyari a boi libilibi gwe èn a sani dati gi den furu dek'ati. ");
INSERT INTO srnNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Fu di Paulus ben wani en so, meki wi go moro fara nanga sipi na a foto Asus pe en bo kon ini a sipi. A ben wani waka nanga futu kon drape. ");
INSERT INTO srnNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Di a doro na Asus, a kon ini a sipi èn so un go na a foto Mitilena. ");
INSERT INTO srnNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Fu drape wi hari go moro fara, èn a tamara fu en wi doro fesi Kios. A tra dei wi hari go na Samos, èn a dei na en baka wi doro na Mileta. ");
INSERT INTO srnNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Wi ben psa Efese fu di Paulus no ben wani lasi ten ini a distrikti Asia, bika a ben e feti fu doro na Yerusalem. A ben e suku fu doro drape tapu a Pinksterfesa efu a ben man. ");
INSERT INTO srnNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Di Paulus ben de na Mileta, a seni kari den fesiman fu a gemeente fu Efese kon. ");
INSERT INTO srnNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Di den man kon, Paulus taigi den taki: “Un sabi fa mi ben libi na un mindri sensi a dei di mi poti futu ini Asia. ");
INSERT INTO srnNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi wroko gi Masra nanga ala sakafasi. Mi krei furu èn mi nyan furu pina fu di den Dyusma ben wani kiri mi. ");
INSERT INTO srnNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ala san ben de fanowdu fu un sabi, mi leri èn ferteri unu. Mi du dati na ini un oso èn na ala sma fesi. Mi no hori noti na baka gi unu. ");
INSERT INTO srnNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi leri Dyusma nanga sma di no de Dyu tak' den mus fu drai den libi kon na Gado èn teki bribi ini wi Masra Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Luku, now a Santa Yeye e meki mi go na Yerusalem èn mi no sabi san o miti mi drape. ");
INSERT INTO srnNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","San mi sabi nomo na tak' a Santa Yeye e taigi mi wan krin fasi na ibri foto tak' sma o poti mi na ini straf'oso, èn den o pina mi. ");
INSERT INTO srnNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ma mi eigi libi no prenspari, a no e teri gi mi. San prenspari gi mi, na tak' mi kan kba a wroko di Masra Yesus gi mi fu du. A wroko dati na fu ferteri libisma a Bun Nyunsu fu a bun-ati fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Now mi sabi tak' no wan fu unu di mi kon ferteri fu a fasi fa Gado wani tiri libisma, o si mi moro. ");
INSERT INTO srnNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Fu dat'ede mi e taigi un tide tak' a no mi frantwortu moro efu un go lasi. ");
INSERT INTO srnNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Bika mi no hori noti na baka, ma mi ferteri unu ala sani san Gado ben wani fu un sabi. ");
INSERT INTO srnNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Sorgu tak' un e luku bun fa un e tyari unsrefi nanga ala den bribisma. A Santa Yeye poti unu leki sma di e tiri a gemeente, èn A gi unu a frantwortu fu sorgu gi a gemeente fu Gado di A bai nanga a brudu fu En Manpikin. ");
INSERT INTO srnNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Bika mi sabi tak' te mi gwe, sma o kon na unu di gersi krasi tigri èn den o pruberi fu pori a gemeente. ");
INSERT INTO srnNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Sma o opo na un mindri di o taki sani di no tru, fu hari den bribisma kon na den baka. ");
INSERT INTO srnNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Un mus tan na ai, èn un no mus fergiti tak' na dri yari langa mi sori ibriwan fu unu fa fu tyari ensrefi. Mi du dati dei nanga neti èn nanga furu watra ai. ");
INSERT INTO srnNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Now mi e libi unu ini a anu fu Gado nanga a wortu di e sori unu a bun-ati fu En. Bika A kan meki un gro ini a bribi èn kisi den blesi di A pramisi den sma fu En. ");
INSERT INTO srnNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mi no ben abi bigi-ai tapu tra sma solfru, gowtu noso krosi. ");
INSERT INTO srnNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Un srefi sabi fa mi wroko fu sorgu misrefi nanga den sma di ben de nanga mi. ");
INSERT INTO srnNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Tapu a fasi disi mi sori unu tak' un mus wroko tranga, soleki fa mi ben du, fu man yepi pôtisma. Un memre tu den wortu di Masra Yesus ben taki: Wan moro bigi blesi de tapu a sma di e gi, dan tapu a sma di e kisi.” ");
INSERT INTO srnNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Di Paulus kba taki, a kindi dan a begi nanga ala den sma. ");
INSERT INTO srnNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Dan den alamala bari krei. Den brasa en èn den bosi en. ");
INSERT INTO srnNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Noti no ben meki den sari so, leki di Paulus taigi den tak' noiti moro den no o si en. Dan den tyari en go na a sipi. ");
INSERT INTO srnNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Baka di wi prati nanga furu muiti fu den, wi koti a se abra go langalanga na Kos. A tra dei a sipi go na Rodos, dan fu drape wi go na Patara. ");
INSERT INTO srnNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Drape wi feni wan sipi di bo go na Fenisia. Wi go ini a sipi èn so wi kon gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Di a eilanti Siprus ben de fu si na wi kruktu-anu sei, wi psa en go moro fara na Siriakondre. Dan wi doro na a foto Tirus, pe den bo puru a lai ini a sipi. ");
INSERT INTO srnNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Drape wi go suku den bribisma, dan wi tan seibi dei nanga den. Den taigi Paulus tak' a Santa Yeye ben taigi den fu a no go na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ma baka den seibi dei dati wi go moro fara. Ala den brada, makandra nanga den wefi nanga den pikin fu den, kon nanga wi te na dorosei fu a foto. Di wi doro na sekanti, wi kindi dan wi begi. ");
INSERT INTO srnNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Baka dati wi taki makandra odi. Dan wi go ini a sipi èn den drai go baka na oso. ");
INSERT INTO srnNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Di wi kmopo na Tirus wi seiri go na Ptolemais. Drape wi go taki den bribisma odi, dan wi tan wan dei nanga den. ");
INSERT INTO srnNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","A tra dei fu en wi go moro fara na Sesarea. Drape wi go tan na a oso fu Filipus di e panya a Bun Nyunsu fu Gado. A ben de wan fu den seibi man di ben yepi ini a gemeente fu Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A ben abi fo umapikin di no ben abi masra ete. Den uma disi ben de profeiti. ");
INSERT INTO srnNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Di wi ben de wan pisten drape, wan profeiti di ben nen Agabus kmopo fu Yudea kon. ");
INSERT INTO srnNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Di a kon na unu, a teki a banti nanga san Paulus ben lontu en bere, a tai en eigi anu nanga futu, dan a taki: “Yere san a Santa Yeye e taki: Na so den Dyusma fu Yerusalem o tai a man di abi a banti disi. Dan den o gi en abra na den sma di no de Dyu.” ");
INSERT INTO srnNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Di wi yere a sani dati, wi nanga den bribisma drape begi Paulus tangitangi fu no go na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ma Paulus piki un taki: “Fu sanede un e krei so? Un e meki mi lasi ati. Mi no klari wawan fu den tai mi na Yerusalem, ma fu dede drape srefi gi a nen fu Masra Yesus.” ");
INSERT INTO srnNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Di wi si tak' Paulus no e kenki en prakseri, wi tan tiri. Dan wi taki: “Meki a wani fu Masra psa.” ");
INSERT INTO srnNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Baka dati un meki unsrefi klari dan un hari go na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wantu bribisma fu Sesarea kon nanga wi. Den tyari wi go na a oso fu Mnason pe wi bo tan. Mnason ben de fu Siprus, èn a ben de wan fu den fosi sma di teki bribi ini Masra Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Di wi doro na Yerusalem, den bribisma teki wi nanga opo anu. ");
INSERT INTO srnNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","A tra dei wi nanga Paulus go luku Yakobus. Ala den fesiman fu a gemeente ben drape tu. ");
INSERT INTO srnNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Baka di Paulus taki den odi, a ferteri den finifini fu a wroko di Gado meki a du mindri den sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Di den yere dati, den gi Gado grani. Dan den taigi Paulus taki: “Brada, yu si omeni dusundusun Dyusma kon teki bribi na ini Masra Yesus, èn den alamala e du ala muiti fu du san a wèt fu Moses e taki. ");
INSERT INTO srnNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Now sma taigi den tak' yu e leri ala den Dyusma di e libi na mindri den tra folku, tak' den no abi fu du moro san a wèt fu Moses e taki. Yu ben sa taigi den tak' den no abi fu besnei den pikin, èn tak' den no abi fu hori den gwenti fu den Dyu moro. ");
INSERT INTO srnNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","San musu psa now? Bika den o yere tak' yu doro dyaso. ");
INSERT INTO srnNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Arki now san yu mus du. Wi abi fo man dyaso di pramisi Gado wan sani. ");
INSERT INTO srnNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Go nanga den man disi, dan yu teki prati nanga den te den o krin densrefi soleki fa a wèt e taki. Pai gi den san de fu pai, dan den kan krebi den ede. So ala sma sa si tak' den sani di den sma e ferteri fu yu no tru, bika yu srefi e libi soleki fa a wèt e taki. ");
INSERT INTO srnNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Gi den bribisma di no de Dyu, wi ben seni wan brifi kba nanga den besroiti di wi teki, tak' den no mus nyan noti di offer na tra gado. Sosrefi den no mus nyan brudu, den no mus nyan meti di kiri sondro tak' a brudu lon kmopo, èn den no mus gi densrefi abra na takru lostu.” ");
INSERT INTO srnNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","A tra dei Paulus go nanga den fo man, dan den krin densrefi soleki fa a wèt e taki. Dan a go ini a mamakerki go taigi a Dyudomri oten den bo kba fu krin densrefi, fu den ben kan tyari a offer san den ben mus tyari gi ibriwan fu den. ");
INSERT INTO srnNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Di den seibi dei fu krin densrefi ben de fu kba, wantu Dyusma fu a distrikti Asia si Paulus ini a mamakerki. Ne den sutu faya gi den sma, den grabu en, ");
INSERT INTO srnNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","dan den bari taki: “Kondreman, kon yepi wi! Disi na a man di e waka leri ala sma na ala sei tak' den sani fu den Dyusma no bun. A e leri den tu tak' den no abi fu teri a wèt fu Moses nanga a presi disi. Boiti dati a pori a Santa Presi fu di a tyari Grikisma go ini a mamakerki.” ");
INSERT INTO srnNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Den man taki so fu di den ben si Trofimus, di ben kmopo fu Efese, e waka nanga Paulus ini a foto, èn den prakseri tak' Paulus ben tyari en go ini a mamakerki tu. ");
INSERT INTO srnNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","A sani disi tyari wan bigi dyugudyugu kon ini a foto. Den sma lon kon fu ala sei. Den grabu Paulus èn den srepi en kmopo fu a mamakerki. Dan wantron den tapu den doro fu a mamakerki. ");
INSERT INTO srnNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Di den sma ben e suku fu kiri Paulus, a komandanti fu den Romeini srudati kisi a boskopu tak' heri Yerusalem de ini bigi dyugudyugu. ");
INSERT INTO srnNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Wantron a teki srudati nanga ofisiri lon go na den sma. Di den sma si a komandanti nanga den srudati, den tapu fu naki Paulus. ");
INSERT INTO srnNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dan a komandanti go na en, a meki den grabu en, dan a taigi den fu keti en nanga tu keti. Dan a aksi den sma taki: “Suma na a man disi èn san a du?” ");
INSERT INTO srnNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Den sma ben meki sowan babari tak' a komandanti no ben man kisi fu yere san psa. Bika a wan ben bari disi, a trawan ben bari dati. So a taigi den srudati fu tyari Paulus go na a srudati-oso. ");
INSERT INTO srnNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Di den doro na a trapu fu a oso, den sma meki sowan dyugudyugu tak' den srudati ben abi fu opo Paulus tyari go moro fara. ");
INSERT INTO srnNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bika a bigi grupu sma di ben e waka na den baka, ben e tan bari taki: “Kiri en, kiri en!” ");
INSERT INTO srnNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Di den srudati ben de fu tyari Paulus go na ini a srudati-oso, a aksi a komandanti taki: “Mi kan aksi yu wan sani?” A komandanti piki en taki: “So, yu sabi taki Grikitongo? ");
INSERT INTO srnNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","A no yu na a man fu Egipte di no langa di psa meki opruru ini a kondre èn di lowe go ini a dreisabana nanga fo dusun kiriman?” ");
INSERT INTO srnNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulus piki a man taki: “Mi na wan Dyu. Mi na wan borgu fu Tarsus, wan prenspari foto na Silisia. Mi e aksi yu primisi fu taki nanga den sma.” ");
INSERT INTO srnNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","A komandanti gi en primisi, dan Paulus tan tnapu tap'sei fu a trapu èn a sori den sma nanga en anu tak' den mus tan tiri. Di den alamala tan tiri, Paulus bigin taki nanga den ini Dyutongo. A taki: ");
INSERT INTO srnNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Papa nanga brada, un yere. Mi wani sori unu tak' mi no fowtu.” ");
INSERT INTO srnNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Di den sma yere tak' Paulus bigin taki nanga den ini Dyutongo, den kon moro tiri. Dan Paulus taigi den taki: ");
INSERT INTO srnNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mi na wan Dyusma di gebore na Tarsus ini Silisia. Ma mi kweki ini a foto disi èn mi kisi leri fu Gamaliyel, di leri mi fin'fini fa mi mus hori a wèt fu den afo fu wi. Mi ben du ala muiti fu du san Gado wani, leki fa un alamala e du tide. ");
INSERT INTO srnNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mi ben de na den sma baka di e bribi ini a Nyun Pasi fu kiri den. Man nanga uma mi tai nanga keti èn mi poti den ini straf'oso. ");
INSERT INTO srnNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","A grandomri nanga a heri Grankrutu fu unu kan taki tak' na so a de. Bika na den srefi ben gi mi brifi gi den brada fu unu ini Damaskus. Drape mi ben wani grabu den sma èn bui den tyari kon na Yerusalem fu strafu den. ");
INSERT INTO srnNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ma di mi ben de na pasi krosbei fu Damaskus, wan sani miti mi. Brekten yuru wan krin faya di kmopo fu heimel, lontu mi. ");
INSERT INTO srnNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mi fadon na gron, dan mi yere wan sten aksi mi taki: ‘Saul, Saul, fu sanede yu de na Mi baka fu du Mi ogri?’ ");
INSERT INTO srnNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mi aksi taki: ‘Masra, suma na Yu?’ A sten piki mi taki: ‘Mi na Yesus fu Nasaret di yu e du ogri.’ ");
INSERT INTO srnNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Den man di ben de nanga mi si a faya, ma den no yere a sten fu a Wan di ben e taki nanga mi. ");
INSERT INTO srnNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Dan mi aksi taki: ‘Masra, san mi mus du?’ Masra taigi mi taki: ‘Opo go na Damaskus. Drape yu sa kisi fu yere ala sani san yu mus du.’ ");
INSERT INTO srnNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Den man di ben de nanga mi, ben hori mi na mi anu tyari go na Damaskus, fu di a krin faya ben breni mi. ");
INSERT INTO srnNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Drape wan man kon na mi di ben nen Ananias. A ben e hori ensrefi trutru na a Dyubribi, èn ala den Dyusma drape ben e taki bun fu en. ");
INSERT INTO srnNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","A tnapu na mi sei, dan a taki: ‘Brada Saul, Gado e meki yu si baka!’ A srefi momenti dati mi ben kan si a man. ");
INSERT INTO srnNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","A taigi mi moro fara taki: ‘A Gado fu den afo fu wi ben teki yu na fesi kba fu yu kon sabi a wani fu En, èn fu yu si a Wan di bun ini Gado ai, èn fu yu yere En sten. ");
INSERT INTO srnNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Bika yu mus ferteri ala sma san yu si èn san yu yere fu En. ");
INSERT INTO srnNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","So no draidrai moro. Opo, teki dopu èn kari a nen fu Masra fu A gi yu pardon fu yu sondu.’ ");
INSERT INTO srnNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Di mi ben de baka na Yerusalem èn mi ben de ini a mamakerki e begi, Gado sori mi wan sani. ");
INSERT INTO srnNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mi si fa Masra e taigi mi taki: ‘Du esi fu kmopo na Yerusalem, bika den sma dyaso no sa bribi san yu o ferteri den fu Mi.’ ");
INSERT INTO srnNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Dan mi piki taki: ‘Masra, den sma sabi tak' na mi ben e grabu den sma di e bribi ini Yu. Mi ben e poti den na straf'oso èn mi ben e meki den kisi fonfon ini den Dyukerki. ");
INSERT INTO srnNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Èn mi ben tnapu drape di den kiri Stefanus, a man di ben e ferteri tra sma fu Yu. Mi ben feni en heri bun èn mi ben hori wakti na den krosi fu den man di ben e kiri en.’ ");
INSERT INTO srnNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ma Masra taigi mi taki: ‘Yu mus gwe, bika Mi o seni yu go na fara presi, na sma di no de Dyu.’ ” ");
INSERT INTO srnNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Den sma arki Paulus te leki a taki a sani disi. Dan den bigin bari taki: “Kiri en! A no fiti fu sowan sma tan na libi!” ");
INSERT INTO srnNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Den sma ben e bari, den ben e wai nanga den krosi èn den ben e fringi santi na loktu. ");
INSERT INTO srnNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ne a komandanti komanderi den fu tyari Paulus go ini a srudati-oso. A taigi den tak' den mus wipi Paulus fu a taigi en fu sanede den sma ben e rigeri so nanga en. ");
INSERT INTO srnNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ma di den tai Paulus fu fon en, a taigi a ofisiri di ben tnapu drape taki: “San a wèt e taki? Yu kan wipi wan Romeinisma sondro tak' krutubakra leisi strafu gi en?” ");
INSERT INTO srnNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Di a ofisiri yere san Paulus taki, a go taigi a komandanti taki: “Sabi san yu o du. A man disi na wan borgu fu Roma.” ");
INSERT INTO srnNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","A komandanti go na Paulus, dan a aksi en taki: “Yu na wan Romeinisma?” Paulus piki taki: “Iya.” ");
INSERT INTO srnNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Dan a komandanti taki: “Mi pai furu moni fu tron wan Romeinisma.” Ma Paulus taigi en taki: “Ma mi gebore leki wan Romeinisma.” ");
INSERT INTO srnNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Den srudati di ben mus fon en fu yere san a du, libi en wantron. A komandanti srefi kon frede di a kon sabi tak' a ben meki den tai wan Romeinisma. ");
INSERT INTO srnNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","A tra dei fu en, a komandanti meki den lusu Paulus. Dan a seni kari den prenspari domri nanga den man fu a Grankrutu fu den Dyu kon, fu di a ben wani sabi finifini fu sanede den sma ben suku fu kiri en. Dan a tyari Paulus kon na dorosei, meki a tnapu fesi den man disi. ");
INSERT INTO srnNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulus hori en ai tapu den man fu a Grankrutu dan a taigi den taki: “Brada, mi abi wan krin konsensi fesi Gado fu a fasi fa mi tyari misrefi te nanga a dei fu tide.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ma a grandomri Ananias taigi den man di ben tnapu sei Paulus tak' den mus naki en tapu en mofo. ");
INSERT INTO srnNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Dan Paulus taigi en taki: “Gado srefi sa naki yu, yu hoigriman! Yu teki a wèt fu krutu mi, ma yu srefi e broko a wèt fu meki sma naki mi.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Den man di ben tnapu sei Paulus aksi en taki: “Na kosi yu e kosi a grandomri fu Gado?” ");
INSERT INTO srnNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulus piki den taki: “Brada, mi no ben sabi tak' na a grandomri. Bika a skrifi taki: Yu no mus taki takru fu wan edeman fu a pipel.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ma fu di Paulus ben sabi tak' sonwan fu den man ben de Saduseiman èn tak' trawan ben de Fariseiman, a bari taigi den taki: “Brada, mi na wan Fariseiman èn mi p'pa ben de wan Fariseiman tu. Den wani krutu mi fu di mi e bribi tak' dedesma o kon na libi baka.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Di Paulus taki a sani dati, wan prati kon na mindri den Fariseiman nanga den Saduseiman èn den sma di ben drape prati na ini tu grupu. ");
INSERT INTO srnNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Bika den Saduseiman e taki tak' dedesma no e kon na libi baka, èn den e taki tu tak' engel noso tra yeye no de. Ma den Fariseiman e taki tak' ala den sani disi de. ");
INSERT INTO srnNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Dan den sma bigin meki wan bigi babari. Sonwan fu den sabiman fu Gado wèt di ben de Fariseiman, opo tnapu. Den bigin bari san den feni fu a sani, den taki: “Wi no feni no wan ogri na a man disi! A kan tak' na wan yeye noso wan engel taki nanga en!” ");
INSERT INTO srnNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A trobi mindri den tu grupu kon so hebi tak' a komandanti ben frede tak' den bo priti Paulus na tu. Dat' meki a komanderi den srudati fu go puru Paulus na den mindri, tyari go na a srudati-oso. ");
INSERT INTO srnNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","A neti dati Masra kon na Paulus èn A taigi en taki: “Hori dek'ati. Bika leki fa yu ferteri den sma dya na Yerusalem fu Mi, na so yu mus go ferteri den sma na Roma fu Mi tu.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","A tra dei fu en den Dyu meki mofo fu kiri Paulus. Den meki wan sweri tak' den no bo nyan noso dringi te leki den kiri en. ");
INSERT INTO srnNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Moro leki fotenti man ben meki a sweri dati. ");
INSERT INTO srnNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Den go na den prenspari domri nanga den fesiman fu a folku dan den taigi den taki: “Wi meki wan sweri tak' wi no o nyan noti te leki wi kiri Paulus. ");
INSERT INTO srnNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","So, makandra nanga den man fu a Grankrutu, unu fu un sei mus seni aksi a komandanti now fu a tyari Paulus ete wan leisi kon na krutu. Un mus du leki un wani ondrosuku a tori fu en moro fini. Dan wi sa teki en na wi tapu fu kiri en fosi a doro dyaso.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ma a boi fu Paulus sisa yere san den Dyu ben seti fu du. Dan a go na ini a srudati-oso, go ferteri Paulus san a ben yere. ");
INSERT INTO srnNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ne Paulus seni kari wan fu den ofisiri, dan a taigi en taki: “Tyari a boi disi go na a komandanti. A abi wan sani fu taigi en.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","A ofisiri teki a boi tyari go na a komandanti, dan a taigi en taki: “A straf'man Paulus seni kari mi, dan a aksi mi fu tyari a boi disi kon na yu. A abi wan sani fu taigi yu.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","A komandanti hori a boi na en anu tyari go na wan sei. Dan a aksi en taki: “San yu abi fu taigi mi?” ");
INSERT INTO srnNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","A boi piki en taki: “Den Dyusma meki mofo tak' den o aksi yu fu tyari Paulus tamara kon fesi a Grankrutu fu den. Den o meki leki den wani aksi en wan sani moro fini. ");
INSERT INTO srnNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ma yu no mus du san den taki, bika moro leki fotenti fu den seti luru fu kiri Paulus. Den meki wan sweri tak' den no o nyan noso dringi te leki den kiri en. Nownowde den tnapu klar'klari e wakti fu yu seni en kon.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","A komandanti taigi a boi taki: “Yu no mus taigi no wan sma tak' yu gi mi wan pingi fu a sani disi.” Dan a seni en gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Baka dati a kari tu ofisiri kon na en dan a taigi den taki: “Tide neti neigi yuru, tu hondro srudati mus tnapu klari fu go na Sesarea. Seibitenti srudati na tapu asi, nanga tu hondro srudati di e feti nanga lansri mus go nanga den. ");
INSERT INTO srnNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Sorgu tak' Paulus abi asi tu, dan un tyari en go na granman Feliks sondro tak' wan sani psa nanga en.” ");
INSERT INTO srnNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Dan a komandanti skrifi wan brifi gi granman Feliks. A skrifi: ");
INSERT INTO srnNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Lespeki granman Feliks, Disi na wan brifi fu komandanti Klaudius Lisias. Mi e seni taki yu odi. ");
INSERT INTO srnNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Den Dyusma ben grabu a man disi èn den bo kiri en. Ma di mi yere tak' en na wan Romeinisma, mi nanga mi srudati kon ini a tori èn mi puru a man na den anu. ");
INSERT INTO srnNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Fu di mi ben wani sabi fu sanede den ben kragi en, mi tyari en go na fesi a Grankrutu fu den. ");
INSERT INTO srnNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Drape mi kon si tak' a man no du noti fu a mus dede noso go na strafu. Den ben krutu en soso fu a wèt fu den. ");
INSERT INTO srnNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Di mi yere tak' den meki mofo fu kiri en, mi seni en kon wantron na yu. Dan mi taigi den sma di e krutu en fu kon taigi yu san den abi nanga en. ");
INSERT INTO srnNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Den srudati du san a komandanti komanderi den fu du, èn den teki Paulus a neti dati go na a foto Antipatris. ");
INSERT INTO srnNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","A tra dei fu en den srudati di ben waka, drai go baka na a srudati-oso ini Yerusalem. Den srudati na tapu den asi tyari Paulus go moro fara. ");
INSERT INTO srnNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Di den dati doro na Sesarea, den tyari Paulus nanga a brifi gi granman Feliks. ");
INSERT INTO srnNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","A granman leisi a brifi, dan a aksi fu sortu distrikti Paulus kmopo. Di a yere tak' a kmopo fu Silisia, ");
INSERT INTO srnNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","a taigi en taki: “Mi sa ondrosuku a tori fu yu te den sma di e kragi yu doro.” Dan a komanderi den fu tyari Paulus go sroto ini a kownu-oso fu Herodes. ");
INSERT INTO srnNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Baka feifi dei a grandomri Ananias nanga wantu fesiman fu a folku doro na granman Feliks fu kragi Paulus. Den ben tyari wan afkati kon nanga den di ben nen Tertulus. ");
INSERT INTO srnNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Di den seni teki Paulus, Tertulus bigin kragi en taki: “Mi lespeki granman Feliks, wi sabi tak' na a fasi fa yu e tiri a kondre meki tak' wi e libi ini freide èn tak' sani e go moro bun nanga a pipel disi. ");
INSERT INTO srnNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Disi wi e taki ala leisi na ala sei, èn wi e taki yu grantangi fu ala den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ma mi no wani teki furu ten fu yu. Dat' meki mi e begi yu fu sori wi yu bun-ati èn fu arki san wi o taki wan syatu fasi. ");
INSERT INTO srnNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bika wi si tak' a man disi de leki wan takru siki. A e tyari dyugudyugu na mindri den Dyusma na ala sei fu grontapu. A de wan fesiman fu a grupu di den e kari Nasaretsma. ");
INSERT INTO srnNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","A ben pruberi tu fu pori a mamakerki fu unu, ma un grabu en. Wi ben wani strafu en soleki fa a wèt fu den Dyu e taki, ");
INSERT INTO srnNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ma komandanti Lisias kon ini a tori, èn nanga tranga a puru en na un anu. ");
INSERT INTO srnNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Dan a taigi den sma di e kragi en fu kon na yu. Te yu taki nanga en fu ala den sani disi, dan yu srefi o yere tak' ala den sani di wi taki fu en tru.” ");
INSERT INTO srnNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Den tra Dyusma agri nanga ala san Tertulus ben taki. Den taki tak' a tru. ");
INSERT INTO srnNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Di granman Feliks sori Paulus tak' a abi a okasi fu taki, Paulus taigi en taki: “Mi sabi tak' someni yari kba yu e koti krutu gi a pipel disi. Dat' meki mi no e frede fu taki na yu fesi tak' mi no fowtu. ");
INSERT INTO srnNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","A no moro leki twarfu dei di psa mi go na Yerusalem fu go anbegi Gado. Efu yu aksi, yu srefi sa yere tak' na so a de. ");
INSERT INTO srnNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Den no kan taki tak' den si pe mi hari taki nanga sma ini a mamakerki noso pe mi meki dyugudyugu ini den Dyukerki, noso wan tra presi ini a foto. ");
INSERT INTO srnNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Den no man sori yu tu tak' den sani tru fu san den e kragi mi now. ");
INSERT INTO srnNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mi e bribi ala sani san de ini a wèt èn san den profeiti ben taki. Ma a de tru tak' mi e dini a Gado fu wi afo tapu wan fasi di den e kari a Nyun Pasi. Ma den e si en leki wan falsi leri. ");
INSERT INTO srnNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mi e ferwakti a srefi sani leki den, tak' Gado o meki ala dedesma kon na libi baka: den sma di bun ini Gado ai, nanga den sma di no bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Dat' meki mi e du muiti fu abi wan krin konsensi fesi Gado nanga libisma. ");
INSERT INTO srnNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Baka someni yari mi drai go baka na Yerusalem fu tyari moni gi mi pipel èn fu tyari offer gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Di mi ben e du den sani dati, den kon miti mi ini a mamakerki. Mi ben krin misrefi leki fa a wèt fu den Dyu e taki. A no de so tak' furu sma ben drape, noso tak' dyugudyugu ben de. ");
INSERT INTO srnNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ma wantu Dyusma fu Asia ben drape. Na den dati ben mus kon dya fu kon kragi mi na yu fesi efu den ben abi wan sani nanga mi. ");
INSERT INTO srnNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Noso meki den man disi taki sortu fowtu den feni na mi di mi ben tnapu fesi a Grankrutu fu den. ");
INSERT INTO srnNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kande na fu a wan sani di mi bari, di mi ben tnapu na den fesi taki: ‘Un tyari mi kon na krutu tide fu di mi e bribi tak' dedesma o kon na libi baka.’ ” ");
INSERT INTO srnNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Dan granman Feliks, di ben sabi heri bun fu a Nyun Pasi, tapu a krutu. A taigi den taki: “Te komandanti Lisias kon, mi sa koti krutu ini a tori disi.” ");
INSERT INTO srnNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Dan a taigi a ofisiri fu a hori Paulus na straf'oso, ma den no ben mus du nanga en leki fa den e du nanga den tra straf'man. Èn den no ben mus tapu den mati fu Paulus fu kon sorgu en. ");
INSERT INTO srnNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Wantu dei na baka Feliks kon drape nanga en wefi Drusila di ben de wan Dyu. Dan a seni kari Paulus meki a ferteri en fu a bribi na ini Kristus Yesus. ");
INSERT INTO srnNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ma di Paulus bigin taki fu san bun ini Gado ai, èn tak' un mus hori unsrefi, èn tak' Gado o krutu libisma, Feliks kon frede. Dat' meki a taigi Paulus taki: “A nofo fu tide. Te mi abi ten mi sa seni kari yu baka.” ");
INSERT INTO srnNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ma a srefi ten Feliks ben e howpu tak' Paulus bo gi en moni. Fu dat'ede a ben e seni kari en ala yuru fu taki nanga en. ");
INSERT INTO srnNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Baka tu yari, Porsius Festus tron granman na Feliks presi. Ma fu di Feliks ben wani du den Dyusma wan bun, meki a libi Paulus ini a straf'oso na baka. ");
INSERT INTO srnNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Dri dei baka di granman Festus doro ini a distrikti, a kmopo fu Sesarea go na Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Di a doro drape den prenspari domri nanga den fesiman fu den Dyu, go kragi Paulus na en. ");
INSERT INTO srnNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Dan den aksi Festus fu du den wan bun, fu meki Paulus kon na Yerusalem. Den ben aksi a sani disi fu di den ben meki mofo fu kiri Paulus na pasi. ");
INSERT INTO srnNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ma Festus piki den tak' Paulus bo tan ini a straf'oso na Sesarea, èn tak' baka wantu dei en srefi bo go drape. ");
INSERT INTO srnNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","A taigi den tu fu meki wantu edeman go nanga en fu kragi Paulus efu den feni tak' a du wan sani san no fiti. ");
INSERT INTO srnNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Baka aiti kon miti tin dei, Festus libi den dan a drai go baka na Sesarea. A tra dei fu en a hori krutu èn a meki den tyari Paulus kon. ");
INSERT INTO srnNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Di Paulus doro, den Dyu di ben kmopo fu Yerusalem lontu en èn den tyari wan lo hebi kragi kon na fesi. Ma den no ben kan sori tak' den sani tru. ");
INSERT INTO srnNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulus fu en sei taki: “Mi no broko a wèt fu den Dyu, mi no pori a mamakerki, èn mi no broko no wan wèt fu a grankownu.” ");
INSERT INTO srnNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ma Festus ben wani du den Dyusma wan bun. So a aksi en taki: “Yu wani go baka na Yerusalem fu mi krutu a tori fu yu drape?” ");
INSERT INTO srnNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulus piki en taki: “Mi tnapu fesi a krutusturu fu a grankownu èn dati na a presi pe den mus krutu mi. Mi no du den Dyusma noti. Yu srefi sabi dati heri bun. ");
INSERT INTO srnNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Efu mi du wan sani di fiti tak' mi mus dede, dan mi de klari fu den kiri mi. Ma efu noti no tru fu san den e kragi mi, dan no wan sma kan gi mi abra na den, soso fu du den wan bun. Mi wani fu a grankownu krutu a tori fu mi.” ");
INSERT INTO srnNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Baka di Festus kenki prakseri nanga den raiman fu en, a piki Paulus taki: “Yu aksi fu a grankownu krutu yu, dan un sa tyari yu go na a grankownu.” ");
INSERT INTO srnNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Wantu dei na baka kownu Agripa nanga Bernisa kon na Sesarea fu taki granman Festus odi. ");
INSERT INTO srnNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Fu di den tan drape wan heri pisten, Festus taki a tori fu Paulus nanga a kownu. A taigi en taki: “Di Feliks gwe, a libi wan man ini a straf'oso na baka. ");
INSERT INTO srnNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Di mi go na Yerusalem, den prenspari domri nanga den fesiman fu den Dyu kon kragi a man dati na mi èn den aksi mi fu leisi strafu gi en. ");
INSERT INTO srnNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ma mi piki den tak' Romeinisma no abi a gwenti fu gi wan sma abra na trawan soso fu du den wan bun. A sma mus tnapu fosi fesi den wan di e kragi en fu kisi a okasi fu sori den tak' a no du a sani. ");
INSERT INTO srnNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Di den man di ben kragi en kon dyaso nanga mi, mi no lasi ten. A tra dei fu en mi hori krutu èn mi komanderi den fu tyari a man kon. ");
INSERT INTO srnNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ma den man di ben opo fu kragi en, no tyari no wan fu den ogri sani kon na fesi di mi ben ferwakti. ");
INSERT INTO srnNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ma na agri den no ben e agri nanga son sani fu a bribi fu den, nanga fu wan man Yesus di dede. Ma Paulus feni tak' A e libi. ");
INSERT INTO srnNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Fu di mi no ben sabi san mi mus du nanga a tori disi, meki mi aksi en efu a wani go na Yerusalem fu a krutu hori drape. ");
INSERT INTO srnNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ma Paulus teki a besroiti fu tan na straf'oso te leki a grankownu koti a krutu. So mi komanderi den fu hori en na straf'oso te leki mi feni a okasi fu seni en go na a grankownu.” ");
INSERT INTO srnNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Dan kownu Agripa taigi Festus taki: “Mi srefi sa wani yere san a abi fu taki.” Festus piki en taki: “Tamara yu sa yere.” ");
INSERT INTO srnNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","A tamara fu en Agripa nanga Bernisa kon nanga bigi prodo ini a presi pe den e hori krutu. Den srudati edeman nanga den moro prenspari man fu a foto ben de nanga den. Dan Festus taigi den fu tyari Paulus kon. ");
INSERT INTO srnNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Di Paulus doro, Festus taki: “Kownu Agripa nanga ala tra sma dyaso, disi na a man di ala den Dyusma fu Yerusalem nanga fu a foto dyaso kon kragi na mi. Den bari tak' a man disi no mus tan na libi. ");
INSERT INTO srnNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ma mi kon si tak' a no du no wan sani fu wi kiri en. Èn fu di a aksi fu a grankownu koti krutu gi en, meki mi teki a besroiti fu seni en go. ");
INSERT INTO srnNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ma mi no abi no wan spesrutu sani fu skrifi a grankownu abra en. Fu dat'ede mi tyari en kon na un fesi, èn spesrutu na yu fesi, kownu Agripa. Te yu kba ondrosuku a tori, dan mi sa abi wan sani fu skrifi. ");
INSERT INTO srnNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Bika mi feni tak' a no fiti fu seni wan straf'man gwe, sondro fu skrifi san nanga san a du.” ");
INSERT INTO srnNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa taigi Paulus taki: “Yu abi a okasi now fu sori tak' yu no fowtu.” Ne Paulus opo en anu dan a taki: ");
INSERT INTO srnNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kownu Agripa, mi breiti tak' mi kan tnapu tide na yu fesi fu sori tak' ala den sani fu san den Dyusma e kragi mi, no tru. ");
INSERT INTO srnNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Bika yu sabi ala den gwenti fu den Dyusma nanga den sani pe den no man feni densrefi. Fu dat'ede mi e begi yu fu arki mi nanga pasensi. ");
INSERT INTO srnNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ala den Dyusma sabi fa mi ben libi na mindri fu mi eigi pipel di mi ben yongu, nanga fa mi ben libi ini Yerusalem. ");
INSERT INTO srnNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Den sabi mi bun langa kba. Efu den wani, den srefi kan taki tak' mi ben de fu a grupu fu den Fariseiman. Fu ala den Dyu, den man dati e hori a wèt tapu a moro tranga fasi. ");
INSERT INTO srnNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Now mi e tnapu dya na fesi krutu fu di mi abi a howpu tak' Gado o du san a pramisi den afo fu wi. ");
INSERT INTO srnNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Den twarfu lo fu wi pipel e tan dini Gado dei nanga neti fu di den e howpu a srefi sani tu. Mi kownu, na fu a howpu disi den Dyusma tyari mi kon kragi. ");
INSERT INTO srnNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Fu sanede un no man bribi tak' Gado kan meki dedesma kon na libi baka? ");
INSERT INTO srnNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mi fu mi sei ben prakseri tak' mi mus meki ala muiti fu feti Yesus fu Nasaret. ");
INSERT INTO srnNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Na dati mi ben du tu ini Yerusalem. Nanga a makti di mi ben kisi fu den prenspari domri, mi poti furu fu den sma fu Gado na straf'oso. Èn te den ben kiri den, mi ben taki tak' a bun. ");
INSERT INTO srnNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ini ala den Dyukerki mi ben e fon den bribisma. Tapu sowan fasi mi ben e pruberi fu meki den drai den baka gi Yesus. Nanga bigi atibron mi ben de na den baka fu du den ogri te na den dorosei foto srefi. ");
INSERT INTO srnNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Na dati mi ben e du tu a leisi di mi go na Damaskus. Den prenspari domri ben seni mi go èn den ben gi mi a makti fu grabu den bribisma. ");
INSERT INTO srnNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mi kownu, di mi ben de na pasi, bigibigi brekten, mi si wan faya di ben krin moro a son. A fadon fu heimel kon na tapu mi nanga den sma di ben de nanga mi. ");
INSERT INTO srnNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Wi alamala fadon na gron. Dan mi yere wan sten aksi mi na ini Dyutongo taki: ‘Saul, Saul, fu sanede yu de na Mi baka fu du Mi ogri? Yu e du yusrefi, leki te wan kaw e skopu a tiki fu en masra nanga en baka futu.’ ");
INSERT INTO srnNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Dan mi aksi taki: ‘Masra, suma na Yu?’ Masra piki mi taki: ‘Mi na Yesus, di yu e du ogri. ");
INSERT INTO srnNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ma opo tnapu na tapu yu futu, bika Mi sori Misrefi na yu fu di Mi teki yu leki Mi wrokoman. Yu mus ferteri sma den sani san yu si tide èn san Mi o sori yu ete. ");
INSERT INTO srnNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mi sa puru yu na anu fu den Dyusma nanga den sma di no de Dyu, pe Mi o seni yu go. ");
INSERT INTO srnNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Yu sa opo den ai, fu den drai den libi kmopo fu a dungru kon ini a leti, èn fu kmopo ondro a makti fu Satan kon na Gado. Dan den sa kisi pardon fu den sondu, èn den o kon mindri den sma fu Gado fu di den bribi ini Mi.’ ");
INSERT INTO srnNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kownu Agripa, fu dat'ede mi no tranga mi yesi gi san Masra ben sori mi kmopo fu heimel. ");
INSERT INTO srnNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mi go fosi na Damaskus. Dan mi go na Yerusalem nanga heri Yudea, èn na den sma di no de Dyu. Mi taigi den tak' den mus drai den libi kon na Gado, èn tak' den mus du sani san e sori tak' den drai den libi trutru. ");
INSERT INTO srnNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Na fu den sani disi den Dyusma grabu mi ini a mamakerki, èn den suku fu kiri mi. ");
INSERT INTO srnNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ma Gado yepi mi te leki a dei fu tide. So mi tnapu dyaso e ferteri bigiwan nanga pikinwan noti moro leki san Moses nanga den profeiti ben taki tak' o psa. ");
INSERT INTO srnNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Den ben taki tak' a Mesias o nyan pina, èn tak' A o de a fosi sma di o opo baka na dede, fu tyari leti kon gi en eigi pipel nanga den sma di no de Dyu.” ");
INSERT INTO srnNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ma ini a taki di Paulus e taki fu sori tak' a no fowtu, Festus bari taki: “Paulus, na lawlaw sani yu e taki! Yu leri so furu tak' yu lasi yu ferstan.” ");
INSERT INTO srnNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ma Paulus taigi en taki: “Mi lespeki Festus, a no lawlaw sani mi e taki. Mi de bun na mi ferstan. Mi e taki sani di tru. ");
INSERT INTO srnNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Fu di kownu sabi fu san mi e taki, meki mi e taki sondro frede nanga en. Mi sabi tak' a sabi den sani disi heri bun, bika den no psa na wan bakabini.” ");
INSERT INTO srnNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Dan Paulus aksi kownu Agripa taki: “Kownu Agripa, yu e bribi san den profeiti taki? Mi sabi tak' yu e bribi den!” ");
INSERT INTO srnNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ma kownu Agripa piki en taki: “Yu prakseri tak' na so esi yu kan meki mi tron wan Kristensma?” ");
INSERT INTO srnNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulus piki en taki: “Mi kownu, mi no sabi efu na her'esi noso baka wan pisten, ma mi e begi Gado tak' yu nanga ala den trawan di yere mi tide sa kon leki mi, ma sondro den bui disi.” ");
INSERT INTO srnNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Dan kownu Agripa, granman Festus nanga Bernisa opo tnapu. Ala den tra sma di kon nanga den opo tu. ");
INSERT INTO srnNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Di den kmopo drape, den taigi makandra taki: “A man disi no du noti fu a dede noso fu a kisi strafu.” ");
INSERT INTO srnNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Dan kownu Agripa taigi Festus taki: “Un ben kan lusu a man disi efu a no ben aksi fu a grankownu krutu a tori fu en.” ");
INSERT INTO srnNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Di den teki a besroiti fu seni un go nanga sipi na Italiakondre, den gi wan ofisiri di ben nen Yulius a frantwortu abra Paulus nanga wantu tra straf'man. Yulius ben de wan ofisiri ini a grupu srudati di den ben kari: A Grupu fu a Grankownu. ");
INSERT INTO srnNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Dan so wi go ini wan sipi fu Adramitium di bo go na den lanpresi ini a distrikti Asia. Di wi e gwe, Aristarkus kon nanga wi. A ben de wan man fu a foto Tesalonika ini Masedonia. ");
INSERT INTO srnNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","A tra dei wi doro na a foto Sidon èn Yulius ben de so bun fu gi Paulus okasi fu a go luku den mati fu en fu den sorgu gi en. ");
INSERT INTO srnNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Di wi kmopo fu drape, a winti ben wai kon na a sipi tapu. Fu dat'ede wi seiri psa krosbei fu a eilanti Siprus. ");
INSERT INTO srnNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Na ini a birti fu Silisia nanga Pamfilia, wi koti a se abra go na a foto Mira ini Lisia. ");
INSERT INTO srnNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Drape a ofisiri feni wan sipi fu Aleksandria di bo go na Italiakondre. So a meki un go ini a sipi dati. ");
INSERT INTO srnNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Wan heri pisten un ben e go safrisafri nomo èn nanga furu muiti un ben man doro ini a birti fu Knidus. Èn fu di a winti ben e wai tranga kon na wi tapu, un seiri go na a zuidsei fu a eilanti Kreta, dan un psa a presi di den e kari Salmone. ");
INSERT INTO srnNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Di un psa Salmone nanga furu muiti, un doro wan presi di den e kari Bun Ankra Presi, krosbei fu a foto Lasea. ");
INSERT INTO srnNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Un ben lasi furu ten kba èn a no ben de wan bun ten moro fu de nanga sipi tapu se, bika a ten pe den Dyu e faste ben psa kba. Fu dat'ede Paulus warskow den taki: ");
INSERT INTO srnNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Brada, mi e si tak' un kan kisi bigi problema efu un kmopo dyaso fu go moro fara. A kan tak' un lasi a sipi nanga den lai, ma a kan tu tak' un lasi un libi srefi.” ");
INSERT INTO srnNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ma a ofisiri ben fertrow a kapten nanga a man di ben tyari a sipi moro leki Paulus. ");
INSERT INTO srnNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Fu di a lanpresi pe den ben de no ben bun fu psa a kowruten, meki moro furu fu den man gi a rai fu kmopo drape go moro fara. Den ben wani meki muiti fu doro na Feniks fu psa a kowruten drape. Feniks ben de wan lanpresi na Kreta èn wan sipi ben kan doro drape fu zuidwest nanga fu noordwest sei. ");
INSERT INTO srnNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Di a winti bigin wai safri kmopo fu zuidsei, den man prakseri tak' den bo man kisi san den ben wani. So den lusu a ankra èn den seiri krosbei fu a syoro fu Kreta. ");
INSERT INTO srnNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ma no langa baka di den lusu, wan bun hebi winti bigin wai di den ben kari a Noordoost Winti. ");
INSERT INTO srnNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","A winti dati bigin hari a sipi e tyari gwe, èn fu di un no ben man drai a sipi, meki un libi en gi a winti. ");
INSERT INTO srnNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Di un doro na a pikin eilanti Klauda na a sei pe a winti no ben wai so tranga, un ben abi furu muiti ete fu un no lasi a pikin boto. ");
INSERT INTO srnNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","So den hari en kon ini a sipi. Dan den meki titei waka ondro a sipi kon na loktu fu tai den planga fu en hori na wan. Baka dati den saka den seiri fu a watra tyari a sipi, bika den ben frede tak' a sipi ben kan fasi tapu den santi-bangi fu Sirta. ");
INSERT INTO srnNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","A winti ben e rigeri srefsrefi. Dat' meki a tamara fu en den bigin trowe den lai go ini a se. ");
INSERT INTO srnNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A di fu dri dei den srefi trowe sani fu a sipi, soleki seiri nanga titei. ");
INSERT INTO srnNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Wan lo dei son noso stari no ben de fu si èn a winti ben tan wai tranga. Te fu kba un no ben abi howpu moro tak' un bo feni yepi. ");
INSERT INTO srnNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Someni dei langa den man no ben nyan. Dan Paulus go tnapu na den mindri èn a taigi den taki: “Brada, efu un ben arki mi fu no seiri kmopo fu Kreta, dan den problema disi no ben miti unu èn un no ben lasi den sani. ");
INSERT INTO srnNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ma mi e begi unu now fu no lasi ati, bika no wan fu unu o lasi un libi. A sipi wawan o lasi. ");
INSERT INTO srnNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mi na fu Gado èn mi e dini En. A neti di psa wan engel fu En kon na mi, ");
INSERT INTO srnNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","dan a taigi mi taki: ‘Paulus, yu no abi fu frede, bika yu mus tnapu fesi a grankownu. Luku, fu yu ede Gado sa kibri a libi fu ala den sma di de ini a sipi nanga yu.’ ");
INSERT INTO srnNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Brada, dat' meki un no mus lasi ati, bika mi e bribi Gado. Ala sani sa waka leki fa A seni taigi mi. ");
INSERT INTO srnNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ma a sipi o go fasi na tapu wan eilanti.” ");
INSERT INTO srnNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","A ben de tin-na-fo dei kba di un ben lasi pasi tapu a se fu Adria. Dan mindrineti so den sipiman ben kisi a firi tak' un de krosbei fu wan syoro. ");
INSERT INTO srnNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Dat' meki den saka wan pisi loto na wan titei go ini a watra fu marki o dipi a se ben de drape. Den marki tak' a watra ben dipi dritenti-na-siksi (36) meter. Pikinso moro fara den marki tutenti-na-seibi (27) meter. ");
INSERT INTO srnNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Dan den bigin frede tak' a sipi o naki panya na den bigi ston ini a watra. Fu dat'ede den saka fo ankra na bakasei fu a sipi go ini a watra. Dan den bigin begi fu dei broko. ");
INSERT INTO srnNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ma den sipiman ben wani lowe kmopo fu a sipi. Den saka a pikin boto ini se dan den du leki den bo go saka ankra na fes'sei fu a sipi. ");
INSERT INTO srnNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ne Paulus taigi a ofisiri nanga den srudati taki: “Efu den man disi no tan ini a sipi, un no o tan na libi.” ");
INSERT INTO srnNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","So den srudati kapu den titei fu a pikin boto, meki a fadon go ini se. ");
INSERT INTO srnNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pikinso fosi dei broko Paulus taigi den alamala tak' den mus nyan. A taigi den taki: “Na tin-na-fo dei kba di un e sidon e wakti nomo sondro fu un nyan wan sani. ");
INSERT INTO srnNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ma mi e taigi unu fu un nyan, bika un abi en fanowdu fu tan na libi. Not'noti sa psa nanga no wan fu unu.” ");
INSERT INTO srnNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Di Paulus taki so, en srefi teki brede èn a taki Gado tangi let' fesi den alamala. Dan a broko en èn a bigin nyan. ");
INSERT INTO srnNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ala den man kisi dek'ati èn den bigin nyan tu. ");
INSERT INTO srnNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wi ben de nanga tu hondro nanga seibitenti-na-siksi (276) sma tapu a sipi. ");
INSERT INTO srnNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Baka di den nyan te den bere furu, den trowe a aleisi go ini se fu a sipi kon moro lekti. ");
INSERT INTO srnNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Di dei broko den si a syoro, ma den no ben sabi na sortu kondre den de. Dan den si wan presi pe santi ben de. So den teki a besroiti fu tyari a sipi go na syoro drape efu a ben man. ");
INSERT INTO srnNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Den kapu den titei, libi den ankra ini a watra. Den lusu den titei nanga san den ben tai a stuur, dan den opo a fes'sei seiri baka fu a winti tyari a sipi go na a syoro. ");
INSERT INTO srnNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ma a sipi kon fasi tapu wan santi-bangi. A fesi pisi no ben man beweigi srefsrefi moro, èn den tranga skwala naki a bakasei pisi broko. ");
INSERT INTO srnNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Den srudati ben wani kiri ala den straf'man fu no wan fu den swen gwe. ");
INSERT INTO srnNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ma a ofisiri no meki den du dati fu di a ben wani tak' Paulus mus tan na libi. Dan a komanderi den tak' den sma di sabi swen ben mus dyompo fosi fu swen go na syoro. ");
INSERT INTO srnNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Den tra sma ben mus teki planga noso tra pis'pisi fu a sipi fu doro syoro. Na so den alamala doro bun na syoro. ");
INSERT INTO srnNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Baka di un doro bun na syoro, un kisi fu yere tak' a eilanti nen Malta. ");
INSERT INTO srnNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Den sma fu drape ben bun srefsrefi gi unu. Den meki wan bigi faya dan den kari un alamala kon sidon lontu en, fu di alen ben fadon èn a ben kowru. ");
INSERT INTO srnNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulus piki wan bosu drei taki. Di a poti en ini a faya, wan takru sneki kmopo mindri den taki di a firi a faya, dan a beti Paulus na en anu. ");
INSERT INTO srnNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Di den sma fu drape si a sneki fasi na Paulus anu, den taigi makandra taki: “A man disi mus de wan kiriman. A no dede ini a watra, ma a gado di e sorgu tak' ala sma kisi den paiman, no wani fu a tan na libi.” ");
INSERT INTO srnNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ma Paulus seki a sneki trowe ini a faya sondro tak' wan sani psa nanga en. ");
INSERT INTO srnNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Den sma ben ferwakti tak' Paulus skin bo sweri, noso tak' iniwan momenti a bo fadon dede. Ma di den wakti wan heri pisten èn den si tak' noti no psa nanga en, den kenki prakseri. Dan den taki tak' Paulus mus de wan gado. ");
INSERT INTO srnNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","A granman fu a eilanti, di ben nen Publius, ben abi wan pisi gron ini a kontren drape. A teki unu nanga opo anu ini en oso èn a sorgu dri dei langa gi unu. ");
INSERT INTO srnNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","A srefi ten dati a p'pa fu Publius ben didon na bedi nanga hebi korsu nanga wan takru wrokobere. Paulus go na a man disi. A begi gi en, a poti en anu na en tapu, dan a man kon betre. ");
INSERT INTO srnNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Di a sani disi psa, den tra sikisma fu a eilanti kon na Paulus èn a dresi den alamala. ");
INSERT INTO srnNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Den sma gi un furu grani nanga lespeki, èn di wi bo seiri gwe baka, den gi un ala sani san un ben abi fanowdu. ");
INSERT INTO srnNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Baka dri mun wi gwe moro fara nanga wan sipi di ben psa a kowruten drape. A sipi dati ben de fu Aleksandria èn a ben tyari a popki fu a twelengi gado leki marki na a ede fu a sipi. ");
INSERT INTO srnNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Di wi doro na Sirakusa, wi tan dri dei drape. ");
INSERT INTO srnNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Fu drape wi seiri go moro fara, dan wi doro na Regium. A tamara fu en wan winti bigin wai kmopo fu zuidsei, èn a tra dei fu en wi doro na Puteoli. ");
INSERT INTO srnNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Drape wi miti wantu bribisma èn den aksi wi fu tan seibi dei nanga den. Baka dati wi go moro fara na Roma. ");
INSERT INTO srnNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Den bribisma fu Roma yere tak' wi e kon, so den waka kon miti unu te na a Wowoyo fu Api nanga a presi di den e kari Dri Oso. Di Paulus si den, a kisi dek'ati èn a taki Gado tangi. ");
INSERT INTO srnNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Di wi doro na Roma, Paulus kisi a primisi fu libi en wawan ini wan oso. Ma wan srudati ben e hori wakti gi en. ");
INSERT INTO srnNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Baka dri dei Paulus kari den fesiman fu den Dyusma drape kon makandra. Di den kon, a taigi den taki: “Brada, mi no du wi pipel no wan ogri, èn mi no broko den gwenti fu den afo fu wi tu. Ma den kondreman fu wi na Yerusalem grabu mi èn den gi mi abra ini anu fu den Romeinisma. ");
INSERT INTO srnNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Den sma dati aksi mi fin'fini san mi du, èn di den si tak' mi no du noti fu den kiri mi, den ben wani lusu mi. ");
INSERT INTO srnNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ma den Dyusma no ben wani a sani dati. So mi ben abi fu aksi meki a grankownu krutu a tori fu mi. Ma a no de so tak' na kragi mi kon kragi mi pipel. ");
INSERT INTO srnNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Fu dat'ede mi aksi fu miti nanga unu èn fu taki nanga unu. Bika den bui mi fu di mi abi a srefi howpu leki a pipel fu Israel.” ");
INSERT INTO srnNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Dan den taigi en taki: “Den brada fu Yudea no seni no wan brifi abra yu kon gi wi. No wan sma tyari wan boskopu kon dya fu yu èn no wan sma kon taki takru fu yu. ");
INSERT INTO srnNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ma un ben sa wani sabi san yu e bribi, bika ala presi sma e taki takru fu a grupu disi.” ");
INSERT INTO srnNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Dan den meki mofo fu miti wan tra dei. A dei dati moro sma ete kon na en oso. Dan Paulus taki nanga den fu mamanten te leki mofoneti fu a fasi fa Gado wani tiri libisma. A du muiti fu sori den kmopo fu a wèt fu Moses nanga den buku fu den profeiti, tak' san a taki fu Yesus tru. ");
INSERT INTO srnNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Sonwan fu den bribi san Paulus taki, ma trawan fu den no ben wani bribi. ");
INSERT INTO srnNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Di den no ben man feni densrefi, den opo gwe. Ma fosi den gwe Paulus taigi den taki: “A Santa Yeye ben abi leti di A meki a profeiti Yesaya taigi den afo fu unu taki: ");
INSERT INTO srnNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Go na a pipel disi èn taigi den taki: Yere un o yere, ma un no o ferstan noti, èn luku un o luku, ma un no o si noti. ");
INSERT INTO srnNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Bika a pipel disi trangayesi. Den no wani arki moro, èn den tapu den ai. Noso den bo si nanga den ai, den bo yere nanga den yesi, èn den bo ferstan nanga den ati tak' den mus drai den libi fu Mi kan dresi den. ");
INSERT INTO srnNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Fu dat'ede mi wani fu un sabi disi: Gado seni a boskopu disi gi den sma di no de Dyu, tak' A wani ferlusu libisma. Den dati o arki.” ");
INSERT INTO srnNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Di Paulus taki den sani dati, den Dyusma gwe, ma den ben e hari taki nanga makandra. ");
INSERT INTO srnNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulus tan tu yari langa ini a oso di a ben yuru èn a opo en gi ala sma di ben wani kon na en. ");
INSERT INTO srnNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Sondro frede èn sondro fu wan sma ben tapu en, a ben e ferteri sma fu a fasi fa Gado wani tiri libisma, èn a ben e leri den fu Masra Yesus Kristus.");
INSERT INTO srnNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Gi den sma fu Gado na Roma, Disi na wan brifi fu Paulus, wan knekti fu Kristus Yesus. A ben kari mi fu de wan boskopuman fu En, èn A poti mi aparti fu panya a Bun Nyunsu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Gado ben pramisi a Bun Nyunsu disi na fesi, di A meki den profeiti fu En skrifi en ini a Santa Buku. ");
INSERT INTO srnNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","A Bun Nyunsu disi e taki fu En Manpikin, wi Masra Yesus Kristus, di kon gebore leki libisma ini a famiri fu Kownu David. ");
INSERT INTO srnNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ma a Yeye fu En di santa, sori un krin tak' En na a Manpikin fu Gado fu di Gado meki A opo baka na dede. ");
INSERT INTO srnNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kristus meki tak' Gado sori wi En bun-ati èn A meki wi tron En boskopuman. Wi mus wroko ondro ala den folku, fu den kon bribi ini Gado èn du san A taki. Na so Kristus sa kisi bigi nen. ");
INSERT INTO srnNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Un srefi de ini a grupu sma disi, di Gado kari fu tron sma fu Yesus Kristus. ");
INSERT INTO srnNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Dat' meki mi e skrifi unu di de na Roma, un di Gado lobi èn di A kari fu de sma fu En. Mi e winsi tak' Gado wi P'pa, nanga Masra Yesus Kristus, sa sori un bun-ati èn gi un freide. ");
INSERT INTO srnNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Na a fosi presi mi e taki mi Gado tangi fu un alamala fu san Yesus Kristus du gi unu. Bika na heri grontapu, sma e taki fu a bribi fu unu. ");
INSERT INTO srnNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mi e dini Gado nanga mi heri ati fu panya a Bun Nyunsu fu En Manpikin. Na En na mi kotoigi tak' mi e tan prakseri unu ala leisi te mi e begi. ");
INSERT INTO srnNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mi e begi Gado tak' efu a de En wani, dan meki A gi mi wan okasi now fu kon na unu. ");
INSERT INTO srnNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Bika mi e angri fu si unu, fu prati wan presenti fu a Santa Yeye nanga unu fu gi un krakti. ");
INSERT INTO srnNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","San mi wani taki, na tak' wi kan kraka makandra. Mi e kraka unu nanga mi bribi èn unu e kraka mi nanga a bribi fu unu. ");
INSERT INTO srnNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Brada nanga sisa, mi wani fu un sabi tak' furu leisi mi ben prakseri fu kon na unu. Ma te leki now ala leisi wan sani ben kon na mindri. Mi wani si froktu na un mindri, leki fa mi e si en na den tra folku. ");
INSERT INTO srnNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Bika mi abi a frantwortu fu ferteri a Bun Nyunsu na den Grikisma nanga den sma di no de Griki. Sosrefi gi sma di kisi leri nanga sma di no kisi leri. ");
INSERT INTO srnNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Dat' meki mi e angri fu kon na unu na Roma, fu ferteri unu a Bun Nyunsu. ");
INSERT INTO srnNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mi no e syen gi a Bun Nyunsu, bika a de a krakti fu Gado fu ferlusu ala sma di e bribi. A de gi den Dyu fosi, ma a de tu gi den sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","A Bun Nyunsu e sori unu fa un kan kon bun ini Gado ai. A sani disi e bigin èn a e kba nanga bribi. Bika a skrifi taki: “A sma di bun ini Gado ai, sa libi fu di a bribi.” ");
INSERT INTO srnNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","A atibron fu Gado e kmoto fu heimel kon na tapu ala sma di no e teri En èn di no e libi soleki fa A wani. A fasi fa den e libi e meki tak' den tru sani fu Gado no de fu si gi tra sma. ");
INSERT INTO srnNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Bika san den ben kan sabi fu Gado de krin fu si, bika Gado srefi tyari en kon na krin gi den. ");
INSERT INTO srnNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","A tru tak' nanga un ai un no man si a têgo makti fu Gado nanga En Gadofasi. Ma sensi di grontapu meki, un man ferstan den sani disi te un e luku den sani san A meki. Dat' meki den no man taki tak' den no ben sabi moro betre. ");
INSERT INTO srnNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bika nanga aladi den sabi Gado, den no gi En grani leki Gado, èn den no taki En tangi. Den abi den eigi denki fu Gado. Den no abi ferstan èn den ati kon dungru. ");
INSERT INTO srnNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Den e prakseri tak' den koni, ma den don. ");
INSERT INTO srnNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bika prefu den dini a bigi Gado di no e dede, den go dini popki di gersi libisma di e dede gwe. Den go dini popki di gersi fowru di e frei na loktu, meti di e waka tapu fo futu, nanga meti di e kroipi. ");
INSERT INTO srnNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Dat' meki Gado gi den abra na den takru lostu fu den ati, fu den du ala sortu sani di no fiti nanga makandra skin. ");
INSERT INTO srnNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Den kenki den tru sani fu Gado gi a lei. Den e gi grani na den sani san Gado meki èn den e dini den, prefu den dini Gado di meki ala sani. Meki wi opo a nen fu Gado fu têgo! Amen. ");
INSERT INTO srnNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Dat' meki Gado libi den meki den du den syensyen sani di den lostu fu du. Den frow no e go na bedi nanga wan man, soleki fa Gado poti en, ma den e go na bedi nanga densrefi. ");
INSERT INTO srnNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","A de a srefi nanga den mansma. Den no wani go nanga wan frow na bedi, ma den e lostu densrefi fayafaya. Mansma e go na bedi nanga mansma. Dan so den e kisi a strafu ini den skin di fiti a ogri san den e du. ");
INSERT INTO srnNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Fu di den no feni en fanowdu fu teri Gado, meki A libi den fu den prakseri sani san no abi no wan warti, èn meki den du sani san no fiti. ");
INSERT INTO srnNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Den lai nanga kruktudu. Den abi ogri ati, bigi-ai nanga takru fasi. Den e dyarusu, den e kiri, den e meki trobi, den e bedrigi, soso ogri de ini den, èn den e konkru sma tori. ");
INSERT INTO srnNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Den e taki takru fu trawan èn den no wani sabi noti fu Gado. Den no abi no wan dropu lespeki, den abi bigifasi èn den lobi taki bigitaki. Den e feni nyun fasi fu du ogri, èn den no e arki den m'ma nanga den p'pa. ");
INSERT INTO srnNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Den e du lawlaw sani, yu no kan fertrow den, èn den no abi no wan dropu lobi noso sari-ati gi trawan. ");
INSERT INTO srnNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Den e du den sani disi aladi den sabi tak' Gado o strafu den sma di e du den sani disi. Ma a no dati wawan. Den e prisiri tu nanga tra sma di e du den tu. ");
INSERT INTO srnNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Brada, yu kan krutu den sma di e du den sani disi, ma awinsi suma na yu, yu no moro betre. Bika te yu e krutu wan trawan, yu e krutu yusrefi, bika yu e du den srefi sani. ");
INSERT INTO srnNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Wi sabi tak' Gado abi leti te A e krutu den sma di e du den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Brada, yu denki tak' Gado o krutu den sma di du den sani disi, ma dan A no o krutu yu di e du den srefi sani tu? ");
INSERT INTO srnNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Na span yu no e span tak' Gado bun so gi yu, tak' A abi langa pasensi èn tak' na wani A no wani strafu yu wantron? Na sabi yu no sabi tak' Gado bun gi yu fu di A wani tak' yu mus drai yu libi? ");
INSERT INTO srnNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ma fu di yu trangayesi èn yu no wani drai yu libi, yu e meki tak' a strafu fu yu o kon moro hebi tapu a dei di Gado o krutu èn strafu libisma soleki fa a fiti. ");
INSERT INTO srnNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Bika Gado o pai ala sma fu den sani san den du. ");
INSERT INTO srnNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","A o gi a libi fu têgo na den sma di e tan hori doro fu du bun, fu di den wani meki Gado gi den grani, bigi nen nanga a libi pe dede no de. ");
INSERT INTO srnNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ma Gado o puru En atibron tapu den sma di e prakseri densrefi nomo, di no wani arki den tru sani, èn di e du ogri. ");
INSERT INTO srnNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ala libisma di e du ogri mus sabi tak' pina nanga benawtu e wakti den. A de gi den Dyu fosi, ma a de tu gi den sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ma grani, bigi nen, nanga freide e wakti ala sma di e du bun. A de gi den Dyu fosi, ma a de tu gi den sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Bika ala sma na a srefi gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Den sma di no de ondro a wèt fu Moses, o go lasi sondro a wèt te den sondu. Èn ala sma di de ondro a wèt, Gado o teki a wèt fu krutu den. ");
INSERT INTO srnNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Bika a no den sma di e arki a wèt e kon bun ini Gado ai, ma na den sma di e du san a wèt e taki. ");
INSERT INTO srnNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Den sma di no de Dyu no abi a wèt fu Moses. Ma efu den e du san a wèt e taki, aladi den no abi wèt, dan den de wan wèt gi densrefi. ");
INSERT INTO srnNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Nanga dati den e sori tak' den sani san skrifi ini a wèt, de na ini den ati. Den konsensi e sori tak' na so a de, èn a e taigi den efu den e du bun noso ogri. ");
INSERT INTO srnNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Na so a o de tapu a dei di Gado o meki Kristus Yesus krutu ala kibrisani fu libisma. Disi e agri nanga a Bun Nyunsu san mi e preiki. ");
INSERT INTO srnNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ma fa fu unu di e kari unsrefi Dyu? Un e bribi tak' Gado o ferlusu unu fu di un e hori a wèt, èn un e meki bigi tak' un de fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Un sabi san Gado wani, èn un sabi san na a moro bun sani fu du fu di un kisi leri kmopo fu a wèt. ");
INSERT INTO srnNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Un e bribi tak' un na sma di mus sori breniwan a pasi fu Gado, èn tak' un de leki wan faya gi den sma di de na dungru. ");
INSERT INTO srnNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Un e bribi tak' ini a wèt un e feni sabi nanga sani san de tru. Dat' meki un e si unsrefi leki sma di mus leri trawan di no abi ferstan èn leki sma di mus skoro pikin. ");
INSERT INTO srnNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ma fa a kan tak' un e leri trawan, ma un no e leri unsrefi? Un e taigi sma tak' den no mus fufuru, ma un srefi e fufuru. ");
INSERT INTO srnNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Un e taigi sma tak' den no mus huru, ma un srefi e du en. Unu nanga kruktu gado no e koti, ma un e go fufuru sani ini den tempel fu den. ");
INSERT INTO srnNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Un e meki bigi tak' un abi a wèt, ma un e gi Gado syen fu di un no e hori a wèt. ");
INSERT INTO srnNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","A skrifi taki: “Na unu e meki tak' sma di no de Dyu e afrontu Gado.” ");
INSERT INTO srnNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Meki mi taigi unu wan sani. A besnei di un besnei, abi warti soso efu un e hori a wèt. Ma efu un no e du san a wèt e taki, dan un leki Dyu di besnei, de a srefi leki sma di no de Dyu, di no besnei. ");
INSERT INTO srnNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ma efu wan sma di no besnei e libi leki fa a wèt e taki, dan Gado e si sowan sma leki wan sma di besnei. ");
INSERT INTO srnNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Dat' meki den sma di no besnei, ma di e du san a wèt e taki, o krutu unu. Bika awinsi un besnei èn un abi a wèt na tapu papira, toku un e sondu. ");
INSERT INTO srnNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","A no te yu gebore leki Dyu, noso fu di yu besnei, e meki tak' yu na wan trutru Dyu. ");
INSERT INTO srnNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Fu besnei trutru a no te den e koti yu skin nomo, ma te yu ati kenki. Na dati e meki tak' yu na wan trutru Dyu. A no a wèt e du dati, ma na a Yeye fu Gado. Dan a no libisma o gi yu grani, ma na Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Sortu wini un abi dan fu di un na Dyu, èn sortu warti a abi fu besnei? ");
INSERT INTO srnNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","A abi bun furu warti. Ini a fosi presi Gado ben gi den Dyu a boskopu fu En. ");
INSERT INTO srnNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ma efu wantu sma no ben du san Gado taki, dan yu wani taigi mi tak' Gado no o du san En e taki? ");
INSERT INTO srnNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kwet'kweti! Awinsi ala sma e lei, Gado no e lei. A de soleki fa a skrifi taki: A o de fu si tak' Yu abi leti, èn Yu o wini te den e krutu Yu. ");
INSERT INTO srnNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ma efu a sondufasi fu wi e meki sma si moro krin tak' Gado abi leti, san un sa taki dan? Leki libisma un kan taki tak' Gado no e du sani nanga leti fu puru En atibron na un tapu. Ma un kan taki dati? ");
INSERT INTO srnNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kwet'kweti! Bika efu Gado no e du sani nanga leti, dan fa A sa man krutu grontapu dan? ");
INSERT INTO srnNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Èn efu a leifasi fu mi e tyari kon na krin tak' Gado de fu fertrow, èn tak' sowan fasi A e kisi moro grani, dan fu sanede Gado e strafu mi leki wan sondusma? ");
INSERT INTO srnNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Dan betre yu taki: “We, efu wan ogri e tyari wan bun, kon un du ogri dan!” Son sma e gi wi a pori nen tak' na dati wi e leri. Ma a strafu san den o kisi, fiti den. ");
INSERT INTO srnNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Fa a sani de dan? A tru tak' wi leki Dyu betre moro den tra sma? Kwet'kweti! Bika wi ben sori kba tak' ala sma sondu, Dyusma nanga sma di no de Dyu. ");
INSERT INTO srnNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","A de soleki fa a skrifi taki: No wan sma no bun ini Gado ai, no wan enkri sma srefi. ");
INSERT INTO srnNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","No wan sma abi ferstan, èn no wan sma e suku Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Den alamala go waka den eigi pasi, èn no wan fu den no bun fu noti moro. No wan no de di e du bun, no wan enkri wan. ");
INSERT INTO srnNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Den gorogoro de leki wan opo grebi, èn den tongo e taki soso lei. Den mofobuba e kiri yu leki te wan takru sneki beti yu. ");
INSERT INTO srnNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Den mofo furu nanga fluku èn nanga hati sani. ");
INSERT INTO srnNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Den futu e lon es'esi fu go kiri, ");
INSERT INTO srnNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","èn ala pe den e go den e pori sani èn den e libi sari na baka. ");
INSERT INTO srnNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Den no sabi san na freide, ");
INSERT INTO srnNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","èn den no abi lespeki gi Gado srefsrefi. ");
INSERT INTO srnNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Wi sabi tak' ala sani san a wèt e taki, de gi den sma di ben libi ondro a wèt. Dan no wan sma o man abi wan sani fu taki, èn heri grontapu sa kon ondro a krutu fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Dat' meki no wan sma e kon bun ini Gado ai nomo fu di a du san a wèt e taki. Bika a wèt e meki wi kon sabi tak' wi sondu. ");
INSERT INTO srnNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ma now, Gado meki un kon si tak' A e meki sma kon bun ini En ai sondro a wèt. A Wèt nanga den Profeiti ben taki fu a sani disi. ");
INSERT INTO srnNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Wi e kon bun ini Gado ai te wi bribi ini Yesus Kristus. Disi e teri gi ala sma di e bribi. A no abi trobi suma yu de. ");
INSERT INTO srnNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Bika ala sma sondu èn den no abi a fosi glori fu Gado moro. ");
INSERT INTO srnNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ma di Kristus Yesus ferlusu wi, A meki wi kon bun ini Gado ai. Na En bun-ati meki A du dati. Wi no ben abi fu du noti. ");
INSERT INTO srnNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Gado seni Yesus kon fu meki wi kon bun baka nanga En, te wi bribi tak' Yesus pai fu wi sondu nanga En brudu. Na so Gado sori tak' A e du sani tapu wan leti fasi. Bika A no e luku den sondu fu a ten di de na un baka, ma A ben hori langa pasensi. ");
INSERT INTO srnNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ini a ten disi A e sori un baka tak' A e du sani nanga leti. So A e sori wi tak' A bun, èn tak' A e meki den sma kon bun ini En ai di e bribi ini Yesus. ");
INSERT INTO srnNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Dat' meki un no man meki bigi srefsrefi. Fu san ede? Fu di wi du san a wèt e taki? Nono, ma na fu di un bribi. ");
INSERT INTO srnNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Bika wi e bribi tak' wan sma no e kon bun ini Gado ai fu di a e du san a wèt e taki, ma fu di a e bribi. ");
INSERT INTO srnNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","San un e prakseri? Un prakseri tak' Gado na a Gado fu den Dyu wawan, èn tak' A no de a Gado fu den tra folku tu? Meki mi taigi yu tak' Gado na a Gado fu den tra folku tu. ");
INSERT INTO srnNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Bika na wan Gado nomo de di e meki Dyu nanga sma di no de Dyu kon bun ini En ai te den bribi. ");
INSERT INTO srnNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yu denki tak' a bribi disi e meki tak' a wèt no e teri moro? Kwet'kweti! Bika soso te yu e bribi, yu o man hori a wèt. ");
INSERT INTO srnNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","San wi leki Dyu mus taki fu wi afo Abraham dan? ");
INSERT INTO srnNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Efu Abraham ben du wan sani fu kon bun ini Gado ai, dan a ben kan meki bigi. Ma na Gado a no ben abi no wan sani fu a ben kan meki bigi. ");
INSERT INTO srnNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Bika a skrifi ini a Santa Buku taki: “Fu di Abraham bribi Gado, meki Gado si en leki wan sma di bun ini En ai.” ");
INSERT INTO srnNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Wan sma di wroko e kisi pai fu di a wroko fu en. Den no e pai en fu di den wani sori en den bun-ati. ");
INSERT INTO srnNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ma efu wan sma poti en fertrow tapu Gado di e meki sondusma kon bun nanga En, dan Gado e si sowan sma leki wan sma di bun ini En ai. Bika a sma dati no du noti nanga en eigi krakti. ");
INSERT INTO srnNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","David ben taki a srefi sani. A taki tak' blesi de tapu a sma di Gado e si leki wan sma di bun ini En ai, sondro fu a du wan sani. ");
INSERT INTO srnNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","A skrifi taki: Blesi de tapu den sma di kisi pardon fu den ogri di den du, nanga den sma di Gado no e luku den sondu fu den moro. ");
INSERT INTO srnNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Blesi de tapu a sma di Masra no e teri den sondu fu en moro. ");
INSERT INTO srnNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Un taigi mi now: Gi suma a blesi disi de? Soso gi den sma di besnei, noso gi den sma di no besnei tu? Bika wi e taki fu Abraham tak' fu di a bribi meki Gado si en leki wan sma di bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ma oten a sani disi psa? Fosi Abraham besnei, noso bakaten? A psa fosi a ben besnei. ");
INSERT INTO srnNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abraham ben kisi a kotimarki disi bakaten leki wan stampu tak' a kon bun ini Gado ai, fu di a ben bribi Gado di a no ben abi a kotimarki ete. Tapu a fasi disi Abraham tron a afo fu ala sma di e bribi, awinsi den no besnei. Dan Gado e si den leki sma di bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abraham tron a afo tu fu ala sma di besnei. Ma den no mus besnei wawan, den mus abi a srefi bribi tu di wi afo Abraham ben abi fosi a ben besnei. ");
INSERT INTO srnNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","A no fu di Abraham ben hori a wèt meki Gado pramisi en nanga den bakapikin fu en tak' den o kisi a grontapu disi. Ma fu di a ben bribi meki Gado si en leki wan sma di bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Bika efu wi kan kisi wan sani fu Gado nomo fu di wi e hori a wèt, dan bribi no abi warti, èn dan a pramisi na wan soso sani. ");
INSERT INTO srnNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Bika a wèt e tyari a atibron fu Gado kon. Ma pe wèt no de, un no kan broko en tu. ");
INSERT INTO srnNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Dat' meki fu di wi e bribi, meki Gado gi wi a pramisi fu sori wi En bun-ati, èn a pramisi e teri gi ala den bakapikin tu. A no de gi den sma wawan di e hori a wèt, ma a de gi den sma tu di e bribi leki fa Abraham ben e bribi. Bika Abraham na a p'pa fu wi alamala. ");
INSERT INTO srnNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Bika a skrifi taki: “Mi meki yu tron a p'pa fu furu folku.” Ini a ai fu Gado, Abraham de dati tu, èn ini a Gado disi a ben e bribi. Gado na a Wan di e meki dedewan kon baka na libi, èn na En e meki san no ben de, kon de. ");
INSERT INTO srnNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Gado ben taigi Abraham tak' a bo kisi furu bakapikin, èn aladi ala sani ben e sori kba tak' a no bo man tron a p'pa fu furu folku, a tan bribi èn a no lasi howpu. ");
INSERT INTO srnNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraham ben si tak' a owru tumsi fu kisi wan pikin, bika a ben e suku fu tapu wan hondro yari kba. Sara srefi no bo man kisi pikin moro. Ma Abraham no ben kon swaki na ini en bribi. ");
INSERT INTO srnNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Noiti a lasi bribi ini a pramisi fu Gado, èn a bribi fu en ben kon moro tranga. Nanga dati a ben gi Gado grani. ");
INSERT INTO srnNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","A ben sabi krinkrin tak' Gado abi a makti fu du san A ben pramisi. ");
INSERT INTO srnNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Na a bribi dati meki tak' Gado si en leki wan sma di bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","A skrifi tak' Gado si Abraham leki wan sma di bun ini En ai. Ma un mus sabi tak' a sani disi no e teri gi Abraham wawan. ");
INSERT INTO srnNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","A e teri gi wi tu, te wi poti wi bribi na ini Gado di meki Yesus, wi Masra, opo baka na dede. ");
INSERT INTO srnNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yesus ben dede fu wi sondu ede, èn A opo baka fu wi kan kon bun nanga Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Wi di kon bun ini Gado ai fu di wi bribi, abi freide nanga En, tangi fu wi Masra Yesus Kristus. ");
INSERT INTO srnNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","San Yesus du meki tak' Gado sori wi En bun-ati fu di wi bribi. A bun-ati disi e meki wi tnapu tranga, èn wi e meki bigi fu di wi abi a howpu tak' Gado o meki wi teki prati ini En glori. ");
INSERT INTO srnNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ma a no dati wawan. Wi e meki bigi tu fu di wi e nyan pina. Bika wi sabi tak' te wi e nyan pina, dan a e leri wi fu hori doro. ");
INSERT INTO srnNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Te wi e hori doro, dan dati e meki wi kon tranga, èn a tranga san wi e kon tranga, e meki tak' wi abi howpu. ");
INSERT INTO srnNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Èn a howpu san wi abi no o meki wi kon na syen, bika Gado poti En lobi ini wi ati di A gi wi En Santa Yeye. ");
INSERT INTO srnNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Di wi no ben man yepi wisrefi, dan Kristus dede gi den sma di no e dini Gado, tapu a ten di Gado poti. ");
INSERT INTO srnNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Na wan tranga sani fu dede gi wan sma di bun ini Gado ai. Ma kande yu o man feni wan sma ete di abi a dek'ati fu dede gi wan bun sma. ");
INSERT INTO srnNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ma Gado e sori wi fa A lobi wi. Bika di wi ben de sondusma ete, Kristus dede ini wi presi. ");
INSERT INTO srnNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Now di wi kon bun ini Gado ai fu di Kristus brudu lon gi wi, dan wi kan sabi krinkrin tak' A o ferlusu wi fu a atibron fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Gado meki En Manpikin dede gi wi, fu wi kan kon bun nanga En aladi wi ben de En feyanti. Dat' meki wi kan sabi trutru tak' now di wi kon bun nanga En, A o ferlusu wi fu di Kristus e libi. ");
INSERT INTO srnNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ma dati a no ala. Wi e meki bigi ini Gado fu di wi kon bun baka nanga En tangi fu wi Masra Yesus Kristus. ");
INSERT INTO srnNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","A de so tak' na wan enkri sma nomo meki sondu kon na grontapu, dan sondu tyari dede kon. Èn fu di ala sma sondu, meki ala sma e dede tu. ");
INSERT INTO srnNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Bika sondu ben de kba na grontapu fosi Gado ben gi a wèt. Ma efu wèt no de, dan yu no man kisi strafu fu sondu. ");
INSERT INTO srnNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Wi e si tak' ala sma dede ini a ten fu Adam kon miti Moses, aladi den no du a srefi sondu san Adam du di a psa Gado mofo. Adam na wan prentyi fu a Wan di ben mus kon. ");
INSERT INTO srnNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ma a sondu fu Adam no de leki a presenti san Gado gi wi ini En bun-ati. Bika a sondu fu wan libisma ben tyari dede kon gi furu sma. Ma a bun-ati san Gado sori wi nanga a presenti di A gi wi, warti furu moro dati gi furu sma. Èn san Yesus Kristus du leki libisma ini En bun-ati, meki tak' dati psa. ");
INSERT INTO srnNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","A presenti san Gado gi wi, no de leki a sondu fu Adam. Bika a wan enkri sondu ben tyari strafu kon. Ma aladi wi du someni sondu, Gado gi wi a presenti san meki tak' wi kon bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","A sondu fu a wan man ben meki tak' dede tron basi fu libisma. Ma ala sma di Gado e sori En bun-ati èn di A meki kon bun baka nanga En fu soso, o libi èn rigeri leki kownu, tangi fu Yesus Kristus. ");
INSERT INTO srnNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Fu di Adam psa Gado mofo, a sani dati tyari strafu kon gi ala sma. Na so tu, fu di Yesus du san Gado wani, ala sma kon bun ini Gado ai èn den kisi a libi. ");
INSERT INTO srnNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","A trangayesi fu Adam ben meki bun furu sma tron sondusma. Na so a de tu tak' fu di Yesus arki Gado, meki bun furu sma sa kon bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","A wèt kon bakaten, fu a sondu ben kon moro furu. Ma o moro sma ben e sondu, o moro Gado ben e sori En bun-ati moro ete. ");
INSERT INTO srnNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Soleki fa sondu ben meki dede tron basi fu libisma, na so a bun-ati e tiri libisma now fu di den kon bun ini Gado ai. Disi e meki den kisi a libi fu têgo, tangi fu wi Masra Yesus Kristus. ");
INSERT INTO srnNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","San un sa taki dan? Un sa tan sondu fu Gado sori un En bun-ati moro nanga moro? ");
INSERT INTO srnNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kwet'kweti! Un dede gi sondu. Fa un kan tan libi na ini sondu ete dan? ");
INSERT INTO srnNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Na sabi un no sabi tak' wi alamala di dopu na ini Kristus Yesus, ben dopu na ini a dede fu En? ");
INSERT INTO srnNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Di wi dopu, wi dede èn wi beri makandra nanga En. Dan soleki fa a P'pa meki Kristus opo baka na dede nanga a bigi makti fu En, na so wi o libi wan nyun libi tu. ");
INSERT INTO srnNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Bika efu wi tron wan nanga Kristus fu di wi dede leki En, dan so wi sa opo baka na dede neleki En. ");
INSERT INTO srnNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Wan sani wi sabi: Di den spikri Yesus na a kroisi, dan a owru fasi fu wi ben spikri makandra nanga En. Dati psa fu tyari wan kba kon na a sondu fasi fu wi, èn fu a sondu no man basi wi moro langa. ");
INSERT INTO srnNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Bika sondu no abi makti moro tapu wan sma di dede. ");
INSERT INTO srnNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","So, efu wi dede makandra nanga Kristus, dan wi e bribi tak' wi sa libi makandra nanga En tu. ");
INSERT INTO srnNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Bika wi sabi tak' fu di Kristus opo baka na dede, A no o dede moro. Dede no abi makti moro na En tapu. ");
INSERT INTO srnNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Di Kristus dede, A dede wan leisi nomo fu broko a makti fu sondu, èn noiti A sa abi fu dede moro. Ma now di A e libi, A e libi gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Na so un mus si en tu, tak' un dede gi sondu, ma un e libi gi Gado fu di un de wan nanga Kristus Yesus. ");
INSERT INTO srnNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Un abi wan skin di o dede, ma un no mus meki sondu rigeri leki basi na ini a skin disi, fu du san a lostu. ");
INSERT INTO srnNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","No gi no wan pisi fu yu skin na a sondu fu du den ogri sani fu en. Ma poti yusrefi fu wroko gi Gado leki sma di ben dede, ma di e libi now. Poti ala pisi fu yu skin fu du wroko san bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Dan sondu no o basi un moro. Bika un no de ondro a wèt, fu di Gado sori un En bun-ati. ");
INSERT INTO srnNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","San un sa du dan? Wi kan tan du sondu fu di wi no de moro ondro a wèt, ma fu di Gado sori wi En bun-ati? Kwet'kweti! ");
INSERT INTO srnNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Un sabi tak' te yu e poti yusrefi leki srafu gi wan sma, dan a sma dati na yu basi èn yu mus fu du san a taki. Efu yu de wan srafu fu sondu, dan yu o dede. Ma efu yu e du san Gado wani, dan yu o de wan bun sma ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ma mi e taki Gado tangi! Bika fos'fosi un ben de srafu fu sondu, ma now un gi yesi nanga un heri ati na a leri di un kisi. ");
INSERT INTO srnNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Now un kon fri fu sondu, èn un tron srafu fu Gado fu du san bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Mi e taki a sani disi libisma fasi fu un kan ferstan san mi e taki. Fos'fosi un ben poti unsrefi leki srafu fu libi wan doti libi, èn un ben e broko a wan wèt baka a trawan. Ma now un mus poti ala pisi fu un skin fu du san bun ini Gado ai. Disi o meki un kon santa. ");
INSERT INTO srnNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Di un ben de srafu fu a sondu ete, dan un no ben man du san bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ma sortu wini un ben abi? Now un e syen fu den sani san un ben e du, bika a kba fu den sani dati na dede. ");
INSERT INTO srnNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ma now un kon fri fu sondu èn un tron srafu fu Gado. A wini san un abi na tak' un kon santa, èn a kba fu a sani disi na a libi fu têgo. ");
INSERT INTO srnNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Bika a paiman fu sondu na dede. Ma a presenti san Gado gi wi, na a libi fu têgo na ini Kristus Yesus, wi Masra. ");
INSERT INTO srnNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Brada nanga sisa, solanga wan sma de na libi, dan a wèt e taigi a sma san a mus du. Un sabi dati, bika mi e taki nanga sma di sabi a wèt. ");
INSERT INTO srnNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Fu gi wan eksempre: Te wan uma trow, dan a wèt e tai en fasi na en masra solanga a man e libi. Ma te en masra dede, dan a wèt di ben tai en na en masra, no e teri gi en moro. ");
INSERT INTO srnNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","So efu a frow teki wan tra man, aladi en masra de na libi ete, dan sma abi leti fu taki tak' a huru. Ma efu en masra dede, dan a wèt no e teri moro gi en. So a no e huru, awinsi a teki wan tra man. ");
INSERT INTO srnNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Brada nanga sisa, na so a de nanga unu tu. Bika di Kristus dede, un kmopo ondro a makti fu a wèt. Dan now un de fu a Wan di kon baka na libi, fu wi kan du bun wroko gi Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Di wi ben meki a sondufasi fu wi tiri wi, dan den sondu lostu di a wèt ben e wiki na ini wi, ben e basi wi fu wi du den wroko di e tyari dede kon. ");
INSERT INTO srnNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ma now a wèt no e teri gi wi moro, bika wi dede gi a sani di ben tai wi hori. Now wi no e dini Gado moro tapu a owru fasi fu a wèt, ma wi e dini En tapu a nyun fasi fu a Yeye. ");
INSERT INTO srnNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","San un sa taki dan? Tak' a wèt na sondu? Kwet'kweti! Ma na a wèt ben leri mi san na sondu. Mi no bo sabi san na bigi-ai efu a wèt no ben taki: “Yu no mus abi bigi-ai.” ");
INSERT INTO srnNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ma a sondu teki a wèt disi fu wiki ala sortu bigi-ai na ini mi. Efu a wèt no ben de, dan sondu no bo abi a makti disi. ");
INSERT INTO srnNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Fos'fosi mi ben libi sondro wèt. Ma di a wèt kon, a sondu kisi makti ");
INSERT INTO srnNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","èn mi dede. So mi kon si tak' a wèt di ben mus tyari libi kon, tyari dede kon gi mi. ");
INSERT INTO srnNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Bika a sondu teki a wèt disi fu kori mi, èn fu kiri mi. ");
INSERT INTO srnNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ma a wèt santa, sosrefi den sani san a wèt e taki. Den de leki fa Gado wani, èn den bun. ");
INSERT INTO srnNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Un sa man taki dan tak' wan bun sani tyari dede kon gi mi? Kwet'kweti! Na a sondu du dati. A teki a bun sani fu tyari dede gi mi. Na so sondu sori san a de trutru, èn a wèt sori tak' sondu takru psa marki. ");
INSERT INTO srnNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Wi sabi tak' a wèt kmopo fu a Yeye fu Gado, ma mi na wan libisma di de leki wan srafu fu sondu. ");
INSERT INTO srnNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mi srefi no man ferstan den sani san mi e du. Bika mi no e du den sani san mi e angri fu du. Ma den sani san mi no lobi srefsrefi, na dati mi e du. ");
INSERT INTO srnNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Fu di mi e du san mi no wani du, dan dati e sori mi tak' mi e agri nanga a wèt, èn tak' mi e feni en bun. ");
INSERT INTO srnNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ma a no mi e du den sani moro, ma na a sondu di e libi na ini mi. ");
INSERT INTO srnNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Mi sabi tak' no wan bun no de na ini mi, sobun na ini a sondufasi fu mi. Bika mi e angri fu du san bun, ma mi no man. ");
INSERT INTO srnNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mi no e du a bun san mi wani du. Ma a ogri san mi no wani du, na dati mi e du. ");
INSERT INTO srnNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","So efu mi e du a sani san mi no wani fu du, dan a no mi e du en moro, ma na a sondu di e libi na ini mi. ");
INSERT INTO srnNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","So mi kon si wan sani ini a libi. Dati na tak' te mi wani du bun, a ogri de leti drape. ");
INSERT INTO srnNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Dipi ini mi ati mi lobi a wèt fu Gado, ");
INSERT INTO srnNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ma mi e si tak' wan heri tra wèt e wroko na ini mi skin. Mi agri nanga a wèt fu Gado ini mi ferstan. Ma a tra wèt e feti nanga a wèt fu Gado, èn a e meki mi tron wan srafu fu a wèt fu sondu di de na ini mi. ");
INSERT INTO srnNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ai, mi de fu sari fu tru! Suma sa ferlusu mi puru ini a skin disi di o meki mi dede? ");
INSERT INTO srnNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mi e taki Gado grantangi tak' na Yesus Kristus, wi Masra, e du dati! So mi e si tak' nanga mi ferstan mi e du san Gado wèt e taki, ma nanga a sondufasi fu mi, mi e du san a wèt fu sondu e taki. ");
INSERT INTO srnNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ma now Gado no e krutu den sma moro di de wan nanga Kristus Yesus. ");
INSERT INTO srnNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Bika a wèt fu a Yeye, di e tyari libi kon fu di wi de wan nanga Kristus Yesus, meki wi kon fri fu a wèt di e tyari sondu nanga dede kon. ");
INSERT INTO srnNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Gado du san a wèt no ben man du fu di a sondufasi fu wi meki a wèt kon swaki. A seni En eigi Manpikin kon ini wan skin leki san wi leki sondusma abi, fu de wan offer gi sondu. Na so A krutu a sondu ini wan libisma skin. ");
INSERT INTO srnNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Now wi kan du san a wèt e taigi wi fu du, bika wi no e libi moro leki fa a sondufasi fu wi wani, ma wi e libi leki fa a Yeye wani. ");
INSERT INTO srnNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Bika den sma di e meki a sondufasi fu den tiri den, e poti den prakseri fu du san a sondu wani. Ma den sma di e meki a Yeye tiri den, e poti den prakseri fu du san a Yeye wani. ");
INSERT INTO srnNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Fu poti yu prakseri tapu san a sondufasi fu yu wani, e tyari dede kon. Ma fu poti yu prakseri tapu san a Yeye wani, e tyari libi nanga freide kon. ");
INSERT INTO srnNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Dat' meki a sma di e poti en prakseri tapu san a sondufasi fu en wani, na wan feyanti fu Gado. A no e du san a wèt fu Gado e taki, èn a no man du en tu. ");
INSERT INTO srnNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Den sma di e meki a sondufasi fu den tiri den, no man gi Gado prisiri. ");
INSERT INTO srnNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ma un dati no e meki a sondufasi fu unu e tiri unu. Un e du san a Yeye wani, dati na efu a Yeye fu Gado e libi na ini unu. Ma a sma di no abi a Yeye fu Kristus, no de wan sma fu En. ");
INSERT INTO srnNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Efu Kristus de na ini unu, dan a skin o dede fu di a sondu. Ma a yeye o libi fu di Kristus meki un kon bun ini Gado ai. ");
INSERT INTO srnNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Gado ben meki Yesus opo baka na dede. So efu a Yeye fu Gado e libi na ini unu, dan En di ben meki Kristus Yesus opo baka na dede, sa meki un skin di o dede, kon baka na libi tu, nanga a krakti fu En Yeye di e libi na ini unu. ");
INSERT INTO srnNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Brada nanga sisa, wi abi wan plekti. Ma a no fu wi du san a sondufasi fu wi e taigi wi fu du. ");
INSERT INTO srnNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Bika efu un e libi leki fa a sondufasi fu un wani, dan a o tyari dede gi unu. Ma efu nanga a krakti fu a Yeye, un tapu fu du san a sondufasi fu un wani, dan un o libi. ");
INSERT INTO srnNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ala sma di a Yeye fu Gado e tiri, na pikin fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Bika a Yeye di Gado gi unu, no e meki un tron srafu fu un frede baka. Ma a Yeye meki un tron pikin fu Gado, èn A e meki wi taki: “Abba, wi Papa!” ");
INSERT INTO srnNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","A Yeye disi srefi e taki makandra nanga wi yeye tak' wi na pikin fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","So efu wi na pikin fu Gado, dan wi abi prati na ini den gudu. Wi abi prati na ini den gudu fu Gado makandra nanga Kristus. Bika efu wi e nyan pina makandra nanga En, dan wi o teki prati na ini En glori tu. ");
INSERT INTO srnNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","A de krin gi mi tak' a glori san wi o kisi bakaten, bigi moro a pina san wi e nyan nownow. ");
INSERT INTO srnNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Bika ala den sani san Gado meki, e wakti nanga wan bigi angri fu Gado tyari kon na krin suma na den pikin fu En. ");
INSERT INTO srnNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Bika ala sani san Gado meki kon lasi en warti, no fu di den srefi ben wani, ma fu di Gado meki dati psa. Ma howpu de. ");
INSERT INTO srnNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Nownow den sani san Gado meki e pori gwe. Ma den o kon fri fu a katibo disi, èn den o abi prati na ini a glori san den pikin fu Gado o kisi. ");
INSERT INTO srnNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Bika wi sabi tak' te leki now, ala den sani san Gado meki e soktu leki wan uma di mus kisi wan pikin. ");
INSERT INTO srnNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ma a no den wawan, wi srefi e soktu tu. Wi ben kisi a Yeye leki a fosi sani fu Gado. Ma now wi e wakti fu Gado teki wi leki trutru pikin fu En, dati na te A meki wi skin kon fri. ");
INSERT INTO srnNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Fu di wi ben abi a howpu disi meki Gado ferlusu wi. Ma efu yu e howpu fu kisi wan sani di yu abi kba, dan dati a no howpu. Suma e howpu fu kisi wan sani san a abi kba? ");
INSERT INTO srnNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ma efu wi e howpu fu kisi wan sani san un no abi ete, dan wi e wakti nanga pasensi te leki wi kisi en. ");
INSERT INTO srnNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Na so a Yeye e yepi wi tu nanga wi swakifasi. Bika wi no sabi gi san wi mus begi èn fa wi mus du en. Ma a Yeye srefi e begi gi wi nanga dyeme di yu no man poti na ini wortu. ");
INSERT INTO srnNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Èn Gado, di sabi ala ati, sabi san a Yeye wani taki. Bika a Yeye e begi gi den sma fu Gado soleki fa Gado wani. ");
INSERT INTO srnNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Èn wi sabi tak' Gado e tyari ala sani kon na wan bun kba gi den sma di lobi En, sobun den sma di A ben kari soleki fa A ben abi na ini En prakseri. ");
INSERT INTO srnNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Bika Gado ben sabi kba na fesi suma na den sma dati. Èn A ben poti kba na fesi tak' den mus kon de leki En Manpikin. Tapu a fasi dati a Manpikin na a fosiwan fu wan bigi grupu brada nanga sisa. ");
INSERT INTO srnNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Den sma di A ben poti kba na fesi, na den dati A kari. Èn den sma di A kari, na den dati A meki kon bun ini En ai. Den sma di A meki kon bun ini En ai, na den dati A o meki teki prati na ini En glori. ");
INSERT INTO srnNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","San un mus taki fu den sani disi dan? Efu Gado de nanga wi, dan suma o man du wi wan sani? ");
INSERT INTO srnNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Gado no ben hori En Manpikin gi Ensrefi, ma A gi En abra fu wi alamala ede. Efu Gado gi wi En Manpikin, dan fa A no sa gi wi ala tra sani dan? ");
INSERT INTO srnNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Suma sa man kragi den sma di Gado ben teki gi Ensrefi? Na Gado meki wi kon bun ini En ai. ");
INSERT INTO srnNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Suma sa man krutu wi? No wan sma, bika Kristus Yesus dede gi wi. Ma a no dati wawan. Gado meki A opo baka na dede, èn now A de na a let'anu sei fu Gado pe A e begi gi wi. ");
INSERT INTO srnNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Suma sa man prati wi fu a lobi fu Kristus? Awinsi wi e pina noso wi de ini nowtu, awinsi sma de na wi baka fu du wi ogri, awinsi wi no abi noti fu nyan noso fu weri, èn awinsi wi e suku fu dede noso sma wani fu kiri wi, no wan fu den sani disi o man prati wi nanga a lobi fu Kristus. ");
INSERT INTO srnNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","A de soleki fa a skrifi taki: Fu Yu ede meki ala yuru den wani kiri wi. Den teki wi leki skapu di den e tyari fu go srakti. ");
INSERT INTO srnNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ma a sani san Yesus du fu di A lobi wi, meki tak' wi de moro leki winiman na ini ala den sani disi. ");
INSERT INTO srnNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Bika mi sabi krinkrin tak' noti sa man prati wi fu a lobi fu Gado: no dede, no libi, no wan engel, no wan yeye di abi makti, sosrefi noti di o psa tide noso tamara, èn no wan yeye di abi krakti. ");
INSERT INTO srnNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","No wan sani tu di de na loktu noso ondrogron, èn no wan tra sani di Gado meki, sa man prati wi fu a lobi fu Gado di de na ini Kristus Yesus, wi Masra. ");
INSERT INTO srnNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Mi na fu Kristus èn den sani san mi e taki tru. Mi no e lei. A Santa Yeye e tiri mi konsensi, èn mi konsensi e taigi mi tak' mi no e lei. ");
INSERT INTO srnNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Mi ati broko èn mi abi wan dipi sari. ");
INSERT INTO srnNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Mi ben e winsi tak' a fluku fu Gado ben de na mi tapu èn tak' mi ben prati nanga Kristus, efu dati ben sa yepi den sma fu mi, mi eigi folku. ");
INSERT INTO srnNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Den na den sma fu Israel. Gado ben teki den leki En pikin, èn A sori den En glori. A ben meki ferbontu nanga den èn A gi den a wèt. Na den na den sma di Gado ben sori fa fu dini En trutru, èn A ben gi den pramisi. ");
INSERT INTO srnNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Den na den bakapikin fu den afo, èn di Kristus kon leki libisma, A gebore leki wan fu den. Na En na Gado di hei moro ala sani, èn meki wi opo En nen fu têgo. Amen. ");
INSERT INTO srnNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Mi no e taki tak' Gado no du san A taki. Bika a no ala sma di gebore leki Dyu na trutru Dyu. ");
INSERT INTO srnNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","A no ala bakapikin fu Abraham na trutru bakapikin fu en tu. Bika a skrifi taki: “Isak sa de a rutu fu yu pipel.” ");
INSERT INTO srnNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Dati wani taki tak' a no den pikin di meki libisma fasi na pikin fu Gado. Ma Gado e si leki pikin fu Abraham, soso den pikin di kon gebore tapu gron fu san A ben pramisi. ");
INSERT INTO srnNT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Bika Gado ben pramisi Abraham taki: “Tra yari a srefi ten disi, Mi sa drai kon dyaso baka, dan Sara sa abi wan manpikin.” ");
INSERT INTO srnNT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ma a no dati wawan. Rebeka ben hori bere tu fu wan man nomo. Wi afo Isak. ");
INSERT INTO srnNT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Den pikin no ben gebore ete, èn den no ben du no wan bun noso ogri ete. Ma Gado ben wani sori tak' a didon na En fu teki suma A wani. ");
INSERT INTO srnNT_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","A no didon na san wan sma e du, ma a didon na Gado di e kari suma A wani. Dat' meki A taigi Rebeka taki: “A bigiwan sa kon ondro a makti fu a pikinwan.” ");
INSERT INTO srnNT_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","A de soleki fa a skrifi taki: “Yakob Mi ben lobi, ma Mi no ben man si Esau na ai.” ");
INSERT INTO srnNT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","San un mus taki dan? Un sa man taki tak' Gado no e du sani tapu wan leti fasi? Kwet'kweti! ");
INSERT INTO srnNT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Bika Gado ben taigi Moses taki: “Mi e sari suma Mi wani sari, èn Mi e sori sari-ati na suma Mi wani sori sari-ati.” ");
INSERT INTO srnNT_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","So a no didon na san wan sma wani, efu noso omeni muiti a e meki. Ma a didon na a sari-ati fu Gado. ");
INSERT INTO srnNT_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Bika a skrifi ini a Santa Buku tak' Gado taigi Farao taki: “Mi poti yu leki Farao nomo fu Mi kan teki yu fu sori Mi makti, èn fu Mi nen panya na heri grontapu.” ");
INSERT INTO srnNT_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","So yu e si tak' Gado e sari suma A wani, èn A e tranga a ati fu suma a wani. ");
INSERT INTO srnNT_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Dan son sma o wani taigi mi taki: “Efu na so a de, dan fa Gado kan feni tak' un fowtu? Bika no wan sma o man tapu En fu A du san A wani.” ");
INSERT INTO srnNT_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ma suma na yu leki libisma fu taigi Gado tak' san A e du no bun? Wan kroiki no kan aksi a sma di meki en taki: “Fu sanede yu meki mi so?” ");
INSERT INTO srnNT_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","A man di e meki kroiki kan du nanga a kleidoti san a wani. Fu a srefi kleidoti a kan meki wan kroiki gi spesrutu momenti, nanga wan trawan gi aladei 