﻿USE sofia;
DROP TABLE IF EXISTS sofia.srmNT_vpl;
CREATE TABLE srmNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES srmNT_vpl WRITE;
INSERT INTO srmNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wë nöö dee sëmbë, fa i si woo taki aki, nöö dee gaan sëmbë u ˻Masa˼ Jesosi Keesitu dee a abi, nöö de wë woo kai da unu aki e. Biga di de pai Masa Jesosi, nöö de pai ën a di lö u Abahamu, di gaan sëmbë fuu dee Isaëli sëmbë, ufö a dë wan bakamii u Könu Dafiti tu. ");
INSERT INTO srmNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Wë nöö haika e. Di möön fesiten gaan sëmbë fuu di u Dju sëmbë abi, hën de kai Abahamu, nöö hën pali Isaki e, nöö Isaki ko pali Jakopu, nöö hën Jakopu pali Juda ku dee baaa fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nöö hën Juda tei Tamali nöö hën ku ën pali Pëlëzi ku Zelaki, nöö hën Pëlëzi toona ko pali Esilon, nöö hën Esilon ko pali Lam. ");
INSERT INTO srmNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Nöö Lam ko pali Aminada, nöö Aminada toona ko pali Nakison, nöö hën Nakison ko pali Salima. ");
INSERT INTO srmNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nöö hën Salima tei Lakabu hën a pali Boasi. Hën Boasi tei Luti nöö hën a pali Obëti ku ën. Nöö hën Obëti toona pali Isai. ");
INSERT INTO srmNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Nöö Isai hën pali Könu Dafiti e, nöö hën Könu Dafiti toona pali Könu Salumon ku di mujëë u Ulia di a bi tei. ");
INSERT INTO srmNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Nöö hën Salumon toona pali Könu Lahabiam, nöö hën Könu Lahabiam toona pali Könu Abia, nöö Könu Abia pali Könu Asa. ");
INSERT INTO srmNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Nöö hën Könu Asa ko pali Könu Josafati, nöö hën Könu Josafati toona ko pali Könu Jolam, nöö hën Könu Jolam ko pali Könu Uzia. ");
INSERT INTO srmNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Nöö hën Könu Uzia pali Könu Jotam, nöö hën Könu Jotam ko pali Könu Akasi, nöö hën Könu Akasi ko pali Könu Esikia. ");
INSERT INTO srmNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Nöö hën Könu Esikia toona ko pali Könu Manase, nöö hën Könu Manase ko pali Könu Amon, nöö Könu Amon toona ko pali Könu Josia. ");
INSERT INTO srmNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nöö hën Könu Josia ko pali Könu Jekonia ku dee baaa fëën. Nöö a di ten u Könu Jekonia ala, nëën dee Babilon sëmbë kisi dee gaan sëmbë fuu tei tja go buta a katibo a Babilon köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Söö. Nöö woo kai dee gaan sëmbë u Masa Jesosi go dou. Nöö hën woo seti ku Könu Jekonia baka. Könu Jekonia hën toona pali Seatiëli, nöö hën Seatiëli pali Zebabeli. ");
INSERT INTO srmNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nöö hën Zebabeli toona ko pali Abiutu, nöö hën Abiutu pali Eliakim, nöö hën Eliakim toona pali Azolu. ");
INSERT INTO srmNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Nöö hën Azolu toona ko pali Sadoki, nöö hën Sadoki toona ko pali Akim, nöö hën Akim ko pali Eliutu. ");
INSERT INTO srmNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Nöö hën Eliutu toona ko pali Eleesa, nöö hën Eleesa pali Maatan, nöö hën Maatan ko pali wan sëmbë de kai Jakopu möön. ");
INSERT INTO srmNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nöö di Jakopu dë, hën ko pali Josëfu, nöö di Josëfu aki, hën wë da di manu u Malia e, nöö Malia hën pai Jesosi, di da di Keesitu. ˻Nöö fa u kai ën di Keesitu dë, hën kë taki di Sëmbë di Gadu bi paamusi taa a o manda ko fu ko tii di goonliba a wan leti fasi.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nöö sö u kai teni-a-fö gaan avo fu Masa Jesosi fu kumutu a Abahamu te dou a Könu Dafiti. Nöö fu kumutu a Könu Dafiti te dou a di ten de kisi de buta a katibo a Babilon dë, u toona kai teni-a-fö gaan avo fëën baka. Nöö fu kumutu a di ten di de kisi de buta a katibo dë tee dou di ten di de pai di Keesitu, u toona kai teni-a-fö gaan avo baka. Nöö sö wë dee gaan sëmbë u Masa Jesosi bi waka e. ");
INSERT INTO srmNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wë nöö fa i si woo taki ën aki, nöö sö de pai Jesosi Keesitu e, dee sëmbë. A dë sö taa Malia hën bi da di kiija mujëë u Josëfu. Nöö de an duumi seei, nöö hën wë de ko si taa di mujëë dë ku bëë gbolo. Nöö fa i si a ko dë ku bëë naandë, nöö di Akaa u Masa Gaangadu hën wë mbei a ko dë ku di bëë. ");
INSERT INTO srmNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nöö Josëfu dë wan sëmbë di ta libi leti a pasi kumafa Gadu kë. Nöö di Malia ko dë ku di bëë sö, nöö a kë disëën, ma an kë du ën a wan fasi fu sen kisi di mujëë, ma a kë du ën a wan tjubii fasi sö. ");
INSERT INTO srmNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nöö hën wë a dë ta pakisei di soni te wan pisi, nöö hën a duumi. Hën a sunjan wan basia u Masa Gaangadu köndë ko nëën. Hën a kai ën: “Josëfu, di böngö fu Könu Dafiti aki.” Hën a piki. A taa: “Ja musu fëëë fii tei Malia fii mujëë buta a i wosu e. Biga di bëë i si a dë ku ën naandë, na libisëmbë dëën. Di Akaa u Masa Gadu, hën wooko sö. ");
INSERT INTO srmNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nöö a o pai wan womi mii, nöö woon kai ën Jesosi. Hën kë taki ‘di Heepima’. Biga a o heepi dee sëmbë fëën puu de a dee hogilibi u de basu.” ");
INSERT INTO srmNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nöö fa i si di soni pasa dë sö, nöö a kai makandi ku di buka u Masa Gaangadu di a bi da wan fesiten tjabukama fëën ˻de kai Jesaaja˼. ");
INSERT INTO srmNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","A taa: Un haika e, dee sëmbë. Di wëndjë mujëë mii di an duumi ku manu wan daka, hën o tei bëë, nöö a o pai wan womi mii. Nöö de o kai di mii Imanuwëli. Hën kë taki “Gadu dë ku u”. Sö di tjabukama bi taki kaa e. ");
INSERT INTO srmNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Söö. Nöö di Josëfu hopo a duumi, nöö hën a du leti kumafa di basia taki dëën. Biga a tööu ku Malia hën a hoi ën nëën wosu. ");
INSERT INTO srmNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma nöö an sabi ën kuma mujëë fëën möönsö u teefa a pali wan womi mii, nöö hën wë de kai ën Jesosi. Nöö a sö wan fasi de pali Masa Jesosi e. ");
INSERT INTO srmNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Wë nöö di de pai Masa Jesosi, nöö de pai ën a wan köndë de kai Betelehem a di pisiwata u Judea naandë. Nöö di juu dë, wan könu de ta kai Helodi hën bi ta tii di köndë. Nöö hën de dë te wan pisi, nöö hën wanlö könima ko a di köndë. Dee könima dë, de ta luku teeja u de sabi andi o ta pasa a goonliba. Nöö hën de kumutu te a di së u sonu kumutu ala, hën de waka te de ko dou a Jelusalen. ˻Biga hën da di hediköndë u dee Dju sëmbë.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nöö fa de ko dou a Jelusalen dë, nöö hën de ta hakisi taa: “Wë na unsë de pai di njunjun könu fuun dee Dju sëmbë aki? Biga di u bi dë a u köndë a di së u sonu kumutu hën u si wan teeja di lei u soni fëën, nöö hën u ko aki fuu ko wai ku ën.” Sö de ta hakisi. ");
INSERT INTO srmNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wë nöö di Könu Helodi jei di soni dee könima ta hakisi naandë, nöö a toobi ën gaanfa, hën ku hii dee sëmbë u Jelusalen tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nöö hën a kai dee Gaan Begima u Dju ku dee Sabima u Wëti u de ko nëën. Hën a hakisi de taa: “Unfa di Buku taki? Naasë de o pai di Keesitu, di o ko dë könu fuu dee Dju sëmbë?” ");
INSERT INTO srmNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nöö hën de piki ën taa: “Wë leti a Judea aki a di köndë de kai Betelehem, ala de o pai di mii. Biga sö Gadu bi manda di tjabukama fëën faa musu sikifi. A taa: ");
INSERT INTO srmNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Di köndë de kai Betelehem, fa i si a dë a di pisiwata u Judea aki, nöö an dë lagi möön dee oto köndë u Judea, a dee hedima wojo e. Biga nëën wan gaan tiima o kumutu. Hën o tii dee Isaëli sëmbë u mi kuma wan sëmbë ta kiija sikapu ta tii de fu de an musu kaba a sösö. Sö a dë sikifisikifi a di Buku e.” Nöö sö dee leima piki Könu Helodi. ");
INSERT INTO srmNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nöö di Könu jei sö, hën a kai dee könima ko nëën saapi, nöö hën a ta fini de tefa a kaba fu de konda dëën gbelingbelin söndö ganjan ee un longi kaa de bi si di teeja. Hën de konda dëën tefa de kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nöö hën a manda de taa: “Un musu go a Betelehem e, nöö un suku finifini tee un go si di mii ka a dë, nöö un toona ko piki mi baka wantewante. Biga miseei kë go wai ku ën mbei piizii dëën tu.” Sö a taki da de. ");
INSERT INTO srmNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nöö hën wë di di Könu taki sö kaa, nöö hën de tei pasi nöö hën de go e. Nöö fa de nango dë, hën de ko si di wan seei teeja di de bi si a de köndë ala. Nöö di de si ën, nöö de wai seei. Nöö hën di teeja ta waka a de fesi ta tja de tee a go dou leti a di wosu ka di mii dë nëën dendu, nöö hën a tan piii a di wosu liba. ");
INSERT INTO srmNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nöö hën dee könima denda go a di wosu dendu, hën de go si di mii ku ën mama naandë, hën de tjökö kini a goon ta wai ku di mii ta bigi ën seei. Nöö hën de jabi dee toonpu u de, nöö hën de tei gaan dii gudu u di ten ala hën de da di mii. De dëën goutu. De dëën wan pei soni de ta tjuma nöö a ta sumëë suti, ku wan sumëë suti fatu degidegi kantii sö. Sö de dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nöö di ndeti hën de duumi, hën de sunjan wan sunjan taa de an musu toona go a di könu möön. Nöö hën de tei wan oto pasi hën de waka go u de a de köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nöö hën a baka u di dë, hën wan basia u Masa Gaangadu köndë ko piki Josëfu a sunjan taa: “Womi, hopo e, nöö i tei di mii ku ën mama nöö un kule go a Egepiti köndë. Nöö un tan ala u tee un jei mi piki unu baka, biga di könu o ta suku di mii faa musu feni ën kii.” ");
INSERT INTO srmNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nöö hën a di ndeti naandë seei, hën Josëfu hopo hën a tei di mii ku ën mama hën de fusi go a Egepiti köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hën de fika ala teefa Könu Helodi dëdë bifö de toona ko baka. Nöö fa di soni pasa dë, nöö a kai makandi ku wan oto buka Masa Gaangadu bi da dee tjabukama fëën a fesiten, a taa: Mi kai di mii u mi puu a Egepiti köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma nöö fa de bi dë a Egepiti köndë ala, hën di könu jei taa sö dee könima bi ganjëën, nöö hati fëën ko boonu seei tee an saanfa faa du. Nöö hën a kai dee sodati ko, hën a taki da de taa: “Un go a Betelehem e, nöö un go kii hii dee womi mii naandë tuu, kumutu a tide pai mii te kisi ku dee tu jaa mii.” Biga fu di soni naandë mbei a bi hakisi dee könima ee na un ten de bi si di teeja. ");
INSERT INTO srmNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nöö fa di soni pasa dë, nöö a kai leti ku di buka di Gadu bi da di tjabukama fëën de kai Jelemia, a taa: ");
INSERT INTO srmNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","A di köndë de kai Lama, de ta jei wan tumisi wolo, këë ta piki te na soni. Mama Lakëli ta këë dëdë ku libi fu dee mii fëën hedi. An kë sëmbë musu ganjëën möönsö biga dee mii fëën kaba tuu. Sö wë di Buku bi taki a fesi e. Nöö sö wan gaan hogi pasa a di köndë di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nöö hën de dë tee fa Könu Helodi dëdë, nöö hën wan basia u Masa Gadu Köndë toona ko a Josëfu a sunjan möön, te ka a dë a Egepiti köndë ala. A taki dëën taa: ");
INSERT INTO srmNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Womi, hopo, nöö i tei di mii ku ën mama nöö un toona go a Isaëli köndë baka e. Biga dee sëmbë dee bi ta suku di mii u kii nöö de an dë ku libi möön.” ");
INSERT INTO srmNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nöö hën Josëfu hopo, hën a tei di mii ku ën mama hën de toona go a Isaëli Köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma nöö di de dou, hën Josëfu ko jei taa di mii fu Könu Helodi de kai Akelausi ko dë könu u hii di pisiwata fu Judea nëën tata kamian. Nöö hën di a jei sö kaa, hën a panta seei. Nöö hën a toona sunjan wan oto sunjan möön taa an musu go a di pisiwata u Judea ala möön. Nöö hën a bia tei di mii ku ën mama, hën de go a di pisiwata de kai Galilea. ");
INSERT INTO srmNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hën de go libi a wan köndë de kai Nazalëti, ka Josëfu ku ën mujëë bi ta dë a fesi. Nöö fa u du dë, nöö a kai ku wan oto soni Masa Gadu bi manda wan tjabukama fëën faa taki a fesi, u di Paamusi Könu di Gadu o manda. A bi taa: De o kai ën sëmbë fu Nazalëti. ");
INSERT INTO srmNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wë nöö baka sömëni jaa longi, hën wan womi de kai Johanisi ko dë a di gaan sabana u Judea dendu ta bai basia. ");
INSERT INTO srmNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","A ta bai taa: “Un disa dee hogilibi fuunu e, bia ko libi bunu. Biga di juu dou kaa fu Gadu musu tii unu a wan njunjun fasi.” Fa Johanisi ta bai di basia dë, nöö sö a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nöö di Johanisi dë, nöö hën wë da di sëmbë di di tjabukama u Masa Gadu de kai Jesaaja bi taki a fesi di a taa: De ta jei wan töngö, wan sëmbë ta bai a di sabana taa: “Un mbei di pasi da Masa ooo, be a dë limbolimbo gbegedee dëën. Un seeka dee bendibendi pisi u di pasi, be de ko dë tololoo.” Sö Jesaaja bi taki taa wan sëmbë o ko ta bai, nöö di sëmbë a bi taki dë, nöö di Johanisi aki wë e. ");
INSERT INTO srmNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nöö fa Johanisi sai dë, nöö di koosu a ta bisi nëën sinkii, nöö de mbei ën ku wan mbeti de kai kamëli puuma, nöö di banti a ta tai nëën mindi nöö ku mbeti kakisa de mbei ën. Nöö di soni a ta njan, a dë wan pei atiti ta dë a di sabana naandë, nöö höniwata a ta bebe. Sö wan sëmbë Johanisi dë. ");
INSERT INTO srmNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nöö hii dee sëmbë u Jelusalen te kisi hii dee oto köndë u Judea tuu, te dou ku dee oto pisiwata u di lio de kai Joodan dë, de tuu seei ta hai ko nëën naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nöö fa a ta bai de a dee hogilibi u de dë, nöö de ta piki. De ko si taa de an ta libi bunu tuu, nöö hën Johanisi ta dopu de a di Joodan lio dë. ");
INSERT INTO srmNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nöö di juu dë, i abi tu paatëi a di dju keiki. Wan da Sadusei, wan da Falisei. ˻Nöö fa dee sëmbë u de tu paatëi sai dë, de ta mbei deseei gaan hebima u Dju, bumbuu sëmbë.˼ Nöö di de jei taa Johanisi ta dopu sëmbë, nöö hën sömëni u de ko nëën faa dopu de tu. Ma di a si de, nöö hën a gandji da de seei. A taa: “Un dee takuhatima dë, unfa un hai ko gidjii sö naandë kuma wanlö hia sindeki ta lusu kumutu a dokunu ta kule da faja? Ambë bai unu taa fuun kule da di hatiboonu u Gadu fu an kai a unu liba? ");
INSERT INTO srmNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","“Wë nöö ee wan kë Gadu hati boonu ku unu, nöö un musu bia unu libi, be lanti si taa un disa dee hogilibi fuunu tuu e! ");
INSERT INTO srmNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wan musu sai naandë ta mbei taa: ‘Fa u dë Abahamu böngö tjika aki, nöö andi seei sa toobi u möön? Gadu sëmbë u dë kaa.’ Wan mëni di soni dë e! Biga mi taki da unu taa ee Gadu kë nöö a sa mbei dee sitonu i si aki kisi libi bia ko Abahamu böngö a unu kamian. ˻Biga wan ta libi bunu möön de.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Nöö mi taki da unu e, taa fa u dë aki, nöö de seti koti dee pau lutu kaa. Nöö ee wan pau sai dë an ta pai bumbuu njanjan, nöö de o faa ën puu koti tuwë a faja tjuma kaba a sösö.” Sö Johanisi bai dee hedima u Dju keiki dee ko nëën dë. ");
INSERT INTO srmNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nöö hën a toona fan möön taa: “Fa mi ta dopu sëmbë aki, nöö mi ta dopu de ku wata fu di de kë bia disa di hogilibi u de. “Ma nöö wan oto sëmbë dë ta ko a mi baka, nöö a hebi gaanfa möön mi e. Ma bumbuu tjika seei u mi dë futuboi fëën ta tja saapatu fëën dëën. Nöö fa a o ko dë, nöö a o tja wan oto dopu ko, biga hën o dopu unu ku di Akaa u Masa Gadu, ku faja. ˻Biga fa a o du ën dë, nöö di Akaa o dë a unu liba kuma faja ta tjuma hogilibi puu a unu hati.˼ “Sö wë di Sëmbë di o ko aki o abi kaakiti tjika e. ");
INSERT INTO srmNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Nöö fa u dë aki, a dë kabakaba këëë faa ko seeka di njanjan fëën. A o tja dee bumbuu njanjan ko lai a suwa, ma dee poipoi wan a o tjuma a di faja di an sa tapa a mundu möönsö.” Sö Johanisi taki. ");
INSERT INTO srmNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wë nöö di juu dë, hën Masa Jesosi seei kumutu a Galilea ko a Johanisi a Joodan Lio dë, faa musu dopu ën tu. ");
INSERT INTO srmNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma nöö fa a ko dë, hën Johanisi kë tapëën. A taa: “Fa i dë aki, nöö mi bi musu ko a i fii dopu mi, nöö hën i ko a mi nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Masa Jesosi piki ën taa: “Nönö, na tapa mi e. Boo du ën nöö. Biga a fiti fuu du hii dee soni dee dë leti a Gadu wojo.” Nöö di a taki sö kaa, nöö hën Johanisi dopu ën awaa. ");
INSERT INTO srmNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nöö di a dopu ën te a kaba, hën Masa Jesosi ta kumutu a di wata. Nöö wantewante dë, hën mundu jabii wajaa gbegedee nëën liba, hën a si di Akaa u Masa Gadu kuma wan pomba saka ko nëën liba. ");
INSERT INTO srmNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hën de jei wan töngö piki te a liba ala taa: “Ja si di sëmbë aki ö? Hën wë da di lobi womi mii u mi. Libi fëën ta kai ku mi.” Sö wan gaan soni wë pasa di Masa Jesosi dopu e, dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wë nöö baka u di Masa Jesosi dopu, nöö hën di Akaa u Gadu tjëën go a wan gaan sabana dendu, fu di didibi sa ko nëën ko poobëën luku ee a sa mbei a piki ën buka. ");
INSERT INTO srmNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nöö hën Masa Jesosi go tan ala föteni daka ndeti ku didia ta begi söndö njan, nöö hangi ko kisi ën seei. ");
INSERT INTO srmNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nöö hën di poobasëmbëma de kai didibi go nëën ala. A taki dëën taa: “Wë di i dë di Mii u Gadu tuu, nöö be i fan ku dee sitonu i si aki be de bia sondi u njan da i.” ");
INSERT INTO srmNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma nöö hën Masa Jesosi piki ën taa: “Ja jei fa a sikifi a Gadu Buku ö? A taa na soni u njan wanwan nöö ta hoi sëmbë a libi e, ma a hiniwan wöutu fu Gadu di a ta taki, nöö a de libi ta kumutu. Sö di Buku taki e.” ");
INSERT INTO srmNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nöö hën di didibi tei ën tja go te a di Wosu u Masa Gadu a Jelusalen naandë, tee a di tölu fëën a liba ala. ");
INSERT INTO srmNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hën a taki dëën taa: “Di i da Gadu Mii, nöö vinde i seei tuwë go a goon. Biga di Buku sikifi taa Gadu o manda dee basia fëën u de ko heepi i. De o tja i a maun fu ja musu naki futu a sitonu.” ");
INSERT INTO srmNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nöö hën Masa Jesosi piki ën taa: “Ma di Buku taki tu taa ja musu pooba Masa Gadu e. Biga hën da i Gadu.” ");
INSERT INTO srmNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nöö hën a baka u di dë möön, nöö hën di didibi tei Masa Jesosi tja go tee a wan hei kununu liba, hën a lei ën hii soni u goonliba palalaa lontu dou. Dee waiti soni nëbai wan u goonliba ku hii dee köndë, de tuu a lei ën. ");
INSERT INTO srmNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hën a taki dëën taa: “Ja si ö? Hii dee soni aki tuu mi o da i fii seei, ee i tjökö kini a goon a mi fesi aki begi mi.” ");
INSERT INTO srmNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nöö fa di didibi fan te tjika dë, nöö hën Masa Jesosi gandji dëën awaa. A taa: “Hetji pasa kumutu a mi fesi aki, ju didibi Saatan! Biga di Buku u Gadu taki taa ja musu begi na wan oto soni a mundu möön leki Gadu i Masa. Hën tö nöö i musu ta dini.” ");
INSERT INTO srmNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nöö fa a fan ku ën naandë, nöö hën di didibi disëën go, nöö hën dee basia u Masa Gadu Köndë ko nëën awaa ko sölugu ën. ");
INSERT INTO srmNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nöö a baka u di dë, hën Masa Jesosi ko jei taa de kisi Johanisi di Dopuma buta a dunguwosu. Nöö di a jei sö, hën a kumutu a Judea go a di pisiwata u Galilea, a Nazalëti ka de bi kiijëën. ");
INSERT INTO srmNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma nöö an tan dë. A pasa go libi a wan oto köndë u Galilea de kai Kapenaumi di dë a di ze bandja. Nöö di köndë a go sai dë, nöö a dë zuntu ku dee köndë ka dee Dju lö de kai Zebulon ku Nafutali ta libi. ");
INSERT INTO srmNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nöö a kai ku wan soni di tjabukama u Gadu de kai Jesaaja bi sikifi a di Buku di a taa: ");
INSERT INTO srmNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Un luku dee köndë dë, dee u Zebulon ku Nafutali lö. De dë leti a di pasi ka i ta waka nango a di ze, a di oto së banda u di Lio de kai Joodan, a Galilea seei, ka dee sëmbë na Dju ta libi. ");
INSERT INTO srmNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dee lö sëmbë naandë bi dë a suguu, ma awaa de ko si wan gaan limbo ta ko a de. Fa de bi ta fëëë dëdë dë, nöö di limbo dë o ko puu de a di sitaafu dë basu, leti kuma te didia ta jabi faa jaka di ndeti go. Sö Jesaaja bi sikifi. ");
INSERT INTO srmNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Wë nöö di juu dë, nöö hën Masa Jesosi seti ta konda di buka u Gadu taa: “Dee sëmbë o, un disa dee hogilibi fuunu e, bia libi bunu. Biga Masa Gaangadu dë kabakaba faa tii unu a wan hii njunjun fasi awaa.” ");
INSERT INTO srmNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tefa wan daka nöö hën Masa Jesosi ta waka a di ze u Galilea bandja naandë, hën a ko si wanlö womi ta tuwë nëti a wata u de kisi fisi. Nöö wan u dee womi de kai Petuisi, hënseei da Simon. Di otowan da hën baaa womi Andiasi. De tu baaa aki sö dë höndima ta kisi fisi. ");
INSERT INTO srmNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nöö fa Masa Jesosi ta pasa dë, hën a kai de: “Dee womi aki.” Hën de piki. A taa: “Un ko go ku mi e, be mi lei unu fa fuun kisi libisëmbë ˻tja ko da Gadu˼.” ");
INSERT INTO srmNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nöö fa a fan ku de dë, nöö hën wante de disa hii dee soni u de de bi ta höndi dë tuu, nöö hën de go ta waka a Masa Jesosi baka. ");
INSERT INTO srmNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nöö hën de waka go möön longi. Nöö hën Masa Jesosi si tu oto baaa möön, Jakobosi ku Johanisi, nöö deseei dë höndima tu ta kisi fisi. Nöö de dë ku de tata Zebedeosi a wan boto dendu ta lapu dee nëti u de. Nöö hën a kai de tu, fu de ko waka nëën baka. ");
INSERT INTO srmNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nöö hën de tu baaa kumutu wante a di boto disa de tata, nöö hën de go ta waka a Masa Jesosi baka. ");
INSERT INTO srmNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nöö hën Masa Jesosi kumutu dë ta waka a hii di pisiwata u Galilea naandë te dou. A nango a dee keikiwosu u dee Dju nango ta lei de ta konda di bunu buka u Masa Gaangadu da de kumafa di Njunjun Tii u Gadu o dë. Nöö a ta kula hii pei siki tu. ");
INSERT INTO srmNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nöö fa u mbei naandë, nöö hën në fëën ko paaja a hii di pisiwata naandë tuu te kisi Silia köndë, nöö hën de ta tja peipei sikima ko nëën faa kula de. So sëmbë sinkii ta njan de, so sëmbë dë ku gadu a hedi, so sëmbë dë ku pikimii siki ta naki de ta tuwë, so sëmbë dë lanlan, hii dee lö pei sëmbë dë tuu de ta tja ko nëën nöö a ta kula de. ");
INSERT INTO srmNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nöö na sikima wanwan nöö ta ko nëën sö e. Ma hii sëmbë dee dë a Galilea dë tuu booko seei gililii ta ko nëën, ku dee sëmbë u di pisiwata de kai Dekapolisi, ku dee sëmbë u Jelusalen te dou ku dee oto köndë u Judea tuu, te kisi dee sëmbë ta libi a oto banda u Joodan Lio ala. Hii dee sëmbë dee jei fëën palalaa dou, de tuu ta booko gililii ta ko nëën. ");
INSERT INTO srmNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nöö di Masa Jesosi si dee hia sëmbë ta ko nëën dë, nöö hën a subi wan kuun te dou nëën mindi, nöö hën a sindo faa lei de. Hën dee bakama fëën hai ko dë möön zuntu ku ën. ");
INSERT INTO srmNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nöö hën a tei dee wöutu aki nöö hën a lei de. A taa: ");
INSERT INTO srmNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Dee sëmbë o, wan fëëë e, ee un ta fii taa söndö Gadu wan dë wan wojo soni. Un dë bunu e, biga dee sëmbë ta fii sö, nöö de dë a dendu u di Tii u Gadu kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Nöö un dë bunu e, dee sëmbë, ee un ta këë. ˻Biga ee un biibi a Gadu, nöö˼ Gadu o mbei hati fuunu ko kötö wan daka nöömö. ");
INSERT INTO srmNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Nöö un dë bunu e, dee sëmbë, ee un abi saka fasi. Biga a bakaten di goonliba aki o ko fuunu nöömö fuun tii. ");
INSERT INTO srmNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nöö un dë bunu e, dee sëmbë, ee un ta kë fu hii soni musu ta waka tololoo a Gadu wojo. Biga wan daka woon si ën sö nöömö. ");
INSERT INTO srmNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Nöö un dë bunu e, dee sëmbë, ee un abi tjalihati u sëmbë. Biga Gadu o abi tjalihati fuunu tu. ");
INSERT INTO srmNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Nöö un dë bunu e, dee sëmbë, ee hati fuunu dë limbolimbo a Gadu wojo. Biga a a’ wan daka unu ku Gadu o miti nöömö fesi ku fesi. ");
INSERT INTO srmNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Nöö un dë bunu e, dee sëmbë, ee un lo’ u mbei sëmbë ku sëmbë ko fii ku deseei. Biga sö wan sëmbë o tja di në taa a dë miii u Gadu gbelingbelin. ");
INSERT INTO srmNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nöö un dë bunu e, dee sëmbë, ee sëmbë ta suku unu a toobi fu di un ta libi bunu a Gadu wojo hedi. Biga sö wan sëmbë dë a di Tii u Masa Gadu dendu kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nöö un dë bunu e, dee sëmbë, ee sëmbë ta kosi unu ta toobi unu ta mindi hii sootu pei hogi ta buta a unu hedi fu di un ta waka a mi baka hedi. ");
INSERT INTO srmNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Un musu ta wai da di dë e. Un musu ta piizii seei, biga a Masa Gadu Köndë ala woon feni wan gaan paima. Biga leti sö nöö wë de bi du ku dee tjabukama u Gadu dee bi dë bifö unu. ");
INSERT INTO srmNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nöö un haika e, dee sëmbë. Fa un ko nama ku mi aki, nöö un dë kuma satu da dee sëmbë u di goonliba aki. Nöö i sabi fa satu ta heepi tjika. Ma nöö ee a bi sa lasi di tesi fëën, nöö an bi o abi heepi a mundu möönsö e. A sitaati nöö i bi o sa tuwëën go, ka sëmbë o makisëën ku futu. Nöö un musu luku bunu fu wan lasi di tesi fuunu, fuun ko kuma satu di lasi ën tesi. ");
INSERT INTO srmNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nöö söseei un dë kuma wan lampu faja tu e, da hii dee sëmbë u di goonliba aki. Nöö i sabi nö? Te wan köndë dë a wan hei kununu liba, nöö te dee faja fëën ta sëndë nëën nöö di köndë dë an sa dë tjubitjubi. Hii sëmbë ta si ën kaa. Nöö söseei un musu dë tu e. Hii sëmbë musu ta si di libi fuunu fa a limbo tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Biga na wan sëmbë o sëndë faja nöö a butëën a wan tjubi kamian te ka sëmbë an sa si limbo ku ën. Nönö. Fa a o sëndëën dë, nöö a o hopo ën buta a liba be hii sëmbë a di wosu sa si soni ku di limbo fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","“Nöö sö nöö di libi fuunu musu dë a di goonliba aki e, dee sëmbë. A musu dë gbegedee kuma wan faja limbo. Nöö sëmbë o ko si dee bunu soni un ta du, nöö de o ta gafa di Tata fuunu di dë a liba ala. ");
INSERT INTO srmNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Dee sëmbë o, fa mi ko ta lei unu aki, ma ko u ko poi dee wëti Gadu da Mosesi fuu hoi e. Nönö. Nöö ma ko u ko poi dee soni dee fesiten tjabukama bi sikifi tu. Ma mi ko u ko mbei hii soni pasa kumafa dee soni dë sikifisikifi dë bi kë taki. ");
INSERT INTO srmNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Nöö un si hii dee soni dee dë sikifisikifi a di Buku nö? Wë mi sa taki da unu gbelin taa solanga dee soni u goonliba aki ku dee soni u liba ala dë eti, nöö na wan u dee soni sikifi a di Buku o fika di an o pasa e, te dou ku dee piki pisi fëën tuu. Hii de tuu seei o pasa. ");
INSERT INTO srmNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Nöö ee wan sëmbë i ta poi ee wan piki pisi seei u dee soni Gadu taki ta sösö de nöö i ta lei sëmbë u de du sö tu, nöö di sëmbë dë o dë di möön sösö wan a dee sëmbë dee Gadu ta tii dendu. “Ma ee wan sëmbë i ta hoi i seei a dee wëti dë liba nöö i ta lei otowan andi de kë taki, nöö hën o dë gaan heima a dee sëmbë Gadu ta tii dendu. ");
INSERT INTO srmNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Nöö mi taki da unu e, taa ee wan ta libi möön bunu a Gadu wojo möön dee Faliseima ku dee Sabima u Wëti, nöö wan o sa dë a di Njunjun Tii u Gadu dendu möönsö e. ");
INSERT INTO srmNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Wë nöö un bi jei fa de bi fan ku dee gaan sëmbë fuu a fesi taa ja musu kii sëmbë, ma ee i kii sëmbë nöö i musu kisi sitaafu fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Ma nöö mii taki da unu taa di sëmbë di hati fëën boonu ku di otowan fëën kaa, nöö hënseei musu kisi sitaafu tu e, kuma di sëmbë di kii sëmbë. Söseei di sëmbë di kosi di otowan fëën taku kosi nöö hënseei musu kisi sitaafu tu. Nöö di sëmbë di o kosi di otowan fëën taa a lau, nöö a musu mëni ën seei bunu, ee nasö a o go tja sitaafu a didibi faja. ");
INSERT INTO srmNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Nöö mi taki möön e, taa ee i go a di keikiwosu fii tja soni go da Gadu nöö hën i ko mëni taa wan sëmbë ta hoi i a bëë a wan sondi, ");
INSERT INTO srmNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nöö i musu disa di paima fii leti dë, nöö i go a di otowan go seeka di taki te i kaba bifö nöö i toona ko da Gadu di soni di i bi o dëën awaa. ");
INSERT INTO srmNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nöö ee wan sëmbë ta tja i go a kuutu u wan soni hedi, nöö fa i si un dë a pasi nango naandë kaa, nöö i musu biinga seei be un koti di taki wante. Biga ee i sai dë ta buuja te di felantima fii tja i go a kuutu, nöö soni i miti e. Biga dee kuutuma o buta i a dee siköutu maun, nöö dee siköutu o tuwë i go a dunguwosu. ");
INSERT INTO srmNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nöö mi taki da i gbelin taa solanga ja paka di möni de o kai da i fii paka teee dou ku di lasiti köpösënsi, nöö ja o sa kumutu dë möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Wë nöö un bi jei fa de bi fan ku dee gaan sëmbë fuu taa ja musu duumi ku wan mujëë na mujëë fii u wosu. Na sö de taki nö? ");
INSERT INTO srmNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma nöö mii taa di sëmbë di ta luku wan mujëë kuma a kë tei ën, nöö nëën hati a tei ën kaa e. ");
INSERT INTO srmNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","“Dee sëmbë o, ˻fa mi ta fan aki, un musu biinga fuun du fa un sa du fii waka a Gadu pasi e. Boo taki ën sö, taa˼ ee di fa i ta luku soni ku di wojo fii hën ta manda i fii du hogi, nöö a möön bëtë i diki ën puu tuwë e. Nöö söseei tu ee i kë du hogi ku di leti së maun fii, nöö a bëtë i koti ën tuwë tu. Biga a sa möön bëtë da i taa wan kamian fii sinkii poi ma i feni di libi u teego möön leki de hiti i ku telu tuwë go a di didibi faja. ");
INSERT INTO srmNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“De bi taki taa ee wan sëmbë tuwë di mujëë fëën nöö a musu dëën wan biifi be lanti si taa a tuwëën. ");
INSERT INTO srmNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma nöö mii taki da unu taa ee wan sëmbë tuwë hën mujëë ma na manu a tei nëën wosu, nöö a mbei di mujëë naandë ko jajo mujëë e. Nöö ee wan womi go tei sö wan mujëë, nöö hënseei booko Gadu wëti tu. Biga a tei wan oto sëmbë mujëë. ");
INSERT INTO srmNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Un bi jei fa de bi fan ku dee gaan sëmbë fuu möön taa te i tei Gadu në soi, nöö ja musu booko di soi dë möönsö. I musu du di soni nöömö. ˻Ma ee i tei wan oto soni soi, nöö di soi dë an hogi poi fu booko.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Ma nöö mii taki da unu taa wan musu soi möönsö e, kwetikweti. Wan musu tei liba ala soi ku ën biga ala di könubangi fu Gadu dë. ");
INSERT INTO srmNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nöö wan musu tei di goonliba aki soi ku ën tu, biga aki di bangi fëën dë ka a ta buta futu. Nöö söseei ja musu tei Jelusalen soi ku ën biga hën da di köndë u di Gaan Könu. ");
INSERT INTO srmNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nöö ja musu tei i hedi soi ku ën tu, biga fa i sai naandë, ja a’ kaakiti a i seei tjika fii mbei na wan niën u di uwii fii bia ko weti ee nasö baaka. “Hën mbei wë mi taki e, taa an dë fii soi möönsö ufö di soni i taki dë tuu. Ma te joo taki wan soni nöö i fan gbelin, nöö a bunu kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wë biga te i taki aai, a musu tan aai e. Te i taa nönö, a musu tan nönö. Ma ee i musu soi ufö de o tei taa tuu, nöö a go a di së u hogi kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nöö un bi jei tu fa de ta taki taa ˻du ku du na wisi˼. Ee wan sëmbë booko wan së wojo fii, nöö i musu toona booko wan së wojo fëën tu. Ee wan sëmbë naki i booko tanda nöö i musu toona naki di fëën tanda booko tu. Na sö de ta taki nö? ");
INSERT INTO srmNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","“Ma nöö mii taki da unu taa wan musu puu hatiboonu a wan sëmbë liba taa te a du i hogi nöö joo du ën hogi baka e. Ee di sëmbë hogi seei, ma ja musu libi sö ku ën. Ma ee wan sëmbë naki i baai maun a i bandja jesi, nöö i bia di oto së dëën be a naki möön. ");
INSERT INTO srmNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nöö ee wan sëmbë kë tja i go a kuutu fu di a kë di liba bisi fii hedi, nöö i dëën di liba bisi fii ku di basu wan tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ee wan sëmbë ta duwengi i fii waka ku ën wan hafu juu langa, nöö i waka ku ën wan hii juu langa e. ");
INSERT INTO srmNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ee wan sëmbë hakisi i sondi fii dëën, nöö i dëën. Ee a hakisi i soni fii leni ën, nöö i leni ën. Na niinga. ");
INSERT INTO srmNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nöö un bi jei de bi taki taa i musu lobi di sëmbë di ta libi bunu ku i, ma di felantima fii i sa buuse ën. ");
INSERT INTO srmNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Ma nöö mii taki da unu taa un musu lobi dee felantima fuunu e. Un musu ta begi da dee sëmbë dee ta du hogi ku unu. ");
INSERT INTO srmNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nöö te un du sö kaa, nöö woon djeesi unu Tata a liba kuma miii fëën gbelingbelin. Wë biga fa a sai dë, nöö te di sonu fëën ta jabi, nöö a ta jabi da dee bunu sëmbë ku dee hogi wan tuu. Te tjuba fëën ta kai, a ta kai te dou a hii sëmbë, dee ta libi bunu nëën wojo ku dee an ta libi bunu nëën wojo tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Nöö ee i ta lobi dee sëmbë dee ta lobi i nöö, ma ja ta lobi dee felantima fii, nöö un paima fëën seei joo feni? Biga sö nöö dee hogisonima u di goonliba aki ta libi u de kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ee i ta fan ku dee sëmbë i ku de ta fii nöö, nöö na wan apaiti soni i du dë e. Sö nöö dee sëmbë u di goonliba aki ta libi dee an sabi na wan wojo soni u Gadu möönsö. Ma i musu libi bunu ku hii sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Wë nöö mi taki e, taa un musu biinga be un libi söndö föutu te dou, leti kumafa unu Tata di dë a liba ala ta libi söndö föutu te dou.” Nöö sö Masa Jesosi ta lei dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","˻Nöö Masa Jesosi toona nango dou ku di lei fëën eti. A taa:˼ “Haika e, dee sëmbë, ee woon du wan soni fuun dini Gadu, nöö wan musu du ën fuun feni në a libisëmbë e. Biga ee i du ën fu sö hedi, nöö wan o kisi na wan paima a unu Tata a liba. Kaba u di taki di dë kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nöö söseei tu, ee joo da wan sëmbë wan soni fii puu ën a fuka, nöö ja musu tei ën ta bai basia a ganda mindi e, kumafa dee sëmbë ta pëë deseei u bumbuu sëmbë ta du. Biga de ta hopo a dee keiki ee nasö a sitaati ta bai ta konda soni u hii sëmbë musu si de taa sö de du wan gaan bumbuu soni. Nöö na sö un musu du, dee sëmbë. Biga mi taki da unu taa fa i si de du ën dë, nöö de an o kisi oto paima fëën a Gadu möönsö, biga de kisi di paima u de kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Ma te joo puu wan sëmbë a fuka, nöö i musu du ën a wan tjubi fasi kuma leti maun fii an saandi töötömaun fii ta du, töötömaun an saandi leti maun ta du. ");
INSERT INTO srmNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nöö di Tata fuu di ta si hii soni ee a tjubi seei, nöö hën o si ën nöö a o da i paima fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nöö söseei tu, te joo begi nöö ja musu ta du ën kumafa dee sëmbë ta pëë deseei u bumbuu sëmbë ta du. Biga de lobi u hopo begi a keiki dendu ee nasö a ganda mindi, be hii sëmbë musu si taa sö de sabi u begi tjika. Mi taki da unu taa fa i si dee lö sëmbë sai dë, de an o kisi na wan wojo soni a Gadu e. Tuu fëën seei wë di dë kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Ma te joo begi, nöö be i go fii a i dendu wosu nöö i tapa i döö, nöö i begi i Tata ka i dë tapatapa döö dë te i kaba. Nöö i Tata di ta si andi ta pasa a tjubii, hën o da i di paima fii. ");
INSERT INTO srmNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nöö te joo begi tu, nöö ja musu ta hai di fan nango langalanga nöömö e, kumafa dee sëmbë u di goonliba aki dee an sabi Gadu ta du. Fa de sai u de dë, de ta mëni taa te de ta begi longi sö nöö Gadu musu u jei de. ");
INSERT INTO srmNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma na sö un musu begi e. Biga ufö un go u go begi seei, nöö Gadu sabi gaanduwe kaa andi ku andi un abi fanöudu. ");
INSERT INTO srmNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ma te woon begi, nöö a di fasi aki un musu begi e, dee sëmbë: Ke, u Tata a liba o, hii sëmbë musu lesipeki i e, sabi taa i dë bumbuu limbolimbo. ");
INSERT INTO srmNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","U begi taa di Tii fii musu paaja a hii goonliba, be di fii kë pasa a goonliba aki leti kumafa a ta pasa a i a liba ala. ");
INSERT INTO srmNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nöö u begi i tu, fii da u dee soni u abi fanöudu fuu pasa u libi tide. ");
INSERT INTO srmNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nöö u begi i o, be i puu u a bëë fu dee hogi dee u ta du, leti kumafa i si u ta puu dee otowan fuu a bëë fu dee hogi de ta du u. ");
INSERT INTO srmNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nöö u begi i, taa na disa u da dee soni dee sa hai u tja go a di së u hogi e, ma puu u a di didibi maun. Sö fuun begi e, dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","15","“Biga mi taki e, taa ee un ta hoi sëmbë a bëë u dee hogi de ta du unu, nöö unu Tata a liba ala o hoi unu a bëë tu e, u dee hogi dee un ta du. Ma ee un puu di otowan fuunu a bëë, nöö unu Tata a liba ala o puu unu a bëë tu. ");
INSERT INTO srmNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nöö mi taki da unu möön e, taa te woon hoi begi söndö njan, nöö wan musu dë gudjuu kuma dee sëmbë dee ta mbei deseei u bumbuu sëmbë. Fa de sai u de dë, de ta gudju fesi fu hii sëmbë musu si taa aai, de da bumbuu sëmbë, sö de ta hoi begi tjika söndö njan. Nöö mi taki da unu taa fa i si de ta du naandë, tuu u de seei di dë kaa e. De an o kisi na wan kodo soni a Gadu möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Ma te joo hoi begi söndö njan, nöö be i wasi te i kaba, lo’ fatu a sinkii, kan i uwii te i kaba, seeka, ");
INSERT INTO srmNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","be sëmbë an musu sabi taa sö i ta hoi begi söndö njan. Nöö di Tata fii di ta si hii soni ee a dë tjubitjubi seei, nöö hën o sabi nöö a o da i wan paima. ");
INSERT INTO srmNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Wë nöö mi taki möön e, dee sëmbë, taa wan musu biinga fuun abi hia gudu a goonliba aki. Biga aki kopikopi sa njan dee gudu fii, ee nasö sukufu sa poi de. Fufuuma sa ko fufuu hii dee soni i abi tja go, i fika ku maun tjololoo. Sö di libi a goonliba aki dë kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hën mbei i musu biinga fii libi a sö wan fasi taa i ta lai gudu a Masa Gadu Köndë. Biga ala kopikopi an o ko njan mën, sukufu an o kisi ën, fufuuma an o ko dou dë u fufuu ën tja go. Nöö ala fii tjubi dee gudu fii e. ");
INSERT INTO srmNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Biga ka gudu fii dë, nöö naandë di hati fii ta dë tu. Sö wë a dë e, dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Boo taki ën sö taa di wojo fii di dë a i sinkii dë, nöö a dë kuma wan lampu faja fii sa si soni limbolimbo. Nöö te i ta si soni sö kaa, nöö hii libi fii o dë gbegedee limbolimbo. ");
INSERT INTO srmNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma nöö ee i ta luku dee soni u di goonliba aki ku di wojo fii söndö i mëni Gadu, nöö joo fika a dungu. Di wojo fii di bi musu heepi i fii si soni limbolimbo an heepi i möönsö, ma i fika leti a dungu dë. ");
INSERT INTO srmNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Haika e, dee sëmbë, na wan sëmbë sa dini tu masa makandi e. I musu fu lobi wan möön wan, ee nasö joo hëngi a wan möön wan. Nöö söseei tu, ja sa waka a Masa Gadu baka ku dee gudu u goonliba aki baka makandi e, kwetikweti. ");
INSERT INTO srmNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nöö mi taki da unu taa ja musu ta a’ bookohedi ta hakisi taa: ‘Maingë, andi seei mi o feni u njan?’ nasö ‘Unsë mi o feni wata u bebe baa?’ nasö i ta hakisi taa: ‘Naasë seei mi o feni koosu u mi tapa di sinkii u mi aki?’ Nönö, na sö i musu ta pakisei e. Biga fa i feni libi a Gadu dë kaa, nöö an bunu möön soni u njan ku soni u bebe nö? Nöö di sinkii fii wë? An bumbuu möön di koosu fii bisi nëën nö? ");
INSERT INTO srmNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wë nöö di Gadu da i dee gaan soni naandë kaa, nöö an sa da i dee möön piki soni kuma njanjan ku koosu tu nö? “Un luku dee fou ta buwa ta lontu a liba ala. Fa de sai naandë, nöö de aan goon ta paandi fu de sa feni njanjan. De an abi na wan suwa möönsö ka de sa tjubi njanjan tu. Ma de ta njan këdë biga di Tata fii di dë a liba ala ta sölugu de. Wë nöö mi taki da unu taa un bumbuu gaanfa möön dee fou e! ");
INSERT INTO srmNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Fa un dë aki sö, undi fuunu sa libi tjë sö seei pasa möön leki fa Gadu bi buta da i, fu di i ta booko hedi mbei? Na wan sëmbë e! ");
INSERT INTO srmNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wë ee ja sa heepi i seei a dee pikipiki soni dë, nöö andi i ta booko hedi ku koosu soni u du? “Un luku dee folo naandë, fa de hanse. Ma na deseei ta mbei dee bisi u de, nöö de an ta wooko u de bai de tu. ");
INSERT INTO srmNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma nöö mi taki da unu e, taa fa Könu Salumon bi ta bisi dee gaan waiti bisi fëën seei, ma dee bisi fëën an bi ta hanso kuma dee folo naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","“Nöö fa Gadu ta bisi dee sösö uwii ku hanse folo dë, an dë taa de ta sai dë longi seei. Te mamate i si taa de dë sö hanse, te u sapate de puu kai dëë u de tja go tjuma. Wë nöö unu wë? Na möön hesi Gadu o sölugu unu ku soni u bisi tu nö? Ee, dee sëmbë aki, unfa seei a waka te nöö di biibi fuunu piki sö baa? ");
INSERT INTO srmNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Fëën mbei mi taki da unu taa, wan musu ta booko hedi taa: ‘Maingë, unsë woo feni soni u njan? Unsë woo feni wata u bebe? Unfa woo feni koosu u bisi?’ ");
INSERT INTO srmNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mi taki da unu taa dee sëmbë an dë ku Masa Gaangadu a wan së, de ta a’ bookohedi a dee lö pei soni dë. Ma unu Tata a liba bi sabi gaanduwe kaa taa un abi dee lö soni naandë fanöudu. ");
INSERT INTO srmNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ma nöö a di fosu kamian un musu biinga fuun ta dë a di Tii u Masa Gadu dendu ta libi kumafa a kë, nöö hii dee soni u taki dë tuu woon feni. ");
INSERT INTO srmNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Nöö sö mi ta taki da unu e, dee sëmbë, taa ja musu abi bookohedi fu dee soni fu amanjan, biga te amanjan dou, nöö a sa sölugu fëën seei. Nöö hiniwan daka ta abi hën soni fii booko hedi nëën te tjika kaa.” ");
INSERT INTO srmNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nöö hën Masa Jesosi ta fan eti, a taa: “Wë nöö mi taki da unu taa na kuutu sëmbë e, nöö sëmbë an o kuutu i tu. ");
INSERT INTO srmNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Biga fa i si i ta kuutu sëmbë dë, nöö söseei de o toona kuutu i baka. Biga ku di wan seei maaka di i tei maaka di otowan fii, nöö ku ën seei a o toona maaka i baka. ");
INSERT INTO srmNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Boo taki ën sö taa i ta si wan sakisi a i baaa wojo, ma nöö wan gaan gindi baliki dë a i seei wojo, ja ta si ën. ");
INSERT INTO srmNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nöö hën i sai dë ta taki da di otowan fii taa: ‘Tan e womi, be mi puu di sakisi a i wojo da i,’ ma nöö di gaan gindi baliki dë leti a i seei wojo goboo naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","I bödjëëma, fa i si i ta mbei i seei gaan bumbuu sëmbë möön di otowan fii naandë, faandi mbei ja sa puu di gaan baliki di dë a i seei wojo, nöö joo si möön limbo fii puu di sakisi a di otowan fii wojo? ");
INSERT INTO srmNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nöö mi taki möön e, taa ˻i musu ta mëni i seei ku di sëmbë di joo ta konda wan bumbuu soni da. Biga˼ te i tuwë wan bumbuu soni da dagu, nöö a o disëën dë bia ko kisi i njan tënë pisipisi. Nöö söseei tu, ee joo tuwë bumbuu soni da hagu, an o si ën u soni. Ma a o bia makisëën ku futu fiönfiön pasa go fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nöö un haika e, dee sëmbë. Un musu ta begi Masa Gaangadu soni, nöö woon kisi. Un musu ta suku soni nëën, nöö woon feni. Un musu ta naki ën döö nöömö, nöö a o jabi döö da unu. ");
INSERT INTO srmNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wë biga di sëmbë di ta begi Gadu, nöö hën o kisi. Di sëmbë di ta suku soni nëën, nöö hën o feni. Di sëmbë ta naki ën döö, nöö hën a o jabi döö da. ");
INSERT INTO srmNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Biga kumafa un dë aki, ee di mii fii hakisi i wan pisi bëëë, undi fuunu o go tei sitonu dëën? ");
INSERT INTO srmNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ee a hakisi wan pisi fisi nöö joo go tei wan pisi sindeki tja ko dëën ö? Wë nönö, ja o du sö e. ");
INSERT INTO srmNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Biga hii fa i si hati fii an dë bumbuu te dou seei, ma i ta da dee mii fii bumbuu soni. Nöö di Tata fuunu di dë a liba ala wë? Na möön hesi a o da unu bumbuu soni te un begi ën nö? ");
INSERT INTO srmNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nöö mi taki e, i musu libi ku sëmbë leti kumafa i seei kë u de musu libi ku i tu. Biga te i libi sö kaa, nöö hën da i piki di mama u hii dee wëti dee Gadu bi buta Mosesi ku dee fesiten tjabukama u de sikifi buta a di Buku fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Wë dee sëmbë, fa u dë a goonliba aki, nöö tu dööbuka dë di sëmbë ta denda e, wan gaan wan ku wan piki wan. Nöö un musu biinga fuun denda a di piki wan. Biga ee i denda a di gaan wan nöö joo go dou a di didibi faja. Nöö di pasi di ta tja i go a di döö dë baai e, nöö an taanga u waka. Hia sëmbë ta tei ën. Ma ee i denda a di piki döö nöö joo feni di libi u teego. Ma di pasi di ta tja i go dou a di piki döö dë piki tu, nöö a taanga u waka. Nöö biti sëmbë ta waka nëën. ");
INSERT INTO srmNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nöö mi taki e, dee sëmbë, taa un musu mëni unu seei bunu ku dee sëmbë dee ta waka ta ganjan sëmbë taa de ta tja Gadu buka, ma na Gadu hën manda de. Dee lö sëmbë naandë, de dë leti kuma wan takumbeti di bisi sikafu puuma te a kaba, nöö a go a dee sikafu dendu ta mbei kuma hënseei da sikafu tu. Ma hii fu di dë takumbeti hati a abi. Sö dee ganjansëmbëma ta libi. ");
INSERT INTO srmNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma fa de o ko dë seei, joo sabi de e, biga joo si a di libi u de taa ganjansëmbëma de dë. “Biga ja sa booko bumbuu fuuta a matunga e. ");
INSERT INTO srmNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Di pau di bi ta pai bumbuu njanjan nöö bumbuu njanjan nöö a o ta pai nöömö, nöö di pau di an bi naa pali bumbuu njanjan nöö an o pai ën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wan bumbuu pau an sa pai poipoi njanjan, söseei wan poipoi pau an sa pai bumbuu njanjan. ");
INSERT INTO srmNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nöö ee wan pau dë an ta pai bumbuu soni möönsö, nöö de o faa ën gboogboo tuwë a gufalu tjuma puu dë. ");
INSERT INTO srmNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hën mbei wë mi taki taa i sa sabi dee sëmbë u bi taki dë a di libi u de. ");
INSERT INTO srmNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Biga na hii sëmbë di ta kai mi ‘Masa’ ta dë a di Tii u Gadu dendu fu de dou nëën köndë e. Ma dee sëmbë dee ta du dee soni dee mi Tata kë, nöö de nöö o dou nëën köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Nöö hën mbei te di gaan kuutu daka dou, nöö mi o jaka sömëni sëmbë puu a mi fesi taa ma sabi de. Nöö de o fia taa: ‘Masa, unfa wë? Na u bi da sëmbë buka a i në nö? Na u bi jaka sömëni gadu puu a sëmbë hedi ku di në fii ö? Sömëni hia gaan foondo wooko u bi du a i në, nöö unfa a waka ja sabi u?’ ");
INSERT INTO srmNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Nöö mi o piki de taa: ‘Ambë? Mi? Na wan ten seei mi bi sabi unu möönsö e. Un waka pasa kumutu a mi fesi naandë, un takusëmbëma!’ ” ");
INSERT INTO srmNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nöö hën Masa Jesosi da wan oto möön, a taa: “Ee wan sëmbë i ta jei dee soni mi ta fan ku unu aki nöö i tei de fu tii i libi, nöö sö wan sëmbë mi ta si ën kuma wan gaan fusutan sëmbë di go u go mbei wan wosu fëën. Nöö a seti ën ku wan goonsei taangataanga gingin kuma sitonu. ");
INSERT INTO srmNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nöö di a mbei di wosu te a kaba, nöö hën wan gaan tjuba kai a mundu bigi möön hii soni singi di kamian zuuu piii, gaan ventu ko tee ta naki di wosu. Tee a pasa go, di wosu dë fëën gingin a pë naandë eti. An booko kai seei möönsö, biga de seti ën bunu. ");
INSERT INTO srmNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ma nöö di sëmbë di ta jei di lei u mi aki, ma an tei ën faa libi kumafa mi taki, nöö hën mi ta si kuma wan gaan don sëmbë di mbei di wosu fëën a sandu liba. ");
INSERT INTO srmNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nöö hën wë tjuba kai singi di kamian dë pii, di ventu ta böö ta naki di wosu te wan pisi hën a booko kai djolou kaba a sösö fijaa.” Nöö a sö wan fasi Masa Jesosi lei dee bakama fëën tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nöö fa a fan dë, hii sëmbë tuu foondo gaanfa seei. ");
INSERT INTO srmNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","De taa: “Di sëmbë aki sö, an dë kuma dee Sabima u Wëti e. Biga hën, a ta konda soni da u gbelin seei kuma hënseei da basi fëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nöö hën Masa Jesosi bazia di kuun ko a goon, nöö hën dee gaan hia sëmbë ku ën bi dë ala, hën de dë nëën baka ta ko. ");
INSERT INTO srmNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te wan pisi hën wan sëmbë waka ko nëën, hën a tjökö kini a goon nëën fesi. Di sëmbë aki siki tjina siki hën a begi Masa Jesosi taa: “Masa o, gaantangi, ee i kë, nöö i kula mi be mi ko bunu baa.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Hën Masa Jesosi tuwë maun panjëën, hën a taki dëën taa: “Aai, mi kë. Ko bunu fii e.” Nöö hën wantewante dë hën a ko bunu. Sinkii fëën limbo gbegedee. ");
INSERT INTO srmNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nöö hën Masa Jesosi bai ën taa: “Womi, fa joo go aki, nöö na konda di soni aki da na wan kodo sëmbë e. Ma be i waka tololoo go a di begima u keiki be de si taa i ko bunu. Nöö i tja di paima go paka Masa Gadu kumafa di wëti dë taa te wan sëmbë i ko bunu u sö wan siki nöö sö i musu du.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nöö a baka u di dë, hën Masa Jesosi toona go a Kapenaumi. Nöö fa a go dou naandë, hën wan hedima u dee Loomë köndë sodati ko nëën. ");
INSERT INTO srmNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Hën a taki dëën taa: “Masa o, mi ko a i aki. Wan u dee futuboi u mi suwaki teee piki sö fika a dëdë. A dë a wosu kandikandi, nöö a dë a gaan fuka seei te an sa buli. Nöö hën mi ko a i ko begi i gaantangi be i kulëën da mi.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Hën a piki ën taa: “Söö, mati mi jei. Mi o go nëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma nöö hën di sodati hedima toona taki dëën taa: “Wë Masa o.” A piki. A taa: “Ma bumbuu tjika sö e, fii ko a mi wosu. Ma nöö i sabi nö? Be i fan leti ka i si i sai aki nöö, nöö di futuboi u mi o ko bunu kaa. Biga sö mi sabi taa i abi taki tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“Biga miseei, fa mi dë aki, mi sabi andi da taki. Biga mi dë a sëmbë basu kaa, nöö miseei abi sömëni sodati a mi basu tu. Nöö ee mi taki da wan u de taa be a go ala, nöö a o go. Ee mi taki dëën taa be a ko aki, nöö a o ko. Ee mi manda wan u dee futuboi u mi faa du wan soni, nöö a o du ën. “Nöö söseei mi sabi taa i abi taki tu, te a siki liba seei. Nöö hën mbei mi taa fii fan leti ka i dë aki nöö, nöö di futuboi u mi o ko bunu kaa.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nöö di Masa Jesosi jei fa di sodati hedima fan dë, nöö a bigi dëën tee na soni. Hën a fan ku dee Dju sëmbë dee ta waka ku ën dë taa: “Dee sëmbë, i si fa di sëmbë aki fan ö? Wë mi taki da unu seei gbelin taa, fa mi ta waka ta lontu a u Isaëli köndë aki, nöö ma si di biibi u di sëmbë aki wan daka e. Ma nöö hën an dë Isaëli sëmbë seei faa musu biibi sö. ");
INSERT INTO srmNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Nöö un mëni unu seei e. Biga mi taki da unu taa sömëni sëmbë na u Dju ˻kuma di sodati hedima i si aki˼ o kumutu a dee peipei köndë u goonliba ko biibi a mi disa unu. Nöö de o go sindo makandi ku dee gaan sëmbë fuunu, dee Abahamu, Isaki, Jakopu sö, ka Masa Gaangadu dë könu, ta njan di gaan piizii. ");
INSERT INTO srmNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma nöö un dee sëmbë bi musu feni di piizii dë, nöö woon fika söndö ën e. Dee basia u Gadu Köndë o tuwë unu go a döö a dungudungu ala, nöö na ala woon dë ta bai ta kai olo ta njan tanda, ma an o heepi möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nöö di a bai de sö kaa, nöö hën a bia fan ku di sodati hedima awaa, a taa: “Mati o.” Hën a piki. Hën a taa: “Toona go fii a wosu e. Di soni di i kë, nöö a pasa leti kumafa i biibi naandë.” Nöö fa a fan dë, nöö hën di juu dë seei hën di futuboi u di sodati ko bunu kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nöö hën Masa Jesosi kumutu dë, hën a go a di bakama fëën de kai Petuisi wosu. Nöö hën a go si di mai u Petuisi sikisiki pëtëëë a bedi naandë. Fëbë nöö kisi ën sö. ");
INSERT INTO srmNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nöö hën a tëndë maun panjëën, hën di mujëë ko bëtë wantewante. Nöö hën a hopo go seeka soni u njan da Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hën di sapate buka dë seei, hën de ta tja wanlö hia sëmbë ta ko a Masa Jesosi faa musu kula de. Sömëni u dee sëmbë naandë dë ku soni a hedi, nöö hën Masa Jesosi ta jaka de ta puu a de. Wan wöutu nöö a ta taki, nöö dee soni ta kumutu a de liba go kaa. Sö a abi kaakiti tjika, nöö sö a kula hii dee suwakima de tja ko nëën dë tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nöö fa Masa Jesosi ta du dë, nöö a kai makandi ku di soni di tjabukama u Gadu de kai Jesaaja bi sikifi a fesi di a taa: A tei dee suwaki fuu ku dee siki fuu tuu tja go. A puu de a u liba. ");
INSERT INTO srmNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nöö hën de dë te wan pisi, hën Masa Jesosi si fa dee hia sëmbë ko ta lontu ën, nöö hën a fan ku dee bakama fëën taa: “Un boo koti wata go a di oto së banda ala ufö e.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma nöö di juu dë, hën wan u dee Sabima u Wëti ko a Masa Jesosi. A kai ën taa: “Mësitë.” A piki. A taa: “Mi kë ko ta waka ku i o, hii kamian ka i nango.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nöö hën Masa Jesosi piki ën taa: “˻I fan bunu e, mati. Ma fii waka a mi baka na sösö soni e.˼ Biga fa dee mbeti ta dë a sabana dë, nöö de abi baaku ta libi. Söseei dee fou dee ta buwa ta lontu i si dë, nöö de abi wosu a dee pau hedi. Ma nöö Mi di ko dë Libisëmbë Mii aki, ma abi kamian ka mi ta duumi e.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nöö hën wan oto sëmbë bi dë ku ën dë tu, hën a taki dëën taa: “Wë miseei kë waka ku i tu, ma te mi tata dëdë mi bei te mi kaba bifö.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nöö hën Masa Jesosi piki ën taa: “Mati o, be dee sëmbë dee dë paatipaati ku Gadu bei de na de e. Ma be i ko go ku mi nöö.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nöö hën Masa Jesosi subi a boto, hën ku dee bakama fëën, ");
INSERT INTO srmNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","hën de ta koti nango a di oto së banda. Ma te u de mëni, hën wan gaan ventu ko, a bigi möön hii soni. Hën di wata ta seki nango a di boto dendu teee kuma a sa singi di boto. Ma hii u di dë, Masa Jesosi dë pii a wan kamian u di boto ta duumi. ");
INSERT INTO srmNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nöö hën dee bakama fëën kule go nëën go kai ën taa: “Masa o! Masa!” Hën a piki. De taa: “Heepi u o! Woo kaba a wata!” ");
INSERT INTO srmNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hën a taki da de taa: “Womi, andi un ta fëëë sö u du? Piki nöö di biibi fuunu piki sö nö?” Nöö fa a fan dë, hën a hopo gandji da di ventu ku di wata taa: “Un tan pii!” Nöö wantewante dë hën di wata kötö piii. Di ventu kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nöö di dee bakama fëën si sö kaa, nöö a foondo de te na soni. De luku de na de taa: “Womi, ambë seei da di sëmbë aki, womi? Te a fan ku ventu ku wata nöö de ta piki. A bigi da u o. Poosian nöö a abi sö.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nöö hën de go dou a oto banda a di pisiwata u dee Galasëni sëmbë. Nöö fa de kumutu a tela naandë, hën de ko miti ku tu womi ta libi a wan geebi naandë. Dee sëmbë dë, de dë ku wanlö taku soni a de liba, nöö de ta hogi tee na wan sëmbë tjika u ko a di kamian ka de sai dë. ");
INSERT INTO srmNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nöö di de si Masa Jesosi kaa, hën de bai kai logologo wolo taa: “Ambë ta ko dë, ju di Mii u Gaangadu dë! I ta ko fii da u sitaafu bifö di daka dou nö?” Sö de bai. ");
INSERT INTO srmNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nöö di juu dë, wanlö hia hagu bi dë te ala ta pii soni ta njan. ");
INSERT INTO srmNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hën dee taku soni dee dë a dee sëmbë liba naandë begi Masa Jesosi taa: “Wë ee joo jaka u puu aki, nöö gaantangi da u pasi fuu go a dee hagu ala.” ");
INSERT INTO srmNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hën Masa Jesosi piki de taa: “Un go!” Nöö fa a fan dë, wantewante hën de kumutu a dee sëmbë liba go a dee hagu. Nöö hën dee hagu kule ku baai gbulululu bazia wan kununu dë teee go kai a wata djolou dëdë tuu fijaa. ");
INSERT INTO srmNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma nöö di dee sëmbë bi ta luku dee hagu si sö, nöö hën de kule go a ganda go konda taa sö wan soni pasa ku dee sëmbë dee bi dë ku dee taku soni a hedi naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nöö hën hii di köndë booko gililii ko miti ku Masa Jesosi. Nöö hën de begi ën taa gaantangi, be a kumutu a di pisiwata u de dë go fëën a oto kamian. ");
INSERT INTO srmNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wë nöö di dee Galasëni sëmbë taki sö, hën Masa Jesosi ku dee bakama fëën toona subi a boto. Hën de koti wata toona go a di oto së banda ka de bi kumutu, hën de go a di köndë ka Masa Jesosi ta libi. ");
INSERT INTO srmNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nöö fa de ko dou, hën de tja wan lan sëmbë ko nëën faa kulëën. A dë kandikandi a wan kama liba. Nöö di Masa Jesosi si fa dee sëmbë dee tja di womi ko nëën dë ta biibi ën tjika, hën a taki da di womi taa: “Womi, na fëëë e. Masa Gaangadu da i paadon u dee hogi dee i bi du. An o hoi i a bëë möön.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma nöö so u dee Sabima u Wëti sai naandë, hën de kuutu ku de na de taki taa: “Womi, un luku fa a ta mbei kuma hën da Gadu.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma nöö Masa Jesosi saandi de ta pakisei kaa, hën a piki de taa: “Dee sëmbë o, unfa un ta mëni hogi u mi a unu hati sö? ");
INSERT INTO srmNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Be mi hakisi unu wan soni. Fii taki da sö wan sëmbë taa Gadu puu ën a bëë, naa fii taki dëën taa be a hopo waka go, undi u dee tu soni sa möön fukë u taki ku buka? ˻Na di fosuwan nö? Biga sëmbë an sa go a Gadu faa go hakisi ee di soni i taki dë ee tuu, ee ganjan.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Ma nöö un luku, mi o toona fan ku di womi aki möön. Nöö joo si fa Mi di ko dë Libisëmbë Mii aki abi makiti tjika tuu u puu di sëmbë aki a Gadu bëë.” Hën a bia fan ku ën taa: “Womi.” A piki. A taa: “Mi taki e, hopo taanpu, nöö i tei di kama fii, nöö i go a wosu.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nöö fa a fan dë, hën wantewante sö hën di womi di bi dë lanlan dë hopo vu taanpu a hii dee sëmbë fesi naandë. Hën a tei di kama fëën hën a waka go fëën nëën wosu. ");
INSERT INTO srmNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nöö fa di soni pasa naandë, hën dee hia sëmbë bi sai dë da Masa Gadu tangi e. De gafëën seei fu di a da libisëmbë sö wan gaan kaakiti. ");
INSERT INTO srmNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nöö hën Masa Jesosi kumutu dë, hën a ta waka nango. Te wan pisi, hën a si mi, Mateosi, dë sindosindo a mi kantoo naandë ta pii lanti möni. Hën a kai mi taa: “Mati.” Hën mi piki. Hën a taa: “Ko go ku mi e. Ko ta waka a mi baka.” Hën di a kai mi sö, hën mi hopo wante ko ta waka nëën baka. ");
INSERT INTO srmNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nöö baka u di dë, nöö hën mi kai Masa Jesosi ku dee oto bakama fëën fu de ko njan ku mi a mi wosu. Nöö fa u go sai dë, nöö wanlö oto sëmbë ko dë tu, dee ta pii lanti möni kuma miseei, ku wanlö oto sëmbë lanti ta si kuma poipoi sëmbë u di köndë, de tuu ko makandi a mi Mateosi wosu naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nöö hën dee Faliseima ko si u dë, hën de bigi ta buja ku dee oto bakama u Masa Jesosi taa: “Unfa a waka di mësitë fuunu ta sindo ku dee pii-lanti-mönima ku dee oto poipoi sëmbë u di köndë ta njan a wan tafa?” ");
INSERT INTO srmNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nöö fa de fan dë, hën Masa Jesosi jei gbolo. Hën a taki da de taa: “Dee sëmbë un haika, mi o hakisi unu wan soni.” Hën de taki aai. Hën a taa: “Ambë un sabi abi data fanöudu, dee sëmbë dee dë bumbuu naa dee sikima?” ");
INSERT INTO srmNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hën a taa: “Mi o tei wan soni fu Gadu Buku konda da unu e, nöö un musu pakisei bunu ee andi a kë taki. Gadu taki e, taa: Fa un ta tja dee mbeti ta ko ta kii da mi aki, nöö na dee lö soni dë mi kë e. Ma mi kë fuun abi tjalihati u sëmbë. Hën nöö wë mi ta suku a unu. Sö di Buku taki. “Wë nöö fa mi ko a goonliba aki, nöö ma ko u kai un dee gaan bumbuu sëmbë e. Nönö. ˻Biga mi si taa un dë fa un kë kaa.˼ Ma mi ko u ko kai dee sëmbë dee sabi taa de an ta libi bunu kuma dee aki, be de bia libi fu mi sa heepi de puu de a dee hogilibi u de.” Sö Masa Jesosi fan ku dee Faliseima. ");
INSERT INTO srmNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nöö baka u di dë, hën dee bakama u Johanisi di Dopuma ko a Masa Jesosi. Hën de taa: “Wë u ko a i aki ko hakisi i wan soni. So juu u ku dee Faliseima ta begi söndö njan kumafa di wëti taki, wë ma wa ta si i ku dee bakama fii ta du sö. Un ta njan ta bebe kodo. Nöö u kë sabi faandi mbei.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nöö hën Masa Jesosi piki de taa: “Haika e. Te wan womi ta tööu, nöö te de dë a di piizii dendu nöö dee sëmbë di tööuma bi tei u ta seeka soni dëën, nöö de ta wai biga a dë leti a de dendu naandë. Ma nöö te di juu dou de ko puu ën a de dendu bifö de o dë söndö njan ta kusumi awaa. “˻Ma nöö fa mi ta fan ku unu aki, ma a sa toobi unu fuun tei.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Biga de an ta tei wan njunjun koosu pisi lapu wan awoo koosu e. Biga te i wasi ën, nöö di njunjun koosu o hai disa di awoo wan, nöö di soni o ko möön hogi. ");
INSERT INTO srmNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Söseei de an ta tei njunjun diingi lai a wan awoo mbeti kakisa saku e. Biga di njunjun diingi o soopu, ma nöö di saku an o sa soopu möön biga a gaandi kaa. Te wan pisi a o basiti gboo latja, tuwë di diingi tuu fiaa. Nöö a ko dë taa di saku ku di diingi tuu kaba a sösö. “Ma njunjun mbeti kakisa saku fii tei, nöö i lai di njunjun diingi nëën te i kaba e. Nöö te di diingi ta soopu nöö di saku seei o ta soopu tu. Nöö di diingi o dë bumbuu nöö di saku seei o dë bumbuu tu.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nöö Masa Jesosi an kaba u fan seei, nöö hën wan fesima u Dju keiki ko suti kini a goon nëën fesi. Hën a taki dëën taa: “Mësitë o, mi ko a i aki ko begi i taa wan mujëë mii u mi suwaki teee fa u dë aki a dë seei a dëdë ku libi maun. Nöö hën mi ko hakisi i ee i sa ko buta maun nëën da mi be a toona ko libi.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nöö hën Masa Jesosi piki ën taa: “Antoobi, mati. Un boo go.” Nöö hën a hopo, hën ku u dee bakama fëën, hën u nango. ");
INSERT INTO srmNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Te wan pisi hën wan mujëë waka ko a u baka dë. Nöö di mujëë dë bi abi wan siki, tuwalufu jaa longi soni ta kule nëën an ta koti möönsö. Ma nöö di a si Masa Jesosi ta ko dë, hën a waka saapi ko nëën baka, hën a panjan di koosu buka fëën tjë sö. ");
INSERT INTO srmNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Biga a ta pakisei nëën hati taa: “Ee mi sa nama tjë seei a di koosu fëën, nöö mi libi kaa.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nöö fa u taki dë, hën Masa Jesosi bia luku, hën a si di mujëë. Hën a taa: “Mujëë o, na fëëë e. Di biibi di i abi a mi liba dë heepi i kaa.” Nöö wantewante seei di mujëë ko bëtë gbegedee u di siki fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nöö hën Masa Jesosi nango te a di wosu u di hedima u keiki di bi kai ën dë. Nöö fa a go dou, hën a si wanlö baakuma sai dë kaa ta böö foloiti, ˻kumafa di guwenti fuu dee Dju sëmbë dë te wan sëmbë dëdë˼. Hia sëmbë sai dë ta bai ta këë tee di kamian ta mbei wööö seei, biga de si taa di mujëë mii dëdë kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hën Masa Jesosi taki da de taa: “Dee sëmbë, un hai kumutu aki da mi pasi. Biga na dëdë di mii dëdë e. Duumi nöö a ta duumi.” Ma nöö di de jei a taki sö, nöö hën dee hia sëmbë dë lafu ën mbei ën fa te a bigi. ");
INSERT INTO srmNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nöö hën dee sëmbë dee abi di wosu mbei dee sëmbë go a döö. Hën Masa Jesosi pasa go dou ka di mujëë mii dë, hën a panjëën a maun. Nöö fa u mbei dë, wantewante naandë hën di mujëë mii weki hopo taanpu. ");
INSERT INTO srmNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nöö fa a du dë, hën di soni bigi da sëmbë tee di buka paaja dou hii di pisiwata naandë tuu taa sö wan foondo soni Masa Jesosi du. ");
INSERT INTO srmNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nöö hën Masa Jesosi kumutu naandë. Hën a ta waka nango te wan pisi, nöö hën tu bookowojoma ta ko nëën baka ta bai seei ta kai ën taa: “Na i da di bakamii u Könu Dafiti ö, ˻di Gadu bi paamusi taa a o manda ko faa heepi u˼? U begi i gaantangi, be i a’ tjalihati fuu nöö i heepi u o!” Sö de ta bai ta ko nëën baka nöömö. Ma Masa Jesosi an piki de möönsö, a pasa go fëën a wosu. ");
INSERT INTO srmNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Te wan pisi, hën de go dou nëën ka a dë a wosu dendu naandë. Nöö hën a hakisi de taa: “Wë dee sëmbë, fa un ko a mi aki, nöö un ta biibi tuutuu taa mi sa kula unu nö?” Hën de taa: “Aai, Masa, u ta biibi e.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hën a taki aai. Nöö hën a nama maun a de wojo hën a taki da de taa: “Söö. Wë be a pasa ku unu leti kumafa i si un ta biibi dë e.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nöö fa u mbei dë, hën wojo u de tu sëmbë dë ko limbo seei gbegedee. Ma nöö hën Masa Jesosi bai de taanga taa: “Wan musu kondëën da na wan sëmbë e!” ");
INSERT INTO srmNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma hii fa a bai de dë seei, ma de paaja di soni a du dë te dou hii di köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nöö hën Masa Jesosi ku u dee bakama fëën kumutu naandë. Nöö di u nango, hën de tja wan womi ko nëën faa musu kulëën da de. Di sëmbë aki abi wan soni nëën hedi ta tapëën buka te an sa fan. ");
INSERT INTO srmNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nöö hën Masa Jesosi bai ën puu nëën liba tefa a kaba, nöö wantewante dë hën di womi toona ko ta fan baka. Nöö fa dee gaan hia sëmbë bi sai naandë si di soni pasa dë, hën de taa: “Hëën, aai maingë, u si foondo soni tide di wa bi si a u köndë aki wan daka.” ");
INSERT INTO srmNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma nöö dee Faliseima bi sai dë tu, hën de bai taa: “Höön, andi wë! Wan si taa di hedima u didibi hën ta dëën kaakiti faa jaka dee soni nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nöö hën Masa Jesosi ta waka ta lontu a dee gaangaan köndë ku dee pikipiki köndë fuu dee Dju sëmbë tuu te dou. A nango a dee keikiwosu fuu ta lei sëmbë soni u Gadu ta konda di Bunu Buka da de kumafa di Njunjun Tii u Gadu dë. Nöö hiniwan sooti pei siki di sëmbë abi kaa, de tuu a ta kula. ");
INSERT INTO srmNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma nöö fa a si dee gaan hia sëmbë ta ko nëën nöömö dë, nöö tjali u de kisi ën teee. Biga a si taa de dë fukafuka weiwei, kuma wanlö hia sikafu dë a mundu söndö sëmbë u kiija de. ");
INSERT INTO srmNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nöö hën a bia fan ku u dee bakama fëën, a taa: “Dee sëmbë o, a tjali da mi e. Wan si fa dee sëmbë ta ko gidjii nöömö a mi nö? De dë kuma wan gaan goon njanjan lepilepi fii koti buta a suwa, ma wookoma biti poi o. ");
INSERT INTO srmNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nöö un musu begi di goon Masa, be a manda möön hia wookoma fu de koti di njanjan buta a suwa.” ");
INSERT INTO srmNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","4","Söö. Wë a di pisi aki woo kai dee në fuu dee bakama u Masa Jesosi dee a bi tei a dee otowan mindi, fuu dë dee apaiti tjabukama fëën de ta kai “apösutu”. Di fosu wan hën de kai Simon, di oto në fëën da Petuisi, ku di baaa fëën de kai Andiasi. Nöö i abi Jakobosi ku ën baaa Johanisi, dee mii u Zebedeosi. Nöö a baka u di dë i abi Filipi ku Batolomisi, ku Tomasi, ku mi Mateosi di bi ta pii lanti möni dë. Ufö joo kisi Jakobosi di womi mii u Alufasi, ku Tadeosi, ku Simon di bi dë a dendu u dee sëmbë bi kë puu u dee Dju sëmbë a Loomë köndë basu, ku Judasi Isikaliotu, di o sei Masa Jesosi da dee felantima fëën fu de kii. Nöö u dee tuwalufu sëmbë u kai aki, Masa Jesosi kai u ko nëën, nöö hën a da u makiti fuu ta jaka dee gadu ta kisi sëmbë a hedi ta puu. Nöö söseei a da u makiti tu, fuu kula hii pei sikima ko bunu. ");
INSERT INTO srmNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nöö hën a o manda u go a köndëköndë fuu ta konda di buka u Gadu. Nöö hën a fan ku u te a kaba fa u musu waka. A taki da u taa: “Fa woon go aki, nöö wan musu go a dee oto sëmbë na Isaëli e. Nönö. Na a dee Samalia sëmbë seei un musu go. ");
INSERT INTO srmNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma a dee Isaëli sëmbë fuu, dee i si ta dë kuma lasilasi sikafu dë, a de nöö un musu go. ");
INSERT INTO srmNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Nöö fa i si woon go dë, nöö un musu ta konda soni da de gbelingbelin, be de fusutan taa abiti möön nöö Gadu o seti di tii fëën a wan hii njunjun fasi. ");
INSERT INTO srmNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Nöö fa mi ta manda unu go aki, nöö te un dou a wan köndë nöö un musu kula dee sikima e. Ee wan sëmbë dëdë, nöö un weki ën. Nöö un kula dee sëmbë dee siki tjina nöö un jaka dee gadu puu a sëmbë hedi. Nöö fa un kisi di kaakiti aki, na bai un bai ën e, nöö wan musu mbei sëmbë paka unu fëën tu. ");
INSERT INTO srmNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Nöö fa un nango aki, na köpö sensi seei fuun musu tja go ku unu e. ");
INSERT INTO srmNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wan musu lai na wan soni a saku tja. Wan musu tei tu djakiti ee nasö tu susu tja go ku unu e. Nöö na tei tu pau fii mbei kokoti, ma i sa tei wan. Biga di sëmbë di i ta heepi, nöö hën musu sölugu i. ");
INSERT INTO srmNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Söö. Nöö te un go a wan köndë, ee gaan wan ee piki wan, nöö un musu suku wan sëmbë di de abi lesipeki da a di köndë, nöö unu tuwë lai nëën wosu. Nöö a di wosu naandë, nëën i musu ta libi fu tee i kumutu dë e. ");
INSERT INTO srmNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","“Nöö te woon denda a di wosu, nöö un da dee sëmbë odi taa ‘Masa Gadu musu da unu kötöhati e, dee sëmbë.’ ");
INSERT INTO srmNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nöö mi taki da unu taa ee dee sëmbë u di wosu naandë dë a pasi u kisi di lö bunu dë, nöö Gadu o da de kötöhati tuu. Ma ee de an dë a pasi u de feni ën, nöö de an o feni ën. Di bunu dë o toona ko a unu baka. ");
INSERT INTO srmNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Nöö ee un go a wan köndë ee nasö a wan wosu, nöö dee sëmbë an kë tei unu, de an kë jei di buka un ta tja go dë seei, nöö un kumutu dë go fuunu e. Nöö te woon go, nöö un musu puu di susu fuunu a unu futu, nöö un naki ën puu di doti di bi peka nëën tuwë disa da de, nöö un kumutu dë e. ");
INSERT INTO srmNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nöö mi taki da unu taa te di daka Masa Gadu o kuutu a libisëmbë liba, nöö di köndë dë o kisi wan möön gaan hebi sitaafu möön leki fa dee hogi köndë de kai Sodom ku Gomola bi kisi. ");
INSERT INTO srmNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nöö un haika e, dee sëmbë. Fa i si mi ta manda unu go aki, nöö a dë leti kuma mi ta manda sikafu go a takumbeti dendu. Nöö un musu dë wekiweki ta wooko ku fusutan e, ma nöö un musu dë ku saapi fasi seei tu kuma pomba. ");
INSERT INTO srmNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nöö wojo fuunu musu ta dë limbolimbo nöömö. Un musu saandi un ta du. Wë biga mi o bai unu a fesi taa de o kisi unu tei tja go a dee gaan kuutu u de e, nöö de o fon unu a dee keikiwosu u de seei. ");
INSERT INTO srmNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","De o ta tja unu go a dee hedima u köndë fu di në u mi hedi. Ma wan musu fëëë, biga naandë woon feni pasi fuun sa konda soni u mi da hii sëmbë, Dju sëmbë te dou ku dee na Dju sëmbë tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Nöö te de kisi unu tja go a dee kuutu u de, nöö wan musu dë pantapanta ta booko hedi ta pakisei taa: ‘Unfa woo piki de?’ Nönö. Biga a di juu dë Gadu o da unu di fa fuun piki de. ");
INSERT INTO srmNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nöö an o dë taa unu o fan di fan naandë e, ma di Akaa fuu Tata di dë a unu liba dë, hën o ta fan da unu. ");
INSERT INTO srmNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nöö mi taki e, taa wan baaa o tjëën baaa go könku u de kii puu fu di a nama ku mi hedi. Söseei tu wan tata o tjëën mii go könku u de kii puu, fu di di mii ta nama ku mi hedi. Dee mii o ta hopo ta puu de mama ku de tata a de liba manda go kii fu di de ta nama ku mi hedi. ");
INSERT INTO srmNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Boo taa hii sëmbë o buuse unu fu di un ta nama ku mi hedi. Ma nöö di sëmbë di ta hoi te go dou a di kaba pisi, nöö hën o feni di heepi u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Nöö te un go a wan köndë nöö te de ta toobi unu tumisi, nöö un kule kumutu dë go a oto köndë e. Biga mi taki da unu taa wan o sa kaba di wooko a hii dee köndë u dee Isaëli sëmbë fuu tuu bifö a dë taa mi di ko dë Libisëmbë Mii aki o toona ko a goonliba. ");
INSERT INTO srmNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Ma nöö fa i si de o du ku unu dë, nöö söseei de ta du ku mi aki kaa e. Hën mbei an musu dë gaan soni da unu. Biga di sëmbë di ta tei lei an sa hei möön di sëmbë di ta lei ën. Söseei tu, wan futuboi an sa hei möön hën masa, ma a sa dë kuma hën masa nöö. Hën mbei fa de ta kosi mi aki taa di didibi hën ta wooko a mi liba, wë nöö na möönmöön de o kosi un dee sëmbë ta nama ku mi nö? ");
INSERT INTO srmNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nöö mi taki e, taa fa mi ta manda unu go aki, nöö wan musu fëëë fuun konda dee soni mi ta manda unu fuun konda. Biga na wan soni sa dë a tjubi te nöö an o ko a döö. Nöö na wan soni sa pasa te nöö sëmbë an o ko sabi ën. ");
INSERT INTO srmNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nöö fëën mbei dee soni i si mi ta konda da unu sapisapi a së aki, un musu ta bai ta konda de a lanti dendu. ");
INSERT INTO srmNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Nöö wan musu fëëë tu te sëmbë o ta suku unu fu de kii. Biga de sa kii unu sinkii, ma de an sa kii unu akaa. Ma di Sëmbë fii fëëë, hën da Masa Gaangadu e. Biga ˻ee ja a’ bisi ku ën, nöö˼ a sa disa i te i kaba a sösö, nöö di sinkii fii ku di akaa fii tuu o go a didibi faja. ");
INSERT INTO srmNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Dee sëmbë o, un luku dee sösö piki fou ta buwa ta lontu aki. Sëmbë an ta si de u gaan soni, hën mbei de ta sei tu u de u wan tiisënsi nöö. Ma nöö fa i si de ta buwa dë, na wan kodo u de sa puu kai a goon ee na u Tata a liba da pasi. ");
INSERT INTO srmNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Wë nöö un dee libisëmbë wë? Wan bumbuu gaanfa möön dee piki fou naandë ö? Nöö te i si wan soni pasa ku unu, nöö nëën da u Tata dëën pasi fa a pasa sö nö? Nöö hën mbei mi taa wan musu fëëë. Biga Masa Gaangadu sabi hii soni fuunu finifini, te dou ku un mëni niën uwii dë a unu hedi. ");
INSERT INTO srmNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nöö mi taki e, taa ee ja fëëë fii piki a lanti fesi taa mi ku i nama, nöö miseei tu ma o fëëë u piki mi Tata a liba ala taa mi ku i nama. ");
INSERT INTO srmNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma ee wan sëmbë ja kë piki taa mi ku i nama, nöö miseei tu, ma o piki mi Tata taa mi ku i nama. ");
INSERT INTO srmNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Dee sëmbë o, fa i si mi ko a di goonliba aki, na wata mi tja ko e, ma faja mi tja. ");
INSERT INTO srmNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi ko u ko paati sëmbë ku sëmbë. Biga fu mi hedi a o pasa leti kumafa i si Gadu Buku taki. A taa: Wan womi mii ku ën tata o kisi gaan toobi. Mujëë mii ku ën mama o kisi gaan toobi. Mai ku mai o kisi gaan toobi. ");
INSERT INTO srmNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nöö dee möön gaan felanti di wan sëmbë o abi, de o dë dee bëë fëën seei. Sö a bi sikifi a Gadu Buku kaa e. ");
INSERT INTO srmNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ma nöö ee wan sëmbë lobi hën mama ku ën tata möön mi, ee nasö a lobi ën womi mii ku ën mujëë mii möön mi, nöö di sëmbë dë an bunu tjika u waka a mi baka. ");
INSERT INTO srmNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","“Un haika e, dee sëmbë. Ja si fa de ta buta wan sëmbë faa tja hën lakpa pau te de o tjëën go kii ö? Wë sö nöö hiniwan sëmbë o abi fëën sitaafu di a musu tjai ee a o ko waka a mi baka. Nöö ee ja kë tja di sitaafu dë, nöö ja fiti fii dë wan bakama u mi e. ");
INSERT INTO srmNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Söseei tu, ee wan sëmbë i kë dë fii seei, nöö ja o feni wan suti libi kumafa i kë möönsö. Poi nöö libi fii o ta poi. Ma nöö di sëmbë di ta sakëën libi da mi, hën o feni wan suti libi nöömö kumafa a kë. ");
INSERT INTO srmNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nöö mi taki e, taa fa mi ta manda unu fuun ta tja di buka u Masa Gaangadu aki, ee wan sëmbë tei unu buta a wosu nöö miseei wë a tei dë kaa e. Nöö ee wan sëmbë tei mi, nöö di Sëmbë di manda mi ko a goonliba aki, nöö hënseei wë a tei dë tu. ");
INSERT INTO srmNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nöö ee i si wan sëmbë ta tja Gadu buka nöö hën i hoi ën a i wosu fu di a dë tjabukama u Gadu hedi, nöö i seei o feni paima a Gadu leti kumafa di tjabukama dë seei o feni. Söseei tu, ee i si wan sëmbë ta libi bunu kumafa Gadu kë, nöö hën i kisi ën hoi fu di i sabi taa sö a ta libi hedi, nöö joo feni paima a Gadu leti kumafa di sëmbë dë seei o feni. ");
INSERT INTO srmNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Un luku dee sëmbë ta waka a mi baka aki o, dee sëmbë. Sömëni u de dë lagilagi sëmbë seei a libisëmbë wojo. Ma mi taki e, taa ee dëëwata kisi wan u de nöö i dëën wan kan kötö wata faa bebe fu di a ta waka a mi baka hedi, nöö joo feni paima fëën a Gadu nöömö.” Nöö sö Masa Jesosi leti u dee bakama fëën te a kaba ufö a manda u go. ");
INSERT INTO srmNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Baka u di Masa Jesosi fan ku u sö, hën a kumutu dë, ta waka ta lontu a dee köndëköndë u Galilea ta konda di buka u Masa Gaangadu ta lei sëmbë soni fëën finifini. ");
INSERT INTO srmNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wë nöö di juu dë, de bi kisi Johanisi di dopuma buta a dunguwosu kaa. Nöö ala a dë ta jei u hii dee soni dee Masa Jesosi, di Keesitu, ta du. Nöö hën a kai dee bakama fëën ko nëën, hën a manda de taa: “Un go a Jesosi e, ");
INSERT INTO srmNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nöö un hakisi ën ee hën da di sëmbë tuu, di Gadu bi paamusi u taa a o manda ko, naa u musu luku wan oto sëmbë möön? Sö fuun hakisi ën e.” ");
INSERT INTO srmNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","˻Nöö hën dee bakama u Johanisi nango te de go dou a Masa Jesosi. Hën de dëën di buka te de kaba.˼ Nöö hën Masa Jesosi piki de, a taa: “Un toona go a Johanisi e, nöö un konda hii dee soni dee un si ku dee un jei a mi aki tuu dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Un taki dëën taa ˻hii dee soni Gadu Buku bi taki u di Sëmbë Gadu o manda ko, nöö de tuu ta pasa fa u dë aki˼. Biga bookowojoma ko ta si soni, lanma hopo ta waka, sikitjinama ta ko bunu, bookojesima ko ta jei soni, dëdë sëmbë ta weki, dee möfina sëmbë ta jei di suti Buka u Masa Gadu. Sö fuun taki dëën e. ");
INSERT INTO srmNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nöö un taki dëën tu, taa di sëmbë di an ta mati fu di ma ta du kumafa a bi mëni, nöö sö wan sëmbë dë bunu e.” Sö Masa Jesosi piki de te a kaba. Nöö hën de toona go a Johanisi baka. ");
INSERT INTO srmNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nöö fa dee bakama u Johanisi nango dë, hën Masa Jesosi bia fan ku dee hia sëmbë dee ku ën sai dë. A taa: “Fa un bi kule go a Johanisi a di sabana dë, un sooti sëmbë un go si ala? Un si wan sëmbë di aan pakisei, kuma wan kambaluwa di ventu ta böö nango ta ko nö? ");
INSERT INTO srmNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ee nasö un si wan sëmbë bisibisi ku gaan waiti koosu nö? Nönö, Johanisi an bi dë sö e. Biga dee sëmbë ta bisi gaan waiti koosu, nöö a guduma wosu de ta dë. Na a sabana dendu de ta libi. ");
INSERT INTO srmNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“A kandë un bi mëni tu taa fa woon go dë, nöö woon si wan gaan tjabukama u Gadu ta du gaan foondofoondo soni. Wë mi taki da unu taa un si wan tjabukama u Gadu tuu, ma a möön hei möön wan tjabukama seei. ");
INSERT INTO srmNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Biga Johanisi wë da di sëmbë di dee fesiten tjabukama u Gadu bi sikifi soni fëën, taa Gadu o manda wan sëmbë ko faa seeka pasi da di Heepima di o ko. ");
INSERT INTO srmNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nöö mi taki da unu seei gbelin taa fu hii dee libisëmbë mujëë pai, nöö na wan u de hei kuma di Dopuma de kai Johanisi e. Ma fa mi fan dë seei, ma hiniwan sëmbë di dë a di Njunjun Tii u Gadu dendu te dou ku dee möön lagi wan seei, nöö de tuu a’ kölöku möön Johanisi. ");
INSERT INTO srmNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Nöö fa mi ta fan soni u di Njunjun Tii u Gadu aki, nöö a ta ko taanga seei kaa e, dee sëmbë, fu kumutu a di ten Johanisi hopo seti konda soni fëën fu te kisi fa u dë aki. Nöö di sëmbë di ta biinga taanga nëën baka nöö hën o dë nëën dendu. ");
INSERT INTO srmNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nöö di Njunjun Tii aki, hën da di soni di Mosesi ku hii dee fesiten tjabukama u Gadu tuu bi ta taki, te kisi di ten u Johanisi aki. ");
INSERT INTO srmNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Nöö ee un kë piki, nöö woon ko sabi taa Johanisi wë da di sëmbë di bi musu ko a di ten di di tii aki o seti. Hën wë da di Elia di dee oto fesiten tjabukama bi ta taki taa a o toona ko. ˻Biga di wan seei fasi Johanisi ku Elia abi.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nöö fa i si mi ta fan ku unu aki nöö un pakisei ën bunu e, be un fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nöö hën a bai taa: “Ee, dee sëmbë aki, andi seei mi sa tei maaka ku unu kumafa un dë aki baa? Un dë kuma dee mii ta pëë a sitaati, soni an ta kai ku de möönsö. Fa de sai dë, de ta buja ku de seei taa: ");
INSERT INTO srmNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘U böö tutu da unu te u wei fuun baja, ma wan kë baja. Nöö hën u bia kanda tjali kanda da unu fuun këë, ma wan kë këë.’ “Nöö sö wë nöö un dë tu e, dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Biga Johanisi ko, nöö hën an bi ta njan kuma unu, an bi ta bebe kuma unu, nöö un kosi ën taa a lau, soni dë nëën liba. ");
INSERT INTO srmNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Nöö hën Mi di ko Libisëmbë Mii aki ko, nöö hën mi ta njan ta bebe ku unu, nöö hën un ta kosi mi tu taa mi a’ langabëë tumisi, mi dë bebesonima, mi ta hulu takulibisëmbëma u di köndë. Ma mi sabi taa a o ko a döö nöömö u sëmbë musu ko fusutan taa Gadu hën manda mi ku Johanisi tuu ko, biga u tu tuu bi libi leti kumafa Gadu kë.” ");
INSERT INTO srmNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nöö hën Masa Jesosi ko gandji da dee sëmbë u dee köndë awaa ka a bi du dee möön hia wooko fëën, foondofoondo wan, ma töku de an bi bia ko piki ën möönsö fu de disa dee hogilibi u de. ");
INSERT INTO srmNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","A taa: “Mi bai helu da unu e, un dee sëmbë u Kolazin, ku un dee sëmbë u Betisaida. Biga fa dee köndë de kai Tilusi ku Sidon sai naandë, dee sëmbë u de hogi tee de hogi. Ma ee de bi si dee gaan foondo wooko dee un bi si aki, nöö de bi o bia de libi gaanduwe. Mi taki da unu taa, de bi o buta maun a mindihedi ta bai ta këë ta tuwë deseei a goon ta logoda ta bisi djodjo. Sö di hogilibi de bi ta libi dë bi o hati de tjika. Ma un wan du sö. ");
INSERT INTO srmNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Hën mbei mi taki da unu taa a di gaan kuutudaka u Gadu, nöö di sitaafu di dee sëmbë u Tilusi ku Sidon o kisi an o bigi kuma di woon kisi e. ");
INSERT INTO srmNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Nöö söseei un dee sëmbë u Kapenaumi fa un hei di gaan hei aki, nöö un ninga taa hën o tja unu go a Gadu Köndë ö? Na seei. Mi taki da unu taa a di didibi faja a o tja unu go kaba a sösö. Biga fa dee sëmbë u Sodom bi hogi tjika dë seei, ma ee de bi si dee gaan foondo wooko dee un si aki, nöö de bi o bia libi gaanduwe. Nöö Gadu an bi o booko di köndë u de kaba a sösö te kisi fa u dë aki. ");
INSERT INTO srmNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“Nöö mi taki da unu taa di sitaafu di Sodom o kisi a di gaan kuutudaka an o bigi kuma di un dee sëmbë u Kapenaumi aki o kisi e. Biga wan kë bia unu libi möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nöö hën Masa Jesosi bia fan ku ën Tata awaa. A taa: “Taata o, i wë da Masa u liba ala ku goon aki tuu. Nöö mi gafa i o, fu di fa i ta wooko. Biga i ta hoi dee soni fii tjubitjubi da dee könima u di goonliba aki ku dee sëmbë dee ta mbei taa de sabi soni poi, nöö hën i ta mbei dee lagilagi sëmbë ko sabi de. ");
INSERT INTO srmNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aai Taata, a bigi o, biga wë sö i feni ën bunu fii du. Gaantangi fii e.” ");
INSERT INTO srmNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nöö hën a bia fan ku dee sëmbë hën ku de sai dë möön. A taa: “Dee sëmbë o, fa mi dë aki, mi Tata buta hii soni a mi maun e. Nöö na wan sëmbë sabi mi fa mi dë boiti mi Tata nöö, nöö söseei na wan sëmbë sabi mi Tata tu fa a dë boiti mi di Mii fëën aki nöö, ku di sëmbë di mi kë mbei a ko sabi ën.” ");
INSERT INTO srmNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nöö hën a taa: “Haika e, dee sëmbë, ee wan sëmbë i dë fukafuka, i ko wei u dee lai dee i ta tja, nöö be i ko a mi e. Nöö mi o mbei i ko dë bööböö. ");
INSERT INTO srmNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Dee sëmbë, un saka unu seei da mi o, be mi ta tii unu ta lei unu soni. Biga fa mi dë aki, mi abi tjalihati, mi a saka fasi, nöö ee wan sëmbë i ko a mi nöö joo feni böö te dou a i hati. ");
INSERT INTO srmNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Biga di tii u mi an taanga e, nöö dee lai dee mi o da unu fuun tjai, de dë fukëfukë.” Sö Masa Jesosi fan ku dee sëmbë ta haikëën dë tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nöö hën u dë te wan saba daka, hën u ku Masa Jesosi ta waka ta pasa a wanlö goon dendu. Nöö dee goon dë ku wan pei soni kuma alisi, ma i sa njan mën kuwakuwa. Nöö hangi bi kisi u, nöö hën u ta booko so taka fëën ta buuka ta njan. ");
INSERT INTO srmNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Te wan pisi hën dee Faliseima si taa sö u ta du, hën de taki da Masa Jesosi taa: “Ja si fa dee bakama fii ta wooko a di saba daka ta poi di tjina nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Hën a piki de taa: “Dee sëmbë o, wan bi lesi a di Buku di soni bi pasa ku Dafiti ku dee mati fëën ö? Hangi bi ta kii de, ");
INSERT INTO srmNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","nöö hën de go a di wosu u Masa Gaangadu hën dee begima da de di bëëë di de ta buta da Masa Gadu. Wë nöö di bëëë naandë, dee begima wanwan nöö ta a’ pasi u njan mën, na sö nö? ˻Ma tökuseei Gadu an tei Dafiti ku dee sëmbë fëën fu hogi di de njan mën.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Nöö wan ta lesi a di Buku tu nö, taa a a’ juu dee begima musu ta wooko a di saba daka nö? Wë ma tökuseei de an ta du hogi. ˻Biga a di Wosu u Gadu de ta wooko, nöö di Wosu hei möön dee wëti u saba daka.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Wë nöö mi taki da unu e, taa Mi di Sëmbë di un ta si dë taanputaanpu a unu fesi aki, nöö mi hebi gaanfa pasa di Wosu u Gadu. ˻Nöö ee ma si taa dee sëmbë aki du hogi, nöö an dë fuun musu kuutu de e.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Wan jei fa Gadu taki a di Buku fëën ö? A taa: Fa un ta tja dee mbeti ta ko ta kii da mi dë, na dee lö soni dë mi kë a unu e. Ma mi kë fuun abi tjalihati u sëmbë. Hën nöö mi ta suku a unu. Sö Gadu taki e. Wë nöö misikuma ee un bi sabi andi di Buku kë taki dë, nöö wan bi o kuutu dee sëmbë aki sö, ˻ma un bi o abi tjalihati u de fa di hangi ta kii de dë.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Nöö mi toona taki da unu möön taa Mi di ko dë Libisëmbë Mii aki, nöö mi abi taki a saba daka liba e.” Sö Masa Jesosi taki da dee Faliseima di juu dë. ");
INSERT INTO srmNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nöö hën u kumutu naandë, hën u go dou a wan keikiwosu fuu dee Dju sëmbë, hën u denda nëën. ");
INSERT INTO srmNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nöö hën u ko si wan sëmbë dë, wan së maun fëën dë dëëdëë tjakaa sö. Wë nöö dee felantima u Masa Jesosi bi sai leti dë kaa, nöö hën de o poobëën luku ee de sa feni föutu nëën. Hën de hakisi ën taa: “Unfa i mëni? A fiti fu kula wan sëmbë a saba daka nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hën Masa Jesosi piki de taa: “Haika e. Ee i abi wan sikafu fii ta kiija nöö hën a kai go a baaku dendu a saba daka, nöö ja o go puu ën fu an musu dëdë ö? ");
INSERT INTO srmNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wë nöö wan libisëmbë wë? An bumbuu möön wan mbeti nö? Nöö ee i kë du wan sëmbë bunu a saba daka nöö aan tjina e.” ");
INSERT INTO srmNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nöö hën a bia fan ku di sëmbë di abi di dëëdëë maun taa: “Womi, tëndë di maun fii ko i si.” Nöö fa a tëndë maun taaan naandë kaa, hën di maun fëën ko bunu gbelingbelin kuma di oto së maun. ");
INSERT INTO srmNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma nöö di dee Faliseima si di soni Masa Jesosi du dë, nöö an kai ku de seei. Hën de go a döö go ta kuutu fa u de du de kii ën puu dë. ");
INSERT INTO srmNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma Masa Jesosi sabi kaa taa sö fëën de ta pakisei, nöö hën a kumutu disa de dë, hën a go fëën. Nöö fa a nango dë, wanlö hia sëmbë ta waka ta ko nëën baka hën a kula dee sikima u de tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma nöö hën a ta bai de taa de an musu mbei lanti ko sabi soni fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nöö hii fa Masa Jesosi ta du naandë, nöö a ta pasa leti kumafa Gadu bi buta di fesiten tjabukama fëën de kai Jesaaja faa sikifi a di Buku taa: ");
INSERT INTO srmNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Luku di futuboi u mi aki, di mi tei u miseei vö, hën wë mi lobi e. Gaan piizii fëën seei dë a mi hati. Nëën liba wë mi o buta di Akaa u mi, nöö a o ta konda da dee peipei sëmbë u goonliba andi da bunu ku andi da hogi. ");
INSERT INTO srmNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Fa a o sai dë, nöö an o ta fia ta kai wolo. Na wan sëmbë seei o jei bai fëën a sitaati möönsö. Nöö a o abi tjalihati u sëmbë teee. ");
INSERT INTO srmNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Te a si wan sëmbë booko saka, kuma wan piki pau de booko pië hëngi buta tëkëë dë, nöö an o fën ën puu. Ee a si wan sëmbë abi wan pikii biibi a Masa Gadu liba eti, kuma wan lampu di oli fëën ta kaba nöö a ta tapa nango njöiin, nöö an o böö ën tapa. Sö a o abi tjalihati u sëmbë tjika e. Nöö sö a o ta libi fëën fu te a wini hii mundu buta u de musu libi a wan leti fasi nëën wojo. ");
INSERT INTO srmNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nöö hii dee peipei nasiön u di goonliba aki o buta pakisei nëën liba fu de feni heepi a Gadu. Sö wë di Buku bi taki fu di Futuboi u Gadu di bi o ko. ");
INSERT INTO srmNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nöö di juu dë, hën de tja wan sëmbë ko a Masa Jesosi faa kulëën. Di womi dë, wan soni bi tapëën buka, a booko ën wojo. Nöö hën Masa Jesosi puu di soni nëën liba. Nöö wantewante dë hën buka fëën jabi a ko ta fan, wojo fëën ko limbo a si soni baka. ");
INSERT INTO srmNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nöö di soni foondo dee hia sëmbë sai dë te na soni, hën de ko ta hakisi de na de taa: “Maingë, a sa kë di Bakamii u Könu Dafiti di Gadu bi paamusi u taa a o ko, di Heepima, hën disi nö?” Sö dee sëmbë ta hakisi deseei. ");
INSERT INTO srmNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma nöö di dee Faliseima jei fa de ta taki dë, hën de taa: “Höön, andi wë? Di soni dë na gaan soni sö. Fa i si a ta puu dee soni a sëmbë liba dë, nöö di hedima u dee didibi de kai Belisabo hën wë ta dëën di kaakiti faa du sö e. Na oto soni möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma nöö Masa Jesosi sabi kaa taa sö fëën dee Faliseima ta pakisei. Hën a fan ku de taa: “Unfa un mëni? Ee wan könu dë nöö hën dee sëmbë dee dë nëën tii hopo ta feti ku de na de, nöö nëën da di tii fëën o booko nö? Söseei tu, ee wan piki köndë ee nasö wan bëë ko paati ta feti ku de na de, nöö na kaba a ta kaba a sösö nö? ");
INSERT INTO srmNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Nöö ee di didibi ta feti ku dee otowan fëën ta jaka de na de ta puu a sëmbë liba, nöö nëën da di tii fëën ta kaba a sösö nö? ");
INSERT INTO srmNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nöö fa un taki dë, taa mi ta puu dee soni a sëmbë liba ku di didibi kaakiti, nöö dee sëmbë fuunu wë? Ku un kaakiti de ta puu de? Wë de o da unu adjabëë o, biga ku di wan seei kaakiti mi ku de ta puu de. ");
INSERT INTO srmNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Ma nöö ee mi ta puu de ku di kaakiti u di Akaa u Gadu, nöö un musu sabi taa di Njunjun Tii u Gadu ko a unu awaa e. ");
INSERT INTO srmNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Biga ee wan sëmbë i kë go a wan taanga sëmbë wosu u go tei dee gudu fëën, nöö i musu kisi ën tai te i kaba bifö, na sö nö? ˻Wë nöö hën mi ta du aki.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nöö ee wan sëmbë ja tuwë gogo ku mi a wan së, nöö hën da i dë felantima u mi e. Ee ja ta wooko makandi ku mi fii hai sëmbë ko a mi, nöö hën da i ta jaka sëmbë puu a mi kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Nöö un haika bunu fa mi o fan aki, dee sëmbë. Mi taki e, taa a dë wan gaan hogi soni fii sösö di Akaa u Masa Gaangadu. Biga hii hogi di wan libisëmbë sa du ku hii pei hogi soni a sa taki ta sösö Masa Gaangadu, de tuu sa puu a Gadu bëë. Ma ee i ta sösö di Akaa fëën, nöö heepi an o dë da i möön e, biga Gadu an o puu i nëën bëë möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aluwasi ee wan sëmbë i ta mindi soni da Mi di ko dë Libisëmbë Mii aki ta sösö mi, nöö Gadu o sa puu i a bëë. Ma ee i ta mindi soni da di Akaa fëën ta sösö ën, mi taki da unu gbelin seei taa Gadu an o puu i a bëë möönsö, na a di ten u dë aki, na a bakaten tu. ");
INSERT INTO srmNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nöö fa un fan di soni dë, nöö wan sabi taa a di pau njanjan nëën i ta sabi un sootu pau a dë nö? Ee di njanjan bunu nöö hën da di pau seei bunu, ma ee di njanjan an bunu nöö di pau seei an bunu tu.” ");
INSERT INTO srmNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nöö hën Masa Jesosi kosi dee Faliseima seei awaa, a taa: “Fa un hai ko zunta na dokunu gidjii kuma wanlö hila sindeki naandë, nöö un sa taki bumbuu soni möönsö nö? Nönö, sösö hogi nöö un sa taki. Biga di hogi di dë a unu hati, hën nöö ta kumutu a unu buka te un ta fan. ");
INSERT INTO srmNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Nöö un haika e, dee sëmbë. Ee wan sëmbë i dë nöö bumbuu soni dë a i hati, nöö bumbuu fan joo ta fan. Ma ee wan sëmbë i dë nöö hogi wanwan nöö dë a i hati, nöö hogi soni nöö joo ta taki ta tuwë. ");
INSERT INTO srmNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ma nöö mi taki da unu gbelin taa te di gaan kuutu daka u Masa Gaangadu kisi, nöö hiniwan sëmbë o piki fu hiniwan sösö fan di a bi fan söndö pakisei. ");
INSERT INTO srmNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dee fan dee i bi ta fan, nöö de Gadu o tei ta kuutu i luku ee a dë faa da i leti, ee a dë fii musu kisi sitaafu fëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nöö hën wanlö u dee Sabima u Wëti ku dee Faliseima seei, hën de toona ko a Masa Jesosi möön. Hën de taki dëën taa: “Mësitë, wë fii du wan foondo soni boo si ee a Gadu di taki fii ta kumutu tuu.” ");
INSERT INTO srmNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hën Masa Jesosi gandji da de, a taa: “Un dee takulibima aki, fa un disa Gadu dë, nöö un dë leti kuma wan mujëë di bia baka disëën manu go tei oto womi nëën manu wosu. Sö un hogi tjika. Hën mbei un kë u mi lei unu wan maaka ufö un sa biibi. Wë mi taki da unu e, taa ma a’ maaka fu mi lei unu möönsö möön leki di soni di bi pasa ku di tjabukama u Gadu de kai Jona. ");
INSERT INTO srmNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Biga fa a bi dë dii daka ndeti ku didia a di fisi bëë dendu bifö a kumutu, nöö söseei Mi di ko dë Libisëmbë Mii aki o dë a goon basu dii daka ndeti ku didia ufö mi o kumutu. ");
INSERT INTO srmNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Nöö fa wan kë biibi mi aki, nöö mi taki da unu gbelin taa a di gaan kuutu daka u Masa Gaangadu nöö dee sëmbë u Ninifei o hopo da unu adjabëë e. Biga di Jona konda di buka u Gadu da de, nöö hesihesi seei de piki di buka hën de disa di hogilibi u de bia ko begi Masa Gadu faa puu de a bëë. Ma nöö di Sëmbë di ta fan ku unu aki, nöö a hebi möön Jona gaanfa e, ma wan kë piki ën buka möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Nöö söseei mi taki da unu tu taa di mujëë könu di bi ko a Könu Salumon, hënseei o da unu adjabëë tu a di gaan kuutudaka u Gadu e. Biga a bi kumutu te a longi ko haika Könu Salumon luku fa a köni tjika. Ma nöö di Sëmbë un ta si aki, a hebi möön Könu Salumon gaanfa e, ma wan ta tei ën u soni möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nöö hën Masa Jesosi bai dee sëmbë ta haikëën dë taa: “Un haika e, dee sëmbë. Te wan soni kumutu a wan sëmbë hedi, nöö a o ta waka ta lontu ta suku kamian faa tan te a wei, an feni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nöö a o taa: ‘Söö, antoobi. Mi o toona go a di sëmbë di mi bi kumutu nëën.’ “Nöö a o toona go dou nëën baka, nöö te a si di kamian hooo, oto soni an ko nëën hedi möönsö, nöö a o wai. Biga a dë kuma wan wosu de baí seeka te de kaba buta gbegedee. ");
INSERT INTO srmNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","“Nöö a o taa: ‘Söö, mi böö.’ “Nöö a o go kai sëbën oto gadu möön hogi möön hënseei fu de ko kisi di sëmbë dë a hedi. Nöö mi taki da unu taa di lö sëmbë dë, soni fëën o ko möön hogi möön leki fa a bi dë a fesi. “Nöö sö wan soni o pasa ku unu e, un dee takulibisëmbëma u di ten aki. ˻Biga hii fa un taa un ta dini Gadu dë seei, ma wan ta tei mi u soni möönsö.˼” ");
INSERT INTO srmNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nöö fa Masa Jesosi ta fan ku dee hia sëmbë naandë, nöö a wan wosu dendu a dë ta fan. Te wan pisi, hën hën mama ku dee baa fëën ko nëën u de ko fan ku ën, nöö hën de taanpu a döö buka naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nöö hën wan sëmbë go taki da Masa Jesosi taa: “I mama ku dee baaa fii dë a dööbuka dë e, nöö de kë fan ku i.” ");
INSERT INTO srmNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nöö hën a piki taa: “Aai, wë antoobi. Ma un haika e. Ambë sa dë mi mama ku dee baaa u mi tuutuu?” ");
INSERT INTO srmNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nöö hën a lei finga a u dee bakama fëën taa: “Ja ta si de naandë nö? Dee sëmbë dë, de da mi mama ku dee baaa u mi. ");
INSERT INTO srmNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Biga hiniwan sëmbë di ta du kumafa mi Tata a liba ala kë faa du, nöö hën wë da mi baaa ku mi sisa ku mi mama.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nöö hën di daka dë seei, hën Masa Jesosi kumutu a di wosu go sindo a bandja wata ala. ");
INSERT INTO srmNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nöö hën wanlö gaan hila sëmbë hai go ta lontu hën gilili sö. Hën a hopo go sindo a wan boto bi sai dë dendu, nöö hën dee hia sëmbë dë a tela ala ta haikëën. ");
INSERT INTO srmNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nöö hën a tei wanlö oto ta lei de soni, a taa: “Wan daka nöö hën wan sëmbë go nëën goon go ta jaa böngö. ");
INSERT INTO srmNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nöö fa a ta jaa ën dë, nöö hafu u di böngö kai a pasi liba, nöö hën dee piki fou pii ën njan puu dë. ");
INSERT INTO srmNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hafu fëën kai a sitonu kamian ka hia doti an dë, nöö hën a nasi hesi seei. ");
INSERT INTO srmNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma di di sonu ko hati taanga, nöö hën dee lö böngö dë dëë gbegedee kaba a sösö. De an ko soni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nöö hafu u di böngö kai a maka dendu, nöö a nasi ma nöö hën di maka göö peetëën te an ko soni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Ma nöö so u di böngö kai a bunu doti nöö hën a ko soni seei. So fëën puu diiteni toon möön hia möön fa a bi paandi. Otowan fëën puu sikisiteni toon möön hia, otowan puu wan höndö.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nöö di Masa Jesosi taki di oto te a kaba, nöö hën a taa: “Söö. Wë di woto mi taki aki, nöö un pakisei ën bunu e, dee sëmbë, be un fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nöö hën u dee bakama fëën ko nëën hën u hakisi ën taa: “Masa o, faandi mbei i ta lei dee sëmbë ku nöngö sö? Biga de an ta fusutan.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nöö hën Masa Jesosi piki u taa: “Fa un dee bakama u mi dë aki, unu wë a kai da e, fuun sa ko sabi dee tjubitjubi woto u Gadu. Biga unu sa fusutan fa di Njunjun Tii fëën dë. Ma na dee sëmbë naandë e, biga de an kë tei di lei u mi u soni. ");
INSERT INTO srmNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Biga ee wan sëmbë i jei wan soni nöö hën i tei ën u gaan soni, nöö möönmöön seei joo ta sabi ën. Ma ee i jei ën, nöö ja tei ën u gaan soni möönsö, nöö di pikiwan i bi jei dë, hënseei o lasi da i tu, joo fika ku sösö maun tjololoo. ");
INSERT INTO srmNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Nöö hën wë mbei mi ta lei dee sëmbë dë ku nöngö e. Biga hii fa de ta si mi aki, ma de an sabi ambë da mi möönsö. Fa mi ta fan aki, nöö de ta haika ma de an ta fusutan möönsö. Biga de aan di pakisei u de fusutan soni. ");
INSERT INTO srmNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Fa de sai u de dë, nöö a ta pasa ku de leti kumafa Jesaaja di tjabukama bi sikifi buta a Gadu Buku. A taa: Woon ta si soni ku unu wojo, ma wan o saandi un ta si. Woon ta jei soni ku unu jesi, ma wan o fusutan andi un ta jei. ");
INSERT INTO srmNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Biga fa un sai dë, hii un tuu hati dë tapatapa. Jesi fuunu booko te wan sa jei soni. Wojo fuunu dë dungudungu pii da dee soni u Gadu. Ee nasö, fa i si un ta luku soni ku unu wojo dë, nöö un bi o saandi un ta si. Un bi o jei soni ku unu jesi, nöö un bi o abi fusutan a unu hati, te nöö un bi o ko a mi fu mi kula unu. ˻Sö wë Gadu bi taki a fesiten u wanlö sëmbë e, nöö dee sëmbë u di ten aki, sö nöö de dë tu.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma nöö un dee bakama u mi aki, wan dë sö. Biga un ta si soni ku di wojo fuunu, un ta jei soni ku di jesi fuunu. “Nöö Gadu naki unu kölöku tuu o. ");
INSERT INTO srmNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Biga sömëni u dee fesiten tjabukama u Gadu ku dee oto sëmbë bi ta libi bunu a Gadu wojo a fesi, de bi hangi seei u si dee soni un ta si ku dee un ta jei aki, ma de an bi si de o. De an bi jei de tu.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nöö hën Masa Jesosi taa: “Söö. Wë awa mi o puu di hedi u di woto da unu awaa. ");
INSERT INTO srmNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“I abi so sëmbë de ta jei di buka u di Njunjun Tii u Gadu aki, ma nöö de an kë kai ën gaan soni u de fusutëën hoi a de hati. Nöö te wan pisi di hogihatima de kai didibi hën o ko puu di buka de bi jei dë a de hati gbegedee. Nöö sö wan sëmbë hën hati dë kuma di pasi liba ka di böngö bi kai. An ko soni möönsö ˻biga dee fou bi pii ën njan puu dë˼. ");
INSERT INTO srmNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Nöö ka di böngö kai a di sitonu kamian naandë, nöö hën da di sëmbë di jei di buka nöö hën a kisi ën seei ku wai. ");
INSERT INTO srmNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma nöö an pakisei ën go dou möönsö. Di fa a jei ën wante wai dë, nöö a kaba. “Nöö te wan fuka ko miti ën, ee nasö sëmbë ko suku ën a toobi fu di wöutu di a bi jei naandë hedi, nöö an o hoi go dou. A o disëën bia baka da Gadu. Hën wë da di böngö di bi kai a di sitonu kamian. ");
INSERT INTO srmNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Nöö ka di böngö kai a maka dendu naandë, nöö hën da di sëmbë di jei di buka, ma a abi bookohedi a soni u di goonliba aki poi, ufö dee gudu u di goonliba aki ta ganjëën ta hai ën baka te di buka u Gadu an sa ko soni dëën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Ma ka di böngö kai a di bunu doti naandë, hën da di sëmbë di jei di buka nöö a kisi ën seei limbolimbo, nöö a hoi ën nëën hati. Sö wan sëmbë dë kuma di bunu doti ka di böngö kai hën a pai dou diiteni toon möön leki fa a bi dë, ee nasö sikisiteni, ee nasö wanhöndö. Sö di buka ko soni dëën tjika.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nöö hën Masa Jesosi toona tei wan oto woto möön ta lei dee sëmbë kumafa di Njunjun Tii u Gadu dë. A taa: “A dë leti kuma wan sëmbë tei wan bumbuu njanjan böngö tja go jaa nëën goon te a kaba, nöö hën a go. ");
INSERT INTO srmNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nöö tefa ndeti, köndë kötö pii, nöö hën wan felantima fëën tei wan taku sii hën a go saapi a di goon fu di sëmbë. Nöö hën a go jaa di taku sii a di goon dendu te a kaba, nöö hën a go fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","27","“Nöö hën de dë tee juu dou, di njanjan seti nasi. Nöö hën dee wookoma fëën ko si taa wanlö taku soni dë a di njanjan dendu. “Nöö hën de kule go a di sëmbë abi di goon hën de taa: ‘Wë na bumbuu böngö i bi jaa a di goon nö? Wë u si taku uwii ta nasi ta ko a dee bumbuu wan dendu gidjii. Unsë dee di dë kumutu?’ ");
INSERT INTO srmNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Nöö hën a piki de taa: ‘Nönö, womi. Bumbuu böngö nöö mii bi paandi e. Wë a musu dë taa wan felantima u mi du sö ku mi.’ “Nöö hën de hakisi ën taa: ‘Wë nöö unfa fëën i mëni? Ja kë fuu go hön dee hogi wan puu a dee bumbuu wan dendu nö?’ ");
INSERT INTO srmNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Nöö hën a taa: ‘Nönö e, dee sëmbë. Un boo disa de ufö, biga ee un go u go hön de, nöö woon hön dee bumbuu wan tu. ");
INSERT INTO srmNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A möön bëtë un disëën te de tuu lepi, nöö mi o manda sëmbë go koti dee taku wan tai a bondji tja go tuwë a faja tjuma. Nöö de go koti dee bumbuu wan awaa, tja go lai a suwa.’ ” Nöö sö wan oto Masa Jesosi tei lei dee sëmbë te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nöö hën a toona da de wan woto möön, faa lei de kumafa di Njunjun Tii u Gadu dë. A taa: “A dë leti kuma di uwii de kai mutaadi di de ta paandi a di köndë fuu aki. ");
INSERT INTO srmNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Fa a sai dë, di sii fëën piki möön hii soni de ta paandi. Ma nöö te i paandi ën kaa, nöö a ta ko bigi möön hii dee oto uwii tuu dee u ta paandi a goon dendu, te fou seei ta ko ta mbei wosu nëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nöö hën a toona da de wan woto möön. A taa: “Fa di Tii u Masa Gaangadu sai dë, nöö a djei kuma te wan mujëë ta dian boon. A ta tei wan pikiin sooda sö tuwë nëën, nöö di sooda ta soopu di boon tee a ko gindii, gaan hia soni möön fa a bi dë.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nöö sö Masa Jesosi ta fan ku dee sëmbë. An ta lei de soni söndö an taki ën a nöngö da de. ");
INSERT INTO srmNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nöö a kai makandi ku di soni wan tjabukama u Gadu bi sikifi buta a di Buku. A taa: Mi o koti nöngö da de. Dee soni bi dë tjubitjubi fu sensi di goonliba mbei, mi o tei de taki awaa. Sö Gadu bi taki a fesi e, nöö awaa a ta pasa. ");
INSERT INTO srmNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nöö di Masa Jesosi lei de sö te a kaba, hën a toona go a wosu. Nöö hën u dee bakama fëën ko nëën ko begi ën taa gaantangi, be a puu di oto möön limbo da u andi di taku sii ku di bunu böngö dë bi kë taki. ");
INSERT INTO srmNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nöö hën a piki u taa: “Antoobi. Un haika e. Di sëmbë di jaa di bunu böngö naandë, nöö Mi wë di ko dë Libisëmbë Mii aki. ");
INSERT INTO srmNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nöö di goon doti, hën da hii di goonliba u dë aki. Nöö di bunu böngö naandë, hën da dee sëmbë dee dë a di Njunjun Tii u Gadu dendu. Nöö dee taku sii, de da dee sëmbë dee ta dë a di tii u di didibi dendu. ");
INSERT INTO srmNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nöö di gaan felantima di i si jaa di taku sii naandë, hën wë da di didibi seei. Nöö di ten u koti dë, hën da di kaba juu u di ten u ta libi aki. Nöö dee sëmbë dee o koti di njanjan buta a suwa, nöö de da dee basia u Masa Gadu Köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Wë nöö fa i si dee sëmbë bi koti dee taku uwii tai a bondji tja go tjuma dë, nöö sö sondi o waka te di ten di u dë aki o kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Biga wan juu o ko, nöö Mi di ko dë Libisëmbë Mii aki o manda dee basia u Gadu Köndë go pii hii dee sëmbë dee ta libi takulibi, ku dee ta lei oto sëmbë u de libi sö tu. De o puu dee lö sëmbë dë a dendu u dee sëmbë dee Gadu ta tii, ");
INSERT INTO srmNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","nöö de o tja de go tuwë a didibi faja. Nöö naandë de o dë ta kai wolo ta bai ta këë ta njan tanda. ");
INSERT INTO srmNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","“Ma nöö dee sëmbë dee bi libi bunu a Gadu wojo, nöö de o dë a di köndë ka Gadu dë könu, nöö hii sëmbë o si fa de bi libi bunu tjika. Biga di bunu libi u de o ko a döö ta sëndë leti kuma sonu u hii sëmbë musu si ën. “Nöö fa u ta fan aki, nöö un pakisei ën bunu e, be un fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Hën Masa Jesosi toona tei wan oto woto ta lei sëmbë möön kumafa di Njunjun Tii u Gadu dë. A taa: “A dë leti kuma wan gaan gudu bi dë tjubitjubi a wan pisi goon. Nöö hën wan sëmbë go si ën. Nöö fa a si ën dë, hën a toona tjubi ën te a kaba. An piki na wan sëmbë. Nöö hën a kule go ku gaan wai nëën hati, hën a go sei hii dee soni fëën dee a bi abi tuu fiaa. Nöö hën a tei di möni go bai di goon naandë gbom tei, faa feni di gudu di dë nëën dendu. Sö di gudu bumbuu dëën tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Söseei tu, di Njunjun Tii u Gadu dë kuma wan wënkëma ta suku gaan bumbuu djamati sitonu faa musu bai. ");
INSERT INTO srmNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hën a ta waka ta lontu tee a ko si wan gaan waiti wan, a dii te na soni. Nöö hën a go sei hii dee soni fëën dee a bi abi tuu fiaa, hën a tei di möni tuu hën a go bai di djamati sitonu dë puu tei. Sö a bumbuu dëën tjika.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Hën a toona taki wan otowan da de möön. A taa: “Di Njunjun Tii u Gadu aki, nöö a dë leti kuma dee sëmbë ta kisi fisi. De tuwë wan gaan nëti u de a wata. Hën de kisi hii pei fisi, dee dë u njan ku dee na dë u njan tuu, ");
INSERT INTO srmNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","te di nëti fuu pöö. Hën de hai ën gbulululu puu a tela. “Nöö hën wë de go sindo, hën de ta pii dee bunuwan ta tei ta buta a manda, nöö de ta tuwë dee na bunu.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nöö hën a taa: “Nöö sö a o pasa e, dee sëmbë, te di kaba juu u di ten u ta libi aki dou. Biga Gadu o manda dee basia fëën köndë u de go pii dee takulibisëmbë puu a dee sëmbë dendu dee ta libi bunu a Gadu wojo. ");
INSERT INTO srmNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nöö de o tuwë de go a di faja dendu ka de o dë ta bai ta kai wolo ta njan tanda te de wei, de an o kumutu dë möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nöö hën a hakisi de taa: “Dee sëmbë o, fa mi ta fan ku unu aki, nöö un ta fusutan mi ö?” Hën de taa: “Aai, Masa, u ta fusutan i e.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nöö hën a taa: “Wë a bunu. Biga ee wan leima bi sabi dee awoo lei fu Gadu dee bi dë a di Buku kaa, nöö hën a toona ko kisi dee njunjun lei u di Tii u Gadu aki, nöö di sëmbë dë hën abi bumbuu sondi seei te a hia e. A dë leti kuma wan sëmbë di abi wan kamba fuufuu ku awoo ten ku njunjun ten gudu tuu, nöö a sa nango ta tei kumafa a kë.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sö Masa Jesosi taki da dee sëmbë tefa a kaba. Nöö hën a kumutu dë, ");
INSERT INTO srmNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","hën a tei pasi go a Nazalëti ka de bi kiijëën. Nöö hën wë a go a di keikiwosu u di köndë go ta lei dee sëmbë sai dë. Nöö fa a ta lei de naandë, hën a foondo de te na soni. Hën de ta hakisi de na de taa: “Wë dee sëmbë o, naasë di mii aki sö feni di köni dë ku di kaakiti ta du dee foondo wooko? ");
INSERT INTO srmNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","Biga na di mii u di tëmbëma fuu aki disi nö? Jee? Na Malia da mama fëën nö? Nöö dee baaa fëën, Jakopu, Judasi, Josëfu, ku Simon, ku dee sisa fëën, na u ku de ta dë aki nö? Naasë a go feni dee soni dë?” ");
INSERT INTO srmNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hën de tei ën fu hogi seei. Hën Masa Jesosi taa: “Awa, sö a dë tuu o. Wan tjabukama u Gadu sa feni gafa a hii oto köndë ma boiti nëën seei köndë e, ku ën wosu dendu ka a bi kiija.” ");
INSERT INTO srmNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nöö hën mbei wë an du hia foondo wooko a Nazalëti naandë. Biga dee sëmbë fëën an kë biibi ën. ");
INSERT INTO srmNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wë nöö di juu dë, Könu Helodi di ta tii di köndë ko jei fu dee foondo soni Masa Jesosi ta du a dee köndëköndë. ");
INSERT INTO srmNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nöö hën a taki da dee otowan ku ën bi sai dë, taa: “Fa di sëmbë ta du dee soni naandë, nöö a musu dë taa di dopuma de kai Johanisi hën di dë e. A toona weki baka a dëdë, nöö hën mbei wë a abi kaakiti faa du soni gaanfa sö.” ");
INSERT INTO srmNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wë nöö di soni mbei di könu fan sö. A dë sö taa a bi tei di mujëë u wan baaa womi fëën de kai Filipi buta nëën wosu. Di mujëë hën de kai Helodiasi. ");
INSERT INTO srmNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nöö hën Johanisi fan ku ën taa di soni a du dë, an bunu, aan leti seei kwetikweti. Gadu wëti wë a poi fa a tei di mujëë fëën baaa dë. Sö Johanisi fan ku di könu tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nöö di a fan sö, nöö hën di könu hati boonu ku ën seei te a bi kë kii ën, ma fu di a fëëë hogi në a lanti nöö hën mbei an kii ën ma a tuwëën a dunguwosu. Biga wë hii sëmbë bi ta si Johanisi taa a dë wan tjabukama u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma nöö te wan pisi, hën di könu fujai. Nöö di mujëë di a bi tei dë abi wan mujëë mii fëën di a bi pai ku Filipi. Nöö fa de dë a di piizii u di könu dendu naandë, nöö hën di mujëë mii ko baja wan baja a di piizii dendu te a bigi. Nöö di soni suti da di Könu seei te na soni, ");
INSERT INTO srmNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nöö hën a kai di mujëë mii ko nëën. Hën a paamusi ën ku soi a hii sëmbë fesi naandë taa hiniwan soni di a hakisi kaa, nöö a o dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nöö fa di könu fan dë, hën di mujëë mii kule go piki ën mama taa sö di könu paamusi ën, nöö ee andi a musu hakisi ën. Nöö hën di mama taa: “Wë go taki da Könu taa i kë faa manda sëmbë go kii di Dopuma de kai Johanisi, nöö a koti hën hedi buta a wan gaan paabi dendu, nöö a tja ko da i. Sö fii taki dëën e.” Nöö hën di mujëë mii kule go a di könu go taki di soni dëën te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nöö di di könu jei sö, hën hati fëën latja te na soni. Biga an bi mëni taa sö wan soni di mujëë mii bi o hakisi. Ma nöö fu di a bi soi sö a hii lanti fesi kaa, hën mbei an sa piki nönö möön. ");
INSERT INTO srmNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nöö hën wante fa u mbei dë, hën a manda sëmbë go a dunguwosu go koti Johanisi hedi belim puu. ");
INSERT INTO srmNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hën de butëën a wan paabi dendu, hën de tjëën ko da di mujëë mii. Hën di mujëë mii tei, nöö hën a tja go dëën mama. ");
INSERT INTO srmNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nöö hën dee bakama u Johanisi go tei di dëdë sinkii fëën hën de tja go bei. Nöö hën de go piki Masa Jesosi taa sö wan soni. Johanisi dëdë. ");
INSERT INTO srmNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nöö fa Masa Jesosi jei di buka dë ˻nöö a bigi dëën tee˼. Nöö hën a kumutu naandë, hën a subi a boto, u ku ën, hën u koti wata go a di oto së banda ala. Biga a bi kë fuu dë u wanwan pii ufö. Ma nöö di dee sëmbë u dee peipei köndë si ka u ta puu nango dë, hën wë de booko seei gililii kule a futu koti tapa u a fesi ala. ");
INSERT INTO srmNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nöö di ten u go dou a lampeesi fuu kumutu a boto go a tela, nöö dee sëmbë sai dë gidjii kaa ta luku u. Nöö hën tjali u dee hia sëmbë dë kisi Masa Jesosi tee na soni, nöö hën a ta kula dee suwakima u de tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nöö di juu dë, nöö a bi dë ndeti buka kaa. Nöö hën u ko a Masa Jesosi ko taki dëën taa: “Masa o, luku. Ndeti ta ko. Na fii manda dee sëmbë go, be de go suku soni bai u de njan nö? Biga ka u sai aki, kamian u bai soni u njan an dë aki seei.” ");
INSERT INTO srmNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma nöö hën a piki u taa: “An dë u de go e. Be unu da de soni u njan.” ");
INSERT INTO srmNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hën u mbei: “Huun? Wë Masa, wa a’ soni u njan aki möönsö. Feifi bëëë tö u abi aki, ku tu pikipiki fisi.” ");
INSERT INTO srmNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hën a taa: “Antoobi. Un tja de ko da mi aki.” ");
INSERT INTO srmNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nöö hën u tja de ko dëën. Nöö hën a manda dee hia sëmbë u de go sindo a goon a di ahun liba dë, nöö hën de sindo te de kaba. Nöö hën a tei dee bëëë ku dee fisi hën a hopo wojo luku liba, hën a da Masa Gaangadu tangi te a kaba. Nöö hën a booko dee bëëë ˻ku dee fisi˼ pisipisi tefa a kaba, hën a tëndëën da u. Hën a taa: “Un tja go paati da dee sëmbë e.” ");
INSERT INTO srmNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hën u tja go paati da de. Hën de njan teefa bëë u de fuu, ma tökuseei soni fika eti. Hën u toona pii dee pisipisi dee fika te u kaba, u feni tuwalufu manda fuufuu. Sö a fika hia tjika u dee feifi bëëë ku dee tu pikipiki fisi dë. ");
INSERT INTO srmNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma nöö fa u du ën dë, de bi dë feifi dusu womi sëmbë dee bi njan dë, boiti dee mujëë ku dee mii. ");
INSERT INTO srmNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nöö baka u di dë, hën Masa Jesosi manda u taa be u toona koti wata go ka u bi kumutu, ma nöö hën a o fika naandë ufö faa manda dee sëmbë toona go a wosu. ");
INSERT INTO srmNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nöö di a manda de go kaa, nöö hën a go a wan kununu kamian naandë go ta begi hën wanwan. Nöö di juu dë, kamian ko dungu kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nöö u dë te a mindi wata ala nango ku di boto. Te wan pisi hën wan gaan ventu ko ta seki di wata teee wa sa go möön. ");
INSERT INTO srmNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hën u sai dë ta biinga teefa ganian kanda wa sa dou möönsö. Nöö hën u bia luku te ala. Hën u si wan sëmbë ta waka ku futu tjuwatjuwa a di wata liba ta ko a u. Wë nöö di sëmbë dë, Masa Jesosi wë e, ma nöö wa bi sabi. ");
INSERT INTO srmNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","U mëni taa jooka. Nöö hën u bai kai olo, fëëë nöö u fëëë sö. ");
INSERT INTO srmNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nöö hën Masa Jesosi bai da u wante taa: “Dee sëmbë, wan fëëë e. Un tai hati. Mi wë disi e!” ");
INSERT INTO srmNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nöö hën Petuisi taa: “Masa, ju nö? Wë ee ju di dë tuutuu, nöö i piki mi be mi waka a di wata liba tu ko a i.” ");
INSERT INTO srmNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nöö hën Masa Jesosi piki ën taa: “Antoobi. Waka ko nöö.” Nöö hën Petuisi kumutu a di boto, hën a ta waka a di wata liba nango a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma te wan pisi hën a ko ta luku fa di ventu ta böö ku fa di wata ta seki tjika, nöö hën a panta te na soni, hati fëën latja, nöö hën a ta saka nango a basuwata zuuu. Nöö hën a bai kai wolo taa: “Masa, heepi mi o. Heepi mi!” ");
INSERT INTO srmNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nöö hën Masa Jesosi tëndë maun panjëën. Hën a taa: “Womi, unfa i panta sö? Unfa biibi fii piki gaanfa sö?” ");
INSERT INTO srmNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nöö fa de mbei dë, hën de ko a di boto dendu. Nöö wantewante dë, hën di ventu saka, di wata ko dë piii. ");
INSERT INTO srmNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nöö fa u si dee soni pasa dë, nöö hën u tuu saka tjökö kini a Masa Jesosi fesi dë, hën u taa: “Aai Masa, i da di Mii u Masa Gaangadu tuutuu.” ");
INSERT INTO srmNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nöö hën u go dou a di köndë ka u bi nango. Hën da Ganesalëti. ");
INSERT INTO srmNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nöö di dee sëmbë dë si u kaa, hën de sabi taa Masa Jesosi hën ko dë, nöö hën de paaja buka waaa a hii di köndë lontu dou taa hën ko a de dë. Nöö hën dee sëmbë kisi dee sikima u de, hën de booko gililili ko a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hën de begi ën taa gaantangi, be a da dee sikima pasi u de nama tjë sö seei a di libakoosu fëën buka. Hën Masa Jesosi da de pasi. Nöö fa de ta nama nëën dë, nöö hën hii de tuu fiaa ko bunu u hiniwan siki di de bi abi. ");
INSERT INTO srmNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wë nöö di juu dë, hën wanlö Faliseima ku wanlö Sabima u Wëti kumutu te a Jelusalen ala ko a Masa Jesosi ko hakisi ën wan soni. ");
INSERT INTO srmNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","De taa: “Faandi mbei dee bakama fii ta poi dee wëti fuu sö? Biga de an ta wasi maun a di fa dee gaan sëmbë fuu bi buta fuu musu wasi maun bifö u njan.” Sö de hakisi. ");
INSERT INTO srmNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma nöö hën a piki de taa: “Dee sëmbë o, faandi mbei un ta tötö dee wëti u Gadu buta go a wan së, nöö un ta buta dee lei fuunu a de kamian sö? ");
INSERT INTO srmNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Biga Gadu taki taa i musu kai i mama ku i tata gaan soni. Ee wan sëmbë i dë nöö i ta kosi i mama ku i tata ta wisiwasi de, nöö di wëti taki taa sëmbë o kii i puu dë. Sö Masa Gadu hei mama ku tata tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Ma nöö unu taa wan sëmbë sa taki dëën mama ku ën tata taa: ‘Wë dee sëmbë, heepi an dë. Mi bi abi soni u da unu, ma mi tei ën buta a wan së kaa u mi da Gadu. Wë ma a’ köni fuunu möön e.’ ");
INSERT INTO srmNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nöö un feni taa te wan sëmbë du sö, nöö a bunu poi. Ma na tuu seei. Hogi a ta du fa an ta sölugu ën mama ku ën tata dë. “Nöö hën mbei mi taa un ta tötö dee wëti u Gadu nöö un ta hai dee lei fuunu tja ko buta a de kamian.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nöö hën a kosi de awaa taa: “Un dee bödjëëma aki, hii fa un ta pëë unu seei u bumbuu sëmbë naandë, ma unu wë di tjabukama de kai Jesaaja bi taki e, di a sikifi buta a di Buku taa: ");
INSERT INTO srmNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Dee sëmbë aki, ku de buka de ta mbei taa de ta hei mi, ma mëni u de an dë a mi seei. ");
INSERT INTO srmNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hii fa de mbei taa de ta begi mi kuma Gadu u de naandë, ma sösö soni seei de ta du dë e. Biga na mi wë de ta hei. Fa de ta mbei taa de ta lei sëmbë Gadu wëti dë, ma na tuu seei. Libisëmbë soni tö nöö de ta lei. Sö Jesaaja bi taki, nöö unu wë a bi taki dë e.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nöö hën Masa Jesosi kai dee hia sëmbë dee bi sai dë ko nëën awaa, hën a taa, “Dee sëmbë o, mi o taki wan soni da unu aki, nöö un musu fusutëën bunu. ");
INSERT INTO srmNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mi taki e, taa dee soni i ta njan söndö wasi maun, na de sa mbei i ko sundju a Gadu wojo e. Ma dee soni dee i ta fan ku i buka, de wë ta mbei i ko sundju a Gadu wojo.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nöö di a fan sö te a kaba, nöö hën u dee bakama fëën ko taki dëën taa: “Masa o, fa i si i fan dë, i sabi taa dee Faliseima tei i fu hogi ö?” ");
INSERT INTO srmNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hën a piki u taa: “An dë fuu a’ toobi ku de e, biga na Gadu ta manda de a dee soni de ta du. Nöö hii dee soni dee mi Tata an paandi nöö a o hön de puu. ");
INSERT INTO srmNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dee lö sëmbë dë, de dë kuma wanlö bookowojoma ta suku u de tja oto bookowojoma fu de go pasa ngötö. Nöö na de tuu o kai go a di ngötö nö? Nöö hën mbei mi bi piki unu taa an dë fuun a’ toobi ku de.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nöö hën Petuisi hakisi ën taa: “Wë nöö Masa o, di soni di i taki fu di njan söndö wasi maun dë, ja sa puu ën möön fini da u nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hën a piki taa: “Dee sëmbë, unfa a waka wan bi fusutëën? ");
INSERT INTO srmNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Wë un haika e. Di soni di wan sëmbë ta njan, nöö hën nango nëën bëë. Te wan pisi a o kumutu a i bëë baka, na sö nö? Nöö hën mbei an sa sundju i a Gadu wojo, biga hën da kaba fëën kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","“Ma dee soni dee i ta puu a i buka ta taki, nöö na kaba u de di dë e. Biga a i hati de ta kumutu, nöö de ta mbei i ko sundju a Gadu wojo. ");
INSERT INTO srmNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Biga wë a libisëmbë hati dendu hii pei hogi ta kumutu, kuma kii sëmbë, tei otowan mujëë ku hii oto fanafiti libi a di së u manu ku mujëë, fufuu, mindi soni, ganjan sëmbë, kosi sëmbë, njan sëmbë a baka. Hii dee soni dë tuu ta dë a sëmbë hati u de kumutu ko a döö. ");
INSERT INTO srmNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nöö mi taki da unu e, taa dee lö soni dë wë ta sundju sëmbë a Gadu wojo. Ma fii njan söndö wasi maun a wëti fasi, sö wan soni an sa sundju i a Gadu wojo e, kwetikweti.” Sö wë Masa Jesosi fan ku u tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nöö hën u kumutu a di köndë naandë, hën u go a di pisiwata fu Tilusi ku Sidon. ");
INSERT INTO srmNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nöö fa u go dou dë, hën wan mujëë u di pisiwata naandë ko a Masa Jesosi. Nöö di mujëë dë, Kaana sëmbë a dë e, na Dju sëmbë. Nöö hën a ko ta bai taa: “Masa o, na i da di böngö u Könu Dafiti di bi musu ko nö? Na i da di Heepima nö? Wë nöö a’ tjalihati u mi o. Biga wan gadu dë a di mujëë mii u mi hedi ta dëën sitaafu ta kii. Mi begi i baa, gaantangi, heepi mi ku ën e.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma nöö fa di mujëë ta bai dë seei, ma Masa Jesosi an piki ën möönsö. Nöö hën u dee bakama fëën taki dëën taa: “Masa o, gaantangi, piki di mujëë dë be a disa u baa. A ta bai ta ko a u baka kodo.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hën a piki taa: “Haika e. Gadu an manda mi u mi go a oto pei sëmbë e, ma a dee Isaëli sëmbë fuu nöö mi musu go. Biga de dë kuma wanlö hia lasilasi sikafu di dë söndö tiima, nöö de a’ heepi fanöudu.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma nöö di juu dë hën di mujëë ko suti kini a goon nëën fesi, nöö hën a begi ën taanga taa: “Masa o, gaantangi, heepi mi o. Di mii u mi ta dëdë.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hën a taa: “˻Wë mujëë o, na kë ma kë heepi i e, ma ja dë Isaëli sëmbë,˼ nöö an fiti u puu bëëë a dee mii maun tuwë da dagu mii.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hën di mujëë piki taa: “Aai Masa, wë sö a dë tuu o. Ma dee pikipiki pisi ta puu ta kai a tafa basu wë? Dee dagu mii an sa njan de nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Wë nöö fa di mujëë fan dë, nöö a suti da Masa Jesosi seei, hën a taa: “Aai mujëë, i ta biibi mi taanga tuu o. Wë nöö di soni di i si i ta suku dë, nöö i fendi ën kaa e.” Nöö an kaba u fan seei, hën di mujëë mii u di mama ko bunu gbegedee. ");
INSERT INTO srmNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nöö hën Masa Jesosi kumutu dë, hën u ku ën ta waka a di ze u Galilea bandja dë ta lontu te u go dou a wan kamian ka wanlö kuun dë, nöö hën a go sindo. ");
INSERT INTO srmNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nöö hën wanlö hia sëmbë booko gililili ko nëën möön, nöö de tja hia sikima ko tuwë nëën fesi faa musu kula da de. Hën a kula de tuu fiaa: lanlan sëmbë, bookowojoma, makisamakisa sëmbë, tapabukama, hii de tuu a kula te a kaba gbegedee. ");
INSERT INTO srmNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nöö di dee sëmbë ko si fa dee tapabukama ko ta fan, dee lanma ko ta waka, dee makisamakisa sëmbë ko bëtë seei, dee bookowojoma ko ta si sondi, nöö a bigi da de tee. A foondo de tuutuu, nöö hën de da Masa Gaangadu tangi taa: “Ee, di Gadu fuu dee Isaëli sëmbë aki, a bigi tuu o.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nöö baka fëën, hën Masa Jesosi kai u dee bakama fëën te u piki, a taa: “Tjali u dee hia sëmbë aki kisi mi o. Biga tide mbei di u dii daka di de dë ku mi aki, nöö de an njan na wan wojo sondi möönsö. Wë nöö ma sa manda de go söndö njan, biga a kandë so u de sa faau a pasi.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nöö hën u piki ën taa: “Aai, u jei, ma nöö unsë woo sa fendi sö wan hia soni u njan fuu sa da de, ka u dë a sösö kamian a sabana aki?” ");
INSERT INTO srmNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Hën a hakisi u taa: “Wë un mëni bëëë un abi dë?” Hën u piki ën taa: “U abi sëbën bëëë aki ku wantu piki fisi.” Hën a taa antoobi. ");
INSERT INTO srmNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hën a manda dee sëmbë go sindo leti a goon na ahun liba dë. ");
INSERT INTO srmNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nöö hën de sindo te de kaba, hën Masa Jesosi tei dee sëbën bëëë ku dee pikipiki fisi naandë, hën a da Masa Gadu tangi te a kaba. Nöö hën a booko de pisipisi, hën a tëndë da u taa: “Un tja go paati da dee sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nöö hën u tei, hën u ta paati da dee hia sëmbë dë te dou de tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hën de tuu njan seei teee bëë u de fuu. Nöö hën u toona go pii dee pisipisi dee de njan fika, te fuu sëbën gaan manda. Nöö fa di soni pasa dë, de bi dë fö dusu womi a di kamian ufö i abi dee mujëë ku dee mii. Sö dee sëmbë bi hia tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nöö di de njan tefa de kaba kaa, hën Masa Jesosi manda de go a wosu awaa. Nöö hën u ku ën tei boto hën u koti wata go a di köndë de kai Magidala. ");
INSERT INTO srmNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nöö fa Masa Jesosi ko a Magidala dë, hën dee Saduseima ku dee Faliseima ko nëën. Wë de tu keiki paatëi dë, de an kë piki möönsö taa a Gadu Masa Jesosi kumutu. Nöö fa de ko nëën dë, hën de taa de kë faa lei de wan maaka kumutu a Gadu ala, ee nasö de an o piki taa Gadu hën mandëën ko. ");
INSERT INTO srmNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma nöö hën Masa Jesosi piki de. A taa: “Dee sëmbë, a toobi mi poi da unu. Biga te sapate ee un si bundji a liba ala bë njaan, nöö un taa amanjan sonu o hati. ");
INSERT INTO srmNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te mamate un si di sonu bë hëii, tjuba ta baaka, nöö woon taa tjuba o kai tide. Sö un sabi u wegi dee maaka u liba ala tjika. “Wë nöö unfa a waka wan sa wegi dee maaka dee dë leti a unu wojo un ta si aki? Biga ee un luku dee soni ta pasa a di ten u dë aki, de ta kai seei ku dee soni dee tjabukama u Gadu bi sikifi a fesi e. Nöö hën da di ten de bi taki dë, hën dou kaa.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nöö hën a gandji da de awaa, a taa: “Un dee takulibima aki, un dë leti kuma wan mujëë disëën manu go ta waka ta suku oto manu. ˻Biga Gadu bi da unu dee maaka fëën gaanduwe kaa, nöö hën un disa de go ta suku oto maaka möön.˼ Nöö mi piki unu taa wan o feni oto maaka a mi möönsö e, möön leki di i si mi bi taki da unu kaa u di tjabukama de kai Jona.” Nöö di Masa Jesosi fan ku dee hedima u keiki sö kaa, hën wë a disa de dë. ");
INSERT INTO srmNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nöö hën u ku ën toona subi a boto möön, hën u ta koti nango a di oto së banda ka u bi kumutu. Ma nöö u bi fëëkëtë u tja bëëë go ku u. ");
INSERT INTO srmNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nöö fa u nango dë, hën Masa Jesosi bai u a soni, a taa: “Un mëni unu seei e, dee sëmbë, ku di sooda u dee Faliseima ku dee Saduseima.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma nöö di a fan sö, hën u pakisei wante taa wë a kandë fu di wa tja bëëë, nöö hën mbei a fan sö. ");
INSERT INTO srmNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nöö Masa Jesosi sabi taa sö u ta mëni. Hën a taa: “Dee sëmbë aki, unfa biibi fuunu piki sö? Unfa un sa mëni taa bëëë soni mi ta taki? ");
INSERT INTO srmNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wan ta fusutan mi möönsö nö? Naasë un bi dë di mi tei dee feifi bëëë da feifi dusu sëmbë, de njan te de wei toona fika sömëni manda eti? ");
INSERT INTO srmNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nöö naasë un bi dë möön di mi tei dee sëbën bëëë da dee fö dusu sëmbë, de njan te de wei toona fika sömëni manda möön? ");
INSERT INTO srmNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“Nöö unfa a waka wan ta fusutan taa ma ta a’ bookohedi ku soni u njan? Nöö na bëëë soni mi taki dë. Ma mi taki e, taa un musu mëni unu seei ku di sooda u dee Faliseima ku dee Saduseima.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nöö fa a fan dë ufö u ko kisi u seei awaa taa na di sooda di de ta dian boon, nëën a ta taki, ma di poipoi lei u dee Faliseima ku dee Saduseima di de ta paaja a hii di goonliba, leti kuma wan piki sooda ta soopu ta paaja a wan hia boon, hën wë a ta taki di taki. ");
INSERT INTO srmNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nöö di u dou a oto banda dë, hën u ta waka te u go dou a di pisiwata de kai Sesalia Filipi. Nöö hën Masa Jesosi kai u te u piki, a taa: “Unfa un ta jei de ta taki u Mi di ko dë Libisëmbë Mii aki?” ");
INSERT INTO srmNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nöö hën u piki ën taa: “Wë u ta jei so sëmbë ta taki fii taa i da di dopuma Johanisi, hën toona weki baka a dëdë. So u de taa i dë wan u dee oto tjabukama u Gadu bi dë a fesi kuma Elia, kuma Jelemia sö, hën toona weki baka. Sö u ta jei de ta taki fii.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nöö hën a toona hakisi u taa: “Wë unu wë? Ambë un ta mëni taa mi dë?” ");
INSERT INTO srmNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hën Simon Petuisi piki ën taa: “Masa o, i da di Keesitu e, di Könu Gadu bi paamusi taa a o manda ko. I da di Mii u Masa Gaangadu seei, di abi libi fu teego.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nöö di Masa Jesosi jei fa a fan dë, hën a taa: “Aai womi Simon, ju di mii u Jonasi aki, Gadu naki i kölöku tuutuu. Biga di soni di i ko sabi dë, nöö na libisëmbë lei i ën. Ma mi Tata a liba ala hënseei mbei i ko sabi ën. ");
INSERT INTO srmNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Nöö fa de ta kai i Petuisi dë, na ‘sitonu’ di në fii kë taki nö? Wë nöö mi taki da i taa ku di gaan sitonu i si aki mi o seti di keiki u mi e. Nöö fa mi o seti ën dë, nöö di didibi ku hii di kaakiti di a abi, ku dëdë köndë seei, an o sa tapëën ën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“Nöö mi taki da unu taa mi o da unu taki a di Njunjun Tii u mi dendu, te hiniwan soni di i si un tai a goonliba aki nöö a o dë taitai a Gadu ala. Söseei tu hiniwan soni di un lusu a goonliba aki, a o dë lusulusu a Gadu ala.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nöö di a fan sö te a kaba, hën a bai u tuu seei taa wa musu konda da na wan sëmbë taa hën da di Könu Gadu bi paamusi taa a o manda ko. ");
INSERT INTO srmNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nöö a di ten dë hën Masa Jesosi seti fan ku u, fuu sabi andi o pasa ku ën a bakaten. A taa: “Te wan pisi nöö woo go a Jelusalen. Nöö dee Gaan Womi ku dee Gaan Begima ku dee Sabima u Wëti, de o kisi mi da sitaafu te a tjika de, nöö de o kii mi. Ma nöö a di u dii daka fëën, nöö mi o toona weki baka a dëdë e.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nöö fa a fan naandë, hën Petuisi kai ën tja go a së, hën a fia ku ën taa: “Masa, na taki dee lö soni dë e. Biga de an o sa pasa ku i seei, kwetikweti.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nöö hën a bia gandji dëën taa: “Waka pasa kumutu a mi fesi dë e, ju didibi Saatan. I dë kuma wan sitonu a pasi da mi u mi naki futu kai kumutu a di pasi Gadu buta da mi u mi waka. Biga fa i fan dë, nöö na Gadu da i di pakisei dë e. Libisëmbë pakisei nöö di dë.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nöö di a fan ku Petuisi sö te a kaba, nöö hën a bia fan ku u tuu taa: “Dee sëmbë o, wan mëni fa mi bi fan ku unu nö, taa hiniwan sëmbë abi sitaafu fëën fu tjai ufö a sa waka a mi baka. Nöö ee i kë waka a mi baka tuutuu, nöö i musu disa di soni di i seei ta kë, nöö i tei di sitaafu dë tja. ");
INSERT INTO srmNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Biga ee wan sëmbë i ta suku wan suti libi da i seei a di goonliba aki, nöö ja o feni ën fa i kë möönsö e. Lasi nöö joo lasi. Ma nöö ee i saka i libi fu mi hedi, nöö joo fendi ën kumafa i kë nöömö. ");
INSERT INTO srmNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Nöö ee i feni hii soni u di goonliba aki tuu te dou, ma i seei lasi go a di didibi faja, nöö un heepi seei a abi da i? Nöö andi seei dë a goonliba aki waiti tjika tu, fii tookëën ku di libi u teego? Soni an dë e, baa. ");
INSERT INTO srmNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Biga te wan daka, Mi di ko dë Libisëmbë Mii aki o toona ko a di goonliba aki nöömö, fu mi kuutu a libisëmbë liba. Nöö fa mi o ko dë, nöö mi ku dee basia u mi Tata köndë tuu o ko makandi, nöö ku di gaan hei u mi Tata seei woo ko e. Nöö mi o paka hiniwan sëmbë kumafa a fiti di libi di a bi libi a di goonliba aki.” ");
INSERT INTO srmNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nöö hën a taa: “Mi taki da unu e, taa so fuunu dë aki an o dëdë möönsö bifö un si Mi di ko dë Libisëmbë Mii aki toona ko dou ku di Njunjun Tii u mi.” Sö Masa Jesosi fan ku u tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nöö hën a baka sikisi daka, hën Masa Jesosi tei Petuisi ku de tu baaa Jakobosi ku Johanisi, nöö hën de subi go te a wan hei kununu liba. ");
INSERT INTO srmNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nöö hën de sai dë te wan pisi, hën Masa Jesosi ko tooka a de wojo seei. Fesi fëën ko ta koti faja kuma sonu, nöö dee koosu nëën sinkii ko weti faan te sëmbë wojo an sa kai ku de. ");
INSERT INTO srmNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nöö te u de kë mëni, hën de si tu womi ko taanpu nëën bandja, wan de kai Elia, wan da Mosesi. ˻De tu womi dë bi dë awoo tjabukama u Gadu u fesiten, gaan nëbai sëmbë, nöö de bi dëdë gaanduwe kaa˼ ma nöö hën de ko a Masa Jesosi dë ko ta fan ku ën. ");
INSERT INTO srmNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nöö fa de ta fan ku ën dë, hën Petuisi taa: “Masa o, a bunu fa i tja u ko aki. Nöö ee i kë, nöö mi sa mbei dii tjëkë liba da unu: wan fii, wan u Mosesi, ku wan u Elia.” ");
INSERT INTO srmNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma nöö di a fan sö kaa, hën wan gaan limbo wöluku saka zalalaa ko tapa de buuu. Hën de jei wan töngö ta fan a di wöluku dendu dë taa: “Un luku di lobi Womi Mii u mi aki. Libi fëën ta kai ku mi. Nöö hën fuun ta haika e.” Sö di töngö piki. ");
INSERT INTO srmNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nöö fa de dii bakama u Masa Jesosi jei di fan dë, nöö hën de fëëë te de kai ku fesi a goon. ");
INSERT INTO srmNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hën Masa Jesosi waka go panjan de hën a taa: “Womi o, un hopo. Wan fëëë sö e.” ");
INSERT INTO srmNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nöö di de ko jabi wojo, nöö Masa Jesosi wanwan nöö de si. De an si de tu sëmbë möön. ");
INSERT INTO srmNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nöö hën de toona ta bazia di kununu ta saka nango a goon. Nöö fa de nango dë, hën Masa Jesosi bai de taa: “Un haika e, di soni di un si a di kununu liba naandë, nöö wan musu taki ën da na wan kodo sëmbë e. Un musu hoi ën a unu hati ufö. Tee Mi di ko dë Libisëmbë Mii aki dëdë toona weki baka ufö un sa taki ën.” ");
INSERT INTO srmNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nöö hën de taki dëën taa: “Masa o, u kë hakisi i wan soni. Faandi mbei dee leima fuu, dee Sabima u Wëti, taa Elia hën fosu musu ko ufö di könu Gadu bi paamusi o ko a u?” ");
INSERT INTO srmNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hën a piki de taa: “Awa, fa de ta lei unu dë, nöö sö a dë tuu. Elia bi musu ko a fesi fa a seeka pasi da di Könu. ");
INSERT INTO srmNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma nöö mi taki da unu taa a ko kaa e. Ma dee sëmbë an bi sabi ën, nöö hën de du ku ën kumafa de kë. Nöö söseei de o du ku Mi di ko dë Libisëmbë Mii aki tu.” Sö Masa Jesosi taki. ");
INSERT INTO srmNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nöö fa a fan dë ufö de ko sabi taa Johanisi di Dopuma hën a ta taki dë. Hën wë bi da di Elia di bi musu ko. ");
INSERT INTO srmNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nöö hën de ta bazia di kuun ta ko te de ko kai a palala goon, nöö hën de ko si wanlö hia sëmbë naandë ta luku de. Nöö hën wan womi kule kumutu a dee sëmbë dendu ko kai a goon a Masa Jesosi fesi. Hën a begi ën taa: ");
INSERT INTO srmNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Masa gaantangi, a’ tjalihati fu wan womi mii u mi aki o. Miii siki dë ku ën seei te na soni. So juu a ta naki ën ta tuwë a faja, so juu a ta tuwëën a wata. Sö a ta fukëën tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nöö mi bi tjëën ko a dee bakama fii aki u de heepi mi kulëën, ma de an bi sa heepi mi möönsö. Nöö hën wë i si mi tjëën ko a i seei.” ");
INSERT INTO srmNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nöö hën Masa Jesosi djëmë, a taa: “Ee! Andi seei mi feni a dee sëmbë u di ten aki maun? Fa mi ku de dë aki, de an ta biibi möönsö. Taangajesi nöö de abi sö. Un longi mi musu dë ku unu aki ta hoi pasensi da unu ufö un sa biibi mi?” Nöö hën a taa: “Söö. Wë tja di mii ko a mi aki i si.” ");
INSERT INTO srmNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nöö hën de tjëën ko dëën. Hën a jaka di soni di bi dë nëën liba dë puu tuwë go, nöö wantewante dë hën di mii ko bunu fiaa. ");
INSERT INTO srmNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nöö baka u di dë, hën u dee bakama fëën ko nëën. Hën u hakisi ën taa: “Masa o, andi seei mbei wa bi sa jaka di gadu dë puu a di mii liba?” ");
INSERT INTO srmNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nöö hën a taa: “Awa, wë baaa o, fu di wan ta biibi a di fa wë mbei e. Biga mi taki da unu taa ee un abi wan piki biibi tëin sö seei kuma di sii fu di pau de kai mutaadi, nöö i sa go taki da wan gaan kununu taa ‘hopo kumutu dë’, nöö a o kumutu dë go. Biga te di biibi fuunu dë a di fa kaa, nöö na wan soni o dë di wan o sa du e. ");
INSERT INTO srmNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Ma boiti u di dë, sö wan pei soni, ja sa puu ën a sëmbë liba ee na i tei ten fii begi Masa Gaangadu gaanfa söndö njan.” Sö Masa Jesosi piki u di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nöö baka u di dë, hën u ku Masa Jesosi ko makandi a di pisiwata u Galilea naandë, hën a taki da u taa: “Dee sëmbë, mi kë taki wan soni da unu aki taa Mi di ko dë Libisëmbë Mii aki, nöö wan daka de o buta mi a dee felantima u mi maun. ");
INSERT INTO srmNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nöö de o kii mi e. Ma di u dii daka fëën nöö mi o toona weki baka. Sö wë o pasa ku mi e, dee sëmbë.” Nöö fa a fan ku u dë, nöö a dë wan gaan tjali soni seei da u, a da u fuka te na soni. ");
INSERT INTO srmNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nöö hën u toona go a Kapenaumi möön. Nöö hën dee sëmbë ta pii möni da di Gaan Keikiwosu a Jelusalen dë, nöö hën de ko a Petuisi ko hakisi ën taa: “Wë mati o, fa di mësitë fuunu sai dë, hën an ta paka di keikimöni nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hën a taa: “Aai höön, a ta paka.” Ma nöö fa de ta fan dë, nöö Masa Jesosi an sai naandë. Nöö hën Petuisi go nëën a wosu. Ma nöö fa a denda a di wosu, an jabi buka fan seei, hën Masa Jesosi kai ën taa: “Womi Simon.” Hën a piki. A taa: “Mi kë hakisi i wan soni. Fa dee könu u di goonliba aki ta pii lantimöni, nöö na ambë de ta pii ën? A deseei mii, naa a dee sëmbë dee an dë a di könu famii?” ");
INSERT INTO srmNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Hën Petuisi piki ën taa: “Wë a dee oto sëmbë dee na famii u könu.” Nöö hën Masa Jesosi taa: “Söö. Wë hën da an dë u dee mii u di könu seei musu paka, na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma nöö un boo paka nöö e, fu de an musu mati u. “Nöö haika e. Tei di huku fii nöö i go a huku. Nöö di fosu fisi di i si joo kisi nöö i jabi ën buka luku, nöö joo si wan möni nëën dendu, nöö i tei ën tja go paka u mi ku i.” ");
INSERT INTO srmNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hën u dë te wan daka, nöö hën u dee bakama u Masa Jesosi ko nëën ko hakisi ën taa: “Masa o, u kë hakisi i wan soni. Undi fuu sa dë di möön hei wan a di Njunjun Tii u Gadu dendu di ta ko aki?” ");
INSERT INTO srmNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nöö hën Masa Jesosi kai wan piki mii tja ko nëën, nöö hën a butëën leti a u dendu naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Hën a taa: “Wan ta si di mii aki nö? Ee wan sëmbë ja bia ko abi di fasi di wan piki mii abi, nöö ja o sa dë a di Njunjun Tii dendu möönsö e. ");
INSERT INTO srmNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ma nöö ee i abi sö wan sakafasi, nöö joo dë gaan hei sëmbë a di Njunjun Tii dendu.” ");
INSERT INTO srmNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hën a taki da u möön taa: “Ee i du sö wan piki mii kuma di i si aki wan bunu fu di a nama ku mi hedi, nöö miseei wë i du di bunu dë kaa e. ");
INSERT INTO srmNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nöö ee wan mii kuma disi ko biibi a mi liba, nöö hën wan fuunu mbei a kumutu a Gadu pasi, nöö mi taki e, di sitaafu fëën di joo kisi a Gadu nöö a o hebi gaanfa e. A bi sa möön bëtë da i de bi tei wan gaan gindi sitonu tai a i gangaa te de kaba, nöö de tja i go tuwë a di möön fundu kamian u di ze dubuu pii. Biga di sitaafu dë an o hebi kuma di i bi o kisi a Gadu, ee i bi mbei so wan sëmbë kumutu a di pasi u Gadu.” ");
INSERT INTO srmNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hën a taa: “Mi bai helu da di goonliba aki e, da dee soni fëën ta ganjan sëmbë puu a Gadu pasi. A dë sö tuu taa sö di goonliba aki dë kaa, ma tökuseei mi bai helu da dee sëmbë dee ta buta sëmbë fu de du dee soni dee an kai ku Gadu. ");
INSERT INTO srmNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","“Nöö mi bai unu taa ee i kë du wan soni ku i maun di o mbei i kumutu a di pasi u Gadu, nöö a möön bunu i koti di maun fii kolon puu a i sinkii tuwë wante. “Nöö söseei tu, ee ku di wojo fii dë i kë luku wan soni di o puu i a Gadu pasi, nöö a möön bunu i diki ën puu tuwë. Biga a möön bëtë da i i lasi wan kamian fii sinkii ma i feni di libi u teego, möön leki de hiti i ku telu go a di didibi faja. ");
INSERT INTO srmNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Nöö mi taki da unu möön e, taa un musu mëni unu seei bunu a di fa i ta libi ku dee piki mii kuma di i si aki sö. Wan musu tei de u sösö soni. Biga dee basia u mi Tata köndë dee ta waka nango ta ko nëën fesi nöömö dë, nöö de wë ta watji dee mii aki e. Hën mbei wan musu ta kai de sösö soni.” ");
INSERT INTO srmNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nöö hën a tei wan oto konda da u, a taa: “Ee wan sëmbë abi wan höndö sikafu ta kiija, nöö hën wan u de kumutu a dee otowan dendu lasi go te a go pii, nöö unfa i mëni? Na a o disa dee nëigiteni-ku-nëigi ka de ta njan a di sabana dë, nöö a go suku di lasi sikafu dë tee a feni ën nö? Aai, sö a o du. ");
INSERT INTO srmNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nöö mi taki da unu, taa te a feni di wan kodo di bi lasi go dë, nöö a o wai ku ën gaanfa seei möön leki dee nëigiteni ku nëigi dee an bi go lasi. ");
INSERT INTO srmNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Nöö söseei wë mi Tata di dë a liba ala dë tu e, dee sëmbë. Biga an kë na wan kodo sëmbë fëën musu lasi, te dou ku dee piki mii kuma disi aki seei. Sö a ta kai de gaan soni tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nöö mi o taki wan oto soni da unu möön. Ee wan otowan fii du i wan hogi, nöö i musu go nëën i wanwan go fan ku ën, fuun seeka di taki be un ko bunu baka. Nöö ee di otowan fii piki tei di fan fii, nöö hën da i wini ën tja ko buta a pasi. ");
INSERT INTO srmNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma ee i fan ku ën an kë haika möönsö, nöö i musu toona go kai wantu sëmbë, nöö un tuu go nëën makandi nöö un fan ku ën te un kaba. Nöö a o kai ku di Buku u Gadu ka a sikifi taa i musu abi tu ee nasö dii kotoigima ufö de sa sitampu wan soni taa a dë tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","“Ma nöö ee di otowan fii an kë haika unu möönsö fu di taki musu seeka, nöö be un tja di taki go a dee oto biibima fuunu ka un ta miti makandi a keiki. Nöö ee un go taki ën te un kaba, ma seei di sëmbë an kë piki möönsö, nöö a ko dë taa heepi an dë. Nöö un luku ën kuma wan sëmbë na sabi soni fu Gadu, kuma wan takulibima. ");
INSERT INTO srmNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nöö mi taki da unu e, taa fa un dee sëmbë u mi ta ko makandi naandë, nöö di soni di i si un sitampu te un kaba taa hën bunu, nöö Gadu seei o nama ku unu nëën taa a bunu. Nöö ee un luku wan soni a goonliba aki tee un kaba sitampu taa an bunu, nöö Gadu seei o taa an bunu tu. Sö taki fuunu a goonliba aki o a’ kaakiti tjika e. ");
INSERT INTO srmNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nöö mi taki e, taa ee wantu fuunu ko miti a wan kamian fuun begi mi Tata a liba faa du wan soni da unu, nöö mi piki unu gbelin taa a o du ën e. ");
INSERT INTO srmNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Biga ka tu dii fuunu ko makandi fu di un nama ku mi, nöö mi seei o dë leti a unu mindi dë.” ");
INSERT INTO srmNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nöö hën Petuisi ko nëën, hën a hakisi ën taa: “Wë Masa o, ee wan otowan u mi ta du hogi ku mi nöö hën mi puu ën a bëë te dou sëbën pasi kaa, nöö an tjika nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hën a piki ën taa: “Nönö, womi, an tjika e. I musu ta puu ën a bëë nöömö, ee sëbënteni toon sëbën pasi seei. Ja musu hoi ën a bëë möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nöö hën a toona da u wan oto möön faa lei u fa di Njunjun Tii u Gadu dë. A taa: “A dë leti kuma wan könu di abi sömëni wookoma ta juu möni nëën. Nöö hën a dë te wan daka nöö hën a kai de ko fu de pakëën di möni di de bi juu nëën. ");
INSERT INTO srmNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Wë nöö di de seti di soni, hën de tja wan sëmbë ko nëën. Di sëmbë naandë bi abi sömëni milion faa pakëën. ");
INSERT INTO srmNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","“Hën di könu taa: ‘Wë mati o, da mi di möni u mi di i musu paka mi.’ “Ma nöö di womi an abi di möni. Nöö hën di könu taa: ‘Wë antoobi. Un sei ën, hën ku ën mujëë ku dee mii fëën ku hii soni a abi tuu, nöö un tja di möni u de ko da mi, be mi feni di möni u mi.’ ");
INSERT INTO srmNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma nöö di di womi jei sö, nöö hën a saka tjökö kini a goon nëën fesi, hën a begi ën taa: ‘Köndë Masa o, i a’ leti, ma mi begi i gaantangi hoi pasensi da mi o. Di möni di mi juu a i, nöö mi o paka i ën nöömö.’ ");
INSERT INTO srmNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Nöö fa a begi ën te a kaba dë, nöö hën tjali fëën kisi di könu. Nöö hën a taa: ‘Wë mati o, wë an dë fii paka mi di möni möön e. Un boo disa di taki nöö.’ Nöö di a fan ku ën sö tefa a kaba, nöö hën a mandëën go. ");
INSERT INTO srmNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ma nöö fa di womi kumutu dë, hën a go miti ku wan otowan fëën a pasi, di hën ku ën tuu ta wooko makandi da di könu. Nöö di womi aki bi juu kuma wan teni-a-feifi kölu sö a di womi di kumutu a di könu dë. Nöö fa de miti dë, nöö hën a djombo kisi di otowan a gangaa gbolou peeta. Hën a taa: ‘Söö, womi, wë u miti. Paka mi di möni u mi wantewante, nasö mi o du ku i tide.’ ");
INSERT INTO srmNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Nöö hën di womi tjökö kini a goon nëën fesi hën a begi ën taa: ‘Gaantangi baa, hoi pasensi da mi o. Te mi feni di möni nöö mi o da i ën nöömö.’ ");
INSERT INTO srmNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ma nöö di fosu womi naandë, hën an dë a di taki dë seei, kwetikweti. An haika seei andi di otowan fëën ta taki. Nöö hën wë a mbei dee siköutu ko tei ën tja go buta a dunguwosu fu tee a sa paka di paima. ");
INSERT INTO srmNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ma nöö fa di soni pasa dë, nöö dee oto wookoma u könu sai dë ta si, nöö hën de kule tjalalaa go piki di könu taa sö wan soni de si pasa, a bigi te an sa taki. ");
INSERT INTO srmNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Nöö hën di könu toona kai di wookoma dë ko nëën möön, hën a gandji dëën seei awaa, a taa: ‘Ju hogihatima ju, hii di gaan hia möni di i bi abi u paka mi nöö hën wë mi disa i fu di i bi begi mi. ");
INSERT INTO srmNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wë nöö an bi bunu da i fii abi tjalihati da di otowan fii nö? Jee? Sö i dë ö?’ ");
INSERT INTO srmNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Nöö hati fëën boonu ku ën teee, nöö hën a kai dee siköutu, a taki da de taa: ‘Un kisi di sëmbë dë tja go tuwë a dunguwosu, be a ta tja sitaafu fu teee a paka hii di möni di a bi musu paka mi, tee dou ku dee lasiti bësënsi tuu.’ ” ");
INSERT INTO srmNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nöö sö Masa Jesosi taki wan oto da u te a kaba. Hën a taa: “Un si fa di soni pasa dë ö? Wë nöö leti sö nöö mi Tata di dë a liba ala o libi ku unu tu e, ee wan puu dee otowan fuunu a bëë ku hii unu hati a dee hogi de ta du unu.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nöö hën a baka u di dë, hën u ku Masa Jesosi kumutu a Galilea naandë latja Judea go te a di oto së banda u Joodan Lio. ");
INSERT INTO srmNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nöö fa u ta waka nango dë, wanlö hia sëmbë ta dë a Masa Jesosi baka ta ko nöömö. Nöö di u dou a di oto së banda u di lio, nöö hën a kula dee sikima u de tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nöö di juu dë, hën wanlö Faliseima ko nëën fu de poobëën luku ee de sa feni föutu nëën u de tjëën go kaagi da lanti. Nöö hën de hakisi ën taa: “Mësitë o, u kë hakisi i wan soni aki. Unfa di wëti u Gadu taki? Wan womi sa tuwëën mujëë fu hiniwan piki soni di hën ku ën abi ö?” Sö de hakisi ën. ");
INSERT INTO srmNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nöö hën a piki de taa: “Wan bi lesi a di Buku nö, taa di Gadu mbei goonliba te a kaba nöö hën a mbei libisëmbë, wan womi ku wan mujëë. ");
INSERT INTO srmNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nöö kumutu a di ten dë te kisi fa u dë aki, wan womi o kumutu disa hën mama ku hën tata go libi ku ën mujëë, nöö de o ko dë wan sinkii. ");
INSERT INTO srmNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","De an o dë kuma tu sëmbë möön. Wë nöö fa Masa Gaangadu buta de ko di wan dë, nöö libisëmbë aan leti u paati de möönsö e.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hën de hakisi ën taa: “Wë nöö ee a dë sö tuu, nöö faandi mbei Mosesi bi buta da u Dju sëmbë taa i sa mbei wan pampia a lanti te i kaba taa i ku di mujëë fii tuwë, nöö i manda di mujëë fii go? Faandi mbei a taki sö?” ");
INSERT INTO srmNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hën a taa: “Awa, wë fa a da unu di pasi dë, fu di un abi taangajesi wë mbei e. Ma a seti u goonliba nöö an bi dë sö. ");
INSERT INTO srmNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nöö mii taki da unu seei gbelin taa ee wan sëmbë i abi wan mujëë fii nöö i tuwëën ma na manu a tei a i wosu nöö hën i toona go tei wan oto mujëë, nöö Gadu wëti hën wë i booko dë e.” Nöö sö Masa Jesosi piki dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nöö di u dee bakama fëën jei a taki sö, hën u taa: “Wë nöö Masa o, ee sö di wëti fu Gadu dë, nöö an dë fu womi abi mujëë, an dë u mujëë abi manu tu e. Un boo dë fuu sö nöö.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hën a taa: “Ma na hii sëmbë sa fika sö e. Nönö. Ma dee sëmbë dee a kai da, nöö de nöö sa dë sö. ");
INSERT INTO srmNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Biga so sëmbë an sa tei mujëë biga de pai ën sö kaa. So sëmbë an sa tei mujëë fu di oto sëmbë du hogi ku de. So sëmbë, deseei feni ën fu bunu fu de dë ku wan hati ta biinga fu di Tii u Gadu musu paaja a mundu, hën mbei de an tei mujëë. “Nöö di sëmbë di sa tei di lei aki, nöö be a tei ën e.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nöö di juu naandë, hën de tja wanlö miii ko a Masa Jesosi faa musu buta maun a de hedi begi da de. Nöö di u dee bakama fëën si sö, hën u gandji da dee sëmbë seei. ");
INSERT INTO srmNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma nöö hën Masa Jesosi si taa sö u ta du, hën a bai u taa: “Nönö womi, wan tapa de e. Be de tja dee mii ko da mi nöö. Biga dee sëmbë dee abi sö wan ˻saka˼ fasi kuma dee piki mii i si aki, nöö de nöö o dë a di Tii u Gadu dendu e.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hën a buta maun a dee mii hedi, hën a begi da de te a kaba. Nöö baka fëën, hën u kumutu a di kamian dë nango möön. ");
INSERT INTO srmNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Te wan pisi, hën wan kijoo ko a Masa Jesosi hën a kai ën te a piki, a taa: “Mësitë, wë mi ko a i aki. Mi ko hakisi i ee un bumbuu soni dë fu mi sa du nöö mi feni di libi u teego?” ");
INSERT INTO srmNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hën Masa Jesosi hakisi ën taa: “Faandi mbei i hakisi mi soni u bumbuu? Biga Gadu nöö da bumbuu sëmbë, nöö ee i kë feni libi u teego, nöö i musu hoi i seei a dee wëti fëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hën di womi hakisi taa: “Undi u dee wëti fëën fu mi hoi?” Hën a taa: “Ja musu kii sëmbë. Ja musu go a wan mujëë na mujëë fii. Ja musu fufuu sëmbë soni. Ja musu mindi soni da sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","I musu a’ lesipeki da i mama ku i tata. I musu lobi hii sëmbë kumafa i lobi i seei.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hën a taa: “Aaa, dee soni dë nö? Wë hii dee wëti dë tuu seei mi bi ta hoi kaa, fu sensi mi bi dë miii. Ma nöö ee i si taa wan soni toobi mi eti, nöö gaantangi be i taki ën da mi o.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Hën Masa Jesosi piki ën awaa, a taa: “Söö, wë antoobi. Wë ee i kë ko dë wan bumbuu sëmbë te dou, nöö i go sei hii dee gudu fii dee i abi tuu te i kaba, nöö i tei di möni paati da dee möfina sëmbë u di köndë. Nöö te i du sö kaa, nöö joo abi gudu a Masa Gaangadu köndë te a hia e. Nöö te i kaba, nöö i ko bakama u mi ta waka a mi baka.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wë nöö fa Masa Jesosi fan ku ën te a kaba dë, nöö hën di kijoo bia go ku gaan tjali nëën hati, biga a abi hia gudu tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nöö fa a go dë, hën Masa Jesosi bia fan ku u dee bakama fëën, a taa: “Womi, a dë wan taanga soni tuu fu sö wan guduma musu ko a di Tii u Gadu dendu e. ");
INSERT INTO srmNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ja si fa di mbeti de kai kamëli bigi ö? Ee i luku ën te i kaba, nöö ja sa maakëën seei taa a sa pasa na aguja baaku. Ma mi piki unu taa, di soni dë möön fukë möön leki fu wan guduma sa ko a di Tii u Gadu dendu.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nöö di u jei sö kaa, nöö a toobi u seei. Hën u hakisi ën taa: “Wë ee sö a taanga ˻da wan sëmbë di Gadu heepi sö te a ko gudu˼, nöö ambë seei sa feni di libi u teego baa?” ");
INSERT INTO srmNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hën a luku u diin sö, hën a taa: “Ee a nama a di kaakiti u libisëmbë, nöö na wan sëmbë sa feni ën e. Ma a di kaakiti u Masa Gadu a nama, nöö soni seei an dë di hën an sa du.” ");
INSERT INTO srmNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nöö hën Petuisi taa: “Wë Masa o, uu bi disa hii soni seei ko ta waka a i baka, nöö un paima u o feni?” ");
INSERT INTO srmNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hën a taa: “Haika e. Te a dou di juu fu hii soni musu ko njunjun, nöö Mi di ko dë Libisëmbë Mii aki o go sindo a di könu sutuu u mi ku hii di hei u Gadu di a abi. Nöö di juu dë, nöö un dee tuwalufu sëmbë bi ta waka a mi baka aki, nöö woon ko sindo a tiima sutuu tu, ta kuutu dee tuwalufu lö u Isaëli. ");
INSERT INTO srmNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Nöö na unu wanwan o feni paima e. Ma hii dee sëmbë dee disa de wosu, ee nasö de baaa, ee nasö sisa, tata, mama, miii, pandasi kamian, hiniwan soni fu di a kë waka a mi baka hedi, mi taki da unu taa dee lö sëmbë dë an o lasi. Biga de o toona feni dee soni naandë höndö toon baka, nöö te fu kaba fëën nöö de o feni di libi u teego a Gadu tu. ");
INSERT INTO srmNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Nöö di juu dë, nöö sömëni sëmbë dee de bi ta tei u heihei sëmbë a goonliba aki, de tuu o ko dë lagi sëmbë. Nöö sömëni sëmbë dee bi dë lagima a goonliba aki o ko hei sëmbë awaa.” Sö Masa Jesosi taki da u tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nöö hën wë Masa Jesosi konda wan oto woto da u möön, faa lei u fa di Njunjun Tii u Gadu dë. A taa: “Wan guduma abi wan gaan goon fëën. Nöö hën di mamate biten hën a hopo go suku sëmbë fu de heepi ën wooko di goon. ");
INSERT INTO srmNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nöö di a feni sëmbë, hën a mbei buka ku de te a kaba taa a o paka de wan daka wooko möni. Hën de taki aai, a bunu. Nöö hën wë a manda de go a di goon. ");
INSERT INTO srmNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nöö hën a sai dë te kuma nëigi juu sö, hën a toona go suku sëmbë möön u de musu heepi ën wooko di goon. Nöö hën a go si wanlö sëmbë taanputaanpu pii a wojowojo naandë, de aan soni seei u du möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Nöö hën a taki da de taa: ‘Un ko go wooko da mi a mi goon, nöö mi o paka unu kumafa a fiti.’ Hën de taki aai, nöö hën a manda de go. ");
INSERT INTO srmNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Nöö hën a dë te kuma tuwalufu juu, hën a toona go suku sëmbë möön fu de heepi ën wooko di goon. Hën a feni sëmbë möön. “Nöö a di dii juu, hën a toona go suku möön. ");
INSERT INTO srmNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Hën a dë tee sapate feifi juu hën a toona go möön. Hën a go si wanlö sëmbë dë taanputaanpu a wan kamian, na soni seei de ta du möönsö. “Hën a hakisi de taa: ‘Andi mbei un dë taanputaanpu aki di wan hii daka nöömö sö?’ ");
INSERT INTO srmNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Hën de taa: ‘Wë nönö, wa feni wooko seei möönsö e.’ “Nöö hën a taa: ‘Söö. Wë mi o manda unu be un go wooko a mi goon ala. Un kë ö?’ “Hën de taki aai. Hën a manda de go a di wooko. ");
INSERT INTO srmNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nöö hën de ta wooko tee fa juu kisi u de kumutu a di wooko. Nöö hën di sëmbë abi di goon hën a go fan ku di basi taa: ‘Wë go kai dee wookoma tja ko, nöö i paka de da mi. Nöö joo seti ku dee bi ko lasiti dë te kisi dee fosu sëmbë dee bi ko di mamate e.’ ");
INSERT INTO srmNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Nöö hën di a go u go paka de, nöö hën a seti ku dee bakawan hën a paka de wan hii daka möni. Nöö sö a paka de tuu te dou. ");
INSERT INTO srmNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Ma nöö di a paka dee sëmbë bi ko a fesi, nöö de bi mëni taa de o kisi möön hila möni möön dee ko a baka dë. Ma nöö de ko si taa di wan möni nöö de tuu feni. ");
INSERT INTO srmNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nöö di soni an kai ku de seei, nöö hën de sai dë ta guunjan di sëmbë abi di goon. ");
INSERT INTO srmNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Te wan pisi hën de go nëën gbolo, hën de hakisi ën taa: ‘Unfa di soni waka? Di mamate hën u ko dë ta pena a di sonu mindi tefa di ndeti aki, ma nöö dee sëmbë dee wooko di wan kodo juu langa dë, u ku de tuu kisi di wan seei möni. A bunu sö nö?’ ");
INSERT INTO srmNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Nöö hën di goon masa kai wan u de, a taa: ‘Mati.’ “Hën a piki. “A taa: ‘Fa un taki dë, nöö ma du hogi ku unu e. Biga na mi ku unu bi mbei buka taa mi o paka unu wan daka möni nö? Wë nöö un mëni dë a i maun naandë? Na wan daka möni mi da i dë nö? ");
INSERT INTO srmNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","“ ‘Nöö unfa i pakisei? Di soni di mi abi, ma sa du ku ën kumafa mi kë nö? Sö nöö mi bi kë da dee sëmbë dee ko lasiti dë, nöö fu di mi abi bunuhati u de fëën mbei un ta haun sö nö?’ ” ");
INSERT INTO srmNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sö wan oto Masa Jesosi tei konda da de. Hën a taa: “Sö nöö a o dë a di Njunjun Tii u Gadu e. Dee sëmbë i mëni taa o dë a fesi, nöö de sa ko dë a baka e. Nöö dee sëmbë i sabi taa o dë a baka, nöö de sa ko fesima.” ");
INSERT INTO srmNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nöö a baka u di dë, hën Masa Jesosi o go a Jelusalen. Nöö hën a kai u dee tuwalufu bakama fëën a së. Hën a fan ku u te a kaba taa: ");
INSERT INTO srmNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Dee sëmbë, un haika e. Woo go a Jelusalen awaa. Nöö fa i si woo go dë, nöö wan gaan soni o pasa ku Mi di ko dë Libisëmbë Mii aki e. De o sei mi da dee Gaan Begima ku dee Sabima u Wëti, nöö de o kuutu ku de na de te de kaba fiti buka taa mi musu dëdë. ");
INSERT INTO srmNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nöö de o tja mi go buta a dee oto köndë sëmbë maun dee na dë Dju sëmbë, u de ta sösö mi ta mbei mi fa. Nöö de o fon mi te a tjika de ufö de o tei mi tja go peka a lakpa pau kii. Ma nöö a di u dii daka, nöö mi o toona weki baka e.” ˻Sö wë a fan ku u gbelingbelin tjika.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ma nöö baka di Masa Jesosi fan sö, hën di mama u Jakobosi ku Johanisi, dee mii u Zebedeosi, ko nëën ko tjökö kini a goon nëën fesi taa: “Masa o, mi kë begi i wan soni.” ");
INSERT INTO srmNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nöö hën Masa Jesosi piki ën taa: “Antoobi, mujëë. Andi i kë?” Hën a taa: “Wë ja si dee tu womi mii u mi aki ö? Wë mi ko begi i taa te joo subi a di könu bangi fii, fii tii di köndë, nöö mi kë i mbei de sindo a i bandja, wan u de a i leti maun së, di otowan a i töötömaun së.” ");
INSERT INTO srmNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hën Masa Jesosi hakisi ën taa: “Wë mujëë o, fa i ko begi mi di soni aki, ma nöö i saandi i ta begi mi nö?” Hën a bia fan ku de tu baaa, a taa: “Womi, di soni di de lai da mi u mi bebe aki, nöö un sa bebëën tu ö?” Nöö hën de taa: “Aai, Masa, u sa bebëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hën a taa: “Awa, wë woon bebe wan pikiwan fëën tuu o. Ma haika e. Ee a dë taa fii ko sindo a dee hebi kamian a mi bandja dë, nöö an dë a mi aki fu mi sa mbei buka ku unu nëën e. Biga dee sëmbë dee mi Tata a liba ala buta, nöö de nöö sa feni dee lö kamian naandë.” Sö Masa Jesosi piki de. ");
INSERT INTO srmNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wë nöö di u otowan ko jei fa de tu baaa bi fan dë, nöö hati fuu ko boonu ku de seei. ");
INSERT INTO srmNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nöö hën Masa Jesosi kai hii u tuu ko nëën makandi, hën a fan ku u taa: “Womi, un haika e. Fa dee hedima u di goonliba aki ta tii köndë, nöö de ta masa sëmbë ta buta de a de basu, nöö dee sëmbë dee dë a de basu dë seei ta masa oto sëmbë tu ta buta a de basu. A sö wan fasi wë dee hedima u goonliba aki ta tja köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","“Ma nöö unu, wan musu dë sö e. Nönö. Biga ee wan fuunu kë ko heima a di Njunjun Tii u Gadu aki, nöö i musu saka i seei da di otowan fii. ");
INSERT INTO srmNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ee i kë ko fesima u dee otowan, nöö i musu ko dë kuma futuboi seei da de. ");
INSERT INTO srmNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","A di soni dë un musu ta djeesi mi e, dee sëmbë. Biga fa i si Mi di ko dë Libisëmbë Mii ko a goonliba aki, nöö ma ko fu sëmbë musu dini mi e, ma mi ko u miseei musu dini sëmbë. Mi ko u mi lasi mi libi seei paka paima fu sömëni hia sëmbë sa ko bunu ku Gadu.” Sö Masa Jesosi taki da u a di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nöö hën u ku ën ta waka nango tefa u go dou a wan köndë de kai Jelikou. Nöö fa u nango dë, na u wanwan e. Wanlö gaan hia sëmbë ta waka a Masa Jesosi baka gidjii kumafa de bi guwenti kaa, nöö hën u ta kumutu a di köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nöö di juu dë tu bookowojoma bi dë leti a bandja pasi naandë. Nöö di de jei taa Masa Jesosi hën ta pasa dë, nöö hën de seti bai dëën taa: “Masa gaantangi, na i da di bakamii u Könu Dafiti di bi musu ko nö? Saa u ooo, saa u!” Sö de ta bai. ");
INSERT INTO srmNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma nöö dee hia sëmbë dee ta waka ku u dë ta gandji da dee bookowojoma taa: “Un kabuka naandë!” Ma de an haika seei. Awaa de ta bai taa: “Masa, ju di Heepima dë, u begi i gaantangi, saa u ooo! Heepi u!” ");
INSERT INTO srmNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nöö hën Masa Jesosi taanpu piii, hën a kai de. Hën de ko dou. Hën a hakisi de taa: “Andi un kë fu mi musu du da unu?” ");
INSERT INTO srmNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hën de taa: “Masa, u kë fii heepi u be u ko ta si soni.” ");
INSERT INTO srmNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nöö fa de fan dë, hën tjali u de kisi Masa Jesosi tee na soni, hën a tëndë maun nama a de wojo. Nöö hën wantewante dë, hën wojo u de limbo, de ko si soni gbegedee. Nöö hën de ta waka nango a Masa Jesosi baka, de ku dee hia sëmbë dë. ");
INSERT INTO srmNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nöö u ku Masa Jesosi nango tefa u ko dou a wan köndë de kai Betifaigi. Di köndë dë dë zuntu ku Jelusalen, leti a di kuun de kai Oleifi Kuun bandja naandë. Nöö hën Masa Jesosi kai tu fuu dee bakama fëën, ");
INSERT INTO srmNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","hën a taki da de taa: “Womi, un go a di köndë a u fesi naandë e. Nöö te un go dou nöö woon si wan buliki dë taitai ku ën mii nëën bandja. Nöö un lusu de tja ko da mi. ");
INSERT INTO srmNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Nöö ee a ko dë sö taa wan sëmbë ko hakisi unu taa: ‘Unsë un nango ku dee mbeti?’ nöö un piki ën taa: ‘Di Masa fuu, hën abi de fanöudu,’ nöö de o disa de da unu.” Sö Masa Jesosi fan ku de tu bakama te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wë nöö fa i si di soni o pasa aki, nöö a o kai ku di soni wan tjabukama u Gadu bi sikifi gaanduwe a fesi, a taa: ");
INSERT INTO srmNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Un go taki da dee sëmbë u Jelusalen naandë, leti a Sion dë seei, taa: “Un luku di könu fuunu ta ko a unu a wan saapi fasi dë. A dë sindosindo a wan buliki liba ta waka ta ko, a wan buliki mii seei.” Sö wë di tjabukama bi taki fu di könu Gadu o manda ko, nöö awaa a ta pasa. ");
INSERT INTO srmNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nöö hën de tu bakama du leti kumafa Masa Jesosi manda de. Biga de nango te de go dou, hën de go si di buliki taitai ku ën mii nëën bandja. ");
INSERT INTO srmNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hën de lusu de hën de tei tja ko da Masa Jesosi. Nöö hën de jabi koosu a de baka, nöö hën Masa Jesosi subi ˻a di miii wan liba˼ ta waka nango a Jelusalen. ");
INSERT INTO srmNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nöö di juu dë, hën dee hia sëmbë dee ta waka ku u naandë, hën de tei koosu jabi a di pasi liba, so sëmbë ta koti palo maun ta tuwë a di pasi u di buliki di Masa Jesosi dë nëën liba musu waka a de. Bigi nöö de ta bigi ën sö. ");
INSERT INTO srmNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nöö hën de ta waka nëën baka ta waka nëën fesi, te wan pisi hën de seti bai dëën taa: Ke baa, u böö! Di Gaan Könu fuu dou, di Bakamii u Könu Dafiti di Gadu bi paamusi u. Masa Gaangadu musu dë ku i e! Fa i si a manda i ko aki, në fii musu bai te dou a Gadu Köndë ala! Sö dee hia sëmbë ta bai ta wai ta mbei piizii dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nöö fa u mbei dë, nöö Masa Jesosi dou a Jelusalen kaa, nöö di juu dë köndë ta booko seei, sëmbë ta mbei wajawajawajawaja. Sëmbë ta hakisi taa: “Maingë, ambë ko aki?” ");
INSERT INTO srmNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hën de taa: “Ja jei ö? Jesosi u Nazalëti wë, di tjabukama u Gadu di ta dë a di pisiwata u Galilea, hën ko aki e, hën wë u ta wai ku ën sö.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nöö fa Masa Jesosi ko dou a Jelusalen naandë, nöö hën a go wante a di Wosu u Gadu. Nöö di a go dou, hën a si wanlö hia sëmbë sai naandë ta sei soni da dee wakama ta ko dë. De ta sei dee mbeti ku dee pomba sö dee de ta kii da Gadu ta paka paima. So sëmbë sai dë ta tooka möni. Nöö sö de buta di pisi kamian ko dë kuma wojowojo ta wooko möni te a hia a dee sëmbë ta ko dë. Nöö hën di Masa Jesosi si sö kaa, hën hati fëën boonu seei. Hën a jaka dee sëmbë puu dë, a kandi dee tafa u de tuwë djolou a goon, a tötö dee bangi u dee sëmbë ta sei pomba dë tuwë ku baka a goon. ");
INSERT INTO srmNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hën a gandji da de taa: “Wan bi jei fa Masa Gaangadu bi taki a di Buku ö? A taa di wosu fëën dë wan kamian ka sëmbë musu ta ko ta begi ën. Ma nöö unu tei ën buta ko tan kamian u fufuuma!” ");
INSERT INTO srmNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nöö a baka u di dë, hën dee bookowojoma ku dee lan sëmbë u di köndë ko nëën naandë a di Wosu u Gadu, nöö hën a kula de te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nöö di juu dë, wanlö mii sai dë eti ta kanda ta bai taa: “Gaantangi u di Bakamii u Könu Dafiti di Masa Gadu manda da u aki ooo!” Ma nöö di dee Gaan Begima ku dee Sabima u Wëti ko si dee foombo wooko Masa Jesosi ta du dë, ku di fa dee mii ta kanda ta bai dëën a di Wosu, nöö hati u de ko boonu. ");
INSERT INTO srmNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hën de taki dëën taa: “Fa dee mii ta bai ta kai olo dë, ja ta jei fa de ta taki ö? Ja o tapa de be de kabuka nö?” Hën a piki de taa: “Awa, mi ta jei. Ma nöö wan bi lesi a di Buku u Gadu ö, taa Gadu ta buta dee piki mii u de gafëën, te dou ku dee mii a bobi tuu.” Nöö hën di a taki sö, ");
INSERT INTO srmNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","hën a kumutu disa de dë, nöö hën a go a di köndë de kai Betania. Naandë a duumi di ndeti dë. ");
INSERT INTO srmNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nöö di dobooko fëën, hën u ku Masa Jesosi kumutu a Betania fuu toona go a Jelusalen möön. Nöö di u dë a pasi nango, hën hangi ko kisi Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nöö hën a si wan fuuta pau leti a bandja pasi dë de kai figa, hën a go suku njanjan nëën faa musu njan. Ma nöö an feni. Uwii nöö di pau abi nëën hedi. Nöö hën a fan ku di pau taa: “Fa i si ma feni njanjan a i aki, nöö ja musu pai a di goonliba aki möön e.” Nöö di a fan sö, hën wantewante dë hën di pau uwii lenguwa waaa fiaa. ");
INSERT INTO srmNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nöö di u dee bakama ko si di pau taa a dëë, nöö soni fëën toobi u tumusi. Hën u hakisi Masa Jesosi taa: “Masa o, unfa a waka i fan ku di pau dë hën a dëë hesi sö?” ");
INSERT INTO srmNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nöö hën a piki u taa: “Dee sëmbë, un haika e. Ee i ta biibi Masa Gadu ku hii i hati, nöö unu seei sa du sö tu e. Nöö na di dë nöö, ma möön gaan soni seei un sa du. Biga ee hën i taki da di kuun aki taa: ‘Hopo kumutu fii aki go a di ze,’ nöö a o du leti kumafa i taki dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Biga ee i abi biibi a Masa Gadu tjika, nöö hiniwan soni di i begi ën nöö i sa feni ën nëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nöö hën u toona go a di Wosu u Masa Gadu möön, nöö hën Masa Jesosi seti ta lei sëmbë. Te wan pisi hën dee Gaan Womi ku dee Gaan Begima ko nëën möön. Hën de hakisi ën taa: “Ambë da i taki fii du dee soni i ta du aki?” ");
INSERT INTO srmNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hën a piki de taa: “Wë fa un hakisi di soni dë, nöö miseei o hakisi unu wan soni tu. Nöö te un piki mi, nöö miseei o piki unu unsë mi feni di taki.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hën a hakisi de taa: “Di dopu Johanisi bi ta dopu sëmbë, ambë bi butëën a ta du di lö wooko dë, Masa Gadu naa libisëmbë?” Wë nöö fa a hakisi de naandë, hën de go a së go pakisei di soni go, de pakisei di soni ko, te de wei, hën de taa: “Wë unfa woo taki di soni aki? Biga ee u piki taa Masa Gaangadu hën mandëën, nöö a o hakisi u ee faandi mbei wa bi piki ën buka? Wë nöö woo peka. ");
INSERT INTO srmNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma nöö ee u taki taa libisëmbë hën mandëën nöö u musu fëëë, biga hii dee sëmbë u di köndë aki tuu tei Johanisi fu wan gaan tjabukama di Gadu seei manda ko. Möön bëtë fëën nöö un boo piki ën taa wa sabi.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nöö hën de go a Masa Jesosi hën de piki ën taa: “Wë di soni i hakisi u dë, nöö wa feni u piki i e.” Hën a taki da de taa: “Wë di wan feni, nöö miseei tu, më sa konda da unu ambë da mi di taki u mi ta du dee soni mi ta du aki e.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Hën a toona fan ku de möön taa: “Un haika, mi o taki wan woto da unu aki, nöö un pakisei ën bunu e. “Wan tata bi abi tu womi mii fëën. Nöö hën a go a di möön gaan wan hën a taki dëën taa: ‘Womi o, baa, wë mi kë fii go a u goon tide go wooko e.’ ");
INSERT INTO srmNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Nöö hën a taa: ‘Ambë? Mi ö?’ A taki aai. A taa: ‘Nönö, ma o go e.’ “Ma nöö hën a sai dë te wan pisi, di soni ko hati ën fu di a bi piki hën tata gaan buka sö, nöö hën a hopo go a di goon dendu go wooko. ");
INSERT INTO srmNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ma nöö söseei di tata bi go a di oto womi mii fëën tu, hën a taki dëën taa: ‘Womi, mi kë fii go a u goon dendu go wooko tide e baa.’ “Nöö hën a piki ën taa: ‘Söö. Wë antoobi Taata, mi o go e.’ Wë ma nöö hën an go möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nöö hën Masa Jesosi taa: “Wë nöö mi hakisi unu, de tu mii u di tata, di a fan ku de undi u de piki ën buka?” Nöö hën de piki taa: “Wë di gaan wan, hën du kumafa di tata bi kë.” Nöö hën Masa Jesosi taki da de taa: “Awa, sö a dë tuu. Nöö un haika e. Dee fufuuma u di köndë aki, ku dee jajo mujëë dee un ta mbei fa, nöö dee lö sëmbë dë sa ko a di Njunjun Tii u Gadu dendu möön hesi möön unu e. Biga de sabi kaa taa de an ta libi bunu. Ma nöö unu, un ta mbei kuma un ta piki Gadu buka, un dë bumbuu sëmbë kaa, nöö hën mbei a taanga da unu fuun saka unu seei a di tii u Gadu basu. ");
INSERT INTO srmNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Biga di Johanisi ko, nöö a bi ta lei unu unfa fuun libi ufö un sa ko bunu ku Gadu, ma nöö wan bi kë piki. Nöö hën dee sëmbë dee bi a’ poi në a di köndë, nöö de bia piki Johanisi hesihesi. Ma nöö unu, hii fa un si taa sö de ta piki, ma tökuseei wan bia piki ën buka möönsö. Un mbei taangajesi go dou te kisi fa u dë aki eti.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nöö hën a tei wan woto konda da de möön, a taa: “Wan guduma bi dë e. Nöö hën a koti wan gaan goon hën a paandi di fuuta de kai doloifi nëën te a kaba faa musu ta mbei win. Hën a mbei wan peni te a kaba lomboto di goon. Nöö hën a diki wan baaku te a kaba mbei baki nëën, fu te di doloifi lepi nöö a di baki dë dendu de o ta makisëën ta mbei di win. Nöö hën a mbei wan hei wosu buta a di peni dendu u dee wakitima musu ta watji fufuuma. “Nöö di a mbei hii dee soni tefa a kaba, hën a kai wanlö sëmbë ko nëën. Nöö hën a mbei buka ku de tefa a kaba taa de o ta wooko a di goon, nöö te juu kisi di fuuta lepi, nöö de o ta mbei win nöö hën ku de o ta paati ën. “Nöö di di goon masa mbei di buka ku dee sëmbë te a kaba, hën a mbei wan lëisi go tee a wan oto köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Nöö hën a go dë ala teee juu dou di fuuta lepi. Nöö hën wë a kai wanlö futuboi fëën manda go a di goon, fu de go tei di win fëën a dee sëmbë tja ko dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Nöö hën wë de nango tefa de go dou. Ma nöö di dee sëmbë dee ta wooko a di goon si taa de ta ko, hën de buta ku de. Wan u de de fon tee a fika a dëdë ku libi maun. Di otowan hën de fon kii. Di otowan hën de naki ën ku sitonu kii. ");
INSERT INTO srmNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Nöö hën a baka u di dë, hën di goon masa toona manda oto sëmbë u de go möön go suku di win tja ko dëën. Nöö hën de nango tefa de go dou. Hën dee sëmbë dee dë a di goon du ku de leti kumafa i si de bi du ku dee fosuwan. ");
INSERT INTO srmNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Nöö a baka u di dë, nöö hën di goon masa taa: ‘Söö. Wë mi o manda di womi mii u mi seei go awaa. A kandë te dee sëmbë si ën, nöö de o abi lesipeki fëën, di a dë mi mii.’ “Nöö hën a manda di womi mii fëën go gbolo. ");
INSERT INTO srmNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ma di dee sëmbë dee dë a di goon si taa hën ta ko dë, nöö hën de taa: ‘Söö. Wë di sëmbë a’ di goon, luku di womi mii fëën ta ko dë e.’ “Nöö hën de kuutu ku deseei taa: ‘Te di masa dëdë nöö di mii i si naandë, hën o ko tei di goon aki puu a u maun. Nöö un sabi nö? Un boo kii ën puu aki wante, nöö di goon o fika da u wanwan.’ ");
INSERT INTO srmNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Nöö hën wë di womi mii ko dou. Nöö hën dee sëmbë kisi ën tja go a döösë u di djai, hën de kii ën gbegede puu dë.” Sö wan woto Masa Jesosi konda da de te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hën a taa: “Wë nöö fa dee soni pasa dë, nöö te di goon masa ko, andi un mëni taa a o du ku dee sëmbë naandë?” ");
INSERT INTO srmNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hën de taa: “Höön, wë di soni naandë dë u taki ö? A o sitaafu de ku wan gaan hogi sitaafu di fiti de nöö a o kii de. Nöö a o da oto sëmbë di goon di a sabi taa a sa feni wini fu di goon fëën a de.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nöö hën Masa Jesosi hakisi de, a taa: “Wan sabi fa de taki a di Buku u Gadu nö? De taa: Dee sëmbë ta mbei sitonu wosu, de si wan sitonu taa an bunu, nöö hën de tuwëën a kapëë. Ma nöö bakaten, hën di sitonu dë ko di mama posu u di wosu. Masa Gadu seei wë du di soni sö, nöö a dë wan gaan foondo soni da u. Sö wë di Buku taki. ");
INSERT INTO srmNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Nöö mi taki da unu taa Masa Gadu an o biinga ku unu möön e, faa buta unu a di Tii fëën basu möön. Nönö. A o disa unu, nöö a o tei wanlö oto sëmbë buta a di Tii fëën di a o sa feni wini a de. ");
INSERT INTO srmNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“˻Biga di soni Gadu buta taa a bunu, nöö hën un feni taa an bunu kwetikweti, leti kuma di sitonu de bi tuwë dë.˼ Nöö un sabi fa di sitonu naandë dë nö? Ee un kai nëën liba nöö woon booko pisipisi, ma ee di sitonu hën kai a unu liba nöö lala a o lala unu finufinu kaba a sösö fiaa.” ");
INSERT INTO srmNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wë nöö fa Masa Jesosi fan dë, nöö dee Gaan Begima ku dee Faliseima jei, nöö de sabi taa de wë a tjökö ku di fan a fan dë, nöö hati u de boonu teee. ");
INSERT INTO srmNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nöö de kë kisi ën tja go buta a dunguwosu, ma fu di de fëëë lanti hën mbei de an du sö. Biga hii sëmbë ta tei Masa Jesosi u wan gaan tjabukama u Gadu seei. ");
INSERT INTO srmNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Nöö hën Masa Jesosi toona tei wan woto möön konda faa lei u fa di Njunjun Tii u Gadu dë. A taa: “Wan könu abi wan womi mii fëën o tööu, nöö hën a kai sëmbë a fesi fu te di daka dou nöö de ko a di tööuwosu. Nöö hën a seeka soni te a kaba këë. ");
INSERT INTO srmNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nöö hën a manda dee futuboi fëën fu de go piki dee sëmbë dee a bi kai dë taa wë aan soni, di daka hën a dou. Be de ko a di tööuwosu ko njan di gaan piizii. “Nöö hën dee futuboi go, hën de da di buka te de kaba. Ma nöö dee sëmbë a bi kai dë, de an kë ko. De an dë a di soni dë seei. ");
INSERT INTO srmNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Nöö hën di könu manda wanlö oto futuboi fëën möön taa be de toona go taki da de taa a seeka hii soni tuu kaa. Dee gaan kau, ku dee kau mii dee a bi kiija buta naandë fu de fatu tjika u de njan di daka, nöö a kii de tuu kaa seeka boi. Nöö be de ko a di piizii. Sö a manda taki da de. ");
INSERT INTO srmNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ma nöö fa dee futuboi go da di buka te de kaba naandë, hën dee sëmbë tjëkë ahwa maun da de taa de an dë a di soni dë. Hën wan u de hopo go fëën nëën goon dendu, di otowan go fëën a möni wooko. ");
INSERT INTO srmNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nöö dee sëmbë dee fika, hën de hopo, hën de kisi dee futuboi u di könu hën de du hogihogi ku de te a tjika de, hën de kii de puu dë gbelin. ");
INSERT INTO srmNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Nöö hën di könu jei taa sö wan soni, nöö hën hati fëën ko boonu seei tee na soni. Hën a kai wanlö sodati fëën, hën a manda de go kii dee sëmbë dee bi kii dee futuboi fëën, hën de booko di köndë, de suti faja nëën tjuma gbegedee. ");
INSERT INTO srmNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Nöö hën wë di könu toona kai wanlö oto futuboi u de ko nëën, hën a taa: ‘Wë un luku. Dee soni u seeka buta dë fuu njan di piizii, nöö u kaba u seeka de gaanduwe kaa e, ma dee sëmbë dee mi kai u de ko nöö de hogi poi. An fiti u de ko njan di piizii aki möön. ");
INSERT INTO srmNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“ ‘Wë nöö un sabi nö? Un go a di köndë nöö un paaja waka a hii dee sitaati tuu, gaan wan ku piki wan. Nöö hiniwan sëmbë di un si, nöö un kai ën taa be a ko a di tööuwosu aki ko njan.’ ");
INSERT INTO srmNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Nöö hën de paaja hii di köndë. Nöö hën de kai hii sëmbë dee de si kaa, bunuwan ku hogiwan tuu, hën de tja de ko a di piizii te di wosu fuu pöö ku sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ma nöö di tööu bi abi wan wëti taa di könu seei o buta di koosu fii bisi ko a di tööuwosu. Nöö hën de dë a di piizii dendu te wan pisi nöö hën könu ko u ko da de wodi. Nöö fa a ta da de wodi ta lontu dë, te wan pisi hën wojo fëën ko kai a wan sëmbë ko naandë. A dë fëën ku fëën seei koosu nëën sinkii gbolo. An bisi di koosu könu bi dëën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“Hën könu luku ën diin, a kai ën: ‘Womi.’ “A piki. “A taa: ‘Unfa a waka i ko aki söndö i bisi di koosu di mi da i fii musu bisi?’ “Hën di womi dë pii. An sa piki na wan soni. ");
INSERT INTO srmNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Nöö hën di könu manda dee futuboi fëën taa: ‘Un kisi di sëmbë dë tai ën maun ku ën futu te un kaba, nöö un vindëën go a döö a dungudungu ala, ka sëmbë dë a sitaafu ta bai ta këë ta djëmë nöömö.’ ” ");
INSERT INTO srmNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sö wan oto Masa Jesosi taki da de naandë e. Hën a taa: “Nöö sö wë a dë e, dee sëmbë. Masa Gadu kai hia sëmbë u de ko, ma nöö biti sëmbë nöö ta ko nëën a di fasi di a buta faa tei de.” ");
INSERT INTO srmNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nöö fa Masa Jesosi fan te a kaba dë, hën dee Faliseima go a së go kuutu ku de na de unfa u de du de feni ën kisi tai ku dee fan a ta fan. ");
INSERT INTO srmNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nöö hën de feni wan soni fu de hakisi. Nöö hën de kai dee bakama u de, ku wanlö sëmbë u Könu Helodi paatëi, hën de manda de go a Masa Jesosi go hakisi ën di soni de pakisei dë. Nöö hën de naki te de go dou. Hën de kai ën: “Mësitë o.” Hën a piki. De taa: “Wë u ko a i aki.” A taki aai. “Wë u sabi taa fa i dë aki, nöö i dë gaan bumbuu sëmbë. Biga i ta konda dee soni u Gadu gbelingbelin da u leti kumafa de dë. Ja a’ toobi ku di fa sëmbë ta pakisei fii, hën mbei ja ta kwei di fan da u. Wë nöö hën i si u ko a i aki ko hakisi i wan soni, nöö di fa a dë nöö i piki u. ");
INSERT INTO srmNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","“Fa di Gaan Könu a Loomë ta duwengi u fuu ta paka lanti möni aki, wë nöö unfa i si ën? A fiti fuu pakëën naa an fiti?” Sö de hakisi ën. ");
INSERT INTO srmNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma nöö Masa Jesosi sabi kaa taa politiki wë de ta naki ën sö, hën a piki de taa: “Un dee bödjëëma aki, andi mbei un ta suku mi fuun tai ku fan sö? ");
INSERT INTO srmNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wë un da mi wan kwëngëlë möni i si.” Nöö hën de tei wan kwëngëlë möni tja ko dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nöö hën a hakisi de taa: “Wë ambë abi di në ku di fesi dë a di möni liba aki?” ");
INSERT INTO srmNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hën de piki taa: “Di Gaan Könu.” Hën a taa: “Nasö nö?” De taki aai. Hën a taki da de taa: “Wë nöö di soni di dë u könu nöö un da könu ën e, nöö di soni di dë u Masa Gaangadu nöö un da Masa Gaangadu ën.” ");
INSERT INTO srmNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nöö fa a piki de dë, nöö a bigi da de seei. De an bi mëni taa sö a bi o piki de a sö wan köni fasi te de an sa feni soni u taki möön. Nöö hën de kumutu disëën dë, hën de go u de. ");
INSERT INTO srmNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nöö hën di daka dë seei, hën wanlö sëmbë u di keiki paatëi de kai Sadusei ko a Masa Jesosi. Wë dee lö pei sëmbë naandë, de an kë biibi taa te sëmbë dëdë nöö di akaa fëën ta fika ku libi faa toona ko a di sëmbë sinkii a bakaten, be a weki baka. Nöö fa de ko nëën dë, hën de hakisi ën taa: ");
INSERT INTO srmNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mësitë o, de taa te sëmbë dëdë nöö a o toona weki baka. Wë nöö u ko hakisi i wan soni fëën fii piki u. “Wë Mosesi bi da u wan wëti. A taa ee wan womi ku ën mujëë libi te nöö hën di womi dëdë söndö a pali ku ën, nöö di baaa fëën musu hoi ën suwagi, be a pali miii ku ën fu di baaa fëën böngö an musu kaba. Na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Söö. Wë nöö de bi dë sëbën baaa womi a u mindi aki. Nöö hën di gaan wan u de tei wan mujëë. Hën de dë te wan pisi hën dëdë kii di womi gbolo, hën ku di mujëë an pai möönsö. Nöö hën di oto baaa hoi di mujëë. ");
INSERT INTO srmNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Te di womi dë seei dëdë, an pali ku ën möönsö. Hën di u mbei dii hoi di mujëë. Tefa a dëdë an pai ku ën möönsö. Nöö sö hii dee sëbën baaa womi tuu libi ku di mujëë, ma na wan u de pali miii ku ën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nöö a baka u di dë, hën di mujëë seei ko dëdë tu. ");
INSERT INTO srmNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Wë nöö di soni u kë hakisi i, hën da ee sëmbë dëdë de ta weki baka, nöö unfa di soni o pasa te de tuu weki baka? Undi u dee sëbën baaa o abi di mujëë? Biga de tuu bi libi ku ën.” ");
INSERT INTO srmNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nöö hën Masa Jesosi piki de taa: “Wë un ta tei di taki a wan föutu fasi poi e, fu di wan saandi Gadu Buku taki, nöö wan sabi un kaakiti Gadu abi tu. ");
INSERT INTO srmNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Biga tee sëmbë dëdë weki nöö manu ku mujëë soni an o dë möön e, ma hii sëmbë tuu o dë kuma dee basia u Masa Gaangadu köndë. ");
INSERT INTO srmNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Ma nöö fuu taki a di fa sëmbë ta dëdë weki baka dë, nöö wan ta lesi a di Buku u Gadu fa Gadu bi fan ku Mosesi a di faja dendu ö? ");
INSERT INTO srmNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","A taa: ‘Mi da di Gadu di dee gaan sëmbë fii ta begi, de Abahamu ku Isaki ku Jakopu.’ “Wë wan jei ö? An taa, ‘Mi da di Gadu di de bi ta begi,’ ma a taa ‘Mi da di Gadu de ta begi.’ Wë nöö Masa Gaangadu an dë di Gadu u dëdëdëdë sëmbë e, ma a dë di Gadu u libilibi sëmbë. Wë nöö hën da Abahamu ku Isaki ku Jakopu, di akaa u de dë ku libi a wan kamian eti, nasö nö? Nöö faandi mbei wan kë piki taa tee sëmbë dëdë nöö de dë ku libi eti?” ");
INSERT INTO srmNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wë nöö di dee hia sëmbë sai dë jei fa Masa Jesosi piki dee Saduseima, nöö a bigi da de te na soni. ");
INSERT INTO srmNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nöö di dee Faliseima ko jei taa sö Masa Jesosi wini dee Saduseima a fan, nöö hën de toona hai ko makandi möön ko ta suku soni möön u de go kisi ën. ");
INSERT INTO srmNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Te de kaba nöö hën de go nëën. Nöö de bi abi wan fiafia lei wan a de dendu di sabi Dju wëti finifini, nöö hën o fan di fan. ");
INSERT INTO srmNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Nöö hën a kai ën taa: “Mësitë.” A piki. A taa: “Wë nöö fa Mosesi sikifi dee wëti u Gadu buta a di Buku, nöö undi u de da di möön hebi wan u de tuu?” ");
INSERT INTO srmNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hën a piki de taa: “Di möön hebi wan ö? Hën da i musu lobi Gadu i Masa te dou ku hii i hati ku hii i akaa ku hii di pakisei fii di i abi. ");
INSERT INTO srmNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hën da di möön hebi wan u hii dee wëti tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma nöö wan otowan dë leti nëën baka, hën da i musu lobi di otowan fii leti kumafa i lobi i seei. ");
INSERT INTO srmNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","De tu wëti dë, de dë a fesi u hii dee otowan tuu. Biga hii dee wëti Mosesi ku dee tjabukama bi kisi a Gadu tuu, de tuu ta hëngi a de tu wëti naandë e.” Sö Masa Jesosi piki de. ");
INSERT INTO srmNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wë nöö di dee Faliseima dë a Masa Jesosi dë kaa, nöö hën a bia hakisi de wan soni awaa. ");
INSERT INTO srmNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","A taa: “Wë miseei o hakisi unu wan soni. Unfa un ta mëni u di Könu de kai Keesitu, di Gadu bi paamusi taa a o manda ko? Ambë bakamii a musu dë?” Hën de taa: “Wë a musu dë wan bakamii u Könu Dafiti.” ");
INSERT INTO srmNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hën a taa: “Na sö nö? Wë nöö unfa a waka Dafiti seei kai ën ‘Masa’, ee bakamii fëën nöö a o dë? Biga i sabi fa di Buku taki. Di Akaa u Gadu ko a Dafiti liba nöö hën a taki wan soni u di Paamusi Könu taa: ");
INSERT INTO srmNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Masa Gadu taki da mi Masa taa: ‘Ko sindo a mi letimaun së aki ta luku te mi buta dee felantima fii a i basufutu.’ Na sö Dafiti bi taki ö? ");
INSERT INTO srmNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Wë nöö andi Dafiti kë taki ku di soni dë? Biga ee di Paamusi Könu o dë hën bakamii nöö, unfa a o sa dë hën Masa möön?” Hën di soni dë Masa Jesosi hakisi dee Faliseima. ");
INSERT INTO srmNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma nöö fa a hakisi de di soni dë, na wan u de saanfa u piki ën möönsö. Nöö hën mbei fu kumutu a di ten naandë, nöö na wan sëmbë abi hati u go hakisi Masa Jesosi soni u de sa kisi ën möön. ");
INSERT INTO srmNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nöö a baka u di dë, hën Masa Jesosi fan ku u dee bakama fëën ku dee hia sëmbë dee sai dë tuu. A taa: ");
INSERT INTO srmNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Un haika e, dee sëmbë. Wan si fa dee Sabima u Wëti ku dee Faliseima ta libi ö? De buta deseei a di kamian di Mosesi bi abi ta lei sëmbë dee wëti u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nöö fa un jei de ta fan dë, nöö un musu piki de tuu. Ma nöö wan musu suku u djeesi de a di fa de ta libi e. Nönö, biga de an ta libi kumafa dee wëti ta taki. ");
INSERT INTO srmNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nöö de ta lai wëti tee a hia da unu fuun musu ta tjai, ma de seei an ta tja wan pikiwan fëën seei. ");
INSERT INTO srmNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Nöö fa dee lö sëmbë dë sai dë, nöö hiniwan soni di de o du kaa nöö de ta du ën fu sëmbë wojo musu si de taa de dë bumbuu sëmbë. Biga Gadu bi taki taa i musu sikifi dee wëti fëën buta a i mindifesi ku i maun fu ja musu fëëkëtë de. Ma nöö dee lö sëmbë dë, de ta mbei gaan gindi dosu te de kaba ta sikifi Gadu wëti te a hia lai nëën ta tai buta a de mindi fesi ku de maun te de kaba fu sëmbë musu si de taa aai, sö de ta biibi Gadu tjika. “Söseei Masa Gaangadu bi taki taa te de o nai di koosu u de, nöö de musu nai ën ku jëkëjëkë a buka. Ma nöö de ta nai gaan langalanga jëkëjëkë te pasa maaka fu hii sëmbë musu si taa sö de ta biibi Gadu hebi tjika. Ma an dë sö a de hati. Un si ö? ");
INSERT INTO srmNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Nöö fa i si de sai dë, ee de o go a wan piizii ee nasö de go a keiki, nöö de lobi u sindo a dee möön hei kamian fu hii sëmbë wojo musu ta kai a de. ");
INSERT INTO srmNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nöö te de o go a wojowojo ee nasö a wan oto kamian a lanti dendu, nöö de lobi u sëmbë musu ta da de wodi a lanti dendu dë ta kai de ‘Munëli, Munëli.’ A ta suti da de seei. ");
INSERT INTO srmNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Wë ma nöö mi taki da unu taa na sö un musu libi e, dee sëmbë. Biga un tuu dë baaa ku baaa makandi. ");
INSERT INTO srmNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","10","Nöö wan musu buta unu seei hei möön sëmbë fu de ta ko ta kai unu ‘Munëli’ ee nasö ‘Taata,’ ee nasö ‘Masa.’ Di fa dë an bunu e! Biga wan kodo Masa nöö un abi, ku wan kodo Tata, hën da Masa Gaangadu di dë a liba. Nöö wan kodo Mësitë nöö un abi hën da di könu di Gadu bi paamusi taa a o manda ko. Nöö wan musu tei libisëmbë buta a dee lö kamian dë e, nöö wan musu hopo unu seei buta a dee lö kamian dë tu. Nönö. ");
INSERT INTO srmNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Ma nöö ee wan fuunu kë dë fesima, nöö i musu saka i seei ko dë kuma futuboi u dee otowan fii. ");
INSERT INTO srmNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Biga ee wan sëmbë i ta suku u hopo i seei, nöö Gadu o booko i saka. Ma ee i saka i seei, nöö Gadu o buta i möön hei.” ");
INSERT INTO srmNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nöö hën Masa Jesosi gandji da dee hedima u Dju awaa, a taa: “Mi bai helu da unu e, un dee Sabima u Wëti ku un dee Faliseima aki, un bödjëëma unu! Fa un sai naandë, wan ta ko a di Njunjun Tii u Gadu dendu möönsö, nöö dee sëmbë dee dë fa u ko nëën nöö un ta tapa di pasi da de tu. Un ta tapa di döö seei a de fesi u de an musu denda ko a dendu.  ");
INSERT INTO srmNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Nöö mi toona bai helu da unu möön e, un dee Sabima u Wëti ku un dee Faliseima naandë, un bödjëëma unu! Biga te un si wan mujëë manu fëën dëdë a fika a ganda, nöö un ta tei dee gudu fëën ku hii dee soni dee dë nëën wosu tuu ko fuunu. Nöö naandë seei un ta dë ta begi gaan langa begi, ta mbei taa un dë bumbuu sëmbë poi. Fa un ta du dë, nöö mi taki da unu taa woon kisi wan gaan sitaafu fëën a Gadu e. ");
INSERT INTO srmNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nöö mi bai helu da unu möön e, un dee Sabima u Wëti ku dee Faliseima aki, un bödjëëma unu! Biga fa i si un sai dë, nöö un ta waka hii di mundu fuun feni ee wan kodo sëmbë seei hai tja ko a unu së. Nöö te un wini ën kaa, nöö un ta butëën ko tu toon didibi möön leki fa un sai dë. ");
INSERT INTO srmNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nöö mi bai helu da unu möön e, un dee bookowojoma dë. Biga fa un sai dë, un ta suku u ta lei otowan pasi ma unu seei wan ta si di pasi möönsö. “Biga un taa ee wan sëmbë i tei di Wosu u Masa Gadu soi, nöö di soi dë aan kaakiti. Ee i poi ën seei nöö an o kisi i. Ma ee i tei di goutu di dë a di Wosu soi, nöö hën a’ kaakiti tjika fu di soi kisi i. Sö di lei fuunu di un abi, sö a dë. ");
INSERT INTO srmNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wë un dee bookowojoma dë, unfa un du don sö? Biga di goutu ku di Wosu u Masa Gadu, undi u de möön hebi? Na di Wosu nö? Nöö fu di di goutu dë a di Wosu dë, hën mbei a ko dë wan hebi soni, na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Söseei tu, un ta lei sëmbë taa ee de tei di begitafa soi, nöö di soi aan kaakiti tjika. Ma ee i tei di soni de tja ko buta a di tafa dë soi, nöö hën abi kaakiti, di soi o kisi i ee i booko ën. Na sö un ta taki ö? ");
INSERT INTO srmNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wë nöö un wisiwasi di dë? Biga di soni de tja ko buta a di tafa, nöö nëën hebi e. Ma di begitafa hën hebi, nöö te i tja di soni ko buta a di tafa liba ufö a o ko wan hebi soni. ");
INSERT INTO srmNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nöö mi taki da unu taa, ee i tei di begitafa dë soi, nöö hën da i soi ku ën ku hii dee soni dee dë nëën liba tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Nöö söseei tu, ee i tei di Wosu u Masa Gaangadu soi nöö hën da i ta soi ku ën ku hii dee soni dee nama ku ën tuu, te dou ku Masa Gaangadu seei tu di ta dë a di Wosu. ");
INSERT INTO srmNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nöö te i tei liba ala soi, nöö hën da i tei di könubangi u Masa Gaangadu a liba ala ku Masa Gadu seei di dë sindosindo nëën. Sö di soi fuunu hebi tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nöö mi bai helu da unu möön e, un dee Sabima u Wëti, ku un dee Faliseima, un bödjëëma unu! Biga hii dee soni un ta paandi fuun njan te dou ku dee pikipiki sii tuu, nöö de tuu un ta paati a teni pisi finifini nöö i ta da Gadu fëën pisi. Sö un ta mbei taa un ta hoi Gadu wëti fini tjika. Ma nöö dee gaan wëti u Gadu kuma fii wegi soni luku a wan leti fasi, ee nasö fii abi tjalihati da otowan, ee nasö fii libi a wan leti fasi fu sëmbë sa futoou i, dee di dë wan ta kai de gaan soni möönsö. Nöö an bunu e! Biga ee i lobi u hoi wëti sö, nöö dee wëti dë tuu i bi musu hoi makandi söndö i disa hafu u de. ");
INSERT INTO srmNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Nöö mi bai helu da unu möön, un dee bookowojoma ta lei otowan pasi naandë. Biga un dë leti kuma wan sëmbë ee wan piki sundju kai a di wata fëën di a ta bebe, nöö a o hopo wante go maani ën puu te a kaba bifö a o bebëën. Ma ee wan gaan gindi mbeti dë a di wata nöö an o si ën möönsö. A o bebe di wata wiö. Nöö sö wan sabi u wegi soni tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nöö mi bai helu da unu möön, un dee Sabima u Wëti ku un dee Faliseima, un bödjëëma unu! Biga un ta wasi paabi fuunu ee nasö kan fuunu finifini a wëti fasi, ufö de sa limbo da unu tjika. Ma hii fu di dë, hati dendu fuunu an dë limbolimbo. A lai ku sösö giii ku langahati ku takufasi. ");
INSERT INTO srmNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Un dee bookowojo Faliseima aki, un haika e! Un mbei hati fuunu ko dë limbolimbo, nöö hii dee döösë soni fuunu o dë limbolimbo tu. ");
INSERT INTO srmNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nöö mi bai helu da unu möön e, un dee Sabima u Wëti ku un dee Faliseima aki, un bödjëëma unu! Fa un sai dë, un dë leti kuma dee geebi de ta seeka feifi a döösë tee de ko dë wetiweti faan limbolimbo. Ma dendu u de lai ku dëdë sëmbë pondipondi fika bonu. ");
INSERT INTO srmNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sö un dë e, fa i si un sai dë. Biga un ta mbei unu seei kuma gaan bumbuu sëmbë, ma hati dendu fuunu lai ku sösö ganjan ku bödjëë fasi ku hii pei hogi. ");
INSERT INTO srmNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nöö mi bai helu da unu möön e, un dee Sabima u Wëti ku un dee Faliseima, un bödjëëma unu! Fa un sai naandë, un ta seeka dee geebi u dee fesiten tjabukama u Gadu, ku dee u dee oto sëmbë dee bi libi bunu a Masa Gaangadu wojo. Un ta bisi de te de hanso möön hii soni. ");
INSERT INTO srmNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Sö un ta du e, nöö hën wë un sai dë ta taki taa ee unu bi dë a di ten u de ala, nöö wan bi o kii de kumafa dee gaan sëmbë fuunu bi kii de. ");
INSERT INTO srmNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Ma nöö hii fa un taki dë seei, ma ee sëmbë wegi di fa un ta libi te de kaba, nöö de musu si taa un dë lalalala bakamii u dee gaan sëmbë fuunu dee bi kii dee tjabukama dë. Un djei de tumisi ku di hogilibi fuunu. ");
INSERT INTO srmNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nöö mi taki e, taa be un libi di hogilibi fuunu go dou nöö e, te nöö a o kisi di maaka di dee gaan sëmbë fuunu bi buta da unu. ");
INSERT INTO srmNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Nöö fa un hai ko zunta gidjii kuma sindeki lolulolu na akata dë, nöö un sabi taa un sa lusu kule go te de an o kisi unu tuwë a di didibi faja nö? ");
INSERT INTO srmNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Wë nönö e! Un haika, mi o toona manda wanlö oto tjabukama ko a unu möön, ku fusutan sëmbë. Bumbuu leima seei mi o manda da unu leti kumafa Masa Gadu bi manda ko da dee gaan sëmbë fuunu a fesiten. Nöö hafu u de woon peka a lakpa pau kii, hafu u de woon kii a oto fasi, hafu u de woon fon a dee keikiwosu fuunu, hafu u de woon ta buta ku de ta jaka ta puu a köndëköndë kuma dagu. Sö woon du ku de tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Nöö hën mbei mi taki da unu taa hii dee bumbuu sëmbë u Gadu dee de bi kii a goonliba aki tuu kaa, de tuu o fika a unu liba e, kumutu na Abeli te dou a Sakaliasi di mii u Belekia di de bi kii a di Wosu u Masa Gadu ganda mindi. ");
INSERT INTO srmNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hii di hebi u de tuu o kai a un dee hogi sëmbë ta libi a di ten aki liba e.” Sö Masa Jesosi fan ku dee hedima u Dju naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nöö di a fan sö te a kaba, nöö hën wan gaan tjali kisi ën u di köndë. Hën a taa: “Ee aai, Jelusalen, Jelusalen, a i ganda mindi aki de vinde sitonu naki dee sëmbë kii, dee Gadu bi manda. Hii dee tjabukama tuu de kii a i aki. A tjali e. Sömëni pasi mi bi hangi fu mi kai dee sëmbë fii ko a mi, kumafa wan ganian mama ta kai hën miii fu de ko nëën hanza basu faa tjubi de. Ma nöö de an bi kë ko möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Da a ko dë taa wë heepi an dë. Nöö mi o disa unu be un libi kumafa un kë e, be di kamian fuunu aki booko kaba a sösö. “Biga mi disa unu fuun bai sabi sö. ");
INSERT INTO srmNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nöö mi taki e, te di daka dou u mi toona ko möön, nöö woon dë kabakaba fuun tei mi awaa. Nöö woon toona bai kumafa un bi bai dë kaa taa: ‘Gaantangi u Gadu u di sëmbë a manda da u aki. Gadu musu dë ku ën.’ ” Sö Masa Jesosi fan te a kaba di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nöö hën di a ta kumutu a di Wosu u Masa Gadu a Jelusalen dë faa go, nöö hën u dee bakama fëën ko nëën ko hakisi ën taa: “Masa o, ja si fa dee wosu fu di keikipisi aki waiti nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nöö hën a taa: “Awa, ma fa i si de hanso seei, ma wan daka ta ko di na wan u dee gaan sitonu i si aki o fika oto a oto liba möön e. De tuu de o booko tuwë a goon paaja fanjanfanjan.” ");
INSERT INTO srmNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nöö hën a kumutu dë, hën a go a di kuun de kai Oleifi Kuun go sindo. Nöö hën u ko nëën naandë u wanwan hën u hakisi ën taa: “Masa, wë di soni i taki dë, na un juu ten a o ko pasa? Nöö un maaka joo lei u tu, fuu sa sabi di juu di joo toona ko baka ku di juu di ten u dë aki o kaba?” ");
INSERT INTO srmNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nöö hën Masa Jesosi piki u taa: “Söö. Wë a bunu fuun sabi ën tuu e, fu sëmbë an sa ganjan unu. ");
INSERT INTO srmNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Biga di juu dë, nöö sömëni sëmbë o hopo ta tei mi në taa de da di Paamusi Könu, nöö a di fasi dë de o ta kisi sömëni sëmbë ta ganjan. ");
INSERT INTO srmNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Nöö un haika e. Te di juu ta kisi, nöö woon ta jei taa: ‘Feti dë aki,’ te wan pisi, ‘Feti dë ala.’ Nöö wan musu panta e, biga dee lö soni dë musu ko pasa ufö. Ma nëën da di kaba eti e. ");
INSERT INTO srmNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Di juu dë, nöö wan köndë o hopo go feti ku di oto köndë, wan könu o hopo go feti ku wan oto könu, gaan hangi o ko, goonliba o ta seki, kamian o ta bai ta latja. ");
INSERT INTO srmNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nöö di dë hën da di seti nöö fu di gaan fuka ten di dë u ko. A o dë leti kuma te bëë seti njan wan mujëë faa pai. Sö dee fuka dë o ta lei taa di juu zuntu fu di ten u dë aki musu kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nöö di juu dë, de o seti du ku un dee sëmbë u mi tu. De o buta unu a sëmbë maun u de sitaafu kii. Hii sëmbë o ta buuse unu fu di un nama ku mi hedi. ");
INSERT INTO srmNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hën wë mbei hia sëmbë o bia baka, de an o a’ biibi a mi liba möön. Nöö di juu ten dë, di libi o hogi tee. Sëmbë o ta tja de na de go sei, de o ta buuse deseei te na soni. ");
INSERT INTO srmNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nöö sömëni sëmbë o hopo ta konda taa de da tjabukama u Gadu, nöö de o ta ganjan hia sëmbë ta kisi ta hai tja ko a de së. ");
INSERT INTO srmNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“Nöö fa dee sëmbë u di ten dë o libi hogi ku deseei tjika dë, nöö gaan së u de an o lobi de na de möön e. ");
INSERT INTO srmNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma nöö dee sëmbë dee o tai hati ta biibi a Gadu tee dou di kaba pisi, nöö de o feni di libi u teego. ");
INSERT INTO srmNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma nöö di bunu buka u di Njunjun Tii u Gadu musu paaja te dou hii goonliba e, be hii föluku musu jei. Nöö baka u di dë ufö di ten u dë aki o kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nöö te wan pisi, nöö woon si di gaan hogi di di tjabukama u Gadu de kai Daniëli bi taki e. Di hogi dë, Masa Gaangadu an sa si ën a wojo seei, kwetikweti, biga hën ta biinga u poi hii bumbuu soni kaba a sösö gbegedee. Nöö di hogi dë o hopo ën seei buta leti a di kaba apaiti kamian u Masa Gaangadu Wosu, ka hën wanwan bi musu dë. Sö a o hopo ën seei tjika. (Nöö fa u sikifi ën aki, nöö di sëmbë di ta lesi, nöö be a buta mëni nëën bunu faa musu fusutëën.) ");
INSERT INTO srmNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Nöö te di soni u taki dë pasa, nöö dee sëmbë dee dë a Judea köndë aki nöö de musu kule hesihesi go tjubi a dee gaan kununu liba e. ");
INSERT INTO srmNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ee wan sëmbë i dë a i wosu a baiko a liba ala, nöö i musu bazia wante kai a goon kule go tjubi. Ja musu bia go a i wosu dendu seei taa i nango tei soni fii tja go ku i. Nönö. Sö i musu biinga kule hesi tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nöö dee sëmbë dee dë a goon dendu, sö nöö de musu kule wantewante go tu. De an musu go a wosu go tei koosu u de tjai. ");
INSERT INTO srmNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nöö a o tjali möönsö o, dee sëmbë, da dee mujëë dë ku bëë ku dee dë ku miii a maun. Biga dee daka naandë o dë wan hebi daka seei da de. ");
INSERT INTO srmNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Nöö un musu ta begi Gadu taanga e, be di juu naandë an kisi i a kötö ten, ee nasö a saba daka ˻di a’ tjina fii kule˼. ");
INSERT INTO srmNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Biga mi taki da unu taa, fu sensi di Masa Gadu mbei goonliba, nöö di lö gaan fuka dë an bi ko pasa wan daka eti. Nöö söseei tu an o pasa ufö di ten dë dou. Nöö fa a o pasa naandë, nöö an o pasa möön tu e. ");
INSERT INTO srmNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka soni o hogi tjika dë, mi taki da unu taa ee Masa Gaangadu an tapëën hesi, nöö na wan sëmbë o dë ku libi a goonliba möön. Hii sëmbë seei tuu fiaa o dëdë kaba. Ma fu dee sëmbë dee Masa Gaangadu tei ko sëmbë fëën, nöö fu de hedi wë a o tapëën möön hesi. ");
INSERT INTO srmNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Söö. Nöö di juu dë, nöö wan sëmbë o ko taki da i taa: ‘Luku di Paamusi Könu leti naandë!’ Ma wan musu piki e. ");
INSERT INTO srmNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Biga sömëni sëmbë o ta hopo ta ganjan sëmbë taa de da tjabukama u Gadu ee nasö de da di Paamusi Könu. De o ta du gaan foondo soni ta bia sëmbë hedi ta hai tja ko a de së. Mi taki da unu taa ee a bi sa, nöö de bi o ganjan dee sëmbë fu Gadu seei tu, dee a bi tei kaa ko sëmbë fëën seei. Un si ö? ");
INSERT INTO srmNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nöö fa mi ta taki dee soni da unu aki, nöö mi ta taki de a fesi da unu fu buuja an musu kisi unu. Biga un bi jei de kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nöö mi o toona bai unu wan pasi möön, kumafa i si mi bi bai unu dë kaa taa ee de ko taki da i taa: ‘Di Paamusi Könu ko e! A dë leti a sabana dendu ala!’ nöö wan musu kule go luku e. Biga na tuu. Ee de taa: ‘Haika, a dë leti tjubitjubi a wosu dendu dë,’ ma wan musu piki e. ");
INSERT INTO srmNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Biga te mi ko, nöö an o dë wan tjubitjubi soni sö. Nönö. A o dë limbolimbo u hii sëmbë u goonliba sa si, leti kuma te gaangadu koti faja a di së u sonu kumutu nöö i ta si ën te a di së u sonu go tu. Sö nöö di ko u Mi di ko Libisëmbë Mii aki o dë e. An o dë seei u oto pena taki da oto, biga hii sëmbë o si mi kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ja sabi fa a dë te soni dëdë pondi a wan kamian nö? Te wan pisi nöö joo si hia tingifou ta hai ta ko gidjii dë u de ko njan di soni. Wë sö nöö di ko u mi o dë u hii sëmbë sa si tu. An o dë a tjubi. ");
INSERT INTO srmNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nöö a baka u di fukaten u bi taki dë, nöö wanlö gaan soni o pasa, leti kumafa di tjabukama u Gadu bi taki ën. A taa: Di sonuwojo o dungu kankan. Nöö di libawojo an o tuwë limbo möön tu. Nöö dee teeja dee dë a liba ala, de o ta kumutu a de kamian ta puu ta kai. Hii soni u mundu kaa o ta seki. Sö di tjabukama bi taki, nöö sö a o ko pasa a di ten u ta taki aki. ");
INSERT INTO srmNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Nöö di juu ten dë, de o si di maaka fu Mi di ko dë Libisëmbë Mii aki te a liba ala, nöö hii sëmbë u di goonliba aki tuu o ta bai ta këë te na soni. Biga de o si mi ta koti faja ta ko a dee bundji dendu ala ku gaan kaakiti. ");
INSERT INTO srmNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nöö fa mi o ta ko dë, nöö wan tutu o piki taanga. Nöö dee basia fu Masa Gaangadu köndë o ta waka ta pii hii dee sëmbë u Gadu tuu hai tja ko buta a wan kamian. De o pii de a hii kamian ka de bi dë, ee a sonu go, ee a sonu kumutu, ee a basusë, ee a libasë. Sö dee basia o hai de ko makandi. ");
INSERT INTO srmNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Söö dee sëmbë, be mi lei unu wan soni a di fuuta pau de kai figa. Te un si di pau dë toona ta buta njunjun uwii ta ko, nöö un sabi taa a deewei buka u dë, na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wë nöö so seei tu, te un si dee soni mi bi taki da unu aki ta pasa, nöö un musu sabi taa di juu kisi u Mi di ko dë Libisëmbë Mii aki toona ko. ");
INSERT INTO srmNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nöö mi taki da unu seei gbelin taa dee lö sëmbë u di ten u dë aki, na de tuu o dëdë e, bifö hii dee soni mi taki dë tuu o ko pasa. ");
INSERT INTO srmNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","“Nöö fa mi ta fan ku unu aki, nöö mi taki e, taa hii soni u goonliba aki ku hii soni a liba ala tuu sa kaba a sösö, ma dee wöutu dee mi ta taki da unu aki, na wan u de seei o lasi kaba a sösö möönsö. Sö de dë tuutuu soni tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ma nöö fa mi taki dee soni dë seei, ma na wan sëmbë sabi na un juu ten de o pasa e. Dee basia u Gadu Köndë an sabi, nöö Mi di Mii u Gadu aki seei, ma sabi tu. Ma mi Tata a liba wanwan tö nöö sabi un juu de o pasa. ");
INSERT INTO srmNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Nöö leti kumafa un jei soni bi waka a di ten u Noa, nöö sö nöö soni o dë a di ten Mi di ko dë Libisëmbë Mii aki o toona ko a goonliba. ");
INSERT INTO srmNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Biga dee sëmbë u di ten naandë bi dë ta njan u de ta bebe ta tei mujëë ta da mujëë manu, tee dou di daka Noa go a di gaan sipi. ");
INSERT INTO srmNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","De an bi mëni seei taa sö wan hogi dë u ko miti de. Ma te u de kë mëni, nöö hën tjuba kai gbulululu singi di goonliba piii, sawa de tuu fia tja go kii puu dë. “Nöö mi taki da unu taa leti sö nöö a o dë a di juu ten mi o toona ko a goonliba. ");
INSERT INTO srmNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Biga tu sëmbë sa dë u de a goon dendu ta wooko, te wan pisi mi o ko tei wan u de tja go, di otowan o fika naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tu mujëë o dë u de ta puu fania, te wan pisi mi tei wan u de tja go, di otowan fika. ");
INSERT INTO srmNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nöö hën mbei mi ta bai unu aki taa be un ta dë setiseti ta mëni mi e. Biga wan o sabi na un juu di Masa fuunu aki o toona ko a unu.” ");
INSERT INTO srmNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nöö hën Masa Jesosi toona taki wan oto soni u di ko fëën möön taa: “Di ko u mi o dë leti kuma te wan fufuuma go booko wan wosu a ndeti. Wë nöö di sëmbë di abi di wosu, ee a bi sabi un juu di fufuuma bi o ko, nöö a bi o dë ku wojo setiseti ta watji ën fu an ko booko di wosu fëën. Na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nöö hën mbei un musu ta dë setiseti e. Biga tee wan daka nöö mi o dou a unu liba vau sö, a wan juu di wan bi mëni seei taa mi ta ko.” ");
INSERT INTO srmNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","46","Hën a taa: “Di juu dë o dë kuma te wan guduma o go a wan kamian. Nöö a o kai wan u dee futuboi fëën ko nëën faa musu butëën basi a dee otowan fëën liba. Hën o ta seeka de ta da de njanjan kumafa a dë fanöudu, fu tee di juu kisi fu de masa toona ko. “Wë nöö a o bunu seei da di lö futuboi dë e, ee a dë taa a ta du di wooko fëën a wan bunu fasi ku fusutan. ");
INSERT INTO srmNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Biga tee di juu dou u di masa fëën toona ko, nöö a o si taa a wooko bunu. Nöö a o wai ku ën seei te a o buta hii gudu fëën tuu nëën maun faa musu ta seeka dëën nöömö. ");
INSERT INTO srmNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Ma ee di futuboi dë wan hogi sëmbë, nöö kandë a o pakisei nëën hati taa: ‘Wë fa di masa u mi ta hoi longi tjika aki, nöö kandë an o ko eti.’ ");
INSERT INTO srmNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nöö a o seti ta fon dee oto futuboi kuma hën ta du hogihogi ku de. Nöö a o ta waka ku dee mati fëën ta njan ta bebe soni a kamiankamian ta dööngö. ");
INSERT INTO srmNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nöö i sabi andi o pasa ö? Te wan pisi nöö di masa fëën o ko dou a wan juu di an bi mëni ën seei. ");
INSERT INTO srmNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nöö mi taki da unu taa a o sitaafu di futuboi fëën naandë wan gaan hogi sitaafu e. Biga a o tuwëën go a di kamian ka dee bödjëëma ta dë, nöö naandë a o dë ta tja fuka ta bai ta kai olo ta njan tanda fu nöömö.” Sö wë Masa Jesosi taki da u di juu dë. ");
INSERT INTO srmNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nöö hën Masa Jesosi taa: “Mi o konda wan oto woto da unu aki möön u lei unu fa di Njunjun Tii u Gadu dë.” Hën a taa: “˻Wë un sabi fa di guwenti dë kaa, u te wan womi ku wan mujëë o tööu. Dee wëndjë mujëë mii o go miti ku di womi fu de tei ën tja go tööu ku di mujëë. Na sö nö?˼ “Wë nöö hën wë de o hoi wan tööu, nöö teni mujëë mii bi musu go miti ku di womi a wan kamian, fu de tjëën ko a di mujëë. Hën wë de seeka te de kaba, hën de tei de lampu faja hën de nango. ");
INSERT INTO srmNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","3","Ma nöö feifi u dee mujëë mii waka a wan don fasi. Biga de an tja oli möön leki di dë a de lampu kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma nöö de feifi otowan, de waka ku fusutan. Biga di de kumutu fu de go, nöö hën de tja oli go ku de. ");
INSERT INTO srmNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Nöö hën wë de go sai dë ta luku di womi o tööu di tööu faa ko. Ma nöö a waka lati seei, hën de sai dë tefa ndeti, hën wë duumi tja de gbolo. ");
INSERT INTO srmNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Hën de dë te tuwalufu juu u ndeti, te u de kë mëni hën de jei bai taa: ‘Un hopo! Un hopo seeka! Di womi ta ko e!’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Nöö hën de teni mujëë mii panta hopo vu, hën de kisi lampu u de valai seeka hesihesi. ");
INSERT INTO srmNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Ma nöö dee feifi dee bi waka a don fasi dë, hën de pidi dee otowan taa: ‘Mujëë gaantangi, u begi unu un da u wan piki oli fuu munjan maaun, biga faja fuu ta tapa.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ma nöö de piki de taa: ‘Wë nönö, mujëë, di fuu an hila tjika fuu da unu e. Be un go bai a dee wënkëma.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Nöö hën wë de feifi mujëë mii hën de go u go bai oli. Nöö fa de go dë, hën di womi ko miti ku de feifi mujëë mii dee bi fika dë, nöö hën de tjëën go a di tööuwosu. Nöö di de go dou, hën de tapa döö gbalai söötö, biga di juu pasa kaa u sëmbë musu ko a di piizii. Nöö hën de dë a di piizii wante. ");
INSERT INTO srmNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nöö hën de sai dë tee wan pisi hën de feifi mujëë mii dee bi fika baka dë ko dou ko ta naki di döö ta bai taa: ‘Gaantangi o, dee sëmbë. Un ko jabi döö da u baa.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Nöö hën di womi di abi di tööu hakisi taa: ‘Ambë da dee sëmbë ta bai ta kai mi dë?’ Hën a gandji da de taa: ‘Un go kumutu dë e! Ma sabi unu seei!’ ” Sö wan oto wë Masa Jesosi tei konda da u te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nöö hën a taa: “Hën wë mbei mi ta bai unu e, taa be un dë seei kabakaba hiniwanten. Biga wan sabi di juu di mi o toona ko a goonliba.” ");
INSERT INTO srmNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nöö hën a toona tei wan oto woto konda da u möön, faa lei u fa di Tii u Gadu dë. A taa: “Wan guduma bi dë nëën köndë, nöö hën wë a o go a waka a wan oto köndë. Nöö di a o go, hën a kai dii futuboi fëën ko nëën, nöö hën a tei möni hën a paati da de fu de musu wooko ku ën dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","“Wë nöö di fosuwan a buta feifi dusu nëën maun. Di u mbei tu a buta tu dusu. Di u mbei dii hën a buta wan dusu. Nöö fa a da de di möni peipei dë, nöö a da de ën leti kumafa a sabi taa de abi köni tjika fu de sa wooko ku ën. Hën a baka u di dë, hën a tei pasi hën a go. ");
INSERT INTO srmNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Nöö fa di masa go dë, hën di futuboi di feni di feifi dusu dë, hën a ta wooko ku ën tefa a toona feni feifi dusu möön buta nëën liba, a ko teni dusu. Sö di sëmbë dë wooko ku di fëën tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nöö söseei di u tu, a wooko ku di fëën tee a feni tu dusu möön buta a di fëën liba, a ko fö dusu. ");
INSERT INTO srmNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Ma nöö di u mbei dii, hën a tei di wan dusu fëën dë nöö hën a go diki baaku te a kaba, hën a bei ën buta a goon basu dë. ");
INSERT INTO srmNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Wë nöö di masa u de go tan longi seei ufö a toona ko. Nöö di a toona ko, nöö hën a kai dee futuboi fu de ko konda dëën unfa de wooko ku di möni tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Nöö hën di fosuwan ko. Nöö hën a taki dëën taa: ‘Masa o.’ A piki. A taa: ‘Wë di feifi dusu i bi disa da mi aki nöö mi wooko ku ën e, tee nöö hën mi feni feifi dusu toona buta nëën liba möön. Nöö ja ta si ën aki nö? Mi tjëën ko da i.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Hën di masa fëën wai ku ën seei. A taa: ‘Aai, womi, i dë wan sëmbë u futoou e. I dë wan bumbuu futuboi u mi seei. Wë nöö di i wooko sö bunu ku di piki soni mi bi buta a i maun dë, nöö mi o toona buta wan möön gaan soni a i maun awaa. Nöö be i fika ku mi aki e, be u tuu ta wai makandi.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nöö baka u di dë, hën di u mbei tu hën a ko. Nöö hën a taa: ‘Wë, Masa.’ Hën a piki. A taa: ‘Wë i bi da mi tu dusu. Wë nöö mi wooko ku ën te nöö hën mi toona feni tu dusu buta nëën liba möön. Ja ta si ën aki nö? Mi tjëën ko da i.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Hën di masa fëën taki dëën taa: ‘Aai, womi, i dë wan sëmbë u futoou e. I dë wan bumbuu futuboi u mi seei. Wë nöö di i wooko sö bunu ku di piki soni mi bi buta a i maun dë, nöö mi o toona buta wan möön gaan soni a i maun awaa. Nöö be i fika ku mi aki e, be u tuu ta wai makandi.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nöö hën di u mbei dii nöö hën a ko dou. Hën a taa: ‘Wë Masa, wë fa i dë aki, wë nöö mi bi sabi taa i dë wan hogi sëmbë. I ta koti soni ka ja bi paandi. I ta pii ka ja bi jaa tuwë. ");
INSERT INTO srmNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nöö di mi sabi sö fii kaa, nöö mi fëëë e. Nöö hën wë mbei mi go diki baaku te mi kaba hën mi bei di möni fii. Nöö ja ta si ën këdë aki, mi tjëën ko da i.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nöö di di sëmbë fan sö te a kaba, nöö hën di masa fëën hati boonu. Hën a gandji dëën te na soni, a taa: ‘Ju hogisonima, malëngëma ju! Di i bi sabi taa mi ta koti soni ka ma bi paandi, mi ta pii soni ka ma bi jaa tuwë, ");
INSERT INTO srmNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","wë nöö i bi sa tja di möni u mi tololoo go buta a banku. Biga mi bi sa feni wan piki wini nëën te mi ko.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Nöö hën a manda dee oto futuboi fëën taa: ‘Un go puu di wan dusu nëën maun naandë e, nöö un da di sëmbë di abi teni dusu ën. ");
INSERT INTO srmNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Biga di sëmbë di bi abi te a hila kaa, nöö hën o toona feni te pasa maaka. Ma nöö di sëmbë di abi wan pikiwan nöö, nöö nëën maun de o puu di pikiwan a abi dë, be a fika ku sösö maun tjololoo.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Hën a taa: ‘Un go tei di sösö futuboi naandë puu a mi aki, nöö un tuwëën go a dungudungu ala, ka sëmbë ta tja fuka ta bai ta kai olo ta njan tanda fu nöömö.’ ” Nöö sö wan woto Masa Jesosi tei lei u e. ");
INSERT INTO srmNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Hën a toona fan ku u möön, a taa: “Te wan daka nöö Mi di ko dë Libisëmbë Mii aki o toona ko a goonliba e, mi ku dee basia u Gadu Köndë tuu. Nöö fa mi o ko dë, nöö ku hii di hei u Masa Gadu di a abi, ku hën wë mi o ko e. Biga mi o ko fu mi ko sindo a di könubangi u mi, nöö di waiti u Gadu o ta koti faja a hii di kamian. ");
INSERT INTO srmNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","“Nöö di juu ten dë, nöö de o kai hii sëmbë u goonliba kumutu a hii dee köndëköndë tuu fia tja ko a mi fesi, nöö mi o paati de a tu pei. Hafu u de o dë a mi letimaun së, hafu u de o dë a mi töötömaun së, leti kumafa dee sëmbë ta kiija mbeti ta paati dee mbeti u de, sikapu dë a wan së, kaabita dë a wan së. ");
INSERT INTO srmNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Nöö mi o taki da dee sëmbë dee dë a mi letimaun së taa: ‘Söö, wë un dee sëmbë Gadu limbo fesi da aki, un pasa ko tei di kamian fuunu a mi Tata köndë aki e, di i si a bi seeka buta dë gaanduwe da unu kaa bifö a seti mbei goonliba. ");
INSERT INTO srmNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Biga di mi bi dë da hangi ta kii, nöö hën un da mi soni mi njan. Di dëëwata bi ta kii mi, hën un da mi wata mi bebe. Di mi bi dë wakama, nöö hën un tei mi buta a unu wosu seeka. ");
INSERT INTO srmNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi bi dë pënëpënë söndö soni a sinkii, hën un tei koosu da mi, mi bisi. Di mi bi siki hën wë un sölugu mi. Nöö di de bi tja mi go söötö a dunguwosu nöö hën un ko luku mi e.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Nöö fa mi o fan dë, nöö a o bigi seei da de. Nöö de o hakisi mi taa: ‘Wë Masa o, na un juu u bi si i a kamian hangi bi ta kii i, hën u da i soni fii njan? Na un juu u bi si dëëwata ta kii i, hën u da i wata i bebe? ");
INSERT INTO srmNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na un juu u bi si i kuma wakama a wan kamian hën u tei i buta a wosu? Na un juu u bi si i söndö koosu a sinkii hën u da i soni u bisi? ");
INSERT INTO srmNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na un juu u si i suwakisuwaki ee nasö a dunguwosu, hën u bi ko luku i?’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Nöö mi o piki de taa: ‘Haika e. Hii dee bunu dee i si un bi ta du dee sëmbë u mi tee dou ku dee kaba lagiwan tuu ala, nöö mi seei wë un bi ta du dee bunu dë e.’ Sö mi o piki de. ");
INSERT INTO srmNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nöö baka u di dë, nöö mi o bia fan ku dee dë a mi töötömaun së taa: ‘Un waka pasa kumutu a mi fesi dë! Fa di siba u Gadu kisi unu dë, nöö un kaba a sösö e! Nöö un go a di faja di ta kisi u nöömö, di de bi seeka da di didibi ku dee basia fëën. ");
INSERT INTO srmNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Biga mi bi dë ku hangi ma wan bi da mi soni u njan. Dëëwata bi kisi mi, ma wan bi da mi wata mi bebe. ");
INSERT INTO srmNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi bi dë wakama a unu mindi ma wan tei mi buta a wosu. Mi bi dë pënëpënë ma wan da mi soni mi bisi. Mi bi siki, mi bi dë a dunguwosu, ma wan ko sölugu mi.’ ");
INSERT INTO srmNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nöö de o piki mi taa: ‘Aan, ma Masa o, a bigi da u poi. Na un juu seei u bi si i ku hangi, ma wa bi da i soni u njan? Na un juu u bi si i dëë wata ta kii, ma wa bi da i wata fii bebe? Na un juu u bi si i kuma wakama ma wa bi tei i buta a wosu? Na un juu u bi si i söndö koosu a sinkii ma wa da i koosu fii bisi? Na un juu seei i bi dë suwakisuwaki ee nasö a dunguwosu, ma wa bi sölugu i?’ Sö de o hakisi mi. ");
INSERT INTO srmNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Nöö hën mi o piki de taa: ‘Mi taki da unu seei gbelin, taa fa i si wan bi heepi dee sëmbë u mi te dou ku dee kaba lagiwan seei, nöö mi seei wë i si wan bi heepi dë e.’ Sö mi o piki de. ");
INSERT INTO srmNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Wë sö wë i ta si taa dee takulibima o feni gaan sitaafu fu teego, ma nöö dee sëmbë ta libi bunu a Gadu wojo, de o feni di libi u teego.” Nöö sö wan oto Masa Jesosi taki dë. ");
INSERT INTO srmNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nöö a baka u di dë, hën Masa Jesosi kai u dee bakama fëën te u piki. Hën a fan ku u taa: ");
INSERT INTO srmNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Dee sëmbë, fa u dë aki tu daka nöö fika e, nöö di Pasika o kai. Nöö a dee daka ta ko aki de o kisi Mi di ko Libisëmbë Mii aki tja go buta a sëmbë maun u de musu peka mi a lakpa pau kii.” Sö wan soni Masa Jesosi taki da u. ");
INSERT INTO srmNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wë nöö di juu dë kaa, nöö dee Gaan Begima ku dee Gaan Womi bi go dë a di wosu u di Kaba Hei Begima de kai Kajafasi. ");
INSERT INTO srmNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nöö naandë wë de go sindo ta kuutu unfa de sa du de feni Masa Jesosi tja go kii. ");
INSERT INTO srmNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma so u de dë a di kuutu taa: “Dee sëmbë, un haika e. Ee woo du di soni aki, nöö wa musu du ën a di Pasika daka, biga di köndë o mbei wajawaja da u poi nöö woo abi hogi në a lanti.” Sö so u de taki a di kuutu dendu. ");
INSERT INTO srmNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nöö di juu dë, u ku Masa Jesosi dë a di köndë de kai Betania. Nöö hën u go a di wosu u wan womi de kai Simon di bi siki tjinasiki, go njan. ");
INSERT INTO srmNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nöö hën u ta njan te wan pisi, hën wan mujëë ko dou ku wan hanse bata nëën maun ku wan gaan dii sumëësuti fatu nëën dendu. Nöö hën a waka tololoo ko a Masa Jesosi ka a dë a tafa naandë, hën a tutu di fatu nëën hedi te di fatu kaba këëë a di bata. ");
INSERT INTO srmNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nöö fa a du ën dë, nöö di soni an bunu da u dee bakama u Masa Jesosi seei, nöö hën u sai dë ta guunjan di mujëë taa: “Wë andi a du dë maingë? Di gaan dii fatu dë sö hën a poi kaba a sösö nö? ");
INSERT INTO srmNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Biga a bi sa sei ën puu gaan hila möni, nöö de tei di möni paati da dee penama u di köndë.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma fa u ta fan dë, Masa Jesosi sabi kaa. Hën a hakisi u taa: “Ma dee sëmbë o, andi mbei un sai dë ta guunjan di mujëë u du? An du wogi e. Wan gaan bumbuu soni seei wë a du da mi aki. ");
INSERT INTO srmNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Biga dee pootima o dë aki nöömö fuun ta sölugu, ma mi, ma o dë ku unu longi möön e. ");
INSERT INTO srmNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","“Ma nöö boiti u di dë, i si fa di mujëë du dë ö? Fa a tutu di fatu a mi sinkii aki, nöö mi sinkii wë i si a seeka sö a fesi e, da di bei di de o bei mi abiti möön aki. ");
INSERT INTO srmNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","“Nöö mi taki da unu taa a hii kamian u goonliba ka de o ta konda di buka u mi kaa, nöö sö de o ta konda di bumbuu soni di mujëë aki du da mi tu.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nöö fa u mbei dë, hën wan fuu de kai Judasi Isikaliotu hopo vu disa u, nöö hën a waka tololoo go a dee Gaan Begima ka de ta kuutu dë, dee felantima u Masa Jesosi. Hën a go hakisi de taa: “Wë ee mi mbei möiti fuun sa feni Jesosi kisi, nöö andi woon paka mi?” ");
INSERT INTO srmNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Hën de taa: “Sö nö womi? Wë ee u da i diiteni pisi soofu möni, nöö a o tjika ö?” Hën a taki aai. Hën de tei di möni konda kpaakpaa te de kaba gbelin, hën de tëndë dëën. Hën a tei ën nöö hën a go. ");
INSERT INTO srmNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nöö fu seti a di ten dë, hën a ta suku pasi nöömö unfa a sa du buta Masa Jesosi a dee felantima fëën maun. ");
INSERT INTO srmNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wë nöö di gaan piizii de kai Pasika dë, nëën de ta njan di bëëë di de ta jasa söndö sooda, ˻nöö sömëni daka longi de ta njan mën. Nöö a di fosu daka fëën de ta kii di sikafu mii njan.˼ Nöö hën mbei u hakisi Masa Jesosi taa: “Masa o, naasë i kë fuu seeka kamian fuu ku i sa njan di daka?” ");
INSERT INTO srmNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hën a taki da u taa: “Wë un haika. Un go a di köndë di dë leti a u fesi aki, nöö woon si sö wan womi. Nöö un taki dëën taa: ‘Di Mësitë taki e, a taa di juu Gadu buta dëën nöö a ko zuntu kaa. Nöö a taa a kë ko njan di Pasika aki a i wosu.’ Sö fuun taki da di womi e.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nöö hën so fuu go hën de feni di wosu, hën de seekëën te de kaba fuu go njan. ");
INSERT INTO srmNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nöö hën di sapate hën u go sindo a tafa ta njan, Masa Jesosi ku u dee tuwalufu bakama fëën tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hën u dë te wan pisi, hën a fan ku u taa: “Mi taki e, taa wan fuunu dë leti a u dendu aki o tja mi go sei da dee felantima u mi.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nöö di a fan sö tefa a kaba, hën a hati u tee, a da u gaan pakisei. Nöö hën u ta hakisi ën taa: “Masa o, fa i fan dë, nöö a sa kë taa mi ö?” Sö u ta hakisi oto a oto baka. ");
INSERT INTO srmNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hën a piki taa: “Wan fuunu di i si mi ku ën ta munjan bëëë a di wan kodo baafu paabi aki, hën wë o sei mi sö e. ");
INSERT INTO srmNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nöö a dë sö tuu taa dee tjabukama bi sikifi sömëni soni a fesi u Mi di ko Libisëmbë Mii aki, nöö de tuu musu pasa. Ma helu u di sëmbë di o sei mi aki. A bi möön bëtë hën mama an bi pai ën wan daka ko a di goonliba aki.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nöö fa a fan dë, hën Judasi seei hakisi ën awaa taa: “Wë Mësitë, ambë da di sëmbë? Mi nö?” Hën a piki ën taa: “Leti kumafa i si i taki ën dë, nöö sö a dë e, womi.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nöö fa u dë a tafa ta njan naandë, te wan pisi hën Masa Jesosi tei wan bëëë hën a da Gadu tangi te a kaba. Nöö hën a booko ën hën a tëndëën da u. Hën a taa: “Ja si fa mi booko di bëë aki ö? Hën da di sinkii u mi ˻di o booko fu libisëmbë hedi˼. Un tei ën nöö un njan e.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nöö a baka u di dë, hën a tei wan kan win hën a toona da Gadu tangi möön te a kaba, hën a tëndëën da u. ");
INSERT INTO srmNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","A taa: “Un tei nöö un bebe e. Hën da di gadjabia u mi di mi o tuwë a goon fu Gadu sa mbei wan njunjun buka ku libisëmbë. Biga fa de o kii mi aki, nöö hën o mbei Gadu o puu hia sëmbë a bëë u dee hogi de bi du.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Hën a taa: “Mi taki da unu e, taa te mi ku unu bebe win a di fasi aki möön, nöö di Njunjun Tii fu mi Tata hën seti kaa e.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nöö di u njan te u kaba kaa, hën u kanda wan kanda da Masa Gaangadu te u kaba, hën wë u hopo kumutu naandë ta waka nango a di kuun de kai Oleifi Kuun. ");
INSERT INTO srmNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hën Masa Jesosi fan ku u, a taa: “Dee sëmbë o, a di ndeti i si aki seei nöö na wan fuunu o abi biibi a mi liba möön e. Un tuu o go disa mi. Biga a o pasa leti kumafa dee fesiten tjabukama bi sikifi buta a di Buku taa de o fon di sëmbë di ta luku dee sikafu, nöö hii dee sikafu tuu o kule paaja fanjanfanjan. ");
INSERT INTO srmNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Ma nöö mi taki e, te mi weki baka kumutu a dëdë, nöö mi o go dë a Galilea ta luku unu.” Nöö sö Masa Jesosi fan ku u tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma nöö fa a fan dë, hën Petuisi piki ën wante taa: “Ambë, Masa! Aluwasi hii dee otowan aki tuu go disa i ma mi, aan juu seei di mi o disa i möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nöö hën Masa Jesosi piki ën taa: “Womi, fa mi o fan aki, nöö tuutuu soni mi o taki e. A di ndeti aki seei, ganian an o kanda ufö joo fia dii toon taa ja sabi mi, womi.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wë nöö Petuisi an sa jei di soni dë. A taa: “Aluwasi ee mi ku i musu dëdë makandi seei, ma ma o fia möönsö taa ma sabi i. Na seei.” Nöö fa Petuisi taki dë, nöö sö nöö u dee oto bakama tuu taki. ");
INSERT INTO srmNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nöö hën u ku Masa Jesosi nango tefa u go dou a wan djai de ta kai Gëtiseimani. Nöö hën a taki da u taa: “Un sindo aki ufö e, nöö mi o go ala go begi.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nöö hën a tei Petuisi ku de tu mii u Zebedeosi, hën de ta waka nango te de go dou a wan kamian u di djai. Nöö hën gaan pakisei ko a Masa Jesosi liba te an saanfa u du. A ko dë seei fukafuka tee na soni. ");
INSERT INTO srmNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hën a taki da de taa: “Womi, fuka ku tjali fuu mi hati tee kuma a sa tja dëdë kii mi. Nöö un tan aki ta da mi taanga e.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nöö hën a waka go a fesi abiti sö, hën a kai tapa fesi a goon dë wante. Nöö hën a begi taa: “Ke Taata o, gaantangi mi begi i, di soni di i lai da mi u mi bebe aki, ee i sa puu ën da mi u ma bebëën nöö be i puu ën o. Ma nöö fa mi fan aki seei, ma na du di soni di mi kë e, ma be a pasa kumafa i kë.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nöö di a begi sö tefa a kaba, hën a hopo toona go a de dii womi dee a bi disa dë, nöö hën a si taa de ta duumi. Hën a kai Petuisi te a piki a taa: “Womi, wan sa tan ku wojo ku mi di wan kodo juu langa aki seei nö? ");
INSERT INTO srmNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wë un weki hoi wakiti e, nöö un begi taanga be di didibi an wini unu. Ma mi sabi taa hati fuunu kë du kumafa a fiti, ma wan taanga sö.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nöö hën a toona go begi di wan seei begi baka. A taa: “Taata, di soni di i lai da mi u mi bebe, nöö ee an sa puu, nöö heepi mi be mi bebëën nöö. Biga di soni di i kë, nöö hën musu pasa.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nöö hën a toona ko a de dii bakama fëën möön, hën a si taa de toona ta duumi möön. Duumi nöö hebi a de wojo sö. ");
INSERT INTO srmNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nöö hën a disa de dë, hën a toona go begi di u mbei dii pasi, di wan seei begi te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nöö hën a toona ko a de dii bakama dë möön. Hën a fan ku de taa: “Duumi nöö un ta duumi ta böö sinkii sö nö baa? Wë ma nöö di juu kisi o. De sei Mi di ko dë Libisëmbë Mii aki da dee hogihatima kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nöö un hopo boo go e, biga di sëmbë di sei mi hën wë ta waka ta ko dë.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nöö Masa Jesosi an kaba u fan seei, nöö hën wë Judasi dou, hën ku wanlö gaan hila sëmbë. De ko ku feti lai e, de ko ku ufangi, de dë ku kodjo a maun. Nöö fa de ko dë, nöö dee Gaan Begima ku dee Gaan Womi wë bi manda de e. ");
INSERT INTO srmNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wë nöö Judasi di könkuma bi taki da de kaa taa: “Haika, mi o da unu wan maaka. Fa i si woo go dou naandë, nöö di sëmbë di i si mi o bosi, nöö hën da di sëmbë di un musu kisi e.” Sö wan buka a bi mbei ku de te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nöö fa de go dou naandë, hën a waka go a Masa Jesosi wante, hën a dëën odi taa: “Mësitë, odi o.” Hën a bosi ën a bandjajesi naandë ˻kumafa di guwenti u di köndë bi dë te joo da wan sëmbë fii odi˼. ");
INSERT INTO srmNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hën Masa Jesosi taa: “Mati o, di soni di i ko aki fii ko du, nöö be i du ën nöö e.” Nöö fa a fan dë, hën dee sëmbë kule voo ko kisi ën gbalau panjan gingin wante u de tja go. ");
INSERT INTO srmNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nöö hën wan fuu dee bakama u Masa Jesosi hai di ufangi fëën valau puu a dosu hën a hiti go dë. Nöö hën a koti di futuboi u di Kaba Hei Begima jesi belim puu tuwë a goon naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma nöö hën Masa Jesosi taa: “Nönö womi, toona tuusi di ufangi fii nëën dosu e. Biga di sëmbë di hopo ufangi a liba nöö ju ufangi o kii.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hën a toona taa: “Unfa i mëni, baa? I sa’ taa ma abi kaakiti fu mi sa hakisi mi Tata faa heepi mi nö? Biga a sa manda möön un mëni dusudusu basia fëën köndë u ko puu mi a dee sëmbë aki maun. ");
INSERT INTO srmNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma nöö ee mi du sö, nöö dee soni dee fesiten tjabukama bi sikifi buta a di Buku, nöö de an o pasa möön.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nöö hën a bia fan ku dee hia sëmbë ko nëën naandë, a taa: “Dee sëmbë, faandi mbei un ko a mi aki ku feti soni ku kodjo ku ufangi, fuun ko kisi mi kuma mi da wan toobisëmbëma a di köndë? Biga hiniwanten mi bi dë a di Wosu u Masa Gadu ta lei sëmbë, ma tökuseei wan bi kisi mi. ");
INSERT INTO srmNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","“Ma seei mi sabi taa dee soni ta pasa aki, nöö de musu fu ko pasa, be dee soni dee fesiten tjabukama bi sikifi musu ko tuu.” Nöö fa a fan dë, nöö hën hii u dee bakama fëën tuu fiaa kule go disëën. A fika hën wanwan ku dee sëmbë dee ko kisi ën dë. ");
INSERT INTO srmNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nöö hën de tei ën tja go tee a di wosu fu di Kaba Hei Begima u bi taki dë de kai Kajafasi. Biga naandë dee Sabima u Wëti ku dee Gaan Womi tuu bi hai ko makandi ta luku u de tja Masa Jesosi ko. ");
INSERT INTO srmNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma nöö fa dee sëmbë ta tjëën go dë, nöö Petuisi bi dë te a baka ala ta waka sapisapi ta ko. Nöö hën a nango tee go dou a di djai dendu. Nöö hën a sindo ku dee watjima u di wosu ta luku ee unfa de o du ku Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nöö di juu dë, hën di Kaba Hei Begima ku dee tiima ku hii dee oto kuutuma u dee Dju tuu sai dë kaa ta mindi soni ta buta a Masa Jesosi hedi. De ta suku föutu nëën nöömö fu de feni tja go konda da dee lanti u Loomë dee ta tii di köndë, be gaan lanti sa piki taa a musu dëdë. ");
INSERT INTO srmNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma nöö hii fa de ta pii soni ta mindi dëën seei, ma na wan soni de si bigi tjika faa musu dëdë. ");
INSERT INTO srmNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Te wan pisi, hën tu u dee mindisonima hopo taanpu. Hën de taa: “Lanti, un haika e. Di womi i si aki sö, hën bi taki taa a sa booko di Wosu u Masa Gadu tuwë a goon, nöö a dii daka dendu nöö a sa toona mbei ën baka. Sö wë a bi taki e, fa i si un ta si ën aki.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nöö hën di Kaba Hei Begima hopo vu taanpu a pë. Nöö hën a fan ku Masa Jesosi, a taa: “Wë di soni fii de ta taki aki, andi fëën joo taki? Soni de ta mindi da i, naa sö i taki tuu?” ");
INSERT INTO srmNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma Masa Jesosi dë fëën pii. An piki ën na wan töngö seei. Nöö hën di Kaba Hei Begima fan ku ën möön taa: “Mi manda i e, fii soi da mi a di libilibi Gadu fesi aki, taa di soni joo piki mi, a o dë tuutuu soni. Nöö mi hakisi i taa ee ju da di Könu di Gadu bi paamusi taa a o manda ko? Ju da di Mii u Gadu nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nöö hën Masa Jesosi piki ën awaa, a taa: “Wë leti kumafa i si i taki dë, nöö sö nöö mi dë e. Nöö di juu o dou, nöö woon si Mi di ko dë Libisëmbë Mii aki sindosindo leti a letimaun së u Masa Gaangadu di abi hii kaakiti a mundu. Woon si mi kumutu a liba ala ta saka ta ko e, a dee bundji dendu.” Sö a piki ën. ");
INSERT INTO srmNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wë nöö fa a fan dë, nöö hën di Kaba Hei Begima tënë dee koosu fëën sinkii seei zaaa, ˻hati fëën nöö boonu sö˼. Hën a taa: “Dee sëmbë, andi un kë jei möön? An dë fuu suku kotoigi möön e. Biga wan jei fa a mindi soni da Masa Gaangadu nö? ");
INSERT INTO srmNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Andi un pakisei fuun du ku ën?” Hën de tuu bai piki a di kuutu taa: “Aan soni u du möönsö, dëdë nöö a musu dëdë e!” ");
INSERT INTO srmNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nöö fa u mbei dë, hën de bigi u du hogihogi ku Masa Jesosi awaa. De ta tunta nëën fesi, de ta naki ën ku böö, ˻de tai ën wojo˼ hën de ta naki ën baai maun a bandjajesi ta mbei ën fa taa: ");
INSERT INTO srmNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Di i taa i da di Paamusi Könu, i ku Gadu ta fan, nöö konda da u ee ambë naki i di naki?” Nöö sö dee sëmbë ta du ku Masa Jesosi di juu naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma nöö fa dee soni ta pasa dë, Petuisi hën a dë pii sindosindo ku dee watjima a di djai dendu. Te wan pisi hën wan mujëë futuboi fu di wosu ko nëën, hën a hakisi ën taa: “Wë womi, na i bi dë ku di Jesosi fu Galilea naandë nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nöö hën Petuisi fia a hii dee sëmbë dë fesi taa: “Ambë? Mi? Nönö! Ma saandi i ta taki dë.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hën a hopo kumutu dë waka go a di djai dööbuka ala. Nöö hën wan oto mujëë mii ko nëën möön, hën a fan ku dee sëmbë taa: “Di womi i si aki, a bi dë ku Jesosi u Nazalëti tu e.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hën Petuisi toona fia möön, a soi seei taa: “Ma sabi di sëmbë un ta taki dë e!” ");
INSERT INTO srmNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Te wan pisi, hën wanlö sëmbë bi dë taanputaanpu dë, hën de ko a Petuisi möön taa: “Womi, an dë fii pena fia taa ja dë sëmbë u di womi dë e. Biga u ta jei a di töngö tatai fii taa i da wan Galilea sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Höön, wë Petuisi an bi fia eti e. Hën a ta konda sondi a buka ta sibëën seei ta fia tee, a taa: “Mi taki da unu e, taa di womi dë ma sabi ën seei wan daka, kwetikweti!” Nöö fa a fan dë, wante nöö hën wan ganian bai kanda te a koti. ");
INSERT INTO srmNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nöö hën Petuisi ko mëni di fan di Masa Jesosi bi fan ku ën taa: “A di ndeti aki seei, ganian an o kanda bifö joo fia dii pasi taa ja sabi mi.” Nöö di a ko mëni di soni dë, hën a kule go a döö go këë te a bigi. Hati nöö a hati ën sö. ");
INSERT INTO srmNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nöö hën di dobooko fëën mamate biten, hën dee Gaan Begima ku dee Gaan Womi kai kuutu u de taki unfa de sa du buta Masa Jesosi a dee gaan lanti fu Loomë maun. ˻Biga de an sa manda sëmbë go kii ee na dee Loomë lanti dë da de pasi.˼ Hën de kuutu tefa de ko feni wan baaku. ");
INSERT INTO srmNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nöö hën de go tei Masa Jesosi, hën de bui ën te de kaba. Hën de tjëën go tee a di gaama de kai Pilati, di dee Loomë lanti bi buta faa tii dee Dju sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wë nöö di juu dë, hën Judasi ko si taa fa a sei Masa Jesosi dë nöö de o kii ën tuu. Nöö di sondi ko hati ën tee an saanfa u du möön. Nöö hën a tei de diiteni pisi soofu möni dee de bi pakëën dë, hën a go a dee Gaan Begima ku dee Gaan Womi. ");
INSERT INTO srmNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Hën a taki da de taa: “Dee sëmbë, ma du bunu e. Sö wan bumbuu sëmbë mi sei fu de kii ën tuwë buuu fëën a goon. Biga fa i si a sai dë, na hogi a du möönsö e.” Ma nöö hën de piki ën taa: “Ambë? Wa a’ soni fëën u taki möön e. A fika da i.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nöö di de piki ën sö kaa, nöö hën a hiti di möni tuwë djolou a goon leti a di Wosu u Masa Gadu dendu naandë, hën a kule go hëngi hënseei kii. Nöö sö wë di soni dë pasa ku Judasi e. ");
INSERT INTO srmNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nöö hën dee Gaan Begima go pii di möni te de kaba. Hën de taa: “Wë di möni aki an bunu u buta a di keiki kasi möön. An o kai ku di wëti fuu, biga hën da möni di de paka u de kii sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nöö hën de kai pakisei te de kaba ee unfa u de du ku di möni. Nöö hën de ko fendi taa de o go a dee sëmbë ta mbei dee soni kuma agban sö go bai wan pisi goon a de fu de ta bei wakama. ");
INSERT INTO srmNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hën mbei de ta kai di goon dë Buuu Goon te kisi fa u dë aki. ");
INSERT INTO srmNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Wë nöö fa di soni pasa naandë, nöö a kai makandi ku wan soni di tjabukama u Gadu de kai Jelemia bi taki a fesi, a taa: “De tei dee diiteni soofu möni di dee Isaëli sëmbë bi si taa a hia tjika fu paka u di sëmbë dë, ");
INSERT INTO srmNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nöö hën de go bai wan goon ku ën a dee sëmbë ta tëmbë ku doti, kumafa Masa Gadu manda mi.” Sö a bi dë sikifisikifi a di Buku kaa e. ");
INSERT INTO srmNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Wë nöö di juu dë, de bi tja Masa Jesosi go a Gaama Pilati kaa. Nöö hën di Gaama hakisi ën taa: “Wë ju da di könu u dee Dju sëmbë tuu nö?” Nöö hën Masa Jesosi piki ën taa: “A dë leti kumafa i si Gaama taki naandë.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Di juu dë, dee Gaan Begima ku dee Gaan Womi ta pii soni ta mindi ta buta a Masa Jesosi hedi tee a hia, ma Masa Jesosi an ta piki. A dë fëën pii nöö. ");
INSERT INTO srmNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nöö hën di Gaama hakisi ën taa: “Wë ja ta jei dee hia hogi fii de ta konda dë nö? Nöö ja o piki nö?” ");
INSERT INTO srmNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Masa Jesosi an taki na wan soni möönsö. Nöö di soni ko bigi da Gaama seei fu di a dë fëën pii, an ta piki. ");
INSERT INTO srmNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wë nöö a bi dë sö taa te di Pasika daka dou, nöö Gaama bi guwenti u puu wan sëmbë di lanti kë a dunguwosu da de. ");
INSERT INTO srmNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nöö di ten dë, wan gaan hogihatima de ta kai Balabasi bi dë a dunguwosu. ");
INSERT INTO srmNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nöö hën Gaama bia fan ku dee hia sëmbë dee bi hai ko dë taa: “˻Wë lanti, un saanfa di guwenti fuunu dë taa mi musu lusu wan sëmbë da unu.˼ Wë nöö undi u dee sëmbë aki un kë fu mi lusu da unu: Balabasi, naa Jesosi di un ta kai di Paamusi Könu fuunu aki?” ");
INSERT INTO srmNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wë fa a hakisi di soni naandë, nöö a sabi taa dee Dju hedima bi tja Masa Jesosi ko nëën fu di de ta haun ku ën. ˻Hën wë mbei na de a hakisi di soni ma a hakisi dee sösö sinkii sëmbë.˼ ");
INSERT INTO srmNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nöö fa Gaama ta fan ku dee sëmbë dë, nöö a bi dë sindosindo a di kuutubangi fëën. Te wan pisi, hën wan sëmbë tja wan buka ko dëën taa hën mujëë taki taa an musu dë a dendu fu di kuutu u di gaan bumbuu sëmbë naandë. Biga a di ndeti dë a bi sunjan wan sunjan, nöö a dëën fuka seei gaanfa nëën hati. Sö wë di mujëë u Gaama manda taki dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nöö di juu ten Gaama ta haika di buka fëën mujëë naandë, nöö dee Gaan Begima ku dee Gaan Womi ta tuusi dee sösö sinkii sëmbë a baka ta duwengi de taa: “Un piki taa Balabasi faa lusu e! Un piki taa Balabasi un kë. Jesosi nöömö de musu kii.” Sö dee felantima u Masa Jesosi ta manda de u de taki. ");
INSERT INTO srmNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nöö hën aan soni möön. Gaama bia hakisi de taa: “Wë andi un feni fuun piki?” Nöö hën de tuu bai wööö ku wan töngö taa: “Balabasi hën u kë e! Balabasi hën i musu lusu!” ");
INSERT INTO srmNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hën a hakisi taa: “Wë andi un kë u mi du ku Jesosi di de ta kai di Paamusi Könu fuunu aki?” Hën de bai piki taa: “De musu pekëën a lakpa pau kii e!” ");
INSERT INTO srmNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nöö hën Gaama toona hakisi de taa: “Ma wë un hogi seei wë a bi du?” Hën de ta bai möön taanga nango taa: “Un pekëën nöö, un pekëën a lakpa pau kii e!” ");
INSERT INTO srmNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nöö fa de ta bai dë, nöö Gaama ta luku de diin. A si taa an sa tapa de te a heepi möönsö. Ee an piki fa de kë, nöö de o mbei toobi booko di köndë. Nöö hën a tei wata nöö hën a wasi maun te a kaba a hii dee sëmbë fesi dë. Hën a taa: “Söö, mi kaba e. Mi wasi maun puu miseei a dendu fu di buuu u di bumbuu sëmbë aki an fika a mi hedi. Soni fëën fika da unu e.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nöö hën hii dee Dju sëmbë sai naandë tuu bai taa: “Aai, be a fika a u ku dee mii fuu tuu hedi e, taa u kii ën. Wa a’ toobi!” ");
INSERT INTO srmNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nöö hën wë Gaama lusu Balabasi puu a dunguwosu da de. Hën a manda dee sodati fëën u de fon Masa Jesosi te de kaba, hën a butëën a de maun u de pekëën a lakpa pau kii. ");
INSERT INTO srmNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nöö hën dee sodati tei Masa Jesosi hën de tjëën go a di wosu u Gaama dendu. Nöö hën de bai da dee otowan u de taa: “Un ko lontu ën e!” Nöö hën hii dee sodati u di lö dë tuu ko lomboto ën gililii sö. ");
INSERT INTO srmNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hën de puu dee koosu fëën nëën sinkii di a bi bisi, hën de bisi ën wan langa djapona bëëë sö, ˻kumafa könu ta bisi˼. ");
INSERT INTO srmNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nöö hën de tei wan agbago maka hën de lolu ën te de kaba mbei kuma könu kaapusa, hën de tuusi ën nëën hedi. Nöö hën de tei wan baluma hën de butëën nëën maun kuma könu pau. Nöö hën de ta mbei ën fa ta tjökö kini a goon ta bai taa: “Wodi o, könu u dee Dju! Wodi o, könu!” ");
INSERT INTO srmNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nöö de ta tunta nëën fesi. Te wan pisi nöö hën de puu di pau nëën maun nöö hën de ta naki ën ku ën a hedi gboogboo sö sömëni pasi. ");
INSERT INTO srmNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nöö di de du ku ën sö tefa de kaba, hën de toona puu di könu djapona nëën sinkii, hën de tei dee fëën koosu toona bisi dëën baka. Nöö awaa de o tjëën go ka de o pekëën a di lakpa pau. ");
INSERT INTO srmNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nöö fa de ta tja Masa Jesosi nango dë, te wan pisi nöö hën de miti ku wan womi de kai Simon. A dë wan sëmbë u di köndë de kai Sileni, wan Afiikan köndë. Nöö fa de si ën dë, hën de duwengi ën faa tei di lakpa pau u Masa Jesosi tja dëën, biga hënseei an sa tjëën möön. ");
INSERT INTO srmNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","34","Nöö hën de nango te de go dou a di kamian de kai Golugata, hënseei da Hedibonu Kamian. Nöö hën de tei win mökisi ku bita hën de da Masa Jesosi faa bebe. Ma di a tesi ën kaa nöö an këën. Nöö hën de kandi ën a di lakpa pau a goon dë peka ku peegu tefa de kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nöö di dee sodati pekëën tefa de kaba kaa, hën de hopo ën ku di lakpa pau taanpu a pë. Nöö hën de tei dee bisi fëën dee bi dë nëën sinkii, hën de tuwë lötu luku ambë ku ambë o wini dee koosu fëën te de kaba, nöö hën de paati de puu. ");
INSERT INTO srmNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nöö di de du sö kaa te de kaba, nöö hën de sindo u de naandë ta watji Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma nöö de bi tei wan paanga hën de sikifi soni nëën te de kaba taa DISI DA JESOSI DI KÖNU U DEE DJU SËMBË, hën de pekëën leti a di lakpa pau hedi. Biga sö dee Loomë lanti bi guwenti u piki sëmbë faandi mbei de peka di sëmbë a di lakpa pau. ");
INSERT INTO srmNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nöö fa de ta kii Masa Jesosi a lakpa pau dë, nöö de ta kii tu oto sëmbë a lakpa pau tu. Wan dë nëën letimaun së, wan dë nëën töötömaun së, nöö Masa Jesosi dë a mindi. Wë de tu oto sëmbë naandë, de bi dë fufuuma ta watji sëmbë ta kisi fon u de tei soni fii tja go, nöö hën de peka de ku Masa Jesosi a di wan ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nöö fa u du dë, nöö sömëni sëmbë ta waka ta pasa a di kamian. Nöö te de si Masa Jesosi a di lakpa pau, nöö de ta kosi ën ta mbei ën fa ta seki hedi, ");
INSERT INTO srmNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ta taki taa: “Wë ju bi taa joo booko di Wosu u Masa Gadu puu nöö a dii daka dendu joo toona mbei ën baka. Sö i bi mbei taa i a’ kaakiti tjika. Wë nöö andi mbei ja sa puu i seei a di lakpa pau dë? Ee i da di Mii u Gadu tuutuu, nöö saka kumutu a di lakpa pau boo si e.” Sö de ta taki fa i si de ta pasa dë. ");
INSERT INTO srmNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nöö söseei dee Gaan Begima ku dee Sabima u Wëti ku dee Gaan Womi ta mbei ën fa ta lafu ën tu. De ta taki taa: ");
INSERT INTO srmNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Höön, wë a bi ta heepi oto sëmbë. Andi mbei an sa heepi ën seei? Jee? Ee hën da di Paamusi Könu fuu tuu, wë nöö be a saka kumutu a di lakpa pau ko a goon, nöö woo biibi ën. ");
INSERT INTO srmNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Fa a sai dë, a taa a ta buta futoou fëën a Gadu liba. Wë nöö be Gadu heepi ën biga a taa Gadu dëën tata.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nöö söseei dee hogi sëmbë dee dë pekapeka nëën bandja dë ta kosi ën ta mbei ën fa tu, fa de ku ën sai naandë. ");
INSERT INTO srmNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ma nöö fu kumutu a tuwalufu juu sonuati u tee kisi dii juu sapate, nöö hii di köndë tuu ko zuguu pii. Hii dii juu langa a tan sö dungudungu kankan. ");
INSERT INTO srmNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nöö a di dii juu ten dë, hën Masa Jesosi bai taanga ˻a di töngö fuu˼ a taa: “Eloi, Eloi, lama sabaktani?” Di dë kë taki: “Gadu e, di Gadu u mi, andi mbei i bia baka disa mi sö?” ");
INSERT INTO srmNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nöö dee sëmbë dee sai taanputaanpu naandë nöö de jei ën, ma nöö de an sabi andi a taki. Nöö hën de taa: “Dee sëmbë, un haika. Elia në wë a ta kai dë sö e, faa musu ko heepi ën.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nöö hën wan u de kule go tei wan sipönsu, hën a munjëën ku wan gandjigandji win te a kaba, hën a butëën a wan pau buka tëndë dëën faa bebe. ");
INSERT INTO srmNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma dee otowan taa: “Nönö, un tan. Un disëën boo luku ee Elia o ko heepi ën tuu.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nöö fa u mbei dë, nöö hën Masa Jesosi bai wan taanga bai möön, hën a manda di akaa fëën go awaa. A dëdë pii, böö fëën koti. ");
INSERT INTO srmNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nöö di juu dë seei, hën sömëni gaan foombo soni ko pasa. Biga di gaan degi koosu bi dë a di Wosu u Masa Gadu di bi tapa di möön hebi kamba u Masa Gaangadu fu libisëmbë an sa dou ala, hën tënë seei zalalaa kumutu a liba te kisi goon, di kamian fika jabijabi hooo. Goonliba ta seki ta bai. Gaangaan sitonu ta bai ta latja. ");
INSERT INTO srmNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nöö sömëni u dee geebi u di köndë booko jabi, nöö wanlö hia sëmbë dee bi ta biibi Gadu toona weki ko ku libi baka. ");
INSERT INTO srmNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hën de kumutu a dee geebi, ma nöö de an go a di köndë ganda u Jelusalen eti. Tefa baka di Masa Jesosi seei toona weki baka a dëdë bifö de go a Jelusalen awaa. Nöö sömëni sëmbë si de e, fa de toona weki baka dë. ");
INSERT INTO srmNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Söö. Wë nöö dee sodati ku di hedima u de, di de si fa di goonliba seki, dee gaangaan soni pasa dë, nöö hati u de latja te na soni. De taa: “Wë di soni aan soni. Di sëmbë aki, a bi musu dë Miii u Masa Gaangadu tuutuu.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nöö hii fa i si de bi ta du ku Masa Jesosi naandë, nöö wanlö mujëë bi dë taanputaanpu te a longi ala ta luku. Dee mujëë naandë, fu sensi a di ten di Masa Jesosi bi seti di wooko fëën a Galilea, nöö de bi ta sölugu fëën nöömö. ");
INSERT INTO srmNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wan u de da Malia u Magidala, di otowan da Malia di mama u Jakobosi ku Josëfu, ku di mama u de tu womi mii u Zebedeosi. Sö de bi dë te ala ta luku andi de ta du ku Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nöö hën u dë tefa sapate buka. Nöö wan guduma de kai Josëfu bi dë a Jelusalen dë, nöö di köndë de kai Alimatea hën da köndë fëën. Nöö hënseei bi dë wan sëmbë ta biibi a Masa Jesosi tu. ");
INSERT INTO srmNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nöö di a si taa Masa Jesosi dëdë, hën a go a Gaama Pilati go hakisi ën pasi faa go tei di dëdë sinkii fëën tja go bei. Hën Gaama taa antoobi, hën a manda sodati fu de puu ën a di lakpa pau dëën. ");
INSERT INTO srmNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nöö hën Josëfu tei di dëdë, hën a lolu ën a wan gaan langa weti koosu tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nöö a bi abi wan sitonu baaku di de bi seeka njunjun u bei sëmbë, nöö hën a tja di dëdë go buta a di baaku dë dendu. Hën de logoda wan gaan gindi sitonu tuwë ko tapa di baaku buka te de kaba, nöö hën de go. ");
INSERT INTO srmNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nöö fa de ta du dë, nöö Malia fu Magidala ku di oto Malia bi dë leti dë sindosindo a di oto së u di geebi ala ta luku. ");
INSERT INTO srmNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nöö di juu dë, di daka de ta seeka da di saba pasa kaa. Ma hii fu di dë, dee Gaan Begima ku dee Faliseima, hën wë de go a Gaama gbolo. ");
INSERT INTO srmNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Hën de kai ën: “Köndë Masa.” A piki. De taa: “Wë u ko a unu aki. U ko taki wan oto ku unu taa di ten di di bödjëëma naandë bi dë ku libi, nöö a ta taki kodo taa te a dëdë nöö a di u dii daka fëën nöö a o toona weki ko ku libi baka. Sö a bi ta taki e. ");
INSERT INTO srmNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","“Wë nöö u kë begi Gaama fuun buta sëmbë a di geebi be de watji ën dii daka longi fu sëmbë an musu ko dë. Biga ee wan du sö, nöö dee bakama fëën o go fufuu di sinkii fëën tja go, nöö de o go ta ganjan sëmbë taa a weki baka a dëdë. Nöö di lö ganjan dë o hogi möön leki fa de bi ta ganjan sëmbë a fesi e. Nöö hën wë tja u ko a Gaama aki, u ko begi ën faa musu heepi u a di lö pisi dë.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nöö hën Gaama taa: “Wë un go tei wanlö sodati tja go buta, nöö un seeka di geebi tapa kumafa un sa tapëën.” ");
INSERT INTO srmNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nöö di a da de pasi sö, nöö hën de go tapa di geebi tee de kaba naki sitampu nëën fu sëmbë an ko dë. Hën de tei sodati buta a di kamian ta watji da de, nöö hën de go u de. ");
INSERT INTO srmNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wë nöö hën u dë teefa di saba daka pasa. Nöö di oto daka di o ko dë möön, hën da di fosu daka u di wiki. ˻Hën da sonde.˼ Hën di daka dë, hën Malia fu Magidala ku di oto Malia hopo hën de tei pasi nango a di geebi ka de bi bei Masa Jesosi. Nöö di juu dë, sonu seti kumutu kaa. ");
INSERT INTO srmNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wë nöö wan gaan soni bi pasa a di ndeti dë. Goonliba bi seki tee na soni, hën wan basia u Masa Gadu Köndë kumutu a liba ala bazia ko a di geebi ka de bi bei Masa Jesosi. Nöö hën a puu di gaan gindi sitonu di de bi tapa di baaku buka, hën a go sindo leti a di sitonu dë liba. ");
INSERT INTO srmNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nöö fa a sai naandë, fesi fëën ta sëndë teee kuma te gaangadu koti faja, nöö dee koosu fëën sinkii dë wetiweti faan. ");
INSERT INTO srmNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nöö hën dee sodati dee bi sai dë ta watji di geebi, di de si di soni pasa sö kaa, nöö hën de fëëë tee de ta tëëmë tjatjatja tombi kai a goon gbolou dë pii kuma de dëdë. Sö de panta tjika. ");
INSERT INTO srmNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wë nöö hën de tu mujëë waka go dou a di geebi. Nöö di de si di basia fu Gadu dë, hën de fëëë te na soni. Nöö hën a kai de taa: “Dee mujëë aki.” De piki. A taa: “Wan fëëë sö e. Mi sabi ambë un ta suku kaa. Jesosi di de kii a di lakpa pau, hën wë un ta suku. ");
INSERT INTO srmNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wë an dë aki möön e. A weki baka leti kumafa i si a bi taki da unu ufö a dëdë. Un ko luku di kamian ka de bi butëën. Wan si ö? Sëmbë an sai dë möön. A go. ");
INSERT INTO srmNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“Nöö mi taki e, un bia toona, nöö un kule go a dee bakama fëën go piki de taa a weki baka a dëdë nöö a o waka a de fesi go a Galilea. Ala de ku ën o miti kumafa a bi taki. Un jei bunu fa mi taki da unu ö? Mi fan ku unu kaa e.” ");
INSERT INTO srmNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nöö hën dee mujëë toona kumutu dë. De ta panta möönsö ma etiseei de ta wai. Hën de ta kule nango u de tja di bunu buka dë go konda da u dee bakama u Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma nöö fa de nango dë, te u de kë mëni, hën de ku Masa Jesosi seei miti a pasi. Hën Masa Jesosi da de odi taa: “Dee mujëë aki, un weki nö?” Nöö di sondi bigi da de teee. Hën de saka tjökö kini a goon nëën fesi, hën de ta kisi ën a futu dë ta baasa. ");
INSERT INTO srmNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma nöö hën Masa Jesosi taki da de taa: “Dee mujëë, wan fëëë e. Un go taki da dee otowan u mi taa be de go a Galilea, nöö ala mi ku de o miti kumafa mi bi taki da de.” ");
INSERT INTO srmNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wë nöö di juu dë, so u dee sodati kumutu ka de bi ta watji di geebi naandë, hën de kule go a ganda go a dee Gaan Begima. Hën de go konda da de kumafa hii soni bi pasa ka de bi ta watji a di geebi ala. ");
INSERT INTO srmNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Nöö di dee begima jei sö kaa, nöö hën de kai dee Gaan Womi tuu ko a de. Hën de go sindo a kuutu fu de taki ee andi de sa feni fu di soni di pasa naandë. Nöö di de kuutu tefa de kaba, hën de toona kai dee sodati ko a de möön, hën de taki da de taa: “Wë un haika e. Woo paka unu wan gaan möni aki, nöö wan musu konda taa weki di womi weki e. Ma un musu piki sëmbë taa un bi duumi, nöö hën dee bakama fëën ko fufuu ën tei tja go. Sö un musu taki. Nöö wan musu fëëë e. ");
INSERT INTO srmNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Biga ee di taki dë dou a di Gaama jesi, nöö woo heepi unu fan ku ën tee nöö hati fëën o kötö.” ");
INSERT INTO srmNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nöö hën wë dee watjima tei di möni naandë, nöö hën de ta konda leti kumafa dee hedima manda de. Nöö fa de ta taki ën dë, nöö sö nöö dee Dju sëmbë ta kondëën te kisi fa u dë aki eti. ");
INSERT INTO srmNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nöö hën wë dee mujëë ko dou a u dee ëlufu bakama u Masa Jesosi, hën de da u di buka te de kaba. Nöö di u jei sö nöö aan soni möön, hën wë u go a Galilea. Hën u nango tefa u go dou a di kuun ka Masa Jesosi bi taki da u a fesi fuu go, nöö hën u go si ën ala. ");
INSERT INTO srmNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nöö di u si ën, hën u tjökö kini a goon nëën fesi ta bigi ën. Ma nöö so fuu an saandi seei fuu pakisei, a bigi da u poi. ");
INSERT INTO srmNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nöö hën Masa Jesosi waka ko a u awaa, hën a taki da u taa: “Söö, wë dee sëmbë, un haika e. Mi kisi hii makiti a liba ala ku goon aki tuu. ");
INSERT INTO srmNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nöö un musu ta waka a dee köndëköndë u goonliba ta paaja di buka u mi da hii sëmbë, be de bia ko dë bakama u mi kuma unu. Nöö un musu dopu de a di në u mi Tata ku di në u mi di Mii fëën aki ku di në u di Akaa fu mi Tata tu. ");
INSERT INTO srmNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nöö un musu ta lei de u de piki hii dee soni tuu dee mi manda unu fuun musu ta du kaa. Nöö fa woon nango dë, nöö mi taki da unu taa mi o dë ku unu hiniwanten e, u tee a kaba u di goonliba aki.” Sö wë Masa Jesosi fan ku u dee bakama fëën a di kuun liba ala e. A kaba.");
INSERT INTO srmNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Söö dee sëmbë, leti kumafa woo taki aki, nöö sö nöö di Bunu Buka u Masa Jesosi di Paamusi Könu seti e. Jesosi Keesitu hën da di Mii u Masa Gaangadu seei, nöö di pampia aki o lei i fa a dë. ");
INSERT INTO srmNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nöö a bi ko pasa leti kumafa di sëmbë de kai Jesaaja bi sikifi buta a di Buku u Gadu. Biga Jesaaja bi dë wan tjabukama u Gadu u fesiten, hën a sikifi wan soni u di Könu Gadu bi paamusi taa a o manda ko a dee Dju sëmbë. A taa, Gadu o manda wan sëmbë waka a di Paamusi Könu dë fesi faa musu buta sëmbë a pasi dëën. ");
INSERT INTO srmNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nöö di sëmbë dë o dë a di sabana dendu ta bai basia ta taki taa: Un seeka di pasi da Masa ooo, be a dë limbolimbo gbegedee dëën. Un seeka dee bendibendi pisi u di pasi, be de ko dë tololoo. Sö Jesaaja bi sikifi taa sö wan sëmbë o ko sai dë ta bai. ");
INSERT INTO srmNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Wë nöö da sö a ko pasa tuu leti kumafa Gadu bi taki dë e. Biga wan womi de kai Johanisi di Dopuma, hën Gadu manda ko. Nöö fa a ko naandë, nöö a ta libi a di sabana dendu u di pisiwata de kai Judea. Naandë a ta bai di basia ta dopu sëmbë. Nöö sömëni sëmbë ta ko nëën nöömö, nöö a ta bai ta taki: “Un bia disa di hogilibi fuunu oo, nöö unu ku Masa Gaangadu o ko bunu. Gaangadu an o hoi dee hogi du fuunu a bëë möön.” Sö a ta bai ta taki. ");
INSERT INTO srmNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nöö hii dee sëmbë u di pisiwata u Judea naandë, ku di mama köndë fëën de kai Jelusalen, nöö de tuu ta ko a Johanisi naandë ta ko ta haika fa a ta bai di basia. Nöö hën de ko ta piki taa: “Awa, wa ta libi bunu tuu.” Nöö te wan sëmbë i piki sö kaa, nöö Johanisi ta dopu i a di lio de kai Joodan dë. ");
INSERT INTO srmNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Söö. Wë nöö di koosu fu Johanisi di a ta bisi nëën sinkii, a mbei ku di puuma u di mbeti de ta kai kamëli. Atiti ku höniwata da sondi u njan fëën. Sö wan sëmbë a bi dë e. ");
INSERT INTO srmNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Nöö Johanisi toona ta fan ku dee sëmbë. A taa: “Un haika e, dee sëmbë. Wan oto Sëmbë o ko a mi baka nöö a hebi möön mi gaanfa e. Ma bumbuu tjika seei u sa bendi lusu di susu fëën puu nëën futu. Fa mii dë aki, mi ta dopu unu ku wata, ma di Sëmbë di o ko dë, nöö hën a o dopu unu ku di Akaa u Masa Gaangadu. ˻Biga a o mandëën ko a unu liba.˼” ");
INSERT INTO srmNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wë nöö di juu dë, hën Masa Jesosi kumutu a di köndë de kai Nazalëti u di pisiwata de kai Galilea, nöö hën a ko a Joodan Lio naandë fu Johanisi musu dopu ën. Nöö hën Johanisi dopu ën te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nöö fa Masa Jesosi ta kumutu a di wata dendu ta ko a tela, nöö hën a luku nëën liba ala hën a si liba jabi hooo. Nöö hën a si di Akaa u Gadu kuma wan pomba bazia ko nëën liba. ");
INSERT INTO srmNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nöö hën wan töngö piki a liba ala taa: “I da mi lobi Womi Mii. Libi fii ta kai ku mi e.” Sö wan soni pasa di Masa Jesosi dopu. ");
INSERT INTO srmNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Söö. Wë nöö a baka u di dë, nöö hën di Akaa u Gadu tja Masa Jesosi go a wan sabana kamian. ");
INSERT INTO srmNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nöö hën a go dë ala hii föteni daka. Nöö a dee föteni daka dendu dë, nöö di didibi ta mbei möiti ku ën nöömö faa musu piki ën buka a soni, ma nöö Masa Jesosi an du kumafa a kë möönsö. Nöö fa Masa Jesosi dë a di sabana dee hia daka naandë, nöö dee mbeti u di sabana bi sai dë tu, ma dee basia u Gadu Köndë bi dë ku ën ta tjubi ën. ");
INSERT INTO srmNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hën de dë te wan daka, nöö hën de kisi Johanisi di Dopuma söötö a dunguwosu. Nöö baka u di dë, hën Masa Jesosi toona go a Galilea, nöö hën a seti ta waka ta lontu ta konda di Bunu Buka u Gadu da dee sëmbë u di pisiwata dë. ");
INSERT INTO srmNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A ta taki da de taa: “Di juu ko zuntu e, u Masa Gadu musu tii unu a wan njunjun fasi. Nöö ee wan sëmbë i kë ko a di Njunjun Tii u Gadu dendu, nöö i musu bia disa di hogilibi fii, nöö i piki di Bunu Buka u Gadu di mi ta konda aki.” Sö Masa Jesosi ta taki da de. ");
INSERT INTO srmNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nöö wan piki ze bi dë a di pisiwata u Galilea naandë. Te wan daka nöö hën Masa Jesosi go ta waka a di ze dë bandja, nöö hën a ko miti ku tu womi. Dee womi aki dë baaa ku baaa. Wan de kai Simon, ˻hënseei de ko ta kai Petuisi˼. Di otowan da Andiasi. De dë ta tuwë nëti u de kisi fisi biga hën da wooko u de de ta du. ");
INSERT INTO srmNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nöö hën Masa Jesosi kai de tu baaa dë te de piki. A taa: “Un ko dë ku mi ta waka a mi baka e, nöö mi o lei unu fuun kisi libisëmbë ˻tja ko a mi së˼.” ");
INSERT INTO srmNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nöö wantewante naandë, hën de tu womi disa dee nëti u de hën de go ta waka a Masa Jesosi baka. ");
INSERT INTO srmNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","20","Nöö hën Masa Jesosi waka go möön longi, nöö hën a ko si tu oto baaa möön. De seei dë höndima tu ta kisi fisi. Nöö fa Masa Jesosi ta pasa dë, nöö de bi dë ku de tata a boto ta seeka wanlö nëti u de. Wan u dee baaa de ta kai Johanisi, di otowan da Jakobosi, nöö di tata u de hën de kai Zebedeosi. Nöö di Masa Jesosi si de tu baaa dë, hën a kai de taa: “Un ko go ku mi e.” Nöö hën wante dë, hën de disa de tata ku dee wookoma u de naandë, nöö hën de go ta waka a Masa Jesosi baka. ");
INSERT INTO srmNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nöö hën Masa Jesosi kumutu naandë, hën ku dee bakama fëën, hën de go a wan u dee köndë u Galilea de ta kai Kapenaumi. Nöö hën de dë te di saba daka, hën Masa Jesosi go a di keikiwosu u di köndë go ta lei dee sëmbë dee bi ko dë di lei fëën. ");
INSERT INTO srmNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nöö fa a ta lei de naandë, a bigi da hii sëmbë tee na sondi. Biga an ta lei de kumafa dee Sabima u Wëti bi guwenti u lei de Gadu wöutu, ma a ta lei de seei a wan apaiti fasi kuma hënseei abi di lei. ");
INSERT INTO srmNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wë nöö di daka dë gbolo, wan womi bi dë a di keikiwosu naandë, a dë ku wan soni nëën liba. Nöö hën wë a bai ko a hedi ko ta fan. A taa: ");
INSERT INTO srmNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesosi u Nazalëti, andi seei u ku i abi? I ko aki fii kaba u a sösö nö? Wë mi sabi ambë da i. I wë da di apaiti Sëmbë u Gadu di a manda ko a di goonliba aki.” ");
INSERT INTO srmNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nöö hën Masa Jesosi bai ën taa: “Kabuka naandë! Kumutu a di sëmbë liba wante.” ");
INSERT INTO srmNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nöö fa a fan dë, hën di soni ko möön taanga a di sëmbë liba te hii sinkii fëën ta tëëmë tjatjatjatja. Hën a bai taanga bifö a kumutu nëën awaa. ");
INSERT INTO srmNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wë nöö fa di soni pasa naandë, a ko foondo dee sëmbë tumisi. Hën de ko ta taki da de na de taa: “Dee sëmbë, andi u ta si aki? Njunjun lei ko a u nö? Di sëmbë aki abi taki a dee soni ta kisi sëmbë a hedi liba tee de ta piki hën buka a sondi seei.” ");
INSERT INTO srmNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nöö hën di soni Masa Jesosi du naandë paaja a hii dee köndëköndë u Galilea tuu paliii dou. Sö a bigi da sëmbë tjika. ");
INSERT INTO srmNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nöö hën Masa Jesosi kumutu a di keikiwosu naandë, hën ku Jakobosi ku Johanisi, nöö hën de go a di wosu u Simon ku ën baaa Andiasi. ");
INSERT INTO srmNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Di juu dë di mai u Simon bi dë ku gaan fëbë. A dë leti a bedi naandë. Hën de kondëën da Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nöö hën wë Masa Jesosi go a di mama, hën a panjëën a maun hopo ën sindo. Nöö hën wantewante di fëbë go, a ko bunu seei te a hopo seeka soni da de. ");
INSERT INTO srmNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nöö hën de dë tefa sonu go, hën dee sëmbë u di köndë tja sëmbë te a hia ko a Masa Jesosi naandë. Dee sëmbë de tja ko dë, de dë ku peipei siki ufö i abi dee sëmbë dee dë ku soni a hedi. ");
INSERT INTO srmNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Hii sëmbë u di köndë tuu fiaa hai ko a di dööbuka naandë, ");
INSERT INTO srmNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","nöö hën Masa Jesosi kula hii dee sëmbë ku dee peipei siki naandë te a kaba. Söseei a jaka dee soni ta kisi sëmbë a hedi. An da de pasi u de fan möönsö, biga an kë u de konda ambë dëën. ");
INSERT INTO srmNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nöö hën di mamate biten, ganian an kanda seei, nöö hën Masa Jesosi hopo. Hën a kumutu a di köndë ganda go dë a wan kamian piii hën wanwan ta begi Masa Gaangadu. ");
INSERT INTO srmNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Te wan pisi hën Simon ku dee otowan fëën ko hopo, de an si Masa Jesosi a wosu dë, hën de go ta suku ën te fa de ko si ën. ");
INSERT INTO srmNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nöö hën de hakisi ën taa: “Andi pasa? Dee sëmbë ta hakisi fa fii poi.” ");
INSERT INTO srmNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nöö hën Masa Jesosi piki de taa: “Nönö, na soni. Ma un boo go a dee oto köndë ala tu e, go tja di Bunu Buka u Gadu go paaja. Biga wë hën mbei mi ko a goonliba.” ");
INSERT INTO srmNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nöö hën de kumutu ala, hën de ta waka a dee köndëköndë u Galilea tuu. Fa de ta waka dë, nöö Masa Jesosi ta konda di Bunu Buka u Gadu da dee sëmbë a hii dee keikiwosu u dee Dju sëmbë. Nöö a ta jaka dee soni ta kisi sëmbë a hedi ta puu a de liba. ");
INSERT INTO srmNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hën de dë te wan daka, nöö hën wan sëmbë dë ku tjinasiki ko a Masa Jesosi. Nöö hën a tjökö kini a goon nëën fesi begi ën taa: “Ee, Masa o, mi sabi taa ee i kë i sa kula mi o.” ");
INSERT INTO srmNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nöö hën tjali u di sëmbë kisi Masa Jesosi, nöö hën a tëndë maun panjëën. Hën a taa: “Aai mati, mi kë e. Be i ko bunu wante!” ");
INSERT INTO srmNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nöö fa a fan dë, hën di sëmbë ko bunu wantewante naandë, di tjinasiki an dë u si nëën sinkii möön seei. ");
INSERT INTO srmNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nöö hën Masa Jesosi mandëën taa be a go. Ma nöö a bai ën tu taa: “Na konda di sondi pasa ku i aki da sëmbë e! Ma waka tololo go a di begima di ta dë a di keikiwosu, be a si taa i ko bunu. Nöö i tja di paima go tuwë da Gadu kumafa Mosesi bi taki.” ˻Biga gaanduwe Gadu bi da wan tiima u dee Dju sëmbë de kai Mosesi dee wëti fëën. A taa te wan sëmbë i ko bunu u sö wan siki, nöö i musu tja paima go da Gadu bifö i sa toona go a wosu baka.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma nöö fa di sëmbë kumutu naandë, an tapëën buka möönsö. Ma a go ta paaja di taki naandë te dou hii di köndë, te Masa Jesosi an bi sa ko a dee köndë ganda möön u sëmbë si ën. Nöö hën a fika a döösë ka sëmbë an ta dë hia, ma töku sëmbë ta kumutu a hii së nango nëën ala eti. ");
INSERT INTO srmNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Baka wan tu daka sö, hën Masa Jesosi toona go a Kapenaumi. Nöö an dou seei, hën di njunsu paaja taa sö wan soni, Masa Jesosi toona ko nëën wosu. ");
INSERT INTO srmNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nöö hën dee sëmbë u di köndë booko gulululu ko fuu di kamian naandë pöö te kamian an dë u denda go a wosu dendu möön seei. ");
INSERT INTO srmNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Di juu dë, Masa Jesosi dë a di wosu dendu ta konda di Buka u Gadu da dee sëmbë. Te wan pisi hën fö womi ko dou ku wan lanlan sëmbë di de ta tja a wan kama liba ko dëën faa kula. ");
INSERT INTO srmNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma nöö fa sëmbë hia a di kamian tjika dë, nöö de fö womi an sa feni pasi u pasa go dou a Masa Jesosi. Nöö hën de subi a wan sikada go a di wosuliba. ˻Biga dee wosuliba u di köndë bi dë paatapaata.˼ Nöö hën de fula wan baaku leti a Masa Jesosi liba dë, hën de saka di womi a di kama liba zëngëë ku tatai te go buta leti a Masa Jesosi fesi a goon dë. ");
INSERT INTO srmNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nöö hën di Masa Jesosi si fa dee womi ta biibi ën tjika te de mbei sö wan gaan möiti, nöö hën a taki da di lan womi taa: “Na fëëë, womi. Mi da i paadon u dee hogi dee i bi du. Masa Gadu an ta hoi i a bëë möön e!” ");
INSERT INTO srmNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma nöö wanlö Sabima u Wëti bi dë sindosindo leti naandë ta haika soni. Nöö di fa Masa Jesosi fan dë an bunu a de seei, kwetikweti. Nöö hën de ta guunjëën a de hati taa: ");
INSERT INTO srmNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Unfa di womi dë sa a’ hati u taki sö wan gaan soni? Na sösö a ta sösö Masa Gadu nö? Biga ambë sa puu sëmbë a Gadu bëë boiti Masa Gadu seei nöö?” ");
INSERT INTO srmNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma nöö Masa Jesosi sabi taa sö de ta pakisei, nöö hën a hakisi de taa: “Dee sëmbë o, unfa un ta mëni hogi u mi a unu hati sö? ");
INSERT INTO srmNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wë mi hakisi unu e, taa ee fii taki da sö wan sëmbë taa Gadu puu ën a bëë, ee nasö fii taki dëën taa, be a hopo waka go, nöö undi u de tu soni dë sa möön fukë u taki ku buka? ˻Na di fosu wan nö? Biga sëmbë an sa go a Gadu go hakisi ën ee a puu di sëmbë a bëë tuu.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“Ma nöö un luku. Mi o lei unu taa Mi di ko Libisëmbë Mii aki, na fan nöö mi sa fan, ma mi abi makiti tu a di goonliba aki fu mi sa puu sëmbë a Gadu bëë.” ");
INSERT INTO srmNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nöö hën a bia fan ku di womi taa: “Mati, hopo taanpu! Tei i kama nöö i go fii a wosu!” ");
INSERT INTO srmNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nöö fa a fan dë, hën di womi hopo vu taanpu a pë a dee hia sëmbë fesi naandë, nöö hën a tei ën kama hën a waka go fëën a wosu. Nöö di soni naandë bigi da hii sëmbë tee de ko ta gafa Gadu taa: “Hoo, wa si sö wan gaan sondi wan daka.” ");
INSERT INTO srmNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nöö hën Masa Jesosi kumutu hën a go a di piki ze u Galilea bandja. Nöö sëmbë ta ko nëën naandë te a hia, nöö a ta da de di lei fëën. ");
INSERT INTO srmNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nöö hën a ta waka nango. Te wan pisi, hën a si wan womi de kai Leifi. ˻Hën seei da Mateosi.˼ A dë fëën sindosindo a wan piki wosu a bandja pasi dë ta pii lantimöni, biga hën da wooko fëën kaa. Nöö di Leifi aki, wan womi de kai Alufasi hën pai ën. Nöö di Masa Jesosi si ën, hën a kai ën faa musu ko bakama fëën. Nöö wantewante hën Leifi hopo ko ta waka nëën baka. ");
INSERT INTO srmNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wë nöö a ko pasa sö taa Leifi kai Masa Jesosi ku dee bakama fëën fu de musu ko njan ku ën nëën wosu. Nöö hën de go sindo u de njan. Nöö sömëni u dee pii-lanti-mönima ku sömëni oto sëmbë dee abi poi në a di köndë, nöö sö de ko dë ta njan ku de a wan tafa makandi. Biga hia u dee lö pei sëmbë naandë bi ta waka a Masa Jesosi baka kaa. ");
INSERT INTO srmNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te wan pisi nöö hën wë dee Sabima u Wëti ko ta pasa naandë gbolo, dee u di Dju paatëi de kai Falisei. Nöö hën de ko si Masa Jesosi dë sindosindo ku dee pii-lanti-mönima ku dee oto nëpoima u di köndë dë ta njan makandi, nöö di sondi an bunu a de seei, kwetikweti. Nöö hën de hakisi dee bakama u Masa Jesosi taa: “Faandi mbei di mësitë fuunu go dë ta njan ku dee lö pei sëmbë naandë a wan tafa u du?” ");
INSERT INTO srmNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nöö di Masa Jesosi jei di hakisi u de, nöö hën a piki de a nöngö taa: “Dee sëmbë o, unfa un mëni? Wan sëmbë di siki ku wan sëmbë di dë bumbuu, undi u de abi data fanöudu? Na di sikima nö? Wë nöö ma ko u kai dee sëmbë dee dë bumbuu sëmbë kaa e, ma mi ko u kai dee sëmbë dee an ta libi bunu a Gadu wojo, fu mi heepi de.” Nöö sö a piki de. ");
INSERT INTO srmNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hën de dë te wan pisi. Nöö di juu dë, dee bakama u Johanisi di Dopuma ku dee u dee Faliseima ta hoi deseei söndö njan. Biga sö dee Dju sëmbë abi wan guwenti taa so juu de ta tja hangi u wan pisiten fu begi hedi. Nöö hën wan tu sëmbë ko a Masa Jesosi, hën de hakisi ën taa: “Faandi mbei dee bakama u Johanisi ku dee u dee Faliseima ta tja hangi fu begi hedi, ma i ku dee bakama fii wan ta du sö?” ");
INSERT INTO srmNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nöö hën Masa Jesosi piki de a wan nöngö fasi, a taa: “Fa u dë aki, ee wan sëmbë o tööu, nöö a o kai sömëni sëmbë ko a di piizii, na sö nö? Wë nöö solanga di tööuma dë ku de naandë, nöö de an sa ta kusumi ta tja hangi. Wai nöö de o ta wai. ");
INSERT INTO srmNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma te di juu dou de ko puu ën a de mindi bifö de o sa ta kusumi ta tja hangi awaa.” ");
INSERT INTO srmNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nöö hën a taa: “˻Fa mi ta fan ku unu aki, ma a sa toobi unu fu un tei.˼ Biga na wan sëmbë o tei wan njunjun koosu pisi u lapu wan awoo koosu. Biga te i wasi ën nöö di njunjun pisi o hai kumutu disa di awoo wan, nöö di baaku o ko möön bigi möön leki fa a bi dë kaa. ");
INSERT INTO srmNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Söseei tu, ja sa tei wan njunjun win lai a wan awoo mbeti kakisa saku. Biga di awoo saku gaandi kaa, an ta hai möön. Nöö ee i lai di njunjun win go nëën dendu, nöö te di win soopu nöö di saku o tënë tuwë di win fiaa. Da a ko dë i lasi di win fii ku di saku tuu. “Ma nöö i musu tei wan njunjun saku nöö i lai di njunjun win nëën, nöö de tuu o dë bunu kumafa a fiti.” ");
INSERT INTO srmNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nöö hën de dë te wan saba daka, nöö hën wë Masa Jesosi ku dee bakama fëën ta latja ta pasa a wan goon dendu. Di goon naandë, de paandi wan pei soni kuma alisi nëën, ma i sa njan mën kuakua. Nöö hën wë dee bakama ta booko dee taka dee bendi ko a di pasi naandë ta gili a maun ta njan. ");
INSERT INTO srmNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Di juu dë wanlö sëmbë u di Faliseima kulupu si de, hën de ko hakisi Masa Jesosi taa: “Fa dee bakama fii ta du dë, na Gadu wëti de ta poi nö? Biga de ta wooko a saba daka.” ");
INSERT INTO srmNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Nöö hën a piki de taa: “Wan bi lesi a Gadu buku nö, di soni bi pasa ku Dafiti a di ten u di Kaba Hei Begima de kai Abiata? Hangi bi ta kii hën ku dee mati fëën, nöö hën a go a di wosu u Gadu, hën dee begima da de di bëëë di de ta buta da Gadu naandë. Nöö hën Dafiti njan mën, hën ku dee mati fëën tuu. Wë nöö di bëëë naandë, dee begima wanwan nöö bi a’ pasi u njan mën, na sö nö? ˻Ma tökuseei Gadu an tei Dafiti ku dee sëmbë fëën fu hogi di de njan mën o.˼” ");
INSERT INTO srmNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nöö hën a taki da de taa: “Haika e, dee sëmbë. Masa Gaangadu an mbei libisëmbë fu de hoi saba tjina hedi e, ma a mbei di saba faa heepi libisëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nöö mi taki da unu, taa Mi di i si ko Libisëmbë Mii aki, nöö mi dë Masa a hii soni liba e te dou ku di saba tuu.” Sö wan soni Masa Jesosi taki da dee Faliseima a di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wë nöö a wan oto saba möön, hën Masa Jesosi toona go a di keikiwosu. Nöö di a go dou, nöö wan womi sai naandë, wan së maun fëën dë dëëdëë tjakaa. ");
INSERT INTO srmNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma nöö sëmbë dë leti dë ta watji Masa Jesosi ee a o kula di womi a di saba daka naandë, biga de kë feni föutu nëën u de tjëën go kaagi. ");
INSERT INTO srmNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nöö hën wë aan soni. Hën Masa Jesosi taki da di womi di dë ku di dëëdëë maun naandë taa be a hopo taanpu a dee hia sëmbë fesi dë. Nöö hën a hopo taanpu. ");
INSERT INTO srmNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nöö hën Masa Jesosi bia hakisi dee sëmbë dee sai naandë taa: “Unfa Gadu Buku taki, dee sëmbë? Undi möön bunu? Fii du bunu a saba, naa fii du hogi? Fii musu puu sëmbë a dëdë buka, naa fii disëën faa dëdë? Unfa Gadu wëti sikifi fëën?” Ma nöö fa a hakisi de naandë, na wan sëmbë piki ën möönsö, de tuu ko dë pii. ");
INSERT INTO srmNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nöö hën a luku de ku hatiboonu. Ma nöö a hati ën tu, fu di de abi sö wan taangajesi da Gadu te tjali u sëmbë an ta kisi de möönsö. Nöö hën a bia fan ku di womi taa: “Mati, tëndë di maun fii i si.” Nöö hën di womi tëndëën maun, nöö hën wantewante di maun ko bunu leti kumafa a bi musu dë. ");
INSERT INTO srmNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nöö hën wë dee Faliseima kumutu dë, hën de waka go langalanga tee a di kulupu u di Könu u di köndë, hën da Helodi. Nöö hën de ko ta kuutu makandi unfa u de du de kisi Masa Jesosi kii. ˻Sö di soni Masa Jesosi du dë hati de tjika.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Wë nöö wan daka möön, hën Masa Jesosi ku dee bakama fëën hën de go a di piki ze u Galilea bandja. ");
INSERT INTO srmNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nöö fa de ko dou dë, hën wanlö hia sëmbë hai ko nëën gidjii, dee sëmbë u Jelusalen ku hii dee oto köndë u Judea, ku dee u di pisiwata de kai Idumea, ku dee sëmbë dee ta dë a di oto së banda u Joodan Lio, ku dee u dee köndëköndë u dee pisiwata de kai Tilusi ku Sidon. Sö dee sëmbë hai ko a Masa Jesosi tjika, biga de bi jei u dee foondo wooko a ta du. ");
INSERT INTO srmNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nöö di de ko hia sö kaa, nöö hën Masa Jesosi taki da dee bakama fëën taa be de seeka wan boto buta a bandja wata naandë dëën. Biga fa a ta kula sëmbë dë, nöö awaa seei de ta pusa ta ko nëën liba. ");
INSERT INTO srmNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Biga de ta si taa ee de nama nëën, nöö de sa ko bunu nöömö. ");
INSERT INTO srmNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Di juu dë, dee sëmbë dë ku soni a hedi, te de ko dou a Masa Jesosi nöö de ta bai kai olo seei kai a goon. Nöö de ta taki dëën taa: “˻U sabi ambë da i e!˼ I da di Mii u Masa Gaangadu.” ");
INSERT INTO srmNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma nöö hiniwanten te de taki sö kaa, nöö Masa Jesosi ta gandji da de taa de an musu taki di soni dë. ");
INSERT INTO srmNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wë nöö te wan pisi hën Masa Jesosi go a wan kamian ka wanlö hia kuun dë, nöö hën a kai sömëni sëmbë u de ko nëën. ");
INSERT INTO srmNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nöö hën a pii tuwalufu womi a de dendu tei u de fika ku ën ta lei nëën nöömö, nöö de de kai “apösutu”. Nöö a o manda de go a köndëköndë u de paaja di Bunu Buka u Gadu, ");
INSERT INTO srmNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nöö a o da de makiti tu u de ta jaka dee gadu ta kisi sëmbë a hedi puu a de liba. ");
INSERT INTO srmNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Söö. Wë nöö dee në u de tuwalufu womi dee a tei dë, nöö di fosu wan hën da Simon, hën Masa Jesosi ta kai Petuisi. ");
INSERT INTO srmNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nöö joo kisi Jakobosi ku ën baaa Johanisi, de da de tu womi mii u di womi de kai Zebedeosi. Nöö Masa Jesosi da de wan në, a ta kai de Boanëgësi, nöö di në dë hën kë taki “Mii u Döndö”, ˻biga sö de tu baaa fasi bi dë˼. ");
INSERT INTO srmNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nöö baka u dee baaa dë, nöö joo kisi Andiasi, Filipi, Batolomisi, Mateosi, Tomasi ku wan oto Jakobosi. Hën tata da Alufasi. Nöö joo kisi Tadeosi ku wan oto Simon, nöö di womi aki, hën bi dë a di paatëi u dee sëmbë dee ta suku u puu Loomë lanti a de liba. ");
INSERT INTO srmNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ufö joo kisi Judasi Isikaliotu, hën o sei Masa Jesosi buta a dee felantima maun. Nöö sö wanlö sëmbë Masa Jesosi tei u de dë ku ën makandi e. ");
INSERT INTO srmNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te wan daka möön hën Masa Jesosi go dë a wan wosu, nöö hën sëmbë booko ko nëën naandë tee hën ku dee bakama fëën an sa fendi pasi u njan seei. ");
INSERT INTO srmNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Te wan pisi hën dee mama bëë fëën ko jei taa sö ta pasa, hën de taa de o ko tei ën tja go. Biga de ta si kuma tja sondi kamian fëën an dë bunu möön. ");
INSERT INTO srmNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nöö di juu dë, wanlö Sabima u Wëti u Jelusalen bi dë a Masa Jesosi naandë, hën di de si andi ta pasa hën de taa: “Wë di sondi aki an dë u taki oto fasi möönsö e. Hën di gaan hedima u dee didibi de kai Belisabo hën wë kisi ën a hedi sö. Hën ta dëën di taanga faa ta jaka dee gadu puu a dee sëmbë liba.” ");
INSERT INTO srmNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nöö Masa Jesosi ˻sabi taa sö de ta taki, hën a˼ kai de ko, hën a taki da de taa: “Dee sëmbë, unfa di didibi sa jaka dee otowan fëën puu a wan kamian? A sa booko di tii fëën seei sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Biga ee dee sëmbë u wan köndë hopo feti ku deseei, nöö na booko di köndë dë o booko nö? ");
INSERT INTO srmNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Söseei ee wan bëë hopo ta feti ku deseei, nöö na booko di bëë naandë ta booko kaba a sösö nö? ");
INSERT INTO srmNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wë nöö ee di didibi ta feti ku ën seei sö, nöö nëën da a ta kaba di tii fëën a sösö nö? Ma nöö di soni ta pasa aki, na di soni un ta taki dë e. ");
INSERT INTO srmNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ma mi o taki da unu andi da di soni ta pasa aki. Te joo go tei gudu a wan taanga womi wosu, nöö i musu kisi ën tai gingin ufö i sa go tei dee gudu fëën awaa. Wë nöö hën u ta du aki e. ");
INSERT INTO srmNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nöö un dee leima u wëti aki, un haika. Fa i si un fan dë, un musu mëni unu seei e. Biga fu hii dee hogi dee sëmbë ta du, ee de ta kosi Masa Gaangadu seei ta sösö ën ta poi ën në, Gadu sa puu de nëën bëë eti. ");
INSERT INTO srmNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma ee wan sëmbë i ta kosi di Akaa u Gadu ta wisiwasi ën, di sëmbë naandë an o kisi paadon a Gadu möönsö a mundu.” ");
INSERT INTO srmNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nöö sö Masa Jesosi fan ku dee sëmbë, fu di de taki taa di hedima u dee didibi hën dë nëën liba ta du dee foondo wooko. ");
INSERT INTO srmNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Te wan pisi Masa Jesosi mama ku dee baaa fëën ko dou a dööbuka dë gbolo, hën de manda kai ën. ");
INSERT INTO srmNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nöö di juu dë, sömëni sëmbë bi sindo lontu Masa Jesosi a di wosu dendu. Nöö hën sëmbë taki dëën taa: “Masa o, dee sëmbë fii ko aki, i mama ku dee baaa fii, nöö de ta kai i e. De dë leti a dööbuka dë.” ");
INSERT INTO srmNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nöö hën a taa: “Dee sëmbë u mi nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Nöö hën a luku dee sëmbë sindosindo lontu ën naandë, hën a taa: “Un dee sëmbë aki dee ta du kumafa Gadu kë, nöö unu wë da mi mama ku mi baaa ku mi sisa e.” ");
INSERT INTO srmNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wë nöö te wan oto daka möön, hën Masa Jesosi toona ko dë a di piki ze u Galilea bandja möön ta lei sëmbë Gadu wöutu. Nöö hën sömëni sëmbë booko seei gililili ko nëën naandë, nöö hën a subi a wan boto bi dë a lampeesi dë, nöö hën a sindo. Nöö dee hia sëmbë dë a tela liba dë, ");
INSERT INTO srmNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","nöö hën a tei wanlö woto ta lei de sömëni sondi a wödu fasi. ");
INSERT INTO srmNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","A taa: “Wan goonma go ta jaa böngö nëën goon dendu. ");
INSERT INTO srmNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nöö fa a ta jaa ën naandë, nöö so fëën ta kai a di pasi liba nöö dee piki fou ta ko ta pii ën ta njan. ");
INSERT INTO srmNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“So u di böngö ta kai a sitonu kamian ka doti an dë hia, nöö a nasi hesi seei. ");
INSERT INTO srmNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma nöö hën di sonu ko hati, hën a kii ën, biga di sitonu kendi di lutu fëën. ");
INSERT INTO srmNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Nöö so u di böngö kai a maka dendu, nöö di böngö ku dee maka tuu ta göö makandi, ma dee maka ta peeta di njanjan te an sa ko sondi. ");
INSERT INTO srmNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Ma nöö dee otowan kai a bunu goon doti, nöö hën a göö ko puu njanjan e. Biga so puu diiteni toon möön hia möön fa a bi dë, so puu sikisiteni toon möön hia, otowan puu wanhöndö. Nöö sö di pisi dë ko njanjan tjika.” ");
INSERT INTO srmNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sö wan woto Masa Jesosi da dee sëmbë te a kaba, nöö hën a taa: “Wë fa mi fan ku unu aki, nöö un pakisei ën bunu e, be un fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nöö hën de dë te wan pisi, Masa Jesosi dë ku wantu sëmbë ku de tuwalufu bakama fëën, nöö hën de hakisi ën taa: “Masa o, faandi mbei i ta lei dee sëmbë a tjubi fasi sö?” ");
INSERT INTO srmNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nöö hën a piki de taa: “Haika e. Unu wë Gadu naki kölöku fuun sa ko sabi dee tjubitjubi soni u di tii fëën. Ma dee oto sëmbë naandë ˻de an ta kë saka deseei a di Tii u Gadu basu möönsö, nöö fëën mbei˼ mi ta lei de a tjubi fasi sö. ");
INSERT INTO srmNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nöö a ko dë taa de ta si kodo ma de an ta fusutan, de ta haika kodo ma de an ta jei möönsö. Biga ee nasö de bi o bia de libi ko a Gadu, nöö a bi o puu de a bëë.” ");
INSERT INTO srmNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nöö hën a hakisi dee bakama fëën taa: “Wan bi fusutan di woto di mi lei dee sëmbë ö? Wë nöö unfa woon du fusutan dee oto sondi mi o toona lei sëmbë möön?” ");
INSERT INTO srmNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hën a taa: “Söö. Wë nöö un haika e, mi o puu ën da unu. Di goonma mi bi taki naandë, hën da di bosikopuma u Gadu e, nöö di böngö hën da di wöutu u Gadu di a ta tja ta paaja. ");
INSERT INTO srmNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nöö ka di böngö kai a pasi liba, dee piki fou ko pii ën njan dë, hën da dee sëmbë ta jei di wöutu u Gadu, ma te de jei ën, nöö wantewante di didibi ta ko puu ën a de pakisei djee, de an ta mëni ën möön. ");
INSERT INTO srmNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Nöö ka di böngö kai a di doti ku sitonu a basu, hën da dee sëmbë dee jei di wöutu u Gadu hën de tei ën seei ku wai, ");
INSERT INTO srmNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ma de an ta hoi dou. Biga te sëmbë ta hoi de u felanti, fuka ku toobi ko miti de u di wöutu hedi, nöö de ta kumutu disa di biibi djee. Biga di wöutu an bi go fundu a de hati tjika. ");
INSERT INTO srmNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Nöö di goon ka di böngö kai a maka dendu dë, hën da dee sëmbë ta jei di wöutu ");
INSERT INTO srmNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma de ta abi bookohedi ku dee sondi u goonliba aki poi. Dee gudu u di goonliba aki ta ganjan de, de ta kë peipei sondi te de an ta a’ ten u di wöutu u Gadu, nöö an sa göö ko sondi a de libi möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Ma nöö ka di böngö kai a di bunu goon, hën da dee sëmbë tei di wöutu u Gadu nöö de ta dëën pasi faa wooko a de hati. Nöö Gadu ta fendi wini a dee lö sëmbë naandë seei te a hia, leti kuma di böngö di puu diiteni toon möön hia möön fa a bi dë, ku sikisi toon, ku wan höndö toon.” ");
INSERT INTO srmNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nöö hën Masa Jesosi taa: “˻Fa i si di womi jaa di böngö naandë, nöö sö a musu du e, biga di wöutu u Gadu an musu fika tjubitjubi. Biga˼ ee wan sëmbë tja wan faja ko a wan wosu dendu, nöö an o butëën a sondi basu. Ma a o butëën a wan kamian be hii sëmbë sa si limbo ku ën, na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","“Nöö un haika e, dee sëmbë. ˻Dee soni mi ta lei a di fasi aki, de an o fika sö tjubitjubi u nöömö e. De o ko a döö wan daka nöömö u sëmbë musu ko sabi de. Biga˼ hiniwan soni di dë tjubitjubi musu u ko a döö wan daka nöömö.” ");
INSERT INTO srmNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hën a taa: “Söö. Wë nöö fa mi fan ku unu aki, nöö un pakisei ën bunu e, be un fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nöö hën a taa: “Dee sëmbë, un buta pakisei a dee soni mi ta taki e. Biga di wan seei maaka joo tei u maaka soni, nöö ku hënseei de o toona maaka da i tu, nöö möön hia seei joo kisi a liba. ");
INSERT INTO srmNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Biga ee wan sëmbë i kisi wan piki soni, nöö hën i wooko ku ën, nöö joo toona kisi möön hia. Ma nöö ee ja wooko ku ën möönsö, nöö di pikiwan di i bi kisi naandë joo lasi ën fiaa.” Sö Masa Jesosi taki di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nöö hën wan oto toon, hën Masa Jesosi tei wan oto woto toona lei dee sëmbë möön fa di Njunjun Tii u Gadu dë. A taa: “A dë leti kuma wan goonma go nëën goon dendu go jaa njanjan böngö te a kaba, nöö hën a go fëën a ganda. ");
INSERT INTO srmNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nöö fa a go dë, a fëëkëtë di oto naandë. A dë fëën nöö ta duumi ta weki. ");
INSERT INTO srmNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","“Ma nöö fa di böngö sai a di goon naandë, te wan pisi a tja aguja ko a döö. Hën a ta göö fëën ta ko, teee a ko dë ku bëë ko puu jakajaka seei ko abi njanjan. ");
INSERT INTO srmNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te wan pisi a lepi, juu fëën dou, hën di goonma ko koti. Ma nöö hii fa di njanjan waka ko sö naandë, ma di sëmbë di paandi ën an saanfa a du ufö a ko sö. Wë nöö leti sö nöö a ta pasa a di Njunjun Tii u Gadu dendu e.” Sö wan oto Masa Jesosi da di juu dë. ");
INSERT INTO srmNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nöö hën a taa: “Un oto mi o toona tei u mi lei unu möön fa soni ta waka a di Njunjun Tii u Gadu dendu?” ");
INSERT INTO srmNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hën a taa: “Wë a dë sö leti kuma di uwii de kai mutaadi di u ta paandi a di köndë fuu aki. Fa a sai dë, nöö di sii fëën piki möön hii dee oto sii de ta paandi, na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma nöö te a göö, nöö a ta ko bigi pasa hii dee oto uwii tuu dee u ta paandi a goon dendu, te piki fou seei ta ko ta mbei wosu a dee maun fëën. “Nöö sö nöö sondi dë a di Njunjun Tii u Gadu dendu e.” ");
INSERT INTO srmNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Wë nöö te Masa Jesosi ta konda di wöutu u Gadu da sëmbë, nöö dee lö oto aki a lobi u tei konda. Biga a ta fan ku de a wan fasi kumafa de sa fusutan soni nöö. Ma te hën ku dee bakama fëën dë de wanwan, nöö a ta puu sondi da de möön fini. ");
INSERT INTO srmNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wan daka hën Masa Jesosi dë ta konda di wöutu u Gadu da dee gaan hia sëmbë naandë tefa sapate, nöö hën a fan ku dee bakama fëën taa: “Womi, un boo koti go a di oto së banda ala ufö.” Hën de taki aai. ");
INSERT INTO srmNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nöö aan soni, hën de disa dee hia sëmbë naandë, nöö hën de tei Masa Jesosi leti fa a sai dë, nöö hën de subi a boto, hën de ta aba di piki ze naandë nango. Ma nöö wanlö oto boto ta faaka de. ");
INSERT INTO srmNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Nöö fa de nango dë, hën Masa Jesosi go a di boto gogo ala wante go kandi buta hedi a wan kunsu liba, hën a duumi pii. ˻Wei nöö a wei sö.˼ Nöö hën de nango te wan pisi, hën wan gaan ventu ko bigi möön hii soni ta seki di wata teee, di wata nango a di boto dendu seei djululuu, kuma de sa singi. Nöö dee bakama fëëë te na soni hën de kule go a Masa Jesosi go weki ën taa: “Masa, ja si taa woo dëdë kaba a di wata aki ö? Ja a’ toobi nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nöö hën Masa Jesosi weki, hën a hopo. Hën a bai di ventu ku di sekiwata taa: “Un tan pii e!” Nöö fa a fan dë, wantewante hën di ventu ku di wata tan piii. ");
INSERT INTO srmNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nöö hën Masa Jesosi hakisi dee bakama taa: “Andi mbei un fëëë sö? ˻Wan a’ futoou a mi liba eti nö?˼” ");
INSERT INTO srmNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nöö hën dee bakama panta te na soni, de ko dë ta luku deseei diin ta hakisi de na de taa: “Womi, ambë da di sëmbë aki di abi sö wan poosian te gaan ventu ku sekiwata seei ta piki ën buka a soni?” ");
INSERT INTO srmNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wë nöö hën Masa Jesosi ku dee bakama fëën aba di piki ze go tjökö a di pisiwata u dee Galasëni sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","4","Nöö fa de ta kumutu a boto dë, nöö hën de ko miti ku wan womi di wanlö taku soni dë nëën liba gbolo. Di womi aki ta libi a dee sitonu baaku u di köndë ka de ta bei sëmbë, nöö a dë sö taanga tee na wan sëmbë seei sa kisi ën hoi buta a wan kamian pii. Biga sömëni pasi de bi pooba bui ën nëën maun ku ën futu tuu, ma nöö a ta koti dee këti seei wököwökö kule go fëën. ");
INSERT INTO srmNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nöö a ndeti ku didia di womi aki ta dë a di geebi naandë ta sanga nango ta ko ta bai ta kai wolo ta koti ën seei ku sitonu pisi hii ën sinkii. ");
INSERT INTO srmNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nöö fa a dë a di kamian naandë te wan pisi hën a si Masa Jesosi te ala, nöö hën a kule ko kai a goon nëën fesi holou sö. ");
INSERT INTO srmNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nöö hën a ta bai taanga seei ta fan ku ën taa: “Andi tja i ko aki, Jesosi, i di Womi Mii u di möön hei Gadu u mundu? Andi u ku i abi eee? Mi begi i taa be i soi a Masa Gadu fesi taa ja o da mi sitaafu e!” ");
INSERT INTO srmNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nöö sö a taki, biga Masa Jesosi bi fan ku di soni nëën liba naandë taa a musu go kumutu dë. ");
INSERT INTO srmNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nöö hën Masa Jesosi hakisi di womi taa: “Un në fii?” Hën a taa: “Mi de kai A-Hia-Möön-Hii, biga u dë seei te a hia.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nöö hën de ta begi Masa Jesosi seei nöömö, taa: “Gaantangi, na jaka u puu a di pisiwata aki e, u begi i.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nöö zuntu ku di kamian naandë i abi wan kununu, nöö wanlö hia hagu bi sai nëën ta pii sondi ta njan. ");
INSERT INTO srmNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nöö hën dee taku soni begi Masa Jesosi taa: “Ee joo puu u a di sëmbë aki liba, nöö gaantangi da u pasi fuu go a dee hagu e.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hën Masa Jesosi da de pasi. Hën de tuu kumutu a di sëmbë go a dee hagu. Fa u mbei naandë hën dee hagu tei kule seei ta bazia di kununu naandë gililili te a di ze u Galilea dubuu piii. Dee hagu dëdë a wata fiaa. Nöö de bi dë kuma tu dusu hagu sö. ");
INSERT INTO srmNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nöö di dee sëmbë bi dë ta watji dee hagu naandë si di soni, nöö hën de kule go a ganda go konda taa sö wan sondi pasa ku dee hagu. Nöö hën dee sëmbë u di köndë booko seei gililili ko a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","16","Fa de ko dou, hën de si di sëmbë di bi dë ku dee hia taku soni nëën liba sindosindo pii ku koosu a sinkii, ku bunu fusutan seei. Nöö dee sëmbë dee bi sai dë, hën de konda da dee otowan te de kaba kumafa de si soni pasa ku di womi ku dee hagu. ");
INSERT INTO srmNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nöö hën dee sëmbë u di köndë begi Masa Jesosi taa gaantangi be a kumutu a di pisiwata u de go fëën. ");
INSERT INTO srmNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nöö Masa Jesosi an fia ku de. A piki, hën a go a boto wante faa go. Ma nöö hën di womi a bi jaka dee taku soni puu nëën liba dë begi ën taa: “Masa, gaantangi, be mi go ku i e.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma nöö Masa Jesosi an dëën pasi faa go ku ën. A taki dëën taa: “Mati o, toona go a dee sëmbë fii ku dee mati fii e, nöö i go konda da de di bunu Gadu du da i aki, ku di fa a saa i tjika.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nöö hën di womi go e, hën a ta konda di sondi pasa ku ën a hii di pisiwata naandë tuu palalaa te dou, kumafa Gadu heepi ën tjika. Baa nöö di sondi dë foondo sëmbë e. Nöö da sö wan gaan wooko Masa Jesosi du a di pisiwata de kai Dekapolisi naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wë nöö hën Masa Jesosi ku dee bakama fëën toona aba go a di oto së banda ala, nöö fa de go dou dë hën sëmbë ko lontu ën seei te a hia buta a mindi. ");
INSERT INTO srmNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nöö di juu dë, hën wan womi de kai Jailusi ko dou. Di womi aki, a dë wan u dee hedima u keiki u di köndë naandë. Nöö di a si Masa Jesosi hën a kai ku kini a goon. ");
INSERT INTO srmNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","A taki dëën taa: “Gaantangi mi begi i, nama maun a wan mujëë mii u mi da mi. A siki seei te fu dëdë.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nöö hën de tei pasi u de go a di hedima wosu, nöö dee hia sëmbë naandë ta bondji Masa Jesosi seei gililili sö nango ku ën. ");
INSERT INTO srmNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wë nöö di juu dë wan mujëë bi dë a dee sëmbë dendu naandë, sondi ta kule nëën tuwalufu jaa longi kaa. ");
INSERT INTO srmNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A bi go a sömëni data, de kulëën te de wei. Hii möni fëën tuu kaba këëë, ma ka u di siki bëtë awaa a ta ko möön hogi. ");
INSERT INTO srmNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Nöö hën di mujëë ko jei u Masa Jesosi gbolo, nöö hën a taa a o ko nëën ko suku heepi tu. Biga a taa: “Ee mi sa nama tjë söseei a di koosu fëën, nöö mi si kuma mi sa ko bëtë nöömö.” Sö di mujëë ta taki nëën hati. Nöö hën a ta tuusi hënseei a dee sëmbë mindi dë tefa a ko nama maun a di koosu u Masa Jesosi kumafa a bi taki. ");
INSERT INTO srmNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nöö di a nama nëën, wantewante dë a fii taa a ko bëtë djeee, di soni an ta kule nëën möön. A ko böö u di sitaafu dë. ");
INSERT INTO srmNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nöö Masa Jesosi seei fii taa wan poosian kumutu nëën kula wan sëmbë, nöö hën wante a bia hakisi dee hia sëmbë ta waka nëën baka naandë taa: “Ambë panjan di koosu u mi?” ");
INSERT INTO srmNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nöö hën dee bakama fëën piki taa: “Masa, dee gaan hia sëmbë ta bondji i gililili aki, hën i taa ee ambë nama a i nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma nöö Masa Jesosi ta tuwë wojo a dee hia sëmbë dendu naandë, faa si ee ambë bi panjëën. ");
INSERT INTO srmNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nöö hën di di mujëë ko sabi taa sö wan gaan sondi pasa ku ën, nöö hën a ko fëëë seei. Hën a ko tuwëën seei a goon a Masa Jesosi fesi naandë, hën a konda hii di sondi te a kaba kumafa a bi waka. ");
INSERT INTO srmNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nöö hën Masa Jesosi fan ku ën taa: “Mujëë, di fa i si i biibi a mi tjika dë, hën wë mbei i fendi heepi e. Nöö go fii, i böö u di siki bi ta sitaafu i dë.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nöö an kaba u fan ku di mujëë seei, nöö hën wanlö sëmbë ko dou dë. De kumutu a di wosu u Jailusi, di hedima u keiki di bi ko begi Masa Jesosi faa ko kula di mujëë mii fëën dëën. Nöö hën de fan ku Jailusi taa: “Mati o, gaan sondi. An dë u di mësitë ko a i wosu möön e, biga di mujëë mii fii lasi libi kaa.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nöö hën Masa Jesosi jei fa de fan, ma nöö an dë gaan sondi dëën seei. Nöö hën a fan ku Jailusi taa: “Na fëëë e, mati. Ta biibi a mi nöömö.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nöö hën de nango a di wosu ka di mujëë mii dë dëdëdëdë ala. Ma nöö Masa Jesosi an mbei dee hia sëmbë go ku ën möön. Petuisi, ku Jakobosi, ku ën baa Johanisi, de nöö a mbei go ku ën. ");
INSERT INTO srmNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nöö di de naki tefa de go dou a di wosu, nöö sömëni sëmbë sai naandë kaa ta mbei wajawaja ta bai ta këë ta kai olo te a bigi. ");
INSERT INTO srmNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nöö hën Masa Jesosi denda go a di wosu, hën a hakisi dee sëmbë taa: “Andi un ta du a di kamian aki sö? Biga na dëdë di mujëë mii dëdë e. Duumi a ta duumi.” ");
INSERT INTO srmNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nöö fa a fan dë, hën de lafu ën te a bigi, biga de sabi bunu taa di mujëë mii dëdë tuu. Nöö hën a buta dee sëmbë naandë tuu go a döö, nöö hën a kai di tata ku di mama u di mujëë mii, ku de dii bakama fëën naandë, nöö hën de go a di kamba ka di dëdë dë. ");
INSERT INTO srmNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nöö hën Masa Jesosi go panjan di dëdë a maun, hën a taa: “Talita kumi,” dati wan taki: “Mujëë mii, hopo taanpu fii e!” ");
INSERT INTO srmNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nöö fa a taki naandë, hën di mujëë mii hopo taanpu a pë. Hën a ta waka ta lontu a di wosu dendu, biga a abi tuwalufu jaa kaa. Baa nöö di soni pasa dë, a bigi da dee sëmbë e. ");
INSERT INTO srmNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nöö hën Masa Jesosi bai de taa: “Di sondi i si pasa aki, wan musu taki ën da sëmbë e. Nöö un da di mujëë mii soni u njan.” Nöö sö wan gaan soni Masa Jesosi du möön e, ka a dë a di pisiwata naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wë nöö hën Masa Jesosi ku dee bakama fëën kumutu naandë, nöö hën de go a di köndë ka a bi kiija. ˻Hën da Nazalëti.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nöö a di saba daka, hën a go a di keikiwosu go ta lei dee sëmbë u di köndë dee lei fëën. Nöö fa a ta fan dë, a ta bigi da de seei, nöö hën de bia ta hakisi de na de taa: “Naasë a kumutu ko aki ku dee lei fëën dë? Unsë a feni sö wan köni? Ambë dëën kaakiti faa ta du dee foondo wooko u ta jei a ta du? ");
INSERT INTO srmNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Biga na di tëmbëma bi dë aki nëën disi nö? Na di mii aki Malia bi pali nö? Dee baaa fëën u sabi de bunu: Jakobosi, Josëfu, Judasi, ku Simon. Dee sisa fëën, na u ku de ta dë aki nö?” Nöö hën de tei ën u hogi te na soni. ");
INSERT INTO srmNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nöö hën Masa Jesosi taki da de taa: “Un haika e, dee sëmbë. Wan tjabukama u Gadu an ta fuka u nëbai a oto köndë e, boiti a di köndë ka a bi kiija, ku dee bëë fëën. A de nöö an ta fendi gafa.” ");
INSERT INTO srmNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Ma fa a fan dë seei, ma a bigi dëën fa dee sëmbë an kë biibi ën. Nöö fëën mbei an du foondo wooko naandë möönsö, boiti wantu sëmbë nöö a kula, di a buta maun a de liba. Nöö hën a kumutu naandë hën a go a dee oto köndë u di pisiwata dë go ta lei sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Te wan daka hën Masa Jesosi kai de tuwalufu bakama fëën ko nëën. Nöö hën a taki da de taa: “Un haika e, mi o manda unu go tu ku tu a dee köndëköndë, ˻nöö woon go konda taa Masa Gadu ta hopo wan njunjun tii˼. Nöö mi o da unu makiti fuun sa jaka dee soni ta ko a sëmbë hedi puu a de liba. ");
INSERT INTO srmNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","“Ma nöö fa woon go aki, wan musu tja soni e. Wan musu tja bëëë. Wan musu tja tu susu, di fuunu futu dë tjika kaa. Wan musu tja tu koosu tu, di dë a unu sinkii dë tjika kaa. Wan musu tja möni e. Nöö di kokoti a i maun dë, hën nöö fii tja. ");
INSERT INTO srmNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Nöö fa woon go aki, nöö te un dou a wan köndë, nöö di sëmbë di o kisi unu buta nëën wosu, nöö naandë un musu tan fu te un kumutu a di köndë dë e. Wan musu kumutu dë go tan a oto wosu möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","“Nöö te un go a wan köndë ka de an kë unu, de an kë jei di lei fuunu, nöö un kumutu disa di köndë dë go e. Ma bifö un go un musu feki di basufutu sandu fuunu tuwë a di köndë kuma wan maaka u de si taa di hebi fika da de.” Nöö sö Masa Jesosi fan ku dee bakama fëën te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nöö hën dee bakama go e. Hën de go ta konda da dee sëmbë a dee köndëköndë taa be de bia disa dee hogilibi u de. ");
INSERT INTO srmNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nöö fa de go dë, nöö de heepi sëmbë e. Biga de jaka sömëni soni bi ta kisi sëmbë a hedi puu a de liba, de tutu fatu a sömëni sikima sinkii kula de ko bunu. ");
INSERT INTO srmNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Nöö fa Masa Jesosi ta du dee foondo wooko a di pisiwata u Galilea naandë, nöö në fëën ta bai ta paaja nango a dee köndëköndë. De ta taki nëën liba seei. So sëmbë taa: “Un haika, dee sëmbë. Johanisi di Dopuma di di könu bi manda dee sodati kii, hën wë toona weki a dëdë e, hën a tei oto në ta tja.” Otowan taa: “Nönö, di fesiten Tjabukama u Gadu de kai Elia, hën di dë e. Hën toona weki ta tja oto në.” Otowan a dendu taa: “Nönö e, na weki di sëmbë aki weki a dëdë, ma a dë wan hebi Tjabukama u Gadu nöö, kuma dee bi dë a fesi.” Nöö sö dee sëmbë ta fan peipei soni u Masa Jesosi. Te nöö di könu u di köndë de kai Helodi seei ko jei u Masa Jesosi. Hën a taa: “Awa, Johanisi di Dopuma di mi bi manda sëmbë kii, hën toona weki tuu. Biga hën nöö sa du dee lö foondo wooko mi ta jei di sëmbë naandë ta du dë.” Sö hën a taki. ");
INSERT INTO srmNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Wë nöö fa di Könu fan dë, a bi kii di Dopuma tuu o, biga a bi manda sodati go koti ën hedi puu. Nöö di sondi mbei a du sö. Di Könu bi abi wan baaa fëën de kai Filipi, nöö di baaa bi abi wan mujëë de kai Helodiasi. Nöö hën di Könu tei di mujëë u di baaa fëën aki buta a wosu gbolo. Nöö hën di a du sö, hën wë Johanisi bai ën taa an du bunu, biga a booko Gadu wëti fa a tei ën suwagi dë. Nöö hën di di mujëë jei taa sö Johanisi bai di manu fëën, nöö a tei Johanisi fu hogi. A hoi ën a bëë seei, a kë kii ën nöömö. Ma nöö di Könu an dëën pasi faa musu kii ën, biga a ta lesipeki Johanisi, a ta si taa a dë wan bumbuu sëmbë ta libi kumafa Gadu kë. Ma nöö u di Könu musu du di mujëë fëën wan piizii, hën a manda sodati buta Johanisi a dunguwosu. Ma so juu di könu ta kai Johanisi faa fan ku ën, nöö a lobi u ta haikëën, hii fa dee fan u Johanisi ta toobi ën seei. ");
INSERT INTO srmNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wë nöö hën de dë te wan daka gbolo, di mujëë kisi pasi faa du ku Johanisi kumafa a bi kë. Biga a ko pasa sö taa di Könu fujai, nöö hën a hoi wan gaan piizii. A kai hii dee bigima u di pisiwata naandë tuu ko a di piizii: dee lanti hedima, ku dee hedima u sodati, ku dee guduma. ");
INSERT INTO srmNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nöö hën de dë a di piizii dendu tee wan pisi. Nöö di baa mujëë fëën di a tei dë bi abi wan mujëë mii fëën. Nöö hën di mujëë mii ko baja wan gaan ˻dëë wojo˼ baja bigi möön hii sondi. Baa nöö a suti da di Könu ku hii dee bigima sai naandë te na soni, fa di mujëë mii baja dë. ");
INSERT INTO srmNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nöö hën di könu kai di mujëë mii ko nëën, hën a taa: “Wë mii, di baja i baja aki a suti poi, nöö mi kë paka i e. Ma nöö i musu piki mi andi i kë, nöö mi soi a hii dee bigima aki fesi tuu taa hiniwan sondi di i hakisi mi mi o da i ën kaa. Ee hafu u di köndë mi ta tii aki seei i kë, mi o da i ën.” Sö di Könu taki da di mujëë mii. ");
INSERT INTO srmNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nöö di a taki sö, hën di mii kule seei hesihesi go nëën mama taa: “Maama o, sö di Könu taki da mi e, nöö andi mi musu hakisi ën?” Nöö hën di mama piki di mujëë mii taa: “Go piki di könu e, taa i kë u de tja di hedi u Johanisi di Dopuma a wan paatu dendu ko da i.” ");
INSERT INTO srmNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nöö hën di mii kule hesihesi go a di könu. A taa: “Wë Köndë Masa, mi ko piki di sondi mi kë e. Mi kë fii da mi di hedi u Johanisi di Dopuma a wan paatu dendu hesihesi seei.” ");
INSERT INTO srmNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wë nöö di di Könu jei sö, nöö hati fëën ko latja, biga a hati ën faa musu du sö wan sondi ku di Dopuma. Ma nöö fu di soi a bi soi a dee bigima naandë fesi da di mujëë mii kaa, fëën mbei an sa puu di buka dë möön. ");
INSERT INTO srmNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nöö aan köni, hën a manda wan sodati faa go koti Johanisi hedi buta a wan paatu tja ko. Nöö hën di sodati go koti Johanisi hedi belim puu, ");
INSERT INTO srmNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","hën a tei buta a di paatu tja ko da di mujëë mii. Nöö hën di mii tei tja go nëën mama. ");
INSERT INTO srmNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wë nöö di dee bakama u Johanisi jei di taki dë, nöö a hati de e, ma heepi an dë. Nöö hën de ko tei di dëdë sinkii fëën tja go bei. Nöö da sö wan gaan hogi Könu Helodi du e. ");
INSERT INTO srmNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wë nöö hën dee bakama u Masa Jesosi, dee a bi manda go a köndëköndë, hën de toona ko nëën baka, nöö hën de konda dëën te de kaba fa de lei dee sëmbë ku fa de du di wooko tjika. ");
INSERT INTO srmNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nöö hën Masa Jesosi taki da de taa: “Un sabi nö? Un boo go a wan pii kamian u wanwan ka sëmbë an dë, fuu sa böö abiti sö.” Nöö di sondi mbei a taki sö, biga hia sëmbë ta kumutu a dee köndëköndë ta ko nëën nöömö ta suku heepi te hën ku dee bakama fëën an sa fendi pasi u njan, bamba u de böö seei. ");
INSERT INTO srmNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nöö hën de kai a boto ta puu nango a di kamian ka de o go dë de wanwan. ");
INSERT INTO srmNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma nöö wanlö hia sëmbë si de, nöö de sabi kaa taa a sö wan kamian de nango. Nöö hën de kule lontu a bandja wata u de go miti ku de a di oto së banda ala. ");
INSERT INTO srmNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nöö di Jesosi ku dee bakama fëën go tjökö, hën de si dee hia sëmbë naandë ta luku de kaa. Nöö aan soni, hën Masa Jesosi go ta lei de sömëni soni möön, biga tjali u de kisi ën. A si taa de dë kuma wanlö hia sikafu söndö tiima ta waka ta daama nango ta ko. ");
INSERT INTO srmNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Nöö fa u mbei dë, nöö sapate ta ko kaa, nöö hën dee bakama taki da Masa Jesosi taa: “Masa o, i sabi nö? A tjika fii manda dee sëmbë go, be de go suku sondi u njan bai a dee köndëköndë a u bandja aki. Biga sëmbë an ta libi ka u dë aki, nöö sondi u njan an dë aki u fendi tu.” ");
INSERT INTO srmNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma nöö hën Masa Jesosi taa: “Nönö e, unu musu da de sondi u njan.” Hën de taki dëën taa: “Unfa i mëni? Dee sömëni sëmbë aki, u o da de sondi u njan nö? Biga di möni di u musu puu bai sondi u njan da de, nöö a musu dë aiti liba wooko möni.” Sö dee bakama fëën piki ën. ");
INSERT INTO srmNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nöö hën Masa Jesosi hakisi de taa: “Un mëni bëëë un abi aki? Un go luku i si.” Nöö hën de go luku te de ko, hën de ko piki ën taa: “U abi feifi bëëë ku tu fisi nöö.” ");
INSERT INTO srmNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nöö hën a manda de taa: “Un go mbei dee sëmbë sindo a dee ahun liba aki na alö e.” ");
INSERT INTO srmNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nöö hën de go mbei dee sëmbë sindo a hipihipi, feifiteni ku feifiteni a wan hipi, wan höndö ku wan höndö a wan hipi. ");
INSERT INTO srmNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nöö hën di de sindo sö kaa, hën Masa Jesosi tei de feifi bëëë ku de tu fisi, nöö hën a hopo wojo luku liba da Masa Gadu tangi te a kaba, hën a booko de pisipisi te a kaba. Nöö hën a tëndë da dee bakama taa be de paati da dee sëmbë. Nöö hën de tei paati da dee sömëni sëmbë naandë tee lontu ko kai. ");
INSERT INTO srmNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nöö hii dee sëmbë tuu seei njan te bëë u de fuu, de an kë möön. ");
INSERT INTO srmNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Wë nöö di mëni sëmbë njan di ten dë, feifi dusu womi sëmbë de konda e, ˻ufö i abi dee mujëë ku dee mii˼. Nöö di de njan te de kaba, hën dee bakama go pii di bëëë ku di fisi dee fika nöö a dou hii tuwalufu manda fuufuu eti. Nöö da sö wan gaan foondo wooko Masa Jesosi du a di lö kamian dë e. ");
INSERT INTO srmNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nöö di dee sëmbë njan te de kaba naandë kaa, hën Masa Jesosi kai dee bakama ko nëën, hën a taa: “Un go tei di boto, nöö un puu go a Betisaida ala.” Sö Masa Jesosi taki da de. Ma nöö hën a o fika dë faa manda dee sëmbë go. ");
INSERT INTO srmNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nöö hën dee bakama fëën go. Nöö di Masa Jesosi manda dee oto sëmbë go kaa, hën a go a wan kuun kamian naandë hën wanwan go ta begi Masa Gaangadu. ");
INSERT INTO srmNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nöö hën di sapate, di boto u dee bakama fëën dë tee a mindiwata ala. ");
INSERT INTO srmNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Te wan pisi hën Masa Jesosi tuwë wojo luku, a si taa de dë a gaan toobi seei. Biga de ta puu kodo ma de an nango fesi. Wan gaan ventu wë ko ta kii de sö. Nöö a gaan ndeti seei di sondi dë ta pasa, biga fosu ganian an kanda eti. Nöö di Masa Jesosi si sö, hën a bazia di kuun ko a di wata bandja hën a ta waka seei tjuwatjuwa ta ko a dee bakama fëën. Nöö hën di a ko zuntu ku de hën a mbei kuma a ta pasa. ");
INSERT INTO srmNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Di juu dë dee bakama wojo ko kai a di sëmbë ta waka a di wata liba naandë, nöö hati u de latja te na soni, de bai kai wolo, biga de mëni taa jooka de si dë. Nöö hën Masa Jesosi kai de taa: “Kijoo, wan fëëë sö e. Un tai hati. Mi wë disi.” ");
INSERT INTO srmNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nöö hën a subi a di boto dendu. Fa a subi dë, nöö wante hën di ventu kötö pii. Wë nöö di sondi dë bigi da dee bakama fëën te na soni. ");
INSERT INTO srmNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Biga wë hii fa de bi si Masa Jesosi tei de feifi bëëë hën a da dee gaan hia sëmbë, de njan dë seei, ma töku de an bi buta mëni nëën fu de sabi ambë dëën. ");
INSERT INTO srmNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nöö hën de puu go tjökö a di pisiwata u dee Genesalëti sëmbë ala, nöö hën de tai di boto u de te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nöö fa de ko dou dë, hën sëmbë si de sabi wante kaa. ");
INSERT INTO srmNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nöö hën de kule go paaja di njunsu te dou hii dee köndë naandë, taa: “Jesosi di kulama dë a di köndë fuu.” Nöö hën dee sëmbë kule go tei dee sikima buta a kama ta tja ko a Masa Jesosi seei gililili sö. ");
INSERT INTO srmNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wë nöö sö. Hii ka Masa Jesosi nango kaa, a dee gaangaan köndë ku dee pikipiki köndë te dou ku dee pandasi kamian tuu, dee sëmbë ta tja dee sikima u de ko buta a sitaati dëën faa musu kula de da de. Nöö de ta begi ën taa be a da de pasi u de ta nama a di jëkëjëkë u di koosu buka fëën, nöö hii dee sëmbë dee nama sö kaa, de tuu ko bëtë. Nöö da sö Masa Jesosi kula dee sëmbë u di pisiwata dë tjika. ");
INSERT INTO srmNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wë nöö hën de dë te wan daka, hën so u dee Faliseima ku dee Sabima u Wëti kumutu a Jelusalen ko a Masa Jesosi dë. ");
INSERT INTO srmNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Te wan pisi hën de ko si taa te dee bakama u Masa Jesosi ta njan, nöö de an ta wasi maun a di fa dee Dju sëmbë guwenti u wasi maun. ");
INSERT INTO srmNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Biga wan tuutuu Dju sëmbë an o njan ee na a wasi maun kumafa a lei a dee gaan sëmbë fëën, ");
INSERT INTO srmNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","taa te a kumutu a wojowojo ko, nöö a musu wasi a wan apaiti fasi bifö a sa njan. Nöö a musu wasi dee paabi lai fëën a wan apaiti fasi tu, kuma dee kan u bebe wata, gansë, paabi u njan. Biga de ta mëni taa ee de an du sö nöö de an o dë limbolimbo a Gadu wojo. ");
INSERT INTO srmNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nöö hën mbei dee Faliseima ku dee Sabima u Wëti hakisi Masa Jesosi taa: “Faandi mbei dee bakama fii an ta hoi dee wëti dee dee gaan sëmbë fuu buta da u?” ");
INSERT INTO srmNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nöö hën Masa Jesosi fan ku de, a taa: “Un dee bödjëëma i si aki, un haika e. Gadu bi da di tjabukama fëën de kai Jesaaja wan buka u wanlö sëmbë, nöö a bi a’ leti e. Biga a taa: Dee sëmbë i si aki sö, de ta lesipeki mi ku de buka, ma hati u de an dë a mi seei. ");
INSERT INTO srmNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Fa de ta bai taa de ta hei mi naandë, na tuu. Sösö sondi seei de kai në ta du dë. Biga na dee wëti u mi de ta lei sëmbë möönsö. Libisëmbë wëti nöö de ta lei. Sö Jesaaja bi taki, nöö dee sëmbë a taki dë, unu wë e.” ");
INSERT INTO srmNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nöö hën a taa: “Dee lei libisëmbë buta, de un ta tei u gaan soni seei, ma nöö dee lei Gadu buta, de un ta disa a wan së ala.” ");
INSERT INTO srmNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hën a taa: “Aai, un köni seei baa, fa un saanfa u buta dee lei u dee gaan sëmbë fuunu a dee lei u Gadu kamian tjika. ");
INSERT INTO srmNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Biga a fesiten di Gadu bi da Mosesi dee wëti, hën a taa i musu lesipeki i mama ku i tata. Ee wan sëmbë i ta kosi i mama ku i tata ta wisiwasi de, nöö de musu kii i puu. Sö Gadu hei mama ku tata tjika. ");
INSERT INTO srmNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Ma nöö un biëën ko wan hii oto soni. Biga wan sëmbë sa taki dëën mama ku ën tata taa: ‘Dee sëmbë, mi si taa un dë a fuka. Ma nöö di sondi mi bi musu tei u heepi unu, mi butëën a wan së da Gadu kaa. Da a ko heepi fëën an dë. Ma a’ soni u da unu möön.’ ");
INSERT INTO srmNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nöö fa di sëmbë fan dë, nöö un ta si taa a fan bunu poi. Nöö sö un sai dë ta tapa sëmbë u de an sa puu de mama ku de tata a fuka möön. ");
INSERT INTO srmNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","“Wë nëën da un puu dee lei u Gadu buta dee lei u dee gaan sëmbë fuunu a de kamian nö? Nöö di soni mi taki dë, hën da wan kodo nöö, u dee hia sösö lei fuunu dee un ta lei sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nöö hën Masa Jesosi mbei dee hia sëmbë dee bi ko dë hai ko möön zuntu ku ën, nöö hën a taa: “Un haika bunu fa mi o fan aki, be un fusutëën. ");
INSERT INTO srmNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mi taki e, dee sondi ta kumutu a döö së nango a i sinkii, na de ta mbei i ko sundju a Gadu wojo e. Ma dee sondi ta kumutu a i hati ko a döö, de ta sundju i a Gadu wojo.  ");
INSERT INTO srmNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nöö fa mi fan ku unu aki, nöö un pakisei ën bunu e, be un fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nöö hën a disa dee sëmbë naandë, hën a go a wosu. Nöö hën dee bakama fëën ko hakisi ën taa: “Masa o, andi di soni i lei dee sëmbë naandë kë taki?” ");
INSERT INTO srmNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nöö hën a taa: “Fa mi fan dë, unu seei tu wan fusutan nö? Wan sabi nö, taa di sondi di i njan tuwë go a i bëë an sa mbei i ko sundju a Gadu wojo? ");
INSERT INTO srmNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Biga te wan pisi a ta toona kumutu a i sinkii baka.” (Nöö ku di lei aki i sa si taa Masa Jesosi puu tjina a hii soni u njan.) ");
INSERT INTO srmNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","Hën a fan go möön longi, a taa: “Di sondi di ta kumutu a wan sëmbë hati ko a döö, nöö hën ta sundju ën a Gadu wojo, kuma te i ta libi fanafiti a manu ku mujëë soni, kuma te i ta fufuu, i ta kii sëmbë, i ta tei sëmbë mujëë ee nasö sëmbë manu, ");
INSERT INTO srmNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","i a’ langahati u sëmbë soni, i ta a’ hogihati u sëmbë, i ta ganjan sëmbë, i ta du fanafiti soni, i ta haun ku sëmbë, i ta tja sëmbë go sei a baka, i abi gaan fasi, i abi wisiwasi fa. ");
INSERT INTO srmNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hii dee lö sondi naandë tuu, a libisëmbë hati de ta kumutu ko a döö, nöö de ta mbei i ko sundju a Gadu wojo. Un jei bunu fa mi taki aki nö? Söö.” ");
INSERT INTO srmNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nöö hën Masa Jesosi kumutu a di köndë naandë, hën a go a di pisiwata zuntu ku di köndë de kai Tilusi, nöö hën a denda go a wan wosu. Ma nöö an kë u sëmbë sabi taa sö a ko sai naandë. Ma di soni an sa tjubi, sëmbë ko sabi gbolo taa a dë a di köndë. ");
INSERT INTO srmNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nöö wan mujëë bi sai dë bi abi wan piki mujëë mii, nöö wan taku soni dë a di mujëë mii liba. Nöö sö hesi di di mujëë ko sabi taa Masa Jesosi sai dë, nöö hën a waka seei langalanga ko nëën naandë. Nöö hën a tjökö kini nëën fesi ");
INSERT INTO srmNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","27","ta begi ën gaanfa seei taa: “Masa, gaantangi, ko jaka wan sondi puu a di mujëë mii u mi liba da mi. Biga a ta penëën te na soni.” Ma nöö hën Masa Jesosi piki ën taa: “Mujëë o, an fiti fii musu puu bëëë a de mii maun tuwë da dagu mii e. Biga dee mii fosu musu njan.” ˻Nöö fa a fan dë, a kë taki taa dee Dju sëmbë fëën fosu musu fendi heepi˼ biga wë di mujëë aki sö an dë Dju sëmbë, oto köndë sëmbë a dë. De pai ën a Finisia u Silia köndë. ");
INSERT INTO srmNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nöö di Masa Jesosi piki ën sö, nöö hën di mujëë hakisi ën taa: “Wë Masa o, dee sakasaka dee ta puu a di tafa liba ta kai a goon, nöö dee dagu mii an sa pii de njan nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nöö hën Masa Jesosi piki ën taa: “Aai mujëë, i hakisi bunu o, nöö i fendi heepi kaa. Toona go fii a wosu, biga di taku soni kumutu disa di mujëë mii fii e.” ");
INSERT INTO srmNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nöö hën di mujëë toona go a wosu. Nöö fa a go dou dë, hën a si di mii fëën dë kandikandi pii, biga di taku soni disëën go kaa. Nöö da sö Masa Jesosi heepi di mujëë naandë e. ");
INSERT INTO srmNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nöö hën a kumutu a di pisiwata u Tilusi naandë nöö hën a o toona go a di ze u Galilea. Nöö fa a nango dë, hën a latja Sidon pasa go dou a di pisiwata de kai Dekapolisi möön. ");
INSERT INTO srmNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nöö di a dou, nöö hën de tja wan womi ko nëën. Di womi aki sö an ta jei soni, an ta fan bunu tu. Nöö hën de ko begi Masa Jesosi taa gaantangi, be a buta maun nëën liba faa sa ko bunu. ");
INSERT INTO srmNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nöö hën Masa Jesosi puu di womi a dee sëmbë naandë mindi nöö hën a tjëën go a wan së. Nöö hën a buta finga a di womi jesi toona puu. Hën a tunta nëën finga buta a di womi töngö. ");
INSERT INTO srmNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nöö hën a luku liba nöö a hai böö taanga. Nöö hën a taa: “Efata,” dati wan taki: “Un jabi.” Di töngö Masa Jesosi ta fan hën taki sö e. ");
INSERT INTO srmNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nöö fa u mbei naandë, nöö hën di womi ko ta fan limbolimbo, a ko ta jei soni seei gbegedee. ");
INSERT INTO srmNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nöö hën Masa Jesosi bai dee sëmbë taanga taa de an musu konda di soni di pasa naandë da na wan sëmbë. Ma nöö di möön a ta bai de, möönmöön seei de ta paajëën nango. ");
INSERT INTO srmNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nöö hën di soni bigi da hii mundu. De sai dë ta taki taa: “Aai oo, hii dee soni di sëmbë aki ta du, de tuu bunu e. Biga dee tapabukama ku dee sëmbë dee an ta jei soni seei a ta mbei de ta ko ta jei soni ta fan.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wë nöö hën a ko pasa sö a di ten naandë taa wanlö hia sëmbë ko dë ku Masa Jesosi möön ta haika di lei fëën. Hën de sai ku ën dë te nöö hangi ko kisi de poi, soni an dë u de njan. Nöö hën Masa Jesosi kai dee bakama fëën ko nëën, hën a taa: ");
INSERT INTO srmNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Un haika e. Tjali kisi mi da dee sëmbë aki, biga disi mbei dii daka di de dë ku mi aki, nöö hangi kisi de poi. ");
INSERT INTO srmNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma nöö ee mi manda de go a wosu söndö njan, nöö so u de o faau a pasi, biga ka de ta libi ku aki longi poi.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nöö hën dee bakama piki taa: “Wë ma sëmbë an ta libi a di kamian aki, nöö unsë u sa feni sondi u njan tjika u da dee hia sëmbë aki?” ");
INSERT INTO srmNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nöö hën a hakisi de taa: “Un mëni bëëë un abi aki?” Nöö hën de piki taa: “Sëbën nöö u abi.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nöö hën a taa antoobi. Hën a mbei dee sëmbë sindo leti a goon naandë. Nöö hën a tei de sëbën bëëë, hën a begi da Gadu tangi te a kaba. Nöö hën a booko dee bëëë pisipisi, hën a tëndë da dee bakama u de paati da dee sëmbë. Nöö hën dee bakama tei, hën de paati da dee hia sëmbë dë te lontu ko kai. ");
INSERT INTO srmNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nöö de bi abi wantu fisi naandë tu, nöö hën de tei de tja ko da Masa Jesosi. Nöö hën a toona begi Gadu te a kaba dëën tangi, nöö hën a tëndë da dee bakama fëën. Nöö hën de tei toona paati da dee sëmbë te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Nöö hën hii sëmbë njan te bëë u de fuu. Nöö dee sëmbë bi njan di njan naandë bi dë fö dusu e. Nöö di de njan te de kaba, hën dee bakama go pii dee njanjan fika naandë te de kaba zunta, nöö a fuu hii sëbën manda. Nöö hën Masa Jesosi ko manda dee sëmbë go a wosu awaa. Nöö da sö wan gaan foondo wooko Masa Jesosi du möön a di pisi kamian dë e. ");
INSERT INTO srmNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nöö a baka u di dee sëmbë go, hën Masa Jesosi ku dee bakama fëën subi a boto kumutu dë. Nöö hën de hai go a di pisiwata de kai Damanuta. ");
INSERT INTO srmNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nöö di de ko dou, nöö wantewante hën dee Faliseima ko a Masa Jesosi ko ta suku ën buka a sondi. Nöö hën de fan go, de fan ko, nöö hën de hakisi ën taa a musu du wan foondo wooko u lei de taa a Gadu di kaakiti fëën ta kumutu tuutuu. ");
INSERT INTO srmNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nöö di de hakisi sö, hën Masa Jesosi djëmë hun. Hën a taa: “A bigi a mi, di a dë taa dee sëmbë u di ten aki ta suku foondo wooko nöömö ufö de sa piki taa Gadu hën manda mi ko.” Nöö hën a piki de, a taa: “Ma o du na wan foondo wooko lei unu kumafa un kë möönsö e.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sö a piki de, nöö hën a disa de naandë go fëën. Hën ku dee bakama fëën toona subi a boto fu de go a di oto së banda u di ze ala baka. ");
INSERT INTO srmNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","16","Ma nöö fa Masa Jesosi ku dee bakama fëën dë a di boto nango dë, de bi fëëkëtë u tja bëëë. Nöö hën de nango te wan pisi, hën Masa Jesosi bai de a wan sondi a nöngö fasi sö, a taa: “Un mëni unu seei e, be wan tei di sooda u dee Faliseima ku di u Könu Helodi.” Ma nöö fa a fan dë, dee bakama an fusutan andi a kë taki da de. Nöö hën de ta fan ku deseei taa: “Awa womi, wan kodo bëëë tö nöö u tja ku u a di boto, nöö hën mbei wë i si a bai u sö e.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma nöö Masa Jesosi sabi taa sö de ta taki, nöö hën a gandji da de, a taa: “Dee sëmbë o, unfa un sa taki sö wan soni taa u di wa tja bëëë hën mbei mi ta fan sö ku unu? Wan fusutan fa mi dë eti nö? Unfa un sa don sö? ");
INSERT INTO srmNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Biga misikuma un abi wojo ma wan ta si sondi, un abi jesi ma wan ta jei sondi. Wan sabi möön andi bi pasa ");
INSERT INTO srmNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","di mi bi tei de feifi bëëë booko pisipisi, hën un paati da de feifi dusu sëmbë nö? Di de njan te bëë u de fuu, unfa di bëëë bi fika hia tjika?” Nöö hën de piki taa: “Tuwalufu manda.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nöö hën a hakisi taa: “Wë di mi booko de sëbën bëëë un bi paati da de fö dusu sëmbë wë? Un mëni manda bi fika?” Nöö hën de piki taa: “Sëbën.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hën a taa: “Wë nöö an tjika fuun sabi taa fa mi dë aki, ma ta abi bookohedi ku njanjan sondi nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nöö hën de tjökö a di köndë de kai Betisaida. Nöö di de ko dou, hën wanlö sëmbë tja wan bookowojoma ko a Masa Jesosi, nöö hën de begi ën faa musu nama maun a di womi be a ko ta si sondi. ");
INSERT INTO srmNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nöö hën a panjan di womi a maun tja puu a di köndë ganda. Nöö hën a tunta a di womi wojo, hën a nama maun nëën. Nöö hën a hakisi ën taa: “I ta si sondi ö?” ");
INSERT INTO srmNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hën di womi piki taa: “Wë mi ta si sëmbë ta waka ma de djei pau.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nöö hën Masa Jesosi toona lobi maun nëën wojo wan pasi möön, nöö hën a hakisi ën taa: “Unfa i ta si sondi möön?” Nöö hën di womi luku sondi möön. Fa u mbei dë, a ko ta si sondi gbegedee seei awaa. ");
INSERT INTO srmNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nöö hën Masa Jesosi bai ën taa an musu toona go a di köndë naandë. Hën a mandëën go a wosu. ");
INSERT INTO srmNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wë nöö hën Masa Jesosi ku dee bakama fëën, hën de tei pasi nango a dee köndëköndë dee dë zuntu ku di gaan köndë de kai Sesalia Filipi. Nöö fa de dë a pasi nango dë, nöö hën Masa Jesosi hakisi dee bakama fëën, a taa: “Womi, ambë un ta jei de ta taki taa mi dë?” ");
INSERT INTO srmNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nöö hën de piki taa: “Wë de ta taki taa i da wan u dee nëbai Tjabukama u Gadu di toona weki a dëdë, kuma Johanisi di Dopuma, kuma de Elia sö. Sö lanti ta mëni fii e.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nöö hën a bia hakisi de taa: “Wë unu wë? Ambë uun taa mi dë fa mi ku unu ta lontu aki?” Nöö hën Petuisi piki taa: “Masa, i da di Keesitu e, di Paamusi Könu di bi o ko.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nöö hën Masa Jesosi bai de taa: “Fa Petuisi taki dë, nöö wan musu kondëën da na wan sëmbë e. Un musu hoi ën tjubitjubi ufö.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nöö hën a seti fan ku de soni fëën seei limbolimbo awaa. A taa: “Mi o taki wan soni da unu aki e, taa Mi di ko dë Libisëmbë Mii aki, mi o tja sömëni pei sitaafu a dee Gaan Womi ku dee Gaan Begima ku dee Sabima u Wëti maun. Biga de an kë tei mi u soni möönsö. Te wan pisi nöö de o kii mi. Ma nöö a di u dii daka, nöö mi o toona weki ko ku libi baka.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nöö sö a fan ku dee bakama fëën limbolimbo. Ma nöö hën Petuisi kai ën a së, hën a taa: “Haika, di fan i fan dë, ja musu taki sö e. Sö wan soni an musu pasa ku i seei, kwetikweti.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nöö di a fan sö, hën Masa Jesosi bia luku dee oto bakama naandë, nöö hën a gandji da Petuisi. A taa: “Pasa kumutu a mi fesi dë, Didibi Saatan ju, biga fa i fan dë, na sö Gadu ta mëni soni. Libisëmbë pakisei nöö di dë.” ");
INSERT INTO srmNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nöö hën a kai dee oto bakama fëën, ku wanlö hia sëmbë bi sai dë, u de hai ko möön zuntu ku ën. Nöö hën a taa: “Un haika e, dee sëmbë. Ee wan sëmbë i kë ko dë bakama u mi, nöö i musu disa di soni di i seei kë du, nöö i musu dë kabakaba fii tei hiniwan sondi di ko a i liba fu di i ta nama ku mi hedi, te dou ku dëdë seei. Ja musu hai baka möönsö.” Sö a fan ku de. ");
INSERT INTO srmNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nöö hën a taa: “Fa mi fan dë, di soni mbei mi taki sö. Biga ee wan sëmbë i ta suku fii hoi i libi kumafa i kë, nöö joo lasi di suti libi Gadu kë da i. Ma ee wan sëmbë i ta saka i libi fu mi hedi nasö fu di Bunu Buka u Gadu musu paaja hedi, nöö di sëmbë dë o fendi libi a Gadu nöömö. ");
INSERT INTO srmNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Nöö unfa un mëni, dee sëmbë? Ee wan sëmbë i fendi di goonliba aki njan kumafa i kë, ma i lasi go a di didibi faja fu teego, nöö andi seei a heepi i? ");
INSERT INTO srmNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nöö andi seei dë a di goonliba aki waiti tjika tu fii sa lasi i seei fëën hedi? ");
INSERT INTO srmNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Nöö wan ta si fa dee sëmbë u di ten u dë aki ta disa Gadu ta libi dee hogilibi u de nö? Wë nöö ee hën wan sëmbë sen ta kisi i fii piki a dee lö sëmbë dë dendu taa i ta nama ku mi, ee nasö sen kisi i fii piki dee soni mi ta taki da unu aki, nöö söseei sen o kisi mi da i tu, a di daka di mi o ko. “Biga di juu o dou, nöö Mi di ko dë Libisëmbë Mii aki o toona ko a goonliba aki, mi ku dee basia u mi Tata köndë tuu. Nöö fa i si woo ko dë, ku hii di gaan hei u mi Tata ku di waiti fëën tuu mi o ko e. Nöö a di juu dë, mi o piki seei gbelin taa ma sabi i di lö sëmbë naandë tu.” Nöö da sö Masa Jesosi bai dee sëmbë te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hën a taki da dee bakama fëën taa: “Dee sëmbë o, mi piki unu seei gbelin taa, so fuunu dë aki an o dëdë bifö un si di Tii u Gadu ko a goonliba ku kaakiti e.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nöö hën a baka sikisi daka u di a fan ku dee bakama fëën sö kaa, nöö hën a tei Petuisi, Jakobosi, ku Johanisi, hën de subi wan gaan hei kununu go te nëën liba ala, de wanwan. Nöö hën de sai dë te wan pisi, hën de ko si Masa Jesosi tooka gaanfa seei a de wojo. ");
INSERT INTO srmNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Dee koosu fëën sinkii ko weti faan. Ka de weti tjika dë, na wan libisëmbë tjika u mbei koosu ko weti kuma di dë e. ");
INSERT INTO srmNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nöö hën de ko si tu sëmbë ta fan ku Masa Jesosi dë. Mosesi ku Elia wë e, ˻de tu gaan nëbai tjabukama u Gadu u fesiten, de wë ko fan ku ën sö, ma de bi dëdë gaanduwe kaa˼. ");
INSERT INTO srmNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nöö hën Petuisi taki da Masa Jesosi, a taa: “Mësitë o, a suti fa u dë aki. Nöö i sabi nö, woo mbei dii tjëkëliba da unu, wan fii, wan u Mosesi, ku wan u Elia.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma fa a fan dë seei, ma na ku fusutan e, biga di ten dë hën ku dee otowan fëën bi fëëë te de an sa fa u taki. ");
INSERT INTO srmNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Di juu dë, hën de si wan bundji saka zaaa ko tapa de buuu. Nöö hën de jei wan töngö ta piki a di bundji dendu taa: “Di sëmbë aki, hën wë da di lobi Womi Mii u mi e. Nöö hën un musu ta haika.” Sö di töngö taki. ");
INSERT INTO srmNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nöö te u de Petuisi kë mëni, de an si de tu sëmbë dë möön. Masa Jesosi wanwan tö nöö de si fika dë. ");
INSERT INTO srmNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nöö hën de bia kumutu a di kununu liba ta saka nango a goon. Te wan pisi hën Masa Jesosi taki da de, a taa: “Un haika e, dee sëmbë. Di sondi un si a di kununu liba ala, wan musu taki ën da na wan sëmbë e. Ma un hoi ën fuunu wanwan ufö. Te mi di ko dë Libisëmbë Mii aki weki baka a dëdë bifö fuun sa kondëën.” Sö a bai de. ");
INSERT INTO srmNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nöö hën mbei de an kondëën da sëmbë tu. Ma di de ta bazia di kuun nango, hën de ta taki a di sondi dë liba de na de nöö. Nöö de ta hakisi deseei taa: “Fa a taki soni u dëdë weki baka dë, andi a kë taki ku di dë?” ");
INSERT INTO srmNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nöö hën de bia hakisi Masa Jesosi taa: “Masa o, faandi mbei dee Sabima u Wëti ta lei u taa Elia fosu bi musu ko bifö di Paamusi Könu ko?” ");
INSERT INTO srmNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Nöö hën a piki de taa: “Awa, sö a dë a Gadu Buku tuu e, taa Elia fosu musu ko lei sëmbë buta a pasi bifö di Paamusi Könu ko. Ma nöö mi taki da unu taa Elia ko kaa e, nöö hën de du ku ën kumafa de kë, leti kumafa di Buku bi taki taa de bi o du.” ˻Nöö fa a fan dë, hën dee bakama ko fusutan taa Johanisi di Dopuma a ta taki dë. Hën wë bi dë di Elia di bi musu ko.˼ Hën a taa: “Wan oto soni dë sikifisikifi a di Buku tu, taa te di Sëmbë di ko Libisëmbë Mii o ko, nöö de an o si ën u wan wojo sondi. De o sitaafu ën te a tjika de. Sö di Buku taki. Nöö unfa un mëni u di dë?” Sö a hakisi de. ˻Ma de an sabi unfa u piki ën.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nöö hën de ta saka ta ko tefa de kai a palala goon, ka dee oto bakama bi dë a di kununu futu dë. Nöö di de ko dou, hën de ko si sömëni sëmbë a di kamian ta fan nango ta ko kuma de dë a wan gaan buja, nöö dee Sabima u Wëti seei bi dë a dendu tu. ");
INSERT INTO srmNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nöö te u dee sëmbë kë mëni, hën de si Masa Jesosi gbegedee ta ko, nöö de ko foondo gaanfa seei. Hën de kule go nëën go dëën odi. ");
INSERT INTO srmNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nöö hën a hakisi de taa: “Andi ta pasa a di kamian aki mbei un ta fan hia sö?” ");
INSERT INTO srmNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nöö hën wan womi piki ën taa: “Mësitë o, mi bi ko a i aki. Wan soni dë a wan womi mii u mi liba ta biinga seei u kii ën. A ta tapëën buka te an sa fan, ");
INSERT INTO srmNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","nöö te a ta ko nëën liba, nöö a ta kisi ën ta tuwë a goon holou, sukuma ta puu nëën buka fukuu, a ta tai ën tanda gingin, sinkii fëën ta ko gagagaa sö. Nöö di ja bi dë, hën wë i si mi begi dee bakama fii u de musu jaka di soni puu a di mii liba da mi. Ma nöö de biinga seei te de wei, de an sa du na wan sondi da di mii. Nöö sö e baa.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nöö hën Masa Jesosi piki taa: “Ee maingë, andi seei mi fendi a dee sëmbë u di ten aki maun di a dë taa wan ta biibi möönsö? Un longi seei mi musu dë ku unu aki eti bifö woon biibi? Un longi mi musu hoi pasensi ku unu?” Nöö hën a taa: “Un go tei di mii tja ko aki i si.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nöö hën de go tei di mii. Ma fa de ta ko ku ën dë, nöö hën di sondi di dë nëën liba si Masa Jesosi gbegedee, nöö aan sondi, hën a kisi ën ta du sondi te na sipootu. Biga a tuwë di mii a goon holou, a ta logoda a goon, ta puu sukuma a buka seei fukuu. ");
INSERT INTO srmNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nöö hën Masa Jesosi hakisi di tata u di mii taa: “Un longi di sondi dë ku di mii kaa?” Hën a piki taa: “Wë u sensi di a dë piki mii a maun, ");
INSERT INTO srmNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","hën a ta ko nëën te kisi fa u dë aki. Nöö sömëni pasi seei a ta biinga u kii ën, te a wata ku faja tuu a ta hiti ën go. Wë nöö Mësitë, ee i sa heepi u, nöö gaantangi mi begi i tei tjalihati fuu nöö i heepi u.” Sö di tata u di mii taki. ");
INSERT INTO srmNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nöö hën Masa Jesosi piki ën taa: “Wë na a mi a dë e, ma a i a dë. Biga ee wan sëmbë ta biibi Gadu, nöö sondi seei an dë di Gadu an sa du dëën.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nöö di a taki sö hën di tata u di mii bai taanga taa: “Mësitë o, mi ta biibi e. Ma nöö fii heepi mi be mi biibi tjika.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nöö di juu dë, hën Masa Jesosi si taa sömëni sëmbë ta booko ta ko a de naandë. Nöö hën a bai di soni di dë a di mii liba taa: “Ju di sondi ta dë a di mii aki liba ta tapëën jesi ku ën buka, mi taa, hetji pasa kumutu disëën! Nöö na toona ko nëën möön a mundu!” ");
INSERT INTO srmNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nöö fa a bai ën dë kaa, hën di soni bai kai wan hogi olo. Nöö hën a kisi di mii wan pasi möön, di mii ta seki ta du soni, sinkii fëën ko kakakaa. Nöö hën a kumutu go disa di mii djee awaa. Ma nöö di mii fika a goon pii, nöö hën dee sëmbë sai naandë taa: “Awa, dëdë a dëdë e.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma nöö hën Masa Jesosi panjëën a maun hopo taanpu, biga a ko bunu kaa. ");
INSERT INTO srmNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nöö hën a kumutu dë ku dee bakama fëën hën de toona go a wosu. Nöö di de dou, hën dee bakama hakisi ën taa: “Masa o, faandi mbei wa bi sa puu di soni a di mii liba?” ");
INSERT INTO srmNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nöö hën a piki de taa: “Sö wan taku soni ja sa jakëën puu go söndö begi e.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nöö hën Masa Jesosi ku dee bakama fëën kumutu a di köndë naandë. Nöö fa de nango dë, de ta latja ta pasa a di pisiwata de kai Galilea. Nöö di ten dë Masa Jesosi an kë u lanti sabi naasë a dë, ");
INSERT INTO srmNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","biga a kë lei dee bakama fëën a wantu soni liba. Nöö hën de nango te wan pisi, hën a kai de te de piki, hën a taa: “Un haika e. De o könku Mi di ko dë Libisëmbë Mii aki buta a sëmbë maun e, nöö de o kii mi. Ma nöö a di u dii daka nöö mi o toona weki baka.” Sö a fan ku de. ");
INSERT INTO srmNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma nöö dee bakama an ta fusutan di sondi a ta taki da de dë, nöö de fëëë u hakisi ën tu. ");
INSERT INTO srmNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nöö hën de nango te de dou a Kapenaumi nöö hën de go denda a wosu. Nöö hën Masa Jesosi hakisi de taa: “Fa u bi dë a pasi ta ko dë, andi un bi fendi ta fia ku unu seei sö?” ");
INSERT INTO srmNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma nöö de an piki ën, de dë piii seei. Biga di soni de bi ta fia, de bi ta hakisi de na de taa tee Masa Jesosi ko könu, nöö ee undi u de o dë möön hei möön dee oto. ");
INSERT INTO srmNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nöö hën Masa Jesosi sindo te a kaba, hën a kai de tuwalufu bakama fëën tuu ko nëën. Nöö hën a fan ku de, a taa: “Söö. Wë un kë ko fesima a di könu tii u mi dendu ö? Wë be mi taki da unu, taa di fuunu di o saka hënseei tei di möön lagi kamian ta dini dee otowan fëën, hën wë o dë di möön hei sëmbë fuunu tuu e.” Sö a piki de. ");
INSERT INTO srmNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nöö hën a kai wan piki mii ko a de fesi dë. Hën a hopo ën tei. ");
INSERT INTO srmNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Hën a taa: “Haika e. Ee wan sëmbë i tei sö wan lagi sëmbë kuma di mii aki sö u gaan sondi fu di i nama ku mi hedi, nöö miseei i tei dë e. Nöö fa i tei mi dë, nöö na mi wanwan i tei, ma i tei Masa Gaangadu tu di manda mi ko a goonliba aki.” Nöö sö Masa Jesosi fan ku dee bakama fëën te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nöö baka u di dë, hën Johanisi taki wan sondi da Masa Jesosi, a taa: “Masa o, u bi si wan sëmbë ta tei di në fii ta jaka dee soni ta kisi sëmbë a hedi puu a de liba. Nöö hën u fan ku ën faa disa, biga an dë a di kulupu fuu.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nöö hën Masa Jesosi piki, a taa: “Wë an bi dë fuun tapëën e. Biga na wan sëmbë sa tei di në u mi du foondo wooko, nöö a bia sö hesi ta kosi mi. ");
INSERT INTO srmNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nöö boiti di dë, fa a ta du foondo wooko a mi në dë, hën da an dë felantima fuu. Nöö ee wan sëmbë an dë felanti fuu, nöö hën da u ku ën dë a wan së.” Nöö sö Masa Jesosi piki. ");
INSERT INTO srmNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nöö hën a taa: “Mi o taki wan sondi aki da unu gbelin seei. Di sëmbë di o du wan sëmbë bunu a di në u mi di Paamusi Könu, ee wan gangaa wata seei a dëën, nöö Gadu o dëën paima nöömö.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Hën Masa Jesosi fan ku dee bakama fëën go möön longi, a taa: “Ja si fa di mii aki dë nö? ˻An kisi fusutan fu soni fu mi wan bëtë eti.˼ Nöö ee sö wan sëmbë ko biibi a mi, nöö hën i mbei a du wan soni faa kumutu a Gadu pasi, nöö gaan hogi seei i du dë e. A bi sa möön bëtë da i de bi tai wan gaan gindi sitonu a i gangaa te de kaba, nöö de tja i go tuwë a di möön fundu kamian u di ze dubuu piii. Biga mi taki da unu taa di sitaafu naandë an hogi kuma di joo kisi ee i mbei wan lagi sëmbë kuma di i si aki kumutu a Gadu pasi. ");
INSERT INTO srmNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Nöö mi taki e, i musu biinga seei fii fika a Gadu pasi. Fëën mbei ee wan gaan soni fii kuma di letisë maun fii kë puu i a Gadu pasi, nöö a bëtë i koti ën puu tuwë e. Biga a dë möön bunu da i fii dou a Gadu Köndë ku wan së maun, möön leki de tuwë i a didibi faja ku telu.  ");
INSERT INTO srmNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Biga di faja ala an ta tapa möönsö, söseei dee bitju ta njan sëmbë ala de an ta dëdë möönsö tu. ");
INSERT INTO srmNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Nöö ee di futu fii ta suku u puu i a Gadu pasi tu, nöö fii koti ën puu tuwë e. Biga a dë möön bunu ee i dou a Gadu Köndë ku wan së futu, möön leki i dou a didibi faja ku de tu së futu fii, fii go ta tja sitaafu u nöömö.  ");
INSERT INTO srmNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Biga di faja ta tjuma sëmbë ala, an ta tapa möönsö, söseei dee bitju ta njan sëmbë ala, de an ta dëdë tu. ");
INSERT INTO srmNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Söseei, ee di letisë wojo fii kë puu i a Gadu pasi, nöö fii diki ën puu tuwë e. Biga a dë möön bunu da i i dou a Gadu Köndë ku wan së wojo, möön leki i dou a didibi faja ku tu së wojo go ta tja sitaafu u nöömö. ");
INSERT INTO srmNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Biga di faja ta tjuma sëmbë ala an ta tapa möönsö, söseei dee bitju ta njan sëmbë ala, an ta dëdë möönsö tu e.” ");
INSERT INTO srmNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","50","Nöö hën Masa Jesosi fan möön, a taa: “Un haika e, dee sëmbë. Satu dë wan bumbuu soni da u a goonliba aki. Ma ee a lasi ën kaakiti, nöö sondi an dë u toona dëën kaakiti möön e. ˻Nöö sö un sa luku di libi fuunu. A musu a’ kaakiti tu, kuma satu. Ma bifö a sa ko sö,˼ nöö i musu tai hati pasa sömëni soni dee ta pooba i ufö. ˻Ma ee nasö, nöö joo dë kuma di satu u taki dë di lasi ën kaakiti, ja o abi wan wojo heepi da sëmbë möön.˼ “Nöö sö e baa, wan musu lasi unu kaakiti, ma un musu ta libi fiifii ku unu seei nango nöömö.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nöö hën Masa Jesosi ku dee bakama fëën kumutu a di kamian naandë, nöö hën de toona go a Judea. Hën de koti Joodan Lio aba go a di oto së banda. Nöö di de go dou, nöö sömëni sëmbë ko a Masa Jesosi, nöö hën a seti u lei de kumafa a bi guwenti. ");
INSERT INTO srmNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Te wan pisi hën wanlö sëmbë u dee Faliseima kulupu ko nëën naandë, nöö hën de ko hakisi ën soni fu de sa feni ën kisi. Biga de hakisi ën taa: “Mësitë o, unfa di wëti u Gadu dë? Wan womi sa tuwë di mujëë fëën nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nöö hën hënseei toona hakisi de wan soni. A taa: “Unfa Mosesi bi sikifi u di soni dë buta a di buku u Gadu?” ");
INSERT INTO srmNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hën de piki taa: “Wë a sikifi buta taa ee wan womi o tuwë di mujëë fëën, nöö a musu sikifi wan pampia te a kaba u taki di soni mbei an këën möön ufö a mandëën go.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nöö hën a taa: “Awa, sö a sikifi tuu. Ma fu di taangajesi fuunu mbei Mosesi da unu sö wan pasi. Ma un haika e. ");
INSERT INTO srmNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","A seti di Masa Gaangadu mbei hii soni u goonliba, nöö hën a mbei wan womi ku wan mujëë nöö. ");
INSERT INTO srmNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nöö fëën mbei wan womi o kumutu disa hën mama ku ën tata nöö a go dë ku ën mujëë, ");
INSERT INTO srmNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nöö de an o dë tu sëmbë paatipaati möön, ma de o ko dë di wan sinkii. ");
INSERT INTO srmNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nöö dee sëmbë Gadu tja ko makandi sö kaa, nöö na wan sëmbë abi leti u paati de e.” Sö Masa Jesosi piki dee Faliseima. ");
INSERT INTO srmNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nöö di de toona ko a wosu, hën dee bakama hakisi ën a di manu ku mujëë soni liba di a bi taki naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nöö hën a piki de taa: “Mi taki da unu e, taa ee wan womi tuwëën mujëë go tei oto mujëë, nöö Gadu wëti seei a booko dë. ");
INSERT INTO srmNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Söseei tu ee wan mujëë tuwëën manu go tei oto manu, nöö Gadu wëti di mujëë dë booko tu.” Sö a piki de. ");
INSERT INTO srmNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wan daka hën wanlö sëmbë ta tja dee mii u de ko a Masa Jesosi faa musu buta maun a de liba. Nöö di dee bakama si sö, hën de gandji seei da dee sëmbë taa de an musu tja dee mii ko nëën. ");
INSERT INTO srmNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nöö hën di Masa Jesosi si sö kaa, nöö hati fëën boonu. Hën a bai de taa: “Wan tapa dee mii u de an ko a mi e. Biga di fasi i si wan piki mii abi, hën da di fasi di dee sëmbë dee dë a di Tii u Masa Gadu musu abi. ");
INSERT INTO srmNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Biga mi taki da unu gbelin taa ee wan sëmbë an sa futoou hënseei a Masa Gaangadu maun kumafa wan piki mii ta futoou hënseei a dee gaan sëmbë fëën maun, nöö soni an o mbei te a sa dë a di Tii u Gadu dendu möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nöö di a fan sö te a kaba, hën a tei dee mii nëën maun, hën a begi Masa Gaangadu da de. ");
INSERT INTO srmNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nöö hën Masa Jesosi kumutu a di pisi kamian naandë ta waka nango. Te wan pisi hën wan womi ko tjökö kini a goon nëën fesi, hën a hakisi ën taa: “Di bumbuu mësitë aki o, andi seei mi sa du u mi feni di libi u teego a Gadu?” ");
INSERT INTO srmNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nöö hën Masa Jesosi piki ën taa: “Fa i taa mi bumbuu dë, na wan sëmbë dë bumbuu boiti Masa Gaangadu tö. ");
INSERT INTO srmNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“Ma nöö fu piki a di hakisi fii naandë, nöö ja sabi dee wëti Gadu buta da sëmbë u de libi ku de nö? A taa ja musu kii sëmbë, ja musu tei oto sëmbë mujëë, ja musu ta fufuu, ja musu ta mindi soni buta a sëmbë hedi, ja musu ganjan sëmbë a köni fasi njan, i musu lesipeki i mama ku i tata, na sö nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nöö hën di womi piki ën taa: “Aai, ma sensi di mi bi dë piki mii, nöö hën mi ta hoi miseei a dee wëti naandë liba te kisi fa u dë aki.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hën Masa Jesosi luku di womi nöö a lobi ën seei. Nöö hën a taki dëën taa: “Wë ma wan soni toobi i eti. Go, nöö i sei hii dee gudu fii dee i abi te i kaba, nöö i tei di möni nöö i paati ën da dee pootima, nöö joo abi gudu a Gadu Köndë ala e. Nöö ko fika ku mi ta waka a mi baka.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nöö di di womi jei fa a fan naandë, nöö hën a saka hedi a goon ko dë pii. Nöö ku gaan tjali a hati a go a wosu biga a abi gudu te a hia a di goonliba aki. ");
INSERT INTO srmNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hën Masa Jesosi bia luku dee bakama fëën, hën a taa: “Un si ö? A taanga e, fu wan guduma musu ko a di Tii u Gadu dendu.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Fa Masa Jesosi taki naandë, nöö a bigi da dee bakama fëën te na soni. Nöö hën a taa: “A taanga tuu e, dee mii. Mi taki da unu seei taa fu wan guduma musu ko a di Tii u Gadu dendu, an dë sösö soni e. ");
INSERT INTO srmNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Leti kumafa di gaan mbeti de kai kamëli an sa pasa a wan aguja baaku, nöö söseei a taanga da wan guduma faa ko a di Tii u Gadu dendu.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nöö fa a taki naandë, awaa seei di sondi ko foondo dee bakama fëën biga de an bi mëni sö. Nöö hën de bia ko ta hakisi deseei taa: “Wë nöö ee sö a dë, nöö hën da na wan sëmbë sa feni libi u teego e.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nöö hën Masa Jesosi luku de diin, hën a taa: “Ee a nama a di kaakiti u libisëmbë nöö na wan sëmbë sa feni ën tuu. Ma a nama a di kaakiti u Masa Gadu, nöö soni an dë di hën an sa du.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nöö hën Petuisi hakisi ën taa: “Wë nöö u wë Masa? Fa u disa hii soni ko ta waka a i baka aki, un wini fëën woo feni.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nöö hën Masa Jesosi piki taa: “Aai, sö a dë tuu. Ma nöö mi taki da unu taa di sëmbë di o disa hën baaa, ku ën sisa, ku ën mama, ku ën tata, ku ën mii, ku dee pandasi kamian fëën fu di a ko nama ku mi, ee nasö fu di a kë paaja di bunu buka u Gadu, nöö an o lasi e. ");
INSERT INTO srmNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Biga a o toona feni hii soni wan höndö toon baka: ee sisa, ee baaa, mama, tata, pandasi kamian, ku köndë tuu seei a o feni a di ten u dë aki, ma nöö a o kisi sitaafu tu o. Ma nöö a di ten di ta ko, nöö a o feni di libi u teego a Gadu. ");
INSERT INTO srmNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Nöö a di ten dë tu, sömëni sëmbë dee bi dë heima a goonliba aki o ko lagi sëmbë e. Nöö sömëni sëmbë dee an bi dë wan wojo soni a libisëmbë wojo aki, nöö de o ko fesima seei.” Nöö sö Masa Jesosi fan ku dee bakama fëën di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nöö di juu dë, Masa Jesosi nango a Jelusalen. Nöö a dë a pasi nango seei, ma nöö dee bakama fëën dë nëën baka ta waka, ma na ku wai. Biga de dë fëëëfëëë pantapanta. Söseei dee oto sëmbë ta waka ku de, deseei dë fëëëfëëë tu, ˻biga de ta sinti taa soni o pasa ku ën ala˼. Te wan pisi, hën a kai de tuwalufu bakama fëën a së, nöö hën a toona fan ku de möön kumafa a bi fan ku de a fesi kaa. ");
INSERT INTO srmNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A taa: “Womi, un haika e. Fa u nango a Jelusalen aki, nöö de o du ku Mi di ko Libisëmbë Mii aki e. Biga de o sei mi buta a dee Gaan Begima ku dee Sabima u Wëti maun, nöö de o tei mi tja go a kuutu te de kaba buta taa mi musu dëdë. Nöö baka u di dë, nöö de o tja mi go buta a dee oto köndë sëmbë dee ta tii di köndë i si aki maun. ");
INSERT INTO srmNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nöö de o mbei mi fa seei, de o tunta a mi, de o fon mi ku wipi. Te u kaba fëën de o kii mi. Ma nöö a di u dii daka nöö mi o toona weki baka ko ku libi e.” Nöö sö Masa Jesosi piki dee bakama fëën gbelin möön. ");
INSERT INTO srmNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wë nöö baka u di dë hën Jakobosi ku ën baaa Johanisi, dee mii u Zebedeosi, kai Masa Jesosi a së. De taa: “Masa o, u ko begi i wan soni aki.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Hën a hakisi de taa: “Wë andi un kë sö baa?” ");
INSERT INTO srmNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hën de taa: “Wë Masa, u kë begi i fii buta da u taa te i tei di könu kamian fii, nöö wan fuu o dë a i leti maun së, di otowan o dë a i töötömaun së ta heepi i tii di köndë. Nöö hën da di soni u ko begi i.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nöö hën Masa Jesosi piki de taa: “Ma kijoo, di soni un hakisi mi aki, ma un sabi andi un ta hakisi ö? Di kan de lai da mi u mi bebe aki, woon sa bebëën tu nö? Di sitaafu mi o tja aki, woon sa tjëën nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nöö hën de piki taki taa: “Aai Masa, woo sa tjëën.” Nöö hën a taa: “Awa, woon tja sitaafu tuu, ");
INSERT INTO srmNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ma fuun feni dee hei kamian dë, di dë ma sa paamusi unu e, biga an dë a mi. Gadu nöö a fika da, faa da dee sëmbë ku dee sëmbë dee a bi buta fu de feni sö wanlö hei kamian.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wë nöö di dee oto bakama ko jei taa sö de tu baaa naandë go suku sö wan hei kamian a Masa Jesosi, nöö hën de tei de fu hogi seei. ");
INSERT INTO srmNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma nöö hën Masa Jesosi kai hii de tuu makandi ko nëën, hën a taa: “Un haika e, kijoo. Dee goonliba hedima dee an ta biibi a Gadu, un sabi fa de ta libi kaa. De tuu ta kë pëë basi a oto sëmbë liba te dou a deseei liba tu. ");
INSERT INTO srmNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma nöö unu, na sö un musu libi e. Di fuunu di kë dë heima nöö a musu sakëën seei ta dini dee otowan fëën. ");
INSERT INTO srmNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nöö di sëmbë di kë ko di möön hei wan fuunu tuu, nöö a musu dë kuma saafu da dee otowan. ");
INSERT INTO srmNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Biga fa mi ko dë Libisëmbë Mii aki, ma ko u sëmbë musu dini mi e. Ma mi ko u mi dini sëmbë. Mi ko seei u mi paka mi libi kuma paima fu sömëni hia sëmbë sa ko bunu ku Gadu.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nöö hën Masa Jesosi ku dee bakama fëën ko a wan köndë de kai Jelikou tefa de nango. Nöö di de ta kumutu a di köndë, nöö wanlö hia sëmbë nango ku de. Di juu dë, nöö wan bookowojoma bi dë leti a di pasi bandja naandë sindosindo ta pidi möni. Di womi aki de kai Balitimeosi. A di töngö u de, hën kë taki, di mii u Timeosi. ");
INSERT INTO srmNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nöö hën di a ko jei taa di nëbaima u Nazalëti de kai Jesosi, hënseei ta pasa dë wante, nöö hën a seti ta bai ta kai ën taa: “Jesosi, na i da di bakamii u Könu Dafiti di bi o ko di Heepima nö? Gaantangi mi begi i o, saa mi, saa mi e!” ");
INSERT INTO srmNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nöö fa a ta bai dë, hën sömëni u dee sëmbë ta waka a Masa Jesosi baka naandë gandji dëën taa: “Womi, kabuka naandë e!” Ma nöö an haika de seei. Möönmöön a ta bai eti taa: “Jesosi, di bakamii u Könu Dafiti dë, saa mi, saa mi e!” ");
INSERT INTO srmNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nöö hën Masa Jesosi taanpu piii hën a taa: “Un kai di sëmbë ta bai dë da mi.” Nöö hën de go a di womi, de taa: “Söö. Be hati fii kötö e, womi. A ta kai i. Nöö fii hopo boo go.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nöö di a jei sö kaa, hën a feki ën liba koosu vau tuwë go ala, hën a hopo vu taanpu, hën de tjëën go dou a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nöö di Masa Jesosi si ën a taa: “Mati, andi i kë u mi du da i?” Hën a taa: “Mësitë, mi kë i heepi mi be mi ko ta si soni e.” ");
INSERT INTO srmNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Hën Masa Jesosi taa: “Wë fa i ta biibi a mi tjika aki, mati, nöö i feni heepi kaa e.” Nöö fa u mbei naandë, hën di womi ko si soni gbegedee, nöö hën a ta waka nango a Masa Jesosi baka mökisi ku dee oto sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wë nöö hën Masa Jesosi ku dee bakama fëën ta waka nango te de ko dou a di pisiwata ka dee köndë de kai Betifaigi ku Betania dë, ka di kununu de kai Oleifi dë tu. Hën da de ko zuntu ku Jelusalen. Nöö hën Masa Jesosi kai tu u dee bakama fëën ko nëën. Hën a taki da de taa: ");
INSERT INTO srmNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Un go langalanga a di köndë a u fesi dë e, nöö te un denda nëën, nöö woon si wan njönku buliki taitai a bandja pasi dë, di sëmbë an sindo nëën liba waka wan daka. Nöö un lusu ën tja ko da mi. ");
INSERT INTO srmNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Nöö ee wan sëmbë hakisi unu taa: ‘Faandi mbei un ta lusu di buliki?’ nöö un musu piki ën taa: ‘Masa abi ën fanöudu.’ ” Nöö sö Masa Jesosi manda de te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nöö hën de tu bakama naandë go a di köndë. Nöö fa de go dou, hën de si di buliki taitai a wan dööbuka a bandja pasi naandë tuu, leti kumafa Masa Jesosi bi taki. Hën de go ta lusu ën. ");
INSERT INTO srmNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nöö wanlö sëmbë bi dë taanputaanpu dë, nöö di de si taa sö de ta lusu di buliki, hën de hakisi de taa: “Andi un ta lusu di buliki u du?” ");
INSERT INTO srmNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hën de piki de leti kumafa Masa Jesosi bi taki da de taa: “Masa abi ën fanöudu.” Nöö fa de fan dë, hën dee sëmbë an tapa de möön. ");
INSERT INTO srmNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nöö hën de tja di buliki ko da Masa Jesosi hën de jabi koosu nëën liba. Nöö hën Masa Jesosi subi a di buliki liba. ");
INSERT INTO srmNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nöö hën sömëni sëmbë ko ta jabi koosu a di pasi liba, otowan ta denda a kapëë ta koti uwii tja ko tuwë a di pasi a Masa Jesosi fesi, nöö di buliki ta waka a dee uwii ku dee koosu liba. Bigi nöö de ta bigi Masa Jesosi sö. ");
INSERT INTO srmNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nöö fa de nango dë, sëmbë ta waka a fesi, sëmbë ta waka a baka, Masa Jesosi dë a mindi. Di juu dë, hii sëmbë ta bai taanga taa: “Hosana e! Hosana! Gadu dë ku di sëmbë aki!” Otowan ta bai taa: “Aai, Gadu dë ku di sëmbë di a manda ko a u aki!” ");
INSERT INTO srmNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Otowan taa: “Ke baa! Gadu o toona seti di tii u Könu Dafiti baka!” Otowan taa: “Aai, hosana! Di bai aki a musu go dou seei te a Masa Gaangadu köndë!” Sö dee sëmbë ta bai ta taki. ");
INSERT INTO srmNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nöö hën Masa Jesosi go dou a Jelusalen dendu gbolo, nöö hën a go wante a di Wosu u Masa Gadu nöö hën a denda nëën. Nöö hën a tuwë wojo luku hii sondi naandë finifini te a kaba. Ma nöö fu di a ko lati kaa an sa du soni möön, nöö hën hën ku dee tuwalufu bakama fëën hën de toona go a Betania go duumi. ");
INSERT INTO srmNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Di dobooko fëën hën de kumutu a Betania u toona go a Jelusalen baka, nöö hangi ko kisi Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nöö hën a tuwë wojo go te ala hën a si wan fuuta pau de kai figa, nöö a si taa a dë ku uwii seei tjentjen. Nöö hën a go suku njanjan nëën. Ma nöö di a go dou, an feni na wan kodo, biga an bi dë ten u di pau pai njanjan eti. ");
INSERT INTO srmNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nöö hën a taki da di pau taa: “Na wan ten sëmbë o feni njanjan a i njan möön e.” Nöö fa a fan dë, dee bakama bi haikëën nöö hën de pasa go. ");
INSERT INTO srmNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nöö hën Masa Jesosi ku dee bakama fëën ta waka te de go dou a Jelusalen, nöö hën de toona go wante a di Wosu u Masa Gadu möön. Nöö di de go dou, hën de si taa sëmbë sai naandë gidjii te a hia, so u de ta sei soni, so u de ta tooka möni da dee wakama dee ta ko naandë ta feni hia wini a de. Nöö hën wë di soni an bunu da Masa Jesosi seei, nöö hën a jaka dee sëmbë puu dë. A kandi dee tafa u dee sëmbë ta tooka möni naandë tuwë djolou a goon. Nöö i bi abi wanlö sëmbë ta sei pomba da sëmbë u de sa paka paima da Gadu, nöö hën Masa Jesosi kandi dee bangi u de tuwë tu. ");
INSERT INTO srmNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nöö hën a tapa pasi da dee sëmbë dee ta waka ta pasa a di keikipisi naandë kuma gaan pasi, be de an waka naandë möön ku dee soni de ta sei dë. ");
INSERT INTO srmNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nöö hën a bai dee sëmbë dë taa: “Wan bi jei fa Gadu Buku taki nö? A taa: ‘Mi wosu musu dë wan kamian u hii pei nasiön sëmbë ta ko ta begi Mi,’ ma uun tei ën ko buta wan kamian u ta tjubii fufuuma.” ");
INSERT INTO srmNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nöö hën dee Gaan Begima ku dee Sabima u Wëti ko jei taa sö Masa Jesosi du, nöö an bunu da de seei kwetikweti, nöö hën de ta suku wan fasi u de sa kisi ën kii. Ma da töku de fëëë biga wë hii mundu tei ën u gaan soni u di fasi fa a ta lei de soni u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nöö hën de fika dë te di ten sonu go a goon, hën Masa Jesosi ku dee bakama fëën toona kumutu a Jelusalen go. ");
INSERT INTO srmNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Di dobooko möön, hën Masa Jesosi ku dee bakama fëën ta toona go a Jelusalen baka. Te wan pisi hën de dou a di figa pau di a bi siba naandë, nöö hën dee bakama luku, de si taa dee uwii fëën ko laulau. Di pau dëdë seei te dou a lutu. ");
INSERT INTO srmNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nöö hën Petuisi ko mëni fa Masa Jesosi bi fan ku di pau, nöö hën a kai ën te a piki, a taa: “Mësitë, luku di figa pau di i bi siba jeside aki, a dëdë tuu o.” ");
INSERT INTO srmNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hën Masa Jesosi piki ën taa: “Awa, sö a dë tuu, nöö fëën mbei un musu ta biibi Gadu e. ");
INSERT INTO srmNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aai, mi taki da unu taa ee un ta futoou Gadu tuutuu söndö panta a unu hati, nöö sondi an o dë di Gadu an o sa du da unu. Biga ee i taki da di kununu aki sö taa be a hopo kumutu naandë go tuwëën seei a ze, nöö a o du sö tuu. ");
INSERT INTO srmNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Fëën mbei mi taki da unu taa, ee woon hakisi Gadu wan soni nöö un ta biibi a unu hati taa un abi di soni kaa, nöö woon kisi ën e.” ");
INSERT INTO srmNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nöö hën a fan ku de möön a taa: “Haika e, te un ta begi, nöö ee i ko mëni taa i ku sëmbë a’ soni, nöö i musu puu di sëmbë a bëë ufö i go dou ku di begi e, nöö Masa Gaangadu o puu i a bëë tu u dee hogi dee i ta du.  ");
INSERT INTO srmNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ma nöö ee wan ta puu sëmbë a bëë u dee hogi dee de ta du unu, nöö unu Tata a liba an o puu unu a bëë tu u dee hogi dee un ta du.” ");
INSERT INTO srmNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nöö hën de ko dou a Jelusalen awaa, nöö hën de toona go a di Wosu u Masa Gadu möön. Nöö fa Masa Jesosi ta waka ta lontu naandë, nöö hën wë a ko miti ku dee Gaan Begima ku dee Sabima u Wëti ku dee Gaan Womi. ");
INSERT INTO srmNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nöö hën de kai ën te a piki, de taa: “Wë u ko hakisi i wan sondi. Dee soni dee i du a di Keikiwosu aki, unsë i feni di leti fii du sö? Ambë da di sëmbë di manda i fii du sö wanlö soni?” ");
INSERT INTO srmNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nöö hën Masa Jesosi piki de taa: “Wë antoobi. Ma mi o hakisi unu wan sondi tu. Nöö ee un piki mi, nöö mi o piki unu ambë manda mi. ");
INSERT INTO srmNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","“Wë mi taki e, taa Johanisi di Dopuma, ambë bi mandëën faa dopu sëmbë: libisëmbë, naa Masa Gadu?” ");
INSERT INTO srmNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","Nöö di a hakisi de sö, hën de hai go a së go ta kuutu nango ta ko te de wei, de taa: “Ee u taa Gadu hën bi mandëën, nöö a o hakisi u ee faandi mbei wa bi piki ën? Ma nöö wa sa piki taa libisëmbë mandëën.” Nöö di soni mbei de taki sö, biga de fëëë lanti, fu di sömëni sëmbë bi biibi taa Johanisi bi dë wan tjabukama u Gadu tuutuu. ");
INSERT INTO srmNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nöö hën de toona ko a Masa Jesosi, hën de piki ën taa: “Wa sabi ambë bi mandëën e.” Nöö hën a piki de taa: “Ee wan sa piki mi, nöö miseei ma sa piki unu tu.” Nöö hën de disa di oto. ");
INSERT INTO srmNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nöö hën Masa Jesosi tei wan oto ta lei dee sëmbë a wödu fasi. A taa: “Wan womi bi dë, nöö hën a koti wan gaan goon fëën te a kaba, nöö hën a paandi di pau de kai doloifi a di goon, faa ta mbei win u bebe ku di njanjan fëën. Nöö hën a mbei wan sitonu peni te a kaba lontu di goon. Nöö hën a toona mbei wan goon mata ku sitonu ka de o ta fon di doloifi ta mbei di win. Nöö a baka u di dë, hën a mbei wan wakiti wosu tjongoo sö go a liba. “Nöö di a kaba u du dee lö soni dë kaa, nöö hën a buta di goon a wanlö sëmbë maun fu de musu ta wooko ën dëën. Nöö hën a kumutu dë go a wan oto köndë. ");
INSERT INTO srmNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Nöö hën a dë ala tee a sabi taa di juu dou u di fuuta lepi de mbei di win kaa. Nöö hën a kai wan futuboi fëën ko nëën, hën a mandëën taa be a go a dee wookoma go tei di fëën pisi u di win di a bi musu feni u di goon, tja ko dëën. ");
INSERT INTO srmNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","“Ma nöö di di futuboi dë naki te a go dou a di goon, nöö hën dee wookoma kisi ën hën de fon mën te a fon, nöö hën de mandëën go ku sösö maun. ");
INSERT INTO srmNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Nöö a baka u di dë, hën di womi toona manda wan oto futuboi go möön. Nöö di dee wookoma si di futuboi ko dou, hën de kisi ën, hën de fon mën a hedi te a fon nöö hën de toona du sömëni oto hogihogi soni ku ën te a tjika de. ");
INSERT INTO srmNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Nöö hën di goon masa manda wan oto futuboi go möön, hën de toona kisi di dë kii. Nöö hën a ta puu futuboi ta manda nango a dee wookoma kodo, so u de de ta fon, so u de de ta kii, ");
INSERT INTO srmNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","teee a fika wan kodo sëmbë tö di a sa manda möön, hën da di wan kodo womi mii fëën di a lobi te na soni. “Hën a taa: ‘Wë mi o manda di womi mii u mi aki go. A kandë te dee wookoma si ën nöö de sa abi lesipeki fëën fu di a dë miii u mi.’ ");
INSERT INTO srmNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nöö hën a manda di womi mii fëën go. Ma nöö di dee wookoma si di womi mii u di tata ta ko, nöö hën de taki da de na de taa: ‘Söö, ja ta si di womi mii u di sëmbë abi di goon aki ta ko naandë nö? Hën wë o kisi di gudu fëën tata a bakaten. Wë nöö un sabi nö? Un böö kisi ën kii, nöö di goon aki o fika a u maun.’ ");
INSERT INTO srmNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","“Nöö hën de kisi di womi mii, nöö hën de kii ën wantewante naandë, hën de puu ën a di djai dendu tuwë go a kapëë ala. De an bei ën seei.” ");
INSERT INTO srmNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nöö hën Masa Jesosi hakisi taa: “Wë nöö fa dee soni pasa dë, nöö di sëmbë di bi disa di goon da dee wookoma naandë, unfa i mëni taa a o du? Na a o manda sëmbë go kii dee hogihatima dë puu dë nö? Awa, nöö a o buta di goon fëën a oto sëmbë maun. ");
INSERT INTO srmNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Nöö wan bi lesi fa Masa Gadu Buku taki nö? A taa: Dee sëmbë ta mbei sitonu wosu dë, de si wan sitonu taa an bunu, nöö hën de tuwëën a kapëë. Ma nöö bakaten, hën di sitonu dë ko di mama posu u di wosu. ");
INSERT INTO srmNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Masa Gadu seei wë du di soni sö e, nöö a dë wan gaan foondo soni seei da u. Na sö di Buku taki ö?” ");
INSERT INTO srmNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nöö di Masa Jesosi fan sö hën a tapa dë. Ma nöö dee keikihedima u Dju dee sai naandë, hën hati u de boonu seei te de kë kisi ën kii. Biga de sabi limbolimbo taa de a fan tjökö ku di oto naandë. Ma nöö töku de fëëë taa lanti o du ku de ee de kisi Masa Jesosi a wajaa naandë. Nöö hën mbei de disëën, nöö hën de go. ");
INSERT INTO srmNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Baka u di dë, nöö hën dee keikihedima dë go puu wanlö sëmbë u di Faliseima kulupu, ku di u könu Helodi, hën de manda de go a Masa Jesosi go luku ee de sa kisi ën ku fan. ");
INSERT INTO srmNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nöö fa de ko dou dë, hën de kai ën te a piki, hën de taa: “Mësitë, u sabi taa i dë wan leti sëmbë di an ta ganjan sëmbë. Fa i dë aki nöö libisëmbë an sa ta hai i nango ta ko ku di u de pakisei. Biga ja a’ toobi ku di fa de ta pakisei soni. Nönö. Fa i sai dë, i ta lei sëmbë Gadu wöutu seei gbegedee kumafa Gadu kë u sëmbë musu sabi, nöö hën i si u ko a i aki ku wan hakisi. “Wë fa di gaan könu u Loomë köndë ta duwengi u fuu musu ta paka lanti möni aki, nöö unfa i feni fëën? ");
INSERT INTO srmNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A fiti fuu pakëën, naa an fiti? Unfa i si ën?” Ma nöö Masa Jesosi sabi taa bödjëë de ko ta pëë u de musu kisi ën, nöö hën a taki da de taa: “Baja, mi un kë kisi sö nö? Wë un da mi wan kpëngëlë möni i si.” ");
INSERT INTO srmNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nöö hën de tei wan kpëngëlë möni tja ko dëën, nöö hën a luku ën, a taa: “Ambë abi di në ku di fesi dë a di möni liba aki?” Hën de piki taa: “Wë di Gaan Könu u Loomë.” ");
INSERT INTO srmNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hën a taa: “Na sö nö? Wë nöö un da di Gaan Könu di soni di da fëën e, nöö un da Masa Gadu di soni di dë fëën.” Sö a piki de. Nöö fa a piki dë, nöö a foondo de seei, ˻biga de an bi mëni taa sö a bi o piki de a sö wan köni fasi˼. ");
INSERT INTO srmNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nöö hën sëmbë u di Saduseima kulupu ko a Masa Jesosi awaa. Wë nöö fa dee Saduseima sai dë, de an kë piki taa te wan sëmbë dëdë nöö a o toona weki baka. ˻Biga de an ta biibi seei taa di akaa u wan sëmbë ta fika ku libi baka u di a dëdë.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nöö fa de ko a Masa Jesosi dë, hën de kai ën te a piki, de taa: “Mësitë, u kë hakisi i wan soni aki. Wë i sabi fa Mosesi bi sikifi buta da u, taa ee wan womi tei wan mujëë ma nöö an pai ku di mujëë, nöö te a dëdë nöö wan baaa fëën musu hoi ën suwagi faa musu pai ku ën, be hën baaa böngö an kaba. Na sö a dë nö? ");
INSERT INTO srmNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Wë nöö a pasa sö taa de bi dë sëbën baaa, nöö hën wan u de tei wan mujëë. Te a dëdë an pai ku ën möönsö, ");
INSERT INTO srmNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","nöö hën wan oto baaa fëën hoi suwagi. Te di baaa naandë seepi dëdë tu, an pai ku di mujëë tu. Te dou di u dii, hën seepi ko dëdë tu, an pai ku di mujëë möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nöö sö a go tee dou dee sëbën baaa tuu. Hii de tuu libi ku di mujëë ma na wan kodo pai miii ku ën möönsö. Baka u di dë, hën di mujëë seepi ko dëdë tu. ");
INSERT INTO srmNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Wë nöö di de ta bai taki taa te wan sëmbë dëdë nöö a o toona weki baka, wë nöö u kë hakisi i wan soni. Te sëmbë weki baka a dëdë, undi u dee sëbën baaa naandë o abi di mujëë? Biga de tuu bi libi ku ën.” Nöö sö dee Saduseima hakisi Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hën a piki de taa: “Wë awa mi jei, ma di hakisi fuunu föutu tumisi fu di wan sabi Masa Gaangadu Buku, hën tu wan sabi di kaakiti di Masa Gadu abi tu. ");
INSERT INTO srmNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Biga te sëmbë weki baka a dëdë kaa, nöö manu ku mujëë soni an o dë möön e. Womi an o tei mujëë möön, mujëë an o tei manu möön tu, ma de o dë kuma dee basia u Gadu Köndë. ");
INSERT INTO srmNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Ma nöö boiti u di dë, wan jei fa Mosesi bi sikifi buta a di Buku nö? Di ten a bi si di faja ta kisi a di uwii ma di uwii an ta tjuma, nöö hën Gadu fan ku ën. A taa: ‘Mi da di Gadu di dee gaan sëmbë fii ta begi: de Abahamu, Isaki, Jakopu sö.’ Na sö a taki nö? ˻Wë nöö fa a fan dë, an taa mi bi dë di Gadu u dee lö sëmbë dë e, ma a taa mi da di Gadu u de.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wë nöö Masa Gadu an dë Gadu u wan sëmbë di an dë ku libi e. ˻Nöö hën da de Abahamu sö dë ku libi a wan kamian eti, hii fa de bi dëdë a sinkii fasi gaanduwe kaa.˼ Nöö hën mbei mi taa wan a’ leti seei a di soni un hakisi dë.” Nöö sö Masa Jesosi piki dee Saduseima di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wë nöö fa Masa Jesosi ku dee Saduseima fan te de kaba naandë, nöö wan Sabima u Wëti bi sai leti naandë ta haika. Nöö di a si taa Masa Jesosi piki de sö bunu hën a hakisi ën taa: “Mësitë o, dee hia wëti Gadu buta da u fuu ta hoi aki, undi u de da di möön hebi wan u de tuu?” ");
INSERT INTO srmNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nöö hën a piki ën taa: “Di möön hebi wan u de nö? Wë hën da disi: Un dee sëmbë u Isaëli aki, un haika e. Masa Gaangadu di Gadu fuunu, hën wanwan tö da Masa u mundu. ");
INSERT INTO srmNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nöö un musu lobi ën ku hii unu hati ku hii unu akaa ku hii unu pakisei, te dou ku hii di kaakiti di un abi. ");
INSERT INTO srmNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nöö di otowan dë sö taa, I musu lobi oto sëmbë leti kumafa i lobi i seei. Nöö de tu wëti aki, de da dee möön hebi wan u dee wëti u Gadu tuu.” ");
INSERT INTO srmNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nöö hën di Sabima u Wëti piki Masa Jesosi taa: “Aai Mësitë, fa i si i taki dë, sö a dë tuu. Biga Masa Gaangadu hën tö nöö da Gadu u mundu, otowan an dë möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nöö hën nöö fuu lobi ku hii u hati ku hii u pakisei ku hii u akaa, ku hii di kaakiti di u abi. Wë nöö söseei u musu lobi oto sëmbë leti kumafa u lobi u seei tu. Wë nöö misikuma ee wan sëmbë i ta libi sö kaa, nöö di dë dë möön bunu möön leki hii dee mbeti i ta tja ko ta tjuma da Masa Gaangadu, ku hii dee oto soni u ta tja ko ta tuwë dëën, na sö nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nöö di Masa Jesosi jei fa di womi piki ku fusutan, nöö hën a taki dëën taa: “Aai mati, misikuma ja dë longi poi fii sa ko a di Tii u Masa Gaangadu dendu.” Wë da sö Masa Jesosi fan ku di Sabima u Wëti naandë. Nöö di dee hia sëmbë jei fa a ta piki ku fusutan tjika dë, nöö na wan u de abi hati u hakisi ën soni möön. ");
INSERT INTO srmNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nöö fa Masa Jesosi dë a di Wosu u Masa Gadu ta lei sëmbë naandë, te wan pisi hën hënseei bia hakisi wan soni. A taa: “Dee sëmbë, faandi mbei dee Sabima u Wëti ta lei unu taa di Paamusi Könu o dë wan baka mii u Dafiti nöö? ");
INSERT INTO srmNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Biga wë di Akaa u Gadu seei bi ko a Dafiti liba. Hën a taki soni u di Paamusi Könu di o ko. A taa: Masa Gadu taki da mi Masa taa: ‘Ko sindo a mi letisë maun aki, u tee mi buta hii dee felantima fii a i basufutu.’ Na sö Dafiti sikifi nö? ");
INSERT INTO srmNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Wë nöö ee Könu Dafiti ta kai di Paamusi Könu Masa fëën, nöö unfa a sa dë hën bakamii nöö?” Nöö sö wan soni Masa Jesosi hakisi dee sëmbë naandë, ma de an saanfa u piki. ˻Nöö fa a fan köni tjika dë te a tai hii sëmbë te dou ku dee hedima u Dju,˼ nöö a ta suti da dee sösö sinkii sëmbë naandë tee na soni. ");
INSERT INTO srmNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nöö hën a fan go möön longi. A bai dee sömëni sëmbë naandë taa: “Un haika e, dee sëmbë. Un musu mëni unu seei bunu ku dee Sabima u Wëti e. Aai. Biga fa i si de sai dë, nöö de lo’ u ta waka ta poolo a lanti dendu ku dee gaan langa djakiti u de zëëë, be hii sëmbë musu ta saka ta da de odi a wan gaan lesipeki fasi. ");
INSERT INTO srmNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","De lobi u ta sindo a dee möön gaan hedima kamian a dee keiki fuunu. Te de go a wan sëmbë wosu u de go njan, nöö de nango ta sindo a dee möön gaan heima bangi. Sö de ta mbei de seepi u bumbuu sëmbë tjika. ");
INSERT INTO srmNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Ma na bumbuu sëmbë de dë e. Biga fa i si de sai dë, nöö ee de si wan mujëë manu fëën dëdë a fika tjököö a ganda naandë, nöö de o ko njan dee gudu fëën wosu puu nëën maun fiaa seei. Nöö ku ën sö de o ta ko ta taanpu a lanti wojo ta begi wanlö gaan langa begi u de, ta mbei deseei bumbuu sëmbë a sëmbë wojo. “Wë nöö mi taki da unu taa dee lö sëmbë i si naandë, de o kisi wan gaan sitaafu a Gadu maun e, te a o ko kuutu libisëmbë.” Sö Masa Jesosi bai dee sëmbë naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nöö fa Masa Jesosi ku dee bakama fëën dë a di gaan keikiwosu naandë, te wan pisi nöö hën a waka go sindo zuntu ku di kamian ka de ta tja möni ta ko ta tuwë da Gadu a di keikiwosu. A ta luku fa de ta tuwë dee möni. Nöö di ten naandë, nöö dee guduma ta tja möni ta ko ta tuwë seei djolodjolo sö. ");
INSERT INTO srmNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te wan pisi hën wan pooti mujëë waka ko naandë. Di mujëë aki, hën manu bi dëdë disëën, nöö hën a ko tuwë tu kpëngëlë möni da Gadu, an dou wan bësënsi seei. ");
INSERT INTO srmNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nöö hën Masa Jesosi kai dee bakama fëën te de piki, a taa: “Un si di pooti mujëë dë nö? Hën tuwë di möön gaan hia möni möön hii de tuu da Gadu e. Aai. ");
INSERT INTO srmNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Biga fa i si dee guduma ta tja möni u de ta ko ta tuwë dë, nöö wan pikiwan nöö de ta tuwë u dee gaan hia wan de abi. Ma nöö di mujëë naandë, di soni a abi faa tei heepi ën seei, hën i si a tei tuwë tuu dë kaa. Nöö fëën mbei mi taki da unu taa hën tuwë di möön hia möni.” Nöö sö Masa Jesosi taki da dee bakama fëën di daka dë. ");
INSERT INTO srmNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nöö hën Masa Jesosi ku dee bakama fëën kumutu a di Wosu u Masa Gadu ko kai a döö. Nöö hën wan u dee bakama kai ën te a piki, a taa: “Mësitë o, ja si fa dee wosu u di keikipisi aki waiti nö? Luku fa dee sitonu u de bigi!” ");
INSERT INTO srmNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nöö hën a piki taa: “Sö a dë tuu o, ma fa i ta si dee wosu dë sitampusitampu aki seei, ma nöö mi taki da unu taa wan daka o dou, hii dee sitonu i si aki tuu o booko kai paaja fanjanfanjan sö. Na wan u de o fika oto a oto liba möön e.” Sö a piki de. ");
INSERT INTO srmNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nöö hën de kumutu naandë waka go a Oleifi Kununu. Nöö hën Masa Jesosi go sindo a di kununu bandja ta luku go a Jelusalen, nöö a ta si di Wosu u Masa Gadu seei gbegedee. Te wan pisi hën Petuisi, ku Jakobosi, ku Johanisi ku Andiasi hën de ko nëën. Hën de taa: ");
INSERT INTO srmNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Wë Masa o, fa i bi taki di booko u di Gaan Keikiwosu di u bi dë ala, un juu dee lö soni dë o pasa? Un maaka joo da u fuu sa sabi taa di ten dë dou?” Sö de hakisi ën. ");
INSERT INTO srmNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nöö hën a piki de taa: “Awa, a dë fuun dë ku mëni fëën tuu, fu sëmbë an musu ganjan unu. ");
INSERT INTO srmNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Biga mi taki da unu taa sömëni sëmbë o hopo tei mi në ta taki taa de da di Paamusi Könu kaa. Nöö ku di fan u de dë, de o ta ganjan sömëni sëmbë hai tja ko a de së. Hën mbei un musu mëni unu seei e. ");
INSERT INTO srmNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Söö. Wë nöö di ten dë, nöö woon ta kisi njunsu taa gaan feti ta pasa a sömëni köndë u goonliba aki. Nöö te un jei sö, nöö an musu buuja unu e, biga dee lö soni naandë tuu musu pasa. Ma nëën da di kaba u goonliba eti e. ");
INSERT INTO srmNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mi taki da unu taa wan nasiön sëmbë ku wan oto nasiön sëmbë o ta hopo ta feti ku deseei. Wan könu o manda dee sodati fëën u de ta miti ta feti ku dee sodati u wan oto könu. Goon o ta seki ta jabi a kamiankamian, gaan hangi o ko a sömëni köndë ta kii sëmbë. Nöö fa dee lö soni dë o pasa, de o dë leti kuma te bëë ta njan wan mujëë, juu fëën zuntu faa pali. ˻Sö dee fuka u kai dë o lei taa di juu zuntu fu di goonliba aki musu kaba.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Söö. Nöö di juu dë, un musu luku bunu ku unu seei taa un dë tololoo a Gadu pasi. Biga sëmbë o ta kisi unu tja go a kuutu e, de o ta fon unu a dee keikiwosu fuunu. De o ta tja unu go a dee gaama ku dee könu u de kuutu unu. Dee lö soni dë tuu de o du ku unu fu di un ta nama ku mi hedi. Ma nöö töku a bunu o, biga a di fa dë woon kisi okasi fuun musu taki soni u mi da de. ");
INSERT INTO srmNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nöö mi taki e, taa hii nasiön sëmbë u goonliba musu ko jei di bunu njunsu u Gadu, biga te a dë sö kaa ufö di kaba u goonliba sa dë. ");
INSERT INTO srmNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Söö. Nöö haika. Te sëmbë kisi unu tja go a kuutu fu mi hedi kaa, nöö wan musu sai dë ta booko hedi taa: ‘Andi woon taki ee?’ Nönö, un fan go nöö. Biga na unu o fan ma di juu dë di Akaa u Gadu seepi o da unu andi fuun taki. ");
INSERT INTO srmNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Nöö di ten dë sëmbë o hogi e, dee sëmbë. Biga wan baaa womi o tei ën baaa tja go könku u de kii ën, söseei wan tata o könku ën mii da de u de kii. Dee mii o ta biinga u puu dee gaan sëmbë u de a de liba, de o ta könku de da sëmbë seei u de kii. Sö libisëmbë o hogi tjika e. ");
INSERT INTO srmNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Di juu dë, hii sëmbë o buuse unu fu di un nama ku mi hedi. Ma nöö di sëmbë di o tai hati fika a di pasi u Gadu go dou, nöö hën o feni di libi u teego a Gadu.” Nöö sö Masa Jesosi fan ku dee bakama fëën di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wë nöö gaanduwe a fesi kaa wan tjabukama bi taki u wan gaan hogi soni o ko pasa a di Gaan Wosu u Masa Gaangadu dendu, nöö di sëmbë di ta lesi Gadu buku nöö be a buta pakisei faa fusutan andi di soni aki kë taki. Hën Masa Jesosi fan ku dee bakama fëën go möön longi, a taa: “Te un si di Gaan Hogi Soni ko taanpu a di kamian ka an bi musu dë ta poi Masa Gaangadu tjina, nöö aan soni u taki möön. Un dee sëmbë a di pisiwata u Judea aki musu kule go tjubi a dee gaan kununu liba e. ");
INSERT INTO srmNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Ee wan sëmbë dë nëën liba wosu a baiko dë, nöö a musu saka kai a goon wante kule go ka a sa go. An musu denda a wosu go tei soni. ");
INSERT INTO srmNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ee wan sëmbë dë a goon dendu ta wooko, a musu kule go wante ka a o go. An musu go tei koosu a gangasa seei. ");
INSERT INTO srmNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nöö mi taki da unu e, taa dee mujëë dee dë ku bëë, ku dee o dë ku miii a maun, a o dë gaan fuka soni da de o. Aai. ");
INSERT INTO srmNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nöö un musu begi Gadu be di soni aki an musu pasa a gaan kötö ten, nasö a gaan tjuba ten. ");
INSERT INTO srmNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Biga mi taki da unu taa fu sensi Masa Gadu mbei goonliba, nöö di lö gaan fuka dë an bi ko pasa wan daka eti, nöö baka u di ten naandë nöö an o pasa möön tu. ");
INSERT INTO srmNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Nöö hën mbei mi taki da unu taa ee Masa Gaangadu an sati di ten puu hafu u dee daka naandë, nöö na wan sëmbë o fika ku libi möön e. Ma fu dee sëmbë dee Masa Gaangadu tei ko sëmbë fëën, fu de hedi mbei an o disa di hogi naandë go dou, ma a o koti ën hafu. ");
INSERT INTO srmNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Söö. Nöö a di ten naandë, ee de ko taki da unu taa di Paamusi Könu dë a sö wan kamian, wan musu piki e. ");
INSERT INTO srmNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Biga sömëni sëmbë o ta hopo ta mindi soni taa de da di Paamusi Könu, de o ta mindi soni taa Gadu hën ta wooko a de liba, nöö de o ta du gaan foondo wooko seei. Nöö a sö wan fasi de o ta biinga u kisi dee sëmbë u Gadu ta ganjan puu nëën pasi, ee de sa. ");
INSERT INTO srmNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hën mbei mi taa un musu ta luku bunu ku unu seei. “Un si, mi taki hii soni da unu a fesi kaa e, nöö be un köni.” ");
INSERT INTO srmNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nöö hën Masa Jesosi taki möön a taa: “Nöö baka u di gaan fuka ten u taki dë, nöö wanlö oto gaan soni o ko pasa tu e, kumafa di tjabukama bi taki a fesi. A taa: Di sonuwojo o dungu kankan, nöö di libawojo an o tuwë limbo möön tu. ");
INSERT INTO srmNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dee teeja dee dë a liba ala, de o ta kumutu a de kamian ta puu ta kai. Hii kaakiti u mundu kaa o ta seki. ");
INSERT INTO srmNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nöö di juu dë, sëmbë o si Mi di ko Libisëmbë Mii aki kumutu a liba ala ta ko a dee wöluku dendu. Nöö ku gaan kaakiti mi o ko e, ku waiti seei, ta koti faja ta ko. ");
INSERT INTO srmNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nöö di ten naandë nöö mi o manda dee basia u mi go ta pii hii dee sëmbë dee mi tei ko sëmbë u mi kaa kumutu a hii dee peipei kamian u mundu ka de dë tuu, tja ko a mi. ");
INSERT INTO srmNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nöö fa mi ta fan ku unu aki, nöö un tei wan lei a dee figa pau u di köndë aki. Te i si taa de ta buta njunjun uwii, nöö i sabi taa deewei zuntu kaa, na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nöö söseei a dë ku dee soni dee mi ta taki aki. Te i ta si taa de ta pasa sö kaa kumafa mi taki de dë, nöö un musu sabi taa di juu dou fu Mi di ko Libisëmbë Mii aki musu toona ko a goonliba. Mi dë leti a baka huku naandë ta ko e. ");
INSERT INTO srmNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nöö mi taki da unu taa dee lö sëmbë u di ten u dë aki, de an o dëdë kaba tuu bifö dee soni dee i jei mi taki aki o ko pasa. ");
INSERT INTO srmNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Nöö fa i si dee soni u di goonliba aki ku dee u mundu sai dë, nöö de tuu sa pasa go kaba a sösö e. Ma dee wöutu dee mi ta konda da unu aki, nöö de an o kaba a sösö möönsö. Sö de dë tuutuu soni tjika.” ");
INSERT INTO srmNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nöö hën a taa: “Di juu ku di ten di mi o toona ko a goonliba, na wan sëmbë sabi ën e. Dee basia u Masa Gaangadu köndë an sabi ën, nöö miseei di ko Libisëmbë Mii aki an sabi ën tu. Gadu u Tata wanwan tö nöö sabi di juu ku di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hën mbei un musu dë kabakaba këëë ta watji mi. Biga wan sa na un juu mi o ko. ");
INSERT INTO srmNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Mi o kondëën da unu a wan fasi aki taa a dë leti kuma wan bigima di o go a oto köndë go waka. Nöö hën a kai dee wookoma fëën go buta wooko a de maun te a kaba u de ta du, hiniwan sëmbë ku ën wooko. Nöö hën a fan ku di sëmbë ta watji a di dööbuka taa: ‘I musu dë kabakaba ta luku mi e.’ ");
INSERT INTO srmNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“˻Nöö mi wë da di bigima mi taki dë.˼ Nöö un musu dë kabakaba ta luku mi. Biga wan o sabi di ten nasö di juu di mi o ko e, ee a sapate buka, ee a gaan ndeti, ee a ganian kanda, ee te kamian ta limbo, wan o sabi. ");
INSERT INTO srmNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Te fii sabi nöö mi dou kaa, nöö na be a dë taa i dë kuma i ta duumi di juu dë e. ");
INSERT INTO srmNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Nöö sö e. Fa i si mi ta fan ku unu aki, nöö sö nöö mi ta fan ku hii sëmbë. Un musu dë kabakaba ta luku mi e, dee sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wë nöö fa Masa Jesosi ta fan ku dee bakama fëën dë, nöö a fika tu daka nöö de o njan di gaan piizii daka u dee Dju de kai Pasika. ˻A di daka dë, de ta mëni fa dee gaan sëmbë u de bi kumutu a saafu a Egepiti köndë,˼ nöö de ta njan wan pei bëëë de ta jasa söndö sooda. Söö. Nöö di juu dë, dee Gaan Begima ku dee Sabima u Wëti sai dë ta watji Masa Jesosi u de kisi kii a wan köni fasi. ");
INSERT INTO srmNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ma de ta kuutu ku deseei taa: “Wa musu kisi ën a di gaan daka e, biga ee nasö dee hia sëmbë o mbei toobi ku u, nöö di köndë o seki poi.” So de ta taki. ");
INSERT INTO srmNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nöö di ten dë, Masa Jesosi dë a di köndë de kai Betania a di wosu u wan womi de kai Simon. Di womi aki bi abi tjinasiki, nöö nëën wosu Masa Jesosi ku dee bakama fëën dë ta njan. Te wan pisi hën wan mujëë waka ko dou naandë. A dë ku wan sitonu bata nëën maun, ku wan sumëë suti fatu nëën dendu. Di fatu aki, de mbei ën ku di lutu u wan pei uwii nöö a dii te na soni. Nöö fa di mujëë ko denda a wosu dë, nöö hën a waka tololoo go a Masa Jesosi, nöö hën a booko di bata a buka naandë kpö, hën a ta tutu di fatu a Masa Jesosi hedi te hii di fatu kaba këëë a di bata. ");
INSERT INTO srmNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma nöö fa a du dë, nöö so u dee sëmbë sai naandë an tei di soni u bunu seei, nöö hën de ta guunjëën taa: “Faandi mbei a poi di fatu sö u du baa? Jee? ");
INSERT INTO srmNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Biga di fatu dë, ee de bi sei ën, nöö wan hii jaa möni a bi o puu, nöö de bi sa tei di möni paati da dee pootima u di köndë. Nöö hën a poi ën sö.” Sö de ta guunjëën. ");
INSERT INTO srmNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Masa Jesosi bai de taa: “Un disa di mujëë e. Andi mbei un ta guunjëën u du? Mi taki da unu taa wan gaan bumbuu soni a du da mi aki. ");
INSERT INTO srmNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Biga ee un kë da dee pootima möni, nöö un sa ta da de hiniwanten. Ma mi, ma o dë ku unu aki fu nöömö e. ");
INSERT INTO srmNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nöö fëën mbei di mujëë aki ta du andi hën a sa du da mi wante. Un si? Biga fa a du di soni aki, nöö a du ën da di dëdë mi o dëdë abiti möön, leti kumafa de ta tuwë fatu a sëmbë sinkii u de tja go bei. ");
INSERT INTO srmNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Nöö mi taki gbelin seei da unu taa te de ta tja di bunu buka u Gadu ta paaja a goonliba da sëmbë, nöö de o ta taki di soni di di mujëë du aki nöömö. De an o fëëkëtëën möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nöö fa Masa Jesosi fan naandë kaa, nöö hën di bakama fëën de kai Judasi Isikaliotu, nöö hën a kumutu a dee otowan dendu naandë, nöö hën a waka go tololoo a dee Gaan Begima, dee felantima u Masa Jesosi. Hën a go taki da de taa a sa heepi de u de kisi Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nöö di de jei sö nöö de wai e, nöö hën de paamusi ën taa de o pakëën ee a du sö. Nöö fu kumutu a di ten naandë, nöö di Judasi aki ta suku wan okasi nöömö faa sa buta Masa Jesosi a dee Dju hedima naandë maun. ");
INSERT INTO srmNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nöö baka u di dë, hën di fosu daka u di Pasika piizii dou. Nöö a di daka dë, nëën de ta njan di bëëë de ta mbei söndö sooda. Nöö de ta kii wan sikapu u de njan tu, nöö ku di sikapu dë de ta mëni fa Gadu bi puu de a saafu a fesiten. Nöö hën mbei de ta seeka da di daka dë seei gaanfa. Söö. Nöö hën dee bakama u Masa Jesosi hakisi ën taa: “Masa, naasë i kë fuu musu seeka fuu njan di daka?” ");
INSERT INTO srmNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hën a kai tu u de taa: “Un haika, mi kë manda unu go a Jelusalen ganda. Nöö fa woon nango te un go dou dë, nöö woon si wan womi ta waka ta ko ku wan djogu wata, nöö un faakëën. ");
INSERT INTO srmNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nöö te un si taa a denda a wan wosu, nöö woon go fan ku di sëmbë abi di wosu taa ee naasë di kamba dë di di Mësitë ku dee bakama fëën musu ko njan di daka. ");
INSERT INTO srmNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nöö te un hakisi ën sö kaa, nöö a o lei unu wan gaan kamba a di wosu a liba, ka hii soni dë di un abi fanöudu. Nöö di kamba dë, hën un musu seeka te un kaba e.” Nöö sö Masa Jesosi manda dee bakama fëën, nöö hën de go. ");
INSERT INTO srmNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nöö di de naki te de go dou a di köndë, nöö hën de si hii sondi leti kumafa a bi taki da de, nöö hën de seeka te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nöö hën di sapate buka, nöö hën Masa Jesosi ku dee oto bakama ko dou a di wosu. ");
INSERT INTO srmNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hën de go sindo a tafa u de njan. Te wan pisi hën Masa Jesosi kai de te de piki, a taa: “Un haika e, dee sëmbë. Wan fuunu ta njan ku mi aki o könku mi e.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Fa a taki dë, a booko dee bakama hati seei, hën de ta hakisi ën wan fu wan taa: “Masa, mi a o sa dë nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hën a toona piki de taa: “Mi taki seei gbelin da unu taa wan fuun dee tuwalufu i si ta nama di bëëë ku mi a di wan kodo baafu paabi aki, o du sö ku mi e. ");
INSERT INTO srmNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nöö a o pasa ku mi leti kumafa a bi sikifi a Masa Gadu buku kaa, taa di Sëmbë di o ko Libisëmbë Mii musu dëdë. Ma nöö mi taki da unu taa helu u di sëmbë di o könku mi e. A bi sa möön bëtë de an bi pali ën ko a di goonliba aki wan daka.” Sö Masa Jesosi fan ku de te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nöö fa de ta njan makandi dë, te wan pisi hën Masa Jesosi tei wan bëëë nöö hën a da Gadu tangi te a kaba, nöö hën a booko ën. Nöö hën a langa da dee bakama fëën, taa: “Disi da di sinkii u mi e. Un tei njan.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Söseei a tei di kan ku di win nëën dendu, hën a da Gadu tangi te a kaba. Hën a langëën da dee bakama taa: “Un bebe tjëntjën te lontu ko kai.” Hën de bebëën lontu dou te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nöö hën a taa: “Fa i si un bebe di win aki, hën da di buuu u mi di o kai a goon ˻fu Gadu sa mbei wan njunjun buka ku libisëmbë˼. Biga fa mi o dëdë aki, hën o paka puu sömëni hia sëmbë a Gadu bëë u dee hogi du u de.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nöö hën a taa: “Mi taki da unu tuutuu seei, taa ma o bebe di win a di fasi aki möön e. Biga tee i si mi bebëën möön, nöö Gadu ko ku di Njunjun Tii fëën a libisëmbë mindi.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nöö baka u di dë, hën de kanda wan kanda te de kaba da Gadu tangi, nöö hën de kumutu naandë. Nöö hën de nango a di kununu de kai Oleifi Kununu. ");
INSERT INTO srmNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nöö fa Masa Jesosi ku dee bakama fëën dë a pasi nango dë, hën a kai de te de piki, a taa: “A di ndeti aki hii unu tuu o paaja go disa mi fiaa. A o pasa leti kumafa a sikifi a di Buku u Gadu, taa de o fon di sikafuma nöö dee sikafu o paaja fanjanfanjan go u de.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nöö hën a taa: “Ma te mi weki baka a dëdë, nöö mi o waka a unu fesi go a Galilea e. Ala mi ku unu o toona miti.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nöö hën Petuisi piki taa: “Masa, ee dee otowan aki tuu disa i go seei ma mi, ma o disa i möönsö e.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma nöö Masa Jesosi toona piki ën taa: “Womi, haika. Mi taki da i taa a di ndeti aki ganian an o kanda dou tu pasi bifö joo fia dii pasi taa ja sabi mi a goonliba wan daka.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wë nöö Petuisi an sa jei di soni dë. Hën a taa: “Ambë, Masa! Ee u mi dëdë ku i seei, nöö mi dë kabakaba kaa. Ma sa piki wan daka taa ma sabi i e.” Nöö sö nöö dee otowan tuu ta piki tu. ");
INSERT INTO srmNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nöö hën Masa Jesosi ku dee bakama fëën nango te de go dou a wan kamian de kai Gëtiseimani. Nöö hën a taki da de taa: “Un dë aki ta luku mi e. Mi o go begi ala.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma nöö a tei Petuisi ku Johanisi ku Jakobosi fu de musu go ku ën möön fundu a di kamian. Te wan pisi hën Masa Jesosi ko dë fukafuka te na soni. ");
INSERT INTO srmNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nöö hën a fan ku de dii bakama naandë taa: “Wan gaan fuka ko a mi liba seei tee kuma mi sa dëdë. Nöö un tan aki ufö ta da mi taanga e.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nöö hën a waka go wan pikiwan möön longi, nöö hën a tuwëën seei a goon. ");
INSERT INTO srmNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nöö hën a begi Masa Gaangadu taa: “Ke Taata o, mi sabi taa i sa du hii soni. Nöö di kan di i lai da mi u mi bebe aki, nöö a hebi da mi o. Nöö mi begi i, ee a sa, nöö be i tei ën puu a mi. Ma nöö fa mi fan aki seei, ma na du kumafa mi kë e, ma du kumafa i kë.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nöö di a begi sö te a kaba nöö hën a toona ko a de dii bakama fëën, hën a si taa de duumi piii. Nöö hën a kai Simon Petuisi te a piki, a taa: “Simon, duumi i ta duumi sö nö, womi? Wan sa dë ku wojo di wan kodo juu aki ta da mi taanga nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hën a toona taa: “Be un dë ku wojo ta begi e, dee sëmbë, be di didibi an wini unu. Ma mi sabi taa hati fuunu kë du kumafa a fiti, ma sinkii fuunu an taanga sö.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nöö fa a taki dë, hën a toona go a di begi baka. A begi di wan seei begi di a bi begi te a kaba, ");
INSERT INTO srmNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","nöö hën a toona ko a dee bakama fëën möön. Awaa seei de dë ta duumi, biga duumi nöö hebi a de wojo sö. Nöö di a weki de, nöö a ko bigi da de te de an saanfa u fan ku ën möön. ");
INSERT INTO srmNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nöö hën a toona go begi te a kaba di u dii pasi, nöö hën a toona ko a de möön. Hën a taa: “Duumi nöö un ta duumi ta böö sinkii fuunu sö nö baa? Aai. Wë di juu dou e, u de buta Mi di ko Libisëmbë Mii aki a dee takuhatima maun. ");
INSERT INTO srmNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Biga di sëmbë di sei mi, nöö a dou kaa. Nöö un hopo boo go.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wë nöö Masa Jesosi an kaba u fan seei, nöö hën Judasi dou. Hii fa a bi dë wan u dee tuwalufu bakama u Masa Jesosi seei, ma töku a ko dou ku wanlö hia sëmbë. De dë ku kodjo ku ufangi a maun u de ko kisi Masa Jesosi. Dee Gaan Begima, ku dee Sabima u Wëti, ku dee Gaan Womi, de wë manda de. ");
INSERT INTO srmNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wë nöö Judasi bi mbei buka ku dee sëmbë dë kaa taa: “Te i si mi bosi wan sëmbë, nöö di sëmbë dë hën fuun kisi tei e. Nöö un musu panjëën taanga, fu an sa kumutu.” Sö Judasi bi fan ku dee sëmbë a fesi. ");
INSERT INTO srmNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nöö di de ko dou, nöö hën Judasi waka go miti ku ën nöö hën a taa: “Odi o, Mësitë.” Nöö hën a baasëën bosi. ");
INSERT INTO srmNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Fa u mbei naandë, hën dee sëmbë kisi Masa Jesosi gbalau panjan gingin wante. ");
INSERT INTO srmNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma nöö wan u dee bakama dë a dendu naandë hai ën ufangi valau, hën a djafu wan futuboi u di Kaba Hei Begima jesi belim puu tuwë a goon naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nöö hën Masa Jesosi hakisi dee sëmbë dee ko naandë taa: “Dee sëmbë, a mi liba un ko sö nö, ku pau ku kodjo ku ufangi, kuma mi da wan sëmbë ta booko di köndë nö? ");
INSERT INTO srmNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wë nöö un bi ta si mi hiniwanten a di Wosu u Masa Gaangadu ta lei sëmbë Gadu wöutu, nöö unfa wan bi kisi mi ala? “Ma mi sabi taa fa un ta du aki, nöö a ta pasa leti kumafa a bi sikifi a Gadu Buku kaa.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Fa u mbei naandë, hii dee bakama u Masa Jesosi paaja kule go disëën fiaa. ");
INSERT INTO srmNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma nöö wan kijoo bi dë a de dendu naandë, a bi dë ku wan gaan koosu nëën sinkii lolulolu, nöö hën dee felantima tuwë maun kisi ën wante. ");
INSERT INTO srmNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nöö hën a feki di gaan koosu valau puu nëën sinkii disa, hën a kule pënëpënë go. ");
INSERT INTO srmNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wë nöö fa dee sëmbë bi ko kisi Masa Jesosi naandë, nöö hën de tjëën go tee a di wosu u di Kaba Hei Begima. Nöö di ten naandë hii dee hedima u Dju tuu, dee Gaan Begima ku dee Gaan Womi ku dee Sabima u Wëti, sö de tuu hai ko makandi naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Di juu dë Petuisi bi dë te a baka ala ta waka sapisapi ta ko. Nöö hën a ko dou a di djai dendu naandë, nöö hën a go sindo ku dee wakitima bi sai dë ta këndë faja ku de makandi. ");
INSERT INTO srmNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nöö di ten naandë, dee Gaan Begima ku hii dee kuutuma u dee Dju sëmbë, nöö de seti ta kuutu a Masa Jesosi liba kaa. Nöö de ta suku u tja kaagi fëën ko a fesi u de sa feni wan soni fu de sa buta taa a musu dëdë, ma de an sa feni soni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Biga hii fa dee sëmbë ta tja sömëni soni ko ta mindi dëën, ma de an ta kai a di wan baaku möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Te wan pisi hën wanlö sëmbë hopo taki wan soni, taa: ");
INSERT INTO srmNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Dee sëmbë aki, un haika wan soni u seei bi jei ku u seei jesi. Di womi aki bi taki taa a o booko di Wosu u Masa Gadu di de mbei ku libisëmbë maun tuwë a goon, nöö a dii daka dendu nöö a o toona mbei ën baka söndö libisëmbë maun. Sö a bi taki e.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma fa dee sëmbë fan dë seei, ma dee fan u de an ta kai a wan möönsö. ");
INSERT INTO srmNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nöö hën di Kaba Hei Begima hopo taanpu a dee oto kuutuma fesi naandë, nöö hën a hakisi Masa Jesosi taa: “Wë dee soni fii de ta taki aki, nöö ja o piki de möönsö nö, ee tuu soni de ta mindi da i. Unfa i taki?” ");
INSERT INTO srmNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma Masa Jesosi an jabi ën buka piki na wan soni. Nöö hën di Kaba Hei Begima hakisi ën baka taa: “I da di Könu di Masa Gaangadu bi paamusi taa a o manda ko nö? I da di Mii u di möön hei Gadu u mundu nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nöö hën Masa Jesosi piki awaa taa: “Leti kumafa i taki dë, nöö sö a dë. Nöö wan daka o dou, nöö woon si mi di ko dë Libisëmbë Mii aki dë sindosindo a di letisë maun u Gadu di abi hii makiti u mundu. Söseei woon toona si mi ta saka ta ko a dee bundji dendu ala.” Sö Masa Jesosi piki. ");
INSERT INTO srmNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wë nöö di di Kaba Hei Begima jei fa a piki ën naandë, nöö hati fëën boonu e, tee a hai di koosu nëën sinkii naandë tënë zaan sö. ");
INSERT INTO srmNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nöö hën a hakisi hii dee kuutuma dee sai naandë taa: “Dee sëmbë aki, un ta suku kaagi a di womi aki möön nö? Wan jei fa a piki dë nö? A butëën seei makandi ku Gadu. Nöö unfa un mëni fëën?” Nöö hën de tuu piki a di kuutu taa: “An dë u taki möön e. Dëdë nöö a musu dëdë.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nöö fa u mbei dë, nöö di kamian ko ta fanjanfanjan kaa. Hën de bigi ta tunta a Masa Jesosi fesi, te wan pisi de tai ën wojo ku hangisa, hën de ta naki ën ta dëën baaimaun, ta hakisi ën taa: “Wë di i taa Gadu ta lei i soni, wë nöö piki u, ambë naki i dë?” Dee wakitima u di kamian seei ta naki ën ku böö tu. ");
INSERT INTO srmNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wë nöö fa de ta du ku Masa Jesosi dë, nöö Petuisi dë a di djai dendu a goon ala. Te wan pisi nöö hën wan mujëë futuboi u di Kaba Hei Begima waka ko dou. ");
INSERT INTO srmNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nöö hën a si Petuisi sindosindo ta këndë faja ku dee sëmbë naandë. Hën a luku ën diin. A taa: “Womi, na i seei bi dë makandi ku di Jesosi u Nazalëti dë nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nöö hën Petuisi piki taa: “Ma saandi i ta taki dë e. Ma fusutan seei.” Nöö hën a kumutu dë go taanpu zuntu ku di djai dööbuka. Ma nöö fa a taki dë, nöö hën wan womi ganian kanda kënkënjënkëën. ");
INSERT INTO srmNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te wan pisi, nöö hën di mujëë mii toona si ën möön, hën a fan ku dee sëmbë dee ku ën sai dë taa: “Di womi aki da wan u dee sëmbë u di womi de ta kuutu dë e.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nöö hën Petuisi toona fia taa: “Mi taki e, ma sabi di sëmbë naandë.” Hën de sai dë te wan pisi, nöö hën dee sëmbë ku Petuisi taanpu naandë taa: “Womi, i musu dë wan sëmbë fëën, biga i da Galilea sëmbë e.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nöö hën Petuisi fia awaa taa: “Dee sëmbë aki, ee mindi mi ta mindi soni nöö Masa Gaangadu seei musu sitaafu mi e. Biga mi ta soi da unu taa ma sabi di sëmbë un ta taki dë, kwetikweti.” ");
INSERT INTO srmNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Di a fan sö kaa, hën wantewante di ganian toona kanda di u tu pasi. Nöö hën Petuisi ko mëni fa Masa Jesosi bi taki dëën taa: “Ganian an o kanda dou tu toon bifö joo fia dii pasi taa ja sabi mi.” Nöö di a ko mëni sö kaa, nöö hën a bia go ta këë seei te a bigi. Hati nöö a hati ën sö. ");
INSERT INTO srmNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wë nöö di juu dë, dee Gaan Begima ku dee Sabima u Wëti ku dee Gaan Womi, ku dee oto kuutubasi u dee Dju sëmbë bi sai naandë ta kuutu makandi nöömö unfa u de du ku Masa Jesosi. Nöö hën de ta kuutu tefa di ganian kanda, nöö hën de kai a wan pakisei. Hën de toona kisi Masa Jesosi tai gingin. Nöö hën de tjëën go a di sëmbë di dee Loomë lanti bi buta faa ta kuutu sondi da dee Dju sëmbë. Hën da Gaama Pilati. ");
INSERT INTO srmNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nöö hën de go a di kuutu wante. Hën di gaama hakisi Masa Jesosi taa: “Fa de ta taki fii aki, ju da di könu u dee Dju tuu nö?” Nöö hën Masa Jesosi piki taa: “Kumafa Gaama taki dë nöö.” ");
INSERT INTO srmNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nöö di ten dë, dee Gaan Begima ta pii sömëni sondi ta kaagi Masa Jesosi da di gaama. ");
INSERT INTO srmNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nöö hën di gaama toona bia fan ku Masa Jesosi möön. A taa: “Haika dee hia hogi de ta konda taa i du aki. Ja o piki ee sondi de ta mindi da i nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma nöö Masa Jesosi an piki na wan soni seei. Nöö di sondi dë bigi da Gaama Pilati e, di Masa Jesosi an ta piki ta fia ku dee sëmbë a dee sondi de ta kaagi ën dë. ");
INSERT INTO srmNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Wë nöö wan guwenti bi dë taki taa te di Pasika piizii o dou, nöö dee Dju sëmbë o hakisi di gaama faa puu wan sëmbë a dunguwosu da de. ");
INSERT INTO srmNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nöö di juu dë wan womi de kai Balabasi ku wanlö otowan fëën bi dë a dunguwosu söötösöötö. Biga de bi kii wanlö sëmbë a wan wajawaja dendu, di ten de ta feti u puu dee Loomë lanti a de liba. Nöö hën mbei de bi söötö de. ");
INSERT INTO srmNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Di juu dë, hën dee hia sëmbë dee bi ko a Masa Jesosi baka di de ta tjëën go a Gaama Pilati dë, hën de hai ko möön zuntu ku di wosu hën de bai taa: “Du da u kumafa i bi guwenti e, Gaama.” ");
INSERT INTO srmNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nöö hën Gaama hakisi de taa: “Ambë un kë mi musu lusu da unu? Un kë mi lusu di könu fuunu aki nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Fa a hakisi de di soni dë, a hakisi sö biga a sabi taa ˻na dee sösö sinkii sëmbë dë bi tja Masa Jesosi ko dë˼. Ma dee Gaan Begima bi tjëën ko fu di de ta haun ku ën hedi. ");
INSERT INTO srmNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma nöö di juu dë, dee Gaan Begima dë a dee sëmbë dendu naandë ta da de faja taa: “Un ta piki taa Balabasi e! Un piki taa Balabasi, hën a musu lusu.” Nöö hën dee sëmbë seti ta bai ta taki da di gaama taa: “Balabasi hën i musu lusu e!” ");
INSERT INTO srmNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nöö hën di gaama hakisi taa: “Nöö andi mi musu du ku di sëmbë un ta kai di könu fuunu aki?” ");
INSERT INTO srmNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hën de bai taa: “Pekëën a lakpa pau! Pekëën a lakpa pau kii e!” ");
INSERT INTO srmNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hën Gaama toona hakisi taa: “Faandi mbei un taki sö? Un hogi a du?” Hën de bai möön taanga taa: “Pekëën a lakpa pau kii e!” ");
INSERT INTO srmNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Wë nöö di gaama kë u dee sëmbë hati musu kötö, hën a lusu Balabasi puu a di dunguwosu da de. Nöö hën a manda dee sodati hën de wipi Masa Jesosi wan gaan taku wipi te de kaba. Nöö hën Gaama butëën a dee sodati maun awaa fu de tjëën go peka a lakpa pau. ");
INSERT INTO srmNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nöö hën dee sodati tei Masa Jesosi hën de tjëën go a wan apaiti kamba u di wosu u di gaama. Nöö hën de kai hii di sodati lö u de tuu ko makandi. ");
INSERT INTO srmNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nöö hën de tei wan baaubaau koosu sö kumafa könu ta bisi, hën de bisi Masa Jesosi te de kaba. Nöö hën de tei wan tatai ku maka hën de lolu ën te de kaba mbei kuma könu kaapusa, tuusi nëën hedi. ");
INSERT INTO srmNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nöö hën de ta hoi ën a sipootu awaa. De ta wai maun dëën ta taki taa: “Odi o, könu! Odi o, könu u dee Dju!” ");
INSERT INTO srmNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nöö hën de tei wan pau, hën de ta naki ën a hedi. Nöö de ta tunta nëën fesi, de ta saka ta tjökö kini nëën fesi a goon ta mbei kuma de ta dëën lesipeki. ");
INSERT INTO srmNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nöö di de kaba u mbei ën fa sö kaa, nöö hën de toona puu di koosu de bi bisi nëën sinkii, nöö hën de bisi di fëën seei koosu dëën baka. Nöö hën de tjëën puu a di köndë ganda go a döösë u de go pekëën a lakpa pau awaa. ");
INSERT INTO srmNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nöö hën de nango ku ën te wan pisi, hën de miti ku wan womi de kai Simon. A kumutu a kamian ta ko a ganda. Di womi aki, a dë u wan köndë u Afiikan de kai Sileni, nöö a dë di tata u Lufusi ku Alekesani. Nöö fa a ta pasa naandë, hën dee sodati duwengi ën faa musu tja di lakpa pau u Masa Jesosi dëën, biga Masa Jesosi ko suwaki te an sa tjëën möön. ");
INSERT INTO srmNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nöö hën dee sodati ta tja Masa Jesosi go tee a wan kamian de kai Golugata, hën da Hedibonu Kamian, sö de kai di kamian naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nöö di de ko dou, nöö hën de mökisi win ku wan pei deesi dëën faa musu bebe, ˻be di sinkii hati fëën musu bösö,˼ ma nöö Masa Jesosi an kë bebëën. ");
INSERT INTO srmNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nöö hën dee sodati kandi ën a di lakpa pau peka awaa, hën de hopo di pau taanpu a pë. Nöö a baka u di dë, hën de ta tuwë lötu luku ambë o wini dee koosu u Masa Jesosi di de bi puu nëën sinkii buta dë. Nöö sö de paati dee koosu fëën te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nöö di ten de peka Masa Jesosi a di lakpa pau dë, nöö a bi dë wan pisiten u nëigi juu mamate sö. ");
INSERT INTO srmNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nöö de bi sikifi wan soni a wan paanga pisi peka a di lakpa pau hedi naandë, de sikifi taa JESOSI, DI KÖNU U DEE DJU, HËN DISI. Biga sö dee Loomë lanti bi guwenti u piki sëmbë faandi mbei de peka di sëmbë a di lakpa pau. ");
INSERT INTO srmNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wë nöö fa de du ku Masa Jesosi dë, nöö de peka tu oto sëmbë buta nëën bandja, wan dë nëën leti maun së, di otowan dë nëën töötömaun së. Dee sëmbë dë, de bi ta kii sëmbë ta tei soni u de, hën mbei de ta kii de a sö wan fasi.  ");
INSERT INTO srmNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nöö sö a ko pasa leti kumafa Masa Gaangadu Buku bi taki gaanduwe u di Sëmbë di Gadu o manda ko taa: “De o kondëën makandi ku dee takulibima.” ");
INSERT INTO srmNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nöö sëmbë ta waka ta pasa naandë, nöö de ta lafu Masa Jesosi seei, de ta seki hedi ta lei finga nëën ta taki taa: “Luku, i bi ta taki taa joo booko di Wosu u Gadu nöö a dii daka dendu joo toona mbei ën baka. Na sö i bi taki nö? ");
INSERT INTO srmNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wë nöö be i saka kumutu a di lakpa pau di i a’ makiti sö!” ");
INSERT INTO srmNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Söseei dee Gaan Begima ku dee Sabima u Wëti ta taki tu. De taa: “Fa a sai naandë, a bi ta heepi oto sëmbë ta puu de a sitaafu, na sö nö? Wë nöö andi mbei an sa heepi ën seei? ");
INSERT INTO srmNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Biga ee hën da di Paamusi Könu tuu, nöö be a saka kumutu a lakpa pau ko a goon be u si, nöö woo biibi nëën liba.” Söseei de tu womi dee dë pekapeka ku ën naandë ta taki soni ta tjökö ën tu. ");
INSERT INTO srmNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wë nöö a di sonuati tuwalufu juu, nöö hën wan gaan dungu ko kai a goonliba kankan, nöö a dë sö teee dii juu sapate. ");
INSERT INTO srmNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nöö hën Masa Jesosi bai taanga, a taki a di töngö fëën taa: “Eloi, Eloi, lama sabaktani?” Hën kë taki: “Gadu e, di Gadu u mi, andi mbei i bia baka disa mi sö?” ");
INSERT INTO srmNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nöö dee sëmbë dee dë taanputaanpu naandë, de jei fa a bai “Eloi,” hën so u de taa: “Un haika, a ta kai di fesiten tjabukama fuu de kai Elia e, faa ko puu ën a di lakpa pau.” ");
INSERT INTO srmNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nöö hën wan sëmbë sai dë kule go tuusi wan sipönsu a wan asin mbeimbei di de abi naandë, hën a fingëën a wan papai tëndë go a Masa Jesosi buka faa tjupa. Nöö hën a taa: “Söö. Un boo tan luku ee Elia o ko puu ën a di lakpa pau tuu.” ");
INSERT INTO srmNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma nöö hën Masa Jesosi bai wan pasi möön a wan taanga töngö te a kaba, nöö hën böö fëën koti awaa. A dëdë piii. ");
INSERT INTO srmNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","Nöö di oposii, di hedima u dee sodati, a sai leti taanputaanpu a Masa Jesosi fesi naandë. Nöö di a jei fa a bai, a si di fasi fa a dëdë naandë, nöö hën a taa: “Aai, di sëmbë i si de kii aki, Mii u Gadu wë a bi dë tuu e.” Di juu dë, nöö de bi abi wan gaan degi gaan koosu a di Wosu u Masa Gadu a Jelusalen naandë ˻ta tapa di kamian u di wosu ka di Kaba Hei Begima ku Gadu ta miti wan pasi a wan jaa, fu sëmbë an sa go nëën dendu˼. Nöö fa Masa Jesosi böö koti dë, hën wantewante di gaan degi koosu dë tënë a tu pisi kumutu a liba ala zalalaa te kisi goon, disa di kamian hooo. Sö wan gaan soni pasa a di ten naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nöö wanlö mujëë bi dë taanputaanpu te a longi ala ta luku fa Masa Jesosi ta dëdë. Wan u dee mujëë de kai Salome, wan da Malia, di u di köndë de kai Magidala, ku wan oto Malia, di mama di bi pali Josëfu ku di piki baaa fëën de kai Jakobosi. ");
INSERT INTO srmNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","De dii mujëë aki sö bi ta waka a Masa Jesosi baka a di pisiwata de kai Galilea ta sölugu ën a sömëni fasi. Nöö wanlö oto mujëë bi ko ku de tu, fa de bi ko a Jelusalen naandë, nöö sö de tuu bi sai naandë ta luku dee soni de ta pasa. ");
INSERT INTO srmNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nöö fa dee soni ta pasa aki, nöö saba ta kisi kaa. Biga fa i si sonu o go dë, nöö saba kai a goon, nöö de an o sa du soni möön. Nöö dee Dju sëmbë ta seeka gaanfa da di lö saba dë, fu di a ta kai a di ten u di Pasika. ");
INSERT INTO srmNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nöö di juu dë wan womi de kai Josëfu u di köndë de kai Alimatea bi dë a Jelusalen naandë. Di womi aki, a dë wan u dee möön hebi kuutuma u dee Dju sëmbë. Nöö a dë wan sëmbë ta dini Masa Gaangadu seei, biga a dë ta luku di ten di di Njunjun Tii fëën o ko a goonliba. Sö wan sëmbë di Josëfu aki bi dë. Wë nöö di a si taa Masa Jesosi dëdë, di saba ta ko saaa sö seei, hën mbei a tei hati waka langalanga go a Gaama Pilati. Nöö hën a hakisi ën taa, gaantangi be a dëën di dëdë sinkii u Masa Jesosi faa tja go bei. ");
INSERT INTO srmNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wë nöö fa Josëfu hakisi di soni dë, nöö a foondo di gaama möönsö, biga an kë piki taa Masa Jesosi dëdë sö hesi. Nöö hën a kai di oposii hakisi ën ee a dëdë kaa, nöö hën di oposii piki ën taa aai, a dëdë tuu. ");
INSERT INTO srmNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nöö di Gaama jei sö, hën a da Josëfu pasi faa musu go tei di dëdë sinkii fëën tja go bei. ");
INSERT INTO srmNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nöö hën Josëfu kumutu dë, hën a go bai wan pei finu weti wojo koosu. Nöö hën de go puu di dëdë sinkii u Masa Jesosi a di lakpa pau, hën de lolu ën te de kaba ku di weti koosu. Nöö hën de tjëën go buta a wan sitonu baaku dendu di de bi diki seeka u bei sëmbë. Biga a di fasi dë dee Dju bi ta bei dëdë. Nöö di de du sö te de kaba, hën de lola wan gaan gindi sitonu tapa di baaku buka buuu. ");
INSERT INTO srmNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nöö di juu naandë, de tu Malia dee u bi taki dë, de dë leti naandë ta luku ka de buta di sinkii u Masa Jesosi. Nöö da sö wanlö gaan soni pasa a di daka naandë. ");
INSERT INTO srmNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nöö hën de njan di saba daka te de kaba, nöö hën Malia u Magidala, ku Salome, ku di oto Malia, di mama u Jakobosi, nöö hën de go bai peipei sumëë suti soni u de musu go sakwi a di dëdë sinkii u Masa Jesosi kumafa di guwenti u dee Dju sëmbë dë. ");
INSERT INTO srmNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nöö hën di dobooko fëën, a di fosu daka u di wiki dë, nöö hën dee mujëë tei pasi ta waka nango a di geebi. Di ten naandë, sonu bi ta ko kaa. ");
INSERT INTO srmNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nöö fa de ta waka nango, nöö de ta hakisi deseei taa: “Mujëë, fa woo go aki, nöö ambë seei woo feni heepi u lola di gaan gindi sitonu puu a di baaku buka, fuu sa go nëën dendu?” ");
INSERT INTO srmNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nöö hën de naki tee de ko zuntu ku di geebi. Hën de ko si taa di gaan sitonu di bi dë a di baaku buka, a dë te a wan së ala. Di baaku fika hooo. ");
INSERT INTO srmNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hën de denda go a di baaku. Nöö hën de si wan basia u Masa Gaangadu köndë leti naandë kuma wan njönku kijoo sö, a dë sindosindo a letimaun së a di baaku dendu. Fa a sai dë, a dë bisibisi ku wan langa djakiti zëëë sö, wetiweti faan. Nöö dee mujëë panta seei. ");
INSERT INTO srmNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nöö hën di basia fan ku de, a taa: “Wan panta sö e, dee mujëë. Na Jesosi u Nazalëti un ta suku ö, di sëmbë di de bi peka a di lakpa pau kii? Wë an dë aki möön e. A weki baka a dëdë. Un luku ka de bi bei ën aki. Un si taa a dë aki möön nö?” ");
INSERT INTO srmNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hën a taki da de taa: “Un toona go, nöö un go piki dee bakama fëën te dou ku Petuisi tu e, taa a o go a Galilea. Nöö ala unu ku ën o miti kumafa a bi taki da unu. Sö fuun taki da de.” ");
INSERT INTO srmNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nöö di dee mujëë jei a taki sö, nöö a toobi de. De fëëë seei. Nöö hën de kumutu a di baaku dendu ko a döö, hën de kule vililili go. De panta tee de an konda da na wan sëmbë andi de bi si dë.  ");
INSERT INTO srmNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wë nöö fa Masa Jesosi bi weki baka a dëdë dë a di fuuku mamate u di fosu daka u di wiki, nöö Malia u Magidala hën bi da di fosu sëmbë di si ën ku wojo taa a weki baka tuu. Di mujëë dë, a fesi a bi dë ku sëbën gadu nëën hedi, nöö hën Masa Jesosi bi jaka de puu. ");
INSERT INTO srmNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nöö hën fa di mujëë si ën naandë, nöö hën a kule go wante a dee bakama u Masa Jesosi ka de bi go ta kusumi ta këë. Nöö hën a go konda da de taa sö a si Masa Jesosi gbolo, a weki baka a dëdë. ");
INSERT INTO srmNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma fa dee bakama jei taa Masa Jesosi dë ku libi dë, Malia seei si ën, ma töku de an biibi. ");
INSERT INTO srmNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nöö hën a baka u di dë, hën Masa Jesosi tjëën seei go lei tu oto sëmbë möön. Dee sëmbë aki bi ˻kumutu a Jelusalen ganda˼ ta waka nango, nöö hën Masa Jesosi ko a de ko ta fan ku de kuma wan hii oto sëmbë. ˻Ma nöö te u kaba fëën nöö hën de ko si taa hën di dë tuu, a weki baka a dëdë.˼ ");
INSERT INTO srmNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nöö hën de toona go a Jelusalen wante go konda da dee bakama taa sö Masa Jesosi weki baka a dëdë tuutuu, de bi si ën. Ma tökuseei dee bakama an kë piki. ");
INSERT INTO srmNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nöö baka u di dë, hën dee ëlufu bakama bi dë a tafa ta njan a wan kamian. Te u de kë mëni, hën Masa Jesosi dou a de dendu naandë kaa. Nöö hën a gandji da de fu di de an bi ta biibi. A bai de fu di de bi abi taangajesi sö te de an kë piki dee sëmbë dee bi konda di soni da de taa sö a weki baka a dëdë. ");
INSERT INTO srmNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nöö hën a fan ku de taa: “Söö. Wë nöö awaa un musu paaja go a hii köndë u goonliba e, go konda di Bunu Buka u mi da hii sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nöö di sëmbë di o biibi tei dopu, nöö hën Gadu o da libi u teego. Ma nöö di sëmbë di an biibi möönsö, nöö hën o kisi sitaafu a Gadu fu teego.” ");
INSERT INTO srmNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nöö hën a taki da de möön taa: “Dee soni aki sö o ta pasa a dee sëmbë dendu dee o biibi mi tuutuu. De o kisi kaakiti a Gadu u de ta du peipei foondo wooko. Biga de o ta jaka dee gadu ta kisi sëmbë a hedi. De o ta fan a wanlö oto töngö di de an bi sabi wan daka. ");
INSERT INTO srmNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ee de panjan hogi sindeki ku maun, ma soni an o du de. Ee de bebe taku soni seei, ma an o du de hogi. De o buta maun a dee sikima hedi begi da de, nöö de o ko bëtë. Hii dee soni aki sö o ta pasa a dee biibima dendu u lei taa di wöutu de ta konda dë, a Gadu a kumutu tuu.” ");
INSERT INTO srmNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nöö sö Masa Jesosi fan ku dee bakama fëën te a kaba. Nöö di a manda de sö kaa, nöö hën Gadu hopo ën tja go a liba, hën a go sindo a di letisë maun u Gadu. Nöö hën dee bakama waka go a hii köndë go konda di Buka. ");
INSERT INTO srmNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nöö Masa heepi de seei, a da de maun a di wooko. Biga de du sömëni foondofoondo wooko u lei taa di buka de ta konda naandë, a Gadu a kumutu tuutuu. Da sö.");
INSERT INTO srmNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wë, mi mati Teofilusi, mi, Lukasi, manda gaan odi da i. Nöö mi kë taki da i kumafa soni bi pasa ku Masa Jesosi. Ma nöö fa mi o taki aki, na mi da fosu sëmbë di mbei ën buta a pampia e. Biga sömëni sëmbë bi sikifi soni fëën kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","3","Nöö dee bakama u Masa Jesosi ku sömëni oto sëmbë bi si dee soni aki ku deseei wojo kumutu a seti fëën te kaba fëën, nöö de fika ta konda da sëmbë kumafa a bi pasa. Nöö leti fa de ta kondëën dë, nöö sö nöö dee sëmbë ta sikifi ën buta a pampia. Nöö miseei jei ën finifini tu, biga mi nango ta hakisi sëmbë, de ta kondëën da mi. Nöö di mi jei ën sö, nöö mi si taa a bunu fu mi mbei di pampia aki manda da i ");
INSERT INTO srmNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","fii seei musu jei ën finifini tu taa na lëgëdë. Dee soni de bi lei i dë, de tuu dë tuutuu soni. ");
INSERT INTO srmNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wë a di juu ten di di sëmbë de kai Helodi bi dë könu u Judea Köndë, nöö hën wan begima bi dë de kai Sakaliasi. A bi dë a wan feleniki u dee begima de kai Abia. Nöö hën mujëë de ta kai Elizabëti, nöö hënseei dë famii u dee Begima tu. ");
INSERT INTO srmNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nöö de tu sëmbë dë tuu bi ta libi kumafa Masa Gaangadu kë. De ta hoi dee wëti fëën te na wan sëmbë bi feni föutu a de. ");
INSERT INTO srmNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma wan soni nöö bi makei de, hën da de an bi abi miii, biga Elizabëti an bi pai wan daka, nöö de tu sëmbë tuu ko gaan sëmbë kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nöö hën de dë te wan daka, nöö hën Sakaliasi ku dee oto begima musu go du di wooko u de a di Gaan Wosu u Masa Gaangadu ˻a Jelusalen naandë˼. ");
INSERT INTO srmNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nöö hën de dë a di wooko te wan pisi, nöö hën de tuwë lötu kumafa di guwenti u de bi dë, fu de luku ee ambë o go tjuma sumëë suti soni da Masa Gadu nëën Wosu dendu dë. Nöö hën de tuwë tefa de kaba, nöö hën di lötu kai a Sakaliasi. Nöö hën de mandëën go. ");
INSERT INTO srmNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nöö di a go a di wosu faa go tjuma di soni, nöö hii dee oto sëmbë tuu dë taanputaanpu a dööbuka ta begi Masa Gadu. ");
INSERT INTO srmNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nöö hën Sakaliasi dë a di Wosu dendu te wan pisi, hën wan basia u Gadu ko nëën ko taanpu a letimaun së u di tafa ka de ta tjuma di sumëë suti soni. ");
INSERT INTO srmNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nöö di Sakaliasi si ën, nöö hën hati fëën latja. A panta tee na sipootu. ");
INSERT INTO srmNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hën di basia taki dëën taa: “Na fëëë e, Sakaliasi. Masa Gaangadu jei dee begi fii, nöö di mujëë fii, Elizabëti, o pai wan womi mii. Nöö i musu kai ën Johanisi. ");
INSERT INTO srmNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nöö te i pai di mii, nöö joo abi gaan piizii ku ën. Söseei hii sëmbë o wai ku di mii. ");
INSERT INTO srmNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nöö fa joo pai ën dë, nöö a o dë wan hei sëmbë a Masa Gadu wojo. Hiniwan taanga diingi di sa dööngö sëmbë nöö an musu bebëën. Nöö sensi nëën mama bëë dendu seei di Akaa u Masa Gadu o dë ku ën, nöö di mii o ta dë nëën leiki. ");
INSERT INTO srmNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nöö a o mbei sömëni sëmbë u Isaëli Köndë aki bia de libi toona ko a Masa Gaangadu, di Gadu u de. ");
INSERT INTO srmNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","“Nöö di mii di woon pai dë o dë wan sëmbë kuma di fesiten tjabukama de kai Elia. Biga kumafa di kaakiti u Masa Gadu bi dë a Elia liba, nöö sö a o dë a di mii liba tu. Nöö leti kumafa Elia bi dë a di Akaa u Masa Gadu leiki, nöö söseei di mii o dë tu. Nöö a o waka a Masa fesi faa seeka hii soni dëën. A o ta bia sëmbë hati, tata ku mii o ko ta libi bunu ku deseei. A o mbei dee sëmbë dee an bi ta piki Gadu buka musu bia ko abi bunu fusutan, kuma dee sëmbë dee ta libi bunu a Masa Gadu wojo. Leti kumafa mi taki aki, nöö sö a o seeka sëmbë hati da Masa.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nöö hën Sakaliasi hakisi di basia taa: “Wë fa un taki dë, wë nöö un maaka un o da mi fu mi sa sabi taa a sa dë sö tuu? Biga mi ko gaandi kaa, nöö di mujëë u mi seei ko gaandi tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nöö hën di basia piki ën taa: “Mi da Gabiëli, di basia u Masa Gadu di ta dë hiniwanten leti nëën bandja. Hën wë manda mi ko a i fu mi tja di bunu buka aki ko da i. ");
INSERT INTO srmNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma nöö fu di ja kë biibi, nöö di maaka mi o da i hën da buka fii o tapa. Ja o fan möön u te di mujëë dë ku bëë te a pai bifö joo fan möön. Biga dee soni mi taki da i aki, te di daka dou nöö de tuu o pasa sö tuu.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nöö di juu dë, dee hia sëmbë bi dë a dööbuka ta luku Sakaliasi. Hën de tuu foombo. De taa: “Wë unfa a tan longi a di Wosu dendu sö?” ");
INSERT INTO srmNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Te wan pisi, hën Sakaliasi kumutu ko a döö. Nöö buka fëën tapa, an sa fan ku dee sëmbë möön. Nöö de ko si wante taa wan soni a si a di Wosu dendu, biga a ta biinga u kondëën da de ku maun. ");
INSERT INTO srmNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nöö hën Sakaliasi ta wooko a di Wosu u Masa Gadu tefa juu fëën kisi faa go a wosu, nöö hën a go. ");
INSERT INTO srmNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nöö an longi möön seei, hën di mujëë fëën, Elizabëti, tei bëë. Nöö hën a tjubi feifi liba longi a wosu dendu. ");
INSERT INTO srmNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Hën a da Gadu tangi seei taa: “Masa Gadu, gaan tangi fii. I du mi wan gaan bunu fu di i mëmbë mi ku i bunuhati. Biga awaa ufö i puu sen a mi wojo a hii sëmbë fesi.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nöö baka u di dë, hën Elizabëti dë ku di bëë tee a a’ sikisi liba, nöö hën Masa Gadu toona manda di basia dë seei go a wan wëndjë mujëë mii de ta kai Malia. A ta libi a di pisiwata de kai Galilea a di köndë de ta kai Nazalëti. ");
INSERT INTO srmNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nöö di mujëë aki an sabi womi wan daka, ma wan womi de kai Josëfu bi pidi ën ta kiija. Ma an bi tei ën eti. Nöö Josëfu bi dë wan sëmbë u di lö u di fesiten könu de kai Dafiti. ");
INSERT INTO srmNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wë nöö fa di basia go dou a Malia naandë, nöö hën a dëën odi taa: “Tia, odi oo. I a’ bunuhedi möön hii mujëë e. Biga Masa Gaangadu dë ku i. A o naki i kölöku möön hii mujëë u goonliba.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wë di Malia jei di odi hën a panta teee, biga a toobi ën. Hën a hakisi ën seei taa: “Wë un sooti odi disi? Andi a kë taki?” ");
INSERT INTO srmNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hën di basia taki dëën taa: “Malia, na fëëë e! Masa Gadu seei tei i apaiti kaa faa lei i di bunuhati fasi fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Biga joo dë ku bëë, nöö joo pai wan womi mii. Nöö i musu kai ën Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nöö di mii di joo pai dë, a o hebi möön hii sëmbë. Biga di në fëën o dë ‘di Mii u di möön hei Gadu a liba.’ Nöö Masa Gadu o butëën ko könu nëën gaan avo Dafiti kamian, ");
INSERT INTO srmNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","nöö a o dë könu u dee bakamii fuunu gaan avo Jakopu u nöömö. Taki fëën an o kaba möönsö a mundu.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hën Malia hakisi di basia taa: “Unfa mi sa du dë ku bëë? Biga ma sabi womi wan daka.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hën di basia piki ën taa: “Di Akaa u Masa Gadu hën o ko a i e, nöö di taanga u Gadu hën o du di soni naandë. Nöö hën mbei di mii di joo pai, de o kai ën Gaangadu Mii. A o dë wan apaiti sëmbë u Masa Gadu limbolimbo. ");
INSERT INTO srmNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Nöö haika e, i sisa Elizabëti dë ku gaan bëë a di gaandigaandi ten fëën aki. Fa u dë aki, a dë ku bëë sikisi liba longi kaa. Di wan seei mujëë di hii sëmbë bi sabi taa an sa pai mii, hën wë ko dë ku bëë e. ");
INSERT INTO srmNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Biga na wan soni dë a goonliba aki di Masa Gaangadu an sa du.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Hën Malia piki ën taa: “Wë mi dë a mi Masa maun dendu. Be a pasa ku mi kumafa i taki dë.” Hën di de fan sö te de kaba, hën di basia go fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nöö a baka u di di basia fan ku Malia sö kaa, nöö an longi möön seei, nöö hën Malia hopo tei pasi. Hën a waka hesihesi go tee a wan köndë u di pisiwata de kai Judea a dee kuun mindi. ");
INSERT INTO srmNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hën di a go dou, hën a denda go a Sakaliasi wosu, hën a da Elizabëti odi. ");
INSERT INTO srmNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nöö hën di Elizabëti jei di odi u Malia, hën di mii dë nëën bëë dendu dë buli seei. Nöö hën di Akaa u Masa Gadu ko a Elizabëti liba ");
INSERT INTO srmNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","hën a bai taa: “Keee, mujëë, i a’ bunuhedi möön hii mujëë. Gadu dë ku i. Söseei di mii di dë a i bëë dendu dë tu, Masa Gadu a’ gaan piizii ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Unfa mi du ufö mi a’ bunuhedi sö tee di mama u mi Masa seei ko haika mi? ");
INSERT INTO srmNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wë biga di mi jei di odi fii, nöö di mii dë a mi bëë dendu aki wai te a buli. ");
INSERT INTO srmNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","“Wë nöö fa i si i piki Gadu buka dë, mujëë, nöö joo si bunu fëën e. Biga dee soni a taki da i dë, nöö de tuu o pasa sö tuu.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nöö hën Malia seei bia gafa Gadu tu. A taa: “Mi gafa Masa tee dou ku mi akaa tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mi ta wai seei a mi hati ku di Gadu u mi. Hën da mi Heepima. ");
INSERT INTO srmNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Biga a bi luku mi möfina sëmbë te a buta mi ko hei sëmbë a goonliba. Nöö di hei a hei mi aki, mi abi ën fu teego. Hii sëmbë u goonliba o ta kai mi në taa sö Masa bi dë ku mi. ");
INSERT INTO srmNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wë biga di Sëmbë di abi kaakiti a hii mundu liba nöö hën wë du mi di gaan bunu aki. Di Sëmbë di abi limbo hati möön hii sëmbë a goonliba nöö hën du mi ën. ");
INSERT INTO srmNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","An ta wei möönsö fu du dee sëmbë dee ta lesipeki ën gaan bunu. A ta heepi dee lö sëmbë dë nöömö fu teego. Biga a a’ tjalihati u libisëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nöö a taanga, a a’ makiti u du soni. Biga a jaka dee gaanfasi sëmbë ku dee bigimëmbë wan paaja. ");
INSERT INTO srmNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dee gaan könu u goonliba a ta hai puu a de könu bangi. Ma dee sakafasi sëmbë a ta hopo fu de musu ko dë hei sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A ta paati dee gudu fëën da dee pena sëmbë, dee ta kë Masa Gadu. Ma dee guduma dee aan fanöudu fëën, a ta mbei de go ku sösö maun. ");
INSERT INTO srmNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","A ta a’ tjalihati nöömö ta heepi dee sëmbë fëën u Isaëli, leti kumafa a bi paamusi u tata Abahamu ku dee bakamii fëën. Fa a bi fan dë, nöö an fëëkëtë möönsö. A heepi u tuu. Nöö a o ta heepi u nöömö.” Sö Malia fan te a kaba gafa Gadu. ");
INSERT INTO srmNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nöö hën a fika ku Elizabëti naandë te a abi dii liba, nöö hën a toona go fëën nëën köndë. ");
INSERT INTO srmNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nöö hën de dë te di ten u Elizabëti dou faa pai, nöö hën a pai wan womi mii. ");
INSERT INTO srmNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nöö di dee famii fëën ku dee sëmbë a di pisiwata dë jei taa sö Gadu du ën sö wan gaan bunu, nöö hën de tuu wai ku ën seei. ");
INSERT INTO srmNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hën de dë tefa di mii abi aiti daka, hën de ko u ko koti di mii buta di maaka faa dë taa sëmbë u Gadu disi, kumafa di guwenti u dee Dju sëmbë bi dë. Nöö de bi kë tei ën tata në ta kai di mii Sakaliasi. ");
INSERT INTO srmNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma hën mama taa: “Nönö, u musu kai ën Johanisi.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hën de piki ën taa: “Wë nönö mujëë, biga na wan sëmbë dë a di famii fuunu de ta kai Johanisi.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hën de go fan ku ën tata ku maun hakisi ën ee un në a kë fu de musu kai di mii. ");
INSERT INTO srmNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nöö hën a mbei de dëën wan piki böutu sö, nöö hën a sikifi nëën taa di në u di mii da Johanisi. Hën de taa: “Hmmm, di soni aki, a foombo.” ");
INSERT INTO srmNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nöö a di juu dë seei, Sakaliasi buka jabi, töngö fëën lusu, hën a seti u fan baka. Nöö di a si sö, hën a gafa Gadu seei. ");
INSERT INTO srmNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nöö hii dee sëmbë u di pisiwata naandë foombo te na soni. Nöö hën di woto dë ko paaja a hii Judea a dee kuun mindi naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nöö di hii sëmbë jei fa di soni pasa naandë, nöö hën de ta pakisei a de hati taa: “Wë unfa seei di mii naandë o dë?” Biga de si taa Masa Gadu dë ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nöö hën di Akaa u Masa Gadu ko a Sakaliasi di tata u di mii liba, nöö hën a konda wan buka u Masa Gadu taa: ");
INSERT INTO srmNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","69","Gaantangi u Masa Gadu, di Gadu fuu dee Isaëli sëmbë aki, fu di a ko puu u dee sëmbë fëën a sitaafu. Biga ˻fa i si di wëndjë mujëë mii o pai di mii dë˼ nöö Gadu o da u wan taanga Heepima a di lö fu di futuboi fëën de kai Dafiti. ");
INSERT INTO srmNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A o da u ën leti kumafa a bi mbei dee fesiten tjabukama fëën bi paamusi dee gaan sëmbë fuu gaanduwe kaa ");
INSERT INTO srmNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","taa hën sa ko puu u a dee felantima fuu basu. Nöö dee sëmbë dee an lobi u, nöö de an o feni u ta sitaafu möön. ");
INSERT INTO srmNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","75","Biga Gadu taa a o ta a’ tjalihati da dee gaan sëmbë fuu faa ta heepi de. Nöö a ta mëni di buka di a bi mbei ku de nöömö. Biga a bi mbei wan buka ku u tata Abahamu te a djula dëën taa a o puu u dee bakamii fëën a dee felantima fuu basu fuu musu sa dini ën ta libi gbelingbelin kumafa a kë söndö fëëë fu tee u dëdë. ");
INSERT INTO srmNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wë nöö, di mii u mi aki sö, de sa kai i Tjabukama u di möön hei Gadu a u liba. Biga joo waka a Masa fesi go fan ku lanti be de seeka hatiböö u de dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Joo taki da de taa de musu bia de libi be Masa Gadu heepi de, be an hoi di hogilibi u de a bëë möön. ");
INSERT INTO srmNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Biga Masa Gadu a’ tjalihati u libisëmbë. An kë u de ta dë a dungudungu da dëdë ta sitaafu. Hën mbei a tuwë di limbo fëën ko a goonliba kuma te sonu ta booko ta ko, fu de sa kumutu a dungu ko ta libi fiifii a di limbo u Gadu. Sö Sakaliasi fan te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nöö hën di mii sai dë ta göö ta ko. Nöö fusutan fëën ta göö tu biga di Akaa u Gadu ta heepi ën. Nöö hën a sai dë teefa a ko bigi tjika, hën a kumutu go ta libi a sabana dendu hën wanwan, teefa a dou di juu faa konda di Buka u Gadu da dee Isaëli sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wë nöö a di ten dë, di Gaan Könu u dee Loomë sëmbë de kai Këisë Aukesi bi ta tii, nöö hën a manda wan buka go a hii köndë ka a abi taki taa hii sëmbë musu go sikifi de në buta a lanti buku. Biga de ta konda sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Di konda aki, hën bi dë di fosu toon de o konda sëmbë. Nöö di juu dë, di gaama de kai Sileni bi dë gaama fu Silia Köndë. ");
INSERT INTO srmNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nöö hën hiniwan sëmbë nango a di kamian ka de bi pai hën avo fu de musu tei hën në sikifi a lanti buku. ");
INSERT INTO srmNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Nöö söseei Josëfu fu di köndë de kai Nazalëti a di pisiwata fu Galilea dë hopo tu, hën ku ën kiija mujëë Malia di bi dë ku di bëë. Hën de go tee a di köndë de kai Betelehem a di pisiwata u Judea ala. Biga hën da di köndë fu dee gaan lö fu di fesiten könu de kai Dafiti, nöö Josëfu bi dë bakamii u Dafiti. Nöö hën de go fu de sikifi de në. ");
INSERT INTO srmNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wë nöö di de dou a Betelehem naandë, nöö ten u Malia kisi faa pai. ");
INSERT INTO srmNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nöö hën a pai wan womi mii. Hën da fosu mii fëën. Hën a dimboli ën a koosu, hën a kandi ën buta a wan këdë dendu ka sëmbë ta buta ahun da dee mbeti ta njan. Biga a mbeti wosu de bi buta de fu de duumi, fu di kamian an bi dë a di lantiwosu möön. ");
INSERT INTO srmNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wë nöö sëmbë u di pisiwata naandë ta kiija di mbeti de ta kai sikafu. Nöö a di ndeti di de pai di mii dë seei, nöö wanlö womi bi dë a sabana ta luku sikafu fu soni an musu du de. ");
INSERT INTO srmNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hën de dë te wan pisi, nöö te u de kë mëni hën wan basia u Masa Gadu Köndë bazia ko a de a di ndeti dë. Nöö hën kamian ko limbo gbegedee kuma didia, biga a Masa Gadu seei di limbo kumutu. Nöö fa di soni pasa dë, nöö dee womi ta luku sikafu dë tuu panta seei. De ko fëëë tee kuma de sa dëdë. ");
INSERT INTO srmNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma di basia taki da de taa, “Nönö dee womi, wan fëëë sö e. Biga fa mi ko aki, nöö mi tja wan gaan bunu buka, piizii wan seei, ko da unu. Nöö di piizii an o dë fu wan kodo sëmbë, ma a o dë u hii sëmbë u goonliba. ");
INSERT INTO srmNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Biga mi ko taki da unu taa tide de pai di Heepima fuunu da unu awaa, di i si un bi ta jei soni fëën nöömö taa a o ko a goonliba. Hën de ta kai di Keesitu, di Paamusi Könu. Hën da di Masa fuunu. Nöö tide de pai ën a di köndë u Könu Dafiti de ta kai Betelehem. ");
INSERT INTO srmNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“Wë nöö mi o lei unu wan maaka e. Te un go nöö woon si wan mii dimbolidimboli a koosu pisi. De kandi ën buta a wan këdë dendu ka de ta da mbeti soni u njan. Nöö te un si sö, nöö hën di mii di dë e.” ");
INSERT INTO srmNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nöö hën wantewante dë, nöö hën wanlö oto basia u Gadu köndë ko gidjii ko mökisi ku di bi sai dë. Hën de ta gafa Gadu tee a bigi taa: ");
INSERT INTO srmNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Masa Gadu, u ku hii dee sëmbë fii Köndë ala tuu ta bai i në. U ta gafa i o, biga gaan fii ko a goonliba da dee sëmbë Gadu ta wai ku de.” Sö de ta bai ta taki. ");
INSERT INTO srmNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nöö di de konda di soni te de kaba, hën de toona go u de a Masa Gadu Köndë ka de bi kumutu. Nöö di dee basia go, hën dee sëmbë fan ku deseei taa: “Wë womi, di buka Masa Gadu manda ko da u aki, nöö un boo go a Betelehem go luku di soni.” ");
INSERT INTO srmNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nöö de seeka hesihesi, hën de hopo go a Betelehem. Nöö hën de go si Malia ku Josëfu ku di mii tuu. Di mii dë kandikandi a wan këdë de ta da mbeti njanjan dendu. ");
INSERT INTO srmNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nöö di de si ën sö kaa, hën de go konda di woto u di mii da hii sëmbë leti kumafa di basia bi taki ën da de. ");
INSERT INTO srmNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nöö hii dee sëmbë dee jei di soni u di mii, nöö de tuu ko foondo te na soni, fu di buka dee sikafuma ko taki da de naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nöö hën Malia tei dee soni a bi jei u di mii ku dee soni dee bi pasa tuu hoi nëën hati ta pakisei de nöömö. ");
INSERT INTO srmNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nöö hën dee sikafuma bia toona go a di sabana baka. Nöö de ta gafa Masa Gaangadu ta bai ën në ta wai fu hii dee soni dee de bi jei ku dee de bi si ku de wojo. Biga de bi dë leti kumafa di basia bi taki da de. ");
INSERT INTO srmNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nöö hën de dë tee di mii abi aiti daka hën de koti ën buta di maaka kumafa di wëti u Masa Gadu bi dë. Hën de dëën në. De kai ën Jesosi leti kumafa di basia u Masa Gadu bi kai ën kaa bifö hën mama bi tei bëë fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Nöö hën Malia ku Josëfu sai dë te di juu dou fu Malia musu seeka puu di pai sundju. Nöö hën a tei tu piki pomba faa tja go tjuma da Masa Gaangadu a di Gaan Wosu fëën, kumafa Gadu bi da Mosesi di wëti. Nöö hën de hopo, hën de tei di mii, hën de tjëën go a Jelusalen go butëën a wan apaiti fasi da Gadu kumafa di wëti taki u wan fosupai womi mii, ufö Malia tjuma dee pomba puu di pai sundju awaa. ");
INSERT INTO srmNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nöö di juu dë, wan womi bi ta dë a Jelusalen de ta kai Simion. A bi dë wan gaan bumbuu sëmbë ta libi kumafa Gadu kë ta hoi dee wëti fëën. Fa a sai dë a ta luku Masa Gadu nöömö faa musu puu dee Isaëli sëmbë fëën a dee sitaafu u de, be de feni böö. Nöö di Akaa u Gadu dë ku di womi aki ta tjëën nëën leiki. ");
INSERT INTO srmNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nöö di Akaa bi taki dëën kaa taa an o dëdë ufö a si di sëmbë de kai di Keesitu, di Paamusi Könu di Masa Gadu taa a o manda ko da de u heepi de. ");
INSERT INTO srmNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nöö di juu di de ta tja di Mii ko, hën di Akaa manda Simion faa go a di Wosu u Masa Gadu dendu. Hën fa a go dou dë, hën a si di mama ku di tata ta tja di mii ko, fu de seekëën kumafa di wëti u Masa Gadu taki. ");
INSERT INTO srmNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Hën di a si de, hën a tei di mii puu a de maun. Hën a gafa Gadu, taa: ");
INSERT INTO srmNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Ke, Masa, awaa mi sa dëdë waiwai. Mi hati ko kötö. Biga mi seei wojo si di Heepima kumafa i bi paamusi mi. ");
INSERT INTO srmNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","I mandëën ko da u dee Isaëli sëmbë faa heepi u ku hii dee oto sëmbë u goonliba tuu. A o puu u a di së u dungu buta ko a di së u limbo, nöö a o lei u di bunu pasi fuu waka. Nöö fëën hedi sëmbë o bai u Isaëli sëmbë në taa: ‘Di mii u Isaëli Köndë hën heepi hii sëmbë u goonliba.’ ” Sö Simion fan te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nöö fa a fan dë, nöö a toobi Josëfu ku di mama u di mii. A foombo de seei. ");
INSERT INTO srmNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Hën Simion begi Gadu da de te a kaba. Hën a taki da Malia, di mama u di mii, taa: “Di mii i si aki sö, a o mbei sömëni u dee Isaëli sëmbë aki booko saka e. Nöö söseei a o mbei sömëni u de ko hei tu. Nöö a o puu sömëni sëmbë gogo a döö, be de si dee pakisei u libisëmbë dee dë a de hati awaa. Biga a ko a u kuma wan maaka di Gadu da u. Di soni de an si wan daka, hën de o ta si nëën. Di soni de an bi jei wan daka, hën de o ta jei nëën. Fëën mbei na hii sëmbë o lobi ën. De o ta kosi ën. Nöö söseei tu, wan daka ta ko, nöö di soni di o pasa ku di mii aki o hogi da i kuma de suti i ku ufangi a i hati. Sö a o hogi da i tjika.” ");
INSERT INTO srmNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nöö di juu dë, wan m’ma bi sai naandë tu di Masa Gadu ta fan nëën liba. Hën de ta kai Hana. Wan tata de kai Fanuëli hën pai ën nöö gaan lö fëën dë Asë. Nöö a bi dë wan gaandi mujëë kaa. Fa a sai dë, a bi libi sëbën jaa ku di fosu manu fëën di a bi tei nëën njönku ten, nöö hën di womi dëdë. Nöö hën a dë a ganda te a dou aititeni-ku-fö jaa söndö manu. Nöö a ta dë a di Wosu u Masa Gadu nöömö, an ta kumutu dë möönsö. A sai dë ta begi Gadu ta hopo ën në ndeti ku didia te so juu an ta njan seei. ");
INSERT INTO srmNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nöö a di juu Simion ta fan dë, hën di mujëë aki seei ko dou tu, hën di a si di mii nöö hën a da Gadu tangi. Nöö hën a sai dë ta konda soni u di mii da hii dee sëmbë u Jelusalen dee bi ta mëni Masa Gadu faa manda di Heepima ko u ko puu de a sitaafu. ");
INSERT INTO srmNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nöö hën Malia ku Josëfu seeka hii soni kumafa di wëti u Masa Gadu taki te de kaba, nöö hën de toona go u de a de köndë, a Nazalëti a di pisiwata u Galilea. ");
INSERT INTO srmNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nöö hën di mii sai dë ta göö ta ko. A dë seei gaagaa. Möönmöön a ta a’ fusutan u dee soni u Masa Gadu ku libisëmbë tuu. Nöö Masa Gadu seei ta dë ku ën tu ta tjëën a bunu liba. ");
INSERT INTO srmNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wë nöö dee gaan sëmbë fëën bi guwenti fu go a Jelusalen hiniwan jaa u de go njan di gaan piizii de ta kai Pasika. ");
INSERT INTO srmNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nöö hën di Jesosi abi tuwalufu jaa, nöö hën de ku ën go a Jelusalen a di piizii. ");
INSERT INTO srmNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nöö di dee piizii daka pasa kaa, nöö hën de toona nango a wosu baka. Ma nöö di juu dë Jesosi bi fika a Jelusalen, ma dee sëmbë fëën an bi sabi taa sö a fika ala. ");
INSERT INTO srmNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Biga de bi ninga taa sonte a waka ku dee oto sëmbë u de dee bi go a di piizii. Fëën hedi de waka wan hii daka te ndeti bifö de ko mëni u de suku ën. Hën de suku ën a dee famii u de ku dee mati u de dendu tefa de wei. ");
INSERT INTO srmNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hën di de an si di mii, nöö hën de toona go a Jelusalen baka go suku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nöö a di u dii daka dendu u di de ta suku ën ufö de go si ën a di Wosu u Masa Gadu dendu sindosindo a dee mësitë mindi. A ta haika fa de ta lei sëmbë soni u Masa Gadu, nöö a ta hakisi de soni tu, de ta konda dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nöö hii dee sëmbë dee ta jei di fan u di mii, nöö a ta foondo de te na soni. Biga de an sabi unfa a waka a abi sö wan bumbuu fusutan te a ta piki dee sëmbë dee ta fan ku ën dë kuma na piki mii a dë. ");
INSERT INTO srmNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nöö söseei di soni toobi Josëfu ku Malia tu tee de foondo. Nöö di de go si di mii, nöö hën hën mama hakisi ën taa: “Ma di mii aki o, andi mbei i du sö ku u? Tide mbei dii daka di mi ku i tata ta booko hedi ta suku i.” ");
INSERT INTO srmNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hën a toona hakisi de taa: “Wë andi mbei un ta suku mi sö? Wan sabi taa mi dë aki a mi Tata wosu nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma fa di mii fan dë, hën tata ku hën mama an bi saandi a kë taki da de. De an fusutëën seei. ");
INSERT INTO srmNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nöö hën de tei ën nöö hën de toona go u de a Nazalëti baka. Nöö hën Jesosi toona sakëën seei a dee gaan sëmbë fëën basu. Ma hën mama tei hii dee soni u di mii buta nëën hati dendu ta pakisei nöömö. ");
INSERT INTO srmNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nöö hën di mii sai dë ta göö ta ko. Nöö möönmöön a ta a’ fusutan u soni, nöö Masa Gadu ku libisëmbë tuu lobi ën. ");
INSERT INTO srmNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wë nöö a di teni-a-feifi jaa u di tii u di Gaan Könu de kai Këisë Tibelia, nëën Johanisi seti di wooko fëën. Nöö a di ten dë sömëni tiima bi dë a di Gaan Könu dë basu. Biga Gaama Pontuisi Pilati bi ta tii di köndë de kai Judea. Könu Helodi bi ta tii di köndë de kai Galilea. Nöö di baaa fëën de kai Filipi bi ta tii de tu köndë de kai Idumea ku Takonitisi. Nöö Gaama Lisamiasi bi ta tii di köndë de kai Abilene. ");
INSERT INTO srmNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nöö a di ten dë, Ananiasi ku Kajafasi bi dë dee Kaba Hei Begima u dee Dju sëmbë. Nöö hën Masa Gadu kai di mii u Sakaliasi de kai Johanisi ka a dë a sabana dendu ala. ");
INSERT INTO srmNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nöö hën a hopo ta waka ta lontu a hii dee köndë a di pisiwata u di lio de kai Joodan, ta konda da sëmbë taa de musu bia de libi ko dopu, be Masa Gadu an hoi dee hogilibi u de a bëë möön. ");
INSERT INTO srmNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nöö fa a ta du dë, a kai ku di soni di fesiten tjabukama u Gadu de kai Jesaaja bi sikifi a di Buku u Gadu taa: Wan sëmbë ta bai a di sabana taa: “Un mbei di pasi da Masa ooo, be a ko dë tololoo. ");
INSERT INTO srmNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hii dee hei liba ku dee kuun, te dou ku dee sakasaka kamian tuu musu ko dë palalaa. Nöö dee bendibendi u di pasi musu ko dë tololoo. Söseei dee baaku dee dë a di pasi, de musu tapa de tuu ko buta palalaa. ");
INSERT INTO srmNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nöö te a dë sö kaa, nöö hii sëmbë o si di heepi di Masa Gaangadu abi awaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nöö fa Johanisi ta bai dë, nöö wanlö gaan hia sëmbë ta ko nëën faa dopu de. Hën a taki da de taa: “Unu takuhatima kuma sindeki, un ko tei dopu nö? Ambë taki da unu taa un sa kumutu a di hatiboonu u Gadu ˻söndö un bia unu libi˼? ");
INSERT INTO srmNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Un musu libi bunu e, be hii sëmbë si taa libi fuunu tooka. Wan musu sai dë ta taki taa fu di di gaan avo fuunu de kai Abahamu ku Masa Gadu bi dë gaan mati, nöö Gadu an o sitaafu unu e! Nönö, wan mëni sö. Biga ee Gadu kë, a sa mbei dee sitonu aki bia ko böngö u Abahamu ˻a unu kamian˼. ");
INSERT INTO srmNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Biga luku, de seti koti dee pau lutu kaa. Nöö ee wan pau sai dë an ta pai bumbuu njanjan, nöö de o faa ën puu koti tuwë a faja tjuma kaba a sösö.” Sö Johanisi ta bai. ");
INSERT INTO srmNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nöö hën de hakisi ën taa: “Wë nöö andi u musu du möön?” ");
INSERT INTO srmNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hën a piki de taa: “Ee wan sëmbë i abi tu hëmpi, nöö i musu tei wan nöö i da di sëmbë di na abi. Söseei ee wan sëmbë i abi njanjan, nöö i musu da di sëmbë di na abi.” ");
INSERT INTO srmNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nöö a baka fëën, nöö hën dee pii-lanti-mönima ko nëën tu faa musu dopu de. Hën de hakisi ën taa: “Mësitë o, andi u musu du möön?” ");
INSERT INTO srmNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nöö hën a taki da de taa: “Un haika e. Te un ta pii möni, nöö wan musu hakisi möön hia möön leki fa lanti buta.” ");
INSERT INTO srmNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nöö hën dee sodati ko nëën tu, hën de hakisi ën taa: “Wë andi uu musu du?” Nöö hën a taki da de taa: “Wan musu suku toobi ku sëmbë ta musu de ta tei möni a de e. Söseei wan musu mindi soni da sëmbë tu fii tja de go a kuutu fu möni hedi. Ma un musu dë tifihedi ku di möni un ta kisi a lanti.” ");
INSERT INTO srmNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nöö fa dee sëmbë ta jei di fan u Johanisi dë, hën de pakisei taa: “Wë ambë da di sëmbë naandë, maingë? A sa kë di Keesitu, di Paamusi Könu di Masa Gadu bi taa a o manda ko da u a goonliba aki nö?” Biga de bi kë fu di Paamusi Könu musu ko. ");
INSERT INTO srmNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Fëën hedi Johanisi piki de taa: “Nönö, dee sëmbë, nëën disi e. Ma hebi kuma ën. Ma di Sëmbë dë hën ta ko nöömö. Fa mi dë aki, ma hei tjika u mi lusu di susu fëën puu nëën futu seei. Biga mii ko u mi dopu sëmbë ku wata nöö, ma nöö te hën a ko nöö a o dopu unu ku di Akaa u Masa Gadu, ku faja. ˻Biga di Akaa o limbo unu hati puu dee hogilibi dee bi dë a unu, kuma te faja ta tjuma goon puu dee soni fika di goon doti.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nöö fa di Sëmbë o ko dë, nöö a dë kabakaba këëë faa seeka di njanjan fëën. Dee bumbuu njanjan a o tei tjubi a gaan suwa, ma dee poipoi wan a o tuwë a di faja di an sa tapa a mundu möönsö, be de tjuma kaba a sösö.” ");
INSERT INTO srmNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nöö sö Johanisi ta wasiköi dee sëmbë nöömö ta konda di Bunu Buka u Masa Gadu da de. ");
INSERT INTO srmNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma Johanisi bi gandji da Könu Helodi tu fu di di könu bi tei hënseei baaa mujëë, ufö a du sömëni oto hogi tu. ");
INSERT INTO srmNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nöö hën di Könu hopo hën a go du wan möön gaan hogi eti. A kisi Johanisi söötö a dunguwosu. ");
INSERT INTO srmNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma bifö de söötö Johanisi a dunguwosu, nöö sömëni hia sëmbë bi ta ko nëën faa dopu de. Nöö Masa Jesosi seei bi kisi dopu nëën tu. Nöö fa a bi dë a di dopu, nöö a ta begi. Tee wan pisi, hën di mundu jabi waaa sö nëën liba. ");
INSERT INTO srmNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Hën di Akaa u Masa Gadu saka ko kuma wan pomba ko tan nëën liba, nöö hën wan töngö piki a liba ala taa: “I da mi lobi Womi Mii. Libi fii ta kai ku mi te.” Sö wan soni pasa a di dopu u Jesosi e. ");
INSERT INTO srmNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nöö Jesosi bi abi diiteni jaa di a seti lei sëmbë. Nöö hiniwanten de bi ta luku ën kuma wan mii u Josëfu. Nöö Josëfu, hën da di mii u Eli. ");
INSERT INTO srmNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nöö Eli, hën da di mii u Mataati. Nöö Mataati, hën da di mii u Leifi. Nöö Leifi, hën da di mii u Mëtji. Nöö Mëtji, hën da di mii u Janai. Nöö Janai, hën da di mii u Josëfu. ");
INSERT INTO srmNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Nöö Josëfu, hën da di mii u Matatiasi. Nöö Matatiasi, hën da di mii u Amosi. Nöö Amosi hën da di mii u Naum. Nöö Naum, hën da di mii u Esili. Nöö Esili, hën da di mii u Nagai. ");
INSERT INTO srmNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nöö Nagai, hën da di mii u Maati. Nöö Maati, hën da di mii u Matatiasi. Nöö Matatiasi, hën da di mii u Semei. Nöö Semei, hën da di mii u Joseki. Nöö Joseki, hën da di mii u Joda. ");
INSERT INTO srmNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Nöö Joda, hën da di mii u Joanan. Nöö Joanan, hën da di mii u Lesa. Nöö Lesa, hën da di mii u Zebabeli. Nöö Zebabeli, hën da di mii u Seatiëli. Nöö Seatiëli, hën da di mii u Neli. ");
INSERT INTO srmNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nöö Neli, hën da di mii u Mëtji. Nöö Mëtji, hën da di mii u Adi. Nöö Adi, hën da di mii u Kosan. Nöö Kosan, hën da di mii u Elimadon. Nöö Elimadon, hën da di mii u Eli. ");
INSERT INTO srmNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Nöö Eli, hën da di mii u Josua. Nöö Josua, hën da di mii u Eleise. Nöö Eleise, hën da di mii u Jolim. Nöö Jolim, hën da di mii u Mataati. Nöö Mataati, hën da di mii u Leifi. ");
INSERT INTO srmNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nöö Leifi, hën da di mii u Simion. Nöö Simion, hën da di mii u Juda. Nöö Juda, hën da di mii u Josëfu. Nöö Josëfu, hën da di mii u Jonam. Nöö Jonam, hën da di mii u Eliakim. ");
INSERT INTO srmNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Nöö Eliakim, hën da di mii u Mëlia. Nöö Mëlia, hën da di mii u Mëna. Nöö Mëna, hën da di mii u Mataata. Nöö Mataata, hën da di mii u Naatan. Nöö Naatan hën da di mii u Dafiti. ");
INSERT INTO srmNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nöö Dafiti, hën da di mii u Isai. Nöö Isai, hën da di mii u Obëti. Nöö Obëti, hën da di mii u Boasi. Nöö Boasi, hën da di mii u Salima. Nöö Salima, hën da di mii u Nakison. ");
INSERT INTO srmNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nöö Nakison, hën da di mii u Aminada. Nöö Aminada, hën da di mii u Adimin. Nöö Adimin, hën da di mii u Alini. Nöö Alini, hën da di mii u Esilon. Nöö Esilon, hën da di mii u Pëlëzi. Nöö Pëlëzi, hën da di mii u Juda. ");
INSERT INTO srmNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Nöö Juda, hën da di mii u Jakopu. Nöö Jakopu, hën da di mii u Isaki. Nöö Isaki, hën da di mii u Abahamu. Nöö Abahamu, hën da di mii u Teela. Nöö Teela, hën da di mii u Naako. ");
INSERT INTO srmNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nöö Naako, hën da di mii u Seluku. Nöö Seluku, hën da di mii u Leu. Nöö Leu, hën da di mii u Pëlëki. Nöö Pëlëki, hën da di mii u Ebeli. Nöö Ebeli, hën da di mii u Sela. ");
INSERT INTO srmNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Nöö Sela, hën da di mii u Kainan. Nöö Kainan, hën da di mii u Apakasa. Nöö Apakasa, hën da di mii u Semi. Nöö Semi, hën da di mii u Noa. Nöö Noa, hën da di mii u Lamëki. ");
INSERT INTO srmNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nöö Lamëki, hën da di mii u Metusela. Nöö Metusela, hën da di mii u Enöku. Nöö Enöku, hën da di mii u Jeleti. Nöö Jeleti, hën da di mii u Mahalali. Nöö Mahalali, hën da di mii u Kainan. ");
INSERT INTO srmNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Nöö Kainan, hën da di mii u Enösi. Nöö Enösi, hën da di mii u Seti. Nöö Seti, hën da di mii u Adam. Nöö Adam, hën da di mii u Masa Gadu. ˻Dati wan taki Masa Gadu seepi bi mbei ën ku ën seei maun.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nöö di Masa Jesosi kumutu a Joodan Lio ka Johanisi bi dopu ën dë, nöö di Akaa u Masa Gadu bi dë nëën liba, hën a tei ën tja go a sabana dendu. ");
INSERT INTO srmNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nöö ala di didibi go poobëën luku ee a o piki ën buka a soni. Hën Masa Jesosi tan föteni daka ku föteni ndeti a di sabana dë söndö njan, nöö hën hangi ko kisi ën. ");
INSERT INTO srmNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nöö hën di didibi taki dëën taa: “Luku, di i dë di Mii u Gadu kaa, nöö i fan ku di sitonu aki be a bia ko bëëë da i, fii feni soni u njan.” ");
INSERT INTO srmNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Masa Jesosi piki ën taa: “Nönö e. Biga di Buku u Gadu taa: ‘Na njanjan wanwan ta hoi sëmbë a libi.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","7","Nöö hën di didibi tjëën go a wan hei kamian, hën a lei ën kölö sö hii dee köndë tuu fu goonliba aki. Hën a taki dëën taa: “Luku, hii dee soni aki tuu dë u mi. Gadu da mi de, nöö ee mi kë da sëmbë, nöö mi sa da. Nöö de tuu mi sa da i ku di kaakiti u de ku hii dee gudu u de tuu, be i dë takima u de ta njan di bunu ku di waiti u de. Ma i musu tjökö kini a goon a mi fesi begi mi ufö.” ");
INSERT INTO srmNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hën Masa Jesosi piki ën taa: “Nönö e, biga a dë a Masa Gadu Buku taa: ‘Masa Gadu wanwan tö i musu ta begi. Hën wanwan nöö i musu ta dini, biga hën nöö da i Masa.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nöö a baka u di dë, hën di didibi tjëën go a Jelusalen, tee a di Gaan Wosu u Masa Gadu liba a di tölu hedi ala. Hën a taki dëën taa: “Di i dë di Mii u Gadu, nöö hiti i seei puu aki tuwë go a goon, nöö soni an o du i. ");
INSERT INTO srmNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Biga a dë a Gadu Buku taa: ‘Masa Gadu o manda dee basia fëën ko heepi i fu soni an musu du i. ");
INSERT INTO srmNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","De o tja i a maun fu ja musu naki futu a sitonu.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Hën Masa Jesosi toona piki ën taa: “Ma a dë a di Buku tu taa: ‘Ja musu pooba Masa Gadu e, biga hën da i Gadu.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nöö sö di didibi pooba Masa Jesosi a hii soni te a wei, an sa wini ën möönsö. Nöö a baka fëën hën a disëën dë, hën a go fëën ufö. ");
INSERT INTO srmNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nöö a baka fëën, hën Masa Jesosi toona ko a di pisiwata u Galilea. Nöö di kaakiti u di Akaa u Gadu bi dë ku ën te në fëën bai a hii di kamian. ");
INSERT INTO srmNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nöö a nango ta lei de di oto u Masa Gadu a dee keikiwosu u de, nöö hii sëmbë ta gafëën taa a sabi soni. ");
INSERT INTO srmNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nöö hën a sai dë te wan pisi hën a toona ko a Nazalëti ka de bi kiijëën. Nöö hën a dë tefa saba daka dou, hën a go a di keikiwosu kumafa a bi guwenti. Hën a hopo taanpu faa lesi Gadu Wöutu da de. ");
INSERT INTO srmNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hën wan u dee tiima u di keiki tei di pampia di di fesiten tjabukama u Masa Gadu de kai Jesaaja bi sikifi, hën a tëndëën dëën. Hën a jabi ën te a dou a wan kamian ka a de sikifisikifi taa: ");
INSERT INTO srmNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","Di Akaa u Masa Gadu dë a mi liba. Masa Gadu tei mi fu mi konda di Bunu Buka fëën da dee pootima ku dee möfina sëmbë. A tei mi u mi konda da dee sëmbë dee dë taitai, taa mi sa puu de a di fuka de sai dë fu de ko feni böö. A tei mi u mi konda da dee bookowojoma taa dee wojo u de sa ko bunu fu de ko si soni baka. A tei mi u mi konda da dee sëmbë dee ta dë a sitaafu ta kaba a sösö taa de sa kumutu a di sitaafu dë basu. A tei mi u mi konda da hii sëmbë tuu taa di juu dou awaa fu Masa Gadu limbo fesi da libisëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nöö di Masa Jesosi kaba u lesi di pampia hën a tapëën, hën a toona tëndëën da di tiima baka. Nöö hën a go bazia sindo. Nöö hii dee sëmbë dë a di keikiwosu tuu ko ta luku ën diin. ");
INSERT INTO srmNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nöö hën a taki da de taa: “Wë di pisi u di Buku di i si u lesi aki, nöö di Sëmbë di Gadu taa a o manda ko dë nöö hën wë disi e.” ");
INSERT INTO srmNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nöö di a fan sö te a kaba nöö di fan fëën suti da dee sëmbë tee a foombo de. Ma tökuseei de an gafëën kaba. Biga so u de toona kosi ën taa: “Wë ambë da di sëmbë di ta fan di fan naandë? Na di mii u Josëfu nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nöö hën Masa Jesosi piki de taa: “Aai, a bunu. Un sa koti wödu da mi kumafa un kë e. Un sa taki da mi taa: ‘Data o, heepi i seei. Biga un bi jei dee soni i bi ta du a Kapenaumi, nöö di i ko a i seei köndë aki nöö be i heepi dee sëmbë fii tu, boo si.’ ");
INSERT INTO srmNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Ma un haika e, mi o taki wan soni da unu. Wan tjabukama u Gadu an ta a’ në nëën seei köndë e. ");
INSERT INTO srmNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Biga luku di tjabukama de kai Elia. Di ten a bi dë, nöö sö de an bi tei ën u soni tu. A bi tapa di tjuba hii dii jaa ku sikisi liba longi nëën köndë Isaëli aki. Tjuba seei an bi kai möönsö, nöö hën wan gaan hangi ko. Nöö Isaëli köndë bi abi sömëni mujëë di manu u de bi dëdë disa de. ");
INSERT INTO srmNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma tökuseei ˻fu di dee sëmbë fëën seei köndë an bi biibi ën tjika˼, hën mbei Gadu puu ën manda go tee a wan oto köndë de kai Salepita te a di pisiwata u Sidon Köndë ala go ta heepi wan oto köndë mujëë di hën manu bi dëdë disa. ");
INSERT INTO srmNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Nöö söseei a di tjabukama de ta kai Elisa ten, Isaëli köndë aki bi abi hia sikitjinama, ma Elisa an bi kula na wan kodo u de ˻fu di de an biibi ën tjika˼. Ma wan oto sëmbë de kai Naaman kumutu te a wan oto köndë de kai Silia nöö hën a feni kula.” Nöö sö Masa Jesosi fan ku dee sëmbë te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nöö dee sëmbë dee bi dë a di keikiwosu dendu, di de ko jei fa Masa Jesosi fan, nöö hën hati u de ko boonu tee na sipootu. ˻Biga de sabi taa de a ta taki.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hën de hopo vu hën de kisi ën hai tja go a döö. Hën de tjëën go a di kuun buka fu de tuusi ën tuwë go a goon. Biga di köndë bi dë a wan kuun liba. ");
INSERT INTO srmNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma te u de kë si, hën a pasa a de mindi dë go fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A baka u di dë, nöö hën Masa Jesosi toona go a Kapenaumi, a di pisiwata u Galilea dë seei. Nöö hën a dë tefa di saba dou, hën a go a keiki go ta lei sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nöö fa a ta lei de dë, nöö a foombo de seei. Biga te a ta fan, i ta si taa hën abi di taki. ");
INSERT INTO srmNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nöö fa de dë a keiki naandë nöö wan oto sëmbë bi ko dë tu. A bi dë ku wan gadu nëën hedi. Nöö di a si Masa Jesosi, hën a bai kai olo taa: ");
INSERT INTO srmNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Disa u ooo, disa u, Jesosi u Nazalëti. Andi tja i ko aki? I ko fii ko kii u wante nö? Mi sabi i. Ju da di Sëmbë u Masa Gadu seei apaiti.” ");
INSERT INTO srmNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma hën Masa Jesosi gandji dëën taa: “Kabuka dë! Andi joo feni taki? Kumutu a di sëmbë dë liba e!” Nöö hën di gadu hiti di sëmbë tuwë a goon a dee oto sëmbë fesi dë, ma an du ën soni. Nöö hën a kumutu disëën go. ");
INSERT INTO srmNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hën dee sëmbë tuu ko fëëë teee de taki ku deseei taa: “Maingë, andi u ta si aki! Dee soni a ta lei dë, andi seei da de? Biga ku di makiti ku di taanga fëën a puu di gadu a di sëmbë liba. Fa a fan dë, wante di soni disa di sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nöö hën oto fëën paaja a hii di köndë naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nöö hën Masa Jesosi kumutu a keiki, hën a go a di wosu u di womi de kai Simon. Hën a go si Simon mai sikisiki naandë. Wan taanga fëbë kisi ën. Nöö hën de begi Masa Jesosi faa kulëën da de. ");
INSERT INTO srmNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nöö hën a bendi go a di mujëë liba hën a gandji da di fëbë. Nöö hën wantewante dë, hën di fëbë pasa di mujëë, hën a hopo go seeka soni da de de njan. ");
INSERT INTO srmNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hën de sai dë tefa sapate buka, sonu nango. Nöö hën dee sëmbë u di köndë naandë tja wanlö hia sikima peipei wan ko a Masa Jesosi, nöö hën a buta maun a de kula de tuu ko bunu. ");
INSERT INTO srmNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nöö söseei a puu hia soni a sëmbë liba tu, dee ta kisi sëmbë a hedi. De ta bai taa: “Ju da di Womi Mii u Masa Gadu,” nöö a ta gandji da de taa: “Un kabuka dë! Wan fan dë möön e.” Biga de tuu bi sabi ën tuutuu taa hën da di Keesitu, di Paamusi Könu. ");
INSERT INTO srmNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hën di dobooko fëën, mamate biten, hën Masa Jesosi hopo go a döö, hën a go dë a wan kamian hën wanwan. Nöö hën dee hia sëmbë go ta suku ën teefa de go si ën naandë. Hën de begi ën taa gaantangi, be a tan ku de naandë. An musu go disa de. ");
INSERT INTO srmNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma Masa Jesosi taki da de taa: “Wë ma mi musu fu go a dee oto köndë tu u mi konda di Bunu Buka u Masa Gadu da de, be de jei kumafa a ta hopo di Njunjun Tii fëën fa u dë aki. Biga fu di soni dë hedi mbei a manda mi ko a goonliba aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nöö hën a ta waka a hii dee köndëköndë u dee Dju tuu ta konda di Bunu Buka u Gadu da de a dee keiki u de. ");
INSERT INTO srmNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wan daka hën Masa Jesosi bi dë a di ze de ta kai Genesalëti bandja, nöö hën sömëni sëmbë ta ko nëën fu de jei Masa Gadu oto. De ko hila tee kamian an dë faa taanpu möön. ");
INSERT INTO srmNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nöö hën a si tu boto a lampeesi dë. Wanlö sëmbë bi kumutu a höndi ko ta wasi dee nëti u de. ");
INSERT INTO srmNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nöö hën a go subi a di boto u di womi de ta kai Simon. ˻Hën seei da Petuisi.˼ Hën a taa be a tuusi di boto go a wata abiti sö. Nöö hën a sindo a di boto ta lei dee sëmbë dee dë a tela liba ala. ");
INSERT INTO srmNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nöö di a kaba u lei de, nöö hën a taki da Simon taa: “Womi, tuusi di boto go a mindiwata, nöö un tuwë dee nëti fuunu be un kisi fisi.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nöö hën Simon piki taa: “Wë Mësitë o, hii di ndeti u ta dëdë ta tuwë nëti te u wei, wa kisi na wan wojo soni. Ma töku di i taki sö, nöö u sa tuwë luku.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nöö hën de tuwë dee nëti a wata, hën de kisi fisi teee a fika piki sö nëti u de bi tënë. ");
INSERT INTO srmNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nöö hën de bai kai dee oto sëmbë a di oto boto ala, dee ku de ta wooko makandi, u de ko heepi de hai dee fisi. Nöö hën de ko a de, hën de ta kisi dee hia fisi ta buta a de tu boto teee a fika piki sö möön nöö de tu boto tuu bi singi. ");
INSERT INTO srmNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nöö di Simon Petuisi si sö, hën a tuwëën seei a goon a Masa Jesosi fesi. Hën a taa: “Masa, kumutu a mi aki e! Biga mi dë wan hogilibi sëmbë. ˻Ma bumbuu tjika fii ko a mi bandja.˼” ");
INSERT INTO srmNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Di soni mbei a taki sö. Fa de kisi dee hia fisi di wan pasi dë, nöö a foombo ën te a ko fëëë, hën ku dee oto sëmbë dee ku ën sai naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nöö Johanisi ku Jakobosi, de da dee sëmbë dee ta wooko ku Simon makandi. De dë mii u wan tata de ta kai Zebedeosi. Nöö di soni foondo de tu. Hën Masa Jesosi taki da Simon taa: “Na fëëë, womi. I bi ta kisi fisi, ma fa u dë aki mi o mbei i ko ta kisi libisëmbë ˻ta tja ko u de musu sabi mi˼.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hën de tja dee boto u de go buta, hën de disa hii soni u de dë, hën de go ta waka a Masa Jesosi baka. ");
INSERT INTO srmNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wë nöö a baka u di dë, nöö hën Masa Jesosi go a wan köndë. Nöö wan sëmbë bi sai naandë, sinkii fëën lai ku tjinasiki. Nöö di a si Masa Jesosi, hën a kai ku fesi a goon begi ën taa: “Masa, ee i kë nöö i sa kula di tjinasiki u mi da mi.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nöö hën Masa Jesosi tëndë maun nama nëën, hën a taa: “Wë mi kë. Ko bunu e!” Nöö hën wante dë, di sëmbë ko bunu kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nöö hën Masa Jesosi bai ën taa an musu konda da na wan sëmbë, ma be a go a di begima ˻a Masa Gaangadu Wosu dë˼ be a si taa a ko bunu. Nöö be a tja paima go da Gadu kumafa di wëti taki. Biga da sö Gadu bi taki da di fesiten hedima u dee Dju de kai Mosesi taa sö sëmbë musu du te de ko bunu u di lö siki dë, fu hii sëmbë sabi taa i ko bunu tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma hii fa a bai ën dë seei, ma tökuseei soni u Masa Jesosi paaja a hii di kamian dë. Nöö hii sëmbë ta ko nëën gidjii u de jei dee soni a ta taki, söseei faa heepi de a dee siki u de tu. ");
INSERT INTO srmNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma Masa Jesosi lobi u nango a sabana dendu go begi hën wanwan. ");
INSERT INTO srmNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wë nöö wan oto daka möön hën Masa Jesosi ta lei sëmbë ˻a wan wosu dendu˼. Nöö wanlö sëmbë u di keiki paatëi de kai Falisei ku dee Sabima u dee Djuwëti seei dë sindosindo naandë tu. De bi kumutu a hii dee köndëköndë u Galilea ku Judea, te dou ku Jelusalen. Nöö di juu dë, di kaakiti u Gadu bi dë a Masa Jesosi faa kula dee sikima. ");
INSERT INTO srmNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Te wan pisi hën wanlö womi ko dou ku wan lan sëmbë a wan kama liba ko suku heepi a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hën di de ko dou a di wosu ka Masa Jesosi dë, nöö sëmbë sai dë teee a hia. De an sa feni kamian seei u de tja di sëmbë go dou a Masa Jesosi. Nöö hën de subi go a di wosu liba, ˻biga dee wosu liba u di köndë bi dë palalaa sö˼. Nöö hën de go booko di wosu a liba ala. Nöö hën de saka di womi a di kama go a dee hia sëmbë dendu dë, go buta a Masa Jesosi fesi. ");
INSERT INTO srmNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nöö hën di Masa Jesosi si fa dee sëmbë biibi tjika, hën a taki da di sikima taa: “Womi, wë Masa Gadu puu i a bëë e. An ta mëni dee hogi i bi du möön.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nöö di dee Faliseima ku dee Sabima u Wëti jei fa Masa Jesosi taki, nöö hën de ta kuutu ën a de hati taa: “Huun? Unfa wan libisëmbë sa fan sö? Ambë da di sëmbë naandë di ta hoi Gadu a sipootu sö? Ambë tjika u puu sëmbë a Gadu bëë boiti hënseei nöö?” ");
INSERT INTO srmNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","23","Wë nöö Masa Jesosi sabi di pakisei de abi, nöö hën a piki de taa: “Dee sëmbë, andi mbei un musu ta pakisei dee soni dë u du? Andi seei mi musu du fuun sabi taa mi abi taki a di goonliba aki? Ee mi taa Gadu puu di sëmbë nëën bëë, ee nasö mi taki dëën taa be a hopo waka go nëën wosu, undi u de mi musu du fuun sabi taa mi abi taki a goonliba? ");
INSERT INTO srmNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma nöö un luku e, mi o lei unu taa Mi di ko dë Libisëmbë Mii aki, na fan nöö mi sa fan, ma mi abi makiti tuú a goonliba aki fu mi sa puu sëmbë a Gadu bëë.” Nöö hën a bia fan ku di sikima taa: “Mi taki e, hopo, nöö i tei di kama fii nöö i waka go fii a wosu.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hën wante dë, hën di sëmbë hopo a hii dee sëmbë tuu fesi. Hën a tei hën kama hën a ta waka ta gafa Masa Gaangadu nango nëën wosu. ");
INSERT INTO srmNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nöö hii sëmbë ko foondo. A bigi da de te na soni, hën de taa: “Aai, dee sëmbë, Masa Gaangadu bigi e. A bumbuu. U si foombo soni tide.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A baka u di dë, hën Masa Jesosi go si wan sëmbë de kai Leifi sindosindo nëën kantoo ka a ta pii lanti möni, nöö hën a kai ën faa ko dë bakama fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hën di womi hopo disa hii soni fëën dë, hën a waka go a Masa Jesosi baka. ");
INSERT INTO srmNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nöö hën de dë te wan daka, nöö hën Leifi mbei wan gaan piizii nëën wosu da Masa Jesosi. Nöö sömëni u dee sëmbë dee ta pii lanti möni ku sömëni oto sëmbë bi dë a di piizii ta njan ku de tu. ");
INSERT INTO srmNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Te wan pisi hën dee Faliseima, ku dee Sabima u Wëti dee ta nama ku dee Faliseima, ko si Masa Jesosi ku dee lö sëmbë dë sindosindo ta njan makandi, hën hati u de boonu. Hën de hakisi dee bakama u Masa Jesosi taa ee faandi mbei de ta njan ta bebe ku dee sëmbë dee ta pii lanti möni dë ku dee oto takulibi sëmbë u di köndë? ˻Biga bumbuu sëmbë an bi musu ta hulu dee lö sëmbë dë.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hën Masa Jesosi koti wan nöngö da de taa: “Ee wan sëmbë ja siki, nöö ja abi data fanöudu. ");
INSERT INTO srmNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nöö un haika e. Ma ko aki fu bumbuu sëmbë hedi e, ma u dee takulibi sëmbë hedi, u mi kai de u de bia de libi ko a Masa Gadu.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nöö hën dee Faliseima ku dee Sabima u Wëti toona hakisi ën taa: “Wë Mësitë o, andi mbei dee bakama fii an ta disa u njan fu begi hedi kumafa u ta disa? Biga dee bakama u Johanisi di Dopuma ta begi söndö njan hiniwanten, söseei dee bakama fuu ta begi söndö njan tu. Ma dee bakama fii ta njan ta bebe kodo. Unfa a waka?” ");
INSERT INTO srmNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nöö hën Masa Jesosi da de wan oto. A taa: “Ee wan sëmbë o tööu, nöö dee mati fëën o ko nëën a di tööu. Nöö fa hën ku de o sai dë, nöö de o ta njan ta piizii makandi. ");
INSERT INTO srmNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma tee di daka dou de puu ën a de mindi ufö de o ta kusumi ta tja hangi awaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nöö hën a toona da de wanlö oto möön ˻ta lei de kumafa di awoo lei u de ku di njunjun lei fëën an ta kai˼. A taa: “Dee sëmbë, un haika e. Na wan sëmbë o tei wan njunjun koosu pisi go lapu wan awoo koosu. Wë biga ee a du sö, nöö a o poi di njunjun wan nöö di awoo wan an o kai ku ën tu. ");
INSERT INTO srmNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Nöö söseei na wan sëmbë sa buta wan njunjun diingi a wan awoo mbeti kakisa saku. Biga a ko taanga kaa. Nöö te di diingi o soopu, nöö di awoo saku o bai latja. Di diingi o kaba a sösö nöö di saku seei o kaba a sösö tu. ");
INSERT INTO srmNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma te i buta di diingi a wan njunjun saku, nöö di saku dë diaan eti. Nöö te di diingi soopu, nöö di saku o tëndë, an o bai latja tuwë di diingi. Nöö di njunjun diingi ku di njunjun mbeti kakisa saku tuu o dë bunu. ");
INSERT INTO srmNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Ma nöö na wan sëmbë ta bebe awoo diingi nöö i kë bebe njunjun wan möön, biga joo si taa di awoo diingi suti möön di njunjun wan.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wë nöö a wan saba, hën Masa Jesosi ku dee bakama fëën ta waka ta pasa a wan goon dendu. Nöö wan sootu pei soni kuma alisi sö dë a di goon ma de sa njan mëën kuakua, nöö hën dee bakama ta booko ën ta buuka ta njan. ");
INSERT INTO srmNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nöö hën so u dee Faliseima hakisi de taa: “Faandi mbei un ta booko di soni a di saba daka u du? Nëën da un ta booko di wëti nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nöö hën Masa Jesosi piki de taa: “Ja bi lesi a di Buku u Gadu andi Dafiti bi du nö, di ten hangi bi ta kii hën ku dee oto sëmbë ku ën bi ta waka? ");
INSERT INTO srmNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","De bi ta lontu te de go dou a di wosu u Gadu dendu, hën Dafiti si dee bëëë de bi tja go buta da Gadu naandë. An bi dë soni u de musu njan, biga dee begima wanwan tö nöö bi sa njan mën. Ma tökuseei Dafiti njan mën, hën ku dee otowan fëën tuu. ˻Ma Gadu an bi tei de u hogi fu di fuka u de hedi.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Ma ˻boiti u di dë˼, un musu sabi taa mi di ko dë Libisëmbë Mii aki dë Masa u saba.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nöö hën wan oto saba möön, hën Masa Jesosi go lei sëmbë a keiki. Nöö hën wan sëmbë ko naandë di wan së maun fëën doba fika dëëdëë. ");
INSERT INTO srmNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nöö wanlö Sabima u Wëti ku dee Faliseima bi sai dë kaa, nöö hën de ta luku ee a o heepi di sëmbë naandë a di saba, u de feni föutu nëën fu de tja go kaagi. ");
INSERT INTO srmNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma nöö Masa Jesosi bi sabi kaa andi de ta mëni a de hati, hën a kai di sëmbë taa: “Womi, hopo ko taanpu a u fesi aki.” Nöö hën di sëmbë hopo hën a ko taanpu naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hën Masa Jesosi hakisi dee sëmbë sai dë taa: “Andi möön bunu fuu du a saba, hogi naa bunu? Fuu musu puu sëmbë a dëdë maun, naa fuu disëën faa dëdë? Unfa di wëti taki?” ");
INSERT INTO srmNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hën a luku dee sëmbë tuu lontu dou. Nöö hën a taki da di sëmbë taa: “Womi, tëndë di maun fii i si.” Nöö hën di di womi mbei kuma a kë tëndë di maun fëën, nöö hën wante hën a ko bunu djee kumafa a bi dë. ");
INSERT INTO srmNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nöö hën dee sëmbë hati ko boonu ku Masa Jesosi tee kuma de sa lau sö, nöö hën de seti kuutu ku deseei ee unfa u de du ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A di pisiten dë, hën Masa Jesosi go a wan kuun liba go begi Masa Gadu, nöö hën a tan dë begi wan hii ndeti. ");
INSERT INTO srmNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te di mamate fëën, hën a kai dee sëmbë dee bi ta waka nëën baka u de ko nëën. Nöö hën a tei tuwalufu sëmbë a de mindi, dee o dë apaiti tjabukama fëën de ta kai apösutu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nöö haika dee në u de. Di fosuwan de kai Simon, hënseei da Petuisi, ku ën baaa Andiasi, ku Jakobosi ku Johanisi ku Filipi ku Batolomisi, ");
INSERT INTO srmNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateosi ku Tomasi, ku Jakobosi wan mii u Alufasi, ku Simon di bi dë wan sëmbë u di paatëi de kai Zeloti, ");
INSERT INTO srmNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ku Judasi wan mii fu Jakobosi, ku Judasi Isikaliotu di sei Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nöö hën Masa Jesosi ku dee tuwalufu bakama dee a bi tei dë ku dee otowan dee fika, hën de saka go a goon a wan palala kamian. Nöö sëmbë u Jelusalen te dou ku dee oto kamian u Judea, ku sëmbë u de tu köndë ta dë a di ze bandja de kai Tilusi ku Sidon tuu sai dë kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","De ko u jei di lei fëën. So sëmbë ko faa kula de. So sëmbë bi abi soni a de liba ta toobi de, nöö hën de ko a Masa Jesosi faa puu de da de. Nöö hën a puu de tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Hii sëmbë bi ta mbei möiti u de nama nëën, biga di kaakiti u Masa Gaangadu ta kumutu nëën ta kula de tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nöö hën Masa Jesosi hopo wojo luku dee bakama fëën, nöö hën a taa: “Un dee möfina sëmbë aki, un dë bunu e, biga woon njan di bunu u di Njunjun Tii u Masa Gaangadu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nöö un dee sëmbë dee ta hangi fuun ko kumafa Masa Gadu kë, nöö un dë bunu e, biga woon feni ën sö tuu. “Nöö un dee sëmbë dee ta këë, un dë bunu, biga di këë fuunu o bia ko lafu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nöö un dë bunu e, un dee sëmbë oto sëmbë an sa si a wojo fu di un ta biibi a Mi di ko dë Libisëmbë Mii aki hedi. Fa de ta puu unu a de mindi ta kosi unu ta poi unu në a köndëköndë, nöö un dë bunu e. ");
INSERT INTO srmNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nöö un musu piizii, un musu wai seei, biga a Masa Gadu Köndë woon kisi wan gaan paima. Biga söseei dee fesiten sëmbë fuunu bi du ku dee fesiten tjabukama u Masa Gadu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ma un dee sëmbë dee taa: ‘U abi gudu, ˻nöö wa abi Masa Gaangadu fanöudu möön,˼’ mi bai helu da unu, biga te bakaten te di gudu fuunu kaba, nöö wan o a’ soni möön. Biga un bi njan di bunu fuunu tuu a fesi kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Nöö un dee sëmbë dee ta mbei taa un dë fa un kë, ˻wan abi Masa Gadu fanöudu möön,˼ mi bai helu da unu biga a bakaten wan o dë kumafa un kë möön. “Nöö un dee sëmbë dee ta wai ta lafu fu di un feni andi un kë, mi bai helu da unu biga a bakaten këë nöö woon ta këë. ");
INSERT INTO srmNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Nöö un dee sëmbë ta kisi gafa a köndë ˻fu di un ta libi kumafa dee sëmbë dee an dë a Masa Gadu së kë˼, mi bai helu da unu. Biga söseei dee fesiten sëmbë dee bi ta ganjan taa de ta tja Gaangadu buka bi kisi gafa tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Hën Masa Jesosi toona taki da de taa: “Ma un dee sëmbë dee kë jei mi tuutuu aki, un haika. Mi taki e, un musu lobi dee felantima fuunu, nöö un du bunu da dee sëmbë dee abi hogihati fuunu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nöö söseei un musu wensi bunu da dee sëmbë dee ta siba unu ta kosi unu. Nöö un musu begi da dee sëmbë dee ta du hogihogi ku unu tu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Nöö ee wan sëmbë naki i baaimaun a bandjajesi, nöö i bia di oto së dëën be a toona naki e. Nöö ee wan sëmbë tei di liba koosu fii, nöö ja musu tapëën fu an tei di basu koosu fii tu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nöö söseei ee wan sëmbë hakisi i wan soni, nöö ja musu niingëën. Ee wan sëmbë tei soni fii, nöö ja musu toona tei ën nëën baka. ");
INSERT INTO srmNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Nöö leti kumafa i kë fu sëmbë musu libi ku i, nöö sö seei i musu libi ku sëmbë tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Hën a taki da de möön taa: “Un haika e, dee sëmbë. Ee i ta lobi dee sëmbë dee ta lobi i nöö, nöö ja o feni gafa naandë e. Biga na wan apaiti soni i ta du dë. Biga dee sëmbë dee an dë ku Masa Gadu a wan së, sö deseei ta libi tu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Nöö söseei ee i ta du dee sëmbë bunu dee ta du i bunu wanwan, nöö ja o feni gafa fëën tu. Biga sö nöö dee sëmbë dee an dë ku Masa Gaangadu a wan së ta libi u de kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Nöö ee i juu wan sëmbë soni fu di i sabi taa a o toona da i ën baka, nöö ja du wan apaiti soni fii kisi gafa e. Biga sö nöö dee sëmbë dee an dë ku Masa Gadu a wan së ta du tu. Nöö un musu libi bunu möön de. ");
INSERT INTO srmNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Biga un musu lobi dee felantima fuunu. Un musu du de bunu. Ee joo juu sëmbë soni, nöö i musu juu di sëmbë di ja abi pakisei taa joo feni soni nëën baka. Nöö te i du sö, nöö joo kisi wan gaan paima a Gadu e. Nöö a di fasi dë woon djeesi unu Tata Masa Gadu tu, biga sö a ta libi. A abi bunuhati u sëmbë, biga dee sëmbë an ta dëën tangi seei a ta heepi te kisi ku dee hogihati sëmbë tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Nöö un musu ta abi tjalihati u sëmbë e, leti kumafa Masa Gadu abi tjalihati.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nöö hën Masa Jesosi toona taki da de taa: “Ja musu ta kaagi sëmbë e, dee sëmbë, nöö de an o kaagi i tu. Ja musu kuutu de u de musu kisi sitaafu, nöö Masa Gadu an o kuutu i tu, fii kisi sitaafu. Ja musu ta hoi otowan a bëë nöö Masa Gaangadu an o hoi i a bëë tu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","I musu ta da sëmbë soni, nöö i seei o kisi tu. Nöö möön hia seei joo kisi e. Biga Gadu o lai ën a wan gaan manda ta zin ta fugu tee di manda an sa tei möön, nöö a hopo ën da i. Biga ku di wan seepi maaka di i ta maaka da otowan, nöö ku ën seei de o maaka da i tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nöö hën a koti wanlö nöngö da de, a taa: “Bookowojoma an sa tja bookowojoma a maun e. Biga de tuu o go kai a ngötö dendu kaba a sösö. ");
INSERT INTO srmNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nöö söseei wan siköö mii an o sabi soni kuma di mësitë fëën e, ma te a ta lei te a ko sabi ufö a o ko dë kuma di mësitë.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Nöö hën a taa: “Dee sëmbë o, unfa i ta si di piki sundju a di otowan fii wojo fii taki dëën taa: ‘Womi, be mi puu di sundju a i wojo dë da i,’ ma di gaan wan a i seei wojo dë, ja ta si ën? I bödjëëma, i musu puu di gaan sundju di dë a i seei wojo te i kaba, nöö i sa si bunu fii puu di u di otowan dëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nöö hën a taa: “Ee wan pau ta pai sösö njanjan, nöö an dë wan bumbuu pau e. Söseei wan pau di ta pai bumbuu njanjan an dë wan sösö pau tu. ");
INSERT INTO srmNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Biga hiniwan pau i sa sabi ën nëën njanjan. Ja o feni apeesina naa alandja pau, nöö söseei ja o feni mamaun a panpantii. ");
INSERT INTO srmNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dati wan taki ee i dë hogihatima, nöö ja o taki bumbuu soni. Nöö ee i dë bumbuu sëmbë, ja o taki hogihatima soni. Ma kumafa di hati fii dë, nöö sö di buka fii o ta fan.” ");
INSERT INTO srmNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nöö hën Masa Jesosi toona lei dee sëmbë soni möön. A taa: “Dee sëmbë o, faandi mbei un ta kai mi ‘Masa’ ma wan ta du dee soni dee mi ta taki da unu fuun du? ");
INSERT INTO srmNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","“So sëmbë ta ko a mi ta ko ta jei di lei u mi, nöö te de go nöö de ta du kumafa de jei dë. Nöö sö wan sëmbë, a dë kuma wan sëmbë di o mbei wan wosu fëën, nöö hën a seti ën ku wan goonsei taangataanga gingin kuma sitonu. Hën a mbei di wosu te a kaba. Nöö hën a bakaten, hën wan gaan tjuba kai tee na soni, singi di kamian pii. Ma töku di wosu an booko kai möönsö. A fika taanputaanpu apë fu di de seti ën bunu sö. ");
INSERT INTO srmNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Ma di sëmbë di ta jei di lei u mi ma an ta du kumafa mi ta lei ën, nöö a dë kuma wan sëmbë di ta mbei wan wosu fëën, nöö hën a seti ën a sandu liba mbei te a kaba. Nöö hën a baka, hën wan gaan wata ko sawa di wosu tja go fiaa. Biga di goonsei an bi dë gingin tjika.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A baka u di Masa Jesosi kaba u lei dee sëmbë naandë, nöö hën a toona go a Kapenaumi. ");
INSERT INTO srmNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nöö wan oposii u dee Loomë Köndë sodati bi dë a di köndë dë. Nöö a abi wan futuboi fëën di a lobi gaanfa, ma nöö hën di futuboi siki tee a dë a maunmaun. ");
INSERT INTO srmNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nöö hën di di oposii jei u Masa Jesosi, nöö hën a go a wanlö Gaan Womi u dee Dju sëmbë go hakisi de ee de sa go a Masa Jesosi go begi ën faa ko kula di futuboi fëën dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Nöö hën dee sëmbë hopo go a Masa Jesosi, hën de begi ën seei taa be a ko heepi di womi da de, mbei di futuboi fëën ko bunu. De taa: “Di womi aki, a dë wan sëmbë di lobi u Dju sëmbë e. Biga di keiki fuu seei a heepi u mbei fiaa. Wë nöö hën u si taa a fiti fii sa du ën di bunu aki da u.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nöö hën Masa Jesosi hopo wante faa go ka di oposii ta libi. Nöö hën de ta waka nango. Ma nöö di de ko zuntu, hën di oposii manda sëmbë u de taki dëën taa: “Ma bumbuu tjika fii musu ko a mi wosu e. ");
INSERT INTO srmNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hën mbei miseei an ko a i tu. Ma be i taki wan wöutu nöö, nöö di sëmbë u mi o ko bunu kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Wë biga miseei, fa mi dë aki nöö mi dë a sëmbë basu, nöö mi abi sodati a mi basu tu. Nöö ee mi taki da wan u de taa be a go ala, nöö a o hopo go. Ee mi taki da wan otowan taa be a ko aki, nöö wante a dou kaa. Ee mi taki da di futuboi u mi taa be a du di dë, nöö wantewante a ta du ën. Nöö söseei mi sabi taa ee i, Masa Jesosi, taki ee wan wöutu seei, nöö a o pasa sö kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nöö hën dee sëmbë go, hën de da Masa Jesosi di buka te de kaba. Nöö di a jei fa di oposii taki, nöö a bigi dëën tee na sondi. Hën a bia luku hii dee sëmbë dee bi ta waka ku ën naandë. Hën a taa: “Dee sëmbë, a bigi da mi e. Biga di wakama dë ko ta biibi mi möön leki un dee Isaëli sëmbë u di köndë aki seei.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nöö hën dee sëmbë dee bi tja di buka ko dë toona go. Nöö di de go dou a wosu, hën de si taa di futuboi u di oposii ko bunu kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nöö baka u di dë, hën Masa Jesosi go a wan köndë de kai Nain, hën ku dee bakama fëën ku wanlö hia oto sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nöö di de go dou a di dööbuka u di peni di lontu di köndë, nöö hën de si wanlö sëmbë kumutu ta waka ta ko ku wan dëdë de ta tja go bei. Di sëmbë naandë bi dë di wan kodo womi mii tö fëën mama, nöö di mama manu bi dëdë disëën kaa. Nöö di mama ku sömëni sëmbë ta waka ta ko. ");
INSERT INTO srmNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nöö di Masa Jesosi si di mama u di mii, nöö tjali fëën kisi ën. Hën a fan ku di ën taa: “Mujëë o, kabuka.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nöö hën a waka go panjan di daagi, nöö hën dee sëmbë ta tja di dëdë taanpu pii. Nöö hën a taa: “Womi, hopo.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nöö hën wantewante dë, hën di dëdë sëmbë weki. Hën a hopo sindo, hën a seti fan. Nöö hën Masa Jesosi taki da di mama taa: “Luku di mii fii aki. Ko tei i soni.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wë nöö di soni di pasa dë, a bigi da dee sëmbë tee na soni. De taa: “Masa Gadu bigi e, dee sëmbë. A ko heepi u dee sëmbë fëën te a manda wan gaan tjabukama fëën ko da u.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nöö hën di oto dë paaja a hii Judea te dou ku dee oto köndë tuu dee dë zuntu dë. ");
INSERT INTO srmNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wë nöö di dee bakama u Johanisi di Dopuma jei hii dee oto u Masa Jesosi dë, hën de go konda de da Johanisi ka a dë a dunguwosu dë. Nöö hën Johanisi kai tu u dee bakama fëën ko nëën ");
INSERT INTO srmNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","faa manda de go a Masa Jesosi. A taki da de taa: “Wë un sabi taa Masa Gadu bi paamusi taa a bi o manda wan sëmbë ko da u ˻faa puu u a dee fuka fuu˼. Nöö un go a Jesosi e, go hakisi ën ee hën da di sëmbë dë, naa a dë a baka ta ko eti.” Sö Johanisi manda di buka. ");
INSERT INTO srmNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nöö hën dee bakama u Johanisi nango tefa de go dou a Masa Jesosi. Nöö hën de taki dëën taa: “Wë Johanisi di Dopuma manda u fuu musu ko hakisi i ee i da di sëmbë di Masa Gadu bi paamusi taa a bi o manda ko da u, naa a dë a baka ta ko eti?” ");
INSERT INTO srmNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nöö a di ten dë seei, Masa Jesosi bi dë ta kula wanlö hia sëmbë. De bi ko nëën ku peipei siki, ku gadu a hedi, so u de dë bookowojo sëmbë, nöö de ko faa heepi de. Hën a ta kula de te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hën a fan ku dee bakama u Johanisi taa: “Wë un toona go, nöö un konda dee soni dee un si aki dëën e, ku dee soni dee un jei aki. Un taki dëën taa bookowojo sëmbë ko ta si soni, lan sëmbë ko ta waka, tjinama ta ko bunu, bookojesima ko ta jei soni, dëdë sëmbë ta weki baka a dëdë, dee möfina sëmbë ta jei di buka u Masa Gadu ˻leti kumafa di tjabukama bi taa sö a o dë te di Paamusi Könu ko˼. ");
INSERT INTO srmNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“Nöö i taki da Johanisi tu taa di sëmbë di ta futoou mi te an ta mati fu di ma ta du kumafa a bi mëni, nöö sö wan sëmbë dë bunu e. Sö fuun taki dëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hën di dee bakama u Johanisi go kaa, nöö hën Masa Jesosi bia ko ta hakisi dee sëmbë dee sai dë taa: “Dee sëmbë aki, fa un bi go a Johanisi a di sabana ala, un sooti sëmbë un go si ala? Un si wan sösö sëmbë di na a’ pakisei fëën seei nö, kuma wan kambaluwa di di ventu ta tja nango ta ko? ");
INSERT INTO srmNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Andi un bi si? Un si wan sëmbë di bisi wan gaan hanso bisi ta wai ta njan ta bebe nö? Nönö e! Dee sëmbë ta libi di lö libi dë, a guduma wosu de ta dë, na a sabana dendu. ");
INSERT INTO srmNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Naa un si wan gaan tjabukama u Masa Gadu? Aai, hën un si dë tuu. Ma Johanisi bigi möön wan tjabukama seei e. ");
INSERT INTO srmNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Biga hën da di sëmbë di Buku u Gadu bi taki taa a o manda ko a di Heepima fesi, faa seeka di pasi dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Nöö mi taki da unu e, taa fu dee sëmbë de bi pai a fesiten te kisi fa u dë aki, nöö Johanisi di Dopuma hei möön de tuu. Ma tökuseei fa Masa Gadu ta hopo di Njunjun Tii fëën aki, nöö dee möön lagi sëmbë dee ta dë a di Tii fëën dendu, nöö de a’ bunu hedi möön Johanisi e.” Sö Masa Jesosi taki. ");
INSERT INTO srmNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wë nöö fa Johanisi bi ko dë, nöö dee sösö sinkii sëmbë u di köndë ku dee sëmbë ta pii lanti möni, de bi piki di buka fëën. Biga de ko si taa Masa Gadu a’ leti. Nöö hën de bia de libi hën de mbei Johanisi dopu de. ");
INSERT INTO srmNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma dee fesima u keiki kuma dee Faliseima ku dee Sabima u Wëti, de an bi kë di heepi Masa Gadu bi o heepi de möönsö. Biga de bi niinga u bia de libi fu Johanisi dopu de. ");
INSERT INTO srmNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nöö hën mbei Masa Jesosi taki da de taa: “Wë nöö ambë seei mi sa tei maaka ku dee sootu pei sëmbë aki? ");
INSERT INTO srmNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","De djei dee mii ta pëë a sitaati. Ee i mbei fofio da de u de baja, de an o baja. Ee i kanda këë kanda da de u de këë, de an o këë. ˻Nöö sö dee fesima u keiki dë tu. Ja sa du soni te a kai ku de möönsö.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wë biga di Johanisi di Dopuma ko, nöö an ta njan dee njanjan u di köndë, an ta bebe dee soni u di köndë, hën de feni taa didibi dë nëën liba. ");
INSERT INTO srmNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nöö hën Mi di ko dë Libisëmbë Mii aki ko, nöö hën mi ta njan ta bebe kuma dee otowan. Nöö hën de feni taa mi a’ langabëë, mi dë bebesonima, mi ta hoi mati ku dee sëmbë ta pii lanti möni ku dee oto hogilibi sëmbë u di köndë. ");
INSERT INTO srmNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Ma antoobi. Fa de ta taki dë seei, ma töku dee sëmbë u Masa Gadu o sabi di köni fëën. ˻De o sabi taa mi ku Johanisi tuu ta libi bunu.˼” ");
INSERT INTO srmNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Hën de dë te wan daka, hën wan u dee Faliseima de kai Simon kai Masa Jesosi faa ko nëën wosu ko njan ku ën. Nöö hën Masa Jesosi hopo, hën a go a Simon wosu. Nöö hën a sindo a wan langa bangi ˻tëndë futu buta nëën liba, kumafa guwenti u de dë a di köndë te de o sindo a tafa u njan˼. ");
INSERT INTO srmNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nöö wan mötjö mujëë bi dë a di köndë. Nöö di a jei taa sö Masa Jesosi dë a Simon wosu, nöö hën a o go ala tu. Nöö di a nango, hën a tja wan gaan dii bata sumëësuti fatu. ");
INSERT INTO srmNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nöö hën a go dou. Hën a go taanpu leti a Masa Jesosi futu së, nöö hën a seti këë. Hën a ta bosi Masa Jesosi futu ta këë tefa di wojowata fëën munjëën futu pëtëëë, nöö hën a dëë ën ku di uwii u hedi fëën. Nöö hën a tei di sumëë suti fatu hën a tutu ën a Masa Jesosi futu. ");
INSERT INTO srmNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nöö di Simon si di sondi, nöö hën a ta guunjëën nëën hati taa: “Wë, ee di sëmbë aki dë wan tjabukama u Masa Gadu tuu, nöö a musu u sabi taa di mujëë naandë dë wan jajo mujëë. An bi musu nama nëën seei.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nöö hën Masa Jesosi kai ën, “Simon.” Hën a piki. A taa: “Wë, mi kë taki wan soni da i.” Hën a taa: “Andi wë, Mësitë?” ");
INSERT INTO srmNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hën a taa: “De bi dë tu womi bi juu möni a wan sëmbë. Wan u de juu teni dusu kölu, di otowan juu feifi höndö kölu. ");
INSERT INTO srmNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nöö hën de dë a di taki dë ta bia nango ta ko biga de an sa feni di möni u de paka di womi. “Te wan pisi hën di womi ko taki da de taa an dë u de paka di möni möön. Be de disa di möni dë soni seei ku piizii.” Sö wan oto Masa Jesosi taki te a kaba, nöö hën a hakisi Simon taa: “Wë de tu sëmbë dë, undi u de o lobi di sëmbë möön taanga?” ");
INSERT INTO srmNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Hën Simon taa: “Wë misikuma di womi di bi juu möön hia möni.” Hën a taa: “Wë awa, i piki bunu. ");
INSERT INTO srmNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","46","Nöö luku, fa i kai mi, mi ko a i wosu aki.” A taki aai. “Ja da mi wata fu mi wasi futu, ja bosi mi, ja tutu fatu a mi hedi, ja du na wan wojo soni da mi kumafa di guwenti dë. Ma nöö luku di mujëë aki. Fu sensi di a ko aki, hën a ta këë ta munjan mi futu ku ën wojowata ta dëë mi futu ku di uwii u hedi fëën. A bosi mi futu seei, hën a tei wan gaan dii sumëësuti fatu lobi a mi futu. ");
INSERT INTO srmNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Nöö mi taki e, di mujëë i si aki sö, nöö Masa Gadu puu ën a bëë u hii dee hogilibi fëën tuu dee a bi ta libi. Hën mbei wë i si a lobi mi ta wai ku mi sö. “Biga di sëmbë di sabi taa a du hia hogi hën Gadu puu ën a bëë, nöö di sëmbë dë hën o lobi Gadu möön taanga. Ma di sëmbë di pakisei taa wan piki hogi sö nöö a bi du nöö Gadu puu ën a bëë, nöö di sëmbë dë o lobi Gadu wan pikiwan nöö.” ");
INSERT INTO srmNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nöö hën Masa Jesosi bia fan ku di mujëë taa: “Mujëë, i kisi paadon e. Masa Gadu an hoi dee hogi fii i bi du nëën bëë möön!” ");
INSERT INTO srmNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nöö hën dee oto sëmbë ku Masa Jesosi bi sindo a tafa naandë, hën de ta fan ku deseei taa: “Wë ambë da di sëmbë aki di ta puu sëmbë a Gadu bëë?” ");
INSERT INTO srmNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Hën Masa Jesosi taa: “Mujëë, di biibi fii heepi i e. Nöö i go fii a wosu ku piizii.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A baka u di dë, hën Masa Jesosi go ta waka a dee köndëköndë ta tja di Bunu Buka ta konda da lanti taa Gadu tja di Njunjun Tii fëën ko a goonliba awaa. Nöö de tuwalufu bakama fëën bi dë ku ën, ");
INSERT INTO srmNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ku wanlö mujëë tu. A fesi nöö dee mujëë dë bi dë ku siki, nöö hën a kula de ko bunu. So u de, soni bi kisi de a hedi hën a jaka de puu. Wan u dee mujëë de ta kai Malia u di köndë de kai Magidala, hën bi abi sëbën gadu nëën hedi hën Masa Jesosi puu de tuu dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wan otowan möön de kai Johana, hën manu de kai Kusasi, wan hedima u Könu Helodi wosu, ku wan de kai Susana, ku sömëni otowan möön bi dë ku Masa Jesosi ku dee bakama fëën ta waka ku de ta lontu. De ta heepi de a dee soni dee de bi abi fanöudu u de sa libi, ta puu de a fuka a di së u möni soni. ");
INSERT INTO srmNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wan daka hën sömëni sëmbë kumutu a dee köndëköndë ta ko a Masa Jesosi te a hila. Nöö hën a tei wan oto faa lei de soni. A taa: ");
INSERT INTO srmNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wan daka hën wan sëmbë go nëën goon go ta paandi wan soni ˻kuma alisi˼. Nöö di a ta jaa di sii, nöö hafu kai a pasi liba, nöö sëmbë ta waka dë ta makisëën ku futu te an sa ko soni, ufö dee piki fou ta pii ën ta njan tu. ");
INSERT INTO srmNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","“Nöö hafu u di sii kai a sitonu goon. Nöö di a booko wojo ko nöö hën a toona dëdë, fu di di kamian aan doti tjika nöö an ta feni wata kumafa a dë fanöudu. ");
INSERT INTO srmNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Nöö so fëën kai ka maka dë, nöö hën di maka göö ko peetëën kii. An sa ko soni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Ma nöö hafu u di sii kai a bunu goon, nöö hën a göö tee a puu njanjan te a hila.” Sö wan oto Masa Jesosi taki te a kaba. Nöö hën a taa: “Fa mi fan ku unu aki, nöö un pakisei ën bunu e, be un fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nöö baka u di dë, hën dee bakama fëën ko hakisi ën faa puu di hedi u di oto da de. ");
INSERT INTO srmNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nöö hën a taa: “Wë un haika e. Dee tjubitjubi soni u di Njunjun Tii u Masa Gadu, unu musu sabi de tuu. Ma dee oto sëmbë, ˻de dë kuma dee sëmbë Esaja bi taki taa:˼ De ta luku ma de an ta si soni. De ta haika ma de an ta fusutan. Hën mbei mi ta fan ku de a nöngö.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hën a taki da de taa “Wë di puu u di oto dë sö taa: di sii, hën da di Wöutu u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nöö di ka di sii kai a di pasi, hën da te wan sëmbë jei di Wöutu, nöö di didibi ko puu ën nëën hati wante fu an fika ta biibi u Gadu heepi ën. ");
INSERT INTO srmNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Nöö di ka a kai a sitonu goon, nöö hën da di sëmbë di kisi di Wöutu seei ku wai, ma te toobi miti ën faa poobëën luku ee a biibi Gadu tuutuu, nöö a ta toona tuwëën disa biga aan lutu wan bëtë. ");
INSERT INTO srmNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Nöö di ka a kai a maka kamian, nöö hën da di sëmbë di tei di Wöutu tuu, ma a a’ bookohedi u dee soni u di goonliba aki tumisi. A ta pakisei dee peipei libi u di goonliba aki, hogi wan ku bunu wan tuu, ta suku gudu ku piizii. Dee lö soni dë ta fuu di sëmbë hati te nöö di Wöutu an sa ko soni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ma nöö ka di sii kai a bunu goon, hën da a kai a wan bumbuu sëmbë hati. Nöö di a jei di Wöutu, nöö a ta hoi ën nëën hati ta pakisei ën tee a ko soni seei nëën libi.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nöö hën a taki möön taa: “˻Di Wöutu u Masa Gadu dë kuma wan faja e.˼ Nöö na wan sëmbë o sëndë faja te a kaba, nöö a butëën a wan bungu dendu, nasö a soni basu. Ma a o butëën a wan heihei kamian ka hii dee sëmbë dë a di wosu sa si soni ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nöö te di limbo fëën kai ko dë, nöö na wan soni o fika tjubitjubi tee nöö sëmbë an o si ën e, nöö na wan soni sa danga tee an o sa ko a limbo. ");
INSERT INTO srmNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nöö un seti jesi be un jei bunu e, dee sëmbë. Biga di sëmbë di bi jei soni kaa, nöö a o sa jei möön hia. Ma di sëmbë di an kë jei seei, nöö di piki soni di a bi mëni taa a jei, hën a o toona lasi.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wan daka hën Masa Jesosi dë a wan wosu ta lei sëmbë. Te wan pisi hën hën mama ku dee baaa fëën ko u ko luku ën, ma dee sëmbë bi hia a di kamian tee de an sa feni pasi u go dou nëën. ");
INSERT INTO srmNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nöö hën wan sëmbë go taki da Masa Jesosi taa: “Mësitë o, i mama ku dee baaa fii ko a i aki. De dë a döö dë, nöö de kë si i.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hën a taa: “Sö nö baa? Wë nöö dee sëmbë i si mi ku de dë aki, nöö de da mi mama ku mi baaa e. Wë biga dee sëmbë dee ta jei Gadu buka ta piki ën, de da mi bëë kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wan daka hën Masa Jesosi ku dee bakama fëën dë a wata bandja dë, hën a taki da de taa: “Un boo subi a boto koti wata go a di oto së banda ala.” Nöö hën wante hën de subi a boto tuusi go a mindi wata. ");
INSERT INTO srmNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nöö hën Masa Jesosi go kandi ta duumi. Hën de nango te wan pisi, hën wan gaan ventu ko ta seki di wata tee di boto ta biinga seei u singi. ");
INSERT INTO srmNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hën de go kai ën weki taa: “Masa hesi, hopo ooo, hopo! Woo dëdë a wata tuu kaba!” Nöö hën Masa Jesosi hopo, nöö hën a gandji da di wata ku di ventu. Nöö hën wantewante dë hën di wata ku di ventu tuu ko kötö piii. ");
INSERT INTO srmNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nöö hën Masa Jesosi hakisi de taa: “Dee sëmbë aki, andi mbei un fëëë sö? Naasë di biibi fuunu dë? ˻Wan sabi taa mi ku unu dë aki nö?˼” Ma nöö fa a du dë, nöö a foondo de te de ko fëëë. Hën de ta hakisi de na de taa: “Wë ambë seei da di sëmbë aki, dee sëmbë? Biga ventu ku wata tuu ta piki ën buka.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nöö baka u di dë, hën Masa Jesosi ku dee bakama fëën nango teefa de go tjökö a di pisiwata u dee Galasëni sëmbë, leti a oto banda u Galilea dë. ");
INSERT INTO srmNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Nöö di a nango a tela, hën wan sëmbë u di köndë ko miti ku ën. Di lö sëmbë dë, a abi wanlö hia taku soni nëën liba, nöö de dë nëën liba longi kaa. An ta bisi koosu a sinkii, an ta libi a wosu, an ta libi seei kumafa libisëmbë ta libi möön, ma a ta dë fëën a dee sitonu baaku ka de ta bei dëdë. Dee sëmbë u di köndë mbei möiti a hii fasi te de wei. De ta tai ën ku bui, ma a ta booko dee bui kölökölö seei lusu puu, nöö dee taku soni nëën liba ta hai ën ta tja go a dee sabana kamian. Na tide oto de ta penëën sö. Nöö hën di a si Masa Jesosi, nöö hën a kai olo tuwëën seepi a goon a Masa Jesosi fesi. Nöö hën a taa: “Jesosi, i di Mii u di Möön Hei Gadu a liba, andi mi ku i abi? I ko aki fii ko pena mi nö? Mi begi i, na sitaafu mi e!” Biga Masa Jesosi bi bai ën kaa taa a musu kumutu a di sëmbë liba. ");
INSERT INTO srmNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nöö hën Masa Jesosi hakisi ën taa: “Un në fii?” Hën a taa: “Mi da A-Hila-Möön-Hii.” Biga de bi dë hia te sëmbë an sa konda de. ");
INSERT INTO srmNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nöö hën de begi Masa Jesosi fa an musu tuwë de go a di sitaafu kamian u de eti. ");
INSERT INTO srmNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nöö wanlö hagu bi dë a wan kuun bandja ta pii soni ta njan. Nöö hën dee soni taa be Masa Jesosi da de pasi fu de go a dee hagu dë. Nöö hën a taa: “Un go!” ");
INSERT INTO srmNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nöö hën de kumutu a di womi, hën de go a dee hagu. Nöö fa u ta taki aki, hën dee hagu kumutu kule gililili go kai a wata djulululu dëdë fiaa. ");
INSERT INTO srmNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hën dee sëmbë dee bi ta luku dee hagu, hën de kule go a ganda go paaja di buka te dou a hii kamian u di köndë dë tuu taa sö wan soni de si. ");
INSERT INTO srmNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nöö hën hii dee sëmbë tuu booko kumutu a dee kamiankamian ko luku andi pasa. Nöö hën de go si di womi di dee soni bi dë nëën liba dë, sindosindo a Masa Jesosi bandja a goon dë piii. A dë ku koosu a sinkii, ku ën bumbuu fusutan. Nöö hën de tuu ko fëëë. ");
INSERT INTO srmNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nöö hën dee sëmbë dee bi si di soni, hën de konda da dee otowan fa Masa Jesosi bi puu dee soni a di sëmbë liba. ");
INSERT INTO srmNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nöö hën di fëëë de fëëë dë, hën mbei hii dee sëmbë u di pisiwata dë begi Masa Jesosi taa, gaantangi be a kumutu a di köndë u de go. Nöö hën Masa Jesosi subi a di boto faa go. ");
INSERT INTO srmNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nöö hën di sëmbë di Masa Jesosi bi puu dee soni nëën liba naandë, hën a taki da Masa Jesosi taa a kë go ku ën. Ma Masa Jesosi taki dëën taa: ");
INSERT INTO srmNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wë, nönö, mati. Toona go a i köndë, nöö i go konda da dee sëmbë kumafa Gadu du i bunu tjika.” Hën di sëmbë piki, nöö hën a go nëën köndë go ta paaja di buka ta konda da hii sëmbë di bunu di Gadu du ën. ");
INSERT INTO srmNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hën Masa Jesosi ku dee bakama fëën toona koti go a di oto së banda ka de bi kumutu. Nöö di de go dou, nöö hën dee hia sëmbë bi sai dë wai ku de, biga de bi dë ta luku Masa Jesosi faa toona ko. ");
INSERT INTO srmNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nöö a di ten dë seei, hën wan hedima u keiki de kai Jailusi ko a Masa Jesosi. Nöö hën a tjökö kini a goon nëën fesi begi ën taa gaantangi be a ko nëën wosu. ");
INSERT INTO srmNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Biga a abi wan kodo mujëë mii fëën tö nöö a abi tuwalufu jaa, ma nöö a siki seei tee a dë a dëdë ku libi maun. Nöö hën Masa Jesosi piki ën taa, “Söö. Wë antoobi, mati. Un boo go.” Nöö hën de tei pasi nango, nöö hën wanlö hia sëmbë ta waka ku ën ta peetëën seei tee na soni. ");
INSERT INTO srmNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nöö di juu dë, hën wan mujëë bi sai a di köndë naandë, a bi dë ku wan siki tuwalufu jaa longi kaa, soni ta kule nëën an ta tapa möönsö. A go a data seei te a wei, ma an sa ko bunu möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hën di a jei taa Masa Jesosi ko dë, nöö hën wë a waka saapisaapi nëën baka go panjëën a dee jëkëjëkë u di koosu buka fëën. Nöö hën wante, hën a ko bunu kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma nöö hën Masa Jesosi bia hakisi taa: “Ambë panjan mi?” Nöö hën de tuu ta piki taa: “Na mi.” Disi taa: “Na mi.” Disi taa: “Na mi.” Nöö hën Petuisi taa: “Wë Masa, luku fa dee sömëni hia sëmbë ta peeta i aki. Nöö unfa joo du sabi ambë panjan i?” ");
INSERT INTO srmNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hën Masa Jesosi taa: “Aai, ma seei mi sabi taa wan sëmbë panjan mi. Biga mi fii wan kaakiti kumutu a mi sinkii go kula wan sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nöö hën di mujëë si taa wë di soni an sa tjubi möön. Nöö hën a ko ku panta seei ko tjökö kini a goon a Masa Jesosi fesi a hii dee sëmbë wojo dë. Nöö hën a konda hii soni dëën, andi mbei a waka ko panjan di koosu jëkëjëkë fëën, ku fa a ko bunu. De tuu a pii konda dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nöö hën Masa Jesosi taa: “Mujëë, na fëëë möön e. Di biibi fii aki, nöö a heepi i kaa. Go fii a i wosu ku piizii.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nöö di juu dë seei, hën wan u dee sëmbë u di hedima u keiki di bi ko kai Masa Jesosi faa ko kula di mujëë mii fëën dëën, ko dou. Hën a taki dëën taa: “Mati, gaan soni. An dë fii mbei di Mësitë ko möön e, biga di mii fii dëdë kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma nöö hën Masa Jesosi seei taki da di tata u di mii taa: “Na fëëë e, mati. Hoi di biibi fii a mi liba nöömö, nöö joo si. Di mii fii o toona ko bunu.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nöö hën de nango te de go dou a di wosu. Nöö Masa Jesosi an kë oto sëmbë go ku ën a di wosu ka di mii dë möön leki Johanisi, Petuisi, Jakobosi, ku di mii tata ku ën mama nöö. ");
INSERT INTO srmNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nöö di a go dou a di wosu dendu, hën a taki da dee sëmbë dee ta bai ta këë naandë taa be de an këë möön. Wë biga di mii na dëdë a dëdë, duumi a ta duumi. ");
INSERT INTO srmNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nöö hën de lafu ën mbei ën fa, biga de bi sabi tuutuu taa di mii dëdë. ");
INSERT INTO srmNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nöö hën a pasa go dou a di mujëë mii. Nöö hën a panjëën a maun, hën a kai ën taa: “Mujëë mii, hopo e.” ");
INSERT INTO srmNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nöö hën wantewante dë, hën di mujëë mii weki hën a hopo. A libi baka. Nöö hën Masa Jesosi taa be de dëën soni u njan. ");
INSERT INTO srmNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nöö di soni foondo di mama ku di tata u di mii te na soni. Ma Masa Jesosi taki da de taa: “Di soni i si pasa aki, nöö wan musu taki ën da sëmbë e.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A baka u di dë, hën Masa Jesosi kai dee tuwalufu bakama fëën ko nëën. Hën a da de kaakiti ku taki fu de ta jaka dee gadu ta puu a sëmbë hedi. Söseei a da de kaakiti tu u de ta kula hii sootu pei siki u sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nöö hën a manda de u de go ta lontu a dee peipei köndë ta konda da sëmbë taa Masa Gadu ta hopo di Njunjun Tii fëën fa u dë aki. Nöö söseei tu de musu kula dee sikima ko bunu. ");
INSERT INTO srmNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hën a taki da de taa: “Fa woon go aki, nöö wan musu tja soni go ku unu e. Wan musu tja wakatiki. Wan musu tja saku. Wan musu tja njanjan. Wan musu tja möni. Nöö dee koosu dë a unu sinkii dë, nöö ku de nöö un musu go. ");
INSERT INTO srmNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nöö te wan sëmbë hoi unu nëën wosu, nöö naandë un musu dë fu tee un kumutu a di köndë dë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Nöö te un go a wan köndë, nöö te de an kë haika di buka fuunu, nöö un musu feki di sandu u di köndë di bi peka a unu basufutu puu tuwë da de e, be a fika kuma wan maaka taa un bi konda di buka da de ma de an bi këën. Nöö a fika da de.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nöö hën de go. De ta waka a dee köndëköndë ta konda di Bunu Buka u Masa Gadu ta kula sömëni sikima. ");
INSERT INTO srmNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Di juu dë, hën Könu Helodi, di ta tii Galilea Köndë, ko jei hii dee soni Masa Jesosi ta du. Nöö a toobi ën tee na soni, biga de an sabi ambë ta du dee soni dë. So sëmbë taa wë Johanisi di Dopuma ˻di di könu bi kii˼ hën hopo baka a dëdë ko ta du dee soni. ");
INSERT INTO srmNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","So sëmbë taa di fesiten tjabukama u Masa Gadu de kai Elia hën toona ko, ee nasö wan u dee oto awoo fesiten tjabukama hën weki baka. ");
INSERT INTO srmNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hën Könu taa: “Wë Johanisi miseei bi kii, nöö ma sabi ambë da di sëmbë dë.” Nöö hën a ta mbei möiti nöömö faa musu si ën. ");
INSERT INTO srmNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nöö hën a baka wan pisiten, nöö hën dee tjabukama toona ko a Masa Jesosi, hën de konda dëën fa soni bi waka di de tja di Buka go a dee köndëköndë. Nöö hën Masa Jesosi tei de, nöö hën de ku ën go a ˻wan sabana kamian zuntu ku˼ wan köndë de kai Betisaida, de wanwan. ");
INSERT INTO srmNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nöö di lanti jei taa Masa Jesosi go a di kamian dë, nöö hën de faakëën. Nöö di a si de, hën a kisi de ku wai. Nöö hën a ta konda da de kumafa Masa Gadu ta hopo di Njunjun Tii fëën fa u dë aki. Hën a ta kula dee sikima u de tu. ");
INSERT INTO srmNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nöö hën de dë te di sapate buka, hën dee bakama u Masa Jesosi ko nëën. Hën de taki dëën taa: “Masa o, fa u dë a di kamian aki, nöö a lati kaa. Nöö na fii manda dee sëmbë go nö, be de go a dee boiti ku dee köndë dee dë a zuntu aki go suku soni u njan ku kamian u duumi.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nöö hën Masa Jesosi taki da de taa: “Wë nönö, wan musu mbei dee sëmbë go e. Un da de soni u njan.” Hën de taki dëën taa: “Wa abi soni u njan aki möön leki feifi bëëë ku tu fisi tö. Ee na i kë fuu go bai soni u njan da de, ma de hia e!” ");
INSERT INTO srmNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nöö hën Masa Jesosi taki da de taa: “Wë un mbei dee sëmbë sindo a hipihipi u feifiteni sö te dou.” Biga dee sëmbë bi dë kuma feifi dusu womi sö bifö i abi mujëë ku mii. ");
INSERT INTO srmNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nöö hën dee bakama go seeka dee sëmbë buta te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nöö hën Masa Jesosi hopo wojo a liba, nöö hën a da Masa Gadu tangi. Hën a booko dee bëëë ku dee fisi pisipisi, hën a da dee bakama fëën. Nöö hën de tja go paati da dee sëmbë, ");
INSERT INTO srmNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","hën de njan tee bëë u de fuu. Nöö hën dee bakama go pii dee pisi dee fika te de kaba, de fuu tuwalufu gaan manda. ");
INSERT INTO srmNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wan daka möön, hën Masa Jesosi go dë a wan kamian hën wanwan ta begi. Te wan pisi hën dee bakama fëën ko nëën, hën a hakisi de taa: “Wë fa mi ku unu ta waka ta lontu aki, ambë lanti ta taki taa mi dë? Andi u mi de ta pakisei?” ");
INSERT INTO srmNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hën de taa: “Wë u ta jei de ta taki taa i da Johanisi di Dopuma di de bi kii, hën toona weki. So sëmbë taa i da Elia, di fesiten tjabukama u Masa Gadu, hën toona weki ko a goonliba baka. Ee nasö wan u dee oto fesiten tjabukama kuma ën, hën toona weki. Sö de ta mëni.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nöö hën Masa Jesosi hakisi de taa: “Wë unu wë, fa mi ku unu ta waka ta lontu aki, ambë un mëni da mi?” Nöö hën Petuisi piki ën taa: “Masa o, i da di Paamusi Könu e, di Keesitu di Gadu bi paamusi taa a o manda ko da u ˻faa heepi u˼.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nöö hën Masa Jesosi bai de taa de an musu konda di soni dë da na wan sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nöö hën a taki da de taa: “Un haika e, dee sëmbë. Mi di ko dë Libisëmbë Mii aki musu tja sömëni sitaafu e. Fa dee Gaan Womi ku dee Gaan Begima ku dee Sabima u Wëti sai dë, de an dë a mi du nöö de o tja mi go kii. Ma a di u dii daka fëën nöö mi o toona weki baka a dëdë e.” Sö Masa Jesosi taki da de te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hën a taki da de möön taa: “Ee wan sëmbë i kë ko a mi baka, nöö dee du fii an musu hati i fii disa e. Nöö hiniwan daka i musu ta tja di sitaafu di o ta miti i fu di i ta waka a mi baka, leti kumafa wan sëmbë ta tja wan lakpa pau u de pekëën kii. ");
INSERT INTO srmNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Biga ee wan sëmbë i ta suku fii hoi i libi ku dee du fii, nöö ja o feni ën kumafa i kë möönsö e. Ma di sëmbë di hopo ën seei ku telu da mi, nöö hën o feni ën kumafa a kë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wë biga ee wan sëmbë i feni hii bunu u di goonliba aki tuu ma i dëdë go a didibi faja, nöö andi i wini? ˻Nëën da i sei i hedi bai kaapusa nö?˼ ");
INSERT INTO srmNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Biga ee wan sëmbë sen ta kisi i fii piki taa i nama ku mi ta tei dee lei u mi a goonliba aki, nöö söseei tu te mi go te mi ko u mi ko tei di könu bangi u mi, nöö sö sen o kisi mi da i tu. Biga wan daka o dou di mi o ko ku di gaan waiti u mi ku di u mi tata, ku di u dee basia u Gadu Köndë ala tuu. Nöö di juu dë, sen o kisi mi tu fu mi nama ku di sëmbë naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Nöö dee sëmbë, un haika bunu e. Fa mi ta fan ku unu aki, nöö so u dee sëmbë dë aki an o dëdë bifö de o si fa Masa Gadu o hopo di Njunjun Tii fëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","A baka u aiti daka fu di Masa Jesosi taki dee oto dë, nöö hën a tei Johanisi ku Petuisi ku Jakobosi go a wan kuun liba go ta begi. ");
INSERT INTO srmNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nöö di a ta begi tee wan pisi, nöö hën fesi fëën ko tooka. Dee koosu nëën sinkii tuu ko ta sëndë kuma te Gadu ta koti faja. ");
INSERT INTO srmNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Te wan pisi, hën tu sëmbë ko naandë ko ta fan ku Masa Jesosi. Dee sëmbë dë seei sinkii ta sëndë te na soni tu, kumafa dee sëmbë ta libi a Masa Gadu Köndë sinkii ta sëndë. Nöö fa de ko ta fan ku ën naandë, de dë wanlö fesiten tjabukama u Masa Gadu dee bi dëdë gaanduwe kaa. Wan de kai Mosesi, wan da Elia. De ko ta fan ku Masa Jesosi u di wooko di Masa Gadu bi mandëën ko a goonliba faa du. Biga de ta taki soni u di fa a o dëdë a Jelusalen. ");
INSERT INTO srmNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Di juu dë, nöö Petuisi ku dee otowan fëën bi ta duumi. Te wan pisi, nöö hën de weki. Nöö hën de bia luku, de si Masa Jesosi sinkii ta sëndë seei, nöö de si de tu sëmbë tu dee ku hën ta fan dë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nöö hën di de tu sëmbë o toona go, nöö hën Petuisi taa: “Wë Masa o, a suti fa u dë aki. Nöö ee i kë, nöö u sa mbei dii tjëkëliba, wan fii, wan u Mosesi, ku wan u Elia.” (Ma wë fa Petuisi ta fan dë seei, nöö a dë kuma an saandi a ta taki e.) ");
INSERT INTO srmNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nöö an kaba u fan seei, hën de si wan bundji saka zaaa ko tapa de. Nöö dee bakama ko fëëë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nöö hën de jei wan töngö a di bundji dendu taa: “Di sëmbë aki sö, hën da di Womi Mii u mi di mi tei manda ko a goonliba. Nöö hën fuun musu haika e.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nöö di de jei di fan sö kaa, hën de ko si taa Masa Jesosi wanwan tö nöö fika naandë. Nöö sö wan soni dee sëmbë si pasa e. Ma nöö fa de si ën seei, ma de an kondëën da na wan sëmbë möönsö di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Di dobooko fëën, hën de kumutu a di kuun liba saka ko a goon, nöö sömëni sëmbë ko miti ku de. ");
INSERT INTO srmNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nöö hën wan sëmbë a de mindi bai taa: “Mësitë, gaantangi, heepi mi ku di wan kodo womi mii u mi aki o. ");
INSERT INTO srmNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wan soni ta ko nëën liba, nöö a ta bai ta tuwëën a goon, nöö sukuma ta kumutu nëën buka. Ee fuu taki, an ta disëën möönsö. Möönmöön a ta kabëën a sösö. ");
INSERT INTO srmNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nöö mi bi begi dee bakama fii fu de puu ën da mi, ma de an sa puu ën.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hën Masa Jesosi taa: “Huun? Andi seei mi feni a dee sëmbë u di ten aki maun? Fa mi ku de ta dë aki, de an ta biibi möönsö. Taangajesi nöö de abi sö. Fu un longi ten mi musu dë ku unu ta hoi pasensi da unu ufö woon biibi mi?” Hën a taki da di sëmbë taa: “Tja di mii ko da mi aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nöö hën di sëmbë ta waka ta ko ku di mii a Masa Jesosi. Ma nöö de an dou seei, hën di soni kisi di mii tuwë a goon dobëën buta kakakaa. Nöö hën Masa Jesosi bai ën taa, “Hetji pasa kumutu a di mii liba e!” Nöö hën a kumutu wante, di mii ko bunu. Nöö hën Masa Jesosi tei di mii hën a dëën tata. ");
INSERT INTO srmNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nöö di soni foondo dee sëmbë tee de taa: “Maingë, mi fëëë di kaakiti u Masa Gadu e! Aai, a a’ poosian tuu.” Fa dee sëmbë ta fan dë, hën Masa Jesosi taki da dee bakama fëën taa: ");
INSERT INTO srmNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Un haika e, dee sëmbë. Mi o taki wan soni da unu aki, nöö un musu hoi ën fu wan fëëkëtëën. ˻Fa i si dee sëmbë ta gafa mi aki seei,˼ ma wan ten o dou nöö de o tja Mi di ko dë Libisëmbë Mii aki go sei da sëmbë fu de kii mi puu.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma nöö di fan a fan dë, a dë wan foombo soni da dee bakama fëën. De an fusutëën möönsö, biga a dë wan tjubitjubi soni da de. Ma seei de bi fëëë u de hakisi ën andi da di soni. ");
INSERT INTO srmNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wë nöö di juu dë, hën wan gaan toobi hopo a dee bakama dendu. De ko ta hakisi deseei taa: “Undi fuu seei dë di möön hei wan a di wooko aki?” ");
INSERT INTO srmNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nöö hën Masa Jesosi saandi de ta pakisei, hën a go tei wan mii tja ko buta nëën bandja naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Hën a taki da de taa: “Dee sëmbë o, un si di mii aki sö? ˻An dë wan hei sëmbë, ma tökuseei˼ di sëmbë di ta tei ˻sö wan lagilagi sëmbë kuma˼ di mii aki fu mi hedi, nöö hën da a ta tei miseei tu. Nöö di sëmbë di ta tei mi, nöö hën ta tei di Sëmbë di manda mi ko aki. “Nöö di sëmbë di a’ sakafasi te a ta butëën seei a hii dee otowan fëën basu, nöö hën da di möön hei sëmbë a Masa Gadu wojo e, dee sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nöö hën wan u dee bakama u Masa Jesosi de kai Johanisi taki dëën taa: “Masa, u bi si wan sëmbë ta puu soni a sëmbë liba ku i në, ma di sëmbë dë an bi ta nama ku i kumafa u ku i nama aki. Nöö hën u tapëën taa be an musu du sö.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Hën Masa Jesosi taa: “Wë nönö womi, wan musu tapëën e. Biga ee wan sëmbë an dë feantima fuunu, nöö hën da unu ku ën dë a wan së.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wë nöö di juu dë, Masa Jesosi ten ko zuntu faa toona go a Gadu Köndë ka a bi kumutu. Nöö di a sabi sö kaa, hën a buta taa a o go a Jelusalen. ");
INSERT INTO srmNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nöö hën a manda wantu u dee bakama fëën go a fesi u de go suku kamian u de duumi a pasi. Nöö hën dee bakama fëën go te de go dou a wan u dee köndë u dee Samalia sëmbë, hën de go hakisi wanlö sëmbë dë kamian u de ku Masa Jesosi duumi. ");
INSERT INTO srmNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma nöö dee sëmbë sabi taa a Jelusalen de nango, nöö hën mbei de piki de taa de aan kamian da de u de duumi. ");
INSERT INTO srmNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nöö hën dee sëmbë bia toona ko piki Masa Jesosi baka. Nöö hën di Johanisi ku Jakobosi jei di soni, hën de hakisi Masa Jesosi taa: “Masa o, ja kë fuu kai faja kumutu a liba ko kaba dee sëmbë dë a sösö nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nöö hën Masa Jesosi bai de taa: “Nönö womi, un sooti pei pakisei da di dë? Un kaba ku dee soni dë!” ");
INSERT INTO srmNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nöö hën de pasa go suku kamian a oto köndë duumi. ");
INSERT INTO srmNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nöö fa de dë a pasi nango dë, hën wan sëmbë ko a Masa Jesosi ko taki dëën taa: “Mi kë go ku i aluwasi naasë i nango.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hën Masa Jesosi piki ën taa: “Wë a bunu, ma i sabi nö? Dee mbeti abi baaku ka de ta kandi duumi, nöö söseei dee piki fou abi wosu tu. Ma Mi di ko dë Libisëmbë Mii aki, ma abi kamian ka mi ta dë e. ˻Ma ee i kë sö, nöö i ko boo go.˼” ");
INSERT INTO srmNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nöö hën wan oto daka möön, hën Masa Jesosi kai wan womi faa musu ko dë bakama fëën. Hën di womi taa: “Antoobi, mi sa ko, ma mi kë begi i wan soni ufö. Mi kë dë te mi tata dëdë mi bei te mi kaba, nöö mi ko e.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hën Masa Jesosi taa: “Wë nönö womi, be dee sëmbë dee an dë a mi du bei dee dëdë sëmbë u de e. Ma ju, be i ko go ku mi go paaja di Buka, be sëmbë ko sabi taa Masa Gadu ta hopo di Njunjun Tii fëën fa u dë aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nöö hën wan oto daka möön, hën wan womi taki da Masa Jesosi taa a kë ko bakama fëën. Ma a kë faa dëën pasi be a go da dee sëmbë fëën wosu adjoisi ufö a ko. ");
INSERT INTO srmNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nöö hën Masa Jesosi piki ën taa: “Aai, wë mi jei, ma i sabi nö? Ee wan sëmbë ta du wan wooko ku tu hati nöö di wooko dë an o ko bumbuu soni möönsö. Nöö ee wan sëmbë ta wooko a di lö fasi dë, nöö an bumbuu tjika faa ko dë wan wookoma a di Tii u Gadu dendu e.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wan oto daka möön, hën Masa Jesosi kai sëbënteni-ku-tu u dee bakama fëën ko nëën. Nöö hën a manda de tu ku tu u de musu go a dee pikipiki köndë ku dee gaangaan köndë ka hënseei bi pakisei faa musu go, ˻be de konda da dee sëmbë taa Gadu ta hopo di njunjun tii fëën˼. ");
INSERT INTO srmNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nöö hën a taki da de taa: “Un haika e, dee sëmbë. Di goon bigi nöö di njanjan lepi u koti, ma wookoma biti poi. Nöö un begi Masa Gadu e, faa puu hia sëmbë manda go a di wooko fëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nöö hën a toona taa: “Fa mi ta manda unu aki, mi ta manda unu leti kuma sikafu mii nango a pëndë mbeti dendu. Ma un go nöö. Mi ta manda unu. ");
INSERT INTO srmNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nöö fa woon go dë, wan musu tja möni e, wan musu tja saku. Nöö dee susu un tuusi a unu futu dë, nöö ku de nöö un musu go. Nöö te un nango, wan musu ta buuja ta da oto ku sëmbë a pasi. ");
INSERT INTO srmNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","6","“Nöö ee de kai unu a wan wosu fuun go duumi, nöö un musu begi da di sëmbë abi di wosu taa: ‘Masa Gadu musu dë ku i e.’ Nöö fa woon taki dë, nöö ee wan bumbuu sëmbë sai naandë di fiti u feni di bunu i begi dëën dë, nöö di bunu o tan a di wosu. Ma ee di sëmbë an fiti di lö bunu dë, nöö di bunu o toona ko a unu baka. ");
INSERT INTO srmNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Nöö fa de o tei unu a di wosu dë, nöö naandë un musu tan e. Wan musu kumutu ku unu lai go libi a oto wosu. Nöö te de da unu soni u njan, nöö un musu njan mën. Sen an musu kisi unu. Biga wan wookoma musu feni hën paima fu di wooko di a ta du. ");
INSERT INTO srmNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nöö te un go a wan köndë nöö ee de kisi unu ku piizii, nöö di soni i si de seeka da unu fuun njan nöö hën un musu njan e. ");
INSERT INTO srmNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","“Nöö un kula dee sikima dee sai a di köndë dë. Nöö un taki da hii dee sëmbë taa di ten kisi u Masa Gadu hopo di Njunjun Tii fëën awaa, ˻nöö be de seeka u ko nëën˼. ");
INSERT INTO srmNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Ma te un go a wan köndë, nöö ee dee sëmbë dë nëën an kë haika unu, nöö un musu go taanpu a sitaati u di köndë, nöö un taki da de taa: ");
INSERT INTO srmNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Di doti u di köndë aki di bi peka a u futu, nöö u feki ën puu tuwë disa da unu e, kuma wan maaka taa Masa Gadu o sitaafu unu. Biga u bi ko fuu konda da unu taa Masa Gadu ta hopo di Njunjun Tii fëën fa u dë aki, ma wan këën. Nöö di hebi fëën fika da unu e. U, u nango.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nöö hën a toona taki möön taa: “Nöö un musu sabi taa a di daka di Masa Gadu o kuutu hii mundu, nöö di sitaafu di köndë dë o kisi o möön hogi möön leki di hogi köndë de kai Sodom bi kisi e.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nöö hën Masa Jesosi taa: “Mi bai helu da un dee sëmbë ta libi a Kolazin ku dee u Betisaida e. Wë biga ee dee köndë de kai Sidon ku Tilusi bi si dee gaan foombo wooko dee mi ta du a unu mindi aki, nöö de bi o bia de libi gaanduwe kaa. Di hogilibi u de bi o hati de tee de bi o bisi djodjo go sindo a goon ta tuwë sindja a de sinkii. Sö a bi o hati de tjika. Ma un dee sëmbë u Kolazin ku Betisaida si dee foondo wooko u mi, ma töku wan a’ toobi möönsö fuun disa dee hogilibi fuunu. ");
INSERT INTO srmNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Nöö hën mbei mi taki taa tee Masa Gadu o kuutu goonliba, nöö di sitaafu woon kisi o hogi möön di Sidon ku Tilusi o kisi. ");
INSERT INTO srmNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Nöö un dee sëmbë u Kapenaumi tu, unfa un mëni? Un mëni taa di hei fuunu aki o tja unu go a Gadu Köndë nö? Nönö e, na seei. Ma a didibi faja a o tja unu go! ˻Biga mi ko a unu ma wan tei di lei u mi u soni möönsö.˼” ");
INSERT INTO srmNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nöö hën Masa Jesosi taki da dee bakama fëën taa: “Ee wan sëmbë ta piki unu buka, hën da a ta piki di buka u mi kaa. Ma ee wan sëmbë an tei unu, nöö hën da an tei mi tu, söseei an tei di Sëmbë di manda mi ko aki tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nöö hën de sëbënteni-ku-tu bakama u Masa Jesosi go tefa de toona ko, nöö de ta wai seei. De taki dëën taa: “Masa o, fa u go dë, nöö dee gadu bi saka a u basu seei, di u tei di në fii bai de.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hën Masa Jesosi taki da de taa: “˻Awa, sö de o saka da unu tuu.˼ Biga miseei bi si fa di kaakiti u didibi bi booko saka gaanduwe kaa. Mi si ën, a kumutu a liba ala pasa a mi wojo valau sö, kuma liba koti faja go a goon. Nöö fa dee gadu saka a unu basu dë, nöö sö de o ta saka. ");
INSERT INTO srmNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“Biga mi ta da unu makiti a di gaan felantima fuu liba e, ku hii dee hogi soni dee a o manda ko a unu, te dou ku sindeki ku kukutulabu tuu. De an o sa du unu hogi. ");
INSERT INTO srmNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Ma tökuseei na fu di soni dë hedi un musu ta wai e. Na fu di dee gadu ta saka a unu basu mbei un musu ta wai tu. Ma un musu ta wai seei fu di un sabi taa në fuunu dë sikifisikifi a Masa Gadu Köndë ala.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nöö hën di Akaa u Gadu mbei Masa Jesosi ko wai tee na soni. Hën a taa: “Masa Gadu, gaantangi fii o. I da Masa u liba ala ku goonliba aki tuu. Nöö mi da i tangi u di a dë taa i tjubi dee soni fii da dee könima ku dee sabisonima u di goonliba aki te de an sa sabi de möönsö. Nöö hën i toona mbei dee lagilagi sëmbë aki dee ta piki i buka, ko sabi de. Aai Taata, gaantangi fii e. Biga sö i feni ën taa a bunu. Wë nöö i bigi e, Taata.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Hën a taa: “Dee sëmbë o, mi Tata buta hii soni a mi maun e. Nöö na wan sëmbë sabi kaba u di Mii boiti di Tata nöö. Söseei na wan sëmbë sabi kaba u di Tata tu boiti di Mii nöö, ku di sëmbë di di Mii kë faa ko sabi ën.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nöö hën a bia luku dee bakama fëën, nöö hën a taki da de taa: “Un dee sëmbë aki, un abi bunuhedi e, fu dee soni dee un ta jei ku dee un ta si aki. ");
INSERT INTO srmNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Biga sömëni u dee fesiten tjabukama ku dee könu tuu bi hangi u de si dee soni un ta si aki. De bi hangi tu u de jei dee soni dee un ta jei aki, ma de an bi sa jei de.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te wan daka, hën wan u dee sabima u wëti hopo go a Masa Jesosi u go poobëën luku. Nöö hën a hakisi ën taa ee andi faa musu du te nöö a sa feni di teego libi u Masa Gadu. ");
INSERT INTO srmNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hën Masa Jesosi hakisi ën taa: “Andi sikifi a Gadu Buku? Andi i ta lesi nëën?” ");
INSERT INTO srmNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hën a taa: “Wë mi ta lesi taa i musu lobi Masa Gadu ku hii i hati ku hii i akaa ku hii i taanga ku hii pakisei fii. Nöö i musu lobi di otowan fii leti kumafa i lobi i seei.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nöö hën Masa Jesosi taa: “Wë fa i piki dë, nöö i piki bunu. Sö fii libi tuu, nöö joo dou a Masa Gadu Köndë.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma di di womi si taa di soni a hakisi dë nëën a feni, hën a toona hakisi Masa Jesosi taa: “Wë ambë da di otowan u mi di mi musu lobi kuma miseei?” ");
INSERT INTO srmNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nöö hën Masa Jesosi tei wan oto konda dëën. A taa: “Wan sëmbë bi kumutu a Jelusalen nango a Jelikou. Nöö hën a nango te wan pisi, hën wanlö fufuuma ko kisi ën panjan. Hën de fon mën te a fon. Hën de tei dee soni fëën dee a bi tja tuu, te kisi ku dee koosu dee bi dë nëën sinkii. Hën de disëën a goon dë a dëdë ku libi maun, hën de go u de. ");
INSERT INTO srmNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Nöö hën a sai dë te wan pisi, hën wan u dee begima di ta wooko a Masa Gadu Wosu ko ta pasa. Nöö di a si di womi a goon dë, hën a koti lontu a oto së pasa go fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Nöö a baka u di dë, hën wan u dee bakamii u Leifi di ta wooko a Masa Gadu Wosu ko ta pasa tu. Nöö di a ko si di womi a goon dë, hën a luku ën diin te a kaba. An du wan wojo soni möönsö. Hën a koti lontu a oto së pasa go fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“A baka fëën hën wan Samalia sëmbë ko ta pasa dë tu. Nöö di a si di womi a goon naandë, nöö hën tjali fëën kisi ën te a taa: ‘Wë di sëmbë aki, ˻fa u ku dee lö sëmbë aki dë feanti seei˼ ma tjali fëën kisi mi, nöö ma sa disëën aki go. Mi musu heepi ën.’ ");
INSERT INTO srmNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","“Nöö hën a go a di womi go lobi deesi a dee koti buka fëën hën a tai de te a kaba. Hën a hopo ën buta a di mbeti fëën liba, hën a ta tjëën te a wan lantiwosu. Nöö naandë a go sölugu ën. ");
INSERT INTO srmNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Nöö di mamate hën a hopo, nöö hën a go a di sëmbë di abi di wosu. Nöö hën a tei möni, hën a dëën. Hën a taki dëën taa: ‘Womi o, gaantangi baa, luku di sëmbë aki bunu da mi, nöö ee di möni an tjika nöö te mi toona nöö mi o paka i dou.’ ” Sö wan oto Masa Jesosi taki te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nöö hën a bia hakisi di womi di bi ko nëën dë taa: “Wë mati, andi i pakisei u de dii sëmbë naandë? Undi u de libi ku di womi kuma di otowan fëën di a ta lobi kuma hënseei?” ");
INSERT INTO srmNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hën di womi taa: “Wë misikuma di sëmbë di bi a’ tjalihati fëën dë.” Hën Masa Jesosi taa: “Wë nöö i piki bunu. Nöö i go e, nöö i libi kumafa di womi dë libi dë.” ");
INSERT INTO srmNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nöö di Masa Jesosi ku dee bakama fëën dë a pasi nango ˻a Jelusalen dë,˼ te wan pisi hën de go dou a wan köndë. Nöö hën wan mujëë de kai Maita kai ën faa ko nëën wosu. Nöö hën a go. ");
INSERT INTO srmNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wë nöö Maita bi abi wan sisa fëën de ta kai Malia. Nöö fa Masa Jesosi ko a de dë, hën Malia go sindo leti nëën fesi a goon naandë ta haika dee soni a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Maita bi dë ku bookohedi ta seeka soni u njan da Masa Jesosi ku dee bakama fëën. Hën de dë te wan pisi, an sa tjëën möön. Nöö hën a fan ku Masa Jesosi taa: “Masa o, ja si nö? Fa i si i ko aki, nöö hën Malia disa mi wanwan tö fu mi seeka hii soni da unu. Ja sa mandëën fa a ko heepi mi nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hën Masa Jesosi piki ën taa: “Wë Maita o, mujëë, haika e. I dë ku gaan pakisei ta booko hedi a sömëni soni. ");
INSERT INTO srmNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ma wan soni nöö dë fanöudu e, mujëë. Fa i si Malia ko sindo ta haika mi aki, nöö hën du di möön bunu soni, nöö ma o puu ën nëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wan daka hën Masa Jesosi bi dë a wan kamian ta begi. Hën a begi teefa a kaba, nöö hën wan u dee bakama fëën hakisi ën taa: “Masa o, andi mbei ja sa lei u fa fuu begi tu, kumafa Johanisi lei dee bakama fëën?” ");
INSERT INTO srmNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hën a taki da de taa: “Antoobi. Mi o lei unu. Te woon begi, nöö sö fuun musu taki: Ke, u Tata a liba, hii sëmbë musu lesipeki i e. De musu sabi taa i dë bumbuu limbolimbo. U begi taa di Tii fii musu paaja a hii goonliba. ");
INSERT INTO srmNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nöö u begi i fii da u dee soni u abi fanöudu fuu pasa u libi tide. ");
INSERT INTO srmNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nöö u begi i tu, be i puu u a bëë u dee hogi dee u ta du, leti kumafa u seei ta puu dee otowan fuu a bëë fu dee hogi de ta du u. Nöö u begi i taa na disa u da dee soni dee sa hai u tja go a di së u hogi e. Sö fuun ta begi e, dee sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Hën a toona taki da de taa: “Ee wan sëmbë i a’ wan bunu mati, nöö hën wan sëmbë ko a i a mindi ndeti, nöö joo go a di mati fii. Nöö joo taki dëën taa: ‘Mati, gaantangi baa, mi ko begi i soni. Wan mati u mi kumutu a kamian ko a mi, nöö ma a’ sondi u njan fu mi dëën. Gaantangi, juu mi dii bëëë.’ ");
INSERT INTO srmNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Nöö di sëmbë o piki i taa: ‘Haika, na toobi mi a di juu aki e. Mi söötö döö go kandi kaa. Mi ku dee mii u mi dë a kamba aki, de ta duumi. Ma sa hopo go tei bëëë da i möön e.’ Ma nöö fu di di fuka fii bigi, nöö joo ta naki di döö kodo ta begi ën nango nöömö. ");
INSERT INTO srmNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Nöö mi taki e, kandë an o jabi di döö da i fu di un dë mati hedi. Ma fu di i ta naki di döö nëën hedi nöömö te an sa feni pasi duumi, nöö hën mbei a musu hopo tei di bëëë da i kuma di mëni i abi fanöudu. ");
INSERT INTO srmNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Fëën mbei mi taki da unu taa i musu ta begi Masa Gadu nöömö e, nöö a o da i di soni di i ta begi ën. I musu ta suku di soni i abi fanöudu nëën, nöö joo feni ën. I musu ta naki di döö fëën, nöö a o jabi ën da i. ");
INSERT INTO srmNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Biga di sëmbë di ta begi ën, nöö hën a ta da. Di sëmbë di ta suku nëën, nöö hën o feni. Nöö di sëmbë di ta naki di döö fëën, hën a o jabi ën da. ");
INSERT INTO srmNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Wë nöö fa un dë aki, ee di mii fii pidi i wan pisi fisi nöö i sa tei wan sindeki pisi dëën nö? Na seei. ");
INSERT INTO srmNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nöö ambë dë a unu mindi aki tu di o tei kukutu labu da hën mii ee a pidi i obo. Nönö, sëmbë an dë e. ");
INSERT INTO srmNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","“Wë nöö fa un ta du hogi so juu seei, ma un sabi taa un musu da dee mii fuunu bumbuu soni, wë nöö unu Tata a liba wë? An sa da unu di Akaa fëën tu nö, te un ta begi ën.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Te wan oto daka möön, hën Masa Jesosi puu wan soni bi dë a wan womi liba. Di soni bi tapa di womi buka nöö di Masa Jesosi jakëën puu, nöö wantewante a ko ta fan bumbuu baka. Nöö di soni foombo hii sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma seei so u dee sëmbë kosi Masa Jesosi. De taa: “Fa i si a ta puu dee soni a sëmbë liba aki, nöö na ku wan oto kaakiti möönsö, ma ku di kaakiti u di hedima u dee didibi de kai Belisabo, ku ën wë a ta du ën e.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nöö hën wanlö sëmbë sai dë kë poobëën luku. Hën de hakisi ën taa: “Wë dee soni dee i ta du aki, nöö ee i da sëmbë u Masa Gadu tuu, nöö lei u wan maaka be u sa sabi taa Gadu dë ku i tuu.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma Masa Jesosi sabi fa de ta pakisei ˻taa na sëmbë u Gadu a dë, ma a dë sëmbë u didibi˼. Nöö hën a taki da de taa: “Hiniwan köndë di hopo ta feti ku ën seei, nöö an sa tan e. A o booko. Söseei hiniwan famii di hopo ta feti ku ën seei o kaba a sösö tu. ");
INSERT INTO srmNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Wë nöö ee dee didibi hopo ko ta feti ku deseei, nöö unfa i mëni de o du? Na kaba de o kaba a sösö nö? Didibi sa jaka dee otowan fëën go nö? “Wë nöö di un bai taa ku kaakiti u di hedima fu dee didibi mi ta puu dee otowan fëën, ");
INSERT INTO srmNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","nöö dee sëmbë fuunu dee ta puu soni a sëmbë liba wë? Ambë kaakiti de tei ta du ën? Biga di wan puu nöö u tuu ta puu de. Nöö naandë a o waka mbei dee sëmbë fuunu seei o da unu adjabëë. ");
INSERT INTO srmNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“˻Nöö un mëni unu seei ku dee lö pakisei dë e.˼ Biga ku di kaakiti u Masa Gadu wë mi ta du dee soni aki. Wë nöö di mi ta du de ku di kaakiti u Masa Gadu, nöö hën da Gadu hopo di Njunjun Tii fëën a unu mindi awaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Hën a toona taki da de möön taa: “Un haika. Solanga wan taanga sëmbë dë fëën seekaseeka ku ën feti lai ta luku ën wosu, nöö na wan kodo sëmbë seei sa ko fufuu soni fëën tja go e. ");
INSERT INTO srmNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma te wan oto sëmbë ko di taanga möön hën, nöö a o sa ko kisi ën panjan feti ku ën tee a wini ën. Nöö a o tei hii dee feti lai fëën dee a bi ta mëni u heepi ën seei, ku dee gudu fëën tuu, tja go paati da dee otowan.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nöö hën Masa Jesosi taki da de möön taa: “Fa u taki dee soni aki, nöö di sëmbë di an kë nama ku mi, nöö hën da felantima u mi kaa e. Söseei di sëmbë di an ta suku sëmbë tja ko da mi, nöö hën ta jaka sëmbë puu a mi.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nöö hën a taa: “Te wan gadu dë a wan sëmbë hedi, nöö te a kumutu disëën go, nöö a o ta waka ta lontu ta suku kamian ka dee otowan fëën ta libi te a wei. Nöö a o taa: ‘Wë, nönö, ma feni kamian aki u mi tan.’ “Nöö a o bia toona ko a di sëmbë hedi ka a bi kumutu dë seei. ");
INSERT INTO srmNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nöö te a ko naandë nöö a o si di kamian limbolimbo hooo. ˻Di sëmbë an feni wan bumbuu soni buta nëën möönsö.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nöö paa, tjala! A toona ko a di sëmbë hedi baka. Nöö a o go kai sëbën gadu hogiwan möön leki ën seei, nöö de o ko lai a di sëmbë naandë hedi. Nöö di lö sëmbë naandë, tan fëën o ko dë möön hogi gaanfa möön fa a bi dë a fesi.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nöö fa Masa Jesosi ta fan dë, nöö hën wan mujëë bi sai a dee sëmbë mindi dë hopo bai fan ku ën. A taa: “Womi, di mama fii di pai i, a abi kölöku e, fu di Gadu feni taa hën musu pai i.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hën Masa Jesosi piki ën taa: “˻Aai, mujëë,˼ ma fa i si u dë aki, nöö dee sëmbë dee ta jei di Wöutu u Masa Gadu ta piki ën buka, nöö de ta feni di möön gaan bunu möön leki di sëmbë di pai mi e.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nöö fa de dë ala, nöö sëmbë ta ko a Masa Jesosi naandë gidjii sö. Hën a taa: “Dee sëmbë u di ten aki, de abi takuhatiböö. Na biibi de kë biibi sö e, ma de ta ko a mi u de feni maaka a mi. Ma ma abi oto maaka u lei de möön leki di maaka u di fesiten tjabukama de ta kai Jona e. ");
INSERT INTO srmNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","“Wë biga leti kumafa Jona bi dë wan maaka da dee sëmbë u Ninifei, nöö söseei Mi di ko dë Libisëmbë Mii aki dë wan maaka da dee sëmbë u di ten u dë aki tu. ");
INSERT INTO srmNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Nöö un haika e. Gaanduwe a fesiten, wan mujëë könu bi kumutu tee a wan longi köndë ko a Jelusalen faa ko jei di köni u Könu Salumon. Ma nöö un dee sëmbë u di ten aki abi wan sëmbë a unu dendu kaa di hei gaanfa möön di fesiten könu dë e, ma tökuseei wan kë haikëën. “Wë nöö woon si fa a o waka a di Gaan Kuutu Daka di Masa Gadu o kuutu hii sëmbë. Biga di mujëë u taki dë, hënseei o hopo ta kuutu unu e, taa: ‘Mi wë bi kumutu a sö wan longi kamian ko haika di fan u di könu, ma unu bi dë leti a wan möön hebi Sëmbë bandja, ma wan bi kë haikëën möönsö.’ ");
INSERT INTO srmNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Nöö söseei dee sëmbë u Ninifei dee bi piki di buka u Jona o hopo a di Daka dë fu de kuutu unu tu. Biga de bi bia de libi wantewante fu di de jei di fan fu Jona. Ma aki un ta si wan Sëmbë a unu mindi di hei möön Jona gaanfa, ma töku wan kë piki ën buka.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hën a toona taki da de taa: “Na wan sëmbë o sëndë wan faja te a kaba, nöö a tjubi ën a soni basu e. Ma a o sëndëën buta a wan kamian fu hii sëmbë di o ko a di wosu musu sa si limbo ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Nöö ee i sëndë wan faja, nöö ee wojo fii bunu nöö i ta si limbo ku ën fii saandi i ta du. Biga di wojo hën da di faja fii sinkii. Ma nöö ee wojo fii booko nöö ee i sëndë faja buta naandë seei, töku ja o si soni. A sösö dungu nöö joo ta dë. Ja o saandi i ta du. ");
INSERT INTO srmNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Hën mbei i musu ta köni ku i wojo fu an musu ko dungu. ˻Nöö söseei i musu ta köni fu hogi pakisei an musu dë a i hati.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Biga leti kumafa i ta si soni bunu te wojo fii dë limbolimbo, nöö söseei ee hati fii dë limbolimbo fii tei Gadu wöutu ta hoi, nöö i o ko dë bumbuu sëmbë te dou.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Di Masa Jesosi fan sö tefa a kaba, hën wan Faliseima kai ën faa ko njan nëën wosu. Nöö hën a go ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nöö di juu de sindo u de njan, nöö soni u Masa Jesosi toobi di Faliseima. Biga an wasi ˻maun kumafa dee Faliseima ta wasi maun˼. ");
INSERT INTO srmNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nöö di Masa Jesosi si taa di soni dë toobi di Faliseima, hën a taki dëën taa: “Un dee Faliseima aki, andi mbei un ta biinga fu sinkii fuunu musu ta dë limbolimbo, ma hatiböö fuunu lai te dou ku hii sootu pei hogi. ");
INSERT INTO srmNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Un wisiwasi di dë? Un ninga taa Masa Gadu kë fu di sinkii fuunu wanwan nöö musu ta dë limbolimbo nö? Wë di hatiböö fuunu wë? ");
INSERT INTO srmNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","“Wë un musu biinga be hati fuunu dë limbolimbo e, be un ta libi bunu ku hii sëmbë ta heepi dee penama. Biga te un libi sö, nöö an o dë fuun suku fuun ta wasi soni a dee peipei fasi dë möön. Biga hii soni fuunu o ta dë limbolimbo kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nöö di a taki sö da de te a kaba, hën a taa: “Un dee Faliseima aki, mi bai helu da unu e. Fa un sai dë, un ta mbei taa un dë bumbuu möön hii sëmbë. Un ta paati hii soni fuunu, fii da Gadu di fëën së te dou ku dee pikipiki goon njanjan fuunu tuu kumafa di wëti dë. Nöö di naandë bunu tuu, ma an tjika. Biga wan ta libi bunu ku sëmbë, nöö wan lobi Gadu tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hën a toona taa: “Mi bai helu da unu wan pasi möön e, un dee Faliseima. Biga te un go a keiki, nöö un lobi u sindo a di möön hei kamian u di wosu. Te un ta waka a sitaati, nöö un ta kë hii sëmbë musu ta da unu odi a lanti dendu, kuma un hei möön hii sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Nöö mi bai helu da unu e. Un dë leti kuma wan awoo geebi, sëmbë ta waka ta pasa nëën liba söndö de sabi taa ku sö wan hogi soni de ta nama dë.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nöö di Masa Jesosi taki sö kaa, hën wan u dee Sabima u Wëti hakisi ën taa: “Wë Mësitë o, fa i taki aki, na u i ta kosi tu nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nöö hën Masa Jesosi bia fan ku de awaa, a taa: “Mi bai helu da unu tu, un dee Sabima u Wëti. Biga fa un ta lei lanti dee wëti u Mosesi dë, un ta suku u lai hebi soni a de liba fu de musu tjai, ma unu seei wan ta pooba u tjëën wan pikiwan seei. ");
INSERT INTO srmNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nöö mi bai helu da unu möön e. Biga un ta seeka dee geebi fu dee fesiten tjabukama u Masa Gadu te de hanso. Dee gaan sëmbë fuunu wë bi kii de, nöö unu ta seeka dee geebi. ");
INSERT INTO srmNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nöö di soni dë mbei hii mundu ko ta si gbelin taa fa dee gaan sëmbë fuunu bi kii dee tjabukama dë, nöö a bunu a unu. Dee gaan sëmbë bi kii, nöö dee mii ta seeka dee geebi. ");
INSERT INTO srmNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ma antoobi, Masa Gadu sabi fa fuunu. Biga a bi taki a fesi taa a o manda dee tjabukama ku dee futuboi fëën ko da unu, nöö so u de woon kii. So u de woon sitaafu. ");
INSERT INTO srmNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Fëën mbei, un dee sootu pei sëmbë aki, unu wë Masa Gadu o sitaafu fu hii dee tjabukama fëën tuu dee de bi kii tuwë buuu a goon, fu sensi goonliba seti. ");
INSERT INTO srmNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Fu kumutu a Abeli te dou ku Sakaliasi di de bi kii a di Wosu u Masa Gadu dendu, leti a di begi tafa ku di möön hebi kamba mindi dë, nöö u de tuu woon kisi sitaafu e.” ");
INSERT INTO srmNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nöö hën Masa Jesosi taki da de möön taa: “Mi bai helu da unu möön, un dee Sabima u Wëti. Biga un ta tei dee oto u Masa Gadu tuu ta tapa buta dë fu sëmbë an musu sabi de. Unu seei, wan kë mbei möiti fuun musu sabi de, nöö ee wan sëmbë kë sabi de nöö un ta tapa pasi da de. ˻Biga wan kë lei de a di fasi.˼” ");
INSERT INTO srmNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Nöö hën di Masa Jesosi fan ku de sö te a kaba, hën a kumutu go fëën. Nöö a baka u di dë, hën dee Faliseima ku de Sabima u Wëti seti ta ko nëën ku hatiboonu fasi nöömö ta hakisi ën peipei soni. De ta seti taapu dëën faa musu taki wan soni fu de sa feni ën tja go kaagi da lanti. ");
INSERT INTO srmNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nöö di juu Masa Jesosi ta fan dë, nöö dusudusu sëmbë ta ko nëën naandë tee kamian an dë u de tan, nöö de ta peeta deseei. Nöö hën Masa Jesosi seti wasiköi dee bakama fëën, a taki da de taa: “Womi, un mëni unu seei ku di sooda u dee Faliseima e. Dati wan taki wan musu tei di ganjan libi u de. Biga de ta mbei taa de dë bumbuu sëmbë ma na tuu. Nöö hën mbei wan musu djeesi de e. ");
INSERT INTO srmNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Biga na wan soni sa tjubi te nöö an ko a döö. Nöö na wan soni sa danga tu te nöö sëmbë an o ko sabi ën. ");
INSERT INTO srmNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Fëën mbei di soni di i si un ta taki a ndeti a dungudungu, nöö de o jei ën a gaan didia. Nöö di soni di un ta konda sapisapi da unu seei a kamba dendu, nöö hën de o feni ta bai basia a di köndë.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nöö hën a taki da dee bakama fëën möön taa: “Un dee mati u mi aki, wan musu fëëë dee sëmbë dee o sa kii unu e. Wë biga ee wan libisëmbë kii i, nöö an sa du oto soni ku i möönsö. Biga an sa du soni ku di akaa fii, hën mbei wan musu ta fëëë de. ");
INSERT INTO srmNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma Masa Gadu hën un musu ta fëëë e. Biga tee a kii wan sëmbë te a kaba, nöö a sa toona sitaafu ën a bakaten. Biga hën abi di faja ka didibi o go, nöö hën mbei hën un musu ta fëëë. ");
INSERT INTO srmNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","“˻Nöö un musu ta mëni Masa Gadu tuu e, dee sëmbë, biga hën ta sölugu fuunu.˼ Wë biga luku dee piki fou ta buwa aki. De ta sei feifi u de u wan bangunötu nöö, ma töku Gadu ta mëni de. Wë nöö un dee libisëmbë wë? An möönsö nö? Nöö Masa Gadu sabi unu finifini te kisi ku dee uwii u hedi fuunu tuu.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nöö di a fan sö te a kaba, hën a taki da de taa: “Mi taki da unu e, taa dee sëmbë dee ta piki a libisëmbë fesi taa de sabi Mi di ko dë Libisëmbë Mii aki, nöö a bakaten nöö miseei o piki a dee basia u Masa Gadu fesi taa mi sabi de tu. ");
INSERT INTO srmNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","“Ma ee wan sëmbë an kë piki taa a sabi mi a libisëmbë fesi aki, nöö a bakaten nöö ma o piki taa mi sabi ën tu, a dee basia u Masa Gadu fesi ala.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Hën a toona taa: “Ee wan sëmbë kosi Mi di ko dë Libisëmbë Mii aki, nöö Gadu sa puu ën a bëë eti. Ma ee wan sëmbë ta kosi di Akaa fëën, nöö an o puu ën a bëë möönsö e.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Hën a toona taki da de möön taa: “Haika, dee sëmbë. Te de kisi unu u tja go a kuutu a dee keiki u de, ee nasö de tja unu go a dee gaan sëmbë ku dee gaama u köndë u de kuutu unu, nöö wan musu ta pakisei taa: ‘Ee maingë, unfa woo du? Andi seei woo taki?’ ");
INSERT INTO srmNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Biga te di juu dou, nöö di Akaa u Masa Gadu seei o lei unu andi fuun musu taki e.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nöö di juu naandë seei, nöö hën wan sëmbë bi dë a de mindi naandë taki da Masa Jesosi taa: “Mësitë o, mi kë begi i wan soni. Di tata fuu dëdë disa di gudu fëën naandë. Nöö mi kë i taki da di baaa u mi taa be a paati dee gudu, be a da mi u mi së.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hën Masa Jesosi piki ën taa: “Womi, na di wooko dë mi ko aki u ko du e. Ma ko u ko kuutu soni fuunu ta paati gudu da unu.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nöö hën a taki da dee sëmbë sai dë tuu taa: “Dee sëmbë aki, un musu mëni unu seei fu wan abi langawojo a soni e. Biga na gudu ta mbei sëmbë ta libi gaandi, söseei an ta mbei sëmbë libi suti tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hën a konda wan oto da de, a taa: “Wan guduma bi dë, hën a ta koti goon ta wooko ta paandi njanjan nöömö tefa a feni hia njanjan. ");
INSERT INTO srmNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hën a sindo pakisei taa: ‘Wë unfa mi o du? Biga ma a’ wosu tjika fu mi lai dee njanjan dee mi abi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Hën a sai dë te wan pisi, hën a taa, ‘Söö. Wë mi saandi mi o du. Mi o booko dee wosu aki tuwë, nöö mi o mbei wanlö gaan gindi wan. Nöö a de mi o lai dee njanjan ku dee gudu u mi tuu, ");
INSERT INTO srmNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","nöö mi o dë kumafa mi kë awaa. Dee gudu dee mi abi, nöö de o tja mi sömëni jaa. An o dë u mi wooko möön. Mi o ta njan ta bebe ta mbei piizii ta libi suti kumafa mi kë.’ ");
INSERT INTO srmNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ma nöö te faa mëni, hën Masa Gadu taki dëën taa: ‘I lauma ju! A di ndeti aki seei de o ko tei di akaa fii puu a i tja go. Nöö dee gudu i abi dë ku dee njanjan i tjubi buta dë, ambë seei de o fika da?’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nöö hën Masa Jesosi taa: “Wan si ö? Nöö sö a ta pasa ku dee sëmbë dee ta suku gudu u goonliba aki, söndö de ta suku u libi kumafa Masa Gadu kë, fu de feni gudu nëën ala.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hën Masa Jesosi bia fan ku dee bakama fëën awaa. A taa: “Fëën mbei wan musu abi bookohedi tumisi taa andi woon njan, nasö andi woon bisi. ");
INSERT INTO srmNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Biga di libi ˻di Masa Gadu da unu dë, nöö˼ a dë gaan soni möön leki dee njanjan fuun njan. Nöö di sinkii ˻Masa Gadu da unu dë˼, a dë gaan soni möön leki dee koosu fuun bisi nëën. ˻Nöö di a da unu libi ku sinkii kaa, nöö an sa toona da unu njanjan ku koosu u bisi tu nö?˼ ");
INSERT INTO srmNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Wë biga fa dee fou sai dë, de an ta diki goon paandi njanjan. De an ta diki alisi. De an a’ këdë ee nasö gaan suwa ta tjubi njanjan möönsö, ma Masa Gadu hën ta sölugu de. Wë nöö unu libisëmbë wë? Wan bumbuu gaanfa möön dee fou nö? Nöö an sa sölugu fuunu tu nö? ");
INSERT INTO srmNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Nöö un sëmbë sa libi ee wan juu langa seei möön fa Gadu bi buta dëën, fu di a ta booko hedi mbei? Di libi fii an o pusa pasa di daka a bi da i möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wë nöö ee di bookohedi fii an sa heepi i a di piki soni dë, nöö ee i ta bookohedi a gaangaan soni seei nöö a sa heepi ö? ");
INSERT INTO srmNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nöö luku dee folo dee ta nasi a peipei kamian, fa de hanse. De an ta wooko, nöö de an ta nai soni u bisi tu. Ma nöö mi taki da unu taa, fa di gaan könu de kai Salumon bi dë ku hii dee gaan waiti bisi fëën seei, ma an bi ta bisi hanso kuma dee folo dë e. ");
INSERT INTO srmNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“Ma nöö fa i si dee folo hanse seei ma te sapate de puu kai pökö. De kaba a sösö kaa. Wë nöö di Masa Gadu ta bisi dee sösö uwii ku so wanlö hanse folo, nöö an sa da unu koosu fuun bisi tu nö? Ke dee sëmbë aki, luku fa di biibi fuunu piki. Biga wan ta buta mëni a Masa Gadu tjika. ");
INSERT INTO srmNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Dee sëmbë o, mi taki e, wan musu a’ bookohedi fu njanjan ku soni u bebe. Wan musu ta kai dee soni naandë gaan soni poi. ");
INSERT INTO srmNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Biga a dee lö soni dë, dee sëmbë dee an ta dë ku Masa Gadu a wan së ta booko hedi. Ma unu Tata sabi dee soni un abi fanöudu kaa e. ");
INSERT INTO srmNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nöö be un suku nöö fuun dë a di Tii fëën basu, nöö hënseei o da unu hii dee soni dee un abi fanöudu.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nöö hën a toona taki da dee bakama fëën möön taa: “Dee sëmbë u mi aki, fa un dë biti seei, ma wan musu fëëë e. Biga unu Tata Masa Gadu bi feni ën u bunu faa buta unu u di Njunjun Tii fëën dendu, fuun sa njan dee bunu fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Nöö fa i si un dë aki, ˻wan musu lai hia gudu a wosu te poi˼. Ma un musu sei de, nöö un paati di möni da dee pena sëmbë. Nöö hën da un ta lai möni a wan saku di an sa gaandi möönsö. Biga di lö möni dë an o kaba a sösö möönsö ka a dë a Gadu Köndë ala. A o dë u teego. Fufuuma an o sa go ala go fufuu ën möönsö, nöö bitju an o sa go ala go njan mën tu. Nöö naandë fii lai di gudu fii buta e, dee sëmbë, ma na a goonliba aki. ");
INSERT INTO srmNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Biga ka di gudu fii dë, naandë hati fii ta dë tu.” Nöö sö Masa Jesosi taki da dee bakama fëën di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nöö hën a toona taki da de taa: “Dee sëmbë o, un musu dë kabakaba e, ku faja sëndësëndë a unu maun. Un musu bisi wooko koosu, be i dë kabakaba ta luku di Masa fuunu. ");
INSERT INTO srmNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","“Nöö woon dë leti kuma wanlö futuboi de Masa go a kamian a wan piizii. Nöö de o dë a wosu dë pii kabakaba ta luku ën, fu te a ko dou naki di döö nöö de musu hopo jabi di döö dëën wantewante. ");
INSERT INTO srmNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nöö te di Masa u dee futuboi ko si taa de dë kabakaba kaa, nöö de o feni paima. Biga hënseei o puu ën koosu nëën sinkii buta a wan së, nöö a o hopo tafa sölugu de te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“Wë nöö hën da bunu u dee futuboi seei te de Masa ko baka a wosu nöö a ko si taa de dë kabakaba. Biga wë hiniwan juu di a ko dou, nöö de musu dë kabakaba, ee a ganian kanda, ee a mindi ndeti seei. ");
INSERT INTO srmNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Nöö un musu pakisei di soni dë bunu e. Biga ee wan sëmbë sabi a fesi taa a sö wan juu fufuuma o ko nëën, nöö a o dë ku wojo ta watji bunu fu an musu ko booko di wosu fëën fufuu soni. ");
INSERT INTO srmNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nöö fëën mbei un musu hoi unu seei bunu fuun dë kabakaba tu. Biga Mi di ko dë Libisëmbë Mii aki o toona ko a goonliba a wan juu di sëmbë an o mëni taa nëën mi o ko.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nöö di Masa Jesosi fan sö te a kaba, nöö hën Petuisi hakisi ën taa: “Wë Masa o, fa i ta da u dee oto ta lei u dee soni aki, a dë fuu wanwan nö? Naa a dë u hii sëmbë?” ");
INSERT INTO srmNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nöö hën Masa Jesosi piki ën taa: “Wë mi ta fan di fan aki da dee sëmbë dee abi bumbuu fusutan, ku dee lanti sa a’ futoou a de liba. Biga sö wan sëmbë hën di masa o tei buta hedima nëën wosu, fu te di juu dou hën musu paati njanjan da dee otowan. ");
INSERT INTO srmNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nöö te di Masa fëën toona ko, nöö ee a ko si taa a dë wan bumbuu futuboi, a ta du di wooko fëën bunu, nöö a o kisi wan gaan paima. ");
INSERT INTO srmNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mi taki da unu e, taa nëën maun hën masa o buta hii dee gudu fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ma ee di futuboi dë bi taki nëën hati taa: ‘Wë mi masa an o ko eti,’ nöö hën a hopo ta fon dee otowan fëën, womi ku mujëë tuu, ta njan ta bebe ta piizii ta dööngö, ");
INSERT INTO srmNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nöö te hën masa toona ko baka a wan daka di an sabi ku wan juu di an bi mëni, nöö a sa sitaafu ën wan hogi sitaafu e. A o du ku ën seei kumafa a ta du ku dee oto sëmbë dee an ta piki ën buka. ");
INSERT INTO srmNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Biga di sëmbë di ta du soni ku sabi, nöö hën o kisi wan möön hogi sitaafu. ");
INSERT INTO srmNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma di sëmbë di ta du hogi söndö a saandi a ta du, nöö hën an o sa kisi sö wan hogi sitaafu kuma di sëmbë di ta du hogi ku sabi. Biga di sëmbë di i bi du bunu, nöö nëën i ta pakisei u feni bunu baka. Söseei di sëmbë di i bi da möön hia, nöö nëën joo ta mëni taa joo feni möön hia.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nöö hën Masa Jesosi toona taa: “Fa i si mi ko a goonliba aki, nöö mi ko u ko suti faja kumafa sëmbë ta suti faja a goon. Ma dee sëmbë o, mi bi kë u di faja dë bi suti kaa e. ");
INSERT INTO srmNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Biga di sitaafu mi musu tja bifö mi kaba di soni di mi ko u ko du aki, a hebi da mi o. ");
INSERT INTO srmNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Nöö unfa un pakisei, dee sëmbë? Un ninga taa mi ko aki u tja fii ko a di goonliba aki nö? Nönö e, ma mi ko u paati sëmbë ku sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Biga ee feifi sëmbë dë a wan wosu dendu, nöö de o ta kisi toobi ku deseei fu mi hedi. Dii o dë ku mi a wan së, tu dë a wan oto së. Ee nasö, tu o dë ku mi a wan së, dii dë a wan oto së. ");
INSERT INTO srmNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wan tata o poi ku di womi mii fëën fu mi hedi e, nöö wan womi mii o poi ku ën tata. Wan mama o poi ku di mujëë mii fëën. Wan mujëë mii o poi ku ën mama. Mai ku mai o poi ku de seei. Hën mbei mi taa na u piizii mi ko e.” ");
INSERT INTO srmNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hën Masa Jesosi ko ta fan ku dee hia sëmbë ko nëën dë awaa. A taki da de taa: “Dee sëmbë aki o, unfa un du ta sabi dee maaka dë a liba ala, ma dee u goonliba aki wan ta sabi de? Biga te un hopo wojo luku liba, nöö ee un si taa di bundji bë njaaan a di së ka sonu ta kumutu, nöö un taa tjuba o kai. Nöö a ta kai tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","“Nöö te un hopo wojo luku a di së u libasë, nöö te di ventu ta ko nöö un taa: ‘Ma di ventu di ta ko di ko aki, di sonu o hati e.’ Nöö sonu ta hati tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“Wë nöö dee soni u liba ala, de un dë aki ta sabi. Wë nöö dee soni ta pasa a unu fesi a goonliba aki wë? Unfa wan ta si de fuun sabi na un juu u dë, un bödjëëma? ");
INSERT INTO srmNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Biga un saandi da di leti soni fuun du, nöö faandi mbei wan ta seeka soni fuunu buta a pasi? ");
INSERT INTO srmNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Te i ku i felantima a’ soni nöö i si taa a kë tja i go a kuutu u di soni dë hedi, nöö ˻te i si taa i a’ föutu˼ nöö be i dëën leti wante e, be di taki koti bifö un dou a di kuutuma. Ma ee nasö, te di kuutu kaba, nöö dee siköutu o kisi i buta a dunguwosu, ");
INSERT INTO srmNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","fu teee i paka di lasiti bë sënsi u di paima de kai da i fii paka.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nöö di juu naandë, hën wanlö sëmbë ko konda da Masa Jesosi taa wanlö Galilea sëmbë bi ta kii wan mbeti u de tjuma da Masa Gadu. Nöö fa de dë ta seeka di paima naandë, nöö de an kaba seei, hën dee sodati u Gaama Pilati ko kii de tuwë leti dë a di paima liba. ");
INSERT INTO srmNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hën Masa Jesosi piki de taa: “Wë dee sëmbë o, unfa un mëni u dee Galilea sëmbë dee sodati kii naandë? Un mëni taa de dë möön hogi möön hii dee oto sëmbë u Galilea mbei di soni dë miti de nö? ");
INSERT INTO srmNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wë nönö, na di soni dë mbei e. Ma nöö mi taki da unu taa ee wan bia unu libi, nöö sö unu seei sa dëdë kaba a sösö tu. ");
INSERT INTO srmNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Nöö di di tölu u Siloam bi kai kii dee teni-a-aiti sëmbë, nöö unfa fëën un pakisei? Un mëni taa dee teni-a-aiti sëmbë naandë bi hogi möön hii dee sëmbë u Jelusalen, mbei di soni dë miti de nö? ");
INSERT INTO srmNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nönö e, ma mi taki da unu taa ee wan bia unu libi, nöö söseei un sa dëdë kaba a sösö tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nöö hën a toona da de wan oto möön. A taa: “Wan sëmbë bi abi wan goon fëën, nöö hën a paandi di fuuta pau de ta kai figa nëën. Nöö hën a dë te wan daka, nöö hën a go a di goon go suku njanjan a di pau. Ma nöö an feni na wan kodo njanjan nëën. ");
INSERT INTO srmNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“Nöö hën a taki da di sëmbë di ta luku di goon taa: ‘Wë i sabi nö? Dii jaa longi kaa mi ta ko ta suku njanjan a di pau aki, ma ma ta feni möönsö. Nöö fii faa ën e. Andi a dë a di goon ta du?’ ");
INSERT INTO srmNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Nöö hën di sëmbë di ta luku di goon taa: ‘Wë un boo disëën di jaa aki möön, nöö mi o diki wan ngötö lontu ën buta deesi dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nöö te di oto jaa ee an pai njanjan, nöö te i toona ko nöö i sa faa ën awaa.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nöö hën Masa Jesosi dë teefa wan saba, hën a go a wan keiki go ta lei sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nöö wan mujëë sai naandë bi dë ku wan siki teni-a-aiti jaa longi kaa. Wan gadu wë bi du ku ën sö te sinkii fëën bendi doba fika sö, an sa hopo luku liba. ");
INSERT INTO srmNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nöö di Masa Jesosi si di mujëë hën a kai ën ko nëën. Hën a taki dëën taa: “Mujëë o, i ko bunu e. I böö u di siki fii.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nöö hën a buta maun a di mujëë liba. Nöö wantewante dë hën di mujëë ko bunu leti kumafa a bi dë. Nöö hën a da Masa Gadu tangi taa: “Ke! Masa o, i bumbuu e. Gaantangi fii. Mi böö.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wë nöö di di hedima u di keiki si sö, nöö hën a mati. Hati fëën boonu te na soni, fu di kula Masa Jesosi kula di mujëë a di saba. Hën a hakisi dee oto sëmbë dë taa: “Na sikisi daka u abi fuu wooko nö? Wë a dee sikisi daka dë dendu un musu ko suku kula, ma na a saba e!” ");
INSERT INTO srmNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Ma Masa Jesosi piki taa: “Un dee bödjëëma aki, hiniwan saba un ta lusu dee kau ku dee buliki fuunu ta tja de go bebe wata. Nöö di mujëë aki wë? Fa a dë wan bakamii fu Abahamu nöö a dë wan apaiti sëmbë u Gadu kaa, ma töku di didibi sitaafu ën teni-a-aiti jaa longi kaa. Wë nöö di tatai di tai ën aki, ee a saba seei an musu lusu nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nöö di Masa Jesosi fan sö teefa a kaba, nöö hën sen kisi dee felantima fëën te na soni. Ma hii dee oto sëmbë tuu ta wai seei ku hii dee gaan wooko dee a ta du. ");
INSERT INTO srmNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nöö hën Masa Jesosi toona seti lei de baka. A taki da de taa: “Andi mi sa tei taki da unu tee nöö a djeesi di Njunjun Tii u Gadu? ");
INSERT INTO srmNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wë a dë kuma wan sii de kai mutaadi di wan sëmbë tei paandi nëën goon. Di sii piki tee kuma wojo an sa si ën. Ma te i paandi ën, nöö a ta nasi ta göö tee a ko pau seei. A ta paaja maun tee fou seei ta feni kamian a dee maun fëën ta mbei wosu. Nöö sö di Njunjun Tii u Masa Gadu dë e.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hën a toona taa: “Andi mi sa tei möön fu mi lei unu fa di Njunjun Tii u Gadu dë? ");
INSERT INTO srmNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wë a dë leti kuma wan piki sooda di wan mujëë tei tuwë a wan hia boon, nöö di sooda ta soopu hii di boon te dou. Sö di Njunjun Tii u Masa Gadu dë e.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nöö a baka u di dë, hën Masa Jesosi toona tei pasi nango a Jelusalen. Nöö fa a nango dë nöö a ta pasa a sömëni köndë, nöö a ta lei sëmbë a dee peipei köndë nango. ");
INSERT INTO srmNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nöö hën wan sëmbë ko nëën ko hakisi ën taa: “Masa o, biti së u sëmbë nöö o dou a Gadu Köndë nö?” Hën Masa Jesosi piki ën taa: ");
INSERT INTO srmNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Un sabi nö? Na suku di soni dë e. Ma biinga be i dë wan u dee sëmbë di sa pasa a di piki döö go a dendu. Biga mi taki e, taa a a’ wan juu ta ko dë, nöö sömëni fuunu o kë biinga fu de pasa go a di piki döö ma wan o sa feni ën. ");
INSERT INTO srmNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Woon sai dë te di sëmbë di abi di köndë o hopo tapa di döö. Nöö woon go taanpu a di döö buka ta naki di döö ta begi di sëmbë taa: ‘Masa o, gaantangi jabi di döö da u.’ Ma a o piki unu taa: ‘Un disa mi. Ma sabi unu. Unsë un kumutu?’ ");
INSERT INTO srmNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Nöö di juu dë woon piki taa: ‘Wë nönö, Masa, i sabi u. U ku i bi ta njan ta bebe makandi. A u köndë seei i bi ta lei u hiniwan juu.’ ");
INSERT INTO srmNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ma nöö a o piki unu taa: ‘Mi taki e, ma sabi unu e. Ma sabi naasë un kumutu. Un kumutu a mi fesi dë, un takusëmbëma.’ ");
INSERT INTO srmNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Nöö naandë woon fika ta si dee fesiten sëmbë fuunu te a Gadu Köndë ala, de Abahamu, Isaki, ku Jakopu, ku hii dee tjabukama u Masa Gadu. Woon ta si de ma wan o sa dou a de. Nöö naandë woon dë ta du soni ta kai olo te un wei. ");
INSERT INTO srmNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nöö sëmbë o kumutu a hii së u di goonliba go a Gadu köndë ala, nöö de tuu o go sindo a tafa ala, ˻ma wan o sa dou a de˼. ");
INSERT INTO srmNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nöö hën mbei mi ta taki da unu limbolimbo taa dee sëmbë dee bi dë fesiwan aki sa ko bakawan ala. Dee bi dë bakawan aki sa bia ko dë fesiwan ala. Da sö.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A di wan seei daka naandë, hën wanlö Faliseima ko a Masa Jesosi ko taki dëën taa: “Mësitë, a bëtë i kumutu aki go e, biga Könu Helodi ta suku i faa kii.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Ma nöö Masa Jesosi piki de taa: “Un go taki da di bödjëëma naandë taa mi dë aki ta jaka dee didibi ta puu a sëmbë liba, mi ta kula dee sikima ko bunu. Nöö mi o wooko di wooko u mi wantu daka eti. Ma fu go, mi musu fu go a Jelusalen nöömö. Biga de an ta kii wan tjabukama u Masa Gadu a wan oto kamian möön leki a Jelusalen.” ");
INSERT INTO srmNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hën a bia ta fan soni u Jelusalen. A taa: “Aai baa, di köndë de kai Jelusalen, dee sëmbë fëën nöö ta kii dee tjabukama u Masa Gadu sö. Dee sëmbë a ta manda da de tuu de ta naki ku sitonu ta kii. Nöö a tjali möönsö, un dee sëmbë a Jelusalen dë. Biga fa un sai dë, un sabi un mëni pasi mi kai unu fuun ko a mi nö, leti kumafa wan ganian mama ta kai dee mii fëën fu de ko tjubi nëën hanza basu. Ma wan bi kë. ");
INSERT INTO srmNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","“Hën mbei fa u dë aki, nöö di köndë fika da unu awaa. Biga mi, ma o dë ku unu möön. Mi o go. Ma te wan ten dë, woon toona si mi möön. Nöö woon ˻kisi mi ku wai awaa˼ ta bai taa: ‘Gaantangi u Gadu fu di sëmbë di ko a u a di në u Masa.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A wan saba daka hën wan u dee fesima u dee Faliseima kai Masa Jesosi faa ko njan nëën wosu. Nöö di a ko, nöö ˻wanlö Faliseima ku wanlö Sabima u Wëti˼ dë leti dë ta watji ën ˻u de feni wan soni nëën di an bunu, u de tjëën go kaagi˼. ");
INSERT INTO srmNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nöö wan womi sai dë tu ku wan siki fëën. Di sëmbë bi siki taanga te hii sinkii fëën soi. ");
INSERT INTO srmNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nöö hën Masa Jesosi hakisi dee Faliseima ku dee Sabima u Wëti dee sai dë taa: “Wë dee sëmbë aki o, mi kë hakisi unu wan soni. Te saba daka, a bunu fii kula wan sëmbë ko bunu, naa i musu disëën? Unfa di wëti u Mosesi taki?” ");
INSERT INTO srmNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma nöö na wan sëmbë piki ën. De an taki aai, de an taki nönö. Nöö hën Masa Jesosi tëndë maun panjan di womi. Nöö hën a kulëën te a kaba, hën a mandëën go. ");
INSERT INTO srmNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nöö hën a toona hakisi de möön taa: “Ee wan sëmbë i abi wan womi mii fii ee nasö wan kau, nöö hën a kai a tobo wata, nöö fu di a dë saba daka nöö joo disëën faa dëdë nö, naa joo go puu ën?” ");
INSERT INTO srmNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma nöö de an piki ën na wan wojo soni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nöö fa de dë sindosindo a tafa naandë, nöö hën Masa Jesosi luku dee sëmbë dee ko a di piizii dë te a kaba lontu dou. Nöö hën a si taa sëmbë sai dë kë sindo a dee möön hebi kamian fu di tafa, biga de ta suku hei u deseei tumisi. Nöö hën a konda wan oto da de. ");
INSERT INTO srmNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","A taki da de taa: “Te wan sëmbë kai i fii ko a wan piizii nëën wosu, nöö te i go, nöö ja musu suku u go sindo a di möön hei kamian wante e. Ma i musu sindo te a wan së buka ala. Biga kandë sö, di sëmbë di kai i ko dë, bi kai wan oto sëmbë tu di hei möön i. ");
INSERT INTO srmNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nöö a o ko taki da i taa: ‘Wë mati o, saka ko sindo a baka aki, be di otowan sindo a i kamian.’ Nöö di juu naandë, ku gaan sen joo hopo go sindo a di möön lagi kamian. ");
INSERT INTO srmNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ma ee wan sëmbë kai i fii ko a wan piizii nëën wosu, nöö te i go, nöö go sindo a di möön lagi kamian e. Nöö te di juu a ko, nöö ee a si taa wë di kamian i sindo ala an fiti i, nöö a o kai i taa: ‘Mati o, na sindo ala baa. Ko sindo aki.’ Nöö a o tei i tja go buta a wan möön hei kamian. Nöö fa joo hopo ka i bi sindo dë fii waka go sindo a di möön hei kamian, nöö dee oto sëmbë o si taa aai, i dë wan hei sëmbë tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Biga di sëmbë di ta hopo ën seei, nöö hën de o saka. Ma di sëmbë di ta sakëën seei, nöö hën de o hopo.” ");
INSERT INTO srmNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nöö hën Masa Jesosi taki da di sëmbë di kai ën a di piizii naandë taa: “Mati o, te joo kai sëmbë möön fu de ko njan ku i, nöö na kai dee bëë fii e, ku dee bunu mati fii, ee nasö dee gudu sëmbë dee ta libi a i bandja dee sa du i bunu baka. Wë biga ee i kai dee sëmbë dë wanwan, nöö te de o njan nöö de o toona kai i tu. Nöö te de kai i, i go njan te i hopo, nöö hën di njanjan i njan dë, hën nöö da di paima i feni fu di i bi kai de ko njan ku i. Nöö a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Ma te joo kai sëmbë u de ko a i wosu ko njan, nöö i musu suku dee pootima e. Ee wan sëmbë aan möni, ee wan sëmbë wojo booko, ee wan sëmbë lan, nöö de i musu ta kai be de ko njan a i wosu. ");
INSERT INTO srmNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nöö joo feni bunu fëën. Biga dee lö sëmbë dë, de an sa toona paka i baka. Ma wan daka ta ko Masa Gadu o weki dee sëmbë a dëdë dee bi libi bunu nëën wojo, nöö a di daka dë joo feni di paima fii e.” ");
INSERT INTO srmNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nöö hën di Masa Jesosi fan sö te a kaba, nöö hën wan u dee sëmbë ku ën dë sindosindo a tafa dë taki dëën taa: “Wë di sëmbë di o feni kamian go sindo a di tafa u Masa Gadu nëën köndë ala, nöö a a’ bunuhedi e!” ");
INSERT INTO srmNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nöö hën Masa Jesosi piki ën, a konda wan oto dëën taa: “Wan womi bi dë, nöö hën a kai hia sëmbë u de ko nëën. Nöö hën a seeka soni u njan te a hia u de musu ko njan ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","“Nöö di di juu kisi, nöö hën a manda wan wookoma fëën u go taki da dee sëmbë taa di juu dou, be de ko. Biga hii soni dë seekaseeka kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ma nöö di di wookoma go kai de, hën de tuu ta pii soni ta konda. Wan u de taa: ‘Wë fa mi dë aki, nöö ma sa ko e. Biga mi bai wan goon, nöö mi musu go luku ën. Nöö taki da i masa taa an musu tei mi u hogi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Di otowan taki taa: ‘Wë mi bai teni kau, nöö mi musu go wooko ku de luku. Nöö hën mbei ma o feni pasi u ko. Nöö taki da i masa taa be an tei mi u hogi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Di otowan taki möön taa: ‘Wë djunsu aki mi tei wan mujëë, nöö ma o sa ko.’ ");
INSERT INTO srmNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Hën di wookoma toona ko dëën masa dee bosikopu. Nöö hën di masa hati boonu seei, hën a taki dëën taa: ‘Wë nöö toona go hesihesi e, nöö i waka a dee gaangaan sitaati ku dee pikipiki sitaati dee dë a di köndë aki tuu, nöö i suku dee lanlan sëmbë ku dee sëmbë dee an sa wooko, ku dee bookowojo sëmbë ku dee pena sëmbë, nöö i tja de tuu ko.’ ");
INSERT INTO srmNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Hën di wookoma go tefa a ko, hën a taa: ‘Wë Masa, wë mi feni dee sëmbë nöö de ko kaa, ma misikuma kamian dë eti.’ ");
INSERT INTO srmNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Hën a taa: ‘Wë nöö toona go a dee pandasi kamian ku dee boiti ku dee sabana dendu, nöö te i feni sëmbë nöö i panjan de a maun hai tja ko. Biga di wosu u mi musu fuu. ");
INSERT INTO srmNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma nöö mi taki da unu taa dee fosu sëmbë dee mi bi kai dë, nöö na wan u de sa feni di njanjan u mi aki njan möön e.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Nöö fa Masa Jesosi ta waka nango dë, nöö wanlö hia sëmbë ta waka ku ën nango. Tee wan pisi, hën a bia luku de. Hën a taki da de taa: “Ee wan sëmbë ja sa kai mi gaan soni möön i mama ku i tata ku i mujëë ku dee mii fii ku dee baaa fii ku dee sisa fii ku hii dee libi dee i abi tuu, nöö ja sa dë wan bakama u mi e. Biga i musu sa tja sitaafu u mi hedi. Ee i dëdë seei fu mi hedi, ja musu a’ toobi. ");
INSERT INTO srmNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Biga ee wan sëmbë i kë waka a mi baka, nöö ja musu abi kë fii seei e. Ma di soni di mi kë, hën nöö i musu du, nöö joo dë wan bakama u mi tuutuu. ");
INSERT INTO srmNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Wë nöö un musu pakisei di soni bunu e. Biga ee wan fuunu kë mbei wan wosu nöö unfa joo du? Ja o go sindo pakisei te i kaba luku ee di möni fii tjika u du di wooko bifö i go seti mbei ën ö? ");
INSERT INTO srmNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","“Wë biga ee i go seti ën nöö hën di möni fii kaba, nöö te wan sëmbë ko dë ko si ën nöö a o taa: ");
INSERT INTO srmNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Di womi aki, luku wan gaan wosu a seti mbei disa aki. Na mbei wë an kë mbei ën e, ma di möni fëën wë kaba.’ Nöö di juu dë nöö de o ta mbei i fa. ");
INSERT INTO srmNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nöö söseei ee wan könu abi teni dusu sodati nöö hën a pakisei taa a o go feti ku wan oto könu di abi tuwenti dusu sodati, nöö bifö a go a musu pakisei bunu ee a sa feti ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“Ma ee a luku te a kaba nöö a si taa: ‘Wë di könu di abi tuwenti dusu sodati dë, ma sa wini ën,’ nöö an musu luku te di könu ko zuntu poi e. Ma a musu manda sëmbë a fesi go begi ën te a kaba, be di taki koti bifö de ko miti. ");
INSERT INTO srmNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Wë nöö söseei hiniwan fuunu musu sindo pakisei ee i sa disa dee soni dee i abi, nöö ee ja sa disa de fii ko ta waka a mi baka nöö ja sa dë bakama u mi e. ");
INSERT INTO srmNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Wë biga un luku, dee sëmbë. Satu dë wan suti soni u njan tuu, ma ee di satu kaba a sösö te an sa kisi gansë möön, nöö andi i sa du ku ën möön? ");
INSERT INTO srmNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A kapëë nöö i sa tei ën tuwë, biga aan heepi a goonliba möön. ˻Nöö söseei joo dë tu e, ee ja waka ku hii i hati a mi baka.˼ “Nöö fa mi fan ku unu aki, nöö un pakisei ën bunu e, dee sëmbë, be un fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wan daka hën dee sëmbë ta pii lanti möni ku dee oto takulibima u di köndë, hën de go a Masa Jesosi faa musu konda Gadu oto da de. ");
INSERT INTO srmNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nöö hën dee Faliseima ku dee Sabima u Wëti ko si Masa Jesosi ku dee sëmbë naandë makandi. Nöö hën de taa: “Ee! Aai baa. Di sëmbë aki, a ta butëën seei kuma bumbuu sëmbë, ma a ta hulu dee gaan takulibima u di köndë. So juu hën ku de ta njan makandi seei. A bunu nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nöö Masa Jesosi sabi taa sö de ta guunjëën, nöö hën a da de wan oto. A taa: ");
INSERT INTO srmNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Un haika e, dee sëmbë. Ee wan fuunu abi wan höndö sikafu nöö wan u de kumutu a dee otowan dendu go lasi, nöö unfa joo du? Ja o seeka dee nëniteni-ku-nëni naandë disa a sabana dë, nöö i go suku di lasi wan te i feni ën nö? ");
INSERT INTO srmNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Nöö te i feni ën kaa, nöö joo wai seei hopo ën buta a gangaa baaku tja ko a ganda. Nöö te i ko dou ku ën kaa, nöö joo kai dee mati fii ku dee sëmbë dë a i bandja naandë taa: ‘Un ko mbei piizii ku mi e, dee sëmbë. Biga di mbeti u mi bi lasi, nöö mi feni ën baka.’ ");
INSERT INTO srmNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Wë nöö fa i si hii sëmbë ta wai naandë, nöö söseei a dë a Gadu Köndë tu te wan takulibima biëën libi ko ta waka a Masa Gadu baka. De ta piizii ku ën möön leki dee oto nëniteni-ku-nëni sëmbë dee bi dë seekaseeka dë kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nöö hën a toona taki da de möön taa: “Nöö söseei tu, ee wan mujëë abi teni kpëngëlë möni nöö hën wan u de lasi, nöö an o sëndë faja nöö a ta bai di wosu köniköni ta suku ën teefa a feni ën baka nö? ");
INSERT INTO srmNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nöö te a feni ën kaa, nöö a o kai dee mati fëën ku dee sëmbë dë nëën bandja tuu ko. Nöö a o taki da de taa: ‘Dee sëmbë o, mi bi abi teni kpëngëlë möni nöö wan u de bi lasi, hën mi ta suku ën tefa u dë aki hën mi feni ën. Nöö un ko wai mbei piizii ku mi makandi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Wë nöö fa i si dee sëmbë ta wai u di wan kodo kpëngëlë möni bi lasi de feni dë, nöö söseei dee basia u Masa Gadu ta wai tu e, ee wan kodo takulibima seei biëën libi ko ta waka a Masa Gadu baka.” ");
INSERT INTO srmNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nöö hën a toona taki da de möön taa: “Wan tata bi dë e, nöö a bi abi tu womi mii fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nöö hën wan daka hën di piki wan ko nëën. Hën a taki dëën taa: ‘Taata o, mi kë fii paati dee gudu fii, nöö i da mi di u mi së di mi bi o feni wante.’ Nöö hën di tata paati di gudu fëën da dee womi mii fëën te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nöö an longi möön, hën di piki wan sei dee gudu fëën. Hën a tei di möni. Hën a go a wan longi köndë, nöö naandë a poi di möni fëën tuu ku jajo libi. ");
INSERT INTO srmNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nöö hën a sai dë te wan pisi, hën wan gaan hangi ko a di köndë. Nöö hën pena ko ta kii ën a hii fasi, biga di möni fëën bi kaba gaanduwe kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Nöö hën a go a wan sëmbë u di köndë go suku wooko. Nöö hën di sëmbë dëën wan wooko, a mandëën faa musu go ta luku dee hagu fëën dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nöö hangi ko ta kii di womi mii tee dee hagu njanjan seei a bi kë feni njan fu bëë fëën fuu, ma na di dë seei de dëën. Na wan sëmbë dëën soni u njan a di köndë möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nöö hën a sai dë tee wan pisi, nöö hën wojo fëën ko limbo. Hën a taa: ‘Luku fa mi dë aki. Sömëni wookoma mi tata abi ta da njanjan, de ta njan te tjika de, nöö hën mi ko dë aki ta pena da hangi ta kii. ");
INSERT INTO srmNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nöö mi sabi andi mi o du. Mi o toona go a mi tata, nöö mi o go taki dëën taa: “Taata, wë mi du hogi ku i tee dou ku Masa Gadu tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nöö ma waiti möön seei fii musu tei mi kuma mii fii e, ma tei mi kuma wan wookoma fii nöö.” ’ ");
INSERT INTO srmNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Nöö hën a hopo ta waka nango nëën tata. “Nöö di tata bi dë a wosu naandë. Te wan pisi, hën a tuwë wojo go te ala, hën a si wan sëmbë ta ko. Hën a si taa di womi mii fëën hën ta ko naandë. Nöö hën tjali fëën kisi ën tee. Hën a hopo vu kule go kisi ën baasa, a bosi ën wai ku ën te a bigi. ");
INSERT INTO srmNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Nöö hën di womi mii taa: ‘Taata o, wë ma waiti tjika möön fii tei mi kuma miii fii e, biga mi du i hogi tee dou ku Masa Gadu seei tu.’ ");
INSERT INTO srmNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ma di tata an haika di mii seei. A taki da dee wookoma fëën taa: ‘Un hesi go tei di möön waiti wojo koosu tja ko bisi dëën. Nöö un go tei andelu tja ko tuusi nëën finga, nöö un tja saapatu ko dëën be a bisi. ");
INSERT INTO srmNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nöö un go kii di fatu kau tja ko, boo boi njan mbei piizii. ");
INSERT INTO srmNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Biga di womi mii u mi aki bi go kaba a sösö, ma a toona ko a u baka.’ Hën de seti mbei di piizii. ");
INSERT INTO srmNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nöö a di ten dë seei, di gaan baaa fëën bi dë a goon dendu. Nöö hën di a kumutu a goon ta ko, hën a jei de ta wai ta pëë ta mbei piizii te a bigi. ");
INSERT INTO srmNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nöö hën a kai wan u dee wookoma fëën tata ko, hën a hakisi ën taa: ‘Andi ta pasa bigi di bigi aki sö?’ ");
INSERT INTO srmNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Hën a piki ën taa: ‘Wë di piki baaa fii di bi go, hën wë toona ko a wosu. Nöö hën i tata kii di fatu kau ta wai ku ën fu di a toona ko ku libi a wosu baka.’ ");
INSERT INTO srmNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nöö di di gaan baaa jei sö, hën hati fëën boonu tee a taa an o go a wosu. “Nöö hën di tata ko jei, hën a go nëën a döö go begi ën taa: ‘Womi, gaantangi, ko boo go a wosu.’ ");
INSERT INTO srmNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Hën a taa: ‘Wë nönö Taata, më o ko a wosu. Wë biga sömëni jaa longi mi ku i dë aki, mi ta du hii soni da i dee i ta manda mi fu mi musu du. Na wan daka seei mi pasa i buka. Mi ta wooko da i kuma mi da wan sitaafuma fii, ma na wan daka i da mi wan u dee kaabita seei fu mi mbei piizii ku dee mati u mi. ");
INSERT INTO srmNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma di womi mii fii aki di go poi dee gudu fii ku di jajo libi fëën, tefa a toona ko aki nöö hën i ta mbei sö wan gaan piizii te i kii di fatu kau dëën. ˻Nöö ma sa ko a wosu. A hati mi poi.˼’ ");
INSERT INTO srmNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Hën di tata taa: ‘Wë mii o, wë fa mi ku i ta libi makandi aki, nöö hii dee soni dee mi abi aki tuu dë fii, na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma di baaa fii di bi go sömëni longi te u mëni taa a dëdë kaba a sösö, hën wë toona ko a u ku libi baka. Nöö an fiti fuu wai mbei piizii ku ën nö?’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nöö hën Masa Jesosi toona taki wan oto woto möön da dee bakama fëën. A taa: “Wan guduma bi dë, nöö ˻a a’ hia wookoma. Hën a tei wan sëmbë buta basi a dee wookoma fëën liba faa ta seeka di wooko ta luku hii dee gudu fëën dëën.˼ “Nöö hën a dë tee wan daka, nöö hën wan sëmbë ko nëën ko taki dëën taa: ‘Mati o, haika e. Di basi i buta a dee wookoma fii liba dë, an ta wooko bunu e. A ta njan di möni fii.’ “Hën di guduma taa: ‘Sö nö?’ Hën a taki aai. Hën a taa: ‘Wë antoobi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Nöö hën a manda kai di basi ko nëën. Hën a taki dëën taa: ‘Womi, mi jei wan soni. Wë nöö hën mi kai i ko hakisi fii musu konda da mi. De taki da mi taa i ta njan di möni u mi tuu. Wë nöö i musu taki da mi unfa i wooko ku di möni, biga abiti möön mi o puu i. Ja o dë basi fu di wooko u mi möön.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Nöö hën di basi taki nëën hati taa: ‘Ee maingë, di soni aki, a bigi da mi. Wë nöö ee di masa u mi ko puu mi a wooko, nöö andi seei mi o du? Biga ma sa wooko a goon dendu te tja heepi ko da mi fu mi feni soni njan. Nöö fu mi ta waka ta pidi njanjan a sëmbë wosu, mi a’ sen fëën. Ma sa du ën.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Hën a sai dë te wan pisi, hën a taa: ‘Söö. Wë mi saandi mi o du u te de puu mi a di wooko, nöö oto sëmbë sa hoi mi a de wosu. Nöö pena an o kii mi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Hën di a pakisei sö kaa, nöö hën a kai hii dee sëmbë dee bi juu soni nëën masa söndö paka. Nöö hën di de ko nëën, hën a taki da di fosuwan taa: ‘Womi o.’ A piki. A taa: ‘Un mëni i bi abi fii paka di masa u mi?’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Hën a piki ën taa: ‘Wë basi, mi abi wan höndö bali fatu dee mi bi tei fu mi musu paka.’ “Hën a taki aai. Hën a tei di pampia a bi sikifi dee soni a bi juu, hën a tënëën tuwë. Hën a dëën wan oto pampia taa: ‘Luku wan oto pampia aki. Go sindo, nöö i toona sikifi ën. Ma te joo sikifi, na sikifi wan höndö möön e. Sikifi feifiteni bali nöö.’ Hën a tei, hën a go sindo hën a sikifi. ");
INSERT INTO srmNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Hën a kai wan otowan, di u mbei tu. Hën a taa: ‘Womi o, fa u ta wooko aki, nöö dee soni mi bi juu i, un mëni i abi fii musu paka?’ “Hën a piki ën taa: ‘Wë basi, mi abi wan dusu saku boon fu mi musu paka.’ “Hën a tei di biifi hën a tënëën. Hën a taki dëën taa: ‘Go sindo, nöö i sikifi otowan. Ma te joo sikifi, nöö i sikifi aiti höndö nöö. Na sikifi wan dusu möön.’ ˻Nöö sö a saka di möni da de tuu.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nöö hën di di guduma si fa di basi du dë, hën a taa: ‘Aai, di sëmbë aki, ˻hii fa a hogi˼ ma a sabi u du soni e. A köni tuu. ˻A sabi fa u heepi ën seei fu te di fuka ko nëën a bakaten, nöö a sa libi.˼’ ” Nöö hën Masa Jesosi toona taa: “Luku fa di guduma gafa di sëmbë. Nöö mi taki e, dee sëmbë u di goonliba aki dee an ta waka a Masa Gadu baka, de ta libi a wan fasi u tja wini ko da de a bakaten möön leki dee sëmbë dee ta waka a Gadu baka e.” ");
INSERT INTO srmNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nöö hën a toona taki da de taa: “˻Un si fa di basi du aki nö? A seeka di soni faa musu toona heepi ën seei a bakaten.˼ Nöö sö unu seei musu du tu e, dee sëmbë. Dee möni un si un ta wooko a goonliba aki, nöö un musu ta wooko ku de a wan fasi fu te di daka un kumutu a di goonliba aki, nöö de o kisi unu ku piizii seei te un dou a Gadu köndë ala ka woon dë fu teego. ");
INSERT INTO srmNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Nöö a dë sö taa ee wan sëmbë ja sa seeka wan piki soni te a ko bumbuu soni, nöö söseei ja o sa seeka gaan soni tu. Nöö ee i ta fufuu piki soni, nöö söseei joo ta fufuu gaan soni tu. ");
INSERT INTO srmNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","“Nöö ee wan sëmbë ja ta seeka di gudu i ta feni a goonliba aki a wan bumbuu fasi, ja ta njan mën kumafa a fiti, wë nöö unfa Masa Gadu o sa futoou i faa da i gaan gudu nëën köndë fii seeka? ");
INSERT INTO srmNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nöö ee wan sëmbë ja ta seeka oto sëmbë soni te de butëën a i maun, nöö unfa de o da i soni fii seei, fii seeka? ");
INSERT INTO srmNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nöö na wan sëmbë sa dini tu masa makandi e, dee sëmbë. Biga joo lobi wan möön wan. Ee i hëngi a wan, nöö ja o sa hëngi a di otowan möön. Wë nöö i sa dë a Gadu baka, ee nasö i sa dë a gudu baka, ma nöö ja sa dë a de tuu baka makandi e.” ");
INSERT INTO srmNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nöö di Masa Jesosi taki dee oto aki teefa a kaba, nöö hën dee Faliseima jei, nöö hën de an kë sö. Biga deseei a’ langabëë u möni tumusi. Nöö hën de bia ta sösö Masa Jesosi ta mbei ën fa. ");
INSERT INTO srmNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hën Masa Jesosi taki da de taa: “Wë unu wë mi ta taki tuu e. Biga a sëmbë wojo un ta mbei taa un dë bumbuu sëmbë, ma Masa Gadu hën sabi unu hati e. Nöö di soni libisëmbë ta si u gaan bumbuu soni, nöö a Masa Gadu wojo an dë wan wojo soni.” ");
INSERT INTO srmNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nöö hën a taki da dee Faliseima möön taa: “Un haika e, dee sëmbë. Fu sensi di ten u Mosesi te kisi di ten u Johanisi di Dopuma, nöö dee wëti Mosesi ku dee tjabukama bi kisi a Gadu bi ta konda da libisëmbë fa u de waka a Gadu baka. Ma nöö fa u dë aki, wan njunjun buka ko taa Masa Gadu hopo wan Njunjun Tii. Nöö hia sëmbë ta biinga a di Njunjun Tii dë baka kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ma tökuseei an dë taa dee awoo wëti an bunu e. Mundu ku goonliba sa kaba, ma na wan piki wan u dee wëti seei o kaba a sösö möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hën a toona taki möön taa: “Ee wan sëmbë i go tei wan mujëë te nöö hën i tuwëën disa nöö i toona go tei wan otowan, nöö di wëti u Masa Gadu hën i booko dë kaa e. Nöö söseei tu, ee wan sëmbë i go tei wan tuwë mujëë fu wan oto womi, nöö i seei booko di wëti u Gadu tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nöö hën a toona taki da de möön taa: “Wë un haika e, dee sëmbë. Wan guduma bi dë a wan köndë. Nöö a gudu tee na sipootu. Hiniwan juu a ta libi fëën kumafa a kë ta bai dee gaan dii koosu ta bisi ta mbei gaan piizii. ");
INSERT INTO srmNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","“Ma nöö wan sëmbë bi dë a di köndë naandë tu de ta kai Lazalosi. A pena te an saanfa u du ku ën seei. Kasikaasi kisi ën hii ën sinkii. Na hopo seei a ta hopo ta waka. Nöö de ta hopo ën ta tja nango ta buta a di guduma dööbuka ");
INSERT INTO srmNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","fu te di guduma njan nöö a kandë a sa feni so u dee sakasaka u dee njanjan fëën dee ta kumutu nëën tafa ta kai a goon. Nöö dee dagu u sitaati ta ko ta lëmbë dee kasikaasi fëën nëën sinkii. ");
INSERT INTO srmNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nöö hën de dë te wan pisi nöö hën di penama dëdë. Hën dee basia u Masa Gadu ko tei ën tja go nëën gaan sëmbë Abahamu bandja. ˻Nöö a sai dë ta wai ta piizii ta libi suti kumafa di libi dë ala.˼ “Nöö a baka fëën hën di guduma dëdë tu, hën de tjëën go bei. ");
INSERT INTO srmNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma nöö fa a dëdë dë, nöö hën a go a didibi faja. Hën a go sai dë a di faja dendu ta tja sitaafu ta bai ta kai olo. “Tee wan pisi, nöö hën a hopo wojo luku te ala, a si Lazalosi a Abahamu bandja dë. ");
INSERT INTO srmNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Hën a bai kai Abahamu taa: ‘Taata oo, Taata, gaantangi, tei tjali u mi nöö i manda Lazalosi be a tuusi finga fëën a wata tja ko munjan mi töngö. Biga ka mi dë aki, di faja ta kendi mi tumusi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nöö hën Abahamu piki ën taa: ‘Ke, aai mii, wë mi jei e. Ma mëni taa di ten di i bi dë a goonliba ala, i bi ta libi bunu kumafa i kë. Soni seei an bi ta fuka i. I bi njan di bunu libi fii a goonliba ala tuu bifö i dëdë ko aki. Nöö Lazalosi, di a bi dë a goonliba ala, nöö hii fuka a bi ta tjai. Wë nöö fa u dë aki i ko ta tja sitaafu, ma Lazalosi hën ko feni böö awaa. ");
INSERT INTO srmNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“ ‘Ma haika, boiti u di dë, pasi an dë fu dee sëmbë u mi aki aba ko a unu ala e. Söseei pasi an dë a unu ala tu fu un sa aba ko a u aki. Biga wa sa pasa di gaan fundu ngötö a u mindi aki fuu ko miti ku u seei.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nöö hën di guduma taa: ‘Aai, wë mi jei. Ma nöö i sabi nö? Mi begi i Taata, gaantangi, manda Lazalosi be a go a mi tata wosu, ");
INSERT INTO srmNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nöö a o si wanlö baaa u mi naandë. De dë feifi. Nöö gaantangi be a wasiköi de da mi taa de an musu libi kumafa mi bi libi a goonliba ala möön, fu de ko a di sitaafu kamian aki.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nöö hën Abahamu piki ën taa: ‘Sö nö, womi?’ Hën a taki aai. Hën a taa: ‘Wë, mi jei. Ma i sabi nö? Dee sëmbë a goonliba ala, de abi dee buku fu Mosesi ku dee u dee tjabukama u Masa Gadu kaa. Nöö be dee baaa fii haika andi dee buku ta taki nöö de waka a de baka.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Hën di guduma taa: ‘Aai, Taata, sö a dë tuu. Ma di dë wanwan an tjika. Ma ee wan dëdë sëmbë hopo go wasiköi de, nöö de o bia de libi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Hën Abahamu piki ën taa: ‘Ma haika e, mati. Ee de an sa tei dee sikifi a dee buku naandë, nöö ee wan sëmbë hopo kumutu a dëdë köndë go fan ku de seei, de an o jei möönsö e.’ ” Sö wan gaan oto Masa Jesosi konda dë e. ");
INSERT INTO srmNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Hën Masa Jesosi taki da dee bakama fëën taa: “Un musu sabi taa dee soni ta hai sëmbë puu a Gadu pasi an o sa kaba a di goonliba aki möönsö. Ma mi bai helu da dee sëmbë dee o ta tja dee lö soni dë ko a sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Biga ka fii du sö wan soni, nöö a möön bunu de tai wan gaan gindi sitonu a i gangaa, nöö de tja i go tuwë a ze mindi be i dëdë kaba a sösö wante, fu ja du di hogi di i bi pakisei dë. Di sitaafu dë hogi, ma an hogi kuma di i bi o feni ee i bi feni pasi puu sëmbë a Gadu pasi. ");
INSERT INTO srmNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Un musu luku bunu ku di soni naandë fu an musu miti unu e.” Hën a toona taa: “Wë nöö ee i si taa di otowan fii du i hogi, nöö i musu fan ku ën be an du sö ku i möön. Nöö ee i si taa a piki disa di hogi du fëën dë, nöö i musu disëën. Ja musu hoi ën a bëë. ");
INSERT INTO srmNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ee a du i hogi sëbën toon a wan daka seei nöö hën a ko a i sëbën toon ko begi i fii dëën paadon, nöö i musu disëën. Na hoi ën a bëë möön e.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nöö hën dee bakama taki da Masa Jesosi taa: “Wë Masa o, u ta biibi a Masa Gadu liba, ma di biibi fuu an tjika. Nöö u begi i gaantangi, heepi u be di biibi fuu ko möön taanga.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nöö hën Masa Jesosi piki de taa: “Aai. Wë womi, ee i abi wan piki biibi a Gadu liba kuma ahun sii seei, hën i taki da di pau i si aki sö taa: ‘Hön kumutu aki go paandi i seei a ze,’ nöö a o piki i buka e.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nöö hën a taki da de möön taa: “Undi fuunu o abi wan wookoma, nöö te a go a wooko a goon dendu nasö a go luku dee mbeti a sabana tee a ko, nöö i taki dëën taa: ‘Ko sindo njan’? ");
INSERT INTO srmNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","“Na tuu fii. Ma joo taki dëën taa: ‘Wë luku, di i ko kaa, nöö i seeka hesihesi nöö i go boi njanjan seti tafa da mi be mi njan. Nöö te mi njan te bëë u mi fuu kaa, nöö i seei sa njan tu.’ ");
INSERT INTO srmNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Wë nöö unfa un pakisei u di soni naandë? Un pakisei taa di basi u di wookoma musu da di wookoma fëën apaiti tangi fu di a wooko dëën taanga sö nö? Nönö. An dë faa dëën tangi e. Wë biga fa a wooko naandë, sö nöö a bi musu wooko. ");
INSERT INTO srmNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Wë nöö unu seei tu e, te un wooko da Masa Gadu kumafa a da i di wooko, nöö an dë fuun suku tangi nëën e. Biga sö nöö di wooko fuunu dë kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nöö fa Masa Jesosi nango a Jelusalen dë, nöö hën a ta pasa a di pisiwata u Samalia ku Galilea mindi. ");
INSERT INTO srmNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nöö hën a go dou a wan piki köndë. Hën teni sëmbë ko miti ku ën naandë, nöö dee sëmbë dë tuu siki tjina siki. Hën de taanpu te ala, ");
INSERT INTO srmNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","de bai taanga kai Masa Jesosi taa: “Jesosi, Masa o, ke gaantangi, tei tjalihati fuu nöö i heepi u baa!” ");
INSERT INTO srmNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nöö di Masa Jesosi jei di bai, nöö hën a bia luku. Hën a si dee sëmbë. Hën a taki da de taa: “Ee, aai mii. Wë un sabi nö? Un pasa go a dee begima be de si unu fa un dë.” Nöö di de seti nango, te wan pisi hën de tuu ko bunu djee. ");
INSERT INTO srmNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nöö di wan u de si taa a ko bunu, hën an go möön ma a bia toona. Nöö hën a ta bai taanga ta gafa Gadu ta dëën tangi u di bunu a du ën naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nöö hën a kule go kai a Masa Jesosi fesi a goon naandë. Hën a taki dëën taa: “Ke Masa, gaantangi fii e, fu di bunu i du mi aki. A bigi. Nöö mi si ën!” Nöö di sëmbë dë bi dë wan Samalia sëmbë. ˻An bi dë Isaëli sëmbë seei kuma dee oto nëigi, faa bi musu da Gadu tangi sö.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Nöö hën Masa Jesosi hakisi ën taa: “Wë womi o, fa i ko i wanwan aki, na teni sëmbë un bi dë ko bunu nö? Unsë dee otowan fii dë? Na wan u de toona ko fu de ko da Gadu tangi möönsö möön leki di döösë sëmbë aki nö? Wë a bigi a mi.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hën a taki dëën taa: “Wë womi o, hopo go fii e. Di biibi di i abi a mi liba, nöö a heepi i kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wan daka, hën wanlö Faliseima ko a Masa Jesosi ko hakisi ën taa: “Mësitë o, na un ten Masa Gadu o ko a goonliba ko tei di Könu Tii fëën, faa taki a hii sëmbë liba?” Nöö hën Masa Jesosi piki de taa: “Wë un haika e. ˻Di tii u Gadu an ta ko kumafa un ta mëni ën dë e. Biga˼ dee könu u di goonliba aki te de o ko u tii dee köndë, nöö hii sëmbë ta sabi taa de ta ko. ˻Biga de ta wai ta pëë doon, tutu ta piki.˼ Ma di ko u di tii u Masa Gadu hën an o dë sö e. ");
INSERT INTO srmNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Biga te a o ko, nöö na wan sëmbë o sa taki taa: ‘Luku ën aki.’ Ee nasö: ‘Luku ën ala.’ De an o sa lei sëmbë sö. Biga di Tii fëën ta dë a dee sëmbë dee ta waka nëën baka hati.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nöö hën a taki da dee bakama fëën taa: “Fa mi o disa unu go aki, nöö wan ten o ko nöö un tuu o hangi u si ee wan u dee daka seei di Mi di ko dë Libisëmbë Mii aki o dë nëën könubangi ta taki a hii mundu liba. Ma wan o sa si ën eti. ");
INSERT INTO srmNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sëmbë o taki da unu taa: ‘Un luku ën aki!’ Ee nasö: ‘Un luku ën ala.’ Ma wan musu go luku e. Wan musu piki möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","“Biga te di daka di Mi di ko dë Libisëmbë Mii aki o toona ko, nöö a o dë leti kuma te liba koti faja walau sö, hii sëmbë ta si ën. Biga liba ala o limbo gbegede te kisi ku goon aki tuu. Nöö söseei di ko u mi o dë tu. ");
INSERT INTO srmNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma bifö mi toona ko aki a sö wan fasi, nöö mi musu tja sitaafu ku pena tee bifö. Biga dee lö sëmbë u di ten u dë aki, de an dë a mi du. Kwetikweti. ");
INSERT INTO srmNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ma di ten di Mi di ko dë Libisëmbë Mii aki o toona ko a goonliba, nöö a o dë leti kumafa di ten u Noa bi dë. Biga leti kumafa soni bi ko miti dee sëmbë a di ten dë, nöö söseei a o miti dee sëmbë u di ten di mi o ko tu. ");
INSERT INTO srmNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Biga a Noa ten de bi ta njan ta bebe, dee womi bi ta tei mujëë, dee mujëë bi ta tei manu. De bi ta libi u de kumafa de kë söndö mëni Gadu möönsö, tefa di daka Noa go a di sipi dendu. Hën di tjuba seti kai, gaan wata ta ko te a kii de tuu fia puu dë. ");
INSERT INTO srmNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Nöö söseei tu a bi miti dee sëmbë a di ten u Lotu. Dee sëmbë bi sai dë ta njan ta bebe, de bi ta bai soni ta sei, de bi ta koti goon ta paandi njanjan, de bi ta mbei wosu, ");
INSERT INTO srmNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","tee di daka di Lotu kumutu a Sodom go. Nöö hën di wan seei daka naandë faja kumutu a liba mökisi ku di soni de kai zuwalufu kai ko a goon tjuma dee sëmbë u Sodom kii tuu fiaa puu dë. ");
INSERT INTO srmNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wë nöö söseei a o pasa tu te Mi di ko dë Libisëmbë Mii aki o toona ko a goonliba fu sëmbë musu si mi.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nöö hën a taki da de möön taa: “A di daka dë nöö ee wan sëmbë dë nëën baiko, nöö an musu tei ten faa go tei soni fëën nëën wosu dendu e. A musu bazia ko a goon wante nöö a kule go tjubi. Nöö söseei ee wan sëmbë dë nëën goon dendu ta wooko, nöö an musu kule go a ganda go tei soni nëën wosu, ma a musu kule go tjubi nöö. ");
INSERT INTO srmNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","“Nöö fa mi ta fan aki, un mëni di soni di bi pasa ku di mujëë fu Lotu e. ");
INSERT INTO srmNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Biga di sëmbë di ta biinga faa hoi ën libi kumafa a këën ˻ku dee soni fëën dee a abi a goonliba aki˼, nöö a o lasi ën nöömö. Ma di sëmbë di aan toobi faa lasi ën, nöö hën o feni ën fa a kë.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Hën a taki möön taa: “A di daka di Mi di ko dë Libisëmbë Mii aki o ko, nöö tu sëmbë sa dë a wan bedi ta duumi, nöö wan u de Gadu o tei tja go nöö di otowan a o disëën. ");
INSERT INTO srmNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nöö tu mujëë o dë makandi a wan kamian ta mbei boon, nöö wan u de Gadu o tei tja go, nöö di otowan a o disëën.  ");
INSERT INTO srmNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Söseei tu sëmbë sa dë makandi ta wooko a goon dendu, nöö wan u de Gadu o tei tja go, nöö di otowan a o disëën dë.” ");
INSERT INTO srmNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nöö hën dee bakama u Masa Jesosi hakisi ën taa: “Wë, Masa o, na unsë u di goonliba di soni naandë o pasa?” Nöö hën a koti wan nöngö da de taa: “Ka wan mbeti dëdë fika, nöö naandë dee opete ta ko.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nöö hën Masa Jesosi taki wan woto da dee bakama fëën faa lei de kumafa de an musu ko wei u begi Gadu, ma de musu ta begi ën hiniwanten söndö lasi hati. ");
INSERT INTO srmNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A taa: “Wan fisikai bi dë a wan köndë, nöö a bi hogi tee an ta fëëë Gadu, nöö aan toobi ku libisëmbë tu. ");
INSERT INTO srmNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nöö wan mujëë bi ta dë a di köndë dë tu, manu fëën bi dëdë. Nöö a bi ta ko a di fisikai nöömö ta ko ta begi ën taa: ‘Fisikai o, mi kë i heepi mi. Mi ku wan sëmbë a’ sondi, nöö mi begi i fii kuutu di soni da u. Da mi di leti u mi nöö i dëën di adjabëë fëën.’ ");
INSERT INTO srmNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Nöö a fesi di fisikai an bi kë heepi di mujëë. Ma a baka fëën a ko pakisei tee a kaba, hën a taa: ‘Wë aluwasi fa ma ta fëëë Gadu, nöö ma a’ toobi ku libisëmbë tu, ");
INSERT INTO srmNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma tökuseei di mujëë aki ta ko a mi nöömö, an ta disa mi ku di taki möönsö. Nöö mi o heepi ën be a feni di leti fëën, be mi böö fëën. Biga ee nasö, a o ta ko ta kaakei mi ku di taki fëën dë nöömö.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nöö hën Masa Jesosi taa: “Un haika fa di fisikai taki dë. A abi hogihati, ma tökuseei, a piki di mujëë buka. ");
INSERT INTO srmNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wë nöö Masa Gadu di abi sö bunuhati wë? Ee wan sëmbë fëën ta begi ën nöömö a ndeti ku didia, an sa heepi ën nö? Biga a bi pii de puu a oto sëmbë dendu tei ko fëën sëmbë kaa, nöö a o buuja ufö a ko a de nö? Nönö, an o buuja e. ");
INSERT INTO srmNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi taki e, a o ko hesihesi a de ko kuutu soni da de. “Ma nöö fa mi fan dë seei, ma ˻fa de o du ku dee sëmbë u mi a di goonliba aki tjika dë, nöö˼ te Mi di ko dë Libisëmbë Mii aki toona ko ˻u mi ko heepi de˼, nöö mi o feni sëmbë möönsö di ta biibi a mi eti nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nöö hën Masa Jesosi da de wan oto u dee sëmbë dee ta wisiwasi otowan ta mbei deseei taa de dë bumbuu sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","A taa: “Wan daka nöö hën tu sëmbë hopo, hën de go a Masa Gaangadu Wosu fu de go begi Gadu. Nöö wan u dee sëmbë bi dë Faliseima nöö di otowan bi dë wan sëmbë di ta pii lanti möni. ");
INSERT INTO srmNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Nöö hën di de go naandë, hën di Faliseima go taanpu te a wan së ala, hën wanwan. Nöö hën a begi taa: ‘Masa Gadu, gaantangi fii e, fu di ma dë kuma dee takusëmbëma, kuma dee fufuuma, kuma dee sëmbë dee ta tei sëmbë mujëë, kuma di sëmbë ta pii lanti möni aki. ");
INSERT INTO srmNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tu toon hiniwan wiki mi ta disa u njan ta begi i. Hiniwan soni mi abi nöö mi ta paati, nöö mi tja fii së ko da i a keiki kumafa di wëti dë. Sö mi ta libi.’ Sö di Faliseima begi. ");
INSERT INTO srmNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ma di sëmbë ta pii lanti möni naandë, nöö a sabi taa an ta libi bunu tuu. Nöö sen kisi ën tee an sa hopo wojo luku liba möön. A fika a baka ala ta naki maun nëën hati taa: ‘Ke, Masa Gadu, a’ tjalihati u mi nöö i heepi mi o. Biga mi sabi taa mi dë wan gaan takusëmbëma tuu.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nöö hën Masa Jesosi taa: “Wë mi taki da unu taa fa di sëmbë ta pii lanti möni go a wosu dë, nöö Masa Gadu an hoi dee hogi du fëën nëën bëë möön e, ma a tei ën ko sëmbë fëën. Ma di Faliseima dë, Gadu disëën a go fëën a wosu nöö. Biga hiniwan sëmbë di hopo hënseei, nöö Gadu o sakëën. Ma hiniwan sëmbë di saka hënseei, nöö hën Gadu o hopo.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A di juu dë seei, nöö hën de ta tja dee piki mii ko a Masa Jesosi faa musu buta maun a de liba ˻begi da de˼. Ma di dee bakama u Masa Jesosi si sö, nöö hën de gandji da de taa: “Wan musu tja dee piki mii dë ko aki e.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma di Masa Jesosi jei fa dee bakama taki, hën a taa: “Nönö. Wan tapa de e! Un be dee mii ko a mi nöö. Biga sëmbë kuma dee mii aki, de ta dë a di Njunjun Tii u Masa Gadu dendu ta feni di bunu fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nöö mi taki e, ee wan sëmbë i kë ko dë a di Tii u Gadu dendu, nöö i musu abi sakafasi ta futoou Masa Gaangadu kumafa wan mii ta abi sakafasi ta futoou dee gaan sëmbë fëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nöö hën wan hedima u dee Isaëli sëmbë ko a Masa Jesosi. Hën a hakisi ën taa: “Mësitë o, mi sabi taa i dë wan bumbuu sëmbë, nöö hën mi ko hakisi i andi mi musu du fu mi feni di libi u teego.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Hën Masa Jesosi piki ën taa: “Womi, fa i ta kai mi bumbuu sëmbë aki, ma i saandi i ta taki dë nö? Bumbuu sëmbë an dë boiti Gadu wanwan nöö. ");
INSERT INTO srmNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ma nöö fii feni di libi u teego, nöö ja sabi dee wëti u Masa Gadu eti ö, taa ja musu go a oto mujëë möön leki di mujëë fii u wosu. Ja musu kii sëmbë. Ja musu fufuu sëmbë soni. Ja musu mindi soni da sëmbë. I musu ta lesipeki i tata ku i mama.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hën di hedima piki taa: “Wë, hii dee wëti dë tuu mi ta hoi fu sensi di mi dë piki mii.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nöö hën Masa Jesosi toona taki dëën taa: “Wë, mi jei. Ma ee fuu taki ën gbelin kumafa a dë, wan soni nöö toobi i eti. Hën da i musu go sei hii dee soni fii dee i abi te i kaba, nöö i paati di möni da dee pena sëmbë. Nöö te i du sö kaa, nöö i ko ta waka a mi baka. Nöö a bakaten nöö joo feni wan möön bunu gudu a Gaangadu Köndë.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nöö di di sëmbë jei sö, hën tjali ko kisi ën tee kuma a sa këë, biga a abi hia gudu tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nöö di Masa Jesosi si fa tjali kisi di womi fu dee gudu fëën hedi, nöö hën a taki taa: “Aai, di soni aki, a taanga e. Fu wan guduma butëën seei a di Tii u Masa Gaangadu basu, a dë wan taanga soni tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A dë leti kuma te wan gaan mbeti ta biinga faa pasa a wan aguja baaku. Sö a taanga tjika.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nöö di de jei sö, hën de hakisi ën taa: “Wë, ee a taanga da wan sëmbë ˻di Gadu seei heepi sö te a ko gudu˼, nöö ambë seei o sa go a Gadu Köndë?” ");
INSERT INTO srmNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hën Masa Jesosi piki de taa: “Di soni dë, na wan libisëmbë a’ taanga u du ën, ma Gaangadu hën a sa du hii soni.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nöö hën Petuisi taki dëën taa: “Wë Masa, luku. U disa hii soni tuu, fuu ko ta waka a i baka.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nöö hën Masa Jesosi piki ën taa: “Wë sö a dë tuu. Ma haika e. Ee wan sëmbë i kë dë a di Njunjun Tii u Gadu dendu te nöö hën i disa i wosu ee nasö i tata ku i mama ee nasö dee baaa fii ee nasö i mujëë ku dee mii fii, ");
INSERT INTO srmNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nöö mi taki e, taa hii dee soni naandë tuu joo toona feni baka möön leki fa i bi abi a goonliba aki, nöö a bakaten nöö joo feni di bunu libi u teego tu a Gadu Köndë.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A baka u di dë, hën Masa Jesosi kai de tuwalufu bakama fëën a së. Hën a taki da de taa: “Un haika e. Fa u dë aki, nöö u nango a Jelusalen. Nöö hii dee soni dee tjabukama u Gadu bi sikifi u Mi di ko dë Libisëmbë Mii aki, nöö de tuu o pasa ku mi awaa. ");
INSERT INTO srmNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dee feantima u mi o tja mi go a dee döösë sëmbë dee abi taki a di köndë aki, nöö de o ta mbei mi fa ta kosi mi ta tunta a mi. ");
INSERT INTO srmNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nöö de o wipi mi te de kaba ufö de o kii mi awaa. Ma nöö di u mbei dii daka fëën, nöö mi o toona weki hopo baka.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma fa Masa Jesosi fan ku dee sëmbë fëën dë, nöö de an fusutëën. A dë wan tjubitjubi soni da de, biga de an saandi a ta taki dë. ");
INSERT INTO srmNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nöö hën de nango tefa de ko zuntu ku di köndë de ta kai Jelikou. Nöö wan bookowojoma bi dë sindosindo a bandjapasi naandë ta pidi möni. ");
INSERT INTO srmNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nöö di a ta jei dee hia sëmbë ta fan ta ko dë hën a hakisi taa: “Sëmbë hën ta ko hia naandë sö nö? Andi ta pasa?” ");
INSERT INTO srmNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hën de taki dëën taa: “Di sëmbë de ta kai Jesosi u Nazalëti, hën wë ta pasa aki e.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nöö di a jei sö, nöö hën a bai taanga taa: “Jesosi eee, i di bakamii u Dafiti dë, ˻na i da di Heepima nö?˼ Gaantangi mi begi i, a’ tjali u mi, nöö i heepi mi ooo.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma di dee sëmbë dee bi ta waka a Masa Jesosi fesi jei di bai, hën de gandji dëën taa a musu kabuka dë. Ma tökuseei an disa. A bai möön taanga eti taa: “Jesosi eee, di mii u Dafiti dë, saa mi ooo, heepi mi, gaantangi!” ");
INSERT INTO srmNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nöö di Masa Jesosi seei jei di bai, nöö hën a taanpu pii. Hën a taki da dee sëmbë taa be de go tei di sëmbë naandë tja ko nëën. Nöö hën de tjëën ko. Hën Masa Jesosi hakisi ën taa: ");
INSERT INTO srmNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Mati o, wë andi i kë u mi du da i?” Hën di bookowojoma piki ën taa: “Masa, mi kë ta si soni baa.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hën Jesosi taki dëën taa: “Wë antoobi. Be wojo fii ko limbo e. Biga di biibi i ta biibi a Masa Gadu dë heepi i kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nöö wantewante dë, hën wojo fëën ko limbo gbegedee. Nöö hën a ta waka nango a Masa Jesosi baka ta gafa Gadu u di bunu a du ën dë. Nöö fa hii dee sëmbë dee bi sai dë si andi pasa dë, nöö hën de tuu gafa Gadu seei. ");
INSERT INTO srmNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nöö hën di Masa Jesosi kula di bookowojoma te a kaba, nöö hën a pasa go dou a Jelikou. Nöö a ta latja pasa a di köndë ganda ˻faa go a Jelusalen˼. ");
INSERT INTO srmNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nöö wan guduma de kai Zakeosi bi ta dë a di köndë. A dë wan hedima u dee sëmbë ta pii lanti möni. ");
INSERT INTO srmNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","4","Nöö fa Masa Jesosi ta pasa naandë, nöö Zakeosi bi kë si ën faa sabi ën. Ma an bi sa si ën a dee hia sëmbë dendu, biga a dë wan sati sëmbë. Nöö hën a kule go a fesi go subi a wan pau go dë a liba ala, fu te Masa Jesosi ta pasa dë nöö a musu u si ën. ");
INSERT INTO srmNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Te wan pisi hën Masa Jesosi ko ta pasa, nöö hën a hopo wojo a liba hën a si Zakeosi. Hën a kai ën: “Mati Zakeosi!” Hën a piki. Hën a taa: “Saka hesi ko a goon. Biga a dë fanöudu fu mi ko a i wosu tide.” ");
INSERT INTO srmNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nöö hën Zakeosi saka hesihesi ko a goon, nöö ku gaan piizii seei a tei Masa Jesosi tja go nëën wosu. ");
INSERT INTO srmNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma nöö di dee oto sëmbë si sö, hën de mati. De tei Masa Jesosi fu hogi seei fu di a de taa a go a wan takusëmbëma wosu. ");
INSERT INTO srmNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma nöö hën Zakeosi hopo taanpu ˻a dee sëmbë dendu˼ nöö hën a fan ku Masa Jesosi. A taki dëën taa: “Masa o, wë luku, te kuma tide nöö mi o paati dee gudu u mi leti mindi, nöö mi o da dee pootima u di köndë wan së. Nöö ee mi bi fufuu wan sëmbë, nöö mi o dëën fö toon möön hia möön fa mi bi tei.” ");
INSERT INTO srmNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hën Masa Jesosi piki taa: “Wë un dee sëmbë u di wosu aki, un a’ bunuhedi e. Biga tide Masa Gadu heepi unu. Nöö di sëmbë di a’ di wosu aki, a bi dë fanöudu u mi ko nëën, biga hënseei da wan bakamii u Abahamu di gaan sëmbë fuu tu. Wë nöö luku, a bi poi seei te kaba a sösö, ma tide a toona ko a Gadu baka. ");
INSERT INTO srmNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nöö fu dee lö sëmbë aki hedi mbei Mi di ko dë Libisëmbë Mii aki ko a goonliba e. Biga mi ko fu mi suku dee sëmbë dee kaba a sösö u mi tja de ko da Gadu.” ");
INSERT INTO srmNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nöö di juu Masa Jesosi ta fan ku dee sëmbë naandë, nöö de bi dë zuntu ku Jelusalen. Nöö dee Dju sëmbë bi ta mëni taa naandë nöömö Masa Gadu o bazia ko a goonliba faa ko tei di Könu Tii fëën a hii sëmbë wojo. Nöö dee sëmbë ta waka ku Masa Jesosi dë, de ta mëni taa wantewante di soni dë o pasa. Nöö fëën mbei Masa Jesosi da de wan oto, fu de musu sabi taa an o pasa kumafa de ta mëni ën dë. ");
INSERT INTO srmNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nöö hën a taki da de taa: “Wan hebima bi o go a wan longi köndë fu de butëën ko könu, bifö a o toona ko ta tii di köndë awaa. ");
INSERT INTO srmNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Nöö fëën mbei di juu a o go, nöö hën a kai teni u dee wookoma fëën ko nëën. Hën a da hiniwan u de wan dusu kölu. A taki da de taa: ‘Un wooko ku di möni aki fu mi sa feni wini nëën te mi toona ko.’ Nöö di a taki sö kaa, nöö hën a go fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ma dee sëmbë u di köndë fëën bi buuse ën te de manda buka go da dee sëmbë u di köndë ka a nango ala taa: ‘Wa kë di sëmbë aki ko könu fuu e.’ ");
INSERT INTO srmNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ma tökuseei de butëën ko könu. “Nöö hën a baka fëën hën a toona ko a di köndë ko seti di könu tii fëën awaa. Nöö di a ko, hën a manda buka kai dee wookoma fëën dee a bi da di möni fu de musu wooko dëën, be de musu piki ën unfa de bi wooko ku di möni. ");
INSERT INTO srmNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Nöö hën di fosuwan ko nëën nöö hën a tja di möni ko dëën. Hën a taa: ‘Masa o, luku, i bi da mi wan dusu kölu. Nöö hën mi ta wooko ku ën tefa i ko aki, mi feni dusu kölu buta nëën liba. Nöö hën mi tjëën ko da i.’ ");
INSERT INTO srmNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Nöö hën di masa fëën taa: ‘Aai womi, wë i wooko bunu e. Wë nöö fu di i wooko a sö wan futoou fasi ku di piki soni aki, nöö mi o da i wan gaan wooko awaa. Mi o buta i be i dë hedima u teni köndë.’ ");
INSERT INTO srmNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nöö hën di u mbei tu ko. Nöö hën a taki dëën taa: ‘Masa, luku, i bi da mi wan dusu kölu, nöö hën mi wooko ku ën tee mi wini feifi dusu kölu buta nëën liba. Nöö ja si ën aki, mi tjëën ko da i.’ ");
INSERT INTO srmNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Nöö hën di masa fëën taki dëën taa: ‘Söö. Wë nöö fu di i wooko sö, nöö hën mbei mi o buta i fii dë hedima u feifi köndë.’ Nöö hën a taki aai. ");
INSERT INTO srmNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Nöö hën di u mbei dii ko nëën. Hën a taki dëën taa: ‘Masa, ja ta si di möni fii aki nö. I bi da mi wan dusu kölu. Nöö u di mi sabi taa i dë wan taangalibi sëmbë, langahatima, i ta tei soni ka ja bi buta, i ta koti soni ka ja bi paandi, nöö mi fëëë i. Hën mbei mi tai di möni fii a di hangisa aki fu an musu kaba a sösö, nöö hën mi tja i soni ko da i.’ ");
INSERT INTO srmNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","“Hën di masa fëën taki dëën taa: ‘Womi, sö i hogi gaanfa wë nö? Wë di i sabi taa mi dë wan taangalibi sëmbë, langahatima di ta tei soni ka ma bi buta, mi ta koti soni ka ma bi paandi, nöö faandi mbei ja bi tei di möni u mi tja go buta a banku, fu te mi toona ko nöö a möön hia. A bi sa göö a di banku. Ma fa i du ku ën aki, nöö andi seei mi wini? Wë antoobi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nöö hën a taki da dee oto sëmbë sai dë taa: ‘Un hesi ko puu di möni aki nëën maun e, nöö un da di sëmbë di abi teni dusu kölu dë, be disi fika ku sösö maun.’ ");
INSERT INTO srmNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Hën de bai: ‘Huun? Wë Masa, di sëmbë ala, hën a feni teni dusu kölu kaa.’ ");
INSERT INTO srmNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A taki: ‘Aai, mi sabi sö. Ma di sëmbë di abi hia, nöö hën o feni möön hia eti. Ma di sëmbë di na abi, nöö nëën maun de o puu di pikiwan di a abi, be a fika ku maun. ");
INSERT INTO srmNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“ ‘Nöö dee felantima u mi, dee na bi kë u mi dë könu u de, nöö un musu tja de tuu ko kii a mi fesi aki.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nöö di Masa Jesosi taki di soni dë tefa a kaba, nöö hën hën ku dee bakama fëën tei pasi nango a Jelusalen, nöö Masa Jesosi hën dë a de fesi. ");
INSERT INTO srmNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nöö hën de nango tefa de ko zuntu ku de tu köndë de ta kai Betifaigi ku Betania, leti a di gaan kuun de ta kai Oleifi Kuun naandë. Nöö hën Masa Jesosi manda tu u dee bakama fëën fu de waka a fesi. ");
INSERT INTO srmNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","A taki da de taa: “Un nango te un go dou a di köndë a unu fesi ala, nöö woon si wan buliki mii taitai naandë. Sëmbë an sindo nëën liba waka wan daka. Nöö un lusu ën tja ko da mi e. ");
INSERT INTO srmNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma a kandë sö, wan sëmbë o ko hakisi unu taa: ‘Wë faandi mbei un ta lusu di mbeti u du?’ Nöö un musu taki dëën taa: ‘Masa abi ën fanöudu.’ ” ");
INSERT INTO srmNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nöö hën de tu bakama go, hën de go si hii soni leti kumafa Masa Jesosi bi taki da de. ");
INSERT INTO srmNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hën di de go seti lusu di buliki, hën sëmbë ko hakisi de taa: “Wë, faandi mbei un ta lusu di mbeti u du?” ");
INSERT INTO srmNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hën de piki taa: “Masa abi ën fanöudu.” ");
INSERT INTO srmNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nöö hën de tei ën tja go da Masa Jesosi. Hën de jabi koosu a di buliki baka mindi, hën de mbei Masa Jesosi sindo nëën liba. ");
INSERT INTO srmNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hën de seti u waka go. Nöö hën dee sëmbë ku ën ta waka nango dë ta jabi koosu a di gaan pasi liba fu di buliki musu waka a dee koosu liba. ˻Sö de ta hei Masa Jesosi tjika.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nöö hën de nango tefa de dou ka de o seti bazia di kuun fu de go a goon, nöö hën dee hia sëmbë ta waka nëën baka naandë tuu seti mbei piizii. De ta bai taanga ta gafa Gadu fu dee gaan bunu de bi si Masa Jesosi du a goonliba. ");
INSERT INTO srmNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","De taa: “Gaantangi u Masa Gadu ooo. A manda di Könu fëën ko da u. Masa Gadu musu dë ku ën e. Gadu, gaantangi fii! I mbei i ku libisëmbë toona ko fii! Di në fii musu bai te dou a di möön hei kamian a liba ala!” ");
INSERT INTO srmNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma di dee Faliseima jei fa de ta bigi Masa Jesosi nöö de an kë sö. Hën de taki dëën taa: “Mësitë o, bai dee sëmbë fii be de kabuka dë.” ");
INSERT INTO srmNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hën a taki da de taa: “Un haika e. Ee dee sëmbë u mi kabuka, nöö dee sitonu a bandjapasi aki seei o bia bai a dee sëmbë dë kamian. ˻Biga di bai aki musu u bai.˼” ");
INSERT INTO srmNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nöö hën Masa Jesosi nango te a ko dou ka a sa si Jelusalen, nöö hën a hopo wojo luku di köndë. Nöö hën tjali fëën kisi ën te a bai këë. ");
INSERT INTO srmNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A taa: “Un dee sëmbë u Jelusalen aki, ee a di ten aki un bi sabi di soni di bi sa heepi unu fuun sa feni böö, nöö wan bi o libi sö e. Ma luku, kumafa u dë aki, a poi da unu kaa, ma wan sa si ën biga a tjubi da unu. ");
INSERT INTO srmNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nöö wanlö hogi daka ta ko, nöö a dee daka dë dee felantima fuunu o ko lontu di köndë fuunu tapa buta a djegi, nöö woon fika a di köndë ganda naandë. Na wan fuunu o sa pasa ko a döö. ");
INSERT INTO srmNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","“Nöö naandë woon dë ta pena ta tja sitaafu fu te de kii unu ku dee miii fuunu tuu. Nöö dee gaan sitonu de tei mbei wosu a unu naandë, na wan u de o fika oto a oto liba möön e. De tuu de o booko tuwë a goon paaja fanjanfanjan. Sö de o booko di köndë fuunu tjika, fu di wan bi kë sabi di juu di Gadu bi ko faa ko heepi unu.” ");
INSERT INTO srmNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nöö hën Masa Jesosi go dou a Jelusalen awaa, hën a dendu go a di Gaan Wosu u Masa Gadu. Nöö wanlö sëmbë bi sai naandë ta sei soni a di wosu dendu. Nöö hën Masa Jesosi jaka de tuu puu tuwë a döö. ");
INSERT INTO srmNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hën a taki da de taa: “A sikifi a Gadu Buku taa: ‘Di wosu u mi aki, a dë wan wosu fuun ta ko ta begi mi.’ Ma un dee bödjëëma aki tei ën buta ko fufuuma kamian ta du kumafa un kë.” ");
INSERT INTO srmNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nöö di juu dë, hën Masa Jesosi ta lei sëmbë a di Wosu u Masa Gadu dendu hiniwan daka. Ma dee Gaan Begima ku dee Sabima u Wëti ku dee oto fesima u di köndë tuu bi ta suku wan fasi fu de musu kii ën. ");
INSERT INTO srmNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma de an saafa u du u de sa feni ën kii, biga hii sëmbë lobi u go nëën go jei dee soni a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wan daka hën Masa Jesosi bi dë a di Wosu u Masa Gaangadu dendu ta lei sëmbë ta konda di Bunu Buka u Gadu da de. Nöö hën dee Gaan Begima ku dee Sabima u Wëti ku dee Gaan Womi u di köndë ko nëën. ");
INSERT INTO srmNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hën de hakisi ën taa: “Wë dee soni i ta lei sëmbë aki, ku hii dee oto soni i ta du tuu, ambë seei manda i fii ta du de? Kondëën da u.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nöö hën Masa Jesosi piki de taa: “Söö. Wë antoobi. Ma miseei o hakisi unu wan soni tu. Nöö te un kondëën da mi, nöö mi o piki unu di Sëmbë di manda mi fu mi ta du dee soni aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Hën a hakisi de taa: “Di dopu Johanisi bi ta dopu sëmbë, naasë a kumutu, a Masa Gadu naa a libisëmbë? Ambë un sabi mandëën? Un kondëën da mi.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nöö hën de kuutu ku deseei tefa de wei, de taa: “Wë ee u piki ën taa Masa Gadu hën mandëën, nöö a kandë a o hakisi u taa: ‘Andi mbei wan bi kë biibi ën?’ ");
INSERT INTO srmNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma ee u piki ën taa a bi dë u libisëmbë, nöö lanti o kë naki u ku sitonu kii.” Biga hii lanti bi tei Johanisi kuma wan tjabukama u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Fëën mbei de piki ën taa: “Wë wa sa naasë a kumutu.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hën Masa Jesosi taki da de taa: “Wë da miseei tu, ma sa konda da unu ambë manda mi fu mi du dee soni aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nöö hën a toona da de wan oto möön. A taa: “Wan sëmbë bi koti wan gaan goon fëën faa mbei pandasi kamian. Nöö hën a paandi wan fuuta de ta kai doloifi nëën tefa a kaba. Nöö fu di a o go a wan oto köndë go tan te a longi, nöö hën a suku wanlö sëmbë tja ko buta a di pandasi kamian u de ta luku ën dëën. Nöö hën wë a go fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Hën a go dë ala teefa a sabi taa di fuuta u di goon sa lepi. Nöö hën a manda wan u dee wookoma fëën go a dee sëmbë, fu de musu dëën hafu u dee njanjan u di goon faa tja ko dëën. “Ma di di wookoma go dou a di pandasi kamian, nöö hën dee sëmbë kisi ën. Hën de fon mën tee a fon, hën de mandëën go nëën masa ku sösö maun. ");
INSERT INTO srmNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Hën di masa u di goon toona manda wan oto wookoma go luku möön, nöö söseei de du ku ën tu. De kisi ën fon dëën sen tee a tjika de, hën de mandëën go nëën masa ku sösö maun tu. ");
INSERT INTO srmNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Nöö hën di masa u di goon toona manda wan otowan u dee wookoma fëën go möön, di u mbei dii. Ma söseei de du ku ën tu. De naki ën koti hii ën sinkii, hën de jakëën puu a di pandasi kamian. Hën a toona go nëën masa ku sösö maun. ");
INSERT INTO srmNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Hën di masa u di goon taa: ‘Wë andi seei mi musu du möön? Wë nöö mi o manda di lobi mii u mi aki go. Kandë sö de sa a’ lesipeki fëën fu di a dë mi mii.’ ");
INSERT INTO srmNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nöö hën wë a mandëën go. “Ma di de si di mii u di masa ta waka ta ko, nöö hën de fiti buka makandi taa: ‘Söö. Luku di mii fëën ta waka ta ko dë. Hën wë di tata o disa di goon aki da e. Nöö un boo kii ën wante, nöö woo feni di goon ku dee soni dee dë nëën tuu ko fuu seei.’ ");
INSERT INTO srmNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“Nöö hën di di mii ko dou, hën de kisi ën. Hën de puu ën a di pandasi kamian ganda, hën de kii ën.” Nöö hën Masa Jesosi hakisi dee sëmbë taa: “Wë nöö fa de kii ën dë, nöö andi di sëmbë di abi di pandasi kamian o du ku dee sëmbë dee kii di mii fëën dë? ");
INSERT INTO srmNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Na a o ko kii de tuu puu a di pandasi kamian fëën nö? Nöö a o suku oto sëmbë tja ko buta dë fu de ta luku di kamian fëën dëën.” Wë nöö di dee Isaëli sëmbë dee sai dë jei a fan sö, nöö de an këën. Hën de taa: “Nönö, di sondi aki an musu pasa sö e!” ");
INSERT INTO srmNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hën Masa Jesosi luku de diin sö te a kaba, hën a taki da de taa: “Wë a o pasa tuu. Biga ja jei fa de sikifi a Gadu Buku nö? De koti wan nöngö taa: Di sitonu dee tëmbëma bi feni taa an bunu te de tuwë a kapëë, hën wë ko dë di mama posu ta hoi di wosu.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hën a taa: “Ee wan sëmbë i kai a di sitonu dë liba, nöö a o booko hii i sinkii. Ma ee di sitonu seei hën kai a i liba, nöö ja o a’ pisi möön. Biga a o lala i finufinu.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nöö fa Masa Jesosi da de di oto naandë, nöö dee Gaan Begima ku dee Sabima u Wëti bi kë kisi ën tja go söötö wantewante, biga de sabi taa de a tjökö ku di oto. Ma de fëëë dee hia sëmbë bi sai naandë. ");
INSERT INTO srmNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nöö hën de sai dë ta watji ën nöömö tefa de feni wanlö sëmbë. Hën de taki da de taa: “Wë u kë begi unu wan soni fuun heepi u, nöö u paka unu.” Hën dee sëmbë taa: “Söö, wë antoobi.” Hën de taa: “Un go a Jesosi kuma bumbuu sëmbë. Nöö un hakisi ën soni a köni fasi fuun feni wan töngö nëën fuu sa tjëën go kaagi da di gaama.” Nöö hën dee sëmbë go. ");
INSERT INTO srmNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nöö hën de go a Masa Jesosi, hën de hakisi ën taa: “Mësitë o, u ko a i aki. U kë hakisi i wan soni e, ma na u gaan womi fasi. Biga u sabi taa di fan fii dë bumbuu soni. I ta lei sëmbë di pasi u Masa Gadu bunu. I ta luku hii sëmbë di wan fasi nöö, ta konda fa Gadu kë u sëmbë musu libi söndö ganjan. ");
INSERT INTO srmNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“Nöö hën wë u ko a i aki ko hakisi i wan soni. Fa u ta paka di Gaan Könu lanti möni aki, nöö a bunu fuu pakëën nö, naa an bunu? Unfa a dë a di wëti u Gadu?” ");
INSERT INTO srmNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma fa de taki dë, nöö Masa Jesosi sabi kaa taa de kë kisi ën, hën a taa: ");
INSERT INTO srmNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Un tja wan kpëngëlë möni ko i si.” Hën de tei wan möni hën de tja ko dëën. Hën a hakisi de taa: “Wë ambë fesi dë a di möni? Un në un si dë sikifisikifi nëën?” Hën de taa: “Wë di u di Gaan Könu.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hën a taa: “Wë, ee a dë u di Gaan Könu, nöö un dëën hën soni e. Nöö un da Masa Gadu di soni di dë fëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nöö fa a fan dë, a foondo de tee. Hën de taa: “Aai, di sëmbë aki, wa a’ möiti fuu mbei te nöö u sa kisi ën möönsö.” Nöö hën de disëën. ");
INSERT INTO srmNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ma a baka u di dë, hën so u dee sëmbë u di keiki paatëi de ta kai Sadusei ko a Masa Jesosi. Dee sëmbë naandë an kë biibi möönsö taa dëdë sëmbë sa weki baka. Hën de hakisi ën taa: ");
INSERT INTO srmNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Wë Mësitë o, Mosesi bi sikifi wan wëti da u taa ee wan womi libi ku wan mujëë nöö ee di womi dëdë disa di mujëë söndö de pai miii, nöö wan u dee baaa u di womi musu tei di mujëë hoi, be de pai mii fu di böngö u di baaa di dëdë dë an musu kaba. ");
INSERT INTO srmNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Wë wan tata ku wan mama bi abi sëbën womi mii. Nöö hën di gaan wan tei wan mujëë. Hën de dë te wan pisi, hën di womi dëdë disa di mujëë söndö de pai miii. ");
INSERT INTO srmNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nöö hën di baaa di waka nëën baka tei di mujëë hoi, ma a dëdë disa di mujëë möön söndö de pai miii. ");
INSERT INTO srmNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hën di baaa di u mbei dii toona tei ën, hën a dëdë disëën tu. Nöö sö a pasa ku hii dee sëbën baa tuu fiaa. Na wan u de pai miii ku di mujëë möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A baka u di dë hën di mujëë ko dëdë tu. ");
INSERT INTO srmNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Wë te dee dëdë sëmbë o toona weki ko ku libi, nöö undi u de sëbën baa o abi di mujëë? Biga de tuu bi libi ku ën kaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nöö hën Masa Jesosi piki de taa: “˻Dee sëmbë aki, wan fusutan di soni bunu e.˼ Biga a goonliba aki nöö, womi ta tei mujëë, mujëë ta tei manu. ");
INSERT INTO srmNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Ma a Gadu ala dee lö libi dë an dë ala e. Biga dee sëmbë dee ta dë a Gadu Köndë ala, nöö de ko dë kuma dee basia fëën köndë kaa, de an ta dëdë möön. “Nöö di soni mbei sëmbë an ta dëdë ala. Biga dee sëmbë ta dë ala, de dë Masa Gadu mii, nöö de dëdë weki ko feni di libi u teego kaa. Nöö dee sëmbë dee Masa Gadu si taa de dë bumbuu nëën wojo, nöö de a o weki tei tja go u de feni di lö libi dë e.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nöö hën a toona taki da dee Saduseima taa: “˻Unfa wan kë piki taa te sëmbë dëdë nöö akaa fëën ta fika ku libi eti, faa toona ko nëën sinkii möön a bakaten?˼ Biga luku di Buku u Gadu, ka Mosesi bi sikifi kumafa a bi si di faja a di uwii. A bi sai dë ta luku di soni te wan pisi, hën a jei wan töngö a di faja dendu taa: ‘Mi da di Gadu di dee gaan sëmbë fuunu, Abahamu, ku Isaki, ku Jakopu ta begi. Di Gadu u de wë disi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","“Wë fa Gadu fan dë, hën kë taki taa dee sëmbë a kai dë, de dë ku libi eti. Biga Gadu an dë wan Gadu u dëdë sëmbë e. Nöö hën da hii dee sëmbë dee Gadu mbei tuu dë ku libi eti nëën wojo.” ");
INSERT INTO srmNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Nöö hën wanlö Sabima u Wëti piki ën taa: “Mësitë, i abi leti e, i taki bunu.” Nöö a baka u di dë, nöö na wan sëmbë abi hati u hakisi Masa Jesosi na wan soni möön. ");
INSERT INTO srmNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nöö hën Masa Jesosi taki da de taa: “Wë mi o hakisi unu wan soni awaa. Dee mësitë ta lei unu di Buku u Gadu taa di Paamusi Könu o dë Dafiti bakamii, na sö nö? ");
INSERT INTO srmNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Wë nöö sö a dë tuu. Ma Dafiti seei sikifi soni fëën a di Kanda Buku. A taa: Masa Gadu taki da mi Masa taa: ‘Ko sindo a mi letimaun së aki. ");
INSERT INTO srmNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nöö i dë aki fu tee mi buta dee felantima fii tuu a i basu futu.’ ");
INSERT INTO srmNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Wë nöö di Dafiti ta kai ën ‘mi Masa’, nöö unfa a sa dë bakamii fëën nöö?” ");
INSERT INTO srmNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nöö leti a hii dee hia sëmbë dendu naandë Masa Jesosi taki da dee bakama fëën taa: ");
INSERT INTO srmNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Un musu luku bunu ku dee Sabima u Wëti e. Biga fa de sai dë, de lobi u tapa gaan langa bandjakoosu ta waka ta lontu u de a köndë ganda mindi nango a wojowojo, fu hii sëmbë musu ta si de ta da de odi a lesipeki fasi a hii sëmbë fesi. Nöö söseei tu, te de go a keiki, ee nasö tee de o go fu de go sindo a tafa a wan piizii, nöö de lobi u go sindo a dee möön hei kamian. ");
INSERT INTO srmNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Ma nöö hii fa de ta mbei taa de bumbuu dë, ma de an bumbuu e. Biga dee mujëë söndö manu dee aan heepi u deseei, nöö de dee Sabima ta njan hii soni de abi te kisi ku de wosu tuu. Nöö ku di fasi dë seei, de ta kumutu u de nango ta begi wanlö gaan langa begi u sëmbë musu sabi taa de dë bumbuu sëmbë. Nöö dee lö sëmbë dë, de o kisi di möön gaan hebi sitaafu a Gadu e.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nöö hën Masa Jesosi dë a di Wosu u Gadu te wan pisi, hën a hopo wojo luku ala hën a si fa dee guduma ta tuwë möni a di möni këdë u di keiki. ");
INSERT INTO srmNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nöö hën a si wan pena mujëë, manu fëën bi dëdë, hën a tja tu köpö sensi fëën ko tuwë a di këdë. ");
INSERT INTO srmNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nöö hën Masa Jesosi luku ën te a kaba, hën a taki da dee bakama fëën taa: “Un si ö? Fa de ta buta möni a di këdë aki, nöö di pena mujëë i si naandë buta gaan möni möön de tuu e. ");
INSERT INTO srmNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Biga di wan piki möni dë, hën nöö a bi abi faa njan. Aambi a wosu möönsö. Ma dee guduma abi hia möni a wosu eti.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wë nöö fa de dë a di Wosu dë, hën so u dee bakama u Masa Jesosi taa: “Ja si fa di Wosu u Gadu aki waiti nö? De tëmbëën te a hanso. Nöö hën de bisi ën seei ku dee soni dee de ta tja ko ta da Masa Gadu.” Nöö hën Masa Jesosi taki da de taa: ");
INSERT INTO srmNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Aai, sö a dë tuu. Ma i si fa di Wosu dë aki nö? Fa i si de mbei ën hanso seei, ma wan ten o ko de o booko ën fiaa tuwë a goon. Dee sitonu i si dë, na wan u de o dë oto a oto liba möön. De tuu o booko paaja.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nöö hën de hakisi ën taa: “Wë mësitë o, u kë fii lei u wan maaka fuu sabi na un ten di soni dë o pasa.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nöö hën Masa Jesosi piki de taa: “Un musu luku bunu a di ten u ta taki aki fu sëmbë an musu ko ganjan unu. Biga hia sëmbë o ta ko a unu ku mi në. So u de o taa: ‘Mi wë da di Paamusi Könu,’ nöö di otowan o taa: ‘Di ten dou kaa.’ Ma wan musu piki e. Wan musu haika dee soni de ta taki da unu möönsö. ");
INSERT INTO srmNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Nöö te un ta jei taa takitaki, toobi, feti, buja ta pasa a kamiankamian, nöö wan musu fëëë e. Biga dee lö soni dë musu ko pasa ufö, ma di kaba u di goonliba nëën di dë eti. ");
INSERT INTO srmNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wan könu o ta suku di otowan a toobi ta feti ku ën tee a bigi. Nöö söseei wan köndë o hopo ta suku di oto köndë a toobi, de o ta feti te a bigi. ");
INSERT INTO srmNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","“Nöö di juu dë, goon o ta seki ta latja a sömëni kamian u di goonliba ta kii sëmbë. Gaan hangi o ta ko tee soni seei an o ta dë u njan. Nöö taku siki o ko a mundu ta kii piki mii ku gaan sëmbë tuu. Gaangaan soni seei o ta pasa a goonliba tee dou a mundu a liba ala tu. Gaangaan maaka o ta pasa dee ja bi mëni, te hii sëmbë o ko ta fëëë a di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma bifö hii dee soni aki ko, nöö de o buta unu da siköutu kisi. De o sitaafu unu ta du hogihogi ku unu te a tjika de. De o tja unu go kuutu a dee keikiwosu u de. De o tja unu go söötö buta a dunguwosu. De o tja unu go a dee könu ku dee gaama go kuutu unu fu di un ta waka a mi baka. ");
INSERT INTO srmNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma nöö te a pasa sö kaa, nöö woon feni pasi fuun konda di Bunu Buka u Masa Gadu da dee sëmbë awaa. ");
INSERT INTO srmNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Ma nöö fa woon go a dee kuutu dë, nöö an dë fuun booko hedi a di soni woon taki e. ");
INSERT INTO srmNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Biga miseei o da unu dee wöutu dee fuun taki. Mi o da unu fusutan fuun sabi unfa fuun piki de. Nöö te un fan te un kaba kaa, nöö na wan u dee felantima fuunu o feni soni u piki möön e. ");
INSERT INTO srmNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Unu tata ku unu mama ku dee baaa fuunu ku dee famii fuunu ku dee mati fuunu, de tuu o tja unu go kaagi da lanti fu de musu sitaafu unu. Nöö sömëni fuunu de o kii puu. ");
INSERT INTO srmNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nöö hii sëmbë o buuse unu, fu di un ta biibi a mi hedi. ");
INSERT INTO srmNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Ma tökuseei wan musu fëëë. Biga ee un hoi a di biibi go dou, nöö na wan u dee uwii a unu hedi seei sa lasi. Ee un dëdë seei, ma woon toona weki fuun feni di bunu libi fu teego.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Hën a taki möön taa: “Te un si sodati lontu Jelusalen buta a djegi, nöö un musu sabi taa di ten dou fu de booko ën puu dë e. ");
INSERT INTO srmNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nöö dee sëmbë dee dë a Judea a di ten dë, nöö de musu kule go tjubi a dee gaan kuun mindi. Nöö dee sëmbë dee dë a köndë ganda, nöö de musu kule kumutu dë. Dee sëmbë dee dë a goon dendu, de an musu toona go a köndë ganda möön. ");
INSERT INTO srmNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Biga a di daka dë Gadu o sitaafu dee sëmbë u Jelusalen fu hii dee hogi du u de, kumafa di Buku fëën bi taki a fesi. ");
INSERT INTO srmNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Nöö a tjali fu dee mujëë dee dë ku bëë a di lö ten naandë e, ku dee mujëë dë ku miii a maun. Biga sö wan gaan hebi sitaafu o ko a di köndë. Masa Gadu hati o boonu tee na sipootu. ");
INSERT INTO srmNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nöö hafu u dee sëmbë de o kii ku sëufangi, hafu u de de o kisi tja go paaja a hii köndë. Nöö dee döösë sëmbë o ko tei Jelusalen ko u de nöö de o ta du ku ën kumafa de kë, fu tee dou di ten Masa Gadu bi buta da de pasa.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nöö hën a toona taki da de möön taa: “Di ten u ta taki soni fëën aki, nöö de o ta si gaangaan maaka a di sonu ku di libawojo, ku dee teeja tuu a gaangadu ala. Nöö a goonliba aki, nöö di ze o ta seki ta giinta tee hii sëmbë a dee köndëköndë o ko fëëë. ");
INSERT INTO srmNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","De o ta panta tee. Biga de o si taa de dë a dëdë ku libi maun, fu di de an saandi o ko a di goonliba. Di mundu a liba ala o ta seki te na soni, nöö hii dee soni ala tuu o pusa kumutu a de kama ka de bi dë. ");
INSERT INTO srmNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Nöö di juu dë, Mi di ko dë Libisëmbë Mii aki o kumutu a liba ala ta bazia ta ko a goon a wan bundji dendu, ku di gaan kaakiti u mi ku di limbo u mi kuma sonuwojo. ");
INSERT INTO srmNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nöö te un si dee soni naandë seti ko, nöö un musu dë waiwai awaa. Biga di juu zuntu fuun kumutu a di fuka di un dë aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Nöö hën a da de wan oto taa: “Un luku. Te i si di pau de kai figa ku dee oto pau buta folo, nöö i musu sabi taa de o buta njanjan. ");
INSERT INTO srmNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","“Wë nöö söseei tu, te un si taa hii dee soni mi ta taki da unu aki tuu seti ko, nöö un musu sabi taa Masa Gadu juu dou faa ko a di goonliba ko tei di Könu Tii fëën ta taki a hii mundu liba awaa. ");
INSERT INTO srmNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nöö mi taki da unu tuutuu taa dee lö sëmbë u di ten u dë aki, de an o dëdë kaba bifö hii dee soni u taki aki ko pasa. ");
INSERT INTO srmNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nöö fa mi ta fan aki, nöö di mundu a liba ala ku di goonliba u dë aki tuu sa lasi go kaba a sösö, ma dee wöutu u mi aki na wan u de sa lasi möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Hën a taki da de möön taa: “Dee sëmbë o, un mëni unu seei e, fu wan booko unu hedi ku dee sölugu u di goonliba aki ku dee jajo libi fëën, te nöö un fëëkëtë di Daka dë e. Wan musu ta sai dë ta dööngö ta poi ten te nöö di daka kisi unu söndö un mëni. Biga a o ko kai a hii sëmbë tuu liba kuma aviti. Aan fa fii köni te nöö an o kisi i. ");
INSERT INTO srmNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hën mbei un musu dë ku wojo ta begi Gadu nöömö fuun sa pasa dee soni u ta taki aki söndö un lasi di biibi di un abi a mi liba. Nöö un sa ko taanpu a Mi di ko dë Libisëmbë Mii aki fesi söndö fëëë.” ");
INSERT INTO srmNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nöö sö Masa Jesosi ta lei dee sëmbë nöömö a di Wosu u Masa Gadu dendu. Mamate a ta lei de tee sapate, ma a ndeti a ta dë a di Kuun de ta kai Oleifi Kuun. ");
INSERT INTO srmNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nöö te mamate biten, nöö dee sëmbë u di köndë ta toona ta ko a di Wosu u Gadu naandë möön fu de jei andi a o ko taki da de möön. ");
INSERT INTO srmNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wë nöö di ten dë, di daka u dee Isaëli Sëmbë ko zuntu kaa di de ta njan bëëë söndö sooda. ˻Di daka dë, hën de ta kai Pasika.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nöö dee Gaan Begima ku dee Sabima u Wëti ta suku wan köni fasi nöömö fa de sa du de feni Masa Jesosi kii. Biga ee lanti ko sabi, a kandë de o mbei gaan toobi ku de. ");
INSERT INTO srmNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Di juu naandë, hën di didibi go a di womi de kai Judasi Isikaliotu hati. Nöö di womi aki bi dë wan u dee tuwalufu bakama u Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nöö hën a hopo go a dee Gaan Begima ku dee hedima u dee sodati dee ta hoi wakiti a di Wosu u Masa Gadu naandë. Hën a taki da de taa ee de kë nöö a sa mbei möiti da de fu de sa kisi Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nöö di dee sëmbë jei sö, hën de wai seei. De taa de sa pakëën möni ee a heepi de sö. ");
INSERT INTO srmNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nöö hën di Judasi jei sö kaa, hën a ta suku fa fu de sa feni Masa Jesosi kisi a wan fasi fu lanti an musu sabi. ");
INSERT INTO srmNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nöö hën de dë tefa di daka dou u de kii di sikapu mii fu de njan di daka. ");
INSERT INTO srmNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nöö hën Masa Jesosi manda Petuisi ku Johanisi a wan soni. A taki da de taa: “Wë un go, nöö un seeka boi soni fuu njan di Pasika.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hën de hakisi ën taa: “Wë Masa o, unsë i kë fuu go seeka?” ");
INSERT INTO srmNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Hën a taa: “Un go a di köndë ganda, nöö woon si wan womi ta waka nango ku wan djogu wata, nöö un waka go nëën baka. Nöö te un si a denda a wan wosu, nöö unu seei musu go denda naandë tu. ");
INSERT INTO srmNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nöö un musu taki da di sëmbë abi di wosu taa: ‘Di mësitë manda u fuu ko hakisi i ee naasë di kamba dë ka hën ku dee bakama fëën sa ko njan di piizii?’ ");
INSERT INTO srmNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nöö a o lei unu wan gaan kamba a liba dë ku hii dee soni dee un a’ fanöudu. Nöö naandë un musu go seeka soni te un kaba.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nöö hën dee sëmbë go. Hën de go si hii soni tuu leti kumafa Masa Jesosi bi taki da de. Nöö hën de go seeka soni. ");
INSERT INTO srmNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nöö hën de sai dë tee di juu kisi, hën Masa Jesosi ku dee oto bakama fëën ko dou. Hën de tuu go sindo a tafa u de njan. ");
INSERT INTO srmNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nöö hën a taki da de taa: “Wë mi bi hangi seei fu mi njan di daka aki ku unu e baa, ufö di juu dou fu mi tja di sitaafu di mi musu tjai. ");
INSERT INTO srmNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wë biga ma o njan sö wan daka ku unu möön eti e, u tee dee soni u ta mëni ku di piizii aki tuu pasa, nöö Masa Gadu seti di Njunjun Tii fëën a libisëmbë mindi.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nöö hën a tei di kan hën a da Masa Gadu tangi te a kaba. Nöö hën a taki da de taa: “Un tei ën nöö un tuu bebe lontu ko kai. ");
INSERT INTO srmNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wë biga fa i si u ta bebe di win aki sö, nöö ma o bebëën möön eti e. Ma te Masa Gadu tja di Njunjun Tii fëën ko bifö mi o toona bebëën möön.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nöö hën a tei di bëëë hën a da Gadu tangi te a kaba. Hën a booko ën paati da dee bakama fëën. Nöö hën a taki da de taa: “Di bëëë i si aki, hën da di sinkii u mi di o dëdë fuunu hedi. Nöö kumafa i si u ta njan mën aki, sö nöö un musu ta du nöömö, fuun ta mëni di dëdë di mi o dëdë da unu.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nöö di de njan te de kaba, hën a tei di kan, hën a taa: “Di win un ta si a di kan aki, nöö hën da di njunjun buka Masa Gadu mbei ku unu fu di mi o tuwë di buuu u mi a goon, ˻dëdë fuunu hedi˼.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nöö hën a taa: “Ma un haika e, dee sëmbë. Wan fuunu di mi ku ën dë sindosindo ta njan a tafa aki o tja mi go könku fu de musu kii mi. ");
INSERT INTO srmNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nöö sö nöö a musu pasa e. Biga Mi di ko dë Libisëmbë Mii aki musu u dëdë kumafa Masa Gadu bi butëën. Ma helu u di sëmbë di o könku mi sö e, biga di sitaafu di a o kisi, a o bigi.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nöö di Masa Jesosi taki sö, nöö hën dee bakama seti hakisi de na de taa: “Wë undi fuu seei dë aki di sa du sö wan soni baa?” ");
INSERT INTO srmNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A di ten dë seei hën dee bakama u Masa Jesosi kisi toobi ku deseei. De ta fia ku de na de ta hakisi taa fa de sai dë undi u de sa dë möön hei möön dee oto. ");
INSERT INTO srmNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma Masa Jesosi taki da de taa: “Dee sëmbë aki, un haika e. Dee könu u di goonliba aki dee ta tii köndë, de ta duwengi sëmbë fu de musu du dee soni de kë. Nöö de ta suku u sëmbë musu buta de hei möön oto sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma di lö libi naandë an musu dë a unu mindi e. Biga di sëmbë di dë di möön hei wan fuunu, hën musu dë di möön sakafasi sëmbë. Nöö di hedima fuunu hën musu dë kuma wan wookoma a unu mindi. ");
INSERT INTO srmNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Biga di sëmbë di ta sindo ta njan a tafa ku di sëmbë di ta buta njanjan a di tafa, undi u de möön hei? Na di sëmbë ta sindo a tafa nö? Ma luku mi fa mi dë kuma wan wookoma a unu mindi aki, kuma di sëmbë di ta buta njanjan a tafa da dee otowan. Nöö söseei unu musu dë tu e.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nöö hën a taa: “Wë un haika e baa. Unu bi da dee sëmbë dee bi dë ku mi sömëni longi, ku dee pena u mi ku dee fuka libi u mi te kisi fa u dë aki. ");
INSERT INTO srmNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Wë nöö fëën mbei mi paamusi unu taa te mi subi a di Könu Tii u mi, nöö mi o da unu taki a sëmbë liba e. Wë biga sö mi Tata bi paamusi mi taa a o da mi taki a sëmbë liba, nöö söseei mi toona paamusi unu tu. ");
INSERT INTO srmNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nöö un sa sindo a tafa ta njan ta bebe a di köndë u mi ka mi dë könu. Nöö un sa sindo a dee könubangi ta kuutu dee tuwalufu lö u dee Isaëli sëmbë. “Sö mi paamusi unu e, dee sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nöö hën Masa Jesosi kai Petuisi, a taa: “Simon o.” Hën a piki. Hën a taa: “Haika e, mi o taki wan soni da i. Di didibi Saatan hakisi pasi faa pooba unu e. Nöö a o pooba unu leti kuma te wan sëmbë ta fon alisi ta böö, faa musu sabi undi da di kakisa, undi da di njanjan. ");
INSERT INTO srmNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma haika Simon, mi begi da i kaa e, fu ja musu disa di biibi fii di i abi. Biga joo disa mi. Ma te i toona ko a mi baka nöö i musu heepi dee otowan fii tu, fu de ko möön taanga a di biibi.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hën Petuisi taa: “Höön, Masa, nönö! Mi, fa mi dë aki, nöö hiniwan kamian ka i nango mi sa go ku i. Ee a dunguwosu seei mi sa go. Ee te a dëdëköndë seei mi sa go ku i. Ma o disa i möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hën Masa Jesosi taki dëën taa: “Womi Petuisi, mi taki e, taa tide seei bifö ganian kanda joo fia dii pasi nöömö taa ja sabi mi, mi ku i na mati.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nöö hën a toona taki da de möön taa: “A fesi mi bi ta manda unu go a kamian söndö möni, söndö tasi, söndö susu a futu. Wë nöö di un bi nango un bi ta pena nö?” Nöö hën de tuu piki ën taa: “Wë nönö, Masa, soni an bi ta fuka u e.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nöö hën a taa: “Söö. Wë un haika e. Fa u dë aki, te woon go a kamian möön nöö ee wan sëmbë abi saku nöö be a tjëën e. Ee wan sëmbë a’ möni nöö be a tjëën. Nöö ee wan sëmbë aambi sëufangi, nöö be a sei di gaan koosu fëën nöö a bai sëufangi. ");
INSERT INTO srmNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Wë biga wan soni u mi dë sikifisikifi a Gadu Buku taa de ta si mi ku dee takusëmbëma di wan fa. Nöö hii dee soni di Buku bi taki u mi, nöö fa u dë aki de tuu musu ko pasa e.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hën de taki dëën taa: “Masa o, luku. U abi tu ufangi aki kaa.” Hën Masa Jesosi taki da de taa: “Aaa, wë un boo disa di oto ufö.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A baka u di dë, hën Masa Jesosi ku dee bakama fëën go a döö. Hën de nango tefa de go dou a di kuun de ta kai Oleifi Kuun, kumafa de bi guwenti. ");
INSERT INTO srmNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nöö di de go dou a di kamian, hën a taki da de taa: “Un begi e, dee sëmbë, be di tesi di ta ko a unu aki an musu wini unu.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nöö hën a waka kumutu dë go a wan së buka. A go longi tjika kuma ka wan sëmbë sa hiti kodjo dou. Nöö hën a tjökö kini a goon dë begi Masa Gadu. A taa: ");
INSERT INTO srmNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Taata o, gaan tangi mi begi i, luku di soni dë a mi liba aki. Nöö ee i feni ën bunu nöö un boo du ën a wan oto fasi. Biga a hebi da mi poi. Ma fa mi taki aki seei, na du kumafa mi kë e, ma du kumafa i kë.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nöö di juu dë hën a si wan basia u Masa Gadu Köndë ko nëën ko dëën kaakiti. ");
INSERT INTO srmNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma nöö hën di soni ko hebi nëën liba möön tee an saanfa faa du. Hën a ko begi möön taanga eti tee di suwa fëën ko dë kuma buuu ta koti ta kai a goon. ");
INSERT INTO srmNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nöö di a kaba u begi, hën a hopo toona go a dee bakama fëën. Nöö di a go dou, hën a si de tuu ta duumi. Biga tjali bi kisi de poi. ");
INSERT INTO srmNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nöö hën a taki da de taa: “Duumi un ta duumi sö nö, womi? Wë un hopo e, nöö un begi Masa Gadu faa musu heepi unu fu di soni di ta ko a unu aki an musu wini unu.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nöö an kaba u fan seei, hën de bia luku hën de si wanlö hia sëmbë ta ko. Nöö fa de ta ko dë, Judasi di bakama u Masa Jesosi dë a fesi, nöö hën a waka ko zuntu ku Masa Jesosi faa musu bosi ën. ");
INSERT INTO srmNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Hën Masa Jesosi hakisi ën taa: “Womi Judasi, andi wë, baa? Ku bosi i ta sei Mi di ko dë Libisëmbë Mii aki nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nöö hën dee bakama fu Masa Jesosi hakisi ën taa: “Masa o, andi u musu du? U musu tei sëufangi heepi i kii dee sëmbë aki ö?” ");
INSERT INTO srmNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nöö fa u mbei dë, nöö hën wan u dee bakama koti di letisë jesi u wan u dee futuboi u di Kaba Hei Begima belim puu. ");
INSERT INTO srmNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nöö hën Masa Jesosi taa: “Womi, nönö. Na du sö e.” Nöö hën a go panjan di jesi u di sëmbë hën a ko bunu baka. ");
INSERT INTO srmNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nöö hën a fan ku dee Gaan Begima ku dee hedima u dee sodati dee ta luku di Wosu u Gadu, ku dee Gaan Womi dee ko dë, a taa: “Dee sëmbë, faandi mbei un ko a mi aki ku ufangi ku kodjo kuma un ta ko kisi wan bookoköndëma di ta kii sëmbë? ");
INSERT INTO srmNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Biga mi ku unu bi ta dë hiniwan daka a di Wosu u Masa Gadu, ma na wan daka un buta maun a mi taa woon kisi mi tja go a kuutu. Nöö hën un ko a mi aki tide sö nö? “Ma wë antoobi, awaa di juu fuunu ku didibi dou, biga hën a’ taki a di mindi aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wë nöö di Masa Jesosi fan sö te a kaba, hën de kisi ën gbolou panjan. Hën de tjëën go tee a di Kaba Hei Begima pisi. Nöö fa de nango dë, hën Petuisi seei ta waka saapisaapi nango a de baka. ");
INSERT INTO srmNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nöö hën de nango tefa de go dou hën de tja Masa Jesosi go a wosu dendu. Ma nöö de bi mbei wan gaan faja a di djai dendu, nöö hia sëmbë bi sindo naandë ta këndë faja. Nöö di Petuisi ko dou, hën a go sindo a dee sëmbë bandja ta këndë faja tu. ");
INSERT INTO srmNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nöö hën a sai dë te wan pisi. Hën wan mujëë ta wooko a di wosu ko si ën a di faja bandja naandë, nöö hën a luku ën diin sö. Hën a taa: “Huun, di womi aki, mi si kuma di sëmbë de tja ko aki dë sëmbë fii.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hën Petuisi fia taa: “Ambë? Mi? Di sëmbë dë, ma sabi ën!” ");
INSERT INTO srmNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Te wan pisi hën wan oto sëmbë ko dou dë möön. Hën a taa: “Wë womi, di fasi mi si i aki, i musu u dë wan u dee sëmbë u di womi naandë.” Hën Petuisi toona fia möön taa: “Nönö womi, di sëmbë un ta taki dë, ma sabi ën e! Na kai mi në mökisi ku ën.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nöö kuma baka wan juu langa sö, hën wan otowan ko dou dë möön. A taa: “Huun? Di womi aki, a musu dë sëmbë u di womi dë, biga a dë Galilea sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hën a taa: “Nönö e, dee sëmbë. Mi taki e, di sëmbë dë ma sabi soni fëën e! Un disa mi ku soni fëën!” Nöö di a taki sö, nöö hën wë di ganian bai kanda kënkënjënkëën. ");
INSERT INTO srmNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Di juu dë, hën Masa Jesosi bia luku ën diin. Nöö Petuisi ko pakisei di woto di a bi taki dëën taa: “Womi, a di ndeti aki seei ufö ganian kanda, nöö joo fia dii pasi taa ja sabi mi.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nöö hën wë a kule kumutu go a döö, hën a go bai këë te a bigi. ˻Di disa di a disa Masa Jesosi dë, nöö hën wë hati ën sö.˼ ");
INSERT INTO srmNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma nöö fa de kisi Masa Jesosi tja go buta naandë, nöö hën dee sëmbë sai dë ta watji ën. De ta hoi ën a sipootu ta naki ën wanwan böö. ");
INSERT INTO srmNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nöö hën de tei wan koosu hën de tai ën wojo tapa. Hën de ta naki ën ta hakisi ën taa: “Ee Gadu ta fan ku i tuu, nöö i taki da u ambë naki i?” ");
INSERT INTO srmNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nöö hën de ta kosi ën peipei takutaku kosi tefa a tjika de. ");
INSERT INTO srmNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nöö hën di dobooko fëën, mamate biten, nöö hën dee Gaan Womi ku dee Gaan Begima ku dee Sabima u Wëti, hën de ko makandi fu de kuutu a Masa Jesosi liba awaa. Nöö hën de go tei ën tja ko. ");
INSERT INTO srmNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nöö hën de hakisi ën taa: “Wë unfa i ta pakisei fii seei, fa i dë aki? I da di Paamusi Könu nö? Taki da u.” Hën a piki de taa: “Wë ee mi taki da unu seei, wan o kë biibi mi e. ");
INSERT INTO srmNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nöö ee mi hakisi unu wan soni tu, nöö wan o piki mi. ");
INSERT INTO srmNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma wan soni nöö mi sa taki da unu taa, fu kumutu a di ten aki nöö Mi di ko dë Libisëmbë Mii aki o dë sindosindo a letimaun së u Masa Gadu ka a dë ku di gaan kaakiti fëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nöö hën de tuu hakisi ën taa: “Wë womi, fa i fan dë, nöö i da di Mii u Gadu nö?” Hën a taki da de taa: “Wë, leti kumafa un taki dë, nöö sö nöö a dë e.” ");
INSERT INTO srmNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nöö hën de tuu bai taa: “Söö. Un toobi u abi fu de tja kaagi fëën ko da u möön? Biga u seei jei nëën seei buka fa a taki. A taa hën da Masa Gadu Mii. U feni soni fuu kii ën awaa.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nöö hën hii dee sëmbë tuu hopo vu taanpu. Hën de tei Masa Jesosi, hën de tjëën go a Gaama Pilati, di hedima u di köndë. ");
INSERT INTO srmNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nöö di de ko dou, hën de seti kaagi ën taa: “Di sëmbë i si aki sö, a ta tja gaan toobi ko a di köndë e, ta bia sëmbë hedi ku dee lei fëën. A taa wa musu paka di Gaan Könu lanti möni möön. Nöö a taki taa hën da di Keesitu, di Paamusi Könu di Masa Gadu bi taa a o manda da u.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nöö hën Pilati hakisi ën taa: “Womi, i da di könu u dee Dju sëmbë tuu nö?” Hën Masa Jesosi piki ën taa: “Leti kumafa i taki dë, sö nöö a dë.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nöö hën Pilati taki da dee Gaan Begima ku hii dee oto sëmbë dee ko naandë taa: “Wë di sëmbë aki, ma feni föutu nëën u mi sitaafu ën e.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma nöö hën dee sëmbë tuu ta piki nöömö taa: “A ta tja gaan toobi ko a hii di köndë ku di lei fëën e. Biga a seti a Galilea hën a ta waka ta lontu hii dee köndë teefa a ko dou ku ën a u a Judea aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wë nöö di Pilati jei sö, hën a hakisi ee Jesosi dë sëmbë u Galilea. ");
INSERT INTO srmNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Biga ˻Pilati seei aan taki a Galilea, ma˼ Könu Helodi hën abi taki ala. Nöö hën de piki ën taa: “Aai, a dë sëmbë u Galilea.” Nöö di Pilati ko jei sö, hën a mandëën go a Könu Helodi be hën kuutu soni fëën. Biga a di juu dë di könu bi dë leti a Jelusalen dë tu. ");
INSERT INTO srmNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Wë nöö di Könu Helodi si Masa Jesosi ko dou, hën a wai. Biga a bi ta jei fëën nöömö, ma hën ku ën an bi miti wan daka. Nöö fa de miti dë nöö a bunu dëën, biga kandë a sa du wan foombo soni dëën be a si. ");
INSERT INTO srmNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nöö hën di könu hakisi Masa Jesosi wanlö hia soni faa konda dëën, ma Masa Jesosi an piki ën. A dë fëën pii. ");
INSERT INTO srmNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nöö hën dee Gaan Begima ku dee Sabima u Wëti djombo tei fesi ta konda sömëni soni fëën ku hatiboonu da di könu. ");
INSERT INTO srmNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hën di könu ku dee sodati fëën, hën de lafu Masa Jesosi te a bigi, ta wisiwasi ën ta mbei ën fa. Hën de bisi wan gaan waiti koosu dëën kumafa könu ta bisi, hën de toona mandëën go a Gaama Pilati baka. ");
INSERT INTO srmNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nöö a di daka naandë seei Gaama Pilati ku Könu Helodi ko mati, ma a fesi de bi dë felantima. ");
INSERT INTO srmNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nöö hën Pilati kai hii dee Gaan Begima ku dee hedima u Isaëli ku hii dee oto sëmbë ko nëën makandi. ");
INSERT INTO srmNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Hën a taki da de taa: “Wë un tja di sëmbë aki ko a mi taa a du hogi. Un taa a ta tja gaan toobi ko a di köndë. Ma fa mi luku ën ta hakisi ën soni a unu fesi aki, nöö ma si taa a du dee soni un ta konda dë e. Nöö ma si föutu nëën. ");
INSERT INTO srmNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nöö Könu Helodi seei an bi feni föutu nëën tu, biga a toona mandëën ko a u aki baka. An du wan wojo hogi tjika faa musu dëdë e. ");
INSERT INTO srmNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Fëën mbei mi o sitaafu ën nöö, nöö mi o toona puu ën da unu.”  ");
INSERT INTO srmNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wë biga hiniwan jaa a di piizii aki dendu di Gaama bi guwenti u puu wan sëmbë a dunguwosu da dee Isaëli sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma nöö di a taki taa a o puu Masa Jesosi da de, nöö hën hii dee sëmbë tuu fiaa bai taa: “Nönö e, nönö! Kii ën puu dë! Balabasi, hën i musu puu da u.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Wë nöö di Balabasi aki, hën de bi buta a dunguwosu fu wan gaan toobi a bi tja ko a di köndë, bifö a bi kii sëmbë tu.) ");
INSERT INTO srmNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ma Pilati bi kë puu Masa Jesosi. Nöö hën a taa: “Jesosi, hën mi o puu e, biga ma si di föutu di a du!” ");
INSERT INTO srmNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma de ta bai nango nöömö taa: “Kii ën! Pekëën a lakpa pau kii!” ");
INSERT INTO srmNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nöö hën a toona hakisi de möön di u mbei dii pasi taa: “Wë un hogi seei a bi du? Biga ma feni na wan kodo soni nëën fu mi mandëën go kii. Fëën mbei mi o sitaafu ën nöö, nöö mi o puu ën be a go.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma dee sëmbë ko bai möön taanga eti taa de musu pekëën a lakpa pau kii. De ta bai ta kai olo teee kamian ta mbei wajawaja. Nöö Pilati an ko saanfa u du möön. ");
INSERT INTO srmNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nöö hën mbei a taki da de taa: “Söö. Wë ma sabi möön e. Fa un kë du nöö un du.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nöö hën a puu di sëmbë di de kë da de. Di sëmbë dë, hën de bi buta a dunguwosu fu di a bi kii sëmbë nöö a bi tja gaan toobi ko a di köndë tu. Ma di hën de kë, hën a puu ën a dunguwosu. Ma Masa Jesosi, hën a disa da de fu de du ku ën kumafa de kë. ");
INSERT INTO srmNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nöö hën de ta tja Masa Jesosi nango tee wan pisi hën de miti ku wan sëmbë de ta kai Simon fu di köndë de ta kai Sileni. A bi kumutu a kamian ta ko a ganda, hën de miti ku ën a pasi. Nöö hën de kisi ën panjan taa a musu tja di lakpa pau u Masa Jesosi dëën. Hën de hopo ën buta nëën baka, hën a ta tjëën dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wë nöö di juu dë, nöö sömëni sëmbë ta waka nango a Masa Jesosi baka, womi ku mujëë tuu. Nöö tjali fëën kisi de tee dee mujëë ta bai ta këë. ");
INSERT INTO srmNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nöö hën Masa Jesosi bia luku de, hën a taki da de taa: “Un dee mujëë mii u Jelusalen aki, wan këë u mi hedi e. Ma un musu këë fuunu seei ku dee mii fuunu hedi. ");
INSERT INTO srmNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Biga abiti möön nöö wan sitaafu ten o ko, nöö sëmbë o dë ta taki taa: ‘Ee maingë, di ten di u dë aki, a bunu da dee mujëë dee an pai mii wan daka, ku dee mujëë mii dee na a’ miii a maun.’ ");
INSERT INTO srmNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Biga a di lö ten dë, nöö hia sëmbë o dë ta bai taa: ‘Dee gaan kuun aki eee, gaantangi, un kai ko a u liba ooo.’ Nöö de o taki da dee piki kuun taa: ‘Gaantangi, un kai ko tapa u, be soni fuu an dë a di goonliba aki möön. Biga di ten aki hogi tumusi.’ ");
INSERT INTO srmNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Wë biga ee ku di kuwakuwa pau de ta du sö, nöö di dëëdëë pau wë?” Sö Masa Jesosi taki da dee mujëë. ");
INSERT INTO srmNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wë nöö fa de ta tja Masa Jesosi nango dë, nöö de ta tja tu oto sëmbë tu fu de go kii ku ën makandi. De tu sëmbë naandë bi du gaan hogi a di köndë. ");
INSERT INTO srmNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nöö hën de nango te de ko dou a di kamian de ta kai Hedibonu. Nöö hën de peka Masa Jesosi ku de tu hogi sëmbë dë a lakpa pau, nöö hën de hopo de taanpu a pë, wan dë a Masa Jesosi letimaun së, di otowan dë nëën töötömaun së, Masa Jesosi dë a de mindi. ");
INSERT INTO srmNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nöö hën Masa Jesosi taa: “Taata o, na hoi dee sëmbë ta kii mi aki a bëë e, biga de an saandi de ta du.” Nöö hën dee sodati tuwë lötu paati dee koosu fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nöö sömëni sëmbë bi sai dë taanputaanpu ta luku dee soni ta pasa. Dee hedima u di köndë seei dë a dendu tu, nöö de ta wisiwasi ën ta mbei ën fa. De taa: “A bi heepi oto sëmbë ta du de gaangaan bunu, nöö be a heepi ën seei tu, ee hën da di Keesitu, di Paamusi Könu.” Sö dee hedima ta taki. ");
INSERT INTO srmNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nöö söseei dee sodati ta mbei ën fa tu. De tja gandji win u ko dëën fa a bebe. ");
INSERT INTO srmNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Hën de taa: “Ee i da di könu u dee Dju sëmbë tuu, nöö i heepi i seei be i kumutu naandë.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nöö de sikifi wan soni peka a di lakpa pau hedi taa: DISI DA DI KÖNU U DEE DJU SËMBË. ");
INSERT INTO srmNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nöö söseei wan u dee sëmbë di de peka ku Masa Jesosi a di lakpa pau naandë ta kosi ën tu. A taki dëën taa: “Womi, ee i dë di Paamusi Könu di Masa Gadu manda da u aki, nöö i puu i seei a di lakpa pau e, nöö i ko puu u tu.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Ma di otowan gandji dëën taa: “Womi, fa i si mi ku i ta kisi di sitaafu aki, u ta kisi ën leti kumafa a fiti, biga u bi du hogi tumusi. Ma di sëmbë aki sö, hën an bi du hogi möönsö. Nöö fa i ta kosi ën dë, ja ta fëëë Gadu nö? Ja sabi taa u tuu o dëdë aki nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nöö hën a bia fan ku Masa Jesosi taa: “Jesosi o, gaantangi mi begi i, te i tei di Könu Tii fii nöö i mëni mi e.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nöö hën Masa Jesosi piki ën taa: “Antoobi. Mi taki da i gbelin taa tide seei mi ku i o dë makandi a di waiti kamian u Masa Gadu de ta kai Paladëisi.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hën de sai dë te tuwalufu juu sonuati, nöö hën kamian ko dungu tee a dë kuma ndeti. Nöö hën a tan sö tee di dii juu sapate, ");
INSERT INTO srmNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","sonu seei an jabi möönsö. Nöö hën di gaan koosu di bi tapa di Kaba Hebi Kamian u di Wosu u Masa Gadu tënë leti mindi puu tu pisi. ");
INSERT INTO srmNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nöö hën Masa Jesosi bai ku taanga töngö taa: “Taata o, gaantangi, tei di Akaa u mi e. Mi disëën da i.” Nöö fa a fan dë, hën böö fëën koti. A dëdë pii. ");
INSERT INTO srmNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nöö di di oposii si fa hii soni pasa, nöö a bigi dëën te na soni. Hën a bia gafa Gadu taa: “Aai oo dee sëmbë, di sëmbë i si aki sö, a bi dë wan gaan bumbuu sëmbë a Gadu wojo e.” ");
INSERT INTO srmNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nöö di dee hia sëmbë dee bi ko naandë si fa hii soni pasa, hën de naki maun a de hati taa: “Ee, aai maingë, di soni pasa aki, a hogi. A tjali da u.” Nöö hën de paaja go a wosu. ");
INSERT INTO srmNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nöö dee mati u Masa Jesosi ku dee mujëë dee bi kumutu a Galilea ko ku ën a Judea dë, de bi dë taanputaanpu te a wan së ala ta luku fa hii soni ta pasa ku ën. ");
INSERT INTO srmNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nöö wan gaan kuutuma u dee Isaëli sëmbë bi dë de ta kai Josëfu, nöö a di köndë de kai Alimatea a ta libi. Nöö a dë wan bumbuu sëmbë, hii sëmbë ta lesipeki ën. Nöö a dë wan sëmbë ta luku fu Masa Gadu musu ko hopo di Tii fëën a di köndë. Nöö di ten de ta kuutu u kii Masa Jesosi dë, nöö hën an bi dë wan ku de a dee soni de ta taki dë. ");
INSERT INTO srmNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nöö di di womi aki si taa Masa Jesosi dëdë, nöö hën a go a Pilati go begi ën faa dëën di dëdë go bei. ");
INSERT INTO srmNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nöö hën a dëën pasi. Nöö hën a go puu Masa Jesosi a di lakpa pau, hën a lolu ën ku wan gaan limbo koosu. Nöö a bi abi wan njunjun baaku de bi diki a sitonu dendu u de bei sëmbë, ma de an bi bei sëmbë nëën wan daka eti. Nöö naandë a tja Masa Jesosi go bei. ");
INSERT INTO srmNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wë nöö a di daka naandë de ta seeka soni u de njan di saba, biga a di sapate juu dë di saba o kai a goon. ");
INSERT INTO srmNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nöö dee mujëë u Galilea dee bi ko ku Masa Jesosi naandë, hën de go ku Josëfu fu de musu luku unsë de buta di dëdë sinkii u Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nöö hën di de si kaa, nöö hën de bia toona. Nöö hën de go seeka sumëë suti soni, u de tja go lobi a di dëdë sinkii u Masa Jesosi ˻kumafa di guwenti bi dë te wan sëmbë dëdë˼. Ma di de si taa saba kai a goon kaa, nöö hën de disa hii soni, hën de go dë pii ta böö, kumafa di wëti u dee Isaëli sëmbë bi dë. ");
INSERT INTO srmNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nöö hën a di sonde mamate biten, hën dee mujëë hopo. Hën de tei dee soni de bi seeka buta naandë fu de tja go sakwi a di dëdë sinkii u Masa Jesosi, nöö hën de go a di kamian ka de bi bei Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma nöö di de go dou, hën de si di baaku jabijabi hooo. Di gaan sitonu de bi tapa di geebi bi logoda kumutu a di baaku buka. ");
INSERT INTO srmNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nöö hën de denda go a di baaku dendu, ma nöö de an si di dëdë sinkii u Masa Jesosi naandë möön. ");
INSERT INTO srmNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hën de bai: “Huun? Wë andi pasa maingë? Unsë de tjëën go?” Nöö fa de ta fan dë, te u de kë mëni, hën de si tu womi sëmbë dë taanputaanpu leti a de bandja naandë. De dë ku gaan limbo koosu a de sinkii ta koti faja te na soni. ");
INSERT INTO srmNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nöö hën de panta tee, de saka kai ku kini tapa de fesi a goon. Nöö hën dee basia taki da de taa: “Dee mujëë, andi mbei un ko suku wan libisëmbë a geebi dendu? ");
INSERT INTO srmNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Di sëmbë un ta suku an dë aki e. A hopo kumutu a dëdë. Wë nöö un pakisei dee oto a bi taki da unu, di unu ku ën bi dë a Galilea ala. ");
INSERT INTO srmNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Biga a bi taki da unu taa de o tja di Sëmbë di ko dë Libisëmbë Mii go sei da dee hogihati sëmbë. Nöö de o pekëën a lakpa pau kii, ma nöö a di u dii daka fëën a o toona weki hopo baka. Na sö a bi taki nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wë nöö di dee basia taki sö kaa, hën dee mujëë ko mëni fa Masa Jesosi bi taki awaa. Hën de taa: “Aai, sö a bi taki da u tuu.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nöö hën de bia toona go. Hën de nango tee a de ëlufu bakama u Masa Jesosi ku dee oto sëmbë fëën, nöö hën de konda di soni da de taa sö wan soni de go si. ");
INSERT INTO srmNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wë nöö dee mujëë dee konda di soni naandë, wan u de de ta kai Malia Magidala, di otowan da Johana, di otowan möön da Malia di mama u Jakobosi, ku wanlö oto mujëë möön dee bi dë ku de naandë. De wë go konda di buka da dee tjabukama u Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ma dee sëmbë an kë biibi, biga de feni taa dee soni de ta taki dë, na bumbuu soni. Sösö soni de ta taki. ");
INSERT INTO srmNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma nöö hën Petuisi hopo, hën a kule go a di geebi. Nöö di a go dou, hën a bendi luku a di baaku dendu, hën a si dee koosu dee bi dë a Masa Jesosi sinkii leti dë. Nöö hën a bia toona go a wosu. Di soni foombo ën tee a taa: “Ee maingë, andi seei miti u aki? Andi pasa?” ");
INSERT INTO srmNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wë nöö a di daka dë seei, hën tu u dee sëmbë bi ta waka a Masa Jesosi baka kumutu a Jelusalen dë nango a wan köndë de kai Emausu. An longi ku Jelusalen tumusi, ma a sa dë kuma wan teni-a-fö kilomëti sö fu waka. ");
INSERT INTO srmNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nöö di de nango, hën de ta da oto u de a pasi ta taki dee soni dee bi pasa ku Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nöö hën de nango te wan pisi, nöö hën de si wan sëmbë ko ta waka ku de a di pasi. De si di sëmbë, ma de an sabi taa Masa Jesosi hën di dë. ");
INSERT INTO srmNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","A bi dë kuma wojo u de bi tapa u de an si ën sabi. ");
INSERT INTO srmNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Te wan pisi, hën di sëmbë hakisi de taa: “Wë, dee sëmbë, un oto un ta da a pasi taangataanga sö? Andi du unu?” Hën de taanpu pii ku tjali. ");
INSERT INTO srmNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nöö hën wan u de de ta kai Kelopasi mbei: “Huun? Wë nöö ja jei di gaan soni di bi pasa a Jelusalen a dee daka aki nö? A sa kë taa wakama i dë mbei ja jei ën nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A taa: “Andi pasa?” De taa: “Ja jei di soni fu di sëmbë de kai Jesosi u Nazalëti nö? A bi dë wan tjabukama u Masa Gadu ta du foombo wooko ta lei sëmbë ku kaakiti leti kuma hën abi di lei. Masa Gadu ku hii sëmbë bi feni ën taa a dë wan gaan hei sëmbë a goonliba. ");
INSERT INTO srmNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma dee Gaan Begima ku dee hedima fuu tjëën go a di Gaama faa kuutu ën, nöö hën wë Gaama piki taa a musu dëdë. Nöö hën de pekëën a lakpa pau kii. ");
INSERT INTO srmNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wë u bi pakisei taa hën sa dë di sëmbë di bi o puu u dee Isaëli sëmbë a dee fuka fuu, ma nöö tide mbei dii daka kaa di de kii ën. ");
INSERT INTO srmNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Ma na di dë nöö, ma tide wanlö mujëë sëmbë fuu ko taki wan foondo soni da u. De taa a di mamate biten, de go a di baaku ka de bi bei ën. ");
INSERT INTO srmNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ma nöö di de go luku, de an si di dëdë sinkii fëën naandë möön. Hën de toona ko taki da u taa de si basia u Masa Gadu Köndë naandë. Nöö dee basia taki da de taa Jesosi dë ku libi, a weki baka. ");
INSERT INTO srmNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nöö wantu sëmbë fuu kule go a di geebi go luku tu. Hën de go si di baaku hooo leti kumafa dee mujëë bi taki da de, ma de an si Jesosi.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nöö hën Masa Jesosi taki da de taa: “Ma dee sëmbë aki, unfa un don gaanfa sö? Andi mbei a taanga da unu sö fuun biibi dee soni dee tjabukama u Masa Gadu bi taki? Biga hii dee soni aki tuu de bi taki a fesi kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nöö un bi musu sabi taa di Paamusi Könu bi musu fu pena sö bifö a sa go sindo a di könubangi fëën.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nöö hën a seti taki a dee soni liba, dee Mosesi ku dee oto tjabukama u Masa Gadu bi sikifi buta dë. A mbei de ko fusutan hii dee soni fëën seei tuu dee bi dë sikifisikifi a Gadu Buku. ");
INSERT INTO srmNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nöö hën de ta fan di fan nango tefa de ko zuntu ku di köndë ka dee sëmbë nango, nöö hën Masa Jesosi mbei kuma a kë pasa go fëën. ");
INSERT INTO srmNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hën dee sëmbë begi ën taa: “Mati o, gaantangi, tan ku u aki. Na pasa go, biga a ko lati kaa. Ndeti.” Nöö hën a piki hën a waka go ku de a wosu. ");
INSERT INTO srmNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nöö hën de ko sindo a tafa fu de njan. Nöö hën Masa Jesosi tei di bëëë, hën a da Masa Gadu tangi te a kaba, nöö hën a booko di bëëë paati da de. ");
INSERT INTO srmNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nöö di juu dë, hën wojo u de ko limbo gbegedee awaa. De ko sabi taa di sëmbë i si de ta si aki, nöö Masa Jesosi wë. Ma te u de kë mëni, nöö de an si ën möön. A go djee. ");
INSERT INTO srmNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nöö hën de taki ku deseei taa: “Hooo, aai baa, luku fa hati fuu bi fii piizii di a ta fan ku u a di pasi ta puu Gadu Buku da u.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nöö di juu dë seei, hën de hopo bia toona go a Jelusalen baka. Nöö naandë de go miti ku dee ëlufu bakama u Masa Jesosi ku dee otowan makandi. ");
INSERT INTO srmNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nöö di de dou, hën dee sëmbë taki da de taa: “Dee sëmbë aki o, Masa Jesosi hopo kumutu a dëdë tuu, biga Simon seei si ën.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nöö hën dee sëmbë seei toona konda hii soni da de wante. De seti ku dee soni bi pasa ku de a pasi, di de nango a Emausu tefa de dou a wosu. Hën de toona konda fa de go sindo u njan, ku di fa Masa Jesosi booko di bëëë paati da de nöö hën wojo u de ko limbo fu de sabi taa hën di dë. ");
INSERT INTO srmNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ma nöö dë an kaba u fan seei, nöö te u de kë si nöö Masa Jesosi dë taanputaanpu a de mindi dë piii. Nöö hën a da de odi, a taa: “Dee sëmbë, Masa Gadu musu dë ku unu ta da unu böö e.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma nöö fa de si ën dë, nöö de panta seei. De fëëë biga de mëni taa jooka de ta si dë. ");
INSERT INTO srmNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nöö hën a hakisi de taa: “Wë andi du unu un ta panta gaanfa sö? Andi mbei wan kë biibi? ");
INSERT INTO srmNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Biga luku mi maun ku mi futu aki ˻ka de bi peka mi˼. Mi seepi wë disi e. Nöö un ko panjan mi fii luku. Biga jooka an ta abi mbeti, an ta a’ bonu kumafa un si mi abi aki.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wë nöö di a taki sö da de kaa, nöö hën a lei de hën maun ku hën futu. ");
INSERT INTO srmNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nöö di soni bigi da de te na soni. A da de piizii te kuma de an sa biibi ën. Nöö hën a hakisi de taa: “Wan abi soni u njan aki nö?” ");
INSERT INTO srmNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hën de taki aai. Nöö hën de tei wan pisi fisi jasajasa hën de dëën. ");
INSERT INTO srmNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nöö hën a tei ën njan leti a de wojo dë, be de si. ");
INSERT INTO srmNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nöö hën a taki da de taa: “Wë hii dee soni aki tuu mi bi taki da unu di ten mi ku unu bi dë e, taa sö dee soni o pasa ku mi leti kumafa de dë sikifisikifi a dee buku u Mosesi ku dee tjabukama, ku di Kanda Buku.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nöö hën a mbei de wojo ko limbo fu de musu fusutan di Buku u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A taki da de taa: “Sö nöö a dë a di Buku e, taa di Paamusi Könu musu pena te a dëdë, ma a di u dii daka fëën a o weki hopo baka a dëdë. ");
INSERT INTO srmNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nöö di Buku taki tu taa de musu konda soni fëën da hii sëmbë, be de bia de libi ko ta waka nëën baka, be Gadu an hoi dee hogilibi u de a bëë möön. Nöö a Jelusalen fosu de musu seti konda di Buka, nöö de musu kondëën da hii pei nasiön sëmbë u goonliba. Sö a dë sikifisikifi a di Buku kaa. ");
INSERT INTO srmNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Wë nöö unu wë da dee sëmbë dee musu kondëën e. Biga unu da dee kotoigima dee si hii dee soni pasa aki tuu. ");
INSERT INTO srmNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma nöö fa mi ta da unu di wooko aki, nöö un musu luku te di kaakiti di mi Tata bi paamusi unu ko ufö. Biga mi o mandëën ko da unu. A Jelusalen aki un musu dë ta luku ën e, fu te Gadu mandëën ko a unu liba.” ");
INSERT INTO srmNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nöö a baka u di dë, nöö hën de ta waka nango te de ko zuntu ku di köndë de kai Betania. Nöö hën a hopo maun a de liba hën a begi da de. ");
INSERT INTO srmNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nöö an kaba seei, hën Masa Gadu tei ën tja go a liba. ");
INSERT INTO srmNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nöö hën de fika dë ta wai ku ën ta gafëën te wan pisi, nöö hën de bia toona go u de a Jelusalen baka ku gaan wai. ");
INSERT INTO srmNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nöö hën de go sai dë a di Wosu u Masa Gadu ta gafa Gadu ta dëën tangi nöömö.");
INSERT INTO srmNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","A dë sö taa bifö hii soni u mundu bi seti, nöö di Sëmbë de ta kai di Wöutu u Gadu bi dë gaanduwe kaa. Nöö di Sëmbë dë ku Gadu bi dë makandi. Hën seei wë bi da Gadu e. ");
INSERT INTO srmNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hën mbei hii dee soni dee dë a mundu tuu. Biga na wan soni seei dë di ko fëën seei, söndö hën mbei ën. ");
INSERT INTO srmNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hën abi libi, nöö te wan sëmbë i feni libi nëën kaa, nöö i kumutu a dungu ko a limbo. Biga hënseei da di limbo. ");
INSERT INTO srmNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nöö di limbo dë ta sëndë seei a di dungu. Hii fa i si di dungu ta mbei möiti u tapëën, ma an sa tapëën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Söö. Wë u dë te wan pisi, hën wë Masa Gadu manda wan womi de kai Johanisi ko, ");
INSERT INTO srmNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","faa konda soni a fesi u di Limbo di o ko abiti möön. Nöö fa a o konda soni fëën dë, a o kondëën fu hii sëmbë musu jei, be de biibi dee soni a o taki. ");
INSERT INTO srmNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma nöö di Johanisi dë, nëën da di Limbo eti e, ma ko a ko nöö faa konda dee soni dee a sabi u di Sëmbë di da di Limbo. ");
INSERT INTO srmNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Biga di Sëmbë di o ko dë, hën da di tuutuu Limbo di sa limbo hiniwan sëmbë wojo. Nöö abiti möön nöö a o ko a lanti wajaa u si. ");
INSERT INTO srmNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nöö di Sëmbë di u ta konda soni fëën aki, nöö a ko a di goonliba aki tuu e, di goonliba di hënseei bi mbei. Ma dee sëmbë bi dë a di ten dë, de an bi sabi ambë dëën. ");
INSERT INTO srmNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dee Dju sëmbë dee bi musu dë sëmbë fëën seei an tei ën u soni. ");
INSERT INTO srmNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma tökuseei sëmbë bi dë dee bi tei ën u soni, hën de ko biibi nëën liba. Nöö hiniwan sëmbë di tei ën sö kaa, nöö sö wan sëmbë a da i di leti fii ko miii u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ma na kumafa de ta pali miii a libisëmbë fasi e. Nönö. Ma fu di Gadu hën o wooko sö a i, nöö hën mbei joo ko miii fëën. ");
INSERT INTO srmNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nöö di Sëmbë u ta konda soni fëën aki di de ta kai di Wöutu u Gadu dë, a ko wan libisëmbë tuu e, nöö hën a ko libi a u mindi fu wan pisiten. Nöö u seei bi si di waiti fëën di a abi. Nöö di waiti u si nëën naandë, a dë di waiti di di wan kodo womi mii u Masa Gaangadu tö nöö sa abi. Biga fa a libi a u mindi aki, nöö nëën u si fa Gadu abi bunuhati u libisëmbë tjika. Nöö nëën u si tu kumafa a sabi hii soni gbelingbelin tjika, ˻leti kumafa a dë a Gadu wojo˼. ");
INSERT INTO srmNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nöö kumafa u taki dë, Johanisi hën bi ta konda soni fëën. Nöö hën di a si ën, hën a bai taa: “Söö. Un si di Sëmbë dë nö? Hën wë mi bi ta konda da unu taa o ko a mi baka di hebi gaanfa möön mi. Mi, djunsudjunsu aki ufö de pali mi, ma hën a bi dë gaanduwe kaa a mundu. Nöö hën wë i si di dë e!” ");
INSERT INTO srmNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nöö di Sëmbë di i si Johanisi taki dë, nöö u seei ko sabi ën tu e, dee sëmbë. ˻Hën da Masa Jesosi Keesitu.˼ Nöö fa di bunuhati fasi u Gadu dë nëën tjika dë, nöö u tuu ta feni sömëni bunu nëën baka na baka te a hia. ");
INSERT INTO srmNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Biga a Mosesi Gadu bi manda dee wëti ko da u fuu hoi. Ma a Jesosi Keesitu a mbei u ko sabi di bunuhati fasi fëën di a abi. Hën a mbei u ko sabi soni gbelingbelin tu, ˻leti kumafa a dë a Gadu wojo. Sö wanlö gaangaan bunu u feni a Masa Jesosi e.˼ ");
INSERT INTO srmNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dee sëmbë, fa Masa Gadu sai dë, na wan daka seei libisëmbë si ën ku wojo möönsö e. Ma di wan kodo Womi Mii fëën dë, di hën ku ën dë wan makandi te wata an sa pasa a de mindi, hën mbei u ko sabi ën awaa. ");
INSERT INTO srmNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wë nöö di juu Johanisi ko dë, nöö dee gaan hedima u Dju bi ta dë a di köndë de ta kai Jelusalen. Nöö hën dee hedima dë manda wanlö begima u Dju ku wanlö oto sëmbë ta wooko ku de makandi a di Gaan Wosu u Masa Gaangadu a Jelusalen dë, u de go hakisi Johanisi ee ambë dëën. ");
INSERT INTO srmNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nöö hën dee sëmbë dë nango tefa de go dou a Johanisi, hën de hakisi ën ee hën da di Keesitu, di Heepima di Gadu bi paamusi taa a o manda ko a goonliba. Nöö Johanisi an ganjan de. A piki de gbelin taa: “Nönö, na mi da di sëmbë dë e.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nöö hën de toona hakisi ën möön taa: “Wë a sa kë taa i da Elia di tjabukama u Gadu, hën weki toona ko nö?” Hën a piki taa: “Nönö, nëën disi e.” Hën de taa: “Wë di oto Tjabukama di Gadu bi o manda ko wë, hën da i nö?” Hën a toona piki de möön taa: “Nönö, nëën da mi e.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hën de taa: “Wë nöö ambë seei da i? Taki da u bumbuu, fuu sa toona go piki dee sëmbë dee manda u ko a i aki. Andi i ta taki fii seei?” ");
INSERT INTO srmNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nöö hën a taa: “Wan bi jei fa di tjabukama u Gadu de kai Jesaaja bi sikifi buta a di Buku u Gadu nö? A taa: U ta jei wan töngö kuma wan basia ta bai a di sabana taa, ‘Un seeka di pasi oo, be a ko dë tololoo da Masa! ˻Un seeka di libi fuunu buta a tatai liba!˼’ Wë di sëmbë di Jesaaja bi taki abi di töngö dë, nöö hën wë disi e. Awaa di soni ta pasa kumafa Jesaaja bi taki.” Sö Johanisi piki dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nöö fa de ko ta hakisi Johanisi dee soni dë, nöö wanlö sëmbë u di Dju keiki paatëi de kai Falisei bi dë a dendu tu. ");
INSERT INTO srmNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nöö hën de toona hakisi ën taa: “Wë ja dë di Keesitu. Ja dë Elia. Ja dë di oto Tjabukama tu. Nöö andi mbei i ta dopu sëmbë u du?” Sö de hakisi ën. ");
INSERT INTO srmNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Hën a taa: “Wë nönö, fa mi ta dopu sëmbë aki nöö an bigi sö e. Biga ku wata nöö mi ta dopu de. Ma wan sëmbë dë a unu mindi di wan sabi, nöö hën o du wan möön gaan wooko. ");
INSERT INTO srmNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hën wë mi ta taki da unu taa mi ta seeka di pasi da. Nöö fa a sai dë, a hei teee ma hei tjika fu mi sa dë futuboi fëën seei. Na di susu fëën seei mi sa lusu puu nëën futu.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nöö di kamian ka de ko ta fini Johanisi dee soni dë, a dë zuntu ku di köndë de kai Betania, a di oto së banda u di lio de kai Joodan Lio. Ala wë Johanisi ta dopu dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nöö di dobooko fëën, nöö hën Johanisi si Masa Jesosi ta waka ta ko nëën. Hën a taa: “Un luku di Sikapu Mii u Gadu dë e. Hën wë Gadu manda faa ko paka fu dee hogi du fu hii libisëmbë ˻kumafa de ta kii sikapu ta paka paima˼. ");
INSERT INTO srmNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nöö hën wë mi bi ta konda da unu taa mi ta seeka di pasi da. Nöö a hebi möön mi e. Biga a bi dë gaanduwe kaa bifö de pali mi. ");
INSERT INTO srmNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“Nöö mi seepi tu, ma bi o sabi ën. Ma nöö fu soni fëën musu ko wajaa a limbo da u dee Isaëli sëmbë aki, hën mbei i si mi ko ta dopu sëmbë a di wata aki.” Sö Johanisi taki u Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nöö un haika bunu fa Johanisi konda fëën e. A taa: “Mi seepi si di Akaa u Masa Gaangadu saka ko kuma wan pomba ko tan a di Sëmbë dë liba e. ");
INSERT INTO srmNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“Nöö ma bi o sabi ën, ma Masa Gadu di manda mi fu mi dopu sëmbë aki, nöö hën bi taki ën da mi a fesi. A taa di sëmbë di mi o si di Akaa fëën saka ko fika nëën liba, nöö hën da di Sëmbë di o dopu sëmbë ku di Akaa u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","“Nöö di soni Gadu taki da mi dë, mi si ën tuu e. Nöö fëën mbei wë mi ta konda da unu gbelingbelin taa di Sëmbë i si dë, hën da di Womi Mii u Masa Gaangadu.” Sö Johanisi taki da de di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Di dobooko möön, hën Johanisi ku tu u dee bakama fëën dë taanputaanpu a di wan seei kamian naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Te wan pisi hën Johanisi si Masa Jesosi ta waka ta pasa, hën a taa: “Un luku di Sikapu Mii u Gadu, hën wë di dë e.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nöö di de tu sëmbë dë jei a taki sö, nöö hën de tei nëën baka wante ta faakëën. ");
INSERT INTO srmNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Te wan pisi hën Masa Jesosi bia luku, hën a si de ta ko nëën baka. Nöö hën a hakisi de taa: “Andi un kë sö baa?” Hën de piki taa: “Wë Labi, wë u kë ko sabi unsë i ta dë.” (“Labi” hën da “Mësitë” a de töngö.) ");
INSERT INTO srmNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Hën a taa: “Wë antoobi. Un ko luku nöö woon si.” Nöö hën wë de go. Nöö a di juu ten de go dë, nöö a bi dë kuma fö juu sapate, hën de fika ku ën dë tefa ndeti. ");
INSERT INTO srmNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wë nöö de tu sëmbë dee go ku Masa Jesosi naandë, wan u de de kai Andiasi, nöö a abi wan baaa fëën de kai Simon. ");
INSERT INTO srmNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nöö hën wë di de kumutu a Masa Jesosi dë, hën Andiasi go nëën baaa Simon wante. Hën a taki dëën taa: “Womi e, womi, u feni di sëmbë baa, di Gadu bi paamusi taa a o manda da u faa ko Könu fuu.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nöö hën a tjëën baaa Simon go a Masa Jesosi. Nöö hën wë di Masa Jesosi si de ko nëën, nöö hën a fan ku Simon taa: “Di mii u Jonasi aki, fa u dë aki de ta kai i Simon. Ma bakaten nöö de o bia ta kai i Kefasi e.” (Nöö Kefasi, hën kë taki “gaan sitonu.” Hën seei da “Petuisi”.) ");
INSERT INTO srmNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nöö di dobooko fëën möön, nöö hën Masa Jesosi kë go a di pisiwata de kai Galilea. Hën a suku wan womi de ta kai Filipi tefa a si ën. Hën a taa: “Womi, mi kë i ko go ku mi e, baa.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nöö di soni mbei a kai Filipi. Biga a dë sëmbë u wan köndë u Galilea de kai Betisaida. Hën da di köndë u Andiasi ku ën baaa Petuisi tu. ");
INSERT INTO srmNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ma nöö ufö de go, nöö hën Filipi seei go a wan womi de kai Nataniëli, hën a fan ku ën taa: “Womi, u feni di sëmbë di Mosesi ku dee fesiten tjabukama bi sikifi soni fëën e. Di sëmbë dë, hën da Jesosi, di Mii u Josëfu u di köndë de kai Nazalëti.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nöö hën Nataniëli hakisi ën taa: “Ma wan bumbuu soni sa kumutu a Nazalëti nö, womi?” Hën a piki ën taa: “Wë ko luku nöö joo si.” Hën de hopo nango a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nöö hën wë di Masa Jesosi si Nataniëli ta waka ta ko nëën, hën a taa: “Un luku wan sëmbë ta ko aki. Bumbuu Isaëli sëmbë e. Biga aan ten seei a ta ganjan sëmbë möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nöö hën Nataniëli hakisi ën taa: “Wë unfa i du sabi mi baa?” Hën a piki ën taa: “Mi bi si i sabi gaanduwe kaa a di ten i bi dë a di figa pau basu, ufö Filipi ko kai i.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nöö di soni bigi da Nataniëli tee, hën a taa: “Ee, aai Mësitë, i da di Mii u Gadu tuu e. I da di Könu fu u dee Isaëli sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nöö hën Masa Jesosi taki dëën taa: “Awa, wë di mi taki sö da i taa mi bi si i a di figa pau basu, hën mbei i biibi sö nö? Wë joo si möön gaan foombo soni möön di dë e. ");
INSERT INTO srmNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Biga mi taki da unu gbelin, taa a a’ wan ten woon si mundu jabi wajaa, nöö dee basia u Masa Gadu Köndë o kumutu a Mi di ko Libisëmbë Mii aki ta subi nango a Gadu ta saka ta ko.” Sö Masa Jesosi fan ku ën. ");
INSERT INTO srmNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nöö baka tu daka u dee soni u taki dë, nöö hën de hoi wan tööu wosu a di köndë u Galilea de kai Kana, nöö di mama u Masa Jesosi ko a di piizii. ");
INSERT INTO srmNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nöö de bi kai Masa Jesosi ku u dee bakama fëën tu, fuu ko a di piizii. ");
INSERT INTO srmNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nöö hën wë u dë te wan pisi, hën di win u ta bebe ko kaba. Hën Masa Jesosi mama go nëën go taki dëën taa: “Wë Baa o, gaan soni, di win u dee sëmbë kaba.” ");
INSERT INTO srmNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Hën Masa Jesosi piki ën taa: “Faandi mbei i ko a mi? Juu u mi an kisi eti e.” ");
INSERT INTO srmNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma nöö hën di mama bia fan ku dee futuboi dee ta wooko a di wosu taa: “Haika e. Di soni di i si a o taki da unu, nöö hën fuun du e.” ");
INSERT INTO srmNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nöö de bi abi sikisi gaan sitonu djogu naandë. A dee djogu dë de bi guwenti u lai wata u wasi kumafa di wëti u dee Dju bi dë, nöö hiniwan u dee djogu ta hoi kuma wan höndö liti wata sö. ");
INSERT INTO srmNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nöö hën Masa Jesosi fan ku dee futuboi taa be de go ba wata lai a dee djogu naandë tuu. Nöö hën de go ta tja di wata ta tuwë a dee sikisi gaan gindi djogu dë te de fuu pöö. ");
INSERT INTO srmNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hën a taa: “Un go ba so u di wata tja go da di hedima u di piizii be a tesi ën luku.” Nöö hën de ba di wata tja go da di hedima, ");
INSERT INTO srmNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","nöö hën di hedima tesi ën te a kaba. Ma nöö bifö de bi tjëën go dëën, nöö di sösö wata dë bi bia ko win kaa. Nöö fa di hedima tesi ën dë, an sabi naasë di win kumutu. Dee futuboi wanwan nöö sabi, biga de bi tja di wata lai a dee djogu. Nöö hën di hedima u di piizii kai di tööuma a së. ");
INSERT INTO srmNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","A taa: “Womi, unfa di soni waka? Biga hii sëmbë lobi u da di suti win a fesi, nöö te dee sëmbë bebe te a tjika de ufö de o ta da de di möön sösö wan awaa. Ma nöö i ja du sö. I hoi di suti win a baka hën i buta de bebe di sösö wan fosu, ufö i ko ta da di möön suti wan awaa. Mi kë sabi faandi mbei.” ");
INSERT INTO srmNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wë nöö fa di soni pasa dë a Kana a di pisiwata u Galilea naandë, nöö hën da di fosu foondo wooko Masa Jesosi du e. Ku ën a mbei sëmbë si di Gadu fasi fëën di a abi, nöö hën u dee bakama fëën ko biibi möön taanga nëën liba. ");
INSERT INTO srmNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nöö hën a baka u di dë, hën Masa Jesosi ku ën mama ku dee baaa fëën ku u dee bakama fëën tuu, hën u go a di köndë de kai Kapenaumi, hën u tan ala wantu daka. ");
INSERT INTO srmNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nöö di ten dë, di gaan daka fuu dee Dju de kai Pasika, juu fëën ko zuntu faa kai. Nöö hën Masa Jesosi tei pasi, nöö hën a go a Jelusalen. ");
INSERT INTO srmNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nöö hën a nango tefa a go dou a di gadii u di Gaan Wosu u Masa Gadu. Nöö hën a luku, hën a si hia sëmbë sai dë ta sei kau, ta sei sikapu, ta sei pomba. So sëmbë dë sindosindo ta tooka möni da dee sëmbë dee ta ko dë. ");
INSERT INTO srmNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nöö di a si dee soni de ta du a di Wosu, hën a tei wanlö tatai mbei wipi tefa a kaba. Nöö hën a buta ku dee sëmbë ta jaka de ku dee kau u de ku dee sikapu u de tuu ta puu a di gadii dë. Hën a ta du soni a di kamian teee, ta tombi dee tafa u dee tookamönima ta tuwë djolou a goon ta paaja dee möni fanjaaan a goon dë. ");
INSERT INTO srmNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nöö hën a bai dee sëmbë ta sei pomba dë taa: “Un hopo kumutu aki ku dee soni fuunu dë, biga di wosu u mi Tata aki na wojowojo a dë e!” ");
INSERT INTO srmNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nöö fa a du dë, nöö hën wë u dee bakama fëën ko fusutan wan soni bi dë a Gadu Buku sikifisikifi taa: “Di biinga di mi ta biinga da di wosu fii, Gadu, a o njan di kaakiti u mi tuu fiaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wë nöö di soni Masa Jesosi du naandë an kai ku dee hedima u Dju seei. Hën de hakisi ën taa: “Womi, ambë manda i fii du di soni naandë? Un maaka joo da u fuu sabi taa Gadu da i leti u du sö.” ");
INSERT INTO srmNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Hën Masa Jesosi piki de taa: “Un sa booko di Wosu u Masa Gadu aki, nöö baka dii daka mi o toona hopo ën baka.” ");
INSERT INTO srmNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hën de taa: “Höön, föteni-ku-sikisi jaa longi de tei kaa ta mbei di Wosu aki, nöö hën i taa i sa hopo ën a dii daka dendu nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma nöö fa Masa Jesosi ta fan naandë, na di wosu dë a ta mëni. Ma a ta mëni hënseei sinkii. ˻Biga hën da di Wosu u Gadu kaa ka Gadu ta dë. Nöö Masa Jesosi sabi taa a bakaten nöö de o kii ën, ma a di u dii daka fëën nöö a o toona hopo baka.˼ ");
INSERT INTO srmNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nöö hën u dë te a bakaten di a hopo baka a dëdë tuu, bifö u dee bakama fëën ko mëni taa sö wan soni a bi taki. Nöö hën u ko biibi hii dee soni dee dë sikifisikifi a Gadu Buku ku dee soni dee Masa Jesosi seei bi fan ku u tuu awaa. ");
INSERT INTO srmNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wë ma nöö di juu ten dë di Masa Jesosi dë a Jelusalen faa njan di Pasika dë, nöö a du sömëni foombofoombo soni e, nöö fëën mbei sömëni sëmbë ko biibi nëën liba taa Gadu hën mandëën. ");
INSERT INTO srmNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma hii fa de biibi ën dë seei, ma Masa Jesosi an ta futoou de möönsö. An hopo hënseei tuwë da de, biga a sabi libisëmbë fasi fa de dë. ");
INSERT INTO srmNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Fa a sai dë, an bi a’ fanöudu u sëmbë musu konda soni u libisëmbë dëën, biga a sabi gbelin hii soni di dë a de hati kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nöö di juu dë, wan Faliseima bi dë de ta kai Nikodemusi, nöö a bi dë wan u dee kuutuma u dee Dju. ");
INSERT INTO srmNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nöö hën wë a ko a Masa Jesosi a wan ndeti gbolo. A kai ën: “Mësitë o.” Hën a piki. A taa: “Wë u sabi taa i da wan leima di Gadu seei manda ko. Biga na wan sëmbë sa du dee gaan foombo wooko dee i ta du, ee na Gadu dë ku i.” ");
INSERT INTO srmNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nöö hën Masa Jesosi piki ën taa: “˻Wë a bunu di i taki sö, mati. Ma mi o taki wan soni da i,˼ nöö tuutuu soni seei a dë. Mi taki e, ee wan sëmbë i dë, nöö de an toona pai i fii feni wan njunjun libi baka, nöö ja o sa dë a dendu u dee sëmbë Gadu ta tii.” ");
INSERT INTO srmNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nöö hën Nikodemusi hakisi ën taa: “Wë nöö unfa de o du pai wan sëmbë möön di ko gaangaan sëmbë kaa? A o toona go nëën mama bëë dendu, faa pai ën di u tu pasi nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Hën a piki ën taa: “Be mi taki wan soni da i gbelin, mati. Fa de pai i a libisëmbë fasi aki, nöö an tjika eti e. Ma di Akaa u Gadu hën musu toona pai i a wan hii oto fasi baka. A musu da i wan njunjun libi a i akaa ufö joo sa dë a dendu u dee sëmbë Gadu ta tii. ");
INSERT INTO srmNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Biga te de pai i a libisëmbë fasi, nöö i ta feni libi a i sinkii nöö. Ma te di Akaa u Gadu pai i, nöö i ta feni libi a i akaa. ");
INSERT INTO srmNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Nöö fa mi ta fan ku i aki, taa de musu toona pai i baka, nöö an musu dë gaan soni da i sö e. ");
INSERT INTO srmNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Biga na hii soni mbei fii sa fusutëën wantewante. “Luku fa u dë aki, di ventu ta böö nango ka a kë. Fa a ta mbei vuuu dë, di bai fëën nöö i ta jei, ma ja sabi naasë a ta kumutu, ja sabi naasë a nango tu. Wë sö nöö a dë tu ku hii dee sëmbë dee di Akaa u Gadu mbei ko pai baka fu de toona feni di njunjun libi u ta taki aki. ˻Ja o fusutëën, ma joo sabi nöö taa sö a dë.˼” ");
INSERT INTO srmNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma nöö fa Masa Jesosi ta fan dë, di soni toobi Nikodemusi eti. Hën a hakisi taa: “Unfa seei di soni dë o sa waka maingë?” ");
INSERT INTO srmNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hën Masa Jesosi toona piki ën taa: “Wë mati o, fa i dë wan gaan leima u Isaëli aki, nöö hën ja fusutan dee soni u ta taki aki eti ö? ");
INSERT INTO srmNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","“Wë haika e. Mi o taki da i gbelin taa uu sabi andi u ta taki e. Biga dee soni dee u si nöö de wë u ta konda. Ma nöö wan kë piki dee fan fuu. ");
INSERT INTO srmNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wë nöö ee wan kë piki te mi ta konda soni u di goonliba aki da unu, nöö unfa woon du piki te mi ta konda soni u Gadu? ");
INSERT INTO srmNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Biga na wan sëmbë go ka Masa Gadu ta dë wan daka, boiti mi wanwan tö di kumutu nëën ala ko dë Libisëmbë Mii aki. ");
INSERT INTO srmNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Luku di soni di bi pasa a fesiten a di sabana. Gadu manda Mosesi faa mbei wan köpö sindeki hopo buta a liba, nöö hiniwan sëmbë di luku di sindeki dë ku biibi, nöö a ko bunu kaa. Wë nöö söseei de o hopo Mi di ko dë Libisëmbë Mii aki a liba tu e. ");
INSERT INTO srmNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nöö ee wan sëmbë i ta biibi a mi, nöö joo feni libi a Gadu fu teego. ");
INSERT INTO srmNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Wë biga Masa Gadu lobi libisëmbë sö tee a da de di wan kodo Womi Mii fëën di a abi. Nöö ee wan sëmbë i ta biibi a di Mii fëën aki liba, nöö ja o lasi go kaba a sösö möönsö, ma i abi di libi u teego kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Biga fa Masa Gadu manda di Mii fëën ko a goonliba aki, nöö an mandëën ko faa kuutu sëmbë tuwë go da sitaafu e. Ma a mandëën ko faa hai sëmbë puu a didibi basu, be de feni di libi u teego. ");
INSERT INTO srmNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Nöö ee wan sëmbë i ta biibi a di Mii u Gadu aki liba, nöö ja o kisi sitaafu a Gadu e. Ma ee ja kë biibi ën, nöö Gadu kuutu i kaa fii kisi di sitaafu dë. Biga ja kë piki taa di Sëmbë aki, hën da di wan kodo mii u Gadu di a manda ko. ");
INSERT INTO srmNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Nöö di soni aki sö, hën da di soni mbei sö wan sëmbë musu kisi sitaafu. A dë sö taa Gadu manda limbo ko a goonliba u limbo libisëmbë wojo, ma nöö de an këën. Fa de sai dë, de lobi di dungu möön di limbo. Biga de an kë disa di hogilibi u de fu de ko a di së u limbo. ");
INSERT INTO srmNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Biga di sëmbë di ta du hogi, hën ta buuse limbo. An o ko seei ka di limbo sa kai nëën, fu di an kë u sëmbë si dee hogi a ta du. ");
INSERT INTO srmNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","“Ma nöö ee wan sëmbë ta libi leti, nöö hën aan toobi ee di limbo kai nëën. Biga a kë u de si taa Gadu dë ku ën a dee soni a ta du.” Sö Masa Jesosi fan ku Nikodemusi di ndeti dë. ");
INSERT INTO srmNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nöö a baka u di dë, nöö hën Masa Jesosi ku u dee bakama fëën kumutu ˻a Jelusalen dë˼ nöö hën u go a wan oto kamian u Judea, fuu ku ën sa dë u wanwan ufö. Nöö hën u go dë ala te wan pisi, hën sëmbë ta ko a u ala fuu dopu de. ");
INSERT INTO srmNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Wë nöö di juu dë, nöö de an bi buta Johanisi a dunguwosu eti e. Nöö hënseei dë a wan kamian de kai Anon ta dopu sëmbë tu. Nöö di Anon dë, a dë zuntu ku di köndë de kai Salim, nöö naandë bi abi hia wata, hën mbei Johanisi ta dopu sëmbë ala. Nöö sömëni sëmbë ta ko nëën tu faa dopu de. ");
INSERT INTO srmNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Te wan pisi hën dee bakama u Johanisi ku wan oto sëmbë u Dju ko ta fia wan gaan fia a unfa i musu wasi ufö i sa ko limbo a Gadu wojo. ");
INSERT INTO srmNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nöö hën dee bakama u Johanisi ko nëën, hën de taki dëën taa: “Wë Mësitë, ja jei nö? Di sëmbë u bi si ku i a di oto së banda ala, di i bi ta konda soni fëën nöömö dë, a dë leti a wan kamian ala ta dopu sëmbë seei tee a hia. Hii sëmbë nango nëën ala gililili sö ta disa i.” ");
INSERT INTO srmNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nöö hën Johanisi piki de taa: “Un haika e, dee sëmbë. Na wan sëmbë sa feni sö wan hei ee na Gadu hën hei ën sö e. ");
INSERT INTO srmNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nöö wan bi jei fa mi bi fan ku unu kaa nö, taa na mi da di Paamusi Könu, ma Gadu manda mi ko nëën fesi nöö. ");
INSERT INTO srmNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Wë nöö fa di soni un taki ta pasa dë, nöö a dë leti kuma te wan womi o tööu ku wan mujëë, a o abi wan mati fëën ta seeka soni dëën. Nöö te di mati seeka te a kaba kaa, nöö a o go dë fëën pii, ta haika ee unfa soni ta waka. Nöö ee a si taa a ta waka bunu, nöö a o wai seei gaanfa. Na sö nö? Wë nöö di wai di mati u di tööuma ta wai dë, nöö hën da di wai di miseei ta wai aki e. ");
INSERT INTO srmNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Biga di Sëmbë dë hën musu ta hei nango nöömö, ma mi musu ta saka nango möönmöön. ");
INSERT INTO srmNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Biga wë di sëmbë di kumutu a Gadu nöö hën hei möön hii sëmbë. Mi, a goonliba aki de pai mi e. Hën mbei goonliba sëmbë nöö mi dë, nöö te mi ta fan mi ta taki soni nöö kumafa goonliba sëmbë sa fusutan soni. Ma di Sëmbë dë, fa a sai dë, hën a musu hei möön hii sëmbë biga a Masa Gaangadu a kumutu. ");
INSERT INTO srmNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nöö fa a kumutu nëën dë, nöö a ta konda dee soni dee a si ku dee a jei a Gadu ala, ma tökuseei libisëmbë an kë tei dee soni a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","“Ma ee wan sëmbë i ta piki taa dee soni a ta taki dë, de dë tuu, nöö hën da i ta sitampu taa dee soni Gadu seei ta taki, de dë tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Biga di Sëmbë dë, fa i si a sai dë, nöö Gadu wë mandëën e, nöö a ta konda soni leti kumafa Gadu ta dëën. Nöö i si fa Masa Gadu dëën di Akaa fëën dë nö? An dëën hafuhafu e, ma a dëën tuu seei ku telu faa sa ta wooko nëën liba nöömö. ");
INSERT INTO srmNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Di sëmbë i si u ta taki aki sö, nöö Masa Gadu seei Mii a dë e, dee sëmbë. Nöö hën Tata lobi ën tee, nöö hën a buta hii soni nëën maun faa ta tii. ");
INSERT INTO srmNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nöö ee wan sëmbë i ta biibi a di Womi Mii u Gadu i si dë, nöö i abi di libi u teego kaa. Ma ee wan sëmbë ja kë biibi ën, nöö ja o feni di libi dë möönsö, biga di hatiboonu u Gadu dë a i liba kaa.” Sö Johanisi fan ku dee bakama fëën di daka dë te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Wë nöö di juu dë, hën dee Faliseima ko jei taa sëmbë ta ko a Masa Jesosi te a hia faa dopu de. Nöö de ta fika ku ën dë ta ko bakama fëën, teefa dee bakama u Masa Jesosi ko hia möön dee u Johanisi seei. ");
INSERT INTO srmNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ma nöö fa u ta taki aki seei, na Masa Jesosi ta dopu dee sëmbë e, ma u dee bakama fëën, u ta dopu de. ");
INSERT INTO srmNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nöö hën wë di Masa Jesosi ko jei taa sö dee Faliseima ko sabi fëën kaa, nöö hën a kumutu a Judea dë wante faa toona go a Galilea. ");
INSERT INTO srmNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma nöö a musu latja pasa a di pisiwata de kai Samalia ufö a sa go dou. ");
INSERT INTO srmNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nöö hën u nango te u go dou a wan köndë u Samalia de ta kai Sikali. A dë zuntu ku wan pisi goon di di gaan sëmbë fuu de kai Jakopu bi da hën mii Josëfu. ");
INSERT INTO srmNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Naandë Jakopu bi diki wan baaku wata fëën, nöö a sai dë eti. Wë nöö di juu dë, Masa Jesosi ko wei u waka, nöö hën a go sindo a di baaku bandja dë. Nöö a bi dë wan soni u tuwalufu juu sö u didia. ");
INSERT INTO srmNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Te wan pisi nöö hën wan mujëë u di köndë naandë ko u ko ba wata. Hën Masa Jesosi hakisi ën taa: “Mujëë o, mi begi i, da mi wan piki wata mi bebe.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Di juu dë, u dee bakama fëën bi go a di köndë ganda u go bai sondi u njan.) ");
INSERT INTO srmNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nöö hën di mujëë hakisi ën taa: “Wë womi, unfa i sa hakisi mi wata u mi da i fii bebe? Na i da wan Dju nö? Wë mi da wan Samalia mujëë.” (Biga dee Dju ku dee Samalia sëmbë an ta koti.) ");
INSERT INTO srmNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nöö hën Masa Jesosi piki ën taa: “Wë mujëë, ee i bi sabi di bunu di Gadu kë da i, ku ee i bi sabi di Sëmbë ta hakisi fii dëën wata aki, nöö i bi o bia begi ën faa da i kuwakuwa wata fii sa feni libi nëën.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nöö hën di mujëë piki ën taa: “Wë womi, fa i ta fan dë, nöö ja abi na wan wojo sondi naandë fii kisi wata, ufö di baaku aki fundu poi tu. Nöö naasë joo feni di wata dë u da mi? ");
INSERT INTO srmNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Fa i sai dë, i hei möön di gaan sëmbë fuu de kai Jakopu nö? Biga di baaku i si aki, nöö hën wë diki ën da u, nöö hën seepi bi ta bebe di wata fëën, hën ku dee mii fëën ku dee mbeti fëën tuu.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nöö hën Masa Jesosi toona taki taa: “Wë di sëmbë ta bebe di wata aki sö, nöö dëëwata ta toona kisi ën. ");
INSERT INTO srmNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma di sëmbë di o bebe di wata di mi o dëën, nöö hën dëëwata an o kisi möönsö a mundu. Biga di wata di mi o dëën, nöö a o dë nëën dendu kuma wan kiikihedi ta kule wata ta ko nöömö. An o kaba möönsö. Nöö so wan sëmbë abi di libi u teego e.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nöö hën di mujëë taki dëën taa: “Wë womi o, wë mi kë di wata dë e baa, fu dëëwata an musu kisi mi möön. Nöö an o dë u mi ta ko aki ta ko ta ba wata hiniwanten möön.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hën Masa Jesosi taki dëën taa: “Wë antoobi. Go kai i manu be i ku ën ko.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hën di mujëë taa: “Ambë? Mi nö? Ma a’ manu e!” Hën Masa Jesosi piki ën taa: “Söö mujëë, fa i piki naandë, ja ganjan e. Ja a’ manu tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Biga feifi womi i tei tuwë kaa. Nöö di i ku ën sai naandë fa u dë aki, nöö an dë manu fii tu. Hën mbei mi taa i piki bunu.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nöö hën di mujëë taa: “Aai, womi, awaa mi si taa i da wan tjabukama u Gadu tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Wë nöö dee gaan sëmbë fuu bi ta begi Gadu a di kuun aki sö. Ma un dee Dju taa Jelusalen ala da di möön bunu kamian fuu ta begi Gadu. Nöö unfa i ta taki u di soni dë?” ");
INSERT INTO srmNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Hën Masa Jesosi taki dëën taa: “Mujëë, mi o taki wan soni da i aki, nöö i biibi mi e, taa wan ten ta ko, nöö na a di kununu i si aki, na a Jelusalen tu woo go u go begi Gadu di Tata fuu möön. ˻Biga di kamian ka fuu begi ën, nëën o dë di gaan soni möön.˼ ");
INSERT INTO srmNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","“Ma nöö haika e. Fa i si un dee Samalia sëmbë ta begi Gadu aki sö, ma an dë taa sabi un sabi ën ufö un ta begi ën e. Ma nöö u dee Dju uu sabi ën kaa bifö u ta begi ën, biga a u di heepi u Gadu ta kumutu ta paaja go a oto sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Ma mi taki e, di soni dë seei an o dë gaan soni möön tu. Biga wan ten o ko, nöö a dë kaa tu, taa te sëmbë o begi Gadu u Tata, nöö ku hii de akaa de o ta begi ën ta hopo ën në a wan gbelingbelin fasi söndö ganjan. Nöö te i begi ën sö kaa, nöö hën da i ta begi ën a wan leti fasi. Nöö sö wanlö sëmbë Gadu ta suku u ta begi ën e. ");
INSERT INTO srmNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","“Biga fa Gadu sai dë an dë libisëmbë ku sinkii e, ma a dë akaa. Nöö ee wan sëmbë i kë begi ën, nöö ja musu begi ën a wan döösë fasi nöö e, ku ganjan. Nönö. Ma i musu ta hopo ën në ta begi ën a wan tuutuu fasi ku hii i akaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nöö hën di mujëë taa: “Wë i sabi nö? Un boo disa di oto ufö e, baa. Biga di Könu di Gadu bi paamusi u taa a o manda ko, nöö te a ko, nöö a o lei u hii soni möön fini.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nöö hën Masa Jesosi piki ën taa: “Mujëë o, di Sëmbë i taki dë, hën wë i si ta fan ku i aki kaa e.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nöö di juu dë, nöö u dee bakama u Masa Jesosi toona ko nëën. Nöö di u si taa a ta fan ku wan ˻Samalia˼ mujëë nöö a bigi da u seei. Ma tökuseei na wan fuu hakisi ën ee andi a ta taki, ee nasö un oto de ta da naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nöö fa u mbei dë, hën di mujëë tuwë di djogu fëën disa dë, hën a kule go a köndë ganda. Nöö hën a go kai dee sëmbë ala taa: ");
INSERT INTO srmNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Un ko luku wan womi ala, dee sëmbë. A konda hii sondi dee mi bi du tuu da mi. A sa kë hën da di Könu di Gadu bi o manda da u nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nöö fa a fan dë, nöö hën dee sëmbë hopo gililili nango a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nöö di juu dë, u dee bakama bi dë a di baakuwata dë ta begi Masa Jesosi taa: “Mësitë o, wë fii ko njan.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Hën a piki u taa: “Mi abi wan njanjan aki ta njan di wan sabi e, ˻nöö hën ta da mi kaakiti kaa˼.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nöö hën u ta hakisi u seei taa: “Wë a sa kë fa u go ala, nöö hën wan sëmbë tja soni u njan ko dëën aki a njan nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nöö hën Masa Jesosi piki u taa: “Di njanjan u mi, hën da te mi ta du dee soni di Sëmbë manda mi ko aki kë fu mi du, be di wooko fëën go dou. ");
INSERT INTO srmNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","37","“Wan jei fa de taki nö? De taa a fika fö liba nöö dee njanjan u dee goon o lepi u koti. Ma mi taki da unu taa, un hopo wojo luku dee njanjan u dee goon. De lepi tjika u koti kaa. ˻Biga ja ta si dee sëmbë ta ko gidjii ala nö?˼ De lepi kaa e, fuu heepi de feni di libi u teego wantewante aki. U sa hai de tja ko buta a suwa seei. Nöö hën da u dee kotima ta feni u paima kaa. “Nöö aki sö di nöngö ko tuu taa wan sëmbë ta paandi, di otowan ta koti. Nöö te di njanjan u di goon lepi, nöö di sëmbë di bi paandi ku di sëmbë di ta koti tuu ta wai makandi. ");
INSERT INTO srmNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","“Fa mi bi manda unu go dë, dee sëmbë, mi bi manda unu go fuun koti dee soni dee oto sëmbë bi paandi. Dee otowan dë, de bi waka a unu fesi, nöö de bi wooko taanga ta konda di buka, nöö hën un ko a baka aki ko ta feni di wini. Biga awaa ufö dee sëmbë ta piki di buka.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Nöö di juu dë, dee Samalia sëmbë ko dou gidjii dë kaa. Nöö hën de begi Masa Jesosi faa tan ku de naandë. Nöö hën a fika ku de tu daka. Wë nöö fa de bi ko nëën naandë, nöö sömëni u de bi ko biibi nëën kaa, fu di fan di di mujëë bi fan ku de taa, “A konda hii dee soni mi bi du tuu da mi.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma nöö fa Masa Jesosi fika ku de dë, nöö hën sömëni oto sëmbë ko biibi nëën möön, fu dee wöutu u Gadu dee a tei ta lei de hedi. ");
INSERT INTO srmNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nöö hën de piki di mujëë taa: “U bi ta biibi fu di i bi fan ku u, ma nöö fa u dë aki u seepi jesi ko jei dee soni dee a taki. Nöö hën mbei u ko sabi tuutuu taa di Sëmbë i si aki, hën da di Paamusi Könu, di Heepima di Gadu manda ko u heepi hii sëmbë u goonliba.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Wë nöö kumafa u taki dë, Masa Jesosi fika dë tu daka a Samalia ala, nöö hën u kumutu dë. Hën u go dou a Galilea awaa. ");
INSERT INTO srmNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wë nöö Masa Jesosi bi taki taa wan tjabukama an ta feni nëbai nëën seei köndë. ");
INSERT INTO srmNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma nöö ˻di pasi aki˼ di a ko dou a Galilea, nöö dee sëmbë kisi ën seei ku wai. Biga sömëni u de bi dë a Jelusalen ta njan di Pasika piizii, nöö de bi si fa Masa Jesosi bi du sömëni gaan foombofoombo soni ala. Hën wë mbei de wai ku ën gaanfa sö. ");
INSERT INTO srmNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Nöö hën a toona go a Kana ka a bi mbei di wata bia ko win. Nöö di a go dou, hën wan womi kumutu a Kapenaumi ko nëën. Di sëmbë aki, a dë wan lantima ta wooko da di Könu. Nöö di a jei taa sö Masa Jesosi kumutu a Judea ko a Kana dë, nöö hën a go nëën wante go begi ën faa ko kula wan womi mii fëën dëën, biga a siki te a fika piki a dëdë. ");
INSERT INTO srmNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nöö hën Masa Jesosi taki dëën taa: “Söö, wë fa un dë aki, ee na un si foombo wooko, nöö wan o biibi mi möönsö nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma nöö tökuseei hën di womi fan ku ën taa: “Mësitë o, gaantangi mi begi i baa, ko go heepi mi ku di mii u mi bifö a dëdë.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hën Masa Jesosi taki dëën taa: “Wë antoobi. Go fii a wosu e. Di mii fii an o dëdë, a libi kaa.” Nöö fa a fan ku di sëmbë dë, nöö a biibi, nöö hën a go fëën. ");
INSERT INTO srmNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nöö fa a tei pasi nango dë, te wan pisi hën dee futuboi fëën ko miti ën a pasi. Hën de tja buka ko dëën taa di mii libi, a bëtë kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nöö hën a hakisi de taa: “Wë nöö na un juu u di daka di mii ko bëtë?” Hën de taa: “Jeside a di sonuati a di wan juu ten, nöö hën di fëbë an kisi ën möön e.” ");
INSERT INTO srmNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nöö hën di tata kai pakisei diin. Hën a si taa a kai leti a di ten Masa Jesosi bi fan ku ën dë taa di mii libi, an o dëdë. Nöö hën di de ko sabi sö kaa, nöö hën di womi ku hii dee sëmbë fëën wosu dendu tuu fiaa ko biibi a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nöö di soni di i si pasa naandë, hën mbei di u tu gaan foombo wooko di Masa Jesosi du a Kana, nöö a du ën di a kumutu a Judea toona ko a Galilea baka. ");
INSERT INTO srmNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nöö a baka u di dë, hën wan oto piizii u dee Dju o dë. Hën Masa Jesosi tei pasi hën a toona go a Jelusalen. ");
INSERT INTO srmNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Wë nöö di juu dë, wan peti wata bi dë a Jelusalen ganda, zuntu ku di djai dööbuka ka de ta tja dee sikapu ko a di köndë dendu. Di peti naandë sö, dee Dju bi ta kai ën Batesita, nöö de mbei feifi baiko lontu ën. ");
INSERT INTO srmNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nöö a dee baiko naandë sömëni sikima sai dë kandikandi: bookowojoma, sömëni lanlan sëmbë, de tuu sai dë ta luku di ten di wata o seki. ");
INSERT INTO srmNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Biga de taa a ta a’ juu nöö wan basia u Gadu Köndë ta saka ko naandë ko seki di wata, nöö ee wan sëmbë i fosu go nama a di wata, nöö i sa ko bunu nöömö aluwasi un sootu siki i bi abi. ");
INSERT INTO srmNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wë nöö wan womi bi sai naandë, diiteni-ku-aiti jaa longi a siki, an sa hopo waka. ");
INSERT INTO srmNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nöö di Masa Jesosi go si ën kandikandi dë, nöö a sabi taa a bi sai dë longi kaa. Nöö hën a hakisi ën taa: “Wë womi, unfa wë? Ja kë ko bëtë nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hën a piki ën taa: “Wë awa, mi kë bëtë, ma ma abi sëmbë u tja mi go a di wata. Biga te a ta seki, nöö ufö mi penapena go dou nëën nöö wan oto sëmbë bi go a mi fesi gaanduwe kaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nöö hën Masa Jesosi taki dëën taa: “Wë antoobi. Hopo, nöö i tei di kama fii, nöö i waka go fii a wosu.” ");
INSERT INTO srmNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nöö fa i si a taki dë, wantewante hën di womi ko bunu kaa. Hën a tei ën kama hën a go. Ma nöö di soni aki pasa leti a wan saba daka u dee Dju. ");
INSERT INTO srmNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nöö di a nango te wan pisi hën wanlö hedima u Dju ko si taa a ta waka ta tja di kama fëën. Hën de hakisi ën taa: “Womi, unfa i du ta tja di kama fii a di saba daka aki? Ja sabi di wëti taa ja musu wooko a saba ö?” ");
INSERT INTO srmNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hën a piki de taa: “Wë nönö, di sëmbë di kula mi, hën taki da mi taa mi musu hopo tei mi kama nöö mi go a mi wosu.” ");
INSERT INTO srmNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nöö hën de hakisi ën taa: “Ambë da di sëmbë di manda i sö?” ");
INSERT INTO srmNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma nöö di sëmbë an bi sabi Masa Jesosi seei. Biga hia sëmbë bi dë a di kamian, nöö di a kulëën te a kaba, hën a fusi go fëën. ");
INSERT INTO srmNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma nöö te wan pisi hën Masa Jesosi ko si di womi möön a di Wosu u Masa Gadu. Hën a fan ku ën taa: “Womi.” A piki. A taa: “Fa i si i ko bunu aki, nöö i musu kaba ku hogilibi e, ee nasö wan möön gaan soni o miti i.” ");
INSERT INTO srmNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nöö di di womi ko sabi Masa Jesosi, hën wë a go konda wante da dee Dju hedima taa Jesosi hën wë kulëën mbei a ko bunu. ");
INSERT INTO srmNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nöö di dee Dju hedima jei sö kaa, hën de bia buta ku Masa Jesosi taa a ta poi tjina fu di saba. ");
INSERT INTO srmNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nöö hën a piki de taa: “Wë mi tata an ta disa bunu fëën u du fu di a dë saba daka hedi e, nöö hën mbei miseei di Mii fëën aki, më sa disa bunu u du a saba tu.” ");
INSERT INTO srmNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wë nöö fa a piki de dë, nöö an bunu da dee hedima, nöö hën hati u de boonu seei te de ta suku köni u de feni ën kii. Biga na di tjina u di saba nöö a poi, ma a kai Gadu hën eigi tata ta mbei taa hën ku Gadu dë pei. ");
INSERT INTO srmNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nöö hën Masa Jesosi fan ku de, a taa: “Söö. Wë mi o taki wan soni da unu aki, nöö a tuu möön hii soni. Mi taki da unu e, taa fa mi ku mi Tata dë di wan tjika aki, ma sa du na wan soni mi wanwan möönsö söndö ën. Di soni mi si a ta du nöö hën nöö mi seei ta du tu, biga u tuu ta du di wan soni. ");
INSERT INTO srmNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","“Fa mi dë aki, mi Tata lobi mi e, nöö hii dee soni a ta du kaa tuu a ta lei mi. Nöö a o lei mi möön gaan soni eti u mi du möön leki dee un si aki kaa, nöö a o foombo unu seei. ");
INSERT INTO srmNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Biga fa i si mi Tata ta weki dëdë sëmbë toona da de libi, nöö sö nöö mi di Mii fëën aki sa da hiniwan sëmbë di mi kë libi tu. ");
INSERT INTO srmNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Nöö na mi Tata ta kuutu libisëmbë e. Ma hii kuutu tuu a buta a mi maun. ");
INSERT INTO srmNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nöö di soni mbei a du sö, fu hii sëmbë musu sa hei mi di Mii fëën aki leti kumafa de ta hei mi Tata. “Nöö sö e. Ee wan sëmbë an kai di Mii fëën aki gaan soni, nöö söseei an kai mi Tata di manda mi ko aki gaan soni tu. ");
INSERT INTO srmNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nöö tuutuu mi o taki wan oto soni da unu, taa ee wan sëmbë i tei dee fan mi ta fan aki taa tuu nöö i ta biibi a di Sëmbë manda mi ko aki liba, nöö i abi di libi u teego kaa. De an o sa kuutu i tuwë go da di sitaafu u teego, biga i kumutu a di së u dëdë ko a di së u libi. ");
INSERT INTO srmNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Nöö mi taki da unu e, taa wan juu o dou nöö a dë kaa tu, taa dee sëmbë dee an bi feni di libi u Gadu eti o jei di fan u mi di Mii u Gadu aki. Nöö ee de piki mi, nöö de o feni libi. ");
INSERT INTO srmNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Biga leti kumafa Gadu hën abi libi, nöö sö nöö mi di Mii fëën aki abi libi tu. Sö a butëën da mi kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nöö hën a da mi di leti tu fu mi kuutu libisëmbë fu di mi seei ko dë libisëmbë miii. ");
INSERT INTO srmNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Dee soni mi ta fan aki nöö de an musu bigi da unu poi e, dee sëmbë. Biga wan juu o dou, nöö hii dëdë sëmbë tuu o jei mi di Mii u Gadu aki ta kai de u de musu ko a kuutu, nöö de tuu o weki kumutu a geebi toona ko ku libi baka. ");
INSERT INTO srmNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Dee bi libi bunu a Gadu wojo, de o weki fu de libi ku Gadu fu teego. Ma nöö dee bi libi hogi a Gadu wojo, nöö de o toona weki fu de feni di sitaafu u teego. Sö mi o kuutu a de liba e. ");
INSERT INTO srmNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nöö te mi ta kuutu a sëmbë liba, nöö di kuutu u mi ta dë leti. Biga ma ta du na wan kodo soni mi wanwan, ma kumafa mi ta jei a mi Tata nöö sö nöö mi ta kuutu buta. Nöö ma ta du na wan wojo soni tu faa kai ku miseei e, ma mi ta du dee soni dee ta kai ku mi Tata di manda mi ko aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Hën a taa: “Un haika e. Ee mi ta konda soni u miseei da unu kumafa mi dë, nöö wan o kë piki mi e. ");
INSERT INTO srmNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma nöö wan oto sëmbë ta konda soni u mi, hën da mi Tata, nöö a ta kondëën leti kumafa a dë. ");
INSERT INTO srmNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Nöö Johanisi seei tu bi ta konda soni u mi. Unu seei bi manda sëmbë go fini ën u dee soni a bi ta konda, nöö fa i si a piki dë an ganjan unu e. Ma a piki unu leti kumafa a dë. ");
INSERT INTO srmNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Ma nöö fa mi ta fan aki seei, ma an dë taa mi ta langi a dee soni libisëmbë ta taki u mi e. Ma mi taki ën sö nöö fuun musu piki, be un feni libi u teego. ");
INSERT INTO srmNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Biga Johanisi bi dë kuma wan lampu sëndësëndë ta lei sëmbë di pasi, nöö a bi suti da unu fu wan pisiten. Di juu dë un bi kë jei ën seei. ");
INSERT INTO srmNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ma nöö wan oto soni möön dë eti di ta konda u mi, nöö a möön hebi möön dee fan u Johanisi seei. Hën da dee wooko dee mi Tata manda mi ko u mi ta du aki. Biga fa i si mi ta du dee foombo wooko aki, nöö de ta sitampu gbelin taa mi Tata Masa Gadu hën manda mi ko aki tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Nöö fa a manda mi ko aki, hënseei bi ta taki soni u mi tu. Ma kumafa un dë aki, un wan jei fan fëën wan daka. Wan si ën sabi wan daka tu. ");
INSERT INTO srmNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Fa un ta jei dee wöutu fëën dë, de an ta fika a unu hati möönsö. Biga wan kë piki mi, di Sëmbë di a manda ko da unu aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hën a taki da de möön taa, “Wan oto soni dë möön di ta konda soni u mi, hën da di Buku u Gadu. Nöö un ta hulu di Buku dë ta bia nango ta ko kodo, fu di un sabi taa nëën un sa feni di libi u teego. ˻Wë nöö sö a dë tuu.˼ Ma fu mi wë di Buku ta taki di taki e, ");
INSERT INTO srmNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ma wan kë ko a mi möönsö fuun sa feni di libi dë. ");
INSERT INTO srmNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ma nöö fa mi ta fan aki, dee sëmbë, wan musu mëni taa pena mi ta këë e, fu di un libisëmbë wan kë hei mi. Nönö. Biga a Gadu nöö mi ta suku hei. ");
INSERT INTO srmNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","43","Ma nöö fa un sai dë, mi sabi unu taa wan lobi Gadu. Biga ee un bi lobi ën, nöö un bi o tei mi u soni. Biga fa mi ko aki, a Gadu në mi ko. Hën da mi Tata, nöö hën manda mi ko aki tuu. Ma nöö wan ta tei mi u soni möönsö. Ma te wan oto sëmbë hopo ko nëën seei në, nöö hën un ta tei u soni waiwai seei. ");
INSERT INTO srmNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Ma nöö fa mi fan dë, unfa un sa biibi mi? An foombo mi tu. Biga a libisëmbë nöö un ta suku u feni nëbai, ma wan a’ bisi möönsö fuun feni nëbai a di wan kodo Gadu u mundu. ");
INSERT INTO srmNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ma nöö hii fa i si mi ta fan ku unu aki seei, dee sëmbë, ma wan musu mëni taa mi o tja unu go kaagi da mi Tata e. Ma wan sëmbë dë kabakaba kaa u kaagi unu. Hën da Mosesi di i si un ta buta mëni fuunu sö gaanfa nëën liba taa woon feni heepi a dee soni a sikifi buta dë. ");
INSERT INTO srmNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ma ee un bi biibi Mosesi tuu nöö an bi o toobi unu fuun sa biibi mi e, biga soni u mi wë a bi sikifi buta dë. ");
INSERT INTO srmNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nöö sö wë i si taa wan ta biibi dee soni a sikifi dë, nöö unfa un sa biibi dee soni mi ta fan ku unu aki?” Sö Masa Jesosi fan ku dee hedima u Dju dë te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hën u dë te wan daka hën u ku Masa Jesosi koti di ze u Galilea de kai Tibelia, go te a di oto së banda. ");
INSERT INTO srmNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","4","Hën u subi go sindo a wan kununu bandja. Nöö di ten dë, di gaan daka fuu dee Dju de kai Pasika ko zuntu faa kai. Nöö di juu dë, wanlö gaan hila sëmbë ta lontu a futu ta faaka Masa Jesosi ta ko, fu di de bi si a du sömëni foombofoombo soni ta kula sömëni sikima. ");
INSERT INTO srmNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nöö fa u ku Masa Jesosi dë sindosindo naandë, te wan pisi hën a hopo wojo hën a si dee hia sëmbë ta ko. Nöö hën a hakisi Filipi taa: “Wë womi, dee sëmbë ta ko dë, naasë woo feni soni u njan u da de?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ma fa a hakisi ën dë seei, ma a ta poobëën luku ee unfa di biibi fëën bigi tjika. Wë biga a bi saandi a o du kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hën Filipi piki ën a taa: “Wë Masa o, ee u bi wooko tu höndö daka seei, ma töku möni fëën an o tjika fuu bai soni u njan da dee hia sëmbë gidjii dë e. Aan fa fuu paati ën pikipiki te nöö a sa tjika de.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nöö hën Andiasi di baaa u Simon Petuisi taa: ");
INSERT INTO srmNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wan mii dë aki abi feifi piki bëëë ku tu pikipiki fisi tö, ma nöö unfa dee soni dë sa du heepi dee hia sëmbë aki?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nöö di a taki sö, hën Masa Jesosi taa: “Antoobi.” Hën a manda u taa u musu mbei dee sëmbë sindo a goon, biga di kamian naandë bi dë ku hia ahun. Nöö hën dee sëmbë saka sindo. Nöö fa de bi ko hia dë, nöö de dë feifi dusu womi ˻söndö de konda dee mujëë ku dee mii˼. Sö dee sëmbë bi hia tjika. ");
INSERT INTO srmNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nöö hën Masa Jesosi tei dee bëëë ku dee fisi dë, hën a da Gadu tangi te a kaba. Nöö hën a booko de pisipisi te a kaba, hën a tëndëën da u dee bakama fëën fuu paati da dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nöö hën u tja go paati da de, hën de njan tefa de bëë fuu. Nöö di de kaba u njan, nöö hën Masa Jesosi manda u taa: “Söö. Wë nöö be un go pii dee pisipisi dee fika e, be de an poi kaba a sösö.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nöö hën u go pii te a fuu tuwalufu gaan manda. Sö a fika hia tjika u dee feifi bëëë dee sëmbë njan. ");
INSERT INTO srmNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wë nöö di dee sëmbë si di gaan soni Masa Jesosi du dë, nöö a bigi da de te na soni. Hën de taa: “Söö. Wë di soni aki an dë u fia. Di sëmbë i si aki, hën da di Tjabukama di i si Masa Gadu paamusi taa a o manda ko a goonliba.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nöö hën di de taki sö kaa, hën de kë kisi ën ku taanga buta könu u de wante. Ma nöö di Masa Jesosi sabi sö kaa, nöö hën a fusi kumutu a de mindi, hën a go a dee kununu ala hën wanwan. ");
INSERT INTO srmNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Nöö hën u sai dë tefa di ndeti buka, Masa Jesosi an ko möönsö, nöö hën u dee bakama fëën go subi a di boto fuu aba go a Kapenaumi. Nöö di juu dë kamian ko ta dungu kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nöö hën di u nango te wan pisi, hën wan gaan ventu ko ta böö teee, di wata ta seki te na sondi. ");
INSERT INTO srmNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hën u ta puu ku taanga nango te u go kuma wan feifi kilomëti longi ku ka u bi kumutu, nöö hën u bia luku. Hën u si wan sëmbë ta waka ku futu a di wata liba ta ko a u. Nöö hën u ko fëëë te, u ta tëëmë tjatjatjatja sö, biga wa saandi da di soni ta ko a u dë. Nöö hii u di dë, Masa Jesosi wë gbolo, ma wa bi sabi. ");
INSERT INTO srmNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nöö hën a fan ku u taa: “Dee sëmbë, wan fëëë e. Mi wë disi.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nöö di u jei sö kaa, hën hati fuu ko kötö, nöö wa fëëë möön faa ko a di boto. Ma nöö fa i si a subi a di boto dë kaa, nöö te fuu mëni hën u dë a di oto së banda ala piii, ka u bi nango. ");
INSERT INTO srmNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Di dobooko fëën möön, hën dee hia sëmbë dee bi dë a di oto së banda ka u kumutu ala, hën de ko foondo tee. De an sa naasë Masa Jesosi bi go. Biga oto boto an bi sai dë möönsö möön leki di fuu boto, nöö de sabi taa na u ku Masa Jesosi bi go di go. ");
INSERT INTO srmNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nöö di juu dë wanlö gaan boto fu Tibelia Köndë ko tjökö naandë zuntu ku di kamian ka Masa Jesosi bi tei dee bëëë da Gadu tangi paati da de de njan. ");
INSERT INTO srmNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nöö hën di dee sëmbë ko sabi taa Masa Jesosi an sai dë möön, u dee bakama fëën seei wa sai dë möön tu, hën de subi a dee gaan boto hën de koti ko a Kapenaumi. Hën dee hia sëmbë ta suku Masa Jesosi ");
INSERT INTO srmNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","teefa de ko si ën. Nöö hën de hakisi ën taa: “Mësitë o, na un ten seepi i ko aki baa?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nöö hën Masa Jesosi taki da de taa: “Fa i si mi o fan ku unu aki, nöö tuutuu soni a dë e. Wan ta kule a mi baka fu di un ta fusutan dee foombo wooko mi ta du hedi e, ma fu di a dë taa mi bi da unu di bëëë un njan te bëë fuunu fuu. ");
INSERT INTO srmNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","“Nöö mi taki e, taa wan musu ta biinga fuun feni di njanjan di ta hoi unu fu wan pisiten nöö e, dee sëmbë. Ma be un biinga fuun feni di njanjan di sa mbei un feni libi u teego. Di njanjan dë, Mi di ko Libisëmbë Mii aki nöö sa da unu ën e. Biga mi nöö Gadu si taa fiti faa da mi di taki fu da unu sö wan soni.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nöö hën de piki ën taa: “Wë nöö unfa u musu du te nöö u sa du dee wooko Gadu kë fuu du?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hën a piki de taa: “Di wooko Gadu kë nö? Hën nöö da fuun musu biibi a Mi di Sëmbë di a manda ko aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hën de toona hakisi ën taa: “Wë nöö un maaka joo lei u fuu sabi taa a i u musu biibi? ");
INSERT INTO srmNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","I sa du foombo wooko kuma Mosesi nö? Biga hën bi ta da dee fesiten sëmbë fuu di njanjan de kai ‘mana’ hibiwan daka, u de njan a di gaan sabana kumafa di Buku taki taa: ‘Gadu Köndë bëëë a da de de njan.’ Nöö i sa du sö wan soni tu nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hën Masa Jesosi piki de taa: “Dee sëmbë, be mi taki wan tuutuu soni da unu e. Na Mosesi bi da de di mana dë e, ma mi Tata seei bi da de ën. Ma nöö fa mi taki dë seei, ma nëën bi da di tuutuu njanjan di ta kumutu a Gadu ala eti. ");
INSERT INTO srmNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Biga awaa ufö a ta da libisëmbë di tuutuu njanjan awaa. Hën da di Sëmbë aki di kumutu nëën ala, nöö hën bumbuu möön di mana. Biga hën sa mbei sëmbë feni di tuutuu libi di dë u teego.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hën de taa: “Wë nöö Mësitë o, tide wante fii seti da u di njanjan dë, fuu sa ta njan mën nöömö.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nöö hën Masa Jesosi piki de taa: “Un haika e. Mi wë da di njanjan di i si mi ta taki dë, di ta da sëmbë libi u teego. Biga ee wan sëmbë i ko a mi, nöö hati fii an o hangi na wan soni möön. Ee i ta biibi a mi liba, nöö dëëwata seei an o kisi i möön. ˻Biga joo dë bööböö.˼ ");
INSERT INTO srmNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ma nöö a dë leti kumafa mi bi taki da unu dë kaa. Un ta si mi fa mi dë, ma wan ta kë piki taa Gadu hën manda mi ko aki. ");
INSERT INTO srmNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ma fa mi fan dë seei, ma hii dee sëmbë dee mi Tata Gadu ta da mi, nöö de tuu o ko a mi nöömö, nöö di sëmbë di ko a mi ma o jakëën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Biga fa mi kumutu a liba ala ko aki, dee sëmbë, ma ko u mi du kumafa mi kë e. Ma mi ko u mi du dee soni dee di Sëmbë manda mi ko kë u mi du. ");
INSERT INTO srmNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nöö andi da di kë fëën? Hën wë da ma musu lasi na wan u dee sëmbë dee a da mi, ma mi musu weki de a dëdë a di kaba lasiti daka. ");
INSERT INTO srmNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Tuu wë e, dee sëmbë, disi da di soni mi Tata kë, taa hiniwan sëmbë di ta si mi di Mii fëën aki nöö i biibi a mi liba, nöö di sëmbë dë i abi di libi u teego kaa. Nöö sö wan sëmbë mi o weki a di kaba lasiti daka.” Sö Masa Jesosi taki da dee hia sëmbë dee ko nëën dë. ");
INSERT INTO srmNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nöö fa de jei di fan fëën naandë taa hën da di njanjan di kumutu a liba, hën so u de tei ën fu hogi seei. Hën de ta guunjëën, ");
INSERT INTO srmNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","taa: “Wë di mii aki sö, nëën da di mii u Josëfu de kai Jesosi nö? U sabi hën mama ku ën tata, nöö unfa a sa taki da u taa a kumutu a liba?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nöö hën Masa Jesosi taa: “Dee sëmbë o, un disa di guunjan un ta guunjan mi naandë e. ");
INSERT INTO srmNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Biga na wan sëmbë sa ko a mi ee na mi Tata di manda mi ko aki hën hai ën ko. Nöö sö wan sëmbë, hën mi o weki a dëdë a di kaba lasiti daka. ");
INSERT INTO srmNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Wan jei fa dee tjabukama sikifi buta a di Buku u Gadu nö? De taa hii sëmbë tuu o kisi lei a Gadu. Wë nöö ee wan sëmbë i jei di lei u Gadu dë, nöö i tei ën tja go a i hati, nöö a mi joo ko nöömö. ");
INSERT INTO srmNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Biga fa sëmbë ta kisi lei a Gadu seei, ma na wan sëmbë bi si ën ku wojo wan daka, boiti mi tö di kumutu nëën ala. ˻Hën mbei a mi i musu ko fii sabi soni fëën.˼ ");
INSERT INTO srmNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nöö fëën mbei mi taki da i tuutuu taa di sëmbë di ko biibi a mi, nöö hën feni di libi a Gadu di dë u teego. ");
INSERT INTO srmNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Mi taki da unu möön e, taa mi da di njanjan di ta da sëmbë gbelingbelin libi. ");
INSERT INTO srmNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Dee fesiten sëmbë fuunu, de bi njan di mana a di sabana tuu, ma töku de bi dëdë. ");
INSERT INTO srmNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma aki sö di njanjan dë awaa di kumutu a Gadu ko, nöö ee wan sëmbë i njan mën nöö ja o dëdë, ma joo feni di libi a Gadu di dë fu teego. ");
INSERT INTO srmNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Mi taki da unu möön e, dee sëmbë, taa mi da di njanjan ta da sëmbë libi. A Gadu mi kumutu, nöö di sëmbë di ta njan di njanjan aki hën abi di libi u teego. Nöö di njanjan di mi ta taki aki, nöö hën wë da di sinkii u mi aki, di mi o da fu hii goonliba sëmbë musu sa feni libi.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nöö di dee hedima u Dju jei a fan sö, hën de bigi ta fia ku deseei makandi taa: “Unfa di sëmbë aki sa da u hën sinkii fuu njan, maingë?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nöö hën Masa Jesosi piki de taa: “Tuutuu soni seei mi o taki da unu aki, dee sëmbë, taa ee wan sëmbë ja tei di sinkii u Mi di ko Libisëmbë Mii aki kuma njanjan fii, nöö ee ja tei di buuu u mi kuma wata di i ta bebe, nöö ja feni libi seei eti e. ");
INSERT INTO srmNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma ee wan sëmbë i tei di sinkii u mi kuma njanjan fii u njan, nöö i tei di buuu u mi kuma wata fii u bebe, nöö i abi di libi u teego kaa, nöö mi o weki i a dëdë a di kaba lasiti daka. ");
INSERT INTO srmNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Biga di sinkii u mi aki, hën da di tuutuu njanjan fii njan ee i kë libi. Nöö di buuu u mi, hën da di tuutuu wata fii bebe. ");
INSERT INTO srmNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nöö ee wan sëmbë tei di sinkii u mi aki kuma njanjan fëën a ta njan, nöö a tei di buuu u mi kuma wata fëën a ta bebe, nöö mi ku di sëmbë dë ko di wan. Wa o paati ku u seei möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Dee sëmbë o, fa mi Tata sai dë, nöö hën wë abi libi e, nöö hën toona da mi ën fu mi abi ën tu. Nöö hën manda mi ko aki. Nöö ee wan sëmbë tei mi kuma njanjan fëën a ta njan, nöö di sëmbë dë hën mi o da di libi dë tu e. ");
INSERT INTO srmNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Fëën mbei mi taa mi da di njanjan di kumutu a Gadu ala di ta da sëmbë libi. An dë kuma di mana di dee fesiten sëmbë fuunu bi njan, biga wë de bi dëdë, ma ee wan sëmbë njan di njanjan aki sö, hën o abi di libi u teego.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nöö a sö wan fasi Masa Jesosi ta lei dee sëmbë e, a di keikiwosu u dee Dju a Kapenaumi. ");
INSERT INTO srmNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nöö fa dee sëmbë dee bi ta waka a Masa Jesosi baka jei di fan a fan dë, nöö hën sömëni u de taa: “Maingë, andi da dee soni a ta lei dë? Ambë tjika u tei de?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma nöö Masa Jesosi sabi kaa taa sö de ta fan, nöö hën a fan ku de taa: “Wë di soni mi taki dë, hën taanga da unu fuun tei sö nö? ");
INSERT INTO srmNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wë nöö unfa seei a o dë da unu te un si Mi di ko dë Libisëmbë Mii aki toona go a liba ka mi bi kumutu? ");
INSERT INTO srmNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dee soni dee mi fan ku unu dë, na a sösö sinkii fasi un musu fusutan de e. Biga sinkii soni an sa heepi i fii feni di lö libi dë. Ma Akaa soni mi fan naandë, nöö ee i tei ën, nöö joo feni di libi u teego. ");
INSERT INTO srmNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma nöö fa mi ta biinga ku unu aki seei, so fuunu an kë piki mi.” Biga Masa Jesosi bi sabi gaanduwe kaa ambë ku ambë an o kë biibi ën, nöö a sabi di sëmbë di o sei ën a bakaten tu. ");
INSERT INTO srmNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nöö hën a toona taki da de taa: “Di soni aki wë mbei mi taki da unu taa na wan sëmbë sa ko a mi ee na mi Tata da i taanga.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nöö kumutu a di ten naandë, hën sömëni u dee sëmbë bi ta waka nëën baka kumutu go disëën, de an dë ku ën möön. ");
INSERT INTO srmNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nöö hën a bia hakisi u dee tuwalufu bakama fëën dee a bi pii tei apaiti taa: “Unfa un pakisei baa? Un kë go tu nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nöö hën Simon Petuisi piki ën taa: “Masa o, na ambë seei u sa go möönsö? Biga i nöö abi dee wöutu dee ta da sëmbë libi u teego. ");
INSERT INTO srmNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nöö u ta biibi a i liba, biga u sabi taa i da di Paamusi Könu, di Mii u Gadu gbelingbelin di a manda ko.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nöö hën a piki de taa: “Awa, sö un ta piki tuu. Ma nöö a dendu fuun dee tuwalufu womi mi pii tei aki, wan fuunu dë didibi e.” ");
INSERT INTO srmNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Fa a taki naandë, nöö di mii u Simon Isikaliotu de kai Judasi, hën wë da di sëmbë a ta taki. Biga hii fa i si a dë a dendu fuu dee tuwalufu bakama u Masa Jesosi seei, ma hën o sei ën a bakaten. ");
INSERT INTO srmNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nöö a baka u di dë, hën Masa Jesosi ta waka a dee köndëköndë fu Galilea. An nango a dee köndë u Judea ala möön, fu di dee hedima u Dju ta watji ën fu de feni ën kii. ");
INSERT INTO srmNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma nöö di juu dë, wan oto piizii fuu dee Dju sëmbë de ta njan bi zuntu faa kai. A dee daka dë, u ta mbei tjëkëliba ˻ta toona mëni fa dee gaan sëmbë fuu bi libi a di sabana hii föteni jaa longi˼. ");
INSERT INTO srmNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nöö hën dee baaa u Masa Jesosi ko ta kaakei ën taa: “Womi, andi i ta fika aki u du? Na a Judea ala fii go nö, fu dee sëmbë dee lo’ u nama ku i si dee foombo wooko i ta du. ");
INSERT INTO srmNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Biga ee wan sëmbë ta suku nëbai, nöö an o ta dë tjubitjubi, ma a o go lei ën seei a lanti wajaa be hii mundu si ën. Wë nöö di i ta du dee soni aki kaa, nöö fii go a lanti ala e, be de si i.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Biga wë hii fa de dë baaa fëën seei, ma de an ta biibi ën. Hën wë mbei de fan sö. ");
INSERT INTO srmNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","8","Nöö hën Masa Jesosi piki de taa: “Awa, mi sa go, ma di ten u mi an kisi eti e. Ma be un go nöö. Biga hiniwan juu uun kë, nöö un sa go ala. Fa un dë aki, dee sëmbë u di goonliba aki an ta buuse unu, ma mi de ta buuse. De an sa si mi a wojo seei, fu di mi ta konda da de gbelingbelin taa de an ta libi bunu a Gadu wojo. Nöö be unu wanwan go a di piizii e.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nöö di a fan ku de sö kaa, hën de de go, ma hën a fika a Galilea naandë ufö. ");
INSERT INTO srmNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ma baka u di de go, nöö hën a tei pasi faa go a di piizii awaa. Ma fa a nango naandë, an waka u lanti si ën. A waka a wan tjubi fasi sö. ");
INSERT INTO srmNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nöö di juu dë, fa de dë a di piizii dendu a Jelusalen naandë, nöö dee hedima u Dju ta watji ën ta hakisi taa: “Naasë a dë? Unsë di womi dë?” ");
INSERT INTO srmNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nöö dee hia sëmbë dee ko a di piizii naandë, nöö deseei ta taki soni fëën tu. So u de ta gafëën taa a dë bumbuu sëmbë. Otowan taa: “Nönö huun, a dë wan ganjansëmbëma, politikima.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma hii fa de ta fan naandë seei ma na wajaa a lanti, biga de ta fëëë dee hedima u Dju. ");
INSERT INTO srmNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nöö dee daka dee de buta u de njan di piizii nöö de pasa mindi kaa bifö Masa Jesosi ko dou awaa. Hën a go fëën wante a di gadii u di Wosu u Masa Gaangadu, nöö hën a seti lei sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nöö dee hedima u Dju ko sai dë ta haikëën tu, nöö de ko foondo seei teee, de taa: “Wë unfa di lagilagi sëmbë aki ko sabi soni sö, ma na a dee siköö fuu a go?” ");
INSERT INTO srmNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hën Masa Jesosi bia piki de. A taa: “Dee sëmbë, un haika e. Di lei i si mi ta lei aki, nöö na a mi a kumutu e. Ma di Sëmbë di manda mi ko aki, nëën a kumutu. ");
INSERT INTO srmNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nöö ee wan sëmbë i ta hangi fii du fa Gadu kë nöö joo sabi ee a Gadu di lei u mi ta kumutu, ee miseei sondi mi ta tei ta taki. ");
INSERT INTO srmNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Ma nöö ee wan sëmbë hopo ta konda soni fëën seei, nöö nëbai nöö a ta suku, na sö a dë nö? Ma ee a ta suku nëbai da di sëmbë di mandëën ko, nöö di sëmbë dë dë bumbuu sëmbë kaa. Na politiki a ta naki.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nöö hën a taa: “Dee sëmbë, na Mosesi bi tja dee wëti u Gadu ko da unu nö? Hën mbei un ta hei ën sö. Ma töku na wan fuunu kë hoi dee wëti dë, biga un kë kii mi. Nöö mi kë sa faandi mbei.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nöö hën de piki ën taa: “Soni hën ko a i hedi nö, womi? Ambë da di sëmbë di kë kii i?” ");
INSERT INTO srmNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nöö hën a taa: “Fa mi dë aki, wan kodo foondo wooko tö mi du a saba, hën wë a bigi da unu te wan saanfa fuun du. ");
INSERT INTO srmNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ma nöö unu, hiniwanten un ta poi saba. Biga Mosesi bi da unu wan wëti taa un musu koti di maaka u Dju a dee womi mii fuunu sinkii, te de abi aiti daka u di de pai ën. Ma nöö tökuseei na a Mosesi ten wë di wëti dë kumutu e, ma sensi a dee oto gaan sëmbë fuunu dee bi dë ufö ën. ");
INSERT INTO srmNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nöö ee wan sëmbë ko a unu fuun koti di maaka a di mii fëën sinkii dëën, nöö ee a kai a saba daka seei ma un ta koti ën waiwai fu di di wëti musu hoi. Wë nöö na wooko un ta wooko a di saba dë nö? “Wë nöö faandi mbei un musu ta guunjan mi u di mi heepi wan sëmbë ko bumbuu ku telu a saba daka? ");
INSERT INTO srmNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","I si ö? Wan musu ta kuutu soni hesihesi sö e, dee sëmbë, ma un musu ta wegi soni luku fini ufö un kuutu, nöö di kuutu fuunu o dë leti.” Sö Masa Jesosi fan ku dee hedima naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nöö fa dee sëmbë u Jelusalen dë ta haika di fan u Masa Jesosi, nöö so u de ta hakisi taa: “Wë di sëmbë aki, nëën dee hedima fuu bi ta suku u kii nö? ");
INSERT INTO srmNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nöö hën a ko dë aki ta fan a lanti dendu wajaa sö. Ma na wan sëmbë dë aki ta suku u tapëën seei. Wë a sa kë sonte dee hedima fuu ko si taa hën da di Paamusi Könu di Gadu bi o manda ko nö? ");
INSERT INTO srmNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma ee de ta mëni sö seei, ma u sabi naasë di sëmbë aki kumutu. U sabi ën bumbuu. Ma te di Paamusi Könu ko, sëmbë an o sabi naasë a kumutu.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nöö di de fan sö, hën Masa Jesosi bai fan möön taanga ka a dë a di djai dendu dë taa: “Awa, un sabi mi tuu, di da un taa un sabi naasë mi kumutu. Ma tökuseei wan sabi fini fëën eti e. Biga fa mi ko aki, ma ko u mi seepi ma wan Sëmbë hën manda mi ko. Nöö di Sëmbë dë an ta ganjan sëmbë. Ma fa uun sai dë, wan sabi di Sëmbë mi ta taki aki möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ma nöö mii sabi ën biga nëën ala mi kumutu. Hën manda mi ko aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nöö fa a fan dë, nöö di fan fëën an kai ku dee hedima seei, nöö hën de kë kisi ën tja go. Ma tökuseei na wan sëmbë panjëën, biga di juu fëën an dou eti. ");
INSERT INTO srmNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma nöö hii fa dee hedima bi ta suku ën u kisi seei, ma wanlö hila sëmbë sai dë ko ta biibi nëën. Biga de taa: “Wë mi hakisi e, te di Paamusi Könu ko, nöö a o sa du möön gaan foombo wooko möön fa di sëmbë aki ta du nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nöö fa dee lanti ta fan kusikusi naandë, nöö dee Faliseima an kë jei seei taa sö de ta mëni u Masa Jesosi taa hën da di Paamusi Könu. Nöö hën de go a dee Gaan Begima dee ta dë a di Gaan Keikiwosu dë, hën de fiti buka makandi. Nöö hën de manda dee wakitima dee ta watji di Wosu taa be de go kisi Jesosi tja ko da de. ");
INSERT INTO srmNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Di juu dë, Masa Jesosi ta fan ku dee sëmbë eti. A taa: “Wan sati pisiten nöö mi o dë ku unu möön eti e, nöö mi o toona go a di Sëmbë di bi manda mi ko aki. ");
INSERT INTO srmNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A di juu dë woon ta suku mi te un wei, ma wan o feni mi möönsö. Biga ka mi o go dë, wan o sa ko dou ala e.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nöö hën dee Dju hedima hakisi deseei taa: “Wë nöö naasë di womi aki sa go maingë te nöö wa o sa si ën möön? A sa kë taa a o go a dee oto köndë ka dee Dju sëmbë fuu paaja go, faa musu go ta lei dee oto köndë sëmbë nö? ");
INSERT INTO srmNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Andi da di oto a ta taki naandë taa woon suku mi te un wei, wan o si mi möön, nöö ka mi o go nöö wan o sa dou ala?” ");
INSERT INTO srmNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nöö di kaba lasiti daka u di piizii dë, hën bigi möön hii dee oto daka tuu. Nöö a di daka dë, hën Masa Jesosi hopo taanpu hën a bai taa: “Ee wan sëmbë dëëwata kisi i nöö be i ko a mi e, ko tei wata fii bebe. ");
INSERT INTO srmNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Biga a sikifi a Masa Gadu Buku taa, di sëmbë di ko biibi a mi nöö a o dë nëën hati dendu kuma wan kiiki hedi ta kule wata ta ko nöömö, ta tja di libi u teego ta paaja.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Wë nöö fa a fan naandë, a ta taki u di Akaa u Gadu di dee sëmbë ta biibi nëën o kisi a bakaten. Biga di juu dë, sëmbë an bi kisi di Akaa eti fu di Masa Jesosi an bi toona go a Gadu Köndë faa feni di nëbai fëën eti. ");
INSERT INTO srmNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nöö di dee sëmbë jei fa a bai dë, hën so u de taa: “Maingë, di sëmbë dë, a musu u dë di Tjabukama di Gadu bi o manda ko e.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Otowan taa: “Hën di Paamusi Könu seei di dë wante.” Otowan taa: “Hun? Nönö, na a Galilea di Paamusi Könu bi o kumutu e. ");
INSERT INTO srmNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Biga Gadu Buku taki taa a o dë wan bakamii u Dafiti, nöö a Betelehem a o kumutu, ka Dafiti bi ta libi.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nöö da sö dee sëmbë ko paati fu Masa Jesosi hedi. ");
INSERT INTO srmNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","So u de kë go kisi ën seei fu de tja go a kuutu, ma tökuseei na wan sëmbë panjëën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nöö fa de mbei dë, hën wë dee wakitima toona go a dee Faliseima ku dee Gaan Begima, dee bi manda de ko. Hën dee hedima hakisi de taa: “Unfa wë? Wan kisi ën tja ko nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hën de taa: “Wë nönö. Fa u jei di fan fëën te u kaba dë, nöö a bigi da u poi. Biga wa jei na wan sëmbë fan sö wan daka.” ");
INSERT INTO srmNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nöö hën dee Faliseima taa: “Ambëë? A ganjan unu kisi tu nö? ");
INSERT INTO srmNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Fa u dë aki, un jei wan daka taa wan fuu dee takima ku dee Faliseima aki ko biibi nëën ö? ");
INSERT INTO srmNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wan sabi taa dee lagilagi sëmbë sösö wan dë, dee na sabi wan wojo soni u Gadu wëti, de nöö ta biibi ën nö? Helu u de tu!” ");
INSERT INTO srmNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nöö fa de fan dë, nöö Nikodemusi di bi go fan ku Masa Jesosi a wan ndeti, nöö hënseei dë wan u dee hedima tu. Nöö hën a hakisi de taa: ");
INSERT INTO srmNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Wë nöö unfa di wëti fuu dë? U sa kuutu wan sëmbë da sitaafu söndö u dëën pasi faa fan, fuu sabi taa hogi a du tuu nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nöö hën de piki ën taa: “Aa, fa u dë aki, nöö i seei dë a di së u dee Galilea sëmbë tu nö? Wë go suku a di Buku luku ee unsë joo si taa wan tjabukama u Gadu kumutu a Galilea wan daka.”  ");
INSERT INTO srmNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nöö fa de fan dë, nöö hën hii sëmbë booko paaja go u de a wosu. ");
INSERT INTO srmNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma nöö Masa Jesosi hën a go a di kununu de kai Oleifi Kununu. ");
INSERT INTO srmNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nöö di dobooko fëën mamate biten, hën Masa Jesosi toona ko a di Wosu u Masa Gadu möön. Nöö fa a ko dë, nöö hën hii sëmbë hai ko wante nëën naandë, hën a seeka sindo faa lei de. ");
INSERT INTO srmNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nöö di juu dë, dee Sabima u Wëti ku dee Faliseima tja wan mujëë ko nëën naandë. A dë sö taa de kisi di mujëë dë ku wan womi, hën de tjëën ko buta taanputaanpu leti a dee hia sëmbë fesi dë. ");
INSERT INTO srmNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Hën de taki da Masa Jesosi taa: “Wë Mësitë o, di mujëë aki, hën wë u kisi ku womi djunsu dë nöö hën wë u tjëën ko a i. ");
INSERT INTO srmNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wë nöö a dee wëti Mosesi bi da u, nöö a taa te u kisi wan mujëë sö nöö u musu naki ën ku sitonu kii. Nöö unfa ii taki u di soni dë?” Sö de hakisi ën. ");
INSERT INTO srmNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ma nöö fa de ta hakisi ën dë, taapu tö nöö de ta seti dëën sö fu de feni föutu nëën u de tjëën go kaagi. Ma nöö Masa Jesosi an piki de, hën a bendi ta sikifi soni ku ën finga a goon. ");
INSERT INTO srmNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hën de ta buta ku ën nöömö faa musu taki wan soni. Te wan pisi hën a hopo taanpu. Hën a taa: “Luku, di fuunu di si taa a dë söndö föutu a Gadu wojo, nöö be a hiti di fosu sitonu naki di mujëë.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hën di a fan sö kaa, hën a toona bendi ta sikifi soni ku finga a goon möön. ");
INSERT INTO srmNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","10","Nöö di dee sëmbë bi tja di mujëë ko dë jei sö, nöö hën de bia ta fusi nango u de oto a oto baka, seti a dee gaan wan te dou a dee möön njönku wan. Biga de tuu ko si taa de an dë söndö föutu a Gadu wojo. Nöö hën Masa Jesosi hopo taanpu, nöö an si na wan kodo sëmbë dë möön boiti di mujëë wanwan tö sai dë taanputaanpu. Hën a hakisi ën taa: “Wë mujëë o, unsë dee sëmbë dee tja i ko aki dë? De an da i sitaafu möön nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hën a taa: “Wë nönö, Mësitë.” Nöö hën a taa: “Söö, wë antoobi. Nöö miseei, ma o da i sitaafu tu. Nöö i toona go fii, ma te i go nöö na du hogi möön e, mujëë.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nöö hën Masa Jesosi toona seti fan ku dee sëmbë dee bi ko nëën naandë. A taa: “Mi da di limbo u di goonliba aki e. Hën mbei ee wan sëmbë i ta waka a mi baka nöö ja o waka a dungu möönsö, ma fusutan fii o dë limbolimbo gbegedee. Biga i kisi di libi u Gadu kaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nöö di a taki sö, hën dee Faliseima buta ku ën wante. De taa: “Haika fa i ta fan fii seei naandë. Ja abi na wan sëmbë u dë kotoigima da i, hën mbei sëmbë an sa piki di fan fii taa tuutuu soni i ta taki.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hën Masa Jesosi piki de taa: “Ee soni u miseei mi ta konda seei, ma nöö tuutuu soni mi ta taki e. Biga mii sabi naasë mi kumutu, nöö mi sabi naasë mi nango tu. Ma fa un sai dë, un wan sabi dee soni dë. ");
INSERT INTO srmNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","“Nöö fa un ta kuutu mi aki, un ta kuutu mi a libisëmbë fasi nöö. Ma fa mi dë aki, ma ta kuutu na wan sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma te mi o kuutu, nöö di kuutu u mi o dë leti e, biga na mi wanwan o kuutu ën. Ma mi ku mi Tata di manda mi ko aki tuu o kuutu ën makandi. ");
INSERT INTO srmNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Nöö unfa a dë a di wëti fuunu, dee sëmbë? Na tu sëmbë musu taki di wan soni ufö de sa piki taa tuu nö? ");
INSERT INTO srmNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wë nöö mi dë wan sëmbë ta kotoigi da miseei kaa, nöö di otowan hën da mi Tata di manda mi ko aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nöö hën de hakisi ën taa: “Sö nö? Wë naasë di tata fii dë?” Hën a piki de taa: “Wë di wan sabi mi, hën mbei wë wan sabi mi Tata. Ma ee un bi sabi ambë da mi, nöö un bi o sabi ambë da mi Tata tu.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nöö dee fan Masa Jesosi ta fan naandë, nöö a fan de leti a di Wosu u Masa Gaangadu dendu, zuntu ku di kamian ka de ta tja möni ko u da Gadu. Ma nöö fa hii sëmbë bi dë gidjii dë seei, ma töku na wan sëmbë kisi ën panjan, biga di juu fëën an dou eti. ");
INSERT INTO srmNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nöö hën a toona fan ku de möön taa: “Mi o go, nöö woon suku mi te un wei ma wan o sa dou ka mi nango e. Nöö woon dëdë söndö Gadu puu unu a bëë u dee hogidu fuunu.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nöö hën di a taki sö, hën dee hedima u Dju taa: “Wë unsë a o go di a taa ka a o go wa o sa dou ala? A sa kë a o go kii ën seei nö, maingë?” ");
INSERT INTO srmNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma nöö hën a taki da de taa: “Un haika e, uun dë u goonliba aki, ma nöö mii dë u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nöö fa mi taki da unu taa woon dëdë söndö Gadu puu unu a bëë u dee hogi du fuunu aki, nöö tuu e. Biga ee wan kë piki mi taa mi da di Sëmbë di mi taki da unu taa mi dë aki, nöö woon dëdë a dee hogi du fuunu liba söndö Gadu puu unu a bëë.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nöö hën de hakisi ën taa: “Wë fa i ta fan dë, ambë seei da i?” Nöö hën a piki de taa: “Mi da di Sëmbë di mi ta taki da unu nöömö kaa taa mi dë. Hën nöö mi dë eti. ");
INSERT INTO srmNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nöö fa mi dë aki, mi abi sömëni soni u mi sa tei kuutu unu, ma nöö ma o du sö e. Biga di Sëmbë di manda mi ko aki, nöö dee sondi dee a ta taki da mi nöö de nöö mi ta tei ta taki. Nöö tuutuu sondi a ta taki e, dee sëmbë. I sa futoou ën.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma nöö fa Masa Jesosi ta fan naandë, de an ta fusutan taa soni fëën Tata Masa Gadu a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Fëën mbei a taki da de taa, “Te di daka woon hopo Mi di ko Libisëmbë Mii aki buta a liba bifö woon ko sabi ambë da mi awaa. Nöö a di ten dë, nöö woon ko si taa ma ta du na wan wojo sondi u mi seei, söseei tu ma ta fan wan soni u miseei, ma dee soni mi Tata lei mi, nöö de mi ta taki. ");
INSERT INTO srmNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nöö fa a manda mi ko aki, nöö a ta dë ku mi tu e. An ta disa mi wanwan möönsö, biga hiniwan juu mi ta du dee sondi dee ta kai ku ën.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nöö di dee hia sëmbë bi sai dë jei fa a fan, nöö sömëni u de bia ko biibi nëën, ˻te kisi so u dee hedima u Dju˼. ");
INSERT INTO srmNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nöö hën Masa Jesosi fan ku dee ˻hedima u˼ Dju dee ko biibi ën dë taa: “Ee un ta hoi dee lei mi ta lei unu aki nango nöömö, nöö woon ko dë bakama u mi tuutuu. ");
INSERT INTO srmNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nöö woon ko sabi sondi gbelingbelin, leti kumafa a dë a Gadu wojo. Nöö te un ko sabi sondi sö kaa, nöö a o mbei un ko fii kumutu a di saafu un sai dë.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nöö hën de piki ën taa: “Ambëë? Fa uu dë aki, u da Abahamu böngö. Hën da gaan sëmbë fuu. Na wan ten u bi dë saafu a sëmbë basu wan daka. Nöö unfa i sa taa woo ko fii kumutu a saafu?” ");
INSERT INTO srmNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nöö hën Masa Jesosi piki de taa: “Fu tuutuu mi taki da unu taa ee wan sëmbë i ta du hogi nango nöömö, nöö saafu wë i dë a hogi du basu e. ");
INSERT INTO srmNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","“Nöö ee i dë saafu ta wooko da wan famii, nöö ja a’ wan tan kamian a di famii dë möönsö. Biga saafu nöö i dë. Ma nöö di sëmbë di dë miii u di famii, nöö hën o dë a di famii nöömö, nöö ˻hën o abi taki a di wosu dendu˼. ");
INSERT INTO srmNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wë nöö ee di Mii u Gadu aki, hën puu i a saafu mbei i ko fii, nöö i ko fii tuutuu seei. ");
INSERT INTO srmNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Dee sëmbë, fa un sai dë, mi sabi taa unu da dee böngö u Abahamu, ma nöö wan ta djei ën e. Biga un dë kabakaba u kii mi fu di wan kë tei dee soni mi ta lei unu aki. Ee Abahamu wë, an bi o du sö o. ");
INSERT INTO srmNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Fa mi dë aki, mi ta lei unu dee sondi dee mi si ku dee mi jei a mi Tata, ma nöö unu ta du dee sondi dee un si a di tata fuunu.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nöö hën de piki ën taa: “Un tata fuu i ta taki dë? Na di böngö u Tata Abahamu u dë nö?” Hën a piki de taa: “Ee un bi dë dee gbelingbelin böngö u Abahamu, nöö un bi o libi kuma hën. ");
INSERT INTO srmNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma un dë kabakaba u kii mi, hii fa mi da di Sëmbë di ta lei unu dee tuutuu soni u Gadu dee miseei jei nëën. Abahamu an bi o du sö wan soni e. ");
INSERT INTO srmNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ma uun ta du dee soni dee un si a unu tata, hën mbei un kë kii mi.” Nöö hën de piki ën taa: “Wë nöö fa i ta fan dë, i kë mbei taa u da oto tata mii nö? Nönö. Masa Gaangadu mii seei u dë. Hën nöö da u Tata.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nöö hën Masa Jesosi piki de taa: “Ee Gadu hën bi da unu tata, nöö un bi o lobi mi e, biga nëën ala mi kumutu ko aki. Hën seei wë manda mi ko aki. ");
INSERT INTO srmNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nöö faandi mbei wan ta fusutan dee soni mi ta taki aki? A dë fu di wan dë a di fa fuun tei de, hën wë mbei e. ");
INSERT INTO srmNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Di didibi seei wë da unu tata e, dee sëmbë. Biga dee soni dee a lo’ u du, nöö deseei wë un ta kë du dë kaa. Fa a sai dë, sensi a di seti u mundu a bi ta kii sëmbë kaa. An nama wan daka seei a tuu soni möönsö, biga di soni de kai tuu, an dë nëën hati seei. Mindi soni, hën da di hiniwan daka fan fëën di a ta fan kaa, biga nëën mindi soni ku lëgëdë kumutu. ");
INSERT INTO srmNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nöö fu di un nama ku ën, hën wë mbei wan kë piki mi a dee tuutuu soni mi ta lei unu aki. ");
INSERT INTO srmNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Fa un dë aki, na wan fuunu sa lei finga a mi taa mi du hogi wan daka möönsö. Wë ee wan sa lei sö, nöö hën da tuutuu soni nöö mi ta taki. Nöö faandi mbei wan kë piki mi? ");
INSERT INTO srmNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na fu di wan dë sëmbë u Gadu nö? Aai, hën wë mbei. Wë biga di sëmbë di dë u Gadu nöö hën ta haika Gadu woto.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nöö hën de piki ën taa: “Söö. Wa bi taki leti o, taa ju da wan takusëmbëma, ju Samalia sëmbë ju? Wan hogi soni wë dë a i liba ta fan dee lö fan naandë!” ");
INSERT INTO srmNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hën Masa Jesosi piki de taa: “Nönö e, dee sëmbë. Na soni hën dë a mi liba e, ma mi Tata në hën nöö mi ta suku u bai. Ma unu ta wisiwasi mi. ");
INSERT INTO srmNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma nöö ma a’ toobi, biga ma ta suku nëbai da miseei. Ma nöö wan Sëmbë dë di ta suku ën da mi, nöö hën ta kuutu buta ambë fiti nëbai ku ambë an fiti. ");
INSERT INTO srmNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","˻Nöö ka a hei mi tjika aki,˼ nöö fu tuutuu mi taki da unu taa ee wan sëmbë ta hoi dee soni mi ta fan aki, nöö an o dëdë kaba a sösö möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nöö hën dee Dju hedima piki ën taa: “Söö. Awaa u ko si gbelin taa wan didibi hën dë a i liba tuu, ˻fa i ko ta fan dee laulau fan naandë˼. Biga Abahamu dëdë gaanduwe kaa, söseei dee fesiten tjabukama tu. Ma nöö ii ko dë aki ta bai taa ee wan sëmbë ta hoi a dee lei fii nöö an o dëdë möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Fa i sai dë, i hei möön Abahamu ku dee oto tjabukama u Gadu dee dëdë kaa nö? Unfa seei i ta mëni fii seei?” ");
INSERT INTO srmNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hën Masa Jesosi piki de taa: “Ee miseei ta hei miseei, nöö an dë wan wojo sondi. Ma mi Tata di un taa hën da Gadu fuunu, hën ta hei mi e. ");
INSERT INTO srmNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nöö hii fa un taa a dë unu Gadu ma töku wan sabi ën, ma nöö mii sabi ën. Ee mi taa ma sabi ën, nöö hën da mi dë wan lëgëdëma kuma unu. Ma nöö mii sabi ën e, nöö mi ta hoi dee taki fëën tu. ");
INSERT INTO srmNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nöö Abahamu, di gaan sëmbë fuunu, bi wai tumusi e, di a sabi taa a o si di daka di mi o ko a goonliba aki. Wë nöö a si ën tu, nöö a wai seei.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Fa a fan dë, hën de mbei: “Höön, andi i ta taki dë? Fa I sai naandë, ja gaandi dou feifiteni jaa eti, hën i bai taa i si Abahamu nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nöö hën Masa Jesosi piki de taa: “Tuutuu mi taki da unu taa bifö de pai Abahamu, nöö mi bi dë gaanduwe kaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","˻Nöö fa a piki dë, nöö de jei seei gbelin taa a taki taa hënseei da Gadu.˼ Nöö hën de kule go kisi sitonu mii u de naki ën kii. Ma nöö Masa Jesosi fusi a de dendu pala kumutu a di Wosu dë go fëën. ");
INSERT INTO srmNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nöö hën fa Masa Jesosi nango dë, te wan pisi hën a si wan bookowojoma di de bi pali sö. ");
INSERT INTO srmNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nöö hën u dee bakama fëën hakisi ën taa: “Wë Mësitë o, fa de pali di sëmbë bookobookowojo aki, hogi hën tata ku ën mama du mbei de pali ën sö nö, naa nëën seei a kumutu?” ");
INSERT INTO srmNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nöö hën a piki u taa: “Nönö, na hogi di womi aki du e, na hogi hën mama ku ën tata du tu. Ma a ko pasa sö u di kaakiti u Masa Gadu musu ko a limbo nëën libi. ");
INSERT INTO srmNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Fa u dë aki, nöö u abi ten eti fuu ta wooko da di Sëmbë di manda mi ko aki, biga didia dë eti. Ma te wan pisi ndeti o ko, nöö na wan sëmbë o sa wooko möön. ");
INSERT INTO srmNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Hën mbei solanga mi dë a goonliba aki, nöö mi da di Limbo di ta limbo sëmbë u di goonliba aki wojo.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nöö fa a fan naandë, hën a tunta a goon wante. Nöö hën a mbei ën pötöpötö, hën a lobi a di bookowojoma naandë wojo. ");
INSERT INTO srmNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nöö hën a taki dëën taa be a go wasi a di tobo de kai Siloam. (Nöö di “Siloam” dë, hën kë taki “de mandëën”.) Nöö hën di sëmbë go, hën a go wasi te a kaba. Nöö fa a du naandë, hën wojo fëën limbo gbegedee, a ko ta si soni, nöö hën a toona go fëën a wosu. ");
INSERT INTO srmNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wë nöö di a dou a wosu, hën dee sëmbë ku ën ta libi bandja ku bandja naandë, ku dee oto sëmbë dee bi naa si ën ta pidi möni, hën de ko si ën naandë. Hën de ta hakisi taa: “Wë nöö di sëmbë aki, nëën u bi ta si sindosindo ta pidi möni nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Otowan taa: “Hën seei wë di dë e.” Otowan taa: “Nönö, nëën. Oto sëmbë nöö wë djei ën sö.” Ma nöö hënseei piki taa: “Mi seei wë disi wante e, dee sëmbë!” ");
INSERT INTO srmNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hën de taa: “Wë nöö unfa a waka wojo fii jabi te i ko ta si soni baa?” ");
INSERT INTO srmNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hën a piki de taa: “Wan womi de kai Jesosi hën wë mbei wan pötöpötö lobi a mi wojo, hën a manda mi u mi go wasi a di tobo de kai Siloam. Nöö hën di mi go wasi, nöö hën mi ko ta si soni.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hën de hakisi ën taa: “Wë nöö naasë di sëmbë dë?” Hën a taa: “Wë nönö, ma sabi.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nöö hën wanlö sëmbë bi sai naandë tei ën tja go a dee Faliseima. ");
INSERT INTO srmNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wë biga di daka di i si Masa Jesosi kulëën naandë, nöö a bi dë leti a wan saba. ");
INSERT INTO srmNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hën dee Faliseima hakisi ën taa: “Wë womi, unfa i du ko ta si soni? Kondëën da u.” Hën di sëmbë piki taa: “Wë di sëmbë tei doti mbei pötöpötö lobi a mi wojo, hën mi go wasi. Hën wë wojo u mi ko limbo, mi ko ta si soni e.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nöö hën so u dee Faliseima taa: “Hön, di sëmbë naandë, na a Gadu a kumutu e. Biga an hoi di saba.” Ma dee otowan u de taa: “Ma wan hogi sëmbë an bi o sa du sö wan gaan foondo soni e.” Hën de kisi toobi ku deseei naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nöö hën de toona bendi ko a di sëmbë di wojo bi booko naandë baka, hën de taa: “Wë ju a bi kula mbei i ko ta si sondi. Nöö unfa fëën ii taki?” Hën a taa: “Wë mi si taa a dë wan tjabukama u Gadu.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma nöö de an kë piki seei taa de bi pai ën bookobookowojo ma nöö fa u dë aki a ko ta si soni. Nöö hën de dë a di taki tee, hën de kai hën tata ku ën mama ko. ");
INSERT INTO srmNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Hën de hakisi de taa: “Wë di sëmbë aki sö, miii fuunu nö? Nöö bookobookowojo un bi pai ën nö? Nöö unfa a waka ufö a ko ta si soni fa u dë aki? Un piki u boo jei.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nöö hën di tata ku di mama piki de taa: “Wë u sabi taa a dë miii fuu, nöö u sabi gbelingbelin tu taa u bi pali ën bookobookowojo. ");
INSERT INTO srmNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma nöö fa a waka ufö a ko ta si soni, nöö di dë wa sabi. Nöö wa sabi tu ambë da di sëmbë di kulëën te a ko ta si soni. Ma nöö di a dë gaangaan sëmbë kaa, nöö a kandë un sa hakisi ën seei i si, be hënseei fan ku unu.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nöö sö di tata ku di mama u di womi piki, u di de fëëë dee hedima u Dju. Biga wë de bi buta taa ee wan sëmbë ta piki taa Jesosi hën da di Paamusi Könu, nöö de o puu i a keiki. ");
INSERT INTO srmNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hën mbei de piki a di lö fasi dë taa: “Un hakisi hënseei biga a ko gaan sëmbë kaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nöö hën de toona kai di womi di u tu pasi ko a de. Hën de taki dëën taa: “Wë womi, fa i fan dë, u kë jei ën möön. Ma nöö i musu hopo maun a liba soi a Gadu fesi taa tuutuu soni gbelin joo taki awaa. Biga u sabi taa di sëmbë di i taa hën kula i dë, nöö takulibima a dë e.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nöö hën di sëmbë piki de taa: “Wë ee a dë takulibima nöö di dë ma sabi. Ma wan kodo soni nöö mi sabi. Hën da mi bi dë bookowojoma, ma nöö fa u dë aki mi ko ta si soni.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nöö hën de hakisi ën möön taa: “Wë andi ku andi seei a du da i baa, ufö i ko ta si soni. Piki u boo jei.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nöö hën a piki de taa: “Wë mi bi taki di soni da unu kaa ma nöö wan kë piki. Andi fëën seei un kë jei a mi möön? A sa kë taa unu seei kë bia ko bakama fëën tu nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nöö fa a piki de naandë, hën de kisi faja awaa. Hati u de boonu ku ën tee hën de kosi ën te a bigi. De taa: “Höön, wë nöö i kë dë bakama u sö wan lagilagi sëmbë nö? U dee sëmbë aki, bakama u Mosesi uu dë, ");
INSERT INTO srmNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","biga u sabi taa ku Mosesi wë Gadu bi fan. Ma di lö sëmbë dë, hën wa sabi naasë seei a kumutu ko aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nöö hën di sëmbë taa: “Aa, wë a foombo mi tumisi o, di un taa wan sabi naasë a kumutu, ma nöö a kula mi te mi ko ta si soni. ");
INSERT INTO srmNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wë u sabi taa fa Gadu sai dë, an ta haika di begi u wan takulibima. Ma di sëmbë di ta lesipeki ën ta du dee soni dee a ta taki, nöö te hën begi ën nöö a ta jei. ");
INSERT INTO srmNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wë nöö fu sensi di goonliba mbei te kisi tide, nöö wa jei taa de mbei wan sëmbë di de pali bookobookowojo ko si soni wan daka. ");
INSERT INTO srmNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ee di sëmbë dë an bi dë u Gadu, nöö an bi o sa du sö wan soni e.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nöö fa di womi piki naandë, hën dee hedima kosi ën tee, de taa: “Ju! Fa i si de pali i bookobookowojo dë, nöö ja sabi taa hogilibi mbei de pali i sö nö? Nöö andi i abi u lei u?” Nöö hën de jakëën puu a di keikiwosu dë buta go a döö. ");
INSERT INTO srmNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nöö di Masa Jesosi ko jei taa sö de jaka di womi, hën a ko miti ku ën. Hën a hakisi ën taa: “Unfa wë baa? I ta biibi a di Mii u Gadu di ko libisëmbë mii nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nöö hën di womi piki ën taa: “Wë nöö Mësitë o, unsë seei a dë baa? Mi kë biibi nëën.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nöö hën a piki ën taa: “Hën wë i si disi kaa e. Hën seei wë ta fan ku i aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nöö hën di womi taa: “Aaa, wë Masa, mi ta biibi o.” Hën a saka tjökö kini a goon dëën. ");
INSERT INTO srmNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nöö di soni pasa dë, hën mbei Masa Jesosi taki wan soni aki sö. A taa: “Fa mi ko a goonliba aki, nöö mi ko fu mbei libisëmbë musu kuutu paati ku deseei. Dee bookowojoma, de o ko a mi fu mi limbo de wojo be de fusutan soni. Ma nöö dee sëmbë dee taa wojo u de an booko, de ta si soni kaa, nöö de o ko fika bookowojoma awaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nöö fa a fan naandë, nöö wanlö Faliseima bi sai naandë ta jei, nöö de sabi taa de a ta tjökö. Hën de taa: “Ee? Unfa i taki? I kë taa u dë bookowojoma nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Hën a piki de taa: “Wë ee un bi piki taki wojo fuunu booko, nöö wan bi du hogi e. Ma nöö di un taa soni an du unu, un ta si soni kaa, nöö fëën mbei föutu fika a unu liba.” ");
INSERT INTO srmNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nöö hën Masa Jesosi ta lei dee sëmbë möön, a taa: “˻I sabi fa a dë te wan sëmbë o kiija sikafu. A o mbei wan sitonu peni ta tjubi de fu hogi mbeti an sa ko kisi de kii. Na sö a dë nö? Wë nöö fa a o mbei di peni dë, nöö wan kodo dööbuka tö a o abi.˼ Nöö mi o konda wan soni da unu aki, nöö tuutuu soni seei a dë e. Ee wan sëmbë an kë waka a di dööbuka, ma a ta subi fëën a wan oto kamian fu go a di peni dendu, nöö di sëmbë dë nöö fufuuma e, hogihatima gbelin seepi a dë wante. ");
INSERT INTO srmNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","“Ma di sëmbë di o waka a di dööbuka ko a di peni dendu, nöö hën da di kiijama u dee sikafu seei. ");
INSERT INTO srmNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nöö fa i si a ko dou dë, nöö wantewante di wakitima o jabi di döö dëën, faa pasa go a dendu. Nöö te a go a dendu kaa, nöö hiniwan u dee sikafu a o kai de në, nöö de o jei ën biga de sabi ën töngö. Nöö a o tja de kumutu a di peni dendu go a döö faa sölugu de. ");
INSERT INTO srmNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nöö fa de o go a döö dë, nöö di sikafuma o ta waka a de fesi, nöö de o dë nëën baka, biga de ta sabi ën töngö. ");
INSERT INTO srmNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","“Ma ee wan oto sëmbë di nëën ta kiija de ko a de naandë, nöö de an o go nëën baka e. De o kule seei dëën, biga de an sabi wan oto sëmbë töngö möön leki di sëmbë ta kiija de.” ");
INSERT INTO srmNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sö wan woto Masa Jesosi tei lei dee sëmbë a nöngö fasi, ma nöö de an saandi a ta taki da de möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nöö di a si taa de an ta fusutan, hën a toona fan ku de möön. A taa: “Mi taki e, dee soni i si mi o fan ku unu aki, nöö tuutuu soni seei de dë e. Mi seepi wë da di dööbuka, di fii waka go dou a dee oto sikapu. ");
INSERT INTO srmNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Hii dee sëmbë dee bi buta deseei a di kamian di i si mi abi aki, nöö fufuuma sösö nöö de bi dë e. Fëën mbei dee sikafu dee dë u mi tuutuu an bi ta piki de buka. ");
INSERT INTO srmNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Mi taki da unu e, taa mi da di dööbuka da hiniwan sëmbë di sa kë pasa go a di peni dendu faa feni di heepi u Gadu. Nöö sö wan sëmbë i dë fii bööböö seei. I sa ta waka fii nango a döö toona ko, ta feni di sölugu u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Dee fufuuma dee mi bi taki dë, de ko u de ganjan dee sikapu kii poi kaba a sösö. Ma mii ko u ko da de gbelingbelin libi seei ku telu.” ");
INSERT INTO srmNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Hën a toona taki möön taa: “Mi da di möön bumbuu sikafuma u sikafu e. Biga fa mi dë aki, mi dë kabakaba u mi dëdë da dee sikafu u mi. ");
INSERT INTO srmNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma di sëmbë de ta juu u luku sikafu u de pakëën, nöö hën an o dë sö e, biga nëën abi dee sikafu. Nöö te a si taa hogi mbeti ta ko, nöö a o kule disa de naandë go fëën fiaa. Nöö di hogi mbeti o booko ko a de ko paaja de fanjanfanjan. Wan si ö? ");
INSERT INTO srmNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Di sëmbë de ta juu ta paka dë, a go fëën gaanduwe biga aan toobi ku dee sikafu. Möni nöö a ta wooko fëën. Ma mi, ma dë sö e. ");
INSERT INTO srmNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Mi taki da unu möön e, taa mi da di möön bumbuu kiijama u sikafu. Mi sabi dee sikafu u mi, nöö dee sikafu u mi seei sabi mi tu. ");
INSERT INTO srmNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Leti kumafa i si mi ku mi Tata sabi u seei bunu aki, nöö sö mi ku dee sikafu u mi sabi u seei tu, hën mbei wë mi o dëdë da de. ");
INSERT INTO srmNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Nöö mi abi oto sikafu dee an dë a di hipi aki dendu eti e, nöö deseei mi musu tja ko mökisi ku dee disi tu. Biga de o jei di töngö u mi, nöö te de jei ën nöö de o piki ko a mi, nöö woo dë wan kodo hipi sikapu ku wan kodo sikafuma. ");
INSERT INTO srmNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nöö fu di soni i si mi fan naandë, fëën hedi mbei mi Tata lobi mi sö e, fu di mi o lasi mi libi da dee sikafu u mi, fu mi toona feni ën baka. ");
INSERT INTO srmNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nöö fa mi o lasi mi libi dë, na sëmbë hën o puu ën a mi e. Nönö. Ma ku miseei kë mi o lasi ën. Nöö mi abi leti fu mi lasi mi libi, mi abi leti fu mi sa toona feni ën baka tu, biga sö mi Tata buta da mi kaa u mi musu du.” Sö Masa Jesosi fan ku dee sëmbë ta haikëën dë te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nöö fu di fan u Masa Jesosi naandë hedi mbei dee hedima u Dju kisi toobi buja te a bigi paati ku deseei. ");
INSERT INTO srmNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","So u de taa: “Di sëmbë naandë, didibi dë nëën hedi e. Hën wë poi ën sö. Faandi mbei un sai naandë ta haikëën eti?” ");
INSERT INTO srmNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Otowan taa: “Wan sëmbë di didibi dë nëën hedi, nöö a sa fan sö wan fan nö? Unfa wan didibi sa kula wan sëmbë di de pali bookobookowojo te a ko ta si soni?” ");
INSERT INTO srmNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nöö di juu dë, de ta njan wan gaan piizii a Jelusalen möön, di de ta mëni kumafa de bi toona wëi di Gaan Keikiwosu da Gadu. Nöö di ten dë da di möön kötö ten u di jaa. ");
INSERT INTO srmNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nöö hën wë Masa Jesosi ta waka a di baiko u di Wosu u Masa Gadu de ta kai di Baiko u Salumon. ");
INSERT INTO srmNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nöö hën wë aan soni, hën dee hedima u Dju ko lontu ën naandë wante. Hën de hakisi ën taa: “Womi, un longi seei joo ta bia u ta daama nango ta ko? Fan ku u limbolimbo awaa. Ee i da di di Paamusi Könu, nöö i piki u gbelin boo sabi awaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Hën Masa Jesosi piki de taa: “Wë mi bi taki ën da unu kaa, ma nöö wan bi kë biibi. Biga sömëni gaan wooko mi du a mi Tata në, nöö de ta konda gbelin ambë da mi. ");
INSERT INTO srmNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma wan kë piki möönsö. Nöö di soni mbei, fu di wan dë a dee sikafu u mi dendu. ");
INSERT INTO srmNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“Fa dee sikafu u mi sai dë nöö de sabi mi töngö e, nöö mi seei sabi de tu. Nöö de ta waka ta ko a mi baka, ");
INSERT INTO srmNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","nöö mi ta da de di libi u teego. Soni an o mbei te de sa lasi go kaba a sösö möönsö e, nöö de an sa puu de a mi maun dendu tu. ");
INSERT INTO srmNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Biga mi Tata hën da mi de, nöö hën abi di möön gaan kaakiti u mundu. Hën mbei de an sa puu de nëën maun möönsö, ˻nöö de an sa puu de a mi maun möönsö tu˼. ");
INSERT INTO srmNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Biga mi ku mi Tata dë di wan.” ");
INSERT INTO srmNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nöö fa i si Masa Jesosi fan dë, nöö hën dee hedima hati boonu wante, te de kisi sitonu mii möön u de naki ën kii. ");
INSERT INTO srmNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nöö hën Masa Jesosi fan ku de taa: “Sömëni gaan foondo wooko mi du a unu mindi u lei unu di kaakiti u mi Tata. Wë nöö fu undi u de hedi mbei un kë naki mi ku sitonu kii?” ");
INSERT INTO srmNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hën de taa: “Nönö e! Fa i si u kë naki i aki, na u dee foondo wooko fii hedi e. Ma fu di i ta sösö Masa Gaangadu, hën mbei. Biga fa i dë aki, nöö i da wan sösö libisëmbë leti kuma u, ma nöö hën i sai naandë ta pëë i seei taa i dë Gadu. Hën mbei wë u kë naki i ku sitonu kii.” ");
INSERT INTO srmNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Nöö hën Masa Jesosi piki de taa: “Wë nöö di soni dë hën bigi da unu sö nö? Wan sabi fa a sikifi a di Buku u Gadu di un taa hën ta tii libi fuunu naandë nö? A taa, Gadu bi kai so sëmbë ‘gadu’ fu di a buta de fu de kuutu nëën kamian. Sö di Buku taki, nöö ja sa puu na wan soni a di Buku. “Wë nöö ee dee sösö sinkii sëmbë dë a kai ‘gadu,’ ");
INSERT INTO srmNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nöö mi wë? Unfa un sa taki taa mi ta sösö Gadu te mi taa mi da Mii fëën? Andi mbei a ta bigi da unu sö? Biga mi Tata seei wë tei mi apaiti fëën seei vö, hën a manda mi ko a goonliba aki. ");
INSERT INTO srmNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Ma nöö fa i si mi ta fan ku unu aki seei, ma an dë fuun piki e, ee na un si mi ta du dee lö wooko dee mi Tata nöö bi sa du. ");
INSERT INTO srmNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma ee un si mi ta du de, nöö be un biibi fu de hedi e, ee wan kë piki fa mi ta fan aki. Biga te un biibi u de wooko hedi kaa, nöö woon ko fusutan taa di Tata dë a mi tuu, nöö mi dë a di Tata. Mi ku ën, sö u dë di wan.” ");
INSERT INTO srmNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nöö fa Masa Jesosi fan dë, hën de kë kisi ën panjan tja go wante, ma nöö hën a fusi kumutu a de dendu go fëën. ");
INSERT INTO srmNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nöö hën a koti go a di oto së banda u Joodan Lio ka Johanisi bi ta dopu sëmbë a fesi, ");
INSERT INTO srmNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","nöö naandë sëmbë ta ko nëën seei te a hia. Hën de taa: “A dë sö tuu, taa Johanisi an bi du na wan foondo wooko möönsö. Ma Gadu bi dë ku ën e, biga hii dee soni dee a bi taki u di sëmbë aki, de tuu dë tuu.” Sö de ta fan ku deseei. ");
INSERT INTO srmNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nöö fu di soni dë hedi mbei hia sëmbë ko biibi a Masa Jesosi a di kamian dë. ");
INSERT INTO srmNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Wë nöö di juu dë, nöö hën wan womi bi dë de kai Lazalosi, nöö hën a kai a siki. Nöö a abi tu sisa fëën: wan da Maita, di otowan da Malia. Nöö de dii sëmbë dë tuu ta dë a di köndë de kai Betania. Nöö di Malia aki sö, hën da di mujëë di o tutu di sumëë suti fatu a Masa Jesosi futu te a kaba nöö a o dëë ën ku di uwii u hedi fëën. ");
INSERT INTO srmNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nöö hën wë de tu sisa manda buka da Masa Jesosi ka a dë ala taa Lazalosi di mati fëën di a bi lobi di gaan lobi, nöö a siki teee na soni. ");
INSERT INTO srmNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nöö di Masa Jesosi jei di buka dë kaa, hën a taa: “Awa, ma di siki fëën i si aki, na dëdë o dë kaba fëën e, ma fu Masa Gaangadu kisi nëbai. Biga di Mii fëën aki o feni gaan nëbai a di soni di o pasa aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Wë nöö Masa Jesosi lobi de dii sëmbë dë gaanfa: Maita, ku Lazalosi, ku Malia. ");
INSERT INTO srmNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ma tökuseei fa a jei di buka naandë seei, ma a tan tu daka eti ufö a o go haika dee sëmbë awaa. ");
INSERT INTO srmNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nöö hën a taki da u dee bakama fëën taa: “Un seeka, boo toona go a Judea awaa e.” ˻Biga Betania da wan köndë fu Judea.˼ ");
INSERT INTO srmNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nöö hën u taa: “Wë ma Mësitë o, djunsudjunsu dë dee hedima bi kë naki i ku sitonu kii ala, nöö hën i kë fuu toona go ala möön nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nöö hën Masa Jesosi piki u a wan nöngö fasi, a taa: “Hiniwan didia ta limbo tuwalufu juu langa, nöö di sëmbë di ta waka a dee juu dë an sa naki futu kai. Biga di sonu ta tuwë limbo dëën. ");
INSERT INTO srmNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma nöö di sëmbë di ta waka a ndeti nöö hën sa naki futu biga limbo an dë. I si?” ");
INSERT INTO srmNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nöö hën a fan ku u taa: “Di mati fuu de kai Lazalosi duumi e. Ma mi o go weki ën baka.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nöö hën u taa: “Wë Masa o, wë ee a dë sö nöö an hogi poi. Biga ee duumi a duumi, nöö hën da a o bëtë.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ma nöö fa Masa Jesosi fan dë, a taki ën fu di a si taa Lazalosi dëdë kaa, ma u dee bakama fëën ta mëni taa sösö duumi nöö a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nöö hën a fan ku u limbolimbo awaa taa: “Lazalosi böö koti e. ");
INSERT INTO srmNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma nöö mi wai fuunu hedi u di a dë taa ma bi dë ala, biga di soni ta pasa aki hën o mbei un ko biibi möön taanga. Nöö un hopo seeka, boo go haika di dëdë.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nöö hën Tomasi, di de kai Tumii, taki da u dee otowan taa: “Womi, un boo go nöö e, be dee hedima kii u ku Masa Jesosi tuu makandi, ˻be de böö fuu˼.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nöö fa de fan dë, nöö hën de hopo, hën de nango teefa de go dou a di köndë. Nöö hën de ko sabi taa Lazalosi dëdë, de bei te a abi fö daka kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nöö di köndë de kai Betania dë, hën ku Jelusalen an bi dë longi tumisi. Dii kilomëti nöö de bi dë, ");
INSERT INTO srmNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","nöö hën mbei sömëni u dee hedima u Dju kumutu a Jelusalen ko a Betania u de ko këë pena ku Maita ku ën sisa Malia. ");
INSERT INTO srmNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nöö hën di Maita ko jei taa sö Masa Jesosi dë a pasi ta ko, hën a hopo wante waka go faa go miti ën a pasi. Ma Malia nöö hën a fika a wosu ala eti. ");
INSERT INTO srmNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nöö fa Maita ko dou a Masa Jesosi naandë, hën a taki dëën taa: “Ee Masa o, ee i bi dë aki, nöö di baaa u mi an bi o dëdë e. ");
INSERT INTO srmNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma nöö mi sabi taa hiniwan soni di i hakisi Gadu kaa, nöö Gadu o da i ën.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nöö hën Masa Jesosi taa: “Mujëë, na fëëë e. Di baaa fii o toona weki baka.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Hën a taa: “Aai, wë mi sabi taa a di kaba lasiti daka teee hii sëmbë o toona weki nöö hënseei o weki tu.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nöö hën Masa Jesosi piki ën taa: “Mujëë o, miseei wë disi kaa e, di ta weki sëmbë a dëdë ta da de libi. Nöö di sëmbë di ta biibi a mi, ee hën sinkii dëdë seei ma nëën da kaba u di libi fëën eti e. Biga a abi di libi u teego kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nöö hiniwan sëmbë di biibi a mi te a feni di libi dë, nöö na wan ten seei a o dëdë kaba a sösö möönsö. I ta piki di soni dë nö, mujëë?” ");
INSERT INTO srmNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hën a taa: “Aai Masa, mi ta biibi tuu taa i da di Mii u Masa Gaangadu. I da di Könu Gadu bi paamusi taa a o manda ko a di goonliba aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nöö fa de fan te de kaba naandë, nöö hën Maita toona go a wosu. Hën a kai ën sisa Malia tja go a wan së, hën a taki dëën taa: “Di Mësitë ko e, nöö a hakisi fa fii.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wë nöö di Malia jei sö taa Masa Jesosi ko, nöö hën a hopo wante nango nëën. ");
INSERT INTO srmNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Biga fa Masa Jesosi bi ko dë, nöö an bi dou a di köndë ganda eti. A fika a hafu pasi ka i si Maita bi go miti ku ën naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nöö di dee ˻hedima u˼ Dju dee bi ta këë pena ku Malia dë ko si fa a hopo hesihesi go a döö ala, nöö hën de mëni taa kandë a nango këë a di geebi ka de bei Lazalosi ala. Nöö hën de nango nëën baka. ");
INSERT INTO srmNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nöö hën Malia waka te go dou a Masa Jesosi. Nöö di a si ën, hën a hiti hënseei tuwë a goon nëën fesi dë. Hën a taa: “Ee, Masa, ee i bi dë aki nöö di baaa u mi an bi o dëdë.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nöö di Masa Jesosi si fa Malia ku dee ˻hedima u˼ Dju ta këë, nöö a fukëën nëën hati gaanfa te a fika piki an sa hoi ën seei möön. ");
INSERT INTO srmNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hën a hakisi de taa: “Wë naasë un bei di dëdë?” Hën de taa: “Masa, ko go luku nöö joo si.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nöö di ten naandë, nöö wata ta pasa a Masa Jesosi wojo. ");
INSERT INTO srmNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hën dee Dju ˻hedima˼ taa: “Dee sëmbë, un luku fa a bi lobi ën!” ");
INSERT INTO srmNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","So u de taa: “Wë nöö ma di sëmbë aki, nëën bi heepi di bookowojoma te a ko ta si soni nö? Nöö faandi mbei an bi heepi di womi aki be an dëdë?” ");
INSERT INTO srmNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nöö di de fan sö, hën Masa Jesosi toona ko dë ku fuka möön te na soni, nöö hën a waka go dou a di geebi. Nöö di geebi dë wan baaku di de bi diki a sitonu, nöö hën de logoda wan gaan sitonu tapa di geebi buka. ");
INSERT INTO srmNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nöö hën Masa Jesosi taki da de taa: “Un logoda di sitonu puu a di baaku buka e.” Nöö hën Maita, di sisa u di womi di dëdë naandë, taki taa: “Masa, nönö e. A ta tingi kaa, biga disi mbei fö daka di a dëdë.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nöö hën Masa Jesosi taki dëën taa: “Mujëë o, ma bi taki da i taa ee i ta biibi a mi, nöö joo si fa Gadu bigi nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nöö fa a fan dë, nöö hën de logoda di sitonu puu a di baaku buka awaa. Hën Masa Jesosi hopo wojo luku liba, hën a taa: “Taata o, gaantangi fii e, fu di a dë taa i ta jei mi kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nöö mi sabi tu taa hiniwanten te mi ta fan ku i nöö i ta jei mi. Ma nöö fu dee sëmbë dee taanpu aki hedi mbei mi ta fan sö e, fu de sa ko biibi tuu taa i wë manda mi ko a goonliba aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nöö fa i si a begi te a kaba dë, nöö hën a bai kai Lazalosi ku wan taanga töngö taa: “Lazalosi, hopo kumutu ko a döö!” ");
INSERT INTO srmNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nöö hën di sëmbë di i si a kai dë, hën a hopo kumutu ko e, ku dee geebi koosu lolulolu nëën sinkii eti te dou ku ën maun ku ën futu. Fesi fëën seei dë taitai ku wan hangisa. Nöö hën Masa Jesosi taki da dee sëmbë taa: “Un lusu dee koosu puu nëën sinkii, be a go.” ");
INSERT INTO srmNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wë nöö di dee ˻hedima u˼ Dju dee bi sai dë si di soni Masa Jesosi du naandë, nöö hën sömëni u de ko biibi nëën. ");
INSERT INTO srmNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma nöö so u de kule go konda da dee Faliseima taa sö wan gaan soni Masa Jesosi toona du möön. ");
INSERT INTO srmNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nöö hën wë aan soni, hën dee Gaan Begima u dee Dju ku dee Faliseima kai wan gaan kuutu hakisi ee andi de musu du möön. De taa: “Wë wa ta du. Wan si fa di bödjëëma dë ta du dee foondo wooko fëën nango nöömö nö? ");
INSERT INTO srmNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wë nöö ee wa tapëën, nöö hii sëmbë o ko biibi nëën taa hën da di könu di bi musu ko. Nöö dee sëmbë u Loomë dee ta tii u, nöö de o ko booko di köndë fuu puu u a di kamian i si u dë aki.” Nöö sö de taki. ");
INSERT INTO srmNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nöö wan womi de kai Kajafasi, hën bi da di Kaba Hei Begima a di lö ten naandë, nöö hën a taki da dee otowan taa: “Dee sëmbë aki, unfa un don sö? ");
INSERT INTO srmNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wan sabi taa a möön bunu di wan kodo sëmbë aki dëdë, möön leki hii di nasiön fuu aki tuu fiaa musu dëdë kaba a sösö nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ma nöö fa a fan dë, nöö na fan fëën seei a fan e, ma fu di hën da di Kaba Hei Begima a di ten naandë, nöö hën mbei Masa Gaangadu seei dëën di fan naandë faa konda fa Masa Jesosi o dëdë a hii Dju sëmbë kamian. ");
INSERT INTO srmNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma na Dju sëmbë wanwan nöö e, ma a o dëdë da hii dee sëmbë tuu dee o ko miii u Gadu. Fa de dë paajapaaja a hii goonliba, ma nöö a o tja de ko a di wan. ");
INSERT INTO srmNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nöö fa Kajafasi fan te a kaba dë, nöö hën dee hedima tuu piki ku ën makandi. Nöö fu kumutu a di ten naandë, nöö de ta suku fu de sa kisi Masa Jesosi tja go kii nöömö. ");
INSERT INTO srmNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hën mbei Masa Jesosi an ta waka wajaa a dee Dju sëmbë dendu möön, ma a hai go fëën te a wan kamian zuntu ku di sabana. Naandë sö a go a wan köndë de kai Efalaim ufö, hën ku u dee bakama fëën. ");
INSERT INTO srmNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nöö di juu dë, di ten ko zuntu u de toona njan di Pasika. Nöö sömëni hia sëmbë u dee boiti kamian hai ko dë a Jelusalen naandë, u de wasi a wëti fasi be de dë kabakaba fu de njan di daka. ");
INSERT INTO srmNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nöö fa de ko dë, nöö de ta tuwë wojo ta suku Masa Jesosi ee a ko. De taanpu a di Wosu u Masa Gadu ta hakisi de na de taa: “Wë dee sëmbë, unfa un mëni fëën? A o ko a di piizii aki möönsö nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nöö di soni mbei de ta hakisi sö, fu di dee Gaan Begima ku dee Faliseima bi buta kaa taa ee wan sëmbë i sabi naasë a dë, nöö i musu piki de be de kisi ën tja go a kuutu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wë nöö di a fika sikisi daka ufö di Pasika kai, nöö hën Masa Jesosi toona ko a Betania ka a bi weki Lazalosi a dëdë naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nöö di a ko, nöö hën dee sëmbë wai te de hopo tafa dëën. Nöö Maita bi dë wan u dee sëmbë ta seeka soni u njan da dee sëmbë ko dë. Nöö fa de sindo a tafa naandë, nöö Lazalosi seei dë sindosindo ku de dë tu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hën de sai dë te wan pisi hën di oto sisa u Lazalosi de kai Malia hopo go tei wan bata sumëësuti fatu. Nöö di fatu dë, de mbei ën ku wan sootu pei pau lutu nöö a dii te na soni. Nöö hën Malia tutu hii di fatu a Masa Jesosi futu te a kaba këë, nöö hën a ta dëë hën futu ku di hediuwii fëën. Nöö fa a du ën dë, nöö hii di wosu ta sumëë suti te na soni. ");
INSERT INTO srmNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nöö hën di soni dë fuka Judasi Isikaliotu te na soni. Wë di sëmbë dë, hën o sei Masa Jesosi, hii fa a dë wan bakama fëën. Nöö hën a ta guunjan taa: ");
INSERT INTO srmNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Na poi a poi di fatu dë nö? Faandi mbei de an bi sei ën, nöö de tja di möni ko da u fuu paati da dee penama u di köndë?” Biga di fatu bi dë kuma wan hafu liti sö, nöö i bi musu wooko wan hii jaa ufö i sa feni möni tjika fii bai ën. ");
INSERT INTO srmNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ma nöö fa i si Judasi fan dë, na pootima seei a ta mëni sö e, ma fu di a dë wan fufuuma nöö hën wë mbei a taki sö. Biga hën ta tja di mönisaku fuu, nöö a ta fufuu hafu u dee möni dee sëmbë ta da u. ");
INSERT INTO srmNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nöö hën Masa Jesosi taki dëën taa: “Nönö womi, un disa di mujëë e. A bi dë fanöudu faa tjubi di fatu dë tuwë a mi futu ufö di daka dou u de bei mi. ");
INSERT INTO srmNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Biga dee pootima o dë ku unu nöömö fuun sölugu, ma mi, ma o dë aki ku unu nöömö e.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nöö di juu dë, nöö sömëni u dee Dju ko jei taa Masa Jesosi dë a Betania, nöö hën de booko gililili kumutu a Jelusalen ala ko luku ën. Ma na Masa Jesosi nöö de ko u ko luku e, ma de kë si Lazalosi tu, di a bi weki a dëdë. ");
INSERT INTO srmNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nöö di soni dë mbei dee Gaan Begima fiti buka u de musu kii Lazalosi tu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Biga fëën hedi mbei sömëni u dee Dju sëmbë ta paati ku de ta biibi a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nöö di dobooko möön, hën dee hila sëmbë bi ko a Jelusalen naandë u de ko njan di Pasika ko jei taa Masa Jesosi dë a pasi ta ko. ");
INSERT INTO srmNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nöö hën de go booko palomaun te a hila, hën de kule gililili go kisi Masa Jesosi a pasi ta wai dee palomaun dëën. De ta bai a de töngö taa: Hosana! Di sëmbë ta ko a u aki, Gadu dë ku ën e! Hën da di könu fuu dee Isaëli sëmbë di u bi ta luku nöömö faa musu ko. Hën wë i si ta ko aki awaa a di në u Masa! ");
INSERT INTO srmNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nöö Masa Jesosi bi feni wan njönku buliki, hën a subi nëën liba. Nöö di buliki ta tjëën leti kumafa de bi sikifi a Masa Gadu Buku taa: ");
INSERT INTO srmNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Wan fëëë, un dee sëmbë u Sion. Un luku, hën di könu fuunu wë ta ko a unu dë e. A dë sindosindo a wan njönku buliki liba ta waka ta ko a unu. Sö di Buku bi taki kaa, nöö hën wë i si ko pasa dë. ");
INSERT INTO srmNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma nöö di juu dë, u dee bakama u Masa Jesosi wa bi fusutëën eti. A bakaten di a dëdë weki ko feni di hei di a bi musu feni a Gadu ufö u ko sabi awaa taa sö wan soni fëën bi sikifi a di Buku gaanduwe kaa, nöö hën wë i si pasa leti a u wojo dë. ");
INSERT INTO srmNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wë nöö dee sëmbë dee bi dë ku Masa Jesosi a di ten a bi weki Lazalosi a dëdë naandë, nöö de bi ta konda di soni nango nöömö teefa hii lanti ko jei ën. ");
INSERT INTO srmNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hën mbei i si dee hia sëmbë kule go miti ku Masa Jesosi naandë, fu di de bi jei taa sö wan gaan foombo soni a du. ");
INSERT INTO srmNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nöö hën dee Faliseima hai go dë a wan së gudjuu ala, go ta taki ku deseei taa: “Wë di soni aki, wa ta du seei möönsö. Biga hii mundu seei ta kule gililili nango nëën baka.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nöö fa dee hia sëmbë ko a Jelusalen naandë, nöö wanlö pei sëmbë de ta kai Giiki ko tu. De ko fu de ku dee Dju musu begi Gadu makandi, nöö de kë si Masa Jesosi tu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nöö hën de go a wan fuu dee bakama u Masa Jesosi de kai Filipi. Biga di Filipi aki, a kumutu a Betisaida, di dë wan köndë u Galilea. ˻Nöö hia Giiki sëmbë bi dë a Galilea di ten dë.˼ Nöö hën wë de go fan ku ën taa: “Wë mati, u ko a i aki e baa. U ko fuu si Jesosi, ee u sa si ën.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nöö di Filipi jei sö, nöö hën a go a Andiasi. Hën de tu sëmbë dë, Andiasi ku Filipi, hën de go a Masa Jesosi go piki ën taa: “Masa o, wanlö Giiki sëmbë ko aki nöö de kë si i.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nöö hën a piki taa: “˻Wë awa, di juu dou tuu e, fu dee oto köndë sëmbë sa ko a mi tu. Biga˼ awaa ufö di Sëmbë di ko Libisëmbë Mii aki o feni di hei di a musu feni a Gadu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nöö fu tuutuu mi taki da unu seei gbelin taa ee wan kalu sii an kai a goon te a pondi, nöö a o fika hën wanwan tö logoo dë. Ma te a kai a goon pondi toona nasi ufö a sa feni otowan kuma hënseei te a hia. ");
INSERT INTO srmNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Nöö söseei a dë ku unu tu e, dee sëmbë. Biga ee wan sëmbë ja kë saka i seei kuma di kalu sii di kai a goon naandë, ma i kë libi fii seei kumafa i kë, nöö ja o feni ën fa i kë möönsö e. Ma ee di libi fii a goonliba aki an dë gaan soni da i ˻i ta saka i seei da Gadu,˼ nöö joo feni ën fa i kë tee dou ku di libi u teego tuu. ˻Nöö hii fa mi ta taki u di kalu sii aki, nöö sö wan soni o pasa ku mi fa u dë aki.˼ ");
INSERT INTO srmNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","“Nöö ee wan sëmbë i kë ko futuboi u mi, nöö i musu ta waka a mi baka a hii futu, ˻te dou ku di dë tu˼. Biga hiniwan kamian ka mi nango nöö naandë di sëmbë ta dini mi musu go tu. Nöö ee wan sëmbë ta dini mi a sö wan fasi, nöö mi Tata o hei ën gaanfa seei.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nöö di Masa Jesosi fan sö te a kaba, hën a taa: “Dee sëmbë, hati u mi nöö dë ku fuka sö, fu di soni di o pasa ku mi aki. Wë andi seei mi musu taki maingë? Mi musu begi mi Tata faa puu mi nëën nö? Wë nönö, ma sa begi ën sö, biga fu di soni dë hedi mi dë te kisi di ten aki. ");
INSERT INTO srmNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Taata o, be sëmbë si di hei ku di kaakiti di i abi e, be di në fii bai.” Nöö fa a fan dë, nöö hën wan töngö piki kumutu a liba ala wante taa: “Mi feni në a i liba kaa e, nöö mi o toona feni në a i möön eti.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nöö dee sëmbë dee bi taanpu lontu ën naandë jei, hën so u de taa: “Wë maingë, liba hën bai sö nö?” Otowan taa: “Nönö, wan basia u Masa Gadu Köndë wë fan ku ën sö e.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nöö di Masa Jesosi jei de taki sö, hën a taa: “Dee sëmbë, fa i si un jei di töngö naandë, nöö na u mi hedi a fan e, ma fuunu hedi wë. ");
INSERT INTO srmNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Biga di juu dou kaa u di soni di Gadu o tei fu kuutu hii sëmbë u goonliba musu pasa. Awaa di takulibima di ta tii goonliba musu lasi ën kamian awaa. ");
INSERT INTO srmNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma nöö mi, fa de o hëngi mi kii aki, nöö hën o mbei mi o sa hai hii pei föluku ko a mi.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nöö fa Masa Jesosi ta fan dë, nöö pindja wë a ta pindja dee sëmbë fu de sabi un pei dëdë o kii ën. ");
INSERT INTO srmNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nöö di soni a fan dë bigi da dee sëmbë te na soni. Hën de hakisi ën taa: “Wë fa i taa i da di Sëmbë di ko Libisëmbë Mii dë, na di Paamusi Könu i ta taki nö? Wë nöö unfa i sa taki taa de o hëngi i kii? Biga a sikifi a di Buku u Gadu taa di Paamusi Könu o libi u teego. Ambë da di Sëmbë di ko Libisëmbë Mii i ta taki naandë?” ");
INSERT INTO srmNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Hën Masa Jesosi piki de taa: “Un haika e, dee sëmbë. Fa mi dë a unu mindi aki, mi ta limbo unu wojo a dee soni u Gadu eti. Nöö be un waka a di limbo dë e, biga na sö a o dë nöömö. Biga abiti möön nöö di dungu o ko, nöö di sëmbë di o ta waka a dungu an o sabi naasë a nango. ");
INSERT INTO srmNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","“Fëën mbei fa i si mi dë aki ta limbo unu wojo eti, nöö be un biibi a mi liba e, nöö unu seei o ko dë sëmbë di sa limbo oto sëmbë wojo a Gadu soni tu.” Nöö di a fan ku dee sëmbë dë sö te a kaba, hën a kumutu a de dendu go tjubi da de. ");
INSERT INTO srmNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nöö sö i ta si taa hii fa dee sëmbë si dee hia foondo wooko Masa Jesosi bi du a de fesi dë seei, ma de an kë biibi möönsö taa Gadu hën mandëën ko. ");
INSERT INTO srmNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nöö hën da a pasa sö leti kumafa di fesiten Tjabukama u Gadu de kai Jesaaja bi fan di a taa: Masa o, fa u ta konda di Buka fii aki, nöö ambë seei ta piki ën? Ambë seei ta si di gaan kaakiti fii fu de fusutëën möönsö? ");
INSERT INTO srmNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nöö sö a ko dë taa dee sëmbë dee Jesaaja taki dë, de an bi sa biibi möön e. ");
INSERT INTO srmNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Biga a toona taki a wan oto kamian möön taa: Gadu bi dungu de wojo fu de an musu si soni fëën möön. A mbei de aan fii a de hati möön u de sa fusutan soni fëën. Nöö hën Gadu taa: Fa u dë aki, de an sa piki fu de bendi ko a mi möönsö, u mi kula de puu a hogi du. Sö Masa Gadu bi manda Jesaaja fa a fan. ");
INSERT INTO srmNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nöö di soni mbei Jesaaja fan sö e. A bi si di Gadu fasi u Masa Jesosi gaanduwe kaa, ku di gaan waiti fëën di a o abi, hën mbei a këë pena a di fasi dë sö. ");
INSERT INTO srmNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma töku fa u taki ën dë seei, ma sömëni u dee hedima u Dju ko biibi nëën, ma de an kë ta tjëën wajaa a lanti u sëmbë sa sabi. Biga de fëëë dee Faliseima taa ee de jei nöö de o puu de a keiki. ");
INSERT INTO srmNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nöö sö wë i si de bi kë abi bunu në a libisëmbë möön leki fu de abi bunu në a Gadu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nöö a wan ten naandë, Masa Jesosi bi bai fan ku de a wan taanga töngö, a taa: “Ee wan sëmbë i ta biibi a mi, nöö na a mi wanwan nöö i ta biibi e. Ma i ta biibi a di Sëmbë di manda mi ko aki tu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nöö di sëmbë di ta si mi, nöö di Sëmbë di manda mi ko aki hënseei a ta si dë tu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","“Fa mi ko a goonliba aki, mi ko kuma wan faja ta tuwë limbo a dungu, nöö ee wan sëmbë ta biibi a mi nöö an sa fika a dungu e.” ");
INSERT INTO srmNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nöö hën a taa: “Ee wan sëmbë ta jei dee lei mi ta lei aki ma an kë piki de, nöö di sëmbë dë nöö ma ta kuutu ën e. Biga fa mi ko a goonliba aki, nöö ma ko u ko kuutu libisëmbë da sitaafu, ma mi ko u ko heepi de puu de a hogi basu. ");
INSERT INTO srmNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ma ee wan sëmbë an kë mi ku dee lei mi ta lei aki möönsö, nöö hii fa mi taa ma ta kuutu ën dë, ma an dë taa an o feni kuutu e. Nönö. Di kuutu fëën hën a dë kaa. Biga dee lei i si a bi jei a mi aki, deseei o kuutu ën a di kaba lasiti daka. ");
INSERT INTO srmNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Biga dee soni mi ta lei unu aki, nöö an dë taa soni u mi seei mi ta tei ta konda e. Nönö. Ma mi Tata di manda mi ko aki, hën ta buta da mi andi u mi musu taki ku unfa mi musu taki ën. ");
INSERT INTO srmNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nöö mi sabi gbelin taa dee soni dee a ta manda mi u mi konda aki, nöö de sa heepi i fii feni libi u teego. Hën wë mbei mi ta konda de gbelingbelin leti kumafa mi Tata taki da mi u mi konda.” Nöö sö Masa Jesosi fan di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nöö di juu dë, nöö di Pasika daka bi zuntu kaa faa kai. Nöö Masa Jesosi sabi taa di ten fëën ta kisi faa musu kumutu a di goonliba aki toona go nëën Tata. Wë nöö a bi lobi u dee sëmbë fëën dee bi nama ku ën apaiti, ma awaa a o lei u fa a lobi u gaanfa tjika. ");
INSERT INTO srmNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nöö hën wë di sapate woo njan makandi. Nöö di juu dë, di didibi bi buta di pakisei a Judasi di mii u Simon Isikaliotu hati kaa, faa musu sei Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nöö fa u ko a tafa dë, nöö Masa Jesosi bi sabi taa hën Tata bi dëën taki a hii soni liba kaa. A sabi taa a Gadu a bi kumutu nöö a Gadu a o toona go baka. ");
INSERT INTO srmNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nöö hën a hopo hën a puu dee liba koosu fëën nëën sinkii buta go a wan së ala, hën a tei wan duku tai nëën mindi. ");
INSERT INTO srmNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hën a tombi wata tuwë a wan gaan paabi te a kaba faa wasi u futu. Nöö hën a ta wasi u futu ta lontu ta dëë ku di duku di a bi tai nëën mindi dë. ");
INSERT INTO srmNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Te wan pisi hën a go dou a Simon Petuisi faa wasi ën futu. Hën Petuisi taa: “Ambë, Masa! Na tuu fii! Ja sa wasi mi futu.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Hën Masa Jesosi piki ën taa: “Di soni di mi ta du aki, ja o fusutëën eti e, ma bakaten ufö joo fusutëën.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Hën a taa: “Kwetikweti! Ja o feni mi futu wasi e!” Hën Masa Jesosi taki dëën taa: “Womi, haika. Ee ma wasi i futu, nöö mi ku i an o sa nama möön e.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nöö di Petuisi jei sö kaa, hën a bia piki ën awaa, taa: “Masa o, di a dë sö, nöö na mi futu wanwan fii wasi e, ma be i wasi mi futu te dou ku mi maun ku mi hedi tuu.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Hën Masa Jesosi piki ën taa: “Wë nönö, womi. Ee wan sëmbë i bi wasi kaa, nöö an dë fii toona wasi hii sinkii fii möön e, ma futu fii nöö dë u wasi ee a sundju. Nöö fa un dë aki, uun dë limbolimbo kaa, ma nöö na hii unu tuu e.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nöö di soni mbei a taa na u tuu dë limbolimbo, biga a sabi undi fuu o sei ën. ");
INSERT INTO srmNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nöö hën di a wasi u futu te a kaba, hën a toona go tei dee koosu fëën bisi baka, hën a go sindo a tafa awaa. Hën a hakisi u taa: “Wë dee sëmbë o, di soni mi du aki, un saandi nö? ");
INSERT INTO srmNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wë un haika e. Fa un dë aki, un ta kai mi ‘Mësitë’ ku ‘Masa,’ nöö un a’ leti biga sö mi dë tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wë nöö ee mi dë di Masa ku di Mësitë fuunu, nöö hën mi saka miseei sö te mi wasi futu fuunu, wë nöö unu wë? Na sö fuun du tu nö? ");
INSERT INTO srmNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Biga di soni mi du da unu dë, nöö mi du ën fuun sa djeesi mi ta du sö tu. ");
INSERT INTO srmNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“Biga mi taki da unu gbelin taa wan futuboi an sa hei möön hën masa. Söseei tu wan bosikopuma an sa hei möön di sëmbë di dëën di buka. ");
INSERT INTO srmNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wë nöö te un ko sabi dee soni mi ta lei unu aki ta du de kaa, nöö Gadu o ta dë ku unu e. ");
INSERT INTO srmNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ma fa mi ta fan aki seei, nöö na hii unu tuu o dë a di fan mi ta fan aki dendu e. Biga mi sabi unu tuu hati fa un dë. Ma töku mi bi pii unu tei nöö, fu di soni di sikifi a di Buku u Gadu musu ko tuu taa: Di sëmbë mi ku ën sindo ta njan a wan tafa, hënseei hopo ën futu makisa mi. Sö di Buku taki. ");
INSERT INTO srmNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nöö mi ta kondëën da unu a fesi, fu te a ko pasa nöö woon biibi taa mi da di Sëmbë di mi bi ta konda da unu nöömö taa mi dë. ");
INSERT INTO srmNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Nöö un haika e. Mi o manda unu kuma tjabukama u mi, nöö mi taki da unu tuutuu taa di sëmbë di tei unu nöö miseei a tei dë e. Nöö di sëmbë di tei mi kaa, nöö a tei di Sëmbë di manda mi ko a goonliba aki tu.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nöö fa Masa Jesosi fan naandë, nöö hën wan gaan fuka ko nëën liba, hën a fan ku u limbolimbo. A taa: “Un haika e. Wan tuutuu soni mi o fan ku unu aki, dee sëmbë. Wan fuunu dë leti aki o tja mi go sei.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nöö di a taki sö kaa, nöö hën u tuu luku u seei lontu ko kai. Nöö a bigi da u poi, biga wa sabi undi fuu a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nöö wan fuu bi dë gaan mati u Masa Jesosi möön de oto, nöö a dë sindosindo leti a Masa Jesosi bandja dë. ");
INSERT INTO srmNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nöö hën Simon Petuisi njan wojo dëën faa hakisi Masa Jesosi ee undi fuu a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hën di womi pusa ko möön zuntu ku ën hën a taa: “Masa, undi fuu seei dë aki sa du di soni dë baa?” ");
INSERT INTO srmNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nöö hën a piki ën taa: “Fa i si mi o tuusi di bëëë a di baafu aki, nöö di sëmbë di mi o tëndëën da, nöö hën dëën e.” Nöö hën a tei di bëëë hën a tuusi ën a di baafu nöö hën a tëndëën da Judasi Isikaliotu, di mii u wan tata de kai Simon. ");
INSERT INTO srmNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nöö fa Judasi tei di bëëë dë, nöö wante hën di didibi subi nëën. Nöö hën Masa Jesosi taki dëën taa: “Womi, di soni di i si i ta pakisei fii du dë, nöö hopo go du ën wante e.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma nöö fa u dee oto bakama dë sindosindo dë, nöö na wan fuu sabi faandi mbei Masa Jesosi fan ku ën sö. ");
INSERT INTO srmNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","So fuu mëni taa, awa, wë di Judasi hën ta tja di mönisaku da u, nöö a kandë Masa Jesosi mandëën faa go bai soni fuu njan di daka. Ee nasö kandë a musu tja möni go da dee penama u di köndë. Sö u bi pakisei. ");
INSERT INTO srmNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nöö di Judasi tei di bëë, nöö hën a hopo go a döö wante. Nöö di ten naandë ndeti ko kaa. ");
INSERT INTO srmNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nöö di Judasi go kaa, hën Masa Jesosi fan ku u dee otowan fika ku ën naandë taa: “Söö. Wë dee sëmbë, awaa di juu dou e, fu Mi di ko Libisëmbë Mii aki musu feni nëbai. Nöö na di dë nöö, ma a di soni di o pasa ku mi aki, nöö Gadu seei o feni nëbai tu. ");
INSERT INTO srmNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nöö fu di a o feni nëbai a mi, nöö hënseei o buta mi di Mii fëën aki ko feni möön hia nëbai eti, nöö wantewante seei a o du ën.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nöö hën a taa: “Dee mii o, a fika wan sati ten nöö fu mi ku unu dë aki eti. Woon ta hangi mi, ma wan o si mi möön. A o dë leti kumafa mi bi fan ku dee hedima kaa, nöö söseei mi o toona fan ku unu aki taa ka mi o go nöö wan o sa ko dë. ");
INSERT INTO srmNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Nöö fa mi nango aki, nöö mi o manda unu a wan njunjun soni e. Wan si fa mi lobi unu nö? Wë nöö sö un musu lobi unu seei tu. ");
INSERT INTO srmNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Biga te un ta lobi sö kaa, nöö hii sëmbë o si taa bakama u mi gbelin un dë e.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nöö hën Simon Petuisi hakisi ën taa: “Wë Masa o, naasë seei joo go disa u baa?” Hën a piki ën taa: “Ka mi o go di pasi aki, nöö ja o sa ko ku mi eti, ma te bakaten ufö.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nöö hën Petuisi toona hakisi ën möön taa: “Ma wë Masa, faandi mbei ma sa ko ku i wante? Biga mi dë seei kabakaba fu mi lasi mi libi da i.” ");
INSERT INTO srmNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nöö hën Masa Jesosi piki ën taa: “Awa, i taa i sa lasi i libi da mi. Ma nöö haika. Fu tuutuu mi taki da i womi, taa ganian an o bai kanda seei di ndeti aki, ufö joo fia dii toon taa ja sabi mi.” Sö Masa Jesosi fan ku Simon Petuisi te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nöö hën Masa Jesosi bia fan ku hii u dee bakama fëën tuu awaa, a taa: “Dee mii o, wan musu dë fukafuka e. Un ta futoou Gadu kaa, nöö un musu futoou mi tu. ");
INSERT INTO srmNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Biga ka mi Tata ta dë nöö kamian u libi sai dë te a hia. Ee an bi dë sö, nöö mi bi o taki ën da unu. ");
INSERT INTO srmNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nöö mi o go ala go seeka kamian da unu te mi kaba, nöö mi o toona ko tei unu, be mi ku unu dë makandi ala. ");
INSERT INTO srmNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nöö fa mi ta fan aki, un sabi di pasi u go dou ka mi nango, nasö nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nöö hën Tomasi piki ën taa: “Wë Masa o, wa sabi naasë i nango seei, nöö unfa u sa du sabi di pasi baa?” ");
INSERT INTO srmNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Hën Masa Jesosi piki ën taa: “Womi, miseei wë da di pasi ku di tuu, ku di libi. ˻Biga a mi nöö i sa feni di libi u teego ku dee tuutuu soni dee an dë ganjan.˼ Nöö na wan sëmbë sa dou a mi Tata e, ee na mi tja i go nëën. ");
INSERT INTO srmNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nöö ee un bi sabi mi tuu kumafa mi dë, nöö un bi o sabi mi Tata tu. Nöö fu kumutu a di ten aki, un sabi ën e, biga un si ën kaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nöö hën Filipi taa: “Masa o, lei u di Tata nöö a tjika kaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Hën Masa Jesosi taa: “Ma womi Filipi, fu di ten mi dë ku unu aki, nöö ja sabi mi eti nö? Ja sabi taa di sëmbë di si mi, nöö mi Tata a si naandë kaa nö? Unfa i sa taki taa mi musu lei i di Tata möön? ");
INSERT INTO srmNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ja kë biibi taa mi ku mi Tata dë di wan nö? Biga dee lei mi ta lei aki, nöö na mi abi de e, ma mi Tata hën abi de, nöö hën dë a mi ta wooko a mi liba. ");
INSERT INTO srmNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Biibi mi e baa, taa mi ku mi Tata dë di wan. Ma nöö ee di fan u mi taanga da i poi fii piki, nöö be i biibi mi nöö u dee foondo wooko dee i bi si mi ta du. ");
INSERT INTO srmNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Nöö tuutuu soni mi ta taki da unu aki e, taa ee un abi biibi a mi liba nöö unu seei o ta du dee wooko mi ta du tu. Nöö möön gaan wooko seei woon sa du eti, biga mi nango a mi Tata. ");
INSERT INTO srmNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nöö fa mi nango aki, nöö hiniwan soni di un ta hakisi mi Tata a mi në, nöö mi o ta du ën da unu. Nöö a di fasi dë mi, di Mii fëën aki, o tja nëbai ko da mi Tata. ");
INSERT INTO srmNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","“Nöö mi taki da unu wan pasi möön e, taa hiniwan soni di un hakisi mi a mi në nöö mi o du ën da unu e, dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nöö un haika e. Ee wan sëmbë i lobi mi, nöö joo du dee soni dee mi ta manda i fii du. ");
INSERT INTO srmNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nöö fa mi o go aki, nöö mi o begi mi Tata be a manda wan oto Sëmbë ko da unu, faa taanpu ku unu ta heepi unu. Nöö di Sëmbë i si dë, hën an o disa unu möönsö. Unu ku ën o dë fu nöömö. ");
INSERT INTO srmNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nöö i sabi ambë dëën nö? Di Akaa u Gadu wë e, di ta lei unu soni gbelin kumafa a dë tuutuu, nöö hën wë mi o manda da unu. “Ma nöö fa i si a o ko dë, nöö dee sëmbë u di goonliba aki dee an dë ku mi a wan së, nöö de an o tei ën u soni e. Biga de an o si ën u de fusutëën seei, de an o sabi ën. Ma uun sabi ën kaa, biga a ta dë ku unu fa u dë aki nöö abiti möön a o dë a unu hati ta tii unu. Un si? ");
INSERT INTO srmNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nöö fa mi nango aki, ma o disa unu a zengezenge kuma miii di na a’ mama ku tata e, ma mi o toona ko a unu baka. ");
INSERT INTO srmNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A fika wan sati ten eti, nöö dee sëmbë u di goonliba aki an o si mi möön, ma unu woon toona si mi baka. Nöö fu di mi o toona libi baka nöö söseei unu seei o toona libi baka tu. ");
INSERT INTO srmNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nöö a di ten dë ufö woon ko fusutan gbelin taa mi ku mi Tata an dë paatipaati möönsö, di wan nöö u dë. Söseei tu woon ko si taa mi ku unu an dë paatipaati, di wan nöö u dë. ");
INSERT INTO srmNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Nöö mi taki e, di sëmbë di sabi andi ku andi mi mandëën faa du nöö a ta piki mi buka, nöö di sëmbë dë, hën lobi mi e. Nöö ee wan sëmbë i lobi mi sö, nöö söseei mi Tata o lobi i tu. Nöö miseei o lobi i, nöö mi o hopo miseei da i fii sa ko sabi mi.” ");
INSERT INTO srmNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nöö fa a fan dë, hën Judasi hakisi ën soni, ma na di de kai Isikaliotu e. A hakisi taa: “Wë Masa o, faandi mbei u nöö joo hopo i seei da, ma ja o hopo i seei da hii mundu?” ");
INSERT INTO srmNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Hën Masa Jesosi piki ën taa: “Di soni mbei nö? Haika e. Di sëmbë di lobi mi, nöö hën o ta piki mi buka a soni, nöö hën mi Tata o lobi. Nöö mi ku mi Tata o ko tan ku ën nöö woo hopo u seepi dëën. ");
INSERT INTO srmNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma nöö ee wan sëmbë an lobi mi, an ta piki mi buka, ˻unfa mi sa du hopo miseei dëën? Biga hën da a ta sösö mi, nöö na mi wanwan nöö a ta sösö, ma a ta sösö mi Tata tu. Biga˼ dee soni mi ta konda aki, de an dë soni u mi e, ma de dë u mi Tata di manda mi ko aki. ");
INSERT INTO srmNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nöö hii dee soni aki sö tuu mi ta fan ku unu e baa, fu di mi dë ku unu aki eti. ");
INSERT INTO srmNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma te mi go, nöö mi Tata o manda di Akaa fëën ko da unu a mi në. Nöö hën o ta lei unu hii soni. Fa i si a o ko dë, hii dee soni dee mi ta fan ku unu aki tuu kaa a o toona mbei un ko sabi de baka. ");
INSERT INTO srmNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nöö fa mi nango aki, di soni di mi ta disa da unu aki, hën da kötöhati. Nöö an o dë kuma di kötöhati i ta feni a goonliba aki e. Nönö. Ma a o dë wan gbelingbelin kötöhati kuma di miseei abi aki. Hën mbei wan musu ta dë fukafuka fëëëfëëë e, baa. ");
INSERT INTO srmNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Wë dee sëmbë, un jei fa mi bi taki da unu naandë taa mi o go ma mi o toona ko a unu baka. Wë ee un lobi mi tuutuu, nöö misikuma a sa suti da unu fu di a dë taa mi nango a mi Tata. Biga mi Tata hei möön mi. ");
INSERT INTO srmNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Nöö mi ta konda dee soni aki da unu a fesi e, fu tee di juu dou de ko pasa, nöö woon ta biibi möön taanga. ");
INSERT INTO srmNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma nöö ma sa fan ku unu möön longi e baa, biga di hedima u di goonliba aki ta ko kaa, faa ko du ku mi. Ma fa i si a ta ko dë seei, ma an o feni na wan wojo soni a mi faa musu a’ leti a mi liba. ");
INSERT INTO srmNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma nöö fu di dee sëmbë u di goonliba aki musu ko sabi gbelin taa mi lobi mi Tata, fëën mbei baa ma ta biinga u mi puu miseei, ma mi ta hoi miseei tololoo a dee soni dee mi Tata buta da mi fu mi du. Da sö e, dee sëmbë. “Wë nöö un hopo boo kumutu aki go.” ");
INSERT INTO srmNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Biga mi da di tuutuu doloifi pau, nöö mi Tata hën da di sëmbë di abi di goon. ");
INSERT INTO srmNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nöö unu da dee maun u di pau. Wë nöö ee wan u dee maun u mi an ta pai, nöö mi Tata o djafu ën puu. Ma hiniwan maun di ta pai, nöö a o ta seekëën djafu faa musu toona pai möön hia njanjan. Sö e. ");
INSERT INTO srmNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Ma nöö fa u dë aki, uun dë seekaseeka kaa e, fu di un tei dee fan mi bi fan ku unu. Nöö mi taki e baa, taa un fika namanama ku mi nöömö ˻u di kaakiti u mi musu dë a unu˼. ");
INSERT INTO srmNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Biga un sabi taa ee wan paumaun an dë namanama a di pau sinkii nöö an o sa pai. Nöö sö nöö a dë ku unu tu e. Ee wan fika namanama ku mi, nöö wa o pai dee fuuta dee un musu pai. ");
INSERT INTO srmNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mi taki e, mi da di doloifi pau, nöö unu da dee maun u mi. Di sëmbë di i si ta fika namanama ku mi u di kaakiti u mi musu feni pasi wooko nëën, nöö a o dë kuma wan fuuta pau di ta pai njanjan te a hia. Biga söndö mi ja sa du na wan bumbuu soni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","“Ee wan sëmbë an fika namanama ku mi, nöö a dë leti kuma wan paumaun di an ta pali. Dee lö maun dë, de ta djafu de puu tuwë go a wan së ala be de dëë. Nöö te wan pisi nöö de ta pii de tuwë a faja tjuma. ");
INSERT INTO srmNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Ma ee un fika namanama ku mi fu di lei di mi ta lei unu aki ta feni pasi wooko a unu libi, nöö un sa hakisi hiniwan soni di un kë nöö woon feni ën e. ");
INSERT INTO srmNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nöö a di fasi dë mi Tata o feni gaan nëbai e, dee sëmbë, ee di libi fuunu ta pai hia fuuta dëën. Nöö sëmbë o si tu taa unu wë da bakama u mi tuutuu. ");
INSERT INTO srmNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Wë nöö mi taki da unu e, taa leti kumafa i si mi Tata lobi mi aki, nöö sö nöö miseei lobi unu tu e baa. Nöö be un ta fika a di kamian ka di lobi u mi sa dou a unu. ");
INSERT INTO srmNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nöö un sabi fa fuun sa du fuun fika sö nö? Un musu ta piki mi buka a dee soni mi ta manda unu. Nöö ee un du sö, nöö woon ta si di lobi u mi nöömö, leti kumafa mi ta si di lobi u mi Tata, fu di mi ta piki ën buka a dee soni a ta manda mi. Sö e. ");
INSERT INTO srmNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nöö di soni mbei mi ta fan dee soni aki ku unu, fu di mi kë u di wai mi abi a mi hati aki musu dë a unu hati tu. Nöö mi kë u di wai dë musu dë ku telu fu nöömö. ");
INSERT INTO srmNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Nöö mi o manda unu a wan soni aki, dee sëmbë. Un musu ta lobi unu na unu e, leti kumafa i si mi ta lobi unu aki. ");
INSERT INTO srmNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Biga na wan sëmbë sa lobi sëmbë ku sö wan gaan lobi kuma di sëmbë di o lasi ën libi fëën mati hedi. Un si? ");
INSERT INTO srmNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nöö mi ku unu o dë mati, ee un ta du dee soni dee mi ta manda unu fuun ta du. ");
INSERT INTO srmNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Fa u dë aki ma ta kai unu futuboi möön e. Biga wan futuboi an ta sabi soni fëën masa wan bëtë. Ma mati mi ta kai unu. Biga hii dee soni dee mi jei a mi Tata tuu mi tei konda da unu finifini. ");
INSERT INTO srmNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nöö fa i si un ko dë mati u mi aki, na unu wë bi tei mi e, ma mi bi pii unu tei. Nöö mi buta unu fu di libi fuun musu pai hia fuuta di o tan fu nöömö. Nöö te a dë sö kaa, nöö hiniwan soni di un hakisi mi Tata a mi në, nöö a o da unu ën. ");
INSERT INTO srmNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Nöö mi ta manda unu taa be un ta lobi unu na unu e, baa. ");
INSERT INTO srmNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Biga fa dee sëmbë u goonliba sai dë, de an dë ku Gadu a wan së, nöö de an o lobi unu möönsö. De o buuse unu seei. Ma nöö an musu dë gaan soni da unu e, biga un musu mëni taa mi fosu de bi buuse kaa bifö unu. ");
INSERT INTO srmNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ee un bi dë ku de a wan së, nöö de bi o lobi unu seei kuma sëmbë u de. Ma wan dë sö, biga mi pii unu puu a de dendu tja ko buta a mi së, nöö hën mbei de an sa si unu a wojo seei. ");
INSERT INTO srmNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","21","“Wan mëni fa mi bi fan ku unu möön nö, taa wan futuboi an hebi möön hën Masa. Wë nöö leti kumafa i si sëmbë ta sitaafu mi aki, nöö sö nöö de o ta sitaafu unu tu fu mi hedi. Nöö di soni mbei de o du sö, fu di de an sabi taa Masa Gadu hën manda mi ko a goonliba aki. Ma nöö kumafa i si so sëmbë dë a de dendu ta piki mi buka, nöö sö nöö de o ta piki unu buka tu e. ");
INSERT INTO srmNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Fa dee sëmbë dee an dë ku Gadu a wan së sai dë, ee ma bi ko a goonliba aki ko fan ku de, nöö an bi o dë taa de du hogi. Ma nöö fa u dë aki, de an sa fia. Biga mi fan ku de kaa, nöö hën de buuse mi seei. ");
INSERT INTO srmNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nöö ee wan sëmbë buuse mi, nöö mi Tata seei a buuse tu e. ");
INSERT INTO srmNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ee ma bi du gaan foombo soni a de dendu di na wan sëmbë u goonliba aki bi sa du, nöö an bi o dë hogi sö ee de an kë piki mi. Ma mi du de, de si, ma tökuseei de ta buuse mi ku mi Tata tuu. Fëën mbei di zöndu u de hebi sö. ");
INSERT INTO srmNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Ma nöö fa i si di soni ta pasa aki sö, nöö a kai ku di soni di dë sikifisikifi a di Buku u Gadu, di de taa de ta tei ta tii libi u de naandë. Biga a taa: De ta buuse mi seei, ma an dë taa soni wë mi du de e. ");
INSERT INTO srmNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ma nöö te mi o go a mi Tata, nöö mi o manda di Sëmbë mi bi taki dë da unu e, faa ko taanpu ku unu. Hën da di Akaa di ta mbei sëmbë ko sabi hii soni gbelingbelin leti fa a dë. A Gadu seei a o kumutu, nöö a o ta konda soni u mi. ");
INSERT INTO srmNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nöö unu seei o ta konda soni u mi tu, biga a seti u di wooko hën mi ku unu bi dë kaa fu te kisi fa u dë aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Hën Masa Jesosi ta fan ku u dee bakama fëën eti, a taa: “Dee sëmbë o, mi ta konda dee soni aki da unu a fesi e, fu bakaten wan musu buuja te un disa u biibi a mi liba. ");
INSERT INTO srmNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Biga dee hedima o puu unu a dee keiki u de. A o ko dë sö taa kii seei de o ta kii unu, nöö de o ninga taa Gadu wë de ta heepi fa de ta du dë. ");
INSERT INTO srmNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ma di soni mbei de o du sö, fu di de an sabi mi Tata, nöö de an sabi ambë da mi tu. ");
INSERT INTO srmNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nöö mi ta konda dee soni aki da unu a fesi, fu te di juu dou de ko pasa nöö an o bigi da unu poi. Biga woon toona mëni taa sö mi bi taki da unu kaa. “Nöö ma bi ta konda dee soni aki da unu fu di mi bi dë ku unu eti. ");
INSERT INTO srmNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ma awaa mi o toona go a di Sëmbë di manda mi ko aki baka. Ma nöö na wan fuunu ta hakisi mi möönsö ee naasë mi nango. ");
INSERT INTO srmNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ma fu di mi ta fan dee soni aki ku unu, nöö mi si taa hati fuunu dë fukafuka te na soni. ");
INSERT INTO srmNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Ma mi taki da unu gbelin, dee sëmbë, taa a dë wan gaan heepi da unu fa i si mi nango aki. Biga ee ma go, nöö di Akaa u Gadu di mi o manda u ko taanpu ku unu, nöö an o sa ko e. Ma te mi go kaa, nöö mi o mandëën da unu. ");
INSERT INTO srmNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nöö te a ko, nöö a o ta lei dee goonliba sëmbë aki taa de an saandi da hogilibi e, de an saandi da letilibi, de an sabi u wegi soni kuutu tu. ");
INSERT INTO srmNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“Nöö di soni mbei mi taa de an saandi da hogilibi, biga de an kë biibi mi möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nöö di soni mbei mi taa de an saandi da letilibi, biga mi libi leti tee mi sa toona go a mi Tata ka dee libisëmbë u goonliba aki an sa si mi möön seei. Sö mi libi leti tjika, ma de an si ën möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nöö di soni mbei mi taa de an sabi u wegi soni. Wë biga Gadu kuutu di hedima u de te a buta dëën taa a o feni sitaafu u nöömö, ˻ma töku de ta waka nëën baka eti˼. ");
INSERT INTO srmNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Wë mi abi hia soni möön u konda da unu e, dee sëmbë, ma wan o sa fusutan de eti. ");
INSERT INTO srmNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma te di Akaa ko, di ta lei soni leti kumafa a dë ˻a Gadu wojo˼, nöö a o mbei i ko sabi hii soni kumafa a dë. Biga fa a o ko naandë, an o tei soni fëën seei konda, ma dee soni dee a jei a mi ku mi Tata, nöö de a o ta taki. Nöö a o fan ku unu a dee soni liba dee dë u ko eti. ");
INSERT INTO srmNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","“Fa a o ko dë, nöö a o mbei un si di hei ku di nëbai di mi abi e. Biga a o ta tei dee soni u mi ta konda da unu finifini fuun sabi de. ");
INSERT INTO srmNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nöö hii soni di mi Tata abi dë u mi kaa, hën mbei mi taa di Akaa o tei a dee soni u mi faa lei unu.” ");
INSERT INTO srmNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Hën Masa Jesosi toona taki da u möön taa: “Abiti möön wan o si mi möön baa, ma nöö te wan pisi woon toona si mi baka.” ");
INSERT INTO srmNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Nöö hën di u jei a taki sö, hën u bia ta hakisi u na u makandi taa: “Womi, andi da di soni di a ta fan naandë taa abiti möön wa o si ën möön, ma te wan pisi nöö woo toona si ën baka? Andi a ta fan dë taa a nango nëën Tata? Andi seei a kë taki di a taa ‘Abiti möön’? Wa saandi a ta taki e.” ");
INSERT INTO srmNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nöö hën Masa Jesosi si taa u kë hakisi ën soni fëën, hën a taa: “Fa un ta fan ku unu seei sapisapi naandë, fu di mi taki taa abiti möön wan o si mi möön, nöö te wan pisi woon toona si mi baka, hën ta toobi unu sö nö? ");
INSERT INTO srmNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wë un haika e. Fu tuutuu mi taki da unu gbelin taa dee sëmbë dee an dë ku mi a wan së, de o ta wai seei, ma unu, woon dë ku gaan fuka ta këë ta kusumi te na soni. Ma nöö wan fëëë e. Di fuka i si woon ta fuka naandë o bia ko wan gaan wai seei da unu. ");
INSERT INTO srmNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Wan sabi fa a dë te wan mujëë dë ku bëë nö? Te di juu fëën kisi faa pali, nöö di bëë ta njan mën seei, ma te a pai kaa nöö an ta mëni di fuka naandë möön. Wai nöö a ta wai fu di a pai wan mii. ");
INSERT INTO srmNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","“Nöö sö nöö a o dë ku unu tu e baa. Fa i si un sai naandë, nöö un dë ku gaan fuka seei a unu hati fu di mi taa mi nango. Ma mi o toona si unu baka e, nöö di juu dë woon bia ta wai seei. Nöö na wan sëmbë o sa puu di wai dë a unu hati möön. ");
INSERT INTO srmNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nöö di juu naandë, nöö wan o ta hakisi dee lö hakisi dë möön tu. “Nöö mi taki e baa, taa hiniwan soni di woon begi mi Tata a mi në, nöö woon feni ën e. ");
INSERT INTO srmNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Te kisi kumafa u dë aki, wan hakisi na wan soni a mi në eti. Ma nöö fuun seti hakisi awaa nöö woon feni, nöö di wai fuunu o ko dë telutelu awaa. ");
INSERT INTO srmNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Dee sëmbë o, fa mi ta fan ku unu aki, nöö mi ta fan ku unu a nöngö fasi nöö. Ma nöö wan juu o ko di ma o ta konda soni da unu a sö wan fasi möön. Ma mi o ta fan ku unu limbolimbo seei awaa ta lei unu soni u mi Tata. ");
INSERT INTO srmNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nöö di juu dë, nöö unu seei o ta begi ën soni awaa a mi në. An o dë u mi nöö musu ta begi ën da unu möön. ");
INSERT INTO srmNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Biga mi Tata lobi unu, fu di un lobi mi nöö un ta biibi taa nëën mi kumutu ko aki. ");
INSERT INTO srmNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nöö sö a dë tuu e. Biga a mi Tata mi kumutu ko a goonliba aki, nöö awaa mi o toona go nëën baka.” ");
INSERT INTO srmNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nöö di a fan sö, nöö hën u taa: “Aaa, u si taa i ta fan ku u limbolimbo awaa tuu. Ja ta fan ku u a nöngö fasi möön. ");
INSERT INTO srmNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nöö u ko si tu taa an dë fanöudu fu wan sëmbë musu hakisi i soni biga i sabi hii soni kaa. Hën mbei u ta biibi taa a Gadu i kumutu ko.” ");
INSERT INTO srmNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Hën a piki u taa: “Awa, un ta biibi tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ma nöö un haika e. Wan juu o ko nöö a ta ko seei zaaa kaa, di unu tuu seei o paaja disa mi wanwan tö. Hiniwan fuunu o go fëën nëën wosu. Ma nöö ma ta dë mi wanwan möönsö e, biga mi Tata ta dë ku mi nöömö. ");
INSERT INTO srmNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Sö wë e, dee sëmbë. Mi tei dee soni aki konda da unu baa, fuun sa abi kötöhati fu di un nama ku mi. Biga a di goonliba aki fuka ku sitaafu dë nëën. Ma wan lasi hati e, biga mi wini hii soni a di goonliba aki kaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nöö di Masa Jesosi fan sö ku u te a kaba kaa, nöö hën a hopo wojo luku liba. Hën a taa: “Wë Taata o, ja si di juu dou. Nöö mi begi i taa a di soni di o pasa aki, nöö fii mbei dee sëmbë u goonliba aki ko si di waiti di dë a di Mii fii aki e, nöö di waiti di i seei abi o ko a döö tu. ");
INSERT INTO srmNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wë biga i da mi taki a hii sëmbë liba kaa, fu mi sa da dee sëmbë dee i da mi di libi u teego. ");
INSERT INTO srmNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nöö andi da di libi u teego? Hën da u de ko sabi i, di wan kodo tuutuu Gadu u mundu ku mi, Jesosi Keesitu, di i manda ko a goonliba aki. ");
INSERT INTO srmNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Nöö fa i manda mi ko aki, nöö mi mbei libisëmbë si di hei ku di waiti di i abi o. Biga di wooko di i da mi u mi du nöö mi kabëën. ");
INSERT INTO srmNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Wë nöö di i si a dë sö kaa, nöö be mi toona ko a i e, Taata, u mi sa toona feni di hei ku di waiti baka di mi ku i bi abi makandi ufö di goonliba aki mbei. ");
INSERT INTO srmNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Wë nöö luku dee sëmbë aki dee i tei a dee oto sëmbë u goonliba dendu da mi. Mi mbei de ko sabi fa i dë e. De bi dë fii kaa, nöö hën i tei de hën i da mi de. Nöö de an disa dee wöutu fii e, Taata. De piki de hoi seei. ");
INSERT INTO srmNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nöö hën mbei de ko sabi gbelin taa hii dee soni dee i da mi, nöö a i de tuu kumutu. ");
INSERT INTO srmNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Biga mi konda dee wöutu fii da de, nöö de tei de. Nöö hën wë de ko sabi gbelingbelin taa aai, a i mi kumutu. De biibi seei taa i manda mi ko aki. ");
INSERT INTO srmNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nöö fa mi ta begi i aki, Taata, nöö mi ta begi da dee sëmbë dee i da mi aki. Ma ta begi da dee oto sëmbë u goonliba dee an dë ku u a wan së e. Nönö. Biga dee i si aki, nöö de wë da fii. ");
INSERT INTO srmNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Biga hii dee soni mi abi, nöö de dë fii, nöö hii soni i abi nöö de dë fu mi. Nöö fa i si dee disi dë aki, nöö de o ta mbei oto sëmbë si di waiti di mi abi, ˻hën wë mbei mi ta begi da de sö˼. ");
INSERT INTO srmNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Biga ma o dë a goonliba aki möön. Mi ta ko a i kaa, ma de o dë aki eti. Taata, fa i si i dë fii limbolimbo söndö föutu dë, nöö i tjubi dee sëmbë dee i da mi aki ku di kaakiti u di në fii o, be de dë di wan makandi leti kumafa mi ku i dë di wan aki. ");
INSERT INTO srmNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“Hii di ten mi bi dë ku dee sëmbë aki, nöö mi bi ta tjubi de ku di kaakiti fii në. Mi bi ta luku de seei fu de an kumutu a di pasi. Fëën mbei na wan u de lasi, boiti di hogi wan di i si fasi fëën tjëën go kaba a sösö naandë, u di soni di Buku fii taki musu ko tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ma nöö awaa mi ta ko a i, Taata. Nöö mi ta fan dee soni aki fu di mi dë a goonliba eti. Biga mi kë u dee sëmbë aki musu abi di wai di mi abi aki tuu ku telu a de hati. ");
INSERT INTO srmNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Hii di juu ten mi dë ku de aki, nöö mi bi ta da de dee wöutu fii, hën mbei dee oto sëmbë u di goonliba aki ta buuse de sö. Biga de an dë ku de a wan së a dee hogi de ta du, leti kumafa i si miseei an dë ku de a wan së tu. ");
INSERT INTO srmNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Ma nöö ma ta begi fii puu de a goonliba e. Nönö. Ma mi kë fii tjubi de be di didibi an musu wini de. ");
INSERT INTO srmNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Biga na sëmbë u di goonliba aki de dë möön e, leti kumafa mi seei an dë sëmbë u di goonliba aki tu. ");
INSERT INTO srmNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nöö mi begi i, Taata, fii lei de di Wöutu fii, be de si soni gbelingbelin kumafa a dë tuutuu, nöö de o ko dë apaiti da i söndö föutu. Biga di Wöutu fii hën da di Tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","“Nöö leti kumafa i si i manda mi ko a goonliba aki, nöö sö nöö mi ta manda dee sëmbë aki go a goonliba tu, ˻fu de ta lei sëmbë soni fii˼. ");
INSERT INTO srmNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nöö fu de hedi mi ta buta miseei ku telu a i maun fu de si, nöö deseei o buta deseei ku telu a i maun tu söndö ganjan. ");
INSERT INTO srmNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ma nöö na dee sëmbë aki nöö mi ta begi da e, Taata. Ma mi ta begi da dee sëmbë tu dee o jei di buka a de nöö de bia ko biibi. ");
INSERT INTO srmNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Taata o, mi begi i gaantangi, be de tuu ko dë wan makandi e, leti kumafa mi ku i dë wan aki. Sö u ku de tuu musu dë wan makandi. Biga ee a dë sö kaa, nöö dee oto sëmbë u goonliba o ko sabi awaa taa aai, i manda mi ko aki tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Fa mi ku i dë aki, i bi da mi sö wan hei taa mi ku i sa dë di wan. Nöö mi ta toona da dee i si aki di wan seei hei dë tu, fu de dë di wan makandi. ");
INSERT INTO srmNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nöö mi o dë a de dendu, nöö joo dë a mi dendu, nöö sö u tuu o dë di wan makandi. Nöö te a ko sö kaa, nöö dee oto sëmbë u goonliba o ko sabi gbelingbelin taa i manda mi ko aki. Nöö de o ko si tu taa i lobi dee sëmbë fii naandë leti kumafa i lobi mi aki. ");
INSERT INTO srmNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Nöö Taata, fa mi ta begi i aki, nöö mi kë dee sëmbë i buta a mi maun aki musu ko dë ku mi ka mi dë e, be de sa si di waiti ku di hei di i da mi. Biga i bi lobi mi bifö i mbei di goonliba seei. ");
INSERT INTO srmNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Taata, fa i ta du soni ku leti tjika naandë, nöö dee oto sëmbë u di goonliba aki an sabi i e. Ma nöö mii sabi i. Nöö dee sëmbë i da mi aki nöö deseei ko sabi taa i manda mi ko aki. ");
INSERT INTO srmNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Fa mi ku de bi dë aki, mi mbei de ko sabi i gbelin kumafa i dë, nöö mi o ta mbei de ko sabi i möönmöön eti. Biga te de sabi i kumafa i dë kaa, nöö de o ta lobi deseei ku di wan seei lobi di i si i ta lobi mi aki. Nöö miseei o dë a de dendu tu ta tii de.” Sö Masa Jesosi fan ku ën Tata tefa a kaba. ");
INSERT INTO srmNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nöö hën di Masa Jesosi begi sö te a kaba, hën u ku ën kumutu dë, hën u pasa di kiiki de kai Gidilon go a di oto së tela. Nöö ala wan djai dë ku wanlö hia pau, nöö hën u go a di djai dë dendu. ");
INSERT INTO srmNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma nöö Judasi, di sëmbë di o sei Masa Jesosi, nöö a bi sabi di kamian naandë bunu kaa, biga u ku Masa Jesosi bi lobi u ko makandi naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nöö hën u sai dë te wan pisi, hën u si Judasi ta ko ku wanlö hia sodati, ku wanlö siköutu dee ta wakiti a di Wosu u Gadu a Jelusalen dë. Nöö fa de ta ko dë, nöö dee Gaan Begima ku dee Faliseima, de wë manda de nöö de ta ko ku feti soni a maun, so sëmbë ta tja falambo, so sëmbë dë ku lampu, biga a bi dë ndeti. ");
INSERT INTO srmNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma nöö Masa Jesosi bi sabi hii dee soni dee o pasa ku ën kaa, nöö hën a waka go miti ku de. Hën a hakisi de taa: “Ambë un ta suku sö?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hën de taa: “Jesosi u di köndë de kai Nazalëti.” Hën a piki de taa: “Wë mi disi kaa.” (Nöö fa dee sëmbë ta fan dë, nöö Judasi di könkuma bi dë leti dë.) ");
INSERT INTO srmNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nöö di Jesosi piki de sö, nöö hën de tuu hai baka naki de na de tuwë a goon. ");
INSERT INTO srmNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hën a toona hakisi de möön taa: “Ambë da di sëmbë un ta suku?” Hën de taa: “Jesosi u Nazalëti.” ");
INSERT INTO srmNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Hën a piki de taa: “Wë mi bi piki unu kaa taa miseei disi wante. Nöö ee mi un ta suku, nöö un disa dee oto sëmbë aki be de go u de.” ");
INSERT INTO srmNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nöö da sö di wöutu ko leti kumafa a bi taki taa: Dee i bi da mi, na wan u de mi lasi möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nöö wan u dee sëmbë ko dë de kai Malikusi. A dë wan futuboi u di Kaba Hei Begima. Nöö fa i si u mbei dë, nöö hën Petuisi hai di sëufangi fëën valau puu nëën dosu, hën a koti wan së jesi u di sëmbë dë belim puu tuwë a goon dë. ");
INSERT INTO srmNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Hën Masa Jesosi bai ën taa: “Nönö womi. Tuusi di ufangi fii nëën dosu baka. Di sondi di mi Tata da mi u mi bebe aki, ma musu bebëën tuu ku telu nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nöö di juu dë, hën dee hia sodati ku di hedima u de ku dee siköutu u dee Dju hedima, hën de kisi Masa Jesosi awaa. Hën de tai ën maun te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hën de tjëën go a di wosu u wan tata de kai Ananasi. Nöö di Ananasi dë, hën bi dë di Kaba Hei Begima a fesi ufö Kajafasi, nöö Kajafasi tööu ku wan mujëë mii fëën. ");
INSERT INTO srmNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Nöö Kajafasi hën wë bi da di sëmbë di bi da dee hedima u Dju lai a di kuutu taa, ka u hii di nasiön tuu kaba a sösö nöö a möön bunu wan kodo sëmbë nöö dëdë.) ");
INSERT INTO srmNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nöö fa de kisi Masa Jesosi tja go naandë, nöö Simon Petuisi ku wan oto bakama bi dë tee a baka ala ta waka ta ko. Nöö di bakama naandë, di Kaba Hei Begima bi sabi ën kaa, fëën mbei de dëën pasi faa go ku Masa Jesosi a di djai dendu. Ma Petuisi hën a fika a döö naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nöö hën wë di oto bakama dë toona go fan ku di mujëë mii ta watji a di dööbuka, nöö hën a mbei Petuisi pasa ko a di djai dendu tu. ");
INSERT INTO srmNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nöö hën di mujëë mii hakisi Petuisi taa: “Womi, na i da wan u dee bakama u di sëmbë de tja ko aki nö?” Hën Petuisi piki taa: “Nönö, na mi e.” ");
INSERT INTO srmNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nöö fa de dë a di djai dendu a di ndeti dë, nöö kamian bi kötö, hën de mbei wan faja buta dë ta këndë. Dee wookoma ku dee siköutu tuu sai naandë, hën Petuisi seei go ta këndë faja ku de tu. ");
INSERT INTO srmNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nöö di juu naandë, de bi tja Masa Jesosi go a di awoo Kaba Hei Begima de kai Ananasi kaa. Nöö hën Ananasi ta hakisi ën peipei soni fuu dee bakama fëën, ku di lei a abi ta lei sëmbë a di köndë. ");
INSERT INTO srmNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Hën Masa Jesosi piki ën taa: “Wë fa i ta hakisi mi dee soni aki, wë hibiwan juu mi bi ta lei sëmbë a lanti wajaa. Biga mi bi nango a hii dee keikiwosu te dou ku di Wosu u Masa Gadu tuu, ka hii dee Dju sëmbë ta ko makandi. Nöö na tjubitjubi mi bi ta du ën. ");
INSERT INTO srmNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wë nöö na mi i musu hakisi. Hakisi dee sëmbë dee bi ta haika dee fan u mi naandë, biga misikuma de musu sabi andi da dee soni mi bi ta lei de.” ");
INSERT INTO srmNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nöö fa a fan dë, hën wan u dee wakitima di bi dë zuntu ku ën dë, hën a dëën wan baaimaun a bandjajesi dë kpaa taa: “Sö joo piki di Kaba Hei Begima nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Hën Masa Jesosi piki ën taa: “Womi, ee mi taki wan hogi soni, nöö lei mi di hogi mi taki. Ma ee mi fan leti, nöö andi mbei i naki mi u du?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nöö fa a fan naandë, nöö hën de disa di taki, hën Ananasi mandëën taitai maun go a Kajafasi awaa. ");
INSERT INTO srmNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nöö di juu dë, Simon Petuisi dë fëën taanputaanpu naandë ta këndë di faja eti. Te wan pisi hën de bia ko ta hakisi ën möön taa: “Wë womi, na i da wan u dee bakama u di sëmbë naandë nö?” Hën a fia taa: “Nönö, nönö, na mi e!” ");
INSERT INTO srmNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nöö wan futuboi u di Kaba Hei Begima sai dë. A dë famii u Malikusi di Petuisi bi koti ën jesi, nöö hën a hakisi ën taa: “Tan. Wë womi o, na i ku ën mi bi si a di djai ala ö?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nöö hën Petuisi toona fia möön taanga taa: “Nönö hön, na mi da di sëmbë di i bi si dë e!” Nöö hën wantewante dë hën ganian bai kanda. ");
INSERT INTO srmNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nöö hën baka u di dë, hën de kumutu a Kajafasi. Hën de tja Masa Jesosi go a di kuutuwosu u dee Loomë sëmbë dee ta tii di köndë. Naandë wan Gaama de kai Pilati ta dë, di dee Loomë lanti buta ta tii di köndë. Nöö di juu dë a bi dë mamate biten. Nöö abiti möön di Pasika o kai, nöö fëën mbei dee hedima u Dju an sa go a di kuutuwosu, biga an dë wosu u dee Dju. Nöö de an kë poi di tjina taa de go a wan wosu na u Dju sëmbë, biga de kë hoi deseei limbolimbo u de sa njan di daka. ");
INSERT INTO srmNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Fëën mbei Gaama Pilati musu ko a de a döö. Nöö di a ko dou, hën a hakisi de taa: “Wë un hogi di sëmbë aki du mbei un tjëën ko a mi aki?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nöö hën de piki ën taa: “Hön, nönö. Wë di soni dë an dë u hakisi. Wë biga ee an bi dë wan sëmbë di ta du hogi, nöö wa bi o tjëën ko da i aki.” ");
INSERT INTO srmNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nöö hën di Gaama taa: “Sö nö? Wë nöö di a dë sö kaa, nöö be unu seei tei ën tja go kuutu ku dee wëti fuunu.” Nöö hën de piki ën taa: “Wë nönö, wa sa kuutu ën e, biga un dee Loomë lanti an ta da u pasi u kii sëmbë!” ");
INSERT INTO srmNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nöö di soni mbei a musu pasa sö. Biga Masa Jesosi bi pindja de kaa taa de an o kii ën kumafa dee Dju sëmbë ta kii sëmbë, hën mbei de bi musu tjëën go da di Loomë Gaama fu hën musu mandëën go kii. ");
INSERT INTO srmNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nöö hën Pilati toona go a di kuutuwosu, hën a kai Masa Jesosi ko nëën. Hën a hakisi ën taa: “Wë nöö i da di könu u dee Dju sëmbë tuu nö, ˻kumafa de ta taki taa i taki˼?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Hën a piki ën taa: “Wë fa i ta hakisi mi aki, na un fasi i ta mëni ën? A di fasi i seei ta mëni u könu, naa a di fasi dee Dju ta mëni ën?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Hën Gaama taa: “Hön, ambë? Mi da Dju nö? Unfa mi sa mëni ën a Dju fasi? Na dee sëmbë fii seei ku dee Gaan Begima fii tja i ko a mi aki nö? Nöö hën mi ko hakisi i andi da di soni di i du mbei de tja i ko aki?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Hën a piki ën taa: “˻Wë de taa mi ta mbei miseei könu.˼ Wë ma di Könu Tii u mi an dë wan tii kuma di u dee sëmbë u di goonliba aki e. Biga ee a bi dë sö, nöö dee futuboi u mi bi o hopo heepi mi feti fu dee Dju hedima an bi musu kisi mi tja ko aki. Ma nöö di tii u mi, na a di goonliba aki a kumutu e.” ");
INSERT INTO srmNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nöö hën Gaama piki ën taa: “Söö. Wë nöö hën da i ta piki taa i dë könu.” Hën Masa Jesosi taa: “Awa, mi da wan könu tuu. I a’ leti a di dë. Ma boiti di dë, di soni mbei de pai mi ko a di goonliba aki, fu mi sa lei sëmbë andi da tuu ˻ku andi da ganjan˼. Nöö hibiwan sëmbë di kë jei tuutuu soni, nöö a o haika andi mi ta fan.” ");
INSERT INTO srmNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nöö hën di gaama taa: “Ambë tjika u sabi andi da di tuu?” Nöö fa de fan naandë, nöö hën Gaama Pilati toona go a döö a dee hedima u Dju ala, hën a taa: “Wë mi suku föutu a di womi te mi wei. Ma feni soni nëën möönsö u mi musu kuutu ën. ");
INSERT INTO srmNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma nöö un sabi nö? Un bi guwenti fu te Pasika kai, nöö mi lusu wan sëmbë di dë a dunguwosu da unu. Nöö unfa fëën un mëni? Un kë mi lusu di könu fuunu aki da unu nö?” ");
INSERT INTO srmNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nöö fa a fan dë, nöö hën de tuu kai olo taa: “Ambëë? Nëën i musu lusu e! Balabasi, hën fii lusu!” Nöö di Balabasi dë, a bi dë a dunguwosu fu di a bi dë wan sëmbë ta tja toobi ko a di köndë. ");
INSERT INTO srmNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nöö hën Gaama Pilati manda sëmbë, de wipi Masa Jesosi wan hogi wipi. ");
INSERT INTO srmNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nöö baka u di dë, hën dee sodati tei wan tatai ku maka kuma agbago maka djangadjanga hën de lolu ën mbei kuma könu kaapusa te de kaba, hën de tuusi ën a Masa Jesosi hedi. Nöö hën de tei wan baau djakiti langa wan kumafa könu ta bisi, hën de bisi ën dëën te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nöö hën de nango nëën ta mbei ën fa taa: “Odi o, könu u dee Dju, odi o!” Hën de ta naki ën nëën bandjajesi ku ën fesi tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nöö hën di gaama toona go a döö a dee hedima u Dju, hën a taa: “Wë un haika, mi o toona tja di sëmbë ko da unu e. Biga mi, ma feni na wan föutu nëën möönsö fu mi sa dëën sitaafu.” ");
INSERT INTO srmNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nöö fa a fan dë, nöö hën a mbei de tja Masa Jesosi ko a döö da de. A dë ku di langa djakiti nëën sinkii, ku di maka kaapusa nëën hedi. Hën di gaama taki da de taa: “Un luku di womi. Hën wë disi e.” ");
INSERT INTO srmNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ma nöö di dee Gaan Begima ku dee siköutu u de si ën, hën de bai kai wan gaan wolo taa: “Un kii ën oo! Un pekëën a lakpa pau kii! Un pekëën a lakpa pau kii!” ˻Biga a sö wan fasi dee Loomë sëmbë bi guwenti u kii dee sëmbë ta du hogi a di köndë a di ten dë.˼ Nöö hën di gaama piki taa: “Mi? Na mi e! Ee a lakpa pau un kë kii ën, nöö be unu seei tjëën go hëngi kii, biga ma feni föutu nëën möönsö.” ");
INSERT INTO srmNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Hën dee Dju bai piki taa: “Ja feni föutu nëën nö? Wë haika, u abi wan wëti nöö di wëti taa ee wan sëmbë ta mbei hënseei Gadu nöö a musu dëdë. Wë nöö di womi aki taa hën da Miii u Gadu, nöö hën mbei a musu dëdë e!” ");
INSERT INTO srmNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wë nöö di di gaama jei de fan sö, nöö a ko möön fëëë seei. ");
INSERT INTO srmNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Hën a toona go a di kuutuwosu dendu, hën ku Masa Jesosi, hën a hakisi ën taa: “Wë, ambë seei da i? Naasë i kumutu ko aki?” Ma Masa Jesosi an piki ën na wan soni. ");
INSERT INTO srmNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hën Gaama taa: “Ja kë piki mi nö? Ja sabi di makiti di mi abi aki nö, taa mi sa lusu i be i go, ee nasö mi sa mbei de peka i a lakpa pau kii?” ");
INSERT INTO srmNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Hën Masa Jesosi piki ën taa: “Wë nönö, ja sa abi sö wan makiti a mi liba, ee na Gadu hën da i ën. Fëën mbei di sëmbë di i si tja mi ko da i aki, hën du di möön gaan hogi.” ");
INSERT INTO srmNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wë nöö di di gaama jei a fan sö, nöö hën a ta suku wan baaku nöömö faa sa lusu ën. Ma nöö dee hedima u Dju an dë nëën. De ta bai wolo seei taa: “Kaba! Ee i lusu di sëmbë aki go, nöö i ku di Gaan Könu a Loomë o ko a wan gaan toobi e. Biga ee wan sëmbë ta mbei hënseei könu nöö hën ku di Gaan Könu dë gaan felantima!” ");
INSERT INTO srmNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wë nöö di Gaama Pilati jei fa de fan dë, hën a mbei de toona tja Masa Jesosi ko a di djai möön. Hën a go sindo a di kuutubangi fëën awaa faa koti di taki. Nöö di kuutubangi dë a wan hei sitonu liba. Mbei de mbei di kamian dë, nöö a di Dju töngö de kai ën Gabata. ");
INSERT INTO srmNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nöö di ten di soni aki ta pasa, nöö a bi dë kuma nëigi juu mamate sö. Nöö de ta seeka seei u de njan di Pasika daka di o kai dë. Nöö hën di gaama taki da dee hedima u Dju taa: “Wë un luku di könu fuunu aki e!” ");
INSERT INTO srmNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma nöö de an sa jei di soni dë. Hën de bai taa: “Un tjëën puu dë. Un tjëën puu dë. Un pekëën a lakpa pau kii!” Hën a taa: “Di könu fuunu, hën u musu peka a lakpa pau kii nö?” Hën dee Gaan Begima bai piki taa: “Wa a’ oto könu a u liba möönsö e, möön leki di Gaan Könu a Loomë!” ");
INSERT INTO srmNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nöö di Gaama Pilati jei de taki sö, nöö hën a da de Masa Jesosi awaa fu de tja go peka kii. Nöö hën dëë sodati tei ën, hën de ku ën ta waka nango. ");
INSERT INTO srmNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nöö fa de nango dë, hënseei ta tja di lakpa pau fëën ku taanga nango ka de o pekëën kii. Nöö hën de nango te de go dou a di kamian de kai Hedibonu. A Dju töngö de kai ën Golugata. ");
INSERT INTO srmNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nöö naandë sö de go pekëën a di lakpa pau te de kaba. Nöö de peka tu oto sëmbë a lakpa pau di daka dë tu. Hën de hopo de taanpu a pë nöö Masa Jesosi dë a de mindi. ");
INSERT INTO srmNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Ma nöö di gaama bi mbei de sikifi wan soni peka a di lakpa pau u Masa Jesosi, nöö de sikifi ën a dii pei töngö: a dë a di Alamaiki töngö di u dee Dju sëmbë ta fan, a dë a Latein, a dë a Giiki, a taa: JESOSI FU NAZALËTI, DI KÖNU U DEE DJU SËMBË, HËN DISI. Nöö di kamian ka de peka Masa Jesosi a di lakpa pau naandë, a dë zuntu ku Jelusalen, nöö sömëni u dee Dju sëmbë ta waka ta pasa dë, nöö de ta lesi di sikifi di dë a di lakpa pau. ");
INSERT INTO srmNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nöö hën dee Gaan Begima go ta mbei toobi ku Gaama Pilati taa: “Ja bi musu sikifi ën sö taa hën da di könu fuu dee Dju sëmbë e. Ma i bi musu sikifi taa, hën bi ta mbei taa a dë könu fuu.” ");
INSERT INTO srmNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nöö hën di Gaama bai de taa: “Un disa mi e! Di soni mi sikifi naandë, a fika sö.” ");
INSERT INTO srmNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wë nöö di dee sodati peka Masa Jesosi te de kaba kaa, hën de tei dee bisi fëën hën de paati de a fö pei, hiniwan sodati ku fëën. Ma nöö di gaan djapona fëën di de bi mbei ku telu söndö miti, hën nöö fika. ");
INSERT INTO srmNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Hën de taa: “Wan boo tënë di djapona aki e, ma un boo tuwë lötu luku ee undi fuu o feni ën.” Nöö sö wë i si taa a kai ku di soni di bi sikifi a Gadu Buku taa Dee bisi u mi de paati da de na de; de tuwë lötu da di koosu u mi. Nöö leti sö dee sodati du e. ");
INSERT INTO srmNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nöö fa Masa Jesosi dë a di lakpa pau dë, nöö hën mama ku ën mama sisa dë taanputaanpu naandë, ku wan mujëë de kai Malia di da di mujëë u Kelopasi, ku Malia fu Magidala. Sö de tuu sai dë makandi. ");
INSERT INTO srmNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nöö hën Masa Jesosi bia luku, hën a si hën mama dë ku di bakama fëën di dë gaan mati fëën. Hën a taki dëën mama taa: “Mujëë o, luku di womi i si dë. Hën wë da miii fii e.” ");
INSERT INTO srmNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hën a fan ku di bakama tu taa: “Womi, luku i mama dë.” Nöö kumutu a di ten dë, hën di bakama naandë tei Masa Jesosi mama buta nëën wosu ta sölugu. ");
INSERT INTO srmNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma nöö Masa Jesosi sabi taa hii dee soni hën Tata bi buta dëën faa du nöö de tuu pasa kaa, boiti wan oto soni nöö di bi sikifi a di Buku u Gadu. Hën a taa: “Dëëwata kisi mi.” ");
INSERT INTO srmNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nöö wan gandjigandji win kuma asin bi dë a wan paniki dendu dë, hën de tei sipönsu tuusi nëën. Hën de tei wan maun u di piki pau de kai hisopu hën de tuusi di sipönsu nëën hën de tëndëën buta nëën buka. ");
INSERT INTO srmNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nöö di a tjupëën te a kaba hën a bai taa: “A kaba!” Hën a saka hedi hën a manda di akaa fëën go. Böö fëën koti. ");
INSERT INTO srmNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nöö di juu dë, dee Dju bi ta seeka seei u de njan di daka, biga fa a o kai dë, a dë wan gaan apaiti saba. Nöö hën mbei de go begi Gaama Pilati faa mbei sëmbë go booko dee sëmbë dee dë a dee lakpa pau tuu futu, be de dëdë möön hesi fu de sa puu de. Biga de an kë di sinkii u de musu fika hëngihëngi naandë kisi di saba. ");
INSERT INTO srmNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nöö hën dee sodati go booko di fosu sëmbë futu te de kaba. Hën de go booko di u tu. ");
INSERT INTO srmNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma nöö di de dou a Masa Jesosi fu de booko ën futu, hën de ko si taa a dëdë kaa. Nöö hën de an booko ën futu möön. ");
INSERT INTO srmNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma wan u dee sodati tei wan lanza hën a suti ën nëën bandja, nöö hën gadjabia ku wata ta kule ta kumutu nëën bandja dë tjölölölö ta kai a goon. ");
INSERT INTO srmNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nöö di sëmbë i si ta taki dee soni aki, hën seepi si de ku wojo e. Nöö fa a ta fan aki, na soni a ta mindi e. Tuutuu soni seei a ta taki, fu te i jei nöö i musu bia ko biibi a Masa Jesosi tu. ");
INSERT INTO srmNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Biga hii dee soni i si pasa aki, de pasa sö fu dee soni dee dë a di Buku u Gadu tuu musu ko tuu. Biga di Buku bi taa: Na wan kodo bonu fëën o booko möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ufö a taki a wan oto kamian taa: De o ko si di sëmbë sabi di de bi suti di suti naandë. ");
INSERT INTO srmNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nöö di juu dë, i bi abi wan womi de kai Josëfu u di köndë de kai Alimatea. Nöö a bi dë wan bakama u Masa Jesosi tu, ma a tjubitjubi fasi fu di a bi fëëë dee hedima u Dju. Nöö di Josëfu aki go a Gaama Pilati go hakisi ën pasi faa sa go tei di dëdë sinkii u Masa Jesosi tja go bei. Hën di Gaama dëën pasi. ");
INSERT INTO srmNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nöö hën ku di womi de kai Nikodemusi di bi ko a Masa Jesosi a wan ndeti, hën de ko tei ën. Nöö fa Nikodemusi ko dë, a tja sumëë suti sondi te a hila mökisimökisi faa seeka di dëdë sinkii u Masa Jesosi. Dee soni dee a tja ko naandë, de sa hia kuma wan feifiteni kilo sö, sö de hia tjika. ");
INSERT INTO srmNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nöö hën wë de tu sëmbë dë lolu di dëdë sinkii u Masa Jesosi ku wanlö weti koosu pisi mökisi ku dee sumëë suti soni dë te de kaba, kumafa dee Dju sëmbë guwenti fu seeka wan dëdë bei. ");
INSERT INTO srmNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Wë nöö zuntu ku ka de bi peka Masa Jesosi kii naandë, wan djai bi dë ku wan sitonu kununu ka de bi seeka wan gaan baaku u de ta bei sëmbë. Ma de an bei sëmbë nëën wan daka eti. ");
INSERT INTO srmNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nöö fa di gaan daka o kai dë, nöö dee sëmbë ta biinga seei. Nöö fu di di geebi bi dë zuntu naandë kaa, hën de tei Masa Jesosi sinkii tja go bei a di baaku dë te de kaba. Nöö hën de go u de. ");
INSERT INTO srmNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Söö. Wë nöö a di fosu daka u di wiki di hopo dë, hën da sonde, mamate biten, kamian an limbo eti, nöö hën Malia u Magidala hopo go a di geebi ka de bi bei Masa Jesosi. Nöö fa i si de bei Masa Jesosi naandë, nöö de bi logoda wan gaan gindi sitonu tapa di baaku buka. Ma nöö di Malia go dou, nöö hën a si taa di sitonu an dë a di baaku buka möön. ");
INSERT INTO srmNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nöö hën a kule toona go konda da Simon Petuisi ku di oto bakama u Masa Jesosi di hën ku ën dë gaan mati taa: “Dee sëmbë, u go a di geebi di mamate aki e, ma nöö wa si Masa naandë. De puu ën dë tja go, nöö wa sa naasë de tjëën go buta.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nöö hën di de tu bakama naandë jei sö, hën de hopo tei pasi ta kule nango a di geebi u de go luku. ");
INSERT INTO srmNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nöö fa de ta kule dë, hën di oto bakama kule go pasa Petuisi, nöö hën fosu go dou a di geebi. ");
INSERT INTO srmNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hën a bendi luku a di baaku dendu, nöö hën a si dee koosu de bi lolu Masa Jesosi ala, ma nöö hën an go a di baaku dendu. ");
INSERT INTO srmNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nöö hën Petuisi ko dou, nöö hën a denda go a di baaku dendu wante. Hën a si dee koosu de bi lolu Masa Jesosi sinkii a wan kamian dë, ");
INSERT INTO srmNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma nöö di hangisa de bi tai ën hedi, hën a si ën dobadoba te a wan së ala. ");
INSERT INTO srmNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nöö hën di oto bakama ku ën ko dë, hën a denda go a di baaku dendu awaa, go luku dee soni te a kaba, nöö hën a ko biibi awaa. ");
INSERT INTO srmNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma nöö fa a ko biibi naandë seei, ma de an fusutan eti taa sö Masa Gadu Buku bi taki gaanduwe taa di Paamusi Könu musu toona weki baka. ");
INSERT INTO srmNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nöö hën de tu bakama toona go a wosu. ");
INSERT INTO srmNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma nöö Malia bi toona ko dë möön. Hën a ko taanpu leti a di geebi naandë ta këë nöömö. Te wan pisi, hën a bendi luku a di baaku dendu. ");
INSERT INTO srmNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nöö hën a si tu basia u Masa Gaangadu köndë sindosindo naandë gbolo, leti ka Masa Jesosi sinkii bi dë. Wan dë nëën hedi së, wan dë nëën futu së ala, nöö de tuu bisi weti koosu faan a de sinkii. ");
INSERT INTO srmNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nöö hën de hakisi ën taa: “Mujëë, andi seei du i, i ta këë sö baa?” Hën a taa: “Wë nönö, de puu di Masa u mi aki e, nöö ma sa naasë de tjëën go buta.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nöö fa a fan dë, nöö hën a bia luku, hën a si Masa Jesosi taanputaanpu leti naandë, ma hii fu di dë an sabi taa hën di dë. ");
INSERT INTO srmNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nöö hën Masa Jesosi hakisi ën taa: “Mujëë o, andi seei du i, i ta këë sö? Ambë fii lasi i ta suku?” Ma nöö Malia bi mëni taa di sëmbë ta luku di djai wë ta fan ku ën dë, hën a taa: “Wë baa, ee i puu ën aki tja go a wan oto kamian, nöö gaantangi mi begi i, lei mi ka a dë be mi go tei ën.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nöö fa a fan dë, hën Masa Jesosi kai ën nëën në awaa taa: “Malia!” Nöö hën di mujëë bia vau luku ën hën a kai ën: “Laboni!” (Hën da Mësitë a di Alamaiki töngö di de ta fan.) Hën a go u go panjëën. ");
INSERT INTO srmNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nöö hën Masa Jesosi fan ku ën taa: “Nönö mujëë, na panjan mi e, biga ma go a mi Tata eti. Ma nöö bia toona go piki dee otowan u mi taa mi nango a mi Tata di dë Tata fuunu tu, ku mi Gadu di dë di Gadu fuunu tu. Sö fii taki da de e.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nöö di de fan te de kaba, nöö hën Malia tja di buka ko konda da u dee bakama u Masa Jesosi taa: “Dee sëmbë, mi si Masa e!” Hën a da u di buka di a manda nëën da u. ");
INSERT INTO srmNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nöö a di sapate dë seei, hën u ko dë a wan wosu makandi, hën u söötö di döö fu di u fëëë dee hedima u Dju. Nöö te fuu kë mëni hën Masa Jesosi ko taanpu leti a u mindi naandë. Hën a da u odi taa: “Un dë nö? Be hati fuunu kötö e, dee sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nöö hën a lei u dee peegu maaka nëën maun dendu ku di lanza buka nëën bandja, be u si taa hënseei di dë kaa. Nöö hën u wai te na soni. ");
INSERT INTO srmNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hën a toona taki da u möön taa: “Un musu dë ku kötöhati e, dee sëmbë.” Hën a taa: “Wë un haika e. Leti fa i si mi Tata bi manda mi ko a dee sëmbë u goonliba aki, nöö söseei mi ta manda unu go a de tu e.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nöö fa a fan naandë, nöö hën a böö u vuuu ku buka hën a taa: “Un tei di Akaa u Gadu a unu liba e. ");
INSERT INTO srmNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nöö fa woon tei ën dë, nöö di sëmbë woon puu a bëë fu dee hogi du fëën, nöö Gadu puu ën a bëë tu. Ma nöö dee sëmbë dee un hoi a bëë fu dee hogi du u de hedi, nöö Gadu o hoi de a bëë tu e.” Sö a taki da u. ");
INSERT INTO srmNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma nöö wan otowan fuu de kai Tomasi, hënseei de kai Tumii, hën an bi sai naandë di daka dë. ");
INSERT INTO srmNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nöö di u si ën, hën u fan ku ën taa: “Womi, u seei si Masa Jesosi e.” Hën a piki u taa: “Un disa mi e, womi. Mi, fa mi dë aki, ee na mi seei si dee peegu maaka nëën maun dendu u mi buta finga a de, ee nasö mi tuusi maun a di lanza buka nëën bandja, ma o piki möönsö e!” Sö Tomasi fia ku u tjika. ");
INSERT INTO srmNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nöö baka aiti daka fëën, hën u toona ko makandi a di wosu möön, nöö Tomasi seei bi ko tu. Nöö hën u dë söötösöötö döö naandë, te wan pisi hën u si Masa Jesosi dë taanputaanpu leti a u mindi dë. Hën a da u odi taa: “Un musu dë ku kötöhati e, dee sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nöö hën a bia fan ku Tomasi wante taa: “Söö. Wë Tomasi, luku mi maun dendu aki ku dee peegu maaka. Nöö tëndë di finga fii ko buta a de e. Tëndë di maun fii ko buta a di lanza buka a mi bandja aki.” Nöö hën a fan ku ën taa: “Womi o, di fasi di i abi taa ja ta kë ta biibi, nöö i musu disëën e, nöö i bia ko ta biibi awaa.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nöö hën Tomasi piki awaa taa: “Aai o, Masa. I da mi Masa ku mi Gadu tuu.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Hën Masa Jesosi taa: “Womi, di i si nöö hën mbei i biibi nö? Ma nöö Gadu ta wai ku dee sëmbë dee ta biibi söndö de si.” ");
INSERT INTO srmNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nöö fa u sikifi dee soni aki, dee sëmbë, nöö sömëni oto foombo soni dë di Masa Jesosi bi du eti e, faa mbei u dee bakama fëën ko si taa sö wan sëmbë a dë, ma dee di dë wa sikifi de buta a di buku aki. ");
INSERT INTO srmNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma nöö dee aki, u sikifi de fuun musu biibi taa Masa Jesosi hën da di Keesitu, di Könu di Masa Gadu bi paamusi taa a o manda ko. Hën da di Womi Mii u Masa Gaangadu seei gbelingbelin. Nöö te un biibi sö kaa, nöö woon feni di libi u teego fu di un nama ku ën. Da sö. ");
INSERT INTO srmNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wë nöö a baka u di dë, hën Masa Jesosi tjëën seei ko lei u dee bakama fëën wan pasi möön, a di piki ze de kai Tibelia. Wë di oto aki, a pasa sö taa ");
INSERT INTO srmNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petuisi ku Tomasi, di de kai Tumii naandë, ku Nataniëli u Kana fu di pisiwata u Galilea, ku u de tu womi mii u Zebedeosi, ku tu otowan fuu möön, sö u bi dë makandi a wan kamian. ");
INSERT INTO srmNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Te wan pisi hën Simon Petuisi taki da u dee otowan taa: “Wë mi o go tuwë nëti luku e baa.” Hën u piki taa: “Antoobi. Woo go ku i tu e, womi.” Nöö hën u hopo, hën u go tei boto wante, nöö hën wë u go e. Ma nöö fa u go dë, hii di ndeti tefa didia wa kisi na wan wojo soni möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nöö hën di mamate biten, kamian ta mbei bëëë sö, hën wë Masa Jesosi ko dë taanputaanpu leti a bandja wata naandë, ma nöö wa bi sabi taa hën di dë. ");
INSERT INTO srmNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nöö hën a bai hakisi u taa: “Dee kijoo dë e, andi un kisi baa?” Hën u bai piki taa: “Nönö, wa feni e.” ");
INSERT INTO srmNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nöö hën a taki da u taa: “Wë un sabi nö? Un hiti di nëti fuunu go a di letimaun së u di boto, nöö woon kisi.” Nöö di u jei sö, nöö hën u puu di nëti a di së dë hiti go a di oto së. Nöö wantewante naandë hën u kisi fisi te a hila seei, tee wa sa hai di nëti ko a di boto dendu. ");
INSERT INTO srmNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nöö hën di bakama di hën ku Masa Jesosi dë gaan mati taki da Petuisi taa: “Womi, Masa Jesosi wë i si di dë e!” Nöö di Petuisi jei sö kaa, hën a bia kisi koosu bisi, biga an bi dë ku bumbuu soni a sinkii. Hën a djombo kai a wata djubuu sun go a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma nöö u otowan fika a di boto dendu ta diipi ta ko ku dee gaan hia fisi u kisi dë, biga wa bi dë longi ku lampeesi poi. A bi dë kuma wan höndö mëti sö nöö. ");
INSERT INTO srmNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nöö di u ko tjökö kumutu a di boto nöö hën u ko si zonka hëii naandë kaa, ku fisi a faja liba. Hën u si bëëë naandë tu. ");
INSERT INTO srmNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Hën Masa Jesosi taki da u taa: “Wë un go tei so u dee fisi un kisi ala tja ko.” ");
INSERT INTO srmNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nöö hën Simon Petuisi go ta hai di nëti ta tja ko a tela. Nöö dee fisi u kisi dë dë wan höndö ku feifiteni-ku-dii, nöö de tuu bi dë gaangaan fisi. Ma nöö hii fa de hia seei, ma na wan tatai u di nëti koti möönsö. ");
INSERT INTO srmNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nöö hën Masa Jesosi kai u taa: “Wë un ko boo njan.” Ma nöö hii fa i si di soni ta pasa dë, nöö u dee bakama fëën ta wegi ën ta luku. Nöö a bigi da u, u ta si kuma nëën ma da hën. Ma nöö na wan fuu bi a’ hati u hakisi ën ee ambë dëën. ");
INSERT INTO srmNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nöö hën Masa Jesosi tei di bëëë ku di fisi di bi dë a faja liba dë, hën a paati da u. ");
INSERT INTO srmNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wë nöö disi mbei dii pasi di Masa Jesosi tjëën seei ko lei u dee bakama fëën, baka u di a weki a dëdë. ");
INSERT INTO srmNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nöö di u njan te u kaba, hën Masa Jesosi fan ku Simon Petuisi, a kai ën: “Simon o.” A piki. A taa: “Ju di mii u Jonasi aki, i lobi mi möön dee disi ö?” Hën Petuisi piki taa: “Wë aai Masa, i seei sabi taa mi lobi i e.” Nöö hën a taa: “Antoobi. Wë nöö fii ta da dee njunjun sëmbë dee ko biibi a mi liba di buka u mi e. Sölugu de da mi leti kumafa wan kiijama u sikapu ta sölugu dee sikapu mii.” ");
INSERT INTO srmNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nöö hën a toona hakisi ën di u tu pasi taa: “Simon, ju di mii u Jonasi aki, i lobi mi nö?” Nöö hën a piki ën di wan seei fasi taa: “Aai Masa, i seei sabi taa mi lobi i.” Nöö hën a taki dëën taa: “Antoobi. I musu sölugu dee sikapu u mi da mi e.” ");
INSERT INTO srmNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hën a toona hakisi ën di wan seei soni di u mbei dii pasi taa: “Simon, di mii u Jonasi aki, i lobi mi nö?” Nöö di a jei a hakisi ën di u dii pasi ee a lobi ën, nöö a ko hati ën seei. Hën a taa: “Masa o, wë i seei sabi hii soni kaa. I sabi taa mi lobi i.” Nöö hën Masa Jesosi taki dëën taa: “Söö. Wë nöö i musu sölugu dee sikapu u mi da mi e.” ");
INSERT INTO srmNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nöö hën a toona fan ku ën taa: “Womi, mi o taki wan soni da i aki e, nöö a dë tuu möön hii soni. Fa i dë njönku aki, nöö i seei ta bisi koosu da i seei te i kaba, nöö i ta waka fii nango ka i kë, nasö nö? Ma nöö haika e. Te i ko gaandi, nöö joo tëndë maun fii da oto sëmbë be de bisi koosu da i, nöö de o tja i go a wan kamian ka ja o kë go.” ");
INSERT INTO srmNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nöö ku di fan naandë, Masa Jesosi ta pindja Petuisi kumafa dëdë fëën o waka, nöö di dëdë fëën naandë o tja gaan nëbai da Masa Gaangadu. Nöö hën Masa Jesosi taki dëën taa: “Womi o, Petuisi, be i ta waka a mi baka nöö e.” ");
INSERT INTO srmNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma nöö fa de ta fan dë, te wan pisi hën Petuisi bia luku, hën a si di bakama di hën ku Masa Jesosi dë gaan mati ta waka ta ko a de baka. (Di bakama aki, hën wë da di sëmbë di bi sindo hëngi a Masa Jesosi, di de bi ta njan di Pasika. Hën bi hakisi taa: “Undi fuu o könku i di könku?”) ");
INSERT INTO srmNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nöö fa Petuisi si ën dë, hën a hakisi Masa Jesosi taa: “Wë di sëmbë aki wë? Andi fëën i ta taki?” ");
INSERT INTO srmNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Hën Masa Jesosi piki ën taa: “Wë womi, ee mi kë faa fika ku libi fu te mi toona ko a goonliba aki baka seei, nöö andi fëën i kë? Be i ta waka a mi baka nöö e.” ");
INSERT INTO srmNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Wë nöö fu di soni dë hedi mbei dee biibima seti ta mindi soni taa di bakama naandë hën an o dëdë möönsö. Ma nöö fa i jei dë, Masa Jesosi hën an taki sö e. Ma a bi taa: “Ee mi kë faa fika ku libi u te mi toona ko, nöö andi fëën i kë?” Sö a bi taki di taki. ");
INSERT INTO srmNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wë da sö e, dee sëmbë. Di bakama u taki naandë, nöö hën wë i si ta sikifi hii dee soni aki, nöö u sabi taa de dë tuu. ");
INSERT INTO srmNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nöö sömëni oto soni möön Masa Jesosi du tu, ma misikuma ee fuu sikifi de tuu buta a buku, nöö di mundu aki seei an o bigi tjika u hoi hii dee buku naandë e. A kaba.");
INSERT INTO srmNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Mati Teofilusi, ˻mi Lukasi manda gaan odi da i e, taa mi dë bumbuu˼. Womi, mi bi mbei wan fosu pampia manda da i kaa, hën mi toona ta mbei disi u mi manda da i möön, di u mbei tu. Wë nöö di fosu pampia di mi bi mbei dë, nöö mi bi sikifi sömëni soni u Masa Jesosi da i, u di fa a bi libi a goonliba aki ku di fa a bi ta lei sëmbë soni u Gadu bifö Masa Gadu tei ën tja go a liba. Ma bifö a go, nöö a bi lei dee sëmbë a bi pii tei u de musu ko tjabukama fëën apaiti, fa u de musu du di a o go. Leti kumafa di Akaa u Masa Gadu mandëën, nöö so a lei de. ");
INSERT INTO srmNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Biga baka u di a dëdë ˻toona weki baka˼, a nango a de ta ko nöömö te kai föteni daka, ta du peipei soni u de musu sabi taa a toona weki baka tuutuu. De seei ta si ën ku deseei wojo, nöö a ta fan ku de ta lei de fa di Njunjun Tii u Gadu dë. ");
INSERT INTO srmNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nöö hën de dë te wan daka, hën a kai de te de piki, a taa: “Un haika e, dee sëmbë. Wan musu kumutu a Jelusalen aki eti e. Un musu tan aki ta luku di soni Masa Gadu o du da unu. Biga a o da unu wan gaan bunu, leti kumafa mi bi paamusi unu kaa. ");
INSERT INTO srmNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Fa i si Johanisi di Dopuma bi sai dë, a bi ta dopu sëmbë ku wata, ma abiti möön nöö Masa Gadu o dopu unu ku di Akaa fëën. ˻Biga a o mandëën ko a unu liba.˼” Sö wan soni Masa Jesosi fan ku dee bakama fëën te a kaba. ");
INSERT INTO srmNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nöö hën de sai dë tee wan daka, nöö hën de hakisi ën taa: “Wë Masa, unfa joo du? Joo puu dee Loomë sëmbë a u dee Isaëli sëmbë liba awaa, fuu sa toona tii u seei baka nö?” ");
INSERT INTO srmNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hën a piki de taa: “Wë nönö, an dë fuun biinga fu un ko sabi dee soni dë e. Biga mi Tata Masa Gadu nöö abi di taki faa buta di daka ku di juu di de o pasa. ");
INSERT INTO srmNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","“Ma unu, a o da unu di Akaa fëën. Nöö fa di Akaa o ko a unu liba dë, nöö a o da unu kaakiti fuun sa tei dee soni u mi dee un sabi konda da lanti be de jei. A Jelusalen aki woon seti konda di buka, nöö woon ta kondëën te dou hii Judea köndë te kisi Samalia köndë, nöö woon toona ta kondëën be a paaja a hii dee köndëköndë u goonliba tuu ka sëmbë dë. Sö woon ta waka ta paaja di buka tjika.” Sö Masa Jesosi taki da dee bakama fëën di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nöö hën de dë te wan pisi, hën Masa Gadu tei ën tja go a liba gbolo leti a de wojo dë. A tjëën go tee bundji tapëën, de an sa si ën möön. ");
INSERT INTO srmNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hën dee bakama fëën sai dë ta luku ka a go a liba ala diin. Hën te u de kë mëni, hën de si tu sëmbë taanputaanpu a de bandja dë, ku wetiweti bisi faan a de sinkii. ");
INSERT INTO srmNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hën de tu sëmbë hakisi dee bakama taa: “Dee sëmbë u Galilea aki, andi mbei un taanpu ta luku liba diin sö? Di wan seei sëmbë di un si Masa Gadu tja go a liba dë, Masa Jesosi, te wan ten a o toona ko a goonliba baka e. Nöö a di wan seei fasi kumafa i si a go dë, sö nöö a o toona ko baka.” Sö de tu sëmbë taki da de. ");
INSERT INTO srmNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wë nöö di juu dë, de bi dë a di kuun de kai Oleifi Kuun. Nöö di di soni pasa sö kaa, nöö hën de kumutu dë hën de toona go a Jelusalen. Biga di kuun an longi ku di köndë, a sa dë kuma wan kilomëti sö nöö. ");
INSERT INTO srmNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nöö di de go dou a Jelusalen, hën de toona go a di wosu ka de bi guwenti u go, a wan kamba a liba ala. Nöö dee sëmbë ku dee sëmbë dee go dë, de da dee tjabukama u Masa Jesosi: Petuisi, Johanisi, Jakobosi, Andiasi, Filipi, ku Tomasi, Batolomisi, Mateosi, Jakobosi di da di womi mii u Alufasi, ku Simon di womi di bi kë puu Loomë lanti a dee Dju liba. Ufö i abi di oto Judasi, di womi mii u wan tata de kai Jakobosi. ");
INSERT INTO srmNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dee lö sëmbë dë, sö de bi guwenti u ta ko makandi fu de ta begi Gadu nöömö, de ku Malia di mama u Masa Jesosi, ku wanlö oto mujëë, ku dee baaa fu Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nöö hën de dë te wan daka, hën wanlö hia sëmbë ko dë makandi a di kamian. De dë wan höndö ku tuwenti sëmbë, biibima u Masa Jesosi wanwan. Te wan pisi, hën Petuisi hopo taanpu a de mindi. ");
INSERT INTO srmNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","Hën a taki da de taa: “Dee sëmbë u mi aki, wë un sabi fa di Akaa u Masa Gadu bi ko a Dafiti liba gaanduwe a fesi, faa sikifi soni u di soni Judasi du aki. Wë ee wan soni sikifi a di Buku kaa, nöö a musu pasa nöömö, nöö hën i si a pasa ku Judasi a u mindi aki. Biga Judasi bi dë wan fuu. Masa Jesosi bi tei u ku ën tuu fuu musu dë a di wooko u Masa Gadu makandi. Nöö hën wë i si a tja dee sëmbë ko kisi Masa Jesosi kii.” ");
INSERT INTO srmNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Wë nöö fa Judasi bi du di hogi dë, nöö dee felantima u Masa Jesosi bi pakëën. Nöö hën a tei di möni, hën a go bai wan goon. Nöö a di goon di a bai dë, naandë seei a kai gbolo dëdë pii. Bëë fëën latja puu tiipa a döö. Sö wan soni pasa ku Judasi e. ");
INSERT INTO srmNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nöö hën hii dee sëmbë u Jelusalen ko jei taa sö a dëdë a di goon dendu, nöö hën de ko ta kai di goon Akelidama, hën da Buuu Goon. ");
INSERT INTO srmNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Hën Petuisi taki möön taa: “A bi dë sikifisikifi a di pisi u Gadu Buku de kai Kanda Buku taa: Di wosu fëën ka a bi ta dë, a musu fika söndö sëmbë. Na wan sëmbë musu go libi nëën möön. Hën a toona sikifi taa: Oto sëmbë musu subi a di wooko nëën kamian. ");
INSERT INTO srmNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Wë nöö hën da wan sëmbë musu ko a Judasi kamian e, fu toona heepi u a di wooko. Nöö di sëmbë di woo tei, a musu dë wan sëmbë di bi dë ku u a bigi fu di soni, kumutu a di daka di Johanisi bi dopu Masa Jesosi tee dou di daka di Masa Gadu tei ën tja go a liba. A bi musu si taa Masa Jesosi dëdë toona weki baka. Sö wan sëmbë wë u musu tei buta a Judasi kamian e.” ");
INSERT INTO srmNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nöö di Petuisi taki sö te a kaba, nöö hën de kai tu womi ko buta. Wan u de de kai Josëfu. Hën da Basabasi, hënseei da Jusitusi. Nöö di otowan de kai Matiasi. ");
INSERT INTO srmNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nöö hën de begi te de kaba taa: “Masa Gadu o, wë u ko a i. Biga i sabi hiniwan libisëmbë hatiböö fa a dë. “Wë nöö fu di Judasi an dë aki möön, fëën hedi wan oto sëmbë musu subi a di wooko nëën kamian ko tjabukama fii. Nöö hën i si u tja de tu womi aki ko da i, fii lei u undi u de i kë. Biga Judasi disa u hën a go a di kamian di fiti ën.” Sö wan begi de begi. ");
INSERT INTO srmNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nöö di de begi sö te de kaba, hën de tuwë lötu. Nöö hën Matiasi wini, hën a ko mökisi ku dee ëlufu Gaan Tjabukama u Masa Jesosi dee bi fika mbei tuwalufu. ");
INSERT INTO srmNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Hën de dë te wan daka, dee Dju sëmbë o njan di daka de kai Pensiti, nöö hën dee biibima u Masa Jesosi tuu hai ko makandi a wan wosu möön. ");
INSERT INTO srmNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hën de sai dë te u de kë mëni, hën de jei wan soni kuma gaan ventu kumutu a liba ta ko te a ko dou a di wosu dendu vooo sö, ka de dë sindosindo. ");
INSERT INTO srmNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hën de si wan soni kuma faja töngö paaja fingafinga go nama a hiniwan u de. ");
INSERT INTO srmNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hën di Akaa u Masa Gadu wë i si ko a de liba sö e. Nöö a tja wan köni ko da de, hiniwan u de ko ta taki oto töngö. ");
INSERT INTO srmNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nöö di juu dë, wanlö hia Dju sëmbë fu dee peipei köndë u goonliba bi dë a Jelusalen. De tuu ta biibi Masa Gadu, nöö de bi ko a Jelusalen dë u de njan di daka. ");
INSERT INTO srmNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nöö di de jei di bai, hën de booko gililii ko a dee sëmbë u Masa Jesosi, ko haika. Nöö hën de ko ta jei de ta fan peipei töngö, hiniwan sëmbë ta jei di töngö fëën seei di a ta taki. ");
INSERT INTO srmNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hën de taa: “Wooo maingë, andi da di soni aki? A bigi da u. Naasë dee Galilea sëmbë aki lei dee töngö sabi sö? Biga na deseei töngö de ta fan dë. ");
INSERT INTO srmNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Unfa a waka de ko sabi hii dee töngö fuu tuu ta taki. ");
INSERT INTO srmNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Biga a sömëni peipei köndë u kumutu nöö u ta fan di töngö u di köndë ka u kumutu: Paatia, Media, Elam, Mesopotamia, Judea, Kapadosia, Pontusi, Asia, ");
INSERT INTO srmNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Fiigia, Panfilia, Egepiti, dee köndëköndë u Libië dee dë zuntu ku Sileni, ufö i abi Loomë, ku Keeta, ku Alabia. A dee köndë dë tuu u kumutu. ");
INSERT INTO srmNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","So fuu dë Dju sëmbë, so fuu an dë Dju sëmbë, ma u ko ta biibi Masa Gadu kuma de, nöö hën u ko ta jei dee sëmbë aki ta konda dee foondofoondo soni u Masa Gadu da u a dee töngö dee u sabi. Nöö a bigi da u e!” ");
INSERT INTO srmNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nöö hën de fika ta hakisi de na de nöömö taa: “Andi disi maingë? Wa fusutëën e!” ");
INSERT INTO srmNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma nöö otowan a de dendu dë mbei dee Tjabukama u Masa Jesosi fa taa: “Maingë, wan piki e! Dööngö nöö de dööngö sö.” ");
INSERT INTO srmNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nöö di dee Tjabukama jei de taki sö, hën Petuisi hopo, hën ku dee otowan fëën tuu. Hën a bai taki da dee hia sëmbë dë taa: “Dee sëmbë aki, un haika e. Un dee Dju sëmbë u Jelusalen aki ku hii un dee wakama tuu, un haika bunu fa mi o fan ku unu aki. Mi kë lei unu andi ta pasa aki. ");
INSERT INTO srmNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Wë fa un taa u dööngö aki, nöö na tuu e, dee sëmbë. Fa di nëigi juu mamate u dë aki, a tjika u sëmbë bebe soni dööngö kaa nö? Nönö. ");
INSERT INTO srmNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma di soni pasa aki, a dë di soni di di fesiten tjabukama u Gadu de kai Joëli bi taki a fesi. A taa: ");
INSERT INTO srmNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Masa Gadu manda wan buka ko taa: ‘A di kaba ten u goonliba mi o du wan soni. Mi o da hii pei sëmbë di Akaa u mi. Dee womi mii fuunu ku dee mujëë mii fuunu o ta kisi fan a Gadu ta konda da sëmbë. Dee kijoo mii fuunu o ta si soni u mi ku wojo limbo. Dee gaan womi o ta sunjan soni u mi. ");
INSERT INTO srmNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Di juu dë, di Akaa u mi o ko a dee sëmbë dee ta wooko da mi liba, womi ku mujëë tuu. Nöö de o ta kisi fan a mi u de konda da sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nöö mi o du foombofoombo soni a liba ala. Mi o du bödjëë soni a goonliba aki tu, kuma maaka sö. Biga sëmbë o si buuu, de o si faja, de o si sumuku baakabaaka. ");
INSERT INTO srmNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Di sonuwojo o dungu pii, nöö di libawojo o ko bëëë sö kuma buuu. Sö o pasa bifö di Gaan Hebi Daka u Masa Gadu o dou. ");
INSERT INTO srmNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma nöö hiniwan sëmbë di o kai Masa Gadu në faa feni heepi nëën, hën Gadu o puu fu an feni sitaafu.’ Sö Masa Gadu bi fan a Joëli liba, nöö hën i si ta pasa aki e, dee sëmbë.” ");
INSERT INTO srmNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hën Petuisi toona taki da de möön, a taa: “Dee sëmbë fu Isaëli aki, un haika mi bunu e. “Di sëmbë de kai Jesosi fu di köndë de kai Nazalëti, hën bi ta du sömëni foombofoombo soni a unu dendu, leti kumafa un tuu sabi kaa. Masa Gadu wë dëën di kaakiti faa ta du sö e, be un musu sabi taa hën mandëën. ");
INSERT INTO srmNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ma nöö di Jesosi dë, hën Masa Gadu bi buta a fesi taa a o da unu pasi fuun kii ën. A bi sabi kaa taa woon tjëën go da dee hogihati sëmbë fu de pekëën a lakpa pau kii. Sö a bi sabi a fesi kaa. ");
INSERT INTO srmNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","“Ma fa un kii ën dë, nöö Gadu an disëën a dëdë köndë e. A puu ën a di sitaafu dë, toona weki ën baka. Biga Dëdë Köndë aan di kaakiti u tapëën buta dë u nöömö. Nöö hën i si a toona weki baka. ");
INSERT INTO srmNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Wë nöö Dafiti bi sikifi wan soni. ˻Buka da fëën ma wöutu na fëën. Biga Masa Jesosi hën abi di wöutu.˼ A taa: Fa mi dë aki, ma ta fëëë na wan soni, biga mi sabi taa Masa Gadu dë leti a mi bandja aki. Nöö a o ta dë ku mi nöömö. ");
INSERT INTO srmNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Fa i dë ku mi tjika aki, Masa Gadu, nöö mi ta wai seei te dou a mi hati dendu. Dee wöutu dee mi ta tei ta taki, nöö waiwai soni de dë. Biga fa i si mi dë ku mi sösö sinkii aki seei, ma ma ta fëëë dëdë möönsö, biga mi sabi taa joo tja mi. ");
INSERT INTO srmNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nöö mi sabi tu taa ja o disa mi a dëdë köndë. Di futuboi fii di dë apaiti da i vö, ja o disëën sinkii a dëdë köndë faa lulu poi kaba a sösö. ");
INSERT INTO srmNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","I lei mi di pasi kaa, ka fu mi go mi feni libi, nöö joo dë ku mi, hën mbei mi o dë waiwai. Sö Dafiti bi sikifi a fesiten e. ");
INSERT INTO srmNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Wë nöö dee sëmbë u mi aki, ˻be mi puu di soni a sikifi dë da unu. Biga fa Dafiti taki dë, nöö na hënseei soni a tei taki e˼. A bi dë wan gaan sëmbë fuu, nöö a dëdë te de bei gaanduwe kaa. Geebi fëën sai leti dë eti. ");
INSERT INTO srmNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","“Ma nöö fa Dafiti fan naandë, nöö a bi dë wan tjabukama u Gadu, nöö a bi ta konda u wan soni o pasa a bakaten. Biga a bi sabi taa Masa Gadu bi paamusi ën wan soni ku soi seei taa wan u dee bakamii fëën o ko tei di könu sutuu fëën fu nöömö. ");
INSERT INTO srmNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","“Wë nöö di Dafiti sabi sö kaa, hën mbei a taki di lö soni dë fu di sëmbë di Masa Gadu o manda ko. Hën de kai di Keesitu. A o dëdë ma a o toona weki baka. A taa Masa Gadu an o disëën a dëdë köndë fu hën sinkii musu poi. Sö Dafiti bi taki.” ");
INSERT INTO srmNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nöö hën Petuisi taa: “Un haika e, dee sëmbë. Di sëmbë Dafiti taki dë, hën da Jesosi e. Biga a bi dëdë, ma nöö Masa Gadu an disëën a dëdë köndë, a weki ën baka a dëdë. U dee sëmbë i si aki tuu seepi bi si ën ku u wojo taa sö a pasa tuu. ");
INSERT INTO srmNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nöö fa u dë aki, a dë leti a di letimaun së fëën Tata Masa Gadu a liba ala, ka a tjëën go buta a di möön kaba hebima kamian. “Nöö fa i si Masa Jesosi go ala, nöö hën di tata fëën dëën di Akaa fëën kumafa a bi paamusi ën taa a o dëën. Nöö hën Masa Jesosi toona da u ën. Nöö fa i si u ta taki dee peipei töngö fuunu aki, nöö di Akaa u Gadu hën mbei e. Sö Masa Jesosi toona da u ën tjika. ");
INSERT INTO srmNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Nöö i sabi fa Dafiti bi sikifi möön, a taa: Masa Gadu taki da mi Masa taa: ‘Sindo fii a mi letimaun së aki, ");
INSERT INTO srmNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ta luku fa mi o buta dee felantima fii a i basufutu.’ Sö wan soni Dafiti sikifi. Wë nöö fa a sikifi dë, ma na Dafiti bi go a Masa Gadu a liba ala e. ˻Fa a taki dee soni dë, na hënseei soni a ta taki, ma Masa Jesosi soni a taki.˼ ");
INSERT INTO srmNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nöö dee sëmbë u Isaëli aki, un musu sabi taa di Jesosi di un peka a di lakpa pau kii dë, hën wë Masa Gadu tei buta ko Masa fu hii mundu e. Hën da di Könu di a bi paamusi u kaa, di Keesitu.” Sö Petuisi taki da dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nöö di dee hia sëmbë jei fa a taki dë, nöö hën hati u de latja te na soni. A go a de sinkii. Hën de bai hakisi Petuisi ku dee oto Tjabukama u Masa Jesosi taa: “Woolo, dee sëmbë fuu dë, unfa woo du möön?” ");
INSERT INTO srmNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Hën Petuisi piki de taa: “Un musu disa di hogilibi fuunu, be hiniwan fuunu go dopu a di në u Jesosi Keesitu. Nöö te un du sö kaa, nöö Masa Gadu an o hoi dee hogilibi fuunu a bëë möön. Nöö a o da unu di Akaa fëën tu, faa wooko a unu liba. ");
INSERT INTO srmNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","“Wë biga Masa Gadu bi paamusi unu kaa taa sö a o da unu di Akaa fëën. Unu, ku dee mii fuunu, ku hii dee böngö fuunu, ku hii dee sëmbë dee ta dë a dee longi köndë dee a ta kai fu ko sëmbë fëën, de tuu a bi paamusi.” Sö Petuisi taki da de. ");
INSERT INTO srmNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nöö hën a tei sömëni oto soni möön ta bai de. A ta biinga ku de kodo u de musu piki di fan fëën, be de an musu feni di sitaafu ta tja kumafa dee hogihatima u di köndë o feni ën. ");
INSERT INTO srmNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nöö di a taki sö kaa, nöö hën sömëni sëmbë piki tuu. Biga di daka dë, nöö kuma wan dii dusu sëmbë sö piki di buka go dopu. Nöö hën de ko mökisi ku dee sëmbë u Masa Jesosi dee bi biibi kaa. ");
INSERT INTO srmNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nöö fa de ko biibi dë, hën de nango ta lei soni u Masa Jesosi a dee Tjabukama nöömö. De ta libi suti ku deseei ku piizii, ta begi Masa Gadu, ta njan makandi fu di de tuu ta biibi a Masa Jesosi. ");
INSERT INTO srmNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nöö di juu dë, dee Tjabukama u Masa Jesosi ta du sömëni foombofoombo soni e, te hii lanti ko ta fëëë. ");
INSERT INTO srmNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nöö fa dee sëmbë ko biibi Masa Jesosi dë, de ta libi makandi seei. De an ta mömbi deseei soni. Te wan sëmbë abi, a ta da di otowan. ");
INSERT INTO srmNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nöö ee wan sëmbë dë ku fuka, nöö di otowan o sei wan goon fëën, ee nasö wan oto soni di a abi, nöö te a feni di möni nöö a tja ko paati da dee otowan puu de a fuka. ");
INSERT INTO srmNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nöö hiniwan daka de ta ko ta mökisi a di djai u di Wosu u Masa Gadu a Jelusalen naandë. Nöö sö de ta waka ta njan makandi a dee wosu u de ku piizii, ku limbohati seei. ");
INSERT INTO srmNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nöö de ta gafa Masa Gadu nöömö. Nöö fa de ta libi dë, hii sëmbë u di köndë tuu ta luku de taa: “Aai maingë, dee sëmbë aki, bumbuu sëmbë de dë e.” Nöö hiniwan daka Masa Jesosi ta tja oto sëmbë ko nama ku de, dee sëmbë dee ta ko a Gadu fu de feni di heepi fëën. ");
INSERT INTO srmNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nöö hën de dë te wan daka, nöö hën Petuisi ku Johanisi nango a di Wosu u Masa Gadu a wan dii juu sapate. Biga hiniwan daka sëmbë bi guwenti u go begi Gadu a di lö ten dë. ");
INSERT INTO srmNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nöö di djai u di Wosu u Masa Gadu bi abi wan döö fëën de kai Hanse Nëngë Döö, nöö naandë de ta tja wan sëmbë ko buta. Di sëmbë dë bi lan sensi nëën mama bëë dendu, nöö hiniwan daka de ta tjëën go buta naandë faa musu ta pidi möni a dee sëmbë ta pasa nango a di Wosu u Gadu. ");
INSERT INTO srmNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nöö hën di di sëmbë si Petuisi ku Johanisi ta pasa nango a di Wosu, nöö hën a pidi de möni. ");
INSERT INTO srmNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nöö hën de luku ën diin. Hën Petuisi taki dëën taa: “Womi, hopo wojo luku i si.” ");
INSERT INTO srmNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hën a luku de. A a’ di pakisei taa de o dëën wan soni. ");
INSERT INTO srmNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hën a taki dëën taa: “Ma a’ möni e, ma di soni di mi abi nöö hën mi o da i. A di në u Jesosi Keesitu fu Nazalëti mi taki da i taa hopo waka e!” ");
INSERT INTO srmNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nöö hën a panjëën a leti maun faa hopo ën taanpu. Fa u du dë, hën futu u di womi ko taanga, ");
INSERT INTO srmNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","hën a hopo vu taanpu apë. Hën a denda go ku de a di djai dendu. Hën a ta waka ta djombo ta bai ta gafa Masa Gadu ta dëën tangi u di bunu di a du ën dë. ");
INSERT INTO srmNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nöö di juu dë, sömëni sëmbë bi dë a di Keikiwosu kaa, nöö de tuu si di womi fa a ta waka ta gafa Masa Gadu ta dëën tangi. ");
INSERT INTO srmNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nöö de sabi taa hën da di sëmbë bi dë sindosindo a di Hanse Nëngë Dööbuka ta pidi möni, nöö hën a ko hopo taanpu ta waka. ");
INSERT INTO srmNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nöö hën de kule go a Petuisi ku Johanisi ka de sai dë a di pisi u di Keikiwosu de kai Salumon Baiko. Nöö di womi di bi lan dë, a dë ku de maun ku maun panjanpanjan. Nöö a bigi da de te na soni. ");
INSERT INTO srmNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hën di Petuisi si dee hia sëmbë ta kule ta ko a de, hën a taki da de taa: “Dee Isaëli sëmbë u mi aki, andi bigi da unu sö? Fa di womi ko bunu aki, un ninga taa ku u seei kaakiti u kulëën nö? Ee na un mëni taa fu di hati fuu limbo möön oto sëmbë mbei Masa Gadu da u kaakiti sö? Nönö e! Nëën mbei. ");
INSERT INTO srmNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“Ma Masa Gadu, di dee fesiten sëmbë fuu bi ta begi kaa, dee Abahamu, Isaki, Jakopu sö, hën wë kë da Masa Jesosi gaan nëbai, nöö hën mbei a kula di sëmbë aki, be un sabi taa sö wan sëmbë Jesosi dë. Biga Jesosi bi dë di Futuboi u Gadu seei di a manda ko da u, ma nöö unu tjëën go da dee tiima u di köndë fuu aki u de musu kii. Hën di un tjëën go, nöö Gaama Pilati an bi si na wan föutu nëën faa musu dëdë e. Hën a taa an o kii ën, a o disëën be a go. Ma di a taki sö, nöö hën un ko ta bai taa an musu disëën go. ");
INSERT INTO srmNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“Di apaiti sëmbë u Masa Gadu, ku hën wë i si un du sö e, dee sëmbë. A bi bunu te Masa Gadu seei an feni na wan föutu nëën wan daka, ma unu taa wan këën. Hën un begi di gaama faa musu puu wan oto sëmbë a dunguwosu da unu nëën kamian. Hën un kai di sëmbë dëën. Wan gaan hogi sëmbë di bi ta kii sëmbë, hën un mbei a puu da unu. ");
INSERT INTO srmNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ma di bumbuu Sëmbë di ta da hii mundu libi, nöö hën un kii puu. “Ma fa un du dë seei, ma Masa Gadu toona weki ën baka e. Biga u seepi si ën ku u seei wojo. ");
INSERT INTO srmNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nöö hën di kaakiti fëën wë i si kula di sëmbë bi lan aki. Fu di u ta biibi nëën liba, hën mbei di sëmbë ko dë tjentjen a unu fesi aki kumafa un tuu ta si ën kaa. ");
INSERT INTO srmNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nöö haika e, dee sëmbë u mi aki. Mi sabi taa fa un ku dee hedima fuu kii Masa Jesosi dë, wan bi sabi taa sö wan gaan hogi un bi ta du e. ");
INSERT INTO srmNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","“Ma nöö gaanduwe a fesi Masa Gadu bi da dee tjabukama fëën wan buka taa di sëmbë fëën di a o manda ko a goonliba, di Keesitu, a musu tja sitaafu nöömö. Nöö hën wë i si pasa aki. ");
INSERT INTO srmNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Nöö dee sëmbë o, dee hogilibi fuunu musu hati unu te nöö un bia disa de e, ko a Masa Gadu. Nöö an o hoi unu a bëë möön. Nöö te un du sö kaa, nöö a o ta da unu böö. ");
INSERT INTO srmNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nöö a o toona manda Jesosi Keesitu ko da unu möön e. Biga a bi buta a fesi taa sö a o toona mandëën da u kaa. ");
INSERT INTO srmNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ma nöö fa u dë aki a musu fika a Masa Gadu köndë ala ufö. Te dou di juu fu Masa Gadu musu puu hogi a goonliba buta hii soni ko bunu baka ufö a o toona ko. Biga sö wan soni Masa Gadu bi paamusi dee gaan sëmbë fuu a dee tjabukama fëën taa sö a o du. ");
INSERT INTO srmNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Nöö Mosesi bi taki da dee gaan sëmbë fuu taa: Fa i si Masa Gadu manda mi ko da unu aki, nöö söseei a bakaten a o manda wan oto Tjabukama ko da unu. Nöö di sëmbë di o ko dë, a o dë di wan köndë sëmbë kuma unu. Nöö te a ko, nöö dee soni dee a o taki da unu, nöö de tuu un musu piki e. ");
INSERT INTO srmNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Biga ee wan sëmbë ja kë piki di buka u di Tjabukama dë, nöö joo kumutu a dee sëmbë u Masa Gadu dendu go kaba a sösö. Sö wë Mosesi bi taki da dee gaan sëmbë fuu e, dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Nöö hii dee tjabukama u Gadu, kumutu a Samueli te dou ku hii dee otowan dee bi ta konda soni u Gadu da sëmbë, de tuu kisi di wan seei buka taa sö wanlö soni o pasa, nöö hën de ko ta pasa a di ten u dë aki. ");
INSERT INTO srmNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","De bi konda taa sö wanlö bunu Masa Gadu o du sëmbë. Nöö unu wë da dee sëmbë dee musu kisi dee bunu dë e. Masa Gadu ku dee gaan sëmbë fuu bi abi di buka, ma unu wë ta feni dee bunu de bi taki. “Biga a bi taki da u gaan sëmbë Abahamu taa a di böngö fëën hii pei sëmbë u goonliba o feni heepi. ˻Wë nöö di böngö di a taki dë, Masa Jesosi wë e, dee sëmbë.˼ ");
INSERT INTO srmNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Hën a manda ko kuma Futuboi fëën. Nöö fa a mandëën ko dë, u dee Isaëli sëmbë fosu a mandëën da e. Biga a kë faa heepi unu mbei un disa dee hogilibi fuunu.” Sö wë Petuisi taki tuwë da dee hia sëmbë a di Keikiwosu dë. ");
INSERT INTO srmNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nöö di juu dë, Petuisi ku Johanisi an kaba u fan seei hën dee begima ku di hedima u dee siköutu dee ta watji a di Wosu u Gadu, ku dee sëmbë u di keiki paatëi de kai Sadusei, hën de ko dou a de. ");
INSERT INTO srmNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Hati u de boonu ku de te na soni, biga de ta konda da dee otowan taa Masa Jesosi dëdë toona weki baka. ˻Biga dee Saduseima an sa jei taa sëmbë sa dëdë toona weki baka.˼ ");
INSERT INTO srmNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nöö hën de kisi Johanisi ku Petuisi panjan gingin tja go söötö a dunguwosu. Nöö de o luku te amanjan bifö de o kuutu de, biga ndeti kaa. ");
INSERT INTO srmNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma nöö fa dee Tjabukama bi fan ku dee sëmbë dë, nöö wanlö hia sëmbë bia piki di buka bendi ko a di së u Masa Jesosi. Nöö fa de go mökisi ku dee oto biibima u Masa Jesosi naandë hën de ko dë kuma feifi dusu sëmbë sö. ");
INSERT INTO srmNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nöö hën de dë te mamate, hën dee Dju hedima, ku dee Gaan Womi, ku dee Sabima u Wëti, de tuu hai ko mökisi a Jelusalen naandë u de kuutu. ");
INSERT INTO srmNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Di awoo hedima u dee begima de kai Ananasi, ku di Kaba Hei Begima de kai Kajafasi, wan oto sëmbë de kai Johanisi, ku Alekesani, ku hii dee oto famii u Ananasi, sö de ko a di kuutu. ");
INSERT INTO srmNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nöö hën de manda sëmbë u de go tei de tu Tjabukama u Masa Jesosi, Petuisi ku Johanisi, tja ko a de. Nöö di de ko dou, hën de hakisi de taa: “Ku un kaakiti un kula di lan sëmbë dë? Un sëmbë në un kai ufö un du sö wan soni?” ");
INSERT INTO srmNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nöö di juu dë di Akaa u Masa Gaangadu bi dë a Petuisi liba hebi seei. Nöö hën a piki de gbelin taa: “Gaan lanti, un piimisi fuunu e. ");
INSERT INTO srmNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Un kë sabi unfa u du ufö u heepi di lan sëmbë ö? ");
INSERT INTO srmNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wë be mi taki ën da unu, biga a dë fanöudu fuun musu sabi. A dë fanöudu fu hii un dee sëmbë u Isaëli tuu musu sabi taa Jesosi Keesitu u Nazalëti hën kulëën ku ën kaakiti. Hën mbei i si a ko taanpu telutelu a unu fesi aki. Di sëmbë di un bi peka a di lakpa pau naandë kii, nöö hën kulëën e. Unu wë bi kii ën, ma Masa Gaangadu weki ën baka. ");
INSERT INTO srmNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Wë wan sabi fa de sikifi ën buta a Masa Gaangadu Buku nö? De taa: Dee sëmbë ta mbei sitonu wosu, hën de si wan sitonu taa an bunu, nöö hën de tuwëën a kapëë. Ma nöö bakaten, hën di sitonu dë ko mama posu u di wosu. Wë di sitonu dë, Masa Jesosi wë e, dee sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hën nöö sa puu sëmbë a hogi basu fii sa dou a Masa Gaangadu fesi. Oto në an dë a goonliba aki möönsö di u libisëmbë sa kai fuu feni di heepi u Gadu.” ");
INSERT INTO srmNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wë nöö di dee kuutuma jei fa Petuisi ku Johanisi ta fan söndö fëëë sö, hën de taa: “Maingë, dee sëmbë aki, na sösö sinkii sëmbë de dë nö? Biga de an go a siköö wan bëtë, ma nöö hën de ko ta fan ku u söndö fëëë sö.” Di soni bigi da de, nöö hën de ko si taa di fa dee Tjabukama bi ta dë ku Masa Jesosi, hën wë mbei de sabi u fan sö. ");
INSERT INTO srmNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nöö soni an dë u fia möön tu. Biga di lan womi di de bi kula sai leti dë taanputaanpu ku de. ");
INSERT INTO srmNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nöö hën de manda Petuisi ku Johanisi ku di womi di bi lan taa be de kumutu a di kuutu kamba ufö. Nöö hën de kumutu go. Nöö hën dee kuutuma fika dë ta hakisi taa: ");
INSERT INTO srmNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Wë unfa woo du ku dee sëmbë? Biga hii sëmbë fu Jelusalen aki tuu sabi fa de bi kula di lan sëmbë dë. A dë wan gaan foondo soni da hii mundu, nöö wa sa fia, biga a bödjëë tuu. ");
INSERT INTO srmNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma nöö un boo bai de nöö taa de an musu tei di në u Jesosi ta paaja a di köndë möön.” ");
INSERT INTO srmNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nöö di de kuutu tefa de kaba, hën de toona kai Petuisi ku Johanisi taa be de ko. Hën de ko dou. Hën de buta ku de seei taa de an musu ta kai di në u Jesosi ta lei sëmbë soni fëën möön a mundu. ");
INSERT INTO srmNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nöö hën Petuisi ku Johanisi piki de taa: “Lanti, fa un taki da u aki, nöö u jei. Un bai u taa wa musu konda soni u Masa Jesosi. Ma Masa Gaangadu manda u fuu musu konda. Nöö unfa un mëni? Undi u dee buka un si kuma Masa Gaangadu o kë fuu musu piki? ");
INSERT INTO srmNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wë nöö wa sa tjubi dee soni u wojo bi si ku dee u jesi bi jei. U musu konda de nöömö.” Sö de piki de. ");
INSERT INTO srmNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hën dee kuutuma toona bai de seei gbelin taa de an musu konda de, nöö hën de manda de go. De an saanfa u de du fu de musu da de sitaafu, biga hii sëmbë ta gafa Masa Gaangadu ta bai ën në fu di gaan soni di bi pasa dë. ");
INSERT INTO srmNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Biga di sëmbë di de bi kula a di gaan foondo fasi dë, nöö a bi abi jaa pasa föteni, ma an bi waka wan daka. ");
INSERT INTO srmNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nöö fa dee kuutuma manda Petuisi ku Johanisi go dë, nöö hën de go a dee oto biibima u Masa Jesosi go taki da de unfa dee Gaan Begima ku dee Gaan Womi bi taki da de. Hën de konda te de kaba. ");
INSERT INTO srmNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nöö di dee otowan u de jei sö, nöö hën de tuu ko ta gafa Masa Gaangadu taa: “Masa Gadu oo, i mbei hii soni a liba ala, ku goon aki tuu, te dou ku di ze. ");
INSERT INTO srmNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nöö hën i manda di Akaa fii faa fan a di futuboi fii liba, u gaan avo Dafiti, taa: Andi du dee peipei sëmbë u goonliba mbei hati u de boonu sö? Faandi mbei de ta suku pasi sö te de wei, u de du hogi ku Masa Gaangadu? ");
INSERT INTO srmNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dee könu u goonliba ku dee oto tiima tuu ta hai ko fiti buka u de feti ku Masa Gaangadu puu hën ku di Könu fëën di a buta, a de liba. Sö Dafiti taki. ");
INSERT INTO srmNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Wë nöö Masa Gaangadu, di soni Dafiti bi taki dë hën wë i si ta pasa fa u dë aki. Biga dee hedima u goonliba, Helodi ku Pontuisi Pilati, ku dee Isaëli sëmbë fuu, ku dee oto köndë sëmbë tuu ko mökisi leti a Jelusalen aki fu de du hogi ku Masa Jesosi, di Futuboi fii di dë apaiti da i. Di Sëmbë di i bi da taki a hii mundu liba, nöö hën de bi sitaafu sö e. ");
INSERT INTO srmNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nöö hën de du hii dee soni dee i bi buta a fesi taa sö o pasa. Wë Masa, sö i seei abi di kaakiti tuu, fu buta hii soni fu de musu pasa leti kumafa i bi kë. ");
INSERT INTO srmNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Nöö fa u dë aki ja si o? Dee sëmbë bai u taa de o du ku u. Nöö hën u begi i, Masa, fii da u dee futuboi fii degihati, be u sa ta konda di Buka fii nöömö söndö fëëë. ");
INSERT INTO srmNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Masa Gaangadu, i musu kula dee suwakima, be sëmbë si di kaakiti fii di i abi. Be u tei di në u Masa Jesosi ta du foondofoondo soni, be hii sëmbë si di kaakiti di a abi. Biga hën wanwan tö dë di apaiti Futuboi fii di i buta. Nöö da sö u begi i, Masa.” ");
INSERT INTO srmNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nöö di de begi sö te de kaba, hën di kamian ka de dë ko ta seki seei te na soni. Hën di Akaa u Masa Gaangadu toona ko taanga a de liba, hën de ko ta konda di buka u Gadu seei söndö fëëë. ");
INSERT INTO srmNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nöö di juu dë, hii dee biibima u Masa Jesosi tuu bi dë ku wan hati. Na wan sëmbë ta hoi ën gudu buta nëën wosu fëën wanwan, ma de tuu ta abi soni makandi. ");
INSERT INTO srmNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hën dee Tjabukama u Masa Jesosi ta konda da lanti nöömö fa Masa Jesosi weki a dëdë. Nöö fa de ta fan dë, di fan u de abi kaakiti, nöö a dë u si tuutuu taa Masa Gaangadu ta tja de ku ën bunuhati seei. ");
INSERT INTO srmNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Fa de sai dë, na wan sëmbë bi dë a de dendu ta pena. Biga ee wan sëmbë i dë ku pena nöö dee otowan ee dee a’ goon ee nasö wosu, nöö de ta sei ën ");
INSERT INTO srmNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nöö de tei di möni tja ko da dee Tjabukama u Masa Jesosi. Nöö dee Tjabukama tei di möni nöö de paati da dee penama puu de a fuka. Sö de bi ta libi di ten dë. ");
INSERT INTO srmNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nöö hën wan sëmbë bi dë de kai Josëfu. Dee Tjabukama u Masa Jesosi ta kai ën Banabasi; hën kë taki “wan sëmbë di ta da sëmbë hati.” Nöö a dë u di lö u Isaëli de kai Leifi, nöö a kumutu a di köndë de kai Sipuusi. ");
INSERT INTO srmNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nöö hën di womi aki bi abi wan goon, hën a sei ën. Hën a tei hii di möni fëën tuu tja ko da dee Tjabukama u Masa Jesosi u de paati da sëmbë. ");
INSERT INTO srmNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Di juu dë, hën wan womi bi dë de kai Ananiasi, nöö hën mujëë de kai Safila. Nöö de bi abi wan goon u de. Nöö hën de sei di goon. ");
INSERT INTO srmNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nöö hën di womi tei hafu u di möni hoi buta dë, hën a tei di fika tja go da dee Tjabukama u Masa Jesosi ˻taa tuu u di möni di a sei di goon hën di dë˼. Nöö fa a du dë, hën mujëë seei dë a dendu tu. ");
INSERT INTO srmNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nöö di a du sö, hën Petuisi gandji dëën taa: “Womi Ananiasi, unfa i du bifö di didibi subi a i liba sö, te i kë ganjan di Akaa u Masa Gadu? ");
INSERT INTO srmNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Andi mbei i du sö? I seei bi abi di goon, nöö di i sei ën kaa, nöö i bi sa hoi hii di möni. Ma nöö hën i tjubi hafu fëën buta dë, hën i tei di fika tja ko da u taa ˻tuu fëën di dë˼. Wë na ku libisëmbë i du di hogi e, ma ku Masa Gadu i du ën.” ");
INSERT INTO srmNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nöö di Ananiasi jei di fan wante, nöö hën a tombi kai a goon dëdë pii, böö fëën koti. Nöö fa di soni pasa dë, dee oto sëmbë jei nöö hati u de latja seei. ");
INSERT INTO srmNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nöö hën wanlö kijoo mii hopo hën de ko dimboli di dëdë tefa de kaba, hën de tei ën tja go bei. ");
INSERT INTO srmNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hën de dë te baka dii juu langa sö, hën di mujëë u di womi ko dou. An bi sabi taa sö wan soni bi pasa ku ën manu. ");
INSERT INTO srmNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nöö di a ko dou, hën Petuisi hakisi ën taa: “Mujëë, haika. Fa di manu fii bi tja di möni u di goon ko aki, tuu fëën a tja nö?” Hën a piki taa: “Aai, tuu fëën di dë e.” ");
INSERT INTO srmNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Hën Petuisi toona taki dëën taa: “Faandi mbei i ku i manu tuu fiti buka makandi taa woon pooba di Akaa u Masa Gadu luku sö? Wë dee womi mii dee bi tja di manu fii go bei, haika futu u de a dööbuka dë. Nöö de o tja i go bei tu e.” ");
INSERT INTO srmNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hën di a taki sö, di mujëë jei. Hën a kai gbolo a Petuisi fesi dë dëdë pii. Hën dee kijoo ko dou, hën de si ën dë dëdëdëdë. Hën de toona hopo ën tei tja go bei nëën manu bandja. Sö wan gaan soni pasa di juu dë. ");
INSERT INTO srmNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nöö di dee biibima u Masa Jesosi ku dee oto sëmbë jei, nöö hën hii de tuu fëëë te na soni. ˻De si taa libi u de musu dë tololoo a pasi seei.˼ ");
INSERT INTO srmNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Di juu dë, dee Tjabukama u Masa Jesosi ta du hia soni, foondofoondo wan kuma maaka sö, ˻nöö sëmbë ta si taa Gadu dë ku de tuu˼. Nöö dee sëmbë dee ta biibi a Masa Jesosi ta ko a di kamian u di Keikiwosu de kai Salumon Baiko nöömö ta mökisi makandi. ");
INSERT INTO srmNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ma fa de ta ko dë, na de ku oto sëmbë e. Biga dee oto sëmbë dee an ta biibi a Masa Jesosi liba, de ta fëëë seei u de ko mökisi ku de, hii fa de ta gafa de nöömö taa bumbuu sëmbë de dë. ");
INSERT INTO srmNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nöö dee sëmbë u Masa Jesosi ta ko möön hia seei. Hiniwan juu oto sëmbë ta ko biibi, womi ku mujëë tuu, ta mökisi ku dee otowan bi biibi a fesi. ");
INSERT INTO srmNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nöö fa Gadu ta da dee Tjabukama kaakiti tjika dë, nöö sëmbë ta tja dee suwakima u de ta ko ta buta a bandja pasi. De ta tja de ta buta a kama liba a goon dë, so u de dë a bedi, nöö de dë ta luku Petuisi faa pasa dë, sonte di jeje fëën sa kai a de nöö de sa ko bunu. ");
INSERT INTO srmNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Gaan hia sëmbë seei ta kumutu a dee köndëköndë a Jelusalen bandja dë ta tja dee suwakima u de ta ko, ku dee sëmbë dee dë ku soni a hedi ta sitaafu de ta kii. Nöö de tuu dee Tjabukama kula ko bunu. ");
INSERT INTO srmNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nöö fa dee Tjabukama u Masa Jesosi ta du dee foombo soni sö, nöö hën di Kaba Hei Begima u dee Isaëli sëmbë ku dee mati fëën u di Sadusei paatëi, de ko ta haun ku de te na soni. ");
INSERT INTO srmNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Te wan daka, hën de go kisi de tja go söötö a dunguwosu. ");
INSERT INTO srmNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma a di ndeti dë seei, hën wan basia u Masa Gadu Köndë ko jabi dee döö u di dunguwosu puu dee Tjabukama tja ko a döö. ");
INSERT INTO srmNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Hën a taki da de taa: “Un go taanpu a di Wosu u Masa Gadu e, nöö un ta konda da lanti nöömö taa wan njunjun libi dë u feni a Masa Gadu. Un puu hii soni fëën da de be de sabi.” ");
INSERT INTO srmNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nöö hën dee Tjabukama piki. Biga di dobooko fëën, hën de toona go dë a di Wosu go ta lei lanti leti kumafa di basia bi taki da de. Di mamate dë seei, hën di Kaba Hei Begima ku dee mati fëën ko makandi u de kuutu di soni u dee Tjabukama u Masa Jesosi. Hën de kai hii dee hedima u dee Isaëli sëmbë ku hii dee oto kuutuma u Isaëli tuu taa be de ko a kuutu. Hën di de ko, hën de manda buka da dee wakitima u di dunguwosu taa be de go tei dee Tjabukama tja ko da de. ");
INSERT INTO srmNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nöö hën dee wakitima go. Ma nöö di de go dou nöö pii, djee. Dee sëmbë an sai dë. Hën de toona go a dee kuutuma go taa: ");
INSERT INTO srmNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Dee sëmbë aki, wë u dou e. Nöö gaan soni. Dee sëmbë dee un manda u fuu go tei, wa si de e. U go a di dunguwosu, u si dee döö tuu dë söötösöötö ku dee siköutu dë a dee dööbuka ta hoi wakiti tuu u si. Ma nöö di u go dou hën u jabi di döö, wa si sëmbë. De an sai dë e. Wa sabi naasë de go.” ");
INSERT INTO srmNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nöö di di Kaba Hei Begima ku dee Gaan Begima ku di hedima u dee wakitima u di Wosu u Gadu jei sö, nöö a toobi de tumisi. De an saandi pasa. ");
INSERT INTO srmNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Te wan pisi, hën wan sëmbë ko dou, a taa: “Un haika e, dee sëmbë. Dee womi un bi buta a dunguwosu, de dë leti 