﻿USE sofia;
DROP TABLE IF EXISTS sofia.sri_vpl;
CREATE TABLE sri_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sri_vpl WRITE;
INSERT INTO sri_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo ñekʉ̃sãmarã iripoegue marã ãsũ ããrĩnerã ããrĩmá. Jesucristo, David parãmi ããrĩturiagʉ ããrĩdi ããrĩmí. David, Abraham parãmi ããrĩturiagʉ ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaac pagʉ, Isaac Jacob pagʉ, Jacob Judásã pagʉ ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá pũrã Fares, Zara wãĩkʉrã ããrĩnerã ããrĩmá. Ĩgʉ̃sã pago Tamar wãĩkʉdeo ããrĩmó. Fares Esrom pagʉ, Esrom Aram pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab pagʉ, Aminadab Naasón pagʉ, Naasón Salmón pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz pagʉ ããrĩdi ããrĩmí. Ĩgʉ̃ pago Rahab wãĩkʉdeo ããrĩmó. Booz, Obed pagʉ ããrĩdi ããrĩmí. Ĩgʉ̃ pago Rut wãĩkʉdeo ããrĩmó. Obed Isaí pagʉ ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí Israel bumarã opʉ David pagʉ ããrĩdi ããrĩmí. David, Urías marãpo ããrĩdeo merã Salomón wãĩkʉgʉre pũrãkʉdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboam pagʉ, Roboam Abías pagʉ, Abías Asa pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafat pagʉ, Josafat Joram pagʉ, Joram Uzías pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotam pagʉ, Jotam Acaz pagʉ, Acaz Ezequías pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías Manasés pagʉ, Manasés Amón pagʉ, Amón Josías pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías, Jeconíasã pagʉ ããrĩdi ããrĩmí. Ĩgʉ̃sã ããrĩripoere Israel bumarãrẽ Babilonia marã gapʉ ñeã, ĩgʉ̃sãya nikũgue ãĩãnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Irasirigʉ, Jeconías Babilonia nikũgue Salatiel wãĩkʉgʉre pũrãkʉdi ããrĩmí. Salatiel Zorobabel pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abiud pagʉ, Abiud Eliaquim pagʉ, Eliaquim Azor pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Zadoc pagʉ, Zadoc Aquim pagʉ, Aquim Eliud pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar pagʉ, Eleazar Matán pagʉ, Matán Jacob pagʉ, ");
INSERT INTO sri_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob, José pagʉ ããrĩdi ããrĩmí. José, María marãpʉ ããrĩdi ããrĩmí. María, Jesús masakare taubu “Cristo” wãĩkʉgʉ pago ããrĩdeo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham merã keopʉrori, Daviguere marĩ keotũnumakʉ̃, ããrĩpererã Abraham parãmerã ããrĩturiarã catorce burigora masãporewãgãnerã ããrĩmá. David merã ĩgʉ̃ parãmerã ããrĩturiarãrẽ keomakʉ̃, Babiloniague Israel bumarãrẽ ĩgʉ̃sã ãĩaburo dupuyuro keotũnumakʉ̃, catorce burigora masãporewãgãnerã ããrĩmá. Dupaturi Babiloniague ĩgʉ̃sã ejadero pʉrʉ, ĩgʉ̃sã parãmerã ããrĩturiarãrẽ keopʉrorimakʉ̃, Cristo deyoadero pʉrʉ keotũnumakʉ̃, catorce burigora masãporewãgãnerã ããrĩmá doja. ");
INSERT INTO sri_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo deyoaburi ãsũ waayuro. Ĩgʉ̃ pago María, José merã marãpʉkʉbo iriyupo. Ĩgʉ̃sã suro merã ããrĩrikʉburo dupuyuro Õãgʉ̃ deyomarĩgʉ̃ turari merã nijĩpo ããrĩnʉgãsiayupo. ");
INSERT INTO sri_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José igo merã mojõsiabu diayemarẽ irigʉ ããrĩyupʉ. Irasirigʉ, igo nijĩpo ããrĩrĩ́rẽ masĩgʉ̃, masaka ĩũrõgue igore: “Ñerõ irideo ããrĩmó”, ãrĩ weresãdʉabi, ĩgʉ̃sã masĩbirimakʉ̃ta igore béobu iriadiyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Irire ĩgʉ̃ gũñaripoe Marĩpʉre wereboegʉ, kẽrõgue ĩgʉ̃rẽ deyoa, ãsũ ãrĩyupʉ: —José, David parãmi ããrĩturiagʉ, Maríare ñerõ gũñabirikõãka! Igo, Õãgʉ̃ deyomarĩgʉ̃ turari merã nijĩpo ããrĩnʉgãsiamo. Irasirigʉ güiro marĩrõ igo merã mojõsiaka! ");
INSERT INTO sri_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Igo majĩgʉ̃rẽ pũrãkʉgokumo. Ĩgʉ̃ ĩgʉ̃yarã masakare ĩgʉ̃sã ñerĩ iridea wajare taubu ããrĩgʉkumi. Irasirigʉ ĩgʉ̃rẽ “Jesús” wãĩyegʉkoa, ãrĩyupʉ Marĩpʉre wereboegʉ Josére. ");
INSERT INTO sri_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","I ããrĩpereri Marĩpʉ ĩgʉ̃ya kerere weredupuyudire gojadorederosũta waayuro. Ãsũ ãrĩ gojasũdero ããrĩbʉ́: ");
INSERT INTO sri_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Sugo nomeõ ʉ̃mʉ́ʉ merã ããrĩbirikerego, sugʉ majĩgʉ̃ pũrãkʉgokumo. Ĩgʉ̃ “Emanuel” wãĩkʉgʉkumi, ãrĩ gojasũdero ããrĩbʉ́. “Emanuel”, ãrĩrõ: “Marĩpʉ marĩ merãta ããrĩ́mi”, ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José kãrĩadi yobeja, pʉrʉ Marĩpʉre wereboegʉ ĩgʉ̃rẽ doreaderosũta María merã mojõsiayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Irasirikeregʉ, igo magʉ̃rẽ pũrãkʉburo dupuyuro igore marãpokʉbi irirosũ ããrĩkõãyupʉ. Igo pũrãkʉadero pʉrʉ, majĩgʉ̃rẽ “Jesús” wãĩyeyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes wãĩkʉgʉ, Judea nikũ marã opʉ ããrĩripoe Jesús iri nikũma makã Belẽ́gue deyoayupʉ. Ĩgʉ̃ deyoadero pʉrʉ, abe mʉrĩriro gapʉ marã neñukãrẽ õãrõ masĩrĩmasã Jerusalẽ́gue ejañurã. ");
INSERT INTO sri_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Irogue eja, iri makã marãrẽ sẽrẽñañurã: —Sugʉ majĩgʉ̃ deyoadi judío masaka opʉ ããrĩbu, ¿noógue ããrĩ́rĩ? Gʉaya nikũgue gʉa ããrĩmakʉ̃, abe mʉrĩriro gapʉ neñukãmʉ ĩgʉ̃ deyoarire ĩmugʉ̃ boyopʉrorimakʉ̃ ĩãbʉ́. Irasirirã ĩgʉ̃rẽ bʉremurã aarirã́ iriabʉ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Opʉ Herodes ĩgʉ̃sã irasũ ãrãdeare pébokagʉ, bʉro gũñarikʉyupʉ. Ããrĩpererã Jerusalén marãde gũñarikʉñurã. ");
INSERT INTO sri_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Irasirigʉ Herodes ããrĩpererã paía oparãrẽ, Moisés doredeare buerimasãdere siiu neeõ, ĩgʉ̃sãrẽ sẽrẽñayupʉ: —Cristo, Marĩpʉ iriubu, ¿noógue deyoabu ããrãyuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ãsũ ãrĩ yʉjʉñurã: —Judea nikũma makã Belẽ́gue deyoagʉkumi. Iripoegue Marĩpʉya kerere weredupuyudi ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén wãĩkʉri makãgue sugʉ Opʉ deyoagʉkumi. Ĩgʉ̃ Marĩpʉyarã Israel bumarãrẽ korebu ããrĩgʉkumi. Irasiriro Belén Judea nikũ ããrĩrĩ́ makãrĩ watope ubu ããrĩrĩ́ makã ããrĩkerero, gaji makãrĩ nemorõ ããrĩrokoa, ãrĩ gojadi ããrĩmí, ãrĩ wereñurã Herodere. ");
INSERT INTO sri_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Herodes masĩrĩmasãrẽ siiu, masaka péberogue sẽrẽñayupʉ: —¿Naásũ ããrĩmakʉ̃ neñukãmʉ deyoari? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“Irinʉgue deyoami”, ãrĩ yʉjʉmakʉ̃ pégʉ, ĩgʉ̃sãrẽ Belẽ́gue ãsũ ãrĩ iriuyupʉ: —Iro marãrẽ: “¿Noógue ããrĩ́rĩ, majĩgʉ̃ deyoadi?” ãrĩ sẽrẽñarã waaka! Ĩgʉ̃rẽ bokajarã, õõta goedujarika, yʉre ĩgʉ̃ ããrĩrṍrẽ weremurã! Yʉde ĩgʉ̃rẽ bʉremugʉ̃ waadʉakoa, ãrĩyupʉ ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, Belẽ́gue waakõãñurã. Maague waamakʉ̃, neñukãmʉ, abe mʉrĩriro gapʉ boyoadi ĩgʉ̃sã dupuyuro waadupuyuyupʉ, ĩgʉ̃sã waarí maarẽ́ ĩmugʉ̃. Ĩgʉ̃sã neñukãmʉrẽ ĩãrã, bʉro ʉsʉyañurã. Neñukãmʉ ĩgʉ̃sã dupuyuro waa, majĩgʉ̃ ĩgʉ̃ ããrĩrĩ́ wii weka dujanʉgãjayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Irasirirã iri wiigue ñajãrã, majĩgʉ̃rẽ, ĩgʉ̃ pago María merã ããrĩgʉ̃́rẽ bokajañurã. Ĩgʉ̃rẽ ĩã, ĩgʉ̃ pʉro ñadʉkʉpuri merã ejamejã: “Õãtarimi”, ãrĩ bʉremuñurã. Ĩgʉ̃sã ãĩadea kũmarĩrẽ tũpã: oro, incienso, mirra wãĩkʉri sʉ̃rõrĩ wajaparire ĩgʉ̃rẽ sĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pʉrʉ ĩgʉ̃sã kãrĩripoe Marĩpʉ kẽrõgue wereyupʉ: —Mʉsãya makãgue goedujáarã, Herodes pʉro waarí maarẽ́ dujáabirikõãka! Gaji maa gapʉ dujáaka! ãrĩ wereyupʉ. Irasirirã gaji maa gapʉ goedujáañurã. ");
INSERT INTO sri_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Masĩrĩmasã goedujáadero pʉrʉ, Marĩpʉre wereboegʉ Josére kẽrõgue deyoa, ãsũ ãrĩ wereyupʉ: —Yobeka! Majĩgʉ̃rẽ, ĩgʉ̃ pago merã Egipto nikũgue ãĩduriwãgãka! Yʉ mʉrẽ: “Dujarika!” ãrĩ weremakʉ̃gue dujarika! Herodes majĩgʉ̃rẽ ãmabu yámi ĩgʉ̃rẽ wẽjẽbu, ãrĩ wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, José yobe, majĩgʉ̃rẽ ãĩ, pago merã ñamita Egiptogue waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herodes okaropã irogue ããrĩñurã. Irasiriro Marĩpʉya kerere weredupuyudi Marĩpʉ magʉ̃rẽ ĩgʉ̃ ãrĩdeare gojaderosũta waayuro. Marĩpʉ ãsũ ãrĩdi ããrĩmí: “Yʉ magʉ̃rẽ Egiptogue ããrĩgʉ̃́rẽ siiubʉ”. ");
INSERT INTO sri_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes, masĩrĩmasã ĩgʉ̃ pʉro goedujáabirimakʉ̃ ĩãgʉ̃, guatariakõãyupʉ. Irasirigʉ Belén marãrẽ, iri makã tʉro ããrĩrã́dere ʉ̃ma pũrãgãrẽ wẽjẽpeokõãdoreyupʉ. Masĩrĩmasã ãrĩdeare gũñagʉ̃: “Õõpãta majĩgʉ̃ masãkumi”, ãrĩ gũñayupʉ. Irasirigʉ pe bojori oparãrẽ, pe bojori doka oparãrẽ wẽjẽbéodoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ĩgʉ̃ irasiriri Jeremías Marĩpʉya kerere weredupuyudi gojaderosũta waayuro. Ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá wãĩkʉrogue bʉro bʉjawereri merã dʉjaritua, orerãkuma. Raquel parãmerã ããrĩturiarã Israel bumarã nome ĩgʉ̃sã pũrãrẽ bʉro orerãkuma. Ĩgʉ̃sã pũrãrẽ wẽjẽmakʉ̃ ĩãrã, bʉjawereduúbirimakʉ̃, gajerã ĩgʉ̃sãrẽ gũñaturamakʉ̃ irimasĩbirikuma, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes boadero pʉrʉ, Marĩpʉre wereboegʉ Josére Egiptogue ããrĩgʉ̃́rẽ kẽrõgue deyoa, ãsũ ãrĩyupʉ doja: ");
INSERT INTO sri_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Majĩgʉ̃rẽ wẽjẽdʉanerã boapereakõãma. Irasirigʉ majĩgʉ̃rẽ, pago merã Israel bumarãya nikũgue ãĩ dujáaka doja! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, José yobe, majĩgʉ̃rẽ, pago merãta Israel bumarãya nikũgue ãĩãkõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","José gapʉ Judea nikũgue ejagʉ, Herodes magʉ̃ Arquelao wãĩkʉgʉ ĩgʉ̃ pagʉ dagʉre gorawayudi ããrĩ́mi, ãrĩrĩ kerere pégʉ, güiyupʉ. Irasirigʉ, kẽrõgue Marĩpʉ ĩgʉ̃rẽ werederosũta Judea nikũrẽ taria, Galilea nikũgue waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Iri nikũguere Nazaret wãĩkʉri makãgue eja, ããrĩyupʉ. Irasiriro Marĩpʉya kerere weredupuyunerã gojaderosũta waayuro. Ãsũ ãrĩ gojanerã ããrĩmá: “‘Cristo, Marĩpʉ iriudi Nazaretmʉta ããrĩ́mi’, ãrĩrãkuma masaka”, ãrĩ gojanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Iripoere Juan masakare wãĩyerimasʉ̃ Judea nikũ masaka marĩrõgue ĩgʉ̃ pʉro ejarãrẽ Marĩpʉyare buenʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ãsũ ãrĩ werenayupʉ: —Mʉsã ñerõ iririre bʉjawereka! Mʉsã gũñarĩrẽ gorawayuka! Mérõ dʉyáa, Marĩpʉ ĩgʉ̃yarãrẽ doreri ejaburo, ãrĩ werenayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iripoeguemʉ Isaías Marĩpʉya kerere weredupuyudi, Juan iriburire ãsũ ãrĩ gojadi ããrĩmí: Sugʉ, masaka marĩrõgue bʉro gainírĩ merã: “Marĩ Opʉ aariburi dupuyuro ĩgʉ̃ aariburi maarẽ́ diayema maa õãrĩ maa ãmurã́ irirosũ diayemarẽ irika!” ãrĩ weregʉkumi, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juãya suríro camellu poari merã suadea suríro ããrĩyuro. Ĩgʉ̃ya yʉjʉwẽñarĩdade waibʉ gasiro merã irideada ããrĩyuro. Poreroa, mume makãnʉ́ʉ marãyare baarikʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén marã, ããrĩperero Judea nikũ marã, dia Jordán wãĩkʉdiya tʉro marãde ĩgʉ̃rẽ pérã ejañurã. ");
INSERT INTO sri_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ĩgʉ̃sã ñerõ irideare bʉjawere, Marĩpʉre weretarimakʉ̃ ĩãgʉ̃, ĩgʉ̃sãrẽ deko merã wãĩyeyupʉ dia Jordán wãĩkʉdiyague. ");
INSERT INTO sri_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juan, wárã fariseo bumarã, saduceo bumarã ĩgʉ̃rẽ wãĩyedorerã ejamakʉ̃ ĩãgʉ̃, ãsũ ãrĩyupʉ: —Mʉsã ãña irirosũ ñerã ããrã. ¿Noã mʉsãrẽ õõguere aaridoreari? “Marĩpʉ, gʉa ñerõ iriri waja gʉare wajamoãbirikõãburo”, ãrĩrã, ¿yʉre wãĩyedorerã aarari? ");
INSERT INTO sri_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mʉsã: “Gʉa ñerõ irideare bʉjawere, gũñarĩrẽ gorawayuabʉ”, ãrĩrã, mʉsã ñerõ irideare piri, õãrĩ gapʉre irika! Mʉsã irasirimakʉ̃, Marĩpʉ mʉsãrẽ wajamoãbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mʉsã: “Gʉa Abraham parãmerã ããrĩturiarã ããrĩmakʉ̃, Marĩpʉ gʉare wajamoãbirikumi”, ãrĩ gũñabirikõãka! Yʉ mʉsãrẽ ãsũ ãrã: “Mʉsã gũñarĩrẽ gorawayubirimakʉ̃, mʉsã Abraham parãmerã ããrĩturiari wajamáa. Marĩpʉ i ʉ̃tãyeri merã Abraham parãmerã ããrĩturiarã waamakʉ̃ irimasĩmi”. ");
INSERT INTO sri_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mʉsã ñerĩ iririre piribirimakʉ̃ ĩãgʉ̃, Marĩpʉ mʉsãrẽ béogʉkumi. Sugʉ yukʉ ñerĩ dʉkakʉdire ĩã, kõme merã nugũrĩgue merãta diti, peamegue soebéorosũ mʉsãrẽ béogʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mʉsã ñerõ irideare bʉjawere, mʉsã gũñarĩrẽ gorawayumakʉ̃ ĩãgʉ̃, yʉ mʉsãrẽ deko merã wãĩyegʉkoa. Yʉ pʉrʉ aarigʉ́, yʉ nemorõ turagʉ ããrĩ́mi. Yʉ gapʉ ubu ããrĩgʉ̃́, ĩgʉ̃rẽ neõ sʉropebirikoa. Ĩgʉ̃ mʉsãrẽ Õãgʉ̃ deyomarĩgʉ̃ merã, peame merã wãĩyegʉkumi. Irasirigʉ Õãgʉ̃ deyomarĩgʉ̃rẽ mʉsã merã ããrĩnímakʉ̃ irigʉkumi, ñerĩrẽ soebéorosũ mʉsãrẽ ñerĩrẽ béoburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Trigo gasirire korobéogʉ irirosũ ããrĩ́mi. Gasirire koro odo, iri yerire baari duripíri wiigue duripígʉ irirosũ õãrõ irirãrẽ ĩgʉ̃ pʉrogue ãĩagʉkumi. Gasiri gapʉre peamegue soebéogʉ irirosũ ñerõ irirãrẽ peamegue béogʉkumi. Iri peame neõ yaribirikoa, ãrĩ werenayupʉ Juan masakare. ");
INSERT INTO sri_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Juan masakare dia Jordán wãĩkʉdiyague deko merã wãĩyeripoe Jesús Galileague ããrãdi ĩgʉ̃rẽ wãĩyedoregʉ waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Irogue ejamakʉ̃, Juan ĩgʉ̃rẽ wãĩyedʉabiradiyupʉ: —¿Mʉ gapʉ yʉre wãĩyerono irigʉ yʉre wãĩyedoregʉ aaríri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","16","Jesús gapʉ ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉre wãĩyeka! Marĩrẽ ããrĩpereri Marĩpʉ dorederosũta iriro gããmea. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ: “Jáʉ”, ãrĩ, Jesúre wãĩyeyupʉ. Wãĩye odomakʉ̃, Jesús diague níadi majãnʉgãmakʉ̃ta, ʉ̃mʉgasi tũpãkõãyuro. Õãgʉ̃ deyomarĩgʉ̃ buja irirosũ deyogʉ dijari, ĩgʉ̃ weka ejabejamakʉ̃ ĩãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ãsũ ãrĩyupʉ Jesúre: —Ĩĩ yʉ magʉ̃, yʉ maĩgʉ̃ ããrĩ́mi. Ĩgʉ̃ merã bʉro ʉsʉyáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pʉrʉ Õãgʉ̃ deyomarĩgʉ̃ Jesúre masaka marĩrõgue ãĩayupʉ, wãtĩ ĩgʉ̃rẽ ãrĩmesãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iroguere Jesús cuarenta nʉrĩ, cuarenta ñamĩrĩgora baabiriyupʉ. Pʉrʉ ʉaboakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ĩgʉ̃ ʉaboamakʉ̃ ĩãgʉ̃, wãtĩ ĩgʉ̃ pʉro eja, ãsũ ãrĩyupʉ: —Diayeta Marĩpʉ magʉ̃ ããrĩgʉ̃́, mʉ turaro merã i ʉ̃tãyerire pã́ duparu waamakʉ̃ irika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús gapʉ ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉpʉya werenírĩ gojadea pũgue: “Baari dita masakare okamakʉ̃ iribea. Ããrĩpereri Marĩpʉya werenírĩ gapʉ ĩgʉ̃sãrẽ okamakʉ̃ yáa”, ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ Jesús wãtĩrẽ. ");
INSERT INTO sri_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pʉrʉ wãtĩ Marĩpʉya makã Jerusalẽ́gue Jesúre ãĩa, Marĩpʉya wii wekague ãĩmʉrĩa, ");
INSERT INTO sri_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ĩgʉ̃rẽ ãsũ ãrĩyupʉ: —Diayeta Marĩpʉ magʉ̃ ããrĩgʉ̃́, yebague parimadijaka! Ĩgʉ̃ya werenírĩ gojadea pũgue: Marĩpʉ ĩgʉ̃rẽ wereboerãrẽ mʉrẽ koredoregʉkumi, neõ ʉ̃tãyegue meébejabirikõãburo, ãrĩgʉ̃, ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ wãtĩ Jesúre. ");
INSERT INTO sri_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉpʉya werenírĩ gojadea pũgue: “Bʉremurĩ marĩrõ Marĩpʉre: ‘Mʉ turari merã yʉre gajino iri ĩmuka!’ ãrĩbirikõãka!” ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ Jesús wãtĩrẽ. ");
INSERT INTO sri_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pʉrʉ wãtĩ Jesúre ʉ̃marĩ buúru wekague ãĩmʉrĩayupʉ doja. Irogue ããrĩpereri i ʉ̃mʉma makãrĩrẽ, masaka oparidere ĩmupeokõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Irire ĩmupeo, Jesúre ãsũ ãrĩyupʉ: —Mʉ ñadʉkʉpuri merã ejamejãja, yʉre: “Mʉ, yʉ Opʉ ããrã”, ãrĩ bʉremumakʉ̃, i ããrĩpererire mʉrẽ sĩgʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús ãsũ ãrĩyupʉ: —Satanás, yʉ pʉrore wirika! Yʉpʉya werenírĩ gojadea pũgue: “Marĩpʉ direta bʉremuka! Ĩgʉ̃ doreri direta irika!” ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ Jesús wãtĩrẽ. ");
INSERT INTO sri_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, wãtĩ waakõãyupʉ. Ĩgʉ̃ waadero pʉrʉ, Marĩpʉre wereboerã Jesúre iritamurã ejañurã. ");
INSERT INTO sri_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juãrẽ peresu iridea kerere pégʉ, Jesús Galilea nikũgue waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Iro ããrĩrĩ́ makã Nazarere tariwãgã, Capernaum wãĩkʉri makãgue ejayupʉ. Galilea wãĩkʉri ditaru tʉro ããrĩbʉ́ Capernaum. Iri makã Zabulón bumarãya nikũ, Neftalí bumarãya nikũ ããrĩunadero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesús irogue ejagʉ, iripoeguemʉ Marĩpʉya kerere weredupuyudi Isaías gojaderosũta iriyupʉ. Ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón bumarãya nikũ, Neftalí bumarãya nikũ ããrĩunadero, judío masaka ããrĩmerãya nikũ ããrã. Ditaru tʉro, dia Jordán wãĩkʉdiya abe ñajãrõgue Galilea wãĩkʉri nikũ ããrã. ");
INSERT INTO sri_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Iro marã, naĩtĩãrõgue ããrĩrã́ irirosũ Marĩpʉyare masĩbema. Ĩgʉ̃sã masĩbiri waja peamegue waabonerã ããrĩ́ma. Irasũ ããrĩkererã, sĩãgorire ĩãrã irirosũ ĩgʉ̃sãrẽ taubure ĩãrãkuma. Ĩgʉ̃ta ĩgʉ̃sãrẽ Marĩpʉre masĩmakʉ̃ irigʉ aarigʉkumi. Irasirirã boyorogue ããrĩrã́ irirosũ ããrĩrãkuma, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesús irogue ããrĩgʉ̃́, masakare ãsũ ãrĩ buenʉgãyupʉ: —Mʉsã ñerĩ iririre bʉjawereka! Mʉsã gũñarĩrẽ gorawayuka! Mérõ dʉyáa, Marĩpʉ ĩgʉ̃yarãrẽ doreri ejaburo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galilea wãĩkʉri ditaru tʉrogue ejagʉ, Simṍrẽ, ĩgʉ̃ pagʉmʉ Andrére bokajayupʉ. Simṍta “Pedro” wãĩkʉyupʉ. Ĩgʉ̃sã waaí wẽjẽrĩmasã ããrĩñurã. Ditarugue ĩgʉ̃sãya buidire meéyorã iriñurã. ");
INSERT INTO sri_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús ĩgʉ̃sãrẽ: —Náka, yʉ merã! Daporare mʉsãrẽ waaí wẽjẽrĩmasã ããrĩrĩ́rẽ piri, Marĩpʉya kerere wererimasã ããrĩmakʉ̃ irigʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, mata ĩgʉ̃sãya buiriyukure píkõã, Jesús merã waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pʉrʉ Jesús yoaweyaro waa, Santiagore, ĩgʉ̃ pagʉmʉ Juãrẽ bokajayupʉ. Ĩgʉ̃sã Zebedeo wãĩkʉgʉ pũrã ããrĩñurã. Ĩgʉ̃sãya doódirugue ĩgʉ̃sã pagʉ merã ĩgʉ̃sãya buiriyukure ãmurã́ iriñurã. Jesús ĩgʉ̃sãrẽ: “Náka, yʉ merã!” ãrĩ siiuyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã: “Jáʉ”, ãrĩ, ĩgʉ̃sãya doódirure, pagʉre píkõã, Jesús merã waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ããrĩperero Galilea nikũrẽ judío masaka nerẽrĩ wiirigue buegorenayupʉ. Õãrĩ kerere, Marĩpʉ ĩgʉ̃yarãrẽ doregʉ ããrĩrĩ́rẽ bueyupʉ. Irasũ ããrĩmakʉ̃ pũrĩrikʉrãrẽ ããrĩpereri ĩgʉ̃sã pũrĩrĩrẽ tauyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ĩgʉ̃ irasiriri kerere ããrĩperero Siria nikũ marã masĩpereakõãñurã. Irasirirã gajerosũperi sĩrĩrĩ oparãrẽ, pũrĩrikʉrãrẽ, wãtẽa ñajãsũnerãrẽ, ñamasĩrĩrĩ oparãrẽ, waamasĩmerãdere Jesús pʉrogue ãĩãñurã. Irasirigʉ ããrĩpererãrẽ tauyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ĩgʉ̃ irasirimakʉ̃ ĩãrã, wárã Galilea nikũ marã, Decápolis wãĩkʉri nikũma makãrĩ marã, Jerusalén marã, Judea nikũ marã, dia Jordán wãĩkʉdiya abe mʉrĩriro gapʉ marã ĩgʉ̃ merã waañurã. ");
INSERT INTO sri_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús, masaka wárã ĩgʉ̃ pʉro ejamakʉ̃ ĩãgʉ̃, buúrugue mʉrĩa, eja doayupʉ. Ĩgʉ̃ irogue doamakʉ̃, ĩgʉ̃ buerã ĩgʉ̃ pʉro nerẽnʉgãjañurã. ");
INSERT INTO sri_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ĩgʉ̃sã nerẽnʉgãjamakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃sãrẽ ãsũ ãrĩ buepʉroriyupʉ: ");
INSERT INTO sri_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—“Marĩpʉ iritamubirimakʉ̃, ĩgʉ̃ gããmerĩrẽ irimasĩña marĩbokoa”, ãrĩ gũñarãno, ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ dorerogue waarãkuma. Iroguema ĩgʉ̃sãya ããrã. Irasirirã ʉsʉyama. ");
INSERT INTO sri_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Bʉjawereri merã ããrĩrã́rẽ Marĩpʉ ĩgʉ̃sãrẽ gũñaturamakʉ̃ irigʉkumi. Irasirirã ʉsʉyama. ");
INSERT INTO sri_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’“Gajerã nemorõ ããrã”, ãrĩ gũñamerã, Marĩpʉ ĩgʉ̃sãrẽ: “I nikũrẽ sĩgʉra”, ãrĩdeare oparãkuma. Irasirirã ʉsʉyama. ");
INSERT INTO sri_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Marĩpʉ gããmerĩrẽ iridʉarã, ʉaboarã baadʉarã, ñemesiburã iirídʉarã irirosũ ããrĩ́ma. Marĩpʉ ĩgʉ̃sãrẽ iritamugʉkumi, ĩgʉ̃ gããmerĩrẽ iriburo, ãrĩgʉ̃. Ĩgʉ̃sãrẽ iritamugʉ̃, iirí, baayapianerã irirosũ ããrĩmakʉ̃ irigʉkumi. Irasirirã ʉsʉyama. ");
INSERT INTO sri_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Gajerãrẽ bopoñarĩ merã ĩãrãrẽ Marĩpʉ ĩgʉ̃sãrẽ bopoñarĩ merã ĩãgʉkumi. Irasirirã ʉsʉyama. ");
INSERT INTO sri_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ñerĩ opamerã Marĩpʉre ĩãrãkuma. Irasirirã ʉsʉyama. ");
INSERT INTO sri_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Gajerãrẽ õãrõ siuñajãrĩ merã ããrĩmakʉ̃ iridʉarãrẽ Marĩpʉ ĩgʉ̃sãrẽ: “Yʉ pũrã ããrĩ́ma”, ãrĩgʉkumi. Irasirirã ʉsʉyama. ");
INSERT INTO sri_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Marĩpʉ gããmerĩrẽ iriri waja, gajerã ĩgʉ̃sãrẽ ñerõ tarimakʉ̃ irisũrã ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ dorerogue waarãkuma. Iroguema ĩgʉ̃sãya ããrã. Irasirirã ʉsʉyama. ");
INSERT INTO sri_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Yʉre mʉsã bʉremurĩ waja gajerã mʉsãrẽ ñerõ wereníkerepʉrʉ, mʉsãrẽ ñerõ irikerepʉrʉ, ããrĩpereri gajerosũperi ñerĩ kere ãrĩkerepʉrʉ, ʉsʉyaka! ");
INSERT INTO sri_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Marĩpʉya kerere weredupuyunerãrẽ mʉsã dupuyuro ããrĩnerãrẽ ãsũta ñerõ irinerã ããrĩmá. Irasirirã mʉsãrẽ ñerõ irikerepʉrʉ, õãrõ ʉsʉyari merã ããrĩrikʉka! Pʉrʉguere wáro õãrĩ oparãkoa ʉ̃mʉgasiguere, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Irasũ ãrĩ odo, Jesús ãsũ ãrĩ buenemoyupʉ: —Mʉsã i ʉ̃mʉguere Marĩpʉyare irirã moã okari irirosũ ããrã. Moã okadea okabirimakʉ̃, dupaturi okamakʉ̃ irimasĩbirikoa. Béokõãkoa. Béoadero pʉrʉ, masaka kʉrawasiribéokõãkuma. Irasirirã mʉsã moã okari irirosũ Marĩpʉyare iriníkõãka! ");
INSERT INTO sri_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Mʉsã i ʉ̃mʉ marãrẽ sĩãgori irirosũ ããrã. Irasirirã Marĩpʉyare mʉsã irimakʉ̃ ĩãrã, ĩgʉ̃rẽ masĩrãkuma. Buúru wekague ããrĩrĩ́ makãrẽ duúmasĩña máa. ");
INSERT INTO sri_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Masaka sĩãgodirure sĩãgorã, dupa kũma dokague píbirikuma. Sĩãgo, wii dekogue siukuma, iri wii marã ããrĩpererã õãrõ boyorogue ããrĩburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","I irirosũ mʉsãde Marĩpʉyare õãrõ iriri merã masakare mʉsã ĩgʉ̃yarã ããrĩrĩ́rẽ masĩmakʉ̃ irika, ĩgʉ̃rẽ ʉ̃mʉgasigue ããrĩgʉ̃́rẽ: “Õãtarigʉ ããrĩ́mi”, ãrĩ bʉremuburo, ãrĩrã! ");
INSERT INTO sri_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Mʉsã yʉre ãsũ ãrĩ gũñabirikõãka: “Marĩpʉ Moisére doreri pídeare, irasũ ããrĩmakʉ̃ Marĩpʉya kerere weredupuyunerã gojadeare béogʉ aarigʉ́ irikumi”, ãrĩ gũñabirikõãka! Irire béogʉ aarigʉ́ meta iribʉ. Iri ããrĩpererire keoro iriyuwarikʉgʉ aarigʉ́ iribʉ. ");
INSERT INTO sri_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Diayeta mʉsãrẽ werea. Ʉ̃mʉgasi, i nikũ ããrĩrṍpãta Marĩpʉ neõ mérõgã su wãĩ ĩgʉ̃ doreri pídeare béobirikumi. Ããrĩpereri ĩgʉ̃: “Ãsũ irigʉra”, ãrĩdeare keoro iriyuwarikʉgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iri dorerire su wãĩrẽ tarinʉgãrãno, gajerãrẽ: “Gʉa irirosũ irika!” ãrĩ buerã, ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ĩgʉ̃ ĩãmakʉ̃ ubu ããrĩrã́ ããrĩrãkuma. Gajerã gapʉ iri dorerire õãrõ irirã, gajerãrẽ ĩgʉ̃sã irirosũ iridorerã, ʉ̃mʉgasigue ĩgʉ̃yarãrẽ dorerogue ĩgʉ̃ ĩãmakʉ̃ oparã irirosũ ããrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ire mʉsãrẽ werea. Mʉsã, Moisés doredeare buerimasã, fariseo bumarã nemorõ Marĩpʉ gããmerĩrẽ iribirikererã, Marĩpʉ ĩgʉ̃yarãrẽ doreroguere neõ waabirikoa. ");
INSERT INTO sri_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Marĩpʉ mʉsã ñekʉ̃sãmarãrẽ doredeare mʉsã pénerã ããrĩbʉ́. Ĩgʉ̃sãrẽ ãsũ ãrĩdi ããrĩmí: “Masakare wẽjẽbirikõãka! Gajigʉre wẽjẽdinorẽ wajamoãka, ĩgʉ̃ wẽjẽdea waja!” ");
INSERT INTO sri_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yʉ gapʉ mʉsãrẽ werea. Sugʉ ĩgʉ̃yagʉ merã guagʉ, wajamoãsũgʉkumi. Ĩgʉ̃yagʉre: “Mʉ wajamáa”, ãrĩ bʉridagʉnorẽ marĩ oparã wajamoãrãkuma. Ĩgʉ̃yagʉre: “Waibʉ irirosũ pémasĩrĩ opabea mʉ”, ãrĩgʉ̃norẽ peamegue waamagoegoráa. ");
INSERT INTO sri_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Irasirirã Marĩpʉya wiima soepeorogue ĩgʉ̃rẽ bʉremurã gajino pírã waamurã: “Yaagʉ yʉ merã guami”, ãrĩ gũñabokarã, ");
INSERT INTO sri_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Marĩpʉre sĩburire píkõã, mʉsãyagʉ pʉrogue waa: “Yʉ mʉrẽ ñerõ irideare kãtika!” ãrĩ sẽrẽka ĩgʉ̃rẽ! Mʉsã gãme ãmuadero pʉrʉ, dupaturi Marĩpʉya wiigue mʉsã sĩdʉadeare ĩgʉ̃rẽ sĩrã waaka! ");
INSERT INTO sri_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Sugʉ mʉsãrẽ weresãdʉagʉ, weresãrĩrẽ beyerimasʉ̃ pʉrogue mʉsãrẽ ãĩdʉamakʉ̃, mata maague ĩgʉ̃ merã waarã́, ĩgʉ̃ mʉsãrẽ weresãrĩrẽ ãmuka! Ĩgʉ̃ merã õãrõ ãmubirimakʉ̃, beyerimasʉ̃guere mʉsãrẽ weresãgʉkumi. Ĩgʉ̃ mʉsãrẽ weresãmakʉ̃ pégʉ, beyerimasʉ̃ mʉsãrẽ suraraguere wia, peresu iridoregʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Diayeta mʉsãrẽ werea. Beyerimasʉ̃ mʉsãrẽ wajaridoredeare wajaripeobirimakʉ̃, neõ mʉsãrẽ wiubirikumi. ");
INSERT INTO sri_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Iripoegue marã weredeare mʉsã pénerã ããrĩbʉ́. Ãsũ ãrĩnerã ããrĩmá: “Gajigʉ marãpo merã ñerõ iribirikõãka!” ");
INSERT INTO sri_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yʉ gapʉ mʉsãrẽ werea. Sugʉ nomeõrẽ ñerõ iridʉari merã ĩãgʉ̃, ĩgʉ̃ gũñarĩgue igo merã ñerõ irisiami. ");
INSERT INTO sri_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Irasirirã mʉsãya koyeru diaye gapʉmarũ merã ĩã, ñerõ irirã, irirure goreweabéorosũ iri ñerõ iririre pirika! Mʉsã koyerure béomakʉ̃, iriru dita dediria. Ñerõ iririre pirimerã ããrĩpereri mʉsãya dupʉ merã peamegue béosũrãkoa. ");
INSERT INTO sri_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mʉsãya diayema mojõ merã ñerõ irirã, iri mojõrẽ dititá béorosũ iri ñerõ iririre pirika! Mʉsãya mojõrẽ béomakʉ̃, iri mojõ dita dediria. Ñerõ iririre pirimerã ããrĩpereri mʉsãya dupʉ merã peamegue béosũrãkoa. ");
INSERT INTO sri_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Iripoegue marã idere ãrĩnerã ããrĩ́ma: “Sugʉ ĩgʉ̃ marãpore béodʉagʉ: ‘I waja merã mʉrẽ béoa’, ãrĩ gojari pũrẽ sĩrõ gããmea”, ãrĩnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yʉ gapʉ mʉsãrẽ werea. Sugʉ, ĩgʉ̃ marãpo gajigʉ merã ñerõ iribirikerepʉrʉ igore béogʉ, igore gajigʉ merã marãpʉkʉmakʉ̃ irigʉ, igore ñerõ irimakʉ̃ irikumi. Irasũ ããrĩmakʉ̃, ĩgʉ̃ béodeo merã marãpokʉgʉde ñerõ irigʉ irikumi. ");
INSERT INTO sri_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Iripoegue marãrẽ weredeare mʉsã pénerã ããrĩbʉ́. Ãsũ ãrĩ werenerã ããrĩmá ĩgʉ̃sãrẽ: “‘Marĩpʉ wãĩ merã ãsũ irigʉra’, ãrĩderosũta marĩ Opʉ ĩũrõ keoro irika!” ");
INSERT INTO sri_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yʉ gapʉ mʉsãrẽ werea. Mʉsã gajerãrẽ: “Ãsũ irigʉra”, ãrĩrã, Marĩpʉre wãĩpeobirikõãka! “Ʉ̃mʉgasima merã ãsũ irigʉra”, ãrĩbirikõãka! Ʉ̃mʉgasi, Marĩpʉ doaro ubu ããrĩrṍ meta ããrã. ");
INSERT INTO sri_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","I nikũma merãdere wãĩpeobirikõãka! I nikũ Marĩpʉya nikũ ããrã. Irasirio ĩgʉ̃ kʉraña doanírõ irirosũ ããrã. Jerusalén merãdere wãĩpeobirikõãka! Jerusalén marĩ Opʉ turatarigʉya makã ããrã. ");
INSERT INTO sri_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Yaa dipuru merã ãsũ irigʉra”, ãrĩ wãĩpeobirikõãka! Mʉsã irasũ ãrĩrĩ merã neõ mʉsãya dipuruma poarire ñírĩda, o borerida waamakʉ̃ irimasĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Ãsũ irigʉra”, o “Ãsũ iribirikoa”, ãrĩrã, wãĩpeoro marĩrõ su diayeta wereka! Wãĩpeori merã: “Ãsũ irigʉra”, ãrĩrã, wãtĩ gããmerĩrẽ irirã yáa. ");
INSERT INTO sri_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Iripoegue marã weredeare mʉsã pénerã ããrĩbʉ́. Ãsũ ãrĩnerã ããrĩmá: “Mʉrẽ gajigʉ mʉya koyerure pátĩãderosũta mʉde ĩgʉ̃ya koyerure pátĩã gãmika! Mʉya guikarure ĩgʉ̃ pánuaderosũta mʉde ĩgʉ̃ya guikarure pánua gãmika!” ãrĩnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yʉ gapʉ mʉsãrẽ werea. Mʉsãrẽ ñerõ iridire irasũ ĩãkõãka! Ĩgʉ̃rẽ ñerõ iri gãmibirikõãka! Sugʉ mʉsãya wayupãrã diaye gapʉre pámakʉ̃, kúgapʉma wayupãrãdere pádoreka! ");
INSERT INTO sri_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sugʉ mʉrẽ weresãrĩrẽ beyerimasʉ̃ pʉro ãĩa: “Ĩgʉ̃ya surírore sĩdoreka, ĩgʉ̃ yʉre ñerõ iridea waja”, ãrĩ weresãmakʉ̃, iriñerẽ sĩka! Irasũ ããrĩmakʉ̃, mʉya wekamañedere sĩnemoka ĩgʉ̃rẽ! ");
INSERT INTO sri_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sugʉ surara gajinorẽ su kilómetro mʉrẽ ãĩwãgãdoremakʉ̃, gaji kilómetro ãĩwãgãnemobosaka doja! ");
INSERT INTO sri_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sugʉ mʉrẽ gajinorẽ sẽrẽmakʉ̃, sĩka ĩgʉ̃rẽ! Gajino mʉrẽ wayumakʉ̃ sĩka ĩgʉ̃rẽ! “Wayubirikoa”, ãrĩbirikõãka! ");
INSERT INTO sri_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Gaji iripoegue marã weredeare mʉsã pénerã ããrĩbʉ́. Ãsũ ãrĩnerã ããrĩmá: “Mʉsã merãmarãrẽ maĩka! Mʉsãrẽ ĩãturirã gapʉre ĩãturi doo, gãmika!” ãrĩnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yʉ gapʉ mʉsãrẽ werea. Mʉsãrẽ ĩãturirãrẽ maĩka! Mʉsãrẽ ñerõ werenírãrẽ: “Õãrõ ããrĩburo”, ãrĩka! Mʉsãrẽ ĩãturi doorãrẽ õãrõ irika! Mʉsãrẽ ñerõ ãrĩ bʉridamakʉ̃, mʉsãrẽ ñerõ irimakʉ̃, ĩgʉ̃sãya ããrĩburire Marĩpʉre sẽrẽbosaka! ");
INSERT INTO sri_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Irasirirã Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ pũrã ããrĩrãkoa. Marĩpʉ ñerãrẽ, õãrãdere abe asimakʉ̃ yámi. Ĩgʉ̃ dorerire irirã pʉro, irimerã pʉrodere deko merẽmakʉ̃ yámi. Irasirirã mʉsãde ĩgʉ̃ irirosũta masakare sʉrosũ õãrõ irika! ");
INSERT INTO sri_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉsãrẽ maĩrã direta maĩrã, ¿ñeénorẽ ʉ̃mʉgasigue wajatabokuri? Romano marã opʉre niyeru wajaseabosarimasãde ñerã ããrĩkererã, ĩgʉ̃sãrẽ maĩrãrẽ maĩma. ");
INSERT INTO sri_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉsãyarã direta õãrõ bokatĩrĩñeãrã, ¿ñeéno õãrĩrẽ gajerã nemorõ iribokuri? Marĩpʉre masĩmerãde ĩgʉ̃sãyarãrẽ õãrõ bokatĩrĩñeãma. ");
INSERT INTO sri_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Irasirirã, Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ neõ ñerĩ marĩgʉ̃ ããrĩrṍsũta mʉsãde neõ ñerĩ marĩrã ããrĩka! ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesús ãsũ ãrĩ werenemoyupʉ: —“Õãrĩrẽ irirã ããrã”, ãrĩrã, masaka ĩũrõ mʉsã iririre iri ĩmubirikõãka! Mʉsã irire irasirimakʉ̃, Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ mʉsã irasiridea wajare sĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Irasirirã boporãrẽ iritamurã, ããrĩpererãrẽ werebirikõãka! Irigatorimasã irirosũ iribirikõãka! Ĩgʉ̃sã boporãrẽ iritamurã, marĩ nerẽrĩ wiirigue nerẽanerã, makã dekogue ããrĩrã́ ĩũrõ: “Õãrã ããrĩ́ma”, ãrĩburo, ãrĩrã, iri ĩmuma. Diayeta mʉsãrẽ werea. Masaka ĩgʉ̃sãrẽ õãrõ ãrĩrĩ merã wajatari opasiama. ");
INSERT INTO sri_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mʉsã gapʉ boporãrẽ gajino sĩrã, masaka ĩãberogue sĩka! ");
INSERT INTO sri_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Marĩpʉ, mʉsã irasirimakʉ̃ ĩãgʉ̃, mʉsãrẽ õãrõ wajatamakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Marĩpʉre sẽrẽrã, irigatorimasã irirosũ iribirikõãka! Ĩgʉ̃sã marĩ nerẽrĩ wiirigue, makã dekogue masaka ĩãburo, ãrĩrã, sẽrẽ ĩmuma. Diayeta mʉsãrẽ werea. Masaka ĩgʉ̃sãrẽ ĩãrĩ merã wajatari opasiama. ");
INSERT INTO sri_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉsã gapʉ Marĩpʉre sẽrẽrã, mʉsãya taribugue ñajãa, disipʉro bia, gajerã ĩãberogue ĩgʉ̃rẽ sẽrẽka! Ĩgʉ̃ deyomarĩgʉ̃ ããrĩkeregʉ, mʉsã merã ããrĩgʉkumi. Irasirigʉ, gajerã ĩãberogue mʉsã ĩgʉ̃rẽ sẽrẽmakʉ̃ ĩãgʉ̃, mʉsãrẽ õãrõ wajatamakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Marĩpʉre sẽrẽrã, ubu ããrĩrĩ́ werenírĩ merã dupaturi sẽrẽdujabirikõãka! Marĩpʉre masĩmerã irasũ yáma. “Wári werenírĩ merã gʉa sẽrẽmakʉ̃, gʉare pégʉkumi”, ãrĩ gũñama. ");
INSERT INTO sri_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ĩgʉ̃sã irirosũ iribirikõãka! Mʉsã sẽrẽburo dupuyuro Marĩpʉ mʉsã gããmerĩrẽ masĩsiami. ");
INSERT INTO sri_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Irasirirã ãsũ ãrĩ sẽrẽrõ gããmea Marĩpʉre: Gʉapʉ ʉ̃mʉgasigue ããrĩgʉ̃́, ããrĩpererã mʉrẽ goepeyari merã bʉremuburo. ");
INSERT INTO sri_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mʉ ããrĩpererãrẽ doreri aariburo. Ʉ̃mʉgasigue marã mʉ gããmerõ irirosũta i nikũ marãde iriburo. ");
INSERT INTO sri_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ʉ̃mʉrikʉ gʉare baari sĩka! ");
INSERT INTO sri_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gajerã gʉare ñerõ irideare gʉa kãtirosũta mʉde gʉa ñerõ irideare kãtika! ");
INSERT INTO sri_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gʉa ñerõ iridʉamakʉ̃ kãmutaka! Ñegʉ̃ gʉare ñerĩ ãrĩmesãrĩrẽ tau kãmutaka! Mʉ sugʉta gʉare doregʉ, turatarigʉ, gʉa bʉremugʉ̃ ããrĩnígʉkoa, ãrĩ sẽrẽka Marĩpʉre! ");
INSERT INTO sri_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Gajerã mʉsãrẽ ñerõ irideare mʉsã kãtimakʉ̃ ĩãgʉ̃, Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ mʉsã ñerõ irideare kãtigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gajerã mʉsãrẽ ñerõ irideare mʉsã kãtibirimakʉ̃, Marĩpʉ mʉsã ñerõ irideare kãtibirikumi. ");
INSERT INTO sri_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Marĩpʉre bʉremurã bererã, irigatorimasã irirosũ iribirikõãka! Ĩgʉ̃sã bererã, ĩgʉ̃sãya diapure bʉjawererã irirosũ iri ĩmuma, masaka ĩgʉ̃sã bererire ĩãmasĩburo, ãrĩrã. Diayeta mʉsãrẽ werea. Masaka ĩgʉ̃sãrẽ ĩãrĩ merã wajatari opasiama. ");
INSERT INTO sri_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mʉsã gapʉ bererã, mʉsã irinarõsũta irika! Mʉsãya diapure waakoe, õãrõ wʉʉapukõãka! ");
INSERT INTO sri_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mʉsã irasirimakʉ̃, gajerã mʉsã bererire masĩbirikuma. Marĩpʉ gapʉ deyomarĩgʉ̃ ããrĩkeregʉ, mʉsã merã ããrĩ́mi. Ĩgʉ̃ dita mʉsã gajerã ĩãberogue iririre ĩãgʉ̃, mʉsãrẽ õãrõ wajatamakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Wári i nikũmarẽ sea neeõ duripíbirikõãka! I nikũma borewiji boakõãrokoa. Boabirimakʉ̃, burua baadediukõãrãkuma. Baadediubirimakʉ̃, yajarimasã ñajãa, yajakõãrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Irasirirã mʉsã ʉ̃mʉgasima opaburi gapʉre gũñaka! Ʉ̃mʉgasima neõ borewiji boabirikoa. Iroguere burua mʉsã opaburire neõ baadediubirikuma. Yajarimasãde neõ ñajãa, yajabirikuma. ");
INSERT INTO sri_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mʉsã i ʉ̃mʉma direta: “Opadʉakoa”, ãrĩ gũñarã, irire bʉro maĩrãkoa. Ʉ̃mʉgasima gapʉre: “Opadʉakoa”, ãrĩ gũñarã, irire bʉro maĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Mʉsãya koye mʉsãya gũñarĩguere sĩãgodiru irirosũ ããrã. Mʉsã õãrĩ koye oparã irirosũ ããrĩmakʉ̃, mʉsãya gũñarĩguere õãrõ sĩãgoro irirosũ ããrã. Irasirirã Marĩpʉyare masĩa. ");
INSERT INTO sri_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mʉsã ñerĩ koye oparã irirosũ ããrĩmakʉ̃, mʉsãya gũñarĩguere naĩtĩãrõ irirosũ ããrã. Marĩpʉyare masĩbea. I naĩtĩãrĩ, ñetaria. Irire masĩbirimakʉ̃ ñegoráa. ");
INSERT INTO sri_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Neõ sugʉ moãboerimasʉ̃ pẽrã oparãrẽ moãboemasĩbirikumi. Sugʉ opʉre maĩgʉ̃, gajigʉ gapʉre maĩbirikumi, o sugʉ opʉre bʉremugʉ̃, gajigʉ gapʉre yʉjʉbirikumi. Niyerudere maĩtarigʉ, Marĩpʉ gapʉre maĩbemi. ");
INSERT INTO sri_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Irasirigʉ mʉsãrẽ ire weregʉra. Mʉsã ããrĩrikʉrire gũñarã, “¿Ñeénorẽ baarãkuri, ñeénorẽ iirírãkuri, ñeénorẽ sãñarãkuri?” ãrĩ gũñarikʉbirikõãka! Marĩ okari gapʉ, baari nemorõ wajakʉa. Marĩya dupʉ, surí nemorõ wajakʉa. ");
INSERT INTO sri_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mirãrẽ ʉ̃marõgue wʉ́rãrẽ ĩãka! Ĩgʉ̃sã baadʉarã, otebema. Otedea dʉkare seabema. Baari duripíri wiiridere opabema. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ gapʉ ĩgʉ̃sãrẽ baari sĩmi. Mʉsã gapʉ, mirã nemorõ wajakʉtarinʉgãa. ");
INSERT INTO sri_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mʉsã bʉro gũñarikʉri merã neõ mérõgã masãnemobirikoa. Mʉsã irasũ gũñarikʉri wajamáa. ");
INSERT INTO sri_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Irire masĩkererã, ¿nasirirã mʉsã surí sãñaburire gũñarikʉri? Makãnʉ́ʉma goori masãrĩrẽ gũñaka! Iri moãbirikerero, suabirikerero õãrĩ surí sãñarõ irirosũ deyoa. ");
INSERT INTO sri_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mʉsãrẽ werea. Opʉ Salomón surí õãrĩ sãñadero nemorõ iri goori gapʉ õãrĩ deyoa. ");
INSERT INTO sri_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iri goorire Marĩpʉ õãrĩ goori deyomakʉ̃ irikerepʉrʉ, mérõgã pʉrʉ ñaĩdija pereakõãa. Gajinʉ gapʉ peamegue soebéokõãsũa. Iri mata pereburi ããrĩkerepʉrʉ, Marĩpʉ iri goorire õãrĩ deyomakʉ̃ yámi. Iri goorire õãrĩ ããrĩmakʉ̃ irirosũ nemorõ mʉsãrẽ õãrõ irigʉkumi. Suríre sĩgʉkumi. Mʉsã gapʉ ĩgʉ̃rẽ mérõgã bʉremurĩ opáa. ");
INSERT INTO sri_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Irasirirã: “¿Ñeénorẽ baarãkuri, ñeénorẽ iirírãkuri, ñeénorẽ sãñarãkuri?” ãrĩ gũñarikʉbirikõãka! ");
INSERT INTO sri_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Marĩpʉre masĩmerã bʉro gũñarikʉri merã irire ãmaníkõãma. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ gapʉ ããrĩpereri mʉsã gããmerĩrẽ masĩsiami. Irire mʉsãrẽ sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Irasirirã, Marĩpʉ mʉsã Opʉ ããrĩrĩ́rẽ, ĩgʉ̃ gããmerĩrẽ, ĩgʉ̃ dorerire, ããrĩpereri nemorõ gããmepʉrorika! Mʉsã irasirimakʉ̃, ããrĩpereri mʉsã baa, iiríburire, mʉsã surí sãñaburidere sĩwekapeogʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Irasirirã: “¿Naásũ waarokuri ñamigãrẽ?” ãrĩ gũñarikʉbirikõãka! Gajinʉmarẽ mʉsã ñerõ tariburire gũñarikʉdupuyubirikõãka! Dapagãma direta gũñaka! Dapagãrẽ mʉsã ñerõ tariburi ããrĩsiáa, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesús irire ãrĩ odo, ãrĩnemoyupʉ doja: —Gajerãrẽ: “Ñerã ããrĩ́ma”, ãrĩ werewʉabirikõãka! Mʉsã werewʉabirimakʉ̃ ĩãgʉ̃, Marĩpʉ mʉsãrẽ: “Ñerã ããrĩ́ma”, ãrĩ ĩãbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gajerãrẽ: “Õãrõ iribema”, ãrĩ ĩãrõsũta Marĩpʉ mʉsãrẽ ĩãgʉkumi. Gajerãrẽ: “Ãsũ ããrĩ́ma”, ãrĩ ĩãrõsũta Marĩpʉ mʉsãrẽ ĩãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mʉsã ñerõ iridea, koyerugue wári turu oparosũ ñetariri ããrĩrĩ́rẽ gũñabirikererã, mʉsãyagʉ ñerõ iridea, koyerugue nikũyegã oparosũ ããrĩrĩ́rẽ: “Ñegoráa”, ãrĩ gũñáa. ");
INSERT INTO sri_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Irasirirã mʉsã ñerõ iridea, koyerugue wári turu oparosũ ããrĩrã́, mʉsãyagʉre ĩgʉ̃ya koyerugue ããrĩrĩ́ nikũyegãrẽ: “¿Ãĩbéosi?” ãrĩmasĩbea. ");
INSERT INTO sri_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mʉsã ñerõ iririkʉrã, irigatorikʉrã ããrã. Mʉsãya koyerugue ããrĩrĩ́ turu gapʉre ãĩbéopʉroriro irirosũ mʉsã ñerõ iririre piripʉrorika! Irasiri odo, mʉsãyagʉre: “Mʉ ñerõ iririre pirikõãka!” ãrĩ masĩa. ");
INSERT INTO sri_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Marĩpʉre ñerõ ãrĩ bʉridarãrẽ ĩgʉ̃ya kerere werebirikõãka! Ĩgʉ̃sãrẽ wererã, diayéare õãrĩrẽ sĩrã, o yeseare ñaguĩda wajaparidare sĩrã irirosũ iribokoa. Diayéa guarã, õãrĩ sĩkerepʉrʉ, gãmenʉgã kũrĩkõãkuma. Yesea iridare noó gããmerõ kʉrawasiribéokuma. Ĩgʉ̃sã irirosũ ããrĩrã́rẽ, ubugorata Marĩpʉya kerere werebirikõãka! ");
INSERT INTO sri_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Marĩpʉre sẽrẽka! Ĩgʉ̃rẽ sẽrẽmakʉ̃, sĩgʉkumi. Õãrĩrẽ ãmarã́, bokarãkoa. Wiigue ñajãdʉarã oemakʉ̃, Marĩpʉ disipʉro tũpã ñajãdoregʉ irirosũ mʉsã sẽrẽrĩrẽ pégʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ĩgʉ̃rẽ sẽrẽrãnorẽ sĩgʉkumi. Ãmarã́no, bokarãkuma. Wiigue ñajãdʉarã oerã irirosũ ĩgʉ̃rẽ sẽrẽmakʉ̃ ĩãgʉ̃, ĩgʉ̃sãrẽ ñajãdoregʉ irirosũ ĩgʉ̃sã sẽrẽrĩrẽ õãrõ pégʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Mʉsã pũrã pã́rẽ sẽrẽmakʉ̃, ʉ̃tãyere sĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Waaí sẽrẽmakʉ̃dere, ãñarẽ sĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ñerã ããrĩkererã, mʉsã pũrãrẽ õãrĩrẽ sĩmasĩa. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ gapʉ, mʉsã nemorõ õãrĩrẽ sĩmasĩmi. Irasirigʉ ĩgʉ̃rẽ sẽrẽrãrẽ irire sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Mʉsã, gajerã mʉsãrẽ õãrõ irimakʉ̃ gããmerõsũta mʉsãde ĩgʉ̃sãrẽ õãrõ irika! Moisés gojadea pũgue, Marĩpʉya kerere weredupuyunerã gojadea pũguedere irasũta iridoredero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Marĩpʉ pʉrogue ñajãdʉarã ĩgʉ̃yare irika! Irogue ñajãmakʉ̃ diasagoráa. Eyabiri disipʉro ñajãrõ irirosũ ããrã. Peamegue waaró gapʉ eyari disipʉro ñajãrõ, eyari maarẽ́ waaró irirosũ ããrã. Iri maarẽ́ waamakʉ̃ diasabea. Irasirirã wárã masaka irogue waarã́ yáma. ");
INSERT INTO sri_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Marĩpʉ pʉro gapʉre waamakʉ̃ diasagoráa. Irasirirã mérãgãta masaka, eyabiri disipʉro ñajãrõrẽ, irogue eyabiri maarẽ́ bokama. Irogue waarã́, Marĩpʉ merã õãrõ ããrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Õãrõ pémasĩka! “Marĩpʉya kerere weredupuyurimasã ããrã”, ãrĩgatorãrẽ pébirikõãka! Ĩgʉ̃sã oveja guamerã, õãrĩrẽ irirã irirosũ mʉsã pʉrogue ejarãkuma. Irasirikererã, ĩgʉ̃sã gũñarĩguere diayéa makãnʉ́ʉ marã guarã irirosũ, ñerã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ĩgʉ̃sã ñerõ irimakʉ̃ mʉsã ĩgʉ̃sãrẽ: “Ñerã ããrĩ́ma”, ãrĩ ĩãmasĩrãkoa. Poragʉ iguire dʉkakʉbirikoa. Ñaagʉ̃de higo wãĩkʉrire dʉkakʉbirikoa. ");
INSERT INTO sri_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Õãdi yukʉ õãrĩrẽ dʉkakʉa. Ñedi gapʉ ñerĩrẽ dʉkakʉa. ");
INSERT INTO sri_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yukʉ õãdi ñerĩrẽ dʉkakʉbirikoa. Ñedide õãrĩrẽ dʉkakʉbirikoa. ");
INSERT INTO sri_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Õãrĩ dʉkakʉbiridire pábéo, peamegue soekõãma. ");
INSERT INTO sri_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Irasirirã: “Marĩpʉya kerere weredupuyurimasã ããrã”, ãrĩgatorãrẽ ĩgʉ̃sã iriri merã: “Ãrĩgatorikʉrã ããrĩ́ma”, ãrĩ ĩãmasĩrãkoa mʉsã. ");
INSERT INTO sri_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Wárã yʉre: “Mʉta ããrã gʉa Opʉ”, ãrĩkererã, ããrĩpererã ʉ̃mʉgasigue Yʉpʉ ĩgʉ̃yarãrẽ dorerogue ñajãbirikuma. Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ gããmerĩrẽ irirã dita ĩgʉ̃ ããrĩrṍguere ñajãrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yʉpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, wárã yʉre: “Gʉa Opʉ, mʉyare masakare buebʉ. Mʉ wãĩ merã wãtẽãrẽ béowiu, wári õãrĩrẽ iri ĩmubʉ”, ãrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ĩgʉ̃sã irasũ ãrĩkerepʉrʉ: “Mʉsãrẽ neõ masĩbiribʉ. Ñerĩrẽ irirã ããrã mʉsã. Irasirirã yʉ pʉrore wirika!” ãrĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Yʉ werenírĩrẽ péduripígʉno, yʉ dorerire irigʉno, õãrõ pémasĩgʉ̃ ããrĩ́mi. Sugʉ ʉ̃tãyegue ʉ̃kʉ̃ãrĩ goberi máñajãa, wii õãrõ núdi irirosũ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pʉrʉ deko merẽ, dia wáro yura, mirũ bʉro wẽjẽpukerepʉrʉ, iri wii ʉ̃kʉ̃ãrõ núdea wii ããrĩsĩã, neõ mirũabirikoa. ");
INSERT INTO sri_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yʉ werenírĩrẽ pékeregʉ, yʉ dorerire iribi gapʉ sugʉ ĩmiparogue wii iridi irirosũ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pʉrʉ deko merẽ, dia wáro yura, mirũ bʉro wẽjẽpumakʉ̃, mata õjẽdija, kõmopereakõãkoa, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ĩgʉ̃ bue odomakʉ̃, masaka ĩgʉ̃ buerire pégʉkari merã: “Õãtariro buemi”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Moisés gojadeare buerimasã irirosũ buebiriyupʉ. Sugʉ doregʉ irirosũ bueyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús buúrugue ããrãdi dijarimakʉ̃ ĩãrã, wárã masaka ĩgʉ̃rẽ tʉyañurã. ");
INSERT INTO sri_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sugʉ kãmi boagʉ Jesúre ĩãgʉ̃, ĩgʉ̃ pʉro ñadʉkʉpuri merã ejamejã, ĩgʉ̃rẽ sẽrẽyupʉ: —Yʉ Opʉ, mʉ yʉ pũrĩrikʉrire taudʉagʉ taumasĩa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃ya mojõ merã ĩgʉ̃rẽ moãñayupʉ. —Mʉrẽ taugʉra. Kãmi marĩgʉ̃ dujaka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, kãmi yariakõãyuro. ");
INSERT INTO sri_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Irasirigʉ Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Gajerã masakare mʉ tariadeare werebirikõãka! Paí pʉrogue mʉrẽ kãmi yariadeare ĩgʉ̃rẽ ĩmugʉ̃ waaka, ĩgʉ̃ mʉrẽ: “Kãmi marĩgʉ̃ ããrĩ́mi”, ãrĩburo, ãrĩgʉ̃. Ĩgʉ̃ irasũ ãrãdero pʉrʉ, Moisés gojadea pũgue sĩdoredeare sĩka! Mʉ irire irimakʉ̃ ĩãrã, masaka mʉrẽ kãmi yariadeare masĩrãkuma, ãrĩyupʉ Jesús ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pʉrʉ Jesús Capernaugue ejamakʉ̃, romano marã surara opʉ ĩgʉ̃ pʉro ejanʉgã, ĩgʉ̃rẽ iritamurĩ sẽrẽyupʉ: ");
INSERT INTO sri_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Gʉa Opʉ, yʉre moãboegʉ bʉro pũrĩrikʉgʉ yaa wiigue oyami. Bʉari merã bʉro pũrĩsũgʉ̃ iriami, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Ĩgʉ̃rẽ taugʉ waagʉra. ");
INSERT INTO sri_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Surara opʉ ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉ Opʉ, yaa wiire mʉrẽ: “Ñajãrika!” ãrĩ masĩbirikoa. Yʉ ubu ããrĩgʉ̃́ ããrã. Irasirigʉ mʉ õõgueta doreri merã yʉre moãboegʉ tarigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gajerã oparã yʉre dorema. Yʉde gajerã surarare dorea. Yʉ sugʉre: “Waaka!” ãrĩmakʉ̃, waami. Gajigʉre: “Aarika!” ãrĩmakʉ̃, aarími. Yʉ, yʉre moãboegʉre: “Ire irika!” ãrĩmakʉ̃, irire yámi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús surara opʉ irasũ ãrĩrĩrẽ pégʉ, pégʉkakõãyupʉ. Ĩgʉ̃rẽ tʉyarãrẽ ãsũ ãrĩyupʉ: —Diayeta mʉsãrẽ werea. Ĩĩ surara opʉ Israel bumʉ ããrĩbirikeregʉ, yʉre bʉremumi. Ĩĩ irirosũ yʉre bʉremugʉ̃ neõ sugʉ Israel bumʉrẽ bokajabiribʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mʉsãrẽ werea. Wárã masaka ĩĩ irirosũ yʉre bʉremurãkuma. Ĩgʉ̃sã ããrĩperero marã judío masaka ããrĩmerã ããrĩkererã, ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ dorerogue eja, marĩ ñekʉ̃sãmarã Abraham, Isaac, Jacob merã doa, baarãkuma. ");
INSERT INTO sri_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gajerã judío masaka: “Gʉa Opʉ ããrĩrṍgue waamurã ããrã”, ãrĩkerepʉrʉ, ĩgʉ̃sã bʉremubiri waja Marĩpʉ ĩgʉ̃sãrẽ naĩtĩãrõgue béodediugʉkumi. Iroguere pũrĩsũrã bʉro ore, bʉjawereri merã ĩgʉ̃sãya guikare kũrĩduútúrãkuma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Irasũ ãrĩ odo, surara opʉre ãrĩyupʉ: —Dujáaka mʉya wiigue! Mʉ bʉremurõsũta waarokoa mʉrẽ moãboegʉre, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩripoeta, ĩgʉ̃rẽ moãboegʉre pũrĩrĩ tariakõãyuro. ");
INSERT INTO sri_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pʉrʉ Jesús Pedroya wiigue waayupʉ. Iri wiigue ñajãgʉ̃, Pedro mʉ́ñekõrẽ peyarogue bʉro nimakʉrikʉgo oyagore bokajayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Irasirigʉ igoya mojõrẽ moãñayupʉ. Ĩgʉ̃ moãñamakʉ̃ta, nimakʉri tariakõãyuro. Iri tarimakʉ̃ wãgãnʉgã, ĩgʉ̃sãrẽ baari ejoyupo. ");
INSERT INTO sri_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naĩmejãripoe ããrĩmakʉ̃, masaka wárã wãtẽa ñajãsũnerãrẽ Jesús pʉrogue ãĩjañurã. Ĩgʉ̃ werenírĩ merã wãtẽa ĩgʉ̃sãguere ñajãnerãrẽ béowiuyupʉ. Irasũ ããrĩmakʉ̃, ããrĩpererã pũrĩrikʉrãrẽ tauyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Irire irigʉ, iripoeguemʉ Marĩpʉya kerere weredupuyudi Isaías gojaderosũta iriyupʉ. Ãsũ ãrĩ gojadi ããrĩmí: “Marĩ turabirire, marĩ sĩrĩrĩrẽ marĩrẽ taubosami”, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús wárã masaka ĩgʉ̃ pʉro nerẽmakʉ̃ ĩãgʉ̃, ĩgʉ̃ buerãrẽ: —Náka, ditaru sikoepʉgue taribujarã! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃, sugʉ Moisés gojadeare buerimasʉ̃ Jesús pʉro eja, ãrĩyupʉ: —Buegʉ, mʉ noó waaró mʉrẽ tʉyagʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Makãnʉ́ʉ marã diayéa ĩgʉ̃sã kãrĩrĩ toreri opama. Mirãde ĩgʉ̃sã kãrĩrõ opama. Yʉ ããrĩpererã tĩ́gʉ̃ gapʉ kãrĩrõ opabea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Gajigʉ ĩgʉ̃ buerire tʉyagʉ ĩgʉ̃rẽ ãrĩyupʉ: —Yʉ Opʉ, yʉpʉ boamakʉ̃ ĩgʉ̃rẽ yáa odo, mʉrẽ tʉyagʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉre tʉyadʉagʉ, daporata yʉ merã aarika! Yʉre bʉremumerã, boanerã irirosũ ããrĩrã́ta boanerãrẽ yáaburo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Irasũ ãrĩ odo, doódirugue ĩgʉ̃ buerã merã mʉrĩñajãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ĩgʉ̃sã mʉrĩñajãa, taribujaripoe ditarure mirũ bʉro waayuro. Makũrĩ doódirure páñajãmiũkõãdiyuro. Irasũ waaripoere Jesús gapʉ kãrĩgʉ̃ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Irasirirã ĩgʉ̃rẽ yobeñurã: —Gʉa Opʉ, gʉare tauka! Marĩ mirĩmurã yáa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús yʉjʉyupʉ: —¿Nasirirã bʉro güiri mʉsã? Yʉre mérõgã bʉremurĩ opáa mʉsã, ãrĩyupʉ. Irasũ ãrĩgʉ̃ta wãgãnʉgã: “Mirũ, makũrĩ iropãta, toeaka!” ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, mirũ, makũrĩde toedijapereakõãyuro. ");
INSERT INTO sri_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ĩgʉ̃ irasirimakʉ̃ ĩãgʉka, ãsũ ãrĩ gãme wereníñurã: —¿Ñeémʉno masakʉ ããrĩ́rĩ ĩĩ? Mirũ, makũrĩde ĩgʉ̃rẽ tarinʉgãbea, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pʉrʉ Jesús ditarure taribuja, Gadara marãya nikũgue ejayupʉ. Irogue ejamakʉ̃, pẽrã ʉ̃ma masãgoberi watopegue ããrãnerã ĩgʉ̃rẽ bokatĩrĩñurã. Ĩgʉ̃sã wãtẽa ñajãsũnerã goerã ããrĩñurã. Irasirirã iro waarí maarẽ́ masaka neõ waabiriñurã. ");
INSERT INTO sri_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ĩgʉ̃rẽ bokatĩrĩ, ãsũ ãrĩ gainíñurã: —Jesús, ʉ̃mʉgasigue marã Opʉ magʉ̃, ¿nasirigʉ aarigʉ́ yári mʉ gʉa pʉroguere? ¿Ĩgʉ̃ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejabirikerepʉrʉ, gʉare poyarikʉmakʉ̃ irigʉ aaríri mʉ? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ĩgʉ̃sã koregue wárã yesea ãma baarã iriñurã. ");
INSERT INTO sri_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Irasirirã wãtẽa Jesúre ãsũ ãrĩ sẽrẽñurã: —Gʉare béowiugʉ, sĩĩsã yeseaguere ñajãdoreka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Jáʉ, ĩgʉ̃sãrẽta ñajãrã waaka! ãrĩyupʉ Jesús. Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃sã pẽrã ʉ̃maguere ããrãnerã yeseaguere ñajãñurã. Ĩgʉ̃sã ñajãmakʉ̃ta, yesea dupatʉrʉgue ũma mirẽbuáa, ditarugue meébia dijáa, mirĩ boapereakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Irasũ waamakʉ̃ ĩãrã, yeseare korerimasã gʉkari merã makãgue ũmadujáa, ããrĩpereri ĩgʉ̃sã ĩãdeare, irasũ ããrĩmakʉ̃ wãtẽa ñajãsũnerãrẽ waadeare wereñurã. ");
INSERT INTO sri_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Irire pérã, iri makã marã ããrĩpererã Jesús pʉrogue waa, ĩgʉ̃rẽ ĩãrã, turaro merã ĩgʉ̃sãya nikũrẽ wiridoreñurã. ");
INSERT INTO sri_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Irasirigʉ Jesús doódirugue mʉrĩñajãa, ditarure taribuja, ĩgʉ̃ya makãgue ejayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Iroguere sugʉ dupʉ bʉadire ĩgʉ̃ peyaro merã Jesús pʉro ãĩjañurã. Jesús, ĩgʉ̃sã ĩgʉ̃rẽ bʉremumakʉ̃ ĩãgʉ̃, dupʉ bʉadire ãsũ ãrĩyupʉ: —Gũñaturaka! Yʉ, mʉ ñerõ irideare kãtia, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, surãyeri Moisés gojadeare buerimasã ãsũ ãrĩ gũñañurã: “Ĩgʉ̃ werenírĩ merã Marĩpʉre ñerõ wereními”. ");
INSERT INTO sri_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús gapʉ ĩgʉ̃sã gũñarĩrẽ ĩãmasĩ, ãsũ ãrĩyupʉ: —¿Nasirirã yʉre ñerõ gũñarĩ mʉsã? ");
INSERT INTO sri_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Naásũ ãrĩrĩ gapʉ diasaberi ĩĩ bʉadire: “Yʉ, mʉ ñerõ irideare kãtia”, ãrĩrĩ, o “Wãgãnʉgã, waaka!” ãrĩrĩ gapʉ diasaberi? ");
INSERT INTO sri_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yʉ ããrĩpererã tĩ́gʉ̃ i ʉ̃mʉgue ããrĩrã́rẽ ĩgʉ̃sã ñerõ irideare Marĩpʉ dorero merã kãtimasĩa. Irasirigʉ ĩĩ bʉadire taugʉra, mʉsãrẽ irire masĩdoregʉ, ãrĩyupʉ. Irasũ ãrĩ odo, bʉadire ãrĩyupʉ: —Wãgãnʉgã, mʉ oyaderore ãĩ, mʉya wiigue waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, bʉadi ããrãdi wãgãnʉgã, ĩgʉ̃ya wiigue waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Masaka, ĩgʉ̃ irasũ waaríre ĩãrã, ĩãgʉkakõãñurã. Marĩpʉre: “Õãtaria, mʉ turari masakʉre sĩrĩ”, ãrĩ, ʉsʉyari sĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pʉrʉ Jesús iro merã waa, yʉre ĩãbokami. Yʉ Mateo, romano marã opʉre niyeru wajaseabosagʉ ããrĩbʉ́. Jesús, yʉ moãrĩ taribugue doagʉre ĩã, yʉre: “Náka, yʉ merã!” ãrĩmi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, wãgãnʉgã, ĩgʉ̃ merã waakõãbʉ. ");
INSERT INTO sri_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pʉrʉ yaa wiigue Jesús ĩgʉ̃ buerã merã baaripoe wárã niyeru wajaseabosarimasã, gajerã ñerõ irirãde baarã ejama. ");
INSERT INTO sri_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ĩgʉ̃sã merã ĩgʉ̃ baamakʉ̃ ĩãrã, fariseo bumarã gapʉ ĩgʉ̃ buerãrẽ sẽrẽñama: —¿Nasirigʉ mʉsãrẽ buegʉ niyeru wajaseabosarimasã, ñerõ irirã merã baari? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ãrĩmi: —Pũrĩrĩ marĩrã kúririmasʉ̃rẽ ãmabema. Pũrĩrikʉrã gapʉ ĩgʉ̃rẽ ãmama. ");
INSERT INTO sri_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Marĩpʉya werenírĩ gojadea pũgue ĩgʉ̃sã gojadeare buerã waaka! Ãsũ ãrĩ gojasũdero ããrĩbʉ́ iri pũguere: “Yʉre bʉremurã, waimʉrãrẽ wẽjẽ soepeomakʉ̃ gããmebea. Gajerãrẽ mʉsã bopoñarĩ merã ĩãmakʉ̃ gããmea”, ãrĩmi Marĩpʉ, ãrĩ gojasũdero ããrĩbʉ́. “Õãrã ããrã”, ãrĩ gũñarãrẽ siiugʉ aaribiribʉ. “Ñerõ irirã ããrã”, ãrĩ gũñarã direta siiugʉ aarigʉ́ iribʉ, ĩgʉ̃sã ñerõ irideare bʉjawere, gũñarĩrẽ gorawayuburo, ãrĩgʉ̃, ãrĩmi Jesús fariseo bumarãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pʉrʉ Juan masakare wãĩyegʉ buerire tʉyarã Jesúre sẽrẽñarã ejama: —Gʉa Marĩpʉre bʉremurã berea. Irasũ ããrĩmakʉ̃ fariseo bumarãde berema. ¿Nasirirã mʉ buerã gapʉ gʉa irirosũ iriberi? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Sugʉ mojõsiadi bosenʉ irimakʉ̃, ĩgʉ̃ siiuanerã ĩgʉ̃ merã ããrĩrã́ bʉjawerebirikuma. Pʉrʉ ĩgʉ̃rẽ gajerã ãĩãmakʉ̃, bʉjawereri merã bererãkuma. ");
INSERT INTO sri_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Masaka maama suríro gasiro merã bʉgʉñerẽ seretúbirikuma. Irasũ seretúmakʉ̃, maama gasiro ĩgʉ̃sã koeadero pʉrʉ, tʉ̃ãneeõ, bʉgʉñerẽ wári gobe yeguenemomakʉ̃ irikoa. ");
INSERT INTO sri_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Waimʉrã gasiri merã iridea ajuri bʉgʉ ajurigue maama igui dekore diribirikuma. Irasũ dirimakʉ̃, maama igui deko pãmu, bʉgʉ ajuro sẽrãturabiri ooreakõãkoa. Irasiriro igui deko, ajurode kõmokoa. Irasirirã maama igui dekore maama ajurogue diriro gããmea, ãrĩmi Jesús ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús ĩgʉ̃sãrẽ wereripoe judío masaka nerẽrĩ wii opʉ Jesús pʉro eja, ñadʉkʉpuri merã ejamejã, ĩgʉ̃rẽ ãrĩmi: —Yʉ magõ daporata kõmoakõãmo. Igore mʉya mojõ merã ñapeogʉ aarika! Irasirimakʉ̃, dupaturi okagokumo, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, Jesús wãgãnʉgã, ĩgʉ̃ merã waami. Gʉa ĩgʉ̃ buerãde ĩgʉ̃ merã waabʉ. ");
INSERT INTO sri_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Gʉa maague waaripoe sugo nomeõ Jesús pʉrʉpʉ gapʉ eja, ĩgʉ̃ya suríro yuware moãñayupo. Igo pe mojõma pere su gubu peru pẽrẽbejari bojorigora dí wiriri merã pũrĩrikʉgo ããrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ãsũ ãrĩ gũñayupo: “Ĩgʉ̃ya surírore yʉ moãñarĩ merã dita yʉ pũrĩrikʉri tarirokoa”, ãrĩ gũñayupo. ");
INSERT INTO sri_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Igo moãñamakʉ̃ péña, Jesús gãmenʉgã, igore ĩã, ãrĩmi: —Gũñaturaka! Mʉ yʉre bʉremurĩ opáa. Irasirigo mʉ pũrĩrikʉrire tausũa, ãrĩmi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, pũrĩrĩ marĩgõ dujamo. ");
INSERT INTO sri_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pʉrʉ Jesús Jairoya wiigue ejami. Irogue ñajãjagʉ, majĩgõ boadeore yáaburo dupuyuro bayapeorimasãrẽ, gajerã bʉro ore, gainírãrẽ bokaja, ");
INSERT INTO sri_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ĩgʉ̃sãrẽ ãsũ ãrĩmi: —Wiriaka mʉsã! Majĩgõ boabemo. Kãrĩgõ yámo. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ bʉrima. ");
INSERT INTO sri_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús ĩgʉ̃sãrẽ wiriadore, boadeo ããrĩrĩ́ taribugue ñajãa, igoya mojõrẽ ñeãyupʉ. Ĩgʉ̃ ñeãmakʉ̃ta masãbeja, wãgãnʉgãyupo. ");
INSERT INTO sri_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Masaka ããrĩperero iro ããrĩrã́ Jesús iriadea kerere pépereakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús iro ããrãdi wiriamakʉ̃, pẽrã koye ĩãmerã ĩgʉ̃rẽ gainí tʉyama: —David parãmi ããrĩturiagʉ, gʉare bopoñaka! ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús, wiigue ñajãmakʉ̃, koye ĩãmerãde ñajãa, ĩgʉ̃ pʉrogue ejanʉgãma. Irasirigʉ Jesús ĩgʉ̃sãrẽ sẽrẽñami: —¿Yʉ mʉsãrẽ koye ĩãmakʉ̃ irimasĩrĩrẽ bʉremurĩ? ãrĩmi. —Gʉa Opʉ, bʉremua, ãrĩ yʉjʉma. ");
INSERT INTO sri_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃sãya koyere ñapeomi: —Mʉsã bʉremurõsũta mʉsãrẽ ĩãmakʉ̃ irigʉra, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃sã õãrõ ĩãkõãma. Irasirigʉ Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉ mʉsãrẽ taurire gajerãrẽ werebirikõãka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ĩgʉ̃ irasũ ãrĩkerepʉrʉ, ããrĩperero iro marãrẽ Jesús ĩgʉ̃sãrẽ iriadeare werewasiripeokõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Koye ĩãmerã ããrãnerã iri wiire wiriaripoeta, gajerã sugʉ wereníbi wãtĩ ñajãsũdire Jesús pʉro ãĩjama. ");
INSERT INTO sri_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús ĩgʉ̃rẽ ĩã, wãtĩ ĩgʉ̃guere ñajãdire béowiumi. Ĩgʉ̃ wãtĩrẽ béowiumakʉ̃ta, wereníbiradi werenínʉgãmi. Ĩgʉ̃ irasirimakʉ̃ ĩãrã, ããrĩpererã ĩãgʉka: —Marĩ õõ Israel nikũrẽ ãsũ iririnorẽ neõ ĩãbiribʉ, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo bumarã gapʉ Jesúre: —Ĩĩ, wãtẽa opʉ turari merã wãtẽãrẽ béowiumi, ãrĩ werewʉama. ");
INSERT INTO sri_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ããrĩpereri makãrĩrẽ judío masaka nerẽrĩ wiirigue masakare buegorenagʉ̃ waami. Õãrĩ kerere, Marĩpʉ ĩgʉ̃yarãrẽ doregʉ ããrĩrĩ́marẽ buenami. Irasũ ããrĩmakʉ̃, pũrĩrikʉrãrẽ ããrĩpereri gajerosũperi sĩrĩrĩ oparãrẽ taunami. ");
INSERT INTO sri_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Masakare ĩãgʉ̃, bopoñarĩ merã ĩgʉ̃sãrẽ ĩãmi. “Ĩgʉ̃sã bʉjawererã, gũñaturamerã, oveja sugʉ ĩgʉ̃sãrẽ korerimasʉ̃ opamerã irirosũ ããrĩ́ma”, ãrĩ gũñayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Irasirigʉ ãsũ ãrĩmi gʉare ĩgʉ̃ buerãrẽ: —Marĩpʉyare neõ pémerã, pooegue oteri dʉka bʉribejadea irirosũ wárã ããrĩ́ma. Ĩgʉ̃sãrẽ ĩgʉ̃yare weremurã gapʉ iri pooere moãrĩmasã irirosũ mérãgã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Irasirirã marĩ Opʉre iri pooe opʉ irirosũ ããrĩgʉ̃́rẽ: “Gajerã mʉyare weremurãrẽ iriuka!” ãrĩ sẽrẽka! ãrĩmi Jesús gʉare. ");
INSERT INTO sri_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pʉrʉ Jesús gʉare pe mojõma pere su gubu peru pẽrẽbejarã ĩgʉ̃ buerã ããrĩmurãrẽ siiu, gʉare ĩgʉ̃ turarire sĩmi, ããrĩpereri pũrĩrĩrẽ tau, wãtẽa masakare ñajãnerãdere béowiuburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ãsũ wãĩkʉrã ããrĩbʉ́ gʉa Jesús beyenerã: Simón wãĩkʉgʉ ããrĩmí. Ĩgʉ̃rẽta “Pedro” wãĩyemi Jesús. Simón pagʉmʉ Andrés wãĩkʉmi. Gajigʉ Santiago ããrĩmí. Ĩgʉ̃ pagʉmʉ Juan wãĩkʉmi. Ĩgʉ̃sã Zebedeo pũrã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Gajerã Felipe, Bartolomé, Tomás ããrĩmá. Yʉ Mateo, romano marã opʉre niyeru wajaseabosarimasʉ̃ ããrĩdi ããrĩbʉ́. Gajigʉ Santiago, Alfeo magʉ̃ ããrĩmí. Gajigʉ Tadeo ããrĩmí. Ĩgʉ̃ta Lebeo wãĩkʉmi. ");
INSERT INTO sri_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Gajigʉ Simón, celote wãĩkʉri bumʉ ããrĩmí. Gajigʉ Judas Iscariote wãĩkʉgʉ ããrĩmí. Ĩgʉ̃ta Jesúre wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmubu ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús gʉare ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarãrẽ turarire sĩ odo, ãsũ ãrĩ were iriumi: —Judío masaka ããrĩmerã pʉroguere waabirikõãka! Irasũ ããrĩmakʉ̃, Samaria nikũma makãrĩguedere waabirikõãka! ");
INSERT INTO sri_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel bumarã Marĩpʉyare masĩmerã, oveja dedirinerã irirosũ ããrĩrã́ pʉro gapʉ waaka! ");
INSERT INTO sri_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ĩgʉ̃sãrẽ ãsũ ãrĩ wererã waaka: “Mérõ dʉyáa, Marĩpʉ ĩgʉ̃yarãrẽ doreri ejaburo”, ãrĩka! ");
INSERT INTO sri_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pũrĩrikʉrãrẽ tauka! Boanerãrẽ masũka! Kãmi boarãdere tauka! Wãtẽa masakare ñajãnerãrẽ béowiuka! Yʉ turarire mʉsãrẽ wajamarĩrõ sĩa. Irasirirã, yʉ mʉsãrẽ wajamarĩrõ sĩrõsũta wajamarĩrõ ĩgʉ̃sãrẽ tauka! ");
INSERT INTO sri_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Waarã́, neõ niyeru oro, plata, cobrere, ");
INSERT INTO sri_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","mʉsãya aju ãĩabirikõãka! Surí, sapatu mʉsã sãñarĩ merã dita waaka! Tuariyukure ãĩabirikõãka! Moãrĩmasã ĩgʉ̃sã moãrĩ waja merã wajata baama. Irasirirã mʉsã masakare bueri waja baari mʉsãrẽ sĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Makãrẽ ejarã, iri makã marã: “Ĩĩta õãrõ irigʉ ããrĩ́mi”, ĩgʉ̃sã ãrĩgʉ̃ pʉro dujaka! Mʉsã iro ããrĩrṍpã ĩgʉ̃ya wiire ããrĩka! Waarã́gue iri wiire wirika! ");
INSERT INTO sri_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Iri wiire ñajãrã, wii marãrẽ: “Marĩpʉ mʉsãrẽ siuñajãrĩ sĩburo”, ãrĩ õãdoreka! ");
INSERT INTO sri_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mʉsãrẽ õãrõ bokatĩrĩñeãmakʉ̃, ĩgʉ̃sãrẽ: “Marĩpʉ siuñajãrĩ sĩrĩ merã õãrõ ããrĩrikʉka!” ãrĩka! Mʉsãrẽ gããmemerã, i siuñajãrĩ merã ããrĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mʉsãrẽ ĩgʉ̃sã ñeãbirimakʉ̃, mʉsã buerire pédʉabirimakʉ̃ ĩãrã, ĩgʉ̃sãya wiire, o ĩgʉ̃sãya makãrẽ wiriarã, nikũwera mʉsãya guburigue tuadeare mojẽbéoka, ĩgʉ̃sãrẽ wajamoãburire ĩmurã! ");
INSERT INTO sri_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Diayeta mʉsãrẽ werea. Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃ Sodoma, Gomorra marãrẽ wajamoãrõ nemorõ mʉsãrẽ gããmemerãrẽ wajamoãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Yʉre õãrõ péka! Ovejare makãnʉ́ʉ marã diayéa guarã watopegue iriurosũ ñerã masaka watopegue mʉsãrẽ iriua. Irasirirã õãrõ pémasĩka! Ĩgʉ̃sã watopegue ñerõ iriro marĩrõ ããrĩrikʉka! ");
INSERT INTO sri_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pémasĩka! Masaka mʉsãrẽ ĩgʉ̃sã oparãrẽ wiarãkuma, mʉsãrẽ wajamoãdorerã. Judío masaka ĩgʉ̃sã nerẽrĩ wiiriguedere mʉsãrẽ tãrãrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Irasũ ããrĩmakʉ̃, mʉsã yʉre bʉremurĩ waja, ĩgʉ̃sãya makãrĩ marã oparã pʉrogue, ĩgʉ̃sãya nikũ marã oparã pʉrogue ãĩãrãkuma mʉsãrẽ wajamoãdoremurã. Irasirirã mʉsãrẽ irogue ãĩãmakʉ̃, oparãrẽ, judío masaka ããrĩmerãdere yaa kerere wererãkoa mʉsã. ");
INSERT INTO sri_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mʉsãrẽ oparã pʉrogue ãĩãmakʉ̃: “¿Naásũ ãrĩrãkuri ĩgʉ̃sãrẽ?” ãrĩ gũñarikʉbirikõãka! Oparã mʉsãrẽ sẽrẽñamakʉ̃, Marĩpʉ gũñarĩ sĩrĩ merã wererãkoa. ");
INSERT INTO sri_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Irasirirã mʉsã gũñarĩ merã werebirikoa. Marĩpʉ, Õãgʉ̃ deyomarĩgʉ̃ merã mʉsãrẽ masĩrĩ sĩrĩ merã werenírãkoa. ");
INSERT INTO sri_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Iripoere masaka, ĩgʉ̃sãyarã yʉre bʉremumakʉ̃ ĩãrã, ĩgʉ̃sãrẽ oparãguere wẽjẽdorerã wiarãkuma. Pagʉsãmarã ĩgʉ̃sã pũrãrẽ oparãguere wẽjẽdorerã wiarãkuma. Gajerã, ĩgʉ̃sã pagʉsãmarãrẽ ĩãturi, oparãguere wẽjẽdorerã wiarãkuma. ");
INSERT INTO sri_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Irasirirã masaka ããrĩperero i ʉ̃mʉ marã yʉre mʉsã bʉremurĩ waja mʉsãrẽ ĩãturi doorãkuma. Marĩpʉ gapʉ yʉre piriro marĩrõ bʉremugʉ̃rẽ taugʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Su makã marã mʉsãrẽ ñerõ irimakʉ̃, gaji makãgue duriwãgãka! Diayeta mʉsãrẽ werea. Ããrĩpereri Israel nikũma makãrĩrẽ mʉsã buegorena odoburo dupuyuro, yʉ ããrĩpererã tĩ́gʉ̃ Marĩpʉ iriudi i ʉ̃mʉgue dupaturi aarigʉkoa doja. ");
INSERT INTO sri_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Neõ sugʉ buegʉ, ĩgʉ̃rẽ buegʉ nemorõ ããrĩbemi. Moãboerimasʉ̃de ĩgʉ̃ opʉ nemorõ ããrĩbemi. ");
INSERT INTO sri_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sugʉ buegʉ ĩgʉ̃rẽ buedi irirosũ dujadʉamakʉ̃ õãgoráa. Moãboerimasʉ̃de ĩgʉ̃ opʉ irirosũ dujadʉamakʉ̃ õãgoráa. Masaka yʉre mʉsã Opʉre: “Ĩĩ Beelzebú, wãtẽa opʉ ããrĩ́mi”, ãrĩrã, mʉsã yaarãdere ñerõ ãrĩ werenírãkuma. ");
INSERT INTO sri_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Irasirirã mʉsãrẽ ñerõ iridʉarãrẽ güibirikõãka! Ããrĩpereri gajerã ĩãberogue irideare, durirogue irideadere pʉrʉgue masĩsũrokoa. ");
INSERT INTO sri_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yʉ mʉsãrẽ masaka péberogue weredeare ĩgʉ̃sã pérogue wereka! Yʉ mʉsãrẽ gajerã ĩãberogue werenídeare makã dekogue bʉro bʉsʉro merã wereka! ");
INSERT INTO sri_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉsãrẽ wẽjẽrã mʉsãya dupʉ direta boamakʉ̃ irirãkuma. Mʉsãya yʉjʉpũrãrĩ gapʉre boamakʉ̃ irimasĩbirikuma. Irasirirã güibirikõãka! Marĩpʉ gapʉre güika! Ĩgʉ̃ gapʉ mʉsãya dupʉ, mʉsãya yʉjʉpũrãrĩrẽ peamegue béomasĩmi. Irasirirã ĩgʉ̃rẽ güiri merã bʉremuka! ");
INSERT INTO sri_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Masaka pẽrã mirã wajarirã, su niyeru tigã, mérõgã wajakʉri tigãrẽ sĩkuma. Ĩgʉ̃sã mérõgã wajakʉkerepʉrʉ, Marĩpʉ gapʉ ĩgʉ̃sãrẽ õãrõ koremi. Ĩgʉ̃sãrẽ: “Boaburo”, ãrĩbirikerepʉrʉ, neõ sugʉgã yebague yuridija, boabemi. ");
INSERT INTO sri_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Marĩpʉ ããrĩpereri mʉsã ããrĩrikʉrire masĩgʉ̃, mʉsãya poarire: “Irikʉ ããrã”, ãrĩ masĩpeokõãmi. ");
INSERT INTO sri_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Irasirirã güibirikõãka! Mʉsã, mirã nemorõ wajakʉa. Irasirigʉ Marĩpʉ mirãrẽ korero nemorõ mʉsãrẽ koregʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Sugʉ, masaka péuro: “Jesúyagʉ ããrã”, ãrĩ weremakʉ̃, yʉde Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ péuro ĩgʉ̃rẽ: “Yaagʉ ããrĩ́mi ĩĩ”, ãrĩ weregʉra. ");
INSERT INTO sri_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sugʉ yʉre masĩkeregʉ, masaka péuro: “Ĩgʉ̃rẽ masĩbea”, ãrĩ weremakʉ̃, yʉde Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ péuro: “Yʉde ĩgʉ̃rẽ masĩbea”, ãrĩ weregʉra, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Irasũ ãrĩ odo, masakare ãsũ werenemomi: —Mʉsã yʉre: “Ĩgʉ̃ i ʉ̃mʉguere aarigʉ́, masakare siuñajãrĩ merã ããrĩmakʉ̃ irigʉ aarimí”, ãrĩ gũñabirikõãka! Irasirigʉ aarigʉ́ meta iribʉ. Yʉ ejarita, masakare ĩgʉ̃sã basi gãme dʉkawarimakʉ̃ yáa. Irasirirã surãyeri yʉre bʉremurãkuma. Gajerã yʉre bʉremumerã gapʉ ĩgʉ̃sãrẽ ĩãturirãkuma. ");
INSERT INTO sri_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sugʉ yʉre bʉremurĩ waja, ĩgʉ̃ magʉ̃ ĩgʉ̃rẽ ĩãturigʉkumi. Sugo yʉre bʉremurĩ waja, igo magõ igore ĩãturigokumo. Sugo mʉ́ñekõ yʉre bʉremurĩ waja, igo bepo igore ĩãturigokumo. ");
INSERT INTO sri_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Irasirirã su wii marã ĩgʉ̃sãyagʉ yʉre bʉremumakʉ̃ ĩãrã, ĩgʉ̃rẽ ĩãturirãkuma. ");
INSERT INTO sri_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Sugʉ yʉre maĩrõ nemorõ ĩgʉ̃ pagʉsãmarã gapʉre maĩtarinʉgãgʉ̃, yaagʉ ããrĩmasĩbirikumi. Yʉre maĩrõ nemorõ ĩgʉ̃ pũrã gapʉre maĩtarinʉgãgʉ̃de, yaagʉ ããrĩmasĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sugʉ yʉre tʉyadʉari waja curusague pábiatú wẽjẽsũbu irirosũ ããrĩkeregʉ, neõ piriro marĩrõ yʉre tʉyaníkõãburo. Yʉre tʉyadʉabi, yaagʉ ããrĩmasĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sugʉ i ʉ̃mʉgue ĩgʉ̃ okarire maĩgʉ̃, peamegue béosũgʉkumi. Gajigʉ yʉre tʉyari waja gajerã ĩgʉ̃rẽ wẽjẽkerepʉrʉ, Marĩpʉ gapʉ ĩgʉ̃rẽ taugʉkumi, ĩgʉ̃ pʉrogue ĩgʉ̃ merã ããrĩburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Sugʉ mʉsãrẽ yaarãrẽ õãrõ bokatĩrĩñeãgʉ̃, yʉdere bokatĩrĩñeãmi. Yʉre bokatĩrĩñeãgʉ̃, yʉre iriudidere bokatĩrĩñeãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Marĩpʉ ĩgʉ̃ya kerere weregʉre õãrĩ wajatamakʉ̃ irigʉkumi. Sugʉ Marĩpʉya kerere weregʉ ããrĩrĩ́rẽ ĩãmasĩ, ĩgʉ̃rẽ õãrõ bokatĩrĩñeãgʉ̃, ĩgʉ̃ irirosũ õãrĩ wajatagʉkumi. Sugʉ gajigʉ ĩgʉ̃ õãgʉ̃ ããrĩrĩ́rẽ ĩãmasĩ, ĩgʉ̃rẽ õãrõ bokatĩrĩñeãgʉ̃, ĩgʉ̃ irirosũ ĩgʉ̃de õãrĩ wajatagʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sugʉ ubu ããrĩgʉ̃́ yʉre tʉyagʉre gajigʉ ĩgʉ̃rẽ iritamudʉagʉ deko yʉsari tĩãmakʉ̃ ĩãgʉ̃, Marĩpʉ ĩgʉ̃dere õãrõ irigʉkumi, ãrĩ weremi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús gʉare pe mojõma pere su gubu peru pẽrẽbejarã ĩgʉ̃ buerãrẽ irasũ ãrãdero pʉrʉ, Galilea nikũgue ããrĩrĩ́ makãrĩ marãrẽ buegorenagʉ̃ waakõãmi. ");
INSERT INTO sri_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan masakare wãĩyerimasʉ̃ peresugue ããrĩyupʉ. Irogue ããrĩgʉ̃́, Cristo iriri kerere pégʉ, ĩgʉ̃ buerire tʉyarãrẽ Jesúre ãsũ ãrĩ sẽrẽñarã waaka: ");
INSERT INTO sri_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—“¿Mʉta ããrĩ́rĩ, Cristo masakare taugʉ aaribu iriayupʉ, ĩgʉ̃sã ãrĩdi, o gajigʉre yúrãkuri gʉa?” ãrĩ sẽrẽñarã waaka! ãrĩ iriuyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Irasirirã, Jesús pʉrogue ejarã, Juan sẽrẽñadoredeare ĩgʉ̃rẽ sẽrẽñama. Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Mʉsã périre, mʉsã ĩãrĩrẽ Juãrẽ wererã waaka! ");
INSERT INTO sri_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Koye ĩãbiranerã õãrõ ĩãma. Waamasĩbiranerã waamasĩakõãma. Kãmi boanerã yaripereakõãsũama. Gãmipũ pébiranerã péakõãma. Boanerãde masãkõãma. Boporã, Marĩpʉ masakare tauri kerere weremakʉ̃ péma. ");
INSERT INTO sri_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“Yʉre bʉremurĩrẽ piribi, ʉsʉyari opagʉkumi”, ãrĩ wererã waaka Juãrẽ! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ĩgʉ̃sã waadero pʉrʉ, Jesús Juãyamarẽ masakare ãsũ ãrĩ werenʉgãmi: —Mʉsã masaka marĩrõgue Juãrẽ ĩãrã waarã́, güigʉre gũñaturabire ĩãrã waarã́ meta irikuyo. Ĩgʉ̃ turabi, mirũ táborere wẽjẽpubéorosũ ããrĩbemi. ");
INSERT INTO sri_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Irasũ ããrĩmakʉ̃, mʉsã ĩgʉ̃rẽ irogue ĩãrã waarã́, õãrĩ surí sãñagʉ̃rẽ ĩãrã waarã́ meta irikuyo. Õãrĩ surí sãñarãno oparãya wiirigue ããrĩkuma. Juan ĩgʉ̃sã irirosũ ããrĩbemi. ");
INSERT INTO sri_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mʉsã irogue ĩgʉ̃rẽ ĩãrã waarã́, Marĩpʉya kerere weredupuyurimasʉ̃rẽ ĩãrã waarã́ iriyo. Mʉsãrẽ werea. Diayeta Juan Marĩpʉya kerere weredupuyunerã nemorõ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Marĩpʉya werenírĩ gojadea pũgue gojasũdero ããrĩbʉ́ Juan iriburire. Irasirigʉ Marĩpʉ ĩgʉ̃ magʉ̃rẽ ãsũ ãrĩdi ããrĩmí: Mʉ waaburo dupuyuro yaa kerere weredupuyurimasʉ̃rẽ iriugʉra mʉ waaburore ãmuyudoregʉ, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Mʉsãrẽ diayeta werea. Juan aariburi dupuyuro neõ sugʉ ĩgʉ̃ nemorõ yaamarẽ masĩgʉ̃ marĩdi ããrĩmí. Irasũ ããrĩkerepʉrʉ, sugʉ Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́yagʉ gapʉ Juan nemorõ yaamarẽ masĩgʉ̃ ããrĩgʉkumi. Ããrĩpererã nemorõ ubu ããrĩgʉ̃́ ããrĩkeregʉ, masĩgʉ̃ ããrĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan masakare wãĩyedi buenʉgãdeapoegueta, daporaguedere masaka ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ñajãdʉarãrẽ bʉro ñerõ tarimakʉ̃ yáma. Ĩgʉ̃sã turari merã ĩgʉ̃sãrẽ peremakʉ̃ iridʉarã iriadima. ");
INSERT INTO sri_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan aariburo dupuyuro ããrĩpererã Marĩpʉya kerere weredupuyunerã ĩgʉ̃sã gojadea merã, Moisés gojadea merã Marĩpʉ ĩgʉ̃yarãrẽ doreri kerere werenerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iripoegue Marĩpʉ ĩgʉ̃ya gojadea pũgue: “Yaa kerere weredupuyurimasʉ̃rẽ Elías irirosũ ããrĩbure iriugʉra”, ãrĩdi ããrĩmí. Juan irasũ ãrĩsũdita ããrĩ́mi. Irire bʉremurõ gããmea. ");
INSERT INTO sri_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gãmipũrĩ oparã, yʉ wererire õãrõ péka! ");
INSERT INTO sri_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Masaka dapora marã, ¿ñeémarãno irirosũ ããrĩ́rĩ? Majĩrã makã dekogue ĩgʉ̃sã merãmarã merã bira gainí doanírã irirosũ ããrĩ́ma. Ãsũ ãrĩ gainíma: ");
INSERT INTO sri_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Gʉa tẽrẽdiru purimakʉ̃, bayabirabʉ. Bʉjawereri merã gʉa bayamakʉ̃, orebirabʉ”, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan masakare wãĩyerimasʉ̃ pã́ baabiri, igui deko pãmudeare iiríbirimi. Ĩgʉ̃ irasirimakʉ̃ ĩãrã: “Wãtĩ ñajãsũdi ããrĩ́mi ĩĩ”, ãrĩbʉ mʉsã ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pʉrʉ yʉ ããrĩpererã tĩ́gʉ̃ baa, iirímakʉ̃ ĩãrã: “Baapagʉ, iirípagʉ ããrĩ́mi”, ãrĩbʉ. “Romano marã opʉre niyeru wajaseabosarimasã merãmʉ, ñerõ irirã merãmʉ ããrĩ́mi”, ãrĩbʉ mʉsã yʉre. Mʉsã gʉare bʉremubirikererã, gʉa iririre ĩãrã: “Marĩpʉ ĩgʉ̃sãrẽ masĩrĩ sĩmi”, ãrĩ masĩbokoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pʉrʉ Jesús iroma makãrĩ marãrẽ turimi. Ĩgʉ̃sã wári ĩgʉ̃ Marĩpʉ turari merã iririre iri ĩmumakʉ̃ ĩãkererã, ĩgʉ̃sã ñerõ iririre bʉjawerebiri, neõ piribirima. Irasirigʉ ĩgʉ̃sãrẽ ãsũ ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Mʉsã Corazín marã, Betsaida marãde ñerõ tarirãkoa. Iripoegue marã Tiro, Sidón marã, mʉsã ĩũrõ Marĩpʉ ĩgʉ̃ turari merã iri ĩmurõsũ iri ĩmumakʉ̃ ĩãrã, ĩgʉ̃sã ñerõ irideare piribonerã ããrĩmá. Ĩgʉ̃sã ñerõ irideare bʉro bʉjawererire ĩmurã, bʉjawereri surí sãña, nitĩrẽ dipuru weka mawasiripeobonerã ããrĩmá. Mʉsã gapʉ Marĩpʉ turari merã yʉ iri ĩmurĩrẽ ĩãkererã, mʉsã ñerõ iririre neõ piribea. ");
INSERT INTO sri_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Irasirigʉ mʉsãrẽ werea. Marĩpʉ ããrĩpererã ñerãrẽ ĩgʉ̃ wajamoãrĩnʉ ejamakʉ̃, Tiro, Sidón marãrẽ wajamoãrõ nemorõ mʉsãrẽ wajamoãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mʉsã Capernaum marãde: “Ʉ̃mʉgasigue mʉrĩãrãkoa”, ãrĩ gũñadáa. Iroguere neõ waabirikoa. Boanerã ããrĩrṍgue béodijusũrãkoa. Sodoma marãrẽ yʉ mʉsãrẽ Marĩpʉ ĩgʉ̃ turari merã iri ĩmuderosũta iri ĩmumakʉ̃, iri makã daporadere ããrĩbokoa dapa. ");
INSERT INTO sri_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Irasirigʉ mʉsãrẽ werea. Marĩpʉ ããrĩpererã ñerãrẽ ĩgʉ̃ wajamoãrĩnʉ ejamakʉ̃, Sodoma marãrẽ wajamoãrõ nemorõ mʉsã gapʉre wajamoãgʉkumi, mʉsã ñerõ iririre piribiri waja, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iripoere Jesús ĩgʉ̃ Pagʉre ãsũ ãrĩmi: —Aʉ, yʉ mʉrẽ: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩa. Mʉ ʉ̃mʉgasi marã, i nikũ marã Opʉ ããrã. Irasirigʉ: “Masĩtarinʉgãrã, ããrĩpererire pémasĩa”, ãrĩ gũñarãrẽ mʉyare masĩmakʉ̃ iribea. Majĩrã irirosũ mʉrẽ bʉremurã gapʉre mʉyare masĩmakʉ̃ yáa. ");
INSERT INTO sri_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aʉ, irasũta ããrã. Mʉ gããmederosũta ʉsʉyari merã irasũ yáa, ãrĩmi Jesús ĩgʉ̃ Pagʉre. ");
INSERT INTO sri_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pʉrʉ masakare ãsũ ãrĩ werenemomi: —Yʉpʉ yʉre ããrĩpereri irimasĩrĩrẽ sĩmi. Neõ sugʉ masakʉ yʉ ããrĩrikʉrire masĩbemi. Yʉpʉ dita yʉre masĩmi. Neõ sugʉ masakʉ Yʉpʉ ããrĩrikʉrire masĩbemi. Yʉ dita ĩgʉ̃rẽ masĩa. Yʉ ĩgʉ̃rẽ masĩdorerãde ĩgʉ̃rẽ masĩma. ");
INSERT INTO sri_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mʉsã Marĩpʉre tʉyadʉarã nʉkʉ̃rĩ ũũma õẽrã irirosũ ããrĩrã́ yʉ pʉro aarika! Yʉ mʉsãrẽ siuñajãrĩ sĩgʉra. ");
INSERT INTO sri_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mʉsã yʉ iridoreri gapʉre irika! Yʉ iririkʉrire masĩka! Yʉ mʉsãrẽ bopoñarĩ merã ĩã, iritamugʉ̃ ããrã. Irasirirã yʉ iridorerire irirã, yʉ merã õãrõ siuñajãrĩ bokarãkoa. ");
INSERT INTO sri_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yʉ iritamurõ merã yaare mʉsã irimakʉ̃ diasabea. Irasirirã yʉ dorerire irirã, nʉkʉ̃biri kãrãwʉririre ũũmarõsũ ããrĩrãkoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iripoere judío masaka siuñajãrĩnʉ ããrĩmakʉ̃, Jesús trigo otedero watope waamakʉ̃, gʉa ĩgʉ̃ buerã ʉaboasĩã, trigo yerire tʉ̃rĩ koro baabʉ. ");
INSERT INTO sri_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gʉa irasirimakʉ̃ ĩãrã, fariseo bumarã Jesúre ãsũ ãrĩma: —Ĩãka! ¿Nasirirã siuñajãrĩnʉrẽ moãdorebirikerepʉrʉ, mʉ buerã irasũ yári? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús ĩgʉ̃sãrẽ ãrĩmi: —¿Iripoeguemʉ David, ĩgʉ̃ merãmarã merã ʉaboagʉ, ĩgʉ̃ irideare mʉsã buebiriri? ");
INSERT INTO sri_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ĩgʉ̃ merãmarã merã Marĩpʉya wiigue ñajãa, Marĩpʉ ĩũrõ peyari pã́ duparure baadi ããrĩmí. Marĩpʉ paía ããrĩmerãrẽ: “Iri pã́ duparure baabirikõãka!” ãrĩdi ããrĩmí. David gapʉ paí ããrĩbirikeregʉ, irire baagʉ, Marĩpʉ ĩũrõ ĩgʉ̃ dorerire tarinʉgãgʉ̃ meta iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Paía Marĩpʉya wiigue moãrã, siuñajãrĩnʉrĩrẽ siuñajãbema. Siuñajãbirikererã, Marĩpʉ dorerire tarinʉgãbema. ¿Irire buebiriri mʉsã, Marĩpʉ Moisére doreri pídea pũguere? ");
INSERT INTO sri_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mʉsãrẽ werea. Marĩpʉya wiire bʉremurõ nemorõ yʉ gapʉre bʉremurõ gããmea. ");
INSERT INTO sri_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Marĩpʉ ĩgʉ̃ya werenírĩ gojadea pũgue ãsũ ãrĩdi ããrĩmí: “Yʉre bʉremurã waimʉrãrẽ wẽjẽ soepeomakʉ̃ gããmebea. Gajerãrẽ mʉsã bopoñarĩ merã ĩãmakʉ̃ gããmea”, ãrĩdi ããrĩmí. Mʉsã irire pémasĩrã yʉ buerã ñerõ iribirikerepʉrʉ, ĩgʉ̃sãrẽ: “Ñerõ yáma”, ãrĩbiribokoa. ");
INSERT INTO sri_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉ ããrĩpererã tĩ́gʉ̃ ããrĩsĩã, siuñajãrĩnʉrẽ masaka gajino ĩgʉ̃sã iriburire doremasĩa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Irasũ ãrĩ odo, waa, judío masaka nerẽrĩ wiigue ñajãmi. ");
INSERT INTO sri_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iro sugʉ masakʉ mojõ diíweredi ããrĩmí. Irasirirã fariseo bumarã Jesúre: “Ñerõ yámi”, ãrĩ weresãdʉarã, ĩgʉ̃rẽ sẽrẽñama: —¿Siuñajãrĩnʉ ããrĩmakʉ̃, sugʉ pũrĩrikʉgʉre taudoreri ããrĩ́rĩ? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús yʉjʉmi ĩgʉ̃sãrẽ: —Siuñajãrĩnʉ ããrĩkerepʉrʉ, mʉsãyagʉ oveja gobegue meéñajãmakʉ̃ ĩãrã, ĩgʉ̃rẽ ãĩ wiukõãkoa. ");
INSERT INTO sri_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Marĩpʉ sugʉ masakʉre, oveja nemorõ maĩtarinʉgãmi. Irasirirã siuñajãrĩnʉrẽ masakare õãrõ irirã, Moisés doredeare tarinʉgãrã meta yáa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Irasũ ãrĩ odo, mojõ diíweredire ãrĩmi: —Mʉya mojõrẽ soeoka! Ĩgʉ̃ya mojõrẽ soeomakʉ̃ta, gaji mojõ irirosũ õãrĩ mojõ dujabʉ. ");
INSERT INTO sri_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ĩgʉ̃ irasirimakʉ̃ ĩãrã, fariseo bumarã gua wiria: “¿Nasirisĩã, marĩ Jesúre wẽjẽrãkuri?” ãrĩ gãme wereníñurã. ");
INSERT INTO sri_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús ĩgʉ̃sã ĩgʉ̃rẽ wẽjẽdʉarire masĩ, waakõãmi. Ĩgʉ̃ waamakʉ̃, wárã masaka ĩgʉ̃rẽ tʉyama. Irasirigʉ ããrĩpererã pũrĩrikʉrãrẽ taumi. ");
INSERT INTO sri_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ĩgʉ̃sãrẽ taugʉ: “Yaamarẽ gajerãrẽ werebirikõãka!” ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesús irasirigʉ, Marĩpʉya kerere weredupuyudi Isaías gojaderosũta irimi. Ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ãsũ ãrĩmi Marĩpʉ: “Ĩĩ yʉre moãboegʉ, yʉ beyedi, yʉ maĩgʉ̃ ããrĩ́mi. Ĩgʉ̃ merã ʉsʉyáa. Õãgʉ̃ deyomarĩgʉ̃rẽ ĩgʉ̃rẽ sĩgʉra. Irasirigʉ yʉ turari merã ããrĩpererã masakare diayema iririre weregʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ĩgʉ̃ guaseo, gainíbirikumi. Ĩgʉ̃ makã dekogue bʉro gainígorenamakʉ̃ neõ pébirikuma. ");
INSERT INTO sri_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Turamerãrẽ bopoñarĩ merã ĩã, iritamugʉkumi. Irasirigʉ, ĩgʉ̃sã miũmerẽñu biu peaboadiñu irirosũ ããrĩmakʉ̃ ĩãgʉ̃, peabéogʉ irirosũ ĩgʉ̃sãrẽ iribirikumi. Bʉjawererãrẽ gũñaturamakʉ̃ irigʉkumi. Irasirigʉ, ĩgʉ̃sã sĩãgodiru yauboadiru irirosũ ããrĩmakʉ̃ ĩãgʉ̃, yaubéogʉ irirosũ ĩgʉ̃sãrẽ iribirikumi. Ĩgʉ̃ Opʉ ñajãburi dupuyuro ĩgʉ̃sãrẽ irasirigʉkumi. Ĩgʉ̃ Opʉ ñajãdero pʉrʉ, masakare diayema iririre irimakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Irasirirã ããrĩperero marã ĩgʉ̃ doreburire ʉsʉyari merã yúrãkuma”, ãrĩmi, ãrĩ gojadi ããrĩmí Isaías. ");
INSERT INTO sri_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pʉrʉ masaka wãtĩ ñajãsũdire Jesúre taudorerã ãĩjama. Ĩgʉ̃ wãtĩ ñajãsũdi: wereníbi, koye ĩãbi ããrĩmí. Ĩgʉ̃sã ãĩjamakʉ̃ ĩã, Jesús ĩgʉ̃rẽ taumi. Ĩgʉ̃ irasirimakʉ̃, õãrõ ĩã, wereními. ");
INSERT INTO sri_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ããrĩpererã masaka, ĩgʉ̃ tarimakʉ̃ ĩãgʉka, ãsũ ãrĩ gãme sẽrẽñama: —¿Ĩĩ David parãmi ããrĩturiagʉ masakare taubu meta ããrĩkuri? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, fariseo bumarã gapʉ ãsũ ãrĩma: —Ĩĩ wãtẽa opʉ Beelzebú turari merã wãtẽãrẽ béowiumi, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús ĩgʉ̃sã gũñarĩrẽ masĩsĩã, ĩgʉ̃sãrẽ ãsũ ãrĩmi: —Su nikũ marã ĩgʉ̃sã basi dʉkawari gãmekẽãrã, pereakõãkuma. Su makã marã, o su wii marã ĩgʉ̃sã basi dʉkawari gãmekẽãrã, pereakõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Irasũta wãtẽa opʉ ĩgʉ̃yarã wãtẽãrẽ béowiugʉ, ĩgʉ̃ basita ĩgʉ̃yarãrẽ dʉkawari pereakõãmakʉ̃ iribokumi. Irasirigʉ, ¿noãrẽ dorenemobokuri? ");
INSERT INTO sri_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mʉsã yʉre: “Wãtẽa opʉ Beelzebú turari merã wãtẽãrẽ béowiumi”, ãrĩ werewʉáa. Mʉsã buerire tʉyarã gapʉ wãtẽãrẽ béowiurã, ¿noã turari merã béowiukuri? Mʉsã ĩgʉ̃sãrẽ: “Marĩpʉ turari merã wãtẽãrẽ béowiuma”, ãrã. Irasiriro mʉsã yʉre werewʉari diaye ããrĩbea. ");
INSERT INTO sri_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yʉ Õãgʉ̃ deyomarĩgʉ̃ turari merã wãtẽãrẽ béowiua. Irasiriro Marĩpʉ ĩgʉ̃yarãrẽ doreri mʉsã pʉroguere ejasiáa, ãrĩ masĩsũa. ");
INSERT INTO sri_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Irire keori merã mʉsãrẽ werenemogʉra. Neõ sugʉ masakʉ, turagʉya wiire ĩgʉ̃rẽ siapʉroribirikeregʉ, ĩgʉ̃ oparire ẽmagʉ̃ ñajãmasĩbirikumi. Ĩgʉ̃rẽ siadero pʉrʉgue merẽ ĩgʉ̃yare ẽmamasĩkumi, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Irasũ ãrĩ odo, ãsũ ãrĩnemomi: —Yʉre gããmemerã, yʉre ĩãturirã ããrĩ́ma. Masakare yʉre siiu neeõtamumerã, ĩgʉ̃sãrẽ waawasirimakʉ̃ irirã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Mʉsãrẽ diayeta werea. Marĩpʉ ããrĩpereri masaka ñerõ iririre, ñerõ ãrĩ werenírĩdere kãtimasĩmi. Õãgʉ̃ deyomarĩgʉ̃rẽ ĩgʉ̃sã ñerõ ãrĩ werenímakʉ̃ tamerãrẽ neõ kãtibirikumi. ");
INSERT INTO sri_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yʉ ããrĩpererã tĩ́gʉ̃rẽ ĩgʉ̃sã ñerõ ãrĩ werenímakʉ̃, Marĩpʉ irire kãtimasĩmi. Õãgʉ̃ deyomarĩgʉ̃ gapʉre ĩgʉ̃sã ñerõ ãrĩ werenímakʉ̃, irire neõ kãtibirikumi. Dapora, i ʉ̃mʉ peredero pʉrʉguedere ĩgʉ̃sã irasũ ãrĩdeare neõ kãtibirikumi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Irasũ ãrĩ odo, Jesús gaji keori merã buenemomi: —Õãdi yukʉ õãrĩrẽ dʉkakʉa. Ñedi yukʉ ñerĩrẽ dʉkakʉa. Yukʉre irigʉ dʉka merã ĩãmasĩsũa. ");
INSERT INTO sri_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mʉsã ãña irirosũ ñerã ããrã. Mʉsã ñerã ããrĩsĩã, õãrĩrẽ werenímasĩbea. Marĩ gũñarõsũta marĩ werenírĩ wirikõãa. ");
INSERT INTO sri_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Õãgʉ̃ õãrĩ gũñarĩ opami. Irasirigʉ õãrĩrẽ wereními. Ñegʉ̃ ñerĩ gũñarĩ opami. Irasirigʉ ñerĩrẽ wereními. ");
INSERT INTO sri_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mʉsãrẽ werea. Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, ããrĩpereri masaka noó gããmerõ werenímoãmadeare ĩgʉ̃sãrẽ masĩmakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mʉsã õãrõ werenídea waja Marĩpʉ mʉsãrẽ: “Waja opabema”, ãrĩgʉkumi. Mʉsã ñerõ werenídea waja mʉsãrẽ: “Waja opama”, ãrĩgʉkumi, ãrĩmi Jesús fariseo bumarãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pʉrʉ surãyeri fariseo bumarã, Moisés gojadeare buerimasã ĩgʉ̃rẽ ãrĩma: —Buegʉ, Marĩpʉ turari merã gʉare iri ĩmuka! ãrĩma. “Ĩgʉ̃ irire irimasĩbi, Marĩpʉ iriudi meta ããrĩ́mi”, ãrĩdʉarã irasũ ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús yʉjʉmi: —Mʉsã dapora marã masaka ñerã, Marĩpʉre gããmemerã ããrã. Mʉsã yʉre Marĩpʉ turari merã gajino iri ĩmudorea. Mʉsã irasiridorekerepʉrʉ, Marĩpʉya kerere weredupuyudi Jonás iridea direta weregʉra. ");
INSERT INTO sri_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás ʉrenʉ, ʉre ñami waaí wágʉya paru poekague ããrĩderosũta yʉde ããrĩpererã tĩ́gʉ̃ ʉrenʉ, ʉre ñami yeba poekague ããrĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Iripoegue Nínive marã Jonás Marĩpʉya kerere weremakʉ̃ pérã, ĩgʉ̃sã ñerõ irideare bʉjawere, ĩgʉ̃sã gũñarĩrẽ gorawayunerã ããrĩmá. Dapora yʉ Jonás nemorõ masĩgʉ̃ õõgue mʉsã merã ããrã. Yʉ Marĩpʉya kerere werekerepʉrʉ, mʉsã ñerõ iririkʉrire bʉjawerebea. Irasirirã, Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, Nínive marã mʉsã dapora marãrẽ: “Ñegorabʉ”, ãrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, sugo iripoeguemo Sabá nikũ marã opo mʉsã dapora marãrẽ: “Ñegorabʉ”, ãrĩgokumo. Yoaromogue ããrĩkerego, õõgue i nikũgue aarideo ããrĩmó, marĩ ñekʉ̃sãmarã opʉ Salomón wári masĩrĩ merã wererire pégo aarigó. Dapora yʉ Salomón nemorõ masĩgʉ̃ õõgue mʉsã merã ããrã. Yʉ mʉsã merã ããrĩkerepʉrʉ, mʉsã gapʉ yʉ wererire pédʉabea, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Irasũ ãrĩ odo, keori merã werenemomi doja: —Wãtĩ masakʉguere ããrãdi wiri, pʉrʉ deko marĩrõgue ĩgʉ̃ siuñajãburore ãmagorenagʉ̃ waakumi. ");
INSERT INTO sri_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Irore bokabi, ãsũ ãrĩ gũñakumi: “Yʉ wiridi, yaa wii irirosũ ããrĩmí. Dupaturi yʉ wiridiguereta goeñajãgʉra doja”, ãrĩ gũñakumi. Irasirigʉ ĩgʉ̃guere dupaturi goeñajãgʉ̃, gajino marĩrĩ wii, õãrõ ãmu, ooaweadea wiire irirosũ bokajakumi. ");
INSERT INTO sri_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Irasirigʉ gajerã wãtẽa su mojõma pere gaji mojõ peru pẽrẽbejarã ĩgʉ̃ nemorõ ñerãrẽ siiu, ĩgʉ̃sã ããrĩpererã merã masakʉguere ããrĩníkõãkumi. Irasirigʉ masakʉ ĩgʉ̃ dupuyuro ããrĩrikʉdero nemorõ ñerõ ããrĩkumi. Dapora marã Marĩpʉre gããmemerã, yʉre pédʉamerã irasũta ñerõ waarãkuma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús masakare wereripoe ĩgʉ̃ pago, ĩgʉ̃ pagʉpũrã merã ĩgʉ̃ ããrĩrĩ́ wii disipʉro ejayupo ĩgʉ̃ merã werenídʉago. ");
INSERT INTO sri_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sugʉ igore ĩã, Jesúre weremi: —Mʉpo, mʉ pagʉpũrã disipʉro níama, mʉ merã werenídʉarã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃rẽ ãrĩmi: —¿Noã ããrĩ́rĩ yʉpo, yʉ pagʉpũrã? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Irasũ ãrĩgʉ̃, gʉare ĩgʉ̃ buerãrẽ soepu, ãsũ ãrĩmi: —Ĩĩsã, yʉpo, yʉ pagʉpũrã irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ gããmerĩrẽ irirãno, yʉ pagʉmʉ, yʉ pagʉmo, yʉpo irirosũ ããrĩ́ma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Irinʉta Jesús wiigue ããrãdi ditarugue waa, iri ditaru tʉro eja doami. ");
INSERT INTO sri_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Masaka wárã ĩgʉ̃ pʉro nerẽmakʉ̃ ĩãgʉ̃, doódirugue mʉrĩñajãa, eja doami. Ããrĩpererã masaka ĩmiparogue dujanʉgãma ĩgʉ̃ buerire pémurã. ");
INSERT INTO sri_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Irasirigʉ wári keori merã ĩgʉ̃sãrẽ ãsũ ãrĩ buemi: —Sugʉ oterimasʉ̃ ĩgʉ̃ya oteri yerire meéwasirigʉ waakumi. ");
INSERT INTO sri_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ĩgʉ̃ meéwasiriwãgãmakʉ̃, gaji yeri maague yurikoa. Iro yuriadea yerire mirã eja, baapeokõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gaji yeri ʉ̃tãyerikʉrogue yurikoa. Iro sĩmerẽrõgã nikũ ããrĩmakʉ̃, iro yuriadea yeri mata puriadikoa. ");
INSERT INTO sri_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iri nikũ sĩmerẽrõgã ããrĩmakʉ̃, puriñajãdi, pʉrʉ abe asimakʉ̃, nugũrĩ marĩsĩã, ñaĩ, boakõãkoa. ");
INSERT INTO sri_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gaji yeri pora watopegue yurikoa. Pora gapʉ puritarimʉrĩa, oteri gapʉre wẽjẽkõãkoa. ");
INSERT INTO sri_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gaji yeri õãrĩ nikũgue yurikoa. Iri yeri puri, õãrõ dʉkakʉkoa. Suñu cien yeri, gajiñu sesenta yeri, gajiñu treinta yeri dʉkakʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mʉsã gãmipũrĩ oparã, yʉ wererire péduripíka! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pʉrʉ gʉa ĩgʉ̃ buerã ĩgʉ̃ pʉro waa, ĩgʉ̃rẽ sẽrẽñabʉ: —¿Nasirigʉ masakare keori merã bueri? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús gʉare yʉjʉmi: —Marĩpʉ ĩgʉ̃yarãrẽ doregʉ ããrĩrĩ́rẽ, iripoegue masĩbirideare mʉsãrẽ masĩmakʉ̃ yámi. Gajerã ĩgʉ̃rẽ bʉremumerã gapʉre irasiribemi. ");
INSERT INTO sri_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ĩgʉ̃yare masĩrãnorẽ masĩnemomakʉ̃ irigʉkumi. Irasirirã wáro masĩrĩ oparãkuma. Gajerã ĩgʉ̃rẽ bʉremumerã ĩgʉ̃yare masĩmerãrẽ ĩgʉ̃sã mérõ masĩadideare pémasĩbirimakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Irasirigʉ yʉ ĩgʉ̃sãrẽ keori merã buea. Ĩgʉ̃sã Marĩpʉ iririre ĩãkererã, ĩãmasĩbema. Ĩgʉ̃yare pékererã, péduripíbema. Neõ pémasĩbema. ");
INSERT INTO sri_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Irasirirã Marĩpʉya kerere weredupuyudi Isaías gojaderosũta yáma. Ãsũ ãrĩ gojadi ããrĩmí: Ãsũ ãrĩmi Marĩpʉ: “Yaare pékererã, mʉsã neõ pémasĩbea. Yʉ iririre ĩãkererã, mʉsã neõ ĩãmasĩbea. ");
INSERT INTO sri_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yaa werenírĩrẽ pédʉabirisĩã, mʉsã neõ pémasĩbea. Gãmipũrĩ pémerã, koye ĩãmerã irirosũ ããrã. Mʉsã irasũ ããrĩmerã, yaare ĩãmasĩ, õãrõ pémasĩbokoa. Yʉ pémasĩrĩ sĩrĩrẽ oparã yʉre bʉremubokoa. Irasirigʉ mʉsãrẽ taubokoa”, ãrĩmi Marĩpʉ, ãrĩ gojadi ããrĩmí Isaías. ");
INSERT INTO sri_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Gʉa gapʉre ãrĩmi: —Mʉsã gapʉ pémasĩa. Irasirirã ʉsʉyáa. Yʉ iririre ĩãrã, yʉ wererire pérã, yʉre bʉremua. ");
INSERT INTO sri_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Diayeta mʉsãrẽ werea. Wárã iripoegue marã Marĩpʉya kerere weredupuyunerã, gajerã Marĩpʉre bʉremunerã mʉsã dapora ĩãrĩrẽ bʉro ĩãdʉanerã ããrãdima. Irire ĩãdʉakererã, irire ĩãbirinerã ããrĩmá. Mʉsã dapora périre bʉro pédʉakererã, pébirinerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Irasirirã õãrõ péka! Yʉ oterimasʉ̃ keori merã bueadeare mʉsãrẽ weregʉra. Iri ãsũ ãrĩdʉaro yáa. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri kere, oteri yeri irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Surãyeri masaka iri kerere pékererã, pémasĩbema. Maa bʉriri maa irirosũ ããrĩ́ma. Iri kerere péadero pʉrʉ, oteri yeri iri maague yuridea yerire mirã baapeoderosũ, wãtĩ aari, ĩgʉ̃sã péadideare ẽmapeokõãmi. ");
INSERT INTO sri_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Gajerã masaka ʉ̃tãyerikʉri yeba irirosũ ããrĩ́ma. Iri kerere pérã, mata ʉsʉyari merã: “Õãgoráa”, ãrĩ gũñama. Irire pékererã, oteri yeri ʉ̃tãyerikʉrogue yuriadero pʉrʉ, puri, nugũrĩ puriñajãbiriderosũ waama. Mérõgã pʉrʉ ĩgʉ̃sã Marĩpʉyare pédʉari waja gajerã ĩgʉ̃sãrẽ ñerõ irimakʉ̃ ĩãrã, o ñerõ tarisĩã, mata ĩgʉ̃yare pirikõãma. ");
INSERT INTO sri_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Gajerã masaka porakʉri yeba irirosũ ããrĩ́ma. Iri kerere pékererã, oteri yeri porakʉrogue yuriadero pʉrʉ, pora gapʉ puritarimʉrĩa wẽjẽderosũ, i ʉ̃mʉmarẽ bʉro gũñarikʉma. Doebiridere bʉro gããmenemoma. Irasirirã Marĩpʉyare kãtima. Otediñu dʉka marĩdiñu irirosũ dujama. ");
INSERT INTO sri_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Gajerã masaka õãrĩ nikũ irirosũ ããrĩ́ma. Marĩpʉya kerere pérã, õãrõ pémasĩma. Irasirirã oteri yeri õãrĩ nikũgue yuriadero pʉrʉ, puri õãrõ dʉkakʉderosũ õãrĩrẽ yáma. Surãyeri cien yeri, gajerã sesenta yeri, gajerã treinta yeri dʉkakʉrosũ irirã ããrĩ́ma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús irasũ ãrĩ odo, gaji keori merã gʉare buemi: —Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri i irirosũ ããrã. Sugʉ pooe opʉ ĩgʉ̃ya pooegue õãrĩ yerire otekumi. ");
INSERT INTO sri_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Su ñami merã ããrĩpererã kãrĩripoe ĩgʉ̃rẽ ĩãturigʉ pooegue eja, ĩgʉ̃ trigo oteadea watopegue ñerĩ táre otekumi. Ote odo, waakõãkumi. ");
INSERT INTO sri_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo yeri puriwiriadero pʉrʉ, ñerĩ táde purikoa. Pʉrʉ trigo dʉkakʉkoa. Iri dʉkakʉmakʉ̃ ĩãrã, iri pooe opʉre moãboerimasã ñerĩ tá ããrĩmakʉ̃ ĩãmasĩkuma. ");
INSERT INTO sri_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Irasirirã iri pooe opʉre wererã waakuma: —Gʉa opʉ, ¿nasiriro õãrĩ yeri direta mʉya pooere otesũdero ããrĩkerepʉrʉ, ñerĩ táde puriyuri? ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, ãsũ ãrĩkumi: —Yʉre ĩãturigʉ iri ñerĩ táre otekumi, ãrĩkumi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ moãboerimasã sẽrẽñakuma doja: —¿Ñerĩ táre gʉa taáseabéorã waamakʉ̃ gããmekuri mʉ? ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—Taáseabirikõãka! Ñerĩ táre taásearã trigodere duuabokoa. ");
INSERT INTO sri_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Iri, ñerĩ tá merãta puri masãkõãburo. Trigo ñaĩmakʉ̃, gajerã dʉka seaboerimasãrẽ ãsũ ãrĩ iriugʉra: “Ñerĩ táre taáseapʉrori, dupa dotori siaka, irire soemurã! Pʉrʉ trigore seaka, irire yʉ duripíri wiigue duripímurã!” ãrĩgʉra, ãrĩkumi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Irasũ ãrĩ odo, gaji keori merã buemi: —Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri sugʉ masakʉ ĩgʉ̃ya pooegue suye oteriye mostaza wãĩkʉri yegãrẽ oterosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iri oteri yegã ããrĩpereri oteri yeri nemorõ mérĩ yegã ããrĩkoa. Irasũ ããrĩkerero, otemakʉ̃, pʉrʉ yukʉ wádi irirosũ puri masãkoa. Irasirirã wʉ́rã irigʉ dʉpʉrigue ĩgʉ̃sãya surí suakuma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pʉrʉ gaji keori merã buemi: —Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri i irirosũ ããrã. Sugo nomeõ pã́ duparure iribo, mérõgã pã́ wemasãmakʉ̃ iriri poga merã trigo pogare morẽkumo. Irire wemasãseyaburo, ãrĩgõ, irasirikumo. Irasiriro Marĩpʉ ĩgʉ̃yarãrẽ doreri iri pã́ wemasãrĩ morẽrĩ poga irirosũ ããrã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús masakare i ããrĩpereri buerire weregʉ, keori merã dita buenami. Keori marĩrõ ĩgʉ̃sãrẽ buenabirimi. ");
INSERT INTO sri_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Irasirigʉ Marĩpʉya kerere weredupuyudi gojaderosũta irimi. Ãsũ ãrĩ gojadi ããrĩmí Jesús masakare wereburimarẽ: Keori merã weregʉkoa. Iri merã weregʉ, Marĩpʉ i ʉ̃mʉrẽ iridero pʉrʉgue marã neõ masĩbirideare dapora marãrẽ weregʉra, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pʉrʉ Jesús masakare seretu odo, wiigue ñajãmi. Ĩgʉ̃ ñajãmakʉ̃ ĩã, gʉa ĩgʉ̃ buerã ĩgʉ̃ pʉrogue ñajãa, ĩgʉ̃rẽ sẽrẽñabʉ: —Trigo otedea watopegue ñerĩ tá puri masãdea keorire werenemoka! ¿Naásũ ãrĩdʉaro iriari? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Gʉa irasũ ãrĩmakʉ̃ pégʉ, Jesús yʉjʉmi: —Yʉ ããrĩpererã tĩ́gʉ̃, iri pooe opʉ õãrĩ yeri otedi irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pooe gapʉ i ʉ̃mʉ irirosũ ããrã. Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ããrĩmurã gapʉ õãrĩ yeri irirosũ ããrĩ́ma. Wãtĩyarã ñerĩ tá irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","’Wãtĩ pooe opʉre ĩãturigʉ irirosũ ããrĩ́mi. I ʉ̃mʉ pererinʉ iri otedea dʉkare searinʉ irirosũ ããrã. Marĩpʉre wereboerã, pooe opʉre dʉka seaboerimasã irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","’Iri ñerĩ táre ĩgʉ̃sã taáseadeare peamegue soebéoderosũta i ʉ̃mʉ pererinʉ ejamakʉ̃ waarokoa. ");
INSERT INTO sri_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Irasũ waaripoe yʉ ããrĩpererã tĩ́gʉ̃, yʉre wereboerãrẽ iriugʉkoa. Irasirirã ĩgʉ̃sã masakare ñerĩ irimakʉ̃ irirãrẽ, Marĩpʉ dorerire tarinʉgãrãdere neeõrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Neeõ odo, perebiri peamegue ĩgʉ̃sãrẽ béorãkuma. Irogue bʉro pũrĩsũrã ĩgʉ̃sãya guikare kũrĩduútú orerãkuma. ");
INSERT INTO sri_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Marĩpʉ gããmerĩrẽ irirã gapʉ ʉ̃mʉgasigue ĩgʉ̃yarãrẽ dorerogue ããrĩrã́, abe ʉ̃mʉmʉ irirosũ gosewasirirãkuma. Mʉsã gãmipũrĩ oparã, yʉ wererire péduripíka! ");
INSERT INTO sri_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Gaji mʉsãrẽ werea. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri i irirosũ ããrã. Sugʉ masakʉ wáro niyeru gajigʉya nikũ poekague yáapídeare bokakumi. Irire bokagʉ, bʉro ʉsʉyakumi. Irasirigʉ ĩgʉ̃ bokadeare bʉro gããmesĩã, dupaturi yáapíkõãkumi doja. Irasirigʉ ããrĩpereri ĩgʉ̃yare gajerãrẽ duakumi. Ĩgʉ̃ duadea waja merã iri nikũrẽ wajarikumi. ");
INSERT INTO sri_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Gaji mʉsãrẽ werea doja. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri i irirosũ ããrã. Sugʉ wajaririmasʉ̃ wajapari yeri perla wãĩkʉri yerire ãma wajaridʉakumi. ");
INSERT INTO sri_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iri yerire ãmagʉ̃́, wajapatariri yere bokakumi. Iri yere bʉro gããmesĩã, ããrĩpereri ĩgʉ̃yare duakumi. Ĩgʉ̃ duadea waja merã iri yere wajarikumi. ");
INSERT INTO sri_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Gaji mʉsãrẽ werea doja. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri, waaí wẽjẽrĩmasã buidi meéyo, ããrĩpererã waaí ããrĩrã́kʉ ñeãrõ irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ĩgʉ̃sãya buidire waaí ʉtʉrimakʉ̃ ĩãrã, waaí wẽjẽrĩmasã ĩmiparogue tʉ̃ãmajã, waairé beyekuma. Õãrã waairé ĩgʉ̃sãya puuirigue seasãkuma. Ñerãrẽ béokõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","I ʉ̃mʉ pererinʉ ããrĩmakʉ̃, masakare ãsũta waarokoa. Marĩpʉre wereboerã õãrãrẽ, ñerãrẽ beyerã aarirãkuma. ");
INSERT INTO sri_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Beye odo, ñerãrẽ perebiri peamegue béorãkuma. Irogue bʉro pũrĩsũrã ĩgʉ̃sãya guikare kũrĩduútú orerãkuma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pʉrʉ gʉare sẽrẽñami: —¿I ããrĩpererire pémasĩrĩ mʉsã? ãrĩmi. —Ʉ̃́ʉ̃, pémasĩa, ãrĩ yʉjʉbʉ. ");
INSERT INTO sri_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gʉa irasũ ãrĩmakʉ̃, ãrĩmi: —Sugʉ Moisés gojadeare buerimasʉ̃ Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doregʉ ããrĩrĩ́marẽ masĩgʉ̃, wii opʉ irirosũ ããrĩgʉkumi. Irasirigʉ wii opʉ, iripoegue ĩgʉ̃ opadeare, maama ĩgʉ̃ oparidere ãĩwiugʉ irirosũ, maama buerire, iripoeguema bueridere õãrõ masĩrĩ merã weregʉkumi, ãrĩmi Jesús gʉare. ");
INSERT INTO sri_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús iri keori merã were odo, iro ããrãdi waa, ");
INSERT INTO sri_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ĩgʉ̃ masãdea makãgue ejami. Irogue eja, judío masaka nerẽrĩ wiigue buemi. Masaka, ĩgʉ̃ buemakʉ̃ pérã, pégʉkakõãma. Ãsũ ãrĩ gãme wereníma: —¿Noógue bueyuri, ĩĩ iropã masĩbu? ¿Nasirisĩã, iri ĩmurĩrẽ irimasĩyuri? ");
INSERT INTO sri_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ĩĩ taboa moãdi magʉ̃ ããrĩ́mi. Ĩgʉ̃ pago María wãĩkʉmo. Santiago, José, Simón, Judas ĩgʉ̃ pagʉpũrã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ĩgʉ̃ pagʉpũrã nomede i makã marãta ããrĩ́ma. Ĩgʉ̃ marĩ irirosũ ããrĩkeregʉ, ¿nasirisĩã, i ããrĩpererire masĩrĩ? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Irasirirã ĩgʉ̃rẽ bʉremudʉabirima. Jesús gapʉ ĩgʉ̃sãrẽ ãrĩmi: —Ããrĩpererogue sugʉ Marĩpʉya kerere weredupuyugʉre gajerã bʉremuma. Ĩgʉ̃ya nikũ marã, ĩgʉ̃ya wii marã gapʉ ĩgʉ̃rẽ bʉremubema, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Irasirigʉ Jesús, ĩgʉ̃sã ĩgʉ̃rẽ bʉremubirimakʉ̃ ĩãgʉ̃, iri makãrẽ wári Marĩpʉ turari merã iri ĩmubirimi. ");
INSERT INTO sri_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Iripoere Herodes Galilea nikũ marã opʉ, Jesús iriri kerere péyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Irire pégʉ, ĩgʉ̃rẽ moãboerãrẽ ãsũ ãrĩyupʉ: —Ĩgʉ̃ irire irasũ irigʉ, Juan masakare wãĩyerimasʉ̃ta boadigue masãdi ããrĩkumi. Irasirigʉ wári iri ĩmurĩrẽ irikumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Juan boaburi dupuyuro Herodes ĩgʉ̃ pagʉmʉ Felipe marãpo Herodías wãĩkʉgore ẽma, marãpokʉmakʉ̃ ĩãgʉ̃, ");
INSERT INTO sri_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ãsũ ãrĩdi ããrĩmí: —Mʉ pagʉmʉ marãpore marãpokʉgʉ, Marĩpʉ dorerire tarinʉgãgʉ̃ yáa, ãrĩdi ããrĩmí. Irasirigʉ Herodes ĩgʉ̃rẽ ñeã, peresu iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ĩgʉ̃ Juãrẽ wẽjẽdʉadi ããrĩmí. Judío masaka gapʉ: “Ĩĩ Juan Marĩpʉya kerere weredupuyurimasʉ̃ ããrĩ́mi”, ãrĩ gũñanerã ããrĩmá. Irasirigʉ Herodes: “Juãrẽ yʉ wẽjẽmakʉ̃ yʉ merã guabokuma”, ãrĩgʉ̃, ĩgʉ̃sãrẽ güidi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pʉrʉ Herodes ĩgʉ̃ deyoadea bosenʉ irigʉ iridi ããrĩmí. Ĩgʉ̃ irasiririnʉrẽ Herodías magõ ĩgʉ̃ siiuanerã ĩũrõ baya ĩmudeo ããrĩmó. Igo baya ĩmumakʉ̃ ĩãgʉ̃, Herodes bʉro ʉsʉyadi ããrĩmí. Irasirigʉ igore: ");
INSERT INTO sri_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“Ãrĩgatoro marĩrõ, mʉ yʉre sẽrẽrĩnorẽ sĩgʉra”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, igo pagore: “¿Ñeénorẽ sẽrẽgokuri yʉ?” ãrĩdeo ããrĩmó. Irasirigo igo pago sẽrẽdoreaderosũta ĩgʉ̃rẽ sẽrẽdeo ããrĩmó: —Juan masakare wãĩyerimasʉ̃ya dipurure dititá, soropa wáripa merã ĩgʉ̃ya dipurure yʉre sĩka! ãrĩdeo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Igo irasũ ãrĩmakʉ̃ pégʉ, Herodes bʉro bʉjaweredi ããrĩmí. Ĩgʉ̃ siiuanerã péuro: “Ãrĩgatoro marĩrõ, mʉ yʉre sẽrẽrĩnorẽ sĩgʉra”, ãrãdi ããrĩsĩã, gʉyasĩrĩgʉ̃, igore: “Mʉrẽ sĩbirikoa”, ãrĩmasĩbiridi ããrĩmí. Irasirigʉ, igo ĩgʉ̃rẽ sẽrẽrõsũta iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Irasirigʉ, ĩgʉ̃yagʉ surara Juan peresugue ããrĩgʉ̃́ pʉro waa, ĩgʉ̃ya dipurure dititádi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pʉrʉ soropa merã ĩgʉ̃ya dipurure ãĩri, Herodías magõrẽ wiadi ããrĩmí. Ĩgʉ̃ wiamakʉ̃ ñeã, igo pagore ãĩa sĩdeo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juan boadero pʉrʉ, ĩgʉ̃ buerire tʉyanerã ĩgʉ̃ya dupʉre ãĩwãgã, yáarã waanerã ããrĩmá. Yáa odo, Juan boadeare Jesúre wererã ejama. ");
INSERT INTO sri_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juãrẽ wẽjẽadea kerere pégʉ, Jesús doódirugue mʉrĩñajãa, masaka marĩrõgue gʉa ĩgʉ̃ buerã merã waakõãmi. Ĩgʉ̃ irogue waaríre pérã, masaka ĩgʉ̃sãya makãrĩrẽ wiri, ĩgʉ̃ dupuyuro maague waa, ejasianerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Gʉa ditaru gaji koepʉgue taribujaja, Jesús doódirugue sãñadi majãnʉgã, wárã masakare bokajami. Irasirigʉ ĩgʉ̃sãrẽ bopoñarĩ merã ĩã, pũrĩrikʉrã ĩgʉ̃sã ãĩrianerãrẽ taumi. ");
INSERT INTO sri_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Naĩmejãwãgãripoe gʉa Jesús buerã ĩgʉ̃ pʉro waa, ãsũ ãrĩbʉ ĩgʉ̃rẽ: —Naĩmejãrõgue yáa. Õõ masaka marĩrõgue ããrã. Irasirigʉ masakare waadoreka! Makãrĩgue ĩgʉ̃sã baaburire wajarirã waaburo, ãrãdibʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Gʉa irasũ ãrĩmakʉ̃ pégʉ, Jesús ãrĩmi: —Waabirikõãburo. Mʉsã ĩgʉ̃sãrẽ baari sĩka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gʉa ĩgʉ̃rẽ ãrĩbʉ: —Su mojõma pã́ duparu, waaídere pẽrãta opáa, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Irire yʉre ãĩrika! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pʉrʉ masakare tá weka doadoremi. Irasirigʉ su mojõma pã́ duparure, pẽrã waairé ãĩ, ʉ̃mʉgasigue ĩãmu, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩmi. Ãrĩ odo, iri pã́ duparure pea, gʉare ĩgʉ̃ buerãrẽ sĩmi masakare gueredoregʉ. Irasirirã gʉa ĩgʉ̃sãrẽ irire guerebʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Irasirirã ããrĩpererã baayapiakõãma. Pʉrʉ ĩgʉ̃sã baadʉáadeare pe mojõma pere su gubu peru pẽrẽbejari puuirigora seasã, ʉtʉudobobʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iro baanerã: nome, majĩrã keoña márĩrõ ʉ̃ma direta keomakʉ̃ cinco mil gora ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pʉrʉ Jesús gʉa ĩgʉ̃ buerãrẽ doódirugue mʉrĩñajãdore, ditarugue ĩgʉ̃ dupuyuro taribujadoremi. Ĩgʉ̃ gapʉ irogue dujami dapa masakare seretubu. ");
INSERT INTO sri_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Seretu odo, buúru wekague sugʉta waayupʉ Marĩpʉre sẽrẽgʉ̃ waagʉ́. Ñami ejaripoe sugʉta ããrĩyupʉ iroguere. ");
INSERT INTO sri_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Gʉa gapʉ ditaru dekogue ããrĩbʉ́. Mirũ bʉro waabʉ. Irasiriro makũrĩ doódirure pátúpaukõãbʉ. Irasirirã taribujajabiribʉ dapa. ");
INSERT INTO sri_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pʉrʉ ãgãbo wereripoe Jesús ditarugue buaja, gʉa pʉrogue deko weka aarimí. ");
INSERT INTO sri_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ĩgʉ̃ deko weka aarimakʉ̃, gʉa ĩgʉ̃rẽ ĩãmasĩbirisĩã, ĩãgʉkakõãbʉ. Güiri merã: “Masakʉ boadi wãtĩ ããrĩ́mi”, ãrĩ gainíbʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gʉa güimakʉ̃ ĩãgʉ̃, Jesús gʉare ãsũ ãrĩmi: —Gũñaturaka! Yʉta ããrã. Güimerãta! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ãrĩmi ĩgʉ̃rẽ: —Mʉ, yʉ Opʉ ããrĩgʉ̃́, yʉre deko weka waa, mʉ pʉrogue aaridoreka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Jáʉ, aarika! ãrĩmi Jesús. Irasũ ãrĩmakʉ̃ pégʉ, Pedro doódirugue sãñadi dujinʉgã, deko weka Jesús pʉrogue waami. ");
INSERT INTO sri_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ĩgʉ̃ irasũ waakeregʉ, mirũ bʉro wẽjẽpumakʉ̃ ĩãgʉ̃, güigorami. Irasirigʉ mirĩdijagʉ: —Yʉ Opʉ, yʉre tauka! ãrĩ gainími. ");
INSERT INTO sri_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, Jesús ĩgʉ̃ya mojõrẽ ñeã: “Yʉre mérõgã bʉremurĩ opáa. ¿Nasirigʉ yʉre bʉremuturaberi?” ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pʉrʉ Jesús Pedro merã doódirugue aari, mʉrĩñajãmakʉ̃, mirũ waadea toeakõãbʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Irasũ waamakʉ̃ ĩãrã, gʉa doódirugue ããrĩrã́ ñadʉkʉpuri merã Jesús pʉro eja doa, ĩgʉ̃rẽ: —Mʉ diayeta Marĩpʉ magʉ̃ ããrã, ãrĩ bʉremubʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pʉrʉ taribujaja, Genesaret wãĩkʉri nikũgue ejabʉ. ");
INSERT INTO sri_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iro marã Jesúre ĩãmasĩsĩã, ããrĩpererã iro ããrĩrã́rẽ ĩgʉ̃ ejari kerere wereñurã. Irasirirã ããrĩpererã pũrĩrikʉrãrẽ taudorerã ĩgʉ̃ pʉrogue ãĩjama. Ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽma: ");
INSERT INTO sri_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Mʉya suríro yuwa direta ĩgʉ̃sãrẽ moãñadoreka! ãrĩma. Irasirirã ããrĩpererã pũrĩrikʉrã ĩgʉ̃ya surírore moãñanerã ĩgʉ̃sã sĩrĩrĩ opadeare tarisũma. ");
INSERT INTO sri_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pʉrʉ surãyeri fariseo bumarã, Moisés gojadeare buerimasãde Jerusalẽ́gue ããrãnerã Jesús pʉro eja, ĩgʉ̃rẽ sẽrẽñama: ");
INSERT INTO sri_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Nasirirã mʉ buerã, marĩ ñekʉ̃sãmarã iriunaderosũ iriberi? Marĩ ñekʉ̃sãmarã baaburi dupuyuro mojõkoederosũ iribema, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Yʉde mʉsãrẽ sẽrẽñagʉra. ¿Nasirirã Marĩpʉ doreri gapʉre irirono irirã, mʉsã ñekʉ̃sãmarã iriunadeare yári? ");
INSERT INTO sri_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Marĩpʉ ãsũ ãrĩdi ããrĩmí: “Mʉpʉre, mʉpore bʉremuka! Sugʉ ĩgʉ̃ pagʉsãmarãrẽ ñerõ werenígʉ̃ wẽjẽdoresũgʉkumi”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ĩgʉ̃ irasũ ãrĩkerepʉrʉ, mʉsã gapʉ masakare ĩgʉ̃sã pagʉsãmarãya ããrĩburire buerã, ãsũ ãrã: “Sugʉ ĩgʉ̃ pagʉre, o ĩgʉ̃ pagore: ‘Yʉ mʉsãrẽ sĩboadeare Marĩpʉre sĩpeokõãbʉ. Irasirigʉ mʉsãrẽ iritamumasĩbirikoa’, ãrĩmakʉ̃ õãgoráa”, ãrĩ buea. ");
INSERT INTO sri_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Irasũ buerã, masakare ĩgʉ̃sã pagʉsãmarãrẽ iritamubirimakʉ̃, Marĩpʉ dorerire ubu ĩãbéomakʉ̃ yáa, mʉsã ñekʉ̃sãmarã iriunadeare iritʉyadorerã. ");
INSERT INTO sri_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Masaka ĩũrõ dita õãrõ yáa mʉsã. Ĩgʉ̃sã ĩãberogue ñerõ iririkʉrã ããrã. Iripoegue Marĩpʉya kerere weredupuyudi Isaías diayeta gojadi ããrĩmí mʉsã irigatorire gojagʉ. Ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ĩĩsã masaka ĩgʉ̃sãya disi merã yʉre õãrõ wereníkererã, ĩgʉ̃sãya yʉjʉpũrãrĩgue yʉre neõ bʉremubema. ");
INSERT INTO sri_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Irasiriro ĩgʉ̃sã yʉre bʉremurã nerẽrĩ wajamáa. Ĩgʉ̃sã bueri, yʉ doreri meta ããrã. Masaka doreri ããrã, ãrĩ gojadi ããrĩmí, ãrĩ yʉjʉmi Jesús fariseo bumarãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Irasũ ãrĩ odo, masakare ĩgʉ̃ pʉro siiu, ãsũ ãrĩmi: —Yʉ wererire õãrõ pékũĩnú péka! ");
INSERT INTO sri_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sugʉ masakʉya disigue baari ñajãri, ĩgʉ̃rẽ ñegʉ̃ waamakʉ̃ iribea. Ĩgʉ̃ya disigue wiriri gapʉ, ĩgʉ̃rẽ ñegʉ̃ waamakʉ̃ yáa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, gʉa ĩgʉ̃ buerã ĩgʉ̃ pʉro waa, ĩgʉ̃rẽ ãrĩbʉ: —¿Mʉ masĩrĩ? Mʉ irasũ ãrãdeare pérã, fariseo bumarã guakõãma, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Gʉa irasũ ãrĩmakʉ̃, Jesús ãsũ ãrĩ yʉjʉmi: —Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ããrĩpereri ĩgʉ̃ otebirideare nugũrĩ merãta duua béogʉ irirosũ ĩgʉ̃sãrẽ béogʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Irasirirã ĩgʉ̃sãrẽ irasũ ĩãkõãka! Ĩgʉ̃sã Marĩpʉyare masĩbirikererã, gajerã ĩgʉ̃yare masĩmerãrẽ buema. Irasirirã koye ĩãmerã gajerã koye ĩãmerãrẽ tʉ̃ãdupuyurã irirosũ ããrĩ́ma. Sugʉ koye ĩãbi gajigʉ koye ĩãbire tʉ̃ãdupuyuwãgãgʉ̃, ĩgʉ̃sã pẽrãgueta gobegue meéñajãkõãrãkuma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro gapʉ Jesúre ãrĩmi: —Gʉare wereka! Masakʉ ĩgʉ̃ya disi wiriri keori, ¿naásũ ãrĩdʉaro yári? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús yʉjʉmi: —¿Mʉsãde pémasĩberi dapa? ");
INSERT INTO sri_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ããrĩpereri marĩ baari, marĩya disigue ñajãa, parugue waa, pʉrʉ tariwereakõãa. ");
INSERT INTO sri_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Masaka werenírĩ, ĩgʉ̃sãya disi wiriri ããrã. Ĩgʉ̃sã gũñarĩgue ñerĩrẽ oparã ñerõ wereníma. Iri ĩgʉ̃sãrẽ ñerã waamakʉ̃ yáa. ");
INSERT INTO sri_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ĩgʉ̃sã gũñarĩgue ñerĩ oparã ãsũ ããrĩ́ma. Ñerĩ gũñarã, masakare wẽjẽbéorã, gajigʉ marãpo, gajego marãpʉ merã ñerõ irirã, ʉ̃ma nome merã, nome ʉ̃ma merã ñerõ gãmebirarã, yajarã, ãrĩgatorã, masakare ñerõ kere wererã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iri ñerĩ ĩgʉ̃sã gũñarĩgue opari, ĩgʉ̃sãrẽ ñerã waamakʉ̃ yáa. Masaka ĩgʉ̃sã ñekʉ̃sãmarã iriunaderosũ baaburi dupuyuro mojõkoebirimakʉ̃, ĩgʉ̃sãrẽ ñerã waamakʉ̃ iribea, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pʉrʉ Jesús Tiro, Sidón wãĩkʉri makãrĩ ããrĩrṍgue waami. ");
INSERT INTO sri_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Irogue ejamakʉ̃, sugo nomeõ Canaán nikũmo irogue ããrĩgṍ Jesús pʉro gainíjamo: —Yʉ Opʉ, David parãmi ããrĩturiagʉ yʉre bopoñaka! Yʉ magõ wãtĩ ñajãsũdeo bʉro ñerõ tarigo yámo, ãrĩmo. ");
INSERT INTO sri_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Igo irasũ ãrĩmakʉ̃ pékeregʉ, Jesús igore yʉjʉbirimi. Irasirirã gʉa ĩgʉ̃ buerã ĩgʉ̃rẽ ãrĩbʉ: —Waadoreka igore! Marĩrẽ ñerõ gainí tʉyawãgãrimo, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Gʉa irasũ ãrĩmakʉ̃ pégʉ, Jesús igore ãrĩmi: —Yʉpʉ yʉre, Israel bumarã oveja dedirinerã irirosũ ããrĩrã́ direta iritamudoregʉ iriumi, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Igo Israel bumo ããrĩbirikerego, Jesús guburi pʉro ñadʉkʉpuri merã ejamejã, ãsũ ãrĩmo: —Yʉ Opʉ, yʉre iritamuka! ãrĩmo. ");
INSERT INTO sri_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús igore yʉjʉmi: —Wii opʉ ĩgʉ̃ pũrã baarire ẽma, diayéare ejomakʉ̃ õãbea, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ĩgʉ̃ irasũ ãrĩkerepʉrʉ, igo gapʉ ĩgʉ̃rẽ ãrĩmo doja: —Yʉ Opʉ, irasũ ããrĩkerepʉrʉ, diayéa gapʉ wii marã baawasiridijurire baaboema, ãrĩmo. ");
INSERT INTO sri_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Igo irasũ ãrĩmakʉ̃, Jesús igore yʉjʉmi: —Mʉ yʉre bʉremurĩ opataria. Mʉ sẽrẽrõsũta waarokoa, ãrĩmi. Ĩgʉ̃ irasũ ãrĩripoeta, igo magõguere wãtĩ ñajãdi wiriakõãyupʉ. Irasirigo tariyupo. ");
INSERT INTO sri_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús irogue ããrãdi waa, Galilea wãĩkʉri ditaru tʉro tariwãgãmi. Pʉrʉ buúrugue mʉrĩa, eja doami. ");
INSERT INTO sri_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ĩgʉ̃ iro doamakʉ̃, wárã masaka ejama. Waamasĩmerãrẽ, koye ĩãmerãrẽ, werenímasĩmerãrẽ, poyarimasãrẽ, wárã gajerã pũrĩrikʉrãrẽ ĩgʉ̃ pʉro ãĩjapíma. Irasirigʉ Jesús ĩgʉ̃sãrẽ taumi. ");
INSERT INTO sri_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Irasirimakʉ̃ ĩãrã, masaka ĩãgʉkakõãma. Werenímasĩbirinerã werenímakʉ̃ ĩãrã, poyarimasã ããrĩñerã tarimakʉ̃ ĩãrã, waamasĩbirinerã waamasĩmakʉ̃ ĩãrã, koye ĩãbirinerã ĩãmakʉ̃ ĩãrã, ĩãgʉkakõãma. Irasirirã Marĩpʉre: “Marĩ Israel bumarã Opʉ, turatarigʉ ããrĩ́mi”, ãrĩ, ʉsʉyari sĩma. ");
INSERT INTO sri_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pʉrʉ Jesús gʉare ĩgʉ̃ buerãrẽ siiu, ãrĩmi: —Ĩĩsã masakare bopoñarĩ merã ĩãa. Yʉ merã ʉrenʉgora ããrĩsiama. Ĩgʉ̃sãrẽ baari pereakõãa. Ĩgʉ̃sãrẽ ʉa merã ĩgʉ̃sãya wiirigue goedujáamakʉ̃ gããmebirikoa. Ĩgʉ̃sã baamerãta waarã́, maa dekota turari perea kõmoakõãbokuma, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ĩgʉ̃ irasũ ãrĩmakʉ̃, gʉa ĩgʉ̃ buerã ĩgʉ̃rẽ ãrĩbʉ: —¿Nasirisĩã, marĩ õõ masaka marĩrõgue ĩĩsã wárã masaka baaburire bokabokuri? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús gʉare sẽrẽñami: —¿Diíkʉ pã́ duparure opari mʉsã? ãrĩmi. —Su mojõma pere gaji mojõ peru pẽrẽbejari duparu, irasũ ããrĩmakʉ̃ waaí mérãgã opáa, ãrĩ yʉjʉbʉ. ");
INSERT INTO sri_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Irasirigʉ Jesús masakare yebague doadore, ");
INSERT INTO sri_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","su mojõma pere gaji mojõ peru pẽrẽbejari pã́ duparure, waaigã́dere ãĩ, Marĩpʉre ʉsʉyari sĩmi. Odo, pã́ duparure, waaigã́dere pea, gʉare sĩmi. Irasirirã gʉa irire masakare guerebʉ. ");
INSERT INTO sri_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Irasirirã ããrĩpererã irire baayapiakõãma. Pʉrʉ ĩgʉ̃sã baadʉáadeare su mojõma pere gaji mojõ peru pẽrẽbejari puuirigora seasã, ʉtʉudobobʉ. ");
INSERT INTO sri_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iro baanerã: nome, majĩrã keoña marĩrõ ʉ̃ma direta keomakʉ̃, cuatro mil gora ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pʉrʉ Jesús masakare seretu odomakʉ̃, doódirugue mʉrĩñajãa, Magdala wãĩkʉrogue ĩgʉ̃ merã waakõãbʉ. ");
INSERT INTO sri_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jesús Magdala wãĩkʉrogue ejadero pʉrʉ, fariseo bumarã, saduceo bumarã ĩgʉ̃rẽ ĩãrã ejarã: “Marĩpʉ turari merã iri ĩmurĩrẽ irika!” ãrĩma. “Ĩgʉ̃ irire irimasĩbi, diayeta Marĩpʉ iriudi meta ããrĩ́mi”, ãrĩdʉarã, irasũ ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús gapʉ ĩgʉ̃sãrẽ yʉjʉmi: —Mʉsã ñamika abe õãrõ diiañajãmakʉ̃ ĩãrã: “Õãrĩ ñami ããrĩrokoa”, ãrã. ");
INSERT INTO sri_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Boyoripoe ñípimakʉ̃ ĩãrã: “Dekonʉ ããrĩrokoa”, ãrã. Ʉ̃marõmarẽ ĩãrã: “Ãsũ waarokoa”, ãrĩ masĩa. Irire õãrõ masĩkererã, inʉ Marĩpʉ turari merã yʉ iri ĩmurĩ gapʉre ĩãrã, neõ õãrõ pémasĩbea. ");
INSERT INTO sri_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dapora marã masaka ñerã, Marĩpʉre gããmemerã ããrĩ́ma. Yʉre Marĩpʉ turari merã gajino iri ĩmudorema. Ĩgʉ̃sã irasiridorekerepʉrʉ, Marĩpʉya kerere weredupuyudi Jonás iridea direta weregʉra, ãrĩmi. Irasũ ãrĩ odo, ĩgʉ̃sãrẽ béowãgã, gajerogue waakõãmi. ");
INSERT INTO sri_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pʉrʉ gʉa ditarugue taribujarã, pã́rẽ kãtikõãnerã ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Irasirigʉ Jesús gʉare ãrĩmi: —Fariseo bumarã, saduceo bumarã ĩgʉ̃sã pã́ wemasãrĩ morẽrĩrẽ õãrõ pémasĩka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ĩgʉ̃ irasũ ãrĩrĩrẽ gʉa gapʉ pémasĩbiribʉ. Irasirirã gʉa basi gãme ãsũ ãrĩ wereníbʉ: —Marĩ pã́rẽ ãĩribiradeare ĩãgʉ̃, irasũ ãrĩkumi, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gʉa irasũ ãrĩrĩrẽ masĩsĩã, gʉare sẽrẽñami: —¿Nasirirã: “Pã́rẽ ãĩribirabʉ”, ãrĩ gãme werenírĩ mʉsã? Yʉre mérõgã bʉremurĩ opáa mʉsã. ");
INSERT INTO sri_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mʉsã pémasĩberi dapa? ¿Yʉ cinco mil ʉ̃marẽ su mojõma pã́ duparure dʉkawa ejodeare gũñaberi mʉsã? Ĩgʉ̃sã baayapiadero pʉrʉ, ¿diíkʉ puuirigora ĩgʉ̃sã baadʉáadeare mʉsã seasã ʉtʉudobori? ");
INSERT INTO sri_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Pʉrʉ yʉ su mojõma pere gaji mojõ peru pẽrẽbejari pã́ duparure dʉkawa, cuatro mil ʉ̃marẽ ejodeadere gũñaberi mʉsã? Ĩgʉ̃sã baayapiadero pʉrʉ, ¿diíkʉ puuirigora ĩgʉ̃sã baadʉáadeare mʉsã seasã ʉtʉudobori? ");
INSERT INTO sri_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nasirirã mʉsã yʉ wererire pémasĩberi? Yʉ: “Fariseo bumarã, saduceo bumarã pã́ wemasãrĩ morẽrĩrẽ õãrõ pémasĩka!” ãrĩgʉ̃, pã́rẽ ãrĩgʉ̃ meta iriabʉ, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa pémasĩbʉ. Pã́ wemasãrĩ morẽrĩrẽ ãrĩgʉ̃ meta irimi. Fariseo bumarã, saduceo bumarã ãrĩgatori merã bueri gapʉre: “Õãrõ pémasĩka!” ãrĩgʉ̃ irimi. ");
INSERT INTO sri_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pʉrʉ Jesús Cesarea Filipo wãĩkʉri makã pʉrogue waami. Irogue eja, gʉare ĩgʉ̃ buerãrẽ sẽrẽñami: —Masaka yʉre ããrĩpererã tĩ́gʉ̃rẽ, ¿naásũ ãrĩ gũñarĩ? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Gʉa ĩgʉ̃rẽ yʉjʉbʉ: —Surãyeri mʉrẽ: “Juan masakare wãĩyerimasʉ̃ ããrĩ́mi”, ãrĩma. Gajerã: “Elías ããrĩ́mi”, gajerã: “Jeremías ããrĩ́mi, o gajigʉ Marĩpʉya kerere weredupuyurimasʉ̃ ããrĩ́mi”, ãrĩma, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Irasũ ãrĩmakʉ̃, Jesús gʉare sẽrẽñami: —Mʉsãkoa yʉre, ¿naásũ ãrĩ gũñarĩ? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Simón Pedro ĩgʉ̃rẽ ãrĩmi: —Mʉ, Marĩpʉ iriudi, Cristo ããrã. Marĩpʉ okanígʉ̃ magʉ̃ ããrã mʉ, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃rẽ yʉjʉmi: —Simón, Jonás magʉ̃, mʉ yʉre yʉjʉri, masaka mʉrẽ weredea meta ããrã. Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ irire mʉrẽ masĩmakʉ̃ yámi. Irasirigʉ mʉ ʉsʉyari opáa. ");
INSERT INTO sri_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mʉrẽ werea. Mʉ “Pedro” wãĩkʉa. I ʉ̃tãye weka turari wiire iriboderosũ yʉ mʉ merã yaarãrẽ yʉre bʉremuturarã ããrĩmakʉ̃ irigʉkoa. Irasirigʉ wãtĩ ĩgʉ̃ turari merã yʉre bʉremurãrẽ neõ tarinʉgãbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yʉ mʉrẽ Marĩpʉ ĩgʉ̃yarãrẽ doreroguema sawire sĩgʉkoa, mʉ iroguemarẽ iridoreburire. Irasirigʉ mʉ Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ dorerosũta: “I ʉ̃mʉguere ãsũ waabirikõãburo”, ãrĩmakʉ̃, irire waabirimakʉ̃ irigʉkumi. Mʉ ĩgʉ̃ dorerosũta: “I ʉ̃mʉguere ãsũ waaburo”, ãrĩmakʉ̃, irire waamakʉ̃ irigʉkumi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesús irasũ ãrãdero pʉrʉ, gʉare ãrĩmi: —Gajerã masakare yʉre: “Marĩpʉ iriudi, Cristo ããrĩ́mi ĩĩ”, ãrĩ werebirikõãka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ĩgʉ̃ irasũ ãrĩrĩnʉ merãta Jesús gʉare ĩgʉ̃ buerãrẽ ĩgʉ̃ boaburire werenʉgãmi: —Yʉre Jerusalẽ́gue waaró ããrã. Irogue marã: judío masaka mʉrã, paía oparã, Moisés gojadeare buerimasã yʉre bʉro ñerõ tarimakʉ̃ irirãkuma. Yʉre wẽjẽrãkuma. Ĩgʉ̃sã irasirikerepʉrʉ, ʉrenʉ waaró merã Marĩpʉ yʉre masũgʉkumi, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro Jesúre yoaweyarogue ãĩa, ĩgʉ̃rẽ ãsũ ãrĩmi: —Yʉ Opʉ, irire ãrĩbirikõãka! Marĩpʉ, mʉ ãrĩrõsũ mʉrẽ waamakʉ̃ kãmutaburo. Mʉ ãrĩrõsũ mʉrẽ waabirikõãburo, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús gãmenʉgã, ĩgʉ̃rẽ ãsũ ãrĩmi: —Satanás, yʉ pʉrore wirika! Mʉ, Marĩpʉ yʉre dorerire iribirimakʉ̃ iridʉagʉ yáa. Marĩpʉ gããmerĩrẽ gũñabea. Masaka gũñarõsũ gũñáa mʉ, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ĩgʉ̃ irasũ ãrĩ odo, gʉare ãrĩmi: —Sugʉ yʉre tʉyadʉagʉ ĩgʉ̃ iridʉarire piriburo. Irasirigʉ yʉre tʉyadʉari waja curusague pábiatú wẽjẽsũbu irirosũ ããrĩkeregʉ, neõ piriro marĩrõ yʉre tʉyaníkõãburo. ");
INSERT INTO sri_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sugʉ i ʉ̃mʉgue ĩgʉ̃ya okari direta maĩgʉ̃ peamegue béosũgʉkumi. Gajigʉ gapʉ yʉre tʉyari waja gajerã ĩgʉ̃rẽ wẽjẽkerepʉrʉ, Marĩpʉ pʉrogue ĩgʉ̃ merã ʉsʉyari bokagʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sugʉ masakʉ i ʉ̃mʉmarẽ ããrĩpereri opakeregʉ, ĩgʉ̃ boari pʉrʉ waaburi gapʉre gũñabiri waja peamegue waagʉ́, õãrĩrẽ neõ wajatabirikumi. Irasirigʉ i ʉ̃mʉgue opari direta gũñagʉ̃, ĩgʉ̃ boadero pʉrʉ, peamegue béosũgʉkumi. Iroguere ĩgʉ̃ wiridʉagʉ i ʉ̃mʉgue opari merã neõ wajarimasĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉ ããrĩpererã tĩ́gʉ̃, Yʉpʉ gosewasiriri merã, ĩgʉ̃rẽ wereboerã merã i ʉ̃mʉguere dupaturi aarigʉ́, ããrĩpererã masakare ĩgʉ̃sã irideakʉ keoro wajarigʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Diayeta werea yʉ. Surãyeri mʉsã õõguere ããrĩrã́ mʉsã boaburo dupuyuro yʉ ããrĩpererã tĩ́gʉ̃, Opʉ ñajãmakʉ̃ ĩãrãkoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Su mojõma pere gaji mojõ suru pẽrẽbejarinʉrĩ pʉrʉ, Jesús Pedrore, Santiagore, ĩgʉ̃ pagʉmʉ Juãrẽ ʉ̃marĩ buúrugue siiu mʉrĩãmi. ");
INSERT INTO sri_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iri buúru wekague ĩgʉ̃sã mʉrĩjadero pʉrʉ, ĩgʉ̃sã ĩũrõ ĩgʉ̃ deyori gorawayuakõãyupʉ. Ĩgʉ̃ diapu abe ʉ̃mʉmʉ irirosũ gosewasiriyuro. Ĩgʉ̃ya suríro goseriñe, õãrõ borero waayuro. ");
INSERT INTO sri_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Irasũ waaripoeta iripoegue marã Moisés, Elías Jesús merã weretamunímakʉ̃ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ĩgʉ̃sãrẽ ĩãgʉ̃, Pedro Jesúre ãrĩyupʉ: —Gʉa Opʉ, marĩ õõ ããrĩmakʉ̃ õãtaridʉáa. Mʉ gããmemakʉ̃, õõguere ʉre wiigã irigʉra. Mʉya wii, Moiséya wii, Elíaya wii irigʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ĩgʉ̃ irasũ ãrĩ wereníripoe, õãrõ gosewasiriri mikãyebo ĩgʉ̃sãrẽ túbiakõãyuro. Iri yebo poekague Marĩpʉ ãsũ ãrĩ werenímakʉ̃ péñurã: —Ĩĩ yʉ magʉ̃, yʉ maĩgʉ̃ ããrĩ́mi. Ĩgʉ̃ merã bʉro ʉsʉyáa. Õãrõ péka ĩgʉ̃rẽ! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Irasũ ãrĩmakʉ̃ pérã, Jesús buerã bʉro güiri merã, ejamejã, ĩgʉ̃sãya diapurire yebague moomejãkõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ĩgʉ̃sã irasirimakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃sã pʉro waa, ĩgʉ̃sãrẽ moãña: —Wãgãnʉgãka! Güibirikõãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ĩgʉ̃ irasũ ãrĩmakʉ̃ ĩũrã, gajerãrẽ ĩãbiriñurã. Jesús direta ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pʉrʉ buúrugue ããrãnerã dijariñurã. Irogue dijarigʉ Jesús ĩgʉ̃sãrẽ turaro merã ãrĩyupʉ: —Dapora mʉsã ĩãdeare gajerãrẽ werebirikõãka! Yʉ ããrĩpererã tĩ́gʉ̃ boa, masãdero pʉrʉgue irire wereka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃ buerã ĩgʉ̃rẽ sẽrẽñañurã: —¿Nasirirã Moisés gojadeare buerimasã: “Cristo, Marĩpʉ iriubu aariburo dupuyuro Elías aaripʉrorigʉkumi”, ãrĩrĩ? ãrĩ sẽrẽñañurã. ");
INSERT INTO sri_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Mʉsã ãrĩrõsũta Elías aaripʉrorigʉkumi ããrĩpererire ãmuyubu. ");
INSERT INTO sri_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yʉ gapʉ ãsũ ãrĩ weregʉra mʉsãrẽ. Elías ejasiami. Ĩgʉ̃ ejakerepʉrʉ, masaka ĩgʉ̃rẽ ĩãmasĩbirima. Irasirirã ĩgʉ̃sã gããmerõ iridʉarire ĩgʉ̃rẽ ñerõ irima. Ĩgʉ̃rẽ iriderosũta yʉ ããrĩpererã tĩ́gʉ̃rẽ ñerõ irirãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérãgue, pémasĩñurã. “Ĩgʉ̃: ‘Elías ejasiami’, ãrĩgʉ̃, Juan masakare wãĩyedire ãrĩgʉ̃ yámi”, ãrĩ masĩñurã pama. ");
INSERT INTO sri_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pʉrʉ ĩgʉ̃sã buúrugue ããrãnerã wárã masaka pʉro dijajama. Ĩgʉ̃sã dijajamakʉ̃ ĩãgʉ̃, sugʉ masakʉ aari, Jesús pʉro ñadʉkʉpuri merã ejamejã, ĩgʉ̃rẽ ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Yʉ Opʉ, yʉ magʉ̃rẽ bopoñaka! Ĩgʉ̃ ñamasĩrĩrĩ opagʉ ããrĩ́mi. Bʉro ñerõ tarinami. Irasirigʉ peamegue meémejãma, diaguedere meébianokõãmi. ");
INSERT INTO sri_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Irasirigʉ ĩgʉ̃rẽ mʉ buerã pʉrogue ãĩjadabʉ. Ĩgʉ̃sã ĩgʉ̃rẽ taumasĩbirama, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús yʉjʉmi: —Mʉsã dapora marã, yʉre bʉremurĩ opamerã, diayemarẽ neõ pémasĩmerã ããrã. ¿Noópã yoaripoe mʉsã merã ããrĩgʉkuri? ¿Noópã yoaripoe mʉsã yʉre bʉremubirire gũñaturagʉkuri? Majĩgʉ̃rẽ õõ gapʉ ãĩrika! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ĩgʉ̃rẽ ãĩjamakʉ̃, Jesús wãtĩ majĩgʉ̃guere ããrĩgʉ̃́rẽ: “Wirika ĩgʉ̃rẽ!” ãrĩmi. Jesús ĩgʉ̃rẽ béowiumakʉ̃ta, majĩgʉ̃ tariakõãmi. ");
INSERT INTO sri_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pʉrʉ gʉa Jesús buerã gajerã péberogue ĩgʉ̃rẽ sẽrẽñabʉ: —¿Nasirirã gʉa gapʉ wãtĩrẽ béowiumasĩbirayuri? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús yʉjʉmi: —Mʉsã Marĩpʉre mérõgã bʉremurĩ opasĩã, ĩgʉ̃rẽ béowiumasĩbirabʉ. Diayeta mʉsãrẽ werea. Mʉsã bʉremurĩ opari mostaza wãĩkʉri yegãpã irirosũ ããrĩkerepʉrʉ, i buúrure: “Sõõgue waaburo”, ãrĩ masĩbokoa. Mʉsã irasũ ãrĩmakʉ̃, i buúru mʉsã dorerosũta waabokoa. Marĩpʉre bʉremurĩ oparã ããrĩpererire irimasĩa. ");
INSERT INTO sri_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ĩĩno wãtĩrẽ béowiudʉarã, bereri merã Marĩpʉre bʉro sẽrẽrõ gããmea, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pʉrʉ Galilea nikũgue gʉa waagorenabʉ. Irogue Jesús gʉare ãrĩmi: —Masaka yʉre ããrĩpererã tĩ́gʉ̃rẽ ñeã, gajerãguere wiarãkuma. ");
INSERT INTO sri_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ĩgʉ̃sã yʉre wẽjẽrãkuma. Yʉre wẽjẽadero pʉrʉ, ʉrenʉ waaró merã Marĩpʉ yʉre masũgʉkumi, ãrĩmi. “Yʉre wẽjẽrãkuma”, ãrĩmakʉ̃ pérã, gʉa bʉro bʉjawerebʉ. ");
INSERT INTO sri_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pʉrʉ gʉa Jesús merã Capernaugue waabʉ. Irogue ejadero pʉrʉ, Marĩpʉya wiima ããrĩburire niyeru wajaseabosarimasã Pedro pʉro eja, ĩgʉ̃rẽ sẽrẽñama: —¿Mʉsãrẽ buegʉ Marĩpʉya wiima ããrĩburire niyeru wajariri? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro ĩgʉ̃sãrẽ yʉjʉmi: —Wajarimi, ãrĩmi. Pʉrʉ Pedro wiigue ñajãa, Jesúre sẽrẽñaburipoeta Jesús gapʉ ĩgʉ̃rẽ sẽrẽñapʉrorimi: —Simón, ¿naásũ gũñarĩ mʉ? I ʉ̃mʉ marã oparã masakare niyeru wajaseadʉarã, ¿noã gapʉre wajaseakuri? ¿Ĩgʉ̃sãyarãrẽ, o gajero marã ĩgʉ̃sãya nikũgue ejanerã gapʉre wajaseakuri? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Gajero marã gapʉre wajaseakuma, ãrĩ yʉjʉmi Pedro. Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús ãrĩmi: —Irasirigʉ sugʉ opʉ ĩgʉ̃yarãrẽ wajaseabirikumi. ");
INSERT INTO sri_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Marĩpʉyarã marĩ ããrĩkererã, Marĩpʉya wiima ããrĩburire niyeru wajaseabosarãrẽ marĩ merã guamakʉ̃ iribirikoa. Irasirirã wajarirãkoa. Wejerida ãĩ, ditarugue waaí wẽjẽgʉ̃ waaka! Baapʉrorigʉre túwea ãĩka! Ĩgʉ̃ya disigue niyeru tire bokagʉkoa. Pʉrʉ iriti merã marĩ pẽrãyare Marĩpʉya wiima ããrĩburire wajarigʉ waaka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iripoere gʉa Jesús buerã ĩgʉ̃ pʉro eja, sẽrẽñabʉ: —Ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ doreroguere, ¿noã gʉa watopere ããrĩpererã nemorõ ããrĩgʉkuri? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Gʉa irasũ ãrĩmakʉ̃, Jesús majĩgʉ̃rẽ siiu, ĩgʉ̃rẽ gʉa watopegue ãĩnú, ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Diayeta mʉsãrẽ werea. “Majĩgʉ̃ irirosũ ããrã, gajerã nemorõ ããrĩbea”, ãrĩ gũñaka! Mʉsã: “Gajerã nemorõ ããrã”, ãrĩ gũñarĩrẽ gorawayumerã, ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ doreroguere neõ waabirikoa. ");
INSERT INTO sri_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sugʉ ĩgʉ̃ basi: “Yʉ ubu ããrĩgʉ̃́, majĩgʉ̃ irirosũ ããrã”, ãrĩ gũñagʉ̃, Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩũrõ gajerã nemorõ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sugʉ yaagʉre, ĩĩ majĩgʉ̃ irirosũ ããrĩgʉ̃́rẽ õãrõ bokatĩrĩñeãgʉ̃ yʉdere bokatĩrĩñeãmi. ");
INSERT INTO sri_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Sugʉ yʉre bʉremurãrẽ ĩĩ majĩgʉ̃ irirosũ ããrĩrã́rẽ ñerõ irimakʉ̃ irigʉno, bʉro wajamoãsũgʉkumi. Irasiriro ĩgʉ̃ gajerãrẽ ñerõ irimakʉ̃ iriburi dupuyuro masaka ĩgʉ̃rẽ wáriye ʉ̃tãye merã wʉ̃́nugũgue siasiu, wádiyague meéyomakʉ̃ õãbokoa. ");
INSERT INTO sri_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","I ʉ̃mʉguere masakare ñerõ irimakʉ̃ iriri ããrã. Irasirirã ñerõ tarima. I ĩgʉ̃sãrẽ ñerõ irimakʉ̃ iriri ããrĩníkõãrokoa. Gajerãrẽ ñerõ irimakʉ̃ irigʉno gapʉ ñetariro tarigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Irasirirã mʉsãya mojõ, o gubu merã ñerõ irirã, iri mojõrẽ, o iri gubure dititá béorosũ iri ñerõ iririre pirika! Su mojõ, o su gubu opakererã, Marĩpʉ pʉrogue waamakʉ̃ õãtarirokoa. Ñerõ iririre pirimerã gapʉ perebiri peamegue béosũrãkuma. Ĩgʉ̃sã pe mojõ, o pe gubu opakererã, peamegue waamakʉ̃ ñetarirokoa. ");
INSERT INTO sri_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mʉsãya koyeru merã ĩã, ñerõ irirã, irirure goreweabéorosũ iri ñerõ iririre pirika! Su koyeru opakererã, Marĩpʉ pʉrogue waamakʉ̃ õãtarirokoa. Ñerõ iririre pirimerã gapʉ perebiri peamegue béosũrãkuma. Ĩgʉ̃sã pe koyeru opakererã, peamegue waamakʉ̃ ñetarirokoa. ");
INSERT INTO sri_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Neõ sugʉ ĩĩsã majĩrãrẽ ubu ĩãbéobirikõãka! Mʉsãrẽ werea. Ʉ̃mʉgasigue Yʉpʉre wereboerã ĩgʉ̃sãrẽ korerã ĩgʉ̃ merã ããrĩníkõãma, ĩgʉ̃sãrẽ ĩgʉ̃ iritamudorerire irimurã. ");
INSERT INTO sri_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yʉ ããrĩpererã tĩ́gʉ̃ dediribonerãrẽ taugʉ aarigʉ́ iribʉ. ");
INSERT INTO sri_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Yʉ wererire, ¿naásũ gũñarĩ? Ovejare korerimasʉ̃ cien oveja opagʉ, sugʉ oveja dedirimakʉ̃ ĩãgʉ̃, gajerã noventa y nueve ovejare makã tʉro ĩgʉ̃sã baarogue duripíkõã, dediriadire ãmagʉ̃́ waakumi. ");
INSERT INTO sri_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Diayeta mʉsãrẽ werea. Ĩgʉ̃rẽ bokagʉ, gajerã noventa y nueve dediribiranerã nemorõ ĩgʉ̃rẽ ʉsʉyakumi. ");
INSERT INTO sri_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ãsũta Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩĩsã majĩrã irirosũ ããrĩrã́rẽ dedirimakʉ̃ gããmebemi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Irasũ ãrĩ odo, ãsũ ãrĩ werenemomi: —Mʉyagʉ mʉrẽ ñerõ irimakʉ̃, gajerã péberogue ĩgʉ̃ merã irire wereníka! Ĩgʉ̃ irire õãrõ merã ãmudʉagʉ: “Mʉrẽ ñerõ iribʉ! Kãtika yʉ irideare!” ãrĩmakʉ̃, mʉsã dupaturi ʉsʉyari merã gãme wapikʉrãkoa. ");
INSERT INTO sri_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ĩgʉ̃ irire ãmudʉabirimakʉ̃, sugʉ o pẽrãrẽ siiu, dupaturi ĩgʉ̃ pʉro waaka! Ĩgʉ̃sã péurogue ĩgʉ̃ mʉrẽ ñerõ irideare wereka! Irasiriro Marĩpʉya werenírĩ gojadea pũgue dorederosũta pẽrã o ʉrerã iri ñerõ irideare wererire pédero pʉrʉ: “Diayeta irasũ waabʉ”, ãrĩ masĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mʉrẽ ñerõ iridi ĩgʉ̃sã péurogue ãmudʉabirimakʉ̃, ããrĩpererã yʉre bʉremurã merã nerẽ, ĩgʉ̃sãrẽ ĩgʉ̃ ñerõ irideare wereka! Ĩgʉ̃sã péuroguedere ãmudʉabirimakʉ̃ ĩãrã, ĩgʉ̃rẽ: “Marĩpʉre bʉremubi, o romano marã opʉre ñegʉ̃ niyeru wajaseabosarimasʉ̃ irirosũ ããrĩ́mi”, ãrĩ ĩãka! ");
INSERT INTO sri_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Diayeta mʉsãrẽ werea. Mʉsã Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ dorerosũta: “I ʉ̃mʉguere ãsũ waabirikõãburo”, ãrĩmakʉ̃, irire waabirimakʉ̃ irigʉkumi. Mʉsã ĩgʉ̃ dorerosũta: “I ʉ̃mʉguere ãsũ waaburo”, ãrĩmakʉ̃, irire waamakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Gajidere mʉsãrẽ werea. Mʉsã pẽrã sʉrosũ gũñarĩ merã: “Ãsũ Marĩpʉre sẽrẽrã!” ãrĩmakʉ̃, Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ mʉsã sẽrẽrõsũta irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pẽrã, o ʉrerã yʉre bʉremurã nerẽmakʉ̃, yʉde ĩgʉ̃sã watopegue ããrã, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Irasũ ãrĩmakʉ̃ pégʉ, Pedro Jesús pʉro ejanʉgã, ãsũ ãrĩ sẽrẽñami ĩgʉ̃rẽ: —Yʉ Opʉ, ¿diíkʉgora yaagʉ yʉre ĩgʉ̃ ñerõ irimakʉ̃ kãtigʉkuri? ¿Su mojõma pere gaji mojõ peru pẽrẽbejarigora ĩgʉ̃ yʉre ñerõ irimakʉ̃ kãtigʉkuri? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús ĩgʉ̃rẽ yʉjʉmi: —“Su mojõma pere gaji mojõ peru pẽrẽbejarigora ĩgʉ̃ yʉre ñerõ irimakʉ̃ kãtigʉkoa”, ãrĩbirikõãka! Ĩgʉ̃ ñerõ irinarikʉ kãtika! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Irasũ ãrĩ odo, keori merã buemi gʉare Jesús: —Irasiriro Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri ãsũ ããrã. Sugʉ opʉ ĩgʉ̃rẽ moãboerimasãrẽ ĩgʉ̃sã ĩgʉ̃rẽ wajamorĩrẽ wajaridorekumi. ");
INSERT INTO sri_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ĩgʉ̃sã ĩgʉ̃rẽ wajamorĩrẽ ãmunʉgãripoe gajerã ĩgʉ̃yarã sugʉ wáro wajamogʉ̃rẽ ĩgʉ̃ pʉro ãĩakuma. ");
INSERT INTO sri_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ĩgʉ̃ wajamorĩrẽ wajarimasĩbirimakʉ̃ ĩãgʉ̃, ĩgʉ̃ opʉ ĩgʉ̃yarãrẽ: “Ĩgʉ̃rẽ, ĩgʉ̃ marãpore, ĩgʉ̃ pũrãrẽ ĩgʉ̃ opari ããrĩpereri merã gajerãguere duarã waaka!” ãrĩkumi. “Irasirigʉ ĩgʉ̃sãrẽ duari waja merã ĩgʉ̃ yʉre wajamorĩrẽ wajarigʉkumi”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","’Irasũ ãrĩmakʉ̃ pégʉ, wáro wajamogʉ̃ gapʉ ñadʉkʉpuri merã ejamejã, ĩgʉ̃ opʉre bʉro sẽrẽkumi: “Yʉ opʉ, gʉare gajerãguere duabirikõãka! Yúka dapa! Bopoñaka yʉre! Mʉrẽ yʉ wajamorĩ ããrĩpererire wajaripeokõãgʉkoa”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","’Irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃rẽ bopoñarĩ merã ĩã, ĩgʉ̃rẽ wiukumi. “Ĩgʉ̃ wajamodea pereakõãa”, ãrĩ, irire kãtipeokõãkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ĩgʉ̃ irasiriadero pʉrʉ, wáro wajamodi waa, gajigʉ ĩgʉ̃ merãmʉ ĩgʉ̃ opʉre moãboerimasʉ̃rẽ bokajakumi. Ĩgʉ̃ merãmʉ gapʉ ĩgʉ̃rẽ mérõgã wajamokumi. Ĩgʉ̃rẽ bokajagʉ, mata ĩgʉ̃ya wʉ̃́nugũrẽ bʉro ñeã: “Murĩgora, yʉre mʉ wajamorĩrẽ wajaripurumuka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","’Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃ merãmʉ gapʉ ñadʉkʉpuri merã ejamejã, ĩgʉ̃rẽ bʉro sẽrẽkumi: “Yúka dapa! Bopoñaka yʉre! Mʉrẽ yʉ wajamorĩ ããrĩpererire wajaripeokõãgʉkoa”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ĩgʉ̃ bʉro sẽrẽmakʉ̃ pékeregʉ, ĩgʉ̃rẽ yʉjʉbirikumi. Irasirigʉ ĩgʉ̃rẽ peresugue iridorekumi. “Yʉre ĩgʉ̃ wajamorĩrẽ wajaripeomakʉ̃gue wiuka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","’Wáro wajamodi ĩgʉ̃rẽ mérõgã wajamogʉ̃rẽ irasirimakʉ̃ ĩãrã, gajerã moãboerimasã bʉro bʉjawereri merã ĩgʉ̃ iriadea ããrĩpererire ĩgʉ̃sã opʉre wererã waakuma. ");
INSERT INTO sri_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Irire pégʉ, ĩgʉ̃sã opʉ wáro wajamodire siiu, ãsũ ãrĩkumi: “Mʉ ñetaria. Mʉ yʉre bʉro sẽrẽmakʉ̃, mʉ yʉre wajamodeare kãtipeokõãbʉ. ");
INSERT INTO sri_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yʉ irasirikerepʉrʉ, mʉ gapʉ mʉ merãmʉrẽ ĩgʉ̃ mʉrẽ mérõgã wajamodeare kãtibirayuro. Mʉ yʉre wajamodeare yʉ kãtiderosũta ĩgʉ̃ mʉrẽ wajamodeadere mʉ kãtimakʉ̃ õãtariboakuyo. ¿Nasirigʉ ĩgʉ̃rẽ bopoñabirari mʉ?” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","’Irasũ ãrĩ odo, ĩgʉ̃ merã bʉro guagʉ, ĩgʉ̃rẽ peresu irikumi bʉro wajamoãdoregʉ. Ĩgʉ̃ wajamorĩrẽ wajaripeobi neõ wiribirikumi, ãrĩ weremi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pʉrʉ ãsũ ãrĩnemomi: —Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ mʉsãrẽ irasũta wajamoãgʉkumi, mʉsãyarã ĩgʉ̃sã mʉsãrẽ ñerõ irideare mʉsã õãrõ merã kãtibirimakʉ̃, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús irire wereadero pʉrʉ, Galilea nikũgue ããrãdi gʉa ĩgʉ̃ buerã merã Judea nikũgue waa, dia Jordán wãĩkʉdiya gaji koepʉgue waami. ");
INSERT INTO sri_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Irogue waamakʉ̃ ĩãrã, wárã masaka ĩgʉ̃rẽ tʉyama. Irasirigʉ irogue pũrĩrikʉrãrẽ taumi. ");
INSERT INTO sri_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Irasirimakʉ̃ ĩãrã, surãyeri fariseo bumarã Jesús pʉro eja, ĩgʉ̃rẽ ñerĩ ĩgʉ̃ werenímakʉ̃ iridʉarã, sẽrẽñama: —¿Sugʉ masakʉ ĩgʉ̃ gããmerõ ĩgʉ̃ marãpore béomakʉ̃, marĩ doreri ããrĩkuri? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús ĩgʉ̃sãrẽ yʉjʉmi. —¿Marĩpʉya werenírĩ gojadea pũrẽ buebiriri mʉsã? Ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Neõgoraguere Marĩpʉ i ʉ̃mʉrẽ irigʉ, ʉ̃mʉ́ʉ, nomeõ iridi ããrĩmí”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ãsũ ãrĩ gojanemosũdero ããrĩbʉ́ doja: “Sugʉ ʉ̃mʉ́ʉ ĩgʉ̃ pagʉsãmarãrẽ wiri, ĩgʉ̃ marãpo merã ããrĩgʉkumi. Irasirirã ĩgʉ̃sã pẽrã ããrĩkererã, Marĩpʉ ĩũrõ su dupʉta irirosũ ããrĩrãkuma”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Irasirirã pẽrã irirosũ ããrĩbema. Su dupʉta irirosũ ããrĩ́ma. Marĩpʉ ĩgʉ̃sãrẽ su dupʉta irirosũ ããrĩmakʉ̃ iridero pʉrʉ, gajigʉ ĩgʉ̃sãrẽ gãme béomakʉ̃ iribirikõãrõ gããmea, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, fariseo bumarã sẽrẽñama doja: —Mʉ irasũ ãrĩkerepʉrʉ, Moisés gapʉ ãsũ ãrĩ gojadi ããrĩmí: “Sugʉ ĩgʉ̃ marãpore béodʉagʉ: ‘I waja merã mʉrẽ béoa’, ãrĩ gojari pũrẽ sĩrõ gããmea”, ãrĩ gojadi ããrĩmí. ¿Nasirigʉ irasũ ãrĩ gojayuri? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Mʉsã ñekʉ̃sãmarã Marĩpʉ dorerire iridʉabirimakʉ̃ ĩãgʉ̃: “Mʉsã marãposã nomerẽ béomasĩa”, ãrĩ gojadi ããrĩmí Moisés. Ĩgʉ̃ irasũ ãrĩ gojakerepʉrʉ, neõgoragueta Marĩpʉ mʉsã marãposã nomerẽ béomakʉ̃ gããmebiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mʉsãrẽ werea. Sugo marãpʉkʉgo gajigʉ merã ñerõ iribirikerepʉrʉ, igo marãpʉ gapʉ igore béo, gajegore marãpokʉgʉ, igo merã ñerõ irigʉ yámi. Gajigʉ béodeore marãpokʉgʉde igo merã ñerõ irigʉ yámi, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa ĩgʉ̃ buerã ãrĩbʉ: —Ĩgʉ̃sã marãposã nomerẽ béo, gajego merã ããrĩmakʉ̃ õãbea. Irasirirã marãpo marĩmakʉ̃ õãbokoa, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús gʉare yʉjʉmi: —Ããrĩpererã masaka marãpo, o marãpʉ marĩrãta ããrĩbokatĩũbirikuma. Marĩpʉ marãpokʉdorebirinerã, o marãpʉkʉdorebirinerã dita bokatĩũmasĩma. ");
INSERT INTO sri_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Surãyeri ʉ̃ma marãpokʉmasĩbema. Ĩgʉ̃sã watopegue surãyeri ʉ̃ma deyoarãgueta poyarimasã ããrĩnerã nomerẽ marãpokʉmasĩbema. Masaka gajerã ʉ̃marẽ marãpokʉmasĩbirimakʉ̃ yáma. Gajerã ʉ̃ma, Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doregʉya direta iridʉarã marãpokʉbema. Irasirirã marãpo, o marãpʉ marĩrã ããrĩbokatĩũdʉarã, ãsũta ããrĩníkõãburo, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pʉrʉ masaka majĩrãrẽ Jesús pʉro ãĩjama, ĩgʉ̃sãrẽ ñapeo, Marĩpʉre ĩgʉ̃sãya ããrĩburire sẽrẽbosadorerã. Ĩgʉ̃sã ãĩjamakʉ̃ ĩãrã, gʉa ĩgʉ̃ buerã ĩgʉ̃sãrẽ bokatĩrĩ: “Ĩgʉ̃rẽ garibobirikõãka!” ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús gapʉ gʉare ãrĩmi: —Majĩrã yʉ pʉrogue aariburo. Kãmutabirikõãka ĩgʉ̃sãrẽ! Ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ããrĩmurã, ĩĩsã majĩrã yʉre ʉsʉyari merã bokatĩrĩñeãrã irirosũ ããrĩ́ma, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Irasirigʉ majĩrãrẽ ñapeo, Marĩpʉre ĩgʉ̃sãya ããrĩburire sẽrẽbosa odo, gajerogue waakõãmi doja. ");
INSERT INTO sri_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pʉrʉ sugʉ maamʉ Jesús pʉrogue eja, ĩgʉ̃rẽ sẽrẽñami: —Õãgʉ̃ buegʉ, yʉ ʉ̃mʉgasigue perebiri okari opadʉagʉ, ¿ñeéno õãrĩrẽ irigʉkuri? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús ĩgʉ̃rẽ ãrĩmi: —¿Nasirigʉ yʉre: “Õãgʉ̃ ããrã”, ãrĩrĩ? Marĩpʉ sugʉta õãgʉ̃ ããrĩ́mi. Mʉ ʉ̃mʉgasigue perebiri okari opadʉagʉ, Marĩpʉ dorerire irika! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, maamʉ ãsũ ãrĩ sẽrẽñami doja: —¿Dií gapʉre irigʉkuri? ãrĩmi. Jesús ĩgʉ̃rẽ yʉjʉmi: —Masakare wẽjẽbirikõãka! Gajigʉ marãpo merã ñerõ iribirikõãka! Yajabirikõãka! Gajerãyamarẽ ãrĩgatori merã werebirikõãka! ");
INSERT INTO sri_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉpʉ, mʉpore goepeyari merã bʉremuka! Mʉ basi maĩrõsũta mʉ pʉro ããrĩrã́rẽ maĩka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ĩgʉ̃ irasũ ãrĩmakʉ̃, maamʉ Jesúre ãrĩmi doja: —Iri doreri ããrĩpererire majĩgʉ̃gueta neõ tarinʉgãbiribʉ yʉ. ¿Ñeéno dʉyari, yʉre yʉ irinemoburi? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús ĩgʉ̃rẽ ãrĩmi: —Mʉ, Marĩpʉ ĩũrõ ĩgʉ̃ dorerire iripeodʉagʉ, mʉ oparire duagʉ waaka! Mʉ duadea wajare boporãrẽ sĩka! Irasirigʉ ʉ̃mʉgasiguere wári õãrĩ opagʉkoa. Irasiri odo, yʉ merã aarika! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, maamʉ ĩgʉ̃ wári oparire maĩsĩã, bʉro bʉjawereri merã waakõãmi. ");
INSERT INTO sri_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ĩgʉ̃ bʉjawereri merã waamakʉ̃ ĩãgʉ̃, Jesús gʉare ĩgʉ̃ buerãrẽ ãrĩmi: —Diayeta mʉsãrẽ werea. Wári doebiri oparãrẽ Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreroguere waamakʉ̃ diasagoráa. ");
INSERT INTO sri_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mʉsãrẽ dupaturi werea. Camellu awiru gobegãrẽ ñajãtariweremasĩbirikumi. I nemorõ wári doebiri opagʉre Marĩpʉ ĩgʉ̃yarãrẽ doreroguere waamakʉ̃ diasáa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa ĩgʉ̃ buerã pégʉka, ãsũ ãrĩ gãme sẽrẽñabʉ: —Iro merẽ, ¿noã gapʉ Marĩpʉ tausũmurã ĩgʉ̃ pʉrogue waamurã ããrĩbokuri? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús gʉare ĩã, ãrĩmi: —Masaka ĩgʉ̃sã basi ĩgʉ̃sã iriri merã Marĩpʉ pʉrogue waamasĩbema. Marĩpʉ dita masakare ĩgʉ̃ pʉro ããrĩmurã waamakʉ̃ irimasĩmi. Ããrĩpererire irimasĩmi, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ĩgʉ̃rẽ ãrĩmi: —Gʉa Opʉ, gʉa mʉrẽ tʉyarã, ããrĩpereri gʉa opadeare pípeokõãbʉ. Irasirirã gʉa gapʉ, ¿ñeénorẽ oparãkuri? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús gʉare ãsũ ãrĩ yʉjʉmi: —Diayeta mʉsãrẽ werea. I ʉ̃mʉ peredero pʉrʉ ããrĩpereri maama gorawayuripoe yʉ ããrĩpererã tĩ́gʉ̃ ʉ̃mʉgasi gosewasirirogue Opʉ doarogue doagʉkoa. Yʉ iro doamakʉ̃, mʉsãde yʉre tʉyarã, pe mojõma pere su gubu peru pẽrẽbejari oparã doarigue doarãkoa. Irasirirã mʉsã Israel bumarãrẽ pe mojõma pere su gubu peru pẽrẽbejari buri marãrẽ dorerãkoa. ");
INSERT INTO sri_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yʉ merã waarã́, ĩgʉ̃sãya wiirire, ĩgʉ̃sã pagʉpũrãrẽ, pagʉsãmarãrẽ, pũrãrẽ, ĩgʉ̃sãya pooerire pípeorã, wári õãrĩ wajatarãkuma. Ĩgʉ̃sã iro dupuyuro opaderosũ cien nemorõ opanemorãkuma. Irasũ ããrĩmakʉ̃ Marĩpʉ merã perebiri okari oparãkuma. ");
INSERT INTO sri_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wárã daporare oparã ããrĩrã́, pʉrʉguere ubu ããrĩrã́ dujarãkuma. Wárã daporare ubu ããrĩrã́ gapʉ, pʉrʉguere oparã ããrĩrãkuma, ãrĩ weremi Jesús gʉare ĩgʉ̃ buerãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Irasirigʉ dupaturi Jesús keori merã buemi doja: —Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri ãsũ ããrã. Sugʉ igui pooe opʉ boyodujimejãripoe ĩgʉ̃ya pooere moãmurãrẽ siiugʉ waakumi. Ãsũ ãrĩkumi: ");
INSERT INTO sri_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Sunʉ moãrĩ waja suti niyeru ti wajarigʉra”, ãrĩkumi ĩgʉ̃sãrẽ. Pʉrʉ ĩgʉ̃sãrẽ ĩgʉ̃ya pooegue moãdoregʉ iriukumi. ");
INSERT INTO sri_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pʉrʉ goeripoe dupuyuro nueve hora ããrĩmakʉ̃, makã dekogue waa, gajerã moãrĩ opamerãrẽ bokajakumi. ");
INSERT INTO sri_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ĩgʉ̃sãrẽ bokaja, ãrĩkumi: “Mʉsãde yaa pooere moãrã waaka! Keoro wajarigʉra”, ãrĩkumi. Irasirirã ĩgʉ̃ya pooegue moãrã waakuma. ");
INSERT INTO sri_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pʉrʉ pooe opʉ goeripoe ããrĩmakʉ̃, ñamika tres hora ããrĩmakʉ̃dere gajerãrẽ moãdorekumi doja. ");
INSERT INTO sri_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pʉrʉ ñamikague cinco hora ããrĩmakʉ̃, makã dekogue waakumi doja. Irogue eja, gajerã moãrĩ opamerãrẽ bokaja, ĩgʉ̃sãrẽ sẽrẽñakumi: “¿Nasirirã dapagãrẽ moãbirikererã doaneãkõãrĩ mʉsã?” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Neõ sugʉ gʉare: ‘Moãrã waaka!’ ãrĩbirami”, ãrĩ yʉjʉkuma. Irasirigʉ pooe opʉ ĩgʉ̃sãrẽ: “Mʉsãde yaa pooere moãrã waaka! Keoro wajarigʉra”, ãrĩkumi. Irasirirã ĩgʉ̃sãde ĩgʉ̃ya pooere moãrã waakuma. ");
INSERT INTO sri_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Abe ñajãripoegue ããrĩmakʉ̃, pooe opʉ ĩgʉ̃ya pooere siiu moãgʉ̃rẽ ãsũ ãrĩkumi: “Moãrãrẽ siiu, moãrã ejatũnunerãrẽ wajaripʉrori, ĩgʉ̃sã ejaburi dupuyuro ejanerãrẽ wajari odo, ejapʉrorianerãrẽ wajaritũnuka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Irasirigʉ, cinco hora ããrĩmakʉ̃ moãnʉgãnerãrẽ sunʉ moãrĩ wajataropã suti niyeru ti wajarikumi. ");
INSERT INTO sri_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ĩgʉ̃ irasũ wajarimakʉ̃ ĩãrã, moãpʉrorianerã: “Gʉa gapʉre ĩgʉ̃sã nemorõ wajarigʉkumi”, ãrĩ gũñadikuma. Ĩgʉ̃sãdere sʉrosũta wajarikõãkumi. ");
INSERT INTO sri_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Irasũ wajarimakʉ̃ ĩãrã, pooe opʉ merã gua, ĩgʉ̃rẽ ãrĩkuma: ");
INSERT INTO sri_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ĩĩsã gʉa pʉrʉgue ejanerã gapʉ su horata moãama. Gʉa gapʉ sunʉ õãrõ moãneãkõãbʉ. Bʉro abe asiripoe moãbʉ. Gʉa irasũ moãneãkerepʉrʉ, sʉrosũ wajarikõãbʉ mʉ”, ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, pooe opʉ gapʉ sugʉ ĩgʉ̃sã watope ããrĩgʉ̃́rẽ ãrĩkumi: “Yʉ merãmʉ, yʉ mʉrẽ ñerõ irigʉ meta yáa. Yʉ mʉrẽ: ‘Suti niyeru ti wajarigʉra’, ãrĩmakʉ̃ pégʉ: ‘Jáʉ’, ãrãbʉ mʉ. Irasirigʉ yʉ ãrãderosũta mʉrẽ keoro wajariabʉ. ");
INSERT INTO sri_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Irasirigʉ yʉ wajariadeare ãĩ, waakõãka! Ĩĩrẽ mʉ pʉrʉgue ejadidere mʉrẽ wajariaderopãta wajarigʉra. ");
INSERT INTO sri_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","I yaa niyeru ããrã. Irasirigʉ yʉ gããmerõ wajarimasĩa. Gajerãrẽ yʉ õãrõ sĩmakʉ̃ ĩãgʉ̃, ¿yʉre ĩãturiri mʉ?” ãrĩkumi pooe opʉ. ");
INSERT INTO sri_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’I keori ãrĩrõsũta Marĩpʉ ĩgʉ̃yarã ããrĩpʉrorinerãrẽ, ĩgʉ̃sã pʉrʉ ĩgʉ̃yarã ããrĩrã́dere sʉrosũ õãrĩrẽ sĩgʉkumi, ãrĩ weremi Jesús gʉare. ");
INSERT INTO sri_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús Jerusalén waarí maague waagʉ́, gʉare pe mojõma pere su gubu peru pẽrẽbejarã ĩgʉ̃ buerãrẽ gajerã péberogue siiuwãgã, ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Õãrõ péka! Marĩ Jerusalẽ́gue waarã́ yáa. Irogue yʉ ããrĩpererã tĩ́gʉ̃, paía oparãguere, irasũ ããrĩmakʉ̃ Moisés gojadea buerimasãguere wiasũgʉkoa. Ĩgʉ̃sã yʉre: “Boaburo”, ãrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Irasirirã judío masaka ããrĩmerãguere yʉre wiarãkuma. Ĩgʉ̃sã yʉre bʉrida, tãrã, curusague pábiatú wẽjẽrãkuma. Ĩgʉ̃sã yʉre wẽjẽadero pʉrʉ, ʉrenʉ waaró merã masãgʉkoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pʉrʉ Zebedeo marãpo igo pũrã Santiago, Juan merã Jesús pʉrogue eja, ĩgʉ̃rẽ sẽrẽbo ñadʉkʉpuri merã ejamejãmo. ");
INSERT INTO sri_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Igo irasirimakʉ̃, Jesús igore sẽrẽñami: —¿Ñeénorẽ gããmerĩ mʉ? ãrĩmi. Igo ĩgʉ̃rẽ yʉjʉmo: —Mʉ, Opʉ ñajãgʉ̃, ĩĩsã yʉ pũrã pẽrãrẽ mʉ merã doremurã sóoka! Sugʉre mʉ diaye gapʉ, gajigʉre kúgapʉ doadoreka! ãrĩmo Jesúre. ");
INSERT INTO sri_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Igo irasũ ãrĩmakʉ̃ pégʉ, Jesús igo pũrãrẽ ãrĩmi: —Mʉsã yʉre sẽrẽrĩrẽ pémasĩbea. Yʉ bʉro ñerõ tarigʉkoa. ¿Yʉ ñerõ tarirosũ mʉsãde ñerõ tarirã, bokatĩũrãkuri? ãrĩmi. Ĩgʉ̃sã yʉjʉma: —Bokatĩũkõãrãkoa, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Diayeta ããrã. Yʉ irirosũ mʉsãde ñerõ tarirãkoa. Yʉ gapʉ mʉsãrẽ yʉ diaye, kúgapʉ doamurãrẽ beyemasĩbea. Yʉpʉ ãmusiadi ããrĩmí irire. Irasirirã ĩgʉ̃ beyenerã dita yʉ diaye, kúgapʉ doarãkuma, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Gʉa pe mojõmarã ĩgʉ̃ buerã gapʉ Santiago, Juan ĩgʉ̃sã Jesúre sẽrẽrĩrẽ pérã, ĩgʉ̃sã merã guabʉ. ");
INSERT INTO sri_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gʉa guamakʉ̃ ĩãgʉ̃, Jesús ããrĩpererãrẽ gʉare siiu neeõ, ãsũ ãrĩ weremi: —I nikũ marã oparã Marĩpʉre bʉremumerã gapʉ ĩgʉ̃sãyarãrẽ dorerã, turaro merã dorema. Ĩgʉ̃sã doka marãde irasũta dorema. Irire masĩa mʉsã. ");
INSERT INTO sri_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉsã tamerã ĩgʉ̃sã irirosũ iribirikoa. Mʉsã watopeguere opʉ ããrĩdʉagʉ, mʉsãrẽ moãboegʉ irirosũ ããrĩburo. ");
INSERT INTO sri_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sugʉ mʉsã watopegue ããrĩgʉ̃́, gajerã nemorõ ããrĩdʉagʉ, moãboegʉ irirosũ ããrĩburo. ");
INSERT INTO sri_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yʉde irasũta ããrã. Yʉ ããrĩpererã tĩ́gʉ̃ masaka yʉre iritamuburo, ãrĩgʉ̃ meta aaribʉ́. Yʉ gapʉ ĩgʉ̃sãrẽ iritamugʉ̃ aaribʉ́. Irasirigʉ wárã masakare yʉ boari merã ĩgʉ̃sã ñerõ iridea wajare wajaribosagʉ aarigʉ́ iribʉ, ãrĩmi Jesús gʉare. ");
INSERT INTO sri_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pʉrʉ Jericógue ããrãnerã gʉa wirimakʉ̃, wárã masaka Jesúre tʉyama. ");
INSERT INTO sri_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Gʉa waarí maa tʉro, pẽrã koye ĩãmerã doama. Jesús iro tariwãgãrĩrẽ péñarã ãsũ ãrĩ gainíma: —Gʉa Opʉ, David parãmi ããrĩturiagʉ, gʉare bopoñaka! ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ĩgʉ̃sã irasũ ãrĩ gainímakʉ̃, masaka gapʉ ĩgʉ̃sãrẽ: “Toeaka!” ãrĩma. Ĩgʉ̃sã irasũ ãrĩkerepʉrʉ, ĩgʉ̃sã gainíadero nemorõ gainínemoma: —Gʉa Opʉ, David parãmi ããrĩturiagʉ, gʉare bopoñaka! ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pé, Jesús dujanʉgãja, ĩgʉ̃sãrẽ siiu, ãsũ ãrĩ sẽrẽñami: —¿Ñeénorẽ yʉ mʉsãrẽ irimakʉ̃ gããmerĩ? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Gʉa Opʉ, gʉare koye ĩãmakʉ̃ irika! ãrĩ yʉjʉma. ");
INSERT INTO sri_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃sãrẽ bopoña, ĩgʉ̃sãya koyere moãñami. Ĩgʉ̃ moãñamakʉ̃ta, ĩãkõãma. Irasirirã Jesúre tʉyama. ");
INSERT INTO sri_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Gʉa Jesús merã Jerusalẽ́gue ejaburo dupuyuro Betfagé wãĩkʉri makãgue ejapʉroribʉ. Betfagé, buúru Olivos wãĩkʉri buúru pʉro ããrĩbʉ́. Jesús irogue ejagʉ, gʉa merãmarã pẽrãrẽ ");
INSERT INTO sri_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ãsũ ãrĩ iriumi: —Si makã marĩ bokatĩũrõ ããrĩrĩ́ makãgue waaka! Irogue ejarã, burra ĩgʉ̃sã sianúadeore majĩgʉ̃ merã bokajarãkoa. Ĩgʉ̃sãrẽ bokajarã, ĩgʉ̃sã siadeadare kura, ãĩrika! ");
INSERT INTO sri_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mʉsãrẽ: “¿Nasirimurã ĩgʉ̃sãrẽ kurari?” ãrĩmakʉ̃ pérã: “Marĩ Opʉ gããmeami. Dapora wiagʉkumi doja”, ãrĩka! ãrĩ iriumi. ");
INSERT INTO sri_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ire irasũ irigʉ, Marĩpʉya kerere weredupuyudi gojaderosũta irimi. Ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén marãrẽ ãsũ ãrĩ wereka: “Mʉsã Sión marã ĩãka! Mʉsã Opʉ mʉsã pʉrogue mʉsãrẽ iritamugʉ̃ aarími. Ubu ããrĩgʉ̃́ irirosũ burra majĩgʉ̃ weka peyawãgãrimi”, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Irasirirã Jesús iriuanerã iri makãgue waa, ĩgʉ̃ iridoreaderosũta iriñurã. ");
INSERT INTO sri_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burrore, pago merã Jesús pʉrogue ãĩjamakʉ̃, gʉaya surí wekamarẽ túwea, ĩgʉ̃sã weka peobʉ. Gʉa irasiriadero pʉrʉ, Jesús, majĩgʉ̃ wekague mʉrĩbejami. ");
INSERT INTO sri_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mʉrĩbeja, Jesús Jerusalẽ́gue peyawãgãmakʉ̃ ĩãrã, masaka wárã ĩgʉ̃sãya weka sãñarĩ suríre túwea ãĩ, ĩgʉ̃ waarí maarẽ́ sẽõpídupuyuma ĩgʉ̃rẽ bʉremurã. Irasũ ããrĩmakʉ̃, gajerã yuku dʉpʉri pũrikʉrire diti ãĩ, maarẽ́ pídupuyuma, ĩgʉ̃ waarí maa õãrĩ maa ããrĩburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Irasirirã ĩgʉ̃ dupuyuro waarã́, ĩgʉ̃ pʉrʉ tʉyarã ãsũ ãrĩ gainíma: —Opʉ David parãmi ããrĩturiagʉre ʉsʉyari sĩrã! Ĩĩ Marĩpʉ marĩrẽ taugʉ iriudi õãrõ aariburo. Marĩpʉre: “Õãtaria mʉ ããrĩpererã Opʉ ʉ̃mʉgasigue ããrĩgʉ̃́”, ãrĩ, ʉsʉyari sĩrã! ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalẽ́gue ejamakʉ̃, irogue ããrĩrã́ ĩãgʉkapereakõãma. Wárã ĩgʉ̃sã basi ãsũ ãrĩ gãme sẽrẽñama: —¿Noã ããrĩ́rĩ ĩĩ? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Gajerã masaka yʉjʉma ĩgʉ̃sãrẽ: —Ĩĩ Marĩpʉya kerere weregʉ Jesús wãĩkʉgʉ ããrĩ́mi. Galilea nikũma makã Nazaretmʉ ããrĩ́mi, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pʉrʉ Jesús Marĩpʉya wiigue ñajãmi. Ñajãa, doebiri duarãrẽ, ĩgʉ̃sã duarire wajarirãdere bokajagʉ, ĩgʉ̃sãrẽ béowiumi. Niyeru gorawayurimasãya niyeru sãñarĩ kũmarĩrẽ yomeéwiunokõãmi. Bujare dua doanírãya doaripẽrĩdere irasũta irimi. ");
INSERT INTO sri_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ĩgʉ̃sãrẽ ãsũ ãrĩmi: —Marĩpʉ ĩgʉ̃ya werenírĩ gojadea pũgue ãsũ ãrĩdi ããrĩmí: “Yaa wii, yʉre bʉremurã yʉre sẽrẽrĩ wii ããrã”, ãrĩdi ããrĩmí. Mʉsã gapʉ yajarimasãya wii irirosũ ããrĩmakʉ̃ yáa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús Marĩpʉya wiigue ããrĩripoe koye ĩãmerã, waamasĩmerãde ĩgʉ̃ pʉrogue ejama. Ĩgʉ̃sã ejamakʉ̃ ĩãgʉ̃, ĩgʉ̃sãrẽ taumi. ");
INSERT INTO sri_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Paía oparã, Moisés gojadeare buerimasã gapʉ ĩgʉ̃ turari merã iri ĩmumakʉ̃ ĩãrã, iri wiigue majĩrã ĩgʉ̃rẽ: “Opʉ David parãmi ããrĩturiagʉ õãtaria mʉ”, ãrĩ gainímakʉ̃ pérã, ĩgʉ̃ merã guama. ");
INSERT INTO sri_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Irasirirã Jesúre ãsũ ãrĩma: —¿Ĩĩsã majĩrã ãrĩrĩrẽ péri mʉ? ãrĩma. Jesús yʉjʉmi: —Péa. ¿Marĩpʉya werenírĩ gojadea pũrẽ ire buebiriri mʉsã? Ãsũ ãrĩ gojasũdero ããrĩbʉ́: Mʉ majĩrãrẽ, mirĩrãgãrẽ õãrõ ʉsʉyari merã mʉrẽ bayapeomakʉ̃ iribʉ, ãrĩ gojasũdero ããrĩbʉ́, ãrĩmi Jesús ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Irasũ ãrĩ odo, ĩgʉ̃sãrẽ béowãgã, Betania wãĩkʉri makãgue waakõãmi. Irogue eja, kãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gajinʉ boyoripoe Jesús Jerusalẽ́gue goedujáagʉ, ʉaboakõãmi. ");
INSERT INTO sri_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Irasũ ʉaboagʉ, maa tʉro nídi higuera wãĩkʉdire ĩãgʉ̃, irigʉ dʉkare ãmagʉ̃́ waadimi. Dʉka marĩbʉ irigʉ gapʉ. Pũrĩ dita ããrĩbʉ́. Dʉka marĩmakʉ̃ ĩãgʉ̃, Jesús ãsũ ãrĩmi: —Igʉ yukʉ neõ dupaturi dʉkakʉbirikoa, ãrĩmi. Ĩgʉ̃ irasũ ãrĩrĩ merãta, irigʉ ñaĩnʉgãkõãbʉ. ");
INSERT INTO sri_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Irigʉ irasũ waamakʉ̃ ĩãrã, gʉa ĩgʉ̃ buerã ĩãgʉkakõãbʉ. —¿Nasiriro mata irigʉ ñaĩakõãrĩ? ãrĩ sẽrẽñabʉ Jesúre. ");
INSERT INTO sri_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús gʉare yʉjʉmi: —Diayeta mʉsãrẽ werea. Mʉsã: “Marĩpʉ ãsũ irimasĩbirikumi”, ãrĩ gũñarõ marĩrõ ĩgʉ̃rẽ bʉremurã, yʉ irigʉre ñaĩmakʉ̃ iriaderosũ mʉsãde irimasĩrãkoa. Irigʉre yʉ iriadero nemorõ diasarire irimasĩrãkoa. Irasirirã Marĩpʉre: “I buúrure dia wádiyague béoka!” ãrĩmakʉ̃, mʉsã ãrĩrõsũta waarokoa. ");
INSERT INTO sri_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mʉsã Marĩpʉre bʉremurĩ merã sẽrẽmakʉ̃, mʉsã sẽrẽrõsũta Marĩpʉ mʉsãrẽ irigʉkumi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pʉrʉ Jesús Marĩpʉya wiigue ñajãmi. Ĩgʉ̃ irogue bueripoe paía oparã, gajerã judío masaka mʉrã ĩgʉ̃ pʉrogue waa, ĩgʉ̃rẽ sẽrẽñama: —¿Noã mʉrẽ doreri, mʉ irire irasirimakʉ̃? ¿Noã mʉrẽ: “Ãsũ irika!” ãrĩrĩ? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Yʉde mʉsãrẽ sẽrẽñagʉra. Mʉsã yʉjʉmakʉ̃, yʉde mʉsãrẽ yʉjʉgʉra. ");
INSERT INTO sri_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juan masakare deko merã wãĩyemakʉ̃, ¿noã ĩgʉ̃rẽ wãĩyedoregʉ iriuri, Marĩpʉ, o masaka? ãrĩmi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníma: —¿Naásũ ãrĩ yʉjʉrãkuri marĩ? “Marĩpʉ Juãrẽ doredi ããrĩmí”, marĩ ãrĩmakʉ̃, Jesús marĩrẽ: “¿Nasirirã ĩgʉ̃ weredeare bʉremubiriri mʉsã?” ãrĩbokumi. ");
INSERT INTO sri_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ããrĩpererã masaka: “Juan Marĩpʉya kerere weredupuyudi ããrĩmí”, ãrĩ gũñama. Marĩ: “Masaka Juãrẽ wãĩyedorenerã ããrĩmá”, ãrĩmakʉ̃, masaka marĩ merã guabokuma, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Irasirirã Jesúre ãsũ ãrĩ yʉjʉma: —Juãrẽ wãĩyedoredire gʉa masĩbea, ãrĩma. Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃sãrẽ ãrĩmi: —Mʉsã yʉre: “¿Noã mʉrẽ irire iridoreri?” ãrĩ sẽrẽñadeare yʉde mʉsãrẽ yʉjʉbea, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús irasũ ãrĩ odo, ĩgʉ̃sãrẽ keori merã buemi: —¿Naásũ ãrĩ gũñarĩ, yʉ ãsũ ãrĩ weremakʉ̃ pérã? Sugʉ pẽrã pũrã opakumi. Sugʉre ãsũ ãrĩkumi: “Makʉ, igui otedea pooegue moãgʉ̃ waaka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Waabea”, ãrĩ yʉjʉkumi. Pʉrʉ: “Waagʉra”, ãrĩ gũña, pooegue moãgʉ̃ waakumi. ");
INSERT INTO sri_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pʉrʉ ĩgʉ̃sã pagʉ gajigʉ ĩgʉ̃ magʉ̃ pʉro waakumi. Ĩgʉ̃ ãrãderosũta ĩgʉ̃dere: “Pooegue moãgʉ̃ waaka!” ãrĩkumi. Ĩgʉ̃: “Jáʉ”, ãrĩkeregʉ, waabirikumi. ");
INSERT INTO sri_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Nií gapʉ pagʉ dorerire iriyuri? ãrĩ sẽrẽñami Jesús. —Ĩgʉ̃ moãdorepʉroriadi gapʉ iriyupʉ, ãrĩ yʉjʉma. Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús ãrĩmi: —Mʉsãrẽ diayeta werea. Mʉsã romano marã opʉre niyeru wajaseabosarimasãrẽ, ʉ̃ma merã gãmebira wajatarimasã nomerẽ: “Ñerã ããrĩ́ma”, ãrĩkerepʉrʉ, ĩgʉ̃sã gapʉ mʉsã nemorõ Marĩpʉ ĩgʉ̃yarãrẽ doreroguere waarãkuma. ");
INSERT INTO sri_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan masakare wãĩyedi mʉsãrẽ: “Ãsũ irika, Marĩpʉ dorerire irirã!” ãrĩ buegʉ aarikerepʉrʉ, mʉsã ĩgʉ̃ buerire neõ bʉremubiribʉ. Ĩĩsã romano marã opʉre niyeru wajaseabosarimasã, ʉ̃ma merã gãmebira wajatarimasã nome gapʉ ĩgʉ̃ buerire pérã, irire bʉremuma. Ĩgʉ̃sã irasirimakʉ̃ ĩãkererã, mʉsã gapʉ mʉsã ñerõ iririre bʉjawere, mʉsã gũñarĩrẽ neõ gorawayubiribʉ. Ĩgʉ̃ buerire neõ bʉremubiribʉ, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús dupaturi ãsũ ãrĩ werenemomi: —Gaji keori merã yʉ weremakʉ̃ péka doja! Sugʉ masakʉ ĩgʉ̃ya nikũrẽ pooe opakumi. Iri pooere iguidarire otekumi. Ote odo, iri pooe tʉrore sãrĩsãkõãkumi. Iro ʉ̃tãyegue igui kʉrabipiri gobere irikumi. Wii ʉ̃marĩ wiigãrẽ irikumi, iri pooere korerã õãrõ ĩã koreburo, ãrĩgʉ̃. Irasiri odo, gajerãrẽ iri pooere wayukumi. “Yaa oteri dʉkare deko merã sĩrãkoa, yʉ mʉsãrẽ iri pooere wayuri waja”, ãrĩkumi. Irasũ ãrĩ odo, gajerogue waakõãkumi. ");
INSERT INTO sri_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pʉrʉ igui ñíripoe ejamakʉ̃, ĩgʉ̃rẽ moãboerãrẽ ĩgʉ̃ya pooere moãrã pʉrogue ĩgʉ̃ya oteri dʉkare deko merã sẽrẽdoregʉ iriukumi. ");
INSERT INTO sri_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Iri pooere moãrã gapʉ ĩgʉ̃ iriuanerã irogue ejamakʉ̃ ĩãrã, ĩgʉ̃sãrẽ ñerõ irikuma. Sugʉre bʉro pá, gajigʉre wẽjẽ, gajigʉre ʉ̃tãyeri merã deakuma. ");
INSERT INTO sri_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ĩgʉ̃sã irasiriadeare pégʉ, iri pooe opʉ gajerã ĩgʉ̃rẽ moãboerãrẽ ĩgʉ̃ iriupʉrorianerã nemorõ iriukumi. Ĩgʉ̃sã ejamakʉ̃ ĩãrã, iri pooere moãrã ĩgʉ̃sãdere irasũta ñerõ irikuma doja. ");
INSERT INTO sri_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ĩgʉ̃sã irasiriadero pʉrʉ, pooe opʉ ĩgʉ̃ magʉ̃rẽ iriukumi. “Yʉ magʉ̃ gapʉre bʉremurãkuma”, ãrĩ gũñadikumi. ");
INSERT INTO sri_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Iri pooere moãrã gapʉ ĩgʉ̃ magʉ̃ ejamakʉ̃ ĩãrã, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníkuma: “Ĩĩ pʉrʉguere i pooere opabu ããrĩ́mi. Ĩgʉ̃rẽ wẽjẽkõãrã! Irasirirã marĩ basi i pooere oparãkoa”, ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Irasirirã ĩgʉ̃rẽ ñeã, pooe tʉrogue ãĩwãgã, wẽjẽbéokõãkuma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Irasũ ãrĩ odo, judío masaka oparãrẽ sẽrẽñami: —Iri pooere moãrã ĩgʉ̃ magʉ̃rẽ wẽjẽadero pʉrʉ, pooe opʉ irogue ejagʉ, ¿nasirigʉkuri ĩgʉ̃sãrẽ? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ĩgʉ̃rẽ yʉjʉma: —Ĩgʉ̃sã ñerãrẽ bopoñarõ marĩrõ wẽjẽkõãgʉkumi. Pʉrʉ gajerãrẽ ĩgʉ̃ya pooere wayugʉkumi. Ĩgʉ̃sã gapʉ ĩgʉ̃ igui oteri dʉkare deko merã ĩgʉ̃rẽ sĩrãkuma, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús ãsũ ãrĩmi ĩgʉ̃sãrẽ: —¿Mʉsã Marĩpʉya werenírĩ gojadea pũrẽ ire buebiriri? Ãsũ ãrĩ gojasũdero ããrĩbʉ́: Suye ʉ̃tãye wii iririmasã ĩgʉ̃sã béoadeaye merã gajigʉ gapʉ õãrõ turari wii irigʉkumi. Marĩpʉ irasiridi ããrĩmí. Marĩ ĩgʉ̃ irasirideare ĩãrã: “Õãtaria”, ãrĩ gũñáa, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Irasirigʉ mʉsãrẽ werea yʉ. Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ããrĩmurãrẽ ĩgʉ̃ õãrĩ sĩrĩrẽ mʉsãrẽ sĩbirikumi. Mʉsãrẽ ĩgʉ̃ sĩboadeare gajerã ĩgʉ̃ dorerire irirã gapʉre sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sugʉ i ʉ̃tãye weka meémejãgʉ̃, mʉtãkõãgʉkumi. I ʉ̃tãye gapʉ ĩgʉ̃ weka meébejaro, ĩgʉ̃rẽ õãrĩ pogagãgue meémutũbéokõãrokoa, ãrĩmi Jesús. ((Jesús i keori merã weregʉ: “Sugʉ yʉre gããmebi wajamoãsũgʉkumi”, ãrĩgʉ̃ irimi.)) ");
INSERT INTO sri_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Paía oparã, fariseo bumarã iri keori merã Jesús irasũ ãrĩ weremakʉ̃ pérã: “Marĩrẽ ãrĩgʉ̃ irasũ ãrĩkumi”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Irasirirã ĩgʉ̃rẽ ñeãdʉadiñurã peresu irimurã. Irasũ ñeãdʉakererã, ãsũ ãrĩ gũñañurã: “Masaka Jesúre: ‘Marĩpʉya kerere weredupuyugʉ ããrĩ́mi’, ãrĩma”, ãrĩñurã. Irasirirã ĩgʉ̃sãrẽ güisĩã, Jesúre ñeãmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús dupaturi gaji keori merã ĩgʉ̃sãrẽ buenemomi. Ãsũ ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri ãsũ ããrã. Su nikũ marã opʉ ĩgʉ̃ magʉ̃ mojõsiari bosenʉ irikumi. ");
INSERT INTO sri_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Irasirigʉ opʉ ĩgʉ̃rẽ moãboerãrẽ: “Yʉ magʉ̃ mojõsiari bosenʉ ĩãrã aarika!” ĩgʉ̃ ãrĩnerãrẽ siiudoregʉ iriukumi. Ĩgʉ̃sã siiumakʉ̃ ĩgʉ̃sã gapʉ: “Waabea”, ãrĩkõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Irasirigʉ opʉ gajerã ĩgʉ̃rẽ moãboerãrẽ iriukumi doja. “Yʉ siiunerãrẽ ãsũ ãrĩ wererã waaka: ‘Yʉre moãboerãrẽ yaarã wekʉare, gajerã yaarã ejorã õãrõ diíkʉrãrẽ wẽjẽdoresiabʉ. Ããrĩpereri yʉ magʉ̃ mojõsiari bosenʉ baaburi ãmu odosiabʉ. Irasirirã: Bosebaarã aarika!’ ãrĩ wereka ĩgʉ̃sãrẽ!” ãrĩ iriukumi. ");
INSERT INTO sri_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ĩgʉ̃ siiunerã gapʉ irire pékererã, bosenʉrẽ ĩãrã waabirikuma. Sugʉ ĩgʉ̃ya pooegue waakõã, gajigʉ ĩgʉ̃ moãrĩrẽ ĩãgʉ̃ waakõãkumi. ");
INSERT INTO sri_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Gajerã gapʉ opʉre moãboerãrẽ ñeã, pá, wẽjẽbéokõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ĩgʉ̃sã irasiririre pégʉ, opʉ bʉro guakumi. Irasirigʉ ĩgʉ̃yarã surarare iriukumi, ĩgʉ̃sãrẽ wẽjẽanerãrẽ wajamoãdoregʉ. Irasirirã ĩgʉ̃yarã surara ĩgʉ̃sãrẽ wẽjẽpeokõã, ĩgʉ̃sãya makãrẽ soebéokõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pʉrʉ opʉ gajerã ĩgʉ̃rẽ moãboerãrẽ ãsũ ãrĩkumi: “Yʉ magʉ̃ mojõsiari bosenʉmarẽ ãmusiabʉ. Yʉ siiunerã gapʉ ñerã ããrĩsĩã, aaribirikuma. ");
INSERT INTO sri_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Irasirirã ããrĩpererã makã dekoma maarĩ́gue ããrĩrã́rẽ mʉsã bokajarãrẽ siiurã waaka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃rẽ moãboerã waa, ããrĩpererã ĩgʉ̃sã bokajarãrẽ: ñerãrẽ, õãrãrẽ siiu, opʉya wiigue ãĩakuma. Irasirirã, ĩgʉ̃ bosenʉ iriri taribure ʉtʉriakõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Pʉrʉ opʉ ĩgʉ̃sãrẽ ĩãgʉ̃ ñajãgʉ̃, sugʉre mojõsiari bosenʉma suríro sãñabire ĩãkumi. ");
INSERT INTO sri_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Irasirigʉ ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽñakumi: “Yʉ merãmʉ, ¿nasirigʉ mojõsiari bosenʉma suríro sãñabirikeregʉ, ñajãriari mʉ?” ãrĩkumi. Ĩgʉ̃ irasũ ãrĩ sẽrẽñamakʉ̃ pégʉ, ĩgʉ̃ gapʉ yʉjʉbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ĩgʉ̃ yʉjʉbirimakʉ̃ ĩãgʉ̃, opʉ ĩgʉ̃rẽ moãboerãrẽ ãsũ ãrĩkumi: “Ĩĩrẽ ñeã, ĩgʉ̃ya mojõrĩrẽ, guburidere sia, ãĩ wiria, naĩtĩãrõgue ĩgʉ̃rẽ béorã waaka! Irogue bʉro pũrĩsũgʉ̃ ĩgʉ̃ya guikare kũrĩduútú oregʉkumi”, ãrĩkumi, ãrĩ weremi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Irasũ ãrĩ odo, ãsũ ãrĩnemomi: —Ĩĩ opʉ keori irirosũ Marĩpʉ wárã siiukerepʉrʉ, ĩgʉ̃ beyerã gapʉ mérãgã ããrĩ́ma, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesús irasũ ãrãdero pʉrʉ, fariseo bumarã waakõãma. Ĩgʉ̃rẽ weresãdʉarã: “Ĩgʉ̃rẽ diaye yʉjʉbirimakʉ̃ irimurã ire sẽrẽñarã!” ãrĩ gãme wereníñurã. ");
INSERT INTO sri_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Irasirirã surãyeri ĩgʉ̃sã buerire tʉyarãrẽ, Herodeya bumarã merã Jesús pʉrogue iriuñurã. Ĩgʉ̃sã Jesús pʉrogue ejarã, ĩgʉ̃rẽ ãrĩma: —Buegʉ, gʉa mʉ iririkʉrire masĩa. Mʉ ãrĩgatoro marĩrõ werenía. “¿Naásũ gũñarĩ masaka yʉre?” ãrĩ gũñarõ marĩrõ Marĩpʉyare diayeta ĩgʉ̃sãrẽ buea. Oparãrẽ, ubu ããrĩrã́dere ããrĩpererãrẽ sʉrosũta ĩãa. ");
INSERT INTO sri_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Irasirigʉ gʉare wereka! ¿Naásũ gũñarĩ mʉ? Romano marã opʉ marĩrẽ niyeru wajasearire marĩ wajarimakʉ̃, ¿õãgorari, o õãberi? ãrĩma Jesúre. ");
INSERT INTO sri_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús gapʉ ĩgʉ̃sã ĩgʉ̃rẽ ñerõ iridʉarire masĩsĩã, ãsũ ãrĩmi: —Irigatorikʉrã ããrã mʉsã. ¿Nasirirã yʉre ñerõ yʉjʉmakʉ̃ iridʉari mʉsã? ");
INSERT INTO sri_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Niyeru tire mʉsã romano marã opʉre wajariburi tire ãĩrika! ãrĩmi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, sunʉ moãrĩ waja wajataropã wajakʉri tire ãĩãma. ");
INSERT INTO sri_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ĩgʉ̃sã iri tire ãĩjamakʉ̃, ĩgʉ̃sãrẽ sẽrẽñami: —I tiguere, ¿noãya diapu keori, noãya wãĩ tuuyari? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Romano marã opʉya diapu keori, ĩgʉ̃ya wãĩta tuuyáa, ãrĩ yʉjʉma. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãsũ ãrĩmi: —Iro merẽ romano marã opʉya ããrĩrĩ́rẽ ĩgʉ̃rẽ sĩka! Marĩpʉya gapʉre Marĩpʉre sĩka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, pégʉka, ĩgʉ̃rẽ piriwãgãkõãma. ");
INSERT INTO sri_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Irinʉrẽta surãyeri saduceo bumarã Jesús pʉrogue ejama. Ĩgʉ̃sã: “Masaka boanerãgue masãbirikuma”, ãrĩ bʉremurã ããrĩmá. Irasirirã Jesúre ãsũ ãrĩma: ");
INSERT INTO sri_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Buegʉ, Moisés ãsũ ãrĩdi ããrĩmí: “Sugʉ marãpokʉdi pũrã marĩkeregʉ ĩgʉ̃ marãpore boaweomakʉ̃, ĩgʉ̃ pagʉmʉ igore dúunorẽgʉkumi. Irasirirã, igo merã ĩgʉ̃ pũrãkʉrã, ĩgʉ̃ tĩ́gʉ̃ dagʉ pũrã irirosũta ããrĩrãkuma”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Iripoegue gʉa watopeguere sugʉ pũrã su mojõma pere gaji mojõ peru pẽrẽbejarã ããrĩunanerã ããrĩmá. Ĩgʉ̃sã tĩ́gʉ̃ gapʉ marãpokʉ, pũrã marĩgʉ̃ta boakõãyupʉ. Irasirigʉ ĩgʉ̃ dagʉ dokamʉta ĩgʉ̃ marãpo ããrĩdeore dúunorẽyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ĩgʉ̃de ĩgʉ̃ tĩ́gʉ̃ dagʉ irirosũta pũrã marĩgʉ̃ta boakõãyupʉ. Ĩgʉ̃sã pẽrã dokamʉde pũrã marĩgʉ̃ta boakõãyupʉ. Irasũ dita pũrã marĩrãta boapereakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ĩgʉ̃sã pʉrʉ ĩgʉ̃sã marãpode boakõãyupo pama. ");
INSERT INTO sri_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ĩgʉ̃sã su mojõma pere gaji mojõ peru pẽrẽbejarã ʉ̃ma ããrĩpererã igore marãpokʉñurã. Irasirirã boanerã masãmakʉ̃, ¿niíno marãpogora ããrĩgokuri? ãrĩ sẽrẽñama. ");
INSERT INTO sri_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Mʉsã diaye gũñabea. Marĩpʉya werenírĩ gojadeare, Marĩpʉ turaridere masĩbea. ");
INSERT INTO sri_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Boanerã ĩgʉ̃sã masãdero pʉrʉ, ĩgʉ̃sã ʉ̃mʉgasigue Marĩpʉre wereboerã irirosũ ããrĩrãkuma. Iroguere marãpokʉbirikuma. Ĩgʉ̃sã pũrã nomedere nomesubirikuma. ");
INSERT INTO sri_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Marĩpʉya werenírĩ gojadea pũgue boanerã ĩgʉ̃sã masãburire mʉsã buebiriri? Ãsũ ãrĩdi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yʉ Abraham, Isaac, Jacob Opʉ ããrã”, ãrĩdi ããrĩmí. Irasirirã ĩgʉ̃sã boanerã ããrĩkererã, Marĩpʉ merã okarã ããrĩ́ma. Irasirigʉ Marĩpʉ okarã Opʉ ããrĩ́mi. Boanerã neõ dupaturi masãbirikõãmurã Opʉ ããrĩbemi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, masaka: “Õãrõ buemi”, ãrĩ pégʉkakõãma. ");
INSERT INTO sri_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesús saduceo bumarãrẽ ĩgʉ̃sã ĩgʉ̃rẽ sẽrẽñanemomasĩbirimakʉ̃ iririre pérã, fariseo bumarã nerẽma. ");
INSERT INTO sri_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Irasirigʉ sugʉ ĩgʉ̃sã merãmʉ, Moisés gojadeare buerimasʉ̃ Jesúre diaye yʉjʉbirimakʉ̃ iridʉagʉ, ãsũ ãrĩ sẽrẽñami: ");
INSERT INTO sri_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Buegʉ, ¿dií gapʉ Marĩpʉ doreri gaji doreri nemorõ ããrĩ́rĩ? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús ĩgʉ̃rẽ yʉjʉmi: —Mʉya yʉjʉpũrã merã, mʉ ããrĩrikʉri merã, ããrĩpereri mʉ gũñarĩ merã Marĩpʉre mʉ Opʉre maĩka! ");
INSERT INTO sri_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","I doreri, gaji nemorõ ããrĩtarinʉgãrĩ ããrã. ");
INSERT INTO sri_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","I doreri pʉrʉma ãsũ ãrã: “Mʉ basi maĩrõsũta mʉ pʉro ããrĩrã́rẽ maĩka!” ");
INSERT INTO sri_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Marĩ i pe dorerire irirã, ããrĩpereri Moisés doredeare, Marĩpʉya kerere weredupuyunerã buedeare irirã yáa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo bumarã irogue nerẽanerã ããrĩripoe Jesús ĩgʉ̃sãrẽ sẽrẽñami: ");
INSERT INTO sri_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Naásũ gũñarĩ mʉsã Cristo, Marĩpʉ iriudire? ¿Noã magʉ̃ ããrĩ́rĩ ĩgʉ̃? ãrĩmi. —Cristo, David parãmi ããrĩturiagʉ ããrĩ́mi, ãrĩ yʉjʉma. ");
INSERT INTO sri_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãrĩmi: —David, Cristo ñekʉ̃ ããrĩkeregʉ, ¿nasirigʉ Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃rẽ weredorederosũta Cristore: “Yʉ Opʉ ããrĩ́mi”, ãrĩyuri? David ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Marĩpʉ yʉ Opʉre ãsũ ãrĩmi: “Õõ, yʉ diaye gapʉ doaka, yʉ merã dorebu! Irasiriripoe mʉrẽ ĩãturirãrẽ mʉ dorerire tarinʉgãnemobirimakʉ̃ irigʉra”, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David, Cristo ñekʉ̃ ããrĩkeregʉ, ĩgʉ̃rẽ: “Yʉ Opʉ ããrĩ́mi”, ãrĩdi ããrĩmí. ¿Nasirigʉ, Cristo, David parãmi ããrĩturiagʉ ããrĩkerepʉrʉ, David ĩgʉ̃rẽ irasũ ãrĩyuri? ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ĩgʉ̃ irasũ ãrĩrĩrẽ pérã, neõ ĩgʉ̃rẽ yʉjʉmasĩbirima. Irasirirã güirã, ĩgʉ̃rẽ dupaturi sẽrẽñanemobirima. ");
INSERT INTO sri_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pʉrʉ Jesús masakare, gʉa ĩgʉ̃ buerãdere ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisés gojadeare buerimasã, fariseo bumarã, Marĩpʉ Moisére doreri pídeare: “Ãsũ ãrĩdʉaro yáa”, ãrĩ wererã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Irasirirã ĩgʉ̃sã wererire õãrõ iritʉyaka mʉsã! Ĩgʉ̃sã iririkʉri gapʉre ĩãkũĩbirikõãka! Ĩgʉ̃sã wererosũta iribema. ");
INSERT INTO sri_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Masakare dorerã: “Ãsũ irika!” ãrĩrã, ĩgʉ̃sãrẽ gajino bʉro nʉkʉ̃rĩ kõãtãrĩrã irirosũ ããrĩmakʉ̃ yáma. Masaka ĩgʉ̃sã dorerire bokatĩũbirikerepʉrʉ, ĩgʉ̃sãrẽ neõ iritamubema, ĩgʉ̃sã dorerire iriburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","’Masaka ĩãmakʉ̃ dita õãrĩrẽ iri ĩmuma. Marĩpʉya werenírĩ ĩgʉ̃sã gojadea pũrĩ sãrĩ kũmarĩgã gajerãya nemorõ eyari kũmarĩgãrẽ ĩgʉ̃sãya diapuserorire, ĩgʉ̃sãya dʉkaridere siatúma, masaka ĩgʉ̃sãrẽ: “Marĩpʉyare õãrõ masĩma”, ãrĩdorerã. Irasũ ããrĩmakʉ̃, ĩgʉ̃sãya dipuru peyari gasirore gajerãya nemorõ yoari yuradari opari gasirire peyama, masaka ĩgʉ̃sãrẽ: “Marĩpʉre bʉremutarima”, ãrĩdorerã. ");
INSERT INTO sri_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bosenʉrĩ ããrĩmakʉ̃, oparã doarigue dita doadʉama. Marĩ nerẽrĩ wiiriguedere ñajãrã, õãrĩ doaripẽrĩgue dita doadʉama. ");
INSERT INTO sri_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Makã dekoguere masakare õãrõ bʉremurĩ merã ĩgʉ̃sãrẽ bokatĩrĩ õãdoremakʉ̃ gããmema. Gajerãrẽ ĩgʉ̃sãrẽ: “Gʉare buerã ããrĩ́ma”, ãrĩmakʉ̃ gããmema. ");
INSERT INTO sri_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ĩgʉ̃sã irasũ ãrĩkerepʉrʉ, mʉsã gapʉ masakare: “Mʉsã gʉare buerã ããrã”, ãrĩdorebirikõãka! Mʉsã sugʉ pũrãta ããrã. Yʉ mʉsãrẽ buegʉ sugʉta ããrã. ");
INSERT INTO sri_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","I ʉ̃mʉguere neõ sugʉ masakʉre: “Gʉapʉ ããrĩ́mi”, ãrĩbirikõãka! Ʉ̃mʉgasigue ããrĩgʉ̃́ dita Marĩpʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Neõ sugʉ mʉsã watopegue ããrĩgʉ̃́rẽ: “Marĩ opʉ ããrĩ́mi”, ãrĩbirikõãburo. Yʉ, Marĩpʉ iriudi Cristo, sugʉta mʉsã Opʉ ããrã. ");
INSERT INTO sri_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mʉsã watopegue ããrĩgʉ̃́ gajerã nemorõ ããrĩgʉ̃́, mʉsãrẽ moãboerimasʉ̃ irirosũ mʉsãrẽ iritamugʉ̃ ããrĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sugʉ ĩgʉ̃ basi: “Gajerã nemorõ ããrã”, ãrĩ gũñagʉ̃norẽ Marĩpʉ ĩgʉ̃rẽ ubu ããrĩgʉ̃́ dujamakʉ̃ irigʉkumi. Gajigʉ: “Gajerã nemorõ ããrĩbea”, ãrĩ gũñagʉ̃ gapʉre Marĩpʉ ĩgʉ̃sã opʉ ããrĩmakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Mʉsã Moisés gojadeare buerimasã, fariseo bumarã irigatorikʉrã ããrã. Mʉsã bueri merã masakare ʉ̃mʉgasigue Marĩpʉ ĩgʉ̃yarãrẽ dorerogue waabonerãrẽ kãmutarã yáa. Mʉsãde iroguere waabirikoa. Gajerã iroguere waadʉarãdere kãmutáa. Irasirirã ñerõ tarirãkoa. ");
INSERT INTO sri_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Mʉsã Moisés gojadeare buerimasã, fariseo bumarã irigatorikʉrã ããrã. Wapiweyarã nome wajamomakʉ̃ ĩã, ĩgʉ̃sãya wiirire ẽmanokõãa. Ĩgʉ̃sãrẽ bopoñabirikererã, yoaripoe Marĩpʉre sẽrẽ ĩmugatoa, masaka mʉsãrẽ: “Marĩpʉre õãrõ bʉremuma”, ãrĩburo, ãrĩrã. Irasirirã ñerõ tarirãkoa. Marĩpʉ mʉsãrẽ gajerã nemorõ wajamoãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Mʉsã Moisés gojadeare buerimasã, fariseo bumarã irigatorikʉrã ããrã. Dia wádiyague taribuja, yoaroma makãrĩgue mʉsã buerire tʉyabure ãmarã́ waáa. Ĩgʉ̃rẽ boka, mʉsã bueri merã ĩgʉ̃rẽ mʉsã nemorõ perebiri peamegue waabu ããrĩmakʉ̃ yáa. Irasirirã ñerõ tarirãkoa. ");
INSERT INTO sri_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Mʉsã koye ĩãmerã gajerãrẽ tʉ̃ãdupuyuwãgãmasĩmerã irirosũ masakare Marĩpʉyare keoro buebea. Irasirirã ñerõ tarirãkoa. Ĩgʉ̃sãrẽ ãsũ ãrĩ buea: “Sugʉ: ‘Marĩpʉya wii merã ãsũ irigʉra’, ãrĩ wãĩpeodeare iribirimakʉ̃, waja opabemi”, ãrã. Idere ãsũ ãrĩ buea: “Gajigʉ: ‘Marĩpʉya wiima oro merã ãsũ irigʉra’, ãrĩ wãĩpeodeare iribirimakʉ̃, waja opami”, ãrã. ");
INSERT INTO sri_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Koye ĩãmerã irirosũ Marĩpʉyare diaye gũñamerã, pémasĩmerã ããrã mʉsã. Marĩpʉ ĩgʉ̃ya wiire, iri wiima oro nemorõ õãrĩ ããrĩtarinʉgãmakʉ̃ yámi. Irasirigʉ marĩrẽ, ¿dií gapʉre bʉremurĩ merã gũñamakʉ̃ gããmerĩ, orore, o ĩgʉ̃ya wii gapʉre? ");
INSERT INTO sri_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mʉsã idere ãsũ ãrĩ buea: “Sugʉ: ‘Marĩpʉya wiima soepeoro merã ãsũ irigʉra’, ãrĩ wãĩpeodeare iribirimakʉ̃, waja opabemi”, ãrã. Idere ãsũ ãrĩ buea: “Gajigʉ: ‘Iri soepeoro weka peodea merã ãsũ irigʉra’, ãrĩ wãĩpeodeare iribirimakʉ̃, waja opami”, ãrã. ");
INSERT INTO sri_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Koye ĩãmerã irirosũ Marĩpʉyare diaye gũñamerã, pémasĩmerã ããrã mʉsã. Marĩpʉ ĩgʉ̃ya wiima soepeorore, marĩ iro weka peodea nemorõ õãrĩ ããrĩtarinʉgãmakʉ̃ yámi. Irasirigʉ marĩrẽ, ¿dií gapʉre bʉremurĩ merã gũñamakʉ̃ gããmerĩ, soepeorore, o iro weka peodea gapʉre? ");
INSERT INTO sri_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Irasirigʉ sugʉ: “Marĩpʉya wiima soepeoro merã ãsũ irigʉra”, ãrĩ wãĩpeogʉ, ããrĩpereri iri soepeoro weka peyari merãdere wãĩpeogʉ irikumi. ");
INSERT INTO sri_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sugʉ: “Marĩpʉya wii merã ãsũ irigʉra”, ãrĩ wãĩpeogʉ, Marĩpʉ iri wiigue ããrĩgʉ̃́ merãdere wãĩpeogʉ irikumi. ");
INSERT INTO sri_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sugʉ: “Ʉ̃mʉgasima merã ãsũ irigʉra”, ãrĩ wãĩpeogʉde, Marĩpʉ irogue Opʉ doarogue doagʉ merãdere wãĩpeogʉ irikumi. ");
INSERT INTO sri_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Mʉsã Moisés gojadeare buerimasã, fariseo bumarã irigatorikʉrã ããrã. Irasirirã ñerõ tarirãkoa. Mʉsã oteri mʉtãrĩgã: menta, anís, comino wãĩkʉri baari morẽrĩnorẽ sea neeõ, dʉkawa, pe mojõma diruri irikoa. Sudiru Marĩpʉya wiigue ãĩakoa, ĩgʉ̃ dorerire irimurã. Irasirikererã, iri nemorõ õãrĩ gapʉre iribea. Diayema iririre, gajerãrẽ bopoñarĩ merã ĩãrĩrẽ, Marĩpʉre bʉremurĩrẽ neõ iribea. Irasirirã mʉsã oterire Marĩpʉre sĩduúro marĩrõ diayemadere irika! Gajerãrẽ bopoñaka! Marĩpʉre bʉremuka! ");
INSERT INTO sri_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Koye ĩãmerã gajerãrẽ tʉ̃ãdupuyuwãgãmasĩmerã irirosũ masakare Marĩpʉyare keoro buebea. Ããrĩpereri mʉsã doreri gapʉre irikererã, iri nemorõ doreri gapʉre neõ iribea. ");
INSERT INTO sri_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Mʉsã Moisés gojadeare buerimasã, fariseo bumarã irigatorikʉrã ããrã. Irasirirã ñerõ tarirãkoa. Mʉsã masaka ĩũrõgue dita õãrõ irirã, soropa weka gapʉ dita õãrõ koeadeapa irirosũ ããrã. Irasirirã mʉsã basi wári opadʉarã gajerãyare yajarã, iripa poekague koeña marĩrĩpa gʉrari ʉtʉriripa irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mʉsã fariseo bumarã, koye ĩãmerã irirosũ, Marĩpʉyare pémasĩmerã ããrã. Irasirirã mʉsã gũñarĩrẽ gorawayupʉrorika, soropa poeka gapʉre õãrõ koeadeapa irirosũ ããrĩmurã. Irasirirã, soropa weka gapʉdere õãrõ koeadeapa irirosũ ããrĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Mʉsã Moisés gojadeare buerimasã, fariseo bumarã irigatorikʉrã ããrã. Irasirirã ñerõ tarirãkoa. Mʉsã masãgoberi irirosũ ããrã. Masaka, iri masãgoberire ʉ̃tã majĩrĩ boreri merã õãrõ wʉ̃kãdea majĩrĩ merã biamakʉ̃ ĩãrã: “Õãrõ deyoa”, ãrĩ ĩãma. Iri õãrõ deyokerepʉrʉ, poekague boanerãya gõãrĩ́, ããrĩpereri ñerĩ boadea sãñakoa. ");
INSERT INTO sri_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mʉsãde i irirosũta ããrã. Masaka mʉsãrẽ ĩãmakʉ̃, õãrã irirosũ ããrã. Irasũ ããrĩkererã, poekague mʉsã gũñarĩguere ñerĩrẽ opataria. Irasirirã irigatorikʉrã, ñerõ iririkʉrã ããrã. ");
INSERT INTO sri_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Mʉsã Moisés gojadeare buerimasã, fariseo bumarã irigatorikʉrã ããrã. Irasirirã ñerõ tarirãkoa. Mʉsã, iripoegue marã Marĩpʉya kerere weredupuyunerãya masãgoberire õãrõ ãmua. Gajerã õãrõ irinerãya masãgoberi weka weanúdeadere õãrõ ãmua. ");
INSERT INTO sri_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ãmu odo, ãsũ ãrĩ werenía: “Marĩ ñekʉ̃sãmarã darã Marĩpʉya kerere weredupuyunerãrẽ wẽjẽnerã ããrĩmá. Gʉa ĩgʉ̃sã ããrĩdeapoegue ããrĩnerã tamerã ĩgʉ̃sãrẽ wẽjẽtamubiribokuyo”, ãrã. ");
INSERT INTO sri_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mʉsã irire irasũ ãrĩrã, mʉsã basita: “Gʉa Marĩpʉya kerere weredupuyunerãrẽ wẽjẽnerã parãmerã ããrĩturiarã ããrã”, ãrĩrã yáa. ");
INSERT INTO sri_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Irasirirã mʉsã ñekʉ̃sãmarã ñerõ iripʉroriwãgãriderosũta iriyuwarikʉkõãka mʉsãde! ");
INSERT INTO sri_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Mʉsã ñerõ iririkʉrã ãña irirosũ ããrã. Mʉsã ñerõ iriri waja Marĩpʉ mʉsãrẽ peamegue béoburire neõ duribirikoa. ");
INSERT INTO sri_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Irasirigʉ yʉ mʉsã pʉrogue Marĩpʉya kerere weredupuyurãrẽ, ĩgʉ̃yare masĩrãrẽ, mʉsãrẽ buerimasãdere iriugʉra. Yʉ irasũ iriukerepʉrʉ, mʉsã gapʉ surãyerire wẽjẽrãkoa. Gajerãrẽ curusague pábiatú wẽjẽrãkoa. Gajerãrẽ mʉsã nerẽrĩ wiirigue tãrã, noó ĩgʉ̃sã waarí makãrĩ waamakʉ̃ tʉyagorenarãkoa ĩgʉ̃sãrẽ ñerõ iridʉarã. ");
INSERT INTO sri_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Irasirirã ããrĩpererã masaka õãrãrẽ wẽjẽdea waja, mʉsã waja opáa. Mʉsã ñekʉ̃sãmarã Abel diayemarẽ iridire wẽjẽpʉroriwãgãrirã, Zacarías Berequías magʉ̃guere wẽjẽtũnunerã ããrĩmá. Ĩgʉ̃rẽ Marĩpʉya wiima soepeoro Marĩpʉ ããrĩrĩ́ taribu watopegue wẽjẽnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Diayeta mʉsãrẽ werea. Ããrĩpererãrẽ ĩgʉ̃sã wẽjẽdea waja dapora marã wajakʉrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Mʉsã Jerusalén marã, Marĩpʉya kerere weredupuyurãrẽ wẽjẽkõãa. Marĩpʉ iriunerãrẽ ʉ̃tãyeri merã dea wẽjẽa. Wári yʉ mʉsãrẽ ãgãbo igo pũrãrẽ igoya kẽdʉpʉri merã neeõnúrõsũ neeõnú koredʉadibʉ. Mʉsã gapʉ yʉ irasũ irimakʉ̃ neõ gããmebiribʉ. ");
INSERT INTO sri_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Irasiriro mʉsã ããrĩrĩ́ makã, béodea makã dujarokoa. ");
INSERT INTO sri_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Diayeta mʉsãrẽ werea. Dapora merãta mʉsã yʉre ĩãnemobirikoa. Pʉrʉgue mʉsã: “Marĩpʉ iriudi õãtarigʉ ããrĩ́mi, õãrõ aariburo”, ãrĩrãgue, yʉre dupaturi ĩãrãkoa doja, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús Marĩpʉya wiigue ããrãdi wiriadero pʉrʉ, gʉa ĩgʉ̃ buerã ĩgʉ̃ pʉro waa, ãsũ ãrĩbʉ: —Ĩãka i wiire! Õãrĩ wii, wári wii ããrã, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús gapʉ yʉjʉmi: —Mʉsã i wiire daporare ĩãdáa. Diayeta mʉsãrẽ werea. I wiima ããrĩpereri mʉsã ĩãdea, i ʉ̃tãyeride mʉtãdijapereakõãrokoa. Neõ suye ʉ̃tãye gajiye weka weamʉrĩadeade dujabirikoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pʉrʉ Olivos wãĩkʉri buúrugue eja, irogue doami Jesús. Iro ĩgʉ̃ doamakʉ̃, gʉa ĩgʉ̃ buerã ĩgʉ̃ pʉrogue eja, gajerã péberogue sẽrẽñabʉ: —Gʉare wereka! ¿Naásũ ããrĩmakʉ̃, mʉ ãrãderosũ waarokuri? ¿Ñeéno iri ĩmugʉkuri, mʉ dupaturi aarigʉ́? ¿Naásũ waarokuri, i ʉ̃mʉ pereburi dupuyuro? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús yʉjʉmi: —Õãrõ pémasĩka! Gajerã mʉsãrẽ ãrĩgatorire pébirikõãka! ");
INSERT INTO sri_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wárã ãrĩgatorimasã aarirãkuma. “Marĩpʉ iriudi, Cristo ããrã yʉ”, ãrĩrãkuma. Ĩgʉ̃sã ãrĩgatomakʉ̃ pérã, wárã masaka ĩgʉ̃sãrẽ bʉremurãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Masaka mʉsã pʉro gãmewẽjẽrĩrẽ pérã, yoarogue marã gãmewẽjẽrĩ kerere pérã, gʉkabirikõãka! Irasũta waarokoa. Irasũ waakerepʉrʉ, i ʉ̃mʉ pereburo dʉyarokoa dapa. ");
INSERT INTO sri_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Su bumarã gaji bumarã merã gãmekẽãrãkuma. Su nikũ marã gaji nikũ marã merã gãmewẽjẽrãkuma. Masaka wárã ʉaboari merã boarãkuma. Gajerã pũrĩrikʉ ñerõ tarirãkuma. Wári makãrĩguere nikũ ñomerokoa. ");
INSERT INTO sri_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","I ããrĩpereri merã masaka ñerõ taripʉroriwãgãrirãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Irasirirã gajerã mʉsãrẽ ñeã, ãĩa, oparãguere ñerõ iridorerã wiarãkuma. Mʉsãrẽ wẽjẽrãkuma. Yʉre bʉremurĩ waja ããrĩpererã i ʉ̃mʉ marã mʉsãrẽ ĩãturi doorãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Irasũ waaripoe wárã yʉre bʉremuadinerã bʉremuduúrãkuma. Irasirirã gãme ĩãturi doo, ĩgʉ̃sã merãmarã ããrãdinerãrẽ ĩgʉ̃sãrẽ ĩãturirãguere wiarãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wárã: “Marĩpʉya kerere weredupuyurimasã ããrã”, ãrĩgatorãkuma. Irasirirã wárã masaka ĩgʉ̃sãrẽ bʉremurãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Masaka iro dupuyuro ñerõ iridero nemorõ ñerõ irirãkuma. Irasirirã wárã ĩgʉ̃sã gãme maĩrĩrẽ pirirãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ĩgʉ̃sã mʉsãrẽ ñerõ irikerepʉrʉ, mʉsã yʉre neõ bʉremuduúbirimakʉ̃, Marĩpʉ mʉsãrẽ taugʉkumi, ĩgʉ̃ pʉro ããrĩníkõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Marĩpʉyare wererã ããrĩpererã i ʉ̃mʉ marãrẽ ĩgʉ̃yarãrẽ doregʉ ããrĩrĩ́ kerere wererãkuma, ããrĩpereri bumarã irire masĩburo, ãrĩrã. Ĩgʉ̃sã ããrĩpererã iri kerere péperedero pʉrʉ, i ʉ̃mʉ pererokoa. ");
INSERT INTO sri_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Iripoegue Marĩpʉya kerere weredupuyudi Daniel i ʉ̃mʉ pereburo dupuyuro waaburire ãsũ ãrĩ gojadi ããrĩmí: “Ñegʉ̃ Marĩpʉre ĩãturigʉ Marĩpʉya wii ñerĩ marĩrĩ wiigue ñajãgʉkumi”, ãrĩ gojadi ããrĩmí. ((Irasirirã iri wiigue ĩgʉ̃ ããrĩmakʉ̃ ĩãrã, i pũrẽ buerãno: “I ʉ̃mʉ pereburo yáa”, ãrĩ masĩrãkuma.)) ");
INSERT INTO sri_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ñegʉ̃ irogue ããrĩmakʉ̃ ĩãrã, Judea nikũ marã buurígue ũmaduriburo. ");
INSERT INTO sri_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sugʉ ĩgʉ̃ya wii wekague ããrĩgʉ̃́, wii poekague ĩgʉ̃yare ãĩgʉ̃ ñajãbita ũmaduriburo. ");
INSERT INTO sri_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sugʉ ĩgʉ̃ya pooegue ããrĩgʉ̃́de, ĩgʉ̃ya suríre wiigue ãĩgʉ̃ dujáabita ũmaduriburo. ");
INSERT INTO sri_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Irasũ waarínʉrĩrẽ nijĩpagosã nome, ĩgʉ̃sã pũrã mirĩrãgã oparã nomede ñerõ tarirãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Irasirirã Marĩpʉre ãsũ ãrĩ sẽrẽka: “Puibʉre, siuñajãrĩnʉ ããrĩmakʉ̃, gʉare i irasũ waabirikõãburo”, ãrĩka ĩgʉ̃rẽ! ");
INSERT INTO sri_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Irasũ waarínʉrĩrẽ masaka bʉro ñerõ tarirãkuma. Marĩpʉ i ʉ̃mʉrẽ iripʉroridero pʉrʉre masaka ñerõ taridero nemorõ ñerõ tarirãkuma. I ĩgʉ̃sãrẽ ñerõ waaburi neõ dupaturi irasũ waanemobirikoa. ");
INSERT INTO sri_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Irasirigʉ Marĩpʉ masakare i ñerõ waaríre: “Yoaripoe waabirikõãburo”, ãrĩgʉkumi. Ĩgʉ̃ irasiribirimakʉ̃, neõ sugʉ masakʉ taribiribokumi. Irasirigʉ ĩgʉ̃ beyenerãrẽ bopoñasĩã, ĩgʉ̃sãrẽ ñerõ waaríre: “Iropãta waaburo”, ãrĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Gajerã mʉsãrẽ: “Ĩãka! Õõta Cristo ããrĩ́mi”, ãrĩmakʉ̃ pérã, o gajerã mʉsãrẽ: “Cristo sõõgue ããrãmi”, ãrĩmakʉ̃ pérã, bʉremubirikõãka! ");
INSERT INTO sri_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wárã ãrĩgatorimasã aarirãkuma. Surãyeri: “Yʉ Cristo ããrã”, ãrĩrãkuma. Gajerã: “Marĩpʉya kerere weredupuyurimasʉ̃ ããrã”, ãrĩrãkuma. Mʉsãrẽ ĩgʉ̃sã ãrĩgatorire bʉremudorerã, wári gajino iri ĩmurãkuma. Irasirikererã, Marĩpʉ beyenerãrẽ ĩgʉ̃rẽ bʉremuduúmakʉ̃ irimasĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iri waaburi dupuyuro yʉ mʉsãrẽ weresiáa, irire masĩburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Irasirirã gajerã masaka mʉsãrẽ: “Cristo sõõ masaka marĩrõgue ããrãmi”, ãrĩmakʉ̃ pérã, ĩãrã waabirikõãka! Gajerã mʉsãrẽ: “Ĩãka! I wiima taribugue ããrĩ́mi”, ãrĩmakʉ̃ pérã, ĩgʉ̃sãrẽ bʉremubirikõãka! ");
INSERT INTO sri_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yʉ ããrĩpererã tĩ́gʉ̃ gũñaña marĩrõ i ʉ̃mʉgue dupaturi aarigʉkoa. Ʉ̃marõgue, abe mʉrĩriro gapʉ, ĩgʉ̃ ñajãrõ gapʉ bupu miãrõ irirosũ aarigʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mimua nerẽmakʉ̃ ĩãrã, masaka sugʉ waibʉ boadi ããrĩrṍrẽ masĩkuma. I irirosũ yʉ aarimakʉ̃ ĩãrã, ĩgʉ̃sã wajamoãsũburire masĩrãkuma, ãrĩ weremi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Irasũ ãrĩ odo, gʉare ãsũ ãrĩnemomi: —Masaka ñerõ taririnʉrĩ pʉrʉta abe ʉ̃mʉmʉ naĩtĩãkõãgʉkumi. Abe ñamimʉ boyonemobirikumi. Neñukã ʉ̃mʉgasigue ããrĩrã́ yuridijarirãkuma. Ʉ̃marõgue marã turarãde naradari merã béosũrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Irasũ waaripoere masaka yʉ ããrĩpererã tĩ́gʉ̃ ʉ̃mʉgasigue merã aarimakʉ̃ ĩãrãkuma. Irasirirã ããrĩpereri i ʉ̃mʉma makãrĩ marã yʉ wári Marĩpʉ turari merã, ĩgʉ̃ gosewasiriri merã mikãyebori weka aarimakʉ̃ ĩãrã, güirã orerãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yʉ aarigʉ́, yʉre wereboerãrẽ ããrĩperero i ʉ̃mʉguere iriugʉkoa. Puridiru bʉro bʉsʉmakʉ̃, ĩgʉ̃sã yʉ beyenerãrẽ ããrĩpererogue ããrĩrã́rẽ neeõrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ire mʉsã masĩburo, ãrĩgʉ̃, higueragʉ keori merã weregʉra. Irigʉ pũ maamamakʉ̃ ĩãrã: “Bojori waaburo mérõgã dʉyáa”, ãrĩ masĩa. ");
INSERT INTO sri_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Irigʉ waarósũta i ããrĩpereri yʉ ãrĩrĩ irasũ waamakʉ̃ ĩãrã: “Cristo dupaturi aariburo mérõgã dʉyáa”, ãrĩ masĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Diayeta mʉsãrẽ werea. I ããrĩpereri yʉ ãrĩrĩ, dapora marã pereburo dupuyuro irasũ waarokoa. ");
INSERT INTO sri_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ʉ̃mʉgasi, i nikũde pereakõãrokoa. Yʉ werenírĩ gapʉ neõ perebirikoa. Ããrĩpereri yʉ ãrĩrõsũta waayuwarikʉrokoa. ");
INSERT INTO sri_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Yʉ dupaturi aariburinʉrẽ, iri horare neõ sugʉ masĩbirikumi. Marĩpʉre wereboerã ʉ̃mʉgasigue ããrĩrã́de masĩbema. Yʉ Marĩpʉ magʉ̃de masĩbea. Yʉpʉ sugʉta masĩmi. ");
INSERT INTO sri_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Noé ããrĩdeapoe marãrẽ waaderosũta yʉ ããrĩpererã tĩ́gʉ̃ aariburo dupuyurogãrẽ waarokoa. ");
INSERT INTO sri_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Iripoere i nikũ Marĩpʉ miũburo dupuyuro masaka õãrõ baa, iirí, mojõsia, ĩgʉ̃sã pũrã nomerẽ nomesu ããrĩrikʉnerã ããrĩmá. Noésã doódirugue ñajãrĩnʉguedere irasũta iriníkõãnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Gũñaña marĩrõ merã wáro deko merẽ, i nikũ mirĩpereakõãdero ããrĩbʉ́. Ĩgʉ̃sãde mirĩpereakõãnerã ããrĩmá. Irasũta yʉ ããrĩpererã tĩ́gʉ̃de gũñaña marĩrõ merã i ʉ̃mʉguere dupaturi aarigʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Irasũ waaripoere pẽrã pooegue moãrã ããrĩrãkuma. Sugʉ yʉre bʉremugʉ̃ ãĩãsũgʉkumi. Gajigʉ yʉre bʉremubi irogueta béowãgãsũgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nomede pẽrã nome ojodʉka biurã ããrĩrãkuma. Sugo yʉre bʉremugõ ãĩãsũgokumo. Gajego yʉre bʉremubeo irogueta béowãgãsũgokumo. ");
INSERT INTO sri_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Õãrõ pémasĩka! Yʉ mʉsã Opʉ dupaturi aariburi horare neõ masĩbea mʉsã. ");
INSERT INTO sri_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ire õãrõ masĩka! Wii opʉ ĩgʉ̃ya wiire sugʉ yajarimasʉ̃ ñami merã ejaburi horare masĩgʉ̃, kãrĩrõ marĩrõ korekumi, ĩgʉ̃ya wiire ñajãburire kãmutabu. ");
INSERT INTO sri_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yʉ ããrĩpererã tĩ́gʉ̃ gũñaña marĩrõ aarigʉkoa. Irasirirã, wii opʉ irirosũ mʉsãde yʉ aariburire õãrõ yúro gããmea, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pʉrʉ Jesús gaji keori merã gʉare buenemomi: —Sugʉ moãboegʉ ĩgʉ̃ opʉre bʉremugʉ̃, pémasĩgʉ̃ ãsũ irikumi. Ĩgʉ̃ opʉ gajerogue waagʉ́, ĩgʉ̃rẽ ĩgʉ̃ya wiire gajerãrẽ ĩgʉ̃rẽ moãboerãrẽ koredoregʉ píkumi. Irasirigʉ ĩgʉ̃rẽ ĩgʉ̃sãrẽ baarire keoro siiu baadoregʉ píkumi. ");
INSERT INTO sri_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Irasirigʉ ĩgʉ̃ opʉ ĩgʉ̃ya wii goedujajamakʉ̃ ĩãgʉ̃, ĩgʉ̃rẽ moãboegʉ ĩgʉ̃ dorederosũta iridi ããrĩsĩã, ʉsʉyakumi. ");
INSERT INTO sri_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Diayeta mʉsãrẽ werea. Ĩgʉ̃ píderosũta ĩgʉ̃ keoro irideare ĩãgʉ̃, ĩgʉ̃ opʉ ĩgʉ̃rẽ ããrĩpereri ĩgʉ̃yare koredoregʉ pígʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ĩgʉ̃rẽ moãboegʉ ñegʉ̃ gapʉ ãsũ irikumi. “Yʉ opʉ mata goebirikumi”, ãrĩ gũñagʉ̃, gajerã ĩgʉ̃ opʉre moãboerãrẽ ñerõ pábira, mejãrikʉrã merã iirí baagorenakumi. ");
INSERT INTO sri_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ĩgʉ̃ irasirigorenarĩnʉrẽ gũñaña marĩrõ ĩgʉ̃ opʉ goejakumi. Ĩgʉ̃rẽ moãboegʉ gapʉ: “Ĩgʉ̃ iri hora goegʉkumi”, ãrĩ masĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ĩgʉ̃ opʉ goejagʉ ĩgʉ̃rẽ moãboegʉ ñerõ irideare pégʉ, ĩgʉ̃rẽ bʉro wajamoãgʉkumi. Irasirigʉ irigatorikʉrãrẽ béorogue ĩgʉ̃rẽ béogʉkumi. Iroguere ĩgʉ̃ bʉro pũrĩsũgʉ̃ ĩgʉ̃ya guikare kũrĩduútú oregʉkumi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Pʉrʉ Jesús dupaturi keori merã gʉare ãsũ ãrĩ buemi doja: —Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ doreri ãsũ ããrã. Pe mojõmarã nóome ããrĩkuma. Su ñami ĩgʉ̃sãya sĩãgori duparu merã mojõsiadire bokatĩrĩrã waakuma. ");
INSERT INTO sri_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Su mojõmarã nome sĩãgori duparu ĩgʉ̃sã ãĩaburire õãrõ ãmuyubirikuma. Gajerã su mojõmarã nome gapʉ ĩgʉ̃sã ãĩaburire õãrõ ãmuyukuma. ");
INSERT INTO sri_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ãmuyumerã nome ĩgʉ̃sãya sĩãgori duparure ãĩakererã, ĩgʉ̃sã gorawayuburire ʉye ãĩabirikuma. ");
INSERT INTO sri_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ãmuyurã nome gapʉ ĩgʉ̃sãya sĩãgori duparure ãĩ, gaji ʉye ĩgʉ̃sã gorawayuburire ãĩakuma. ");
INSERT INTO sri_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Irasirirã, mojõsiadi mata ejabirimakʉ̃, ĩgʉ̃sãrẽ wʉja ejamakʉ̃ kãrĩakõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pʉrʉ ñami deko ããrĩmakʉ̃, gajerã masaka: “Mojõsiadi aarisiami. Ĩgʉ̃rẽ bokatĩrĩrã aarika!” ãrĩ gainímakʉ̃ pékuma. ");
INSERT INTO sri_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ĩgʉ̃sã gainímakʉ̃ pérã, yobe, ĩgʉ̃sãya sĩãgori duparure ãmukuma. ");
INSERT INTO sri_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ʉye gorawayuburire ãĩabiranerã nome gapʉ, gajerã gaji ʉye ãĩãnerã nomerẽ ãsũ ãrĩkuma: “Gʉaya sĩãgori duparu yariro yáa. Irasirirã mérõgã mʉsãya ʉyere gʉadere sĩka!” ãrĩ sẽrẽadikuma. ");
INSERT INTO sri_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ãmuyuanerã nome gapʉ ãsũ ãrĩ yʉjʉkuma: “Gʉaya ʉye mʉsãrẽ sĩmakʉ̃, mʉsãrẽ, gʉadere ejabiribokoa. Irasirirã ʉye duarã pʉro mʉsã basi wajarirã waaka!” ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Irasirirã ãmuyubiranerã nome ʉye wajarirã waakõãkuma. Ĩgʉ̃sã waadero pʉrʉ, mojõsiadi ejakumi. Ĩgʉ̃ ejamakʉ̃ ĩãrã, ãmuyuanerã nome gapʉ ĩgʉ̃rẽ bokatĩrĩkuma. Irasirirã ĩgʉ̃ merã bosenʉ iriri wiigue ĩãrã ñajãkõãkuma. Ĩgʉ̃sã ñajãperemakʉ̃, iri wii marã disipʉrore biakõãkuma. ");
INSERT INTO sri_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pʉrʉgue ãmuyubiranerã nome gapʉ ejakuma. “Gʉa Opʉ, gʉadere tũpãsóoka!” ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, mojõsiadi ãsũ ãrĩ yʉjʉkumi: “Diayeta yʉ mʉsãrẽ masĩbea”, ãrĩkumi ĩgʉ̃sã nomerẽ, ãrĩ weremi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Irasũ ãrĩ odo, gʉare ãrĩmi: —Yʉ ããrĩpererã tĩ́gʉ̃ dupaturi aariburinʉrẽ, iri horadere neõ masĩbea mʉsã. Irasirirã ãmuyunerã nome mojõsiadire bokatĩrĩrã waamurã ĩgʉ̃sãya sĩãgori duparure ãmuyuderosũ mʉsãde yʉ aariburire õãrõ ãmuyuka! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Irasũ ãrĩ odo, gaji keori merã gʉare ĩgʉ̃ buerãrẽ buenemomi doja: —Marĩpʉ ĩgʉ̃yarãrẽ doregʉ, sugʉ wii opʉ irirosũ ããrĩ́mi. Wii opʉ gaji nikũgue waabu, ĩgʉ̃rẽ moãboerãrẽ siiu, ĩgʉ̃ya niyerure koredoregʉ píkumi. ");
INSERT INTO sri_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Irasirigʉ, ĩgʉ̃sãrẽ: “Õõpã merã wajatanemorãkuma”, ãrĩ ĩãmasĩsĩã, ĩgʉ̃ya niyeru wajapari tirire dʉkawakumi. Sugʉre su mojõma tiri, gajigʉre pe ti, gajigʉre su ti sĩkumi. Ĩgʉ̃sãrẽ sĩ odo, waakõãkumi. ");
INSERT INTO sri_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Irasirigʉ su mojõma tiri opagʉ, mata iri tiri merã gajino wajari, dua, gaji su mojõma tiri wajatanemokumi. Irasirigʉ pe mojõma tiri opakumi. ");
INSERT INTO sri_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pe ti opagʉde irasũta gaji pe ti wajatanemokumi. Irasirigʉ wapikʉri tiri opakumi. ");
INSERT INTO sri_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Su ti opagʉ gapʉ yebague gobe má, iri gobegue ĩgʉ̃ opʉ sĩadea tire yáapíkõãkumi. ");
INSERT INTO sri_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Yoadero pʉrʉ, wii opʉ goekumi. Goeja, ĩgʉ̃ya niyeru tiri merã ĩgʉ̃sã wajatanemodeare ãmubu, ĩgʉ̃rẽ moãboerãrẽ siiukumi. ");
INSERT INTO sri_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Irasirigʉ su mojõma tiri sĩsũdi ĩgʉ̃ opʉ pʉrogue eja, pe mojõma tiri ĩgʉ̃rẽ wiakumi. “Yʉ opʉ, su mojõma tiri yʉre sĩbʉ mʉ”, ãrĩkumi. “Ĩãka! Iri tiri merã gaji su mojõma tiri wajatanemobʉ”, ãrĩkumi ĩgʉ̃ opʉre. ");
INSERT INTO sri_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ opʉ ãrĩkumi: “Õãgoráa. Mʉ yʉre moãboegʉ õãgʉ̃ ããrã. Yʉ dorederosũta yʉ mérõgã mʉrẽ pídea merã õãrõ iriyo. Irasirigʉ wári yaare koredoregʉ pígʉra. Yʉ merã ããrĩgʉ̃́, ʉsʉyari merã ããrĩka!” ãrĩkumi ĩgʉ̃ opʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pʉrʉ pe ti sĩsũdide ĩgʉ̃ opʉ pʉrogue eja, ĩgʉ̃rẽ ãsũ ãrĩkumi: “Yʉ opʉ, pe ti yʉre sĩbʉ mʉ. Ĩãka! Iri tiri merã gaji pe ti wajatanemobʉ”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ opʉ ãrĩkumi: “Õãgoráa. Mʉ yʉre moãboegʉ õãgʉ̃ ããrã. Yʉ dorederosũta yʉ mérõgã mʉrẽ pídea merã õãrõ iriyo. Irasirigʉ wári yaare koredoregʉ pígʉra. Yʉ merã ããrĩgʉ̃́, ʉsʉyari merã ããrĩka!” ãrĩkumi ĩgʉ̃ opʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pʉrʉ su ti sĩsũdi gapʉ, ĩgʉ̃ opʉ pʉrogue eja, ĩgʉ̃rẽ ãsũ ãrĩkumi: “Yʉ opʉ, mʉrẽ moãboerãrẽ bʉro turaro merã moãdoregʉ ããrã. Mʉ basi moãbirikeregʉ, ĩgʉ̃sãrẽ oterire otedore, ĩgʉ̃sãrẽ oteri dʉkare seadore, irire mʉ basita opáa. Mʉrẽ moãboerãya moãrĩ merã wajatarire mʉ basita opáa. Irire masĩa yʉ. ");
INSERT INTO sri_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Irasirigʉ mʉrẽ güigʉ, yebague gobe má, iri gobegue mʉya niyeru tire yáapíkõãbʉ. Ĩãka! I ti ããrã mʉya niyeru ti”, ãrĩkumi ĩgʉ̃ opʉre. ");
INSERT INTO sri_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ opʉ ãrĩkumi: “Mʉ yʉre moãboegʉ ñegʉ̃ ããrã. Térikʉgʉ ããrã. Mʉ yʉre ãsũ ãrã: ‘Mʉ basi moãbirikeregʉ, mʉrẽ moãboerãrẽ oterire otedore, ĩgʉ̃sãrẽ oteri dʉkare seadore, irire mʉ basita opáa. Mʉrẽ moãboerãya moãrĩ merã wajatarire mʉ basita opáa. Irire masĩa yʉ’, ãrã mʉ yʉre. ");
INSERT INTO sri_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mʉ irasũ ãrĩgʉ̃, ¿nasirigʉ, yʉ mʉrẽ sĩdea tire niyeru duripíri wiigue duripíbiriri? Irogue duripímakʉ̃, i wii moãrã iri ti merã wáro wajatanemobosabokuma mʉrẽ. Irasirigʉ, yʉ goejamakʉ̃, mʉ yʉre ĩgʉ̃sã iriri merã wajatanemobosadeare wiaboakuyo”, ãrĩkumi ĩgʉ̃ opʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Irasũ ãrĩ odo, gajerãrẽ irogue ããrĩrã́rẽ ãrĩkumi: “Ĩgʉ̃rẽ niyeru tire ẽma, pe mojõma tiri opagʉ gapʉre sĩka! ");
INSERT INTO sri_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sugʉ wári opagʉ sĩnemosũgʉkumi. Irasirigʉ ĩgʉ̃ wári opadero nemorõ opagʉkumi. Gajigʉ opabi ĩgʉ̃ mérĩgã opadideare ẽmapeokõãsũgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ĩĩ yʉre moãboegʉ keoro iribire naĩtĩãrõgue béokõãka! Iroguere bʉro pũrĩsũgʉ̃ ĩgʉ̃ya guikare kũrĩduútú oregʉkumi”, ãrĩkumi ĩgʉ̃sã opʉ, ãrĩ weremi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Irasũ ãrĩ odo, gʉare ãrĩnemomi: —Yʉ ããrĩpererã tĩ́gʉ̃, ããrĩpererã yʉre wereboerã merã i ʉ̃mʉ marãrẽ doregʉ aarigʉ́, gosewasiriri merã Opʉ doarogue doagʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yʉ irogue doamakʉ̃, yʉre wereboerã ããrĩpereri buri marã masakare yʉ diaye neeõrãkuma. Ĩgʉ̃sãrẽ neeõ odomakʉ̃, sugʉ ejorã koregʉ ovejare, cabrare boje dʉkawanúrõsũ yʉ ĩgʉ̃sãrẽ dʉkawanúgʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yʉre bʉremurãrẽ oveja irirosũ ããrĩrã́rẽ yʉ diaye gapʉ núgʉkoa. Yʉre bʉremumerãrẽ cabra irirosũ ããrĩrã́rẽ yʉ kúgapʉ núgʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yʉ irasiriadero pʉrʉ, yʉ ããrĩpererã Opʉ, yʉ diaye gapʉ nírãrẽ ãsũ ãrĩ weregʉkoa: “Yʉpʉ mʉsãrẽ õãrõ irisiami. I ʉ̃mʉrẽ irigʉgueta mʉsãya ããrĩburire ĩgʉ̃yarãrẽ doreroguere ãmuyusiami. Irasirirã ĩgʉ̃ merã ããrĩrã́ aarika! ");
INSERT INTO sri_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉ ʉaboamakʉ̃ ĩãrã, mʉsã yʉre baari ejobʉ. Yʉ ñemesibumakʉ̃, mʉsã yʉre iiríri tĩãbʉ. Yʉ mʉsã pʉro gãmeñajãgʉ̃ ejamakʉ̃, yʉre kãrĩrõ wayubʉ. ");
INSERT INTO sri_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Surí marĩgʉ̃ yʉ ããrĩmakʉ̃ ĩãrã, mʉsã yʉre suríre sãbʉ. Pũrĩrikʉmakʉ̃, mʉsã yʉre ĩãrã ejabʉ. Peresugue yʉ ããrĩmakʉ̃dere yʉre ĩãrã ejabʉ”, ãrĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yʉ irasũ ãrĩmakʉ̃ pérã, yʉ diaye gapʉ nírã Yʉpʉ: “Õãrã, waja opamerã ããrĩ́ma”, ãrĩ ĩãnerã yʉre sẽrẽñarãkuma: “Gʉa Opʉ, ¿naásũ ããrĩmakʉ̃, mʉ ʉaboamakʉ̃ gʉa mʉrẽ baari ejori? ¿Naásũ ããrĩmakʉ̃, mʉ ñemesibumakʉ̃ mʉrẽ iiríri tĩãrĩ? ");
INSERT INTO sri_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Naásũ ããrĩmakʉ̃, mʉ gʉa pʉro gãmeñajãgʉ̃ ejamakʉ̃, kãrĩrõ wayuri? ¿Naásũ ããrĩmakʉ̃, mʉ surí marĩgʉ̃ ããrĩmakʉ̃ gʉa mʉrẽ surí sãrĩ? ");
INSERT INTO sri_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Naásũ ããrĩmakʉ̃, mʉ pũrĩrikʉmakʉ̃, o peresugue mʉ ããrĩmakʉ̃dere gʉa mʉrẽ ĩãrã ejari?” ãrĩrãkuma yʉre. ");
INSERT INTO sri_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, yʉ ããrĩpererã Opʉ, ĩgʉ̃sãrẽ ãsũ ãrĩ yʉjʉgʉkoa: “Diayeta mʉsãrẽ werea. Mʉsã sugʉ yaarã watopegue ããrĩpererã nemorõ ubu ããrĩgʉ̃́rẽ õãrõ irirã, yʉreta õãrõ irirã iribʉ”, ãrĩgʉkoa ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ĩgʉ̃sãrẽ irasũ ãrĩ odo, yʉ kúgapʉ nírãrẽ ãsũ ãrĩ weregʉkoa: “Yʉpʉ wajamoãsũmurã ããrã mʉsã. Yʉ pʉrore wirika! Perebiri peamegue waaka! Yʉpʉ iri peamerẽ wãtẽa opʉ, ĩgʉ̃yarã merã ããrĩburore ãmuyusiami. ");
INSERT INTO sri_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉ ʉaboamakʉ̃ ĩãrã, mʉsã yʉre baari ejobiribʉ. Yʉ ñemesibumakʉ̃, mʉsã yʉre iiríri tĩãbiribʉ. ");
INSERT INTO sri_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yʉ mʉsã pʉro gãmeñajãgʉ̃ ejamakʉ̃, yʉre kãrĩrõ wayubiribʉ. Surí marĩgʉ̃ yʉ ããrĩmakʉ̃, mʉsã yʉre surí sãbiribʉ. Yʉ pũrĩrikʉmakʉ̃, peresugue yʉ ããrĩmakʉ̃dere mʉsã yʉre ĩãrã ejabiribʉ”, ãrĩgʉkoa ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yʉ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã yʉre sẽrẽñarãkuma: “Gʉa Opʉ, ¿naásũ ããrĩmakʉ̃, mʉ ʉaboamakʉ̃, ñemesibumakʉ̃, gʉa pʉro gãmeñajãgʉ̃ ejamakʉ̃, surí opabirimakʉ̃, pũrĩrikʉmakʉ̃, peresugue mʉ ããrĩmakʉ̃ gʉa mʉrẽ iritamubiriri?” ãrĩrãkuma yʉre. ");
INSERT INTO sri_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, yʉ ããrĩpererã Opʉ ĩgʉ̃sãrẽ ãsũ ãrĩ weregʉkoa: “Diayeta mʉsãrẽ werea. Mʉsã sugʉ yaarã watopegue ããrĩpererã nemorõ ubu ããrĩgʉ̃́rẽ iritamumerã, yʉreta iritamumerã iribʉ”, ãrĩgʉkoa ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pʉrʉ ĩgʉ̃sã perebiri peamegue wajamoãsũrãkuma. Yʉpʉ: “Õãrã, waja opamerã ããrĩ́ma”, ãrĩ ĩãnerã gapʉ ĩgʉ̃ pʉrogue perebiri okarire oparãkuma, ãrĩ weremi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús iri ããrĩpererire bue odo, gʉare ĩgʉ̃ buerãrẽ ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Penʉ dʉyáa, pascua bosenʉ ejaburo. Irire mʉsã masĩa. Iri bosenʉ ããrĩmakʉ̃, yʉ ããrĩpererã tĩ́gʉ̃rẽ ñeã, oparãguere wiarãkuma, curusague pábiatú wẽjẽdoremurã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iripoere paía oparã, Moisés gojadeare buerimasã, judío masaka mʉrãde Caifás paía opʉya wii disipʉroma yebague nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Irogue nerẽrã, ĩgʉ̃sã Jesúre ãrĩgatori merã ñeã, wẽjẽburire ãmuñurã. ");
INSERT INTO sri_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Irire ãmurã́: —Bosenʉ ããrĩmakʉ̃, ĩgʉ̃rẽ ñeãbirikõãrã! Masaka marĩ merã guarã, marĩrẽ gainí turibokuma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ĩgʉ̃sã ĩgʉ̃rẽ wẽjẽburire ãmuripoere Jesús Betania wãĩkʉri makãgue Simón kãmi boadiya wiigue ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Irogue ĩgʉ̃ ããrĩmakʉ̃, sugo nomeõ suru sʉ̃rõdiru opago, Jesús pʉro ejamo. Igo opadiru “alabastro” wãĩkʉri ʉ̃tãye merã iridiru, sʉ̃rõrĩ wajapari opadiru ããrĩbʉ́. Jesús baa doaníripoe ĩgʉ̃ya dipurure iri sʉ̃rõrĩrẽ piupeomo. ");
INSERT INTO sri_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Igo irasũ piupeomakʉ̃ ĩãrã, gʉa Jesús buerã guarã ãsũ ãrĩbʉ: —¿Nasirigo igo irire irasiriwasiribéokõãrĩ? ");
INSERT INTO sri_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iri sʉ̃rõrĩrẽ duago, wáro niyerure wajataboakumo. Iri niyeru merã boporãrẽ iritamuboakumo, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús, gʉa irasũ ãrĩmakʉ̃ pégʉ, gʉare ãrĩmi: —¿Nasirirã igore garibori mʉsã? Ire yʉre irasirigo, õãrĩrẽ irigo yámo. ");
INSERT INTO sri_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Boporã mʉsã watopeguere ããrĩníkõãrãkuma. Yʉ tamerãrẽ mʉsã merã ããrĩnímakʉ̃ ĩãbirikoa. ");
INSERT INTO sri_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Igo i sʉ̃rõrĩ yʉre piupeogo, yaa dupʉre ĩgʉ̃sã yʉre yáaburo dupuyuro ãmuyugo irirosũ irigo yámo. ");
INSERT INTO sri_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Diayeta mʉsãrẽ werea. Marĩpʉ masakare tauri kerere wererã ããrĩperero i ʉ̃mʉgue waagorenarã, igo yʉre irideadere gajerãrẽ wererãkuma, igore gũñaburo, ãrĩrã, ãrĩmi Jesús gʉare. ");
INSERT INTO sri_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesús irasũ ãrãdero pʉrʉ, sugʉ gʉa Jesús buerã pe mojõma pere su gubu peru pẽrẽbejarã watopemʉ Judas Iscariote wãĩkʉgʉ paía oparã merã werenígʉ̃ waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ĩgʉ̃sãrẽ ãrĩyupʉ: —Yʉ Jesúre mʉsãrẽ wiamakʉ̃, ¿noópã niyeru wajarirãkuri yʉre? ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ treinta niyeru tiri plata merã iridea tirire wajariñurã. ");
INSERT INTO sri_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ĩgʉ̃sã wajarimakʉ̃, Judas: “¿Naásũ ããrĩmakʉ̃ ĩgʉ̃sãrẽ yʉ Jesúre wiamakʉ̃ õãkuri?” ãrĩ gũñayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pʉrʉ pã́ wemasãrĩ morẽña marĩrĩ baari bosenʉ pʉroririnʉ ããrĩmakʉ̃, gʉa Jesús buerã ĩgʉ̃ pʉrogue waa, ĩgʉ̃rẽ sẽrẽñabʉ: —¿Noógue mʉ pascua bosenʉ baaburire ãmumakʉ̃ gããmekuri? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ĩgʉ̃ gʉare ãrĩmi: —Jerusalẽ́gue waaka! Iro mʉsã bokajagʉre ãsũ ãrĩka: “Gʉare buegʉ mʉrẽ ãsũ ãrĩ weredoreami: ‘Yʉ ñerõ tariburo mérõgã dʉyáa. Pascua bosenʉ ããrĩmakʉ̃, yʉ buerã merã mʉya wiigue baagʉkoa’, ãrãmi”, ãrĩka! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Irasirirã, pascua bosenʉ ããrĩmakʉ̃, Jesús doreaderosũta gʉa baaburire ãmunerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naĩmejãripoe Jesús gʉa ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarã merã baa doaními. ");
INSERT INTO sri_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Gʉa baaripoe gʉare ãrĩmi: —Diayeta mʉsãrẽ werea. Sugʉ mʉsã watope ããrĩgʉ̃́ yʉre wẽjẽdʉarãguere yʉre ĩmugʉkumi, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa bʉro bʉjawereri merã sugʉno dita ĩgʉ̃rẽ sẽrẽñayobʉ: —Gʉa Opʉ, ¿yʉ ããrĩ́rĩ mʉrẽ ĩmubu? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Gʉa irasũ ãrĩ sẽrẽñamakʉ̃, gʉare yʉjʉmi: —Yʉ merã i pare pã́ yosa baagʉta ããrĩ́mi yʉre wẽjẽdʉarãguere yʉre ĩmubu. ");
INSERT INTO sri_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Marĩpʉya werenírĩ gojadea pũgue gojaderosũta yʉ ããrĩpererã tĩ́gʉ̃rẽ waaró yáa. Yʉre ĩmubu gapʉre ñetariro waarokoa. Ĩgʉ̃ deyoabirimakʉ̃ õãboyo, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Judas Jesúre wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmubu sẽrẽñami: —Gʉare buegʉ, ¿yʉ mʉrẽ ĩmubu ããrĩ́rĩ? ãrĩmi. Jesús ĩgʉ̃rẽ yʉjʉmi: —Ʉ̃́ʉ̃, mʉta ããrã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Irasũ ãrĩ odo, gʉa baaripoe Jesús pã́rẽ ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩ, pã́rẽ pea, gʉare ĩgʉ̃ buerãrẽ ãsũ ãrĩ gueremi: —Ire baaka! Yaa dupʉ ããrã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pʉrʉ iiríripare ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩ, gʉare iripare sĩu, ãsũ ãrĩmi: —Mʉsã ããrĩpererã ire iiríka! ");
INSERT INTO sri_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","I yaa dí ããrã. Yʉ boagʉ, dí béori merã wárã masaka ñerõ iridea wajare wajaribosagʉkoa. Irasirigʉ yaa dí béori merã Yʉpʉ ĩgʉ̃sãrẽ: “Õãrõ irigʉra”, ãrĩdeare iriyuwarikʉgʉkumi. Irasirigʉ ĩgʉ̃sã ñerõ irideare kãtigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mʉsãrẽ werea. Igui dekore marĩ dapora iirírosũ yʉ dupaturi neõ iirínemobirikoa. Pʉrʉ Yʉpʉ ĩgʉ̃yarãrẽ dorerogue mʉsã merã maama igui dekore iirígʉkoa, ãrĩmi Jesús gʉare. ");
INSERT INTO sri_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pʉrʉ Marĩpʉre bayapeo odo, gʉa iri wiigue ããrãnerã wiria, Olivos wãĩkʉri buúrugue waabʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Irogue ejagʉ, Jesús gʉare ãrĩmi: —Dapagã ñami mʉsã ããrĩpererã gũñaturaro marĩrõ yʉre béowãgãpereakõãrãkoa. Mʉsã irasiriburire Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Yʉ oveja koregʉre wẽjẽmakʉ̃ irigʉkoa. Irasirimakʉ̃, ĩgʉ̃yarã oveja ũmawasiriakõãrãkuma”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yʉ boadigue masãdero pʉrʉ, mʉsã dupuyuro Galileague waadupuyugʉkoa, ãrĩmi gʉare. ");
INSERT INTO sri_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ãsũ ãrĩ yʉjʉmi: —Gajerã ããrĩpererã mʉrẽ béowãgãkerepʉrʉ, yʉ gapʉ mʉrẽ neõ béowãgãbirikoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús Pedrore ãrĩmi: —Diayeta mʉrẽ werea. Dapagã ñami ãgãbo wereburo dupuyuro mʉ yʉre masĩkeregʉ, ʉrea gajerãrẽ: “Masĩbea”, ãrĩgatogʉkoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro ĩgʉ̃rẽ ãrĩmi: —Yʉ mʉ merã boabu ããrĩkeregʉ: “Masĩbea”, ãrĩgatobirikoa, ãrĩmi. Ããrĩpererã gʉa ĩgʉ̃ buerã, Pedro ĩgʉ̃ ãrĩrõsũta ãrĩbʉ Jesúre. ");
INSERT INTO sri_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pʉrʉ Jesús gʉa ĩgʉ̃ buerã merã waa, Getsemaní wãĩkʉrogue eja, gʉare ãrĩmi: —Õõta doaka mʉsã dapa! Sõõgue Marĩpʉre sẽrẽgʉ̃ waagʉ́ yáa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Irasũ ãrĩ odo, Pedrore, Zebedeo pũrã pẽrãguereta siiuwãgãmi. Ĩgʉ̃ bʉro gũñarikʉ, bʉjawereyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Irasũ bʉjaweregʉ, ĩgʉ̃ siiuwãgãnerãrẽ ãrĩyupʉ: —Bʉro bʉjawereri merã kõmoma goero péñakoa. Õõta dujaka! Mʉsãde yʉ kãrĩberosũta kãrĩmerãta yʉre yúka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Irasũ ãrĩ odo, yoaweyaro waanemo, yebague ĩgʉ̃ya diapure moomejã, Marĩpʉre ãsũ ãrĩ sẽrẽyupʉ: —Aʉ, yʉ ñerõ tariburire taudʉagʉ taumasĩa. Yʉ irasũ ãrĩkerepʉrʉ, yʉ gããmerõsũ iribirikõãka! Mʉ gããmerõsũ gapʉ yʉre waaburo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Irasũ ãrĩ sẽrẽ odo, ʉrerã ĩgʉ̃ buerã pʉrogue ejagʉ, ĩgʉ̃sã kãrĩrãrẽ bokaja, Pedrore ãrĩyupʉ: —¿Nasirirã su horanogãgora mʉsã yʉre kãrĩmerãta yúmasĩberi? ");
INSERT INTO sri_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kãrĩmerãta! Marĩpʉre sẽrẽka, wãtĩ ãrĩmesãrĩrẽ iribokoa, ãrĩrã! Mʉsã gũñarĩ merã õãrĩrẽ iridʉadáa. Irire iridʉakererã, bokatĩũbea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Irasũ ãrĩ odo, dupaturi waa, Marĩpʉre sẽrẽyupʉ doja: —Aʉ, i yʉ ñerõ tariburire taudʉabi, mʉ gããmerõsũ irika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pʉrʉ ĩgʉ̃ buerã ʉrerã pʉro dupaturi ejagʉ, kãrĩrãrẽta bokajayupʉ doja. Ĩgʉ̃sãrẽ wʉja pũrĩtariyuro. ");
INSERT INTO sri_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ĩgʉ̃sãrẽ ĩãkõã, dupaturi Marĩpʉre sẽrẽgʉ̃ waayupʉ doja. Ĩgʉ̃ sẽrẽaderosũta sẽrẽyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pʉrʉ ĩgʉ̃sã pʉro eja, ãrĩyupʉ: —¿Mʉsã siuñajã, kãrĩrã yári dapa? Yʉre ããrĩpererã tĩ́gʉ̃rẽ ñerãguere ĩgʉ̃sã wiari hora ejasiáa. ");
INSERT INTO sri_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wãgãnʉgãka! Náka, waarã́! Yʉre wẽjẽdʉarãguere yʉre ĩmubu aarisiami, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ĩgʉ̃ irasũ ãrĩ wereripoe Judas, gʉa Jesús buerã pe mojõma pere su gubu peru pẽrẽbejarã watopemʉ ããrãdi ejami. Wárã masaka sareri majĩrĩ, yukʉ dʉkari oparã ĩgʉ̃ merã ejama. Ĩgʉ̃sã paía oparã, judío masaka mʉrã ĩgʉ̃sã iriuanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ĩgʉ̃sã ejaburi dupuyuro Judas ĩgʉ̃sãrẽ Jesúre ĩmubu ãsũ ãrĩ weredi ããrĩmí: “Yʉ ĩgʉ̃ya wayupãrã mimigʉ̃ta ããrĩgʉkumi. Ĩgʉ̃rẽ ñeãka!” ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Irasirigʉ Jesús pʉro ejagʉ, ĩgʉ̃rẽ ãrĩmi: —Gʉare buegʉ, ¿ããrĩ́rĩ mʉ? ãrĩ, ĩgʉ̃ya wayupãrãrẽ mimimi. ");
INSERT INTO sri_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ĩgʉ̃ irasirimakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃rẽ ãrĩmi: —Yʉ merãmʉ, ¿nasirigʉ aarigʉ́ iriari? Mʉ irigʉra, ãrãdeare irika! ãrĩmi. Irasirirã masaka Jesús pʉro eja, ĩgʉ̃rẽ ñeãwãgãkõãma. ");
INSERT INTO sri_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ĩgʉ̃sã ĩgʉ̃rẽ ñeãwãgãripoe sugʉ ĩgʉ̃ buegʉ ĩgʉ̃ya sareri majĩrẽ tʉ̃ãwea ãĩ, paía opʉre moãboegʉya gãmipũrẽ dititá dijukõãmi. ");
INSERT INTO sri_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ĩgʉ̃ irasirimakʉ̃ ĩãgʉ̃, Jesús gapʉ ĩgʉ̃rẽ ãrĩmi: —Mʉya sareri majĩrẽ duripíkõãka! Sareri majĩ merã gajerã merã gãmewẽjẽrãno, sareri majĩ merãta wẽjẽsũrãkuma. ");
INSERT INTO sri_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mʉsã masĩberi? Yʉpʉre yʉ sẽrẽmakʉ̃, daporata ĩgʉ̃rẽ wereboerãrẽ pe mojõma pere su gubu peru pẽrẽbejari burigora yʉre iritamumurãrẽ iriubokumi. ");
INSERT INTO sri_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yʉ sẽrẽmakʉ̃, Marĩpʉya werenírĩ gojadea pũgue gojaderosũ waabiribokoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Irasũ ãrĩ odo, masakare ãrĩmi: —¿Nasirirã sareri majĩrĩ merã, yukʉ dʉkari merã sugʉ yajarimasʉ̃rẽ ñeãrã aarirã́ irirosũ yʉre ñeãrã aaríri? Ʉ̃mʉrikʉ Marĩpʉya wiigue yʉ mʉsãrẽ bue doanímakʉ̃, mʉsã yʉre neõ ñeãbiribʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Daporare i ããrĩpereri mʉsã yʉre irasirirã, Marĩpʉya kerere weredupuyunerã gojaderosũta irirã yáa, ãrĩmi Jesús. Ĩgʉ̃rẽ ñeãmakʉ̃ ĩãrã, gʉa ĩgʉ̃ buerã ĩgʉ̃rẽ sugʉreta ũmaweonúwãgãkõãbʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Irasirirã Jesúre ñeãnerã paía opʉ Caifáya wiigue ãĩãñurã. Iri wiiguere Moisés gojadeare buerimasã, judío masaka mʉrãde nerẽsiañurã. ");
INSERT INTO sri_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro gapʉ yoaweyaro Jesúre tʉyañajãa, Caifáya wii disipʉro ñajãrõma yebague eja, Marĩpʉya wiire korerã surara merã doayupʉ. “¿Naásũ iriyuwarikʉrãkuri?” ãrĩgʉ̃, irogue ĩã doaníyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paía oparã, judío masaka mʉrã, ããrĩpererã oparã irogue nerẽanerã Jesúre ãrĩgatori merã weresãmurãrẽ ãmarã́ iriñurã ĩgʉ̃rẽ wẽjẽmurã. ");
INSERT INTO sri_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ĩgʉ̃sã pʉrogue wárã masaka ãrĩgatori merã ĩgʉ̃rẽ weresãrã ejakererã: “Ĩgʉ̃ i ñerõ iridea waja boaburo”, ãrĩ weresãrĩrẽ neõ bokabiriñurã. Pʉrʉ gajerã pẽrã ĩgʉ̃rẽ ãrĩgatori merã weresãrã ejañurã. ");
INSERT INTO sri_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ãsũ ãrĩñurã: —Ĩĩ ãsũ ãrĩmi: “Marĩpʉya wiire béomasĩa. Ʉrenʉ waaró merãta iri wiire dupaturi iri odomasĩa”, ãrĩmi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, paía opʉ wãgãnʉgã, Jesúre ãrĩyupʉ: —¿Ĩgʉ̃sãrẽ yʉjʉberi mʉ? ¿Nasirirã mʉrẽ irasũ ãrĩ weresãrĩ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús gapʉ yʉjʉbiriyupʉ. Ĩgʉ̃ yʉjʉbirimakʉ̃ ĩãgʉ̃, paía opʉ ĩgʉ̃rẽ ãrĩyupʉ: —Marĩpʉ okanígʉ̃ péuro diaye wereka! ¿Mʉta ããrĩ́rĩ, Cristo Marĩpʉ magʉ̃? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Ĩgʉ̃ta ããrã mʉ ãrĩrõsũta. Idere mʉsãrẽ werea. Pʉrʉ yʉ ããrĩpererã tĩ́gʉ̃rẽ Yʉpʉ turagʉ diaye gapʉ doamakʉ̃ ĩãrãkoa. Ʉ̃mʉgasima mikãyebori weka yʉ aarimakʉ̃dere ĩãrãkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, paía opʉ ĩgʉ̃ guarire ĩmugʉ̃, ĩgʉ̃ya surírore tʉ̃ãyegue, ãsũ ãrĩyupʉ: —Ĩĩ irasũ ãrĩ werenígʉ̃, Marĩpʉre ñerõ ãrĩgʉ̃ yámi. ¿Nasirimurã gajerã ĩgʉ̃rẽ weresãrĩrẽ neõ pénemobokuri marĩ? Mʉsã, ĩgʉ̃ basita Marĩpʉre ñerõ ãrĩrĩrẽ pésiáa. ");
INSERT INTO sri_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Naásũ gũñarĩ? ãrĩyupʉ. —Marĩpʉre ĩgʉ̃ ñerõ ãrĩrĩ waja boaburo, ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Irasũ ãrĩ odo, ĩgʉ̃ diapure síku eotú, ĩgʉ̃rẽ doteñurã. Gajerã ĩgʉ̃ya diapure pá, ");
INSERT INTO sri_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ãsũ ãrĩñurã: —Mʉ Cristo ããrĩgʉ̃́, ãrĩbokaka: “¿Noã mʉrẽ pári?” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Iri wii poekague ĩgʉ̃sã irasiriripoere Pedro disipʉro ñajãrõma yebague doaníyupʉ. Ĩgʉ̃ irogue doamakʉ̃, sugo paía opʉre moãboego ĩgʉ̃ pʉro eja, ĩgʉ̃rẽ ãrĩyupo: —Mʉde Jesús Galileamʉ merã ããrĩdita ããrã, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Igo irasũ ãrĩmakʉ̃ pégʉ, Pedro ããrĩpererã iro ããrĩrã́ péurogue ãrĩgatori merã: —Mʉ irasũ ãrĩrĩrẽ pémasĩbirikoa yʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pʉrʉ iri wii tʉroma sãrĩrõ disipʉrogue waayupʉ. Irogue gajego ĩgʉ̃sãrẽ moãboego ĩgʉ̃rẽ ĩãgõ, iro ããrĩrã́rẽ ãrĩyupo: —Jesús Nazaretmʉ merã ããrĩdita ããrĩ́mi ĩĩ, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro ãrĩgatori merã dupaturi yʉjʉyupʉ: —Marĩpʉ péuro diayeta werea. Yʉ ĩgʉ̃rẽ masĩbea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mérõgã pʉrʉta masaka irogue ããrĩrã́ Pedro pʉrogue waa, ĩgʉ̃rẽ ãrĩñurã: —Mʉ diayeta Jesús buerã merãmʉta ããrã. Pémasĩrõta ĩgʉ̃sã irirosũ werenía, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Pedro yʉjʉyupʉ: —Marĩpʉ péuro diayeta werea. Yʉ mʉsãrẽ diaye werebirimakʉ̃, Marĩpʉ yʉre wajamoãburo. Ĩgʉ̃rẽ neõ masĩbea yʉ, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩripoeta ãgãbo wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pedro, ãgãbo weremakʉ̃ pégʉ, Jesús ĩgʉ̃rẽ: “Ãgãbo wereburo dupuyuro mʉ yʉre masĩkeregʉ, ʉrea: ‘Masĩbea’, ãrĩgatogʉkoa”, ãrãdeare gũñabokayupʉ. Irire gũñaboka, wiria, bʉjawereri merã bʉro oreyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Boyodujimejãripoe ããrĩpererã paía oparã, judío masaka mʉrã merã nerẽ: “Ãsũ iri, Jesúre wẽjẽrã”, ãrĩ ãmuñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Irasũ ãrĩ ãmu odo, Jesúre sia, ãĩwãgã, Poncio Pilato wãĩkʉgʉre Judea nikũ marã opʉre wiañurã. ");
INSERT INTO sri_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ĩgʉ̃sã Jesúre wẽjẽrãkuma, ãrĩrĩrẽ pégʉ, Judas gapʉ bʉro bʉjawereri merã ĩgʉ̃ Jesúre ĩmuadeare gũñayupʉ. Irasirigʉ treinta niyeru tiri plata merã iridea tiri ĩgʉ̃sã ĩgʉ̃rẽ wajaridea tirire paía oparãrẽ, judío masaka mʉrãrẽ wiagʉ waayupʉ. Irogue eja, ĩgʉ̃sãrẽ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Yʉ ñetariro iriakubʉ. Yʉ ñerĩ iribire oparãguere wiadire: “Boaburo”, ãrãñurã, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃rẽ yʉjʉñurã: —Mʉ irasiriadea gʉaya meta ããrã. Mʉya ããrã, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Judas Marĩpʉya wiigue niyeru tirire meéwasiribéo, waakõãyupʉ. Waa, pũgubudare siasiu, ĩgʉ̃ basi ĩgʉ̃ya wʉ̃́nugũrẽ túsãnú, parimadija, boakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Paía oparã niyeru tirire sea neeõrã, ãsũ ãrĩñurã: —I niyeru ĩgʉ̃sã masakʉre wẽjẽburi waja wajariadea ããrã. Irasirirã i niyerure Marĩpʉya wiima duripíri kũmague pímasĩbirikoa. Marĩrẽ doreri irasiridorebea, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pʉrʉ ãsũ ãrĩñurã: “I niyeru merã diiari sorori weagʉya nikũrẽ wajarimakʉ̃ õãrokoa. Irasirirã gajero marã õõgue boamakʉ̃, iri nikũ ĩgʉ̃sãrẽ yáaburi nikũ ããrĩrokoa”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Irasirirã masaka iri nikũrẽ: “Dí béodea nikũ ããrã”, ãrĩ wãĩyema. Daporaguedere irasũta wãĩkʉkõãa. ");
INSERT INTO sri_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ĩgʉ̃sã irasirimakʉ̃, Jeremías Marĩpʉya kerere weredupuyudi gojaderosũta waabʉ. Ãsũ ãrĩ gojadi ããrĩmí: “Israel bumarã treinta niyeru tiri plata merã iridea tirire ĩgʉ̃rẽ wajarideare ãĩma. ");
INSERT INTO sri_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Irasirirã iri tiri merã diiari sorori weagʉya nikũrẽ wajarima. Irasirirã, Marĩpʉ yʉre: ‘Ãsũ irirãkuma’, ãrĩ gojadorederosũta yáma”, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pilato, Jesúre ĩgʉ̃ pʉrogue ĩgʉ̃sã ãĩjamakʉ̃, ĩgʉ̃rẽ sẽrẽñayupʉ: —¿Mʉta ããrĩ́rĩ judío masaka Opʉ? ãrĩyupʉ. —Mʉ ãrĩrõsũta ĩgʉ̃ta ããrã, ãrĩ yʉjʉyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Paía oparã, judío masaka mʉrã ĩgʉ̃rẽ weresãrĩ gapʉre yʉjʉbiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Irasirigʉ Pilato ĩgʉ̃rẽ ãrĩyupʉ: —¿Ããrĩpereri ĩgʉ̃sã mʉrẽ weresãrĩrẽ péberi mʉ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús gapʉ neõ yʉjʉbiriyupʉ. Ĩgʉ̃ yʉjʉbirimakʉ̃ ĩãgʉ̃, Pilato ĩãgʉkakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bojorikʉ pascua bosenʉ ããrĩmakʉ̃, Pilato sugʉ peresugue ããrĩgʉ̃́rẽ masaka wiudoregʉre wiunayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Iripoere sugʉ Barrabás wãĩkʉgʉ peresugue ããrĩyupʉ. Masaka ĩgʉ̃ ñerõ irideare masĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Irasirigʉ ĩgʉ̃sã nerẽmakʉ̃ ĩãgʉ̃, Pilato ĩgʉ̃sãrẽ sẽrẽñayupʉ: —¿Nií gapʉre yʉ wiumakʉ̃ gããmerĩ mʉsã? ¿Barrabáre, o Jesús: “Cristo” ĩgʉ̃sã ãrĩgʉ̃ gapʉre? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wárã masaka Jesúre bʉremumakʉ̃ ĩãrã, oparã ĩgʉ̃rẽ ĩãturisĩã, Pilato pʉrogue ãĩãnerã ããrĩmá. Pilato gapʉ ĩgʉ̃sã ĩãturirire masĩkõãyupʉ. Irasirigʉ Jesúre wiudʉadiyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pʉrʉ Pilato masaka weresãrĩrẽ beyerimasʉ̃ doarogue doaripoe, ĩgʉ̃ marãpo ĩgʉ̃rẽ kere iriuyupo: “Ĩgʉ̃ diayema irigʉre gajerosũ neõ iribirikõãka! Dapagã ñami ĩgʉ̃rẽ waaburire bʉro goero kẽãkubʉ”, ãrĩ kere iriuyupo. ");
INSERT INTO sri_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Paía oparã, judío masaka mʉrã gapʉ masakare ãsũ ãrĩdoreñurã: “‘Barrabáre wiuka, Jesús gapʉre wẽjẽka!’ ãrĩka!” ãrĩdoreñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pʉrʉ Pilato masakare dupaturi sẽrẽñayupʉ doja: —¿Ĩgʉ̃sã pẽrãrẽ nií gapʉre yʉ wiumakʉ̃ gããmerĩ mʉsã? ãrĩyupʉ. —Barrabás gapʉre wiuka! ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pilato sẽrẽñayupʉ: —¿Nasirigʉkuri yʉ, ĩĩ Jesús: “Cristo” ĩgʉ̃sã ãrĩgʉ̃ gapʉre? ãrĩyupʉ. Ããrĩpererã: —Curusague pábiatú wẽjẽka ĩgʉ̃rẽ! ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Irasirigʉ Pilato ãsũ ãrĩyupʉ: —¿Ñeéno ñerĩrẽ iriari ĩĩ, mʉsã irasũ ãrĩmakʉ̃? ãrĩyupʉ. Masaka gapʉ dupaturi gainínemoñurã: —Curusague pábiatú wẽjẽka ĩgʉ̃rẽ! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ĩgʉ̃sã ĩgʉ̃rẽ pédʉabirimakʉ̃, ĩgʉ̃sã guari merã gainímakʉ̃ pégʉ, Pilato dekore ãĩwãgãridoreyupʉ. Iri merã masaka ĩũrõ mojõkoe, ãsũ ãrĩyupʉ: —Ĩĩrẽ waja opabire wẽjẽdoreri, yʉ doreri meta ããrã. Mʉsã doreri ããrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ããrĩpererã masaka ãsũ ãrĩñurã: —Gʉa mʉrẽ ĩĩrẽ wẽjẽdoreri waja, gʉa, gʉa pũrã ããrĩpererã merã waja oparãkoa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pilato Barrabáre peresugue ããrĩgʉ̃́rẽ wiuyupʉ. Pʉrʉ surarare Jesúre tãrãdore, ĩgʉ̃rẽ ĩgʉ̃sãrẽ wiayupʉ, ĩgʉ̃rẽ curusague pábiatú wẽjẽdoregʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Irasirirã surara Jesúre Pilatoya wiima yebague ãĩjañurã. Irogue ããrĩpererã surarare Jesús pʉro neeõñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pʉrʉ ĩgʉ̃ya surírore túwea ãĩ, opʉya suríro irirosũ deyoriñe diiariñerẽ ĩgʉ̃rẽ sãñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pora merã iriadea berore ĩgʉ̃ya dipurure peoñurã. Irasiri odo, yukʉre diaye gapʉ moãsua, ĩgʉ̃ pʉro ñadʉkʉpuri merã ejamejã, ĩgʉ̃rẽ ãsũ ãrĩ bʉridañurã: —Bʉremurã aarika judío masaka Opʉre! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ĩgʉ̃rẽ síku eotú, ĩgʉ̃sã moãsuadire tʉ̃ãwea ãĩ, irigʉ merãta ĩgʉ̃ya dipurure pánañurã. ");
INSERT INTO sri_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ĩgʉ̃rẽ bʉrida odo, ĩgʉ̃sã sãdea surírore túwea, ĩgʉ̃ya suríro gapʉre sãñurã doja. Sã odo, curusague pábiatú wẽjẽmurã ĩgʉ̃rẽ ãĩ wiriakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ĩgʉ̃sã ĩgʉ̃rẽ ãĩwãgãrã, sugʉ masakʉre Simón wãĩkʉgʉ Cirenemʉrẽ bokatĩrĩma. Ĩgʉ̃rẽ Jesús kõãdea curusare kõãdorema. ");
INSERT INTO sri_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ĩgʉ̃rẽ irasũ ãĩwãgãrã, Gólgota wãĩkʉrogue ãĩjama. “Gólgota”, ãrĩrõ: “Masakʉ dipuru boaweadea pero”, ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Irogue eja, igui deko sʉ̃ĩrĩ merã morẽdeare Jesúre tĩãdima. Jesús irire iiríña, pʉrʉ iiríbirimi. ");
INSERT INTO sri_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ĩgʉ̃rẽ curusague pábiatú ãĩwãgũnú odo, surara ĩgʉ̃ surí sãñadeare: “Ubu ãrĩboka birarã: ‘¿Noãrẽ dujarokuri?’” ãrĩma, irire ĩgʉ̃sã basi gãme dʉkawamurã. Ĩgʉ̃sã irasirirã, Marĩpʉya kerere weredupuyudi gojaderosũta irima. Ãsũ ãrĩ gojadi ããrĩmí: “Yaa suríre ĩgʉ̃sã basi ãrĩboka bira dʉkawarãkuma”, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Irasiriadero pʉrʉ, surara curusa pʉro eja doama, Jesúre korerã. ");
INSERT INTO sri_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","“Ĩĩ ãsũ iridea waja boami”, ãrĩrã: “Ĩĩta judío masaka Opʉ ããrĩ́mi”, ãrĩ gojadea majĩrẽ curusague Jesúya dipuru weka pábiatúma. ");
INSERT INTO sri_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pẽrã yajarimasãdere curusarigue pábiatú ãĩwãgũnúma. Sugʉre ĩgʉ̃ diaye gapʉ, gajigʉre ĩgʉ̃ kúgapʉ pábiatú ãĩwãgũnúma. ");
INSERT INTO sri_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Masaka Jesús pʉro tariwãgãnarã, ñerõ ãrĩ bʉrida, ĩgʉ̃sãya dipure yure, ãrĩma: ");
INSERT INTO sri_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Mʉ ãsũ ãrĩ wereníbʉ: “Marĩpʉya wiire béo, pʉrʉ ʉrenʉ waaró merãta iri wiire dupaturi iri odogʉkoa”, ãrĩbʉ. Irasirigʉ mʉ basi tauka! Mʉ diayeta Marĩpʉ magʉ̃ ããrĩgʉ̃́, curusague merã dijarika! ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Irasũta paía oparã, Moisés gojadeare buerimasã, fariseo bumarã, judío masaka mʉrãde ãrĩ bʉridama. Ãsũ ãrĩ gãme wereníma: ");
INSERT INTO sri_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Gajerã gapʉre taumi. Ĩgʉ̃ basi gapʉ taumasĩbemi. “Israel bumarã Opʉ ããrã”, ãrĩmi. Irasirirã, curusague merã ĩgʉ̃ dijarimakʉ̃ ĩãrã, marĩ ĩgʉ̃rẽ bʉremurãkoa. ");
INSERT INTO sri_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ĩgʉ̃: “Marĩpʉre bʉremua, ĩgʉ̃ magʉ̃ ããrã”, ãrĩmi. Irasirigʉ ĩgʉ̃ ãrĩderosũta Marĩpʉ ĩgʉ̃rẽ maĩgʉ̃, iritamuburo, ãrĩ bʉridama. ");
INSERT INTO sri_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yajarimasã Jesús pʉro curusarigue pábiatú ãĩwãgũnúsũanerãde irasũta ĩgʉ̃rẽ ñerõ ãrĩ bʉridama. ");
INSERT INTO sri_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Goeripoe ããrĩmakʉ̃, i nikũ ããrĩpererogue naĩtĩãkõãbʉ. Ʉre hora gora naĩtĩãbʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ʉre hora ejamakʉ̃ta Jesús bʉro gainími: —Elí, Elí, ¿lama sabactani? ãrĩmi. Irasũ ãrĩgʉ̃: “Yʉ Opʉ, yʉ Opʉ, ¿nasirigʉ yʉre béori mʉ?” ãrĩgʉ̃ irimi. ");
INSERT INTO sri_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Surãyeri irogue ããrĩrã́, ĩgʉ̃ irasũ ãrĩ gainímakʉ̃ pérã: —Marĩpʉya kerere weredupuyudire Elíare siiugʉ yámi, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mata sugʉ ĩgʉ̃sã merãmʉ ũmawãgã, igui deko piari yosadea yʉsʉre yukʉ yuwague siatú, ãĩwãgã, Jesúre iiríburo, ãrĩgʉ̃, soemuúmi. ");
INSERT INTO sri_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ĩgʉ̃ irasirimakʉ̃ ĩãrã, gajerã gapʉ ãsũ ãrĩma: —Iropãta irika! Elías ĩgʉ̃rẽ taugʉ aarimakʉ̃ ĩãñarã dapa marĩ, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús dupaturi bʉro gainínemo, kõmoakõãmi. ");
INSERT INTO sri_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ĩgʉ̃ kõmomakʉ̃ta, Marĩpʉya wii poekama taribu disipʉro kãmutari gasiro ʉ̃marõ gapʉ merã yegue dijari, deko merã yeguesiajayuro. Nikũ bʉro ñomebʉ. Ʉ̃tãyeri pagayeride waariakõãbʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Masãgoberi tũpãkõãyuro. Wárã Marĩpʉre bʉremurã boanerã masãñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús masãdero pʉrʉ, ĩgʉ̃sã masãgoberigue ããrĩnerã wiria, Marĩpʉya makãgue Jerusalẽ́gue waañurã. Ĩgʉ̃sã irogue ejamakʉ̃, masaka wárã ĩgʉ̃sãrẽ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Romano marã surara opʉ ĩgʉ̃yarã surara merã Jesúre koreanerã, nikũ ñomemakʉ̃, ããrĩpereri irasũ waaríre ĩãrã, bʉro gʉka, güiri merã ãsũ ãrĩma: —Ĩĩ diayeta Marĩpʉ magʉ̃ ããrãdañumi, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wárã nome yoaweyarogue Jesúre ĩũníma. Ĩgʉ̃sã Galileague Jesúre iritamugorenanerã nome ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ĩgʉ̃sã nome watopeguere María Magdalena wãĩkʉgo, gajego María wãĩkʉgo Santiago, José pago, gajego Zebedeo marãpo ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pʉrʉ naĩmejãripoe ããrĩmakʉ̃, José wári opagʉ, Arimatea wãĩkʉri makãmʉ irogue ejami. Ĩgʉ̃ Jesús buerire tʉyagʉ ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Irasirigʉ Pilato pʉrogue waa, Jesúya dupʉre yáabu sẽrẽyupʉ. Ĩgʉ̃ ãrĩ sẽrẽmakʉ̃ pégʉ, Pilato surarare Jesúya dupʉre sĩdoreyupʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Irasirigʉ José waa, Jesúya dupʉre ãĩdiju, õãrĩ suríro gasiro gʉrari marĩrĩ gasiro merã ĩgʉ̃ya dupʉre õmayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Õma odo, ĩgʉ̃rẽ yáabodea masãgobegue píyupʉ. Iri gobe, maama gobe ʉ̃tãyegue mádea gobe ããrĩyuro. Irogue Jesúya dupʉre pí odo, wári majĩ ʉ̃tã majĩ merã iro ñajãrõrẽ õãrõ biakõã, waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ĩgʉ̃ irasiriripoe María Magdalena, gajego María merã iri gobe bokatĩũrõ ĩũdoaníñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gajinʉ gapʉ judío masaka siuñajãrĩnʉ ããrĩmakʉ̃, paía oparã, fariseo bumarã Pilato pʉrogue waañurã. ");
INSERT INTO sri_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ãsũ ãrĩñurã Pilatore: —Gʉa opʉ, sõõ ããrĩdi okagʉgue ãrĩgatorikʉgʉ ãrĩdeare gʉa gũñáa. Ãsũ ãrĩmi: “Yʉ boa, ʉrenʉ pʉrʉ masãgʉkoa”, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Irasirigʉ mʉyarã surarare ʉrenʉgora ĩgʉ̃ya dupʉre píaderogue koredoregʉ iriuka, ĩgʉ̃ buerã ñami merã ĩgʉ̃ya dupʉre yajabirikõãburo, ãrĩgʉ̃! Ĩgʉ̃sã yajadero pʉrʉ masakare: “Jesús boadigue masãkõãmi”, ãrĩbokuma. Irasiriro ĩgʉ̃ ãrĩgatodea nemorõ ĩgʉ̃sã ãrĩgatori gapʉ ñetarirokoa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Pilato yʉjʉyupʉ: —Jáʉ, ĩĩsã yaarã surara õõgue ããrĩ́ma. Ĩgʉ̃sãrẽ ãĩaka, iri masãgobe gajerosũ waari, ãrĩrã! Irasirirã mʉsã bokatĩũrõ ĩgʉ̃sãrẽ koredoreka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃sã waa, iri gobe biadea ʉ̃tã majĩrẽ õãrõ wĩtãbiatoñurã, masaka ĩgʉ̃sã ñajãdeare ĩãmasĩrãra, ãrĩrã. Irasũ ããrĩmakʉ̃, surarare iri gobere õãrõ koredoreñurã. ");
INSERT INTO sri_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judío masaka siuñajãrĩnʉ pʉrʉ, gajinʉ boyodujimejãripoe gaji semana ñajãrĩnʉ ããrĩmakʉ̃, María Magdalena, gajego María merã Jesúre pídea gobere ĩãrã waañurã. ");
INSERT INTO sri_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gũñaña marĩrõ nikũ bʉro ñomeyuro. Irasũ waaripoe marĩ Opʉre wereboegʉ ʉ̃mʉgasigue merã dijari, masãgobere ĩgʉ̃sã biadea ʉ̃tã majĩrẽ tũpã, iri majĩ weka doayupʉ. ");
INSERT INTO sri_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ĩgʉ̃ bupu miãrõsũ õãrõ gosewasirigʉ ããrĩyupʉ. Ĩgʉ̃ya suríro õãrõ borero ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Surara iri gobere koreanerã ĩgʉ̃rẽ ĩãrã, bʉro güiri merã narada, kõmorã irirosũ waañurã. ");
INSERT INTO sri_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pʉrʉ Marĩpʉre wereboegʉ irogue ĩãrã waanerã nomerẽ ãrĩyupʉ: —Güibirikõãka! Yʉ masĩa, mʉsã Jesús ĩgʉ̃sã curusague pábiatú wẽjẽadire ãmarã́ yáa. ");
INSERT INTO sri_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ĩgʉ̃ õõrẽ mámi. Ĩgʉ̃ ãrĩderosũta masãsiami. Ĩgʉ̃ya dupʉre ĩgʉ̃sã píaderore ĩãrã aarika! ");
INSERT INTO sri_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pʉrʉ mumurõ merã ĩgʉ̃ buerãrẽ: “Ĩgʉ̃ boadi ããrĩkeregʉ, masãmi. Mʉsã dupuyuro Galileague waagʉkumi. Irogue ĩgʉ̃rẽ ĩãrãkoa”, ãrĩ wererã waaka! Irire mʉsãrẽ weregʉ aarigʉ́ iriabʉ, ãrĩyupʉ Marĩpʉre wereboegʉ. ");
INSERT INTO sri_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, masãgobere ĩãrã waanerã nome güikererã, mumurõ merã ʉsʉyari merã Jesús buerãrẽ wererã ũmadujáañurã. ");
INSERT INTO sri_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ĩgʉ̃sã ũmadujáarã nomerẽ Jesús ĩgʉ̃sãrẽ bokatĩrĩ, õãdoreyupʉ. Ĩgʉ̃rẽ ĩãrã, ĩgʉ̃ pʉro ñadʉkʉpuri merã ejamejã, ĩgʉ̃ya guburire ñeã, ĩgʉ̃rẽ bʉremuñurã. ");
INSERT INTO sri_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —Güibirikõãka! Yaarã yʉ buerãrẽ: “Galileague waaka!” ãrĩ wererã waaka! Irogue yʉre ĩãrãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ĩgʉ̃sã nome Jesús buerãrẽ wererã waaripoe surãyeri surara masãgobere koreanerã Jerusalẽ́gue waañurã. Irogue eja, paía oparãrẽ ããrĩpereri masãgobegue waadeare werepeokõãñurã. ");
INSERT INTO sri_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ĩgʉ̃sã irasũ ãrĩ weremakʉ̃ pérã, paía oparã, judío masaka mʉrã merã nerẽñurã. Irasirirã ĩgʉ̃sã: “¿Nasirirãkuri?” ãrĩ ãmu odo, surarare wáro niyerure sĩ, ");
INSERT INTO sri_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ãsũ ãrĩñurã: —Masakare ãsũ ãrĩka: “Ñami merã gʉa kãrĩripoe Jesús buerã masãgobegue eja, ĩgʉ̃ya dupʉre yajakõãnerã ããrãma”, ãrĩka! ");
INSERT INTO sri_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilato mʉsã irasũ ãrĩ kerere pémakʉ̃, gʉa ĩgʉ̃ merã werenírãkoa, mʉsãrẽ wajamoãbirikõãburo, ãrĩrã, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, surara niyerure ñeã, waakõãñurã. Pʉrʉ paía oparã ĩgʉ̃sãrẽ weredoreaderosũta gajerãrẽ wereñurã. Irasirirã, ĩgʉ̃sã irasũ ãrĩrĩ kerere wárã judío masaka pénerã ããrĩmá. Daporaguedere ĩgʉ̃sã ãrĩgatodeare bʉremukõãma dapa. ");
INSERT INTO sri_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pʉrʉ gʉa Jesús buerã pe mojõma pere su gubu suru pẽrẽbejarã Galileague waa, buúrugue ĩgʉ̃ gʉare waadoredea buúrugue waabʉ. ");
INSERT INTO sri_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Irogue eja, Jesúre ĩãrã, ĩgʉ̃rẽ bʉremubʉ. Surãyeri gʉa merã waanerã gapʉ: “¿Ĩgʉ̃ta ããrĩkuriye ĩĩ?” ãrĩ gũñama. ");
INSERT INTO sri_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Irasirigʉ Jesús gʉa pʉro aari ejanʉgã, ãsũ ãrĩmi: —Yʉpʉ yʉre ããrĩpererogue i nikũ, ʉ̃mʉgasiguedere dorebure sóosiami. ");
INSERT INTO sri_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Irasirirã ããrĩpereri buri marã masakare yaa kerere buerã waaka, ĩgʉ̃sãde mʉsã irirosũta yaa buerire tʉyaburo, ãrĩrã! Yʉpʉ wãĩ merã, yʉ wãĩ merã, Õãgʉ̃ deyomarĩgʉ̃ wãĩ merã ĩgʉ̃sãrẽ deko merã wãĩyeka! ");
INSERT INTO sri_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ããrĩpereri yʉ mʉsãrẽ doredeare ĩgʉ̃sãrẽ bueka, irire iriburo, ãrĩrã! Ire masĩka mʉsã! Yʉ mʉsã merã ããrĩníkõãgʉkoa. I ʉ̃mʉ pereadero pʉrʉguedere mʉsã merã ããrĩníkõãgʉkoa, ãrĩ weremi gʉare Jesús. Iropãta ããrã.");
INSERT INTO sri_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Marĩpʉ magʉ̃ Jesucristoya kere wereri, ãsũ nʉgãdero ããrĩbʉ́: ");
INSERT INTO sri_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Iripoegue Isaías Marĩpʉya kerere weredupuyudi, Marĩpʉ ĩgʉ̃ magʉ̃rẽ ãrĩdeare gojadi ããrĩmí. Marĩpʉ ĩgʉ̃ magʉ̃rẽ ãsũ ãrĩdi ããrĩmí: Mʉ waaburo dupuyuro yaa kerere weredupuyubure iriugʉkoa, mʉ waaburore ãmuyudoregʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ĩgʉ̃ masaka marĩrõgue bʉro gainírĩ merã ãsũ ãrĩ weregʉkumi: “Marĩ Opʉ aariburi dupuyuro ĩgʉ̃ aariburi maarẽ́ diayema maa õãrĩ maa ãmurã́ irirosũ diayemarẽ irika!” ãrĩ gainígʉkumi, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Irasirigʉ Juan masaka marĩrõgue masakare wãĩyepʉroriwãgãrigʉ, ãsũ ãrĩ werenayupʉ ĩgʉ̃sãrẽ: —Mʉsã ñerõ irideare bʉjawereka! Mʉsã gũñarĩrẽ gorawayuka! Deko merã wãĩyesũanerã dujaka! Irasirirã mʉsã ñerõ irideare kãtisũrãkoa. ");
INSERT INTO sri_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ããrĩpererã Judea nikũ marã, Jerusalén marãde ĩgʉ̃ wererire pérã ejañurã. Ĩgʉ̃sã ñerõ irideare Marĩpʉre weretaripeomakʉ̃ ĩãgʉ̃, Juan ĩgʉ̃sãrẽ dia Jordán wãĩkʉdiyague wãĩyeyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juãya surí camellua poari merã suadea ããrĩyuro. Ĩgʉ̃ya yʉjʉwẽñarĩda waibʉ gasiro merã irideada ããrĩyuro. Poreroa, mume makãnʉ́ʉ marãyare baarikʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Masakare ãsũ ãrĩ werenayupʉ: —Gajigʉ yʉ pʉrʉ aaribu, yʉ nemorõ turagʉ ããrĩ́mi. Yʉ gapʉ ubu ããrĩgʉ̃́, ĩgʉ̃rẽ neõ sʉropebirikoa. ");
INSERT INTO sri_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yʉ mʉsãrẽ deko merã wãĩyea. Ĩgʉ̃ gapʉ Õãgʉ̃ deyomarĩgʉ̃ merã wãĩyegʉkumi. Irasirigʉ Õãgʉ̃ deyomarĩgʉ̃ mʉsã merã ããrĩníkõãgʉkumi mʉsãrẽ iritamubu, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Iripoere Jesús Galilea nikũma makã, Nazaret wãĩkʉri makãgue ããrãdi, Juan pʉrogue ejayupʉ. Ĩgʉ̃ ejamakʉ̃, Juan ĩgʉ̃rẽ dia Jordán wãĩkʉdiyague wãĩyeyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ĩgʉ̃ wãĩye odomakʉ̃, Jesús diague ããrãdi majãnʉgãgʉ̃ta ʉ̃mʉgasi tũpãmakʉ̃ ĩãyupʉ. Õãgʉ̃ deyomarĩgʉ̃ buja irirosũ deyogʉ ĩgʉ̃ weka dijariyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Irasũ waaripoe Marĩpʉ ʉ̃mʉgasigue merã Jesúre ãsũ ãrĩ wereníyupʉ: —Mʉ yʉ magʉ̃, yʉ maĩgʉ̃ ããrã. Mʉ merã bʉro ʉsʉyáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesúre Juan wãĩyeri pʉrʉgãta Õãgʉ̃ deyomarĩgʉ̃ masaka marĩrõgue ãĩayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Irasirigʉ Jesús irogue waa, cuarenta nʉrĩgora makãnʉ́ʉ marã waimʉrã guarã watopegue ããrĩyupʉ. Ĩgʉ̃ irogue ããrĩmakʉ̃, wãtẽa opʉ Satanás wãĩkʉgʉ ĩgʉ̃rẽ ãrĩmesãdiyupʉ. Marĩpʉre wereboerã ĩgʉ̃rẽ iritamurã ejañurã. ");
INSERT INTO sri_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Herodes Juãrẽ peresugue sóodobodero pʉrʉ, Jesús Galilea nikũgue masakare Marĩpʉya kerere weregorenagʉ̃ wãgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ãsũ ãrĩ werenayupʉ: —Marĩpʉ iripoegue: “Ãsũ waarokoa”, ãrĩdea ejasiáa. Daporare mérõgã dʉyáa, ĩgʉ̃yarãrẽ doreri ejaburo. Irasirirã mʉsã ñerõ iririre bʉjawereka! Mʉsã gũñarĩrẽ gorawayuka! Ĩgʉ̃ masakare tauri kere gapʉre bʉremuka! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pʉrʉ Jesús Galilea wãĩkʉri ditaru tʉro waagʉ́, Simṍrẽ, ĩgʉ̃ pagʉmʉ Andrére bokajayupʉ. Ĩgʉ̃sã waaí wẽjẽrĩmasã ããrĩsĩã, ditarugue ĩgʉ̃sãya buidire meéyorã iriñurã. ");
INSERT INTO sri_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —Náka, yʉ merã! Daporare mʉsãrẽ waaí wẽjẽrĩmasã ããrĩrĩ́rẽ piri, masakare Marĩpʉya kerere wererimasã ããrĩmakʉ̃ irigʉkoa. ");
INSERT INTO sri_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, mata ĩgʉ̃sãya buiriyukure irota píkõã, ĩgʉ̃ merã waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pʉrʉ Jesús yoaweyaro waa, Zebedeo pũrã Santiagore, ĩgʉ̃ pagʉmʉ Juãrẽ doódirugue ĩgʉ̃sãya buiriyukure ãmu sãñanímakʉ̃ ĩãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús ĩgʉ̃sãrẽ siiuyupʉ. Ĩgʉ̃ siiumakʉ̃ pérã: “Jáʉ”, ãrĩ, ĩgʉ̃sãya doódirugue ĩgʉ̃sã pagʉ Zebedeore, ĩgʉ̃rẽ iritamurã merã pí, Jesús merã waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ĩgʉ̃ merã waa, Capernaum wãĩkʉri makãgue ejañurã. Irogue judío masaka siuñajãrĩnʉ ããrĩmakʉ̃, Jesús ĩgʉ̃sã nerẽrĩ wiigue ñajãa, masakare buenʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Moisés gojadeare buerimasã irirosũ buebiriyupʉ. Õãrõ doreri opagʉ irirosũta bueyupʉ. Ĩgʉ̃ irasũ buemakʉ̃ pérã, pégʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Iri wiiguere ĩgʉ̃sã merã sugʉ wãtĩ ñajãsũdi ããrĩyupʉ. Ãsũ ãrĩ gainíyupʉ: ");
INSERT INTO sri_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús Nazaretmʉ, ¿nasiribu gʉa pʉro aaríri? ¿Gʉare peamegue béogʉ aarigʉ́ yári? Yʉ mʉrẽ ĩãmasĩkõãa. Mʉ, Mʉpʉ iriudi, õãtarigʉ ããrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús wãtĩrẽ: —Wereníbita! Wirika ĩgʉ̃rẽ! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, wãtĩ masakʉre meémejã, naradamakʉ̃ iri, bʉro gainí, wiriakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jesús wãtĩrẽ béowiumakʉ̃ ĩãrã, ããrĩpererã masaka ĩãgʉka, ĩgʉ̃sã basi ãsũ ãrĩ gãme sẽrẽñañurã: —¿Ñeéno ããrĩ́rĩ, ñeéno maama bueri ããrĩ́rĩ i? Ĩĩ wãtẽãrẽ ĩgʉ̃ turaro merã wiridoremakʉ̃, neõ ĩgʉ̃rẽ tarinʉgãbema, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mérõgã pʉrʉta ããrĩperero Galilea nikũ marã Jesús iriadea kerere péseyakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús nerẽrĩ wiigue ããrãdi Santiago, Juan merã wiria, Simón, Andréya wiigue waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón mʉ́ñekõ bʉro nimakʉrikʉgo peyarogue oyayupo. Irasirirã Jesúre: “Sĩrĩgõ yámo”, ãrĩ wereñurã. ");
INSERT INTO sri_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Irasũ ãrĩmakʉ̃ pégʉ, Jesús igo pʉro ejanʉgã, igoya mojõrẽ ñeã tʉ̃ãwãgũnúmakʉ̃ta nimakʉri tariakõãyuro. Iri tarimakʉ̃, ĩgʉ̃sãrẽ baari ejoyupo. ");
INSERT INTO sri_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Abe ñajãdero pʉrʉ naĩmejãripoe iri makã marã ããrĩpererã pũrĩrikʉrãrẽ, wãtẽa ñajãsũnerãdere Jesús pʉrogue ãĩjañurã. ");
INSERT INTO sri_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Irasirirã ããrĩpererã iri makã marã ĩgʉ̃ ããrĩrĩ́ wii disipʉrogue nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús wárã pũrĩrikʉrãrẽ tauyupʉ. Wárã wãtẽa masakare ñajãnerãdere béowiuyupʉ. Wãtẽa, Jesús Marĩpʉ magʉ̃ ããrĩrĩ́rẽ masĩñurã. Irasirigʉ Jesús: “Werenímerãta!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesús gajinʉ gapʉ naĩtĩãweyaripoegãta yobe, iri makã tʉro masaka marĩrõgue Marĩpʉre sẽrẽgʉ̃ waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón, ĩgʉ̃ merãmarã merã Jesús marĩmakʉ̃ ĩãgʉ̃, ĩgʉ̃rẽ ãmagʉ̃́ waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ĩgʉ̃rẽ bokagʉ: —Ããrĩpererã masaka mʉrẽ ãmarã́ iriama, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús ãsũ ãrĩyupʉ: —Náka, gaji makãrĩ õõ pʉro weya ããrĩrĩ́ makãrĩ marãdere buegʉ waadʉakoa. Ire iributa i ʉ̃mʉguere aaribʉ́. ");
INSERT INTO sri_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Irasirigʉ ããrĩperero Galilea nikũgue judío masaka nerẽrĩ wiirigue buegorenagʉ̃, wãtẽa masakare ñajãnerãrẽ béowiunayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesús irasiriripoe sugʉ kãmi boagʉ ĩgʉ̃ pʉro eja, ñadʉkʉpuri merã ejamejãja, ĩgʉ̃rẽ sẽrẽyupʉ: —Mʉ, yʉ pũrĩrikʉrire taudʉagʉ taumasĩa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús bʉro bopoñarĩ merã ĩgʉ̃rẽ ĩã, ĩgʉ̃ya mojõ merã moãña, ãsũ ãrĩyupʉ: —Mʉrẽ taugʉra. Kãmi marĩgʉ̃ dujaka! ");
INSERT INTO sri_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ĩgʉ̃ irasũ ãrĩrĩ merãta kãmi yaripereakõãyuro. Irasirigʉ kãmi marĩgʉ̃ dujayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jesús ĩgʉ̃rẽ turaro merã ãsũ ãrĩyupʉ: —Gajerã masakare mʉ tariadeare werebirikõãka! Paí pʉrogue mʉya kãmi yariadeare ĩgʉ̃rẽ ĩmugʉ̃ waaka, ĩgʉ̃ mʉrẽ: “Õãa, kãmi marĩgʉ̃ ããrã”, ãrĩburo, ãrĩgʉ̃! Ĩgʉ̃ irasũ ãrãdero pʉrʉ, Moisés gojadea pũgue sĩdoredeare sĩka! Mʉ irire irimakʉ̃ ĩãrã, masakade mʉya kãmi yariadeare masĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesús ĩgʉ̃rẽ: “Gajerãrẽ yʉ mʉrẽ tauadeare werebirikõãka!” ãrĩkerepʉrʉ, kãmi boadi gapʉ irire masaka ããrĩperero marãrẽ werepʉroriyupʉ. Irasirigʉ Jesús masaka ĩũrõ makãrĩguere ñajãmasĩbiriyupʉ. Makã tʉrogue dita waanayupʉ. Irogue ĩgʉ̃ ããrĩkerepʉrʉ, masaka ããrĩperero marã ĩgʉ̃ pʉrogue ĩãrã ejanañurã. ");
INSERT INTO sri_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mérõgã pʉrʉ Jesús dupaturi Capernaugue goedujáayupʉ. Ĩgʉ̃ goejadero pʉrʉ, iro marã masaka ĩgʉ̃ wiigue ããrĩrĩ́rẽ masĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Irasirirã mata wárã masaka iri wiire nerẽ, disipʉrogueta ʉtʉriwirinʉgãjakõãñurã. Jesús ĩgʉ̃sãrẽ Marĩpʉya kerere weregʉ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ĩgʉ̃ wereripoe wapikʉrã ʉ̃ma dupʉ bʉadire Jesús pʉrogue ãĩjañurã. ");
INSERT INTO sri_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Masaka wárã ããrĩmakʉ̃, ĩgʉ̃rẽ ãĩñajãmasĩbiriñurã. Irasirirã iri wii wekague mʉrĩa, Jesús weka su gobe ãĩwea, ĩgʉ̃ oyaro merãta ĩgʉ̃rẽ dijuñurã. ");
INSERT INTO sri_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús, ĩgʉ̃sã ĩgʉ̃rẽ bʉremumakʉ̃ ĩãgʉ̃, bʉadire ãsũ ãrĩyupʉ: —Yʉ, mʉ ñerõ irideare kãtia. ");
INSERT INTO sri_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, surãyeri Moisés gojadeare buerimasã iri wiigue doarã Jesúre ãsũ ãrĩ gũñañurã: ");
INSERT INTO sri_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nasirigʉ ĩĩ ĩgʉ̃ werenírĩ merã Marĩpʉre ñerõ ãrĩrĩ? Masaka ñerõ irideare neõ sugʉ masakʉ kãtimasĩbirikumi. Marĩpʉ sugʉta masĩkumi”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús ĩgʉ̃sã gũñarĩrẽ ĩãmasĩ, ãsũ ãrĩyupʉ: —¿Nasirirã irasũ gũñarĩ mʉsã? ");
INSERT INTO sri_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Naásũ ãrĩrĩ gapʉ diasaberi ĩĩ bʉadire: “Yʉ, mʉ ñerõ irideare kãtia”, ãrĩrĩ, o “Wãgãnʉgã, mʉ oyarore ãĩkõã waaka!” ãrĩrĩ gapʉ diasaberi? ");
INSERT INTO sri_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yʉ ããrĩpererã tĩ́gʉ̃ i ʉ̃mʉgue ããrĩrã́rẽ ĩgʉ̃sã ñerõ irideare Marĩpʉ dorero merã kãtimasĩa. Irasirigʉ ĩĩ bʉadire taugʉra, mʉsãrẽ irire masĩdoregʉ, ãrĩyupʉ. Irasũ ãrĩ odo, bʉadire ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Yʉ mʉrẽ ãsũ ãrã: Wãgãnʉgã, mʉ oyaderore ãĩkõã, mʉya wiigue waaka! ");
INSERT INTO sri_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ĩgʉ̃ irasũ ãrĩrĩ merãta ããrĩpererã masaka ĩũrõ wãgãnʉgã, ĩgʉ̃ oyaderore ãĩ, waakõãyupʉ. Irasiririre ĩãrã, ĩãgʉka, Marĩpʉre: “Õãtaria mʉ, neõ ãsũ iririnorẽ ĩãñamerã ããrĩbʉ́”, ãrĩ, ʉsʉyari sĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pʉrʉ Jesús dupaturi ditaru tʉrogue waayupʉ. Irogue wárã masaka ĩgʉ̃ pʉro nerẽmakʉ̃ ĩãgʉ̃, ĩgʉ̃sãrẽ bueyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pʉrʉ iro ããrãdi waa, Alfeo magʉ̃rẽ Leví wãĩkʉgʉre ĩgʉ̃ moãrĩ taribugue doagʉre ĩãyupʉ. Ĩgʉ̃ romano marã opʉre niyeru wajaseabosagʉ ããrĩyupʉ. Jesús ĩgʉ̃rẽ ĩã: —Náka, yʉ merã! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Leví wãgãnʉgã, ĩgʉ̃ merã waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús Levíya wiigue waamakʉ̃ ĩãrã, wárã niyeru wajaseabosarimasã, gajerã ñerõ irirãde ĩgʉ̃rẽ tʉyañurã. Levíya wiigue eja, Jesús ĩgʉ̃sã merã ĩgʉ̃ buerã merã baa doaníyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesús ĩgʉ̃sã merã baa doanímakʉ̃ ĩãrã, fariseo bumarã, Moisés gojadeare buerimasãde Jesús buerãrẽ ãsũ ãrĩñurã: —¿Nasirigʉ mʉsãrẽ buegʉ niyeru wajaseabosarimasã, ñerõ irirã merã iirí, baari? ");
INSERT INTO sri_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ãrĩyupʉ: —Pũrĩrĩ marĩrã kúririmasʉ̃rẽ ãmabema. Pũrĩrikʉrã gapʉ ĩgʉ̃rẽ ãmama. Yʉ: “Õãrã ããrã”, ãrĩ gũñarãrẽ siiugʉ aaribiribʉ. “Ñerõ irirã ããrã”, ãrĩ gũñarã gapʉre siiugʉ aaribʉ́, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan buerã, fariseo bumarãde bererã iriñurã. Irasirirã gajerã masaka Jesús pʉro eja, ĩgʉ̃rẽ sẽrẽñañurã: —Juan buerã, fariseo bumarã buerire tʉyarãde Marĩpʉre bʉremurã berenama. ¿Nasirirã mʉ buerã gapʉ ĩgʉ̃sã irirosũ iriberi? ");
INSERT INTO sri_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Sugʉ mojõsiadi bosenʉ irimakʉ̃, ĩgʉ̃ siiuanerã ĩgʉ̃ merã ããrĩrã́, berebirikuma. ");
INSERT INTO sri_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pʉrʉ ĩgʉ̃rẽ gajerã ãĩãmakʉ̃, bʉro bʉjawereri merã bererãkuma. ");
INSERT INTO sri_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Masaka maama suríro gasiro merã bʉgʉñerẽ seretúbirikuma. Irasũ seretúmakʉ̃, maama gasiro ĩgʉ̃sã koeadero pʉrʉ, tʉ̃ãneeõ, bʉgʉñerẽ wári gobe yeguenemomakʉ̃ irikoa. ");
INSERT INTO sri_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Waimʉrã gasiri merã iridea ajuri bʉgʉ ajurigue maama igui dekore diribirikuma. Irasũ dirimakʉ̃, maama igui deko pãmu, bʉgʉ ajuro sẽrãturabiri, ooreakõãkoa. Irasiriro igui deko, ajurode kõmokoa. Irasirirã maama igui dekore maama ajurogue diriro gããmea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sunʉ, judío masaka siuñajãrĩnʉ ããrĩmakʉ̃, Jesús trigo otedero watope waamakʉ̃, ĩgʉ̃ buerã trigo yerire tʉ̃rĩ, koro, baawãgãñurã. ");
INSERT INTO sri_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseo bumarã, Jesús buerã irasirimakʉ̃ ĩãrã, Jesúre ãrĩñurã: —Ĩãka! ¿Nasirirã siuñajãrĩnʉrẽ moãdorebirikerepʉrʉ, mʉ buerã irasũ yári? ");
INSERT INTO sri_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —¿Iripoegue opʉ David ĩgʉ̃ merãmarã merã ʉaboagʉ, ĩgʉ̃ irideare buebiriri? ");
INSERT INTO sri_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ĩgʉ̃ merãmarã merã Marĩpʉya wiigue ñajãa, Marĩpʉ ĩũrõ peyari pã́ duparure baadi ããrĩmí. Abiatar paía opʉ ããrĩripoe irasiridi ããrĩmí. Marĩpʉ paía ããrĩmerãrẽ: “Iri pã́ duparure baabirikõãka!” ãrĩdi ããrĩmí. David gapʉ paí ããrĩbirikeregʉ, irire baagʉ, Marĩpʉ ĩũrõ ĩgʉ̃ dorerire tarinʉgãgʉ̃ meta iridi ããrĩmí, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Irasũ ãrĩ odo, ãsũ ãrĩyupʉ doja: —Iripoegue Marĩpʉ masakaya ããrĩburire siuñajãrĩnʉrẽ ĩgʉ̃sãrẽ pídi ããrĩmí. Masaka gapʉ inʉnorẽ ĩgʉ̃sã iriburire doremasĩbema. ");
INSERT INTO sri_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yʉ ããrĩpererã tĩ́gʉ̃ ããrĩsĩã, siuñajãrĩnʉrẽ masakare gajino ĩgʉ̃sã iriburire doremasĩa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gajinʉ Jesús judío masaka nerẽrĩ wiigue ñajãyupʉ doja. Iri wiigue sugʉ masakʉ diayema mojõ gapʉ diíweredi ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseo bumarã, Moisés gojadeare buerimasã Jesúre ĩãduripítʉya: “Siuñajãrĩnʉ ããrã, irasirirã ĩĩ mojõ diíweredire ĩgʉ̃ taumakʉ̃ ĩgʉ̃rẽ weresãrã!” ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús mojõ diíweredire: —Wãgãnʉgã, masaka ĩũrõgue ejanʉgãgʉ̃ aarika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Irasũ ãrĩ odo, gajerã iri wii ããrĩrã́rẽ ãsũ ãrĩ sẽrẽñayupʉ: —¿Siuñajãrĩnʉrẽ Marĩpʉ marĩrẽ ñeénorẽ iridoreyuri, õãrĩrẽ, o ñerĩrẽ, masakare taurire, o wẽjẽrĩrẽ? Ĩgʉ̃sã gapʉ ĩgʉ̃rẽ yʉjʉbiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Irasirigʉ Jesús ĩgʉ̃sãrẽ guari merã ĩãyupʉ. Ĩgʉ̃sã pémasĩdʉabirimakʉ̃ ĩãgʉ̃, bʉjawereyupʉ. Irasirigʉ mojõ diíweredire: —Mʉya mojõrẽ soeoka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, soeoyupʉ. Ĩgʉ̃ soeomakʉ̃, ĩgʉ̃ya mojõ õãkõãyuro. ");
INSERT INTO sri_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Irire ĩãrã, fariseo bumarã iri wiigue ããrãnerã wiria, Herodes merãmarã merã nerẽ: “¿Nasirisĩã, marĩ ĩgʉ̃rẽ wẽjẽrãkuri?” ãrĩ gãme wereníñurã. ");
INSERT INTO sri_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús gapʉ ĩgʉ̃ buerã merã ditaru tʉrogue waakõãyupʉ. Gajerã masaka Galilea nikũ marã wárã ĩgʉ̃rẽ tʉyañurã. ");
INSERT INTO sri_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judea nikũ marã, Jerusalén marã, Idumea nikũ marã, dia Jordán wãĩkʉdiya gaji koepʉ marã, gajerã Tiro, Sidón wãĩkʉri makãrĩ tʉro marãde Jesús iriri kerere pérã, ĩgʉ̃rẽ ĩãrã ejañurã. ");
INSERT INTO sri_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jesús wárã pũrĩrikʉrãrẽ taugʉ iriyupʉ. Ĩgʉ̃ irasũ taumakʉ̃ ĩãrã, ããrĩpererã pũrĩrikʉrã ĩgʉ̃ pʉrogue ejanʉgãñurã ĩgʉ̃rẽ moãñamurã. Irasirigʉ, ĩgʉ̃sã wárãgora ããrĩmakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃ buerãrẽ suru doódirure ãmudoreyupʉ, masaka ĩgʉ̃rẽ kʉ̃ñarõgãgora ejanʉgãbirikõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wãtẽa ĩgʉ̃rẽ ĩã, ĩgʉ̃ ĩũrõ ñadʉkʉpuri merã ejamejã: —Mʉ ʉ̃mʉgasigue marã Opʉ magʉ̃ ããrã, ãrĩ gainíñurã. ");
INSERT INTO sri_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús wãtẽãrẽ turaro merã: —Yaamarẽ werenímerãta! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gajinʉ Jesús buúru wekague mʉrĩa, ĩgʉ̃ gããmerãrẽ siiuyupʉ. Ĩgʉ̃ siiumakʉ̃ pé, ĩgʉ̃ pʉro nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Irasirigʉ Jesús pe mojõma pere su gubu peru pẽrẽbejarã ĩgʉ̃ merã ããrĩmurãrẽ, Marĩpʉya kerere ĩgʉ̃ buedoremurãrẽ beyeyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ĩgʉ̃sãrẽ ĩgʉ̃ turarire sĩyupʉ, pũrĩrikʉrãrẽ tau, wãtẽa masakare ñajãnerãdere béowiuburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ãsũ wãĩkʉrã ããrĩñurã: Simón wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃rẽta “Pedro” wãĩyeyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Gajigʉ Santiago, ĩgʉ̃ pagʉmʉ Juan ĩgʉ̃sã Zebedeo wãĩkʉgʉ pũrã ããrĩñurã. Jesús ĩgʉ̃sãrẽ “Boanerges” wãĩyeyupʉ. “Boanerges”, ãrĩrõ: “Bupua masã”, ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Gajerã: Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago ããrĩñurã. Santiago, Alfeo magʉ̃ ããrĩyupʉ. Gajerã: Tadeo, Simón ããrĩñurã. Simón, celote wãĩkʉri bumʉ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Gajigʉ Judas Iscariote wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃ta Jesúre wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmubu ããrĩyupʉ. Pʉrʉ Jesús ĩgʉ̃ buerã merã su wiigue ñajãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dupaturi wárã masaka ĩgʉ̃ pʉro nerẽñurã doja. Irasirigʉ Jesús, ĩgʉ̃ buerã merã baamasĩbiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesúya wererã irasũ waaríre pérã: “Niãrõtãrĩakõãkumi”, ãrĩñurã. Irasirirã gajerogue ĩgʉ̃rẽ ãĩadʉarã ejadiñurã. ");
INSERT INTO sri_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Gajerã Moisés gojadeare buerimasã Jerusalẽ́gue merã aaranerã ãsũ ãrĩñurã: —Ĩĩ, wãtẽa opʉ Beelzebú ñajãsũdi ããrĩ́mi. Irasirigʉ Beelzebú turari merã wãtẽãrẽ béowiumi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús masakare siiu, su keori merã ãsũ ãrĩ wereyupʉ: —¿Nasirigʉ Satanás ĩgʉ̃ basita béowiubokuri? ");
INSERT INTO sri_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Su nikũ marã ĩgʉ̃sã basi dʉkawari gãmekẽãrã, pereakõãkuma. ");
INSERT INTO sri_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Su wii marã ĩgʉ̃sã basi dʉkawari gãmekẽãrã, pereakõãkuma. ");
INSERT INTO sri_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanás ĩgʉ̃yarã merã dʉkawari gãmekẽãgʉ̃, ĩgʉ̃ basita yuwarikʉdijakõãkumi. ");
INSERT INTO sri_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Neõ sugʉ masakʉ, turagʉya wiire ĩgʉ̃rẽ siapʉroribirikeregʉ, ĩgʉ̃ oparire ẽmagʉ̃ ñajãmasĩbirikumi. Ĩgʉ̃rẽ siadero pʉrʉgue merẽ ĩgʉ̃yare ẽmamasĩkumi, ãrĩyupʉ. Jesús wãtĩ nemorõ turagʉ ããrã, ãrĩgʉ̃, irasũ ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Pʉrʉ ãsũ ãrĩnemoyupʉ: —Mʉsãrẽ diayeta werea. Marĩpʉ ããrĩpereri masaka ñerõ iririre, ĩgʉ̃sã ñerõ ãrĩ werenírĩdere kãtimasĩmi. ");
INSERT INTO sri_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Õãgʉ̃ deyomarĩgʉ̃rẽ ĩgʉ̃sã ñerõ ãrĩ werenímakʉ̃ tamerãrẽ neõ kãtibirikumi. Irasũ waja opaníkõãrãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ĩgʉ̃sã ĩgʉ̃rẽ: “Wãtĩ ñajãsũdi ããrĩ́mi ĩĩ”, ãrĩ werewʉari waja irasũ ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ĩgʉ̃ iro ããrĩripoe Jesús pago, ĩgʉ̃ pagʉpũrã merã ejayupo. Ĩgʉ̃ ããrĩrĩ́ wii disipʉrogueta ejanʉgãja, iro ããrĩrã́rẽ Jesúre siiudoreñurã. ");
INSERT INTO sri_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Irasirirã Jesús pʉro doarã ĩgʉ̃rẽ ãrĩñurã: —Mʉpo, mʉ pagʉpũrã disipʉrogue mʉrẽ ãmarã́ ejañurã. ");
INSERT INTO sri_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús gapʉ ãsũ ãrĩyupʉ: —¿Noã ããrĩ́rĩ yʉpo, yʉ pagʉpũrã? ");
INSERT INTO sri_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Irire ãrĩ odo, ĩgʉ̃ pʉro doarãrẽ ĩã, ãsũ ãrĩyupʉ: —Ĩĩsã, yʉpo, yʉ pagʉpũrã irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Marĩpʉ gããmerĩrẽ irirãno, yʉ pagʉmʉ, yʉ pagʉmo, yʉpo irirosũ ããrĩ́ma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gajinʉ Jesús ditaru tʉrogue buenʉgãyupʉ doja. Masaka wárã ĩgʉ̃ pʉro nerẽñurã. Ĩgʉ̃sã wárã nerẽmakʉ̃ ĩã, Jesús doódirugue mʉrĩñajãa, eja doayupʉ. Masaka ĩmiparogue dujanʉgãñurã ĩgʉ̃ buerire pémurã. ");
INSERT INTO sri_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Irasirigʉ wári keori merã ĩgʉ̃sãrẽ ãsũ ãrĩ bueyupʉ: ");
INSERT INTO sri_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Õãrõ péka! Sugʉ oterimasʉ̃ ĩgʉ̃ oterire otegʉ waakumi. ");
INSERT INTO sri_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ĩgʉ̃ irire meéwasiriwãgãmakʉ̃, gaji yeri maague yurikoa. Iro yuriadea yerire mirã eja, baapeokõãkuma. ");
INSERT INTO sri_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gaji yeri ʉ̃tãyerikʉrogue yurikoa. Iro nikũ sĩmerẽrõgã ããrĩmakʉ̃, iri yeri mata puriadikoa. ");
INSERT INTO sri_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Puriñajãdi, pʉrʉ abe asimakʉ̃ nugũrĩ marĩsĩã, ñaĩ, boakõãkoa. ");
INSERT INTO sri_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gaji yeri pora watopegue yurikoa. Pora gapʉ puritarimʉrĩa, iro yuridea yerire wẽjẽkõãkoa. Irasiriro dʉka marĩrĩta boakõãkoa. ");
INSERT INTO sri_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gaji yeri õãrĩ nikũgue yurikoa. Iri yeri puri, masã, õãrõ dʉkakʉkoa. Suñu treinta yeri, gajiñu sesenta yeri, gajiñu cien yeri dʉkakʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Irire were odo: —Gãmipũrĩ oparã, yʉ wererire péduripíka! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Masaka waadero pʉrʉ, Jesús sugʉta ããrĩmakʉ̃ ĩãrã, ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarã, gajerã ĩgʉ̃ merã ããrĩrã́de iri keori merã bueadeare: —¿Naásũ ãrĩdʉaro iriari, gʉare mʉ bueadea? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Marĩpʉ ĩgʉ̃yarãrẽ doregʉ ããrĩrĩ́rẽ iripoegue masĩbirideare mʉsãrẽ masĩmakʉ̃ yámi. Yʉ gajerãrẽ ĩgʉ̃rẽ bʉremumerã gapʉre keori merã dita buea. ");
INSERT INTO sri_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Irasirirã Marĩpʉ iririre ĩãkererã, ĩãmasĩbema. Ĩgʉ̃yare pékererã, õãrõ pémasĩbema. Marĩpʉ, ĩgʉ̃sã ñerõ iriri gapʉre pirimakʉ̃ ĩãgʉ̃, kãtibokumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús gaji ĩgʉ̃sãrẽ ãrĩnemoyupʉ doja: —¿Mʉsã, iri keori merã yʉ bueadeare pémasĩberi? Irire pémasĩmerã, ¿nasiri gaji gapʉre pémasĩbokuri? ");
INSERT INTO sri_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Marĩpʉya kerere weregʉ, oteri yerire otegʉ irirosũ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Surãyeri masaka bʉriri maa irirosũ ããrĩ́ma. Marĩpʉya kerere péadero pʉrʉ, oteri yeri iri maague yuridea yerire mirã baapeoderosũ, wãtẽa opʉ Satanás aari, ĩgʉ̃sã péadideare ẽmapeokõãmi. ");
INSERT INTO sri_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Gajerã masaka ʉ̃tãyerikʉri yeba irirosũ ããrĩ́ma. Ĩgʉ̃sã Marĩpʉya kerere ʉsʉyari merã péma. Irire pékererã, oteri yeri ʉ̃tãyerikʉrogue yuriadero pʉrʉ, puri nugũrĩ puriñajãbiriderosũ waama. Irasirirã mérõgã pʉrʉ ĩgʉ̃sã Marĩpʉyare pédʉari waja gajerã ĩgʉ̃sãrẽ ñerõ irimakʉ̃ ĩãrã, o ñerõ tarirã, ĩgʉ̃sã péadeare pirikõãma. ");
INSERT INTO sri_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gajerã masaka porakʉri yeba irirosũ ããrĩ́ma. Marĩpʉya kerere péma. Irire pékererã, oteri yeri porakʉrogue yuriadero pʉrʉ, pora gapʉ puritarimʉrĩa wẽjẽderosũ, ");
INSERT INTO sri_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","i ʉ̃mʉma gapʉre bʉro gũñarikʉma. “Wári oparã õãrõ ããrĩrãkoa”, ãrĩ gũñarĩ, gajinorẽ bʉro gããmenemorĩ Marĩpʉya kerere péadideare kãtimakʉ̃ yáa. Otediñu dʉka marĩdiñu irirosũ dujama. Irasirirã Marĩpʉyare iribema. ");
INSERT INTO sri_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Gajerã masaka õãrĩ nikũ irirosũ ããrĩ́ma. Marĩpʉya kerere õãrõ péduripíma. “Õãgoráa”, ãrĩ, Marĩpʉyare õãrõ yáma. Irasirirã otediñu wári dʉkakʉrosũ ããrĩ́ma. Surãyeri treinta yeri, gajerã sesenta yeri, gajerã cien yeri dʉkakʉrosũ ããrĩ́ma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Gaji Jesús ãrĩnemoyupʉ doja: —Masaka sĩãgodirure ãĩa, dupa kũma dokague, o kãrĩrõ dokaguedere píbirikuma. Ubu gapʉ ʉ̃marõgue siukuma, õãrõ sĩãgoburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Masaka ĩãberogue duripídeare sĩãgorogue ĩãmasĩrõ irirosũ ããrĩpereri masaka masĩbirideare masĩsũrokoa. Irasiriro yayedea irirosũ neõ ããrĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gãmipũrĩ oparã, yʉ wererire õãrõ péduripíka! ");
INSERT INTO sri_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Irasũ ãrĩ odo, ãsũ ãrĩnemoyupʉ doja: —Mʉsã périre õãrõ pémasĩka! Mérõgã pémasĩdʉarã, mérõgã pémasĩrãkoa. Wáro pémasĩdʉarã, wáro pémasĩrãkoa. Marĩpʉ ĩgʉ̃ya kerere mʉsã pémasĩdʉaropã pémasĩrĩrẽ sĩgʉkumi. Irasũ ããrĩmakʉ̃, wáro pémasĩdʉarãrẽ sĩnemogʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Irasirigʉ ĩgʉ̃ya kerere õãrõ pémasĩrãrẽ wári pémasĩrĩ sĩnemogʉkumi. Gajerã pémasĩmerã gapʉre ĩgʉ̃sã pémasĩadideare ẽmasũrãkuma. Irasirirã neõ pémasĩmerã ããrĩrãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Irasũ ãrĩ odo, gaji keori merã bueyupʉ doja: —Marĩpʉ ĩgʉ̃yarãrẽ doreri ãsũ ããrã. Sugʉ masakʉ ĩgʉ̃ya pooegue oteri yerire meéwasirigʉ irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ĩgʉ̃ irasũ meéwasiriadero pʉrʉ, ñami merã kãrĩkumi. Pʉrʉ boyoripoe yobekumi. Ʉ̃mʉrĩ, ñamirĩ tarikoa. Ĩgʉ̃ oteadea yeri puri masãkoa. Ĩgʉ̃ gapʉ irire: “Irasũ waakoa”, ãrĩ masĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Iri yeri yeba poekague ããrĩsĩã, puri, pũrĩ wiripʉrori, pʉrʉ dupañerĩgã wiri, dʉka yeri deyoakoa. Pʉrʉgue pama õãrõ dʉka bʉribejakoa. ");
INSERT INTO sri_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iri bʉribeja odomakʉ̃ ĩã, ĩgʉ̃rẽ moãboerãrẽ irire sea duripímurãrẽ iriukumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Irasũ ãrĩ odo, gaji ãrĩnemoyupʉ doja: —Marĩpʉ ĩgʉ̃yarãrẽ doreri, ¿ñeéno irirosũ ããrĩkuri? ¿Ñeéno keori merã weregʉkuri? ");
INSERT INTO sri_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I irirosũ ããrã. Suye oteriye mostaza wãĩkʉri yegãrẽ oterosũ ããrã. Iri oteri yegã ããrĩpereri oteri yeri nemorõ mérĩ yegã ããrã. ");
INSERT INTO sri_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Irasũ ããrĩkerero, otemakʉ̃, pʉrʉ yukʉ wádi dʉpʉri padi masãkoa. Irasirirã mirã irigʉ dʉpʉrigue, yʉsʉrogue ĩgʉ̃sãya surí suakuma, ãrĩyupʉ Jesús ĩgʉ̃ buerãrẽ, ĩgʉ̃sã merã ããrĩrã́dere. ");
INSERT INTO sri_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús masakare ãsũ buenayupʉ. Marĩpʉya kerere weregʉ, wári keori merã masaka pémasĩrõgueta buenayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ĩgʉ̃sãrẽ buegʉ, keori merã dita buenayupʉ. Ĩgʉ̃ buerã merã dita ããrĩgʉ̃́ gapʉ: “Ãsũ ãrĩdʉaro yáa iri”, ãrĩ werenayupʉ ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesús masakare oteri keori merã bueadeanʉ naĩmejãripoe ĩgʉ̃ buerãrẽ ãsũ ãrĩyupʉ: —Náka, ditaru sikoepʉgue taribujarã! ");
INSERT INTO sri_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, masakare seretu, ĩgʉ̃ sãñadea doódirugue mʉrĩñajãa, ĩgʉ̃rẽ ãĩ taribujakõãñurã. Gajerã gaji doóriduparu merã wapikʉwãgãñurã. ");
INSERT INTO sri_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ĩgʉ̃sã taribujaripoe mirũ bʉro waa, makũrĩ ĩgʉ̃sãya doódirure páñajãmiũakõãdiyuro. Bʉro goero waayuro ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús gapʉ wejaturoma doaripẽrõgue peyari gasiro merã ẽõtú kãrĩbejakõãyupʉ. Irasirirã ĩgʉ̃ buerã ĩgʉ̃rẽ ãsũ ãrĩ yobeñurã: —¿Gʉare buegʉ, mʉ ĩãberi? Marĩ mirĩmurã yáa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús wãgãnʉgã, mirũrẽ, makũrĩdere toedoreyupʉ: —Iropãta, toeaka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, mirũ, makũrĩ bʉro waadea toedijapereakõãyuro. ");
INSERT INTO sri_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pʉrʉ Jesús ĩgʉ̃ buerãrẽ ãrĩyupʉ: —¿Nasirirã güiri mʉsã? ¿Yʉre bʉremurĩ opaberi dapa mʉsã iropã güirã? ");
INSERT INTO sri_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ĩgʉ̃sã gapʉ bʉro gʉka, ãsũ ãrĩ gãme wereníñurã: —¿Ñeémʉno masakʉ ããrĩ́rĩ ĩĩ? Mirũ, makũrĩgueta ĩgʉ̃rẽ tarinʉgãbea, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús ĩgʉ̃ buerã merã ditarure taribuja, Gerasa marãya nikũgue ejayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús doódirugue ããrãdi majãnʉgãripoe sugʉ masakʉ wãtĩ ñajãsũdi, masãgoberi watopegue ããrãdi Jesúre bokatĩrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ĩgʉ̃ masãgoberi watopegue ããrĩgʉ̃́ ããrĩyupʉ. Neõ sugʉ ĩgʉ̃rẽ pũguburi merã, kõmedari merãdere siapímasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wári ĩgʉ̃ya guburire, mojõrĩdere kõmedari merã siapínadiñurã. Ĩgʉ̃sã siapírikʉ, ĩgʉ̃sã siadeadarire tʉ̃ãtawasiri béonokõãyupʉ. Neõ sugʉ ĩgʉ̃rẽ tarinʉgãmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ʉ̃mʉrikʉ, ñamirikʉ buurígue, masãgoberi watopegue gainígorenayupʉ. Ĩgʉ̃ basita ʉ̃tãyeri merã ĩgʉ̃ya dupʉre pá kãmitúnayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesúre yoarogueta ĩãgʉ̃, ũmawãgãri, ĩgʉ̃ ĩũrõ ñadʉkʉpuri merã ejamejãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesús ãrĩyupʉ: —Wãtĩ, mʉ ñajãdire wirika! Irasũ ãrĩmakʉ̃ pégʉ, bʉro gainírĩ merã ãsũ ãrĩyupʉ: —Jesús, ʉ̃mʉgasigue ããrĩpererã nemorõ turagʉ magʉ̃, ¿nasiribu yári mʉ yʉre? Mʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ péuro mʉrẽ sẽrẽa. Yʉre poyarikʉmakʉ̃ iribirikõãka! ");
INSERT INTO sri_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús ĩgʉ̃rẽ sẽrẽñayupʉ: —¿Naásũ wãĩkʉri mʉ? —Wárã ããrã gʉa. Irasirigʉ Legión wãĩkʉa yʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Irasũ ãrĩ odo, Jesúre bʉro sẽrẽyupʉ doja: —Gʉare i nikũrẽ béowiubirikõãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Iro buúru pʉro wárã yesea ãma baarã iriñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ĩgʉ̃sãrẽ ĩãrã, wãtẽa Jesúre sẽrẽñurã: —Gʉare yeseaguere ñajãdoregʉ iriuka! ");
INSERT INTO sri_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Jáʉ, ĩgʉ̃sãrẽta ñajãrã waaka! ãrĩyupʉ Jesús wãtẽãrẽ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, masakʉguere ããrãnerã wiria, yesea dos mil ããrĩrã́rẽ ñajãñurã. Ĩgʉ̃sã ñajãmakʉ̃, yesea ũma mirẽbuáa, ditarugue meébia dijáa, mirĩ boapereakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Irasũ waamakʉ̃ ĩãrã, yeseare korerimasã gʉkari merã ũmadujáa, ĩgʉ̃sãya makã marãrẽ, iri makã tʉro marãdere wererã waañurã. Ĩgʉ̃sã weremakʉ̃ pérã, masaka ããrĩpererã: “¿Naásũ waáayuri?” ãrĩ, ĩãrã ejañurã. ");
INSERT INTO sri_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús pʉro ejarã, wãtẽa ñajãsũdi ããrãdire iro doagʉre ĩãñurã. Suríro sãñadi, õãrõ pémasĩrĩ merã ããrĩyupʉ. Masaka ĩgʉ̃rẽ ĩãrã, bʉro güiñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jesús masakʉre wãtẽãrẽ béowiuadeare ĩãnerã yeseare waadeadere wereñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Irire pérã, Gerasa marã Jesúre: “Waaka gʉaya nikũrẽ!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús doódirugue mʉrĩñajãyupʉ. Ĩgʉ̃ mʉrĩñajãmakʉ̃, wãtẽa ñajãsũdi ããrãdi Jesúre: “Yʉde mʉ merã waadʉakoa”, ãrĩ sẽrẽadiyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃rẽ ãsũ ãrĩyupʉ: —Yʉ merã waabirikõãka! Mʉya wiigue goedujáaka! Mʉrẽ mʉ Opʉ õãrõ iriadeare, ĩgʉ̃ bopoñarĩ merã ĩãdeare mʉya wii marãrẽ weregʉ waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Decápolis wãĩkʉrogue waa, iroma makãrĩ marãrẽ ããrĩpereri Jesús ĩgʉ̃rẽ irideare werenʉgãyupʉ. Ããrĩpererã ĩgʉ̃ wererire pérã, pégʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús Gerasa marãya nikũgue ããrãdi doódirugue mʉrĩñajãa, gaji koepʉgue taribujakõãyupʉ. Ĩgʉ̃ irogue ejamakʉ̃ ĩã, ditaru tʉrogue wárã masaka ĩgʉ̃ pʉro nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ĩgʉ̃ irogue ããrĩripoe sugʉ judío masaka nerẽrĩ wii oparã merãmʉ Jairo wãĩkʉgʉ ejayupʉ. Jesúre ĩãgʉ̃, ĩgʉ̃ya guburi pʉro ñadʉkʉpuri merã ejamejãja, ĩgʉ̃rẽ bʉro sẽrẽyupʉ: ");
INSERT INTO sri_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Yʉ magõ kõmobogue iriamo. Mʉya mojõrĩ merã ñapeo, igore taugʉ aarika! Mʉ irasirimakʉ̃, okagokumo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃ merã waayupʉ. Ĩgʉ̃ waamakʉ̃, wárã masaka ĩgʉ̃rẽ kʉ̃ñarõgã tuuyañurã. ");
INSERT INTO sri_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ĩgʉ̃sã watopegue sugo nomeõ pe mojõma pere su gubu peru pẽrẽbejari bojorigora dí wiriri merã pũrĩrikʉgo ããrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wárã kúririmasã igore kúrikerepʉrʉ, neõ taribiriyuro. Igo niyeru opadideare ããrĩpereri ĩgʉ̃sãrẽ wajaripeokerepʉrʉ, sõõ gapʉ bʉro waayuro. ");
INSERT INTO sri_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Igo, Jesús pũrĩrikʉrãrẽ taurire péyupo. Irasirigo masaka watopegue waa: “Ĩgʉ̃ya surírore yʉ moãñamakʉ̃, pũrĩrĩ yʉre tarirokoa”, ãrĩ gũñarĩ merã, Jesús pʉrʉpʉ gapʉ ejanʉgã, ĩgʉ̃ya surírore moãñayupo. ");
INSERT INTO sri_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mata igo dí wiriadea tariakõãyuro. “Yʉre pũrĩrĩ tarikoa”, ãrĩ péñayupo. ");
INSERT INTO sri_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Igo moãñamakʉ̃ta, Jesús ĩgʉ̃ turaro merã sugo pũrĩrikʉgore tauadeare masĩkõãyupʉ. Irasirigʉ masakare gãmenʉgã ĩã: —¿Noã yaa surírore moãñarĩ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃ buerã ĩgʉ̃rẽ ãrĩñurã: —¿Mʉ ĩãberi? Wárã masaka mʉrẽ kʉ̃ñarõgã tuuyama. ¿Nasirigʉ ĩgʉ̃sãrẽ: “¿Noã yʉre moãñarĩ?” ãrĩ sẽrẽñarĩ? ");
INSERT INTO sri_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús gapʉ masaka ããrĩpererãrẽ ĩãyupʉ, ĩgʉ̃rẽ moãñadeore ĩãbokabu. ");
INSERT INTO sri_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jesús igo pũrĩrikʉri tariadeare masĩmakʉ̃ ĩã, güi naradari merã ĩgʉ̃ya guburi pʉro ñadʉkʉpuri merã ejamejã, ããrĩpererire diaye ãrĩrĩ merã werepeokõãyupo. ");
INSERT INTO sri_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús igore ãrĩyupʉ: —Mʉ yʉre bʉremurĩ opáa. Irasirigo mʉ pũrĩrikʉrire tausũa. Ʉsʉyari merã waaka! Mʉ pũrĩrikʉadea tariakõãa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús irasũ ãrĩripoe Jairoya wiigue ããrãnerã ejañurã: —Mʉ magõ kõmoakõãmo. Iropãta marĩrẽ buegʉre garibonemoka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ĩgʉ̃sã irasũ ãrĩkerepʉrʉ, Jesús Jairore ãsũ ãrĩyupʉ: —Güibirikõãka! Bʉremurĩ opaka yʉre! ");
INSERT INTO sri_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Irasirigʉ Jesús masakare: “Aaribirikõãka!” ãrĩ, Pedro, Santiago, ĩgʉ̃ pagʉmʉ Juãrẽ siiu, Jairoya wiigue ĩgʉ̃sã merã waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iri wiigue ejagʉ, wárã masaka bʉro bʉsʉro orerãrẽ bokajayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús, wiigue ñajãa, ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —¿Nasirirã mʉsã iropã bʉsʉro oreri? Igo majĩgõ boabemo. Kãrĩgõ yámo. ");
INSERT INTO sri_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ bʉriñurã. Irasirigʉ Jesús ããrĩpererãrẽ wiriadoreyupʉ. Ĩgʉ̃sã wiriadero pʉrʉ, majĩgõ pagʉsãmarãrẽ, ĩgʉ̃ merãmarãrẽ igo peyarogue siiu ñajãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ñajãja, igoya mojõrẽ ñeã, igore: —Talita, cumi, ãrĩyupʉ. “Talita, cumi”, ãrĩrõ: “ ‘Majĩgõ, wãgãnʉgãka!’ ãrã”, ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, majĩgõ wãgãnʉgã, waamasĩyupo. Igo pe mojõma pere su gubu peru pẽrẽbejari bojori opago ããrĩyupo. Masaka, igo masãmakʉ̃ ĩãrã, ĩãgʉkatariakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús gapʉ ĩgʉ̃sãrẽ turaro merã: —Igo masãdeare gajerãrẽ werebirikõãka! ãrĩyupʉ. Irasũ ãrĩ odo, igo pagʉsãmarãrẽ: “Igore baari ejoka!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pʉrʉ Jesús iro ããrãdi ĩgʉ̃ya nikũgue goedujáayupʉ. Ĩgʉ̃ buerãde ĩgʉ̃ merã waañurã. ");
INSERT INTO sri_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Judío masaka siuñajãrĩnʉ ããrĩmakʉ̃, Jesús ĩgʉ̃sã nerẽrĩ wiigue ñajãa, masakare buenʉgãyupʉ. Wárã masaka iro ããrĩrã́ ĩgʉ̃ buemakʉ̃ pérã, pégʉkakõãñurã: —¿Noógue bueyuri ĩĩ iropã masĩbu? ¿Noã ĩgʉ̃rẽ iropã masĩrĩrẽ sĩyuri, ĩgʉ̃ turari merã iri ĩmuburire? ");
INSERT INTO sri_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ĩĩ taboa merã gajino irigʉ ããrĩ́mi. María magʉ̃, Santiago, José, Simón, Judasã tĩ́gʉ̃ ããrĩ́mi. Ĩgʉ̃ pagʉpũrã nomede õõ marĩya makãta ããrĩ́ma, ãrĩ gãme wereníñurã ĩgʉ̃sã basi. Irasirirã ĩgʉ̃rẽ bʉremudʉabiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús gapʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —Ããrĩpererogue sugʉ Marĩpʉya kerere weredupuyugʉre gajerã bʉremuma. Ĩgʉ̃ya nikũ marã, ĩgʉ̃ya wererã, ĩgʉ̃ya wii marã gapʉ ĩgʉ̃rẽ bʉremubema, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Irasirigʉ iro ããrĩgʉ̃́, wári Marĩpʉ turari merã iri ĩmubiriyupʉ. Surãyerita pũrĩrikʉrãrẽ ĩgʉ̃ya mojõrĩ merã ñapeo tauyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iro marã ĩgʉ̃rẽ bʉremubirimakʉ̃ ĩãgʉ̃, gʉkatariakõãyupʉ. Pʉrʉ iri makã tʉroma makãrĩ marãrẽ buegʉ waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Irasirigʉ Jesús ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarãrẽ siiu neeõ: “Yʉ turari merã wãtẽa masakare ñajãnerãrẽ béowiurã waaka!” ãrĩ, ĩgʉ̃sã ããrĩpererãrẽ pẽrã dita dʉkawa iriuyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ĩgʉ̃sãrẽ iriugʉ, gajino baari, aju, niyeru ãĩadorebiriyupʉ. Ĩgʉ̃sã tuari yuku direta ãĩadoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ĩgʉ̃sã sãñarĩ merã dita waadoreyupʉ. Gaji ĩgʉ̃sã surí sãñaburi ãĩadorebiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ãsũ ãrĩyupʉ: —Sugʉ mʉsãrẽ õãrõ bokatĩrĩñeãmakʉ̃, ĩgʉ̃ya wiita dujaka! Iri makãrẽ wiri waarã́gue iri wiire wirika! ");
INSERT INTO sri_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Su makã marã mʉsãrẽ gããmebirimakʉ̃ ĩãrã, mʉsã werenírĩrẽ pédʉabirimakʉ̃ ĩãrã, iri makãrẽ tariwãgã, iri makãma nikũwera mʉsãya guburigue tuadeare mojẽbéokõãka! Ĩgʉ̃sã mʉsãrẽ gããmebiri waja irasirika, ĩgʉ̃sãrẽ Marĩpʉ wajamoãburire pémasĩburo, ãrĩrã! Yʉ mʉsãrẽ diayeta werea. Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, Sodoma, Gomorra marãrẽ wajamoãrõ nemorõ ĩgʉ̃sãrẽ wajamoãgʉkumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, waakõãñurã. Waa, masakare: “Mʉsã ñerõ irideare bʉjawereka! Mʉsã gũñarĩrẽ gorawayuka!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Irasũ ããrĩmakʉ̃, wárã wãtẽa masakare ñajãnerãrẽ béowiuñurã. Wárã pũrĩrikʉrãrẽ ʉye merã wʉ̃kã, tauñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ããrĩperero marã masaka Jesús ĩgʉ̃ iriri kerere péseyakõãñurã. Herodes, Galilea nikũ marã opʉde péyupʉ. Irire pégʉ, ãsũ ãrĩyupʉ: —Juan masakare wãĩyerimasʉ̃ boadigue masãdi ããrĩkumi. Irasirigʉ turari merã wári iri ĩmurĩrẽ irikumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gajerã gapʉ ãrĩñurã: —Ĩgʉ̃, Elías iripoegue Marĩpʉya kerere weredupuyudi ããrĩkumi. Gajerã ãrĩñurã: —Ĩgʉ̃, sugʉ iripoeguemʉ, Marĩpʉya kerere weredupuyudi irirosũ ããrĩgʉ̃́ ããrĩkumi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes irire pé, ãsũ ãrĩyupʉ: —Ĩgʉ̃, Juan ããrĩkumi. Yʉ ĩgʉ̃rẽta ĩgʉ̃ya dipurure dititádorebʉ. Daporare dupaturi masãkumi doja, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Juan boaburi dupuyuro Herodes ĩgʉ̃ pagʉmʉ Felipe marãpore ẽma, igore marãpokʉdi ããrĩmí. Igo Herodías wãĩkʉdeo ããrĩmó. Ĩgʉ̃ irasirimakʉ̃ ĩã, Juan Herodere: —Mʉ pagʉmʉ marãpore marãpokʉgʉ, Marĩpʉ dorerire tarinʉgãgʉ̃ yáa, ãrĩdi ããrĩmí. Ĩgʉ̃ irasũ ãrĩrĩ waja Herodes ĩgʉ̃yarã ʉ̃marẽ Juãrẽ peresu iridoredi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herodías gapʉ Juãrẽ pũrĩsũgʉ̃ ĩãdeo ããrĩmó. Irasirigo ĩgʉ̃rẽ wẽjẽdʉadeo ããrãdimo. Herodes gapʉ Juãrẽ: “Õãrĩrẽ irigʉ, õãgʉ̃ ããrĩ́mi”, ãrĩ gũña, bʉremurĩ merã ĩgʉ̃rẽ güidi ããrĩmí. Juan weremakʉ̃ pégʉ, bʉro gũñarikʉdi ããrĩmí. Irasũ gũñarikʉkeregʉ, ʉsʉyari merã ĩgʉ̃ wererire pédi ããrĩmí. Irasirigʉ ĩgʉ̃rẽ wẽjẽdorebiridi ããrĩmí. Irasirigo Herodías ĩgʉ̃rẽ wẽjẽdʉakerego, wẽjẽdoremasĩbirideo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pʉrʉ Herodías ĩgʉ̃rẽ wẽjẽdʉadeo ããrĩsĩã, õãrõ bokadeo ããrĩmó. Herodes ĩgʉ̃ deyoadeanʉ ããrĩmakʉ̃, ĩgʉ̃ya nikũ marã oparãrẽ, ĩgʉ̃yarã surara oparãrẽ, gajerã Galilea marã oparãdere siiu, ĩgʉ̃sã merã bosebaadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ĩgʉ̃ siiuanerã merã baari taribugue baaripoe Herodías magõ ñajãa, ĩgʉ̃sã ĩũrõ baya ĩmudeo ããrĩmó. Igo baya ĩmumakʉ̃ ĩãrã, Herodes, ĩgʉ̃ siiuanerãde ʉsʉyanerã ããrĩmá. Irasirigʉ Herodes igore ãrĩdi ããrĩmí: —Mʉ gããmerĩnorẽ sẽrẽka yʉre! Mʉ sẽrẽrĩrẽ mʉrẽ sĩgʉra, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Irasirigʉ iro ããrĩrã́ péuro: “Ãrĩgatoro marĩrõ mʉ sẽrẽrõsũta mʉrẽ sĩgʉkoa. Yʉ opari, yaa nikũ ããrĩrĩ́ deko ejatuaropã mʉrẽ sĩgʉkoa”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, igo pago pʉro waa, sẽrẽñadeo ããrĩmó: —¿Ñeénorẽ sẽrẽgokuri yʉ? —Juan masakare wãĩyerimasʉ̃ya dipurure sẽrẽka! ãrĩ yʉjʉdeo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Igo pago irasũ ãrĩmakʉ̃ pégo, mata opʉ Herodes pʉrogue waa, ĩgʉ̃rẽ ãrĩdeo ããrĩmó: —Daporata Juan masakare wãĩyerimasʉ̃ya dipurure dititá, soropa wáripa merã sĩmakʉ̃ gããmekoa. ");
INSERT INTO sri_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Igo irasũ ãrĩmakʉ̃, opʉ Herodes bʉro bʉjaweredi ããrĩmí. Ĩgʉ̃ siiuanerã péuro: “Mʉ sẽrẽrĩrẽ mʉrẽ sĩgʉra”, ãrãdi ããrĩsĩã, gʉyasĩrĩgʉ̃, igore: “Mʉ sẽrẽrĩrẽ sĩbirikoa”, ãrĩmasĩbiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Irasirigʉ mata ĩgʉ̃yagʉ surarare peresu iriri wiigue Juãya dipurure dititá ãĩwãgãridoregʉ iriudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Irasirigʉ surara irogue waa, Juãya dipurure dititá, soropa merã ãĩadi ããrĩmí. Ãĩja, Herodías magõrẽ wiadi ããrĩmí. Ĩgʉ̃ igore iripare wiamakʉ̃, ñeã, igo pagore ãĩa sĩdeo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan buerã ĩgʉ̃rẽ waadea kerere pérã, irogue waa, ĩgʉ̃ya dupʉre ãĩwãgã, yáañurã. ");
INSERT INTO sri_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús ĩgʉ̃yare buedoregʉ iriuanerã ĩgʉ̃ pʉro goedujajarã, ĩgʉ̃sã iriadeare ĩgʉ̃sã masakare bueadeare werepeokõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ĩgʉ̃sã goedujajadero pʉrʉ, wárã masaka ĩgʉ̃sã pʉro gãmeñajãrã ejañurã. Irasirirã Jesús buerã baamasĩbiriñurã. Irasirigʉ Jesús ĩgʉ̃sãrẽ: —Náka, marĩ dita masaka marĩrõgue siuñajãrã! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Irasirigʉ Jesús ĩgʉ̃ buerã merã doódirugue mʉrĩñajãa, ĩgʉ̃sã dita masaka marĩrõgue waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ĩgʉ̃sã waamakʉ̃ ĩãrã, wárã masaka Jesúre ĩãmasĩñurã. Irasirirã ããrĩpereri makãrĩ marã maague waa, Jesús ejaburogue ũmajasiañurã. ");
INSERT INTO sri_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús doódirugue sãñadi majãnʉgãja, wárã masakare ĩãyupʉ. Ĩgʉ̃sãrẽ ĩãgʉ̃: “Ĩĩsã oveja sugʉ ĩgʉ̃sãrẽ koregʉ opamerã irirosũ ããrĩ́ma”, ãrĩ gũñayupʉ. Irasirigʉ ĩgʉ̃sãrẽ bopoñarĩ merã ĩã, wári buenʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ñamika ããrĩmakʉ̃, Jesús buerã ĩgʉ̃ pʉro waa, ĩgʉ̃rẽ ãrĩñurã: —Õõ masaka marĩrõgue ããrã. Ñamikague ããrĩsiáa. ");
INSERT INTO sri_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Irasirigʉ masakare waadoreka! Makãrĩgue, makãrĩ tʉroma wiirigue baari wajarirã waaburo. Marĩ õõguere baari opabea, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús gapʉ: —Mʉsã ĩgʉ̃sãrẽ baari sĩka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã: —¿Gʉa ĩgʉ̃sã baaburire wajarirã waamakʉ̃ gããmekuri? Ĩgʉ̃sã baaburi doscientos nʉrĩ moã wajataropã wajakʉrokoa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —¿Diíkʉ pã́ duparu opari mʉsã? Ĩãrã waaka! —Jáʉ, ãrĩ, baarire ĩãrã waa: —Su mojõma pã́ duparu ããrã, waaí pẽrãta ããrĩ́ma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Irasirigʉ Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Masakare tá weka boje yebori dita doayodoreka! ");
INSERT INTO sri_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Irasirirã su yebore cien, gaji yebore cincuenta doajañurã. Ããrĩpererã irasũ dita doajañurã. ");
INSERT INTO sri_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ĩgʉ̃sã eja doaperemakʉ̃, Jesús su mojõma pã́ duparu, pẽrã waairé ãĩ, ʉ̃mʉgasigue ĩãmu, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩyupʉ. Ãrĩ odo, iri pã́ duparure pea, ĩgʉ̃ buerãrẽ sĩyupʉ, masakare gueredoregʉ. Waaídere irasũta iriyupʉ, ããrĩpererãrẽ gueredoregʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Irasirirã ããrĩpererã õãrõ baayapiakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pʉrʉ ĩgʉ̃sã baadʉáadeare Jesús buerã seasãrã, pe mojõma pere su gubu peru pẽrẽbejari puuirigora ʉtʉudoboñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pã́ duparure baanerã: nome, majĩrã keoña marĩrõ ʉ̃ma direta keomakʉ̃, cinco mil gora ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pʉrʉ Jesús ĩgʉ̃ buerãrẽ doódirugue mʉrĩñajãdore, Betsaida wãĩkʉri makãgue ĩgʉ̃ dupuyuro taribujadoreyupʉ. Ĩgʉ̃sã taribujaripoe Jesús masakare: “Õãrõ waaka!” ãrĩ seretuyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Seretu odo, buúrugue Marĩpʉre sẽrẽgʉ̃ mʉrĩayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Naĩwãgãriripoe Jesús sugʉta buúru wekague ããrĩyupʉ. Ĩgʉ̃ buerã gapʉ ditaru dekogora ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mirũ ĩgʉ̃sãrẽ taribujamasĩña marĩrõ ĩgʉ̃sã diaye wẽjẽpumakʉ̃ ĩãyupʉ Jesús. Pʉrʉ boyo mʉrĩriripoe ditarugue buaja, deko weka ĩgʉ̃sã pʉro aari, ejanʉgã, ĩgʉ̃sãrẽ tariwãgãbu irirosũ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ĩgʉ̃ irasũ deko weka ejanʉgãmakʉ̃ ĩãrã: “Masakʉ boadi wãtĩ ããrĩ́mi”, ãrĩ gũña, bʉro gʉkari merã gainíñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ããrĩpererã ĩgʉ̃rẽ ĩãrã, bʉro gʉkañurã. Ĩgʉ̃sã gʉkamakʉ̃ ĩãgʉ̃, mata Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Gũñaturaka! Yʉta ããrã. Güimerãta! ");
INSERT INTO sri_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, ĩgʉ̃sã sãñadiru doódirugue mʉrĩñajãyupʉ. Ĩgʉ̃ mʉrĩñajãmakʉ̃ta, mirũ toeakõãyuro. Irasũ waamakʉ̃ ĩãrã, ĩãgʉkatariakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ĩgʉ̃ pã́ duparure Marĩpʉ turari merã iri ĩmuadeare pémasĩbiriñurã. Ĩgʉ̃yamarẽ õãrõ pémasĩturabiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesús doódirugue mʉrĩñajãmakʉ̃, ĩgʉ̃ merã taribuja, Genesaret wãĩkʉri nikũgue eja, doódirure siatúpau majãkõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ĩgʉ̃sã majãmakʉ̃, mata masaka Jesúre ĩãmasĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Irasirirã ĩgʉ̃sãya nikũ ããrĩpererogue ũmawãgã, pũrĩrikʉrãrẽ ĩgʉ̃sã peyari merãta ĩgʉ̃ ããrĩrṍgue ãĩjañurã. ");
INSERT INTO sri_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ããrĩperero ĩgʉ̃ waaró ĩgʉ̃ ejaburi dupuyuro paga makãrĩ marã, mʉtã makãrĩgã marã, makãrĩ tʉro marãde pũrĩrikʉrãrẽ wiiri disipʉrorigue ãĩwiupíñurã. Ĩgʉ̃sã pʉro ĩgʉ̃ ejamakʉ̃ ĩã, ĩgʉ̃rẽ: —Mʉya suríro yuwa direta ĩgʉ̃sãrẽ moãñadoreka! ãrĩ sẽrẽñurã. Irasirirã ããrĩpererã ĩgʉ̃ya surírore moãñarã ĩgʉ̃sã pũrĩrikʉadeare tarisũñurã. ");
INSERT INTO sri_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pʉrʉ fariseo bumarã, Moisés gojadeare buerimasãde Jerusalẽ́gue ããrãnerã eja, Jesús pʉro nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Irasũ nerẽrã, ĩgʉ̃sã: “Baaburi dupuyuro mojõkoeka!” ãrĩdeare surãyeri Jesús buerã mojõkoero marĩrõ baamakʉ̃ ĩãrã, ĩgʉ̃sãrẽ werewʉañurã. ");
INSERT INTO sri_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseo bumarã, ããrĩpererã judío masaka ĩgʉ̃sã ñekʉ̃sãmarã iriunaderosũ ĩgʉ̃sãya mojõrĩrẽ mojõkoepʉrori baanañurã. ");
INSERT INTO sri_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ĩgʉ̃sã baari duarogue ejanerãde mojõkoepʉrorisĩã, baanañurã. Wári gaji ĩgʉ̃sã ñekʉ̃sãmarã iriunadeare iritʉyañurã. Irasirirã ĩgʉ̃sã ñekʉ̃sãmarã: “Ãsũ dita irika!” ãrĩdeare irirã, ĩgʉ̃sã iiríriduparure, ĩgʉ̃sã iiríburi duripíriduparure, ĩgʉ̃sãya kõmesororire, ĩgʉ̃sã doaripẽrĩrẽ koenañurã. ");
INSERT INTO sri_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Irasirirã fariseo bumarã, Moisés gojadeare buerimasãde Jesúre ãsũ ãrĩ sẽrẽñañurã: —¿Nasirirã mʉ buerã marĩ ñekʉ̃sãmarã iriunaderosũ baaburi dupuyuro mojõkoeberi? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã masaka ĩãberogue ñerõ iririkʉrã, irigatorikʉrã ããrã. Iripoegue Marĩpʉya kerere weredupuyudi Isaías mʉsã dapora irigatorire gojagʉ, diayeta ãsũ ãrĩ gojadi ããrĩmí: Masaka ĩgʉ̃sãya disi merã yʉre õãrõ wereníkererã, ĩgʉ̃sãya gũñarĩgue yʉre neõ bʉremubema. ");
INSERT INTO sri_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Irasiriro ĩgʉ̃sã yʉre bʉremurã nerẽrĩ wajamáa. Ĩgʉ̃sã bueri, yʉ doreri meta ããrã. Masaka doreri ããrã, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Irasirirã mʉsã ñekʉ̃sãmarã iriunaderosũ irimurã Marĩpʉ dorerire pirikõãa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ãsũ ãrĩnemoyupʉ doja: —Mʉsã ñekʉ̃sãmarã doredeare iritʉyarã, Marĩpʉ doreri gapʉre béokõãa. ");
INSERT INTO sri_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Iripoegue Moisés ãsũ ãrĩ gojadi ããrĩmí: “Mʉpʉre, mʉpore bʉremuka! Sugʉ ĩgʉ̃ pagʉsãmarãrẽ ñerõ werenígʉ̃ wẽjẽdoresũgʉkumi”, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mʉsã gapʉ masakare ãsũ ãrĩ buea: “Sugʉ ĩgʉ̃ pagʉre, o ĩgʉ̃ pagore: ‘Yʉ mʉsãrẽ sĩboadeare Marĩpʉre sĩpeokõãbʉ. Irasirigʉ mʉsãrẽ iritamumasĩbirikoa’, ãrĩmakʉ̃ õãgoráa”, ãrĩ buea. ");
INSERT INTO sri_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mʉsã masakare irasũ ãrĩ buerã, masakare ĩgʉ̃sã pagʉsãmarãrẽ iritamubirimakʉ̃ yáa. ");
INSERT INTO sri_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Irasirirã mʉsã ñekʉ̃sãmarã pídeare gajerãrẽ irire iritʉyadorerã, ĩgʉ̃sãrẽ Marĩpʉ doreri gapʉre ubu ĩãmakʉ̃ yáa. Gaji wári irinorẽ yáa, ãrĩyupʉ Jesús fariseo bumarãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Irasũ ãrĩ odo, Jesús masakare siiu, ãsũ ãrĩyupʉ: —Yʉ wererire ããrĩpererã õãrõ pékũĩnú, péka! ");
INSERT INTO sri_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Masakaya disigue ñajãri ĩgʉ̃sãrẽ ñerã waamakʉ̃ iribea. Ĩgʉ̃sãya disi wiriri gapʉ, ĩgʉ̃sãrẽ ñerã waamakʉ̃ yáa. ");
INSERT INTO sri_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Gãmipũrĩ oparã, yʉ wererire péduripíka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pʉrʉ Jesús masaka merã ããrãdi, wiigue ñajãkõãyupʉ. Irogue ĩgʉ̃ buerã ĩgʉ̃ keori merã wereadeare sẽrẽñañurã. ");
INSERT INTO sri_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ĩgʉ̃sã sẽrẽñamakʉ̃ pégʉ, ãrĩyupʉ: —¿Mʉsãde pémasĩberi dapa? Ããrĩpereri baari masakaya disigue ñajãri, ĩgʉ̃sãrẽ ñerã waamakʉ̃ irimasĩbea. ¿Irire pémasĩberi mʉsã? ");
INSERT INTO sri_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ĩgʉ̃sã baadea ĩgʉ̃sã gũñarĩgue ñajãbea. Ĩgʉ̃sãya paru gapʉ ñajãa, pʉrʉ tariwiria, ãrĩyupʉ. Irire ãrĩgʉ̃: “Ããrĩpereri baari õãrĩ ããrã”, ãrĩgʉ̃ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Gaji ãrĩnemoyupʉ doja: —Masaka ĩgʉ̃sã gũñarĩguere opari gapʉ, ĩgʉ̃sãrẽ ñerã waamakʉ̃ yáa. ");
INSERT INTO sri_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ĩgʉ̃sã gũñarĩgue ñerĩ oparã, ãsũ ããrĩ́ma. Ñerĩ gũñarã, gajerã marãposã nomerẽ gãmebirarã, nome merã ñerĩ iririkʉrã, masakare wẽjẽbéorã, ");
INSERT INTO sri_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gajerãyare yajarã, gajigʉ oparinorẽ bʉro ʉaribejarã, gajerãrẽ ñerõ irirã, ãrĩgatorã, ñerã, gajino oparãrẽ ĩãturirã, gajerãrẽ ñerõ kere wererã, “Gajerã nemorõ ããrã yʉ”, ãrĩ gũñakererã pémasĩrĩ marĩrõ irirã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iri ããrĩpereri ñerĩ masaka gũñarĩgue opari ĩgʉ̃sãrẽ ñerã waamakʉ̃ yáa, ãrĩyupʉ Jesús ĩgʉ̃ buerãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pʉrʉ Jesús iro ããrãdi waa, Tiro, Sidón wãĩkʉri makãrĩ tʉrogue ejayupʉ. Irogue eja, su wiigue ñajãyupʉ masaka ĩgʉ̃ ããrĩrṍrẽ masĩbirikõãburo, ãrĩgʉ̃. Irasirikeregʉ, masĩkõãsũyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sugo nomeõ wãtĩ ñajãsũdeo pago ĩgʉ̃ ejadeare pégo, mata ĩgʉ̃ pʉro waa, ĩgʉ̃ya guburi pʉro ñadʉkʉpuri merã ejamejãyupo. ");
INSERT INTO sri_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Igo judío masako ããrĩbeo ããrĩyupo. Igo deyoadea makã Sirofenicia wãĩkʉri makã ããrĩyuro. Jesús pʉro ñadʉkʉpuri merã ejamejãja, ĩgʉ̃rẽ sẽrẽyupo: —Wãtĩrẽ béowiuka yʉ magõrẽ! ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús igore ãrĩyupʉ: —Wii opʉ pũrã baarire ẽma, diayéare ejomakʉ̃ õãbea. ");
INSERT INTO sri_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Igo ĩgʉ̃rẽ yʉjʉyupo: —Irasũta ããrã yʉ Opʉ. Irasũ ããrĩkerepʉrʉ, diayéagueta baari peyaro doka majĩrã baawasiridijurire baaboema, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús igore ãrĩyupʉ: —Mʉ õãrõ yʉjʉa. Irasirigo mʉya wiigue goedujáaka! Wãtĩ mʉ magõrẽ ñajãdi wirisiami, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, igoya wiigue goedujáa, igo magõrẽ peyarogue oyagore bokajayupo. Wãtĩ igore ñajãdi wiriasiayupʉ. Irasirigo tariyupo. ");
INSERT INTO sri_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro wãĩkʉri makã tʉrogue ããrãdi dupaturi wiri, Sidón wãĩkʉri makãrẽ tariwãgã, Decápolis wãĩkʉri nikũrẽ tariwere, Galilea wãĩkʉri ditarugue ejayupʉ doja. ");
INSERT INTO sri_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Irogue ejamakʉ̃ ĩã, iro marã sugʉ gãmipũ pébire werenírĩ kukugʉre Jesús pʉro ãĩa: —Mʉya mojõrĩ merã ñapeoka ĩgʉ̃rẽ! ãrĩ sẽrẽñurã. ");
INSERT INTO sri_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Irasirigʉ Jesús masaka ĩãbero gapʉ ĩgʉ̃rẽ ãĩa, mojõsũrĩ merã pébiya gãmipũrĩrẽ soesóo, síku eopeo, ĩgʉ̃ya nedirure moãñayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pʉrʉ ʉ̃mʉgasigue ĩãmu, siuñajãnʉgãja, ãsũ ãrĩyupʉ: —Efata! ãrĩyupʉ. “Efata”, ãrĩrõ: “Toyoka!” ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, pébiya gãmipũrĩ toyoakõãyuro. Mata ĩgʉ̃ya nediru turadea niirõãmakʉ̃, õãrõ werenímasĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús gapʉ ĩgʉ̃rẽ taumakʉ̃ ĩãnerãrẽ: “Gajerãrẽ werebirikõãka!” ãrĩyupʉ. Ĩgʉ̃: “Werebirigorakõãka!” ãrĩkerepʉrʉ, ĩgʉ̃sã gapʉ gajerãrẽ werepeokõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bʉro ĩãgʉka, ʉsʉyari merã ãsũ ãrĩñurã: —Ããrĩpererire õãrõ yámi. Gãmipũ pémerãrẽ õãrõ pémakʉ̃ yámi. Werenímasĩmerãdere õãrõ werenímasĩmakʉ̃ yámi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pʉrʉ dupaturi wárã masaka Jesús pʉrogue nerẽanerãrẽ baari peremakʉ̃ ĩãgʉ̃, ĩgʉ̃ buerãrẽ siiu, ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ʉrenʉgora waáa, ĩĩsã masaka yʉ merã ããrĩrṍ. Ĩgʉ̃sãrẽ baari pereakõãa. Irasirigʉ ĩgʉ̃sãrẽ bopoñarĩ merã ĩãa. ");
INSERT INTO sri_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Surãyeri yoarogue aarinerã ããrĩmá. Ĩgʉ̃sã baamerãrẽta ĩgʉ̃sãya wiirigue goedujáadoremakʉ̃, maa dekota turabiriakõãbokuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃ buerã yʉjʉñurã: —¿Nasirisĩã, õõ masaka marĩrõguere baari boka ejobokuri marĩ ĩgʉ̃sãrẽ? ");
INSERT INTO sri_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús ĩgʉ̃sãrẽ sẽrẽñayupʉ: —¿Diíkʉ pã́ duparu opari mʉsã? —Su mojõma pere gaji mojõ peru pẽrẽbejari duparu opáa, ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Irasirigʉ Jesús masakare yebague doadore, iri pã́ duparure ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩyupʉ. Irasiri odo, pã́ duparure pea, ĩgʉ̃ buerãrẽ sĩyupʉ, masakare gueredoregʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Waaigã́dere mérãgã opañurã. Jesús ĩgʉ̃sãgãrẽ ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩ, iridere ĩgʉ̃ buerãrẽ masakare gueredoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ããrĩpererã irire baayapiakõãñurã. Pʉrʉ ĩgʉ̃sã baadʉáadeare Jesús buerã su mojõma pere gaji mojõ peru pẽrẽbejari puuiri seasã ʉtʉudoboñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iro baanerã: nome, majĩrã keoña marĩrõ ʉ̃ma direta keomakʉ̃, cuatro mil gora ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pʉrʉ Jesús ĩgʉ̃sãrẽ seretu, ĩgʉ̃ buerã merã doódirugue mʉrĩñajãa, Dalmanuta wãĩkʉri makã tʉrogue waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pʉrʉ fariseo bumarã Jesús merã werenírã ejañurã. Irasũ ejarã: “Marĩpʉ turari merã iri ĩmurĩrẽ irika!” ãrĩñurã. “Ĩgʉ̃ irire irimasĩbi, Marĩpʉ iriudi meta ããrĩ́mi”, ãrĩdʉarã, irasũ ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ĩgʉ̃sã irasiridoremakʉ̃ pégʉ, Jesús bʉro bʉjawereri merã siuñajãnʉgãja, ãrĩyupʉ: —Mʉsã dapora marã masaka, ¿nasirimurã Marĩpʉ turari merã iri ĩmurĩrẽ ĩãdʉari? Diayeta mʉsãrẽ werea. Marĩpʉ turari merã iri ĩmurĩrẽ mʉsã ĩũrõ neõ iribirikoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ĩgʉ̃sãrẽ irasũ ãrĩ odo, ĩgʉ̃sã iro nírõta, doódirugue mʉrĩñajãa, ditaru sikoepʉgue taribujakõãyupʉ ĩgʉ̃ buerã merã. ");
INSERT INTO sri_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Irogue taribujarã, ĩgʉ̃sã baaburire kãtikõãñurã. Doódiruguere suruta pã́ opañurã. ");
INSERT INTO sri_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Irasirigʉ Jesús ĩgʉ̃sãrẽ goepeyari merã wereyupʉ: —Fariseo bumarã, Herodeyarãya pã́ wemasãrĩ morẽrĩrẽ õãrõ pémasĩka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ĩgʉ̃ buerã gapʉ ĩgʉ̃ irasũ ãrĩrĩrẽ pémasĩmerã, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníñurã: —Marĩ pã́ opabirimakʉ̃ ĩãgʉ̃, irasũ ãrĩkumi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús, ĩgʉ̃sã irasũ ãrĩrĩrẽ masĩkõãyupʉ. Irasirigʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —¿Nasirirã: “Pã́ opabea”, ãrĩ gãme werenírĩ? ¿Masĩberi? ¿Pémasĩberi mʉsã dapa? ");
INSERT INTO sri_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Koye opakererã, ĩãberi? ¿Gãmipũrĩ opakererã, péberi? ¿Yʉ irideare gũñaberi mʉsã? ");
INSERT INTO sri_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Yʉ cinco mil masaka ʉ̃marẽ pe mojõma pã́ duparure yʉ dʉkawa sĩdeare gũñaberi? Ĩgʉ̃sã baayapiadero pʉrʉ, ¿diíkʉ puuiri ĩgʉ̃sã baadʉáadeare seasã ʉtʉudobori? ãrĩyupʉ Jesús. —Pe mojõma pere su gubu peru pẽrẽbejari puuiri, ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ: —Pʉrʉ su mojõma pere gaji mojõ peru pẽrẽbejari pã́ duparure cuatro mil masakare yʉ sĩdero pʉrʉ, ¿diíkʉ puuiri ĩgʉ̃sã baadʉáadeare seasã ʉtʉudobori? —Su mojõma pere gaji mojõ peru pẽrẽbejari puuiri, ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ĩgʉ̃sã irasũ ãrĩ yʉjʉmakʉ̃, ĩgʉ̃sãrẽ: —¿Mʉsã irire gũñakererã, pémasĩberi dapa? ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ditarure taribuja, pʉrʉ Betsaida wãĩkʉri makãrẽ ejañurã. Ĩgʉ̃sã irogue ejamakʉ̃ ĩãrã, iro marã sugʉ koye ĩãbire Jesús pʉro ãĩa: —Mʉya mojõ merã moãñaka, ĩgʉ̃rẽ taridoregʉ! ãrĩ, bʉro sẽrẽñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús koye ĩãbiya mojõrẽ ñeã, iri makã tʉrogue ĩgʉ̃rẽ tʉ̃ãwãgã, síku merã ĩgʉ̃ya koyere eopeoyupʉ. Irasiri odo, ĩgʉ̃ya mojõrĩ merã ĩgʉ̃rẽ ñapeo: —¿Mʉrẽ gajino deyori? ãrĩ sẽrẽñayupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ĩgʉ̃ ĩãpã, ĩãdiyupʉ. Irasirigʉ Jesúre: —Masakare ĩãdáa. Ĩgʉ̃sã yuku irirosũ deyorã waanamakʉ̃ ĩãa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús dupaturi ĩgʉ̃ya mojõrĩ merã ĩgʉ̃ya koyere ñapeoyupʉ doja. Iropãgueta ããrĩpereri õãrõ deyoyuro ĩgʉ̃ ĩãmakʉ̃. ");
INSERT INTO sri_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Irasirigʉ Jesús ĩgʉ̃rẽ: —Mʉya wiigue diayeta goedujáakõãka! Makãguere waabirikõãka! I mʉrẽ yʉ iriadeare gajerã masakare iro ããrĩrã́rẽ werebirikõãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pʉrʉ Jesús ĩgʉ̃ buerã merã Cesarea Filipo wãĩkʉri makã tʉro ããrĩrĩ́ makãrĩgue waañurã. Maa waagʉ́, ĩgʉ̃ buerãrẽ ãsũ ãrĩ sẽrẽñayupʉ: —Masaka yʉre, ¿naásũ ãrĩ gũñarĩ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ĩgʉ̃ buerã ĩgʉ̃rẽ yʉjʉñurã: —Surãyeri mʉrẽ: “Juan, masakare wãĩyerimasʉ̃ ããrĩ́mi”, ãrĩma. Gajerã: “Elías ããrĩ́mi”, gajerã: “Marĩpʉya kerere weredupuyurimasã merãmʉ ããrĩ́mi”, ãrĩma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Mʉsãkoa yʉre, ¿naásũ gũñarĩ? ãrĩ sẽrẽñayupʉ. Pedro ĩgʉ̃rẽ yʉjʉyupʉ: —Mʉ, Marĩpʉ iriudi, Cristo ããrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃sãrẽ: —Yʉ ããrĩrikʉrire gajerãrẽ werebirikõãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pʉrʉ ĩgʉ̃sãrẽ ãsũ ãrĩ buenʉgãyupʉ: —Yʉ ããrĩpererã tĩ́gʉ̃ bʉro ñerõ tarigʉkoa. Judío masaka mʉrã, paía oparã, Moisés gojadeare buerimasã yʉre gããmemerã yʉre wẽjẽrãkuma. Yʉre wẽjẽkerepʉrʉ, ʉrenʉ waaró merã masãgʉkoa doja, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ĩgʉ̃sãrẽ pémasĩma õãrõ wereyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro gapʉ Jesúre gajero gapʉ ãĩjanʉgã, ĩgʉ̃rẽ turaro merã: “Irire ãrĩbirikõãka!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús gapʉ gãmegoronʉgã, ĩgʉ̃ buerãrẽ ĩã, Pedrore ãrĩyupʉ: —Satanás, yʉ pʉrore wirika! Mʉ, Marĩpʉ yʉre dorerire kãmutadʉagʉ yáa. Mʉ gũñarĩ, Marĩpʉ gũñarĩ ããrĩbea. Masaka gũñarõsũ gũñáa mʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Irasũ ãrĩ odo, masakare, ĩgʉ̃ buerãrẽ siiu, ãrĩyupʉ: —Sugʉ yʉre tʉyadʉagʉ ĩgʉ̃ iridʉarire piriburo. Irasirigʉ yʉre tʉyari waja curusague pábiatú wẽjẽsũbu irirosũ ããrĩkeregʉ, neõ piriro marĩrõ yʉre tʉyaníkõãburo. ");
INSERT INTO sri_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sugʉ i ʉ̃mʉgue ĩgʉ̃ya okari direta maĩgʉ̃, peamegue waagʉkumi. Gajigʉ yʉre bʉremugʉ̃, Marĩpʉ masakare tauri kerere ĩgʉ̃ wereri waja gajerã ĩgʉ̃rẽ wẽjẽkerepʉrʉ, ĩgʉ̃ gapʉ tarigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sugʉ masakʉ i ʉ̃mʉmarẽ ããrĩpereri opakeregʉ, ĩgʉ̃ boari pʉrʉ waaburi gapʉre gũñabiri waja peamegue waagʉ́, õãrĩrẽ neõ wajatabirikumi. ");
INSERT INTO sri_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Irasirigʉ peameguere wiridʉagʉ, i ʉ̃mʉ opari merã neõ wajarimasĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Dapora marã ñerã Marĩpʉre gããmemerã ããrĩ́ma. Noó yʉre, yʉ werenírĩrẽ masĩkererã, gʉyasĩrĩrĩ merã yʉre: “Masĩbea”, ãrĩmakʉ̃, yʉde gʉyasĩrĩrĩ merã ĩgʉ̃sãrẽ: “Masĩbea”, ãrĩgʉkoa. Yʉ ããrĩpererã tĩ́gʉ̃, Yʉpʉ gosewasiriri merã, ĩgʉ̃rẽ wereboerã õãrã merã i ʉ̃mʉguere dupaturi aarigʉ́, yʉre gʉyasĩrĩnerãrẽ yʉde gʉyasĩrĩgʉkoa, ãrĩ wereyupʉ Jesús ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús ãrĩnemoyupʉ doja: —Diayeta mʉsãrẽ werea. Surãyeri mʉsã õõguere ããrĩrã́, mʉsã boaburo dupuyuro, Marĩpʉ ĩgʉ̃ turaro merã ĩgʉ̃yarãrẽ doreri aarimakʉ̃ ĩãrãkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jesús, su mojõma pere gaji mojõ suru pẽrẽbejarinʉrĩ pʉrʉ Pedrore, Santiagore, Juãrẽ ʉ̃marĩ buúrugue ĩgʉ̃sã direta siiu mʉrĩayupʉ. Irogue ĩgʉ̃sã ĩũrõ ĩgʉ̃ deyori gorawayuakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ĩgʉ̃ya suríro goseriñe, õãrõ borero waayuro. Neõ sugo nomeõ surí koego irasũ boreri waamakʉ̃ irimasĩgõ mámo. ");
INSERT INTO sri_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Irasũ waaripoeta iripoegue marã Moisés, Elías deyoanʉgã, Jesús merã weretamunímakʉ̃ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Irasirirã bʉro güiñurã. Pedro naásũ ãrĩmasĩbirisĩã, Jesúre: —Gʉare buegʉ, marĩ õõ ããrĩmakʉ̃ õãtaridʉáa. Irasirirã ʉre wiigã irirãra. Mʉya wii, Moiséya wii, Elíaya wii irirãra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ĩgʉ̃ irasũ ãrĩripoe su yebo mikãyebo dijari ĩgʉ̃sãrẽ túbiakõãyuro. Iri yebo poekague Marĩpʉ ãsũ ãrĩ werenímakʉ̃ péñurã: —Ĩĩ yʉ magʉ̃, yʉ maĩgʉ̃ ããrĩ́mi. Ĩgʉ̃rẽ õãrõ péka! ");
INSERT INTO sri_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Irasũ ãrĩmakʉ̃, Pedrosã gãmenʉgã ĩũrã, Moisére, Elíare ĩãbiriñurã. Jesús direta nímakʉ̃ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pʉrʉ Jesús buúru wekague ĩgʉ̃rẽ waamakʉ̃ ĩãdeare: “Gajerãrẽ werebirikõãka!” ãrĩ dijariyupʉ. —Yʉ ããrĩpererã tĩ́gʉ̃ boa, masãdero pʉrʉgue irire gajerãrẽ wereka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Irasirirã ĩgʉ̃ doreaderosũta gajerãrẽ werebirikererã, ĩgʉ̃sã basi gãme ãsũ ãrĩ sẽrẽñañurã: —“Yʉ boa, masãdero pʉrʉ”, ãrĩgʉ̃, ¿nasirigʉ irasũ ãrãyuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Irasirirã Jesúre ãsũ ãrĩ sẽrẽñañurã: —¿Nasirirã Moisés gojadeare buerimasã: “Cristo, Marĩpʉ iriubu aariburi dupuyuro Elías aaripʉrorigʉkumi”, ãrĩrĩ? ãrĩ sẽrẽñañurã. ");
INSERT INTO sri_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Mʉsã ãrĩrõsũta Elíata aaripʉrorigʉkumi, ããrĩpererire ãmuyubu. Marĩpʉya werenírĩ gojadea pũgue yʉre ããrĩpererã tĩ́gʉ̃rẽ waaburire ãsũ ãrĩ gojasũdero ããrĩbʉ́: Ĩgʉ̃ta bʉro ñerõ tarigʉkumi. Masaka ĩgʉ̃rẽ gããmebirikuma, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yʉ gapʉ mʉsãrẽ: “Elías ejasiami”, ãrã. Ĩgʉ̃ irasũ ejamakʉ̃, masaka ĩgʉ̃sã gããmerõ iridʉarire ĩgʉ̃rẽ ñerõ irima. Ĩgʉ̃rẽ waaburire iripoegue Marĩpʉya werenírĩ gojadea pũgue gojaderosũta ĩgʉ̃rẽ irisiama, ãrĩyupʉ Jesús Pedrosãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús Pedrosã merã buúrugue ããrãdi dijajagʉ, gajerã ĩgʉ̃ buerã pʉro wárã masaka nerẽanerãrẽ bokajayupʉ. Moisés gojadeare buerimasãde ããrĩñurã. Ĩgʉ̃ buerã merã gãme guaseorã iriñurã. ");
INSERT INTO sri_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pʉrʉ Jesúre ĩãrã, ããrĩpererã ĩãgʉka, ĩgʉ̃ pʉro ũmawãgã, ĩgʉ̃rẽ õãdoreñurã. ");
INSERT INTO sri_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús ĩgʉ̃ buerãrẽ: —¿Ñeénorẽ gãme guaseoari, mʉsã ĩgʉ̃sã merã? ãrĩ sẽrẽñayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ĩgʉ̃ sẽrẽñamakʉ̃ pégʉ, sugʉ ĩgʉ̃sã watope ããrĩgʉ̃́ Jesúre ãrĩyupʉ: —Buegʉ, mʉrẽ yʉ magʉ̃rẽ wãtĩ ñajãsũdire ãĩriabʉ. Wãtĩ ĩgʉ̃rẽ wereníbirimakʉ̃ irinami. ");
INSERT INTO sri_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Noó ĩgʉ̃ waaró wãtĩ ĩgʉ̃rẽ yebague ñeã meépiunokõãmi. Ĩgʉ̃ irasirimakʉ̃ ĩgʉ̃ya disigue sũmu wiri, ĩgʉ̃ya guikare kũrĩduútúa, bʉanokõãmi. Yʉ mʉ buerãrẽ: “Majĩgʉ̃rẽ wãtĩrẽ béowiubosaka!” ãrãdabʉ. Neõ bokatĩũbirama, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã yʉre bʉremurĩ opabirigorakõãa. ¿Noópã yoaripoe mʉsã merã ããrĩgʉkuri? ¿Noópã yoaripoe mʉsã yʉre bʉremubirire gũñaturagʉkuri? Majĩgʉ̃rẽ õõ gapʉ ãĩrika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Irasirirã majĩgʉ̃rẽ Jesús pʉro ãĩãñurã. Ĩgʉ̃ pʉro ãĩjamakʉ̃, wãtĩ Jesúre ĩãgʉ̃, majĩgʉ̃rẽ narada, yebague tũrũjamejã, sũmutumakʉ̃ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Irasũ waamakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃ pagʉre sẽrẽñayupʉ: —¿Diípoegue ãsũ waanʉgãrĩ ĩgʉ̃? ãrĩyupʉ. Ĩgʉ̃ pagʉ yʉjʉyupʉ: —Majĩgʉ̃gãgueta irasũ ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wãtĩ ĩgʉ̃rẽ wẽjẽdʉagʉ peamegue meémejã, diaguedere meébiamakʉ̃ irinami. Irasirigʉ mʉ gʉare iritamumasĩgʉ̃, bopoñarĩ merã ĩã, gʉare iritamuka! ãrĩyupʉ Jesúre. ");
INSERT INTO sri_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús ãrĩyupʉ ĩgʉ̃rẽ: —Marĩpʉ, mʉ yʉre bʉremumakʉ̃ ĩãgʉ̃, mʉya ããrĩburire irigʉ, ããrĩpererire irimasĩmi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, majĩgʉ̃ pagʉ ãsũ ãrĩ gainíyupʉ: —Mʉrẽ bʉremua. Nemorõ bʉremumakʉ̃ irika yʉre! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús, wárã masaka ĩgʉ̃sã pʉro ũma nerẽmakʉ̃ ĩãgʉ̃, wãtĩrẽ wiridoreyupʉ: —Ĩĩ majĩgʉ̃rẽ wereníbirimakʉ̃, pébirimakʉ̃ iridi ĩgʉ̃rẽ wirika! Dupaturi ĩgʉ̃rẽ ñajãbita pama! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, wãtĩ gainí, majĩgʉ̃rẽ bʉro naradari merã yebague tũrũjamejãmakʉ̃, kõmoadi irirosũ waamakʉ̃ irisĩã, ĩgʉ̃rẽ wiriyupʉ. Irasũ waamakʉ̃ ĩãrã, ããrĩpererã masaka: “Kõmoakõãmi”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús ĩgʉ̃ya mojõrẽ ñeã, ĩgʉ̃rẽ tʉ̃ãwãgũnúmakʉ̃, wãgãnʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pʉrʉ Jesús, wiigue ñajãjamakʉ̃, ĩgʉ̃ buerã masaka péberogue ĩgʉ̃rẽ sẽrẽñañurã: —¿Nasirirã gʉa gapʉ wãtĩrẽ béowiumasĩbirayuri? ");
INSERT INTO sri_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Ĩĩno wãtĩrẽ béowiudʉarã, bereri merã Marĩpʉre bʉro sẽrẽrõ gããmea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Pʉrʉ Jesús irogue ããrãdi ĩgʉ̃ buerã merã waa, Galilea nikũgue tariwerewãgãyupʉ. Ĩgʉ̃ waaróre gajerã masĩmakʉ̃ gããmebiradiyupʉ. Ĩgʉ̃ buerãrẽ buegʉ irasiriyupʉ. Ãsũ ãrĩ bueyupʉ ĩgʉ̃sãrẽ: —Masaka yʉre ããrĩpererã tĩ́gʉ̃rẽ ñeã, gajerãguere wẽjẽdorerã wiarãkuma. Ĩgʉ̃sã yʉre wẽjẽadero pʉrʉ, ʉrenʉ waaró merã masãgʉkoa doja, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ĩgʉ̃ irasũ ãrĩrĩrẽ ĩgʉ̃sã gapʉ pémasĩbiriñurã. Pémasĩbirikererã, ĩgʉ̃rẽ güirã: “¿Naásũ ãrĩdʉagʉ iriari, irasũ ãrĩgʉ̃?” ãrĩ sẽrẽñabiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesús Capernaugue eja, pʉrʉ wiigue ñajãja, ĩgʉ̃ buerãrẽ sẽrẽñayupʉ: —Mʉsã maa aarirã́, ¿ñeénorẽ gãme werení guaseowãgãrirã iriari? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, yʉjʉbiriñurã. Maa aarirã́, ĩgʉ̃sã basi: “¿Noã marĩ watopere ããrĩpererã nemorõ ããrĩgʉkuri?” ãrĩ werení guaseowãgãrirã iriñurã. Irasirirã Jesúre yʉjʉbiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ĩgʉ̃sã yʉjʉbirimakʉ̃ ĩãgʉ̃, Jesús eja doaja, ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarãrẽ siiu, ãsũ ãrĩyupʉ: —Sugʉ ããrĩpererãrẽ doregʉ ããrĩdʉagʉ ããrĩpererãrẽ moãboegʉ irirosũ ããrĩpererãrẽ iritamurõ gããmea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Irasũ ãrĩ, majĩgʉ̃rẽ ĩgʉ̃sã dekogue ãĩnú, ĩgʉ̃rẽ kõã, ĩgʉ̃ya gosowekague ãĩpeo, ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Sugʉ yaagʉre ĩĩ majĩgʉ̃ irirosũ ããrĩgʉ̃́rẽ õãrõ bokatĩrĩñeãgʉ̃ yʉdere bokatĩrĩñeãmi. Yʉre bokatĩrĩñeãgʉ̃ yʉ direta bokatĩrĩñeãgʉ̃ meta yámi. Yʉpʉ yʉre iriudidere bokatĩrĩñeãmi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pʉrʉ Juan Jesúre ãrĩyupʉ: —Gʉare buegʉ, sugʉ masakʉ mʉ wãĩ merã wãtẽãrẽ: “Wirika mʉsã ñajãdire!” ãrĩ béowiumakʉ̃ ĩãbʉ. Ĩgʉ̃, marĩ merã ããrĩbirimakʉ̃ ĩãrã, ĩgʉ̃rẽ: “Irire neõ irinemobirikõãka!” ãrãbʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús gapʉ ãrĩyupʉ: —Kãmutabirikõãka ĩgʉ̃rẽ! Neõ sugʉ yʉ wãĩ merã gajino iri ĩmugʉ̃, pʉrʉ yʉre ñerõ wereníbirikumi. ");
INSERT INTO sri_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Marĩrẽ ĩãturibi, marĩ merãmʉta ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Diayeta mʉsãrẽ werea. Mʉsãrẽ: “Cristoyarã ããrĩ́ma”, ãrĩ, mʉsãrẽ deko tĩãrãnorẽ diayeta Marĩpʉ ĩgʉ̃sãrẽ wajatari opamakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Sugʉ yʉre bʉremurãrẽ ĩĩ majĩgʉ̃ irirosũ ããrĩrã́rẽ ñerõ irimakʉ̃ irigʉno, bʉro wajamoãsũgʉkumi. Irasiriro, ĩgʉ̃ gajerãrẽ ñerõ irimakʉ̃ iriburi dupuyuro masaka ĩgʉ̃rẽ wáriye ʉ̃tãye merã wʉ̃́nugũgue siasiu, wádiyague meéyomakʉ̃ õãbokoa. ");
INSERT INTO sri_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Irasirirã mʉsãya mojõ merã ñerõ irirã, iri mojõrẽ dititá béorosũ ñerõ iririre pirika! Su mojõ merãta Marĩpʉ pʉrogue waamakʉ̃ õãtarirokoa. Ñerõ iririre pirimerã gapʉ perebiri peamegue béosũrãkuma. Ĩgʉ̃sã pe mojõ opakererã, irogue waamakʉ̃ ñetarirokoa. Iroguere peame neõ yaribirikoa. ");
INSERT INTO sri_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Beka irogue waarã́rẽ baaníkõãrãkuma. Neõ boabirikuma. Peame neõ yaribirikoa. ");
INSERT INTO sri_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","’Mʉsãya gubu merã ñerõ irirã, iri gubure dititá béorosũ ñerõ iririre pirika! Su gubu merãta, Marĩpʉ pʉrogue waamakʉ̃ õãtarirokoa. Ñerõ iririre pirimerã gapʉ perebiri peamegue béosũrãkuma. Ĩgʉ̃sã pe gubu opakererã, irogue waamakʉ̃ ñetarirokoa. Iroguere peame neõ yaribirikoa. ");
INSERT INTO sri_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Beka irogue waarã́rẽ baaníkõãrãkuma. Neõ boabirikuma. Peame neõ yaribirikoa. ");
INSERT INTO sri_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","’Mʉsãya koyeru merã ĩã, ñerõ irirã, irirure gorewea, béorosũ ñerõ iririre pirika! Su koyeruta opakererã, Marĩpʉ ĩgʉ̃yarãrẽ dorerogue waamakʉ̃ õãtarirokoa. Ñerõ iririre pirimerã gapʉ perebiri peamegue béosũrãkuma. Ĩgʉ̃sã pe koyegueta opakererã, irogue waamakʉ̃ ñetarirokoa. ");
INSERT INTO sri_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Beka irogue waarã́rẽ baaníkõãrãkuma. Neõ boabirikuma. Peame neõ yaribirikoa. ");
INSERT INTO sri_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’I ʉ̃mʉguere ããrĩpererã Marĩpʉre bʉremurã moã okari irirosũ ããrĩrã́, peamegue ʉ̃jʉ̃ pũrĩsũrõsũ ñerõ tariri merã õãrõ ããrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moã okamakʉ̃ õãgoráa. Irasirirã gajerã merã õãrõ ããrĩrã́ moã okari irirosũ ããrã. Moã okadea okabirimakʉ̃, dupaturi okamakʉ̃ irimasĩbirikoa. Irasirirã moã okari irirosũ ããrĩka! Gajerã merã õãrõ ããrĩníkõãka! ãrĩ wereyupʉ Jesús ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús Capernaugue ããrĩdi waa, Judea nikũgue eja, dia Jordán wãĩkʉdiya gaji koepʉgue ejayupʉ doja. Irogue wárã masaka ĩgʉ̃ pʉro nerẽmakʉ̃ ĩãgʉ̃, ĩgʉ̃ irinarõsũta dupaturi ĩgʉ̃sãrẽ bueyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ĩgʉ̃ bueripoe fariseo bumarã Jesúre ñerĩ werenímakʉ̃ iridʉarã, ãsũ ãrĩ sẽrẽñarã ejañurã: —Sugʉ masakʉ ĩgʉ̃ marãpore béomakʉ̃, ¿marĩ doreri ããrĩkuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —¿Naásũ doreyuri Moisés mʉsãrẽ? ");
INSERT INTO sri_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃rẽ ãsũ ãrĩñurã: —“Sugʉ masakʉ ĩgʉ̃ marãpore béodʉagʉ: ‘I waja mʉrẽ béoa’, ãrĩ gojari pũrẽ sĩrõ gããmea”, ãrĩ gojadi ããrĩmí, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, ãsũ ãrĩyupʉ Jesús: —Mʉsã ñekʉ̃sãmarã Marĩpʉ dorerire iridʉabirimakʉ̃ ĩãgʉ̃: “Ĩgʉ̃sã marãposã nomerẽ béodʉarã, béokõãburo”, ãrĩ gojadi ããrĩmí Moisés. ");
INSERT INTO sri_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ĩgʉ̃ irasũ ãrĩ gojakerepʉrʉ, neõgoragueta Marĩpʉ i ʉ̃mʉrẽ irigʉ, ʉ̃mʉ́ʉ, nomeõ iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sugʉ ʉ̃mʉ́ʉ ĩgʉ̃ pagʉsãmarãrẽ wiri, ĩgʉ̃ marãpo merã ããrĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Irasirirã ĩgʉ̃sã pẽrã ããrĩkererã, Marĩpʉ ĩũrõ su dupʉta irirosũ ããrĩrãkuma. Irasirirã pẽrã ããrĩbema. Su dupʉta irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Marĩpʉ ĩgʉ̃sãrẽ su dupʉta irirosũ ããrĩmakʉ̃ iridero pʉrʉ, gajigʉ ĩgʉ̃sãrẽ gãme béomakʉ̃ iribirikõãrõ gããmea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jesús irasũ ãrĩ odo, ĩgʉ̃ buerã merã wiigue ñajãkõãyupʉ. Irogue ĩgʉ̃ buerã irire sẽrẽñanemoñurã doja. ");
INSERT INTO sri_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Sugʉ masakʉ ĩgʉ̃ marãpore béodi gajego merã marãpokʉgʉ, igo merã ñerõ irigʉ yámi. ");
INSERT INTO sri_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nomeõde igo marãpʉre béogo, gajigʉ merã marãpʉkʉgo, ĩgʉ̃ merã ñerõ irigo yámo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pʉrʉ masaka majĩrãrẽ Jesúre moãñadorerã ĩgʉ̃ pʉro ãĩjañurã. Ĩgʉ̃sã ãĩjamakʉ̃ ĩãrã, ĩgʉ̃ buerã gapʉ ĩgʉ̃sãrẽ bokatĩrĩ: “Ĩgʉ̃rẽ garibobirikõãka!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sã merã gua, ãsũ ãrĩyupʉ: —Majĩrã yʉ pʉrogue aariburo. Kãmutabirikõãka ĩgʉ̃sãrẽ! Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ããrĩmurã ĩĩsã majĩrã yʉre ʉsʉyari merã bokatĩrĩñeãrã irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Diayeta mʉsãrẽ werea. Ĩĩsã majĩrã Marĩpʉre ĩgʉ̃sã Opʉre gããmerã irirosũ ããrĩmerãno, ĩgʉ̃yarãrẽ doreroguere waabirikuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Irasũ ãrĩ odo, majĩrãrẽ ãĩ, kõã, ĩgʉ̃sãrẽ ñapeo, Marĩpʉre ĩgʉ̃sãya ããrĩburire sẽrẽbosayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús irogue ããrãdi waaripoe sugʉ maamʉ ũmaja, ĩgʉ̃ ñadʉkʉpuri merã Jesúya guburi pʉro ejamejãja, sẽrẽñayupʉ: —Õãgʉ̃ buegʉ, yʉ ʉ̃mʉgasigue perebiri okarire wajatadʉagʉ, ¿ñeénorẽ irigʉkuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —¿Nasirigʉ yʉre: “õãgʉ̃”, ãrĩrĩ? Marĩpʉ sugʉta õãgʉ̃ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mʉ, ĩgʉ̃ doreri pídeare masĩa: “Masakare wẽjẽbirikõãka! Gajigʉ marãpo merã ñerõ iribirikõãka! Yajabirikõãka! Gajerã irideare ãrĩgatori merã werebirikõãka! Gajerãyare ãrĩgatori merã ãĩbirikõãka! Mʉ pagʉsãmarãrẽ goepeyari merã bʉremuka!” ãrĩ wereyupʉ Jesús ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Maamʉ Jesúre yʉjʉyupʉ: —Buegʉ, iri doreri ããrĩpererire majĩgʉ̃gueta tarinʉgãbiribʉ yʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús ĩgʉ̃rẽ maĩrĩ merã ĩã, ãsũ ãrĩyupʉ: —Mʉrẽ su wãĩ dʉyáa. Mʉ oparire duagʉ waaka! Mʉ duadea wajare boporãrẽ sĩka! Irasirigʉ ʉ̃mʉgasiguere wári õãrĩ opagʉkoa. Irasiri odo, yʉ merã aarika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ wári oparire maĩsĩã, bʉro bʉjawereri merã waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ĩgʉ̃ bʉjawereri merã waamakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃ buerãrẽ ĩã, ãrĩyupʉ: —Wári doebiri oparãrẽ Marĩpʉ ĩgʉ̃yarãrẽ doreroguere ĩgʉ̃sã waadʉamakʉ̃ diasagoráa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃sã gapʉ pégʉka, pémasĩbiriñurã. Jesús dupaturi werenemoyupʉ doja ĩgʉ̃sãrẽ: —Yʉ buerã, mʉsãrẽ werea. Masaka: “Wári opari merã õãrõ waarokoa yʉre”, ãrĩ gũñarãrẽ Marĩpʉ ĩgʉ̃yarãrẽ doreroguere ĩgʉ̃sã waamakʉ̃ diasagoráa. ");
INSERT INTO sri_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camellu awiru gobegãgue ñajãtariweremasĩbirikumi. I nemorõ, wári doebiri opagʉre Marĩpʉ ĩgʉ̃yarãrẽ doreroguere waamakʉ̃ diasáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, nemorõ pégʉka, ĩgʉ̃sã basi gãme sẽrẽñanurã: —Iro merẽ, ¿noã gapʉ Marĩpʉ tausũmurã ĩgʉ̃ pʉrogue waamurã ããrĩbokuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús ĩgʉ̃sãrẽ ĩã, ãrĩyupʉ: —Masaka ĩgʉ̃sã basi ĩgʉ̃sã iriri merã Marĩpʉ pʉrogue waamasĩbema. Marĩpʉ dita ĩgʉ̃sãrẽ ĩgʉ̃ pʉro ããrĩmurã waamakʉ̃ irimasĩmi. Ĩgʉ̃ dita ããrĩpererire irimasĩmi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ĩgʉ̃rẽ ãrĩyupʉ: —Gʉa Opʉ, gʉa mʉrẽ tʉyarã, ããrĩpereri gʉa opadeare pípeokõãbʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús yʉjʉyupʉ: —Diayeta mʉsãrẽ werea. Yʉ merã Marĩpʉya kerere wererã waarã́, ĩgʉ̃sãya wiirire, ĩgʉ̃sã pagʉpũrãrẽ, pagʉsãmarãrẽ, pũrãrẽ, ĩgʉ̃sãya pooerire pípeorã, wári õãrĩ wajatarãkuma. ");
INSERT INTO sri_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ĩgʉ̃sã iro dupuyuro opaderosũ i ʉ̃mʉguere cien nemorõ ĩgʉ̃sãya wiiri, ĩgʉ̃sã pagʉpũrã, pagosã nome, pũrã, ĩgʉ̃sãya pooeri oparãkuma. Ĩgʉ̃sã, yaarã ããrĩmakʉ̃ ĩãrã, gajerã ĩgʉ̃sãrẽ ñerõ tarimakʉ̃ irikerepʉrʉ, wári õãrĩ wajatarãkuma. I ʉ̃mʉ peremakʉ̃, ʉ̃mʉgasigue perebiri okari oparãkuma. ");
INSERT INTO sri_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wárã daporare wári oparã, pʉrʉguere neõ gajino opamerã dujarãkuma. Opamerã gapʉ, pʉrʉguere wári oparã dujarãkuma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pʉrʉ Jesús Jerusalẽ́gue waarí maague ĩgʉ̃ buerã dupuyuro majãyupʉ. Ĩgʉ̃ dupuyumakʉ̃ ĩãrã, ĩãgʉkakõãñurã. “¿Marĩrẽ irogue naásũ waarokuri?” ãrĩ gũña, güiri merã ĩgʉ̃ pʉrʉ tʉyañurã. Irasirigʉ Jesús ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarãrẽ siiu, ĩgʉ̃rẽ waaburire werenʉgãyupʉ doja: ");
INSERT INTO sri_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Õãrõ péka! Marĩ Jerusalẽ́gue waarã́ yáa. Irogue yʉ ããrĩpererã tĩ́gʉ̃, paía oparãguere, Moisés gojadeare buerimasãguere wiasũgʉkoa. Ĩgʉ̃sã yʉre: “Boaburo”, ãrĩrãkuma. Irasirirã judío masaka ããrĩmerãguere wiarãkuma. ");
INSERT INTO sri_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ĩgʉ̃sã yʉre bʉrida, síku eotúbira, bʉro tãrãrãkuma. Irasiri odo, yʉre wẽjẽrãkuma. Ĩgʉ̃sã yʉre wẽjẽadero pʉrʉ, ʉrenʉ waaró merã masãgʉkoa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pʉrʉ Zebedeo pũrã Santiago, Juan Jesús pʉro waa ejanʉgã, ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽñurã: —Gʉare buegʉ, gʉa sẽrẽrõsũta gʉare irika! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús ĩgʉ̃sãrẽ sẽrẽñayupʉ: —¿Ñeénorẽ yʉ irimakʉ̃ gããmerĩ mʉsã? ");
INSERT INTO sri_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ĩgʉ̃rẽ yʉjʉñurã: —Mʉ Opʉ ñajãgʉ̃, gʉadere mʉ merã doremurã sóoka! Sugʉre mʉ diaye gapʉ, gajigʉre kúgapʉ doadoreka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã yʉre sẽrẽrĩrẽ pémasĩbea. Yʉ bʉro ñerõ tarigʉkoa. ¿Yʉ ñerõ tarirosũ mʉsãde ñerõ tarirã, bokatĩũrãkuri? ¿Yʉre ĩgʉ̃sã wẽjẽrõsũ mʉsãdere ĩgʉ̃sã wẽjẽmakʉ̃, bokatĩũrãkuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Bokatĩũkõãrãkoa, ãrĩ yʉjʉñurã. Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Yʉ irirosũ mʉsãde ñerõ tari, boarãkoa. ");
INSERT INTO sri_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yʉ gapʉ mʉsãrẽ yʉ diaye, kúgapʉ doamurãrẽ beyemasĩbea. Yʉpʉ ãmusiadi ããrĩmí irire. Irasirirã ĩgʉ̃ beyenerã dita yʉ diaye, kúgapʉ doarãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gajerã Jesús buerã pe mojõmarã gapʉ Santiago, Juan ĩgʉ̃sã Jesúre sẽrẽrĩrẽ pérã, ĩgʉ̃sã merã guañurã. ");
INSERT INTO sri_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ĩgʉ̃sã guamakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃sãrẽ ĩgʉ̃ pʉro siiu neeõ, ãrĩyupʉ: —I nikũ marã oparã Marĩpʉre bʉremumerã ĩgʉ̃sãyarãrẽ turaro merã dorema, ĩgʉ̃sã dorerire iridorerã. Irire masĩa mʉsã. ");
INSERT INTO sri_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉsã tamerã ĩgʉ̃sã irirosũ iribirikoa. Mʉsã watopeguere opʉ ããrĩdʉagʉ, mʉsãrẽ moãboegʉ irirosũ ããrĩrṍ gããmea. ");
INSERT INTO sri_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sugʉ mʉsã watopegue ããrĩgʉ̃́ gajerã nemorõ ããrĩdʉagʉ, ããrĩpererãrẽ moãboegʉ irirosũ ããrĩburo. ");
INSERT INTO sri_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yʉde irasũta ããrã. Yʉ ããrĩpererã tĩ́gʉ̃ masaka yʉre iritamuburo, ãrĩgʉ̃ meta aaribʉ́. Yʉ gapʉ ĩgʉ̃sãrẽ iritamugʉ̃ aaribʉ́. Irasirigʉ wárã masakare yʉ boari merã ĩgʉ̃sã ñerõ iridea wajare wajaribosagʉ aarigʉ́ iribʉ, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pʉrʉ Jesús ĩgʉ̃ buerã merã Jericógue ejayupʉ. Iri makãrẽ tariwãgãmakʉ̃, wárã masaka ĩgʉ̃sã merã waañurã. Ĩgʉ̃sã waarí maa tʉro sugʉ koye ĩãbi doayupʉ. Ĩgʉ̃ Bartimeo wãĩkʉgʉ, Timeo magʉ̃ ããrĩyupʉ. Ʉ̃mʉrikʉ iri maa tʉro masakare niyeru sẽrẽ doanínayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Masaka: “Jesús Nazaretmʉ aarími”, ãrĩmakʉ̃ pégʉ, ãsũ ãrĩ gainínʉgãyupʉ: —Jesús, David parãmi ããrĩturiagʉ, yʉre bopoñarĩ merã ĩãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ĩgʉ̃ irasũ ãrĩ gainímakʉ̃ pérã, wárã masaka: “Toeaka!” ãrãdiñurã. Ĩgʉ̃sã irasũ ãrĩkerepʉrʉ, ĩgʉ̃ gapʉ ĩgʉ̃ gainíadero nemorõ: —David parãmi ããrĩturiagʉ, yʉre bopoñarĩ merã ĩãka! ãrĩ gainíyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, Jesús dujanʉgãja, masakare: —Siiurika ĩgʉ̃rẽ! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gajerã ĩgʉ̃rẽ siiu: “Ʉsʉyaka! Wãgãnʉgãka! Mʉrẽ siiumi”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pé, ĩgʉ̃ya suríro wekamañerẽ túweapí, pari wãgãnʉgã, Jesús pʉro ejanʉgãjayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús ĩgʉ̃rẽ sẽrẽñayupʉ: —¿Ñeénorẽ yʉ mʉrẽ irimakʉ̃ gããmerĩ? ãrĩyupʉ. Bartimeo yʉjʉyupʉ: —Buegʉ, yʉre koye ĩãmakʉ̃ irika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Mʉ yʉre bʉremurĩ opáa. Irasirigʉ tausũa, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, koye ĩãbiradi õãrõ ĩãmasĩakõãyupʉ. Pʉrʉ maague Jesúre tʉyawãgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pʉrʉ Jesús ĩgʉ̃ buerã merã Jerusalẽ́gue ejaburo dupuyuro, Betfagé, Betania wãĩkʉri makãrĩ pʉro ejapʉroriyupʉ. Iri makãrĩ Olivos wãĩkʉri buúru ããrĩdujimejãrõ ããrĩyuro. Irogue ejagʉ, Jesús pẽrã ĩgʉ̃ buerãrẽ ãsũ ãrĩ iriuyupʉ: ");
INSERT INTO sri_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Si makã marĩ bokatĩũrõ ããrĩrĩ́ makãgue waaka! Irogue ejarã, sugʉ burrore ĩgʉ̃sã sianúadire neõ suñarõ peyasũña marĩgʉ̃rẽ bokajarãkoa. Ĩgʉ̃rẽ kura, ãĩrika! ");
INSERT INTO sri_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sugʉ mʉsãrẽ: “¿Nasirimurã yári?” ãrĩmakʉ̃: “Marĩ Opʉ gããmeami. Dapora wiagʉkumi doja”, ãrĩka! ãrĩ iriuyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ĩgʉ̃ irasũ ãrĩmakʉ̃, pẽrã waa, maa tʉro ããrĩrĩ́ wii disipʉro burrore ĩgʉ̃sã sianúadire bokaja, ĩgʉ̃rẽ kurañurã. ");
INSERT INTO sri_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ĩgʉ̃sã irasirimakʉ̃ ĩãrã, iro ããrĩrã́ sẽrẽñañurã: —¿Nasirirã yári? ¿Nasirimurã burrore kurari? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, Jesús ãrãderosũta wereñurã. Ĩgʉ̃sã irasũ ãrĩ weremakʉ̃ pérã: “Ãĩaka!” ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pʉrʉ burrore Jesús pʉrogue ãĩãñurã. Ãĩja, ĩgʉ̃sãya wekama suríre túwea, burro weka peoñurã. Jesús ĩgʉ̃ wekague mʉrĩbeja waayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Masaka wárã ĩgʉ̃sãya wekama suríre túwea ãĩ, ĩgʉ̃ waaburi maarẽ́ sẽõpídupuyuñurã ĩgʉ̃rẽ bʉremurã. Gajerã yukʉ dʉpʉri pũrikʉrire diti, maarẽ́ pídupuyuñurã, ĩgʉ̃ waarí maa õãrĩ maa ããrĩburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Irasirirã ĩgʉ̃ dupuyuro waarã́, ĩgʉ̃ pʉrʉ tʉyarãde ãsũ ãrĩ gainíñurã: Marĩ Opʉre ʉsʉyari sĩrã! Ĩĩ Marĩpʉ marĩrẽ taugʉ iriudi õãrõ aariburo. ");
INSERT INTO sri_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Marĩ Opʉ ñajãburi õãrõ aariburo. Marĩ ñekʉ̃ David opʉ ããrĩderosũta õãrõ ããrĩburo. Marĩpʉre: “Õãtaria mʉ ããrĩpererã Opʉ ʉ̃mʉgasigue ããrĩgʉ̃́”, ãrĩ, ʉsʉyari sĩrã! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Irasirigʉ Jesús Jerusalẽ́gue eja, Marĩpʉya wiigue ñajãa, ããrĩpereri iri wiimague ããrĩrĩ́rẽ ĩãpeokõãyupʉ. Ĩã odo, Betaniague ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarã merã waayupʉ. Ĩgʉ̃sã irogue waaripoere ñamikague ããrĩsiayuro. ");
INSERT INTO sri_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gajinʉ gapʉ Betaniague ããrãnerã Jerusalẽ́gue goedujáañurã doja. Jesús irogue goedujáagʉ, ʉaboakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yoarogue merã higuera wãĩkʉdire õãrõ pũrikʉdire ĩã: “Dʉkakʉkoa”, ãrĩgʉ̃ ĩãgʉ̃ waadiyupʉ. Irigʉ gapʉ dʉka marĩyuro. Dʉkakʉripoe ããrĩbiriyuro. Irasirigʉ pũrĩ direta bokajayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Irigʉ dʉka marĩmakʉ̃ ĩãgʉ̃, Jesús ãsũ ãrĩyupʉ: —Igʉ dʉkare masaka neõ dupaturi baabirikuma. Neõ dʉkakʉbirikoa, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃ buerã péñurã. ");
INSERT INTO sri_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pʉrʉ Jerusalẽ́gue eja, Jesús Marĩpʉya wiigue ñajãyupʉ. Irogue doebiri duarãrẽ, wajarirãdere béowiuyupʉ. Niyeru gorawayurimasãya niyeru sãñarĩ kũmarĩrẽ yomeéwiunokõãyupʉ. Bujare dua doanírãya doaripẽrĩdere irasũta iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","“Neõ duari ãĩ ñajãbirikõãka, Marĩpʉya wiiguere!” ãrĩyupʉ Jesús masakare. ");
INSERT INTO sri_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ãsũ ãrĩ bueyupʉ ĩgʉ̃sãrẽ: —Marĩpʉ ĩgʉ̃ya werenírĩ gojadea pũgue ãsũ ãrĩdi ããrĩmí: “Yaa wii, yʉre bʉremurã yʉre sẽrẽrĩ wii wãĩkʉrokoa. Irasirirã ããrĩpereri nikũ marã i wiigue yʉre sẽrẽrã aarirãkuma”, ãrĩdi ããrĩmí. Mʉsã gapʉ, ĩgʉ̃ irasũ ãrĩkerepʉrʉ, yajarimasãya wii irirosũ ããrĩmakʉ̃ yáa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ããrĩpererã masaka pégʉkakõãñurã. Irasirirã paía oparã, Moisés gojadeare buerimasãde ĩgʉ̃rẽ güiñurã. “¿Nasiri ĩĩrẽ wẽjẽrãkuri?” ãrĩ gũñamañurã. ");
INSERT INTO sri_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pʉrʉ naĩmejãripoe Jesús ĩgʉ̃ buerã merã iri makãrẽ wiriwãgãkõãyupʉ doja. ");
INSERT INTO sri_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gajinʉ boyoripoe maague waarã́, higueragʉ nugũrĩgue merãta ñaĩnʉgãdire ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro irigʉre Jesús ãrãdeare gũña, ĩgʉ̃rẽ ãrĩyupʉ: —Buegʉ, ĩãka! Igʉ higueragʉ mʉ boadoredi boakõãsiayo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús yʉjʉyupʉ: —Marĩpʉre bʉremuka! ");
INSERT INTO sri_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Diayeta mʉsãrẽ werea. Sugʉ Marĩpʉre bʉremugʉ̃, ĩgʉ̃rẽ: “I buúrure dia wádiyague béoka!” ãrĩmakʉ̃, ĩgʉ̃ ãrãderosũta waarokoa. Mʉsã: “Marĩpʉ ãsũ irimasĩbirikumi”, ãrĩ gũñarõ marĩrõ: “Ĩgʉ̃rẽ yʉ sẽrẽaderosũta waarokoa”, ãrĩ bʉremumakʉ̃, Marĩpʉ diayeta irasirigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Irasirigʉ mʉsãrẽ irire weregʉra doja. Marĩpʉre sẽrẽrã: “Yʉ sẽrẽrõsũta waarokoa yʉre”, ãrĩ bʉremumakʉ̃, mʉsã sẽrẽrõsũta irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Irasirirã Marĩpʉre mʉsã sẽrẽburo dupuyuro gajerã mʉsãrẽ ñerõ iridea waja ĩgʉ̃sã merã guarire pirika! Ĩgʉ̃sã ñerõ irideare kãtika! Irasirimakʉ̃ ĩãgʉ̃, Mʉsãpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ mʉsã ñerõ irideare kãtigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Gajerã mʉsãrẽ ñerõ irideare mʉsã kãtibirimakʉ̃ ĩãgʉ̃, ĩgʉ̃de mʉsã ñerõ irideare kãtibirikumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, dupaturi Jerusalẽ́gue waañurã doja. Irogue eja, Jesús Marĩpʉya wiigue waanamakʉ̃ ĩãrã, paía oparã, Moisés gojadeare buerimasãde, judío masaka mʉrã merã ĩgʉ̃ pʉrogue waa ejanʉgã, ");
INSERT INTO sri_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ĩgʉ̃rẽ sẽrẽñañurã: —¿Noã mʉrẽ doreri mʉ irasirimakʉ̃? ¿Noã mʉrẽ: “Ãsũ irika!” ãrĩrĩ? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Yʉde mʉsãrẽ sẽrẽñagʉra. Mʉsã yʉjʉmakʉ̃, yʉde mʉsãrẽ yʉjʉgʉra. ");
INSERT INTO sri_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Noã Juãrẽ masakare deko merã wãĩyedoregʉ iriuyuri, Marĩpʉ, o masaka? Yʉjʉka! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníñurã: —“Marĩpʉ Juãrẽ doredi ããrĩmí”, marĩ ãrĩmakʉ̃, Jesús marĩrẽ: “¿Nasirirã ĩgʉ̃ weredeare bʉremubiriri mʉsã?” ãrĩbokumi. ");
INSERT INTO sri_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ããrĩpererã masaka: “Diayeta Juan Marĩpʉya kerere weredupuyudi ããrĩmí”, ãrĩ gũñama. Marĩ: “Masaka Juãrẽ wãĩyedorenerã ããrĩmá”, ãrĩmakʉ̃, masaka marĩ merã guabokuma, ãrĩñurã. Masakare güisĩã, irire irasũ ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Irasirirã: “Masĩbirikoa”, ãrĩ yʉjʉñurã Jesúre. Irasirigʉ Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã yʉre: “¿Noã mʉrẽ irire doreri?” ãrĩ sẽrẽñadeare yʉde mʉsãrẽ yʉjʉbea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pʉrʉ Jesús paía oparãrẽ, Moisés gojadeare buerimasãrẽ, judío masaka oparãrẽ keori merã ãsũ ãrĩ wereyupʉ: —Sugʉ masakʉ ĩgʉ̃ya pooegue iguidarire otekumi. Ote odo, iri pooe tʉro ʉ̃tãyeri merã sãrĩsãkumi. Ʉ̃tãyegue igui kʉrabipiri gobere irikumi. Wii ʉ̃marĩ wiigãrẽ irikumi, iri pooere korerã õãrõ ĩã koreburo, ãrĩgʉ̃. Irasiri odo, gajerãrẽ iri pooere wayu: “Yaa oteri dʉkare yʉre deko merã sĩrãkoa, yʉ mʉsãrẽ iri pooere wayuri waja”, ãrĩkumi. Irasũ ãrĩ odo, gajerogue waakõãkumi. ");
INSERT INTO sri_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pʉrʉ igui ñíripoe ejamakʉ̃, ĩgʉ̃rẽ moãboegʉre ĩgʉ̃ya pooere moãrã pʉrogue iriukumi, ĩgʉ̃ya pooema oteri dʉkare deko merã sẽrẽdoregʉ. ");
INSERT INTO sri_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Iri pooere moãrã gapʉ ĩgʉ̃ irogue ejamakʉ̃ ĩãrã, ĩgʉ̃rẽ ñeã, pákuma. Neõ gajino sĩrõ marĩrõ ĩgʉ̃rẽ iridujukuma. ");
INSERT INTO sri_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pʉrʉ iri pooe opʉ gajigʉ ĩgʉ̃rẽ moãboegʉre iriukumi doja. Ĩgʉ̃rẽ dipurure pá, kãmitúkuma. Ĩgʉ̃rẽ bʉrida, iridujukuma. ");
INSERT INTO sri_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Iri pooe opʉ gajigʉre iriukumi doja. Ĩgʉ̃rẽ wẽjẽkõãkuma. Pʉrʉ wárã iriukumi doja. Surãyerire pá, gajerãrẽ wẽjẽkõãkuma. ");
INSERT INTO sri_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Irasirigʉ iri pooe opʉ magʉ̃, ĩgʉ̃ bʉro maĩgʉ̃ dita dʉyakumi. “Yʉ magʉ̃rẽ bʉremurãkuma”, ãrĩ gũñarĩ merã ĩgʉ̃rẽ iriutũnuadikumi. ");
INSERT INTO sri_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Iri pooere moãrã gapʉ ĩgʉ̃ magʉ̃ ejamakʉ̃ ĩãrã, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníkuma: “Ĩĩta pʉrʉguere i pooere opabu ããrĩ́mi. Ĩgʉ̃rẽ wẽjẽkõãrã! Irasirirã marĩ basi i pooere oparãkoa”, ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Irasirirã ĩgʉ̃rẽ ñeã, wẽjẽ, pooe tʉrogue ĩgʉ̃ya dupʉre ãĩwãgã béokõãkuma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Irasũ ãrĩ odo, ĩgʉ̃sãrẽ sẽrẽñayupʉ: —Iro merẽ pooe opʉ, ¿nasirigʉkuri ĩgʉ̃ya pooere moãrãrẽ? Ãsũ irigʉkumi. Irogue waa, ĩgʉ̃sãrẽ wẽjẽ, ĩgʉ̃ya pooere gajerã gapʉre sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Mʉsã Marĩpʉya werenírĩ gojadea pũrẽ ire buebiriri? Ãsũ ãrĩ gojasũdero ããrĩbʉ́: Suye ʉ̃tãye wii iririmasã ĩgʉ̃sã béoadeaye merã gajigʉ gapʉ õãrõ turari wii irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Marĩpʉ irasiridi ããrĩmí. Marĩ ĩgʉ̃ irasirideare ĩãrã: “Õãtaria”, ãrĩ gũñáa, ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ Jesús ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Judío masaka oparã ĩgʉ̃ i keori merã irasũ ãrĩ weremakʉ̃ pérã: “Marĩrẽ: ‘Ĩgʉ̃sã irirosũ ñerã ããrã’, ãrĩgʉ̃ irikumi”, ãrĩ pémasĩ, ĩgʉ̃rẽ ñeã, peresu iridʉadiñurã. Irasiridʉakererã: “Masaka ĩgʉ̃rẽ marĩ irasirimakʉ̃ ĩãrã, marĩ merã guabokuma”, ãrĩ gũñañurã. Irasirirã ĩgʉ̃sãrẽ güi, Jesúre pirikõã, gajerogue waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pʉrʉ Jesúre weresãdʉarã, surãyeri fariseo bumarãrẽ, Herodeya bumarãdere Jesús pʉrogue ĩgʉ̃rẽ wári sẽrẽña, diaye yʉjʉbirimakʉ̃ iridorerã iriuñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ĩgʉ̃sã iriuanerã Jesús pʉrogue ejarã, ãsũ ãrĩñurã: —Buegʉ, mʉ iririkʉrire masĩa. Mʉ ãrĩgatoro marĩrõ werenía. Marĩpʉyare diayeta buea. “¿Naásũ gũñarĩ masaka yʉre?” ãrĩ gũñarõ marĩrõ diayeta ĩgʉ̃sãrẽ werea. Oparãrẽ, ubu ããrĩrã́dere ããrĩpererãrẽ sʉrosũta ĩãa. Irasirigʉ gʉare wereka! Romano marã opʉ marĩrẽ niyeru wajasearire marĩ wajarimakʉ̃, ¿õãgorari, o õãberi? ¿Wajariro gããmerĩ, o wajaribirikõãrõ gããmerĩ? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús gapʉ ĩgʉ̃sã irigatori merã ĩgʉ̃rẽ ñerõ iridʉarire masĩsĩã, ãsũ ãrĩyupʉ: —¿Nasirirã yʉ ñerõ yʉjʉmakʉ̃ iridʉari mʉsã? Niyeru tire yʉre ãĩrika! Iri tire ĩãmurã! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, suti ãĩãñurã. Jesús ĩgʉ̃sãrẽ sẽrẽñayupʉ: —I tiguere, ¿noãya diapu keori, noãya wãĩ tuuyari? ãrĩyupʉ. —Romano marã opʉya diapu keori, ĩgʉ̃ wãĩta tuuyáa, ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Irasirigʉ Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Iro merẽ romano marã opʉya ããrĩrĩ́rẽ ĩgʉ̃rẽ sĩka! Marĩpʉya gapʉre Marĩpʉre sĩka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pʉrʉ surãyeri saduceo bumarã Jesús pʉrogue ejañurã. Ĩgʉ̃sã: “Masaka boanerãgue masãbirikuma”, ãrĩ bʉremurã ããrĩñurã. Irasirirã Jesúre ãsũ ãrĩñurã: ");
INSERT INTO sri_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Buegʉ, Moisés marĩrẽ ãsũ ãrĩ gojapídi ããrĩmí: “Sugʉ marãpokʉdi pũrã marĩkeregʉ igore boaweomakʉ̃, ĩgʉ̃ pagʉmʉ igore dúunorẽgʉkumi. Irasirirã, ĩgʉ̃ igo merã pũrãkʉrã ĩgʉ̃ tĩ́gʉ̃ dagʉ pũrã irirosũta ããrĩrãkuma”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iripoeguere sugʉ pũrã su mojõma pere gaji mojõ peru pẽrẽbejarã ããrĩunanerã ããrĩmá. Ĩgʉ̃sã tĩ́gʉ̃ gapʉ marãpokʉ, pũrã marĩgʉ̃ta boakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Irasirigʉ ĩgʉ̃ dagʉ dokamʉta ĩgʉ̃ marãpo ããrĩdeore dúunorẽyupʉ. Ĩgʉ̃de, ĩgʉ̃ tĩ́gʉ̃ dagʉ irirosũta pũrã marĩgʉ̃ta boakõãyupʉ. Ĩgʉ̃sã pẽrã dokamʉde pũrã marĩgʉ̃ta boakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Irasũ dita pũrã marĩrãta boapereakõãñurã. Ĩgʉ̃sã pʉrʉ ĩgʉ̃sã marãpode boakõãyupo pama. ");
INSERT INTO sri_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ĩgʉ̃sã su mojõma pere gaji mojõ peru pẽrẽbejarã ʉ̃ma igore marãpokʉadiñurã. Irasirirã boanerã masãmakʉ̃, ¿niíno marãpogora ããrĩgokuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Mʉsã diaye gũñabea. Marĩpʉya werenírĩ gojadeare, ĩgʉ̃ turaridere mʉsã neõ masĩbea. ");
INSERT INTO sri_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Boanerã ĩgʉ̃sã masãdero pʉrʉ, ĩgʉ̃sã ʉ̃mʉgasigue Marĩpʉre wereboerã irirosũ ããrĩrãkuma. Iroguere marãpokʉbirikuma. Ĩgʉ̃sã pũrã nomedere nomesubirikuma. ");
INSERT INTO sri_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Moisés gojadea pũguere boanerã ĩgʉ̃sã masãburire buebiriri? Iripoeguere yukʉgãgue ʉ̃jʉ̃rõgue Marĩpʉ Moisére ãsũ ãrĩdi ããrĩmí: “Yʉ Abraham, Isaac, Jacob Opʉta ããrã”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Irasirirã ĩgʉ̃sã boanerã ããrĩkererã, Marĩpʉ merã okarã ããrĩ́ma. Irasirigʉ Marĩpʉ boanerã dupaturi masãbirimurã Opʉ ããrĩbemi. Okarã, boanerãgue dupaturi masãmurã Opʉ ããrĩ́mi. Irasirirã mʉsã: “Boanerã masãbirikuma”, ãrĩ gũñarã, diaye gũñabea, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ĩgʉ̃sã Jesús merã wereníripoe sugʉ Moisés gojadeare buerimasʉ̃ ĩgʉ̃sã pʉro ejayupʉ. Jesús ĩgʉ̃ õãrõ yʉjʉrire pé, ãsũ ãrĩ sẽrẽñayupʉ ĩgʉ̃rẽ: —¿Dií gapʉ Marĩpʉ doreri gaji doreri nemorõ ããrĩ́rĩ? ");
INSERT INTO sri_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Gaji doreri nemorõ ããrĩrĩ́ i ããrã: “Israel bumarã õãrõ péka! Marĩpʉ sugʉta mʉsã Opʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Irasirirã mʉsãya yʉjʉpũrãrĩ merã, mʉsã ããrĩrikʉri merã, ããrĩpereri mʉsã gũñarĩ merã, mʉsã turari merã Marĩpʉre mʉsã Opʉre maĩka!” ");
INSERT INTO sri_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","I doreri pʉrʉma ãsũ ãrã: “Mʉ basi maĩrõsũta mʉ pʉro ããrĩrã́rẽ maĩka!” I pe dorerita gaji ããrĩpereri doreri nemorõ ããrã, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Moisés gojadeare buerimasʉ̃ ãsũ ãrĩ yʉjʉyupʉ: —Buegʉ, irasũta ããrã. Mʉ ãrĩrĩ diayeta ããrã. Marĩpʉ sugʉta ããrĩ́mi. Gajigʉ ĩgʉ̃ irirosũ ããrĩgʉ̃́ mámi. ");
INSERT INTO sri_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Marĩrẽ marĩya yʉjʉpũrãrĩ merã, marĩ gũñarĩ merã, ããrĩpereri marĩ turari merã Marĩpʉre maĩrõ gããmea. Marĩ basi maĩrõsũta gajerãrẽ maĩrõ gããmea. Marĩpʉre bʉremurã ĩgʉ̃ ĩũrõ waimʉrã wẽjẽ soepeomakʉ̃ õãgoráa. I nemorõ Marĩpʉre, masakadere marĩ maĩmakʉ̃ õãtaria, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ĩgʉ̃ pémasĩrĩ merã õãrõ yʉjʉmakʉ̃ ĩã, Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Mérõ dʉyáa, Marĩpʉ mʉ Opʉ ããrĩrĩ́rẽ mʉ pémasĩburo, ãrĩyupʉ. Jesús irire irasũ ãrãdero pʉrʉ, neõ sugʉ ĩgʉ̃rẽ sẽrẽñanemobiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús Marĩpʉya wiigue buegʉ, ãsũ ãrĩ sẽrẽñayupʉ: —¿Nasirirã Moisés gojadeare buerimasã: “Cristo, David parãmi ããrĩturiagʉ ããrĩ́mi”, ãrĩrĩ? ");
INSERT INTO sri_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David, Cristo ñekʉ̃ ããrĩkeregʉ, Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃rẽ weredorederosũta ãsũ ãrĩ gojadi ããrĩmí: Marĩpʉ yʉ Opʉre ãsũ ãrĩmi: “Õõ, yʉ diaye gapʉ doaka, yʉ merã dorebu! Irasiriripoe mʉrẽ ĩãturirãrẽ mʉ dorerire tarinʉgãnemobirimakʉ̃ irigʉra”, ãrĩmi, ãrĩ gojadi ããrĩmí David. ");
INSERT INTO sri_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David, Cristo ñekʉ̃ ããrĩkeregʉ, ĩgʉ̃rẽ: “Yʉ Opʉ ããrĩ́mi”, ãrĩdi ããrĩmí. ¿Nasirigʉ, Cristo, David parãmi ããrĩturiagʉ ããrĩkerepʉrʉ, David ĩgʉ̃rẽ irasũ ãrĩyuri? ãrĩyupʉ Jesús. Wárã masaka iri wiigue ããrĩrã́ ĩgʉ̃ wererire ʉsʉyari merã péñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús ãsũ ãrĩ buenemoyupʉ: —Moisés gojadeare buerimasã ñerõ iririre õãrõ pémasĩka! Oparã irirosũ surí yoari sãña, masaka ĩũrõgue waagorenama. Makã dekoguere masakare õãrõ bʉremurĩ merã ĩgʉ̃sãrẽ bokatĩrĩ õãdoremakʉ̃ gããmema. ");
INSERT INTO sri_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Marĩ nerẽrĩ wiiriguere ñajãrã, õãrĩ doaripẽrĩgue dita doadʉama. Bosenʉrĩ ããrĩmakʉ̃dere oparã doarigue dita doadʉama. ");
INSERT INTO sri_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wapiweyarã nome wajamomakʉ̃ ĩã, ĩgʉ̃sãya wiirire ẽmanokõãma. Ĩgʉ̃sãrẽ bopoñarĩ merã ĩãbirikererã, yoaripoe Marĩpʉre sẽrẽ ĩmugatoma, masaka ĩgʉ̃sãrẽ: “Marĩpʉre õãrõ bʉremuma”, ãrĩburo, ãrĩrã. Ĩgʉ̃sã irasiriri waja, Marĩpʉ ĩgʉ̃sãrẽ gajerãrẽ wajamoãrõ nemorõ wajamoãgʉkumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pʉrʉ Jesús Marĩpʉya wiima ĩgʉ̃sã ãmuburi niyeru neeõrĩ kũma pʉro masaka ĩgʉ̃sã niyeru sãmakʉ̃ ĩã doaníyupʉ. Wári doebiri oparã iri kũmaguere wáro niyeru sãñurã. ");
INSERT INTO sri_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sugo wapiweyo iri kũma pʉro ejanʉgã, pe tigã mérõgã wajakʉri tirigãrẽ sãyupo. ");
INSERT INTO sri_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iri tirire igo sãmakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃ buerãrẽ siiu, ãrĩyupʉ: —Diayeta mʉsãrẽ werea. Igo wapiweyo bopogo niyeru sĩgõ, Marĩpʉ ĩũrõ gajerã ããrĩpererã sĩadero nemorõ sĩamo. ");
INSERT INTO sri_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gajerã wári doebiri oparã wáro sĩkerepʉrʉ, ĩgʉ̃sãya wáro dʉyáa. Igo gapʉ bopogo ããrĩkerego, igo baari wajariboadeare ããrĩpereri sĩpeokõãmo Marĩpʉre bʉremugõ, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Marĩpʉya wiigue ããrãdi wiriaripoe sugʉ ĩgʉ̃ buegʉ ãsũ ãrĩyupʉ: —Gʉare buegʉ, ĩãka i wiire pagari ʉ̃tãyeri merã iridea wii miẽrẽ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Mʉsã i wiire wári wiire daporare ĩãdáa. Pʉrʉgue neõ suye ʉ̃tãye gajiye weka weamʉrĩadeade dujabirikoa. Ããrĩpereri mʉtãdijapereakõãrokoa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pʉrʉ Jesús ĩgʉ̃ buerã merã Olivos wãĩkʉri buúru Marĩpʉya wii bokatĩũrõ ããrĩrĩ́ buúrugue waayupʉ. Jesús irogue eja doamakʉ̃, Pedro, Santiago, Juan, Andrés ĩgʉ̃rẽ ĩgʉ̃sã seyaro sẽrẽñañurã: ");
INSERT INTO sri_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Gʉare wereka! ¿Naásũ ããrĩmakʉ̃, mʉ ãrãderosũ waarokuri? ¿Ñeéno iri ĩmugʉkuri, iri ããrĩpereri irasũ waaburi dupuyuro? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Õãrõ pémasĩka! Gajerã mʉsãrẽ ãrĩgatorire pébirikõãka! ");
INSERT INTO sri_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wárã ãrĩgatorimasã aarirãkuma. “Yʉ Marĩpʉ iriudi Cristo ããrã”, ãrĩrãkuma. Ĩgʉ̃sã irasũ ãrĩgatomakʉ̃ pérã, wárã masaka ĩgʉ̃sãrẽ bʉremurãkuma. ");
INSERT INTO sri_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Masaka mʉsã pʉro gãmewẽjẽrĩrẽ pérã, yoarogue marã gãmewẽjẽrĩ kerere pérã, gʉkabirikõãka! Irasũta waarokoa. Irasũ waakerepʉrʉ, i ʉ̃mʉ pereburo dʉyarokoa dapa. ");
INSERT INTO sri_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Su bumarã, gaji bumarã merã gãmewẽjẽrãkuma. Su nikũ marã, gaji nikũ marã merã gãmewẽjẽrãkuma. Wári makãrĩguere nikũ ñomerokoa. Masaka wárã ʉaboari merã boarãkuma. I ããrĩpereri merã masaka ñerõ taripʉroriwãgãrirãkuma. ");
INSERT INTO sri_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Gajerã mʉsãrẽ ñeã, ãĩa, oparãguere ñerõ iridorerã wiarãkuma. Mʉsã judío masaka nerẽrĩ wiirigue ããrĩmakʉ̃, mʉsãrẽ párãkuma. Mʉsã yʉre bʉremurĩ waja makãrĩ marã oparã pʉrogue, iri nikũ marã oparã pʉrogue ãĩãsũrãkoa. Irasirimakʉ̃, mʉsã Marĩpʉya õãrĩ kerere wererãkoa ĩgʉ̃sãrẽ. Irasirirã mʉsã basi õãrõ pémasĩka! ");
INSERT INTO sri_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","I ʉ̃mʉ pereburo dupuyuro Marĩpʉyare wererã ããrĩpereri buri marãrẽ ĩgʉ̃ya kerere wererãkuma. ");
INSERT INTO sri_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Masaka mʉsãrẽ oparã pʉrogue ãĩãmakʉ̃: “¿Naásũ ãrĩrãkuri ĩgʉ̃sãrẽ?” ãrĩ gũñarikʉmerãta waaka! Oparã mʉsãrẽ sẽrẽñamakʉ̃, Marĩpʉ gũñarĩ sĩrĩ merã wererãkoa. Irasirirã mʉsã basi wereníbirikoa. Õãgʉ̃ deyomarĩgʉ̃ iritamurĩ merã, ĩgʉ̃ werenírĩ sĩrĩ merã wererãkoa. ");
INSERT INTO sri_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’I ʉ̃mʉ pereburo dupuyuro masaka ĩgʉ̃sã pagʉpũrãrẽ, ĩgʉ̃sã tĩ́rãrẽ oparãguere wẽjẽdorerã wiarãkuma. Pagʉsãmarã ĩgʉ̃sã pũrãrẽ, pũrã ĩgʉ̃sã pagʉsãmarãrẽ oparãguere wẽjẽdorerã wiarãkuma. ");
INSERT INTO sri_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yʉre mʉsã bʉremurĩ waja ããrĩperero marã masaka mʉsãrẽ ĩãturi doorãkuma. Mʉsãrẽ ĩgʉ̃sã ñerõ irikerepʉrʉ, yʉre bʉremurĩrẽ piribirimakʉ̃, Marĩpʉ mʉsãrẽ taugʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’I ʉ̃mʉ pereburo dupuyuro ñegʉ̃rẽ Marĩpʉre ĩãturigʉre ĩãrãkoa. Marĩpʉya wiigue ĩgʉ̃rẽ ããrĩdorebiridea wiigue nímakʉ̃ ĩãrãkoa. Iripoegue Marĩpʉya kerere weredupuyudi Daniel ĩgʉ̃rẽ gojadi ããrĩmí. Ĩgʉ̃ gojadeare buegʉno, pémasĩburo. Ãsũ ãrĩ gojadi ããrĩmí: “Iro ĩgʉ̃ nímakʉ̃ ĩãrã, Judea nikũgue ããrĩrã́ buurígue ũmaduriburo”. ");
INSERT INTO sri_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Irasũ waaripoere masakare ñerõ waarokoa. Sugʉ ĩgʉ̃ya wii wekague ããrĩgʉ̃́ wii poekague ĩgʉ̃yare ãĩgʉ̃ ñajãbirikõãburo. ");
INSERT INTO sri_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sugʉ ĩgʉ̃ya pooerigue ããrĩgʉ̃́de ĩgʉ̃ya suríre wiigue ãĩgʉ̃ dujáabirikõãburo. ");
INSERT INTO sri_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Irasũ waarínʉrĩrẽ nijĩpagosã nome, gajerã ĩgʉ̃sã pũrã mirĩrãgã oparã nomede bʉro ñerõ tarirãkuma. ");
INSERT INTO sri_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Irasirirã Marĩpʉre ãsũ ãrĩ sẽrẽka: “Puibʉ ããrĩmakʉ̃, irasũ waabirikõãburo”, ãrĩ sẽrẽka! ");
INSERT INTO sri_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","’Irasũ waarínʉrĩrẽ masaka ñerõ tarirãkuma. Marĩpʉ i ʉ̃mʉrẽ iripʉroridero pʉrʉre masaka ñerõ taridero nemorõ ñerõ tarirãkuma. I ĩgʉ̃sãrẽ ñerõ waaburi neõ dupaturi irasũ waanemobirikoa. ");
INSERT INTO sri_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Irasirigʉ Marĩpʉ masakare i ñerõ waaríre: “Yoaripoe waabirikõãburo”, ãrĩgʉkumi. Ĩgʉ̃ irasiribirimakʉ̃, neõ sugʉ masakʉ taribiribokumi. Irasirigʉ ĩgʉ̃ beyenerãrẽ bopoñasĩã, ĩgʉ̃sãrẽ ñerõ waaríre: “Iropãta waaburo”, ãrĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Irasũ ñerõ waaripoere gajerã mʉsãrẽ: “Ĩãka! Õõta Cristo ããrĩ́mi”, o “Sõõ ããrãmi Cristo”, ãrĩmakʉ̃ pérã, bʉremubirikõãka! ");
INSERT INTO sri_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wárã ãrĩgatorikʉrã aarirãkuma. Surãyeri: “Yʉ Marĩpʉ iriudi Cristo ããrã”, o “Marĩpʉya kerere weredupuyurimasã ããrã”, ãrĩrãkuma. Irasirirã masakare ĩgʉ̃sã ãrĩgatorire bʉremudorerã, wári gajino iri ĩmurãkuma. Irasirikererã, Marĩpʉ beyenerãrẽ ĩgʉ̃rẽ bʉremuduúmakʉ̃ irimasĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Iri irasũ waaburi dupuyuro mʉsãrẽ i ããrĩpererire weresiáa. Irasirirã õãrõ pémasĩka! ãrĩ wereyupʉ Jesús ĩgʉ̃ buerãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesús ãsũ ãrĩ werenemoyupʉ ĩgʉ̃sãrẽ: —Irasũ ñerõ waarínʉrĩ pʉrʉ, abe ʉ̃mʉmʉ naĩtĩãkõãgʉkumi. Ñamimʉde boyonemobirikumi. ");
INSERT INTO sri_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Neñukã ʉ̃mʉgasigue ããrĩrã́ yuridijarirãkuma. Ʉ̃marõgue marã turarãde naradari merã béosũrãkuma. ");
INSERT INTO sri_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Irasũ waaripoere masaka yʉ ããrĩpererã tĩ́gʉ̃, bʉro turari merã, gosewasiriri merã mikãyebogue i nikũguere dupaturi aarimakʉ̃ ĩãrãkuma. ");
INSERT INTO sri_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yʉre wereboerãrẽ ããrĩperero i nikũguere iriugʉra. Irasirirã yaarãrẽ Marĩpʉ beyenerãrẽ ããrĩpererogue ããrĩrã́rẽ yʉ pʉrogue neeõrãkuma. ");
INSERT INTO sri_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ire mʉsã masĩburo, ãrĩgʉ̃, higueragʉ keori merã weregʉra. Irigʉ pũ maamamakʉ̃ ĩãrã: “Bojori waaburo mérõgã dʉyáa”, ãrĩ masĩa. ");
INSERT INTO sri_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Irigʉ waarósũta i ããrĩpereri yʉ ãrĩrĩ irasũ waamakʉ̃ ĩãrã: “Marĩpʉ iriudi dupaturi aariburo mérõgã dʉyáa”, ãrĩ masĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Diayeta mʉsãrẽ werea. I ããrĩpereri yʉ ãrĩrĩ, dapora marã ĩgʉ̃sã boapereburo dupuyuro irasũ waarokoa. ");
INSERT INTO sri_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ʉ̃mʉgasi, i nikũde pereakõãrokoa. Yʉ werenírĩ gapʉ neõ perebirikoa. Ããrĩpereri yʉ mʉsãrẽ ãrĩrõsũta waayuwarikʉrokoa. ");
INSERT INTO sri_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Yʉ dupaturi aariburinʉrẽ, iri horare neõ sugʉ masĩbemi. Marĩpʉre wereboerã ʉ̃mʉgasigue ããrĩrã́de masĩbema. Yʉ Marĩpʉ magʉ̃de masĩbea. Yʉpʉ sugʉta masĩmi. ");
INSERT INTO sri_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Mʉsãde yʉ aariburinʉrẽ masĩbea. Irasirirã õãrõ pémasĩrĩ merã yúka! “Gʉare iritamuka!” ãrĩ sẽrẽka Marĩpʉre! ");
INSERT INTO sri_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I keori merã mʉsãrẽ weregʉra. Wii opʉ yoarogue gãmeñajãgʉ̃ waaburi dupuyuro ĩgʉ̃rẽ moãboerãrẽ ĩgʉ̃ya wiire koredorekumi. Surãyerire ĩgʉ̃ moãrĩrẽ píkumi. Gajigʉre wii disipʉro koredorekumi, ĩgʉ̃ dujariburire õãrõ yúdoregʉ. ");
INSERT INTO sri_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Irasiri odo, waakõãkumi. Ĩgʉ̃rẽ moãboerã gapʉ ĩgʉ̃ dujariburinʉrẽ neõ masĩbirikuma. Ñamika, o ñami deko, ãgãbo wereripoe, o boyoripoe aaribokumi. Ĩgʉ̃sã õãrõ yúbirimakʉ̃, ĩgʉ̃ gũñaña marĩrõ aarigʉ́, ĩgʉ̃sãrẽ kãrĩrãrẽ bokajagʉkumi. Wii opʉre moãboerã ĩgʉ̃ dujariburinʉrẽ ĩgʉ̃sã masĩbiriderosũta mʉsãde yʉ dupaturi aariburinʉrẽ masĩbea. ");
INSERT INTO sri_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gũñaña marĩrõ yʉ aariburire masĩrã, yʉre õãrõ pémasĩrĩ merã yúka! Sugʉ kãrĩgʉ̃ irirosũ ããrĩgʉ̃́ yʉre õãrõ yúbirikumi. Ĩgʉ̃ irirosũ ããrĩbirikõãka! ");
INSERT INTO sri_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yʉ mʉsãrẽ ãrĩrĩrẽ ããrĩpererãrẽ ãrĩgʉra. Õãrõ pémasĩrĩ merã yúka! ãrĩ wereyupʉ Jesús ĩgʉ̃ buerãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Penʉ pascua bosenʉ, judío masaka pã́ wemasãrĩ morẽña marĩrĩ baari bosenʉ dʉyaripoe paía oparã, Moisés gojadeare buerimasã nerẽñurã. Jesúre ãrĩgatori merã ĩgʉ̃sã ĩgʉ̃rẽ ñeã, wẽjẽburire ãmuñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Irire ãmurã́, ãsũ ãrĩñurã: —I bosenʉ ããrĩmakʉ̃ ĩgʉ̃rẽ ñeãbirikõãrã! Masaka marĩ merã guarã, marĩrẽ gainí turibokuma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betania wãĩkʉri makãgue, Simón kãmi boadiya wiigue ããrĩyupʉ. Ĩgʉ̃ iri wiigue ããrĩrã́ merã baa doaníripoe sugo nomeõ suru sʉ̃rõdiru opago Jesús pʉro ejanʉgãyupo. Igo opadiru “alabastro” wãĩkʉri ʉ̃tãye merã iridiru, sʉ̃rõrĩ “nardo” wãĩkʉri wajapari opadiru ããrĩyuro. Irirure tũpã, Jesúya dipurure piupeoyupo. ");
INSERT INTO sri_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Gajerã iri wiigue ããrĩrã́ igo irasirimakʉ̃ ĩãrã, gua, ãsũ ãrĩ gãme wereníñurã: —¿Nasirigo iri sʉ̃rõrĩrẽ irasiriwasiribéokõãrĩ? ");
INSERT INTO sri_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Igo irire duamakʉ̃, trescientos niyeru tiri su bojori moã wajataropã wiriboakuyo. Iri waja merã boporãrẽ iritamuboakumo, ãrĩñurã. Igo irasiririre suyubiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús gapʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —Igore garibobirikõãka! ¿Nasirirã igore garibori? Igo yʉre õãrĩrẽ yámo. ");
INSERT INTO sri_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Boporã mʉsã watopeguere ããrĩníkõãrãkuma. Irasirirã ĩgʉ̃sãrẽ iritamudʉarã iritamumasĩa. Yʉ tamerãrẽ mʉsã merã ããrĩnímakʉ̃ ĩãbirikoa. ");
INSERT INTO sri_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Igo õãrõ iridʉaro bokatĩũrõ yʉre õãrõ iriamo. Yaa dupʉre masãgobegue ĩgʉ̃sã píburi dupuyuro ãmuyugo, yʉre sʉ̃rõrĩ piupeosiamo. ");
INSERT INTO sri_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Diayeta mʉsãrẽ werea. Marĩpʉ masakare tauri kerere wererã ããrĩperero i ʉ̃mʉgue waagorenarã, igo yʉre irideadere gajerãrẽ wererãkuma, igore gũñaburo, ãrĩrã, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pʉrʉ Judas Iscariote wãĩkʉgʉ sugʉ Jesús buerã pe mojõma pere su gubu peru pẽrẽbejarã watopemʉ paía oparã pʉrogue waa, ĩgʉ̃ Jesúre ĩgʉ̃sãguere ĩgʉ̃rẽ ĩmuburire wereníyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ʉsʉyari merã: “Ĩgʉ̃rẽ mʉ gʉare ĩmumakʉ̃, niyeru mʉrẽ wajarirãkoa”, ãrĩñurã. Irasirigʉ Judas: “¿Naásũ ããrĩmakʉ̃ ĩgʉ̃sãrẽ yʉ Jesúre wiamakʉ̃ õãkuri?” ãrĩ gũñayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pʉrʉ judío masaka pã́ wemasãrĩ morẽña marĩrĩ baari bosenʉ pʉroririnʉ ããrĩmakʉ̃, Marĩpʉ ĩũrõ oveja majĩrãrẽ wẽjẽ baañurã. Irinʉta Jesús buerã ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽñañurã: —¿Noógue mʉ pascua bosenʉ baaburire ãmumakʉ̃ gããmekuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pé, Jesús ĩgʉ̃ buerã pẽrãrẽ ãsũ ãrĩ iriuyupʉ: —Jerusalẽ́gue waaka! Irogue sugʉ dekosoro kõãwãgãgʉ̃ mʉsãrẽ bokatĩrĩgʉkumi. Ĩgʉ̃rẽ tʉyaka! ");
INSERT INTO sri_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ĩgʉ̃, wiigue ñajãmakʉ̃, iri wii opʉre: “Gʉare buegʉ, ãsũ ãrĩ sẽrẽñadoreami: ‘¿Dií taribugue yʉ buerã merã i pascua bosenʉrẽ baagʉkuri?’ ãrãmi”, ãrĩka! ");
INSERT INTO sri_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mʉsã irasũ ãrĩmakʉ̃ pé, wári taribu ʉ̃marõgue ãmuadea taribuguere ĩmugʉkumi. Irogue marĩ baaburire ãmuka! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Irasirirã iri makãgue waa, irogue eja, Jesús wereaderosũta bokaja, pascua bosenʉ baaburire ãmuñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pʉrʉ naĩmejãripoe Jesús ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarã merã iri taribugue baagʉ ejayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ĩgʉ̃sã baa doaníripoe Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Diayeta mʉsãrẽ werea. Sugʉ mʉsã watopemʉ yʉ merã baa doanígʉ̃ta yʉre wẽjẽdʉarãguere yʉre ĩmugʉkumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, bʉro bʉjawereri merã sugʉno dita ĩgʉ̃rẽ sẽrẽñayoñurã: —¿Yʉ ããrĩ́rĩ mʉrẽ ĩmubu? ãrĩñurã. Gajerãde irasũ dita ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Sugʉ mʉsã pe mojõma pere su gubu peru pẽrẽbejarã watopemʉ yʉ merã baagʉta ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Marĩpʉya werenírĩ gojadea pũgue gojaderosũta yʉre ããrĩpererã tĩ́gʉ̃rẽ waaró yáa. Yʉre ĩmubu gapʉre ñetariro waarokoa. Ĩgʉ̃ deyoabirimakʉ̃ õãboyo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jesús, ĩgʉ̃sã baaripoe pã́rẽ ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩ, pea, ĩgʉ̃sãrẽ ãsũ ãrĩ guereyupʉ: —Ire baaka! Yaa dupʉ ããrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pʉrʉ iiríripare ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩ, ĩgʉ̃sãrẽ iripare sĩyupʉ. Irasirirã ããrĩpererã iiríñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —I yaa dí ããrã. Yʉ masakare boabosagʉ yaa dí béori merã wárãrẽ Yʉpʉ: “Ĩgʉ̃sãrẽ õãrõ irigʉra”, ãrĩdeare iriyuwarikʉgʉkoa. ");
INSERT INTO sri_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Diayeta mʉsãrẽ werea. Igui dekore marĩ dapora iirírosũ yʉ dupaturi neõ iirínemobirikoa. Pʉrʉ Yʉpʉ ĩgʉ̃yarãrẽ dorerogue mʉsã merã maama igui dekore iirígʉkoa, ãrĩyupʉ Jesús ĩgʉ̃ buerãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pʉrʉ Marĩpʉre bayapeo odo, Olivos wãĩkʉri buúrugue waakõãñurã doja. ");
INSERT INTO sri_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Irogue Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã ããrĩpererã gũñaturaro marĩrõ yʉre béowãgãpereakõãrãkoa. Mʉsã irasiriburire Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojasũdero ããrĩbʉ́: Yʉ oveja koregʉre wẽjẽmakʉ̃ irigʉkoa. Irasirimakʉ̃, ĩgʉ̃yarã oveja ũmawasiriakõãrãkuma, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yʉ boadigue masãdero pʉrʉ, mʉsã dupuyuro Galileague waadupuyugʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro gapʉ Jesúre ãrĩyupʉ: —Ĩgʉ̃sã ããrĩpererã mʉrẽ béowãgãkerepʉrʉ, yʉ gapʉ mʉrẽ neõ béowãgãbirikoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Mʉrẽ diayeta werea. Dapagã ñami ãgãbo pea wereburi dupuyuro mʉ yʉre masĩkeregʉ ʉrea gajerãrẽ: “Masĩbea”, ãrĩgatogʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro ĩgʉ̃rẽ ãrĩyupʉ: —Yʉ mʉ merã boabu ããrĩkeregʉ: “Masĩbea”, ãrĩgatobirikoa, ãrĩyupʉ. Ããrĩpererã ĩgʉ̃ buerã Pedro ãrĩrõsũ dita ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pʉrʉ Getsemaní wãĩkʉrogue ejañurã. Irogue Jesús ĩgʉ̃ buerãrẽ: —Õõta doaka mʉsã dapa! Marĩpʉre sẽrẽgʉ̃ waagʉ́ yáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Irasũ ãrĩ odo, Pedro, Santiago, Juãrẽ siiuwãgãyupʉ. Ĩgʉ̃ bʉro gũñarikʉ, bʉjawereyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ĩgʉ̃sãrẽ ãrĩyupʉ: —Bʉro bʉjawereri merã kõmoma goero péñakoa. Kãrĩmerãta õõ doa yúka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Irasũ ãrĩ odo, yoaweyaro waanemo, yebague moomejãja, Marĩpʉre ãsũ ãrĩ sẽrẽyupʉ: —Aʉ, ããrĩpererire irimasĩa mʉ. I yʉ ñerõ tariburire taudʉagʉ tauka! Yʉ irasũ ãrĩkerepʉrʉ, yʉ gããmerõsũ iribirikõãka! Mʉ gããmerõsũ gapʉ yʉre waaburo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pʉrʉ ĩgʉ̃sã pʉrogue ejagʉ, ĩgʉ̃sã kãrĩrãrẽ bokajayupʉ. Pedrore ãrĩyupʉ: —Simón, ¿kãrĩgʉ̃ yári? ¿Nasirigʉ su horanogora yʉre kãrĩbita yúmasĩberi? ");
INSERT INTO sri_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kãrĩmerãta! Marĩpʉre sẽrẽka, wãtĩ ãrĩmesãrĩrẽ iribokoa, ãrĩrã! Mʉsã gũñarĩ merã õãrĩrẽ iridʉadáa. Irire iridʉakererã, bokatĩũbea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Irasũ ãrĩ odo, Marĩpʉre ĩgʉ̃ sẽrẽaderosũta dupaturi sẽrẽgʉ̃ waayupʉ doja. ");
INSERT INTO sri_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dupaturi ĩgʉ̃sã pʉro ejagʉ, kãrĩrãrẽta bokajayupʉ doja. Ĩgʉ̃sãrẽ wʉja pũrĩtariyuro. Irasirirã, naásũ ãrĩ yʉjʉmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ʉreagora kãrĩrãrẽ bokajagʉ, Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Siuñajã, kãrĩka pama! Iropãta ejáa. Yʉre ããrĩpererã tĩ́gʉ̃rẽ ñerãguere wiari hora ejasiáa. ");
INSERT INTO sri_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wãgãnʉgãka! Náka, waarã́! Yʉre wẽjẽdʉarãguere yʉre ĩmubu aarisiami, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ĩgʉ̃ irasũ ãrĩ wereripoe Judas, Jesús buerã pe mojõma pere su gubu peru pẽrẽbejarã watopemʉ ããrãdi ejayupʉ. Wárã masaka sareri majĩrĩ, yukʉ dʉkari opanerã Jesús pʉrore ĩgʉ̃ merã ejañurã. Ĩgʉ̃sã paía oparã, Moisés gojadeare buerimasã, judío masaka mʉrã iriuanerã ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ĩgʉ̃sã Jesús pʉro ejaburi dupuyuro Judas ĩgʉ̃sãrẽ ãsũ ãrĩ weredi ããrĩmí: “Yʉ ĩgʉ̃ya wayupãrãrẽ mimigʉ̃ta ããrĩgʉkumi. Ĩgʉ̃rẽ ñeã, õãrõ sia, ãĩaka!” ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas, Jesús pʉro ejagʉta: “Gʉare buegʉ”, ãrĩ, ĩgʉ̃ya wayupãrãrẽ mimiyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ĩgʉ̃ mimimakʉ̃ ĩãrã, Judas merã aaranerã Jesúre turaro merã ñeãwãgãñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sugʉ Jesús buegʉ gapʉ paía opʉre moãboegʉre sareri majĩ merã ĩgʉ̃ya gãmipũrẽ dititá dijukõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús gapʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —¿Nasirirã sareri majĩrĩ merã, yukʉ dʉkari merã sugʉ yajarimasʉ̃rẽ ñeãrã aarirã́ irirosũ yʉre ñeãrã aaríri? ");
INSERT INTO sri_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ʉ̃mʉrikʉ Marĩpʉya wiigue mʉsã watopegue buebʉ. Iroguere mʉsã yʉre neõ ñeãbiribʉ. Mʉsã irasiriri Marĩpʉya werenírĩ gojadea pũgue gojaderosũta waaró yáa yʉre, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesúre ñeãmakʉ̃ ĩãrã, ããrĩpererã ĩgʉ̃ buerã sugʉreta ũmaweonúwãgãkõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sugʉ maamʉ ĩgʉ̃ õmasiariñe merã dita Jesúre tʉyayupʉ. Ĩgʉ̃dere ñeãkõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ĩgʉ̃sã ĩgʉ̃rẽ ñeãmakʉ̃, ĩgʉ̃ õmasiariñerẽ meépí, surí marĩgʉ̃ ũmaduriwãgãkõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pʉrʉ Jesúre paía opʉ pʉrogue ãĩjañurã. Iroguere paía oparã, Moisés gojadeare buerimasã, judío masaka mʉrã ããrĩpererã nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro gapʉ yoaweyaro Jesúre tʉyañajãa, paía opʉya wii disipʉro ñajãrõma yebague eja, Marĩpʉya wiire korerã surara merã peame tʉro sũma doaníyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Paía oparã, judío masaka mʉrã, ããrĩpererã irogue nerẽanerã Jesúre ãrĩgatori merã weresãmurãrẽ ãmarã́ iriñurã ĩgʉ̃rẽ wẽjẽmurã. Irasirikererã, bokabiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wárã gajerã ãrĩgatori merã Jesúre weresãkerepʉrʉ, keoro ejabiriyuro. ");
INSERT INTO sri_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Gajerãde wãgãnʉgãja, ãrĩgatori merã ãsũ ãrĩ weresãñurã: ");
INSERT INTO sri_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Gʉa, ĩgʉ̃ ãsũ ãrĩmakʉ̃ pébʉ: “Marĩpʉya wii masaka iridea wiire béokõãgʉra. Pʉrʉ ʉrenʉ waaró merã gaji wii, masaka iribiri wiire irigʉra”, ãrĩmi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ĩgʉ̃sã irasũ ãrĩrĩde keoro ejabiriyuro. ");
INSERT INTO sri_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Irasirigʉ paía opʉ ĩgʉ̃sã watopegue wãgãnʉgãja, Jesúre sẽrẽñayupʉ: —¿Ĩgʉ̃sãrẽ yʉjʉberi mʉ? ¿Nasirirã mʉrẽ irasũ ãrĩ weresãrĩ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús gapʉ yʉjʉbiriyupʉ. Ĩgʉ̃ yʉjʉbirimakʉ̃ ĩã, paía opʉ dupaturi sẽrẽñayupʉ doja: —¿Mʉ Marĩpʉ õãtarigʉ magʉ̃ Cristota ããrĩ́rĩ? ");
INSERT INTO sri_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Yʉ ĩgʉ̃ta ããrã. Yʉ ããrĩpererã tĩ́gʉ̃rẽ Yʉpʉ turagʉ diaye gapʉ doamakʉ̃ ĩãrãkoa. Ʉ̃mʉgasima mikãyebori weka yʉ aarimakʉ̃dere ĩãrãkoa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, paía opʉ ĩgʉ̃ guarire ĩmugʉ̃, ĩgʉ̃ya surírore tʉ̃ãyegue, ãsũ ãrĩyupʉ: —¿Nasirimurã gajerã ĩgʉ̃rẽ weresãrĩrẽ pénemobokuri marĩ? ");
INSERT INTO sri_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mʉsã, ĩgʉ̃ basita Marĩpʉre ñerõ ãrĩrĩrẽ pésiáa. ¿Naásũ gũñarĩ? ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ããrĩpererã ãsũ ãrĩñurã: —Marĩpʉre ĩgʉ̃ ñerõ ãrĩrĩ waja boaburo, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Irasirirã surãyeri Jesúre síku eotú, suríro gasiro merã ĩgʉ̃ya koyere siabiato, ĩgʉ̃rẽ pá: —“¿Noã mʉrẽ pári?” ãrĩbokaka! ãrĩñurã. Marĩpʉya wiire korerã Jesúre ãĩa, ĩgʉ̃ya diapure bʉro pánañurã. ");
INSERT INTO sri_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro gapʉ paía opʉya wii disipʉro ñajãrõma yebague doaníyupʉ. Iro ĩgʉ̃ doaripoe sugo nomeõ paía opʉre moãboego ejayupo. ");
INSERT INTO sri_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ĩgʉ̃ peame tʉro sũma doanímakʉ̃ ĩãgõ, ĩgʉ̃rẽ ãsũ ãrĩyupo: —Mʉde Jesús Nazaretmʉ merã ããrĩdita ããrã, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro ãrĩgatori merã ãsũ ãrĩ yʉjʉyupʉ igore: —Ĩgʉ̃rẽ masĩbea. Mʉ irasũ ãrĩrĩrẽ pémasĩbirikoa yʉ, ãrĩyupʉ. Irasũ ãrĩ, iri wii tʉroma sãrĩrõ disipʉrogue wiriaripoeta ãgãbo wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Moãboego Pedrore dupaturi ĩã, iro ããrĩrã́rẽ ãrĩyupo doja: —Ĩĩ, Jesús merãmʉta ããrĩ́mi, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro dupaturi igore ãrĩgatoyupʉ doja: —Ããrĩbea yʉ, ãrĩyupʉ. Mérõgã pʉrʉta iro ããrĩrã́ Pedrore ãrĩñurã doja: —Mʉ diayeta Jesús buerã merãmʉta ããrã. Mʉ Galileamʉta ããrã. Pémasĩrõta ĩgʉ̃sã irirosũ werenía, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Pedro ãrĩyupʉ: —Marĩpʉ péuro diayeta werea. Yʉ mʉsãrẽ diaye werebirimakʉ̃, Marĩpʉ yʉre wajamoãburo. Yʉ mʉsã werenígʉ̃rẽ masĩbea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ĩgʉ̃ irasũ ãrĩripoeta dupaturi ãgãbo wereyupʉ. Pedro, ãgãbo weremakʉ̃ pégʉ, Jesús ĩgʉ̃rẽ: “Ãgãbo pea wereburo dupuyuro mʉ yʉre masĩkeregʉ, ʉrea: ‘Masĩbea’, ãrĩgatogʉkoa”, ãrãdeare gũñaboka, bʉro oreyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Boyodujimejãripoe ããrĩpererã judío masaka oparã, paía oparã, mʉrã, Moisés gojadeare buerimasã nerẽ: “¿Nasirirãkuri marĩ Jesúre?” ãrĩ wereníñurã. Werení odo, ĩgʉ̃rẽ sia, ãĩwãgã, Pilatore wiañurã. ");
INSERT INTO sri_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Jesúre sẽrẽñayupʉ: —¿Mʉta ããrĩ́rĩ judío masaka Opʉ? ãrĩyupʉ. —Mʉ ãrĩrõsũta ĩgʉ̃ta ããrã, ãrĩ yʉjʉyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Paía oparã Jesúre: “Ĩĩ ñerõ iridi ããrĩ́mi”, ãrĩ, wári weresãñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pilato dupaturi Jesúre ãsũ ãrĩ sẽrẽñayupʉ: —¿Neõ yʉjʉberi? Péka! Ĩgʉ̃sã mʉrẽ wári weresãrã yáma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús gapʉ neõ yʉjʉbiriyupʉ. Irasirigʉ Pilato ĩãgʉkakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bojorikʉ pascua bosenʉ ããrĩmakʉ̃, Pilato sugʉ peresugue ããrĩgʉ̃́rẽ masaka wiudoregʉre wiunayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iripoere Barrabás wãĩkʉgʉ gajerã romano marã oparãrẽ béodʉarã masakare wẽjẽnerã merã peresugue ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iri bosenʉ ããrĩmakʉ̃, Pilato pʉrogue wárã masaka nerẽ: —Mʉ bojorikʉ irinarõsũta irika doja! ãrĩ sẽrẽñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato ĩgʉ̃sãrẽ yʉjʉyupʉ: —¿Mʉsã judío masaka Opʉre yʉ wiumakʉ̃ gããmerĩ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato, paía oparã Jesúre ĩãturisĩã, ĩgʉ̃sã ĩgʉ̃rẽ wiamakʉ̃ masĩgʉ̃, irasũ ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Paía oparã gapʉ masakare: “Barrabáre wiuka!” ãrĩ gainídoreñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pé, Pilato ĩgʉ̃sãrẽ sẽrẽñayupʉ: —Mʉsã judío masaka Opʉ, ãrĩgʉ̃ merã gapʉre, ¿nasirimakʉ̃ gããmekuri? ");
INSERT INTO sri_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ĩgʉ̃ irasũ ãrĩmakʉ̃, bʉro gainírĩ merã: —Curusague pábiatú wẽjẽka ĩgʉ̃rẽ! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato ĩgʉ̃sãrẽ ãrĩyupʉ: —¿Ñeéno ñerĩrẽ iriari ĩgʉ̃, mʉsã irasũ ãrĩmakʉ̃? Ĩgʉ̃sã gapʉ dupaturi: —Curusague pábiatú wẽjẽka ĩgʉ̃rẽ! ãrĩ gainíñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Irasirigʉ Pilato ĩgʉ̃sã ĩgʉ̃ merã õãrõ dujamakʉ̃ iridʉagʉ, ĩgʉ̃sã gããmerõsũta Barrabáre wiuyupʉ. Jesús gapʉre tãrãdore, pʉrʉ surarare wiayupʉ, ĩgʉ̃rẽ curusague pábiatúdoregʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Irasirirã surara Jesúre Pilatoya wii disipʉroma yebague ãĩjañurã. Irogue ããrĩpererã surarare Jesús pʉro neeõñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pʉrʉ suríro bʉro diiariñerẽ ĩgʉ̃rẽ sãñurã. Ĩgʉ̃ya dipurure pora bero ĩgʉ̃sã iriadea berore peoñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pʉrʉ: “Bʉremurã aarika judío masaka Opʉre!” ãrĩ gainíñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ĩgʉ̃ya dipurure yukʉ dʉka merã pá, ĩgʉ̃rẽ síku eotúbiranañurã. Ĩgʉ̃rẽ bʉridarã ñadʉkʉpuri merã ejamejãjanañurã. ");
INSERT INTO sri_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pʉrʉ irasiri bʉrida odo, suríro diiariñerẽ túwea, ĩgʉ̃ya surírore sãñurã doja. Irasiri odo, ĩgʉ̃rẽ curusague pábiatú wẽjẽmurã ãĩãkõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ĩgʉ̃rẽ ãĩãrã, sugʉ Cirenemʉ Simón wãĩkʉgʉre pooegue ããrãdi dujarigʉre bokatĩrĩñurã. Ĩgʉ̃ Alejandro, Rufo wãĩkʉrã pagʉ ããrĩyupʉ. Ĩgʉ̃rẽ bokatĩrĩ, Jesús kõãdea curusare kõãdoreñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gólgota wãĩkʉrogue Jesúre ãĩjañurã. “Gólgota”, ãrĩrõ: “Masakʉ dipuru boaweadea pero”, ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Irogue eja, Jesúre igui deko mirra wãĩkʉri merã morẽadeare tĩãdiñurã. Jesús gapʉ iiríbiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Pʉrʉ irogue ñamigãgã nueve hora ããrĩmakʉ̃ Jesúre curusague pábiatú ãĩwãgãnúkõãñurã pama. Odo, ĩgʉ̃ya suríre: “¿Noãrẽ dujarokuri?” ãrĩboka birañurã, irire ĩgʉ̃sã basi gãme dʉkawamurã. ");
INSERT INTO sri_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","“Ĩĩ ãsũ iridea waja boami”, ãrĩrã: “Ĩĩta judío masaka Opʉ ããrĩ́mi”, ãrĩ gojadea majĩrẽ curusague ĩgʉ̃ weka pábiatúñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesús merã pẽrã yajarikʉrãrẽ gaji curusarigue pábiatú ãĩwãgũnúñurã. Sugʉre ĩgʉ̃ diaye gapʉ, gajigʉre kúgapʉ pábiatú ãĩwãgũnúñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jesúre ĩgʉ̃sã irasirimakʉ̃, Marĩpʉya werenírĩ gojadea pũgue gojaderosũta waayuro: “Ĩgʉ̃ ñerĩ irigʉ irirosũ ñerã merã wẽjẽsũgʉkumi”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Masaka irogue ããrĩrã́ Jesús pʉro ejanʉgãja, bʉridari merã ĩgʉ̃rẽ ĩgʉ̃sãya dipure sagui, ñerõ wereníñurã. —Jʉ̃ʉ̃́, mʉ Marĩpʉya wiire béo, pʉrʉ ʉrenʉ waaró merãta iri wiire dupaturi iri odogʉkoa, ãrĩ wereníbʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Irasirigʉ mʉ basi tauka! Curusague merã dijarika! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Paía oparã, Moisés gojadeare buerimasãde ĩgʉ̃rẽ ãsũ ãrĩ bʉridañurã: —Gajerã gapʉre taumi. Ĩgʉ̃ basi gapʉ taumasĩbemi. ");
INSERT INTO sri_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Diayeta Cristo, Israel bumarã Opʉ ããrĩgʉ̃́, curusague merã ĩgʉ̃ dijarimakʉ̃ ĩãrã, marĩ ĩgʉ̃rẽ bʉremurãkoa, ãrĩ bʉridañurã. Ĩgʉ̃ merã pábiatú ãĩwãgũnúsũanerãde irasũta ãrĩ bʉridañurã. ");
INSERT INTO sri_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Goeripoe ããrĩmakʉ̃, i nikũ ããrĩpererogue naĩtĩãkõãyuro. Ʉre hora gora naĩtĩãyuro. ");
INSERT INTO sri_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ʉre hora ejamakʉ̃ta Jesús bʉro gainíyupʉ: —Eloi, Eloi, ¿lama sabactani? ãrĩyupʉ. Irasũ ãrĩgʉ̃: “Yʉ Opʉ, yʉ Opʉ ¿nasirigʉ yʉre béori mʉ?” ãrĩgʉ̃ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Surãyeri iro ããrĩrã́, ĩgʉ̃ irasũ ãrĩ gainímakʉ̃ pérã: —Péka! Marĩpʉya kerere weredupuyudire Elíare siiugʉ yámi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sugʉ ĩgʉ̃sã merãmʉ ũmawãgã, igui deko piari yosadea yʉsʉre yukʉ yuwague siatú, Jesúre iiríburo, ãrĩgʉ̃ soemuúyupʉ. Irasũ soemuúgʉ̃, ãsũ ãrĩyupʉ: —Ĩãñarã marĩ, ĩgʉ̃ curusague ããrĩgʉ̃́rẽ Elías ãĩdijugʉ aarimakʉ̃, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús bʉro gainí, kõmoakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ĩgʉ̃ kõmomakʉ̃ta Marĩpʉya wii poekama taribu disipʉro kãmutari gasiro ʉ̃marõ gapʉ merã yegue dijari, deko merã yeguesiajayuro. ");
INSERT INTO sri_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesús boamakʉ̃ ĩãgʉ̃, romano surara opʉ: —Ĩĩ diayeta Marĩpʉ magʉ̃ ããrãdañumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nomede yoaweyarogue Jesúre ĩũníñurã. Ĩgʉ̃sã nome watopeguere María Magdalena ããrĩyupo. Gajego María Santiago, ĩgʉ̃ tĩ́gʉ̃ José pago ããrĩyupo. Gajego Salomé ããrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galileague ããrĩmakʉ̃, ĩgʉ̃rẽ iritamunerã nome ããrĩñurã. Gajerã nome wárã ããrĩñurã, Jerusalẽ́gue ĩgʉ̃ merã waanerã nome. ");
INSERT INTO sri_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Naĩmejãripoe ããrĩmakʉ̃, judío masaka siuñajãrĩnʉ ñajãburo dupuyuro José, Arimatea wãĩkʉri makãmʉ Pilato pʉrogue ejayupʉ. Judío masaka oparã watopemʉ ããrĩyupʉ. Ĩgʉ̃ Marĩpʉ ĩgʉ̃yarãrẽ doreburire yúgʉ iriyupʉ. Irasirigʉ güiro marĩrõ Pilato pʉro eja, Jesúya dupʉre yáabu sẽrẽyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ĩgʉ̃ irasũ ãrĩ sẽrẽmakʉ̃, Pilato pégʉkakõãyupʉ. Irasirigʉ surara opʉre siiu: —¿Jesús ããrĩrṍta boakõãrĩ? ãrĩ sẽrẽñayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Surara opʉ ĩgʉ̃rẽ: “Boakõãmi”, ãrĩ yʉjʉmakʉ̃ pégʉ, Pilato Josére Jesúya dupʉre ãĩdijudoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Irasirigʉ José õãrĩ suríro gasiro wajari, Jesúya dupʉre ãĩdiju, iri gasiro merã õmayupʉ. Pʉrʉ su gobe masãgobe ʉ̃tãyegue mádea gobegue píyupʉ. Irasiri odo, iri gobere ʉ̃tã majĩ merã biayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ĩgʉ̃ Jesúya dupʉre yáamakʉ̃, María Magdalena, gajego María José pago ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judío masaka siuñajãrĩnʉ tariadero pʉrʉ, María Magdalena, gajego María, Santiago pago, gajego Salomé, sʉ̃rõrĩ wajariñurã Jesúya dupʉre piupeomurã. ");
INSERT INTO sri_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Semana ããrĩpʉroririnʉrẽ ĩgʉ̃sã nome ñamigãgã, abe mʉrĩriripoe Jesúya dupʉre yáadea masãgobegue waañurã. ");
INSERT INTO sri_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Irogue waarã́: —¿Noã marĩrẽ iri masãgobe biadea ʉ̃tã majĩrẽ tũpãbosarãkuri? ãrĩ wereníwãgãñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Irogue ejarã, iri gobere biadea ʉ̃tã majĩ miẽrẽ gajerogue oyamakʉ̃ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Irasirirã iri gobegue ñajãa, sugʉ maamʉ diayemapãrẽ gapʉ suríro yoaro õãrõ borero sãñadi doamakʉ̃ ĩãñurã. Ĩgʉ̃rẽ ĩãrã, ĩãgʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ĩgʉ̃ gapʉ ĩgʉ̃sãno merẽ ãrĩyupʉ: —Gʉkabirikõãka! Mʉsã Jesús Nazaretmʉrẽ, ĩgʉ̃sã curusague pábiatú wẽjẽadire ãmarã́ yáa. Masãsiami. Õõrẽ mámi. Ĩãka, ĩgʉ̃sã ĩgʉ̃rẽ píaderore! ");
INSERT INTO sri_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ĩgʉ̃ buerãrẽ, irasũ ããrĩmakʉ̃ Pedrore wererã waaka! Ĩgʉ̃ mʉsã dupuyuro Galileague waasiami. Irogue mʉsã ĩgʉ̃rẽ ĩãrãkoa ĩgʉ̃ ãrĩderosũta, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, bʉro gʉka naradari merã waakõãñurã. Bʉro güisĩã, gajerãrẽ ĩgʉ̃sã ĩãdeare werebiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús semana ããrĩpʉroririnʉ boyoripoe, ĩgʉ̃ masãdero pʉrʉ María Magdalenarẽ deyoapʉroriyupʉ. Igo su mojõma pere gaji mojõ peru pẽrẽbejarã wãtẽãrẽ ĩgʉ̃ béowiusũdeo ããrĩyupo. ");
INSERT INTO sri_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesús igore deyoadero pʉrʉ, ĩgʉ̃ buerãrẽ igo ĩãdeare werego waayupo. Ĩgʉ̃sã bʉro bʉjawereri merã orerã iriñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Igo ĩgʉ̃sãrẽ: “Jesús okami, ĩgʉ̃rẽ ĩãbʉ”, ãrĩ wererire pérã, bʉremubiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pʉrʉ Jesús gajerã pẽrãrẽ makã tʉrogue waarã́rẽ deyoayupʉ. Ĩgʉ̃ deyoapʉrorigʉ, deyoderosũ deyobiriyupʉ. Irasirirã ĩgʉ̃rẽ ĩãmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ĩgʉ̃rẽ ĩãmasĩ, pʉrʉ ĩgʉ̃ buerã ããrĩrṍgue waa, Jesús ĩgʉ̃sãrẽ deyoadeare wereñurã. Ĩgʉ̃sãdere bʉremudʉabiriñurã. ");
INSERT INTO sri_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jesús ĩgʉ̃ boa, masãdero pʉrʉ, ĩgʉ̃ buerã pe mojõma pere su gubu suru pẽrẽbejarãrẽ ĩgʉ̃sã baa doanírõgue deyoa, ãrĩyupʉ: —¿Nasirirã, yʉ masãdea kerere pékererã, bʉremuberi, ĩgʉ̃sã mʉsãrẽ werekerepʉrʉ? Bʉremurĩ opabea mʉsã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pʉrʉ ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ doja: —Ããrĩpererogue marãrẽ Marĩpʉ masakare tauri kerere wererã waaka! ");
INSERT INTO sri_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yʉre bʉremurã, deko merã wãĩyesũrã tausũrãkuma. Yʉre bʉremumerã gapʉ peamegue béosũrãkuma. ");
INSERT INTO sri_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yʉre bʉremurã yʉ wãĩ merã, yʉ turaro merã wãtẽãrẽ masakaguere ñajãnerãrẽ béowiurãkuma. Gaji masã ya ĩgʉ̃sã dupuyuro werenímasĩbirideare werenírãkuma. ");
INSERT INTO sri_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ãñarẽ ñeãmakʉ̃, ĩgʉ̃sãrẽ ñerõ waabirikoa. Nima iirímakʉ̃dere pũrĩbirikoa. Pũrĩrikʉrãrẽ ĩgʉ̃sãya mojõrĩ merã ñapeomakʉ̃, ĩgʉ̃sãrẽ pũrĩrĩ tarirokoa, ãrĩyupʉ Jesús ĩgʉ̃ buerãrẽ. ");
INSERT INTO sri_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Marĩ Opʉ Jesús irasũ ãrĩ were odoadero pʉrʉ, Marĩpʉ ĩgʉ̃rẽ ʉ̃mʉgasigue ãĩmʉrĩayupʉ. Irasirigʉ irogue ejagʉ, Marĩpʉ diaye gapʉ eja doayupʉ. ");
INSERT INTO sri_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ĩgʉ̃ buerã ĩgʉ̃ masakare tauri kerere ããrĩpererogue wererã waañurã. Ĩgʉ̃sã irasũ weregorenamakʉ̃, marĩ Opʉ Jesús ĩgʉ̃sãrẽ iritamuníkõãyupʉ. Irasirigʉ ĩgʉ̃ turari merã ĩgʉ̃sãrẽ iri ĩmurĩrẽ irimakʉ̃ irinayupʉ, masakare ĩgʉ̃sã wererire: “Diayeta ããrã”, ãrĩ bʉremudoregʉ. Iropãta ããrã.");
INSERT INTO sri_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Opʉ Teófilo, yʉ mʉrẽ õãdorea. Gʉa watopere Jesús irinʉgãdeare ĩãnerã gʉare ĩgʉ̃ya kerere buema. Wárã gajirã, ĩgʉ̃sã gʉare buederosũta keoro gojanʉgãsianerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Yʉde ããrĩpereri Jesús irinʉgãdeare masĩpeodʉagʉ, õãrõ buebʉ. Irasirigʉ mʉrẽ gajirã buedeare: “Diayeta ããrã”, ãrĩ masĩburo, ãrĩgʉ̃, irire keoro gojáa. ");
INSERT INTO sri_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes, Judea nikũ marã opʉ ããrĩripoe sugʉ paí Zacarías wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃, paí Abías wãĩkʉgʉya bumʉ ããrĩyupʉ. Ĩgʉ̃ marãpo Isabel wãĩkʉgo, paí Aarón wãĩkʉgʉ parãmeõ ããrĩturiagogue ããrĩyupo. ");
INSERT INTO sri_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ĩgʉ̃sã pẽrãgueta Marĩpʉ ĩũrõrẽ diayemarẽ irirã, Moisére doreri pídeadere tarinʉgãbiriñurã. Irasirirã gajirã ĩgʉ̃sãrẽ: “Ñerĩ irirã ããrĩ́ma”, ãrĩmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Isabel pũrã marĩgõno ããrĩyupo. Irasirirã pũrã marĩrãta, muñuakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sunʉ Zacaríaya bumarãrẽ Marĩpʉya wiigue Marĩpʉ ĩũrõ moãrĩ ããrĩyuro. Irasirirã, ĩgʉ̃ paíare iridorederosũta irirã irogue waañurã. ");
INSERT INTO sri_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Irogue ejadero pʉrʉ, ĩgʉ̃sã paía irinarõsũ Zacaríare sʉ̃rõrĩ soemubure beyebokañurã. Irasirigʉ Zacarías Marĩpʉya wiima taribugue soemugʉ̃ ñajãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ĩgʉ̃ irire soemuripoe iri taribu wirinʉgãrõgue wárã masaka Marĩpʉre sẽrẽrã iriñurã. ");
INSERT INTO sri_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ĩgʉ̃ soemuripoe sugʉ Marĩpʉre wereboegʉ sʉ̃rõrĩ soemurõ diaye gapʉ Zacaríare deyoayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías ĩgʉ̃rẽ ĩãgʉ̃, ĩãgʉka, nasirimasĩbiriyupʉ. Bʉro güiyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ĩgʉ̃ güimakʉ̃ ĩãgʉ̃, Marĩpʉre wereboegʉ gapʉ ãsũ ãrĩyupʉ: —Zacarías, güibirikõãka! Marĩpʉ mʉ sẽrẽrĩrẽ pémi. Mʉ marãpo Isabel sugʉ majĩgʉ̃ pũrãkʉgokumo. Ĩgʉ̃rẽ “Juan” wãĩyeka! ");
INSERT INTO sri_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ĩgʉ̃ merã bʉro ʉsʉyagʉkoa. Wárã gajirã ĩgʉ̃ deyoamakʉ̃, ʉsʉyarãkuma. ");
INSERT INTO sri_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ĩgʉ̃ Marĩpʉ ĩũrõrẽ ubu ããrĩgʉ̃́ meta ããrĩgʉkumi. Igui deko pãmurĩrẽ, siburidere neõ iiríbirikumi. Ĩgʉ̃ deyoaburi dupiyurogueta Õãgʉ̃ deyomarĩgʉ̃rẽ opatarisiagʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wárã Israel bumarãrẽ Marĩpʉre gũñaduúnerãrẽ dupaturi gũñamakʉ̃ irigʉkumi doja. ");
INSERT INTO sri_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Marĩ Opʉ aariburi dupiyuro Elías Marĩpʉya kerere weredupiyudi werederosũta Õãgʉ̃ deyomarĩgʉ̃ turari merã masakare weregʉkumi. Pagʉsãmarã ĩgʉ̃sã pũrã merã õãrõ ããrĩburo, ãrĩgʉ̃; tarinʉgãrĩmasãdere oparã dorerire õãrõ yʉjʉburo, ãrĩgʉ̃, Marĩpʉyare weregʉkumi. Irasirigʉ masaka marĩ Opʉre õãrõ ʉsʉyari merã bokatĩrĩñeãburo, ãrĩgʉ̃, irire weregʉkumi, ãrĩyupʉ Marĩpʉre wereboegʉ Zacaríare. ");
INSERT INTO sri_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Zacarías sẽrẽñayupʉ: —¿Nasirigʉ yʉ ire: “Diayeta ããrã”, ãrĩmasĩbukuri? Yʉ bʉgʉrogora ããrã. Yʉ marãpode bʉ́ro ããrĩ́mo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ãsũ ãrĩ yʉjʉyupʉ: —Yʉ Marĩpʉre wereboegʉ, Gabriel wãĩkʉgʉ, Marĩpʉ pʉro ããrĩgʉ̃́ ããrã. Ĩgʉ̃ta yʉre iriuami, mʉrẽ i õãrĩ kerere weredoregʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Dapagorare yʉ wererire mʉ bʉremubiri waja, wereníbi dujagʉkoa. Mʉ magʉ̃ deyoadero pʉrʉ, werenígʉkoa doja. Marĩpʉ: “Irasũ waaburo”, ãrĩmakʉ̃, yʉ mʉrẽ ãrãderosũta waarokoa, ãrĩyupʉ Gabriel Zacaríare. ");
INSERT INTO sri_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ĩgʉ̃ irasũ ãrĩ wereripoere masaka, iri taribu wirinʉgãrõgue ããrĩrã́ Zacaríare yúrã iriñurã. “¿Naásũ waayuri, ĩgʉ̃ iropa yoaripoe deyomarĩgʉ̃?” ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías iri taribugue ããrãdi wirijagʉ, ĩgʉ̃sãrẽ weredʉagʉ, neõ werenímasĩbiriyupʉ. Irasirigʉ ĩgʉ̃ya mojõrĩ merã irikeoyupʉ. Masaka, ĩgʉ̃ irasirimakʉ̃ ĩãrã: “Iri taribugue Marĩpʉ ĩmuadeare ĩãgʉkakõãkumi”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zacarías Marĩpʉya wiigue Marĩpʉ ĩũrõ moãrĩrẽ iripeo, ĩgʉ̃ya wiigue goedujáakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pʉrʉ ĩgʉ̃ marãpo Isabel nijĩpo ããrĩnʉgãyupo. Su mojõmarã abe neõ wiriro marĩrõ igoya wiigue ããrĩkõãyupo. ");
INSERT INTO sri_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ãsũ ãrĩ gũñayupo: “Marĩpʉ, yʉ pũrã marĩgõ ããrĩdeore iritamugʉ̃ irasũ yámi, masaka yʉre ĩãbéobirikõãburo, ãrĩgʉ̃”. ");
INSERT INTO sri_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel nijĩpo ããrĩnʉgãdero pʉrʉ, su mojõma pere gaji mojõ suru pẽrẽbejari abe waaró merã Marĩpʉ ĩgʉ̃rẽ wereboegʉ Gabriere Galilea nikũma makã Nazaret wãĩkʉri makãgue, ");
INSERT INTO sri_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","sugo nomeõ María wãĩkʉgo, neõ sugʉ ʉ̃mʉ́ʉ merã ããrĩbeo pʉrogue iriuyupʉ. Igo, José wãĩkʉgʉ opʉ David parãmi ããrĩturiagʉ merã marãpʉkʉbo iriyupo. ");
INSERT INTO sri_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel, igo ããrĩrṍgue ñajãa, igore: —Mʉrẽ õãdorea. Marĩpʉ mʉrẽ õãrõ irigʉ ããrĩ́mi. Ĩgʉ̃ marĩ Opʉ mʉ merã ããrĩ́mi. Ããrĩpererã nome nemorõ mʉrẽ õãrõ iritarinʉgãgʉkumi, ãrĩ õãdoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María, ĩgʉ̃rẽ ĩãgõ, ĩgʉ̃ irasũ ãrĩrĩrẽ pégo, pégʉkakõãyupo. “¿Naásũ ãrĩdʉaro irikuri ĩgʉ̃ yʉre õãdoreri?” ãrĩ, bʉro gũñayupo. ");
INSERT INTO sri_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Igo gʉkamakʉ̃ ĩãgʉ̃, Marĩpʉre wereboegʉ ãrĩyupʉ: —María, güibirikõãka! Marĩpʉ ĩũrõrẽ mʉ õãrĩ bokabʉ. Mʉ merã ʉsʉyami. ");
INSERT INTO sri_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Irasirigo mʉ dapagorare nijĩpo ããrĩnʉgãgokoa. Sugʉ majĩgʉ̃ pũrãkʉgokoa. Ĩgʉ̃rẽ “Jesús” wãĩyegokoa. ");
INSERT INTO sri_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Ĩgʉ̃ ubu ããrĩgʉ̃́ meta ããrĩgʉkumi. Marĩpʉ ããrĩpererã nemorõ turagʉ, ĩgʉ̃rẽ: “Yʉ magʉ̃ ããrã mʉ”, ãrĩgʉkumi. David, mʉ magʉ̃ ñekʉ̃, Israel bumarã opʉ ããrĩdi ããrĩmí. Marĩpʉ Davire opʉ píderosũta mʉ magʉ̃dere Opʉ pígʉkumi Israel bumarãrẽ doreníbure. Ĩgʉ̃ doreri neõ perebirikoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, María ĩgʉ̃rẽ sẽrẽñayupo: —¿Nasiriro yʉre irasũ waabukuri, yʉ neõ sugʉ ʉ̃mʉ́ʉ merã ããrĩbirikeremakʉ̃? ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Igo irasũ ãrĩmakʉ̃ pégʉ, ãsũ ãrĩyupʉ: —Õãgʉ̃ deyomarĩgʉ̃ mʉguere dijarigʉkumi. Marĩpʉ ããrĩpererã Opʉ turari, su ĩĩmikãyebo túbiaro irirosũ ejarokoa mʉrẽ. Irasirigʉ mʉ magʉ̃ deyoabu, Marĩpʉyagʉ õãgʉ̃ ããrĩgʉkumi. Masaka ĩgʉ̃rẽ: “Marĩpʉ magʉ̃ ããrĩ́mi”, ãrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mʉ basudeo Isabede, bʉ́ro ããrĩkerego, sugʉ majĩgʉ̃ pũrãkʉgokumo. Masaka igore: “Pũrã marĩgõ ããrĩ́mo”, ãrĩkeremakʉ̃, su mojõma pere gaji mojõ suru pẽrẽbejari abegora opasiamo. ");
INSERT INTO sri_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Marĩpʉre ĩgʉ̃ iridʉari, neõ diasabea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, María ãrĩyupo: —Yʉ marĩ Opʉre moãboego ããrã. Marĩpʉ, mʉ ãrĩrõsũta iriburo yʉre, ãrĩyupo. Igo irasũ ãrãdero pʉrʉ, Marĩpʉre wereboegʉ waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Irinʉrĩta María mumurõ merã Judea nikũ ʉ̃tãyuku watopegue ããrĩrĩ́ makãgue waayupo. ");
INSERT INTO sri_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Irogue eja, Zacaríaya wiigue ñajãa, Isabere õãdoreyupo. ");
INSERT INTO sri_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Igo õãdorerire pémakʉ̃, Isabel magʉ̃ igoya patoregue ããrĩgʉ̃́ bʉro gãmeñayupʉ. Igo, Õãgʉ̃ deyomarĩgʉ̃rẽ opatariyupo. ");
INSERT INTO sri_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Irasirigo turaro merã ãsũ ãrĩyupo: —Marĩpʉ ããrĩpererã nome nemorõ mʉrẽ õãrõ iritarinʉgãmi. Mʉ magʉ̃dere õãrõ yámi. ");
INSERT INTO sri_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mʉ, yʉ Opʉ pago yʉre ĩãgõ ejamakʉ̃ õãtaria. ");
INSERT INTO sri_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mʉ õãdorerire yʉ pémakʉ̃ta, yʉ magʉ̃ yaa patoregue ããrĩgʉ̃́ bʉro ʉsʉyari merã gãmeñami. ");
INSERT INTO sri_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Marĩpʉre wereboegʉ mʉrẽ wereadeare: “Keoro waarokoa”, ãrĩ bʉremusĩã, õãrõ ʉsʉyari merã ããrã, ãrĩyupo Isabel Maríare. ");
INSERT INTO sri_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Irasirigo María ãsũ ãrĩyupo: Yaa yʉjʉpũrãgue yʉ Opʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩa. ");
INSERT INTO sri_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Marĩpʉ yʉre taugʉ merã bʉro ʉsʉyáa. ");
INSERT INTO sri_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yʉ ubu ããrĩgṍ ããrĩkeremakʉ̃, Marĩpʉ yʉre ĩgʉ̃rẽ moãboegore gũñami. Irasirirã dapagora merã masaka yʉre: “Marĩpʉ igore õãrõ iridea merã bʉro ʉsʉyadeo ããrĩmó”, ãrĩníkõãrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Marĩpʉ turatarigʉ yʉre wári õãrĩrẽ yámi. Ĩgʉ̃ õãtarigʉ, neõ ñerĩ opabi ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ããrĩpererã goepeyari merã ĩgʉ̃rẽ bʉremurãrẽ bopoñaníkõãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ĩgʉ̃ turari merã wári õãrĩrẽ iri ĩmumi. “Gʉa gajirã nemorõ ããrã”, ãrĩ gũñarãnorẽ ubu ããrĩrã́ dujamakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Oparãrẽ ubu ããrĩrã́ dujamakʉ̃ yámi. Ubu ããrĩrã́: “Gajirã nemorõ ããrĩbea”, ãrĩ gũñarã gapʉre oparã dujamakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ʉaboarimasãrẽ wári õãrĩ sĩmi. Wári oparã gapʉre neõ gajino opamerã dujamakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Marĩ ñekʉ̃sãmarãrẽ: “Iritamugʉra”, ãrĩderosũta Abrahãrẽ, ĩgʉ̃ parãmerã ããrĩturiarãdere iritamuníkõãmi. Irasirigʉ marĩ Israel bumarãrẽ, ĩgʉ̃rẽ moãboerãrẽ ĩgʉ̃ ãrĩdeare neõ kãtiro marĩrõ bopoñarĩ merã iritamuníkõãmi, ãrĩyupo María. ");
INSERT INTO sri_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María, Isabel merã ʉrerã abegora ããrĩyupo. Pʉrʉ igoya wiigue goedujáakõãyupo. ");
INSERT INTO sri_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pʉrʉ Isabel majĩgʉ̃ deyoarinopoe nijĩwãgũdero pʉrʉ, igo magʉ̃ deyoayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Irasirirã igo pʉro ããrĩrã́, igoyarã, Marĩpʉ igore õãrõ iridea kerere pérã, igore ʉsʉyatamurã waañurã. ");
INSERT INTO sri_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Igo magʉ̃ deyoadero pʉrʉ, su mojõma pere gaji mojõ ʉreru pẽrẽbejarinʉrĩ waaró merã majĩgʉ̃rẽ ĩgʉ̃ya dʉpʉma gasirogãrẽ wiirirã waañurã. Ĩgʉ̃rẽ ĩgʉ̃ pagʉ “Zacarías” wãĩrẽ wãĩyedʉadiñurã. ");
INSERT INTO sri_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Isabel gapʉ ĩgʉ̃sãrẽ: —Ããrĩbea. Ĩgʉ̃: “Juan” wãĩkʉgʉkumi, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Igo irasũ ãrĩmakʉ̃ pérã, igore: —¿Nasirigʉ irasũ wãĩkʉbukuri? Neõ mʉyarã irasũ wãĩkʉrã máma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Irasirirã Zacaríare: “¿Mʉ naásũ wãĩyedʉakuri?” ãrĩrã, mojõrĩ merã irikeo, sẽrẽñañurã. ");
INSERT INTO sri_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Irasirigʉ Zacarías su taboa majĩ sẽrẽ, iri majĩgue: —“Juan wãĩkʉgʉkumi”, ãrĩ gojayupʉ. Ĩgʉ̃ gojarire ĩãrã, gʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Irire gojagʉta Zacarías wereníbi ããrãdi wereníakõãyupʉ doja. Irasirigʉ Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ããrĩpererã Zacarías pʉro ããrĩrã́, ĩgʉ̃ werenímakʉ̃ pérã, gʉkakõãñurã. Ããrĩpererogue Judea nikũ marã ʉ̃tãyuku watopegue ããrĩrã́rẽ Juan deyoadeare wereñurã. ");
INSERT INTO sri_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ĩgʉ̃ deyoadea kerere pérã, ããrĩpererã gũña, ãsũ ãrĩ gãme sẽrẽñañurã: —Ĩĩ majĩgʉ̃ bʉgʉro waagʉ́, ¿naásũ ããrĩrikʉgʉkuri Marĩpʉ turari merã deyoadi? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, Õãgʉ̃ deyomarĩgʉ̃rẽ opatarigʉ Marĩpʉ ĩgʉ̃rẽ weredorerire ãsũ ãrĩ wereyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Marĩpʉre Israel bumarã Opʉre ʉsʉyari sĩrã! Marĩ ĩgʉ̃yarã pʉrogue marĩrẽ taugʉ aarími. ");
INSERT INTO sri_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Irasirigʉ marĩrẽ taubure turatarigʉre iriugʉkumi. Ĩgʉ̃, David Marĩpʉre moãboerimasʉ̃ ããrĩdi parãmi ããrĩturiagʉgue ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Iripoegue Marĩpʉ, ĩgʉ̃ya kerere weredupiyurimasã ñerĩ marĩrã merã marĩrẽ tauburire ãsũ ãrĩ weredi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Ããrĩpererã mʉsãrẽ ĩãturirãrẽ, wajarãkʉrãrẽ, mʉsãrẽ tariweremakʉ̃ irigʉra”, ãrĩ weredi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Irasirigʉ marĩ ñekʉ̃sãmarãrẽ: “‘Mʉsãrẽ bopoñarĩ merã ĩãgʉ̃, õãrõ irigʉra’, ãrĩdeare neõ kãtibirikoa”, ãrĩ weredi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Irire Marĩpʉ marĩ ñekʉ̃ Abrahãrẽ weredi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Irasirigʉ marĩrẽ ĩãturirãrẽ wijatagʉkumi, güiri marĩrõ ĩgʉ̃ dorerire iritʉyaburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ããrĩperero marĩ okaro bokatĩũrõ marĩrẽ ĩgʉ̃yarã, diayemarẽ irirã ããrĩmakʉ̃ irigʉkumi, ãrĩyupʉ Zacarías. Irasũ ãrĩ odo, ĩgʉ̃ magʉ̃gãrẽ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Makʉ, masaka mʉrẽ: “Marĩpʉ ããrĩpererã nemorõ turagʉya kerere weredupiyurimasʉ̃ ããrĩ́mi”, ãrĩrãkuma. Mʉ, marĩ Opʉ aariburi dupiyuro ĩgʉ̃ aariburi maarẽ́ diayema maa ãmugʉ̃́ irirosũ ĩgʉ̃yare weregʉ waagʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Marĩpʉyarãrẽ ãsũ ãrĩ weregʉkoa: “Marĩpʉre: ‘Gʉa ñerõ irideare kãtika!’ ãrĩ sẽrẽmakʉ̃, mʉsãrẽ kãtigʉkumi. Irasirigʉ mʉsãrẽ perebiri peamegue waabonerãrẽ taugʉkumi”, ãrĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Marĩpʉ marĩrẽ bopoñarĩ merã maĩsĩã, ʉ̃mʉ, maamanʉ boyoro irirosũ waamakʉ̃ irigʉkumi, ʉ̃mʉgasigue merã marĩrẽ taubure iriugʉ. ");
INSERT INTO sri_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Naĩtĩãrõgue ããrĩrã́rẽ boyori sĩgʉkumi perebiri peamegue waabonerãrẽ ĩgʉ̃rẽ masĩburo, ãrĩgʉ̃. Irasirigʉ marĩrẽ ĩgʉ̃ merã õãrõ siñajãrĩ bokamakʉ̃ irigʉkumi, ãrĩ wereyupʉ Zacarías. ");
INSERT INTO sri_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Majĩgʉ̃ õãrĩ gũñarĩ merã, Marĩpʉ turari merã masãyupʉ. Masaka marĩrõgue yoaripoe ããrĩyupʉ. Irogue ããrĩgʉ̃́ta Israel bumarãrẽ buenʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Marĩpʉ magʉ̃ deyoaburi dupiyuro romano marã opʉ Augusto wãĩkʉgʉ ĩgʉ̃ya nikũ marãrẽ ããrĩpererãrẽ keoñabu, ĩgʉ̃sã wãĩrẽ gojatúdoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","3","Irasirirã ããrĩpererã masaka ĩgʉ̃sã ñekʉ̃sãmarã deyoadea makãrĩgue ĩgʉ̃sã wãĩrẽ gojatúrã waañurã. Siria nikũ marã opʉ Cirenio wãĩkʉgʉ ããrĩripoe gojatúnʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Irasirigʉ Joséde, Galilea nikũma makã Nazaretgue ããrãdi, Judea nikũma makã Belẽ́gue waayupʉ. Belén, David deyoadea makã ããrĩyuro. Ĩgʉ̃, David parãmi ããrĩturiagʉ ããrĩsĩã, irogue waayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ĩgʉ̃ marãpo ããrĩbo María merã ĩgʉ̃ wãĩrẽ gojatúgʉ waayupʉ. María gapʉ nijĩpo ããrĩyupo. ");
INSERT INTO sri_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Irasirigo irogue ããrĩgṍ, nijĩwãgũyupo. ");
INSERT INTO sri_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kãrĩrĩ wii ʉtʉrimakʉ̃ ĩã, José, María merã wekʉa wiigue kãrĩrã waañurã. Iri wiigue María neõ pũrãkʉbeo ããrĩdeo, majĩgʉ̃ pũrãkʉnʉgãyupo. Ĩgʉ̃ deyoamakʉ̃, surí gasiri merã õma, wekʉa baari korogue ĩgʉ̃rẽ sãyupo. ");
INSERT INTO sri_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén tʉrogue ovejare korerimasã ããrĩñurã. Ñamirikʉ irogue dita ĩgʉ̃sãyarã ovejare koreboyoanañurã. ");
INSERT INTO sri_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Irogue ĩgʉ̃sãrẽ gũñaña marĩrõ sugʉ Marĩpʉre wereboegʉ deyoayupʉ. Ĩgʉ̃ deyoamakʉ̃, Marĩpʉ gosesiriri ĩgʉ̃sãrẽ boyoyuro. Irasũ waamakʉ̃ ĩãgʉka, bʉro güiñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Marĩpʉre wereboegʉ ãsũ ãrĩyupʉ ĩgʉ̃sãrẽ: —Güibirikõãka! Mʉsãrẽ õãrĩ kerere ãĩrigʉ yáa, ããrĩpererã masaka ʉsʉyaburire. ");
INSERT INTO sri_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dapagã ñami, David deyoadea makãguere mʉsãrẽ taubu deyoami. Ĩgʉ̃ Marĩpʉ iriudi, Cristo mʉsã Opʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mʉsã majĩgʉ̃rẽ ĩãrã waarã́, surí gasiri merã õmadire, wekʉa baari korogue sãñagʉ̃rẽ bokajarãkoa. Irasirirã ĩgʉ̃rẽ ĩãrã: “Diayeta ããrãñumi”, ãrĩrãkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ĩgʉ̃ irire ãrĩripoeta gajirã wárã Marĩpʉre wereboerã deyoa, Marĩpʉre bʉremurã ãsũ ãrĩ bayañurã: ");
INSERT INTO sri_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́rẽ: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩrã! I ʉ̃mʉgue ĩgʉ̃ merã õãrõ ããrĩrã́ siñajãrĩ opaburo, ãrĩ bayañurã. ");
INSERT INTO sri_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Marĩpʉre wereboerã ʉ̃mʉgasigue mʉrĩadero pʉrʉ, ovejare korerimasã ĩgʉ̃sã basi gãme wereníñurã: —Náka, dapagorata Belẽ́gue! Marĩpʉre wereboegʉ marĩrẽ wereaderosũta ĩãrã waarã́! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Irasirirã mumurõ merã ĩãrã waañurã. Irogue eja, Josére, Maríare bokajañurã. Majĩgʉ̃ gapʉre wekʉa baari korogue sãñagʉ̃rẽ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ĩgʉ̃rẽ ĩãrã, iro ããrĩrã́rẽ Marĩpʉre wereboegʉ majĩgʉ̃yamarẽ wereadeare wereñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ĩgʉ̃sã irire weremakʉ̃ pérã, ããrĩpererã pégʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María gapʉ ããrĩpereri ĩgʉ̃sã wererire pégo, igoya yʉjʉpũrãgueta gũñaduripíyupo. ");
INSERT INTO sri_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ovejare korerimasã Marĩpʉre wereboegʉ wereaderosũta ããrĩpereri ĩgʉ̃sã péadea, ĩãdea keoro waamakʉ̃ ĩãrã, Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari merã goedujáakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pʉrʉ su mojõma pere gaji mojõ ʉreru pẽrẽbejarinʉrĩ waaró merã majĩgʉ̃rẽ ĩgʉ̃ya dʉpʉma gasirogãrẽ wiiriñurã. Wiiri odo, Marĩpʉre wereboegʉ Maríare, igo nijĩpo ããrĩburo dupiyuro ãrĩderosũta ĩgʉ̃rẽ “Jesús” wãĩyeñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pʉrʉ Moisés: “Ãsũ irika ʉ̃mʉ́ʉrẽ pũrãkʉadero pʉrʉ!” ãrĩdeare iripeo, José, María merã Jesúre Jerusalẽ́gue ãĩãñurã, Marĩpʉya wiigue Marĩpʉre: “Mʉyagʉ ããrĩ́mi”, ãrĩ ĩmurã waarã́. ");
INSERT INTO sri_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Irire irirã, Marĩpʉ dorederosũta iriñurã. Ãsũ ãrĩ gojasũdero ããrĩbʉ́ Marĩpʉ doreri gojadea pũgue: “Ããrĩpererã ʉ̃ma deyoapʉrorirã Marĩpʉyarã ããrĩburo”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Irasirirã José, María merã Jerusalẽ́gue Marĩpʉ dorederosũta irirã waañurã. Ãsũ ãrĩ gojasũdero ããrĩbʉ́ doja: “Pẽrã buja, o ĩgʉ̃sã marĩmakʉ̃ buja irirosũ deyorãgã pẽrã sĩka, Marĩpʉ ĩũrõ wẽjẽ soepeoburo, ãrĩrã”. ");
INSERT INTO sri_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iripoere Jerusalẽ́guere sugʉ bʉgʉro Simeón wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃ õãgʉ̃, Marĩpʉre bʉremugʉ̃ ããrĩyupʉ. Israel bumarãrẽ taugʉ aaribure yúgʉ iriyupʉ. Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃ merã ããrĩníkõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iripoegue Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃rẽ ãsũ ãrĩ weredi ããrĩmí: “Cristo, Marĩpʉ iriubure ĩãbita boabirikoa mʉ”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Jesúre ĩgʉ̃ pagʉsãmarã Jerusalẽ́gue ãĩjarinʉrẽ Õãgʉ̃ deyomarĩgʉ̃ Simeṍrẽ Marĩpʉya wiigue waadoreyupʉ. Marĩpʉ dorederosũta Jesúre iri wiigue ãĩjamakʉ̃ ĩã, Simeón ĩgʉ̃rẽ kõã, Marĩpʉre ʉsʉyari sĩ, ãsũ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Yʉ Opʉ, mʉ iripoegue ãrĩderosũta keoro yáa. Irasirigʉ dapagorare yʉ mʉrẽ moãboegʉ ʉsʉyari merã boamasĩa. ");
INSERT INTO sri_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ĩĩ majĩgʉ̃rẽ masakare taubure yaa koye merã ĩãa. ");
INSERT INTO sri_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ĩgʉ̃rẽ masĩdoregʉ, ããrĩpererã masaka ĩũrõgue iriubʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ĩgʉ̃ta judío masaka ããrĩmerãrẽ mʉrẽ masĩmakʉ̃ irigʉ, sĩãgori sĩgʉ̃ irirosũ irigʉkumi. Ããrĩpererã masaka: “Marĩpʉ ĩgʉ̃yarã Israel bumarãrẽ õãrõ iritamumi”, ãrĩrãkuma, ãrĩyupʉ Simeón. ");
INSERT INTO sri_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón majĩgʉ̃yamarẽ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃ pagʉsãmarã pégʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón ĩgʉ̃sãrẽ: “Marĩpʉ mʉsãrẽ õãrõ iriburo”, ãrĩ odo, Jesús pagore ãsũ ãrĩyupʉ: —Ĩĩ majĩgʉ̃ Marĩpʉ beyedi ããrĩ́mi. Wárã Israel bumarã ĩgʉ̃rẽ bʉremumerã perebiri peamegue béodijusũrãkuma. Ĩgʉ̃rẽ bʉremurã gapʉ ʉ̃mʉgasigue ãĩmʉrĩãsũrãkuma. Marĩpʉ turari merã ĩgʉ̃ iri ĩmumakʉ̃ ĩãrã, wárã masaka ñerõ werenírãkuma ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Irasiriri merã ããrĩpererã masaka ĩgʉ̃sãya yʉjʉpũrãrĩgue gũñarĩrẽ masĩsũrokoa. Mʉ gapʉ i merã mʉya yʉjʉpũrãrẽ sareri majĩ merã saremakʉ̃ pũrĩsũrõsũ bʉro bʉjaweregokoa, ãrĩyupʉ Simeón Maríare. ");
INSERT INTO sri_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gajigo Marĩpʉya wiiguere Marĩpʉya kerere weredupiyugode ããrĩyupo. Igo Ana wãĩkʉgo, Fanuel magõ, Aser bumo, bʉ́ro ããrĩyupo. Maamogora marãpʉkʉdeo ããrãdimo. Pʉrʉ, su mojõma pere gaji mojõ peru pẽrẽbejari bojori waaró merã igo marãpʉ boakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Irasirigo wapiweyo dujayupo. Ĩgʉ̃sã Jesúre Marĩpʉya wiigue ãĩjaripoere ochenta y cuatro bojorigora opayupo. Iri wiiguere ʉ̃mʉrikʉ, ñamirikʉ bereri merã Marĩpʉre sẽrẽnayupo. ");
INSERT INTO sri_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jesúre ãĩjamakʉ̃ ĩãgõ, ĩgʉ̃ pʉro aari ejanʉgã, Marĩpʉre ʉsʉyari sĩyupo. Pʉrʉ ããrĩpererã Jerusalén marãrẽ taubure yúrãrẽ Jesús deyoadeare wereyupo. ");
INSERT INTO sri_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José, María Jerusalẽ́gue ããrãnerã, Marĩpʉ dorederosũta ããrĩpereri iripeo, Galilea nikũ ĩgʉ̃sãya makã Nazaretgue goedujáakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Irogue majĩgʉ̃ turagʉ õãrõ masĩgʉ̃ masãyupʉ. Marĩpʉ ĩgʉ̃rẽ õãrõ iritamuyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bojorikʉ Jesús pagʉsãmarã pascua bosenʉrĩ ããrĩmakʉ̃, Jerusalẽ́gue waanañurã. ");
INSERT INTO sri_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús pe mojõma pere su gubu peru pẽrẽbejari bojori oparipoe ĩgʉ̃sã irinarõsũ ĩgʉ̃ merã iri bosenʉrẽ irogue taurã waañurã. ");
INSERT INTO sri_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iri bosenʉ tariadero pʉrʉ, ĩgʉ̃sãya makãgue Nazaretgue goedujáakõãñurã. Jesús gapʉ Jerusalẽ́gueta dujakõãyupʉ. Ĩgʉ̃ pagʉsãmarã ĩgʉ̃ irogue dujarire masĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Gajirã marĩ merãmarã merã aarikumi”, ãrĩ gũñadiñurã. Pʉrʉ Jerusalẽ́rẽ ĩgʉ̃sã wiriadeanʉ ñamika ããrĩmakʉ̃, ĩgʉ̃sã merãmarã watopegue ĩgʉ̃rẽ ãmadiñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ãma, ĩgʉ̃rẽ bokabiri, maa deko merãta gãme dujáakõãñurã doja Jerusalẽ́gue ãmarã́ waarã́. ");
INSERT INTO sri_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ʉrenʉ pʉrʉ Marĩpʉya wiigue Moisés gojadeare buerimasã watopegue doagʉre bokañurã. Ĩgʉ̃sã werenírĩrẽ pé, ĩgʉ̃sãrẽ sẽrẽñanayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ĩgʉ̃ masĩrĩ merã wererire, ĩgʉ̃ õãrõ yʉjʉrire pérã, ããrĩpererã pégʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ĩgʉ̃ irogue doamakʉ̃ ĩãrã, ĩgʉ̃ pagʉsãmarã ĩãgʉkakõãñurã. Pago ĩgʉ̃rẽ ãrĩyupo: —Makʉ, ¿nasirigʉ gʉare irasiriari mʉ? Yʉ, mʉpʉ merã bʉro gũñarikʉri merã mʉrẽ ãmaabʉ, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús pagore ãsũ ãrĩ yʉjʉyupʉ: —¿Nasirirã yʉre ãmaarĩ? Yʉpʉyare yʉre iriro gããmea ĩgʉ̃ya wiiguere. ¿Irire masĩberi mʉsã? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ĩgʉ̃ irasũ ãrĩrĩrẽ ĩgʉ̃ pagʉsãmarã gapʉ pémasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pʉrʉ Jesús ĩgʉ̃sã merã Nazaretgue goedujáakõãyupʉ. Ĩgʉ̃ irinírõsũta ĩgʉ̃sã dorerire tarinʉgãrõ marĩrõ yʉjʉnayupʉ. Ĩgʉ̃ pago gapʉ ããrĩpereri ĩgʉ̃ Jerusalẽ́gue iriadeare igoya yʉjʉpũrãgue gũñaduripíyupo. ");
INSERT INTO sri_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús wári masĩrĩ merã masãyupʉ. Marĩpʉ ĩgʉ̃rẽ: “Õãgʉ̃ ããrĩ́mi”, ãrĩ ĩãyupʉ. Masakade ããrĩpererã irasũta ãrĩ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pe mojõma pere su gubu pẽrẽbejari bojori Tiberio wãĩkʉgʉ romano marã opʉ ããrĩrĩ́ ñajãdero pʉrʉ, gajirã ĩgʉ̃ dokamarã ĩĩsãkʉ ããrĩñurã: Poncio Pilato, Judea nikũ marã opʉ ããrĩyupʉ. Herodes, Galilea nikũ marã opʉ ããrĩyupʉ. Ĩgʉ̃ pagʉmʉ Felipe: Iturea, Traconite, pe nikũ marã opʉ ããrĩyupʉ. Gajigʉ Lisanias, Abilinia nikũ marã opʉ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Gajirã pẽrã: Anás, Caifás wãĩkʉrã paía oparã ããrĩñurã. Ĩgʉ̃sã oparã ããrĩripoere Zacarías magʉ̃ Juãrẽ masaka marĩrõgue ããrĩgʉ̃́rẽ Marĩpʉ ĩgʉ̃yare weredoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Irasirigʉ Juan ããrĩperero dia Jordán wãĩkʉdiya tʉrogue masaka irogue ejarãrẽ: —Mʉsã ñerõ irideare bʉjawereka! Mʉsã gũñarĩrẽ gorawayu, wãĩyedoreka! Irasirimakʉ̃, mʉsãrẽ Marĩpʉ mʉsã ñerõ irideare kãtigʉkumi, ãrĩ werenayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juan irire irigʉ, iripoegue Marĩpʉya kerere weredupiyudi Isaías gojaderosũta iriyupʉ. Ãsũ ãrĩ gojadi ããrĩmí: Masaka marĩrõgue sugʉ bʉro gaguinírĩ merã weregʉkumi: “Marĩ Opʉ aariburi dupiyuro ĩgʉ̃ aariburi maarẽ́ diayema maa õãrĩ maa ãmurã́ irirosũ diayemarẽ irika! ");
INSERT INTO sri_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dupa tʉrʉri ããrãdeare yasurope piusũrokoa. Ʉ̃tãyuku ããrãdeade keoro dujarokoa. Maarĩ́ dupaberori ããrãdeade diayema maarĩ́ dujarokoa. Goberikʉri maarĩ́de su báparogueta dujarokoa. ");
INSERT INTO sri_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Marĩpʉ marĩrẽ taubure iriumakʉ̃, ããrĩpererã masaka ĩãrãkuma”, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wárã masaka Juan pʉrogue wãĩyedorerã ejañurã. Juan ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã ãña irirosũ ñerã ããrã. ¿Noã mʉsãrẽ õõguere aaridoreari? Marĩpʉ, gʉa ñerõ iriri waja wajamoãbirikõãburo, ãrĩrã, ¿mʉsã yʉre wãĩyedorerã aarari? ");
INSERT INTO sri_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mʉsã: “Gʉa ñerõ irideare bʉjawere, gũñarĩrẽ gorawayuabʉ”, ãrĩrã, mʉsã ñerõ irideare piri, õãrĩ gapʉre irika! Mʉsã: “Gʉa Abraham parãmerã ããrĩturiarã ããrĩmakʉ̃, Marĩpʉ gʉare wajamoãbirikumi”, ãrĩ gũñabirikõãka! Yʉ mʉsãrẽ ãsũ ãrã: “Mʉsã gũñarĩrẽ gorawayubirimakʉ̃, mʉsã Abraham parãmerã ããrĩturiari wajamáa. Marĩpʉ i ʉ̃tãyeri merã Abraham parãmerã ããrĩturiarã waamakʉ̃ irimasĩmi”. ");
INSERT INTO sri_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mʉsã ñerĩ iririre piribirimakʉ̃ ĩãgʉ̃, Marĩpʉ mʉsãrẽ béogʉkumi. Sugʉ yukʉ ñerĩ dʉkakʉdire ĩã, kõme merã nugũrĩgue merãta diti, peamegue soebéorosũ mʉsãrẽ béogʉkumi, ãrĩyupʉ Juan. ");
INSERT INTO sri_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, Juãrẽ sẽrẽñañurã: —¿Gʉare nasiriro gããmerĩ? ");
INSERT INTO sri_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan ĩgʉ̃sãrẽ yʉjʉyupʉ: —Sugʉ peñe suríro opagʉ, opabire suñe sĩburo. Baari opagʉ, baari opabire dʉkawaburo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gajirã romano marã oparãrẽ niyeru wajaseabosarã, Juan pʉro wãĩyedorerã ejañurã. Ĩgʉ̃sãde Juãrẽ sẽrẽñañurã: —Gʉare buegʉ, ¿gʉare nasiriro gããmerĩ? ");
INSERT INTO sri_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Juan ãrĩyupʉ: —Mʉsã oparã mʉsãrẽ wajaseadoreaderopata wajaseaka! Ĩgʉ̃sã doreadero nemorõ wajaseabirikõãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Gajirã surara Juãrẽ sẽrẽñañurã: —¿Gʉakoare nasiriro gããmerĩ? ãrĩñurã. Ĩgʉ̃sã irasũ ãrĩmakʉ̃, ãsũ ãrĩ yʉjʉyupʉ: —Gajirã oparire ẽmabirikõãka! Ĩgʉ̃sãrẽ niyeru ẽmadʉarã ãrĩkatori merã ĩgʉ̃sã iribirideaguereta weresãbirikõãka! Mʉsã moã wajatari merã ʉsʉyaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Masaka: “¿Naásũ ããrĩmakʉ̃ Marĩpʉ iriubu aarigʉkuri?” ãrĩ gũñarã iriñurã. Irasirirã, Juan wererire pérã: “¿Ĩĩ Juan, Cristo ããrĩkuri?” ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan ããrĩpererã masakare ãsũ ãrĩyupʉ: —Yʉ mʉsãrẽ deko merã wãĩyea. Gajigʉ yʉ pʉrʉ aarigʉ́, yʉ nemorõ turagʉ ããrĩ́mi. Yʉ gapʉ ubu ããrĩgʉ̃́, ĩgʉ̃rẽ neõ sʉropebirikoa. Ĩgʉ̃ aarigʉ́, mʉsãrẽ Õãgʉ̃ deyomarĩgʉ̃ merã, peame merã wãĩyegʉkumi. Irasirigʉ mʉsãrẽ Õãgʉ̃ deyomarĩgʉ̃ mʉsã merã ããrĩnímakʉ̃ irigʉkumi, ñerĩrẽ soebéorosũ mʉsãrẽ ñerĩrẽ béoburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Trigo gasirire korobéogʉ irirosũ ããrĩ́mi. Gasirire koro odo, iri yerire baari duripíri wiigue duripígʉkumi. Iri gasiri gapʉre peamegue soebéokõãgʉkumi. Iri peame neõ yaribirikoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juan gaji wári irasũ wereri merã masakare: “Ãsũ irika!” ãrĩ werenayupʉ. Irasirigʉ iri merã Marĩpʉya õãrĩ kerere werenayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Iripoere opʉ Herodes ĩgʉ̃ pagʉmʉ Felipe marãpore Herodías wãĩkʉgore ẽma, marãpokʉyupʉ. Iri waja, gaji wári ñerõ iridea waja, Juan ĩgʉ̃rẽ: “Mʉ irasirimakʉ̃ ñetaria”, ãrĩ wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes, Juan wererire pérono irigʉ, ñerõ irinemo, ĩgʉ̃rẽ peresu iriri wiigue sóodoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan peresu iriri wiigue sóosũburi dupiyuro ããrĩpererã masaka ĩgʉ̃ pʉro wãĩyedorerã ejarãrẽ wãĩyeyupʉ. Jesúde ĩgʉ̃ pʉrogue wãĩyedoregʉ ejayupʉ. Juan ĩgʉ̃rẽ wãĩye odomakʉ̃, Jesús Marĩpʉre sẽrẽripoe ʉ̃mʉgasi tũpãkõãyuro. ");
INSERT INTO sri_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Õãgʉ̃ deyomarĩgʉ̃, buja irirosũ deyogʉ dijari, Jesús weka ejabejayupʉ. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ãsũ ãrĩyupʉ Jesúre: —Mʉ yʉ magʉ̃, yʉ maĩgʉ̃ ããrã. Mʉ merã bʉro ʉsʉyáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús treinta bojori opagʉ masakare buenʉgãyupʉ. Masaka Jesúre: “José magʉ̃ ããrĩ́mi ĩĩ”, ãrĩ gũñadiñurã. José, Elí magʉ̃ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat magʉ̃, Matat Leví magʉ̃, Leví Melqui magʉ̃, Melqui Jana magʉ̃, Jana José magʉ̃, José Matatías magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatías Amós magʉ̃, Amós Nahum magʉ̃, Nahum Esli magʉ̃, Esli Nagai magʉ̃, Nagai Maat magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat Matatías magʉ̃, Matatías Semeí magʉ̃, Semeí José magʉ̃, José Judá magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joana magʉ̃, Joana Resa magʉ̃, Resa Zorobabel magʉ̃, Zorobabel Salatiel magʉ̃, Salatiel Neri magʉ̃, Neri Melqui magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melqui Adi magʉ̃, Adi Cosam magʉ̃, Cosam Elmodam magʉ̃, Elmodam Er magʉ̃, Er Josué magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josué Eliezer magʉ̃, Eliezer Jorim magʉ̃, Jorim Matat magʉ̃, Matat Leví magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví Simeón magʉ̃, Simeón Judá magʉ̃, Judá José magʉ̃, José Jonán magʉ̃, Jonán Eliaquim magʉ̃, Eliaquim Melea magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea Mainán magʉ̃, Mainán Matata magʉ̃, Matata Natán magʉ̃, Natán opʉ David magʉ̃ ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David Isaí magʉ̃, Isaí Obed magʉ̃, Obed Booz magʉ̃, Booz Salmón magʉ̃, Salmón Naasón magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadab magʉ̃, Aminadab Aram magʉ̃, Aram Esrom magʉ̃, Esrom Fares magʉ̃, Fares Judá magʉ̃, Judá Jacob magʉ̃ ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob Isaac magʉ̃, Isaac Abraham magʉ̃ ããrĩdi ããrĩmí. Abraham Taré magʉ̃, Taré Nacor magʉ̃, Nacor Serug magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug Ragau magʉ̃, Ragau Peleg magʉ̃, Peleg Heber magʉ̃, Heber Sala magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán magʉ̃, Cainán Arfaxad magʉ̃, Arfaxad Sem magʉ̃, Sem Noé magʉ̃ ããrĩdi ããrĩmí. Noé Lamec magʉ̃, Lamec Matusalén magʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusalén Enoc magʉ̃, Enoc Jared magʉ̃, Jared Mahalaleel magʉ̃, Mahalaleel Cainán magʉ̃, Cainán Enós magʉ̃, Enós Set magʉ̃, Set Adán magʉ̃ ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Adán neõgorague Marĩpʉ iridi, ĩgʉ̃ magʉ̃ ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús Õãgʉ̃ deyomarĩgʉ̃rẽ opatariakõãyupʉ. Irasirigʉ Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃ dia Jordán wãĩkʉdiyague ããrãdire masaka marĩrõgue ãĩayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Irogue Jesús cuarenta nʉrĩgora ããrĩyupʉ. Irogue ããrĩripoe wãtĩ ĩgʉ̃rẽ ãrĩmesãgʉ̃ ejayupʉ. Iri cuarenta nʉrĩrẽ Jesús neõ baabiriyupʉ. Irasirigʉ ʉaboakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ĩgʉ̃ ʉaboamakʉ̃ ĩãgʉ̃, wãtĩ Jesúre ãsũ ãrĩyupʉ: —Diayeta Marĩpʉ magʉ̃ ããrĩgʉ̃́, mʉ turaro merã i ʉ̃tãyere pã́ waamakʉ̃ irika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉpʉya werenírĩ gojadea pũgue: “Baari dita masakare okamakʉ̃ iribea. Ããrĩpereri Marĩpʉya werenírĩ gapʉ ĩgʉ̃sãrẽ okamakʉ̃ yáa”, ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ Jesús wãtĩrẽ. ");
INSERT INTO sri_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pʉrʉ wãtĩ Jesúre ʉ̃tãʉ̃ wekague ãĩmʉrĩayupʉ. Irogue suñarõta ããrĩpereri i ʉ̃mʉma makãrĩrẽ ĩmupeokõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Irire ĩmupeo odo, ãsũ ãrĩyupʉ: —I yʉre sĩdea ããrã. Irasirigʉ yʉ sĩdʉagʉre sĩgʉkoa, ĩgʉ̃ i ããrĩpereri opʉ ããrĩburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mʉ yʉre ñadʉkʉpuri merã ejamejãja, bʉremumakʉ̃, i ããrĩpereri mʉrẽ sĩgʉra, ãrĩ wereyupʉ wãtĩ Jesúre. ");
INSERT INTO sri_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Satanás, yʉ pʉrore wirika! Yʉpʉya werenírĩ gojadea pũgue: “Marĩpʉ ditare bʉremuka! Ĩgʉ̃ doreri ditare irika!” ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ Jesús wãtĩrẽ. ");
INSERT INTO sri_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pʉrʉ wãtĩ Jesúre Jerusalẽ́gue ãĩa, Marĩpʉya wii wekague ãĩmʉrĩa, ĩgʉ̃rẽ ãsũ ãrĩyupʉ doja: —Diayeta Marĩpʉ magʉ̃ ããrĩgʉ̃́, õõgue merã yebague parimadijaka! ");
INSERT INTO sri_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojasũdero ããrĩbʉ́: Marĩpʉ ĩgʉ̃rẽ wereboerãrẽ mʉrẽ koredoregʉkumi, neõ ʉ̃tãyegue meébejabirikõãburo, ãrĩgʉ̃, ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ wãtĩ Jesúre. ");
INSERT INTO sri_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Yʉpʉya werenírĩ gojadea pũgue: “Bʉremurĩ marĩrõ Marĩpʉre: ‘Mʉ turari merã yʉre gajino iri ĩmuka!’ ãrĩbirikõãka!” ãrĩ gojasũdero ããrĩbʉ́, ãrĩ wereyupʉ Jesús wãtĩrẽ. ");
INSERT INTO sri_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Irasirigʉ wãtĩ Jesúre gaji ãrĩmesãrĩ bokabiri, waakõãyupʉ dapa. ");
INSERT INTO sri_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pʉrʉ Jesús masaka marĩrõgue ããrãdi Galilea nikũgue goedujáayupʉ. Õãgʉ̃ deyomarĩgʉ̃ turarire opatariyupʉ. Ããrĩperero Galilea nikũ marã ĩgʉ̃ iridea kerere masĩpereakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús irogue ejagʉ, makãrĩkʉ judío masaka nerẽrĩ wiirigue buenayupʉ. Ĩgʉ̃ buemakʉ̃ pérã, ããrĩpererã: “Õãrõ buemi”, ãrĩ bʉremuñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pʉrʉ Jesús Nazaretgue ĩgʉ̃ masãdea makãgue goedujáayupʉ. Ĩgʉ̃ irinarõsũta judío masaka siñajãrĩnʉ ããrĩmakʉ̃, ĩgʉ̃sã nerẽrĩ wiigue waa, ñajãyupʉ. Iri wiigue Marĩpʉya werenírĩ gojadea pũrẽ bue ĩmubu wãgãnʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Irasirigʉ iri wii koregʉ Jesúre Marĩpʉya kerere weredupiyudi Isaías gojadea pũrẽ sĩyupʉ. Ĩgʉ̃ sĩmakʉ̃, Jesús iri pũgue ãsũ ãrĩ gojadeare boka, bue ĩmuyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yʉ Opʉ, Õãgʉ̃ deyomarĩgʉ̃ yʉ merã ããrĩmakʉ̃ yámi, ĩgʉ̃ dorerire iriburo, ãrĩgʉ̃. Ĩgʉ̃yare iridoregʉ yʉre beyepídi ããrĩmí. Irasirigʉ boporãrẽ ĩgʉ̃ya kerere weredoregʉ, bʉro bʉjawererãrẽ ʉsʉyamakʉ̃ iridoregʉ, peresugue ããrĩrã́rẽ taudoregʉ, koye ĩãmerãrẽ ĩãmakʉ̃ iridoregʉ, ñerõ irisũrãrẽ taudoregʉ yʉre iriudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Marĩ Opʉ ĩgʉ̃yarãrẽ taugʉ aariburire weredoredi ããrĩmí, ãrĩ gojadi ããrĩmí Isaías, ãrĩ bue ĩmuyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bue ĩmu odo, ĩgʉ̃ bueadea pũrẽ tũrã, iri wii koregʉre wia, eja doayupʉ. Ããrĩpererã iri wiigue ããrĩrã́ ĩgʉ̃rẽ ĩãduúbiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesús ãsũ ãrĩ werenʉgãyupʉ ĩgʉ̃sãrẽ: —Dapagã merã yʉ mʉsãrẽ bue ĩmumakʉ̃, Isaías gojaderosũta waáa. ");
INSERT INTO sri_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesús irasũ ãrĩmakʉ̃ pérã, ããrĩpererã pégʉkakõãñurã. “Õãrĩ werenírĩ merã weremi”, ãrĩ gũñañurã. Irasũ gũñakererã, ĩgʉ̃sã basi gãme sẽrẽñañurã: —¿Ĩĩ José magʉ̃ meta ããrĩ́rĩ? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús, ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —Masaka ĩgʉ̃sã ãrĩnarõsũ mʉsã yʉre: “Mʉ õãrõ kúrigʉ ããrĩrĩ́rẽ ĩmugʉ̃, mʉ basita kúrika!” ãrĩkoa. Gajidere ãrĩkoa: “Gʉa, mʉ Capernaugue iri ĩmudea kerere pébʉ. Irasirigʉ iroguere mʉ iriderosũta i makã, mʉ masãdea makãdere iri ĩmuka!” ãrĩkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Irasũ ãrĩ odo, ãsũ ãrĩnemoyupʉ: —Diayeta mʉsãrẽ werea. Neõ sugʉ Marĩpʉya kerere weredupiyurimasʉ̃rẽ ĩgʉ̃ya nikũ marã õãrõ bokatĩrĩñeãbema. ");
INSERT INTO sri_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Irasirigʉ mʉsãrẽ ire õãrõ masĩmakʉ̃ gããmea. Iripoegue Elías Marĩpʉya kerere weredupiyudi ããrĩdeapoere masaka Marĩpʉre bʉremubiri waja, ʉre bojori gaji bojori dekogora neõ deko merẽbiridero ããrĩbʉ́. Ããrĩpereroguere baaride marĩdero ããrĩbʉ́. Marĩya nikũrẽ wárã wapiweyarã nome ããrĩnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ĩgʉ̃sã wárã ããrĩkeremakʉ̃, Marĩpʉ Elíare ĩgʉ̃sãrẽ iritamudoregʉ neõ iriubiridi ããrĩmí. Gaji nikũmo Sarepta wãĩkʉri makãmo Sidón pʉro ããrĩgṍ gapʉre iritamudoregʉ Elíare iriudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eliseo Marĩpʉya kerere weredupiyudi ããrĩdeapoedere wárã kãmi boarã marĩya nikũrẽ ããrĩunanerã ããrĩmá. Ĩgʉ̃sã wárã ããrĩkeremakʉ̃, Marĩpʉ Eliseore ĩgʉ̃sãrẽ taudoregʉ neõ iriubiridi ããrĩmí. Siria nikũmʉ Naamán wãĩkʉgʉ gapʉre taudoregʉ Eliseore iriudi ããrĩmí, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesús irasũ ãrĩmakʉ̃ pérã, ããrĩpererã iri wiigue ããrĩrã́ ĩgʉ̃ merã bʉro guañurã. ");
INSERT INTO sri_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Irasirirã wãgãnʉgã, ĩgʉ̃rẽ ñeã, ãĩãkõãñurã. Iri makã ʉ̃tãʉ̃ weka iridea makã ããrĩyuro. Irasirirã iri makã tʉrogue ĩgʉ̃rẽ ãĩa, túmeédijudʉarã iriadiñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesús gapʉ ĩgʉ̃sã watopeta tariwerewãgãkõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pʉrʉ Jesús Capernaugue waayupʉ. Iri makã Galilea nikũgue ããrĩyuro. Irogue eja, judío masaka siñajãrĩnʉ ããrĩmakʉ̃, ĩgʉ̃sã nerẽrĩ wiigue ĩgʉ̃sãrẽ bueyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sugʉ doregʉ irirosũ õãrõ masĩrĩ merã ĩgʉ̃ buemakʉ̃ pérã, pégʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Iri wiiguere ĩgʉ̃sã merã sugʉ wãtĩ ñajãsũdi ããrĩyupʉ. Ãsũ ãrĩ gaguiníyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús Nazaretmʉ, ¿nasiribu gʉa pʉro aaríri? ¿Gʉare peamegue béogʉ aarigʉ́ yári? Yʉ mʉrẽ ĩãmasĩkõãa. Mʉ, Marĩpʉ iriudi, õãtarigʉ ããrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús wãtĩrẽ: —Wereníbita! Wirika ĩgʉ̃rẽ! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, wãtĩ masaka ĩũrõ ĩgʉ̃ ñajãdire yebague túmeépí, ñerõ iriro marĩrõ wiriakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jesús wãtĩrẽ béowiumakʉ̃ ĩãrã, ããrĩpererã masaka ĩãgʉka, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníñurã: —¿Ñeéno werenírĩ ããrĩ́rĩ i? Ĩgʉ̃ turaro merã wãtẽãrẽ wiriadoremakʉ̃, mata wirianokõãma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pʉrʉ Jesús iriadeare ããrĩperero iri makã tʉro marãrẽ weresiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús, nerẽrĩ wiigue ããrãdi wiria, Simṍya wiigue waayupʉ. Simón mʉ́ñekõ bʉro nimakʉrikʉgo iriyupo. Jesús ejamakʉ̃ ĩãrã, igore taudorerã ĩgʉ̃rẽ sẽrẽñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ĩgʉ̃sã irasũ sẽrẽmakʉ̃ pégʉ, Jesús igo pʉro waa ejanʉgã: “Pũrĩrĩ tarika igore!” ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩrĩ merãta igore nimakʉri ããrãdea tariakõãyuro. Irasirigo wãgãnʉgã, ĩgʉ̃sãrẽ baari ejoyupo. ");
INSERT INTO sri_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ñamika, abe ñajãdero pʉrʉ, iri makã marã ããrĩpererã gajirosũperi pũrĩrikʉrãrẽ Jesús pʉrogue ãĩjañurã. Jesús pũrĩrikʉrãrẽ, ĩgʉ̃ya mojõrĩ merã ñapeo, tauyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wárã wãtẽa masakare ñajãnerãdere béowiuyupʉ. Wãtẽa wirirã, Jesúre ãsũ ãrĩ gaguiníñurã: —Mʉ, Marĩpʉ magʉ̃ ããrã, ãrĩñurã. Ĩgʉ̃sã Jesúre, ĩgʉ̃ Cristo, Marĩpʉ iriudi ããrĩrĩ́rẽ masĩñurã. Irasirigʉ Jesús wãtẽãrẽ werenídorebiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gajinʉ boyoripoe Jesús makã tʉro masaka marĩrõgue waayupʉ. Ĩgʉ̃ waadero pʉrʉ, masaka ĩgʉ̃rẽ ãma, ĩgʉ̃ pʉrogue ejañurã. Ĩgʉ̃rẽ: “Gʉa merã dujaka dapa!” ãrãdiñurã. ");
INSERT INTO sri_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús gapʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —Marĩpʉ ĩgʉ̃yarã Opʉ ããrĩrĩ́rẽ yʉre weredoregʉ iriudi ããrĩmí. Irasirigʉ gaji makãrĩ marãdere ire weregʉ waagʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Irasirigʉ ããrĩperero Galilea nikũ marãrẽ judío masaka nerẽrĩ wiirigue buegorenayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gajinʉ Jesús Genesaret wãĩkʉri ditaru tʉrogue ããrĩmakʉ̃, wárã masaka ĩgʉ̃ pʉrore ʉtʉrinʉgãjañurã Marĩpʉya kerere pédʉarã. ");
INSERT INTO sri_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús iri ditaru tʉro waaí wẽjẽrĩmasãya doóriduparu peru masaka marĩrĩ payamakʉ̃ ĩãyupʉ. Waaí wẽjẽrĩmasã gapʉ ĩgʉ̃sãya buiriyukure koerã iriñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús Simṍyarugue mʉrĩñajãa, ĩgʉ̃rẽ soewijudoreyupʉ. Soewijupau odomakʉ̃ ĩã, Jesús irirugue eja doa, masakare buenʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bue odo, Simṍrẽ ãsũ ãrĩyupʉ: —Doódiru merã ditaru deko ʉ̃kʉ̃ãrõgue wija, mʉsãya buiriyukure meéyoka waaí ñeãmurã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón ĩgʉ̃rẽ yʉjʉyupʉ: —Gʉare buegʉ, dapagã ñamirẽ wẽjẽboyoakõãdabʉ. Neõ wẽjẽbirakubʉ. Mʉ dorerosũta buidire meéyoñagʉra doja, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ĩgʉ̃sã meéyomakʉ̃, waaí wárã ñajãa, buidire ooreakõãdiñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wárã ñajãmakʉ̃ ĩã, ĩgʉ̃sã merãmarã gajiru doódirugue ããrĩrã́rẽ bʉadeañurã, ĩgʉ̃sãrẽ ñeãtamudorerã. Irasirirã ĩgʉ̃sã eja, waairé seasãmakʉ̃, perugueta mirĩboyakõãyuro. ");
INSERT INTO sri_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Irasũ waamakʉ̃ ĩãgʉ̃, Simón Pedro Jesús pʉro ñadʉkʉpuri merã ejamejãja, ĩgʉ̃rẽ ãrĩyupʉ: —Yʉ Opʉ, mʉ õãtarigʉ ããrã. Yʉ gapʉ ñegʉ̃ ããrã. Irasirigʉ yʉ pʉrore ããrĩbirikõãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón, wárã waaí ñajãmakʉ̃ ĩãgʉkagʉ, irasũ ãrĩyupʉ. Ĩgʉ̃ merã ããrĩrã́de ĩãgʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gajiru doódiru ããrĩrã́ ĩgʉ̃ merãmarã Zebedeo pũrã Santiago, Juan ããrĩñurã. Ĩgʉ̃sãde ĩãgʉkakõãñurã. Jesús gapʉ Simṍrẽ ãrĩyupʉ: —Güibirikõãka! Dapagorare mʉ waaí wẽjẽrĩmasʉ̃ ããrĩrĩ́rẽ piri, Marĩpʉya kerere masakare wererimasʉ̃ ããrĩgʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Irasirirã ĩgʉ̃sãya doóriduparure ditaru tʉro tʉ̃ãmajũpíkõã, ããrĩpereri ĩgʉ̃sãyare píkõã, Jesús merã waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pʉrʉ Jesús su makãgue ããrĩripoe sugʉ kãmi boagʉ ejayupʉ. Jesúre ĩãgʉ̃, ĩgʉ̃ pʉro ñadʉkʉpuri merã ejamejã, ĩgʉ̃ya diapure yebague moomejãja, ĩgʉ̃rẽ sẽrẽyupʉ: —Yʉ Opʉ, mʉ yʉ pũrĩrikʉrire taudʉagʉ taumasĩa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃ya mojõ merã ĩgʉ̃rẽ moãña, ãsũ ãrĩyupʉ: —Mʉrẽ taugʉra. Kãmi marĩgʉ̃ dujaka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩrĩ merãta kãmi yaripereakõãyuro. ");
INSERT INTO sri_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Irasirigʉ turaro merã Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Gajirã masakare mʉ tariadeare werebirikõãka! Paíre mʉrẽ kãmi yariadeare ĩmugʉ̃ waaka! Ĩgʉ̃ mʉrẽ ĩãgʉ̃: “Kãmi marĩgʉ̃ ããrã”, ãrĩgʉkumi. Pʉrʉ Moisés gojadea pũgue sĩdoredeare sĩka! Mʉ irire irimakʉ̃ ĩãrã, ããrĩpererã masaka mʉrẽ kãmi yariadeare masĩrãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesús ĩgʉ̃rẽ: “Gajirãrẽ mʉ tariadeare werebirikõãka!” ãrĩkeremakʉ̃, ããrĩpererogue marã masaka Jesús ĩgʉ̃rẽ iriadeare pépereakõãñurã. Irasirirã wárã masaka ĩgʉ̃ pʉrogue ĩgʉ̃ buerire pérã, ĩgʉ̃sã pũrĩrikʉridere taudorerã, ejañurã. ");
INSERT INTO sri_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús gapʉ masaka marĩrõgue Marĩpʉre sẽrẽgʉ̃ waanayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sunʉ Jesús buemakʉ̃, surãyeri fariseo bumarã gajirã Moisés gojadeare buerimasãde irogue doañurã. Ĩgʉ̃sã ããrĩperero Galilea nikũma makãrĩ marã, Judea nikũma makãrĩ marã, Jerusalén marã ããrĩñurã. Jesús pũrĩrikʉrãrẽ taubu, Marĩpʉ turarire opayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ĩgʉ̃ bueripoe gajirã iro marã sugʉ dʉpʉ bʉadire ĩgʉ̃ oyaro merãta ãĩjañurã. Ĩgʉ̃rẽ wiigue ãĩñajãa, Jesús pʉrogue pídʉarã iriadiñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Masaka wárã ããrĩmakʉ̃, ãĩñajãmasĩbiri, iri wii wekague mʉrĩa, su gobe ãĩwea, ĩgʉ̃rẽ masaka watopegue ĩgʉ̃ oyaro merãta Jesús pʉro dijuñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús, ĩgʉ̃sã ĩgʉ̃rẽ bʉremumakʉ̃ ĩãgʉ̃, bʉadire ãrĩyupʉ: —Yʉ, mʉ ñerõ irideare kãtia. ");
INSERT INTO sri_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, fariseo bumarã, Moisés gojadeare buerimasã ãsũ ãrĩ gũñañurã: “¿Ñeémʉno masakʉ ããrĩ́rĩ ĩĩ? Ĩgʉ̃ werenírĩ merã Marĩpʉre ñerõ ãrĩmi. Masaka ñerõ irideare neõ sugʉ masakʉ kãtimasĩbirikumi. Marĩpʉ sugʉta masĩkumi”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús ĩgʉ̃sã gũñarĩrẽ ĩãmasĩ, ãsũ ãrĩyupʉ: —¿Nasirirã irasũ gũñarĩ mʉsã? ");
INSERT INTO sri_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Naásũ ãrĩrĩ gapʉ diasaberi ĩĩ bʉadire: “Yʉ, mʉ ñerõ irideare kãtia”, ãrĩrĩ, o “Wãgãnʉgã, waaka!” ãrĩrĩ gapʉ diasaberi? ");
INSERT INTO sri_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yʉ ããrĩpererã tĩ́gʉ̃ i ʉ̃mʉgue ããrĩrã́rẽ ĩgʉ̃sã ñerõ irideare Marĩpʉ dorero merã kãtimasĩa. Irasirigʉ ĩĩ bʉadire taugʉra, mʉsãrẽ irire masĩdoregʉ, ãrĩyupʉ. Irasũ ãrĩ odo, bʉadire ãrĩyupʉ: —Yʉ mʉrẽ ãsũ ãrã. Wãgãnʉgã, mʉ oyaderore ãĩ, mʉya wiigue waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ĩgʉ̃ irasũ ãrĩrĩ merãta ĩgʉ̃sã ĩũrõ wãgãnʉgã, ĩgʉ̃ oyaderore ãĩ, ĩgʉ̃ya wiigue waagʉ́, Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Masaka, Jesús irasiririre ĩãgʉka, ĩgʉ̃sãde Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩñurã. Bʉro güiri merã ãsũ ãrĩñurã: —Dapagãrẽ neõ marĩ ĩãbirideare ĩãa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pʉrʉ Jesús iro merã waa, Leví wãĩkʉgʉre bokajayupʉ. Leví romano marã opʉre niyeru wajaseabosagʉ ããrĩyupʉ. Ĩgʉ̃ moãrĩ taribugue doamakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Náka, yʉ merã! ");
INSERT INTO sri_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Leví wãgãnʉgã, ĩgʉ̃ moãdea ããrĩpererire pípeo, Jesús merã waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pʉrʉ Leví ĩgʉ̃ya wiigue eja, Jesúre bosenʉ iripeoyupʉ. Wárã niyeru wajaseabosarimasã, gajirã masaka ĩgʉ̃sã merã baa doaníñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jesús ĩgʉ̃sã merã doamakʉ̃ ĩãrã, fariseo bumarã, Moisés gojadeare buerimasã Jesús buerãrẽ ãsũ ãrĩ werewʉañurã: —¿Nasirirã niyeru wajaseabosarimasã, ñerõ irirã merã iirí, baari mʉsã? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Pũrĩrĩ marĩrã kúririmasʉ̃rẽ ãmabema. Pũrĩrikʉrã gapʉ ĩgʉ̃rẽ ãmama. ");
INSERT INTO sri_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yʉ: “Õãrã ããrã”, ãrĩ gũñarãrẽ siiugʉ aaribiribʉ. “Ñerõ irirã ããrã”, ãrĩ gũñarã ditare siiugʉ aarigʉ́ iribʉ, ĩgʉ̃sã ñerõ irideare bʉjawere, gũñarĩrẽ gorawayuburo, ãrĩgʉ̃, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesús irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ sẽrẽñañurã: —Juan buerã, fariseo bumarã buerire tʉyarãde Marĩpʉre bʉremurã bere, ĩgʉ̃rẽ sẽrẽnama. ¿Nasirirã mʉ buerã gapʉ õãrõ iirí, baari? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —¿Sugʉ mojõsʉadi bosenʉ irimakʉ̃, mʉsã ĩgʉ̃ siiuanerãrẽ ĩgʉ̃ merã ããrĩrã́rẽ bʉjawereri merã beremakʉ̃ irimasĩbukuri? ");
INSERT INTO sri_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pʉrʉ ĩgʉ̃rẽ gajirã ãĩãmakʉ̃, bʉjawereri merã bererãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Irire ãrĩ odo, keori merã ĩgʉ̃sãrẽ ãsũ ãrĩ wereyupʉ doja: —Masaka neõ suríro maamañerẽ tábirikuma bʉgʉñerẽ seretúmurã. Irasũ seretúrã, maamañerẽ poyanorẽrã irikuma. Maama gasiro merã bʉgʉñerẽ seretúadero õãrõ deyobirikoa. ");
INSERT INTO sri_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Waimʉrã gasiri merã iridea ajuri bʉgʉ ajurigue maama igui dekore diribirikuma. Irasũ dirimakʉ̃, maama igui deko pãmu, bʉgʉ ajuri sẽrãturabiri, ooreakõãkoa. Irasiriro igui deko, ajuride kõmokoa. ");
INSERT INTO sri_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Irasirirã maama igui dekore maama ajurigue diriro gããmea. ");
INSERT INTO sri_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Masaka igui deko pãmurĩrẽ iirírã, maama igui dekore gããmebirikuma, maama buerire pédʉaberosũ. “Igui deko pãmudea gapʉ, maama igui deko nemorõ õãa”, ãrĩrãkuma, ãrĩyupʉ Jesús ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gajinʉ, judío masaka siñajãrĩnʉ ããrĩmakʉ̃, Jesús trigo otedero watope waamakʉ̃, ĩgʉ̃ buerã trigo yerire tʉ̃rĩ koro baawãgãñurã. ");
INSERT INTO sri_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ĩgʉ̃sã irasirimakʉ̃ ĩãrã, surãyeri fariseo bumarã ĩgʉ̃sãrẽ sẽrẽñañurã: —¿Nasirirã siñajãrĩnʉrẽ moãdorebirikeremakʉ̃, irasũ yári mʉsã? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —¿Mʉsã iripoeguemʉ David ĩgʉ̃ merãmarã merã ʉaboagʉ, ĩgʉ̃ irideare buebiriri? ");
INSERT INTO sri_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ĩgʉ̃ merãmarã merã Marĩpʉya wiigue ñajãa, Marĩpʉ ĩũrõ peyari pã́ duparure baadi ããrĩmí. Marĩpʉ paía ããrĩmerãrẽ: “Iri pã́ duparure baabirikõãka!” ãrĩdi ããrĩmí. David gapʉ paí ããrĩbirikeregʉ, irire baagʉ, Marĩpʉ ĩũrõ ĩgʉ̃ dorerire tarinʉgãgʉ̃ meta iridi ããrĩmí, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Irasũ ãrĩ odo, ãsũ ãrĩyupʉ doja: —Yʉ ããrĩpererã tĩ́gʉ̃ ããrĩsĩã, siñajãrĩnʉrẽ masaka gajino ĩgʉ̃sã iriburire doremasĩa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gajinʉ siñajãrĩnʉ ããrĩmakʉ̃, Jesús judío masaka nerẽrĩ wiigue ñajãa, ĩgʉ̃sãrẽ bueyupʉ. Iri wiigue sugʉ masakʉ diayema mojõ gapʉ diíweredi ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fariseo bumarã, Moisés gojadeare buerimasã Jesúre bʉro ĩãduripítʉya: “Siñajãrĩnʉ ããrã, irasirirã ĩĩ mojõ diíweredire ĩgʉ̃ taumakʉ̃, ĩgʉ̃rẽ weresãrãra”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús ĩgʉ̃sã gũñarĩrẽ ĩãmasĩ, mojõ diíweredire: —Wãgãnʉgã, masaka ĩũrõgue ejanʉgãgʉ̃ aarika! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, mojõ diíweredi wãgãnʉgã, Jesús pʉro ejanʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ĩgʉ̃ ejanʉgãmakʉ̃, Jesús gajirã irogue ããrĩrã́rẽ ãsũ ãrĩyupʉ: —Mʉsãrẽ sẽrẽñadʉakoa. ¿Siñajãrĩnʉrẽ Marĩpʉ marĩrẽ ñeénorẽ iridoreyuri, õãrĩrẽ, o ñerĩrẽ, masakare taurire, o wẽjẽrĩrẽ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sẽrẽña odo, masaka ããrĩpererãrẽ ĩã, mojõ diíweredire ãrĩyupʉ: —Mʉya mojõrẽ soeuka! Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, soeuyupʉ. Ĩgʉ̃ soeumakʉ̃, ĩgʉ̃ya mojõ õãkõãyuro. ");
INSERT INTO sri_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ĩgʉ̃ irasirimakʉ̃ ĩãrã, fariseo bumarã, Moisés gojadeare buerimasã bʉro guañurã: “¿Nasirirãkuri marĩ ĩĩrẽ?” ãrĩ gãme wereníñurã. ");
INSERT INTO sri_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Irinʉrĩrẽ Jesús ʉ̃tãʉ̃gue Marĩpʉre sẽrẽgʉ̃ waayupʉ. Irogue iri ñamirẽ Marĩpʉre sẽrẽboyoakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Boyoripoe ĩgʉ̃ buerire tʉyarãrẽ siiu neeõ, ĩgʉ̃sã watopegue ããrĩrã́rẽ pe mojõma pere su gubu peru pẽrẽbejarã ʉ̃marẽ beyeyupʉ: “Mʉsãrẽ yaa kerere buegorenamurãrẽ beyepía”, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ĩĩsãkʉ ããrĩñurã: Simón wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃rẽta “Pedro” wãĩyeyupʉ Jesús. Simón pagʉmʉ Andrés; gajirã: Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO sri_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago ããrĩñurã. Santiago, Alfeo magʉ̃ ããrĩyupʉ. Gajigʉ Simón ããrĩyupʉ. Ĩgʉ̃ celote wãĩkʉri bumʉ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Gajigʉ Judas ããrĩyupʉ. Ĩgʉ̃ Santiago magʉ̃ ããrĩyupʉ. Gajigʉ Judas Iscariote wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃ta Jesúre wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmubu ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús iri ʉ̃tãʉ̃gue ããrãdi ĩgʉ̃sã merã dijija, iri ʉ̃tãʉ̃ ããrĩdijimejãrõgue ããrĩyupʉ. Ĩgʉ̃ beyeanerã, gajirã wárã ĩgʉ̃ buerire tʉyarã merã ããrĩyupʉ. Gajirã wárã ããrĩperero Judea nikũ marã, Jerusalén marã, wádiya tʉro marã Tiro, Sidón marã ããrĩñurã. Ĩgʉ̃sã Jesús pʉro ĩgʉ̃ buerire pérã, ĩgʉ̃sã pũrĩrikʉrire taudorerã ejanerã ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesús wãtẽa ñajãsũnerãdere tauyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ĩgʉ̃ ããrĩpererãrẽ Marĩpʉ turaro merã taumakʉ̃ ĩãrã, ããrĩpererã masaka ĩgʉ̃rẽ moãñadʉañurã. ");
INSERT INTO sri_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pʉrʉ Jesús ĩgʉ̃ buerãrẽ ĩã, ãsũ ãrĩyupʉ: —Marĩpʉ mʉsã Opʉ ããrĩ́mi. Irasirirã boporã ããrĩkererã, ʉsʉyaka! ");
INSERT INTO sri_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Dapagorare mʉsã ʉaboari merã ããrĩrã́, pʉrʉguere yapirãkoa. Irasirirã ʉsʉyaka! ’Dapagorare bʉro bʉjawereri merã orerã, pʉrʉguere ʉsʉyari merã bʉrirãkoa. Irasirirã ʉsʉyaka! ");
INSERT INTO sri_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Mʉsã yʉre ããrĩpererã tĩ́gʉ̃rẽ bʉremumakʉ̃ ĩãrã, gajirã mʉsãrẽ ĩãturi doorãkuma. Mʉsãrẽ: “Gʉa merã ããrĩmerãta!” ãrĩ béorãkuma. Mʉsãrẽ ñerõ werenírãkuma. “Ñerã ããrĩ́ma”, ãrĩ werewʉarãkuma. Ĩgʉ̃sã irasũ ãrĩkeremakʉ̃, ʉsʉyari merã ããrĩrikʉka! ");
INSERT INTO sri_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Iripoegue marĩ ñekʉ̃sãmarã Marĩpʉya kerere weredupiyunerãrẽ irasũta iriunanerã ããrĩmá. Irasirirã dapagora marã mʉsãrẽ mʉrãrõta ñerõ irimakʉ̃ ĩãrã, bʉro ʉsʉyaka! Bʉro ʉsʉyari merã ããrĩrikʉka! Mʉsã ʉ̃mʉgasigue waamakʉ̃, Marĩpʉ õãrĩ wáro wajatari sĩgʉkumi mʉsãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Mʉsã i ʉ̃mʉmarẽ wári oparã gapʉ ʉsʉyari bokasiáa. Pʉrʉguere ʉsʉyari neõ bokabirikoa. Irasiriro mʉsãrẽ ñegoráa. ");
INSERT INTO sri_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Mʉsã dapagorare yapirã, pʉrʉguere bʉro ʉaboarãkoa. Ʉsʉyari neõ bokabirikoa. Irasiriro mʉsãrẽ ñegoráa. ’Dapagorare Marĩpʉyare bʉridarã, pʉrʉguere bʉro bʉjawereri merã orerãkoa. Ʉsʉyari neõ bokabirikoa. Irasiriro mʉsãrẽ ñegoráa. ");
INSERT INTO sri_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Masaka ããrĩpererã mʉsãrẽ: “Õãrã ããrĩ́ma”, ãrĩkeremakʉ̃, ʉsʉyari neõ bokabirikoa. Iripoegue mʉsã ñekʉ̃sãmarã Marĩpʉyare ãrĩkatori merã wererimasãrẽ: “Õãrã ããrĩ́ma”, ãrĩunanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Yʉ werenírĩrẽ õãrõ péduripírãnorẽ ãsũ ãrĩ weregʉra. Mʉsãrẽ ĩãturirãrẽ maĩka! Mʉsãrẽ doorãrẽ õãrõ irika! ");
INSERT INTO sri_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mʉsãrẽ: “Ñerõ waaburo”, ãrĩrãrẽta õãdoreka! Mʉsãrẽ ñerõ ãrĩ bʉridarãrẽta Marĩpʉre ĩgʉ̃sã õãrõ ããrĩburire sẽrẽbosaka! ");
INSERT INTO sri_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sugʉ masakʉ mʉsãya wayupãrãrẽ pámakʉ̃, gajipãrẽ gapʉdere pádoreka! Mʉsãya suríro wekamañerẽ ẽmamakʉ̃, mʉsãya camisadere sĩka! ");
INSERT INTO sri_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ããrĩpererã mʉsãrẽ gajino sẽrẽrãnorẽ sĩka! Sugʉ masakʉ mʉsã oparire ãĩãmakʉ̃, ĩgʉ̃rẽ: “Wiaka!” ãrĩbirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gajirã mʉsãrẽ õãrõ irimakʉ̃ gããmerõsũta mʉsãde ĩgʉ̃sãrẽ õãrõ irika! ");
INSERT INTO sri_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mʉsãrẽ maĩrã ditare maĩmakʉ̃ õãbea. Mʉsã irasũ maĩrĩ wajamáa. Gajirã, ñerã ããrĩkererã, ĩgʉ̃sãrẽ maĩrãrẽ maĩkuma. ");
INSERT INTO sri_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mʉsãrẽ õãrõ irirã ditare õãrõ irimakʉ̃ õãbea. Mʉsã irasiriri wajamáa. Ñerãde ĩgʉ̃sãrẽ õãrõ irirãrẽ õãrõ irikuma. ");
INSERT INTO sri_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Gajirãrẽ wayurã ĩgʉ̃sãrẽ: “Gʉa wayuadeare keoro wiaka doja!” ãrĩmakʉ̃ õãbea. Mʉsã irasiriri wajamáa. Ñerõ irirãde gajirã ñerãrẽ wayukuma. Ĩgʉ̃sã wayuadeare: “Ããrĩpereri wiarãkuma doja”, ãrĩ gũñakuma. ");
INSERT INTO sri_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Irasirirã ñerã irirosũ iribirikõãka! Mʉsãrẽ ĩãturirãdere maĩka! Ĩgʉ̃sãrẽ õãrõ irika! Ĩgʉ̃sãrẽ wayurã, mʉsã wayuadeare: “Wiaka doja!” ãrĩbirikõãka! Irasirirã wári õãrĩ wajatari bokarãkoa. Marĩpʉ ããrĩpererã nemorõ turagʉ pũrã ããrĩrãkoa. Masaka Marĩpʉre ʉsʉyari sĩbirikeremakʉ̃, ĩgʉ̃sãrẽ bopoñarĩ merã ĩãmi dapa. Ñerã ããrĩkeremakʉ̃, ĩgʉ̃sãrẽ irasũ ĩãmi dapa. ");
INSERT INTO sri_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Irasirirã mʉsãde Mʉsãpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ masakare bopoñarĩ merã ĩãrõsũta gajirãrẽ bopoñarĩ merã ĩãka! ");
INSERT INTO sri_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Gajirãrẽ: “Ñerã ããrĩ́ma”, ãrĩ werewʉabirikõãka! Mʉsã werewʉabirimakʉ̃ ĩãgʉ̃, Marĩpʉ mʉsãrẽ: “Ñerã ããrĩ́ma”, ãrĩ ĩãbirikumi. Gajirã mʉsãrẽ ñerõ irimakʉ̃ ĩãrã: “Marĩpʉ ĩgʉ̃sãrẽ wajamoãburo”, ãrĩbirikõãka! Mʉsã irasũ ãrĩbirimakʉ̃, Marĩpʉ mʉsãrẽ: “Wajamoãgʉra”, ãrĩbirikumi. Gajirã mʉsãrẽ ñerõ irideare kãtika! Mʉsã kãtimakʉ̃, Marĩpʉde mʉsã ñerõ irideare kãtigʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gajirãrẽ sĩka! Mʉsã sĩmakʉ̃, Marĩpʉ mʉsãrẽ wári õãrĩ sĩgʉkumi. Ajuro wári ajuro gajino ʉtʉriri ajuro õãrõ ñadiuadea ajuro irirosũ sĩgʉkumi. Mʉsã gajirãrẽ sĩderopata Marĩpʉ mʉsãrẽ sĩgʉkumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Irasũ ãrĩ odo, keori merã wereyupʉ doja: —Sugʉ masakʉ koye ĩãbi gajigʉ koye ĩãbire tʉ̃ãdupiyuwãgãmasĩbirikumi. Ĩgʉ̃sã pẽrãgueta maarẽ́ ĩãmerã gobegue meéñajãkõãkuma. ");
INSERT INTO sri_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sugʉ buerimasʉ̃ ĩgʉ̃ buerã nemorõ masĩkumi. Ĩgʉ̃ buerãde ĩgʉ̃ buederosũ buepeosĩã, ĩgʉ̃sãrẽ buedi masĩderosũta ĩgʉ̃sãde masĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Mʉsã ñerõ iridea, koyerugue wári turu oparosũ ñetariri ããrĩrĩ́rẽ gũñabirikererã, mʉsãyagʉ ñerõ iridea, koyerugue nikũyegã oparosũ ããrĩrĩ́rẽ: “Ñegoráa”, ãrĩ gũñáa. ");
INSERT INTO sri_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Irasirirã mʉsã ñerõ iridea, koyerugue wári turu oparosũ ããrĩrã́, mʉsãyagʉre ĩgʉ̃ya koyerugue ããrĩrĩ́ nikũyegãrẽ: “¿Ãĩbéosi?” ãrĩmasĩbea. Mʉsã ñerõ iririkʉrã, irikatorikʉrã ããrã. Mʉsãya koyerugue ããrĩrĩ́ turu gapʉre ãĩbéopʉroriro irirosũ mʉsã ñerõ iririre piripʉrorika! Irasiri odo, mʉsãyagʉre: “Mʉ ñerõ iririre pirikõãka!” ãrĩ masĩa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Irasũ ãrĩ odo, gaji keori merã wereyupʉ doja: —Yukʉ õãdi ñerĩ dʉkakʉbirikoa. Yukʉ ñedide õãrĩ dʉkakʉbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ããrĩpereri yukure dʉka merã ĩãmasĩsũa. Poragʉ higo wãĩkʉrire dʉkakʉbirikoa. Ñaagʉ̃de iguire dʉkakʉbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Irasirigʉ sugʉ masakʉ õãgʉ̃, yukʉ õãrĩ dʉkakʉdi irirosũ ããrĩ́mi. Ĩgʉ̃ gũñarĩgue õãrĩ gũñarĩ opasĩã, õãrĩrẽ yámi. Gajigʉ ñegʉ̃, ĩgʉ̃ gũñarĩgue ñerĩ gũñasĩã, ñerĩrẽ yámi. Marĩ gũñarĩgue gũñarõsũta werenírãkoa. Irasirirã masaka ñerĩ gũñarĩ oparã, ñerĩ werenírãkuma. Õãrĩ gũñarĩ oparã gapʉ õãrĩ werenírãkuma. ");
INSERT INTO sri_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Nasirirã mʉsã yʉre: “Yʉ Opʉ ããrã mʉ”, ãrĩkererã, yʉ dorerire neõ iriberi? ");
INSERT INTO sri_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sugʉ yʉ pʉro eja, yʉ werenírĩrẽ péduripí, pʉrʉ yʉ dorerire irigʉ, ãsũpero irigʉ irirosũ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Sugʉ ʉ̃tãyegue ʉ̃kʉ̃ãrĩ goberi máñajãa, wii õãrõ nugũdi irirosũ ããrĩ́mi. Pʉrʉ dia wáro yura, ĩgʉ̃ya wiiguere deko ũma meétúkeremakʉ̃, neõ mirũabirikoa. ");
INSERT INTO sri_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yʉ werenírĩrẽ pékeregʉ, yʉ dorerire iribi gapʉ sugʉ ĩmiparogue wii iridi irirosũ ããrĩ́mi. Dia wáro yuraro, ĩgʉ̃ya wiire ũmabéokõãkoa. Irasiriro ããrĩpereri kõmopereakõãkoa, ãrĩ wereyupʉ Jesús masakare. ");
INSERT INTO sri_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús masakare irire were odo, Capernaugue waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iroguere romano marã surara opʉ ããrĩyupʉ. Ĩgʉ̃rẽ moãboegʉ sĩrĩgʉ̃ kõmorĩ pʉrogãgue ããrĩyupʉ. Surara opʉ ĩgʉ̃rẽ bʉro maĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Irasirigʉ, Jesús iridea kerere pégʉ, judío masaka mʉrãrẽ Jesús pʉrogue iriuyupʉ, ĩgʉ̃rẽ moãboegʉre taugʉ aaridoregʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ĩgʉ̃sã Jesús pʉrogue ejarã, ĩgʉ̃rẽ turaro merã ãsũ ãrĩ sẽrẽñurã: —Surara opʉ gʉare mʉ pʉro iriuadi, õãgʉ̃ ããrĩ́mi. Irasirigʉ ĩgʉ̃rẽ iritamuka! ");
INSERT INTO sri_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ĩgʉ̃ judío masakʉ ããrĩbirikeregʉ, marĩya nikũ marãrẽ bʉro maĩmi. Ĩgʉ̃ta ĩgʉ̃ya niyeru merã gʉa nerẽrĩ wiire moãdoremi. Irasirigʉ ĩgʉ̃rẽ iritamuka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Irire pégʉ, Jesús ĩgʉ̃sã merã waayupʉ. Surara opʉ, ĩgʉ̃ya wii pʉro ĩgʉ̃sã ejawãgãrimakʉ̃ ĩãgʉ̃, ĩgʉ̃ merãmarãrẽ Jesúre ãsũ ãrĩ weredoregʉ iriuyupʉ: —Yʉ Opʉ, mʉrẽ garibonemodʉabirikoa. Yʉ ubu ããrĩgʉ̃́ ããrĩsĩã, yaa wiire mʉ ñajãrimakʉ̃, bʉro gʉyasĩrĩkoa. ");
INSERT INTO sri_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Irasirigʉ yʉde mʉ pʉrogue waabea. Mʉ werenírĩ turari merã yʉre moãboegʉre: “Sĩrĩrĩ tarika ĩgʉ̃rẽ!” ãrĩmakʉ̃ tarigʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gajirã oparã yʉre dorema. Yʉde gajirã surarare dorea. Yʉ sugʉre: “Waaka!” ãrĩmakʉ̃, waami. Gajigʉre: “Aarika!” ãrĩmakʉ̃, aarími. Yʉ, yʉre moãboegʉre: “Ire irika!” ãrĩmakʉ̃, irire yámi, ãrĩka Jesúre! ãrĩ iriuyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ĩgʉ̃ weredoreadeare ĩgʉ̃sã weremakʉ̃ pégʉ, Jesús gʉkakõãyupʉ. Ĩgʉ̃rẽ tʉyarãrẽ gãmenʉgã ĩã, ãsũ ãrĩyupʉ: —Mʉsãrẽ werea. Sĩĩ surara opʉ Israel bumʉ ããrĩbirikeregʉ, yʉre bʉremumi. Israel bumarã watopeguere sĩĩ irirosũ yʉre bʉremugʉ̃rẽ neõ bokajabiribʉ, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, surara opʉ iriuanerã ĩgʉ̃ya wiigue goedujáañurã. Irogue goedujajarã, sĩrĩgʉ̃ ããrãdire tariadiguere bokajañurã. ");
INSERT INTO sri_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pʉrʉ Jesús Capernaugue ããrãdi Naín wãĩkʉri makãgue waayupʉ. Ĩgʉ̃ buerã, gajirã masaka wárã ĩgʉ̃ merã waañurã. ");
INSERT INTO sri_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iri makãrẽ ejaripoe iri makã marã, sugʉ masakʉ boadire kõãwãgãriñurã ĩgʉ̃rẽ yáarã waarã́. Ĩgʉ̃ wapiweyo magʉ̃, sugʉ ããrĩgʉ̃́ ããrãdiyupʉ. Ĩgʉ̃ pago ĩgʉ̃rẽ yáamurã merã waamakʉ̃, wárã masaka wapikʉwãgãriñurã. ");
INSERT INTO sri_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Igore ĩãgʉ̃, marĩ Opʉ Jesús bʉro bopoñarĩ merã ĩã, ãsũ ãrĩyupʉ: —Orebirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Irasirigʉ Jesús masãpore pʉro ejanʉgã, moãñayupʉ. Ĩgʉ̃ moãñamakʉ̃ ĩãrã, iri porere kõãrã dujanʉgãñurã. Jesús boadire ãsũ ãrĩyupʉ: —Yʉ mʉrẽ ãrã: “Wãgãnʉgãka!” ");
INSERT INTO sri_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ĩgʉ̃ irasũ ãrĩmakʉ̃, boadi wãgãdoa, werenínʉgãyupʉ. Irasirigʉ Jesús ĩgʉ̃rẽ pagore wiayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Irire ĩãrã, ããrĩpererã masaka ĩãgʉkakõãñurã. Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩñurã. Ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníñurã: —Ĩĩ Marĩpʉya kerere wererimasʉ̃, turatarigʉ, marĩ watopeguere ejami. Idere ãrĩñurã: —Marĩpʉ ĩĩrẽ iriuñumi ĩgʉ̃yarãrẽ iritamudoregʉ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Irasirirã ããrĩpererogue Judea nikũ marã, iri nikũ tʉro marãde Jesús ĩgʉ̃rẽ masũdea kerere pépereakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan masakare wãĩyerimasʉ̃ peresugue ããrĩripoe ĩgʉ̃ buerire tʉyarã ããrĩpereri Jesús irideare ĩgʉ̃rẽ wererã waañurã. Juan irire pégʉ, ĩgʉ̃sã merãmarã pẽrãrẽ siiu: ");
INSERT INTO sri_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","—Jesúre ãsũ ãrĩ sẽrẽñarã waaka! “¿Mʉta ããrĩ́rĩ Cristo gʉare taugʉ aaribu iriayupʉ, ĩgʉ̃sã ãrĩdi, o gajigʉre yúrãkuri gʉa?” ãrĩ sẽrẽñarã waaka! ãrĩ iriuyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Irasirirã, Jesús pʉro ejarã, ĩgʉ̃rẽ ãrĩñurã: —Juan masakare wãĩyerimasʉ̃ gʉare mʉrẽ ãsũ ãrĩ sẽrẽñadoreami: “¿Mʉta ããrĩ́rĩ Cristo gʉare taugʉ aaribu iriayupʉ, ĩgʉ̃sã ãrĩdi, o gajigʉre yúrãkuri gʉa?” ");
INSERT INTO sri_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ĩgʉ̃sã ejaripoere Jesús wárã pũrĩrikʉrãrẽ, wãtẽa ñajãsũnerãrẽ, koye ĩãmerãdere taugʉ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Irasirigʉ Jesús ãsũ ãrĩ yʉjʉyupʉ Juan iriuanerãrẽ: —Mʉsã ĩãrĩrẽ, mʉsã périre, Juãrẽ wererã waaka! Koye ĩãbiranerã õãrõ ĩãma. Waamasĩbiranerã waamasĩakõãma. Kãmi boanerã yaripereakõãsũama. Gãmipũ pébiranerã péakõãma. Boanerãde masãkõãma. Boporã, Marĩpʉ masakare tauri kerere weremakʉ̃ péma. ");
INSERT INTO sri_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“Yʉre bʉremurĩrẽ piribi, ʉsʉyari opagʉkumi”, ãrĩ wererã waaka Juãrẽ! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ĩgʉ̃sã waadero pʉrʉ, Jesús Juãyamarẽ masakare ãsũ ãrĩ werenʉgãyupʉ: —Mʉsã masaka marĩrõgue Juãrẽ ĩãrã waarã́, güigʉre gũñaturabire ĩãrã waarã́ meta irikuyo. Ĩgʉ̃ turabi, mirũ táborere wẽjãpubéorosũ ããrĩbemi. ");
INSERT INTO sri_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Irasũ ããrĩmakʉ̃, mʉsã ĩgʉ̃rẽ irogue ĩãrã waarã́, õãrĩ surí sãñagʉ̃rẽ ĩãrã waarã́ meta irikuyo. Õãrĩ surí sãñarãno oparãya wiirigue ããrĩkuma. Juan ĩgʉ̃sã irirosũ ããrĩbemi. ");
INSERT INTO sri_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mʉsã irogue ĩgʉ̃rẽ ĩãrã waarã́, Marĩpʉya kerere weredupiyurimasʉ̃rẽ ĩãrã waarã́ iriyo. Mʉsãrẽ werea. Juan diayeta Marĩpʉya kerere weredupiyunerã nemorõ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Marĩpʉya werenírĩ gojadea pũgue gojasũdero ããrĩbʉ́ Juan iriburire. Irasirigʉ Marĩpʉ ĩgʉ̃ magʉ̃rẽ ãsũ ãrĩdi ããrĩmí: Mʉ waaburo dupiyuro yaa kerere weredupiyubure iriugʉra, mʉ waaburore ãmuyudoregʉ, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Mʉsãrẽ werea. Juan aariburi dupiyuro neõ sugʉ ĩgʉ̃ nemorõ yaamarẽ masĩgʉ̃ marĩdi ããrĩmí. Irasũ ããrĩkerepʉrʉ, sugʉ Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́yagʉ gapʉ Juan nemorõ yaamarẽ masĩgʉ̃ ããrĩgʉkumi. Ããrĩpererã nemorõ ubu ããrĩgʉ̃́ ããrĩkeregʉ, masĩgʉ̃ ããrĩgʉkumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ĩgʉ̃ irasũ ãrĩrĩrẽ pérã, ããrĩpererã masaka, romano marã opʉre niyeru wajaseabosarimasãde Juan wãĩyesũnerã ããrĩsĩã: “Marĩpʉ diayeta irigʉ ããrĩ́mi”, ãrĩ masĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo bumarã, Moisés gojadeare buerimasã gapʉ Juãrẽ wãĩyedorebirinerã ããrĩsĩã, Marĩpʉ ĩgʉ̃sãrẽ iridʉarire gããmebiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Irasirigʉ marĩ Opʉ Jesús ãsũ ãrĩnemoyupʉ: —Masaka dapagora marã, ¿ñeémarãno irirosũ ããrĩ́rĩ? ");
INSERT INTO sri_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Majĩrã makã dekogue ĩgʉ̃sã merãmarã merã bira gaguiní doanírã irirosũ ããrĩ́ma. Ãsũ ãrĩ gaguiníma: “Gʉa tẽrẽdiru purimakʉ̃, bayabirabʉ. Bʉjawereri merã gʉa bayamakʉ̃, orebirabʉ”, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan masakare wãĩyerimasʉ̃ pã́ baabirimakʉ̃, igui deko pãmudeare iiríbirimakʉ̃ ĩãrã, ĩgʉ̃rẽ: “Wãtĩ ñajãsũdi ããrĩ́mi ĩĩ”, ãrĩbʉ mʉsã. ");
INSERT INTO sri_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pʉrʉ yʉ ããrĩpererã tĩ́gʉ̃ baa, iirímakʉ̃ ĩãrã: “Baapagʉ, iirípagʉ ããrĩ́mi”, ãrĩbʉ. “Romano marã opʉre niyeru wajaseabosarimasã merãmʉ, ñerõ irirã merãmʉ ããrĩ́mi”, ãrĩbʉ mʉsã yʉre. ");
INSERT INTO sri_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mʉsã yaamarẽ, Juãyamarẽ masĩbirikeremakʉ̃, gʉare masĩrã gapʉ: “Diayeta Marĩpʉ iriunerã ããrĩ́ma”, ãrĩ masĩma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, sugʉ fariseo bumʉ Jesúre ĩgʉ̃ya wiigue baadoregʉ siiuayupʉ. Irasirigʉ Jesús ĩgʉ̃ya wiigue waa, eja, baari peoro pʉro eja, doayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sugo nomeõ iri makãmo, ñerõ iririmasõ, Jesús fariseoya wiigue baagʉ ejadea kerere pé, irogue waayupo. Suru borewariru “alabastro” wãĩkʉri ʉ̃tãye merã iridirure õãrõ sʉ̃rõrĩ opadirure ãĩayupo. ");
INSERT INTO sri_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ãĩa, Jesús pʉrʉpʉ gapʉ ejanʉgãja, igo ñerõ irideare bʉro bʉjawereri merã gũña, ore, Jesús pʉro meédoaja, ĩgʉ̃ya guburi wekare igoya kódeko meébejamakʉ̃ ĩã, igoya poañapu merã túkoe bojoyupo. Túkoe bojo, bʉremurĩ merã ĩgʉ̃ya guburire mimi, igo sʉ̃rõrĩ ãĩadea merã ĩgʉ̃ya guburire pípeoyupo. ");
INSERT INTO sri_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Igo irasirimakʉ̃ ĩãgʉ̃, fariseo bumʉ Jesúre baadoregʉ siiuadi ĩgʉ̃ basi gũñayupʉ: “Igo ĩgʉ̃ya guburire moãñagõ ñerõ iririmasõ ããrĩ́mo. Ĩĩ diayeta Marĩpʉya kerere weregʉ ããrĩgʉ̃́, irire masĩsiabukumi”, ãrĩ gũñayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús ĩgʉ̃ gũñarĩrẽ ĩãmasĩ, ĩgʉ̃rẽ ãrĩyupʉ: —Simón, yʉ mʉrẽ gajino weredʉakoa, ãrĩyupʉ. —Buegʉ, wereka yʉre! ãrĩyupʉ Simón. ");
INSERT INTO sri_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús i keori merã wereyupʉ ĩgʉ̃rẽ: —Sugʉ masakare niyeru wayurimasʉ̃ ããrĩkumi. Pẽrã ʉ̃ma wajamokuma ĩgʉ̃rẽ. Sugʉ wári niyeru koeri quinientos moãrĩnʉrĩ wajataropa wajamokumi. Gajigʉ mérĩ koerigã cincuenta moãrĩnʉrĩ wajataropa wajamokumi. ");
INSERT INTO sri_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ĩgʉ̃sã pẽrã, ĩgʉ̃sã wajamorĩrẽ wajariri opabirimakʉ̃ ĩãgʉ̃, niyeru wayudi ĩgʉ̃sãrẽ pẽrãguereta: “Iropata, mʉsã wajamorĩ pereburo. Irire kãtigʉkoa”, ãrĩkumi. Irasirimakʉ̃, ¿nií gapʉ niyeru wayudire bʉro maĩkuri? wáro wajamodi, o mérõgã wajamodi gapʉ, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón yʉjʉyupʉ: —Wáro wajamodi gapʉ bʉro maĩbukumi, ãrĩyupʉ. —Diayeta yʉjʉa mʉ, ãrĩyupʉ Jesús ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Irasũ ãrĩ odo, Jesús nomeõrẽ ĩã, Simṍrẽ ãrĩyupʉ: —¿Igo yʉre iriadeare ĩãrĩ mʉ? Mʉya wiigue yʉ ñajãjamakʉ̃, mʉ yʉre yaa guburi koeburire deko sĩbirabʉ. Igo gapʉ yaa guburire igoya kódeko merã koe, igoya poañapu merã túkoe bojoamo. ");
INSERT INTO sri_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yʉ õãdoremakʉ̃, mʉ yʉre bokatĩrĩ pábʉa, mimibirabʉ. Igo gapʉ yʉ ñajãjadero pʉrʉgue yaa guburire mimiadeo neõ mimiduúbemo. ");
INSERT INTO sri_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mʉ gapʉ yaa dipurure ʉye õãrĩ sʉ̃rõrĩ merã pípeobirabʉ. Igo gapʉ yaa guburire sʉ̃rõrĩ pípeoamo. ");
INSERT INTO sri_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Irasirigʉ Simón, yʉ mʉrẽ werea. Igo ñerõ iridea wári ããrĩkeremakʉ̃, yʉ irire kãtia. Yʉ irasirimakʉ̃, yʉre bʉro maĩmo. Gajigʉ gapʉ, yʉ ĩgʉ̃ ñerõ irideare kãtimakʉ̃: “Yʉ mérõgãta ñerõ irideare opáa”, ãrĩ gũñasĩã, yʉre sĩrũta maĩmi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ĩgʉ̃rẽ irasũ ãrĩ odo, nomeõrẽ ãsũ ãrĩyupʉ: —Mʉ ñerõ irideare kãtia yʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gajirã masaka iri wiigue ĩgʉ̃ merã baadoregʉ siiuanerã ãsũ ãrĩ gãme wereníñurã: —¿Ñeémʉno masakʉ ããrĩ́rĩ ĩĩ, irasũ ñerõ irideare kãtigʉ? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús gapʉ nomeõrẽ ãrĩyupʉ doja: —Yʉre bʉremusĩã, perebiri peamegue waabodeo tausũsiáa. Irasirigo õãrõ siñajãrĩ merã waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pʉrʉ Jesús paga makãrĩ marãrẽ, mʉtã makãrĩgã marãdere Marĩpʉ ĩgʉ̃yarãrẽ doreri kerere weregorenagʉ̃ waayupʉ. Ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarã ĩgʉ̃ merã waañurã. ");
INSERT INTO sri_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nomede ĩgʉ̃ merã waañurã. Pũrĩrikʉrã ããrĩnerã Jesús taunerã nome ããrĩñurã. Gajirã nome, wãtẽa ñajãnerãrẽ Jesús béowiusũnerã ããrĩñurã. Sugo María Magdalena wãĩkʉgo ããrĩyupo. Igo su mojõma pere gaji mojõ peru pẽrẽbejarã wãtẽãrẽ Jesús béowiusũdeo ããrĩyupo. ");
INSERT INTO sri_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Gajigo Juana wãĩkʉgo, Cuza wãĩkʉgʉ marãpo ããrĩyupo. Cuza Herodeya wiigue moãboerimasã opʉ ããrĩyupʉ. Gajigo Susana wãĩkʉgo ããrĩyupo. Gajirã nomede wárã Jesús merã waañurã ĩgʉ̃ buerire pédʉarã. Ĩgʉ̃sã nome, ĩgʉ̃sã opari merã Jesúre, ĩgʉ̃ buerãdere iritamuñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wárã masaka wári makãrĩ marã Jesús pʉro ĩgʉ̃rẽ ĩãdʉarã nerẽñurã. Ĩgʉ̃sã wárã nerẽmakʉ̃, Jesús i keori merã ãsũ ãrĩ bueyupʉ ĩgʉ̃sãrẽ: ");
INSERT INTO sri_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Sugʉ oterimasʉ̃ ĩgʉ̃ya oteri yerire meésirigʉ waakumi. Ĩgʉ̃ meésiriwãgãmakʉ̃, gaji yeri maague yurikoa. Masaka iri maague waarã́, iro yuriadea yerire kʉramutũkõãkuma. Mirãde iri yerire boka, baapeokõãkuma. ");
INSERT INTO sri_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gaji yeri ʉ̃tãyerikʉrogue yurikoa. Iri yeri puriadikoa. Puriadi, deko marĩmakʉ̃ ñaĩ, boakõãkoa. ");
INSERT INTO sri_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gaji yeri pora watopegue yurikoa. Pora gapʉ puritarimʉrĩa, oteri gapʉre wẽjẽkõãkoa. ");
INSERT INTO sri_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gaji yeri õãrĩ nikũgue yurikoa. Iri yeri õãrõ puri, wári dʉkakʉkoa. Su dupañu cien yerigora dʉkakʉkoa, ãrĩyupʉ. Iri keori merã were odo, ĩgʉ̃sãrẽ turaro merã ãsũ ãrĩyupʉ doja: —Mʉsã gãmipũrĩ oparã, yʉ wererire péduripíka! ãrĩyupʉ Jesús masakare. ");
INSERT INTO sri_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pʉrʉ ĩgʉ̃ buerã ĩgʉ̃rẽ sẽrẽñañurã: —¿Naásũ ãrĩdʉaro iriari, gʉare mʉ wereadea? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Marĩpʉ ĩgʉ̃yarãrẽ doregʉ ããrĩrĩ́rẽ iripoegue masĩbirideare dapagorare mʉsãrẽ masĩmakʉ̃ yámi. Gajirã gapʉre keori merã dita buea. Irasirirã ĩgʉ̃sã Marĩpʉ iririre ĩãkererã, ĩãmasĩbirikuma. Ĩgʉ̃yare pékererã, pémasĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Yʉ iri keori merã bueadea ãsũ ãrĩdʉaro yáa. Iri oteri yeri Marĩpʉya werenírĩ irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Surãyeri masaka Marĩpʉya werenírĩrẽ pékererã, pémasĩbema. Maa bʉriri maa irirosũ ããrĩ́ma. Ĩgʉ̃ya werenírĩrẽ péadero pʉrʉ, oteri yeri iri maague yuridea yerire mirã baapeoderosũ, wãtĩ ĩgʉ̃sã gũñarĩgue eja, ĩgʉ̃sã péadideare ẽmapeokõãmi. Ĩgʉ̃sã Marĩpʉre bʉremubiri, tausũbirikõãburo, ãrĩgʉ̃, irasũ yámi. ");
INSERT INTO sri_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Gajirã masaka ʉ̃tãyerikʉri yeba irirosũ ããrĩ́ma. Ĩgʉ̃sã Marĩpʉya werenírĩrẽ ʉsʉyari merã pékeremakʉ̃, oteri yeri ʉ̃tãyerikʉrogue yuriadero pʉrʉ, nugũrĩ marĩderosũ ĩgʉ̃sãrẽ waáa. Irasirirã yoaweyaripoe bʉremuadima. Pʉrʉ Marĩpʉyare iridʉari waja gajirã ĩgʉ̃sãrẽ ñerõ irimakʉ̃ ĩãrã, mata ĩgʉ̃yare pirikõãma. ");
INSERT INTO sri_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Gajirã masaka porakʉri yeba irirosũ ããrĩ́ma. Marĩpʉya werenírĩrẽ pékererã, oteri yeri porakʉrogue yuriadero pʉrʉ, pora gapʉ puritarimʉrĩa, wẽjẽderosũ, i ʉ̃mʉmarẽ bʉro gũñarikʉma. Irasirirã wári oparire gũñataria, ĩgʉ̃sã gããmerõ iridʉasĩã, Marĩpʉya werenírĩrẽ kãtima. ");
INSERT INTO sri_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Gajirã masaka õãrĩ nikũ irirosũ ããrĩ́ma. Irasirirã Marĩpʉya werenírĩrẽ õãrõ pérã, péduripíma. Õãrĩ gũñarĩrẽ oparã, Marĩpʉyare iridʉarã ããrĩ́ma. Gajirã ĩgʉ̃sãrẽ ñerõ irikeremakʉ̃, ĩgʉ̃yare piribema. Wári õãrĩ dʉkakʉdiñu irirosũ ããrĩ́ma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pʉrʉ gaji keori merã bueyupʉ doja: —Masaka sĩãgodirure sĩãgorã, kõmesoro merã muúpíbirikuma. Kãrĩrõ dokaguedere dobobirikuma. Ʉ̃marõ, wii dekogue siukuma. Irasirirã gajirã iri wiire ñajãrã, sĩãgodiru ʉ̃jʉ̃gorore õãrõ ĩã, ñajãkuma. ");
INSERT INTO sri_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ããrĩpereri masaka iripoegue masĩbirideare masĩsũrokoa. Masaka ĩãberogue duripídeare sĩãgoro ããrĩrṍgue ĩãmasĩrõ irirosũ masĩsũrokoa. Yayedea irirosũ neõ ããrĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Irasirirã Marĩpʉya werenírĩrẽ pérã, õãrõ pémasĩka! Irire õãrõ péduripígʉnorẽ Marĩpʉ wári pémasĩrĩ sĩnemogʉkumi. Gajigʉ õãrõ pébirikeregʉ: “Masĩa yʉ”, ãrĩ gũñami. Ĩgʉ̃ irasũ ãrĩ gũñakeregʉ, õãrõ pémasĩbemi. Ĩgʉ̃ pémasĩadideare ẽmasũgʉkumi. Irasirigʉ neõ pémasĩbi dujagʉkumi pama, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pʉrʉ Jesús pago, ĩgʉ̃ pagʉpũrã merã ĩgʉ̃rẽ ĩãgõ ejayupo. Masaka wárã ĩgʉ̃ pʉrogue ããrĩmakʉ̃, ejamasĩbiriyupo. ");
INSERT INTO sri_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Irasirigʉ sugʉ irogue ããrĩgʉ̃́ Jesúre wereyupʉ: —Mʉpo, mʉ pagʉpũrã merã mʉrẽ ĩãdʉarã, masaka pʉrʉpʉgue níama, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ãsũ ãrĩ yʉjʉyupʉ: —Marĩpʉya werenírĩrẽ õãrõ péduripírã, ĩgʉ̃yare õãrõ iritʉyarã, yʉpo, yʉ pagʉpũrã irirosũ ããrĩ́ma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sunʉ Jesús ditaru tʉrogue ããrĩgʉ̃́, ĩgʉ̃ buerã merã doódirugue mʉrĩñajãa, ĩgʉ̃sãrẽ: —Náka, ditaru sipãrẽgue taribujarã! ãrĩyupʉ. —Jáʉ, ãrĩ, waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iro taribujagʉ, Jesús kãrĩñajãkõãyupʉ. Pʉrʉ ditaruguere bʉro mirũ waayuro. Doódiruguere makũrĩ páñajãa, miũkõãdiyuro. Bʉro goero waayuro ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Irasũ waamakʉ̃ ĩãrã, Jesúre yobeñurã: —Gʉare buegʉ, marĩ mirĩmurã yáa, ãrĩ gaguiníñurã. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús yobe, mirũ, makũrĩrẽ toedoreyupʉ. Ĩgʉ̃ toedoremakʉ̃, mirũ, makũrĩ bʉro waadea toedijapereakõãyuro. ");
INSERT INTO sri_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pʉrʉ ĩgʉ̃ buerãrẽ ãrĩyupʉ: —¿Mʉsã yʉre bʉremurĩ opaberi? Ĩgʉ̃sã gapʉ gʉkanerã ããrĩsĩã, ĩãgʉka, ĩgʉ̃sã basi gãme sẽrẽñañurã: —¿Ñeémʉno masakʉ ããrĩ́rĩ ĩĩ? Ĩgʉ̃ mirũrẽ, makũrĩrẽ toedoremakʉ̃ toedijakõãa, neõ tarinʉgãbea ĩgʉ̃rẽ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pʉrʉ Galilea nikũ bokatĩũrõ, Gadara wãĩkʉrogue taribujajañurã. ");
INSERT INTO sri_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús doódirugue ããrãdi majãnʉgãmakʉ̃, sugʉ masakʉ iri makãmʉ ĩgʉ̃ pʉro ejanʉgãyupʉ. Ĩgʉ̃ wãtẽa ñajãsũdero pʉrʉ yoakõãyuro. Neõ surí sãñabi, wiiguere ããrĩbi, masãgoberi watopegue dita ããrĩgʉ̃́ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Wãtĩ masakʉre wári ñeã meémejãnayupʉ. Irasirirã masaka ĩgʉ̃rẽ ñeã, ĩgʉ̃ya mojõrĩrẽ, guburidere kõmedari merã sʉanadiñurã ĩgʉ̃rẽ biadobomurã. Ĩgʉ̃ gapʉ ĩgʉ̃sã sʉarikʉ, tʉ̃ãtanokõãyupʉ. Irasirigʉ wãtĩ ĩgʉ̃rẽ masaka marĩrõgue waamakʉ̃ irinayupʉ. Jesús wãtĩrẽ: “Wirika mʉ ñajãdire!” ãrĩyupʉ. Masakʉ Jesúre ĩãgʉ̃, ĩgʉ̃ pʉro ñadʉkʉpuri merã ejamejã, bʉro gaguiníyupʉ: —Jesús, ʉ̃mʉgasigue marã Opʉ ããrĩpererã nemorõ turagʉ magʉ̃, ¿nasiribu yári mʉ yʉre? “Yʉre poyarikʉmakʉ̃ iribirikõãka!” ãrĩ, bʉro sẽrẽa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús ĩgʉ̃rẽ sẽrẽñayupʉ: —¿Ñeémʉ wãĩkʉri mʉ? ãrĩyupʉ. —“Legión” wãĩkʉa yʉ, ãrĩ yʉjʉyupʉ. “Legión”, ãrĩrõ: “wárã”, ãrĩdʉaro yáa. Wárã wãtẽa ñajasũdi ããrĩsĩã, irasũ wãĩkʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wãtẽa masakʉguere ñajãnerã Jesúre: —Gʉare bʉro ʉ̃kʉ̃ãrĩ gobegue waadorebirikõãka! ãrĩ sẽrẽñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iro ʉ̃tãʉ̃gue wárã yesea ãma baarã iriñurã. Ĩgʉ̃sãrẽ ĩãrã, wãtẽa Jesúre sẽrẽñurã: —Yeseaguere gʉare ñajãdoreka! —Jáʉ, ĩgʉ̃sãguereta ñajãrã waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ĩgʉ̃ irasũ ãrĩmakʉ̃, wãtẽa masakʉguere ããrãnerã wirirã, yeseaguere ñajãñurã. Ĩgʉ̃sã ñajãmakʉ̃, yesea ũma mirẽbuáa, ditarugue meébia dijáa, mirĩ boapereakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Irasũ waamakʉ̃ ĩãrã, yeseare korerimasã gʉkari merã ũmadujáa, ĩgʉ̃sãya makã marãrẽ, iri makã tʉro marãdere wererã waañurã. ");
INSERT INTO sri_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Irire pérã: “¿Naásũ waáayuri?” ãrĩ, Jesús pʉro ĩãrã waañurã. Irogue eja, wãtẽa béowiusũadire bokajañurã. Jesús pʉro, suríro sãñadi, õãrõ pémasĩrĩ merã doayupʉ. Masaka ĩgʉ̃rẽ ĩãrã, bʉro güiri merã ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wãtẽãrẽ béowiumakʉ̃ ĩãnerã irogue ejarãrẽ irire wereñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Irire pérã, ããrĩpererã Gadara nikũ marã bʉro güisĩã, Jesúre: “Waaka õõrẽ!” ãrĩñurã. Ĩgʉ̃sã waadoremakʉ̃ pégʉ, Jesús doódirugue mʉrĩñajãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ĩgʉ̃ mʉrĩñajãmakʉ̃ ĩãgʉ̃, wãtẽa béowiusũadi Jesúre: —Yʉde mʉ merã waadʉakoa, ãrĩ sẽrẽadiyupʉ. Jesús gapʉ ĩgʉ̃rẽ ãrĩyupʉ: —Yʉ merã waabirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Mʉya wiigue goedujáaka! Ããrĩpereri Marĩpʉ mʉrẽ õãrĩ iriadeare weregʉ waaka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ya makãgue waakõãyupʉ. Irogue eja, Jesús ĩgʉ̃rẽ õãrĩ iriadeare ããrĩpererã ĩgʉ̃ya makã marãrẽ wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús Gadara nikũgue ããrĩripoe wárã masaka Galilea nikũgue ĩgʉ̃rẽ yúrã iriñurã. Irasirirã, ĩgʉ̃ taribujajamakʉ̃ ĩãrã, bʉro ʉsʉyari merã bokatĩrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iripoere sugʉ judío masaka nerẽrĩ wii opʉ Jairo wãĩkʉgʉ Jesús pʉrogue ejayupʉ. Eja, Jesúya guburi pʉro ñadʉkʉpuri merã ejamejãja, ĩgʉ̃rẽ: “Yaa wiigue waaka!” ãrĩ, bʉro sẽrẽyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ĩgʉ̃ magõ bʉro sĩrĩgõ kõmorĩ pʉrogãgue ããrĩyupo. Igo sugota ããrĩyupo. Pe mojõma pere su gubu peru pẽrẽbejari bojori opayupo. Jesús Jairoya wiigue waamakʉ̃, wárã masaka ĩgʉ̃rẽ kʉ̃ñarõgã tuuyañurã. ");
INSERT INTO sri_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ĩgʉ̃sã watopegue sugo nomeõ pe mojõma pere su gubu peru pẽrẽbejari bojorigora dí wiriri merã pũrĩrikʉgo ããrĩyupo. Irasirigo igo opadea niyerure kúririmasãrẽ wajari peremejãkõãyupo. Ĩgʉ̃sã kúrikeremakʉ̃ta, igo pũrĩrikʉri neõ taribiriyuro. ");
INSERT INTO sri_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesús iro waamakʉ̃ ĩãgõ, ĩgʉ̃ pʉrʉpʉ gapʉ waa ejanʉgã, ĩgʉ̃ya suríro yuware moãñayupo. Igo moãñamakʉ̃ta, igo dí wiririadea tariakõãyuro. ");
INSERT INTO sri_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Irasirigʉ Jesús sẽrẽñayupʉ: —¿Noã yʉre moãñarĩ? ãrĩyupʉ. Ããrĩpererã: “Gʉa neõ moãñabea”, ãrĩñurã. Pedro, ĩgʉ̃ merãmarã merã: —Gʉare buegʉ, ¿nasirigʉ irasũ ãrĩ sẽrẽñarĩ? Masaka wárã kʉ̃ñarõgã tuuyama mʉrẽ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús gapʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —Sugo nomeõ moãñañumo yʉre. Igo moãñamakʉ̃, yʉ turari merã igo pũrĩrikʉrire tauayo. Irire masĩa yʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo: “Yʉ iriadeare masĩmi”, ãrĩ gũña, bʉro güi naradari merã ĩgʉ̃ guburi pʉro ñadʉkʉpuri merã ejamejãja, ããrĩpererã péuro Jesúre: “Yʉ mʉya surírore moãñamakʉ̃ta yʉ pũrĩrikʉadea tariakõãbʉ”, ãrĩ wereyupo. ");
INSERT INTO sri_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús igore ãrĩyupʉ: —Mʉ yʉre bʉremurĩ opáa. Irasirigo mʉ pũrĩrikʉrire tausũa. Ʉsʉyari merã waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús irasũ ãrĩripoe sugʉ masakʉ Jairoya wii ããrãdi ejayupʉ, Jairore weregʉ ejagʉ: —Mʉ magõ kõmoakõãmo. Marĩrẽ buegʉre garibonemobirikõãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús Jairore ãsũ ãrĩyupʉ: —Güibirikõãka! Bʉremurĩ opaka yʉre! Mʉ magõ tarigokumo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Irasirigʉ Jairoya wiigue eja, gajirãrẽ ñajãdorebiriyupʉ. Pedrore, Juãrẽ, ĩgʉ̃ tĩ́gʉ̃ Santiagore, boadeo pagʉsãmarã ditare siiu ñajãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ĩgʉ̃sã ñajãjaripoere ããrĩpererã iri wiigue ããrĩrã́ bʉro orerã iriñurã. Jesús ãrĩyupʉ ĩgʉ̃sãrẽ: —Orebirikõãka! Majĩgõ boabemo. Kãrĩgõ yámo. ");
INSERT INTO sri_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, oreanerã gapʉ ĩgʉ̃rẽ bʉriñurã. “Igo boadeare masĩa gʉa”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús gapʉ boadeo pʉro ejanʉgã, igoya mojõrẽ ñeã, turaro merã igore ãsũ ãrĩyupʉ: —Majĩgõ, wãgãnʉgãka! ");
INSERT INTO sri_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ĩgʉ̃ irasũ ãrĩmakʉ̃, igoya yʉjʉpũrã goeyuro. Irasirigo mata wãgãdoakõãyupo. Jesús igo pagʉsãmarãrẽ: “Baari ejoka igore!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Igo okamakʉ̃ ĩãrã, igo pagʉsãmarã gʉkatariakõãñurã. Jesús igore ĩgʉ̃ masũadeare gajirãrẽ weredorebiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pʉrʉ Jesús ĩgʉ̃ buerãrẽ pe mojõma pere su gubu peru pẽrẽbejarãrẽ siiu neeõ, ĩgʉ̃ turarire sĩyupʉ: “Iri turari merã ããrĩpererã wãtẽãrẽ béowiumasĩrãkoa. Pũrĩrĩdere taumasĩrãkoa”, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Irasirigʉ ĩgʉ̃sãrẽ Marĩpʉ ĩgʉ̃yarãrẽ doreri kerere weredoregʉ, pũrĩrikʉrãdere taudoregʉ ãsũ ãrĩ iriuyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","—Waarã́, gajinorẽ neõ ãĩabirikõãka! Mʉsã tuadire, ajuro, baari, niyeru, gaji surí mʉsã gorawayuburidere ãĩabirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Makã ejarã, mʉsã ejadea wiita ããrĩkõãka! Iri makãrẽ waarã́gue iri wiire wirika! ");
INSERT INTO sri_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gaji makã marã masaka mʉsãrẽ gããmebirimakʉ̃, iri makãrẽ diayeta tariakõãka! Irasũ tariarã, nikũwera mʉsãya guburigue tuadeare mojẽbéokõãka! Ĩgʉ̃sã mʉsãrẽ gããmebiri waja Marĩpʉ ĩgʉ̃sãrẽ wajamoãburire masĩburo, ãrĩrã, irasirika! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ĩgʉ̃ irasũ ãrĩ odoadero pʉrʉ, waakõãñurã. Irasirirã ããrĩpereri makãrĩgue Marĩpʉ masakare tauri kerere weregorenarã, pũrĩrikʉrãdere taugorenarã waañurã. ");
INSERT INTO sri_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Iripoere Galilea nikũ marã opʉ Herodes ããrĩpereri Jesús iriri kerere péyupʉ. Gajirã Jesúre masĩmerã: “Ĩgʉ̃, Juan masakare wãĩyerimasʉ̃ta boadigue masãdi ããrĩkumi”, ãrĩñurã. Herodes gapʉ irire pégʉ: “¿Nasiriro irasũ waáari?” ãrĩ, bʉro gũñarikʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gajirã: “Elías iripoegue ããrĩunadi deyoakumi”, ãrĩñurã. Gajirã: “Sugʉ Marĩpʉya kerere weredupiyudi iripoegue ããrĩunadi masãkumi”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes gapʉ ãsũ ãrĩyupʉ: “Yʉta Juãrẽ ĩgʉ̃ya dipurure dititádorebʉ. ¿Niíno gapʉ ããrĩbukuri iropa wári werenísũgʉ̃?” ãrĩyupʉ. Irasirigʉ Jesúre bʉro ĩãdʉadiyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús ĩgʉ̃ buerã buedoregʉ iriunerã goedujajarã, ĩgʉ̃sã irideare werepeokõãñurã ĩgʉ̃rẽ. Pʉrʉ Jesús ĩgʉ̃sãrẽ masaka marĩrõgue Betsaida wãĩkʉri makã tʉrogue siiuayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ĩgʉ̃sã irogue waarí kerere pérã, wárã masaka Jesúre tʉyañurã. Jesús ĩgʉ̃sãrẽ õãdore, Marĩpʉ ĩgʉ̃yarãrẽ doreri kerere wereyupʉ. Pũrĩrikʉrã ĩgʉ̃rẽ taudorerãrẽ tauyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ñamika ããrĩmakʉ̃, Jesús buerã pe mojõma pere su gubu peru pẽrẽbejarã ĩgʉ̃ pʉro eja, ĩgʉ̃rẽ ãrĩñurã: —Masakare waadoreka! Õõ pʉro ããrĩrĩ́ makãrĩma wiirigue ĩgʉ̃sã kãrĩrĩ, baari ãmarã́ waaburo. Õõ marĩ ããrĩrṍguere neõ gajino máa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús gapʉ ãrĩyupʉ: —Mʉsã ĩgʉ̃sãrẽ baari sĩka! Ĩgʉ̃sã yʉjʉñurã: —Gʉa pã́ duparu su mojõma duparuta, waaídere pẽrãta opáa. Mérõgã baari ããrã. Masaka gapʉ wárãgora ããrĩ́ma. Irasirirã gʉa gaji baari wajarirã waamerã ĩgʉ̃sãrẽ ejobirikoa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wárã masaka ããrĩñurã ĩgʉ̃sã merã. Ʉ̃ma ditare keomakʉ̃, cinco mil ããrĩñurã. Irasirigʉ Jesús ĩgʉ̃ buerãrẽ ãrĩyupʉ: —Masaka ããrĩpererãrẽ boje yebori cincuenta dita dʉkawa, ĩgʉ̃sãrẽ doadoreka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Irasirirã ĩgʉ̃ buerã ĩgʉ̃ ãrĩrõsũta ããrĩpererã masakare doadoreñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Masaka doaperemakʉ̃, Jesús su mojõma pã́ duparure, pẽrã waairé ãĩ, ʉ̃mʉgasigue ĩãmu, Marĩpʉre ʉsʉyari sĩ, irire peayupʉ. Pea, ĩgʉ̃ buerãrẽ masakare gueredoregʉ sĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Irasirirã ããrĩpererã masaka irire baayapiakõãñurã. Pʉrʉ ĩgʉ̃sã baadʉáadeare Jesús buerã pe mojõma pere su gubu peru pẽrẽbejari puuirigora seasã ʉtʉudoboñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gajinʉ Jesús ĩgʉ̃ sugʉta Marĩpʉre sẽrẽgʉ̃ iriyupʉ. Ĩgʉ̃ buerã ĩgʉ̃ merã ããrĩñurã. Irasirigʉ Jesús ĩgʉ̃sãrẽ ãsũ ãrĩ sẽrẽñayupʉ: —Masaka yʉre, ¿naásũ ãrĩ gũñarĩ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ĩgʉ̃sã yʉjʉñurã: —Surãyeri mʉrẽ: “Juan, masakare wãĩyerimasʉ̃ ããrĩ́mi”, ãrĩma. Gajirã: “Elías iripoegue ããrĩunadi ããrĩ́mi”, gajirã: “Sugʉ Marĩpʉya kerere weredupiyudi iripoegue ããrĩunadi, masãdi ããrĩ́mi”, ãrĩma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃sãrẽ sẽrẽñayupʉ: —Mʉsãkoa yʉre, ¿naásũ ãrĩ gũñarĩ? ãrĩyupʉ. Pedro ãrĩyupʉ ĩgʉ̃rẽ: —Mʉ, Marĩpʉ iriudi, Cristo ããrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pedro irasũ ãrĩrĩrẽ pégʉ, Jesús ĩgʉ̃ buerãrẽ bʉro turaro merã: “Gajirãrẽ ire werebirikõãka!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Irasũ ãrĩ odo, ãsũ ãrĩyupʉ doja: —Yʉre ããrĩpererã tĩ́gʉ̃rẽ bʉro ñerõ tariro ããrã. Judío masaka mʉrã, paía oparã, Moisés gojadeare buerimasã yʉre gããmebirisĩã, gajirãrẽ yʉre wẽjẽdorerãkuma. Ĩgʉ̃sã yʉre wẽjẽadero pʉrʉ, ʉrenʉ waaró merã Marĩpʉ yʉre masũgʉkumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pʉrʉ ããrĩpererã masakare ãrĩyupʉ: —Yʉre tʉyadʉarãno ĩgʉ̃sã iridʉarire piriburo. Irasirirã yʉre tʉyari waja curusague pábiatú, wẽjẽsũmurã irirosũ ããrĩkererã, piriro marĩrõ yʉre tʉyaníkõãburo. ");
INSERT INTO sri_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","I ʉ̃mʉgue ĩgʉ̃sãya okari ditare maĩrãno perebiri peamegue béosũrãkuma. Gajirã gapʉ yʉre tʉyari waja, masaka ĩgʉ̃sãrẽ wẽjẽkeremakʉ̃, Marĩpʉ pʉrogue waarãkuma, ĩgʉ̃ merã õãrõ ããrĩnímurã. ");
INSERT INTO sri_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sugʉ masakʉ i ʉ̃mʉmarẽ ããrĩpereri opakeregʉ, ĩgʉ̃ boari pʉrʉ waaburi gapʉre gũñabiri waja peamegue waagʉ́, õãrĩrẽ neõ wajatabirikumi. ");
INSERT INTO sri_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Masaka yʉre, yaa kerere gʉyasĩrĩmakʉ̃, yʉde ĩgʉ̃sãrẽ gʉyasĩrĩgʉkoa. Yʉ ããrĩpererã tĩ́gʉ̃ yʉ gosesiriri merã, Yʉpʉ, ĩgʉ̃rẽ wereboerã õãrã gosesiriri merã dupaturi aarigʉkoa. Irasũ aarigʉ́, yʉre gʉyasĩrĩnerãrẽ gʉyasĩrĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Diayeta mʉsãrẽ werea. Surãyeri mʉsã õõgue ããrĩrã́, mʉsã boaburi dupiyuro Marĩpʉ ĩgʉ̃yarãrẽ doregʉ ããrĩrĩ́rẽ ĩãrãkoa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ĩgʉ̃ irasũ ãrãdero pʉrʉ su mojõma pere gaji mojõ ʉreru pẽrẽbejarinʉrĩ waadero pʉrʉ, Jesús ʉ̃tãʉ̃ wekague Marĩpʉre sẽrẽgʉ̃ waagʉ́, Pedro, Santiago, Juãrẽ siiu mʉrĩayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Irogue Marĩpʉre sẽrẽripoe ĩgʉ̃ya diapu deyori gorawayuakõãyuro. Ĩgʉ̃ya suríro bʉro borero kũmijũrĩñe waayuro. ");
INSERT INTO sri_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Irasũ waaripoe ĩgʉ̃ pʉro ʉ̃ma pẽrã deyoa, ĩgʉ̃ merã weretamuníñurã. Ĩgʉ̃sã iripoegue marã Moisés, Elías ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ĩgʉ̃sãde gosesiriri merã deyoañurã. Iripoegue: “Ĩgʉ̃rẽ ãsũ waarokoa”, ãrĩderosũta Jerusalẽ́gue ĩgʉ̃ boaburire Jesús merã wereníñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrosã bʉro wʉjakʉkererã, kãrĩrõ marĩrõ Jesús gosesiririre, ĩgʉ̃ merã ããrĩrã́rẽ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisés, Elías Jesús pʉro ããrãnerã waaripoe Pedro ãrĩyupʉ: —Gʉare buegʉ, marĩ õõgue ããrĩmakʉ̃ õãtaridʉáa. Irasirirã ʉre wiigã irirãra. Mʉya wii, Moiséya wii, Elíaya wii irirãra, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩkeregʉta, ĩgʉ̃ ãrĩrĩrẽ neõ pémasĩbiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ĩgʉ̃ irasũ ãrĩripoe su yebo ĩĩmikãyebo túbiayuro ĩgʉ̃sãrẽ. Iri ĩgʉ̃sãrẽ túbiamakʉ̃, bʉro güiñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Marĩpʉ ĩĩmikãyebo poekague ãsũ ãrĩ werenímakʉ̃ péñurã: —Ĩĩ yʉ magʉ̃, yʉ beyedi ããrĩ́mi. Ĩgʉ̃rẽ õãrõ péka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Marĩpʉ wereníadero pʉrʉ, Jesús ditare ĩãñurã. Pedrosã gapʉ Jesús i nikũgue ããrĩrĩ́nʉrĩrẽ neõ sugʉ masakʉre ĩgʉ̃sã ĩãdeare werebiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gajinʉ gapʉ ĩgʉ̃sã ʉ̃tãʉ̃gue ããrãnerã dijijadero pʉrʉ, wárã masaka Jesúre bokatĩrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sugʉ masakʉ ĩgʉ̃sã watopegue ããrĩgʉ̃́ turaro merã ãrĩyupʉ: —Gʉare buegʉ, yʉ mʉrẽ bʉro sẽrẽa. Yʉ magʉ̃ sugʉta ããrĩgʉ̃́rẽ bopoñarĩ merã ĩãka! ");
INSERT INTO sri_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wãtĩ ĩgʉ̃rẽ ñeã, gũñaña marĩrõ gaguiní, naradamakʉ̃ irinami. Irasirigʉ majĩgʉ̃ ĩgʉ̃ya disigue sũmu wirisũnami. Wãtĩ ĩgʉ̃rẽ bʉro ñerõ tarimakʉ̃ irinami. Ĩgʉ̃rẽ neõ piridʉabemi. ");
INSERT INTO sri_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉ buerãrẽ wãtĩrẽ bʉro béowiudoreadabʉ. Ĩgʉ̃sã neõ bokatĩũbirama, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús yʉjʉyupʉ: —Mʉsã dapagora marã, yʉre bʉremurĩ opamerã, diayemarẽ neõ pémasĩmerã ããrã. ¿Noópa yoaripoe mʉsã merã ããrĩgʉkuri? ¿Noópa yoaripoe mʉsã yʉre bʉremubirire gũñaturagʉkuri? ãrĩyupʉ. Irasũ ãrĩ odo, wãtĩ ñajãsũdi pagʉre: —Mʉ magʉ̃rẽ ãĩrika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Majĩgʉ̃ Jesús pʉro waa ejanʉgãmakʉ̃, wãtĩ ĩgʉ̃rẽ yebague túmeépíkõãyupʉ. Ĩgʉ̃rẽ dupaturi bʉro naradamakʉ̃ iriyupʉ. Jesús gapʉ wãtĩrẽ: “Majĩgʉ̃rẽ wirika!” ãrĩ, tauyupʉ. Irasiri odo, ĩgʉ̃rẽ pagʉre wiayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Masaka ããrĩpererã Marĩpʉ wári turari merã iririre ĩãrã, ĩãgʉkakõãñurã. Ĩgʉ̃sã ããrĩpererã Jesús iriadeare: “Õãtaria”, ãrĩ gũñaripoeta Jesús ĩgʉ̃ buerãrẽ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Yʉ mʉsãrẽ wererire õãrõ péduripíka! Kãtibirikõãka! Masaka yʉre ããrĩpererã tĩ́gʉ̃rẽ ñeã, gajirãguere wiarãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ĩgʉ̃sã gapʉ ĩgʉ̃ irasũ ãrĩrĩrẽ õãrõ pémasĩbiriñurã. Marĩpʉ ĩgʉ̃sãrẽ irire pémasĩmakʉ̃ iribiriyupʉ dapa. Irasirirã Jesúre güirã: “¿Naásũ ãrĩdʉagʉ iriari, mʉ irasũ ãrĩgʉ̃?” ãrĩ sẽrẽñabiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pʉrʉ ĩgʉ̃ buerã ãsũ ãrĩ guaseonʉgãñurã: “Marĩ watopere, ¿noã marĩ ããrĩpererã nemorõ ããrĩ́rĩ?” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús ĩgʉ̃sã gũñarĩrẽ ĩãmasĩkõãyupʉ. Irasirigʉ sugʉ majĩgʉ̃rẽ ĩgʉ̃ pʉro ãĩnú, ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Sugʉ yaagʉre, ĩĩ majĩgʉ̃ irirosũ ããrĩgʉ̃́rẽ õãrõ bokatĩrĩñeãgʉ̃, yʉdere bokatĩrĩñeãmi. Yʉre õãrõ bokatĩrĩñeãgʉ̃, yʉre iriudidere bokatĩrĩñeãmi. Sugʉ mʉsã watopemʉ: “Gajirã nemorõ ããrĩbea”, ãrĩ gũñagʉ̃, gajirã nemorõ ããrĩ́mi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pʉrʉ Juan Jesúre ãrĩyupʉ: —Gʉare buegʉ, sugʉ masakʉ mʉ wãĩ merã wãtẽãrẽ: “Wirika mʉsã ñajãdire!” ãrĩ béowiumakʉ̃ ĩãbʉ. Ĩgʉ̃, marĩ merãmʉ ããrĩbirimakʉ̃ ĩãrã, ĩgʉ̃rẽ: “Irire neõ irinemobirikõãka!” ãrãbʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús gapʉ ãrĩyupʉ: —Kãmutabirikõãka ĩgʉ̃rẽ! Sugʉ marĩrẽ ĩãturibi, marĩ merãmʉta ããrĩ́mi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pʉrʉ Jesús ʉ̃mʉgasigue mʉrĩaburi dupiyuro ejawãgãriripoe: “Jerusalẽ́gue waagʉra”, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ĩgʉ̃ waaburi dupiyuro gajirãrẽ Samaria nikũgue ããrĩrĩ́ makãgue ĩgʉ̃ kãrĩburore ãmayudoregʉ iriuyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samaria marã gapʉ judío masaka merã gãmesʉribirisĩã, Jesús Jerusalẽ́gue waaburire pérã, ĩgʉ̃rẽ bokatĩrĩñeãdʉabiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jesús buerã Santiago, Juan Samaria marã ĩgʉ̃rẽ bokatĩrĩñeãdʉabirimakʉ̃ ĩãrã, ãsũ ãrĩñurã: —Gʉa Opʉ, ¿iripoegue Elías Marĩpʉya kerere weredupiyudi iriderosũ, ʉ̃mʉgasima peamerẽ diju, ĩgʉ̃sãrẽ wẽjẽdoremakʉ̃ gããmekuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pé, Jesús ĩgʉ̃sãrẽ gãmenʉgã, ĩã, ãrĩyupʉ: —Irasũ ãrĩbirikõãka! Mʉsãrẽ irasũ werenímakʉ̃ irigʉre masĩbea. Mʉsã werenírĩ Õãgʉ̃ deyomarĩgʉ̃ wereri ããrĩbea. ");
INSERT INTO sri_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yʉ ããrĩpererã tĩ́gʉ̃ masakare béogʉ aaribiribʉ. Ĩgʉ̃sãrẽ taugʉ aarigʉ́ iribʉ, ãrĩyupʉ. Irasũ ãrĩ odo, gaji makãgue waakõãyupʉ doja. ");
INSERT INTO sri_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ĩgʉ̃sã maague waamakʉ̃, sugʉ masakʉ ĩgʉ̃sã pʉro eja, Jesúre ãrĩyupʉ: —Yʉ Opʉ, mʉ noó waaró mʉrẽ tʉyagʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Makãnʉ́ʉ marã diayéa ĩgʉ̃sã kãrĩrĩ toreri opama. Mirãde ĩgʉ̃sã kãrĩrõ opama. Yʉ ããrĩpererã tĩ́gʉ̃ gapʉ kãrĩrõ opabea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pʉrʉ Jesús gajigʉre ãrĩyupʉ: —Náka, yʉ merã! Ĩgʉ̃ gapʉ yʉjʉyupʉ: —Yʉ Opʉ, yʉpʉ boamakʉ̃ ĩgʉ̃rẽ yáa odo, mʉrẽ tʉyagʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉre bʉremumerã, boanerã irirosũ ããrĩrã́ta boanerãrẽ yáaburo. Mʉ gapʉ Marĩpʉ ĩgʉ̃yarãrẽ doreri kerere weregʉ aarika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gajigʉ Jesúre ãrĩyupʉ: —Yʉ Opʉ, mʉrẽ tʉyagʉra. Yʉ mʉrẽ tʉyaburi dupiyuro yaa wii marãrẽ seretugʉ waadʉakoa dapa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Sugʉ masakʉ moãnʉgãgʉ̃ waadi, moãdʉabi gãmenʉgãdujáagʉ, moãbirikumi. Marĩpʉ dorerire iritʉyanʉgãgʉ̃, ĩgʉ̃ gããmerĩrẽ piribi, gãmenʉgãdujáagʉ irirosũ ããrĩkumi. Irasirigʉ Marĩpʉyare õãrõ iritʉyabirikumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pʉrʉ marĩ Opʉ Jesús gajirã setenta y dos ʉ̃marẽ beye, pẽrã dita dʉkawa, ĩgʉ̃sãrẽ ããrĩpereri ĩgʉ̃ waaburi makãrĩguere ");
INSERT INTO sri_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ãsũ ãrĩ iriuyupʉ: —Wárã masaka Marĩpʉyare neõ pémerã, pooegue oteri dʉka bʉribejadea irirosũ ããrĩ́ma. Ĩgʉ̃sãrẽ Marĩpʉyare weremurã gapʉ, iri pooere moãrĩmasã irirosũ mérãgã ããrĩ́ma. Irasirirã marĩ Opʉre: “Gajirã mʉyare weremurãrẽ iriuka!” ãrĩ sẽrẽka! ");
INSERT INTO sri_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mʉsãde Marĩpʉyare wererã waaka! Oveja majĩrãrẽ makãnʉ́ʉ marã diayéa watopegue iriurosũ yʉ mʉsãrẽ ñerã ããrĩrṍguere iriua, Marĩpʉyare weredoregʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mʉsãya ajuri, niyeru ãĩabirikõãka! Gubu surí, mʉsã sãñarĩ merã dita waaka! Maague masakare bokajarã, õãdore yoaripoe weretamuníbirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","’Su wiino ñajãrã, iri wii marãrẽ: “Marĩpʉ mʉsãrẽ siñajãrĩ sĩburo”, ãrĩ õãdorepʉrorika! ");
INSERT INTO sri_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Iri wii marã Marĩpʉ siñajãrĩ sĩrĩrẽ opadʉarã mʉsãrẽ õãrõ bokatĩrĩñeãrã, Marĩpʉ siñajãrĩ sĩrĩ merã õãrõ ããrĩrikʉrãkuma. Mʉsãrẽ gããmemerã, i siñajãrĩ merã ããrĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mʉsã ejadea wiita dujaka! Iri wii marã mʉsãrẽ ejorire baa, iiríka! Sugʉ moãrĩmasʉ̃ ĩgʉ̃ moãrĩ waja keoro wajatakumi. Mʉsã Marĩpʉyare buerã, moãrĩmasã irirosũ ããrã. Mʉsãrẽ iri wii marã ejori, mʉsã ĩgʉ̃sãrẽ Marĩpʉyare bueri waja ããrã. Irasirirã gaji wiirigue ããrĩgorenabirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mʉsã su makãgue ejarã, iro marã mʉsãrẽ õãrõ bokatĩrĩñeã, ĩgʉ̃sã baari ejomakʉ̃, õãrõ baaka! ");
INSERT INTO sri_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Iri makã marã pũrĩrikʉrãrẽ tauka! Ãsũ ãrĩ wereka: “Mérõ dʉyáa, Marĩpʉ doreri mʉsã pʉrogue aariburo”, ãrĩka! ");
INSERT INTO sri_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","’Gaji makãgue mʉsã ejamakʉ̃, iro marã mʉsãrẽ bokatĩrĩñeãbirimakʉ̃, wiriwãgãrã, ãsũ ãrĩka ĩgʉ̃sãrẽ: ");
INSERT INTO sri_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mʉsãya makãma nikũwera gʉaya guburire tuadeare mojẽbéoa. Mʉsã gʉare gããmebiri waja Marĩpʉ mʉsãrẽ wajamoãburire masĩmakʉ̃ irirã, irasũ yáa. Ire õãrõ pémasĩka! Mʉsã gʉare gããmebirikeremakʉ̃, mérõ dʉyáa, Marĩpʉ doreri aariburo”, ãrĩka ĩgʉ̃sãrẽ! ");
INSERT INTO sri_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mʉsãrẽ werea. Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, mʉsãrẽ gããmebirinerãrẽ Sodoma marãrẽ wajamoãrõ nemorõ wajamoãgʉkumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Pʉrʉ Jesús gaji makãrĩ marãrẽ ãsũ ãrĩyupʉ: —Mʉsã Corazín marã, Betsaida marãde ñerõ tarirãkoa. Iripoegue marã Tiro, Sidón marã, mʉsã ĩũrõ Marĩpʉ ĩgʉ̃ turari merã iri ĩmurõsũ iri ĩmumakʉ̃ ĩãrã, ĩgʉ̃sã ñerõ irideare piribonerã ããrĩmá. Ĩgʉ̃sã ñerõ irideare bʉro bʉjawererire ĩmurã, bʉjawereri surí sãña, nitĩkʉrogue doabonerã ããrĩmá. Ĩgʉ̃sã ñerõ irideare piri, õãrĩ gapʉre iribonerã ããrĩmá. Mʉsã gapʉ Marĩpʉ turari merã iri ĩmurĩrẽ ĩãkererã, mʉsã ñerõ iririre neõ piribea. ");
INSERT INTO sri_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Irasirigʉ mʉsãrẽ werea. Marĩpʉ ĩgʉ̃ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, Tiro, Sidón marãrẽ wajamoãrõ nemorõ mʉsãrẽ wajamoãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mʉsã Capernaum marã: “Ʉ̃mʉgasigue mʉrĩãrãkoa”, ãrĩ gũñadáa. Iroguere neõ waabirikoa. Boanerã ããrĩrṍgue béodijusũrãkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Irasũ ãrĩ odo, ĩgʉ̃ buerãrẽ ãrĩyupʉ: —Mʉsã wererire péduripírãno yʉ wereridere péduripíma. Mʉsãrẽ gããmemerãno yʉdere gããmebema. Yʉre gããmemerãno yʉre iriudidere gããmebema, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pʉrʉ Jesús setenta y dos iriunerã bʉro ʉsʉyari merã goejañurã: —Gʉa Opʉ, wãtẽãrẽ mʉ dorero merã, mʉ wãĩ merã gʉa béowiumakʉ̃, õãrõ yʉjʉama, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús ãrĩyupʉ ĩgʉ̃sãrẽ: —Bupu miãrõ irirosũ wãtẽa opʉ Satanás ʉ̃mʉgasigue ããrãdi, yurimadijarimakʉ̃ ĩãbʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Õãrõ péka! Yʉ mʉsãrẽ turari sĩbʉ, ãñarẽ, korebabare kʉrapeo, ããrĩpereri wãtĩ turaridere neõ ñerõ irisũrõ marĩrõ tarinʉgãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mʉsã wãtẽãrẽ wiridoremakʉ̃ ĩgʉ̃sã õãrõ yʉjʉadeare ʉsʉyabirikõãka! Mʉsã Marĩpʉyarã ããrĩmakʉ̃, ʉ̃mʉgasigue mʉsã wãĩ gojatúsũdero ããrĩbʉ́. Iri gapʉre ʉsʉyaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ĩgʉ̃ irasũ ãrĩripoe Õãgʉ̃ deyomarĩgʉ̃ Jesúre bʉro ʉsʉyamakʉ̃ iriyupʉ. Irasirigʉ Jesús ĩgʉ̃ Pagʉre ãsũ ãrĩyupʉ: —Aʉ, yʉ mʉrẽ: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩa. Mʉ ʉ̃mʉgasi marã, i nikũ marã Opʉ ããrã. Irasirigʉ: “Masĩtarinʉgãrã, ããrĩpererire pémasĩa”, ãrĩ gũñarãrẽ mʉyare masĩmakʉ̃ iribea. Majĩrã irirosũ mʉrẽ bʉremurã gapʉre mʉyare masĩmakʉ̃ yáa. Aʉ, irasũta ããrã. Mʉ gããmederosũta ʉsʉyari merã irasũ yáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pʉrʉ masakare ãrĩyupʉ: —Yʉpʉ yʉre ããrĩpereri irimasĩrĩrẽ sĩmi. Neõ sugʉ masakʉ yʉ ããrĩrikʉrire masĩbemi. Yʉpʉ dita masĩmi. Neõ sugʉ masakʉ Yʉpʉ ããrĩrikʉrire masĩbemi. Yʉ dita masĩa. Yʉ ĩgʉ̃rẽ masĩdorerãde ĩgʉ̃rẽ masĩma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Irasũ ãrĩ odo, ĩgʉ̃ buerãrẽ ĩã, ĩgʉ̃sã ditare ãsũ ãrĩyupʉ: —Mʉsãya koye merã yʉre ĩãa. Irasirirã ʉsʉyáa. ");
INSERT INTO sri_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mʉsãrẽ werea. Wárã iripoegue marã Marĩpʉya kerere weredupiyunerã, irasũ ããrĩmakʉ̃ oparã iripoegue ããrĩnerã mʉsã dapagora ĩãrĩrẽ ĩãdʉanerã ããrãdima. Irire ĩãdʉakererã, ĩãbirinerã ããrĩmá. Mʉsã dapagora périre pédʉakererã, pébirinerã ããrĩmá, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pʉrʉ sugʉ Moisés gojadeare buerimasʉ̃ Jesúre diaye yʉjʉbirimakʉ̃ iridʉagʉ wãgãnʉgã, ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽñayupʉ: —Buegʉ, ¿ñeénorẽ yʉre iriro gããmerĩ, ʉ̃mʉgasigue perebiri okari opabu? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —¿Naásũ ãrĩ gojasũyuri, Moisés gojadea pũgue? Mʉ irire buegʉ, ¿naásũ péñarĩ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Moisés gojadeare buerimasʉ̃ ĩgʉ̃rẽ yʉjʉyupʉ: —Ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Marĩpʉ mʉ Opʉre bʉro maĩka! Mʉya yʉjʉpũrã merã, mʉ ããrĩrikʉri merã, mʉ turari, ããrĩpereri mʉya gũñarĩ merã ĩgʉ̃rẽ maĩka! Mʉ basi maĩrõsũta mʉ pʉro ããrĩrã́dere maĩka!” ãrĩ gojasũdero ããrĩbʉ́, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Irire pégʉ, Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Diayeta yʉjʉa mʉ. Irire irigʉ, ʉ̃mʉgasigue perebiri okarire opagʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Moisés gojadeare buerimasʉ̃ gapʉ masaka ĩgʉ̃rẽ: “Õãgʉ̃ ããrĩ́mi”, ãrĩ gũñamakʉ̃ gããmegʉ̃, Jesúre sẽrẽñayupʉ doja: —¿Noã ããrĩ́rĩ, yʉ pʉro ããrĩrã́? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús keori merã wereyupʉ ĩgʉ̃rẽ: —Sugʉ masakʉ Jerusalẽ́gue ããrãdi Jericó waarí maague buáakumi. Ĩgʉ̃ irogue buáamakʉ̃, yajarimasã ĩgʉ̃rẽ bokatĩrĩ, ñeã, ĩgʉ̃ opadea ããrĩpererire ẽmapeo, ĩgʉ̃ya surídere túwea, ãĩ, ĩgʉ̃rẽ bʉro pá, kãmitú, waakõãkuma. ");
INSERT INTO sri_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ĩgʉ̃sã irasũ iriadero pʉrʉ, sugʉ paí iri maarẽ́ waakumi. Ĩgʉ̃rẽ ĩãkeregʉ, yoarogue ĩãtariakõãkumi. ");
INSERT INTO sri_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ĩgʉ̃ pʉrʉ, gajigʉ Levíya bumʉ iri maarẽ́ waakumi. Ĩgʉ̃de ĩgʉ̃rẽ ĩãkeregʉ, yoarogue ĩãtariakõãkumi. ");
INSERT INTO sri_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pʉrʉ sugʉ Samariamʉ iri maarẽ́ waakumi. Ĩgʉ̃rẽ ĩãboka, bʉro bopoñarĩ merã ĩgʉ̃rẽ ĩãkumi. ");
INSERT INTO sri_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Irasirigʉ ĩgʉ̃ pʉro waa ejanʉgã, ĩgʉ̃ya kãmirẽ ʉye, igui deko pãmudea merã pípeo, surí gasiri merã õmakumi. Õma odo, ĩgʉ̃yagʉ burro wekague ãĩpeo, ĩgʉ̃rẽ ãĩãkõãkumi. Ãĩa, su wii naarĩmasã kãrĩrĩ wiigue eja, irogue ĩgʉ̃rẽ korekumi dapa. ");
INSERT INTO sri_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gajinʉ gapʉ ĩgʉ̃ya niyeru penʉ moã wajataropa iri wii opʉre sĩkumi. “Õãrõ koreka ĩĩrẽ!” ãrĩkumi. “Dupaturi aarigʉ́, mʉrẽ wajarinemogʉra ĩĩrẽ koreri waja”, ãrĩkumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Irire were odo, Moisés gojadeare buerimasʉ̃rẽ sẽrẽñayupʉ: —¿Naásũ gũñarĩ mʉ irire pégʉ? ¿Niíno gapʉ ĩĩsã ʉrerã watopemʉ yajarimasã pádire ĩgʉ̃ pʉro ããrĩgʉ̃́rẽ irirosũ õãrõ iriyuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Moisés gojadeare buerimasʉ̃ yʉjʉyupʉ: —Ĩgʉ̃rẽ bopoñarĩ merã ĩã iritamudi gapʉ, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Mʉde ĩĩ bopoñarĩ merã ĩãdi iriderosũta gajirãrẽ irigʉ waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pʉrʉ Jesús ĩgʉ̃ buerã merã waa, su makãgue ejayupʉ. Iri makãguere sugo Marta wãĩkʉgo ĩgʉ̃rẽ bokatĩrĩñeã, igoya wiigue ñajãdoreyupo. ");
INSERT INTO sri_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jesús iri wiigue ñajãjamakʉ̃, Marta pagʉmo María wãĩkʉgo ĩgʉ̃ya guburi pʉro eja doayupo ĩgʉ̃ werenírĩrẽ pédʉago. ");
INSERT INTO sri_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta gapʉ ããrĩpereri igo moãrĩrẽ bʉro gũñarikʉyupo. Irasirigo igo pagʉmo Jesúya guburi pʉro doamakʉ̃ ĩãgõ, ĩgʉ̃ pʉro waa, ĩgʉ̃rẽ ãrĩyupo: —Gʉa Opʉ, yʉ sugota ããrĩpererire moãgõ irikõãdáa. ¿Mʉ ĩãberi, yʉ pagʉmo yʉre neõ iritamubirimakʉ̃? Igore iritamudoreka yʉre! ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Igo irasũ ãrĩmakʉ̃ pégʉ, Jesús yʉjʉyupʉ: —Marta, mʉ wári gajino moãrĩrẽ gũñarikʉa. ");
INSERT INTO sri_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Su wãĩrẽta iriro gããmea marĩrẽ. María i õãrĩrẽ beyemo. Irasirirã, yʉ werenírĩrẽ igo pédʉamakʉ̃, gajirã neõ igore irire pirimakʉ̃ iribirikuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sunʉ Jesús gajirogue Marĩpʉre sẽrẽgʉ̃ iriyupʉ. Ĩgʉ̃ sẽrẽ odomakʉ̃, sugʉ ĩgʉ̃ buegʉ ãrĩyupʉ ĩgʉ̃rẽ: —Gʉa Opʉ, Juan masakare wãĩyerimasʉ̃ ĩgʉ̃ buerãrẽ Marĩpʉre sẽrẽrĩrẽ buederosũ gʉadere bueka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Marĩpʉre sẽrẽrã, ãsũ ãrĩka: “Gʉapʉ ʉ̃mʉgasigue ããrĩgʉ̃́, ããrĩpererã mʉrẽ goepeyari merã bʉremuburo. Mʉ ããrĩpererãrẽ doreri aariburo. Ʉ̃mʉgasigue marã mʉ gããmerõ irirosũta i nikũ marãde iriburo. ");
INSERT INTO sri_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ʉ̃mʉrikʉ gʉare baari sĩka! ");
INSERT INTO sri_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gajirã gʉare ñerõ irideare gʉa kãtirosũta mʉde gʉa ñerõ irideare kãtika! Gʉa ñerõ iridʉamakʉ̃ kãmutaka! Ñegʉ̃ gʉare ñerĩ ãrĩmesãrĩrẽ tau kãmutaka!” ãrĩka Marĩpʉre sẽrẽrã! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Irasũ ãrĩ odo, keori merã wereyupʉ ĩgʉ̃sãrẽ: —Yʉ ire weremakʉ̃ pérã, ¿naásũ gũñarĩ mʉsã? Ñami deko ããrĩmakʉ̃, sugʉ masakʉ ĩgʉ̃ merãmʉya wiigue waa, ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽkumi: “Yʉ merãmʉ, ʉreru pã́ duparu sĩka yʉre! ");
INSERT INTO sri_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gajigʉ yʉ merãmʉ yaa wiigue naagʉ̃ ejáami. Yʉ ĩgʉ̃rẽ gajino mérõ ejorino neõ opabirakubʉ. Irasirigʉ mʉrẽ sẽrẽgʉ̃ aarabʉ”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pékeregʉ, wii poekague ããrĩgʉ̃́ gapʉ ãsũ ãrĩ yʉjʉkumi: “Yʉre garibobirikõãka! Makãpʉrore õãrõ biakõãsiabʉ. Yʉ pũrã yʉ merã kãrĩrãgue yáma. Wãgãnʉgã, mʉrẽ sĩgʉ̃ waasubirikoa”, ãrĩkumi ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ire mʉsãrẽ werea. Ĩgʉ̃ merãmʉ ããrĩkeremakʉ̃, ĩgʉ̃rẽ sĩbirikumi. Sĩbirikeregʉ, ĩgʉ̃rẽ piriro marĩrõ sẽrẽmakʉ̃ ĩã, ĩgʉ̃rẽ: “Garibonemobirikõãburo”, ãrĩgʉ̃, ããrĩpereri ĩgʉ̃ gããmerĩrẽ sĩkõãkumi pama. ");
INSERT INTO sri_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Irasirigʉ mʉsãrẽ werea. Marĩpʉre sẽrẽka! Mʉsã sẽrẽmakʉ̃, sĩgʉkumi. Õãrĩrẽ ãmarã́, bokarãkoa. Wiigue ñajãdʉarã oemakʉ̃, Marĩpʉ makãpʉro tũpã ñajãdoregʉ irirosũ mʉsã sẽrẽrĩrẽ pégʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ĩgʉ̃rẽ sẽrẽrãnorẽ sĩgʉkumi. Ãmarã́no bokarãkuma. Wiigue ñajãdʉarã oerã irirosũ ĩgʉ̃rẽ sẽrẽmakʉ̃ ĩãgʉ̃, ĩgʉ̃sãrẽ ñajãdoregʉ irirosũ ĩgʉ̃sã sẽrẽrĩrẽ õãrõ pégʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mʉsã pũrã pã́rẽ sẽrẽmakʉ̃, ʉ̃tãyere sĩbirikoa. Waaí sẽrẽmakʉ̃dere ãñarẽ sĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ãgãbo diu sẽrẽmakʉ̃, korebabare sĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ñerã ããrĩkererã, mʉsã pũrãrẽ õãrĩrẽ sĩmasĩa. Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ gapʉ mʉsã nemorõ õãrĩrẽ sĩmasĩmi. Irasirigʉ Õãgʉ̃ deyomarĩgʉ̃rẽ sĩgʉkumi ĩgʉ̃rẽ sẽrẽrãrẽ, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pʉrʉ Jesús wãtĩ masakʉre werenímasĩbirimakʉ̃ irigʉre béowiugʉ iriyupʉ. Wãtĩrẽ béowiumakʉ̃, wereníbiradi wereníakõãyupʉ. Masaka, ĩgʉ̃ irasirimakʉ̃ ĩãrã, ĩãgʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gajirã gapʉ Jesúre ãsũ ãrĩ werewʉañurã: —Ĩĩ wãtẽa opʉ Beelzebú turaro merã wãtẽãrẽ béowiumi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gajirãde ĩgʉ̃rẽ: —Mʉ diayeta turari opagʉ, iri turari merã gajino ʉ̃mʉgasimarẽ iri ĩmuka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús gapʉ ĩgʉ̃sã gũñarĩrẽ masĩsĩã, ãsũ ãrĩyupʉ: —Su nikũ marã ĩgʉ̃sã basi dʉkawari gãmekẽãrã, pereakõãkuma. Su wii marã ĩgʉ̃sã basi dʉkawari gãmekẽãrã, pereakõãkuma. ");
INSERT INTO sri_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mʉsã yʉre: “Wãtẽa opʉ Beelzebú turari merã wãtẽãrẽ béowiumi”, ãrĩ werewʉáa. Yʉre ĩgʉ̃ turari merã wãtẽãrẽ béowiudoregʉ, ĩgʉ̃ basi ĩgʉ̃yarãrẽ béobukumi. Irasirirã ĩgʉ̃sã basi dʉkawari gãmekẽãrã, pereakõãbukuma. ");
INSERT INTO sri_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iri irasũ ããrĩmakʉ̃, mʉsã buerire tʉyarã gapʉ wãtẽãrẽ béowiurã, ¿noã turari merã béowiukuri? Mʉsã ĩgʉ̃sãrẽ: “Marĩpʉ turari merã wãtẽãrẽ béowiuma”, ãrã. Irasiriro mʉsã yʉre werewʉari diaye ããrĩbea. ");
INSERT INTO sri_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yʉ gapʉ Marĩpʉ turari merã wãtẽãrẽ béowiumakʉ̃, Marĩpʉ doreri mʉsã pʉroguere ejasiáa, ãrĩ masĩsũa. ");
INSERT INTO sri_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Sugʉ wii opʉ turagʉ ããrĩpereri mojõkʉgʉ, ĩgʉ̃ya wiimarẽ õãrõ koremasĩkumi. Gajirã ĩgʉ̃ oparire ẽmamasĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","“I mojõkʉsĩã, yaa wiire õãrõ koremasĩa”, ãrĩ gũñakeremakʉ̃, gajigʉ ĩgʉ̃ nemorõ turagʉ gapʉ ĩgʉ̃rẽ tarinʉgã, ããrĩpereri ĩgʉ̃ mojõkʉrire ẽmagʉkumi. Irasirigʉ ĩgʉ̃ oparire ãĩpeo, ĩgʉ̃ merãmarãrẽ gueregʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yʉre gããmemerã, yʉre ĩãturirã ããrĩ́ma. Masakare yʉre siiu neeõtamumerã, ĩgʉ̃sãrẽ waasirimakʉ̃ irirã ããrĩ́ma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Irasũ ãrĩ odo, gaji keori merã ĩgʉ̃sãrẽ wereyupʉ doja: —Wãtĩ masakʉguere ããrãdi wiri, pʉrʉ deko marĩrõgue ĩgʉ̃ siñajãburore ãmagorenagʉ̃ waakumi. Irore bokabi, ãsũ ãrĩ gũñakumi: “Yʉ wiridi, yaa wii irirosũ ããrĩmí. Dupaturi yʉ wiridiguereta goeñajãgʉra doja”, ãrĩ gũñakumi. ");
INSERT INTO sri_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Irasirigʉ ĩgʉ̃guere dupaturi goeñajãgʉ̃, gajino marĩrĩ wii, õãrõ ãmu, ooaweadea wiire irirosũ bokajakumi. ");
INSERT INTO sri_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Irasirigʉ gajirã wãtẽa su mojõma pere gaji mojõ peru pẽrẽbejarã ĩgʉ̃ nemorõ ñerãrẽ siiu, ĩgʉ̃sã ããrĩpererã merã masakʉguere ããrĩníkõãkumi. Irasirigʉ masakʉ ĩgʉ̃ dupiyuro ããrĩrikʉdero nemorõ ñerõ ããrĩkumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús irire wereripoe sugo nomeõ masaka watopegue ããrĩgṍ gaguiníyupo: —Mʉrẽ pũrãkʉ masũdeo ʉsʉyatarikumo, ãrĩyupo Jesúre. ");
INSERT INTO sri_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús gapʉ igore ãrĩyupʉ: —Marĩpʉya werenírĩrẽ pérã, ĩgʉ̃ dorerire irirã gapʉ õãrõ ʉsʉyarãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pʉrʉ Jesús ĩgʉ̃ pʉro masaka wárã nerẽwãgãriripoe ãsũ ãrĩ wereyupʉ ĩgʉ̃sãrẽ: —Dapagora marã masaka ñetarirã ããrĩ́ma. Yʉre Marĩpʉ turari merã gajino iri ĩmudorekeremakʉ̃, Marĩpʉya kerere weredupiyudi Jonás iridea ditare weregʉra. ");
INSERT INTO sri_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iripoegue Marĩpʉ Jonárẽ Nínive wãĩkʉri makã marãrẽ weredorederosũ yʉre ããrĩpererã tĩ́gʉ̃rẽ dapagora marã masakare weredoremi. ");
INSERT INTO sri_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, sugo iripoeguemo Sabá nikũ marã opo mʉsã dapagora marãrẽ: “Ñegorabʉ”, ãrĩgokumo. Yoaromogue ããrĩkerego, õõgue i nikũgue aarideo ããrĩmó, marĩ ñekʉ̃sãmarã opʉ Salomón wári masĩrĩ merã wererire pégo aarigó. Dapagora yʉ Salomón nemorõ masĩgʉ̃ õõgue mʉsã merã ããrĩkeremakʉ̃, mʉsã gapʉ yʉ wererire pédʉabea. ");
INSERT INTO sri_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Iripoegue Nínive marã Jonás Marĩpʉya kerere weremakʉ̃ pérã, ĩgʉ̃sã ñerõ irideare bʉjawere, ĩgʉ̃sã gũñarĩrẽ gorawayunerã ããrĩmá. Dapagora yʉ Jonás nemorõ masĩgʉ̃ õõgue mʉsã merã ããrã. Yʉ Marĩpʉya kerere werekeremakʉ̃, mʉsã ñerõ iririkʉrire bʉjawerebea. Irasirirã, Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, Nínive marã mʉsã dapagora marãrẽ: “Ñegorabʉ”, ãrĩrãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Irasũ ãrĩ odo, gaji keori merã wereyupʉ: —Masaka sĩãgodirure sĩãgorã, deyomarĩrõgue duúbirikuma. Dupa kũma dokaguedere píbirikuma. Sĩãgo, wii dekogue siukuma, gajirã iri wiire ñajãrã iri sĩãgodiru boyorore õãrõ ĩã ñajãburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mʉsãya koye mʉsãya gũñarĩguere sĩãgodiru irirosũ ããrã. Mʉsã õãrĩ koye oparã irirosũ ããrĩmakʉ̃, mʉsãya gũñarĩguere õãrõ sĩãgoro irirosũ ããrã. Irasirirã Marĩpʉyare masĩa. Mʉsã ñerĩ koye oparã irirosũ ããrĩmakʉ̃, mʉsã gũñarĩguere naĩtĩãrõ irirosũ ããrã. Marĩpʉyare masĩbea. ");
INSERT INTO sri_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Irasirirã pémasĩka, mʉsãya gũñarĩgue sĩãgori, naĩtĩãrĩ waabirikõãburo, ãrĩrã! ");
INSERT INTO sri_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mʉsãya gũñarĩgue sĩãgori, naĩtĩãrõ marĩrõ irirosũ ããrĩmakʉ̃, ããrĩpereri Marĩpʉyare pémasĩrãkoa. Irasirirã sĩãgori boyorogue ĩãrõsũ õãrõ pémasĩrĩ merã ĩgʉ̃yare iritʉyarãkoa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús irasũ ãrĩ odoadero pʉrʉ, sugʉ fariseo bumʉ ĩgʉ̃ya wiigue baadoregʉ siiuayupʉ ĩgʉ̃rẽ. Irasirigʉ Jesús ĩgʉ̃ merã waa, ĩgʉ̃ya wiigue ñajãa, eja doayupʉ ĩgʉ̃ merã baabu. ");
INSERT INTO sri_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseo bumʉ gapʉ judío masaka irinírõsũ Jesús baaburi dupiyuro ĩgʉ̃ mojõkoebirimakʉ̃ ĩãgʉ̃, ĩãgʉkakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ĩgʉ̃ ĩãgʉkamakʉ̃ ĩãgʉ̃, marĩ Opʉ Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Mʉsã fariseo bumarã masaka ĩũrõgue dita õãrõ irirã, soropa weka gapʉ dita õãrõ koeadeapa irirosũ ããrã. Irasirirã gajirãyare yajadʉarã, ñerĩ ditare iridʉarã ããrĩsĩã, iripa poekague gʉrari ʉtʉriro irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Irasirirã neõ pémasĩbea. Marĩpʉ, marĩya dʉpʉre irigʉ, marĩ gũñarĩdere iridi ããrĩmí. ¿Irire pémasĩberi mʉsã? ");
INSERT INTO sri_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mʉsã oparire gajirãrẽ sĩrã, õãrõ gũñarĩ merã sĩka! Irasirirã soropa poeka gapʉdere koeadeapa irirosũ ããrĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Mʉsã fariseo bumarã bʉro ñerõ tarirãkoa. Mʉsã oteri mʉtãrĩgã: menta, ruda wãĩkʉri baari morẽrĩnorẽ, ããrĩpereri oteridari dʉkakʉrinogãdere sea neeõ, keoro dʉkawa, pe mojõma diruri irikoa. Sudiru Marĩpʉya wiigue ãĩa: “Ĩgʉ̃rẽ yʉ sĩrĩ ããrã”, ãrĩ, irogue píkoa, ĩgʉ̃ dorerire irimurã. Irasirikererã, gajirãrẽ diayema iririre iribea. Marĩpʉre maĩbea. Irasirirã mʉsã oterire ĩgʉ̃rẽ sĩduúro marĩrõ diayemadere irika! Marĩpʉre maĩrĩ merã bʉremuka! ");
INSERT INTO sri_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Mʉsã fariseo bumarã bʉro ñerõ tarirãkoa. Mʉsã nerẽrĩ wiiriguere nerẽrã, õãrĩ doarigue dita doadʉáa. Makã dekoguere masakare mʉsãrẽ goepeyari merã bokatĩrĩ õãdoremakʉ̃ gããmea. ");
INSERT INTO sri_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Mʉsã Moisés gojadeare buerimasã, fariseo bumarãde bʉro ñerõ tarirãkoa. Mʉsã masãgoberi irirosũ ããrã. Irasirirã masaka iri goberi ããrĩrṍ weka tãpítariarã, iri goberi poekague ããrĩrĩ́rẽ masĩberosũ mʉsã ñerõ oparire masĩbema, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, sugʉ Moisés gojadeare buerimasʉ̃ ãrĩyupʉ ĩgʉ̃rẽ: —Buegʉ, mʉ fariseo bumarãrẽ irasũ ãrĩgʉ̃, gʉadere ãrĩ turigʉ yáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús gapʉ ĩgʉ̃rẽ ãsũ ãrĩyupʉ: —Mʉsãde, Moisés gojadeare buerimasã bʉro ñerõ tarirãkoa. Mʉsã gajirãrẽ: “Ãsũ irika!” ãrĩ, dorerã, ĩgʉ̃sãrẽ gajino bʉro nʉkʉ̃rĩ kõãtãrĩrã irirosũ ããrĩmakʉ̃ yáa. Irasirirã iri dorerire bokatĩũbema. Ĩgʉ̃sã mʉsã dorerire bokatĩũbirikeremakʉ̃, ĩgʉ̃sãrẽ neõ iritamubea iri dorerire iriburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Irasirirã mʉsã bʉro ñerõ tarirãkoa. Iripoegue marã Marĩpʉya kerere weredupiyunerã masãgoberi weka weanúdeare mʉsã ãmua. Ĩgʉ̃sãrẽta mʉsã ñekʉ̃sãmarã wẽjẽnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ĩgʉ̃sã irasũ wẽjẽdero pʉrʉgue, dapagora mʉsã ĩgʉ̃sã iripoegue irideare iriwekabejakõãa, ĩgʉ̃sã wẽjẽnerãya masãgoberi weka weanúdeare ãmurã́. Irasirirã mʉsã ĩgʉ̃sã wẽjẽdeare: “Ñegorabʉ”, ãrĩ gũñabea. Mʉsã ñekʉ̃sãmarã Marĩpʉya kerere weredupiyunerãrẽ gããmebiriderosũ mʉsãde yʉre gããmebea. ");
INSERT INTO sri_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Irasirigʉ iripoegue Marĩpʉ ĩgʉ̃ masĩrĩ merã ãsũ ãrĩdi ããrĩmí: “Yaa kerere weredupiyurimasãrẽ, yaare buerimasãdere iriugʉra. Irire buemakʉ̃ ĩã, surãyerire masaka wẽjẽrãkuma. Gajirãrẽ ñerõ iridʉarã, noó ĩgʉ̃sã waaró tʉyagorenarãkuma”, ãrĩdi ããrĩmí Marĩpʉ. ");
INSERT INTO sri_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Marĩpʉ i ʉ̃mʉrẽ iriadero pʉrʉ, Abere ĩgʉ̃ tĩ́gʉ̃ wẽjẽdi ããrĩmí. Pʉrʉ Marĩpʉya kerere weredupiyunerãrẽ wẽjẽnerã ããrĩmá. Pʉrʉ Zacaríadere Marĩpʉya wiima soepeoro Marĩpʉ ããrĩrĩ́ taribu watopegue wẽjẽnerã ããrĩmá. Irasirigʉ Marĩpʉ ããrĩpererãrẽ ĩgʉ̃sã wẽjẽdea waja dapagora marãrẽ wajamoãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Mʉsã Moisés gojadeare buerimasã bʉro ñerõ tarirãkoa. Mʉsã Marĩpʉyare masĩkererã, mʉsã basi irire iridʉabea. Irasirirã gajirãrẽ irire masĩdʉarãrẽ masĩbirimakʉ̃ yáa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, Moisés gojadeare buerimasã, fariseo bumarãde ĩgʉ̃ merã guatariakõãñurã. Irasirirã bʉro ĩgʉ̃rẽ werewʉa, wári ĩgʉ̃rẽ sẽrẽñanʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ĩgʉ̃ diaye yʉjʉbirimakʉ̃ pérã, ĩgʉ̃rẽ weresãdʉarã, irasiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ĩgʉ̃sã irasiriripoe Jesús pʉro masaka wárã nerẽñurã. Ĩgʉ̃sã wárã ããrĩsĩã, gãme kʉratĩãnokõãñurã. Jesús ĩgʉ̃ buerãrẽ ãsũ ãrĩ werenʉgãyupʉ: —Fariseo bumarã irikatorire õãrõ pémasĩka! Ĩgʉ̃sã irikatori pã́ wemasãrĩ morẽrĩ irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ããrĩpereri gajirã ĩãberogue irideare, durirogue irideadere pʉrʉgue masĩsũrokoa. ");
INSERT INTO sri_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mʉsã naĩtĩãrõgue irirosũ gajirã péberogue werenídeare boyorogue irirosũ Marĩpʉ ĩgʉ̃sãrẽ pémakʉ̃ irigʉkumi. Mʉsã wii poekague yayero werenídeadere makã dekogue gaguinírõsũ gajirãrẽ õãrõ pémakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Mʉsãrẽ yʉ merãmarãrẽ werea. Mʉsãrẽ wẽjẽrã, mʉsãya dʉpʉ ditare boamakʉ̃ irirãkuma. Pʉrʉguere mʉsãrẽ neõ ñerõ irinemobirikuma. Irasirirã mʉsãrẽ wẽjẽdʉarãrẽ güibirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yʉ mʉsã goepeyari merã güibure weregʉra. Marĩpʉ gapʉre güiri merã bʉremuka! Masakare ĩgʉ̃sã okarire ẽmamasĩmi. Ĩgʉ̃ ẽmadero pʉrʉ, ĩgʉ̃sãrẽ perebiri peamegue béomasĩmi. Irasirirã ĩgʉ̃ gapʉre güiri merã bʉremuka! ");
INSERT INTO sri_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Masaka su mojõmarã mirã wajarirã, pe niyeru koegã, mérõgã wajakʉri koerigãrẽ sĩkuma. Ĩgʉ̃sã mérõgã wajakʉkeremakʉ̃, Marĩpʉ gapʉ ĩgʉ̃sãrẽ õãrõ koremi. Neõ sugʉre kãtibemi. ");
INSERT INTO sri_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Marĩpʉ ããrĩpereri mʉsã ããrĩrikʉrire masĩgʉ̃, mʉsãya poarire: “Irikʉ ããrã”, ãrĩ masĩpeokõãmi. Irasirirã güibirikõãka! Mʉsã, mirã nemorõ wajakʉa. Irasirigʉ Marĩpʉ mirãrẽ korero nemorõ mʉsãrẽ koregʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Mʉsãrẽ werea. Sugʉ, masaka péuro: “Jesúyagʉ ããrã”, ãrĩ weremakʉ̃, yʉ ããrĩpererã tĩ́gʉ̃de Marĩpʉre wereboerã péuro: “Yaagʉ ããrĩ́mi ĩĩ”, ãrĩ weregʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sugʉ yʉre masĩkeregʉ, masaka péuro: “Ĩgʉ̃rẽ masĩbea”, ãrĩ weremakʉ̃, yʉ ããrĩpererã tĩ́gʉ̃de Marĩpʉre wereboerã péuro: “Yʉde ĩgʉ̃rẽ masĩbea”, ãrĩ weregʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Sugʉ yʉre ããrĩpererã tĩ́gʉ̃rẽ ñerõ ãrĩ werenímakʉ̃, Marĩpʉ kãtimasĩmi. Õãgʉ̃ deyomarĩgʉ̃ gapʉre ñerõ ãrĩ werenímakʉ̃, neõ kãtibirikumi. ");
INSERT INTO sri_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Masaka mʉsãrẽ ĩgʉ̃sã nerẽrĩ wiiri oparã pʉrogue, weresãrĩrẽ beyerimasã pʉrogue, o makãrĩ marãrẽ dorerã pʉrogue mʉsãrẽ ĩgʉ̃sã weresãmurã ãĩmakʉ̃: “¿Naásũ yʉjʉrãkuri, o naásũ ãrĩrãkuri ĩgʉ̃sãrẽ?” ãrĩ, bʉro gũñarikʉbirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ĩgʉ̃sã mʉsãrẽ sẽrẽñamakʉ̃ta, Õãgʉ̃ deyomarĩgʉ̃ masĩrĩ sĩrĩ merã ĩgʉ̃sãrẽ wererãkoa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pʉrʉ sugʉ masaka watopegue ããrĩgʉ̃́ Jesúre ãrĩyupʉ: —Buegʉ, gʉapʉ boagʉ ĩgʉ̃ opadeare gʉare pími. Irasirigʉ yʉ tĩ́gʉ̃rẽ irire keoro dʉkawa, yʉdere sĩdoreka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús gapʉ ĩgʉ̃rẽ yʉjʉyupʉ: —Mʉsãpʉ pídeare mʉsãrẽ dʉkawabu ããrĩbea yʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Irasũ ãrĩ odo, ããrĩpererãrẽ ãrĩyupʉ: —Pémasĩka mʉsã! Doebirire, gajinodere wáro gããmebirikõãka! Masaka wári oparã, õãrĩ okari gapʉre opabema, wári opari ditare gũñarã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Irasũ ãrĩ odo, keori merã wereyupʉ ĩgʉ̃sãrẽ: —Sugʉ masakʉ wári doebiri opakumi. Ĩgʉ̃ otedeade wárigora dʉkakʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Irasirigʉ ĩgʉ̃ basi gũñakumi: “¿Nasirigʉkuri? Yaa oteri dʉka sea duripíburi wii máa”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pʉrʉ gũñakumi doja: “Ãsũ irigʉra. Yʉ gajino duripíri wii ããrĩpʉroridea wiire béo, nemorõ wári wii irigʉra. Iri odo, iri wiigue yaa oteri dʉkare ããrĩpereri, yaa doebiridere duripígʉra. ");
INSERT INTO sri_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pʉrʉ yʉ basi ãsũ ãrĩgʉra: ‘Wári doebiri opáa. Wári bojorima baaburidere opáa. Irasirigʉ siñajã, baa, iirí, ʉsʉyagʉra’”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Marĩpʉ gapʉ ĩgʉ̃rẽ ãrĩkumi: “Mʉ neõ pémasĩbi ããrã. Dapagã ñamita boagʉkoa. Mʉ boamakʉ̃, ¿noã oparãkuri mʉ duripíadeare?” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Irasũta waarãkuma, masaka ĩgʉ̃sãya doebiri ditare gũñarã. Ĩgʉ̃sãya ããrĩburi ditare gũña, wári doebirire duripírãkuma. Irasirikererã, Marĩpʉre gũñamerã, ĩgʉ̃ ĩũrõrẽ boporã irirosũ ããrĩrãkuma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pʉrʉ Jesús ĩgʉ̃ buerãrẽ ãsũ ãrĩyupʉ doja: —Irasirigʉ mʉsãrẽ ire weregʉra. Mʉsã ããrĩrikʉrire gũñarã: “¿Ñeénorẽ baarãkuri, ñeénorẽ iirírãkuri, ñeénorẽ sãñarãkuri?” ãrĩ, bʉro gũñarikʉbirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Marĩ okari gapʉ, baari nemorõ wajakʉa. Marĩya dʉpʉ, surí nemorõ wajakʉa. Irasiriro mʉsã ããrĩrikʉri, mʉsã opari nemorõ wajakʉa. ");
INSERT INTO sri_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mirãrẽ gũñaka! Ĩgʉ̃sã baadʉarã, otebema. Otedea dʉkare seabema. Baari duripíri wiiridere opabema. Marĩpʉ gapʉ ĩgʉ̃sãrẽ baari sĩmi. Mʉsã gapʉ, mirã nemorõ wajakʉtarinʉgãa. ");
INSERT INTO sri_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mʉsã bʉro gũñarikʉri merã neõ mérõgã masãnemobirikoa. ");
INSERT INTO sri_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mʉsã irasũ gũñarikʉri wajamarĩkeremakʉ̃, ¿nasirirã gajinorẽ bʉro gũñarikʉri? Mʉsã gũñarikʉri merã ããrĩpererire neõ irimasĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Makãnʉ́ʉma goori masãrĩrẽ gũñaka! Iri moãbirikerero, suabirikerero, õãrĩ surí sãñarõ irirosũ deyoa. Mʉsãrẽ werea. Opʉ Salomón surí õãrĩ sãñadero nemorõ iri goori gapʉ õãrĩ deyoa. ");
INSERT INTO sri_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iri goori makãnʉ́ʉgue mata puridea goori ããrĩkeremakʉ̃, Marĩpʉ õãrĩ goori deyomakʉ̃ irikeremakʉ̃, mérõgã pʉrʉ ñaĩdija pereakõãa. Gajinʉ gapʉ peamegue soebéokõãsũa. Iri mata pereburi ããrĩkeremakʉ̃, Marĩpʉ iri goorire õãrĩ deyomakʉ̃ yámi. Iri goorire õãrĩ ããrĩmakʉ̃ irirosũ nemorõ mʉsãrẽ õãrõ irigʉkumi. Mʉsã ĩgʉ̃rẽ mérõgã bʉremukeremakʉ̃, mʉsãrẽ surí sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Irasirirã ʉ̃mʉrikʉ mʉsã baaburire, mʉsã iiríburire bʉro gũñarikʉri merã ãmabirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","I ʉ̃mʉ marã Marĩpʉre bʉremumerã bʉro gũñarikʉri merã irire ãmaníkõãma. Ĩgʉ̃sã irasũ ããrĩkeremakʉ̃, Marĩpʉ mʉsã gããmerĩrẽ masĩsiami. Irire mʉsãrẽ sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Irasirirã mʉsã Marĩpʉre masĩrã, ĩgʉ̃ mʉsã Opʉ ããrĩrĩ́rẽ gããmepʉrorika! Mʉsã irasirimakʉ̃, mʉsã baa, iiríburire, mʉsã surí sãñaburidere sĩwekapeogʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Mʉsã yaarã, mérãgã, oveja su yebo marã irirosũ ããrã. Irasũ ããrĩkererã, güibirikõãka! Mʉsãpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ ĩgʉ̃yarãrẽ dorerogue mʉsã ĩgʉ̃ merã ããrĩmakʉ̃ gããmemi, ĩgʉ̃ merã doreburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Irasirirã mʉsã oparire duaka! Iri duadea wajare niyerure boporãrẽ sĩka! Ʉ̃mʉgasiguemarẽ gũñaka! Irasirirã irogue perebiri wajatarire, ajurogue doebiri neõ perebirire oparosũ oparãkoa. Irogue wajatarire yajarimasã ñajãa, ãĩmasĩbirikuma. Buruade baadedeubirikuma. ");
INSERT INTO sri_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mʉsã i ʉ̃mʉma ditare: “Opadʉakoa”, ãrĩ gũñarã, irire bʉro maĩrãkoa. Ʉ̃mʉgasima gapʉre: “Opadʉakoa”, ãrĩ gũñarã, irire bʉro maĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Yʉ i ʉ̃mʉgue dupaturi aariburi dupiyuro õãrõ ãmuyuanerãgue ããrĩka! Sĩãgodirure sĩãgoanerã irirosũ yʉre yúka! ");
INSERT INTO sri_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sugʉ masakʉ, mojõsʉadi pʉrogue mojõsʉari bosenʉ waamakʉ̃, ĩgʉ̃rẽ moãboerã ĩgʉ̃ dujariburire yúkuma. Ĩgʉ̃sã opʉ ĩgʉ̃ya wiigue goedujaja, ñajãdʉagʉ makãpʉrore ĩgʉ̃ dotemakʉ̃ pérã, ĩgʉ̃rẽ moãboerã mata tũpãkuma. Ĩgʉ̃sã yúrosũta mʉsãde yʉ dujariburire yúka! ");
INSERT INTO sri_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ĩgʉ̃sã opʉ goemakʉ̃, ĩgʉ̃ doreaderosũta irirã, ʉsʉyarãkuma. Ĩgʉ̃sã irasirimakʉ̃ ĩãgʉ̃, ĩgʉ̃sã opʉ ĩgʉ̃sãrẽ moãboegʉ irirosũ ĩgʉ̃sãrẽ: “Baari peoro pʉro doarã aarika!” ãrĩgʉkumi ĩgʉ̃sãrẽ baari ejobu. ");
INSERT INTO sri_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ĩgʉ̃rẽ moãboerã ĩgʉ̃ ñami deko ããrĩmakʉ̃, o boyoripoe ããrĩmakʉ̃, ĩgʉ̃ goeburire õãrõ yúanerã ããrĩsĩã, ʉsʉyarãkuma. ");
INSERT INTO sri_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ire masĩka! Sugʉ wii opʉ ĩgʉ̃ya wiigue yajarimasʉ̃ ejaburi horare masĩgʉ̃, ĩgʉ̃rẽ yúkumi ĩgʉ̃ya wiigue ñajãburire kãmutabu. ");
INSERT INTO sri_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Irasirirã mʉsãde õãrõ yúka! Yʉ ããrĩpererã tĩ́gʉ̃ gũñaña marĩrõ aarigʉkoa. Irasirirã yaare iririre neõ piriro marĩrõ yʉre yúka mʉsã! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Pedro gapʉ sẽrẽñayupʉ: —Gʉa Opʉ, i keori merã weregʉ, ¿gʉa ditare weregʉ yári, o ããrĩpererãrẽ wereri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús gaji keori merã ãsũ ãrĩ wereyupʉ ĩgʉ̃sãrẽ doja: —Sugʉ moãboerimasʉ̃ ĩgʉ̃ opʉre bʉremugʉ̃ õãrõ pémasĩgʉ̃ ãsũ irikumi. Ĩgʉ̃ opʉ gajirogue waagʉ́, ĩgʉ̃rẽ: “Yaa wii marãrẽ õãrõ koreka!” ãrĩ píkumi. Irasirigʉ baaripoe ããrĩmakʉ̃, gajirã moãboerimasãrẽ baarire keoro ejokumi. ");
INSERT INTO sri_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Irasirigʉ, ĩgʉ̃ opʉ ĩgʉ̃ya wii goedujajamakʉ̃ ĩãgʉ̃, ĩgʉ̃ opʉ dorederosũta iriadi ããrĩsĩã, õãrõ ʉsʉyakumi. ");
INSERT INTO sri_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Diaye mʉsãrẽ werea. Ĩgʉ̃ irasirimakʉ̃ ĩãgʉ̃, ĩgʉ̃ opʉ ããrĩpereri ĩgʉ̃yare ĩgʉ̃rẽ koredoregʉ pígʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gajigʉ moãboerimasʉ̃ ñegʉ̃ gapʉ ãsũ irikumi. “Yʉ opʉ yoaripoe deyobemi”, ãrĩ gũñagʉ̃, gajirã ĩgʉ̃ opʉre moãboerãrẽ ʉ̃marẽ, nomedere ñerõ pábira, baa, iirí, mejãkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ĩgʉ̃ irasiriripoe gũñaña marĩrõ ĩgʉ̃ opʉ goejakumi. Ĩgʉ̃rẽ moãboegʉ gapʉ: “Ĩgʉ̃ iri hora goegʉkumi”, ãrĩmasĩbirikumi. Irasirigʉ ĩgʉ̃ opʉ goejagʉ, ĩgʉ̃ ñerõ irideare pégʉ, ĩgʉ̃rẽ bʉro wajamoãgʉkumi. Marĩpʉre bʉremumerãrẽ béorogue ĩgʉ̃rẽ béogʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Irasirigʉ sugʉ moãboerimasʉ̃ ĩgʉ̃ opʉ iridorerire masĩkeregʉ, õãrõ ãmubiri, irire neõ iribirimakʉ̃ ĩãgʉ̃, ĩgʉ̃ opʉ ĩgʉ̃rẽ wajamoã, bʉro tãrãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gajigʉ moãboerimasʉ̃ gapʉ ĩgʉ̃ opʉ iridorerire masĩbi, irire iribirimakʉ̃ ĩãgʉ̃, ĩgʉ̃ opʉ ĩgʉ̃rẽ sĩrũweyata tãrãgʉkumi. Marĩpʉ masakare ĩgʉ̃ iridorerire masĩmakʉ̃ yámi. Irasirigʉ õãrõ masĩgʉ̃rẽ ĩgʉ̃ iridorerire õãrõ iridoremi. Pʉrʉ ĩgʉ̃rẽ masĩnemomakʉ̃ irigʉ, ĩgʉ̃ iridea nemorõ õãrĩrẽ iridoremi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Pʉrʉ Jesús ĩgʉ̃sãrẽ ãrĩyupʉ doja: —Béoadeare peame merã soebéorosũ i ʉ̃mʉ marã ñerõ iririre béogʉ aarigʉ́ iribʉ. Dapagoragãta iri ñerĩ ããrĩpererire soebéomakʉ̃ ĩãdʉasiadáa. ");
INSERT INTO sri_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yʉ ñerõ tarigʉkoa. Yʉ ñerõ tariburire gũñagʉ̃, bʉro bʉjawereri merã ããrĩrikʉa. Irasirigʉ irire tariwerepeogʉgue bʉro ʉsʉyagʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mʉsã yʉre: “Ĩgʉ̃ i nikũguere aarigʉ́, masakare siñajãrĩ merã gãme ããrĩrikʉmakʉ̃ irigʉ aarimí”, ¿ãrĩ gũñarĩ? Irasũ ããrĩbea. Mʉsãrẽ werea. Masakare ĩgʉ̃sã basi gãme dʉkawarimakʉ̃ irigʉ aaribʉ́. Irasirirã surãyeri yʉre bʉremurãkuma. Gajirã yʉre bʉremubirikuma. ");
INSERT INTO sri_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dapagã merã su wii marã su mojõ marã yaa kerere péadero pʉrʉ, ĩgʉ̃sã basi gãme dʉkawarirãkuma. Ʉrerã, pẽrã merã, pẽrã, ʉrerã merã gãme ĩãturirãkuma. ");
INSERT INTO sri_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Surãyeri masaka yʉre bʉremunʉgãdero pʉrʉ, gajirã yʉre bʉremubiridero pʉrʉ, ãsũ waarãkuma. Sugʉ ĩgʉ̃ magʉ̃rẽ ĩãturigʉkumi yʉre bʉremumakʉ̃ ĩãgʉ̃. Gajigʉ ĩgʉ̃ pagʉre ĩãturigʉkumi. Gajigo igo magõrẽ ĩãturigokumo. Gajigo igo pagore ĩãturigokumo. Sugo mʉ́ñekõ igo bepore ĩãturigokumo. Sugo bepo igo mʉ́ñekõrẽ ĩãturigokumo yʉre bʉremumakʉ̃ ĩãgõ, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pʉrʉ Jesús masakare ãsũ ãrĩ wereyupʉ doja: —Mʉsã abe ñajãrõ gapʉ ĩĩmikãyeborire ĩãrã: “Deko merẽburo yáa”, ãrã. Mʉsã ãrãderosũta waáa. ");
INSERT INTO sri_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sur gapʉ merã mirũ aarimakʉ̃: “Asirinʉ ããrĩrokoa”, ãrã. Mʉsã ãrãderosũta asirinʉ ããrã. ");
INSERT INTO sri_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mʉsã irikatorikʉrã, i nikũmarẽ, ʉ̃marõmarẽ ĩãrã: “Õãrĩnʉ, o ñerĩnʉ waarokoa”, ãrĩ masĩa. Irire õãrõ masĩkererã, ¿nasirirã inʉrĩrẽ Marĩpʉ turari merã yʉ iri ĩmurĩ gapʉre ĩãrã, neõ õãrõ pémasĩberi? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Irasũ ãrĩ odo, ãsũ ãrĩnemoyupʉ doja: —¿Mʉsã diayema iririre ĩã beyemasĩberi dapa? ");
INSERT INTO sri_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sugʉ mʉsãrẽ weresãdʉamakʉ̃, ĩgʉ̃ merã oparã pʉrogue waarã́, ĩgʉ̃rẽ: “Dupaturi irasũ iribirikoa”, ãrĩ gãme ãmuka! Mʉsã ĩgʉ̃rẽ ãmubirimakʉ̃, weresãrĩrẽ beyerimasʉ̃guere mʉsãrẽ weresãgʉkumi. Pʉrʉ beyerimasʉ̃ mʉsãrẽ peresu iridoregʉ, suraraguere wiagʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mʉsãrẽ werea. Beyerimasʉ̃ mʉsãrẽ wajaridorerire mʉsã wajaripeobirimakʉ̃, neõ mʉsãrẽ wiubirikumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jesús irasũ ãrĩripoe gajirã ĩgʉ̃rẽ ãsũ ãrĩ wereñurã: —Galilea marã Marĩpʉ ĩũrõ waibʉre wẽjẽ, soepeo bʉremuripoe Pilato gapʉ ĩgʉ̃sãrẽ wẽjẽyupʉ. Ĩgʉ̃ irasũ wẽjẽmakʉ̃, waibʉ dí merã masaka dí morẽãkõãyuro, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ãrĩyupʉ: —Pilato wẽjẽnerãrẽ, ¿naásũ gũñarĩ? ¿Ĩgʉ̃sã irasũ wẽjẽsũrã, gajirã Galilea marã nemorõ ñerã ããrĩdea waja boayuri? ");
INSERT INTO sri_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ããrĩbea. Mʉsãrẽ werea. Mʉsãde ñerĩ iririre bʉjaweremerã, mʉsã gũñarĩrẽ gorawayumerã, boarã, perebiri peamegue waarãkoa. ");
INSERT INTO sri_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Irinʉgue gajirã dieciocho masakare Siloé wãĩkʉri wii ʉ̃marĩ wii ĩgʉ̃sã weka tʉridija, tãũ wẽjẽyuro. ¿Naásũ gũñarĩ mʉsã ĩgʉ̃sãrẽ waadeare? ¿Ĩgʉ̃sã irasũ boarã, gajirã Jerusalén marã nemorõ ñerã ããrĩdea waja boayuri? ");
INSERT INTO sri_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ããrĩbea. Mʉsãrẽ werea. Mʉsãde ñerĩrẽ bʉjaweremerã, mʉsã gũñarĩrẽ gorawayumerã, boarã, perebiri peamegue waarãkoa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús ĩgʉ̃sãrẽ irasũ ãrĩ odo, keori merã wereyupʉ: —Pooe opʉ ĩgʉ̃ya pooegue ĩgʉ̃ otedi higueragʉ wãĩkʉdire opakumi. Sunʉ: “Dʉkakʉkoa”, ãrĩ, ĩãgʉ̃ waakumi. Neõ bokabirikumi. Dʉka marĩkoa. ");
INSERT INTO sri_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bokabirisĩã, iri pooe moãgʉ̃rẽ werekumi: “Ĩãka! Ʉre bojorigora igʉ dʉkare ãmadáa. Dʉka máa. Irasirigʉ irigʉre pábéokõãka! Dʉka marĩkerero, gajino oteboaderore kãmutanía”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃rẽ moãboegʉ ãsũ ãrĩkumi: “Yʉ opʉ, i bojorigora tamerãrẽ níñaburo dapa. Yʉ irigʉ pʉrore nikũrẽ sea odo, waibʉ gʉra merã ũjãtũñagʉra. ");
INSERT INTO sri_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yʉ irasũ iriadero pʉrʉ, gajipoe iriro dʉkakʉbukoa. Dʉka marĩmakʉ̃ ĩãgʉ̃, pábéodoreka!” ãrĩkumi, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sunʉ judío masaka siñajãrĩnʉ ããrĩmakʉ̃, Jesús ĩgʉ̃sã nerẽrĩ wiigue buegʉ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Iro sugo nomeõ dieciocho bojorigora pũrĩrikʉgo ããrĩyupo. Wãtĩ igore dupamutĩrõ nímakʉ̃ iriyupʉ. Irasirigo diaye nímasĩbiriyupo. ");
INSERT INTO sri_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Igo irasũ ããrĩmakʉ̃ ĩãgʉ̃, Jesús igore: “Aarika!” ãrĩ siiuyupʉ: —Nomeõ, mʉ pũrĩrikʉri tausũsiáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Irasũ ãrĩgʉ̃ta, igore ĩgʉ̃ya mojõrĩ merã ñapeoyupʉ. Ĩgʉ̃ ñapeomakʉ̃ta, diaye níyupo. Pʉrʉ Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩnʉgãyupo. ");
INSERT INTO sri_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesús siñajãrĩnʉ igore taumakʉ̃ ĩãgʉ̃, iri nerẽrĩ wii opʉ gapʉ ĩgʉ̃ merã guayupʉ. Irasirigʉ, masakare ãsũ ãrĩyupʉ: —Semanarikʉ, marĩ moãrĩnʉrĩ, su mojõma pere gaji mojõ suru pẽrẽbejarinʉrĩ ããrã. Irasirirã mʉsã pũrĩrikʉrã taudoredʉarã, irinʉrĩrẽ taudorerã aarika! Dapagãno marĩ siñajãrĩnʉrẽ irinorẽ iribirikõãrõ gããmea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, marĩ Opʉ Jesús ãsũ ãrĩyupʉ: —Mʉsã irikatorikʉrã ããrã. Mʉsã wekʉre, o burrore oparã siñajãrĩnʉ ããrĩkeremakʉ̃, ĩgʉ̃sãrẽ sʉadeadarire kura, ĩgʉ̃sãrẽ deko iirídorerã ãĩbuáa. ");
INSERT INTO sri_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Igore Abraham parãmeõ ããrĩturiagore wãtẽa opʉ Satanás dieciocho bojorigora pũrĩrikʉmakʉ̃ irimi. Iro merẽ siñajãrĩnʉ ããrĩmakʉ̃, ¿igore taubirikõãrõ gããmeadayuri? ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, Jesúre ĩãturirã ããrĩpererã gʉyasĩrĩpereakõãñurã. Gajirã gapʉ ããrĩpereri Jesús õãrĩ iririre ĩãrã, ʉsʉyañurã. ");
INSERT INTO sri_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pʉrʉ ãrĩyupʉ doja: —Marĩpʉ ĩgʉ̃yarãrẽ doreri, ¿ñeéno irirosũ ããrĩkuri? ¿Ñeéno keori merã weregʉkuri? ");
INSERT INTO sri_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I irirosũ ããrã. Suye oteriye mostaza wãĩkʉri yegãrẽ oterosũ ããrã. Iri yegãrẽ sugʉ masakʉ ĩgʉ̃ya pooegue otekumi. Ĩgʉ̃ oteadero pʉrʉ, yukʉ wádi irirosũ puri, masãkoa. Irasirirã mirã wárã irigʉ dʉpʉrigue ĩgʉ̃sãya surí suakuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Dupaturi keori merã werenemoyupʉ: —Marĩpʉ ĩgʉ̃yarãrẽ dorerire, ¿ñeéno keori merã werenemogʉkuri? ");
INSERT INTO sri_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I irirosũ ããrã. Pã́ wemasãrĩ morẽrĩ poga irirosũ ããrã. Sugo nomeõ pã́ irigo, mérõgã pã́ wemasãmakʉ̃ iriri poga merã trigo pogare morẽkumo. Igo irasũ morẽadero pʉrʉ, iri poga mérõgã ããrĩkerero, wemasãseyakõãkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pʉrʉ Jesús Jerusalẽ́gue waagʉ́, paga makãrĩrẽ, mʉtã makãrĩgãdere buetariwãgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Irogue sugʉ masakʉ ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽñayupʉ: —Yʉ Opʉ, ¿Marĩpʉ perebiri peamegue waabonerãrẽ taumurã mérãgã ããrĩkuri? ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús i keori merã wereyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Marĩpʉ pʉrogue ñajãdʉarã, ĩgʉ̃yare irika! Mʉsãrẽ werea. Wárã ĩgʉ̃ pʉrogue ñajãdʉakererã, ñajãmasĩbirikuma. Irogue ñajãdʉamakʉ̃ diasagoráa. Eyabiri makãpʉro ñajãrõ irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Marĩpʉ, sugʉ wii opʉ irirosũ ããrĩ́mi. Wii opʉ wãgãnʉgã, makãpʉrore biadero pʉrʉ, mʉsã gapʉ makãpʉrogue ããrĩrã́ ĩgʉ̃ya wiire ñajãdʉarã, ãsũ ãrĩrãkoa ĩgʉ̃rẽ: “Gʉa opʉ, gʉare tũpãsóogʉ aarika!” ãrĩrãkoa. Irasũ ãrĩkeremakʉ̃, wii opʉ gapʉ: “Mʉsãrẽ masĩbea. Noó marã ããrĩrã́ ããrĩkoa”, ãrĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ĩgʉ̃ irasũ ãrĩmakʉ̃, mʉsã gapʉ ãsũ ãrĩrãkoa: “Gʉa mʉ merãta baa, iirí iribʉ. Gʉaya makãguedere buegorenabʉ”, ãrĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mʉsã irasũ ãrĩmakʉ̃, ãsũ yʉjʉgʉkumi: “‘Mʉsãrẽ masĩbea. Noó marã ããrĩrã́ ããrĩkoa’ ãrĩsiáa. Mʉsã ñerõ irirã ããrã. Irasirirã ããrĩpererã waaka! Yʉ pʉrore wirika!” ãrĩgʉkumi wii opʉ mʉsãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Irasirirã, Abraham, Isaac, Jacob, ããrĩpererã Marĩpʉya kerere weredupiyunerã merã Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ããrĩmakʉ̃ ĩãrã, mʉsã gapʉ makãpʉrogue béosũnerã ããrĩsĩã, pũrĩsũrã mʉsãya guikare kũrĩduútú orerãkoa. ");
INSERT INTO sri_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Irasũ waaripoere norte marã, sur marã, abe mʉrĩriro marã, abe ñajãrõ marã Marĩpʉ ĩgʉ̃yarãrẽ dorerogue eja, ʉsʉyari merã baa doanírãkuma. ");
INSERT INTO sri_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Irasirirã dapagorare ubu ããrĩrã́, pʉrʉguere oparã dujarãkuma. Dapagorare: “Oparãgora ããrã”, ãrĩrã gapʉ pʉrʉguere ubu ããrĩrã́ dujarãkuma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesús irasũ ãrĩripoe surãyeri fariseo bumarã ĩgʉ̃ pʉrogue eja, ãsũ ãrĩñurã: —Herodes mʉrẽ wẽjẽdʉami. Irasirigʉ gajirogue waaka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús gapʉ ĩgʉ̃sãrẽ yʉjʉyupʉ: —Ãsũ ãrĩ wererã waaka, ĩgʉ̃ ãrĩkatorikʉgʉre: “Dapagãrẽ, ñamigãdere ãsũta irigʉra. Wãtẽãrẽ béowiugʉkoa. Pũrĩrikʉrãrẽ taugʉkoa. Irasirigʉ ñamigã sinʉ gapʉ odogʉkoa”, ãrãmi, ãrĩ wereka ĩgʉ̃rẽ! ");
INSERT INTO sri_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dapagã, ñamigã, ñamigã sinʉ gapʉdere Jerusalẽ́gue waagʉra. Iro marã Marĩpʉya kerere weredupiyunerãrẽ wẽjẽnerã ããrĩmá. Irasirigʉ yʉre Marĩpʉya kerere weredupiyugʉre ĩgʉ̃sã wẽjẽbure iri makãgue ããrĩrṍ gããmea. ");
INSERT INTO sri_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Mʉsã Jerusalén marã Marĩpʉya kerere weredupiyurimasãrẽ wẽjẽkõãa. Ĩgʉ̃ iriunerãrẽ ʉ̃tãyeri merã dea wẽjẽa. Wári yʉ mʉsãrẽ, ãgãbo igo pũrãrẽ, igoya kẽdʉpʉri merã neeõnúrõsũ neeõnúdʉadibʉ. Mʉsã gapʉ yʉ irasũ irimakʉ̃ neõ gããmebiribʉ. ");
INSERT INTO sri_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Irasiriro mʉsã ããrĩrĩ́ makã, béodea makã dujarokoa. Mʉsãrẽ diayeta werea. Mʉsã yʉre dupaturi ĩãbirikoa. Pʉrʉgue mʉsã: “Marĩpʉ iriudi õãtarigʉ õãrõ aariburo”, ãrĩrã, yʉre dupaturi ĩãrãkoa doja, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sunʉ Jesús, judío masaka siñajãrĩnʉ ããrĩmakʉ̃, sugʉ fariseo bumarã opʉya wiigue baagʉ waayupʉ. Irogue ããrĩrã́ gajirã fariseo bumarã ĩgʉ̃rẽ ĩãnʉrʉ̃níkõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ĩgʉ̃sã baaro pʉrogue sugʉ masakʉ bijiri pũrĩrikʉgʉ Jesús diaye ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Irasirigʉ Jesús, Moisés gojadeare buerimasãrẽ, fariseo bumarãdere ãsũ ãrĩ sẽrẽñayupʉ: —Siñajãrĩnʉ ããrĩmakʉ̃, ¿sugʉ pũrĩrikʉgʉre taudoreri, o taudoreberi? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, neõ yʉjʉbiriñurã. Ĩgʉ̃sã yʉjʉbirimakʉ̃ ĩãgʉ̃, Jesús bijiri pũrĩrikʉgʉre tauyupʉ. Odo, ĩgʉ̃rẽ: “Õãrõ waaka!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pʉrʉ ĩgʉ̃sãrẽ sẽrẽñayupʉ doja: —Siñajãrĩnʉ ããrĩkeremakʉ̃, mʉsãyagʉ burro, o mʉsãyagʉ wekʉ gobegue meéñajãdire ĩãrã, ¿mata ãĩ wiubiribukuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ĩgʉ̃sã gapʉ, ĩgʉ̃ irasũ ãrĩ sẽrẽñarĩrẽ yʉjʉmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús fariseo bumarã opʉya wiigue ããrĩgʉ̃́, iri wiimʉ siiuanerã ejamakʉ̃ ĩãyupʉ. Ĩgʉ̃sã õãrĩ doaripẽrĩrẽ beyeñurã, oparã irirosũ doamurã. Ĩgʉ̃sã irasirimakʉ̃ ĩãgʉ̃, Jesús i keori merã wereyupʉ ĩgʉ̃sã ããrĩpererãrẽ: ");
INSERT INTO sri_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—Sugʉ wii opʉ mojõsʉari bosenʉ irigʉ mʉsãrẽ siiuadero pʉrʉ, mʉsã ĩgʉ̃ya wiigue ejarã, oparã doarire beye doabirikõãka! Iri wii opʉ gajirã ĩgʉ̃ siiuanerãrẽ mʉsã nemorõ goepeyarã ejamakʉ̃ ĩãgʉ̃, mʉsãrẽ ãsũ ãrĩgʉkumi: “Ĩĩsã gapʉre mʉsã doarire sĩka! Mʉsã gapʉ sõõgue doarã waaka!” ãrĩgʉkumi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, mʉsã gʉyasĩrĩrĩ merã ubu ããrĩrã́ doarigue doarã waarãkoa. ");
INSERT INTO sri_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Irasirirã, wii opʉ mʉsãrẽ siiumakʉ̃, ubu ããrĩrã́ doarigue doaka! Mʉsã irasirimakʉ̃ ĩãgʉ̃, iri wii opʉ mʉsãrẽ: “Oparã doarigue doarã aarika!” ãrĩgʉkumi. Ĩgʉ̃ irasirimakʉ̃ ĩãrã, gajirã ĩgʉ̃ siiuanerã mʉsãrẽ bʉremurĩ merã ĩãrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sugʉ ĩgʉ̃ basi: “Gajirã nemorõ ããrã”, ãrĩ gũñagʉ̃norẽ Marĩpʉ ĩgʉ̃rẽ ubu ããrĩgʉ̃́ dujamakʉ̃ irigʉkumi. Gajigʉ: “Gajirã nemorõ ããrĩbea”, ãrĩ gũñagʉ̃ gapʉre Marĩpʉ ĩgʉ̃rẽ gajirã nemorõ ããrĩmakʉ̃ irigʉkumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Irasũ ãrĩ odo, ĩgʉ̃rẽ siiuadire ãsũ ãrĩyupʉ: —Mʉ bosenʉ irigʉ, mʉ merãmarãrẽ, mʉ pagʉpũrãrẽ, mʉyarãrẽ, doebiri oparãrẽ siiubirikõãka! Mʉ ĩgʉ̃sãrẽ siiumakʉ̃, mʉrẽ ĩgʉ̃sãde siiu gãmibukuma. Ĩgʉ̃sã irasiriri merã ĩgʉ̃sã baadeare mʉrẽ ejo gãmibukuma. ");
INSERT INTO sri_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mʉ bosenʉ irigʉ, boporãrẽ, poyarimasãrẽ, guburi bʉanerãrẽ, koye ĩãmerãrẽ siiuka! ");
INSERT INTO sri_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mʉ irasirimakʉ̃, Marĩpʉ mʉrẽ õãrõ irigʉkumi. Ĩgʉ̃sãrẽ mʉ siiudea waja, ĩgʉ̃sã mʉrẽ siiu gãmibirikuma. Irasirigʉ Marĩpʉ diayemarẽ irirã boanerãrẽ masũrĩnʉ ããrĩmakʉ̃, mʉrẽ õãrĩrẽ wajarigʉkumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, sugʉ irogue baa doanígʉ̃ ĩgʉ̃rẽ ãrĩyupʉ: —Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ĩgʉ̃ pʉro baa doanírã bʉro ʉsʉyarãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús keori merã wereyupʉ ĩgʉ̃rẽ: —Sugʉ wári bosebaarinʉ irigʉ wárã masaka siiukumi. ");
INSERT INTO sri_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ĩgʉ̃ siiuadero pʉrʉ, bosenʉ ããrĩrĩ́nʉrẽ ĩgʉ̃rẽ moãboegʉre ĩgʉ̃ siiuanerãrẽ weredoregʉ iriukumi. “Aarika! Ããrĩpereri bosenʉmarẽ ãmusiami”, ãrĩ weredorekumi. ");
INSERT INTO sri_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ĩgʉ̃ irire weremakʉ̃ pérã, ããrĩpererã: “Masĩña máa, waabirikoa”, ãrĩkuma. Ĩgʉ̃ siiupʉrorisũadi moãboegʉre ãsũ ãrĩkumi: “Dapagorata nikũ wajari odoa. Irore ĩãgʉ̃ waabu yáa. Irasirigʉ mʉ opʉre: ‘Masĩña máa, waabirikoa’, ãrãmi, ãrĩ wereka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gajigʉ ãsũ ãrĩkumi: “Wekʉa pe mojõmarã wajariabʉ. Ĩgʉ̃sãrẽ keoñagʉ̃ waabu yáa. Irasirigʉ mʉ opʉre: ‘Masĩña máa, waabirikoa’, ãrãmi, ãrĩ wereka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gajigʉ ãsũ ãrĩkumi: “Yʉ dapagorata mojõsʉa odoa. Irasirigʉ iri bosenʉrẽ waabirikoa”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃, moãboegʉ gapʉ goedujáa, ĩgʉ̃ opʉre ĩgʉ̃sã ãrãdeare werekumi. Ĩgʉ̃ weremakʉ̃ pégʉ, opʉ bʉro gua, ãsũ ãrĩkumi ĩgʉ̃rẽ moãboegʉre: “Murĩgoráa. Makã dekoma maarĩ́gue ããrĩrã́rẽ ãmagʉ̃́ waaka! Irasirigʉ boporãrẽ, poyarimasãrẽ, koye ĩãmerãrẽ, gubu bʉanerãrẽ mumurõ merã yaa wiigue ãĩrika!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pʉrʉ moãboegʉ ĩgʉ̃ opʉre werekumi: “Yʉ opʉ, mʉ doreaderosũta masakare siiuabʉ. Wii gapʉre ʉtʉribema dapa”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ opʉ ĩgʉ̃rẽ dorekumi doja: “Maarĩ́gue waaka! Paga maarĩ́gue, mʉtã maarĩ́gãgue mʉ bokajarãrẽ turaro merã siiuwãgãrika! Irasirimakʉ̃, yaa wiire ʉtʉrirãkuma. ");
INSERT INTO sri_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Diayeta mʉrẽ werea. Neõ sugʉ yʉ siiupʉroriadinerã baaboadideare mérõgã baabirikuma”, ãrĩkumi opʉ ĩgʉ̃rẽ moãboegʉre, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wárã masaka Jesúre tʉyañurã. Irasirigʉ ĩgʉ̃sãrẽ gãmenʉgã ĩã, ãsũ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Sugʉ yaa buerire buetʉyadʉagʉ, ĩgʉ̃ pagʉre, pagore, marãpore, pũrãrẽ, pagʉpũrãrẽ, pagʉpũrã nomerẽ, ĩgʉ̃ basi maĩrõ nemorõ yʉ gapʉre maĩrõ gããmea. ");
INSERT INTO sri_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sugʉ yʉre tʉyadʉari waja curusague pábiatú wẽjẽsũbu irirosũ ããrĩkeregʉ, yʉre neõ piriro marĩrõ yʉre tʉyaníkõãburo. Yʉre tʉyadʉabi, yʉ buegʉ ããrĩmasĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sugʉ, mʉsã watopegue ããrĩgʉ̃́, ʉ̃marĩ wiire iriburo dupiyuro: “¿Ñeéno merã iripeogʉkuri?” ãrĩ gũñagʉ̃, iri wiire iriburi wajakʉburire keopʉrorikumi. ");
INSERT INTO sri_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wajakʉburire keopʉroribi, iri wiire iripeobirikumi. Ĩgʉ̃ iripeobirimakʉ̃ ĩãrã, gajirã ĩgʉ̃rẽ bʉridakuma. ");
INSERT INTO sri_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ĩãka! Ĩĩ wiire iriadiñumi. Iripeomasĩbiriñumi”, ãrĩ bʉridakuma ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Su nikũ marã opʉ, gajigʉ opʉ merã gãmewẽjẽburo dupiyuro ĩgʉ̃yarã surarare keopʉrorikumi. “¿Yʉ diez mil surara merã, gajigʉ veinte mil surara opagʉ merã gãmewẽjẽgʉ̃ waagʉ́ bokatĩũbukuri?” ãrĩ gũñakumi. ");
INSERT INTO sri_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Keoña: “Bokatĩũbirikoa”, ãrĩkumi. Irasirigʉ, gajigʉ opʉ ĩgʉ̃yarã surara merã gãmewẽjẽgʉ̃ aarimakʉ̃, yoarogue ĩgʉ̃ ããrĩmakʉ̃ta: “Gãmewẽjẽbirikõãrã”, ãrĩ kere iriukumi ĩgʉ̃yagʉre. ");
INSERT INTO sri_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","I irirosũta yʉ buerã ããrĩdʉarã mʉsã iriburire õãrõ gũñadupiyuro gããmea. Ãsũ ããrã. Mʉsã gããmerĩrẽ piridʉamerã yʉ buerã ããrĩmasĩbea. ");
INSERT INTO sri_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Moã õãrõ okari ããrĩmakʉ̃ õãgoráa. Moã okadea okabirimakʉ̃, dupaturi okamakʉ̃ irimasĩña máa. ");
INSERT INTO sri_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Moã okabirimakʉ̃ õãbea. Béokõãrõ gããmea. Irasirirã mʉsã moã okabirimakʉ̃ béosũburi irirosũ neõ ããrĩbirikõãka! Gãmipũrĩ oparã, ire õãrõ péka! ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gajinʉ wárã romano marã opʉre niyeru wajaseabosarimasã, ñerõ iririmasãde Jesús pʉro ĩgʉ̃ buerire pérã ejañurã. ");
INSERT INTO sri_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ĩgʉ̃sã irasũ ejamakʉ̃ ĩãrã, fariseo bumarã, Moisés gojadeare buerimasãde Jesúre ãsũ ãrĩ werewʉañurã: —Ĩĩ ñerãrẽ bokatĩrĩñeã, ĩgʉ̃sã merã baami, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús i keori merã wereyupʉ ĩgʉ̃sãrẽ: ");
INSERT INTO sri_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Oveja korerimasʉ̃ cien oveja opagʉ, sugʉ oveja dederimakʉ̃ ĩãgʉ̃, noventa y nueve ovejare makã tʉro ĩgʉ̃sã baarogue duripíkõã, dederiadire ãmagʉ̃́ waakumi. Ĩgʉ̃rẽ bokagʉgue ãmuduúkumi. ");
INSERT INTO sri_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ĩgʉ̃rẽ bokagʉ, ʉsʉyari merã ĩgʉ̃rẽ ãĩkõã, ");
INSERT INTO sri_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ĩgʉ̃ya wiigue ãĩ dujáakõãkumi. Ãĩ dujaja, ĩgʉ̃ pʉro ããrĩrã́rẽ, ĩgʉ̃yarãrẽ siiu neeõkumi. “Yaagʉ oveja dederiadire bokáabʉ. Irasirirã yʉ merã ʉsʉyaka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","’Mʉsãrẽ werea. Sugʉ ñerõ irigʉ, oveja dederiadi irirosũ ããrĩ́mi. Irasirigʉ ĩgʉ̃ ñerõ iririre bʉjawere, ĩgʉ̃ gũñarĩrẽ gorawayumakʉ̃, Marĩpʉ pʉro ããrĩrã́ bʉro ʉsʉyama. Gajirã wárã masaka ĩgʉ̃sã noventa y nueve oveja, makã tʉrogue duripínerã irirosũ ããrĩrã́, ãsũ ãrĩ gũñadima: “Ñerõ iribea gʉa gapʉ. Irasirirã gʉa ñerõ iririre bʉjawereri opabea”, ãrĩ gũñama. Ĩgʉ̃sã irasũ ãrĩ gũñamakʉ̃, Marĩpʉ pʉro ããrĩrã́ ʉsʉyabema. ");
INSERT INTO sri_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Sugo nomeõ pe mojõma niyeru koeri wajapari koeri opakumo. Su koe dederimakʉ̃ ĩãgõ, sĩãgodirure sĩãgo, wiire ooa, õãrõ ãmapeokumo. Iri koere bokagogue ãmaduúkumo. ");
INSERT INTO sri_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iri koere bokago, igo pʉro ããrĩrã́rẽ, igoyarãrẽ siiu neeõkumo. “Yaa niyeru koe, dederiadea koere bokáabʉ. Irasirirã yʉ merã ʉsʉyaka!” ãrĩkumo. ");
INSERT INTO sri_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mʉsãrẽ werea. Sugʉ ñerĩrẽ irigʉ ĩgʉ̃ ñerĩ iririre bʉjawere, ĩgʉ̃ gũñarĩrẽ gorawayumakʉ̃, Marĩpʉre wereboerã bʉro ʉsʉyarãkuma. Ĩgʉ̃ dederiboadi dederibirimakʉ̃ ĩãrã, bʉro ʉsʉyarãkuma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Irasũ ãrĩ odo, Jesús gaji keori merã bueyupʉ doja: —Sugʉ masakʉ pẽrã ʉ̃ma pũrãkʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sunʉ pagʉmʉ gapʉ pagʉre ãsũ ãrĩkumi: “Aʉ, mʉ boagʉ, yʉre sĩburire dapagorata yʉre sĩweoka!” ãrĩkumi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ pũrã pẽrãguereta ĩgʉ̃ oparire dʉkawa, sĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mérõgã pʉrʉta, pagʉmʉ gapʉ ĩgʉ̃ pagʉ sĩadeare ããrĩpereri duapeokõãkumi. Pʉrʉ ĩgʉ̃ duadea waja niyeru merã yoarogue gaji nikũgue waakõãkumi. Irogue eja, ĩgʉ̃ya niyerure ñerõ iriri merã irisiripeokõãkumi. ");
INSERT INTO sri_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ĩgʉ̃ya niyeru irisiribéoadero pʉrʉ, iri nikũguere baari pereakõãkoa. Irasirigʉ bʉro ʉaboapʉrorinʉgãkumi. ");
INSERT INTO sri_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Irasirigʉ, sugʉ iri nikũmʉ pʉro, moãrĩ ãmagʉ̃́ waakumi. Ĩgʉ̃ gapʉ ĩgʉ̃rẽ ĩgʉ̃ya moãrĩ ããrĩrṍgue yeseare koredoregʉ iriukumi. ");
INSERT INTO sri_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yapidʉagʉ, yeasea baarireta baadʉadikumi. Neõ gajirã ĩgʉ̃rẽ baari ejobirikuma. ");
INSERT INTO sri_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Irasirigʉ ãsũ ãrĩ gũñanʉgãkumi: “Yʉpʉya wiire wárã ĩgʉ̃rẽ moãboerã ããrĩkeremakʉ̃, baari wáro dʉyanabʉ. Yʉ gapʉ õõguere bʉro ʉaboari merã kõmogʉ̃gue irikoa. ");
INSERT INTO sri_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Irasirigʉ yʉpʉ pʉrogue goedujáagʉra doja. Ãsũ ãrĩgʉra ĩgʉ̃rẽ: ‘Aʉ, yʉ Marĩpʉ ĩũrõrẽ ñerõ irikubʉ. Mʉdere irasũta irikubʉ’, ãrĩgʉra. ");
INSERT INTO sri_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","‘Ñegʉ̃ ããrã. Yʉre: “Yʉ magʉ̃ ããrã”, ãrĩbirikõãka! Irasirigʉ yʉre sugʉ mʉrẽ moãboegʉ irirosũ opaka!’ ãrĩgʉra yʉpʉre”, ãrĩ gũñakumi. ");
INSERT INTO sri_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Irasũ ãrĩ gũña, maague waa, ĩgʉ̃ pagʉya wiigue goedujáakõãkumi. ’Ĩgʉ̃ yoarogue aarimakʉ̃ta, ĩgʉ̃ pagʉ ĩgʉ̃rẽ ĩã, bʉro bopoñakumi. Pʉrʉ ũmawãgã, ĩgʉ̃rẽ bokatĩrĩ, pábʉa, mimi irikumi. ");
INSERT INTO sri_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Irasirigʉ ĩgʉ̃ pagʉre ãrĩkumi: “Aʉ, yʉ Marĩpʉ ĩũrõrẽ ñerõ irikubʉ. Mʉdere irasũta irikubʉ. Ñegʉ̃ ããrã. Yʉre: ‘Yʉ magʉ̃ ããrã’, ãrĩbirikõãka! Irasirigʉ yʉre sugʉ mʉrẽ moãboegʉ irirosũ opaka!” ãrĩkumi ĩgʉ̃ pagʉre. ");
INSERT INTO sri_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ĩgʉ̃ irasũ ãrĩkeremakʉ̃, ĩgʉ̃ pagʉ gapʉ ĩgʉ̃rẽ moãboerãrẽ ãrĩkumi: “Murĩgoráa. Surí õãrĩrẽ ãĩrã waa, sãka! Mojõsũrũ túsãrĩ berodere sãka! Gubu surídere sãka! ");
INSERT INTO sri_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wekʉ majĩgʉ̃ õãrõ diíkʉgʉre ãĩrã waa, wẽjẽka, ĩgʉ̃rẽ baa, yʉ magʉ̃ goejari bosenʉ irimurã. ");
INSERT INTO sri_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ĩĩ yʉ magʉ̃ boakõãkumi, ãrãdi goejami. Okami. Dederidire marĩ bokáa”, ãrĩkumi. Pʉrʉ bosenʉ irinʉgãkuma. ");
INSERT INTO sri_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ĩgʉ̃sã bosenʉ iriripoe, masã tĩ́gʉ̃ gapʉ pooegue ããrĩkumi. Irogue ããrãdi goedujarigʉ, wii pʉro ejagʉ, ĩgʉ̃sã bayarire pékumi. ");
INSERT INTO sri_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ĩgʉ̃sã bayamakʉ̃ pégʉ, sugʉ ĩgʉ̃ pagʉre moãboegʉre siiu, sẽrẽñakumi: “¿Naásũ waáari wiiguere?” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Mʉ pagʉmʉ pũrĩrĩ marĩgʉ̃, õãgʉ̃ goejami. Irasirigʉ mʉpʉ ʉsʉyari merã wekʉ majĩgʉ̃ diíkʉgʉre wẽjẽdoreami”, ãrĩ yʉjʉkumi moãboegʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ĩgʉ̃ irasũ ãrĩ weremakʉ̃ pégʉ, masã tĩ́gʉ̃ gapʉ bʉro guakumi. Wiigue ñajãbirikumi. Ĩgʉ̃ ñajãbirimakʉ̃ ĩãgʉ̃, ĩgʉ̃ pagʉ wiria, ĩgʉ̃rẽ: “Ñajãrika!” ãrãdikumi. ");
INSERT INTO sri_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Aʉ, péka! Yʉ wári bojori mʉ dorerire neõ suñarõ tarinʉgãrõ marĩrõ mʉrẽ moãbosabʉ. Yʉ irasirikeremakʉ̃, neõ sugʉ waibʉ sĩbiribʉ, yʉ merãmarã merã bosenʉ iriburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ĩĩ mʉ magʉ̃ gapʉ ñerã nome merã mʉyare irisiribéodi ããrĩmí. Irire irisiribéo odo, ĩgʉ̃ goejamakʉ̃, wekʉ diíkʉgʉre ĩgʉ̃rẽ wẽjẽ, ejoa”, ãrĩkumi ĩgʉ̃ pagʉre. ");
INSERT INTO sri_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Makʉ, mʉ yʉ merã ããrĩníkõãa. Irasiriro ããrĩpereri yʉ opari mʉya dita ããrã. ");
INSERT INTO sri_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ĩĩ mʉ pagʉmʉ boakõãkumi, ãrãdi goejami. Okami. Dederidire marĩ bokáa. Irasirirã ĩgʉ̃ goejamakʉ̃, marĩ bosenʉ iri ʉsʉyamakʉ̃ õãgoráa”, ãrĩkumi ĩgʉ̃ magʉ̃rẽ, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús irasũ ãrĩ odo, ĩgʉ̃ buerãrẽ i keori merã wereyupʉ: —Sugʉ masakʉ wári doebiri opagʉ ããrĩkumi. Irasirigʉ, ĩgʉ̃yare koregʉre opakumi. Gajirã gapʉ ĩgʉ̃ õãrõ korebirimakʉ̃ ĩãrã, ĩgʉ̃ opʉguere: “Mʉya niyerure irisirigʉ iriami”, ãrĩ weresãkuma. ");
INSERT INTO sri_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ĩgʉ̃sã weresãmakʉ̃ pégʉ, ĩgʉ̃yare koregʉre siiu: “Gajirã yaa niyeru mʉ irisiririre weresãma. Yaare mʉ moãrĩrẽ gojatúri pũrẽ yʉre ĩmuka! Irasirigʉ yaare korenemobirikõãka pama!” ãrĩkumi ĩgʉ̃ opʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ĩgʉ̃ irasũ ãrĩmakʉ̃, niyeru koregʉ ãsũ ãrĩ gũñakumi: “Yʉ opʉ yʉre béowiubu yámi. Yʉ turabea. Irasirigʉ turaro moãrĩrẽ bokatĩũbirikoa. Gajirãrẽ niyeru sẽrẽ doanígʉ̃, gʉyasĩrĩgorakoa. ¿Nasirigʉkuri yʉ?” ãrĩ gũñakumi. ");
INSERT INTO sri_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pʉrʉ gũñanemokumi doja: “Dapagorare yʉ iriburire masĩsiáa. Yʉre moãrĩ marĩmakʉ̃, yʉ ãsũ irimakʉ̃ ĩãrã, yʉre gajirã ĩgʉ̃sãya wiirigue ñajãdorerãkuma”, ãrĩ gũñakumi. ");
INSERT INTO sri_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Irasirigʉ, ĩgʉ̃ opʉre wajamorãrẽ sugʉno ditare siiu, sẽrẽñakumi ejapʉrorigʉre: “¿Yʉ opʉre noópa wajamorĩ mʉ?” ãrĩ sẽrẽñakumi. ");
INSERT INTO sri_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wajamogʉ̃ ĩgʉ̃rẽ yʉjʉkumi: “Cien dʉkari olivo wãĩkʉdi ʉyere wajamokoa”, ãrĩkumi. Ĩgʉ̃ irasũ ãrĩ weremakʉ̃, ãsũ ãrĩkumi ĩgʉ̃rẽ: “Doaka, murĩgoráa! Mʉ wajamorĩrẽ gojatúdea pũ, i pũ ããrã. Iri pũrẽ ãĩ, gaji pũguere cincuenta dʉkarita gojatúka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pʉrʉ gajigʉre sẽrẽñakumi: “¿Mʉkoa, noópa wajamorĩ?” ãrĩkumi. Wajamogʉ̃ ĩgʉ̃rẽ yʉjʉkumi: “Cien trigo ajuri wajamokoa”, ãrĩkumi. Ĩgʉ̃ irasũ ãrĩmakʉ̃, ãsũ ãrĩkumi ĩgʉ̃rẽ: “Mʉ wajamorĩrẽ gojatúdea pũ, i pũ ããrã. Iri pũrẽ ãĩ, gaji pũguere ochenta ajurita gojatúka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ĩgʉ̃ opʉ, ĩgʉ̃ irasũ õãrõ irikatomerẽmakʉ̃ ĩãgʉ̃: “Mʉ ñegʉ̃ ããrĩkeregʉ, mʉ masĩrĩ merã õãrõ niyerure moãmasĩa”, ãrĩkumi. I ʉ̃mʉgue marã Marĩpʉre masĩbirikererã, Marĩpʉyarã ĩgʉ̃sãya niyerure moãmasĩrõ nemorõ moãmasĩma, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Irasũ ãrĩ odo, ãsũ ãrĩ werenemoyupʉ: —Mʉsã i ʉ̃mʉma oparire boporãrẽ sĩka, mʉsãrẽ maĩburo, ãrĩrã! Mʉsã irasũ sĩmakʉ̃, mʉsã opadea pereadero pʉrʉ ʉ̃mʉgasigue mʉsã ejamakʉ̃, irogue ããrĩrã́ mʉsãrẽ ʉsʉyari merã bokatĩrĩñeãrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Sugʉ mérĩgã opari merã õãrõ irigʉ, wári opari merãdere õãrõ irigʉkumi. Gajigʉ mérĩgã opari merã õãrõ iribi, wári opari merãdere õãrõ iribirikumi. ");
INSERT INTO sri_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mʉsã i ʉ̃mʉma merã õãrõ iribirimakʉ̃, ¿noã Marĩpʉyare diaye õãrĩ oparire sĩbukuri mʉsãrẽ? ");
INSERT INTO sri_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Gajigʉyare mʉsã õãrõ iribirimakʉ̃, ¿noã mʉsã õãrõ ããrĩburire sĩbukuri mʉsãrẽ? ");
INSERT INTO sri_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Neõ sugʉ moãrĩmasʉ̃ pẽrã oparãrẽ moãboemasĩbirikumi. Sugʉ opʉre maĩgʉ̃, gajigʉ gapʉre maĩbirikumi, o sugʉ opʉre bʉremugʉ̃, gajigʉ gapʉre yʉjʉbirikumi. Ĩgʉ̃sã irirosũta niyerure maĩtarigʉ, Marĩpʉ gapʉre maĩbemi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, fariseo bumarã gapʉ niyerure maĩrã ããrĩsĩã, ĩgʉ̃rẽ bʉridañurã. ");
INSERT INTO sri_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ĩgʉ̃sã irasũ bʉridamakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ wereyupʉ: —Mʉsã, masaka ĩũrõrẽ õãrõ iriadáa. Ĩgʉ̃sã, mʉsã iririre ĩãrã: “Õãrã diayemarẽ irirã ããrĩ́ma”, ãrĩrĩrẽ bʉro pédʉáa. Marĩpʉ gapʉ mʉsã gũñarĩrẽ masĩmi. Masaka ĩgʉ̃sã basi iririre: “Õãtaria”, ãrĩ gũñadima. Marĩpʉ gapʉ ĩgʉ̃sã iririre: “Ñetaria”, ãrĩ ĩãmi. ");
INSERT INTO sri_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Juan masakare wãĩyedi ejaburo dupiyuro Marĩpʉ ĩgʉ̃ Moisére doreri pídea merã, ĩgʉ̃ya kerere weredupiyunerã buedea merã marĩrẽ doredi ããrĩmí. Dapagora gapʉre Juan ejadero pʉrʉ, Marĩpʉya õãrĩ kerere, ĩgʉ̃yarãrẽ dorerire yʉ werea. Yʉ irire weremakʉ̃ pérã, masaka ĩgʉ̃sã turari merã ĩgʉ̃yarãrẽ doreroguere bʉro ñajãdʉama. ");
INSERT INTO sri_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ʉ̃mʉgasi, i nikũde pererokoa. Iri perekeremakʉ̃, Marĩpʉ Moisére doreri pídeare neõ béobirikumi. Iri doreri merã ããrĩpereri ĩgʉ̃: “Ãsũ irigʉra”, ãrĩdeare iriyuwarikʉgʉkumi ĩgʉ̃ ãrĩderosũta, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Irasũ ãrĩ odo, ãsũ ãrĩnemoyupʉ: —Sugʉ ĩgʉ̃ marãpore béo, gajigo merã marãpokʉgʉ, igo merã ñerõ irigʉ yámi. Gajigʉ béodeore marãpokʉgʉde igo merã ñerõ irigʉ yámi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pʉrʉ Jesús gaji keori merã wereyupʉ doja: —Sugʉ wári doebiri opagʉ ããrĩdi ããrĩmí. Surí wajaparire sãñadi ããrĩmí. Irasirigʉ wári opagʉ ããrĩsĩã, ʉ̃mʉrikʉ bosenʉ irigʉ irirosũ õãrĩ ditare baarikʉdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gajigʉ bopogʉ Lázaro wãĩkʉgʉ, ĩgʉ̃ya dʉpʉ ããrĩperero kãmikʉgʉ wári doebiri opagʉya wii makãpʉro doanadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wári doebiri opagʉ baamakʉ̃, bopogʉ gapʉ ĩgʉ̃ baasiridijuri pogare baayapidʉagʉ, sea, baadi ããrĩmí. Ĩgʉ̃ iro doaripoe diayéa ĩgʉ̃ pʉro eja, ĩgʉ̃ya kãmirẽ neerẽnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Pʉrʉ bopogʉ boakõãdi ããrĩmí. Ĩgʉ̃ boamakʉ̃, Marĩpʉre wereboerã paraíso wãĩkʉrogue Abraham ããrĩrṍgue ĩgʉ̃rẽ ãĩmʉrĩãnerã ããrĩmá. Mérõgã pʉrʉ wári doebiri opagʉde boakõãdi ããrĩmí. Ĩgʉ̃ boamakʉ̃, ĩgʉ̃rẽ yáanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Irasirigʉ doebiri opagʉ ããrãdi boanerã ããrĩrṍgue ejagʉ, bʉro poyari merã ããrĩdi ããrĩmí. Ĩgʉ̃ irogue ããrĩgʉ̃́, ʉ̃mʉgasigue ĩãmu, Abrahãrẽ yoarogue ããrĩmakʉ̃ ĩãdi ããrĩmí. Lázarodere ĩgʉ̃ merã ããrĩmakʉ̃ ĩãdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Irasirigʉ bʉro gaguinídi ããrĩmí: “Yʉ ñekʉ̃ Abraham, bopoñarĩ merã ĩãka yʉre! Lázarore iriuka! Ĩgʉ̃ yʉre ĩgʉ̃ya mojõsũrũ merã dekore yosa, yaa nedirure yʉsañajãmakʉ̃ irigʉ aariburo. Yʉ i peameguere bʉro poyagʉ irikoa”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ĩgʉ̃ irasũ ãrĩkeremakʉ̃, Abraham gapʉ ĩgʉ̃rẽ ãsũ ãrĩdi ããrĩmí: “Makʉ, okagʉ ããrĩgʉ̃́gue ããrĩpererire õãrĩrẽ opabʉ mʉ. Lázaro gapʉre ʉ̃mʉrikʉ ñerõ waabʉ. Dapagorare mʉ ñerõ tariripoere ĩgʉ̃ gapʉ õõguere ʉsʉyari merã ããrĩkõãgʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","’Gaji ãsũ ããrã. Ʉ̃kʉ̃ãrĩ gobe miẽ ããrã. Irasirirã õõguere ããrĩrã́ mʉ pʉroguere waamasĩbema. Mʉ pʉrogue ããrĩrã́ õõgue aaridʉakererã, aarimasĩbema”, ãrĩdi ããrĩmí Abraham. ");
INSERT INTO sri_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ĩgʉ̃ irasũ ãrĩmakʉ̃, doebiri opadi ãsũ ãrĩdi ããrĩmí: “Yʉ ñekʉ̃ Abraham, mʉrẽ bʉro sẽrẽa. Lázarore yʉpʉya wiigue iriuka! ");
INSERT INTO sri_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yʉ su mojõma pererã pagʉpũrãkʉa. Lázarore weredoregʉ iriuka, ĩgʉ̃sãrẽ õõguere ñerõ waaróguere aaribirikõãburo, ãrĩgʉ̃”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Abraham gapʉ yʉjʉdi ããrĩmí: “Marĩpʉ ĩgʉ̃ dorerire Moisére pídeare, Marĩpʉya kerere weredupiyunerã gojadeadere opama mʉ pagʉpũrã. Irasirirã irire bue, bʉremuburo”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ĩgʉ̃ irasũ ãrĩmakʉ̃, doebiri opadi gapʉ yʉjʉdi ããrĩmí: “Yʉ ñekʉ̃ Abraham, ĩgʉ̃sã irire opakererã, õãrõ bʉremubirikuma. Lázaro boadigue masã, ĩgʉ̃sã pʉro waa, ĩgʉ̃sãrẽ weremakʉ̃, ĩgʉ̃sã ñerõ iririre bʉjawere, ĩgʉ̃sã gũñarĩrẽ gorawayurãkuma. Irasirirã õãrĩ gapʉre irirãkuma pama yʉ pagʉpũrã”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Abraham gapʉ ĩgʉ̃rẽ ãsũ ãrĩ weredi ããrĩmí: “Mʉ pagʉpũrã Marĩpʉ ĩgʉ̃ dorerire Moisére pídeare, ĩgʉ̃ya kerere weredupiyunerã gojadeadere bʉremumerã, Lázaro boadigue masã, ĩgʉ̃sãrẽ weremakʉ̃dere Marĩpʉre bʉremubirikuma”, ãrĩdi ããrĩmí Abraham, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús ĩgʉ̃ buerãrẽ ãsũ ãrĩ wereyupʉ: —Masakare ñerõ irimakʉ̃ iriri, ããrĩníkõãrokoa. Gajirãrẽ ñerõ irimakʉ̃ irigʉno gapʉ ñetariro tarigʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sugʉ yʉre bʉremugʉ̃rẽ majĩgʉ̃ irirosũ ããrĩgʉ̃́rẽ ñerõ irimakʉ̃ irigʉ, bʉro wajamoãsũgʉkumi. Irasiriro, ĩgʉ̃ gajigʉre ñerõ irimakʉ̃ iriburi dupiyuro masaka ĩgʉ̃rẽ wáriye ʉ̃tãye merã wʉ̃́nugũgue sʉasiu, wádiyague meéyomakʉ̃ õãbukoa. ");
INSERT INTO sri_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Irasirirã õãrõ pémasĩka mʉsã! Mʉyagʉ mʉrẽ ñerõ irimakʉ̃ ĩãgʉ̃: “Irinorẽ iribirikõãka!” ãrĩka ĩgʉ̃rẽ! Irasirigʉ ĩgʉ̃ ñerõ iriadeare bʉjawere, ĩgʉ̃ gũñarĩrẽ gorawayumakʉ̃ ĩãgʉ̃, ĩgʉ̃ ñerõ iriadeare kãtika! ");
INSERT INTO sri_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Irasirigʉ sunʉrẽ su mojõma pere gaji mojõ peru pẽrẽbejarigora mʉrẽ ñerõ irimakʉ̃ ĩãgʉ̃, irikʉta mʉrẽ kãtiri sẽrẽgʉ̃ ejamakʉ̃, kãtika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesús irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃ buerã ãsũ ãrĩñurã: —Gʉare Marĩpʉre bʉremunemomakʉ̃ irika! ");
INSERT INTO sri_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, marĩ Opʉ Jesús ãrĩyupʉ: —Marĩpʉre mʉsã bʉremurĩ opari, mostazayegã irirosũ mérõgã ããrĩkeremakʉ̃, igʉ sicómoro wãĩkʉdire: “Tʉ̃ãduuawãgã, wádiyague ejanʉgãrõ waaka!” ãrĩbukoa. Mʉsã bʉremurĩ merã doremakʉ̃, mʉsã ãrĩrõsũta waakoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Irasũ ãrĩ odo, ãsũ ãrĩnemoyupʉ doja: —Mʉsã watopegue ããrĩgʉ̃́ sugʉ moãboegʉre opakumi. Ĩgʉ̃ pooegue moãkumi, o wekʉare korekumi. ¿Ĩgʉ̃ moã odo, wiigue dujajamakʉ̃ ĩãrã, ĩgʉ̃rẽ: “Murĩgora, baagʉ aarika!” ãrĩbukuri? ");
INSERT INTO sri_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ãrĩbirikoa. Ãsũ gapʉ ãrĩkoa: “Yʉ baaburire ãmuka! Pʉrʉ yʉ baa, iirí iriripoere yʉre baari sĩnemobu yúka! Yʉ baa odoadero pʉrʉ, mʉde baagʉkoa pama”, ãrĩkoa mʉsãrẽ moãboegʉre. ");
INSERT INTO sri_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ĩgʉ̃ mʉsã moãdorerire õãrõ irimakʉ̃ ĩãrã, ĩgʉ̃rẽ: “Õãa, mʉ merã ʉsʉyáa”, ãrĩbukuri? Ãrĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mʉsãde ĩgʉ̃ irirosũta ããrĩpereri Marĩpʉ dorerire iri odo, ãsũ ãrĩka! “Gʉa ĩgʉ̃rẽ moãboerã, ubu ããrĩrã́ ããrã. Ĩgʉ̃ doreri gʉare pídea ditare iriabʉ”, ãrĩka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Gajinʉ Jesús Jerusalẽ́gue waagʉ́, Samaria nikũ, Galilea nikũ watope tariwãgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Iro ããrĩrĩ́ makãgue ĩgʉ̃ ejaripoe pe mojõmarã ʉ̃ma kãmi boarã ĩgʉ̃rẽ bokatĩrĩrã aariñurã. Kãmi boarã ããrĩsĩã, yoaweyarogue dujanʉgã, suro merã gaguiníñurã: ");
INSERT INTO sri_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—Jesús, buegʉ, gʉare bopoñarĩ merã ĩãka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús ĩgʉ̃sãrẽ ĩãgʉ̃, ãsũ ãrĩyupʉ: —Paíare mʉsãya dʉpʉre ĩmurã waaka! ãrĩyupʉ. Ĩgʉ̃sã maague waaripoe ĩgʉ̃sãya kãmi yaripereakõãyuro. Kãmi marĩrã dujañurã. ");
INSERT INTO sri_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Irasirigʉ sugʉ ĩgʉ̃sã watopemʉ ĩgʉ̃ya kãmi yarimakʉ̃ ĩãgʉ̃, Jesús pʉrogue gãmedujarigʉ, bʉsʉro merã Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesús pʉro ejagʉ, ĩgʉ̃ya guburi pʉro ñadʉkʉpuri merã ejamejãja, ĩgʉ̃ya diapure yebague moomejãja, Jesúre: “Õãa”, ãrĩ, ʉsʉyari sĩyupʉ. Ĩgʉ̃ Samariamʉ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús, ĩgʉ̃ sugʉta irasirimakʉ̃ ĩãgʉ̃, ãsũ ãrĩyupʉ: —Pe mojõmarã ããrãma kãmi tausũanerã. ¿Gajirã su mojõma pere gaji mojõ wapikʉdiru pẽrẽbejarã gapʉ noógue ããrĩkuri? ");
INSERT INTO sri_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ĩĩ gʉaya nikũmʉ ããrĩbi dita Marĩpʉre ʉsʉyari sĩgʉ̃ gãmedujariañumi. ¿Nasirirã gajirã ĩgʉ̃ merã ããrãnerã gapʉ aaribirayuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Irasũ ãrĩ odo, ĩgʉ̃rẽ ãsũ ãrĩyupʉ: —Wãgãnʉgã, waaka! Mʉ Marĩpʉre bʉremurĩ opasĩã, kãmi marĩgʉ̃ dujabʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Iro ããrĩrã́ fariseo bumarã Jesúre ãsũ ãrĩ sẽrẽñañurã: —¿Naásũ ããrĩmakʉ̃, Marĩpʉ ĩgʉ̃yarãrẽ doreri ejarokuri? ãrĩñurã. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, yʉjʉyupʉ: —Marĩpʉ ĩgʉ̃yarãrẽ doreri ejamakʉ̃, mʉsã ĩãmasĩbea. ");
INSERT INTO sri_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Marĩpʉ ĩgʉ̃yarãrẽ doreri õõgue ããrãbʉ, o sõõgue ããrã”, ãrĩmasĩña máa. Ĩgʉ̃yarãrẽ doreri mʉsã watopegue ããrĩsiáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Irasũ ãrĩ odo, ĩgʉ̃ buerãrẽ ãsũ ãrĩyupʉ: —Pʉrʉgue yʉ ããrĩpererã tĩ́gʉ̃ i ʉ̃mʉgue dupaturi aariburire bʉro ĩãdʉarãkoa. Yʉ aariburi dupiyuro sunʉ yʉre ĩãdʉakererã, neõ sunʉ ĩãbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Gajirã mʉsãrẽ ãsũ ãrĩrãkuma. “Ĩãka! Cristo õõta ããrĩ́mi”, o gajirã: “Cristo sõõgue ããrãmi”, ãrĩrãkuma. Ĩgʉ̃sã irasũ ãrĩkeremakʉ̃, ĩgʉ̃sãrẽ neõ tʉyabirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yʉ ããrĩpererã tĩ́gʉ̃ i ʉ̃mʉguere dupaturi aarigʉ́, bupu ããrĩperero ʉ̃marõrẽ gũñaña marĩrõ miãrõsũ, gũñaña marĩrõ aarigʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yʉ dupaturi aariburo dupiyuro yʉre bʉro ñerõ tariro ããrã. Dapagora marã yʉre gããmebirikuma. ");
INSERT INTO sri_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé ããrĩdeapoe marãrẽ waaderosũta yʉ ããrĩpererã tĩ́gʉ̃ aariburo dupiyurogãrẽ waarokoa. ");
INSERT INTO sri_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé ããrĩdeapoere masaka baa, iirí, mojõsʉaunanerã ããrĩmá. Ĩgʉ̃sã pũrã nomerẽ nomesunanerã ããrĩmá. Noé doódiru wádirugue ñajãrĩnʉguedere irasũta iriníkõãunanerã ããrĩmá. Pʉrʉ Marĩpʉ ĩgʉ̃sã ããrĩpererãrẽ miũbéopeokõãdi ããrĩmí. Irasũta waarokoa yʉ dupaturi aarimakʉ̃dere. ");
INSERT INTO sri_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot ããrĩdeapoedere mʉrãrõta iriunanerã ããrĩmá. Baa, iirí, wajari, dua, ote, wiirire iriunanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ĩgʉ̃sã irasũ iriripoe ĩgʉ̃sãya makã Sodoma wãĩkʉri makãrẽ Lot wirideanʉrẽ deko merẽrõsũ, ʉ̃mʉgasima peame, azufre wãĩkʉri poga ʉ̃jʉ̃dijari, ĩgʉ̃sãrẽ wẽjẽpeokõãdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yʉ ããrĩpererã tĩ́gʉ̃ gũñaña marĩrõ i ʉ̃mʉgue dupaturi aarirínʉrẽ masakare irasũta waarokoa. ");
INSERT INTO sri_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Irasũ waaripoere sugʉ ĩgʉ̃ya wii wekague ããrĩgʉ̃́, wii poekague ĩgʉ̃yare ãĩgʉ̃ dijabirikõãburo. Mʉrãrõta gajigʉ ĩgʉ̃ya pooegue ããrĩgʉ̃́, ĩgʉ̃ya wiigue dujáabirikõãburo. ");
INSERT INTO sri_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot marãpo igoya makãrẽ ĩãgãmedujugo, moã turu irirosũ poyanʉgãdeare gũñaka! ");
INSERT INTO sri_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sugʉ ĩgʉ̃ya ããrĩburi ditare gũñagʉ̃ perebiri peamegue waadederigʉkumi. Gajigʉ yaare gũñagʉ̃ tarigʉkumi. Marĩpʉ pʉrogue waagʉkumi ĩgʉ̃ merã õãrõ ããrĩníbu. ");
INSERT INTO sri_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Mʉsãrẽ werea. Irasũ waaburi ñamirẽ, pẽrã peyarogue kãrĩrãkuma. Sugʉ yʉre bʉremugʉ̃ ãĩsũgʉkumi. Gajigʉ yʉre bʉremubi dujagʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nomede pẽrã ojodʉka biurã ããrĩrãkuma. Sugo yʉre bʉremugõ ãĩsũgokumo. Gajigo yʉre bʉremubeo dujagokumo. ");
INSERT INTO sri_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pẽrã pooeguere moãrã ããrĩrãkuma. Sugʉ ãĩsũgʉkumi. Gajigʉ dujagʉkumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃ buerã sẽrẽñañurã: —Gʉa Opʉ, ¿noógue irasũ waarokuri? ãrĩñurã. Jesús yʉjʉyupʉ: —Mimua nerẽmakʉ̃ ĩãrã, masaka sugʉ waibʉ boadi ããrĩrṍrẽ masĩkuma. I irirosũ yʉ aarimakʉ̃ ĩãrã, ĩgʉ̃sã wajamoãsũburire masĩrãkuma, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pʉrʉ Jesús ĩgʉ̃ buerãrẽ buegʉ, ãsũ ãrĩyupʉ: “Mʉsã Marĩpʉre sẽrẽrã, piriro marĩrõ gũñaturari merã sẽrẽka!” ãrĩyupʉ. Irasirigʉ i keori merã wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ãsũ ãrĩyupʉ: —Su makãrẽ sugʉ weresãrĩrẽ beyerimasʉ̃ ããrĩkumi. Ĩgʉ̃ Marĩpʉre, masakadere bʉremubirikumi. ");
INSERT INTO sri_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Iri makãrẽta sugo wapiweyo ããrĩkumo. Igo ĩgʉ̃ pʉrogue ĩgʉ̃rẽ iritamurĩ sẽrẽgõ waanakumo: “Yʉre ĩãturigʉre wajamoãdoreka!” ãrĩnakumo. ");
INSERT INTO sri_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Igo irasũ ãrĩrikʉ, igore: “Iribirikoa”, ãrĩnakumi. Ĩgʉ̃ irasũ ãrĩkeremakʉ̃, wári ĩgʉ̃rẽ sẽrẽ, garibokumo. Igo gariborire piribirimakʉ̃ ĩãgʉ̃, ãsũ ãrĩ gũñakumi ĩgʉ̃ basi: “Yʉ Marĩpʉre, masakadere bʉremubi ããrĩkeremakʉ̃, ");
INSERT INTO sri_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","igo yʉre garibotarimo. Yʉre irasũ garibogo yʉre gariboreamakʉ̃ yámo. Irasirigʉ igore ĩãturigʉre igo weresãrĩrẽ pé, ĩgʉ̃rẽ wajamoãdoregʉkoa pama”, ãrĩkumi, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Irasũ ãrĩ odo, marĩ Opʉ werenemoyupʉ: —Ĩĩ weresãrĩrẽ beyerimasʉ̃ ñegʉ̃ ããrĩkeregʉ, igo sẽrẽnírĩrẽ pékumi. Ĩgʉ̃ irasirideare õãrõ pémasĩka mʉsã! ");
INSERT INTO sri_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ĩgʉ̃ nemorõ Marĩpʉ gapʉ ĩgʉ̃ beyenerãrẽ ʉ̃mʉrĩ, ñamirĩ ĩgʉ̃rẽ bʉro sẽrẽnírãrẽ iritamugʉkumi. “Iritamubirikoa”, ãrĩbirikumi ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mʉsãrẽ werea. Marĩpʉ gajirã ĩgʉ̃sãrẽ ñerõ irimakʉ̃ ĩãgʉ̃, ĩgʉ̃sã sẽrẽrĩrẽ pé, yooboro marĩrõ ĩgʉ̃sãrẽ iritamugʉkumi. ¿Ĩgʉ̃ irasũ õãrõ pégʉ ããrĩkeremakʉ̃, yʉ ããrĩpererã tĩ́gʉ̃ i ʉ̃mʉgue dupaturi aarigʉ́, Marĩpʉre bʉremurãrẽ ĩgʉ̃rẽ sẽrẽrãrẽ bokagʉkuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús irasũ ãrĩ odo, gaji keori merã bueyupʉ. “Gʉa gapʉ õãrã ããrã. Gajirã gapʉ ñerõ irirã ããrĩ́ma”, ãrĩ gũñarãrẽ i keori merã ãsũ ãrĩ wereyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Pẽrã ʉ̃ma Marĩpʉya wiigue ĩgʉ̃rẽ sẽrẽrã waakuma. Sugʉ fariseo bumʉ, gajigʉ romano marã opʉre niyeru wajaseabosarimasʉ̃ ããrĩkuma. ");
INSERT INTO sri_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo bumʉ gapʉ ejanʉgã, ĩãmu, ãsũ ãrĩ wereníkumi: “Gʉapʉ, yʉ mʉrẽ ʉsʉyari sĩa. Yʉ, gajirã yajarimasã, ñerĩ iririmasã, nome merã ñerõ iririmasã irirosũ ããrĩbea. Irasũ ããrĩmakʉ̃, neõ ĩĩ romano marã opʉre niyeru wajaseabosarimasʉ̃ irirosũ ããrĩbea. Irasirigʉ mʉrẽ ʉsʉyari sĩa. ");
INSERT INTO sri_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Semanarikʉ penʉ berea mʉrẽ bʉremugʉ̃. Pe mojõma niyeru koeri wajatagʉ, su koe mʉrẽ sĩa. Ããrĩpereri yʉ wajatarire mʉrẽ irasũ dita sĩa”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Niyeru wajaseabosarimasʉ̃ gapʉ neõ ñajãrõgue dujanʉgã, muúsiunʉgãja, ĩgʉ̃ ñerĩ oparire gũña, bʉjawere, ʉ̃mʉgasigue neõ ĩãmurõ marĩrõ ĩgʉ̃ya koretibire pá, ãsũ ãrĩkumi Marĩpʉre: “Yʉ ñegʉ̃ ããrã, irasirigʉ yʉre bopoñarĩ merã ĩãka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mʉsãrẽ werea. Ĩĩ niyeru wajaseabosarimasʉ̃, Marĩpʉ ĩũrõ õãgʉ̃gue ĩgʉ̃ya wiigue dujáakumi. Fariseo bumʉ gapʉ, Marĩpʉ ĩũrõ waja opagʉta ĩgʉ̃ya wiigue dujáakõãkumi. Ãsũ ããrã. Sugʉ ĩgʉ̃ basi: “Gajirã nemorõ õãgʉ̃ ããrã”, ãrĩ gũñagʉ̃norẽ Marĩpʉ ĩgʉ̃rẽ ubu ããrĩgʉ̃́ ããrĩmakʉ̃ irigʉkumi. Gajigʉ Marĩpʉre: “Ñerõ iriabʉ, irasirigʉ yʉre bopoñarĩ merã ĩãka!” ãrĩgʉ̃ gapʉre Marĩpʉ ĩgʉ̃ ĩũrõ õãgʉ̃ ããrĩmakʉ̃ irigʉkumi, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pʉrʉ masaka majĩrãgãrẽ Jesúre moãñadorerã ĩgʉ̃ pʉro ãĩjañurã. Ĩgʉ̃sã ãĩjamakʉ̃ ĩãrã, Jesús buerã ĩgʉ̃sãrẽ bokatĩrĩ: “Ĩgʉ̃rẽ garibobirikõãka!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús gapʉ majĩrãgãrẽ ĩgʉ̃ pʉro siiu, ĩgʉ̃ buerãrẽ ãrĩyupʉ: —Majĩrã yʉ pʉrogue aariburo. Kãmutabirikõãka ĩgʉ̃sãrẽ! Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ããrĩmurã, ĩĩsã majĩrã yʉre ʉsʉyari merã bokatĩrĩñeãrã irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Diayeta mʉsãrẽ werea. Ĩĩsã majĩrã Marĩpʉre ĩgʉ̃sã Opʉre gããmerã irirosũ ããrĩmerãno, ĩgʉ̃yarãrẽ doreroguere waabirikuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pʉrʉ sugʉ judío masaka oparã merãmʉ Jesúre sẽrẽñayupʉ: —Õãgʉ̃ buegʉ, yʉ ʉ̃mʉgasigue perebiri okarire wajatadʉagʉ, ¿ñeénorẽ irigʉkuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —¿Nasirigʉ yʉre: “õãgʉ̃”, ãrĩrĩ? Marĩpʉ sugʉta õãgʉ̃ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mʉ, ĩgʉ̃ doreri pídeare masĩa: Gajigʉ marãpo merã ñerõ iribirikõãka! Masakare wẽjẽbirikõãka! Yajabirikõãka! Gajirãyamarẽ ãrĩkatori merã werebirikõãka! Mʉ pagʉsãmarãrẽ goepeyari merã bʉremuka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesúre yʉjʉyupʉ: —Iri doreri ããrĩpererire majĩgʉ̃gãgueta iripeosiabʉ yʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃rẽ ãsũ ãrĩyupʉ: —Mʉrẽ su wãĩ dʉyáa. Ããrĩpereri mʉ oparire duagʉ waaka! Mʉ duadea wajare boporãrẽ guereka! Irasirigʉ ʉ̃mʉgasiguere wári õãrĩ opagʉkoa. Odo, yʉ merã aarika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ gapʉ ĩgʉ̃ wári oparire maĩsĩã, bʉro bʉjawereri merã ããrĩnʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ĩgʉ̃ bʉjaweremakʉ̃ ĩãgʉ̃, Jesús ãsũ ãrĩyupʉ: —Wári doebiri oparãrẽ Marĩpʉ ĩgʉ̃yarãrẽ dorerogue ĩgʉ̃sã waadʉamakʉ̃ diasatariakõãa. ");
INSERT INTO sri_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camellu awiru gobegãgue ñajãtariweremasĩbirikumi. I nemorõ wári doebiri opagʉre Marĩpʉ ĩgʉ̃yarãrẽ dorerogue waamakʉ̃ diasáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, masaka ãsũ ãrĩñurã: —Iro merẽ, ¿noã gapʉ Marĩpʉ tausũmurã ĩgʉ̃ pʉrogue waamurã ããrĩbukuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Masaka ĩgʉ̃sã basi ĩgʉ̃sã iriri merã Marĩpʉ pʉrogue waamasĩbema. Marĩpʉ dita ĩgʉ̃sãrẽ ĩgʉ̃ pʉro ããrĩmurã waamakʉ̃ irimasĩmi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ĩgʉ̃rẽ ãrĩyupʉ: —Gʉa Opʉ, gʉa mʉrẽ tʉyarã, ããrĩpereri gʉa opadeare pípeokõãbʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ĩgʉ̃rẽ Jesús ãsũ ãrĩ yʉjʉyupʉ: —Diayeta mʉsãrẽ werea. Marĩpʉ ĩgʉ̃yarãrẽ doreri kerere wererã waarã́, ĩgʉ̃sãya wiirire, marãposã nomerẽ, ĩgʉ̃sã pagʉpũrãrẽ, pagʉsãmarãrẽ, pũrãrẽ pípeorã, wári õãrĩ wajatarãkuma. ");
INSERT INTO sri_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ĩgʉ̃sã iro dupiyuro opaderosũ i ʉ̃mʉguere nemorõ wári õãrĩ wajatarãkuma. Pʉrʉ i ʉ̃mʉ peremakʉ̃, ʉ̃mʉgasigue perebiri okari oparãkuma Marĩpʉ merã ããrĩnímurã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pʉrʉ Jesús ĩgʉ̃ buerãrẽ pe mojõma pere su gubu peru pẽrẽbejarã ditare siiuwãgã, ãrĩyupʉ: —Õãrõ péka! Marĩ Jerusalẽ́gue waarã́ yáa. Irogue ããrĩpereri Marĩpʉya kerere weredupiyunerã yʉre ããrĩpererã tĩ́gʉ̃rẽ gojaderosũta yʉre waarokoa. ");
INSERT INTO sri_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Irasirirã yʉre ñeã, judío masaka ããrĩmerãguere wiarãkuma. Ĩgʉ̃sã yʉre bʉrida, ñerõ werení, síku eotúbirarãkuma. ");
INSERT INTO sri_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yʉre bʉro tãrãrãkuma. Irasiri odo, wẽjẽrãkuma. Ĩgʉ̃sã yʉre wẽjẽadero pʉrʉ, ʉrenʉ waaró merã masãgʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ĩgʉ̃ buerã ĩgʉ̃ irasũ ãrĩ wererire ããrĩpererire neõ pémasĩbiriñurã. Marĩpʉ irire ĩgʉ̃sãrẽ pémasĩmakʉ̃ iribiriyupʉ dapa. ");
INSERT INTO sri_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pʉrʉ Jesús Jericó wãĩkʉri makã tʉrogue ejaripoe ĩgʉ̃ waarí maa tʉro sugʉ koye ĩãbi niyeru sẽrẽ doaníyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Irasirigʉ masaka wárã ĩgʉ̃ pʉro tariwãgãnamakʉ̃ pégʉ, iro ããrĩrã́rẽ sẽrẽñayupʉ: “¿Nasirirã masaka wárã tariwãgãnarĩ?” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Jesús Nazaretmʉ aarigʉ́ yámi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, ãsũ ãrĩ gaguiníyupʉ: —Jesús, David parãmi ããrĩturiagʉ, yʉre bopoñarĩ merã ĩãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ĩgʉ̃ irasũ ãrĩ gaguinímakʉ̃, masaka ĩgʉ̃ dupiyuro ããrĩrã́ gapʉ ĩgʉ̃rẽ: “Toeaka!” ãrĩñurã. Ĩgʉ̃sã irasũ ãrĩkeremakʉ̃, ĩgʉ̃ gaguiníadero nemorõ gaguinínemoyupʉ: —David parãmi ããrĩturiagʉ, yʉre bopoñarĩ merã ĩãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, Jesús dujanʉgãja, masakare: “Ãĩrika ĩgʉ̃rẽ!” ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gajirã ĩgʉ̃rẽ ãĩwãgãñurã. Ĩgʉ̃ pʉrogue ãĩjamakʉ̃, Jesús ĩgʉ̃rẽ sẽrẽñayupʉ: ");
INSERT INTO sri_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Neénorẽ yʉ mʉrẽ irimakʉ̃ gããmerĩ? ãrĩyupʉ. —Yʉ Opʉ, yʉre koye ĩãmakʉ̃ irika! ãrĩ yʉjʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Jáʉ, ĩãka pama! Mʉ yʉre bʉremurĩ opáa. Irasirigʉ tausũa, ãrĩyupʉ Jesús ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, õãrõ ĩãmasĩakõãyupʉ. Irasirigʉ Jesúre tʉyawãgã, Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩyupʉ. Ããrĩpererã ĩgʉ̃rẽ irasũ waamakʉ̃ ĩãrãde, Marĩpʉre ʉsʉyari sĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pʉrʉ Jesús Jericógue eja, iri makãrẽ tariwãgãgʉ̃ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Irore sugʉ masakʉ Zaqueo wãĩkʉgʉ wári doebiri opagʉ, romano marã opʉre niyeru wajaseaboerimasã opʉ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ĩgʉ̃ Jesúre ĩãdʉadiyupʉ. Masaka wárã watopeguere ʉ̃mabi ããrĩsĩã, Jesúre neõ ĩãbokabiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Irasirigʉ ũmadupiyuwãgã, Jesús tariwãgãburo pʉromʉ yukʉ sicómoro wãĩkʉdigue mʉrĩayupʉ ĩgʉ̃rẽ: “Ĩãgʉra”, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús irigʉ pʉro tariagʉ, ʉ̃marõgue peyagʉre ĩãboka, ĩgʉ̃rẽ ãsũ ãrĩyupʉ: —Zaqueo, murĩgora, dijirika! Yʉ dapagãrẽ mʉya wiita dujagʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, Zaqueo mumurõ merã dijiri, Jesúre bʉro ʉsʉyari merã bokatĩrĩgʉ̃ waayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ĩgʉ̃ irasirimakʉ̃ ĩãrã, ããrĩpererã masaka werewʉañurã: “¿Nasirigʉ Jesús ñegʉ̃ya wiigue dujagʉ waáari?” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Irasirigʉ Zaqueo ĩgʉ̃ya wiigue ejadero pʉrʉ, wãgãnʉgã, marĩ Opʉ Jesúre ãrĩyupʉ: —Yʉ Opʉ, péka! Gajino boporãrẽ yʉ oparire deko merã dʉkawagʉra. Yʉ gajirãrẽ ãrĩkatori merã yajadeare wapikʉri ããrĩnemorõ ĩgʉ̃sãrẽ wiagʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús irire pégʉ, iri wii ããrĩrã́rẽ ãsũ ãrĩyupʉ: —Dapagã merã ĩgʉ̃, ĩgʉ̃ya wii marã, ĩgʉ̃sã ñerõ iridea wajare tausũma. Ĩgʉ̃de Abraham parãmi ããrĩturiagʉ, yʉre bʉremugʉ̃ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yʉ ããrĩpererã tĩ́gʉ̃ perebiri peamegue waadederibonerãrẽ ãma, taugʉ aarigʉ́ iribʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús Zaqueo merã werenímakʉ̃ masaka péñurã. Ĩgʉ̃ Jerusalén tʉrogue ããrĩmakʉ̃ ĩãrã, ãsũ gũñañurã: “Gũñaña marĩrõ Marĩpʉ ĩgʉ̃yarãrẽ dorero ejaburo yáa”, ãrĩ gũñañurã. Irasirigʉ Jesús keori merã ĩgʉ̃sãrẽ ");
INSERT INTO sri_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ãsũ ãrĩ wereyupʉ: —Sugʉ masakʉ, opʉ ñajãburo dupiyuro yoarogue gaji nikũgue waakõãkumi. Ĩgʉ̃rẽ opʉ sóoadero pʉrʉ, ĩgʉ̃ya nikũrẽ goekumi. ");
INSERT INTO sri_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ĩgʉ̃ waaburo dupiyuro ĩgʉ̃rẽ moãboerã pe mojõmarãrẽ siiukumi. Siiu, ĩgʉ̃sãkʉ su koe wajapari niyeru koe sĩ, ĩgʉ̃sãrẽ ãsũ ãrĩkumi: “Yʉ irogue ããrĩripoe i niyeru koe merã gajino wajari, duaka, gaji niyeru koeri wajatanemomurã!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Irasũ ãrĩ odo, opʉ ñajãbu waakõãkumi pama. Ĩgʉ̃ya nikũ marã gapʉ ĩgʉ̃rẽ gããmebirikuma. Irasirirã, ĩgʉ̃ waadero pʉrʉ, gajirãrẽ ĩgʉ̃rẽ weredorerã iriukuma. Irasirirã ĩgʉ̃rẽ: “Mʉ, gʉa opʉ ããrĩmakʉ̃ gããmebea”, ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ĩgʉ̃sã ĩgʉ̃rẽ gããmebirikeremakʉ̃, ĩgʉ̃sã opʉ ñajãkumi. Opʉ ñajãa odo, ĩgʉ̃ya nikũgue goedujáakumi. Irasũ goedujajagʉ, ĩgʉ̃rẽ moãboerãrẽ ĩgʉ̃sã niyeru koe merã wajatanemoadeare masĩbu, ĩgʉ̃sãrẽ siiukumi. ");
INSERT INTO sri_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ĩgʉ̃ pʉro ejapʉrorigʉ ãsũ ãrĩkumi: “Yʉ opʉ, mʉ niyeru koe yʉre sĩdea koe merã gaji pe mojõma koeri wajatanemobʉ”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ opʉ ãrĩkumi: “Õãgoráa. Mʉ yʉre moãboegʉ õãgʉ̃ ããrã. Yʉ dorederosũta yʉ mérõgã mʉrẽ pídea merã õãrõ iriyo. Irasirigʉ pe mojõma makãrĩrẽ doregʉ ããrĩgʉkoa”, ãrĩkumi ĩgʉ̃ opʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pʉrʉ gajigʉ ãsũ ãrĩkumi: “Yʉ opʉ, mʉ niyeru koe yʉre sĩdea koe merã gaji su mojõma koeri wajatanemobʉ yʉde”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ opʉ ãrĩkumi: “Su mojõma makãrĩrẽ doregʉ ããrĩgʉkoa”, ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Pʉrʉ gajigʉ ãsũ ãrĩkumi: “Yʉ opʉ, mʉya niyeru koe õõ ããrã. Iri koere suríro gasiro merã õma, duripíbʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉ gajirãrẽ bʉro turaro merã moãdoregʉ ããrã. Mʉ basi moãbirikeregʉ, otebi ããrĩkeregʉ, mʉrẽ moãboerãrẽ oterire otedore, ĩgʉ̃sãrẽ oteri dʉkare seadore, irire mʉ basita opáa. Irasirigʉ mʉrẽ güiabʉ”, ãrĩkumi ĩgʉ̃ opʉre. ");
INSERT INTO sri_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ opʉ ãrĩkumi: “Mʉ yʉre moãboegʉ ñegʉ̃ ããrã. Irasirigʉ mʉrẽ wajamoãgʉra. Mʉ yʉre wereri merãta mʉrẽ weregʉra. Mʉ yʉre ãsũ ãrã: ‘Mʉ gajirãrẽ bʉro turaro merã moãdoregʉ ããrã. Mʉ basi moãbirikeregʉ, otebi ããrĩkeregʉ, mʉrẽ moãboerãrẽ oterire otedore, ĩgʉ̃sãrẽ oteri dʉkare seadore, irire mʉ basita opáa’, ãrã mʉ yʉre. ");
INSERT INTO sri_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mʉ irasũ ãrĩgʉ̃, ¿nasirigʉ yʉ mʉrẽ sĩdea koere niyeru duripíri wiigue duripíbiriri? Irogue duripímakʉ̃, i wii moãrã iri koe merã wáro wajatanemobosabukuma mʉrẽ. Irasirigʉ, yʉ goejagʉ, mʉ yʉre ĩgʉ̃sã iriri merã wajatanemobosadeare ñeãboakuyo”, ãrĩkumi ĩgʉ̃ opʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Irasũ ãrĩ odo, gajirãrẽ ĩgʉ̃ pʉro ããrĩrã́rẽ ãrĩkumi: “Ĩgʉ̃rẽ niyeru koere ẽma, pe mojõma koeri opagʉ gapʉre sĩka!” ãrĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃sã ãsũ ãrĩkuma ĩgʉ̃rẽ: “Gʉa opʉ, pe mojõma koeri opagʉ opasiami”, ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, opʉ ãsũ ãrĩ yʉjʉkumi: “Mʉsãrẽ werea. Ããrĩpererã ĩgʉ̃sã opari merã õãrõ irirã õãrĩrẽ sĩnemosũrãkuma. Gajirã õãrõ irimerã ĩgʉ̃sã mérõgã opadideare ẽmapeokõãsũrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dapagorata yʉre ĩãturirãrẽ yʉre opʉ ñajãmakʉ̃ gããmemerãrẽ yʉ pʉrogue ãĩrika! Yʉ ĩũrõ wẽjẽka ĩgʉ̃sãrẽ!” ãrĩkumi opʉ ĩgʉ̃rẽ moãboerãrẽ, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Irasũ ãrĩ odo, gajirã dupiyuro Jerusalẽ́gue waayupʉ doja. ");
INSERT INTO sri_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Irogue waa, Betfagé, Betania wãĩkʉri makãrĩ pʉro ejapʉroriyupʉ. Iri makãrĩ, Olivos wãĩkʉdi ʉ̃tãʉ̃ ããrĩdujimejãrõgue ããrĩyuro. Irogue ejagʉ, ĩgʉ̃ buerã pẽrãrẽ ãsũ ãrĩ iriuyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Si makã marĩ bokatĩũrõ ããrĩrĩ́ makãgue waaka! Iro ejarã, sugʉ burrore ĩgʉ̃sã sʉanúadire neõ suñarõ peyasũña marĩgʉ̃rẽ bokajarãkoa. Ĩgʉ̃rẽ kura, õõgue ãĩrika! ");
INSERT INTO sri_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sugʉ mʉsãrẽ: “¿Nasirimurã ĩgʉ̃rẽ kurari?” ãrĩmakʉ̃: “Marĩ Opʉ gããmeami”, ãrĩka! ãrĩ iriuyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃ buerã pẽrã makãgue waañurã. Irogue Jesús ĩgʉ̃ ãrãderosũta waayuro. ");
INSERT INTO sri_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Irasirirã burrore ĩgʉ̃sã kuramakʉ̃ ĩãrã, ĩgʉ̃ oparã ĩgʉ̃sãrẽ sẽrẽñañurã: —¿Nasirimurã burrore kurari? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, ãsũ ãrĩ yʉjʉñurã: —Marĩ Opʉ ĩgʉ̃rẽ gããmeami, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pʉrʉ burrore Jesús pʉrogue ãĩãñurã. Ãĩja, ĩgʉ̃sãya wekama suríre túwea, burro weka peo, Jesúre ĩgʉ̃ wekague mʉrĩbejamakʉ̃ iriñurã. ");
INSERT INTO sri_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús peyawãgãrimakʉ̃, masaka ĩgʉ̃sãya wekama suríre túwea ãĩ, ĩgʉ̃ waaburi maarẽ́ sẽõpídupiyuñurã ĩgʉ̃rẽ bʉremurã. ");
INSERT INTO sri_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Irasirirã Jerusalén pʉrogue eja, Olivos wãĩkʉdi ʉ̃tãʉ̃ dijarirã, ããrĩpererã Jesúre bʉremurã ĩgʉ̃rẽ irogue tʉyanerã ããrĩpereri ĩgʉ̃ Marĩpʉ turaro merã iri ĩmumakʉ̃ ĩãdeare gũñarã, ʉsʉyari merã Marĩpʉre: “Õãtaria mʉ”, ãrĩ, bʉro gaguiníñurã ĩgʉ̃rẽ bʉremurã. ");
INSERT INTO sri_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ãsũ ãrĩñurã: Marĩ Opʉre ʉsʉyari sĩrã! Ĩĩ Marĩpʉ marĩrẽ taugʉ iriudi õãrõ aariburo. Ʉ̃mʉgasigue ããrĩrã́ siñajãburo. Ĩgʉ̃sãde Marĩpʉre: “Õãtaria mʉ ããrĩpererã Opʉ ããrĩgʉ̃́”, ãrĩ, ʉsʉyari sĩburo, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, surãyeri fariseo bumarã irogue ããrĩrã́ Jesúre ãrĩñurã: —Buegʉ, mʉ buerãrẽ wereka! Toedoreka ĩgʉ̃sãrẽ! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Mʉsãrẽ werea. Ĩgʉ̃sã ʉsʉyari merã wereníbirimakʉ̃, Marĩpʉ i ʉ̃tãyerire gaguinímakʉ̃ iribukumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pʉrʉ Jesús Jerusalén tʉro eja, iri makãrẽ ĩã, oreyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ãsũ ãrĩyupʉ: —Jerusalén marã, dapagã Marĩpʉ mʉsãrẽ õãrõ siñajãrĩ sĩdʉarire pémasĩmakʉ̃ õãtariboakuyo. Marĩpʉ irasũ sĩdʉakeremakʉ̃, mʉsã irire neõ pémasĩdʉabea. Irasirigʉ Marĩpʉ mʉsãrẽ irire pémasĩdorebemi. ");
INSERT INTO sri_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Irasiriro mʉsãrẽ ñerõ waarínʉ ejarokoa. Mʉsãrẽ ĩãturirã mʉsãya makã tʉrore wea kãmutamejãjarãkuma. Mʉsã wiriboadeare ããrĩpererogue biapeokõãrãkuma mʉsãrẽ ñeãmurã. ");
INSERT INTO sri_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Irasirirã mʉsãrẽ yebague wẽjẽmeépírãkuma. Mʉsãrẽ iri makã marã ããrĩpererãrẽ wẽjẽpeokõãrãkuma. Ʉ̃tãyeri weadeade neõ gajiye weka dujabirikoa. Mʉsãrẽ Marĩpʉ ĩgʉ̃ taudʉarinʉ ejakeremakʉ̃, mʉsã ĩgʉ̃rẽ ĩãmasĩbiridea waja, ĩgʉ̃rẽ béodea waja irasũ waarokoa, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pʉrʉ Jerusalẽ́gue ejagʉ, Jesús Marĩpʉya wiigue ñajãyupʉ. Irogue ñajãa, doebiri duarãrẽ, ĩgʉ̃sã duarire wajarirãdere bokaja, ĩgʉ̃sãrẽ béowiuyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —Marĩpʉ ĩgʉ̃ya werenírĩ gojadea pũgue ãsũ ãrĩdi ããrĩmí: “Yaa wii, yʉre bʉremurã yʉre sẽrẽrĩ wii ããrã”, ãrĩdi ããrĩmí. Mʉsã gapʉ yajarimasãya wii irirosũ ããrĩmakʉ̃ yáa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ʉ̃mʉrikʉ Jesús Marĩpʉya wiigue masakare buegʉ waanayupʉ. Ĩgʉ̃ irasũ buegʉ ejamakʉ̃ ĩã, Moisés gojadeare buerimasã, paía oparã, gajirã judío masaka oparãde: “¿Nasiri ĩgʉ̃rẽ wẽjẽrãkuri?” ãrĩ gũñamañurã. ");
INSERT INTO sri_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ĩgʉ̃sã ĩgʉ̃rẽ wẽjẽdʉakeremakʉ̃, masaka ããrĩpererã ĩgʉ̃ werenírĩrẽ õãrõ pénʉrʉ̃ñurã. Irasirirã Jesúre wẽjẽdʉarã: “Ãsũ irirã, ĩgʉ̃rẽ wẽjẽmurã”, ãrĩ, ãmumasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gajinʉ Jesús Marĩpʉya wiigue ããrĩrã́rẽ Marĩpʉ masakare tauri kerere buegʉ iriyupʉ. Ĩgʉ̃ irasũ buemakʉ̃, paía oparã, Moisés gojadeare buerimasã, judío masaka mʉrã merã ĩgʉ̃ pʉrogue eja, ");
INSERT INTO sri_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ĩgʉ̃rẽ sẽrẽñañurã: —Wereka gʉare! ¿Noã mʉrẽ doreri, mʉ irasirimakʉ̃? ¿Noã mʉrẽ: “Ãsũ irika!” ãrĩrĩ? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Yʉde mʉsãrẽ sẽrẽñagʉra. Yʉjʉka yʉdere! ");
INSERT INTO sri_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juan masakare deko merã wãĩyemakʉ̃, ¿noã ĩgʉ̃rẽ wãĩyedoregʉ iriuyuri, Marĩpʉ, o masaka? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníñurã: —¿Naásũ ãrĩ yʉjʉrãkuri marĩ? “Marĩpʉ Juãrẽ doredi ããrĩmí”, marĩ ãrĩmakʉ̃, Jesús marĩrẽ: “¿Nasirirã ĩgʉ̃ weredeare bʉremubiriri mʉsã?” ãrĩbukumi. ");
INSERT INTO sri_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ããrĩpererã masaka: “Diayeta Juan Marĩpʉyare weredupiyudi ããrĩmí”, ãrĩ gũñama. Marĩ: “Masaka Juãrẽ wãĩyedorenerã ããrĩmá”, ãrĩmakʉ̃, masaka marĩrẽ ʉ̃tãyeri merã dearãkuma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Irasirirã Jesúre ãsũ ãrĩ yʉjʉñurã: —Juãrẽ wãĩyedoredire gʉa masĩbea, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Iro merẽ mʉsã yʉre: “¿Noã mʉrẽ irire doreri?” ãrĩ sẽrẽñadeare yʉde mʉsãrẽ yʉjʉbea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pʉrʉ Jesús i keori merã masakare ãsũ ãrĩ buenʉgãyupʉ: —Sugʉ masakʉ ĩgʉ̃ya pooegue iguidarire otekumi. Ote odo, gajirãrẽ iri pooere wayu: “Yʉ otedea dʉkare deko merã sĩrãkoa, yʉ mʉsãrẽ iri pooere wayuri waja”, ãrĩkumi. Irasũ ãrĩ odo, gajirogue waakõãkumi. Yoaripoe deyomarĩkumi. ");
INSERT INTO sri_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pʉrʉ igui ñíripoe ããrĩmakʉ̃, ĩgʉ̃rẽ moãboegʉre ĩgʉ̃ya pooema oteri dʉkare deko merã sẽrẽdoregʉ iriukumi. Pooere moãrã gapʉ ĩgʉ̃ iriuadire irogue ejamakʉ̃ ĩãrã, ĩgʉ̃rẽ pákuma. Neõ sutõ iguitõ sĩrõ marĩrõ ĩgʉ̃rẽ iridujukuma. ");
INSERT INTO sri_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pʉrʉ pooe opʉ gajigʉ ĩgʉ̃rẽ moãboegʉre iriuadikumi doja. Pooere moãrã gapʉ ĩgʉ̃dere pá, ñerõ irikuma. Neõ gajino sĩrõ marĩrõ ĩgʉ̃dere iridujukuma. ");
INSERT INTO sri_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pʉrʉ pooe opʉ gajigʉ ĩgʉ̃rẽ moãboegʉre iriuadikumi doja. Pooere moãrã gapʉ ĩgʉ̃rẽ kãmitú, iri pooe tʉrogue béokõãkuma. ");
INSERT INTO sri_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ĩgʉ̃sã irasiriadero pʉrʉ, pooe opʉ ãsũ ãrĩ gũñakumi: “¿Nasirigʉkuri yʉ?” ãrĩkumi. “Ãsũ irigʉra. Yʉ magʉ̃ yʉ maĩgʉ̃rẽ iriugʉra. Ĩgʉ̃rẽ iriumakʉ̃, ĩgʉ̃rẽ bʉremurãkuma”, ãrĩ gũñadikumi. ");
INSERT INTO sri_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Irasirigʉ ĩgʉ̃ magʉ̃rẽ iriukumi. Ĩgʉ̃ irogue ejamakʉ̃ ĩãrã, pooe moãrã gapʉ ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníkuma: “Ĩĩta pʉrʉguere i pooere opabu ããrĩ́mi. Ĩgʉ̃rẽ wẽjẽkõãrã! Irasirirã marĩ basi i pooere oparãkoa”, ãrĩkuma. ");
INSERT INTO sri_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Irasirirã ĩgʉ̃rẽ ñeã, pooe tʉrogue ãĩwãgã, wẽjẽbéokõãkuma, ãrĩyupʉ Jesús. Irasũ ãrĩ odo, ĩgʉ̃sãrẽ sẽrẽñayupʉ: —Mʉsã péñamakʉ̃, ĩgʉ̃ magʉ̃rẽ wẽjẽadero pʉrʉ, ¿nasirigʉkuri pooe opʉ ĩgʉ̃ya pooere moãrãrẽ? Ãsũ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Irogue waa, ĩgʉ̃sãrẽ wẽjẽ, iri pooere gajirã gapʉre sĩgʉkumi, ãrĩyupʉ Jesús. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, masaka gapʉ ãsũ ãrĩñurã: —Neõ marĩrẽ irasũ waabirikõãburo, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús gapʉ ĩgʉ̃sãrẽ ĩã, ãsũ ãrĩ sẽrẽñayupʉ: —Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojasũdea, ¿naásũ ãrĩdʉaro yári? Ãsũ ãrĩ gojasũdero ããrĩbʉ́: Suye ʉ̃tãyere wii iririmasã béoadeaye merã gajigʉ gapʉ õãrõ turari wii irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sugʉ i ʉ̃tãye weka meémejãgʉ̃, mʉtãkõãgʉkumi. I ʉ̃tãye gapʉ ĩgʉ̃ weka meébejaro ĩgʉ̃rẽ õãrĩ pogagãgue meémutũbéokõãrokoa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Paía oparã, Moisés gojadeare buerimasãde ĩgʉ̃ i keori merã irasũ ãrĩ weremakʉ̃ pérã: “Marĩrẽ: ‘Pooe moãrã irirosũ ñerã ããrã’, ãrĩgʉ̃ irikumi”, ãrĩ péña, ĩgʉ̃rẽ peresu irimurã bʉro ñeãdʉadiñurã. Irasũ ñeãdʉakererãta: “Masaka, ĩgʉ̃rẽ marĩ irasirimakʉ̃ ĩãrã, marĩ merã guarãkuma”, ãrĩñurã. Irasirirã ĩgʉ̃sãrẽ güisĩã, ñeãmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Irasirirã: “Gajinʉ ĩgʉ̃rẽ ñeãrãra”, ãrĩ, ĩãnʉrʉ̃tʉyañurã. Ĩgʉ̃ ñerõ yʉjʉmakʉ̃ weresãmurã pédʉarã iriadiñurã. Irasirirã gajirãrẽ irikatorãrẽ ĩgʉ̃ pʉro iriuñurã ĩgʉ̃ werenírĩrẽ pédorerã. “Ĩgʉ̃rẽ sẽrẽñarã waarã́, masaka ĩũrõrẽ diaye irirã irirosũ ããrĩka!” ãrĩ, ĩgʉ̃sãrẽ iriuñurã. “Jesús ñerõ werenímakʉ̃ pérã, iri nikũ marã opʉ pʉrogue peresu iridorerã ãĩwãgãrãra”, ãrĩrã, ĩgʉ̃sãrẽ iriuadiñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ĩgʉ̃sã Jesús pʉrogue ejarã, ãsũ ãrĩñurã: —Buegʉ, mʉ iririkʉrire masĩa. Mʉ ãrĩkatoro marĩrõ werenía. Marĩpʉyare diayeta buea. “¿Naásũ gũñarĩ masaka yʉre?” ãrĩ gũñarõ marĩrõ diayeta ĩgʉ̃sãrẽ werea. Oparãrẽ, ubu ããrĩrã́dere ããrĩpererãrẽ surosũta ĩãa. ");
INSERT INTO sri_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Irasirigʉ gʉare wereka! Romano marã opʉ marĩrẽ niyeru wajasearire marĩ wajarimakʉ̃, ¿õãgorari, o õãberi? ãrĩñurã Jesúre. ");
INSERT INTO sri_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús gapʉ ĩgʉ̃sã ñerõ iridʉarire masĩsĩã, ĩgʉ̃sãrẽ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Niyeru koere ãĩrika! I koeguere, ¿noãya diapu keori, noãya wãĩ tuuyari? ãrĩyupʉ. —Romano marã opʉya diapu keori, ĩgʉ̃ wãĩta tuuyáa, ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —Iro merẽ romano marã opʉya ããrĩrĩ́rẽ ĩgʉ̃rẽ sĩka! Marĩpʉya gapʉre Marĩpʉre sĩka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Irasirirã masaka péuro neõ ĩgʉ̃rẽ ñerõ ãrĩ werenímakʉ̃ irimasĩbiriñurã. Ubu gapʉ ĩgʉ̃ yʉjʉrire pérã pégʉka, toekõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pʉrʉ surãyeri saduceo bumarã Jesús pʉrogue ejañurã. Ĩgʉ̃sã: “Masaka boanerãgue masãbirikuma”, ãrĩ bʉremurã ããrĩñurã. Irasirirã Jesúre ãsũ ãrĩñurã: ");
INSERT INTO sri_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Buegʉ, Moisés marĩrẽ ãsũ ãrĩ gojapídi ããrĩmí: “Sugʉ marãpokʉdi pũrã marĩkeregʉ igore boaweomakʉ̃, ĩgʉ̃ pagʉmʉ igore dúunorẽgʉkumi. Irasirirã, ĩgʉ̃ igo merã pũrãkʉrã ĩgʉ̃ tĩ́gʉ̃ dagʉ pũrã irirosũta ããrĩrãkuma”, ãrĩ gojapídi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","’Iripoeguere sugʉ pũrã, su mojõma pere gaji mojõ peru pẽrẽbejarã ããrĩunanerã ããrĩmá. Ĩgʉ̃sã tĩ́gʉ̃ gapʉ marãpokʉ, pũrã marĩgʉ̃ta boakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Irasirigʉ ĩgʉ̃ dagʉ dokamʉta ĩgʉ̃ marãpo ããrĩdeore dúunorẽyupʉ. Ĩgʉ̃de, ĩgʉ̃ tĩ́gʉ̃ dagʉ irirosũta pũrã marĩgʉ̃ta boakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ĩgʉ̃sã pẽrã dokamʉde pũrã marĩgʉ̃ta boakõãyupʉ. Irasũ dita pũrã marĩrãta boapereakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ĩgʉ̃sã pʉrʉ ĩgʉ̃sã marãpode boakõãyupo pama. ");
INSERT INTO sri_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ĩgʉ̃sã su mojõma pere gaji mojõ peru pẽrẽbejarã ʉ̃ma igore marãpokʉadiñurã. Irasirirã boanerã masãmakʉ̃, ¿niíno marãpogora ããrĩgokuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —I ʉ̃mʉgue ããrĩrã́, ʉ̃ma, nome merã marãpokʉma. Ĩgʉ̃sã pũrã nomedere nomesuma. ");
INSERT INTO sri_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ĩgʉ̃sã irasirikeremakʉ̃, ʉ̃mʉgasigue ããrĩmurã gapʉ irasũ ããrĩbirikuma. Marĩpʉ: “Õãrã ããrĩ́ma”, ãrĩ ĩãrã, boanerãgue masã, pʉrʉ ĩgʉ̃ pʉrogue mʉrĩãrãkuma. Iroguere marãpokʉbirikuma. Ĩgʉ̃sã pũrã nomedere nomesubirikuma. ");
INSERT INTO sri_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Marĩpʉre wereboerã irirosũ neõ dupaturi boabirimurã ããrĩsĩã, irasiribirikuma. Ĩgʉ̃sã Marĩpʉ masũnerã, ĩgʉ̃ pũrã ããrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Iripoeguere Moisés ĩgʉ̃ yukʉgãgue ʉ̃jʉ̃rõgue waadeare gojadi ããrĩmí. Ĩgʉ̃ irogue ããrĩmakʉ̃, Marĩpʉ ãsũ ãrĩdi ããrĩmí ĩgʉ̃rẽ: “Yʉ Abraham, Isaac, Jacob Opʉta ããrã”, ãrĩdi ããrĩmí. I merã boanerã masãburire marĩ masĩa. ");
INSERT INTO sri_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Abraham, Isaac, Jacob boanerã ããrĩkererã, Marĩpʉ merã okarã ããrĩ́ma. Irasirigʉ Marĩpʉ boanerã dupaturi masãbirimurã Opʉ ããrĩbemi. Okarã Opʉ ããrĩ́mi. Ããrĩpererã masaka boakererã, Marĩpʉ ĩũrõ okarã ããrĩ́ma, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, surãyeri Moisés gojadeare buerimasã ãsũ ãrĩñurã: —Buegʉ, mʉ õãrõ yʉjʉa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Irasirirã neõ dupaturi gaji ĩgʉ̃rẽ sẽrẽñadʉabiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús gapʉ ãsũ ãrĩyupʉ: —¿Nasirirã Moisés gojadeare buerimasã: “Cristo, David parãmi ããrĩturiagʉ ããrĩ́mi”, ãrĩrĩ? ");
INSERT INTO sri_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David, Salmos wãĩkʉri gojadea pũgue ãsũ ãrĩ gojadi ããrĩmí: Marĩpʉ, yʉ Opʉre ãsũ ãrĩmi: “Õõ, yʉ diaye gapʉ doaka yʉ merã dorebu! ");
INSERT INTO sri_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Irasiriripoe mʉrẽ ĩãturirãrẽ mʉ dorerire tarinʉgãnemobirimakʉ̃ irigʉra”, ãrĩmi, ãrĩ gojadi ããrĩmí David. ");
INSERT INTO sri_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David, Cristo ñekʉ̃ ããrĩkeregʉ, ĩgʉ̃rẽ: “Yʉ Opʉ ããrĩ́mi”, ãrĩdi ããrĩmí. ¿Nasirigʉ, Cristo, David parãmi ããrĩturiagʉ ããrĩkeremakʉ̃, David ĩgʉ̃rẽ irasũ ãrĩyuri? ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ããrĩpererã masaka péurogue Jesús ĩgʉ̃ buerãrẽ ãsũ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Moisés gojadeare buerimasã ñerõ iririre õãrõ pémasĩka! Oparã irirosũ surí yoari sãña, masaka ĩũrõgue waagorenama. Makã dekoguere masakare õãrõ bʉremurĩ merã bokatĩrĩ õãdoremakʉ̃ gããmema. Nerẽrĩ wiiriguere ñajãrã, õãrĩ doaripẽrĩgue dita doadʉama. Bosenʉrĩ ããrĩmakʉ̃dere oparã doarigue dita doadʉama. ");
INSERT INTO sri_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wapiweyarã nome wajamomakʉ̃ ĩã, ĩgʉ̃sãya wiirire ẽmanokõãma. Ĩgʉ̃sãrẽ bopoñarĩ merã ĩãbirikererã, yoaripoe Marĩpʉre sẽrẽ ĩmukatoma, masaka ĩgʉ̃sãrẽ: “Marĩpʉre õãrõ bʉremuma”, ãrĩburo, ãrĩrã. Ĩgʉ̃sã irasiriri waja Marĩpʉ ĩgʉ̃sãrẽ gajirã nemorõ wajamoãgʉkumi, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús Marĩpʉya wiigue ããrĩgʉ̃́, iri wiima ĩgʉ̃sã ãmuburi niyeru neeõrĩ kũmague wári doebiri oparã ĩgʉ̃sã niyeru sãmakʉ̃ ĩãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sugo wapiweyo bopogode iri kũmague pe koegã, mérõgã wajakʉri koerigãrẽ sãmakʉ̃ ĩãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iri koerire igo sãmakʉ̃ ĩãgʉ̃, ãsũ ãrĩyupʉ: —Diayeta mʉsãrẽ werea. Igo wapiweyo bopogo i kũmague niyeru sãgõ, Marĩpʉ ĩũrõ gajirã ããrĩpererã ĩgʉ̃sã sĩadero nemorõ sãamo. ");
INSERT INTO sri_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gajirã wári doebiri oparã wáro sĩkeremakʉ̃, ĩgʉ̃sãya wáro dʉyáa. Igo gapʉ bopogo ããrĩkerego, igo baari wajariboadeare sĩpeokõãmo Marĩpʉre bʉremugõ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Surãyeri ĩgʉ̃ buerã Marĩpʉya wiimarẽ ĩãrã, ãsũ ãrĩñurã: —Õãrĩ ʉ̃tãyeripa merã iridea wii ããrã. Masaka iri wiire ĩgʉ̃sã sĩdeade õãrĩ ããrã, ãrĩñurã. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Mʉsã i wiimarẽ dapagorare ĩãdáa. Sunʉ i wiima ããrĩpereri marĩ ĩãdea, i ʉ̃tãyeride mʉtãdijapereakõãrokoa. Neõ suye ʉ̃tãye gajiye weka weamʉrĩadeade dujabirikoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ sẽrẽñañurã: —Gʉare buegʉ, ¿naásũ ããrĩmakʉ̃ mʉ ãrãderosũ waarokuri? ¿Ñeéno iri ĩmugʉkuri, iri irasũ waaburi dupiyuro? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús yʉjʉyupʉ: —Õãrõ pémasĩka! Gajirã wárã ãrĩkatorimasã aarirãkuma. “Yʉ Marĩpʉ iriudi, Cristo ããrã”, ãrĩrãkuma. “Dapagorare i ʉ̃mʉ pereburo aarisiáa”, ãrĩrãkuma. Ĩgʉ̃sã ãrĩkatorire pébirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Masaka mʉsã pʉro gãmewẽjẽrĩrẽ pérã, gajirogue marã ĩgʉ̃sã oparãrẽ béori kerere pérã, gʉkabirikõãka! I ʉ̃mʉ pereburi dupiyuro irasũ waapʉrorirokoa. Irasũ waakeremakʉ̃, i ʉ̃mʉ pereburo dʉyarokoa dapa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Irasũ ãrĩ odo, ĩgʉ̃sãrẽ ãsũ ãrĩnemoyupʉ doja: —Su bumarã, gaji bumarã merã gãmewẽjẽrãkuma. Su nikũ marã, gaji nikũ marã merã gãmewẽjẽrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Wári makãrĩguere nikũ bʉro ñomerokoa. Masaka wárã ʉaboari merã boarãkuma. Pũrĩrikʉri merã ñerõ tarirãkuma. Ʉ̃mʉgasiguere bʉro goeri, wári gajino deyoarire ĩãrã, masaka bʉro güirãkuma. ");
INSERT INTO sri_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’I ããrĩpereri irasũ waaburo dupiyuro mʉsã yʉre bʉremurĩ waja gajirã mʉsãrẽ ñeã, ñerõ irirãkuma. Irasirirã marĩ judío masaka nerẽrĩ wiirigue mʉsãrẽ weresã, peresu irirãkuma. Makãrĩ marã oparã pʉrogue ãĩãnarãkuma mʉsãrẽ wajamoãdorerã. ");
INSERT INTO sri_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ĩgʉ̃sã irogue mʉsãrẽ ãĩjamakʉ̃, mʉsã gapʉ Marĩpʉya õãrĩ kerere wererãkoa ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ĩgʉ̃sã mʉsãrẽ oparã pʉrogue ãĩwãgãmakʉ̃ ĩãrã, oparãrẽ yʉjʉburire gũñarikʉbirikõãka! “¿Naásũ ãrĩrãkuri ĩgʉ̃sãrẽ?” ãrĩ gũñarikʉbirikererãta ããrĩka! ");
INSERT INTO sri_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mʉsã werenímakʉ̃ iritamugʉra. Mʉsãrẽ irasũ iritamugʉ̃, masĩrĩ merã õãrĩ werenírĩ merã weremakʉ̃ irigʉra. Mʉsã irasũ weremakʉ̃ pérã, mʉsãrẽ ĩãturirã gapʉ mʉsã werenírĩrẽ bokatĩũbirikuma. “Iri diaye ããrĩbea”, ãrĩmasĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Surãyeri mʉsã pagʉsãmarã, mʉsã pagʉpũrã, mʉsãya makã marã, mʉsã merãmarãde mʉsãrẽ oparãguere wẽjẽdorerã wiarãkuma. Irasirirã mʉsãrẽ surãyerire wẽjẽrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yʉre mʉsã bʉremurĩ waja ããrĩperero marã masaka mʉsãrẽ ĩãturi doorãkuma. ");
INSERT INTO sri_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ĩgʉ̃sã irasirikeremakʉ̃, sudagã mʉsãya poadagã neõ dederibirikoa. ");
INSERT INTO sri_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Irasirirã mʉsãrẽ ñerõ irikeremakʉ̃, yʉre bʉremurĩrẽ pirimerã, Marĩpʉ pʉrogue perebiri okari oparãkoa. ");
INSERT INTO sri_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Irasirirã wárã surara Jerusalén tʉro gãmegorobiatúmakʉ̃ ĩãrã, iri makãrẽ ĩgʉ̃sã béoburo mérõgã dʉyáa, ãrĩ masĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Irasũ waamakʉ̃ ĩãrã, Judea nikũgue ããrĩrã́ ʉ̃tãyukugue ũmaduriburo. Jerusalẽ́gue ããrĩrã́de iri makãrẽ wiriburo. Iri makã tʉro ããrĩrã́ Jerusalẽ́guere dupaturi goedujáabirikõãburo. ");
INSERT INTO sri_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Irasũ waarínʉrĩ Marĩpʉ ñerãrẽ wajamoãrĩnʉrĩ ããrĩrokoa. Irasiriro ããrĩpereri ĩgʉ̃ya werenírĩ gojadea pũgue gojaderosũta waarokoa. ");
INSERT INTO sri_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","I nikũ marã bʉro pũrĩrõ péñarãkuma. Marĩpʉ ĩgʉ̃sãrẽ bʉro wajamoãgʉkumi. Irasũ waamakʉ̃, nijĩpagosã nome, ĩgʉ̃sã pũrã mirĩrãgã oparã nomede bʉro ñerõ tarirãkuma. ");
INSERT INTO sri_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Surãyeri i makã marã gãmewẽjẽrõgue boarãkuma. Boamerã gapʉre ããrĩpereri nikũgue ãĩwãgã, peresu irirãkuma. Judío masaka ããrĩmerã Jerusalẽ́rẽ ñerõ irirãkuma. Irasirirã iri makã marãrẽ tarinʉgãrãkuma. Marĩpʉ, judío masaka ããrĩmerãrẽ: “Iri makã marãrẽ neõ opabirikõãka pama!” ãrĩmakʉ̃gue opaduúrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’I ʉ̃mʉ pereburi dupiyuro abe ʉ̃mʉmʉ, abe ñamimʉ, neñukãde deyori gorawayuakõãrãkuma. Wádiya turaro bʉsʉri, makũrĩ nikũguere bʉro ejarokoa. Irasirirã i ʉ̃mʉ marã ããrĩpererã bʉro gʉkari merã diaye gũñamasĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ʉ̃marõgue marã turarã naradari merã béosũrãkuma. Irasũ waamakʉ̃ ĩãrã, masaka i ʉ̃mʉ pereburire: “¿Aarisiakuri?” ãrĩ gũñarã, bʉro güiri merã kõmorã irirosũ neõ gũñajabirikuma. ");
INSERT INTO sri_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Irasũ waaripoere masaka yʉ ããrĩpererã tĩ́gʉ̃, wáro Marĩpʉ turari merã, ĩgʉ̃ gosesiriri merã ĩĩmikãyebogue i nikũguere yʉ dupaturi aarimakʉ̃ ĩãrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yʉ ãrĩderosũta iri goerire waapʉrorimakʉ̃ ĩãrã, mʉsã yaarã ããrĩrã́ güibirikõãka! Gũñaturari merã ʉ̃mʉgasigue ĩãmuka! Mérõgã dʉyáa, Marĩpʉ mʉsãrẽ perebiri peamegue waabonerãrẽ tauri ejaburo, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Irasũ ãrĩ odo, i keori merã ĩgʉ̃sãrẽ werenemoyupʉ: —Higueragʉ, o gajigʉ yukʉ noó gããmedire ĩãka! ");
INSERT INTO sri_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Irigʉ pũ maamamakʉ̃ ĩãrã: “Bojori waaburo mérõgã dʉyáa”, ãrĩ masĩa. ");
INSERT INTO sri_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Irigʉ waarósũta i ããrĩpereri yʉ ãrĩrĩ irasũ waamakʉ̃ ĩãrã: “Marĩpʉ ĩgʉ̃yarãrẽ doreri aariburo mérõgã dʉyáa”, ãrĩ masĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Diayeta mʉsãrẽ werea. I ʉ̃mʉ marã boapereburo dupiyuro i ããrĩpereri yʉ ãrĩrĩ irasũ waarokoa. ");
INSERT INTO sri_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ʉ̃mʉgasi, i nikũde pereakõãrokoa. Yʉ werenírĩ gapʉ neõ perebirikoa. Ããrĩpereri yʉ ãrĩrõsũta waayuwarikʉrokoa. ");
INSERT INTO sri_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","’Yʉ dupaturi aariburinʉrẽ neõ masĩbea mʉsã. Irasirirã õãrõ pémasĩka! Bosenʉrĩrẽ irirã, ñerĩrẽ iribirikõãka! Mejãbirikõãka! I ʉ̃mʉmarẽ bʉro gũñarikʉbirikõãka! Mʉsã ire irasirimerã, gũñaña marĩrõ i ʉ̃mʉguere yʉ aarimakʉ̃ ĩãrã, gʉkabirikoa. Waibʉ gũñaña marĩrõ weadeadague ĩgʉ̃ meésiajarosũta gũñaña marĩrõ yʉ aarirínʉ masakare ããrĩpereri nikũ marãrẽ waarokoa. ");
INSERT INTO sri_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Irasirirã õãrõ pémasĩrĩ merã yúka! Marĩpʉre ãsũ ãrĩ sẽrẽníkõãka! “I ʉ̃mʉ peremakʉ̃, gʉare iritamuka! Turarire sĩka, gʉare õãrõ tariburo, ãrĩgʉ̃! Irasirirã gʉa ããrĩpererã tĩ́gʉ̃rẽ güiro marĩrõ bokatĩrĩrãkoa”, ãrĩ sẽrẽka ĩgʉ̃rẽ! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús ʉ̃mʉrikʉ Marĩpʉya wiigue buenayupʉ. Ñamirikʉ bue odogʉ, Olivos wãĩkʉdi ʉ̃tãʉ̃gue waa, irogue ããrĩboyoanayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Boyoripoe ããrĩmakʉ̃, ããrĩpererã masaka Marĩpʉya wiigue ĩgʉ̃ buerire pérã waanañurã. ");
INSERT INTO sri_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Iripoere judío masaka pã́ wemasãrĩ morẽña marĩrĩ baari bosenʉ, mérõgã dʉyayuro. Iri bosenʉ pascua wãĩkʉyuro. ");
INSERT INTO sri_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Paía oparã, Moisés gojadeare buerimasã Jesúre wẽjẽdʉarã: “¿Nasiri ĩgʉ̃rẽ wẽjẽrãkuri marĩ?” ãrĩñurã. Ĩgʉ̃sã Jesúre wẽjẽdʉakererã, masakare güiñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iripoere wãtĩ, Judas Iscariote wãĩkʉgʉguere ñajãyupʉ ñerõ iridoregʉ. Judas, Jesús buerã pe mojõma pere su gubu peru pẽrẽbejarã watopemʉ ããrãdiyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wãtĩ ñajãdero pʉrʉ, Judas paía oparã, Marĩpʉya wiire korerã surara oparã pʉro waayupʉ. Irogue eja, ĩgʉ̃ Jesúre ĩmuburire ĩgʉ̃sã merã wereníyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ʉsʉyari merã: “Ĩgʉ̃rẽ mʉ gʉare ĩmumakʉ̃, mʉrẽ niyeru wajarirãkoa”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas: “Jáʉ”, ãrĩ, pʉrʉ: “¿Naásũ ããrĩmakʉ̃, masaka ĩãberogue oparãguere yʉ Jesúre wiamakʉ̃ õãrokuri?” ãrĩ gũñayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pʉrʉ pã́ wemasãrĩ morẽña marĩrĩ baari bosenʉ ããrĩnʉgãrĩnʉ ããrĩyuro. Irinʉ pascua bosenʉ iririnʉ ããrĩmakʉ̃, Marĩpʉ ĩũrõ oveja majĩgʉ̃rẽ ĩgʉ̃sã wẽjẽrĩnʉ ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Irinʉta Jesús Pedrore, Juãrẽ ãsũ ãrĩ iriuyupʉ: —Marĩ pascua bosenʉ baaburire ãmurã́ waaka! ");
INSERT INTO sri_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ãsũ ãrĩ sẽrẽñañurã: —¿Noógue marĩ pascua bosenʉ baaburire ãmumakʉ̃ gããmekuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Jerusalẽ́gue waaka! Irogue sugʉ dekosoro kõãwãgãgʉ̃rẽ bokajarãkoa. Ĩgʉ̃rẽ tʉyaka! Ĩgʉ̃ ñajãri wiigue ejarã, iri wii opʉre: “Gʉare buegʉ, ãsũ ãrĩ sẽrẽñadoreami: ‘¿Dií taribugue yʉ buerã merã i pascua bosenʉrẽ baagʉkuri?’ ãrãmi”, ãrĩka! ");
INSERT INTO sri_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mʉsã irasũ ãrĩmakʉ̃ pé, wári taribu, ʉ̃marõgue ĩgʉ̃sã ãmu odoadea taribure ĩmugʉkumi. Irogue marĩ baaburire ãmuka! ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Irasirirã iri makãgue waa, irogue eja, Jesús wereaderosũta bokaja, pascua bosenʉ baaburire ãmuñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ĩgʉ̃sã baaripoe ejamakʉ̃, Jesús ĩgʉ̃ buerã pe mojõma pere su gubu peru pẽrẽbejarã merã baa doaníyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Irogue baa doanígʉ̃, ĩgʉ̃sãrẽ ãrĩyupʉ: —Yʉ boaburo dupiyuro i pascua bosenʉ baarire mʉsã merã bʉro baadʉáa. ");
INSERT INTO sri_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mʉsãrẽ werea. I bosenʉrẽ marĩ dapagora irirosũ yʉ dupaturi neõ irinemobirikoa. Pʉrʉ Yʉpʉ ĩgʉ̃yarãrẽ dorerogue dupaturi iriyuwarikʉgʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Irasũ ãrĩ odo, iiríripare ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩ, ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —Ire ãĩ, dʉkawa iiríka! ");
INSERT INTO sri_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mʉsãrẽ werea. I igui dekore marĩ dapagora iirírosũ yʉ dupaturi neõ iirínemobirikoa. Yʉpʉ ĩgʉ̃yarãrẽ doreri ejadero pʉrʉgue dupaturi iirígʉkoa doja, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pʉrʉ pã́rẽ ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩ, pã́rẽ pea, ĩgʉ̃sãrẽ ãsũ ãrĩ guereyupʉ: —I yaa dʉpʉ ããrã. Yʉ mʉsã ñerõ iridea waja boagʉkoa. Irasirirã mʉsã dapagora iriaderosũ nerẽ, pã́rẽ baarikʉ, yʉ mʉsãrẽ boabosarire gũñaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ĩgʉ̃sã baa odoadero pʉrʉ, pã́rẽ ãĩaderosũta iiríripadere ãĩ, ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —Yʉ mʉsãrẽ boabosagʉ, yaa dí béori merã Yʉpʉ mʉsãrẽ: “Õãrõ irigʉra”, ãrĩdeare iriyuwarikʉgʉkoa. ");
INSERT INTO sri_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Dapagorare yʉre wẽjẽdʉarãguere yʉre ĩmubu õõ yʉ merã baa doaními. ");
INSERT INTO sri_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Marĩpʉ ãrĩderosũta yʉre ããrĩpererã tĩ́gʉ̃rẽ waaró yáa. Yʉre ĩmubu gapʉre ñetariro waarokoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã basi ãsũ ãrĩ gãme sẽrẽñañurã: —¿Noã marĩ watopeguere irasiribukuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pʉrʉ Jesús buerã ãsũ ãrĩ gãme guaseoñurã: —Marĩ watopere, ¿noã ããrĩpererã nemorõ ããrĩgʉkuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús gapʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —I nikũ marã oparã Marĩpʉre bʉremumerã gapʉ ĩgʉ̃sãyarãrẽ dorerã, turaro merã dorema. Irasirirã ĩgʉ̃sã oparãrẽ: “Masakare õãrõ iritamurã ããrĩ́ma”, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉsã tamerã i nikũ marã oparã irirosũ iribirikõãka! Ãsũ gapʉ irika! Mʉsã watopeguere sugʉ gajirã nemorõ ããrĩdʉagʉ, mʉsã nemorõ ubu ããrĩgʉ̃́ maamʉ irirosũ ããrĩburo. Mʉsãrẽ doredʉagʉ, moãboegʉ irirosũ mʉsãrẽ iritamugʉ̃ ããrĩburo. ");
INSERT INTO sri_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mʉsã gũñamakʉ̃, ¿niíno gapʉ gajigʉ nemorõ ããrĩgʉ̃́ ããrĩ́rĩ? ¿Baa doanígʉ̃ gapʉ, o ĩgʉ̃rẽ baari ejogʉ gapʉ ããrĩ́rĩ? Ãsũ ããrã. Baa doanígʉ̃ gajigʉ nemorõ ããrĩ́mi. Yʉ gapʉ mʉsã watopegue ããrĩgʉ̃́, mʉsãrẽ moãboegʉ irirosũta mʉsãrẽ iritamugʉ̃ aaribʉ́. ");
INSERT INTO sri_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Masaka yʉre ñerõ irikeremakʉ̃, mʉsã yʉ merã ããrĩníkõãbʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Irasirigʉ, Yʉpʉ yʉre ĩgʉ̃yarã Opʉ píderosũ, yʉ mʉsãdere oparã sóogʉra. ");
INSERT INTO sri_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Irasirirã, yʉ ĩgʉ̃yarã Opʉ ããrĩrṍgue mʉsãde, yʉ merã iirí, baa doanírãkoa. Irogue mʉsã pe mojõma pere su gubu peru pẽrẽbejari oparã doarire doarãkoa. Irasirirã Israel bumarãrẽ pe mojõma pere su gubu peru pẽrẽbejari buri marãrẽ dorerãkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Irasũ ãrĩ odo, marĩ Opʉ Jesús Pedrore ãsũ ãrĩyupʉ: —Simón, yʉre péka! Wãtẽa opʉ Satanás Yʉpʉre sẽrẽadami, trigo gasirire koro, yʉsasiribéoro irirosũ mʉsãrẽ yʉre bʉremurĩrẽ pirimakʉ̃ iridʉagʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ĩgʉ̃ irasũ iridʉakeremakʉ̃, yʉ gapʉ mʉya ããrĩburire Yʉpʉre sẽrẽbosabʉ, mʉ yʉre bʉremurĩrẽ piribirikõãburo, ãrĩgʉ̃. Irasirigʉ yʉre dupaturi õãrõ gũñaturadero pʉrʉ, mʉyarã yʉre bʉremurãrẽ gũñaturamakʉ̃ irika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ãrĩyupʉ: —Yʉ Opʉ, mʉrẽ peresu irirã, yʉdere mʉ merãta peresu iriburo. Mʉrẽ wẽjẽrã, yʉdere mʉ merãta wẽjẽburo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Pedro, mʉrẽ werea. Dapagã ñami ãgãbo wereburo dupiyuro yʉre masĩkeregʉ ʉrea gajirãrẽ: “Masĩbea”, ãrĩkatogʉkoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Irasũ ãrĩ odo, Jesús ĩgʉ̃ buerãrẽ ãsũ ãrĩ sẽrẽñayupʉ doja: —¿Sõõ ããrĩdeapoere mʉsã niyeru, surí ãĩãrĩ ajuri, gubu surí opamerã mʉsãrẽ yʉ iriudeapoere ñeénorẽ gããmenemorĩ? —Neõ gajino gããmenemobiribʉ, ãrĩ yʉjʉñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, ãrĩyupʉ doja: —Dapagora gapʉre surí, niyeru ãĩãrĩ ajuri oparã, irire ãĩaka! Mʉsãrẽ sareri majĩrĩ marĩmakʉ̃ ĩãrã, mʉsãya surí wekamarẽ dua, su majĩ wajarika! ");
INSERT INTO sri_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ire mʉsãrẽ werea. Marĩpʉya werenírĩ gojadea pũgue gojaderosũta yʉre waaró yáa. Ãsũ ãrĩ gojasũdero ããrĩbʉ́: “‘Ĩgʉ̃de ñegʉ̃ irirosũ ñerã watopeguere ããrĩdi ããrĩ́mi’, ãrĩsũgʉkumi”, ãrĩ gojasũdero ããrĩbʉ́, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pẽrã, ĩgʉ̃ buerã ĩgʉ̃rẽ ãrĩñurã: ");
INSERT INTO sri_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Gʉa Opʉ, pe majĩ sareri majĩrĩ opáa, ãrĩñurã. —Õãsiáa, ãrĩ yʉjʉyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pʉrʉ Jesús ĩgʉ̃ irinarõsũ Olivos wãĩkʉdi ʉ̃tãʉ̃gue waakõãyupʉ. Ĩgʉ̃ buerãde ĩgʉ̃ merã waañurã. ");
INSERT INTO sri_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Irogue ejagʉ, Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Marĩpʉre sẽrẽka, wãtĩ ãrĩmesãrĩrẽ iribukoa, ãrĩrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Irasũ ãrĩ odo, ĩgʉ̃ sugʉta yoaweyaro waa, ñadʉkʉpuri merã ejamejãja, Marĩpʉre ãsũ ãrĩ sẽrẽyupʉ: ");
INSERT INTO sri_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Aʉ, yʉ ñerõ tariburire taudʉagʉ, tauka! Yʉ irasũ ãrĩkeremakʉ̃, yʉ gããmerõsũ iribirikõãka! Mʉ gããmerõsũ gapʉ yʉre waaburo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Marĩpʉre wereboegʉ ʉ̃mʉgasigue ããrãdi Jesúre deyoayupʉ ĩgʉ̃rẽ gũñaturamakʉ̃ irigʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús bʉro pũrĩsũgʉ̃ Marĩpʉre sẽrẽadero nemorõ ĩgʉ̃rẽ sẽrẽnemoyupʉ doja. Ĩgʉ̃ ñajãsʉririta dí yeri pagayeri wiri, yebague yuriyuro. ");
INSERT INTO sri_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Marĩpʉre irasũ ãrĩ sẽrẽ odo, wãgãnʉgã, ĩgʉ̃ buerã pʉrogue ejagʉ, bʉro bʉjawereri merã kãrĩrãrẽ bokajayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Irasirigʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —¿Nasirirã kãrĩrĩ? Yobeka! Marĩpʉre sẽrẽka, wãtĩ ãrĩmesãrĩrẽ iribukoa, ãrĩrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ĩgʉ̃ irasũ ãrĩ wereripoe masaka wárã ejañurã. Judas pe mojõma pere su gubu peru pẽrẽbejarã buerã watopemʉ ããrãdi masakare dupiyuyupʉ. Jesús pʉro eja, ĩgʉ̃rẽ bokatĩrĩ, ĩgʉ̃ya wayupãrãrẽ mimiyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ĩgʉ̃ irasũ mimimakʉ̃ ĩãgʉ̃, Jesús gapʉ ĩgʉ̃rẽ ãrĩyupʉ: —Judas, ¿yʉre ããrĩpererã tĩ́gʉ̃rẽ yʉre ĩãturirãguere wiagʉ, yaa wayupãrãrẽ mimirĩ mʉ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús buerã ĩgʉ̃rẽ masaka ñeãburire masĩrã: “Gʉa Opʉ, ¿gʉa sareri majĩrĩ merã ĩgʉ̃sã merã gãmekẽãsi?” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Irasũ ãrĩ, sugʉ Jesús buegʉ ĩgʉ̃ya sareri majĩ merã paía opʉre moãboagʉre diaye gapʉma gãmipũrẽ dititá dijukõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ĩgʉ̃ irasirimakʉ̃ ĩãgʉ̃, Jesús ãrĩyupʉ: —Iropata irika! Inorẽ irinemobita! ãrĩyupʉ. Ãrĩ odo, gãmipũ ããrãderore moãñayupʉ. Ĩgʉ̃ moãñamakʉ̃, ĩgʉ̃ya gãmipũ õãkõãyuro doja. ");
INSERT INTO sri_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Irasiri odo, ĩgʉ̃rẽ ñeãmurãrẽ: paía oparãrẽ, Marĩpʉya wiire korerã surara oparãrẽ, judío masaka mʉrãdere ãrĩyupʉ: —¿Nasirirã sareri majĩrĩ merã, yukʉ dʉkari merã sugʉ yajarimasʉ̃rẽ ñeãrã aarirã́ irirosũ yʉre ñeãrã aaríri? ");
INSERT INTO sri_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ʉ̃mʉrikʉ Marĩpʉya wiigue mʉsã merã yʉ ããrĩmakʉ̃, yʉre neõ ñeãbiribʉ. Irasũ ããrĩkeremakʉ̃, dapagora mʉsã yʉre ñerõ iriripoe ejasiáa. Wãtĩ naĩtĩãrõgue ããrĩgʉ̃́ mʉsãrẽ dorerire irirã yáa mʉsã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pʉrʉ Jesúre ñeã, paía opʉya wiigue ãĩãñurã. Ĩgʉ̃sã ĩgʉ̃rẽ ãĩãmakʉ̃, Pedro ĩgʉ̃sãrẽ yoaweyarogue tʉyayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Irogue ejarã, makãpʉro ñajãrõma yeba dekogue peame diiuñurã. Irasirirã irime tʉro sũma doaníñurã. Pedro ĩgʉ̃sã pʉro eja, ĩgʉ̃sã watopegue doayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sugo moãboerimasõ, ĩgʉ̃ peame tʉro doamakʉ̃ ĩãgõ, ĩgʉ̃rẽ õãrõ ĩã, gajirãrẽ ãsũ ãrĩ wereyupo: —Ĩĩde ĩgʉ̃ merã ããrĩdita ããrãmi, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Igo irasũ ãrĩmakʉ̃ pégʉ, Pedro ãrĩkatori merã: —Yʉ ĩgʉ̃rẽ neõ masĩbea, ãrĩ yʉjʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mérõgã pʉrʉ gajigʉ ĩgʉ̃rẽ ĩã, ãsũ ãrĩyupʉ: —Mʉde Jesús buerã merãmʉta ããrã, ãrĩyupʉ. —Neõ ããrĩbea yʉ, ãrĩyupʉ Pedro. ");
INSERT INTO sri_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Su hora pʉrʉ gajigʉ gajirãrẽ ãsũ ãrĩ wereyupʉ: —Ĩĩ diayeta ĩgʉ̃ merã ããrĩdita ããrĩ́mi. Galileamʉta ããrĩ́mi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Pedro yʉjʉyupʉ: —Yʉ, mʉ werenígʉ̃rẽ masĩbea, pémasĩbirikoa, ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩripoeta ãgãbo wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ĩgʉ̃ weremakʉ̃, marĩ Opʉ Jesús yoaweyarogue ããrĩgʉ̃́ Pedrore ĩã gãmeuyupʉ. Ĩgʉ̃ irasũ ĩãmakʉ̃, Pedro, Jesús ĩgʉ̃rẽ: “Dapagã ñami ãgãbo ĩgʉ̃ wereburo dupiyuro mʉ yʉre masĩkeregʉ, ʉrea: ‘Masĩbea’, ãrĩkatogʉkoa”, ãrĩdeare gũñabokayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Irire gũñaboka, wiria, bʉjawereri merã bʉro oreyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesúre korerã surara ĩgʉ̃rẽ bʉrida, páñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Irasũ ĩgʉ̃rẽ párã, suríro gasiro merã ĩgʉ̃ya koyere sʉabiato: —¿Noã mʉrẽ pári? Ãrĩbokaka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wári gaji ñerõ ãrĩ bʉridañurã. ");
INSERT INTO sri_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Gajinʉ gapʉ boyodujimejãripoe judío masaka mʉrã, paía oparã, Moisés gojadeare buerimasãde nerẽñurã. Pʉrʉ ĩgʉ̃sã nerẽrõgue Jesúre ãĩja, ãsũ ãrĩ sẽrẽñañurã: ");
INSERT INTO sri_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Wereka gʉare! ¿Mʉ, Marĩpʉ iriudi Cristota ããrĩ́rĩ? ãrĩñurã. Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Mʉsãrẽ: “Yʉ ĩgʉ̃ta ããrã”, ãrĩmakʉ̃, yʉre bʉremubirikoa. ");
INSERT INTO sri_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mʉsãrẽ gajinorẽ yʉ sẽrẽñamakʉ̃, yʉre yʉjʉbirikoa. ");
INSERT INTO sri_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mʉsã yʉre bʉremubirikeremakʉ̃, mérõgã pʉrʉ Yʉpʉ turatarigʉ yʉre ããrĩpererã tĩ́gʉ̃rẽ ĩgʉ̃ diaye gapʉ doamakʉ̃ irigʉkumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ããrĩpererã ĩgʉ̃rẽ sẽrẽñañurã: —¿Irasũ ãrĩgʉ̃, Marĩpʉ magʉ̃ta ããrĩ́rĩ mʉ? ãrĩñurã. —Ĩgʉ̃ta ããrã mʉsã ãrĩrõsũta, ãrĩ yʉjʉyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ãsũ ãrĩñurã: —Nasirimurã gajirã ĩgʉ̃rẽ weresãrĩrẽ pénemobirikoa marĩ! Ĩgʉ̃ werenírĩrẽ marĩ basita pésiáa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Irasũ ãrĩ odo, ããrĩpererã wãgãnʉgã, Jesúre opʉ Pilato wãĩkʉgʉ pʉrogue ãĩãñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jesúre irogue ãĩjarã, ãsũ ãrĩ weresãnʉgãñurã: —Ĩĩ marĩya nikũ marãrẽ ñerõ iridoremakʉ̃ péabʉ. Romano marã opʉ niyeru wajasearire: “Wajaribirikõãka!” ãrĩrĩrẽ péabʉ. Gajidere: “Yʉ judío masaka Opʉ, Cristo ããrã”, ãrãmi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pilato Jesúre sẽrẽñayupʉ: —¿Mʉta ããrĩ́rĩ, judío masaka Opʉ? —Mʉ ãrĩrõsũta ĩgʉ̃ta ããrã, ãrĩ yʉjʉyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Pilato paía oparãrẽ, masaka irogue ããrĩrã́rẽ ãrĩyupʉ: —Ĩĩrẽ neõ ñerĩ iridea máa, yʉ ĩãmakʉ̃, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ĩgʉ̃ irasũ ãrĩkeremakʉ̃, ĩgʉ̃sã gapʉ bʉro weresãnemoñurã: —Ĩgʉ̃ bueri merã masaka oparãrẽ tarinʉgãmakʉ̃ iriami. Galilea nikũgue irire irinʉgãmi. Dapagorare i makãguedere irasũta irigʉ ejáami, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pilato gapʉ sẽrẽñayupʉ: —¿Ĩĩ Galileamʉta ããrĩ́rĩ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Iromʉta ããrĩ́mi”, ãrĩ, ĩgʉ̃sã yʉjʉmakʉ̃ pégʉ, Pilato surarare: “Jesúre Galilea nikũ marã opʉ Herodes pʉro ãĩaka!” ãrĩyupʉ. Iripoere Herodes Jerusalẽ́gue ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Iro dupiyuro Herodes Jesús iridea kerere pédi ããrĩmí. Irasirigʉ yoaripoe ĩgʉ̃rẽ bʉro ĩãdʉagʉ iriadiyupʉ. Jesús ĩgʉ̃ turari merã iri ĩmumakʉ̃ ĩãdʉagʉ iriadiyupʉ. Irasirigʉ ĩgʉ̃ pʉro ĩgʉ̃sã Jesúre ãĩjamakʉ̃ ĩãgʉ̃, bʉro ʉsʉyayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wári Jesúre sẽrẽñadiyupʉ. Ĩgʉ̃ sẽrẽñakeremakʉ̃, Jesús gapʉ ĩgʉ̃rẽ neõ yʉjʉbiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Paía oparã, Moisés gojadeare buerimasãde Herodes pʉro ejanerã, Jesúre turaro merã weresãñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pʉrʉ Herodes ĩgʉ̃ya surara merã Jesúre bʉrida, ñerõ iriñurã. Ĩgʉ̃rẽ bʉridarã, õãrĩ surírore opʉyañerẽ sãñurã. Irasiri odo, Herodes: “Ĩgʉ̃rẽ Pilato pʉrogue ãĩaka doja!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodes, Pilato merã iro dupiyuroguere gãme ĩãdʉabirinerã ããrĩkererã, irinʉ merã gãmesʉriñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pʉrʉ Pilato paía oparãrẽ, judío masaka oparãrẽ, masakadere siiu neeõ, ");
INSERT INTO sri_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ãsũ ãrĩyupʉ: —Mʉsã ĩĩrẽ yʉ pʉro ãĩjarã: “Ĩĩ masakare ñerõ iridoremi”, ãrãbʉ mʉsã yʉre. Mʉsã ĩũrõ, yʉ ĩĩrẽ sẽrẽñapeoabʉ. Mʉsã ĩĩrẽ weresãkeremakʉ̃, ĩĩ ñerõ iridea máa, yʉ ĩãmakʉ̃. ");
INSERT INTO sri_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodede: “Ĩĩrẽ neõ ñerĩ iridea máa”, ãrãyupʉ. Dupaturi ĩĩrẽ yʉ pʉro iriuañumi doja. Irasiriro ĩĩrẽ wẽjẽdoreri máa. Mʉsãde ire masĩa. ");
INSERT INTO sri_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Irasirigʉ yʉ ĩgʉ̃rẽ tãrãdoregʉkoa. Pʉrʉ ĩgʉ̃rẽ wiugʉra, ãrãdiyupʉ Pilato. ");
INSERT INTO sri_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato, bojorikʉ pascua bosenʉ ããrĩmakʉ̃, sugʉ peresugue ããrãdire ĩgʉ̃sã wiudoregʉre wiunayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Irasirirã, Pilato: “Jesúre wiugʉra”, ĩgʉ̃ ãrĩmakʉ̃ pérã, ããrĩpererã masaka suro merã ãsũ ãrĩ gaguinínʉgãñurã: —Jesúre wẽjẽkõãka! Barrabás gapʉre wiuka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ĩĩ Barrabáre iro dupiyuro Jerusalẽ́gue oparãrẽ ĩgʉ̃ béodʉadea waja, gajirãrẽ ĩgʉ̃ wẽjẽdea waja, peresu irinerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato Jesús gapʉre wiudʉadiyupʉ. Irasirigʉ masakare ĩgʉ̃rẽ wiuburire dupaturi sẽrẽñayupʉ doja. ");
INSERT INTO sri_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ĩgʉ̃ Jesúre wiudʉakeremakʉ̃, ĩgʉ̃sã gaguiníadero nemorõ gaguiníñurã doja: —Curusague pábiatú wẽjẽka ĩgʉ̃rẽ! Wẽjẽkõãka ĩgʉ̃rẽ! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Pilato ʉrea waaró merã ĩgʉ̃sãrẽ ãsũ ãrãdiyupʉ doja: —¿Ñeéno ñerĩrẽ iriari ĩĩ, mʉsã irasũ ãrĩ gaguinímakʉ̃? Yʉ ĩãmakʉ̃, neõ ĩgʉ̃rẽ ñerĩ iridea máa. Irasiriro ĩĩrẽ wẽjẽdoreri máa. Irasirigʉ ĩgʉ̃rẽ tãrãdore, wiugʉra, ãrãdiyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ĩgʉ̃ irasũ ãrĩmakʉ̃, masaka, paía oparãde bʉro gaguinínemo: “Curusague pábiatú wẽjẽka ĩgʉ̃rẽ!” ãrĩñurã. Pilato, ĩgʉ̃sã irasũ ãrĩ gaguinímakʉ̃ neõ bokatĩũbiri: “Mʉsã gããmerõ irika!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Irasirigʉ, ĩgʉ̃sã ãrĩrõsũta Jesúre curusague pábiatú wẽjẽdoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pʉrʉ ĩgʉ̃sã sẽrẽrõsũta Barrabáre peresugue ããrĩgʉ̃́rẽ, oparãrẽ béodʉadire, masakare wẽjẽdi gapʉre wiuyupʉ. Irasiri odo, Pilato: “Mʉsã gããmerõsũ irika Jesúre!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesúre curusague wẽjẽmurã ĩgʉ̃sã ãĩwãgãripoe sugʉ Simón wãĩkʉgʉ Cirene wãĩkʉri makãmʉ Jerusalén tʉrogue ããrãdi goedujariyupʉ. Irasirirã ĩgʉ̃rẽ bokatĩrĩ, ñeã, Jesús kõãdea curusare kõãtʉyadoreñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wárã masaka Jesúre waaburire ĩãrã ĩgʉ̃rẽ tʉyañurã. Ĩgʉ̃sã watopegue nome ĩgʉ̃rẽ ĩãrã, gaguiní bʉjawereri merã oretʉyañurã. ");
INSERT INTO sri_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ĩgʉ̃sã oremakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ĩãgãmeu, ãsũ ãrĩyupʉ: —Jerusalén marã nome yʉre orebirikõãka! Mʉsã basi, mʉsã pũrãya ããrĩburire oreka! ");
INSERT INTO sri_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pʉrʉgue masaka ñetariro tarirãkuma. Ãsũ ãrĩrãkuma: “Neõ pũrãkʉmerã, miũñamerã nome ããrĩmakʉ̃ õãtaribuyo”, ãrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ʉ̃tãyukure ãsũ ãrĩrãkuma: “Gʉare tãũ wẽjẽ, dedeukõãburo”, ãrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Masaka yʉre waja opabire ñerõ irimakʉ̃, waja oparã gapʉ ñetariro tarirãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesúre ãĩwãgãrã, pẽrã ñerõ iririmasãdere ĩgʉ̃ merã wẽjẽsũmurãrẽ ãĩwãgãñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ĩgʉ̃sãrẽ ãĩwãgãrã, masakʉ dipuru boaweadea pero wãĩkʉrogue eja, Jesúre curusague pábiatú ãĩwãgũnúñurã. Ñerõ iririmasãdere curusarigue pábiatú ãĩwãgũnúñurã. Sugʉre ĩgʉ̃ diaye gapʉ, gajigʉre ĩgʉ̃ kúgapʉ pábiatú ãĩwãgũnúñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ĩgʉ̃sã Jesúre curusague pábiatú ãĩwãgũnúmakʉ̃, Jesús ãrĩyupʉ: —Aʉ, ĩgʉ̃sã ñerõ iririre kãtika! Ĩgʉ̃sã yʉre irasiririre pémasĩbema, ãrĩyupʉ. Surara ĩgʉ̃ surí sãñadeare: “Ubu ãrĩboka birarã: ‘¿Noãrẽ dujarokuri?’” ãrĩñurã irire ĩgʉ̃sã basi gãme dʉkawamurã. ");
INSERT INTO sri_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Masaka irogue ããrĩrã́ ĩãníñurã. Oparãgueta Jesúre ãsũ ãrĩ bʉridañurã: —Gajirã gapʉre taumi. Irasirigʉ diayeta Cristo, Marĩpʉ beyedi ããrĩgʉ̃́ ĩgʉ̃ basi tauburo, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Surarade ĩgʉ̃rẽ bʉridañurã. Ĩgʉ̃ pʉro waa ejanʉgãrã, igui deko sʉ̃ĩrĩrẽ ĩgʉ̃rẽ iirídoreadiñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Irire irirã, ĩgʉ̃rẽ ãsũ ãrĩñurã: —Mʉ diayeta judío masaka Opʉ ããrĩgʉ̃́, mʉ basi tauka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","“Ĩĩ ãsũ iridea waja boami”, ãrĩrã: “Ĩĩta judío masaka Opʉ ããrĩ́mi”, ãrĩ gojadea majĩrẽ curusague ĩgʉ̃ weka pábiatúñurã. Griego ya merã, latín ya merã, hebreo ya merã gojasũyuro. ");
INSERT INTO sri_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sugʉ ñerõ iridi, Jesús merã ĩgʉ̃sã pábiatú ãĩwãgũnúdi Jesúre ñerõ ãrĩ turiyupʉ: —Mʉ diayeta Cristo ããrĩgʉ̃́, mʉ baside tau, gʉadere tauka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, gajigʉ gapʉ ĩgʉ̃rẽ ãsũ ãrĩyupʉ: —Irasũ ãrĩbirikõãka! ¿Marĩpʉre güiberi irasũ ãrĩgʉ̃? Marĩrẽ suro merã wajamoãma. ");
INSERT INTO sri_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Marĩ gapʉre marĩ ñerĩ iridea waja diayeta wajamoãma. Ĩĩ gapʉ ñerĩrẽ neõ iribi ããrĩ́mi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Irasũ ãrĩ odo, Jesúre ãsũ ãrĩyupʉ: —Jesús, mʉyarã Opʉ ñajãgʉ̃, yʉdere gũñaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—Diayeta mʉrẽ werea. Dapagãta yʉ merã paraíso wãĩkʉrogue ããrĩgʉkoa, ãrĩyupʉ Jesús ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pʉrʉ goeripoe ããrĩmakʉ̃, i nikũ ããrĩpererogue naĩtĩãkõãyuro. Ʉre hora gora naĩtĩãyuro. ");
INSERT INTO sri_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Abede deyomarĩyupʉ irasũ waaripoere. Marĩpʉya wii poekama taribu makãpʉro kãmutari gasiro deko merã yeguesiajakõãyuro. ");
INSERT INTO sri_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Irasirigʉ Jesús turaro merã ãsũ ãrĩ gaguiníyupʉ: —Aʉ, yaa yʉjʉpũrãrẽ mʉrẽ wiáa, ãrĩyupʉ. Irasũ ãrĩgʉ̃ta, kõmoakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Romano marã surara opʉ irasũ waamakʉ̃ ĩãgʉ̃, Marĩpʉre ʉsʉyari sĩyupʉ. Ãsũ ãrĩyupʉ: —Diayeta ĩĩ ñerõ iribi ããrãdañumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ããrĩpererã masaka iro Jesúre waaríre ĩãrã ejanerã ĩgʉ̃ boamakʉ̃ ĩãrã, bʉro bʉjawereri merã ĩgʉ̃sãya koretibirire páwãgã, ĩgʉ̃sãya wiirigue dujáakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ããrĩpererã Jesús merãmarã, Galileague ĩgʉ̃rẽ tʉyanerã nomede yoarogue Jesúre irasũ waaríre ĩãníñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Irogue sugʉ José wãĩkʉgʉ Judea nikũmʉ, Arimatea wãĩkʉri makãmʉ ããrĩyupʉ. Ĩgʉ̃ õãgʉ̃, diayemarẽ irigʉ, Marĩpʉ ĩgʉ̃yarãrẽ doreri ejaburire yúgʉ ããrĩyupʉ. Ĩgʉ̃ judío masaka oparã watopemʉ ããrĩkeregʉ, Jesúre ĩgʉ̃sã: “Wẽjẽka!” ãrĩmakʉ̃ pégʉ: “Jáʉ”, ãrĩbiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Irasirigʉ Pilato pʉrogue waa, Jesúya dʉpʉre yáabu sẽrẽyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sẽrẽ odo, Jesúya dʉpʉre curusague ããrĩrĩ́ dʉpʉre ãĩdiju, õãrĩ surí gasiro merã õmayupʉ. Õma odo, ʉ̃tãyegue mádea gobegue píyupʉ. Iri gobe neõ sugʉ boadire yáasũña marĩrĩ gobe ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","José Jesúre yáarinʉ judío masaka siñajãrĩnʉma ããrĩburire ĩgʉ̃sã ãmuyurinʉ ããrĩyuro. I siñajãrĩnʉ ñajãburo mérõgã dʉyayuro. ");
INSERT INTO sri_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileague Jesúre tʉyanerã nome masãgobegue José waamakʉ̃ ĩãrã, waañurã. Iri gobegue Jesúya dʉpʉre ĩgʉ̃ pímakʉ̃ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ĩgʉ̃sã irasũ ĩãdero pʉrʉ, ĩgʉ̃sã ããrĩrĩ́ wiigue dujáakõãñurã. Dujaja, sʉ̃rõrĩrẽ ĩgʉ̃ya dʉpʉre pípeoburire ãmuñurã. Ãmu odo, siñajãrĩnʉ ããrĩmakʉ̃, Moisés dorederosũta siñajãñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Semana ããrĩpʉroririnʉ ããrĩmakʉ̃, boyodujimejãripoe ĩgʉ̃sã nome dupaturi Jesúya dʉpʉre yáadea masãgobegue waañurã. Ĩgʉ̃sã sʉ̃rõrĩ ãmuadeare ãĩãñurã. Gajirã nomede ĩgʉ̃sã merã wapikʉwãgãñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Irogue ejarã, iri gobe biadea ʉ̃tã majĩrẽ gajirogue oyamakʉ̃ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Irire ĩãrã, diayeta ñajãkõãñurã. Irogue ñajãjarã, neõ marĩ Opʉ Jesúya dʉpʉre bokabiriñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Irasirirã bʉro gʉka, naásũ irimasĩbiriñurã. “¿Naásũ waáayuri?” ãrĩ gũñaripoeta gũñaña marĩrõ pẽrã ʉ̃ma surí gosesiriri sãñarã ĩgʉ̃sã pʉro nímakʉ̃ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ĩgʉ̃sãrẽ ĩãrã, bʉro güiri merã muúsiañurã. Ĩgʉ̃sã irasirimakʉ̃ ĩãrã, ʉ̃ma ĩgʉ̃sãrẽ ãrĩñurã: —¿Nasirimurã boanerãrẽ yáarogue okagʉre ãmarĩ? ");
INSERT INTO sri_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Õõrẽ mámi. Masãsiami. Gũñaka, ĩgʉ̃ mʉsã merã Galileague ããrĩgʉ̃́ mʉsãrẽ ãrĩdeare! ");
INSERT INTO sri_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ãsũ ãrĩmi: “Yʉ ããrĩpererã tĩ́gʉ̃ ããrĩgʉ̃́ masaka ñerãguere wiasũgʉkoa. Ĩgʉ̃sã yʉre curusague pábiatú wẽjẽmakʉ̃, ʉrenʉ waaró merã Marĩpʉ yʉre masũgʉkumi”, ãrĩmi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, Jesús ãrĩdeare gũñabokañurã. ");
INSERT INTO sri_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Irasirirã masãgobegue ããrãnerã goedujajarã, ããrĩpereri ĩgʉ̃sã ĩãdeare Jesús buerã pe mojõma pere su gubu suru pẽrẽbejarãrẽ wereñurã. Irasũ ããrĩmakʉ̃, gajirãrẽ Jesúre bʉremurã ããrĩpererãrẽ irire wereñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jesús buerãrẽ iri kerere wererã ejanerã nome ĩĩsãkʉ ããrĩñurã: María Magdalena, Juana, gajigo María Jacob pago, irasũ ããrĩmakʉ̃ gajirã nome ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ĩgʉ̃sã ĩãdeare werekeremakʉ̃, Jesús buerã gapʉ bʉremubiriñurã. “Irasũ ãrĩkõãrã yáma ĩĩsã nome”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro gapʉ masãgobegue ĩãgʉ̃ ũmawãgãyupʉ. Iri gobegue ĩãgʉ̃ ejagʉ, Jesúya dʉpʉre õmadea gasiro gajiro gapʉ túpeoadea gasiro ditare ĩãyupʉ. Irire ĩãgʉka: “¿Naásũ waáayuri?” ãrĩ gũña, ĩgʉ̃ ããrĩrĩ́ wiigue dujáakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jesús masãdeanʉrẽta pẽrã ĩgʉ̃ buerire tʉyarã Emaús wãĩkʉri makã waarí maague waarã́ iriñurã. Emaúgue waaró, Jerusalén merã wiriwãgãmakʉ̃ pe mojõma pere su gubu suru pẽrẽbejari kilómetro yoaro ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Maa waarã́, ããrĩpereri Jesúre waadeare wereníñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Irire wereníripoe Jesús ĩgʉ̃sã pʉro aari, ĩgʉ̃sã merã waayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ĩgʉ̃, ĩgʉ̃sã merã waamakʉ̃ ĩãkeremakʉ̃, gajino ĩgʉ̃sãrẽ ĩgʉ̃rẽ ĩãmasĩbirimakʉ̃ iriyuro. ");
INSERT INTO sri_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús ĩgʉ̃sãrẽ sẽrẽñayupʉ: —¿Ñeénorẽ werenírã yári, mʉsã maa waarã́? ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, bʉro bʉjawereri merã maa deko dujanʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cleofas wãĩkʉgʉ Jesúre ãsũ ãrĩ yʉjʉyupʉ: —Ããrĩpererã inʉrĩ Jerusalẽ́gue waadeare masĩma. ¿Mʉ sugʉta irogue ããrãdi irasũ waadeare masĩberi? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃sãrẽ: —¿Naásũ waáari? ãrĩyupʉ. Ĩgʉ̃rẽ ãrĩñurã: —Jesús Nazaretmʉrẽ ĩgʉ̃sã iriadeare werenírã iriabʉ. Ĩgʉ̃ Marĩpʉya kerere weregʉ ããrãdimi. Ããrĩpererã masaka ĩũrõ, Marĩpʉ ĩũrõguedere ĩgʉ̃ turari sĩrĩ merã irigʉ, ĩgʉ̃yare weregʉ ããrãdimi. ");
INSERT INTO sri_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paía oparã, gajirã marĩ oparã merã ĩgʉ̃rẽ wẽjẽdorerã, romano marã oparãrẽ wiáama. Ĩgʉ̃sã irasũ wiamakʉ̃, curusague pábiatú wẽjẽama. ");
INSERT INTO sri_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Ĩgʉ̃ marĩrẽ taubu, marĩ Israel bumarã Opʉ ããrĩbu, marĩ yúdi ããrĩ́mi”, ãrĩ gũñadibʉ gʉa ĩgʉ̃rẽ. Irasiriro dapagã merã ʉrenʉ waáa, ĩgʉ̃rẽ wẽjẽadero pʉrʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Surãyeri gʉa merãmarã nome, ĩgʉ̃sã wereri merã gʉare gʉkamakʉ̃ iriama. Dapagã ñamigãgora ĩgʉ̃rẽ yáaderogue ejañurã. ");
INSERT INTO sri_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Irogue eja, ĩgʉ̃ya dʉpʉre bokamerãta, gʉa pʉrogue goedujajama. “Irogue gʉare kẽrõ irirosũ waamakʉ̃, Marĩpʉre wereboerãrẽ ĩãbʉ”, ãrãma. Marĩpʉre wereboerã ĩgʉ̃sãrẽ: “Jesús okami”, ãrãdeadere wereama gʉare ĩgʉ̃sã nome. ");
INSERT INTO sri_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pʉrʉ gajirã gʉa merãmarã ĩgʉ̃rẽ yáaderogue eja, ĩgʉ̃sã nome ãrãderosũta ĩãñurã. Ĩgʉ̃sãde Jesúre ĩãbirañurã, ãrĩ wereñurã Cleofasã Jesúre. ");
INSERT INTO sri_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã pémasĩmerã ããrã. ¿Noópa yoaripoe Marĩpʉya kerere weredupiyunerã gojadeare õãrõ pémasĩrĩ merã bʉremubirikõãrĩ mʉsã? ");
INSERT INTO sri_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Marĩpʉ iriudi Cristo ĩgʉ̃ ʉ̃mʉgasigue mʉrĩaburo dupiyuro, ĩgʉ̃yarã Opʉ ñajãburo dupiyuro ĩgʉ̃rẽ ñerõ tarigʉkumi, ãrĩ gojanerã ããrĩmá. ¿Ire masĩberi mʉsã? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesús irasũ ãrĩ odo, Marĩpʉya kerere weredupiyunerã gojadea pũgue ããrĩpereri ĩgʉ̃sã ĩgʉ̃rẽ gojayudeare: “Ãsũ ãrĩdʉaro yáa”, ãrĩ wereyupʉ ĩgʉ̃sãrẽ. Moisés gojadeare werenʉgãyupʉ. Pʉrʉ ããrĩpererã Marĩpʉya kerere weredupiyunerã gojadeare wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pʉrʉ ĩgʉ̃sã waaró Emaúgue ejamakʉ̃, Jesús iri makãrẽ tariwãgãgʉ̃ irirosũ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ĩgʉ̃ irasũ tariwãgãmakʉ̃ ĩãrã, ĩgʉ̃rẽ ãsũ ãrĩñurã: —Gʉa merã dujaka! Ñamikague ããrã. Naĩmejãrõgue yáa, ãrĩñurã. Irasirigʉ Jesús ĩgʉ̃sã merã waa, ĩgʉ̃sãya wiigue ñajãkõãyupʉ ĩgʉ̃sã merã dujagʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pʉrʉ ĩgʉ̃sã merã baa doanígʉ̃, pã́rẽ ãĩ, Marĩpʉre: “Mʉrẽ ʉsʉyari sĩa”, ãrĩ, pã́rẽ pea, ĩgʉ̃sãrẽ guereyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ĩgʉ̃ irasirimakʉ̃ ĩãrãgueta: “Jesúta ããrĩ́mi”, ãrĩ ĩãmasĩñurã. Ĩgʉ̃sã ĩãmasĩmakʉ̃ta, dederiakõãyupʉ ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ĩgʉ̃ irasũ dederiadero pʉrʉ, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníñurã: —Maague ĩgʉ̃ marĩrẽ: “Marĩpʉya werenírĩ gojadeare: ‘Ãsũ ãrĩdʉaro yáa’”, ãrĩ weremakʉ̃ pérã, bʉro ʉsʉyari merã: “Õãtaria”, ãrĩ péñabʉ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Irasirirã mata Jerusalẽ́gue gãme dujáakõãñurã. Irogue eja, Jesús buerã, pe mojõma pere su gubu suru pẽrẽbejarã nerẽanerãrẽ, gajirã ĩgʉ̃sã merãmarãdere bokajañurã. ");
INSERT INTO sri_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ĩgʉ̃sã ejamakʉ̃ ĩãrã, iro nerẽanerã ãsũ ãrĩñurã: —Diayeta marĩ Opʉ masãñumi. Simṍrẽ deyoayupʉ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, Emaúgue waanerãde ĩgʉ̃sãrẽ maague waadeare wereñurã. Jesús pã́rẽ pea, ĩgʉ̃sãrẽ ĩgʉ̃ sĩmakʉ̃, ĩgʉ̃rẽ ĩãmasĩadeare wereñurã iro nerẽanerãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ĩgʉ̃sã irire irasũ ãrĩ wereníripoe Jesús ĩgʉ̃sãrẽ deyoa, ãsũ ãrĩ õãdoreyupʉ: —¿Ããrĩ́rĩ mʉsã? Siñajãrĩ merã ããrĩrikʉka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ĩgʉ̃ deyoamakʉ̃, ĩãgʉkakõãñurã. “Boadi yʉjʉpũrã deyoamakʉ̃ ĩãrã irikoa marĩ”, ãrĩ gũñañurã. Irasirirã bʉro güiñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ĩgʉ̃sã güimakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃sãrẽ ãrĩyupʉ: —¿Nasirirã ĩãgʉkari mʉsã? ¿Nasirirã yʉre ĩãrã: “Ĩgʉ̃ boadi dupaturi okabiribukumi”, ãrĩ gũñarĩ mʉsã? Irire gũñabirikõãka! ");
INSERT INTO sri_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ĩãka, yaa mojõrĩrẽ, yaa guburidere! Yʉta ããrã. Yʉre moãñaka! Irasirirã masĩrãkoa yʉ ããrĩrĩ́rẽ. Sugʉ boadi ĩgʉ̃ yʉjʉpũrã merã deyoagʉ dʉpʉ opabemi. Dií, gõãrĩ́ opabi ããrĩkumi. Yʉ gapʉ diíre, gõãrĩ́rẽ opáa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Irasũ ããrĩgʉ̃́ta, ĩgʉ̃ya mojõrĩrẽ soeu, ĩgʉ̃ya guburidere ĩmuyupʉ ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ĩgʉ̃sã gapʉ mérõgã bʉremurĩ opakererã, bʉro ʉsʉyari merã: “¿Diayeta ĩgʉ̃ta ããrĩkuri?” ãrĩ gũñañurã. Ĩgʉ̃sã irasũ mérõgã bʉremurĩ opamakʉ̃, Jesús masĩkõãyupʉ. Irasirigʉ ĩgʉ̃sãrẽ sẽrẽñayupʉ: —¿Mʉsã baari opari õõrẽ? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, waaí mupũadea dʉkare sĩñurã. Mume dekodere ĩgʉ̃rẽ sĩñurã baaburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Irire sĩmakʉ̃, ĩgʉ̃sã ĩũrõ ãĩ baayupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Baa odo, Jesús ĩgʉ̃sãrẽ wereyupʉ doja: —Sõõ ããrĩdeapoe mʉsã merã ããrĩgʉ̃́, yʉ mʉsãrẽ werederosũta dapagorare yʉre waabʉ. Moisés yaamarẽ gojaderosũta yʉre waabʉ. Marĩpʉya kerere weredupiyunerã gojaderosũta, Salmos wãĩkʉri pũrẽ gojanerãde ĩgʉ̃sã yʉre gojaderosũta waabʉ. Ããrĩpereri Marĩpʉ ĩgʉ̃sãrẽ irasũ gojadorederosũta yʉre waabʉ, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Irasũ ãrĩ odo, Marĩpʉya werenírĩ gojadeare ĩgʉ̃sãrẽ pémasĩmakʉ̃ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ãsũ ãrĩyupʉ: —Iripoegue Marĩpʉya kerere weredupiyunerã gojadea pũgue ãsũ gojasũdero ããrĩbʉ́: “Cristo, Marĩpʉ iriudi boakõãgʉkumi. Ĩgʉ̃ boagʉ, ʉrenʉ waaró merã masãgʉkumi doja. ");
INSERT INTO sri_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ĩgʉ̃ masãdero pʉrʉ, ĩgʉ̃rẽ bʉremurã ĩgʉ̃ya wãĩ, ĩgʉ̃ turaro merã ããrĩpereri nikũ marãguere ĩgʉ̃ya kerere weregorenarãkuma. Jerusalén marãrẽ werepʉroriwãgãrãkuma. Ãsũ ãrĩ wererãkuma: ‘Mʉsã ñerĩ iririre bʉjawereka! Mʉsã gũñarĩrẽ gorawayuka! Irasirigʉ Marĩpʉ mʉsã ñerĩ irideare kãtigʉkumi’”, ãrĩrãkuma, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mʉsã i ããrĩpereri yʉre waadeare ĩãnerã ããrã. Irasirirã irire gajirãrẽ wererãkoa. ");
INSERT INTO sri_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yʉpʉ iripoegue ãrĩderosũta yʉ mʉsãrẽ Õãgʉ̃ deyomarĩgʉ̃rẽ iriugʉra, ĩgʉ̃ mʉsãguere ããrĩníkõãburo, ãrĩgʉ̃. Irasirirã õõ Jerusalẽ́ta dujaka dapa, ĩgʉ̃ mʉsãrẽ ʉ̃mʉgasima turarire sĩgʉ̃ aarimakʉ̃, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pʉrʉ Jesús ĩgʉ̃sãrẽ Betania wãĩkʉri makã tʉrogue ãĩayupʉ. Irogue eja, Jesús ĩgʉ̃ya mojõrĩ soemu: “Yʉpʉ mʉsãrẽ õãrõ iritamuburo”, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Irasũ ãrĩgʉ̃ta ĩgʉ̃sãrẽ píkõã, ʉ̃mʉgasigue ãĩmʉrĩãkõãsũyupʉ. ");
INSERT INTO sri_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ĩgʉ̃sã, ĩgʉ̃ mʉrĩãmakʉ̃ ĩãrã: “Õãtarigʉ ããrĩ́mi”, ãrĩ bʉremuñurã. Pʉrʉ bʉro ʉsʉyari merã Jerusalẽ́gue goedujáakõãñurã. ");
INSERT INTO sri_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ʉ̃mʉrikʉ Marĩpʉya wiigue ĩgʉ̃rẽ: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩnañurã. Ãsũ ããrã. Irasũta ããrĩburo. Lucas");
INSERT INTO sri_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Neõgoragueta i ʉ̃mʉ ããrĩburi dupiyuro Jesucristo Marĩpʉya werenírĩrẽ weregʉ ããrĩsiadi ããrĩmí. Marĩpʉ merã ããrĩgʉ̃́, Marĩpʉta ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Neõgoragueta ĩgʉ̃ Marĩpʉ merã ããrĩsiadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Irasirigʉ Marĩpʉ ĩgʉ̃ merã i ʉ̃mʉma ããrĩburi ããrĩpererire iridi ããrĩmí. Irasiriro i ʉ̃mʉma ããrĩpereri Marĩpʉ ĩgʉ̃ merã iridea ããrã. ");
INSERT INTO sri_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jesucristo, Marĩpʉ merã perebiri okarire sĩgʉ̃ ããrĩ́mi. I okari merã masakare sĩãgori sĩgʉ̃ ããrĩ́mi. Irasirigʉ ĩgʉ̃sãrẽ Marĩpʉre masĩmakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Marĩpʉre masĩmerã naĩtĩãrõgue ããrĩrã́ irirosũ ããrĩ́ma. Jesucristo sĩãgori sĩgʉ̃ ããrĩgʉ̃́ ĩgʉ̃sãrẽ Marĩpʉre masĩmakʉ̃ yámi. Naĩtĩãrĩ sĩãgorire neõ yaumasĩbea. ");
INSERT INTO sri_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jesucristo i ʉ̃mʉgue aariburi dupiyuro Marĩpʉ Juan wãĩkʉgʉre iriudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan, Jesús masakare sĩãgori sĩgʉ̃ ããrĩgʉ̃́ ĩgʉ̃ i ʉ̃mʉgue aariburire weremi, ããrĩpererã irire pérã ĩgʉ̃rẽ bʉremuburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan masakare sĩãgori sĩgʉ̃ ããrĩgʉ̃́ meta ããrĩmí. Ĩgʉ̃sãrẽ Jesucristo aariburi gapʉre weredupiyudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesucristo diayeta ããrĩpererã masakare sĩãgori sĩgʉ̃ ããrĩgʉ̃́ i ʉ̃mʉgue ããrĩrã́rẽ Marĩpʉre masĩmakʉ̃ irigʉ aaridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jesucristo i ʉ̃mʉguere ããrĩdi ããrĩmí. Marĩpʉ ĩgʉ̃ merã i ʉ̃mʉrẽ irikeremakʉ̃, i ʉ̃mʉ marã gapʉ ĩgʉ̃rẽ neõ masĩbirinerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ĩgʉ̃ya nikũgue aarikeremakʉ̃, ĩgʉ̃ya nikũ marã gapʉ ĩgʉ̃rẽ bokatĩrĩñeãbirinerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ĩgʉ̃rẽ bokatĩrĩñeã, bʉremurã gapʉre Marĩpʉ pũrã ããrĩmakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ĩgʉ̃sã pagʉsãmarã ĩgʉ̃sãrẽ pũrãkʉrã, Marĩpʉ pũrã ããrĩmakʉ̃ iribema. Irasũ ããrĩmakʉ̃, ĩgʉ̃sã pagʉ ĩgʉ̃ gããmerõ iriri merã ĩgʉ̃sãrẽ Marĩpʉ pũrã ããrĩmakʉ̃ iribemi. Marĩpʉ gapʉ ĩgʉ̃sãrẽ ĩgʉ̃ pũrã ããrĩmakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesucristo, Marĩpʉya werenírĩrẽ weregʉ marĩ irirosũ dʉpʉkʉgʉ ããrĩnʉgãdero pʉrʉ, i ʉ̃mʉgue gʉa merã ããrĩgʉ̃́, masakare bʉro maĩrĩ merã, diaye werenígʉ̃ ããrĩmí. Gʉa ĩgʉ̃ gosesiririre ĩãbʉ. Ĩgʉ̃ Marĩpʉ magʉ̃ sugʉ ããrĩgʉ̃́, ĩgʉ̃ irirosũta turagʉ, õãgʉ̃ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan masakare wãĩyedi Jesucristore ĩãgʉ̃, gʉare ãsũ ãrĩ weremi: —Ĩĩ ããrĩ́mi yʉ mʉsãrẽ weredi. Mʉsãrẽ ãsũ ãrĩ werebʉ: “Ĩgʉ̃ yʉ pʉrʉ aarikeregʉ, yʉ deyoaburo dupiyuro ããrĩsiadi ããrĩmí. Irasirigʉ yʉ nemorõ ããrĩ́mi”. ");
INSERT INTO sri_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesucristo marĩrẽ maĩtarigʉ ããrĩsĩã, marĩ ããrĩpererãrẽ õãrõ iritamuníkõãmi. ");
INSERT INTO sri_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Marĩpʉ ĩgʉ̃ dorerire Moisés merã marĩrẽ pídi ããrĩmí. Jesucristo merã gapʉre Marĩpʉ ĩgʉ̃ marĩrẽ maĩrĩrẽ, ĩgʉ̃ werenírĩ diaye ããrĩrĩ́rẽ ĩmumi. ");
INSERT INTO sri_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Neõ sugʉ masakʉ Marĩpʉre ĩãdi mámi. Jesucristo ĩgʉ̃ magʉ̃ sugʉ ããrĩgʉ̃́ gapʉ ĩgʉ̃ Pagʉ merã ããrĩsĩã, marĩrẽ ĩgʉ̃rẽ masĩmakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judío masaka oparã Jerusalén ããrĩrã́ paíare, Levíya bumarãdere Juan pʉrogue ĩgʉ̃rẽ: “¿Noã ããrĩ́rĩ mʉ?” ãrĩ sẽrẽñadorerã iriuñurã. ");
INSERT INTO sri_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ĩgʉ̃sã irasũ ãrĩ sẽrẽñarã ejamakʉ̃, Juan ĩgʉ̃sãrẽ pémasĩma õãrõ ãsũ ãrĩ yʉjʉmi: —Yʉ, Cristo Marĩpʉ masakare taudoregʉ iriudi ããrĩbea, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Irasirirã ĩgʉ̃rẽ dupaturi sẽrẽñama doja: —Iro merẽ, ¿niíno gapʉ ããrĩ́rĩ? ¿Iripoeguemʉ Marĩpʉya kerere weredupiyudi Elías ããrĩ́rĩ? ãrĩma. Juan ĩgʉ̃sãrẽ yʉjʉmi: —Ããrĩbea, ãrĩmi. Ĩgʉ̃ irasũ yʉjʉmakʉ̃ pérã, dupaturi ĩgʉ̃rẽ sẽrẽñama doja: —¿Mʉ, sõõ ããrĩdeapoe masaka Marĩpʉya kerere weredupiyugʉ aaribu ããrãyupʉ, ĩgʉ̃sã ãrĩdi ããrĩ́rĩ? ãrĩma. Juan yʉjʉmi: —Ããrĩbea. ");
INSERT INTO sri_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Irasirirã ĩgʉ̃rẽ ãsũ ãrĩma: —¿Niíno gapʉ ããrĩ́rĩ? Gʉare iriuanerã ĩgʉ̃sã pʉrogue mʉ yʉjʉrire gʉa ãĩãmakʉ̃ gããmema. Irasirigʉ wereka gʉare! Mʉ basi, ¿naásũ ãrĩ gũñarĩ? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Irasirigʉ Juan iripoeguemʉ Isaías Marĩpʉya kerere weredupiyudi gojadea merã ĩgʉ̃sãrẽ ãsũ ãrĩ yʉjʉmi: —Masaka marĩrõgue sugʉ bʉro bʉsʉro merã were gaguinígorenagʉ̃ ãsũ ãrĩ werea: “Marĩ Opʉ aariburi dupiyuro ĩgʉ̃ aariburi maarẽ́ diayema maa õãrĩ maa ãmurã́ irirosũ diayemarẽ irika!” ãrĩ werea, ãrĩmi Juan. ");
INSERT INTO sri_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ĩgʉ̃ irasũ ãrĩ yʉjʉmakʉ̃ pérã, fariseo bumarã iriuanerã ĩgʉ̃rẽ sẽrẽñama doja: —Mʉ, Cristo Marĩpʉ iriudi, o Elías, o sõõ ããrĩdeapoe Marĩpʉya kerere weredupiyudi ããrã, ãrĩbi, ¿nasirigʉ masakare wãĩyeri? ");
INSERT INTO sri_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan ĩgʉ̃sãrẽ ãrĩmi: —Yʉ masakare deko merã wãĩyea. Sugʉ mʉsã watopeguere mʉsã masĩbi ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ĩgʉ̃, yʉ pʉrʉ aarikeregʉ, yʉ nemorõ ããrĩ́mi. Yʉ ubu ããrĩgʉ̃́, ĩgʉ̃rẽ neõ sʉropebirikoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juan ĩgʉ̃ masakare wãĩyenarõgue Betania wãĩkʉro, dia Jordán wãĩkʉdiya abe mʉrĩriro gapʉ i ããrĩpererire ĩgʉ̃sãrẽ weremi. ");
INSERT INTO sri_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Gajinʉ gapʉ Juan, Jesús ĩgʉ̃ pʉro aarimakʉ̃ ĩãgʉ̃, gʉare ãsũ ãrĩmi: —Ĩãka! Ĩĩ Marĩpʉ iriudi, oveja majĩgʉ̃ irirosũ ããrĩ́mi. Ĩgʉ̃ boari merã i ʉ̃mʉ marãrẽ ĩgʉ̃sã ñerõ iridea wajare peremakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ĩĩta ããrĩ́mi yʉ mʉsãrẽ iro dupiyuro ãsũ ããrĩ́mi, ãrĩ weredi. “Ĩgʉ̃ yʉ pʉrʉ aarikeregʉ, yʉ deyoaburo dupiyuro ããrĩsiadi ããrĩmí. Irasirigʉ yʉ nemorõ ããrĩ́mi”, ãrĩ werebʉ. ");
INSERT INTO sri_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yʉde ĩgʉ̃rẽ: “Marĩpʉ iriudi ããrĩ́mi”, ãrĩmasĩbiribʉ. Ĩgʉ̃rẽ masĩbirikeregʉ, Israel bumarã masakare deko merã wãĩyegʉ aarigʉ́ iribʉ, ĩgʉ̃sã ĩgʉ̃rẽ masĩburo, ãrĩgʉ̃, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Irasũ ãrĩ odo, Juan ãsũ ãrĩ werenemomi doja: —Õãgʉ̃ deyomarĩgʉ̃ ʉ̃mʉgasigue merã buja irirosũ deyogʉ dijari, Cristo weka ejamakʉ̃ ĩãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Marĩpʉ yʉre masakare deko merã wãĩyedoredi dupiyurogue ãsũ ãrĩmi: “Mʉ Õãgʉ̃ deyomarĩgʉ̃ dijari, sugʉ masakʉ weka ejamakʉ̃ ĩãgʉkoa. Ĩgʉ̃ta masakare Õãgʉ̃ deyomarĩgʉ̃ merã wãĩyegʉkumi, ĩgʉ̃ ĩgʉ̃sã merã ããrĩníkõãburo, ãrĩgʉ̃”, ãrĩmi Marĩpʉ yʉre. ");
INSERT INTO sri_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Irasũ waamakʉ̃ ĩãgʉ̃: “Ĩgʉ̃ta Marĩpʉ magʉ̃ ããrĩ́mi”, ãrĩ masĩbʉ. Irasirigʉ mʉsãrẽ irire werea, ãrĩmi Juan. ");
INSERT INTO sri_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Gajinʉ gapʉ irogueta Juan dupaturi ããrĩmí doja. Gʉa pẽrã ĩgʉ̃ buerã ĩgʉ̃ merã ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús gʉa pʉro tariamakʉ̃ ĩãgʉ̃, Juan ãsũ ãrĩmi: —Ĩãka! Ĩĩ oveja majĩgʉ̃ irirosũ Marĩpʉ iriudi ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa pẽrã Juan buerã Jesúre tʉyabʉ. ");
INSERT INTO sri_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Irasirigʉ, gʉa ĩgʉ̃rẽ tʉyamakʉ̃ gãmenʉgã ĩã: —¿Ñeénorẽ gããmerĩ? ãrĩmi. Gʉa ĩgʉ̃rẽ ãrĩbʉ: —¿Buegʉ, noógue ããrãrĩ mʉ? ");
INSERT INTO sri_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ĩgʉ̃ gʉare ãrĩmi: —Ĩãrã aarika! Irasirirã gʉa ĩgʉ̃ merã waa, ĩgʉ̃ kãrĩrõgue ñamika cuatro hora ããrĩmakʉ̃ ejabʉ. Irogue eja, iri ñamirẽ ĩgʉ̃ merã ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Gʉa pẽrã: yʉ, Andrés merã Juan weredeare pénerã ããrĩsĩã, Jesúre tʉyabʉ. Andrés, Simón Pedro pagʉmʉ ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Gajinʉ gapʉ, Andrés ĩgʉ̃ tĩ́gʉ̃ Simón Pedrore ãmapurumugʉ̃ waami. Ĩgʉ̃ pʉrogue eja, ĩgʉ̃rẽ ãrĩyupʉ: —Marĩpʉ iriudi Mesíare bokajabʉ, ãrĩyupʉ. “Mesías”, ãrĩrõ: “Cristo”, ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Irasirigʉ Andrés Simṍrẽ Jesús pʉrogue ãĩjami. Jesús ĩgʉ̃rẽ ĩãgʉ̃, ãsũ ãrĩmi: —Mʉ, Simón wãĩkʉgʉ Jonás magʉ̃ ããrã. Pʉrʉ mʉ “Cefas” wãĩkʉgʉkoa, ãrĩmi. “Cefas”, ãrĩrõ: “Pedro”, ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Gajinʉ gapʉ Jesús: “Galilea nikũgue waagʉra”, ãrĩ, Felipere bokaja: —Náka, yʉ merã! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe Betsaida wãĩkʉri makãmʉ ããrĩmí. Pedro, Andrésãde iri makã marãta ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesús ĩgʉ̃rẽ: “Náka!” ãrĩmakʉ̃ pégʉ, Felipe Natanaere siiugʉ waami. Ĩgʉ̃ pʉrogue eja, ĩgʉ̃rẽ ãrĩyupʉ: —Moisés ĩgʉ̃ya doreri gojadea pũgue ĩgʉ̃ gojadire bokajabʉ. Marĩpʉya kerere weredupiyunerãde ĩgʉ̃rẽta gojanerã ããrĩmá. Ĩgʉ̃sã gojadi Jesús Nazaretmʉ, José magʉ̃ ããrãmi, ãrĩyupʉ Felipe. ");
INSERT INTO sri_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Natanael gapʉ ĩgʉ̃rẽ ãrĩyupʉ: —Neõ sugʉ Nazaretmʉ õãrõ irigʉ mámi, ãrĩyupʉ. Felipe gapʉ ĩgʉ̃rẽ ãrĩyupʉ: —Náka, ĩmusi. ");
INSERT INTO sri_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús, Natanael ĩgʉ̃ pʉro ejarimakʉ̃ ĩãgʉ̃, ãsũ ãrĩmi: —Ĩĩ õãgʉ̃, diayeta Israel bumʉgora, ãrĩkatori marĩgʉ̃ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Natanael ĩgʉ̃rẽ sẽrẽñami: —¿Naásũpero merã yʉre masĩrĩ mʉ? Jesús ãrĩmi: —Felipe, mʉrẽ siiuburi dupiyuro higueragʉ doka mʉ ããrĩmakʉ̃ ĩãbʉ, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Natanael ĩgʉ̃rẽ ãrĩmi: —Buegʉ, mʉ Marĩpʉ magʉ̃, Israel bumarã Opʉ ããrã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús ĩgʉ̃rẽ ãrĩmi: —Yʉ mʉrẽ: “Higueragʉ doka mʉ ããrĩmakʉ̃ ĩãbʉ”, ãrĩrĩ ditare pésĩã, yʉre bʉremua. Pʉrʉguere i nemorõ Marĩpʉ turari merã yʉ iri ĩmurĩrẽ ĩãgʉkoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ãsũ ãrĩnemomi doja: —Diayeta mʉsãrẽ werea. Pʉrʉguere ʉ̃mʉgasi tũpãmakʉ̃ ĩãrãkoa. Irasũ tũpãmakʉ̃, Marĩpʉre wereboerã yʉ ããrĩpererã tĩ́gʉ̃ pʉrore mʉrĩãna, dijarina irimakʉ̃ ĩãrãkoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jesús Felipere, Natanaere siiudero pʉrʉ, ʉrenʉ waaró merã, Galilea nikũguere Caná wãĩkʉri makãrẽ sugʉ mojõsʉadiya bosenʉ ããrĩbʉ́. Jesús pagode iri bosenʉrẽ ĩãgõ waamo. ");
INSERT INTO sri_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Gʉa Jesús buerãdere, ĩgʉ̃ merã iri bosenʉrẽ ĩãdorerã siiuma. ");
INSERT INTO sri_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pʉrʉ iri bosenʉma igui deko peremakʉ̃ ĩãgõ, Jesús pago ĩgʉ̃rẽ ãrĩmo: —Igui deko pereakõãbʉ ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Igo irasũ ãrĩmakʉ̃ pégʉ, Jesús ãrĩmi: —¿Nasirigo irire yʉre wereri mʉ? Masaka yʉre masĩburo dʉyakõãa dapa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Igo gapʉ, ĩgʉ̃ irasũ ãrĩkeremakʉ̃, tĩãboerãrẽ ãrĩmo: —Yʉ magʉ̃ mʉsãrẽ dorerosũta irika! ");
INSERT INTO sri_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Iri wiiguere su mojõma pere gaji mojõ suru pẽrẽbejari sorori ʉ̃tãyeri merã iridea sorori ããrĩbʉ́. Judío masaka Marĩpʉ dorederosũ irirã ĩgʉ̃sã gʉrari koeburi deko duripíri sorori ããrĩbʉ́. Sororikʉ wáro deko cincuenta o setenta litros ejari sorori ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús tĩãboerãrẽ ãrĩmi: —I sororire deko piusã ʉtʉudobopeokõãka! ãrĩmi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, iri sororire piusã, ʉtʉudobopeokõãma. ");
INSERT INTO sri_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ĩgʉ̃sã odomakʉ̃, Jesús ãrĩmi: —Mérõ ãĩsĩã, bosenʉ siiu irigʉre tĩãrã waaka! ãrĩmi. “Jáʉ” ãrĩ, ãĩãma. ");
INSERT INTO sri_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Iri bosenʉ siiu irigʉ Jesús dekoreta igui deko iriadeare masĩbirimi. Tĩãboerã dita irire masĩma. Irasirigʉ iri bosenʉ siiu irigʉ irire iiríñagʉ̃, mojõsʉadire siiu, ãsũ ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Gajirã igui deko õãrĩrẽ tĩãdorepʉrorikuma. Pʉrʉ ĩgʉ̃sã siiuanerã wáro iiríadero pʉrʉ, igui deko ubu ããrĩrĩ́rẽ tĩãdorekuma pama. Mʉ gapʉ igui deko õãrĩrẽ duripíayo gʉare tĩãtũnubu, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús Galilea nikũma makã Caná wãĩkʉri makãgue irire irigʉ, Marĩpʉ turaro merã iri ĩmupʉrorimi. Ĩgʉ̃ irasirimakʉ̃ ĩãrã, gʉa ĩgʉ̃ buerã: “Diayeta Marĩpʉ iriudi ããrĩ́mi”, ãrĩ bʉremubʉ. ");
INSERT INTO sri_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pʉrʉ Jesús Capernaum wãĩkʉri makãgue waakõãmi. Ĩgʉ̃ pago, ĩgʉ̃ pagʉpũrã, gʉa ĩgʉ̃ buerãde ĩgʉ̃ merãta waabʉ. Iri makãgue eja, yoaweyaripoe ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua bosenʉ mérõ dʉyaripoe Jesús Jerusalén wãĩkʉri makãgue waami. ");
INSERT INTO sri_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Irogue ejagʉ, Marĩpʉya wiigue ñajãa, wekʉa, oveja, buja duarimasãrẽ bokajami. Irasũ ããrĩmakʉ̃, niyeru gorawayurimasã ĩgʉ̃sãya kũmarĩ pʉro doarãrẽ bokajami. ");
INSERT INTO sri_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ĩgʉ̃sã irasirimakʉ̃ ĩãgʉ̃, pũgubu merã tãrãridari iri, ĩgʉ̃sãrẽ, ĩgʉ̃sãyarã ovejare, wekʉare makãgue tãrãnʉrʉ̃wiumi. Niyeru gorawayurimasãrẽ ĩgʉ̃sãya niyeru kũmarĩrẽ túmeépísirimi. ");
INSERT INTO sri_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Irasiri odo, buja duarimasãrẽ ãsũ ãrĩmi: —Ĩĩsãrẽ ãĩwiriaka! Yʉpʉya wiire doebiri duari wii iribirikõãka! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa ĩgʉ̃ buerã Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojadeare gũñabokabʉ: Yʉ Opʉ, mʉya wiire bʉro maĩa. Ĩgʉ̃sã iri wiire ñerõ irimakʉ̃ ĩãgʉ̃, bʉro bʉjawereri merã ããrã, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judío masaka oparã Jesús irasirimakʉ̃ ĩãrã, ĩgʉ̃rẽ sẽrẽñama: —¿Nasirigʉ ĩgʉ̃sãrẽ béowiuari? Marĩpʉ irire mʉrẽ iridoremakʉ̃, ĩgʉ̃ turari merã iri ĩmuka, gʉa masĩma õãrõ! ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús ĩgʉ̃sãrẽ ãrĩmi: —I wiire mʉsã béomakʉ̃, ʉrenʉ merãta yʉ dupaturi odonúgʉkoa doja, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ãrĩma: —I wiire irirã, cuarenta y seis bojorigora irima. ¿Nasiribu mʉ gapʉ ʉrenʉ merãta odobukuri? ");
INSERT INTO sri_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús iri wiire weregʉ, ĩgʉ̃ya dʉpʉ gapʉre weregʉ irimi. ");
INSERT INTO sri_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesús boa, masãdero pʉrʉ, gʉa ĩgʉ̃ buerã ĩgʉ̃ irasũ ãrĩdeare gũña, pémasĩbʉ. Irasirirã Marĩpʉya werenírĩ gojadea pũgue ĩgʉ̃rẽ gojadeare, ĩgʉ̃ weredeadere: “I diayeta ããrĩyo”, ãrĩ bʉremubʉ. ");
INSERT INTO sri_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua bosenʉ ããrĩmakʉ̃, Jesús Jerusalẽ́gue ããrĩmí. Masaka ĩgʉ̃ Marĩpʉ turari merã iri ĩmumakʉ̃ ĩãrã, wárã: “Marĩpʉ iriudi ããrĩ́mi”, ãrĩ bʉremuma. ");
INSERT INTO sri_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ĩgʉ̃sã irasũ bʉremukeremakʉ̃, Jesús gapʉ ããrĩpererã ĩgʉ̃sã gũñarĩrẽ ĩãmasĩkõãmi. Irasirigʉ ĩgʉ̃sãrẽ: “Yʉre gũñaturari merã bʉremuníkõãrãkuma”, ãrĩ ĩãbirimi. ");
INSERT INTO sri_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Masaka gũñarĩrẽ õãrõ ĩãmasĩgʉ̃ ããrĩsĩã: “¿Naásũ gũñarĩ ĩgʉ̃sã?” ãrĩ sẽrẽñabirikeregʉ, ĩãmasĩmi. ");
INSERT INTO sri_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Sugʉ judío masaka oparã merã fariseo bumʉ Nicodemo wãĩkʉgʉ ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Su ñami Jesúre ĩãgʉ̃ ejayupʉ. Ĩgʉ̃ pʉrogue eja, ĩgʉ̃rẽ ãrĩyupʉ: —Buegʉ, Marĩpʉ mʉ merã ããrĩ́mi. Irasirigʉ ĩgʉ̃ turari merã mʉ iri ĩmumasĩa. Mʉ iri ĩmurĩrẽ ĩãrã, gʉa masĩa. Marĩpʉ mʉrẽ iriudi ããrĩmí gʉare buedoregʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Diayeta mʉrẽ werea. Sugʉ masakʉ dupaturi deyoagʉ irirosũ ããrĩgʉ̃́ dita Marĩpʉ ĩgʉ̃yarãrẽ dorerogue waamasĩmi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Nicodemo Jesúre sẽrẽñayupʉ: —¿Nasiri irasũ waabukuri? Sugʉ masakʉ bʉgʉrogue dupaturi deyoabu, ĩgʉ̃ pagoya patoreguere ñajãmasĩbirikumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Diayeta mʉrẽ werea. Sugʉ masakʉ deko merã, Õãgʉ̃ deyomarĩgʉ̃ merã deyoagʉ dita Marĩpʉ ĩgʉ̃yarãrẽ dorerogue waamasĩmi. ");
INSERT INTO sri_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Masaka pũrãkʉmakʉ̃, ĩgʉ̃sã pũrã masakata ããrĩ́ma. Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃ merã deyoarã gapʉre Marĩpʉ pũrã ããrĩmakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Irasirigʉ mʉ: “Ããrĩpererã dupaturi deyoarã irirosũ ããrĩrṍ gããmea”, ãrĩrĩrẽ pégʉ, pégʉkabirikõãka! ");
INSERT INTO sri_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mirũ noó gããmerõ wẽjãpuwãgãa. Iri bʉsʉrire péa. Irire pékererã, sõõ merã aara, iro waaró yáa, ãrĩ masĩña máa. Irasũta ããrã, Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃ merã deyoarãrẽ Marĩpʉ pũrã ããrĩmakʉ̃ iriri ãsũ waaró yáa, ãrĩ masĩña máa, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Nicodemo ãsũ ãrĩ sẽrẽñayupʉ Jesúre doja: —¿Nasiriro irasũ ããrĩbukuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —¿Mʉ Israel bumarãrẽ Marĩpʉyare buegʉ ããrĩkeregʉ, ire masĩberi? ");
INSERT INTO sri_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Diayeta mʉrẽ werea. Gʉa masĩrĩrẽ, gʉa ĩãdeare mʉsãrẽ werea. Mʉsã gapʉ irire bʉremubea. ");
INSERT INTO sri_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yʉ i ʉ̃mʉma ubu ããrĩrĩ́rẽ weremakʉ̃ mañurẽ bʉremubea. ¿Nasirimurã ʉ̃mʉgasimarẽ yʉ wereri gapʉre bʉremubukuri? ");
INSERT INTO sri_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Neõ sugʉ masakʉ ʉ̃mʉgasiguere mʉrĩa, pʉrʉ dijaridi mámi. Yʉ sugʉta ããrĩpererã tĩ́gʉ̃ ʉ̃mʉgasigue ããrĩdi õõ i ʉ̃mʉgue dijaribʉ. ");
INSERT INTO sri_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","’Iripoegue masaka marĩrõgue Moisés kõme merã ãña keori irideare yukʉgue ãĩsiu, ãĩwãgũnúdi ããrĩmí. I ãña keorire yukʉgue ãĩsiu, ãĩwãgũnúderosũ masaka yʉre ããrĩpererã tĩ́gʉ̃rẽ curusague pábiatú, ãĩwãgũnúrãkuma. ");
INSERT INTO sri_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Irasirirã ããrĩpererã yʉre bʉremurãno perebiri peamegue waabirikuma. Ʉ̃mʉgasigue perebiri okari gapʉre oparãkuma. ");
INSERT INTO sri_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Marĩpʉ i ʉ̃mʉ marãrẽ bʉro maĩsĩã, ĩgʉ̃ magʉ̃ sugʉ ããrĩgʉ̃́rẽ iriudi ããrĩmí. Ĩgʉ̃rẽ bʉremurãno perebiri peamegue waabirikuma. Ʉ̃mʉgasigue Marĩpʉ merã perebiri okari gapʉre oparãkuma. ");
INSERT INTO sri_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Marĩpʉ ĩgʉ̃ magʉ̃rẽ masakare peamegue waabonerãrẽ taudoregʉ i ʉ̃mʉguere ĩgʉ̃rẽ iriudi ããrĩmí. Masakare wajamoãdoregʉ meta i ʉ̃mʉguere ĩgʉ̃rẽ iriudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Marĩpʉ ĩgʉ̃ magʉ̃rẽ bʉremurãrẽ neõ wajamoãbirikumi. Ĩgʉ̃rẽ bʉremumerã gapʉre: “Wajamoãgʉra”, ãrĩ weresiami. Ĩgʉ̃ magʉ̃rẽ sugʉta ããrĩgʉ̃́rẽ bʉremubiridea waja ĩgʉ̃sãrẽ wajamoãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Marĩpʉ magʉ̃ i ʉ̃mʉguere aarimí, masakare Marĩpʉre masĩmakʉ̃ iribu. Irasirigʉ ĩgʉ̃sãrẽ sĩãgori sĩgʉ̃ ããrĩ́mi. Ĩgʉ̃rẽ bʉremumerã gapʉ ĩgʉ̃rẽ gããmebema. Ĩgʉ̃sã ñerĩ iriri gapʉre bʉro gããmema. Irasirirã boyorogue ããrĩmerã, naĩtĩãrõgue ããrĩdʉarã irirosũ ããrĩ́ma. Irasirigʉ Marĩpʉ ĩgʉ̃sãrẽ wajamoãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ããrĩpererã ñerõ irirã Marĩpʉ magʉ̃rẽ gããmebema. Boyorogue ããrĩdʉamerã irirosũ ããrĩ́ma, gajirã ĩgʉ̃sã ñerõ iririre masĩbirikõãburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Marĩpʉyare keoro irirã gapʉ ĩgʉ̃ magʉ̃rẽ gããmema. Boyorogue ããrĩdʉarã irirosũ ããrĩ́ma, gajirã ĩgʉ̃sã õãrĩrẽ irimakʉ̃ ĩãrã: “Marĩpʉ ĩgʉ̃sãrẽ iritamumi”, ãrĩ masĩburo, ãrĩrã, ãrĩ wereyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pʉrʉ Jesús gʉare ĩgʉ̃ buerãrẽ Judea nikũgue siiuwãgãmi. Irogue eja, iro marã merã yoaweyaripoe ããrĩ, ĩgʉ̃sãrẽ wãĩyerã iribʉ. ");
INSERT INTO sri_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juãde masakare Enón wãĩkʉri makãgue wãĩyeyupʉ. Enón, Salim wãĩkʉri makã pʉro ããrĩbʉ́. Irogue dia wádiya ããrĩbʉ́. Irasirirã masaka ĩgʉ̃ pʉrogue wãĩyedorerã waanañurã. ");
INSERT INTO sri_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Gajirã ĩgʉ̃rẽ peresu iriburi dupiyuro ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Iripoere surãyeri Juan buerã sugʉ judío masakʉ merã ĩgʉ̃sã koerikʉri merã guaseopʉroriñurã. ");
INSERT INTO sri_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pʉrʉ Juan pʉrogue waa, ĩgʉ̃rẽ ãsũ ãrĩ wereñurã: —Buegʉ, dia Jordán wãĩkʉdiya gaji koepʉgue mʉ merã ããrĩdi, gʉare mʉ weredi, dapagorare masakare wãĩyegʉ iriami. Ããrĩpererã ĩgʉ̃ pʉrogue waarã́ iriama, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Juan ãrĩyupʉ: —Sugʉ masakʉ Marĩpʉ turari merã õãrĩrẽ iriri, Marĩpʉ ĩgʉ̃rẽ pídea ããrã. ");
INSERT INTO sri_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mʉsã yʉ weredeare pébʉ. “Marĩpʉ iriudi Cristo ããrĩbea yʉ”, ãrĩbʉ. Yʉ Cristo ããrĩbirikeremakʉ̃, Marĩpʉ gapʉ Cristo aariburi dupiyuro yʉre ĩgʉ̃yare weredupiyudoregʉ iriumi. ");
INSERT INTO sri_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ãsũ ããrã. Sugʉ mojõsʉamakʉ̃, nomeõ ĩgʉ̃ merã ããrĩgṍ waakumo. Ĩgʉ̃ merãmʉ, mojõsʉamakʉ̃ ĩãgʉ̃, ĩgʉ̃ werenímakʉ̃ pégʉ, bʉro ʉsʉyakumi. Irasirigʉ mojõsʉadi merãmʉ ʉsʉyaderosũta masaka Cristo merã waamakʉ̃ ĩãgʉ̃, yʉde ʉsʉyari opataria. ");
INSERT INTO sri_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Masaka Cristore tʉyaro gããmea. Yʉ gapʉre tʉyaduúkõãrõ gããmea, ãrĩyupʉ Juan. ");
INSERT INTO sri_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Irasũ ãrĩ odo, Juan ãsũ ãrĩnemoyupʉ doja: —Ʉ̃mʉgasigue merã dijaridi ããrĩpererã nemorõ masĩgʉ̃ ããrĩ́mi. Sugʉ masakʉ i ʉ̃mʉmʉ, i ʉ̃mʉmarẽ wereníkumi. Ʉ̃mʉgasigue merã dijaridi gapʉ ããrĩpererã nemorõ masĩgʉ̃ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ĩgʉ̃ ĩãdeare, ĩgʉ̃ pédeare weremi. Ĩgʉ̃ irire werekeremakʉ̃, neõ sugʉ ĩgʉ̃ wererire bʉremubemi. ");
INSERT INTO sri_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ĩgʉ̃ wererire bʉremurã gapʉ: “Marĩpʉ diaye ããrĩrĩ́marẽ ãrĩkatori marĩrõ ãrĩgʉ̃ ããrĩ́mi”, ãrĩ ĩmuma. ");
INSERT INTO sri_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Marĩpʉ Cristore ĩgʉ̃ iriudire Õãgʉ̃ deyomarĩgʉ̃rẽ opatarimakʉ̃ iridi ããrĩmí. Irasirigʉ Cristo Marĩpʉya werenírĩrẽ weremi. ");
INSERT INTO sri_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Marĩpʉ ĩgʉ̃ magʉ̃ Cristore bʉro maĩmi. Irasirigʉ ĩgʉ̃rẽ ããrĩpereri, ããrĩpererãrẽ doregʉ ããrĩmakʉ̃ iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Marĩpʉ magʉ̃rẽ bʉremurã ʉ̃mʉgasigue ĩgʉ̃ merã perebiri okarire opama. Ĩgʉ̃ magʉ̃rẽ bʉremudʉamerã gapʉ iri okarire neõ opabirikuma. Marĩpʉ ĩgʉ̃sãrẽ bʉro wajamoãgʉkumi, ãrĩyupʉ Juan. ");
INSERT INTO sri_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesús buerã, Juan buerã nemorõ wárã ããrĩrĩ́ kerere, Jesús, Juan nemorõ masakare wãĩyeri kerere, fariseo bumarã péñurã. ");
INSERT INTO sri_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ĩgʉ̃sã iri kerere pékeremakʉ̃, Jesús gapʉ ĩgʉ̃ basi masakare wãĩyebirimi. Gʉa ĩgʉ̃ buerã gapʉ ĩgʉ̃sãrẽ wãĩyebʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo bumarã iri kerere péadeare masĩgʉ̃, Jesús Judea nikũgue ããrãdi, Galilea nikũ gapʉ gʉare siiu, goedujáami. ");
INSERT INTO sri_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galileague goedujáagʉ, Samaria nikũgue tariwãgãmi. ");
INSERT INTO sri_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Iro tariwãgãgʉ̃, iri nikũma makã Sicar wãĩkʉri makãgue ejami. Iri makã, Jacob iripoeguemʉ ĩgʉ̃ magʉ̃ Josére sĩdea nikũ pʉro ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iroguere deko gobe Jacob iridea gobe ããrĩbʉ́. Jesús yoaro aaradi, garibore, iri gobe pʉro siñajã eja doami. Goeripoe ejaburi dupiyuro ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ĩgʉ̃ irogue doaripoeta gʉa ĩgʉ̃ buerã makãgue baari wajarirã waabʉ. Gʉa waadero pʉrʉ, iri gobeguere sugo nomeõ Samariamo deko wágo ejayupo. Igo irogue ejamakʉ̃ ĩãgʉ̃, Jesús igore ãrĩyupʉ: —Yʉre deko tĩãka! ");
INSERT INTO sri_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, ĩgʉ̃rẽ ãrĩyupo: —¿Nasirigʉ mʉ judío masakʉ ããrĩkeregʉ, yʉre Samariamorẽ: “Deko tĩãka!” ãrĩ sẽrẽrĩ? ãrĩyupo. Iripoere judío masaka Samaria marã merã neõ gãmesʉribirima. Irasirigo irasũ ãrĩyupo ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Igo irasũ ãrĩmakʉ̃, Jesús ãrĩyupʉ: —Mʉ Marĩpʉ masakare sĩrĩrẽ masĩgõ, yʉdere masĩgõ, yʉre: “Okari sĩrĩ dekore sĩka”! ãrĩ sẽrẽboakuyo. Mʉ sẽrẽmakʉ̃, yʉ iri dekore sĩboakuyo, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃rẽ ãrĩyupo doja: —Mʉ deko ãĩburi sorore opabea, i gobe ʉ̃kʉ̃ãgoráa. ¿Noógue mʉ i okari sĩrĩ deko bokagʉkuri? ");
INSERT INTO sri_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iripoegue marĩ ñekʉ̃ Jacob i gobema dekore iirídi ããrĩmí. Ĩgʉ̃ pũrã, ĩgʉ̃yarã ejorãde iirínerã ããrĩmá. Ĩgʉ̃ marĩrẽ i gobere pídi ããrĩmí. ¿Mʉ gapʉ ĩgʉ̃ nemorõ masĩgʉ̃ ããrĩ́rĩ? ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús igore yʉjʉyupʉ: —Ããrĩpererã i gobema deko iirírã, dupaturi ñemesiburi oparãkuma. ");
INSERT INTO sri_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yʉ sĩburi gapʉre iirírã, neõ ñemesiburi opabirikuma. Ĩgʉ̃sãrẽ ĩgʉ̃sãya yʉjʉpũrãrĩguere deko ũmayoro irirosũ ããrĩrokoa. Irasirirã i merã perebiri okari oparãkuma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, ĩgʉ̃rẽ ãrĩyupo: —Iri dekore sĩka yʉre! Mʉ yʉre sĩmakʉ̃, yʉ neõ dupaturi ñemesiburi opabirikoa. Irasũ ããrĩmakʉ̃, i gobeguere neõ dupaturi deko wágo aaribirikoa pama, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús igore ãrĩyupʉ: —Mʉ marãpʉre siiugo waaka! Ĩgʉ̃rẽ siiu, õõgue ĩgʉ̃ merã dupaturi aarika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Igo ĩgʉ̃rẽ yʉjʉyupo: —Yʉ, marãpʉ marĩgõ ããrã. Jesús igore ãrĩyupʉ: —Mʉ yʉre: “Marãpʉ marĩgõ ããrã”, ãrĩgõ, diayeta yʉjʉa. ");
INSERT INTO sri_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mʉ su mojõmarã ʉ̃ma merã marãpʉkʉsiadibʉ. Dapagora mʉ merã ããrĩgʉ̃́ mʉ marãpʉ diaye ããrĩbemi, mʉ ĩgʉ̃rẽ neõ mojõsʉabiribʉ. Irasiriro mʉ yʉjʉri diayeta ããrã. ");
INSERT INTO sri_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, ãrĩyupo: —“Mʉ Marĩpʉya kerere weredupiyurimasʉ̃ ããrĩkoa”, ãrĩ gũñáa yʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Gʉa ñekʉ̃sãmarã Samaria marã sigʉ ʉ̃tãʉ̃gue Marĩpʉre bʉremunerã ããrĩmá. Mʉsã judío masaka gapʉ gʉare: “Jerusalẽ́gue Marĩpʉre bʉremurõ ããrã. Irogue Marĩpʉre bʉremurã waaka!” ãrã gʉare mʉsã, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Igo irasũ ãrĩmakʉ̃ pégʉ, Jesús ãsũ ãrĩyupʉ: —Yʉ werenírĩrẽ péka! Pʉrʉgue mʉsã i ʉ̃tãʉ̃guere, Jerusalẽ́guedere Marĩpʉre bʉremurã waabirikoa. Mʉsã irasiriburo mérõgã dʉyáa. ");
INSERT INTO sri_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉsã Samaria marã mʉsã bʉremugʉ̃rẽ masĩbea. Gʉa judío masaka gapʉ gʉa bʉremugʉ̃rẽ õãrõ masĩa. Ĩgʉ̃ masakare taubu judío masakʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Marĩpʉre diayeta bʉremurã ĩgʉ̃sãya yʉjʉpũrãrĩgue bʉremurãkuma. Marĩpʉ ĩgʉ̃rẽ bʉremurãrẽ ãsũta bʉremurõ gããmemi. Ĩgʉ̃rẽ ãsũ bʉremuripoe ejaro, dapagorare ejasiáa. ");
INSERT INTO sri_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Marĩpʉ deyomarĩgʉ̃ ããrĩ́mi. Irasirigʉ ĩgʉ̃rẽ bʉremurãya yʉjʉpũrãrĩgue ããrĩ́mi. Irasirirã ĩgʉ̃sãya yʉjʉpũrãrĩgue diayeta ĩgʉ̃rẽ bʉremurõ gããmea ĩgʉ̃sãrẽ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃rẽ ãrĩyupo: —Yʉ masĩa. Mesías, Marĩpʉ iriudi Cristo aarigʉkumi. Ĩgʉ̃ aarigʉ́, marĩrẽ ããrĩpererire weregʉkumi, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Igo irasũ ãrĩmakʉ̃ pégʉ, ãsũ ãrĩ deyoromuyupʉ: —Yʉ mʉ merã werenígʉ̃ Marĩpʉ iriudita ããrã, ãrĩyupʉ Jesús. ");
INSERT INTO sri_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ĩgʉ̃sã irasũ weretamuripoe gʉa baari wajarirã ejanerã Jesús pʉrogue goedujajabʉ. Ĩgʉ̃ sugo nomeõ Samariamo merã werenímakʉ̃ ĩãrã, ĩãgʉkakõãbʉ. Ĩgʉ̃rẽ neõ: “¿Ñeénorẽ gããmeari? o ¿ñeénomarẽ igo merã wereníari?” ãrĩ sẽrẽñabiribʉ Jesúre. ");
INSERT INTO sri_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pʉrʉ nomeõ igo deko wárisorore irota béodobokõã, makãgue waakõãmo. Irogue ejago, masakare wereyupo: ");
INSERT INTO sri_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Náka, mʉsãde ĩãrã aarika! Sõõ sugʉ ʉ̃mʉ́ʉ ããrãmi. Ĩgʉ̃ ããrĩpereri yʉ irideare masĩpeokõãmi, irire werepeokõãmi yʉre. ¿Ĩgʉ̃ Cristo, Marĩpʉ iriudi ããrĩkuri? ãrĩyupo igoya makã marãrẽ. ");
INSERT INTO sri_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Igo irasũ ãrĩmakʉ̃ pérã, Jesús pʉrogue ĩgʉ̃rẽ ĩãrã waañurã. ");
INSERT INTO sri_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ĩgʉ̃sã ĩgʉ̃ pʉro aariburi dupiyuro gʉa ĩgʉ̃rẽ ãrĩbʉ: —Buegʉ, gʉa mʉrẽ ãĩriadea baarire baaka! ãrĩ sĩadibʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesús gapʉ gʉare ãrĩmi: —Yʉ baari opáa, irire mʉsã masĩbea. ");
INSERT INTO sri_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa basi ãsũ ãrĩ gãme sẽrẽñapʉroribʉ: —¿Gajipoe irirã gajirã ĩgʉ̃rẽ baari ejoayuri? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús gapʉ gʉare ãrĩmi: —Yʉre iriudi gããmerĩrẽ irigʉ, ĩgʉ̃ yʉre moãdoredeare iriyuwarikʉgʉ, baayapigʉ irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mʉsã ãsũ ãrã: “Wapikʉrã abe dʉyáa, ĩgʉ̃sã otedea dʉka sĩburo”. Yʉ gapʉ mʉsãrẽ ãsũ ãrã: “Ĩgʉ̃sã otederore ĩãka! Dʉka borerire searipoe ejasiáa”. ");
INSERT INTO sri_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sugʉ otedea dʉkare searimasʉ̃ ĩgʉ̃ moãdea wajare wajatami. Marĩpʉya werenírĩrẽ weregʉ ĩgʉ̃ irirosũ ããrĩ́mi. Ĩgʉ̃ wererire pérã, yʉre bʉremuma. Irasirirã ʉ̃mʉgasigue perebiri okarire oparãkuma. Ĩgʉ̃sã, ĩgʉ̃ otedea dʉka seari irirosũ ããrĩ́ma. Irasirirã oterimasʉ̃, ĩgʉ̃ otedea dʉkare searimasʉ̃ irirosũ ããrĩrã́, ʉsʉyama, masaka yʉre bʉremumakʉ̃ ĩãrã. ");
INSERT INTO sri_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Masaka ãsũ ãrĩ werewʉakuma: “Sugʉ masakʉ otekumi. Pʉrʉ gajigʉ i otedea dʉkare seakumi”, ãrĩkuma. Ĩgʉ̃sã irasũ ãrĩ werewʉadea diayeta ããrã. ");
INSERT INTO sri_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iripoegue Marĩpʉya werenírĩrẽ weredupiyunerã oterimasã irirosũ ããrĩnerã ããrĩmá. Dapagora yʉ mʉsãrẽ iriua. Mʉsã ĩgʉ̃sã iripoegue otedea dʉkare searimasã irirosũ ããrã. Irasirirã ĩgʉ̃sã moãdea wajare mʉsã wajatarã irirosũ ããrã. Ĩgʉ̃sã moãderoguere moãwekabejarã irirosũ irirã yáa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariamo makãgue ejadero pʉrʉ: “Sõõ ããrãdi ããrĩpereri yʉ irideare masĩpeokõãmi”, ãrĩmakʉ̃ pérã, wárã iri makã marã Jesúre bʉremuñurã. ");
INSERT INTO sri_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Irasirirã Jesús pʉro aarirã́, ĩgʉ̃rẽ: “Gʉa merã dujaka!” ãrĩ sẽrẽma. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sã merã penʉ dujami. ");
INSERT INTO sri_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ĩgʉ̃ wererire pérã, gajirãde wárã ĩgʉ̃rẽ bʉremuma. ");
INSERT INTO sri_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Irasirirã nomeõrẽ ãrĩma: —Gʉa mʉ wereadea ditare pérã, Jesúre bʉremuadabʉ. Dapagora tamerãrẽ gʉa basi ĩgʉ̃ wererire pésĩã, ĩgʉ̃rẽ bʉremua. Gʉa masĩa. Ĩgʉ̃ diayeta Marĩpʉ iriudi, i ʉ̃mʉ marãrẽ peamegue waabonerãrẽ taugʉ ããrĩ́mi, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesús penʉ Samariague ããrãdi, Galilea nikũgue waami. ");
INSERT INTO sri_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iro dupiyuro Jesús ãsũ ãrĩdi ããrĩmí: “Marĩpʉya kerere weredupiyugʉre ĩgʉ̃ya nikũ marã ĩgʉ̃rẽ bʉremubema”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galileague ejamakʉ̃, iro marã ĩgʉ̃rẽ õãrõ bokatĩrĩñeãma. Iro dupiyuro ĩgʉ̃sãde Jerusalẽ́gue pascua bosenʉ ĩãrã ejanerã ããrĩmá. Irasirirã ããrĩpereri Jesús irogue irideare ĩãnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús Galileague ejadero pʉrʉ, Caná wãĩkʉri makãgue ĩgʉ̃ dekoreta igui deko iridea makãgue goemi. Iri makãguere sugʉ Galilea marã opʉ dokamʉ ããrĩmí. Ĩgʉ̃ magʉ̃ Capernaum wãĩkʉri makãgue ããrĩgʉ̃́, pũrĩrikʉgʉ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Irasirigʉ opʉ dokamʉ, Jesús Judeague ããrãdi ĩgʉ̃ Galileague ejari kerere pégʉ, Jesús pʉro aarimí. Ãsũ ãrĩ sẽrẽmi ĩgʉ̃rẽ: —Yʉ magʉ̃ boabu iriami. Ĩgʉ̃rẽ taubosagʉ aarika! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús ãrĩmi: —Marĩpʉ turari merã yʉ iri ĩmurĩrẽ ĩãbirikererã, neõ yʉre bʉremubea mʉsã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Opʉ dokamʉ gapʉ Jesúre ãrĩmi: —Gʉa Opʉ, yʉ magʉ̃ boaburo dupiyuro aarika! ");
INSERT INTO sri_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús ĩgʉ̃rẽ ãrĩmi: —Mʉya wiigue dujáaka! Mʉ magʉ̃ okagʉkumi, ãrĩmi. Opʉ dokamʉ, ĩgʉ̃ irasũ ãrĩrĩrẽ pégʉ, bʉremurĩ merã ĩgʉ̃ya wiigue dujáakõãmi. ");
INSERT INTO sri_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ĩgʉ̃ya wiigue ejawãgãriripoe ĩgʉ̃rẽ moãboerã bokatĩrĩ wereñurã: —Mʉ magʉ̃ okami, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ĩgʉ̃sã irire ãrĩmakʉ̃ pégʉ: “¿Naásũ ããrĩmakʉ̃ õãrĩ?” ãrĩ sẽrẽñayupʉ. Ĩgʉ̃sã ĩgʉ̃rẽ ãrĩñurã: —Ñamika goeripoe pʉrʉgãta nimakʉri tariabʉ ĩgʉ̃rẽ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃ pagʉ ãrĩyupʉ: “Jesús yʉre: ‘Mʉ magʉ̃ okagʉkumi’, ãrĩ wereripoeta nimakʉri tariakuyo”, ãrĩyupʉ. Irasirigʉ, ããrĩpererã ĩgʉ̃ya wii marã merã Jesúre bʉremuyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesús Judea ããrãdi dupaturi Galileague ejadero pʉrʉ, opʉ dokamʉ magʉ̃rẽ ĩgʉ̃ tauadea merã Caná wãĩkʉri makãgue pea Marĩpʉ turari merã iri ĩmumi. ");
INSERT INTO sri_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pʉrʉ Jesús Jerusalẽ́gue judío masaka bosenʉ ĩãgʉ̃ waami. ");
INSERT INTO sri_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iri makã tʉro sãrĩrõgue su makãpʉro “Oveja” wãĩkʉri makãpʉro pʉro wári gobe deko gobe ĩgʉ̃sã iridea gobe ããrĩbʉ́. Iri gobe hebreo ya merã “Betzata” wãĩkʉbʉ. Iri gobe tʉroguere su mojõma taridupabu tiiaña marĩrĩ ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Iri taridupabugue wárã masaka pũrĩrikʉrã oyama. Koye ĩãmerã, waamasĩmerã, guburi bʉasũnerã ããrĩmá. Gajipoere Marĩpʉre wereboegʉ iri gobegue dijajanayupʉ. Irogue dijajagʉ, dekore gãmeñamakʉ̃ irinayupʉ. Ĩgʉ̃ irasiriadero pʉrʉ, iri gobegue buañajãpʉrorigʉno ĩgʉ̃ sĩrĩrĩrẽ tarisũnayupʉ. Irasirirã deko gãmeñaburire yúrã irogue oyama. ");
INSERT INTO sri_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Irogue sugʉ dʉpʉ bʉadi oyami. Ĩgʉ̃ treinta y ocho bojorigora pũrĩrikʉgʉ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús iri gobe tʉro tariwãgãgʉ̃, ĩĩ bʉadi oyagʉre ĩãmi. “Yoaripoe pũrĩrikʉgʉ ããrĩ́mi”, ãrĩ masĩkõãmi. Irasirigʉ ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽñami: —¿Mʉ pũrĩrikʉrire taumakʉ̃ gããmerĩ? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ĩgʉ̃ Jesúre yʉjʉmi: —Yʉ Opʉ, sugʉ yʉre iritamugʉ̃ neõ mámi. Deko gãmeñamakʉ̃, yʉ iri gobe ñajãdʉamakʉ̃, gajirã yʉ dupiyuro ñajãpʉrorinama, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús ĩgʉ̃rẽ ãrĩmi: —Wãgãnʉgãka! Mʉ oyarore ãĩaka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Irasũ ãrĩmakʉ̃ta, ĩgʉ̃ pũrĩrikʉri taribʉ. Irasirigʉ wãgãnʉgã, ĩgʉ̃ oyarore tuútũrã, ãĩãkõãmi. Jesús ĩgʉ̃rẽ tauadeanʉ judío masaka siñajãrĩnʉ ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Irasirirã judío masaka oparã Jesús tausũadi ĩgʉ̃ oyarore ãĩãmakʉ̃ ĩãrã, ĩgʉ̃rẽ ãrĩñurã: —Dapagã marĩ siñajãrĩnʉ ããrã. Mʉ oyarore kõãgʉ̃, marĩ dorerire tarinʉgãgʉ̃ yáa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ĩgʉ̃ ĩgʉ̃sãrẽ yʉjʉyupʉ: —Yʉre tauadi: “Mʉ oyarore ãĩaka!” ãrãmi. ");
INSERT INTO sri_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ ãsũ ãrĩ sẽrẽñañurã: —Irire mʉrẽ irasũ ãrãdi, ¿noãno ããrãrĩ? ");
INSERT INTO sri_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jesús bʉadire tauadero pʉrʉ, iro ããrĩrã́ masaka wárã watopegue waakõãmi. Irasirigʉ bʉadi ããrãdi ĩgʉ̃rẽ tauadire: “Ĩgʉ̃ta ããrĩ́mi”, ãrĩ masĩbiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pʉrʉ Jesús Marĩpʉya wiigue ĩgʉ̃rẽ bokajagʉ, ãrĩmi: —Pémasĩka! Dapagorare mʉ pũrĩrikʉri marĩgʉ̃ ããrã. Irasirigʉ ñerĩrẽ irinemobirikõãka! Dupaturi ñerĩrẽ irigʉ, mʉ pũrĩrikʉdero nemorõ ñerõ tarigʉkoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, bʉadi ããrãdi judío masaka oparã pʉrogue waa, ĩgʉ̃sãrẽ wereyupʉ: —Yʉre tauadi Jesús wãĩkʉgʉ ããrĩ́mi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Irire pérã, judío masaka oparã ĩgʉ̃sã siñajãrĩnʉ ããrĩmakʉ̃ Jesús bʉadire tauadea waja ĩgʉ̃rẽ ñerõ iripʉrori, wẽjẽdʉadiñurã. ");
INSERT INTO sri_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ĩgʉ̃sã ĩgʉ̃rẽ ñerõ iridʉamakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉpʉ piriro marĩrõ moãgʉ̃ yámi. Yʉde moãa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ĩgʉ̃ irire ãrĩmakʉ̃ pérã, judío masaka oparã dupiyuro ĩgʉ̃rẽ wẽjẽdʉadero nemorõ wẽjẽdʉadiñurã. Ĩgʉ̃sã siñajãrĩnʉ ããrĩmakʉ̃ bʉadire ĩgʉ̃ tauadea waja, ĩgʉ̃ Marĩpʉre: “Yʉpʉ”, ãrĩrĩ waja ĩgʉ̃rẽ irasũ wẽjẽdʉadiñurã. “Ĩgʉ̃: ‘Yʉpʉ’, ãrĩgʉ̃, ĩgʉ̃ basi: ‘Yʉ Marĩpʉ suro merã ããrã’, ãrĩgʉ̃ yámi”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Irasirigʉ Jesús ĩgʉ̃sãrẽ ãsũ ãrĩ weremi: —Diayeta mʉsãrẽ werea. Yʉ Marĩpʉ magʉ̃ yʉ gããmerõ neõ iribea. Yʉpʉ iririre ĩãgʉ̃, iri ditare yáa. ");
INSERT INTO sri_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉpʉ yʉre ĩgʉ̃ magʉ̃rẽ maĩmi. Irasirigʉ ããrĩpereri ĩgʉ̃ iririre yʉre ĩmumi. I dapagorare ĩgʉ̃ turari merã yʉ iridea nemorõ gajire yʉre iridoregʉkumi. Ĩgʉ̃ turari merã irire yʉ iri ĩmumakʉ̃ ĩãrã, ĩãgʉkarãkoa mʉsã. ");
INSERT INTO sri_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yʉpʉ boanerãrẽ masũ, okari sĩrõsũta yʉde yʉ okari sĩdʉarãrẽ sĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yʉpʉ masaka ñerõ iridea waja ĩgʉ̃sãrẽ wajamoãbemi. Yʉ gapʉre ããrĩpereri ĩgʉ̃ turarire pími, ĩgʉ̃sãrẽ wajamoãbure. ");
INSERT INTO sri_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ããrĩpererã ĩgʉ̃rẽ bʉremurõsũta yʉdere bʉremuburo, ãrĩgʉ̃, yʉre irasiridoremi. Yʉre ĩgʉ̃ magʉ̃rẽ bʉremumerã Yʉpʉdere bʉremubema. Ĩgʉ̃ yʉre iriudi ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Diayeta mʉsãrẽ werea. Yʉ werenírĩrẽ pérã, yʉre iriudire bʉremurã, ʉ̃mʉgasigue Yʉpʉ merã perebiri okari opama. Wajamoãsũbirikuma. Ĩgʉ̃sã perebiri peamegue waabonerã tarisiama. ");
INSERT INTO sri_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Diayeta mʉsãrẽ werea. Peamegue waabonerã yʉ Marĩpʉ magʉ̃ werenímakʉ̃ péripoe dapagorare ejasiáa. Yʉ wererire pérã, yʉre bʉremurã Marĩpʉ merã okarãkuma. ");
INSERT INTO sri_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yʉpʉ masakare okari sĩgʉ̃ ããrĩ́mi. Irasirigʉ yʉ ĩgʉ̃ magʉ̃rẽ ĩgʉ̃ irirosũta ĩgʉ̃sãrẽ okari sĩmakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yʉ ããrĩpererã tĩ́gʉ̃ ããrã. Irasirigʉ Yʉpʉ yʉre masaka ñerõ iridea waja ĩgʉ̃sãrẽ wajamoãdoremi. ");
INSERT INTO sri_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mʉsã ire pérã, pégʉkabirikõãka! Sunʉ boanerã ããrĩpererã yʉ werenímakʉ̃ pérãkuma. ");
INSERT INTO sri_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ĩgʉ̃sã, yʉ werenímakʉ̃ pérã, masãgoberigue ããrĩnerã masã, wiripereakõãrãkuma. Õãrĩrẽ irinerã masãrãkuma, ʉ̃mʉgasigue perebiri okari opamurã. Ñerĩ irinerã gapʉ masãrãkuma, perebiri peamegue wajamoãsũmurã. ");
INSERT INTO sri_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Yʉ gããmerõ neõ irimasĩbea. Yʉpʉ yʉre iriudi gããmerĩrẽ, ĩgʉ̃ yʉre masakare wajamoãdorerosũta yáa. Irasirigʉ ĩgʉ̃sãrẽ wajamoãgʉ̃ diayeta yáa. ");
INSERT INTO sri_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yʉ basi: “Yʉ Marĩpʉ magʉ̃ ĩgʉ̃ iriudi ããrã”, ãrĩ weremakʉ̃: “Mʉ werenírĩ neõ diaye ããrĩbea”, ãrĩbukoa mʉsã. ");
INSERT INTO sri_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Gajigʉ ããrĩ́mi yaamarẽ weregʉ. Ĩgʉ̃ Yʉpʉ ããrĩ́mi. Ĩgʉ̃ yaamarẽ wereri diayeta ããrã. Irire yʉ õãrõ masĩa. ");
INSERT INTO sri_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mʉsã gajirãrẽ Juãrẽ masakare wãĩyerimasʉ̃rẽ yaamarẽ sẽrẽñadorerã iriubʉ. Ĩgʉ̃de yaamarẽ diayeta weremi. ");
INSERT INTO sri_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yʉ gapʉ sugʉ masakʉre yʉre: “Marĩpʉ iriudi ããrĩmí”, ãrĩ werebure neõ ãmabea. Irasũ ãmabirikeregʉ, Juan yaamarẽ weredeare: “Diayeta ããrã”, ãrĩ werea, mʉsã yʉre bʉremu, peamegue waabirikõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan mʉsãrẽ sĩãgodiru irirosũ ããrĩmí. Ĩgʉ̃ wereri sĩãgodiru ʉ̃jʉ̃goro irirosũ ããrĩbʉ́. Ĩgʉ̃ wererire pérã, yoaweyaripoe mʉsã ʉsʉyadibʉ. ");
INSERT INTO sri_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan weredea nemorõ yʉ iriri merã yʉ ããrĩrikʉrire masĩsũa. Yʉpʉ turari merã ĩgʉ̃ yʉre iriyuwarikʉdoredeare irigʉ yáa. I merã yʉre ĩgʉ̃ iriudi ããrĩrĩ́rẽ masĩsũa. ");
INSERT INTO sri_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yʉpʉ yʉre iriudi, yaamarẽ õãrõ weremi. Ĩgʉ̃ irasũ werekeremakʉ̃, ĩgʉ̃ werenírĩrẽ mʉsã neõ pébea. Ĩgʉ̃ deyorire neõ ĩãbea. ");
INSERT INTO sri_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yʉre Yʉpʉ iriudire mʉsã neõ bʉremubea. Irasirirã ĩgʉ̃ya kerere neõ péduripíbea. ");
INSERT INTO sri_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yʉpʉya werenírĩ gojadea pũrẽ mʉsã õãrõ bueníkõãa. “Gʉa i pũrẽ buerã, Marĩpʉ merã perebiri okarire bokarãkoa”, ãrĩ gũñáa mʉsã. Iri pũguere yaamarẽta gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Iri pũguere yaamarẽ irasũ gojasũkeremakʉ̃, mʉsã gapʉ yʉre gããmebea. Irasirirã i okari yʉ sĩrĩrẽ opabirikoa. ");
INSERT INTO sri_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Masakare yaamarẽ õãrõ werenímurãrẽ ãmabea. ");
INSERT INTO sri_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yʉ mʉsã masaka ããrĩrikʉrire masĩa. Mʉsã Marĩpʉre maĩrã meta ããrã. ");
INSERT INTO sri_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yʉpʉ gããmerõsũta yʉ aarikeremakʉ̃, mʉsã yʉre gããmebea. Gajigʉ gapʉ ĩgʉ̃ basi ĩgʉ̃ gããmerõ aarimakʉ̃, mʉsã ĩgʉ̃rẽ gããmerãkoa. ");
INSERT INTO sri_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nasirirã yʉre bʉremubukuri mʉsã? Mʉsã basi: “Õãrõ yáa”, ãrĩ gãme werenírĩrẽ gããmea. Marĩpʉ sugʉ ããrĩgʉ̃́ mʉsãrẽ: “Õãrõ yáa”, ãrĩ werenírĩ gapʉre gããmebea. ");
INSERT INTO sri_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mʉsã yʉre gããmebiri waja: “Ĩgʉ̃ Pagʉguere gʉare weresãgʉkumi”, ãrĩ gũñabirikõãka! “Moisés dorerire irirã, Marĩpʉ merã õãrõ ããrĩrãkoa”, ãrĩ gũñakeremakʉ̃, Moisés gapʉ mʉsãrẽ weresãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés ĩgʉ̃ gojadea pũgue yaamarẽ gojadi ããrĩmí. Irasirirã ĩgʉ̃ gojadeare bʉremurã, yʉdere bʉremuboayo mʉsã. ");
INSERT INTO sri_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moisés gojadeare mʉsã bʉremumerã, ¿nasirirã yʉ wereri gapʉre bʉremubukuri? ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jesús Jerusalẽ́gue dʉpʉ bʉadire taudero pʉrʉ, gʉa ĩgʉ̃ buerã ĩgʉ̃ merã Galilea wãĩkʉri ditaru gaji koepʉgue taribujabʉ. Iri ditaruta “Tiberias” wãĩkʉbʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Masaka Jesús ĩgʉ̃ turari merã pũrĩrikʉrãrẽ taumakʉ̃ ĩãsĩã, wárã ĩgʉ̃rẽ tʉyama. ");
INSERT INTO sri_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ditaru gaji koepʉgue ĩgʉ̃ ejadero pʉrʉ, gʉa merã ʉ̃tãʉ̃gue mʉrĩa, doami. ");
INSERT INTO sri_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Irinʉ judío masaka bosenʉ, pascua bosenʉ ejaburo mérõgã dʉyabʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús wárã masaka ĩgʉ̃ pʉro aarimakʉ̃ ĩãgʉ̃, Felipere sẽrẽñami: —¿Noógue marĩ ĩĩsã masaka ããrĩpererã baaburire wajarirãkuri? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús ĩgʉ̃ basi ĩgʉ̃ iriburire masĩkeregʉ: “Felipe yʉre, ¿naásũ yʉjʉgʉkuri?” ãrĩgʉ̃, irasũ ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe ĩgʉ̃rẽ yʉjʉmi: —Marĩ dosciento nʉrĩ moãdea waja wajataropa pã́ duparu wajari, masakare marĩ gueremakʉ̃, neõ ejabirikoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, gʉa merãmʉ Andrés, Simón Pedro pagʉmʉ Jesúre ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Õõ ĩĩ majĩgʉ̃ su mojõma pã́ duparu, pẽrã waaí opami. Masaka gapʉ wárãgora ããrĩ́ma. Irasiriro ĩgʉ̃sãrẽ baari neõ ejabirikoa. ");
INSERT INTO sri_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús gʉare ĩgʉ̃ buerãrẽ ãrĩmi: —Masakare ããrĩpererãrẽ doadoreka! ãrĩmi. Iro õãrõ tákʉro ããrĩbʉ́. Irasirirã iri weka doama. Ʉ̃ma ditare keomakʉ̃, cinco mil gora ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ĩgʉ̃sã eja doaperemakʉ̃ ĩãgʉ̃, Jesús pã́ duparure ãĩ, Marĩpʉre: “Õãa”, ãrĩ, ʉsʉyari sĩmi. Irasiri odo, gʉare ããrĩpererã iro doarãrẽ irire gueredoremi. Waaídere gueredoremi. Irasirirã ããrĩpererãrẽ ĩgʉ̃sã baadʉaropa guereyobʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ĩgʉ̃sã yapimakʉ̃ ĩãgʉ̃, Jesús gʉare ĩgʉ̃ buerãrẽ ãrĩmi: —Ĩgʉ̃sã baadʉáarire seaka! Ubugorata kõmobukoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Su mojõma pã́ duparure masaka baadʉáadeare seasãrã, pe mojõma pere su gubu peru pẽrẽbejari puuirigora ʉtʉudobobʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Masaka Jesús Marĩpʉ turari merã ĩgʉ̃sãrẽ baari sĩmakʉ̃ ĩãrã, ãsũ ãrĩma: —Diayeta ããrã. “Ĩĩ Marĩpʉya kerere weredupiyurimasʉ̃ i ʉ̃mʉgue aaribu ããrãyupʉ”, ĩgʉ̃sã ãrĩdita ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Irasirirã Jesúre turaro merã ãĩa, ĩgʉ̃sã Opʉ ããrĩbure sóodʉarã iriadima. Ĩgʉ̃ gapʉ irire masĩkõãmi. Irasirigʉ dupaturi sugʉta ʉ̃tãʉ̃gue mʉrĩãkõãmi. ");
INSERT INTO sri_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Naĩtĩãwãgãriripoe ããrĩmakʉ̃, gʉa ĩgʉ̃ buerã ditarugue buabʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Buaja, doódirugue ñajãa, Capernaugue taribujapʉroribʉ. Naĩtĩãrõgue iribʉ. Jesús gʉa pʉrogue ejabirimi dapa. ");
INSERT INTO sri_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Gʉa taribujamakʉ̃, mirũ bʉro wẽjãpuwãgãribʉ. Pagari makũrĩ wãgãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Su mojõma kilómetro gʉa waadero pʉrʉ, gʉayaru pʉro Jesús deko wekague aarimakʉ̃ ĩãbʉ. Ĩgʉ̃ irasũ aarimakʉ̃ ĩãrã, bʉro güibʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús gapʉ gʉare ãrĩmi: —Yʉta ããrã. Güimerãta! ");
INSERT INTO sri_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa ĩgʉ̃rẽ õãrõ bokatĩrĩ ñajãdorebʉ. Ĩgʉ̃ ñajãdero pʉrʉ, mata gʉa waaderoguere ejabʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Gajinʉ gapʉ masaka ditaru gaji koepʉgue dujanerã iri ñamirẽ gʉayaru suru dujadiru merã gʉa taribujamakʉ̃, Jesús gʉa merã waabirideadere masĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Irogue ĩgʉ̃sã ããrĩripoere gaji doóriduparu Tiberias wãĩkʉri makãgue ããrãdea duparu, Jesús Marĩpʉre: “Õãa”, ãrĩ, ʉsʉyari sĩ, masakare baari gueredero pʉroweyague ejayuro. ");
INSERT INTO sri_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Irasirirã Jesús, gʉa ĩgʉ̃ buerã marĩmakʉ̃ ĩãrã, iri doóriduparugue ñajãa, Capernaugue taribujañurã Jesúre ãmarã́ waarã́. ");
INSERT INTO sri_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ditarure taribuja, Jesúre bokajarã, ĩgʉ̃rẽ sẽrẽñama: —Buegʉ, ¿naásũ ããrĩmakʉ̃ õõguere aarari mʉ? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Diayeta mʉsãrẽ werea. Yʉ Marĩpʉ turari merã iri ĩmurĩrẽ ĩãkererã, ĩgʉ̃ iriudi yʉ ããrĩrĩ́rẽ bʉremubea. Irasirirã, yʉ mʉsãrẽ ejodeare baayapinerã dita ããrĩsĩã, yʉre ãmáa. ");
INSERT INTO sri_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mʉsã baari pereburi gapʉ ditare wajatamurã, moãbirikõãka! Gaji baari yʉ ããrĩpererã tĩ́gʉ̃ sĩburi gapʉre ãmaka! Iri baarire ãmarã́, Marĩpʉ merã perebiri okari oparãkoa. Yʉpʉ yʉre irire mʉsãrẽ sĩdoregʉ ããrĩ́mi. Ĩgʉ̃ iriudi yʉ ããrĩrĩ́rẽ mʉsãrẽ ĩmusiami, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ sẽrẽñama: —¿Nasirirãkuri Marĩpʉ iridorerire õãrõ iriyuwarikʉmurã? ");
INSERT INTO sri_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Marĩpʉ mʉsãrẽ iridoreri ãsũ ããrã. Yʉre ĩgʉ̃ iriudire bʉremudoremi, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ ãrĩma: —Gʉare mʉrẽ bʉremudoregʉ, ¿ñeénorẽ mʉ turari merã iri ĩmugʉkuri? ¿Naásũperire iri ĩmugʉkuri? ");
INSERT INTO sri_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Masaka marĩrõgue marĩ ñekʉ̃sãmarã maná wãĩkʉrire baanerã ããrĩmá. Marĩpʉya werenírĩ gojadea pũgue ãrĩderosũta ʉ̃mʉgasima baarire ĩgʉ̃sãrẽ sĩdi ããrĩmí, ãrĩma Jesúre. ");
INSERT INTO sri_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãrĩmi: —Diayeta mʉsãrẽ werea. Moisés ʉ̃mʉgasima baarire mʉsãrẽ sĩbiridi ããrĩmí. Yʉpʉta baari ʉ̃mʉgasima, diayemarẽ mʉsãrẽ sĩgʉ̃ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yʉ ʉ̃mʉgasigue ããrĩdi Marĩpʉ iriudi, ĩgʉ̃ baari irirosũ ããrĩgʉ̃́, i ʉ̃mʉ marãrẽ okari sĩgʉ̃ ããrã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ ãrĩma: —Gʉa Opʉ, iri baarire gʉare sĩníkõãka! ");
INSERT INTO sri_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉ okarire sĩgʉ̃, baari irirosũ ããrĩgʉ̃́ ããrã. Yʉre tʉyagʉ, neõ ʉaboabi irirosũ ããrĩgʉkumi. Yʉre bʉremugʉ̃, neõ ñemesibubi irirosũ ããrĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Dupiyuro yʉ mʉsãrẽ ãrĩderosũta, mʉsã gapʉ yʉre ĩãkererã, bʉremubea dapa. ");
INSERT INTO sri_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ããrĩpererã Yʉpʉ yʉre sĩnerã yʉre tʉyarãkuma. Ĩgʉ̃sãrẽ yʉ neõ béobirikoa. ");
INSERT INTO sri_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ʉ̃mʉgasigue ããrĩdi yʉ gããmerĩrẽ irigʉ aarigʉ́ meta iribʉ. Yʉre iriudi gããmerĩ gapʉre irigʉ aaribʉ́. ");
INSERT INTO sri_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yʉre iriudi ãsũ gããmemi. Ĩgʉ̃ yʉre sĩnerãrẽ neõ sugʉre yʉ dedeubirimakʉ̃ gããmemi. I ʉ̃mʉ peremakʉ̃, yʉ ĩgʉ̃sãrẽ masũmakʉ̃ gããmemi. ");
INSERT INTO sri_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yʉpʉ yʉre iriudi ããrĩpererã yʉre ĩgʉ̃ magʉ̃rẽ ĩãrã, yʉre bʉremurã ĩgʉ̃ merã perebiri okarire opamakʉ̃ gããmemi. Irasirigʉ i ʉ̃mʉ peremakʉ̃, ĩgʉ̃sãrẽ masũgʉkoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesús: “Yʉ ʉ̃mʉgasigue merã dijaridea baari irirosũ ããrĩgʉ̃́ ããrã”, ãrĩrĩrẽ pérã, judío masaka oparã ĩgʉ̃rẽ werewʉama. ");
INSERT INTO sri_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ãsũ ãrĩma: —¿Ĩĩ Jesús, José magʉ̃ ããrĩberi? Marĩ ĩgʉ̃ pagʉ, ĩgʉ̃ pagore masĩa. ¿Nasirigʉ ĩgʉ̃: “Ʉ̃mʉgasigue ããrĩdi dijaribʉ”, ãrĩrĩ? ");
INSERT INTO sri_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ãsũ ãrĩ yʉjʉmi: —Mʉsã yʉre werewʉarire pirika! ");
INSERT INTO sri_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Neõ sugʉ ĩgʉ̃ gããmerõ yʉre tʉyabirikumi. Yʉpʉ gapʉ yʉre iriudi masaka yʉre bʉremumakʉ̃ irigʉ ããrĩ́mi. I ʉ̃mʉ peremakʉ̃, yʉre bʉremurãrẽ masũgʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Marĩpʉya kerere weredupiyunerã ãsũ ãrĩ gojanerã ããrĩmá: “Marĩpʉ ããrĩpererãrẽ buegʉkumi”. Irasirirã ããrĩpererã Yʉpʉya buerire pé bʉremurã, ĩgʉ̃yare masĩrã yʉre tʉyarãkuma. ");
INSERT INTO sri_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Neõ sugʉ masakʉ Yʉpʉre ĩãgʉ̃ mámi. Yʉ sugʉta ĩgʉ̃ merã ããrĩdi ĩgʉ̃rẽ masĩa. ");
INSERT INTO sri_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Diayeta mʉsãrẽ werea. Yʉre bʉremugʉ̃ Yʉpʉ merã perebiri okari opami. ");
INSERT INTO sri_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉ baari irirosũ ããrĩgʉ̃́ okari sĩgʉ̃ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉsã ñekʉ̃sãmarã masaka marĩrõgue manárẽ baanerã ããrĩmá. Irire baakererã, boanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yʉ ʉ̃mʉgasigue merã dijaridea baari gapʉre werea. Irire baagʉ, neõ boabirikumi. ");
INSERT INTO sri_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉ ʉ̃mʉgasigue merã dijaridea baari okari sĩrĩ irirosũ ããrĩgʉ̃́ yʉta ããrã. I baarire baagʉ, Yʉpʉ merã okanígʉkumi. I baari yʉ sĩrĩ, yaa dʉpʉ ããrã. I ʉ̃mʉ marã Yʉpʉ merã okaníkõãburo, ãrĩgʉ̃, yaa dʉpʉre sĩgʉkoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, judío masaka oparã ĩgʉ̃sã basi gãme guaseo, ãsũ ãrĩma: —¿Nasirigʉ marĩrẽ ĩgʉ̃ya dʉpʉre baadoregʉ sĩbukuri? ");
INSERT INTO sri_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ãrĩmi: —Diayeta mʉsãrẽ werea. Yʉ ããrĩpererã tĩ́gʉ̃ ããrã. Mʉsã yaa dʉpʉre baamerã, yaa díre iirímerã okari opabea. ");
INSERT INTO sri_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yaa dʉpʉre baagʉ, yaa díre iirígʉ, Yʉpʉ merã perebiri okari opami. I ʉ̃mʉ peremakʉ̃, ĩgʉ̃rẽ masũgʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yaa dʉpʉ diayema baari ããrã. Yaa dí diayema iiríri ããrã. ");
INSERT INTO sri_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yaa dʉpʉre baagʉ, yaa díre iirígʉ yʉ merã õãrõ ããrĩ́mi. Yʉde ĩgʉ̃ merã õãrõ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉpʉ yʉre iriudi okanígʉ̃ ããrĩ́mi. Ĩgʉ̃ okanígʉ̃ ããrĩsĩã, yʉdere okanímakʉ̃ yámi. Irasirigʉ yʉre baagʉre yʉ irirosũ okanímakʉ̃ irigʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yʉ irire ãrĩgʉ̃, ʉ̃mʉgasigue merã dijaridea baarire werea. I baari, maná mʉsã ñekʉ̃sãmarã baadea irirosũ ããrĩbea. Ĩgʉ̃sã irire baakererã, boanerã ããrĩmá. Ʉ̃mʉgasigue merã dijaridea baari gapʉre baagʉno, okaníkõãgʉkumi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús Capernaugue judío masaka nerẽrĩ wiigue buegʉ, irire weremi. ");
INSERT INTO sri_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ĩgʉ̃ irasũ ãrĩ buemakʉ̃ pérã, wárã Jesúre tʉyarã ãsũ ãrĩ gãme wereníma ĩgʉ̃sã basi: —Ĩgʉ̃ wereri marĩ pémakʉ̃, diasagoráa. ¿Noã ire bokatĩũbukuri? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ĩgʉ̃sã werenírĩrẽ Jesús pékõãmi. Irasirigʉ ĩgʉ̃sãrẽ sẽrẽñami: —¿Yʉ wererire pédʉabirikuri? ");
INSERT INTO sri_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yʉ ããrĩpererã tĩ́gʉ̃ yʉ ããrĩderogue mʉrĩãmakʉ̃ ĩãrã, ¿naásũ gũñabukuri mʉsã? ");
INSERT INTO sri_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Õãgʉ̃ deyomarĩgʉ̃ masakare okarire sĩmi. Ĩgʉ̃sãya dʉpʉ gapʉ ĩgʉ̃sãrẽ okamakʉ̃ irimasĩña máa. Yʉ wererire pérã Õãgʉ̃ deyomarĩgʉ̃ okari sĩrĩrẽ opama. ");
INSERT INTO sri_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Irasũ ããrĩkeremakʉ̃, gajirã mʉsã merãmarã gapʉ yʉre bʉremubema dapa, ãrĩmi Jesús. Neõgoraguere ĩgʉ̃rẽ bʉremumerã ããrĩmurãrẽ, irasũ ããrĩmakʉ̃ ĩgʉ̃rẽ wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmubure masĩsiayupʉ. ");
INSERT INTO sri_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ãsũ ãrĩmi: —Ãsũ ãrĩ wereabʉ mʉsãrẽ. Neõ sugʉ ĩgʉ̃ gããmerõ yʉre tʉyabirikumi. Yʉpʉ, yʉre bʉremumakʉ̃ irigʉ ããrĩ́mi. Ĩgʉ̃ irasiribirimakʉ̃, neõ sugʉno yʉre bʉremubiribukumi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ĩgʉ̃ irasũ ãrĩrĩrẽ pérã, wárã Jesúre tʉyanerã neõ tʉyanemobirima. ");
INSERT INTO sri_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ĩgʉ̃sã irasirimakʉ̃ ĩãgʉ̃, Jesús gʉare pe mojõma pere su gubu peru pẽrẽbejarã ĩgʉ̃ buerãrẽ sẽrẽñami: —¿Mʉsãde yʉre tʉyaduúrã yári? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Simón Pedro ĩgʉ̃rẽ yʉjʉmi: —Gʉa Opʉ, ¿noãrẽ gʉa tʉyabukuri? Mʉ wereri, gʉare Marĩpʉ merã perebiri okari opamakʉ̃ yáa. ");
INSERT INTO sri_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Gʉa mʉrẽ bʉremusiáa. Gʉa ire masĩsiáa. Mʉ õãgʉ̃, Marĩpʉ iriudi ããrã, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Jesús gʉare ãrĩmi: —Yʉ mʉsãrẽ pe mojõma pere su gubu peru pẽrẽbejarãrẽ beyebʉ. Yʉ irasirikeremakʉ̃, sugʉ mʉsã merã ããrĩgʉ̃́ wãtĩyagʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús irasũ ãrĩgʉ̃, Judare Simón Iscariote magʉ̃rẽ ãrĩgʉ̃ iriyupʉ. Judas pe mojõma pere su gubu peru pẽrẽbejarã gʉa merã ããrĩkeregʉ, Jesúre wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmubu ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jesús masakare irire buedero pʉrʉ, Galilea nikũgue naagʉ̃ waami. Judío masaka oparã ĩgʉ̃rẽ wẽjẽdʉarire masĩgʉ̃, Judea nikũguere ããrĩdʉabirimi. ");
INSERT INTO sri_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iripoere judío masaka ñekʉ̃sãmarã masaka marĩrõgue ããrĩrã́, wiirigã irideare gũñarĩ bosenʉ ejaburo dupiyuro ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Irasirirã Jesús pagʉpũrã ĩgʉ̃rẽ ãrĩma: —Õõrẽ dujabita, Judeague bosenʉrẽ ĩãgʉ̃ waaka! Irasirirã irogue mʉ buerã mʉ turari merã iri ĩmurĩrẽ ĩãrãkuma. ");
INSERT INTO sri_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Masaka mʉrẽ masĩmakʉ̃ gããmegʉ̃, mʉ turari merã iri ĩmurĩrẽ ããrĩpererã ĩũrõ iri ĩmugʉ̃ waaka! Ĩgʉ̃sã ĩãberogue iribirikõãka! ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ĩgʉ̃ pagʉpũrã ããrĩkererã, Jesúre bʉremubirima. ");
INSERT INTO sri_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Irasirigʉ Jesús ĩgʉ̃sãrẽ ãrĩmi: —Masaka ĩgʉ̃sã yʉre masĩburo dʉyakõãa dapa. Mʉsãrẽ iri bosenʉrẽ ĩãrã waadʉamakʉ̃ õãgoráa. ");
INSERT INTO sri_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","I ʉ̃mʉ marã mʉsãrẽ ĩãturibema. Yʉ gapʉre ĩgʉ̃sã ñerõ irideare yʉ weremakʉ̃ ĩãturima. ");
INSERT INTO sri_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mʉsã bosenʉrẽ ĩãrã waaka! Yʉre yʉ waaburo dʉyakoa dapa. Irasirigʉ iri bosenʉrẽ ĩãgʉ̃ waabea dapa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ĩgʉ̃ irire ãrãdero pʉrʉ, Galileague dujami. ");
INSERT INTO sri_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ĩgʉ̃ pagʉpũrã bosenʉrẽ ĩãrã waadero pʉrʉ, Jesúde masaka ĩmurõ marĩrõ waami, ĩgʉ̃sã ĩgʉ̃ waaríre masĩbirikõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Iri bosenʉrẽ judío masaka oparã ĩgʉ̃rẽ ãmarã́ iriñurã. Ãsũ ãrĩ sẽrẽñañurã: —¿Noógue ããrĩkuri ĩgʉ̃? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wárã masaka Jesúyamarẽ werenírã iriñurã. Gajirã: “Õãgʉ̃ ããrĩ́mi”, ãrĩñurã. Gajirã gapʉ: “Õãgʉ̃ meta, masakare ãrĩkatorikʉgʉ ããrĩ́mi”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Judío masaka oparãrẽ güirã, ããrĩpererã péurogue: “Jesús ãsũ ããrĩ́mi”, ãrĩ werebiriñurã. ");
INSERT INTO sri_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jesús irogue eja, iri bosenʉ dekokʉaripoe Marĩpʉya wiigue ñajãa, masakare buemi. ");
INSERT INTO sri_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ĩgʉ̃ buemakʉ̃ pérã, judío masaka oparã pégʉka, ãsũ ãrĩma: —Ĩĩ buebiridi ããrĩkeregʉ, ¿nasirigʉ õãrõ masĩrĩ? ");
INSERT INTO sri_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉ bueri, yaa meta ããrã. Yʉre iriudiya bueri gapʉ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Marĩpʉ gããmerĩrẽ iridʉarã yʉ buerire pérã: “Marĩpʉ ĩgʉ̃rẽ buedorerosũta buemi. Ĩgʉ̃ gããmerõ werebemi”, ãrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sugʉ ĩgʉ̃ gããmerõ weregʉ, gajirãrẽ: “Ĩgʉ̃ õãrõ weremi”, ãrĩ bʉremumakʉ̃ iridʉagʉ ããrĩ́mi. Gajigʉ Marĩpʉ ĩgʉ̃rẽ iriudi gããmerĩrẽ weregʉ gapʉ masakare: “Marĩpʉ õãtarimi”, ãrĩ bʉremumakʉ̃ yámi. Ĩgʉ̃ ãrĩkatori marĩrõ diayeta weregʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés Marĩpʉ doreri gojadea pũrẽ mʉsãrẽ pídi ããrĩmí. Mʉsã gapʉ neõ sugʉ iri dorerire iribea. ¿Nasirirã mʉsã yʉre wẽjẽdʉari? ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Masaka ĩgʉ̃rẽ ãrĩma: —Mʉ wãtĩ ñajãsũdi ããrã. ¿Noã mʉrẽ wẽjẽdʉari? ");
INSERT INTO sri_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Suñarõ siñajãrĩnʉ ããrĩmakʉ̃ yʉ sugʉ pũrĩrikʉgʉre taumakʉ̃ ĩãrã, mʉsã ããrĩpererã ĩãgʉkakõãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iripoegue Moisés mʉsã pũrã ʉ̃marẽ ĩgʉ̃sãya dʉpʉma gasirogãrẽ wiiridoredi ããrĩmí. Ĩgʉ̃ irire doreburo dupiyuro mʉsã ñekʉ̃sãmarã irasirisianerã ããrĩmá. Irasirirã mʉsã majĩrãgãrẽ su mojõma pere gaji mojõ ʉreru pẽrẽbejarinʉrĩ waaró merã ĩgʉ̃sã deyoadero pʉrʉ siñajãrĩnʉ ããrĩkeremakʉ̃, ĩgʉ̃sãrẽ irasirináa. ");
INSERT INTO sri_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Irasirirã Moisés dorederosũta irirã, siñajãrĩnʉ ããrĩkeremakʉ̃ mʉsã majĩrãgã ʉ̃marẽ ĩgʉ̃sãya dʉpʉma gasirogãrẽ wiiria. Siñajãrĩnʉ ããrĩmakʉ̃ yʉ sugʉre ããrĩpereri ĩgʉ̃ya dʉpʉmarẽ õãmakʉ̃ iribʉ. ¿Nasirimurã yʉ merã guari mʉsã? ");
INSERT INTO sri_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mʉsã yʉ irideare ĩãdero pʉrʉ: “Ñerõ irimi”, ãrĩ werewʉabirikõãka! Yʉ irideare õãrõ keoro pémasĩ odorãgue wereníka! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ĩgʉ̃ irasũ ãrĩripoere gajirã Jerusalén marã ãsũ ãrĩ wereníma: —¿Ĩĩ marĩ oparã wẽjẽdʉagʉ meta ããrĩ́rĩ? ");
INSERT INTO sri_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ĩgʉ̃ ããrĩpererã ĩũrõgue buegʉ yámi. Sugʉno gapʉta ĩgʉ̃rẽ gajino neõ ãrĩbema. Gajipoe irirã marĩ oparã: “Ĩĩ diayeta Cristo, Marĩpʉ iriudi ããrĩ́mi”, ¿ãrĩ gũñabukuri? ");
INSERT INTO sri_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Marĩ ĩĩ aariderore masĩa. Cristo, Marĩpʉ iriugʉ gapʉre aarimakʉ̃, ĩgʉ̃ ããrĩderoguere masĩbirikoa. Irasirigʉ Cristo ããrĩbirikumi ĩĩ, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús Marĩpʉya wiigue bueripoe ĩgʉ̃sã irasũ ãrĩ werenímakʉ̃ pégʉ, bʉro bʉsʉro merã ãsũ ãrĩ weremi: —Mʉsã yʉre masĩa, ãrã. Ĩgʉ̃ aariderodere masĩa, ãrã. Yʉ gããmerõ aaribiribʉ. Yʉre iriudi keoro irigʉ ããrĩ́mi. Mʉsã ĩgʉ̃rẽ masĩbea. ");
INSERT INTO sri_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yʉ ĩgʉ̃ pʉrogue ããrĩdi ããrĩsĩã, ĩgʉ̃rẽ masĩa. Ĩgʉ̃ta yʉre iriumi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ peresu iridʉakererã, ñeãbirima. Ĩgʉ̃ ñerõ tariburinʉ dʉyabʉ dapa. Irasirirã ĩgʉ̃rẽ ñeãbirima. ");
INSERT INTO sri_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gajirã wárã masaka ĩgʉ̃rẽ bʉremuma. Ãsũ ãrĩma: —Neõ sugʉ, ĩĩ nemorõ Marĩpʉ turari merã iri ĩmugʉ̃ mámi. Irasirigʉ ĩĩ Cristo, Marĩpʉ iriudi ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo bumarã, masaka Jesúre: “Ĩĩ Marĩpʉ iriudi ããrĩ́mi”, ãrĩrĩrẽ péñurã. Irasirirã ĩgʉ̃sã paía oparã merã Marĩpʉya wiire korerã surarare ĩgʉ̃rẽ ñeã, peresu iridorerã iriuadiñurã. ");
INSERT INTO sri_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Irasirigʉ Jesús masakare ãsũ ãrĩmi: —Yoaweyaripoe mʉsã merã ããrĩgʉkoa. Pʉrʉ yʉre iriudi pʉrogue waagʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉ ããrĩburore mʉsã waamasĩbirikoa. Irasirirã yʉre ãmakererã, neõ bokabirikoa. ");
INSERT INTO sri_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, judío masaka oparã ĩgʉ̃sã basi ãsũ ãrĩ gãme sẽrẽñama: —Ĩgʉ̃ marĩrẽ: “Yʉre mʉsã neõ bokabirikoa”, ãrĩgʉ̃, ¿noógue waagʉkuri? ¿Ĩgʉ̃ judío masaka griego ããrĩrṍgue makãrĩ waanerã pʉrogue griego masakare buegʉ waabukuri? ");
INSERT INTO sri_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ĩgʉ̃ marĩrẽ: “Yʉ ããrĩburore mʉsã waamasĩbirikoa. Irasirirã yʉre ãmakererã, neõ bokabirikoa”, ãrĩrĩ, ¿naásũ ãrĩdʉaro iriayuri? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ĩgʉ̃sã bosenʉ iritũnurĩnʉ dupanʉgora ããrĩmakʉ̃, Jesús wãgãnʉgã, bʉro bʉsʉro merã masakare ãsũ ãrĩ weremi: —Ñemesiburã yʉ pʉrogue iirírã aarika! ");
INSERT INTO sri_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Yʉre bʉremurãya yʉjʉpũrãrĩguere okari sĩrĩ deko ũmayoro irirosũ ããrĩníkõãrokoa”, ãrĩ gojasũdero ããrĩbʉ́, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús irire ãrĩgʉ̃: “Yʉre bʉremurã Õãgʉ̃ deyomarĩgʉ̃rẽ oparãkuma”, ãrĩgʉ̃ irimi. Jesús ʉ̃mʉgasigue mʉrĩaburo dupiyuro Õãgʉ̃ deyomarĩgʉ̃ ejabirimi dapa. ");
INSERT INTO sri_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús ãrĩrĩrẽ pérã, gajirã ãsũ ãrĩma: —Ĩĩ diayeta Marĩpʉya kerere weredupiyurimasʉ̃: “Marĩ pʉro aaribu ããrãyupʉ”, ĩgʉ̃sã ãrĩdi ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gajirã ãsũ ãrĩma: —Ĩĩ, Cristo Marĩpʉ iriudi ããrĩ́mi. Gajirã gapʉ: —Cristo, ¿nasiribu Galileamʉ ããrĩbukuri? ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Marĩpʉya werenírĩ gojadea pũgue ãsũ gojasũdero ããrĩbʉ́: “Cristo Marĩpʉ iriubu, opʉ David parãmi ããrĩturiagʉ ããrĩgʉkumi. David deyoadea makã Belén wãĩkʉri makãgue deyoagʉkumi”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Irasirirã Jesúre surosũ gũñabirisĩã, gãme dʉkawariakõãma. ");
INSERT INTO sri_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Surãyeri Jesúre ñeã, peresu iridʉakererã, iribirima. ");
INSERT INTO sri_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Irasirirã Marĩpʉya wiire korerã surara Jesúre ñeãdorerã iriunerã, paía oparã, fariseo bumarã pʉrogue goedujáañurã. Ĩgʉ̃sã goedujajamakʉ̃ ĩãrã, ĩgʉ̃sãrẽ sẽrẽñañurã: —¿Nasirirã Jesúre ñeã, ãĩribirari? ");
INSERT INTO sri_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Surara ĩgʉ̃sãrẽ yʉjʉñurã: —Neõ sugʉ ĩgʉ̃ irirosũ werenígʉ̃ mámi. ");
INSERT INTO sri_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, fariseo bumarã ĩgʉ̃sãrẽ ãrĩñurã: —¿Mʉsãde ĩgʉ̃ ãrĩkatori merã weremakʉ̃: “Diayeta weremi”, ãrĩ bʉremurĩ? ");
INSERT INTO sri_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Neõ sugʉ marĩ oparã, neõ sugʉ gʉa fariseo bumarã ĩgʉ̃rẽ bʉremugʉ̃ mámi. ");
INSERT INTO sri_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sĩĩsã masaka gapʉ ĩgʉ̃ wererire bʉremurã, Marĩpʉ Moisére doreri pídeare masĩbema. Wajamoãsũmurã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo fariseo bumʉ iro dupiyuro ñami merã Jesúre ĩãgʉ̃ ejadi, ĩgʉ̃sã merã ããrĩyupʉ. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃sãrẽ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Marĩrẽ doreri ãsũ ãrã. Sugʉ masakʉ ĩgʉ̃ irideare weremakʉ̃ marĩ péburo dupiyuro ĩgʉ̃rẽ: “Ñerõ iribʉ”, ãrĩ wajamoãmasĩbea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ãsũ ãrĩ yʉjʉñurã: —¿Mʉde ĩgʉ̃ irirosũ Galileamʉ ããrĩ́rĩ? Marĩpʉya werenírĩ gojadea pũrẽ bueka! Iri pũrẽ buegʉ: “Neõ sugʉ Galileamʉ Marĩpʉya kerere weredupiyurimasʉ̃ mámi”, ãrĩ masĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ĩgʉ̃sã irasũ ãrãdero pʉrʉ, ĩgʉ̃sãya wiirigue dujáakõãñurã. ");
INSERT INTO sri_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús gapʉ ʉ̃tãʉ̃ Olivos wãĩkʉdigue waami. ");
INSERT INTO sri_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gajinʉ gapʉ boyoripoe ããrĩmakʉ̃, Marĩpʉya wiigue waami doja. Ĩgʉ̃ ejamakʉ̃ ĩãrã, masaka ããrĩpererã ĩgʉ̃ pʉro nerẽma. Irasirigʉ eja doa, ĩgʉ̃sãrẽ buenʉgãmi. ");
INSERT INTO sri_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Moisés gojadeare buerimasã, fariseo bumarã sugo nomeõrẽ gajigʉ igo marãpʉ ããrĩbi merã igo ñerõ irigore bokajañurã. Irasirirã Jesús bueripoe iri wiigue ããrĩpererã masaka ĩũrõ igore ãĩñajãnú, Jesúre ãrĩma: ");
INSERT INTO sri_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—Buegʉ, igo marãpʉkʉgo ããrĩkerego, gajigʉ merã ñerõ irigore bokajabʉ. ");
INSERT INTO sri_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés Marĩpʉ doreri gojadea pũgue igo nomeõ irirosũ irigonorẽ ʉ̃tãyeri merã dea wẽjẽdoredi ããrĩmí. Mʉkoa, ¿naásũ ãrĩrĩ? ");
INSERT INTO sri_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","“¿Naásũ yʉjʉgʉkuri?” ãrĩrã, ĩgʉ̃rẽ irasũ ãrĩ sẽrẽñadima. “Ĩgʉ̃ keoro yʉjʉbirimakʉ̃, marĩ oparãguere weresãrãkoa”, ãrĩ gũñañurã. Ĩgʉ̃sã irasũ sẽrẽñamakʉ̃ pégʉ, Jesús gapʉ muúbia doaja, nikũgue ĩgʉ̃ya mojõsũrũ merã gojami. ");
INSERT INTO sri_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ĩgʉ̃sã ĩgʉ̃rẽ sẽrẽñaduúbirimakʉ̃ pégʉ, Jesús wãgãnʉgã, ãsũ ãrĩmi: —Mʉsã merãmʉ ñerõ iribino igore ʉ̃tãye merã deapʉroriburo. ");
INSERT INTO sri_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Irasũ ãrĩ odo, dupaturi muúbia doaja, nikũgue gojami doja. ");
INSERT INTO sri_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã ñerĩ irideare pémasĩ, gʉyasĩrĩrĩ merã, mʉrã sugʉ pʉrʉ, gajigʉ pʉrʉ wiriapʉrorima. Irasirirã Jesúre sugʉta nomeõ iro dujago merã píkõã, waakõãma. ");
INSERT INTO sri_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús wãgãnʉgã, igore ãrĩmi: —¿Noógue ããrĩ́rĩ mʉrẽ weresãnerã? ¿Neõ sugʉ mʉrẽ wajamoãdoregʉ márĩ? ");
INSERT INTO sri_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Mámi, yʉ Opʉ, ãrĩ yʉjʉmo. Igo irasũ ãrĩmakʉ̃, Jesús igore ãrĩmi: —Yʉde mʉrẽ wajamoãdorebea. Irasirigo waaka! Dupaturi ñerĩrẽ neõ irinemobirikõãka! ");
INSERT INTO sri_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús dupaturi masakare ãsũ ãrĩ weremi: —Yʉ i ʉ̃mʉ marãrẽ sĩãgori sĩgʉ̃ ããrã. Yʉre tʉyarã naĩtĩãrõgue ããrĩrã́ irirosũ ããrĩbema. Boyorogue ããrĩrã́ irirosũ ããrĩ́ma. Irasirirã yʉ okari sĩrĩrẽ oparãkuma. ");
INSERT INTO sri_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, fariseo bumarã ãrĩma: —Mʉ basi mʉ ããrĩrikʉrire werea. Irasiriro mʉ werenírĩ neõ wajamáa. ");
INSERT INTO sri_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús ĩgʉ̃sãrẽ ãsũ ãrĩ yʉjʉmi: —Yʉ aariderore, yʉ waaburodere yʉ masĩa. Mʉsã gapʉ irire neõ masĩbea. Irasirigʉ yʉ basi yʉ ããrĩrikʉrire werekeremakʉ̃, yʉ werenírĩ diayeta ããrã. ");
INSERT INTO sri_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mʉsã i ʉ̃mʉ marã irirosũ yʉre werewʉáa. Yʉ gapʉ neõ sugʉre mʉsã irirosũ werewʉabea. ");
INSERT INTO sri_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yʉ masaka ããrĩrikʉrire: “I gapʉ õãa, i gapʉ õãbea”, ãrĩgʉ̃, keoro ãrã. Yʉ sugʉta yʉ gããmerõ irire ãrĩbea. Yʉpʉ yʉre iriudi merã irire irasũ yáa. ");
INSERT INTO sri_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉsãrẽ doreri gojadea pũgue ãsũ ãrã: “Pẽrã masaka ĩgʉ̃sã ĩãdeare surosũ weremakʉ̃: ‘Diayeta ããrã’, ãrĩ bʉremurõ gããmea”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yʉ basi yʉ ããrĩrikʉrire werea. Yʉpʉ yʉre iriudide yʉ ããrĩrikʉrire weremi, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ sẽrẽñama: —¿Noógue ããrĩ́rĩ mʉpʉ? Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Mʉsã yʉre, Yʉpʉdere masĩbea. Yʉre masĩrã, Yʉpʉdere masĩboayo. ");
INSERT INTO sri_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús irasũ ãrĩ weregʉ, Marĩpʉya wiigue ããrĩmí. Masaka niyeru sĩrã, ĩgʉ̃sã sãrĩ kũmarĩ pʉro ããrĩmí. Ĩgʉ̃ ñerõ tariburinʉ ejabiribʉ dapa. Irasirirã neõ sugʉ ĩgʉ̃rẽ ñeã, peresu iribirima. ");
INSERT INTO sri_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús dupaturi judío masaka oparãrẽ weremi: —Yʉ ããrĩderogue waagʉkoa. Yʉ waadero pʉrʉ, mʉsã yʉre ãmarãkoa. Mʉsã ñerĩ iridea waja, waja oparã boarãkoa. Yʉ waaburoguere mʉsã waamasĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gãme sẽrẽñama: —¿Nasirigʉ: “Yʉ waaburoguere mʉsã waamasĩbirikoa”, ãrĩrĩ? ¿Ĩgʉ̃ basi wẽjẽ boagʉkuri irasũ ãrĩgʉ̃? ");
INSERT INTO sri_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Mʉsã gapʉ i ʉ̃mʉgue ããrĩrã́, i ʉ̃mʉ marã ããrã. Yʉ gapʉ ʉ̃mʉgasigue ããrĩdi, i ʉ̃mʉmʉ meta ããrã. ");
INSERT INTO sri_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Irasirigʉ mʉsãrẽ: “Mʉsã ñerĩ iridea waja, waja oparã boarãkoa”, ãrãbʉ. Mʉsã: “Yʉ ĩgʉ̃ ããrã”, ãrĩ wereadeare bʉremubirisĩã, mʉsã ñerĩ iridea waja, waja oparã boarãkoa. ");
INSERT INTO sri_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Irasũ ãrĩgʉ̃ pérã ĩgʉ̃rẽ sẽrẽñama: —¿Noãno ããrĩ́rĩ mʉ? Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Buenʉgãgʉ̃gueta mʉsãrẽ: “Yʉ ĩgʉ̃ ããrã”, ãrĩ weresiabʉ. ");
INSERT INTO sri_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yʉ mʉsãyamarẽ, mʉsã ñerõ iridea waja mʉsãrẽ wajamoãburire weredʉari, wári ããrã. Yʉre iriudi gapʉ diaye weremi. Irasirigʉ ĩgʉ̃ weremakʉ̃ yʉ pédea ditare mʉsã i ʉ̃mʉ marãrẽ werea, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesús: “Yʉre iriudi”, ãrĩgʉ̃, ĩgʉ̃ Pagʉreta werenígʉ̃ irimi. Ĩgʉ̃sã gapʉ irire pémasĩbirima. ");
INSERT INTO sri_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Irasirigʉ Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉre ããrĩpererã tĩ́gʉ̃rẽ mʉsã curusague pábiatú ãĩwãgũnúrãkoa. Mʉsã irasũ irirã: “Yʉ ĩgʉ̃ ããrã”, ãrĩ wereadeare: “Diayeta ããrã”, ãrĩ masĩrãkoa. Yʉ gããmerõ neõ iribi, irasũ ããrĩmakʉ̃ Yʉpʉ yʉre buedea ditare yʉ weregʉ ããrĩrĩ́rẽ masĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yʉre iriudi yʉ merã ããrĩ́mi. Ĩgʉ̃ gããmerĩ ditare irinía. Irasirigʉ ĩgʉ̃ yʉre neõ béobemi. ");
INSERT INTO sri_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús irasũ ãrĩmakʉ̃ pérã, wárã masaka ĩgʉ̃rẽ bʉremuma. ");
INSERT INTO sri_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús, judío masaka: “Marĩpʉ iriudi ããrĩ́mi”, ãrĩ bʉremurãrẽ ãsũ ãrĩmi: —Yʉ werenírĩrẽ bʉremuduúmerã, diayeta yʉ buerã ããrã. ");
INSERT INTO sri_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Irasirirã diayema ããrĩrĩ́rẽ masĩrãkoa. Irire masĩrã, ñerõ iririre pirirãkoa. Moãboeanerã mʉsã opʉre wirianerã irirosũ ããrĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ ãrĩma: —Gʉa Abraham parãmerã ããrĩturiarãgue ããrã. Irasirirã neõ gajirãyarã ĩgʉ̃sãrẽ moãboerã ããrĩbea. Irasirigʉ: “Moãboeanerã mʉsã opʉre wirianerã irirosũ ããrĩrãkoa”, ãrĩgʉ̃, ¿naásũ ãrĩdʉagʉ irasũ ãrĩrĩ mʉ? ");
INSERT INTO sri_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Diayeta mʉsãrẽ werea. Ããrĩpererã ñerĩrẽ irirã, ñerĩrẽ iridoregʉyarã ĩgʉ̃ dokamarã irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sugʉ moãboegʉ wii opʉ magʉ̃ irirosũ neõ ããrĩbemi. Wii opʉ magʉ̃ gapʉ ĩgʉ̃ pagʉya wiimʉ ããrĩníkõãkumi. ");
INSERT INTO sri_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yʉ, ʉ̃mʉgasigue ããrĩgʉ̃́ magʉ̃ ããrã. Irasirigʉ mʉsãrẽ ñerĩrẽ iridoregʉyarã irirosũ ããrĩbirimakʉ̃ irigʉ, diayeta moãboeanerã mʉsã opʉre wirianerã irirosũ ããrĩmakʉ̃ irigʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yʉ mʉsã Abraham parãmerã ããrĩturiarire masĩa. Irasũ ããrĩkererã, mʉsã yʉ wererire pédʉabea. Irasirirã yʉre wẽjẽdʉáa. ");
INSERT INTO sri_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉpʉ yʉre masĩmakʉ̃ irideare mʉsãrẽ werea. Mʉsã gapʉ mʉsãpʉ dorerire yáa. ");
INSERT INTO sri_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ĩgʉ̃sã ĩgʉ̃rẽ ãrĩma: —Abraham gʉa ñekʉ̃ ããrĩdi ããrĩmí. Jesús gapʉ ĩgʉ̃sãrẽ ãrĩmi: —Mʉsã diayeta Abraham parãmerã ããrĩturiarã ããrĩrã́ ĩgʉ̃ iriunaderosũta iririkʉboayo. ");
INSERT INTO sri_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yʉpʉ yʉre diaye wererire mʉsãrẽ yʉ werekeremakʉ̃, yʉre wẽjẽdʉáa. Abraham gapʉ mʉsã irirosũ neõ irasiribiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉsã mʉsãpʉ irirosũta yáa. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ãrĩma: —Gʉa, pagʉ marĩrã irirosũ ããrĩbea. Marĩpʉ sugʉta gʉapʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉpʉ diayeta mʉsãpʉ ããrĩmakʉ̃, mʉsã yʉre maĩboayo. Yʉ ĩgʉ̃ merã ããrĩdita õõ mʉsã pʉrogue aaribʉ́. Yʉ gããmerõ aaribiribʉ. Yʉpʉ yʉre iriumi. ");
INSERT INTO sri_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nasirirã yʉ wererire pémasĩberi mʉsã? Mʉsã yʉ wererire pédʉabirisĩã, pémasĩbea. ");
INSERT INTO sri_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉsãpʉ wãtĩ ããrĩ́mi. Mʉsã ĩgʉ̃yarã ããrã. Irasirirã ĩgʉ̃ gããmerĩrẽ iridʉáa. Neõgoragueta masakare wẽjẽbéodi ããrĩgʉ̃́ yámi. Ĩgʉ̃guere diayema neõ máa. Irasirigʉ ĩgʉ̃ neõ diayemarẽ werebemi. Neõgoraguere masakare ãrĩkatopʉroridi ããrĩmí. Irasirigʉ ĩgʉ̃ irasũ ãrĩkatorikʉgʉ ããrĩsĩã, ãrĩkatori ditare weremi. ");
INSERT INTO sri_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yʉ gapʉ diayemarẽ werea. Irasirirã yʉ wererire pérã, mʉsã irire bʉremubea. ");
INSERT INTO sri_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Noã yʉre: “Mʉ ãsũ irigʉ, ñerõ iriabʉ”, ãrĩ masĩbukuri? Yʉ mʉsãrẽ diayemarẽ werekeremakʉ̃, ¿nasirirã yʉ wererire bʉremuberi? ");
INSERT INTO sri_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yʉpʉ pũrã ĩgʉ̃ werenírĩrẽ péma. Mʉsã gapʉ ĩgʉ̃ pũrã ããrĩbirisĩã, irire pédʉabea, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jesús irasũ ãrĩmakʉ̃ pérã, judío masaka ĩgʉ̃rẽ ãrĩma: —Gʉa: “Mʉ Samariamʉ, wãtĩ ñajãsũdi ããrã”, ãrĩrã, diayeta ãrĩrã yáa. ");
INSERT INTO sri_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉ wãtĩ ñajãsũdi ããrĩbea. Yʉ iriri merã masaka Yʉpʉre: “Õãtaria mʉ”, ãrĩmakʉ̃ yáa. Mʉsã gapʉ yʉ iririre ĩãkererã: “Ñerĩrẽ irigʉ ããrĩ́mi”, ãrã. ");
INSERT INTO sri_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yʉre: “Õãrõ yáa”, ãrĩ bʉremurãrẽ ãmabea yʉ. Yʉpʉ gapʉ masakare yʉre bʉremumakʉ̃ gããmemi. Ĩgʉ̃ta yʉ iririre ĩãgʉ̃, yʉre: “Õãrõ yáa”, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Diayeta mʉsãrẽ werea. Yʉ wererire irigʉ neõ boabirikumi. ");
INSERT INTO sri_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ ãrĩma: —Dapagora gʉa ire masĩa. Mʉ wãtĩ ñajãsũdi ããrã. Abraham iripoegue boakõãdi ããrĩmí. Marĩpʉya kerere weredupiyunerãde boakõãnerã ããrĩmá. Mʉ gapʉ: “Yʉ wererire irigʉ neõ boabirikumi”, ãrã. ");
INSERT INTO sri_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Gʉa ñekʉ̃ Abraham nemorõ ããrĩ́rĩ mʉ? Ĩgʉ̃, Marĩpʉya kerere weredupiyunerãde boakõãnerã ããrĩmá. ¿Noã ããrĩ́rĩ mʉ irasũ ãrĩ weregʉ? ");
INSERT INTO sri_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉ, yʉ basi õãrõ werenírĩ wajamáa. Yʉpʉ gapʉ mʉsã: “Gʉapʉ ããrĩ́mi”, ãrĩgʉ̃ gapʉ yʉre õãrõ weremi. ");
INSERT INTO sri_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉsã gapʉ Yʉpʉre neõ masĩbea. Yʉ ĩgʉ̃rẽ masĩa. Yʉ: “Ĩgʉ̃rẽ masĩbea”, ãrĩgʉ̃, mʉsã irirosũ ãrĩkatorikʉgʉ ããrĩbukoa. Yʉ gapʉ ĩgʉ̃rẽ õãrõ masĩa. Irasũ ããrĩmakʉ̃, ĩgʉ̃ wererire yáa. ");
INSERT INTO sri_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mʉsã ñekʉ̃ Abraham yʉ i ʉ̃mʉgue aariburire masĩdi ããrĩmí. Irasirigʉ yʉ aarimakʉ̃ ĩãgʉ̃, bʉro ʉsʉyari merã ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ĩgʉ̃sã Jesúre ãrĩma: —Mʉ cincuenta bojori opabirikeregʉ, ¿nasirigʉ Abrahãrẽ ĩãdi ããrĩbukuri? ");
INSERT INTO sri_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Diayeta mʉsãrẽ werea. Abraham dupiyuro ããrĩdi yʉta ããrã. ");
INSERT INTO sri_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã ʉ̃tãyeri ãĩ, ĩgʉ̃rẽ dea wẽjẽdʉamakʉ̃, Marĩpʉya wiigue ããrãdi ĩgʉ̃sã watope duriwiriakõãmi. ");
INSERT INTO sri_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Gajinʉ Jesús maague waagʉ́, deyoagʉgueta koye ĩãmasĩbire bokajami. ");
INSERT INTO sri_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gʉa ĩgʉ̃rẽ ĩãrã, Jesúre sẽrẽñabʉ: —Buegʉ, ¿noã ñerõ iridea waja ĩgʉ̃ koye ĩãmasĩbi deyoayuri? ¿Ĩgʉ̃ pagʉsãmarã ñerõ iridea waja, o ĩgʉ̃ basi ĩgʉ̃ ñerõ iridea waja ĩgʉ̃rẽ irasũ waayuri? ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús gʉare ãrĩmi: —Ĩgʉ̃ ñerõ iridea, ĩgʉ̃ pagʉsãmarã ñerõ iridea ĩgʉ̃ deyoagʉgueta koye ĩãmasĩbi ããrĩmakʉ̃ iribiribʉ. Marĩpʉ ĩgʉ̃ turari merã ĩgʉ̃rẽ õãrĩ iririre masakare ĩmugʉkumi. Irasirigʉ ĩgʉ̃ koye ĩãmasĩbi deyoami. ");
INSERT INTO sri_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ʉ̃mʉ merã masaka moãmasĩrã irirosũ dapagora Marĩpʉ yʉre iriugʉ pídeare marĩrẽ iriro gããmea. Ñami merã moãmasĩmerã irirosũ pʉrʉgue ĩgʉ̃ pídeare irimasĩbirikoa pama. ");
INSERT INTO sri_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yʉ i ʉ̃mʉguere ããrĩgʉ̃́, masakare sĩãgori sĩgʉ̃ ããrã. Irasirigʉ ĩgʉ̃sãrẽ Marĩpʉre masĩmakʉ̃ yáa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Irasũ ãrĩ odo, nikũgue síkure eomeépí, iri merã morẽ, koye ĩãmasĩbiya koyeguere túwʉ̃kãmi. ");
INSERT INTO sri_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Irasiri odo, ĩgʉ̃rẽ ãrĩmi: —Siloé wãĩkʉri deko gobegue ĩgʉ̃sã iridea gobegue mʉya koyere koegʉ waaka! ãrĩmi. “Siloé”, ãrĩrõ: “Iriugʉ”, ãrĩdʉaro yáa. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, koye ĩãmasĩbi irogue ĩgʉ̃ya koyere koegʉ waakõãmi. Koe odo, koye ĩãmasĩgʉ̃gue dujariyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ĩgʉ̃ya wiigue dujajamakʉ̃, ĩgʉ̃ya wii pʉro ããrĩrã́, iro dupiyuro ĩgʉ̃ niyeru sẽrẽdi ããrĩmakʉ̃ ĩãnerã, sẽrẽñañurã: —¿Ĩĩ dupiyuro niyeru sẽrẽ doanídita ããrĩ́rĩ? ");
INSERT INTO sri_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Gajirã ãrĩñurã: —Ĩgʉ̃ta ããrĩ́mi. Gajirã gapʉ ãrĩñurã: —Ĩgʉ̃ ããrĩbemi. Ĩgʉ̃ irirosũ deyogʉ ããrĩ́mi. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, koye ĩãmasĩbi ããrãdi gapʉ ãsũ ãrĩyupʉ: —Ĩgʉ̃ta ããrã yʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃, masaka ĩgʉ̃rẽ sẽrẽñañurã: —Mʉ ĩãmasĩbiradi ããrĩgʉ̃́, ¿nasirigʉ dapagorare irasũ ĩãmasĩrĩ? ");
INSERT INTO sri_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ĩgʉ̃sãrẽ yʉjʉyupʉ: —Jesús wãĩkʉgʉ ĩgʉ̃ya síku nikũ merã moãmorẽ, yʉ koyere túwʉ̃kãmi. Túwʉ̃kã odo, yʉre: “Siloé wãĩkʉri deko gobegue ĩgʉ̃sã iridea gobegue mʉya koyere koegʉ waaka!” ãrãmi. Yʉ irogue waa, koyere koe odo, ĩãmasĩpʉroriabʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃rẽ sẽrẽñañurã doja: —Mʉrẽ irasiriadi, ¿noógue ããrãrĩ? —Masĩbirikoa. Noó ããrĩgʉ̃́ ããrĩkumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pʉrʉ ĩgʉ̃sã koye ĩãmasĩbiridire fariseo bumarã pʉrogue ãĩãñurã. ");
INSERT INTO sri_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús ĩgʉ̃ya síku nikũ merã moãmorẽ, koye ĩãmasĩbire taudeanʉ judío masaka siñajãrĩnʉ ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Irasirirã fariseo bumarã koye ĩãmasĩbiridire sẽrẽñañurã: —¿Nasirigʉ dapagorare õãrõ ĩãrĩ? Ĩgʉ̃sãrẽ yʉjʉyupʉ: —Sugʉ ĩgʉ̃ya síku nikũ merã moãmorẽ, yaa koyere túwʉ̃kãmi. Irasirigʉ yaa koyere koeadero pʉrʉ, ĩãmasĩpʉroribʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ĩgʉ̃ irasũ ãrĩmakʉ̃, surãyeri fariseo bumarã merãmarã ãrĩñurã: —Ĩgʉ̃rẽ irasiridi, marĩ siñajãrĩnʉrĩma dorerire iribi ããrĩ́mi. Irasirigʉ Marĩpʉ iriudi ããrĩbemi. Gajirã gapʉ ãrĩñurã: —Ĩgʉ̃ ñerõ irigʉno ããrĩgʉ̃́, i iri ĩmurĩrẽ irimasĩbiriboayupʉ. Irasirirã ĩgʉ̃sã surosũ gũñabirisĩã, dʉkawariñurã. ");
INSERT INTO sri_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Irasirirã dupaturi koye ĩãmasĩbiridire sẽrẽñañurã doja: —Mʉkoa, ¿naásũ ãrĩrĩ mʉrẽ koye ĩãmasĩmakʉ̃ iridire? Ĩgʉ̃ yʉjʉyupʉ: —Ĩgʉ̃ Marĩpʉ kerere weredupiyugʉ ããrĩ́mi, ãrã yʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Judío masaka oparã gapʉ: “Ĩĩ koye ĩãmasĩgʉ̃, dupiyuro koye ĩãmasĩbi ããrĩdi ããrĩbemi”, ãrĩ gũñadiñurã. Irasirirã ĩgʉ̃ pagʉsãmarãrẽ siiu, sẽrẽñañurã: —“¿Ĩĩ mʉ magʉ̃ neõ deyoagʉgueta koye ĩãmasĩbi ããrĩdi ããrĩ́mi”, ãrĩrĩ? Ĩgʉ̃ diayeta koye ĩãmasĩbiridi ããrĩgʉ̃́, ¿nasiri dapagorare õãrõ ĩãmasĩrĩ? ");
INSERT INTO sri_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ĩgʉ̃ pagʉsãmarã yʉjʉñurã: —Ire gʉa masĩa. Ĩĩ gʉa magʉ̃ta ããrĩ́mi. Ĩgʉ̃ deyoagʉgueta koye ĩãmasĩbiridita ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ĩgʉ̃ dapagora koye ĩãmasĩrĩ gapʉre, ĩgʉ̃rẽ ĩãmakʉ̃ irididere masĩbea. Ĩgʉ̃rẽ sẽrẽñaka! Bʉgʉro ããrĩ́mi. Ĩgʉ̃ basi mʉsãrẽ yʉjʉmasĩmi. ");
INSERT INTO sri_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judío masaka oparã dupiyurogue ãsũ ãrĩñurã: —Jesúre: “Marĩpʉ iriudi Cristo ããrĩ́mi”, ãrĩgʉ̃norẽ marĩ nerẽrĩ wiirigue neõ ñajãdorebirikõãrã! ãrĩñurã. Irasirirã, ĩgʉ̃sã ãrĩdeare pénerã ããrĩsĩã, koye ĩãmasĩbiridi pagʉsãmarã ĩgʉ̃sãrẽ güigorañurã. ");
INSERT INTO sri_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Irasirirã ĩgʉ̃sãrẽ: “Bʉgʉro ããrĩ́mi. Ĩgʉ̃rẽ sẽrẽñaka!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Judío masaka oparã irire pérã, dupaturi koye ĩãmasĩbiridire siiu, ĩgʉ̃rẽ ãrĩñurã doja: —Marĩpʉ mʉ wererire pémi. Irasirigʉ ĩgʉ̃ péurogue gʉare diaye wereka! Gʉa ire masĩa. Jesús ñerõ irigʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃sãrẽ ãsũ ãrĩ yʉjʉyupʉ: —Jesúre ĩgʉ̃ ñegʉ̃, o õãgʉ̃ ããrĩrĩ́rẽ masĩbirikoa yʉ. I ditare masĩa. Yʉ dupiyuroguere koye ĩãmasĩbi ããrĩbʉ́. Dapagorare ĩãa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, dupaturi ĩgʉ̃rẽ sẽrẽñañurã doja: —¿Nasiriri ĩgʉ̃ mʉrẽ? ¿Nasirigʉ ĩgʉ̃ mʉrẽ koye ĩãmasĩmakʉ̃ iriri? ");
INSERT INTO sri_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ĩgʉ̃ yʉjʉyupʉ ĩgʉ̃sãrẽ: —Irireta mʉsãrẽ weresiabʉ. Yʉ irasũ ãrĩ werekeremakʉ̃, mʉsã gapʉ yʉ wererire pédʉabirabʉ. ¿Nasirirã dupaturi yʉ irire weremakʉ̃ pédʉari? ¿Mʉsãde ĩgʉ̃ buerã ããrĩdʉakuri? ");
INSERT INTO sri_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃rẽ turiñurã: —Mʉ ĩgʉ̃ buegʉ ããrã. Gʉa gapʉ Moisés gojadeare buerã ããrã. ");
INSERT INTO sri_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ire gʉa masĩa. Marĩpʉ Moisére weredi ããrĩmí. Jesúre iriudi gapʉre gʉa masĩbea. ");
INSERT INTO sri_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, ĩgʉ̃sãrẽ ãsũ ãrĩ yʉjʉyupʉ: —Mʉsã irasũ ãrĩmakʉ̃, pégʉkakõãkoa. Ĩgʉ̃ yʉre koye ĩãmasĩmakʉ̃ irikeremakʉ̃, mʉsã ĩgʉ̃rẽ iriudire masĩbea, ãrã. ");
INSERT INTO sri_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Marĩ ire õãrõ masĩa. Marĩpʉ ñerõ irirã ĩgʉ̃rẽ sẽrẽmakʉ̃ pébemi. Ĩgʉ̃rẽ bʉremugʉ̃, ĩgʉ̃ dorerire irigʉre ĩgʉ̃ sẽrẽrĩ ditare pémi. ");
INSERT INTO sri_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Marĩ neõ sugʉ deyoagʉgueta koye ĩãmasĩbire ĩãmakʉ̃ irigʉ ããrĩrĩ́rẽ pébea. ");
INSERT INTO sri_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Marĩpʉ Jesúre iriubirimakʉ̃, yʉre koye ĩãmasĩmakʉ̃ iribiriboañumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ãrĩñurã: —Mʉ deyoagʉgueta ñerĩ merã deyoadi ããrĩkeregʉ, ¿irire weredʉari gʉare buebu? ãrĩñurã. Irasirirã judío masaka nerẽrĩ wiigue ĩgʉ̃rẽ ñajãdorebiriñurã. ");
INSERT INTO sri_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús koye ĩãmasĩbiridire ĩgʉ̃sã béowiuadeare pémi. Irasirigʉ ĩgʉ̃rẽ bokajagʉ, sẽrẽñami: —¿Marĩpʉ magʉ̃ ããrĩpererã tĩ́gʉ̃rẽ bʉremurĩ mʉ? ");
INSERT INTO sri_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ĩgʉ̃ Jesúre ãrĩmi: —Yʉ Opʉ, ¿noã ããrĩ́rĩ ĩgʉ̃? Wereka yʉre! Ĩgʉ̃rẽ masĩgʉ̃, bʉremugʉra. ");
INSERT INTO sri_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús ĩgʉ̃rẽ ãrĩmi: —Mʉ ĩgʉ̃rẽ ĩãsiáa. Yʉ mʉ merã werenígʉ̃, ĩgʉ̃ta ããrã. ");
INSERT INTO sri_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Irire ãrĩmakʉ̃ pégʉ, Jesús pʉro ñadʉkʉpuri merã ejamejã, ĩgʉ̃rẽ: —Yʉ Opʉ, mʉrẽ bʉremua, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Pʉrʉ Jesús ãsũ ãrĩmi: —Yʉ masaka irideare: “I gapʉ õãa, i gapʉ õãbea”, ãrĩgʉ̃, i ʉ̃mʉguere aaribʉ́. Yʉpʉ gããmerĩrẽ masĩmerã, koye ĩãmasĩmerã irirosũ ããrĩ́ma. Irasirigʉ koye ĩãmasĩmerã irirosũ ããrĩrã́rẽ ĩgʉ̃ gããmerĩrẽ masĩburo, ãrĩgʉ̃, “Gʉa õãrõ masĩa”, ãrĩ gũñarã gapʉre koye ĩãmasĩmerã irirosũ waaburo, ãrĩgʉ̃ aaribʉ́. ");
INSERT INTO sri_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, surãyeri fariseo bumarã ĩgʉ̃rẽ ãrĩma: —¿Mʉ irire ãrĩgʉ̃, gʉadere: “Koye ĩãmasĩmerã irirosũ ããrã”, ãrĩgʉ̃ yári? ");
INSERT INTO sri_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Mʉsã koye ĩãmasĩmerã irirosũ Yʉpʉ gããmerĩrẽ masĩmerã ããrĩrã́, mʉsã ñerĩ iridea wajare opabiribukoa. “Gʉa õãrõ masĩa”, ãrĩrã ããrĩsĩã, mʉsã ñerõ iridea wajare opáa dapa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús irire ãrĩ odoadero pʉrʉ, keori merã ãsũ ãrĩ weremi: —Diayeta mʉsãrẽ werea. Oveja korerimasʉ̃ ĩgʉ̃sãrẽ duripíri sãrĩrõ makãpʉrore ñajãgʉ̃ irirosũ iribino, yajarimasʉ̃ ããrĩkumi. Makãpʉro marĩrõgue ñajãkumi. ");
INSERT INTO sri_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Makãpʉro ñajãgʉ̃ gapʉ oveja korerimasʉ̃ ããrĩkumi. ");
INSERT INTO sri_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Makãpʉrore koregʉ tũpãkumi, oveja korerimasʉ̃rẽ ñajãridoregʉ. Oveja korerimasʉ̃ ñajãmakʉ̃, oveja ĩgʉ̃ werenímakʉ̃ pékuma. Ĩgʉ̃yarãrẽ ĩgʉ̃sã wãĩ merã oekumi. Irasũ oegʉ, ĩgʉ̃sãrẽ siiu wiukumi. ");
INSERT INTO sri_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ĩgʉ̃yarã ããrĩpererãrẽ oe, siiu wiu odo, ĩgʉ̃sãrẽ dupiyuwãgãkumi. Oveja ĩgʉ̃ werenírĩrẽ masĩrã ããrĩsĩã, ĩgʉ̃rẽ tʉyakuma. ");
INSERT INTO sri_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Gajigʉre ĩgʉ̃sã ĩãmasĩbire tʉyabirikuma. Ĩgʉ̃ werenírĩrẽ masĩmerã ããrĩsĩã, ĩgʉ̃rẽ güi ũmaduriwãgãkõãkuma. ");
INSERT INTO sri_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús iri keori merã ĩgʉ̃sãrẽ weremakʉ̃ pérã gapʉ pémasĩbirima. “Ãsũ ãrĩdʉaro irikoa i”, ãrĩmasĩbirima. ");
INSERT INTO sri_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Irasirigʉ Jesús ĩgʉ̃sãrẽ werenemomi doja: —Diayeta mʉsãrẽ werea. Yʉ ovejare duripíri sãrĩrõ makãpʉro irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ããrĩpererã ñerã yʉ dupiyuro aarinerã, yajarimasã irirosũ ããrĩ́ma. Yaarã oveja irirosũ ããrĩrã́ gapʉ ĩgʉ̃sãrẽ pébema. ");
INSERT INTO sri_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉ makãpʉro irirosũ ããrã. Yʉre bʉremurã iri makãpʉrore ñajãrã irirosũ ããrĩ́ma. Ĩgʉ̃sãrẽ peamegue waabonerãrẽ taugʉkoa. Oveja güiro marĩrõ ĩgʉ̃sãrẽ duripíri sãrĩrõ makãpʉrore ñajãrã, wirirã ĩgʉ̃sã baaburi bokarã irirosũ ããrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Yajarimasã ovejare yajamurã, wẽjẽmurã, poyanorẽmurã aaríma. Yʉ gapʉ ĩgʉ̃sãrẽ okarire opamakʉ̃ irigʉ aaribʉ́. Ããrĩpereri õãrĩrẽ opaburo, ãrĩgʉ̃, aaribʉ́. ");
INSERT INTO sri_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yʉ ovejare õãrõ koregʉ irirosũ ããrã. Ovejare õãrõ koregʉ wẽjẽsũbu ããrĩkeregʉ, ĩgʉ̃sãrẽ béobirikumi. Ĩgʉ̃sã õãrõ ããrĩburire boabosagʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Gajigʉ moãrĩmasʉ̃ gapʉ ĩgʉ̃ moãwajatari ditare gũñami. Ovejare õãrõ koregʉ irirosũ ããrĩbemi. Oveja ĩgʉ̃yarã ããrĩbema. Irasirigʉ makãnʉ́ʉmʉ diayée ovejare ñeã wẽjẽgʉ̃ aarimakʉ̃ ĩãgʉ̃, ovejare béo, güi ũmaduriwãgãkõãmi. Ĩgʉ̃sãrẽ béowãgãdero pʉrʉ, makãnʉ́ʉmʉ diayée ovejare ñeãmakʉ̃ ĩãrã, gajirã oveja ũmasiriwãgãkõãma. ");
INSERT INTO sri_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Moãrĩmasʉ̃ ĩgʉ̃ moãwajatari ditare gããmemi. Irasirigʉ ovejare ĩgʉ̃sã õãrõ ããrĩburire gũñabemi. ");
INSERT INTO sri_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Yʉ ovejare õãrõ koregʉ irirosũ ããrã. Yʉpʉ yʉre masĩmi. Yʉde Yʉpʉre masĩa. I irirosũ yaarã ovejare yʉ masĩa. Yaarãde yʉre masĩma. Irasirigʉ yʉ okarire maĩbea. Ĩgʉ̃sã õãrõ ããrĩburire boabosagʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Gajirã oveja gaji duripíri sãrĩrõ marã irirosũ ããrĩ́ma. Ĩgʉ̃sãde yaarã ããrĩ́ma. Ĩgʉ̃sãdere ãĩgʉkoa. Yʉ werenírĩrẽ pérãkuma. Irasirirã yaarã ããrĩpererã su buta ããrĩrãkuma. Yʉ sugʉta ĩgʉ̃sãrẽ koregʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Yaarã õãrõ ããrĩburire boabosagʉkoa. Yʉ okarire maĩbi ããrĩsĩã, irasirigʉkoa masã, dupaturi okabu. Yʉ irasiribu ããrĩmakʉ̃, Yʉpʉ yʉre maĩmi. ");
INSERT INTO sri_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yʉ gããmebirimakʉ̃, neõ sugʉ yʉre boamakʉ̃ irimasĩbiribukumi. Yʉ gããmerõ merã boagʉkoa. Yʉ turaro merã yʉ gããmerĩrẽ irimasĩgʉ̃ ããrĩsĩã, yʉ gããmerõ merã boa, pʉrʉ masãgʉkoa. Yʉpʉ yʉre irireta iridoremi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, judío masaka dupaturi surosũ ĩgʉ̃rẽ gũñabirisĩã, dʉkawarima. ");
INSERT INTO sri_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gajirã wárã ĩgʉ̃sã merãmarãrẽ ĩgʉ̃yamarẽ ãrĩma: —Ĩgʉ̃ wãtĩ ñajãsũdi, niãsũgʉ̃ yámi. ¿Nasirirã ĩgʉ̃rẽ péri mʉsã? ");
INSERT INTO sri_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gajirã gapʉ ãrĩma: —Wãtĩ ñajãsũdi, ĩgʉ̃ irirosũ õãrõ wereníbiribukumi. Koye ĩãmasĩbidere ĩãmakʉ̃ irimasĩbiribukumi, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Puibʉ ããrĩmakʉ̃, Jerusalẽ́gue judío masaka bosenʉ irima. Iripoegue marã Marĩpʉya wiire iripeodeare gũñarĩ bosenʉ ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iri bosenʉrẽ Jesús, Pórtico de Salomón wãĩkʉri taribu Marĩpʉya wii tʉro biaña marĩrĩ taribugue waagorenami. ");
INSERT INTO sri_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Irogue ĩgʉ̃ ããrĩmakʉ̃ ĩãrã, judío masaka oparã ĩgʉ̃ pʉro nerẽ, ĩgʉ̃rẽ sẽrẽñama: —¿Naásũ ããrĩmakʉ̃ gʉare õãrõ diaye weregʉkuri? ¿Mʉ Cristo, Marĩpʉ iriudita ããrĩ́rĩ? ");
INSERT INTO sri_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús ĩgʉ̃sãrẽ yʉjʉmi: —Mʉsãrẽ weresiabʉ. Mʉsã gapʉ yʉ wererire bʉremubea. Yʉ, Yʉpʉ yʉre dorerosũta ĩgʉ̃ turari merã iri ĩmurĩrẽ irinagʉ̃ yáa. I merã yʉ ããrĩrikʉrire masĩsũa. ");
INSERT INTO sri_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yʉ ĩgʉ̃ turari merã iri ĩmurĩrẽ ĩãkererã, mʉsã gapʉ yʉre bʉremubea. Mʉsã yaarã ããrĩbirisĩã, yʉre bʉremubea. Yʉ dupiyuro werederosũta mʉsã gajigʉyarã oveja irirosũ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yaarã oveja yʉ werenírĩrẽ masĩma. Yʉ ĩgʉ̃sãrẽ masĩa. Irasirirã yʉre tʉyama. ");
INSERT INTO sri_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yʉ ĩgʉ̃sãrẽ ʉ̃mʉgasigue perebiri okari opamakʉ̃ yáa. Irasirirã perebiri peamegue neõ waabirikuma. Yʉ ĩgʉ̃sãrẽ korea. Gajirã ĩgʉ̃sãrẽ neõ yʉre ẽmamasĩbema. ");
INSERT INTO sri_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yʉpʉ ĩgʉ̃sãrẽ yʉre sĩdi ããrĩmí. Ĩgʉ̃ ããrĩpererã nemorõ turagʉ ããrĩ́mi. Ĩgʉ̃de ĩgʉ̃sãrẽ koremi. Gajirã ĩgʉ̃sãrẽ neõ ĩgʉ̃dere ẽmamasĩbema. ");
INSERT INTO sri_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉ, Yʉpʉ merã sugʉta ããrã, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, dupaturi judío masaka ʉ̃tãyeri ãĩma, ĩgʉ̃rẽ dea wẽjẽdʉarã. ");
INSERT INTO sri_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ĩgʉ̃sã irasiridʉamakʉ̃ ĩãgʉ̃, Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉ, Yʉpʉ yʉre dorederosũta wári ĩgʉ̃ turari merã iri ĩmurĩrẽ iribʉ. Mʉsã irire ĩãbʉ. ¿Ñeéno yʉ iridea waja mʉsã yʉre ʉ̃tãyeri merã dea wẽjẽdʉari? ");
INSERT INTO sri_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ĩgʉ̃sã ĩgʉ̃rẽ ãrĩma: —Mʉ õãrõ iriri waja gʉa mʉrẽ ʉ̃tãyeri merã dea wẽjẽdʉabea. Mʉ Marĩpʉre ñerõ werenírĩ waja mʉrẽ ʉ̃tãyeri merã dea wẽjẽdʉáa. Mʉ masakʉ ããrĩkeregʉ: “Marĩpʉ ããrã yʉ”, ãrĩ werenía. ");
INSERT INTO sri_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Jesús ĩgʉ̃sãrẽ ãrĩmi: —Marĩpʉ ãsũ ãrĩdi ããrĩmí ĩgʉ̃ mʉsãrẽ doreri gojadea pũgue: “Mʉsã yʉ irirosũ ããrã”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Marĩ ire masĩa. Marĩpʉ ĩgʉ̃ya werenírĩ gojadea pũgue ãrĩrĩ diayeta ããrã. Marĩrẽ neõ irire: “Diaye ããrĩbea”, ãrĩ masĩña máa. Irasiriro iri pũguere ĩgʉ̃ya kerere pérãrẽ: “Yʉ irirosũ ããrĩ́ma”, ãrĩrĩ diayeta ããrã. ");
INSERT INTO sri_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Marĩpʉ yʉre beyesĩã, i ʉ̃mʉguere iriumi. Irasũ ããrĩkeremakʉ̃: “Yʉ Marĩpʉ magʉ̃ ããrã”, ãrĩdea waja mʉsã gapʉ yʉre: “Marĩpʉre ñerõ wereními”, ãrã. ¿Nasirirã yʉre irasũ ãrĩrĩ mʉsã? ");
INSERT INTO sri_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉpʉ yʉre dorerosũta ĩgʉ̃ turari merã yʉ iri ĩmubirimakʉ̃ ĩãrã, yʉ wereri gapʉre bʉremubirikõãka! ");
INSERT INTO sri_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yʉpʉ yʉre dorerosũta yʉ iri ĩmumakʉ̃ ĩãrã, yʉ wererire bʉremubirikererã, yʉ iriri gapʉre: “Marĩpʉ turari merã iriri ããrã”, ãrĩ bʉremuka! Mʉsã irire ãrĩ bʉremurã, Yʉpʉ yʉguere õãrõ ããrĩrĩ́rẽ, irasũ ããrĩmakʉ̃ yʉ ĩgʉ̃ merã sugʉta ããrĩrĩ́rẽ masĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃rẽ peresu iridʉarã ñeãdʉarã iriadima doja. Ĩgʉ̃ gapʉ ĩgʉ̃sãrẽ duriwiriakõãmi. ");
INSERT INTO sri_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wiria, Juan masakare wãĩyepʉroriderogue dia Jordán wãĩkʉdiya gaji koepʉgue dupaturi waa, irogue dujami. ");
INSERT INTO sri_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Masaka wárã ĩgʉ̃rẽ ĩãrã ejama. Ãsũ ãrĩma: —Juan masakare wãĩyedi Marĩpʉ turari merã iririre iri ĩmubirikeregʉ, ããrĩpereri Jesúyamarẽ weredea diayeta ããrã, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Irasirirã wárã iroguere Jesúre bʉremuma. ");
INSERT INTO sri_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Iripoere Betania wãĩkʉri makãmʉ Lázaro wãĩkʉgʉ pũrĩrikʉgʉ iriyupʉ. Iri makã, ĩgʉ̃ tĩ́rã nome María, Marta wãĩkʉrãya makã ããrĩbʉ́. María marĩ Opʉ Jesúya gubure sʉ̃rõrĩ merã piupeo, igo poari merã túkoebo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro pũrĩrikʉmakʉ̃ ĩãrã, ĩgʉ̃ tĩ́rã nome gajirã merã Jesúre kere iriuñurã: —Gʉa Opʉ, mʉ maĩgʉ̃ pũrĩrikʉgʉ yámi, ãrĩ kere iriuñurã. ");
INSERT INTO sri_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús iri kerere pégʉ, ãrĩmi: —Iri pũrĩrĩ ĩgʉ̃rẽ boamakʉ̃ iriburi ããrĩbea. Iri merã Marĩpʉ masakare ĩgʉ̃ turarire ĩmugʉkumi. Ĩgʉ̃ irire ĩmugʉ̃, yʉ ĩgʉ̃ magʉ̃ ããrĩrĩ́rẽ, ĩgʉ̃ turari opagʉ ããrĩrĩ́dere ĩmugʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Irasirigʉ Jesús Martare, igo pagʉmorẽ, Lázarore bʉro maĩsĩã, Lázaro pũrĩrikʉri kere péadero pʉrʉ, penʉ ĩgʉ̃ ããrĩrṍguere dujanemomi. ");
INSERT INTO sri_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Penʉ pʉrʉ gʉare ĩgʉ̃ buerãrẽ ãrĩmi: —Náka, dupaturi Judea nikũgue waarã́ doja! ");
INSERT INTO sri_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Gʉa ĩgʉ̃rẽ ãrĩbʉ: —Buegʉ, irinʉgue marĩ irogue ããrĩmakʉ̃, judío masaka mʉrẽ ʉ̃tãyeri merã dea wẽjẽdʉama. ¿Nasirigʉ mʉ irogue dupaturi waadʉari? ");
INSERT INTO sri_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Gʉa irasũ ãrĩmakʉ̃, Jesús keori merã gʉare ãsũ ãrĩ weremi: —Sunʉrẽ pe mojõma pere su gubu peru pẽrẽbejari horagora ããrã. Irasirirã, i ʉ̃mʉguere sĩãgori ããrĩyumakʉ̃, iri boyori merã masaka noó waaró waarã́, gubutʉabirikuma. ");
INSERT INTO sri_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ñami merã sĩãgori marĩrõ waarã́ gapʉ gubutʉama. ");
INSERT INTO sri_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ĩgʉ̃ irire ãrĩ odo, gʉare ãrĩmi: —Marĩ merãmʉ Lázaro kãrĩakõãmi. Yʉ ĩgʉ̃rẽ yobegʉ waagʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Gʉa ĩgʉ̃rẽ ãrĩbʉ: —Gʉa Opʉ, Lázaro kãrĩmakʉ̃, ĩgʉ̃ sĩrĩrĩ tarirokoa, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús: “Kãrĩakõãmi”, ãrĩgʉ̃, ĩgʉ̃ kõmoadeare weregʉ iridi ããrĩmí. Gʉa gapʉ: “Ĩgʉ̃ kãrĩrĩrẽ weremi”, ãrĩ gũñadibʉ. ");
INSERT INTO sri_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Irasirigʉ Jesús pémasĩma õãrõ gʉare weremi: —Lázaro boakõãmi. ");
INSERT INTO sri_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yʉ ʉsʉyáa, yʉ marĩrõ boami. Ĩgʉ̃ boari merã mʉsã yʉre bʉremunemorãkoa. Náka, marĩ ĩgʉ̃rẽ ĩãrã! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jesús irire ãrĩmakʉ̃ pégʉ, Tomás “Sʉdʉadi” ĩgʉ̃sã ãrĩgʉ̃ gʉare ãrĩmi: —Marĩ Jesús merã waarã́! Ĩgʉ̃ irogue boamakʉ̃, marĩde ĩgʉ̃ merãta boakõãrã! ");
INSERT INTO sri_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús Betaniague ejamakʉ̃, iro marã ĩgʉ̃rẽ werema: —Wapikʉrinʉ taria, Lázaro dagʉre ĩgʉ̃sã yáadero pʉrʉ, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania, Jerusalén pʉrogã, pe kilómetro gaji kilómetro deko yoaro ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Irasirirã judío masaka wárã Lázaro boadea kerere pérã, Marta, Maríare ĩãrã waañurã, ĩgʉ̃sãrẽ ĩã gũñaturaburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús ĩgʉ̃sã pʉro ejaburi kerere pégo, Marta ĩgʉ̃rẽ bokatĩrĩgõ aarimó. María gapʉ wiigueta dujakõãdeo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesús pʉro ejago, ĩgʉ̃rẽ ãrĩmo: —Yʉ Opʉ, mʉ õõgue ããrĩmakʉ̃, yʉ pagʉmʉ boabiriboadi ããrãmi. ");
INSERT INTO sri_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yʉ masĩa. Mʉ Marĩpʉre sẽrẽmakʉ̃, ããrĩpereri mʉ sẽrẽrõsũta irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús igore ãrĩmi: —Mʉ pagʉmʉ dupaturi okagʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Igo ĩgʉ̃rẽ ãrĩmo: —Yʉ masĩa. I ʉ̃mʉ peremakʉ̃ ããrĩpererã boanerã masãmakʉ̃, ĩgʉ̃de dupaturi okagʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Igo irasũ ãrĩmakʉ̃, Jesús ãsũ ãrĩmi: —Yʉ boanerãrẽ masãmakʉ̃ irigʉ, ĩgʉ̃sãrẽ okari sĩgʉ̃ ããrã. Yʉre bʉremugʉ̃ boadigue ããrĩkeregʉ, okagʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Irasirirã okarã yʉre bʉremurãno neõ boabirikuma. ¿Mʉ ire bʉremurĩ? ");
INSERT INTO sri_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Igo ĩgʉ̃rẽ ãrĩmo: —Yʉ Opʉ, mʉrẽ bʉremua. Mʉ, Cristo Marĩpʉ magʉ̃, i ʉ̃mʉgue aarigʉkumi, ĩgʉ̃sã ãrĩdi ããrã. ");
INSERT INTO sri_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta irasũ ãrĩ odo, igo pagʉmo Maríare siiugo waamo. Gajirã péberogã igore ãsũ ãrĩyupo: —Marĩrẽ buegʉ ejasiami. Mʉrẽ siiuami. ");
INSERT INTO sri_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Igo irasũ ãrĩmakʉ̃ pégo, mata María ĩgʉ̃ pʉrogue mumurõ merã aarimó. ");
INSERT INTO sri_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús makãgue ejabirimi dapa. Marta ĩgʉ̃rẽ bokatĩrĩaderogueta ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judío masaka wiigue Maríare ĩã gũñaturaburo, ãrĩrã, igo merã ããrãnerã, igo mumurõ merã waamakʉ̃ ĩãrã, igore tʉyawãgãñurã. “Igo pagʉmʉ yáa masãgobegue orego waagó irikumo”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María Jesús pʉrogue ejago, ĩgʉ̃rẽ ĩã, ĩgʉ̃ guburi pʉro ñadʉkʉpuri merã ejamejã: —Yʉ Opʉ, mʉ õõgue ããrĩmakʉ̃, yʉ pagʉmʉ boabiriboadi ããrãmi, ãrĩmo. ");
INSERT INTO sri_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","34","Igo, igore tʉyanerã merã oremakʉ̃ ĩãgʉ̃, Jesús bʉro bopoña, bʉjawereri merã ĩgʉ̃sãrẽ ĩã: —¿Noógue ĩgʉ̃rẽ yáari mʉsã? ãrĩ sẽrẽñami. Ĩgʉ̃sã ĩgʉ̃rẽ ãrĩma: —Gʉa Opʉ, ĩãgʉ̃ aarika! ");
INSERT INTO sri_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús oremi. ");
INSERT INTO sri_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ĩgʉ̃ oremakʉ̃ ĩãrã, judío masaka ãrĩma: —Ĩãka! Noópagora ĩgʉ̃rẽ maĩayuriye! ");
INSERT INTO sri_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gajirã ĩgʉ̃sã merãmarã gapʉ ãrĩma: —Koye ĩãmasĩbire ĩãmakʉ̃ iridi ããrĩ́mi. ¿Lázaro boaburi dupiyuro ĩgʉ̃rẽ ĩãgʉ̃ taukõãboayuri? ");
INSERT INTO sri_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús bʉro bʉjawereri merã masãgobe pʉro waami. Iri gobe ʉ̃tãtore ããrĩbʉ́. Iri gobe ñajãrõrẽ wári majĩ ʉ̃tã majĩ merã biasũbʉ. ");
INSERT INTO sri_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús ãrĩmi: —Ʉ̃tã majĩrẽ ãĩ weanúka! Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, Marta boadi tĩ́gõ ãrĩmo: —Yʉ Opʉ, ĩgʉ̃ya dʉpʉ daro ʉ̃rĩasiakuyo. Wapikʉrinʉ tarisiáa, ĩgʉ̃ boadero pʉrʉ. ");
INSERT INTO sri_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús gapʉ igore ãrĩmi: —Mʉrẽ wereabʉ: “Yʉre bʉremugõ Marĩpʉ turarire ĩãgokoa”, ãrãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ĩgʉ̃ irasũ ãrĩ odomakʉ̃, ĩgʉ̃sã ʉ̃tã majĩrẽ ãĩ weanúma. Jesús ʉ̃mʉgasigue ĩãmu, Marĩpʉre ãsũ ãrĩmi: —Aʉ, yʉ sẽrẽrĩrẽ mʉ pésiabʉ. Irasirigʉ mʉrẽ: “Õãa”, ãrĩ, ʉsʉyari sĩa. ");
INSERT INTO sri_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yʉ masĩa. Yʉ mʉrẽ sẽrẽrĩrẽ irasũ péníkõãa. Yʉ irire masĩkeregʉ, õõ nírã yʉ mʉ iriudi ããrĩrĩ́rẽ masĩburo, ãrĩgʉ̃, ĩgʉ̃sã péurogue mʉrẽ: “Yʉ sẽrẽrĩrẽ mʉ pésiabʉ”, ãrĩ werea. ");
INSERT INTO sri_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Irasũ ãrĩ odo, Jesús bʉro bʉsʉro merã ãrĩmi: —Lázaro, irore wirika! ");
INSERT INTO sri_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, masãgobegue wiririmi. Ĩgʉ̃ya mojõrĩ, guburire surí gasiri merã dʉrasũdi, ĩgʉ̃ya diapure suríro gasiro merã õmasũdi ããrĩmí. Irasirigʉ Jesús ĩgʉ̃sãrẽ: —Kuranoka ĩgʉ̃ waamakʉ̃! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wárã judío masaka María merã masãgobegue wapikʉnerã Jesús iriadeare ĩãrã, ĩgʉ̃rẽ bʉremuma. ");
INSERT INTO sri_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gajirã ĩgʉ̃sã merãmarã gapʉ fariseo bumarã pʉrogue waa, Jesús iriadeare ĩgʉ̃sãrẽ wereñurã. ");
INSERT INTO sri_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Irasirirã fariseo bumarã, irasũ ããrĩmakʉ̃ paía oparã gajirã judío masaka oparã merã nerẽ, ãsũ ãrĩ wereníñurã: —¿Nasirirãkuri marĩ? Jesús wári turari merã iri ĩmugʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Marĩ ĩgʉ̃rẽ: “Iropata irika!” ãrĩbirimakʉ̃, ããrĩpererã masaka ĩgʉ̃rẽ bʉremurãkuma. Irasirirã romano marã oparã aarirãkuma, Marĩpʉya wiire béo, marĩrẽ marĩya nikũrẽ ẽmamurã, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sugʉ ĩgʉ̃sã merãmʉ, Caifás wãĩkʉgʉ iri bojorire paía opʉ ããrĩmí. Ĩgʉ̃sã irire irasũ ãrĩmakʉ̃ pégʉ, ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã irima ããrĩpererire neõ masĩbea. ");
INSERT INTO sri_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ire pémasĩbea. Sugʉta marĩ judío masakaya ããrĩburire boabosamakʉ̃ õãrokoa. Ĩgʉ̃ boabirimakʉ̃, marĩ ããrĩpererã judío masaka gapʉ pereakõãbukoa. ");
INSERT INTO sri_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ĩgʉ̃ Jesús judío masakaya ããrĩburire boabosaburire weregʉ, ĩgʉ̃ basi gũñarĩ merã irasũ ãrĩbiriyupʉ. Iri bojorire ĩgʉ̃ paía opʉ ããrĩmakʉ̃, Marĩpʉ ĩgʉ̃rẽ irire ãrĩmakʉ̃ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesús boagʉ, judío masakaya ããrĩburire, irasũ ããrĩmakʉ̃ ããrĩpererã Marĩpʉ pũrã ããrĩperero ããrĩrã́dere ĩgʉ̃sãya ããrĩburidere boami, su buta ããrĩburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifás ĩgʉ̃sãrẽ irasũ ãrãdero pʉrʉ: “¿Nasiri Jesúre wẽjẽrãkuri marĩ?” ãrĩ werenírã iriñurã. ");
INSERT INTO sri_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesús, ĩgʉ̃sã ĩgʉ̃rẽ wẽjẽdʉarire masĩkõãmi. Irasirigʉ judío masaka oparã ĩũrõgue neõ waagorenabirimi. Judea nikũma makã, masaka marĩrõ pʉro ããrĩrĩ́ makã Efraín wãĩkʉri makãgue waakõãmi. Irogue gʉa ĩgʉ̃ buerã merã dujami. ");
INSERT INTO sri_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iripoere pascua bosenʉ gʉa judío masaka bosenʉ ããrĩburo mérõgã dʉyabʉ. Irasirirã bosenʉ dupiyuro masaka wárã gaji makãrĩ marãde Jerusalẽ́gue iri bosenʉmarẽ baaburo dupiyuro Marĩpʉ dorederosũta koerã waama ĩgʉ̃ ĩgʉ̃sãrẽ: “Ñerĩ opamerã, õãrã ããrĩ́ma”, ãrĩ ĩãburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ĩgʉ̃sã irogue ejarã, Jesúre ãmagorenañurã. Marĩpʉya wiigue ããrĩrã́, ãsũ ãrĩ gãme wereníñurã: —¿Naásũ gũñarĩ? ¿Bosenʉrẽ ĩãgʉ̃ aarigʉkuri, o aaribirikuri? ");
INSERT INTO sri_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Paía oparã, fariseo bumarã masakare doreñurã. Ãsũ ãrĩñurã: —Jesús ããrĩrṍrẽ masĩrã, gʉare wereka! Ĩgʉ̃rẽ ñeã, peresu iridʉarã irasũ ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Su mojõma pere gaji mojõ suru pẽrẽbejarinʉrĩ pascua bosenʉ waaburi dupiyuro Jesús Betaniague waami. Iri makã, Lázaro boadiguere Jesús masũdiya makã ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Irogue Jesúre bosenʉ iripeoma. Marta baarire gueremo. Lázaro ĩgʉ̃ merã baa doami. Gʉade ĩgʉ̃sã merã baabʉ. ");
INSERT INTO sri_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Gʉa ĩgʉ̃sã merã baaripoe María suru sʉ̃rõdiru wádiru su litro deko opadirure Jesús pʉro ãĩja, ĩgʉ̃ya guburire piupeomo. Iri sʉ̃rõrĩ “nardo” wãĩkʉri sʉ̃rõrĩ, gajino merã morẽña marĩrĩ, wajapari sʉ̃rõrĩ ããrĩyuro. Irire piupeo odo, igoya poañapu merã ĩgʉ̃ya guburire túkoemo. Iri wii ããrĩperero sʉ̃rõseyakõãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Igo irasirimakʉ̃ ĩãgʉ̃, gʉa Jesús buerã watopemʉ Jesúre wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmubu Judas Iscariote ãsũ ãrĩmi: ");
INSERT INTO sri_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Nasirigo i sʉ̃rõrĩrẽ duabirari? Irire duago, trescientos nʉrĩ moãdea wajare wajataropa wajataboakuyo. Irasirigo iri niyerure boporãrẽ sĩboakuyo, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yajarikʉsĩã, irasũ ãrĩmi. Boporãrẽ iritamudʉagʉ meta ããrĩmí. Ĩgʉ̃ gʉaya niyeru ajurore koregʉ ããrĩmí. Iri ajurogue gʉa niyeru duripírire yajanokõãmi. ");
INSERT INTO sri_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús ĩgʉ̃rẽ ãrĩmi: —Iropata ãrĩka! Igo iri sʉ̃rõrĩ duripíadeare yʉre piupeogo, ĩgʉ̃sã yʉre yáaburi dupiyuro iriburire irasũ yámo. ");
INSERT INTO sri_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Boporã mʉsã merã ããrĩníkõãrãkuma. Yʉ gapʉ mʉsã pʉro ããrĩníbirikoa. ");
INSERT INTO sri_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesús Betaniague ããrĩrĩ́ kerere pérã, judío masaka wárã irogue ĩgʉ̃rẽ ĩãrã aarirã́, ĩgʉ̃ ditare ĩãrã aaribirima. Lázaro boadiguere Jesús masũdidere ĩãrã aarimá. ");
INSERT INTO sri_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Jesús ĩgʉ̃rẽ masũmakʉ̃ ĩãdero pʉrʉ, wárã judío masaka paía oparã bueri gapʉre tʉyanemobiri, Jesúre bʉremupʉroriñurã. Irasirirã paía oparã Jesúre wẽjẽdʉarosũta Lázarodere wẽjẽdʉañurã. ");
INSERT INTO sri_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Gajinʉ gapʉ wárã masaka Jerusalẽ́gue pascua bosenʉrẽ ĩãrã ejanerã, Jesús irogue waaburi kerere péñurã. ");
INSERT INTO sri_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Irasirirã beje pũ diti ãĩwãgã, ĩgʉ̃rẽ ãsũ ãrĩ gaguiní bokatĩrĩrã aarimá: —Marĩ Opʉre ʉsʉyari sĩrã! Ĩĩ Marĩpʉ marĩrẽ taugʉ iriudi õãrõ aariburo. Ĩgʉ̃ marĩ Israel bumarã Opʉta ããrĩ́mi, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús burrore bokaja, ĩgʉ̃ weka mʉrĩbejami. Irasirigʉ Marĩpʉya werenírĩ gojadea pũgue ãrĩderosũta irimi. Ãsũ ãrĩ gojasũdero ããrĩbʉ́: ");
INSERT INTO sri_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalén marã güibirikõãka! Ĩãka! Mʉsã Opʉ burro weka peyawãgãrimi, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Gʉa ĩgʉ̃ buerã iri gojadeare pémasĩbiribʉ. “Dapagora Jesús iri gojaderosũta irigʉ yámi”, ãrĩ gũñabiribʉ. Ʉ̃mʉgasigue ĩgʉ̃ mʉrĩadero pʉrʉ, iri gojadeare gũñaboka, pémasĩbʉ. “Marĩpʉya werenírĩ gojadea pũgue ãrĩderosũta Jesúre waabʉ”, ãrĩ gũñabʉ. ");
INSERT INTO sri_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús Lázarore ĩgʉ̃sã yáadea gobere wiridore, ĩgʉ̃rẽ masũmakʉ̃ ĩãnerã gajirãrẽ ĩgʉ̃sã ĩãdeare wererã irima. ");
INSERT INTO sri_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Irasirirã wárã masaka Lázarore Jesús masũdea kerere pénerã ããrĩsĩã, Jesúre bokatĩrĩrã aarimá. ");
INSERT INTO sri_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ĩgʉ̃sã irasirimakʉ̃ ĩãrã, fariseo bumarã ĩgʉ̃sã basi ãsũ gãme ãrĩ wereníñurã: —Ĩãka! Ããrĩpererã ĩgʉ̃ merã dita waarã́ yáma. Marĩ neõ ĩgʉ̃sã iririre kãmutamasĩbea. ");
INSERT INTO sri_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jerusalẽ́gue pascua bosenʉ ããrĩmakʉ̃, Marĩpʉre bʉremurã ejanerã watopere surãyeri griego masaka ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ĩgʉ̃sã Jesúre ĩãdʉarã, Felipere wererã aarimá. Felipe Betsaida wãĩkʉri makãmʉ ããrĩmí. Betsaida, Galilea nikũgue ããrĩrĩ́ makã ããrĩbʉ́. Ãsũ ãrĩma ĩgʉ̃rẽ: —Jesúre ĩãdʉakoa gʉa. ");
INSERT INTO sri_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Felipe Andrére weregʉ waami. Irasirirã ĩgʉ̃sã pẽrãgueta Jesúre wererã waama. ");
INSERT INTO sri_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús, griego masaka ĩgʉ̃rẽ ĩãdʉarire pégʉ, gʉare ãrĩmi: —Mérõgã dʉyáa yʉ ããrĩpererã tĩ́gʉ̃ boa, masã, ʉ̃mʉgasigue mʉrĩaburo. ");
INSERT INTO sri_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Diayeta mʉsãrẽ werea. Oteri yere otebirimakʉ̃, suyeta dujarokoa. Iri yere otedero pʉrʉ, yeba poekague boa, pʉrʉ puri wiri, wári dʉka sĩkoa. ");
INSERT INTO sri_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Sugʉ ĩgʉ̃ i ʉ̃mʉgue okarire maĩgʉ̃no, perebiri peamegue waagʉkumi. Ĩgʉ̃ i ʉ̃mʉgue okarire maĩbi gapʉ ʉ̃mʉgasigue perebiri okari opagʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yʉ dorerire iridʉagʉ, yʉre tʉyaburo. Yʉre tʉyagʉ, yʉ ããrĩburoguere yʉ merã ããrĩgʉkumi. Yʉpʉ yʉ dorerire irigʉre: “Õãrõ irigʉ yámi”, ãrĩ, ĩgʉ̃rẽ õãrõ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Dapagorare yʉ bʉro bʉjawereri merã ããrã. ¿Naásũ ãrĩgʉkuri? “Aʉ, yʉ ñerõ tariburore tauka!” ¿ãrĩgʉkuri? Irire ãrĩbea. Ñerõ taributa i ʉ̃mʉguere aaribʉ́, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Irasũ ãrĩ odo, ĩgʉ̃ Pagʉre: “Aʉ, mʉ turagʉ ããrĩrĩ́rẽ masakare ĩmuka!” ãrĩmi. Ĩgʉ̃ irasũ ãrĩmakʉ̃, Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ werenírĩrẽ pébʉ. Ãsũ ãrĩmi: —Yʉ turagʉ ããrĩrĩ́rẽ masakare ĩmusiabʉ. Irire dupaturi ĩmugʉra doja. ");
INSERT INTO sri_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Masaka irogue ããrĩrã́ ĩgʉ̃ werenírĩrẽ pérã, ãrĩma: —Bupu bʉsʉkumi. Gajirã ãrĩma: —Marĩpʉre wereboegʉ Jesúre wereníami. ");
INSERT INTO sri_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús gapʉ ãsũ ãrĩmi: —Yʉpʉ irire werenígʉ̃, yʉre pédoregʉ meta wereníami. Mʉsã gapʉre pédoregʉ wereníami. ");
INSERT INTO sri_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Dapagorare waarí merã, i ʉ̃mʉ marã ĩgʉ̃sã ñerĩ iridea waja wajamoãsũrãkuma. Irasũ ããrĩmakʉ̃, ñegʉ̃ i ʉ̃mʉ marãrẽ doregʉ béosũgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Curusague ĩgʉ̃sã yʉre pábiatú, ãĩwãgũnúmakʉ̃, ããrĩpererã masakare siiugʉkoa, yʉ merã ããrĩburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Irasũ ãrĩgʉ̃, ĩgʉ̃ curusague boaburire weregʉ irimi. ");
INSERT INTO sri_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ĩgʉ̃ ãrĩrĩrẽ pérã, masaka ĩgʉ̃rẽ ãrĩma: —Marĩpʉya werenírĩ gojadea pũgue ĩgʉ̃sã bue ĩmumakʉ̃ pébʉ. “Marĩpʉ iriudi Cristo okaníkõãgʉkumi”, ãrĩ bue ĩmuma. ¿Nasirigʉ mʉ gapʉ: “Ããrĩpererã tĩ́gʉ̃rẽ curusague pábiatú, ãĩwãgũnúrãkuma”, ãrĩrĩ? ¿Noã ããrĩ́rĩ ããrĩpererã tĩ́gʉ̃? ");
INSERT INTO sri_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Jesús ãrĩmi: —Yʉ masakare sĩãgori sĩgʉ̃ ããrã. Yoaweyaripoe mʉsã pʉrogue ããrĩgʉkoa dapa, Marĩpʉre masĩburo, ãrĩgʉ̃. Irasirirã sĩãgori merã õãrõ waamasĩrã irirosũ ããrĩka! Naĩtĩãrõgue waagorenagʉ̃no, ĩgʉ̃ waaburore neõ masĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yʉ mʉsãrẽ sĩãgori sĩgʉ̃ ããrĩgʉ̃́ mʉsã merã ããrã, Marĩpʉre masĩburo, ãrĩgʉ̃. Irasirirã, mʉsã merã yʉ ããrĩtũnuburo dupiyuro yʉre bʉremuka! Yʉre bʉremurã, boyorogue ããrĩrã́ irirosũ, yaarã ããrĩrãkoa. Irasũ ãrĩ odo, ĩgʉ̃sãrẽ duriwãgãkõãmi. ");
INSERT INTO sri_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús wári Marĩpʉ turari merã iri ĩmumakʉ̃ ĩãkererã, ĩgʉ̃rẽ bʉremubirima. ");
INSERT INTO sri_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Marĩpʉya werenírĩ gojadea pũgue Isaías gojaderosũta irima. Ãsũ ãrĩ gojadi ããrĩmí Isaías: Gʉa Opʉ, masaka gʉa mʉya kere wererire pékererã, bʉremubema. Mʉ turari merã mʉ iri ĩmurĩrẽ ĩãkererã: “Gʉa Opʉ iriri ããrã i”, ãrĩbema, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ĩgʉ̃sã Marĩpʉre bʉremumasĩbirideadere Isaías gajirogue Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","41","Marĩpʉ ĩgʉ̃sãrẽ koye ĩãmasĩmerã irirosũ ããrĩmakʉ̃ iridi ããrĩmí. Ĩgʉ̃yare pémasĩbirimakʉ̃ iridi ããrĩmí. Irasirirã ĩgʉ̃ turari merã iri ĩmurĩrẽ ĩãkererã, irire neõ ĩãmasĩbema. Ĩgʉ̃yare pékererã, irire neõ pémasĩbema. Ĩgʉ̃rẽ neõ bʉremudʉabema. Ĩgʉ̃rẽ bʉremumakʉ̃, ĩgʉ̃sãrẽ taubukumi, ãrĩ, Isaías Jesús turarire, ĩgʉ̃ gosesiririre ĩãdi ããrĩsĩã, irasũ ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gajirã Jesúre bʉremubirikeremakʉ̃, wárã judío masaka, ĩgʉ̃sã oparãgueta ĩgʉ̃rẽ bʉremuñurã. Irasũ bʉremukererã, fariseo bumarãrẽ güisĩã, gajirãrẽ Jesúre ĩgʉ̃sã bʉremurĩrẽ werebiriñurã. Fariseo bumarã ĩgʉ̃sãrẽ: “Neõ marĩ judío masaka nerẽrĩ wiigue ñajãnemobirikõãka!” ãrĩbukuma, ãrĩrã, irasiriñurã. ");
INSERT INTO sri_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Irasirirã Jesúre bʉremukererã, gajirã masaka, Marĩpʉ nemorõ ĩgʉ̃sãrẽ: “Õãrã ããrĩ́ma”, ãrĩmakʉ̃ gããmeñurã. ");
INSERT INTO sri_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús masaka péburo, ãrĩgʉ̃, bʉro bʉsʉro merã ãsũ ãrĩ weremi: —Yʉre bʉremugʉ̃ yʉ ditare bʉremubemi. Yʉpʉ yʉre iriudidere bʉremumi. ");
INSERT INTO sri_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yʉre ĩãgʉ̃, yʉre iriudidere ĩãmi. ");
INSERT INTO sri_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yʉ sĩãgori sĩgʉ̃ ããrĩgʉ̃́ i ʉ̃mʉguere yʉre bʉremurã yʉre iriudire masĩmerã irirosũ ããrĩbirikõãburo, ãrĩgʉ̃ aaribʉ́. Irasirirã naĩtĩãrõgue ããrĩrã́ irirosũ ããrĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yʉ wererire pékererã, irire irimerãrẽ yʉ wajamoãbirikoa. Yʉ i ʉ̃mʉguere masakare wajamoãgʉ̃ aaribiribʉ. Ubu gapʉ taugʉ aaribʉ́, ĩgʉ̃sã perebiri peamegue waabirikõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yʉre gããmemerã, yʉ wererire pédʉamerã wajamoãsũrãkuma. Ĩgʉ̃sãrẽ wajamoãbu, Yʉpʉ ããrĩ́mi. I ʉ̃mʉ peremakʉ̃, yʉ ĩgʉ̃ya werenírĩ wererire pébiridea waja ĩgʉ̃sãrẽ wajamoãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉ gããmerõ werebea. Yʉpʉ yʉre iriudi ĩgʉ̃ weredorerosũta werea. Ĩgʉ̃ yʉre buedorerosũta buea. ");
INSERT INTO sri_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yʉpʉ dorerosũta irigʉno, ʉ̃mʉgasigue perebiri okarire opagʉkumi. Irasirigʉ Yʉpʉ yʉre weredorerosũta mʉsãrẽ werea, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua bosenʉ waaburo mérõgã dʉyabʉ. Jesús i ʉ̃mʉrẽ wiri, ĩgʉ̃ Pagʉ pʉro waaburo mérõgã dʉyarire masĩsiami. Ĩgʉ̃yarã i ʉ̃mʉgue ããrĩrã́rẽ neõ maĩduúbirimi. Ĩgʉ̃sãrẽ bʉro maĩrĩrẽ ĩmuburo mérõgã dʉyabʉ. ");
INSERT INTO sri_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Wãtĩ Judare Simón Iscariote magʉ̃rẽ ĩgʉ̃ya gũñarĩgue Jesúre wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmudoresiadi ããrĩmí. Jesús ĩgʉ̃ Pagʉ pʉro merã aarideare, pʉrʉ ĩgʉ̃ irogue waaburire masĩmi. Marĩpʉ ĩgʉ̃ Pagʉ ããrĩpererãrẽ dorebure pídeadere masĩmi. Irasirigʉ gʉa ĩgʉ̃ buerã merã baa doaníadi, wãgãnʉgã, ĩgʉ̃ya suríro wekamañerẽ túwea, túkoeri gasiro merã ĩgʉ̃ya yʉjʉrure sʉami. ");
INSERT INTO sri_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sʉa odo, soropa merã deko piusã, gʉare ĩgʉ̃ buerãrẽ gʉaya guburire koenʉgãmi. Sugʉya guburire koe odo, ĩgʉ̃ sʉadea gasiro merã túkoemi. Gajirãya guburidere irasũ dita irimi. ");
INSERT INTO sri_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ĩgʉ̃ Simón Pedroya guburire koebu irimakʉ̃ ĩãgʉ̃, Pedro ĩgʉ̃rẽ ãrĩmi: —Yʉ Opʉ, ¿yaa guburire koeri mʉ? ");
INSERT INTO sri_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús ĩgʉ̃rẽ ãrĩmi: —Dapagora yʉ iririre mʉ pémasĩbea. Pʉrʉgue pémasĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro ĩgʉ̃rẽ ãrĩmi: —Yaa guburire mʉ neõ koebirikoa. Jesús ĩgʉ̃rẽ ãrĩmi: —Mʉrẽ yʉ koebirimakʉ̃, yaagʉ ããrĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Simón Pedro ĩgʉ̃rẽ ãrĩmi: —Yʉ Opʉ, yaa guburi ditare koebirikõãka! Yaa guburire koegʉ, yaa mojõrĩ, yaa dipurudere koeka! ");
INSERT INTO sri_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús ãsũ ãrĩmi: —Sugʉ masakʉ õãrõ guuadigue dupaturi guuabirikumi. Naagorena odoadero pʉrʉ, ĩgʉ̃ya guburi ditare koekumi. Ããrĩpererã mʉsã gʉrari marĩrã irirosũ ããrã. Irasũ ããrĩkeremakʉ̃, sugʉ mʉsã merãmʉ ñegʉ̃, gʉrarikʉgʉ irirosũ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús, Judas ĩgʉ̃rẽ wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmuburire masĩsiami. Irire masĩsĩã: “Sugʉ mʉsã merãmʉ ñegʉ̃, gʉrarikʉgʉ irirosũ ããrĩ́mi”, ãrĩgʉ̃ irimi. ");
INSERT INTO sri_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gʉaya guburire koe odo, ĩgʉ̃ya wekamañerẽ sãña, ĩgʉ̃ doaderogue dupaturi eja doaja, gʉare ãsũ ãrĩmi: —¿Yʉ mʉsãrẽ dapagora iririre pémasĩrĩ mʉsã? ");
INSERT INTO sri_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mʉsã yʉre: “Gʉare buegʉ, gʉa Opʉ ããrã”, ãrĩrã, keoro werea. Diayeta yʉ mʉsãrẽ buegʉ, mʉsã Opʉ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yʉ mʉsãrẽ buegʉ, mʉsã Opʉ ããrĩkeregʉ, mʉsãya guburire koeabʉ. Irasirirã mʉsãdere mʉsãya guburire gãme koero gããmea. ");
INSERT INTO sri_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mʉsã gãme iritamumakʉ̃ gããmegʉ̃, mʉsãrẽ irasiri ĩmuabʉ, yʉ mʉsãrẽ iriaderosũta iriburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Diayeta mʉsãrẽ werea. Neõ sugʉ moãboerimasʉ̃, ĩgʉ̃ opʉ nemorõ ããrĩbirikumi. Sugʉ iriusũdi, ĩgʉ̃rẽ iriudi nemorõ ããrĩbirikumi. ");
INSERT INTO sri_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mʉsã ire pémasĩrã, ire irirã, ʉsʉyari merã ããrĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Yʉ irire ãrĩgʉ̃, mʉsã ããrĩpererãrẽ ãrĩbea. Yʉ beyenerãrẽ masĩa. Marĩpʉya werenírĩ gojadea pũgue ãrĩderosũta keoro waarokoa. Ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Yʉ merã baagʉta yʉre ĩãturigʉ dujami”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","I waaburi dupiyuro yʉ mʉsãrẽ werea. Irasirirã yʉ weredea keoro waadero pʉrʉ: “Ĩgʉ̃ ããrã yʉ”, ãrĩdeare bʉremurãkoa. ");
INSERT INTO sri_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Diayeta mʉsãrẽ werea. Yʉ iriunerãrẽ õãrõ merã bokatĩrĩñeãgʉ̃no, yʉdere bokatĩrĩñeãmi. Yʉre õãrõ merã bokatĩrĩñeãgʉ̃, yʉre iriudidere bokatĩrĩñeãmi, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Irasũ ãrĩ odo, Jesús bʉro bʉjawereri merã ããrĩmí. Gʉare pémasĩma õãrõ ãsũ ãrĩ weremi: —Diayeta mʉsãrẽ werea. Sugʉ mʉsã merãmʉ yʉre wẽjẽdʉarãguere yʉre ĩmugʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa: “¿Noãrẽ irasũ ãrĩrĩ?” ãrĩrã, gãme ĩã oya doaníbʉ. ");
INSERT INTO sri_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yʉ Juan, Jesús buegʉ ĩgʉ̃ maĩsũgʉ̃, ĩgʉ̃ pʉrogã doabʉ. ");
INSERT INTO sri_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro ĩgʉ̃ya mojõ merã yʉre soepumi, Jesúre ĩgʉ̃ irasũ ãrĩrĩrẽ sẽrẽñadoregʉ. ");
INSERT INTO sri_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Irasirigʉ yʉ Jesús pʉrogã gãme doaweya, ĩgʉ̃rẽ sẽrẽñabʉ: —Yʉ Opʉ, ¿noã ããrĩ́rĩ ĩgʉ̃? ");
INSERT INTO sri_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús yʉre ãrĩmi: —Yʉ pã́rũrẽ moãwa, yosa, ĩgʉ̃rẽ sĩgʉkoa. Ĩgʉ̃ta ããrĩ́mi yʉre ĩmubu. Irasũ ãrĩ odo, pã́rũrẽ moãwa, yosa, Judare Simón Iscariote magʉ̃rẽ sĩmi. ");
INSERT INTO sri_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ire ñeãmakʉ̃, mata wãtĩ ĩgʉ̃guere ñajãdi ããrĩmí. Irasirigʉ Jesús Judare ãrĩmi: —Mʉ iriburire iripurumuka! ");
INSERT INTO sri_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jesús ĩgʉ̃rẽ irasũ ãrĩrĩrẽ pékererã, gʉa irogue baa doanírã irire pémasĩbiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Surãyeri gʉa ãsũ ãrĩ gũñabʉ: “Judas gʉa niyerure koregʉ ããrĩ́mi. Irasirigʉ Jesús ĩgʉ̃rẽ gʉa bosenʉ baaburire wajaridoregʉ iriuami, o boporãrẽ niyerure sĩdoregʉ iriuami”, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas iri pã́rũrẽ moãwa, yosadeare ñeã odogʉta gʉa pʉrogue ããrĩdi wiriakõãmi. Ĩgʉ̃ wiriaripoe ñamigue ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas waadero pʉrʉ, Jesús gʉare ãrĩmi: —Dapagora Marĩpʉ yʉ ããrĩpererã tĩ́gʉ̃ yʉ turagʉ ããrĩrĩ́rẽ masakare ĩmugʉkumi. Irasũ ããrĩmakʉ̃, yʉ merã ĩgʉ̃ turagʉ ããrĩrĩ́dere ĩmugʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yʉ merã ĩgʉ̃ turagʉ ããrĩrĩ́rẽ ĩmugʉ̃, yʉ turagʉ ããrĩrĩ́dere ĩmugʉkumi. Dapagorata iripurumugʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yaarã, yʉre péka! Yoaweyaripoeta mʉsã merã ããrĩgʉkoa. Mʉsã yʉre ãmarãkoa. Irasirigʉ yʉ judío masakare dupiyurogue ãrĩderosũta dapagora mʉsãdere: “Yʉ waaburore mʉsã waamasĩbea”, ãrĩ werea. ");
INSERT INTO sri_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Maama dorerire mʉsãrẽ pígʉra. Ãsũ ãrã. Gãme maĩka! Yʉ mʉsãrẽ maĩrõsũta gãme maĩka! ");
INSERT INTO sri_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mʉsã gãme maĩmakʉ̃ ĩãrã, ããrĩpererã masaka mʉsãrẽ yʉ buerã ããrĩrĩ́rẽ masĩrãkuma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro Jesúre sẽrẽñami: —Yʉ Opʉ, ¿noógue waagʉkuri mʉ? ãrĩmi. Jesús ĩgʉ̃rẽ ãrĩmi: —Yʉ dapagora waaburoguere mʉ yʉ merã waamasĩbea. Pʉrʉ yʉ pʉrogue waagʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ĩgʉ̃rẽ ãrĩmi: —Yʉ Opʉ, ¿nasiribu dapagorata yʉ mʉ merã waamasĩbirikuri? Ĩgʉ̃sã yʉre wẽjẽdʉakeremakʉ̃, yʉ mʉrẽ béobirikoa. Mʉya ããrĩburire boabosagʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús ĩgʉ̃rẽ ãrĩmi: —“Mʉya ããrĩburire boabosagʉkoa”, ãrã mʉ. ¿Ããrĩrṍta yʉre iribosagʉkuri? Diayeta mʉrẽ werea. Ãgãbo wereburo dupiyuro mʉ yʉre ʉrea gajirãrẽ: “Ĩgʉ̃rẽ masĩbea”, ãrĩgʉkoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús gʉare ãsũ ãrĩmi: —Bʉro gũñarikʉbirikõãka! Marĩpʉre bʉremuka! Yʉdere bʉremuka! ");
INSERT INTO sri_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉpʉ pʉroguere su wii wári taridupabu opari wii irirosũ ããrã. Irogue mʉsã ããrĩburore ãmuyugʉ waagʉkoa. Iri diaye ããrĩbirimakʉ̃, mʉsãrẽ irire werebiriboayo. ");
INSERT INTO sri_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mʉsã ããrĩburore ãmu odo, dupaturi aarigʉkoa mʉsãrẽ ãĩabu. Irasirirã mʉsãde yʉ pʉrogue yʉ merã ããrĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mʉsã yʉ waaburore, yʉ irogue waaburi maarẽ́ masĩa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás ĩgʉ̃rẽ ãrĩmi: —Gʉa Opʉ, mʉ waaburore masĩbea. ¿Nasiri mʉ waaburi maarẽ́ gʉa masĩrãkuri? ");
INSERT INTO sri_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús ĩgʉ̃rẽ ãrĩmi: —Yʉ dita Yʉpʉ pʉrogue waarí maa irirosũ ããrã. Yʉ diayema ããrĩrĩ́rẽ masakare masĩmakʉ̃ irigʉ, ĩgʉ̃sãrẽ okamakʉ̃ irigʉ ããrã. Yʉ merãta Yʉpʉ pʉrogue waarãkuma. ");
INSERT INTO sri_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mʉsã yʉre masĩrã, Yʉpʉdere masĩboayo. Dapagora merã ĩgʉ̃rẽ masĩsiáa. Ĩgʉ̃rẽ ĩãsiáa. ");
INSERT INTO sri_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Felipe ĩgʉ̃rẽ ãrĩmi: —Gʉa Opʉ, Marĩpʉre ĩmuka gʉare! Iropata gããmea gʉa. ");
INSERT INTO sri_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús ĩgʉ̃rẽ ãrĩmi: —Felipe, yʉ yoaripoe mʉsã merã ããrĩkeremakʉ̃, ¿yʉre masĩberi? Sugʉ yʉre ĩãgʉ̃no, Yʉpʉdere ĩãmi. ¿Nasirigʉ mʉ yʉre: “Marĩpʉre ĩmuka gʉare!” ãrĩrĩ? ");
INSERT INTO sri_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Yʉpʉ yʉguere ããrĩrĩ́rẽ, irasũ ããrĩmakʉ̃ yʉ ĩgʉ̃ merã ããrĩrĩ́rẽ bʉremuberi? Yʉ mʉsãrẽ weregʉ, yʉ gããmerõ werebea. Yʉpʉ yʉguere ããrĩgʉ̃́ yʉ merã iri ĩmugʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yʉ mʉsãrẽ: “Yʉpʉ yʉguere ããrĩ́mi, irasũ ããrĩmakʉ̃ yʉ ĩgʉ̃ merã ããrã”, ãrĩ wererire: “Diayeta ããrã”, ãrĩ bʉremuka! Mʉsã yʉ wererire pédero pʉrʉ bʉremumerã, Yʉpʉ turari merã yʉ iri ĩmurĩ gapʉre gũñaka! Irire gũñarã, yʉ wereridere bʉremuka! ");
INSERT INTO sri_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Diayeta mʉsãrẽ werea. Yʉre bʉremugʉ̃, yʉ iriderosũta irigʉkumi. Yʉ, Yʉpʉ pʉrogue waabu yáa. Yʉ waamakʉ̃, yʉre bʉremugʉ̃ yʉ nemorõ wári Yʉpʉ turari merã iri ĩmurĩrẽ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mʉsã yʉre bʉremumakʉ̃, ããrĩpereri mʉsã yʉ wãĩ merã yʉre sẽrẽrĩrẽ pégʉkoa. Irasirigʉ mʉsã yʉre sẽrẽrõsũta irigʉkoa. Yʉ irasiriri merã mʉsãrẽ Yʉpʉ turagʉ ããrĩrĩ́rẽ masĩmakʉ̃ irigʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mʉsã yʉ wãĩ merã yʉre sẽrẽrõsũta irigʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Mʉsã yʉre maĩrã, yʉ dorerire irirãkoa. ");
INSERT INTO sri_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yʉpʉre mʉsãya ããrĩburire sẽrẽbosagʉkoa. Irasirimakʉ̃, Yʉpʉ gajigʉre iriugʉkumi, mʉsãrẽ iritamuburo, ãrĩgʉ̃. Ĩgʉ̃ iriubu mʉsã merã ããrĩníkõãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ĩgʉ̃ Õãgʉ̃ deyomarĩgʉ̃ mʉsãrẽ diayemarẽ masĩmakʉ̃ irigʉ ããrĩ́mi. I ʉ̃mʉ marã yʉre bʉremumerã gapʉ ĩgʉ̃rẽ masĩbema. Irasirirã ĩgʉ̃rẽ bokatĩrĩñeãmasĩbema. Ĩgʉ̃ mʉsã merã ããrĩ́mi. Irasũ ããrĩmakʉ̃, mʉsãguere ããrĩníkõãgʉkumi. Irasirirã ĩgʉ̃rẽ masĩa. ");
INSERT INTO sri_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yʉ mʉsãrẽ béowãgãbirikoa. Mʉsã merãta ããrĩgʉ̃́ aarigʉkoa doja. ");
INSERT INTO sri_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mérõgã dʉyáa yʉ waaburo. Yʉ waadero pʉrʉ, i ʉ̃mʉ marã yʉre bʉremumerã neõ ĩãbirikuma. Mʉsã gapʉ yʉre ĩãrãkoa. Yʉ okáa. Irasirirã mʉsãde okarãkoa. ");
INSERT INTO sri_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yʉ aariburinʉrẽ yʉ, Yʉpʉ merã sugʉta ããrĩrĩ́rẽ masĩrãkoa. Irasũ ããrĩmakʉ̃, mʉsã yʉ merã ããrĩrĩ́rẽ, yʉ mʉsãguere ããrĩrĩ́rẽ masĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉ dorerire masĩgʉ̃ irire irigʉ yʉre maĩgʉ̃ta ããrĩ́mi. Yʉpʉ yʉre maĩgʉ̃rẽ maĩgʉkumi. Yʉde ĩgʉ̃rẽ maĩgʉkoa. Ĩgʉ̃rẽ yaamarẽ õãrõ masĩmakʉ̃ irigʉkoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃, gajigʉ Judas wãĩkʉgʉ Jesúre sẽrẽñami. Judas Iscariote meta ããrĩmí. —Gʉa Opʉ, ¿nasirigʉ gʉa ditare mʉ ããrĩrikʉrire masĩmakʉ̃ irigʉkuri? ¿Nasirigʉ i ʉ̃mʉ marã gapʉre irire masĩmakʉ̃ iribirikuri? ");
INSERT INTO sri_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús ĩgʉ̃rẽ ãrĩmi: —Yʉre maĩgʉ̃ yʉ dorerire irigʉkumi. Yʉpʉ ĩgʉ̃rẽ maĩgʉkumi. Yʉpʉ, irasũ ããrĩmakʉ̃ yʉ ĩgʉ̃ merã ããrĩrã́ aarirãkoa. ");
INSERT INTO sri_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yʉre maĩbi gapʉ yʉ dorerire iribemi. Yʉ mʉsãrẽ wereri, yaa werenírĩ ããrĩbea. Yʉpʉ yʉre iriudiya gapʉ werenírĩ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Yʉ mʉsã merã ããrĩgʉ̃́, i ããrĩpererire mʉsãrẽ werea. ");
INSERT INTO sri_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yʉ sẽrẽmakʉ̃, Yʉpʉ Õãgʉ̃ deyomarĩgʉ̃rẽ mʉsãguere iriugʉkumi. Irasirigʉ Õãgʉ̃ deyomarĩgʉ̃ mʉsãrẽ iritamubu ããrĩsĩã, ããrĩpererire buegʉkumi. Ããrĩpereri yʉ mʉsãrẽ weredeare gũñamakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Yʉ mʉsãrẽ siñajãrĩ merã ããrĩmakʉ̃ irigʉkoa. Yʉ siñajãrĩ merã ããrĩgʉ̃́ irirosũ mʉsãdere siñajãrĩ merã ããrĩmakʉ̃ irigʉkoa. Yʉ mʉsãrẽ siñajãrĩ merã ããrĩmakʉ̃ iriri, i ʉ̃mʉma irirosũ ããrĩbea. Bʉro gũñarikʉ, güibirikõãka! ");
INSERT INTO sri_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yʉ mʉsãrẽ: “Waa, dupaturi mʉsã merãta ããrĩgʉ̃́ aarigʉkoa doja”, ãrĩ weremakʉ̃ pébʉ mʉsã. Yʉpʉ yʉ nemorõ ããrĩ́mi. Irasirirã ĩgʉ̃ pʉrogue yʉ waaburire pédero pʉrʉ, mʉsã yʉre diaye maĩrã, ʉsʉyari merã ããrĩboayo. ");
INSERT INTO sri_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yʉ mʉsãrẽ ire wereyugʉ iriabʉ. Irasirirã ire keoro waamakʉ̃, yʉ mʉsãrẽ weredeare: “Diayeta gʉare weremi”, ãrĩ bʉremurãkoa. ");
INSERT INTO sri_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’I ʉ̃mʉ marãrẽ doregʉ ñegʉ̃ ããrĩ́mi. Ĩgʉ̃ aaribu yámi. Irasirigʉ yʉ mʉsãrẽ mérõgã werenínemogʉra. Ĩgʉ̃ yʉre neõ doremasĩbemi. ");
INSERT INTO sri_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yʉ, Yʉpʉ gapʉre maĩa. Irasirigʉ ĩgʉ̃ yʉre doreri gapʉre yáa, yʉ ĩgʉ̃rẽ maĩrĩrẽ i ʉ̃mʉ marãrẽ masĩburo, ãrĩgʉ̃. Wãgãnʉgãka! Náka waarã́! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús keori merã gʉare ãsũ ãrĩ weremi: —Yʉ diayeta iguida irirosũ ããrã. Yʉpʉ iridare koregʉ irirosũ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yaarã iridama dʉpʉri irirosũ ããrĩ́ma. Yʉpʉ iguidare koregʉ dʉka marĩrĩ dʉpʉrire ditibéogʉ irirosũ yámi. Gaji dʉkakʉri dʉpʉri gapʉre ditiwea ãmugʉ̃́ irirosũ yámi dʉkakʉnemoburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mʉsã yʉ weredeare bʉremurã ããrã. Irasirigʉ Yʉpʉ mʉsãrẽ ñerĩ opamerã ããrĩmakʉ̃ irisiami. ");
INSERT INTO sri_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yʉ merã õãrõ ããrĩka! Irasirigʉ mʉsãguere õãrõ ããrĩníkõãgʉkoa. Su iguidama dʉpʉ iridaguere marĩrõ iri dʉpʉ seyaro dʉkakʉbirikoa. I irirosũta yʉ merã õãrõ ããrĩmerã neõ õãrĩ dʉka sĩbiri dʉpʉri irirosũ ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yʉ iguida irirosũ ããrã. Mʉsã yaarã iridama dʉpʉri irirosũ ããrã. Yʉ merã õãrõ ããrĩnírãno, yʉde ĩgʉ̃sãguere õãrõ ããrĩnímakʉ̃, ĩgʉ̃sã õãrõ dʉkakʉri dʉpʉri irirosũ ããrĩ́ma. Mʉsã yʉ merã õãrõ ããrĩmerã, õãrĩrẽ neõ irimasĩbea. ");
INSERT INTO sri_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yʉ merã õãrõ ããrĩmerã ditibéodea dʉpʉri bojegue ñaĩ oyanírĩ dʉpʉrire sea, peamegue soebéoro irirosũ ããrĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mʉsã yʉ merã õãrõ ããrĩnírã, yʉ buerire kãtimerã, mʉsã gããmerĩnorẽ Yʉpʉre: “Sĩka!” ãrĩ sẽrẽmakʉ̃, sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mʉsã wári õãrĩ dʉkakʉri dʉpʉri irirosũ ããrĩmakʉ̃ ĩãrã, gajirã masaka Yʉpʉre: “Õãtarigʉ ããrĩ́mi”, ãrĩ masĩrãkuma. Irasirirã mʉsã wári õãrĩ irirã, diayeta yʉ buerã ããrĩrĩ́rẽ gajirãrẽ masĩmakʉ̃ yáa. ");
INSERT INTO sri_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉpʉ yʉre maĩrõsũta yʉde mʉsãrẽ maĩa. Irasirirã yʉ mʉsãrẽ maĩgʉ̃ merã ããrĩníka, yʉ maĩrĩrẽ masĩmurã! ");
INSERT INTO sri_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉ, Yʉpʉ yʉre maĩgʉ̃ dorerire irigʉ, ĩgʉ̃ merã õãrõ ããrĩníkõãa. Irasũta mʉsãde yʉ dorerire irirã, yʉ mʉsãrẽ maĩgʉ̃ merã õãrõ ããrĩníkõãa. ");
INSERT INTO sri_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ire mʉsãrẽ werea mʉsã yʉ merã ʉsʉyaburo, ãrĩgʉ̃. Irasirirã ʉsʉyari opatarirãkoa. ");
INSERT INTO sri_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yʉ doreri ãsũ ãrã. Yʉ mʉsãrẽ maĩrõsũta gãme maĩka! ");
INSERT INTO sri_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sugʉ masakʉ ĩgʉ̃ merãmarãrẽ boabosagʉ, gajirã nemorõ ĩgʉ̃sãrẽ maĩmi. ");
INSERT INTO sri_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mʉsã yʉ dorerire irirã yʉ merãmarã ããrã. ");
INSERT INTO sri_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dapagorare yʉ mʉsãrẽ: “Yʉre moãboerã ããrã”, ãrĩbirikoa. Moãboerã ĩgʉ̃sã opʉ iririre masĩbirikuma. Yʉ gapʉ Yʉpʉ yʉre weredeare mʉsãrẽ werepeobʉ. Irasirigʉ mʉsãrẽ: “Yʉ merãmarã”, ãrã. ");
INSERT INTO sri_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉsã yʉre beyebiribʉ. Yʉ gapʉ mʉsãrẽ beyebʉ wári õãrĩrẽ irirã waaburo, ãrĩgʉ̃. Mʉsã õãrĩ iriri, õãrĩ dʉka neõ boabiri irirosũ ããrã. Irasirirã mʉsã yʉre bʉremumakʉ̃, Yʉpʉ mʉsã yʉ wãĩ merã ĩgʉ̃rẽ sẽrẽrõsũta mʉsãrẽ sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yʉ mʉsãrẽ dorea. Mʉsã basi gãme maĩka! ");
INSERT INTO sri_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’I ʉ̃mʉ marã mʉsãrẽ ĩãturimakʉ̃ ĩãrã, yʉre ĩãturipʉrorideare masĩka! ");
INSERT INTO sri_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mʉsã diayeta i ʉ̃mʉ marã ããrĩmakʉ̃, ĩgʉ̃sã merãmarãrẽ maĩrõsũta mʉsãdere maĩbukuma. Yʉ mʉsãrẽ i ʉ̃mʉ marã watopegue ããrĩrã́rẽ beyebʉ. Irasirirã i ʉ̃mʉ marãgora ããrĩbea. Mʉsã ĩgʉ̃sã irirosũ ããrĩbirimakʉ̃ ĩãrã, i ʉ̃mʉ marã mʉsãrẽ ĩãturima. ");
INSERT INTO sri_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yʉ mʉsãrẽ ãrĩdeare gũñaka! “Neõ sugʉ moãboerimasʉ̃, ĩgʉ̃ opʉ nemorõ ããrĩbirikumi”, ãrĩbʉ. Ĩgʉ̃sã yʉre ñerõ irirã, mʉsãdere ñerõ irirãkuma. Yʉ buerire pérã, mʉsã bueridere pérãkuma. ");
INSERT INTO sri_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","I ʉ̃mʉ marã yʉre iriudire masĩbema. Irasirirã mʉsã yʉre bʉremumakʉ̃ ĩãrã, mʉsãrẽ ããrĩpereri ñerĩ irirãkuma. ");
INSERT INTO sri_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Yʉ ĩgʉ̃sãrẽ weregʉ aaribirimakʉ̃, neõ ñerĩ iridea wajare opabiribukuma. Dapagorare yʉ ĩgʉ̃sãrẽ weredero pʉrʉ: “Ñerĩ iridea wajare opabea gʉa”, ãrĩmasĩbema. ");
INSERT INTO sri_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yʉre ĩãturigʉ Yʉpʉdere ĩãturimi. ");
INSERT INTO sri_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yʉ, Yʉpʉ turari merã iri ĩmugʉ̃, gajirã neõ iribirideare iribʉ. Yʉ ĩgʉ̃ turari merã iri ĩmubirimakʉ̃, neõ waja opabiribukuma. Ĩgʉ̃sã yʉ iri ĩmurĩrẽ ĩãma. Irire ĩãdero pʉrʉ, yʉre, Yʉpʉdere ĩãturima. ");
INSERT INTO sri_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","I ĩãturiri, Marĩpʉya werenírĩ gojadea pũgue gojaderosũta keoro waaró yáa. Ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Ĩgʉ̃sã yʉre: ‘Ñerõ yámi’, ãrĩmasĩbirikererã, ĩãturima”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Õãgʉ̃ deyomarĩgʉ̃, mʉsãrẽ iritamugʉ̃ aarigʉkumi. Ĩgʉ̃ mʉsãrẽ diayema ããrĩrĩ́rẽ masĩmakʉ̃ irigʉkumi. Yʉ ĩgʉ̃rẽ Yʉpʉ merã ããrĩgʉ̃́rẽ mʉsãrẽ iriugʉkoa. Ĩgʉ̃ yaamarẽ weregʉkumi mʉsãrẽ. ");
INSERT INTO sri_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yʉ mʉsãrẽ buepʉrorimakʉ̃gueta yʉ merã ããrĩbʉ́. Irasirirã mʉsãde yaamarẽ wererãkoa, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús gʉare ãsũ ãrĩnemomi doja: —Yʉ mʉsãrẽ irire wereabʉ, yʉre piribirikõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judío masaka ĩgʉ̃sã nerẽrĩ wiirigue mʉsã ããrãnerãrẽ béowiurãkuma. Gajipoe gajirã mʉsãrẽ wẽjẽrã: “Marĩpʉ gããmerĩrẽ yáa”, ãrĩ gũñarãkuma. ");
INSERT INTO sri_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yʉre, Yʉpʉdere masĩmerã ããrĩsĩã, irasirirãkuma. ");
INSERT INTO sri_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yʉ irire werea mʉsã, ĩgʉ̃sã irasirimakʉ̃ ĩãrã: “Jesús gʉare irireta weremi”, ãrĩ gũñaburo, ãrĩgʉ̃. ’Yʉ neõgorague mʉsã merã ããrĩsĩã, ire werebiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dapagorare yʉre iriudi pʉrogue waagʉkoa. Yʉ mʉsãrẽ ire werekeremakʉ̃, neõ sugʉ yʉre: “¿Noógue waagʉkuri?” ãrĩ sẽrẽñabea. ");
INSERT INTO sri_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Irasirirã yʉ waaburire weremakʉ̃ pérã, yʉ waaburo gapʉre sẽrẽñabirisĩã, bʉro bʉjawereri merã ããrã. ");
INSERT INTO sri_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Diayeta mʉsãrẽ werea. Yʉ waadero pʉrʉ, õãrokoa mʉsãrẽ. Yʉ waabirimakʉ̃, Õãgʉ̃ deyomarĩgʉ̃ mʉsãrẽ iritamubu aaribiribukumi. Yʉ irogue waagʉ́, ĩgʉ̃rẽ mʉsãrẽ iriugʉkoa, mʉsã merã ããrĩníkõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ĩgʉ̃ aarigʉ́, i ʉ̃mʉ marãrẽ ĩgʉ̃sã ñerõ irirã ããrĩrĩ́rẽ, yʉ diayema irigʉ ããrĩrĩ́rẽ, ĩgʉ̃sã ñerõ iridea waja Marĩpʉ ĩgʉ̃sãrẽ wajamoãburire masĩmakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ĩgʉ̃sã yʉre bʉremubirisĩã, ñerã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yʉ, Yʉpʉ pʉrogue waamakʉ̃, mʉsã yʉre ĩãnemobirikoa. Yʉ irogue waamakʉ̃, Õãgʉ̃ deyomarĩgʉ̃ aarigʉkumi, i ʉ̃mʉ marãrẽ yʉ diayema irigʉ ããrĩrĩ́rẽ masĩmakʉ̃ iribu. ");
INSERT INTO sri_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","I ʉ̃mʉ marãrẽ doregʉ ñegʉ̃ ĩgʉ̃sãrẽ ñerĩ iridoreri waja, Yʉpʉ ĩgʉ̃rẽ wajamoãdoresiami. Irasirigʉ Õãgʉ̃ deyomarĩgʉ̃ aarigʉ́, ĩgʉ̃sãrẽ Yʉpʉ ĩgʉ̃rẽ wajamoãdoredeare masĩmakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Wári ããrã mʉsãrẽ yʉ wereburi. Dapagorare yʉ ire weremakʉ̃, mʉsã pémasĩbiribukoa. ");
INSERT INTO sri_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Õãgʉ̃ deyomarĩgʉ̃ gapʉ aarigʉkumi. Ĩgʉ̃ mʉsãrẽ diayema ããrĩrĩ́rẽ masĩmakʉ̃ irigʉkumi. Irasirigʉ mʉsãrẽ i ããrĩpererire buegʉkumi. Ĩgʉ̃ gããmerõ werebirikumi. Yʉpʉ ĩgʉ̃rẽ weredorerire, pʉrʉgue waaburidere mʉsãrẽ weregʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yʉ ĩgʉ̃rẽ wererire pédeare mʉsãrẽ masĩmakʉ̃ irigʉ, yʉ õãrõ ããrĩrĩ́rẽ masĩmakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ããrĩpereri Yʉpʉ opari, yaa ããrã. Irasirigʉ yʉ mʉsãrẽ: “Õãgʉ̃ deyomarĩgʉ̃ mʉsãrẽ yaamarẽ masĩmakʉ̃ irigʉkumi”, ãrãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mérõgã pʉrʉ mʉsã yʉre ĩãnemobirikoa. Yoaweyaripoe pʉrʉ yʉre ĩãrãkoa doja. I Yʉpʉ pʉrogue waadero pʉrʉ, irasũ waarokoa, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa surãyeri ãsũ ãrĩ gãme wereníbʉ: —¿Naásũ ãrĩdʉaro irikuri ĩgʉ̃ irasũ ãrĩrĩ? Ĩgʉ̃ marĩrẽ: “Mérõgã pʉrʉ mʉsã yʉre ĩãnemobirikoa. Yoaweyaripoe pʉrʉ yʉre ĩãrãkoa doja”. Ire ãrĩ odo: “I Yʉpʉ pʉrogue waadero pʉrʉ, irasũ waarokoa”, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ĩgʉ̃ marĩrẽ: “Mérõgã pʉrʉ”, ãrĩmakʉ̃, ¿naásũ ãrĩdʉaro irikuri? Ĩgʉ̃ irasũ ãrĩrĩrẽ marĩ pémasĩbea, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús ĩgʉ̃rẽ gʉa sẽrẽñadʉarire masĩkõãmi. Irasirigʉ gʉare ãrĩmi: —Yʉ mʉsãrẽ: “Mérõgã pʉrʉ mʉsã yʉre ĩãnemobirikoa. Yoaweyaripoe pʉrʉ yʉre ĩãrãkoa doja”, ¿ãrĩ wererire gãme sẽrẽñarã yári? ");
INSERT INTO sri_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Diayeta mʉsãrẽ werea. Yʉ boamakʉ̃ ĩãrã, bʉro bʉjawereri merã orerãkoa. I ʉ̃mʉ marã yʉre bʉremumerã gapʉ ʉsʉyari merã ããrĩrãkuma. Mʉsã bʉjawererã, pʉrʉ ʉsʉyarãkoa. ");
INSERT INTO sri_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ãsũ ããrã. Nomeõ majĩgʉ̃ kõãburo dupiyurogã, igore pũrĩrĩrẽ bʉjawereri merã gũñakumo. Majĩgʉ̃gã deyoadire ĩãgõ, ʉsʉyakumo. Igore pũrĩadeare gũñanemobirikumo. ");
INSERT INTO sri_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mʉsãde irasũta dapagorare bʉjawereri merã ããrã. Pʉrʉ yʉ mʉsãrẽ dupaturi ĩãgʉ̃ aarigʉkoa. Yʉ irasirimakʉ̃ ĩãrã, mʉsã ʉsʉyari opatarirãkoa. Mʉsã irasũ ʉsʉyari merã ããrĩmakʉ̃, gajirã mʉsãrẽ bʉjaweremakʉ̃ irimasĩbirikuma. ");
INSERT INTO sri_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Irinʉrẽ yʉre neõ sẽrẽñabirikoa. Diayeta mʉsãrẽ werea. Mʉsã yʉre bʉremumakʉ̃ ĩãgʉ̃, Yʉpʉ ããrĩpereri mʉsã yʉ wãĩ merã ĩgʉ̃rẽ sẽrẽrĩrẽ pégʉ, mʉsã sẽrẽrõsũta sĩgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Iro dupiyurogue mʉsã yʉ wãĩ merã Yʉpʉre neõ sẽrẽbiribʉ. Dapagorare yʉ wãĩ merã ĩgʉ̃rẽ sẽrẽka! Mʉsã irasũ sẽrẽmakʉ̃, mʉsã sẽrẽrõsũta sĩgʉkumi. Irasirirã ʉsʉyari opatarirãkoa. ");
INSERT INTO sri_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Yʉ keori merã mʉsãrẽ wereabʉ. Pʉrʉ keori merã werebirikoa. Irasirirã, Yʉpʉyamarẽ yʉ wererire õãrõ pémasĩrãkoa. ");
INSERT INTO sri_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mʉsã Yʉpʉyamarẽ õãrõ pémasĩrĩnʉrẽ yʉ wãĩ merã ĩgʉ̃rẽ sẽrẽrãkoa. Irasũ ãrĩgʉ̃: “Mʉsãya ããrĩburire yʉ ĩgʉ̃rẽ sẽrẽbosagʉkoa”, ãrĩgʉ̃ meta yáa. ");
INSERT INTO sri_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yʉpʉ mʉsãrẽ maĩmi. Irasirirã mʉsã yʉ wãĩ merã mʉsã basi ĩgʉ̃rẽ sẽrẽrãkoa. Mʉsã yʉre maĩa. Irasũ ããrĩmakʉ̃ mʉsã yʉre: “Marĩpʉ pʉrogue ããrĩdi, ĩgʉ̃ iriudi ããrã”, ãrĩ bʉremua. ");
INSERT INTO sri_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉ, Yʉpʉ pʉrogue ããrĩdi, i ʉ̃mʉguere aaribʉ́. Dapagorare i ʉ̃mʉgue ããrãdi, Yʉpʉ pʉrogue waagʉkoa doja, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, gʉa ĩgʉ̃ buerã ĩgʉ̃rẽ ãrĩbʉ: —Dapagorare keori merã mʉ gʉare werebea. Irasirirã mʉ wererire pémasĩa. ");
INSERT INTO sri_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Dapagorare gʉa masĩa. Mʉ ããrĩpererire masĩpeokõãa. Gajirã mʉrẽ sẽrẽñabirikeremakʉ̃, ĩgʉ̃sã gũñarĩgue sẽrẽñadʉarire mʉ masĩa. Irasirirã: “Marĩpʉ pʉrogue ããrĩdi, ĩgʉ̃ iriudi ããrã”, ãrĩ bʉremua, ãrĩbʉ. ");
INSERT INTO sri_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús gʉare ãrĩmi: —¿Dapagorare bʉremurĩ? ");
INSERT INTO sri_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mérõgã dʉyáa, mʉsã yʉre béowãgãburo. Mʉsãya wiirigue waasiri, yʉre sugʉta dujamakʉ̃ irirãkoa. Mʉsã irasirikeremakʉ̃, Yʉpʉ gapʉ yʉ merã ããrĩ́mi. Irasirigʉ yʉ sugʉta ããrĩbea. ");
INSERT INTO sri_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mʉsã yʉ merã õãrõ siñajãrĩ opaburo, ãrĩgʉ̃, mʉsãrẽ i ããrĩpererire wereabʉ. Mʉsã i ʉ̃mʉgue ããrĩripoe i ʉ̃mʉ marã mʉsãrẽ ñerõ tarimakʉ̃ irirãkuma. Ĩgʉ̃sã irasirikeremakʉ̃, yʉ merã gũñaturaka! Yʉ i ʉ̃mʉ marã ñerãrẽ tarinʉgãdigue ããrã. Irasirirã yʉ merã gũñatura ʉsʉyaka! ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús irasũ ãrĩ odo, ʉ̃mʉgasigue ĩãmu, ĩgʉ̃ Pagʉre ãsũ ãrĩmi: —Aʉ, dapagorare mʉ ãrĩderosũta yʉre waaburi ejasiáa. Irasirigʉ masakare yʉ mʉ magʉ̃, mʉ iriudi ããrĩrĩ́rẽ ĩmuka! Mʉ irasirimakʉ̃, yʉ mʉ turagʉ, mʉ õãgʉ̃ ããrĩrĩ́rẽ ĩgʉ̃sãrẽ ĩmugʉkoa. ");
INSERT INTO sri_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mʉ yʉre masaka ããrĩpererãrẽ doregʉ píbʉ, mʉ yʉre sĩnerãrẽ ʉ̃mʉgasigue perebiri okari opamakʉ̃ iridoregʉ. ");
INSERT INTO sri_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Masaka mʉ diayeta Marĩpʉ sugʉ ããrĩgʉ̃́ ããrĩrĩ́rẽ, irasũ ããrĩmakʉ̃ yʉ Jesucristo mʉ iriudi ããrĩrĩ́rẽ masĩrã, ʉ̃mʉgasigue perebiri okari opamurã ããrĩ́ma. ");
INSERT INTO sri_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’I ʉ̃mʉguere mʉ yʉre iridoredeare yʉ iriyuwarikʉbʉ. Irasirigʉ i ʉ̃mʉ marãrẽ mʉ turagʉ, õãgʉ̃ ããrĩrĩ́rẽ ĩmubʉ. ");
INSERT INTO sri_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aʉ, mʉ i ʉ̃mʉrẽ iriburo dupiyuro yʉ mʉ merã õãrõ ããrĩbʉ́. Mʉ ããrĩrikʉrire opabʉ. Irasirigʉ dapagorare mʉ ããrĩrṍgue yʉ mʉ merã õãrõ ããrĩmakʉ̃ mʉrãrõta irika! ");
INSERT INTO sri_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Mʉ yʉre sĩnerãrẽ i ʉ̃mʉ marã watope ããrĩrã́rẽ beyenerãrẽ mʉ ããrĩrikʉrire masĩmakʉ̃ iribʉ. Mʉ yʉre sĩnerã mʉyarã ããrĩ́ma. Mʉ dorerire irima. ");
INSERT INTO sri_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Dapagorare masĩma. Ããrĩpereri yʉ opari, mʉ yʉre sĩdea ããrã. ");
INSERT INTO sri_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mʉ yʉre weredoredeare ĩgʉ̃sãrẽ werebʉ. Yʉ wererire pérã, bʉremuma. Yʉ diayeta mʉ pʉro ããrĩdi ããrĩrĩ́rẽ masĩma. Yʉ mʉ iriudi ããrĩrĩ́rẽ: “Diayeta ããrã”, ãrĩ bʉremuma. ");
INSERT INTO sri_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Yʉ ĩgʉ̃sãya ããrĩburire sẽrẽbosáa. Gajirã i ʉ̃mʉ marã yʉre bʉremumerãya ããrĩburi gapʉre sẽrẽbosabea. Yʉre bʉremurã mʉ yʉre sĩnerã mʉyarã ããrĩ́ma. Irasirigʉ ĩgʉ̃sãya ããrĩburire sẽrẽbosáa. ");
INSERT INTO sri_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ããrĩpererã yaarã, mʉyarã ããrĩ́ma. Irasirirã mʉyarãde, yaarã ããrĩ́ma. Ĩgʉ̃sã yaarã ããrĩsĩã, yʉ õãrõ ããrĩrikʉrire masakare masĩmakʉ̃ yáma. ");
INSERT INTO sri_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Yʉ i ʉ̃mʉguere dujabirikoa. Mʉ yʉre sĩnerã gapʉ i ʉ̃mʉguere dujarãkuma. Aʉ, mʉ õãgʉ̃ ããrã. Mʉ wãĩ merã mʉ turari merã ĩgʉ̃sãrẽ koreka, marĩ sugʉ ããrĩnírõsũta ĩgʉ̃sãde suro merã ããrĩníkõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yʉ i ʉ̃mʉguere mʉ yʉre sĩnerã merã ããrĩgʉ̃́, mʉ turari merã ĩgʉ̃sãrẽ õãrõ korebʉ. Neõ sugʉ dederibirima. Sugʉta peamegue waadederibu ããrĩ́mi. Mʉya werenírĩ gojadea pũgue ãrĩderosũta iri irasũ waabʉ. ");
INSERT INTO sri_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Dapagorare yʉ mʉ pʉrogue waabu yáa. Yʉ waaburi dupiyuro i ʉ̃mʉgue ããrĩgʉ̃́ i ããrĩpererire yʉre bʉremurãrẽ werea, ĩgʉ̃sãde yʉ irirosũta ʉsʉyari opatariburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʉya kerere ĩgʉ̃sãrẽ werebʉ. Yʉ i ʉ̃mʉmʉ ããrĩbea. Irasirirã yʉre bʉremurãde i ʉ̃mʉ marã irirosũ ããrĩbema. Irasirirã i ʉ̃mʉ marã yʉre ĩãturirosũta yʉre bʉremurãdere ĩãturima. ");
INSERT INTO sri_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yʉ mʉrẽ: “Yʉre bʉremurãrẽ i ʉ̃mʉrẽ ãĩaka!” ãrĩ sẽrẽbea. Ãsũ gapʉ ãrĩ sẽrẽa. Ĩgʉ̃sãrẽ õãrõ koreka, wãtĩ ñerĩ iridorerire pébirikõãburo, ãrĩgʉ̃! ");
INSERT INTO sri_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yʉ i ʉ̃mʉmʉ ããrĩbea. Irasirirã yʉre bʉremurãde i ʉ̃mʉ marã irirosũ ããrĩbema. ");
INSERT INTO sri_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mʉya kere diayema ããrã. Irasirigʉ iri merã ĩgʉ̃sãrẽ mʉ dorerire irirã ããrĩmakʉ̃ irika! ");
INSERT INTO sri_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mʉ yʉre mʉya kerere i ʉ̃mʉ marãrẽ weredoregʉ iriuderosũta yʉre bʉremurãrẽ mʉya kerere i ʉ̃mʉ marãrẽ weredoregʉ iriua. ");
INSERT INTO sri_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ĩgʉ̃sãya ããrĩburire mʉ dorerire irigʉ yáa, ĩgʉ̃sãde diayeta mʉ dorerire iriburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Yʉ ĩgʉ̃sãya ããrĩburi ditare sẽrẽbosabea. Ĩgʉ̃sã mʉya kere wererire pérã, gajirãde yʉre bʉremurãkuma. Irasirigʉ yʉ ĩgʉ̃sãya ããrĩburidere sẽrẽbosáa. ");
INSERT INTO sri_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yʉ irire sẽrẽbosáa, yʉre bʉremurã ããrĩpererã suro merã ããrĩburo, ãrĩgʉ̃. Aʉ, mʉ yʉguere õãrõ ããrã. Yʉ mʉ merã ããrã. Irasirirã marĩ ããrĩrṍsũta ĩgʉ̃sã marĩ merã õãrõ ããrĩburo. Ĩgʉ̃sãrẽ suro merã ããrĩmakʉ̃ irika, i ʉ̃mʉ marã yʉ mʉ iriudi ããrĩrĩ́rẽ bʉremuburo, ãrĩgʉ̃! ");
INSERT INTO sri_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mʉ ããrĩrikʉrire yʉre sĩbʉ. Irasirigʉ ĩgʉ̃sãrẽ yʉ irirosũ ããrĩrikʉmakʉ̃ iribʉ, yʉ mʉ merã sugʉ ããrĩrṍsũta ĩgʉ̃sãde suro merã ããrĩburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yʉ ĩgʉ̃sãguere ããrã. Mʉ yʉguere ããrã. Marĩ ĩgʉ̃sã merã ããrã, ĩgʉ̃sã diayeta suro merã ããrĩburo, ãrĩrã. Ĩgʉ̃sã suro merã ããrĩmakʉ̃ ĩãrã, i ʉ̃mʉ marã yʉ mʉ iriudi ããrĩrĩ́rẽ, mʉ yʉre maĩrõsũta yʉre bʉremurãrẽ maĩrĩrẽ masĩrãkuma. ");
INSERT INTO sri_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Aʉ, mʉ i ʉ̃mʉrẽ iriburo dupiyuro yʉre maĩbʉ. Irasirigʉ mʉ ããrĩrikʉrire yʉre sĩbʉ. Yʉre mʉ sĩnerãrẽ yʉ ããrĩburogue yʉ merã ããrĩmakʉ̃ gããmea mʉ yʉre ããrĩrikʉri sĩdeare masĩburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aʉ, mʉ keoro irigʉ ããrã. I ʉ̃mʉ marã yʉre bʉremumerã mʉrẽ masĩbema. Yʉ gapʉ mʉrẽ masĩa. Yʉre bʉremurã yʉ mʉ iriudi ããrĩrĩ́rẽ masĩma. ");
INSERT INTO sri_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉ ããrĩrikʉrire ĩgʉ̃sãrẽ masĩmakʉ̃ iribʉ. Yʉ ĩgʉ̃sãguere ããrĩgʉ̃́ mʉrẽ irasũ masĩmakʉ̃ iriníkõãgʉkoa, mʉ yʉre maĩrõsũta ĩgʉ̃sãde gãme maĩburo, ãrĩgʉ̃, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús ĩgʉ̃ Pagʉre sẽrẽ odoadero pʉrʉ, gʉa ĩgʉ̃ buerã merã Jerusalẽ́rẽ wiri, Cedrón wãĩkʉri ũmayuridijari márẽ taribuja, olivos wãĩkʉri yuku otederogue waami. ");
INSERT INTO sri_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iro dupiyuro wári Jesús irogue gʉare siiuwãgãnami. Irasirigʉ Judas Jesúre ĩãturirãguere ĩgʉ̃rẽ ĩmubu irore masĩmi. ");
INSERT INTO sri_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jesús gʉa merã irogue ejadero pʉrʉ, Judas subu surara merã aarimí. Gajirã surara Marĩpʉya wiire korerãde ĩgʉ̃ merã aarimá. Ĩgʉ̃sã paía oparã, fariseo bumarã iriunerã surara ããrĩmá. Ĩgʉ̃sã mojõkʉri merã, sĩãgoriduparu, sĩãgori tururi merã aarimá. ");
INSERT INTO sri_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús ĩgʉ̃rẽ waaburire masĩsiami. Irasirigʉ, ĩgʉ̃sã ĩgʉ̃ pʉro ejarimakʉ̃, bokatĩrĩ sẽrẽñami: —¿Noãrẽ ãmarĩ mʉsã? ");
INSERT INTO sri_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ĩgʉ̃rẽ yʉjʉma: —Jesús Nazaretmʉrẽ ãmáa. Jesús ĩgʉ̃sãrẽ ãrĩmi: —Ĩgʉ̃ta ããrã yʉ. Judas Jesúre wẽjẽdʉarãguere ĩgʉ̃rẽ ĩmubu surara merã ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús: “Ĩgʉ̃ta ããrã yʉ”, ãrĩmakʉ̃ pérã, duusirimawãgã, yebague meémejãkõãma. ");
INSERT INTO sri_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús ĩgʉ̃sãrẽ dupaturi sẽrẽñami doja: —¿Noãrẽ ãmarĩ mʉsã? Ĩgʉ̃rẽ yʉjʉma: —Jesús Nazaretmʉrẽ ãmáa. ");
INSERT INTO sri_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús ĩgʉ̃sãrẽ ãrĩmi: —Yʉ mʉsãrẽ: “Yʉ ĩgʉ̃ta ããrã”, ãrĩ weresiabʉ. Yʉre ãmarã́, ĩĩsã yʉ merãmarãrẽ waadoreka! ");
INSERT INTO sri_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ĩgʉ̃: “Yʉpʉ yʉre sĩnerãrẽ neõ sugʉre dedeubiribʉ”, ãrĩdeare keoro waaburo, ãrĩgʉ̃, irire irasũ ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ĩgʉ̃sã Jesúre ñeãmurã irimakʉ̃ ĩãgʉ̃, Simón Pedro sareri majĩrẽ opagʉ tʉ̃ãwea ãĩ, paía opʉre moãboegʉre Malco wãĩkʉgʉre diaye gapʉma gãmipũrẽ dititá dijukõãmi. ");
INSERT INTO sri_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús gapʉ Pedrore ãrĩmi: —Mʉya sareri majĩrẽ duripíka! Yʉpʉ yʉre ñerõ taridorederosũta ñerõ tarigʉra, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ĩgʉ̃ irasũ ãrĩmakʉ̃, surara, ĩgʉ̃sã opʉ, Marĩpʉya wiire korerã surara Jesúre ñeã, sʉama. ");
INSERT INTO sri_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Sʉa odo, ĩgʉ̃rẽ Anás wãĩkʉgʉya wiigue ãĩwãgãpʉrorima. Anás, Caifás wãĩkʉgʉ mʉ́ñekʉ̃ ããrĩmí. Caifás iri bojorire paía opʉ ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ĩgʉ̃ta iro dupiyuro judío masaka oparãrẽ: “Sugʉta masakʉ marĩ judío masakaya ããrĩburire boabosamakʉ̃ õãrokoa”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ĩgʉ̃sã Jesúre ãĩãmakʉ̃, yʉ, Simón Pedro merã Jesúre yoaweyarogue ĩãtʉyabʉ. Paía opʉ yʉre masĩmi. Irasirigʉ yʉ Jesúre ĩãtʉyawãgã, paía opʉya wii makãpʉroma yebague ñajãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro gapʉ iri wii tʉro ñajãri makãpʉrogue dujanʉgãmi. Ĩgʉ̃ iro dujanʉgãmakʉ̃ ĩãgʉ̃, yʉ iri makãpʉro korego merã werení, Pedrore siiu ñajãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ĩgʉ̃ ñajãmakʉ̃, makãpʉro korego Pedrore sẽrẽñamo: —¿Mʉ sĩĩ buerã merãmʉ ããrĩberi? Pedro igore ãrĩmi: —Ããrĩbea yʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yʉsagorabʉ. Irasirirã iri wii moãboerimasã, surara merã ĩgʉ̃sã peame diudeame tʉro sũma níma. Pedrode ĩgʉ̃sã pʉrota sũma ními. ");
INSERT INTO sri_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Paía opʉ Anás Jesúre sẽrẽñayupʉ: —¿Noã ããrĩ́rĩ mʉ buerã? ¿Ñeénorẽ ĩgʉ̃sãrẽ bueri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉ ããrĩpererã péurogue buebʉ. Marĩ judío masaka nerẽrĩ wiirigue, irasũ ããrĩmakʉ̃ Marĩpʉya wiiguedere masaka nerẽrõgue buebʉ. Gajirogue durisĩã, neõ buebiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nasirigʉ yʉre sẽrẽñarĩ? Yʉ buerire sẽrẽñadʉagʉ, yʉre pénerãrẽ sẽrẽñaka! Ĩgʉ̃sã yʉ weredeare masĩma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Marĩpʉya wii koregʉ surara ĩgʉ̃ mojõ merã Jesúya diapure pá, ĩgʉ̃rẽ ãrĩyupʉ: —¿Nasirigʉ irasũ yʉjʉri paía opʉre? Irasũ ãrĩbita ĩgʉ̃rẽ! ");
INSERT INTO sri_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Yʉ ñerõ werenímakʉ̃: “Ñeéno werenía”, ãrĩka yʉre! Yʉ diayema gapʉre keoro weremakʉ̃, ¿nasirigʉ yʉre pári? ");
INSERT INTO sri_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jesús irasũ ãrãdero pʉrʉ, Anás ĩgʉ̃rẽ ĩgʉ̃sã sʉadire paía opʉ Caifás pʉrogue iriuyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Irasiriripoe Simón Pedro peame tʉrota sũma níkõãmakʉ̃ ĩãrã, iro ããrĩrã́ ĩgʉ̃rẽ sẽrẽñama: —¿Mʉ sĩĩ buerã merãmʉ meta ããrĩ́rĩ? Pedro ĩgʉ̃sãrẽ ãrĩmi: —Ããrĩbea yʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, sugʉ paía opʉre moãboegʉ Pedro ĩgʉ̃ya gãmipũ dititádiyagʉ Pedrore ãrĩmi: —Yʉ olivos otederogue mʉ ĩgʉ̃ merã ããrĩmakʉ̃ ĩãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro dupaturi: “Ããrĩbea, ĩgʉ̃ merã ããrĩbirabʉ”, ãrĩmi. Irire ãrĩripoeta, ãgãbo weremi. ");
INSERT INTO sri_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pʉrʉ Jesúre Caifáya wii ããrãdire Pilato pʉrogue ãĩãma. Boyoripoe ããrĩbʉ́. Pilato romanomʉ judío masakare doregʉ ããrĩmí. Jesúre ĩgʉ̃ pʉrogue ãĩãrã, ĩgʉ̃ya wiiguere ñajãbirima. “Marĩ judío masaka, ĩgʉ̃ judío masakʉ ããrĩbiya wiiguere ñajãrã, marĩ dorerire tarinʉgãbukoa. Irasirirã pascua bosenʉ baaburire baabiribukoa”, ãrĩ gũñama. ");
INSERT INTO sri_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ĩgʉ̃sã ñajãbirimakʉ̃ ĩãgʉ̃, Pilato ĩgʉ̃sã merã werenígʉ̃ wiririmi. Ĩgʉ̃sãrẽ sẽrẽñami: —¿Neénorẽ iriari ĩĩ, mʉsã yʉre wajamoãdorerã aarimakʉ̃? ");
INSERT INTO sri_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ĩgʉ̃sã Pilatore ãrĩma: —Ĩĩ ñerĩ iribirimakʉ̃, mʉrẽ wiarã aaribiriboakuyo. ");
INSERT INTO sri_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Pilato ãrĩmi: —Ãĩaka! Mʉsãrẽ doreri ãrĩrõsũta mʉsã basi ĩgʉ̃rẽ wajamoãka! Ĩgʉ̃sã ĩgʉ̃rẽ ãrĩma: —Gʉa judío masaka sugʉre mʉ gʉare: “Wẽjẽka!” ãrĩrõ marĩrõ wẽjẽmasĩbea. ");
INSERT INTO sri_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ĩgʉ̃sã irire irasũ ãrĩrã, Jesúre ĩgʉ̃ curusague boaburire iro dupiyuro weredea keoro waamakʉ̃ irima. ");
INSERT INTO sri_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pilato wiigue gãmenʉgã ñajãa, Jesúre siiu, sẽrẽñayupʉ: —¿Mʉta judío masaka Opʉ ããrĩ́rĩ? ");
INSERT INTO sri_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús ĩgʉ̃rẽ ãrĩyupʉ: —¿Mʉ basi gũñarõ merã yʉre irasũ sẽrẽñarĩ, o gajirã mʉrẽ yaamarẽ wereari? ");
INSERT INTO sri_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato ĩgʉ̃rẽ ãrĩyupʉ: —Yʉ judío masakʉ meta ããrã. Mʉya nikũ marã judío masaka, irasũ ããrĩmakʉ̃ paía oparã mʉrẽ õõ yʉ pʉrogue ãĩjama. ¿Ñeénorẽ iriari mʉ? ");
INSERT INTO sri_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús ãrĩyupʉ: —Yʉ Opʉ ããrĩrĩ́, i ʉ̃mʉma ããrĩbea. I ʉ̃mʉma ããrĩmakʉ̃, yaarã gãmekẽãbukuma, judío masaka yʉre ñeã, peresu iribirikõãburo, ãrĩrã. Yʉ Opʉ ããrĩrĩ́, gajiroguema ããrã. ");
INSERT INTO sri_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pilato ĩgʉ̃rẽ ãrĩyupʉ: —¿Mʉ irasũ ãrĩgʉ̃: “Opʉ ããrã”, ãrĩrĩ? Jesús ĩgʉ̃rẽ ãrĩyupʉ: —Mʉ ãrĩrõsũta Opʉ ããrã. Yʉ deyoabʉ i ʉ̃mʉ marãguere diayemarẽ werebu. Ããrĩpererã diayema ããrĩrĩ́rẽ pédʉarã, yʉ wererire péma. ");
INSERT INTO sri_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Pilato ĩgʉ̃rẽ ãrĩyupʉ: —¿Ñeéno ããrĩ́rĩ diayema? Irasũ ãrĩ odo, Pilato judío masaka oparã merã werenígʉ̃ wiriri, ĩgʉ̃sãrẽ ãrĩmi doja: —Ĩĩrẽ neõ ñerĩ iridea máa yʉ ĩãmakʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bojorikʉ pascua bosenʉ ããrĩmakʉ̃, mʉsã irinarõsũta sugʉ peresu ããrĩgʉ̃́rẽ yʉre wiudorea. ¿Mʉsã judío masaka Opʉre mʉsãrẽ wiumakʉ̃ gããmekuri? ");
INSERT INTO sri_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã gaguiníma: —Ĩgʉ̃rẽ wiubirikõãka! Barrabás gapʉre gʉare wiuka! ãrĩma. Barrabás yajarimasʉ̃ ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ĩgʉ̃sã irasũ ãrĩ gaguinímakʉ̃ pégʉ, Pilato ĩgʉ̃yarã surarare Jesúre tãrãdoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jesúre tãrã odo, pora bero iri, ĩgʉ̃ya dipurure peoñurã. Peo odo, opʉya suríro irirosũ deyoriñe diiañiweyariñerẽ ĩgʉ̃rẽ sãñurã. ");
INSERT INTO sri_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sã odo, ĩgʉ̃ pʉro ejanʉgã, ãsũ ãrĩ bʉridañurã: —Õãrõ ããrĩburo judío masaka Opʉ! ãrĩñurã, Irasũ ãrĩrãta, ĩgʉ̃sãya mojõrĩ merã ĩgʉ̃ya diapure páñurã. ");
INSERT INTO sri_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato dupaturi masakare weregʉ wiriri, ãsũ ãrĩmi: —Ĩgʉ̃rẽ neõ ñerĩ iridea máa yʉ ĩãmakʉ̃. Irasirigʉ mʉsãrẽ masĩburo, ãrĩgʉ̃, ĩgʉ̃rẽ siiu wiugʉra mʉsãrẽ ĩãdoregʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Irasũ ãrĩ odo, Jesúre siiu wiumi. Irasirigʉ, Jesús pora berore peyadi, opʉya surírore sãñadi ĩgʉ̃ wiririmakʉ̃, Pilato masakare ãrĩmi: —Ĩãka! Ĩĩta ããrĩ́mi ĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Paía oparã, Marĩpʉya wii korerã surara Jesúre ĩãrã, gaguinínʉgãma: —Ĩgʉ̃rẽ curusague pábiatú wẽjẽka! Curusague pábiatú wẽjẽka! ãrĩ gaguiníma. Pilato ĩgʉ̃sãrẽ ãrĩmi: —Yʉ ĩãmakʉ̃, ĩgʉ̃rẽ neõ ñerĩ iridea máa. Irasirirã mʉsã ĩgʉ̃rẽ ãĩaka! Mʉsã basita ĩgʉ̃rẽ curusague pábiatú wẽjẽrã waaka! ");
INSERT INTO sri_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judío masaka oparã ĩgʉ̃rẽ ãrĩma: —Ĩgʉ̃: “Yʉ Marĩpʉ magʉ̃ ããrã”, ãrĩmi. Gʉare doreri irasũ ãrĩgʉ̃norẽ wẽjẽdorea. ");
INSERT INTO sri_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ĩgʉ̃sã: “Ĩgʉ̃: ‘Yʉ Marĩpʉ magʉ̃ ããrã’, ãrĩmi”, ãrĩmakʉ̃ pégʉ, Pilato ĩgʉ̃ dupiyuro güiadero nemorõ güimi. ");
INSERT INTO sri_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Irasirigʉ Jesúre dupaturi siiu ñajãa, sẽrẽñayupʉ doja: —¿Noómʉ ããrĩ́rĩ mʉ? ãrĩyupʉ. Jesús gapʉ ĩgʉ̃rẽ neõ yʉjʉbiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ĩgʉ̃ yʉjʉbirimakʉ̃ ĩãgʉ̃, Pilato ĩgʉ̃rẽ ãrĩyupʉ: —¿Nasirigʉ yʉre yʉjʉberi? Yʉ yaarã surarare mʉrẽ peresu ããrĩgʉ̃́rẽ wiudoremakʉ̃, mʉrẽ wiurãkuma, o ĩgʉ̃sãrẽ mʉrẽ curusague pábiatú wẽjẽdoremakʉ̃, mʉrẽ pábiatú wẽjẽrãkuma. ¿Irire masĩberi mʉ? ");
INSERT INTO sri_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús ĩgʉ̃rẽ yʉjʉyupʉ: —Mʉ yʉre irasũ iridoreri, Yʉpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ mʉrẽ pídea ããrã. Irasirigʉ yʉre mʉguere wiadi, mʉ nemorõ waja opami, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pilato Jesúre: “¿Nasiri wiugʉkuri yʉ ĩgʉ̃rẽ?” ãrĩ pémaádiyupʉ. Ĩgʉ̃rẽ irasũ wiudʉamakʉ̃ ĩãrã, judío masaka gapʉ gaguiníma: —Mʉ ĩgʉ̃rẽ wiugʉ, romano marã opʉ merãmʉ ããrĩbirikoa. Sugʉ: “Yʉ judío masaka opʉ ããrã”, ãrĩgʉ̃no romano marã opʉre marĩrẽ doregʉre béodʉagʉ, ĩgʉ̃rẽ ĩãturigʉ yámi, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pilato Jesúre wiigue ããrĩgʉ̃́rẽ ʉ̃tã majĩrĩ merã ĩgʉ̃sã iridea yebague wiriridoremi. Ĩgʉ̃, masaka weresãrĩrẽ beyerimasʉ̃ doarogue eja doami. Iri ʉ̃tã majĩrĩ merã ĩgʉ̃sã iridea yeba, hebreo ya merã Gabata wãĩkʉbʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Irasũ waarínʉ, gʉa pascua bosenʉma baaburi ãmurĩnʉ ããrĩbʉ́. Goeripoe dupiyuro ããrĩbʉ́. Pilato ĩgʉ̃ doarogue eja doa, judío masakare ãsũ ãrĩ weremi: —Ĩĩta ããrĩ́mi mʉsã Opʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, judío masaka gaguiníma: —Boaburo ĩgʉ̃. Boaburo. Curusague pábiatú wẽjẽka ĩgʉ̃rẽ! ãrĩma. Pilato ĩgʉ̃sãrẽ ãrĩmi: —¿Yʉ yaarã surarare mʉsã Opʉre curusague pábiatú wẽjẽdoremakʉ̃ gããmerĩ mʉsã? Paía oparã ĩgʉ̃rẽ yʉjʉma: —Gʉa opʉ, romano marã opʉ ããrĩ́mi. Gajigʉ gʉa opʉ mámi. ");
INSERT INTO sri_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pilato Jesúre ĩgʉ̃sãrẽ wiami, curusague pábiatú wẽjẽdoregʉ. Irasirirã ĩgʉ̃rẽ ãĩãkõãma. ");
INSERT INTO sri_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Irasirigʉ Jesús curusare kõã, “Masakʉ dipuru boaweadea pero” wãĩkʉrogue waami. Hebreo ya merã Gólgota wãĩkʉbʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Irogue eja, Jesúre curusague pábiatúma. Gajirã pẽrãrẽ pábiatúma. Sugʉre ĩgʉ̃ diaye gapʉ, gajigʉre ĩgʉ̃ kúgapʉ curusague pábiatú ãĩwãgũnúma. Jesúre ĩgʉ̃sã deko ãĩwãgũnúma. ");
INSERT INTO sri_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato taboa majĩrẽ ĩgʉ̃ gojadea majĩrẽ curusague Jesús dipuru weka pábiatúdoreyupʉ. Ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Ĩĩ Jesús Nazaretmʉ, judío masaka Opʉ ããrĩ́mi”. ");
INSERT INTO sri_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hebreo ya merã, latín ya merã, griego ya merã gojadea ããrĩbʉ́. Jesúre curusague ĩgʉ̃sã pábiatú ãĩwãgũnúdero, makã pʉrogã ããrĩbʉ́. Irasirirã wárã judío masaka irogue aari, iri gojadeare ĩã buema. ");
INSERT INTO sri_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Paía oparã judío masaka ããrĩsĩã, Pilato gojadeare gããmebiriñurã. Irasirirã ĩgʉ̃rẽ wererã waañurã. Ãsũ ãrĩñurã: —Mʉ: “Ĩĩ judío masaka Opʉ ããrĩ́mi”, ãrĩ gojadeare gorawayuka! Ãsũ gapʉ gojaka: “Ĩĩ: ‘Judío masaka opʉ ããrã’, ãrĩmi”, ãrĩ gojaka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato gapʉ ĩgʉ̃sãrẽ ãrĩyupʉ: —Yʉ gojadeare gorawayubirikoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesúre curusague pábiatú ãĩwãgũnúadero pʉrʉ, wapikʉrã surara ĩgʉ̃ya surí ããrãdeare sea, ĩgʉ̃sãkʉ suñeno dita gãme dʉkawama. Suñe suríro su gasirota suadea suríro, eañeãña marĩrõ merã iridea gasiro ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Iri suríro irasũ ããrĩmakʉ̃ ĩãrã, gãme ãrĩ wereníma: —Iñe surírore yeguebirikõãrã! Ubu ãrĩboka birarã! “¿Noãrẽ dujarokuri?” ãrĩma. Ĩgʉ̃sã irasirimakʉ̃, Marĩpʉya werenírĩ gojadea pũgue gojaderosũta keoro waabʉ. Ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Yaa suríre: ‘¿Noãrẽ dujarokuri?’ ãrĩboka birarãkuma, irire gãme ĩgʉ̃sã basi dʉkawamurã”, ãrĩ gojasũdero ããrĩbʉ́. Iri pũgue gojaderosũta surara irasirima. ");
INSERT INTO sri_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesúya curusa pʉro ĩgʉ̃ pago, igo tĩ́gõ, María Cleofas marãpo, María Magdalena níma. ");
INSERT INTO sri_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús, ĩgʉ̃ pagore, irasũ ããrĩmakʉ̃ yʉ ĩgʉ̃ maĩsũgʉ̃ igo pʉro nímakʉ̃ ĩãgʉ̃, igore ãrĩmi: —Meõ, ĩĩ mʉ magʉ̃ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Irasũ ãrĩ odo, yʉre: —Igo, mʉpo ããrĩ́mo, ãrĩmi. Irasirigʉ Jesús pagore yaa wiigue ãĩa opabʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesús irasũ ãrĩ odo: “Ããrĩpereri Yʉpʉ yʉre iridoregʉ pídeare iripeo odosiáa”, ãrĩ masĩmi. Irasirigʉ ãsũ ãrĩmi: —Ñemesibukoa yʉre. Irire ãrĩgʉ̃, Marĩpʉya werenírĩ gojadea pũgue gojadeare iriyuwarikʉmi. ");
INSERT INTO sri_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Irogue suru borewariru igui deko sʉ̃ĩrĩ deko ʉtʉudiru ããrĩbʉ́. Irasirirã iro ããrĩrã́ Jesús irasũ ãrĩmakʉ̃ pérã, iri igui deko sʉ̃ĩrĩ merã yurayʉsʉ merã yosa, hisopo wãĩkʉdima dʉpʉ yuwague sʉatú, Jesúya disire soemuúma. ");
INSERT INTO sri_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús iri yurayʉsʉ igui deko sʉ̃ĩrĩ yosadeare mimimi. Mimi odo, ãsũ ãrĩmi: —Ããrĩpereri iripeo odosiáa, ãrĩmi. Ire ãrĩgʉ̃ta, ĩgʉ̃ya dipurure mumusiudija, ĩgʉ̃ya yʉjʉpũrãrẽ Marĩpʉre wia, boakõãmi. ");
INSERT INTO sri_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jesús boarinʉ gʉa pascua bosenʉma baaburire ãmurĩnʉ ããrĩbʉ́. Gajinʉ gapʉ gʉa judío masaka siñajãrĩnʉ, irasũ ããrĩmakʉ̃ pascua bosenʉ gʉa iririnʉ, ubu ããrĩrĩ́nʉ meta ããrĩbʉ́. Irinʉrẽ boanerã curusarigue ããrĩmakʉ̃ judío masaka oparã gããmebirima. Irasirirã Pilato pʉrogue ĩgʉ̃rẽ sẽrẽrã waañurã: “Mʉyarã surarare curusarigue pábiatúsũnerãrẽ mata boaburo, ãrĩrã, ĩgʉ̃sãya ñigã gõãrĩ́rẽ pánuadoreka! Pʉrʉ ĩgʉ̃sãya dʉpʉrire ãĩdiju, gajirogue pídoreka!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Irasirirã surara Jesús merã curusarigue pábiatúsũnerãya ñigã gõãrĩ́rẽ pánuama. Sugʉre irasũ iripʉrori, gajigʉdere irasũta irima. ");
INSERT INTO sri_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesús pʉro waa ejanʉgãrã, boadiguere ĩãma. Irasirirã ĩgʉ̃ya ñigã gõãrĩ́rẽ pánuabirima. ");
INSERT INTO sri_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sugʉ surara ĩgʉ̃ya sareri merã Jesúre ĩgʉ̃ya arupãma doka saremi. Ĩgʉ̃ saremakʉ̃, mata ĩgʉ̃ya dí, deko merã wiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yʉ, i waamakʉ̃ ĩãbʉ. Irasirigʉ yʉ i pũrẽ gojagʉ, diayema ããrĩrĩ́rẽ mʉsãrẽ werea. Yʉ ire masĩa. Yʉ ĩãdea diayeta waabʉ. Yʉ wereri diayeta ããrã. Irasirigʉ mʉsãrẽ irire werea, mʉsãde Jesúre bʉremuburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Surara Jesúya ñigã gõãrĩ́rẽ pánuabirimakʉ̃, Marĩpʉya werenírĩ gojadea pũgue ãrĩderosũta waabʉ. Iri pũgue ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Ĩgʉ̃ya gõãrĩ́rẽ, neõ su gõãrẽ pánuabirima”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Gajirogue Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Ĩgʉ̃sã saredire ĩãrãkuma”, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jesús boadero pʉrʉ, José Arimatea wãĩkʉri makãmʉ Pilatore Jesúya dʉpʉre sẽrẽgʉ̃ waayupʉ. José judío masaka oparãrẽ güisĩã, Jesúre bʉremugʉ̃ ããrĩrĩ́rẽ gajirãrẽ werebiridi ããrĩmí. Pilato ĩgʉ̃rẽ: “Jáʉ, ĩgʉ̃ya dʉpʉre ãĩaka!” ãrĩmakʉ̃, José curusa pʉro waa, Jesúya dʉpʉre ãĩdijumi. ");
INSERT INTO sri_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemode wári sʉ̃rõrĩrẽ treinta kilo nʉkʉ̃rĩrẽ ãĩjami, Jesúya dʉpʉre õãrõ ãmubu. Ĩgʉ̃ iro dupiyuro ñami merã Jesúre werenígʉ̃ ejadi ããrĩmí. Ĩgʉ̃ ãĩdea: mirra wãĩkʉri sʉ̃rõrĩ, áloes wãĩkʉri sʉ̃rõrĩ merã morẽdea ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Irasirirã ĩgʉ̃sã pẽrã Jesúya dʉpʉre iri sʉ̃rõrĩ merã piupeo, õãrĩ surí gasiri merã õmama. Judío masaka ĩgʉ̃sã boanerãya dʉpʉre yáaburi dupiyuro ãmunaderosũta irima. ");
INSERT INTO sri_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesúre curusague pábiatú wẽjẽdero pʉro pooe ããrĩbʉ́. Iri pooeguere masãgobe ʉ̃tãyegue mádea gobe ããrĩbʉ́. Iri gobere neõ sugʉ boadire yáabirima dapa. ");
INSERT INTO sri_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Gʉa judío masaka siñajãrĩnʉ ejaburo iribʉ. Irasirirã iri gobe curusa ãĩwãgũnúadero pʉrogã ããrĩmakʉ̃, Jesúya dʉpʉre irogue yáama. ");
INSERT INTO sri_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Judío masaka siñajãrĩnʉ waadero pʉrʉ, boyoburo dupiyurogã María Magdalena ĩgʉ̃sã Jesúya dʉpʉre yáaderogue ĩãgõ waayupo. Irogue ejago, iri gobere biadea ʉ̃tã majĩrẽ bojegue ããrĩmakʉ̃ ĩãyupo. ");
INSERT INTO sri_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Irasirigo, gʉa pẽrã Simón Pedro, irasũ ããrĩmakʉ̃ yʉ Jesús maĩsũgʉ̃ pʉrogue ũmawãgãrimo. Igo gʉa pʉrogue ejago, gʉare ãrĩmo: —Marĩ Opʉya dʉpʉre ãĩkõãnerã ããrãma. Ĩgʉ̃rẽ ĩgʉ̃sã píaderore marĩ masĩbea, ãrĩmo. ");
INSERT INTO sri_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Igo irasũ ãrĩmakʉ̃ pérã, yʉ, Pedro merã ĩgʉ̃sã Jesúya dʉpʉre yáaderogue ĩãrã waabʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Irogue waarã́, gʉa pẽrãgueta ũmawãgãbʉ. Yʉ gapʉ Pedrore ũmatariwãgã, masãgobegue ejapʉroribʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Irogue ejagʉ, iri gobere muúbia ĩã sóobʉ. Irasũ ĩã sóogʉ, Jesúya dʉpʉre õmadea surí gasiri ditare ĩãbʉ. Iri gobegue ñajãbiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mérõgã pʉrʉ Simón Pedro ejami. Irogue eja, iri gobegue ñajãa, ĩgʉ̃de Jesúya dʉpʉre õmadea surí gasiri ditare ĩãmi. ");
INSERT INTO sri_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ĩgʉ̃ya dipurure ĩgʉ̃sã õmadea suríro gasirodere ĩãmi. Iri gasiro túpeasũbʉ. Gaji surí gasiri merã peyabiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pedro irasũ ñajãmakʉ̃ ĩãgʉ̃, yʉde iri gobegue ejapʉroridi ñajãa, iri ditare ĩãgʉ̃, bʉremubʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Gʉa, Jesúya dʉpʉre masãgobegue marĩmakʉ̃ ĩãkererã, Marĩpʉya werenírĩ gojadea pũgue Jesús boadigue masãgʉkumi, ãrĩdeare pémasĩbiribʉ. Keoro waarokoa, ãrĩ gũñabiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Irire ĩã odorã, gʉaya wiigue goedujáakõãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María gapʉ masãgobegueta dujáa, bʉro oreyupo. Oregota, iri gobegue muúbia ĩã sóoyupo. ");
INSERT INTO sri_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Irasũ ĩã sóogo, pẽrã Marĩpʉre wereboerãrẽ boreri surí sãñarãrẽ Jesúya dʉpʉ peyaderogue ĩgʉ̃sã doamakʉ̃ ĩãyupo. Sugʉ, ĩgʉ̃ya dipuru ããrĩdero gapʉ, gajigʉ, ĩgʉ̃ya guburi ããrĩdero gapʉ doañurã. ");
INSERT INTO sri_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ĩgʉ̃sã igore sẽrẽñañurã: —¿Nasirigo orego yári? Igo ĩgʉ̃sãrẽ ãrĩyupo: —Yʉ Opʉya dʉpʉre ãĩkõãnerã ããrãma. Ĩgʉ̃rẽ ĩgʉ̃sã píderore yʉ masĩbea, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Irire ãrĩ odo, gãmenʉgã ĩãgõ, Jesúre iro nímakʉ̃ ĩãyupo. Ĩgʉ̃rẽ ĩãkerego: “Jesúta ããrĩ́mi”, ãrĩ ĩãmasĩbiriyupo. ");
INSERT INTO sri_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús igore ãrĩyupʉ: —¿Nasirigo orego yári? ¿Noãrẽ ãmarĩ? Igo gapʉ: “Ĩĩ, i pooere koregʉ ããrĩkumi”, ãrĩ gũñagõ, ĩgʉ̃rẽ ãrĩyupo: —Mʉ ĩgʉ̃ya dʉpʉre gajirogue ãĩadi, yʉre wereka! ¿Noógue píari? Mʉ weremakʉ̃, ĩgʉ̃ya dʉpʉre ãĩgõ waagoráa. ");
INSERT INTO sri_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Igo irasũ ãrĩmakʉ̃, Jesús igore ãrĩyupʉ: —María. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, gãmenʉgã, hebreo ya merã ĩgʉ̃rẽ: —Rabuni, ãrĩyupo. “Rabuni”, ãrĩrõ, hebreo ya merã: “Buegʉ”, ãrĩdʉaro yáa. ");
INSERT INTO sri_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús igore ãrĩyupʉ: —Yʉre pirika! Yʉpʉ pʉrogue mʉrĩabea dapa. Gajirã yaarã pʉrogue waaka! Ĩgʉ̃sãrẽ ãsũ ãrĩ wereka: “Jesús ãrãmi: ‘Yʉpʉ pʉrogue waabu yáa. Ĩgʉ̃ mʉsãdere mʉsãpʉta ããrĩ́mi. Ĩgʉ̃ yʉ Opʉ, irasũ ããrĩmakʉ̃ mʉsãdere mʉsã Opʉta ããrĩ́mi’, ãrãmi”, ãrĩka ĩgʉ̃sãrẽ! ");
INSERT INTO sri_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégo, María Magdalena gʉa Jesús buerã pʉrogue aari, gʉare igo marĩ Opʉre ĩãdeare, ĩgʉ̃ igore weredoreadeare weremo. ");
INSERT INTO sri_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Irinʉ semana ããrĩpʉrorinʉta ñamigue gʉa Jesús buerã gʉaya wiigue nerẽrã, judío masaka oparãrẽ güirã, makãpʉrorire õãrõ biabʉ. Gʉa irogue ããrĩripoe Jesús gʉa dekogue deyoa, gʉare õãdoregʉ, ãsũ ãrĩmi: —Mʉsã õãrõ siñajãrĩ merã ããrĩrikʉka! ");
INSERT INTO sri_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Irasũ ãrĩ odo, ĩgʉ̃ya mojõrĩrẽ, ĩgʉ̃rẽ arupãma doka sarederore gʉare ĩmumi. Gʉa ĩgʉ̃rẽ marĩ Opʉre ĩãrã, bʉro ʉsʉyabʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dupaturi Jesús gʉare ãrĩmi doja: —Õãrõ siñajãrĩ merã ããrĩrikʉka mʉsã! Yʉpʉ yʉre iriuderosũta yʉde mʉsãrẽ iriua, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Irasũ ãrĩ odo, gʉare puripeo, ãsũ ãrĩmi: —Õãgʉ̃ deyomarĩgʉ̃rẽ bokatĩrĩñeãka, mʉsãrẽ iritamubure! ");
INSERT INTO sri_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mʉsã masakare ĩgʉ̃sã ñerõ irideare kãtimakʉ̃, ĩgʉ̃sã ñerõ irideare kãtisũrãkuma. Mʉsã gajirãrẽ ĩgʉ̃sã ñerõ irideare kãtibirimakʉ̃, ĩgʉ̃sã ñerõ irideare kãtisũbirikuma, ãrĩmi Jesús. ");
INSERT INTO sri_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús gʉare deyoamakʉ̃, Tomás Jesús buegʉ “Sʉdʉadi” ĩgʉ̃sã ãrĩdi gʉa merã ããrĩbirimi. ");
INSERT INTO sri_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pʉrʉ ĩgʉ̃ gʉa merã ããrĩmakʉ̃, ĩgʉ̃rẽ ãrĩbʉ: —Gʉa marĩ Opʉre ĩãbʉ. Tomás gapʉ gʉare ãrĩmi: —Ĩgʉ̃ya mojõrĩgue ĩgʉ̃sã pábiadea goberire ĩãbi, iri goberire yaa mojõsũrũ merã puuñabi, irasũ ããrĩmakʉ̃ ĩgʉ̃ arupãma dokare ĩgʉ̃sã saredea gobere yaa mojõ merã soesóoñabi, ĩgʉ̃ masãdea kerere neõ bʉremubirikoa. ");
INSERT INTO sri_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Su semana Jesús gʉare deyoadero pʉrʉ, gʉa ĩgʉ̃ buerã dupaturi wiigue nerẽbʉ. Iripoere Tomás gʉa merã ããrĩmí. Iri wii biadea wii ããrĩkeremakʉ̃, Jesús ñajãa, gʉa dekogue deyoa, gʉare õãdoregʉ, ãsũ ãrĩmi: —Mʉsã siñajãrĩ merã õãrõ ããrĩrikʉka! ");
INSERT INTO sri_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Irasũ ãrĩ odo, Tomárẽ ãrĩmi: —Ĩãka yaa mojõrĩrẽ! Mʉ mojõsũrũ merã yaa mojõrĩgue ĩgʉ̃sã pábiadea goberire puuñaka! Mʉ mojõ merã yʉ arupãma doka ĩgʉ̃sã saredea gobere soesóoñaka! Yʉ masãdeare: “Diaye ããrĩbea”, ãrĩbirikõãka! “Diaye ããrã”, ãrĩ bʉremuka! ");
INSERT INTO sri_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Tomás ãsũ ãrĩmi: —Mʉ, yʉ Opʉ, yʉ bʉremugʉ̃ ããrã. ");
INSERT INTO sri_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús ĩgʉ̃rẽ ãrĩmi: —Mʉ yʉre ĩãsĩã: “Diayeta boadigue masãdi ããrã”, ãrĩ bʉremua. Gajirã gapʉ yʉre ĩãbirikererã, yʉ boadigue masãdeare bʉremurãkuma. Irasirirã ĩgʉ̃sã bʉro ʉsʉyari merã ããrĩrãkuma, ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús gʉa merã ããrĩgʉ̃́, wári gaji Marĩpʉ turari merã iri ĩmurĩrẽ irimi. Iri ããrĩpereri ĩgʉ̃ irideare i pũguere gojapeobiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Irire gojapeobirikeregʉ, surãyeri Jesús irideare gojáa, ĩgʉ̃ Marĩpʉ iriudi Cristo ããrĩrĩ́rẽ, ĩgʉ̃ diayeta Marĩpʉ magʉ̃ ããrĩrĩ́rẽ bʉremuburo, ãrĩgʉ̃. Irasũ ããrĩmakʉ̃ mʉsã ĩgʉ̃rẽ bʉremurĩ merã okari opaburo, ãrĩgʉ̃, irasũ ãrĩ gojáa. ");
INSERT INTO sri_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pʉrʉ Jesús Tiberias wãĩkʉri ditaru tʉro dupaturi gʉare ĩgʉ̃ buerãrẽ deyoami. Gʉare deyoagʉ ãsũ irimi. ");
INSERT INTO sri_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Gʉa irogue ããrĩrã́ ĩĩsãkʉ ããrĩbʉ́: Simón Pedro, Tomás “Sʉdʉadi” ĩgʉ̃sã ãrĩdi, Natanael Galilea nikũma Caná wãĩkʉri makãmʉ, gʉa pẽrã Zebedeo pũrã, irasũ ããrĩmakʉ̃ gajirã pẽrã ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Gʉa irogue ããrĩripoe Simón Pedro ãrĩmi: —Waaí wẽjẽgʉ̃ waagʉ́ yáa. —Gʉade mʉ merã waarãra, ãrĩbʉ. Irasũ ãrĩ, buáa, doódiru merã waabʉ. Iri ñamirẽ waaí wẽjẽboyotamuakõãdibʉ. ");
INSERT INTO sri_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Boyowãgãriripoe Jesús ditaru tʉro nímakʉ̃ ĩãbʉ. Ĩgʉ̃rẽ ĩãkererã, ĩãmasĩbirikubʉ. ");
INSERT INTO sri_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Irasirigʉ gʉare ãrĩmi: —¿Waaí wẽjẽãrĩ? —Neõ wẽjẽbirakubʉ, ãrĩ yʉjʉbʉ. ");
INSERT INTO sri_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Gʉa irasũ ãrĩmakʉ̃ pégʉ, Jesús ãrĩmi: —Doódiru diaye gapʉ buidire meéyoka! Iro gapʉ waaí wẽjẽrãkoa. Ĩgʉ̃ ãrĩrõsũta meéyomakʉ̃, wárã waaí ñajãma. Wárã waaí ñajãmakʉ̃, buidire doódirugue neõ ãĩsãturabiribʉ. ");
INSERT INTO sri_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Irasũ waamakʉ̃ ĩãgʉ̃, yʉ Jesús maĩsũgʉ̃ Pedrore ãrĩbʉ: —Ĩgʉ̃ta marĩ Opʉ ããrĩ́mi. Yʉ irasũ ãrĩmakʉ̃ pégʉ, Simón Pedro ĩgʉ̃ya wekama surírore túweadi, sãña, ditarugue meébia báwãgãmi. ");
INSERT INTO sri_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Gʉa ĩgʉ̃ merãmarã ditaru tʉrore cien metros yoaro payarã, buidire waaí wárã ñajãdire gʉayaru merã tʉ̃ãnumuabʉ. ");
INSERT INTO sri_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Majãnʉgãrã, peame nitĩ dita gose oyanírĩme weka waairé Jesús mupũnugũnerãrẽ, pã́dere ĩãbʉ. ");
INSERT INTO sri_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús gʉare ãrĩmi: —Gajirã waaí, mérã mʉsã wẽjẽrãrẽ ãĩrika! ");
INSERT INTO sri_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Simón Pedro doódirugue ñajãa, buidire ĩmiparogue tʉ̃ãmajãmi. Pagarã waaí ñajãnerã ciento cincuenta y tres ããrĩmá. Wárã waaí ñajãnerã ããrĩkererã, buidire neõ yeguebirima. ");
INSERT INTO sri_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús gʉare ãrĩmi: —Baa yoberã aarika! Gʉa neõ sugʉno ĩgʉ̃rẽ: “¿Noãno ããrĩ́rĩ mʉ?” ãrĩ sẽrẽñabiribʉ. “Ĩgʉ̃ marĩ Opʉta ããrĩ́mi”, ãrĩ masĩbʉ. ");
INSERT INTO sri_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús peame pʉro waa, pã́, waairé ãĩ, gʉare gueremi. ");
INSERT INTO sri_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesús boadigue masãdero pʉrʉ, pea gʉare deyoasiami. Irasirigʉ ditaru tʉrogue deyoagʉ, ʉrea gʉare ĩgʉ̃ buerãrẽ deyoagʉ irimi. ");
INSERT INTO sri_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gʉa baadero pʉrʉ, Jesús Simón Pedrore sẽrẽñami: —Simón, Jonás magʉ̃, ¿mʉ ĩĩsã nemorõ yʉre maĩrĩ? Pedro ĩgʉ̃rẽ ãrĩmi: —Yʉ Opʉ, mʉrẽ maĩa. Mʉ irire masĩa. Jesús ãrĩmi: —Irasirigʉ ovejare koregʉ oveja majĩrãrẽ õãrõ korerosũta yʉre bʉremurãrẽ majĩrã irirosũ ããrĩrã́rẽ õãrõ koreka! ");
INSERT INTO sri_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Irasũ ãrĩ odo, dupaturi Simón Pedrore sẽrẽñami doja: —Simón, Jonás magʉ̃, ¿yʉre maĩrĩ mʉ? —Yʉ Opʉ, mʉrẽ maĩa. Mʉ irire masĩa, ãrĩmi. Jesús ãrĩmi doja: —Ovejare koregʉ ovejare õãrõ korerosũta yʉre bʉremurãrẽ õãrõ koreka! ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Irasũ ãrĩ odo, dupaturi Simón Pedrore sẽrẽñami: —Simón, Jonás magʉ̃, ¿diayeta yʉre maĩrĩ mʉ? Ʉrea ĩgʉ̃rẽ irasũ sẽrẽñamakʉ̃ pégʉ, Simón Pedro bʉro bʉjawereri merã ããrĩmí. Ĩgʉ̃rẽ ãrĩmi: —Yʉ Opʉ, mʉ ããrĩpereri masĩa. Mʉrẽ yʉ maĩrĩrẽ masĩa. Irasirigʉ Jesús ĩgʉ̃rẽ ãrĩmi: —Ovejare koregʉ ovejare õãrõ kererosũta yʉre bʉremurãrẽ õãrõ koreka! ");
INSERT INTO sri_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Diayeta mʉrẽ werea. Mʉ maamʉ ããrĩgʉ̃́ suríre sãña, mʉ gããmerõ noó waadʉaro waaunabʉ. Pʉrʉ bʉgʉro ããrĩgʉ̃́, mʉya mojõrĩrẽ soemugʉkoa. Gajigʉ mʉrẽ suríre sãgʉkumi. Mʉ waadʉaberogue mʉrẽ ãĩwãgãgʉkumi. ");
INSERT INTO sri_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús, Simón Pedro ĩgʉ̃ boaburi merã masakare Marĩpʉ turagʉ, õãgʉ̃ ããrĩrĩ́rẽ masĩmakʉ̃ iriburire irasũ ãrĩ weremi. Irire were odo, Jesús ĩgʉ̃rẽ ãrĩmi: —Yʉre tʉyaka! ");
INSERT INTO sri_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro gãmenʉgã, yʉ ĩgʉ̃sãrẽ tʉyawãgãmakʉ̃ ĩãmi. Yʉ, Jesús maĩgʉ̃, iro dupiyuro Jesús pʉro baa doanígʉ̃ ĩgʉ̃rẽ: “Yʉ Opʉ, ¿noã mʉrẽ wẽjẽdʉarãguere mʉrẽ ĩmubu ããrĩkuri?” ãrĩ sẽrẽñadi ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro yʉre ĩãgʉ̃, Jesúre sẽrẽñami: —Yʉ Opʉ, ¿naásũ waarokuri ĩgʉ̃rẽ? ");
INSERT INTO sri_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús ĩgʉ̃rẽ ãrĩmi: —Yʉ i ʉ̃mʉguere dupaturi aariripoeta ĩgʉ̃ okamakʉ̃ yʉ iridʉarire, o iridʉabirire mʉya meta ããrã. Irire gũñarikʉbirikõãka! Yʉre tʉyaka! ");
INSERT INTO sri_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesús irasũ ãrĩrĩ kerere pérã, gajirã ĩgʉ̃rẽ bʉremurã: “Juan boabirikumi”, ãrĩ gãme weresirima. Jesús: “Juan boabirikumi”, ãrĩdi meta ããrĩmí. “Yʉ i ʉ̃mʉguere dupaturi aariripoeta ĩgʉ̃ okamakʉ̃ yʉ iridʉarire, o iridʉabirire mʉya meta ããrã”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yʉ Jesús buegʉ, yʉ ĩãdeare i pũrẽ gojáa. Irasirirã mʉsã yʉ gojarire: “Diayeta ããrã”, ãrĩ masĩa. ");
INSERT INTO sri_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús wári gaji irimi. Iri ããrĩpererire yʉ gojapeomakʉ̃, wári pũrĩ ããrĩbukoa. Yʉ péñamakʉ̃, masaka iri pũrĩrẽ i ʉ̃mʉguere duripídʉamakʉ̃, ʉtʉriakõãbukoa. Iropata ããrã. Juan");
INSERT INTO sri_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Opʉ Teófilo, yʉ mʉrẽ gojadupiyudea pũguere Jesús neõgorague irinʉgãdeare, ĩgʉ̃ buedea ããrĩpererire gojabʉ. ");
INSERT INTO sri_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ĩgʉ̃ ʉ̃mʉgasigue mʉrĩaburo dupiyuro Õãgʉ̃ deyomarĩgʉ̃ turaro merã ĩgʉ̃ buedoregʉ beyenerãrẽ: “Ãsũ irirãkoa”, ãrĩ weredeadere gojabʉ. ");
INSERT INTO sri_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús ĩgʉ̃ boa, masãdero pʉrʉ, ĩgʉ̃sãrẽ cuarenta nʉrĩgora deyoayupʉ. Irasirigʉ ĩgʉ̃ dupaturi okarire ĩgʉ̃sãrẽ õãrõ masĩmakʉ̃ iriyupʉ. Marĩpʉ ĩgʉ̃yarãrẽ doreri kerere ĩgʉ̃sãrẽ wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesús ĩgʉ̃sã merã ããrĩgʉ̃́, ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: —Jerusalẽ́ta dujaka dapa! Iripoegue Yʉpʉ: “Õãgʉ̃ deyomarĩgʉ̃rẽ mʉsãrẽ iriugʉra”, ãrĩdeare yúka! Irire weresiabʉ. ");
INSERT INTO sri_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan mʉsãrẽ deko merã wãĩyedi ããrĩmí. Yʉ gapʉ mérõgã pʉrʉ mʉsãrẽ Õãgʉ̃ deyomarĩgʉ̃ merã wãĩyegʉkoa, ĩgʉ̃ mʉsã merã ããrĩníkõãburo, ãrĩgʉ̃, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pʉrʉ ʉ̃tãʉ̃ Olivos wãĩkʉdigue Jesús merã nerẽ, ĩgʉ̃rẽ sẽrẽñañurã: —Gʉa Opʉ, ¿dapagorare gajigʉ gʉaya nikũmʉrẽ gʉare dorebure, opʉ pígʉkuri? ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús ĩgʉ̃sãrẽ yʉjʉyupʉ: —Yʉpʉ sugʉta masĩmi. Ĩgʉ̃ irasũta waaburo, ãrĩmakʉ̃ irasũta waarokoa. Mʉsãya meta ããrã i. ");
INSERT INTO sri_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mérõgã pʉrʉ Yʉpʉ Õãgʉ̃ deyomarĩgʉ̃rẽ iriugʉ, mʉsãrẽ ĩgʉ̃ turarire opamakʉ̃ irigʉkumi. Ĩgʉ̃ irasirimakʉ̃, mʉsã güiro marĩrõ gũñaturari merã masakare yaa kerere wererã waarãkoa. Jerusalén marãrẽ, Judea nikũ marãrẽ, Samaria nikũ marãrẽ, ããrĩperero i nikũgue ããrĩrã́rẽ wererã waarãkoa, ãrĩyupʉ Jesús ĩgʉ̃ buedoregʉ beyenerãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ĩgʉ̃ irasũ ãrĩ wereadero pʉrʉ, Marĩpʉ ʉ̃mʉgasigue ĩgʉ̃rẽ ãĩmʉrĩãkõãyupʉ. Ĩgʉ̃sã ĩgʉ̃rẽ ĩãmutʉyamakʉ̃, su yebo ĩĩmikãyebo túbiakõãyuro. Irasirirã ĩgʉ̃rẽ neõ ĩãnemobiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ĩgʉ̃sã ĩãmutʉyaripoe gũñaña marĩrõ pẽrã ʉ̃ma surí boreri sãñanerã ĩgʉ̃sã pʉro deyoa, ");
INSERT INTO sri_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ãsũ ãrĩñurã: —Galilea marã, ¿nasirirã ʉ̃mʉgasire ĩãmunírĩ? Jesús ʉ̃mʉgasigue mʉrĩagʉta dupaturi i ʉ̃mʉguere aarigʉkumi doja. Mʉsã ĩgʉ̃rẽ mʉrĩãmakʉ̃ ĩãrõsũta aarimakʉ̃ ĩãrãkoa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Irasiri, pʉrʉ Jesús buedoregʉ beyenerã Olivos wãĩkʉdi ʉ̃tãʉ̃gue ããrãnerã dijáa, Jerusalẽ́gue dujáakõãñurã doja. Iri makã pʉrogã ããrĩyuro iri ʉ̃tãʉ̃. ");
INSERT INTO sri_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Dujaja, ĩgʉ̃sã kãrĩrĩ taribu ʉ̃marõma taribugue ñajãkõãñurã. Ĩĩsãkʉ ããrĩñurã: Pedro, Santiago, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Simón celote wãĩkʉri bumʉ, Santiago Alfeo magʉ̃, Judas Santiago magʉ̃ ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gajirãde ĩgʉ̃sã merã nerẽñurã: Jesús pagʉpũrã, Jesús pago María, gajirã nome ããrĩñurã. Ʉ̃mʉrikʉ iri taribugue Marĩpʉre sẽrẽmurã nerẽnañurã. ");
INSERT INTO sri_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sunʉ ĩgʉ̃sã merã gajirã Jesúre bʉremurã ciento veinte gora nerẽñurã. Irasirigʉ Pedro ĩgʉ̃sã watopegue wãgãnʉgã, ĩgʉ̃sãrẽ ãsũ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","—Yaarã, gʉa Judas merã pe mojõma pere su gubu peru pẽrẽbejarãgora ããrãdibʉ. Jesús gʉare beyederosũta ĩgʉ̃dere beyeadimi, gʉa merã ĩgʉ̃ya kerere weredoregʉ. Judas gapʉ Jesúre peresugue ñeãwãgãmurãrẽ ĩgʉ̃rẽ ĩmumi. Õãgʉ̃ deyomarĩgʉ̃ Judas waaburire Davire iripoegue gojadorederosũta diayeta waabʉ. ");
INSERT INTO sri_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ĩgʉ̃ Jesúre oparãguere ĩmudea wajare ĩgʉ̃sãrẽ wia, makã ojarogue waa, dipuru gapʉ merã meémejã, ĩgʉ̃ya paru meé ooreakõã, gʉramisĩ wirisiri kõmoakõãyupʉ. Irasirirã oparã iri niyeru merã ĩgʉ̃ meémejãdea nikũrẽ wajariñurã. ");
INSERT INTO sri_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Judas irasũ waadeare ããrĩpererã Jerusalén marã péperekõãñurã. Irasirirã, ĩgʉ̃ irasũ waaderore: “Acéldama” wãĩyeñurã. “Acéldama”, ãrĩrõ, ĩgʉ̃sã ya merã: “Dí béodero”, ãrĩdʉaro irikoa. ");
INSERT INTO sri_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Iripoegue Salmos wãĩkʉri pũgue ãsũ ãrĩ gojasũdero ããrĩbʉ́ Judare: Ĩgʉ̃ya wii ããrĩdero masaka marĩrõ dujaburo. Neõ sugʉ ĩgʉ̃ ããrĩderore dupaturi ããrĩbirikõãburo, ãrĩ gojasũdero ããrĩbʉ́. Ãsũ ãrĩ gojasũdero ããrĩbʉ́ doja: Gajigʉ ĩgʉ̃ya moãdeare gorawayuburo, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Irasirirã marĩrẽ sugʉ Judas gorawayugʉre beyero gããmea. Sugʉ, gʉa merã ããrĩdire, Juan marĩ Opʉ Jesúre deko merã wãĩyemakʉ̃ ĩãdire, ããrĩpereri Jesús irideare ĩãdire, Marĩpʉ ĩgʉ̃rẽ ʉ̃mʉgasigue ãĩmʉrĩãmakʉ̃ ĩãdire beyero gããmea. Irasirigʉ, Jesús boadigue masãdeare gʉa merã weregʉ waagʉkumi, ãrĩyupʉ Pedro. ");
INSERT INTO sri_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, pẽrãrẽ beyeñurã. Sugʉ José wãĩkʉyupʉ. Gajirã ĩgʉ̃rẽta “Justo”, gajirã “Barsabás” wãĩyenerã ããrĩmá. Gajigʉ Matías wãĩkʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Beye odo, ãsũ ãrĩ sẽrẽñurã Marĩpʉre: —Gʉa Opʉ, mʉ ããrĩpererã masaka gũñarĩrẽ õãrõ masĩa. Judas ĩgʉ̃ dapagora ããrĩrṍgue waagʉ́, mʉya kere weredoredeare pirikõãmi. Sugʉ ĩgʉ̃ gorawayubure beyesiabʉ mʉ. Irasirigʉ mʉ beyeadire ĩmuka gʉare! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Irasũ ãrĩ odo, peye ʉ̃tãyegãgue Matías, José wãĩrẽ goja, puuigãgue sã, suye ãĩ ĩãñurã. Matías wãĩ gojatúadeayere ãĩ bokañurã. Irasirirã Matíare: “Gʉa pe mojõma pere su gubu suru pẽrẽbejarã ããrãnerã merã Jesúya kerere weregʉ waagʉkoa”, ãrĩñurã ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés wãĩkʉri bosenʉ ããrĩmakʉ̃, ããrĩpererã Jesúre bʉremurã ĩgʉ̃sã nerẽdea wiigueta nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pʉrʉ gũñaña marĩrõ ʉ̃mʉgasigue mirũ bʉro aarirósũ, ĩgʉ̃sã ããrĩrṍguere bʉro bʉsʉ dijiriyuro. ");
INSERT INTO sri_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Irasũ waaripoe peame ʉ̃jʉ̃rĩ pũrã dijari, nediru irirosũ deyori masakakʉre dipu weka deyoayuro. ");
INSERT INTO sri_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ããrĩpererã Õãgʉ̃ deyomarĩgʉ̃rẽ opatari, ĩgʉ̃ iritamurĩ merã gaji masã ya ĩgʉ̃sã dupiyuro wereníbirideare werenínʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Iripoere wárã judío masaka ããrĩpereri nikũ marã Jerusalẽ́gue ejanerã ããrĩmá. Ĩgʉ̃sã bʉremurĩrẽ õãrõ tʉyarimasã ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Irasũ bʉsʉrire pérã, Jesúre bʉremurã pʉrogue nerẽwãgãñurã. Irogue masakakʉ ĩgʉ̃sãya werenírĩ merã Jesúre bʉremurã werenímakʉ̃ péñurã. Irasũ waaríre pémasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Irasirirã ĩãgʉka, ãsũ ãrĩ gãme wereníñurã: —¿Nasirirã ĩgʉ̃sã Galilea marã ããrĩkererã, marĩ yare õãrõ werenírĩ? Marĩ deyoadea nikũ marã irirosũ wereníma. ");
INSERT INTO sri_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Marĩ gajiro marã ããrã. Partia marã, Media marã, Elam marã, Mesopotamia marã, Judea marã, Capadocia marã, Ponto marã, Asia marã, ");
INSERT INTO sri_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia marã, Panfilia marã, Egipto marã, Libia Cirene wãĩkʉri nikũ tʉro marã ããrã. Marĩ Roma marãde õõguere naarĩmasã ããrã. ");
INSERT INTO sri_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Surãyeri judío masaka, gajirã judío masaka ããrĩbirikererã, judío masaka irirosũ bʉremurã õõguere ããrã. Creta marã, Arabia marãde marĩ merã ããrĩ́ma. Irasirirã marĩ ããrĩpererã gajiro marã ããrĩkererã, marĩ ya merã ĩĩsã õãrõ werenímakʉ̃ péa. Ĩgʉ̃sã Marĩpʉ õãrõ iridea kerere werenírã yáma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Irasirirã ããrĩpererã pégʉkakõãñurã. —¿Nasiriro irasũ waari? ãrĩ gãme wereníñurã. ");
INSERT INTO sri_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gajirã gapʉ: —Mejãrã yáma, ãrĩ bʉridañurã. ");
INSERT INTO sri_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pedro gajirã pe mojõma pere su gubu suru pẽrẽbejarã Jesús buedoregʉ beyenerã merã wãgãnʉgã, bʉro bʉsʉro wereníyupʉ: —Mʉsã ããrĩpererã judío masaka õõgue Jerusalẽ́gue ããrĩrã́ õãrõ péka yʉ wererire! ");
INSERT INTO sri_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mʉsã gʉare: “Mejãrã yáma”, ãrĩ gũñarã, diaye gũñabea. Goeripoe dupiyuro ããrã dapa. Irasirirã gʉa mejãrã meta yáa. ");
INSERT INTO sri_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gʉa irasũ werenírĩrẽ Joel Marĩpʉya kerere weredupiyudi ãsũ ãrĩ gojadi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","18","Marĩpʉ ãsũ ãrĩmi: “I ʉ̃mʉ pereburo dupiyuro Õãgʉ̃ deyomarĩgʉ̃rẽ iriugʉra, masaka ããrĩpereri buri marãrẽ. Irasirirã mʉsã pũrã ʉ̃ma, nomede yaa kerere wererãkuma. Maamarã kẽrõ irirosũ, mʉrã kẽrõgue yʉ ĩmurĩrẽ ĩãrãkuma. Yʉ dorerire irirãrẽ ʉ̃marẽ, nomedere Õãgʉ̃ deyomarĩgʉ̃rẽ iriugʉra. Irasirirã, yaa kerere wererãkuma. ");
INSERT INTO sri_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yʉ ʉ̃mʉgasiguere gajirosũperi deyoamakʉ̃ irigʉra. I nikũdere dí, peame, ĩĩmikã deyoamakʉ̃ irigʉra. ");
INSERT INTO sri_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Abe ʉ̃mʉmʉ naĩtĩãgʉkumi. Abe ñamimʉ dí irirosũ deyogʉ waagʉkumi. Mʉsã Opʉ i ʉ̃mʉguere dupaturi aariburo dupiyuro irasũ waarokoa. Ĩgʉ̃ aarirínʉ goerinʉ ããrĩrokoa. Ubu ããrĩrĩ́nʉ ããrĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","‘Yʉ Opʉ, tauka yʉre!’ ãrĩgʉ̃norẽ taugʉra”, ãrĩmi Marĩpʉ, ãrĩ gojadi ããrĩmí Joel. ");
INSERT INTO sri_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Mʉsã Israel bumarã yʉ wererire õãrõ péka! Marĩpʉ Jesúre Nazaretmʉrẽ iriudi ããrĩmí. Jesús mʉsã pʉrogue ããrĩgʉ̃́, Marĩpʉ turari merã pũrĩrikʉrãrẽ tau, wãtẽa masakare ñajãnerãrẽ béowiu, boanerãrẽ masũdi ããrĩmí. Irasirigʉ Jesús, Marĩpʉ iriudi ããrĩsĩã, ĩgʉ̃ turari merã irire iri ĩmudi ããrĩmí. Irire mʉsã õãrõ masĩa. ");
INSERT INTO sri_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mʉsã ñerãrẽ ĩgʉ̃rẽ curusague pábiatú wẽjẽdoremakʉ̃, Marĩpʉ iripoegue Jesúre irasũ waarokoa, ãrĩderosũta waabʉ. ");
INSERT INTO sri_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Irasũ waakeremakʉ̃, Marĩpʉ gapʉ ĩgʉ̃ boadiguere masũkõãdi ããrĩmí. Boanerã ããrĩrṍrẽ ĩgʉ̃rẽ wiudi ããrĩmí. Irasirimakʉ̃, boari Jesúre tarinʉgãmasĩbiridero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Iripoegue David ãsũ ãrĩ gojadi ããrĩmí, Jesús Marĩpʉre wereníburire: Yʉ Opʉ, mʉrẽ ĩãníkõãa. Mʉ yʉ diaye gapʉ, yʉ merã ããrĩníkõãa. Irasirigʉ yʉ neõ güibea. ");
INSERT INTO sri_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Yaa yʉjʉpũrãgue bʉro ʉsʉyari merã ããrã. Irasirigʉ ʉsʉyari merã werenía. Yʉ boamakʉ̃, boanerã ããrĩrṍgue béobirikoa. Yʉ masãgobegue ããrĩmakʉ̃, yaa dʉpʉ neõ boabirikoa. Yʉre dupaturi okamakʉ̃ irigʉkoa doja. Irasirigʉ yʉ güiro marĩrõ ããrĩgʉkoa. ");
INSERT INTO sri_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mʉ, yʉ dupaturi okaburire yʉre õãrõ masĩmakʉ̃ yáa. Irasirigʉ yʉ merã mʉ ããrĩmakʉ̃, bʉro ʉsʉyari merã ããrã, ãrĩ gojadi ããrĩmí David. ");
INSERT INTO sri_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Yaarã, yʉ mʉsãrẽ diayeta weregʉra. Marĩ ñekʉ̃ David boadi ããrĩmí. Marĩ ñekʉ̃sãmarã ĩgʉ̃rẽ yáanerã ããrĩmá. Ĩgʉ̃ya masãgobe i makãguere ããrã dapa. ");
INSERT INTO sri_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Iripoegue Marĩpʉ Davire ãsũ ãrĩ weredi ããrĩmí: Yʉ mʉrẽ diayeta werea: “Pʉrʉguere mʉ parãmi i nikũ marã Opʉ ããrĩgʉkumi. Yʉ mʉrẽ píderosũta pígʉkoa ĩgʉ̃dere”, ãrĩdi ããrĩmí. David Marĩpʉya kerere weredupiyugʉ ããrĩdi ããrĩmí. Irasirigʉ Jesúre Marĩpʉ píburire masĩsĩã, ãsũ ãrĩ weredi ããrĩmí ĩgʉ̃ masãburire: Ĩgʉ̃ boadero pʉrʉ, boanerã ããrĩrṍgue neõ béosũbirikumi. Ĩgʉ̃ya dʉpʉ masãgobegue neõ boabirikoa, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Marĩpʉ Jesúre boadiguere masũdi ããrĩmí. Ĩgʉ̃rẽ masũadero pʉrʉ, gʉa ããrĩpererã ĩgʉ̃rẽ ĩãbʉ. “Dupaturi okami”, ãrĩ masĩa. ");
INSERT INTO sri_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ĩgʉ̃ Pagʉ ĩgʉ̃rẽ masũ, ʉ̃mʉgasigue ãĩmʉrĩa, ĩgʉ̃ diaye gapʉ dobodi ããrĩmí. Ĩgʉ̃ ãrĩderosũta Jesúre Õãgʉ̃ deyomarĩgʉ̃rẽ iriudi ããrĩmí. Irasirigʉ Jesús gʉare Õãgʉ̃ deyomarĩgʉ̃rẽ iriumi. Irasirirã mʉsã, ĩgʉ̃ gʉaguere ejamakʉ̃ ĩãa. Ĩgʉ̃ iritamurĩ merã gʉa werenímakʉ̃ péa. ");
INSERT INTO sri_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","David gapʉ ĩgʉ̃ boadero pʉrʉ, Jesús mʉrĩaderosũ mʉrĩabiridi ããrĩmí. Ĩgʉ̃ boaburo dupiyuro ãsũ ãrĩ gojadi ããrĩmí, Marĩpʉ Jesúre ãrĩdeare gojagʉ: Marĩpʉ yʉ Opʉre ãsũ ãrĩmi: “Õõ yʉ diaye gapʉ doaka, yʉ merã dorebu! Irasiriripoe mʉrẽ ĩãturirãrẽ mʉ dorerire tarinʉgãnemobirimakʉ̃ irigʉra”, ãrĩmi, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Irasirirã mʉsã Israel bumarã ããrĩpererã õãrõ pémasĩka! Marĩpʉ Jesúre, mʉsã curusague pábiatú wẽjẽdire marĩ Opʉ ããrĩmakʉ̃ iridi ããrĩmí. Marĩpʉ ĩgʉ̃rẽ iriudi ããrĩmí, marĩrẽ tauburo, ãrĩgʉ̃, ãrĩ wereyupʉ Pedro masakare. ");
INSERT INTO sri_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sãya yʉjʉpũrãrĩgue bʉro bʉjawereri merã gũñarikʉ, Pedrore, gajirã Jesús buedoregʉ beyenerãrẽ ãsũ ãrĩ sẽrẽñañurã: —Gʉayarã, ¿nasirirãkuri gʉa? ");
INSERT INTO sri_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro ĩgʉ̃sãrẽ yʉjʉyupʉ: —Mʉsã ñerõ irideare bʉjawere, mʉsã gũñarĩrẽ gorawayuka! Irasirirã mʉsã ããrĩpererã Jesucristore bʉremua, ãrĩ, gʉare deko merã wãĩyedoreka! Mʉsã irasirimakʉ̃, Marĩpʉ mʉsã ñerõ irideare kãtigʉkumi. Õãgʉ̃ deyomarĩgʉ̃rẽ iriugʉkumi, mʉsã merã ããrĩníkõãburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Marĩpʉ ãrĩderosũta mʉsãrẽ, mʉsã pũrã ããrĩturiarãrẽ, gajiro marãdere ããrĩpererã ĩgʉ̃ beyenerãrẽ Õãgʉ̃ deyomarĩgʉ̃rẽ iriugʉkumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Irire ãrĩ odo, gaji wári werenemoyupʉ Pedro ĩgʉ̃sãrẽ: —Õãrõ pémasĩka mʉsã! I nikũ marã Jesúre wẽjẽnerã ñerã ããrĩ́ma. Ĩgʉ̃sã ñerõ iridea waja Marĩpʉ ĩgʉ̃sãrẽ wajamoãgʉkumi. Ĩgʉ̃sã ñerã irirosũ neõ irinemobirikõãka pama! Irasiribirimakʉ̃, Marĩpʉ ĩgʉ̃sãrẽ wajamoãgʉ̃, mʉsã gapʉre wajamoãbirikumi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wárã ĩgʉ̃ wererire õãrõ péñurã. Irasirirã deko merã wãĩyesũñurã Jesúre bʉremurĩrẽ ĩmurã. Irasirirã Jesúre bʉremupʉrorinerã merã ããrĩnʉgãñurã. Pedro ĩgʉ̃sãrẽ wereadeanʉ merãta wárã tres mil gora masaka bʉremunʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Irasirirã ʉ̃mʉrikʉ Jesúre bʉremupʉrorinerã merã nerẽnañurã, ĩgʉ̃ buedoregʉ beyenerã buerire pémurã. Irasũ nerẽnarã, Marĩpʉre sẽrẽ, pã́rẽ dʉkawa, siiu baanañurã. ");
INSERT INTO sri_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesús buedoregʉ beyenerã ĩgʉ̃ iriderosũta wári Marĩpʉ turari merã iri ĩmunañurã. Irasirirã pũrĩrikʉrãrẽ tau, wãtẽa masakare ñajãnerãrẽ béowiu, boanerãrẽ masũnañurã. Ĩgʉ̃sã irasirimakʉ̃ ĩãrã, masaka ããrĩpererã ĩãgʉkanañurã. ");
INSERT INTO sri_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ããrĩpererã Jesúre bʉremurã su bumarã irirosũ õãrõ ããrĩrikʉñurã. Irasirirã ĩgʉ̃sã oparire gãme sĩnañurã. ");
INSERT INTO sri_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Gajinorẽ oparã, irire dua, iri waja merã gajino opamerãrẽ sĩnañurã. ");
INSERT INTO sri_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ʉ̃mʉrikʉ ããrĩpererã surosũ gũñarĩ oparã Marĩpʉya wiigue nerẽnañurã. Ĩgʉ̃sãya wiirigue pã́rẽ dʉkawa, õãrõ ʉsʉyari merã siiu baanañurã. ");
INSERT INTO sri_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Marĩpʉre: “Õãtaria mʉ”, ãrĩ, ʉsʉyari sĩnañurã. Gajirã masaka ĩgʉ̃sãrẽ: “Õãrã ããrĩ́ma”, ãrĩ ĩãñurã. Ʉ̃mʉrikʉ marĩ Opʉ Jesús gajirãrẽ ĩgʉ̃rẽ bʉremumakʉ̃ iriyupʉ. Irasirirã ĩgʉ̃rẽ bʉremurã wárã ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sunʉ, ñamika tres ããrĩmakʉ̃ Pedro, Juan merã Marĩpʉya wiigue waañurã. Iri horata masaka Marĩpʉre sẽrẽnañurã. ");
INSERT INTO sri_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Iri wiima makãpʉrore sugʉ masakʉ deyoagʉgueta waamasĩbi ããrĩdi doayupʉ. Iri makãpʉro: “Õãrĩ makãpʉro” wãĩkʉyuro. Ʉ̃mʉrikʉ ĩgʉ̃ merãmarã ĩgʉ̃rẽ ãĩwãgã, iri makãpʉrogue dobonañurã, iri wii ñajãrãrẽ niyeru sẽrẽ doanídorerã. ");
INSERT INTO sri_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedrosã iri wii ñajãmurã iriripoe ĩgʉ̃sãrẽ ĩã, niyeru sẽrẽyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ĩgʉ̃sã pẽrãgueta ĩgʉ̃rẽ ĩã, Pedro gapʉ ĩgʉ̃rẽ ãrĩyupʉ: —Gʉare ĩãka! ");
INSERT INTO sri_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ĩgʉ̃ irasũ ãrĩmakʉ̃: “Yʉre niyeru sĩmurã irikuma”, ãrĩ gũñarĩ merã bʉro ĩãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro gapʉ ĩgʉ̃rẽ ãrĩyupʉ: —Niyerure opabea. Irire opabirikeregʉ, yʉ opari merã mʉrẽ iritamugʉra. Jesucristo Nazaretmʉ wãĩ merã, ĩgʉ̃ turaro merã wãgãnʉgã waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro ĩgʉ̃rẽ irasũ ãrĩgʉ̃ta, diayema mojõrẽ ñeã, tʉ̃ãwãgũnúyupʉ. Irasirimakʉ̃ta, ĩgʉ̃ya guburi, ĩgʉ̃ya ãñagubuyeri turanʉgãjayuro. ");
INSERT INTO sri_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Irasirigʉ pari wãgãnʉgãja, waapʉrori, pʉrʉ ĩgʉ̃sã merã Marĩpʉya wiigue Marĩpʉre: “Õãtaria mʉ”, ãrĩ gaguiní, pariñajãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Ĩgʉ̃ ʉsʉyari merã Marĩpʉre: “Õãtaria mʉ”, ãrĩ, pariñajãmakʉ̃ ĩãrã, iri wiigue ããrĩrã́ ããrĩpererã ĩgʉ̃rẽ ĩãmasĩ: —Ĩĩ, i wii õãrĩ makãpʉrogue niyeru sẽrẽ doaníadita ããrĩ́mi, ãrĩñurã. Irasirirã ĩgʉ̃ waamasĩmakʉ̃ ĩãrã, “¿Naásũ waari?” ãrĩ ĩãgʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Waamasĩbiradi Pedrosãrẽ duúbirimakʉ̃, ããrĩpererã masaka iri wii ããrĩrã́ ĩãgʉkari merã, ĩgʉ̃sã pʉrogue “Pórtico de Salomón” wãĩkʉrogue ũmanerẽñurã. ");
INSERT INTO sri_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ĩgʉ̃sã irasũ ũmanerẽmakʉ̃ ĩãgʉ̃, Pedro ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã, Israel bumarã, ¿nasirirã iropa gʉkari? ¿Nasirirã gʉare bʉro ĩãrĩ? “Ĩgʉ̃sã Marĩpʉre bʉremurĩ merã, ĩgʉ̃sã turaro merã ĩĩrẽ waamasĩmakʉ̃ iriama”, ãrĩ gũñabirikõãka! ");
INSERT INTO sri_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Jesús ĩgʉ̃ turaro merã ĩgʉ̃rẽ waamasĩmakʉ̃ iriami. Marĩ ñekʉ̃sãmarã Abraham, Isaac, Jacob Marĩpʉre ʉ̃mʉgasigue ããrĩgʉ̃́rẽ bʉremunerã ããrĩmá. Marĩpʉ ĩgʉ̃ magʉ̃ Jesúre, ĩgʉ̃ doreri õãrõ iridire: “Õãtarigʉ ããrĩ́mi”, ãrĩdi ããrĩmí. Mʉsã gapʉ ĩgʉ̃rẽta oparãguere wiabʉ. Pilato ĩgʉ̃rẽ wiudʉakeremakʉ̃, mʉsã gapʉ gããmebiribʉ. ");
INSERT INTO sri_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesús õãgʉ̃, ñerĩrẽ neõ iribi ããrĩkeremakʉ̃, ĩgʉ̃rẽ neõ wiudorebiribʉ. Sugʉ ñegʉ̃ masakare wẽjẽdi gapʉre wiudorebʉ mʉsã. ");
INSERT INTO sri_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Irasirirã, Jesús marĩrẽ okari sĩgʉ̃ gapʉre wẽjẽdorebʉ. Ĩgʉ̃ boadero pʉrʉ, Marĩpʉ gapʉ ĩgʉ̃rẽ masũdi ããrĩmí. Gʉa ĩgʉ̃rẽ Marĩpʉ masũdire ĩãbʉ, ãrĩ masĩa. ");
INSERT INTO sri_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesúta ĩgʉ̃ turaro merã ĩĩ waamasĩbiradire mʉsã ĩãmasĩgʉ̃rẽ waamasĩmakʉ̃ iriami. Gʉa Jesús taumasĩrĩrẽ bʉremumakʉ̃ ĩãgʉ̃, ĩgʉ̃rẽ tauami. Mʉsã ããrĩpererã ĩgʉ̃ tauadire ĩgʉ̃ waamasĩmakʉ̃ ĩãa. ");
INSERT INTO sri_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Yaarã, mʉsã, mʉsã oparãde Jesúre: “Marĩpʉ magʉ̃ta ããrĩ́mi”, ãrĩ pémasĩbirisĩã, ĩgʉ̃rẽ wẽjẽdorebʉ. ");
INSERT INTO sri_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Iripoegue Marĩpʉ ĩgʉ̃ya kerere weredupiyunerã ããrĩpererãrẽ: “Cristo yʉ iriubu ñerõ tarigʉkumi”, ãrĩderosũta Jesúre waabʉ. ");
INSERT INTO sri_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Irasirirã mʉsã ñerõ irideare bʉjawere, mʉsã gũñarĩrẽ gorawayuka! Marĩpʉ dorerire irika! Irasirimakʉ̃, Marĩpʉ mʉsãrẽ mʉsã ñerõ irideare kãti, siñajãrĩ merã ããrĩrikʉmakʉ̃ irigʉkumi. ");
INSERT INTO sri_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Irasirigʉ mʉsãrẽ Cristore dupaturi iriugʉkumi. Cristo, Marĩpʉ beyedi mʉsãrẽ taugʉ, Jesúta ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesucristo ʉ̃mʉgasigue mʉrĩadi, irogueta ããrĩ́mi dapa. Marĩpʉ iripoegue ĩgʉ̃ iriburire ĩgʉ̃ya kerere weredupiyunerãrẽ weredorederosũta ããrĩpererire õãrõ ãmu, pʉrʉ Jesúre iriugʉkumi. ");
INSERT INTO sri_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Iripoegue Moisés irimarẽ marĩ ñekʉ̃sãmarãrẽ ãsũ ãrĩdi ããrĩmí: Pʉrʉgue Marĩpʉ marĩ Opʉ sugʉ ĩgʉ̃ya kerere werebure iriugʉkumi. Yʉre iriuderosũta ĩgʉ̃dere iriugʉkumi. Ĩgʉ̃de marĩyagʉta ããrĩgʉkumi. Ããrĩpereri ĩgʉ̃ wererire péka! Ĩgʉ̃ dorerire õãrõ iritʉyaka! ");
INSERT INTO sri_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ĩgʉ̃ dorerire iritʉyamerã gapʉ béosũrãkuma. Irasirirã Marĩpʉyarã merã neõ ããrĩnemobirikuma pama, ãrĩdi ããrĩmí Moisés. ");
INSERT INTO sri_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ããrĩpererã iripoegue marã Marĩpʉya kerere weredupiyunerãkʉ, Samuel pʉrʉ marãde dapagora waaríre irasũta ãrĩ gojanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Iripoegue Marĩpʉ marĩ ñekʉ̃ Abrahãrẽ: “Yʉ, mʉ parãmi ããrĩturiagʉ merã i ʉ̃mʉ marã ããrĩpererãrẽ õãrõ irigʉra”, ãrĩdi ããrĩmí. Ĩgʉ̃ya kerere weredupiyunerãrẽ ĩgʉ̃ Abrahãrẽ ãrĩdeare weredoredi ããrĩmí marĩ ñekʉ̃sãmarãrẽ. Irasirigʉ Marĩpʉ ĩgʉ̃sãrẽ ãrĩderosũta mʉsãrẽ iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Irasirigʉ ĩgʉ̃ magʉ̃ Jesús boadiguere masũ, marĩrẽ judío masakare iriupʉroridi ããrĩmí, marĩrẽ õãrĩ gapʉre iri, marĩ ñerõ iririre piriburo, ãrĩgʉ̃, ãrĩ wereyupʉ Pedro ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Pedro, Juan merã masakare wereníripoe paía, Marĩpʉya wii korerã surara opʉ, gajirã saduceo bumarã ejañurã. Pedrosã masakare: “Jesús boadero pʉrʉ masãdi ããrĩmí. Irasirirã marĩde boadero pʉrʉ ããrĩpererã masãrãkoa”, ãrĩ buenañurã. Ĩgʉ̃sã irasũ ãrĩ buemakʉ̃ pérã, saduceo bumarã, masaka boanerã masãrĩrẽ bʉremubirisĩã, ĩgʉ̃sã merã bʉro guañurã. ");
INSERT INTO sri_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Irasirirã abe ñajãripoe ããrĩmakʉ̃, Pedrosãrẽ ñeã, iri ñamirẽ peresu iriñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Irasirikeremakʉ̃, gajirã wárã Jesúya kerere pénerã, ĩgʉ̃rẽ bʉremunʉgãrã ããrĩñurã. Irasirirã dupiyurogue Jesúre bʉremupʉrorinerã merã wárã ããrĩñurã. Ʉ̃ma ditare keomakʉ̃, cinco mil ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pedrosãrẽ peresu iriadero pʉrʉ, gajinʉ gapʉ Jerusalẽ́gue judío masaka oparã, gajirã mʉrã, gajirã Moisés gojadeare buerimasã nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gajirãde, paía opʉ Anás, Caifás, Juan, Alejandro, gajirã paía opʉyarã ĩgʉ̃sã merã ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Irogue nerẽ, Pedrosãrẽ ĩgʉ̃sã pʉro ãĩridore, ĩgʉ̃sã ejamakʉ̃: —¿Noã mʉsãrẽ doreri, noã mʉsãrẽ inorẽ irasiridoreri? ãrĩ sẽrẽñañurã. ");
INSERT INTO sri_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Pedro Õãgʉ̃ deyomarĩgʉ̃rẽ opatarisĩã, ãsũ ãrĩ yʉjʉyupʉ ĩgʉ̃sãrẽ: —¿Mʉsã judío masaka oparã, mʉrãde gʉare ĩĩ waamasĩbiradire õãrõ iriadeare, ĩgʉ̃rẽ tauadeare sẽrẽñarã yári? ");
INSERT INTO sri_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mʉsãrẽ ire weregʉra, ããrĩpererã Israel bumarã õãrõ pémasĩburo, ãrĩgʉ̃. Jesucristo Nazaretmʉ turaro merã, ĩgʉ̃ wãĩ merã ĩĩ waamasĩbiradi waamasĩami. Mʉsã ĩgʉ̃rẽta curusague pábiatú wẽjẽdorebʉ. Ĩgʉ̃ boadero pʉrʉ, Marĩpʉ gapʉ ĩgʉ̃rẽ masũ, dupaturi okamakʉ̃ iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iripoegue Marĩpʉya kerere weredupiyudi ãsũ ãrĩ gojadi ããrĩmí: “Suye ʉ̃tãye wii iririmasã ĩgʉ̃sã béoadeaye merã gajigʉ gapʉ õãrõ turari wii irigʉkumi”, ãrĩ gojadi ããrĩmí. Jesús iri ʉ̃tãye ĩgʉ̃sã béoadeaye irirosũ ããrĩ́mi. Marĩpʉ ĩgʉ̃rẽ beyedi ããrĩmí marĩrẽ taubure. ");
INSERT INTO sri_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","I nikũguere Jesús sugʉta marĩrẽ taugʉ ããrĩ́mi. Gajigʉ marĩrẽ taugʉ neõ mámi. Marĩpʉ ĩgʉ̃rẽta iriudi ããrĩmí marĩrẽ taubure, ãrĩ wereyupʉ Pedro ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Judío masaka oparã Pedro, Juan buebirinerã ããrĩkererã, õãrõ gũñaturari merã, pémasĩrĩ merã weremakʉ̃ pérã, pégʉkakõãñurã. Ĩgʉ̃sãrẽ: “Diayeta Jesús merãmarãta ããrĩ́ma”, ãrĩ ĩãmasĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Waamasĩbiradi Pedrosã pʉro nímakʉ̃ ĩãrã, ĩgʉ̃sãrẽ: “Ñerõ irirã iriabʉ”, ãrĩ werewʉamasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Irasirirã, ĩgʉ̃sãrẽ ĩgʉ̃sã nerẽrĩ taribugue ããrĩrã́rẽ wiriadoreñurã, ĩgʉ̃sã basi gãme werenímurã: ");
INSERT INTO sri_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ãsũ ãrĩñurã: —¿Nasirirãkuri ĩgʉ̃sãrẽ? Ĩĩ waamasĩbiradire ĩgʉ̃sã waamasĩmakʉ̃ iriadeare Jerusalén marã pépereakõãñurã. Irasirirã: “Iribirama”, ãrĩmasĩbirikoa marĩ. ");
INSERT INTO sri_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Gajirãrẽ irire neõ pénemomakʉ̃ iribirikõãrõ gããmea marĩrẽ. Irasirirã: “Jesúyamarẽ gajirãguere neõ werenemobirikõãka pama!” ãrĩrã ĩgʉ̃sãrẽ, ãrĩ wereníñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Irasũ ãrĩ werení odo, Pedrosãrẽ siiu, ãsũ ãrĩñurã: —Gajirãguere neõ Jesúyamarẽ werenemobirikõãka! Neõ ĩgʉ̃ya kerere buenemobirikõãka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ĩgʉ̃sã irasũ ãrĩkeremakʉ̃, Pedro, Juan gapʉ ãsũ ãrĩ yʉjʉñurã ĩgʉ̃sãrẽ: —¿Marĩpʉ mʉsã gʉare dorerire irimakʉ̃ gããmerĩ, o ĩgʉ̃ doreri gapʉre gʉa irimakʉ̃ gããmerĩ? ¿Naásũ gũñarĩ mʉsã irire? ");
INSERT INTO sri_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gʉa ĩgʉ̃ dorerire iritʉyarã ããrã. Irasirirã gʉa ĩãdeare, gʉa pédeare neõ wereduúmasĩña máa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, judío masaka oparã gapʉ dupaturi ãrĩñurã: —Jesúyamarẽ neõ werenemomerãta pama! Irire pirimerã, wajamoãsũrãkoa, ãrĩñurã. Gajirã gapʉ ʉsʉyari merã Marĩpʉre: “Mʉ ĩĩ waamasĩbiradire tauadea õãtariabʉ”, ãrĩñurã. Ĩgʉ̃ cuarenta bojori nemorõ opagʉ ããrĩyupʉ. Irasirirã oparã gapʉ Pedrosãrẽ: “Ñerõ irirã iriama”, ãrĩmasĩbiri, wajamoãmerãta ĩgʉ̃sãrẽ wiukõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedrosã irogue ããrãnerã wiria, ĩgʉ̃sã merãmarã pʉrogue waakõãñurã. Irogue eja, paía oparã, judío masaka mʉrã ĩgʉ̃sãrẽ ãrãdeare ĩgʉ̃sã merãmarãrẽ wereñurã. ");
INSERT INTO sri_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ĩgʉ̃sã weremakʉ̃ pérã, ããrĩpererã iro ããrĩrã́ Marĩpʉre sẽrẽñurã: —Gʉa Opʉ, mʉ diayeta ʉ̃mʉgasi, i nikũ, dia wádiya, i ʉ̃mʉma ããrĩpererire iridi ããrã. ");
INSERT INTO sri_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Iripoegue gʉa ñekʉ̃ Davire mʉrẽ moãboegʉre Õãgʉ̃ deyomarĩgʉ̃ merã ãsũ ãrĩ weredoredi ããrĩbʉ́: Judío masaka ããrĩmerã Marĩpʉ merã bʉro guama. Israel bumarãde Marĩpʉyare: “Gããmebea”, ãrĩ gũñadima. ");
INSERT INTO sri_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","I nikũ marã oparã Marĩpʉ merã gãmekẽãdʉarã nerẽrãkuma. Ĩgʉ̃ beyedi merãdere irasũta gãmekẽãrãkuma, ãrĩ weredoredi ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Mʉ weredorederosũta diayeta waabʉ. I makãguere opʉ Herodes, Poncio Pilato, gajirã Israel bumarã, gajirã judío masaka ããrĩmerã nerẽma Jesús mʉ magʉ̃rẽ wẽjẽmurã. Ĩgʉ̃ õãgʉ̃, mʉ beyedi ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Irasirirã, iripoegue mʉ turaro merã mʉ beyedire: “Irasũ waarokoa ĩgʉ̃rẽ”, ãrĩderosũta irima. ");
INSERT INTO sri_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gʉa Opʉ, dapagora paía oparã mʉya kerere: “Werebirikõãka! Mʉsã irire wererã, wajamoãsũrãkoa”, ãrãma gʉare. Ĩgʉ̃sã irasũ ãrãdeare gũñaka mʉ! Gʉa mʉrẽ moãboerã ããrã. Irasirigʉ gʉare mʉyare gajirãrẽ güiro marĩrõ weremakʉ̃ irika! ");
INSERT INTO sri_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gʉare mʉ turaro merã pũrĩrikʉrãrẽ taumakʉ̃ irika! Irasirigʉ gʉare mʉ turaro merã Jesús mʉ magʉ̃, õãgʉ̃ wãĩ merã iri ĩmurĩrẽ irimakʉ̃ irika! ãrĩ sẽrẽñurã Marĩpʉre. ");
INSERT INTO sri_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ĩgʉ̃sã irasũ ãrĩ sẽrẽadero pʉrʉ, ĩgʉ̃sã ããrĩrĩ́ wii gãmeñayuro. Ããrĩpererã Õãgʉ̃ deyomarĩgʉ̃rẽ opatariñurã. Irasirirã, ĩgʉ̃ iritamurĩ merã güiro marĩrõ Marĩpʉya kerere wererã waañurã. ");
INSERT INTO sri_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","33","Irasirirã Jesús buedoregʉ beyenerã Marĩpʉ turaro merã masakare: “Marĩ Opʉ Jesús boadero pʉrʉ masãdi ããrĩmí. Ĩgʉ̃ dupaturi okadero pʉrʉ, gʉa ĩgʉ̃rẽ ĩãbʉ”, ãrĩ wereñurã. Ããrĩpererã Jesúre bʉremurã surosũ gũñañurã. Irasirirã ĩgʉ̃sã oparire: “Yaa ããrã”, ãrĩrõ marĩrõ gãme dʉkawañurã. Marĩpʉ ĩgʉ̃sãrẽ ããrĩpererãrẽ õãrõ iritamuyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Irasirirã wiiri oparã, nikũ oparã, gajirãrẽ irire duañurã. Ĩgʉ̃sã duadea wajare Jesús buedoregʉ beyenerãrẽ sĩnañurã. Jesús buedoregʉ beyenerã irire ĩgʉ̃sã watope ããrĩrã́rẽ gajino opamerãrẽ dʉkawañurã. Irasirirã ĩgʉ̃sã watopegue boporã marĩñurã pama. ");
INSERT INTO sri_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iripoere sugʉ Jesúre bʉremugʉ̃ José wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃ Chipre wãĩkʉri nʉgʉ̃rõmʉ, Levíya bumʉ ããrĩyupʉ. Jesús buedoregʉ beyenerã ĩgʉ̃rẽ “Bernabé” wãĩyeñurã. “Bernabé”, ãrĩrõ, griego ya merã: “Masakare õãrõ yʉjʉpũrãkʉmakʉ̃ irigʉ”, ãrĩdʉaro irikoa. ");
INSERT INTO sri_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ĩgʉ̃ nikũ opagʉ ããrĩsĩã, su pooe ejatuaro gajirãrẽ duayupʉ. Ĩgʉ̃ duadea wajare Jesús buedoregʉ beyenerãrẽ sĩpeokõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gajigʉ Ananías wãĩkʉgʉ ĩgʉ̃ marãpo Safira merã su pooe ejatuaro nikũrẽ duayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ĩgʉ̃ duadea wajare ĩgʉ̃ basi deko merã duripíkõãyupʉ. Irasirigʉ ããrĩpereri niyerure Jesús buedoregʉ beyenerãrẽ sĩpeobirikeregʉ: “Iropata wajariama”, ãrĩkatoyupʉ. Ĩgʉ̃ marãpo ããrĩpereri ĩgʉ̃ irasiriadeare masĩyupo. ");
INSERT INTO sri_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro ãsũ ãrĩyupʉ ĩgʉ̃rẽ: —Ananías, ¿nasirigʉ wãtĩrẽ mʉya gũñarĩguere ñajãdoreari? Ĩgʉ̃ ñajãmakʉ̃ta, mʉya nikũ duadea wajare gʉare sĩpeobirikeregʉ, mʉ Õãgʉ̃ deyomarĩgʉ̃rẽ ãrĩkatoa. ");
INSERT INTO sri_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Iri nikũ mʉ duaburo dupiyuro mʉya nikũ ããrĩbʉ́. Mʉ duadea waja mʉya niyeruta ããrã. Noó mʉ sĩdʉaropa sĩboakuyo. ¿Nasiribu irasũ ãrĩkatori? Gʉa ditare ãrĩkatogʉ meta yáa. Marĩpʉdere ãrĩkatoa mʉ, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, mata Ananías meémejã kõmoakõãyupʉ. Ĩgʉ̃ irasũ waadea kerere pérã, ããrĩpererã bʉro güiñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ĩgʉ̃ kõmoadero pʉrʉ, gajirã maamarã ñajãja, ĩgʉ̃ya dʉpʉre suríro gasiro merã õma, ãĩwiriakõãñurã ĩgʉ̃rẽ yáarã waarã́. ");
INSERT INTO sri_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ʉre hora pʉrʉ, Ananías marãpo ããrãdeo ñajãjayupo. Ĩgʉ̃ boadeare neõ masĩbiriyupo. ");
INSERT INTO sri_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Igo ñajãmakʉ̃ ĩãgʉ̃, Pedro igore sẽrẽñayupʉ: —Wereka yʉre! ¿Mʉsãya pooere duarã, iropata niyeru wajatari mʉsã? ãrĩyupʉ. Igo ĩgʉ̃rẽ yʉjʉyupo: —Iropata wajatabʉ, ãrĩyupo. ");
INSERT INTO sri_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro ãrĩyupʉ igore: —¿Nasirirã mʉsã, marĩ Opʉ Õãgʉ̃ deyomarĩgʉ̃rẽ ãrĩkatoari? “Gʉa irasirimakʉ̃ masĩbirikumi”, ¿ãrĩ gũñadari mʉsã? Ĩãka! Mʉ marãpʉre yáarã ejanerã sĩĩsã dujarima. Mʉya dʉpʉdere ãĩwiriarãkuma, mʉ marãpʉya dʉpʉre ãĩwiriaderosũta, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, igode Pedroya guburi pʉro meémejã kõmoakõãyupo. Irasirirã maamarã igo kõmoadeoguere bokaja, igoya dʉpʉre ãĩwiria, igo marãpʉ dagʉre ĩgʉ̃sã yáadero pʉrogueta igodere yáañurã. ");
INSERT INTO sri_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Irasirirã ããrĩpererã Jesúre bʉremurã, gajirãde Ananías, Safirare waadea kerere pérã, bʉro güiñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iripoere masaka watopegue Jesús buedoregʉ beyenerãrẽ Marĩpʉ ĩgʉ̃ turari merã wári iri ĩmurĩrẽ irimakʉ̃ iriyupʉ. Ããrĩpererã Jesúre bʉremurã Marĩpʉya wii tʉro biaña marĩrĩ taribu “Pórtico de Salomón” wãĩkʉri taribugue nerẽnañurã. ");
INSERT INTO sri_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Masaka ĩgʉ̃sãrẽ: “Õãrã ããrĩ́ma”, ãrĩkeremakʉ̃, gajirã gapʉ ĩgʉ̃sãrẽ güiñurã. Ĩgʉ̃sã merã neõ nerẽdʉabiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Gajirã gapʉ marĩ Opʉ Jesúre wárã ʉ̃ma, nomede bʉremuñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Irasirirã pũrĩrikʉrãrẽ ĩgʉ̃sã peyari gasiri merã Pedro waaburi maa tʉro píñurã. “Pedro ĩgʉ̃sãrẽ ñapeobirikeremakʉ̃, ĩgʉ̃ wãtĩ meépíro ĩgʉ̃sã weka ejamakʉ̃, ĩgʉ̃sãrẽ pũrĩrĩ tarirokoa”, ãrĩ gũñarã, irasiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wárã Jerusalén tʉro marãde pũrĩrikʉrãrẽ, wãtẽa ñajãsũnerãrẽ irogue ãĩãnañurã. Irasirirã Jesús buedoregʉ beyenerã ĩgʉ̃sã ããrĩpererãrẽ taunañurã. ");
INSERT INTO sri_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Irasirirã paía opʉ, gajirã ĩgʉ̃ merãmarã saduceo bumarãde Jesús buedoregʉ beyenerãrẽ bʉro ĩãturi, ");
INSERT INTO sri_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ĩgʉ̃sã merã bʉro gua, ĩgʉ̃sãrẽ ñeã, peresu iriñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Irasirikeremakʉ̃, sugʉ Marĩpʉre wereboegʉ iri ñamita peresu wii makãpʉrorire tũpã, ĩgʉ̃sã ããrĩrĩ́ taribugue ñajãja, ĩgʉ̃sãrẽ ãsũ ãrĩ ãĩwiriayupʉ: ");
INSERT INTO sri_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Marĩpʉya wiigue waaka! Irogue eja, Marĩpʉ Jesúre bʉremurãrẽ ĩgʉ̃ merã õãrõ ããrĩmakʉ̃ iriburi kerere wereka masakare! ãrĩyupʉ Marĩpʉre wereboegʉ ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã peresu ããrãnerã wiriakõãñurã. Gajinʉ gapʉ boyoripoe ããrĩmakʉ̃, Marĩpʉya wiigue ñajãa, masakare buenʉgãñurã, Marĩpʉre wereboegʉ ĩgʉ̃sãrẽ weredoreaderosũta. Ĩgʉ̃sã irogue bueripoe paía opʉ gapʉ, ĩgʉ̃ merãmarãde, Pedrosã peresu ããrãnerã wiriadeare masĩbiriñurã dapa. Irasirirã ĩgʉ̃sã Israel bumarã oparãrẽ ããrĩpererãrẽ neeõñurã. Ĩgʉ̃sã nerẽperemakʉ̃ ĩãrã, surarare peresu iriri wiigue Jesús buedoregʉ beyenerãrẽ ĩgʉ̃sã biadoboanerãrẽ ãĩridoreñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Irasirirã surara ĩgʉ̃sãrẽ ãĩrã waadiñurã. Irogue eja, Pedrosãrẽ neõ bokabiriñurã. Ĩgʉ̃sãrẽ bokabirisĩã, oparãguere wererã dujáakõãñurã doja. ");
INSERT INTO sri_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Dujaja, oparãrẽ: —Peresu iriri wii makãpʉrori õãrõ biadea makãpʉrori ããrãdabʉ. Irogue biadoboanerãrẽ korerãde iri makãpʉrorikʉ níadama. Irasũ ããrĩkeremakʉ̃, gʉa ĩgʉ̃sã ããrãdea taribure makãpʉro tũpãmakʉ̃ neõ marãma, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, paía opʉ, Marĩpʉya wii marã surara opʉ, paía oparãde: “¿Naásũ waayuri ĩgʉ̃sãrẽ?” ãrĩ gũñarikʉñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ĩgʉ̃sã irasũ gũñarikʉripoe sugʉ masakʉ ĩgʉ̃sã pʉro eja: —Mʉsã peresu irianerã Marĩpʉya wiigue ããrãma. Masakare buerã iriama, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, Marĩpʉya wii marã surara opʉ, ĩgʉ̃yarã surara merã ĩgʉ̃sãrẽ ñeãrã waañurã. Irogue eja, ĩgʉ̃sãrẽ ñeã, paía oparã pʉro ãĩãñurã doja. Masakare güisĩã, ĩgʉ̃sãrẽ tãrãbiriñurã. “Gʉa ĩgʉ̃sãrẽ tãrãmakʉ̃ ĩãrã, masaka gʉare ʉ̃tãyeri merã deabukuma”, ãrĩ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ĩgʉ̃sãrẽ judío masaka oparã pʉro ãĩjamakʉ̃, paía opʉ ĩgʉ̃sãrẽ turiyupʉ: ");
INSERT INTO sri_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Gʉa mʉsãrẽ: “Jesúyare neõ buenemobirikõãka!” ãrãdibʉ. Gʉa irasũ ãrĩkeremakʉ̃, mʉsã ããrĩperero Jerusalén marãrẽ buegorenáa. Jesús boadea waja gʉare waja opamakʉ̃ iridʉarã yáa mʉsã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Pedro gajirã Jesús buedoregʉ beyenerã merã ĩgʉ̃rẽ ãsũ ãrĩ yʉjʉyupʉ: —Masaka doreri nemorõ Marĩpʉya gapʉre iriro gããmea. Gʉa mʉsã dorerire irirã, Marĩpʉ doreri gapʉre iribiribukoa. ");
INSERT INTO sri_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mʉsã Jesúre curusague pábiatú wẽjẽdoredire Marĩpʉ, marĩ ñekʉ̃sãmarã Opʉ gapʉ ĩgʉ̃rẽ masũdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ĩgʉ̃rẽ masũ odo, ʉ̃mʉgasigue ãĩmʉrĩagʉ, ĩgʉ̃ diaye gapʉ dobodi ããrĩmí. Marĩrẽ taubure, marĩ Opʉ ããrĩbure irasiridi ããrĩmí. Irasirigʉ marĩ judío masaka marĩ ñerõ irideare bʉjawere, gũñarĩrẽ gorawayumakʉ̃ kãtigʉkumi. ");
INSERT INTO sri_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Gʉa ããrĩpereri Jesús irideare ĩãnerã ããrã. Irasirirã irire werea. Õãgʉ̃ deyomarĩgʉ̃de gʉare irire pémasĩmakʉ̃ yámi. Irasirirã ĩgʉ̃ iritamurĩ merã werea. Marĩpʉ dorerire pérãnodere Õãgʉ̃ deyomarĩgʉ̃rẽ iriugʉkumi, ãrĩ wereyupʉ Pedro paía opʉre. ");
INSERT INTO sri_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, oparã gapʉ guataria, Pedrosãrẽ wẽjẽdʉadiñurã. ");
INSERT INTO sri_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sugʉ fariseo bumʉ Gamaliel wãĩkʉgʉ gapʉ wãgãnʉgãyupʉ ĩgʉ̃sãrẽ werebu. Ĩgʉ̃ judío masaka oparã merãmʉ Moisés gojadeare buerimasʉ̃ ããrĩyupʉ. Masaka ĩgʉ̃rẽ: “Õãgʉ̃ ããrĩ́mi”, ãrĩ bʉremuñurã. Ĩgʉ̃ wãgãnʉgã, surarare: “Ĩĩsãrẽ ãĩwiriaka dapa!” ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ĩgʉ̃sãrẽ ãĩwiriadero pʉrʉ, oparãrẽ ãsũ ãrĩyupʉ: —Mʉsã Israel bumarã, mʉsã ĩgʉ̃sãrẽ iridʉarire õãrõ gũñaka! ");
INSERT INTO sri_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Teudas wãĩkʉgʉ waadeare gũñaka! Irinʉguere ĩgʉ̃ masakare: “Masĩtarinʉgãgʉ̃ ããrã yʉ”, ãrĩdi ããrãdimi. Irasirirã wárã cuatrocientos ʉ̃ma ĩgʉ̃ merãmarã ããrĩnerã ããrãdima ĩgʉ̃ buerire pédʉarã. Pʉrʉ gajirã ĩgʉ̃rẽ wẽjẽkõãnerã ããrĩmá. Ĩgʉ̃rẽ wẽjẽadero pʉrʉ, ĩgʉ̃ merãmarã ããrãdinerã waasiriakõãnerã ããrĩmá. Irasũ waadero pʉrʉ, ĩgʉ̃ buedea pereakõãdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pʉrʉ i nikũ marãrẽ ĩgʉ̃sã keoripoe gajigʉ Judas wãĩkʉgʉ Galileamʉ ããrĩdi ããrãdimi. Wárã ĩgʉ̃ merãmarã ããrĩnerã ããrãdima. Pʉrʉ gajirã ĩgʉ̃dere wẽjẽkõãnerã ããrĩmá. Ĩgʉ̃rẽ wẽjẽadero pʉrʉ, ĩgʉ̃ merãmarã ããrãdinerã waasiripereakõãnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Irasirigʉ mʉsãrẽ werea. Sĩĩsãrẽ, marĩ peresugue biadoboanerãrẽ wiuka! Mʉsã ĩgʉ̃sãrẽ iridʉarire iribirikõãka! Ĩgʉ̃sã bueri, Marĩpʉya bueri ããrĩbero, pereakõãrokoa Teudas, Judas buedea perederosũta. ");
INSERT INTO sri_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ĩgʉ̃sã bueri, Marĩpʉya bueri ããrĩrṍ, neõ perebirikoa. Ĩgʉ̃sãrẽ irire pirimakʉ̃ iribirikoa. Irasirirã irire õãrõ pémasĩka! Ĩgʉ̃sã bueri, diayeta Marĩpʉya bueri ããrĩmakʉ̃, mʉsã ĩgʉ̃sãrẽ wẽjẽdʉarã, Marĩpʉ merã gãmekẽãdʉarã irirosũ iribukoa, ãrĩyupʉ Gamaliel. ");
INSERT INTO sri_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã: “Jáʉ, marĩrẽ diayeta weremi ĩĩ”, ãrĩ péñurã. Irasirirã Jesús buedoregʉ beyenerãrẽ siiu, surarare tãrãdoreñurã. “Jesúyare neõ werenemobirikõãka!” ãrĩñurã. Irasũ ãrĩ odo: “Waaka!” ãrĩ, wiuñurã ĩgʉ̃sãrẽ pama. ");
INSERT INTO sri_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Irasirirã Jesús buedoregʉ beyenerã judío masaka oparã pʉro ããrãnerã waakõãñurã. “Marĩ Jesúyare bueri waja marĩrẽ tãrãdoreama gʉyasĩrĩburo, ãrĩrã”, ãrĩñurã. “Marĩpʉ gapʉ marĩrẽ: ‘Irire bokatĩũkõãma’, ãrĩ masĩmi”, ãrĩñurã. Irasirirã oparã ĩgʉ̃sãrẽ ñerõ irikeremakʉ̃, bʉro ʉsʉyañurã. ");
INSERT INTO sri_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Irasirirã ʉ̃mʉrikʉ Marĩpʉya wiigue, wiiriguedere masakare: “Jesúta Marĩpʉ iriudi, Cristo ããrĩ́mi”, ãrĩ buenañurã. ");
INSERT INTO sri_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Irasirirã irinʉrĩrẽ wárã judío masaka Jesúre bʉremunʉgãñurã. Surãyeri hebreo ya merã wereníñurã. Gajirã griego ya merã wereníñurã. Ĩgʉ̃sã wapiweyarã nomerẽ ʉ̃mʉrikʉ ĩgʉ̃sã baarire keoro guerebirimakʉ̃ ĩãrã, hebreo ya merã werenírã gapʉre turiñurã. ");
INSERT INTO sri_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Irasirirã Jesús buedoregʉ beyenerã Jesúre bʉremurãrẽ ããrĩpererãrẽ ĩgʉ̃sã pʉrogue siiu neeõ, ãsũ ãrĩ wereñurã: —Gʉa baarire guererã, Marĩpʉya kere gapʉre wereduúmakʉ̃ õãbiribukoa. ");
INSERT INTO sri_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Irasirirã mʉsã gʉayarã, Jesúre bʉremurã mʉsã watope ããrĩrã́rẽ su mojõma pere gaji mojõ peru pẽrẽbejarãgora beyeka! “Õãrõ masĩrã, Õãgʉ̃ deyomarĩgʉ̃ turarire opatarirã ããrĩ́ma”, mʉsã ãrĩ ĩãrãrẽ beyeka! Mʉsã beye odomakʉ̃, gʉa ĩgʉ̃sãrẽ baari gueremurãrẽ sóorãkoa. ");
INSERT INTO sri_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Irasirirã gʉa ʉ̃mʉrikʉ Marĩpʉre sẽrẽ, ĩgʉ̃yare buerãkoa, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, ããrĩpererã: “Jáʉ, irasũta irirãra”, ãrĩ, Esteban wãĩkʉgʉre beyeñurã. Ĩgʉ̃ Jesúre õãrõ bʉremugʉ̃, Õãgʉ̃ deyomarĩgʉ̃rẽ opatarigʉ ããrĩyupʉ. Gajirã Felipe, Prócoro, Nicanor, Timón, Parmenas, Nicolás wãĩkʉrãrẽ beyeñurã. Nicolás Antioquíamʉ judío masakʉ ããrĩbirikeregʉ, judío masaka irirosũ bʉremugʉ̃ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ĩgʉ̃sãrẽ beye odo, Jesús buedoregʉ beyenerã pʉro ãĩãñurã. Ĩgʉ̃sã ãĩjamakʉ̃ ĩãrã, Marĩpʉre: “Õãrõ iritamuka ĩgʉ̃sãrẽ!” ãrĩ sẽrẽbosa, ĩgʉ̃sãya dipu weka mojõrĩ merã ñapeoñurã. ");
INSERT INTO sri_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Irasirirã Marĩpʉya kerere weregorenamakʉ̃, wárã masaka irire péñurã. Wárã Jerusalén marã masaka, paíade Jesúre bʉremunʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban Marĩpʉ iritamurĩ merã ĩgʉ̃ turaro merã pũrĩrikʉrãrẽ tau, gaji õãrĩ iri ĩmurĩrẽ iriyupʉ masaka wárã watopere. ");
INSERT INTO sri_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ĩgʉ̃ irasirimakʉ̃ ĩãrã, surãyeri judío masaka “Esclavos Libertado” wãĩkʉri bumarã ĩgʉ̃ merã guaseopʉroriñurã. Ĩgʉ̃sã: Cirene marã, Alejandría marã, Cilicia marã, Asia marã su wii judío masaka ĩgʉ̃sã nerẽrĩ wiigue nerẽnarã ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Esteban, Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃rẽ õãrĩ masĩrĩ sĩrĩ merã werenímakʉ̃ pérã, ĩgʉ̃rẽ neõ werení bokatĩũbiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Irasirirã masaka ĩãberogue gajirãrẽ niyeru wajari: “Ãsũ ãrĩkatoka masakare!” ãrĩñurã: —“Esteban Moisére, Marĩpʉre ñerõ werenímakʉ̃ péabʉ gʉa”, ãrĩka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Irasirirã ĩgʉ̃sã ãrĩkatodoresũanerã irire weremakʉ̃ pérã, iri makã marã, mʉrã, Moisés gojadeare buerimasãde Esteban merã bʉro gua, ĩgʉ̃rẽ ñeã, oparã pʉro ãĩãñurã. ");
INSERT INTO sri_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ĩgʉ̃rẽ irogue ãĩja, gajirãrẽ ãsũ ãrĩkatonemodoreñurã doja: —Ĩĩ ʉ̃mʉrikʉ Marĩpʉya wiire, Moisés gojadeadere ñerõ werenígorenami. ");
INSERT INTO sri_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Masakare: “Jesús Nazaretmʉ, Marĩpʉya wiire béogʉkumi. Moisés marĩrẽ pídeadere gorawayugʉkumi”, ãrĩmakʉ̃ péabʉ gʉa, ãrĩkatoñurã oparãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, oparã ããrĩpererã irogue doarã Estebãrẽ bʉro ĩãñurã. Ĩgʉ̃sã ĩãmakʉ̃, ĩgʉ̃ya diapu Marĩpʉre wereboegʉya diapu irirosũ deyoyuro. ");
INSERT INTO sri_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ĩgʉ̃sã Estebãrẽ ĩãripoe paía opʉ ĩgʉ̃rẽ sẽrẽñayupʉ: —¿Diayeta ãrĩrĩ, ĩgʉ̃sã mʉrẽ weresãrã? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban yʉjʉyupʉ ĩgʉ̃rẽ: —Yaarã, yʉre õãrõ péka! Marĩ ñekʉ̃ Abraham, Harán wãĩkʉri makãgue waaburo dupiyuro Mesopotamiague ããrĩdi ããrĩmí Caldea masaka ããrĩrṍgue. Ĩgʉ̃ irogue ããrĩripoe Marĩpʉ õãrõ gosesiriri merã ĩgʉ̃rẽ deyoa, ");
INSERT INTO sri_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ãsũ ãrĩdi ããrĩmí: “I nikũrẽ, mʉyarãrẽ béowãgãka! Mʉ waamakʉ̃, yʉ gaji nikũ mʉ ããrĩburi nikũrẽ ĩmugʉkoa”, ãrĩdi ããrĩmí Marĩpʉ Abrahãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Marĩpʉ irasũ ãrĩmakʉ̃ pégʉ, Abraham Caldea nikũ ããrãdi Harã́gue waadi ããrĩmí. Irogue ejadero pʉrʉ, ĩgʉ̃ pagʉ boadi ããrĩmí. Ĩgʉ̃ boadero pʉrʉ, Marĩpʉ Abrahãrẽ wiridoredi ããrĩmí doja. Irasirigʉ Abraham õõ, marĩ ããrĩrĩ́ nikũrẽ ejadi ããrĩmí pama. ");
INSERT INTO sri_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ĩgʉ̃ õõgue ejamakʉ̃, Marĩpʉ ĩgʉ̃rẽ neõ nikũrẽ sĩbiridi ããrĩmí dapa. Sĩbirikeregʉ, ĩgʉ̃rẽ: “Pʉrʉgue mʉya, mʉ parãmerã ããrĩturiarãya nikũ ããrĩrokoa”, ãrĩdi ããrĩmí. Ĩgʉ̃ irasũ ãrĩripoere Abraham neõ pũrã marĩdi ããrĩmí dapa. ");
INSERT INTO sri_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gaji Marĩpʉ ĩgʉ̃rẽ ãrĩnemodi ããrĩmí doja: “Mʉ parãmerã ããrĩturiarã gaji nikũgue waarãkuma dapa. Cuatrocientos bojorigora iri nikũ marãrẽ moãboerãkuma. Ĩgʉ̃sãrẽ moãdore, pábirarãkuma. ");
INSERT INTO sri_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yʉ gapʉ iri nikũ marãrẽ wajamoãgʉra ĩgʉ̃sã irasiriri waja. Yʉ ĩgʉ̃sãrẽ wajamoã odoadero pʉrʉ, mʉ parãmerã ããrĩturiarã iri nikũrẽ wirirãkuma. Wiri, yʉ ĩgʉ̃sãrẽ sĩburi nikũgue eja, yʉre bʉremurã yʉ dorerire irirãkuma”, ãrĩdi ããrĩmí Marĩpʉ Abrahãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ĩgʉ̃ irasũ ãrãdero pʉrʉ, ãsũ iridoredi ããrĩmí doja: “Ããrĩpererã ʉ̃marẽ ĩgʉ̃sãya dʉpʉma gasirogãrẽ wiirika! Irasirirã mʉsã yʉ werenírĩ bʉremurĩrẽ yʉre ĩmurãkoa”, ãrĩdi ããrĩmí. Irasirigʉ Abraham ĩgʉ̃ magʉ̃ Isaare su semana ĩgʉ̃ deyoadero pʉrʉ, ĩgʉ̃rẽ wiiridi ããrĩmí. Mʉrãrõta Isaade ĩgʉ̃ magʉ̃ Jacore iridi ããrĩmí. Jacode mʉrãrõta ĩgʉ̃ pũrãrẽ pe mojõma pere su gubu peru pẽrẽbejari buri ããrĩmurãrẽ iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","’Jacob pũrã marĩ ñekʉ̃sãmarã ĩgʉ̃sã pagʉmʉrẽ Josére ĩãturisĩã, Egiptogue waarã́rẽ duanerã ããrĩmá, iro marãrẽ moãboegʉ ããrĩburo, ãrĩrã. Marĩpʉ gapʉ ĩgʉ̃ merã ããrĩníkõãdi ããrĩmí ĩgʉ̃rẽ iritamugʉ̃. Ĩgʉ̃ ñerõ tarikeremakʉ̃, ããrĩpereri ĩgʉ̃ ñerõ taririre taudi ããrĩmí. Wári masĩrĩ sĩdi ããrĩmí. Irasirigʉ faraón Egiptomʉ i nikũ marã opʉ Josére beyedi ããrĩmí, ĩgʉ̃ dokamʉ opʉ ããrĩburo, ãrĩgʉ̃. Ĩgʉ̃ya wiimadere moãdoregʉ sóodi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Pʉrʉ ããrĩperero Egiptoguere, Canaán nikũguedere baari pereakõãdero ããrĩbʉ́. Irasirirã masaka bʉro ñerõ tarinerã ããrĩmá. Marĩ ñekʉ̃sãmarã ʉaboanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Irasirigʉ Egiptogue trigo ããrĩrĩ́ kerere pégʉ, Jacob ĩgʉ̃ pũrãrẽ marĩ ñekʉ̃sãmarãrẽ: “Wajarirã waaka!” ãrĩ iriudi ããrĩmí. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, neõ waarã́ irinerã ããrĩmá iroguere. Irogue eja, baari wajari odo, gãme dujarikõãnerã ããrĩmá doja. ");
INSERT INTO sri_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ĩgʉ̃sã baari wajariadeare baapeo, dupaturi wajarirã waanerã ããrĩmá doja. Iripoeta pama José ĩgʉ̃sãrẽ: “Mʉsã pagʉmʉta ããrã yʉ”, ãrĩ weredi ããrĩmí. Irasirigʉ Egipto marã opʉ José tĩ́rãrẽ masĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pʉrʉ José ĩgʉ̃ tĩ́rã merã kerere iriudi ããrĩmí ĩgʉ̃ pagʉre. “Yʉpʉ, ĩgʉ̃yarã merã aariburo”, ãrĩ iriudi ããrĩmí. Jacoyarã setenta y cinco gora ããrĩnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","José kere iriuadeare pégʉ, Jacob ĩgʉ̃ pũrã merã Egiptogue waadi ããrĩmí. Jacob irogue boadi ããrĩmí. Ĩgʉ̃ pũrã, marĩ ñekʉ̃sãmarãde boanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pʉrʉgue ĩgʉ̃sã parãmerã ããrĩturiarã ĩgʉ̃sãya gõãrĩ́rẽ Siquem wãĩkʉri makãgue Abraham, Hamor pũrãrẽ ĩgʉ̃ ʉ̃tãgobe wajaridea gobegue pímurã ãĩãnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Marĩpʉ Abrahãrẽ: “Mʉ parãmerã ããrĩturiarãrẽ i nikũrẽ sĩgʉra”, ãrĩdero ejawãgãripoe Abraham parãmerã ããrĩturiarã Egiptogue ããrĩrã́ wárã masãporenerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ĩgʉ̃sã irogue ããrĩmakʉ̃, José boadero pʉrʉ yoadero pʉrʉ, gajigʉ iri nikũ marã opʉ ñajãdi ããrĩmí doja. Ĩgʉ̃, José õãrõ irideare õãrõ masĩbiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Irasirigʉ marĩ ñekʉ̃sãmarã wárã masãporemakʉ̃ ĩãgʉ̃, ĩgʉ̃sãrẽ tarinʉgãdʉagʉ, ñerõ iridi ããrĩmí. Ʉ̃ma pũrã deyoarãrẽ boaburo, ãrĩgʉ̃, béodoredi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Iripoeta Moisés deyoadi ããrĩmí. Ĩgʉ̃ Marĩpʉ ĩũrõrẽ õãgʉ̃ ããrĩdi ããrĩmí. Irasirirã ĩgʉ̃ deyoadero pʉrʉ, ĩgʉ̃ pagʉsãmarã ĩgʉ̃sãya wiigue ʉrerã abegora duri merã ĩgʉ̃rẽ masũnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ĩgʉ̃rẽ duúnemomasĩmerã, diague puui merã paubéonerã ããrĩmá. Pʉrʉ Egipto marã opʉ magõ ĩgʉ̃rẽ boka, igoya wiigue ãĩmajã, igo magʉ̃ diaye irirosũ masũdeo ããrĩmó. ");
INSERT INTO sri_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moisés iri wiigue masã, ããrĩpereri Egipto marã buerire buepeodi ããrĩmí. Irasirigʉ ĩgʉ̃ masĩrĩ merã werení, ããrĩpereri õãrõ iridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Pʉrʉ cuarenta bojori opagʉ ĩgʉ̃yarãrẽ Israel bumarãrẽ ĩãdʉagʉ, ĩgʉ̃sã pʉrogue waadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Irogue ejagʉ, sugʉ Egiptomʉ ĩgʉ̃yagʉre ñerõ irimakʉ̃ ĩãdi ããrĩmí. Irasirigʉ ĩgʉ̃rẽ gãmibosagʉ Egiptomʉrẽ wẽjẽkõãdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ĩgʉ̃ basi: “Marĩpʉ yaarãrẽ wijatadoregʉ iriuami, ĩgʉ̃sã irire õãrõ pémasĩkuma”, ãrĩ gũñadi ããrĩmí. Ĩgʉ̃sã gapʉ ĩgʉ̃ gũñarõsũ gũñabirinerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Gajinʉ gapʉ Moisés ĩgʉ̃sã pʉrogue waadi ããrĩmí doja. Irogue ejagʉ, gajirã ĩgʉ̃yarã pẽrã ĩgʉ̃sã basi gãmekẽãmakʉ̃ ĩãdi ããrĩmí. “Iropata gãmekẽãka! ¿Nasirimurã su bumarã ããrĩkererã, iropa gãmekẽãkõãrĩ?” ãrĩdi ããrĩmí Moisés ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, bʉro pádi gapʉ, Moisére túmeénú: “‘¿Noã mʉrẽ gʉa opʉ, gʉare dorebu ããrĩburo’, ãrĩ sóoari? ");
INSERT INTO sri_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ñamika Egiptomʉrẽ mʉ wẽjẽaderosũ yʉdere wẽjẽdʉagʉ yári?” ãrĩdi ããrĩmí Moisére. ");
INSERT INTO sri_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉka, Moisés Egiptore wiri, gaji nikũ Media wãĩkʉri nikũgue waadi ããrĩmí. Irogue ĩgʉ̃sã watopegue ããrĩgʉ̃́, iromorẽ marãpokʉ, pẽrã ʉ̃ma pũrãkʉdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Moisés cuarenta bojorigora iri nikũguere ããrĩdi ããrĩmí. Irikʉ bojori pʉrʉ Sinaí wãĩkʉdi ʉ̃tãʉ̃ pʉro, masaka marĩrõgue waadi ããrĩmí. Irogue sugʉ yukʉgã dʉpʉri watopegue peame ʉ̃jʉ̃makʉ̃ ĩãdi ããrĩmí. Marĩpʉre wereboegʉ iri peame ʉ̃jʉ̃rĩ pũrã dekogue deyoadi ããrĩmí ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés iri peame ʉ̃jʉ̃makʉ̃ ĩãgʉ̃, ĩãgʉkakõãdi ããrĩmí. “¿Naásũ waari?” ãrĩ, iri yukʉgã pʉrogãgue ĩãgʉ̃ waagʉ́, marĩ Opʉ ãsũ ãrĩ werenímakʉ̃ pédi ããrĩmí: ");
INSERT INTO sri_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yʉ, mʉ ñekʉ̃sãmarã: Abraham, Isaac, Jacob Opʉ ããrã”, ãrĩdi ããrĩmí. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, bʉro güi narada, neõ ĩãnemodʉabiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Marĩpʉ ĩgʉ̃rẽ: “Yʉ pʉrota nía mʉ. Irasirigʉ mʉya gubu suríre túweaka, yʉre bʉremurĩrẽ ĩmubu. ");
INSERT INTO sri_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yaarã Egiptogue ããrĩrã́rẽ bʉro poyamakʉ̃ ĩãa. Ĩgʉ̃sã bʉro bʉjawereri merã gaguinímakʉ̃ péa. Irasirigʉ ĩgʉ̃sãrẽ taubu dijijabʉ. Irasirigʉ mʉrẽ Egiptogueta iriugʉra ĩgʉ̃sãrẽ iritamudoregʉ”, ãrĩ weredi ããrĩmí Marĩpʉ Moisére. ");
INSERT INTO sri_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ĩĩ Moiséreta marĩ ñekʉ̃sãmarã ĩgʉ̃rẽ gããmemerã: “‘¿Noã mʉrẽ gʉa opʉ, gʉare dorebu ããrĩburo’, ãrĩ sóoari?” ãrĩnerã ããrĩmá. Marĩpʉ gapʉ ĩgʉ̃rẽ: “Ĩgʉ̃sã opʉ pígʉra mʉrẽ”, ãrĩ, ĩgʉ̃rẽ iriudi ããrĩmí ĩgʉ̃sãrẽ taudoregʉ. Marĩpʉ ĩgʉ̃rẽ wereboegʉ yukʉgã dʉpʉri watopegue peame ʉ̃jʉ̃derogue deyoadi merã ĩgʉ̃rẽ iriudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Irasirigʉ Moisés Egiptogue eja, Marĩpʉ turaro merã wári iri ĩmurĩrẽ iridi ããrĩmí. Pʉrʉ marĩ ñekʉ̃sãmarãrẽ Egiptogue ããrãnerãrẽ siiuwãgã, wádiya deko diiadiyague eja, Marĩpʉ turaro merã irasũta iridi ããrĩmí doja. Pʉrʉ cuarenta bojorigora masaka marĩrõgue ĩgʉ̃sã waagorenamakʉ̃dere, irasũta iridi ããrĩmí doja. ");
INSERT INTO sri_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moiséta marĩ ñekʉ̃sãmarã Israel bumarãrẽ ãsũ ãrĩ weredi ããrĩmí: “Pʉrʉgue marĩyagʉre Marĩpʉ iriugʉkumi ĩgʉ̃ya kerere werebure. Yʉre ĩgʉ̃ iriuderosũta ĩgʉ̃dere iriugʉkumi. Ĩgʉ̃ wererire õãrõ péduripíka!” ãrĩ weredi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Marĩ ñekʉ̃sãmarã masaka marĩrõgue nerẽmakʉ̃, Moisés ĩgʉ̃sã merã ããrĩdi ããrĩmí. Irogue Sinaí wãĩkʉdi ʉ̃tãʉ̃gue Marĩpʉre wereboegʉ ĩgʉ̃rẽ weredi ããrĩmí. Ĩgʉ̃ irasũ weremakʉ̃ péadeare Moisés marĩ ñekʉ̃sãmarãrẽ weretaudi ããrĩmí. Marĩ irire pémakʉ̃, Marĩpʉ marĩrẽ ĩgʉ̃ merã õãrõ ããrĩmakʉ̃ yámi. Iri neõ perebirikoa. ");
INSERT INTO sri_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Moisés irire werekeremakʉ̃, marĩ ñekʉ̃sãmarã gapʉ neõ bʉremubirinerã ããrĩmá. Ĩgʉ̃dere bʉremubiri: “Egiptogue dujáakõãrã”, ãrĩ gũñanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Irasirirã Moisés ʉ̃tãʉ̃gue ããrĩripoe ĩgʉ̃ tĩ́gʉ̃ Aarṍrẽ: “Marĩrẽ Egiptogue ããrĩrã́rẽ ãĩridi, ¿naásũ waayuri? Marĩ neõ masĩbea”, ãrĩnerã ããrĩmá. Irasirirã Aarṍrẽ: “Keori weabosaka gʉare! I keori weadea merã kõãdupiyurãkoa, marĩ waaburi maarẽ́ ĩmuburo, ãrĩrã”, ãrĩnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Irasũ ãrĩ odo, sugʉ wekʉ majĩgʉ̃ keori oro merã weanerã ããrĩmá. Pʉrʉ ĩgʉ̃sãyarã waimʉrã ejorãrẽ wẽjẽ, soepeonerã ããrĩmá iri weadeare bʉremurã. Pʉrʉ irire ʉsʉyari merã ĩãrã, bosenʉ irinʉgãnerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ĩgʉ̃sã weadeare bʉremumakʉ̃ ĩãgʉ̃, Marĩpʉ ĩgʉ̃sãrẽ béodi ããrĩmí, ĩgʉ̃sã gããmerõ iriburo, ãrĩgʉ̃. Irasirirã neñukãrẽ, abeare bʉremunʉgãnerã ããrĩmá. Marĩpʉya kerere weredupiyunerã ãsũ ãrĩ gojanerã ããrĩmá Marĩpʉ ãrĩdeare gojarã: Mʉsã, Israel bumarã masaka marĩrõgue cuarenta bojori ããrĩrã́, yʉ gapʉre mʉsãyarãrẽ waimʉrã ejorãrẽ wẽjẽ soepeo bʉremubiribʉ. ");
INSERT INTO sri_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Irasirirã mʉsã Moloc wãĩkʉgʉ keorire bʉremurã, ĩgʉ̃rẽ bʉremurĩ wiire, mʉsã surí gasiri merã iridea wiire kõãgorenabʉ. Gajigʉ Refán wãĩkʉgʉ neñukãmʉ keori mʉsã weadeadere bʉremubʉ. Mʉsã iri keorire weabʉ bʉremudʉarã. Irasirigʉ, mʉsã yʉre bʉremubiridea waja mʉsãrẽ Babilonia wãĩkʉro koregue béogʉra, ãrĩ gojanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Irasũ ãrĩ odo, Esteban oparãrẽ Marĩpʉya wiima gapʉre wereyupʉ doja: —Marĩ ñekʉ̃sãmarã masaka marĩrõgue ããrĩrã́, Marĩpʉre bʉremurĩ wii, waimʉrã gasiri merã ĩgʉ̃sã iridea wiire opanerã ããrĩmá. Iri wiiguere Marĩpʉ pe mojõma doreri gojadea majĩ ʉ̃tã majĩ ããrĩdero ããrĩbʉ́. Ĩgʉ̃sã iri wiire iriburo dupiyuro Marĩpʉ Moisére iri wii keorire: “Ãsũpero irika!” ãrĩdi ããrĩmí. Irasirirã marĩ ñekʉ̃sãmarã iri wiire Marĩpʉ dorederosũta keoro irinerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ĩgʉ̃sã boadero pʉrʉ, ĩgʉ̃sã pʉrʉ marã iri wiire opaturianerã ããrĩmá. Pʉrʉ Josué ĩgʉ̃sãrẽ siiuwãgãmakʉ̃, iri wiire ĩgʉ̃sã noó waaró ãĩãnanerã ããrĩmá. Ĩgʉ̃sã õõgue ejamakʉ̃, Marĩpʉ i nikũ marãrẽ judío masaka ããrĩbirinerãrẽ béokõãdi ããrĩmí. Yoaripoe marĩ ñekʉ̃sãmarã Marĩpʉre iri wiigue bʉremunerã ããrĩmá. David opʉ ñajãdero pʉrʉguedere opanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Marĩpʉ Davire ĩgʉ̃ ĩũrõ õãrõ iridire ʉsʉyari merã ĩãdi ããrĩmí. Irasirigʉ David Marĩpʉre ãsũ ãrĩdi ããrĩmí: “Gʉa ñekʉ̃ Jacob bʉremudi ããrã mʉ. Irasirigʉ yʉ mʉrẽ wári wii mʉ ããrĩburi wiire iribosasi”, ãrĩdi ããrĩmí. Ĩgʉ̃ irasiridʉakeregʉ, iri wiire iribiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ĩgʉ̃ magʉ̃ Salomón gapʉ iri wiire iridi ããrĩmí pama. ");
INSERT INTO sri_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Irasirikeremakʉ̃, Marĩpʉ gapʉ ããrĩpererãrẽ doregʉ ããrĩsĩã, masaka iridea wiirigue dita ããrĩbemi. Iripoegue ĩgʉ̃ya kerere weredupiyudi ãsũ ãrĩ gojadi ããrĩmí Marĩpʉ ãrĩdeare gojagʉ: ");
INSERT INTO sri_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yʉ, ããrĩpererã Opʉ ããrã. Ʉ̃mʉgasi yʉ doaro irirosũ ããrã. I nikũ yaa guburi kʉraña doanírõ irirosũ ããrã. Irasirirã, yʉ ããrĩburi wiire irimasĩbea mʉsã. ");
INSERT INTO sri_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yʉta ããrĩpererire iribʉ, ãrĩmi Marĩpʉ, ãrĩ gojasũdero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban irasũ ãrĩ odo, ãsũ ãrĩ werenemoyupʉ doja: —Mʉsã Marĩpʉ dorerire tarinʉgãa. Ĩgʉ̃rẽ masĩmerã irirosũ ĩgʉ̃ wererire neõ pédʉabea. Õãgʉ̃ deyomarĩgʉ̃ dorerire neõ iridʉabea. Marĩ ñekʉ̃sãmarã iriderosũta iririkʉkõãa. ");
INSERT INTO sri_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ĩgʉ̃sã ããrĩpererã Marĩpʉya kerere weredupiyunerãrẽ ñerõ waamakʉ̃ irinerã ããrĩmá. Gajirãrẽ: “Jesús marĩrẽ taubu, Marĩpʉ doreri iribu aarigʉkumi”, ãrĩ wererãrẽ wẽjẽnerã ããrĩmá. Ĩgʉ̃rẽta ĩgʉ̃ ejadero pʉrʉ, mʉsã gapʉ ñeã, gajirãrẽ wia wẽjẽdorebʉ. ");
INSERT INTO sri_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Marĩpʉ ĩgʉ̃rẽ wereboerã merã ĩgʉ̃ dorerire marĩ ñekʉ̃sãmarãrẽ píkeremakʉ̃, mʉsã irire bʉro tarinʉgãa, ãrĩ wereyupʉ Esteban oparãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, bʉro guari merã ĩgʉ̃sãya guikare kũrĩduútúñurã. ");
INSERT INTO sri_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Esteban gapʉ Õãgʉ̃ deyomarĩgʉ̃rẽ opatariyupʉ. Ʉ̃mʉgasigue ĩãmu, Marĩpʉ gosesiririre ĩãyupʉ. Marĩpʉ diaye gapʉ Jesús nímakʉ̃ ĩãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Esteban ĩgʉ̃rẽ ĩãgʉ̃: “Ĩãka!” ãrĩyupʉ. “Ʉ̃mʉgasi tũpãmakʉ̃ ĩãa. Jesús ããrĩpererã tĩ́gʉ̃ Marĩpʉ diaye gapʉ nímakʉ̃ ĩãa yʉ”, ãrĩyupʉ oparãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pédʉamerã, bʉro gaguiní, ĩgʉ̃sãya gãmipũrĩrẽ biañurã. Suro merã ũmawãgã, ĩgʉ̃rẽ ñeã, iri makã tʉrogue ãĩãñurã. Ĩgʉ̃sãya surí wekamarẽ túwea pí, sugʉ maamʉ Saulo wãĩkʉgʉre irire koredoreñurã. Odo, Estebãrẽ ʉ̃tãyeri merã dea wẽjẽñurã. ");
INSERT INTO sri_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ĩgʉ̃sã irasirimakʉ̃, Esteban ãsũ ãrĩ sẽrẽyupʉ: —Jesús yʉ Opʉ, yʉ kõmomakʉ̃, yaa yʉjʉpũrãrẽ ñeãka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pʉrʉ ĩgʉ̃ya ñadʉkʉpuri merã ejamejãja, bʉro gaguinírĩ merã: —Yʉ Opʉ, kãtika, ĩĩsãrẽ yʉre ĩgʉ̃sã irasiririre, ãrĩyupʉ. Irasũ ãrĩ, kõmoakõãyupʉ pama. ");
INSERT INTO sri_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo ĩgʉ̃sã Estebãrẽ dea wẽjẽmakʉ̃ ĩãgʉ̃: “Õãrõ irirã irasũ yáma”, ãrĩ gũñayupʉ. Irinʉta Jesúre bʉremumerã ĩgʉ̃rẽ bʉremurãrẽ Jerusalẽ́gue ããrĩrã́rẽ ñerõ irinʉgãñurã. Irasirimakʉ̃ ĩã, Jesúre bʉremurã gapʉ ããrĩpererã Judea nikũgue, Samaria nikũgue waasiriakõãñurã. Jesús buedoregʉ beyenerã dita Jerusalẽ́guere dujañurã. Gajirogue waabiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Gajirã ʉ̃ma Marĩpʉre bʉremurã Estebãya dʉpʉre yáarã, bʉro ore bʉjawereñurã. ");
INSERT INTO sri_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo gapʉ neõ sugʉ Jesúre bʉremugʉ̃ marĩkõãburo, ãrĩgʉ̃, Jesúre bʉremurãya wiirigue ñajãa, ʉ̃marẽ, nomedere ñeã, peresu iribu ãĩãnayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ĩgʉ̃ irasirimakʉ̃, Jesúre bʉremurã Jerusalẽ́rẽ wirirã, noó ĩgʉ̃sã waaró Marĩpʉ masakare tauri kerere werenañurã. ");
INSERT INTO sri_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe wãĩkʉgʉ Samaria nikũ ããrĩrĩ́ makãgue waa, irogue eja, iro marãrẽ Jesucristoya kerere werenayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ĩgʉ̃ iri kerere weremakʉ̃ pérã, ĩgʉ̃ Marĩpʉ turaro merã iri ĩmumakʉ̃ ĩãrã, ĩgʉ̃ pʉro nerẽnañurã ĩgʉ̃ wererire õãrõ pémurã. ");
INSERT INTO sri_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wárã wãtẽa ñajãsũnerãrẽ tauyupʉ. Wãtẽa gapʉ ĩgʉ̃sãguere ããrĩnerã bʉro gaguinírĩ merã wiriñurã. Wárã dʉpʉ bʉarãrẽ, waamasĩmerãdere tauyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Irasirimakʉ̃ ĩãrã, iri makã marã bʉro ʉsʉyañurã. ");
INSERT INTO sri_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Iri makãrẽ sugʉ Simón wãĩkʉgʉ yé ããrĩyupʉ. Ĩgʉ̃ yoaripoe yéa iririkʉrire irigorenamakʉ̃ ĩãrã, Samaria marã ĩãgʉkanokõãñurã. “Yʉ masĩtarinʉgãgʉ̃ ããrã”, ãrĩ werenayupʉ ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Irasirirã ããrĩpererã iri makã marã oparã, oparã ããrĩmerãde ĩgʉ̃rẽ: “Ĩĩ ʉ̃mʉgasigue marã Opʉ irirosũ turari opagʉ ããrĩkumi”, ãrĩ gũñadiñurã. ");
INSERT INTO sri_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ĩgʉ̃ sõõ gapʉ merã wári yéa iririkʉrire irimakʉ̃ ĩãrã, wárã masaka ĩgʉ̃rẽ bʉremuñurã. ");
INSERT INTO sri_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipe gapʉ Samaria marãrẽ: “Marĩpʉ ããrĩpererã Opʉ ããrĩ́mi. Ĩgʉ̃ magʉ̃ Jesucristo marĩrẽ taugʉ ããrĩ́mi”, ãrĩ wereyupʉ. Ʉ̃ma, nome, ĩgʉ̃ wererire pé bʉremumakʉ̃ ĩãgʉ̃, ĩgʉ̃sãrẽ deko merã wãĩyeyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simṍde Jesúre: “Bʉremua yʉ”, ãrĩmakʉ̃ pégʉ, Felipe ĩgʉ̃dere wãĩyeyupʉ. Pʉrʉ Felipe merã waagorenayupʉ. Felipe Marĩpʉ turaro merã iri ĩmumakʉ̃ ĩãgʉ̃, ĩãgʉkanokõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jesús buedoregʉ beyenerã Jerusalẽ́gue ããrĩrã́: “Samaria marã Marĩpʉyare õãrõ bʉremunʉgãñurã”, ãrĩrĩ kerere pérã, Pedro, Juãrẽ ĩãdorerã iriuñurã. ");
INSERT INTO sri_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Irogue ejarã, Jesúre bʉremurãrẽ Marĩpʉre sẽrẽbosañurã, Õãgʉ̃ deyomarĩgʉ̃rẽ bokatĩrĩñeãburo, ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ĩgʉ̃sã marĩ Opʉ Jesúre bʉremunʉgãdero pʉrʉ, ĩgʉ̃ wãĩ merã dita wãĩyesũñurã. Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃sãrẽ ejabiriyupʉ dapa. ");
INSERT INTO sri_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Irasirirã Pedrosã ĩgʉ̃sãya mojõrĩ merã Jesúre bʉremunʉgãnerãya dipu weka ñapeoñurã. Ĩgʉ̃sã ñapeomakʉ̃, Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃sãguere ejayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pedrosã ñapeomakʉ̃, Õãgʉ̃ deyomarĩgʉ̃ ejamakʉ̃ ĩãgʉ̃, Simón gapʉ ĩgʉ̃sã turarire gããmegʉ̃, niyeru merã wajaridʉadiyupʉ. Ãsũ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Iri turarire sĩka yʉdere! Yʉ ñapeorãguere Õãgʉ̃ deyomarĩgʉ̃ ejamakʉ̃ iridʉakoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Pedro ĩgʉ̃rẽ yʉjʉyupʉ: —Mʉ Marĩpʉ turari sĩrĩrẽ: “Niyeru merã wajarigʉkoa” ãrĩ gũñarĩ waja, mʉya niyeru, mʉ merãta béosũrokoa. ");
INSERT INTO sri_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Marĩpʉ ĩũrõrẽ mʉ gũñarĩ diaye ããrĩbea. Irasirigʉ gʉa irirosũ irimasĩbirikoa. ");
INSERT INTO sri_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Mʉ ñerõ iririre iripautariadi ããrã. Irasirigʉ mʉ ñerõ iririre bʉjawere, mʉ gũñarĩrẽ gorawayuka! Marĩpʉre sẽrẽka, mʉ ñerõ gũñarĩrẽ kãtiburo, ãrĩgʉ̃. Gajipoe irigʉ irire kãtibukumi mʉ ĩgʉ̃rẽ sẽrẽmakʉ̃, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Irasũ ãrĩmakʉ̃ pégʉ, Simón ĩgʉ̃sãrẽ ãrĩyupʉ: —Mʉsã Marĩpʉre sẽrẽbosaka, yʉre mʉsã ãrãdea waabirikõãburo, ãrĩrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedrosã, Jesús irimakʉ̃ ĩãdeare, ĩgʉ̃ buemakʉ̃ pédeare iri makã marãrẽ were odo, Jerusalẽ́gue goedujáañurã. Goedujáarã, wárã masakare Samaria nikũ ããrĩrĩ́ makãrĩ marãdere Jesúya kerere werewãgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pʉrʉ sugʉ Marĩpʉre wereboegʉ Felipere ãsũ ãrĩyupʉ: —Jerusalén merã ããrĩnʉgãwãgãrĩ maa, Gaza wãĩkʉri makã buari maague waaka! Iri maa masaka marĩrõgue ããrĩwãgãa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, Felipe iri maague buagʉ, sugʉ Etiopíamʉrẽ bokajayupʉ. Ĩgʉ̃ iri nikũ marã opo dokamʉ, ããrĩpereri igoya niyerure korerimasʉ̃ ããrĩyupʉ. Ĩgʉ̃ Jerusalẽ́gue Marĩpʉre bʉremugʉ̃ ejadi ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Irogue ejadi ĩgʉ̃ya nikũgue goedujáagʉ, ĩgʉ̃ya tũrũdiru caballua tʉ̃ãdiru wekague doagʉ, Isaías Marĩpʉya kerere weredupiyudi gojadea pũrẽ buegʉ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ĩgʉ̃ bueripoe Õãgʉ̃ deyomarĩgʉ̃ Felipere: —Iriru pʉroweya waaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, Felipe iriru pʉro ũmawãgã, Etiopíamʉ Isaías gojadea pũrẽ buemakʉ̃ péyupʉ. Ĩgʉ̃ irire buemakʉ̃ pégʉ: —¿Mʉ buerire pémasĩrĩ? ãrĩ sẽrẽñayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ĩgʉ̃ gapʉ yʉjʉyupʉ: —¿Nasiri pémasĩbukuri, yʉ gajigʉ yʉre i irasũ ãrĩdʉaro yáa, ãrĩgʉ̃ marĩkeremakʉ̃? Mʉrĩñajãka, irire yʉre buebu, ãrĩyupʉ Felipere. ");
INSERT INTO sri_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ĩgʉ̃ bueri ãsũ ãrĩyuro: Ovejare ñeã wẽjẽderosũta ĩgʉ̃dere ñeã wẽjẽrãkuma. Oveja majĩgʉ̃rẽ ĩgʉ̃ya poarire ĩgʉ̃sã peramakʉ̃, ĩgʉ̃ gaguiníbiriderosũta ĩĩ masakʉde gaguiníbirikumi. ");
INSERT INTO sri_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Masaka ĩgʉ̃rẽ bʉridarãkuma. Ĩgʉ̃ ñerõ iribirikeremakʉ̃, neõ sugʉ ĩgʉ̃rẽ: “Waja opabemi”, ãrĩbirikuma. Irasirirã, ĩgʉ̃ i nikũgue ããrĩripoe ĩgʉ̃ya nikũ marã ĩgʉ̃rẽ ñerõ iri, wẽjẽrãkuma. Ĩgʉ̃sã ñerõ irideare neõ sugʉ werepeomasĩbirikumi, ãrĩ gojadea ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Irire bue odo, Felipere sẽrẽñayupʉ: —Wereka yʉre! ¿Noãrẽ gojagʉ iriyuri Isaías, ĩgʉ̃ basi, o gajigʉguere? ");
INSERT INTO sri_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe ãsũ ãrĩ yʉjʉyupʉ ĩgʉ̃rẽ: —Iri Jesúre ãrĩ gojadea ããrã, ãrĩyupʉ. Irasirigʉ Jesúyare ĩgʉ̃ õãrõ iridea kerere wereyupʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Irasũ wereníwãgãrã, ditarugue ejañurã. Iri ditarure ĩãgʉ̃, Etiopíamʉ Felipere: —Ĩãka! Deko ããrã. ¿Mʉ yʉre wãĩyemakʉ̃ õãgorabukuri? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe gapʉ ĩgʉ̃rẽ: —Mʉ Jesucristore õãrõ bʉremumakʉ̃, mʉrẽ deko merã wãĩyegʉra, ãrĩyupʉ. Etiopíamʉ ĩgʉ̃rẽ ãrĩyupʉ doja: —Jesucristore bʉremua yʉ. Ĩgʉ̃ta Marĩpʉ magʉ̃ ããrĩ́mi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Irasirigʉ Etiopíamʉ ĩgʉ̃ya tũrũdiru wejatugʉre dujupídore, ĩgʉ̃sã pẽrã dijinʉgã, ditarugue ñumuwija, Felipe ĩgʉ̃rẽ deko merã wãĩyeyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ĩgʉ̃rẽ wãĩye odo, ñumuwãgãriripoe gũñaña marĩrõ merã Õãgʉ̃ deyomarĩgʉ̃ Felipere gajirogue ãĩãkõãyupʉ. Etiopíamʉ ĩgʉ̃rẽ dupaturi ĩãnemobirikeregʉ, ĩgʉ̃rẽ waadeare gũña, bʉro ʉsʉyari merã ĩgʉ̃ya makãgue dujáakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe gapʉ Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃rẽ ãĩadero pʉrʉ, Azote wãĩkʉri makãgue ejayupʉ. Irogue eja, makãrĩkʉ Jesúya kerere weregorenagʉ̃, Cesarea wãĩkʉri makãgue weretũnujayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Felipe buegorenaripoe Saulo gapʉ Jesúre bʉremurãrẽ ĩãturigʉ: “Wẽjẽpeokõãgʉra”, ãrĩrĩrẽ piribirisĩã, paía opʉ pʉrogue waa, ãsũ ãrĩyupʉ: ");
INSERT INTO sri_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","—Yʉre papera pũ ãmubosaka, Damascogue waaburire. Iri pũrẽ marĩ nerẽrĩ wiiri marã oparãrẽ wiabu yáa. Iri makã marã Jesúre bʉremurãrẽ ʉ̃ma, nomerẽ, noó yʉ bokajarãrẽ ñeã ãĩrigʉra Jerusalẽ́gue peresu iribu, ãrĩ sẽrẽyupʉ Saulo paía opʉre. ");
INSERT INTO sri_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iri pũrẽ sĩadero pʉrʉ, Saulo gajirã merã Damascogue waakõãyupʉ. Ĩgʉ̃ iri makã ejabu iriripoe gũñaña marĩrõ ʉ̃mʉgasigue merã bʉro kũmijũrõ ĩgʉ̃ pʉrore gosesiridijuyuro. ");
INSERT INTO sri_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Irasũ waamakʉ̃, Saulo yebague meémejãgʉ̃, ãsũ ãrĩ werenímakʉ̃ péyupʉ: —Saulo, ¿nasirigʉ yʉre ñerõ yári mʉ? ");
INSERT INTO sri_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ: “¿Noã ããrĩ́rĩ mʉ?” ãrĩyupʉ. —Yʉ Jesús, mʉ ñerõ irigʉta ããrã. Mʉ yʉre ñerõ irigʉ, mʉ basita ñerõ yáa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Saulo bʉro güi naradari merã: —Yʉ Opʉ, ¿naásũpero gapʉ yʉ irimakʉ̃ gããmerĩ? ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, ĩgʉ̃rẽ: —Wãgãnʉgã, makãgue waaka! Irogue sugʉ yʉ mʉrẽ iridoreburire weregʉkumi, ãrĩyupʉ Jesús Saulore. ");
INSERT INTO sri_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo merã waanerãde Jesús werenírĩrẽ pérã gʉka, werenímasĩbiriñurã. Irire pékererã, Jesús gapʉre neõ ĩãbiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo yebague oyadi wãgãnʉgãja, ĩãpãgʉ̃, neõ ĩãbiriyupʉ. Irasirirã ĩgʉ̃ merãmarã ĩgʉ̃rẽ tʉ̃ãwãgãñurã Damascogue waarã́. ");
INSERT INTO sri_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Irogue eja, ʉrenʉgora koye ĩãbiri, neõ baabiri, iiríbiri iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascoguere sugʉ Jesúre bʉremugʉ̃ Ananías wãĩkʉgʉ ããrĩyupʉ. Kẽrõ irirosũgue Jesús ĩgʉ̃rẽ wereníyupʉ: —¿Ananías, ããrĩ́rĩ mʉ? —Yʉ Opʉ, õõta ããrã, ãrĩ yʉjʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ĩgʉ̃ irasũ ãrĩmakʉ̃, Jesús ĩgʉ̃rẽ: —Wãgãnʉgãka! “Diayema maa” wãĩkʉri maague waaka! Iri maague waagʉ́, Judaya wiigue ñajãa, sugʉ Tarsomʉrẽ Saulo wãĩkʉgʉre sẽrẽñaka! Dapagorare ĩgʉ̃ yʉre sẽrẽgʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ĩgʉ̃dere neãgue kẽrõ irirosũ ããrĩrĩ́ merã ĩmuabʉ. Mʉ ĩgʉ̃ pʉro ñajãa, ĩgʉ̃ya dipurure ñapeori merã dupaturi ĩgʉ̃ya koye ĩãburire ĩmuabʉ. Mʉ wãĩdere ĩmuabʉ ĩgʉ̃rẽ, ãrĩyupʉ Jesús Ananíare. ");
INSERT INTO sri_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, ãsũ ãrĩyupʉ: —Yʉ Opʉ, ĩgʉ̃ mʉrẽ bʉremurãrẽ Jerusalẽ́gue ããrĩrã́rẽ ñerõ iriadeare wárã masaka yʉre wereama. ");
INSERT INTO sri_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","I makã marãdere mʉrẽ bʉremurãrẽ ããrĩpererã mʉ wãĩ merã Marĩpʉre sẽrẽrãrẽ peresu iribu, paía oparã: “Ãsũ irika!” ãrĩ iriuadea pũ merã ejáayupʉ, ãrĩ wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ĩgʉ̃ irasũ ãrĩkeremakʉ̃, Jesús gapʉ: —Ĩgʉ̃ pʉrogue waaka! Ĩgʉ̃ yʉ beyesũdi ããrĩ́mi. Irasirigʉ yaa kerere gaji nikũ marãrẽ, ĩgʉ̃sã oparãrẽ, Israel bumarãdere weregʉkumi. ");
INSERT INTO sri_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Irire weregorenagʉ̃, bʉro ñerõ tarigʉkumi. Yʉ basi ĩgʉ̃rẽ weregʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pé, Ananías Judaya wiigue waa, iri wiigue ñajãa, Saulore bokaja, ĩgʉ̃ya dipurure ñapeo, ãsũ ãrĩyupʉ: —Yaagʉ Saulo, péka yʉre! Marĩ Opʉ Jesúta mʉrẽ maague deyoadi yʉre iriuami, mʉrẽ dupaturi koye ĩãburo, ãrĩgʉ̃. Õãgʉ̃ deyomarĩgʉ̃dere opatariburo, ãrĩgʉ̃, iriuami, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ĩgʉ̃ irasũ ãrĩripoeta Sauloya koyeguere waaí nʉtʉ̃rĩ irirosũ deyori tuuyadea yurisiridijakõãyuro. Õãrõ ĩãkõãyupʉ doja. Irasirigʉ wãgãnʉgã, deko merã wãĩyesũadi dujayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pʉrʉ baa, turakõãyupʉ. Iri makãguere yoaweyaripoe Jesúre bʉremurã merã dujayupʉ dapa. ");
INSERT INTO sri_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Iro ããrĩgʉ̃́, judío masaka nerẽrĩ wiirigue waa, irogue ããrĩrã́rẽ: “Jesús, Marĩpʉ magʉ̃ ããrĩ́mi”, ãrĩ werenayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ĩgʉ̃ weremakʉ̃ pérã, ããrĩpererã pégʉka, ĩgʉ̃sã basi ãsũ ãrĩ gãme wereníñurã: —Ĩĩ Jerusalẽ́gue Jesúre bʉremurãrẽ ĩgʉ̃ wãĩ merã Marĩpʉre sẽrẽrãrẽ wẽjẽdoredita ããrĩ́mi. Dapagorare i makãguedere õõ marãrẽ Jesúre bʉremurãrẽ ñeãgʉ̃ aarigʉ́ iriañumi Jerusalẽ́gue ãĩa, paía oparãguere wiabu, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ĩgʉ̃sã irasũ ãrĩkeremakʉ̃, Saulo gapʉ ʉ̃mʉrikʉ judío masakare, Damascogue ããrĩrã́rẽ güiro marĩrõ õãrõ merã: “Jesús diayeta Marĩpʉ iriudi, Cristo ããrĩ́mi”, ãrĩ werenayupʉ. Ĩgʉ̃ irasũ ãrĩ weremakʉ̃ pérã, ĩgʉ̃rẽ: “Ãrĩkatogʉ yámi ĩĩ”, ãrĩmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yoadero pʉrʉ, surãyeri judío masaka Saulore ĩgʉ̃sã wẽjẽburire werenímurã nerẽñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Irasirirã ʉ̃mʉrikʉ, ñamirikʉ makã tʉro ĩgʉ̃sã ʉ̃tã koeri merã weadea sãrĩrõ makãpʉrore korenañurã ĩgʉ̃rẽ wẽjẽdʉarã. Saulo gapʉ ĩgʉ̃sã ĩgʉ̃rẽ wẽjẽdʉarire masĩkõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Irasirirã su ñami Jesúre bʉremurã wári puui merã ĩgʉ̃rẽ iri sãrĩrõma gobegue yótaudijuñurã. Ãsũ irisĩã, Saulo iri makãrẽ wiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pʉrʉ Jerusalẽ́gue goedujayupʉ doja. Irogue ejagʉ, Jesúre bʉremurã merã ããrĩdʉadiyupʉ. Ĩgʉ̃sã gapʉ ĩgʉ̃rẽ güigorañurã. “Jesúre bʉremugʉ̃ ããrĩbemi ĩĩ”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ĩgʉ̃sã irasirimakʉ̃ ĩãgʉ̃, Bernabé gapʉ Saulore Jesús buedoregʉ beyenerã pʉro ãĩayupʉ. Irogue eja, ĩgʉ̃sãrẽ Saulo maague waagʉ́ ĩgʉ̃ Jesúre ĩãdeare, Jesús ĩgʉ̃ merã wereníadeare, ĩgʉ̃ Damascogue Jesúya kerere güiro marĩrõ merã wereadeadere ĩgʉ̃sãrẽ wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","29","Ĩgʉ̃ irasũ ãrĩ wereadero pʉrʉ, Saulo ĩgʉ̃sã merã ããrĩnʉgãyupʉ. Irasirigʉ ĩgʉ̃sã merã Jerusalẽ́gue güiro marĩrõ marĩ Opʉ Jesúya kerere weregorenayupʉ. Iri kerere weregorenagʉ̃, surãyeri judío masaka, griego ya merã werenírãrẽ were, ĩgʉ̃sã merã gãme wereníyupʉ. Ĩgʉ̃sã gapʉ ĩgʉ̃ wererire pédʉabirisĩã, ĩgʉ̃rẽ wẽjẽdʉadiñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Irasirirã ĩgʉ̃sã wẽjẽdʉamakʉ̃ ĩãrã, Jesúre bʉremurã gapʉ ĩgʉ̃rẽ Cesarea wãĩkʉri makãgue ãĩa, irogue eja, ĩgʉ̃ya makã Tarsogue iriukõãñurã pama. ");
INSERT INTO sri_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ĩgʉ̃ irogue waadero pʉrʉ, ããrĩpererã Jesúre bʉremurã Judea marã, Galilea marã, Samaria marã siñajãrĩ merã dujañurã. Õãgʉ̃ deyomarĩgʉ̃ iritamurõ merã bʉremunemoñurã. Jesúyare goepeyari merã iritʉyañurã. Gajirã wárã ĩgʉ̃rẽ bʉremunʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro ããrĩpereri makãrĩ marãrẽ Jesúre bʉremurãrẽ ĩãgorenagʉ̃ waagʉ́, Lida wãĩkʉri makãguedere ejayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Irogue eja, sugʉ Eneas wãĩkʉgʉre bokajayupʉ. Su mojõma pere gaji mojõ ʉreru pẽrẽbejari bojorigora ĩgʉ̃ya wiiguere dʉpʉ bʉadi peyayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro ĩgʉ̃rẽ ãrĩyupʉ: —Eneas, Jesucristo mʉrẽ taugʉkumi. Wãgãnʉgã, mʉ peyaderore ãmu duripíka! Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, Eneas wãgãnʉgãkõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ããrĩpererã Lida marã, Sarón marãde ĩgʉ̃rẽ ĩãrã, iripoegue ĩgʉ̃sã bʉremunadeare piri, Jesús gapʉre bʉremunʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Gaji makã Jope wãĩkʉri makãgue sugo nomeõ Jesúre bʉremugõ “Tabita” wãĩkʉgo ããrĩyupo. Griego ya merã “Dorcas” wãĩkʉyupo. Igo õãrĩrẽ irigo, boporãrẽ õãrõ iritamugõ ããrĩyupo. ");
INSERT INTO sri_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Iripoere Pedro Lidague ããrĩripoe igo pũrĩrikʉ kõmoakõãyupo. Igo kõmoadero pʉrʉ, ĩgʉ̃sã irinaderosũta igo merãmarã igoya dʉpʉ darore koeñurã. Koe odo, ʉ̃marõma taribugue píñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope, Lida pʉrogã ããrĩyuro. Irasirirã Jope marã Jesúre bʉremurã Pedro Lidague ããrĩmakʉ̃ pérã, ʉ̃ma pẽrãrẽ ĩgʉ̃ pʉrogue iriuñurã. Irogue ejarã, ĩgʉ̃rẽ: —Mumurõ merã Jopegue waaka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, mata Pedro ĩgʉ̃sã merã Jopegue waayupʉ. Irogue ejarã, ĩgʉ̃rẽ Dorcas boadeo peyari taribugue siiu mʉrĩãñurã. Ĩgʉ̃ iri taribugue ejamakʉ̃, wapiweyarã nome Pedro pʉro nerẽnʉgãjañurã. Orerãta, igo ĩgʉ̃sãrẽ surí eabosadeare ĩmuñurã ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro iri taribugue ããrĩrã́rẽ ããrĩpererãrẽ wiriadoreyupʉ. Ĩgʉ̃sã wiriadero pʉrʉ, ñadʉkʉpuri merã ejamejãja, Marĩpʉre sẽrẽyupʉ. Sẽrẽ odo, boadeore gãmenʉgã ĩã: —Tabita, wãgãnʉgãka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, koye ĩãpã, Pedrore ĩãgõta wãgãdoayupo. ");
INSERT INTO sri_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro igoya mojõgue ñeã, tʉ̃ãwãgũnú, pʉrʉ wapiweyarã nomerẽ gajirã Jesúre bʉremurãdere siiumu, ĩgʉ̃sãrẽ wiayupʉ igore. ");
INSERT INTO sri_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ããrĩpererã Jope marã igore ĩgʉ̃ masũadea kerere pépereakõãñurã. Irasirirã wárã Jesúre bʉremunʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro yoaripoe Jopeguere sugʉ Simón wãĩkʉgʉ, waimʉrã gasirire ãmurĩmasʉ̃ya wiigue ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesareaguere Cornelio wãĩkʉgʉ wárã surara, “Italiano” wãĩkʉri bumarã opʉ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio, ããrĩpererã ĩgʉ̃ya wii marã merã Marĩpʉre goepeyari merã bʉremuñurã. Irasirigʉ judío masaka boporãrẽ iritamugʉ̃ wári niyeru sĩnayupʉ. Ʉ̃mʉrikʉ Marĩpʉre sẽrẽnayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sunʉ ñamika tres ããrĩmakʉ̃, kẽrõ irirosũgue sugʉ Marĩpʉre wereboegʉ deyoa, ĩgʉ̃ pʉro ñajãmakʉ̃ ĩãyupʉ. Ñajãa, ĩgʉ̃rẽ: —Cornelio, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio bʉro güiri merã ĩgʉ̃ ditare ĩã: —Yʉ Opʉ, ¿ñeénorẽ gããmerĩ? ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃, Marĩpʉre wereboegʉ ĩgʉ̃rẽ ãrĩyupʉ: —Marĩpʉ mʉ sẽrẽrĩrẽ pémi. Mʉ boporãrẽ niyeru sĩrĩdere ĩãmi. ");
INSERT INTO sri_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Irasirigʉ Simón Pedro wãĩkʉgʉre siiudoregʉ, Jopegue iriuka mʉyarã ʉ̃marẽ! ");
INSERT INTO sri_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ĩgʉ̃ gajigʉ Simón wãĩkʉgʉ waimʉrã gasirire ãmurĩmasʉ̃ya wiigue ããrĩ́mi. Iri wii wádiya tʉro ããrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Marĩpʉre wereboegʉ irasũ ãrĩ odo, waadero pʉrʉ, Cornelio ĩgʉ̃rẽ moãboerã pẽrãrẽ, gajigʉ surara ĩgʉ̃rẽ iritamugʉ̃rẽ Marĩpʉre goepeyari merã bʉremugʉ̃rẽ siiuyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ĩgʉ̃sãrẽ siiu, ããrĩpereri Marĩpʉre wereboegʉ ĩgʉ̃rẽ wereadeare wereyupʉ. Were odo, ĩgʉ̃sãrẽ Jopegue iriukõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ĩgʉ̃sã waadeanʉ gajinʉ gapʉ goeripoe ããrĩmakʉ̃, Jopegue ejamurã iriripoe Pedro ĩgʉ̃ ããrĩrĩ́ wii wekague Marĩpʉre sẽrẽgʉ̃ mʉrĩayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ĩgʉ̃ irogue ããrĩgʉ̃́ bʉro ʉaboa, baadʉadiyupʉ. Iri wii marã ĩgʉ̃sã baari ãmuripoe kẽrõ irirosũ waasũ, ʉ̃mʉgasi tũpãmakʉ̃ ĩãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Irasũ tũpãmakʉ̃, suñe suríro irirosũ deyori gasiro wapikʉri tʉrori sʉadea gasiro miẽ, yebague dijarimakʉ̃ ĩãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Iri gasiro poekaguere ããrĩpererã waimʉrã: paárã, yebague sĩgʉ̃wãgãrã, wʉ́rã sãñañurã. ");
INSERT INTO sri_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Marĩpʉ ĩgʉ̃rẽ: —Pedro, wãgãnʉgã, ĩĩsãrẽ wẽjẽ baaka! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ĩgʉ̃ irasũ ãrĩmakʉ̃: —Yʉ Opʉ, yʉ ĩgʉ̃sãnorẽ neõ baañabea. Ñerãrẽ, mʉ gʉare baadorebirinerãrẽ neõ baabea, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Marĩpʉ ĩgʉ̃rẽ dupaturi ãrĩnemoyupʉ doja: —Yʉ: “Õãrã ããrĩ́ma”, ãrĩrãrẽ, ĩgʉ̃sãrẽ: “Ñerã, baaya marĩrã ããrĩ́ma”, ãrĩbirikõãka! ");
INSERT INTO sri_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ʉrea ĩgʉ̃rẽ irire ĩmuadero pʉrʉ, iri gasirore ʉ̃mʉgasigue ãĩmʉrĩãkõãyupʉ doja. ");
INSERT INTO sri_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro: “¿Naásũ ãrĩdʉaro irikuri iri yʉre ĩmuadea?” ãrĩ gũñarikʉripoe Cornelio iriuanerã ĩgʉ̃ ããrĩrĩ́ wii makãpʉro: “¿Simṍya wii noógue ããrĩ́rĩ?” ãrĩ sẽrẽñarã ejañurã. ");
INSERT INTO sri_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Irogue eja, iri wii marãrẽ: “¿Õõta ããrĩ́rĩ, Simón Pedro wãĩkʉgʉ?” ãrĩ oeñurã. ");
INSERT INTO sri_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro ĩgʉ̃ ĩãdeare gũñagʉ̃ iriyupʉ dapa. Ĩgʉ̃ irire gũñaripoe Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃rẽ: —Ĩãka! Ʉ̃ma ʉrerã ãmarã́ yáma mʉrẽ. ");
INSERT INTO sri_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Murĩgora dijapurumuka! “¿Naásũ waarokuri yʉre?” ãrĩ, neõ gũñarikʉro marĩrõ ĩgʉ̃sã merã waaka! Yʉ ĩgʉ̃sãrẽ iriuabʉ mʉrẽ, ãrĩyupʉ Pedrore. ");
INSERT INTO sri_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro dija, ĩgʉ̃sãrẽ: —Yʉta ããrã mʉsã ãmagʉ̃́. ¿Nasirirã aarari? ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ĩgʉ̃sã ĩgʉ̃rẽ ãrĩñurã: —Surara opʉ Cornelio wãĩkʉgʉ gʉare iriuami. Ĩgʉ̃ õãrĩrẽ irigʉ, Marĩpʉre goepeyari merã bʉremugʉ̃ ããrĩ́mi. Ããrĩpererã judío masaka ĩgʉ̃rẽ: “Õãgʉ̃ ããrĩ́mi”, ãrĩ ĩãma. Sugʉ Marĩpʉre wereboegʉ mʉrẽ ĩgʉ̃ya wiigue waadoregʉ siiudoreayupʉ. Mʉ ĩgʉ̃ pʉro waamakʉ̃, mʉ wererire pégʉkumi. Irasirirã mʉrẽ siiurã aarirã́ iriabʉ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pedro: “Ñajãrika! Õõ kãrĩka dapagã ñamirẽ!” ãrĩyupʉ. Gajinʉ gapʉ ĩgʉ̃sã merã waakõãyupʉ. Gajirãde Jope marã Jesúre bʉremurã ĩgʉ̃sã merã wapikʉwãgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Gajinʉ gapʉ Cesareaguere ejañurã. Cornelio gapʉ, ĩgʉ̃yarãrẽ, ĩgʉ̃ merãmarãdere ĩgʉ̃ya wiigue siiu neeõ, Pedrore yúyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro ĩgʉ̃ya wii ejamakʉ̃, Cornelio makãpʉrogue bokatĩrĩgʉ̃ wiria, ñadʉkʉpuri merã ejamejãyupʉ ĩgʉ̃rẽ bʉremugʉ̃. ");
INSERT INTO sri_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ĩgʉ̃ irasirimakʉ̃ ĩã, Pedro gapʉ ĩgʉ̃rẽ tʉ̃ãwãgũnú: —Wãgãnʉgãka! Yʉde mʉ irirosũta masakʉ ããrã, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ĩgʉ̃ya wiigue weretamu ñajãrã, Pedro wárã masaka irogue nerẽanerãrẽ bokajayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Irasũ bokajagʉ, ĩgʉ̃sãrẽ ãrĩyupʉ: —Gʉa judío masaka ããrĩrã́, judío masaka ããrĩmerãya wiiriguere ñajãrã, Moisés gʉare pídeare tarinʉgãbukoa. Mʉsã irire õãrõ masĩa. Marĩpʉ gapʉ gaji bumarãrẽ: “Ñerã ããrĩ́ma”, ãrĩdorebirami yʉre. ");
INSERT INTO sri_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Irasirigʉ mʉ iriuanerã yʉre siiurimakʉ̃, “Waabea”, ãrĩrõ marĩrõ mata aarabʉ. Dapagora yʉ õõgue ejasĩã, mʉsãrẽ: “¿Nasiribu yʉre siiuari?” ãrĩ sẽrẽñadʉakoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio ĩgʉ̃rẽ ãrĩyupʉ: —Wapikʉrinʉ taria i horanota tres ããrĩmakʉ̃, i wii yʉ bere, Marĩpʉre sẽrẽripoe gũñaña marĩrõ sugʉ ʉ̃mʉ suríro bʉro goseriñe sãñagʉ̃ deyoa: ");
INSERT INTO sri_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Cornelio, Marĩpʉ mʉ sẽrẽrĩrẽ pémi. Mʉ boporãrẽ iritamurĩdere ĩãmi”, ãrĩmi yʉre. ");
INSERT INTO sri_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","“Mʉyarã ʉ̃marẽ iriuka, Jopegue Simón Pedro wãĩkʉgʉre siiudoregʉ. Ĩgʉ̃ gajigʉ Simón wãĩkʉgʉ waimʉrã gasirire ãmugʉ̃́ya wiigue wádiya tʉro ããrĩrĩ́ wiigue ããrĩ́mi. Ĩgʉ̃ mʉ pʉro ejagʉ, mʉrẽ weregʉkumi”, ãrĩ weremi yʉre. ");
INSERT INTO sri_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Irasirigʉ mata yaarã ʉ̃marẽ mʉrẽ siiudoregʉ iriuabʉ. Irasirigʉ mʉ gʉa pʉro õãrõ aarayo. Marĩ ããrĩpererã õõrẽ Marĩpʉ ĩũrõ ããrã. Irasirirã ããrĩpereri mʉrẽ Marĩpʉ weredorerire mʉ gʉare weremakʉ̃ pédʉakoa, ãrĩyupʉ Cornelio Pedrore. ");
INSERT INTO sri_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ãsũ ãrĩ werenʉgãyupʉ ĩgʉ̃sãrẽ: —Yʉ dapagoragueta pémasĩa. Diayeta ããrã. Marĩpʉ marĩ ããrĩpererãrẽ surosũ ĩãmi. ");
INSERT INTO sri_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Irasirigʉ ããrĩpereri bumarã ĩgʉ̃rẽ bʉremu, õãrĩrẽ irirãnorẽ ĩãbéobirikumi. ");
INSERT INTO sri_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Marĩpʉ ĩgʉ̃ya kerere judío masakare pídi ããrĩmí. “Jesucristo merã siñajãrĩ bokarãkuma”, ãrĩdi ããrĩmí. Ĩgʉ̃ta ããrĩpererã Opʉ ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ããrĩpereri gʉa judío masaka ããrĩrĩ́ nikũgue waadeare õãrõ masĩkoa mʉsã. Juan masakare bue, ĩgʉ̃sãrẽ deko merã wãĩyemi. Ĩgʉ̃ irasiriadero pʉrʉ, Jesús Galileague buenʉgãmi. ");
INSERT INTO sri_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Idere masĩkoa mʉsã. Ĩĩ Jesús Nazaretmʉrẽ Marĩpʉ Õãgʉ̃ deyomarĩgʉ̃ merã ĩgʉ̃rẽ turarire sĩdi ããrĩmí. Marĩpʉ ĩgʉ̃ merã ããrĩníkõãdi ããrĩmí. Irasirigʉ Jesús masakare õãrĩrẽ irigorenami. Noó ĩgʉ̃ waaró ããrĩpererã wãtĩ doreri irirãrẽ taumi. ");
INSERT INTO sri_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Gʉa judío masaka ããrĩrĩ́ nikũgue Jerusalẽ́guedere ããrĩpereri ĩgʉ̃ irideare ĩãbʉ. Irogue ĩgʉ̃rẽ curusague pábiatú wẽjẽma. ");
INSERT INTO sri_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ĩgʉ̃sã wẽjẽkeremakʉ̃, ʉrenʉ waaró merã Marĩpʉ gapʉ ĩgʉ̃rẽ masũkõãdi ããrĩmí. Ĩgʉ̃rẽ masũ, pʉrʉ gʉare deyoamakʉ̃ irimi, ĩgʉ̃ dupaturi okarire masĩburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jesús ããrĩpererã masakare deyoabiridi ããrĩmí. Gʉa ditare deyoami. Ĩgʉ̃ deyoamakʉ̃, gʉa ĩgʉ̃ merã baa, iiríbʉ. Iripoegueta Marĩpʉ gʉare beyedi ããrĩmí, Jesúre ĩgʉ̃ masũadire ĩãmurãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Marĩpʉ Jesúreta masaka ããrĩpererã okarãrẽ, boanerãdere: “Õãrãrẽ taugʉkoa, ñerã gapʉre wajamoãgʉkoa!” ãrĩ beyebure pídi ããrĩmí. Irire masakare weredoremi gʉare Jesús. ");
INSERT INTO sri_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ããrĩpererã Jesúre bʉremurãrẽ Marĩpʉ ĩgʉ̃sã ñerõ irideare kãtigʉkumi, ãrĩrĩrẽ gojanerã ããrĩmá ããrĩpererã Marĩpʉya kerere weredupiyunerã, ãrĩ wereyupʉ Pedro Cornelioya wii nerẽanerãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro werenírĩrẽ pérãguere Õãgʉ̃ deyomarĩgʉ̃ dijijayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Ĩgʉ̃ ejadero pʉrʉ, ĩgʉ̃sã gajirã ya merã werenímasĩbirideare werenínʉgã, ʉsʉyari merã Marĩpʉre: “Õãtarigʉ ããrã mʉ”, ãrĩ bʉremuñurã. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, Pedro merã irogue ejanerã judío masaka Jesúre bʉremurã pégʉkakõãñurã. “Marĩpʉ Õãgʉ̃ deyomarĩgʉ̃rẽ iriumi judío masaka ããrĩmerãdere”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Irasirigʉ Pedro ĩgʉ̃ merãmarãrẽ ãrĩyupʉ: —Marĩpʉ Õãgʉ̃ deyomarĩgʉ̃rẽ marĩ judío masakare iriuderosũta ĩĩsãdere iriumi. Irasirirã ĩgʉ̃sã Õãgʉ̃ deyomarĩgʉ̃rẽ opamakʉ̃ ĩãrã, marĩ ĩgʉ̃sãrẽ deko merã wãĩyebirikõãrã, ãrĩmasĩña máa. ");
INSERT INTO sri_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Irasirirã: “Mʉsã Jesucristore bʉremurã ĩgʉ̃yarã ããrã”, ãrĩ wãĩyeka ĩgʉ̃sãrẽ! ãrĩ wereyupʉ Pedro ĩgʉ̃ merãmarãrẽ. Ĩgʉ̃sãrẽ wãĩyeadero pʉrʉ, Pedrosãrẽ: “Yoaweyaripoe dujaka gʉa merã dapa!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesús buedoregʉ beyenerã, gajirã ĩgʉ̃rẽ bʉremurã Judeague ããrĩrã́: “Judío masaka ããrĩmerãde Marĩpʉyare bʉremuma”, ãrĩrĩ kerere péñurã. ");
INSERT INTO sri_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro Cesareague ããrãdi Jerusalẽ́gue dujajamakʉ̃ ĩãrã, iro marã judío masaka Jesúre bʉremurã ĩgʉ̃rẽ ãsũ ãrĩ werewʉa, sẽrẽñañurã: ");
INSERT INTO sri_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—¿Nasirigʉ judío masakʉ ããrĩkeregʉ, judío masaka ããrĩmerãya wiigue ñajãa, ĩgʉ̃sã merã baáari? ");
INSERT INTO sri_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Pedro ããrĩpereri ĩgʉ̃rẽ irogue waadeare ãsũ ãrĩ wereyupʉ: ");
INSERT INTO sri_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Yʉ Jopegue ããrĩgʉ̃́, Marĩpʉre sẽrẽripoe kẽrõ irirosũ waabʉ yʉre. Ʉ̃mʉgasigue suñe suríro irirosũ deyori gasiro wapikʉri tʉrori sʉadea gasiro miẽ, yʉ pʉro dijarimakʉ̃ ĩãbʉ. ");
INSERT INTO sri_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Yʉ iri gasiro poekaguere: “¿Ñeéno ããrĩ́rĩ?” ãrĩ, õãrõ ĩãgʉ̃, ããrĩpererã waimʉrã: paárã, makãnʉ́ʉ marã, yebague sĩgʉ̃wãgãrã, wʉ́rã sãñamakʉ̃ ĩãbʉ. ");
INSERT INTO sri_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yʉ ĩgʉ̃sãrẽ ĩãníripoe Marĩpʉ yʉre: “Pedro, wãgãnʉgãka! Ĩgʉ̃sãrẽ wẽjẽ baaka!” ãrĩmakʉ̃ pébʉ. ");
INSERT INTO sri_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Yʉ gapʉ ĩgʉ̃rẽ yʉjʉbʉ: “Baabea yʉ Opʉ. Gajirã waimʉrã gʉa judío masaka baaya marĩrã ããrĩ́ma. Neõ suñarõ ĩgʉ̃sãnorẽ baañabi ããrĩkubʉ”, ãrĩbʉ ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Yʉ irasũ ãrĩmakʉ̃, Marĩpʉ ʉ̃mʉgasigue ããrĩgʉ̃́ dupaturi ãrĩmi doja: “Yʉ baadorerãrẽ: ‘Baaya marĩrã ããrĩ́ma’”, ãrĩbirikõaka! ãrĩmi yʉre. ");
INSERT INTO sri_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ʉrea ĩgʉ̃ irire ĩmuadero pʉrʉ, iri gasirore ããrĩpererã merã ʉ̃mʉgasigue ãĩmʉrĩãkõãmi doja. ");
INSERT INTO sri_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Irasiriripoeta ʉrerã ʉ̃ma Cesarea marã yʉre siiudorerã iriuanerã yʉ ããrĩrĩ́ wiiguere ejama. ");
INSERT INTO sri_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Õãgʉ̃ deyomarĩgʉ̃ yʉre: “‘Ĩgʉ̃sã judío masaka ããrĩmerã merã waabea’, ãrĩ gũñabita waaka!” ãrĩmi. Irasirigʉ yʉ Jope marã Jesúre bʉremurã su mojõma pere gaji mojõ suru pẽrẽbejarã merã waa, Cesareaguere eja, gʉa ããrĩpererã Cornelioya wiigue ñajãbʉ. ");
INSERT INTO sri_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Gʉa iro ñajãjamakʉ̃, Cornelio gʉare: “Sugʉ Marĩpʉre wereboegʉ yaa wii ñajãjamakʉ̃ ĩãbʉ. Ĩgʉ̃ yʉre: ‘Jopegue ʉ̃ma mʉyarãrẽ iriuka, Simón Pedro wãĩkʉgʉre siiudoregʉ!’ ãrĩmi”, ãrĩ weremi. ");
INSERT INTO sri_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","“‘Ĩgʉ̃ mʉrẽ Marĩpʉyare weremakʉ̃ bʉremugʉ̃, mʉ, mʉyarã ããrĩpererã õãrõ tarirãkoa. Ʉ̃mʉgasiguere Marĩpʉ merã õãrõ ʉsʉyari bokarãkoa’, ãrĩ weremi yʉre Marĩpʉre wereboegʉ”, ãrĩmi Cornelio. ");
INSERT INTO sri_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Irasirigʉ yʉ ĩgʉ̃sãrẽ werenʉgãripoe Õãgʉ̃ deyomarĩgʉ̃ marĩrẽ neõgora ĩgʉ̃ dijijaderosũta ĩgʉ̃sãguere dijijami. ");
INSERT INTO sri_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Irasirimakʉ̃ ĩãgʉ̃, Jesús ãrĩdeare gũñabokabʉ. Ãsũta ãrĩmi: “Juan mʉsãrẽ deko merã wãĩyedi ããrĩmí. Yʉ gapʉ mʉsãrẽ Õãgʉ̃ deyomarĩgʉ̃ merã wãĩyegʉkoa, ĩgʉ̃ mʉsã merã ããrĩníkõãburo, ãrĩgʉ̃”. ");
INSERT INTO sri_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Marĩpʉ marĩrẽ iriuderosũta Õãgʉ̃ deyomarĩgʉ̃rẽ iriumi, judío masaka ããrĩmerãdere, marĩ Opʉ Jesucristore ĩgʉ̃sã bʉremumakʉ̃. Ĩgʉ̃ irasirimakʉ̃ ĩãgʉ̃, Marĩpʉre: “Irasiribirikõãka ĩgʉ̃sãrẽ!” ãrĩmasĩbiribʉ yʉ, ãrĩ wereyupʉ Pedro iro ããrĩrã́rẽ. ");
INSERT INTO sri_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ĩgʉ̃ wereadero pʉrʉ, toeperea: —Marĩpʉ judío masaka ããrĩmerãdere ĩgʉ̃sã ñerõ irideare bʉjawere, piridoremi, ĩgʉ̃sãde ʉ̃mʉgasigue ĩgʉ̃ merã õãrõ ʉsʉyari bokaburo, ãrĩgʉ̃, ãrĩ, ʉsʉyari sĩñurã Marĩpʉre. ");
INSERT INTO sri_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebãrẽ wẽjẽadero pʉrʉ, Jesúre bʉremurãrẽ ñerõ iriñurã. Irasirirã surãyeri Feniciague, gajirã Chipre nʉgʉ̃rõgue, gajirã Antioquíague duriwãgãñurã. Ĩgʉ̃sã irogue ejarã, Jesúya kerere wereñurã judío masaka ditare. ");
INSERT INTO sri_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Surãyeri Jesúre bʉremurã Chipre marã, Cirene marã ããrĩñurã. Ĩgʉ̃sã Antioquíague eja, judío masaka ããrĩmerãrẽ Jesúya kerere wereñurã. “Jesús, marĩrẽ taugʉ, ããrĩpererã Opʉ ããrĩ́mi”, ãrĩ wereñurã ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Marĩpʉ irasũ ãrĩ wererãrẽ õãrõ iritamuyupʉ. Irasirirã ĩgʉ̃sã weremakʉ̃ pérã, iro marã wárã Jesúre bʉremunʉgãñurã. Ĩgʉ̃sã dupiyuro bʉremudeare pirikõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","“Ĩgʉ̃sãde Jesúre bʉremuma”, ãrĩrĩ kerere pérã, Jerusalén marã Jesúre bʉremurã Bernabére Antioquíague iriuñurã: “‘¿Naásũ waáari?’ ãrĩ ĩãgʉ̃ waaka!” ãrĩrã. ");
INSERT INTO sri_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Irasirigʉ irogue eja, Marĩpʉ ĩgʉ̃sãrẽ ĩgʉ̃ iritamuadeare ĩã, bʉro ʉsʉyari merã: —Marĩ Opʉ Jesúre õãrõ bʉremuníka! Ĩgʉ̃rẽ bʉremurĩrẽ neõ piribirikõãka! ãrĩ wereyupʉ ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé Õãgʉ̃ deyomarĩgʉ̃rẽ opatarigʉ, õãgʉ̃, Jesúre õãrõ bʉremugʉ̃ ããrĩyupʉ. Irasirirã ĩgʉ̃ weremakʉ̃ pérã, wárã masaka Jesúre bʉremuñurã. ");
INSERT INTO sri_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pʉrʉ Bernabé Antioquíague ããrãdi Saulore Tarsogue ããrĩgʉ̃́rẽ ãmagʉ̃́ waayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ĩgʉ̃rẽ bokaja, ĩgʉ̃sã pẽrãgueta Antioquíague goedujaja, Jesúre bʉremurã merã su bojorigora iri makãguere ããrĩñurã. Iroguere wárã masakare Jesúyare bueñurã. Iripoe merãta iro marãrẽ Jesúre bʉremurãrẽ: “Cristoyarã, Cristiano ããrĩ́ma”, ãrĩ wãĩyepʉroriñurã. ");
INSERT INTO sri_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bernabé, Saulo merã Antioquíague ããrĩripoe gajirã Jerusalén marã Marĩpʉya kerere weredupiyurã iroguere waañurã. ");
INSERT INTO sri_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sugʉ ĩgʉ̃sã merã, Agabo wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃ irogue eja, Õãgʉ̃ deyomarĩgʉ̃ masĩrĩ sĩrĩ merã iro marãrẽ: —Ããrĩpereroguere masaka ʉaboarãkuma, ãrĩ wereyupʉ ĩgʉ̃sãrẽ. Claudio wãĩkʉgʉ romano marã opʉ ñajãdero pʉrʉ Agabo ĩgʉ̃ ãrĩdea waayuro. ");
INSERT INTO sri_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, Antioquía marã Jesúre bʉremurã ãsũ ãrĩñurã: —Marĩ Judeague ããrĩrã́rẽ Jesúre bʉremurãrẽ marĩ niyeru oparire, marĩ sĩrõ bokatĩũrõ iriurã! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Irasirirã niyeru neeõ, Bernabé, Saulo merã: “Jesús buedoregʉ beyenerãrẽ iritamurãrẽ wiaka!” ãrĩ iriuñurã. ");
INSERT INTO sri_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Iripoere Herodes wãĩkʉgʉ Judea marã opʉ, surãyeri Jesúre bʉremurã Jerusalẽ́gue ããrĩrã́rẽ ñerõ irinʉgãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Irasirigʉ ĩgʉ̃yarã surarare Santiagore Juan tĩ́gʉ̃rẽ sareri majĩ merã wẽjẽdoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ĩgʉ̃rẽ wẽjẽmakʉ̃ ĩãrã, judío masaka ʉsʉyañurã. Herodes ĩgʉ̃sã ʉsʉyamakʉ̃ ĩãgʉ̃, Pedrore ñeãdore, peresu iriyupʉ. Irasiriripoe pã́ wemasãrĩ morẽña marĩrĩ baari bosenʉ pascua bosenʉ ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ĩgʉ̃rẽ peresu iriadero pʉrʉ, wapikʉri bu surarare gorawayu koredoreyupʉ. Iri burikʉ wapikʉrã dita ããrĩñurã. “Pascua bosenʉ pʉrʉ, ãĩwiugʉra masaka ĩũrõgue ĩgʉ̃rẽ wẽjẽdorebu”, ãrĩ gũñadiyupʉ Herodes. ");
INSERT INTO sri_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Irasirirã Pedrore surara õãrõ koreníkõãñurã. Ĩgʉ̃ irogue ããrĩripoe Jesúre bʉremurã gapʉ Marĩpʉre bʉro sẽrẽbosaníkõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes Pedrore masaka ĩũrõgue ĩgʉ̃rẽ ãĩwiuburi ñamirẽ pẽrã surara watopegue peda kõmeda merã sʉasũadi kãrĩyupʉ. Gajirã surara pẽrã makãpʉro wiriarore koreñurã. ");
INSERT INTO sri_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ããrĩpererã kãrĩripoe gũñaña marĩrõ sugʉ Marĩpʉre wereboegʉ Pedro ããrĩrĩ́ taribugue deyoayupʉ. Irasiriro iri taribu poekague õãrõ boyosiriakõãyuro. Marĩpʉre wereboegʉ Pedroya dʉkare túkare, ĩgʉ̃rẽ yobeyupʉ. —Murĩgora wãgãnʉgãka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, Pedroya mojõrĩrẽ ĩgʉ̃sã kõmedari sʉadea kuradijakõãyuro. ");
INSERT INTO sri_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Marĩpʉre wereboegʉ ĩgʉ̃rẽ: —Yʉjʉtúka! Mʉya gubu suríre sãñaka! ãrĩyupʉ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, yʉjʉtú, ĩgʉ̃ya gubu suríre sãñayupʉ. Ĩgʉ̃ sãña odomakʉ̃, ãrĩyupʉ doja: —Wekamañe surírore sãñaka! Náka, yʉ merã! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pedro ĩgʉ̃rẽ tʉyawiriayupʉ. “¿Diayeta Marĩpʉre wereboegʉ yʉre ãĩwiriagʉ irikuri? Gajipoe irigʉ kẽgʉ̃ iribukoa”, ãrĩ gũñayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Marĩpʉre wereboegʉ, Pedro merã surara korerã ããrĩpʉrorirãrẽ tari, pʉrʉ gajirãrẽ tari, iri wii ñajãpʉroriri kõme makãpʉrogue ejañurã. Iro ĩgʉ̃sã ejamakʉ̃, iri makãpʉro basi tũpãkõãyuro. Iri makãpʉrore tariwiria, yoaweyaro waa, Marĩpʉre wereboegʉ dederiakõãyupʉ. Pedro sugʉta dujayupʉ pama. ");
INSERT INTO sri_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Marĩpʉre wereboegʉ dederiadero pʉrʉ, Pedro ĩgʉ̃rẽ waadeare õãrõ pémasĩ: —Diayeta Marĩpʉ yʉre wijatadoregʉ, ĩgʉ̃rẽ wereboegʉre iriuañumi Herodes yʉre ñerõ iribirikõãburo, ãrĩgʉ̃, gaji ããrĩpereri judío masaka yʉre ñerõ iridʉarire kãmutadoregʉ, ãrĩ gũñayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Irire gũñawãgã, Maríaya wiigue ejayupʉ. Igo, Juan Marcos wãĩkʉgʉ pago ããrĩyupo. Iri wiiguere masaka wárã nerẽ, Marĩpʉre sẽrẽbosarã iriñurã ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Irogue ejagʉ, Pedro iri wii tʉro ñajãri makãpʉrore doteyupʉ. Ĩgʉ̃ dotemakʉ̃ pégo, sugo Rode wãĩkʉgo iri wii marãrẽ moãboego: “¿Noã ããrĩ́rĩ?” ãrĩ ĩãgõ waayupo. ");
INSERT INTO sri_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ĩgʉ̃ werenírĩrẽ pémasĩ, makãpʉrore tũpãbeota ʉsʉyari merã ũmañajãa, iro nerẽanerãrẽ: “Pedro makãpʉro ããrĩgʉ̃́ kárinami”, ãrĩ wereyupo. ");
INSERT INTO sri_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Igo irasũ ãrĩmakʉ̃ pérã, igore: “Mʉ irasũ ãrĩmoãmakõãgõ yáa”, ãrĩ, igo wererire bʉremubiriñurã. Igo gapʉ ĩgʉ̃sãrẽ: “Diayeta ãrã yʉ”, ãrĩyupo. “Iro merẽ Pedroya yʉjʉpũrã ããrĩkoa”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro gapʉ makãpʉrore dotegʉ iriyupʉ dapa. Irasirimakʉ̃ waa, iri makãpʉrore tũpã, ĩgʉ̃ iro nímakʉ̃ ĩãrã, gʉkakõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ĩgʉ̃ gapʉ ĩgʉ̃ya mojõ merã irikeo, ĩgʉ̃sãrẽ toedoreyupʉ. Pʉrʉ wiigue ñajãja, ĩgʉ̃ peresu ããrĩgʉ̃́rẽ Marĩpʉ ĩgʉ̃rẽ ãĩwiriadeare wereyupʉ ĩgʉ̃sãrẽ: —Irire wereka, Santiagore, gajirã Jesúre bʉremurãrẽ! ãrĩ were odo, gajirogue waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pʉrʉ boyoripoe peresu korerã Pedro marĩmakʉ̃ ĩãrã: “¿Naásũ waáayuri?” ãrĩ gãme gaguiníñurã ĩgʉ̃sã basi. ");
INSERT INTO sri_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Irasirigʉ Herodes ĩgʉ̃yarã surarare Pedrore ãmadoreyupʉ. Ĩgʉ̃sã bokabirimakʉ̃ ĩãgʉ̃, Pedrore koreadinerãrẽ bʉro sẽrẽña, ĩgʉ̃sã yʉjʉbirimakʉ̃, ĩgʉ̃sãrẽ wẽjẽdoreyupʉ. Pʉrʉ Judeare wiri, Cesareague ããrĩgʉ̃́ waayupʉ Herodes. ");
INSERT INTO sri_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Iripoere Herodes Tiro, Sidón wãĩkʉri makãrĩ marã merã bʉro guayupʉ. Iri makãrĩ marã baari, Herodeya nikũ marã duadea ããrĩyuro. Irasirirã, ĩgʉ̃ guamakʉ̃ ĩãrã: “Gʉare baari duabiribukumi”, ãrĩ, ĩgʉ̃ pʉrogue irire ãmurã́ waañurã. Irogue eja, Herodeya wii koregʉ Blasto wãĩkʉgʉre: “Iritamuka gʉare!” ãrĩñurã. Ĩgʉ̃: “Jáʉ”, ãrĩmakʉ̃ pérã: “Herodere wereníbosaka, ĩgʉ̃ gʉa merã guanemobirikõãburo, ãrĩgʉ̃!” ãrĩñurã ĩgʉ̃rẽ. ");
INSERT INTO sri_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Irasirigʉ Herodes ĩgʉ̃sã merã werenídʉarinʉ ejamakʉ̃, opʉ sãñarĩ suríre sãña, masaka ĩũrõ opʉ doarogue doa, ĩgʉ̃sãrẽ wereníyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ĩgʉ̃ irasũ werenímakʉ̃ pérã, masaka gaguiníñurã: —Ĩĩ õõ werenígʉ̃ masakʉ ããrĩbemi. Ʉ̃mʉgasigue marã Opʉ ããrĩ́mi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Herodes ĩgʉ̃sãrẽ: “Masakʉta ããrã yʉ”, ãrĩbiriyupʉ. Irasirigʉ Marĩpʉre bʉremubiri waja, mata Marĩpʉre wereboegʉ Herodere pũrĩrikʉmakʉ̃ iriyupʉ. Irasirigʉ Herodes beka baaweasũ boakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Iri irasũ waadero pʉrʉ, Jesúre bʉremurã Marĩpʉya kerere ããrĩpereroguere weregorenañurã. Wárã masaka irire péñurã. ");
INSERT INTO sri_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé, Saulo merã Jerusalẽ́gue gajirã Jesúre bʉremurãrẽ iritamu odo, Antioquíague gãme dujáañurã. Juan Marcos wãĩkʉgʉde ĩgʉ̃sã merã waayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquíaguere Jesúre bʉremurã watopegue surãyeri Marĩpʉya kerere weredupiyurã, gajirã masakare buerimasã ããrĩñurã. Bernabé ĩgʉ̃sã merãmʉ ããrĩyupʉ. Gajigʉ Simón wãĩkʉgʉ ããrĩyupʉ. Ĩgʉ̃rẽta masaka: “Ñígʉ̃” ãrĩ wãĩyeñurã. Gajigʉ Lucio wãĩkʉgʉ Cirenemʉ ããrĩyupʉ. Gajigʉ Manaén wãĩkʉgʉ, Herodes Galilea marã opʉ dagʉ merã suro merã masãdi ããrĩyupʉ. Gajigʉ Saulo ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sunʉ ĩgʉ̃sã bere, Marĩpʉre sẽrẽripoe Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃sãrẽ wereyupʉ: —Bernabére, Saulore beyepíka! Ĩgʉ̃sã yʉre moãboemurã, yʉ beyesũnerã ããrĩ́ma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ĩgʉ̃sã bere, Marĩpʉre sẽrẽ odo, ĩgʉ̃sãya dipure ñapeo, seretu iriuñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pʉrʉ Bernabé, Saulo merã Õãgʉ̃ deyomarĩgʉ̃ ĩgʉ̃sãrẽ iriuderosũta Seleucia wãĩkʉri makãgue waa, irogue eja, doódiru merã Chipre wãĩkʉri nʉgʉ̃rõgue waañurã. ");
INSERT INTO sri_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Iri nʉgʉ̃rõma makã Salamina wãĩkʉri makãrẽ eja, judío masaka nerẽrĩ wiirigue Marĩpʉya kerere wereñurã. Juan Marcode ĩgʉ̃sãrẽ iritamugorenayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pʉrʉ iri nʉgʉ̃rõrẽ tariwerewãgã, Pafos wãĩkʉri makãgue ejañurã. Irogue ejarã, sugʉ judío masakʉre yé ããrĩgʉ̃́rẽ bokajañurã. Ĩgʉ̃ Barjesús wãĩkʉgʉ ããrĩyupʉ. Griego ya merã Elimas wãĩkʉyupʉ. Iri makã marãrẽ: “Ʉ̃mʉgasigue marã Opʉya kerere weredupiyurimasʉ̃ ããrã yʉ”, ãrĩkatogorenayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Sergio Paulo wãĩkʉgʉ merãmʉ ããrĩyupʉ. Sergio Paulo iri nʉgʉ̃rõ marã opʉ, wári masĩgʉ̃ ããrĩyupʉ. Ĩgʉ̃ Marĩpʉya kerere pédʉagʉ, Bernabé, Saulore siiudoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Irasirirã ĩgʉ̃sã ĩgʉ̃ pʉrogue wererã waañurã. Elimas, yé ããrĩgʉ̃́ gapʉ Sergio Paulo Jesúre bʉremumakʉ̃ gããmebiriyupʉ. Irasirigʉ ĩgʉ̃sã wererire kãmutadʉadiyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Irasirimakʉ̃, Saulo Õãgʉ̃ deyomarĩgʉ̃rẽ opatarigʉ, ĩgʉ̃rẽ bʉro ĩãyupʉ. Saulota, “Pablo” wãĩkʉyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ãsũ ãrĩyupʉ: —Mʉ ãrĩkatorikʉgʉ, ñegʉ̃, ããrĩpereri õãrõ iririre kãmutadʉagʉ, wãtĩ irirosũ ããrã. Marĩ Opʉya diayemarẽ gorawayudʉagʉ ããrã. ");
INSERT INTO sri_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mʉ irasiriri waja marĩ Opʉ mʉrẽ wajamoãgʉkumi. Irasirigʉ mʉ koye ĩãbi dujagʉkoa. Marĩ Opʉ mʉrẽ wajamoãrõpa abe gosesiririre ĩãbirikoa, ãrĩyupʉ Pablo ĩgʉ̃rẽ. Ĩgʉ̃ irasũ ãrĩrĩ merãta ĩgʉ̃rẽ naĩtĩãkõãyuro. Neõ koye ĩãbi dujayupʉ. Irasirigʉ ĩgʉ̃rẽ tʉ̃ãwãgãbure ãmayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ĩgʉ̃ irasũ waamakʉ̃ ĩãgʉ̃, Sergio Paulo marĩ Opʉ Jesúya buerire pégʉkakõãyupʉ. Irasirigʉ Jesúre bʉremuyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pʉrʉ Pablo ĩgʉ̃ merãmarã merã Pafogue ããrãnerã wiri taribuja, Perge wãĩkʉri makãgue ejañurã. Iri makã Panfilia wãĩkʉri nikũgue ããrĩyuro. Ĩgʉ̃sã Pergegue ejamakʉ̃, Juan Marcos gapʉ ĩgʉ̃sãrẽ iro pí, Jerusalẽ́gue gãme dujáakõãyupʉ doja. ");
INSERT INTO sri_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pʉrʉ Pergegue ããrãnerã gaji makã Antioquía wãĩkʉri makãgue waañurã. Iri makã Pisidia wãĩkʉri nikũgue ããrĩyuro. Irogue eja, judío masaka siñajãrĩnʉ ããrĩmakʉ̃ ĩgʉ̃sã nerẽrĩ wiigue ñajãa, doañurã. ");
INSERT INTO sri_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Iri wii marã oparã Moisés gojadeare, Marĩpʉya kerere weredupiyunerã gojadeare bueadero pʉrʉ, Pedrosãrẽ siiu: —Gʉayarã, masakare weredʉarã, wereka, ĩgʉ̃sãrẽ õãrõ ããrĩrikʉburo, ãrĩrã! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pégʉ, Pablo wãgãnʉgã, ĩgʉ̃ya mojõ merã irikeo, ĩgʉ̃sãrẽ wereyupʉ: —Mʉsã Israel bumarã, gajirã ĩgʉ̃sã irirosũ Marĩpʉre bʉremurã, õõ ããrĩrã́, yʉ wererire õãrõ péka! ");
INSERT INTO sri_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Marĩpʉ, gʉa judío masaka Israel bumarã bʉremugʉ̃, gʉa ñekʉ̃sãmarãrẽ beyedi ããrĩ́mi. Irasirigʉ iripoegue ĩgʉ̃sã Egiptogue ããrĩrã́rẽ wárã masãporemakʉ̃ iridi ããrĩmí. Pʉrʉ iri nikũgue ããrĩrã́rẽ ĩgʉ̃ turaro merã ãĩwiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ĩgʉ̃sã Egiptore wiridero pʉrʉ, cuarenta bojorigora masaka marĩrõgue waagorenanerã ããrĩmá. Irogue ĩgʉ̃sã ĩgʉ̃ dorerire tarinʉgãkeremakʉ̃, Marĩpʉ ĩgʉ̃sãrẽ õãrõ koredi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pʉrʉ ĩgʉ̃sã Canaán nikũgue ejamakʉ̃, iri nikũ marãrẽ su mojõma pere gaji mojõ peru pẽrẽbejari buri marãrẽ Marĩpʉ béosĩã, gʉa ñekʉ̃sãmarãrẽ pídi ããrĩmí iro ããrĩdoregʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Marĩpʉ ĩgʉ̃sãrẽ iri nikũgue pídero pʉrʉ, cuatrocientos cincuenta bojorigora ããrĩnerã ããrĩmá. Ĩgʉ̃sã irogue ããrĩmakʉ̃, Marĩpʉ ĩgʉ̃sãrẽ doremurãrẽ pídi ããrĩmí. Ĩgʉ̃sã Samuel wãĩkʉgʉ Marĩpʉya kerere weredupiyudi ĩgʉ̃ ããrĩnʉgãripoegue doretũnunerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Gʉa ñekʉ̃sãmarã Samuere: “Sugʉ gʉa opʉ gããmekoa”, ãrĩ sẽrẽmakʉ̃ pégʉ, Marĩpʉ ĩgʉ̃sã opʉ ããrĩbure Saúre pídi ããrĩmí. Saúl, Cis wãĩkʉgʉ magʉ̃, Benjamĩ́ya bumʉ ããrĩdi ããrĩmí. Ĩgʉ̃ cuarenta bojorigora ĩgʉ̃sã opʉ ããrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pʉrʉ Marĩpʉ Saúre Israel bumarã opʉ ããrĩrĩ́rẽ béo, David wãĩkʉgʉre ĩgʉ̃sã opʉ ããrĩbure pídi ããrĩmí. Ãsũ ãrĩdi ããrĩmí ĩgʉ̃rẽ: “Davire Isaí magʉ̃rẽ bokabʉ. Bʉro ʉsʉyáa ĩgʉ̃ merã. Ããrĩpereri yʉ gããmerĩrẽ irigʉkumi”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Sugʉ David parãmi ããrĩturiagʉ, mʉsãrẽ Israel bumarãrẽ taugʉ aarigʉkumi”, ãrĩ weredi ããrĩmí Marĩpʉ gʉa ñekʉ̃sãmarãrẽ. Irasirigʉ ĩgʉ̃ ãrĩderosũta Jesúre iriudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús masakare buenʉgãburi dupiyuro Juan ããrĩpererã Israel bumarãrẽ: “Mʉsã ñerõ irideare bʉjawere, mʉsã gũñarĩrẽ gorawayuka! Mʉsã irasirimakʉ̃ ĩãgʉ̃, mʉsãrẽ deko merã wãĩyegʉkoa”, ãrĩ buedi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ĩgʉ̃ buetũnuburi dupiyuro ĩgʉ̃sãrẽ ãrĩdi ããrĩmí: “Mʉsã yʉre: ‘Gʉare taugʉ ããrĩ́mi’, ãrĩ gũñadáa. Ããrĩbea yʉ. Yʉ pʉrʉ gajigʉ aarigʉkumi. Yʉ gapʉ ubu ããrĩgʉ̃́, ĩgʉ̃rẽ neõ sʉropebirikoa”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Yaarã, Abraham parãmerã ããrĩturiarã, gajirã ĩgʉ̃sã irirosũ Marĩpʉre bʉremurã õõ ããrĩrã́de õãrõ péka! Marĩpʉ marĩrẽ: “Taugʉra”, ãrĩ kere iriudi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalén marã, ĩgʉ̃sã oparãde Jesús marĩrẽ taugʉre ĩãmasĩbirinerã ããrĩmá. Siñajãrĩnʉrikʉ Marĩpʉya kerere weredupiyunerã gojadeare buekererã, neõ pémasĩbirinerã ããrĩmá. Pémasĩbirisĩã, Jesúre wẽjẽdorerã, Marĩpʉya werenírĩ gojadea pũgue ãrĩderosũta irinerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jesús ĩgʉ̃ ñerõ irideare bokabirikererã, Pilatore: “Wẽjẽka ĩgʉ̃rẽ!” ãrĩ sẽrẽñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Irasirirã iripoegue Marĩpʉya kerere weredupiyunerã gojadea pũgue ãrĩderosũta Jesúre ããrĩpererire iri odo, ĩgʉ̃rẽ curusague boadire ãĩdiju, masãgobe ʉ̃tãyegue mádea gobegue pínerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ĩgʉ̃rẽ wẽjẽkeremakʉ̃, Marĩpʉ gapʉ boadiguere masũdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ĩgʉ̃ masãdero pʉrʉ, wárinʉrĩ deyoadi ããrĩmí ĩgʉ̃ merãmarãrẽ. Dupiyurogue ĩgʉ̃sã ĩgʉ̃ merã Galileague wiri, Jerusalẽ́gue wapikʉgorenarã waanerã ããrĩmá. Dapagorare ĩĩsãta ĩgʉ̃ masãdire ĩãnerã, ĩgʉ̃yare werema gʉayarãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","’Irasirirã yʉ, yʉ merãmʉ Bernabé mʉsãrẽ Jesúya kerere wererã aaribʉ́. Iripoegue Marĩpʉ ĩgʉ̃ Jesús merã õãrõ iriburire weredi ããrĩmí gʉa ñekʉ̃sãmarãrẽ. Ĩgʉ̃ ãrĩderosũta gʉare ĩgʉ̃sã parãmerã ããrĩturiarãrẽ irasiridi ããrĩmí Jesúre boadiguere masũgʉ̃. Salmos wãĩkʉri gojadea pũgue ãsũ ãrĩ gojasũdero ããrĩbʉ́: “Yʉ magʉ̃ ããrã mʉ. Dapagã mʉrẽ masãmakʉ̃ yáa”, ãrĩdi ããrĩmí Marĩpʉ. ");
INSERT INTO sri_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Gaji pũgue Marĩpʉ ãsũ ãrĩdi ããrĩmí, Jesúre boadiguere masũburire, ĩgʉ̃ dʉpʉ boabiriburire: “Iripoegue yʉ Davire: ‘Õãrõ irigʉra’, ãrĩderosũta mʉrẽ irigʉkoa”, ãrĩdi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Gaji Salmos pũ David ĩgʉ̃ gojadea pũgue ãsũ ãrĩ gojadi ããrĩmí: “Mʉ dorerire õãrõ iridiya dʉpʉre neõ boadorebirikoa”, ãrĩ gojadi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Diayeta werea. David okagʉ, Marĩpʉ gããmederosũta ĩgʉ̃ ããrĩdeapoe marãrẽ iritamuníkõãdi ããrĩmí. Ĩgʉ̃ boadero pʉrʉ, ĩgʉ̃ ñekʉ̃sãmarã darãrẽ yáaderogueta gajirã ĩgʉ̃rẽ yáanerã ããrĩmá. Ĩgʉ̃rẽ yáadero pʉrʉ, ĩgʉ̃ya dʉpʉ boakõãyuro. ");
INSERT INTO sri_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jesús Marĩpʉ masũdiya dʉpʉ gapʉ neõ boabiridero ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Mʉsã ããrĩpererã Jesúya kerere yʉ weremakʉ̃, õãrõ péka! Ĩgʉ̃ merã marĩ ñerõ irideare kãtiri bokarãkoa. Ĩgʉ̃rẽ bʉremurãnorẽ ĩgʉ̃sã ñerõ irideare Marĩpʉ kãtigʉkumi. Moisés doreri iriri merã neõ kãtiri bokabirikoa. ");
INSERT INTO sri_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Irasirirã mʉsã dapagora marã õãrõ pémasĩka! Mʉsã õãrõ pémasĩbirimakʉ̃, iripoegue marã Marĩpʉya kerere weredupiyunerã gojaderosũta mʉsãdere waarokoa. ");
INSERT INTO sri_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ãsũ ãrĩ gojanerã ããrĩmá Marĩpʉya werenírĩ gojadea pũgue: Õãrõ péka, yʉre bʉridarimasã! Mʉsã okarinʉrĩrẽ mʉsãrẽ gajino bʉro goerire ĩmugʉra. Gajirã mʉsãrẽ irire weremakʉ̃ pékererã, bʉremubirikoa. Irasirirã mʉsã bʉremubiridea waja béosũrãkoa, ãrĩ gojanerã ããrĩmá, ãrĩ wereyupʉ Pablo Antioquía marãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablosã irire were odo, wiriamakʉ̃, judío masaka ããrĩmerã iri wiigue nerẽanerã ĩgʉ̃sãrẽ: —Gaji siñajãrĩnʉ ããrĩmakʉ̃, gʉare irireta werenemoka doja! ãrĩ sẽrẽñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Irasirirã iri wii nerẽanerã wiriamakʉ̃, wárã judío masaka, judío masaka irirosũ bʉremurãde Pablosã wererire bʉremusĩã, ĩgʉ̃sãrẽ tʉyañurã. Irasirirã Pablosã ĩgʉ̃sãrẽ: “Marĩpʉ mʉsãrẽ bʉro maĩrĩ merã ĩãgʉ̃rẽ bʉremurĩrẽ neõ piribirikõãka!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Gaji semana siñajãrĩnʉ ããrĩmakʉ̃, wárã iri makã marã Marĩpʉya kerere pémurã iri wiigue nerẽñurã doja. ");
INSERT INTO sri_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ĩgʉ̃sã wárã nerẽmakʉ̃ ĩãrã, judío masaka Pablore bʉro ĩãturiñurã. Irasirirã ñerõ werenírĩ merã Pablo wererire: “Diaye ããrĩbea”, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, Pablo, Bernabé güiro marĩrõ merã ĩgʉ̃sãrẽ ãrĩñurã: —Marĩpʉ dorederosũta gʉa mʉsãrẽ judío masakare ĩgʉ̃ya kerere werepʉroriadabʉ. Mʉsã gapʉ irire neõ gããmebea. Marĩpʉ pʉro perebiri okari opaburidere gããmebea. Irasirirã gʉa judío masaka ããrĩmerã gapʉre iri kerere wererãkoa. ");
INSERT INTO sri_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ãsũta doredi ããrĩmí Marĩpʉ ĩgʉ̃ya werenírĩ gojadea pũguere: Mʉsãrẽ judío masaka ããrĩmerãrẽ yaa kerere weredoregʉ pígʉkoa. Irasirigʉ ĩgʉ̃sãrẽ ããrĩpererã i nikũ marã mʉsã irire weremakʉ̃ pérãnorẽ taugʉkoa perebiri peamegue waabonerãrẽ, ãrĩdi ããrĩmí Marĩpʉ, ãrĩ wereñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, judío masaka ããrĩmerã bʉro ʉsʉyari merã: “Marĩpʉya kere gapʉ õãrĩ ããrã”, ãrĩñurã. Irasirirã Marĩpʉ beyesũnerã, ĩgʉ̃ pʉrogue perebiri okari ĩgʉ̃ sĩsũmurã, Jesúre bʉremuñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Irasirirã Marĩpʉyare ããrĩpererogue iri nikũ marãrẽ weregorenañurã. ");
INSERT INTO sri_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Irasirimakʉ̃ ĩãrã, surãyeri judío masaka Pablosãrẽ ñerõ wereníñurã. Ĩgʉ̃sã wererire pérã, gajirã wáro niyeru oparã judío masaka iririkʉrire bʉremurã nome Pablosã merã guañurã. Iri makã marã oparãde ĩgʉ̃sã merã guañurã. Irasirirã ĩgʉ̃sãrẽ ñerõ irinʉgã, ĩgʉ̃sãya nikũrẽ béowiukõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Irasirirã Pablo, Bernabé ĩgʉ̃sãya gubu suríre tuadea nikũwerare mojẽbéoñurã, iri makã marã ĩgʉ̃sã ñerĩ iriri waja ĩmurã. Irasiri odo, Iconiogue waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ĩgʉ̃sã waakeremakʉ̃, Jesúre bʉremurã gapʉ irogue ããrĩrã́ Õãgʉ̃ deyomarĩgʉ̃rẽ opatari, bʉro ʉsʉyari merã dujañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo, Bernabé merã Iconiogue eja, judío masaka nerẽrĩ wiigue ñajãa, Jesúya kerere wereñurã. Ĩgʉ̃sã weremakʉ̃ pérã, judío masaka, gajirã judío masaka ããrĩmerãde wárã Jesúre bʉremunʉgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Judío masaka Jesúyare pédʉamerã gapʉ, Jesúre bʉremurãrẽ ñerõ wereníñurã. Judío masaka ããrĩmerãrẽ, Jesúre bʉremurã merã guamakʉ̃ iriñurã. Irasirirã judío masaka ããrĩmerã Jesúre bʉremurãrẽ ñerõ gũñañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ĩgʉ̃sã irasũ gũñamakʉ̃ ĩãrã, Pablosã gapʉ yoaripoe irore duja, güiro marĩrõ merã: “Marĩpʉ masakare bʉro maĩrĩ merã ĩãmi”, ãrĩ bueñurã. Ĩgʉ̃sã buemakʉ̃, Marĩpʉ ĩgʉ̃yare: “Diayeta buema”, ãrĩgʉ̃, ĩgʉ̃ turaro merã iri ĩmurĩrẽ ĩgʉ̃sã irimakʉ̃ iritamuyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Irasirirã iri makã marã dʉkawariñurã. Surãyeri judío masaka buerire gããmerã, gajirã Pablosã buerire gããmerã dujañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jesúya kerere gããmemerã: judío masaka, judío masaka ããrĩmerãde, oparã merã nerẽ, Pablosãrẽ ñerõ ãrĩ, ʉ̃tãyeri merã dea wẽjẽdʉañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Ĩgʉ̃sã irasũ wẽjẽdʉarire pérã, Pablo, Bernabé merã Licaonia nikũgue duriwãgãñurã. Irogue eja, iro marãrẽ Jesúya kerere buegorenañurã. Ĩgʉ̃sã irasũ buegorenarã, iri nikũ ããrĩrĩ́ makãrĩ Listra, Derbe wãĩkʉri makãrĩgue ejañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listrague eja, sugʉ neõ deyoagʉgueta waamasĩbiridire iro doagʉre bokajañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Irasirigʉ irogue doagʉ, Pablo buemakʉ̃ péyupʉ. Ĩgʉ̃ pémakʉ̃, Pablo su diayeta ĩãyupʉ ĩgʉ̃rẽ. “Ĩĩ Jesúre bʉremumi. ‘Ĩgʉ̃ yʉre taumasĩmi’, ãrĩ gũñakumi”, ãrĩ gũñayupʉ Pablo ĩgʉ̃rẽ ĩãgʉ̃. ");
INSERT INTO sri_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Irasirigʉ turaro merã: —Wãgãnʉgãka! ãrĩyupʉ ĩgʉ̃rẽ. Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, pariwãgãnʉgã waayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablo ĩgʉ̃rẽ irasirimakʉ̃ ĩãrã, Licaonia marã ĩgʉ̃sã ya merã ãsũ ãrĩ gaguiníñurã: —Marĩ bʉremurã ʉ̃marõgue ããrãnerã ʉ̃ma irirosũ deyorã marĩ pʉrogue dijajama, ãrĩ gaguiníñurã. ");
INSERT INTO sri_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Irasirirã Bernabére: “Marĩ bʉremurã opʉ Zeus wãĩkʉgʉ ããrĩ́mi”, ãrĩ wãĩyeñurã. Pablo gapʉre ĩgʉ̃sãrẽ werepʉroridi ããrĩmakʉ̃: “Marĩ bʉremugʉ̃ Hermes wãĩkʉgʉ ããrĩ́mi”, ãrĩ wãĩyeñurã. ");
INSERT INTO sri_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iri makã ñajãrõ tʉro Zeure bʉremurĩ wii ããrĩyuro. Sugʉ paí iri wiire koregʉ wekʉare, goori ĩgʉ̃ ãmuadeare ãĩwãgãyupʉ. Ĩgʉ̃, iro marã merã wekʉare wẽjẽ soepeodʉadiyupʉ Pablosãrẽ bʉremudʉagʉ. ");
INSERT INTO sri_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ĩgʉ̃sã irasũ iridʉamakʉ̃ ĩãrã, Pablosã ĩgʉ̃sãya suríre yegue, iro ããrĩrã́ watopegue ũmawãgã, ãsũ ãrĩ gaguiníñurã: ");
INSERT INTO sri_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Mʉsã gʉare, ¿nasirimurã irasũ yári? Gʉade mʉsã irirosũta masaka ããrã. Gʉa mʉsãrẽ Marĩpʉya kerere ãsũ ãrĩ wererã aaribʉ́. Keori weadeare béokõãka! Marĩpʉ okagʉ gapʉre bʉremuka! Ĩgʉ̃ta ʉ̃mʉgasi, i nikũ, dia, ããrĩpererã i ʉ̃mʉgue ããrĩrã́rẽ iridi ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Iripoegue ããrĩpereri buri marãrẽ ĩgʉ̃sã gããmerõ irimakʉ̃ kãmutabiridi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Masaka ĩgʉ̃rẽ bʉremubirikeremakʉ̃, marĩrẽ õãrõ irigʉ, ĩgʉ̃ õãrõ ããrĩrikʉrire ĩmumi ããrĩpererãrẽ. Irasirigʉ deko merẽmakʉ̃ yámi. Marĩ oterire dʉkakʉmakʉ̃ yámi marĩ baaburire sĩgʉ̃. Irasirigʉ ʉsʉyari merã ããrĩmakʉ̃ yámi marĩrẽ, ãrĩñurã Pablosã ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pékererã, Pablosãrẽ bʉremudʉarã, wekʉare wẽjẽ soepeodʉadiñurã dapa. Pablosã gapʉ ĩgʉ̃sãrẽ: “Iropata irika! Iririre pirikõãka!” ãrĩmakʉ̃ pérã, irire pirikõãñurã pama. ");
INSERT INTO sri_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pʉrʉ gajirã judío masaka, Antioquía marã, Iconio marãde Listrague ejañurã. Irogue ejarã, Pablore ñerõ wereníñurã. Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, iro marãde ĩgʉ̃ merã gua, ĩgʉ̃rẽ ʉ̃tãyeri merã deañurã. Dea odo: “Ĩĩ kõmoakõãmi”, ãrĩ, iri makã tʉrogue tʉ̃ãwãgã meépíbéokõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ĩgʉ̃sã irasirikeremakʉ̃, Jesúre bʉremurã gapʉ ĩgʉ̃ pʉro nerẽjañurã. Ĩgʉ̃sã nerẽjamakʉ̃, wãgãnʉgã, ĩgʉ̃sã merã makãgue dujáakõãyupʉ doja. Gajinʉ gapʉ Bernabé merã Derbegue waayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Irogue eja, Jesúya kerere wereñurã. Ĩgʉ̃sã weremakʉ̃ pérã, wárã iro marã Jesúre bʉremuñurã. Irire were odo, Listrague goedujáañurã. Iro eja, Iconiogue waañurã. Pʉrʉ Pisidiama makã Antioquíague ejañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Iri makãrĩgue weregorenarã, Jesúre bʉremurãrẽ õãrõ ããrĩrikʉmakʉ̃ iriñurã. “Jesúre bʉremurĩrẽ neõ piribirikõãka! Marĩpʉ ĩgʉ̃yarãrẽ doreroguere waadʉarã, õõguere wári poyari merã ããrĩrãkoa”, ãrĩ bueñurã ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pʉrʉ iri makãrĩkʉ marãrẽ Jesúre bʉremurãrẽ iritamumurãrẽ beyeñurã. Beye odo, bere, ãsũ ãrĩ sẽrẽñurã Marĩpʉre ĩgʉ̃sã bʉremugʉ̃rẽ: —Gʉa Opʉ, ĩĩsã mʉyarãrẽ iritamuka! ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ĩgʉ̃sã Pisidia nikũgue weregorenadero pʉrʉ, Panfilia nikũgue ejañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Iri nikũma makã Pergere Marĩpʉya kerere were odoadero pʉrʉ, Atalia wãĩkʉri makãgue waañurã. ");
INSERT INTO sri_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Iri makã ããrãnerã Antioquíague dujáarã, doódiru merã waañurã. Iripoegue iri makã marã Jesúre bʉremurã Pablosãrẽ iriupʉrorirã, Marĩpʉre ĩgʉ̃sãya ããrĩburire ãsũ ãrĩ sẽrẽbosanerã ããrĩmá: “Gʉapʉ, mʉ maĩrĩ merã ĩĩsãrẽ mʉyare buegorenamakʉ̃, õãrõ koreka!” ãrĩ sẽrẽnerã ããrĩmá. Irasirirã Pablo, Bernabé merã ĩgʉ̃sã buedoreadeare buepeo, iri makãrẽ goeñurã doja. ");
INSERT INTO sri_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Irasirirã iri makãrẽ goejarã, gajirã Jesúre bʉremurã merã nerẽ, ããrĩpereri ĩgʉ̃sã Marĩpʉ turari merã iriadeare, Marĩpʉ judío masaka ããrĩmerãdere Jesúre bʉremumakʉ̃ iriadeare wereñurã ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Yoaripoe iroguere Jesúre bʉremurã merã ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pablo, Bernabé Antioquíague ããrĩripoe gajirã Judea nikũ marã irogue eja, Jesúre bʉremurãrẽ ãsũ ãrĩ buenʉgãñurã. —Moisés dorederosũta ããrĩpererã mʉsãya dʉpʉma gasirogãrẽ wiiribirimakʉ̃, Marĩpʉ mʉsãrẽ taubirikumi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ĩgʉ̃sã irire ãrĩmakʉ̃ pérã, Pablosã ĩgʉ̃sã merã bʉro gãme guaseoñurã. Irasirirã Antioquía marã Jesúre bʉremurã Pablore, Bernabére, gajirã iro marãdere Jerusalẽ́gue waamurãrẽ beyeñurã. Ãsũ ãrĩñurã: “Jerusalẽ́gue waaka! Jesús buedoregʉ beyenerãrẽ, ĩgʉ̃sãrẽ iritamurãdere: ‘¿Judea marã buerire diayeta ããrĩ́rĩ?’ ãrĩ sẽrẽñarã waaka!” ãrĩ iriuñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Irasirirã Jesúre bʉremurã ĩgʉ̃sãrẽ iriuadero pʉrʉ, Pablo, Bernabé merã Fenicia nikũ waa, pʉrʉ Samaria nikũrẽ tariwãgã, judío masaka ããrĩmerã ĩgʉ̃sã ñekʉ̃sãmarã bʉremunadeare piri, Marĩpʉya gapʉre bʉremunʉgãrĩ kerere wererã iriñurã Jesúre bʉremurãrẽ. Irire pérã, ããrĩpererã bʉro ʉsʉyañurã. ");
INSERT INTO sri_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablosã Jerusalẽ́gue ejamakʉ̃ ĩãrã, Jesúre bʉremurã, Jesús buedoregʉ beyenerã, ĩgʉ̃sãrẽ iritamurãde õãrõ ʉsʉyari merã bokatĩrĩñurã. Irasirirã Pablo, Bernabé merã ããrĩpereri ĩgʉ̃sã Marĩpʉ turari merã irideare wereñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Iroguere surãyeri fariseo bumarã Jesúre bʉremurã ããrĩñurã. Pablosã weremakʉ̃ pékererã, ĩgʉ̃sã gapʉ wãgãnʉgã, ãsũ ãrĩñurã: —Judío masaka ããrĩmerã Jesúre bʉremurã, ĩgʉ̃sãya dʉpʉma gasirogãrẽ wiiriburo. “Moisés doredeare irika mʉsãde!” ãrĩrõ gããmea ĩgʉ̃sãrẽ, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pé, Jesús buedoregʉ beyenerã, gajirã ĩgʉ̃sãrẽ iritamurã nerẽ, irire ãmudʉarã wereníñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ĩgʉ̃sã yoaripoe wereníadero pʉrʉ, Pedro wãgãnʉgã, wereyupʉ ĩgʉ̃sãrẽ: —Yaarã, õãrõ péka yʉre! Iripoegue, yʉ mʉsã merã ããrĩgʉ̃́rẽ Marĩpʉ beyedi ããrĩmí, yʉre ĩgʉ̃ya kerere judío masaka ããrĩmerãrẽ weredoregʉ. Irasirigʉ ĩgʉ̃ masakare tauri kerere werea, Jesúre bʉremuburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Marĩpʉ ããrĩpererã gũñarĩrẽ masĩgʉ̃, judío masaka ããrĩmerãrẽ Jesúre bʉremurãrẽ: “Yaarã ããrĩ́ma”, ãrĩ ĩmubu, ĩgʉ̃sãdere Õãgʉ̃ deyomarĩgʉ̃rẽ iriumi marĩrẽ iriuderosũta. ");
INSERT INTO sri_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Irasirigʉ marĩrẽ ĩgʉ̃sã merã surosũ ĩãmi. Ĩgʉ̃sã Jesúre bʉremumakʉ̃, ĩgʉ̃sãdere ĩgʉ̃sã gũñarĩgue õãrõ ããrĩrikʉmakʉ̃ yámi. ");
INSERT INTO sri_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Marĩpʉ Moisére doreri pídeare marĩ ñekʉ̃sãmarã bokatĩũbirinerã ããrĩmá. Marĩde ĩgʉ̃sã irirosũ bokatĩũbirikererã, ¿nasirimurã Jesúre bʉremurãrẽ judío masaka ããrĩmerãrẽ irire iridorebukuri? ¿Nasirimurã Marĩpʉ judío masaka ããrĩmerãrẽ ĩgʉ̃yarã ããrĩmakʉ̃ iririre: “Iro ããrĩbea”, ãrĩ gũñabukuri? ");
INSERT INTO sri_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ãsũ gapʉ gũñarõ gããmea. Marĩ Opʉ Jesús marĩrẽ maĩrĩ merã, Marĩpʉ marĩrẽ taumi. Irasirigʉ marĩrẽ taurosũta judío masaka ããrĩmerãdere taumi, ãrĩyupʉ Pedro ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, ããrĩpererã toepereakõãñurã. Irasirirã Pablo, Bernabé merã judío masaka ããrĩmerã watopegue Marĩpʉ turari merã ĩgʉ̃sã iri ĩmudeare weremakʉ̃ õãrõ péñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ĩgʉ̃sã irire were odoadero pʉrʉ, Santiagode wereyupʉ: —Yaarã, péka yʉre! ");
INSERT INTO sri_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Marĩpʉ judío masaka ããrĩmerãrẽ ĩgʉ̃yarã ããrĩnʉgãmakʉ̃ neõ irideare weresiami Simón Pedro mʉsãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Marĩpʉya kerere weredupiyunerã werederosũta waabʉ judío masaka ããrĩmerãrẽ. Marĩpʉya werenírĩ gojadea pũgue ãsũ ãrĩ gojanerã ããrĩmá ĩgʉ̃ ãrĩdeare gojarã: ");
INSERT INTO sri_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Pʉrʉ Daviya bumarã ĩgʉ̃sã oparã ããrĩdea pereadero pʉrʉgue dupaturi ĩgʉ̃ parãmi ããrĩturiagʉre ĩgʉ̃sã Opʉ sóogʉra doja. Irasirigʉ ĩgʉ̃yarãrẽ ĩgʉ̃sã õãrõ ããrĩrikʉmakʉ̃ irigʉkoa. ");
INSERT INTO sri_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Irasirirã ããrĩpererã judío masaka ããrĩmerã yʉ beyenerã, yʉre ĩgʉ̃sã Opʉre bʉremurãkuma, ãrĩmi Marĩpʉ masakare irire masĩdoregʉ, ãrĩ gojanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Irasirigʉ ãsũ gũñáa yʉ. Judío masaka ããrĩmerãrẽ Jesúre bʉremunʉgãrãrẽ wári: “Ãsũ irika!” ãrĩ garibobirikõãrõ gããmea marĩrẽ. ");
INSERT INTO sri_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Irasirirã marĩ ĩgʉ̃sãrẽ ãsũ ãrĩ gojarã: “Keori weadea pʉro baari pídeare baabirikõãka! Nome merã ñerõ iribirikõãka! Nomede ʉ̃ma merã ñerõ iribirikõãka! Waimʉrã wʉ̃́nugũ biu wẽjẽanerãya díkʉri diíre baabirikõãka! Díre iiríbirikõãka!” ãrĩ gojarã! ");
INSERT INTO sri_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Iripoegueta marĩ nerẽrĩ wiirigue siñajãrĩnʉrikʉ Marĩpʉ Moisére doreri pídeare masaka buema. Irasirirã ããrĩpereri makãrĩ marã iri dorerire masĩkuma. Irasirirã yʉ ãrãdea ditare gojarã! ãrĩyupʉ Santiago ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Irasirirã Jesús buedoregʉ beyenerã, ĩgʉ̃sãrẽ iritamurã, gajirã ããrĩpererã Jesúre bʉremurã merã Santiago ãrãdeare: “Irasũta irirã!” ãrĩ, ĩgʉ̃sã merãmarã pẽrãrẽ beyeñurã Antioquíague Pablo, Bernabé merã waamurãrẽ. Irasirirã Judare, Silare beyeñurã. Judata, “Barsabás” wãĩkʉyupʉ. Ĩgʉ̃sã Jesúre bʉremurã watopegue ããrĩrã́ oparã irirosũ ããrĩrã́ ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pʉrʉ ĩgʉ̃sã gojadea pũrẽ ĩgʉ̃sã merã iriuñurã. Ãsũ ãrĩ gojañurã: Gʉa, Jesús buedoregʉ beyenerã, gʉare iritamurã, gajirã Jesúre bʉremurã õõgue ããrĩrã́ õãdorea mʉsãrẽ. Ããrĩpererã judío masaka ããrĩmerã Antioquíague, Siriague, Ciliciague ããrĩrã́rẽ Jesúre bʉremurãrẽ õãdorea. ");
INSERT INTO sri_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Gajirã gʉa merãmarã mʉsã pʉrogue ejarã, mʉsãrẽ garibogorenañurã. Mʉsãya dʉpʉma gasirogãrẽ wiiridore: “Ããrĩpereri Moisés doredeare irika!” ãrĩgorenañurã. Gʉa gapʉ ĩgʉ̃sãrẽ irire: “Buerã waaka!” ãrĩbiradibʉ. ");
INSERT INTO sri_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Irasirirã gʉa ããrĩpererã nerẽ, gʉa merãmarã Judas, Silas wãĩkʉrãrẽ beyeabʉ mʉsã pʉrogue iriumurã. Ĩgʉ̃sã marĩ maĩrã Pablo, Bernabé merã waarãkuma. ");
INSERT INTO sri_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Masaka Pablosãrẽta Jesucristo marĩ Opʉya kerere güiro marĩrõ merã buemakʉ̃ wẽjẽboyaunanerã ããrĩmá. Mérõgã tarinerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judasã mʉsã pʉrogue ejarã, gʉa gojadeare wererãkuma. ");
INSERT INTO sri_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Õãgʉ̃ deyomarĩgʉ̃ gʉare gũñarĩ sĩrõsũta: “Gaji dorerire píbirikoa mʉsãrẽ”, ãrĩ gũñáa. Irasirirã i doreri ditare pírãkoa: ");
INSERT INTO sri_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","“Keori weadea pʉro baari pídeare baabirikõãka! Díre iiríbirikõãka! Waimʉrã wʉ̃́nugũ biu wẽjẽanerãya díkʉri diíre baabirikõãka! Nome merã ñerõ iribirikõãka! Nomede ʉ̃ma merã ñerõ iribirikõãka!” I gʉa dorerire irirã, õãrĩrẽ irirãkoa mʉsã. Iropata ããrã mʉsãrẽ gʉa weredʉari, ãrĩ gojañurã Jesúre bʉremurã Jerusalẽ́gue ããrĩrã́. ");
INSERT INTO sri_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Iri pũrẽ goja odo, Pablosãrẽ: “Õãrõ waaka!” ãrĩ seretuñurã. Pʉrʉ Pablosã Antioquíague waañurã. Irogue eja, Jesúre bʉremurãrẽ siiu neeõ, iri pũrẽ wiañurã. ");
INSERT INTO sri_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Iri pũrẽ bue odo, õãrĩ ĩgʉ̃sã were gojadeare ĩãrã, bʉro ʉsʉyañurã. ");
INSERT INTO sri_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas, Silas merã Marĩpʉya kerere weredupiyurã ããrĩñurã. Irasirirã Jesúre bʉremurãrẽ Marĩpʉ ĩgʉ̃sãrẽ weredoredeare wereñurã. Ĩgʉ̃sã weremakʉ̃ pérã, Jesúre bʉremurã gapʉ ʉsʉya, õãrõ gũñaturari merã dujañurã. ");
INSERT INTO sri_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Judas iroguere yoaweyaripoe ããrĩ: “Dujáagʉ yáa”, ãrĩ seretuyupʉ iro marãrẽ. Irasũ ãrĩmakʉ̃ pé: “Õãrõ waaka! Bʉro siñajãrĩ merã dujáaka Jerusalẽ́gue. Õãburo iro marã, mʉsãrẽ iriuanerã”, ãrĩ dujuñurã. Ĩgʉ̃sã irasũ ãrãdero pʉrʉ, Judas, gajirã merã Jerusalẽ́gue dujáakõãyupʉ doja. ");
INSERT INTO sri_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas gapʉ: “Õõgue dujagʉra”, ãrĩ gũñasĩã, Antioquíague dujakõãyupʉ dapa. ");
INSERT INTO sri_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo, Bernabé merã yoaweyaripoe iroguere dujañurã. Irasirirã wárã gajirã merã iro marãrẽ bue, marĩ Opʉ Jesúya kerere weregorenañurã. ");
INSERT INTO sri_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mérõgã pʉrʉ Pablo Bernabére wereyupʉ: —Náka, ããrĩpereri makãrĩ marĩ Opʉ Jesúya kerere marĩ buegorenadea makãrĩ marãrẽ: “¿Naásũ ããrĩrikʉri?” ãrĩ, ĩãgorenarã! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Bernabé gapʉ Juan Marcore ãĩadʉadiyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Dupiyurogue Juan Marcos ĩgʉ̃sã merã Panfiliague ããrĩgʉ̃́, ĩgʉ̃sã moãrĩrẽ bokatĩũbiridea waja Pablo dupaturi ĩgʉ̃rẽ ãĩadʉabiriyupʉ. Irasirigʉ Bernabére: “Ĩgʉ̃rẽ ãĩabirimakʉ̃dere õãrokoa”, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Irasirirã ĩgʉ̃sã basi irire bʉro gãme guaseo, dʉkawariakõãñurã. Irasirigʉ Bernabé gapʉ Juan Marcore ãĩayupʉ, doódiru merã Chipre nʉgʉ̃rõgue waagʉ́. ");
INSERT INTO sri_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablode Silare beyeyupʉ ĩgʉ̃ merã waabure. Ĩgʉ̃sã buerã waaburi dupiyuro Jesúre bʉremurã ĩgʉ̃sãrẽ: “Marĩ Opʉ mʉsãrẽ maĩgʉ̃ õãrõ koreburo”, ãrĩ sẽrẽbosa, iriuñurã. ");
INSERT INTO sri_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Irasirirã Siria nikũ, Cilicia nikũdere tariwãgã, Jesúre bʉremurãrẽ ĩgʉ̃yare bue, õãrõ gũñaturamakʉ̃ iriñurã ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pʉrʉ Pablo, Silas merã Derbegue, Listrague ejañurã. Irogue ejarã, Timoteore Jesúre bʉremugʉ̃rẽ bokajañurã. Ĩgʉ̃ pagode Jesúre bʉremugõ, judío masako ããrĩyupo. Pagʉ gapʉ griego masakʉ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jesúre bʉremurã Listra marã, Iconio marãde Timoteore: “Õãgʉ̃ ããrĩ́mi”, ãrĩ ĩãñurã. ");
INSERT INTO sri_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Irasirigʉ Pablo Timoteore ĩgʉ̃rẽ wapikʉbure ãĩadʉayupʉ. Judío masaka iri nikũ marã gapʉ Timoteo pagʉ griego masakʉ ããrĩrĩ́rẽ masĩñurã. Irasirigʉ Pablo ĩgʉ̃sã merã guamakʉ̃ iridʉabi, Timoteoya dʉpʉma gasirogãrẽ wiiriyupʉ judío masaka irinarõsũ irigʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pʉrʉ Pablo, Timoteo merã waa, ĩgʉ̃sã gojadea pũmarẽ Jesúre bʉremurãrẽ ĩgʉ̃sã ejari makãrĩ marãrẽ wereñurã. Iri pũ Jerusalẽ́gue Jesús buedoregʉ beyenerã, ĩgʉ̃sãrẽ iritamurã: “Ãsũ irika!” ãrĩ gojadea pũ ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ĩgʉ̃sã irire weremakʉ̃ pérã, Jesúre bʉremurã: “Jáʉ”, ãrĩ, gũñaturari merã Jesúre bʉremunemoñurã. Gajirãde ʉ̃mʉrikʉ Jesúre bʉremubirinerã, bʉremunemowãgãñurã. ");
INSERT INTO sri_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","7","Pʉrʉ Pablosã Asia nikũgue Jesúya kerere buerã waadʉarãrẽ Õãgʉ̃ deyomarĩgʉ̃ waadorebiriyupʉ. Irasirirã ĩgʉ̃sã Frigia nikũrẽ taria, Galacia nikũdere taria, Misia nikũ tʉrogue eja, Bitinia nikũgue waadʉadiñurã. Õãgʉ̃ deyomarĩgʉ̃ gapʉ iroguedere waadorebiriyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Irasirirã Misia nikũ tʉrore tariwãgã, Troas wãĩkʉri makãgue buajañurã. ");
INSERT INTO sri_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Irogue iri ñamirẽ Pablo kẽrõgue irirosũ sugʉ Macedonia nikũmʉ ĩgʉ̃ pʉro nímakʉ̃ ĩãyupʉ. “Gʉare Macedonia marãrẽ iritamugʉ̃ aarika!” ãrĩ siiuyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo kẽrõ irirosũ waadeare gʉare weremakʉ̃ pérã: “Marĩpʉ iri nikũ marãrẽ ĩgʉ̃ya kerere weredoregʉ iriugʉ irikumi marĩrẽ”, ãrĩ gũña, gʉayare ãmu, Macedoniague waakõãbʉ. ((Yʉ Lucas i pũrẽ gojabude ĩgʉ̃sã merã waabʉ.)) ");
INSERT INTO sri_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Irasirirã Troague ããrãnerã doódiru merã Samotracia wãĩkʉri nʉgʉ̃rõgue taribuja, gajinʉ gapʉ Neápoligue waabʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Iri makãrẽ taria, Filipo romano marãya makãgue ejabʉ. Iri makãta Macedonia nikũma makãrĩrẽ doreri makã ããrĩbʉ́. Iroguere yoaweyaripoe ããrĩbʉ́. ");
INSERT INTO sri_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Judío masaka siñajãrĩnʉ ããrĩmakʉ̃, ĩgʉ̃sã Marĩpʉre sẽrẽrã nerẽnarõrẽ ãmarã́ waarã́, iri makã tʉro, dia wekague waabʉ. Irogue eja, iro nerẽanerã nomerẽ Jesúya kerere were doaníbʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Iroguere sugo Tiatira wãĩkʉri makãmo, Lidia wãĩkʉgo õãrĩ surí diiari suríre duarimasõ ããrĩmó. Marĩpʉre bʉremugõ ããrĩmó. Irasirigʉ Marĩpʉ igore Pablo wererire õãrõ pémasĩrĩ merã pé bʉremumakʉ̃ irimi. ");
INSERT INTO sri_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Irasirigʉ Pablo igore, igoya wii marã ããrĩpererãrẽ deko merã wãĩyemi. Ĩgʉ̃ wãĩyeadero pʉrʉ, ãsũ ãrĩmo: —Mʉsã yʉre: “Diayeta Jesúre bʉremugõ ããrĩ́mo”, ãrĩ gũñarã, yaa wiigue dujaka! ãrĩmo gʉare. Igo irasũ ãrĩmakʉ̃ pérã, igoya wiigue dujabʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sunʉ iro marã Marĩpʉre sẽrẽrã nerẽnarõgue dupaturi waarã́, wãtĩ ñajãsũdeore bokajabʉ. Igo gajirãrẽ moãboego ããrĩmó. Irasirigo wãtĩ masĩrĩ sĩrĩ merã masakare: “Ãsũ waarokoa mʉsãrẽ”, ãrĩboka, wáro niyeru wajatabosamo igo oparãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Igo gʉa noó waaró gʉa merã waagó, ãsũ ãrĩ gaguinímo: —Ĩgʉ̃sã Marĩpʉ ããrĩpererãrẽ doregʉre moãboerimasã ããrĩ́ma. Marĩpʉ marĩrẽ tauri kerere werema mʉsãrẽ, ãrĩ gaguinímo. ");
INSERT INTO sri_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wárinʉrĩ gʉare garibomakʉ̃, Pablo gãmenʉgã, wãtĩ igoguere ããrĩgʉ̃́rẽ ãsũ ãrĩmi: —Jesucristo wãĩ merã, ĩgʉ̃ turari merã mʉrẽ: “Igore iropata wirika!” ãrĩmi. Ĩgʉ̃ irasũ ãrĩmakʉ̃ta, wãtĩ igore wiriakõãmi. ");
INSERT INTO sri_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wãtĩ igore wiriadero pʉrʉ, masakare: “Ãsũ waarokoa”, ãrĩ weremasĩbiri, igo oparãrẽ niyeru wajatanemobosabirimo pama. Irasirirã, igo oparã gapʉ Pablo, Silare ñeã, iri makã marã oparã pʉrogue ãĩãma. ");
INSERT INTO sri_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pʉrʉ weresãrĩrẽ beyerimasã pʉrogue ĩgʉ̃sãrẽ ãĩja, ãsũ ãrĩma: —Ĩĩsã judío masaka ããrĩ́ma. Marĩya makã marãrẽ gariborã yáma. ");
INSERT INTO sri_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ĩgʉ̃sã marĩrẽ buerã, marĩ romano marã iririkʉrire iridorebema. Irasirirã ĩgʉ̃sã buerire gããmebea. Ĩgʉ̃sã doreridere irimasĩbea, ãrĩma. ");
INSERT INTO sri_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ĩgʉ̃sã irasũ ãrĩmakʉ̃ pérã, masaka wárã irogue ããrĩrã́ Pablosã merã guama. Weresãrĩrẽ beyerimasã gapʉ Pablosãya suríre túweadore, yuku merã tãrãdorema. ");
INSERT INTO sri_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ĩgʉ̃sãrẽ bʉro tãrã odo, peresu irima. Ĩgʉ̃sãrẽ korebure õãrõ ĩãduripídorema. ");
INSERT INTO sri_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Irasirigʉ ĩgʉ̃sãrẽ koregʉ gapʉ iri wii dekoma taribugue ĩgʉ̃sãrẽ ĩgʉ̃sãya guburire taboa majĩrĩma goberigue sʉadobo, õãrõ biadobokõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pʉrʉ ñami deko ããrĩmakʉ̃, Pablosã Marĩpʉre sẽrẽ, bayapeoñurã. Ĩgʉ̃sã irasũ bayamakʉ̃, gajirã peresugue ããrĩrã́ péñurã. ");
INSERT INTO sri_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ĩgʉ̃sã bayaripoe gũñaña marĩrõ nikũ bʉro ñomeyuro. Irasiriro iri wiide bʉro gãmeña, suro merã ããrĩpereri iri wiima makãpʉrori tũpãpereakõãyuro. Peresugue ããrĩrã́rẽ ĩgʉ̃sã kõmedari merã sʉadeadaride kurakõãyuro. ");
INSERT INTO sri_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Irasũ waamakʉ̃, ĩgʉ̃sãrẽ koregʉ yobe, iri wiima makãpʉrori toyomakʉ̃ ĩãgʉ̃: “Peresu ããrãnerã duriwiriapereakõãñuma”, ãrĩ gũñayupʉ. Irasirigʉ ĩgʉ̃ya sareri majĩrẽ ãĩ, ĩgʉ̃ basi sareboadʉagʉ iriadiyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ĩgʉ̃ irasirimakʉ̃ ĩãgʉ̃, Pablo ĩgʉ̃rẽ gaguiníyupʉ: —Mʉ basi ñerõ neõ iribirikõãka! Ããrĩperekõãa gʉa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, sĩãgodore, Pablosã pʉro ũmawãgã, ĩgʉ̃sãya guburi pʉro naradari merã ejamejãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pʉrʉ ĩgʉ̃sãrẽ ãĩwiu, ãsũ ãrĩ sẽrẽñayupʉ: —¿Nasirigʉkuri, yʉ Marĩpʉ yʉre taumakʉ̃ gããmegʉ̃? ");
INSERT INTO sri_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pablosã yʉjʉñurã: —Marĩ Opʉ Jesucristore bʉremuka! Mʉya wii marãde ĩgʉ̃rẽ bʉremuburo. Mʉsã ĩgʉ̃rẽ bʉremumakʉ̃ ĩãgʉ̃, Marĩpʉ mʉsãrẽ taugʉkumi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Irasũ ãrĩ odo, ĩgʉ̃ya wii marãdere Jesúya kerere wereñurã. ");
INSERT INTO sri_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ñami deko pʉrʉ ĩgʉ̃sãrẽ koreadi ĩgʉ̃sãya kãmirẽ koeyupʉ. Ĩgʉ̃ koe odoadero pʉrʉ, Pablosã ĩgʉ̃rẽ, ĩgʉ̃ya wii marãdere deko merã wãĩyeñurã. ");
INSERT INTO sri_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ĩgʉ̃sãrẽ wãĩyeadero pʉrʉ, Pablosãrẽ ĩgʉ̃ya wiigue ãĩa, baari ejoyupʉ. Ĩgʉ̃, ĩgʉ̃ya wii marã merã Marĩpʉre bʉremusĩã, bʉro ʉsʉyañurã. ");
INSERT INTO sri_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Boyoripoe oparã surarare iriuñurã, peresu wii koregʉre Pablosãrẽ wiudorerã. ");
INSERT INTO sri_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Iri wii koregʉ irire pégʉ, Pablosãrẽ ãrĩyupʉ: —Oparã mʉsãrẽ wiridoreañurã. Irasirirã güiro marĩrõ ʉsʉyari merã wirika! ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pégʉ, Pablo gapʉ ãrĩyupʉ surarare: —Oparã gʉa ñerõ irideare bokabirikererã, masaka wárã ĩũrõ gʉare tãrãdoreama. Ĩgʉ̃sã, gʉa romano marã ããrĩkeremakʉ̃, tãrãdoreama. Pʉrʉ peresu iriama. ¿Dapague gʉare masaka ĩãbero wiudʉari? Ããrĩbea. Ĩgʉ̃sã basita wiurã aariburo gʉare, ãrĩyupʉ Pablo. ");
INSERT INTO sri_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, surara Pablo ãrãdeare oparãrẽ wererã waañurã. Pablo, Silas romano marã ããrĩ́ma, ãrĩrĩ kerere pérã, oparã güigorañurã. ");
INSERT INTO sri_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Irasirirã Pablosã pʉro ejarã, ãsũ ãrĩñurã: —Kãtika, gʉa mʉsãrẽ peresu iriadeare! Irasũ ãrĩ odo, ĩgʉ̃sãrẽ peresugue ããrãnerãrẽ wiu: “Gʉaya makãrẽ wirika!” ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Irasirirã Pablosã peresugue ããrãnerã wiria, Lidiaya wiigue waañurã. Irogue eja, Jesúre bʉremurã nerẽanerãrẽ bokajarã, õãrõ gũñaturanemomakʉ̃ iriñurã. Pʉrʉ waakõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo, Silas merã waarã́, Anfípolire, Apoloniare taria, Tesalónicague ejañurã. Iri makãguere judío masaka nerẽrĩ wii ããrĩyuro. ");
INSERT INTO sri_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Irogue eja, Pablo iri wiigue waayupʉ ĩgʉ̃ gaji makãrĩrẽ irinaderosũta. Ʉre semana judío masaka siñajãrĩnʉrĩ ããrĩmakʉ̃, iro marãrẽ Marĩpʉyare werenayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ãsũ ãrĩ bueyupʉ: —Marĩpʉ iriudi, Cristo ããrĩ́mi. Marĩ ñerõ iridea waja ñerõ taridi ããrĩmí. Ĩgʉ̃ boadero pʉrʉ, Marĩpʉ gapʉ ĩgʉ̃rẽ masũdi ããrĩmí marĩ õãrõ ããrĩburire. Ĩĩ Jesús yʉ ãsũ ãrĩ weregʉ, ĩgʉ̃ta Cristo ããrĩ́mi marĩrẽ taugʉ. Ãsũta ãrĩ werea, Marĩpʉya kerere ĩgʉ̃sã gojadea pũguere, ãrĩ wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ĩgʉ̃ irasũ ãrĩmakʉ̃ pérã, surãyeri judío masaka ĩgʉ̃ wererire: “Diayeta ããrã”, ãrĩ bʉremuñurã. Irasirirã Pablosã merã waañurã. Gajirã wárã griego masaka Marĩpʉre bʉremurĩmasã, oparã nomede, Pablo wererire pérã, bʉremuñurã. Irasirirã ĩgʉ̃sãde ĩgʉ̃sã merã waañurã. ");
INSERT INTO sri_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Gajirã judío masaka irasirimakʉ̃ ĩãrã, Pablosãrẽ ĩãturi, wárã ñerã moãmerãrẽ siiu neeõ: “Pablo ĩgʉ̃ merãmarã merã ñerõ irigʉ yámi”, ãrĩ gaguinírã waaka i makã marãrẽ, ãrĩ iriuñurã. Irasũ ãrĩ gaguinírã, ããrĩpererã iri makã marãrẽ Pablosã merã guamakʉ̃ iriñurã. Irasirirã Jesúre bʉremugʉ̃ Jasón wãĩkʉgʉya wiima makãpʉrore turaro merã tʉ̃ãkoro, ñajãa, Pablosãrẽ ãmadiñurã masakaguere wiadʉarã. ");
INSERT INTO sri_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ĩgʉ̃sãrẽ bokabirisĩã, Jasṍrẽ, gajirã Jesúre bʉremurãdere ñeã tʉ̃ãwãgã, iri makã marã oparã pʉrogue ãĩa, irogue eja, gaguiníñurã: —Pablosã ããrĩpererogue masakare gariborã iriama. Dapagorare marĩya makãrẽ ejasiama. ");
INSERT INTO sri_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ĩĩ Jasón ĩgʉ̃sãrẽ ĩgʉ̃ya wiigue ñajãdoreami. Ĩĩsã ããrĩpereri marĩ romano marã opʉ dorerire tarinʉgãma. “Gajigʉ mʉsã Opʉ, Jesús wãĩkʉgʉ ããrĩ́mi”, ãrĩ buema masakare, ãrĩ gaguiníñurã oparãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ĩgʉ̃sã irasũ ãrĩ gaguinímakʉ̃ pérã, ããrĩpererã iri makã marã, ĩgʉ̃sã oparãde Pablosã merã guañurã. “¿Naásũ waáari?” ãrĩ gaguinísirikõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Irasirirã oparã Jasṍrẽ, ĩgʉ̃ merãmarãdere peresu waadoremerã: “Dupaturi Pablosãrẽ iritamubirikõãka!” ãrĩ, niyeru wajaridore, wiukõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pʉrʉ iri ñamita Jesúre bʉremurã Pablosãrẽ Bereague iriukõãñurã. Irogue eja, judío masaka nerẽrĩ wiigue waañurã. ");
INSERT INTO sri_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Judío masaka Berea marã gapʉ Tesalónica marã nemorõ Jesúya kerere õãrõ pédʉañurã. Irasirirã irire: “¿Diayeta ããrĩ́rĩ?” ãrĩ masĩdʉarã, ʉ̃mʉrikʉ Marĩpʉya werenírĩ gojadea pũmarẽ bueníkõãñurã. ");
INSERT INTO sri_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Irasirirã wárã Jesúre bʉremuñurã. Gajirã griego masakade, iri makã marã oparã nomede bʉremuñurã. ");
INSERT INTO sri_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pablo, Berea marãrẽ Marĩpʉyare wereri kerere pérã, Tesalónica marã judío masaka ejañurã. Irore eja, Berea marãrẽ kere ãrĩ, Pablosã merã guamakʉ̃ iriñurã. ");
INSERT INTO sri_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ĩgʉ̃sã irasirimakʉ̃ ĩãrã, Jesúre bʉremurã Pablore mumurõ merã dia wádiya tʉrogue iriuñurã. Ĩgʉ̃ merãmarã gapʉ Silas, Timoteo merã Bereague dujañurã. ");
INSERT INTO sri_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablore ãĩwãgãnerã Atenas wãĩkʉri makãgue eja, ĩgʉ̃rẽ irogue pí, Bereague gãme dujáakõãñurã doja. Irogue dujajarã, Pablo ĩgʉ̃: “Murĩgora Silas, Timoteode õõgue aariburo”, ãrĩ kere iriuadeare wereñurã ĩgʉ̃sãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo Atenague Silas, Timoteore yúgʉ, iri makã marã keori weadeare wári opamakʉ̃ ĩãgʉ̃, bʉro bʉjawereyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Irasirigʉ judío masaka nerẽrĩ wiigue ĩgʉ̃sã merã werenígʉ̃ waayupʉ. Iroguere gajirã judío masaka ããrĩmerã Marĩpʉre bʉremurã ããrĩñurã. Ĩgʉ̃sã merãdere wereníyupʉ. Ʉ̃mʉrikʉ iri makã marã ĩgʉ̃ bokajarã merã wereníyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Gajirã ʉ̃made Epicúreos wãĩkʉri bumarãyare buerimasã, gajirã Estoicos wãĩkʉri bumarãyare buerimasã Pablo merã wereníñurã. Ĩgʉ̃ weremakʉ̃ pérã, ãsũ ãrĩ gãme sẽrẽñañurã: —¿Naásũ ãrĩ weredʉagʉ yári, ĩĩ iropa werenígʉ̃? ãrĩñurã. Pablo Jesúyare, ĩgʉ̃ masã mʉrĩadeare weremakʉ̃ pérã, gajirã ãsũ ãrĩñurã: —Gajiro marã ĩgʉ̃sã bʉremurãyare weregʉ irikumi, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Irasirirã ĩgʉ̃sã nerẽrõ Areópago wãĩkʉrogue Pablore ãĩãñurã. Irogue ãĩja, ĩgʉ̃rẽ ãrĩñurã: —Gʉa maama bueri mʉ wererire masĩdʉakoa. ");
INSERT INTO sri_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mʉ bueri gajirosũ ããrã. Irasirirã gʉa: “¿Naásũ ãrĩdʉaro yári iri?” ãrĩ masĩdʉakoa, ãrĩñurã Pablore. ");
INSERT INTO sri_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ããrĩpererã Atenas marã, gajiro marã iri makã ejanerãde maama bueri ditare werenídʉañurã. ");
INSERT INTO sri_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Irasirigʉ Pablo Areópagogue ĩgʉ̃rẽ ãĩjadero pʉrʉ, wãgãnʉgã, ãsũ ãrĩ wereyupʉ ĩgʉ̃sãrẽ: —Keori weadeare mʉsã ããrĩpererã õãrõ bʉremua. Irire masĩa yʉ. ");
INSERT INTO sri_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","I makã mʉsãya makãrẽ naagorenagʉ̃, mʉsã bʉremurõrẽ ĩãbʉ. Sugʉ mʉsã bʉremugʉ̃rẽ sĩdea soepeorogue gojatúdeadere ĩãbʉ. “Ʉ̃mʉgasigue marã Opʉ marĩ masĩña marĩgʉ̃rẽ bʉremurõ ããrã”, ãrĩ gojatúdeare ĩãbʉ. Mʉsã ĩgʉ̃rẽ masĩbirikeremakʉ̃, ĩgʉ̃rẽta werea yʉ mʉsãrẽ, ãrĩyupʉ Pablo. Irasũ ãrĩ odo, ãrĩnemoyupʉ doja: ");
INSERT INTO sri_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","—Marĩpʉ i ʉ̃mʉrẽ ããrĩpereri iridi ããrĩmí. Ʉ̃mʉgasi, i nikũ Opʉ ããrĩ́mi. Masaka iridea wiirire ããrĩbemi. ");
INSERT INTO sri_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Marĩ iritamurĩrẽ gããmebemi. Ĩgʉ̃ gapʉ marĩrẽ iritamumi. Marĩ ããrĩrikʉrire, ããrĩpereri gajinodere sĩmi. Okari opamakʉ̃ yámi. Yʉjʉãĩmakʉ̃ yámi marĩrẽ. ");
INSERT INTO sri_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Marĩpʉ sugʉ ʉ̃mʉ́ʉ merãta ããrĩpereri buri marã ããrĩmakʉ̃ iridi ããrĩmí, ĩgʉ̃sãrẽ i nikũ ããrĩpereroguere ããrĩburo, ãrĩgʉ̃. “Õõpa yoaripoe okarãkuma ĩgʉ̃sã ããrĩrṍguere”, ãrĩ pídi ããrĩmí. ");
INSERT INTO sri_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Marĩpʉ: “Yʉre ãmarã́ bokaburo”, ãrĩgʉ̃, irasiridi ããrĩmí. Ĩgʉ̃rẽ marĩ bokaburo, ãrĩgʉ̃, yoarogue ããrĩbemi. Marĩ merãta ããrĩ́mi. ");
INSERT INTO sri_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Marĩpʉ marĩrẽ ããrĩmakʉ̃ yámi. Ĩgʉ̃ marĩmakʉ̃ marĩbukuyo. Marĩ okari, marĩ irimasĩrĩ, marĩ ããrĩrikʉrire sĩgʉ̃ ããrĩ́mi. Mʉsã bayarire gojarimasãde ãsũ ãrĩ gojanerã ããrĩmá: “Marĩde ʉ̃mʉgasigue marã Opʉ pũrã ããrã”, ãrĩ gojanerã ããrĩmá. ");
INSERT INTO sri_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Irasirirã marĩ ĩgʉ̃ pũrã ããrĩrã́, keori masaka weadeare ĩgʉ̃sã gũñarõ merã irideare: “Marĩpʉ irirosũ ããrĩ́mi”, ãrĩ gũñabirikõãrã! Marĩpʉ, masaka oro, plata, ʉ̃tãyeri merã keori weadea irirosũ ããrĩbemi. ");
INSERT INTO sri_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Marĩpʉ iripoegue marã ĩgʉ̃rẽ masĩmerã ĩgʉ̃rẽ bʉremubirimakʉ̃ irasũ ĩãkõãdi ããrĩmí. Irasirigʉ, dapaguere pama marĩrẽ ããrĩpererã i nikũgue ããrĩrã́rẽ: “Mʉsã ñerõ irideare bʉjawereka! Mʉsã gũñarĩrẽ gorawayuka!” ãrĩmi. ");
INSERT INTO sri_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pʉrʉ Marĩpʉ ããrĩpererã ñerãrẽ wajamoãrĩnʉ ejamakʉ̃, ĩgʉ̃ beyedi Jesús merã ããrĩpererã i nikũgue ããrĩrã́rẽ diayeta irigʉkumi õãrãrẽ beye, ñerã gapʉre béobu. Jesús boadero pʉrʉ, Marĩpʉ ĩgʉ̃rẽ masũgʉ̃, ĩgʉ̃ beyedi ããrĩrĩ́rẽ ĩmudi ããrĩmí ããrĩpererãrẽ, ãrĩ wereyupʉ Pablo Atenas marãrẽ. ");
INSERT INTO sri_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ĩgʉ̃ Jesús boadigue masãdeare weremakʉ̃ pérã, gajirã ĩgʉ̃rẽ ubu bʉrikõãñurã. Gajirã gapʉ: —Dupaturi ire mʉ weremakʉ̃ pédʉakoa doja, ãrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pablo ĩgʉ̃sãrẽ piri waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Gajirã, ĩgʉ̃ wererire pénemodʉarã ĩgʉ̃ merã waañurã. Irasirirã Jesúre bʉremunʉgãñurã. Ĩgʉ̃sã merã sugʉ Dionisio wãĩkʉgʉ Areópagogue oparã merã nerẽrĩmasʉ̃ ããrĩyupʉ. Gajigo Dámaris wãĩkʉgode gajirã merã Jesúre bʉremunʉgãyupo. ");
INSERT INTO sri_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pʉrʉ Pablo Atenague ããrãdi waa, Corinto wãĩkʉri makãgue ejayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Irogue judío masakʉ Aquila wãĩkʉgʉre Ponto nikũmʉrẽ bokajayupʉ. Aquila, ĩgʉ̃ marãpo Priscila merã Italia nikũgue ããrĩnerã ããrãdima. Ĩgʉ̃sã irogue ããrĩripoe romano marã opʉ Claudio wãĩkʉgʉ ããrĩpererã judío masakare Romarẽ wiridoremakʉ̃, Aquila ĩgʉ̃ marãpo merã Corintogue ejanerã ããrĩmá. Ĩgʉ̃sã irogue ããrĩmakʉ̃, Pablo ĩgʉ̃sãrẽ ĩãgʉ̃ waayupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ĩgʉ̃de ĩgʉ̃sã moãrikʉrinorẽta moãgʉ̃ ããrĩyupʉ. Irasirigʉ dujakõãyupʉ ĩgʉ̃sã merã moãbu. Ĩgʉ̃sã surí gasiri merã wiiri irirã ããrĩñurã. ");
INSERT INTO sri_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pablo, judío masaka siñajãrĩnʉrikʉ ĩgʉ̃sã nerẽrĩ wiigue waa, judío masakare, judío masaka ããrĩmerãdere Jesúya kerere werenayupʉ, ĩgʉ̃sã iri kerere: “Diayeta ããrã”, ãrĩ gũñaburo, ãrĩgʉ̃. ");
INSERT INTO sri_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Timoteo, Silas merã Macedoniague ããrãnerã Pablo pʉrogue ĩgʉ̃sã ejadero pʉrʉ, Pablo surí gasiri merã wiiri moãrĩrẽ piri, ʉ̃mʉrikʉ judío masakare Jesúya kerere diaye ãrĩrĩ merã bueyupʉ: —Jesús ããrĩ́mi marĩ yoaripoe yúdi. Ĩgʉ̃ta Marĩpʉ iriudi, Cristo ããrĩ́mi, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ĩgʉ̃ irasũ ãrĩ buekeremakʉ̃, judío masaka gapʉ ĩgʉ̃rẽ pédʉabiriñurã. Irasirigʉ ĩgʉ̃sã ñerõ werenírĩ merã ĩgʉ̃rẽ werewʉamakʉ̃ pégʉ, Pablo ĩgʉ̃sãrẽ: “Buenemobirikoa”, ãrĩ ĩmugʉ̃ ĩgʉ̃ya suríre iroma nikũ tuadeare pásiri, ãsũ ãrĩyupʉ: —Marĩpʉ dorederosũta mʉsãrẽ bueabʉ. Mʉsã gapʉ yʉre pédʉabea. Irasirirã mʉsã pédʉabiri waja perebiri peamegue waarãkoa. Irasirigʉ yʉ mʉsãrẽ bueadeare pirigʉkoa. Dapagorare judío masaka ããrĩmerãrẽ buegʉ waagʉra, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Irasũ ãrĩ, iri wiigue ããrãdi wiria, Ticio Justo wãĩkʉya wiigue waayupʉ. Ĩgʉ̃ya wii judío masaka nerẽrĩ wii tʉro ããrĩyuro. Ĩgʉ̃ Marĩpʉre bʉremugʉ̃ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nerẽrĩ wii opʉ Crispo wãĩkʉgʉ, ããrĩpererã ĩgʉ̃ya wii marãde Jesúre bʉremuñurã. Gajirã Corinto marãde wárã Jesúya kerere pérã, ĩgʉ̃rẽ bʉremunʉgãñurã. Irasirirã deko merã wãĩyesũñurã, ĩgʉ̃sã Jesúre bʉremurĩrẽ ĩmurã. ");
INSERT INTO sri_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Su ñami Pablore kẽrõgue irirosũ marĩ Opʉ ĩgʉ̃rẽ ãsũ ãrĩ wereyupʉ: —Güibirikõãka! Neõ piriro marĩrõ yaa kerere bueníkõãka i makã marãrẽ! ");
INSERT INTO sri_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Yʉ, mʉ merã ããrã. Irasirirã masaka mʉrẽ ñerõ irimasĩbema. I makãrẽ wárã yaarã ããrĩ́ma, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Irasirigʉ Pablo iro marã merã su bojori gaji bojori deko ããrĩyupʉ Marĩpʉya kerere buegʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Iripoere romanomʉ Galión wãĩkʉgʉ Acaya nikũ marã opʉ ããrĩripoe judío masaka suro merã nerẽ, Pablore ñeã, Galión pʉrogue ãĩja, ");
INSERT INTO sri_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ãsũ ãrĩñurã: —Ĩĩ masakare: “Ãsũ gapʉ irika, Marĩpʉre bʉremurã!” ãrĩ buegʉ, i nikũma doreri gapʉre béodoremi, ãrĩñurã Galiṍrẽ. ");
INSERT INTO sri_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ĩgʉ̃sã irasũ ãrĩmakʉ̃, Pablo ĩgʉ̃sãrẽ werebu iriripoeta Galión gapʉ judío masakare ãrĩyupʉ: —Ĩgʉ̃ ñerõ iriadero pʉrʉ tamerãrẽ yʉ péboakuyo mʉsã judío masaka weresãrĩrẽ. ");
INSERT INTO sri_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mʉsã dorerire tarinʉgãmakʉ̃, mʉsã basi ãmuka! Ire masĩbea yʉ. Irasirigʉ irire: “Irasũta irika!” ãrĩmasĩbirikoa, ãrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Irasũ ãrĩgʉ̃ta ĩgʉ̃yarã surarare Pablore weresãrãrẽ béowiudoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Irasirimakʉ̃ ĩãrã, ããrĩpererã iri wii ããrĩrã́ Sóstenẽrẽ judío masaka nerẽrĩ wii opʉre ñeã, Galión ĩũrõ páñurã. Ĩgʉ̃sã pámakʉ̃ ĩãgʉ̃, Galión gapʉ: “Ĩgʉ̃sã gããmerõ iriburo”, ãrĩ ĩãkõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo Corintogue yoaripoe ããrĩyupʉ dapa. Pʉrʉ Jesúre bʉremurãrẽ: “Waagʉ́ yáa”, ãrĩ odo, doódiru merã Priscila, Aquila merã Siriama makãgue waakõãñurã. Ĩgʉ̃ doódiru merã waaburi dupiyuro Cencreague ããrĩgʉ̃́, Marĩpʉre: “Ãsũ irigʉra mʉrẽ bʉremugʉ̃”, ãrĩderosũta ĩgʉ̃ya poarire wʉʉapeokõãdoreyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pʉrʉ ĩgʉ̃sã merã waa, Efeso wãĩkʉri makãgue eja, Priscila, Aquilare píkõã, judío masaka nerẽrĩ wiigue waayupʉ. Iri wiigue eja, judío masaka iro nerẽanerã merã Marĩpʉyare wereyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ĩgʉ̃ irasũ weremakʉ̃ pérã, ĩgʉ̃rẽ: “Yoaripoe dujaka gʉa merã!” ãrãdiñurã. Ĩgʉ̃ gapʉ: “Dujabea mʉsã merã”, ");
INSERT INTO sri_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ãrĩgʉ̃ta ĩgʉ̃sãrẽ seretuyupʉ: —Jerusalẽ́gue bosenʉ ĩãgʉ̃ waagʉ́ yáa. Marĩpʉ gããmemakʉ̃ dupaturi ĩãgʉ̃ dujaribukoa mʉsãrẽ, ãrĩyupʉ. Irasũ ãrĩ odo, Efesogue ããrãdi doódiru merã waakõãyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Irasirigʉ Cesareare tariwãgã, Jerusalẽ́gue eja, iro marã Jesúre bʉremurãrẽ õãdoregʉ ejayupʉ. Pʉrʉ Antioquíague waayupʉ doja. ");
INSERT INTO sri_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Irore yoaweyaripoe ããrĩ, pʉrʉ Galaciama makãrĩgue Frigiama makãrĩrẽ dupaturi eja, iri makãrĩ marãrẽ Jesúre bʉremurãrẽ bue, ĩgʉ̃sãrẽ õãrõ ʉsʉyari merã ããrĩrikʉmakʉ̃ iriyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iripoere judío masakʉ Apolos wãĩkʉgʉ, Alejandría wãĩkʉri makãmʉ Efesogue ejayupʉ. Ĩgʉ̃ õãrõ weregʉ, Marĩpʉya werenírĩ gojadeare masĩgʉ̃ ããrĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Gajirã ĩgʉ̃rẽ marĩ Opʉ Jesúya kerere weresianerã ããrĩmá. Irasirigʉ ʉsʉyari merã Jesús irideare diaye ãrĩrĩ merã wereyupʉ. Irasirikeregʉ, Juan masakare deko merã wãĩyedea ditare masĩyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Güiro marĩrõ judío masaka nerẽrĩ wiigue ããrĩrã́rẽ buenʉgãyupʉ. Ĩgʉ̃ buerire péanerã Priscila, Aquila ĩgʉ̃sãya wiigue ĩgʉ̃rẽ ãĩa, irogue õãrõ diaye ãrĩrĩ merã wereñurã ĩgʉ̃ Marĩpʉyare masĩbirire. ");
INSERT INTO sri_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Pʉrʉ Apolos Acayague waadʉamakʉ̃, Jesúre bʉremurã ĩgʉ̃rẽ su pũ gojabosañurã. Irasirirã Jesúre bʉremurãrẽ Acayague ããrĩrã́rẽ: “Apolore õãrõ bokatĩrĩñeãka!” ãrĩrĩ pũrẽ ĩgʉ̃ merã iriuñurã. Irasirigʉ Apolos irogue ejamakʉ̃, Marĩpʉ ĩgʉ̃sãrẽ maĩgʉ̃, ĩgʉ̃ merã õãrõ iritamuyupʉ. ");
INSERT INTO sri_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Irasirigʉ Apolos ããrĩpererã ĩũrõ judío masakare õãrõ turari merã: —Marĩpʉ iriudi, mʉsã yoaripoe yúdi, Cristo ããrĩ́mi. Ĩgʉ̃ta Jesús ããrĩ́mi, ãrĩyupʉ. Irasirirã Marĩpʉya werenírĩ gojadea pũrẽ keoro weremakʉ̃ pérã, judío masaka: “Diaye ããrĩbea”, ãrĩmasĩbiriñurã. ");
INSERT INTO sri_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Corintogue ããrĩripoe Pablo