﻿USE sofia;
DROP TABLE IF EXISTS sofia.spyNT_vpl;
CREATE TABLE spyNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES spyNT_vpl WRITE;
INSERT INTO spyNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","*Teteet ꞉nyi nyēē rōōbu siintaaryeetaab Yēēsu. Sālu ꞉Yēēsu *Kiriistō Bāytooyiintēēt *Tāwuti ānkusālu nkinee *Abraam. ");
INSERT INTO spyNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ki kwaaniitaab Isaka ꞉Abraam. Nto Isaka ki kwaaniitaab Yāākōbō. Ki kwaaniitaab Yuuta ākoo mbo ng'eetaabkaam ꞉Yāākōbō. ");
INSERT INTO spyNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ki kwaaniitaab Bērēēs ākoo Seera ꞉Yuuta. (Nto kaamet ku Tamaar.) Ki kwaaniitaab Ēsrōōn ꞉Bērēēs. Nto Raam ku kwaan ꞉Ēsrōōn. ");
INSERT INTO spyNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ki kwaaniitaab Aminataab ꞉Raam. Kwaaniitaab Nāāsyōōn ku Aminataab. Kwaaniitaab Sālmōōn ku Nāāsyōōn. ");
INSERT INTO spyNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nto Sālmōōn ku kwaaniitaab Boowaas. (Ki kaametiitaab Boowaas Raa-ab.) Ki kwaaniitaab Ōbēēt ꞉Boowaas. (Nto kaametiitaab Ōbēēt ku Ruut.) Kwaaniitaab Yēēsē ku Ōbēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Kwaaniitaab Bāytooyiintēēt Tāwuti ku Yēēsē. Ki kwaaniitaab Sōlōmōōn ꞉Tāwuti. (Nto kaametiitaab Sōlōmōōn ku koorkoonoo kibo chiichoo /kikēēkuurēē Uriiya.) ");
INSERT INTO spyNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Kwaaniitaab Reewoboowaam ku Sōlōmōōn. Kwaaniitaab Abiiya ku Reewoboowaam. Kwaaniitaab Aasa ku Abiiya. ");
INSERT INTO spyNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ki kwaaniitaab Yeewosyafaat ku Aasa. Kwaaniitaab Yooraam ku Yeewosyafaat. Nto kwaaniitaab Usiiya ku Yooraam. ");
INSERT INTO spyNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Kwaaniitaab Choosam ku Usiiya. Nto Choosam ku kwaaniitaab A-aas. Ki kwaaniitaab Esekyaa ꞉A-aas. ");
INSERT INTO spyNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kwaaniitaab Mānāāsē ꞉Esekyaa. Nto kwaaniitaab Āmōōn ku Mānāāsē. Ki kwaaniitaab Choosaaya ꞉Āmōōn. ");
INSERT INTO spyNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Kwaaniitaab Yeekonnyaa ākoo mbo ng'eetaabkaam ku Choosaaya. Bēsyōōsyēchooto ꞉chēē /kikēēnāmēē Yuutayeek /ānkēēyib bokuyēk motwoor ām *Bābulōōn. ");
INSERT INTO spyNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yu /kābokēēyib kuba Bābulōōn, kunyōōr ꞉Yeekonnyaa wēēriit nyēē /kikēēkuurēē Syeeltyeel. Kwaaniitaab Sērubābēēl ku Syeeltyeel. ");
INSERT INTO spyNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Kwaaniitaab Ābiyuut ku Sērubābēēl. Kwaaniitaab Elyaakim ꞉Ābiyuut. Nto kwaaniitaab Asoor ku Elyaakim. ");
INSERT INTO spyNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ki kwaaniitaab Sātōōk ꞉Asoor. Kwaaniitaab Ākiim ku Sātōōk. Nto kwaaniitaab Ēlyuut ku Ākiim. ");
INSERT INTO spyNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Kwaaniitaab Elyeeser ꞉Ēlyuut. Kwaaniitaab Maatan ku Elyeeser. Kwaaniitaab Yāākōbō ku Maatan. ");
INSERT INTO spyNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nto kwaaniitaab Yōōsēēf ku Yāākōbō. Nto Yōōsēēf ku saanteetaab Maaryaa nyoo kaametiitaab Yēēsu nyoo /kēēkuurē kule *Kiriistō. ");
INSERT INTO spyNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kunyoo kung'eetee Abraam ākoy Tāwuti, ku binuutēk taman āk ang'wan. Kung'eetee Tāwuti ākoy bēsyōōsyēchoo /kikēēyibēē Yuutayeek kuba Bābulōōn, ku binuutēk taman āk ang'wan. Nto kung'eetee bēsyōōsyēchooto /kikēēyibē Yuutayeek kuba Bābulōōn ākoy yoo /kikēēsichē Kiriistō, ku binuutēk alak taman āk ang'wan. ");
INSERT INTO spyNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wōlēē /kikēēsikto Yēēsu Kiriistō kumii kule: Kikiikuwo ꞉Yōōsēēf mākiisyō kumāchē koomut Maaryaa. Nteenee kutoombo kōōmutē keey, kutook kule kinyikiis ꞉Maaryaa. Kinyikiis ām kāāmuukēywēēkaab Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ki chii ꞉Yōōsēēf nyēē churtaat. Koosoot koochuchuuy keey simēēntosuur Maaryaa. ");
INSERT INTO spyNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nto yu tākumii kōōsōōtē ꞉Yōōsēēf ng'aleechu, kuchōōnchi *꞉malayikeet ām kiirwootik ānkumwoochi kule, “Yōōsēēf nyēbo kōōtaab Tāwuti, ‑meetay Maaryaa. Ntēē Tāmirmiryēētaab Yēyiin ꞉nyēē kayey kumanach ꞉Maaryaa. ");
INSERT INTO spyNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mākusich wēēriit ānku +mēētoochi kaayneet kule Yēēsu kuuyu makooraraach biiko ām ng'ōōkiswookikwaa.” ");
INSERT INTO spyNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kiyityiin ꞉ng'aleechu tukul kubo kiyēē kimwooy ꞉Yēyiin kubununēē *wōōrkooyoontēēt ake kule, ");
INSERT INTO spyNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mākunyikisiit *꞉ārung'oonyoo ānkusich wēēro nyēē +/mākēēkuurēē Mānwēēl. (Ibooru ꞉kaaynaani bo Mānwēēl kule ‘Kēēboontē keey Yēyiin’.)” ");
INSERT INTO spyNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nto mii lētuunoo yu kāwokung'eetee ꞉Yōōsēēf rwoo, koomut Maaryaa kuu yoo kimwooytoochinē ꞉malayikeetaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kiibuurto ꞉Yōōsēēf Maaryaa nyēē mānāātuuyo ꞉tukwaay kut /kēēsich wēēroo. Yu /kākēēsich, kutoochi ꞉Yōōsēēf wēērooto kaayneet kule Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","/Kikēēsikyinē Yēēsu kiriinkēētaab Bēētēlēyēēm ām yēēmēētaab Yuuteeya kubāytooyiisyē *꞉Ērōōtē. Yu /kābokēēsich Yēēsu, kukwaanee ꞉biiko alake komostaab koong'asiis kukwa Yēērusālēēm, chēē kiboonto kiirnātēētaab kookeelik. ");
INSERT INTO spyNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yu kayit, kuteeb kule, “Miitē ānō ꞉Bāytooyiintēētaab Yuutayeek nyoo /kōkēēsichē? Kakeekasee wōlēē kēēbuurto ꞉kookeelyeet ām koong'asiis kule /kōōkēēsich, kunyi kaakeekwaa bokēēkutunkyi inee.” ");
INSERT INTO spyNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yu kawokukas ꞉Bāytooyiintēēt Ērōōtē ng'aleechaa, kwaam mēt miisin. Kiiyiimset ꞉ng'aleechaa nkicheek biikaab Yēērusālēēm tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yooto kōōruruuch ꞉bāytooyiintoonoo mbo *kibkōrōs chēē wōōyēch tukul ākoo kāānēētikaab kiruutēk tukul chēbo Yuutayeek ankuteebee kule, “+/Mākēēsikyi ānō *Kāārārookiintēēt nyoo kōkēēkānyē?” ");
INSERT INTO spyNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kuwālchi ꞉bichoo kule, “/Kēēsikyinē Bēētēlēyēēm ām Yuuteeya, kuuyu kimwooy ꞉Yēyiin kubununēē *wōōrkooyoontēēt ake kule, ");
INSERT INTO spyNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bēētēlēyēēm, ‑mēēmining' ꞉inyiing' mbo kisich ām kiriinkōōsyēkaab Yuuteeya, kuuyu mākurutunēēniing' ꞉bāytooyiintō ꞉nyēē makubayta biikyuu bo *Isrāyēēl.’” ");
INSERT INTO spyNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nto tēē yoo, kōōyookto *꞉Ērōōtē kuutiit ām kibchamumu /bokēēkuurchi bichoo kiboonto kiirnātēētaab kookeelik sukumwoochi inee āsiiswēk bakeenke chēē kitookunēē ꞉kookeelyaanaa. ");
INSERT INTO spyNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yooto kumwoochi bichoo kule, “Obe Bēētēlēyēēm ankuboocheeng' lakwanaa kāroomin, nto yoo kōōnyōōru, bōōmwoowoo sāāwē ꞉nkanii wāākutunkyi.” ");
INSERT INTO spyNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Yu keewaany ꞉Bāytooyiintēēt kung'āloolchi bichoo, kuba. Nto yu kakas ꞉icheek kookeelyaanaa kung'ērēkiis nyēbo kwōng'uut. Kiirēētoot ꞉kookeelyaanaa bo koong'asiis ākoy wokuteemanee barakuutaab ꞉lakwanaa. ");
INSERT INTO spyNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nto yu kēēwut ꞉bichoo kō, kunyōōr leekweet ākoo kaamet Maaryaa. Kukutunkyi lakwanaa. Nto tēē yoo kootyaach tukuuk chēbo kwōng'uut choo kibokōōkātēē lakwanaata, kunam wōlēē mii *꞉ta-aabuut āk tukuuk alak āyēēng' chēē boong'u nyēē anyiny. ");
INSERT INTO spyNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nto yu iyēēyē ꞉bichoo kaa, kubeetee kēēlto ake kuuyu kikiikuket icheek ꞉Yēyiin ām kiirwootik kule ‑meeyeey wōlēē miitē *꞉Ērōōtē. ");
INSERT INTO spyNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yu kāākubēēchi keey ꞉bichoo kiboonto kiirnātēēt, kuchōōnchi Yōōsēēf *꞉malayikeetaab Yēyiin ām kiirwootik ānkumwoochi kule, “Mii ꞉Ērōōtē wokuchēēng'ē leekweet kule kubakach. Kunyi imwēēytē lakwanaa ākoo kaamet ākoy Miisir ānkubōōbuur wōlooto ākoy āyibuung' lōkōōy.” ");
INSERT INTO spyNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kung'eet ꞉Yōōsēēf kwēēmowuunooto ānkumwoochi kaametiitaab leekweet kule kōōmwēēyto tukwaay leekweet ākoy Miisir. ");
INSERT INTO spyNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kibokōōbuur wōlooto kut kume ꞉Ērōōtē. Kuyityiin ꞉yooto ākoo yoo kimwooyē ꞉Yēyiin kubununēē *wōōrkooyoontēēt ake kule, “Kyāākuur lakwanyuu kuchōōnēē Miisir.” ");
INSERT INTO spyNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kikiikubēēr ꞉Ērōōtē yu kibo taay kule kikēnchi inee ꞉bichoo kibo kiirnātēēt. Yooto, kunyēēr miisin ānkumwooy kule /keebakach lēēkōōk tukul choo wēēriik ām Bēētēlēyēēm ākoo chēbo soong'wēk alak tukul choo ki laatoos. Kimwaayta /keebakach lēēkōōk choo boonto kēnyiisyēk āyēēng' ānkurēk kurubta keey āk wōlēē kimwaayta ꞉bichoo kibo kiirnātēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kunyoo kiyityiin ꞉yooto āk kiyoo kimwooyē ꞉wōōrkooyoontēēt Cheremnyaa kule, ");
INSERT INTO spyNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kichōōnēē ꞉kāānchōōyto Raama, nyēbo mēēysō āk ameetaab mbuy. Riirēē ꞉Rāāyēēl lōkōkyii āmāchāmē /keesaaysaay kuuyu mēēkumii ꞉lōkōchoo.” ");
INSERT INTO spyNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nto yu kāwokume ꞉Ērōōtē, kuchōōnchi *꞉malayikeetaab Yēyiin Yōōsēēf ām kiirwootik kumii Miisir ānkumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Oyeey kōōrēētaab Isrāyēēl kuuyu kōōkubēk ꞉choo kimāchē kubakach leekweet.” ");
INSERT INTO spyNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kung'eetita ꞉Yōōsēēf leekweet ākoo kaamet ānkutākyi keey kōōrēētaab Isrāyēēl. ");
INSERT INTO spyNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nteenee kikiikookeer ꞉Arkelaawo kwaan kubayta Yuuteeya. Yooto, kunyokoriit kuwo ākoy wōlooto. Nto subak, kikiikung'āloolchi inee ꞉Yēyiin ām kiirwootik kunyoo, kiwo ākoy yēēmēētaab Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kiwokuminy ām wōlooto kiriinkēētaab Nāāsārēēt. Kiyityiin ꞉yooto ākoo yoo kimwooyē *꞉wōōrkooyik kule, “+/Mākēēkuurēē Nāāsārēētiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yu kakeeyta ꞉kēnyiisyēk chēē chaang', kutook ꞉chiito ake nyēē /kikēēkuurēē Bātisāniintēēt Yoowaana nyēē kyoomtootēē lōkōōywēk suurkwēēnēētaab Yuuteeya. ");
INSERT INTO spyNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kimwooyē kule, “Oweeksee miyootyēēt kuuyu kaakuriik ꞉bāytooyiisyēētaab Yēyiin!” ");
INSERT INTO spyNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Inee ꞉nyoo king'āloolēē *꞉wōōrkooyoontēētaab Yēyiin *Isaaya yoo kimwooyē kule, “Miitē ꞉kuut nyēē kuuru ām suurkwēēn kule, ‘Ōchōb keey, ānkōōchuulchi Mokoryoontēēt kēēlto.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kiiloochē ꞉Yoowaana sireet nyēē /kikiikwoorunēē sabureekaab *tembes. Kimootee keey anweetaab suwe ānkwoomootē taalamik ākoo kimnyeteet. ");
INSERT INTO spyNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yooto kung'ēētyēē ꞉biiko Yēērusālēēm āk Yuuteeya kumukuul āk biitēētaab Yoortaan kutēē yēē tēē ānkubēēchi Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kimwaayta ꞉bichoo ng'ōōkiswookikwaa ankubatisanee ꞉Yoowaana āynēētaab Yoortaan. ");
INSERT INTO spyNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nto bērē kukas ꞉Yoowaana kakwa *꞉Farisaayeek chēē chaang' ākoo *Satukaayeek kule /keebatisan, kumwoochi bichoo kule, “Ōyēku ng'oomng'ook kuu ēērēēnōōy! Ōbērē +moochililee ng'wooninto nyoo mākuchō ee? ");
INSERT INTO spyNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mākwook nanyuun ōyēyē ng'al chēē kāroomēch sōōtooku kule kooweeksee miyootyēēt, ");
INSERT INTO spyNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","āmōōkwērtē keey ōmwooyē kule, ‘Ntēē kēēbooyē Abraam.’ Āmwoowook man kule imuuchē ꞉Yēyiin kuyey rwoontōōchu kuyēk lōkōkaab *Abraam. ");
INSERT INTO spyNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Itōrōōroot ꞉āywēēt nyēē māchē /keeyebee kēētit. Kunyi keet ake tukul nyoo kamayey lokoyeek chēē kāroomēch /kiiluultooy /ānkēētōōrchi ma. ");
INSERT INTO spyNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ābātisānēēnook ꞉anii bēēko kōōboor kule kooweeksee miyootyēēt, nteenee miitē kuchōōnii ꞉chiito nyēē wōō kubiira anii. ‑Māāyēmē mbo ārēēkyi kwēyōōnik. +Machokubatisaneenaak Tāmirmiryēētaab Yēyiin āk maata. ");
INSERT INTO spyNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Miitē chokusēēstooy mōōrōryēēk ankubeelee mōōrōryēēchoo maataab kibchuulyo nto yityo, kukonoree nkoonuuk chookē.” ");
INSERT INTO spyNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nto mii yoo kung'eetee ꞉Yēēsu Kalilaaya ānkuwokubatisan ꞉Yoowaana ām āynēētaab Yoortaan. ");
INSERT INTO spyNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nteenee kumach kutay ꞉Yoowaana. Kimwooy kule, “Ntēē ichōōnii wōlēē āmiitē ānku ꞉inyiing' nyēē kātēērook ibatisanaa?” ");
INSERT INTO spyNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kukētyi ꞉Yēēsu kule, “Yey ꞉inyiing' kuu nyooto raat kuuyu wuu nyooto ꞉wōlēē māktooy ꞉Yēyiin.” Kucham ꞉Yoowaana kubatisan Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nto yu /kaakeebatisan Yēēsu, kuloong'unēē bēēko āriit. /Kēēyootyi wōliin bo barak ankukas Tāmirmiryēētaab Yēyiin nyēē wuu chēēbtuukē kurēku ānkuchokōōbutyi inee. ");
INSERT INTO spyNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yooto /kēēkuur ām barak kule, “Lakwanyuu ꞉nyi nyoo āchāmē ānkāāng'ērēkyinē.” ");
INSERT INTO spyNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nto miitē yoo, kōōrēētoot ꞉Tāmirmiryēētaab Yēyiin Yēēsu ākoy wōlēē suurkwēēn suwokutyem *꞉Kēniintēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nto yu kāwokubēēni ꞉Yēēsu wōlooto bēsyōōsyēk artam nyēē kimoomē kiy ake tukul, kwaam ꞉kēmēwuut. ");
INSERT INTO spyNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kuchōōnchi ꞉Kēniintēēt ānkumwoochi kule, “Yoo inyiing' Lakwataab Yēyiin ii, iweech baa, rwoontōōchu kuyēk āmiik.” ");
INSERT INTO spyNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nteenee kuwālchi ꞉Yēēsu kule, “Ntēē mwooyē ꞉siruutēk kule, ‘Māsobēē ꞉chii āmit baateey nteenee sobēē ng'ālyoo ake tukul nyēē chōōnēē wōlēē mii ꞉Yēyiin.’” ");
INSERT INTO spyNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nto tēē yoo, kuwēēto ꞉Kēniintoonoo Yēēsu ākoy Yēērusālēēm ānkōōkoochi kōōyyoonyēē yēbo kotootyēēt ām barakuutaab tōōtēētaab *Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yooto kumwoochi kule, “Yoo inyiing' man Lakwataab Yēyiin ii, 'iraantee yuutēyu ākoy ng'wēny, kuuyu mwooyē ꞉siruutēk kule, ‘Mākōōyook ꞉Yēyiin malayikaanikyii bokutaaching' simēēbutyi rwaa kutuying'.’” ");
INSERT INTO spyNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kukētyi ꞉Yēēsu kule, “Ntēē mwooyē subak ꞉siruutēk kule, ‘‑Meetyem Yēyiintēēng'uung'.’” ");
INSERT INTO spyNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kuwēēto subak ꞉Kēniintoonoo Yēēsu lekemeet ake barak ānkōōboorchi bāytit nyēē mii kōōrōōsyēk tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kimwoochi kule, “+Māākōōniing' bāytiniin tukul yoo 'kēēkutung'woo.” ");
INSERT INTO spyNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kukētyi ꞉Yēēsu kule, “Buunyoontooni, ng'eetee yu. Mwooyē ꞉siruutēk kule, ‘Yēyiin ꞉nyēē māchāktōōs /kiiywēyē ānku inee nkit ꞉nyēē /kēēkutunkyinē.’” ");
INSERT INTO spyNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kubakaakta ꞉Kēniintoonoo Yēēsu. Nto yityo kukwa ꞉malayikaanik ānkubokuyēētyēēchi. ");
INSERT INTO spyNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nto yu kawokukas ꞉Yēēsu kule /kookeekerta Yoowaana kō, kung'eetee Yuuteeya ankooyeey Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nteenee yēē kātāminyē Nāāsārēēt, wokuminy Kaabernaam kulēēkitēē tōōliilēēt rōōrōōkoonoo kibo Sābulōōn āk Naftaali. ");
INSERT INTO spyNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kiyityiin ꞉yooto ākoo yoo kimwooyē ꞉wōōrkooyoontēēt *Isaaya kule, ");
INSERT INTO spyNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Kookukas ꞉bichoo minyē mēēnān lēbkēēyyēēt nyēē wōō ām rōōrōōkēētaab Sābulōōn āk nyēbo Naftaali wōloo lēēkitēē ꞉Tōōliilēētaab Kalilaaya āk āynēētaab Yoortaan, yēēmēētaab Kalilaaya wōloo miitē ꞉biich chēē sobooy. Kōōkuchōōnchi ꞉lēbkēēyyēēt bichoo minyē kōōr nyēē kitub ꞉mēēnānēētaab meet.” ");
INSERT INTO spyNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kyaamtaat ꞉Yēēsu lōkōōywēk kuchakee yooto kumwooyootē kule, “Oweeksee miyootyēēt kuuyu kaakuriik ꞉bāytooyiisyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nto mii bēsyēēt ake, yēē kimiitē ꞉Yēēsu kuwēēsyētēē sakaramteetaab Tōōliilēētaab Kalilaaya, kukas biiko alak āyēēng' chēē kituubcho. Kiwiirchinē ꞉bichoo nēētiinēkwaa tōōliil kunāmē *burburiinēk. /Kikēēkuurēē ake Simōōni nyoo /kibokēēkuur lētuunoo kule Bētērō nto nyiin ake ku Antereeya. ");
INSERT INTO spyNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kukuur ꞉Yēēsu bichoo kule, “Orubaa anii! +Maaneetaak wōlēē ōyisuntooy biiko.” ");
INSERT INTO spyNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kubākooktooy ꞉bichoo nēētiinēkwaa bakeenke ānkurubē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yu keenaata ꞉Yēēsu taay kisich, kukas subak biiko alak āyēēng' chēē kituubcho kutinyē keey kwaan ām mwēēng'. /Kikēēkuurēē ake Yāākōbō /kēēlē nyiin ake Yoowaana nto kwaan ku Sebetaayo. Kimiitē ꞉bichoo kuyēytooy nēētiinēkwaa. Yooto kukuur ꞉Yēēsu murēchooto āyēēng' choo kituubcho. ");
INSERT INTO spyNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kubākookyinē ꞉icheek kwaan mwēēng' ānkurubē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yooto nanyuun, kuwēēsyētootēē ꞉Yēēsu Kalilaaya tukul kōōnēētiisyootēē kooriikaab saayeet bo Yuutayeek. Kyoomtootē lōkōōywēk chēē kāroomēch chēbo bāytooyiisyēētaab Yēyiin ānkōōsoobootē biiko chēē kiboonto bōōrwoonik āk tānkuusyo ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","/Kikyaamtaat ng'aleechaa bo kwōng'uut choo kiyēyē ꞉Yēēsu ākoy yēēmēētaab Siirya kutēē yēē tēē. Yooto /kiimutyi inee biiko tukul chēē kimnyoontōōs kunam wōlēē mii ꞉chēē kitinyē tāmirmirook chēē miyootēch, chēē kitinyē mēwuunkook āk chēē kichunkutootiin. Kiisoob ꞉Yēēsu bichoo tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","King'ēētyēē ꞉biiko chēē mātēē chu Kalilaaya, Teekabooli, Yēērusālēēm, Yuuteeya ākoo biitēētaab Yoortaan ankoosaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kimii ꞉yēē kimāchē ꞉Yēēsu kwoomchi biiko lōkōōy. Kiiruruukyi keey ꞉biiko chēē chaang'. Yu kakas kuu nyooto, kuwo ꞉inee āk rubiikyii yēē tōrōōr ānkutēbēē ng'wēny. Kōōnookyi ꞉rubiichoo ");
INSERT INTO spyNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ānkutoow ꞉Yēēsu kōōnēētiis. Kimwooy kule, ");
INSERT INTO spyNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ibēruurootiin sōō, kule nee ꞉biiko choo imoong'tēē keey Yēyiin, kuuyu +mākōōwut bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ibēruurootiin sōō, kule nee ꞉biiko choo buntēē ng'woonin kuuyu mākukārāmchi ꞉ng'ala. ");
INSERT INTO spyNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ibēruurootiin sōō, kule nee ꞉biiko choo yibē keey ng'wēny, kuuyu mākuyēk nyeeng'waa ꞉kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ibēruurootiin sōō, kule nee ꞉biiko choo chēēng'ē churtaayeet, kuuyu mākunyōōr. ");
INSERT INTO spyNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ibēruurootiin sōō, kule nee ꞉biiko choo riirēē alak, kuuyu +/makeeriiree nkicheek. ");
INSERT INTO spyNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ibēruurootiin sōō, kule nee ꞉biiko choo leelach ꞉moonik, kuuyu makukas Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ibēruurootiin sōō, kule nee ꞉biiko choo wuulyēē ng'aleekaab kaalyeet, kuuyu +/mākēēkuur kule lōkōkaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ibēruurootiin sōō, kule nee ꞉biiko choo /kēēwusē yoo kayey kiyēē māchē ꞉Yēyiin, kuuyu mākōōwut Kaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ōbēruurootiin sōō, kule nee ꞉akweek choo ōyēnwoo anii, yoo /kākēēchubook /ānkēēwusook nto /kēēmōlōlchook ng'al chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yoo /kākēēyēwook kuu nyooto, ōtyēēn kubo ng'erekweek, kuuyu mii ꞉kiy nyēbo kwōng'uut nyēē mākutuwēnēēnook ꞉Yēyiin ām kibkōōnkōy. Ntēē /kiikēēwusoon mbo nkicheek *wōōrkooyikaab Yēyiin choo kibo taay kuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kimwooy ꞉Yēēsu kule, “Akweek ꞉muunyeetaab kōōrēēt. Nteenee yoo kakuskusiit ꞉muunyeet, /kāmēētākiitōōysēē nteenee /kēēluluktooy kootartaar ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Akweek ku lēbkēēyyēētaab kōōrēēt. Māwunyāktōōs *꞉kiriinkēēt nyoo /kikēētēēkyi tulwo, ");
INSERT INTO spyNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","āmāmii ꞉chii nyēē tābē taariit ānkōōkubuuyēē kērēbēēt, nteenee ikoochinē yēē itōrōōroot sukulēbkēchi biiko tukul ām kō. ");
INSERT INTO spyNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kunyoo māchāktōōs ōlēbkēchi biiko kubuntēē yēyuutēkwook chēē kāroomēch, si yoo kakasaak kookaasta Kōōn nyoo miitē kibkōōnkōy.” ");
INSERT INTO spyNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“‑Meesoot ꞉chii kule kyāāchōōnii ꞉anii chāānēmtooy ng'aleek choo kisirē *꞉Muusa āk chēbo *wōōrkooyik, nteenee kyāāchōōnii chāātyiichē ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kubooyiit man, āmwoowook kule ākoy kukeeyta ꞉barak ākoo ng'wēny, māmii ꞉kiy nyēē +/mākiinēmto ām kiruutēchoo ānkoo ku mining' nyēē tyaa, ākoy kuyityiin ꞉ng'aleek tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kunyoo, chii ake tukul nyēē kāmēto kiruutēchoo ānkoo mbo nyēē mining' nyēē tyaa ankuyey biiko alak kurub ng'aleekyii kumā chii ꞉nyoo ām bāytooyiisyēētaab Yēyiin. Nto nyoo karub kiruutēchoo ankuyey alak kurub, /kiitōrōōrē nyooto ām bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Āmwoowook kule, ‑mēēwutē ꞉chii bāytooyiisyēētaab Yēyiin yoo kamachurta kusiir Farisaayeechaa ākoo kāānēētichoo bo kiruutēk.” ");
INSERT INTO spyNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kitas taay ꞉Yēēsu kumwooy kule, “Ābērē kyookas kule /kikēēmwoochi chiitaab kēny kule, ‘‑Meebakach chii. Nto chii ake tukul nyoo kābākākiis, ākoy /kiitiilchi ng'al.’ ");
INSERT INTO spyNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nto anii āmwoowook kule chii ake tukul nyoo kānyēērchi ng'eetaabkaamet, +/mākiitiilchi ng'al. Nto chiito nyoo kāmwoochi ng'eetaabkaamet kule, ‘Iberber’ +/mākiiyyoong'tēē kōōk /sikiitiilchi ng'aleek, nto nyoo kālēēnchi ng'eetaabkaamet, ‘Iyēku solwo’, kumisyinē /kiimut /bokēētōōrchi wōlēē bo maataab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kunyoo, yoo imāchē ituwēnchi Yēyiin kiy ankiisoot kule itinyē tisya ām wōlēē mii ꞉ng'eetaabkoomēt, ");
INSERT INTO spyNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ibākookyi kiyoo yooto bo *Kōōtaab Yēyiin ānkiiwē wōlēē mii ꞉ng'eetaabkoomēt bōōchoomnyē kurook nto yityo wēētuwēntē kiyooto. ");
INSERT INTO spyNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yoo miitē ꞉chiito ake kukwēring' kōōk kubo bēsēnnyii nyēē iboontē, kumāchāktōōs simōkāsyiinē ām kēēltaab too kutoombo ōyitē kōōk. Yoo kameeyey kuu nyooto, kukwēriing' ꞉nyiin kōōk ānkōōyokoochiing' boontēētaab kōōk. Makunaming' ꞉boontoonoo bo kōōk ānkōōrēkēērchiing' chiito nyoo riibē kibratiisyek kukertiing' kō. ");
INSERT INTO spyNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","!Kāāmwoowook, +mēētēbii wōlooto ākoy iyaakte bēsēnoo tukul.” ");
INSERT INTO spyNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kitas taay ꞉Yēēsu kumwoochi rubiichoo kule, “Ābērē kyookas ꞉akweek kule /kikēēmwooy kēny kule, ‘‑'Meemarte.’ ");
INSERT INTO spyNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nto anii, āmwoowook kule, chii ake tukul nyoo kāsē koorko ānkuchōrōkyi kuwuu nyēē kaakumarta. ");
INSERT INTO spyNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kunyi, yoo kēēsākyiing' koong'uung' isuuchi ng'ōōki, ilōōtu. Kaykay iboot komosta akeenke nyēbo bōōrng'uung' kusiir /kēēwiirchi bōōrng'uung' tukul wōlēē bo maataab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nto yoo kēēsākyiing' ꞉āwung'uung' isuuchi ng'ōōki, itilte. Kaykay iboot komosta akeenke nyēbo bōōrng'uung' kusiir /kēēwiirchi bōōrng'uung' tukul wōlēē bo maataab kibchuulyo.” ");
INSERT INTO spyNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kimwooy ꞉Yēēsu subak kule, “Kyookas mbo subak /kēēmwooyē kule chii ake tukul nyēē māchē kubar kooyēēy kumāchāktōōs kusirchi koorkēēt barweet nyēē kakwetee. ");
INSERT INTO spyNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nto anii āmwoowook kule, chii ake tukul nyoo kakwet koorkēēnyii kubo ng'aleek alak chēē mānāmē keey ākoo martaayeet, kāākōōsākyi koorkoonoo kuyēk choonchooyēn. Nto chiito nyēē keemut koorkoonooto, kaakumarta ꞉nkinee.” ");
INSERT INTO spyNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kimwooy ꞉Yēēsu subak kule, “Kyookas ꞉akweek kule /kikēēmwoochi chiitaab kēny kule, ‘Yoo kēēwoolchi keey ꞉chii Yēyiin kule makuyey kiy, kumāmāchāktōōs kwiiri kiyooto nteenee māchāktōōs kootyiich.’ ");
INSERT INTO spyNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nto anii āmwoowook kule mātēbi ꞉chii kut koowaal keey. ‑Meewaal keey ꞉chii kutwēchē wōliin bo kibkōōnkōy kuuyu bāytooyiisyēē ꞉Yēyiin wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Āmātēbi ꞉chii kut kulē, ‘Kwaama ꞉teng'et’, kuuyu tyichē ꞉Yēyiin wōlooto. ‑Meewaalee keey ꞉chii kiriinkēētaab Yēērusālēēm kuuyu bo ꞉wōlooto Bāytooyiintēēt nyoo wōō. ");
INSERT INTO spyNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","‑'Meewaalee keey mbo mēting'uung' i-asante, kuuyu ‑mēēmuuchē mbo kut iyey buutyoontēēt akeenke ām mēting'uung' kulēēliit nto kutuuyiit. ");
INSERT INTO spyNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yoo 'kēēchāmē kiito ake, kuyēmē imwaay kule: ‘Ēē, wuu nyooto.’ Nto yoo itāyē, imwaay kule: ‘Acha, māwuu nyoo.’ Yoo 'keemwaay ng'al chēē siirē chuutēchu kukwoonēē ꞉choo wōlēē miitē ꞉Kibrōkōsyoontēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kitas taay ꞉Yēēsu kumwooy kule, “Kyookas mbo subak /kēēmwooyē kule, ‘Koong' āk koong', keelta āk keelta.’ ");
INSERT INTO spyNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nteenee āmwoowook ꞉anii kule, ‑mēēkōrōmchi chii nyēē miyaat. Yoo kasyeeching' ꞉chiito ake kibkermetuut komosta ake, iwēēkyi komosta nyiin ake kusyeech. ");
INSERT INTO spyNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nto yoo kākwēring' ꞉chii kōōk kumāchē kaansuung'uung', imuytoochi mbo nkinee kābuutiit. ");
INSERT INTO spyNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yoo kākērchiing' ꞉chii koong' ikālābchi tukuukyii ām asiista akeenke, itāsyi asiista ake. ");
INSERT INTO spyNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nto yoo kāsooming' ꞉chii kiito ake, ikoochi. Nto yoo kēēbēsēēniing' ꞉chii kiy, ikoochi.” ");
INSERT INTO spyNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kitas taay ꞉Yēēsu kumwooy kule, “Kyookas mbo subak /kēēmwooyē kule, ‘Ichāmē laatyeeng'uung' ānkiiwēchē buunyoontēēng'uung'!’ ");
INSERT INTO spyNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nteenee āmwoowook anii kule, ōchāmē buunikwook ānkōōsoochinē choo wusook ");
INSERT INTO spyNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","sookerkeyiitu Kōōn nyoo miitē kibkōōnkōy. Yēyē ꞉Yēyiin kōōluuchi ꞉asiisnyii biiko choo kāroomēch āk choo miyootēch. Yēyē mbo subak roobta kurōōbēnchi biiko choo kāroomēch āk choo miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ōbērē ꞉akweek tōōs mākutuwēnook ꞉Yēyiin yoo ōchāmē baateey biiko choo chāmook ee? Ntēē yēyē ꞉chii ake tukul kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nto yoo ōng'āloolchinē biiko choo chēēkwook baateey ii, ōnyōōru nee nyēē karaam? Ntēē yēyē ꞉nkicheek choo ‑mēēnkētē Yēyiin kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Churtaat ꞉Yēyiin nyoo miitē kibkōōnkōy, kunyoo, māchāktōōs ōchurtootiin ꞉nkakweek.” ");
INSERT INTO spyNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kimwooy subak ꞉Yēēsu kule, “Ōriib keey. Mayey ꞉chii ng'ālyoo nyēē karaam ām taayeetaab biiko kumāchē kule sukutook. Yoo kayey kuu nyooto, mānyōōru kiy ām wōlēē mii ꞉Kwaan nyoo miitē kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yoo 'kēētoorēt banan, ‑mēērook ing'asaatee keey kuu wōloo yēytooy ꞉kiblembechiisyek ām kooriikaab saayeet āk wōloo bo kēēltaab too, kule sukookaasta ꞉biiko. Kāāmwoowook, mānyōōru kiy ām wōlēē mii ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nteenee yoo iyēētyēēchinē chiito ake, kumāmāchāktōōs ikany kukas mbo ꞉choorweeng'uung'. ");
INSERT INTO spyNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yooto, mākutuwēniing' ꞉Kōōn nyoo kāsē kiy ake tukul nyēbo wung'aan.” ");
INSERT INTO spyNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kitas taay ꞉Yēēsu kumwooy kule, “Yoo ōsooyē, marub ꞉chii ātēbuutēkaab kiblembechiisyek. Kicham ꞉kiblembechiis kusooyē nyēē kātōōnōōn ām kooriikaab saayeet āk wōloo chaang' ꞉biich, sukung'eet kutook. Kāāmwoowook, kisimkunyōōr ꞉bichoo kiyēē kimāchē. ");
INSERT INTO spyNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nteenee, ikērtooy keey ꞉inyiing' kō ankiisaay Kōōn nyoo ‑/mākēēkāsē. Nto yooto mākutuwēniing' ꞉Kōōn nyoo kāsē kiy ake tukul nyēē wunyaat.” ");
INSERT INTO spyNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kitas taay ꞉Yēēsu kumwooy kule, “Yoo ōsooyē, ‑mōōbōloobōlē kuu biich choo ‑mēēnkētē Yēyiin kuuyu isōōtē ꞉choo kule yoo kāmwooy ng'al chēē chaang', /kēēkāsyinē. ");
INSERT INTO spyNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wuu nyooto kuuyu simkōōnkētē ꞉Kōōn kiyēē ‑mōōboontē kutoombo mbo kut osaay. ");
INSERT INTO spyNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kunyoo māchāktōōs ōsooyē kule: Baaba Yēyiin nyoo imiitē kibkōōnkōy, kutōrōriit ꞉kaayneeng'uung'. ");
INSERT INTO spyNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kuyit ꞉bāytooyiisyēēng'uung' kuyeyakay ām wōlēēb ng'wēny ꞉kiyēē imāchē kuu wōloo wuunto ām kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ikōōnēēch kiyēē kyoomē ām bēsyō ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Inyōōwēēch kaat ām choolwookātēēnyoo, kuu yoo kēēnyōōchinē ꞉nkacheek kaat choo choolwookēnchēēch. ");
INSERT INTO spyNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Itiiyēēch /simakeekenteech, nteenee isateeneech wōlēē mii ꞉Buunyoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yoo ōnyōōchinē kaat biiko alak choo choolwookēnchook, kunyōōwook kaat ꞉nkinee Kōōn nyoo mii kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nto yoo ‑mōōyēyē kuu nyooto kumānyōōwook kaat ꞉Kōōn.” ");
INSERT INTO spyNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kimwooy ꞉Yēēsu subak kule, “Yoo *kirē ꞉chii āmiisyēēt, kumāmāchāktōōs kusāng'utiitu kuu wōloo yēytooy ꞉kiblembechiisyechaa māchē kule sukukas ꞉biiko. !Kāāmwoowook, kiikunyōōr ꞉bichoo kuyem kiyēē kimāchē. ");
INSERT INTO spyNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nteenee yoo ōkirē āmiisyēēt, kumāchāktōōs ōbārē buutēēkwook, ōwuunē koonyekwook ankooyiil ōtililiitu ");
INSERT INTO spyNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","simēēnkētook ꞉chii kule ōkirē āmiisyēēt. Nteenee Kōōn nkityō nyoo ‑/mākēēkāsē ꞉nyēē inkētē. Nto yooto, mākutuwēniing'.” ");
INSERT INTO spyNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kitas taay ꞉Yēēsu kumwoochi biiko kule, “‑Mōōtukuulchi keey bāytitaab kōōrooni kuuyu nyēērēē ꞉kuutyek, tuurtōōs /ānkēēchōōrē. ");
INSERT INTO spyNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nteenee ōkōnōrchi keey bāytit ām Kaab Yēyiin wōloo māmiitē ꞉kiy nyēē nyēērēē āmāmii ꞉chōōriin. ");
INSERT INTO spyNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tiiyēē ꞉chii mēt wōloo miitē ꞉bāytinyii. ");
INSERT INTO spyNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Koong'uung' nyēē ikoochinē bōōrng'uung' lēbkēēyyēēt. Yoo kāstooy ꞉koong'uung' nyēē karaam, iboontē lēbkēēyyēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nto yoo mākāstooy nyēē karaam, imiitē mēēnān nyēē mā mining'. Kunyi, yoo kāmis ꞉lēbkēēyyēēt nyoo 'kēēboontē, imiitē mēēnānēēt kutukul! ");
INSERT INTO spyNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Māmii ꞉chii nyēē imuuchē kōōmēlchiin kirōkōōn āyēēng'. Yoo kasyeem, kulāyē ꞉ake. Kunyoo, mānoomtōōs ꞉yiisyēētaab Yēyiin āk muchastaab beesaan.” ");
INSERT INTO spyNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kitas taay ꞉Yēēsu kumwoochi bichoo kule, “Kunyoo, !kāāmwoowook, ‑mookany kwaamaak mēt kule ō-āmē nee, ōyyēē nee nto kule ōloochē nee. Wōō oob ꞉soboontaab chii kusiir āmit nto ku sirooy? ");
INSERT INTO spyNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Māchē ōkāsēē tāriitēk choo ‑mēēnkētē kule /kēēchoonsē kule nee /ānkēēkēsiisyē kule nee āmātinyē mbo chookēēn, nteenee bāyē ꞉Kōōn nyoo miitē kibkōōnkōy. Chāmook akweek oob ꞉Yēyiin kusiir tāriitēchoo? ");
INSERT INTO spyNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yoo keeyiimee keey ꞉chii ng'al chēbo kōōrooni ii, ara imuuchē ꞉yooto kutāsyi bēsyōōsyēk chēē minyēē kōōrēēt? ");
INSERT INTO spyNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ām nee sōōyiimēē keey ng'aleekaab sirooy? Okas baa, wōlēē wuu ꞉taabta ake tukul ām wuuyēēt! Māchiiryootē sukukaraaraniit. ");
INSERT INTO spyNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kāāmwoowook, ānkoo kiboonto ꞉Sōlōmōōn bāytit nyēē tyaa, kimāboonto sirooy chēē kāroorānēch kuu toobtōōchu. ");
INSERT INTO spyNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nto akweek chu ‑mōōkoosēēnoo keey kuyem ii, yoo imuuchē ꞉Yēyiin kookaraaran toobtōōy choo lēēltōōs nto nyēē mā tyaa kurarach ii, kucham nee wōlēē makoolaaktaak nkakweek? ");
INSERT INTO spyNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kunyoo ‑mooyiimee keey kule, ‘+Makyaam nee?’ Nto kule, ‘Kēēyyēē nee?’ Nto mbo kule, ‘Kiiloochē nee?’ ");
INSERT INTO spyNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Biiko choo ‑mēēnkētē Yēyiin ꞉chēē imoymooyē tukuuchoo tukul, nteenee inkētē ꞉Kōōn nyoo miitē kibkōōnkōy kule misyook akweek ōnyōōru tukuuchoo tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kuchamta ꞉chii kurook bāytooyiisyēētaab Yēyiin ākoo churtaayeet. Yooto, mākurōōrōōt ꞉tukuuk chuut alake. ");
INSERT INTO spyNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kunyoo, ‑mooyiimee keey ng'aleekaab tuun, kuuyu boonto ꞉bēsyēētaab tuun ng'aleekyii chēē mākubooryēē.” ");
INSERT INTO spyNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kitas taay ꞉Yēēsu kumwooy kule, “Masiming'alaalee chii nyēē miyaat. ");
INSERT INTO spyNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yoo 'keeng'alaalee chiito ake nyēē miyaat, ku +/makeeng'alaaleeniing' nkinyiing' kuu nyooto. Nto kiyoo 'kēēyēchi chiito ake, /kēēyēwuung' nkinyiing' kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ām nee siikāsē ꞉inyiing' sikitityaa nyēē miitē koong'taab ng'eetaabkoomēt ameekas musukyēēt nyēē miitē koong'ta nyeeng'uung'? ");
INSERT INTO spyNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Imuuchē kule nee imwoochi ng'eetaabkoomēt kule, ‘Kany ānēmuung' sikitityaa ām koong'ta,’ nto kutēē yooto tukul kumiitē ꞉musukyēēt koong'uung' nkityō? ");
INSERT INTO spyNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kiblembechaantaani! Māchāktōōs inēmu kurook musukyēēt nyoo mii koong'uung' nkityō siikaste kāroomin siinēmchi ng'eetaabkoomēt sikitityaanteet ām koong'nyii. ");
INSERT INTO spyNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‑Mēēkoochi ng'ōōk kiy nyēē churtaat kuuyu wēēkyiing' keey ankusankataniing', nto iwiirchi sanayeekuuk tōōrōōy kuuyu itārtoorē.” ");
INSERT INTO spyNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kitas taay ꞉Yēēsu kumwooy kule, “Yoo kēēsoom, /kēēkōōning', yoo kēēchēēng'sē, inyōōru, nto yoo kēēng'ēētiisyē, /kēēyootuung'. ");
INSERT INTO spyNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chiito nyoo soomsē, /kiikoochinē, nyoo chēēng'sē kunyōōru, nto nyoo ing'ēētiisyē, /kēēyootyinē. ");
INSERT INTO spyNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ara miitē ꞉chiito ām akweek nyēē yoo kāsoom ꞉lakwanyii mukaatiit kōōkoochinē rwaanteet? ");
INSERT INTO spyNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nto yoo kamach *burburyoontēēt, kōōkoochi eereeneet? ");
INSERT INTO spyNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kunyi, yoo chāmē ꞉biiko buch kōōkoochi lōkōkwaa tukuuk chēē kāroomēch ii, /keemwa nee nanyuun Yēyiin ām kibkōōnkōy? Mākōōnēm keey ꞉nyoo miisin kukōōn tukuuk chēē kāroomēch yoo kōōsoom!” ");
INSERT INTO spyNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kitas taay ꞉Yēēsu kumwooy kule, “Ōyēchinē biiko alak kuu wōloo kātōōmāchē ꞉akweek /kēēyēytoowook. Iyumē ꞉ng'aleechuutēchu kiruutēkaab *Muusa ākoo kāānēētēywēēkaab *wōōrkooyikaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kitas taay ꞉Yēēsu kumwooy kule, “Obeetee oreet nyoo mariich. Mii ꞉kēēlto nyēē baraay nyēē tinyē oreet nyēē baraay. Choong'ēch ꞉biiko chēē bēētēē kēēlooto wēētii ārbub. ");
INSERT INTO spyNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nteenee mii ꞉kēēlto nyēē keweel nyēē tinyē oreet nyēē mariich. Ng'ērinēch ꞉biiko chēē bēētēē kēēlooto tākyinē keey *soboontaab kibchuulyo.” ");
INSERT INTO spyNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kitas taay Yēēsu kumwooy kule, “Ōriibēē keey *wōōrkooyichoo mābo man choo iyēēloonunēē ruunkuun sumboot nteenee ām moonikwaa ku miyootēch kuu suuyiik. ");
INSERT INTO spyNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ōnkētēē bichoo ng'aleek chēē yēyē. Māyēyē ꞉cheebkateet mbuuniik āmāyēyē ꞉siikoowēēt lamayeek. ");
INSERT INTO spyNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mākyiintōōs keet ake tukul nyoo karaam kuyēyē lokoyeek chēē kāroomēch nto kēētit nyoo miyaat kuyēyē lokoyeek chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","‑Mēēmuuchē ꞉kēētit nyēē karaam kuyey lokoyeek chēē miyootēch āmēēbērē imuuchē ꞉kēētit nyēē miyaat kuyey lokoyeek chēē kāroomēch. ");
INSERT INTO spyNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nto keet ake tukul nyoo kāmāchāktōōs kuyey lokoyeek chēē kāroomēch āmēēbērē kayey, /kiiluulto /ānkēētōōrchi ma. ");
INSERT INTO spyNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kunyoo, ōnkētēē bichoo ng'aleek choo yēyē.” ");
INSERT INTO spyNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kutas taay ꞉Yēēsu kumwoochi rubiikyii kule, “‑Mēēwutē Kaab Yēyiin ꞉biiko tukul choo mwooyē kule, ‘Mokoryoontēēt, Mokoryoontēēt.’ Nteenee chēē iwutē baateey ku choo yēyē kiyēē mākyinē ꞉Baaba ām kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Choong'ēch ꞉biiko chēē mākumwoowoo ām bēsyēētaab tabanta kule, ‘Mokoryoontēēt, Mokoryoontēēt, ntēē kikyoomtēē lōkōōywēk kaayneeng'uung', kiibēbēētēē tāmirmirook chēē miyootēch ānkēēyēyē tukuuk chēē mātēē chu chēbo kwōng'uut!’ ");
INSERT INTO spyNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yooto +māāmwoochi ꞉anii bichoo kule, ‘Kibng'ōōkisiisyēchu, ‑māānkētook ꞉anii! Ōng'ēētyēē yu.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kutas taay ꞉Yēēsu kumwooy kule. “Chii ake tukul nyēē kakas ng'aleekyuu ankurub kukerkeey chii nyēē ng'oom nyēē kitēēkyi kōōnyii kitaweet. ");
INSERT INTO spyNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yoo kārōōbēn ꞉roobta kooyiin ꞉āynōōsyēk kutwoor keey ꞉bēēko ānkōōsoonkiiy ꞉wusōōnēēt kōyooto, māluulē ꞉kōyoo, kuuyu /kikēētēēkyi yēbo kitaweet. ");
INSERT INTO spyNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nto chii ake tukul nyoo kakas ng'aleekyuu amarub, kukerkeey chii nyēē berber nyēē kitēēkyi kōōnyii yēbo ng'aayneet. ");
INSERT INTO spyNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yoo kārōōbēn ꞉roobta, kooyiin ꞉āynōōsyēk kutwaarta ng'aayneet ānkōōsoonkiiy ꞉wusōōnēēt kōōtkēy, kuluulē ꞉kōōt!” ");
INSERT INTO spyNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yu keewaany ꞉Yēēsu kumwooy ng'aleechaa, koolat ꞉biiko ");
INSERT INTO spyNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kuuyu kimēēnēētiisyē kuu kāānēētikaab kiruutēk, nteenee kiinēētiisyē ām kāāmuukēywēēk. ");
INSERT INTO spyNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yu kārēkunēē ꞉Yēēsu lekem barak, kurub ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yooto kuchō ꞉chiito ake nyēē kiboonto makereen ānkukutunyēē taayeetaab Yēēsu ānkumwooy kule, “Mokoryoontēēt, yoo ichāmē, isooboo sāātililiitu kuuyu ānkētē kule imuuchē.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yooto nanyuun kuchuul ꞉Yēēsu āwunyii kutiiny chiichoo ānkumwooy kule, “Āchāmē, kunyi itililiitu!” Kusob ꞉chiichoo areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nto mii yoo kumwoochi ꞉Yēēsu chiichoo kule, “‑Mēētēbii kut imwoochi chii ng'aleechu, nteenee wēēboorchi keey kibkōrōs ānkiikoochi tukuuk chēē kabeelee kōrōsēēk kurub kuu yoo kimwooyē *꞉Muusa sukōōboor yooto kule 'kēētililiitu.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yu kayit ꞉Yēēsu Kaabernaam, kuchō ꞉chiito ake nyēē ki kāāntōōyiintēētaab lukēētaab booryēēt nyēbo Rooma ānkumwoochi Yēēsu kule, ");
INSERT INTO spyNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mokoryoontēēt, miitē ꞉motwooriintēēnyuu kaa kusubsubē ām kitiintiri.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kumwoochi ꞉Yēēsu chiichoo kule, “Imāchē āchōō anii kang'uung' chāāsoob?” ");
INSERT INTO spyNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Kuwālchi ꞉kāāntōōyiintoonoo Yēēsu kule, “Mokoryoontēēt, ānkētē anii kule māyēmāktōōs iwut ꞉inyiing' kōōng'waanii. Āmiitē ꞉anii ng'wēnyuutaab kāāmuukēywēēk ānkāābāytooy biikaab lukēēt. Yoo kāāmwoochi chii nyēē mii ng'wēnyuunyuu kule, ‘Wē’ kuwēētii, nto yoo kāāmwoochi ake kule, ‘Chōō’ kuchōōnii. Yoo kāāmwoochi motwooriintēēnyuu kule, ‘Yey kiy’ kuyēyē. Kunyoo, imwaay baateey ng'ālyoo, yooto mākusob ꞉motwooriintēēng'waanii.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yu kakas ꞉Yēēsu ng'aleekaab chiichoo, koolat ānkumwoochi bichoo kirubootē inee kule, “!Kāāmwoowook, kubooyiit man manaakas yēēt ake *Isrāyēēliin nyēē ikoosēēnoo keey kuu chiichi. ");
INSERT INTO spyNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kāālēēnchook makukwaanee ꞉biiko chēē chaang' koong'asiis āk tinkeey ānkubokwoomchiin ākoo *Abraam, Isaka ākoo Yāākōbō ām Kaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nteenee +/mākēētōōrchi mēēnān ꞉biiko choo bērē nyeeng'waa ꞉Yēyiin bokuriirunee ng'wēny.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yu keewaany ꞉Yēēsu kumwooy kuu nyooto, kumwoochi kāāntōōyiintoonoo kibo lukēēt kule, “Iyeey kaa. Kaakuyeyakay kuu wōloo 'kēēmāktooy kuuyu 'kēēkoosēēnoo keey.” Nto yooto bakeenke kusob ꞉motwooriintēētaab kāāntōōyiintoonoo. ");
INSERT INTO spyNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nto yu kāwo ꞉Yēēsu kaytaab Bētērō, kukas cheebyoosyeetaab biikooy nyēbo Bētērō kukāru ānkumnyoonē. ");
INSERT INTO spyNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yu kātiiny ꞉Yēēsu āwutaab cheebyoosyaanaa, kusob ānkubāyiis. ");
INSERT INTO spyNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nto miitē bēsyoonooto kosolēny kukararakta ꞉asiista, /kiimutyi Yēēsu biiko chēē chaang' chēē kiboonto tāmirmirook chēē miyootēch. Kyaankung'alaal ꞉Yēēsu, kung'ēētyēē ꞉tāmirmiroochoo biiko. Kiisoob mbo biiko tukul chēē kimnyoontōōs. ");
INSERT INTO spyNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kuyityiin ꞉yooto ākoo kiyoo kimwooyē *꞉wōōrkooyoontēētaab Yēyiin *Isaaya kule, “Kikālābwēēch nyāliluutēkyoo ānkōōmuuktoowēēch tānkuusyēēnyoo.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nto mii bēsyēēt ake, yu kēēruruukyi keey ꞉biiko Yēēsu, kumwoochi rubiikyii kule, “Okany kyaay tōōliilēēt keebe biitooniin.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nteenee kuchō ꞉kāānēētiintēēt ake nyēbo kiruutēk ānkumwoochi Yēēsu kule, “Kāānēētiintēēt, ārubiing' ꞉anii ānkoo 'kēēwē ānō.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kukētyi ꞉Yēēsu kule, “Boonto ꞉kimōkōyiinēk ng'wēēnoonik chēē minyē, kuboonto ꞉tāriitēk kooriikwaa, nteenee māboonto *꞉Wēritaab Chii wōlēē imuunyēē.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kumwoochi subak ꞉chiito ake Yēēsu kule, “Mokoryoontēēt, kany kut amuy baaba, nto ārubiing'.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nteenee kukētyi ꞉Yēēsu chiichoo kule, “Ikany kumuy keey ꞉muuswēk, ankiirubwaa.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yooto nanyuun, kulaany ꞉Yēēsu mwēēnkēēt āk rubiikyii ankuba. ");
INSERT INTO spyNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kumii tōōliil kwēēn, kuchō ꞉wusōōnēēt ānkōōsoonkiiy mwēēnkēēt. Yooto tukul kumii ꞉Yēēsu kāruchi keey. ");
INSERT INTO spyNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Koong'eet ꞉rubiik Yēēsu kule, “Mokoryoontēēt, ntēē kākēēbēku, sārwēēch!” ");
INSERT INTO spyNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kumwoochi ꞉Yēēsu kule, “Ntēē kōōmuuyē nyēē tēē nyi? Ākoo ‑mōōkoosēēnoo keey kuyem?” Kung'eet ānkōōburyoong'to wusōōnēēt ākoo bēēko. Yooto, kuteeman ꞉wusōōnēēt āk bēēko. ");
INSERT INTO spyNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Koolat ꞉rubiichoo ankuteebee keey kule, “Chii nee ꞉chiito nyi kāsyinē mbo ꞉wusōōnēēt āk bēy?” ");
INSERT INTO spyNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nto yu kāwokuyit ꞉Yēēsu biitēēt nyiin ake nyēbo tōōliilēēt ām rōōrōōkēētaab Kataara, kuchuwunee ꞉biiko alake āyēēnku kochonkoosyek chēē /kēēmuchinē biiko ānkutākyi keey Yēēsu. Kiboonto ꞉bichoo tāmirmirook chēē miyootēch ānkikōrkōrēch miisin nyēē kimāmii ꞉chii nyēē kiimuuchē kumur yooto. ");
INSERT INTO spyNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kubōlchi ꞉tāmirmiroochoo miyootēch Yēēsu kule, “Imāchēēnēēch nee ōō, Lakwataab Yēyiin? Kēēchōō cheenyaliileech acheek kutoombo kuyitu ꞉bēsyēēt nyoo /kiikeekwey?” ");
INSERT INTO spyNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kilēēkitēē yooto ꞉ākwootiitaab tōōrōōk chēē kyookēētē. ");
INSERT INTO spyNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kusoom ꞉tāmirmiroochoo miyootēch Yēēsu kule, “Yoo 'keekweteech, ikōōnēēch bokiiwut tōōrōōchuut.” ");
INSERT INTO spyNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kumwoochi ꞉Yēēsu kule, “Obe.” Kuchuwu ꞉tāmirmiroochoo miyootēch bakeenke ānkubokōōwutē tōōrōōchoo. Kōōwutē kuu nyooto, kōōtuultēē keey ꞉tōōrōōchoo tukul lekem kusoor tōōliil ānkubokutōōrchi keey āriit ānkubēk! ");
INSERT INTO spyNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kukāsē ꞉biiko chēē kyookooy tōōrōōchoo ng'aleechaa, kumwēyē ākoy kiriing' ānkwoomchinē biiko ng'aleekaab tōōrōōk āk chēbo bichoo kiboonto tāmirmirook chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kukāsē ꞉biikaab kiriinkoonoo ng'aleechaa, kung'ēētōōs ꞉tukul bokukas Yēēsu. Kunyōōru, kusaaysaay kule kung'eetee saang'waa. ");
INSERT INTO spyNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yooto kulaany ꞉Yēēsu mwēēng' ankwaay āk rubiikyii kooyeey Kaabernaam. ");
INSERT INTO spyNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kuyitē, /kiimutyi chiito ake nyēē kisōnkōchoot /kēēkālāboonunēē tiirbeet. Nto bērē kukas ꞉Yēēsu kule kiikoosēē keey ꞉bichooto inee, kumwoochi chiichoo kule, “Wēnyoo, kimkim, /kāākēēnyōōwuung' kaat ām choolwookātēēng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yooto, kumwoochi keey ꞉kāānēētikaab kiruutēk kule, “Kāākōōwuuytēē keey ꞉chiichi Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kōōnkēt ꞉Yēēsu kiyēē kimiitē kōōsōōtē ꞉bichoo ānkumwooy kule, “Ām nee yu ōsōōtēē moo ng'al chēē miyootēch? ");
INSERT INTO spyNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kuskus /kēēmwooy kule, ‘/Kāākēēnyōōwuung' kaat ng'ōōkiswookikuuk’ nto /kēēmwooy kule, ‘Ng'eet ānkiiwēēsyēt’? ");
INSERT INTO spyNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ōkāsē ra kule āboontē ꞉anii, *Wēritaab Chii, kāāmuukēywēēk ām kōōrooni chēē āmuuchēē ānyōōchi biiko kaat.” Yooto bakeenke kumwoochi chiichoo kisōnkōchoot kule, “Yyoony ankiinam tiirbeeng'uung', ānkiiwēēchi keey kaa.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kung'eet ꞉chiichooto kisōnkōchoot bakeenke ānkuwēēchi keey kaa. ");
INSERT INTO spyNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yu kakas ꞉biiko chēē kimii yooto ng'aleechaa, kumuuyo ānkusilto Yēyiin nyi kiikoochinē chii kāāmuukēy chēē wuu choo. ");
INSERT INTO spyNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yu katas taay ꞉Yēēsu āk baannyii, kukas chiito ake nyēē /kikēēkuurēē Mataayo kumii kēēbuur kēryō kōōruruuchē *syuuruut. Yooto, kumwoochi ꞉Yēēsu chiichoo kule, “Rubwaa.” Kung'ēētē bakeenke ānkurubē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nto yu miitē ꞉Yēēsu kwoomiisyē ām kaab Mataayo, kukwa ꞉kāāruruukikaab syuuruut chēē chaang' ākoo biiko alak chēē ‑/kimākiiriiku bokwoomiis āk Yēēsu kuboonto keey rubiikyii. ");
INSERT INTO spyNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nto yu kakas *꞉Farisaayeek kuu nyoo, kuteebee rubiikaab Yēēsu kule, “Ntēē āmiisyē ꞉kāānēētiintēēng'woong' āk kāāruruukikaab syuuruut ākoo biich chēē ‑/mākiiriiku?” ");
INSERT INTO spyNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kukētyi ꞉Yēēsu kule, “Chēēng'ootē ꞉biiko choo imnyoontōōs kāānyooyiintēēt. Māchēēng'ootē ꞉choo sobchootiin. ");
INSERT INTO spyNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ibooru nee ꞉ng'aleechu /kikeesir: ‘Ākāykooyē chamateet kusiir kōrōsēēk.’ Kyāāchōōnchinē ꞉anii biiko choo choolwookēnootiin, āmēēbērē choo isōōtē kule churtootiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kimii ꞉yēē kikwa ꞉rubiikaab Yoowaana ankuteebee Yēēsu kule, “Ām nee yu kēēkirē ꞉acheek āk *Farisaayeek āmiisyēēt āmākirē ꞉rubiikuuk?” ");
INSERT INTO spyNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kukētyi ꞉Yēēsu kule, “‑Mēērukuutē keey ꞉chōōrōōnuutēkaab saanteetaab leekwa ām saakweetaab kooyēēy yoo boonto keey saanteetaab leekwa. Makuyit ꞉bēsyēēt nyēē +/mākiinēmunēē saantaanaa wōlēē mii chōōrōōnuutēkyii, kunyi yooto ꞉yēē makoorukuut keey ꞉chōōrōōnuutēkyii.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kitas taay ꞉Yēēsu kumwooy kule, “‑/Mākēētilē ankeet nyēē tākulēēl /ānkēēkinēē sireet nyēē yoos. Yoo /kakeeyey kuu nyooto kusirinyāktōōs ꞉ankaanaa ānkung'ēti yooto kubarayiit ꞉koong'ta miisin. ");
INSERT INTO spyNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","‑/Mākēēroonkyinē mbo kibkeetiis choo /kātākēēyēyē wōōnkit nyēē yoos. Yoo /kakeeyey kuu nyooto, kōōtōlē ꞉wōōnkit kuwasta keey ꞉kibkeetiisyek. Nteenee /kēēroonkyinē kibkeetiisyek choo /kātākēēyēyē wōōnkit nyēē lēēl, nto yooto kumoomē ꞉kiy tukuuchoo ꞉tukwaay.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kutākung'āloolē ꞉Yēēsu, kuchō ꞉kāāntōōyiintēēt ake ānkukutunyēē taayeenyii ānkumwooy kule, “Kaakume ꞉chēēbnyuu! Ichōō chēētiinyēē āwung'uung' sukusob.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yooto, kuwēēto keey ꞉Yēēsu chiichoo kuboonto keey rubiikyii. ");
INSERT INTO spyNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kirubaat lēt Yēēsu ꞉cheebyoosyeet ake nyēē kikiikunam bōōrto ake nyēē kisāyē ꞉korotiik ām kēnyiisyēk taman āk āyēēng'. Yu kāākuriikyi Yēēsu, kutiiny *maaseekaab kotootyēētaab sireetaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kiisōōtoonu ꞉cheebyoosyaanaa kule, “Yoo kāātiiny buch sireenyii āsobē.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yooto kuweech keey ꞉Yēēsu kukas cheebyoosyeetkēy ānkumwoochi kule, “Chēē, kimkim! /Kāākiisoobiing' kuuyu 'ikoosēēnoo keey.” Kisob ꞉cheebyoosyaanaa bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nto yu kēēwut ꞉Yēēsu kōōtaab kāāntōōyiintoonoo kunyōōr biiko chēē chaang' chēē kimēēysē. Kikuutē ꞉alake kurēēruunēk, kōōnchōōytōōs ꞉chuut. ");
INSERT INTO spyNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kumwoochi bichoo kule, “Obe saang'. Manaame ꞉chēēbi nteenee kāruchi keey.” Kuroorichi ꞉bichoo Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nto yu kaakuba ꞉bichoo saang', kuwo ꞉Yēēsu kisēēnkēētaab lakwanaa, kunam āwut ankoong'eet kōōyyo. ");
INSERT INTO spyNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kiyestee ꞉ng'aleechaa yēēmoonoo tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nto yu kang'eetee ꞉Yēēsu yooto, kurub lēt ꞉cheebkoraatiisyek alake āyēēnku. Kikuurchinootē ꞉bichoo barak kumwooyē kule, “Iriireeneech ōō, *Mōchōkōrēētaab Tāwuti.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nto yu kāwokōōwut ꞉Yēēsu kō, kuba ꞉nkicheek cheebkoraatiisyechaa kō. Yooto kuteebee ꞉Yēēsu icheek kule, “Ara ōyēnchinē kule āmuuchē ꞉anii āsoobook?” Kuwālchi kule, “Kiiyēnchinē ōō, Mokoryoontēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kutabtab ꞉Yēēsu koonyekwaa ānkumwoochi kule, “Kuu yoo kōōkoosēēnoo keey, kuyeyakay kuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kukās ꞉cheebkoraatiisyechaa. Yooto nanyuun, kōōkāloonchi ꞉Yēēsu bichoo kule, “‑Mābōōmwoochi chii ake tukul ng'aleechu.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ānkoo kuwuu nyooto, kibokumwaaytaat ꞉bichoo ng'aleechaa kiyēyē ꞉Yēēsu kuyem kōōroonooto kumukuul. ");
INSERT INTO spyNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nto yu miitē kubēēchinē keey ꞉mbo Yēēsu, /kiimutyi Yēēsu chiito ake nyēē kiboonto *tāmirmiryēēt nyēē miyaat. Kikiyey ꞉tāmirmiryoonoo chiichoo kukwiilakay ꞉ng'elyeb nyēē ‑mēēmuuchē kung'alaal. ");
INSERT INTO spyNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nto yu /kākiibēbēēto tāmirmiryoonoo miyaat kung'eetee chiichoo, kootyaak ꞉ng'elyebta kung'alaal ꞉chiichooto. Kiilat ꞉bichoo kimiitē yooto kumwooyē kule, “Yyē! Manaakeekas bēsyēēt ake ng'ālyoo nyēē tēē nyi ām *Isrāyēēl.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nteenee kumwooy *꞉Farisaayeek kule, “Yyōōch! Yēyiisyēē ꞉chiichi bāytooyiintēētaab tāmirmirook chēē miyootēch sukōōbēbēēto tāmirmirook chuut.” ");
INSERT INTO spyNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kiwēēsyētēē ꞉Yēēsu kiriinkōōsyēk āk soong'wēk tukul. Kiinēētiisyootēē kooriikaab saayeet kwoomtootē lōkōōywēk chēē kāroomēch kurubta keey āk bāytooyiisyēētaab Yēyiin ānkōōsoobē biiko chēē kiboonto bōōrwoonik chēē makerkeey āk tānkuusyo ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nto yu kakas ꞉Yēēsu biiko chēē chaang', kukāsyi kiisayta kuuyu /kikiisomsoomē ānkunyāliltōōs kuu kēēchiir chēē kābotyi ꞉ākiintō. ");
INSERT INTO spyNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yooto, kumwoochi rubiikyii kule, “Wōō ꞉kēsiisyēēt, nteenee ng'ēri ꞉kēsiik. ");
INSERT INTO spyNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kunyoo, ōsoom kutās ꞉Chiitaab yiisyēēt kēsiik alak.” ");
INSERT INTO spyNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kikuur ꞉Yēēsu rubiikyii taman āk āyēēng' ānkōōkoochi kāāmuukēywēēk kōōbēbēētooy tāmirmirook chēē miyootēch ānkōōsoobē biiko choo tinyē bōōrwoon alak tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Lēbkēēyichooto ku chu: Simōōni (nyoo kaayneenyii ake ku Bētērō), ng'eetaabkaamet Antereeya, Yāākōbō araab Sebetaayo kuboonto keey ng'eetaabkaamet Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibō ākoo Baatolomaayo, Toomaas ākoo Mataayo kāāruruukiintoonoo kibo *syuuruut, Yāākōbō araab Alfaayo ākoo Taataayo, ");
INSERT INTO spyNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simōōni Kananaayo ākoo Yuuta Iskaryoot nyoo kichokuchoomtooy Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yooto, kumwoochi kule, “‑Moobe wōlēē miitē ꞉biiko choo mā Yuutayeek āmōōwut kiriinkēēt ake tukul nyēbo biikaab *Samaaryaa, ");
INSERT INTO spyNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","nteenee obe wōlēē miitē ꞉biikaab Isrāyēēl choo kiikubootyo kuu kēēchiir. ");
INSERT INTO spyNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ō-āmtootē kule, ‘Kaakuyit ꞉bāytooyiisyēētaab Yēyiin.’ ");
INSERT INTO spyNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ōsoobootē choo mnyoontōōs, ōng'ēētootēē meet choo kiikubēk, ōsoobē choo boonto *makereenik, ānkōōbēbēētootē tāmirmirook chēē miyootēch. /Kākēēkōōnook kāāmuukēywēēchu buch, kunyi ōkooytooy ꞉nkakweek buch. ");
INSERT INTO spyNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Manamaat ꞉chii *ta-aabuut mbo kisich, *feetaanik nto ku beesaan alak tukul ām mbisinyeenyii. ");
INSERT INTO spyNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Manam mbo lool nto ku sira nyēē iliiktēē keey, kwēyōōn nto mbo kirōk, kuuyu yēmē chii nyoo kāākubirto nkuruukyii /kēēkwēchi kiy. ");
INSERT INTO spyNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yoo kōōwut kiriing' nto ku saang'ta ake tukul, ocheeng' kaytaab chii nyēē sikēn ānkōōbuur kayaata ākoy yoo ōbēēchinē keey. ");
INSERT INTO spyNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yoo kōōwut kaab chii, ōsoomchi bērur. ");
INSERT INTO spyNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nto yoo nyoolchinē /kiibēruur, kunyōōr kaalyeet. Nto yoo mānyoolchinē /kiibēruur, kutēbi. ");
INSERT INTO spyNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yoo kamataachaak ꞉chii nto kumakas ng'aleekwook, olelekte tēērtit ām kērēēnkōōkwook yoo ōng'ēētyēē kayaata nto kiriinkoonooto kōōboorchi kule tākōōbuurtooy ng'ōōkisng'waa. ");
INSERT INTO spyNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Lēyyē, !kāāmwoowook, +/mākiing'woonchi bichoo bo kiriinkoonooto miisin kusiir ng'wooninto nyēē nyōōru ꞉biikaab Komoora āk Sōtōm bēsyoonoo itiilchinē ꞉Yēyiin ng'aleek biiko ām kōōrēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kitas taay ꞉Yēēsu kumwooy kule, “Āyooktook ꞉anii bōōyēyiisyootē okerkeeye kēēchiir chēē miitē suuyiik kwēēn. Kunyoo ōkāsu ānkōōyibē keey ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ōriib keey, kuuyu mākōōyyoong'tēēnook ꞉biiko kōōk ānkubirook ām wōloo bo kooriikwaa bo saayeet. ");
INSERT INTO spyNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","+/Makiimutaak taayeetaab bāytooyik kubo anii. Okany kuyēk ꞉nyooto bārooyinto nyēē kōōmwoochinēē bichooto ākoo choo mā Yuutayeek kiyēē ōyēnchinē. ");
INSERT INTO spyNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","‑Mookany kooyiimaak mētēwoy ꞉kiyēē ōmwooyē nto wōlēē ōmwooytooy kiyooto. +/Mākiiboorwook yooto kiyēē ōmwooyē ");
INSERT INTO spyNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","kuuyu mēēbērē akweek ꞉chēē +mōōng'āloolē, nteenee Tāmirmiryēētaab Baaba ꞉nyēē mākung'āloolē kubuntēēnook. ");
INSERT INTO spyNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Makuchaamta ꞉chii ng'eetaabkaamet /keebakach, kuchaamta ꞉chii lakwanyii ānkuwēēkyi keey ꞉lēēkōōk sikiikwaa kuyey /keebakach. ");
INSERT INTO spyNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mākuwēchook ꞉biiko kubo anii. Nteenee chiito nyoo kamuyta ankookaaseenaa keey ākoy tabanta, +/makiiraraach. ");
INSERT INTO spyNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yoo /kākēēwusēēnook *kiriinkēēt ake, ōmwēchi ake. !Kāāmwoowook, ‑mōōmuutu kiriinkōōsyēkaab Isrāyēēl tukul kumānāāyitu *꞉Wēritaab Chii.” ");
INSERT INTO spyNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kitas taay ꞉Yēēsu kumwooy kule, “Mā wōō ꞉rubiintēēt kusiir kāānēētiintēēnyii āmā wōō ꞉motwooriintō kusiir mokoryoontēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nyoolchinē /kēēyēchi rubiintēēt kiyēē /kēēyēchinē kāāntōōyiintēēnyii, ānku ākoy /kēēyēchi motwooriin kiyēē /kēēyēchinē mokoryoontēēnyii. Yoo /kēēkuurēēnoo anii *Bēēlsēbuul ānkāāyēku chiitaab kayta ii, kucham nee biiko choo mii kanyuu? ");
INSERT INTO spyNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‑Mōōmuyēē choo wusook. +/Makeeng'aany kiy ake tukul nyēē iyēēnoot ānku +/mākiiboor kiy ake tukul nyēē wunyaat. ");
INSERT INTO spyNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ōbāroostooy ng'aleechu ā-āmwook kumākāsē ꞉chii /keekas kāroomin. Nto kiyēē /kēēchoomwook, ōkuurtē kukas ꞉biiko tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","‑Mōōmuyēē choo bākāchē bōōrto āmēēmuuchē kubakach tāmirmiryēēt. Nteenee ōmuyēē nyoo imuuchē koo-armuusee bōōrto āk tāmirmiryēēt maataab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","/Kyooltēē oob kootiitiiyēēnik āyēēng' beesaan chēē mābo laat? Ānkoo kuwuu nyooto, ‑mēēsuuwu mbo ꞉akeenke yoo manaacham ꞉Baaba Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ntēē inkētē mbo ꞉Yēyiin wōlēē tēē ꞉buutēēk ām mētitaab chiito. ");
INSERT INTO spyNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kunyoo, ‑mōōmuuyē, kuuyu chāmook akweek ꞉Yēyiin miisin kusiir kootiitiiyēēn chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Chii nyoo kachamta ām taayeetaab biiko kule chāmoo, +maachamte ꞉nkanii chiichooto ām taayeetaab Baaba. ");
INSERT INTO spyNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nto nyoo katayeenaa taayeetaab biiko, +maatayee ꞉nkanii taayeetaab Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kitas taay ꞉Yēēsu kumwoochi rubiikyii kule, “‑Moosoot kule kyāāchōōntooy ꞉anii tāloosyēēt kōōrēēt, nteenee kyāāyibu ng'ot, ");
INSERT INTO spyNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","kuuyu kichāāwuulyē biiko. Tooytōōs ꞉wēēro ākoo kwaan, kutooyo ꞉chēēbto āk kaamet ānkutooyo ꞉koorkēētaab wēēriit ākoo cheebyoosyeetaab biikooy. ");
INSERT INTO spyNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mākuwēchē keey ꞉biich chēē tilyōōnuut. ");
INSERT INTO spyNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Chii nyoo chāmē kwaan nto kaamet kusiir wōlēē chāmtoo anii, māyēmē ꞉nyoo kuyēk rubiintēēnyuu. Nto nyoo chāmē wērinyii nto ku chēēbnyii kusiir wōlēē chāmtoo anii, māyēmē ꞉nkinee kuyēk rubiintēēnyuu. ");
INSERT INTO spyNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nto chii nyoo kamachamta soboonnyii kubo anii sukuruba, māyēmē ꞉nkinee kuyēk rubiintēēnyuu. ");
INSERT INTO spyNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nyoo kāyēētyi keey soboontaab kōōrooni, mākōōboot soboonnyii bo kibchuulyo. Nto nyoo kēēkooyto soboonnyii ām kōōrooni kubo anii, mākunyōōr *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Chiito nyoo kataachaak kaakutaacha nkanii, nto nyoo kataacha anii kaakutaach Yēyiin nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Chii nyoo tōrōōchē *wōōrkooyoontēētaab Yēyiin kuuyu wōōrkooyoo, kunyōōru kiyēē /kēētuwēnēē wōōrkooyoontēēt. Nto chii nyoo tōrōōchē chiito nyoo churtaat kuuyu churtaat kunyōōru kiyēē /kēētuwēnēē ꞉chiichooto churtaat. ");
INSERT INTO spyNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kāāmwoowook, chii nyoo kārāmchi mbo bēy rubiintēēnyuu ānkoo kumātookunoot ꞉rubiintoonoo, +/mākēētuwēn chiichoo.” ");
INSERT INTO spyNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yu keewaany ꞉Yēēsu kumwoochi rubiikyii taman āk āyēēng' ng'aleechaa, kung'eetee yooto ānkuwokōōnēētiisyoot kwaamtaat lōkōōywēk ām kiriinkōōsyēkaab wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Yu kakas ꞉Bātisāniintēēt Yoowaana nyēē kirataat ng'aleek chēē kimii kuyēyē *꞉Kāārārookiintēēt, kumwoochi rubiikyii āyēēng' kule, “Obe wōlēē mii ꞉Yēēsu ankooteebee yoo inee man ꞉Kāārārookiintēēt nyoo /kōkēēbērē mākuchō, nto tākumii ꞉ake nyēē kēēkānyoonu.” ");
INSERT INTO spyNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yu /kabokeeteebee Yēēsu kuu nyooto, kuwālchi rubiichoo kule, “Oyeey ānkubōōmwoochi Yoowaana kiyēē kookas. ");
INSERT INTO spyNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kāstooy ra ꞉cheebkoraatiisyek, bēēsyētē ra ꞉choo kisōnkōchootiin, kōōkusobcho ꞉choo bo makereenik, kāsē ra ꞉cheemiinyiisyek ng'aleek, /kookiing'eetee meet choo kikiikuba *kāābkwoombiich /ānkōōkyoomchi mbo nkicheek bānoonik lōkōōywēk chēē kāroomēch. ");
INSERT INTO spyNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kunyi, bōōkiimchi Yoowaana kule ibēruuroot ꞉chii ake tukul nyoo mānēētuukyoo batay.” ");
INSERT INTO spyNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yu kāākubēēchi keey ꞉rubiichoo kiiyooktooy ꞉Yoowaana, kumwoochi ꞉Yēēsu biiko kule, “Kyōōbēētii bōōkāsē nee ām kōōr nyēē suurkwēēn? Ara ki tōōywoo nyēē kiimuuchē kōōsooyēn ꞉yoomat yoo kāwus? ");
INSERT INTO spyNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ara ki chii nyēē kikiilaach sirooy chēē kāroorānēch? Acha, /kēēnyōōrchinē chēē iloochē sirooy chēbo barak kaab bāytooyik. ");
INSERT INTO spyNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ara kyōōbēētii bōōkāsē ng'oo nanyuun? Ara ki *wōōrkooyoontēētaab Yēyiin ꞉nyi kibōōnyōōru? Kubooyiit man, kyōōnyōōru wōōrkooyoontēēt nyēē wōō kusiir wōōrkooyoo ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Inee ꞉nyoo ng'āloolēē ꞉Yēyiin ām yoo /kikeesir kule, ‘+Māāyooktē kiiyookiintēēnyuu koonto wokuyēytoowuung' kēēlto.’ ");
INSERT INTO spyNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","!Kāāmwoowook, māmii ꞉chii kōōrooni nyēē wōō kusiir Yoowaana, nteenee wōō ꞉nyoo mātookunoot nyēbo laat ām bāytooyiisyēētaab Yēyiin kusiir inee.” ");
INSERT INTO spyNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kitas taay ꞉Yēēsu kumwooy kule, “Nto kuchakee yoo kitoowu ꞉Bātisāniintēēt Yoowaana kwoomtooy lōkōōywēk ākoy kura, kiyōōt ꞉bāytooyiisyēētaab Yēyiin ām wusiisyēēt ānkusyēēmē ꞉biiko chēbo wōōrōōryēēt kōōsōrto. ");
INSERT INTO spyNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","King'alaalee ng'aleechu *꞉wōōrkooyik tukul ākoo siruutēkaab *Muusa ākoy mbo nkinee Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nto yoo ōmuuchē ōyēnchi, inee ku *Eliiya nyoo /kikēēng'āloolē kule mākuchō. ");
INSERT INTO spyNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nyoo yēbē yiit kukas. ");
INSERT INTO spyNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kunyoo, +maakerkeeyee nee biich chēē wuu chu? Kerkeey lēēkōōy chēē mii wōlēē chaang' ꞉biich āmāchāmē ng'aleekaab chuut yoo /kēēkuurchinē kule, ");
INSERT INTO spyNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Yoo kakeekuutwaak kurēēruut ‑mōōtuumē, kēēlē kēēriiryē, otay ōmēēysē.’ ");
INSERT INTO spyNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wuu nyooto wōlēē kiyibto ꞉biiko Yoowaana āk anii. Kimoomē ꞉Yoowaana āmit chēbo leles nto kuyyēē *tifaayiin. Yooto /kēēmwooy kule, ‘Boonto *tāmirmiryēēt nyēē miyaat.’ ");
INSERT INTO spyNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kuchō *꞉Wēritaab Chii nyēē kyoomiis ānkuyyēē tifaayiik /kēēlē, ‘Kimooroong'nyaa, kibōōkityoo ānku choorweetaab kāāruruukikaab *syuuruut āk biich choo ‑/mākiiriiku.’ Nteenee inkētē ꞉chii kiyēē yibu ꞉ng'oomnān yoo karub kāānēētēywēēkyuu.” ");
INSERT INTO spyNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yooto kung'alaalee ꞉Yēēsu nyēē miyaat kiriinkōōsyēk choo mēēbērē kiweeksee miyootyēēt ānkoo kikiikuyeyee ꞉inee wōlooto ng'al chēbo kwōng'uut. ");
INSERT INTO spyNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kimwooyē kule, “Wuusyō, wēē, kiriinkoonēēb Koorasiin āk Beetsaayta! Tyaa, ꞉ng'woonin nyēē mii kukānyoonwook akweek choo kyookas ng'al chēbo nkoolat choo kyāāyēyē. Nto ki biikaab Tiirō nto ku chēbo Sitōōn chēē kyāāyēchinē ng'aleechu bo nkoolat, nto kiiloochē sirookaab mēēysō ānkōōbuurēē aryaanteet kōōboor kule kaakuweeksee miyootyēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kiriinkōōsyēchu, !kāāmwoowook, mākunyōōr ꞉biikwook ng'wooninto nyēē siirē nyoo nyōōru ꞉biikaab Tiirō ākoo Sitōōn bēsyoonoo itiilchinē ꞉Yēyiin biiko ng'aleek. ");
INSERT INTO spyNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Biikaab Kaabernaam, ōbērē ꞉nkakweek +moobe kibkōōnkōy? Achicha, ōbēētii kāābkwoombiich! Nto /kikikeeyeyee Sōtōm ng'al chēbo nkoolat, choo /kikēēyēwook akweek, nto manaakarbus. ");
INSERT INTO spyNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","!Kāāmwoowook, ōnyōōru ꞉akweek biikaab Kaabernaam ng'woonin nyēē siirē nyoo mākunyōōr ꞉biikaab Sōtōm bēsyoonoo itiilchinē ꞉Yēyiin biiko ng'al.” ");
INSERT INTO spyNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nto miitē yoo, kumwooy ꞉Yēēsu kule, “Āsiltiing' inyiing' Baaba Yēyiin, nyoo ibāwu barak āk ng'wēny, kuuyu 'kwēēboorchi biiko choo yibē keey ng'wēny kiyēē iwunyēē biiko choo isōōtē kule ng'oomēch. ");
INSERT INTO spyNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kōōnkōy, Baaba, kuuyu wuu nyooto ꞉wōlēē imāktooy ꞉inyiing'. ");
INSERT INTO spyNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kikōōno ꞉Baaba kiy ake tukul nyēē āboontē. Baaba nkit ꞉nyēē inkētē wōlēē āwuuyē ꞉anii, āmēēbērē mii subak ꞉chii nyēē inkētē wōlēē wuu ꞉Baaba, nteenee lakwanyii nkit ākoo biiko choo kyaakwey āboorchi.” ");
INSERT INTO spyNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kitas taay ꞉Yēēsu kumwooy kule, “Okwaa wōlēē āmiitē ꞉anii akweek tukul choo ōchoosyootiin ānkōōng'irook ꞉tukun sāāmuung'wook. ");
INSERT INTO spyNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Āyēku tala ānkāāyibē keey ng'wēny. Kunyi, ōrookēē keey muchōōkiinyuu ankookany aneetaak. Yoo kooyey kuu nyooto, +mōōmuung'iisyē. ");
INSERT INTO spyNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mānyikisyinē biich ꞉muchōōkiinyuu ānku kuskus ꞉yiisyēēnyuu.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nto mii bēsyēēt ake yēē ki *Sabaato, kumur ꞉Yēēsu ākoo rubiikyii mbareet ake nyēē kibo nkoonuuk. Kyoomootiin rubiikyii ꞉kēmēy yooto, kutoow kuswech mētēwookaab nkoonuuk ankwaam. ");
INSERT INTO spyNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nto bērē kukas *꞉Farisaayeek kuu nyoo, kumwoochi Yēēsu kule, “Kas, ntēē miitē ꞉rubiikuuk kwiiryēē kiruutyēēt nyoo māchāmu /kēēkēsiis yēē bēsyēētaab Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kukētyi ꞉Yēēsu kule, “Manoosuman ꞉akweek, kiyēē kiyey ꞉Bāytooyiintēēt Tāwuti yoo kyoomē ꞉kēmēwuut ākoo lukēēnyii? ");
INSERT INTO spyNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kiwo *Kōōtaab Yēyiin /ānkiikoochi mukaatiinek choo /kikēēchāmchinē mbo *kibkōrōs nkit kwaam. Kyaam ꞉Tāwuti mukaatiinechaa ānkōōkoochi nkicheek biikaab lukēēnyii kwaam. ");
INSERT INTO spyNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nto mbo subak ii, manoosuman ꞉akweek ām siruutēkaab *Muusa kule iryēē kiruutēk ꞉mbo kibkōrōs yoo yēyiisyēē Kōōtaab Yēyiin ām bēsyēētaab *Sabaato ‑/āmākēēyibē kule kaleel? ");
INSERT INTO spyNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","!Kāāmwoowook, miitē yu ꞉chii nyēē wōō kubiir Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nto ōnkētē kiyēē kiibooru ꞉Yēyiin yoo kimwooyē ām siruutēk kule, ‘Ākāykooyē chamateet kusiir kōrōsēēk,’ nto kāmōōng'āloolēē nyēē miyaat biich chēē māboonto lēēlis. ");
INSERT INTO spyNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bāwu *꞉Wēritaab Chii bēsyēētaab Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kutas taay ꞉Yēēsu ākoo rubiikyii ākoy kōōto ake nyēbo saayeet. ");
INSERT INTO spyNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kimiitē kōyooto ꞉chiito ake nyēē kisōnkōchoot ꞉āwut. Yooto kuteebee *꞉Farisaayeek chēē kimii kōyooto Yēēsu kule, “Ara chāmwēēch ꞉kiruutēk /kiisoobso yēē bēsyēētaab *Sabaato?” Kitēēbē ꞉bichoo kuu nyooto kutēchē Yēēsu subokōōyyoong'tēē kōōk. ");
INSERT INTO spyNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yooto kumwoochi ꞉Yēēsu bichoo kule, “Yoo boonto ꞉chii ām akweek kēēchiiryēēnyii ānkōōsuuchi ꞉kēēchiiryoonoo ng'wēēn yēē bēsyēētaab Sabaato, ichuutu oob bakeenke ām ng'wēēn? ");
INSERT INTO spyNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bo koomānuut ꞉chii miisin kusiir kēēchiir. Kunyoo, chāmwēēch ꞉kiruutēk keeyey kiy nyēē karaam bēsyēētaab Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yu keewaany Yēēsu kumwooy ng'aleechaa, kumwoochi chiichoo kisōnkōchoot ꞉āwut kule, “Chuul āwut.” Yu kachuul, kukaramiit kuu nyiin ake. ");
INSERT INTO spyNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kukāsē ꞉Farisaayeechaa kuu nyooto, kuchuytooy saang' ānkubokuyēchinē Yēēsu ruurumuut koowaang'ta. ");
INSERT INTO spyNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nto yu kēēnkēt ꞉Yēēsu ng'aleek chēē kimii ꞉bichoo kuchōbē, kung'eetee yooto. Kirub ꞉biiko chēē chaang' Yēēsu ānkōōsooboot bōōrwoonik chēē kiboonto ꞉biiko wōlēē wōō. ");
INSERT INTO spyNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nto yooto kōōkāloonchi ꞉Yēēsu bichooto, kumāmwoochi chii kiy kurubta keey āk ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kiyityiin ꞉yooto āk yoo kimwooyē ꞉Yēyiin kubununēē wōōrkooyoontēēt *Isaaya kule, ");
INSERT INTO spyNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Chiinyuu nyēbo yiisyēēt ꞉nyi nyēē kyaakwey. Āchāmē ānkāāng'ērēkyinē. +Māāng'oobchi Tāmirmiryēēnyuu ānku inee ꞉nyēē mākuyibchi bōrōryōōsyēk tukul manta. ");
INSERT INTO spyNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mēēbērē mākuwookuutyēē chii nto kubōloot, āmēēbērē /mākēēkāsyi kēēltaab too kubōlootē. ");
INSERT INTO spyNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mākoy kwiiri tōōywoo nyēē ng'asng'as, nto kōōmiis nōmōryoo nyēē meeymeeyaat, ākoy kukas kule kēēbēliis ꞉manta. ");
INSERT INTO spyNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mākōōkoosēē keey inee ꞉biiko tukul ām kōōrēēt kumukuul.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nto mii yoo /kiimutyi Yēēsu chiito ake nyēē kiboonto tāmirmirook chēē miyootēch ankukoraat āmēēmuuchē kung'alaal. Yooto kōōsoob ꞉Yēēsu chiichoo kukasta ankootyaak kung'alaal. ");
INSERT INTO spyNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yu kakas ꞉biiko tukul chēē kimii yooto kiyēē kiyeyakay, kumuuyo miisin ānkumwooy kule, “Ara *Kāārārookiintēēt ꞉chiichi nyoo kōkēēkānyoonu?” ");
INSERT INTO spyNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nteenee yu kakas *꞉Farisaayeek ng'aleechaa, kumwooy kule, “Māwuu nyoo, ntēē yēyiisyēē ꞉chiichi *Bēēlsēbuul nyoo bāytooyiintēētaab tāmirmiroochooto yoo ibēbēētooy tāmirmiroochu miyootēch.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kuuyu kiinkētē ꞉Yēēsu kiyēē kiisōōtē ꞉bichoo, kumwooy kule, “Yoo kaakubar keey ꞉lukēētaab booryēēt nyēbo kōōrēēt ake, kuburyētē ꞉kōōroonoo. Nto yoo kaakukwiil keey ꞉nkinee mbo kiriing' nto ku kayta ake, kuburyētē. ");
INSERT INTO spyNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kunyi, yoo ākoo miitē ꞉Kibrōkōsyoontēēt kubooryēē keey nkit ii, kōōyyoonyē man ꞉bāytooyiisyēēnyii? ");
INSERT INTO spyNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nto yoo āyēyiisyēē ꞉anii *Bēēlsēbuul ābēbēētēē tāmirmirook chēē miyootēch, kuyēyiisyēē ng'oo ꞉rubiikwook yoo ibēbēētooy tāmirmirook chēē miyootēch? Oteebee, baa, akweek kumwooy chēbo man. ");
INSERT INTO spyNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nteenee yoo āyēyiisyēē Tāmirmiryēētaab Yēyiin ābēbēētooy tāmirmirook chēē miyootēch kōōbooru kule kōōkuyityook ꞉bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nto subak ii, imuuchāksē kule nee kutur ꞉chiito ake kaytaab murēnēēt ake nyēē tinyē nkuruuk ānkōōnēm tukuukaab chiichooto? Yoo kamarat chiitaab kayta, māturē kōōto.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kutas taay ꞉Yēēsu kumwoochi biiko kule, “Chii ake tukul nyoo māmii komosnyuu, ku nyooto ꞉nyēē miitē kubāloo. Nto chii ake tukul nyoo māyēētyēēchoo kiiruruukiisyē, ku nyooto ꞉nyēē isērēētē.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kitas taay ꞉Yēēsu kumwooy kule, “Kāāmwoowook, /kēēnyōōchinē kaat chiito ām ng'ōōki ake tukul āk kōchōōng'nāt ake tukul, nteenee ‑/mākēēnyōōchinē kaat nyoo intosuurē Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chii ake tukul nyoo kang'alaalee *Wēritaab Chii nyēē miyaat, /kēēnyōōchinē kaat, nteenee chii ake tukul nyoo koobuch Tāmirmiryēētaab Yēyiin, ku ‑/mākēēnyōōchinē nyoo kaat ra nto mbo ām bēsyōōsyēk choo kwoonii.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kimwooy subak ꞉Yēēsu kule, “Yoo karaam ꞉kēētit ku kāroomēch ꞉nkicheek lokoyeekyii nto yoo miyaat ꞉kēētit ku miyootēch ꞉nkicheek lokoyeekyii. Kunyi /kiinkētēē kāroomnyēētaab kēētit lokoyeekyii. ");
INSERT INTO spyNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ōyēku sōō ng'oomng'ook nyēē tyaa! Choolwookichu, ōmuuchē ꞉akweek omwaay ng'ālyoo nyēē karaam bēsyō? Kiyēē chōōnēē kuutiitaab chii ku nyēē mii mētinyii. ");
INSERT INTO spyNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yoo karaam ꞉mētitaab chii kuyēyē tukuuk chēē kāroomēch, nto yoo miyaat ꞉mētit kuyēyē tukuuk chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kāāmwoowook, makukwaanee chii kubo ng'ālyoo nyēē mayemaat nyēē kiikumwooy, yoo /kiitiilchinē biiko ng'aleek. ");
INSERT INTO spyNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kunyi, mākubēēr ꞉ng'aleekuuk yoo ibēērē keey nto yēmē /kiiruustiing'.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yooto kumwoochi *꞉Farisaayeek alake ākoo kāānēētikaab kiruutēk Yēēsu kule, “Kāānēētiintēēt, kēēmāchē iyēwēēch kiy nyēbo kwōng'uut nyēē iboorunēēnēēch kule iboontē kāāmuukēywēēk chēē kwoonēē kibkōōnkōy.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kuwālchi ꞉Yēēsu bichoo kule, “Kibrōkōsiis āk choo chuunnyēē Yēyiin ꞉chēē tēēbē /kiiboorchi kiy nyēbo kwōng'uut. Ng'al baateey chēbo kwōng'uut chēē +/mākiiboorchi ku choo kibo wōōrkooyoontēēt Yoona. ");
INSERT INTO spyNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kuu yoo kibēēnnyēē ꞉Yoona mooyēētaab tyoony bo araaray bēsyōōsyēk sōmōk, mākubēēni ꞉nkinee *Wēritaab Chii ng'wēny bēsyōōsyēk sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mākōōyyoong'iis ꞉biikaab Ninaawi bēsyoonoo /kiitiilchinē biiko ng'aleek ankooruusta biiko chēē wuu chutēchu, kuuyu kiweek ꞉icheek yoo kyoomchinē ꞉Yoona lōkōōywēk. Nteenee mii yu ra ꞉nyēē wōō kusiir Yoona. ");
INSERT INTO spyNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mākōōyyo ꞉cheebyoosya nyēē kibāytooy kōōrēētaab Sōōy bēsyoonoo /kiitiilchinē biiko ng'aleek. Makooruusta biiko chēē wuu chutēchu, kuuyu kichōōnēē ꞉inee lōōyin chokuyēbchinē yiit ng'aleekaab ng'oomnān choo kimwoowu ꞉Sōlōmōōn. Nteenee mii yu ra ꞉nyēē wōō kubiir Sōlōmōōn.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kitas taay ꞉Yēēsu kumwooy kule, “Yoo /kāākiibēbēēto *tāmirmiryēēt nyēē miyaat kuchuwunee chiito, makoombakaatee suurkwēēnēēt nyēē kilay ꞉asiis kuchēēng'ē wōlēē kēēmuunyēē. Nto yoo kāmānyōōr wōlēē kāminy, ");
INSERT INTO spyNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kumwooyē kule, ‘Kaykay ayeey wōloo kyāāminyē.’ Yoo kēēyēēw, kunyōōru wōlooto kumasaat ankuyeytaat nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yooto, kōōyēēyē ānkuwokuchōōntooy keey tāmirmirook alak tisab chēē miyootēch kusiir inee ānkōōwut ꞉tukul chiichooto. Kunyi, miyātiitu ꞉chiichoo kusiir yoo kibo taay. Kunyoo mākuwuuyiit nyooto ām wōlēē miitē ꞉biiko choo kiikuchuunnyēē Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nto yu tākumiitē ꞉Yēēsu kung'āloolchinē biiko chēē chaang', chokōōyyoonyēē ꞉kaamet ākoo mbo ng'eetaabkaamet saang' kumāchē kung'āloolchi. ");
INSERT INTO spyNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kumwoochi ꞉chiito ake Yēēsu kule, “Mii ꞉koomēt saang' ākoo mbo ng'eetaabkoomēt kumāchē kung'ālooluung'.” ");
INSERT INTO spyNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kuwāl ꞉Yēēsu kule, “Ng'oo nyēē moomo anii ānku ng'oo ꞉chēē mbo ng'eetaabiya?” ");
INSERT INTO spyNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yooto koong'welyeel rubiikyii ānkumwooy kule, “Bichu kēēboontē keey ꞉chēē mbo ng'eetaabiya ānku mbo moomo. ");
INSERT INTO spyNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chii ake tukul nyoo yēyē ng'aleek choo māchē ꞉Baaba ām kibkōōnkōy, nyēē ng'eetaabiya anii, cheebiya anii ānku moomo anii.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nto ām bēsyoonooto kung'eetee ꞉Yēēsu kō ānkuwokutēbēē sakaramteetaab Tōōliilēētaab Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yu kēēruruukyi keey inee ꞉biiko chēē chaang', kulaany mwēēnkēēt nteenee kiiyyoong'iis ꞉biiko chuut tukul sakaramteetaab tōōliilēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kooneet ꞉Yēēsu bichoo ng'aleek chēē choong'ēch ām tyoonkōōchoy kule, “Kiwokuyis ꞉kāābātiintēēt ake nkoonuuk. ");
INSERT INTO spyNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yu kāyis nkoonuuchoo, kōōsuuchi ꞉alake kēēltaab too. Nto tēē yoo kukwa ꞉tāriitēk ankukwey. ");
INSERT INTO spyNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kōōsuuchi ꞉alake kitaweet wōlēē kitewerer ꞉teng'nyaanteet. Kubiityo ꞉choo areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nteenee yu kalay ꞉asiista kōōsiis nkoonuuchoo kuuyu kimāmii wōlēē kikwērtoochinē keey ꞉tiikiitēk. ");
INSERT INTO spyNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kōōsuuchi ꞉alake wōlēē miitē ꞉kātook. Yu kābiityo ꞉kātoochoo kōōrēēwoon nkoonuuk kut kumanaayey āmit. ");
INSERT INTO spyNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kōōsuuchi ꞉alake teng'eek chēē kāroomēch. Kibiityo ꞉choo nyēē karaam. Kiyey ꞉alake āmiik chēē ng'ēri, kuyey ꞉alake chēē kāykāyēch, nto alak kuyey chēē choong'ēch. ");
INSERT INTO spyNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nyoo yēbē yiit, kukas.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nto mii lētuunoo, kukwoonchi ꞉rubiik Yēēsu ankuteebee kule, “Ām nee siing'āloolchinēē ꞉inyiing' biiko tyoonkōōchoy?” ");
INSERT INTO spyNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kuwālchi ꞉Yēēsu kule, “/Kookeekweyaak akweek ōnkēt kiyēē iyeelaat kurubta keey bāytooyiisyēētaab Yēyiin, nteenee /mānāākiiboorchi alak. ");
INSERT INTO spyNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chiito nyoo yēyiisyēē kiyēē inkēt +/mākēētāsyi ake. Nto nyoo māyēyiisyēē, +/mākiibootēē mbo nyoo kāboonto. ");
INSERT INTO spyNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Āmwoowunēē ng'aleek tyoonkōōchoy kuuyu ānkoo kakasee koong', mākāsē kiy, nto yoo kāyēbchi yiit, kumēēnkētē kiy. ");
INSERT INTO spyNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yityiintōōs ām bichu ꞉kiyoo kimwooyē ꞉wōōrkooyoontēētaab Yēyiin Isaaya kule, ‘+Mōōyēbchinē yiit, āmōōnkētē kiy. +Mōōkāsēē koong', āmōōkāsē kiy. ");
INSERT INTO spyNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kuuyu kiyoomcho bichu ꞉mētēwoy, kiimiiny ꞉bichoo yiitin ānkiimiis koonyay. Nto kōmāwuu nyoo, nto kāsēē koonyekwaa, kuyēbchinēē yiit yiitiikwaa ānkōōnkētēē mētēwookwaa ānkuwēēkiis ānkāāsoob icheek.’ ");
INSERT INTO spyNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nteenee ōbēruurootiin sōō, ꞉akweek nyēē tyaa chu kāstooy ꞉koonyekwook ānkuyēbiitē ꞉yiitiikwook. ");
INSERT INTO spyNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","!Kāāmwoowook, kiikukanyaan *꞉wōōrkooyikaab Yēyiin chēē chaang' āk biiko chēē chaang' choo churtootiin, kule nto kas kiyēē ōmiitē ꞉akweek ōkāsē nteenee maneemuuch. Kukanyaan kule kuyēbchi yiit kiyēē kyookas ꞉akweek nteenee mānēēnkēt kiyooto.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kunyi okany baa ābāng'boong'wook tyoonkōōchoonēēb kāābātiintooni kiyisē nkoonu. ");
INSERT INTO spyNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kerkeey ꞉biiko alake āk kēēltaab too. Kāsē ng'ālyoontēēt nyēē rubtooy keey bāytooyiisyēētaab Yēyiin āmēēnkēt kiyēē mwooyē ꞉lōkōōywēchoo. Yoo kāchō ꞉Kibrōkōsyoontēēt kusārē. ");
INSERT INTO spyNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kukerkeey ꞉alake āk kitaweet. Kāsē ng'ālyoontēēt ankutorooch areet akeenke kukāng'ērēkyi. ");
INSERT INTO spyNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nteenee māchutitēē icheek ꞉ng'ālyoontoonoo, ibuurtooy nto nyēē mā tyaa, yoo /kākēēwēch /ānkēēwus kubo ng'ālyoontēēt, koochuchuuy keey. ");
INSERT INTO spyNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kerkeey ꞉biiko alake teng'eek chēē kibiitee ꞉kātook. Kāsē ng'ālyoontēēt, nteenee bēng'tēē tukuukaab kōōrooni āk muchastaab bāytit. Irēēwoonē ꞉tukuuchoo ng'ālyoontēētaab Yēyiin kumayey kiy. ");
INSERT INTO spyNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kerkeey ꞉biiko alake teng'eek choo kāroomēch. Kāsē ng'ālyoontēēt ānkukiilchi. Yēyiisyēē ꞉alake ng'ālyoontēētaab Yēyiin kuyi keey kisich, kuyi keey ām alak kukaykay, nto alak kuyi keey miisin.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nto mii yoo kumwoochi ꞉Yēēsu biiko tyoonkōōchēēt ake subak kule, “King'eet ꞉chiito ake kuchaan kēbuswēēk chēē kāroomēch mbareenyii. ");
INSERT INTO spyNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nto mii kwēēmooy kukāruuyo ꞉biiko, kuchō ꞉buunyoontēēt ānkuyis suuswoontēēt ake nyēē wuu nkoonnyoontēēt wōlooto bo mbareen ānkuwēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kibiityiin ꞉nkoonuuchoo āk suuswēchoo ankuyey mētēwook. ");
INSERT INTO spyNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nto miitē yoo, kumwoochi ꞉motwoorik chiitaab mbareet kule, ‘Mokoryoontēēt, 'kiichaan oob ꞉inyiing' kēbuswēēk chēē kāroomēch mbareen? So, kokwaanee ānō ꞉suuswēk?’ ");
INSERT INTO spyNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kuwālchi ꞉chiitaab mbareet kule, ‘Buunyoontēēt ꞉nyooto koyey ng'aleechaa.’ Kumwoochi ꞉motwoorikyii kule, ‘Ara keebe ꞉acheek bokiitutu suuswēchoo?’ ");
INSERT INTO spyNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kukētyi motwoorik kule, ‘Acha. Yoo kōōlē boong'ey, ōmuuchē ong'eyte nkoonuuk. ");
INSERT INTO spyNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kunyi okany kubiityiin kuu nyooto ākoy yoo /kēēkēsiisyē. Nto yooto +māāmwoochi biiko choo kēsiisyē kulēkwēl suuswēk ankurat /sikeebeel, nto yityo kōōruruuch nkoonuuk ānkuyib kukwa chookē.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kumwooy ꞉Yēēsu tyoonkōōchēēt ake kurubta keey āk bāytooyiisyēētaab Yēyiin kule, “Kichaan ꞉chiito ake mbareenyii kēbuswoontēēt ake nyēē /kikēēkuurēē *aritaaliit. ");
INSERT INTO spyNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ānkoo ku kēbuswoo nyēē mining' ām kēbus alak tukul chēē /kēēchoonē, biitē ku wōōyiit kusiir keetiik chuut ānkuyēyē sokonaak chēē tēēkyinē ꞉tāriitēk kooriikwaa.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kimwooy subak ꞉Yēēsu kule, “Kerkeey ꞉bāytooyiisyēētaab Yēyiin tukun choo yoo /kakeetankwarta bus kuchututēē busyeek tukul kukuut.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kiyēyiisyootēē ꞉Yēēsu tyoonkōōchoy yoo king'āloolchinootē biiko. ");
INSERT INTO spyNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kiyityiin yooto ꞉kiyoo kimwooyē *꞉wōōrkooyoontēēt ake kule, “Āmiitē wāāmwoowunēē ng'aleek tyoonkōōchoy, ābooru ng'al chēē kiiyēēlootiin kung'eetee /kakeeyey kōōrēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yooto, kubakaakta ꞉Yēēsu bichoo ki chaang' ānkuwo kō. Nto tēē yoo kōōnookyi ꞉rubiikyii ankuteebee inee kule, “Mwoowēēch, ibooru nee ꞉tyoonkōōchoonoo bo suuswoontēēt?” ");
INSERT INTO spyNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kuwālchi ꞉Yēēsu kule, “Chiichoo kichoonē kēbuswēēchoo kāroomēch ku *Wēritaab Chii. ");
INSERT INTO spyNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mbareet ku kōōrēēt, nto nkoonuuk ku biikaab bāytooyiisyēētaab Yēyiin. Nto suuswoontēēt ku biikaab Kibrōkōsyoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nto ꞉nyēē kichoonē suuswoontoonooto ku *Kēniintēēt. Kiyēē +/makeekes ku biiko chēē +/mākiitiilchi ng'aleek ām bēsyēētaab tabanta. Nto kēsiik ku malayikaanik. ");
INSERT INTO spyNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kuu yoo /kēētilē suuswoontoonoo miitē mbareen /ankeebeelee maata, kuwuuyiitu nyooto ām tabantaab kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mākōōyook *꞉Wēritaab Chii malayikaanikyii chokōōnēmto ām Bāytooyiisyēēnyii ꞉biiko tukul choo tēwēchootē biiko alak āk kibng'ōōkisiis alak tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mākutōōrchi bichoo maata nyēē irikitiitē, wōlēē mābokung'woonchi ankuriirunee ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mākōōluuw ꞉choo churtootiin kuu asiista ām Kaab Kwaan. Nyoo yēbē yiit kukas.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kitas taay ꞉Yēēsu kumwooy kule, “Kerkeey ꞉bāytooyiisyēētaab Yēyiin yoo /kakeewunyee tukun chēbo koomānuut mbareen nto tēē yoo kunyōōr ꞉chiito ake ānkōōyēēn subak. Wēētii ꞉chiichoo ām ng'erekweek ānkuwokwaalta tukuukyii tukul chēē boonto ankwaal mbaraanaata.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kimwooy ꞉Yēēsu subak kule, “Kerkeey ꞉bāytooyiisyēētaab Yēyiin āk yoo chēēng'ē ꞉chiito ake sanayeek chēē kāroorānēch, ");
INSERT INTO spyNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","nto yoo kānyōōr sanayaanteet akeenke nyēbo koomānuut wokwaalta kiy ake tukul nyēē boonto ankwaal sanayaantaanaata.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kimwooy subak ꞉Yēēsu kule, “Kerkeey ꞉bāytooyiisyēētaab Yēyiin yoo keeluumta ꞉biiko alake nēētiit tōōliilēēt āriit ankunam *burburiinēk chēē chaang' chēē makerkeey. ");
INSERT INTO spyNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yoo kaakunyiy ꞉burburiinēk nēētiit, kōōchuut ꞉tēkiik kuchō sakaramteet. Nto yityo kōōbuur ng'wēny ānkulēkwēl burburiinēk choo kāroomēch ānkōōkoochi kērēb ānkumēto choo miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wuu nyooto ām bēsyēētaab tabantaab kōōrooni! Makukwa ꞉malayikaanik ānkulēkwēlunēē biiko choo miyootēch wōlēē mii ꞉choo churtootiin. ");
INSERT INTO spyNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","+/Mākēētōōrchi biiko choo miyootēch wōlēē bo maat nyēē irikitiitē wōlēē mākung'woonchi ꞉soboon ankuriirunee ng'wēny.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yu kēēwoong' ꞉Yēēsu kumwooy ng'aleechaa, kuteebee rubiikyii kule, “Ōkāsē ng'aleechuutēchu?” Kukēt rubiikēy kule, “Ēē, kēēkāsē.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yooto nanyuun kumwoochi icheek kule, “Kunyoo, kāānēētiin ake tukul nyēē /kiikiineet kurubta keey bāytooyiisyēētaab Yēyiin, kukerkeey chii nyēē inēmu ām chookēēnyii tukuuk chēē leelach āk chēē yōōsēch.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yu keewaany ꞉Yēēsu kōōnēētiisyēē tyoonkōōchoochoo, kung'eetee yooto. ");
INSERT INTO spyNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nto lētuunoo kuyit Nāāsārēēt wōloo kinērēē. Yooto kōōnēētiis ām *kōōtaab saayeet. Yu kakas ꞉biiko wōlēē kiinēētitooy, koolat ankuteebee keey kule, “Wōlēē kinyōōrtooy ꞉chiichi ng'oomnātooni āk kāāmuukēywēēchu bo kwōng'uut ku ānō? ");
INSERT INTO spyNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","So! Mābo nee ꞉wēēriitēnyi kāātoong'iintoonoo? Mā kaamet nyoo /kēēkuurēē Maaryaa ānku ng'eetaabkaamet oob Yāākōbō, Yōōsēēf, Simōōni ākoo Yuuta? ");
INSERT INTO spyNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kēēboontē keey oob mbo cheebkaamet tukul? Kunyi ii, konyoorta ānō ꞉chiichi ng'aleechu tukul?” ");
INSERT INTO spyNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kitay ꞉bichoo Yēēsu. Nto tēē yoo kumwoochi ꞉Yēēsu bichooto kule, “‑/Mākēēkoonyitē *wōōrkooyoo ām saang'nyii nto kōōng'waa, nteenee koonyitē ꞉biikaab saang'ta ake.” ");
INSERT INTO spyNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Manaayeyee wōlooto ꞉Yēēsu ng'aleek chēē chaang' chēbo kwōng'uut kuuyu kimēēkoosēē keey ꞉biiko inee. ");
INSERT INTO spyNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kikas ꞉Bāytooyiintēēt *Ērōōtē /kyoomtooy Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kumwoochi motwoorikyii kule, “Bātisāniintēēt Yoowaana ꞉nyooto nyēē kookung'eetee meet! Kiyooto nyi ōkāsē kuyēyiisyēē kāāmuukēywēēchoo bo kwōng'uut.” ");
INSERT INTO spyNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kimiitē yēē kichoomnyo ꞉Ērōōtē āk Erootyaa koorkēētaab ng'eetaabkaamet nyēē /kikēēkuurēē Filibō. Kimwoochinē ꞉Yoowaana Ērōōtē kule, “Makaraam 'intii ng'eetaabkoomēt kusobē.” Yooto kōōwuruur ꞉Erootyaa Ērōōtē kukerta Yoowaana kōōtaab kibratiisyek. ");
INSERT INTO spyNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kimāchē yooto ꞉Ērōōtē kubakach Yoowaana nteenee kiiywey biiko, kuuyu kichāmtooy ꞉bichoo kule *wōōrkooyoontēēt ꞉Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nto miitē yēē /kikyoomē saakweet nyēē king'ērēkyinēē ꞉Ērōōtē bēsyēēt nyēē /kikēēsichēē, chokutuumēē ꞉chēēbtaab Erootyaa taayeetaab biiko. Yooto kung'erech ꞉Ērōōtē kut ");
INSERT INTO spyNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kōōwoolchi keey chēēbooto kule ikoochinē kiyēē kateeb. ");
INSERT INTO spyNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wokuteebee ꞉chēēboo kaamet nto tēē yoo chokumwoochi Ērōōtē kule, “Āmāchē mētitaab Yoowaana /kēēyibunēēnoo kibseesweet!” ");
INSERT INTO spyNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yooto kwoorookēn ꞉Bāytooyiintēēt, nteenee kuuyu kikiikōōwoolchi keey chēēboo ām taayeetaab tāyēēkyii, kumwaayta /kēēyēchi kiyooto kitēēbē. ");
INSERT INTO spyNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kunyoo /kibokeechwenta mētitaab Yoowaana ām kāābrātiisyō ");
INSERT INTO spyNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","nto yityo /kēēyibchinēē chēēbkēy kibseesweet. Kunam ꞉chēēboo mētooto ānkuyibchi kaamet. ");
INSERT INTO spyNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lētuunoo bokumuy Yoowaana ꞉rubiikyii nto yityo bokumwoochi Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yu /kābokyoomchi Yēēsu ng'aleechaa, kung'ēētyēē wōlooto kimii ānkwooyyēē mwēēnkēēt kumāchē kuba yēē kimālēēkit ꞉chii. Nto kukāsē ꞉biiko kuu nyooto, koosaab sakaramteetaab tōōliilēēt kwaalach Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kurēkunēē ꞉Yēēsu mwēēng', ankukas biiko chēē ki chaang' miisin, kukāsyi kiisayta ānkōōsoobchi bōōrwēk. ");
INSERT INTO spyNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nto kwiimēnē ꞉kōōrēēt, kōōnookyi ꞉rubiik ānkumwoochi kule, “Ntēē kāākwiimēn ꞉kōōrēēt ānku suurkwēēnnyoo ꞉wōli! Mwoochi bichu simkuroot subokwaalaat āmiik chēē kāriibēē moonikwaa.” ");
INSERT INTO spyNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kuwāl ꞉Yēēsu kule, “Mēērook kuba. Ōkoochi ꞉akweek kiyēē kaam.” ");
INSERT INTO spyNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kukētyi ꞉rubiik Yēēsu kule, “Ntēē mukaatiinek muut āk *burburiinēk āyēēng' baateey chēē kēēboontē!” ");
INSERT INTO spyNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kumwoochi ꞉Yēēsu kule, “Ōkōōnoo baa āmiichooto.” ");
INSERT INTO spyNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kumwooy ꞉Yēēsu kule kōōbuur ꞉biiko yoo bo saatyeet. Nto miitē yoo kunam mukaatiinekēy muut āk burburiinēkēy āyēēng' ankukas barak kubirchi Yēyiin kōōnkōy. Nto yityo kubcheyaabchey ānkōōkoochi rubiikyii kubchēchinoot biiko. ");
INSERT INTO spyNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kyoomiis ꞉bichoo tukul kut kubiyoong'iis. Nto bērē kōōruruuchoot ꞉rubiik āmiik chēē /kikiituuchaat, kunyiy kērēboonik taman āk āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Biiko chēē kyaam āmiichu ku murēnik kisyēērōōk muut /kumānāākiiyiitito chēēbyōōsōōk āk lēēkōōk. ");
INSERT INTO spyNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yooto bakeenke, kōōkiimchi ꞉Yēēsu rubiikyii kulaany mwēēnkēēt simkoonto kutākumii ꞉inee kōō-āmiisē biiko. ");
INSERT INTO spyNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nto yu kāākōō-āmiis bichoo, kootooch nkityō lekemeet ake barak wokusaay. Kwiimēnē ꞉kōōrēēt kutākumii ꞉inee wōlooto nkityō. ");
INSERT INTO spyNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yooto tukul, kikiikuwo ꞉mwēēnkēēt tōōliil kwēēn ānkimiitē kōōsooyēnē ꞉wusōōnēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nto yu kāng'ēēyēn ꞉kōōrēēt, kuwēēsyētēē ꞉Yēēsu bēēko barak ākoy wōlēē kimii ꞉rubiikyii. ");
INSERT INTO spyNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nto bērē kukas ꞉rubiikyii kuwēēsyētoonunēē tōōliilēēt, kumuuyo miisin ānkumwooy kule, “Chii ēē, nto āyiin!” Kumwooyē kuu nyooto kōōnchōōytōōs bakeenke nyēē kāākubōōtoon. ");
INSERT INTO spyNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yooto kumwoochi ꞉Yēēsu rubiichoo kule, “‑Mōōmuuyē! Nto yu anii nyoo.” ");
INSERT INTO spyNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kukāsē ꞉Bētērō kuu nyoo, kumwooyē kule, “Yoo inyiing' ii, Mokoryoontēēt, imwoowoo āwēēsyētēē bēēko barak ākoy wōloo imiitē.” ");
INSERT INTO spyNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kuwālchi ꞉Yēēsu Bētērō kule, “Chōō naas.” Kurēkunēē ꞉Bētērō mwēēng' ankootaar bēēko barak ānkutākyi keey Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yu kakas wusōōnēēt, kunyokoriit ānkutoow kuling'taat. Yooto kutooree kāānchōōyto kule, “Wōōy, ānkiisārwoo wē, Mokoryoontēēt!” ");
INSERT INTO spyNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kōōyokooyto ꞉Yēēsu āwut ankunam Bētērō. Nto tēē yoo kumwoochi kule, “So, ntēē iyābē kuu nyi? ‑Mēēkoosēēnoo keey?” ");
INSERT INTO spyNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nto yu kaakulaany ꞉tukwaay mwēēng', kuteeman ꞉wusōōnēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kukutunkyi ꞉biiko choo kimiitē mwēēng' Yēēsu kumwooyē kule, “Kubooyiit man, inyiing' Lakwataab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nto yu kaakwaay, bokōōyyoonyēē yēē /kikēēkuurēē Keneesareet. ");
INSERT INTO spyNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yu kēēnkēt ꞉biikaab wōlooto kule ki Yēēsu ꞉nyooto, kukuurootēē biiko soong'wēk chēē ki laatoos. Kikiimutyi Yēēsu biiko tukul chēē kimnyoontōōs. ");
INSERT INTO spyNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kusoom ꞉bichooto kimnyoontōōs Yēēsu kule, “Ichāmwēēch kēētiiny buch maaseekaab kotootookaab sireeng'uung'.” Kisob ꞉chii ake tukul nyēē kitiiny maaseechaa. ");
INSERT INTO spyNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nto mii bēsyēēt ake, kukwaanee *꞉Farisaayeek alake āk kāānēētikaab kiruutēk Yēērusālēēm ankuteebee Yēēsu kule, ");
INSERT INTO spyNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ām nee yu mārubē ꞉rubiikuuk ntāsimuutēkaab mbo kuuko? Ntēē ‑mēēntāsiimē ꞉icheek āwunnyēk nto āmiisyē?” ");
INSERT INTO spyNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kuwālchi ꞉Yēēsu kule, “Ntēē ōkwētyinē akweek mākuutēkaab Yēyiin ankoorub ātēbuutēkaab mbo kuukoong'? ");
INSERT INTO spyNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kimwooy oob ꞉Yēyiin kule, ‘Iywey kōōn āk koomēt? Chii nyoo chubē kwaan nto kaamet, kunyoolchinē ꞉meet.’ ");
INSERT INTO spyNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nteenee ōmwooyē ꞉akweek kule yoo kāmwoochi ꞉chii kaamet nto kwaan kule, ‘Kiito ake tukul nyoo kātāākōōnook, kukyaasat kubo Yēyiin,’ ");
INSERT INTO spyNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nto yooto mēēbērē māchāktōōs kooywey sikiikyii. Ōmōōntooy ꞉akweek kuu nyiitēnyi ng'ālyoontēētaab Yēyiin ankoorub ātēbuutēkwook nkit. ");
INSERT INTO spyNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ōyēyē keey sōō kutyaa kule ōchurtootiin! Kibēēr ꞉wōōrkooyoontō bo Yēyiin *Isaaya yoo kimwooyē kule: ");
INSERT INTO spyNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Koonyitēēnoo ꞉bichoo kuutuw, āmāboontēēnoo moo. ");
INSERT INTO spyNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ānkoo kasaaya ꞉bichoo, ‑māākāsyinē, kuuyu chōōnēē ꞉kāānēētiisyēēng'waa wōlēē mii ꞉biich buch.’” ");
INSERT INTO spyNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nto miitē yoo, kumwoochi ꞉Yēēsu biiko kuyisyi keey inee nto yityo kumwoochi kule, “Okas baa ng'ālyoontooni: ");
INSERT INTO spyNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mēēbērē kiyēē iwutē kuutiitaab chii ꞉nyēē yēyē chiichoo kumātililiit, nteenee nyēē yēyē kumātililiit ku kiyoo chōōnēē kuutiinyii.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yu keewaany ꞉Yēēsu kumwooy kuu nyooto, kōōnookyi ꞉rubiikyii, ānkumwoochi kule, “'Kēēnkēt ꞉inyiing' kule kāng'woonchi *Farisaayeek ꞉ng'aleechaa 'kēēmwooyē?” ");
INSERT INTO spyNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kuwālchi ꞉Yēēsu kule, “+/Makeeng'eeyta keet ake tukul nyēē kimāchoonē ꞉Baaba nyoo mii kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kunyi ‑mooyiimee keey ꞉akweek Farisaayeechaa. Kōryootiin ꞉bichoo. Nto yoo kēēntōōchi ꞉cheebkoraatyaanteet ake ake, kōōsuuchinē ꞉tukwaay ng'wēēn.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yooto kumwooy ꞉Bētērō kule, “Iboorwēēch ng'aleechaa bo tiliilinto.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kuwālchi ꞉Yēēsu kule, “So, ākoo mānōōnkēt kura? ");
INSERT INTO spyNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","‑Mōōnkēt ꞉akweek kule kiy ake tukul nyoo wēētēē kuut kuwēētii moo ānkuwokuwo saang'? ");
INSERT INTO spyNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nto ng'aleek choo kwoonēē kuut kukwoonēē ꞉choo mēt ānku chooto chēē yēyē chiito kumātililiit. ");
INSERT INTO spyNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kiyēē chōōnēē mēt ku kāāsōōtēywēēk chēē miyootēch kuu chēbo rumiisyēēt, martaayeet, sikornateet, chōōrsēēt, mōlōlchinooyēētaab ng'al āk ng'ōōmsēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tukuuk chooto chēē yēyē chiito kumātililiit. Nteenee yoo koomiis ꞉chiito kumaneentasiim āwut, māyēyē ꞉yooto kumātililiit ꞉chiichoo ām wōlēē mii ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yu kang'eetee ꞉Yēēsu yooto ākoo rubiikyii, kuwo ākoy kōōrēētaab kiriinkēētaab Tiirō āk Sitōōn. ");
INSERT INTO spyNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yooto kuchōōnchi ꞉cheebyoosyeet ake nyēē kimā Cheebyuutayaa. Kibōloobōl kumwooyē kule, “Mokoryoontēēt, *Mōchōkōrēētaab Tāwuti, ankiiriireenaa! Mii kōōyiimē chēēbnyuu ꞉tāmirmiryēēt nyēē miyaat.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mānāāwālchi ꞉Yēēsu cheebyoosyaanaa ng'ālyoo ām baanaa. Yooto kubēēchi ꞉rubiik Yēēsu ankusaaysaay kule, “Mwoochi, naas, kuwēēchi keey ntēē kābōloobōloot kuu nyi.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kuwālchi ꞉Yēēsu cheebyoosyaanaa kule, “Cheebyoos, /kikiiyookwoo anii baateey wōlēē miitē ꞉biikaab *Isrāyēēl choo kēēchiir chēē kiikubootyo.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kōōnookyi ꞉cheebyoosyeet Yēēsu, kukutunyēē taayeenyii ānkumwoochi kule, “Ānkiiyēētyēēchoo ōō, Mokoryoontēēt!” ");
INSERT INTO spyNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kulēēnchi ꞉Yēēsu, “Makaraam /kiinēm āmnyoontēētaab lēēkōōk /ānkēēmētyi ng'ōōkin.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kuwālchi ꞉cheebyoosyaanaa kule, “Wuu nyooto sinee ōō, Mokoryoontēēt, ntēē āmē mbo ꞉ng'ōōkin seeserik yoo āmiisyē ꞉biikwaa.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yu kāmwooy ꞉cheebyoosyaanaa kuu nyooto, kuwālchi ꞉Yēēsu kule, “Cheebyoos, kuuyu 'ikoosēēnoo keey miisin, /kāākēēchāmuung' kuu wōloo 'kēēmāktooy.” Kumwooyē ꞉Yēēsu kuu nyooto kusobē bakeenke ꞉chēēbtaab cheebyoosyaanaa. ");
INSERT INTO spyNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nto tēē yoo kung'eetee ꞉Yēēsu yooto kumur sakaramteetaab Tōōliilēētaab Kalilaaya, kiitooch yēē tōrōōr ānkōōbuur ng'wēny sukōōnēētiis. ");
INSERT INTO spyNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","/Kikiimutyi biiko chēē chunkutootiin, chēē kōryootiin, chēē sōnkōchootiin, chēē kirātākiis ꞉ng'ēlyēēbik āk alak chēē chaang' /ānkiikoochi taayeetaab Yēēsu. Kōōsoob ꞉Yēēsu bichooto tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yu kakas ꞉biiko kung'āloolē ꞉choo kikirātākiis ꞉ng'ēlyēēbik, kāsobcho ꞉choo kisōnkōchootiin, kubeesyet ꞉choo kichunkutootiin ankukasta ꞉choo kikōryootiin, koolat ānkusilto Yēyiintēētaab *Isrāyēēl. ");
INSERT INTO spyNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nto miitē yoo kukuur ꞉Yēēsu rubiikyii ānkumwoochi kule, “Ntēē kaariiree bichu. Kōōkiibuurtē keey bēsyōōsyēk sōmōk āmāmii ꞉kiyēē āmē! Mēēbērē +māāmwoochi kuba kumanaa-am kiy kuuyu imuuchē kōōmiistoochi ꞉kēmēwuut kēēltaab too.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kuwāl ꞉rubiikyii kule, “Nto wōlēē sikeenyoorte āmit chēē yēmē biich chēē tēē chu ām suurkwēēnooni ku ānō?” ");
INSERT INTO spyNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kuteebee ꞉Yēēsu kule, “Ōboontē mukaatiinek ata?” Kuwālchi ꞉rubiik kule, “Kēēboontē tisab āk *burburiinēk chēē ng'ēri.” ");
INSERT INTO spyNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yooto, kumwoochi biiko kōōbuur ng'wēny nyēē katet keey. ");
INSERT INTO spyNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nto tēē yoo kunam mukaatiinechaa tisab āk burburiinēk, nto yu kāākubirchi Yēyiin kōōnkōy, kubcheyaabchey ānkōōkoochi rubiik kubchēchinoot biiko. ");
INSERT INTO spyNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kwoomiis ꞉biiko tukul kut kubiyoong'iis. Nto yu kēēruruuchoot ꞉rubiik āmiik chēē king'ēt, koonyiit kērēboonik tisab. ");
INSERT INTO spyNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nto laatitaab biiko chēē kyoomiis, ki kisyēērōōk ang'wan /kumānāākiiyiitito chēēbyōōsōōk āk lēēkōōk. ");
INSERT INTO spyNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nto mii yoo nanyuun, kōō-āmiis ꞉Yēēsu biiko kubēēchi keey ankulaany ꞉inee mwēēnkēēt ākoo rubiikyii ānkuwo ākoy saang'ta ake nyēē /kikēēkuurēē Makataan. ");
INSERT INTO spyNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nto miitē bēsyēēt ake, kukwoonchi *꞉Farisaayeek ākoo *Satukaayeek Yēēsu kumāchē kutyem. Kimwoochi kuyēchi icheek kiy nyēbo kwōng'uut sukōōnkētēē kule boonto ꞉inee kāāmuukēywēēk chēē kwoonēē kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nteenee kuwālchi ꞉Yēēsu kule, “Yoo imēnē, ōmwooyē ꞉akweek kule, ‘Mākumusēs tuun ꞉kōōrēēt, kuuyu arraa ꞉wōliin bo barak.’ ");
INSERT INTO spyNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nto yoo bo kōrrōōn, ōmwooyē kule, ‘Yiiwoot ra, kuuyu kaarraniit ꞉wōliin bo barak ānkutuuluunkēnoot.’ Ōnkētē ꞉akweek kiyēē ibooru ꞉wōliin bo barak yoo kaarraniit ‑āmōōnkētē kiyēē ibooru ꞉ng'aleek chu ōkāsē kuyēyāktōōs. ");
INSERT INTO spyNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Biich chēē miyootēch choo kiikutēwēchākiis ꞉chēē tēēbē /kēēyēchi kiy nyēbo kwōng'uut. Ng'aleek baateey chēbo kwōng'uut chēē +/mākiiboorchi ku choo kibo Yoona.” Yooto kubakaakta ꞉Yēēsu bichooto ānkuwēētēē mwēēnkēēt āk rubiikyii. ");
INSERT INTO spyNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nto yu kayit tōōliilēēt biitooniin, koosoot ꞉rubiik kule kikiikuwuutyēē mukaatiinek. ");
INSERT INTO spyNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kumwoochi ꞉Yēēsu kule, “Ōriibēē keey kiyēē bāyēēnook ꞉Farisaayeek āk *Satukaayeek.” ");
INSERT INTO spyNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kung'alaalee ꞉rubiichoo ng'aleechaa ānkumwooy kule, “Kāmwooy kuu nyooto kuuyu manaakeenamaanu mukaatiinek.” ");
INSERT INTO spyNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nto yu kēēnkēt ꞉Yēēsu kiyēē king'āloolēē ꞉rubiikyii, kuteebee kule, “‑Mōōkoosēēnoo keey kāroomin? Ām nee yu ōmiitē ōmwooyē kule manoonamaanu mukaatiinek? ");
INSERT INTO spyNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mānōōnkēt kiy ākoy kura? ‑Mōōsōōtē mukaatiinechaa ki muut choo kyoomē ꞉biiko kisyēērōōk muutu āk kaatuukanik choo kyōōruruuchē kunyiy kērēboonichoo? ");
INSERT INTO spyNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nto mbo naas mukaatiinechaa ko tisab choo kwoomē ꞉biiko kisyēērōōk ang'wanu āk kaatuukanik choo kwōōruruuchē kunyiy kērēboonichoo? ");
INSERT INTO spyNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ām nee simōōnkēt kule kāmāāng'āloolwook kurubta keey āmiik? !Kāāmwoowook, ōriibēē keey kiyēē bāyēēnook ꞉Farisaayeechaa āk Satukaayeechaa!” ");
INSERT INTO spyNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yooto nanyuun, kōōnkēt ꞉rubiichoo kule mēēbērē kimwoochinē icheek ꞉Yēēsu kuriibēē keey āmiik nteenee kimwoochinē kuriibēē keey kāānēētuutēkaab Farisaayeek āk chēbo *Satukaayeek. ");
INSERT INTO spyNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yu kāwokuyit ꞉Yēēsu ākoo rubiik rōōrōōkēētaab *kiriinkēētaab Kayisareeya Filiibi, kuteebee rubiikyii kule, “Mwooyē ꞉biiko kule *Wēritaab Chii, ku ng'oo?” ");
INSERT INTO spyNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kuwālchi ꞉rubiik kule, “Mwooyē ꞉alake kule inyiing' Bātisāniintēēt Yoowaana, kubērē ꞉alake *Eliiya, nto alak kumwooyē kule Cheremnyaa nto ku ake ām *wōōrkooyikaab Yēyiin nyēē kaakung'eetee *kāābkwoombiich.” ");
INSERT INTO spyNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kulēēnchi Yēēsu, “Nto akweek, ōbērē anii ku ng'oo?” ");
INSERT INTO spyNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kumwooy ꞉Simōōni Bētērō kule, “Inyiing' *Kāārārookiintēēt, Lakwataab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yooto kumwooy ꞉Yēēsu kule, “Simōōni araab Yoona, ibēruuroot. Mā chii ꞉nyēē kāng'oong'uung' ng'aleechu, nteenee Baaba anii nyoo miitē kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kunyi, +māākuuriing' kule Bētērō ānku +māātēēkyi kitawaani kōōnyuu nyēē ‑mēēbēlē ꞉Buunyoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","+Māākōōniing' kāāmuukēywēēk chēbo Bāytooyiisyēētaab Yēyiin. Kiy ake tukul nyēē ikērē ām kōōrooni, +/makeeker ām kibkōōnkōy. Nto nyēē iyootē ām kōōrooni, +/makeeyaat ām kibkōōnkōy.” ");
INSERT INTO spyNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yu keewaany ꞉Yēēsu kumwooy kuu nyooto, kōōkiimchi rubiikyii masimkumwaaytaat kule inee ꞉Kāārārookiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuchakee yooto kuwo taay kutoow ꞉Yēēsu kumwoochinē rubiikyii kule ākoy kuwo ꞉inee Yēērusālēēm ānkubuntēē nyāliluutēk chēē chaang' ām āwunnyēkaab booyik, mbo *kibkōrōs chēē wōōyēch āk kāānēētikaab kiruutēk. Kimwooy mbo subak kule ākoy /keebakach inee nto miitē bēsyēētaab sōmōk /kiing'eetee meet. ");
INSERT INTO spyNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yooto kuwēēto ꞉Bētērō Yēēsu komos ānkumwoochi kule, “Acha ōō, Mokoryoontēēt! Mēērook kuyēyākiis ꞉ng'ala chēē wuu choo ām wōlēē imiitē!” ");
INSERT INTO spyNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yooto kōōtuukyi Bētērō batay ānkumwoochi kule, “Sateenaa keey wē, Syeetaani! ‑Mēēyēku kāānākuut ām wōlēē āmiitē. 'Isōōtē kuu wōlēē isōōtitooy ꞉biiko, āmēēbērē kuu wōloo māktooy ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nto tēē yoo kumwoochi ꞉Yēēsu rubiikyii kule, “Chii ake tukul nyoo māchē kurub ng'aleekyuu, kutay kiyēē māchē ꞉mooyēēnyii amanyokoriit meet. Yoo kaakucham kuyey kuu nyooto, kuruba. ");
INSERT INTO spyNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nyoo kāyēētyi keey soboontaab kōōrooni, mākōōboot soboonnyii bo kibchuulyo. Nto nyoo kēēkooyto soboonnyii ām kōōrooni kubo anii, mākunyōōr *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kāroomnyo nee nyēē nyōōru ꞉chii yoo kēētukuulchi keey tukuukaab kōōrooni ānkōōboot soboonnyii bo kibchuulyo? Nto kiy nee nyēē imuuchē ꞉chii kuwalee soboonooto? ");
INSERT INTO spyNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Āmiitē ꞉anii, *Wēritaab Chii wāāchōōnii ām Lēbkēēyyēētaab Baaba āk malayikaanikyii, ānkuchāāyēchi chii ake tukul kurubta keey kiyēē kiikuyey. ");
INSERT INTO spyNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","!Kāāmwoowook, mii ꞉biiko alake yu chēē mābēku kumanaakas Wēritaab Chii kuyibu bāytooyiisyēēnyii.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nto yu kakeeyta ꞉bēsyōōsyēk lo, kulaang'ta ꞉Yēēsu ākoy tulwēēt ake barak, kuboontootē keey Bētērō, Yāākōbō āk Yoowaana ng'eetaabkaametiitaab Yāākōbō. ");
INSERT INTO spyNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kumiitē wōlooto, kuweek ꞉eertaab Yēēsu kukāsē rubiik, koolekecheech kuu asiista. Kileelakiitu ꞉nkicheek sirookyii kule mang'! ");
INSERT INTO spyNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yooto kukas ꞉rubiichoo *Muusa āk *Eliiya kwoomē lōkōōy āk Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kulēēnchi ꞉Bētērō Yēēsu, “Mokoryoontēēt, karaam nyēē tyaa kēēmiitē yuutēyu. Kany ateech kēryōōnik sōmōk, nyeeng'uung', nyēbo Muusa ākoo nyēbo *Eliiya.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kutākung'āloolē ꞉Bētērō, kuchō ꞉boolteet nyēē ki lebkeey miisin ankoolaambuuch icheek ānkuchōōnēē ꞉kuutiit booltaanaata kumwooyē kule, “Lakwanyuu ꞉nyi nyēē āchāmē ānkāāng'ērēkyinē. Kunyoo, ōkāsyinē kiyēē mwooyē.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yu kakas ꞉rubiichoo kuutiinaa, kumuuyo ānkōōbutyi ng'wēny kukubuy kuut. ");
INSERT INTO spyNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kuwo ꞉Yēēsu yooto ankutabtab icheek kumwoochinē kule, “‑Mōōmuuyē, ōng'ēētyē.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nto yu kēētōrōōr ꞉rubiichoo mētēwook, māmiitē ꞉chii ake tukul nteenee Yēēsu nkit. ");
INSERT INTO spyNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yu kimii kurēkunēē lekem, kōōkiimchi ꞉Yēēsu rubiichoo kule, “‑Mōōmwoochi chii kiyēē kookas, ākoy yoo /kaakiing'eetee *Wēritaab Chii meet.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kuteebee ꞉mbo Bētērō Yēēsu kule, “Ām nee naas, sukumwooyē ꞉kāānēētikaab kiruutēk kule māchāktōōs kōōyēēw *꞉Eliiya kurook, nto chōōnii *꞉Kāārārookiintēēt?” ");
INSERT INTO spyNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kuwālchi ꞉Yēēsu kule, “Mwooyē ꞉bichoo man. Intōōwu ꞉Eliiya sukukaramiit ꞉kiy ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","!Kāāmwoowook, kiikuchō Eliiya ānkimēēnkētē ꞉bichoo, nteenee kiyeyee kiy ake tukul nyēē kimāchē. Nto ām kēēlto nyēē wuu nyooto, makunyalil *꞉Wēritaab Chii ām āwunnyēkaab bichooto.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yooto nanyuun kōōnkēt ꞉rubiichoo kule kimiitē ꞉Yēēsu kung'āloolēē Bātisāniintēēt Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yu kāākurēk ꞉Yēēsu āk rubiichoo, kuba ākoy yoo kimiitē ꞉rubiik chuut alake kuboonto keey biiko chēē kichoong'ēch chēē kikiikōōruruuch keey. Yooto, kuchō ꞉chiito ake ānkukutunyēē taayeetaab Yēēsu ");
INSERT INTO spyNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ānkumwoochi kule, “Mokoryoontēēt, riiree wērinyuu nyēē boonto mēwuunkook. Iyiimē ꞉bōōroo miisin kutōōrchinē kwaak mā nto ku bēēko. ");
INSERT INTO spyNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kāāmutyi rubiikuuk nteenee manaakoomuuch.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yooto kumwooy ꞉Yēēsu kule, “Kunuurēch sōō, ꞉biiko alake nyēē tyaa. Nto yu manookaaseenaa keey! +Māābuurtook ākoy āyu? +Māāmuytoochook ākoy āyu? Omutwaa anii wēēroo.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kōōbēbēēto ꞉Yēēsu tāmirmiryoonoo miyaat kung'eetee wēēroo. Yooto, kusob ꞉wēēroo bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nto miitē yoo kuboonto keey Yēēsu āk rubiikyii, kuteebee ꞉rubiik kule, “So, ām nee simakiimuuch ꞉acheek tāmirmiryoonoo miyaat?” ");
INSERT INTO spyNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kuwālchi ꞉Yēēsu kule, “Kuuyu ‑mōōkoosēēnoo keey kāroomin. Kāāmwoowook, nto ōboontē kaakaaseet nyēē mining' nyēē tēē kēbuswoontēētaab *aritaaliit, nto ōmuuchē ōmwoochi tulwooni kule, ‘Ng'eetee yu ānkiiwē yuun’ kung'ēētē. Māmii ꞉kiy nyēē ibēlook. ");
INSERT INTO spyNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mēēmuuchāktōōs ꞉tāmirmiryēēt nyēē wuu nyooto, yoo manoosaay ānkōōkir āmiisyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nto yēē kimiitē kubēēsyētē ꞉tukul ām Kalilaaya, kumwoochi ꞉Yēēsu rubiikyii kule, “Mii /bokiiyokoochinē *Wēritaab Chii āwunnyēkaab biikaab kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","+/Makeebakachaa nto miitē bēsyēētaab sōmōk /kiing'eeteenaa meet.” Kiyey ꞉yooto kwoorookēniis ꞉rubiik miisin. ");
INSERT INTO spyNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yu kayit ꞉Yēēsu āk rubiikyii Kaabernaam, kukwa ꞉kāāruruukikaab *syuuruutaab *Kōōtaab Yēyiin ankuteebee Bētērō kule, “Mākwēyē ꞉kāānēētiintēēng'woong' syuuruut nyēbo Kōōtaab Yēyiin?” ");
INSERT INTO spyNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kuwālchi ꞉Bētērō kule, “Kwēyē.” Kuwo ꞉Bētērō kō, nto baanta nyooto māchē kung'alaal, kumwoochi ꞉Yēēsu kule, “Ikāsē ꞉inyiing' kule nee ōō, Simōōni? Ng'oo ꞉nyēē kwēchinē bāytooyikaab kōōrooni syuuruut? Lōkōkwaa nto biiko alak?” ");
INSERT INTO spyNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kuwālchi ꞉Bētērō kule, “Kwēchinē ꞉biiko alake.” Kumwoochi ꞉Yēēsu kule, “Ākoo tookunoot kule mākwēyē kiy ꞉lēēkōōy. ");
INSERT INTO spyNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nteenee yoo simākēēkustoochi bichu, iwē ākoy tōōliil ānkiiwiirchi ntawaaniit bēēko. Nto *burburyoontēēt nyoo bo taayta inam, ing'aany kuutiinyii. +Meenyoorte āriit beesyaanteet nyēē yēmē kukweytee ꞉biiko āyēēnku syuuruut. Iyibchi bichoo kubo syuuruut nyeenyuu ākoo nyeeng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nto mii bēsyēēt ake, kuteebee ꞉rubiik Yēēsu kule, “Ng'oo ꞉nyēē wōō ām bāytooyiisyēētaab Yēyiin?” ");
INSERT INTO spyNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kukuur ꞉Yēēsu leekwa nyēē mining' kōōyyoong'to keey rubiik ");
INSERT INTO spyNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ānkulē, “!Kāāmwoowook, yoo kamooweekse ōbuur kuu wōloo wuunto ꞉lēēkōōy chēē minkēēch, mākoy kōōwut ꞉chii ām akweek bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kunyi, nyoo yibē keey ng'wēny kuu leekwa, ku wōō ꞉nyooto miisin ām bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nto nyoo tōrōōchē chii nyēē wuu lakwani ām kaayneenyuu, kukaakutoroochaa anii. ");
INSERT INTO spyNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Chii nyoo kaken ake nyēē takukuskus ām kāāyēnēēt, kumisyinē /kēērātyi rwaa nyēē wōō kaat /ānkēētōōrchi araaray kuling'ta. ");
INSERT INTO spyNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tyaa sōō ꞉ng'wooninto nyēē mākunyōōr ꞉biiko choo kēntooy biich. Mii ꞉biiko chēē makuken biiko alak kutaya, nteenee mākung'woonchi sōō kule nee chiichoo kēnē ake. ");
INSERT INTO spyNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yoo kēēsākyiing' ꞉āwung'uung' nto kereenkeeng'uung' itayaa, itilte! Kaykay inyōōru *soboontaab kibchuulyo iboontē āwut akeenke nto ku kereeng' akeenke kusiir iboontē āwunnyēk tukwaay nto ku kērēēnkōōk tukwaay /ānkēētōōrchiing' wōlēē bo maataab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yoo kēēsākyiing' koong'uung' itayaa, ilōōtu! Kaykay inyōōru *soboontaab kibchuulyo iyuu kimekoong'nyaa kusiir iboontē koonyek tukwaay /ānkēētōōrchiing' wōlēē bo maataab kibchuulyo.” ");
INSERT INTO spyNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kitas taay ꞉Yēēsu kumwoochi rubiikyii kule, “Ōriibē keey! ‑Mōōmōōntooy ake tukul ām chu tākung'ārng'ār. Kubooyiit man, tinyē ꞉icheek malayikaanikwaa chēē boonto keey Baaba ām kibkōōnkōy ākookoy. ");
INSERT INTO spyNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yoo boonto ꞉chii kēēchiirēkyii bokol ānkubot ꞉akeenke ii, kuyēyē kule nee? Bākooktooy oob chuut tāmānwookik sokool āk sokool ankuwokucheeng'aat nyoo kābotē? ");
INSERT INTO spyNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kubooyiit man, ng'ērēchē miisin kubo nyooto akeenke kusiir chuut alak. ");
INSERT INTO spyNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ām kēēlto nyēē wuu nyooto, māchāmē ꞉kōōn nyoo mii kibkōōnkōy kubot mbo ꞉akeenke ām bichooto tākung'ārng'ār.” ");
INSERT INTO spyNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kitas taay ꞉Yēēsu kumwooy kule, “Yoo kāchoolwookēnchiing' ꞉ng'eetaabkoomēt iwēētē komos ānkuwēēboorchi lēēluutyēēnyii. Nto yoo kākāsuung', 'kukēēyisu inee. ");
INSERT INTO spyNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nteenee yoo kāmākāsuung', iwēētē keey chiito ake nto ku biich āyēēng', sukumiitē ꞉biiko āyēēnku nto sōmōku ꞉chēē chāmchiintōōs kule wuu nyooto /sikiitiil ng'ālyoo. ");
INSERT INTO spyNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nto yoo kāmākāsyi bichoo, ōmwoochi booyikaab kanisa ng'aleek tukul. Nto yoo kāmākāsyi booyichoo, ōyib inee kuu wōloo /kēēyibtooy chii nyoo ‑mēēnkētē Yēyiin nto kuu kāāruruukiintēētaab *syuuruut.” ");
INSERT INTO spyNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kitas taay ꞉Yēēsu kumwooy kule, “Kiy ake tukul nyēē ōkērē ām kōōrooni, +/makeeker ām kibkōōnkōy. Nto kiyēē ōyootē ām kōōrooni, +/makeeyaat ām kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Āmwoowook subak kule, yoo kākāsyiin ꞉biiko āyēēnku ām kōōrooni yoo sooyē kumāchē kiito ake, kuyēchinē ꞉Baaba nyoo mii kibkōōnkōy kuu wōlēē kāmāktooy. ");
INSERT INTO spyNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yoo kātuuyo ꞉biiko āyēēnku nto ku sōmōk kuyēyiisyēē kaayneenyuu, āboontē keey āk icheek.” ");
INSERT INTO spyNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nto miitē yoo kuteebee ꞉Bētērō Yēēsu kule, “Mokoryoontēēt, māchāktōōs ānyōōchi kaat ng'eetaabiya areet ata yoo kāchoolwookēnchoo? Ara, ākoy areet tisab?” ");
INSERT INTO spyNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kukētyi ꞉Yēēsu kule, “‑Mēēnyōōchinē kaat areet tisab baateey, nteenee kunyil tāmānwookik tisab āk tisab.” ");
INSERT INTO spyNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yooto kumwooy ꞉Yēēsu kule, “Wuu nyi ꞉bāytooyiisyēētaab Yēyiin: Kimwoochi ꞉bāytooyiintēēt wootwookikyii kukwa /bokeeng'alaalee wōlēē kiwuu ꞉yiisyōōnuutēkwaa. ");
INSERT INTO spyNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kiboonto ꞉wootwookiintēēt nyēē kibo taay bēsēnto nyēē wōō miisin. ");
INSERT INTO spyNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nto kuuyu ki wōō ꞉bēsēnoo nyēē kimēēmuuchē kuyaakta, kumwooy ꞉mokoryoontēēt kule /kyaalta wootwookiintoonoo āk kanyii tukul kunam wōlēē mii ꞉cheebyoosyeenyii, lōkōkyii āk kiy ake tukul nyēē kiboonto /keeyaaktee bēsēnooto. ");
INSERT INTO spyNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kukutunyēē ꞉wootwookiintoonoo taayeetaab mokoryoontēēnyii ankuriiree keey kule, ‘Lēyyē, mokoryoontēēt, tēēkōōnoo sōō bārooyinto sāāyookuung' bēsēnng'uung' tukul.’ ");
INSERT INTO spyNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kuriiree ꞉mokoryoontoonoo chiichoo ānkōōmiisyi bēsēnooto kootyaaktaayakay. ");
INSERT INTO spyNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nto yu chuytooy ꞉wootwookiintoonoo saang' kutuuyēē wootwookiintēēt nyiin ake. Kiboonto ꞉nyoo bēsēntaab nyiitēnyi nyēē mābo laat. Yooto kutēryēkyinē nyiin kumāchē kookeet ānkubērē, ‘Yookwoo bēsēnnyuu!’ ");
INSERT INTO spyNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kukutuny ꞉nyiin ankusaaysaay murēētkēy kule, ‘Murooni, tēēkōōnoo bārooyinto ēē, wē, sāāyookuung' bēsēnng'uung'.’ ");
INSERT INTO spyNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nteenee kitāyiis ꞉chiichoo ānkukwēr nyiin ākoy kōōk wokurat ākoy bēsyēēt nyēē kayaaktee bēsēnoo! ");
INSERT INTO spyNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nto yu kakas ꞉wootwookik chuut alake kiyēē kayeyakay, kunērēēkiis miisin ānkubokumwoochi mokoryoontēēng'waa kiyēē kiyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yu kakas ꞉mokoryoontēēt ng'aleechaa, kukuur wootwookiintoonoo ānkumwoochi kule, ‘Iyēku sikoran. Yu kwēēriirēē keey ꞉inyiing' āmiisuung' anii bēsēnoo kwēēboontē tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","So, kwaaming' ꞉nee simeeriiree ꞉nkinyiing' wootwookiintēēt nyiin ake?’ ");
INSERT INTO spyNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kinyēēr ꞉mokoryoontoonoo ankunam chiichoo kukerta kō kung'woonchi ākoy kuyaakta bēsēntaab biich tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kunyi, mākuyēwook ꞉Baaba nyoo mii kibkōōnkōy kuu nyooto yoo ‑mōōnyōōchinē keey kaat.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yu keewaany ꞉Yēēsu kumwooy ng'aleechaa, kung'eetee Kalilaaya ānkutākyi keey yēēmēētaab Yuuteeya. Kisyēbunēē biitēētaab koong'asiis nyēbo āynēētaab Yoortaan. ");
INSERT INTO spyNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kurub ām wōlooto ꞉biiko chēē chaang' ānkōōsoob choo kimnyoontōōs. ");
INSERT INTO spyNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nto tēē yoo, kukwoonchi *꞉Farisaayeek alake Yēēsu kumāchē kutyem, ankuteebee kule, “Chāmwēēch ꞉kiruutēk kukwet ꞉chii koorkēēnyii kubo ng'ālyoo ake tukul?” ");
INSERT INTO spyNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kuwālchi ꞉Yēēsu kule, “Manoosuman ꞉akweek siruutēk yoo mwooyē kule, yu kitoowu ꞉Yēyiin kuyēyē kōōrēēt, ‘Kiyey murēn āk koorko,’ ");
INSERT INTO spyNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ānkumwooy kule, ‘Kiyooto nyēē yēyē murēn kung'eetee kōōtaab kwaan āk kaamet ankoomut koorkēēnyii ānkunoomnyo ꞉tukwaay kuyēk kiy akeenke.’ ");
INSERT INTO spyNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mēēbērē tāku biich āyēēng', nteenee kāākuyēk kiy akeenke. Kunyoo ‑mēēbēēsyo ꞉chii kiyēē kiikōōnoomnyo ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kuteeb subak ꞉Farisaayeechaa kule, “Ām nee sukumwooy *꞉Muusa kule, kusirchinē ꞉saanteet koorkēēt barweet nyēē bārēē kooyēēyto nto kwētē koorkēēt?” ");
INSERT INTO spyNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kukētyi ꞉Yēēsu kule, “Kichāmwook akweek ꞉Muusa ōkwētē kooruukwook kuuyu wuuyēch ꞉mukuulēywēkwook. Nteenee kimāwuu nyoo yu kibo taay. ");
INSERT INTO spyNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","!Kāāmwoowook, chii nyoo kwētē koorkēēnyii ām ng'aleek chēē mānāmē keey āk martaayeet, ānkulē keemut koorkēēt ake, kukaakumarta ꞉chiichoo.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yooto kumwoochi ꞉rubiik Yēēsu kule, “Yoo ākoo wuu chu ꞉ng'aleek ām wōlēē miitē ꞉murēno āk koorkēēnyii kukaykay kumēēmutiis ꞉chii.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kuwālchi ꞉Yēēsu rubiikyii kule, “‑Mēēmuuchē ꞉chii ake tukul kucham ng'aleechu, nteenee choo kiikung'oonkyi ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Choong'ēch ꞉ng'aleek chēē yēyē biiko kumākēēsyo. Miitē ꞉alake chēē /kikēēsichē kumēēmuuchē kusich, kukilātē alak ꞉biiko nto alak, kitay kēēsyēēt kubo bāytooyiisyēētaab Yēyiin. Nyoo imuuchē kucham, kucham.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nto miitē yoo, /kiimutyi Yēēsu lēēkōōk kule kutiinyēē āwunnyēk kōōbēruur. Nteenee kiiburyoong'to ꞉rubiikaab Yēēsu bichoo. ");
INSERT INTO spyNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kumwoochi ꞉Yēēsu kule, “‑Mooraany, nteenee ōbāroochi lōkōchu minkēēch kukwa wōlēē āmiitē, kuuyu biiko chēē wuu chuutēchu ꞉chēē iwutē bāytooyiisyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yooto, kōōbēruur lōkōchoo, nto yityo kuwēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nto miitē bēsyēēt ake kuchō ꞉chiito ake ankuteebee Yēēsu kule, “Kāānēētiintēēt, nee ꞉nyēē karaam nyēē māchāktōōs ayey sāānyōōru *soboontaab kibchuulyo?” ");
INSERT INTO spyNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kuwālchi ꞉Yēēsu kule, “Ām nee yu 'keeteebeenaa kurubta keey kiy nyēē karaam? Yēyiin baateey ꞉nyēē karaam. Nto yoo imāchē siiminy nyēē karaam, iriib kiruutēkaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kuteebee ꞉chiichoo Yēēsu kule, “Imwooyē kiruutēk nkōchō?” Kulēēnchi ꞉Yēēsu, “‑Meebakach chii, ‑meemarte, ‑mēēchōōrsē, ‑mēērātyi chii ng'wiiynan, ");
INSERT INTO spyNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","iywey kōōn āk koomēt ankiicham laatyeeng'uung' kuu wōloo ichāmtooy keey.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kumwooy ꞉chiichoo kule, “Ntēē ārubē kiruutēchu tukul. Ara nee nyēē taakustaat?” ");
INSERT INTO spyNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kuwālchi ꞉Yēēsu kule, “Yoo imāchē siichurte, wee-alte kiy ake tukul nyēē iboontē ānkiikoochi bānoonik kiyēē 'kēēnyōōru. Yoo 'keeyey kuu nyooto, irubwaa. +Mēēnyōōru bāytit nyēbo man ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yu kakas ꞉chiichoo kuu nyoo, kusimikta nyēē kāng'woonchi, kuuyu ki wōō ꞉bāytit nyēē kiboonto. ");
INSERT INTO spyNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nto tēē yoo kumwoochi ꞉Yēēsu rubiikyii kule, “Wuuy sōō kule nee kucham ꞉chiito nyēē boonto bāytit bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","!Kāāmwoowook, nyumnyum kōōwut *꞉tembes koong'taab sintaaniit kusiir kōōwut ꞉chii nyēē boonto bāytit Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yu kakas ꞉rubiik ng'aleechaa, kumuuyo miisin ānkumwooy kule, “Ara ng'oo, naas, ꞉nyēē imuuchē /kiiraraach?” ");
INSERT INTO spyNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yooto kōōrōōtoot ꞉Yēēsu rubiichoo ānkumwooy kule, “Mēēmuuchāktōōs ꞉ng'aleechu ām wōlēē mii ꞉chiito, nteenee imuuchāktōōs ꞉kiy tukul ām wōlēē mii ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yooto, kumwooy ꞉Bētērō kule, “Kēēnyōōru nee ꞉acheek chu kookeebakaakte kiy ake tukul ankeerubiing'?” ");
INSERT INTO spyNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kumwoochi ꞉Yēēsu kule, “!Kāāmwoowook, yoo bāytooyiisyē *꞉Wēritaab Chii āk Yēyiin ām kōōrēēt nyoo lēēl, +mōōbāytooyiisyē ꞉akweek rubiikyuu tamanu āk āyēēng'. +Mōōtiilchinē ng'aleek ārootunwēēk taman āk āyēēng' chēbo Isrāyēēl. ");
INSERT INTO spyNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nto chii ake tukul nyēē kaakubakaakta koorin nto mbo ng'eetaabkaamet nto mbo cheebkaamet nto kwaan nto kaamet nto lēēkōōk nto ku mbareenik kubo anii, mākunyōōr tukuuchoo kunyil bokol nto miisin, mākunyōōr *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nteenee biiko choo yibē keey barak ām kōōrooni mākubooyiit lēt ām Kaab Yēyiin, nto choo yibē keey ng'wēny ām kōōrooni mākubooyiit taayta ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kitas taay ꞉Yēēsu kumwooy tyoonkōōchēēt ake kule, “Wuu nyi ꞉bāytooyiisyēētaab Yēyiin. Kimii ꞉chiito ake nyēē kiboonto mbareenyii nyēbo *musābiibuunēk. Kimusta ꞉chiichoo bēsyēēt ake kōrrōōn wokucheeng' biiko chēē kāyēchi yiisyēēt ām mbaraanaa. ");
INSERT INTO spyNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yooto kukāsyiin ꞉chiichoo āk biikaab yiisyēēt kule mākukwēchi bichooto beesaanik chēē /kikēēyēyiisyēē ām bēsyēēt akeenke. Yooto nanyuun kukwēr bichoo mbareen. ");
INSERT INTO spyNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nto yēē ki āsiiswēk sōmōk chēbo kōrrōōn, kuwo ꞉chiichoo wōlēē kiiruruukyinē keey ꞉biiko kumāchē yiisyēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kumwoochi chiichoo bichoo kule, ‘Obe ꞉nkakweek bōōyēyiisyē mbareeng'waanii, sāākwēwook kiyēē yemaat.’ ");
INSERT INTO spyNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kuba ꞉bichoo. Kiiyeey ꞉chiichoo yooto āsiiswēk chēē kimāchē kuyitē lo āk yēē kimii āsiiswēk sokool wokukwēr biiko alak. ");
INSERT INTO spyNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chokuwo subak yēē kimāchē kumii ꞉asiista taman āk akeenke. Kunyōōr subak biiko alak chēē kimii kēēyyoong'iis. Kuteebee choo kule, ‘Ām nee yu sōōyyoonyēē ꞉akweek yu kwiimēn?’ ");
INSERT INTO spyNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yooto kuwāl ꞉bichoo kule, ‘Kēēmiitē yu kuuyu māmii ꞉chii nyēē kaakusireech kēēyēchi yiisyēēt.’ Kumwoochi ꞉chiichoo bichoo kule, ‘Okwaa ꞉nkakweek bōōyēyiisyē ām mbareeng'waanii.’ ");
INSERT INTO spyNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nto yu kararakta ꞉asiista, kumwoochi ꞉chiichoo kibo mbaraanaa chiinyii nyēē kiiyyoonkyinē yiisyēēt kule, ‘Kuur biikaab yiisyēēt tukul ānkiikwēchi beesaanikwaa choo kāyēyiisyēē. Itoowunēē choo /kākēēsirē lēt ankiitas taay ākoy choo /kākēēsirē taay.’ ");
INSERT INTO spyNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yooto nanyuun, kukwa ꞉biikaab yiisyēēt choo /kikēēsirē asiistaab taman āk akeenke /ānkēēkwēchi beesaanik chēē /kikēēyēyiisyēē bēsyēēt akeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nto yu kakwa ꞉choo /kikēēnyōōyēē /kēēsirē, kubērē tōōs +/mākēēkwēchi chēē chaang' kusiir chuut, nteenee /kikēēkwēchi icheek tukul beesaanik chēē /kikēēyēyiisyēē bēsyēēt akeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kutoow ꞉akeenke kuwookuutyēē chiitaab mbareet ");
INSERT INTO spyNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","kumwoochinē kule, ‘So, ntēē kāyēyiis ꞉bichu /kātākēēsirē asiista akeenke buch, ānkii-āyēēchēēnēēch acheek chu kakyaamee keey yiisyēēt ānkēēyōōtu asiistaab bēēt?’ ");
INSERT INTO spyNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kuwālchi ꞉chiitaab mbareet chiichooto kule, ‘Lēyyē, tilyaani, nee ꞉nyēē miyaat? Kākēēkāsyiinē oob kule +/mākēēkwēwuung' beesaanik chēbo bēsyēēt akeenke? ");
INSERT INTO spyNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wēēchi keey! Kaacham ākwēchi chiito nyoo kāchōōnii lēt beesaanik chēē tēē cheekuuk. ");
INSERT INTO spyNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ākoo ‑māāboontē ꞉anii kāāmuukēywēēk ayeyee beesaanikyuu kiyēē āmāchē ayeyee? Nto katuuyiitiing' keey ꞉moo kubo mooyēēnyuu nyēē lēēl ōō?’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yooto kooteryeech ꞉Yēēsu kule, “Nteenee biiko choo yibē keey ng'wēny mākubooyiit taayta, nto choo yibē keey barak mākubooyiit lēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nto yu kimiitē ꞉Yēēsu kōōtōōchē Yēērusālēēm kuwēēto rubiikyii taman āk āyēēng' komos ānkumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“!Kookas, kēēmiitē kēēbēētii ākoy Yēērusālēēm. +/Mābokiiyokoochi *Wēritaab Chii mbo kibkōrōs chēē wōōyēch ākoo kāānēētikaab kiruutēk. Makooruustaa /keebakachaa ");
INSERT INTO spyNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ānkōōyokoochoo biikaab Rooma. Mākōōntosuuroo ꞉choo ānkubirsēētoo kulālchoo ānkukwērtoochoo *murtooywoontēēt. Nto miitē bēsyēētaab sōmōk +/makiing'eeteenaa meet.” ");
INSERT INTO spyNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nto miitē yoo, kuchōōnto ꞉cheebyoosyeetaab Sebetaayo wērikyii ānkukutunyēē taayeetaab Yēēsu kumāchē kusoomso. ");
INSERT INTO spyNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kuteebee ꞉Yēēsu kule, “Imāchē nee?” Kuwāl ꞉cheebyoosyaanaa kule, “Chāmwoo kōōbuurunēēniing' ꞉wērinyuu ake āwutaab taay kōōbuurunēē ꞉ake āwutaab kaataam ām Bāytooyiisyēēng'uung' nyoo chōōnii.” ");
INSERT INTO spyNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kumwoochi ꞉Yēēsu kule, “‑Mōōnkētē kiyēē ōsoomē. Ōmuuchē ꞉akweek ocham ōbuntēē nyāliluutēk chēē +māānyōōru ꞉anii?” Kuwālchi ꞉bichoo Yēēsu kule, “Kiimuuchē.” ");
INSERT INTO spyNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kumwoochi ꞉Yēēsu kule, “+Mōōnyāliilchē sinee kuu anii, ānkoo kuwuu nyooto, ‑māāboontē kāāmuukēywēēk ākōōnook ātēbto nyēbo āwutaab taay nto ku nyēbo kaataam. Baaba Yēyiin ꞉nyēē yēytoochinē biiko bārooyinwēchoo.” ");
INSERT INTO spyNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yu kakas ꞉rubiik chuut alake tamanu ng'aleechaa, kunyēērchi murēchooto āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yooto kukuur ꞉Yēēsu rubiichoo tukul ānkumwoochi kule, “Ōnkētē kule bāytooyik chēē mii kōōrooni kumāchē kōōboorchi biiko alak kule icheek ꞉chēē bāytooyiisyē ānkuboonto kāāmuukēywēēk kubiir chuut. ");
INSERT INTO spyNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nteenee ‑mookany kuwuuyiit nyooto ām wōlēē ōmiitē ꞉akweek. Kunyoo yoo māchē ꞉chii ām akweek kuyēk nyēē wōō, kumāchāktōōs kuyēētyēēchinē chuut. ");
INSERT INTO spyNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nto nyoo māchē kubāytooyiis, kumāchāktōōs kuyēchinē chuut yiisyēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kyāāchōōnii *Wēritaab Chii sichāāyēchi biiko yiisyēēt, āmēēbērē kyāāchōōnii /subokēēyēwoo. Kichāākooytē soboonnyuu sukusobcho ꞉biiko chēē chaang'.” ");
INSERT INTO spyNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nto yu ng'ēētēē ꞉Yēēsu Yēērikō ākoo rubiikyii, kurub lēt ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kimii ꞉biiko alake āyēēnku chēē kikōryootiin kēēbuurēē kēēlto komos. Yu kēēnkēt kule ki Yēēsu ꞉nyi kimii kukēēytooy, kukuurchi barak kule, “*Mōchōkōrēētaab Tāwuti, iriireeneech, ankiiriireeneech!” ");
INSERT INTO spyNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kōōburyoong'to ꞉biiko kule, “Ōsiisyē!” Nteenee kukuurchi barak ꞉bichoo miisin kule, “Mōchōkōrēētaab Tāwuti, ankiiriireeneech!” ");
INSERT INTO spyNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kōōyyo ꞉Yēēsu ankuteebee cheebkoraatiisyechaa kule, “Ōmāchē āyēwook nee?” ");
INSERT INTO spyNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kuwālchi kule, “Mokoryoontēēt, kēēmāchē keekaste.” ");
INSERT INTO spyNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kukāsyi ꞉Yēēsu bichoo kiisayta ānkutiiny koonyekwaa. Kukasta ꞉bichoo areet akeenke ankurub Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nto yu kariikta ꞉Yēēsu āk rubiikyii saang'ta ake nyēē /kikēēkuurēē Beetfaaka ām Lekemeetaab *Musēytuuniinēk, ");
INSERT INTO spyNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kumwoochi rubiikyii āyēēng' kule, “Obe ākoy saang'iin. +Mābōōnyōōru sikiryo nyēē siirwaak nyēē boonto keey kaamet. Otyaach tukwaay ānkōōkwērwoo. ");
INSERT INTO spyNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nto yoo kateebeenaak ꞉chii ng'ālyoo, ōlēēnchi māchē ꞉Mokoryoontēēt ānkumākukēt areet akeenke.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kiityiich ꞉ng'aleechu kiyoo kimwooyē *꞉wōōrkooyoontēēt ake kule, ");
INSERT INTO spyNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ōmwoochi biikaab Yēērusālēēm kule. Ong'nyoo bāytooyiintēēng'woong'. Miitē kuchōōnii wōlēē ōmiitē. Yiboot keey ng'wēny ānkuchōōnēē sikiryo nyēē siirwaak.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yooto nanyuun kuba ꞉rubiichoo āyēēnku ankubokuyey kuu yoo kimwoochinē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kibokootyaach ānkukwēr siirwaakaanaa bo sikiryo āk kaamet. Yu kayit, kwaalyaktee sikiroochoo tukwaay sirookwaa chēē /kiiliiktēē keey, nto tēē yoo kutēbēē ꞉Yēēsu nyoo ki siirwaak. ");
INSERT INTO spyNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yooto kōōyiitoochinoot ꞉biiko chēē chaang' sirookwaa kēēltaab too, nto alak kubutoot sokēēkaab sōōsik kōōkoochinoot kēēlooto kōōboor koonyit. ");
INSERT INTO spyNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kityēēnchinootē barak ꞉biiko chēē kimii taay āk chēē kimii lēt kumwooyē kule, “Kutōrōriit *꞉Mōchōkōrēētaab Tāwuti! Ibēruuroot ꞉nyi chōōnii ām kaayneetaab Yēyiin! Kutōrōriit ꞉Yēyiin ām kibkōōnkōy!” ");
INSERT INTO spyNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kuyitu Yēērusālēēm, kōōwāywooytōōs ꞉biiko tukul ānkutēēbē kule, “So, ng'oo ꞉nyi?” ");
INSERT INTO spyNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kuwāl ꞉bichoo kikwoontooy keey Yēēsu kule, “Wōōrkooyoontēēt Yēēsu ꞉nyi, nyoo bo Nāāsārēēt ām Kalilaaya.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nto tēē yoo, kōōwut ꞉Yēēsu biiwuutaab *Kōōtaab Yēyiin. Kimii yooto ꞉biiko chēē kiwālāng'tooy beesaanik āk alak chēē kyooltooy chēēbtuukēēnikaab kōrōsēēk āk cheemung'aariisyek alak. Kuwunukto ꞉Yēēsu meesoosyekaab bichoo kiwālāng'tooy beesaanik kōōtyēēlākiis. Kiityeel mbo nkicheek ng'ēchērōōkaab choo kyooltooy chēēbtuukēēnik ankukwet bichoo tukul kuba saang'. ");
INSERT INTO spyNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kimwoochinē ꞉Yēēsu bichoo kule, “Mwooyē ꞉siruutēk kule, ‘Bo ꞉Kōōnyuu saayeet,’ nteenee kyooweech ꞉akweek ‘kuyēk kēbēnnyoo nyēbo sāsiik.’” ");
INSERT INTO spyNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yooto /kiimutyi Yēēsu cheebkoraatiisyek āk chēē kichunkutootiin. Kōōsoob ꞉Yēēsu bichoo. ");
INSERT INTO spyNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kinyēēr ꞉mbo *kibkōrōs chēē wōōyēch āk kāānēētikaab kiruutēk miisin yu kakas ng'aleek chēbo kwōng'uut chēē kiyey ꞉Yēēsu āk wōlēē kityēēntooy ꞉lēēkōōk ām biiwuutaab *Kōōtaab Yēyiin kōōkoostooy Yēyiin kule, “/Kiikaasta *Mōchōkōrēētaab Tāwuti!” ");
INSERT INTO spyNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yooto, kumwoochi ꞉bichoo Yēēsu kule, “Imiitē ikāsē kiyēē mwooyē ꞉lōkōchu ēē?” Kulēēnchi ꞉Yēēsu, “Ēē, ākāsē. Manoosuman ꞉akweek yēēt ake ām siruutēk yoo mwooyē kule, ‘Kiiyey ꞉inyiing' Yēyiin kookaastiing' ꞉lēēkōōy āk chēērērōōk?’” ");
INSERT INTO spyNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kung'eetee ꞉Yēēsu Yēērusālēēm ānkuwokurwoowunēē *kiriinkēētaab Beetannyaa. ");
INSERT INTO spyNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nto yu kāyyēēkunēē kumiitē ꞉Yēēsu kōōyēēyē Yēērusālēēm, kwaam ꞉kēmēy. ");
INSERT INTO spyNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kukas kēētit ake nyēē /kēēkuurēē *mutiiniit nyēē kimii kēēlto komos, kuwo yooto. Kimanaayey ꞉kēētoo lokoyeek nteenee kitinyē sokēēk chēē kituumtuumēn kityō. Kuchub ꞉Yēēsu kēētooto kule, “‑Mataweeyey lokoyeek yēēt ake!” Kumwooyē kuu nyooto kuyoomē ꞉kēētoo bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kukāsē ꞉rubiik ng'aleechu kumuuyo ankuteebee keey kule, “So, keeyaam ꞉nee mutiiniini areet akeenke?” ");
INSERT INTO spyNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kumwoochi ꞉Yēēsu rubiichoo kule, “!Kāāmwoowook, yoo ōkoosēē keey Yēyiin ām mooyēēt akeenke, ōmuuchē oyey kiyēē kāāyēchi ꞉anii mutiiniini, āmēēbērē nyooto sōō, baateey, nteenee ōmuuchē mbo ōmwoochi lekemeet kule, ‘Ng'eet ānkuwēēwiirchi keey araaray,’ kuyēyē ꞉lekemaanaa kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yoo ōkoosēēnoo keey, ōnyōōru kiy ake tukul nyoo ōsooyē.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nto yu kēēyēēw ꞉Yēēsu biiwuutaab *Kōōtaab Yēyiin, kutoow kōōnēētiis. Yooto kukwa ꞉mbo *kibkōrōs chēē wōōyēch āk booyik ankuteebee kule, “Kāāmuukēy nee chēē iyēyēē ꞉inyiing' ng'aleechu? Ānku ng'oo ꞉nyēē kōōniing' kāāmuukēywēēchooto?” ");
INSERT INTO spyNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kuwālchi ꞉Yēēsu bichoo kule, “+Maateebeenaak ꞉nkanii tēēbuutyēēt akeenke. Yoo kōōwālwoo, +māāmwoowook chiichēē kikōōnoo kāāmuukēywēēk ayey ng'aleechu. ");
INSERT INTO spyNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ātēēbē kule ii, kikwoonēē ānō ꞉kāāmuukēywēēk choo kiibātisāniisyēē ꞉Yoowaana? Ara kikwoonēē wōlēē mii ꞉Yēyiin nto wōlēē mii ꞉biich?” Kulēēnchi keey ꞉bichoo nkityōōniin, “Yoo kakeemwaay kule kikwoonēē ꞉kāāmuukēywēēkyii wōlēē miitē ꞉Yēyiin kutēēbēēnēēch kule, ‘Ntēē simōōyēnchi?’ ");
INSERT INTO spyNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nteenee kēēnyōkōōrēch keemwaay kule kikwoonēē wōlēē mii ꞉biiko, kuuyu chāmchiintōōs ꞉biiko tukul kule ki *wōōrkooyoontēētaab Yēyiin ꞉Yoowaana.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yooto kuwālchi ꞉bichoo Yēēsu kule, “‑Mākiinkētē.” Kumwoochi ꞉Yēēsu bichoo kule, “‑Māāmwoowook ꞉nkanii chiichēē kikōōnoo kāāmuukēywēēk ayey ng'aleechu.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kumwoochi ꞉Yēēsu bichoo kule, “Mii yu ꞉ng'ālyoo. Kimii yēēt ake ꞉chiito ake nyēē kiboonto wērikyii āyēēng'. Nto tēē yoo, kumwoochi ꞉kwaan wēēriit nyēē wōō kule, ‘Wēnyoo, iwē ra mbareetaab *musābiibuunēk wēēyēyiisyē.’ ");
INSERT INTO spyNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kulēēnchi ꞉wēēroo kwaan, ‘‑Māāmāchē.’ Nto nyēē mā tyaa, kuweech kāāsōōtēywēēkyii ānkuwo. ");
INSERT INTO spyNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kuwēēchi ꞉boontoonoo wēēriit nyēē mining' ānkumwoochi nkinee kuu yoo kāmwoochinē nyiin. Kumwooy ꞉nyoo kule, ‘Āwēētii ōō, āboonyuu,’ āmāwo. ");
INSERT INTO spyNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nkōnō ām wērichoo ꞉nyēē kiyey kiyēē kimāchē ꞉kwaan?” Yu kateeb ꞉Yēēsu kuu nyooto, kuwālchi ꞉bichoo kule, “Nyoo ki wōō.” Kumwoochi ꞉Yēēsu bichoo kule, “!Kāāmwoowook, imuuchāktōōs kuba Kaab Yēyiin ꞉kāāruruukikaab *syuuruut ākoo chēēmurēniisyēk tōōmiitē ꞉akweek. ");
INSERT INTO spyNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Āmwooyē kuu nyooto kuuyu kichokōōboorwook ꞉Bātisāniintēēt Yoowaana kēēlto nyēbo churtaayeet ankootay ꞉akweek ōyēnchi, nteenee kiiyēnchi ꞉kāāruruukikaab syuuruut ākoo chēēmurēniisyēk. Ānkoo mbo yu kabookas kēēyēnchi ꞉bichoo, manooweeksee ng'ōōkiswookikwook ānkōōyēnchi.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kimwoochi subak ꞉Yēēsu bichoo kule, “Ōyēbchi yiit subak tyoonkōōchooni: King'eet ꞉chiito ake kuchaan *musābiibuunēk mbareenyii ankuker. Nto yityo kubal ng'wēēnēēt nyēē sukurōōtyinē ꞉muumēēkaab lokoyeekaab kēētoo yoo /kakiireem. Kiteech mbo kēryēēt nyēē sukuriibēē ꞉chiito mbaraanaa. Nto tēē yoo, kumwoochi biiko alak bokuriibchi mbaraanaa si yoo kāākururyo ꞉musābiibuunēchoo kubchēchiin. Nto kāākuyityo, kuruuto ꞉chiitaab mbareet. ");
INSERT INTO spyNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Yu kābokururyo ꞉lokoyeechaa, kōōyook ꞉chiitaab mbareet motwoorikyii bokuyibchi inee kereeryaanteet nyeenyii nyēbo musābiibuunēk. ");
INSERT INTO spyNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yu kayit, kunam ꞉bichoo kiriibē mbaraanaa motwooriintēēt akeenke ānkubirsēēt. Kibakach ake nto nyiin ake, kuwiiraatee rwoontōōk. ");
INSERT INTO spyNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kōōyookto subak ꞉chiichoo motwoorik alak chēē kēēytēē choo kibo taay. Nteenee /kibokēēyēchi nkicheek ng'aleek chēē wuu choo /kikēēyēchinē chuut. ");
INSERT INTO spyNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nto nyēbo lēt kutukul kōōyookto ꞉chiichoo wērinyii kuwo mbaraanaa kubērē tōōs makooywey ꞉bichooto. ");
INSERT INTO spyNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nteenee kukāsē ꞉bichoo wēritaab chiichoo, kukuurē keey bakeenke kule, ‘Murēchu, ong'nyi lakwataab chiichiito! Okany keebakach sikēēyibchi keey mbaraani.’ ");
INSERT INTO spyNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kunam ꞉bichoo wēēroo ānkukwēryoot kuwo tuuyta saang' ankubakach! ");
INSERT INTO spyNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kunyoo, yoo chōōnii ꞉chiitaab mbareet ii, chokuyēyēē nee bichooto kiriibē mbareenyii?” ");
INSERT INTO spyNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kuwāl ꞉biiko kule, “Bākāchē kibng'ōōkisiisyēchoo ānkōōkoochi mbaraanaa biiko alak chēē imuuchē kuriibchi sukōōkoochinē inee kereeryaanteet nyeenyii.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yooto kumwoochi ꞉Yēēsu bichoo kule, “Kyoosuman oob ām siruutēkaab Yēyiin yoo mwooyē kule, ‘Rwaanteet nyoo kitāyē ꞉biiko kuteekta ꞉nyēē kōōkuyēk tiiyēywoontēētaab kōōto. Kōkōōnu ꞉Yēyiin tiiyēywoontooni ānkubo kwōng'uut sōō nyēē tyaa yoo kēēkāsē!’ ");
INSERT INTO spyNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kunyoo āmwoowook kule +/mākiinēmunēēnook bāytooyiisyēētaab Yēyiin /ānkiikoochi biiko choo makuyey ng'aleek chēē chāmē ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Chii ake tukul nyēē karyaach rwaantaanaa, makutirtir. Nto nyoo kēēsuuchi ꞉rwaantaanaata, kuruurumē.” ");
INSERT INTO spyNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nto yu kakas ꞉mbo kibkōrōs chēē wōōyēch ākoo *Farisaayeek tyoonkōōchoonoo, kōōnkēt kule king'āloolēē ꞉Yēēsu icheek. ");
INSERT INTO spyNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yooto kucheeng' kēēlto nyēē kanamee Yēēsu, nteenee kinyōkōriitu biiko chēē ki chaang' ām yooto kuuyu kiiyēnchiintōōs ꞉bichooto kule *wōōrkooyoontēētaab Yēyiin ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kitas taay ꞉Yēēsu kumwoochi biiko tyoonkōōchēēt ake subak kule, ");
INSERT INTO spyNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Wōlēē wuu ꞉bāytooyiisyēētaab Yēyiin kumii kule: Kimii ꞉bāytooyiintēēt ake nyēē kiyēytoochi wērinyii saakweetaab kooyēēyto. ");
INSERT INTO spyNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nto tēē yoo, kōōyookto motwoorikyii bokukuuroot tāyēēk chēē kimāchāktōōs kukwa saakweet. Nteenee kutay ꞉tāyēēchoo kukwa. ");
INSERT INTO spyNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kōōyookto subak motwoorikyii alak kule, ‘Bōōmwoochinootē tāyēēchooto kule kaayeeny yeeyiik āk wuunōōk chēē lumlumēch. Ōkwoonchi keey kyaam saakweenyoo kuuyu kāāchōb ꞉anii kiy ake tukul.’ ");
INSERT INTO spyNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nteenee kitay ꞉bichoo ng'aleechaa ānkubēēchi keey. Kiwokuyēyiis ꞉ake ām mbareenyii nto ake kuwo mung'aareenyii. ");
INSERT INTO spyNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kunam ꞉choo king'ētu motwoorikaab chiichoo, koonyaliilset ankubakach alak. ");
INSERT INTO spyNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yooto kunyēēr ꞉bāytooyiintoonoo ānkōōyookto biikyii bo lukēēt bokwaaraanta rumiichoo ankubeel kiriinkēēng'waa. ");
INSERT INTO spyNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nto tēē yoo kumwoochi motwoorikyii kule, ‘Kāākuchōbākoy ꞉saakwaanēēb kooyēēy. Nteenee kāmēētākunyoolunoot kukwa ꞉biiko choo kwāākuurē. ");
INSERT INTO spyNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kunyoo, obe wōloo bo sachaaraan bōōmwoochi chii ake tukul nyēē kōōnyōōru kuchō saakwaani.’ ");
INSERT INTO spyNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kubeetaat ꞉motwoorichoo bokōōruruuch biiko tukul chēē kiimuuch kunyōōr nyēē mātiny kule ng'oo ꞉ng'oo. Kiwool keey ꞉tāyēēk kut kunyiy ꞉kōōtaab saakwa. ");
INSERT INTO spyNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nteenee yu kāwokuchō ꞉bāytooyiintēēt chokukas tāyēēk, kukas chiito ake nyēē kimaneelaach sirook chēbo saakweetaab kooyēēyto choo /kikiikiikoochi. ");
INSERT INTO spyNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kuteebee ꞉boontēētaab saakwa chiichoo kule, ‘Nto ii, tilyeenyuu, 'kēēchōō ꞉inyiing' kule nee kō āmā sirookaab saakweetaab kooyēēyto?’ Kusiis ꞉chiichoo āmā ng'ālyoo. ");
INSERT INTO spyNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nto tēē yoo kumwoochi ꞉bāytooyiintēēt motwoorikyii kule, ‘Orat chiichi āwunnyēk ākoo kērēēnkōōk ānkōōwiirchi saang' wōliin bo mēēnānēēt wokung'woonchi ꞉soboon ankuriirunee ng'wēny.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kiiwoong' ꞉Yēēsu tyoonkōōchoonoo kumwooyē kule, “Chaang' ꞉biiko chēē kuurootiin nteenee churtooy ꞉chēē ng'ēri.” ");
INSERT INTO spyNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kikwaany keey ꞉moonikaab *Farisaayeek nto yooto, bokung'alaalee kiyēē makutechee Yēēsu sukunam. ");
INSERT INTO spyNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yooto, kōōyookto ꞉bichoo biikwaa āk chēbo *Ērōōtē kubēēchi Yēēsu. Kuyitē kumwoochinē Yēēsu kule, “Kāānēētiintēēt, kiinkētē kule 'ibooyē manta ānkiinēētē biiko ām kēēlto nyēbo man kōōnkēt kiyēē māchē ꞉Yēyiin. Māwēēchiing' ꞉chii ānkoo ku inee ku ng'oo. ");
INSERT INTO spyNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kunyi ii, mwoowēēch, baa, kāāsōōtēywēēkuuk, ara karaam kēēkwēchinē bāytooyiintēētaab Rooma *syuuruut nto miyaat?” ");
INSERT INTO spyNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nto kuuyu kiinkētē ꞉Yēēsu ruurumuung'waa, kumwoochi kule, “Ōyēku sōō, kiblembechiis nyēē tyaa! Kābōōtēkyoo nee? ");
INSERT INTO spyNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ōbooru baa, ꞉akweek beesyaantaanaata /kēēkwēytēē syuuruut.” /Kiiboorchi beesyaanteetkēy. ");
INSERT INTO spyNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kuteebee bichoo kule, “Bo ng'oo ꞉mēti āk kaaynaani mii beesyaantaani?” ");
INSERT INTO spyNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kuwāl ꞉biikēy kule, “Bo bāytooyiintēētaab Rooma.” Yooto nanyuun, kumwoochi ꞉Yēēsu bichoo kule, “Māchāktōōs ōkoochi bāytooyiintoonoo kiinyii, nto Yēyiin, ōkoochi nyēē nyeenyii.” ");
INSERT INTO spyNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yu kakas ꞉bichoo ng'aleechaa, koolat, nto tēē yoo kubēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nteenee kukwoonchi subak Yēēsu *꞉Satukaayeek alake bēsyoonooto. Kiiyēnchinē ꞉bichoo kule yoo kaakume ꞉chiito, kukaakume kutukul nyēē mēēbērē wokung'ēētēē meet bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yooto, kuteebee ꞉bichooto Yēēsu kule, “Kāānēētiintēēt, mwooyē ꞉kiruutēkaab Yēyiin choo kikōōnu *꞉Muusa kule yoo kame ꞉chiito āmānāāsikyiin leekwa ākoo koorkēēnyii, kōōntiiyē ꞉ng'eetaabkaametiitaab chiichooto koorkoonoo, sukusikyi nyiin lēēkōōk chēē /sikēēkuurtēē. ");
INSERT INTO spyNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kunyoo ii, ntēē kimii ꞉chiito ake kēny nyēē kiboonto wērikyii tisab. Nto yu kāwokuwōōyiit ꞉wēēriit kibooreetyeet, kukēēsyo. Nto mii yoo, kumēēchi keey nyēē mānāāsikyi ꞉koorkoonoo leekwa. ");
INSERT INTO spyNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kōōntiiyiis ꞉wēēriit nyēē kirubu nyooto kimēē. Kiibuurchiin ꞉nkinee ākoo koorkoonoo ankume āmānāāsikyiin āk koorkoonoo leekwa. Kōōntiiyiis ꞉wēēriit nyēē kibo sōmōk. Kōōbuurto keey ꞉nyoo nkinee koorkoonoo, nto mii yoo, kume ꞉nkinee nyēē mānāānyōōr leekwa. Kiyeyakay kuu nyooto kut kubēk ꞉wērichoo tukul āmā lēēkōōy. ");
INSERT INTO spyNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nto mii lētuunoo, kume ꞉nkinee koorkoonoo. ");
INSERT INTO spyNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kunyoo, kēēmāchē imwoowēēch: Mākubooyiit ng'oo ꞉koorkoonoo kōōyyiin kāng'ēētyēē ꞉bichooto tukul meet, kuuyu kubooyiit man, kiikoomut ꞉bichoo tukul koorkoonoo?” ");
INSERT INTO spyNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kuwālchi ꞉Yēēsu kule, “Ōkustootiin kuuyu ‑mōōnkētē ꞉akweek kiyēē ibooru ꞉siruutēkaab Yēyiin āk wōlēē wuu ꞉kāāmuukēywēēkyii. ");
INSERT INTO spyNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yoo kāākung'ēētyēē ꞉biiko meet, mēēbērē tākōōmutē keey subak. Ibuurē kuu ꞉malayikaanikaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nteenee kurubta keey ng'eeteetaab meet nyēbo biiko choo kiikubēk ii, mwoowook nee ꞉Yēyiin ");
INSERT INTO spyNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","yoo mwooyē kule, ‘Anii Yēyiintēētaab *Abraam, Isaka ākoo Yāākōbō’? Yoo /kakeemwa kule bo ꞉Yēyiin anum, kōōbooru ꞉yooto kule tākusoboot ꞉chiichooto ānkoo kiikume kēny.” ");
INSERT INTO spyNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yu kakas ꞉bichoo ng'aleechaa, koolat wōlēē kiinēētitooy ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nto yu kakas *꞉Farisaayeek kule kaakoomuukta ꞉Yēēsu *Satukaayeek, kōōruruuch keey. ");
INSERT INTO spyNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nto tēē yoo, kutyem ꞉kāānēētiintēēt ake nyēbo kiruutēk Yēēsu, kuteebee kule, ");
INSERT INTO spyNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nto ii, kāānēētiintēēt, kiruutyēēt nkōnō ꞉nyēē wōō ām kiruutēkaab *Muusa?” ");
INSERT INTO spyNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kuwālchi ꞉Yēēsu kule, “Mwooyē ꞉siruutēk kule, ‘Icham Yēyiintēēng'uung' ām mooyēēng'uung' tukul, soboonng'uung' tukul, āk kāāsōōtēywēēkuuk tukul.’ ");
INSERT INTO spyNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kiruutyēēt ꞉nyiitēnyi nyēbo koomānuut ānku wōō ām tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nto nyēbo āyēēng' kōōrōōbērē nyiin kumwooyē kule, ‘Icham laatyeeng'uung' kuu wōloo ichāmtooy keey.’ ");
INSERT INTO spyNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iyumē ꞉kiruutēchuutēchu āyēēnku kiruutēkaab Muusa tukul ākoo siruutēkaab *wōōrkooyik.” ");
INSERT INTO spyNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kumiitē *꞉Farisaayeek kukēēruruuch keey, kuteebee ꞉Yēēsu kule, ");
INSERT INTO spyNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ōsōōtē nee ꞉akweek kurubta keey *Kāārārookiintēēt nyoo ōkānyoonu? Chōōnēē kōōtaab ng'oo?” Kuwāl ꞉bichoo kule, “Kōōtaab *Tāwuti.” ");
INSERT INTO spyNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kukētyi ꞉Yēēsu kule, “Ām nee, naas, sukumwoochi ꞉Tāmirmiryēētaab Yēyiin Tāwuti kukuur Kāārārookiintēēt kule ‘Mokoryoontēēt’? Kimwooy oob ꞉Tāwuti kule, ");
INSERT INTO spyNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kimwoochi ꞉Yēyiin Mokoryoontēēnyuu kule: Ibuurunēē āwunyuu nyēbo taay ākoy yoo kaayeyiing' itēbēē buunikuuk.’ ");
INSERT INTO spyNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kunyi, yoo kuurē ꞉Tāwuti Kāārārookiintēēt kule ‘Mokoryoontēēnyuu’ kōōmuuchāktōōs kule nee kuchōōnēē ꞉Kāārārookiintēēt kōōtaab Tāwuti?” ");
INSERT INTO spyNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mānāākēt ꞉chii ake tukul ng'ālyoo amanaatakukany ꞉bichoo kuteebee Yēēsu tēēbuut ake tukul kung'eetee yooto kuwo taay. ");
INSERT INTO spyNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nto miitē yoo, kumwoochi ꞉Yēēsu rubiikyii ākoo biiko chēē kimii yooto kule, ");
INSERT INTO spyNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yibē keey *꞉Farisaayeek āk kāānēētikaab kiruutēk kule icheek chēē inkētē koobanybaany siruutēkaab *Muusa. ");
INSERT INTO spyNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ōkāsē sinee kiy ake tukul nyēē mwoowook, nteenee ‑moorub yēyuutēkwaa kuuyu māyēyē ꞉icheek kiyēē inēētē. ");
INSERT INTO spyNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ing'irēē biich ꞉bichu tukuuk chēē nyikiisēch āmāmāchē ꞉icheek mbo kut kutiiny tukuuchooto. ");
INSERT INTO spyNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yēyē kiy ake tukul kumāchē kule sukukas ꞉biiko kule kiikōōnēmchi keey ꞉icheek Yēyiin. Iwōōyiitē tukuuk chēē mii ꞉siruutēkaab Yēyiin ānkuryookyi keey tokoch āk wōlēēb āwuun. Ikōōyiitē mbo maaseekaab sirookwaa kusiir chēbo biiko alak /sikēēbērē tōōs sooyē ꞉icheek miisin! ");
INSERT INTO spyNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kicham ꞉bichoo kutēbēē wōloo /kēēkoonyitē ām sookwoonuut āk ng'ēchērōōk choo bo taay ām kooriikaab saayeet. ");
INSERT INTO spyNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kicham /kiisubooyootē nyēbo koonyit ām wōlēē chaang' ꞉biich ankicham /kēēkuurē ām koonyit kule ‘Mokoryoontēēt’. ");
INSERT INTO spyNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‑Mookany kukuurook ꞉chii kule ‘Mokoryoontēēt’ kuuyu Mokoryoontēēt ku akeenke baateey ānkōōtuubchē ꞉akweek tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Āmōōtōrōōr chii ām kōōrooni kule ‘Baaba,’ kuuyu ōboontē Kōōn akeenke ānkumiitē kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","‑Moocham kukuurook ꞉chii kule ‘Kāāntōōyiin nyēē wōō’ kuuyu ōboontē Kāāntōōyiintēēt nyēē wōō akeenke nto nyooto ku *Kāārārookiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nyēē wōō miisin ām akweek ku nyoo yēētyēēchinē chuut. ");
INSERT INTO spyNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chii nyoo yibē keey barak +/makiichuchuuk nto nyoo yibē keey ng'wēny, +/mākiitōrōōr.” ");
INSERT INTO spyNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kitas taay ꞉Yēēsu kumwooy kule, “Ōmiitē sōō, nyēē miyaat kule nee ꞉akweek kāānēētikaab kiruutēk ākoo *Farisaayeek, kiblembechiisyechu! Ōkērēē keey kurkeet nyēē wēētii Kaab Yēyiin nyēē ‑mōōbāroochinē biiko alak kōōwut āmēēbērē ōwutē ꞉akweek mbo nkityō. ");
INSERT INTO spyNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ōmiitē sōō, nyēē miyaat kule nee ꞉akweek kāānēētikaab kiruutēk āk Farisaayeek, kiblembechiisyechu! Ōmbākootēē tōōliiloon āk rōōrōōkiis ōmāchē ōnyōōru chiito akeenke nyēē karubaak. Nto yoo kōōnyōōru, oyey bichoo koolaambuuch ꞉ng'ōōkistaab Kibrōkōsyoontēēt kusiirook. ");
INSERT INTO spyNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ōmiitē sōō, nyēē miyaat kule nee ꞉akweek cheebkoraatiis choo ōrēētootē alak! Ōnēētē kule, ‘Yoo keewaalee keey ꞉chii *Kōōtaab Yēyiin, māmii ꞉ng'ālyoo, nteenee yoo keewaalee keey *ta-aabuutaab Kōōtaab Yēyiin kunāmē muumeekyii.’ ");
INSERT INTO spyNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Cheebkoraatiisyechu, ōbērbērēch sōō, nyēē tyaa. Nkōnō nyēbo koomānuut kubiir ake: ta-aabuut nto Kōōtaab Yēyiin nyoo itiliilē ta-aabuut? ");
INSERT INTO spyNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ōmwooyē mbo subak kule, ‘Yoo keewaalee keey ꞉chii *kāābkōrōs ām Kōōtaab Yēyiin, kumāmii ꞉ng'ālyoo, nteenee yoo keewaalee keey kiyēē tuwēntooy kubo kōrōsēēk, kunāmē ꞉muumeekyii.’ ");
INSERT INTO spyNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ōkōryootiin sōō, nyēē tyaa. Nkōnō nyēbo koomānuut kusiir ake: kōrōsēēk nto kāābkōrōs nyoo itiliilē kōrōsēēk? ");
INSERT INTO spyNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kunyoo, yoo keewaalee keey ꞉chii kāābkōrōs, kaakoowaalee keey nkinee kiito nyoo /kākēēsooytooy ām kāābkōrōs. ");
INSERT INTO spyNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nto nyoo iwoolēē keey Kōōtaab Yēyiin, kaakoowaalee keey Kōyooto ākoo nyoo minyē āriit. ");
INSERT INTO spyNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nto nyoo iwoolēē keey kibkōōnkōy, kaakoowaalee keey ng'echereetaab bāytooyiisyēēt bo Yēyiin ākoo nyoo ibuurēē ng'echeraanaata.” ");
INSERT INTO spyNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kitas taay ꞉Yēēsu kumwooy kule, “Ōmiitē sōō, nyēē miyaat kule nee ꞉akweek kāānēētikaab kiruutēk ākoo *Farisaayeek, kiblembechiisyechu! Ōkoochinē Yēyiin akeenke ām taman nyēbo tukuuchoo /kiitōōyēē āmiik. Nteenee kyookweeste ng'aleekaab koomānuut ām Mākuutēkaab Yēyiin. Chooto ku manta, kiisayta ākoo kaakaaseet. Karaam ōkoochinē Yēyiin ng'ooluutyēēng'woong' nteenee karaam miisin ōyēyē ng'aleechaa alak. ");
INSERT INTO spyNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cheebkoraatiisyechu irēētootē biich! Ōyiimēē keey tukun chēē minkēēch ankoobakaakte tukun chēbo koomānuut. ");
INSERT INTO spyNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ōmiitē sōō, nyēē miyaat kule nee ꞉akweek kāānēētikaab kiruutēk ākoo Farisaayeek! Kiblembechiisyechu! Okerkeeye tērēkōōy chēē /kiiwuunē wōlēēb saang' nto wōliin bo āriit kutuuryootiin. ");
INSERT INTO spyNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ōkōryootiin ꞉Farisaayeek! Ōwuunē kurook terekyeet āriit nto kāākuyityo mākutililiit ꞉nkinee wōlēēb saang'. ");
INSERT INTO spyNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ōmiitē sōō, nyēē miyaat kule nee ꞉akweek kāānēētikaab kiruutēk āk Farisaayeek, kiblembechiisyechu! Okerkeeye mbēērōōs chēē /kikeemas kuleelakiitu wōlēēb barak nto wōliin bo āriit kunyiyaat ꞉koyikaab muuswēk āk kiy ake tukul nyēē mā tiliil. ");
INSERT INTO spyNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Okerkeeye ꞉akweek mbēērōōsyēchoo kuuyu ōboorunēē wōlēēb saang' kule ōchurtootiin nteenee ām āriit, kyoowung'te keey ng'ōōki ānkōōyēku kiblembechiis miisin.” ");
INSERT INTO spyNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kitas taay ꞉Yēēsu kumwooy kule, “Ōmiitē sōō, nyēē miyaat kule nee ꞉akweek kāānēētikaab kiruutēk āk Farisaayeek, kiblembechiisyechu! Ōtēēkyinē *wōōrkooyikaab kēny tukuuk chēē /kiisōōtēē ānkōōkāroorānē mbēērōōsyēkaab biiko choo churtootiin, ");
INSERT INTO spyNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","sōōmwooyē kule, ‘Nto kikēēmiitē kōōrēēt ām bēsyōōsyēkaab mbo kuuko, nto kimākēēwāstooy korotiikaab wōōrkooyichu kuu wōloo kiyēytooy ꞉biikyoo chēbo kēny.’ ");
INSERT INTO spyNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nto kuuyu ōkuurē bichu kule mbo kuuko, ōchāmchiintōōsii nkityō kule okerkeeye mbo kuukoong'. ");
INSERT INTO spyNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kunyi, otas taay naas, ōyēyē ng'ōōkistaab mbo kuukoong'! ");
INSERT INTO spyNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ng'oomng'ookichu! Ōmuuchē kule nee ochilil ‑/makiiruusteenaak maataab kibchuulyo? ");
INSERT INTO spyNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Āmiitē āyookwook wōōrkooyik, biiko chēē boonto kiirnātēēt āk kāānēētik. +Mōōkwērtoochi alak murtooywōōsyēk obakach, nto alak +mōōbir ām kooriikwook bo saayeet ankookwetaatee kiriinkōōsyēk. ");
INSERT INTO spyNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kunyoo +/mākiing'woonchook kubo biiko tukul choo /kikeebakach buch, koonaamee Ābēl ākoy Sekaryaa Araab Berekyaa nyoo kyōōbākākyinē kwēēnuutaab Kōōtaab Yēyiin ākoo *kāābkōrōs. ");
INSERT INTO spyNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","!Kāāmwoowook, biiko chēē wuu chuutēchu ꞉chēē nyōōru ng'wooninoo tukul.” ");
INSERT INTO spyNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kibōlchi ꞉Yēēsu Yēērusālēēm kumwoochinē kule, “Wōōy, wēē, Yēērusālēēm, wē, Yēērusālēēm! Irumē wōōrkooyik ānkiiwiirēē rwoontōōk biiko choo iyooku ꞉Yēyiin kule kuyisuung'! Kyaasyeem kunyil areet chēē chaang' kule āyisu biikuuk kuu wōloo yisuntooy ꞉nkokya kinyiinyiiyēēnik kōōwut kebebaakyii, nteenee mānēēkōōnoo kut ayey kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kunyi mākuyoochiin ꞉Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","!Kāāmwoowook kuchakee raat kuwo taay mātābōōkāsoo subak, ākoy omwaay kule, ‘Ibēruuroot ꞉nyoo chōōnii ām kaayneetaab Yēyiin.’” ");
INSERT INTO spyNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nto yu miitē ꞉Yēēsu kuwēēchinē keey kukang'eetee *Kōōtaab Yēyiin, kōōnookyi ꞉rubiikyii ānkōōboorchi inee wōlēē /kikeeteekta Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yooto kumwoochi ꞉Yēēsu rubiichoo kule, “‑Mōōbēng'tēē ōchōrōkyinē tukuuk tukul chēē wuu chu. Kāāmwoowook, +/mākiiturbuub tukuuchu tukul nyēē māmii ꞉rwaa mbo akeenke nyēē ng'ētu kookemeeraat keey ake.” ");
INSERT INTO spyNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nto yu mii ꞉Yēēsu kēēbuurēē Lekemeetaab *Musēytuuniinēk āk rubiikyii nkit, kuteebee ꞉rubiik kule, “Mwoowēēch, āyu yēē yēyāktōōs ꞉ng'aleechaa 'kēēmwooyē? Kiy nee ꞉nyēē +makeekasee yēē iyēēwunēē ꞉inyiing' āk yēē yitu ꞉tabantaab kōōrēēt?” ");
INSERT INTO spyNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kumwoochi ꞉Yēēsu kule, “Ōriib keey! ‑Mookany /kiiberbeeraak. ");
INSERT INTO spyNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Choong'ēch ꞉biiko chēē makukwaanaat ankuyey keey ꞉ake tukul kule inee ku kāārārookiintēēt. Mākōōbotbootoot ꞉bichoo biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","+Mookas kubārē keey ꞉biiko ām kōōrēēt /ānkyoomu ng'al chēbo booryoot, nteenee ‑mōōmuuyē. Māsimkuyitu ꞉tabantaab kōōrēēt ānkoo kāyēyākiis ꞉tukuuchoo. ");
INSERT INTO spyNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mākubooryo ꞉bōrōryēēt ake āk ake, kubooryo ꞉kōōrēēt ake āk ake. Mākuchō ꞉kēmēwuut ānkutookunootēē ꞉kibring'ring'nyēēt komoswookik chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ng'wooninto nyēē kāāmunēē moroontoon ꞉nyoo nto yitu ꞉kōōrēēt nyēē lēēl. ");
INSERT INTO spyNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","+/Makeechaamtaak, /kēēwusook, /keebakachaak /ānkēēwēchook ām kōōrōōsyēk tukul kuuyu ōyēnwoo. ");
INSERT INTO spyNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Makoochuchuuyee keey ꞉biich chēē chaang' kaakaaseet ankuchaamtaat keey āmēēkōōriiku keey. ");
INSERT INTO spyNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Makuyey keey ꞉biiko chēē chaang' kuyēk *wōōrkooyikaab Yēyiin ānkutēwēch biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mākuwōōyiit ꞉ng'ōōkisto kut kubot ꞉chamateet. ");
INSERT INTO spyNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nteenee +/makiiraraach chiito nyoo kamuyta ākoy tabanta. ");
INSERT INTO spyNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nto subak, +/makyaamtee Lōkōōywēchu Kāroomēch bo Kaab Yēyiin kōōrēēt kumukuul kukas ꞉biikaab yēēmōōsyēk tukul, nto yitu ꞉tabanta.” ");
INSERT INTO spyNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Kimwooy ꞉Yēēsu subak kule, “Yoo kookas ‘kiyoo ‑mēēriiku ꞉Yēyiin’ nyoo king'āloolēē ꞉wōōrkooyoontēēt Tānnyēēl kukēēyyoonyēē Kōōtaab Yēyiin, māchāktōōs kumwēchi ꞉biiko choo miitē Yuuteeya lekem. (Kuyeb yiit ꞉chii nyoo sumānē ng'aleechu.) ");
INSERT INTO spyNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nto yoo kanyoorta ꞉ng'aleechu chii kumii kōōnyii barak, ‑mēēwut kō kule kōōnēm kiy ake tukul nyēē sukumwēyto, ");
INSERT INTO spyNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ameeyeey ꞉chii nyoo miitē mbareen kaa kule wokunam sireet nyēē iliiktēē keey. ");
INSERT INTO spyNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lēyyē, mākuwuuyiityi sōō kule nee ām bēsyōōsyēchooto kooruuk choo kōōyootiin āk choo irēēriisyē! ");
INSERT INTO spyNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Osaay Yēyiin kule māyēyākiis ꞉ng'aleechu yoo yiiwoot nto ku bēsyēētaab *Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mākuwōōyiit ꞉ng'woonintaab bēsyōōsyēchooto kusiir ng'woonin ake tukul nyēē kiikutook kuchakee kayey ꞉Yēyiin kōōrēēt, āmākoy kutook ꞉ng'woonin ake nyēē tēē nyoo bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nteenee kiikoonwaakiit ꞉Yēyiin bēsyōōsyēchooto kuuyu mii ꞉biikyii chēē kiikukwey nyēē nto kimanaakoonwaakiit, nto māmii ꞉chii nyēē kātāwokusobē. ");
INSERT INTO spyNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Yoo kāmwoowook ꞉chii ake tukul kule ong'nyi *Kāārārookiintēēt nto ong'nyiin, ‑mōōyēnchi, ");
INSERT INTO spyNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","kuuyu makukwa ꞉biiko chēē makuyey keey kuyēk kāārārookik āk *wōōrkooyikaab Yēyiin. Makuyey ꞉bichu ng'al chēbo kwōng'uut sukung'eet, yoo imuuchāktōōs, kutēwēch biikaab Kiriistō choo kwēyootiin. ");
INSERT INTO spyNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kāsimāsōōwook, kookas? ");
INSERT INTO spyNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kunyoo, yoo kāmwoowook ꞉chiito ake kule, ‘Ong'nyiin Kāārārookiintēēt miitē suurkwēēn,’ ‑moobe wōlooto, nto kumwoowook kule, ‘Ong'nyi kawunyee keey kisēēnkē’, ‑moocham. ");
INSERT INTO spyNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kuu yoo iwēchēē koong'asiis /bokeekasee tinkeey, kukērkēyiitu nyooto ꞉wōlēē chōōntooy *꞉Wēritaab Chii. ");
INSERT INTO spyNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wōloo mii ꞉mōtōōng'wēk, kumii yooto ꞉muuswēk.” ");
INSERT INTO spyNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kitas taay ꞉Yēēsu kumwooy kule, “Yoo bēku ꞉nyāliluutēchoo bo bēsyōōsyēchooto, ‘Mākumis ꞉asiista, āmēētākōōluuwu ꞉araaweet. Mākōōtimtiimākoy ꞉wōliin bo barak ānkōōsuuw ꞉kookeelik.’ ");
INSERT INTO spyNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yooto +māābooru keey *꞉Wēritaab Chii ām barak. Mākuriiryo ꞉biikaab kōōrooni tukul yoo kakasa āchōōnēē boolik barak ām kāāmuukēywēēk āk lēbkēēyyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yoo /kēēkuutē koontiit kuchēchi barak, +māāyooktē malayikaanikyuu kuba komosta ake tukul nyēbo kōōrēēt bokōōruruukoot biiko choo kwēyootiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kumwooy subak ꞉Yēēsu kule, “Yoo inkātu ꞉kēētoo /kēēkuurēē *mutiiniit, kōōbooru kule kaakuriik kumusēs. ");
INSERT INTO spyNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ām kēēlto nyēē wuu nyooto, yoo ōkāsē kuyēyāktōōs ꞉tukuuchoo tukul, ōnkēt kule kaakuriik ꞉bēsyēēt nyoo āyēēwunēē. ");
INSERT INTO spyNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","!Kāāmwoowook, mābootōōs ꞉biikyuu choo kyaakwey ānkoo kāyēyākiis ꞉tukuuchoo tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mākubot ꞉barak āk ng'wēny, nteenee mābotē ꞉ng'ālyoontēēnyuu. ");
INSERT INTO spyNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Māmii ꞉chii nyēē inkētē bēsyēēt nyēē āyēēwunēē. ‑Mēēnkētē ꞉malayikaanik āmāānkētē mbo ꞉nkanii, nteenee Baaba nkit ꞉nyēē inkētē. ");
INSERT INTO spyNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kērkēyiitu ꞉yoo kariik āyēēwunēē ꞉anii *Wēritaab Chii āk bēsyōōsyēchoo kibo Noowa. ");
INSERT INTO spyNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kutoombo kuchōōnii yooto ꞉taambiliilyeet, kyoomiisyē ꞉biiko, kuyyēēsyē, kōōmutiisyē /ānkiimutē chuut ākoy bēsyoonoo kiiwutē ꞉Noowa mwēēng'. ");
INSERT INTO spyNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kimēēnkēt ꞉bichoo kiyēē kimii wokuyēyāktōōs ākoy yoo kichōōnii ꞉taambiliilyeet ankubakach bichoo tukul. Makukerkeyiit nyooto bēsyoonoo chōōnii ꞉Wēritaab Chii. ");
INSERT INTO spyNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yoo mii ꞉murēnik āyēēnku mbareen, +/mākēēyib akeenke /keebakaakta ake. ");
INSERT INTO spyNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nto yoo mii ꞉kooru āyēēnku kung'ooysēē rwaanteet, +/mākēēyib akeenke /keebakaakta ake. ");
INSERT INTO spyNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kunyi, ōriib keey kuuyu ‑mōōnkētē bēsyēēt nyēē chōōnēē ꞉Mokoryoontēēng'woong'. ");
INSERT INTO spyNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ōrōōtootē ng'ālyoontooni: Nto inkētē ꞉chiitaab kayta āsiiswēk chēē chōōnēē ꞉chōōriintēēt, nto riibsē ‑/mākēēbut kanyii. ");
INSERT INTO spyNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kunyoo māchāktōōs ōchōbootiin ꞉nkakweek, kuuyu mākuchō *꞉Wēritaab Chii ām āsiiswēk chēē ‑mōōmoonkyinē. ");
INSERT INTO spyNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ara ng'oo nanyuun nyēē motwooriin nyēē /kiikoosēē keey ānku ng'oom? Nyēē kiikoosēē keey ku nyoo itōōrchinē ꞉mokoryoontēēt biikaab kanyii kubāyē nyēē māmii ꞉wuuyin. ");
INSERT INTO spyNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ibēruuroot ꞉chiichoo yoo kānyōōr ꞉mokoryoontēēnyii kuyēyē yiisyoonoo nyēē karaam! ");
INSERT INTO spyNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","!Kāāmwoowook, mākōōkoochi ꞉mokoryoontoonoo motwooriintoonoo kōōyyoonkyi tukuukyii tukul chēē boonto. ");
INSERT INTO spyNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nteenee yoo miyaat ꞉motwooriintoonoo, mākumwooy kule, ‘Lōō yēē chōōnii ꞉mokoryoontēēnyuu.’ ");
INSERT INTO spyNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yooto mākubirsēēt motwoorik chuut ānkung'āsyānchi keey kwoomiis ānkuyyēēsyo ākoo kibōōkitiis. ");
INSERT INTO spyNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nto yoo kāchō ꞉mokoryoontēēnyii ām bēsyēēt nyēē ‑mēēmoonkyinē ꞉motwooriintoonoo, ");
INSERT INTO spyNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","māchokōōng'woonchi motwooriintoonoo ānkutōōrchi wōlēē mii ꞉kiblembechiisyek chuut, wokuriirunee ng'wēny.” ");
INSERT INTO spyNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kitas taay ꞉Yēēsu kumwooy kule, “Okany āmwoowook wōlēē wuu ꞉chōōnēētaab bāytooyiisyēētaab Yēyiin nyēē lēēl. King'eet ꞉tiibiik alake tamanu kunam taariinekwaa bokutorooch saanteet nyēē mākiisyē. ");
INSERT INTO spyNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kibērbērēch ꞉muutu kung'oomēch ꞉chuut muutu. ");
INSERT INTO spyNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kinam ꞉choo kibērbērēch taariinek cheekwaa amanaanamtaat keey mwaaniinek. ");
INSERT INTO spyNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nteenee kinamtaat keey ꞉choo king'oomēch mwaaniinek. ");
INSERT INTO spyNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yooto wokooliiny ꞉saanteetkēy. Kukās ꞉tibichoo kut kōōnuukiis ānkuruuyo. ");
INSERT INTO spyNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nto miitē kwēēmooy kwēēn, /kēēkuur kule, ‘Kaakuyit ꞉saanteet! Nyoo, okwaa baa, otorooch!’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kung'ēētyo ꞉tibichoo tukul ankuyeyta taariinekwaa. ");
INSERT INTO spyNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yooto kumwoochi ꞉chu kibērbērēch chu king'oomēch kule, ‘Ntēē miitē kumistōōs ꞉taariinekyoo acheek, ōroong'wēēch mwaaniinek.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kukētyi ꞉choo king'oomēch kule, ‘Acha. Nto nyuun kurārchēēch acheek. Boo-al chēēkwook.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kung'ēētyo bokwooliis. Nto kumiitē kēēltaab too kubēētii, kuyitu ꞉saanteet. Yooto kōōwutē ꞉choo kichōbootiin kōōtaab saakweet āk saanteet /ānkēēkērē kurkeet. ");
INSERT INTO spyNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nto tēē yoo kuyit ꞉nkicheek chu kibēētii mwaanik ānkōōng'ēētiis kule, ‘Iyootwēēch! Iyootwēēch! Yootwēēch kurkeet!’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nteenee kuwālchi ꞉chiichoo kule, ‘‑Māānkētook ꞉anii.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kiiwoong' ꞉Yēēsu tyoonkōōchoonoo kule, “Kunyoo, ōriib keey naas, kuuyu ‑mōōnkētē bēsyēēt nto ku āsiiswēk chēē āyēēwunēē anii.” ");
INSERT INTO spyNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kitas taay ꞉Yēēsu kumwooy tyoonkōōchēēt ake kurubta keey bāytooyiisyēētaab Yēyiin kule, “Kimii ꞉chii nyēē kimāchē kuwo ruutooy, kukuur motwoorikyii ānkōōtōōrchi chii tukuuk chēē kiimuuchē kuriib. ");
INSERT INTO spyNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kiitōōrchi nyēbo taay beesaanik kisyēērōōk konom, kōōtōōrchi ake kisyēērōōk tibtēm nto ake kōōtōōrchi nyoo kisyēērōōk taman. Nto kāākuyityo, kuruuto. ");
INSERT INTO spyNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kiwokuyēyiisyēē ꞉nyoo /kikiitōōrchinē kisyēērōōk konom beesaanichaa areet akeenke kubāsunēē alak kisyēērōōk konom. ");
INSERT INTO spyNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kunyōōr ꞉nkinee nyoo /kikiitōōrchinē kisyēērōōk tibtēm kisyēērōōk alak tibtēm. ");
INSERT INTO spyNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nteenee kiwokubal ꞉nyoo /kikiitōōrchinē kisyēērōōk taman ng'wēēnēēt ankukonor beesaanikaab mokoryoontēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nto kaakukeeyta bēsyōōsyēk chēē chaang', kōōyēēwunēē ꞉mokoryoontoonoo ruutooy. Kikuur ake tukul ām motwoorichoo chokumwooy wōlēē kibeeta ꞉ng'aleekaab beesaanichaa. ");
INSERT INTO spyNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kuchō ꞉nyoo /kikiikoochinē kisyēērōōk konom ānkumwooy kule, ‘Mokoryoontēēt, 'kikiitōōrwoo beesaanik kisyēērōōk konom, kunyi kas, baa, mii ꞉kisyēērōōk alake konomu barak.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kuwālchi ꞉mokoryoontēēnyii motwooriintoonoo kule, ‘Kweeyey nyēē karaam /ānkiikoosēēniing' keey! Kuu yoo 'kweemuuch ikaaman tukuuk chēē ng'ēri kut kubās keey, +māākōōniing' ibāwu tukuuk chēē choong'ēch. Chōōnchi keey keetankas ꞉tukwaay!’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nto tēē yoo kuchō ꞉nkinee nyoo /kikiikoochinē kisyēērōōk tibtēm, ānkumwooy kule, ‘Mokoryoontēēt, 'kikiitōōrwoo beesaanik kisyēērōōk tibtēm, kunyi kas, baa, kōōkutāsyi keey ꞉kisyēērōōk tibtēmu.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kuwālchi ꞉mokoryoontēēt kule, ‘Kweeyey nyēē karaam, /ānkiikoosēēniing' keey! Kuu yoo 'kweemuuch ikaaman tukuuk chēē ng'ēri kut kubās keey, +māākōōniing' ibāwu tukuuk chēē choong'ēch. Chōōnchi keey keetankas ꞉tukwaay!’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nto mii yoo, kuchō ꞉nyoo /kikiikoochinē kisyēērōōk taman, ānkumwoochi mokoryoontēēt kule, ‘Mokoryoontēēt, kwāānkētē kule iyēku chii nyēē kōrōōm nyēē 'kiicham ikēsē kiyēē kimēēchoonē ānkiiruruuchēē wōlēē mānēēyis kēbus. ");
INSERT INTO spyNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kwaanyokoriitu, kunyoo kiwāābālchi beesaanikuuk ng'wēny akonor. Neennyi, onkyu beesaanikuuk.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kuwālchi ꞉mokoryoontēēt kule, ‘Imiyaat ānkiiburēn! Ākoo kiinkētē ꞉inyiing' kule ākēsēē ꞉anii āmiik wōlēē manaachaan ānkāāruruuchēē wōlēē mānāāyis ee? ");
INSERT INTO spyNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Karaam, nto kiikonoree lēnkuunēk wōloo bāsu keey, nto kāchāānyōōru kōōkutāsyi keey. ");
INSERT INTO spyNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ōnēmunēē nyi beesaanichaa ānkōōkoochi chiito nyoo kāboonto beesaanik kisyēērōōk bokol. ");
INSERT INTO spyNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chiito nyoo kāyēyiisyē kiyēē /kākiikoochi, +/mākēētāsyi. Nto nyoo kāmāyēyiisyē /kiinēmunēē mbo nyooto /kākiikoochinē. ");
INSERT INTO spyNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nto motwooriintooni kēwēyiin, ōwiirchi saang' wōliin bo mēēnānēēt wokung'woonchi ꞉soboon ankuriirunee ng'wēny.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kitas taay ꞉Yēēsu kumwooy kule, “Yoo chōōnii *꞉Wēritaab Chii ām wōōyinnyii kuu bāytooyiin kuboontoonu keey malayikaanik tukul, mākōōbuurēē ng'echereenyii bo bāytooyiisyēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","+/Mākiiruruukyi biiko tukul taayeenyii. Yooto, mākōōbēēsyo biiko kuu yoo ibēēstōōs ꞉ākiintēēt kēēchiirēk ākoo ng'oroorik. ");
INSERT INTO spyNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mākutēbunēē ꞉kēēchiirēk āwutaab taay kutēbunēē ꞉ng'oroorik āwutaab kaataam. ");
INSERT INTO spyNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mākumwoochi yooto choo miitē āwutaab taay kule, ‘Okwaa ꞉choo kiikōōbēruurook ꞉Baaba. Onam bārooyinng'woong' ām Kaab Yēyiin nyoo /kisimkēēchōbwook kuchakee /kakeeyey kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ki yoo kaama ꞉kēmēy, ōbāyoo, nto yoo kaama ꞉melel, ōkōōnoo bēy chēē kaayyee nto yoo kāāruutoochook, ōtoochoo. ");
INSERT INTO spyNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ki yoo māātinyē sira, ōloochoo, nto yoo kaamnyaan, ōrwoomoo, nto yoo /kikēērātoo, bookasaa.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yooto mākukētyi ꞉choo churtootiin kule, ‘Āyu yēē kyoomiing' inyiing' ꞉kēmēy ankeebayiing' ꞉acheek ōō, Mokoryoontēēt, ku āyu yēē kyoomiing' ꞉melel ānkēēkōōniing' bēy chēē 'keeyyee? ");
INSERT INTO spyNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ki āyu yēē 'kiiruutoochēēch ankeetaachiing' ꞉acheek, ku āyu yēē kimēētinyē sira ankiilaachiing'? ");
INSERT INTO spyNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Āyu yēē 'kiimnyoonē ꞉inyiing' ku āyu yēē 'kiirataat ankubokiirwaamiing' ꞉acheek?’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mākukēt yooto kule, ‘Kāāmwoowook, kiyēē kyōōyēchi ake tukul ām mbo ng'eetaabiya choo kuskus, kyōōyēwoo anii.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nto tēē yoo kumwoochi choo miitē āwutaab kaataam kule, ‘Ōng'ēētyēē yu ꞉chu ōruustooyootiin bōōkārbusyi wōlēē bo maataab kibchuulyo nyoo /kikēēyēytoochi Kibrōkōsyoontēēt ākoo tāmirmirookyii bo rōkōs. ");
INSERT INTO spyNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kyaama ꞉kēmēy, ‑amoobayaa, kwaama ꞉melel, ‑āmōōkōōnoo bēy. ");
INSERT INTO spyNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Āruutoochook, ‑amootaachaa. Āwē āmā sira, amanoolaachaa, amnyaan, amaboorwaamaa /ankeerata amabookasaa.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mākumwoochi yooto ꞉nkicheek bichooto kule, ‘Āyu yēē kyaaming' ꞉kēmēy, melel, nto iruutoochēēch, nto yēē kimēētinyē sira, nto yēē kiimnyoonē, nto kiirataat, āmākēēyēētyēēchiing' ōō, Mokoryoontēēt?’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nto yooto mākukēt kule, ‘Kāāmwoowook, yoo mānōōyēchi kiy biikyuu choo kuskus, mēēbērē kyōōyēwoo anii kiy.’ ");
INSERT INTO spyNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yooto nanyuun +/makiimut bichooto wōlēē wokung'woonchinē ꞉soboon ākookoy /ankiimut choo churtootiin kuba wōlēē bo *soboontaab kibchuulyo.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yu kēēwoong' ꞉Yēēsu kumwooy ng'aleechu tukul, kumwoochi rubiikyii kule, ");
INSERT INTO spyNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kuu yoo ōnkētē, kāākung'ēt ꞉bēsyōōsyēk āyēēnku /kyaam *Saakweetaab Keeytaayeet, nto yooto +/mākiiyokooytoo anii, *Wēritaab Chii, /bokēēkwērtoochoo murtooywoontēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kiiruruukyi keey ꞉mbo *kibkōrōs chēē wōōyēch ākoo booyikaab Yuutayeek kaytaab *kibkōrōs nyēē wōō nyēē /kikēēkuurēē Kayaafa. ");
INSERT INTO spyNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yooto kuchōb wōlēē makunamta Yēēsu /subokeebakach. ");
INSERT INTO spyNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kimwooy kule, “‑Mookany keenam chiichi /kyoomē Saakweetaab Keeytaayeet, kuuyu imuuchē ꞉biiko kuyey wōōrōōryēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nto yu miitē ꞉Yēēsu Beetannyaa ām kaab Simōōni chiichoo kikiikunāmē *꞉makereenik, ");
INSERT INTO spyNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kuchō ꞉koorkēēt ake nyēē kiboontoonu mwaay nyēē kiboong'u nyēē anyiny nyēbo beesaan chēē chaang' miisin. Nto kumiitē ꞉Yēēsu kāmurēē keey yēē /kyoomiisyēē, chokuraang'tee ꞉koorkoonoo mētinyii mwaayaa. ");
INSERT INTO spyNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bērē kukas ꞉rubiikaab Yēēsu kuu nyoo, kung'woonchi ānkumwooy kule, “Ntēē sukunyarta ꞉koorkooni mwaay kuu nyi? ");
INSERT INTO spyNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","/Kātākyooltēē mwaayi beesaan chēē chaang' /ānkiikoochi bānoonik.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kiinkēt ꞉Yēēsu kiyēē kimii kumwooyē ꞉icheek. Yooto, kumwoochi rubiikyii kule, “Ōmāchēē nee ꞉akweek koorkooni? Ntēē kāākuyēwoo anii ng'ālyoo nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kookas, ōboontē keey ꞉akweek bānoonik ākookoy, nteenee mēēbērē ōboontē keey anii ākookoy. ");
INSERT INTO spyNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yoo kāroong'tēē ꞉koorkoonoo mwaayi mēt, kāmiitē kuyēytoo /subokeemuya. ");
INSERT INTO spyNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","!Kāāmwoowook, ‑/mākēēwuutyēē koorkooni ām kiyēē kaakuyey yoo /kyoomtooy lōkōōywēk chēē kāroomēch ām kōōrēēt tukul.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nto miitē yoo kung'eet ꞉Yuuta Iskaryoot nyoo ki akeenke ām rubiikaab Yēēsu taman āk āyēēng' ānkuwo wōlēē kimiitē ꞉mbo kibkōrōs chēē wōōyēch. ");
INSERT INTO spyNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kiwokuteebee bichoo kule, “Kiy nee ꞉nyēē ōkōōnoo yoo kāāchōbwook kēēlto onam chiichi?” /Kēēchāmchi *feetaanik sosom. ");
INSERT INTO spyNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nto kuchakee yooto kuwo taay kucheeng' ꞉Yuuta bārooyinto nyēē kachaamtee Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nto yēē ki bēsyēētaab taayta nyēbo Saakweetaab mukaatiin chēē mākuutunootiin, kōōnookyi ꞉rubiik yēē kimii ꞉Yēēsu ankuteebee kule, “Ānō wōlēē imāchē keeyeyte /sikyaamee *Saakweetaab Keeytaayeet?” ");
INSERT INTO spyNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kuwālchi ꞉Yēēsu kule, “Boocheeng'aate chii ām kiriing' ānkōōmwoochi kule, ‘Kāmwooy ꞉Kāānēētiintēēt kule: Kaakuyit ꞉bēsyōōsyēkyuu. Kunyi, āmiitē āk rubiikyuu, chāā-āmēē Saakweetaab Keeytaayeet kōōng'uung'.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bokuyeyta ꞉rubiichoo saakwaanaa kuu wōloo kāmwooytoochinē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nto kumii kurātoorātē ꞉kōōrēēt, kōōbuur ng'wēny ꞉Yēēsu ākoo rubiikyii taman āk āyēēng' kwoomiis. ");
INSERT INTO spyNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kumii kwoomiisyē, kumwooy ꞉Yēēsu kule, “!Kāāmwoowook, mii ꞉akeenke ām akweek nyēē makuchaamtaa.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kung'woonchi ꞉rubiichoo ānkutoow ꞉ake tukul kuteeb kule, “Ara anii ōō, Mokoryoontēēt?” ");
INSERT INTO spyNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kuwāl ꞉Yēēsu kule, “Nyoo kiilābloobtooy ꞉tukwaay mukaatiit terekyeet akeenke ꞉nyēē makuchaamtaa. ");
INSERT INTO spyNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Makume *꞉Wēritaab Chii kuu yoo siraat. Nteenee mākung'woonchi sōō kule nee ꞉chiito nyoo makuchaamtaa! Kaykay nto /kimākēēsich chiichoo.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kumwooy ꞉Yuuta kule, “Anii mbonō oob ōō, Mokoryoontēēt?” Kuwālchi ꞉Yēēsu kule, “Ēē, inyiing'.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nto mii yoo, kunam ꞉Yēēsu mukaatiit ānkubirchi Yēyiin kōōnkōy ankubetes nto yityo kōōkoochi rubiikyii kumwoochinē kule, “Bōōrnyuu ꞉nyi, o-am.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kunam terekyeet nyēē kimiitē *꞉tifaayiik ānkubirchi Yēyiin kōōnkōy ānkōōkoochi rubiikyii kumwooyē kule, “Oyyee ꞉akweek tukul. ");
INSERT INTO spyNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Korotiikyuu ꞉chu chēbo *kiirootyeet nyēē lēēl chēē +/makiitaata /sikēēnyōōchi kaat biiko chēē chaang' kubo ng'ōōkiswookik. ");
INSERT INTO spyNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","!Kāāmwoowook, ‑māwāāyyēē subak tifaayiichu ākoy bēsyoonoo āyyēē āk akweek tifaayiik chēē leelach ām Kaab Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nto tēē yoo, kutyēēn kōōkoostooy Yēyiin, ānkung'ēētyo kutākyi keey Lekemeetaab *Musēytuuniinēk. ");
INSERT INTO spyNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kumiitē kēēltaab too, kumwoochi ꞉Yēēsu rubiikyii kule, “Ōmiitē ꞉akweek tukul bōōmwēyēēnoo kwēēmowuuniitēnyi, kuu yoo mwooyē ꞉siruutēk kule, ‘+Maabakach ākiintēēt kusērēēt ꞉kēēchiirēk.’ ");
INSERT INTO spyNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nto yoo kaang'eetee meet, +maantooy Kalilaaya.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kuwālchi ꞉Bētērō kule, “Ānkoo kāmwēyēēniing' ꞉chuut tukul mākoy abakaaktiing' ꞉anii.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kukētyi ꞉Yēēsu Bētērō kule, “Kāāmwoowuung', ām kwēēmowuuni, kutoombo kōōturkuuchē ꞉kirkōōnkiit, +meetuuch keey ꞉inyiing' areet sōmōk kule ‑mēēnkētoo.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kuwāl ꞉Bētērō kule, “Mākoy atuuch keey kule ‑māānkētiing'. Yoo kābo meet kēēbēku ꞉tukwaay.” Kōōruumchi ꞉nkicheek rubiik chuut tukul kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yu kayit ꞉Yēēsu ākoo rubiikyii yēē /kēēkuurēē Ketesemaane, kumwoochi kule, “Okanyaa yuutēyu, āwē ꞉anii yuun waasaay.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kuwēēto keey Bētērō ākoo wērichoo āyēēng' bo Sebetaayo. Kyaam ꞉ng'uusng'uus Yēēsu kut kulōōklōōkēn. ");
INSERT INTO spyNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nto tēē yoo, kumwoochi mbo Bētērō kule, “Kāāmuy ꞉anii kut wuu nyēē +maameey. Kunyi, ōng'ētunēē yuutēyu ānkōōkāsu.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yooto koonaakta taay kisich ānkukutuny ānkuyim kutiiny tokochta ng'wēny kusaay kule, “Baaba, yoo imuuchāktōōs, inēmtoowoo nyalili. Nteenee kuyeyakay kuu wōloo imāktooy, mēēbērē wōloo āmāktooy ꞉anii.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nto yu keeyeey wōloo kimii ꞉rubiikyii sōmōku kunyōōr kuruuytōōs. Kumwoochi Bētērō kule, “Kāmōōmuuchē kēēkāsu tukul mbo asiista akeenke? ");
INSERT INTO spyNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Māchāktōōs ōkāsu ānkōōsooyē simōō-āsyi keey tyēmiisyēēt. Ōbērē nto oyey, āmāmii ꞉nkuruuk.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yooto kooyeey subak ankusaay kule, “Lēyyē, Baaba, yoo mēēmuuchāktōōs /kiinēmtoowoo nyalili, kuyeyakay kuu wōloo imāktooy.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yu kēēyēēw ꞉Yēēsu nyēbo āyēēng', kunyōōr mbo Bētērō kāruuyo subak, kuuyu kiboonto rwoonik chēē nyikiisēch. ");
INSERT INTO spyNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kubakaakta rubiichoo ankuwokusaay nyēbo sōmōk kumwooyē kuu yoo kābo taay. ");
INSERT INTO spyNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nto tēē yoo kooyeey wōloo kimiitē ꞉rubiik ānkumwoochi kule, “Ākoo tōōbēng'tēē rwoonik? Okas, kaakuyit ꞉āsiiswēk /kiiyokoochi *Wēritaab Chii āwunnyēkaab kibng'ōōkisiis! ");
INSERT INTO spyNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ong'nyiin choomtooyiintēēt kāākuchō! Ōng'ēētyē bokēētuuyēē.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kutākumii ꞉Yēēsu kung'āloolē, kuyitu ꞉Yuuta nyoo ki akeenke ām rubiikaab Yēēsu taman āk āyēēng'. Kiboontoonu keey biiko chēē chaang' chēē kitinyē chōōkiinēk ākoo syaariinek chēē kiiyooku ꞉mbo kibkōrōs chēē wōōyēch ākoo booyik. ");
INSERT INTO spyNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kikiisimkumwoochinē ꞉Yuuta bichoo kule, “Nyoo ōkāsē ātōrōōchē, ōnāmē nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kutākyinē keey ꞉Yuuta Yēēsu bakeenke ānkutōrōōchē kumwooyē kule, “Aase, Mokoryoontēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kukētyi ꞉Yēēsu kule, “Kāchēētōrōōchoo man ōō, murooni?” Kutēryēkyinē ꞉bichoo Yēēsu bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kukāsē ꞉rubiintēēt ake nyēbo Yēēsu kuu nyoo, kung'usu chōōkiit nto bērē kuyeb motwooriintēētaab *kibkōrōs nyēē wōō, kuchwenta yiitit kōōsuuyto. ");
INSERT INTO spyNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kumwoochi ꞉Yēēsu rubiintoonoonyii kule, “Kētyi chōōkiing'uung' kiraaru, kuuyu iwoong'tooy ꞉chōōkiit chii nyoo kicham chōōki. ");
INSERT INTO spyNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","‑Mōōnkētē kule āmuuchē ꞉anii ākuur Baaba kuyēētyēēchoo areet akeenke ānkōōmuuchē kōōyookwoo lukōōsyēk taman āk āyēēng' chēbo malayikaanik? ");
INSERT INTO spyNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kāyityiin ꞉ng'aleechu āk siruutēkaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kuwēēkyi keey ꞉Yēēsu bichoo ānkumwoochi kule, “Ōbērē āntōōchinē ꞉anii lukēēt nyēē māchē kuweech kōōrēēt sookwaante chōōkiinēk āk syaariinek boonamaa? Ntēē kwāāboontē keey ꞉anii akweek kwaak ām biiwuutaab *Kōōtaab Yēyiin ānēētiisyē. Kwaamaak ꞉nee simoonamaa yooto? ");
INSERT INTO spyNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nteenee ityiichē ꞉ng'aleechu tukul siruutēkaab *wōōrkooyik.” Kimwēyēē ꞉rubiik Yēēsu! ");
INSERT INTO spyNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nto mii yoo kukwēryoot ꞉bichooto Yēēsu kaab Kayaafa, kibkōrōs nyoo wōō. Kikiikōōruruukyi keey wōlooto ꞉kāānēētikaab kiruutēk ākoo booyik. ");
INSERT INTO spyNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kiinaamaat ꞉Bētērō Yēēsu ākoy kiyēnkuutaab kaytaab chiichoo bo kōrōs ānkōōbuur āk riibiikaab kayaata sukukas kiyēē makuyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kimach *꞉kōōkwēētaab Yuutayeek tukul kōōyyoonkyinē ꞉mbo *kibkōrōs chēē wōōyēch, kule kunyōōr ng'ālyoo nyēē miyaat nyēē nāmē Yēēsu /sikiitiilchi meet. ");
INSERT INTO spyNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nteenee mānāānyōōr ng'ālyoo ānkoo kisyeem ꞉biich chēē chaang' kumōlōlchi Yēēsu ng'al. Nto yityo kōōnēm keey ꞉biiko alake āyēēnku ");
INSERT INTO spyNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ānkumwooy kule, “Kimwooyē ꞉chiichi kule imuuchē kōōturbuub Kōōtaab Yēyiin ankuteechee bēsyōōsyēk sōmōk.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kōōyyo *꞉kibkōrōs nyēē wōō ankuteebee Yēēsu kule, “Itinyē wōlēē ituuktooy keey ām ng'aleechu mwooyē ꞉bichu?” ");
INSERT INTO spyNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kusiisyi keey ꞉Yēēsu. Kumwoochi subak ꞉kibkōrōs nyoo wōō Yēēsu kule, “Ātēēbēēniing' ām taayeetaab Yēyiin kule ii, ‘Inyiing' man *Kāārārookiintēēt, Lakwataab Yēyiin?’ ” ");
INSERT INTO spyNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kuwāl ꞉Yēēsu kule, “Ēē, wuu nyooto, 'keemwaay. Nteenee āmwoowook akweek tukul kule: +Mookas *Wēritaab Chii kōōbuurunēē āwutaab taay nyēbo Nyoo bo Kāāmuukēy ankookas kuchōōnēē boolik.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kikwaany keey ꞉moo chiichoo wōō bo kōrōs kut kubaach sirookyii ānkumwooy kule, “!Kookas, kaakookerkeeyee keey ꞉chiichi Yēyiin! Nee ake ꞉nyēē /tākēēmwoowēēch kurubta keey āk chiichi? Kookas oob wōlēē kāākōōntosuurto Yēyiin? ");
INSERT INTO spyNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ōbērē nee ꞉akweek?” /Kēēlēēnchi, “Misyinē ꞉meet.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","King'utyinē ꞉alake koonyek ānkōōtuluuchē, kusyēēchē ꞉alake ");
INSERT INTO spyNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sukumwoochinē kule, “Kāārārookiintooni, ng'oo ꞉nyoo kābiring'?” ");
INSERT INTO spyNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yooto kumiitē ꞉Bētērō yoo kibo biiy, kuchō ꞉chēēbto ake nyēē ki motwooriin ānkumwoochi kule, “Kwēēboontootē keey ꞉nkinyiing' Yēēsu nyēbo Kalilaaya.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nteenee kutuuch keey ꞉Bētērō ām taayeetaab biiko tukul kule, “‑Māānkētē kiyēē imiitē imwooyē.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nto tēē yoo kōōnookyi ꞉Bētērō yēbo oreet nyēē wēētii kayaata. Bērē kukas ꞉chēēbto ake, kumwoochi biiko kule, “Kiboontootē keey ꞉chiichi Yēēsu nyēbo Nāāsārēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kutuuch keey subak ꞉Bētērō kut kuchubchinē keey kule, “‑Māānkētē ꞉anii chiichi!” ");
INSERT INTO spyNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nto nyēē mā tyaa kōōnookyi Bētērō ꞉biiko chēē kikiiyyoonyēē yooto ānkumwoochi kule, “Kubooyiit man, inyiing' ꞉ake. Kerkeey ꞉ng'elyebng'uung' nyēbo chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kuchubchi keey ꞉Bētērō kule, “‑Māānkētē ꞉anii chiichi!” Kubēkunēē ꞉ng'aleechaa kuutiinyii, kōōturkuuchē ꞉kirkōōnkiit bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yooto nanyuun koosoot ꞉Bētērō yoo kimwooyē ꞉Yēēsu kule, “Kutoombo kōōturkuuchē ꞉kirkōōnkiit, +meetuuch keey ꞉inyiing' areet sōmōk kule ‑mēēnkētoo.” Yooto kuwo saang' ānkuwokuriir nyēē ng'waa miisin. ");
INSERT INTO spyNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nto yu kāmwook ꞉asiista, kootiil mbo kibkōrōs chēē wōōyēch tukul āk booyikaab Yuutayeek kule /keebakach Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yooto, /keerat ꞉Yēēsu /ānkēēkwērchi *꞉Bilaato nyoo kāāyyoong'iintēētaab Rooma. ");
INSERT INTO spyNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nto yu kakas ꞉Yuuta nyoo kichoomtooy Yēēsu kule /kaakiiruusta Yēēsu, kuriirunee ng'wēny. Kikētyi feetaanichaa ki sosom mbo kibkōrōs choo wōōyēch āk booyik. ");
INSERT INTO spyNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kimwoochi kule, “Kwaayey ng'ōōki achaamte chii nyēē bēērē keey.” Yooto kukētyi ꞉bichoo kule, “Kukwaaneeniing'!” ");
INSERT INTO spyNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yooto nanyuun kuwiirchi ꞉Yuuta feetaanichaa *Kōōtaab Yēyiin ānkuwokookeet keey. ");
INSERT INTO spyNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yu kānyōōr ꞉mbo kibkōrōs chēē wōōyēch feetaanichaa kumwooy kule, “Sālootiin ꞉beesaanichu koroti, kunyi mēērook /kiikoochi lēnkuutaab Kōōtaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kung'alaal ꞉bichoo nto mii yoo, kootiil kule /bokyaalee mbareet nyēē /sikēēmuchinē biich chēē sobooy. /Kikēēkuurēē mbaraanaa Mbaraab Kibtērēēn. ");
INSERT INTO spyNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kiyooto nyēē kiyey /kēēkuurē wōlooto ākoy kura kule, “Mbaraab Koroti”. ");
INSERT INTO spyNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kuyityiin ꞉yooto āk kiyēē kimwooyē *꞉wōōrkooyoontēēt Cheremnyaa kule, “/Keenam betekik sosom chēbo feeteet choo kyooltēē inee *꞉Isrāyēēliik ");
INSERT INTO spyNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ankwaalee mbaraab kibtērēēn kuu wōloo kimwooytoowoo ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nto kumii ꞉Yēēsu taayeetaab *Bilaato, kuteebee ꞉bāytooyiintoonoo kule, “Inyiing' ꞉bāytooyiintēētaab Yuutayeek?” Kukētyi ꞉Yēēsu kule, “Wuu nyooto sinee.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nto yu keeteeyee keey ꞉mbo kibkōrōs chēē wōōyēch āk booyikaab Yuutayeek kurubta keey Yēēsu, kusiisyi keey. ");
INSERT INTO spyNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kuteebee ꞉Bilaato kule, “‑Mēēkāsē wōlēē tēē ꞉ng'aleek chēē mwooyē ꞉bichu kule !kiiyey?” ");
INSERT INTO spyNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mānāākēt ꞉Yēēsu ng'ālyoo mbo kisich. Kubotyi ꞉tonkoy bāytooyiintoonoo. ");
INSERT INTO spyNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kiityooktooy ꞉bāytooyiintēēt ām kēnyiit ake tukul kibratyaanteet akeenke nyoo kaakutool ꞉biiko. /Kikēēyēyē kuu nyooto yoo /kyoomē *Saakweetaab Keeytaayeet. ");
INSERT INTO spyNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kimii ām bēsyōōsyēchooto chiito ake nyēē kikiikuchiis miisin kut /kikiikeerat. /Kikēēkuurēē chiichoo Baraaba. ");
INSERT INTO spyNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kunyoo, kuteebee ꞉Bilaato biiko chēē kikiiruruukyi keey yooto kule, “Ng'oo ꞉nyēē ōmāchē ꞉akweek ātyooktoowook, Baraaba nto Yēēsu nyoo /kēēbērē *Kāārārookiintēēt?” ");
INSERT INTO spyNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kimwooyē ꞉bāytooyiintoonoo kuu nyooto kōōnkētē kule kiituuyiityi ꞉icheek Yēēsu moo. ");
INSERT INTO spyNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kutākumiitē ꞉Bilaato kēēbuurēē ng'echereenyii bo bāytooyiisyēēt, kōōyookyi ꞉koorkēēnyii ng'ālyoo kule, “Kweeyiimaa ꞉kiirwootik kuyyeech kubo chiichoo. Kunyi, ‑meeyeyee kiy kuuyu bēērē keey.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kutēē yooto tukul, kitas taay ꞉mbo kibkōrōs chēē wōōyēch āk booyikaab Yuutayeek kōōwuruur bichoo kumwaayta /kiityaakta Baraaba /ankeebakach Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kuteeb subak ꞉bāytooyiintoonoo kule, “Nkōnō ām bichu āyēēng' nyēē ōmāchē ꞉akweek ātyooktoowook ꞉anii?” Kulē, “Baraaba.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kuteeb subak ꞉Bilaato kule, “Ayeyee nee Yēēsu nyoo /kēēbērē *Kāārārookiintēēt?” Kōōruumchi ꞉bichoo tukul kule, “/Keebakach!” ");
INSERT INTO spyNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kumwooy ꞉bāytooyiintoonoo kule, “Rōkōs nee ꞉nyēē koyey ꞉chiichi?” Kubōloobōl ꞉bichoo kumwooyē kule, “/Keebakach! /Keebakach!” ");
INSERT INTO spyNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yu kakas ꞉Bilaato kule kāmēētākōōmuuchē bichoo ānkiimuuchē koong'etng'eet wōōrōōryēēt, kuram bēēko ānkōōwuunēē āwunnyēk taayeetaab bichoo kumwooyē kule, “Kukwaaneenaak ꞉korotiikaab chiichi, ābēērē keey ꞉anii.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yooto, kuwāl ꞉bichoo tukul kule, “Kany kwaameech acheek ꞉korotiikaab chiichi āk lōkōkyoo!” ");
INSERT INTO spyNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yooto kōōtyooktoochi ꞉Bilaato bichoo Baraaba ānkōōkoochi /kiityōōlsēt Yēēsu nto tēē yoo kōōyokooyto /bokēēkwērtoochi murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kukwēryoot ꞉biikaab lukēēt Yēēsu kaytaab bāytooyiintēēt *Bilaato nto tēē yoo, kōōruruukyi keey ꞉lukēētaab booryēēt tukul Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kubuutēē Yēēsu sirook ānkōōlookyi sireet nyēē arraa, ");
INSERT INTO spyNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kutaay kuutwēētaab kātook ānkōōkēmēērchi mēt kuyey wuu nyēē bāytooyiin. /Kikiikoochi kunamee kirōkto āwunyii nyēbo taay ānkubokukutunyēē ꞉bichoo taayeenyii kuyey keey wuu nyēē kākoonyit Yēēsu kumwoochinē kule, “Kimkim! Bāytooyiintēētaab Yuutayeek!” ");
INSERT INTO spyNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kung'utyi ānkōōsōrunēē kirōkoo kimii āwut ānkōōkōryōōnyēē mēt. ");
INSERT INTO spyNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yu /kāākiintosuur, /kiirēēkunēē siraanaa arraa /ānkiilookyi sirookyii choo kōbo kwaak nto tēē yoo, /keebeeta /subokēēkwērtoochi murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kumii /kēēbēētooy, /kēētuuyēē chiito ake nyēē kibo Kurēēn nyēē /kikēēkuurēē Simōōni. /Kēēkērchinē nyoo koong' bakeenke kukalab murtooywoontēētaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nto yu /kakeeyit yēē /kikēēkuurēē Kolkoota (kaayneet nyēē ibooru kule ‘Rōkyēētaab Mēt’) ");
INSERT INTO spyNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","/kiikoochi Yēēsu *tifaayiik chēē /kikiikeetasee saakityeek alak kule kuyye. Nto bērē kuchamcham, kutay kuyye. ");
INSERT INTO spyNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nto yu kāākukwērtoochi ꞉bichoo Yēēsu murtooywoontēēt, kubar *sēkēēryēēt sukōōnkētēē kule ng'oo ꞉nyēē mākuyib sireet nkōnō. ");
INSERT INTO spyNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nto kāākuyityo, kutēbēē ꞉bichoo yooto kuriib Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","/Kikiikēēsirchi kiito ake ng'aleek chēē kiyey /sikiitiilchi Yēēsu meet chēē kimwooyē kule: YĒĒSU ꞉NYI NYOO BĀYTOOYIINTĒĒTAAB YUUTAYEEK. /Kikēēkwērtoochi kiyooto yoo bo mētitaab Yēēsu barak ām murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","/Kikēēkwērtoochi nkicheek kibng'ōōkisiis āyēēng' murtooywōōsyēkwaa. /Kikiiyyoong'to ake kutābān āwutaab Yēēsu nyēbo taay /ānkiiyyoong'to ake komostaab kaataam. ");
INSERT INTO spyNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kiinchuruurē ꞉biiko chēē kimurē yooto Yēēsu ānkukwērtooy mētēwook ");
INSERT INTO spyNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kumwoochinē kule, “Ntēē kwēēbērē +mēēturbuub *Kōōtaab Yēyiin ankiiteechee bēsyōōsyēk sōmōk? Iraraach keey, naas. Yoo inyiing' ꞉Lakwataab Yēyiin, irēkunēē murtooywoontoonoo!” ");
INSERT INTO spyNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kiinchuruur Yēēsu ꞉nkicheek mbo kibkōrōs chēē wōōyēch, kāānēētikaab kiruutēk ākoo booyik. ");
INSERT INTO spyNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kimwooyē kule, “Kiisoobē ꞉chiichi biiko alak, ntēē ‑mēēsoob keey naas. Mā inee ꞉bāytooyiintēētaab *Isrāyēēl? Yoo keemuuch kurēkunēē murtooywoontooni, +mākiiyēnchi. ");
INSERT INTO spyNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kwēēkoosēē keey oob ꞉chiichi Yēyiin ānkumwooyē kule, ‘Āyēku Lakwataab Yēyiin?’ Kany kusār naas ꞉Yēyiin yoo chāmē.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kiinchuruur ꞉nkicheek kibng'ōōkisiisyēchoo /kikēēkwērtoochinē murtooywoontēēt āk inee. ");
INSERT INTO spyNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kichō ꞉mēēnānēēt bēēt nyēē kiker kōōrēēt tukul, kung'eetee āsiiswēk lo ākoy āsiiswēk sokool. ");
INSERT INTO spyNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yu kayit āsiiswēk sokool, kōōnchō ꞉Yēēsu kule, “Yēyiintēēnyuu, Yēyiintēēnyuu, ntēē 'keebakaaktaa anii!” (Kimwooyē yooto ām kuutiinyii kule, “Ēli, ēli, lema sabaktani?”) ");
INSERT INTO spyNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yu kakas ꞉biikaab lukēēt chēē kimii yooto, kulē, “Miitē kukuurē *Eliiya.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yooto kulabatee ꞉akeenke ām icheek kiroonkuryēēt ankooluumta *tifaayiik chēē ki tāytāy ānkurutyi kiroonkuryoonoo kēētit nto yityo kōōyokoochi kuutiitaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kimwooyē ꞉alake kule, “Okany keekas yoo mākuchō ꞉Eliiya chokooraraach!” ");
INSERT INTO spyNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kiinchō ꞉Yēēsu ankung'et. ");
INSERT INTO spyNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yooto bakeenke, kukērēērunēē keey āyēēng' kuchakee barak ākoy ng'wēny ꞉ankeet nyēē ki rikimim nyoo /kikiiyēēlēē Kitōōkiitaab *Kōōtaab Yēyiin. Kiitimtiimākoy ꞉kōōrēēt ānkōōtēēsiis ꞉rwoontōōk. ");
INSERT INTO spyNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kiitēēsiis ꞉kochonkoosyek kuyootākiis ānkung'ēētyo ꞉biiko chēē chaang' choo kikiikubēk ānki churtootiin. ");
INSERT INTO spyNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","King'ēētyēē ꞉bichoo kochonkoosyek, nto yu /kaakiing'eetee Yēēsu meet, kuba Yēērusālēēm ānkōōboorchi keey biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yu kakas ꞉nyēē wōō nyēbo lukēēt āk biikyii choo kiriibē Yēēsu kibring'ring'nyoonoo ākoo ng'aleek tukul chēē kiyēyākiis, kumuuyo ānkumwooy kule, “Kubooyiit man, ākoo Lakwataab Yēyiin ꞉chiichi!” ");
INSERT INTO spyNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kikiiyyoong'iis ꞉chēēbyōōsōōk alake chēē chaang' yēē lōō kutoobēnē kiyēē kiyēyāktōōs. Chēēbyōōsōōchooto ꞉choo kiboontootē keey Yēēsu kuchakee Kalilaaya kuyēētyēēchinootē. ");
INSERT INTO spyNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Alak ām chooto ku Maaryaa nyēbo Maktaala, Maaryaa kaametiitaab Yāākōbō āk Yōōsēēf ākoo kaametiitaab wērichoo kibo Sebetaayo. ");
INSERT INTO spyNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nto yu kēēmēn ꞉kōōrēēt, kuchō ꞉chiito ake nyēē ki rubiintēētaab Yēēsu ānkiboonto bāytit nyēē wōō. Kibo *kiriinkēēt ake nyēē /kikēēkuurēē Arimataaya nto kaayneenyii ku Yōōsēēf. ");
INSERT INTO spyNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kiwo ꞉chiichoo wōlēē kimii ꞉Bilaato ānkusoom /kiikoochi bōōrtaab Yēēsu. Kuchāmchi ꞉Bilaato /kiikoochi. ");
INSERT INTO spyNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kimwaayta ꞉Yōōsēēf /kiirēēkunēē bōōrtaab Yēēsu murtooywoontēēt /ankeeratee ankeet nyēē tiliil. ");
INSERT INTO spyNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nto tēē yoo, wokōōkoochi kochonkeenyii nyēē kitākōōwōrē /ānkimānāākēēmuchi chii. Yooto kuwunukyi rwaanteet nyēē wōō kuker kurkeetaab kochonkaanaa ānkuwēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kikiibuurēē ꞉Maaryaa nyēbo Maktaala ākoo Maaryaa nyiin ake yooto kukas kochonkaanaa. ");
INSERT INTO spyNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nto yu kāyyēēkunēē, yēē ki bēsyēētaab *Sabaato, kubēēchi ꞉mbo kibkōrōs ākoo *Farisaayeek *Bilaato ānkumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Mokoryoontēēt, kimwooyē ꞉ng'wiintoonoo bo chii yooto kitākusoboot kule, ‘+Maang'eetee meet yoo kaakukeeyta ꞉bēsyōōsyēk sōmōku,’ ");
INSERT INTO spyNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","kunyi mwaayte /kēēriib kochonkaanaa ākoy bēsyoonoo bo sōmōk. Nto buch, imuuchē ꞉rubiikyii bokuchoor muusto nto tēē yoo kumwoochi biiko kule /kookiing'eetee meet. Makumiyatiit yooto ꞉ng'wiiynaneet nyiitēnyi bo lēt kusiir nyoo kibo taay.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kuwālchi ꞉Bilaato kule, “Obeete riibiik alak bōōriib kochonkaanaa kuriibākoy kuu wōloo ōmuuktooy.” ");
INSERT INTO spyNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kuba ꞉bichoo ānkubokōōtiiny kurkeetaab kochonkaanaa kāroomin kumoolchi rwaantaanaa yooto ānkōōkoochi riibiichoo kuriib. ");
INSERT INTO spyNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yu kēērir ꞉kōōrēēt kukookukeeyta ꞉bēsyēētaab *Sabaato, kuwo ꞉Maaryaa nyēbo Maktaala ākoo Maaryaa nyiin ake bokoorwaam kochonkaanaa. ");
INSERT INTO spyNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yooto, kōōring'riing' ꞉kōōrēēt miisin kuuyu kikiikurēkunēē *꞉malayikeetaab Yēyiin barak, kiwo ākoy kochonkaanaa ānkuwunukto rwaanteet ānkōōbuurēē barak. ");
INSERT INTO spyNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kiilēkēchēēchē ꞉malayikaanaa kuu yoo keewech ꞉kōōrēēt anki leelach ꞉sirookyii kuu kweyaanteet. ");
INSERT INTO spyNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yooto kumuuyo ꞉riibiichoo kimii yooto ānkubōōtoon kut wuu nyēē mākubēk. ");
INSERT INTO spyNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kumwoochi ꞉malayikeet chēēbyōōsōōchoo kule, “‑Mōōmuuyē, ānkētē ꞉anii kule ōchēēng'ē ꞉akweek Yēēsu nyoo /kōkēēkwērtoochinē murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Māmiitē yu nteenee kaakung'eetee meet kuu yoo kimwooyē. Okwaa bookas wōloo kōmiitē ");
INSERT INTO spyNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ankoobe areet akeenke bōōmwoochi rubiikyii kule, ‘Kaakung'eetee ꞉Yēēsu meet ankumakoonto Kalilaaya wōlēē bōōnyōōrchinē.’ Kookas oob?” ");
INSERT INTO spyNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yooto kung'ēētyo ꞉chēēbyōōsōōchoo areet akeenke ankulabat bokumwoochi rubiikaab Yēēsu ng'aleechaa. Kitinyē bōōtoonik chēē katasta keey ng'erekweek chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kumii tākulābātē, kutuuyēē Yēēsu. Kootaakwees icheek ꞉Yēēsu nto yityo kukutuny kukōōb kērēēnkōōkaab Yēēsu nyēē kākutunkyi. ");
INSERT INTO spyNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nto tēē yoo, kumwoochi ꞉Yēēsu kule, “‑Mōōmuuyē. Bōōmwoochi mbo ng'eetaabiya kuba Kalilaaya bokēēnyōōryē wōlooto.” ");
INSERT INTO spyNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kumiitē ꞉chēēbyōōsōōchoo kubēētii, kikiikung'ēētyo ꞉riibiik alake ankuba kiriing' bokumwoochi mbo kibkōrōs chēē wōōyēch kiy ake tukul nyēē kaakuyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nto yu kāākutuuyo ꞉mbo kibkōrōs chēē wōōyēch ākoo booyik kuchōb ng'aleek. Kiikoochi riibiichoo beesaanik chēē chaang' ");
INSERT INTO spyNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ānkumwoochi kule, “Omwaay kule, ‘Kokwa ꞉rubiikaab Yēēsu kwēēmooy ankuchoor muustaab Yēēsu kukākēēruuyē!’ ");
INSERT INTO spyNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nto yoo kāyityi ꞉ng'aleechu bāytooyiintēēt, +mākēēmwoochi ꞉acheek kāroomin āmēēbērē makunamaak akweek ꞉ng'ala.” ");
INSERT INTO spyNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kunam ꞉riibiichoo beesaanichaa ankuyey kuu yoo /kākēēmwoochinē. /Kikyaamtaatee ng'aleechaa kimwooyē ꞉riibiichoo wōlēē miitē ꞉Yuutayeek ākoy kura. ");
INSERT INTO spyNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kiba ꞉rubiichoo ki taman āk akeenke lekem ām Kalilaaya wōloo kimwoochinē ꞉Yēēsu kule kuba. ");
INSERT INTO spyNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nto yu kakas ꞉rubiichoo Yēēsu, kukutunkyi. Nteenee manaacham ꞉alake kule ki Yēēsu ꞉nyooto. ");
INSERT INTO spyNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yooto kumwoochi ꞉Yēēsu rubiichoo kule, “/Kōōkēēkōōno anii kāāmuukēywēēk tukul chēē miitē kibkōōnkōy āk chēē miitē ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kunyoo obeetaate bōrōryōōsyēk tukul ankooyey biiko kuyēk rubiikyuu. Ōbātisānē ām kaayneetaab Baaba, nyēbo Leekweet ākoo nyēbo Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ōnēētē bichooto kooywey kiy ake tukul nyēē kāāmwoowook. Nto kubooyiit man, āboontē keey akweek ākoy tabantaab kōōrēēt.”");
INSERT INTO spyNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Lōkōōywēk ꞉chu chēē kāroomēch chēbo Lakwataab Yēyiin, Yēēsu *Kiriistō. ");
INSERT INTO spyNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kikiikumwooy ꞉Yēyiin kēny kubununēē wōōrkooyoontēēt Isaaya kule, “+Māāyooktē kiiyookiintēēnyuu koonto wokuyēytoowuung' kēēlto.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","/Kikeesir subak kule, “Miitē ꞉kuut nyēē kuuru ām suurkwēēn kule, ‘Ōchōb keey, ānkōōchuulchi Mokoryoontēēt kēēlto.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kiiyookiintoonoo ku Bātisāniintēēt Yoowaana. Kyoomtooy ām kōōr nyēē suurkwēēn kule māchāktōōs ꞉biiko kuweek ām miyootyēēt /ankeebatisan, sukunyōōchi ꞉Yēyiin kaat. ");
INSERT INTO spyNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","King'ēētyēē ꞉biiko chēē chaang' Yēērusālēēm ākoo komoswookik tukul chēbo Yēēmēētaab Yuuteeya bokukas lōkōōywēchoo bo Yoowaana. Nto yu kābokumwooy choolwookātēēng'waa /keebatisanee āynēētaab Yoortaan. ");
INSERT INTO spyNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kikiilaach ꞉Yoowaana sireet nyēē /kikiikwoorunēē sabureekaab *tembes, ankumootee keey anweetaab suwe. Kyoomē taalamik ākoo kimnyeteet. ");
INSERT INTO spyNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kimwoochinootē biiko kule, “Yoo kaawaany kāānēētiisyēēnyuu, mākuchō ꞉chiito ake nyēē boonto kāāmuukēywēēk kubiira nyēē ‑maayemaat ārēēkyi kwēyōōnik. ");
INSERT INTO spyNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kaabatisaneenaak ꞉anii bēēko, nteenee makubatisaneenaak ꞉inee Tāmirmiryēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nto mii bēsyēēt ake, kuchōōnēē ꞉Yēēsu Nāāsārēēt ām Yēēmēētaab Kalilaaya ankubatisanee ꞉Yoowaana āynēētaab Yoortaan. ");
INSERT INTO spyNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yu kāloong'unēē bēēko, kukas barak kuyootāktōōs ānkurēkyi ꞉Tāmirmiryēētaab Yēyiin nyēē wuu chēēbtuukē. ");
INSERT INTO spyNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yooto, kumwooy ꞉Yēyiin ām barak kule, “Inyiing' lakwanyuu nyēē āchāmē, ānkāāng'ērēkyinē.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Kukwēryoot bakeenke ꞉Tāmirmiryēētaab Yēyiin Yēēsu ākoy suurkwēēn, wōlēē kimii ꞉nkicheek tyoong'iikaab wuuyēēt. Kiibuur ꞉Yēēsu wōlooto bēsyōōsyēk artam āmāmii ꞉kiy nyēē kyoomē. Kutyem *꞉Kēniintēēt, kumii wōlooto. Yu kāwēēchi keey ꞉Kēniintēēt, kukwa ꞉malayikaanikaab Yēyiin ānkuyēētyēēchi. ");
INSERT INTO spyNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nto mii bēsyēēt ake yu /kabokeerat Yoowaana, kooyeey ꞉Yēēsu Yēēmēētaab Kalilaaya kwaamtaat lōkōōywēk chēē kāroomēch chēē kikwoonēē wōlēē mii ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kimwooyē kule, “Kaakuyit ꞉bēsyēēt! Kāākuyityook ꞉bāytooyiisyēētaab Yēyiin! Oweeksee choolwookātēēng'woong' ānkōōyēnchi Lōkōōywēchu Kāroomēch.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nto mii bēsyēēt ake, kumii ꞉Yēēsu kuwēēsyētootēē sakaramteetaab Tōōliilēētaab Kalilaaya, kukas biiko āyēēng' chēē kimii kuwiirchinē nēētiinēk bēēko kunāmē *burburiinēk. Bichooto ku Simōōni ākoo ng'eetaabkaamet Antereeya. ");
INSERT INTO spyNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kukuur ꞉Yēēsu icheek kule, “Orubwaa! +Maaneetaak wōlēē ōyisuntooy biiko.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kubākooktooy bakeenke nēētiinēkwaa bo burburiinēk ānkurubē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yu keenaata ꞉Yēēsu taay kisich, kukas biiko alak āyēēng' kumii mwēēnkēēng'waa kuyēytooy nēētiinēkwaa. Bichooto ku Yāākōbō ākoo ng'eetaabkaamet, Yoowaana wērichoo bo Sebetaayo. ");
INSERT INTO spyNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kukuur ꞉Yēēsu nkicheek. Kukāsē kuu nyooto, kubākookyinē kwaan mwēēng' āk biiko chēē kimii kuyēchinē yiisyēēt ankurub Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kiwo ꞉Yēēsu ākoo rubiikyii Kaabernaam. Nto mii bēsyēētaab *Sabaato, kōōwut ꞉tukul *kōōtaab saayeet ankooneet ꞉Yēēsu biiko ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kiilat ꞉biiko wōlēē kiinēētitooy ꞉Yēēsu. Kimēēnēētē kuu wōloo kiinēētitooy ꞉kāānēētikaab kiruutēk, nteenee kiinēētē ām kāāmuukēywēēk. ");
INSERT INTO spyNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kimii kōyooto bo saayeet ꞉chiito ake nyēē kiiyiimē *꞉tāmirmiryēēt nyēē miyaat. ");
INSERT INTO spyNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kubōlchi ꞉tāmirmiryoonoo Yēēsu kule, “Imāchēēnēēch nee ōō, Yēēsu nyēbo Nāāsārēēt? Imāchē ibakacheech? Ntēē ānkētiing'! Inyiing' ꞉nyoo ichurtaat ānkiiboontē kāāmuukēywēēkaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kōōburyoong'to ꞉Yēēsu kule, “Siis, ankiichuwunee chiichi!” ");
INSERT INTO spyNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yu kāmwooy kuu nyooto, kōōsimsiim ꞉tāmirmiryoonoo miyaat chiichoo. Kōōnchō ankuchuwunee chiichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kiilat ꞉biiko tukul /ankeeteebee keey kule, “Ng'al nee ꞉chu? Boonto ꞉Yēēsu kāāmuukēywēēk chēē imuuchē kōōnēētiisyēē ām kēēlto nyēē lēēl, āk chēē ibēbēētēē tāmirmirook chēē miyootēch ānkukāsyi!” ");
INSERT INTO spyNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","/Kikyaamtaatee ng'aleechaa Yēēmēētaab Kalilaaya kumukuul. ");
INSERT INTO spyNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yu kang'eetee ꞉Yēēsu ākoo rubiikyii *kōōtaab saayeet, kuba kaab Simōōni. ");
INSERT INTO spyNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kimnyoonē ꞉cheebyoosyeetaab biikooy bo Simōōni. Yu /kākēēmwoochi Yēēsu kule mnyoonē ꞉cheebyoosyaanaa, ");
INSERT INTO spyNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","kuwo ankunam āwut kōōyyo. Kusob ꞉cheebyoosyeet ānkubāyiis. ");
INSERT INTO spyNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yu kararakta ꞉asiista, kukāākubēk ꞉āsiiswēkaab *Sabaato, kōōmutyi ꞉biiko Yēēsu biiko tukul chēē kimnyoontōōs āk chēē kiiyiimē ꞉tāmirmirook chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kibokōōruruukyi keey ꞉biiko chēē chaang' kurkat saang' ām kōyooto kimii ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kiisoob ꞉Yēēsu biiko chēē chaang' chēē kiboonto bōōrwoonik chēē kimakerkeey ānkōōbēbēēto tāmirmirook chēē chaang' chēē miyootēch. Kiker koong' ꞉Yēēsu tāmirmiroochoo kuuyu kiinkētē ꞉icheek wōlēē wuu ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yu kāng'ēēyēn ꞉kōōrēēt, kung'eet ꞉Yēēsu ānkuwo wōlēē kimālēēkitēē ꞉chii wokusaay Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nto bērē kusēw mbo ꞉Simōōni kule mēēkumii ꞉Yēēsu, kucheeng'aat. ");
INSERT INTO spyNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yu kunyōōr, kumwoochi kule, “Mii kuchēēng'iing' ꞉biiko.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kulē ꞉Yēēsu, “Māchāktōōs keebe komosta ake waa-amte lōkōōywēkaab Yēyiin, kuuyu chooto ꞉chēē kyāāchōōnchinē.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kyaamtaatee ꞉Yēēsu lōkōōywēk kooriikaab saayeet ām Kalilaaya tukul, ānkōōbēbēētootē tāmirmirook chēē miyootēch kung'ēētyēē biiko. ");
INSERT INTO spyNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kichōōnchi ꞉chiito ake Yēēsu bēsyēēt ake ꞉nyēē kiboonto *makereenik. Kukutunyēē taayeetaab Yēēsu ānkumwoochi kule, “Mokoryoontēēt, yoo ichāmē, isooboo sāātililiitu kuuyu ānkētē kule imuuchē.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kuriiree ꞉Yēēsu. Yooto, kōōyokooyto āwut kutiiny chiichoo ānkulēēnchi, “Āchāmē. Kunyi, itililiitu!” ");
INSERT INTO spyNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kusob ꞉chiichoo bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yu kāsob, kōōkāloonchi ꞉Yēēsu kule, ");
INSERT INTO spyNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“‑Mēēmwoochi chii ake tukul ng'aleechu. Nteenee iwē ānkuwēēboorchi keey *kibkōrōs kukasing', siitooku kule 'kēētililiitu. Iyib tukuuk chēē ibirchinēē Yēyiin kōōnkōy /sikēēyēwuung' kōrōsēēk kuu wōloo kimwooytooy *꞉Muusa ām kiruutēk.” ");
INSERT INTO spyNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ānkoo kuwuu nyooto, kiwo ꞉chiichoo ankwaamtaat lōkōōywēchoo. Ki yoo kēēwut ꞉Yēēsu kiriing' ake tukul, kōōruruukyinē keey ꞉biiko, kumāchē /kiisoob. Kiyey ꞉ng'aleechaa kut mēēkōōwutē ꞉Yēēsu kiriinkōōsyēchoo kukāsē ꞉biiko. Ānkoo kiibuurchinē keey ꞉Yēēsu taban wōlēē mālēēkitēē ꞉chii, kitākukwoonchinē ꞉biiko ām komoswookik tukul. ");
INSERT INTO spyNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nto mii bēsyēēt ake, kooyeey ꞉Yēēsu Kaabernaam. Nyēē mā tyaa, kukas ꞉biiko kule kāākuchō. ");
INSERT INTO spyNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kukwa ꞉biiko chēē chaang' ānkōōruruukyi keey kō ākoy saang' kut kimāmii wōlēē kiisiirē ꞉chii kereeng'. Kwoomchi ꞉Yēēsu biiko ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kutākwoomtooy ꞉Yēēsu lōkōōywēchoo, koomut ꞉biiko alake ang'wanu chiito ake nyēē kichunkutoot. ");
INSERT INTO spyNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nto kuuyu kimāmii ꞉bārooyinto nyēē kiimuuchē ꞉bichoo kukasee Yēēsu, kubeeta chiichoo ākoy kōōto barak ānkubut kēsyēkuut kutook yēē kiimuuchē kōōyokooytēē chiichooto. Kōōyokooyto chiichoo kumii tiirbeet ākoy yēē kimii ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yu kakas ꞉Yēēsu kule kiikoosēē keey ꞉bichoo inee, kumwoochi chiichoo kichunkutoot kule, “Wēnyoo, /kāākēēnyōōwuung' kaat ām choolwookātēēng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kimii yooto ꞉kāānēētikaab kiruutēk alake chēē kiing'unyng'uung'tōōs kumwooyē kule, ");
INSERT INTO spyNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ām nee yu ng'āloolē ꞉chiichi kuu nyi? Kāyib keey kule inee ku Yēyiin sōō? Ng'oo ꞉nyēē imuuchē kunyōōchi biiko kaat ām choolwookātēēng'waa, yoo mā Yēyiin nkit?” ");
INSERT INTO spyNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nteenee kōōnkēt ꞉Yēēsu ām tāmirmiryēēnyii kiyēē kimii kōōsōōtē ꞉kāānēētichoo. Kumwoochi kule, “Ām nee soosoot ꞉akweek kuu nyooto? ");
INSERT INTO spyNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kuskus nkōnō? Āmwoochi chiichi chunkutoot kule, ‘/Kākēēnyōōwuung' kaat,’ nto kule, ‘Ng'eet, ankiinam tiirbeeng'uung', ānkiiwēēsyēt’? ");
INSERT INTO spyNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","+Mookas raat kule āboontē ꞉anii, *Wēritaab Chii, kāāmuukēywēēk ām kōōrooni chēē āmuuchēē ānyōōchi biiko kaat ām choolwookātēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Yooto bakeenke kumwoochi ꞉Yēēsu chiichoo kule, “Yyoony, ankiinam tiirbeeng'uung', ānkiiwēēchi keey kaa.” ");
INSERT INTO spyNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","/Kēēmwoochinē chiichooto kichunkutoot kuu nyooto, kung'ēētē ānkunāmē tiirbeenyii ānkuwēēchinē keey, kukāsē ꞉biiko tukul. Kiilat ꞉biiko ankookaasta Yēyiin, kuuyu ki ng'al ꞉choo chēē kimānāāyēyākiis bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nto mii bēsyēēt ake, kuwo ꞉Yēēsu subak sakaramteetaab Tōōliilēētaab Kalilaaya. Kirub ꞉biiko chēē chaang' ankooneet ꞉inee ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kutākumii kuwēēsyētootē, kukas chiito ake nyēē kimii kēēbuur kēryō kōōruruuchē *syuuruut. /Kikēēkuurēē chiichoo Laawi araab Alfaayo. Kumwoochi ꞉Yēēsu kule, “Rubwaa!” Kung'eet ꞉Laawi ankurub. ");
INSERT INTO spyNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kuwēēto keey ꞉Yēēsu lētuunoo rubiikyii, kāāruruukikaab syuuruut chēē chaang' ākoo mbo biiko chēē /kikeetay choo kiboontootē keey tukul ānkubokwoomiis kaab Laawi. ");
INSERT INTO spyNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yu kakas *꞉Farisaayeek alake chēē ki kāānēētikaab kiruutēk kuu nyooto, kumwoochi rubiikaab Yēēsu kule, “Ām nee yu āmiisyē ꞉chiichi ākoo kāāruruukichu bo syuuruut ākoo mbo alak chēē ‑/mākiiriiku?” ");
INSERT INTO spyNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kumwoochi ꞉Yēēsu kāānēētichoo bo kiruutēk kule, “Chēēng'ootē ꞉biiko choo imnyoontōōs kāānyooyiintēēt. Nteenee māchēēng'ootē ꞉choo sobchootiin. Kyāāchōōnii ꞉anii chāākuurē biiko choo choolwookēnootiin, mēēbērē choo isōōtē kule churtootiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kikirē ām bēsyōōsyēchooto ꞉rubiikaab Bātisāniintēēt Yoowaana ākoo Farisaayeek āmiisyēēt. Nto mii yoo, kukwoonchi ꞉biiko Yēēsu ankuteebee kule, “Ām nee yu kirē ꞉rubiikaab Yoowaana ākoo choo bo Farisaayeek āmiisyēēt, āmēēbērē kirē ꞉cheekuuk?” ");
INSERT INTO spyNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kukētyinēē ꞉Yēēsu bichoo tyoonkōōchēēt kule, “‑Mēērukuutē keey ꞉chōōrōōnuutēkaab saanteetaab leekwa ām saakweetaab kooyēēy yoo mii ꞉saanteetaab leekwa. ");
INSERT INTO spyNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Makuyit ꞉bēsyēēt nyēē +/mākiinēmunēē saantaanaa wōlēē mii chōōrōōnuutēkyii. Ku yooto ꞉yēē makoorukuut keey ꞉chōōrōōnuutēkyii.” ");
INSERT INTO spyNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kumwoochi subak tyoonkōōchēēt ake kule, “‑/Mākēētilē ankeet nyēē tākulēēl /ānkēēkinēē sireet nyēē yoos. Yoo /kakeeyey kuu nyooto, kusirinyāktōōs ꞉ankaanaa ānkung'ēti yooto kubarayiit ꞉koong'ta miisin. ");
INSERT INTO spyNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nto subak ‑/mākēēroonkyinē kibkeetiis chēē /kātākēēyēyē wōōnkit nyēē yoos, kuuyu yoo kakuut ꞉kibkeetiisyechaa, kung'ētyēē wōōnkoo kuwasta keey *꞉tifaayiik. Nteenee māchāktōōs /kēēroonkyinē tifaayiik choo /kātākēēyēyē wōōnkit nyēē lēēl.” ");
INSERT INTO spyNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nto mii bēsyēēt nyēē ki *Sabaato, kumur ꞉Yēēsu ākoo rubiikyii mbareetaab nkoonuuk. Kumii kumurē yooto, kuswech ꞉rubiikyii mētēwookaab nkoonuuk, kubiiriir ankwaam. ");
INSERT INTO spyNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yu kakas *꞉Farisaayeek alake chēē kimiitē yooto kiyēē kayey ꞉rubiichoo, kumwoochi Yēēsu kule, “Kas! Ām nee yu mii ꞉rubiikuuk kwiiryēē kiruutyēēt nyoo yēētē /kēēkēsiis ām bēsyēētaab Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kukētyi ꞉Yēēsu Farisaayeechaa kule, “Manoosuman ꞉akweek, yoo ki-iryēē ꞉Bāytooyiintēēt *Tāwuti kiruutēk, yoo kyoomē ꞉kēmēwuut ākoo biiko choo kiboonto keey? ");
INSERT INTO spyNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yoo ki *kibkōrōs nyēē wōō ꞉Abyataar, kuwo ꞉Tāwuti *Kōōtaab Yēyiin /ānkiikoochi mukaatiinek choo /kikēēchāmchinē mbo *kibkōrōs nkit. Kyaam ꞉Tāwuti mukaatiinechaa ānkōōkoochi nkicheek biiko choo kiboonto keey. ");
INSERT INTO spyNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kunyoo, bāwu ꞉chiito Sabaato āmēēbērē bāwu ꞉Sabaato chiito. ");
INSERT INTO spyNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kunyi, bāwu *꞉Wēritaab Chii bēsyēētaab Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nto mii bēsyēēt ake, kōōwut subak ꞉Yēēsu *kōōtaab saayeet. Kimii ꞉chiito ake kōyooto nyēē kisōnkōchoot ꞉āwut. ");
INSERT INTO spyNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kimii yooto ꞉nkicheek *Farisaayeek chēē kimāchē kukas yoo kēēsoobiis ꞉Yēēsu ām bēsyēētaab *Sabaato subokōōyyoong'tēē kōōk. ");
INSERT INTO spyNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yu kakas ꞉Yēēsu chiichoo kisōnkōchoot ꞉āwut, kukuur kuchō taay. Nto yityo, ");
INSERT INTO spyNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","kuteebee bichoo kule, “Chāmwēēch ꞉kiruutēkyoo /keeyey kiy nyēē karaam ām bēsyēētaab Sabaato, nto nyēē miyaat? /Kiisoobiis, nto /kēēbākākiis?” Kisiisyo ꞉bichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kōōrōōtoot ꞉Yēēsu bichoo nyēē kāng'woonchi, kuuyu kimātinyē ꞉icheek kiisayta. Kumwoochi chiichoo kisōnkōchoot ꞉āwut kule, “Chuul āwut.” Kuchuulē kuu nyooto, kukārāmiitu ꞉āwut. ");
INSERT INTO spyNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kukāsē ꞉Farisaayeechaa kuu nyooto, kung'ēētōōs, bokutuuytōōs ākoo biikaab *Ērōōtē kusat koowaang'ta Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nto mii yoo, kuwo ꞉Yēēsu ākoo rubiikyii ākoy Tōōliilēētaab Kalilaaya. Kirub ꞉biiko chēē chaang' chēē kikwoonēē komoswookik alak chēbo yēēmēētaab Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Kibo ꞉alake chēē chaang' *kiriinkēētaab Yēērusālēēm ām yēēmēētaab Yuuteeya ākoo komoswookik alak chēbo yēēmoonooto. Kikwoonēē ꞉alake yēēmēētaab Itumeeya, kukwoonēē ꞉alake yēēmōōsyēk chēē kimii biitēētaab āynēētaab Yoortaan. Nto alak kibo yēēmēētaab Tiirō ākoo Sitōōn. Kikwoonii ꞉bichoo bokukāsē kiyēē kimii ꞉Yēēsu kuyēyē. ");
INSERT INTO spyNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nto kuuyu kikiikuchaang'iit ꞉biiko ānkimii kāwunuk keey kut kāākuriikyi ꞉Yēēsu sakaramteetaab tōōliilēēt, kōōyookto ꞉Yēēsu rubiikyii bokuyib mwēēnkēēt sukung'eet kōōnēētiis kumii kēēbuur mwēēng' ām tōōliil. ");
INSERT INTO spyNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kiwunuk keey ꞉biiko chēē kimnyoontōōs sukutiiny Yēēsu, kuuyu kikiikōōsoob ꞉inee biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kimii ꞉biiko chēē kiiyiimē ꞉tāmirmirook chēē miyootēch. Ki yoo kakas ꞉tāmirmiroochoo Yēēsu, kuyēyē bichoo kukutuny ām taayeetaab Yēēsu ānkōōnchōōyiis kule, “Inyiing' Lakwataab Yēyiin!” ");
INSERT INTO spyNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kiker koong' ꞉Yēēsu tāmirmiroochoo miyootēch ‑mēēboor wōlēē kiwuu ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nto mii bēsyēēt ake, kukwey ꞉Yēēsu biikyii ānkuwēēto lekem. ");
INSERT INTO spyNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bichooto ku taman āk āyēēng' ānkukuurēē chooto *lēbkēēyik. Kimāchē kule kōōbuurtooy keey sukōōyooktooy bokwoomtootē lōkōōywēk chēē kāroomēch ");
INSERT INTO spyNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ānkōōkoochi mbo kāāmuukēywēēk chēē ibēbēētēē tāmirmirook chēē miyootēch kung'ēētyēē biiko. ");
INSERT INTO spyNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Lēbkēēyichoo taman āk āyēēng' choo kikwēyē ꞉Yēēsu ku: Simōōni nyēē kitoochi ꞉Yēēsu kaayneet ake kule Bētērō, ");
INSERT INTO spyNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yāākōbō araab Sebetaayo ākoo ng'eetaabkaamet Yoowaana. Kikuur ꞉Yēēsu bichoo tukwaay kule ‘Bōnēērkē’. (Kaayna nyēē ibooru kule murēnēētaab iileet.) ");
INSERT INTO spyNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Chuut alak ku Antereeya, Filibō, Baatolomaayo, Mataayo, Toomaas, Yāākōbō araab Alfaayo, Taataayo, Simōōni Kananaayo, (kiibooru kaaynaani bo Kananaayo kule ki murēn nyēbo booryēēt) ");
INSERT INTO spyNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ākoo Yuuta Iskaryoot nyoo kichokuchoomtooy Yēēsu lētuunoo. ");
INSERT INTO spyNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yu kang'eetee ꞉Yēēsu lekem, kooyeey Kaabernaam. Kirub ꞉biiko chēē chaang' subak kut kimēēmuuchē ꞉inee ākoo rubiikyii kwoomiis. ");
INSERT INTO spyNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yu kāyityi kaamet ākoo mbo ng'eetaabkaamet ꞉ng'aleechaa, kuba kumāchē bokukwēryoon kuchō kaa, kuuyu /kikēēmwooyē kule kiikubun ꞉mēt. ");
INSERT INTO spyNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kimii ꞉kāānēētikaab kiruutēk alake chēē kikwoonēē Yēērusālēēm bokukāsē kiyēē kiinēētē ꞉Yēēsu. Kimwooyē ꞉kāānēētichoo kule, “Kookunam chiichi ꞉Bēēlsēbuul nyoo kāāyyoong'iintēētaab tāmirmirook chēē miyootēch. Nyooto ꞉nyēē miitē kōōkoochinē nkuruuk chēē kwētēē tāmirmirook chēē miyootēch.” ");
INSERT INTO spyNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yu kakas ꞉Yēēsu kuu nyooto, kukuur kāānēētichoo ānkōōboorchinēē ng'al tyoonkōōchoy. Kiteebee kule, “Imuuchē ꞉Kibrōkōsyoontēēt kukwet tāmirmirookyii? ");
INSERT INTO spyNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yoo kaakubchey keey ꞉lukēētaab booryēēt nyēbo kōōrēēt ake, ankubar keey nkit, ibuurtooy ānō ꞉kōōroonoo? Māburyētē? ");
INSERT INTO spyNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nto kubo kwaak yoo kāākutooytoochiin ꞉kayta ake, mābotē ꞉kayaa? ");
INSERT INTO spyNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kunyoo, yoo kāākukōōno ꞉Kibrōkōsyoontēēt kāāmuukēywēēk chēē ākwētēē lukēēnyii, mābotē ꞉bāytooyiisyēēnyii? ");
INSERT INTO spyNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mii ꞉ng'oo nyēē imuuchē kōōwut kaytaab chii nyēbo nkur ānkōōnēmunēē tukuukyii? Yoo kamarat chiichoo, mākoy kōōnēmunēē tukuukyii. ");
INSERT INTO spyNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kāāmwoowook, imuuchāktōōs kunyōōchi ꞉Yēyiin kaat chii ām choolwookātēēnyii tukul āk mbo kōchōōng'nāt ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nteenee ‑/mākēēnyōōchinē kaat chii nyoo kōchōnkyinē Tāmirmiryēētaab Yēyiin. Kunyoo, kiikurat chiichoo ꞉choolwookātēēt ākookoy.” ");
INSERT INTO spyNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kimwooyē ꞉Yēēsu ng'aleechu, kuuyu kiintosuur ꞉bichoo Tāmirmiryēētaab Yēyiin kumwooyē kule boonto ꞉Yēēsu *tāmirmiryēēt nyēē miyaat. ");
INSERT INTO spyNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Kimii ꞉biiko chēē chaang' kēēruruukyi keey Yēēsu. Yooto, kuyit ꞉kaamet ākoo mbo ng'eetaabkaamet ānkōōyookto /kēēkuurchi Yēēsu kuchō saang', kuuyu kimāmii ꞉bārooyinto wōlēē kiimuuchē kukasee inee. /Kēēmwoochi Yēēsu kule, “Mii kukuuriing' ꞉koomēt ākoo mbo ng'eetaabkoomēt ām saang'.” ");
INSERT INTO spyNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kukētyi ꞉Yēēsu kule, “Moomo anii ꞉ng'oo ānku mbo ng'eetaabiya anii ꞉ng'oo?” ");
INSERT INTO spyNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kukasaakasta ānkulē, “Bichu kēēboontē keey ꞉chēē mbo ng'eetaabiya ānku moomo. ");
INSERT INTO spyNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chii ake tukul nyoo yēyē ng'aleek choo māchē ꞉Yēyiin, ku nyooto ꞉nyēē ng'eetaabiya anii, cheebiya anii ānku moomo anii.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nto mii bēsyēēt ake, kuwo ꞉Yēēsu subak sakaramteetaab Tōōliilēētaab Kalilaaya. Kiiruruukyi keey ꞉biiko chēē chaang'. Kunyoo, kōōwut mwēēnkēēt ake ānkōōbuur ng'wēny nto yityo, kooneet bichoo kikiiyyoong'iis ām sakaramteetaab tōōliilēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kiineet biiko ng'aleek chēē chaang' kubuntēē tyoonkōōchoy. ");
INSERT INTO spyNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kimwooy kule, “King'eet ꞉kāābātiintēēt ake kuyis nkoonuuk. ");
INSERT INTO spyNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yu kāyis, kōōsuuchi ꞉alake kēēltaab too. Yooto kukwa ꞉tāriitēk ānkukwēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kōōsuuchi ꞉alake kitaweet wōlēē kitewerer ꞉teng'nyaanteet. Kubiityo ꞉choo areet akeenke, ");
INSERT INTO spyNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","nteenee yu kalay ꞉asiista kubeel kusisyo kuuyu kimāmii wōlēē kinērchinē ꞉tiikiitēk. ");
INSERT INTO spyNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kōōsuuchi ꞉alake wōlēē miitē ꞉kātook. Kubiityiin ꞉choo āk kātoochoo kookiich keey kut kumayey ꞉nkoonuuk āmit. ");
INSERT INTO spyNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nteenee kōōsuuchi ꞉alake teng'eek chēē kāroomēch. Kibiityo ꞉choo ankuyey āmiik. Kiyeyaatee āmiik chēē ng'ēri, chēē kāykāyēch, āk chēē choong'ēch.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yu keewaany ꞉Yēēsu tyoonkōōchoonoo, kumwooy kule, “Nyoo yēbē yiit, kukas.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kuboonto keey ꞉Yēēsu rubiikyii taman āk āyēēng' ākoo rubiik chuut alak, kuteebee ꞉rubiichoo Yēēsu kōōboorchi tyoonkōōchoonoo. ");
INSERT INTO spyNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kumwoochi ꞉Yēēsu kule, “/Kookeekweyaak akweek ōnkēt kiyēē iyeelaat kurubta keey āk wōlēē wuu ꞉bāytooyiisyēētaab Yēyiin. Nteenee mākukāsēē ꞉alake ng'aleek tukul tyoonkōōchoy. ");
INSERT INTO spyNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kuu yoo siraat kule, ‘Nto yoo kakasee koong', mākāsē kiy. Nto yoo kāyēbchi yiit, ‑mēēnkētē kiy. Nto kikas ꞉icheek ānkōōnkēt, nto kiikuweek ām miyootyēēng'waa, sukung'eet ꞉Yēyiin, kunyōōchi kaat.’” ");
INSERT INTO spyNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nto kurubta keey āk tyoonkōōchēētaab nkoonuuchoo, kumwoochi ꞉Yēēsu rubiichoo kule, “Ākoo mānōōnkēt kiyēē mwooyē ꞉tyoonkōōchooni? Yoo mānōōnkēt mbo nyiitēnyi ii, +mōōnkētēē nee, naas, chuut tukul? ");
INSERT INTO spyNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Okany āboorwook. /Kikiikerkeeyee ng'ālyoontēētaab Yēyiin kēbuswēēchoo /kikēēyisē. ");
INSERT INTO spyNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kerkeey ꞉biiko alake kēēltaab too. Kāsē ng'ālyoontēēt, nteenee chōōnii ꞉Syeetaani areet akeenke ankusaree ng'ālyoontoonoo. ");
INSERT INTO spyNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kukerkeey ꞉alake kitaweet. Toochē ng'ālyoontēēt ām ng'erekweek, ");
INSERT INTO spyNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","nteenee chutitēē ꞉ng'ālyoontoonoo kisich. Nto yoo /kākēēwēch /ānkēēwus, kubo ng'ālyoontēētaab Yēyiin, koochuchuuy keey. ");
INSERT INTO spyNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kerkeey ꞉alake teng'eek chēē kibiityēē ꞉kātook. Kāsē ng'ālyoontēēt, ");
INSERT INTO spyNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nteenee bēng'tēē tukuukaab kōōrooni āk muchastaab bāytit. Irēēwoonē ꞉tukuuchoo ng'ālyoontēētaab Yēyiin kumayey kiy. ");
INSERT INTO spyNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kukerkeey ꞉biiko alake teng'eek chēē kāroomēch. Kāsē ng'ālyoontēēt ānkukiilchi. Yēyiisyēē ꞉alake ng'ālyoontēētaab Yēyiin kuyi keey kisich, kuyi keey ām alak kukaykay, nto ām alak kuyi keey miisin.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kutas taay ꞉Yēēsu kumwoochi rubiikyii kule, “Māmii ꞉chii nyēē tābē taariit ānkōōkubuuyēē kērēbēēt, nto kōōkoochi kurērē, nteenee /kiikoochinē taariit yēē itōrōōroot sukoolebkeey kōōto. ");
INSERT INTO spyNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kunyoo, kiyēē wunyaat, mākutook. Nto kiyēē iyēēnoot, +/makeeng'aany. ");
INSERT INTO spyNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yoo yēbē yiit ꞉chii, kukas.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kumwoochi ꞉Yēēsu subak kule, “Māchē ōyēbē yiit, ānkōōrōōtootē kiyēē /kēēmwoowook. Yoo kōōkoochi biiko alak lēbkēēyyēētaab ng'ālyoontēētaab Yēyiin, mākukōōnook ꞉Yēyiin lēbkēēyyēēt nyēē wuu nyooto, ānkumākutāswook ake. ");
INSERT INTO spyNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nyoo yēyiisyēē kiyēē boonto, +/mākēētāsyi ake, nto nyoo māyēyiisyēē, +/mākiinēmunēē mbo kiyēē boonto.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kitas taay ꞉Yēēsu kumwoochi biiko tyoonkōōchēēt ake subak nyēē kiikerkeeyee bāytooyiisyēētaab Yēyiin. Kimwoochi kule, “Yisē ꞉kāābātiintēēt nkoonuuk mbareen. ");
INSERT INTO spyNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Rwēē kwēēmooy ānkukāsu bēēt. Nteenee kumii ꞉kēbuswēēk kubiitōōs kutēē yooto tukul āmēēnkētē ꞉inee wōlēē biititooy. ");
INSERT INTO spyNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bārbāru ꞉kēbuswēēchoo ankuyey kiriintōōk nto mii yoo kuyey mētēwook chēē ām lētuunoo kuyēchi āmiik. Teng'eek nkit ꞉chēē inēērē kēbuswēēk kut kuyey āmiik. ");
INSERT INTO spyNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nto yoo kāākururyo ꞉nkoonuuchoo, wokukēsiis ꞉chiitaab mbareet.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kumwoochi ꞉Yēēsu bichoo subak kule, “+Maakerkeeyee nee bāytooyiisyēētaab Yēyiin? Nto tyoonkōōch nee ꞉nyēē sāāboorunēē? ");
INSERT INTO spyNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ōyēbchi yiit, baa. Miitē ꞉kēbuswoontēēt ake nyēē /kēēkuurēē *aritaaliit. Mining' ꞉kēbuswoontooni ām kēbus alak tukul choo /kēēchoonē. ");
INSERT INTO spyNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nteenee yoo kabiit, kukēēytēē keet alak tukul choo /kēēchoonē mbareen. Yēyē sokonaak chēē wōōyēch chēē tēēkyinē ꞉tāriitēk kiyōōnchōōkwaa kuuyu iyēēlē ꞉sokonaachaa ānkuyēchinē wuurwēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kyoomchi Yēēsu biiko ng'ālyoontēētaab Yēyiin kubuntēē tyoonkōōchook chēē wuu chuutēchu kurubta keey āk wōlēē kitēēnto ꞉ng'oomnātēēng'waa. ");
INSERT INTO spyNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kimwoochinēē choo kimā rubiikyii ng'aleek tyoonkōōchēēt. Nto yoo kiboonto keey ꞉inee rubiikyii nkit, kōōboorchinē choo ng'aleek tukul. ");
INSERT INTO spyNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nto mii bēsyoonooto kosolēny, yu kaakoowaany ꞉Yēēsu kōōnēētiis, kumwoochi rubiikyii kule, “Okany kyaay tōōliilēēt kebe biitooniin.” ");
INSERT INTO spyNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kiwēētēē ꞉Yēēsu mwēēnkēēt āk rubiikyii ankurub ꞉nkicheek mwēēnkōōsyēk alake chēē kimii yooto. ");
INSERT INTO spyNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kumiitē tōōliil kwēēn, kuchō ꞉wusōōnēēt nyēē wōō ānkōōsooyēn mwēēnkēēt kusyōōlchi ꞉bēēko mwēēng' kut kitanyiy. ");
INSERT INTO spyNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yooto tukul, kimii ꞉Yēēsu rwoo ām mwēēng' lēt. Bokoong'eet ꞉rubiikyii kule, “Kāānēētiintēēt! ‑Mēēkāsē ꞉inyiing' kule kākēēbēku?” ");
INSERT INTO spyNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kung'eet ꞉Yēēsu ānkōōburyoong'to wusōōnēēt āk bēēko. Yu kayey kuu nyooto, kusiis ꞉wusōōnēēt ānkutēēmoon ꞉bēēko. ");
INSERT INTO spyNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yooto, kumwoochi ꞉Yēēsu rubiikyii kule, “Ntēē kōōmuuyē nyēē tēē nyi? Ākoo ‑mōōkoosēēnoo keey?” ");
INSERT INTO spyNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kiiywey ꞉icheek Yēēsu miisin, ānkulē, “Chii nee ꞉chiito nyi kāsyinē mbo ꞉wusōōnēēt āk bēēko?” ");
INSERT INTO spyNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nto mii yoo, kuyit ꞉Yēēsu ākoo rubiikyii saang'taab Keraasa ām biitēēt ake nyēbo tōōliilēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Yu kāloong'unēē ꞉Yēēsu mwēēng', kuchuwunee ꞉chiito ake nyēē kiboonto *tāmirmirook chēē miyootēch kochonkoosyek wōlēē /kikēēmuchinē biiko. Kimāmii ꞉chii nyēē kitākōōmuuchē chiichoo ānkoo /kakeeratee nyōrōōrōōnik. ");
INSERT INTO spyNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ki yoo /kakeeratee biinkōōnik āwunnyēk /ankeeratee nyōrōōrōōnik kērēēnkōōk kung'ētyēē choo. ");
INSERT INTO spyNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kiinchōōyootēē wōloo bo kochonkoosyek ākoo wōloo bo lekemoosyek kwiimēn āk kuyyeech ānkuboochēē keey rwoontōōk. ");
INSERT INTO spyNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yu kākāsyi ꞉chiichoo Yēēsu yēē lōō, kulābātyi ānkukutunkyi. ");
INSERT INTO spyNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Kumwoochi ꞉Yēēsu tāmirmiryoonoo miyaat nyi kiiyiimē chiichoo kule, “Chuwu!” Kubōloobōl ꞉chiichoo kumwooyē kule, “Imāchēēnoo nee ōō, Yēēsu Lakwataab Yēyiin, nyoo Iyweyaat. Āsooyiing' ām kaayneetaab Yēyiin kule ‑'meenyaliilaa.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kuteebee ꞉Yēēsu kule, “/Kēēkuurēēniing' ng'oo?” Kulē, “/Kēēkuurēēnoo ‘Lukēēt,’ kuuyu kēēchoong'ēch.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kisaaysaay ꞉tāmirmiroochoo Yēēsu kut kukētyinē keey kumakeekwetee icheek saang'aata. ");
INSERT INTO spyNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kimiitē ꞉ākwootiitaab tōōrōōk kwookēētēē yēbo lekemeet nyēē kilēēkitēē yooto. ");
INSERT INTO spyNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kusoom ꞉tāmirmiroochoo Yēēsu kule, “Ichāmwēēch kiiwut tōōrōōchuut.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kuchāmchi ꞉Yēēsu. Kuchuwu bakeenke ānkōōwutē tōōrōōchoo. Kiitiroomiis ꞉tōōrōōchoo kiyitē kisyēērōōk āyēēng' bokōōtuultēē keey lekem ānkōōsuuchi tōōliil kubēk. ");
INSERT INTO spyNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kimii ꞉biiko alake chēē kiriibē tōōrōōchoo. Yu kakas kiyēē kiyeyakay, kulabat bokwoomchi biikaab saang'aa tukul. Kukwa ꞉biiko bokukas kiyēē kayeyakay. ");
INSERT INTO spyNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","16","Bērē kuyit yēē kimii ꞉Yēēsu, /kēēmwoochi kiyēē kiyeyakay ām wōlēē mii ꞉chiichoo kiboonto tāmirmirook chēē miyootēch ākoo kiyēē kyaam tōōrōōk. Yooto, kukas chiichoo kukaakukaramiit ānkēēbuur ng'wēny koolaakaat. Kiiywey ꞉bichoo Yēēsu, ");
INSERT INTO spyNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ānkumwoochi kule, “Ng'eetee kōōrēēnyoo.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kumii ꞉Yēēsu kuloonyē mwēēng', kusoom ꞉chiichoo /kikiisoobē kule, “Kany keebeete keey tukwaay.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kumwoochi ꞉Yēēsu kule, “Iwē kaa ānkuwēēmwoochi biikwook kiyēē kāākuyēwuung' ꞉Yēyiin kubo kiisaynyii.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kunyoo, kyaamtaatee ꞉chiichoo yēēmoonoo bo Teekabooli kiyēē kiyēchi ꞉Yēēsu. Kiilat ꞉biiko tukul ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kiiyeeyee ꞉Yēēsu mwēēnkēēt ākoo rubiikyii ākoy biitoonoo kikwoonēē. Yu kayit, kukwa ꞉biiko chēē chaang' ānkōōruruukyi keey. Kutākumii sakaramteetaab tōōliilēēt, ");
INSERT INTO spyNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","kuchō ꞉kāāntōōyiintēēt ake nyēbo *kōōtaab saayeet nyēē /kikēēkuurēē Chāyirō. Yu kayit yēē kimii ꞉Yēēsu, kukutuny. ");
INSERT INTO spyNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yooto, kuriirchi Yēēsu kule, “Ātinyē chēēbnyuu nyēē imnyoonē ankaakulalakay miisin. Chōō, baa, chēētiinyēē āwung'uung' nto anyuun kusob ꞉lakwanyuu.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kucham ꞉Yēēsu ānkuwēēto keey. Kirub ꞉biiko chēē chaang' miisin kut kōōkiichootē keey. ");
INSERT INTO spyNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kimii yooto ꞉koorkēēt ake nyēē kikiikumnyaan kēnyiisyēk taman āk āyēēng' kusāyē ꞉korotiik. ");
INSERT INTO spyNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kikiikōōbootyi tukuuk tukul chēē kiboonto cheebsaakitiis chēē chaang' āmāsobē. Kitāsē taay ꞉bōōrto kumiyātiitu miisin. ");
INSERT INTO spyNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Kikiikukas /kyoomtooy Yēēsu. Yooto kumwoochi keey kule, “Yoo kāātiiny mbo sireenyii baateey, kāāsob.” Yu keesoot kuu nyooto, kuchō ām lēt ānkutiiny sireetaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kōōyyoong'iis ꞉korotiik. Kukas ām bōōrnyii kule kāākusob. ");
INSERT INTO spyNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yu kēēnkēt ꞉Yēēsu ām tāmirmiryēēt kule kāākōōsoobiis ꞉kāāmuukēywēēkyii, kuweech keey ankuteeb kule, “Ng'oo ꞉nyēē kāākutiiny sireenyuu?” ");
INSERT INTO spyNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kumwoochi ꞉rubiikyii kule, “‑Mēēkāsē kule chaang' ꞉biiko yoo imiitē ānkiitēēbē kule ng'oo ꞉nyi kātiinying'?” ");
INSERT INTO spyNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kukasta ꞉Yēēsu kumāchē kōōnkēt chiichooto kātiinyē sireenyii. ");
INSERT INTO spyNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kuuyu kiinkēt ꞉koorkoonoo kiyēē kaakuyeyakay ām bōōrnyii, kuchō nyēē kaakubootan ānkukutunyēē taayeetaab Yēēsu ānkumwoochi kiyēē kaakuyeyakay ām soboonnyii. ");
INSERT INTO spyNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kumwoochi ꞉Yēēsu kule, “Chēē, 'kēēsob kuuyu 'kēēkoosēēnoo keey! Mākoy tawokooyiimiing' ꞉bōōroo subak. Iwēētē bāybooyyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kutākumii ꞉Yēēsu kung'āloolē, kukwaanee ꞉biiko alake kaab kāāntōōyiintoonoo bo *kōōtaab saayeet ānkumwoochi kule, “Kaakume ꞉lakwang'uung'. ‑Mateemakee kiy kāānēētiintēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kisiil yiit Yēēsu ꞉ng'aleechaa. Yooto kulēēnchi kāāntōōyiintoonoo, “‑Mēēmuy, ikaaseenaa keey.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mānāāwēēto ꞉Yēēsu biiko tukul nteenee kichāmchi baateey Bētērō, Yāākōbō āk Yoowaana nyoo ki ng'eetaabkaametiitaab Yāākōbō. ");
INSERT INTO spyNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yu kayit kukas kāānchōōytaab biiko chēē kibirtooy keey, kuriirtōōs ānkwoomē mbuy. ");
INSERT INTO spyNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kuwo kō ānkulē, “Kiy nee nyēē ōbirtoochinē keey? Ōnchōōchinē nee? So, ōbērē kaakume ꞉leekweet? Ntēē mii kāruchi keey baateey.” ");
INSERT INTO spyNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yu kamwa ꞉Yēēsu kuu nyooto, kuroorchi ꞉biiko. Kukwet ꞉Yēēsu biiko tukul kuba saang' ānkukuur sikiikaab leekweet ākoo rubiichoo ki sōmōk ankuba ꞉tukul yēē kimii ꞉leekweet. ");
INSERT INTO spyNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kunam ꞉Yēēsu lakwanaa āwut ānkulē, “Ng'eet, baa ōō, chēē!” ");
INSERT INTO spyNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kung'eet bakeenke ꞉chēēboo ānkuwēēsyēt. Kiboonto lakwanaa kēnyiisyēk taman āk āyēēng'. Kinam biich kuut. ");
INSERT INTO spyNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kiikiimchi ꞉Yēēsu bichoo mabokwaamtaat ng'aleechaa ānkumwoochi sikiik kubay leekweet. ");
INSERT INTO spyNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nto lētuunoo, kung'eetee ꞉Yēēsu yooto ākoo rubiikyii ankooyeey Nāāsārēēt wōloo kinērēē. ");
INSERT INTO spyNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yu ki bēsyēētaab *Sabaato, kuwo *kōōtaab saayeet ānkōōnēētiis. Kiilat ꞉biiko tukul chēē kiyēbchi yiit ng'aleechaa ānkulē, “Kinyoorta ānō ꞉chiichi ng'aleechu? Ng'oomnān nee ꞉nyēē /kikiikoochi chiichi? Kāāmuukēy nee ꞉chēē boonto ꞉inee sukuyēyē ng'al chēbo kwōng'uut? ");
INSERT INTO spyNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ntēē kiinkētē chiichi! Mā kāātoong'iintēēt wēēroo bo Maaryaa? Mbo ng'eetaabkaamet oob ꞉Yāākōbō, Yōōsē, Yuuta ākoo Simōōni? Mā mbo cheebkaamet chu kēēboontē keey ām yu?” Kunyoo, kitay ꞉bichoo ng'aleekaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kumwoochi ꞉Yēēsu kule, “/Kēēkoonyitē *wōōrkooyoontēētaab Yēyiin, nteenee ‑/mākēēkoonyitēē saang'nyii āmākoonyitē ꞉tilyōōnuutēkyii ākoo mbo biikaab kōōng'waa.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Kiilat ꞉Yēēsu, kuuyu kitay ꞉bichoo kōōyēnchi ng'aleekyii. Manaayey ng'al chēē tyaa chēbo kwōng'uut. Kitiinyēē biiko chēē ng'ēri chēē kimnyoontōōs āwunnyēk ānkōōsoob. Yooto, kuwo soong'wēk alak wokōōnēētiis. ");
INSERT INTO spyNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nto mii bēsyēēt ake, kukuur ꞉Yēēsu rubiichoo ki taman āk āyēēng' kumāchē kōōyookto kubeetaatee āyēēng' āyēēng', bokwaamtaat ng'ālyoontēētaab Yēyiin. Kumanaaba, kumwoochi ꞉Yēēsu kule, “Kāākōōnook kāāmuukēywēēk ōbēbēētē tāmirmirook chēē miyootēch kung'ēētyēē biiko.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Kumwoochi subak kule, “Kunam ꞉chii kirōknyii. ‑Moonam āmnyoo, lool, beesyaa, sira nto mbo kwēyōōn. ");
INSERT INTO spyNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yoo kataachaak ꞉chiito ake ām kanyii, ōbuur kayaata ākoy ōng'ēētyēē saang'aata. ");
INSERT INTO spyNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nto yoo koobe saang'ta ake amataachaak ꞉biiko ankutay kukas kiyēē ōmwooyē, olelekte tēērtit ām kwēyōōnikwook kōōboorchi kule tākōōbuurto ng'ōōkisng'waa, nto yityo, ōbēēchi keey.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kibokwoomchinoot ꞉rubiichoo biiko kuweeksee miyootyēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kiibēbēēto tāmirmirook chēē miyootēch chēē chaang', ankooyiilee mwaayta biiko chēē chaang' choo kimnyoontōōs ānkōōsoob. ");
INSERT INTO spyNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King'alaalee ꞉biiko chēē chaang' Yēēsu kut kuyityi Bāytooyiintēēt *Ērōōtē ꞉ng'aleechaa. Kimwooyē ꞉biiko alake kule, “Kaakung'eetee ꞉Bātisāniintēēt Yoowaana meet, suku inee ꞉nyi mii kuyēyē ng'aleechu /kiilātē tukul.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kulē ꞉alake, “Acha! Wōōrkooyoontēēt *Eliiya ꞉nyi nyēē kāākōōyēēw.” Nto alak kumwooyē kule, “Wōōrkooyoontēētaab Yēyiin ꞉nyi nyēē kerkeey āk *wōōrkooyik choo kibo kēny.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yu kakas ꞉Ērōōtē kuu nyooto, kumwooy kule, “Ākoo kookung'eetee ꞉Yoowaana meet, chiichoo kyāāchwēntooy mētit!” ");
INSERT INTO spyNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kimwooy ꞉Ērōōtē kuu nyooto, kuuyu ki inee ꞉nyi kibākāchē Yoowaana. Nto wōlēē kichōōnto ꞉meetaab Yoowaana kimii kule: Kiboonto ꞉Ērōōtē ng'eetaabkaamet nyēē /kikēēkuurēē Filibō. Kitinyē ꞉Filibō koorkēēt nyēē /kikēēkuurēē Erootyaa. Kung'eet ꞉Ērōōtē koomut koorkoonoo kutākusobē ꞉Filibō. Yu kakas ꞉Yoowaana kiyēē kiyey ꞉Ērōōtē, kutuukyi kule, “Makaraam kōōnti ꞉chii koorkēētaab ng'eetaabkaamet, yoo tākusobē ꞉nyiin.” Yu kāmwooy ꞉Yoowaana kuu nyooto, kunam ꞉Ērōōtē ankukerta kō. ");
INSERT INTO spyNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kiwēch ꞉Erootyaa Yoowaana kut kumach mbo kule /keebakach nteenee kimēēmuuchāktōōs. ");
INSERT INTO spyNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kiiywēyē ꞉Ērōōtē Yoowaana, kuuyu ki chii ꞉Yoowaana nyēbo man, ānki churtaat. Ānkoo kiiyiimē mēt Ērōōtē ꞉ng'aleekaab Yoowaana, kitākuyēbchinē yiit kiyēē kimwooyē. ");
INSERT INTO spyNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nto mii bēsyēēt ake, kunyākyi Erootyaa ꞉bārooyinto. Kiyey ꞉Ērōōtē saakweet nyēē king'ērēkyinēē bēsyēēt nyēē /kikēēsichēē. Kikuur ꞉Ērōōtē biikyii chēē wōōyēch. Kikuur mbo kāāntōōyikaab lukēētaab booryēēt ākoo biiko alak chēē kitookunootiin ām Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Kichō ꞉chēēbtaab Erootyaa ānkutuumēē yooto koong'ereech Ērōōtē āk tāyēēkyii. Kōōwoolchi keey ꞉Ērōōtē kule, “Ātuwēnēēniing' kiy ake tukul nyēē imāchē kubo ng'erekweekyuu ām wōlēē kēētuumtē! Ānkoo yoo imāchē kereeryaanteetaab tukuuk tukul chēē āboontē, ākōōniing'!” ");
INSERT INTO spyNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yu kakas ꞉chēēboo kuu nyoo, kuwo wōlēē mii ꞉kaamet ankuteebee kule, “Moomo, waamwaayte /kēētuwēnēēnoo nee?” Kukētyi ꞉kaamet kule, “/Kēēkōōning' mētitaab Bātisāniintēēt Yoowaana.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kooyeey ꞉chēēbi areet akeenke wōlēē mii ꞉Ērōōtē ānkumwooy kule, “Āmāchē ikōōnoo mētitaab Yoowaana /kēēyibunēē kibseesweet areet akeenke!” ");
INSERT INTO spyNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kuteryekta ꞉mukuulēytaab Ērōōtē. Nteenee kuuyu kikiikoowaal keey ām taayeetaab tāyēēkyii, kuchāmchiin. ");
INSERT INTO spyNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kōōyookto ꞉Ērōōtē riibiintēēnyii kuwo wōloo /kikeekerta Yoowaana wokuchwen kaatit ānkuyib mētit. ");
INSERT INTO spyNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kuyibunēē ꞉nyoo mētoo kibseesweet ānkōōkoochi chēēbi. Kunam ꞉chēēboo ānkuyibchi kaamet. ");
INSERT INTO spyNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yu kakas ꞉rubiikaab Yoowaana kule kaakume, bokumuy. ");
INSERT INTO spyNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yu kēēyēēw ꞉lēbkēēyichoo ki taman āk āyēēng' choo kiiyooktooy ꞉Yēēsu, kumwoochi inee kiyēē kibokuyey āk nyēē kiineet. ");
INSERT INTO spyNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yooto tukul kiiliichinē keey biiko chēē chaang' Yēēsu kut kimāmii ꞉bārooyinto nyēē kyoomiisyēē āk rubiikyii. Kumwoochi rubiikyii kule, “Keebe wōlēē mālēēkitēē ꞉chii, subōōmuuny kisich.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kung'ēētyo ankubeetee mwēēnkēēng'waa kutākyinē keey wōlēē kimālēēkitēē ꞉chii. ");
INSERT INTO spyNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nto yu kakas ꞉biiko kuwēētii ꞉Yēēsu, kulabat koosaab sakaramteetaab tōōliilēēt kwoolāk taay. Kumii ꞉bichoo kubēētii, kutuuytōōs ākoo biiko alak chēē kiminyē kiriinkōōsyēk choo kimurē ꞉icheek. Kulumchinē ꞉nkicheek baanaa. ");
INSERT INTO spyNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nto yu kāwokuyit ꞉Yēēsu ākoo rubiikyii komosta nyi kimāchē bokōōmuunyēē, kurēkunēē mwēēng'. Bērē kukas ꞉Yēēsu bichoo kēēruruuch keey kumii kukānyiisyē, kuriiree, kuuyu kikerkeey kēēchiir chēē māboonto ākiin. Kooneet bichooto ng'aleek chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kumii kwiimēnē ꞉kōōrēēt, kubēēchi Yēēsu ꞉rubiikyii, ānkumwoochi kule, “Nto yu kāākwiimēn, ānkēēmiitē suurkwēēn. ");
INSERT INTO spyNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mwoochi bichu kuroot bokucheeng'aat kiyēē kaal sukwaam.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kukētyi ꞉Yēēsu kule, “Ōkoochi ꞉akweek kiyēē kaam.” Kuwēēkyi ꞉rubiikyii kule, “Imwooyē kule bokyaal mukaatiinek chēē yēmē bichu tukul? Chaang' ꞉beesaanik choo miisin!” ");
INSERT INTO spyNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kuteebee ꞉Yēēsu kule, “Ata mukaatiinek chēē ōboontē? Obe bookas.” Bērē bokukas ꞉rubiichoo, kunyōōr mukaatiinek muut āk *burburiinēk āyēēng' baateey. ");
INSERT INTO spyNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kumwoochi ꞉Yēēsu rubiikyii kumwoochi biiko kutetaatee keey lukōōsyēk ānkutēbēē ng'wēny yēbo saatyeet. ");
INSERT INTO spyNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kutetaatee keey konom konom ām tētuutēk bokol. ");
INSERT INTO spyNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kunam ꞉Yēēsu mukaatiinechaa ki muut ākoo burburiinēk āyēēng', kukas barak, ānkubirchi Yēyiin kōōnkōy. Nto yityo, kubcheyaabchey mukaatiinechaa ānkōōkoochi rubiikyii kōōkoochinoot biiko. Kubcheyaabchey nkicheek burburiinēchoo āyēēng' ānkōōkoochi biiko. ");
INSERT INTO spyNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kyoomiis ꞉biiko tukul kut kubiyoong'iis. ");
INSERT INTO spyNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nto mii yoo, kōōruruuch ꞉rubiik kaatuukanik koonyiit kērēboonik taman āk āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Biiko chēē kyaam āmiichu ku ꞉murēnik kisyēērōōk muut. ");
INSERT INTO spyNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yu keewaany ꞉rubiik kōōruruuch kaatuukanik, kumwoochi ꞉Yēēsu kulaany mwēēnkēēt koonto Beetsaayta, kutākōō-āmiisē ꞉inee biiko. ");
INSERT INTO spyNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yu kaakuba ꞉biiko, kuwo ꞉Yēēsu lekem ankuwokusaay Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kutuuyiitu ꞉kōōrēēt, kitākumii ꞉mwēēnkēēt baan, nteenee kimii ꞉Yēēsu nkit lekem. ");
INSERT INTO spyNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kiwusē ꞉yoomeet nyēē nyikiis kuchōōnēē taay. Kiinkētē ꞉Yēēsu kule kimii kāwuuyiityi rubiikyii kukwaany bēēko. Nto yu kāng'ēēyēn ꞉kōōrēēt, kuwēēsyētēē bēēko barak kutākyi keey rubiik. ");
INSERT INTO spyNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kukaakuriik ꞉Yēēsu, kukas ꞉rubiik. Yooto kulē, “Chii ēē, nto āyiin?” ");
INSERT INTO spyNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kumuuyo ꞉tukul. Yooto, bakeenke kumwoochi ꞉Yēēsu rubiichoo kule, “‑Mōōmuuyē! Ōkāng'u! Nto yu anii nyoo.” ");
INSERT INTO spyNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kulaany ꞉nkinee mwēēnkēēt. Yu kalaany, kuteeman ꞉yoomeet. Kiilat ꞉rubiik miisin, ");
INSERT INTO spyNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kōōboor kule ānkoo kikiikukas ꞉icheek bāyiisyoonoo bo biiko kisyēērōōk muut, manaakoomuuch kubēēr Yēēsu, ng'ālyoo nyēē tookunoot kule kiwuuyēch ꞉mētēwookwaa. ");
INSERT INTO spyNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kumii ꞉Yēēsu ākoo rubiikyii mwēēnkēēt, kutākyi keey Keneesareet. Yu kayit wōlooto, /kiiyyoong'to mwēēnkēēt /ankeerat simeenaata. ");
INSERT INTO spyNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yu kārēkunēē mwēēnkoonoo, kōōnkēt ꞉biikaab kōōroonooto Yēēsu areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kulabataatee kōōroonooto tukul kumwaaytaat kule kāākuchō ꞉Yēēsu. Yu kakas ꞉biiko ng'aleechu, /keekalabaan biiko choo kimnyoontōōs ām tiirboosyek kukwa wōlēē kimii ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","/Kikiimut choo kimnyoontōōs kukwa sōkōōniinēk ām soong'wēchoo āk kiriinkōōsyēchoo kiwēēsyētēē ꞉Yēēsu. Kisaay ꞉biiko Yēēsu kutiiny ꞉bichoo kimnyoontōōs *maaseek chēbo kotootookaab sireenyii sukusobcho. Kisob ꞉chii ake tukul nyēē kitiiny maaseechaa. ");
INSERT INTO spyNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nto mii bēsyēēt ake, kōōruruukyi keey Yēēsu *꞉Farisaayeek alake ākoo kāānēētik alak chēbo kiruutēk. Kikwoonēē ꞉bichu Yēērusālēēm bokukāsē kiyēē kiyēyē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nyēē mā tyaa, kukas ꞉bichoo rubiik alak chēbo Yēēsu kwoomiisyēē āwunnyēk chēē /kimanaakiintasiim kuu yoo mwooyē ꞉kiruutēkwaa. ");
INSERT INTO spyNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ām Farisaayeek āk Yuutayeek alak, kimāāmiisyē ꞉chii ake tukul yoo mānāākōōtiliil āwunnyēk kuu yoo kimwooyē ꞉booyikaab kēny. ");
INSERT INTO spyNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ki yoo kakwaanee ꞉bichu kōōkwēēt ake, kimāāmiisyē yoo mānāākōōtiliil keey. Kirubē kiruutēk alak chēē chaang' chēbo booyikaab kēny chēē /kiintāsiimē tērēkōōkwaa. ");
INSERT INTO spyNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kubōlchi ꞉Farisaayeechaa ākoo kāānēētichoo bo kiruutēk Yēēsu kule, “Nto yu āmiisyē ꞉rubiikuuk, āmēēbērē itiliilē āwunnyēk kuu yoo mwooyē ꞉kiruutēk?” ");
INSERT INTO spyNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kumwoochi ꞉Yēēsu kule, “Kibēēr *꞉Isaaya yoo king'āloolē kurubta keey akweek choo ōyēyē keey kule ōchurtootiin ām yoo siraat kule: ‘Koonyitēēnoo ꞉bichoo kuutuw, āmāboontēēnoo moo. ");
INSERT INTO spyNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ānkoo kasaaya, ‑māākāsyinē, kuuyu chōōnēē ꞉kāānēētiisyēēng'waa wōlēē mii ꞉biich buch.’” ");
INSERT INTO spyNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kutas taay ꞉Yēēsu kumwoochi kule, “Ākoo karaam akweek sōō, yu kyoobakaakte mākuutēkaab Yēyiin ānkōōriib kiruutēkaab biiko? ");
INSERT INTO spyNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ōboontē ng'oomnātēēt ake nyēē ōsātyinē Mākuutēkaab Yēyiin komos soorub kiruutēkwook. ");
INSERT INTO spyNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kimwooy ꞉siruutēkaab Muusa kule, ‘Iywey kōōn āk koomēt.’ Kumwooy subak kule, ‘Chii nyoo chubē kwaan nto kaamet, kunyoolchinē ꞉meet.’ ");
INSERT INTO spyNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nto akweek ōmwooyē kule, ‘Karaam yoo kēēkoochi ꞉chii Yēyiin kiinyii kubo kōrōsēēk ām *Kōōtaab Yēyiin, kusiir yoo kātāyēētyēēchinēē kiyooto kwaan nto kaamet.’ ");
INSERT INTO spyNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kiy ꞉nyoo nyēē kyooyeetee chiichoo kuyēētyēēchi kwaan nto kaamet. ");
INSERT INTO spyNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kēēlto ake ꞉nyi nyēē kyōōtub kiyēē kimwooyē ꞉Yēyiin ankookeeree kiruutēkwook ānkōōtāsē ōyēyē ng'aleek alak chēē chaang' chēē wuu chooto.” ");
INSERT INTO spyNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nto mii yoo, kukuur ꞉Yēēsu biiko chēē chaang' ānkumwoochi kule, “Ōyēbchi yiit ānkōōsōōtyēēchi kiyēē āmwooyē: ");
INSERT INTO spyNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Māyēyē chii ꞉tukuuk choo iwutē moo kumātililiit, nteenee yēyē ꞉choo kwoonēē moo.” ");
INSERT INTO spyNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yooto kubakaakta ꞉Yēēsu bichoo ankubeeta keey rubiikyii kayta nyēē kitēbunēē. Yu kayit wōlooto, kuteebee ꞉rubiikyii Yēēsu kōōboorchi kiyēē kāmwoochinē biiko. ");
INSERT INTO spyNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kuwālchi ꞉Yēēsu kule, “Ākoo manookas ꞉nkakweek kiyēē kāāmwooyē! ‑Mōōnkētē ꞉akweek kule kiyēē kēēwut mooyēētaab chiito kuchōōnēē saang', āmāyēyē chii kumātililiit? ");
INSERT INTO spyNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Āmiik choo āmē ꞉chiito mēēbērē iwutē mētinyii, nteenee iwutē mooyēēnyii nyēē makuwasta tukuuchooto kuba saang'.” (Kumwooyē ꞉Yēēsu kuu nyooto, kiibooru kule tiliilēch ꞉āmiik tukul.) ");
INSERT INTO spyNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kumwooy subak kule, “Tukuuk chēē kwoonēē āriinyii ꞉chēē yēyē kumātililiit. ");
INSERT INTO spyNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwoonēē ꞉kāāsōōtēywēēk chēē miyootēch mētitaab chiito. Yēyē chiito kumarta, kuchōōrso, kurumiis, ");
INSERT INTO spyNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kumooroong'nan, kusikorakay, kōōbērbēēriis, kuyēk kimuchasyaa, kuyey tuuyintaab moo, kuyeyaat seemseemnyeet, kukāsē keey āk ng'al alak tukul chēbo bēērbēēryo. ");
INSERT INTO spyNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kunyoo, yēyuutēchu miyootēch tukul chēē yēyē chiito kumātililiit ām taayeetaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nto mii yoo, kung'eetee ꞉Yēēsu Kalilaaya ānkuwo ākoy saang'taab Tiirō ām kōōrēētaab Fōyinikē ānkōōwut kōōto ake. Kimāchē kule nto ‑mēēnkēt ꞉chii ake tukul kule kāākuchō ꞉inee. Nteenee kimēēmuuchē kut kuwuny keey. ");
INSERT INTO spyNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kimii ꞉cheebyoosyeet ake nyēē kibo kōōroonooto bo Fōyinikē nyēē kimā Cheebyuutayaa. Kiboonto ꞉cheebyoosyaani chēēbnyii nyēē kiiyiimē *꞉tāmirmiryēēt nyēē miyaat. Yu kēēnkēt ꞉cheebyoosyaanaa kule kāākuchō ꞉Yēēsu, kuwo ānkukutunyēē taayeenyii ānkusoom wokōōbēbēēto tāmirmiryēēt nyēē miyaat kung'eetee chēēbnyii. ");
INSERT INTO spyNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kukētyi ꞉Yēēsu kule, “Kany kwoomiis ꞉lōkōkyuu kurook. Makaraam /kiinēm āmnyoontēētaab lēēkōōk /ānkēēmētyi ng'ōōkin.” ");
INSERT INTO spyNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kulē ꞉cheebyoosyeet, “Wuu nyooto ōō, Mokoryoontēēt. Ntēē imuuchē mbo ꞉ng'ōōkiik kukwey āmiik choo isuuytooy, yoo mii kwoomiisyē ꞉lēēkōōk.” ");
INSERT INTO spyNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kumwoochi ꞉Yēēsu kule, “Kuuyu 'kēēkoosēēnoo keey, kāāyēwuung' kuu wōloo 'kēēmāktooy. Kunyi, wēēchi keey, wēēnyōōru chēēbng'uung' kukaakung'eetee ꞉tāmirmiryoonoo miyaat.” ");
INSERT INTO spyNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kuwo ꞉cheebyoosyaanaa kaa. Kiwokunyōōr lakwanyii kukaakukaramiit ānkimii kāru ām kitiintiriit. ");
INSERT INTO spyNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yu kang'eetee ꞉Yēēsu saang'taab Tiirō, kumur *kiriinkēētaab Sitōōn ānkuwo ākoy Yēēmēētaab Teekabooli koong'asiis yēbo Tōōliilēētaab Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yu kāwokuyit wōlooto, kōōmutyi ꞉biiko cheemiinyaanteet ake nyēē kibalyaat. Kisoom ꞉bichoo Yēēsu kutiiny chiichoo sukusob. ");
INSERT INTO spyNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kunam ꞉Yēēsu cheemiinyaantaanaa ankootabaanee wōlēē kimii ꞉biiko. Nto yityo, kōōwutēē mooriik yiitiikaab chiichoo ānkung'utyi moorineenyii ānkutiinyēē ng'elyebtaab chiichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kukas barak ānkulēēnchi chiichoo, “Iyaatakse ankiityaakse!” ");
INSERT INTO spyNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yu kāmwooy kuu nyooto, kuyootākiis ꞉yiitiik, kootyaak ꞉ng'elyebta koochuurta ng'aleek. ");
INSERT INTO spyNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Ānkoo kiikiimchi ꞉Yēēsu biiko kule mamwaaytaat ng'aleechaa, kiilat ꞉bichoo miisin ankwaamtaat kiyēē kikas. Kimwooyē kule, “Nto yu kaakuyey ꞉Yēēsu kiy ake tukul kukaramiit. Yēyē biiko choo miinkyootiin kukas ng'aleek ākoo choo bālyootēch kung'alaal nyēē karaam.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kimii ꞉bēsyēēt ake subak yēē kiiruruukyi keey ꞉biiko chēē chaang' Yēēsu. Yu kaakoowaany ꞉Yēēsu kwoomchi bichoo lōkōōywēk, kukuur rubiikyii ānkulēēnchi, ");
INSERT INTO spyNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ntēē kaariiree bichu. Kōōkiibuurtē keey bēsyōōsyēk sōmōk, āmāmii ꞉kiyēē āmē. ");
INSERT INTO spyNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kwoonēē ꞉bichu alake lōōyin. Yoo kāāmwoochi kuba āmēēbērē kāāchēēnkyi kiyēē kaam, ākoy kōōmiistoot alak ꞉kēmēwuut ām kēēltaab too.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kumwooy ꞉rubiikyii kule, “Ara nyōōrchinē ānō ꞉chii mukaatiin ām suurkwēēnooni chēē /kakeebayee bichu tēē chu?” ");
INSERT INTO spyNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kuteebee ꞉Yēēsu rubiichoo kule, “Ōboontē mukaatiinek ata?” Kulē ꞉rubiik, “Tisab.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kumwoochi ꞉Yēēsu biiko kōōbuur ng'wēny. Kunam mukaatiinechaa tisab, kubirchi Yēyiin kōōnkōy ankubcheyaabchey ānkōōkoochi rubiikyii kōōkoochinoot biiko. ");
INSERT INTO spyNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kiboonto *burburiinēk chēē ng'ēri. Kunam ꞉Yēēsu burburiinēchoo, kubirchi Yēyiin kōōnkōy ānkōōkoochi rubiikyii kubcheytaat. ");
INSERT INTO spyNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Kyoomiis ꞉biiko chēē kiyitē wōloo bo kisyēērōōk ang'wan kut kubiyoong'iis. Yu /kāākyoomiis kubēk, kōōruruuch ꞉rubiik kaatuukanik koonyiit kērēboonik tisab. Lētuunoo, kumwoochi ꞉Yēēsu biiko kubēēchi keey ");
INSERT INTO spyNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ankulaany ꞉inee mwēēng' ākoo rubiikyii kutākyi keey saang'taab Talmanuuta. ");
INSERT INTO spyNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nto miitē bēsyēēt ake, kukwoonchi Yēēsu *꞉Farisaayeek alake chēē kimāchē kukwiil ānkumwoochi kuyēchi kiy nyēbo kwōng'uut nyēē kēēboorchinēē kule boonto ꞉inee kāāmuukēywēēk chēē kwoonēē kibkōōnkōy. Kimiitē yooto kutyēmē. ");
INSERT INTO spyNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","King'woonchi Yēēsu, ānkulē, “Lēyyē! Ām nee yu māchē ꞉biiko alake kiy nyēbo kwōng'uut? !Kāāmwoowook, māmii ꞉kiy nyēē +/mākiiboorchi biiko chēē wuu chooto.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kubakaakta ꞉Yēēsu bichoo ankooyeey wōlēē kimii ꞉mwēēnkēēt kumāchē kuba ākoo rubiikyii komosta ake. ");
INSERT INTO spyNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kikiwuutyēē ꞉rubiik kunam mukaatiinek ām wōloo kikwoonēē nteenee ki mukaatiit akeenke baateey nyēē kimii mwēēng'. ");
INSERT INTO spyNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yooto kōōkāloonchi ꞉Yēēsu rubiikyii kule, “Ōriibēē keey kiyēē bāyēēnook *꞉Farisaayeek āk *Ērōōtē.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kiisōōtē ꞉rubiichoo kule king'āloolēē ꞉Yēēsu mukaatiinek. Kuteebee keey kule, “Kamwaaytee nee ꞉Yēēsu ng'aleechaa? Kuuyu ‑mākēēboontē mukaatiinek?” ");
INSERT INTO spyNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kiinkēt ꞉Yēēsu kiyēē kimwooyē ꞉rubiik. Yooto kuteebee kule, “Ām nee yu ōmwooyē kule ‑mōōboontē mukaatiinek? So, mānōōsēwu kura? Ākoo tākuwuuyēch ꞉mētēwookwook. ");
INSERT INTO spyNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bo nee ꞉koonyek chu ōboontē? Ānku bo nee ꞉yiitiik? ");
INSERT INTO spyNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kyōōwuutyēē mbo yoo kyāābāyēē mukaatiinechaa muut biiko kisyēērōōk muut? Kiinyiit ꞉kaatuukanik kērēboonik ata?” Kulē ꞉rubiik, “Taman āk āyēēng'.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kuteebee ꞉Yēēsu subak kule, “Nto yoo kwāābāyēē mukaatiinechaa tisab biiko kisyēērōōk ang'wan, konyiy ꞉kaatuukanik kērēboonik ata?” Kulē ꞉rubiik, “Tisab.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kumwoochi ꞉Yēēsu rubiikyii kule, “‑Mōōkāsēē mbo chooto?” ");
INSERT INTO spyNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nto mii yoo, kuyit ꞉Yēēsu ākoo rubiikyii Beetsaayta. Yooto, kōōmutyi ꞉biiko alake cheebkoraatyaanteet ake. Kisoom ꞉bichoo Yēēsu kutiiny chiichoo sukusob. ");
INSERT INTO spyNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kunam ꞉Yēēsu āwutaab cheebkoraatyaantaanaa ānkukwēryoot ākoy wōlēē kimālēēkitēē ꞉chii. King'utyi koonyekaab chiichoo ankutabtab. Yu kēēnēm āwunnyēk, kuteebee kule, “Ikāsē kiy?” ");
INSERT INTO spyNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kukasta ꞉chiichoo ānkulē, “Ākāsē biiko, nteenee wuu keet chēē bēēsyētē.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kutabtab subak koonyekaab chiichoo. Yooto, kukās ꞉koonyekaab chiichoo nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kumwoochi ꞉Yēēsu kule, “Iwē kaa, nteenee ‑maweemwaaytaate kiyēē kāāyēwuung'.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nto mii yoo, kuwēēto keey ꞉Yēēsu rubiikyii soong'wēk chēē kilēēkitēē *kiriinkēētaab Kayisareeya Filiibi. Kumii kēēltaab too, kuteebee rubiikyii kule, “Mwooyē ꞉biiko kule anii ng'oo?” ");
INSERT INTO spyNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kukētyi ꞉rubiik kule, “Mwooyē ꞉biiko alake kule inyiing' Bātisāniintēēt Yoowaana, kubērē ꞉alake *Eliiya, nto alak kumwooyē kule akeenke ām *wōōrkooyikaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yooto kuteebee ꞉Yēēsu icheek kule, “Nto akweek ōbērē anii ng'oo?” Kulē ꞉Bētērō, “Inyiing' *Kāārārookiintēēt nyoo kikēēkānyē kuchōōnēē Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kulē ꞉Yēēsu, “Wuu nyooto! Nteenee masimomwaaytaate.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nto mii yoo, kutoow ꞉Yēēsu kumwoochi rubiikyii kule, “Ākoy kubuntēē *꞉Wēritaab Chii nyāliluutēk chēē chaang'. Makutay ꞉booyik, mbo *kibkōrōs chēē wōōyēch ākoo kāānēētikaab kiruutēk. +/Makeebakach nto miitē bēsyēētaab sōmōk /kiing'eetee meet.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kimwooy ꞉Yēēsu ng'aleechaa kutook. Yu kakas ꞉Bētērō kuu nyoo, kuwēēto Yēēsu komos ankootaayee ng'aleechaata kāmwooyē. ");
INSERT INTO spyNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nteenee kōōtuukyi ꞉Yēēsu Bētērō batay ānkōōburyoong'to Bētērō kule, “Sateenaa keey, Syeetaani! Bo ꞉kāāsōōtēywēēkuuk biich buch nyēē ‑mēēnkētē wōlēē māktooy ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kukuur ꞉Yēēsu biiko choo kiboontootē keey rubiikyii ānkumwoochi kule, “Chii ake tukul nyoo māchē kurub ng'aleekyuu, manyokoriit meet ankusaanee keey kiyēē māchē ꞉mooyēēnyii. Yoo kaakucham kuyey kuu nyooto, kuruba. ");
INSERT INTO spyNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nyoo kāyēētyi keey soboontaab kōōrooni, mākōōboot soboonnyii bo kibchuulyo. Nto nyoo kēēkooyto soboonnyii ām kōōrooni kubo anii ākoo kāānēētēywēēkyuu, mākunyōōr *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kāroomnyo nee ꞉nyēē nyōōru ꞉chii yoo kēētukuulchi keey tukuukaab kōōrooni ānkōōboot soboonnyii bo kibchuulyo? ");
INSERT INTO spyNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nto kiy nee ꞉nyēē imuuchē ꞉chii kuwalee soboonooto? ");
INSERT INTO spyNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chii ake tukul nyoo kataya āk ng'aleekyuu ām kōōroonēēb kibng'ōōkisiisyēchu, +maatay ꞉nkanii, *Wēritaab Chii, bēsyoonoo āchōōntooy keey malayikaanik ām lēbkēēyyēētaab Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kimwoochi ꞉Yēēsu subak kule, “!Kāāmwoowook, kumānāābēk ꞉biiko alake chēē mii yu, makukas bāytooyiisyēētaab Yēyiin nyēē chōōntooy kāāmuukēywēēk.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yu kakeeyta ꞉bēsyōōsyēk lo, kuwēēto keey ꞉Yēēsu Bētērō, Yāākōbō ākoo Yoowaana tulwēēt ake nyēē ki suurkwēēnnyoo. Kumii wōlooto kukas ꞉rubiik kukaakuweek ꞉eertaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kiweek ꞉nkicheek sirookyii kuleelakiitu kut kōōlēkēchēēchtōōs. Ki leelach lēēlinto ake nyēē ‑mēēmuuchē ꞉chii bēsyēēt ake kōōlēēliit sira nyēē lēēl kuu nyooto! ");
INSERT INTO spyNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kukas ꞉rubiik *Eliiya ākoo *Muusa kung'āloolē ākoo Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yooto, kumwoochi ꞉Bētērō Yēēsu kule, “Kāānēētiintēēt, karaam kule nee kēēmiitē yu. Kany keeyeyte kēryōōsyēk sōmōk, nyeeng'uung', nyēbo Muusa ākoo nyēbo Eliiya.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kimēēnkēt ꞉Bētērō kiyēē kimwooyē. Kiiywēyiis ꞉rubiichoo miisin ām kiyēē kiyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nyēē mā tyaa, kōōyuung' ꞉boolteet, ankoolaambuuch icheek tukul choo kimii yooto. Kumwooy ꞉Yēyiin ām booltaanaa āriit kule, “Lakwanyuu ꞉nyi nyēē āchāmē. Kunyoo, ōkāsyi kiyēē mwooyē.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kukasta ꞉rubiichoo nto bērē kulē, kumākāsē chii, nteenee ki Yēēsu nkit. ");
INSERT INTO spyNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yu kimii kurēkunēē lekem, kōōkiimchi ꞉Yēēsu rubiichoo kule, “‑Mōōmwoochi chii ake tukul kiyēē kookas ākoy bēsyēēt nyēē kaakung'eetee *꞉Wēritaab Chii meet.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kisiista ꞉rubiichoo ng'aleechaa ankuteebee keey kule, “Ibooru nee ꞉ng'ālyoontooni bo ng'eeteetaab meet?” ");
INSERT INTO spyNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nto mii yoo, kuteebee ꞉rubiichoo Yēēsu kule, “Ntēē mwooyē ꞉kāānēētikaab kiruutēk kule māchāktōōs kōōntōōw ꞉Eliiya ām Kāārārookiintēēt?” ");
INSERT INTO spyNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Kukētyi ꞉Yēēsu kule, “Man, sinee intōōwu ꞉Eliiya sukukaramiit ꞉kiy ake tukul. Kāāmwoowook, kisimkuchō ꞉Eliiya /ānkiikēēyēchi kiy ake tukul nyēē kimāchē ꞉biich kuu wōloo mwooytooy ꞉siruutēk. Yoo ākoo kiikukaramiit ꞉kiy ake tukul, ām nee /sikeesir ām kitaabuutaab Yēyiin kule makunyalilee ꞉Wēritaab Chii tukuuk chēē chaang' ānku +/mākiintosuur?” ");
INSERT INTO spyNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yu kārēkunēē ꞉Yēēsu lekem ākoo rubiichoo ki sōmōk, kunyōōr rubiik choo kibākooktooy kukēēruruukyi keey ꞉biiko chēē chaang'. Kimii ꞉nkicheek kāānēētikaab kiruutēk alake kukwiilē keey ākoo rubiichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yu kakas ꞉biiko Yēēsu, kung'ērēkyi ankutorooch bokoosubaay. ");
INSERT INTO spyNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kuteeb ꞉Yēēsu kule, “Ōmiitē ōkwiilēē keey nee?” ");
INSERT INTO spyNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kumwooy ꞉chiito ake ām kwēēnuutaab bichoo kule, “Kāānēētiintēēt, kātāāmutu lakwanyuu nyēē boonto *tāmirmiryēēt nyēē miyaat nyēē kiikuyey kuratakay ꞉ng'elyebta. ");
INSERT INTO spyNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yoo kātēryēkyi ꞉tāmirmiryoonoo leekweet, kōōryookyinē ng'wēny kukabus, nyiyē keelek, ankukwiilakay ꞉bōōrto tukul. Kāāmwoochi rubiikuuk kōōbēbēēto tāmirmiryooni miyaat, nteenee maneemuuch.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kumwooy ꞉Yēēsu kule, “Wuu nee ꞉mētēwookwook ēē! Manookaaseenaa keey! Sāābuurtook ākoy āyu? Nto +māāmuytoochook ākoy āyu? Omutwaa wēēroo.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","/Kiimutyi. Yu kakas ꞉tāmirmiryoonoo Yēēsu, kōōsimsiim wēēroo ānkōōryookyi ng'wēny. Koomilmiil kut kukabus. ");
INSERT INTO spyNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kuteebee ꞉Yēēsu kwaaniitaab wēēroo kule, “Kung'eetee āyu ꞉yēē kiwuu nyiitēnyi ꞉wēēri?” Kulē ꞉kwaan, “Kung'eetee leekwaanti. ");
INSERT INTO spyNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kiikusyeem ꞉tāmirmiryoonoo ām bēsyōōsyēk chēē chaang' kule kubakach wēēri. Kiwunukyinē mā, nto kutōōrchinē bēēko. Wuusyō! Iriireeneech, ānkiisārwēēch ēē, wē, yoo 'imuuchē!” ");
INSERT INTO spyNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kumwoochi ꞉Yēēsu kule, “'Keemwaayte ānō kule yoo āmuuchē? Imuuchāktōōs ꞉kiy ake tukul ām chii nyoo ikoosēē keey Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kuriiree keey ꞉kwaaniitaab wēēroo kule, “Ākoosēē keey sinee ꞉anii Yēyiin, nteenee akuskus ām kaakaaseet. Ititiiroo saakaasee keey Yēyiin miisin.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yu kakas ꞉Yēēsu biiko kālābāt ānkōōruruukyi keey yooto, kōōbēbēēto tāmirmiryoonoo miyaat nyēē kiyey wēēri kumiiny ankuratakay ꞉ng'elyeb kule, “Chuwunee wēēri āmāwēēkētyi keey subak.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kōōnchō ꞉tāmirmiryoonoo ānkōōsimsiim wēēroo ankuchuyta! Kulyelta ꞉wēēroo wuu nyēē kame. Kulē ꞉biiko, “Kaakume!” ");
INSERT INTO spyNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kunam ꞉Yēēsu āwutaab wēērooto ankoong'eet kōōyyo. Kukaramiit ꞉wēēroo. ");
INSERT INTO spyNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yu kiboonto keey ꞉Yēēsu rubiikyii ām kō, kuteebee ꞉rubiik Yēēsu kule, “Ām nee yu kāmākiimuuchē ꞉acheek kiibēbēētē tāmirmiryoonoo?” ");
INSERT INTO spyNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kumwoochi ꞉Yēēsu kule, “Mēēmuuchāktōōs ꞉tāmirmiryēēt nyēē wuu nyoo yoo manoosaay āmānōōkir āmiisyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","King'eetee ꞉Yēēsu yooto ākoo rubiikyii ānkubēēchi keey. Kibeesyetaatee Yēēmēētaab Kalilaaya nto kuuyu kimii kōōnēētootē rubiikyii, manaamach kule kōōnkēt ꞉chii ake tukul wōlēē kimii ꞉icheek. Kimwoochi rubiichoo kule, “+/Mākiiyokoochi *Wēritaab Chii biiko. +/Makeebakach, nto mii bēsyēētaab sōmōk, +/makiing'eetee meet.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kimēēnkēt ꞉rubiik kiyēē kimwooyē ꞉Yēēsu nteenee kiiywey kuteebee. ");
INSERT INTO spyNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nto mii yoo, kuyit ꞉Yēēsu ākoo rubiikyii Kaabernaam. Kumii kō, kuteebee ꞉Yēēsu rubiikyii kule, “Kiy nee nyi kōōkwiiloonunēē keey ām kēēltaab too?” ");
INSERT INTO spyNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mānāāwāl kiy ꞉rubiik, kuuyu kimii kukwiilēē keey kule ng'oo ꞉nyēē wōō. ");
INSERT INTO spyNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kōōbuurto ꞉Yēēsu rubiikyii ānkumwoochi kule, “Nyoo māchē kōōntōōchi alak, kuyib keey ng'wēny, ānkuchāmē kuyēētyēēchinē chuut.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yooto, kukuur ꞉Yēēsu leekweet ake ānkōōyyoong'tēē taayeetaab rubiik ānkōōmuuryēē lakwanaa āwunyii ānkulē, ");
INSERT INTO spyNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Chii ake tukul nyēē toochē chii nyēē wuu lakwani ām kaayneenyuu, kaakutaacha, nto nyoo kataacha, kaakutaach Yēyiin nyoo kiiyookwoo.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yu keewaany ꞉Yēēsu kumwooy kuu nyooto, kumwoochi ꞉Yoowaana kule, “Kāānēētiintēēt, kikeekas chiito ake nyēē kiibēbēētooy tāmirmirook chēē miyootēch kuyēyiisyēē kaayneeng'uung'. Kikeeyeetee, kuuyu kimā rubiintēēng'uung' ake.” ");
INSERT INTO spyNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kumwooy ꞉Yēēsu kule, “‑Mooyeetee. Yoo mii ꞉chiito nyēē yēyē ng'aleek chēē /kiilātē ām kaayneenyuu, mēēbērē makung'alaaleenaa nyēē miyaat. ");
INSERT INTO spyNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nyoo mākwiilēēch ku nyēēnyoo. ");
INSERT INTO spyNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","!Kāāmwoowook kule, chii nyoo kāyēētyēēchook bēēko chēē kooyyee, kuuyu ōyēku cheechuu, ku ākoy /kēētuwēn. ");
INSERT INTO spyNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Chiito nyoo kaken chii nyēē takung'arng'ar ām choo iyēnwoo kutaya, kumisyinē nyoo /kēērātyi kaat rwaa nyēē /kēēng'ooysēē /ānkēētōōrchi araaray kuling'ta. ");
INSERT INTO spyNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yoo kēēsākyiing' ꞉āwung'uung' itayaa, itilte, kuuyu kaykay inyōōru *soboontaab kibchuulyo iboontē āwut akeenke kusiir iboontē āwunnyēk tukwaay /ānkēētōōrchiing' wōlēē bo maataab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Yoo kēēsākyiing' ꞉kereenkeeng'uung' itayaa, itilte, kuuyu kaykay ing'waalee kereenkeet akeenke ānkiinyōōru soboontaab kibchuulyo kusiir iboontē kērēēnkōōk tukwaay /ānkēētōōrchiing' wōlēē bo maataab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nto yoo kēēsākyiing' ꞉koong'uung' itayaa, ilōōtu. Kaykay iwē Kaab Yēyiin iyēku kimekoong'nyaa, kusiir iboontē koonyek tukwaay ānku /bokēētōōrchiing' ");
INSERT INTO spyNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","wōlēē ‘Mābēku ꞉mōkiik, āmāmisē ꞉ma kēnyiis.’ ");
INSERT INTO spyNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chii nyoo rubiintēēnyuu mākubuntēē ng'wooninto sukutililiit. ");
INSERT INTO spyNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Karaam yoo 'kēēnēmchi keey yiisyēētaab Yēyiin. Nto yoo 'keechuchuyee keey yiisyoonoo, +'meeyey kule nee sitēēyēchi Yēyiin yiisyēēt. Kunyoo, ōnēmchinē keey yiisyēētaab Yēyiin ānkōōchoomtōōsii.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nto mii yoo, kung'eetee ꞉Yēēsu yooto, kwaay āynēētaab Yoortaan ānkutākyi keey Yēēmēētaab Yuuteeya. Kiiruruukyinootē keey ꞉biiko chēē chaang' kutēē yooto tukul. Kooneet ꞉Yēēsu biiko ng'ālyoontēētaab Yēyiin kuu yoo kwēēnēētē kwaak. ");
INSERT INTO spyNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yooto, kukwoonchi *꞉Farisaayeek alake chēē kimāchē kutyem, ankuteebee kule, “/Kēēchāmē ām kiruutēkyoo kukwet ꞉chii koorkēēnyii?” ");
INSERT INTO spyNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kukētyi ꞉Yēēsu ām tēēbuutyēēt kule, “Kimwoochi nee *꞉Muusa mbo kuukoong'?” ");
INSERT INTO spyNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kumwooy ꞉bichoo kule, “Kichāmchi ꞉Muusa saanteet kusirchi barweet nyēē bārēē kooyēēyto.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kumwoochi ꞉Yēēsu Farisaayeechaa kule, “Kichām ꞉Muusa barwaanaa, kuuyu wuuyēch ꞉mukuulēywēkaab biiko. ");
INSERT INTO spyNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yu kitoowu ꞉Yēyiin kuyēyē kōōrēēt, ‘Kiyey murēn āk koorko.’ ");
INSERT INTO spyNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kunyoo, kiyooto nyēē yēyē murēn kung'eetee kōōtaab kwaan āk kaamet ankoomut koorkēēnyii ");
INSERT INTO spyNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ānkunoomnyo ꞉tukwaay kuyēk kiy akeenke.’ Mēēbērē tāku biich āyēēng', nteenee kāākuyēk kiy akeenke. ");
INSERT INTO spyNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kunyi, mēēbēēsyo ꞉chii kiyēē kiikōōnoomcho ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kumii kō, kuteebee ꞉rubiik Yēēsu kōōboorchi ng'ālyoontoonoo. ");
INSERT INTO spyNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kumwoochi kule, “Chii nyoo kakwet koorkēēnyii ankoomut ake, kāākuchoolwookēnchi koorkoonoo kākwētē. ");
INSERT INTO spyNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nto nkinee koorkēēt nyoo katay saanteenyii ankoomut keey ākoo chiito ake, kāākuchoolwookēnchi saantaanaa kātāyē.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kimii ꞉biiko alake chēē kiimutyi Yēēsu lēēkōōk sukutiinyēē āwunnyēk kōōbēruur, nteenee kiiburyoong'to ꞉rubiik bichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yu kakas ꞉Yēēsu kiyēē kiyey ꞉rubiik kukōrōmchi kule, “Ōbāroochi lōkōchoo minkēēch kukwa wōlēē āmiitē! ‑Mooraany kuuyu biiko chēē wuu chuutēchu ꞉chēē iwutē bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","!Kāāmwoowook, chii nyoo ‑mēēkoosēē keey Yēyiin kuu wōloo yēytooy ꞉lōkōchoo, ‑mēēwutē ꞉nyoo Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kutorooch ꞉Yēēsu lōkōchoo ānkutiiny āwunnyēk ankusaay Yēyiin kōōbēruur. ");
INSERT INTO spyNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yu katas taay ꞉Yēēsu ākoo baannyii, kulābāt ꞉chiito ake ānkukutunyēē taayeenyii ānkulē, “Kāānēētiintēēt! Ikaraam ꞉inyiing'. +Maayey nee sāānyōōru *soboontaab kibchuulyo?” ");
INSERT INTO spyNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kukētyi ꞉Yēēsu kule, “Ām nee siikuuroo kule āwuu karaam? Yēyiin nkit ꞉nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ābērē 'inkētē kiruutēkaab Yēyiin choo kimwooyē *꞉Muusa kuu: ‘‑Meebakach chii, ‑meemarte, ‑mēēchōōrsē, ‑mēērātyi chii ng'wiiynan, ‑mēēlātu chii, iywey kōōn āk koomēt.’” ");
INSERT INTO spyNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kumwooy ꞉chiichoo kule, “Kāānēētiintēēt, kyāākir ng'aleechaa kung'eetee āmining'.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kōōrōōtoot ꞉Yēēsu chiichoo. Kung'ērēkyi ānkumwoochi kule, “Botuung' ꞉kiito akeenke. Wee-alte kiy ake tukul nyēē iboontē, 'ānkiisārunēē bānoonik. Yoo 'keeyey kuu nyooto, irubwaa. +Mēēnyōōru bāytit nyēbo man ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kuteryekta ꞉mukuulēynyii ankusimikta nyēē kāng'woonchi, kuuyu kiboonto bāytit nyēē wōō. ");
INSERT INTO spyNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kōōrōōtoot ꞉Yēēsu rubiikyii ānkumwooy kule, “Wuuy sōō nyēē tyaa kucham ꞉biich chēē mokorēēn bāytooyiisyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kiilat ꞉rubiik ng'aleechaa. Kiikiimchi ꞉Yēēsu subak kule, “Biikyuu, wuuy sōō kule nee kōōwut ꞉chii nyēē wuu nyoo Kaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nyumnyum mbo kōōwut ꞉tembes koong'taab sintaaniit kusiir kōōwut ꞉chii nyēē boonto bāytit Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kiilat ꞉rubiik subak miisin ankuteebee keey kule, “Ara ng'oo, naas, ꞉nyēē imuuchē /kiiraraach?” ");
INSERT INTO spyNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kōōrōōtoot ꞉Yēēsu rubiichoo, ānkulē, “Mēēmuuchāktōōs sinee ām wōlēē mii ꞉chiito, nteenee, imuuchāktōōs ām wōlēē mii ꞉Yēyiin, kuuyu māmii ꞉kiy nyēē biirē Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nto mii yoo, kuteebee ꞉Bētērō Yēēsu kule, “Kas kookeebakaakte ꞉acheek kiy ake tukul ankeerubiing'?” ");
INSERT INTO spyNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Kukētyi ꞉Yēēsu kule, “!Kāāmwoowook, chii ake tukul nyēē kaakubakaakta tukuukyii tukul sukuruba kwoomtootē ng'aleekaab Yēyiin, +/mākēēkētyi tukuuchoo ām bēsyōōsyēchu kusiir choo kiboonto. Yoo ki mbareet nto kooriik chēē kibakaakta, mākunyōōr. Nto yoo ki tuubchōōsyēk chēē kibakaakta, mākunyōōr. Yoo ki kwaan nto kaamet nto lēēkōōk chēē kibakaakta, mākunyōōr nkicheek. Nto subak, +/mākēēwus ām kōōrooni nteenee mākunyōōr *soboontaab kibchuulyo ām kōōrēēt nyoo chōōnii. ");
INSERT INTO spyNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Biiko chēē chaang' choo tookunootiin ām soboontaab kōōrooni, mākubooyiit lēt ām Kaab Yēyiin. Nto biiko chēē chaang' choo mātookunootiin ām soboontaab kōōrooni, mākubooyiit taay ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kutāsē taay Yēēsu āk rubiikyii ām baanaa bo Yēērusālēēm, kimii ꞉Yēēsu kukeentooy ānkurubu ꞉rubiik ām lēt muut kwoomoonu mēt ꞉kiyēē kimwooy ꞉Yēēsu. Kikimuuyo mbo ꞉biiko alake choo kimii ꞉nkicheek kurubē Yēēsu. Yooto, kukuur ꞉Yēēsu rubiichoo taman āk āyēēng', ānkumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“!Kookas, kēēmiitē kēēbēētii ākoy Yēērusālēēm. +/Mābokiiyokoochi *Wēritaab Chii mbo *kibkōrōs chēē wōōyēch ākoo kāānēētikaab kiruutēk. Makooruusta ꞉bichoo Wēritaab Chii /keebakach ānkōōyokoochi biikaab Rooma. ");
INSERT INTO spyNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mākōōntosuur ꞉choo, kung'utyi, kubirsēēt kulālchi ankubakach. Nto mii bēsyēētaab sōmōk, makung'eetee meet.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nto mii yoo, kuwēēchi ꞉Yoowaana ākoo Yāākōbō, choo ki ꞉wērikaab Sebetaayo, Yēēsu ankuteebee kule, “Kāānēētiintēēt, mii ꞉kiito ake nyēē kēēmāchē iyēwēēch.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kuteebee ꞉Yēēsu kule, “Nee ꞉nyooto?” ");
INSERT INTO spyNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kukētyi ꞉rubiichoo kule, “Kākēēmāchē ꞉acheek ichāmwēēch kōōbuurunēēniing' ꞉ake āwutaab taay, kōōbuurunēēniing' ꞉ake nyēbo kaataam bēsyoonoo ibāytooyiisyē ām lēbkēēyyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kumwoochi ꞉Yēēsu kule, “‑Mōōnkētē kiyēē ōsoomē. Ōmuuchē ꞉akweek okalab nyāliluutēk chēē +maakalab ꞉anii nto ōmuuchē ōbuntēē nyāliluutēk chēē +māābuntēē ꞉anii?” ");
INSERT INTO spyNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kumwooy ꞉rubiichoo kule, “Kiimuuchē.” Kumwoochi ꞉Yēēsu kule, “+Mōōnyōōru nyāliluutēk chēē +māānyōōru ꞉anii, ānku +mōōbuntēē nyāliluutēk chēē +māābuntēē ꞉anii. ");
INSERT INTO spyNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ānkoo kuwuu nyooto, ‑māāboontē kāāmuukēywēēk chēē āmuuchē ākoochi chii kōōbuurunēēnoo āwunyuu nyēbo taay nto nyēbo kaataam. Yēyiin nkit ꞉nyēē kiikukwey chēē mākōōkoochi bārooyinooto.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yu kēēnkēt ꞉rubiik chuut tamanu kiyēē kimāchē ꞉Yāākōbō ākoo Yoowaana, kunyēērchi murēchooto. ");
INSERT INTO spyNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kukuur ꞉Yēēsu rubiik tukul, ānkumwoochi kule, “Tookunoot kule māchē ꞉bāytooyik chēē mii kōōrooni kōōboorchi biiko alak kule icheek ꞉chēē bāytooyiisyē ānkuboonto kāāmuukēywēēk kubiir chuut. ");
INSERT INTO spyNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nteenee ‑māmāchāktōōs kuwuuyiit nyoo ām wōlēē ōmiitē ꞉akweek. Yoo māchē ꞉chii ām akweek kuyēk nyēē wōō, kumisyinē kuyibē keey ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nto nyoo māchē kubāytooyiis, kumāchāktōōs kuyēētyēēchinē chuut. ");
INSERT INTO spyNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kyāāchōō ꞉anii *Wēritaab Chii, sichāāyēētyēēchi biiko, āmēēbērē kyāāchōōnii /subokēēyēētyēēchoo. Chāākooytooy soboonnyuu sukusobcho ꞉biiko chēē chaang'.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nto mii yoo, kuyit ꞉Yēēsu ākoo rubiikyii *kiriinkēētaab Yēērikō. Nto kumii kung'ēētōōs, kurub ꞉biiko chēē chaang'. Kimii ꞉cheebkoraatyaanteet ake nyēē kikiibuur kēēlto komos kusoomsē. /Kikēēkuurēē chiichoo Bartimaayo (Araab Timaayo). ");
INSERT INTO spyNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yu kakas ꞉chiichoo kule Yēēsu nyēbo Nāāsārēēt ꞉nyēē kimii kukēēytooy, kukuurso kule, “Yēēsu, inyiing' *Mōchōkōrēētaab Tāwuti, iriireenaa!” ");
INSERT INTO spyNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kōōburyoong'to ꞉biiko chēē chaang' kule, “Siis!” Nteenee kikuurchi ꞉chiichoo barak kule, “Mōchōkōrēētaab Tāwuti, ankiiriireenaa!” ");
INSERT INTO spyNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kōōyyo ꞉Yēēsu, ānkumwoochi biiko kule, “Ōmwoochi kuchō.” /Kēēmwoochi kule, “Ing'erech, ānkiiyyoony, kuuriing' ꞉Yēēsu.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kukāsē kuu nyooto, kung'ēētē bakeenke ānkumētooy sireet nyēē kikiiliiktēē keey, /ānkiirēētoot ākoy yēē kimii ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kuteebee ꞉Yēēsu kule, “Imāchē āyēwuung' nee?” Kukētyi ꞉chiichoo kule, “Mokoryoontēēt, āmāchē akaste.” ");
INSERT INTO spyNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kumwoochi ꞉Yēēsu kule, “/Kāākēēyēwuung' kiyēē 'kēēmāchē, kuuyu 'kēēkoosēēnoo keey.” Yu kāmwooy ꞉Yēēsu kuu nyooto, kukasta ꞉chiichoo ānkuwēēto keey Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yu kikiikuriik ꞉Yēēsu ākoo rubiikyii Yēērusālēēm, kumur *kiriinkēētaab Beetannyaa yēē kilēēkitēē Lekemeetaab *Musēytuuniinēk. Nto mii kēēltaab too, kukēē-āyēēchēē keey saang'taab Beetfaaka, ");
INSERT INTO spyNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kumwoochi rubiikyii āyēēng' kule, “Obe ākoy saang'iin. Yoo kooyit wōlooto, +mōōnyōōru sikiryo nyēē siirwaak kurataat amanaakesen chii bēsyēēt ake. Otyaach ānkōōkwēru. ");
INSERT INTO spyNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nto yoo kateebeenaak ꞉chii kule ōmāchēē nee, ōlēēnchi māchē ꞉Mokoryoontēēt ānkumākukēt areet akeenke.” ");
INSERT INTO spyNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kuba ꞉rubiichoo ānkubokunyōōr sikiryoonoo /kākēērātyi kurkat saang' ankootyaach. ");
INSERT INTO spyNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nto bērē kukas ꞉biiko alake chēē kimii yooto, kuteebee rubiichoo kule, “Ōtyookyinē nee sikiryēēt?” ");
INSERT INTO spyNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kukētyi ꞉rubiichoo kuu wōloo kimwooytoochinē ꞉Yēēsu. /Kēēchāmchi kubeeta sikiryēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kukwēr ꞉rubiichoo sikiryoonoo ākoy yēē kimii ꞉Yēēsu. Yu kayit yooto, kōōrēēk kāāliikoonikwaa ankwaalyaktee bataytaab sikiryoonooto sukōōbuurēē ꞉Yēēsu. Kōōbuurēē ꞉Yēēsu bataytaab sikiryoonoo ankutas taay āk baanta. ");
INSERT INTO spyNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kiirēēk ꞉biiko chēē chaang' chēē kimii yooto kāāliikoonikwaa ānkōōyiito kēēltaab too. Kubut ꞉alake sokēēk ānkōōyiito nkicheek. ");
INSERT INTO spyNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kityēēnchinootē barak ꞉biiko chēbo taay ākoo chēbo lēt kumwooyē kule, “Kutōrōriit ꞉Yēyiin! Ibēruuroot ꞉nyi chōōnii ām kaayneetaab Yēyiin! ");
INSERT INTO spyNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ibēruuroot *꞉Mōchōkōrēētaab Tāwuti! Kutōrōriit ꞉Yēyiin ām kibkōōnkōy!” ");
INSERT INTO spyNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nto mii yoo, kuyit ꞉Yēēsu Yēērusālēēm ānkōōwut biiwuutaab *Kōōtaab Yēyiin. Kumarar wōlēē kiwuu ꞉kiy ake tukul. Nto mii yoo, kooyeey ākoo rubiikyii tukul choo ki taman āk āyēēng' ākoy Beetannyaa, kuuyu kimii kwiimēnē ꞉kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nto yu kāyyēēkunēē, kung'eetee ꞉Yēēsu ākoo rubiikyii Beetannyaa ankooyeey Yēērusālēēm. Kwaam Yēēsu ꞉kēmēwuut. ");
INSERT INTO spyNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nto yu kimii kubēētii, kutoobēnchi kēētit ake nyēē /kēēkuurēē *mutiiniit wōlēē lōō. Kiboonto ꞉kēētoo sokēēk chēē nyāliilēch nyēē kibērē ꞉chii tōōs kiikuyey lokoy. Nto bērē kuyit yooto, koosyaach kēētoo kubērē nto nyōōr lokoyeek. Nteenee kuuyu kimā bēsyōōsyēk ꞉chooto chēē kiyēyē ꞉kēētoo lokoyeek, mānāānyōōr ꞉inee lokoyaa ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yooto, kuchub ꞉Yēēsu kēētoo kukāsē ꞉rubiik kule, “Mēērook /kyaameeniing' kiy bēsyēēt ake.” ");
INSERT INTO spyNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yu kayit ꞉Yēēsu ākoo rubiikyii Yēērusālēēm, kōōwut biiwuutaab *Kōōtaab Yēyiin. Kimii yooto ꞉biiko chēē kiwālāng'tooy beesaanik āk alak chēē kyooltooy chēēbtuukēēnik chēē /sikēēbēēlēē kōrōsēēk. Kimiitē ꞉nkicheek cheemung'aariisyek alake yooto. Yooto, kootyeelaat ꞉Yēēsu meesoosyekaab bichoo kiwālāng'tooy beesaanik āk ng'ēchērōōkaab choo kyooltooy chēēbtuukēēnik ankukwet bichoo tukul kuba saang'. ");
INSERT INTO spyNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mānāāchāmchi mbo chii nyēē kiboontootē kiy ake tukul nyēē kyooltooy kubuntēē biiwuutaab *Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kimwooy kule, “Mwooyē ꞉Yēyiin ām siruutēk kule, ‘Bo ꞉Kōōnyuu saayeet wōlēē mākusooyēē ꞉biikaab kōōrōōsyēk tukul.’ Nteenee kyooweech ꞉akweek kuyēk kēbēnnyoo nyēē wunyēē keey ꞉sāsiik!” ");
INSERT INTO spyNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yu kakas ꞉mbo kibkōrōs chēē wōōyēch ākoo kāānēētikaab kiruutēk kiyēē kiyey ꞉Yēēsu, kung'woonchi. Yooto, bokusat wōlēē sukubakakta inee kuuyu kiilātē ꞉biiko kubo kāāmuukēywēēk chēē kiboonto. ");
INSERT INTO spyNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yu kāākwiimēn ꞉kōōrēēt, kung'eetee ꞉Yēēsu ākoo rubiikyii kiriinkoonoo ānkubēēchi keey wōlto ake. ");
INSERT INTO spyNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yu kāyyēēkunēē, kooyeey ꞉Yēēsu ākoo rubiikyii Yēērusālēēm. Kumii kubēētii, kukas ꞉icheek kēētoo kōchubē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kumwoochi ꞉Bētērō Yēēsu kule, “Mokoryoontēēt, kas, ntēē kookuyaam ꞉kēētitkoonye kwēēchubē!” ");
INSERT INTO spyNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kumwoochi ꞉Yēēsu kule, “Māchē ōkoosēē keey Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kāāmwoowook yoo ikoosēē keey ꞉chii Yēyiin ām mooyēēt akeenke, kōōmuuchē kumwoochi lekemeet wokōōsuuchi araaray ankuyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kunyi, yoo ōtēēbē kiito ake ām saayeet ānkōōchāmtooy kule kaakukas ꞉Yēyiin, ōnyōōru. ");
INSERT INTO spyNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nto yoo isooyē Yēyiin ānkumii ꞉kiyēē miyaat nyēē kiikuyēwuung' ꞉chiito ake, inyōōchi chiichoo kaat kurook sukung'eet kunyōōwuung' nkinyiing' ꞉Yēyiin kaat ām choolwookātēēng'uung'. ");
INSERT INTO spyNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nto yoo ‑mōōyēyē kuu nyooto kumānyōōwook ꞉Yēyiin kaat.” ");
INSERT INTO spyNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yu kayit ꞉Yēēsu ākoo rubiikyii subak Yēērusālēēm, kōōwut biiwuutaab *Kōōtaab Yēyiin. Kumii kuwēēsyētēē wōlooto, kukwoonchi ꞉mbo *kibkōrōs chēē wōōyēch āk kāānēētikaab kiruutēk āk booyik ");
INSERT INTO spyNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ankuteebee kule, “Ng'oo ꞉nyēē kikōōniing' kāāmuukēywēēk iyey ng'aleechu?” ");
INSERT INTO spyNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kuwālchi ꞉Yēēsu bichoo kule, “Kany ateebeenaak ꞉nkanii tēēbuutyēēt nto yoo kōōkētwoo, +māāmwoowook chiichēē kikōōnoo kāāmuukēywēēk ayey ng'aleechu. ");
INSERT INTO spyNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ātēēbēēnook kule ii, yoo kiibātisāniisyē ꞉Yoowaana, kikwoonēē ꞉kāāmuukēywēēkyii wōlēē mii ꞉Yēyiin, nto wōlēē mii ꞉biiko?” ");
INSERT INTO spyNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kwaam mēt bichoo ānkumwoochi keey kule, “Yoo kakeemwaay kule kikwoonēē ꞉kāāmuukēywēēkyii wōlēē mii ꞉Yēyiin, makuteebeeneech kule ām nee simākiiyēnchi. ");
INSERT INTO spyNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nto yoo kākēēlē, ‘Wōlēē mii ꞉biiko.’ Achicha!” Kiiywey kumwooy, kuuyu kiinkētē kule kichāmchiintōōs ꞉biiko tukul kule ki *wōōrkooyoontēētaab Yēyiin ꞉Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yooto kuwālchi Yēēsu kule, “‑Mākiinkētē.” Kumwoochi nkinee ꞉Yēēsu kule, “Yoo wuu nyooto, ‑māāmwoowook ꞉nkanii chiichēē kikōōnoo kāāmuukēywēēk ayey ng'aleechu.” ");
INSERT INTO spyNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kumwoochinēē ꞉Yēēsu kāāntōōyichoo bo Yuutayeek tyoonkōōch kule, “King'eet ꞉chiito ake kēny kuchaan *musābiibuunēk mbareenyii ankuker. Kibal ng'wēēnēēt nyēē sukurōōtyinē ꞉bēēkaab lokoyeekaab kēētoo yoo /kakiiruruuny ankuteech kēryēēt nyēē /sikēēriibēē mbaraanaa. Nto yityo, kumwoochi biiko alak bokuriibchi mbaraanaa sukubchēchiin lokoyeek. Yooto, kuwo ruutooy. ");
INSERT INTO spyNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yu kāruryo ꞉lokoyeechaa, kōōyookto ꞉chiichoo motwooriintēēnyii wokuyibchi kereeryaanteet nyeenyii. ");
INSERT INTO spyNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yu kayit ꞉motwooriintoonoo wōlooto, kunam ꞉bichoo ānkubir ankukwet āmēēkoochi kiy. ");
INSERT INTO spyNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kōōyookto subak ꞉chiichoo motwooriintēēnyii ake. /Kēēbir nkinee nyoo /keelal /kiitaatee /ānkiintosuur. ");
INSERT INTO spyNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kōōyookto subak motwooriintēēt nyēbo sōmōk. Yu kayit ꞉nyoo, /keebakach. Kōōyookto subak alak kurub keey. Kuyitē ꞉nkicheek choo wōlooto, /kēēbirē alak /kiinyāliilē, nto alak /kēēbākāchē. ");
INSERT INTO spyNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nteenee kiboonto ꞉chiichoo kibo mbareet wērinyii akeenke nyēē kichāmē miisin. Kōōyookto wēērootonyii kubērē tōōs makooywey ꞉bichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kuyitē ꞉nyoo, kukuurē keey ꞉bichoo kule, ‘Murēchu, ong'nyi lakwataab murooniito! Okany keebakach sukuyēk ꞉mbaraani nyēēnyoo.’ ");
INSERT INTO spyNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kunam ꞉bichoo wēēroo ankubakach nto yityo bokumētyi tuuyta saang'. ");
INSERT INTO spyNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yoo koosoot ii, kiy nee ꞉nyēē kichokuyēchi ꞉chiitaab mbareet bichoo? Okany āmwoowook, machokubakach bichoo tukul ānkōōkoochi biiko alak kuriib mbaraanaa.” ");
INSERT INTO spyNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kumwoochi ꞉Yēēsu subak kule, “Ābērē kyoosuman siruutēkaab Yēyiin yoo mwooyē kule, ‘Rwaanteet nyoo kitāyē ꞉biiko kuteekta ꞉nyēē kōōkuyēk tiiyēywoontēētaab kōōto. ");
INSERT INTO spyNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kōkōōnu ꞉Yēyiin tiiyēywoontooni ānkubo kwōng'uut sōō nyēē tyaa yoo kēēkāsē!’” ");
INSERT INTO spyNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yooto, kumach ꞉kāāntōōyichoo bo Yuutayeek kule kunam Yēēsu ankukerta kō, kuuyu kiinkētē kule kimii kung'āloolēē icheek ām tyoonkōōchoonoo. Nteenee kibakaakta ꞉bichoo Yēēsu ānkubēēchi keey kuuyu ki chaang' ꞉biiko yooto. ");
INSERT INTO spyNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kibokōōyook ꞉kāāntōōyichoo bo Yuutayeek lētuunoo *Farisaayeek alak āk biikaab *Ērōōtē bokutech Yēēsu /sikeenam. ");
INSERT INTO spyNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yu kayit ꞉bichoo wōlēē mii ꞉Yēēsu, kumwoochi kule, “Kāānēētiintēēt! Kiinkētē kule ibooyē manta āmāwēēchiing' ꞉chii kuuyu ām inyiing', mātiny kule ng'oo ꞉ng'oo. Inēētē biiko ām kēēlto nyēbo man kōōnkēt kiyēē māchē ꞉Yēyiin. Kunyoo ii, ara karaam kēēkwēchinē *syuuruut bāytooyiintēētaab Rooma ");
INSERT INTO spyNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","nto mēērook kēēkwēyē?” Yooto kōōnkēt ꞉Yēēsu miyootyēēt nyēē kiisōōtē ꞉bichoo ānkumwoochi kule, “Kōōkwoonii bōōtēchoo? Kōōbooru baa ꞉chii beesyaanteet nyēē boonto.” ");
INSERT INTO spyNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yu /kākiiboorchi, kuteebee bichoo kule, “Bo ng'oo ꞉mēti āk kaaynaani mii beesyaantaani?” Kukētyi ꞉bichoo kule, “Bo bāytooyiintēēt nyēē wōō nyēbo Rooma.” ");
INSERT INTO spyNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kumwoochi ꞉Yēēsu kule, “Ōkoochi bāytooyiintoonoo kiinyii, nto Yēyiin, ōkoochi nyeenyii.” Kiilat ꞉bichoo ām kiyēē kimwooy ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nto mii yoo, kukwoonchi subak Yēēsu ꞉biiko alake chēē /kikēēkuurēē *Satukaayeek. Kiiyēnchinē ꞉bichoo kule yoo kaakume ꞉chiito, kaakume kutukul nyēē māwokung'ēētēē meet bēsyēēt ake. Kuteebee ꞉bichooto Yēēsu kule, ");
INSERT INTO spyNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kāānēētiintēēt, kisirweech *꞉Muusa kiruutyēēt nyēē mwooyē kule yoo keemut ꞉chii koorkēēnyii ankume ꞉chiichoo āmānāāsikyi ꞉koorkoonoo leekwa, kōōntiiyē ꞉ng'eetaabkaametiitaab chiichoo koorkoonoo sukusikyi nyiin lēēkōōk chēē /sikēēkuurtēē. ");
INSERT INTO spyNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kimii ꞉biiko alake chēē tisabu chēē kituubcho mooyēēt akeenke. Kiimutiis ꞉nyēē ki wōō ankusimkume kumānāāsikyi ꞉koorkoonoo leekwa. ");
INSERT INTO spyNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kōōntiiyiis ꞉nyēē kirubē chiichoo. Kume ꞉nkinee nyoo, āmānāāsikyi ꞉koorkoonoo leekwa. Kōōntiiyiis subak ꞉nyēē kibo sōmōk ankume ꞉nkinee āmānāāsikyiin āk koorkoonoo leekwa. ");
INSERT INTO spyNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kiyeyakay kuu nyooto ākoy chiito nyēē kibo tisab. Kibēk ꞉bichoo tukul āmā leekwa. Nto mii yoo, kume nkinee ꞉koorkoonoo. ");
INSERT INTO spyNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kunyoo, kēēmāchē imwoowēēch, mākubooyiit ng'oo ꞉koorkoonoo kōōyyiin kāng'ēētyēē ꞉bichoo tukul meet āk koorkoonoo?” ");
INSERT INTO spyNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kukētyi ꞉Yēēsu kule, “Ōsōōtyēēchinē nyēē miyaat, kuuyu ‑mōōnkētē ꞉akweek kiyēē ibooru ꞉siruutēkaab Yēyiin āk wōlēē wuu ꞉kāāmuukēywēēkyii. ");
INSERT INTO spyNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yoo kāākung'ēētyēē ꞉biiko meet, mēēbērē tākōōmutē keey subak. Ibuurē kuu ꞉malayikaanik ām barak. ");
INSERT INTO spyNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nto kurubta keey ng'eeteetaab meet, ābērē kyoosuman siruutēkaab *Muusa yoo kimwoochinē ꞉Yēyiin ām sōntiinoo kilāyē kule, ‘Anii Yēyiintēētaab *Abraam āk Isaka ākoo Yāākōbō.’ ");
INSERT INTO spyNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yoo /kakeemwa kule bo ꞉Yēyiin anum, kōōbooru ꞉yooto kule tākusoboot ꞉chiichooto ānkoo kiikume kēny. Ōsōōtē bebe!” ");
INSERT INTO spyNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kimii yooto ꞉kāānēētiintēēt ake nyēbo kiruutēk nyēē kimii kuyēbchinē yiit kiyēē king'āloolēē ꞉Yēēsu ākoo Satukaayeechaa. Kikas ꞉kāānēētiintoonoo bo kiruutēk kule kikētyi ꞉Yēēsu bichoo kiyēē kiteebee ām kēēlto nyēē karaam. Yooto, kuteebee Yēēsu kule, “Ām kiruutēk tukul choo kikōōnu ꞉Yēyiin, nkōnō ꞉nyēē wōō?” ");
INSERT INTO spyNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kukētyi ꞉Yēēsu kule, “Siraat kule, ‘Oyeb yiit ōō, biikaab Isrāyēēl: Yēyiin nkit ꞉nyēē /kēēkutunkyinē ānku Yēyiin ku akeenke. ");
INSERT INTO spyNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Icham Yēyiintēēng'uung' ām mooyēēng'uung' tukul soboonng'uung' tukul, kāāsōōtēywēēkuuk tukul, āk nkuruukuuk tukul.’ Kiruutyēēt ꞉nyooto nyēē wōō. ");
INSERT INTO spyNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nto ake kumwooyē kule: ‘Icham laatyeeng'uung' kuu wōloo ichāmtooy keey.’ Māmii subak ꞉kiruutēk alake chēē siirē chu.” ");
INSERT INTO spyNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yu keewaany ꞉Yēēsu kumwooy kuu nyooto, kulēēnchi ꞉chiichoo, “Kōōnkōy, Kāānēētiintēēt, 'keemwaay man kule Yēyiin ku akeenke, māmiitē ꞉ake. ");
INSERT INTO spyNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kunyi, karaam yoo kacham ꞉chii Yēyiin ām mooyēēnyii tukul ānkumāchē mbo kōōsōōtē Yēyiin kwaak ānkuyēyē yiisyēētaab Yēyiin ām nkuruukyii tukul ankucham laatyeenyii kuu wōloo chāmtooy keey. Karaam /keerub ng'aleechu kusiir yoo /kātākēēyēyootē kōrōs choo /kēēbēēlē kutukul āk alak tukul.” ");
INSERT INTO spyNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yu kakas ꞉Yēēsu kule kākēt ꞉chiichoo nyēē karaam, kumwoochi kule, “'Kāmēēlōō ām bāytooyiisyēētaab Yēyiin.” Kung'eetee yooto, māmii ꞉chii nyēē kitākukāng' kuteebee Yēēsu ng'ālyoo kumāchē kutech. ");
INSERT INTO spyNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nto tēē yoo, kumii ꞉Yēēsu kōōnēētē biiko ām biiwuutaab *Kōōtaab Yēyiin, kumwooy kule, “Imuuchē kule nee kumwooy ꞉kāānēētikaab kiruutēk kule chōōnēē *꞉Kāārārookiintēēt kōōtaab Tāwuti? ");
INSERT INTO spyNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nto yu kiyey ꞉Tāmirmiryēētaab Yēyiin Tāwuti kumwooy kule, ‘Kimwoochi ꞉Yēyiin Mokoryoontēēnyuu kule: Ibuurunēē āwunyuu nyēbo taay ākoy yoo kaayeyiing' itēbēē buunikuuk.’ ");
INSERT INTO spyNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kunyi, yoo kuurē ꞉Tāwuti Kāārārookiintēēt kule ‘Mokoryoontēēnyuu’ ii, kōōmuuchāktōōs kule nee kuchōōnēē ꞉Kāārārookiintēēt kōōtaab Tāwuti?” Kiyēbchi yiit ꞉biiko ng'aleechaa bo Yēēsu ām ng'erekweek. ");
INSERT INTO spyNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kutas taay ꞉Yēēsu kumwoochi bichoo kule, “Ōriibēē keey ꞉kāānēētichoo bo kiruutēk, āmōōrubē ātēbuutēkwaa. Kicham ꞉bichu kōōloochē sirook chēē yoo /kakeekas /simkiinkētē kule icheek kiirwookik. Bēēsyētootēē wōlēē chaang' ꞉biiko /sikiisubooyootē nyēē /kākēēkoonyit. ");
INSERT INTO spyNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lēkwēlootē ng'ēchērōōk chēē mii taay yoo /kēēmii kooriikaab saayeet. Mbo yoo /kēēmii saakwa ake tukul, kōōmoymooyē ꞉bichu ng'ēchērōōk chēbo taay. ");
INSERT INTO spyNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lātunootē koor chēē musuuk kuyibēē tukuukwaa ānkusooyē miisin kuyēyē keey kule churtootiin. +/Mākiing'woonchi miisin biich chēē wuu chuutēchu kusiir chii ake tukul nyēē kiikukusta.” ");
INSERT INTO spyNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kumii ꞉Yēēsu kēēbuur ng'wēny ām *Kōōtaab Yēyiin yēē kilēēkitēē ꞉looloonik chēē /kikiiruruukyinē beesaanik chēbo yiisyēētaab Yēyiin, kukas wōlēē kiikoochintooy ꞉biiko beesaanik looloonichoo. Kiikoochinē ꞉biiko chēē ki mokorēēnik beesaanik chēē chaang' looloonichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nto mii yoo, kuchō ꞉cheebyoosyeet ake nyēē ki musuk ankubanan. Kiinēm ꞉nyoo beesaanikyii chēē ng'ēri anku tukul chēē kiboonto. ");
INSERT INTO spyNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kukuur ꞉Yēēsu rubiikyii ānkumwoochi kule, “!Kāāmwoowook, cheebyoosyaani musuk ꞉nyēē kēēnēm beesaanik laatit nyēē wōō kusiir chuut tukul. ");
INSERT INTO spyNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kāng'ōmōrunēē ꞉mokorēēnik laatit nyoo kēēkooytooy wōlēē bo chēē boonto, nteenee kābār ꞉cheebyoosyaanaa loolēēnyii tukul.” ");
INSERT INTO spyNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kumii ꞉Yēēsu ākoo rubiikyii kung'ēētyēē yooto kibo biiwuutaab *Kōōtaab Yēyiin, kumwoochi ꞉rubiintēēnyii ake kule, “Kāānēētiintēēt, wōōyēch ꞉rwoontōōchu /kikeeteechee Kōyi bo Yēyiin ānku kāroorānēch nyēē tyaa!” ");
INSERT INTO spyNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kukētyi ꞉Yēēsu kule, “Kookas, kāroorānēch ꞉kooriichu, nteenee +/mākiiturbuub tukuuchu tukul nyēē māmii ꞉rwaa mbo akeenke nyēē ng'ētu kookemeeraat keey ake.” ");
INSERT INTO spyNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nto mii yoo, kuyit ꞉Yēēsu ākoo rubiikyii biitēēt nyēē kibo Lekemeetaab *Musēytuuniinēk yēē kitoobēnē keey ākoo Kōōtaab Yēyiin ānkōōbuur ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kuteebee ꞉Bētērō, Yāākōbō, Yoowaana āk Antereeya Yēēsu kule, “Āyu yēē yēyāktōōs ꞉ng'aleechaa kātēēmwooyē ānku kiy nee ꞉nyēē +makeekasee yoo yityiintōōs ꞉ng'aleechaa?” ");
INSERT INTO spyNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kumwoochi ꞉Yēēsu kule, “Ōriib keey! ‑Mookany /kiiberbeeraak. ");
INSERT INTO spyNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Choong'ēch ꞉biiko chēē makukwaanaat ankuyey keey ꞉ake tukul kule inee ku kāārārookiintēēt. Mākōōbotbootoot ꞉bichoo biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","+Mookas kubārē keey ꞉biiko ām kōōrēēt /ānkyoomu booryoot, nteenee ‑mōōmuuyē. Ākoy kuyēyākiis ꞉tukuuchoo, nto yitu ꞉tabanta. ");
INSERT INTO spyNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mākubooryo ꞉bōrōryēēt ake āk ake, kubooryo ꞉kōōrēēt ake āk ake. Mākōōring'riing'oot ꞉komoswookik chēē chaang' ām kōōrēēt ānkuchō ꞉kēmēwuut. Ng'wooninto nyēē kāāmunēē moroontoon ꞉nyoo nto yitu ꞉kōōrēēt nyēē lēēl.” ");
INSERT INTO spyNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kumwoochi ꞉Yēēsu kule, “Ōriib keey. +/Makeenamaak /ānkiiyyoong'tēēnook kōōk ām kooriikaab saayeet /ānkēēbirook ām wōlooto. +/Makiimutaak taayeetaab bāytooyik kubo anii. Bārooyinto ꞉nyooto nyēē +mōōmwoochinēē bichooto kiyēē ōyēnchinē. ");
INSERT INTO spyNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","/Kyoomtooy kurook lōkōōywēk chēē kāroomēch kukas ꞉biiko tukul ām kōōrēēt kumukuul nto yitu ꞉tabantaab kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yoo /kaakeenamaak /ānkiiyyoong'tēēnook kōōk, ‑mookany kooyiimaak mēt ꞉kiyēē +moomwaay. +/Mākiiboorwook yooto kiyēē ōmwooyē kuuyu mēēbērē akweek chēē +mōōng'āloolē nteenee ꞉Tāmirmiryēētaab Yēyiin nyēē mākung'āloolē. ");
INSERT INTO spyNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mākung'ōmto ꞉chii ng'eetaabkaamet /keebakach ānkung'ōmto ꞉kwaan lakwanyii /keebakach. Makutay ꞉lēēkōōk mbo kwaan āk mbo kaamet ānkung'ōmto /keebakach. ");
INSERT INTO spyNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kunyi, mākuwēchook ꞉biiko, kuuyu ōyēnwoo. Nteenee chiito nyēē kamuyta ākoy tabanta ꞉nyēē makooraraach ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kumwoochi ꞉Yēēsu rubiikyii kule, “Yoo kookas ‘kiyoo ‑mēēriiku ꞉Yēyiin’ kukēēyyoonyēē yēē ‑/mākēēmākyinē, ōmwēy ꞉biikaab Yuuteeya ākoy lekem barak. (Kuyēbchi yiit ꞉chii nyoo sumānē ng'aleechu.) ");
INSERT INTO spyNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yoo kanyoorta ꞉ng'aleechu chii kumii kōōnyii barak, ‑mēēwut kō kule kōōnēm kiy ake tukul nyēē sukumwēyto, ");
INSERT INTO spyNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ameeyeey ꞉chii nyoo miitē mbareen kaa kule wokunam sireet nyēē iliiktēē keey. ");
INSERT INTO spyNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lēyyē, mākuwuuyiityi sōō kule nee ām bēsyōōsyēchooto kooruuk choo kōōyootiin āk choo irēēriisyē! ");
INSERT INTO spyNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Osaay Yēyiin kule māyēyākiis ꞉ng'aleechu yoo yiiwoot. ");
INSERT INTO spyNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mākuwōōyiit ꞉ng'woonintaab bēsyōōsyēchooto kusiir ng'woonin ake tukul nyēē kiikutook kuchakee kayey ꞉Yēyiin kōōrēēt, āmēēbērē mākutook ꞉ng'wooninto ake nyēē tēē nyoo bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nteenee kiikoonwaakiit ꞉Yēyiin bēsyōōsyēchooto kuuyu mii ꞉biikyii chēē kiikukwey nyēē nto kimanaakoonwaakiit, nto māmii ꞉chii nyēē kātāwokusobē. ");
INSERT INTO spyNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yoo kāmwoowook ꞉chii ake tukul kule ong'nyi *Kāārārookiintēēt nto ong'nyiin, ‑mōōyēnchi, ");
INSERT INTO spyNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","kuuyu makukwa ꞉biiko chēē makuyey keey kuyēk kāārārookik āk *wōōrkooyikaab Yēyiin. Makuyey ꞉bichu ng'al chēbo kwōng'uut sukung'eet, yoo imuuchāktōōs, kutēwēch biikaab Kiriistō choo kwēyootiin. ");
INSERT INTO spyNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kunyoo, ōriib keey. !Kāāsim āmwoowook tukul kumanaayit ꞉bēsyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kutas taay ꞉Yēēsu kumwoochi rubiikyii kule, “Yoo bēku ꞉nyāliluutēchoo bo bēsyōōsyēchooto ‘Mākumis ꞉asiista āmēētākōōluuwu ꞉araaweet. ");
INSERT INTO spyNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mākōōtimtiimākoy ꞉wōliin bo barak kōōsuuw ꞉kookeelik.’ ");
INSERT INTO spyNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","+/Makeekasa anii, *Wēritaab Chii, āchōōnēē boolik ām kāāmuukēywēēk āk lēbkēēyyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","+Māāyooktē malayikaanikyuu kōōruruukoot biiko choo kwēyootiin kung'eetee kōōrēēt komosta ake ākoy ake.” ");
INSERT INTO spyNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kumwoochi subak kule, “Yoo kēēnkāt ꞉kēētoo /kēēkuurēē *mutiiniit, kōōbooru kule kaakuriik kumusēs. ");
INSERT INTO spyNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ām kēēlto nyēē wuu nyooto, yoo ōkāsē kuyēyāktōōs ꞉tukuuchoo, ōnkēt kule kaakuriik ꞉bēsyēēt nyoo āyēēwunēē. ");
INSERT INTO spyNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","!Kāāmwoowook, mābootōōs ꞉biikyuu choo kyaakwey ānkoo kāyēyākiis ꞉tukuuchoo tukul. ");
INSERT INTO spyNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mākubot ꞉barak āk ng'wēny, nteenee mābotē ꞉ng'ālyoontēēnyuu. ");
INSERT INTO spyNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Māmii ꞉chii nyēē inkētē bēsyēēt nyēē āyēēwunēē. ‑Mēēnkētē ꞉malayikaanik āmāānkētē mbo nkanii, nteenee inkētē ꞉Baaba. ");
INSERT INTO spyNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ōriib keey ankooyeyte keey, kuuyu ‑mōōnkētē yēē yitu ꞉bēsyoonooto. ");
INSERT INTO spyNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kerkeey yoo māchē ꞉chii nyēbo kanyii kuwo ruutooy. Bākookyinē motwoorikyii yiisyēēt nyēē makuyey ankutool ake kuriib kayta. ");
INSERT INTO spyNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ōriib keey, kuuyu ‑mōōnkētē yēē rōōtunēē ꞉chiitaab kayta. Imuuchē kuyit kukararakta ꞉asiista, kwēēmooy kwēēn, kumānēērir ꞉kōōrēēt nto kumānāāmwook ꞉asiista. ");
INSERT INTO spyNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yoo kāchō, māchāktōōs kunyōōrwook ōkāsu. ");
INSERT INTO spyNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Okas ng'aleechu! Mā akweek nkit chēē āmiitē āmwoowook ng'aleechu, nteenee māchāktōōs kuyeyta keey ꞉biiko tukul.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kikiikung'ēt ꞉bēsyōōsyēk āyēēnku kuyit ꞉bēsyēēt nyēē kyoomēē ꞉Yuutayeek *Saakweetaab Keeytaayeet ākoo Saakweetaab mukaatiin chēē mākuutunootiin. Kimii kuchēēng'ē ꞉mbo *kibkōrōs ākoo kāānēētikaab kiruutēk wōlēē makunamta Yēēsu kumākāsē ꞉chii sukubakach. ");
INSERT INTO spyNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kimwooy kule, “‑Mookany keeyey ng'aleechu yoo bo *Saakweetaab Keeytaayeet, kuuyu imuuchē ꞉biiko kuyey wōōrōōryēēt.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kimii ꞉yēē kyoomiisyē ꞉Yēēsu ām Beetannyaa kumiitē kaab Simōōni, chiichoo kikiikunāmē *꞉makereenik. Yooto, kuchō ꞉koorkēēt ake kō nyēē kiboonto mwaay nyēē kiboong'u nyēē anyiny /ānkikyooltēē beesaan chēē chaang' miisin. Yooto, kuraang'tee ꞉koorkoonoo Yēēsu mwaayaa mēt. ");
INSERT INTO spyNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Yu kakas ꞉biiko alake chēē kimii yooto kiyēē kayey ꞉koorkoonoo, kumwooy nyēē kāng'woonchi kule, “Nto yu sukunyarta ꞉koorkooni mwaay nyēē ālē beesaan chēē chaang' miisin kuu nyi! Nto yu /kātākyooltooy /ānkiikoochi bānoonik beesaanik.” Kinyēērchi ꞉bichoo koorkoonoo miisin. ");
INSERT INTO spyNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kumwoochi ꞉Yēēsu bichoo kule, “‑Moomakee kiy koorkoonoo. Ntēē kāākuyēwoo anii ng'ālyoo nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ōboontē keey ꞉akweek bānoonik ākookoy ānku +mōōyēētyēēchinē kuu wōlēē ōchāmtooy. Nteenee ‑mōōboontē keey anii ākookoy. ");
INSERT INTO spyNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kaakuyey ꞉koorkooni kuu wōlēē kēēmuuktooy kuroonkyi mwaayaa mētinyuu kuyeytaa nto yitu ꞉yēē /kēēmuyēēnoo. ");
INSERT INTO spyNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","!Kāāmwoowook, ‑/mākēēwuutyēē koorkooni ām kiyēē kaakuyey yoo /kyoomtooy lōkōōywēk chēē kāroomēch ām kōōrēēt tukul.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nto mii yoo, kuwo ꞉Yuuta Iskaryoot nyoo ki akeenke ām rubiikaab Yēēsu choo ki taman āk āyēēng', wōlēē kimii ꞉mbo *kibkōrōs chēē wōōyēch wokuchaamta Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yu kayit wōlooto /kēēng'ērēkyi. /Kikēēmwoochi kule, “Yoo kēēyēwēēch kēēlto wōlēē +makeenamte Yēēsu, kēēkōōniing' beesaanik.” Kuwo ꞉Yuuta wokucheeng' wōlēē /sikeenamta Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ām bēsyēētaab taayta nyēbo Saakweetaab mukaatiin chēē mākuutunootiin, kiyēēnyē ꞉Yuutayeek mēēnkit nyēē sukwaam bēsyoonooto. Yu kayit ꞉bēsyooni, kuteebee ꞉rubiik Yēēsu kule, “Ānō wōlēē +mawee-amee *Saakweetaab Keeytaayeet bokēēyēytoowuung'?” ");
INSERT INTO spyNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kumwoochi ꞉Yēēsu rubiikyii āyēēng' kule, “Obe ākoy Yēērusālēēm. +Mōōtuuyēē murēn nyēē boontoonu tērēētaab bēēko. Orub chiichoo lēt ākoy kōōto nyēē kēēwut. ");
INSERT INTO spyNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yoo kooyit kōyooto, ōmwoochi chiitaab kōōto kule māchē ꞉Kāānēētiintēēt wōlēē sukwoomiisyēē ākoo rubiikyii ām Saakweetaab Keeytaayeet. ");
INSERT INTO spyNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mākōōboorwook ꞉chiichoo kisēēnkēēt nyēē wōō nyēbo koroofa nyēē mii ꞉tukuuk tukul chēbo ātēbto. Ōyēytoowēēch āmiik.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yu keewaany ꞉Yēēsu kumwoochi rubiichoo kuu nyooto, kuba ākoy Yēērusālēēm ānkubokunyōōr ng'aleek tukul kuu wōloo kāmwooytooy ꞉Yēēsu. Kuyeyta āmiikaab saakwaanaa. ");
INSERT INTO spyNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kumii kurātoorātē ꞉kōōrēēt, kuwo ꞉Yēēsu ākoo rubiikyii taman āk āyēēng' ākoy kōyooto ānkutoow kwaam saakweet. ");
INSERT INTO spyNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kumii kwoomiisyē, kumwooy ꞉Yēēsu kule, “!Kāāmwoowook, mii ꞉akeenke ām akweek nyēē kēēmiitē kyoomiisyē ꞉tukul nyēē makuchaamtaa.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kung'woonchi rubiik ankuteebee ꞉ake tukul Yēēsu kule, “Ara anii?” ");
INSERT INTO spyNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kukētyi ꞉Yēēsu kule, “Nyoo kiilābloobtooy ꞉tukwaay mukaatiit terekyeet akeenke nyēē makuchaamtaa. ");
INSERT INTO spyNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Makume *꞉Wēritaab Chii kuu yoo /kikeesir kurubta keey āk inee. Nteenee mākung'woonchi sōō kule nee ꞉chiito nyoo makuchaamtaa. Kaykay nto /kimākēēsich chiichoo.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yu kimii kwoomiisyē, kunam ꞉Yēēsu mukaatiit ānkubirchi Yēyiin kōōnkōy. Nto tēē yoo kubetes mukaatiinaa ānkōōkoochi rubiikyii kōōnēmunoot. Kimwoochi kule, “Bōōrnyuu ꞉nyi. Kunyi, o-am.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kunam subak terekyeet nyēē kimii *꞉tifaayiik ānkubirchi Yēyiin kōōnkōy ānkōōkoochi rubiichoo kumōōsoot. ");
INSERT INTO spyNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kimwoochi kule, “Korotiikyuu ꞉chu chēbo *kiirootyeet nyēē lēēl. +/Makiitaata sukusobcho ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","!Kāāmwoowook, ‑māwāāyyēē subak tifaayiik ākoy bēsyoonoo wāāyyēē chēē leelach ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nto tēē yoo, kutyēēn ꞉bichoo kōōkoostooy Yēyiin ānkung'ēētyo kutākyi keey Lekemeetaab *Musēytuuniinēk. ");
INSERT INTO spyNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kumii kēēltaab too, kumwoochi ꞉Yēēsu rubiikyii kule, “+Mōōmwēyēēnoo ꞉akweek tukul kuu yoo mwooyē ꞉siruutēk kule, ‘+Maabakach ākiintēēt kusērēēt ꞉kēēchiirēk.’ ");
INSERT INTO spyNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nteenee yoo kaang'eetee meet, +maantooy Kalilaaya.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kumwoochi ꞉Bētērō Yēēsu kule, “Ānkoo kāmwēyēēniing' ꞉chuut tukul, ‑māābākooktiing' ꞉anii.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kumwoochi ꞉Yēēsu kule, “Bētērō! Kāāmwoowuung', kumānēēturkuuchē ꞉kirkōōnkiit nyēbo āyēēng' kwēēmowuuni, +meetuuch keey ꞉inyiing' areet sōmōk kule ‑mēēnkētoo.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kumwoochi ꞉Bētērō Yēēsu subak kule, “Mākoy atuuch keey! Yoo kābo meet kēēbēku ꞉tukwaay.” Kōōruumchi ꞉nkicheek rubiik chuut kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yu kayit ꞉Yēēsu ākoo rubiikyii yēē /kēēkuurēē Ketesemaane, kumwoochi kule, “Ōbuurēē yu, waasaay ꞉anii.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Koonaata kisich ākoo Bētērō, Yāākōbō ākoo Yoowaana. Kwaam ꞉ng'uusng'uus Yēēsu kut kulōōklōōkēn. ");
INSERT INTO spyNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kumwoochi rubiichooto sōmōk kule, “Kāāmuy ꞉anii kut wuu nyēē +maameey. Ōng'ētunēē yuutēyu ānkōōkāsu!” ");
INSERT INTO spyNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Yooto koonaata ꞉inee kisich kukutuny ānkuyim kutiiny ꞉tokochta ng'wēny ankusaay kule, “Baaba! Imuuchāktōōs ꞉tukuuk tukul ām wōlēē imiitē. Inēmtoowoo nyalili. Nteenee kuyeyakay kuu wōloo imāktooy ꞉inyiing' mēēbērē kuu wōloo āmāktooy ꞉anii.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yu kēēyēēwunēē ꞉Yēēsu wōloo kāwokusooyēē, kunyōōr rubiik choo sōmōk kuruuytōōs. Kumwoochi Bētērō kule, “Simōōni, ākoo kēēru? 'Kāmēēmuuchē mbo ikāsu ām asiista akeenke? ");
INSERT INTO spyNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ōkāsu ankoosaay simōō-āsyi keey tyēmiisyēēt. Ōbērē nto oyey, āmāmii ꞉nkuruuk.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kooyeey ꞉Yēēsu subak ankuwokusaay kuu yoo kābo taay. ");
INSERT INTO spyNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nto iyēēwu nyēbo āyēēng', kunyōōr mbo Bētērō kuruuytōōs subak, kuuyu kichoosyootiin miisin. Kuchusyo ꞉rubiichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kiiyeey ꞉Yēēsu subak ankuwokusaay nyēbo sōmōk, nto yu kaweech keey, kumwoochi rubiichoo kule, “Ākoo tōōbēng'tēē rwoonik? Kaakuyem. Okas kaakuyit ꞉āsiiswēk /kiiyokoochi *Wēritaab Chii āwunnyēkaab kibng'ōōkisiis. ");
INSERT INTO spyNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ong'nyiin choomtooyiintēēt kāākuchō! Ōng'ēētyē bokēētuuyēē.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kutākumii ꞉Yēēsu kung'āloolē, kuyitu ꞉Yuuta nyoo ki akeenke ām rubiichoo ki taman āk āyēēng'. Kiboontoonu keey biiko chēē chaang' chēē kitinyē chōōkiinēk ākoo syaariinek chēē kiiyooku ꞉mbo kibkōrōs chēē wōōyēch ākoo booyik. ");
INSERT INTO spyNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kikiisimkumwoochinē ꞉Yuuta bichoo kule, “Nyoo ōkāsē ātōrōōchē, ōnāmē nyooto ānkōōriibootē simāmwēy.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kuyitu ꞉Yuuta, kutōrōōchē Yēēsu kule, “Aase, Mokoryoontēēt!” ");
INSERT INTO spyNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kutēryēkyinē ꞉bichoo Yēēsu bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kukāsē ꞉rubiintēēt ake kuu nyooto, kung'usu chōōkiit, nto bērē kuyeb motwooriintēētaab kibkōrōs nyēē wōō, kuchwenta yiitit kōōsuuyto. ");
INSERT INTO spyNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yooto, kumwoochi ꞉Yēēsu bichoo kināmē inee kule, “Ōbērē āntōōchinē ꞉anii lukēēt nyēē māchē kuweech kōōrēēt sookwaante chōōkiinēk āk syaariinek boonamaa? ");
INSERT INTO spyNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ntēē kwāāboontē keey ꞉anii akweek kwaak ām biiwuutaab *Kōōtaab Yēyiin ānēētiisyē. Kwaamaak ꞉nee simoonamaa yooto? Nteenee ityiichē ꞉ng'aleechu tukul siruutēkaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yu kāmwooy ꞉Yēēsu kuu nyooto, kumwēchi keey ꞉rubiikyii. ");
INSERT INTO spyNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kimii ꞉murēno nyēē kiinoomootē Yēēsu nyēē kikyaalyaktee keey ankeet baateey. Nto yu kibērē /keenam, ");
INSERT INTO spyNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kuchiwit kuchururchi ankaanaa yooto ānkumwēchi keey kibchuraat. ");
INSERT INTO spyNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","/Kikēēkwēryoot Yēēsu ākoy kaytaab *kibkōrōs nyēē wōō. Kikiiruruukyi keey wōlooto ꞉mbo kibkōrōs chēē wōōyēch, booyik ākoo kāānēētikaab kiruutēk. ");
INSERT INTO spyNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kiinaamaat ꞉Bētērō Yēēsu ākoy kuyit kiyēnkuutaab kaytaab bichoo bo kōrōs. Kumii wōlooto kōōbuur ꞉nkinee ng'wēny kuyu maata nyēē kimii kuywēē ꞉biiko chēē kiriibē kayaa. ");
INSERT INTO spyNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kimach *꞉kōōkwēētaab Yuutayeek tukul kōōyyoonkyinē ꞉mbo kibkōrōs chēē wōōyēch, kule kunyōōr ng'ālyoo nyēē miyaat nyēē nāmē Yēēsu /sikiitiilchi meet. Nteenee mānāānyōōr ng'ālyoo. ");
INSERT INTO spyNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ānkoo kimōlōlchi ꞉biiko chēē chaang' Yēēsu ng'al, kichuunchuun ꞉ng'aleekwaa. ");
INSERT INTO spyNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kimwooy ꞉alake subak kule, ");
INSERT INTO spyNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kikeekas ꞉acheek kumwooyē ꞉chiichi kule mākōōturbuub *Kōōtaab Yēyiin nyoo kitēēchē ꞉biiko ankuteech ake nyēē mēēbērē tēēchē ꞉biiko. Kālē makuteechee nyooto bēsyōōs sōmōk.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kichuunchuun ꞉nkicheek ng'aleekaab bichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yooto kōōyyo ꞉chiichoo wōō bo kōrōs ankuteebee Yēēsu kule, “Itinyē wōlēē ituuktooy keey ām ng'aleechu mwooyē ꞉bichu?” ");
INSERT INTO spyNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kusiisyi keey ꞉Yēēsu. Kumwoochi subak ꞉chiichooto wōō bo kōrōsēēk Yēēsu kule, “Inyiing' man *Kāārārookiintēēt, Lakwataab Nyoo Tōrōōr?” ");
INSERT INTO spyNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kumwoochi ꞉Yēēsu kule: “Anii ꞉nyooto anku +mookas *Wēritaab Chii kōōbuurunēē āwutaab taay nyēbo Nyoo bo Kāāmuukēy ankookas kuchōōnēē boolik.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kikwaany keey ꞉moo chiichoo wōō bo kōrōs kut kubaach sirookyii ānkumwooy kule, “Nee ake ꞉nyēē /tākēēmwoowēēch kurubta keey āk chiichi? ");
INSERT INTO spyNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kookas oob wōlēē kāākōōntosuurto Yēyiin? Kunyi, ōbērē nee akweek?” Kōōruumchi ꞉kiirwookik tukul kule, “Misyinē kume.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kung'utyi ꞉kiirwookik alake Yēēsu ankurat koonyek. Kurātootiin ꞉koonyek, /kiituluuksēt /ankeeteebee kule, “Mwoowu, baa, ng'oo ꞉nyi kēētuluuchiing'!” Yooto, koorabaakset ꞉bichoo kiriibē kayaata. ");
INSERT INTO spyNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kumii ꞉Bētērō kēēbuur biiy, chokumur yooto ꞉chēēbto ake nyēē kiyēchinē kibkōrōs nyēē wōō yiisyēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kōōrōōtoot ꞉chēēbooto Bētērō ānkulē, “Kwēēboontootē keey ꞉nkinyiing' oob chiichi bo Nāāsārēēt!” ");
INSERT INTO spyNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kutuuch keey ꞉Bētērō. Kimwooy kule, “‑Māānkētē kiyēē imwooyē.” Kōōnookyi ꞉Bētērō yēbo oreet nyēē wēētii kayaata. Yooto, kooturkuuch kirkōōnkiit. ");
INSERT INTO spyNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kutākumiitē ꞉Bētērō yooto bo oreet, kukas ꞉chēēbkēy subak, ānkumwoochi biiko chēē kimii yooto kule, “Lēyyē! Rubiintēētaab Yēēsu ꞉chiichi!” ");
INSERT INTO spyNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kutuuch keey ꞉Bētērō subak. Nyēē mā tyaa, kumwoochi ꞉biiko chēē kimii yooto kule, “Kubooyiit man! Inyiing' rubiintēētaab Yēēsu kuuyu isālu Kalilaaya.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kuchubchi keey ꞉Bētērō kule, “‑Māānkētē chiichi ōmiitē ōng'āloolēē.” ");
INSERT INTO spyNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yooto, kooturkuuch ꞉kirkōōnkiit nyēbo āyēēng'. Koosoot ꞉Bētērō yoo kāmwoochinē ꞉Yēēsu kule, “Kumaneeturkuuch ꞉kirkōōnkiit nyēbo āyēēng', +meetuuch keey ꞉inyiing' areet sōmōk kule ‑'mēēnkētoo.” Kuriir ꞉Bētērō nyēē ng'waa. ");
INSERT INTO spyNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nto yu kāmwook ꞉asiista, kootiil *꞉kōōkwēētaab Yuutayeek tukul kunam wōlēē mii ꞉mbo *kibkōrōs chēē wōōyēch, booyik āk kāānēētikaab kiruutēk kurat Yēēsu ānkukwēryoot ākoy kaab *Bilaato. ");
INSERT INTO spyNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yu /kakiiyiitita kaab Bilaato, kuteebee ꞉nyoo Yēēsu kule, “Inyiing' ꞉bāytooyiintēētaab Yuutayeek?” Kumwoochi ꞉Yēēsu kule: “Wuu nyooto, sinee.” ");
INSERT INTO spyNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kiiteeyee keey ꞉mbo kibkōrōs chēē wōōyēch kule kiikuyey ꞉Yēēsu ng'al chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kuteebee ꞉Bilaato Yēēsu kule, “Māmii ꞉kiyēē 'ikētu kurubta keey ng'aleechu mwooyē ꞉bichu kule !kiiyey?” ");
INSERT INTO spyNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mānāākēt ꞉Yēēsu ng'ālyoo. Kubotyi ꞉tonkoy Bilaato. ");
INSERT INTO spyNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kiityooktooy ꞉bāytooyiintēēt ām kēnyiit ake tukul kibratyaanteet akeenke nyoo kaakutool ꞉biiko. /Kikēēyēyē kuu nyooto yoo /kyoomē *Saakweetaab Keeytaayeet. ");
INSERT INTO spyNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kimii ām bēsyōōsyēchooto ꞉biiko alake chēē kikwiilē bāytooyiisyēētaab Bilaato ānkikiikubākākiis kut /kikiikeerat. Akeenke ām bichooto ku nyēē /kikēēkuurēē Baraaba. ");
INSERT INTO spyNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yooto kōōruruukyi keey ꞉biiko chēē chaang' kaytaab Bilaato. Kusoom ꞉bichoo Bilaato kōōtyooktoochi chiito akeenke nyēē rataat kuu yoo kwēētyooktoochinē kwaak yoo mii ꞉saakwaanaa. ");
INSERT INTO spyNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kuteeb ꞉Bilaato kule, “Ōmāchē ātyooktoowook bāytooyiintēētaab Yuutayeek?” ");
INSERT INTO spyNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kitēēbēē ꞉Bilaato bichoo kuu nyooto kōōnkētē kule kēētuuyiityi ꞉mbo kibkōrōs Yēēsu moo. ");
INSERT INTO spyNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nteenee kōōwuruur ꞉mbo kibkōrōs biiko tukul kumwoochi Bilaato kootyaakta Baraaba yoo kātēētyooktooy Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kuteeb ꞉Bilaato kule, “Kunyi, ōmāchē ayeyee nee naas chiichi ōbērē bāytooyiintēētaab Yuutayeek?” ");
INSERT INTO spyNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kōōruumchi ꞉biiko tukul kule, “Ibakach!” ");
INSERT INTO spyNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kumwoochi ꞉Bilaato biiko kule, “Ara koleel nee ꞉chiichi?” Kubōloobōl ꞉biiko kule, “Obakach! Obakach!” ");
INSERT INTO spyNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nto kuuyu kimāmāchē ꞉Bilaato kunyēēr ꞉biiko, kōōtyooktoochi Baraaba. /Kikiityōōlsēt Yēēsu, nto tēē yoo kōōyokooyto /bokēēkwērtoochi *murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kubeeta ꞉biikaab lukēēt Yēēsu ākoy kaytaab *Bilaato āriit ānkukuur lukēētaab booryēēt tukul. ");
INSERT INTO spyNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kōōlookyi sireet nyēē arraa ankutaay kuutwēētaab kātook ankookemeer mētinyii wuu nyēē kāyēk bāytooyiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yu /kāākiilookyi tukuuchoo, /kēētoow /keeyey keey kule /kākēēsilto Yēēsu /kēēmwooyē kule, “Kimkim! Bāytooyiintēētaab Yuutayeek!” ");
INSERT INTO spyNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kiikōryōōnyēē ꞉bichoo Yēēsu kirōkto mēt ānkung'utyinē kibtaman ānkukutunyēē taayeenyii kuyēyē keey kule kākoonyit. ");
INSERT INTO spyNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yu /kāākiintosuur, /kiirēēkunēē siraanaa arraa /ānkiilookyi sirookyii choo bo kwaak nto tēē yoo, /kēēkwēryoot /bokēēkwērtoochi murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","/Kēēmii /kēēbēētooy /kēētuuyēē chiito ake nyēē kibo kōōrēētaab Kurēēn. /Kikēēkuurēē chiichoo Simōōni nyēē ki kwaaniitaab Alekisaanta ākoo Ruufō. /Kēētuuyēē kuu nyooto, /kēēkērchinē koong' kukalab murtooywoontēētaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kikwēryoot ꞉bichoo Yēēsu ākoy yēē /kēēkuurēē Kolkoota, (kaayneet nyēē ibooru kule ‘Rōkyēētaab Mēt’). ");
INSERT INTO spyNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nto bērē kōōkoochi ꞉bichoo Yēēsu *tifaayiik chēē /kikeetasee saakityeek alak, kutay kuyye. ");
INSERT INTO spyNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kukwērtoochi ꞉bichoo Yēēsu murtooywoontēēt. Nto yu mākubchēchi keey sirookyii, kubar *sēkēēryēēt sukōōnkētēē kule ng'oo ꞉nyēē mākuyib sireet nkōnō. ");
INSERT INTO spyNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ki asiistaab sōmōk nyēbo kōrrōōn, yu /kikēēkwērtoochinē Yēēsu murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","/Kikiikēēsirchi kiito ake ng'aleek chēē kiyey /sikiitiilchi Yēēsu meet chēē kimwooyē kule: BĀYTOOYIINTĒĒTAAB YUUTAYEEK. ");
INSERT INTO spyNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","/Kikēēkwērtoochi nkicheek kibng'ōōkisiis āyēēng' murtooywōōsyēkwaa. /Kikiiyyoong'tēē ake āwutaab taay nyēbo Yēēsu /ānkiiyyoong'to ake nyēbo kaataam. ");
INSERT INTO spyNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kiinchuruurē ꞉biiko chēē kimurē yooto Yēēsu ānkukwērtooy mētēwook kumwoochinē kule, “Ntēē kwēēbērē ꞉inyiing' +mēēturbuub *Kōōtaab Yēyiin ankiiteechee subak bēsyōōsyēk sōmōk? ");
INSERT INTO spyNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Iraraach keey naas. Irēkunēē murtooywoontoonoo!” ");
INSERT INTO spyNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kiinchuruur ꞉nkicheek mbo kibkōrōs chēē wōōyēch ākoo kāānēētikaab kiruutēk Yēēsu kumwoochinē keey kule, “Kiisoobē ꞉chiichi biiko alak, ntēē ‑mēēsoob keey naas. ");
INSERT INTO spyNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kēēmāchē keekas ra kāārārookiintooni kuurē keey kule bāytooyiintēētaab *Isrāyēēliik. Yoo keemuuch kurēkunēē murtooywoontooni, +mākiiyēnchi.” Kiinchuruur ꞉nkicheek kibng'ōōkisiisyēchoo kimii murtooywōōsyēkwaa. ");
INSERT INTO spyNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kichō ꞉mēēnānēēt bēēt nyēē kiker kōōrēēt tukul, kung'eetee āsiiswēk lo ākoy āsiiswēk sokool. ");
INSERT INTO spyNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yu kayit āsiiswēk sokool kōōnchō ꞉Yēēsu kule, “Yēyiintēēnyuu, Yēyiintēēnyuu, ntēē 'keebakaaktaa!” (Kimwooyē yooto ām kuutiinyii kule, “Ēlōōy, Ēlōōy, lema sabaktani?”) ");
INSERT INTO spyNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yu kakas ꞉biikaab lukēēt chēē kimii yooto, kulē, “Okas, miitē kukuurē *Eliiya.” ");
INSERT INTO spyNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kulabatee ꞉chiito ake kiroonkuryēēt ankooluumta *tifaayiik chēē tāytāy. Kurutyi kiroonkuryoonoo kēētit ānkōōyokoochi kuutiitaab Yēēsu ānkulē, “Okany keekas yoo mākuchō ꞉Eliiya chokōōrēēkunēē murtooywoontooni!” ");
INSERT INTO spyNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kiinchō ꞉Yēēsu ankung'et. ");
INSERT INTO spyNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yooto bakeenke, kukērēērunēē keey āyēēng' kuchakee barak ākoy ng'wēny ꞉ankeet nyēē ki rikimim nyoo /kikiiyēēlēē Kitōōkiitaab *Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yu kakas ꞉chiito nyēē wōō nyēbo lukēētaab booryēēt wōlēē kameeta ꞉Yēēsu, kumwooy kule, “Kubooyiit man, ākoo Lakwataab Yēyiin ꞉chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kikiiyyoong'iis ꞉chēēbyōōsōōk alake yēē lōō kutoobēnē kiyēē kiyēyāktōōs. Chēēbyōōsōōchoo alak ku Maaryaa nyēbo Maktaala, Sālōōmē ākoo Maaryaa kaametiitaab Yōōsē āk Yāākōbō nyoo mining'. ");
INSERT INTO spyNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kirubootē ānkiyēētyēēchinootē ꞉chēēbyōōsōōchoo Yēēsu, yoo kimii Kalilaaya. Kimii ꞉nkicheek chēēbyōōsōōk alake yooto chēē chaang' chēē kiinaam Yēēsu ākoy Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ki bēsyēēt ꞉nyooto nyēē kichōbēē keey ꞉Yuutayeek kukānyoonu bēsyēētaab *Sabaato. Kimii ꞉boontēēt ake nyēē /kikēēkuurēē Yōōsēēf nyēbo *kiriinkēētaab Arimataaya nyēē ki kiirwookiin nyēē kitookunoot ām *kōōkwēētaab Yuutayeek. Kikiikōōyēnchi ꞉boontoonoo kule kichōōnēē ꞉Yēēsu Kaab Yēyiin chokuyēk Bāytooyiintēēt nyoo /kikēēmii /kēēkānyē. Yu kakas ꞉boontoonoo kule kaakuriik ꞉āsiiswēk chēē toowu ꞉bēsyēētaab *Sabaato ānkutākumii ꞉Yēēsu murtooywoontēēt, kukāng' ānkuwo kaab *Bilaato wokusoom /kēēchāmchi kōōnēm muustaab Yēēsu sukumuy, kumanaarataarat ꞉kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kiilat ꞉Bilaato yu kakas kule kaakume ꞉Yēēsu. Kikuur chiito nyēē wōō nyēbo lukēēt ankuteebee kule, “Kaakume ꞉Yēēsu, man?” ");
INSERT INTO spyNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kumwoochi ꞉nyoo kule, “Kaakume.” Kuchāmchi Yōōsēēf wokuyib muustaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kiwokwaal ꞉Yōōsēēf ankeet ānkuwokōōrēēk muustaab Yēēsu ām murtooywoontēēt ankuratee ankaanaata. Kunam muusto ānkuwokōōtōōr kochonkeet ake nyēē /kikiikiiwōr. Nto yityo, kuwunukyi rwaanteet nyēē wōō kuker kochonkaanaa. ");
INSERT INTO spyNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kikāsē ꞉Maaryaa nyēbo Maktaala ākoo Maaryaa, kaametiitaab Yōōsē, yēē /kikeekonoree Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yu kāākubēk ꞉bēsyēētaab *Sabaato kukararakta ꞉asiista, kuwo ꞉Maaryaa nyēbo Maktaala, Sālōōmē, ākoo Maaryaa kaametiitaab Yāākōbō, wokwaal mwaanik chēē boong'u nyēē anyiny subokooyiilee muustaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yu kēērir ꞉kōōrēēt, kubeeta mwaanichaa ākoy wōloo /kikēēmuchinē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Kumii kēēlto, kutēēbootēē keey kule, “Ng'oo ꞉nyēē wokuwunuktoowēēch rwaantaanaa tēē nyoo ēē?” Yu kayit, kukasta, nto bērē kulē, /kiikēēwunukto rwaanteet kuyaatakay ꞉kochonkeet. ");
INSERT INTO spyNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kōōwut kochong'. Yooto, kukas murēn nyēē kikiibuur āwutaab taay ām kochong'. Kikiilaach sireet nyēē lēēl anku kooy nyēē kiilēkēchēēchē miisin. Kumuuyo ꞉chēēbyōōsōōchoo miisin yu kakas chiichoo. ");
INSERT INTO spyNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kumwoochi ꞉chiichoo kule, “‑Mōōmuuyē! Ānkētē kule kōōmāchē Yēēsu nyēbo Nāāsārēēt nyoo /kōkēēkwērtoochinē murtooywoontēēt. Kaakung'eetee meet, neennyi māmii yu. ‑Mōōkāsē yu /kikiitōōrē! ");
INSERT INTO spyNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bōōmwoochi Bētērō ākoo rubiik chuut kule, ‘Makoonto ꞉Yēēsu Kalilaaya wōlēē +mābōōnyōōrchi kuu wōloo kimwooytoowook.’ ” ");
INSERT INTO spyNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kichuwunee ꞉chēēbyōōsōōchoo kochonkaanaa nyēē kābōōtoon. Kilabat āmānāāng'āloolchi chii ake tukul ām kēēltaab too.  ");
INSERT INTO spyNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","King'ēētēē ꞉Yēēsu meet kukāng'ēēyēn ꞉kōōrēēt ām bēsyēēt nyēē kirubē bēsyēētaab *Sabaato. Nto chiito nyēbo taay kōōboorchi keey ꞉inee ku Maaryaa nyēbo Maktaala, nyoo kiibēbēētoochinē tāmirmirook chēē miyootēch tisab. ");
INSERT INTO spyNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Kuwo ꞉Maaryaa nyi bo Maktaala ākoy wōlēē kimii kuriiryēē ꞉rubiikaab Yēēsu ānkumwoochi kule, “!Kaakas Yēēsu! Soboot!” Kuchweesta ꞉rubiichoo ng'aleekyii. ");
INSERT INTO spyNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kikiikuwalak ꞉eertaab Yēēsu kōōboorchinē keey rubiikyii āyēēng' chēē kimii kēēltaab too kukwoonēē Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yooto, kooyeey ꞉rubiichoo Yēērusālēēm bokumwoochi chuut kule, “!Kaakeekas Yēēsu.” Kuchweesta ꞉chuut ng'aleekwaa subak. ");
INSERT INTO spyNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ām lētuunoo, kōōboorchi keey ꞉Yēēsu rubiik choo ki taman āk akeenke kumii kwoomiisyē. Kibōlchi ꞉Yēēsu rubiichoo, kuuyu kitay kōōyēnchi kule kiimuuchē ꞉inee kung'eetee meet ākoo mbo subak kule kichwees ng'aleekaab biiko choo kimwooy kule kiikukas inee ānkusoboot. ");
INSERT INTO spyNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nto mii yoo, kumwoochi rubiikyii kule, “Obe kōōrōōsyēk tukul bōō-āmchinootē biiko tukul lōkōōywēk chēē kāroomēch. ");
INSERT INTO spyNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Chii ake tukul nyēē kēēyēnwoo /ankeebatisan, makooraraach ꞉Yēyiin. Nto nyoo kāmēēyēnwoo, +/makiiruusta. ");
INSERT INTO spyNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","+/Mākiikoochi biiko choo kēēyēnwoo kāāmuukēywēēk chēē imuuchē kuyey kiy nyēē ‑mēēmuuchē ꞉chii ām nkuruukyii. Imuuchē ām kaayneenyuu, kōōbēbēētooy tāmirmirook chēē miyootēch kung'ēētyēē biiko. Makung'alaal ng'ēlyēēbik chēē ‑mēēnkētē. ");
INSERT INTO spyNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yoo kanam eereen māyēyēē kiy, nto yoo kayye mbo ng'woonēēt mābākāchē. Yoo kātiinyēē chii nyēē imnyoonē āwunnyēk ankusaay Yēyiin, kusobē ꞉chiichoo.” ");
INSERT INTO spyNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yu kaakoowaany ꞉Mokoryoontēēt Yēēsu kung'āloolchi rubiikyii, /kēēyib kuwo Kaab Yēyiin wokōōbuurēē āwutaab taay nyēbo Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kiba ꞉rubiik kōōrēēt tukul bokwaamta ng'aleekaab Yēēsu. Yu kyoomtooy ng'aleechaa, kiyēyē ām kāāmuukēywēēkaab Yēēsu tukuuk chēē ‑mēēmuuchē ꞉chii kuyey. Tukuuchooto chēē kiyey biiko chēē chaang' kucham kule bo man ꞉lōkōōywēchooto.");
INSERT INTO spyNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Boontēēt nyēē koonyitoot Tēyōfiilō, kiikusir ꞉biiko chēē chaang' ng'aleek chēē kiikuyēyākiis ām wōlēē kēēmiitē. ");
INSERT INTO spyNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kisir kuu wōloo kimwooytoowēēch ꞉biiko choo kikāsē ng'aleechaata rubtooy keey āk Yēēsu. Bichooto mbo ꞉chēē kibokwaamtaat ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Boontēēt nyēē koonyitoot, kuuyu kwāārōōtootē tukuuchoo tukul kung'eetee wōlēē kitoowunēē, kaasoot kule karaam asiruung' ām kēēlto nyēē chōboot ");
INSERT INTO spyNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","siinkēt kule man ꞉kiy ake tukul nyoo /kiikiineetiing'. ");
INSERT INTO spyNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yu kibāytooy *꞉Ērōōtē kōōrēētaab Yuutayeek kumukuul, kimii *꞉kibkōrōs ake nyēē /kikēēkuurēē Sekaryaa nyēē kichōōnēē sokonnyeet nyēbo mbo *kibkōrōs nyēbo Abiiya. Nto cheebyoosyeenyii ku Ēliisābēēt nyēē kibo kōōtaab *Āārōn nyoo kiyootu mbo kibkōrōs. ");
INSERT INTO spyNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kiiywēyē ꞉Sekaryaa āk cheebyoosyeenyii Yēyiin ānkirubē kiruutēk tukul kuu wōlēē māktooy ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kikiikōōbuurchiin ꞉tukwaay nyēē lōō āmānāānyōōr lēēkōōy, kuuyu ki sōōn ꞉Ēliisābēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kimii ꞉yēē kiyēyiisyē ꞉Sekaryaa ām *Kōōtaab Yēyiin, kuuyu kibo kōōng'waa ꞉bārooyinto kuyēyiis. ");
INSERT INTO spyNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","/Keekwey inee ām bareetaab *sēkēēryēēt, kuu wōloo /kikēēyēytooy kwaak, kōōwut Kōōtaab Yēyiin wōloo kiiwutē ꞉mbo kibkōrōs nkit wokōōtuskēēn kiito ake nyēē boong'u nyēē anyiny. ");
INSERT INTO spyNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kisooyē ꞉biiko chuut tukul ām saang' ku tēē yooto tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kutākumii kō, kuchōōnchi *꞉malayikeet ake ānkōōyyoonyēē āwunyii nyēbo taay ām yoo kiituskēēnēē kiyoo. ");
INSERT INTO spyNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kuteryekta keey ꞉mukuulēy Sekaryaa ānkumuy miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nteenee kumwoochi ꞉malayikaanaa kule, “Sekaryaa, ‑mēēmuy! Kaakukas ꞉Yēyiin saayeeng'uung'. Kunyoo, mākusikuung' ꞉cheebyoosyeeng'uung' leekweet nyēē wēēriit ānku +mēēkuurēē lakwanaata Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","+Meeng'erech ānku mākung'ērēkiis ꞉nkicheek biiko chēē chaang' kubo ng'ālyoontooni. ");
INSERT INTO spyNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mākuyēk ꞉Yoowaana chii nyēē wōō ām taayeetaab Yēyiin. Mēēbērē makuyye *tifaayiik nto tukuuk alak tukul chēē ibōōkiitē biich. Mākōōnyiityi ꞉Yēyiin Tāmirmiryēēnyii ānkoo kutākumiitē mooyēētaab kaamet. ");
INSERT INTO spyNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Makuweech biikaab *Isrāyēēl chēē chaang' kucham Yēyiintēēng'waa. ");
INSERT INTO spyNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Makoonto ꞉inee taayeetaab Mokoryoontēēt ām tāmirmiryēēt āk kāāmuukēy chēē wuu choo kibo *Eliiya. Mākōōchoomnyo lēēkōōk ākoo sikiikwaa, makuweech biiko choo kāwōōt kukas ng'aleekaab choo churtootiin ankuyeyta biiko kutorooch Mokoryoontēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kumwoochi ꞉Sekaryaa malayikaanaa kule, “Ntēē kōōkēēwōōyēkiitu ꞉tukwaay. +Māānkētēē nee kule man ꞉ng'aleechu?” ");
INSERT INTO spyNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kukētyi ꞉malayikaanaa kule, “Ntēē ꞉anii Kāāburyēēl, nyoo ālēēkityiintōōsii āk Yēyiin! /Kāākiiyookwoo āyibuung' lōkōōywēchu kāroomēch. ");
INSERT INTO spyNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kas! Mākuyēyākiis ꞉ng'aleechu ām bēsyēēt nyēē kiikukwey ꞉Yēyiin. Nteenee kuuyu maneecham kiyēē kāāmwoowuung', makunaming' keey ꞉kuut ākoy kuyityiin ꞉bēsyoonooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kikānyiis ꞉biiko choo kimii saang' kut kulē, “So! Nto yu keekaay keey ra ꞉Sekaryaa ām kō kuu nyi ēē?” ");
INSERT INTO spyNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yu kāwokuchuw saang', kikiikunamakay ꞉kuutiit nyēē kimēēmuuchē kut kung'alaal. King'āloolchinēē biiko āwunnyēk baateey. Kōōnkēt yooto ꞉biiko kule kikiikutookyi Sekaryaa ꞉ng'ālyoo kuchōōnēē wōlēē mii ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kitas taay ꞉Sekaryaa kuyēyiisyē ām *Kōōtaab Yēyiin ākoy kubēk ꞉bēsyōōsyēkyii. Nto mii yoo, kuwēēchi keey kaa. ");
INSERT INTO spyNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nyēē mā tyaa, kunam ꞉mooyēēt Ēliisābēēt. Kuwunyee keey kō ārook muut. Kumwoochi keey yooto kule, ");
INSERT INTO spyNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kaakuriireenaa ꞉Yēyiin kōōnēmtoowoo kāānchuruurēētaab biiko kuuyu mānāāsich.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ām araaweetaab lo kung'eetee kukānyikisiit ꞉Ēliisābēēt, kōōyookto ꞉Yēyiin malayikeet Kāāburyēēl kuwo ākoy Nāāsārēēt ām yēēmēētaab Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kimii *꞉ārung'oonyoontēēt ake wōlooto nyēē /kikēēkuurēē Maaryaa. /Kikiikēēmākyi chiito ake nyēē /kikēēkuurēē Yōōsēēf nyēē kichōōnēē kōōtaab Bāytooyiintēēt *Tāwuti. ");
INSERT INTO spyNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kiwo ꞉malayikaanaata ākoy yēē kimii ꞉Maaryaa ānkumwoochi kule, “Ichāmu nee ōō, Maaryaa? Sērē, ichamaat ām taayeetaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kibotyi ꞉Maaryaa kiyēē mākumwooy, yu kakas ng'aleechaa. Kiteebee keey kityō kule, “Ng'al nee ꞉chu ēē?” ");
INSERT INTO spyNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kumwoochi *꞉malayikeet kule, “‑Mēēmuy! Kāākōōbēruuriing' ꞉Yēyiin! ");
INSERT INTO spyNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kunyi, imiitē wēēnyikisiitu ānku +mēēsich leekweet nyēē wēēro ānku +mēēkuurēē lakwanaa Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mākuyēk chii nyēē iyweyaat ānku Lakwataab Yēyiin. Mākōōkoochi ꞉Yēyiin kāāmuukēywēēk kubāytooyiis kuu Tāwuti. ");
INSERT INTO spyNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Makubayta biikaab *Isrāyēēl ām kēnyiisyēk chēē mābēku.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kuteebee ꞉Maaryaa malayikaanaa kule, “Āmuuchē ꞉anii ānyōōru leekweet kule nee? Ntēē atiimaat.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kukētyi ꞉malayikaanaa kule, “Mākuchōōnchiing' ꞉Tāmirmiryēētaab Yēyiin ankoolaambuuchiing' ꞉kāāmuukēywēēkyii. Churtaat ꞉leekweet nyēē +mēēsich /ānkumākēēkuurēē lakwataab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nto subak, ānkoo kimwooyē ꞉biiko kule ki sōōn ꞉tilyeeng'uung' Ēliisābēēt ānkimii kukēēytēē kēnyiisyēkaab yyootēēt, boonto ra mooyēēt nyēbo ārook lo. ");
INSERT INTO spyNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Māmiitē ꞉kiy nyēē mēēmuuchāksē ām wōlēē mii ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kumwooy ꞉Maaryaa kule, “Āchāmē kiy ake tukul nyēē mākwoo ꞉Yēyiin. Kunyoo, kany kuyeyakay kuu wōloo 'keemwaayte.” Yooto, kuwēēchi keey *꞉malayikeet. ");
INSERT INTO spyNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Yooto bakeenke, kuruutoochi ꞉Maaryaa Ēliisābēēt āk boontēēnyii Sekaryaa chēē kiminyē *kiriinkēēt ake ām mosoobēytaab yēēmēētaab Yuuteeya. Kuyitē kayaata ");
INSERT INTO spyNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ānkōōtookwēēsē Ēliisābēēt, kwoorēērēnē ꞉lakwataab Ēliisābēēt ām moo. Kōōnyiityi ꞉Yēyiin Ēliisābēēt tāmirmiryēēt ");
INSERT INTO spyNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kukuurchi barak kumwoochinē Maaryaa kule, “Ibēruuroot kusiir kooruuk alak tukul! Ibēruuroot mbo ꞉leekweet nyēē +mēēsich. ");
INSERT INTO spyNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ng'ālyoo nyēbo koonyit sōō, kule nee kuchō ꞉kaametiitaab Mokoryoontēēnyuu kut chokukasa. ");
INSERT INTO spyNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yooto 'kēēchōōnii kō ānkiitookwēēsoo, kwoorēērēnē ꞉leekweet ām moo kubo ng'erekweek. ");
INSERT INTO spyNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ibēruuroot ꞉inyiing' nyoo 'kiiyēnchi kule makuyeyakay ꞉kiyēē kiikumwooy ꞉Yēyiin!” ");
INSERT INTO spyNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nto mii yoo, kutyēēn ꞉Maaryaa kule, “Āsiltooy Yēyiin ām mooyēēnyuu tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Baybay ꞉tāmirmiryēēnyuu kubo Kāārārookiintēēnyuu Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kaakoosoot kōōbēruuroo, motwooriintēēnyii nyēē mining'. Kung'eetee raat kuwo taay, +/mākēēkuuro kule ‘nyēē kiikōōbēruur ꞉Yēyiin’. ");
INSERT INTO spyNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kāākuyēwoo ꞉Yēyiin ng'ālyoo nyēē wōō miisin. Lēyyē, kusilākoy ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Riirēē ꞉Yēyiin biiko tukul choo iywēyē inee kung'eetee binuut āk binuut. ");
INSERT INTO spyNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kāākōōboor kāāmuukēywēēkyii ānkōōsērwēētē choo ng'āsē keey. ");
INSERT INTO spyNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ichuchuukunēē bāytooyik ng'ēchērōōkwaa ānkōōloong'tēē choo yibē keey ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ibiyoonyēē biiko choo āmē ꞉kēmēwuut tukuuk tukul chēē kāroomēch ānkukwētē choo mokorēēn āmēēkoochi kiy. ");
INSERT INTO spyNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kiikuyēētyēēchēēch acheek biikaab *Isrāyēēl choo motwoorikyii. Lēyyē! Kaakoosoot ra ꞉Yēyiin kiyēē kimwooyē kule makuriiree kōyoo bo *Abraam kēnyiis āk kēnyiis. Ng'aleechuutēchu ꞉choo kimwoochinē biikyoo choo kibo taay.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kiibuurto keey ꞉Maaryaa Ēliisābēēt ārook chēē māchē kuyitē sōmōk nto iyēēyē kaa. ");
INSERT INTO spyNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nto mii yoo, kusich Ēliisābēēt leekweet nyēē wēēriit. ");
INSERT INTO spyNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yu kakas ꞉laatoosyek āk tilyōōnuutēk kiisayta nyēē kiiboorchi ꞉Yēyiin Ēliisābēēt, kung'ērēkiis ꞉tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kutinyē ꞉lakwanaa bēsyōōsyēk sisiit kuba ꞉laatoosyek āk tilyōōnuutēk saakweet nyēē */kikiimurootānēē lakwanaa. Kimāchē ꞉bichoo kule nto /kēēkuurtēē leekweet kaayneetaab kwaan kule Sekaryaa. ");
INSERT INTO spyNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nteenee kutāyiis ꞉kaamet. Kimwooy kule, “+/Mākēēkuurēē Yoowaana.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kumwooy ꞉biiko kule, “O, ntēē māmii ꞉chii ām kōōng'woong' nyēē /kēēkuurē kuu nyoo!” ");
INSERT INTO spyNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","/Keeteebee Sekaryaa /kēēng'āloolchinēē āwunnyēk kōōboor wōlēē +/mākēēkuurto leekweet. ");
INSERT INTO spyNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kumwaayta /kiikoochi kiyēē kasir. Yu kasir kule, “+/Mākēēkuurēē lakwani Yoowaana,” koolat ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kootyaak ꞉ng'elyebtaab Sekaryaa bakeenke ānkusilto Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kimuuyo ꞉laatoosyek miisin. /Kikyaamtaat ng'aleechaa kuyit komoswookik tukul chēbo mosoobēytaab Yuuteeya. ");
INSERT INTO spyNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kiteebee keey ꞉chii ake tukul kule, “Ara māchokuyēk nee ꞉lakwani?” Kitookunoot ꞉lakwanaa kule tinyē kāāmuukēywēēkaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nto mii yoo, kōōnyiityi ꞉Yēyiin Sekaryaa tāmirmiryēēt kutyēēn kule, ");
INSERT INTO spyNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kutōrōriit ꞉Yēyiintēētaab *Isrāyēēl, kuuyu kachokooraraach biikyii. ");
INSERT INTO spyNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mii kōōyookwēēch Kāārārookiintēēt kuchōōnēē kōōtaab *Tāwuti, nyēē boonto kāāmuukēywēēk miisin, ");
INSERT INTO spyNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kuu wōloo kimwooytooy ꞉Yēyiin kēny kubununēē wōōrkooyikyii. ");
INSERT INTO spyNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Makooraraacheech ām wōlēē mii ꞉buunikyoo ākoo mbo ām wōlēē mii ꞉biiko chēē wēchēēch. ");
INSERT INTO spyNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Kaakuriiree ꞉Yēyiin man mbo kuuko kootyiich *kiirootyeet nyoo kimwoochinē *Abraam. ");
INSERT INTO spyNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mākukōōnēēch mbo bārooyinto nyēē kēēyēchinē yiisyēēnyii nyēē ‑mākēēmuuytōōsii. Mākusārunēēnēēch wōlēē mii ꞉buunikyoo ");
INSERT INTO spyNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ankuyeyeech kēētililiitu ankeechurte ākookoy ām taayeetaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nto inyiing' ii, lakwanyuu, +mēēyēku *wōōrkooyoontēētaab Yēyiin. +'Meentooy wēēyēytoochi Mokoryoontēēt kēēlto. ");
INSERT INTO spyNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","+Māwēēboorchi biiko kōōnkēt wōlēē /kiirārooktooy yoo kāsoom /kēēnyōōchi kaat. ");
INSERT INTO spyNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Riirēēnēēch ꞉Yēyiin ām mooyēēnyii nyēē lēēl. Mākōōyook lēbkēēyyēēt kuchōōnēē kibkōōnkōy ");
INSERT INTO spyNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","chokōōluuchi biiko choo kiikoolaambuuch ꞉mēēnānēētaab mēēyinto. Mākōōrēētootēēch ꞉lēbkēēyyooni kēēnyōōru tāloosyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kinerta ꞉Yoowaana ng'ālyoontēētaab Yēyiin ām nkuruukyii tukul. Kiminyootē suurkwēēn ākoy bēsyēēt nyēē kichokōōboorchi keey biikaab *Isrāyēēl. ");
INSERT INTO spyNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kimii ꞉bāytooyiintēēt ake ām bēsyōōsyēchooto nyēē kibāytooy Rooma ākoo kōōrōōsyēk alak chēē chaang'. /Kikēēkuurēē bāytooyiintoonoo *Kayisaar Ākuustō. Kimwaayta ꞉kāāntōōyiintoonoo /kiiyiit biiko tukul ām kōōrōōsyēchooto. ");
INSERT INTO spyNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kibo taay ꞉kāāyiitiisyoonoo ām nyoo kichokuyēyāktōōs kubāytooy *꞉Kirēēnnyō kōōrēētaab Siirya. ");
INSERT INTO spyNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","/Kikēēmwooy kule /bokiiyiitēē ꞉chii wōlēē /kikēēsikyinē. ");
INSERT INTO spyNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nto kuuyu kibo ꞉Yōōsēēf kōōtaab Tāwuti, king'eetee Nāāsārēēt ām yēēmēētaab Kalilaaya ānkuwo kiriinkēēng'waa Bēētēlēyēēm ām yēēmēētaab Yuuteeya wōloo /kikēēsikyinē Bāytooyiintēēt *Tāwuti. ");
INSERT INTO spyNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kiwēēto keey Maaryaa nyi kimāchē kule sukoomut ānkoo kikiikuriik kucham keey. ");
INSERT INTO spyNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kumii wōlooto, kwaam Maaryaa ꞉mooyēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nyēē mā tyaa kutwaat wēēriit. Kōōyēēn leekweet ānkōōmukoonchi mwēēnkēēt nyēē /kiing'ēēng'sēē ām mchoor, kuuyu kimāmii ꞉bārooyinto kōōtaab tāyēēk. ");
INSERT INTO spyNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kimii ꞉ākiik alake kwēēmowuunooto chēē kyookooy kēēchiirēk ām yeecheyta nyēē kilēēkitēē Bēētēlēyēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kuchōōnchi *꞉malayikeet ākiichoo ām lēbkēēyyēētaab Yēyiin ankookweny icheek. Kinam bichoo ꞉muyātēēt kut kubōōtoon. ");
INSERT INTO spyNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nteenee kumwoochi ꞉malayikaanaa kule, “‑Mōōmuuyē! Āyibwook ꞉anii lōkōōywēk chēē makuyey biiko tukul ām kōōrēēt kung'ērēkiis miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","/Kāākēēsikwook raat ām Bēētēlēyēēm *Kāārārookiintēēt nyoo kwōōkānyoonu. Nyooto ku Mokoryoontēēng'woong'. ");
INSERT INTO spyNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yoo sōōnyōōru lakwanaa, +mookas /kāākiiyēēnēē sirook /ānkiimukoonchi mwēēnkēēt nyēē /kiing'ēēng'sēē.” ");
INSERT INTO spyNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nyēē mā tyaa, kurēkunēē ꞉lukēētaab malayikaanik kibkōōnkōy, kuyēmo āk nyiin ānkutyēēn ꞉tukul kōōkoostooy Yēyiin kule, ");
INSERT INTO spyNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wōō ꞉Yēyiin ām kibkōōnkōy! Mii kuchōōnchinē ꞉tāloosyēēt biiko, choo makuchamta ꞉Yēyiin, kule churtootiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yu keeyeey ꞉malayikaanichaa kibkōōnkōy, kumwooy ꞉ākiik kule, “Murēchu, okany keebe Bēētēlēyēēm bokeekas ng'ālyoontooni kāākōōboorwēēch ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yu kāmwooy kuu nyooto, kulabat ākoy wōlooto ānkubokunyōōr Maaryaa, Yōōsēēf āk leekweet nyēē /kāākiimukoonchi mwēēnkēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yooto, kumwoochi ꞉ākiichoo biiko ng'aleekaab malayikaanaa chēē kirubtooy keey lakwanaa. ");
INSERT INTO spyNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kiilat ꞉biiko tukul ng'aleechaa kyoomu ꞉ākiik nteenee ");
INSERT INTO spyNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","kinamtaat ꞉Maaryaa mēt. ");
INSERT INTO spyNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kiikoostootē ꞉ākiichoo Yēyiin kumii kōōyēēyē wōloo kimii ꞉kēēchiirēk kubo lōkōōywēk chēē kinyōōr. Kikas leekweet kuu wōloo /kikēēmwooytoochinē. ");
INSERT INTO spyNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nto mii bēsyēētaab sisiit kung'eetee /kākēēsich lakwanaa, /keeyey saakweet nyēē */kikiimurootānēē /ānkēētoochinēē kaayneet. Yu /kaakiimuraatan /kēētoochi kaayneet kule Yēēsu, kaaynaanaa kisimkutoochinē *꞉malayikeet /kumanaakeemanach. ");
INSERT INTO spyNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","/Kikeesir ām kiruutēkaab Yēyiin choo kikōōnu *꞉Muusa kule ibuurē ꞉koorko nyēē kāsich wēēro bēsyōōsyēk artam nto /kēēlābchinē. Nto yoo /sikēēlābchi, kimāchāktōōs kuwēētooy chēēbtuukēēnik āyēēng' chēē wōōyēch nto āyēēng' chēē minkēēch /bokēēyēchinēē ntāsimuutēk. /Kikeesir mbo subak kule, leekwa ake tukul nyēē /kākēēsich nyēē kibooreetyeet ānku wēēro, /kiitāboonē nyoo kubo yiisyēētaab Yēyiin. Kunyoo, yu kikiikukeeyta ꞉bēsyōōsyēchoo bo tōmōnoontiit, kuwēēto keey ꞉Maaryaa Yōōsēēf kuboontootē leekweet Yēēsu. Kiba ākoy *Kōōtaab Yēyiin nyēē kimii Yēērusālēēm. Kimāchē /bokēēyēchi ntāsimuutēk ām wōlooto kuu wōloo mwooytooy ꞉kiruutēk ānkubokōōkooyto Yēēsu kubo yiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kimii ꞉chiito ake Yēērusālēēm nyēē /kikēēkuurēē Simiyōōn nyēē ki lēēl ꞉moo ankichamaat ng'ālyoontēētaab Yēyiin miisin. /Kikikiinyiityi Tāmirmiryēētaab Yēyiin ānkikānyoonu *Kāārārookiintēēt kuchō. ");
INSERT INTO spyNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kikiikōōboorchi ꞉Tāmirmiryēētaab Yēyiin kule kumanaame ꞉inee, makukas Kāārārookiintēēt nyoo mākōōyook ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kikiikōōrēētoot ꞉Tāmirmiryēētaab Yēyiin bēsyoonooto Simiyōōn kuwo *Kōōtaab Yēyiin. Kuyitē ꞉Yōōsēēf āk Maaryaa wōlooto, ");
INSERT INTO spyNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","kunāmē ꞉Simiyōōn leekweet ankookaasta Yēyiin kule, ");
INSERT INTO spyNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","“Bāytooyiintēēnyuu Yēyiin, yoo kaameey ra, māmii ng'ālyoo, kuuyu kaakas leekweet kuu yoo 'kwēēmwoowu. Kaakas *Kāārārookiintēētaab kōōrēēt nyoo 'kiikuurtoowēēch kukāsē ꞉biiko tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mākuyēk lēbkēēyyēētaab bōrōryōōsyēk tukul ankuyey /kēēkoonyit biikaab *Isrāyēēl tukul.” ");
INSERT INTO spyNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kiiyyo ꞉Yōōsēēf ākoo Maaryaa yooto kōōlātē kiyēē kimii ꞉Simiyōōn kumwooyē kurubta keey Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kōōbēruur ꞉Simiyōōn icheek tukwaay ānkumwoochi Maaryaa kule, “Makuyey ꞉lakwani /kiiraraach biikaab Isrāyēēl alak nto alak mākubootyo. Mākōōboor kāāmuukēywēēkaab Yēyiin ām Isrāyēēl, nteenee makukwiil ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yooto, mākōōboor keey ꞉miyootyēēt nyēē kiwung'ta keey ꞉bichoo. Mākung'woonchiing' ꞉ng'aleechaa miisin kukerkeyiit nyēē /kākēērutēēniing' chōōkiit kubun.” ");
INSERT INTO spyNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kimii ꞉nkinee cheebyoosyeet ake *Kōōtaab Yēyiin bēsyoonooto nyēē /kikēēkuurēē Ana. Kikiikuyoosiit miisin ānki *wōōrkooyoo nyēbo Yēyiin. Ki lakwataab boontēēt ake nyēē /kikēēkuurēē Fānwēēl nyēē kibo kōōtaab Asyeer. Kiming'to keey saanteenyii kēnyiisyēk tisab nto yityo kume ꞉saanteet. ");
INSERT INTO spyNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kōōbuur ku musuk ākoy yēē kiboonto kēnyiisyēk tāmānwookik sisiit āk ang'wan. Kiwēētii ꞉cheebyoosyaanaa Kōōtaab Yēyiin ku tēē yooto tukul wokukutunkyinē Yēyiin bēēt nto kwēēmooy ānkukirē āmiik kibtaman. ");
INSERT INTO spyNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kiwo ꞉cheebyoosyaanaa yoo king'āloolchinēē ꞉Simiyōōn Maaryaa ākoo Yōōsēēf. Kubirchi ꞉nkinee Yēyiin kōōnkōy ānkumwoochi chii ake tukul nyēē kimii kukānyoonu kooraraach ꞉Yēyiin Yēērusālēēm kule, “Kaakuyit *꞉Kāārārookiintēēt!” ");
INSERT INTO spyNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yu /kāākēēyēchi ntāsimuutēchoo kuu wōloo māktooy ꞉kiruutēkaab Yēyiin, kooyeey ꞉Yōōsēēf āk Maaryaa *kiriinkēēng'waa Nāāsārēēt ām yēēmēētaab Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kineree ꞉Yēēsu wōlooto kut kukich. /Kikiibēruur /ānkiikoochi kiirnātēēt nyēē wōō. ");
INSERT INTO spyNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ām kēnyiit ake tukul, kibēētii sikiikaab Yēēsu Yēērusālēēm bokwoomē *Saakweetaab Keeytaayeet. ");
INSERT INTO spyNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yu kiboonto ꞉Yēēsu kēnyiisyēk taman āk āyēēng', /keebeeta saakwaanaa. ");
INSERT INTO spyNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yu kābēk ꞉saakweet, kung'ēētyo ꞉sikiikyii kooyeey kaa. Nteenee king'ētunēē ꞉Yēēsu Yēērusālēēm kumēēnkētē ꞉sikiik. ");
INSERT INTO spyNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kibērē ꞉sikiik tōōs tākuboontoonu keey ꞉inee chōōrōōnuutēkyii nto tilyōōnuutēk. Nto mii kosolēny, wokucheeng'aatee ꞉kwaan āk kaamet wōlēē mii ꞉chōōrōōnuutēk āk tilyōōnuutēk, ");
INSERT INTO spyNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","nteenee mānāānyōōr. Kooyeey yu kāyyēēkunēē ākoy Yēērusālēēm bokucheeng'aat. ");
INSERT INTO spyNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nto mii bēsyēētaab sōmōk bokunyōōr kumii kiirwookēētaab kāānēētikaab kiruutēk ām *Kōōtaab Yēyiin kukāsē kiyēē /kikēēmwooyē ānkukiirē ng'al. ");
INSERT INTO spyNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kiilat ꞉chii ake tukul nyēē kikāsē kiirnātēēt nyēē kiboonto ꞉Yēēsu āk wōlēē kiwāluntooy kiyēē /kikēētēēbēē. ");
INSERT INTO spyNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kinam kuut kwaan āk kaamet. Kulēēnchi ꞉kaamet, “Baaba, ng'ālyoo nee ꞉nyi 'kēēyēwēēch! Ntēē siikōōnēēch keeluyaatee wōli tukul?” ");
INSERT INTO spyNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kukētyi ꞉Yēēsu kule, “Ām ꞉nee soocheeng'aateenaa wōloo tukul? ‑Mōōnkētē ꞉akweek kule māchāktōōs āmiitē ꞉anii kōyi bo Baaba āyēyē ng'aleek chēē mākwoo ꞉Baaba?” ");
INSERT INTO spyNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","51","Mānēēnkēt ꞉sikiik kiyēē kiibooru ꞉ng'aleechaa kimwooyē ꞉Yēēsu, nteenee kinamtaat ꞉Maaryaa mēt. Kicham ꞉Yēēsu kuwēēto keey kwaan āk kaamet. Kiwokukoonyit sikiikyii. ");
INSERT INTO spyNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yooto tukul kumii kunērē ꞉Yēēsu, kutāsyinē keey ꞉ng'oomnānēēnyii ānkuchāmē ꞉Yēyiin āk biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ki kēnyiitaab taman āk muut kubāytooy ꞉Tibēēryō kōōrēētaab Rooma kumukuul. Ām bēsyōōsyēchooto, kibāytooy ꞉Bōōntyō *Bilaato yēēmēētaab Yuuteeya, kubāytooy *꞉Ērōōtē Antibaas yēēmēētaab Kalilaaya, nto ng'eetaabkaamet Filibō, kubāytooy ꞉nyoo yēēmōōsyēk āyēēng': nyēbo Itureeya ākoo nyēbo Traakoniit. Kibāytooy ꞉Lusaannya yēēmēētaab Abileen. ");
INSERT INTO spyNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nto mbo *kibkōrōs chēē wōōyēch ām bēsyōōsyēchooto ku *Anaas ākoo *Kayaafa. Ki yooto mbo yēē kiiyookyinē ꞉Yēyiin Yoowaana Araab Sekaryaa lōkōōywēk kumii suurkwēēn. ");
INSERT INTO spyNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kunyoo, kyaamtaatee ꞉Yoowaana lōkōōywēk biitōōsyēk tukwaay chēbo āynēētaab Yoortaan kumwoochinootē biiko kuweeksee miyootyēēt nyoo kiikuyey /ankeebatisan sukunyōōchi ꞉Yēyiin kaat. ");
INSERT INTO spyNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kiityiich kuu yoo siraat ām kitaabuutaab *wōōrkooyoontēētaab Yēyiin *Isaaya kule, “Miitē ꞉chiito ake kukuuru ām kōōr nyēē suurkwēēn kule, ‘Oyeyte keey, ānkōōbāroochi Mokoryoontēēt kēēlto. ");
INSERT INTO spyNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","/Keeyeb tulōōntōōk /ānkēēsisinēē tuybēyōōsyēk. /Keechuul kēēlwookik choo moosootiin /ānkiirōōr choo sing'iirēch. ");
INSERT INTO spyNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Māchāktōōs ꞉biiko tukul kōōnkētē kule māchē ꞉Yēyiin kooraraach icheek.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kimwoochi ꞉Yoowaana biiko chēē kimāchē /keebatisan kule, “Ng'oomng'ookichu! Ng'oo ꞉nyēē kāmwoowook ōmwēyēē ng'woonintaab Yēyiin nyoo mākuchōōnchook? ");
INSERT INTO spyNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ōboorunēē yēyuutēkwook kule kooweeksee miyootyēēt, āmōōkwērtē keey ōmwooyē kule, ‘Ntēē kēēbooyē Abraam.’ Āmwoowook man kule imuuchē ꞉Yēyiin kuyey rwoontōōchu kuyēk lōkōkaab *Abraam. ");
INSERT INTO spyNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Itōrōōroot ꞉āywēēt. Kunyi, keet ake tukul nyoo kamayey lokoyeek chēē kāroomēch, /kiiluultooy /ānkēētōōrchi ma.” ");
INSERT INTO spyNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kuteebee ꞉biiko Yoowaana kule, “Kiy nee ꞉nyēē +mākiiboorunēē kule kookeebakaakte miyootyēēt?” ");
INSERT INTO spyNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kumwoochi ꞉Yoowaana kule, “Yoo boonto ꞉chii sirooy āyēēng', kubchēchi nyoo mātinyē sira. Nyoo boonto āmiik, kubchēchi nkinee nyoo mātinyē.” ");
INSERT INTO spyNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kikwa ꞉nkicheek kāāruruukikaab *syuuruut kumāchē kule /keebatisan ānkumwoochi Yoowaana kule, “Kāānēētiintēēt! Nto nkacheek, mākwēēch kule kēēyēyē nee?” ");
INSERT INTO spyNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kukētyi ꞉Yoowaana kule, “Boosaan ōtāsyinē laatit ake barak ām syuuruut nyoo /kikiitiilwook kule ōruruuchēē biiko.” ");
INSERT INTO spyNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kukwa ꞉nkicheek chēē riibē tāloosyēēt ankuteebee kule, “Nto nkacheek, mākwēēch keeyey nee?” Kukētyi ꞉Yoowaana kule, “‑Mōō-āmchi chii ng'ōōki ām kiyēē manaayey, āmōōsāsunēē chii tukuukyii. Oteeree beesaanik choo /kēēkwēwook ām yiisyēēng'woong'.” ");
INSERT INTO spyNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kikānyoonu ꞉chii ake tukul kuyit *꞉Kāārārookiintēēt ām lēēkitō. Kyoomē mēt kumwooyē kule, “Ara nyuun Kāārārookiintēēt ku Yoowaana?” ");
INSERT INTO spyNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kumwooy ꞉Yoowaana kule, “Ābātisānēēnook ꞉anii bēēko baateey, nteenee mākuchō ꞉chiito nyēē boonto kāāmuukēywēēk kubiira, nyēē ‑māāyēmē mbo ārēēkyi kwēyōōnik. +Machokubatisaneenaak ꞉inee Tāmirmiryēētaab Yēyiin āk maata. ");
INSERT INTO spyNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Machokuseesta mōōrōryēēk kung'ēt ꞉nkoonuuk ankubeelee mōōrōryēēchoo maataab kibchuulyo. Nto nkoonuuk, kukonoree choo chookē.” ");
INSERT INTO spyNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kitas taay ꞉Yoowaana kwoomchinē biiko lōkōōywēk chēē kāroomēch ānkōōkāloonchinē kutayee keey ng'ōōki. ");
INSERT INTO spyNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kiiburyoong'to ꞉Yoowaana Bāytooyiintēēt *Ērōōtē kuuyu kyoobuch ng'eetaabkaamet kōōnēmunēē koorkēēnyii Erootyaa. Kiiburyoong'to mbo subak kubo ng'al alak chēē chaang' chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yooto, kunam ꞉Ērōōtē ankukerta kō. Kiinyikiis ꞉ng'ālyoontooni miyootyēētaab Ērōōtē miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yu kitākubātisāniisyootē ꞉Yoowaana, kuchō ꞉nkinee Yēēsu /ankeebatisan. Nto kumii ꞉Yēēsu kusooyē Yēyiin, kuyaatakay ꞉kibkōōnkōy ");
INSERT INTO spyNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ānkurēkyi ꞉Tāmirmiryēētaab Yēyiin nyēē wuu chēēbtuukē. Kukuur ꞉Yēyiin ām barak kule, “Inyiing' lakwanyuu nyēē āchāmē ānkāāng'ērēkyinē.” ");
INSERT INTO spyNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kitinyē ꞉Yēēsu kēnyiisyēk chēē kimāchē kukēēytēē sosom kutoowu yiisyēēnyii. Kikuurē ꞉biiko Yēēsu kule araab Yōōsēēf ānkoo kimābo Yōōsēēf. Kichōōnēē kōōtaab Ēēli. ");
INSERT INTO spyNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ēēli nyoo ki araab Maatat. Maatat araab Laawi, Laawi nyoo ki araab Mēlki, Mēlki nyoo kibo Yanaay, Yanaay nyoo ki araab Yōōsēēf. ");
INSERT INTO spyNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yōōsēēf araab Matatyaa nyoo ki araab Āmōōs. Kibo ꞉Āmōōs Nāwuum nyoo ki araab Ēsli, Ēsli araab Nakaay. ");
INSERT INTO spyNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakaay araab Mayaat nyoo ki araab Matatyaa araab Sēmēyiin nyoo kibo Yōōsēk. Kibo ꞉Yōōsēk Yoota ");
INSERT INTO spyNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","nyoo ki araab Yowanaan nyoo ki araab Reesa, nyoo kibo Sērubābēēl, araab Syeeltyeel nyoo kibo Nēēri. ");
INSERT INTO spyNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Kibo ꞉Nēēri Mēlki, nyoo ki araab Aati, nyoo kibo Koosam araab ");
INSERT INTO spyNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eer nyoo kibo Chooswa araab Elyeeser, nyoo kibo Yōōriim, nyoo ki araab Maatat. Kibo ꞉Maatat Laawi, ");
INSERT INTO spyNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","nyoo ki araab Simiyōōn nyoo kibo Yuuta, Yuuta araab Yōōsēēf nyoo kibo Yoonam araab Elyaakim. ");
INSERT INTO spyNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyaakim araab Meleeya nyoo kibo Meena, Meena nyoo ki araab Mataata. Kibo ꞉Mataata Naasan, nyoo ki araab Tāwuti. ");
INSERT INTO spyNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tāwuti nyoo kibo Yēēsē araab Ōbēēt nyoo ki kwaan ku Boowaas, Boowaas araab Sālmōōn nyoo kibo Nāāsyōōn, ");
INSERT INTO spyNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nyoo ki araab Aminataab, nyoo ki araab Raam nyoo ki araab Ēsrōōn nyoo ki kwaan ku Bērēēs, nyoo kibo Yuuta. ");
INSERT INTO spyNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Kibo ꞉Yuuta Yāākōbō nyoo ki araab Isaka nyoo kibo *Abraam araab Teera. Kibo ꞉Teera Nayoor, ");
INSERT INTO spyNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nyoo ki araab Sēruk, Sēruk araab Rēēwu nyoo kibo Belek nyoo ki kwaan ku Eber araab Syeela. ");
INSERT INTO spyNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kibo ꞉Syeela Kaynaan nyoo ki araab Arfaksaat, araab Syēēm, nyoo kibo Noowa. Kwaaniitaab Noowa ku Lameek, ");
INSERT INTO spyNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","nyoo ki araab Metuseela araab Enok nyoo kibo Chāārēēt araab Maalaleel nyoo kibo Kaynaan. ");
INSERT INTO spyNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kibo ꞉Kaynaan Ēnōs nyoo ki araab Sēēt. Kibo ꞉Sēēt Aatam, nyoo kiyēyē ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yu /kābokiinyiityi Yēēsu Tāmirmiryēētaab Yēyiin, kung'eetee komosaa kibo āynēētaab Yoortaan ānkōōrēētoot ꞉Tāmirmiryoonoo ākoy suurkwēēn. ");
INSERT INTO spyNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kiibuur wōlooto bēsyōōsyēk artam kukirē āmiisyēēt. Yu kābēk ꞉bēsyōōsyēchoo artamu, kwaam ꞉kēmēwuut miisin. Kutākumii ꞉Yēēsu wōlooto, kuchōōnchi *꞉Kēniintēēt kumāchē kutyem. ");
INSERT INTO spyNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kimwoochi kule, “Yoo inyiing' man ku Lakwataab Yēyiin ii, imwoochi rwaantaani kuyēk āmnyoontēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kukētyi ꞉Yēēsu kule, “Ntēē mwooyē ꞉siruutēkaab Yēyiin kule, ‘Māsobēē ꞉chiito āmit baateey.’” ");
INSERT INTO spyNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kuwēēto ꞉Kēniintēēt Yēēsu ākoy lekemeet ake barak ānkung'oonkyi kukas kiriinkōōsyēk tukul ām kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Kumwoochi Yēēsu kule, “Yoo 'kēēkutung'woo, +māākōōniing' kāāmuukēywēēk ibayte kiriinkōōsyēchuut tukul kāroorānēch kut kōōtēnytēēnyē, kuuyu anii ꞉nyēē āboontē kāāmuukēywēēk ākoochi chii ake tukul nyoo kaacham.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kukētyi ꞉Yēēsu kule, “Ntēē mwooyē ꞉siruutēkaab Yēyiin kule māchāktōōs /kēēkutunkyinē Yēyiin /ānkiiywēyē inee nkit.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nto mii yoo, kuwēēto subak ꞉Kēniintoonoo Yēēsu ākoy Yēērusālēēm ānkōōkoochi kōōyyoonyēē yēē kotootyēēt ām barakuutaab tōōtēētaab *Kōōtaab Yēyiin. Yooto, kumwoochi ꞉Kēniintēēt kule, “Yoo inyiing' man Lakwataab Yēyiin ii, iraantee baa, yuutēyu ");
INSERT INTO spyNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kuuyu mwooyē ꞉siruutēkaab Yēyiin kule, ‘Mākōōyook ꞉Yēyiin malayikaanikyii bokuriibing'. ");
INSERT INTO spyNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Makutaaching' malayikaanichaa ānkōōrēētootiing' simeenachiing' ꞉rwaa.’” ");
INSERT INTO spyNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kukētyi ꞉Yēēsu kule, “Mwooyē ꞉siruutēkaab Yēyiin kule, ‘‑Meetyem Yēyiintēēng'uung'.’” ");
INSERT INTO spyNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Yu kaakutyem ꞉Kibrōkōsyoontēēt Yēēsu, kubakaakta ānkuwēēchi keey ākoy bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yu kāwokunyōōr ꞉Yēēsu kāāmuukēywēēkaab Tāmirmiryēēt, kooyeey yēēmēētaab Kalilaaya ankuyey tukuuk chēē chaang' chēē /kiilātē. Kitookunēē ꞉kaayneenyii yēēmoonooto tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kiikoostooy ꞉chii ake tukul wōlēē kiinēētitooy ām *kooriikaab saayeet. ");
INSERT INTO spyNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nto mii yoo, kooyeey ꞉Yēēsu Nāāsārēēt wōloo kinērēē. Nto mii bēsyēētaab *Sabaato, kōōwut *kōōtaab saayeet kuu kwaak. Kumii kō, kung'eet kumāchē kusuman ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","/Kiiyokoochi lōkōōywēk chēē kisir ꞉wōōrkooyoontēētaab Yēyiin *Isaaya. Kung'aany yēē kimāchē ankusuman kule, ");
INSERT INTO spyNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Āboontē Tāmirmiryēētaab Yēyiin, kuuyu kikweya ꞉Yēyiin ā-āmchinootē bānoonik lōkōōywēk chēē kāroomēch. Kiiyookwoo ꞉Yēyiin chāāmwoochi biiko kule +/makiityaakta choo rātootiin ām choolwookātēēt. Nto choo kōryootiin, +/mākēēng'oonkyi koonyek kukasta. Nto choo kiikōōtiiny ꞉biiko alake ām bāytooyiisyēēt, mākubāw keey. ");
INSERT INTO spyNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kiiyookwoo ꞉Yēyiin chāāmwoochi biiko kule bēsyōōsyēk ꞉chu chēē makuchamee ꞉Yēyiin icheek.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yu keewaany ꞉Yēēsu kusuman siruutēchoo, kukētyi chiito nyēē kiiyyoonkyinē saayeet ānkōōbuur ng'wēny sukoobanybaany ng'aleechaa. Kiirōōtoot ꞉biiko tukul Yēēsu miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kimwoochi bichoo kule, “Kāākuyityiin ꞉bēsyooni āk kiyēē mwooyē ꞉siruutēchu.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","King'ērēkyi ꞉biiko tukul chēē kimii yooto Yēēsu ankoolat miisin ām wōlēē king'ālooltooy, kuuyu ki kāroomēch ꞉ng'aleekyii. Nteenee kimwooy ꞉biiko alake kule, “Māchē ꞉chiichi kumwooy kule inee ku *Kāārārookiintēēt? Acha ēē, wē, ntēē araab Yōōsēēf.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kukētyi ꞉Yēēsu kule, “Ānkēt kule ōmuuchē ōmwoowoo ng'ālyoontoonoo kimwooy ꞉booyoo nyēbo kēny kule, ‘Isoob keey kurook ꞉kāānyooyiintēēt.’ Ōmiitē ōmwooyē kule ntēē ‑māāyēyē ꞉anii ng'al chēbo kwōng'uut ām saang'nyuu kuu yoo kyāāyēyē ām Kaabernaam. ");
INSERT INTO spyNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","!Kāāmwoowook, ‑/mākēēchāmē *wōōrkooyoontēētaab Yēyiin ām saang'nyii.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Kumwoochi ꞉Yēēsu subak kule, “Osoot yoo kiyēyē ꞉Yēyiin kuwo ꞉roobta kēnyiisyēk sōmōk āk ārook lo. Kichō ꞉kēmēwuut kōōrēēt /ānkiiyookto wōōrkooyoontēētaab Yēyiin *Eliiya kuwo ākoy *kiriinkēēt ake nyēē /kikēēkuurēē Sarefaat ām kōōrēētaab Sitōōn wōlēē kimii ꞉koorko nyēē ki musuk nyēē mēēbērē ki Cheebyuutayaa. Ntēē kimii naas, ꞉kooruuk alake chēē chaang' chēē ki Cheebyuutayiis āmēēbērē /kikiiyookto Eliiya kuwēēchi icheek? ");
INSERT INTO spyNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Okas, baa, mbo yoo kiisoobē ꞉wōōrkooyoontēētaab Yēyiin Eliisya Naaman nyoo kikinam *꞉makereenik ānkibo kōōrēētaab Siirya. Ntēē kimii ꞉biiko chēē chaang' chēē ki Yuutayeek chēē kiboonto makereenik āmēēbērē /kikiisoob?” ");
INSERT INTO spyNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","King'woonchi ꞉ng'aleechaa bichoo ām kōyooto bo saayeet. ");
INSERT INTO spyNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kung'ēētyo ānkukwēryoot Yēēsu kumāchē kule wokuwunuktēē kēēbēēryēēt ake nyēē kilēēkitēē yooto. ");
INSERT INTO spyNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nteenee kibotēē ꞉Yēēsu yooto ānkuwēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kiwēēchi keey ākoy Kaabernaam. Kyoomchi biiko ng'ālyoontēētaab Yēyiin ām *kōōtaab saayeet yēē ki bēsyēētaab *Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kiilat ꞉biiko ām wōlēē kiinēētitooy ꞉Yēēsu, kuuyu king'āloolē ām kāāmuukēywēēk. ");
INSERT INTO spyNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kimii ꞉chiito ake kōyooto nyēē kiiyiimē *꞉tāmirmiryēēt nyēē miyaat. Kubōlchi Yēēsu ꞉tāmirmiryoonoo kule, ");
INSERT INTO spyNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ō! Yēēsu nyēbo Nāāsārēēt, imāchēēnēēch nee? Imāchē iwaang'teech? Ntēē ānkētiing' ꞉anii. Inyiing' nyoo ichurtaat ānkiichōōnēē Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kōōburyoong'to ꞉Yēēsu tāmirmiryoonoo kule, “Siis ankiichuwunee chiichi.” Kōōryookyinē ꞉tāmirmiryoonoo miyaat chiichoo ng'wēny kukāsē ꞉biiko tukul ānkuchuwu nyēē manaayeyee chiichoo kiy. ");
INSERT INTO spyNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kiilat ꞉biiko tukul ankuteebee keey kule, “Ng'al nee ꞉chu! Ntēē boonto ꞉chiichi kāāmuukēywēēk chēē ibēbēētēē tāmirmirook chēē miyootēch ānkukāsyi?” ");
INSERT INTO spyNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kiisambaakta ꞉ng'aleechaa kut kuyit yēēmoonooto tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yu kang'eetee ꞉Yēēsu *kōōtaab saayeet bēsyoonooto, kuwo ākoy kaab Simōōni. Kiimnyoonē cheebyoosyeetaab biikooy bo Simōōni miisin. /Keesaaysaay Yēēsu kule, “Isoob cheebyoosyaani.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wokōōyyoonyēē ꞉Yēēsu yēē kimii ꞉cheebyoosyeet ānkōōbēbēēto bōōrto. Kusob ꞉cheebyoosyaanaa areet akeenke ānkubāyiis. ");
INSERT INTO spyNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yu kararakta ꞉asiista bēsyoonooto kukāākubēk ꞉āsiiswēkaab *Sabaato, kōōmutyi ꞉biiko Yēēsu biiko chēē chaang' chēē kitinyē bōōrwoonik chēē makerkeey. Yu kātiinyēē ꞉Yēēsu bichoo āwunnyēk, kusobcho. ");
INSERT INTO spyNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kiibēbēētooy mbo tāmirmirook chēē miyootēch chēē chaang' chēē kiiyiimē biiko. Yu chuwu ꞉tāmirmiroochoo, kuwookyinē barak kumwoochinē Yēēsu kule, “Inyiing' ku Lakwataab Yēyiin!” Nteenee kuuyu kiinkētē ꞉tāmirmiroochoo miyootēch kule *Kāārārookiintēēt ꞉Yēēsu, kibōlchinē ꞉Yēēsu kusiisyo. ");
INSERT INTO spyNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yu kāyyēēkunēē, kuwēēchi keey ꞉Yēēsu wōlēē kimālēēkitēē ꞉chii. Kicheeng'aat ꞉biiko ām wōlto ake tukul. Nto yu /kābokēēnyōōr, /keesaaysaay kule tākōōbuur kiriinkoonooto bo Kaabernaam. ");
INSERT INTO spyNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nteenee kumwoochi ꞉Yēēsu kule, “Māchāktōōs āwē kiriinkōōsyēk alak waa-amtaate lōkōōywēk chēē kāroomēch chēbo Bāytooyiisyēētaab Yēyiin, kuuyu chooto ꞉chēē kiyey /kiiyookwoo āchōō kōōrooni.” ");
INSERT INTO spyNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kutas taay ꞉Yēēsu kwoomchinoot biiko ng'ālyoontēētaab Yēyiin ām kooriikaab saayeet ām kōōrēētaab Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nto mii bēsyēēt ake, kumii ꞉Yēēsu kwoomchinē biiko ng'ālyoontēētaab Yēyiin ām sakaramteetaab Tōōliilēētaab Keneesareet, kōōruruukyi keey ꞉biiko chēē chaang'. Kiwunuk keey ꞉bichoo kut kuriich Yēēsu miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yooto, kukas ꞉Yēēsu mwēēnkōōsyēk alak āyēēng' chēē /kikiiyyoong'tēē tōōliil taban. Kimii ꞉biikaab mwēēnkōōsyēchoo kōōwuunē ānkuyēytooy nēētiinēk ām mwēēnkōōsyēchooto taban. ");
INSERT INTO spyNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yu kakas ꞉Yēēsu bichooto, kukuur nyēē /kikēēkuurēē Simōōni nyi ki nyeenyii ꞉mwēēnkēēt ake. Kulaany ꞉Yēēsu mwēēnkoonoo ānkumwoochi Simōōni kuwunukto takoonaata kisich kuwo bēēko sukunyōōr ꞉inee bārooyinto nyēē koomchinēē biiko ng'ālyoontēētaab Yēyiin. Kiwunukto mbo ꞉Simōōni mwēēnkoonooto ankulaany ꞉nkicheek āriit. Kōōbuur ꞉Yēēsu ng'wēny ām mwēēnkoonoo ānkwoomchi biiko ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yu keewaany kumwoochi Simōōni kule, “Obe, baa, yuun chaang' bēēko bōōwiirchi nēētiinēk bēēko onam *burburiinēk.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kukētyi ꞉Simōōni kule, “Mokoryoontēēt, kokyaam booryēēt kuyyeech āmākēēnāmē kiy mbo kisich. Nteenee kuuyu 'keemwaay, +makeesyeem.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nto bērē kusyeem, kunam burburiinēk chēē chaang' miisin kut wuu nyēē mākung'ētyo ꞉nēētiinēk. ");
INSERT INTO spyNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yu kakas ꞉Simōōni kuu nyooto, kukuurēē āwut chōōrōōnuutēkwaa chēē kināmiisyootē tukul bokuyēētyēēchi kukālāb burburiinēchoo. Kubeeta ꞉choo mwēēnkēēng'waa. /Kikiinēm burburiinēk chēē kiinyiit mwēēnkōōsyēk tukwaay kut wuu nyēē makuling'ta. ");
INSERT INTO spyNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yu kēēnkēt ꞉Simōōni kiyēē kaakuyeyakay, kukutunyēē taayeetaab Yēēsu ānkumwoochi kule, “Ibakaaktaa ōō, mokoryoontēēt, ntēē ākoo āchoolwookēnoot nyēē mēērooko mbo ālēēkitēēniing'.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kimwooy ꞉Simōōni kuu nyooto, kuuyu kiilat ꞉inee miisin āk biiko choo kiboonto keey ām burburiinēk chēē kinam. ");
INSERT INTO spyNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kiilat ꞉nkicheek Yāākōbō ākoo Yoowaana wērichoo kibo Sebetaayo, choo kiyēyiisyootē āk Simōōni. Kumwoochi ꞉Yēēsu Simōōni kule, “‑Mēēmuy! Kāmēētēēnāmootē burburiinēk kung'eetee raat ānkuwo taay, nteenee +mēēyisunootē biiko.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yu /kāākēēmwoochi kuu nyooto, kukwaanee mwēēnkōōsyēkwaa ākoy sakaramteet ānkubākookyi tukuuk tukul yooto sukuyēk rubiikaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nto mii bēsyēēt ake, kuruutoochi ꞉Yēēsu *kiriinkēēt ake. Kichō ꞉chiito ake nyēē kiboonto *makereenik. Yu kakas ꞉chiichoo Yēēsu, kōōryookyi keey ng'wēny ānkumwoochi kule, “Mokoryoontēēt! Ānkētē kule 'imuuchē isooboo. Kunyoo, yoo ichāmē, itiliiloo ām bōōri.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kuchuul ꞉Yēēsu āwunyii kutiiny chiichoo ānkumwoochi kule, “Āchāmē! Kunyi, itililiitu.” Yu kāmwooy ꞉Yēēsu kuu nyooto, kusob ꞉chiichoo areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yu kāākusob, kōōkiimchi ꞉Yēēsu kule, “‑Mēēmwoochi chii ng'aleechu, nteenee wēēboorchi keey kibkōrōs sukuyēwuung' kōrōsēēk kuu yoo kimwooyē *꞉Muusa ām kiruutēk, siitooku ām taayeetaab biiko kule 'kēētililiitu.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nteenee /kikiibaraastaat ng'aleechaa miisin kuyit komoswookik tukul chēbo kōōroonooto. Yu kakas ꞉biiko ng'aleechaa, kuwoolchi Yēēsu bokuyēbchi yiit /ānkiisoob. ");
INSERT INTO spyNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kichāmē ꞉Yēēsu kuwēētii wōlēē mālēēkitēē ꞉chii wokusooyē. ");
INSERT INTO spyNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nto mii bēsyēēt ake, kumii ꞉Yēēsu kōōnēētiisyē, kimii *꞉Farisaayeek alake ākoo kāānēētikaab kiruutēk yooto. Kikwoonēē ꞉bichoo Yēērusālēēm ākoo saang'ta ake tukul ām yēēmēētaab Kalilaaya ākoo yēēmēētaab Yuuteeya. Kiyēyiisyēē ꞉Yēēsu kāāmuukēywēēk kukwaanee wōlēē mii Yēyiin kōōsoobēē biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yooto, kuyit ꞉biiko alake chēē kiimutu chiito ake nyēē kisōnkōchoot kukālāboonunēē tiirbeet. Kisyeem ꞉bichoo kule kubilbil biiko choo kikiiruruukyi keey yooto sukunyōōr Yēēsu, ");
INSERT INTO spyNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","nteenee maneemuuch. Kunyoo, kulaany kōōto barak ānkubut tukuuk chēē /kikeesyebee kutook ꞉koong'ta nyēē kēēyokooytēē chiichoo kumii tiirbeet ākoy yēē kimii ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yu kēēnkēt ꞉Yēēsu kule kēēkoosēē keey inee ꞉bichoo, kumwoochi chiichoo kisōnkōchoot kule, “Wēnyoo, /kākēēnyōōwuung' kaat ām choolwookātēēng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kukāsē ꞉Farisaayeechaa ākoo ꞉kāānēētichoo bo kiruutēk kuu nyooto, kumwaayee moo kule, “Yibē keey ꞉chiichi kule inee ku ng'oo ēē? Bērē tōōs inee ku Yēyiin? Ng'oo ꞉ake nyēē imuuchē kunyōōchi biiko kaat ām choolwookātēēt yoo mā Yēyiin nkit?” ");
INSERT INTO spyNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kiinkētē ꞉Yēēsu kiyēē kimii ꞉bichoo kōōsōōtē. Yooto, kuteebee kule, “Ām nee soosoot ꞉akweek kuu nyooto? ");
INSERT INTO spyNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nkōnō ꞉nyēē kuskus, āmwoochi chiichi kule, ‘/Kākēēnyōōwuung' kaat,’ nto āmwoochi kule, ‘Ng'eet, ānkiiwēēsyēt’? ");
INSERT INTO spyNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ōkāsē ra kule āboontē anii, *Wēritaab Chii, kāāmuukēy ām kōōrooni ānyōōchi biiko kaat ām choolwookātēēt.” Yooto, kumwoochi chiichoo kisōnkōchoot kule, “Yyoony ankiinam tiirbeeng'uung' ānkiiwēēchi keey kaa.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kung'eet ꞉chiichoo areet akeenke kukāsē ꞉biiko tukul ankunam tiirbeenyii ānkuwēēchi keey kaa. Kiikaastaat ꞉chiichoo Yēyiin miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kiilat ꞉chii ake tukul nyēē kimii yooto ānkumuy miisin. Nto tēē yoo, kookaastaat Yēyiin kut kōōyēēchinē kumwooyē kule, “Kaakeekas ra ng'ālyoo nyēē ‑/mākyoomu.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kumii ꞉Yēēsu ākoo rubiikyii kung'ēētyēē kiriinkoonooto, kukas chiito ake nyēē /kikēēkuurēē Laawi kumii kēryō kōōruruuchē *syuuruut. Kumwoochi ꞉Yēēsu chiichoo kule, “Irubwaa!” ");
INSERT INTO spyNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kubākooktooy ꞉nyoo kāāruruukiisyoonoo bo syuuruut ānkurubē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nto yityo kumwoochi ꞉Laawi Yēēsu kule kuruutoochi ām kanyii. Kucham ꞉Yēēsu. Yu kayit ꞉Yēēsu ākoo rubiikyii kaab Laawi, kuyēchi ꞉Laawi saakweet. Kimii nkicheek ꞉kāāruruukikaab *syuuruut alake yooto ākoo tāyēēk alak chēē kyoomiis ākoo Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nteenee kiing'unyng'uunkyi *꞉Farisaayeek āk kāānēētikaab kiruutēk rubiikaab Yēēsu kule, “Ntēē ō-āmchiintōōsii āk kāāruruukichu bo syuuruut ākoo mbo alak chēē ‑/mākiiriiku!” ");
INSERT INTO spyNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kukētyi ꞉Yēēsu kule, “Chēēng'ootē ꞉biiko choo imnyoontōōs kāānyooyiintēēt āmēēbērē chēēng'ootē ꞉choo sobchootiin. ");
INSERT INTO spyNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kichāākuurē ꞉anii biiko choo choolwookēnootiin āmā choo isōōtē kule churtootiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nto mii yoo, kōōng'unyng'uunyiis ꞉biiko alake kumwoochinē Yēēsu kule, “Ntēē *kirē ꞉rubiikaab Bātisāniintēēt Yoowaana ākoo chēbo Farisaayeek āmiisyēēt ānkusooyē āmākirē ꞉cheekuuk?” ");
INSERT INTO spyNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kukētyi ꞉Yēēsu kule, “‑Mēērukuutē keey ꞉chōōrōōnuutēkaab saanteetaab leekwa ām saakweetaab kooyēēy yoo boonto keey saanteet. ");
INSERT INTO spyNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nteenee yitu ꞉bēsyēēt nyēē +/mākiinēmunēē saantaanaa wōlēē mii ꞉chōōrōōnuutēkyii. Yooto nanyuun ꞉yēē makoorukuut keey ꞉chōōrōōnuutēkyii.” ");
INSERT INTO spyNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kōōboorchinēē ꞉Yēēsu bichoo tyoonkōōchēēt kule, “/Mākēētilē ankeet nyēē tākulēēl /ānkēēkinēē sireet nyēē yoos. Yoo /kakeeyey kuu nyooto kusirinyāktōōs ꞉ankaanaa ānkung'ēti yooto kubarayiit ꞉koong'ta miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","‑/Mākēēroonkyinē mbo kibkeetiis choo /kātākēēyēyē wōōnkit nyēē yoos. Yoo /kakeeyey kuu nyooto, kōōtōlē ꞉wōōnkit kuwasta keey ꞉kibkeetiisyek. ");
INSERT INTO spyNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Māchāktōōs /kēēroonkyinē kibkeetiisyek choo /kātākēēyēyē wōōnkit nyēē lēēl. ");
INSERT INTO spyNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yoo kiikunooyēē ꞉chii ātēbuutēkyii choo bo kēny, mēēbērē chāmē kurub kāānēētiisyēēt nyēē lēēl, kuuyu isōōtyēēchinē kule tōōs kāroomēch ꞉ātēbuutēchoochii.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nto mii yēē ki *Sabaato, kumur ꞉Yēēsu ākoo rubiikyii mbareet ake nyēbo nkoonuuk. Yooto, kuswech ꞉rubiikyii mētēwookaab nkoonuuk ankubiiriir ānkulākyi kuut. ");
INSERT INTO spyNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nto bērē kukas *꞉Farisaayeek alake chēē kimii yooto, kumwooy kule, “Ntēē ōmiitē ō-iryēē kiruutyēēt nyoo yēētē /kēēkēsiis ām bēsyēētaab Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kumwoochi ꞉Yēēsu kule, “Manoosuman ꞉akweek, yoo ki-iryēē ꞉Bāytooyiintēēt *Tāwuti kiruutēk, yoo kyoomē kēmēwuut ākoo biiko choo kiboonto keey? ");
INSERT INTO spyNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kiwo ꞉Tāwuti *Kōōtaab Yēyiin /ānkiikoochi mukaatiinek choo /kikēēchāmchinē mbo *kibkōrōs nkit kwaam. Kyaam ꞉Tāwuti mukaatiinechaa ānkōōkoochi nkicheek biiko choo kiboonto keey kwaam.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yu keewaany ꞉Yēēsu kumwoochi Farisaayeechaa kuu nyooto, kumwooy kule, “Bāwu *꞉Wēritaab Chii bēsyēētaab *Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kiwo ꞉Yēēsu subak ām bēsyēēt ake nyēbo *Sabaato kōōto ake nyēbo saayeet ānkōōnēētiis. Kimii kōyooto ꞉chiito ake nyēē kisōnkōchoot ꞉āwutaab taay ");
INSERT INTO spyNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ānkimii ꞉nkicheek *Farisaayeek alake yooto ākoo kāānēētik alak chēbo kiruutēk. Kimāchē ꞉bichoo kukas yoo kēēsoobso ām bēsyēētaab Sabaato, subokōōyyoong'tēē kōōk. ");
INSERT INTO spyNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kiinkētē ꞉Yēēsu kiyēē kimii kōōsōōtē ꞉bichoo. Yooto, kumwoochi chiichoo kisōnkōchoot ꞉āwut kule, “Chōō, baa, chēēyyoonyēē yu bo taay.” Kuwo ꞉chiichoo. ");
INSERT INTO spyNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kukēēyyo ꞉chiichoo yooto, kuteebee ꞉Yēēsu Farisaayeechaa āk kāānēētichoo bo kiruutēk kule, “Chāmwēēch ꞉kiruutēkyoo /keeyey kiy nyēē karaam ām bēsyēētaab Sabaato, nto nyēē miyaat? /Kiisoobiis nto /kēēbākākiis?” ");
INSERT INTO spyNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kiirōōtoot ꞉Yēēsu chii ake tukul. Nto mii yoo, kumwoochi chiichoo kisōnkōchoot ꞉āwut kule, “Chuul āwut.” Kuchuulē āwunoo, kukārāmiitu. ");
INSERT INTO spyNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yu kakas ꞉Farisaayeechaa āk kāānēētichoo bo kiruutēk kuu nyooto, kunyēēr miisin ānkutoow kusat kiyēē makuyeyee Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nto mii bēsyēēt ake, kuwo ꞉Yēēsu ākoy lekemeet ake wokusaay Yēyiin kuyyeech. ");
INSERT INTO spyNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yu kayyeech ꞉kōōrēēt, kukuur rubiikyii, kukwey chēē kiyitē taman āk āyēēng' ānkukuur chooto kule *lēbkēēyik. ");
INSERT INTO spyNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kikwey Simōōni nyēē kitoochi kaayneet ake kule Bētērō, Antereeya nyēē ki ng'eetaabkaametiitaab Bētērō, Yāākōbō, Yoowaana, Filibō, Baatolomaayo, ");
INSERT INTO spyNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataayo, Toomaas, Yāākōbō araab Alfaayo, Simōōni nyēē kāng'unoot, ");
INSERT INTO spyNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuuta araab Yāākōbō ākoo Yuuta Iskaryoot nyoo kichokuchoomtooy Yēēsu lētuunoo. ");
INSERT INTO spyNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yu kārēkunēē lekem, kōōruruukyi keey ꞉rubiik āk biiko alak chēē chaang' chēē kikwoonēē Yēērusālēēm, yēēmēētaab Yuuteeya tukul, yēēmēētaab Tiirō ākoo nyēbo Sitōōn chēē kimii sakaramteetaab araarayta. ");
INSERT INTO spyNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kikwoonii ꞉bichoo bokuyēbchinē yiit kiyēē kiinēētē ꞉Yēēsu ānkimāchē mbo kule /kiisoob. Kiisoob ꞉Yēēsu mbo alak chēē kiboonto tāmirmirook chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kimāchē ꞉bichoo tukul kule kutiiny Yēēsu, kuuyu kiboonto ꞉Yēēsu kāāmuukēywēēk chēē kyāānkutiiny ꞉chiito, kusobē. ");
INSERT INTO spyNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nto mii yoo, kuweech keey ꞉Yēēsu ānkōōrōōtoot rubiikyii ānkumwoochi kule, “Ōmiitē sōō, nyēē karaam kule nee ꞉akweek choo ōmoong'tēē keey Yēyiin, kuuyu nyēēng'woong' ꞉Bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ōmiitē sōō, nyēē karaam kule nee ꞉akweek choo ‑mōōboontē kiy, kuuyu +/mākēēkōōnook ām lētuunoo. Ōmiitē sōō, nyēē karaam kule nee ꞉akweek choo ōbuntēē wuuyin, kuuyu +moong'erech lētuunoo. ");
INSERT INTO spyNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ōbēruurootiin ꞉akweek sōō kule nee yoo keenkwelaak ꞉biiko alake ankutayaak ānkuchubook ānkung'ōōmook, kuuyu ōyēnchinē *Wēritaab Chii. ");
INSERT INTO spyNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yoo kāyēwook kuu nyooto, ōtyēēn ankooraan kubo ng'erekweek, kuuyu mii ꞉kiito nyēē wōō nyēē mākutuwēnēēnook ꞉Yēyiin ām kibkōōnkōy. Ōmuytoochi kuuyu /kikiikēēyēchinoon nkicheek *wōōrkooyikaab Yēyiin choo kibo taay kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mii sōō, nyēē miyaat kule nee ꞉biiko choo mēēntōōs, kuuyu makung'etee ꞉ng'erekweekwaa kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mii sōō, nyēē miyaat kule nee ꞉biiko choo isōōtē kule boonto kiy ake tukul, kuuyu mākubotyi ꞉tukuuchooto ām lētuunoo. Mii sōō, nyēē miyaat kule nee ꞉biiko choo mii kung'ērēktōōs, kuuyu mākuriiryo ānkubuntēē ng'woonin lētuunoo. ");
INSERT INTO spyNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mii sōō, nyēē miyaat kule nee ꞉biiko choo /kēēng'āloolēē nyēē karaam kibtaman. Kuuyu, /kiikeeng'alaalaanunee *wōōrkooyikaab lembech choo kibo kēny kuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kitas taay ꞉Yēēsu kumwooy kule, “Kāāmwoowook akweek choo ōkāswoo kule ōchāmē buunikwook. Ōyēchi chii nyoo wēchook tukuuk chēē kāroomēch. ");
INSERT INTO spyNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ōsooyē Yēyiin kōōbēruur choo kāchubook ānkōōsoochinē choo yēwook ng'aleek chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yoo kasyeeching' ꞉chiito kwermetuut komosta ake, iwēēkyi ake. Yoo kamach ꞉chiito kābuutiing'uung', imuytoochi mbo kaansuut. ");
INSERT INTO spyNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yoo kāsooming' ꞉chii kiy, ikoochi. Nto, yoo kāyib ꞉chii kiing'uung', ‑mēēmwoochi kukētuung'. ");
INSERT INTO spyNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ōyēchinē biiko alak wuu wōloo ōmāktooy akweek /kēēyēytoowook. ");
INSERT INTO spyNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kiy nee ꞉nyēē +mōōnyōōru yoo koocham baateey biiko choo chāmook? Ntēē yēyē mbo ꞉biiko choo ‑mēēnkētē Yēyiin kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kiy nee ꞉nyēē +mōōnyōōru, yoo kōōyēchi nyēē karaam biiko choo yēwook nyēē karaam? Yēyē nkicheek mbo ꞉biiko choo ‑mēēnkētē Yēyiin kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kiy nee ꞉nyēē +mōōnyōōru, yoo kōōbēsēēnchi biiko choo ōnkētē kule yookwook? Ntēē ibēsēēnchinē keey mbo ꞉biiko choo ‑mēēnkētē Yēyiin ānkumāchē ꞉nkicheek kule /kēēyookyi tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nteenee kāāmwoowook, ōchāmē buunikwook ānkōōyēchinē ng'al chēē kāroomēch. Ōyēētyēēchinē mbo biiko choo māchāmē kuyēētyēēchook. Yoo kooyey kuu nyooto, mākutuwēnook ꞉Yēyiin miisin ānku +mōōyēyē tukuuk kuu wōloo yēytooy ꞉Yēyiin, kuuyu yēchinē ꞉Yēyiin biiko tukuuk chēē kāroomēch ānkoo mbo choo māng'ērēkyinē kiyēē /kākēēyēchi āk mbo choo sooy. ");
INSERT INTO spyNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Māchāktōōs ōriirēē biiko kuu wōloo yēytooy ꞉Baaba. ");
INSERT INTO spyNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‑Mēēmwoochi chii kule miyaat ꞉kiyēē kayey kumānēērōōtootē, /simākēēyēwuung' nkinyiing' kuu nyooto. ‑'Meeruuste chii /simakiiruustiing' nkinyiing'. Yoo kāyēwuung' ꞉chii kiy nyēē miyaat, māchāktōōs inyōōchi kaat /sikēēnyōōwuung' nkinyiing' kaat. ");
INSERT INTO spyNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yoo 'kēēkooytē kiyēē iboontē ām mooyēēt nyēē lēēl, mākukōōning' nkinyiing' ꞉Yēyiin alak ānkurisuung'. Chēē 'kēēkooytē, /kēēkētuung' chēē tēē chooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kimwooy ꞉Yēēsu chēbo tyoonkōōchēēt kule, “Imuuchē man ꞉cheebkoraatyaanteet ake kōōrēētoot ake? Yoo kātēbi kut kuyey kuu nyooto, kōōsuuchinē ꞉tukwaay ng'wēēn. ");
INSERT INTO spyNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mābiirē ꞉ng'oomnānēētaab mang'an nyēbo boonwookēēt, nteenee yoo kātitir nyoo ka mang'an kooneet keey mākunyōōr ng'oomnātēēt kukerkeyiit boonwookēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kitas taay ꞉Yēēsu kumwooy kule, “Ām nee siikāsē ꞉inyiing' sikitityaa nyēē miitē koong'taab ng'eetaabkoomēt ameekas musukyēēt nyēē miitē koong'ta nyeeng'uung'? ");
INSERT INTO spyNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Imuuchē kule nee imwoochi ng'eetaabkoomēt kule, ‘Kany ānēmuung' sikitityaa ām koong'ta,’ nto kutēē yooto tukul kumiitē ꞉musukyēēt koong'uung' nkityō? Kiblembechaantaani! Māchāktōōs inēmu kurook musukyēēt nyoo mii koong'uung' nkityō siikaste kāroomin siinēmchi ng'eetaabkoomēt sikitityaanteet ām koong'nyii.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kimwoochi subak ꞉Yēēsu kule, “‑Mēēmuuchē ꞉kēētit nyēē karaam kuyey lokoyeek chēē miyootēch, nto kuyey ꞉kēētit nyēē miyaat lokoyeek chēē kāroomēch. ");
INSERT INTO spyNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","/Kiinkētēē kēētit lokoyeek chēē yēyē. Māyēyē ꞉kateet mbuuniik āmāyēyē ꞉siikoowēēt lamayeek. ");
INSERT INTO spyNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yēyē ꞉chiito nyēē karaam tukuuk chēē kāroomēch, nto nyoo miyaat kuyēyē ꞉nyoo tukuuk chēē miyootēch. Kuuyu ng'aleek alak tukul choo isōōtē ꞉chiito, kukwoonēē kuutiinyii.” ");
INSERT INTO spyNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kitas taay ꞉Yēēsu kumwooy kule, “Ām nee sukukuuroo ꞉biiko alake kule, ‘Mokoryoontēēt,’ āmāyēyē kuu wōlēē āmāktooy. ");
INSERT INTO spyNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Rubiintēēt nyēbo man ku nyoo kāsē kiyēē āmwooyē ānkuyēyē kuu wōlēē āmāktooy. ");
INSERT INTO spyNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kerkeey ꞉rubiintoonooto āk chii nyēē bālē yēē māchē kutēēkyi kōōto kut wokunyōōr kitaweet nyēē kāsisinchi kōōto. Yoo keeyiin ꞉āynōōsyēk ānkutwoor keey ꞉bēēko, ‑mēēmuuchē kōōsimsiimākoy ꞉kōyooto mbo kisich, kuuyu /kikēētēēkyi yēē kiimoot. ");
INSERT INTO spyNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nteenee rubiintēēt nyēē mābo man ku nyoo kāsē kiyēē āmwooyē, āmāyēyē kuu wōlēē āmāktooy. Kerkeey ꞉nyooto chii nyēē tēēkyinē kōōto yēē ng'āsng'āsēch ꞉teng'eek. Yoo keeyiin ꞉āynōōsyēk ānkutwoor keey ꞉bēēko, kōōturbuubē kōyooto kule syō!” ");
INSERT INTO spyNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yu keewaany ꞉Yēēsu kwoomchi biiko ng'aleechaa, kuwo ākoo rubiikyii ākoy Kaabernaam. ");
INSERT INTO spyNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kimii ām bēsyōōsyēchooto ꞉kāāntōōyiintēēt ake nyēbo lukēētaab booryēēt nyēē mēēbērē ki Yuutāyiin. Kiboonto ꞉chiichoo motwooriintēēnyii nyēē kichāmē miisin. Nto mii yoo, kumnyaan ꞉motwooriintoonoo miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yu kakas ꞉kāāntōōyiintoonoo /kyoomtooy Yēēsu, kōōyookto booyik alak chēbo Yuutayeek bokung'āloolchi Yēēsu chokōōsoobchi motwooriintēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yu kayit ꞉booyichoo yēē kimii ꞉Yēēsu, kusaaysaay kule, “Yoo mii ꞉chii nyēē māchē /kēēyēētyēēchi, ku chiichoo, lēyyē, ");
INSERT INTO spyNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kuuyu kichameech acheek Yuutayeek miisin kut kiikutēēkwēēch *kōōtaab saayeet.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kucham ꞉Yēēsu kuwēēto keey booyichoo. Kumānāāyitē kaab chiichooto, kōōyooku ꞉kāāntōōyiintoonoo biiko alak kutōrōōk mbo Yēēsu. Kutuuyēē Yēēsu kēēltaab too, kumwoochinē kule kālē ꞉kāāntōōyiintoonoo, “Mokoryoontēēt, ‑'meeyiim keey ichōō kanyuu kuuyu mayemaat. ");
INSERT INTO spyNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nto subak, manaamuuch ꞉anii nkit ātōrōōkuung', kuuyu māāyēmē ayey kuu nyooto. Nteenee ing'alaal baateey ām yoo imiitē, mākusob ꞉motwooriintēēnyuu. ");
INSERT INTO spyNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","/Kēēbāytoo ānkumii ꞉biiko chēē ābāytooy ꞉nkanii. Yoo kāāmwoochi biikyuu kuyey kiyēē bērē nto nyēē bērē, kuyēyē. Nto mbo yoo kāāmwoochi motwooriintēēnyuu kuyey kiyēē bērē, kuyēyē. Kunyoo, yoo 'keemwaay buch kule kusob ꞉motwooriintēēnyuu, kusobē.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kiilat ꞉Yēēsu miisin yu kakas ng'aleechaa! Kōōrōōtoot biiko chēē kimii yooto ānkulē, “Manaakas bēsyēēt ake ām Yuutayeek tukul chii nyēē ikoosēēnoo keey kuu chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yu keeyeey ꞉bichoo /kikiiyooktooy, bokunyōōr motwooriintoonoo kimnyoonē kukāākusob. ");
INSERT INTO spyNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yu kāyyēēkunēē kutākyi keey ꞉Yēēsu āk rubiikyii *kiriinkēētaab Nayiin ānkirubootē ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yu makuyit oreetaab biiwuutaab kiriinkoonoo, kutuuyēē biiko alak kukālāboonu muustaab wēēro, kuboontoonu keey biiko chēē chaang' chēē kimēēysē. Ki leekwa akeenke baateey nyēbo cheebyoosya nyēē musuk. ");
INSERT INTO spyNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kikāsyi ꞉Yēēsu cheebyoosyaanaa kiisayta ānkumwoochi kule, “Cheebyoos, ‑mateeriir!” ");
INSERT INTO spyNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kuwo ꞉Yēēsu ankunam tiirbeet nyoo kimii ꞉muusyoontēēt. Yu kanam, kōōyyoong'iis ꞉bichoo. Yooto, kung'āloolchi ꞉inee muusyoontoonoo kule, “Wēnyoo, ng'eet baa!” ");
INSERT INTO spyNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kumwooyē kuu nyooto, kung'ēētē ꞉wēritkēy areet akeenke ānkōōbuurē ng'wēny ānkōōkoor. Nto mii yoo, kōōmutyi ꞉Yēēsu lakwanaa kaamet. ");
INSERT INTO spyNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kimuuyo ꞉biiko tukul miisin choo kimii yooto ānkumwooy kule, “Wōō ꞉Yēyiin, lēyyē! Kāākutook ra *꞉wōōrkooyoontēēt nyēē wōō ām kwēēnuunyoo. Kāākōōboorwēēch ra ꞉Yēyiin kāāmuukēywēēkyii.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","/Kikyaamtaatee ng'aleechaa kōōrēētaab Yuutayeek kumukuul ākoy mbo kōōrōōsyēk choo ki laatoosyekyii. ");
INSERT INTO spyNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nto mii yoo, kuba ꞉rubiikaab Bātisāniintēēt Yoowaana wōlēē /kikēērātyi Yoowaana ānkubokumwoochi ng'aleek tukul chēē kiikuyeyaan ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kumwoochi ꞉Yoowaana rubiikyii āyēēng' kule, “Booteebee Yēēsu yoo inee man ku *Kāārārookiintēēt nyoo /kōkēēbērē mākuchō, nto mii ꞉ake nyēē tākēēkānyoonu.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Kuyitē ꞉rubiichooto wōlooto, kimii ꞉Yēēsu kōōsoobē biiko chēē kiboonto bōōrwoonik chēē kimakerkeey ānkōōbēbēētooy tāmirmirook chēē miyootēch kung'ēētyēē biiko ānkōōsoobē cheebkoraatiisyek. Yooto, kumwoochi Yēēsu kule, “Kēēyookwēēch ꞉Bātisāniintēēt Yoowaana bokeeteebeeniing' yoo inyiing' man ku Kāārārookiintēēt nyoo /kōkēēbērē mākuchō, nto mii ꞉ake nyēē tākēēkānyoonu.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kumwoochi ꞉Yēēsu kule, “Oyeey ānkubōōmwoochi Yoowaana kiyēē kookas: Kāstooy ra ꞉cheebkoraatiisyek, bēēsyētē ꞉choo kichunkutootiin, kōōkusobcho ꞉choo kikiikwaam *꞉makereenik, kāsē ra mbo ng'aleek ꞉choo kikiikumiinkyo, kōōkung'ēētyēē meet mbo ꞉choo kikiikubēk /ānkōōkyoomchi lōkōōywēk chēē kāroomēch choo imoong'tēē keey Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kunyi, bōōmwoochi kule ibēruuroot ꞉chii ake tukul nyoo tākōōkoosēēnoo keey.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yu kāākubēēchi keey ꞉rubiichoo kiiyooktooy ꞉Yoowaana, kumwoochi ꞉Yēēsu biiko kule, “Kyōōbēētii bōōkāsē nee ām kōōr nyēē suurkwēēn? Ara ki tōōywoo nyēē kiimuuchē kōōsooyēn ꞉yoomat yoo kāwus? ");
INSERT INTO spyNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ara ki chii nyēē kikiilaach sirooy chēē kāroorānēch? Acha, chēē chāmē leles ānkōōloochē sirooy chēē ālē beesaan chēē chaang' kuminyē kaab bāytooyik. ");
INSERT INTO spyNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ara kyōōbēētii bōōkāsē ng'oo nanyuun? Ara ki *wōōrkooyoontēētaab Yēyiin ꞉nyi kibōōnyōōru? Kubooyiit man, kyōōnyōōru wōōrkooyoontēēt nyēē wōō kusiir wōōrkooyoo ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Inee ꞉nyoo ng'āloolēē ꞉Yēyiin ām yoo /kikeesir kule, ‘+Māāyooktē kiiyookiintēēnyuu koonto wokuyēytoowuung' kēēlto.’ ");
INSERT INTO spyNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","!Kāāmwoowook, māmii ꞉chii kōōrooni nyēē wōō kusiir Yoowaana, nteenee wōō ꞉nyoo mātookunoot nyēbo laat ām bāytooyiisyēētaab Yēyiin kusiir inee.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kitas taay ꞉Yēēsu kumwooy kule, “Biiko chēē chaang' choo kikas kāānēētiisyēētaab Yoowaana ānkōōyēnchi Yēyiin, kubatisan ꞉Yoowaana ākoy mbo choo ki kāāruruukikaab syuuruut. ");
INSERT INTO spyNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nteenee kitay *꞉Farisaayeek ākoo kāānēētikaab kiruutēk mākuutēkaab Yēyiin āk bātisāniisyēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kunyoo, +maakerkeeyee nee biich chēē wuu chu ōō, lēyyē? ");
INSERT INTO spyNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kerkeey lēēkōōy chēē mii wōlēē chaang' ꞉biich āmāchāmē ng'aleekaab chuut yoo /kēēkuurchinē kule, ‘Kakeekuutwaak kurēēruut āmōōtuum, kēēlē kēēriiryē, otay ōmēēysē.’ ");
INSERT INTO spyNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wuu nyooto wōlēē kiyibto ꞉biiko Yoowaana āk anii. Kimoomē ꞉Yoowaana āmit chēbo leles nto kuyyēē tifaayiin. Yooto /kēēmwooy kule, ‘Boonto *tāmirmiryēēt nyēē miyaat.’ ");
INSERT INTO spyNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kuchō *꞉Wēritaab Chii kwoomiisyē ānkuyyēē tifaayiik, yooto omwaay kule, ‘Kimooroong'nyaa, kibōōkityoo ānku choorweetaab kāāruruukikaab *syuuruut āk biich choo ‑/mākiiriiku.’ ");
INSERT INTO spyNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nteenee biiko choo rubē ng'aleekyuu ꞉chēē inkētē kule ng'oomnān ꞉nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nto mii yoo, kumwoochi ꞉akeenke ām *Farisaayeek Yēēsu kule bokwoomiis ām kanyii. Kucham ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yu kēēnkēt ꞉koorkēēt ake nyēbo kiriinkoonooto nyēē ki chēēmurēnnyoo kule kimii ꞉Yēēsu kwoomiisyē ām kaab *Fārisooyiintoonoo, kuchōōnto mwaayta nyēē kiboong'u nyēē anyiny. ");
INSERT INTO spyNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kuyitē kōyooto, kōōyyoonyēē Yēēsu komos kuriikyi kērēēnkōōkyii ankuriir. Kitēchi ꞉lōōkik kērēēnkōōkaab Yēēsu kut koonuun. Nto mii yoo, kumasee buutēēk lōōkik choo kitēchinē kērēēnkōōkaab Yēēsu. Kuuyu kimāchē ꞉koorkoonoo kōōboor kule kākoonyit Yēēsu, kuchuuchun kērēēnkōōk ankooyiilee mwaayaa. ");
INSERT INTO spyNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yu kakas ꞉Fārisooyiintoonoo kibo ꞉kayta kuu nyooto, kumwaayee moo kule, “Nto kātinyē ꞉chiichi kāāmuukēywēēk kukwaanee wōlēē mii ꞉Yēyiin, nto kāākōōnkēt ng'ōōkistaab koorkooni.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kumwoochi ꞉Yēēsu chiichoo kule, “Simōōni! Mii ꞉kiyēē āmāchē āmwoowuung'.” Kumwooy ꞉Simōōni kule, “Kāānēētiintēēt, imāchē imwoowoo nee?” ");
INSERT INTO spyNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kumwoochinēē ꞉Yēēsu tyoonkōōchēēt kule, “King'eet ꞉chiito ake, kōōbēsēēnchi biiko alak āyēēng' beesaanik. Kiibēsēēnchi ake chēē chaang' miisin, nto ake kōōbēsēēnchi chēē ng'ēri. ");
INSERT INTO spyNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nto yu kabiir kibēsēniisyēchoo tukwaay kuyook beesaanichaa, kunyōōchi kaat ꞉chiichoo kutēērchi bēsēnoo. Kunyi ātēēbē kule ii, ng'oo ām bichooto tukwaay ꞉nyēē kibaybayiit miisin?” ");
INSERT INTO spyNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kukētyi ꞉Simōōni kule, “Ām kāāsōōtēywēēkyuu, nyēē king'erech miisin ku ꞉nyoo kitinyē bēsēnto nyēē wōō.” Kulēēnchi ꞉Yēēsu, “'Keemwaay man!” ");
INSERT INTO spyNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kuweech keey ꞉Yēēsu ankukas koorkoonoo, ānkumwoochi Simōōni kule, “'Keekas koorkooni miitē yu? Kāākōōwuunēē lōōkikyii kērēēnkōōkyuu ankumasee buutēēkyii. Āyitu kang'uung', maneemuuch ꞉inyiing' mbo ikōōnoo bēēko chēē /kākiiwuuntoowunēēnoo tēērtit ām kērēēnkōōkyuu. ");
INSERT INTO spyNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","46","Maneemuuch ꞉inyiing' itoroochaa kuu wōloo /kēētōrōōktooy tāyēēk, nto iyiil mētinyuu. Nteenee kāākukoonyitoo ꞉koorkooni kut koomuuch kooyiil kērēēnkōōkyuu. ");
INSERT INTO spyNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kunyoo, chamateet nyēē wōō nyi kāākōōboorwoo ꞉koorkooni, kōōbooru kule /kōōkēēnyōōchi kaat ng'ōōkisto nyēē wōō. Nto chii nyoo kōtinyē ng'ōōkisto nyēē mining' /ānkēēnyōōchi kaat, mā tyaa ꞉chamateet nyēē ibooru.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kumwoochi ꞉Yēēsu koorkoonoo kule, “Kāānyōōwuung' kaat ām choolwookātēēng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yu kakas ꞉biiko chēē kimii kwoomiisyē ākoo Yēēsu ng'aleechaa, kuteebee keey kule, “Ng'oo ꞉chiichi ēē, nyi imuuchē kunyōōchi biiko kaat ām choolwookātēēt?” ");
INSERT INTO spyNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yooto, kumwoochi ꞉Yēēsu koorkoonoo kule, “Iwēētē kaalyeet. /Kaakiiraraachiing', kuuyu 'kēēkoosēēnoo keey.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nto mii yoo, kuwēēsyētootēē ꞉Yēēsu kiriinkōōsyēk āk soong'wēk chēē chaang' āk rubiikyii. Kyoomtootē lōkōōywēk chēē kāroomēch chēbo Bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kiboontootē keey chēēbyōōsōōk alak ām baanaa. Kimii ām chēēbyōōsōōchoo ꞉chēē kikiikōōbēbēētoochi ꞉Yēēsu *tāmirmirook chēē miyootēch ākoo alak chēē kikiikōōsoobchi bōōrwoonik chēē kiboonto. Alak ām chēēbyōōsōōchooto ku Maaryaa nyēbo *kiriinkēētaab Maktaala, nyoo kikiikōōbēbēētoochi ꞉Yēēsu tāmirmirook chēē miyootēch tisab. ");
INSERT INTO spyNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nto ake ku Choowaan, cheebyoosyeetaab Kuusa nyoo kiiyyoonkyinē kaab Ērōōtē. Kikēēkuurē ake Susaana āk alak chēē chaang' chēē kiyēētyēēchinootēē Yēēsu ākoo rubiikyii tukuukwaa chēē kiboonto. ");
INSERT INTO spyNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kikwaanaatee ꞉biiko kiriinkōōsyēk ku chaang' ānkōōruruukyi keey Yēēsu. Kumwoochi ꞉Yēēsu bichoo tyoonkōōchēēt ake kule, ");
INSERT INTO spyNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“King'eet ꞉kāābātiintēēt ake kuyis nkoonuuk. Kōōsuuchi ꞉alake kēēltaab too. Kootartaar choo ꞉biiko chēē kibēētēē kēēlooto ankukwey alak ꞉tāriitēk. ");
INSERT INTO spyNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kōōsuuchi ꞉alake kitaweet. Kubiityo ꞉choo. Nto mii yoo, kusisyo ānkubēk, kuuyu kitēwērēr ꞉teng'eek. ");
INSERT INTO spyNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kōōsuuchi ꞉alake wōlēē miitē ꞉kātook. Yooto kubiityo ꞉kātoochoo ānkōōrēēwoon nkoonuuk kut kumanaayey āmit. ");
INSERT INTO spyNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kōōsuuchi ꞉alake teng'eek chēē kāroomēch. Kubiityo ꞉choo nyēē karaam ankuyey āmiik chēē chaang'.” Yu keewaany ꞉Yēēsu kurār tyoonkōōchoonoo, kumwooy kule, “Nyoo yēbē yiit, kukas.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nto mii yoo, kuteebee ꞉rubiik Yēēsu kumwoochi kiyēē ibooru ꞉tyoonkōōchoonoo. ");
INSERT INTO spyNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kumwoochi ꞉Yēēsu rubiichoo kule, “/Kookeekweyaak akweek ōnkēt kiyēē iyeelaat kurubta keey ꞉Bāytooyiisyēētaab Yēyiin. Nteenee mākukāsēē ꞉biiko chuut alake ng'aleek tukul tyoonkōōchoy. Kuu yoo siraat kule, ‘+Mōōyēbchinē yiit, āmōōnkētē kiy. +Mōōkāsēē koong', āmōōkāsē kiy.’ ");
INSERT INTO spyNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Okany āboorwook tyoonkōōchooni. /Kikiikerkeeyee ng'ālyoontēētaab Yēyiin kēbuswēēchoo. ");
INSERT INTO spyNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kerkeey ꞉biiko alake kēēltaab too. Kāsē ng'ālyoontēētaab Yēyiin, nteenee chōōnii *꞉Kēniintēēt areet akeenke ankusaree ng'ālyoontoonoo simēēyēnchi /ankiiraraach. ");
INSERT INTO spyNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kukerkeey ꞉biiko alake yēbo kitaweet. Kāsē ng'ālyoontēēt ankutorooch ām ng'erekweek, nteenee, māchutitooy ꞉ng'ālyoontoonoo mētēwookwaa. Nto yoo kakwa ꞉tyēmuutēk koochuchuuy keey. ");
INSERT INTO spyNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kerkeey ꞉biiko alake teng'eek chēē kibiityēē ꞉kātook. Kāsē ng'ālyoontēēt, nteenee, bēng'tēē tukuukaab kōōrooni, bāytit āk muchastaab tukuuk chēbo leles. Irēēwoonē ꞉tukuuchoo tukul ng'ālyoontēētaab Yēyiin kumayey kiy. ");
INSERT INTO spyNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kerkeey ꞉alake teng'eek chēē kāroomēch. Kāsē ng'ālyoontēēt ānkukiilchi ām manta āk mooyēēt nyēē lēēl. Yēyiisyēē ng'ālyoontoonoo ām muytaayeet sukuyi keey.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kitas taay ꞉Yēēsu kumwoochi rubiikyii subak kule, “Māmii ꞉chii bēsyēēt ake nyēē tābē taariit ankuwunyee tēr, nto kurērē. Nteenee /kēētābē taariit /ānkiikoochi yēē tōrōōr sukulēbkēchi biiko choo kwoonii kō, ");
INSERT INTO spyNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","kuuyu, kiyēē wunyaat, mākutook, nto nyoo iyēēnoot, +/makeeng'aany. ");
INSERT INTO spyNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kunyi, māchē ōyēbchinē yiit ng'aleek ām kēēlto nyēē karaam, kuuyu nyoo yēyiisyēē kiyēē boonto, +/mākēētāsyi ake, nto nyoo māyēyiisyēē, +/mākiinēmunēē mbo kiyēē isōōtē kule boonto.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nto mii bēsyēēt ake, kumii ꞉Yēēsu kwoomchinē biiko lōkōōywēk, kuyit ꞉kaamet ākoo mbo ng'eetaabkaamet. Nteenee kimēēmuuchē kut kuba kō wōloo kimii ꞉Yēēsu kuuyu kikiikiich keey ꞉biiko miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yooto, /kēēmwoochi Yēēsu kule, “Mii ꞉koomēt āk mbo ng'eetaabkoomēt kukuuriing' ām saang' kumāchē kukasing'.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kukētyi ꞉Yēēsu bichoo kule, “Chii ake tukul nyoo kāsē ng'ālyoontēētaab Yēyiin ankuyey kuu wōloo māktooy ꞉Yēyiin nyēē moomo nto ku ng'eetaabiya.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nto mii bēsyēēt ake, kulaany ꞉Yēēsu ākoo rubiikyii mwēēnkēēt ānkumwoochi rubiik kutākyi mwēēnkēēt biitēēt nyiin ake. ");
INSERT INTO spyNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kumii kwooytōōs, kunam Yēēsu ꞉rwoonik. Kutākumii rwoo, kuchō ꞉wusōōnēēt nyēē nyikiis ānkuwus bēēko kusyōōlchi mwēēng' kut kimii ꞉mwēēnkēēt wokuling'tooy. ");
INSERT INTO spyNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yu kakas ꞉rubiik kuu nyooto, kuba yēē kimii ꞉Yēēsu ankoong'eet kule, “Mokoryoontēēt, Mokoryoontēēt, ing'eet! Ntēē kākēēbēku!” Kung'eet ꞉Yēēsu ānkōōburyoong'to wusōōnēēt āk bēēko. Kuteeman ꞉wusōōnēēt āk bēēko areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yooto, kumwoochi ꞉Yēēsu rubiikyii kule, “‑Mōōkoosēēnoo keey?” Kinam kuut rubiik ānkumuuyo miisin ankuteebee keey kule, “Chii nee ꞉chiito nyi iburyoong'tooy mbo wusōōnēēt āk bēēko ānkukāsyinē?” ");
INSERT INTO spyNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kuyit ꞉Yēēsu biitēēt nyiin ake nyēbo yēēmēētaab Kataara, ");
INSERT INTO spyNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yu kāloong'unēē ꞉Yēēsu mwēēng', kuchō ꞉chiito ake nyēē kimii kibchuraat nyēē kikiikooyiimaan *꞉tāmirmirook chēē miyootēch ām bēsyōōs chēē chaang'. Kiminyootē ꞉chiichoo kochonkoos chēē /kikēēmuchinē biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yu kayit yēē kimii ꞉Yēēsu, kōōnchō ānkōōryookyi keey ng'wēny, ānkubōloobōl kule, “Imāchēēnoo nee ōō, Yēēsu Lakwataab Yēyiin nyoo Iyweyaat? Āsooyiing' kule ‑'meenyaliilaa.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kimwooyē ꞉chiichoo kuu nyooto, kuuyu kimii ꞉Yēēsu kōōbēbēētooy tāmirmirook chēē miyootēch choo kikiikooyiimset. /Kikiikeeratee chiichoo nyōrōōrōōnik ākoo tiinkēēnik kule simāmwēy, nteenee king'ētyēē tukul ankusoor suurkwēēn. ");
INSERT INTO spyNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kuteebee ꞉Yēēsu chiichooto kule, “/Kēēkuurēēniing' ng'oo?” Kumwooy kule, “/Kēēkuurēēnoo ‘Lukēēt.’ ” Kimwooy kuu nyooto, kuuyu kiboonto lukēētaab tāmirmirook chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kisaaysaay ꞉tāmirmiroochoo Yēēsu kumakwet icheek kuba wōlēē +mābokunyāliil kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kimii ꞉ākwootiit nyēbo tōōrōōk yēbo lekemeet ake nyēē kilēēkitēē yooto. Kusoom ꞉tāmirmiroochoo Yēēsu kuchāmchi icheek bokōōwut tōōrōōchoo. Kuchāmchi ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kuchuwunee ꞉tāmirmiroochoo chiichoo ānkōōwut tōōrōōchoo. Yooto, kōōtiiriis ꞉tōōrōōchoo kōōtuultēē keey lekem ānkubokutōōrchi keey tōōliil kuliny ꞉bēēko ānkubēk! ");
INSERT INTO spyNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kukāsē ꞉biiko chēē kiriibē tōōrōōchoo kuu nyooto, kumwēy ankubokwaamtaat kiyēē kiyeyakay ām rōōrōōkiisyēk tukul āk kiriing'. ");
INSERT INTO spyNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kuba ꞉biiko yooto bokukas kiyēē kaakuyeyakay. Kuyitē, kunyōōru chiichoo kikiikooyiimset ꞉tāmirmirook chēē miyootēch kukaakukaramiit ankoolaakaat ānkumii kēēbuurto keey Yēēsu. Kimuuyo ꞉bichoo miisin yu kakas kiyēē kiyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","/Kēērārchi bichoo wōlēē /kākiisoobto chiichoo. ");
INSERT INTO spyNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yu kakas ꞉bichoo kuu nyooto, kumwoochi Yēēsu kung'eetee saang'aata, kuuyu kikiikumuuyo miisin. Kung'eet ꞉Yēēsu ākoo rubiikyii kumāchē kooyeey biitēēt nyoo kākwoonēē. ");
INSERT INTO spyNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nto baanta nyoo kāng'ēētyo, kusaaysaay ꞉chiichoo /kākiisoobē kule kubeeta keey tukul. Nteenee kimwoochi ꞉Yēēsu kule, ");
INSERT INTO spyNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Iwē kang'uung' ankuweemwaayte kiyēē kāākuyēwuung' ꞉Yēyiin.” Nto mii yoo, kung'ēētyo ankuba. Kiwo ꞉chiichoo ankuwokwaamtaat ng'aleechaa ām wōlooto tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yu kayit ꞉Yēēsu ākoo rubiikyii biitoonooto kibēētii, kutorooch ꞉biiko chēē kimii kukānyiisyē. ");
INSERT INTO spyNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Kimii ꞉chiito ake yooto nyēē /kikēēkuurēē Chāyirō nyēē ki kāāntōōyiintēētaab *kōōtaab saayeet. Kiboonto ꞉boontoonoo chēēbnyii nyēbo kēnyiisyēk taman āk āyēēng'. Ki lakwanyii ꞉nyooto baateey. Kimnyaanaat ꞉lakwanaa nyēē kikiikukasakay miisin. Kikutunyēē ꞉boontoonoo taayeetaab Yēēsu ānkuriirchi kuwēēto keey kanyii. Kucham ꞉Yēēsu. Kikiikiichaat ꞉biiko Yēēsu miisin yooto kubēētii. ");
INSERT INTO spyNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kimii ꞉nkinee koorkēēt ake baanaa nyēē kikiikumnyaan ām kēnyiisyēk taman āk āyēēng' kusāyē ꞉korotiik. Kikiikōōbootyi tukuukyii tukul cheebsaakitiisyek āmāsobē. ");
INSERT INTO spyNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kuchōōnēē ꞉koorkoonoo lēt ānkutiiny *maaseekaab kotootyēētaab sireetaab Yēēsu. Yu kātiiny maaseechaa, kōōyyoong'iis ꞉korotiik! ");
INSERT INTO spyNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yooto kumwooy ꞉Yēēsu kule, “Ng'oo nyi kāākutiinyo?” Kutuuch keey ꞉chii ake tukul. Kumwoochi ꞉Bētērō Yēēsu kule, “Mokoryoontēēt, ikāsē oob kule keekiich keey ꞉biiko ām yēē imiitē?” ");
INSERT INTO spyNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kukētyi ꞉Yēēsu kule, “Ānkētē man kule kāākutiinyo ꞉chii, kuuyu kāākuyēyiis ꞉kāāmuukēywēēkyuu.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yu kakas ꞉koorkoonoo kule kāākōōnkēt ꞉Yēēsu kiyēē kaakuyeyakay, kumuy kut kubōōtānē. Kuwo ānkukutunyēē taayeetaab Yēēsu ānkumwoochi kiyēē keesach sukutiiny siraanaa āk wōlēē kāsobto areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kumwoochi ꞉Yēēsu kule, “Kuuyu 'kēēkoosēēnoo keey ii, chēē, 'kēēsob. Kunyoo, iwēētē bāybooyyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kutākumii ꞉Yēēsu kung'āloolē, kuyitu ꞉chiito ake nyēē kichōōnēē kaab Chāyirō ānkumwoochi Chāyirō kule, “Boontēēt, ‑mateeyiim kāānēētiintēēt, ntēē kaakung'et ꞉lakwang'uung'!” ");
INSERT INTO spyNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kisiil yiit Yēēsu ꞉ng'aleechaa. Yooto, kumwoochi kwaaniitaab lakwanaa kule, “‑Mēēmuy, nteenee ikaaseenaa keey baateey. Mākusob ꞉leekweet.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yu kabokuyit ꞉icheek tukul kaab Chāyirō, kumwooy ꞉Yēēsu kule, “‑Mēēwut ꞉chii ake tukul kōyi mii ꞉lakwani. Āmāchē baateey Bētērō, Yoowaana, Yāākōbō āk sikiikaab leekweet.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ki chaang' ꞉biiko kayaata chēē kiriirtōōs ānkōōnchōōytōōs. Kumwoochi ꞉Yēēsu bichooto kule, “‑Mātōōriiryē! Manaame ꞉lakwani nteenee mii kāruchi keey.” ");
INSERT INTO spyNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kiroorchi ꞉bichoo Yēēsu kuuyu kiinkētē ꞉icheek kule kaakume man ꞉leekweet. ");
INSERT INTO spyNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kuwo ꞉Yēēsu yēē kimii ꞉lakwanaa ankunam āwut ānkukuur kule, “Chēēmining', ing'eet!” ");
INSERT INTO spyNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yooto bakeenke kusob ꞉chēēboo. Kung'eet kōōyyo. Kumwaayta ꞉Yēēsu /keebay lakwanaa. ");
INSERT INTO spyNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kiilat ꞉kwaan āk kaamet. Nteenee kiichiich ꞉Yēēsu icheek kumāmwoochi chii ake tukul kiyēē kaakuyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nto mii bēsyēēt ake, kukuur ꞉Yēēsu rubiikyii taman āk āyēēng' ānkumwoochi kule, “Kāākōōnook kāāmuukēywēēk chēē ōbēbēētēē *tāmirmirook tukul chēē miyootēch ānkōōsoob biiko chēē mnyoontōōs. ");
INSERT INTO spyNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kunyoo, boo-amtaate lōkōōywēkaab Bāytooyiisyēētaab Yēyiin ānkōōsoobootē biiko.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kumanaaba ꞉rubiichoo, kōō-āmiisēē ꞉Yēēsu ng'aleechu kule, “‑Moonamaate kiy ake tukul ām baani. Manam ꞉chii kirōk, lool, āmnyoo, beesaan nto ku sira. ");
INSERT INTO spyNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yoo kōōruutoochi kayta ake, ōbuur yooto kut ōng'ēētyēē saang'aa. ");
INSERT INTO spyNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nto yoo kooyit saang'ta ake, amatoroochaak ꞉biikaab saang'aa, olelekte tēērtit ām kwēyōōnikwook ānkōōbēēchi keey kōōboor kule tākōōbuurto ng'ōōkisng'waa.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yu keewaany ꞉Yēēsu kōō-āmiisēē rubiikyii ng'aleechaa, kubeesyetaatee soong'wēkaab kōōroonooto kwoomtootē lōkōōywēk chēē kāroomēch ānkōōsoobootē biiko chēē mnyoontōōs. ");
INSERT INTO spyNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kiyityi Bāytooyiintēēt *Ērōōtē ꞉ng'aleek chēē kimii ꞉Yēēsu kuyēyē. Kimwooyē ꞉biiko alake kule ki Bātisāniintēēt Yoowaana ꞉Yēēsu nyēē kaakung'eetee meet. ");
INSERT INTO spyNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kimwooyē ꞉alake kule *Eliiya ꞉nyoo, nto alak, kumwooyē kule, “Wōōrkooyoontēēt ake ꞉nyoo nyēē wuu *wōōrkooyik choo kibo kēny nyēē kāākōōyēēw.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kumwooy ꞉Ērōōtē kule, “Ntēē kyāābērē kyaachwente mētitaab Yoowaana. So, ng'oo ꞉ake subak nyi mii kuyēyē ng'aleechu tukul?” Kibotyi ꞉tonkoy. Yooto, kumach kule kōōnkēt chiichooto. ");
INSERT INTO spyNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yu kēēyēēw ꞉lēbkēēyichoo /kikiiyooktooy, kumwoochi Yēēsu kiyēē kibokuyey. Kung'eet ꞉Yēēsu ākoo rubiikyii kumāchē kuba yēē kimālēēkitēē ꞉chii ake tukul. Kibeetee mwēēnkēēt kutākyi keey *kiriinkēētaab Beetsaayta. ");
INSERT INTO spyNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yu kēēnkēt ꞉biiko kule kāākuwo ꞉Yēēsu, kurub inee koosaab sakaramteetaab tōōliilēēt. Yu kayit ꞉Yēēsu sakaramteet, kooneet bichooto kiyēē rubtooy keey āk Bāytooyiisyēētaab Yēyiin ānkōōsoob choo kimāchē /kiisoob. ");
INSERT INTO spyNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kumii ꞉kōōrēēt wokwiimēnē, kubēēchi ꞉rubiik ānkumwoochi kule, “Mwoochi bichu bokucheeng'aat kiyēē kaam āk wōlēē mākuruuyo kwēēmowuuni ām soong'wēchu lēēkitēē yuutēyu. Kuuyu, māmii kiyēē imuuchē kwaam ām suurkwēēnooni.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kukētyi ꞉Yēēsu rubiichoo kule, “Ōkoochi ꞉akweek kiyēē kaam.” Kumwooy ꞉rubiik kule, “Imiitē imwooyē nee? Ntēē kēēboontē mukaatiinek muut āk *burburiinēk āyēēng' baateey. Māyēmē ꞉choo /keebayee bichu. Kyoolēē nee āmit chēē sukuyem biich chēē tēē chu?” ");
INSERT INTO spyNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ki chaang' ꞉bichooto miisin nyēē kikēēytēē kisyēērōōk muut. Kumwoochi ꞉Yēēsu kule, “Otet kōōbuurootēē konom.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kutet ꞉rubiik biiko kōōbuuroot kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kunam ꞉Yēēsu mukaatiinechaa āk burburiinēchoo, kukas barak ānkubirchi Yēyiin kōōnkōy. Nto yityo, kubcheyaabchey mukaatiinek ākoo burburiinēk ānkōōkoochi rubiik kubchēchinoot bichoo. ");
INSERT INTO spyNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kyoomiis ꞉biiko kut kubiyoong'iis. /Kikiiruruuch āmiik chēē king'ēt koonyiit kērēbōōsyēk taman āk āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kimii ꞉yēē kisaay ꞉Yēēsu kuboonto keey ākoo rubiikyii nkit. Nto mii yoo, kuteebee rubiik kule, “Mwooyē ꞉biiko kule anii ku ng'oo?” ");
INSERT INTO spyNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kukētyi ꞉rubiik kule, “Mwooyē ꞉biiko alake kule inyiing' Bātisāniintēēt Yoowaana nto *Eliiya. Nto alak kumwooyē kule inyiing' akeenke ām *wōōrkooyik choo kikiikubēk nyēē kaakung'eetee meet.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kulēēnchi ꞉Yēēsu rubiik, “Nto akweek ōbērē anii ku ng'oo?” Kulēēnchi ꞉Bētērō, “Inyiing' ku *Kāārārookiintēēt nyēē kāākōōyookwēēch ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yu kāmwooy ꞉Bētērō kuu nyooto, kōōkiimchi ꞉Yēēsu icheek masimkumwaaytaat ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kumwoochi subak kule, “Ākoy kubuntēē *꞉Wēritaab Chii nyāliluutēk chēē chaang'. Makutay ꞉booyik, mbo *kibkōrōs chēē wōōyēch ākoo kāānēētikaab kiruutēk. Nto subak +/makeebakach nto miitē bēsyēētaab sōmōk /kiing'eetee meet.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kutas taay ꞉Yēēsu kumwoochi rubiichoo āk biiko chēē kimii yooto kule, “Chii ake tukul nyoo māchē kurub ng'aleekyuu, kutay kiyēē māchē ꞉mooyēēnyii āmānyōkōriitu meet ākookoy. Yoo kaakucham kuyey kuu nyooto, kuruba. ");
INSERT INTO spyNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nyoo kāyēētyi keey soboontaab kōōrooni, mākōōboot soboonnyii bo kibchuulyo. Nto nyoo kēēkooyto soboonnyii ām kōōrooni kubo anii, mākunyōōr *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kāroomnyo nee nyēē nyōōru ꞉chii yoo kēētukuulchi keey tukuuk tukul ām kōōrēēt ānkōōboot soboonnyii bo kibchuulyo?” ");
INSERT INTO spyNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kimwoochi subak ꞉Yēēsu biiko kule, “Chii ake tukul nyoo kataya āk ng'aleekyuu, +maatay ꞉nkanii, *Wēritaab Chii, bēsyoonoo āchōōnii ām lēbkēēyyēēnyuu āk nyēbo Baaba ākoo nyēbo malayikaanikyii. ");
INSERT INTO spyNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","!Kāāmwoowook, mii ꞉biiko alake yu chēē mābēku kumanaakas Bāytooyiisyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nto yu kābēk ꞉bēsyōōsyēk chēē māchē kuyitē sisiit kukāmwooy ꞉Yēēsu ng'aleechaa, kukuur rubiikyii sōmōk: Bētērō, Yoowaana ākoo Yāākōbō. Kuwēēto keey rubiichoo ākoy tulwēēt ake barak wokusaay. ");
INSERT INTO spyNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kumii ꞉Yēēsu kusooyē, kuweek ꞉eernyii koolekecheech miisin. Kuwēēkiis ꞉nkicheek sirook chēē kiiloochē kuleelakiitu kule mang'! ");
INSERT INTO spyNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kutook *Muusa ākoo *Eliiya ām lēbkēēyyēētaab Yēyiin ankung'alaal ꞉tukwaay āk Yēēsu. King'āloolēē ruutooynyii nyēē kimii wokuyityiintōōs ām Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yu king'āloolē ꞉Yēēsu ākoo mbo Muusa, kikiikunam ꞉rwoonik Bētērō āk rubiik chuut āyēēng'. Nto bērē kukās, kukas Yēēsu kukeelaambuuch ꞉lēbkēēyyēēt ānkiboonto keey mbo Muusa. ");
INSERT INTO spyNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yu keeteryeech ꞉Muusa ākoo Eliiya ng'aleekwaa kumāchē kuba, kumwoochi ꞉Bētērō Yēēsu kule, “Mokoryoontēēt, karaam yu kēēmiitē yu. Kany keeyte kēryōōsyēk sōmōk, nyeeng'uung', nyēbo Muusa ākoo nyēbo Eliiya.” Kimēēnkēt ꞉Bētērō kiyēē kimwooyē. ");
INSERT INTO spyNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kutākumii ꞉Bētērō kung'āloolē, koolaambuuch nkicheek ꞉boolteet. Kimuuyo ꞉icheek miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yooto, kuchōōnēē ꞉kuutiit booltaanaa nyēē mwooyē kule, “Lakwanyuu ꞉nyi nyēē āchāmē. Kunyoo, ōkāsyi kiyēē mwooyē.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yu bēku ꞉ng'aleechaa, ki Yēēsu nkit āk rubiichoo chēē kimii yooto. Kisiista ꞉rubiichoo ng'aleechaa kiyēyāktōōs nyēē mānāātwēkyi chii ake tukul ākoy bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yu kāyyēēkunēē, kukāākurēkunēē ꞉Yēēsu ākoo rubiichoo ki sōmōk lekem, kutōrōōk ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kooteeyee keey ꞉chiito ake ām kwēēnuutaab bichooto kule, “Kāānēētiintēēt, mii yu ꞉wērinyuu anku lakwanyuu nyooto baateey. ");
INSERT INTO spyNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tēryēkyinē *꞉tāmirmiryēēt nyēē miyaat kwaak. Yoo kātēryēkyi, kōōnchōōyē, kōōsōrsēētē ānkukābusē. Ryooksētē nyēē miyaat āmāwuntooy areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","!Kwāātēēchi rubiikuuk kōōbēbēētoochi tāmirmiryoonoo, nteenee maneemuuch.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yooto, kumwooy ꞉Yēēsu kule, “Kunuurēch sōō, ꞉biiko alake nyēē tyaa. Nto yu manookaaseenaa keey! +Māābuurtook ānkāāmuytoochook ākoy āyu?” Yooto, kumwoochi kwaaniitaab wēērooto kule, “Imutu baa wēērooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kumii /kiimutu wēēriit, kutēryēkyi ꞉tāmirmiryoonoo ānkōōsōrsēēt. Kōōbēbēēto ꞉Yēēsu tāmirmiryoonoo miyaat kung'eetee wēēroo. Yooto, kusob ꞉wēēroo bakeenke /ānkēēkētyi kwaan. ");
INSERT INTO spyNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kiilat ꞉biiko tukul choo kimii yooto, yu kakas wōlēē kiwuu ꞉kāāmuukēywēēkaab Yēyiin. Kumii ꞉biiko tākōōlātē tukuuk chēē kiikuyeyaan ꞉Yēēsu, kumwoochi ꞉Yēēsu rubiikyii kule, ");
INSERT INTO spyNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Āmāchē ōyēbchi yiit kiyēē āmiitē wāāmwoowook ānkōōnāmtooy mēt. Mii /bokiiyokoochinē *Wēritaab Chii āwunnyēkaab biikaab kōōrooni.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mānēēnkēt ꞉rubiik kiyēē kimii kumwooyē ꞉Yēēsu. Kiiyeelaat, nteenee kinyōkōriitu kuteebee Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kutoow ꞉rubiik kumooyo wōōyinto. ");
INSERT INTO spyNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nteenee kōōnkēt ꞉Yēēsu kiyēē kimii kumooytōōs ꞉icheek. Yooto, kōōyyoong'tēē leekweet ake yēē kimii ꞉inee ānkumwoochi rubiikyii kule, ");
INSERT INTO spyNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Chii ake tukul nyoo kataach leekwa kuuyu nyeenyuu ꞉lakwanaa, kaakutaacha anii. Nto yoo kataacha, kaakutaach Yēyiin nyoo kiiyookwoo. Wuu nyooto, nyoo yibē keey ng'wēny ām akweek, ku nyooto ꞉nyēē wōō.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kimwoochi ꞉Yoowaana Yēēsu kule, “Mokoryoontēēt, kimii ꞉chiito ake nyēē kikeekas kōōbēbēētooy *tāmirmirook chēē miyootēch kuyēyiisyēē kaayneeng'uung'. Yooto, keeyeetee chiichoo kuyey kuu nyooto, kuuyu kimā rubiintēēng'uung' ake.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kukētyi ꞉Yēēsu kule, “‑Mooyeetee, kuuyu chii nyoo mākwiilook ku nyēēng'woong'.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yu kikiikuriikyi Yēēsu ꞉bēsyōōsyēkyii chēē +/mākēēyibēē kuwo kibkōōnkōy, kuwo ākoo rubiikyii nyēē kaakurat moo kutākyinē keey Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kumii kwiimēnē ꞉kōōrēēt kikiikuriich ꞉Yēēsu ākoo rubiichoo saang'ta ake ām kōōrēētaab *Samaaryaa. Kōōyookto biiko alak kuba ākoy saang'aa bokukāsyi bārooyinto wōlēē sukōōmuunyēē. ");
INSERT INTO spyNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nto yu kayit ꞉bichoo wōlooto, kutay ꞉biikaab saang'aata kutorooch, kuuyu kimii kuwēētii *Kōōtaab Yēyiin ām Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yu kāmwooy ꞉bichoo /kākiiyooktooy kule kātāyiis ꞉biikaab saang'aa, kumwoochi ꞉Yāākōbō ākoo Yoowaana Yēēsu kule, “Mokoryoontēēt, +makeeyeyee nee bichoo ēē? Ara kēēmwoochi Yēyiin kutōōrchi iileet kōōmukuus ēē, nto nee?” ");
INSERT INTO spyNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kuweech keey ꞉Yēēsu ānkōōburyoong'to rubiichoo āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nto mii yoo, kutākyi keey saang'ta ake. ");
INSERT INTO spyNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nto mii bēsyēēt ake, kumii kēēltaab too kubēētii, kumwoochi ꞉chiito ake Yēēsu kule, “Ārubiing' ꞉anii ānkoo 'kēēwē ānō!” ");
INSERT INTO spyNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kukētyi ꞉Yēēsu chiichoo kule, “Boonto kimōkōyiinēk wōlēē minyē ānkuboonto nkicheek ꞉tāriitēk wōlēē minyē, nteenee māboonto *꞉Wēritaab Chii wōlēē imuunyēē.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kukuur ꞉Yēēsu chiito ake chokuyēk rubiintēēnyii ake, nteenee kumwoochi ꞉chiichoo Yēēsu kule, “Mokoryoontēēt, kany kut amuy baaba, nto ārubiing'.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kukētyi ꞉Yēēsu chiichoo kule, “Ikany kumuy keey ꞉muuswēk ankiirubwaa, nteenee ichōō ꞉inyiing' chee-amtaate lōkōōywēkaab Bāytooyiisyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kumwoochi ꞉nkinee chiito ake subak Yēēsu kule, “Āwēy, Mokoryoontēēt, āmiitē ꞉nkanii āchōōnii, nteenee kany kurook wāā-āmiis biiko ām kaa.” ");
INSERT INTO spyNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kukētyi ꞉Yēēsu nyoo kule, “Chii nyoo tēbēnē mōkōōnkē ānkukusē lēt, kumānyoolchinē Bāytooyiisyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nto mii yoo, kukwey ꞉Mokoryoontēēt Yēēsu rubiik alak chēē kiyitē tāmānwookik tisab kumāchē kōōyookto simkoonto. Kimāchē kule kubeetaatee āyēēng' āyēēng' ākoy kiriinkōōsyēk āk soong'wēk tukul chēē kikiikuchōb ꞉inee kuruutoochi lētuunoo. ");
INSERT INTO spyNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kumānāāng'ēētyo ꞉rubiik, kōō-āmiisēē ꞉Yēēsu ng'aleechu, “Wōō ꞉kēsiisyēēt, nteenee ng'ēri ꞉kēsiik. Kunyoo, ōsoom kutās ꞉chiitaab yiisyēēt biiko alak. ");
INSERT INTO spyNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ōnkēt kule okerkeeye kēēchiir chēē iwēērē suuyiik kwēēn. ");
INSERT INTO spyNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Manam ꞉chii beesyaa nto lool nto mbo kwēyōōnik alak, amookaayaate keey ām kēēltaab too. ");
INSERT INTO spyNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yoo kōōwut kayta ake tukul, ōmwoochi biikaab kayaata kule, ‘Ōnyōōru bērurto!’ ");
INSERT INTO spyNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yoo yēmāktōōs kunyōōr ꞉bichoo bēruroo, mākunyōōr. Nto yoo māyēmāktōōs, mākōōyēēchook ꞉bēruroo. ");
INSERT INTO spyNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","8","Nto yoo kōōwut saang'ta ake /ankeetoroochaak ām kayta ake, ‑mōōlumootēē koorin chēē chaang'. Ō-āmē ānkōōyyēē kiyēē kākōōnook ꞉biikaab kayaata kuuyu yēmē ꞉chii nyoo kāākubirto nkuruukyii /kiikoochi kiy. ");
INSERT INTO spyNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ōsoob chēē mnyoontōōs ānkōōmwoochinē biiko kule, ‘Kāākuyityook ꞉Bāytooyiisyēētaab Yēyiin.’ ");
INSERT INTO spyNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nteenee yoo katay ꞉biikaab *kiriinkēēt ake kutoroochaak, ōng'ēētyē ānkōōbēēchi keey. Ōmwoochi biikaab kiriinkoonoo kule, ");
INSERT INTO spyNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kiibuukwook tēērtitaab kiriinkēēng'woong' nyi mii kērēēnkōōkyoo sōōsōōtēē keey, nteenee māchāktōōs ōnkētē kule kaakuriik ꞉Bāytooyiisyēētaab Yēyiin.’ ");
INSERT INTO spyNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","!Kāāmwoowook, +/mākiing'woonchi biikaab kiriinkoonooto miisin kusiir mbo ng'wooninto nyēē mākunyōōr ꞉biikaab *kiriinkēētaab Sōtōm ām bēsyoonoo itiilchinē ꞉Yēyiin ng'aleek biiko ām kōōrēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kutas taay ꞉Yēēsu kumwooy kule, “Kiriinkōōsyēkaab Koorasiin ākoo Beetsaayta, wuusyō! Tyaa sōō, ꞉ng'wooninto nyēē mii kukānyoonwook akweek choo kyāāyēwook ng'al chēbo kwōng'uut. Nto ki biikaab Tiirō nto ku chēbo Sitōōn ꞉chēē /kikēēyēchinē ng'aleechaa bo kwōng'uut, nto kiikōōbuurēē aryaanteet ankoolaach sirook chēē ibooru kule kookuweek ām miyootyēēt nyēē kōboonto. ");
INSERT INTO spyNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lēyyē, mākunyōōr ꞉biikwook ng'wooninto nyēē siirē nyoo mākunyōōr ꞉biikaab Tiirō ākoo Sitōōn bēsyoonoo itiilchinē ꞉Yēyiin biiko ng'al ām kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nto akweek biikaab Kaabernaam ii, ōbērē +moobe ꞉nkakweek kibkōōnkōy ēē? Acha, +moobe ng'wēny! ");
INSERT INTO spyNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chii ake tukul nyoo kākāswook kukāākukāswoo. Nto nyoo katayaak, kukaakutaya. Nto nyoo kaakutaya, kukaakutay Yēyiin nyoo kiiyookwoo.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nto yu kābokōōyēēw ꞉rubiichoo ki tāmānwookik tisab, kumwoochi Yēēsu ām ng'erekweek kule, “Mokoryoontēēt! Kāswēēch ra ꞉tāmirmirook chēē miyootēch, yoo kāākēēyēyiisyēē kaayneeng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kukētyi ꞉Yēēsu kule, “Man sinee kāswook. Kwaakas /kēēwunuku Syeetaani kōōsuuwunēē barak kuu iilat nyēē kārārāk. ");
INSERT INTO spyNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kāākōōnook kāāmuukēywēēk chēē ōtoortoorēē ēērēēnōōk āk kēnēyiisyēk ānkōōsyēēntēē kāāmuukēywēēk tukul chēbo Syeetaani. ");
INSERT INTO spyNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","!Kāāmwoowook, ‑mōōng'ērēēkiisyē kule kāswook ꞉tāmirmirook chēē miyootēch, nteenee ōng'ērēēkiisyē, kuuyu sirootiin ꞉kooynōōkwook ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yooto kōōnyiityi ꞉Tāmirmiryēētaab Yēyiin Yēēsu ng'erekweek. Kusilto Yēyiin kumwooyē kule, “Āchāmtiing' inyiing' Baaba Yēyiin, nyoo ibāwu barak āk ng'wēny, kuuyu 'kwēēboorchi biiko choo yibē keey ng'wēny kiyēē iwunyēē biiko choo isōōtē kule inkētē chēē chaang' ānkung'oomēch. Kōōnkōy, Baaba, kuuyu wuu nyooto ꞉wōlēē imāktooy ꞉inyiing'. ");
INSERT INTO spyNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kikōōnoo ꞉Baaba kiy ake tukul nyēē āboontē. Baaba nkit ꞉nyēē inkētē wōlēē wuu ꞉lakwanyii, āmēēbērē mii subak ꞉chii nyēē inkētē wōlēē wuu ꞉Baaba, nteenee anii nkit ākoo biiko choo kyaakwey āboorchi ꞉chēē inkētē.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nto mii yoo, kuwēēkyi keey ꞉Yēēsu rubiikyii ānkulēēnchi, “Ōbēruurootiin ām wōlēē mii ꞉Yēyiin ām kiyēē kookas! ");
INSERT INTO spyNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","!Kāāmwoowook, kiikukanyaan *꞉wōōrkooyikaab Yēyiin chēē chaang' āk bāytooyik kule nto kas ānkuyēbchi yiit kiyēē ōmiitē ꞉akweek ōkāsē ānkōōyēbchinē yiit amanaakas.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nto mii yoo, chokutyem Yēēsu ꞉kāānēētiintēēt ake nyēbo kiruutēk. Kiteebee kule, “Kāānēētiintēēt, māchāktōōs ayey nee sāānyōōru *soboontaab kibchuulyo?” ");
INSERT INTO spyNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kukētyi ꞉Yēēsu kule, “Mwooyē nee ꞉kiruutēkaab Yēyiin choo kikōōnu *꞉Muusa?” ");
INSERT INTO spyNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kukētyi ꞉chiichoo kule, “Mwooyē kule icham Mokoryoontēēt Yēyiintēēng'uung' ām mooyēēt akeenke, soboonng'uung' tukul, nkuruukuuk tukul āk kāāsōōtēywēēkuuk tukul. Māchāktōōs mbo icham laatyeeng'uung' kuu wōloo ichāmtooy keey.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kukētyi ꞉Yēēsu chiichoo kule, “Wuu nyooto! Kunyi, yoo 'keeyey kuu nyooto, +mēēnyōōru soboonto.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kimāchē ꞉chiichoo kōōboorchi biiko alak kule kichurtaat ꞉inee. Kunyoo, kuteebee Yēēsu kule, “Ng'oo ꞉laatyeenyuu ēē?” ");
INSERT INTO spyNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kōōboorchinēē ꞉Yēēsu chiichoo tyoonkōōchēēt kule, “Kimii bēsyēēt ake ꞉chiito ake nyēē ki Yuutāyiin nyēē kiwēētēē Yēērusālēēm kurēktooy Yēērikō. Kumii kēēltaab too kutuchi ꞉sāsiik alake. Kibuutēē ꞉sāsiichoo sirookyii ānkubirsēēt nyēē kitabakach ānkubākookyi kēēlto komos kukalyelta. ");
INSERT INTO spyNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kuchō *꞉kibkōrōs ake. Nto bērē kukas chiichoo kimii kāru kēēlto komos, kumur taban ankukeeyta. ");
INSERT INTO spyNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kuchō subak ꞉chiito ake nyēē kiyēētyēēchinē yiisyēēt ām *Kōōtaab Yēyiin. Yu kakas ꞉nkinee nyoo chiitkēy, kumur taban. ");
INSERT INTO spyNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nto yityo, kuchō ꞉chii nyēbo kōōrēētaab *Samaaryaa, nyēē kichōōnēē sikiryēēt. Nto bērē kukas chiichoo kuriiree. ");
INSERT INTO spyNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kuwo yēē kimii ānkumāsyi ng'woowōōk, koonyaay ānkurātyi. Yu keewaany, kukālābchi sikiryēēt. Kikwēryoot ākoy kayta nyēē /kikiimuuchē /kyaalee kiyēē /kyoomē āk rwoonto ānkōōbuurto keey. ");
INSERT INTO spyNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yu kāyyēēkunēē, kōōnēm ꞉chiichooto beesaanik ānkōōkoochi chiitaab kayta. Kimwoochi kule, ‘Iriibwoo, baa, chiichi ākoy āyēēwu. Nto yoo kakeeytee ꞉beesaanik chēē 'kēēriibēē chu kāākōōning', +māchāātāsuung' laatit nyēē imāchē yoo kāāchōō.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yu keewaany ꞉Yēēsu kurār tyoonkōōchoonoo, kuteebee kāānēētiintoonoo bo kiruutēk kule, “Yoo 'keekas ii, ng'oo ām bichuutēchu sōmōk ꞉nyēē ki laatyeetaab chiichoo kibirē ꞉sāsiik?” ");
INSERT INTO spyNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kukēt ꞉chiichoo kule, “Nyoo kiriiree.” Kulēēnchi ꞉Yēēsu chiichoo, “Man! Kunyoo, wēēbooru ꞉nkinyiing' kiisayta nyēē wuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kitas taay ꞉Yēēsu ākoo rubiikyii ām baanng'waa ākoy saang'ta nyēē kiminyē ꞉cheebyoosyeet ake nyēē /kikēēkuurēē Maariita. Yu kayit, kutorooch ꞉cheebyoosyaanaa kuba kōōnyii. ");
INSERT INTO spyNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kiboonto keey ꞉Maariita cheebkaamet nyēē /kikēēkuurēē Maaryaa. Kwoomu ꞉Yēēsu lōkōōywēk, kimii ꞉Maaryaa yēbo kērēēnkōōkyii kuyēbchinē yiit kiyēē kiinēētē. ");
INSERT INTO spyNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nteenee kimii ꞉Maariita kusuuysuuyēē ng'aleekaab āmiik. Nto tēē yoo, kuwo yēē kimii ꞉Yēēsu ānkulēēnchi, “Mokoryoontēēt! Nto yu kānyikisyoo ꞉yiisyēētaab āmiik, kany chokuyēētyēēchoo ꞉Maaryaa.” ");
INSERT INTO spyNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kukētyi ꞉Yēēsu kule, “Maariita, ntēē imiitē iyiimēē keey tukuuk chēē chaang', ");
INSERT INTO spyNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nteenee, mii ꞉kiito akeenke nyēē māchāktōōs /keeyey. Kaakukwey ꞉Maaryaa kiy nyēē karaam nyēē mēēbērē /tākiinēmunēē.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kimii bēsyēēt ake yēē kisooyē ꞉Yēēsu. Yu keewaany, kuwēēchi ꞉rubiintēēnyii ake ānkumwoochi kule, “Mokoryoontēēt, kēēmāchē 'ineeteech wōlēē /kēēsooytooy kuu wōloo kiinēētitooy ꞉Bātisāniintēēt Yoowaana rubiik cheechii.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kumwoochi ꞉Yēēsu rubiikyii kule, “Ōsooyē kule, ‘Baaba Yēyiin, kutōrōriit ꞉kaayneeng'uung', kuyit ꞉bāytooyiisyēēng'uung'. ");
INSERT INTO spyNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ikōōnēēch kiyēē kyoomē ām bēsyēēt ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Inyōōwēēch kaat ām choolwookātēēnyoo, kuu yoo kēēnyōōchinē kaat ꞉nkacheek chii ake tukul nyoo choolwookēnchēēch. Itiiyēēch /simakeekenteech.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kutas taay ꞉Yēēsu takooneet rubiikyii kurubta keey ākoo saayeet kule, “Yoo kāchōōnchiing' ꞉toontēēt kwēēmooy, imuuchē wēēng'ēētiisyē kule, ‘Laatya, kāānyōōru toontēēt ēē, wē, āmāmii āmnyoo nyēē kaam. Kōōnoo, baa, mukaatiinek sōmōk.’ ");
INSERT INTO spyNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Imuuchē ꞉laatyaanaang'uung' kukuuruung' ām kō kule, ‘Kāākēēruuyē ākoo lēēkōōk kunyoo, ‑mēēmuuchē ꞉chii takuyaat kurkeet kwēēmooy ku tēē nyi. Kunyi, māmii ꞉wōlēē āyēētyēēchintiing'.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yu keewaany ꞉Yēēsu tyoonkōōchoonoo, kumwoochi rubiikyii kule, “!Kāāmwoowook, ānkoo ku choorweeng'uung' ꞉chiichoo, mēēbērē makung'eet areet akeenke ānkukōōning' kiyēē 'kēēmāchē. Nteenee yoo 'keetas taay ing'ēētiisyē, mākuyootuung' kurkeet ām lētuunoo ānkukōōning' kiyēē 'kēēmāchē kuuyu !kēēmuytoochi. ");
INSERT INTO spyNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kunyoo, soomsē, /kēēkōōning', cheeng', inyōōru, ānkiing'ēētiisyē /kēēyootuung'. ");
INSERT INTO spyNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chii nyoo soomsē, /kiikoochinē, nyoo chēēng'sē, kunyōōru, nto nyoo ing'ēētiisyē, /kēēyootyinē.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yu keewaany ꞉Yēēsu, kumwoochi rubiikyii kule, “Ātēēbēē chii ake tukul nyoo boonto leekwa kule ii, yoo kateeb ꞉lakwanaa *burburyoontēēt, ikoochi eereen? ");
INSERT INTO spyNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nto yoo kateeb mēkēyoo, ikoochi kēnēyoo? ");
INSERT INTO spyNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kunyi, yoo ōchāmē ꞉akweek choo ‑mōōchurtootiin ōkoochi lōkōkwook tukuuk chēē kāroomēch ii, /keemwa nee nanyuun Kōōn nyoo mii kibkōōnkōy? Inēmu keey ꞉nyoo miisin kukōōnook Tāmirmiryēēnyii, yoo kōōsoom.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nto mii bēsyēēt ake, kōōbēbēēto ꞉Yēēsu *tāmirmiryēēt nyēē miyaat nyēē kikiikuyey chiito ake kunamakay ꞉kuut. Yu kēēbēbēēto tāmirmiryoonoo, kukaramiit ꞉chiichoo ankung'alaal nyēē karaam. Kiilat ꞉biiko ");
INSERT INTO spyNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","nteenee kumwooy ꞉alake kule, “Ānkoo sinee imuuchē kōōbēbēēto tāmirmirook chēē miyootēch, kwoonēē ꞉kāāmuukēywēēkyii wōlēē mii ꞉Bēēlsēbuul nyoo kāāyyoong'iintēētaab tāmirmirook chēē miyootēch.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yooto kuteebee ꞉alake Yēēsu kumāchē kutyem kule, “Kiy nee ꞉nyēbo kwōng'uut nyēē +meeyey siiboorunēēnēēch kule iboontē kāāmuukēywēēk chēē kwoonēē kibkōōnkōy?” ");
INSERT INTO spyNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kuuyu kiinkētē ꞉Yēēsu kiyēē kimii ꞉bichoo kōōsōōtē, kumwooy kule, “Yoo kaakubar keey ꞉lukēētaab booryēēt nyēbo kōōrēēt ake, kuburyētē ꞉kōōroonoo. Nto yoo kaakukwiil keey ꞉kayta ake tukul, kuburyētē. ");
INSERT INTO spyNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ōmwooyē kule kikōōno anii ꞉Bēēlsēbuul kāāmuukēywēēk chēē ākwētēē lukēēnyii. Nto kikiikukōōno, nto mii kubooryēē keey nkit. Nto yēē kāākubooryēē keey nkit, kuburyētē ꞉bāytooyiisyēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nto yoo ākoo kāākukōōno anii ꞉Bēēlsēbuul kāāmuukēywēēk, kukiikoochinē ꞉ng'oo nkicheek rubiikwook kāāmuukēywēēk choo ibēbēētēē tāmirmirook chēē miyootēch? Oteebee, baa, akweek kumwooy. ");
INSERT INTO spyNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nteenee yēē ākoo ābēbēētooy ꞉anii tāmirmirook chēē miyootēch ānku Yēyiin nyēē kōōnoo kāāmuukēywēēk chēē āyēyiisyēē, kōōbooru ꞉yooto kule kāākuyityook ꞉bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yoo mii ꞉chii kanyii ānkukiimoot ānkutinyē kariikaab booryēēt chēē yēmootiin, kumāmii ꞉chii nyēē imuuchē kubooryēē kut kōōnēmunēē tukuukyii. ");
INSERT INTO spyNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nto yoo kāchō ꞉ake nyēē kiimoot miisin ānkuboonto kariikaab booryēēt chēē kōlkōlēch, kōōsyēēntooy chiichoo ānkōōnēmunēē kariikaab booryēēt tukul choo kāyēētēē keey ankubcheyta tukuuchoo kābāru. ");
INSERT INTO spyNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Chiito nyēē bāloo ku nyoo māmii komosnyuu. Nto chii ake tukul nyoo māyēētyēēchoo kiiruruuch tukuuk, ku inee ꞉nyēē isērēētē.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kimwooy Yēēsu subak kule, “Yoo /kāākiibēbēēto *tāmirmiryēēt nyēē miyaat kuchuwunee chiito, makoombakaatee suurkwēēnēēt nyēē kilay ꞉asiis kuchēēng'ē wōlēē kēēmuunyēē. Nto yoo kāmānyōōr, kumwooyē kule, ‘Kaykay ayeey wōloo kyāāminyē.’ ");
INSERT INTO spyNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nto yoo kēēyēēw, kunyōōru wōlooto kumasaat ankuyeytaat nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kuwēētii ānkuwokuchōōntooy keey tāmirmirook alak tisab chēē miyootēch kusiir inee ānkubokōōwut ꞉tukul chiichooto. Kunyi, miyātiitu ꞉chiichoo kusiir yoo kibo taay.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kutākumii ꞉Yēēsu kung'āloolē, kukuurchi ꞉cheebyoosyeet ake nyēē kimii yooto kikiiruruukyi keey ꞉biiko kule, “Ibēruuroot ꞉koomēt nyoo kisiching' ānkōōrēēryiing'.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kukētyi ꞉Yēēsu cheebyoosyaanaa kule, “Man, nteenee chēē ibēruurootiin miisin ku biiko tukul choo kāsē ng'ālyoontēētaab Yēyiin ankuyey kuu wōlēē /kēēmāktooy.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yu kachaang'iit ꞉biiko miisin ām yēē kimii ꞉Yēēsu, kumwoochi ꞉Yēēsu kule, “Miyootēch sōō, kule nee ꞉biiko alake chēē mii yuutēyu. Māchē kule /kiiboorchi kiy nyēbo kwōng'uut. Ng'aleek baateey chēbo kwōng'uut chēē +/mākiiboorchi ku choo kibo Yoona. ");
INSERT INTO spyNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kuu yoo kyoomchinē ꞉Yoona biiko chēbo *kiriinkēētaab Ninaawi kule kuweek ām miyootyēēt nyēē kiboonto, mii ꞉nkinee *꞉Wēritaab Chii kwoomchinē biiko kuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kutas taay ꞉Yēēsu kumwooy kule, “Mākōōyyo ꞉cheebyoosya nyēē kibāytooy kōōrēētaab Sōōy bēsyoonoo /kiitiilchinē biiko ng'aleek. Makooruusta biiko chēē wuu chuutēchu, kuuyu kichōōnēē ꞉cheebyoosyaanaa lōōyin chokuyēbchinē yiit ng'aleekaab ng'oomnātēēt chēē kimwoowu ꞉Sōlōmōōn. Nteenee miitē yu raat ꞉nyēē wōō kubiir Sōlōmōōn. ");
INSERT INTO spyNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mākōōyyoong'iis ꞉nkicheek biikaab Ninaawi bēsyoonoo /kiitiilchinē biiko ng'aleek. Makooruusta biiko chēē wuu chuutēchu, kuuyu kiikuwēēkiis ꞉icheek kurubta keey ākoo āmtooyiisyēētaab Yoona ānkumii yu ra ꞉nyēē wōō kusiir Yoona.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kutas taay ꞉Yēēsu kumwooy kule, “Māmii ꞉chii nyēē tābē taariit ankuwuny, nto kōōkubuuyēē kērēbēēt. Nteenee /kiikoochinē yēē itōrōōroot sukulēbkēchi chii ake tukul nyoo chōōnii kō.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kutas taay ꞉Yēēsu kumwooy kule, “Koong'uung' ꞉nyēē ikoochinē bōōrng'uung' lēbkēēyyēēt. Yoo kāstooy ꞉koong'uung' nyēē karaam, iboontē lēbkēēyyēēt. Nto yoo mākāstooy nyēē karaam, imiitē mēēnān nyēē mā mining'. ");
INSERT INTO spyNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kunyoo, ōriib keey ‑mookany ōbērē tōōs ōboontē lēbkēēyyēēt ākoo mēēnānēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yoo kēēng'oonkyi bōōrng'uung' tukul lēbkēēyyēēt nyēē māmii wōlēē kāng'ēt, kōōloombuuchiing' ꞉lēbkēēyyoonoo. Kerkeey ākoo yoo keekwenyiing' ꞉taariit nyēē māmii ꞉kiyēē kakerekta, lēbkēyiitu ꞉bōōrng'uung' tukul.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kutākumii ꞉Yēēsu kung'āloolē, kumwoochi *꞉Fārisooyiintēēt ake kubeeta keey inee kanyii bokwoomiis. Kucham ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yu kayit, /kiikoochi āmiik. Kwoomiis ꞉Yēēsu amaneentasiim āwunnyēk kuu wōlēē kiwuu ātēbuutēkaab Yuutayeek. Kiilat ꞉chiitaab kayta miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yu kakas ꞉Yēēsu kule kinam kuut Fārisooyiintoonoo ꞉kiyēē kiyeyakay, kulēēnchi, “Ōchāmē ꞉akweek *Farisaayeek ōtiliilē bōōrwoonikwook saang', nteenee ōbākooktooy āriit kutuur. Ōsāsunootēē biich tukuuk ānkōōyēyē ng'al chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ōbērbērēch sōō nyēē tyaa! ‑Mōōnkētē ꞉akweek kule Yēyiin ꞉nyēē kiyēyē bōōrtaab chiito saang' ākoy āriit? ");
INSERT INTO spyNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ōkoochinē biiko choo bānoon kiyēē ōboontē kusiir yoo kātōōsāsunēē. Yoo !kooyey kuu nyooto, mākutililiit ꞉kiy ake tukul ām wōlēē ōmiitē. ");
INSERT INTO spyNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ōmiitē sōō nyēē miyaat kule nee *꞉Farisaayeek! ‑Mōōkustooy ōnēmchi Yēyiin akeenke ām taman nyēbo kiy ake tukul nyēē ōnyōōru ānkoo ku mining' nyēē tyaa. Nteenee ‑mōōkāsē tukuuk chēē wōōyēch. Tukuuchooto ku ōyēchi chii ng'ālyoo nyēbo man āk kule ocham Yēyiin. Māchāktōōs nto kyōōyēyē tukuuchuutēchu wōōyēch ‑āmōōwuutyēē nkicheek choo minkēēch. ");
INSERT INTO spyNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ōmiitē sōō nyēē miyaat kule nee, ꞉Farisaayeek! Kyoocham ōkwēyē ng'ēchērōōk choo bo taay ām *kooriikaab saayeet. Ōchāmē mbo /kiisubooyootook nyēbo koonyit ām wōlēē chaang' ꞉biich. ");
INSERT INTO spyNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ōmiitē sōō mbo subak nyēē miyaat kule nee! Okerkeeye kiy nyēē tiliil ām saang' ankununaat ꞉wōliin bo āriit nyēē yoo kāsiir ꞉chii yēē ōmiitē, ‑mēēnkētē kule ōnuunnyootiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kumwoochi ꞉kāānēētiintēēt ake nyēbo kiruutēk Yēēsu kule, “Kāānēētiintēēt, yoo 'keeng'alaal kuu nyooto, imiitē intosuurēēch nkacheek.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kumwoochi ꞉Yēēsu nyoo kule, “Ōmiitē sōō ꞉nkakweek kāānēētikaab kiruutēk nyēē miyaat kule nee! Kyoocham ōng'irēē biiko alak tukuuk chēē nyikiisēch āmōōmāchē ꞉akweek kut ōtiiny. ");
INSERT INTO spyNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ōmiitē nyēē miyaat kule nee! Kibākāchē mbo ꞉kuukoong' *wōōrkooyik choo kibo kēny ānkōōmiitē ꞉akweek ōtēēkyinē tukuuk chēē /sikiisōōtēē /kēēkoonyitē. ");
INSERT INTO spyNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yoo ōmiitē ōtēēchē tukuuchoo, ōchāmchiintōōsii kule karaam ꞉kiyēē kiyey mbo ꞉kuukoong'. Kibakach ꞉icheek wōōrkooyik ānkōōmiitē ꞉akweek ōtāsē taay ōnoomēē yooto kibākookyinē ꞉icheek. ");
INSERT INTO spyNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ākoo man yoo kimwooyē ꞉Yēyiin kule, ‘+Māāyooktē wōōrkooyikyuu āk *lēbkēēyikyuu. +/Makeebakach alak nto alak +/mākēēwus.’ ");
INSERT INTO spyNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kunyoo, +/mākiing'woonchook akweek kāānēētikaab kiruutēk āk biiko alak choo kiikuyey kuu nyooto kuuyu kyoobakachaanu biikaab Yēyiin kung'eetee yēē /kikeeyeyee kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","/Kikiinaamee yoo /kikēēbākāchē Ābēl ākoy yoo /kikēēbākākyinē Sekaryaa yoo kibo kwēēnuutaab *kāābkōrōs āk *Kōōtaab Yēyiin. Man, +/mākiing'woonchi bichoo tukul ꞉choo yēyē ng'aleechaa miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ōmiitē ꞉akweek kāānēētikaab kiruutēk nyēē miyaat kule nee! Ōbērē ōboontē ng'oomnānēēt nyēē wōō kurubta keey ākoo Yēyiin. Nteenee kyootay orub kiyēē mākwook ꞉Yēyiin kule oyey. Ōkērēktooy mbo biiko alak kuyey kiyēē mākyinē icheek ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yu kang'eetee ꞉Yēēsu yooto ākoo rubiikyii, kwoowēsyi ꞉kāānēētichoo bo kiruutēk āk *Farisaayeek ānkutoow kuteebaatee tēēbuutēk chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kimāchē ꞉bichoo kule kutech Yēēsu ām kiyēē mākumwooy /sikeenam. ");
INSERT INTO spyNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kikwa ꞉biiko ānkōōruruukyi keey yēē kimii ꞉Yēēsu kut kukuunykuuny ꞉mētēwook. Yooto, kung'āloolchi ꞉Yēēsu rubiikyii kule, “Ōriibēē keey ng'aleekaab Farisaayeek, kuuyu yēyē keey ꞉bichu kule kāroomēch, nteenee māwuu nyoo. ");
INSERT INTO spyNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kiy nyēē iyēēnoot +/mākiiboor, nto kiy nyēē wunyaat ākoy kutook bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kiy nto ng'ālyoo ake tukul nyēē mwooyē ꞉chiito kōōsōōtē kule tōōs mēēbērē /makeekas, kusyooru keey ꞉ng'ālyoontoonoo bēsyēēt ake. Nto yoo kāchoomchi ꞉chii ake ng'al kumiitē kōōto nyēē maalaat, ākoy /kēēkāsunēē ng'aleechaa saang'.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kutas taay ꞉Yēēsu kumwoochi rubiikyii kule, “Biikyuu, ‑mōōmuyēē biiko choo boonto kāāmuukēywēēk kubakach bōōrwoonikwook, nteenee māboonto kāāmuukēywēēk kusiir yooto. ");
INSERT INTO spyNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mii ꞉nyēē māchāktōōs ōmuyēē! Boonto ꞉nyooto kāāmuukēywēēk kutōōrchook wōlēē bo maataab kibchuulyo, yoo kōōbēku. ");
INSERT INTO spyNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","/Kyooltēē oob kootiitiiyēēnik muut beesaan chēē mābo laat? Ānkoo kuwuu nyooto, mēēbērē mākuwuutyēē ꞉Yēyiin ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ntēē inkētē mbo ꞉Yēyiin wōlēē tēē ꞉buutēēk ām mētitaab chiito. Kunyoo, ‑mōōmuuyē, kuuyu isōōtook akweek ꞉Yēyiin miisin kusiir kootiitiiyēēn chēē chaang'.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kutas taay ꞉Yēēsu kumwoochi rubiichoo kule, “Yoo kāchāmchiin ꞉chii ām taayeetaab biiko kule chāmoo, +maacham ꞉nkanii, *Wēritaab Chii, chiichoo ām taayeetaab *malayikaanikaab Yēyiin kule chiinyuu. ");
INSERT INTO spyNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nteenee nyoo kataya ām taayeetaab biiko, +maatay ꞉nkanii ām taayeetaab malayikaanichaa. ");
INSERT INTO spyNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","+/Mākēēnyōōchi kaat biiko choo ng'āloolēēnoo nyēē miyaat, nteenee ‑/mākēēnyōōchinē kaat biiko choo chubē Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yoo /kākiiyyoong'tēēnook kōōk ām kōōkwōōsyēkaab Yuutayeek āk chēbo bāytooyik alak, ‑mookany kooyiimaak mēt ꞉kiyēē +moomwaay nyēē ōtuuchēē keey. ");
INSERT INTO spyNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mākukōōnook yooto ꞉Tāmirmiryēētaab Yēyiin ng'aleek chēē +moomwaay.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yu keewaany ꞉Yēēsu ng'aleechaa, kumwooy ꞉chiito ake ām biiko kwēēn kule, “Mokoryoontēēt, mwoochinoowoo baa ng'eetaabiya kubchēwoo tukuukaab baaba.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kukētyi ꞉Yēēsu chiichoo kule, “Mānāmoo ꞉ng'ala chēē wuu choo.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kumwoochi ꞉Yēēsu biiko kule, “Ōriib keey! Māmāchāktōōs ōtukuulchinē keey tukuuk ām kōōrooni, kuuyu mārubtooy keey ꞉soboonto nyēbo man āk bāytit nyēē boonto ꞉chii.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kutas taay ꞉Yēēsu kurār tyoonkōōchēēt ake kule, “Kimii ꞉chiito ake nyēē kiboonto mbareenyii nyēē wōō. Kiyey ꞉āmiik ām mbaraanaa miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yooto, kumwaayee moo kule, ‘+Maayey kule nee? Ākōnōrēē ānō āmiichu tēē chu tukul?’ ");
INSERT INTO spyNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kumwooy kule, ‘Kiito nyēē miitē, +maaburyeet chookēēnik choo kōbo kwaak ankaateech chēē wōōyēch. Mākukōōno ꞉chooto bārooyinto wōlēē +maakonoree āmiikyuu tukul āk tukuukyuu tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yoo kaakonor, āmwoochi keey kule: Kany atankas ankaabaybayiitu kuuyu kaakonor āmiik chēē yēmoo ām kēnyiisyēk chēē chaang' choo kwoonii.’ ");
INSERT INTO spyNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nteenee kumwoochi ꞉Yēyiin chiichoo kule, ‘Iberber sōō kule nee! Mii /bokiinēmunēēniing' soboonng'uung' kwēēmowuuni. Kunyi ii, mākubooyiit ng'oo ꞉tukuuchoo 'keekonor?’ ");
INSERT INTO spyNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kunyoo, berber ꞉chii nyoo itukuulchinē keey bāytit ām kōōrooni āmātinyē bāytit ām wōlēē mii ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yooto, kumwoochi ꞉Yēēsu rubiikyii kule, “Kunyoo, āmwoowook kule ‑mooyiimee keey kule ō-āmē nee, nto kule ōloochē nee. ");
INSERT INTO spyNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wōō ꞉soboon kusiir āmit nto sirooy. ");
INSERT INTO spyNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Māchē ōkāsēē tāriitēk. Māchoonsē, mākēsiisyē āmātinyē mbo chookēēn, nteenee tākubāyē ꞉Yēyiin. Ntēē ōbooyē ꞉akweek koomānuut ām wōlēē mii ꞉Yēyiin kusiir tāriit! ");
INSERT INTO spyNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mātāsyinē keey ꞉bēsyēēt mbo akeenke yoo keeyiimee keey ꞉chii soboontaab kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nto yēē ākoo ‑mēēmuuchē ꞉yooto kuyēētyēēchook kiy mbo kisich ii, nyēbo nee kooyiimaak ꞉tukun mētēwoy?” ");
INSERT INTO spyNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kutas taay ꞉Yēēsu tākumwooy kule, “Okas baa, wōlēē wuu ꞉taabta ake tukul ām wuuyēēt. Māchiiryootē āmāyēchinē keey sirooy. !Kāāmwoowook, ānkoo kiboonto ꞉Sōlōmōōn bāytit nyēē tyaa, kimāboonto sirooy chēē kāroorānēch kuu ꞉toobtōōchoo. ");
INSERT INTO spyNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nto akweek chu ‑mōōkoosēēnoo keey kuyem ii, yoo imuuchē ꞉Yēyiin kookaraaran toobtōōy choo lēēltōōs raat nto nyēē mā tyaa kurarach, kucham nee wōlēē makoolaaktaak akweek? ");
INSERT INTO spyNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","‑Mooyiimee keey ng'aleekaab āmiik nto ng'al alak tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Biiko choo ‑mēēnkētē Yēyiin ꞉chēē wuulyootēē tukuuchoo tukul, nteenee inkētē ꞉Kōōn kule ōmāchē ꞉akweek tukuuchoo. ");
INSERT INTO spyNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kuchamta ꞉chii kurook bāytooyiisyēētaab Yēyiin. Yooto, mākurōōrōōt ꞉tukuuk chuut alake. ");
INSERT INTO spyNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‑Mōōmuuyē ꞉akweek, biikyuu choo ōng'ērinēch, kuuyu kōōkuchāmwook ꞉Yēyiin kule ōwut Bāytooyiisyēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","‑Mōōtukuulchi keey tukuuk chēē ōboontē, nteenee ōyēētyēēchinēē choo boonto nyalilta. Yoo kooyey kuu nyooto, +mōōnyōōru bāytit nyēē mābēku ām Kaab Yēyiin. Māmii wōlooto ꞉chōōriin āmāmii ꞉kuutya nyēē makunyeeree. ");
INSERT INTO spyNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tiiyēē ꞉chii mēt wōloo miitē ꞉bāytinyii.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kutas taay ꞉Yēēsu subak kumwooy kule, “Oyeyte keey nyēē karaam obakaakte taariinek kulāytōōs. ");
INSERT INTO spyNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Okerkeyiitu motwoorik chēē mii kukānyē mokoryoontēēng'waa kōōyēēwunēē saakweetaab kooyēēy. Yoo ōchōbootiin, +mōōyootyi mokoryoontēēt kurkeet areet akeenke, yoo kēēng'ēētiis. ");
INSERT INTO spyNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","+/Mākiibēruur motwoorik choo /kākēēnyōōr kukāsu. !Kāāmwoowook, mākuyēytoochi ꞉mokoryoontēēt motwoorichoo āmiik ankubay ꞉inee nkityō. ");
INSERT INTO spyNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Imuuchē ꞉mokoryoontēēt kuyit ām āsiiswēk alak tukul. Imuuchē ku kwēēmooy kwēēn nto kumānēērir ꞉kōōrēēt. Nteenee ām asiista ake tukul nyēē kayit, +/mākiibēruur motwoorik choo kānyōōr kuchōbootiin. ");
INSERT INTO spyNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Māchāktōōs ōrōōtootē ng'ālyoontooni: Nto inkētē ꞉chii āsiiswēk chēē isābunēē ꞉chōōriin, nto riibē kayta ‑/mākēēbut. ");
INSERT INTO spyNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kunyoo, ōchōbē keey ꞉nkakweek, kuuyu makucheeraak *꞉Wēritaab Chii.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yooto, kuteebee ꞉Bētērō Yēēsu kule, “Mokoryoontēēt, acheek nkit ꞉chēē imiitē imwoowēēch ng'aleechu, nto chii ake tukul?” ");
INSERT INTO spyNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kukētyi ꞉Yēēsu kule, “Motwooriin ꞉nyēē ikoochinē ꞉mokoryoontēēnyii kōōyyoonkyi chuut ku nyēē /kiikoosēē keey ānku ng'oom. ");
INSERT INTO spyNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","!Kāāmwoowook, yoo karub ꞉motwooriintoonoo kuu wōlēē māktooy ꞉mokoryoontēēnyii, kōōbēruuroot. +/Makiilaang'tee kōōyyoonkyi tukuuk tukul chēbo kayta. ");
INSERT INTO spyNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Imuuchē koosoot ꞉motwooriintoonoo kule lōō yēē wokōōyēēwunēē ꞉mokoryoontēēt. Yooto mākubirsēēt motwoorik chuut kusiir yēē kātāyibē nyēē karaam ānkōōbootyi āsiiswēkyii āmiisyēēt āk yyēēsyēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nto yoo kayit ꞉mokoryoontēēt kumēēnkētē ꞉motwooriintoonoo /ānkēēnyōōr kumiitē kuyēyē kuu nyooto, +/mākēēlālchi /ānkēēwēēkyi komosta nyoo bo choo ‑/mākiikoosēē keey. ");
INSERT INTO spyNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","+/Mākiing'woonchi chiichoo miisin, kuuyu kēēnkētē kiyēē /kākēēmākyinē kule kuyey āmēēbērē kayey kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nteenee chii ake tukul nyēē ‑mēēnkētē kiyēē /kēēmākyinē kule kuyey āmēēbērē kayey, mēēbērē nyōōru ꞉nyoo ng'wooninto nyēē wōō kuu nyoo inkētē. Chii nyoo /kākiikoochi bārooyinto nyēē wōō kuyeyee kiito ake, +/makeemakee kiy nyēē wōō. Nto yoo /kākiikoochi ake kāāmuukēywēēk kusiir chēbo ake, +/makeemakee kiy nyēē wōō kusiir nyēbo nyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kumwooy ꞉Yēēsu subak kule, “Kichāātoowu maata nyēē mākōōtiliil biiko ām kōōrēēt. Lēyyē, ābērē nto /kaakiinaam mayi kuwōōyiit. ");
INSERT INTO spyNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nteenee +/mākiibuuntēēnoo nyāliluutēk ām bēsyōōsyēk choo kwoonii ankaakukinyaataa ꞉ng'aleechu ākoy bēsyēēt nyoo mākubēkunēē. ");
INSERT INTO spyNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ōsōōtē akweek kule āchōōntooy tāloosyēēt kōōrooni? Acha! Āyibu nyalilta ākoo bcheyateet. ");
INSERT INTO spyNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Makubchey keey ꞉biikaab kayta ake. Yoo kā muut ꞉bichoo, makuchama ꞉sōmōku ankutaya ꞉chuut āyēēnku, nto mā nyoo, kuchama ꞉āyēēnku ankutaya ꞉sōmōku. ");
INSERT INTO spyNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Makuchama ꞉wēēriit kutaya ꞉kwaan, nto kutaya ꞉wēēriit kuchama ꞉kwaan. Mākuchuunchuun ꞉chēēbto āk kaamet. Mākuyil ꞉koonyit nyēē kōboontēē keey ꞉koorkēētaab wēēriit āk cheebyoosyeetaab biikooy.” ");
INSERT INTO spyNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yooto, kuwēēkyi keey ꞉Yēēsu biiko ānkumwoochi kule, “Yoo kookas boolteet kuloong'unēē tinkeey, ōmwooyē kule, ‘Mākurōōbēn ra,’ kuyeyakay kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nto yoo kāwusunēē ꞉yoomeet komostaab sōōy, ōmwooyē kule, ‘Makulay ra ꞉asiista,’ kuyeyakay kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ōbērbērēch! Ōbērē tōōs ōnkētē chēē chaang'. Ōnkēt ōmwoowu kiyēē ibooru ꞉wōliin bo barak āk ng'wēny ‑āmōōnkētē kiyēē mii kuyēyāktōōs bēsyōōsyēchu. ");
INSERT INTO spyNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ām nee yu simōōnkētē ꞉akweek kiyēē bo man? ");
INSERT INTO spyNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yoo mii ꞉chiito ake wokōōyyoong'tēēniing' kōōk, kumāchāktōōs isyeem simōkāsyiinē āk chiichoo kutoombo kōōyiititiing' kōōk. Yoo kameeyey kuu nyooto, kōōmuuchē ꞉chiichoo wokurating'. ");
INSERT INTO spyNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nto yoo /kaakeerating', mēēbērē /makiityaaktiing' ākoy yoo 'keeyaakte bēsēntaab biich.” ");
INSERT INTO spyNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yooto, kukwoonchi ꞉biiko alake Yēēsu ānkumwoochi kule, “Kibakach *꞉Bilaato Yuutayeek alak chēbo Kalilaaya yoo kiyibu tukuuk /kēēbēēlchinēē kōrōsēēk ām *Kōōtaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kuteebee ꞉Yēēsu bichooto kule, “Ōbērē ꞉akweek kiboonto ꞉bichoo ng'ōōkisto nyēē wōō kusiir Yuutayeek alak? Ara ꞉kiyooto sōō nyēē kiyey /sikeebakach? ");
INSERT INTO spyNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Acha! Māwuu nyoo. Nteenee yoo kamooweekse ām miyootyēēt nyēē ōboontē +mōōbēku ꞉nkakweek kutukul. ");
INSERT INTO spyNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nto yoo kiturbubchinē ꞉kiyoo ki kooy miisin ām Siloowaam biiko taman āk sisiit kubēk ii, ōbērē ꞉akweek kiboonto ꞉bichoo ng'ōōki nyēē wōō kusiir biiko tukul ām Yēērusālēēm? ");
INSERT INTO spyNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Māwuu nyoo, nteenee yoo kamoobakaakte ng'ōōkiswookikwook +mōōbēku ꞉nkakweek kutukul.” ");
INSERT INTO spyNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nto mii yoo, kōōboorunēē ꞉Yēēsu tyoonkōōchēēt kule, “Kiboonto ꞉chiito ake mbareetaab *musābiibuunēk. Kimii ꞉kēētit ake mbaraanaa nyēē /kikēēkuurēē *mutiiniit. Kiirwoomē ꞉chiichoo kēētooto kwaak ānkōōsyoochē āmānyōōru lokoyaa. ");
INSERT INTO spyNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kinyit ꞉kēētoo chiichooto yooto, kumwoochi nyēē kiyēytooy mbareet kule, ‘Kēnyiitaab sōmōk ꞉nyi ārwoomē kēēti āmāānyōōru kiy! Ntēē kaker mbareet buch. Kunyi, iluultē!’ ");
INSERT INTO spyNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kukētyi ꞉chiichoo kule, ‘Mokoryoontēēt, kany tākēēriibēē kēnyiiniitēnyi baateey! Āmāchē ayeyte ām kēēlto nyēē karaam kusiir kwaak āroonkyinē buurēēsik. ");
INSERT INTO spyNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yoo kātēbi kut kuyey lokoyeek, ku karaam, nto yoo kamayey, iluultē!’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yu ki bēsyēētaab *Sabaato kōōnēētiis ꞉Yēēsu ām kōōto ake nyēbo saayeet. ");
INSERT INTO spyNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kimii ꞉cheebyoosyeet ake kōyooto nyēē kikuuykuuyoot ꞉suweet ām kēnyiisyēk taman āk sisiit. ");
INSERT INTO spyNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yu kakas ꞉Yēēsu cheebyoosyaanaa, kukuur kuchō taay ānkumwoochi kule, “Cheebyoos, kaatyaaktiing'!” ");
INSERT INTO spyNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kutiinyēē ꞉Yēēsu cheebyoosyeet āwunnyēk. Yooto, kuchuulakay ꞉suweetaab cheebyoosyaanaa bakeenke ānkusilto Yēyiin kubirchinē kōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nteenee kinyēēr ꞉kāāyyoong'iintēētaab kōōtaab saayeet kuuyu kiisoobiis ꞉Yēēsu yēē ki *Sabaato. Kimwoochi biiko kule, “Mii ꞉bēsyōōsyēk lo chēē /kēēyēyēē yiisyēēt. Chooto ꞉chēē māchāktōōs ōkwoonii /bokiisoobook āmēēbērē bēsyēētaab *Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yooto kulē ꞉Yēēsu, “Kiblembechiisyechu! Ntēē ōyēyiisyē ꞉nkakweek yēē Sabaato! Ōmāchē ōmwoowoo kule ‑mōōtyoochē tany nto ku sikiryo ānkōōkwēr wokuyye bēēko yēē bēsyēētaab Sabaato? ");
INSERT INTO spyNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kikiikurat ꞉Kibrōkōsyoontēēt cheebyoosyaani kēnyiisyēk taman āk sisiit. Nteenee kēēkoosēē keey Yēyiin kuu *Abraam. Ara kaayey ꞉anii ng'ālyoo nyēē miyaat atyaaktee nyalili ām bēsyēētaab Sabaato?” ");
INSERT INTO spyNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kichusyo ꞉buunikaab Yēēsu, nteenee king'ērēkiis ꞉biiko alake kubo tukuuk chēē /kiilātē chēē kiyey ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kiineet ꞉Yēēsu ng'ālyoo kurubta keey āk Bāytooyiisyēētaab Yēyiin. Kiteebee biiko kule, “Wuu nee ꞉Bāytooyiisyēētaab Yēyiin? Nto +/mākiiboorunēē nee? ");
INSERT INTO spyNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Okany āmwoowook, kerkeey kēbuswoontēēt ake nyēē mining' nyēē /kēēkuurēē *aritaaliit. Yoo kabiit ꞉kēbuswoontooni, kuwōōyiitu ankusabach kut koomuuch kuminy ꞉tāriitēk.” ");
INSERT INTO spyNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kimwoochi subak ꞉Yēēsu biiko kule, “Kerkeey ꞉Bāytooyiisyēētaab Yēyiin ");
INSERT INTO spyNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","yoo kanam ꞉cheebyoosya tukun choo ikuutu bus ankutankwarta busyeek chēē chaang' kut kukuut miisin.” ");
INSERT INTO spyNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nto mii yoo, kumur ꞉Yēēsu kiriinkōōsyēk āk soong'wēk kōōnēētiisyootē yooto tukul kutākyinē keey Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yooto, kuteebee ꞉chiito ake kule, “Mokoryoontēēt, makooraraach ꞉Yēyiin biiko chēē ng'ēri sōō baateey?” Kukētyi ꞉Yēēsu kule, ");
INSERT INTO spyNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","“Mariich ꞉kurkeetaab Kaab Yēyiin. Kunyoo, kōōkiil keey ꞉chii sukōōwut kutakuyaataat ꞉kurkeet, kuuyu yoo kāākutēmēl ꞉chiitaab kōōto makusyeem ꞉biiko chēē chaang' kule kōōwut, nteenee mēēmuukāksē. Nto choo /kaakeekerta saang' ānkōōkōnykōōny kurkeet /kēēyootyi, kumwoochinē choo ꞉Mokoryoontēēt kule, ‘‑Māānkētook.’ ");
INSERT INTO spyNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Makuriiree keey ꞉bichoo kule, ‘Ntēē kikyoomiisyootē tukul 'ānkiinēētiisyootēē soong'wēkyoo!’ ");
INSERT INTO spyNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mākumwooy ꞉Mokoryoontēēt kule, ‘‑Māānkētook, āmēēbērē +mōōwut kōyi kubo miyootyēēt nyoo ōboontē. Kunyoo, ōbēēchi keey!’ ");
INSERT INTO spyNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","+Mabokuriirunee ꞉biiko chēē chaang' ng'wēny kule nto kisimkusyeem kōōwut /kumanaakeeker kurkeet. Kumii kēēyyoong'iis saang', mākukāsē *Abraam, Isaka, Yāākōbō ākoo *wōōrkooyikaab Yēyiin tukul choo mii kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Makukwaanee ꞉biiko komoswookik tukul ām kōōrēēt kumukuul ānkunyōōr ātēbng'waa ām Kaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nteenee ōrōōtootē ng'ālyoontooni: Mākubooyiit lēt ꞉choo yibē keey barak, nto choo yibē keey ng'wēny, makoonto.” ");
INSERT INTO spyNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kikwoonchi yooto *꞉Farisaayeek alake Yēēsu ānkumwoochi kule, “Yoo imāchē isob, ing'eetee yu, kuuyu mii *꞉Ērōōtē kuchēēng'iing' kumāchē kubakachiing'.” ");
INSERT INTO spyNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kukētyi ꞉Yēēsu Farisaayeechaa kule, “Obe bōōmwoochi kimōkōyiinoo kule tāātāsē ꞉anii taay ābēbēētootē tāmirmirook chēē miyootēch ānkāāmiitē āsoobootē biiko raat āk tuun, nteenee +māāyityi tabanta ām bēsyēētaab sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Man sinee kule +māāwēēsyētē raat, tuun āk kōōyyiin. Māyēmāktōōs kumēēchi *꞉wōōrkooyoontēētaab Yēyiin wōlto ake tukul yoo mā Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wōōy, wēē, Yēērusālēēm, wē, Yēērusālēēm! Irumē wōōrkooyik ānkiiwiirēē rwoontōōk biiko choo iyooku ꞉Yēyiin kule kuyisuung'! Kyaasyeem kunyil areet chēē chaang' kule āyisu biikuuk kuu wōloo yisuntooy ꞉nkokya kinyiinyiiyēēnik kōōwut kebebaakyii, nteenee mānēēkōōnoo kut ayey kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kunyi kuyoochiin ꞉kāng'woong'. !Kāāmwoowook, kuchakee raat kuwo taay mātābōōkāsoo, ākoy omwaay kule, ‘Ibēruuroot ꞉nyoo chōōnii ām kaayneetaab Yēyiin.’” ");
INSERT INTO spyNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nto mii bēsyēēt ake, yēē ki bēsyēētaab *Sabaato, kuwo ꞉Yēēsu kaytaab chiito ake nyēē ki akeenke ām *Farisaayeek chēē ki wōōyēch. Kimii nkicheek ꞉Farisaayeek alake kayaata. Kimii kuchēēng'ē kukas yoo makuchwees ꞉Yēēsu bēsyēētaab *Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kimii ꞉nkinee chiito ake yooto nyēē kiikwaanaat ꞉bōōrto. ");
INSERT INTO spyNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kuteebee ꞉Yēēsu Farisaayeechaa āk kāānēētikaab kiruutēk kule, “Chāmwēēch ꞉kiruutēk /kiisoob chii yēē bēsyēētaab *Sabaato, nto acha?” ");
INSERT INTO spyNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mānāāwāl kiy ꞉bichoo. Yooto, kunam ꞉Yēēsu chiichoo āwut ānkōōsoob nto yityo, kumwoochi kuwēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nto mii yoo, kuwēēkyi keey ꞉Yēēsu Farisaayeechaa ānkumwoochi kule, “Yoo kēēsuuchi ꞉lakwang'uung' nto ku teeng'uung' ng'wēēn yēē *Sabaato, ichuutunēē ng'wēēn oob areet akeenke?” ");
INSERT INTO spyNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mānāāwāl kiy ꞉bichoo. ");
INSERT INTO spyNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yu kakas ꞉Yēēsu wōlēē kimii ꞉tāyēēk kulēkwēltooy ātēbto /kēēmāchē /kyoomiis, kumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Yoo /kākēēkuurook obe saakwa ake tukul, ‑mōōmoymooyē ng'ēchērōōk chēbo koonyit. Āmwooyē kuu nyooto, kuuyu imuuchē kuyit ꞉toontēētaab kayaata nyēē koonyitoot kusiiring'. ");
INSERT INTO spyNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mākukwēryoon ꞉chiitaab kayta toontoonoo ankuchokoong'eeteeniing' yoo 'kēēbuurēē ankookeering' ꞉toontoonoo. Yooto, +mēēchus ankiicheeng' ng'echer ake tukul nyēē kākēluung'. ");
INSERT INTO spyNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nto kiyēē māchāktōōs ōyēyē ku nyi: Ōtēbēē ng'ēchērōōk choo bo lēt. Inkētē ꞉ng'oo yoo kāchō ꞉chiitaab kayta ankukasing' imiitē 'kēēbuurēē yooto, makoong'eetiing' wēētēbēē ng'echereet nyēbo taay. Yooto, +/mākēēkoonyitiing' ām taayeetaab tāyēēk chuut. ");
INSERT INTO spyNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kunyoo, chii ake tukul nyoo yibē keey barak +/makiichuchuuk. Nto nyoo yibē keey ng'wēny, +/mākiitōrōōr.” ");
INSERT INTO spyNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nto mii yoo, kukētyi keey ꞉Yēēsu chiitaab kayta ānkumwoochi kule, “Yoo 'keeyey saakweet, māmāchāktōōs ikuurē baateey chōōrōōnuutēkuuk, mbo ng'eetaabkoomēt, tilyōōnuutēkuuk nto laatoosyekuuk choo mokorēēn, choo inkētē kule mākukuuring' nkinyiing' bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nteenee māchāktōōs ikuurē bānoonik, choo ing'wooltōōs, choo sōnkōchootiin āk cheebkoraatiisyek ");
INSERT INTO spyNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","choo ‑mēēmuuchē kukuuring' bēsyēēt ake. Yooto, mākōōbēruuriing' ꞉Yēyiin ānkutuwēniing' ām bēsyoonoo ing'ēētēē meet biiko choo churtootiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yu kakas ꞉chiito ake nyēē kyoomiisyē ākoo Yēēsu ng'aleechaa, kumwooy kule, “Ibēruurootiin sōō, kule nee ꞉biiko choo +mābokwoomiis ām saakweet nyoo bo Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kukētyi ꞉Yēēsu chiichoo kule, “King'eet ꞉chiito ake kuyey saakweet nyēē wōō ānkukuur biiko chēē chaang' kukwa saakwaanaa. ");
INSERT INTO spyNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yu kayit ꞉bēsyēēt nyēē /kikyoomēē saakweet, kōōyookto motwooriintēēnyii wokumwoochinoot bichoo kukwa. ");
INSERT INTO spyNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nteenee kitoow ꞉ake tukul ām bichooto kusoom nyooyeetaab kaat kuuyu kimēēmuuchē kuchō. Kimwooy ꞉ake kule tākumiitē kumārārē mbareet nyēē kitākwoolē. ");
INSERT INTO spyNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kulē ꞉ake kitākwoolē yeeyiikyii taman kunyoo, kimii wokusyēēmtooy. ");
INSERT INTO spyNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nto ake kumwooy ꞉nyoo kule kitākōōmutiisyē kunyoo, kimēēmuuchē kut kuchō. ");
INSERT INTO spyNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yu keeyeey ꞉motwooriintoonoo kaa, wokumwaayta riirikaab bichoo. Yu kakas ꞉chiitaab kayta kuu nyooto, kunyēēr. Kōōyookto motwooriintēētkēy kubuntootēē kēēlwookik choo wōōyēch āk choo minkēēch ām *kiriinkēēng'waa wokukuuroot chii ake tukul nyēē banan nto nyēē sōnkōchoot nto nyēē ing'woolē ākoo nyēē koraat. ");
INSERT INTO spyNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ānkoo kiyey ꞉chiichooto kuu nyooto, kitakubaraay ꞉kōōto. ");
INSERT INTO spyNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kumwoochi ꞉chiichoo motwooriintēētkēynyii subak kule, ‘Āmāchē tāwēēkuurootē biiko alak kukwaanaatee rōōrōōkiisyēk tukul chēbo yēēmooni. Kany kuchō ꞉chii ake tukul nyēē 'kēētuuyēē nto anyuun koonyiit kōyi.’ ");
INSERT INTO spyNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Māmii ꞉chii mbo akeenke ām bichoo /kōsimkēēkuur nyēē makucharee kiy mbo kisich nyoo /kōōkēēyēytoochi.” ");
INSERT INTO spyNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yooto tukul, kimii kurubootē ꞉biiko chēē chaang' Yēēsu. Kuweech keey ꞉Yēēsu kukas bichoo ānkumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Chii ake tukul nyoo māchē kuruba, kumāchāktōōs kuchama kusiir wōlēē chāmtooy kwaan, kaamet, koorkēēnyii, lōkōkyii, mbo ng'eetaabkaamet nto mbo cheebkaamet ankuchamta mbo soboonnyii kubo anii. Yoo māwuu nyoo, māyēku rubiintēēnyuu. ");
INSERT INTO spyNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Māmii ꞉chii nyēē imuuchē kuyēk rubiintēēnyuu yoo kamamuyta ng'wooninto nyēē mākunyōōr kubo anii. ");
INSERT INTO spyNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ng'oo ām akweek ꞉nyēē imuuchē kuteech kōōto yoo mānēēbuur ng'wēny ānkōōyiit tukuuk chēē boonto yoo yēmē kutēēksēē? ");
INSERT INTO spyNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yoo ‑kāmēēyiit, kōōmuuchē kutoow tēēksēēt nto mii kwēēn āk kwēēn, kurār ꞉tukuuk. Yooto, mākuroorchi ꞉biiko kule, ");
INSERT INTO spyNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Kookas murooniin, kosyeem kutēēkso, nteenee kōsimkurārchi ꞉tukuuk kumanaayit ꞉kōōto teket.’ ");
INSERT INTO spyNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nto, māmii ꞉bāytooyiintō nyēē imuuchē kurat keey kule kuwo booryēēt, yoo mānēēbuur ng'wēny āk biikaab kōōkwēēnyii. Mākyiintōōs kukas yoo imuuchē ꞉lukēēnyii nyēbo murēnik kisyēērōōk taman, kōōbēl buunik kisyēērōōk tibtēm. ");
INSERT INTO spyNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yoo kāsē kule mēēmuuchāktōōs, kumāchāktōōs kōōyookto alamaalyeet wokung'āloolchi buunik kutākumii wōlēē lōō sukung'eet kōōchoomnyo keey. ");
INSERT INTO spyNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kunyoo, chii nyoo māchē kuyēk rubiintēēnyuu, māmāchāktōōs kuyēētyi keey soboontaab kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Karaam ꞉muunyeet. Nteenee yoo kaakumiyatiit, mēēbērē tākumii wōlēē /kēēyēytooy sitakukaramiit. ");
INSERT INTO spyNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Muunyeet nyoo ‑meekukaraam, mēēbērē /tākēēyēyēē kiy. ‑/Mākiisēērēē mbo mbareen kule sukooneer āmiik. Yoo kaakumiyatiit ꞉muunyaanaa kumāchāktōōs /kēēlulukto. Nyoo yēbē yiit, kukas.” ");
INSERT INTO spyNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kimii ꞉yēē kikwoonchinē Yēēsu ꞉kāāruruukikaab *syuuruut chēē chaang' āk biiko alak chēē kiyēyootē ng'al chēē miyootēch. Kibokuyēbchinē yiit ꞉bichoo kiyēē kiinēētē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yooto kōōng'unyng'uunyiis *꞉Farisaayeek āk kāānēētikaab kiruutēk kumwooyē kule, “Ntēē toochē ꞉chiichi biich chēē kibng'ōōkisiis ānkwoomiisyē ꞉tukul?” ");
INSERT INTO spyNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kumwoochi ꞉Yēēsu bichoo kule, ");
INSERT INTO spyNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yoo iboontē kēēchiirēkuuk bokol ānkubot ꞉akeenke, ibākookyinē oob chuut tāmānwookik sokool āk sokool yeechey ankuweecheeng'aate nyoo kābotē? ");
INSERT INTO spyNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nto yoo 'kēēnyōōru, ikālābchinē oob buuy ānkiichōōntē kaa ām ng'erekweek? ");
INSERT INTO spyNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yoo 'keeyit kaa ii, ikuurē oob chōōrōōnuutēkuuk āk laatoosyekuuk ānkubōōng'ērēkiisyē ꞉tukul kuuyu 'kēēnyōōru kēēchiiryoonoo? ");
INSERT INTO spyNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ām kēēlto nyēē wuu nyiitēnyi, makung'erech ꞉nkinee Yēyiin kubo choolwookiintēēt akeenke nyoo kākēt keey kusiir biiko tāmānwookik sokool āk sokool choo kuurē keey kule churtootiin āmāmāchē kule kuweek. ");
INSERT INTO spyNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nto yoo boonto ꞉cheebyoosya beesaanikyii chēbo koomānuut ānkōōsuuyto ꞉akeenke, tābē oob taariit ānkōōbuuch kōōto tukul kuchēēng'so kut kunyōōr beesyaantaanaa? ");
INSERT INTO spyNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ara yoo kāākunyōōr ii, kuurē oob chōōrōōnuutēkyii āk laatoosyekyii ānkubokung'ērēkiis tukul? ");
INSERT INTO spyNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ām kēēlto nyēē wuu nyiitēnyi, mākung'ērēkiis *꞉malayikaanik, yoo kaweek ꞉choolwookiintēēt akeenke.” ");
INSERT INTO spyNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kitas taay ꞉Yēēsu kumwooy kule, “Kimii ꞉chiito ake nyēē kiboonto wērikyii āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kimii ꞉yēē kimwoochi ꞉wēēriit nyēē mining' kwaan kule, ‘Abayya, āmāchē irōōbwoo tukuuk chēē cheechuu.’ Kucham kwaan. Kunyoo, kirōōbchi wēēriit nyēē wōō cheechii ānkurōōbchi nkinee nyēē mining' cheechii. ");
INSERT INTO spyNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yu kakeeyta ꞉bēsyōōsyēk chēē ng'ēri, kunam ꞉wēēriit nyi ki mining' cheechii ānkuwēēchi keey kōōr nyēē lōō. Kiwokwaamee tukuuchoo tukul keelat. ");
INSERT INTO spyNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kichō ꞉kēmēwuut kōōroonooto nyēē /kikēēbālē keey keelat. Kyaam wēēroo ꞉kēmēwuut. ");
INSERT INTO spyNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kunyoo, kuwo kaytaab chiito ake ām kōōroonooto ankuwokusaaysaay kule kōōbuurto keey sukuyēchinē yiisyō ake tukul. Kōōkoochi ꞉chiichoo kuriibē tōōrōōk. ");
INSERT INTO spyNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Māmii ꞉chii nyēē kiikoochi kiyēē kaam kunyoo, kilal ꞉kēmēwuut kut kuriik kwaam āmiikaab tōōrōōk. ");
INSERT INTO spyNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Koosootee keey ānkulē, ‘Ntēē nyōōru ꞉motwoorikaab baabaanii āmiik chēē yēmē kwaam kut kung'ēt ꞉alake. Ām nee sukubakachaa ꞉kēmēy ām wōli? ");
INSERT INTO spyNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kaykay ayeey kaa ānkuwāāmwoochi baaba kule: Kyāāchoolwookēnchi Yēyiin ākoo inyiing'. ");
INSERT INTO spyNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Māyēmāktōōs tāāyēku lakwang'uung', nteenee iyiboo kuu motwooriintēēng'uung' ake tukul.’ ");
INSERT INTO spyNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yu keewaany ꞉wēēroo koosoot kuu nyooto, kunam baanta kooyeey kang'waa. Yu makuyit kaa, kutoobēn ꞉kwaan. Kōōnkēt kule ākoo ki wēēroonyii. Kukāsyi kiisayta ankulabat wokutorooch. ");
INSERT INTO spyNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nteenee kumwoochi ꞉wēēroo kwaan kule, ‘Baaba, kyāāchoolwookēnchi Yēyiin ānkāāchoolwookēnchiing'. Māyēmāktōōs tāāyēku lakwang'uung'.’ ");
INSERT INTO spyNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kumwoochi ꞉kwaan motwoorikyii kule, ‘Ōyibu areet akeenke sireet nyoo karaam ām tukul, kimoorineet āk kwēyōōnik ānkōōlookyi wēēri. ");
INSERT INTO spyNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ōkwēru wuunweet nyoo neraat kēēyēēnkyi. Māchāktōōs kēēng'ērēkyi ");
INSERT INTO spyNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kuuyu ākoo tākusoboot ꞉wērinyuu nyi kyāābērē kiikume. Kikiikubot, neennyi kāākōōyēēw.’ Nto yityo, /kēētoow /kyaam saakweet. ");
INSERT INTO spyNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yooto tukul kimiitē ꞉wēēriit nyēē wōō mbareen kuyēyiisyē. Nto yu rōōtu kaa, kukas kutyēēntōōs ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kukuur motwooriintēēt ake ankuteebee kule, ‘Nee ꞉nyi mii kutyēēnchinē ꞉biiko?’ ");
INSERT INTO spyNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kukētyi ꞉motwooriintoonoo kule, ‘Kāākōōyēēw ꞉ng'eetaabkoomēt kuchāmē keey, kunyoo kayeeny ꞉kōōn wuunwaanaa koneraat kwaam ꞉biiko kung'ērēkiis.’ ");
INSERT INTO spyNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","King'woonchi wēēroo ki wōō kut kutay kōōwut kō. Kuchō ꞉kwaan saang' ankuchokusaaysaay kule kuwo kō. ");
INSERT INTO spyNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nteenee kumwoochi kwaan kule, ‘So, abayya! Kwāāyēwuung' ꞉anii yiisyēēt ām kēnyiisyēk chēē chaang' nyēē mānāākēwēynoon āmēēbērē 'kiikōōnoo mbo kwesta abaybaayee keey ꞉nkanii āk chōōrōōnuutēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nto yu kēēyēēw ꞉wēēring'uung' ꞉nyi kiwokwaamee tukuukuuk keelat kōōbootyi chēēmurēniis, neennyi kāchēēyēēnkyi wuunwa nyēē kōnāmē ꞉koong'ta ām biiy ing'ērēkyi.’ ");
INSERT INTO spyNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Kukētyi ꞉kwaan kule, ‘Wēnyoo, kēēboontē keey ꞉acheek āk inyiing' kwaak, anku nyeeng'uung' ꞉kiy ake tukul nyēē āboontē ꞉anii. ");
INSERT INTO spyNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Āboontē man ayey saakwaani, kuuyu kikēēbērē kiikume ꞉ng'eetaabkoomēt, neennyi ākoo tākusoboot. Kikiikubot, neennyi kāākōōyēēw.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nto mii yoo, kumwoochi ꞉Yēēsu rubiikyii subak kule, “Kimii ꞉chiito ake nyēē ki mokoryoo nyēē kiboonto chiinyii nyēē kiiyyoonkyinē komosta nyēbo beesaanik. Kiyityi chiitaab kayta ꞉ng'aleek kule kimii ꞉chiichoo kwoomēē tukuuk keelat. ");
INSERT INTO spyNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kukuur ꞉chiitaab kayta chiichooto kuwo kō ānkumwoochi kule, ‘Kwaakas ng'al chēē mā kāroomēch ām wōlēē imiitē. Kunyoo, āmāchē ichōb kiy ake tukul nyēē karaam, kuuyu āmiitē wāāyyoong'tiing' ām yiisyēēt.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Koosootee keey ꞉chiichoo yu /kābokēēmwoochi kuu nyooto ānkulē, ‘Kāāboot yiisyēēnyuu! +Maayey nee? Ntēē ‑māāboontē nkur chēē sitaayeyaatee yiisyōōnuut chēē nyikiisēch ‑āmāāriiku soomsēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aay, kāānkēt wōlēē āyēytooy yoo sāānyōōru chōōrōōnuutēk chēē sukuriibo yoo kāāboot yiisyooni.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kikuur biiko choo kiboonto bēsēntaab mokoryoontoonoo. Yooto, kuteebee nyēē kibo taay kule, ‘/Kēēyoochiing' ata?’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kulē ꞉nyoo, ‘Mwaaytaab *musēytuuniit wōōnkiichēk bokol.’ Kulē ꞉kāāyyoong'iintoonoo, ‘Man, kunyoo, isir kule konom.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kuteebee nyēē kiikēērē kule, ‘Ntēē inyiing' /kēēyoochiing' ata?’ Kulē ꞉nyoo, ‘Nkoonuuk kuniyaanik bokol.’ Kumwoochi nyoo nkinee kule, ‘Isir kule tāmānwookik sisiit.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kumwooy ꞉mokoryoontoonoo kule, ‘Ntēē ākoo ng'oomng'ook man ꞉chiichi.’ ” Kunyoo, kumwooy ꞉Yēēsu kule, “Inkētē keey ꞉biikaab kōōrooni ām wōlēē yēytooy tukuukwaa kusiir wōlēē inkētitooy icheek ꞉biiko choo kiikunyōōr lēbkēēyyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yooto, kumwooy ꞉Yēēsu kule, “Ōyisunēē beesaanik chōōrōōnuutēk chēē ām lētuunoo, yoo kāākuyēk buch ꞉beesaanik, +mabokutaachaak ōminy kooriikaab kibchuulyo ām Kaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Chii nyoo /kiikoosēē keey ānkuriibē tukuuk chēē ng'ēri, kuriibē nkicheek chēē chaang'. Nto nyoo ‑/mākiikoosēē keey āmāriibē tukuuk chēē ng'ēri, kumāriibē mbo tukuuk chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nto yoo ‑mōōriibē tukuuk chēbo mokornoontiitaab kōōrooni, ku ng'oo ꞉nyēē mākuchāmwook ōriib mokornoontiitaab soboontaab Tāmirmiryēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nto yoo ‑mōōmuuchē ōriibchi biiko alak beesaanikwaa kubo nee /kēēkōōnook chēēkwook? ");
INSERT INTO spyNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Māmii ꞉chii nyēē imuuchē kōōmēlchiin kirōkōōn āyēēng' kuuyu ākoy kulay ꞉ake. Kunyoo, mēēmuuchāktōōs /kiinoomnyo yiisyēētaab Yēyiin āk muchastaab beesaan.” ");
INSERT INTO spyNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yu kakas *꞉Farisaayeek alake kiyēē kimwooy ꞉Yēēsu, kuroorchi, kuuyu kicham ꞉icheek beesaan miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nteenee kumwoochi ꞉Yēēsu kule, “Ōyēyē keey ꞉akweek kule ōchurtootiin ām taayeetaab biiko, nteenee inkētē ꞉Yēyiin tuuyintaab moo nyēē kyoowung'te keey. Kiyēē yibē ꞉biiko kule bo koomānuut, ku buch ām wōlēē mii ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kumanaachokwaamtaat ꞉Bātisāniintēēt Yoowaana lōkōōywēk, ki siruutēk choo kikōōnu *꞉Muusa āk lōkōōywēk choo kiyibu *wōōrkooyik ꞉chēē /kikyoomu. Kung'eetee kāchō ꞉Yoowaana ākoy ra, lōkōōywēk chēē /kyoomtootē ku chēbo Bāytooyiisyēētaab Yēyiin. Nteenee mii ꞉biiko chēē chaang' kukwiilē. ");
INSERT INTO spyNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Imuuchē kubot ꞉barak āk ng'wēny nteenee mābotē ꞉ng'ālyoontēēt mbo akeenke ām siruutēchoo. ");
INSERT INTO spyNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Chii ake tukul nyoo kakwet koorkēēnyii ankoomut ake, kaakubar kooyēēyto. Nto nyoo keemut koorko nyēē kaakukwet ꞉saanteenyii kāākōōntosuur ꞉nyoo kooyēēyoo.” ");
INSERT INTO spyNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kutas taay ꞉Yēēsu kumwooy kule, “Kimii ꞉chiito ake nyēē kiiloochē sirooy chēē kāroorānēch chēbo āliisyō nyēbo barak. Kikicham ꞉chiichi kuyēyē sookwoonuut āk tukuuk chēbo leles. ");
INSERT INTO spyNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nteenee kimii ꞉ake nyēē /kikēēkuurēē Lasaaro nyēē kisyēnunoot ām ng'woowōōk miisin. /Kikikiimukoonchi kaytaab mokoryoontoonoo kurkat. ");
INSERT INTO spyNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kumii yooto bo kurkat kubērē nto nyōōr mbo seeserik, kukwoonii ꞉ng'ōōkiik bokumēēlē ng'woowōōk. ");
INSERT INTO spyNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nto mii lētuunoo chokume ꞉Lasaaro. Kuyib *꞉malayikaanik wokōōbuurto keey *Abraam. Nyēē mā tyaa, chokume ꞉nkinee chiichoo kiboonto bāytit. /Keemuy, ");
INSERT INTO spyNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","nteenee /kibokēētōōrchi tāmirmiryēēnyii wōlēē mii ꞉maata nyēē māmisē. Kumii wōlooto, kutoobēn Lasaaro kuboonto keey Abraam. ");
INSERT INTO spyNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kukuurso ꞉chiichoo kule, ‘Baaba Abraam! Ntēē keewaang'taa ꞉maata! Iriireenaa ānkiiyooku Lasaaro chokōōwutēē moorineet bēēko kutiswoo ng'elyebta.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nteenee kumwoochi ꞉Abraam kule, ‘Wēnyoo, māchāktōōs inkēt kule yoo kitēēsoboot, kiinyōōru tukuukuuk chēē kāroomēch chēē 'kiimāchē, nteenee kimii ꞉Lasaaro ng'woonin. Kunyi, miitoochi keey ra ꞉Lasaaro wōlēē nusaat, ānkiimiitē ꞉inyiing' ng'woonin. ");
INSERT INTO spyNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nto subak, mii ꞉nkōriit nyēē wōō miisin kwēēnuunyoo nyēē yoo kālē ꞉chii ake tukul nyēē mii wōli kuchō komosaa, mēēmuuchāktōōs. Māmii mbo subak ꞉chii nyēē imuuchē kuchōōnēē komosta nyoo imiitē kuchō komosi.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kumwooy ꞉chiichoo kule, ‘Baaba Abraam, mwoochinoowoo naas Lasaaro kuwo kanyoo acheek ");
INSERT INTO spyNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","wokumwoochi mbo ng'eetaabiya muut kule kuriib keey /simākēētōōrchi nkicheek wōli tēē nyi ꞉ng'woonin kōōyyiin kābēk.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nteenee kukētyi ꞉Abraam kule, ‘Kany kuyēbchi yiit siruutēkaab Yēyiin choo kikōōnu *꞉Muusa āk *wōōrkooyik.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kukētyi ꞉nkinee chiichoo Abraam kule, ‘Baaba, māyēmē kuu nyoo baateey, nteenee kaykay yoo /kāākiiyookto chiito ake nyēē kiikume. Imuuchē kuwēēkiis ām miyootyēēt nyēē kiikuyey.’ ");
INSERT INTO spyNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","/Kēēkētyi chiichoo subak kule, ‘Yoo māmāchē raat mbo ꞉ng'eetaabkoomēt kukas kiyēē kimwooyē ꞉Muusa ākoo wōōrkooyik, ku mākoy kukāsyi chii ake tukul nyēē kang'eetee meet.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nto mii yoo, kumwoochi ꞉Yēēsu rubiikyii kule, “Mii ꞉biiko chēē makuken biiko alak kutaya, nteenee mākung'woonchi sōō kule nee chii nyoo kakenta ake. ");
INSERT INTO spyNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Misyinē /kēērātyi chiichoo rwaa nyēē wōō kaat /ānkēētōōrchi araaray kuling'ta, kusiir yoo kātākēnē biikyuu choo tākukuskus ām kāāyēnēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kunyoo, ōriib keey! Yoo kāyēwuung' ꞉ng'eetaabkoomēt ng'ālyoo nyēē miyaat, iburyoong'tē. Nto yoo kāchokusooming' nyooyeetaab kaat, inyōōchi kaat. ");
INSERT INTO spyNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ānkoo kāyēwuung' nyēē miyaat kunyil areet tisab ām bēsyēēt ānkuchōōnii yooto tukul chokusoomē nyooyeetaab kaat, inyōōchinē.” ");
INSERT INTO spyNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nto mii yoo, kumwoochi *꞉lēbkēēyik Yēēsu kule, “Mokoryoontēēt, teeyeyeech kiikaasee keey Yēyiin miisin.” ");
INSERT INTO spyNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kukētyi ꞉Yēēsu kule, “Nto ōtinyē mbo kaakaaseet nyēē kisich nyēē tēē kēbuswoontēētaab *aritaaliit, nto imuuchē kukāswook mbo ꞉mōkōywooni, yoo kōōmwoochi kung'ēēwunēē keey tiikiit ankuwokuchaan keey araaray. ");
INSERT INTO spyNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Imuuchē ꞉chiito kuboonto motwooriintēēnyii nyēē ākiisyē nto nyēē ibātiisyē. Nto yoo kārōōt kaa, māchāmchinē ꞉mokoryoontēēnyii simkwoomiis, ");
INSERT INTO spyNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","nteenee māchāktōōs kubay mokoryoontoonoo kurook. Yoo kaakoowaany ꞉mokoryoontēēt āmiisyēēt, mākwoomiis ꞉motwooriintēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","‑/Mākēēbirchinē kōōnkōy kuuyu kayey kiyēē /kākēēmākyinē. ");
INSERT INTO spyNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kunyoo, yoo kooyey ꞉akweek kiy ake tukul kuu wōloo /kēēmāktooy, ōmwooyē kule, ‘Yiisyēēnyoo ꞉nyooto.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yu katas taay ꞉Yēēsu ākoo rubiikyii kumii kutākyinē keey Yēērusālēēm, kuyit yēē kibo kiyōōtēētaab yēēmēētaab Kalilaaya ākoo kōōrēētaab *Samaaryaa. ");
INSERT INTO spyNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yu kayit saang'ta ake nyēē kimii yooto, kukas biiko alak taman chēē kiboonto *makereenik. Kimāmāchē ꞉bichoo kulēēkityi Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Kukuur Yēēsu kule, “Mokoryoontēēt Yēēsu, ankiiriireeneech.” ");
INSERT INTO spyNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kumwoochi ꞉Yēēsu bichooto kule, “Bōōboorchi keey kibkōrōs.” Kuba ꞉bichoo. Nto kumii kēēltaab too, kukas keey kule kāākusobcho! ");
INSERT INTO spyNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kooyeey ꞉akeenke wōloo kimii ꞉Yēēsu ānkusilto Yēyiin kukuurchinē barak. ");
INSERT INTO spyNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kukutuny ānkuyim kutiiny ꞉tokochta ng'wēny ānkubirchi Yēēsu kōōnkōy ānkoo kibo kōōrēētaab *Samaaryaa ꞉chiichi. ");
INSERT INTO spyNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kumwooy ꞉Yēēsu kule, “Kāmā taman ꞉bichoo kāāsoobē? Mii ānō ꞉chuut sokoolu? ");
INSERT INTO spyNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ntēē sukōōyēēw naas nyi ꞉soboyiintō akeenke chokubirchi Yēyiin kōōnkōy?” ");
INSERT INTO spyNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kumwoochi ꞉Yēēsu chiichoo kule, “Ing'eet ānkiiwēēchi keey. 'Kēēsob kuchurta kuuyu 'kēēkoosēēnoo keey.” ");
INSERT INTO spyNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nto mii yoo, kuteebee *꞉Farisaayeek alake Yēēsu kule, “Chōōnii āyu ꞉bāytooyiisyēētaab Yēyiin?” Kukētyi ꞉Yēēsu kule, “Māmii ꞉kiyēē ibooru yēē chōōnii ꞉bāytooyiisyoonoo kuu wōloo ōsōōtitooy ꞉akweek. ");
INSERT INTO spyNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Māmii mbo ꞉chii nyēē mākumwooy kule, ‘Ong'nyiin’ nto ‘Ong'nyi.’ Ntēē ōboontē keey kēny Bāytooyiisyēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kutas taay ꞉Yēēsu kumwoochi rubiikyii kule, “Makukwa ꞉bēsyōōsyēk chēē +moomwaay kule nto āyēēwu ꞉anii, *Wēritaab Chii. Nteenee ‑mōōkāsoo. ");
INSERT INTO spyNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","+Mōōkāsē /kēēmwooyē kule, ‘Kāākōōyēēw! Ong'nyiin mii yuun!’ nto ‘Ong'nyi mii yu!’ ‑Moobe kule boocheeng'aataa, ");
INSERT INTO spyNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","kuuyu mābotwook yoo kāāchōō. Makukerkeyiit yoo keewech kulebkeyiit ꞉kōōrēēt tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nteenee +maanyalil kurook nyēē ‑/mākyoomu ankutaya ꞉biiko choo ‑mēēyēnwoo. ");
INSERT INTO spyNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Makukerkeyiit mbo ꞉yoo kariik kōōyēēwunēē ꞉Wēritaab Chii āk bēsyōōsyēchoo kibo Noowa. ");
INSERT INTO spyNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kyoomiisyē yooto ꞉biich ānkuyyēēsyē ānkōōmutiisyē ākoy bēsyoonoo kiiwutē ꞉Noowa āk biikyii mwēēnkēēt. Nto mii yoo, kuchō ꞉taambiliilyeet kōōrēēt tukul nyēē kiimukuus biich. ");
INSERT INTO spyNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Makukerkeyiit mbo subak ākoo bēsyōōsyēchoo kibo Lōōt. Kiwuulyootēē ꞉biiko yiisyōōnuutēkwaa kuu kwaak kwoomiisyē ānkuyyēēsyē, kiyēyē mung'aareeng'waa, kichoonsē ānkutēēchē kooriikwaa ");
INSERT INTO spyNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ākoy bēsyēēt nyoo kibākooktooy ꞉Lōōt Sōtōm. Yooto, kuroong' ꞉Yēyiin aryaanteet ake nyēē layaat ām barak nyēē wuu roob. Kiimukuus biiko tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Makunyach biich nkinee *꞉Wēritaab Chii ām kēēlto nyēē wuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yoo kanyoorta ꞉ng'aleechu chii saang', ‑meeyeey kō wokōōruruuch tukuukyii ameeyeey kaa mbo ꞉choo mii mbareen. ");
INSERT INTO spyNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Okasee kiyēē kiyeyakay ām wōlēē mii ꞉cheebyoosyeetaab Lōōt. ");
INSERT INTO spyNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nyoo kāyēētyi keey soboontaab kōōrooni, mākōōboot soboonnyii bo kibchuulyo. Nto nyoo kēēkooyto soboonnyii ām kōōrooni, mākunyōōr *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yoo mii ꞉biiko āyēēnku kuruuytōōs yēēt akeenke, +/mākēēyib akeenke /keebakaakta ake. ");
INSERT INTO spyNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nto yoo mii ꞉kooru āyēēnku kung'oosyē ām yēēt akeenke, +/mākēēyib akeenke /keebakaakta ake.” ");
INSERT INTO spyNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kuteebee ꞉rubiik Yēēsu kule, “Mokoryoontēēt, +makeenyoortiing' ānō?” Kukētyi ꞉Yēēsu kule, “Yoo mii ꞉mōtōōng'wēk, kumii yooto ꞉muuswēk.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nyēē mā lōō, kumwoochi ꞉Yēēsu rubiikyii wōlēē kimāchāktōōs kusooytooy ākookoy ānkumuytooy. ");
INSERT INTO spyNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kimwoochi kule, “Kimii ꞉chiito ake kiriinkēēt ake nyēē kiitiilē ng'al ām kōōk. Kimēēywēyē ꞉chiichoo Yēyiin āmākoonyitē biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kimii ꞉nkinee cheebyoosyeet ake kiriinkoonooto nyēē ki musuk. Kiwēētii ꞉cheebyoosyaanaa wōlēē mii ꞉chiichoo kibtaman kumāchē kule /kēēyēytoochi ng'aleekyii. ");
INSERT INTO spyNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kikwētyi ng'aleekaab cheebyoosyaanaa nyēē lōō. Nto mii lētuunoo kumwaayee moo kule, ‘Ānkoo ‑māāywēyē ꞉anii Yēyiin nto chii ake tukul, ");
INSERT INTO spyNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","+māāyēchi cheebyoosyaani manta, kuuyu kaakootaaraa kōōyiimsētoo mēt.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kumwoochi ꞉Yēēsu rubiikyii kule, “Yoo imuuchē ꞉choolwookiintō nyēē wuu nyoo kuyēchi cheebyoosyaanaa manta ii, ");
INSERT INTO spyNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","/bokeemwa nee Yēyiin? Muytoochinē kut kukas kule kāyēchi manta biikyii choo sooyē inee kibtaman. ");
INSERT INTO spyNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","!Kāāmwoowook, yoo kāākuyityiin, mākuyēchi biikyii manta areet akeenke. Nteenee kany ateebeenaak: Ata ꞉biiko chēē makumuyta kut ayitu ꞉anii *Wēritaab Chii, ānkāānyōōru kōōkoosēēnoo keey?” ");
INSERT INTO spyNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nto mii yoo, kurārchi Yēēsu ng'ālyoo biiko alak chēē kikuurē keey kule churtootiin ānkimōōntooy biich. Kimwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kimii ꞉biiko alake āyēēnku chēē kibokusaay ām *Kōōtaab Yēyiin. Ki *Fārisooyiin ꞉ake, nto ake ku kāāruruukiin bo *syuuru. ");
INSERT INTO spyNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kichō ꞉Fārisooyiintoonoo taay ankusaay kule, ‘Yēyiin, ābiruung' kōōnkōy, kuuyu ‑māāyēku choolwookiin kuu wōloo wuunto ꞉sāsiik, kibrōkōsiis, choo mārtootē āk mbo kāāruruukiintooniin bo syuuruut. ");
INSERT INTO spyNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","*Ākirē āmiisyēēt areet āyēēng' ām wiikiit ānkāākooytooy akeenke ām taman nyēbo kiy ake tukul nyēē ānyōōru.’ ");
INSERT INTO spyNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nteenee kikiiyyo ꞉kāāruruukiintoonoo bo syuuruut wōliin bo lēt. Maneemuuch kukas barak, kusooyē, nteenee kinam keey kwermet ankuriiree keey ām wōlēē mii ꞉Yēyiin kumwoochinē kule, ‘Baaba Yēyiin, iriireenaa anii nyi kyāāchoolwookēn.’ ");
INSERT INTO spyNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","!Kāāmwoowook, chiito nyēē kiiyeey kaa /kukāākēēnyōōchi kaat ku kāāruruukiintoonoo bo syuuruut nyoo kiyibē keey ng'wēny āmēēbērē Fārisooyiintoonoo. Kunyoo, chii nyoo yibē keey barak +/makiichuchuuk, nto nyoo yibē keey ng'wēny, +/mākiitōrōōr.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nto mii bēsyēēt ake, kōōmutyi ꞉biiko alake Yēēsu lēēkōōk chēē minkēēch kumāchē kule kutiinyēē āwunnyēk ānkōōbēruur. Yu kakas ꞉rubiik bichoo, kōōburyoong'to. ");
INSERT INTO spyNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nteenee kimwooy ꞉Yēēsu kule, “Ōbāroochi lēēkōōy kukwa wōlēē āmiitē, kuuyu biiko chēē wuu chuutēchu ꞉chēē nyoolchinē Bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","!Kāāmwoowook, mākoy kōōwut Bāytooyiisyēētaab Yēyiin ꞉chii nyoo māchāmtooy Bāytooyiisyoonoo kuu lōkōchoo.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yooto, kuchōōnchi ꞉kāāntōōyiintēēt ake nyēbo Yuutayeek Yēēsu ānkumwoochi kule, “Kāānēētiin iyēku chii nyēē karaam! +Maayey kule nee sāānyōōru *soboontaab kibchuulyo?” ");
INSERT INTO spyNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kukētyi ꞉Yēēsu kule, “'Kēēsōōtyēēchoo nee siimwaay kule akaraam ꞉anii? Ntēē Yēyiin nkit ꞉nyēē karaam! ");
INSERT INTO spyNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ābērē kiisuman kiruutēkaab Yēyiin choo kikōōnu ꞉Muusa choo mwooyē kule, ‘‑Meemarte, ‑mēērumiisyē, ‑mēēchōōrsē, ‑mēēmōlōlchi chii ng'ālyoo. Koonyit kōōn āk koomēt.’” ");
INSERT INTO spyNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kumwooy ꞉chiichoo kule, “Ānkētē tukul choo 'keemwaay. Kyāākir kung'eetee āmining'.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kumwoochi ꞉Yēēsu chiichoo kule, “Botuung' ꞉kiito akeenke. Wee-alte kiy ake tukul nyēē iboontē ānkiiyēētyēēchinēē bānoonik. Yoo 'keeyey kuu nyooto, irubwaa. +Mēēnyōōru bāytit nyēbo man ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","King'woonchi ꞉ng'aleechaa chiichoo, kuuyu kiboonto bāytit nyēē wōō. ");
INSERT INTO spyNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yu kakas ꞉Yēēsu wōlēē kāwēēto ꞉chiichoo, kumwooy kule, “Wuuy sōō kule nee kucham ꞉biiko choo boonto bāytit Bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nyumnyum mbo kubuntēē *꞉tembes koong'taab sintaaniit kusiir kōōwut ꞉chiito nyēē boonto bāytit Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kumwooy ꞉biiko chēē kikas ng'aleechaa kule, “Ara ng'oo, naas, ꞉nyēē imuuchē /kiiraraach?” ");
INSERT INTO spyNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kukētyi ꞉Yēēsu bichoo kule, “Kiyēē mēēmuuchāktōōs ām wōlēē mii ꞉biiko, kōōmuuchāktōōs ām wōlēē mii ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kuteebee ꞉Bētērō Yēēsu kule, “Kas kookeebakaakte ꞉acheek tukuukyoo tukul ankeerubiing'?” ");
INSERT INTO spyNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kumwoochi ꞉Yēēsu kule, “!Kāāmwoowook, chii ake tukul nyēē kaakubakaakta kooriikyii, koorkēēnyii, mbo ng'eetaabkaamet, kwaan āk kaamet nto lōkōkyii kubo yiisyēētaab Yēyiin, ");
INSERT INTO spyNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mākōōkoochi ꞉Yēyiin chēē chaang' raat kusiir choo kōboonto. Mākunyōōr mbo *soboontaab kibchuulyo ām kōōrēēt nyoo chōōnii.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kuwēēto ꞉Yēēsu rubiikyii choo ki taman āk āyēēng' komos ānkumwoochi kule, “!Kookas, kēēmiitē kēēbēētii Yēērusālēēm. Yoo kakeeyit wōlooto, mākuyityiin man kuu wōloo kikiikung'oorta ꞉wōōrkooyikaab Yēyiin kēny kurubta keey ākoo *Wēritaab Chii. ");
INSERT INTO spyNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","+/Makeenam /ānkiiyokoochi biikaab Rooma chēē mākōōntosuur, kung'utyi, ");
INSERT INTO spyNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kubirsēēt kulālchi ankubakach. Nto mii bēsyēētaab sōmōk, kung'eetee meet.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Maneemuuch ꞉rubiik kōōnkēt kiyēē kimii ꞉Yēēsu kung'āloolēē. Kiiyeelaat ꞉ng'ālyoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yu kikiikuriik kuyit ꞉icheek *kiriinkēētaab Yēērikō, kunyōōr cheebkoraatyaanteet ake nyēē kisoomsē ām kēēlto komos. ");
INSERT INTO spyNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yu kakas ꞉cheebkoraatyaantaanaa bōlātēētaab biiko chēē chaang' chēē kikēēytooy, kumwooy kule, “Ng'oo ꞉bichu mii kung'āloolootē ēē?” ");
INSERT INTO spyNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","/Kēēmwoochi kule Yēēsu nyēbo Nāāsārēēt nyēē kimii kumurē yooto. ");
INSERT INTO spyNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kukuurchinē ꞉chiichoo barak bakeenke kule, “Yēēsu, *Mōchōkōrēētaab Tāwuti, iriireenaa!” ");
INSERT INTO spyNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kōōburyoong'to ꞉biiko chēē kimii taay kule kusiis. Nteenee kikuurchi barak miisin kule, “Mōchōkōrēētaab Tāwuti, ankiiriireenaa!” ");
INSERT INTO spyNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kōōyyo ꞉Yēēsu ānkumwoochi biiko kule, “Ōrēētoonu baa chiichoo kuchō yu.” Yu /kakiiyiit, kuteebee ꞉Yēēsu kule, ");
INSERT INTO spyNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Imāchē āyēwuung' nee?” Kulē ꞉chiichoo, “Mokoryoontēēt, āmāchē akaste.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kulēēnchi ꞉Yēēsu, “/Kāākiisoobiing', kuuyu 'kēētinyē kaakaaseet. Kunyoo, ikaste.” ");
INSERT INTO spyNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kumwooyē ꞉Yēēsu kuu nyooto, kukāstooy ꞉chiichooto bakeenke ānkuwēēto keey Yēēsu kusiltootē Yēyiin. Kisilto nkicheek ꞉biiko tukul Yēyiin choo kikāsē ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kitas taay ꞉Yēēsu āk rubiikyii ankuyit Yēērikō. ");
INSERT INTO spyNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kimii ꞉chiito ake wōlooto nyēē /kikēēkuurēē Sakaayo. Ki kāāruruukiintēētaab *syuuruut nyēē wōō ānkiboonto bāytit nyēē wōō miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kisyeem ꞉Sakaayo kule kukas Yēēsu, nteenee kimēēmuuchē, kuuyu ki chaang' ꞉biiko, nto subak kibar ꞉nwookinto. ");
INSERT INTO spyNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yu kakas kuu nyooto, kulabat taay ankuwokulaany mōkōywēēt ake sukukas Yēēsu nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yu kayit ꞉Yēēsu yooto, kukas barak ānkumwooy kule, “Sakaayo, rēku baa areet akeenke, kuuyu āyēku ra toontēēng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kukāsē ꞉Sakaayo kuu nyooto, kurēku areet akeenke ānkuwēēto keey Yēēsu ākoy kanyii nyēē kabaybayiit miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nteenee mānāāng'ērēkyi ꞉biiko alake ng'aleechaa. Kiing'unyng'uunyiis kule, “Nto yu kāruutoochi ꞉Yēēsu chii nyēē tinyē ng'ōōki kuu nyi?” ");
INSERT INTO spyNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","/Kēēmii /kyoomiisyē, kōōyyo ꞉Sakaayo ānkumwooy kule, “Mokoryoontēēt, +māānēmu kisiincheetaab beesaanikyuu ānkāākoochi bānoonik. Nto yēē ākoo mii ꞉chii nyēē kyāānēmunēē cheechii chēē chaang' kusiir chēē /kikēēmāchēē āruruuchootē syuuruut, +māāyookyi kunyil ang'wan ām choo kyaa-am.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kumwooy ꞉Yēēsu kule, “/Kaakiiraraach ra kayi, kuuyu kēēkoosēē keey ꞉chiichi Yēyiin kuu Abraam. ");
INSERT INTO spyNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kyāāchōōnii ꞉anii, *Wēritaab Chii, chāāchēēng'ootē ānku chāārāroochootē biiko chēē kiikubootyo.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kibērē ꞉biiko chēē chaang' tōōs mākubāytooyiis ꞉Yēēsu yoo kayit Yēērusālēēm. Nteenee mēēbērē kimii wokuyēyāktōōs kuu wōloo kiisōōtitooy ꞉icheek. Nto kumii ꞉Yēēsu tākōōmuunyē, kumwoochi biiko kule, ");
INSERT INTO spyNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Kimii ꞉mokoryoontēēt ake nyēē kimāchē kuwo kōōrēēt ake nyēē kilōō, /bokēēng'oobchi kāāmuukēywēēkaab bāytooyiisyēēt sichokubayta kōōrēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kumānāāwo, kukuur motwoorikyii taman ānkōōkoochinoot chii ake tukul beesaanik chēē tēē chēbo ake. Kimwoochi chii kuyēyiisyēē laatit nyeenyii kubās keey ākoy bēsyēēt nyēē kēēyēēwunēē ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nteenee kitay ꞉biikyii. /Kikiiyookto biiko alak wokumwaayta kule māmāchē ꞉icheek bāytooyiintoonoo. ");
INSERT INTO spyNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yu kēēyēēw ꞉chiichoo ām ruutooy /kukaakeeng'aab kuyēk bāytooyiintēēt, kukuur motwoorikyii taman choo kiikoochinootē beesaanik chokōōboor ꞉chii ake tukul laatit nyeenyii nyēē kiikunyōōr. ");
INSERT INTO spyNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kumwooy ꞉nyēbo taay kule kibās keey ꞉cheechii kunyil taman. ");
INSERT INTO spyNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kulēēnchi nyoo ꞉bāytooyiintēēt, ‘Kuu yoo kwēēriib tukuuchoo kō ng'ēri nyēē karaam, +maayeyiing' ibayte kiriinkōōsyēk taman.’ ");
INSERT INTO spyNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kumwooy ꞉nyēbo āyēēng' kule, ‘Mokoryoontēēt, kookunyil ꞉cheechuu muut.’ ");
INSERT INTO spyNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","/Kēēmwoochi nyoo kule, ‘+Meebayte ꞉inyiing' kiriinkōōsyēk muut.’ ");
INSERT INTO spyNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kookeer ꞉ake kumwoochi bāytooyiintoonoo kule, ‘Beesaanikuuk ꞉chu. Kyaaratee ankeet ankaakonor nyēē māmii ꞉kiy nyēē kitwa. ");
INSERT INTO spyNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kyaakas kule iwuuy 'ankiicham ibirtooy biich ikēsē kiyēē kimēēchoonē ānkiiruruuchēē wōlēē mānēēyis.’ ");
INSERT INTO spyNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yooto, kulē ꞉bāytooyiintēēt, ‘Imiyaat. Kubaring' ꞉ng'aleekuuk nkityō. Yoo ākoo inkētē ꞉inyiing' kule āwuuy ꞉anii ankyaacham ābirtooy biich ākēsē kiyēē kimāāchoonē ānkāāruruuchēē wōlēē mānāāyis ii, ");
INSERT INTO spyNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kwaaming' ꞉nee simeekonoree beesaanikyuu lēnkuut sukubāsu keey? Nto 'kiiyey kuu nyooto, nto kāchāānyōōru beesaanichaa kukāākutāsyi keey ꞉kiy barak.’ ");
INSERT INTO spyNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kuweech keey ꞉bāytooyiintoonoo ānkumwoochi motwoorik alak kule, ‘Ōnēmunēē nyi beesaanichaa ānkōōkoochi chiito nyoo kōtāsyi keey ꞉cheechii miisin kusiir chēbo chuut tukul.’ ");
INSERT INTO spyNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nteenee kimwooy ꞉choo kule, ‘Mokoryoontēēt, ntēē chaang' ꞉chēē boonto ꞉nyoo, bo nee /kēētāsyi alak?’ ");
INSERT INTO spyNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kumwoochi ꞉bāytooyiintoonoo kule, ‘Kātāwuu nyooto sinee, nteenee chiito nyoo kāyēyiisyēē kiyēē /kākiikoochi, /kēētāsyinē ake, nto nyoo māyēyiisyēē, /kiinēmunēē mbo nyooto kāboonto. ");
INSERT INTO spyNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nteenee kurubta keey ākoo buunichoo kāākuwēēkyoo keey, ōkwēru choo ankuboobakach ākāsē.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yu kāyyēēkunēē, kutas taay ꞉Yēēsu āk baanaa. Kimiitē ꞉Yēēsu taay kutēē yooto tukul kutākyinē keey Yēērusālēēm. Nto yityo bokurwoowunēē Beetannyaa. ");
INSERT INTO spyNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yu kāng'ēētyēē Beetannyaa, kuba nto yu kēē-āyēēchēē keey Beetfaaka ām yēē kibo Lekemeetaab *Musēytuuniinēk, kumwoochi ꞉Yēēsu rubiikyii āyēēng' kule, ");
INSERT INTO spyNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Obe ākoy saang'iin. Yoo kooyit yooto, +mōōnyōōru sikiryo nyēē tāku siirwaak kurataat amanaakesen chii bēsyēēt ake. Otyaach ānkōōkwērwoo. ");
INSERT INTO spyNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nto yoo kateebeenaak ꞉chii kule ōtyookyinē nee sikiryēēt, ōlēēnchi ‘Māchē ꞉Mokoryoontēēt.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kiba ꞉rubiichoo ānkubokunyōōr sikiryoonoo kuu wōloo kimwooytoochinē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kumii kōōtyoochē, kuteebee ꞉biikaab sikiryēēt kule, “Ōtyookyinē nee sikiryoonoo?” ");
INSERT INTO spyNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kukētyi ꞉rubiichoo bichoo kule, “Māchē ꞉Mokoryoontēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kukwaanta sikiryoonoo ākoy yoo kimii ꞉Yēēsu. Kuyitu, kōōrēēku sirookwaa chēē kikiiliiktēē keey ānkwoolyāktēē bataytaab sikiryēēt sukutēbēē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kumii ꞉Yēēsu kuwēētii, kōōrēēkunoot ꞉biiko alake sirookwaa chēē kikiiliiktēē keey ānkōōyiitoot kēēltaab too. ");
INSERT INTO spyNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yu kayit ꞉icheek yēē kyoobuksēē ꞉kēēlto ām Lekemeetaab *Musēytuuniinēk, kutoow ꞉biiko kusilto Yēyiin ām ng'erekweek. Kityēēnootē yooto ꞉tukul kubo tukuuk chēbo kwōng'uut chēē kiikuyeyaan ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kikuurchinootē ꞉bichoo barak kumwooyē kule, “Ibēruuroot ꞉Bāytooyiintēēt nyi chōōnii ām kaayneetaab Yēyiin. Chōōnēē ꞉tāloosyēēt kibkōōnkōy. Wōō ꞉Yēyiin, lēyyē.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nteenee kimwoochi *꞉Farisaayeek alake chēē kimii yooto Yēēsu kule, “Kāānēētiintēēt, ānkiiburyoong'tē bichukuuk kumātākumwooy ng'aleechu.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kukētyi ꞉Yēēsu Farisaayeechaa kule, “Kāāmwoowook, yoo kāsiisyo ꞉bichu, kung'āloolē ꞉rwoontōōk.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yu kātoobēn Yēērusālēēm, kuriiree biikaab kiriinkoonooto kut kutēy ꞉lōōkik. ");
INSERT INTO spyNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kimwooyē kule, “Ābērē nto ōnkētē kiyēē māchāktōōs oyey sōōnyōōru tāloosyēēt. Nteenee ōmiitē mēēnān. ");
INSERT INTO spyNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mii ꞉bēsyēēt nyēē mākusēētyook ꞉buunik ānkōōkwēnkwēēnook nyēē māmii wōlēē ōchiirtēē. ");
INSERT INTO spyNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","+/Mākiimukuus kiriinkooni āk biikyii tukul nyēē māng'ētu mbo ꞉rwaa kukeekemeer keey ake, kuuyu kyoomoonte bārooyinto nyēē kikiikukōōnook ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yu kayit ꞉Yēēsu Yēērusālēēm, kōōwut biiwuutaab *Kōōtaab Yēyiin ānkutoow kukwet biiko chēē kimii kwooltooy tukuukwaa ām yooto, ");
INSERT INTO spyNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kumwoochinē kule, “Mwooyē ꞉Yēyiin ām siruutēk kule, ‘Bo ꞉kanyuu saayeet,’ nteenee kyooweech ꞉akweek kuyēk kēbēnnyoo wōlēē wunyēē keey ꞉sāsiik.” ");
INSERT INTO spyNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kiinēētiisyē ꞉Yēēsu kwaak ām *Kōōtaab Yēyiin ām bēsyōōsyēk chēē ng'ēri chēē kimii kukwoonii. Kimii ꞉mbo kibkōrōs chēē wōōyēch āk kāānēētikaab kiruutēk ākoo kāāntōōyik alak kuchēēng'ē kule kubakach Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nteenee kimēēmuuchē kuuyu kiwoolchinē Yēēsu ꞉biiko chēē chaang' kwaak chēē kibokuyēbchinē yiit ng'aleekyii. ");
INSERT INTO spyNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nto mii bēsyēēt ake, kumii ꞉Yēēsu kōōnēētiisyē ānkwoomchinē biiko lōkōōywēk chēē kāroomēch ām biiwuutaab *Kōōtaab Yēyiin, kukwoonchi ꞉mbo *kibkōrōs chēē wōōyēch, kāānēētikaab kiruutēk ākoo booyik. ");
INSERT INTO spyNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kuteebee ꞉bichooto Yēēsu kule, “Mwoowēēch, baa, ng'oo ꞉nyēē kikōōniing' kāāmuukēywēēk iyey ng'aleechu?” ");
INSERT INTO spyNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kuwālchi ꞉Yēēsu kule, “Kany ateebeenaak ꞉nkanii tēēbuutyēēt. Ōmwoowoo, baa, ");
INSERT INTO spyNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","yoo kiibātisāniisyē ꞉Yoowaana, kikwoonēē ꞉kāāmuukēywēēkyii wōlēē mii ꞉Yēyiin, nto wōlēē mii ꞉biiko?” ");
INSERT INTO spyNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yooto kuteebee keey ꞉bichoo kule, “Yoo kakeemwaay kule kikwoonēē ꞉kāāmuukēywēēkyii wōlēē mii ꞉Yēyiin, makuteebeeneech kule ām nee simākiiyēnchi. ");
INSERT INTO spyNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nto yoo kakeemwaay kule kikwoonēē wōlēē mii ꞉biiko, makuwiireeneech ꞉bichu tēē chu rwoontōōk kēēbēku, kuuyu kiikōōyēnchi ꞉icheek kule ki *wōōrkooyoontēētaab Yēyiin ꞉Yoowaana.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yooto kulēēnchi Yēēsu, “‑Mākiinkētē.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kumwoochi ꞉Yēēsu bichoo kule, “‑Māāmwoowook ꞉nkanii chiichēē kikōōnoo kāāmuukēywēēk ayey ng'aleechu.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","10","Kutas taay ꞉Yēēsu kumwoochi biiko kule, “King'eet ꞉chiito ake kuchaan *musābiibuunēk mbareenyii. Yu kaakuchaan, kukāsyiin āk biiko alak kule kuyēytoochi inee mbaraanaa sukubchēchiin āmiik kōōyyiin yoo kāruryo. Nto mii yoo, kuruuto kuyēk kēny. Yu kāwokururyo ꞉āmiik, kōōyookto ꞉chiichoo kibo mbareet motwooriintēēnyii akeenke wokuyibchi kereeryaanteet nyēē ki nyeenyii. Yu kayit ꞉motwooriintoonoo wōlooto kibo mbareen, kubir ꞉bichoo /kikiikoochinē kuyeyta mbaraanaa ankukwet āmā kiy. ");
INSERT INTO spyNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kōōyookto subak ꞉chiichoo motwooriintēēt ake. /Kēēbir nkinee nyoo /kiintosuur /ankeekwet āmā kiy. ");
INSERT INTO spyNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kōōyookto subak ake nyēbo sōmōk. /Kēēbir nyoo, /kiikōōtēn /ānkiichuutoot ākoy tuuyta saang'. ");
INSERT INTO spyNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Koosoot ꞉chiitaab mbareet ānkulē, ‘Saayey nee?’ Nto mii yoo, kulē, ‘Mii ꞉kiyēē +maayey. +Māāyooktē wērinyuu nyi āchāmē. Tōōs imuuchē kooywey ra nyiitēnyi.’ Kōōyookto. ");
INSERT INTO spyNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kuyitē ꞉lakwanaa wōlooto, kukuur keey ꞉bichooto kule, ‘Murēchu, ong'nyi ꞉lakwataab murooniito! Okany keebakach sukuyēk ꞉mbaraani nyēēnyoo.’ ");
INSERT INTO spyNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yooto, kunam ꞉bichoo wēēroo ānkukwēryoot kuwo tuuyta saang' ankubakach. Kunyoo ii, yoo koosoot ꞉akweek chokuyēchinē nee ꞉chiitaab mbareet bichoo? ");
INSERT INTO spyNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Okany āmwoowook, machokubakach bichooto tukul ānkōōkoochi biiko alak kuriibchi mbaraanaata.” Yu kāmwooy ꞉Yēēsu kuu nyooto, kumwoochi ꞉bichoo kule, “Bērē nto māyēyākiis ꞉ng'ala chēē wuu choo.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kōōrōōtoot ꞉Yēēsu ānkumwoochi kule, “Ibooru nee ꞉siruutēkaab Yēyiin ām yoo /kikeesir kule, ‘Tolochta nyoo kitāyē ꞉biiko nyēē kōōkuyēk tiiyēywoontēētaab kōōto.’ ");
INSERT INTO spyNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Chii ake tukul nyēē karyaach rwaantaanaa, +/makeetirtir. Nto nyoo kāluulchi ꞉rwaantaanaata, kuruurumē.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yu kakas ꞉kāānēētikaab kiruutēk ākoo mbo *kibkōrōs chēē wōōyēch ng'aleechaa kimwooyē ꞉Yēēsu, kōōnkēt kule kimii buch ꞉Yēēsu kukwērē ng'aleechaa liimō, nteenee king'āloolēē icheek. Kukwaany keey ꞉moo bichooto ankumach kule kunam Yēēsu, nteenee kinyōkōriitu, kuuyu ki chaang' ꞉biiko yooto. ");
INSERT INTO spyNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kiiyookto ꞉bichoo yōōtiik kuba wōloo kimii ꞉Yēēsu, wokuyey keey kule churtootiin. Kimāchē kunyōōr ng'ālyoo nyēē keechiwiit ꞉inee sukunam ānkōōyokoochi bāytooyiisyēētaab Rooma. ");
INSERT INTO spyNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kikwēēskwēēsānchi ꞉yōōtiichoo Yēēsu kule, “Kāānēētiintēēt, kiinkētē kule imwooyē manta, iyibē biiko tukul kwooyēēch ānkiinēētē biiko kōōnkēt kiyēē māchē ꞉Yēyiin ām kēēlto nyēbo man. ");
INSERT INTO spyNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mwoowēēch baa ng'ālyoontooni: Karaam kēēkwēchinē bāytooyiintēētaab Rooma *syuuruut nto miyaat?” ");
INSERT INTO spyNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yooto kōōnkēt ꞉Yēēsu kule kimii ꞉bichoo kutēchē inee. Kumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ōboorwoo baa beesyaanteet.” Kuteebee yōōtiichoo kule, “Bo ng'oo ꞉mēti āk kaaynaani mii beesyaantaani?” ");
INSERT INTO spyNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kulē ꞉bichoo, “Bo bāytooyiintēēt nyēē wōō nyēbo Rooma.” Kumwoochi ꞉Yēēsu kule, “Ōkoochi bāytooyiintoonoo kiinyii, nto Yēyiin, ōkoochi nyeenyii.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kinam kuut bichoo ꞉kiyēē kimwooy ꞉Yēēsu. Kunyoo, kubotyi ꞉wōlēē makunamta Yēēsu kukāsē ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nto mii yoo, kukwoonchi subak Yēēsu ꞉biiko alake chēē /kikēēkuurēē *Satukaayeek. Kiiyēnchinē ꞉bichoo kule yoo kaakume ꞉chiito, kaakume kutukul nyēē mēēbērē wokung'ēētēē meet bēsyēēt ake. Kimwoochi ꞉bichoo Yēēsu ");
INSERT INTO spyNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","kule, “Kāānēētiintēēt, kisirweech *꞉Muusa kiruutyēēt nyēē mwooyē kule yoo kame ꞉chiito āmānāāsikyiin leekwa ākoo koorkēēnyii, kōōntiiyē ꞉ng'eetaabkaamet koorkoonoo, sukusikyi nyiin lēēkōōk chēē sukuroobta kōōnyii. ");
INSERT INTO spyNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kimii ꞉chiito ake kēny nyēē kiboonto wērikyii tisab. Yu kāwokuwōōyiit ꞉kibooreetyeet, kukēēsyo. Nto mii yoo, kumēēchi keey nyēē mānāāsikyi ꞉koorkoonoo leekwa. ");
INSERT INTO spyNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kōōntiiyiis ꞉wēēriit nyēē kirubu nyoo kimēē. Kōōbuurchiin ꞉nkinee ākoo koorkoonoo ankume āmānāāsikyiin āk koorkoonoo leekwa. ");
INSERT INTO spyNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kookeer ꞉wēēriit nyēbo sōmōk. Kōōbuurto keey ꞉nyoo nkinee koorkoonoo ankume ꞉nkinee āmā leekwa. Kiyeyakay kuu nyooto kut kubēk ꞉wērichoo tukul āmā lēēkōōy. ");
INSERT INTO spyNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nto mii lētuunoo, kume ꞉nkinee koorkoonoo. ");
INSERT INTO spyNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kunyoo, imwoowēēch: Booyiitu ng'oo ꞉koorkoonoo kōōyyiin kāng'ēētyēē ꞉bichooto tukul meet.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kukētyi ꞉Yēēsu bichoo kule, “Ng'ētēē ꞉kāāmutiisyēēt kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yoo /kaakiing'eetee chii meet ānkuwo Kaab Yēyiin, mēēbērē tākōōmutiisyē nto /tābokiimutē subak, ");
INSERT INTO spyNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","kuuyu māmēē subak. Makukerkeyiitu malayikaanik ānku lōkōkaab Yēyiin kuuyu kookoong'eetee ꞉Yēyiin meet. ");
INSERT INTO spyNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nto kurubta keey ākoo ng'eeteetaab meet, kiichuurta *꞉Muusa ām sōntiinoo kilāyē yoo kimwooyē kule, ‘Yēyiintēētaab *Abraam, Isaka ākoo Yāākōbō.’ ");
INSERT INTO spyNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yoo /kakeemwa kule bo ꞉Yēyiin anum, kōōbooru ꞉yooto kule tākusoboot ꞉chiichooto ānkoo kikiikume kēny. Kunyoo, kurubta keey ākoo Yēyiin, sobchootiin ꞉biiko tukul ānkoo mbo choo kiikubēk.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kulē ꞉kāānēētikaab kiruutēk alake, “'Kēēkētu nyēē karaam, kāānēētiintēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Manaatakukany ꞉biiko kuteebaatee Yēēsu subak ng'al alak kutēchē. ");
INSERT INTO spyNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nto mii yoo, kuteebee ꞉Yēēsu bichooto kikwiilē inee kule, “Ām nee yu /kēēmwooyē kule chōōnēē *꞉Kāārārookiintēēt kōōtaab *Tāwuti? ");
INSERT INTO spyNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yoo wuu nyooto ii, kwaam ꞉nee sukusir ꞉Tāwuti ām kitaabuutaab Tyēēnwookik kule, ‘Kimwoochi ꞉Yēyiin Mokoryoontēēnyuu kule: 'Itēbunēē āwunyuu nyēbo taay ");
INSERT INTO spyNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kēēbāytooyiisyē tukwaay ānku +maawaang'te buunikuuk.’ ");
INSERT INTO spyNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kunyi, yoo kuurē ꞉Tāwuti Kāārārookiintēēt kule ‘Mokoryoontēēnyuu’ ii, kōōmuuchāktōōs kule nee kuyēk muchōkōrēēnyii?” ");
INSERT INTO spyNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kumii tākuyēbchinē yiit ꞉biiko kiyēē kimii ꞉Yēēsu kumwooyē, kuwēēkyi keey ꞉Yēēsu rubiikyii ānkumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ōriibēē keey kāānēētichoo bo kiruutēk, ‑amoorub ātēbuutēkwaa. Kicham ꞉bichu kōōloochē sirooy chēē yoo /kakeekas, /simkiinkētē kule icheek kiirwookik. Kicham mbo subak kubēēsyētootēē wōlēē chaang' ꞉biich /sikiisubooyootē nyēē /kākēēkoonyit. Kicham subak kulēkwēlē ng'ēchērōōk choo bo taay ām kooriikaab saayeet ānkōōmoymooyē mbo ng'ēchērōōk chēbo taay ām kaab saakwa ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lātunootē mbo koor chēē musuuk sukuyibēē tukuukwaa. Sooyē miisin kuyēyē keey kule churtootiin. Biich chēē wuu chuutēchu chēē mākuyēchi ꞉Yēyiin ng'al chēē bichiiyēch kusiir choolwookiin ake tukul.” ");
INSERT INTO spyNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kutākumii ꞉Yēēsu *Kōōtaab Yēyiin, kukas wōlēē kiikoochintooy ꞉biiko chēē ki mokorēēn beesaanik loolēēt nyēē /kikiiruruukyinē beesaanik kubo yiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yooto, kuchō ꞉cheebyoosya nyēē ki musuk anki banan. Kibār ꞉nyoo beesaanikyii chēē ki ng'ēri. ");
INSERT INTO spyNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kumwoochi ꞉Yēēsu rubiikyii kule, “!Kāāmwoowook, cheebyoosyaani musuk ꞉nyēē kēēnēm beesaanik laatit nyēē wōō kusiir chuut tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kāng'ōmōrunēē ꞉bichoo mokorēēn laatit nyoo kēēkooytooy wōlēē bo chēē boonto, nteenee kābār ꞉cheebyoosyaanaa loolēēnyii tukul.” ");
INSERT INTO spyNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yooto, kutoow ꞉rubiik kung'alaalee *Kōōtaab Yēyiin. Kimwooyē kule, “Kāroorānēch nyēē tyaa ꞉rwoontōōchu /kikeeteechee Kōyi bo Yēyiin! Kāroorānēch mbo nkicheek nyēē tyaa ꞉tukuuk chu /kikēēkōōnu /kiikaraaranee kōyi!” Nteenee kumwoochi ꞉Yēēsu rubiichoo kule, ");
INSERT INTO spyNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mii ꞉bēsyēēt nyēē +/mākiiturbuub tukuuchu ōchōrōkyinē. +/Mākiiturbuub nyēē māmii ꞉rwaa mbo akeenke nyēē ng'ētu kukeekemeer keey ake.” ");
INSERT INTO spyNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yooto, kuteebee ꞉rubiik Yēēsu kule, “Mokoryoontēēt, yēyāktōōs āyu ꞉ng'ālyoontoonoo ānkumākōōboor ꞉nee?” ");
INSERT INTO spyNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kukētyi ꞉Yēēsu kule, “Ōriib keey ‑/makiiberbeeraak. Choong'ēch ꞉biiko chēē makukwaanaat ankuyey keey ꞉ake tukul kule inee ku kāārārookiintēēt. Mākumwoowook ꞉alake kule, ‘Kaakuriik ꞉Mokoryoontēēt.’ Yoo kāmwooy, ‑mōōyēnchi. ");
INSERT INTO spyNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","+Mookas kubārē keey ꞉biiko ām kōōrēēt ānkukwiilē ꞉alake bāytooyiisyēētaab kōōrēēng'waa, nteenee ‑mōōmuuyē. Māsimkuyitu ꞉tabantaab kōōrēēt ānkoo kāyēyākiis ꞉tukuuchoo. ");
INSERT INTO spyNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mākubooryo ꞉bōrōryēēt ake āk ake, kubooryo ꞉kōōrēēt ake āk ake. ");
INSERT INTO spyNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mākutookunootēē ꞉kibring'ring'nyēēt kōōrēēt. Mākutookunootēē ꞉kēmēwuut nyēē wōō komoswookik chēē chaang' ām kōōrēēt ankukwaanaat ꞉bōōrwoonik chēē miyootēch. Mākutook ꞉tukun ām wōliin bo barak chēē ‑/mākyoomu. ");
INSERT INTO spyNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nto kumānāāyēyāktōōs ꞉ng'aleechaa tukul, +/mākēēwusook /ānkiiyyoong'tēēnook kōōk ām kooriikaab saayeet /ankeerataak kubo anii. Nto subak, +/mākiiyyoong'tēēnook taayeetaab bāytooyik kubo anii. ");
INSERT INTO spyNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bārooyinto ꞉nyooto nyēē +mōōmwoochinēē bichooto kiyēē ōyēnchinē. ");
INSERT INTO spyNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kunyoo, ‑mookany kwaamaak mēt kule bōōmwooyē nee ām kōōk nyēē ōyēētēē keey. ");
INSERT INTO spyNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","+Māāboorwook ꞉anii kiyēē bōōmwooyē nyēē mākoy kukētwook ꞉chii ng'ālyoo. ");
INSERT INTO spyNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Makuchaamtaak ꞉sikiikwook, tuubchōōsyēkwook, tilyōōnuutēkwook ākoo chōōrōōnuutēkwook /keenam alak ām akweek /ankeerat, nto alak /keebakach. ");
INSERT INTO spyNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mākuwēchook ꞉biiko kuuyu ōyēnwoo ");
INSERT INTO spyNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","nteenee ‑mā-āstook ꞉Yēyiin mbo kisich! ");
INSERT INTO spyNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yoo kōōmuytoochi ng'aleechaa, +mōōnyōōru soboonto nyēbo man ām lētuunoo.” ");
INSERT INTO spyNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kimwoochi ꞉Yēēsu subak kule, “Yoo ōkāsē kōōkwēnkwēēnē ꞉buunik Yēērusālēēm, ōnkēt kule kaakuriik ꞉bēsyēēt nyēē sērwētēē ꞉Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Māchāktōōs ꞉biikaab Yuuteeya kumwēchi lekem ānkumwēy ꞉nkicheek choo mii Yēērusālēēm. Nto choo kanyoorta ꞉ng'aleechu saang', kumeeyeey kiriing'. ");
INSERT INTO spyNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kuu wōloo mwooytooy ꞉siruutēk, ku bēsyōōsyēchuutēchu ꞉chēē mākōōng'woonchinēē ꞉Yēyiin biiko choo kiikuchoolwookēn. ");
INSERT INTO spyNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lēyyē, mākuwuuyiityi bēsyōōsyēchooto sōō kule nee kooruuk choo kōōyootiin āk choo irēēriisyē! Mākuchō ꞉wuuyinto nyēē wōō kōōrēēt ānku mākōōng'woonchi ꞉Yēyiin biiko choo mārubē ng'aleekyii. ");
INSERT INTO spyNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","+/Makeebakach alak /ankeenam alak bokuyēkunoot motwoor ām kōōrōōsyēk tukul. Mākuminy ꞉bōrōryōōsyēk alake Yēērusālēēm ākoy yēē bēkunēē ꞉bēsyōōsyēkwaa.” ");
INSERT INTO spyNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kimwoochi subak ꞉Yēēsu rubiikyii kule, “+/Makeekasee mēēyintaab kōōrēēt wōlēē mākōōbuurto ꞉asiista, araaweet āk kookeelik. Mākumuuyo ꞉biiko ām kōōrēēt ānkubotyi ꞉tonkoy kule tākyinē keey ānō, kumwēyēē kaaruumeetaab bēēkaab araarayta. ");
INSERT INTO spyNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mākōōtimtiimākoy ꞉wōliin bo barak ānkumuuyo ꞉biiko chēē chaang' kubo kiyēē mii wokuyēyāktōōs ām kōōrēēt, kut wuu nyēē mākubēk. ");
INSERT INTO spyNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yooto, makukas ꞉biiko āyēēwu ꞉anii, *Wēritaab Chii, ām boolteet ām kāāmuukēywēēk āk lēbkēēyyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yoo ōkāsē kutoowu keey ꞉tukuuchoo tukul, ōng'ērēkiisyē, kuuyu, ōmiitē bōōbēētii kōōrēēt nyēē lēēl.” ");
INSERT INTO spyNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yooto subak, kumwoochi ꞉Yēēsu rubiikyii kule, “Māchē ōkāsēē *mutiiniit āk keetiik alak. ");
INSERT INTO spyNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yoo inkātu ꞉sokēēkaab keetiichoo, ōnkēt kule kaakuriik kumusēs. ");
INSERT INTO spyNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ām kēēlto nyēē wuu nyooto, yoo ōkāsē kuyēyāktōōs ꞉tukuuchoo, ōnkēt kule kaakuriik ꞉Bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","!Kāāmwoowook, mābootōōs ꞉biikyuu choo kyaakwey ānkoo kāyēyākiis ꞉tukuuchoo tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mākubot ꞉barak āk ng'wēny, nteenee mābotē ꞉ng'ālyoontēēnyuu.” ");
INSERT INTO spyNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kitas taay ꞉Yēēsu kumwoochi rubiikyii kule, “Ōriib keey! ‑Mookany ānyōōrwook ōbēng'tēē sookwoonuutēk ōyyēēsyē. ‑Mookany mbo kōōbootook ꞉kāāsōōtēywēēk chēbo wōlēē +moonyoorte mokornoontiit. Yoo kooyey kuu nyooto, makucheeraak ꞉bēsyoonoo āyēēwunēē. ");
INSERT INTO spyNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Makucheer ꞉ng'aleechu biiko ām wōlto ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Māchē ōriibē keey kwaak. Ōsooyē sōōtitir ōbununēē ng'aleechaa soomuuch bōōyyoonyēē taayeetaab *Wēritaab Chii.” ");
INSERT INTO spyNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kiinēētiisyē ꞉Yēēsu ām *Kōōtaab Yēyiin yoo bo bēēt, nto mii kwēēmooy wokuruchinē keey wōliin bo Lekemeetaab *Musēytuuniinēk. ");
INSERT INTO spyNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kuyyēēchē ꞉kōōrēēt, kōōyēēyē Kōōtaab Yēyiin wokōōnēētiisyē. Kimustooy ꞉nkicheek biiko chēē chaang' bokukāsē kiyēē kiinēētē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kikiikuriik ꞉Saakweetaab mukaatiin chēē mākuutunootiin. Saakwaani ku *Saakweetaab Keeytaayeet. ");
INSERT INTO spyNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kimii ꞉mbo kibkōrōs chēē wōōyēch āk kāānēētikaab kiruutēk kuchēēng'ē wōlēē makunamta Yēēsu /subokeebakach. Nteenee kinyōkōriitu kuuyu ki chaang' ꞉biiko yooto. ");
INSERT INTO spyNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yooto, kutamar ꞉Kibrōkōsyoontēēt Yuuta Iskaryoot nyoo ki akeenke ām rubiichoo ki taman āk āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kiwo ꞉Yuuta wōlēē kimii ꞉mbo kibkōrōs chēē wōōyēch ākoo biiko alak chēē ki wōōyēch chēē kiriibē Kōōtaab Yēyiin. Kiwokusat wōlēē +/makeenamta Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","King'ērēkyi ꞉bichoo Yuuta ānkuchāmchiin kule mākōōkoochi ꞉icheek beesaanik, yoo kayey kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kucham ꞉Yuuta ng'aleechaa ankucheeng' bārooyinto nyēē /kiimuuchē /keenamee Yēēsu kumākāsē ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nyēē mā tyaa, kuyit ꞉bēsyēēt nyēē /kēēyēēnyēē mēēnkitaab kōrōsēēkaab Saakweetaab mukaatiin chēē mākuutunootiin. ");
INSERT INTO spyNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kumwoochi ꞉Yēēsu Bētērō ākoo Yoowaana kule, “Bōōyēytoowēēch saakweet kyaam.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kuteebee ꞉icheek Yēēsu kule, “Imāchē bokeeyeytee ānō?” ");
INSERT INTO spyNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kukētyi ꞉Yēēsu kule, “Obe, nto yoo kōōwut Yēērusālēēm, +mōōtuuyēē chiito ake nyēē boontoonu tērēētaab bēēko. Orub chiichoo ākoy kōōto nyēē kēēwut. ");
INSERT INTO spyNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ōmwoochi chiitaab kayta kule, ‘Māchē ꞉Mokoryoontēēt kisēēnkēētaab tāyēēk nyēē sukwaamee *Saakweetaab Keeytaayeet āk rubiikyii.’ ");
INSERT INTO spyNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mākōōboorwook kisēēnkēēt nyēē wōō nyēē mii nyiin barak nyēē boonto tukuuk tukul. Yooto, oyeyte āmiik.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kiba ꞉rubiichoo āyēēnku ānkubokunyōōr kiy ake tukul kuu wōloo kimwooytoochinē ꞉Yēēsu. Nto mii yoo, kuyeyta āmiik. ");
INSERT INTO spyNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yu kāākuchōbākoy kiy ake tukul, kuchōōnto keey ꞉Yēēsu *lēbkēēyik ānkwoomiis. ");
INSERT INTO spyNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kumwoochi ꞉Yēēsu lēbkēēyichoo kule, “Kyaamachaanu kule kyaam tukul āmiichu bo Keeytaayeet kumanaanyalil. ");
INSERT INTO spyNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","!Kāāmwoowook, ‑mēētāwāā-āmē saakweet ake subak nyēē wuu nyi ākoy bēsyēēt nyēē /kakiikeeree nyēē lēēl nyēē biirē nyi ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kunam terekyeet nyēē kimii *꞉tifaayiik. Kubirchi Yēyiin kōōnkōy ānkumwoochi lēbkēēyik kule, “Ōmōōsootē tifaayiichu. ");
INSERT INTO spyNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","!Kāāmwoowook, ‑māwāāyyēē subak tifaayiin ākoy bēsyēēt nyoo +mawaayyee ām Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kunam nkinee mukaatiit ānkubirchi Yēyiin kōōnkōy. Kubetes ānkōōkoochinoot *lēbkēēyik kumwoochinē kule, “Bōōrnyuu ꞉nyi nyēē /kāākēēkōōn kubo akweek. O-am sōōsōōtēēnoo.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yu kāākwoomiis kubēk, kunam terekyeet nyēē kimii ꞉tifaayiik ānkumwooy kule, “*Kiirootyeet ꞉nyi nyēē lēēl kubununēē ꞉korotiikyuu chēē +/makiitaata kubo akweek.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kumwooy ꞉Yēēsu kule, “Ānkoo kēēmiitē kyoomiisyē ꞉tukul, miitē ꞉akeenke ām akweek wokuchoomtoo. ");
INSERT INTO spyNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Makume *꞉Wēritaab Chii kuu wōloo kiikusatita ꞉Yēyiin, nteenee +/mākiing'woonchi chii nyoo kachaamta.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kuteebee keey ꞉rubiik yooto kule, “Ara ng'oo ām acheek ꞉nyēē mii wokuchoomtooy Yēēsu?” ");
INSERT INTO spyNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kutoow ꞉rubiik kumooyo wōōyinto. ");
INSERT INTO spyNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kumwoochi ꞉Yēēsu kule, “Bāytooyik chēē mii kōōrooni kumāchē kōōboorchi biiko alak kule icheek ꞉chēē bāytooyiisyē ānku icheek ꞉chēē inkētē kuyēētyēēchi biiko alak kusiir chuut. ");
INSERT INTO spyNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Māmāchāktōōs oyey ꞉akweek kuu nyooto. Nteenee nyoo kāāntōōyiin ām akweek kuyib keey ng'wēny, nto nyoo māchē kuyēk kāāntōōyiin kumāchāktōōs kuyēētyēēchinē chuut. ");
INSERT INTO spyNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ng'oo ꞉nyēē wōō ām chiito nyoo āmiisyē āk nyoo bāyiisyē? Chiito nyēē wōō ku nyoo āmiisyē, nteenee āboontē keey akweek āyēētyēēchook. ");
INSERT INTO spyNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kwōōmuytoochi ꞉akweek tyēmuutēk chēē kōōkēēnyōōru. ");
INSERT INTO spyNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kuu yoo kiikukōōno ꞉Baaba kāāmuukēywēēk ābāytooyiisyē, +māākōōnook ꞉nkanii kāāmuukēywēēchoo. ");
INSERT INTO spyNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","+Mākiibuurtē keey ꞉tukul āk akweek ām Kaab Yēyiin kyoomiisyē ānkōōtiilchinē ng'aleek biiko tukul chēbo mooyēētaab *Isrāyēēl.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kumwoochi ꞉Yēēsu Bētērō kule, “Simōōni wē, Simōōni! /Kāākiikoochi Syeetaani kāāmuukēywēēk kutyemaak. ");
INSERT INTO spyNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nteenee kāāsoowuung' anii kumēēboot kaakaaseet. Yoo 'keeweekse ichōō wōlēē āmiitē, +mēētitiir rubiik chuut.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kumwoochi ꞉Bētērō Yēēsu kule, “Mokoryoontēēt, kaachamte keey ꞉anii. Yoo kābo rātiisyō, /keerateech tukwaay, nto yoo kābo meet, kēēbēku ꞉tukwaay.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kukētyi ꞉Yēēsu kule, “Bētērō, kāāmwoowuung', kutoombo kōōturkuuchē ꞉kirkōōnkiit kwēēmowuuni +meetuuch keey areet sōmōk.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kumwoochi ꞉Yēēsu rubiikyii kule, “Yoo kyāāyooktook obeetaate āmā beesyaa nto ku lool nto kwēyōōn, ara kibotwook ꞉kiy ake tukul?” Kumwooy ꞉rubiik kule, “Māmii ꞉kiy nyēē kibotwēēch.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kumwoochi ꞉Yēēsu kule, “Nteenee raat, yoo boonto ꞉chii beesaanikyii nto loolēēnyii, kunamaat. Nto nyoo mātinyē chōōkiit, kwaalta kābuutiinyii ankwaal nyeenyii. ");
INSERT INTO spyNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mākuyityiin ꞉siruutēchu bo Yēyiin kurubta keey āk anii ām yoo mwooyē kule, ‘/Kikeetasta kibng'ōōkisiis.’ Kuu wōloo /kikeesirta kurubta keey āk anii, makuyeyakay kuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kumwooy ꞉rubiik kule, “Mokoryoontēēt, nto chu chōōkiinēk āyēēng'.” Kumwoochi ꞉Yēēsu kule, “Kutēēniit choo!” ");
INSERT INTO spyNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nto mii yoo, kuchuwunee ꞉Yēēsu kōyooto kimii kwoomiisyēē āk rubiikyii ānkutākyi keey Lekemeetaab *Musēytuuniinēk kuu kwaak. ");
INSERT INTO spyNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kumii wōlooto, kumwoochi rubiikyii kule, “Māchāktōōs ōsooyē simōō-āsyi keey tyēmuutēk.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kung'eetee ꞉Yēēsu yēē kimii ꞉rubiikyii ankoonaata yēē lōō kisich. Kukutuny ankusaay kule, ");
INSERT INTO spyNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Baaba, yoo ichāmē, inēmtoowoo nyalili. Nteenee kuyeyakay kuu wōloo imāktooy, āmēēbērē kuu wōloo āmāktooy anii.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yu keewaany ꞉Yēēsu kusaay kuu nyooto, kuchō *꞉malayikeet ānkōōtitiir. ");
INSERT INTO spyNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kisaay subak nyēē ng'waa miisin kut kooyot. Kikerkeyiitu ꞉kiyootichaa korotiik chēē /kakiitaata. ");
INSERT INTO spyNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kung'eetee ꞉Yēēsu yooto kāsooyēē, ānkuwo yoo kimii ꞉rubiik. Nteenee kinyōōr rubiichoo kuruuytōōs kubo chaasikaab ng'uusng'uusyēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kumwoochi ꞉Yēēsu rubiichooto kule, “Tōōruuytōōsii? Ōng'ēētyē ankoosaay simōō-āsyi keey tyēmuutēk.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kutākumii ꞉Yēēsu kung'āloolē, kuyit ꞉Yuuta nyoo ki akeenke ām rubiikaab Yēēsu taman āk āyēēng', kuboontoonu keey biiko chēē chaang'. Kuwo yēē kimii ꞉Yēēsu kumāchē kutorooch. ");
INSERT INTO spyNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kumwoochi ꞉Yēēsu kule, “Yuuta! Imāchē man ing'ōmtē *Wēritaab Chii ām toroocheet?” ");
INSERT INTO spyNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yu kakas ꞉rubiik chuut kiyēē kimii wokuyēyāktōōs, kumwooy kule, “Mokoryoontēēt! Keeyebaayeb?” ");
INSERT INTO spyNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","/Kēēmwooyē kuu nyooto, kuchwēntooy ꞉akeenke yiititaab taay nyēbo motwooriintēētaab kibkōrōs nyēē wōō. ");
INSERT INTO spyNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nteenee kumwoochi ꞉Yēēsu rubiikyii kule, “Ōbāroochi kuyey!” Yooto, kunam yiititaab chiichoo ānkukētyi yooto. ");
INSERT INTO spyNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bichoo kikwoontooy keey Yuuta ku mbo kibkōrōs chēē wōōyēch, booyik ākoo biiko alak chēē wōōyēch ām chēē kiriibē *Kōōtaab Yēyiin. Kumwoochi ꞉Yēēsu bichooto kule, “Ntēē sookwaante chōōkiinēk āk syaariinek? Ōbērē āntōōchinē ꞉anii lukēēt nyēē māchē kuweech kōōrēēt? ");
INSERT INTO spyNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ntēē kwāāmiitē ꞉anii kwaak biiwuutaab Kōōtaab Yēyiin amoonamaa? Nteenee bēsyēēng'woong' ꞉nyi ra āk kāāmuukēywēēkaab mēēnānēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","/Keenam Yēēsu yooto /ānkēēkwēryoot ākoy kaytaab *kibkōrōs nyēē wōō. Koonaamaat ꞉Bētērō Yēēsu ākoy biiwuutaab kayaa. ");
INSERT INTO spyNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kikiikoolaay ꞉riibiik maat kiyēng' ānkimii ꞉biiko kuywēē maata. Kiwokuyu ꞉nkinee Bētērō mayaata. ");
INSERT INTO spyNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nto bērē kukas ꞉chēēbto ake nyēē kiyēyiisyē kayaata Bētērō kukataal ꞉maata, kōōrōōtoot ānkulē, “Ntēē kiboontootē keey ꞉chiichi Yēēsu!” ");
INSERT INTO spyNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kutuuch keey ꞉Bētērō kule, “Chēē, ‑māānkētē chiichoo!” ");
INSERT INTO spyNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kukas ꞉chiito ake subak Bētērō ānkumwooy kule, “Inyiing' ꞉ake ām bichu.” Kumwooy ꞉Bētērō kule, “Lēyyē, ābēērē keey!” ");
INSERT INTO spyNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yu kakeeyta ꞉asiista akeenke, kumwooy subak ꞉chiito ake ām yooto kule, “Kubooyiit man, kiboontootē keey ꞉chiichi Yēēsu, kuuyu sālu Kalilaaya.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kutuuch keey ꞉Bētērō kule, “Kubooyiit man, ‑māānkētē kiyēē imiitē imwooyē.” Kōōturkuuchē ꞉kirkōōnkiit bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kuweech keey ꞉Yēēsu ānkōōrōōtoot Bētērō. Koosoot ꞉Bētērō yoo kāmwoochinē ꞉Yēēsu kule, “Kutoombo kōōturkuuchē ꞉kirkōōnkiit kwēēmowuuni +meetuuch keey areet sōmōk.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kuchuyta ꞉Bētērō saang' ānkuwokuriir nyēē kāng'woonchi miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kiintosuuroot Yēēsu ꞉biiko choo kimii kuriibootē ankoonyaliilaat. ");
INSERT INTO spyNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kiiyēēnē koonyek, ānkubirsēētē, sukutēēbootēē kule, “Mwoowu baa, ng'oo ꞉nyi kābiring'?” ");
INSERT INTO spyNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kiinchōchēē mbo subak ꞉bichooto Yēēsu ng'aleek alak chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yu yyēēchē ꞉kōōrēēt, kikiikōōruruuch keey ꞉kōōkwēēt nyēē wōō nyēbo Yuutayeek: Booyik, mbo kibkōrōs chēē wōōyēch āk kāānēētikaab kiruutēk. /Kikēēkwēryoot Yēēsu ākoy kōōk. ");
INSERT INTO spyNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kumii kōōk, /keeteebee kule, “Inyiing' man *꞉Kāārārookiintēēt?” Nteenee kukētyi ꞉Yēēsu kule, “Ānkoo kāāmwoowook, mēēbērē +moochamte, ");
INSERT INTO spyNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","nto subak, yoo kaateebeenaak ꞉nkanii ng'ālyoo, mēēbērē +mōōkētu. ");
INSERT INTO spyNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nteenee kung'eetee raat kuwo taay, +māwāābuurunēē ꞉anii, *Wēritaab Chii, āwutaab taay nyēbo Yēyiin kēēbāytooyiisyē ꞉tukwaay.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kuteebee ꞉bichoo tukul kule, “Imāchē imwaay kule inyiing' Lakwataab Yēyiin?” Kukētyi kule, “Wuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yu kāmwooy ꞉Yēēsu kuu nyooto, kōōruumchi ꞉bichoo kule, “Nee ake ꞉nyēē /tākēēmwoowēēch kurubta keey āk chiichi, ntēē kaakeekas kuchāmchiintōōs nkit.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yooto, kung'eet ꞉kōōkwoonooto tukul bo Yuutayeek ānkukwēryoot Yēēsu ākoy Kaab *Bilaato. ");
INSERT INTO spyNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kumwoochi ꞉bichooto Bilaato kule, “Kikēēnyōōru chiichi kutēwēchootē kāāsōōtēywēēkaab biikyoo kule kumākwēchi bāytooyiintēēt nyēbo Rooma *syuuruut. Kimwooytootē mbo subak kule inee ku kāārārookiintēēt nyēē māchē kubayta biikyoo.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kuteebee ꞉Bilaato Yēēsu kule, “Inyiing' ꞉bāytooyiintēētaab Yuutayeek?” Kukētyi ꞉Yēēsu kule, “Wuu nyooto, sinee.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yu /kābokiikuum Yēēsu, kumwoochi ꞉Bilaato mbo kibkōrōs chēē wōōyēch āk biiko chēē kimii yooto kule, “Ntēē ‑māākāsē lēēlis nyēē boonto ꞉chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kōōwuruur ꞉mbo kibkōrōs choo wōōyēch Bilaato kumwoochinē kule, “Inee ꞉nyēē mii kutēwēchootē biiko ām kōōrēēnyoo kumukuul kubuntēē kāānēētiisyēēnyii. Kitoowunēē ng'aleechaa Kalilaaya, neennyi kookuyit wōli.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Yu kakas ꞉Bilaato ng'aleechaa, kumach kōōnkēt yoo kibo ꞉Yēēsu yēēmēētaab Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yu kāwokōōnkēt, kōōrēkēērchi Yēēsu Ērōōtē nyoo kikiikuruutoon Yēērusālēēm bēsyōōsyēchooto, kuuyu ki bāytooyiintēētaab Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bērē kukas ꞉Ērōōtē Yēēsu, kung'erech miisin, kuuyu kikiikumachaan nyi kooy kule nto kas inee kuuyu /kikiikyaamta Yēēsu miisin. Kimāchē kule nto yey ꞉Yēēsu kiy nyēē /kiilātē. ");
INSERT INTO spyNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kuteebee ꞉Ērōōtē Yēēsu ng'al chēē chaang', nteenee mānāākētyi ꞉Yēēsu ng'ālyoo. ");
INSERT INTO spyNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yooto, kung'ēētyo ꞉mbo kibkōrōs chēē wōōyēch āk kāānēētikaab kiruutēk ānkumwoochi Ērōōtē kule, “So, ntēē kiikuyey ꞉chiichi ng'aleek chēē miyootēch miisin!” ");
INSERT INTO spyNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nto mii yoo, kuyēchi ꞉Ērōōtē āk riibiikyii Yēēsu ng'al chēbo kāāntosuurāt ankoonyaliil. Kiilookyi sireet nyēē kibo bāytooyiisyēēt /ankeeketita kuwo wōlēē kimii ꞉Bilaato. ");
INSERT INTO spyNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kiyey ꞉yooto kuchoomnyo ꞉Ērōōtē āk Bilaato bēsyoonoo kusiir yu kibo taay yoo ki buunyoo ꞉chii ām wōlēē mii ꞉ake. ");
INSERT INTO spyNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kōōruruuch ꞉Bilaato mbo *kibkōrōs chēē wōōyēch āk kāāntōōyik āk biikaab yēēmēēt ");
INSERT INTO spyNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ānkumwoochi kule, “Kōōkwērwoo chiichi ānkōōmwoowoo kule kōtēwēchootē biiko. Kāābērē ākuumu ām taayeeng'woong' ku ‑māākāsē lēēlis nyēē boonto, ");
INSERT INTO spyNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","āmānyōōr ꞉nkinee Ērōōtē lēēlis ake tukul. Kayey ꞉yooto kukētwēēch. Nto subak, māmii ꞉kiy nyēē kiikuyey sukōōsākyi /keebakach. ");
INSERT INTO spyNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kunyi, +/makeebas /ankeebakaakta kuwēēchi keey.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kōōruumchi ꞉biiko kule, “Iwaang'te chiichi ankiityaakte Baraaba.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraaba ku chii nyēē /kikiikeerat nyēē kimāchē kuweech kōōrēēt ānkikiikubākākiis. ");
INSERT INTO spyNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kumwoochi ꞉Bilaato subak bichoo kule, “Ntēē irooko /kiityaakta Yēēsu.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nteenee kubōloobōl ꞉biiko kule, “Obakach! Obakach!” ");
INSERT INTO spyNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kumwoochi ꞉Bilaato bichoo nyēbo sōmōk kule, “Ara, koleel nee ꞉chiichi? Māmisyinē /keebakach. Kunyi, +/makeebas /ankiityaakta.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nteenee kiiwuruur ꞉biiko Bilaato kukuurchinē barak kule, “Māchāktōōs /keebakach chiichi!” Kōōbēliis ꞉kwiilateetaab bichoo ");
INSERT INTO spyNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ānkuyēchi kuu wōloo kāmāktooy. ");
INSERT INTO spyNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kiityaakta Baraaba ankuchamta /bokeebakach Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yu /kikēēmii /kēēkwēryootē Yēēsu, /kēētuuyēē chiito ake nyēē kimii kuwēētii Yēērusālēēm. /Kikēēkuurēē chiichoo Simōōni nyēē kibo kōōrēētaab Kurēēn. /Kēēnāmē nyoo /ānkēēkērchinē koong' kukalabaat murtooywoontoonoo kurubē Yēēsu lēt. ");
INSERT INTO spyNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kiinaamaat ꞉biiko chēē chaang' kuboontootē keey chēēbyōōsōōk chēē kyoomoonte mbuy kuriirēē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kuweech keey ꞉Yēēsu kukas chēēbyōōsōōchoo ānkulēēnchi, “Tibikaab Yēērusālēēm, ‑mooriireenaa, nteenee oriiree keey āk lōkōkwook. ");
INSERT INTO spyNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mii kukwoonii ꞉bēsyōōsyēk chēē mākumwooy ꞉biiko kule, ‘Mii nyēē karaam ꞉koorko nyoo mānāāsich leekwa.’ ");
INSERT INTO spyNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mākumwooyē ꞉biiko yooto kule, ‘Kaykay kuturbubchēēch ꞉tulōōntōōk ānkutubēēch ꞉lekemoosyek.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kitas taay kumwooy kule, “Yoo imuuchē raat /kēēyēchi kēēti ataa ng'al chēē wuu chu ii, /bokeemwa nee nyēē yaamaat?” ");
INSERT INTO spyNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","/Kikeebeeta nkicheek biiko alak āyēēng' chēē kirātootiin kubo ng'al chēē kiikuyey kule /bokeebakach ākoo Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Yu kayit yēēt ake yēē /kikēēkuurēē ‘Rōkyēētaab Mēt,’ /kēēkwērtoochi Yēēsu murtooywoontēēnyii. /Kikēēkwērtoochi ake tukul ām bichoo murtooywoontēēnyii /ānkiiyyoong'tēē ake āwutaab taay /kiiyyoong'tēē ake āwutaab kaataam, kōōkwēēnchi Yēēsu kwēēn. ");
INSERT INTO spyNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kimwooy ꞉Yēēsu ām yooto kule, “Baaba, inyōōchi kaat bichu kuuyu ‑mēēnkētē kiyēē mii kuyēyē.” Kibar ꞉riibiichoo *sēkēēryēēt yu kimāchē kubchēchiin sirookaab Yēēsu sukōōnkēt kule ng'oo ꞉nyēē mākuyib sireet nkōnō. ");
INSERT INTO spyNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kiiyyoong'iis yooto ꞉biiko kukāsē kiyēē kimii kuyēyāktōōs. Kiinchuruursēt ꞉kāāntōōyikaab Yuutayeek Yēēsu kule, “Kiisoobootē ꞉chiichi biiko alak. Kany kōōsoob keey naas yoo inee man *꞉Kāārārookiintēēt nyēē chōōnēē Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kiinchuruur ꞉nkicheek riibiik Yēēsu. Kikwaanta *tifaayiik chēē tāytāyēch ānkōōyokoochi Yēēsu ");
INSERT INTO spyNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ānkumwoochi kule, “Yoo inyiing', man, ꞉bāytooyiintēētaab Yuutayeek, isoob keey, naas.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","/Kikiikēēsirchi kiito ake ng'aleek chēē kiyey /sikiitiilchi Yēēsu meet chēē kimwooyē kule: BĀYTOOYIINTĒĒTAAB YUUTAYEEK ꞉NYI. ");
INSERT INTO spyNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kimwoochi Yēēsu ꞉chiito akeenke ām bichoo āyēēng' choo kimii murtooywōōsyēkwaa kule, “Ikuurē keey inyiing' oob kule Kāārārookiintēēt? Iraraach keey ankiiraraacheech nkacheek!” ");
INSERT INTO spyNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nteenee kōōburyoong'to ꞉nyiin ake kule, “Yyōōch! ‑Mēēywēyē ꞉inyiing' Yēyiin siimwooyē ng'al chēē wuu chu ānkēēmiitē kēēnyōōru āk chiichi ng'wooninto nyēē kerkeey? ");
INSERT INTO spyNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Misyēēch acheek kubo lēēlisto nyēē kēēboontē. Nteenee /kakyaam chiichi buch.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yooto, kumwoochi ꞉chiichoo Yēēsu kule, “Isootaa, yoo 'kēēwut Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kumwoochi ꞉Yēēsu kule, “!Kāāmwoowuung', bokiibuurē ra āk inyiing' kibkōōnkōy.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ku āsiiswēk lo, kuker ꞉kiito ake asiista kutuuyiit ꞉kōōrēēt. Kiichuulyo ꞉mēēnānoonoo ākoy āsiiswēk sokool. Kukērēērunēē keey ꞉ankeet āyēēng' nyēē kirikimim nyēē /kikiiyēēlēē Kitōōkiitaab *Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yooto kōōnchō ꞉Yēēsu kule, “Baaba Yēyiin! Kāāyokoowuung' tāmirmiryēēnyuu!” Kōōtēryēēchē ng'aleechaa, kung'ētē bakeenke! ");
INSERT INTO spyNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kisilto kāāyyoong'iintēēt ake nyēbo lukēēt nyēē kimii yooto Yēyiin. Kimwooy kule, “Kubooyiit man, ākoo kochurtaat ꞉chiichi ām taayeetaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","King'woonchi biiko chēē kimii yooto yu kakas kiyēē kayeyakay. Yooto nanyuun kooyeey kaa nyēē kanamaat keey kwērmētōōk. ");
INSERT INTO spyNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kiiyyoong'iis ꞉chōōrōōnuutēkaab Yēēsu āk chēēbyōōsōōk alak chēē kikiikurubaan Yēēsu kung'eetee Kalilaaya, kutoobēnē kiyēē kimii kuyēyāktōōs. ");
INSERT INTO spyNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kimii ꞉chiito ake nyēē /kikēēkuurēē Yōōsēēf nyēē kiminyē *kiriinkēētaab Arimataaya ām yēēmēētaab Yuuteeya. Kikiikunam ng'ālyoontēētaab Yēyiin miisin ānkimii kukānyoonu Bāytooyiisyēētaab Yēyiin. Ki inee ꞉akeenke ām kōōkwēēt nyēē wōō nyēbo Yuutayeek nteenee kimachamaat ng'aleekaab chuut ām kōōkwoonoo. ");
INSERT INTO spyNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kiwo ꞉chiichoo Kaab *Bilaato wokusoom /kēēchāmchi wokōōnēm muustaab Yēēsu. Kuchāmchi ꞉Bilaato. ");
INSERT INTO spyNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wokōōrēēk muusyoontoonoo ankuratee ankeet ānkuwokōōkoochi kochonkeet ake. Kiiwōroot ꞉kochonkaanaa /āmānāākiikoochi muusyoo bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ki bēsyēēt ꞉nyooto nyēē kimii ꞉Yuutayeek kuyēytēē keey kukātoow keey ꞉bēsyēētaab *Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kiinaam ꞉chēēbyōōsōōchoo kikwoontooy keey Yēēsu ām Kalilaaya Yōōsēēf ākoy kochonkaanaa bokukas wōlēē /kikeekonorta. ");
INSERT INTO spyNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nto mii yoo, kooyeey ankubokuyeyta mwaanik chēē boong'u nyēē anyiny. Nteenee kiimuuny ām bēsyēētaab *Sabaato kuu wōlēē mwooytooy ꞉mākuutēk. ");
INSERT INTO spyNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ām bēsyēētaab taayta, nyēē kirubē bēsyēētaab *Sabaato, kumusta ꞉chēēbyōōsōōchoo kukēērir ꞉kōōrēēt ākoy kochonkaanaa /kikēēkōnōrēē Yēēsu. Kibeeta mwaanichaa kiboong'u nyēē anyiny choo kikiikuyeyta. ");
INSERT INTO spyNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kuyitē, kunyōōru /kāākēēwunukto rwaantaanaa /kikikeekeree kochonkeet. ");
INSERT INTO spyNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yu kēēwut kochong', kukas kule kimāmii ꞉muustaab Mokoryoontēēt Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kutākōōlātē ām kiyēē kayeyakay, kutook ꞉biiko alake āyēēnku chēē kēēyyoong'iis taayeeng'waa. Kikiilaach sirooy chēē kileelach kut kōōwirwiirtōōs. ");
INSERT INTO spyNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kimuuyo ꞉chēēbyōōsōōchoo ankukas ng'wēny. Yooto, kumwoochi ꞉bichoo kule, “Ām nee yu ōchēēng'ēē chii nyēē soboot *kāābkwoombiich? ");
INSERT INTO spyNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Māmii wōli! Nteenee kaakung'eetee meet. Māchāktōōs ōsōōtē wōlēē kimwooytoowook yoo kitākumiitē Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kimwooy kule, ‘+/Mākiiyokoochi *Wēritaab Chii biich chēē kibng'ōōkisiis chēē mākukwērtoochi *murtooywoontēēt. Nto mii bēsyēētaab sōmōk kung'eetee meet.’ ” ");
INSERT INTO spyNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kisēw ꞉chēēbyōōsōōchoo. ");
INSERT INTO spyNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kooyeey ꞉chēēbyōōsōōchoo wōloo kikwoonēē ānkubokwoomchi ng'aleechaa rubiik choo ki taman āk akeenke āk chuut alak. ");
INSERT INTO spyNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chēēbyōōsōōchoo ku Maaryaa nyēbo Maktaala, Choowaan, Maaryaa kaametiitaab Yāākōbō āk chēēbyōōsōōk alak chēē kiboontootē keey tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kichweesta ꞉rubiichoo chēēbyōōsōōchoo. ");
INSERT INTO spyNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ānkoo kuwuu nyooto, king'eet ꞉Bētērō ankulabat wōlooto kibo kochonkaanaa /kikēēmuchinē Yēēsu. Kōōkōōyto āriit, nto bērē kulē, kukas sirookaab Yēēsu baateey āmāmii ꞉bōōrto. Kooyeey ꞉Bētērō kaa kōōlātootē ām kiyēē kiyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kimii ꞉rubiik alake āyēēnku chēbo Yēēsu bēsyoonooto kubēētii saang'taab Emaawu. Kiyibē ꞉lōōyinnyii āsiiswēk āyēēng' kuwēētēē ꞉chiito Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kubēētii, kung'āloolootēē tukuuk tukul chēē kikiikuyēyākiis. ");
INSERT INTO spyNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kutākumii kwoomootē lōkōōy, kulumchi ꞉Yēēsu baanng'waa ankutas taay ꞉tukul ");
INSERT INTO spyNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kumānēēnkēt ꞉rubiik kule ki inee. ");
INSERT INTO spyNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kumwoochi ꞉Yēēsu kule, “Nee nyi ōng'āloolootēē ēē?” Kōōyyoong'iis ānkukās nyēē kāsāng'utiitu. ");
INSERT INTO spyNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kumwoochi ꞉rubiintēēt nyēē /kikēēkuurēē Kileeyoba Yēēsu kule, “Imāchē imwoowēēch kule inyiing' baateey ām Yēērusālēēm nyēē ‑mēēnkētē kiyēē kookuyeyakay?” ");
INSERT INTO spyNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kuteebee ꞉Yēēsu chiichoo kule, “Nee ꞉nyēē kookuyeyakay?” Kulē, “Ng'ālyoo kurubta keey āk Yēēsu nyēbo Nāāsārēēt. Ki *wōōrkooyoontēētaab Yēyiin nyēē kiboonto kāāmuukēywēēk ām wōlēē king'ālooltooy ānkuyēyē ng'al chēbo kwōng'uut ām taayeetaab Yēyiin āk biiko. ");
INSERT INTO spyNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kiiyokooyto ꞉mbo kibkōrōs chēē wōōyēch āk kāāntōōyikyoo /bokeebakach. /Kikēēkwērtoochi murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kōkiimoong'tēē keey ꞉acheek kule inee ꞉nyēē +machokootyaakta biikaab *Isrāyēēl. Bēsyēētaab sōmōk ꞉nyi ra kung'eetee kōyēyākiis ꞉ng'aleechu. ");
INSERT INTO spyNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nto subak, kākōōnēēch ꞉chēēbyōōsōōk alake kunameech ꞉tonkoy. Kamusta ākoy kochong' wōloo /kikiitōōrē, ");
INSERT INTO spyNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nteenee, mānāānyōōr bōōrnyii. Kāmwoowēēch kule kakas malayikaan alak chēē kāmwoochi icheek kule soboot ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kaakuba ꞉alake ām acheek wōlooto ānkubokunyōōr kuwuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kumwoochi ꞉Yēēsu bichooto kule, “Kyōōbuuswookēn sōō nyēē tyaa, ānku wuuyēch mētēwookwook kule nee! Ākoo mānōōyēnchi tukuuk tukul choo kiikumwooy *꞉wōōrkooyikaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","‑Mōōnkētē ꞉akweek kule kimisyinē kunyalil *꞉Kāārārookiintēēt ām tukuuchoo nto /kiitōrōōrē?” ");
INSERT INTO spyNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yooto, kōōbāng'boonkyi ꞉Yēēsu bichoo ām siruutēkaab Yēyiin kutoowunēē choo bo *Muusa ākoy chēbo wōōrkooyik tukul kurubta keey āk inee. ");
INSERT INTO spyNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yu makuyit saang'aa kibēētii, kuyey keey ꞉Yēēsu wuu nyēē kimāchē takutas taay āk baanaa. ");
INSERT INTO spyNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nteenee kiket ꞉bichoo kule kōōbuurto keey ꞉icheek, kuuyu, kikiikwiimēn ꞉kōōrēēt. Kucham ꞉Yēēsu kōōbuurto keey tukul. ");
INSERT INTO spyNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kumāchē kwoomiis, kunam ꞉Yēēsu mukaatiit ānkubirchi Yēyiin kōōnkōy. Kubetes ānkōōkoochi bichooto. ");
INSERT INTO spyNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kusēw ꞉bichoo kule ākoo ki Yēēsu ꞉nyooto. Kusēwu kuu nyooto, kubotē ꞉Yēēsu kule bil! ");
INSERT INTO spyNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kumwooy ꞉bichooto kule, “Kākāākēēng'ērēkiisyē sōō nyēē tyaa, yoo kāmii ꞉Yēēsu kumwoowunoonwēēch ng'aleek kurubta keey āk kiyēē mwooyē ꞉siruutēkaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kung'ēētyo ꞉bichooto areet akeenke ankooyeey Yēērusālēēm. Kibokunyōōr rubiichoo ki taman āk akeenke āk rubiik alak kumii yēēt akeenke. ");
INSERT INTO spyNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","/Kēēmwoochi bichooto tukwaay kule, “Kookung'eetee man ꞉Mokoryoontēēt meet ānku kāākōōboorchi keey Simōōni.” ");
INSERT INTO spyNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kumwoochinē ꞉bichooto kikwoonēē Emaawu chuut kiyēē kiyeyakay ām kēēltaab too āk subak wōlēē kiinkētito ꞉icheek Yēēsu, yu kāwokubetes mukaatiit. ");
INSERT INTO spyNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kutākumii ꞉bichoo kwoomchinē chuut lōkōōywēchoo, kutookunēē ꞉Yēēsu kōyooto ānkumwoochi kule, “Ōnyōōru tāloosyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kimuuyo ꞉bichoo, ānkubōōtoon kubērē tōōs āyiintēēt ꞉nyooto. ");
INSERT INTO spyNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nteenee kumwoochi ꞉Yēēsu kule, “Ām nee yu kōōmuuyē ankooyiimaak mēt ‑moochamte kule anii ꞉nyiitēnyi? ");
INSERT INTO spyNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Okas baa mbo āwunnyēkyuu āk kērēēnkōōk. Otabtab sookas, kuuyu, ōmiitē ōbērē tōōs anii ku āyiintēēt. Mātinyē ꞉āyiintō bōōr.” ");
INSERT INTO spyNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kōōboorchi āwunnyēk āk kērēēnkōōk. ");
INSERT INTO spyNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kiilat ꞉rubiik ānkung'ērēkiis, nteenee wuu nyēē kimā manta. Kuteebee ꞉Yēēsu kule, “Ōboontē āmnyoo?” ");
INSERT INTO spyNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","/Kiikoochi *burburyoontēēt nyēē kiwaatanaat ");
INSERT INTO spyNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ankwaam kukāsē ꞉rubiik. ");
INSERT INTO spyNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kumwoochi rubiikyii kule, “Ōsōōtyēēchi kiyoo kyāāmwoowook yoo kitākēēboontootē keey. Kyāāmwoowook kule misyinē kuyēyākiis ꞉tukuuk tukul kuu wōloo mwooytooy ꞉kitaabuunekaab *Muusa āk chēbo *wōōrkooyikaab Yēyiin āk choo bo kitaabuutaab Tyēēnwookik kurubta keey anii.” ");
INSERT INTO spyNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nto mii yoo, kung'oonkyi ꞉Yēēsu rubiikyii kōōnkēt kiyēē kimwooyē ꞉siruutēkaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kimwoochi kule, “Siraat kule makunyalil ꞉Kāārārookiintēēt anku makung'eetee meet ām bēsyēētaab sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","+/Makyaamtaat ām kōōrootunwēēk tukul kubuntēē kaayneenyii kule kuweek ꞉biiko ām miyootyēēt nyoo kiikuyey /sikēēnyōōchi kaat. Kookas ꞉akweek kuyēyāktōōs ng'aleechu. Kunyoo, o-amtaate lōkōōywēchu ōtoowunēē Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kookas, āmiitē wāāyookwook kiyēē kikuurtoowook ꞉Baaba. Nteenee ōkāng'iisyē yuutēyu bo kiriinkooni kut /kiiluumeenaak kāāmuukēywēēk kukwaanee kibkōōnkōy.” ");
INSERT INTO spyNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nto mii bēsyēēt ake, kuwēēto keey ꞉Yēēsu rubiichoo kung'eetee Yēērusālēēm kutākyinē keey Beetannyaa. Yu kariikta, kōōtōrōōr ꞉Yēēsu āwunnyēk ankusaay Yēyiin kōōbēruur rubiichoo. ");
INSERT INTO spyNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kutākumii kusooyē, /kēēyib kuwo kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kukutunkyi ꞉rubiichoo Yēēsu ankooyeey Yēērusālēēm kung'ērēkootiin miisin. ");
INSERT INTO spyNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kibēētii ꞉rubiichoo *Kōōtaab Yēyiin kibtaman kōōkoostooy Yēyiin.");
INSERT INTO spyNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ām taayta, kimiitē ꞉Ng'ālyoontēēt. Kiboonto keey ꞉Ng'ālyoontoonoo āk Yēyiin. Ki Yēyiin ꞉Ng'ālyoontoonoo, ");
INSERT INTO spyNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ānkiboonto keey āk Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","/Kikeeyey kiy ake tukul kubununēē inee. Nto kimā inee, nto mānāātook ꞉kiy ake tukul nyoo kiikutook. ");
INSERT INTO spyNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Chōōnēē ꞉soboonto wōlēē mii ꞉inee. Kiyibchi ꞉sobooniitēnyi biiko lēbkēēyyēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ikwēnyē ꞉lēbkēēyyoonoo mēēnānēēt, āmālukuyē ꞉mēēnānēēt lēbkēēyyēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kichō ꞉chiito ake nyēē kiiyook ꞉Yēyiin. /Kikēēkuurēē chiichoo Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kichokōōboorchinē ꞉Yoowaana biiko lēbkēēyyoonoo, sukung'eet kōōyēnchi. ");
INSERT INTO spyNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kichokōōboorchinē ꞉Yoowaana biiko kurubta keey āk lēbkēēyyoonooto āmēēbērē ki inee ꞉lēbkēēyyoonoo. ");
INSERT INTO spyNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kichōōnii ꞉lēbkēēyyoonoo kōōrēēt sukulēbkēēchi chii ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kichō ꞉Ng'ālyoontoonoo kōōrēēt nyoo /kikēēyēyē kubununēē inee, nteenee kimēēnkētē ꞉kōōrēēt kule ki ng'oo ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kichō kōōrēēnyii nteenee kitay ꞉biiko kutaach ");
INSERT INTO spyNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","nteenee mii ꞉biiko alake chēē kitaach inee ankookaasee keey. Kichāmchi bichooto kuyēk lōkōkaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mānāāyēk ꞉bichoo lōkōkaab Yēyiin kuu wōloo māktooy ꞉chii leekwa nto kuu yoo sichē ꞉chii leekwa, nteenee Yēyiin nkit ꞉nyēē yēyē bichoo kuyēk lōkōkyii. ");
INSERT INTO spyNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kichokuyēk ꞉Ng'ālyoontoonoo chii, kēēming'tē keey ankeekas wōōyinnyii, wōōyin nyoo nyōōrtooy ꞉wēēro nyēē akeenke baateey wōlēē mii kwaan. Kichāmē biich kuchurta ānkiyib manta. ");
INSERT INTO spyNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Inee ꞉nyoo kyoomtooy ꞉Yoowaana kukuurchinē barak kule, “Inee nyoo kyāāmwooyē kule mākuchō ām lētuunyuu nyēē boonto kāāmuukēywēēk kubiira, kuuyu kimii /kumānāākēēsichoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","/Kikiibēruurēēch acheek tukul kōōliikto kubo chamateet tukul nyēē boontēēnēēch ꞉chiichoo. ");
INSERT INTO spyNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kikōōnēēch *꞉Muusa kiruutēk, kuyibwēēch ꞉Kāārārookiintēēt Yēēsu chamateet āk manta. ");
INSERT INTO spyNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Māmii ꞉chii nyēē kiikukas Yēyiin, nteenee lakwaniitēnyi sālu Yēyiin ꞉nyēē kiikukas. Kiboonto keey Kwaan ānkiikōōboorwēēch wōlēē wuu ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nto mii bēsyēēt ake kōōyookto ꞉kāāntōōyikaab Yuutayeek mbo kibkōrōs āk biiko alak choo kibo kōōtaab Laawi kuba wōlēē kimii ꞉Yoowaana bokuteebee kule inee ku ng'oo. ");
INSERT INTO spyNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kiichuurta kule, “Mā anii *Kāārārookiintēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yooto kuteebee ꞉bichoo kule, “Ara, inyiing' ku *Eliiya?” Kumwooy kule, “Acha.” /Keeteebee subak kule, “Ara inyiing' ku *wōōrkooyoontoonoo bo Yēyiin nyoo king'āloolēē ꞉Muusa.” Kulē, “Anii mbonō.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nto mii yoo nanyuun, kumwooy ꞉bichoo kule, “Ānkiimwoowēēch, inyiing' ku ng'oo? Imwoowēēch subokiiboorchi biiko choo kēēyookwēēch. Imāchē bokiibaartiing' kule inyiing' ku ng'oo naas?” ");
INSERT INTO spyNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kuwālchi ꞉Yoowaana bichoo kule: Anii nyoo king'āloolēēnoo *꞉Isaaya kumwooyē kule, “Miitē ꞉kuut nyēē kuuru ām suurkwēēn kule, ‘Ōchuulchi Mokoryoontēēt kēēlto.’ ” ");
INSERT INTO spyNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ki Farisaayeek ꞉bichoo kiiyooktooyiisyē. ");
INSERT INTO spyNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kiteebee ꞉bichoo /kikiiyooktooy Yoowaana kule, “Yoo mā inyiing' Kāārārookiintēēt āmēēbērē inyiing' ku Eliiya, nto ku wōōrkooyoontoonoo bo Yēyiin, ām nee yu ibātisāniisyē?” ");
INSERT INTO spyNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kuwālchi ꞉Yoowaana bichooto kule, “Ābātisāniisyēē ꞉anii bēēko, nteenee miitē ꞉chii nyēē ōboontē keey āmōōnkētē. ");
INSERT INTO spyNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Inee ꞉nyēē āmiitē āyēytoochinē kēēlto ānku wōō nyēē ‑māāyēmē mbo kut ārēēkyi kwēyōōnik.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kiyēyāksēē ꞉ng'aleechu tukul Beetannyaa ām biitēēt ake nyēbo āynēētaab Yoortaan, wōlēē kimii ꞉Yoowaana kōōbātisāniisyēē. ");
INSERT INTO spyNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yu kāyyēēkunēē, kukas ꞉Yoowaana Yēēsu kuchōōnii. Yooto kumwooy kule, “Ong'nyiin *Mēēnkit nyēbo Yēyiin nyēē inēmtooy ng'ōōkiswookikaab kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Inee ꞉nyoo kyāāmwooyē kule, ‘Miitē kuchōōnii ꞉chii nyēē boonto kāāmuukēywēēk kubiira, kuuyu kimii ꞉inee /kumānāākēēsichoo.’ ");
INSERT INTO spyNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kōmāānkētē ꞉anii chiichoo, nteenee kichāābātisānēē biiko bēēko sukōōnkēt ꞉biikaab *Isrāyēēl.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nto mii yoo, kumwooy ꞉Yoowaana kule: “Kaakas kurēku ꞉Tāmirmiryēētaab Yēyiin nyēē wuu chēēbtuukē ānkōōbutyi Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nto kōmēēboorwoo ꞉Yēyiin, nto kōmāānkētē inee. Kōōyookwoo ꞉Yēyiin chāābātisāniisyēē bēēko, kimwoowoo kule, ‘Yoo keekas chii nyēē kēēbutyi ꞉Tāmirmiryēēnyuu, ku nyooto ꞉nyēē mākubātisāniisyēē Tāmirmiryēēt.’ ");
INSERT INTO spyNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Manta kyaakas ng'aleechu ānkāāmwoowook kule Lakwataab Yēyiin ꞉chiichooto.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yu kāyyēēkunēē, kimii ꞉Yoowaana kukēēyyo subak ākoo rubiik āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kumii ꞉Yēēsu kumurē yooto, kumwooy ꞉Yoowaana kule, “Ong'nyiin *Mēēnkit nyēbo Yēyiin!” ");
INSERT INTO spyNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yu kakas ꞉rubiichoo bo Yoowaana kuu nyooto kubakaakta inee ankurub Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kuweech keey ꞉Yēēsu ankuteebee kule, “Ōchēēng'ē nee ēē?” Kulēēnchi ꞉bichoo Yēēsu, “Iminyē ānō ꞉inyiing' ōō, Kāānēētiintēēt?” ");
INSERT INTO spyNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kumwoochi ꞉Yēēsu kule, “Okwaa bookas.” Kimii ꞉asiista ang'wan nyēbo kōrrōōn. Kibeeta keey wōlēē kiminyē nto yityo, kōōbuurto keey bēsyoonooto. ");
INSERT INTO spyNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Akeenke ām bichoo āyēēng' ku Antereeya nyoo ki ng'eetaabkaametiitaab Simōōni. ");
INSERT INTO spyNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kiwokucheeng'aat ꞉Antereeya ng'eetaabkaamet Simōōni nto yu nyōōru kumwoochi kule, “Kookeekas Meesaaya.” (Kerkeey ꞉kaaynaani bo ‘Meesaaya’ yoo /kakeemwa ām kuutiitaab Kirikiik kule *Kiriistō, (nyēē ng'aabaat) kōōbooru kule Kāārārookiintēēt.) ");
INSERT INTO spyNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yooto kuwēēto ꞉Antereeya ng'eetaabkaam Simōōni wōlēē mii ꞉Yēēsu. Kōōrōōtoot ꞉Yēēsu Simōōni ānkumwooy kule, “Inyiing' ku Simōōni araab Yoowaana nteenee +/mākēēkuurēēniing' Keefa.” (Ibooru kaaynaani bo ‘Keefa’ ām kuutiitaab Kirikiik kule Bētērō, nyēē ibooru kule Rwaa.) ");
INSERT INTO spyNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yooto kāyyēēkunēē, kumach ꞉Yēēsu kuwo Kalilaaya. Yu kātuuyēē Filibō kumwoochi kule, “Irubwaa.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Kibo ꞉nkinee Filibō *kiriinkēētaab Beetsaayta wōloo kiminyē ꞉Antereeya ākoo Bētērō. ");
INSERT INTO spyNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kicheeng' ꞉Filibō Nāātānnyēēl nto nyōōru kumwoochinē kule, “Kookeekas Kāārārookiintoonoo king'āloolēē *꞉Muusa ankung'alaalee nkicheek *꞉wōōrkooyikaab Yēyiin. Chiichooto ku Yēēsu araab Yōōsēēf nyēbo *kiriinkēētaab Nāāsārēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yooto kuteeb ꞉Nāātānnyēēl kule, “'Kēēlē nee ōō! Mii nkinee ꞉kiy nyēē karaam Nāāsārēēt?” Kumwoochi ꞉Filibō Nāātānnyēēl kule, “Chōō cheekas.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yu kakas ꞉Yēēsu Nāātānnyēēl kuchōōnii, kung'alaalee kule, “*Isrāyēēliintēēt nyi nanyuun ꞉nyēē sikēn āmātinyē lembech.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kuteebee ꞉Nāātānnyēēl Yēēsu kule, “'Kēēnkētēēnoo nee?” Yooto kuwālchi ꞉Yēēsu kule, “Kāākāsyiing' *mutiiniit keel kutoombo kukuuring' ꞉Filibō.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yooto kumwooy ꞉Nāātānnyēēl kule, “Kāānēētiintēēt, inyiing' Lakwataab Yēyiin, Bāytooyiintēētaab *Isrāyēēliik.” ");
INSERT INTO spyNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kumwoochi ꞉Yēēsu kule, “!Keechamtaa kuuyu kāāmwoowuung' kule kāākāsyiing' mutiiniit keel. +Meekas chēē chaang' chēē wōōyēch kusiir chuutēchu. ");
INSERT INTO spyNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","!Kāāmwoowook, +mookas barak kuyootāktōōs. +Mookas kurēkyoo anii *Wēritaab Chii, ꞉malayikaanikaab Yēyiin ānkuloong'tooy.” ");
INSERT INTO spyNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Ām bēsyēētaab sōmōk kuchakee yooto, kimii ꞉saakweetaab kooyēēy nyēē /kikeeyeyee saang'taab Kaana ām Kalilaaya. Kimii ꞉Yēēsu saakwaanaata āk kaamet kuboonto keey rubiikyii. ");
INSERT INTO spyNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kikyaam saakweet nto mii kwēēn āk kwēēn, kurār *꞉tifaayiik. Kumwoochi ꞉kaamet Yēēsu kule, “Kāmēēkuboonto naas ꞉bichu tifaayiik.” ");
INSERT INTO spyNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kumwoochi ꞉Yēēsu kaamet kule, “Imāchēēnoo nee? Ntēē mānāāyityiin asiisnyuu.” ");
INSERT INTO spyNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kuwēēkyi keey ꞉kaamet motwoorik ānkumwoochi kule, “Oyey kiyēē mākumwoowook.” ");
INSERT INTO spyNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ām ātēbuutēkaab Yuutayeek, kimii ꞉ntasimnyeet nyēē /kikiitiliilēē keey. Kurubta keey āk yooto, kimii ꞉tērēēnik lo chēbo bēēko. Kiyibē ꞉tērēēt akeenke bēēko chēē kiimuuchē kuyit liitaanik 80. ");
INSERT INTO spyNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yooto kumwoochi ꞉Yēēsu motwoorik kule, “Onyiit bēēko tērēēnichoo.” Koonyiit ꞉motwoorichoo bēēko tērēēnichoo kule bak. ");
INSERT INTO spyNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nto yityo kumwoochi kule, “Oram bēēchooto alak ānkōōyibchi chiito nyoo iyyoonkyinē saakweet.” Kurub ꞉motwoorichoo kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nto bērē ꞉boontoonoo kuchamcham, koolat miisin kuuyu kikiikuweek kuyēk tifaayiin. Kimēēnkētē ꞉boontoonoo wōlēē kikwoonēē ꞉tifaayiichaa nteenee kiinkēt ꞉motwoorichoo wōlēē kirāmēē bēēko. Kukuur ꞉chiichoo saanteet kuwo komos ");
INSERT INTO spyNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ānkumwoochi kule, “Ikooytooy ꞉biiko kwaak tifaayiik choo kāroomēch yoo toowu ꞉saakweet, nto yoo wuu nyēē kābiyoong'iis ꞉biiko /kēēyib choo tāytāy. Ntēē siikonor ꞉inyiing' tifaayiik chēē ānyinyēch miisin ānkuchēēkoochi biiko kumii ꞉saakweet wokubēku?” ");
INSERT INTO spyNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ng'ālyoontēētaab kwōng'uut ꞉nyiitēnyi nyēbo taay kuyey ꞉Yēēsu ānkiyēyāksēē saang'taab Kaana ām Kalilaaya. Yooto nanyuun, kōōboorunēē ꞉Yēēsu wōōyinnyii ng'aleechaata ankookaasee keey ꞉rubiikyii. ");
INSERT INTO spyNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yu kāākubēk nanyuun, kuwo ꞉Yēēsu Kaabernaam, kuboontootē keey kaamet, mbo ng'eetaabkaamet ākoo rubiikyii. Kibēēni wōlooto bēsyōōs chēē ng'ēri. ");
INSERT INTO spyNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yu kaakuriik *꞉Saakweetaab Keeytaayeet nyēbo Yuutayeek, kuwo ꞉Yēēsu Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yu kayit wōlooto, kukas biiko ām biiwuutaab *Kōōtaab Yēyiin kwooltooy tuuka, kēēchiirēk āk chēēbtuukēēnik. Kimii ꞉nkicheek chēē kiwālāng'tooy beesaanik. ");
INSERT INTO spyNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yooto, kōōkwoor ꞉Yēēsu bōrōōk kuyey musyāritiit kukwetee kēēchiirēk āk tuuka tukul chēē kimii yooto. Nto yityo, kululukto beesaanikaab bichoo ankootyeel meesoosyekwaa. ");
INSERT INTO spyNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kimwoochi biiko choo kyooltooy chēēbtuukēēnik kule, “Ōnēmunēē yu tukuuchu! Ām nee yu kyooweech Kōōtaab Baaba kuyēk wōlēē /kyooltooyiisyēē?” ");
INSERT INTO spyNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yu kakas ꞉rubiikyii ng'aleechaa, koosoot yoo mwooyē ām siruutēkaab Yēyiin kule, “Iwoong'too ꞉chamateet nyēē āboontēē Kōōng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kuwāl ꞉kāāntōōyikaab Yuutayeek kule, “Ng'oo ꞉nyēē kākōōning' kāāmuukēywēēk ikwetee biiko kōyi bo Yēyiin? Nto subak, ng'ālyoo nee nyēbo kwōng'uut nyēē imuuchē iyey iboorunēē kule iboontē kāāmuukēy?” ");
INSERT INTO spyNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kuwālchi ꞉Yēēsu kule, “Ōturbuub kōyi bo Yēyiin ānku +maateechee ꞉anii bēsyōōsyēk sōmōk.” ");
INSERT INTO spyNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kukētyi ꞉bichoo Yēēsu kule, “Kiyib ꞉kōyi bo Yēyiin kēnyiisyēk artam āk lo sukuteechakay. Imwooyē ꞉inyiing' kule +meeteechee bēsyōōsyēk sōmōk?” ");
INSERT INTO spyNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nteenee king'āloolēē ꞉Yēēsu bōōrnyii nkit mēēbērē *Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nto yu /kabokiing'eetee Yēēsu meet lētuunoo, kusēw ꞉rubiikyii kule kikiikumwooy ꞉Yēēsu ng'aleechaa. Yooto nanyuun, kōōyēnchi ꞉rubiichoo siruutēkaab Yēyiin āk kiyēē kimwooyē ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kuyey ꞉Yēēsu ng'al chēē chaang' chēbo kwōng'uut kumii saakwaanaa bo Keeytaayeet ām Yēērusālēēm. Yooto kōōyēnchi inee ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ānkoo kiwuu nyooto, manaachamta ꞉Yēēsu bichoo kuuyu kiinkētē wōlēē wuu ꞉chiito ake tukul ");
INSERT INTO spyNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","āmēēbērē kimāchē /kēēmwoochi wōlēē wuu ꞉chiito. ");
INSERT INTO spyNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kimii ꞉kāāntōōyiintēēt ake nyēē ki *Fārisooyiin nyēē kibo *kōōkwēētaab Yuutayeek nyēē /kikēēkuurēē Nikōtēēmō. ");
INSERT INTO spyNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kiwo ꞉chiichoo bēsyēēt ake kwēēmooy wōlēē kimii ꞉Yēēsu ānkumwoochi kule, “Boontēēt, kiinkētē kule inyiing' kāānēētiintēēt nyēē kiiyookuung' ꞉Yēyiin. Māmii ꞉chii nyēē imuuchē kuyey ng'al chēbo kwōng'uut kuu yoo iyēyē ꞉inyiing', yoo mēēbērē boonto kāāmuukēywēēkaab ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kuwālchi ꞉Yēēsu kule, “!Kāāmwoowuung', māmii ꞉chii nyēē makukas bāytooyiisyēētaab Yēyiin yoo /mānāākēēsich subak.” ");
INSERT INTO spyNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yooto kumwooy ꞉Nikōtēēmō kule, “So, /kēēsichē kule nee subak chii nyēē kiikuwōōyiit? Mākoy kōōwut mooyēētaab kaamet /ānkēēsich subak.” ");
INSERT INTO spyNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kulēēnchi ꞉Yēēsu, “!Kāāmwoowuung', māmii ꞉chii nyēē iwutē Kaab Yēyiin yoo /mānāākēēsich ām bēēko āk Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sichē chiito ꞉kwaan āk kaamet, nteenee yoo sukuyēk lakwataab Yēyiin kusichē ꞉Tāmirmiryēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‑Meekany kunaming' kuut yoo kāāmwoowuung' kule, ‘Māchāktōōs /kēēsich chii subak.’ ");
INSERT INTO spyNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wusē ꞉yoomeet āmēēnkētē ꞉chii wōlēē chōōnēē nto wōlēē wēētii. Wuu nyooto wōlēē siktooy ꞉Tāmirmiryēētaab Yēyiin chiito.” ");
INSERT INTO spyNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kuteeb ꞉Nikōtēēmō kule, “Yēyāktōōs ꞉yooto kule nee?” ");
INSERT INTO spyNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kuwālchi ꞉Yēēsu kule, “Iyēku oob kāānēētiin ām kōōrēētaab *Isrāyēēl, so, ‑mēēnkētē ng'aleechu? ");
INSERT INTO spyNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ānkētē kiyēē āmiitē āmwoowuung', ānkāārāru kiyēē kyaakas. Ānkoo kuwuu nyooto, ‑mōōchāmē ng'aleekyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kwāāmwoowook ng'aleekaab kōōrooni, āmōōyēnwoo. Kunyi ii, ōmuuchē raat kule nee ōyēnchi ng'al chēē rubtooy keey āk Kaab Yēyiin? ");
INSERT INTO spyNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Māmii ꞉chii ām kōōrooni nyēē kiikuwo Kaab Yēyiin, nteenee *Wēritaab Chii nkit ꞉nyēē kichōōnēē wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kuu yoo kiitōrōōrchinē *꞉Muusa barak eereenaanaa ām suurkwēēn, ām kēēlto nyēē wuu nyooto, +/mākiitōrōōr Wēritaab Chii, ");
INSERT INTO spyNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","si yoo keekaaseenaa keey ꞉chii kunyōōru *soboontaab kibchuulyo.” ");
INSERT INTO spyNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kicham ꞉Yēyiin kōōrooni miisin kut kukōōn lakwanyii nyooto akeenke baateey sukung'eet ꞉chii ake tukul nyoo ikoosēē keey lakwanaa mēēbērē mākubot, nteenee mākunyōōr *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kimēēyooku ꞉Yēyiin lakwanyii chokooruusta biiko nteenee chokooraraach. ");
INSERT INTO spyNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","‑/Mākiiruustooy chii nyoo keekaasee keey lakwanaa. Nteenee iruustaayaat ꞉nyoo ‑mēēkoosēē keey, kuuyu kitay kookaasee keey lakwani akeenke baateey bo Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nto yoo /sikiiruusta chii kumii kule: Kiikuchō ꞉lēbkēēyyēēt kōōrēēt, nteenee kucham ꞉biiko mēēnānēēt kubo ng'ōōkisto nyēē yēyē. ");
INSERT INTO spyNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chii ake tukul nyoo yēyē ng'ōōkisto kuwēchē lēbkēēyyēēt kuuyu imuuchē kutook ꞉ng'ōōkisnyii. ");
INSERT INTO spyNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nteenee chiito nyoo yēyē ng'aleekaab manta, kuchōōnii wōlēē mii ꞉lēbkēēyyēēt sukutook kule kiyēē yēyē, kuwuu wōlēē māktooy ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yu kang'eetee ꞉Yēēsu ākoo rubiikyii Yēērusālēēm bokubēēnnyoot yēēmēētaab Yuuteeya ānkubātisāniis. ");
INSERT INTO spyNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kimii ꞉nkinee Yoowaana kubātisāniisyē ām yēē /kikēēkuurēē Aynoon yēē kilēēkitēē Salim wōloo ki chaang' ꞉bēēko. Kibēētii ꞉biiko kwaak wōlooto /bokēēbātisānē. ");
INSERT INTO spyNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Kiyēyāktōōs ꞉ng'aleechu kutoombo /keekerta Yoowaana kāābrātiisyō.) ");
INSERT INTO spyNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kikwiilē keey ꞉rubiik alake chēbo Yoowaana ākoo Yuutāyiintēēt ake kubo ntāsimuutēkaab kāātiliilēēt kurubta keey ākoo ātēbuutēkaab Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kunyoo, kubēēchi ꞉rubiichooto Yoowaana ānkumwoochi kule, “Kāānēētiintēēt, tēēsōōtē chiichoo kyōōboontē keey ām biitēēt ake nyēbo āynēētaab Yoortaan, chiichoo 'kiing'āloolēē? Mii ꞉chiichooto kōōbātisāniisyē kuu nyiitēnyi, ānkāākōōwuuyēēnēēch biiko tukul.” ");
INSERT INTO spyNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kuwālchi ꞉Yoowaana kule, “Māmii ꞉chii nyēē nyōōru kiy yoo mānāākōōkoochi ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kyōōkāsē āmwooyē nkityō kule, ‘Anii mbonō *꞉Kāārārookiintēēt, nteenee kisimāntōōwu ām inee.’ ");
INSERT INTO spyNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ām saakweetaab kooyēēyto, bo ꞉murereet saanteet. Nteenee kāng'iisyē ꞉choorweetaab saantaanaa ām kaab kooyēēy nto yoo kāsē kung'ālooloonu ꞉choorweenyii kung'ērēchē. Kunyi kaakuchurta ꞉ng'erekweekyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Māchāktōōs kutōrōriit ꞉Kāārārookiintēēt ānkāārēku ꞉anii.” ");
INSERT INTO spyNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Boonto ꞉chii nyoo chōōnēē kibkōōnkōy kāāmuukēywēēk kubiir chii ake tukul. Nto nyoo bo ng'wēny kubo kōōrooni ānkung'āloolē ng'aleek chēē rubtooy keey āk ng'wēnyuuni. Wōō ꞉nyoo bo kibkōōnkōy kubiir chii ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mwoowu ꞉chiichoo bo kibkōōnkōy kiyēē kiikukasee koonyekyii āk yiitiikyii, ‑/āmākēēkāsyinē ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nto nyoo kāsyinē ng'aleekyii kōōkiimē kule bo man ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mwoowu ꞉chiichoo /kikiiyookunēē kibkōōnkōy ng'aleekaab Yēyiin, kuuyu ikoochinē ꞉Yēyiin Tāmirmiryēēnyii kuyem. ");
INSERT INTO spyNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Chāmē ꞉Yēyiin lakwanyii ānkiikurōōbchi kiy ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chii nyoo ikoosēē keey lakwanaa kunyōōru *soboontaab kibchuulyo. Nto nyoo māchāmē, mākōōng'woonchi ꞉Yēyiin nyēē mānyōōru soboonoo. ");
INSERT INTO spyNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nto mii yoo, kukas *꞉Farisaayeek kule kimii ꞉Yēēsu kōōyumē ānkōōbātisānē biiko chēē chaang' kubiir Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kubooyiit man maneebatisan ꞉Yēēsu chii, nteenee ki rubiikyii ꞉chēē kiibātisāniisyē. ");
INSERT INTO spyNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yu kakas ꞉Yēēsu kule kāākōōnkēt ꞉Farisaayeek ng'aleechaa, kung'eetee Yuuteeya ānkutākyi keey Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nteenee ki ākoy kumur kōōrēētaab *Samaaryaa. ");
INSERT INTO spyNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kumii Samaaryaa, kuba ākoy *kiriinkēēt ake nyēē /kikēēkuurēē Sikaar yēē kilēēkitēē mbaraanaa kiikoochinē ꞉Yāākōbō wērinyii Yōōsēēf. ");
INSERT INTO spyNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kimii ꞉riibkēētaab Yāākōbō yooto. Kuyitē ꞉Yēēsu riibkoonoo, kikiikuriikta ꞉asiista taman āk āyēēng', kōōbuur ng'wēny, kuuyu kikiikuchaas. ");
INSERT INTO spyNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yooto kuchō ꞉koorkēēt ake nyēbo *Samaaryaa. Kumwoochi ꞉Yēēsu koorkoonoo kule, “Ikōōnoo bēēko ayye.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kikiikuba ꞉rubiikyii bokwaal āmiik ām kiriinkoonoo. ");
INSERT INTO spyNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kumwoochi ꞉koorkoonoo Yēēsu kule, “Āyēku anii chēēbsāmooryāyiin, iyēku ꞉inyiing' Yuutāyiin. So, imuuchāktōōs kule nee ārāmuung' bēy?” Kimwooy ꞉koorkoonoo kuu nyooto kuuyu kimākāsyiintōōs ꞉Yuutayeek āk *Samaaryayeek. ");
INSERT INTO spyNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kuwālchi ꞉Yēēsu kule, “Nto 'kēēnkētē kiyēē kōōnu ꞉Yēyiin, ānkiinkētē chiichi soomiing' bēy, nto 'kēēmwoochinē kukōōning' bēēkaab soboon.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kumwoochi ꞉koorkoonoo Yēēsu kule, “Mokoryoontēēt, irāmēē nee bēēchoo ‑āmēēboontē terekyeet. Nto subak, kooy ꞉riibkēēt. Kunyi ii, inyōōrchinē ānō ꞉inyiing' bēēchooto bo soboon? ");
INSERT INTO spyNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kikōōnēēch ꞉kuuko acheek Yāākōbō riibkooni. Kiyyēē ꞉inee bēēkaab riibkooni āk lōkōkyii kuboonto keey boroobikyii. Imāchē iyib keey ꞉inyiing' kule ibiirē Yāākōbō?” ");
INSERT INTO spyNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yooto kuwālchi ꞉Yēēsu kule, “Āmē ꞉melelta subak chii ake tukul nyēē yyēē bēēkaab riibkooni, ");
INSERT INTO spyNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nto nyoo kayye bēēko chēē ākoochinē ꞉anii, mākoy kwaam nyoo ꞉melelta subak. Mākukoosunēē chiichoo ꞉bēēkaab soboon ākookoy.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kumwoochi ꞉koorkoonoo Yēēsu kule, “Mokoryoontēēt, ānkiikōōnoo bēēchooto ōō, lēyyē, simaama ꞉melelta subak, amatachaaram bēy.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kumwoochi ꞉Yēēsu kule, “Wēēkuur saanteeng'uung' ankookwaante keey ākoy yu.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kuwālchi ꞉koorkoonoo Yēēsu kule, “‑Māāboontē ꞉anii saannyaa.” Kumwoochi ꞉Yēēsu kule, “Man. ‑Mēēboontē saannyaa. ");
INSERT INTO spyNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kiikoomutiing' ꞉murēnik muutu, āmā saanteeng'uung' mbo ꞉chiichoo ōboontē keey kuu nyi. Man ꞉kiyēē 'keemwaay.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yooto, kumwoochi ꞉koorkoonoo Yēēsu kule, “Ntēē iyēku wōōrkooyoo! ");
INSERT INTO spyNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kikutunkyinēē mbo ꞉kuuko Yēyiin lekemaani. Ām nee sōōmwooyē ꞉akweek Yuutayeek kule wōlēē yemaat /kēēkutunkyinēē Yēyiin ku Yēērusālēēm?” ");
INSERT INTO spyNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kimwoochi ꞉Yēēsu kule, “Kas kiyēē āmwooyē, makuyit ꞉bēsyēēt nyēē mākoy kukutunkyinēē ꞉biiko Baaba Yēyiin lekemaani nto ku Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ōkutunkyinē ꞉akweek Samaaryayeek kiyēē ‑mōōnkētē, nto acheek kiinkētē kiyēē kēēkutunkyinē kuuyu bununēē ꞉kaararaacheet Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nteenee makuyit ꞉bēsyēēt, ankookuyit mbo kēny, yēē mākukutunkyinē ꞉biiko Baaba ām Tāmirmiryēēt āk manta. Biiko chēē sooyē kuu nyooto chēē māchē ꞉Baaba. ");
INSERT INTO spyNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yēyiin ku tāmirmiryo. Kunyoo māchāktōōs /kēēkutunkyinē ām Tāmirmiryēēt āk manta.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kumwooy ꞉koorkoonoo kule, “Ānkētē kule mākuchō *꞉Kāārārookiintēēt, nto yoo kāchō, mākōōboorwēēch kiy ake tukul.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kuwālchi ꞉Yēēsu kule, “Ntēē nyiitēnyi ng'ālooluung'!” ");
INSERT INTO spyNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ām āsiiswēchooto kōōyēēw ꞉rubiikaab Yēēsu. Kiilat miisin kukas kumii kung'āloolē ꞉Yēēsu āk koorko. Nteenee māmii ꞉nyēē kikany kuteebee koorkoonoo kule, “Imāchē nee?” nto kulēēnchi Yēēsu, “Ōmwooyē nee āk koorkooni?” ");
INSERT INTO spyNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kubakaakta ꞉koorkoonoo tērēētaab bēēko ankooyeey areet akeenke ākoy kiriing' ānkumwoochi biiko ām wōlooto kule, ");
INSERT INTO spyNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Biikyoo, ankookwaa bookas chii nyēē kāmwoowoo kiy ake tukul nyēē kyaayey! Kut ku mā inee *Kāārārookiintēēt?” ");
INSERT INTO spyNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kung'ēētyo ꞉biikaab kiriinkoonooto ānkutākyi keey wōlēē kimii ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kuwēētii koorkoonoo, kusaaysaay ꞉rubiik Yēēsu kule kwoomiis. ");
INSERT INTO spyNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nteenee kumwoochi ꞉Yēēsu kule, “Āboontē āmnyoo nyēē ‑mōōnkētē ꞉akweek.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kwaam rubiik mēt ankuteebee keey kule, “Ara mii ꞉chii nyēē kāākuyibchi āmnyoo?” ");
INSERT INTO spyNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kumwoochi ꞉Yēēsu rubiichooto kule, “Āmnyoontēēnyuu ku ayey mākuutēkaab Baaba nyoo kiiyookwoo ānkāāwoong'u yiisyēēt nyēē kimākwoo chaayey. ");
INSERT INTO spyNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ōmwooyē sōō nee kule, ‘Kāākung'ēt ꞉ārook ang'wanu /kēēkēsiis’? Kāāmwoowook kule, ōrōōtootē mbareenichuut. Kaakuleelakiitu nyēē kaakuyem /keekes. ");
INSERT INTO spyNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kāākutoow ꞉kēsiisyēēt kēny /ānkāākiibēruur kēsiintēēt. Mii kukēsē āmnyoontēētaab *soboontaab kibchuulyo sukung'erech ꞉nyoo choonsē āk nyoo kēsiisyē. ");
INSERT INTO spyNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Man ng'ālyoontoonoo /kēēmwooyē kule, ‘Choonē ꞉ake, kukes ꞉ake.’ ");
INSERT INTO spyNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kāāyooktook bōōkēsiisyē ām mbar nyēē manooyey yiisyō. Kitoowu ꞉alake yiisyēēt nteenee boowaang'te ꞉akweek.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kicham ꞉biikaab Samaaryaa chēē chaang' ām kiriinkoonoo *Kāārārookiintēēt, yu kāwokumwoochi ꞉koorkoonoo kiy ake tukul nyēē kimwoochi ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nto yu kabokukwa ꞉bichoo bo Samaaryaa yooto kimii ꞉Yēēsu, kusaaysaay Yēēsu kōōbuurto keey icheek. Kucham ꞉Yēēsu kōōbuur wōlooto bēsyōōsyēk āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kiikaasee keey ꞉biiko alake subak chēē chaang' inee kubo kiyēē kimwooy. ");
INSERT INTO spyNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kimwoochi ꞉bichoo koorkoonoo kule, “Mēēbērē kakiikaasee keey Yēēsu kuuyu 'kēēmwoowēēch, nteenee kuuyu kaakeekas ꞉acheek nkit kiyēē mwooyē. Kāākiinkēt kule inee ku Kāārārookiintēēt man nyēbo biiko tukul.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nto yu kāākubēēni ꞉Yēēsu wōlooto bēsyōōs āyēēng', kutas taay āk baannyii ākoy Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mānāāwokuminy ꞉Yēēsu kiriinkēēng'waa Nāāsārēēt kuuyu kikiikumwooy ꞉inee nkit kule, ‑/mākēēkoonyitē *wōōrkooyoontēētaab Yēyiin ām kōōrēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nto yu kayit Kalilaaya, kutorooch ꞉biiko kuuyu kikiikukas ꞉icheek kiyēē kiyey ꞉Yēēsu ām Yēērusālēēm yoo kibēētii bokwoomē saakwaanaa bo Keeytaayeet. ");
INSERT INTO spyNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nto mii yoo kuwo kiriinkēētaab Kaana wōloo kiwēēchēē bēēko kuyēk tifaayiik. Kimii ꞉kāāntōōyiintēēt ake kaab bāytooyiintēēt ām kiriinkēētaab Kaabernaam nyēē kiboonto wērinyii nyēē kimnyoonē. ");
INSERT INTO spyNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yu kawokukas ꞉kāāntōōyiintoonoo kule kāākuchōōnēē ꞉Yēēsu Yuuteeya, wokusaaysaay kuchō Kaabernaam chokōōsoobchi wērinyii nyēē ki lalaat miisin. ");
INSERT INTO spyNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yu kayit, kumwooy ꞉Yēēsu kule, “Ām nee yu māchē ꞉biiko alake ayey kiy nyēbo kwōng'uut nto iyēnchinē ng'aleekyuu?” ");
INSERT INTO spyNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kumwoochi ꞉kāāntōōyiintoonoo Yēēsu kule, “Keebe ōō, mokoryoontēēt, kumanaang'et ꞉leekweet.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yooto kuwālchi ꞉Yēēsu kule, “Wēēchi keey kaa, kāākusob ꞉lakwang'uung'.” Kiiyēnchi ꞉chiichoo kiyēē kimwoochi ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nto lētuunoo kumii ꞉kāāntōōyiintoonoo kōōyēēyē, kutuuyēē motwoorikyii kēēlto. Kumwoochi ꞉choo kule, “Kāākusob ꞉wēring'uung'!” ");
INSERT INTO spyNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kuteebee ꞉kāāntōōyiintoonoo bichooto kule, “Ko tyaa ꞉asiista kukāykāyiitu ꞉wēēriit?” /Kēēlēēnchi, “Kō asiista akeenke lang'at kosolēny.” ");
INSERT INTO spyNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kusēw ꞉kwaan kule kō tēē yooto ꞉asiista kumwoochinē ꞉Yēēsu kule, kāākusob ꞉leekweet. Kunyoo, kiikaasee keey ꞉chiichoo āk kanyii tukul Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ki kwōng'uutyēētaab āyēēng' ꞉nyiitēnyi kuyēyē ꞉Yēēsu kuchakee kēēyēēwunēē Yuuteeya kuchō Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kuwo ꞉Yēēsu lētuunoo Yēērusālēēm wōlēē kimii kuyēyēē ꞉Yuutayeek saakweet. ");
INSERT INTO spyNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kimii ꞉kibōōyto ake nyēē kilēēkitēē yēbo Oreetaab Kēēchiirēk nyēē kikiimuut ꞉kēēlwookik muutu chēē kitinyē wuurwēēt. /Kēēkuurē yooto ām kuutiitaab Yuutayeek kule Beteesta. ");
INSERT INTO spyNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kimii ꞉biiko chēē kimnyoontōōs chēē kimurēē keey ng'wēny ām kēryōōsyēchooto. Kikōryootiin ꞉alake, kusōnkōchootiin alake āk chēē kichunkutootiin. ");
INSERT INTO spyNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kikiikusyēn ꞉akeenke ām bichoo kēnyiisyēk sosom āk sisiit. ");
INSERT INTO spyNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yu kakas ꞉Yēēsu chiichooto kukārintit ām yooto kōōnkēt kule kikiikusyēn kēnyiisyēk chēē chaang'. Kuteebee chiichooto kule, “Imāchē isob?” ");
INSERT INTO spyNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kuwālchi ꞉chiichoo kule, “Mokoryoontēēt, māmii ꞉chii nyēē kawiira kibōōyoo yoo wērwērē keey ꞉bēēko. Yoo kātāāsyēēmē, kāsimkōōwut ꞉ake kēny.” ");
INSERT INTO spyNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kumwoochi ꞉Yēēsu kule, “Ng'eet ankiinam kisyeereeng'uung' ānkiiwēēsyēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kusob ꞉chiichooto bakeenke. Kinam kisyeereenyii ānkuwēēchi keey! Kuyēyāktōōs ꞉ng'aleechu, ki bēsyēētaab Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kunyoo, kumwoochi ꞉kāāntōōyikaab Yuutayeek chiichoo /kākiisoobē kule, “Inkēt kule bēsyēētaab *Sabaato ra? Māchāmuung' ꞉kiruutēkyoo inamaate kisyeereet.” ");
INSERT INTO spyNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kuwālchi ꞉chiichoo kule, “Chiichoo kēēsooboo ꞉nyēē kāmwoowoo anam kisyeereenyuu ānkāāwēēsyēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kuteebee ꞉bichoo kule, “Chii ng'oo ꞉nyooto kāmwoowuung' inam kisyeereeng'uung' ānkiiwēēsyēt?” ");
INSERT INTO spyNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kimēēnkēt ꞉chiichoo /kikiisoobē kule ki ng'oo ꞉nyooto, kuuyu kikiikubotyi ꞉Yēēsu wōlēē kimii ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nto yityo, chokunyōōrchi ꞉Yēēsu chiichooto biiwuutaab *Kōōtaab Yēyiin. Kimwoochi kule, “Kēēsob oob? 'Keekas, ‑mataweeyey ng'ōōki kuuyu imuuchē kuchōōnchiing' ꞉mnyaat.” ");
INSERT INTO spyNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kiwokumwoochi ꞉chiichoo kāāntōōyichoo bo Yuutayeek kule Yēēsu nyi kiisoobē inee. ");
INSERT INTO spyNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yooto, kutoow kāāntōōyichoo bo Yuutayeek kuwus Yēēsu kuuyu kiisoobiis ām bēsyēētaab *Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kumwoochi ꞉Yēēsu kāāntōōyichoo kule, “Tākuyēyiisyē ꞉Baaba anii, kunyoo āyēyiisyē ꞉nkanii.” ");
INSERT INTO spyNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kiyey ꞉ng'aleechaata kusyeem ꞉kāāntōōyichoo kubakach Yēēsu. Kimāmāchē baateey kubakach kuuyu kiisoobiis ām bēsyēētaab Sabaato, nteenee kuuyu kimwooy kule kwaan ꞉Yēyiin, ng'ālyoo nyēē ibooru kule kii-āyēēchēē keey ꞉inee Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kunyi, kimwoochi ꞉Yēēsu bichoo kule, “!Kāāmwoowook, māyēyēē keey ꞉Leekweet ng'al nkit, nteenee kāsēē Kwaan. Kunyoo, kiyēē yēyē ꞉Kwaan, kuyēyē ꞉nkinee Leekweet kiyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chāmē ꞉Kwaan Lakwanyii ānkōōboorchinē kiy ake tukul nyēē yēyē ꞉inee. Mākōōboorchi mbo tukuuk chēē biirē chēbo ra ankumoolat ꞉akweek tukul ng'aleechaata. ");
INSERT INTO spyNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kuu yoo ing'ēētē ꞉Kwaan chii nyoo kaakume ānkōōkoochi soboonto, kōōkoochinē ꞉nkinee Lakwanyii biiko soboonto choo kaakucham kōōkoochi. ");
INSERT INTO spyNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","‑Mēētiilchinē ꞉Kwaan chii ng'al. Nteenee kiikōōkoochi Lakwanyii kāāmuukēywēēk tukul kōōtiilchi biiko ng'al, ");
INSERT INTO spyNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","sukung'eet kukoonyit ꞉biiko tukul Leekweet kuu wōloo koonyititooy Kwaan. Nto chii nyoo mākoonyitē Leekweet kumākoonyitē nkinee Kwaan nyoo kiiyooku. ");
INSERT INTO spyNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","!Kāāmwoowook, chii nyoo kāsē ng'aleekyuu ānkōōkoosēē keey Baaba nyoo kiiyookwoo, kunyōōru ꞉chiichoo *soboontaab kibchuulyo. Kiikusiirtēē meet ānkunyōōr soboonto nyēē ‑/mēēkiitiilchinē ng'al. ");
INSERT INTO spyNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","!Kāāmwoowook, mii kuyitu ꞉bēsyēēt, ankookuyit ꞉bēsyoonooto yēē makukas ꞉biiko choo kiikubootyo kiyēē mwooyē ꞉Lakwataab Yēyiin. Nyōōru soboonto ꞉biiko choo kēēyēnchi ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kuu yoo chōōnēē ꞉soboonto wōlēē mii ꞉Kwaan, kiikuyey ꞉Kwaan kuchōōnēē ꞉soboonto wōlēē mii ꞉Leekweet. ");
INSERT INTO spyNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kiikōōkoochi ꞉Kwaan kāāmuukēywēēk kōōtiilchi chii ng'al, kuuyu *Wēritaab Chii ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","‑Moolat ng'aleechu. Makuyit ꞉bēsyēēt nyēē makukas ꞉biiko tukul choo kiikubēk kuutiinyuu, ");
INSERT INTO spyNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nto yooto makukwaanee mbēērōōsyēkwaa. Choo kiikuyey ng'aleek chēē kāroomēch mākunyōōr soboonto nyēē lēēl. Nteenee mākubootyo ꞉choo kiikuyey ng'aleek chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","‑Māāyēyēē keey kiy, nteenee ātiilē baateey kiyēē mwoowoo ꞉Baaba ānkubo man, kuuyu ‑māāyēyē kiyēē āmāchē, nteenee āyēyē kiyēē māchē ꞉nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nto kaang'alaalee keey, nto kaayey kiy nyēē māchāmē ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nteenee mii ꞉ake nyēē ng'āloolēēnoo anii ānkāānkētē kule kiyēē mwoowu kurubta keey anii kubo man. ");
INSERT INTO spyNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","!Kyōōyooktē ꞉akweek biiko kuba wōlēē mii ꞉Yoowaana ānkiikumwoowook ng'aleek chēbo man kurubta keey āk anii. ");
INSERT INTO spyNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","‑Māāmoong'tēē keey kiyēē mwooyē ꞉biiko kurubta keey āk anii, nteenee āmwooyē kuu nyooto /sikiiraraachaak. ");
INSERT INTO spyNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ki nōmōryoo ꞉Yoowaana nyēē kiikoochinē biiko lēbkēēyyēēt ānkyōōng'ērēkyi ꞉akweek lēbkēēyyoonooto kibo bēsyōōs chēē ng'ēri. ");
INSERT INTO spyNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nteenee mii ꞉tukuuk chēē nyikiisēch kusiir ng'aleek choo kimwoowu ꞉Yoowaana. Chooto ku tukuukaab kwōng'uut choo kiikōōtōōrwoo ꞉Baaba kule ayey. Ibooru ꞉chooto kule Baaba ꞉nyēē kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kiikumwooy ꞉nkinee Baaba wōlēē āwuuyē ꞉anii. Manookas kuutiinyii amanookas eernyii, ");
INSERT INTO spyNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","āmēēbērē kyoonam ng'ālyoontēēnyii kuuyu ‑mōōyēnchinē nyi kiiyooku ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kyoocham ōrōōtootē siruutēk miisin ōbērē tōōs yoo kooyey kuu nyooto +mōōnyōōru *soboontaab kibchuulyo. Ntēē mwoowu ꞉siruutēchuutēchu wōlēē āwuuyē ꞉anii, ");
INSERT INTO spyNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ānkoo kuwuu nyooto, ‑mōōchāmē okwaa wōlēē āmiitē sōōnyōōru soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‑Māāmoong'tēē keey kule kusilo ꞉biiko, ");
INSERT INTO spyNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","nteenee ānkētook wōlēē ōwuuyē. Ānkētē kule ‑mōōboontē chamateetaab Yēyiin ām moonikwook. ");
INSERT INTO spyNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kyāāchōō wōlēē ōmiitē ām kaayneetaab Baaba, nteenee otay otaachaa. Nto yoo kāchō ꞉chiito ake ām kaayneenyii nkit, ōchāmē ꞉akweek nyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ōmuuchē raat ōyēnwoo kule nee yoo bērē ꞉chii ām akweek nto /kēēsil kusiir yēē kātōōchēēng'ē kusilook ꞉Yēyiin? ");
INSERT INTO spyNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","‑Moosoot naas kule +maamwaaytaak ꞉anii ām wōlēē mii ꞉Baaba. Nteenee chiito nyēē mwooytook ku *Muusa nyoo ōyēēlchinē ām kāāsōōtēywēēkwook. ");
INSERT INTO spyNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nto kyōōyēnchi Muusa, nto kōōyēnwoo kuuyu kisir ꞉Muusa ng'aleek kurubta keey āk anii. ");
INSERT INTO spyNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nteenee yoo ‑mōōyēnchinē kiyēē kisirē ꞉Muusa ii, ōyēnchi kule nee kiyēē āmwooyē ꞉anii?” ");
INSERT INTO spyNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nto mii bēsyēēt ake, kwoochi ꞉Yēēsu komosta nyiin ake bo Tōōliilēētaab Kalilaaya. /Kēēkuurē tōōliiloonoo kaayneet ake kule Tibeerya. ");
INSERT INTO spyNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yooto koosaab ꞉biiko chēē chaang' sakaramteet kurub inee kuuyu kikiikukas ng'aleek chēbo kwōng'uut chēē kiyēchi ꞉inee biiko choo kimnyoontōōs. ");
INSERT INTO spyNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yu kayit biitoonooto, kootooch āk rubiikyii ākoy lekem ānkuwokōōbuurto ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kikiikuriik yooto ꞉bēsyōōsyēk chēē āmēē ꞉Yuutayeek *Saakweetaab Keeytaayeet. ");
INSERT INTO spyNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yu kakas ꞉Yēēsu kukwoonchinē ꞉biiko chēē chaang', kuteebee Filibō kule, “Kēēnyōōrchinē ānō āmiik chēē kēēbāyēē bichu tukul?” ");
INSERT INTO spyNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kitēēbēē ꞉Yēēsu Filibō ng'aleechaa buch kutyēmē. Kiinkētē ꞉inee kiyēē kimakuyey. ");
INSERT INTO spyNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kuwālchi ꞉Filibō Yēēsu kule, “Ānkoo nto /kakyaalta kiy ake tukul nyēē /kēēboonto, ‑/mākēēnyōōru beesaan chēē yēmē kyoolchinēē bichu āmnyoo kisich nyēē kaam.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kumwooy ꞉Antereeya nyoo ki rubiintēētaab Yēēsu ānkituubcho āk Simōōni Bētērō kule, ");
INSERT INTO spyNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mii yu ꞉wēēro nyēē boonto mukaatiin muut āk *burburiinēk āyēēng' chēē minkēēch, ara yēmē ꞉chooto keebayee bichu tēē chu tukul?” ");
INSERT INTO spyNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kumwoochi ꞉Yēēsu rubiikyii kuyey biiko kōōbuur ng'wēny ām yēbo keeweet. Kimāchē kuyitē ꞉bichu murēnik kisyēērōōk muut. ");
INSERT INTO spyNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kunam ꞉Yēēsu mukaatiinechaa ānkubirchi Yēyiin kōōnkōy, nto yityo, /kēēbchēchinoot bichoo. Kiyey nkicheek burburiinēchooto kuu nyooto. Kiyem ꞉biiko tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nto mii yoo, kumwoochi ꞉Yēēsu rubiikyii kule, “Ōruruuch choo kāng'ēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kōōruruuch ꞉rubiik koonyiit kērēboonik taman āk āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yu kabokukas ꞉biiko ng'ālyoontooni bo kwōng'uut kiyey ꞉Yēēsu, kumwooy kule, “Kubooyiit man, *wōōrkooyoontēētaab Yēyiin ꞉chiichi nyoo /kikēēmwooyē kule mākuchō kōōrēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kiinkētē ꞉Yēēsu kule kimāchē ꞉bichoo bokunam inee kukērchi koong' kuyēk bāytooyiintēēt. Yooto koosikta kuwo lekem. ");
INSERT INTO spyNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yu kāākwiimēn, kurēkto ꞉rubiikaab Yēēsu ākoy tōōliil. ");
INSERT INTO spyNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kulaany mwēēnkēēt ānkutākyi keey *kiriinkēētaab Kaabernaam. Kināmchi ꞉mēēnānēēt bichoo wōlooto kumāboonto keey Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kichō ꞉wusōōnēēt ankusyool bēēko. ");
INSERT INTO spyNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yu kikiikuba ꞉rubiichoo ām lōōyinto nyēē kiyitē kiilomiitaanik muut nto ku lo, kukas Yēēsu kumii kuwēēsyētoonunēē bēēko barak kutākyinē keey mwēēnkoonooto. Kimuuyo ꞉rubiichoo miisin. ");
INSERT INTO spyNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yooto, kumwoochi ꞉Yēēsu kule, “‑Mōōmuuyē, nto yu anii ꞉nyoo!” ");
INSERT INTO spyNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kutaach ꞉rubiik Yēēsu kuchō mwēēng'. Yooto, kuchaakta ꞉mwēēnkēēt ākoy sakaramteet wōlēē /kikēēmākyinē wokōōyyoonyēē. ");
INSERT INTO spyNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yu kāwokuyyeech ꞉kōōrēēt, kōōnkēt ꞉biiko choo king'ētunēē komosta nyiin ake bo tōōliiloonoo kule ki mwēēnkēēt akeenke baateey nyēē kimii yooto. Kiinkētē ꞉bichoo kule kimanaabeeta keey ꞉rubiik Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yooto, kukwaanee ꞉mwēēnkōōsyēk alake *kiriinkēētaab Tibeerya ānkubokōōyyoonyēē yēē kilēēkitēē ꞉yoo kyoomiisyēē ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bērē kukas ꞉biiko kule kāmēētākumii ꞉Yēēsu āk rubiikyii, kulaany mwēēnkōōsyēchoo kuba *kiriinkēētaab Kaabernaam bokucheeng'aat Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yu kābokunyōōrchi Yēēsu wōlooto, kuteebee kule, “Kāānēētiintēēt, 'kēēyitu wōli kutyaa?” ");
INSERT INTO spyNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kuwālchi ꞉Yēēsu kule, “!Kāāmwoowook, ōchēēng'ootoo kuuyu kwōōbiyoong'iisyē āmēēbērē kuuyu kwookas kāāmuukēywēēkaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","‑Mōōbēng'tēē chēēng'sēētaab āmit chēē bēku, nteenee ōnēmchi keey ōchēēng'ē āmnyoontēētaab kibchuulyo. Āmnyoontoonoo ku nyoo kōōnook *꞉Wēritaab Chii, kuuyu inee ꞉nyēē kiikōōkoochi ꞉Baaba Yēyiin kāāmuukēywēēk kuyey kuu nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kuteebee ꞉biiko Yēēsu kule, “Ara, kēēyēyē kule nee sikiinēmchi keey yiisyēētaab Yēyiin?” ");
INSERT INTO spyNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kuwālchi ꞉Yēēsu kule, “/Kiinēmchi keey yiisyēētaab Yēyiin /kukiikaasee keey chiito nyoo kiiyooku ꞉inee.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kuteebee ꞉bichooto Yēēsu kule, “Kiy nee nyēbo kwōng'uut nyēē +meeyey sikiikaaseeniing' keey? ");
INSERT INTO spyNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kyaam ꞉biikyoo choo kibo kēny maana ām kōōr nyēē suurkwēēn, kuu yoo mwooyē ꞉siruutēkaab Yēyiin kule, ‘Kiikoochi kwaam āmnyoontēēt nyēē chōōnēē barak.’” ");
INSERT INTO spyNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kumwoochi ꞉Yēēsu nanyuun bichoo kule, “!Kāāmwoowook, ‑moosoot sōō baateey kule kikōōnook *꞉Muusa āmnyoontoonoo kichōōnēē barak, nteenee ōsōōtē kule kōōnook ꞉Baaba āmnyoontēētaab man kuchōōnēē kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Āmnyoontēētaab Yēyiin ku nyoo chōōnēē kibkōōnkōy ānkuyibchinē biich soboonto.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yooto, kumwoochi ꞉bichoo Yēēsu kule, “Ikōōnēēch kwaak āmnyoontoonooto.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kumwooy ꞉Yēēsu kule, “Anii ꞉āmnyoontoonooto bo soboon. Moomē ꞉kēmēy chiito nyoo kāchō wōlēē āmiitē. Nto nyoo keekaaseenaa keey kumoomē ꞉melel. ");
INSERT INTO spyNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kuu yoo kātāāmwoowook, kookasaa ‑āmōōkoosēēnoo keey. ");
INSERT INTO spyNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Chii ake tukul nyoo kākōōno ꞉Baaba, kuyēku nyeenyuu nyēē mākoy akwet bēsyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kyāāchōōnēē kibkōōnkōy sichaayey kiyēē māchē ꞉Baaba nyoo kiiyookwoo mēēbērē kyāāchōōnii chaayey kiyēē āmāchē. ");
INSERT INTO spyNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mākwoo ꞉Baaba kule ‑māāboot chii mbo akeenke ām choo kiikukōōno, nteenee +maang'eet ake tukul bēsyēētaab tabanta. ");
INSERT INTO spyNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Man, mākyinē ꞉Baaba *soboontaab kibchuulyo biiko tukul choo ikoosēēnoo keey.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yooto kutoow ꞉kāāntōōyikaab Yuutayeek koong'unyng'uuny kuuyu kimwooy ꞉Yēēsu kule, inee ku āmnyoontēēt nyēē chōōnēē kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kimwooy ꞉bichoo kule, “So, mā wēritaab Yōōsēēf ꞉chiichi? Ntēē kiinkēt kwaan āk kaamet. Ām nee sukumwooy raat kule chōōnēē ꞉inee kibkōōnkōy?” ");
INSERT INTO spyNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kumwoochi ꞉Yēēsu bichoo kule, “‑Moong'unyng'uuny. ");
INSERT INTO spyNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Māmii ꞉chii nyēē imuuchē kuchō wōlēē āmiitē yoo kāmāyis ꞉Baaba nyoo kiiyookwoo. Yoo kāākuchō, +maang'eetee meet bēsyoonoo bo tabanta. ");
INSERT INTO spyNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","/Kikeesir ām siruutēkaab *wōōrkooyikaab Yēyiin kule, ‘Makooneet ꞉Yēyiin biiko tukul.’ Chii nyoo kaakukas kāānēētiisyoonoo ānkusēw, kuchōōnii wōlēē āmiitē. ");
INSERT INTO spyNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mēēbērē kaamwaay yooto kule kiikukas ꞉chii Baaba nteenee anii nkit nyoo āchōōnēē wōlēē mii ꞉inee nyēē kyaakas. ");
INSERT INTO spyNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","!Kāāmwoowook, chii ake tukul nyoo ikoosēēnoo keey kuboonto ꞉nyoo kēny *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Anii ꞉āmnyoontēētaab soboonto. ");
INSERT INTO spyNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kyaam ꞉biikyoo choo kibo kēny maana ām kōōr nyēē suurkwēēn nteenee kiikubēk ꞉bichoo tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nteenee mābotē ꞉chii nyoo kaam āmnyoontooni chōōnēē kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Anii ꞉āmnyoontoonooto chōōnēē kibkōōnkōy. Yoo kaam ꞉chii mākunyōōr soboontaab kibchuulyo. +Māākōōnu bōōrnyuu kuyēk āmnyoontēēt nyēē sukōōsoob kōōrēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kiyey ꞉ng'aleechu kukōrōmiitu ꞉kāāntōōyichoo bo Yuutayeek miisin. Kimwooy kule, “So, imuuchē kule nee ꞉chiichi kukōōnēēch bōōrnyii kyaam?” ");
INSERT INTO spyNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kumwoochi ꞉Yēēsu kule, “!Kāāmwoowook, yoo kamoo-am bōōrtaab *Wēritaab Chii ankooyyee korotiikyii, mākoy ōnyōōru soboon. ");
INSERT INTO spyNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Chii nyoo kaam bōōrnyuu ankuyye korotiikyuu, kunyōōru ꞉chiichoo *soboontaab kibchuulyo. +Maang'eetee chiichoo meet ām bēsyēētaab tabanta. ");
INSERT INTO spyNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Āmnyoo nyēbo man ꞉bōōrnyuu ānkubo koomānuut ꞉korotiikyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chii nyoo kaam bōōrnyuu ankuyye korotiikyuu, mākunoomnyo āk anii ānkāānoomnyē āk inee. ");
INSERT INTO spyNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kuu yoo āminyēē kāāmuukēywēēkaab Baaba nyoo kiiyookwoo, mākuminyēē ꞉nkinee chiito nyoo kaam bōōrnyuu kāāmuukēywēēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Anii ꞉āmnyoontoonooto kichōōnēē kibkōōnkōy. Makerkeey ꞉āmnyoontoonoo āk nyoo kyoomē ꞉biikyoo choo kibo kēny, ānkoo kyaam, kibēk. Chiito nyoo kaam āmnyoontooni kunyōōru soboontaab kibchuulyo.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kimwooyē ꞉Yēēsu ng'aleechaa kumii kōōnēētiisyē ām *kōōtaab saayeet ām Kaabernaam. ");
INSERT INTO spyNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yooto kakas ꞉rubiikaab Yēēsu ng'aleechu, kumwooy ꞉wōlēē wōō kule, “Māku nkoolat ꞉ng'aleechu! Ng'oo ꞉nyēē sukoomuuch!” ");
INSERT INTO spyNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kiinkēt ꞉Yēēsu kiyēē kimii kōōyiimē rubiik. Yooto, kumwoochi kule, “So, kāyēk kāānākuut ꞉ng'aleekyuu? ");
INSERT INTO spyNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","/Keemwa baa, kule nto kookas *Wēritaab Chii kōōyēēyē kibkōōnkōy, nto kāwuuyiitu nee? ");
INSERT INTO spyNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kōōnu ꞉Tāmirmiryēētaab Yēyiin soboonto nyēē mākōōnu ꞉kāāmuukēywēēkaab chii. Kōōnu ꞉ng'aleek choo kāāmwoowook soboonto kuuyu kwoonēē wōlēē mii ꞉Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ānkoo kuwuu nyooto, mii ꞉alake ām akweek chēē ‑mēēkoosēēnoo keey.” Kiinkēt ꞉Yēēsu kung'eetee kēny kule ki mbo ng'oo ꞉chēē kimēēkoosēē keey inee ānku ng'oo ꞉nyēē kimakuchaamta inee. ");
INSERT INTO spyNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kitas taay ꞉Yēēsu kumwooy kule, “Ki ng'ālyoontoonooto ꞉nyoo kyāāmwooytēē kule, māmii ꞉chii nyēē chōōnii wōlēē āmiitē yoo kāmāyis ꞉Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kiichuchuuyee keey Yēēsu ꞉biiko chēē chaang' kung'eetee yooto. ");
INSERT INTO spyNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yooto kuteebee ꞉Yēēsu rubiichoo ki taman āk āyēēng' kule, “Ōmāchē ꞉nkakweek obakaaktaa?” ");
INSERT INTO spyNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kuwālchi ꞉Simōōni Bētērō kule, “Keebe ānō ōō, Mokoryoontēēt? Ntēē iboontē ꞉inyiing' lōkōōy chēbo soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kiikoosēēniing' keey ānkēēchāmē kule inyiing' *Kāārārookiintēēt nyēē chōōnēē wōlēē mii ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yooto kumwoochi ꞉Yēēsu kule, “Akweek oob rubiik taman āk āyēēng' chēē kyāākwēyook anii? Nteenee mii ꞉nyēē kibrōkōsyoo ām akweek.” ");
INSERT INTO spyNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kumwooyē ꞉Yēēsu kuu nyooto, king'āloolēē Yuuta Iskaryoot nyēē kimii wokuchoomtooy inee. ");
INSERT INTO spyNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yu kāākuyityo, kōōnēētiisyootēē ꞉Yēēsu Kalilaaya. Kimāmāchē kuwēēsyētootēē Yuuteeya kuuyu kimāchē ꞉kāāntōōyikaab Yuutayeek kubakach. ");
INSERT INTO spyNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yooto, kikiikuriik ꞉Yuutayeek kwaam *Saakweetaab Kēryōōsyēk. ");
INSERT INTO spyNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kumwoochi mbo ꞉ng'eetaabkaamet Yēēsu kule, “Ing'eetee yu ānkiiwē Yuuteeya sukukas rubiikuuk chēbo wōlooto tukuuchu bo kwōng'uut chu iyēyē. ");
INSERT INTO spyNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Māchāktōōs ibooru keey nyēē karaam siitooku. Kunyoo, kany kutookunēē kōōrēēt ꞉ng'aleechu bo kwōng'uut.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kimēēkoosēē keey mbo ꞉ng'eetaabkaamet Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yooto kumwoochi ꞉Yēēsu icheek kule, “Manaayit ꞉bārooyinnyuu nyēē yemaat nteenee oyeyaate ꞉akweek kiyēē ōmāchē. ");
INSERT INTO spyNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mā akweek chēē wēchook ꞉biikaab kōōrooni, nteenee wēchoo anii kuuyu āburyoong'tooy icheek kubo rōkōs nyēē yēyē. ");
INSERT INTO spyNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Obe ꞉akweek saakwaanaa kuuyu manaayit ꞉bārooyinnyuu.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yooto kung'ētunēē ꞉Yēēsu Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nto yu kaakuba mbo ꞉ng'eetaabkaamet, kuwaayta keey Yēēsu ākoy Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kimii ꞉kāāntōōyikaab Yuutayeek kuchēēng'ēē Yēēsu wōlooto. Kitēēbootē kule, “Mii ānō ꞉chiichoo ōō?” ");
INSERT INTO spyNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Kichoomootē ꞉biiko wōlēē wōō kung'āloolēē Yēēsu kuuyu kiiywēyē kāāntōōyikaab Yuutayeek. Kimwooyē ꞉bichoo alake kule, “Karaam ꞉chiichoo.” Kumwooyē ꞉alake kule, “Buryo, ibērbēērootē biich.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","/Kikyaam saakwaanaa nto miitē kwēēn āk kwēēn, kuwo ꞉Yēēsu *Kōōtaab Yēyiin ānkutoow kōōnēētiis. ");
INSERT INTO spyNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","King'woonchi kāāntōōyikaab Yuutayeek ꞉wōlēē kiinēētitooy ꞉Yēēsu kut kumwooy kule, “Kēēnkētēē nee ꞉nkinee nyi siruutēkaab Yēyiin āmēēbērē kiikusumānchi?” ");
INSERT INTO spyNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kumwoochi ꞉Yēēsu bichoo kule, “Ng'aleek chēē ānēētook mēēbērē cheechuu, nteenee kwoonēē wōlēē mii ꞉Yēyiin nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chii nyoo kakwey kuyey kiyēē māchē ꞉Yēyiin, mākōōnkēt yoo kwoonēē ꞉ng'aleekyuu wōlēē mii ꞉Yēyiin, nto cheechuu nkit. ");
INSERT INTO spyNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Chiito nyoo ng'āloolē ām kāāmuukēywēēkyii, kumāchē ꞉nyoo kule /kēēkoonyit. Nteenee āmāchē anii kunyōōr koonyit ꞉nyoo kiiyookwoo. Achurtaat ānkāāyyoong'unēē manta. ");
INSERT INTO spyNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kikōōnook *꞉Muusa kiruutēk āmāmii ꞉chii mbo akeenke ām akweek nyēē riibē kiruutēchoo. So, ōmāchē ōbākākyoo nee?” ");
INSERT INTO spyNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kumwoochi ꞉biiko kule, “Kiikubunuung' ꞉mēt ēē? So, ng'oo ꞉nyēē māchē kubakachiing'?” ");
INSERT INTO spyNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Koomiiny ꞉Yēēsu mēt ankutas taay kule, “Kyaayey kiy akeenke baateey nyēbo kwōng'uut ām Sabaato. King'woonchook akweek tukul ꞉kiyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mwooyē ꞉siruutēkaab Muusa kule ōmurootānē wēēriik ām bēsyēētaab sisiit. (Kubooyiit man mēēbērē Muusa nyēē kimwooyē, nteenee mbo kuukoong' chuut kibo taay.) Kōōnook ꞉yooto ōmurootānē wēēriit ām bēsyēētaab Sabaato yoo /kikēēsichē yēē Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kunyoo, yoo ākoo /kiimurootānē wēēro bēsyēētaab Sabaato ōtiltooy kiy kisich buch, /simākyiiri kiruutyoonoo bo Muusa ii, kubo nee ōnyēērchoo anii yoo kāāsoob chiito kumukuul ām bēsyēētaab Sabaato? ");
INSERT INTO spyNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","‑Mōōtuchinē ng'al buch kukōōkāsunēē saang', nteenee māchāktōōs ōlyēbē ōyyoong'unēē manta.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kimwooyē ꞉biikaab Yēērusālēēm alake kule, “Mā chiichi nyoo /kēēmāchē /keebakach? ");
INSERT INTO spyNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nto yu inee ꞉nyi mii kung'āloolēē taayeetaab biiko āmēēbērē mwoochinē ꞉kāāntōōyikyoo kiy.” Kulē ꞉alake “Ara kāākōōnkēt kule *Kāārārookiintēēt ꞉chiichi?” ");
INSERT INTO spyNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kumwooyē ꞉chuut alake kule, “Ntēē kiinkētē yēē chōōnēē ꞉chiichi. Nteenee māmii ꞉chii nyēē inkētē bēsyēēt nyoo chōōnēē ꞉Kāārārookiintēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yooto kumwooy ꞉Yēēsu kukas ꞉biiko tukul kule, “Man, kōōlē ōnkētoo ānkōōnkētē subak wōlēē āchōōnēē? Mēēbērē kyāāchōōnēē keey. Bo man ꞉nyoo kiiyookwoo, āmōōnkētē ꞉akweek inee. ");
INSERT INTO spyNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nteenee anii ꞉nyēē ānkētē, kuuyu kyāāchōōnēē wōlooto ānku inee ꞉nyēē kiiyookwoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yu kāmwooy ꞉Yēēsu kuu nyooto, kumach ꞉kāāntōōyikaab Yuutayeek kule kunam nteenee māmii ꞉chii nyēē kitiiny kuuyu kitoombo kuyityiin ꞉wōlēē kiikuchōbto ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ānkoo kiwuu nyooto, kiikaasee keey ꞉biiko chēē chaang' inee. Kimwooy ꞉bichooto kule, “Ara, yoo kāchō ꞉Kāārārookiintēēt, makuyey ng'aleek chēbo kwōng'uut kubiir chēē yēyē ꞉chiichi?” ");
INSERT INTO spyNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yu kukas *꞉Farisaayeek ākoo mbo kibkōrōs chēē wōōyēch kuchoomootē ꞉biiko kung'āloolēē Yēēsu nyēē karaam, kōōyookto riibiikaab Kōōtaab Yēyiin kule bokunam Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kutas taay ꞉Yēēsu kumwooy kule, “+Mākēēboontē keey akweek ām bēsyōōsyēk chēē ng'ēri baateey, nto yoo kāākuyityo, ayeey wōloo mii ꞉nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yooto +moocheeng'aa, nteenee ‑mōōnyōōrwoo, āmōōmuuchē okwaa wōloo !kāāwē.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kuteebee keey ꞉kāāntōōyikaab Yuutayeek nkit kule, “So, māchē ꞉chiichi kuwo ānō wōlēē ‑mābokēēnyōōrchinē ꞉acheek? Ara, mākuwo kōōrōōsyēchoo kiisērēētyi keey ꞉biikyoo wokooneet bichooto? ");
INSERT INTO spyNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ibooru nee ꞉ng'aleechaa kāmwooyē kule, ‘+Moocheeng'aa nteenee ‑mōōnyōōrwoo āmōōmuuchē okwaa wōloo !kāāwē?’ ” ");
INSERT INTO spyNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ām bēsyēētaab lētuut nyēbo saakweet, kuchō ꞉Yēēsu ānkukuurchi barak kule, “Chii nyoo āmē ꞉melelta, kuchō wōlēē āmiitē. ");
INSERT INTO spyNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kuu yoo mwooyē ꞉siruutēkaab Yēyiin kule, chii nyoo keekaaseenaa keey, mākurōōtunēē chiichoo ꞉bēēkaab soboonto.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kumwooyē ꞉Yēēsu kuu nyooto kiibooru Tāmirmiryēētaab Yēyiin nyēē nyōōru ꞉chii ake tukul nyoo keekaasee keey inee. /Kimānāākiiyook Tāmirmiryēētaab Yēyiin kuuyu /kimānāākiitōrōōr Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yu kakas ꞉biiko ng'aleechaa kimwooyē ꞉Yēēsu, kumwooy ꞉bichooto alake kule, “Man wōōrkooyoontoonoo bo Yēyiin ꞉chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nto alak kumwooy ꞉choo kule, “Kāārārookiintēēt ꞉chiichi.” Kulē ꞉alake, “Buryo! Mēēmuuchāksē kuchōōnēē ꞉Kāārārookiintēēt Kalilaaya. ");
INSERT INTO spyNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mwooyē ꞉siruutēkaab Yēyiin kule mākuchōōnēē ꞉Kāārārookiintēēt kōōtaab *Tāwuti ām *kiriinkēētaab Bēētēlēyēēm wōloo kiminyē ꞉Tāwuti.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kuchuunchuun ꞉biiko kurubta keey āk Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kimāchē ꞉biiko alake kule kunam Yēēsu, nteenee māmii ꞉chii mbo nyēē kisyeem kunam. ");
INSERT INTO spyNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yu kāākuyityo nanyuun, kooyeey ꞉riibiichoo kibo Kōōtaab Yēyiin wōlēē kimii ꞉mbo kibkōrōs chēē wōōyēch āk *Farisaayeek. Yooto kuteebee ꞉choo riibiichoo kule, “So, ntēē kookwaa buch, kāmōōnāmē?” ");
INSERT INTO spyNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kuwālchi ꞉riibiichoo kule, “Māmii ꞉chii nyēē kiikung'alaal bēsyēēt ake kuu ꞉chiichoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kuteebee ꞉Farisaayeek riibiichooto kule, “So, ōmāchē omwaay kule /kaakiiberbeeraak nkakweek? ");
INSERT INTO spyNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ara ōnkēt mbo kāāntōōyiin ake tukul nyēē kaakookaasee keey chiichoo, nto kumii mbo *꞉Fārisooyiin nyēē kaakucham ng'aleechaata mwooyē ꞉chiichooto? ");
INSERT INTO spyNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Chubootiin ꞉bichu ‑mēēnkēt kiruutēkaab ꞉Muusa.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ām kāāntōōyichoo, kimii ꞉Nikōtēēmō nyoo kikiiwokukas Yēēsu. Kumwoochi ꞉nyoo kāāntōōyichoo kule, ");
INSERT INTO spyNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kurubta keey āk kiruutēkyoo, māmii ꞉chii nyēē /kiiruustooy yoo /manaakeekas kiyēē mwooyē ꞉chiichooto nto /kiinkēt kiyēē kaakuyey.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","/Kēēmwoochi kule, “So, ichōōnēē ꞉nkinyiing' Kalilaaya? Weesuman siruutēkaab Yēyiin, +meekas ām yooto kule māmii *꞉wōōrkooyoontō nyēē imuuchē kuchōōnēē Kalilaaya.” ");
INSERT INTO spyNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nto mii yoo, kooyeey ꞉chii ake tukul kaa, ");
INSERT INTO spyNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","nteenee kuwo ꞉Yēēsu ākoy Lekemeetaab *Musēytuuniinēk. ");
INSERT INTO spyNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yu kāwokuyyeech, kumusta ꞉Yēēsu kooyeey biiwuutaab *Kōōtaab Yēyiin. Kukwa ꞉biiko ānkōōruruukyi keey inee. Kōōbuur ꞉Yēēsu ng'wēny ankooneet bichoo. ");
INSERT INTO spyNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yooto koomut ꞉kāānēētikaab kiruutēk āk *Farisaayeek koorko nyēē /kikeenyoorta chiito ake ānkōōyyoong'tēē yooto bo taayeetaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kumwoochi ꞉bichoo Yēēsu kule, “Kāānēētiintēēt, /kokeenyoorta koorkooni chiito ake. ");
INSERT INTO spyNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kimwooy *꞉Muusa ām kiruutēkyoo kule, irooko ꞉chii nyēē wuu nyooto /kēēwiirēē rwoontōōk kume. Kunyoo ii, imwooyē nee ꞉inyiing'?” ");
INSERT INTO spyNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kimwooyē ꞉bichoo ng'aleechaa kutēchēē Yēēsu sukōōyyoong'tēē kōōk. Kuyim ꞉Yēēsu ankusir yēbo teng'eek ām moorineenyii. ");
INSERT INTO spyNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kitēēbēē ꞉bichooto Yēēsu ng'aleek kutēē yooto tukul. Kōōtōrōōr keey ꞉Yēēsu ānkumwoochi bichoo kule, “Yoo mii ām akweek ꞉nyēē mānāāchoolwookēn, kutoow ꞉nyooto kuwiiree koorkooni rwoontōōk.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yu kāmwooy ꞉Yēēsu kuu nyooto, kuyim subak ānkusiriis. ");
INSERT INTO spyNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yu kabokukas ꞉bichoo ng'aleechaata kimwooyē ꞉Yēēsu kubeetaatee akeenke akeenke. Kiba kurook ꞉choo ki yōōsēch kut wokung'ēt ꞉Yēēsu nkit āk koorkoonoo kuboonto keey biiko alak. ");
INSERT INTO spyNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yooto kōōtōrōōr keey ꞉Yēēsu ankuteebee koorkoonoo kule, “Kaba ānō ꞉biikēy ōō, cheebyoos? Māmii mbo ꞉akeenke nyēē kāng'ēt kooruustiing'?” ");
INSERT INTO spyNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kuwāl kule, “Māmii mbo ꞉akeenke ōō, Mokoryoontēēt.” Yooto kumwoochi koorkoonoo kule, “‑Māāruustiing' ꞉anii nteenee ‑mātāwēēchoolwookēn subak.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kitas taay ꞉Yēēsu kumwoochi bichoo kule, “Anii lēbkēēyyēētaab kōōrēēt. Chiito nyoo karub ng'aleekyuu kunyōōru lēbkēēyyēētaab soboonto nyēē mākoy kuwēēsyētēē mēēnān.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kumwoochi *꞉Farisaayeek Yēēsu kule, “Nto yu imiitē ing'āloolēē keey ꞉inyiing' nkit, mābo man ꞉ng'aleekuuk.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kuwālchi ꞉Yēēsu bichoo kule, “Ānkoo āng'āloolēē keey ꞉anii nkit, kiyēē āmwooyē kubo man kuuyu ānkētē wōlēē kyāāchōōnēē ākoo wōlēē āwēētii. Nteenee ‑mōōnkētē ꞉akweek. ");
INSERT INTO spyNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ōtiilē ꞉akweek ng'al baateey orub kuu wōloo isōōtitooy ꞉biiko, nteenee ‑māātiilchinē ꞉anii chii ng'al. ");
INSERT INTO spyNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nto yoo kāālē ātiilchi chii ng'al, āyyoong'unēē manta kuuyu mēēbērē anii nkit nteenee āboontē keey Baaba nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","/Kikeesir ām kiruutēkwook kule yoo kaakuroob ꞉biich āyēēnku ng'ālyoo, ku man ꞉kiyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Āng'āloolēē keey ꞉anii, nto ake nyēē rōōboo ku Baaba nyoo kiiyookwoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kuteebee ꞉Farisaayeechaa Yēēsu kule, “Mii ānō ꞉kōōn?” Kuwālchi ꞉Yēēsu kule, “‑Mōōnkētoo anii, āmōōnkētē nkinee Baaba. Nto kyōōnkētoo, nto ōnkētē Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kimwooyē ꞉Yēēsu ng'aleechu tukul yooto kimii kōōnēētē biiko ām yēē kimii ꞉looloonik choo /kikiiruruukyinē beesaanik ām *Kōōtaab Yēyiin. Yooto kimāmii mbo ꞉chii nyēē kinam Yēēsu kuuyu kimānāāyityiin ꞉chōbuutēkaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yooto kumwoochi ꞉Yēēsu kāāntōōyichoo subak kule, “+Māāwēēchi keey anku +moocheeng'aataa, nteenee +moomeeyte ng'ōōkiswookikwook ‑āmōōmuuchē obe wōlēē āwēētii ꞉anii.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kuteebee keey ꞉kāāntōōyichoo kule, “Ibooru nee ꞉chiichi yoo mwooyē kule ‑mākēēbēētii wōlēē mākuwo ꞉inee? Ara, makubar keey ꞉chiichi nkit ēē?” ");
INSERT INTO spyNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nteenee kitas taay ꞉Yēēsu kumwooy kule, “Ōbooyē ꞉akweek ng'wēnyuuni, nteenee āchōōnēē ꞉anii kibkōōnkōy. Nyēēng'woong' ꞉kōōrooni nteenee mā nyeenyuu anii ꞉kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kiyooto nyēē āmwoowook kule +moomeeyte ng'ōōkiswookikwook. Makurataak ꞉ng'ōōkiswookichoo ākoy yoo kookaasee keey kule anii ꞉nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kuteebee ꞉bichoo Yēēsu kule, “Inyiing' ng'oo naas?” Kuwālchi kule, “Nyooto kyāāmwoowunoonwook. ");
INSERT INTO spyNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Chaang' ꞉ng'ala chēē kātāāmwoowook ānkāātiilchook ng'al, nteenee bo man ꞉Baaba nyoo kiiyookwoo. Kiyēē āmwoochinē biiko ku nyēē kyāākāsēē inee.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kimēēnkēt ꞉bichoo kule kimii ꞉Yēēsu kung'āloolēē Kwaan ām kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yooto nanyuun kumwooy ꞉Yēēsu kule, “Bēsyoonoo ōtōrōōrē *Wēritaab Chii, ku yooto yēē +mōōnkēt kule anii ꞉nyooto āmāāyēyēē keey kiy. Yooto nanyuun yēē +mōōnkēt kule kiyēē āmwooyē ku nyēē kiinēētoo ꞉Baaba. ");
INSERT INTO spyNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kēēboontē keey ꞉nyoo kiiyookwoo. Manaabakaaktaa āng'ētu nkit bēsyēēt ake kuuyu āyēyē ākookoy kiyēē ing'ērēēchē inee.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yu kāmwooy ꞉Yēēsu kuu nyooto, kōōyēnchi ꞉biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kumwoochi ꞉Yēēsu chooto kiiyēnchinē inee kule, “Yoo kōōkiilchi kiyēē ānēētē, ōyēku man rubiikyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","+Mōōnkēt yooto nanyuun manta anku +/makiityaaktaak.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kumwoochi ꞉kāāntōōyichoo Yēēsu kule, “So, nto yu kēēbooyē ꞉acheek *Abraam, āmānāākēēyēku motwoor bēsyēēt ake! Kunyi, /kiityaakteech ām nee?” ");
INSERT INTO spyNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kuwālchi ꞉Yēēsu kule, “!Kāāmwoowook, motwooriintēētaab ng'ōōkisto ꞉chii nyoo kiikōōtiiny ꞉ng'ōōkisto. ");
INSERT INTO spyNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Minyē ꞉leekwa kang'waa ākookoy nteenee imōkōnyōōnyoot ꞉motwooriintō. ");
INSERT INTO spyNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nto yoo kālē kootyaaktaak ꞉Leekweet ōtyooktooyāktōōsii kuchurta. ");
INSERT INTO spyNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ānkētē sinee kule ōbooyē ꞉akweek Abraam. Nteenee ōmāchē obara kuuyu kiyoomcho ꞉mētēwookwook nyēē ‑mēēwutē ꞉ng'ālyoontēēnyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Āng'āloolēē ꞉anii kiyēē kimii kaab Baaba, nto akweek ōyēyē kiyēē mwoowook ꞉kōōn.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kukētyi ꞉bichooto Yēēsu kule, “Abraam ku baaba acheek.” Yooto kuwālchi ꞉Yēēsu kule, “Nto ki kōōn ꞉Abraam, nto kyōōyēyē kiyēē kiyey. ");
INSERT INTO spyNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ōmāchē ꞉akweek obara ānkoo kāāmwoowook kiyēē bo man nyēē chōōnēē wōlēē mii ꞉Yēyiin, ng'ālyoo nyēē kimēēmuuchē kuyey ꞉Abraam. ");
INSERT INTO spyNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ōyēyē ꞉akweek yiisyēētaab ꞉kōōn.” Kuwālchi ꞉bichooto Yēēsu kule, “Kēēboontē Baaba akeenke, nyooto ku Yēyiin, ānkēēyēku lōkōkyii chēbo man.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yooto kumwoochi ꞉Yēēsu bichooto kule, “Nto ki kōōn akweek ꞉Yēyiin nto ōchāmoo kuuyu kyāāchōōnēē wōlēē mii ꞉Yēyiin ānkāāmiitē raat yu. Mānāāchōōnēē keey. Nteenee inee ꞉nyēē kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","‑Mōōkāsē kiyēē āmwoowook kuuyu wuu nyēē kyoomaalee tēmēnik yiitiikwook. ");
INSERT INTO spyNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kōōn akweek ꞉Kibrōkōsyoontēēt ānkōōrubē kiyēē māchē ꞉inee. Rumiin ꞉inee kung'eetee kēny āmāmii ꞉bēsyēēt nyēē kiikōōyyoong'unēē wōlēē mii ꞉manta kuuyu mātinyē manta. Yoo ibērbēēriisyē, ku cheechii ꞉choo nkit kuuyu, ng'wiin ꞉inee ānku ꞉mētitaab ng'wiiynaneet tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Āmwoowu ꞉anii manta ng'ālyoo ꞉nyēē yēyē simōōyēnwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ara, mii ām akweek ꞉nyēē imuuchē kōōboor kule āboontē ꞉anii ng'ōōkisto? Nto yoo bo man ꞉ng'aleek chēē āmwooyē ii, kwaamaak ꞉nee simōōyēnwoo? ");
INSERT INTO spyNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Chii nyoo bo ꞉Yēyiin kukāsē ng'aleekyii. Nteenee ‑mōōkāswoo kuuyu ‑mōōbooyē Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yooto kumwoochi ꞉kāāntōōyichoo bo Yuutayeek Yēēsu kule, “Ābērē +mākēēkustooyootiin yoo kakeemwaay kule inyiing' Sāmooryāyiin ānkiiboontē *tāmirmiryēēt nyēē miyaat.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kuwālchi ꞉Yēēsu kule, “‑Māāboontē tāmirmiryēēt nyēē miyaat. Āywēyē Baaba āmōōkoonyitoo anii ꞉akweek. ");
INSERT INTO spyNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","‑Māāchēēnkyinē keey ꞉anii koonyit, nteenee mii ꞉nyēē chēēng'woo anku inee ꞉nyēē itiilē kiy ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Āmwoowook manta kule, mākoy kume ꞉chiito nyoo rubē ng'aleekyuu.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kumwoochi ꞉bichoo Yēēsu kule, “Kāākiinkēt nanyuun man kule iboontē tāmirmiryēēt nyēē miyaat! Kiikume *꞉Abraam ānkiikubēk *꞉wōōrkooyikaab Yēyiin ānkiimwooyē kule, nyoo rubē ng'ālyoontēēng'uung' mēēbērē makume? ");
INSERT INTO spyNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Imwooyē ꞉inyiing' kule iwōō kusiir Abraam? Kiikume ꞉inee ānkiikubēk mbo ꞉nkicheek wōōrkooyikaab Yēyiin. Isōōtē kule inyiing' ku ng'oo ēē?” ");
INSERT INTO spyNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yooto kuwālchi ꞉Yēēsu kule, “Yoo āmiitē ātōrōōrē keey ku buch. Nteenee nyēē itōrōōroo ku ꞉Baaba nyoo ōbērē ꞉akweek Yēyiintēēng'woong'. ");
INSERT INTO spyNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","‑Mōōnkētē ꞉akweek Yēyiin, nteenee anii ꞉nyēē ānkētē. Nto kāālē amwaay kule ‑māānkētē, nto kāāyēku ng'wiin kuu akweek. Nteenee ānkētē inee ānkāāriibē ng'ālyoontēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kikiikumachaan ꞉kōōn Abraam kule nto kas bēsyēēnyuu, kunyoo yu kachokukas, kung'erech.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yooto, kumwoochi ꞉bichoo Yēēsu kule, “Nto yu maneeyit mbo kēnyiisyēk konom ānkiimwooyē kule 'kiikas Abraam!” ");
INSERT INTO spyNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kuwālchi ꞉Yēēsu kule, “!Kāāmwoowook, kyāāmiitē kutoombo /kēēsich Abraam.” ");
INSERT INTO spyNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yooto kukwey ꞉bichooto rwoontōōk kule kuwiiree Yēēsu, nteenee kuchuut ꞉Yēēsu biiko ankung'eetee yooto kibo *Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kimii yēē kiwēēsyētootē ꞉Yēēsu ākoo rubiikyii, yooto kukas chiito ake nyēē /kikēēsich kukoraat. ");
INSERT INTO spyNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kuteebee ꞉rubiikyii Yēēsu kule, “Kāānēētiintēēt, nee ꞉nyēē kiyey chiichiin kukor? Ara ng'ōōkisnyii nto nyēbo sikiikyii?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kuwālchi ꞉Yēēsu kule, “Mā ng'ōōkistaab chiichoo nto nyēbo sikiikyii ꞉nyēē kiyey kukor, nteenee mākutook ꞉kāāmuukēywēēkaab Yēyiin kubo inee. ");
INSERT INTO spyNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Māchāktōōs /kēēyēyē yiisyēētaab Baaba nyoo kiiyookwoo yoo tāku lebkeey nteenee mii wokutuuyiitu ꞉kōōrēēt nyēē ‑mēēmuuchē ꞉chii tākuyēyiis. ");
INSERT INTO spyNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yoo tāāmiitē kōōrēēt, āyēku lēbkēēyyēētaab kōōrēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yu keewaany ꞉Yēēsu kumwooy ng'aleechaa kung'utyi ng'wēny. Koomitmiit mēnēēt ankoonyiinyee koonyekaab chiichooto, ");
INSERT INTO spyNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ānkumwoochi kule, “Wēēwuunēē koonyekuuk kibōōytaab Siloowaam.” (Kerkeey kaaynaani bo ‘Siloowaam’ ākoo yoo /kakeemwa kule /kikiiyookto.) Kuwo ꞉chiichoo ānkōōwuun koonyekyii ānkōōyēēw kukaakukasta. ");
INSERT INTO spyNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yooto, kutoow ꞉laatoosyekaab chiichoo āk choo kikiikukas kusoomsē kumwooy kule, “So, mā ꞉chiichi nee nyoo kwēēbuurē sukusoomsē kityō?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kumwooy ꞉alake kule, “Inee ꞉nyooto” nto alak kule, “Buryo! Mā ꞉inee, nteenee kerkeey inee.” Kumwooy ꞉inee nkit kule, “Lēyyē, ntēē anii ꞉nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yooto nanyuun kuteeb ꞉bichooto kule, “Nee ꞉nyēē kiyeying' ikaste?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kuwālchi ꞉chiichoo kule, “Kiimitmiit ꞉chiichoo /kēēkuurēē Yēēsu mēnēēt ankoonyiinyeenaa koonyek ānkumwoowoo wāāwuunēē kibōōytaab Siloowaam. Kunyoo yu kāwāāwuun akaste bakeenke!” ");
INSERT INTO spyNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kuteebee ꞉bichooto kule, “Miitē ānō raat ꞉chiichooto?” Kuwālchi kule, “‑Māānkētē.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yooto, /keenam chiichoo /kikēēng'oonkyinē koonyek /ānkiimutyi *Farisaayeek. ");
INSERT INTO spyNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","King'oonkyinē ꞉Yēēsu chiichoo koonyek yēē ki bēsyēētaab *Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kiteebee ꞉nkicheek Farisaayeechaa chiichoo wōlēē kiyeyta kut kukasta. Kumwoochi kule, “Kinam ꞉chiito ake mēnēēt ankoonyiinyeenaa koonyek, nto yu kāwāāwuun, akaste.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kumwooy ꞉Farisaayeek alake kule, “Māchōōnēē ꞉chiichi wōlēē mii ꞉Yēyiin kuuyu ‑mēēywēyē kiruutyēētaab Sabaato.” Kumwooy ꞉alake kule, “So, imuuchē kule nee kuyey ꞉chii nyēē choolwookiin tukuuk chēbo kwōng'uut chēē wuu choo?” Kuchuunchuun ꞉Farisaayeechaa ām kāāsōōtēywēēkwaa. ");
INSERT INTO spyNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yooto nanyuun kuwēēkyi keey ꞉Farisaayeechaa chiichoo kikoraat ankuteebee kule, “Imwooyē nee ꞉inyiing' kurubta keey āk chiichooto kāyēyiing' ikaste?” Kuwāl kule, “Wōōrkooyoontēētaab Yēyiin ꞉chiichooto.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kimāchāmchiintōōs ꞉kāāntōōyikaab Yuutayeek kule kikoraat ꞉chiichoo man ankaakukasta. Yooto kukuur sikiikaab chiichoo ");
INSERT INTO spyNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ankuteebee kule, “Nyēēng'woong' ꞉lakwani ōmwooyē kule /kikēēsichē kukoraat? Ntēē kāstooy raat?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kumwooy ꞉sikiik kule, “Kiinkētē kule lakwanyoo ānkiinkētē kule kikēēsichē kukoraat. ");
INSERT INTO spyNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nteenee ‑mākiinkētē kule kayeyakay kule nee sukukasta. ‑Mākiinkētē mbo chiichēē kāng'oonkyi koonyek. Nto yu chii ꞉inee nyēē wōō nyēē imuuchē kuwāl, oteebee baa, ꞉akweek kumwoowook nkit.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kimwooy ꞉sikiikaab wēēroo kuu nyooto kuuyu kinyōkōōrēch kāāntōōyichoo bo Yuutayeek. Kikiikumwooy ꞉kāāntōōyichoo kule chii ake tukul nyoo kang'alaalee kule Kāārārookiintēēt ꞉Yēēsu, +/makeekwetee chiichoo *kōōtaab saayeet. ");
INSERT INTO spyNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kiyooto ꞉nyēē kiyey sikiikaab lakwanaa kumwooy kule, “Nto yu chii ꞉inee nyēē wōō, oteebee baa, ꞉akweek.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yooto kukuur ꞉bichoo subak chiichoo kikoraat ānkumwoochi kule, “Itōrōōr Yēyiin ankiimwaay chēbo man! Kiinkētē ꞉acheek kule choolwookiin ꞉chiichi kāng'oong'uung' koonyek.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kuwālchi ꞉chiichoo bichoo kule, “‑Māānkētē ꞉anii kule choolwookiin ꞉chiichoo nto kumā choolwookiin. Nteenee kiy akeenke kityō nyēē ānkētē. Nyooto ku kule kyaakoraat neennyi, ākāstooy raat!” ");
INSERT INTO spyNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kuteebee ꞉bichoo kule, “King'aang'ta ānō koonyekuuk?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kuwālchi ꞉chiichoo kule, “Nto yu kāāmwoowook āmēēbērē ōkāsē. Ōmāchē okas subak nyēbo nee? Ara, ōmāchē ꞉nkakweek ōyēku rubiikyii?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kōōburyoong'to ꞉bichoo kule, “Yyōōch! Inyiing' ꞉nyēē rubiintēētaab chiichooto nteenee kēēbooyē ꞉acheek *Muusa. ");
INSERT INTO spyNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kiinkētē kule king'āloolchi ꞉Yēyiin Muusa, nto chiichi ku ng'oo?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kulēēnchi ꞉chiichoo, “So, māku nkoolat ōō! Kōōlē ‑mōōnkētē wōlēē kichōōnēē ꞉chiichoo ānkāākung'oong'woo koonyekyuu? ");
INSERT INTO spyNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kiinkētē kule mākāsyinē ꞉Yēyiin chii nyēē yēyē rōkōs, nteenee kāsyinē biiko choo iywēyē inee ānkuyēyē kiyēē mākyinē ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","/Manaakeekas chii bēsyēēt ake nyēē kiikung'aany koonyay chēbo chii nyēē /kikēēsichē kukoraat! ");
INSERT INTO spyNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ākoy kuchōōnēē ꞉chiichoo wōlēē mii ꞉Yēyiin nto buch, nto kāmēēmuuchē kuyey kiy nyēē wuu nyi.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kuwālchi ꞉kāāntōōyichoo chiichoo kule, “'Kēēlē, 'kēēyēku ꞉nkinyiing' nyi /kikēēsiktiing' ng'ōōkiswookik, kāānēētiintēēt ām wōlēē kēēmiitē ꞉acheek?” Kukwetee ꞉bichoo chiichoo *kōōtaab saayeet. ");
INSERT INTO spyNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yooto kukas ꞉Yēēsu kule /kikiikeekwetee chiichoo *kōōtaab saayeet. Kunyōōr ꞉Yēēsu chiichooto ankuteebee kule, “Ikoosēē keey ꞉inyiing' *Wēritaab Chii?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kuteebee ꞉chiichoo Yēēsu kule, “Ng'oo ꞉nyooto ōō, mokoryoontēēt, saakaasee keey?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kumwoochi ꞉Yēēsu kule, “'Keekas ra, nto yu inee ꞉nyi ōmiitē ōng'āloolē tukwaay.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yu kakas ꞉chiichoo ng'ālyoontoonoo, kukutuny ām taayeetaab Yēēsu ānkumwooy kule, “Mokoryoontēēt, kaakaaseeniing' keey.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kumwooy ꞉Yēēsu kule, “Kyāāchōōnii kōōrooni sukubchēyākiis ꞉ng'ala. Makukasta ꞉cheebkoraatiisyek ānkukōryo ꞉biiko choo kāstooy.” ");
INSERT INTO spyNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kimii kēēyyoong'iis *꞉Farisaayeek alake yooto. Yu kakas ng'aleechaa kimwooyē ꞉Yēēsu, kumwooy kule, “Ibooru ām wōlēē 'keemwaayte sōō, kule, kēēkōryootiin ꞉acheek?” ");
INSERT INTO spyNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kuwālchi ꞉Yēēsu bichoo kule, “Nto kōōkōryootiin nto mēēbērē ōchoolwookēnootiin, nteenee kuuyu ōmwooyē kule ōkāstooy, +mōōng'ētu ōchoolwookēnootiin.” ");
INSERT INTO spyNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yooto, kumwoochi ꞉Yēēsu kāāntōōyichoo bo Yuutayeek kule, “Āmwoowook manta kule chii nyoo māwēētēē kurkeet nyoo bēētēē ꞉kēēchiirēk kō ankuwaaytee keey wōlto ake buch, ku chōōriin. ");
INSERT INTO spyNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nteenee nyoo buntēē kurkeet ku ākiintēētaab kēēchiirēchooto ");
INSERT INTO spyNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ānkumākuyootyi ꞉riibiintēēt kurkeet. Makukas ꞉kēēchiirēchoo kuutiinyii yoo kākuur ake tukul ām kaayneenyii. Nto yooto nanyuun mākukwēryoot kēēchiirēchoo kuba saang'. ");
INSERT INTO spyNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Makoonto ꞉inee ankurub ꞉kēēchiirēchoo, kuuyu inkētē kuutiinyii. ");
INSERT INTO spyNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mārubē ꞉kēēchiirēchoo soboyiin nteenee mwēyēē kuuyu ‑mēēnkēt kuutiitaab chiichooto.” ");
INSERT INTO spyNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kimii ꞉Yēēsu kōō-ārōōru ng'ālyoo, nteenee māmii ꞉chii ām bichoo nyēē kiinkēt kiyēē kiibooru ꞉ng'aleechaata. ");
INSERT INTO spyNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yooto kumwooy ꞉Yēēsu subak kule, “!Kāāmwoowook, anii ꞉kurkeetaab kēēchiirēchoo. ");
INSERT INTO spyNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ki chōōr ꞉biiko tukul choo kisimkukwa. Kikuur kēēchiirēchoo, nteenee mānāākāsyi ꞉kēēchiirēchooto. ");
INSERT INTO spyNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anii ꞉kurkeet. Chiito nyoo kābuntēēnoo anii +/makiiraraach. Mākuwēētii yeechey ānkurōōtu. ");
INSERT INTO spyNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yoo chōōnii ꞉sāsiintēēt, kumāchē kuchōōrso, kubākākiis ānkōōmukuusiis. Nteenee kyāāchōō ꞉anii sukung'eet kunyōōr ꞉biiko soboonto nyēbo man. ");
INSERT INTO spyNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Anii ꞉ākiintēēt nyēē karaam. Mēēchinē ꞉ākiintō kēēchiirēkyii taay. ");
INSERT INTO spyNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Nteenee nyoomēēchinē ꞉chiito nyoo /kikeesir kēēchiirēchoo kuuyu ma cheechii. Yoo kāchō ꞉suuyoontēēt kumwēyē. Yooto, makusankatan ꞉suuyoontoonoo kēēchiirēk alak ankoosereet chuut. ");
INSERT INTO spyNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Anii ꞉ākiintēēt nyēē karaam ānkyāānēmu keey āmēēchi kēēchiirēkyuu. Inkētoo ꞉Baaba ānkāānkētē nkinee. Ānkētē kēēchiirēkyuu ānkōōnkētoo ꞉nkicheek. ");
INSERT INTO spyNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Māchāktōōs wāākuur kēēchiirēkyuu alak chēē māmii ākwootiini. Makukas kuutiinyuu ankurubwaa bokuyēk ākwootiit akeenke āk chuut, sukwookooy ꞉ākiintēēt akeenke. ");
INSERT INTO spyNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","18","Māmii ꞉chii nyēē mākōōnēmunēēnoo soboonnyuu, nteenee āchāmtooy nkit ameey. Chāmoo ꞉Baaba kuuyu kyāānēmu keey ameey, nto yityo ānyōōru subak soboonnyuu. Āboontē kāāmuukēywēēk ākooytē soboonnyuu ānkāāboontē kāāmuukēywēēk ākētu. Kiyiitēnyi ꞉nyēē kimwoowoo ꞉Baaba kule māchāktōōs ayey.” ");
INSERT INTO spyNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kiyey ꞉ng'aleechuutēchu kuchuunchuun subak ꞉kāāntōōyikaab Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kimwooy ꞉chēē chaang' kule, “Boonto ꞉chiichi *tāmirmiryēēt nyēē miyaat! Kōōkubun ꞉mēt chiichi! Nyēbo nee ōkāsyinē chiichi ng'aleekyii ēē?” ");
INSERT INTO spyNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nteenee kulē ꞉alake, “O, ‑mēēmuuchē ꞉chii nyēē boonto tāmirmiryo kung'alaal kuu chiichi. Imuuchē man ꞉tāmirmiryēēt nyēē miyaat kuyey kukasta chii nyēē koraat?” ");
INSERT INTO spyNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kiyit ꞉bēsyēēt nyēē kibo Saakweetaab Kāātiliilēētaab *Kōōtaab Yēyiin ām Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ki yiiwoot ꞉kōōrēēt ānkimii ꞉Yēēsu kuwēēsyētēē Kōōtaab Yēyiin yēē /kikēēkuurēē Kēēltaab Sōlōmōōn nyēē tinyē wuurwēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kukwoonchi ꞉kāāntōōyikaab Yuutayeek Yēēsu ankuteebee kule, “Yoo inyiing' *Kāārārookiintēēt, ichuurtoowēēch bakeenke.” ");
INSERT INTO spyNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kumwoochi ꞉Yēēsu kule, “Kyāāmwoowook āmōōyēnchinē. Kiyēē āyēyē ām kāāmuukēywēēkaab Baaba kōōbooru wōlēē āwuuyē. ");
INSERT INTO spyNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nteenee ‑mōōchāmoo ꞉akweek kuuyu ‑mōōyēku kēēchiirēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ānkētē kēēchiirēkyuu ānkukāsē kuutiinyuu. Yoo kāākuur kuruboo. ");
INSERT INTO spyNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","29","Ākoochinē *soboontaab kibchuulyo āmābootōōs. Māmii ꞉chii nyēē mākōōnēmunēēnoo āmāmii ꞉chii nyēē imuuchē kōōnēmunēē Baaba kēēchiirēchu. Wōō ꞉Baaba nyoo kikōōnoo kēēchiirēchoo kusiir chii ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Āyēku ꞉anii akeenke āk Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yooto, kukwey ꞉kāāntōōyichoo subak rwoontōōk kule kuwiiree Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nteenee kumwoochi ꞉Yēēsu bichoo kule, “Kyookas ꞉akweek tukuuk chēē chaang' chēē kāroomēch chēē kyaayey ꞉anii ām kāāmuukēywēēkaab Baaba. Kiito nkōnō ām chooto kyaayey ꞉nyēē kayeyaak omach owiireenaa rwoontōōk?” ");
INSERT INTO spyNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kuwālchi ꞉bichoo kule, “‑Mākēēmāchē keewiiring' ām tukuuchoo kāroomēch choo 'kiiyēyē, nteenee kēēwiiriing' kubo ng'aleek choo ichubē Yēyiin. Iyēku chii buch, nteenee imiitē iyibē keey wuu nyēē iyēku Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yooto kuwālchi ꞉Yēēsu bichoo kule, “Mwooyē ꞉Yēyiin ām siruutēchoo ōsumānē kule, ‘Kyaamwaay kule āyibook ꞉anii kule keekerkeeye.’ ");
INSERT INTO spyNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kiinkētē kule bo man ꞉siruutēkaab Yēyiin ākookoy. Kikuur ꞉Yēyiin bichoo kikiikutool kule icheek ku inee. ");
INSERT INTO spyNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kitoola ꞉Baaba ānkōōyookwoo āchōō kōōrooni. Kwaamaak ꞉nee soomwaay kule kāā-ābuch Yēyiin, yoo kaamwaay kule anii ꞉Lakwataab Yēyiin? ");
INSERT INTO spyNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yoo ākoo ‑māāmiitē āyēyē yiisyēētaab Baaba ‑moochamte ng'aleekyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nto yoo āyēyē yiisyēēnyii, ānkoo ‑mōōmuuchē ōyēnwoo, ocham naas tukuuk chēbo kwōng'uut choo kyaayey soomuuch ōnkēt kuchurta kule āsōōchiintōōsii āk ꞉Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kusyeem ꞉kāāntōōyichoo subak kule kunam Yēēsu, nteenee kubotēē taayeeng'waa. ");
INSERT INTO spyNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kinam ꞉Yēēsu baanta kut wokwaay āynēētaab Yoortaan. Kitas taay ākoy wōloo kiibātisāniisyēē ꞉Yoowaana. Kumiitē wōlooto, ");
INSERT INTO spyNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","kukwoonchi ꞉biiko chēē chaang'. Kimwooyē ꞉bichoo kule, “Manaayey ꞉Yoowaana ng'aleek chēbo kwōng'uut, nteenee ng'aleek tukul chēē kimwooy kurubta keey āk chiichi, kubo manta.” ");
INSERT INTO spyNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kiikaasee keey ꞉biiko chēē chaang' Yēēsu ām wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Kimii ꞉chiito nyēē /kikēēkuurēē Lasaaro nyēē kiminyē *kiriinkēētaab Beetannyaa āk mbo cheebkaamet āyēēng', Maaryaa āk Maariita. Ki Maaryaa nyiitēnyi ꞉nyoo kiroonkyinē kērēēnkōōkaab Yēēsu mwaayta nyēē kiboong'u nyēē anyiny ankumasee buutēēkyii. Kimii ꞉yēē kichokumnyaan ꞉Lasaaro. ");
INSERT INTO spyNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yooto kōōyookyi ꞉kooruuchoo Yēēsu ng'ālyoo /kēēmwooyē kule lalaat miisin ꞉choorweenyii nyoo choomtōōs. ");
INSERT INTO spyNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yu kakas ꞉Yēēsu, kumwooy kule, “Ānkoo kame, māng'ētunēē *kāābkwoombiich. Kāyēyākiis buch ꞉ng'aleechu sukutōrōriit ꞉Yēyiin āk Lakwanyii.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kichāmē ꞉Yēēsu Maariita, Maaryaa āk Lasaaro. ");
INSERT INTO spyNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kibēēni ꞉Yēēsu bēsyōōsyēk āyēēng' kung'eetee kānyōōr lōkōōywēchoo. ");
INSERT INTO spyNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nto mii yoo, kumwoochi rubiikyii kule, “Okany kiiyeey Yuuteeya.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nteenee kulēēnchi ꞉rubiikyii, “So, Kāānēētiintēēt, imāchē kiiyeey wōlooto, ānkōmāchē ꞉kāāntōōyichoo bo Yuutayeek kuwiireeniing' rwoontōōk?” ");
INSERT INTO spyNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kuwālchi ꞉Yēēsu rubiikyii kule, “Boonto sōō nee ꞉bēētuut āsiiswēk taman āk āyēēng' chēē /kēēyēyiisyēē? Yoo kāwēēsyēt ꞉chii bēēt, ‑/mākiināchē kuuyu irēētootē ꞉lēbkēēyyēētaab kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nteenee yoo kāwēēsyētēē mēēnānēēt, +/makiinach kuuyu mātinyē lēbkēēyyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yu keewaany ꞉Yēēsu kumwooy kuu nyooto, kumwoochi bichoo kule, “Kāruchi keey ꞉choorweenyoo Lasaaro nteenee mawaang'eet.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kumwoochi ꞉rubiik Yēēsu kule, “Mokoryoontēēt, yoo ākoo kāruchi keey ꞉Lasaaro naas ii, mākusob.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","King'āloolēē ꞉Yēēsu meetaab Lasaaro, kubērē ꞉rubiik tōōs kāru. ");
INSERT INTO spyNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yooto nanyuun, kōōchuurtoochi ꞉Yēēsu rubiichoo bakeenke kule, “Kookume ꞉Lasaaro. ");
INSERT INTO spyNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nteenee ang'erekaat, kuuyu kāmākēēboontē keey chiichoo. Kaamwaay kuu nyooto kubo akweek, sookaaseenaa keey, kunyi keebe.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kumwoochi ꞉Toomaas nyoo ki sārāmiin rubiik chuut kule, “Okany bokēēbēkyi ꞉tukul wōlooto.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kuyitu ꞉Yēēsu, kōōnkēt kule ki bēsyōōsyēk ang'wan kuchakee /kokeekonor Lasaaro. ");
INSERT INTO spyNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kilēēkityiin ꞉Beetannyaa āk Yēērusālēēm nyēē kimāchē kuyitē kiilomiitaanik sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kunyoo, kikiikukwa ꞉biiko chēē chaang' bokuriiree Lasaaro ankusaaysaay Maaryaa āk Maariita. ");
INSERT INTO spyNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yu kakas ꞉Maariita kule kāākuchō ꞉Yēēsu, kutorookta nteenee kung'ētunēē ꞉Maaryaa kō. ");
INSERT INTO spyNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Yooto kumwoochi ꞉Maariita Yēēsu kule, “Lēyyē Mokoryoontēēt, nto 'kwēēmiitē nto kōmāmēē ꞉ng'eetaabiya. ");
INSERT INTO spyNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ānkoo kuwuu nyooto, ānkētē kule imuuchē ꞉Yēyiin kuu nyiitēnyi, kuyēwuung' kiy ake tukul nyēē 'keeteeb.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kumwoochi ꞉Yēēsu Maariita kule, “Makung'eet ꞉ng'eetaabkoomēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kuwālchi ꞉Maariita kule, “Ānkētē sinee kule makung'eet bēsyoonoo bo lētuut.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kumwoochi ꞉Yēēsu kule, “Anii ꞉nyēē āng'ēētēē biiko meet ānkāākōōnu soboonto. Chiito nyoo keekaaseenaa keey, mākunyōōr *soboontaab kibchuulyo ānkoo kame. ");
INSERT INTO spyNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nto chiito nyoo ikoosēēnoo keey mābotē bēsyēēt ake. Ara, ichāmchiintōōsii āk ng'aleechu?” ");
INSERT INTO spyNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Kulēēnchi ꞉Maariita, “Āyēnchinē ōō, Mokoryoontēēt kule inyiing' ku *Kāārārookiintēēt, Lakwataab Yēyiin nyoo kimākuchō kōōrooni.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Yu keewaany ꞉Maariita kumwooy ng'aleechaa, kooyeey kaa ānkukuur cheebkaamet kuwo komos ānkumwoochi kule, “Mii ꞉kāānēētiintēēt kutēēbiing'.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","Kutākumii ꞉Yēēsu wōloo kinyōōrtooy ꞉Maariita, kung'ēētē ꞉Maaryaa areet akeenke wokutuuyēē. ");
INSERT INTO spyNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yu kakas ꞉biiko chu kimii kusooysooyē Maaryaa ām kō kule kātuyto ꞉Maaryaa saang', kurub lēt. Kiisōōtē ꞉bichoo kule tōōs kimāchē wokuriiree wōloo /kikikeekonoree ng'eetaabkaamet. ");
INSERT INTO spyNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yu kayit ꞉Maaryaa yēē kimii ꞉Yēēsu kōōbutyi kērēēnkōōkyii kumwoochinē kule, “Mokoryoontēēt, nto 'kwēēmiitē nto kōmāmēē ꞉ng'eetaabiya.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yu kakas ꞉Yēēsu kuriirē ꞉Maaryaa āk bichoo kārubē lēt, kung'woonchi. ");
INSERT INTO spyNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kuteeb kule, “Kwookonoree ānō?” /Kēēwālchi kule, “Chōō cheekas ōō, Mokoryoontēēt!” ");
INSERT INTO spyNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kuriir ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kimwooy ꞉biiko kule, “Lēyyē, ākoo kōchāmē chiichi miisin!” ");
INSERT INTO spyNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nteenee kumwooy ꞉alake kule, “So, kōmākērēktooy naas ꞉chiichi meetaab Lasaaro yoo ākoo inee ꞉nyoo kiyēyē kukasta ꞉kibkoraatyaantaanaa?” ");
INSERT INTO spyNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kiinyaliil Yēēsu ꞉ng'aleekaab bichoo. Nteenee kiwo ākoy kochong' wōloo /kikikeekonoree chiito /ankikikeekeree rwaanteet nyēē wōō kurkat. ");
INSERT INTO spyNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kumwoochi ꞉Yēēsu biiko ām yooto kule, “Ōnēmu rwaantaani.” Kuwālchi ꞉Maariita kule, “Mokoryoontēēt, boong'u miisin kuuyu bēsyēētaab ang'wan ꞉nyi kuchakee kame.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kulēēnchi ꞉Yēēsu, “Kyāāmwoowuung' oob kule yoo 'keekaaseenaa keey +meekas wōōyintaab Yēyiin?” ");
INSERT INTO spyNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kōōnēm ꞉bichoo rwaanteet. Kukas ꞉Yēēsu barak ānkulē, “Baaba, ābiruung' kōōnkōy kuuyu, 'kēēkāswoo. ");
INSERT INTO spyNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ānkētē kule ikāswoo kwaak. Āmwooyē kuu nyooto sukung'eet kukas ꞉bichu kēēboontē keey ānkōōyēnwoo kule inyiing' ꞉nyēē 'kiiyookwoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yu keewaany ꞉Yēēsu kumwooy kuu nyooto, kukuurso kule, “Ichuwu saang', wē, Lasaaro!” ");
INSERT INTO spyNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kuchuw! Kirātootiin ꞉āwunnyēk āk kērēēnkōōk siroochoo /kikēēmuytooy. Kiiyēēnootiin mbo ꞉nkicheek koonyek. Yooto, kumwoochi ꞉Yēēsu bichoo kule, “Otyaachee siroochoo sukuwēēsyēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kiikaasee keey Yēēsu ꞉biiko chēē chaang' ām choo kirubē Maaryaa lēt yu kakas kiyēē kiyey ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nteenee kiba ꞉alake ānkubokumwoochi *Farisaayeek kiyēē kiyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yooto kukuur ꞉Farisaayeek āk mbo kibkōrōs chēē wōōyēch *kōōkwēētaab Yuutayeek. Kimwoochi kōōkwēēt kule, “+Makeeyey nee? Nto yu mii ꞉chiichi kuyēyē ng'aleechu chaang' chēbo kwōng'uut! ");
INSERT INTO spyNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yoo kākēēbākookyi kutas taay ꞉chiichi ām kēēli, makookaasee keey ꞉chii ake tukul. Yooto makukwa ꞉biikaab Rooma ānkuyibēēnēēch kōōrēēt ankookarbuus biikyoo!” ");
INSERT INTO spyNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kimii yooto ꞉chiito ake nyēē /kikēēkuurēē Kayaafa ānki *kibkōrōs nyēē wōō kēnyiinooto. Kimwooy ꞉chiichoo kule, “Kaamaak ꞉nee ēē? ");
INSERT INTO spyNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","‑Mōōnkētē ꞉akweek kule kaykay kume ꞉chii akeenke kusiir kumis ꞉kōōrēēt tukul.” ");
INSERT INTO spyNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kubooyiit man, kimii mbonō ꞉chiichoo bo kōrōs kumwooyē kuu nyooto kubo kāāsōōtēywēēkyii nkit, nteenee kuuyu ki inee ꞉nyēē ki kibkōrōs nyēē wōō ām kēnyiinooto ānkiimutyoonu ꞉ng'aleekyii kule makume ꞉Yēēsu sukusobcho ꞉Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kimābo Yuutayeek nkit nteenee kibo kule /sikiiruruuch ꞉lōkōkaab Yēyiin choo kisērētyinoot kōōrōōsyēk kuyēk kiito akeenke. ");
INSERT INTO spyNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kitoow ꞉kāāntōōyikaab Yuutayeek kuchakee bēsyoonooto kuwo taay, kucheeng' wōlēē makunamta Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kunyoo manaatakutaaltaat keey ꞉Yēēsu ām yēēmoonoo bo Yuuteeya. Kiwo āk rubiikyii *kiriinkēēt ake nyēē /kikēēkuurēē Efrayiim yēē kilēēkitēē suurkwēēnēēt ānkubokōōbuur wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ām bēsyōōsyēchooto kikiikulēēkitiit kwaam ꞉Yuutayeek *Saakweetaab Keeytaayeet. Kunyoo kikiikuba ꞉biiko chēē chaang' Yēērusālēēm bokōōtiliil keey, kutoombo kuyitu ꞉saakwaanaa. ");
INSERT INTO spyNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yooto tukul kimii ꞉bichoo kuchēēng'ē Yēēsu. Kitēēbēē keey ām *Kōōtaab Yēyiin kule, “Ara chōōnii man ꞉chiichoo saakwaani?” ");
INSERT INTO spyNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kikiisimkumwoochi ꞉mbo kibkōrōs chēē wōōyēch ākoo *Farisaayeek biiko kule yoo kakas ꞉chii wōlēē mii ꞉Yēēsu kumwooy /sikeenam. ");
INSERT INTO spyNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ām bēsyōōsyēk lo kumanaayit *꞉Saakweetaab Keeytaayeet, kuwo ꞉Yēēsu Beetannyaa wōloo kiminyē ꞉Lasaaro, chiichoo kiing'ēētēē ꞉Yēēsu meet. ");
INSERT INTO spyNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kibay ꞉Maariita Yēēsu āk rubiikyii ām wōlooto kuboonto keey Lasaaro. ");
INSERT INTO spyNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nto mii yoo kunam ꞉Maaryaa mwaayta laaleet akeenke nyēē kiboong'u nyēē anyiny /ānkyoolēē beesaan chēē chaang'. Kiroonkyi ꞉Maaryaa mwaayaa kērēēnkōōkaab Yēēsu, nto yityo, kumasee buutēēkyii. Kiboong' ꞉mwaayaa kuker kōōt tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nteenee kimwooy ꞉Yuuta Iskaryoot nyoo ki akeenke ām rubiichoo bo Yēēsu (nyoo kimii wokuchoomtooy inee) kule, ");
INSERT INTO spyNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“So, ntēē /kāmākyooltēē mwaayi beesaan chēē chaang' /ānkiikoochi beesaanichaa bānoonik?” ");
INSERT INTO spyNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kimāmwooyē ꞉chiichoo ng'aleechaa kuriirēē bānoonik, nteenee kuuyu ki kōnōriintēēt ānkisobēē beesaanichaa kubētēchēē kisich, kisich. ");
INSERT INTO spyNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nteenee kimwooy ꞉Yēēsu kule, “‑Meemakee kiy. Kany kukonor mwaayaa kubo bēsyoonoo +/makeemuya. ");
INSERT INTO spyNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","+Mōōboontē keey ꞉akweek bānoonik kwaak nteenee mēēbērē ōboontē keey anii kwaak.” ");
INSERT INTO spyNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yu kakas ꞉biiko chēē chaang' kule kimii ꞉Yēēsu Beetannyaa bokukas. Kimā Yēēsu nkit nyēē kibokukāsē nteenee kimāchē kukas nkinee Lasaaro nyoo kiing'ēētēē ꞉Yēēsu meet. ");
INSERT INTO spyNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kichōb ꞉mbo kibkōrōs chēē wōōyēch kubakach nkinee Lasaaro ");
INSERT INTO spyNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kuuyu, kiyey ꞉ng'eeteenyii bo meet kumwēyēē ꞉biiko chēē chaang' kāāntōōyichoo bo Yuutayeek ānkuyēēlchi Yēēsu ankookaasee keey inee. ");
INSERT INTO spyNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yu kayyeech, kukas ꞉biiko chēē chaang' choo kikiikukwa *Saakwaanaa bo Keeytaayeet kule kimii ꞉Yēēsu kuchōōnii Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yooto kunam sokēēkaab sōōsik ankutorookta Yēēsu. Kityēēnchinootē ꞉bichoo barak kule, “Kutōrōriit ꞉Yēyiin! Ibēruuroot ꞉nyi chōōnii ām kaayneetaab Yēyiin. Ibēruuroot ꞉bāytooyiintēētaab *Isrāyēēl.” ");
INSERT INTO spyNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kikalabaan Yēēsu ꞉sikiryēēt nyēē ki siirwaak, kootyiich yoo mwooyē ꞉siruutēkaab Yēyiin kule, ");
INSERT INTO spyNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“‑Mōōmuuyē, wē, ꞉biikaab Sāāyōōn. Ong'nyi chōōnii ꞉bāytooyiintēēng'woong'. Kālāboonu ꞉sikiryo nyēē siirwaak.” ");
INSERT INTO spyNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mānāāsimkōōnkēt ꞉rubiik kule kiyēē /kikēēmiitē /kēēyēchinē Yēēsu kimii kōōtyiichē siruutēkaab Yēyiin. Nteenee yu kiiyēēyē ꞉Yēēsu kibkōōnkōy, kōōsōōtyi kiyoo kikiikumwooy ꞉siruutēk kurubta keey āk Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kikiikwaamtaat ꞉biiko choo kikāsē kōōng'ēētēē ꞉Yēēsu Lasaaro meet ng'aleechaata. ");
INSERT INTO spyNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kunyoo, kiyey ꞉yooto kutorookta ꞉bichoo chaang' Yēēsu kuuyu ki ng'ālyoo ꞉nyoo nyēē manaayeyakay bēsyēēt ake! ");
INSERT INTO spyNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yooto kukōrōmchi keey *꞉Farisaayeek kule, “Kookas oob kule buch ꞉kiyēē ōmiitē ōyēyē! Okas, ntēē kāākuwuuchi ꞉kōōrēēt tukul chiichiito!” ");
INSERT INTO spyNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kimii ꞉nkicheek Kirikiik alake chēē kikikwa Yēērusālēēm bokwaam saakwaanaa. ");
INSERT INTO spyNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kiba ꞉Kirikiichoo ākoy wōlēē kimii ꞉Filibō nyoo kibo Beetsaayta ām Kalilaaya ānkumwoochi Filibō kule, “Boontēēt, kēēmāchē keekas Yēēsu.” ");
INSERT INTO spyNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kumwoochi ꞉Filibō Antereeya, nto yityo kuyibchi ꞉tukwaay Yēēsu lōkōōywēchoo. ");
INSERT INTO spyNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yooto kumwoochi ꞉Yēēsu icheek kule, “Kāākuyityi nanyuun yēē +/mākiitōrōōr *Wēritaab Chii. ");
INSERT INTO spyNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","!Kāāmwoowook, yoo kāmēēsuuchi ꞉kēbuswoontēēt ng'wēny ankume, kung'ētu ku inee keey. Nteenee yoo kame, makuyey āmiik chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Chiito nyoo kāyēētyi keey soboonnyii, mākōōboot. Nto nyoo kēēkooyto soboonnyii ām kōōrooni, mākunyōōr *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chiito nyoo māchē kuyēwoo yiisyēēt kumāchāktōōs kuruba ānkēēboontootē keey āk inee. Mākukoonyit ꞉Baaba chiichooto yēwoo yiisyēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kaakwaama ꞉ng'uusng'uus. Lēyyē, +maamwaay nee? Ara +māāmwoochi Baaba kōōnēmwoo nyalili mii kuchōōnchoo? Acha, nto yu ki ākoy kuyityiin kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baaba, itōrōōr kaayneeng'uung'.” Yooto, kuchōōnēē ꞉bōlātēēt barak nyēē kimwooyē kule, “Kyāātōrōōr, ānku +māātōrōōr subak.” ");
INSERT INTO spyNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Yu kakas ꞉biiko choo kikiiyyoong'iis yooto bōlātoonoo, kumwooy ꞉bichoo alake kule, “Kātul ꞉kōōrēēt.” Kulē ꞉alake, “Kāng'āloolchi *꞉malayikeet chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kumwoochi ꞉Yēēsu bichoo kule, “Kātook ꞉bōlātoonoo kubo akweek mēēbērē anii. ");
INSERT INTO spyNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kāākuyityiin yēē +/mākiitiilchi biikaab kōōrēēt ng'aleek. +/Makeekwet Bāytooyiintoonoo bo kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nteenee yoo /kiitōrōōroo, +māāyisu biiko tukul kukwa wōlēē āmiitē.” ");
INSERT INTO spyNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yooto kimwooyē ꞉Yēēsu kuu nyooto, kiibooru meet nyēē kimii kuchōōnchinē. ");
INSERT INTO spyNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kulēēnchi ꞉biiko Yēēsu, “Mwoowēēch ꞉kiruutēkyoo kule ming'iisyē *꞉Kāārārookiintēēt ākookoy. So ku ānō wōli imwooyē kule /kiitōrōōrē *Wēritaab Chii? Ng'oo ꞉chiichi /kēēbērē Wēritaab Chii?” ");
INSERT INTO spyNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kumwoochi ꞉Yēēsu bichoo kule, “+Mōōboontē keey lēbkēēyyēēt bēsyōōs chēē ng'ēri. Nto yoo tōōboontē lēbkēēyyēēt, ōbēēsyētootēē simalukuyaak ꞉mēēnānēēt. ‑Mēēnkētē ꞉chii nyoo mii mēēnān wōlēē wēētii. ");
INSERT INTO spyNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yoo tōōboontē keey lēbkēēyyooni kumāchāktōōs okaasee keey sōōbooyiitu lēbkēēyyēēt.” Yu keewaany ꞉Yēēsu kumwooy ng'aleechaata kubotēē yooto. ");
INSERT INTO spyNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ānkoo kikiikuyey ꞉Yēēsu ng'aleek chēē chaang' chēbo kwōng'uut ām taayeetaab bichoo, manaakookaasee keey ꞉bichoo inee. ");
INSERT INTO spyNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kiyeyakay ꞉yooto kootyiich yoo kimwooyē ꞉wōōrkooyoontēētaab Yēyiin *Isaaya kule, “Ara mii ꞉chii nyēē kiiyēnchi lōkōōywēkyoo ōō, Yēyiin, nto nyēē kiikōōnkēt kāāmuukēywēēkuuk?” ");
INSERT INTO spyNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Manaakookaasee keey ꞉bichoo Yēēsu, kurub kuu yoo kisirē *꞉Isaaya kumwooyē kule, ");
INSERT INTO spyNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kiker ꞉Yēyiin koonyekwaa ankuyey kuyoomcho ꞉mētēwook simakas kiy. Kunyoo, ‑mēēmuuchē kukas kiy āmēēmuuchē kusēw ꞉mētēwookwaa, nto yooto, kumāwēēktōōs kukwa wōlēē āmiitē sukung'eet āsoob icheek.” ");
INSERT INTO spyNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kimwooy *꞉Isaaya ng'aleechu kuuyu kikiikukas wōōyintaab Yēēsu ankikiikung'alaalee. ");
INSERT INTO spyNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ānkoo kiwuu nyooto, kiikaasee keey ꞉biiko chēē chaang' Yēēsu ākoo mbo kāāntōōyik alak chēbo Yuutayeek. Nteenee kuuyu kinyōkōōrēch *꞉Farisaayeek, kimāng'āloolēē ꞉icheek ng'aleechaa kutook /simakeekwetee *kōōtaab saayeet. ");
INSERT INTO spyNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kiyey ꞉kāāntōōyichoo kuu nyooto kuuyu kichāmē yoo kāsil icheek ꞉biiko mēēbērē yoo kāsil ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kikuurchi ꞉Yēēsu biiko kule, “Chii nyoo keekaaseenaa keey, kumii kōōkoosēē keey Baaba anii nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Chiito nyoo kaakukasa, kaakukas nkinee Baaba nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kyāāchōō kōōrooni chāākōōnu lēbkēēyyēēt sukung'eet ꞉chii ake tukul nyoo ikoosēēnoo keey mēēbērē ng'ētunēē mēēnān. ");
INSERT INTO spyNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","‑Māātiilchinē chii ng'al nyoo kāsē ng'aleekyuu āmākoonyitē kuuyu kimāāchōōnii chāātiilchinē biikaab kōōrēēt ng'al nteenee kichāārāroochē. ");
INSERT INTO spyNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nto chii nyoo kataya ankutay ng'aleekyuu, makooruusta ꞉ng'aleechaa nkit bēsyoonoo bo tabanta kuuyu kichuunnyēē. ");
INSERT INTO spyNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ng'aleek chēē āmwooyē mākwoonēē wōlēē āmiitē, nteenee Baaba nyoo kiiyookwoo ꞉nyēē kimwoowoo kule āmwoowu. ");
INSERT INTO spyNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ānkētē kule kiyēē mwooyē ꞉Baaba kuyibu *soboontaab kibchuulyo. Kunyoo, kiy ake tukul nyoo āmwooyē ku nyēē kimwoowoo ꞉Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yooto kikiikuriik /kyaam *Saakweetaab Keeytaayeet. Kiinkēt ꞉Yēēsu kule kikiikuyityi ꞉bārooyinnyii kung'eetee kōōrooni ānkuwo wōlēē mii ꞉Kwaan. Kichāmē kutukul biikyii choo kiboonto keey. ");
INSERT INTO spyNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yu kimii ꞉Yēēsu wokwoomiisyē āk rubiikyii, kikiikuyey ꞉Kibrōkōsyoontēēt Yuuta Iskaryoot kuchaamta Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kiinkēt ꞉Yēēsu kule kikiikōōtōōrchi inee ꞉Kwaan kāāmuukēywēēk tukul. Kiinkētē subak kule kichōōnēē ꞉inee wōlēē mii ꞉Yēyiin ankimakooyeey wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kiiyyo ꞉Yēēsu ānkōōrēēk kābuutiinyii nto yityo kumootee keey ankeet nyēē abuus. ");
INSERT INTO spyNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kiroonkyi bēēko karaayiit ānkutoow kōōwuunoot kērēēnkōōkaab rubiikyii. Kimāsēē kērēēnkōōchoo ankaanaa. ");
INSERT INTO spyNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nto yu kayit yēē kimii ꞉Simōōni Bētērō, kulēēnchi ꞉nyoo, “So, Mokoryoontēēt! Imāchē iwuunwoo kērēēnkōōk?” ");
INSERT INTO spyNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Kuwālchi ꞉Yēēsu kule, “‑Mēēnkētē kiyēē āmiitē āyēyē kuu nyi, nteenee +mēēnkēt lētuunoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kutāyiis ꞉Bētērō ānkumwooy kule, “Acha! Mākoy iwuunwoo kērēēnkōōk.” Kumwoochi ꞉Yēēsu Bētērō kule, “Yoo kāmāāwuunuung', māyēmāktōōs tākiibuurtē keey.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kumwoochi ꞉Bētērō kule, “Yoo wuu nyooto nanyuun ii, Mokoryoontēēt, iwuunwoo mbo nkinee mētit āk āwunnyēk.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kuwālchi ꞉Yēēsu kule, “Chii nyoo kāākōōwuun keey kumāchāktōōs baateey kuchururta kērēēnkōōk. Ōtiliilēch ꞉akweek tukul nteenee mii ꞉akeenke ām akweek nyēē mā tiliil.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kimwooy ꞉Yēēsu kuu nyooto kuuyu kikiikōōnkēt chiichēē kimii wokuchoomtooy inee. ");
INSERT INTO spyNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yu keewaany ꞉Yēēsu kōōwuun kērēēnkōōkaab rubiichoo, koolaach kābuutiinoo ānkuwokōōbuur ng'wēny wokwoomiis. Yooto kumwoochi ꞉Yēēsu rubiikyii kule, “Ibooru nee ꞉kiyoo kātāāyēyē? ");
INSERT INTO spyNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ōkuuroo kule, ‘Kāānēētiintēēt’ nto kule ‘Mokoryoontēēt.’ Man āwuuyē nyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ānkoo āyēku ꞉anii Mokoryoontēēng'woong' āk kāānēētiintēēng'woong', kāāwuunwook kērēēnkōōk. Kunyoo māchāktōōs ꞉nkakweek ōwuunchinē keey kērēēnkōōk ");
INSERT INTO spyNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","kuu yoo kātāāboorwook ꞉anii. ");
INSERT INTO spyNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","!Kāāmwoowook, mā wōō ꞉motwooriintō kusiir mokoryoontēēnyii āmā wōō ꞉kiiyookiintō kusiir kāāyooktooyiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yoo koorub ng'aleechu kātāāmwoowook, mākōōbēruurook ꞉Yēyiin! ");
INSERT INTO spyNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‑Māāng'āloolēēnook akweek tukul kuuyu ānkētē soboonwēkaab choo kyaakwey. Nteenee māchāktōōs kuyityiin ꞉siruutēkaab Yēyiin ꞉yēē mwooyē kule, ‘Kiwēēkyoo keey ꞉chiito nyoo kikyoomiisyē ꞉tukwaay.’ ");
INSERT INTO spyNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kāsimāmwoowook ng'aleechu kumānāāyēyākiis, si yoo yēyāktōōs, +mookaasee keey kule anii nyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","!Kāāmwoowook, nyoo toochē chiichēē kāāyooktē, kaakutaacha. Nto nyoo kaakutaacha, kaakutaach nkinee nyoo kiiyookwoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kiiyiimset ꞉yooto Yēēsu mēt kut kulē, “!Kāāmwoowook, mii ꞉akeenke ām akweek nyēē makuchaamtaa.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kukas keey ꞉rubiik nyēē kanam kuut kule ng'oo ꞉nyooto /kēēmwooyē. ");
INSERT INTO spyNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kikitiing'to Yēēsu ꞉rubiintoonoo kichāmē. ");
INSERT INTO spyNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yooto kubutēē ꞉Bētērō rubiintoonoo koong'ta kuteebee Yēēsu kule ki ng'oo ꞉nyooto kimii ꞉inee kung'āloolēē. ");
INSERT INTO spyNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kōōtōrōōr ꞉rubiintoonoo mētinyii ankuteebee Yēēsu kule, “Ng'oo ꞉nyooto ōō, Mokoryoontēēt?” ");
INSERT INTO spyNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kumwoochi ꞉Yēēsu kule, “Nyoo kāākoochi mukaatiit nyēē kaalablaabte, ku chiito ꞉nyooto.” Kunam ꞉Yēēsu mukaatiit ankoolablaabta suutēēk nto yityo kōōyokoochi Yuuta Iskaryoot. ");
INSERT INTO spyNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kunāmē ꞉Yuuta mukaatiinaa kōōloombuuchē ꞉Kibrōkōsyoontēēt bakeenke. Kumwoochi ꞉Yēēsu kule, “Ānkiisārchi kiyēē imāchē iyey.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kimēēnkētē ꞉rubiik chuut alake kiyēē kiibooru ꞉ng'aleechaa bo Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kiisōōtē ꞉rubiik alake kule tōōs kāmwoochi ꞉Yēēsu inee wokwaal tukuukaab saakweet nto kule kōōkoochi biiko choo bānoon kiy kuuyu ki kōnōriintēētaab beesaanik. ");
INSERT INTO spyNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yu kaakunam ꞉Yuuta mukaatiinaa, kuchuyta. Kikiikutuuyiit yooto ꞉kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yu kaakuchuyta ꞉Yuuta, kumwooy ꞉Yēēsu kule, “Mākōōtōrōōrākoy ra *꞉Wēritaab Chii ānkōōtōrōōrākoy ꞉Yēyiin kubununēē inee. ");
INSERT INTO spyNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kuu yoo itōrōōrē ꞉Yēyiin Wēritaab Chii, mākōōtōrōōr ꞉nkinee Yēyiin ānkuyēyāktōōs areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kunyoo ii, lōkōkyuu, ‑mēētākiibuurtooy keey akweek nyēē lōō. +Moocheeng'aa nteenee, āmwoowook kule, ‘‑Mōōbēētii wōloo +māāwē’, kuu yoo kyāāmwoochinē kāāntōōyichoo bo Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Āmiitē wāākōōnook mākuutyēēt nyēē lēēl, nto nyooto ku nyi: Ōchoomtōōsii kuu yoo kyāāchāmook ꞉anii. ");
INSERT INTO spyNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yoo ōchoomtōōsii, mākōōnkēt ꞉biiko tukul kule ōyēku rubiikyuu.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nto tēē yoo, kuteebee ꞉Bētērō Yēēsu kule, “Imāchē iwē ānō ōō, Mokoryoontēēt?” Kuwālchi ꞉Yēēsu kule, “‑Mākēēbēētooy keey kuu nyi, nteenee +meerubwaa lētuunoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kuteebee ꞉Bētērō Yēēsu kule, “Ām nee simakeebeete keey raat ōō, Mokoryoontēēt? Yoo kābo nee, kēēbēku ꞉tukwaay!” ");
INSERT INTO spyNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kuwālchi ꞉Yēēsu kule, “Kule kēēbēku ꞉tukwaay? !Kāāmwoowuung', kutoombo kooturkuuch ꞉kirkōōnkiit, +meetuuch keey areet sōmōk.” ");
INSERT INTO spyNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kumwoochi ꞉Yēēsu rubiikyii subak kule, “‑Matookany kubēk ꞉moonik. Okaasee keey Yēyiin ankookaaseenaa keey. ");
INSERT INTO spyNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mii ꞉kooriik chēē chaang' Kaab Baaba wōlēē +māwāāyēytoowook ming'ātēēt. Nto kāmāwuu nyoo, nto kāmāāmwoowook kuu nyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yoo kāwāāyēytoowook ming'ātoonoo, +māāyēēwu chaamutaak subokiibuurtē keey. ");
INSERT INTO spyNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ōnkētē ꞉akweek kēēlto nyēē wēētii wōlēē +māāwē anii.” ");
INSERT INTO spyNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yooto kumwoochi ꞉Toomaas Yēēsu kule, “Yoo ‑mākiinkētē raat mbo wōlēē iwēētii ii, Mokoryoontēēt, bokiinkētē nee kēēlto nyi imwooyē?” ");
INSERT INTO spyNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kuwālchi ꞉Yēēsu kule, “Anii ꞉kēēlto. Anii ꞉manta ānku anii ꞉soboonto. Māmii ꞉chii nyēē wēētii Kaab Baaba yoo kāmābuntēēnoo. ");
INSERT INTO spyNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nto kōōnkētoo, nto kōōnkētē nkinee Baaba. Nteenee ōmiitē bōōnkētē ām lēēkitō kule ng'oo ꞉Baaba ankukookasee koonyekwook mbo kēny.” ");
INSERT INTO spyNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kumwoochi ꞉Filibō Yēēsu kule, “Mokoryoontēēt, ng'oo ꞉Kōōn. Kiyooto ꞉nyēē kēēmāchē kityō.” ");
INSERT INTO spyNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kuwālchi ꞉Yēēsu kule, “So, Filibō, kōōkiibuurtē keey nyi kooy āmānēēnkētoo. Chiito nyoo kaakukasa kaakukas Baaba. Imuuchē kule nee iteebeenaa kule ng'oo ꞉Baaba anii? ");
INSERT INTO spyNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","So, ‑mēēchāmtooy ꞉inyiing' kule, anii āk Baaba ku kiy akeenke? Ng'aleek choo āmwoowook kumā cheechuu nteenee bo Baaba nyoo inee ku anii ānkuyēyiisyēēnoo. ");
INSERT INTO spyNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ochamtaa yoo āmwooyē kule anii āk Baaba ku kiy akeenke. Nto yoo māwuu nyoo, ochamtaa naas kubo ng'aleechaa bo kwōng'uut choo kyaayey. ");
INSERT INTO spyNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","!Kāāmwoowook, chii nyoo ikoosēēnoo keey makuyey tukuukaab kwōng'uut chēē wuu choo kyaayey ꞉anii ankumakuyey mbo chēē chaang' kusiir chu, kuuyu ‑māāmiitē. ");
INSERT INTO spyNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","Kiy ake tukul nyēē kooteeb ām kaayneenyuu, +maayey, sukutōrōriit ꞉Baaba kubununēē Lakwanyii.” ");
INSERT INTO spyNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kitas taay ꞉Yēēsu kumwoochi rubiikyii kule, “Yoo ōchāmoo, ōriib mākuutēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","+Maateebee Baaba kukōōnook Tāmirmiryēēnyii nyēē mākuyēētyēēchook kuu wōloo kwāāyēytooy ꞉anii. ");
INSERT INTO spyNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bo manta ꞉Tāmirmiryoonoo ānku +mōōbuurtē keey ākookoy. Mānyōōru ꞉chii nyēbo kōōrooni kuuyu mēēbērē makukas Tāmirmiryoonoo nto kōōnkēt. Nteenee +mōōnkētē ꞉akweek Tāmirmiryoonooto kuuyu mii wōlēē ōmiitē ānku +mōōbuurtē keey. ");
INSERT INTO spyNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","+Māāwē, nteenee ‑mōōng'ētu kuu bānoon. +Māāyēēwu wōlēē ōmiitē. ");
INSERT INTO spyNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Lēēkit ang'eetee kōōrēēt nyēē mākoy kukasa ꞉biikaab kōōrooni subak, nteenee +mookasaa ꞉akweek. Nto kuuyu āboontē ꞉anii soboonto, +mōōnyōōru soboonto. ");
INSERT INTO spyNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yoo kookasaa yooto, +mōōnkēt kule āyēku ꞉anii akeenke āk Baaba ānkāāyēku akeenke āk akweek. ");
INSERT INTO spyNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Chiito nyoo kāsē mākuutēkyuu ānkuriibē, kuchāmoo. Makucham ꞉Baaba chii nyoo chāmoo ankaacham ꞉nkanii ānkāāboorchi keey.” ");
INSERT INTO spyNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yooto kumwoochi ꞉Yuuta nyiin ake Yēēsu kule, “Mokoryoontēēt, ām nee yu imāchē iboorwēēch keey āmēēmāchē iboorchi keey biikaab kōōrooni?” ");
INSERT INTO spyNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Kuwālchi ꞉Yēēsu kule, “Chii nyoo chāmoo, kukoonyitē ng'aleek choo ānēētē. Makucham ꞉Baaba chiichoo ānku +māāchōōntē keey Baaba ānkubokēēming'tē keey. ");
INSERT INTO spyNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Chii nyoo māchāmoo, mākoonyitē kiyēē ānēētē. Mākwoonēē ꞉ng'aleechu kookas wōlēē āmiitē, nteenee bo Baaba nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Āmwoowook ng'aleechu kuuyu tākēēboontē keey. ");
INSERT INTO spyNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nteenee mākuyēētyēēchook ꞉Tāmirmiryēētaab Yēyiin nyoo mākōōyook ꞉Baaba. Mākōōnēētook ānkōōsōōtwook ng'aleek tukul choo kyāāmwoowook. ");
INSERT INTO spyNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Lēyyē, ōbuurtē kaalyeenyuu. Makerkeey ꞉kaalyaani ākōōnook nyoo kōōnook ꞉biikaab kōōrooni. ‑Mookany kubēk ꞉moonikwook, āmōōmuuyē. ");
INSERT INTO spyNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kookas oob yoo kāāmwoowook kule, ‘+Māāwē ānku +māāyēēwu wōlēē ōmiitē.’ Yoo ōchāmoo, ong'erech kubo kule āmiitē āwēētii Kaab Baaba nyoo wōō kubiira. ");
INSERT INTO spyNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kāsimāmwoowook ng'aleechu kumānāāyēyākiis, si yoo kāyēyākiis +mōōyēnchi. ");
INSERT INTO spyNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kāmāāng'āloolē āk akweek nyēē lōō kuuyu mii kuchōōnii ꞉bāytooyiintēētaab kōōrooni. Māboonto ꞉bāytooyiintoonoo kāāmuukēy kubāwoo, ");
INSERT INTO spyNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nteenee kāyēyākiis ꞉ng'aleechu sukōōnkēt ꞉biiko tukul kule āchāmē Baaba kuuyu āyēyē kiyēē mwoowoo kule ayey. Lēyyē, kēēng'ēētyēē yu.” ");
INSERT INTO spyNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kitas taay ꞉Yēēsu kumwoochi rubiikyii kule, “Anii *musābiibuut nyēbo man nto Baaba ku chiitaab mbareet. ");
INSERT INTO spyNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tiltooy ꞉Baaba sokonnyeenyuu ake tukul nyoo māyēyē āmnyoo, ānkubulē sokonnyeet nyoo kiyey lokoyeek sukuyey lokoyeek chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kōōtililiitu mbo ꞉akweek kēny ām lōkōōywēk choo kwāāmwoowook. ");
INSERT INTO spyNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yoo kōōkiilchoo, ākiilchook. Māyēyē ꞉sokonnyeetaab musābiibuut lokoy yoo mēēbērē kānoomchi musābiibuut. Wuu nyooto ām wōlēē ōmiitē ꞉nkakweek. ‑Mōōyēyē kiy nyēē karaam yoo kāmōōkiilchoo. ");
INSERT INTO spyNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Anii ꞉musābiibuut, akweek ꞉sokonaak. Yoo kākiilchoo ꞉chii ānkāākiilchi ꞉nkanii, kuyēyē tukuuk chēē chaang' chēē kāroomēch. Kunyoo, ‑mōōyēyē kiy yoo kāmōōkiilchoo. ");
INSERT INTO spyNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","/Kiinēmtooy biiko choo kāmākiilchoo kuu sokonaachaa /kēētiltooy. Kuu yoo mākuyoomcho ꞉sokonaachaa, nto mii yoo /kiiruruuch /ānkēēwiirchi ma kulāyo, +/mākiinēmto nkicheek biiko choo kāmākiilchoo /ānkēētōōrchi maataab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yoo kōōkiilchoo ānkōōbuurtē ng'ālyoontēēnyuu, ankooteeb kiy ake tukul nyēē ōmāchē, /kēēkōōnook. ");
INSERT INTO spyNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yoo kooyey lokoyeek chēē chaang' ānkōōyēku man rubiikyuu, +mōōtōrōōr Baaba. ");
INSERT INTO spyNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Āchāmook ꞉anii kuu wōloo chāmtoo ꞉Baaba. Kunyoo, ōbuurtē ꞉nkakweek chamateenyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yoo kōōriib mākuutēkyuu, +mōōbuurtē chamateenyuu, kuu yoo kyāāriib ꞉nkanii mākuutēkaab Baaba ānkāābuurtē chamateenyii. ");
INSERT INTO spyNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Āmwoowook ng'aleechu sōōbuurtē ng'erekweekyuu, si nto yityo, kuchurta ꞉ng'erekweekwook. ");
INSERT INTO spyNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mākuutyēēnyuu nyi: Ōchoomnyē kuu yoo āchāmook ꞉anii. ");
INSERT INTO spyNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Māmii ꞉chamateet nyēē wōō kusiir yoo kēēnēm keey ꞉chiito kume kubo chōōrōōnuutēkyii. ");
INSERT INTO spyNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yoo kooyey kiyēē kāāmwoowook, ōyēku chōōrōōnuutēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","‑Mātāākuurook subak kule motwoorik kuuyu ‑mēēnkēt ꞉motwooriintēēt kiyēē yēyē ꞉mokoryoontēēnyii. Nteenee ākuurēēnook ra chōōrōōnuutēkyuu kuuyu kāāmwoowook ꞉anii kiy ake tukul nyēē kyāākāsēē Baaba. ");
INSERT INTO spyNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kimōōkwēyoo anii ꞉akweek kule āyēku mokoryoontēēng'woong'. Anii ꞉nyēē kyāākwēyook ōyēku rubiikyuu. Kyaatoolaak kukiil ꞉soboonng'woong' bo tāmirmiryēēt sukung'eet kukōōnook ꞉Baaba kiy ake tukul nyoo kooteeb ām kaayneenyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kunyoo, mākuutyēēnyuu nyi: Ōchoomnyē.” ");
INSERT INTO spyNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kumwoochi ꞉Yēēsu rubiikyii subak kule, “Yoo kāwēchook ꞉biikaab kōōrooni ōnkēt kule kisimkuwēcho anii. ");
INSERT INTO spyNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nto kyōōbooyē kōōrooni nto kichāmook ꞉biikaab kōōrooni. Nteenee kyaakweyaak ꞉anii ōyēku cheechuu, kunyi ‑mōōbooyē kōōrēēt. Kiyooto ꞉nyēē wēchēēnook ꞉biikaab kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Osoot yoo kāāmwoowook kule, ‘Mā wōō ꞉motwooriintō kusiir mokoryoontēēnyii.’ Kuu yoo /kiinyāliiloo, +/makiinyaliilaak nkakweek. Nto yoo /kēēkoonyitē kiyēē kwaaneet ꞉anii, +/mākēēkoonyit kiyēē +mooneet ꞉nkakweek. ");
INSERT INTO spyNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mākuyēwook ꞉biikaab kōōrooni ng'aleechu tukul kuuyu ōyēku cheechuu āk subak kuuyu ‑mēēnkētē ꞉bichoo nyoo kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nto kimānāāchōō ānkāāng'āloolchi bichoo, nto /kimākiitiilchinē kule kiikuchoolwookēn. Nteenee kuuyu kyāāchōō, māmii ꞉wōlēē makutuukta keey ꞉chii ām choolwookātēēt nyēē kiikuyey. ");
INSERT INTO spyNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Chiito nyoo wēchoo, kuwēchē nkinee Baaba. ");
INSERT INTO spyNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nto kimanaayey tukuuk chēbo kwōng'uut ām wōlēē mii ꞉bichoo, nto /kāmākiitiilchinē bichoo ng'al. Ānkoo kookukas ꞉bichoo tukuuchoo bo kwōng'uut choo kwāāyēyē, tākuwēchoo ānkuwēchē nkinee Baaba. ");
INSERT INTO spyNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nteenee ityiichē ꞉yuutēyu siruutyēētaab Yēyiin ꞉yoo mwooyē kule, ‘/Kikēēwēcho buch.’ ");
INSERT INTO spyNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Lēyyē, ōnkētē kule yoo kāāwē ꞉anii Kaab Baaba, +māwāāyooku Tāmirmiryēētaab Yēyiin nyēē mākuyēētyēēchook. Mākōōboorchi biiko manta āk wōlēē āwuuyē ꞉anii. ");
INSERT INTO spyNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mēēbērē Tāmirmiryēētaab Yēyiin nkit nyēē mākōōboortoo nteenee ōboortoo ꞉nkakweek kuuyu kikēēboontootē keey tukul kuchakee kēny. ");
INSERT INTO spyNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Āmwoowook ng'aleechu simōōchuunnyēē kiyēē kyōōyēnchi. ");
INSERT INTO spyNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Makukweteenaak ꞉bichoo kooriikaab saayeet. Makuyit ꞉bēsyēēt nyēē yoo kabakachaak ꞉chii kōōsōōtē kule kayey kiyēē māchē ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yēyē kuu nyooto kubērē tōōs kayey chēē kāroomēch, nteenee yēyē kuuyu ‑mēēnkētē Baaba āmēēnkētoo. ");
INSERT INTO spyNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kāsimāmwoowook ng'aleechu si yoo kayit ꞉yooto kōōsōōtwook ng'aleechaa kyāāmwoowook. Kimānāāsimāmwoowook ng'aleechu kuuyu kitākēēboontē keey. ");
INSERT INTO spyNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nteenee āmiitē wāāyēēyē Kaab Baaba nyoo kiiyookwoo āchōō kōōrooni, amateebeenaa ꞉chii ām akweek wōlēē āwēētii. ");
INSERT INTO spyNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ānkētē kule kāākung'woonchook ꞉ng'aleechu. ");
INSERT INTO spyNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nteenee āmwoowook manta kule karaam ām wōlēē ōmiitē yoo kāāwē suwāāyooku Tāmirmiryēēt kuchō wōlēē ōmiitē, kuuyu yoo kāmāāwē, māchōōnii ꞉Tāmirmiryēēt chokuyēētyēēchook. ");
INSERT INTO spyNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yoo kāchō ꞉Tāmirmiryēēt, mākōōboorchi biiko kule kustooyootiin ām wōlēē kāstooy ꞉icheek ng'ōōkisto, churtaayeet āk kiyēē itiilē ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kurubta keey āk ng'ōōkisto, ku kule ‑mēēkoosēēnoo keey, ");
INSERT INTO spyNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","churtaayeet ku kule, āmiitē āyēēyē ꞉anii Kaab Baaba āmātōōkāsoo ");
INSERT INTO spyNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","nto kiyēē itiilē ꞉Yēyiin ku kule, /kāākiitiilchi ng'aleek bāytooyiintēētaab kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Āboontē ng'aleek chēē chaang' chēē ābērē nto tāāmwoowook nteenee nyikisyook miisin. ");
INSERT INTO spyNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nteenee yoo kāchō ꞉Tāmirmiryoonoo bo manta, mākwoorōōrwook ōnkēt manta kutukul. ‑Māmwoowu kiyēē chōōnēē kāāsōōtēywēēkyii nteenee mākumwoowu nyēē /kēēmwoochinē āk tukuuk chēē makukwa. ");
INSERT INTO spyNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mākōōtōrōōroo ꞉Tāmirmiryoonoo kuuyu mākunyōōru ng'aleekyuu ānkumwoowook. ");
INSERT INTO spyNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kiy ake tukul nyēbo Baaba ku nyeenyuu. Kiyooto ꞉nyēē āmwooytēē kule mākunyōōru ꞉Tāmirmiryoonoo ng'aleekyuu ānkumwoowook. ");
INSERT INTO spyNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kāmēētābōōkāsoo ām lēēkitō, nto nyēē mā tyaa ātooku subak.” ");
INSERT INTO spyNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kimwooy ꞉rubiichoo alake kule, “So, ibooru nee ꞉ng'aleechu? Kālē, ‘Kāmēētābōōkāsoo ām lēēkitō nto nyēē mā tyaa ātooku subak.’ Ānkulē subak, ‘Āmiitē āyēēyē ꞉anii Kaab Baaba.’ ");
INSERT INTO spyNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ibooru nee ꞉ng'aleechu bo ‘Ām lēēkitō’? ‑Mākiinkētē kiyēē mii kung'āloolēē!” ");
INSERT INTO spyNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yooto kōōnkēt ꞉Yēēsu kule kimāchē ꞉rubiichoo sukuteebee inee ng'aleechaata. Kunyoo kuteebee rubiichooto kule, “So, ōmiitē ōtēēbēē keey kiyēē ibooru ꞉yoo kāāmwooyē kule, ‘Ām lēēkitō, ‑mātōōkāsoo, nto nyēē mā tyaa ātooku subak.’? ");
INSERT INTO spyNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","!Kāāmwoowook, +mōōriiryē ānkōōmēēysē nto yooto kumii ꞉biikaab kōōrooni kung'ērēktōōs. Mākung'woonchook nteenee makuweek ꞉ng'wooninng'woong' kuyēk ng'erekweek. ");
INSERT INTO spyNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yoo sichē ꞉koorko kung'woonchinē, nto yoo kāākusich lakwanyii kuwuutyēē ng'wooninoo kubo ng'erekweekaab leekweet. ");
INSERT INTO spyNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kunyoo, wuu nyooto ām wōlēē ōmiitē akweek. Mākung'woonchook sinee kuu nyiitēnyi, nteenee yoo kakeekas keey subak +moong'erech ng'erekweek chēē mākoy kōōnēmunēēnook ꞉chii. ");
INSERT INTO spyNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Māmii ꞉kiy nyēē +mooteebeenaa kuuyu mākukōōnook ꞉Baaba kiy ake tukul nyēē kooteeb ām kaayneenyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Māmii ꞉kiy nyēē kyooteeb ām kaayneenyuu. Kunyi, oteebee Baaba kiyēē ōmāchē sukuyitita ꞉ng'erekweekwook. ");
INSERT INTO spyNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kāāmwoowunēēnook ng'aleechu keel nyēē iyeelaat, nteenee makuyit ꞉bēsyōōsyēk chēē +māāng'oong'wook wōlēē wuu ꞉ng'aleekaab Baaba. ");
INSERT INTO spyNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","+Mooteeb bēsyoonooto kiy ām kaayneenyuu nyēē mā anii nyēē ātēēbwook. ");
INSERT INTO spyNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chāmook ꞉Baaba, kuuyu kyoochamaa ānkōōchāmchiintōōsii kule kyāāchōōnēē ꞉anii wōlēē mii ꞉inee. ");
INSERT INTO spyNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Āchōōnii kōōrooni, kyāāchōōnēē wōlēē mii ꞉Baaba, nteenee āmiitē āng'ēētēē kōōrooni āyēēyē Kaab Baaba.” ");
INSERT INTO spyNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yooto kumwoochi ꞉rubiik Yēēsu kule, “Kēēmwoowu ra ng'aleek kutook nyēē ‑mēēyēēlē. ");
INSERT INTO spyNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kāākiinkēt nanyuun ra kule inkētē kiy ake tukul nyēē mēērook /tākēēkiiring'. Yēyēēch ꞉yooto kiiyēnchi kule ichōōnēē Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kiwālchi ꞉Yēēsu rubiichoo ām yooto kule, “Kōōyēnchi sōō? ");
INSERT INTO spyNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kaakuyit mbo ꞉bēsyēēt nyēē +mōōsērēētyē ꞉akweek tukul kut wāāng'ētu ꞉anii nkit. Ānkoo kuwuu nyooto, kēēboontē keey Baaba. ");
INSERT INTO spyNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kāāmwoowook ng'aleechu si yoo kōōnoomnyē āk anii ōnyōōru kaalyeet. +Mootang'any ām kōōrooni. Nteenee ōkimkimiitu kuuyu kwāābēl kōōrēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yu kaakoowaany ꞉Yēēsu kumwooy ng'aleechaa, kukas barak ānkumwooy kule, “Baaba, kaakuyit ꞉bārooyinto. Itōrōōroo sikēētōrōriitu ꞉tukwaay. ");
INSERT INTO spyNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Inyiing' ꞉nyēē 'kiikōōnoo kāāmuukēywēēk ām wōlēē mii ꞉biiko tukul sāākoochi biiko choo 'kiikōōnoo *soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Soboontaab kibchuulyo nanyuun ku yoo inkētiing' ꞉biiko Yēyiin nyoo bo man ānkōōnkētoo nkanii Kāārārookiintoonoo kiiyooku. ");
INSERT INTO spyNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kwāātōrōōriing' awaang'te yiisyoonoo kiiyookwoo chaayey. ");
INSERT INTO spyNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kunyoo ii, Baaba, kany āchōō bokiibuurtē keey ꞉tukwaay kēēyēmtooy wōōyinto kuu kēny, kutoombo /keeyey kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kyāāboorchi bichoo kiikōōnoo kāāmuukēywēēkuuk. Ki cheekuuk ꞉bichoo nteenee ikōōnoo. Kookunam ꞉bichooto ng'ālyoontēēng'uung' kuchō āwut. ");
INSERT INTO spyNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kāākōōnkēt ꞉bichoo kule kiy ake tukul nyoo kyaayey kuchōōnēē wōlēē imiitē. ");
INSERT INTO spyNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kyāā-āmchi bichoo lōkōōywēchoo 'kiimwoowoo ankiikutaach. Inkēt nanyuun ꞉bichoo kule āchōōnēē man wōlēē imiitē ānkōōyēnchinē kule inyiing' nyēē kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‑Māāsoochinē biikaab kōōrooni, nteenee āsoochinē choo 'kiikōōnoo, kuuyu cheekuuk ꞉chooto. ");
INSERT INTO spyNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chēē āboontē ku cheekuuk nto choo cheekuuk ku cheechuu. Ātōrōōroot kubo bichoo. ");
INSERT INTO spyNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Āmiitē āchōōnii wōloo imiitē nyēē ‑mēētāābuurē ꞉anii kōōrēēt, nteenee tākumii ꞉bichooto. Wōōy, wēē, Baaba nyēē tiliil! Iriib bichoo ām kāāmuukēywēēk chēē wuu choo 'kiikōōnoo, sukung'eet kunoomnyo ꞉bichooto kuyēk akeenke kuu yoo āyēku akeenke āk inyiing'. ");
INSERT INTO spyNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yoo kyāāboontē keey bichoo, kyāāriib ām kāāmuukēywēēkuuk nyēē mānāābootyo, nteenee kibot ꞉akeenke baateey, nto nyooto ku kāāmukuusiintēēt. Kiyityiin ꞉siruutēk ām kēēlooto. ");
INSERT INTO spyNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Baaba, āmiitē āchōōnii wōlēē imiitē. Nteenee āmwooyē ng'aleechu yoo tāāmiitē kōōrēēt sukunyōōr ꞉bichooto ng'erekweekyuu kuchurta. ");
INSERT INTO spyNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kyāā-āmchi bichoo ng'ālyoontēēng'uung'. Kōōkuwēch ꞉biikaab kōōrooni kuuyu mēēbērē bo ꞉icheek kōōrooni, kuu yoo ‑māābooyē ꞉anii kōōrooni. ");
INSERT INTO spyNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","‑Māāsooyiing' kule inēmu bichoo ām kōōrēēt nteenee āsooyiing' kule iriib bichoo kumaaraanta ꞉Kibrōkōsyoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kubooyiit man, mābo ꞉bichoo kōōrēēt kuu yoo ‑māābooyē ꞉nkanii. ");
INSERT INTO spyNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Itiliil bichoo kōōbuurto manta. Ng'ālyoontēēng'uung' ku manta. ");
INSERT INTO spyNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kuu yoo kiiyookwoo ꞉inyiing' āchōō kōōrēēt, +māāyooktē ꞉nkanii bichooto bokuyey yiisyēēng'uung' ām kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kāānēmu keey kubo icheek sukung'eet kōōnēmchi keey ꞉nkicheek ng'aleekaab manta. ");
INSERT INTO spyNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‑Māāsoochinē rubiik baateey, nteenee āsoochinē biiko choo mākōōyēnwoo kubununēē lōkōōywēkaab rubiichoo. ");
INSERT INTO spyNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Baaba āsooyē kule kuyēk ꞉icheek tukul akeenke ku yoo kēēyēku ꞉acheek tukwaay akeenke. Āsooyē mbo subak kule kuyēk ꞉nkicheek akeenke āk acheek, sukung'eet kōōyēnchi ꞉biiko tukul kule kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kyāākoochi bichoo lēbkēēyyoonoo 'kiikōōnoo sukuyēk ꞉icheek akeenke, kuu yoo āyēku akeenke āk inyiing'. ");
INSERT INTO spyNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yoo āyēku ꞉anii akeenke āk icheek ānku inyiing' ku anii kuchurtooy ꞉kibakeenkeenyoo, sukōōnkēt ꞉biiko tukul kule 'kiiyookwoo ꞉inyiing' ānkiichāmē icheek kuu yoo 'kiichamaa anii. ");
INSERT INTO spyNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baaba! Ābērē nto kākwoonii ꞉bichoo wōloo āchōōnii anii sukung'eet kukas kule ātōrōōroot tōrōōrinto nyoo 'kiikōōnoo, kuuyu kisimichamaa kutoombo /keeyey kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baaba nyēē churtaat! Kimēēnkētiing' ꞉kōōrēēt, nteenee kyāānkētiing' ꞉anii. Kunyi kāākōōnkēt ꞉bichu kule 'kiiyookwoo. ");
INSERT INTO spyNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kyaayey bichu kōōnkētiing', anku +maatas āyēyē kuu nyooto sukung'eet kunam ꞉nkicheek chamateet nyoo iboontēēnoo ānkāābuurtē keey ꞉nkanii icheek.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yu keewaany ꞉Yēēsu kusaay, kwooyyo āk rubiikyii tuybēyēēt ake nyēē /kikēēkuurēē Kiitrōōn ankuba ākoy mbareetaab *musēytuuniinēk nyēē kimii wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kiinkēt ꞉nkinee Yuuta nyoo kichoomtooy Yēēsu mbaraanaa, kuuyu kikicham ꞉Yēēsu kōōmuunyēē wōlooto āk rubiikyii. ");
INSERT INTO spyNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yooto, kuwēēto keey ꞉Yuuta biikaab lukēēt nyēē mining' nyēbo Rooma kutākyinē keey mbaraanaa. Kiboontootē keey mbo riibiikaab kaab *kibkōrōs nyēē wōō ākoo *Farisaayeek. Kikirat keey ꞉bichoo kuyem. Kinamaat kariikwaa, taariinek āk nōmōryēēk. ");
INSERT INTO spyNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kiinkētē ꞉Yēēsu kiy ake tukul nyēē kimii wokuyēyāktōōs. Kuchō taay ankuteebee bichooto kule, “So, ōchēēng'ē ng'oo?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kulē ꞉bichoo, “Yēēsu nyēbo Nāāsārēēt.” Kumwoochi ꞉Yēēsu kule, “Ntēē anii ꞉nyi.” Kimii ꞉Yuuta nyoo kichoomtooy Yēēsu kukēēyyo āk bichooto. ");
INSERT INTO spyNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kumwoochinē ꞉Yēēsu bichoo kule, “Anii ꞉nyooto” kōōtuytuuy ꞉bichoo ānkōōryookyi keey ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kuteebee ꞉Yēēsu subak bichoo kule, “So, ōchēēng'ē ng'oo?” Kuwāl ꞉bichoo kule, “Yēēsu nyēbo Nāāsārēēt.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kumwoochi ꞉Yēēsu kule, “Nto yu kāāmwoowook kule anii ꞉nyooto. Yoo ākoo anii ꞉nyēē ōchēēng'ē, kany kubēēchi keey ꞉murēchu āboontē keey.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kumwooyē ꞉Yēēsu kuu nyooto kuyityiin ꞉yoo kimwooyē kule māmii ꞉rubiintēēnyii mbo akeenke nyēē mākubot. ");
INSERT INTO spyNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yooto, kung'us ꞉Bētērō chōōkiit nyēē kiboonto ankuchwen yiititaab taay nyēbo motwooriintēētaab kibkōrōs nyēē wōō. (/Kikēēkuurēē motwooriintoonoo Māālkō.) ");
INSERT INTO spyNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nteenee kumwoochi ꞉Yēēsu Bētērō kule, “Ibērē ꞉inyiing' tōōs ‑māāchāmē ꞉anii nyalilta nyēē kaakuyeyta ꞉Baaba kule ānyōōru? Ikētyi chōōkiing'uung' kiraaru!” ");
INSERT INTO spyNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kumwoochi ꞉nyēē wōō nyēbo lukēēt biikyii bo lukēēt āk riibiichoo kibo *Kōōtaab Yēyiin kule kunam Yēēsu ankurat. ");
INSERT INTO spyNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yu kaakunam ꞉bichoo Yēēsu kōōmutyi kurook *Anaas nyoo ki boontēētaab biikooy bo Kayaafa. Kayaafa ꞉nyēē ki kibkōrōs nyēē wōō ām kēnyiinooto. ");
INSERT INTO spyNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ki inee ꞉nyēē kiirwookyinē kāāntōōyikaab Yuutayeek kule kaykay kume ꞉chiito akeenke sukusobcho ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yooto koonaamaat ꞉Simōōni Bētērō ākoo rubiintēēt ake, Yēēsu. /Kiinkētoot rubiintoonoo ake ām wōlēē kimii ꞉chiichoo wōō bo kōrōs. Kunyoo, kiiwut ꞉inee kayaata. ");
INSERT INTO spyNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nteenee king'ētunēē ꞉Bētērō saang' yēbo oreetaab tuuytaab kayaata. Kiiyeey lēt ꞉rubiintoonoo ānkumwoochi chēēbto nyēē kiriibē oreet kule koomut Bētērō kuchō āriit. ");
INSERT INTO spyNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kumwoochi ꞉chēēboo Bētērō ām yooto bo oraanaa kule, “Inyiing' oob ꞉rubiintēēt ake nyēbo chiichi?” Kulē ꞉Bētērō, “Ābēērē keey!” ");
INSERT INTO spyNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kikaytit ꞉kwēēmowuunooto ānkimii ꞉riibiik alake ākoo motwoorik alak chēbo kayaata kuywēē āng'oong'tiit kukēēyyoong'iis. Kiwokōōyyoonyēē ꞉nkinee Bētērō yooto ānkuyu āng'oong'tiinoo. ");
INSERT INTO spyNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yooto kulēēnchi *꞉kibkōrōs nyēē wōō Yēēsu, “Mwoowoo baa kurubta keey rubiikuuk āk kāānēētiisyēēng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kumwoochi ꞉Yēēsu kule, “Kyāāmwoowu ng'aleechu kukas ꞉chii ake tukul. Māmii ꞉kiy nyēē kyaawuny ām kāānēētiisyēēnyuu. Kyaaneet biiko ām kooriikaab saayeet āk *Kōōtaab Yēyiin wōlēē kiiruruukyinē keey ꞉Yuutayeek tukul. ");
INSERT INTO spyNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Itēēbēēnoo nyēbo nee? Iteebee biiko choo kikāsē kiyēē kyāāmwooyē. Kubooyiit man, inkēt ꞉bichoo kiyēē kyaamwaay.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Koorabaach ꞉riibiintēēt kumwoochinē kule, “Ing'āloolē kuu nyooto ām taayeetaab *kibkōrōs nyēē wōō?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kulēēnchi ꞉Yēēsu, “Yoo ākoo mii ꞉kiyēē kaamwaay nyēē miyaat imwoowu. Nto yoo ākoo bo man ii, irābookyoo nee?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kumwooy ꞉Anaas kule /kiimut Yēēsu kurataat ākoy kaab Kayaafa, kibkōrōs nyoo wōō. ");
INSERT INTO spyNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kumii ꞉Bētērō kuywēē mayaa, /keeteebee kule, “Inyiing' oob rubiintēēt ake nyēbo chiichiin?” Kutuuch keey ꞉Bētērō kule, “Ābēērē keey.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kimii ꞉chiito ake nyēē ki motwooriintēētaab kibkōrōs nyēē wōō. Kibo ꞉chiichooto areetaab muroonoo kichwēnē ꞉Bētērō yiitit. Kuteebee ꞉motwooriintoonoo Bētērō kule, “So, mā inyiing' ꞉nyoo kēēboontē keey Yēēsu ām mbaraanaa?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kulē ꞉Bētērō subak, “Ābēērē keey.” Kooturkuuch ꞉kirkōōnkiit yooto bakeenke. ");
INSERT INTO spyNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yu kāyyēēkunēē /kiimuustee Yēēsu kaab *Kayaafa, /ānkiirēkēērchi bāytooyiintēēt nyēbo kōōrēētaab Rooma. /Kikēēkuurēē bāytooyiintoonoo *Bilaato. Manaacham ꞉kāāntōōyichoo bo Yuutayeek kōōwut kaytaab bāytooyiintoonoo bo Rooma, kuriib tiliilinng'waa sukutas taay āk *Saakweetaab Keeytaayeet. ");
INSERT INTO spyNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kunyoo, kuchuyta ꞉Bilaato saang' sukung'āloolchi kāāntōōyichoo. Kuteebee kule, “Nee ꞉nyēē koleel ꞉chiichi?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kuwāl ꞉bichoo kule, “Nto kamaleelaat nto kāmākiimutuung'.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kumwoochi ꞉Bilaato bichoo kule, “Bōōkuumu ꞉akweek nkityō kurubta keey kiruutēkwook.” Kulē, “Ntēē ‑/mākēēchāmwēēch kēētilchi chii meet.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kiyityiin ām kēēliitēnyi, ꞉kiyoo kimwooyē ꞉Yēēsu kurubta keey āk wōlēē kimakumeeta. ");
INSERT INTO spyNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Yooto, kooyeey ꞉Bilaato kō. Kukuur Yēēsu ankuteebee kule, “Inyiing' ꞉bāytooyiintēētaab Yuutayeek?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kuwālchi ꞉Yēēsu kule, “Wōlēē isōōtitooy ꞉inyiing' nkit nto wōlēē mwooytoowuung' ꞉biiko?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kuwālchi ꞉Bilaato Yēēsu kule, “Yoo 'keekas, āyēku ꞉anii Yuutāyiin sōō? Māku biikwook āk mbo kibkōrōs ꞉chēē kākwēruung' ichōō wōli āmiitē. Kiy nee nyēē 'kweeyey ꞉inyiing'?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yooto, kumwooy ꞉Yēēsu kule, “Mābo ꞉bāytooyiisyēēnyuu kōōrooni. Nto kābo kōōrooni, nto kookwaam ꞉rubiikyuu booryēēt kuyeeta simanama ꞉kāāntōōyichoo bo Yuutayeek. Māchōōnēē ꞉bāytooyiisyēēnyuu kōōrooni!” ");
INSERT INTO spyNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kuteebee ꞉Bilaato Yēēsu kule, “Kunyi ākoo iyēku sōō, bāytooyiin?” Kulēēnchi ꞉Yēēsu, “Inyiing' ꞉nyēē 'keemwaay. /Kikēēsicho kule chaaneet biiko ng'ālyoontēētaab man nyēbo Yēyiin. Kiyooto ꞉nyēē kiyeya sāāchōō kōōrooni. Chii nyēbo man kukāswoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kuteeb ꞉Bilaato kule, “Manta ꞉nee?” Yooto, kung'eet ꞉Bilaato ānkuwo saang' subak wōlēē kimii ꞉Yuutayeechaa ānkumwoochi kule, “Lēyyē, ntēē ‑māākāsē lēēlis nyēē boonto ꞉chiichi! ");
INSERT INTO spyNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nteenee kurubta keey ākoo ātēbuutēkwook, kwāātyooktoowook kwaak kibratyaa akeenke ām kēnyiit yoo ōmiitē saakweeng'woong' bo Keeytaayeet. Ara ōmāchē ātyooktoowook bāytooyiintooni bo Yuutayeek?” ");
INSERT INTO spyNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kubōloobōlchi ꞉bichoo barak kule, “Ityaakte Baraaba.” /Kikikeenam Baraaba /ankeerat kuuyu ki ꞉chii nyēē ki kāwōōtyoo. ");
INSERT INTO spyNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yooto nanyuun kōōkooyto *꞉Bilaato Yēēsu /kēēbirsēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kitaay ꞉biikaab lukēēt nkwaatyeetaab kātook kookerkeeyee nyoo bo bāytooyiisyēēt ānkōōlookyi mētitaab Yēēsu. Kōōlookyi subak sireet nyēē arraa kookerkeeyee nyoo bo bāytooyiisyēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Yu kāākuyityo, kōōliichi keey ꞉bichoo bo lukēēt Yēēsu sukumwoochinē kule, “Kimkim, bāytooyiintēētaab Yuutayeek!” Kimwoochinē kuu nyooto ānkōōrāboochē. ");
INSERT INTO spyNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kiwo ꞉Bilaato saang' subak wōloo kimii ꞉Yuutayeechaa ānkumwoochi kule, “+Māākwēryoonu chiichi kuchō saang', sōōnkēt kule māmii ꞉kiy nyēē miyaat nyēē ākāsē kule koyey.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","/Kēēkwēryoon Yēēsu kuchō saang' wōlēē kimii ꞉bichoo. /Kikiilookyi nkwaatyaanaa bo kātook mēt āk siraanaa ki arraa. Kumwoochi ꞉Bilaato bichoo kule, “Ong'nyi chiing'woong'.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yu kakas ꞉mbo kibkōrōs chēē wōōyēch āk riibiikaab *Kōōtaab Yēyiin Yēēsu, kubōloobōl kule, “Obakach! Ōkwērtoochi *murtooywoontēēt. Obakach.” Kutay ꞉Bilaato. Kimwoochi kule, “Obeete ꞉akweek nkit bōōkwērtoochi murtooywoontēēt. ‑Māākāsē ꞉anii kiy nyēē miyaat nyēē kookuyey ꞉chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kōōkiimchi ꞉Yuutayeechaa kumwooyē kule, “Kikuur keey ꞉chiichi kule inee ku Lakwataab Yēyiin, ng'ālyoo nyēē mwooyē ꞉kiruutēkyoo kule nyoolchinē chii nyēē kayey kuu nyoo kume.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kiinyokoorta ꞉yooto Bilaato miisin. ");
INSERT INTO spyNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kuketita Yēēsu kuwo kō ankuteebee kule, “Ibooyē ānō ꞉inyiing'?” Kusiisyi keey ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kumwoochi ꞉Bilaato Yēēsu kule, “‑Mēēmāchē ing'āloolwoo? ‑Mēēnkētē kule āboontē kāāmuukēywēēk atyaaktiing' nto āmwoochi biikyuu bo lukēēt kubākākyiing' murtooywoontēēt?” ");
INSERT INTO spyNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kuwālchi ꞉Yēēsu kule, “Kāmēēboontē kāāmuukēy ibakachaa nto kāmānāākōōning' ꞉Yēyiin. Kunyoo, chiito nyēē kēēyokoowoo āchōō wōlēē imiitē ꞉nyēē leelaat kusiiring'.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yooto, kusyeem ꞉Bilaato kēēlto nyēē keetyaaktee Yēēsu nteenee kubōloobōl ꞉biiko kule, “Yoo 'keetyaakte chiichoo, kōōbooru kule ‑mēēkāsyiintōōsii āk bāytooyiintēēt nyēē wōō. Chii nyēē yēyē keey kule inee bāytooyiintēēt kukwiilē bāytooyiintoonoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Yu kakas ꞉Bilaato ng'aleechaa, kumwoochi biikyii bo lukēēt kukwēryoot Yēēsu saang' subak ānkōōbuurēē ng'echereenyii nyēē irwoochēē ām yēē /kikēēkuurēē Rwaanteet Komos. (Ām kuutiitaab Yuutayeek /kēēkuurē kule ‘Kabaata.’) ");
INSERT INTO spyNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kimii ꞉taman āk āyēēng' nyēbo kōrrōōn. Ki bēsyēētaab chōbātēētaab Sabaato ꞉nyooto kutāsē taay *꞉Saakweetaab Keeytaayeet. Yooto kumwoochi ꞉Bilaato bichoo kule, “Ong'nyoo bāytooyiintēēng'woong'.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nteenee kubōloobōl ꞉bichoo subak kumwooyē kule, “Owaang'te, obakach, obakach.” Kuteebee ꞉Bilaato bichooto kule, “Ākwērtoochi bāytooyiintēēng'woong' murtooywoontēēt?” Kulē ꞉mbo kibkōrōs chēē wōōyēch, “Bāytooyiintēēnyoo acheek ku nyoo bo Rooma nkit āmāmiitē ꞉ake!” ");
INSERT INTO spyNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yooto kōōyokoochi ꞉Bilaato bichoo Yēēsu, /subokēēbākākyi murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yooto nanyuun, /kēēriiboot Yēēsu. /Kikēēkērchi koong' Yēēsu kukalab murtooywoontēēt, /ankeebeeta ākoy yēēt ake yēē /kikēēkuurēē ‘Rōkyēētaab mēt’. (Ām kuutiitaab Yuutayeek /kikēēkuurē kule ‘Kolkoota’.) ");
INSERT INTO spyNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","/Kibokēēkwērtoochi Yēēsu murtooywoontēēt. /Kikēēkwērtoochi nkicheek sāsiik alak āyēēng' murtooywōōsyēkwaa ānkiiyyoong'tēē ake āwutaab taay nyēbo Yēēsu nto nyiin ake kiiyyoong'tēē nyēbo kaataam. ");
INSERT INTO spyNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kimwooy ꞉Bilaato kule /kēēsirchi ng'aleek baawuut /ānkēēkwērtoochi baawuunaa murtooywoontēētaab Yēēsu yoo bo barak. Kimwooyē kule: YĒĒSU ꞉NYĒBO NĀĀSĀRĒĒT BĀYTOOYIINTĒĒTAAB YUUTAYEEK. ");
INSERT INTO spyNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","/Kikeesiree ng'aleechaa kuutuweek sōmōk. Kuutiit nyēbo Yuutayeek, nyēbo biikaab Rooma āk nyēbo Kirikiik. Kisuman ꞉biiko chēē chaang' ng'aleechaa kuuyu kilēēkitēē Yēērusālēēm ꞉yooto /kikēēkwērtoochinē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kimwoochi ꞉mbo kibkōrōs chēē wōōyēch Bilaato kule, “‑/Makeesir kule ‘Bāytooyiintēētaab Yuutayeek’ nteenee /keesir kule ‘Chiichi nkit ꞉nyēē kikuur keey kule inee bāytooyiintēētaab Yuutayeek’.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kulē ꞉Bilaato, “Kiyēē kaasir, kukaasir!” ");
INSERT INTO spyNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yu kāākukwērtoochi ꞉biikaab lukēēt Yēēsu murtooywoontēēt, kubchēchi keey sirookaab Yēēsu chuut ang'wan. Nteenee kibakaakta sireet nyoo kibo āriit nyēē ki ankeet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nto yityo, kumwoochi keey kule, “‑Mookany keekereer siraani. Kaykay /keebar *sēkēēryēēt sukutook kule ng'oo ꞉nyēē mākuchurtoochi.” Kiyityiin ꞉yooto āk yoo /kikeesir ām siruutēk kule, “Kibchēchiin sirookyuu ānkubārchi kābuutiinyuu sēkēēryēēt sukōōnkēt chiito nyēē mākuyib.” Kumii ꞉bichoo bo lukēēt kumooytōōs siroochoo bo Yēēsu, ");
INSERT INTO spyNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","kimii ꞉kaametiitaab Yēēsu kēēyyoonyēē yēē kilēēkitēē murtooywoontēēt ānkiboonto keey cheebkaamet. Kimii ꞉nkinee Maaryaa cheebyoosyeetaab Kilooba ākoo Maaryaa nyēbo *kiriinkēētaab Maktaala. ");
INSERT INTO spyNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kuweech keey ꞉Yēēsu kukas kaamet ankukas subak rubiintēēnyii nyoo kichāmē ānkumwoochi kaamet kule, “Moomo, wēring'uung' ꞉nyoo.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kumwoochi nkinee rubiintoonoo kule, “Murooni, koomēt ꞉nyoo.” Kung'eetee yooto kiwokōōbuurto keey ꞉rubiintoonoo cheebyoosyaanaa. ");
INSERT INTO spyNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kōōnkēt ꞉Yēēsu kule kikiikoowaany kiy ake tukul nyoo kimākyinē ꞉Yēyiin kule chokuyey. Yooto, kumwooy kule, “Kaakwaama ꞉melelta.” Kiityiich ꞉yooto subak siruutyēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kimii yooto ꞉kiy nyēē kimii *꞉tifaayiik chēē tāytāy. Kunyoo /keenam kiroonkuryēēt /ankiiluumta tifaayiichaa, nto yityo /kēēnoonkuchi kēētit ake /ānkiiyokooyto kutiiny kuutiinyii. ");
INSERT INTO spyNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yu kachuuchun ꞉Yēēsu tifaayiichaa, kumwooy kule, “Kaawaany.” Yooto nanyuun, kurankach ꞉kaatit ankung'et. ");
INSERT INTO spyNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ki bēsyēēt nyooto nyēē /kikēēyēytēē keey kubo bēsyēēt nyēē wōō bo *Sabaato. Kunyoo, kimāmāchē ꞉kāāntōōyikaab Yuutayeek kule kōōkārtootākiis ꞉bichoo ām murtooywōōsyēchoo ākoy bēsyēētaab Sabaato. Yooto kusoom ꞉kāāntōōyichoo Bilaato kumwaayta /kyiiri kērēēnkōōkaab bichoo sukubēk areet akeenke /ānkiirēēk ām murtooywōōsyēchoo. ");
INSERT INTO spyNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yooto kuba ꞉biikaab lukēēt ānkwiiri kērēēnkōōkaab chiitaab taayta āk chēbo nyiin ake, choo /kikēēkwērtoochinē murtooywōōsyēk āk Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nteenee yu kāyityi ꞉bichoo Yēēsu ankukas kule kaakume, mānāā-iri kērēēnkōōk. ");
INSERT INTO spyNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kunam ꞉chiito ake nyēbo lukēēt ng'otinyii ānkubusuyēē Yēēsu mooyēēt komos. Kikwaanee yooto ꞉korotiik āk bēēko. ");
INSERT INTO spyNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Chiito nyēē rāru ng'aleechu, ku ꞉nyēē kikāsē kuyēyāktōōs ānkōōnkētē kule bo man. Rāru ng'aleechu sukung'eet ochamte ꞉nkakweek. ");
INSERT INTO spyNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kiyey ꞉yooto kuyityiin ꞉siruutyēēt nyoo mwooyē kule, “Māmii ꞉koowēēnyii mbo akeenke nyēē +/mākēē-iri.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kiyityiin subak ām siruutēkaab Yēyiin ꞉yēē mwooyē kule, “Makukas ꞉biiko chiichi /kākēēbusuy.” ");
INSERT INTO spyNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kimii ꞉chiito ake nyēē /kikēēkuurēē ꞉Yōōsēēf nyēbo Arimataaya. Ānkoo ki rubiintēētaab Yēēsu ꞉chiichoo, kiiyēēlē keey kōōywēyē kāāntōōyikaab Yuutayeek. Kiwokusoom ꞉chiichoo Bilaato kuchāmchi kuyib muustaab Yēēsu. Kuchāmchi ꞉Bilaato wokōōnēm muustaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kiwēēto keey Nikōtēēmō nyoo kichokukāsē Yēēsu kwēēmowuut ake. Kikinamaat ꞉Nikōtēēmō tukuuk chēē boong'u nyēē anyiny chēē kiyitē kiilōōnik sosom. ");
INSERT INTO spyNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kibeeta ꞉bichoo āyēēnku ankeet ankuratee muustaab Yēēsu kumii ꞉tukuuchoo boong'u nyēē anyiny, kurub kuu wōloo kiyēytooy ꞉Yuutayeek yoo /kēēmuyē chiito. ");
INSERT INTO spyNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kimii ꞉kochonkeet nyēē /kikēēmuchinē biiko yooto /kikēēbākākyinē Yēēsu nyēē /kimānāākēēmuchi chii. ");
INSERT INTO spyNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","/Kikēēmuchi Yēēsu kochonkaanaata kuuyu kilēēkitēē yooto /kēēsārchinē simānyōōryo āk bēsyēētaab *Sabaato nyēē kimii kuyitu. ");
INSERT INTO spyNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ām bēsyēētaab taayta, nyēē kirubē bēsyēētaab *Sabaato, kumusta ꞉Maaryaa nyēbo Maktaala kukēērir ꞉kōōrēēt ānkuwo ākoy kochonkaanaa. Bērē kulē, /kikiikēēwunukto rwaantaanaa /kikikeekeree kurkeetaab kochonkaanaa. ");
INSERT INTO spyNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yu kakas kule kimāmii ꞉muustaab Yēēsu yooto, kooyeey areet akeenke. Kiwokunyōōr Simōōni Bētērō ākoo rubiintoonoo kichāmē ꞉Yēēsu ānkumwoochi kule, “Tōōbērē ꞉akweek, /kōōkēēyib muustaab Mokoryoontēēt ām kochong' āmākiinkētē wōlēē /kōkēēyib.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yooto kulabat ꞉Bētērō āk rubiintoonoo ake kutākyi keey kochonkaanaa. ");
INSERT INTO spyNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Koong'weentee ꞉rubiintēēt nyiin ake Bētērō ānkuyēk nyēbo taay kuyit kochong'. ");
INSERT INTO spyNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yu kayit yooto kuyim, nto bērē kulē, kukāsyi kochong' ankaanaa /kikikeeratee Yēēsu, nteenee mānāākōōwut kochong'. ");
INSERT INTO spyNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kuyitu ꞉Bētērō ānkuchokukēēytooy ākoy kochong'. Yooto, kukas ꞉nkinee ankaanaa āmāmii ꞉bōōrto. ");
INSERT INTO spyNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kikas mbo ankeet nyoo /kikikeeratee mētitaab Yēēsu kukakyaaruny ānkiikoochi komos yēē kimālēēkitēē ꞉nyiin ake. ");
INSERT INTO spyNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kuwo kochong' ꞉nkinee rubiintoonoo kisimkuyitu yooto. Kukas ankoosyechaa ānkōōyēnchi kule ākoo man kaakung'eetee ꞉Yēēsu meet. ");
INSERT INTO spyNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ākoy yooto kitoombo kōōnkēt ꞉bichoo kiy ām yoo kimwooyē ꞉siruutēk kule makung'eetee ꞉Yēēsu meet.) ");
INSERT INTO spyNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yu kāākuyityo, kooyeey ꞉rubiichoo kaa. ");
INSERT INTO spyNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nteenee kikiikooyeey ꞉Maaryaa ākoy kochong' ānkimii kēēyyo saang' kuriirē ānkuyimē kōōkōōytooy kochong'. ");
INSERT INTO spyNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nto bērē kulē, kukāsyi malayikaanik āyēēng' kochong' chēē kikiilaach sirook chēē kileelach kule mang'. Kikiibuurēē ꞉ake mētēw ām yoo kimii ꞉muustaab Yēēsu kōōbuurēē ꞉nyiin ake kāābkēēlyē. ");
INSERT INTO spyNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yooto, kuteebee ꞉malayikaanichaa cheebyoosyaanaa kule, “Iriirchinē nee ōō, cheebyoos?” Kulē, “Kaakubeeta ꞉biiko alake Mokoryoontēēnyuu āmāānkētē wōlēē kābokōōkoochi!” ");
INSERT INTO spyNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nto bērē kuweech keey, kukas Yēēsu nyēē kēēyyoonyēē yooto, nteenee kimēēnkētē kule ki inee ꞉nyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kuteebee ꞉Yēēsu kule, “Iriirchinē nee ōō, cheebyoos? Ānku ng'oo ꞉nyēē imiitē ichēēng'ē?” Kibērē ꞉cheebyoosyaanaa tōōs ki ꞉chiitaab mbareet ꞉nyooto. Yooto, kumwoochi kule, “Boontēēt, yoo ākoo inyiing' nyēē 'kēēnēmu, imwoowu wōlēē kāwēēkoochi siwāāyib.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kulēēnchi ꞉Yēēsu, “Maaryaa.” Kiirōōtoot ꞉cheebyoosyaanaa Yēēsu ānkumwooy ām kuutiitaab Yuutayeek kule, “Rābōōni!” (Kerkeey ꞉yooto ākoo yoo /kakeemwa kule ‘Kāānēētiintēēt’.) ");
INSERT INTO spyNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kimwoochi ꞉Yēēsu cheebyoosyaanaa kule, “Keekas ii, chēē, ‑mēēyēētyoo keey, kuuyu tāku toombo āwē Kaab Baaba. Kiyēē +meeyey ku iwē wōlēē mii ꞉rubiikyuu ānkiimwoochi kule, āmiitē āyēēyē wōlēē mii ꞉Baaba nyoo Kwaan nkicheek. Yēyiintēēnyuu ānku Yēyiintēēng'waa nkicheek.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kuwo ꞉Maaryaa kuu yoo /kākēēmwoochinē ānkumwoochi rubiik kule, “!Kaakas ꞉anii Mokoryoontēēt!” Yooto kumwoochi icheek kiy ake tukul nyoo kāmwoochinē inee ꞉Mokoryoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nto bēsyoonooto kosolēny, kōōruruuch keey ꞉rubiikaab Yēēsu ankukerta keey kō, kuuyu kitākunyōkōōrēch kāāntōōyikaab Yuutayeek. Kutookunēē ꞉Yēēsu areet akeenke yooto kimii ꞉icheek ānkulēēnchi, “Ōbuurtē kaalyeet.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nto yityo, kōōboorchi bichoo āwunnyēk wōloo kichutē ꞉musumaariit ākoo mooyēēt komos wōloo /kikēēbusuyē. King'ērēkiis ꞉rubiik miisin yu kēēnkēt kule ākoo ki Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yooto kumwoochi subak kule, “Ōbuurtē kaalyeet. Kuu yoo kiiyookwoo ꞉Baaba, āyooktook ꞉nkanii.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kōōbuusyi rubiichoo muuyēēt kumwoochi kule, “Ōnyōōru Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yoo kōōnyōōchi biiko kaat ām ng'ōōki nyēē kiikuyey, kunyōōchinē ꞉Yēyiin bichoo kaat, nto yoo kāmōōnyōōchi kaat, ‑/mākēēnyōōchinē kaat.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kunyōōru ꞉Yēēsu rubiik chuut alak, kimāmii ꞉Toomaas, (nyēē /kikēēkuurē ām kaayneet ake kule Kibsārāmiin). ");
INSERT INTO spyNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yu kāwokuchō ꞉Toomaas, kumwoochi ꞉rubiik chuut kule, “!Kaakeekas ꞉acheek Mokoryoontēēt.” Nteenee kimwoochi icheek kule, “Ākoy akas yoo /kikiilōōtunēē musumaariinechaa nto āchāmē. Nto subak, ākoy ātiinyēē āwut yoo bo mooyēēnyii komos saacham.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yu kakeeyta ꞉bēsyōōsyēk sisiitu, kōōruruukyi keey ꞉rubiichoo kōyoo kikaayi kuboonto keey Toomaas. Ānkoo kikērootiin ꞉kurkootik /kibokiiyiinēē kāākōōyyoonyēē ꞉Yēēsu yooto. Kimwoochi kule, “Ōbuurtē kaalyeet.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nto mii yoo kuwēēkyi keey Toomaas ānkumwoochi kule, “Toomaas, chēētiinyēē moorineeng'uung' āwunnyēk ānkiitiinyēē mooyēēnyuu komos āwung'uung'. ‑Mātēēwiiywiiy nteenee iyēnchi.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kumwoochi ꞉Toomaas kule, “Lēyyē, inyiing' ꞉Mokoryoontēēnyuu ānku inyiing' ꞉Yēyiintēēnyuu.” ");
INSERT INTO spyNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kumwoochi ꞉Yēēsu kule, “So, Toomaas, ākoy ikasaa siikaaseenaa keey? Ibēruurootiin kule nee sōō ꞉biich choo ikoosēēnoo keey ānkoo manaakasa!” ");
INSERT INTO spyNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kiyey ꞉Yēēsu ng'al alak chēē chaang' chēbo kwōng'uut kuboonto keey rubiikyii. Māsirootiin ꞉ng'aleechaata ām kitaabuuni. ");
INSERT INTO spyNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nteenee /kikeesir ng'aleechu, soochamte kule *Kāārārookiintēēt ꞉Yēēsu anku Lakwataab Yēyiin, nyēē yoo kookaasee keey, +mōōnyōōru soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nto mii yoo, kōōboorchi keey ꞉Yēēsu subak rubiikyii alak chēē kimii yoo bo Tōōliilēētaab Tibeerya. ");
INSERT INTO spyNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Rubiichooto ku: Simōōni nyoo /kikēēkuurēē Bētērō, Toomaas Kibsārāmiin, Nāātānnyēēl nyoo bo Kaana ām Kalilaaya, wērikaab Sebetaayo āk rubiik alak āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kumwoochi ꞉Bētērō chuut kule, “Murēchu, +mawaatechaate ꞉anii burburiinēk.” Kulē ꞉chuut, “Keebeete keey tukul.” Yooto kulaany ꞉bichoo mwēēnkēēt ānkubokutēkiis. Nteenee manaanam kiy kwēēmowuunooto. ");
INSERT INTO spyNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nto yu mākumwook ꞉asiista, kimii ꞉Yēēsu kēēyyoonyēē sakaramteet, nteenee kimēēnkētē ꞉rubiik kule ki inee ꞉nyooto. ");
INSERT INTO spyNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yooto kukuurchi ꞉Yēēsu bichoo kule, “Wērikēy, manoonam burburyoo?” Kuwāl ꞉chuut kule, “Wooneet!” ");
INSERT INTO spyNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kumwoochi ꞉Yēēsu kule, “Ōwiirchi nēētiit kusyeb āwutaab taay nyēbo mwēēnkēēt. +Moonamee yooto burburiinēk.” Yooto kuwiirchi ꞉bichoo nēētiit tōōliil. Nto bērē kōōchuut, kimēētākōōmuuchē kuuyu kikiikunam burburiinēk chēē chaang' miisin. ");
INSERT INTO spyNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","8","Yooto, kumwoochi ꞉rubiintoonoo kichāmē ꞉Yēēsu Bētērō kule, “Mokoryoontēēt ꞉nyooto!” Kusirinyē ꞉Bētērō sireenyii bakeenke ankumootee keey kābuutiit ānkōōroonchinē tōōliil sukuriiboot nēētiit. Kimā lōō ꞉yooto ām sakaramteet nteenee kimāchē kuyitē miitaanik bokol akeenke. /Kikiirēētoot mwēēnkēēt ākoy sakaramteet kōōchuutootē nēētiit nyēē kikinyiy ꞉burburiinēk. ");
INSERT INTO spyNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yu kāng'ēētyēē ꞉bichoo tōōliil, kukas āng'oong'tiit nyēē king'āsyānē. Kimii ꞉mukaatiinek yooto ākoo burburyoontēēt nyēē kiwaatanaat. ");
INSERT INTO spyNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kumwoochi ꞉Yēēsu bichoo kule, “Ōyibu baa, burburiinēchoo alak choo kātōōnāmē.” ");
INSERT INTO spyNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kōōchuutoon ꞉Bētērō nēētiinoo kikiikunyiy ꞉burburiinēk chēē wōōyēch ākoy sakaramteet. Kiyitē ꞉burburiinēchoo bokol akeenke āk konom āk sōmōk. Ānkoo ki chaang' ꞉burburiinēchoo nyēē tyaa, mānāāng'ēti nēētiit. ");
INSERT INTO spyNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kumwoochi ꞉Yēēsu rubiichoo kule, “Boochur kuut.” Kisēw ꞉rubiik kule ki Mokoryoontēēt. Kinyōkōriitu kuteebee kule inee ku ng'oo. ");
INSERT INTO spyNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yu kāākōōbuur, kōōnēm ꞉Yēēsu mukaatiinek āk burburyoontoonoo ānkubchēchinoot rubiichooto. ");
INSERT INTO spyNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nyēbo sōmōk ꞉nyiitēnyi kōōboorchinē keey ꞉Yēēsu rubiikyii kuchakee yoo king'ēētēē meet. ");
INSERT INTO spyNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yu kāākwoomiis, kuwēēto ꞉Yēēsu Bētērō komos ankuteebee kule, “Simōōni araab Yoowaana, ichāmoo ꞉inyiing' man kusiir wōlēē chāmtoo ꞉chuut?” Kuwālchi ꞉Simōōni Yēēsu kule, “Inkēt ꞉inyiing' ōō, Mokoryoontēēt kule āchāmiing' ꞉anii.” Kumwoochi ꞉Yēēsu kule, “Ikēēmē kuuchiikyuu.” ");
INSERT INTO spyNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kumwoochi ꞉Yēēsu Bētērō nyēbo āyēēng' kule, “Simōōni araab Yoowaana, ichāmoo ꞉inyiing' man?” Kuwālchi ꞉Bētērō kule, “Inkēt ꞉inyiing' ōō, Mokoryoontēēt kule āchāmiing' ꞉anii.” Kumwoochi ꞉Yēēsu kule, “Iriib kēēchiirēkyuu.” ");
INSERT INTO spyNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kumwoochi ꞉Yēēsu subak Bētērō nyēbo sōmōk kule, “Simōōni araab Yoowaana, ichāmoo ꞉inyiing'?” Yooto kung'woonchi ꞉Bētērō kuuyu kateeb ꞉Yēēsu areet sōmōk kule, “Ichāmoo ꞉inyiing'?” Kiwālchi ꞉Bētērō Yēēsu kule, “Mokoryoontēēt, nto yu inkētē ꞉inyiing' kiy ake tukul. Inkētē kule āchāmiing' ꞉anii.” Kuwālchi ꞉Yēēsu kule, “I-ake kēēchiirēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","!Kāāmwoowuung', yoo kiimining', 'kiisirinyē sireeng'uung' ankiimoot keey ānkiiwē wōlēē 'keecham. Nteenee yoo 'keeyoosiitu, +/mākēēkērchiing' koong' itōrōōr āwunnyēk, kusiring'uung' ꞉chiito ake sireeng'uung' ānkumōōtuung', nto yityo kuyibing' wōlēē ‑mēēmāchē.” ");
INSERT INTO spyNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kimwooy ꞉Yēēsu kuu nyooto kōōbooru meet nyēē kimākunyōōr ꞉Bētērō sukōōtōrōōrākoy ꞉Yēyiin. Nto mii yoo, kumwoochi ꞉Yēēsu Bētērō kule, “Irubwaa.” ");
INSERT INTO spyNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nto bērē kulē ꞉Bētērō, kumii ꞉rubiintoonoo kichāmē ꞉Yēēsu kuwēētii wōlēē miitē ꞉icheek. Rubiintoonoo nyoo kitiing'tooy keey Yēēsu ām bēsyoonoo /kikyoomiisyē sukutēēbēē Yēēsu kule, “Mokoryoontēēt, ng'oo ꞉nyēē makuchaamtiing'?” ");
INSERT INTO spyNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yooto kuteebee ꞉Bētērō Yēēsu kule, “Mokoryoontēēt, nto murooni?” ");
INSERT INTO spyNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kuwālchi ꞉Yēēsu kule, “Yēētyēēchiing' nee nto kāālē ꞉anii kuminy ꞉murooniitēnyi ākoy bēsyēēt nyēē āchōōnēē ꞉anii? Irubwaa ꞉inyiing' kityō.” ");
INSERT INTO spyNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lētuunoo kuyityi ꞉ng'aleek wōlēē kimii ꞉biikaab Kiriistō, kule ng'aleechaa kimwooyē ꞉Yēēsu kiibooru kule mēēbērē makume ꞉rubiintoonoo kichāmē ꞉Yēēsu. Nteenee mēēbērē kikimwooy ꞉Yēēsu kule māmēē ꞉chiichoo. Kimwooy buch kule, “Yēētyēēchiing' nee nto kāālē ꞉anii kuminy ꞉murooniitēnyi ākoy bēsyēēt nyēē āchōōnēē ꞉anii?” ");
INSERT INTO spyNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Rubiintooniitēnyi nyoo kimwoowu ng'aleechu, ānku inee ꞉nyi kisirē ng'aleechu. Kiinkētē ꞉acheek kule bo man ꞉kiyēē kimwooy. ");
INSERT INTO spyNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Lēyyē, chaang' ꞉ng'aleek miisin chēē kiyey ꞉Yēēsu. Nto /kikikeesir ng'aleechaa tukul, nto kiinyiitē ꞉kitaabuun kōōr kumukuul!");
INSERT INTO spyNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Boontēēt Tēyōfiilō, ām kitaabuunyuu nyoo kibo taay, kyaasir ng'aleek tukul chēē rubtooy keey ākoo kiyēē kitoow ꞉Yēēsu kuyey ankooneet ");
INSERT INTO spyNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ākoy bēsyēēt nyoo /kikēēyibēē kuwo kibkōōnkōy. Kiirwookyinē *lēbkēēyikyii choo kikiikukwey ām kāāmuukēywēēkaab Tāmirmiryēētaab Yēyiin, yooto kumānāāwēētii kibkōōnkōy. ");
INSERT INTO spyNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yu kāwokung'eetee meet, chokōōboorchi keey lēbkēēyikyii ānkōōbuur ām bēsyōōsyēk artam. Kiiboorchi tukuuk chēē chaang' chēē sukuyey lēbkēēyichoo kuchamta kule kisoboot ꞉inee. King'alaalee tukuuk chēē rubtooy keey ākoo bāytooyiisyēētaab Kaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nto mii bēsyēēt ake, kumii ꞉Yēēsu kwoomē lōkōōy ākoo lēbkēēyichoo, kōōkāloonchi icheek kule, “‑Moong'eetee Yēērusālēēm, nteenee okany ākoy /kēērōōbwook Tāmirmiryēētaab Yēyiin kuu yoo kikiikukuurto ꞉Baaba. Kikyāā-āmwook ng'ālyoontoonoo. ");
INSERT INTO spyNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kiibātisāniisyēē ꞉Yoowaana bēēko, nteenee ām bēsyōōsyēk chēē ng'ēri +/makeebatisaneenaak akweek Tāmirmiryēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kuboonto keey ꞉Yēēsu lēbkēēyichoo, kuteebee ꞉lēbkēēyik kule, “Mokoryoontēēt, ara imiitē sōō, ra wēētyooktēēch acheek biikaab *Isrāyēēl ankiibayteech?” ");
INSERT INTO spyNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kukētyi ꞉Yēēsu kule, “Yēyiin nkit ꞉nyēē bāwu ng'aleechaa. Māmākyook ōnkēt kule mākuyēk āyu. ");
INSERT INTO spyNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nteenee, +mōōnyōōru kāāmuukēywēēk yoo kāchōōnchook ꞉Tāmirmiryēētaab Yēyiin. +Mōōmwoowu ng'aleek chēē rubtooy keey āk anii ām Yēērusālēēm, Yuuteeya, Samaaryaa ākoy komoswookik tukul chēbo kōōrēēt.” ");
INSERT INTO spyNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yu keewaany ꞉Yēēsu kumwooy ng'aleechu, /kēēyib kuwo kibkōōnkōy kukāsē ꞉lēbkēēyik. Kiker ꞉boolteet Yēēsu kōōtōōchootē kut wokoong'irta. ");
INSERT INTO spyNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kimii ꞉lēbkēēyichoo kōōnyālē barak kubērē nto kas Yēēsu, nto bērē kuweech keey kukas biiko alak āyēēng'. Kikiilaach ꞉bichoo sirook chēē leelach ānkēēyyoonyēē komos ām yoo kimii ꞉icheek. ");
INSERT INTO spyNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kumwoochi ꞉bichoo lēbkēēyichoo kule, “Murēchu bo Kalilaaya, ntēē kōōyyoong'iisyē yu ōkāsē barak? Mākōōyēēw ꞉Yēēsu ām kēēlto nyēē wuu nyooto /kākēēyibēē.” ");
INSERT INTO spyNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nto mii yoo, kung'eetee *꞉lēbkēēyichoo yēē kibo Lekemeetaab *Musēytuuniinēk ankooyeey ākoy Yēērusālēēm. Kitēē ꞉baani nyēē /kēēchāmu /keebeesyet ām bēsyēētaab *Sabaato. ");
INSERT INTO spyNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yu kayit wōlooto, kuba koroofa wōloo kiibuurunēē. Lēbkēēyichooto ku: Bētērō, Yoowaana, Yāākōbō, Antereeya, Filibō, Toomaas, Baatolomaayo, Mataayo, Yāākōbō araab Alfaayo, Simōōni nyēē kāng'unoot ākoo Yuuta araab Yāākōbō. ");
INSERT INTO spyNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kituuytōōs kibtaman ām wōlooto kusooyē ꞉tukul ku kiito akeenke. Kiboonto keey āk chēēbyōōsōōk alak āk Maaryaa kaametiitaab Yēēsu āk mbo ng'eetaabkaamet. ");
INSERT INTO spyNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nto mii bēsyēēt ake kung'eet ꞉Bētērō ām kwēēnuutaab rubiik bokol akeenke āk tibtēm ");
INSERT INTO spyNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ānkumwoochi kule, “Mbo ng'eetaabiya, ki ākoy kuyityiin ꞉siruutēchu bo Yēyiin kuu yoo kimwooyē ꞉Tāmirmiryēētaab Yēyiin kubununēē *Tāwuti, kurubta keey Yuuta nyoo kikwēryoonu biiko bokunam Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ki Yuuta akeenke ām acheek ānkikēēyēyiisyootē tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","20","/Kikeesir ām Kitaabuutaab Tyēēnwookik kule, ‘Kumuskēn ꞉kanyii ānkuyēk kiraatyaa!’” (Boontēēt Tēyōfiilō, kinyōōr ꞉Yuuta beesaanik ām rōkōsoo kiyēyē. /Kikyaalee beesaanichaa mbareet. Wōlooto bo mbaraanaata ꞉wōlēē kiryooktoochinē keey kuwēētēē mēt ānkōōtōl ꞉mooyēēt kuruuyo ꞉kosurēēkyii saang'. Kikas ꞉chii ake tukul ām Yēērusālēēm ng'aleechu. Kunyoo, /kikēēkuurēē mbaraanaa ‘Ākēl Taama’ nyēē ibooru kule ‘Mbaraab koroti’.) Kitas taay ꞉Bētērō kumwooy kule, “/Kikeesir mbo subak kule, ‘Kookeer ꞉chiito ake bārooyintaab chiichoo.’ ");
INSERT INTO spyNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kunyoo, māchāktōōs /keekwey nyēē keekeer inee. Nto nyooto ku nyoo kikēēboontootē keey tukul kēēmiitē āk Mokoryoontēēt Yēēsu, ");
INSERT INTO spyNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kutoowunēē yoo kibātisānē ꞉Yoowaana Yēēsu ākoy yoo /kibokēēyibē kuwo kibkōōnkōy. Mākuchutēēch ꞉chiichoo sikiiboorunootē ꞉tukul kule kookung'eetee ꞉Yēēsu meet.” ");
INSERT INTO spyNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yooto, /keetwech biiko āyēēng': Yōōsēēf Barsaaba, nto kaayneenyii ake ku Yuustō. Nto nyiin ake ku Matyaa. ");
INSERT INTO spyNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yooto /keesaay Yēyiin kule, “Mokoryoontēēt, 'inkētē inyiing' wōlēē wuu ꞉kāāsōōtēywēēkaab biiko. Kunyoo, iboorwēēch ām bichu āyēēng' kule nkōnō ꞉nyēē !keekwey ");
INSERT INTO spyNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kuyey yiisyooni bo *lēbkēēyik nyi kibākooktooy ꞉Yuuta sukuwēētii wōloo kiyēmāktōōs kuwo kubo rōkōsnyii.” ");
INSERT INTO spyNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","/Keebar *sēkēēryēēt. Yooto kunam Matyaa. Kung'eetee yooto kuwo taay, kutas keey āk lēbkēēyik chuut ki taman āk akeenke. ");
INSERT INTO spyNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yu kayit bēsyēēt nyēbo *Bēēntēkōōst kōōruruukyi keey ꞉rubiichoo tukul yēēt akeenke. ");
INSERT INTO spyNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nyēē mā tyaa, kuchōōnēē ꞉bōlātēēt barak nyēē kāmooryēn wuu kibuybuy. Kiker ꞉bōlātoonoo kōōto tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kiisuuchi rubiichoo tukuuk chēē wuu āloolātēētaab maat ānkutēbootēē mētēwoy. ");
INSERT INTO spyNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","/Kikiinyiityi chii ake tukul ām yooto Tāmirmiryēēt ānkutoow ꞉ake tukul kung'alaal ām kuutiit nyēē ‑mēēnkētē. Kibo ꞉kāāmuukēywēēchoo Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kimii ꞉Yuutayeek Yēērusālēēm chēē kiikōōnēmchi keey Yēyiin. Kikwoonootēē yēēmōōsyēk chēē tēērchiin ām kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yu kakas bōlātoonoo, kōōruruuch keey. Nto yu kakas ꞉chii ake tukul ām icheek /kēēng'āloolēē kuutiinyii kunam kuut. ");
INSERT INTO spyNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yooto kulē ꞉bichoo, “Māku nkoolat ōō! So, mā Kalilaayeek ꞉bichu tukul? ");
INSERT INTO spyNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ntēē kāsē ꞉ake tukul ām acheek kung'āloolē ꞉bichu kuutiinyii! ");
INSERT INTO spyNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kēēbooyē ꞉alake Baarti, Meetya āk Eelam. Nto alak kubo Meesobotaamnya, kōōrēētaab Yuutayeek, Kabatookya, Bōōntō ākoo Eesya. ");
INSERT INTO spyNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Bo ꞉alake Fruukya, Bamfulyaa, Miisir, rōōrōōkiisyēkaab Liibya chēē lēēkitēē Kurēēn nto alak kubo Rooma ");
INSERT INTO spyNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","chēē Yuutayeek āk chēē /kiikeeweech kurub ātēbuutēkaab Yuutayeek. Kwoonēē ꞉alake Kērēētē ākoo Areebya. Ng'āloolē ꞉bichu kuutuweekyoo kōōbooru tukuuk chēbo kwōng'uut chēē rubtooy keey āk Yēyiin!” ");
INSERT INTO spyNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kutākōōlātē ꞉bichoo, kuteebee keey kule, “Ng'al nee ꞉chu ēē?” ");
INSERT INTO spyNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nteenee kiichaasee keey ꞉alake kumwooyē kule, “Bōōkityootiin ꞉chu!” ");
INSERT INTO spyNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nto mii yoo, kōōyyo ꞉Bētērō taay ānkung'āloolchi biiko choo kikiiruruukyi keey yooto. Kimii yooto ꞉nkicheek *lēbkēēyik chuut tamanu āk akeenke. Kikuurchi ꞉Bētērō barak kule, “Āmwoowook ii, kāābkōōnyoo āk akweek tukul choo ōminyē Yēērusālēēm, ōyēbchi yiit kāroomin kiyēē āmiitē wāāmwoowook. ");
INSERT INTO spyNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kookas, tāku ꞉āsiiswēk sōmōk chēbo kōrrōōn. Mābōōkityootiin ꞉bichu kuu wōloo ōsōōtitooy ꞉akweek. ");
INSERT INTO spyNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ityiichē ꞉yuutēyu kiyēē kikiikumwooy *꞉wōōrkooyoontēētaab Yēyiin Chōōwēēl kule: Mwooyē ꞉Yēyiin kule, ");
INSERT INTO spyNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ām bēsyōōsyēkaab lētuut +māāng'oobchi Tāmirmiryēēnyuu biiko tukul. Mākung'ōōrso yooto ꞉tibikwook āk wērikwook. Mākukāsē ꞉āybēērikwook kitōōntōyēēn ām ng'oong'uutēk ānkumākunyōōru ꞉booyikwook kiirwootik. ");
INSERT INTO spyNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","+Māāng'oobchi mbo Tāmirmiryēēnyuu ām bēsyōōsyēchooto motwoorikyuu ānku murēn nto koor. Mākung'ālooltoowoo ām kāāmuukēywēēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","+Maayey kutook tukuuk chēē ‑/mākyoomu ām wōliin bo barak āk wōlēēb ng'wēny. +/Makiitaata koroti, kuchō ꞉maata ānkutuskēn ꞉kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mākumis ꞉asiista ankusalakay ꞉araaweet nto yitu ꞉bēsyēēt nyoo wōō bo Yēyiin ānkubo kwōng'uut. ");
INSERT INTO spyNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","+/Makiiraraach chii ake tukul nyoo riirchinē Yēyiin.’ ");
INSERT INTO spyNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mooyēētaab *Isrāyēēl, ōyēbchi yiit ng'aleechu: Yēēsu nyēbo Nāāsārēēt ku chii nyēē kiiboorunēē ꞉Yēyiin ng'al chēbo kwōng'uut kuu wōloo ōnkētitooy ꞉akweek. ");
INSERT INTO spyNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","/Kikiiyokoowook chiichi sooyeyee kiyēē ōmāchē ām kēēlto nyēē kikiikusat ꞉Yēyiin ām ng'oomnānēēnyii. Kyoong'eet ꞉akweek āk biikaab Rooma, obakach ōkwērtoochi murtooywoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nteenee kiing'eetee ꞉Yēyiin meet kootyaakta ām nyalil ake tukul, kuuyu mēēbērē kiimuuchē ꞉meet kukiilchi inee. ");
INSERT INTO spyNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kimwooy ꞉Tāwuti ng'al chēē wuu nyēē kiing'wēlyēēlē Mokoryoontēēt kule, ‘Intōōwoo ꞉Yēyiin kibtaman. Miitē ꞉Yēyiin āwunyuu nyēbo taay, kunyoo, māmii ꞉kiy nyēē makutwaaya. ");
INSERT INTO spyNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ng'erechaat ꞉mooyēēnyuu ankaabaybay. Mākōōbuur ꞉bōōrnyuu kuboonto kāākēnēēt, ");
INSERT INTO spyNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kuuyu mēēbērē +mēēbākookyi bōōrnyuu *kāābkwoombiich, nto ibakaakte kunun ꞉chiing'uung' nyoo churtaat. ");
INSERT INTO spyNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","'Kwēēboorwoo kēēlwookik chēbo soboonto, anku +meeng'ereechaa kuyitita ām taayeeng'uung'.’ ");
INSERT INTO spyNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mbo ng'eetaabiya, okany āchuurtoowook: Kime *꞉Tāwuti /ankeemuy. Tākiinkētē mbo raat wōloo /kikēēmuchinē. ");
INSERT INTO spyNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ki *wōōrkooyoontēētaab Yēyiin ꞉Tāwuti ānkiinkētē ꞉inee kiyēē kikiikukuurtoochi ꞉Yēyiin. Kiiwoolchi keey ꞉Yēyiin kule makutool chii nyēbo mooyēēnyii kuyēk bāytooyiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kukāsē kiyēē kimii taay, king'āloolēē ng'eeteetaab meet nyēbo *Kāārārookiintēēt. Kimwooy kule mēēbērē +/mākēēbākookyi kāābkwoombiich, nto mbo kunun ꞉bōōrnyii. ");
INSERT INTO spyNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kookoong'eetee ꞉Yēyiin Yēēsu meet ankookeekas ꞉acheek kule man. ");
INSERT INTO spyNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","/Kōōkiikoochi kōōbuurunēē āwutaab taay nyēbo Yēyiin. Kōōkunyōōr Tāmirmiryēēt kuu yoo kikiikukuurto ꞉Yēyiin, ānku kāākurōōbwēēch Tāmirmiryoonoo. Kunyi, kookas ꞉akweek kuyēyāktōōs ꞉tukuuchoo bēsyooniitēnyi. ");
INSERT INTO spyNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mānāāwo *꞉Tāwuti barak, nteenee kimwooy kule, ‘Kimwoochi ꞉Yēyiin Mokoryoontēēnyuu kule: Ibuurunēē āwunyuu nyēbo taay ");
INSERT INTO spyNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ākoy yoo kaayeyiing' itēbēē buunikuuk.’ ");
INSERT INTO spyNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kunyoo, kukas ꞉biikaab *Isrāyēēl tukul ng'ālyoontooni: Kiyey ꞉Yēyiin Yēēsu nyiitēnyi kyōōkwērtoochi ꞉akweek murtooywoontēēt kuyēk Mokoryoontēēnyoo ānkuyēk mbo subak Kāārārookiintēēnyoo.” ");
INSERT INTO spyNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Yu kakas ꞉bichoo ng'aleechaa kimwooyē ꞉Bētērō, kung'woonchi miisin ām kiyēē kikiikuyeyakay. Kimwoochi ꞉bichoo Bētērō āk *lēbkēēyik chuut alak kule, “Mbo ng'eetaabiya, ara keeyey nee?” ");
INSERT INTO spyNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kukētyi ꞉Bētērō bichoo kule, “Oweekse ām miyootyēēt /ankeebatisan chii ake tukul ām akweek ām kaayneetaab Yēēsu *Kiriistō sukung'eet /kēēnyōōwook kaat. Nto mii yoo, +/mākēērōōbwook Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kiyooto ꞉nyēē kōōkukuurtoowook ꞉Yēyiin āk lōkōkwook ākoo mbo nkicheek alak choo lōōyēch chēē mākukuur ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ām ng'aleechuutēchu āk alak chēē chaang', kiikāloonchi ꞉Bētērō biiko kumwoochinē kule, “Osatee keey wōlēē mii ꞉biich chēē moosootiin. Yoo kooyey kuu nyooto, kōōsāru soboonwēkwook.” ");
INSERT INTO spyNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","/Kikeebatisan biiko choo kicham ng'aleekaab Bētērō. Kitāsyi keey bēsyoonooto ꞉biiko alake chēē kiyitē kisyēērōōk sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kiinēmu keey ꞉bichoo /kikēēbātisānē kuriib kāānēētiisyēētaab *lēbkēēyik. Kiibuurchiintōōs ānkuyēētyēēchinē keey. Kyoomchiintōōs āmiik ānkusooyē ꞉tukul Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kiyey ꞉lēbkēēyik ng'aleek chēē chaang' chēē /kiilātē, ng'ālyoo nyēē kiiywey icheek ꞉biiko tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kiibuurē ꞉biikaab Kiriistō tukul yēēt akeenke ānkuyēētyēēchinē keey ām keel ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kyooltooy tukuukwaa ānkuyēētyēēchinēē chii ake tukul nyoo kābotyi ꞉kiy. ");
INSERT INTO spyNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kibēētii ꞉bichoo kwaak bokutuuytōōs yēbo biiwuutaab *Kōōtaab Yēyiin. Kyoomchiintōōs ām bāybooyyēēt āmiik ām kooriikwaa. ");
INSERT INTO spyNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kiikoostooy Yēyiin ānkung'ērēkyinē icheek ꞉biikaab kiriinkoonoo. Kitāsu ꞉Mokoryoontēēt biiko alak chēē kimii /kiirāroochē ām bēsyō ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nto mii bēsyēēt ake, kuwo ꞉Bētērō ākoo Yoowaana *Kōōtaab Yēyiin yēē ki āsiiswēkaab saayeet. Kubēētii, kimii ꞉asiista sokool bēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yu makuyit, kukas /kiimutu chiito ake nyēē kichunkutootiin ꞉kērēēnkōōk kung'eetee /kākēēsich, kuwo yēbo oreet nyēē /kikēēkuurē kule ‘Oreet nyēē karaaran’. /Kikiikoochinē chiichoo yooto bo oreet kwaak sukusoomē kōōkoochi kiy ꞉biiko choo iwutē biiwuutaab *Kōōtaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yu kakas ꞉chiichoo kichunkutoot kule kikiikuriik ꞉Bētērō āk Yoowaana kōōwut biiy, kusoom beesaanik. ");
INSERT INTO spyNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kōōrōōtoot ꞉Bētērō āk Yoowaana chiichoo nto yityo kumwoochi ꞉Bētērō kule, “Ikaseech!” ");
INSERT INTO spyNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Koonyal ꞉chiichoo icheek kukānyē kule /kēēmētyi kiy. ");
INSERT INTO spyNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kumwoochi ꞉Bētērō chiichooto kule, “‑Māāboontē beesyaa nteenee mii ꞉kiyēē āboontē ānku +māākōōniing' nyooto. Āmwoowuung' ām kaayneetaab Yēēsu *Kiriistō nyēbo Nāāsārēēt, kule ing'eet ānkiiwēēsyēt!” ");
INSERT INTO spyNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kunam ꞉Bētērō āwutaab chiichoo nyēbo taay ānkuyēētyēēchi kōōyyo. Kunyōōr ꞉kērēēnkōōkaab chiichoo nkuruuk areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kōōyyo ānkuwēēsyētoot! Kuwēēto keey ꞉chiichooto mbo Bētērō kōōroonchinootē ꞉inee barak kōōkoostooy Yēyiin ākoy biiy. ");
INSERT INTO spyNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yu kakas ꞉biiko kuwēēsyētootē ꞉chiichoo ānkōōkoostootē Yēyiin, ");
INSERT INTO spyNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kōōnkēt kule ki nyoo kiibuurē oraanaa komos. Kiilat ꞉bichoo ankunam kuut ꞉kiyēē kiyeyakay ām wōlēē mii ꞉chiichoo. ");
INSERT INTO spyNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kumii ꞉chiichoo kāyēētyi keey wōlēē kimii ꞉Bētērō ākoo Yoowaana ām yēē /kikēēkuurēē Kēēltaab Sōlōmōōn nyēē kitinyē wuurwēēt. Koolat ꞉biiko ankulabat ākoy yooto. ");
INSERT INTO spyNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Yu kakas ꞉Bētērō kuu nyooto, kumwoochi biiko kule, “Biikaab *Isrāyēēl! Ām nee yu soolat ām kiyēē kayeyakay? Ōbērē akweek kakeeyey chiichi kuwēēsyēt ām kāāmuukēywēēkyoo nto kule kuuyu kēēchurtootiin? ");
INSERT INTO spyNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Acha! Yēyiintēētaab *Abraam, Isaka āk Yāākōbō, Yēyiintēētaab mbo kuuko ꞉nyēē kayey ng'aleechaa. Kāākōōtōrōōr ꞉Yēyiin motwooriintēēnyii Yēēsu nyoo kyōōtāyē ꞉akweek ām taayeetaab *Bilaato ānkōōrēkēērtē /bokeebakach, ānkoo kikiikumach kule kootyaakta. ");
INSERT INTO spyNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kyootay chii nyēē kichōōnēē wōlēē mii ꞉Yēyiin nyēē churtaat ankoomach kule /kiityooktoowook chii nyēē sikoran. ");
INSERT INTO spyNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kyoobakach chii nyēē kichokuyaat kēēltaab soboonto, nteenee kiing'eetee ꞉Yēyiin meet. Kikeekas ꞉acheek kuyēyāktōōs ꞉kiyi. ");
INSERT INTO spyNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kānyōōr ꞉chiichi ōnkētē ꞉akweek nkuruuk kuwēēsyēt kubo kaakaaseet. Kāsob ꞉inee ām kāāmuukēywēēkaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kunyoo ii, biikyoo, ōyēyē ꞉akweek ng'aleechu, kimōōnkētē ānkimēēnkētē ꞉nkicheek kāāntōōyikwook. ");
INSERT INTO spyNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nteenee kēēliitēnyi ꞉nyēē kaakuyey ꞉Yēyiin sukuyityiin kuu yoo kimwoowu kubununēē wōlēē mii *꞉wōōrkooyikaab Yēyiin. Kimwooy ꞉Yēyiin kule makunyalil *꞉Kāārārookiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kunyi, oweeksee choolwookātēēt ānkōōyisyi keey Yēyiin /sikēēmētoowook ng'ōōkiswookikwook. ");
INSERT INTO spyNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Oyey kuu nyooto, sukung'eet ōnyōōru tāloosyēēt kuchōōnēē wōlēē mii ꞉Yēyiin ānkumākōōyook subak Yēēsu nyoo kisimkutool kuyēk Kāārārookiintēēng'woong'. ");
INSERT INTO spyNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yēmāktōōs kung'ētunēē ꞉Yēēsu kibkōōnkōy ākoy kut kuyit ꞉bēsyēēt nyēē kētyinēē ꞉Yēyiin kiy ake tukul kukaramiit kuu yoo kibo toowunēēt. Kikiikumwooy ꞉Yēyiin ng'aleechu kubununēē wōōrkooyikyii choo kibo kēny. ");
INSERT INTO spyNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kimwooyē *꞉Muusa kule, ‘Mākukōōnook ꞉Yēyiintēēng'woong' wōōrkooyoontēēt ake kuchōōnēē wōlēē mii ꞉biikwook nyēē wuu anii. Māchāktōōs ōkāsyi kiy ake tukul nyēē mwoowook. ");
INSERT INTO spyNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Chii ake tukul nyēē kāmākāsyi, mākung'ētitēē wōlēē mii ꞉biikaab Yēyiin.’ ");
INSERT INTO spyNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kubooyiit man, kiikung'ooraan *꞉wōōrkooyikaab Yēyiin tukul bēsyōōsyēchu, kung'eetee Sāmwēēl ākoy alak choo kibo lētuunoo. ");
INSERT INTO spyNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mii kuyityiintōōs ām wōlēē ōmiitē ꞉ng'aleekaab wōōrkooyichoo āk kiyoo kikuurtoochinē ꞉Yēyiin mbo kuukoong'. Kimwoochi Abraam kule, ‘Mākunyōōr ꞉biikaab kōōrōōsyēk tukul kāābēruurēētaab Yēyiin kubununēē chii nyēē mākuchōōnēē mooyēēng'uung'.’ ");
INSERT INTO spyNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yoo kikōōnu ꞉Yēyiin motwooriintēēnyii Yēēsu, kiiyook kurook simkuchō wōlēē ōmiitē ꞉akweek chokōōbēruurook, kuwēēchēē ake tukul ām akweek wōlēē mii ꞉miyootyēēng'woong'.” ");
INSERT INTO spyNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kutākumii ꞉Bētērō āk Yoowaana tākung'āloolchinē biiko, kukwoonchi ꞉mbo kibkōrōs āk nyēē kiiyyoonkyinē riibiikaab *Kōōtaab Yēyiin āk *Satukaayeek. ");
INSERT INTO spyNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Manaakas ꞉bichu nyēē karaam, yu kimii *꞉lēbkēēyik kōōnēētiisyē ānkwoomchinē biiko kule imuuchē ꞉chii kung'eetee meet kubununēē Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kinam ꞉bichoo Bētērō āk Yoowaana, nteenee kuuyu kikiikwiimēn ꞉kōōrēēt, /keekerta kō ākoy kuyyeech. ");
INSERT INTO spyNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ānkoo kuwuu nyooto, kichamta ꞉biiko chēē chaang' Yēēsu choo kikas ng'aleechaa kyoomu ꞉mbo Bētērō. Kitas taay ꞉biiko chēē kikiikōōyēnchi ng'ālyoontēētaab Yēyiin kubās keey kut kimāchē kuriichē kisyēērōōk muut. ");
INSERT INTO spyNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yu kāyyēēkunēē, kutuuyo ꞉kāāntōōyik, booyik āk kāānēētikaab kiruutēk Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kāāntōōyichoo ku: *Anaas nyoo ki kibkōrōs nyēē wōō, *Kayaafa, Yoowaana, Alekisaanta āk biiko alak chēē kibo kōōtaab mbo kibkōrōs chēē wōōyēch. ");
INSERT INTO spyNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","/Kikēēkwēryoot Bētērō āk Yoowaana kōōkwoonoo. Yooto, kutoow ꞉kāāntōōyichoo kuteebee mbo Bētērō kule, “Kākōōnook ꞉ng'oo kāāmuukēywēēk oyey ng'aleechu?” ");
INSERT INTO spyNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kumwoochi ꞉Bētērō ām kāāmuukēywēēkaab Tāmirmiryēētaab Yēyiin kule, “Kāāntōōyik āk booyikaab yēēmēēt, ");
INSERT INTO spyNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yēē ākoo /kēēmiitē bēsyooni /kēētēēbēēnēēch ng'al chēē rubtooy keey ākoo ng'ālyoo nyēē karaam nyēē /kōōkēēyēchi chiichi kōchunkutoot ākoo wōlēē /kōkiisoobto, ");
INSERT INTO spyNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kumāchāktōōs kōōnkēt ꞉biikaab *Isrāyēēl tukul kule kōsob ꞉chiichi ām kāāmuukēywēēkaab *Kāārārookiintēēt Yēēsu nyēbo Nāāsārēēt. Inee ꞉nyoo kyōōkwērtoochinē murtooywoontēēt, nteenee koong'eetee ꞉Yēyiin meet. ");
INSERT INTO spyNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yēēsu ꞉nyiitēnyi ku rwaanteet nyoo kyōōtāyē oteekte, ꞉nyēē tiiyēywoontēētaab kōōto. ");
INSERT INTO spyNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Māmii ꞉kēēlto ake nyēbo kaararaacheet ꞉nyēē kiikōōkoochi ꞉Yēyiin biiko nteenee Yēēsu nkit.” ");
INSERT INTO spyNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kiilat ꞉kōōkwoonoo bo Yuutayeek ām kāng'unātēēt nyēē kiboonto ꞉Bētērō āk Yoowaana ānkoo kut ki biich chēē kimāsumānootiin. Nteenee kisēw kule ki rubiikaab Yēēsu ꞉icheek. ");
INSERT INTO spyNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nto kuuyu kitākuboontootē keey ꞉chiichoo /kikiisoobē mbo Bētērō, kibotyi ꞉wōlēē kikwiilta icheek. ");
INSERT INTO spyNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kunyoo, kumwoochi ꞉bichoo mbo Bētērō kule, “Obe saang'”. Nto mii yoo, kōōrwooch. ");
INSERT INTO spyNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kiteebee keey ꞉bichooto kule, “+Makeeyeyee nee bichu ēē? Ntēē kāākōōnkēt ꞉chii ake tukul ām Yēērusālēēm kule kaakuyey ꞉bichu ng'ālyoontooni ‑/mākyoomu. Kunyi, māmii ꞉wōlēē kēētuuktooy. ");
INSERT INTO spyNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nteenee yēē simātākutistēē ꞉ng'ālyoontooni biiko, +makeeker koong' bichu kumātākwoomchinē biiko lōkōōywēk kuyēyiisyēē kaaynaani.” ");
INSERT INTO spyNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yooto, /kēēkuur mbo Bētērō kooyeey kō /ānkēēmwoochi kusaan tākōōnēētiisyoot kurubta keey āk Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nteenee kimwoochi ꞉Bētērō ākoo Yoowaana bichooto kule, “Karaam /kiiyweyaak nto /kiiywey Yēyiin? ");
INSERT INTO spyNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","‑Mākiimuuchē ꞉acheek keesiiste kiyēē kiikeekasee koonyek āk yiitiik.” ");
INSERT INTO spyNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Kimāmii ꞉kiyēē kiimuuchē ꞉bichoo kuyeyee mbo Bētērō kuuyu kiikoostooy ꞉biiko tukul Yēyiin kubo chiichoo kiboonto kēnyiisyēk chēē kikēēytēē artam, nyoo /kikiisoobē ām kēēloo bo kwōng'uut. Nto subak, kiimuuchē ꞉bichooto koong'eet wōōrōōryēēt. Kunyoo, kibōlchi subak ankubakaakta kubēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Yu /kabokiityaakta Bētērō ākoo Yoowaana, kooyeey wōloo kimii ꞉biikwaa ānkubokumwoochi ng'aleek chēē kimwooy ꞉mbo kibkōrōs chēē wōōyēch āk booyik. ");
INSERT INTO spyNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yu kakas ꞉bichoo ng'aleechaa kusaay kukuurchinē barak kule, “Mokoryoontēēt Yēyiin nyoo 'kiiyēyē barak āk ng'wēny, bēēkaab araaray āk tukuuk tukul chēē mii kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","King'āloolchinē ꞉Tāmirmiryēēng'uung' kuuko *Tāwuti, kule, ‘Ām nee sukunyēkēriitu ꞉bōrōryōōsyēk alake, ānkōōbootyinē ꞉Isrāyēēl āsiiswēk ng'al chēē māyitē wuy? ");
INSERT INTO spyNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Chōbē keey ꞉bāytooyikwaa kuyey booryēēt ānkukāākōōruruuch keey ꞉nkicheek kāāntōōyik sukubooryēē Yēyiin āk chiinyii nyoo ng'aabaat.’ ");
INSERT INTO spyNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kubooyiit man, kituuyo yu bo kiriinkooni *꞉Ērōōtē āk Bōōntyō *Bilaato ākoo biiko choo mābo kōōrēētaab Isrāyēēl āk choo bo Isrāyēēl. Kiyēchi ruurumuut motwooriintēēng'uung' Yēēsu, nyoo 'kiing'aab kuyēk Kāārārookiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kiyey kiyēē kikiisimitiil kēny ām kāāmuukēywēēkuuk kule makuyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kunyi ii, Mokoryoontēēt, ikas wōlēē kāākōōmuuytēēch ānkiikōōnēēch acheek motwoorikuuk nyikanateet kyaamte ng'ālyoontēēng'uung' nyēē māmii ꞉muyāt. ");
INSERT INTO spyNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ikōōnu kāāmuukēywēēkuuk kōōsoobiis ankiiyey tukuuk chēē /kiilātē āk chēē ‑/mākyoomu ām kaayneetaab motwooriintēēng'uung' Yēēsu nyoo itabaanaat kubo yiisyēēng'uung'.” ");
INSERT INTO spyNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yu keewaany ꞉bichoo kusaay, kōōtimtiimākoy ꞉kōyooto kāmiitē ꞉icheek kusooyēē /ānkiinyiityi icheek tukul Tāmirmiryēētaab Yēyiin. Yooto, kwaamtaat ng'ālyoontēētaab Yēyiin ām nyikanateet nyēē māmii ꞉muyātēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kikinoomnyo ꞉biiko choo kikiikuchamta ng'ālyoontēētaab Yēyiin kuyēk kiito akeenke. Māmii ꞉chii nyēē kiitukuulchinē keey tukuuk nteenee kibchēchiintōōs āk chuut. ");
INSERT INTO spyNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kiiboor *꞉lēbkēēyik ām kāāmuukēywēēk kule king'eetee ꞉Mokoryoontēēt Yēēsu meet. Kiibēruur ꞉Yēyiin lēbkēēyichoo tukul ām yiisyēēng'waa. ");
INSERT INTO spyNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kimāmii ꞉chii ām icheek nyēē kibotyinē ꞉kiy, kuuyu kyooltooy ꞉alake mbareenik nto kooriik ");
INSERT INTO spyNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","/ānkubokiikoochi beesaanichaa kōōyyoong'unēē āwunnyēkaab lēbkēēyik sukung'eet /kēēyēētyēēchinēē choo boonto nyalilta. ");
INSERT INTO spyNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kimii ꞉chiito ake nyēē /kikēēkuurēē Yōōsēēf nyēbo kōōtaab Laawi ānkibo kōōrēētaab Kubrō, nyēē kitoochi ꞉lēbkēēyik kaayneet ake kule ‘Barnaaba’. (Ibooru ꞉kaaynaani kule murēn nyēē ikiimē chuut.) ");
INSERT INTO spyNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ki inee ꞉akeenke ām choo kyaalta mbareenikwaa ānkōōkooyto beesaanik kōōyyoong'unēē āwunnyēkaab lēbkēēyik. ");
INSERT INTO spyNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","King'eet ꞉chiito ake nyēē /kikēēkuurēē Anannyaa āk cheebyoosyeenyii Safiira kwaalta mbareeng'waa. ");
INSERT INTO spyNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yu kaakwaalta, kukāsyiin āk cheebyoosyeenyii kung'aal beesaanik kereeryaa ankukonor. Nto yityo, kuyib ꞉Anannyaa beesaanik chuut bokōōyyoong'unēē āwunnyēkaab *lēbkēēyik. ");
INSERT INTO spyNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Yu kāyib, kumwoochi ꞉Bētērō Anannyaa kule, “Ntēē siicham kutōōrchiing' ꞉Kibrōkōsyoontēēt ng'ōōki kut neennyi 'keeberbeer Tāmirmiryēētaab Yēyiin kule beesaanik tukul ꞉chuutēchu? Ām nee sii-am chuut alak? ");
INSERT INTO spyNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","So, ki nyeeng'uung' oob ꞉mbareet kumanee-alte? Nto subak kāmātāku cheekuuk ꞉beesaanichu kwēē-āltēē mbareet? Kunyi, mā chii ꞉nyēē 'keeberbeer, nteenee Yēyiin!” ");
INSERT INTO spyNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kukāsē ꞉Anannyaa ng'aleechaa, kōōryookyinē keey ng'wēny ānkumēē! Kimuuyo miisin ꞉biiko tukul chēē kikas kiyēē kiyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yooto, kukwoonii ꞉āybēēriik bakeenke ānkubokurātēē ankeet ānkubokumuyē. ");
INSERT INTO spyNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yu kakeeyta ꞉āsiiswēk sōmōku, kuyitu ꞉cheebyoosyeetaab Anannyaa āmēēbērē kiinkētē kiyēē kikiikuyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kuteebee ꞉Bētērō kule, “Cheebyoos, beesaanik tukul ꞉chuutēchu choo kōbo mbareet?” Kulē ꞉cheebyoosyeet, “Ēē, chooto.” ");
INSERT INTO spyNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kumwoochi ꞉Bētērō kule, “Ntēē sōōkāsyiinē osyeem Tāmirmiryēētaab Yēyiin? 'Keekas, mii kuyitu ꞉biiko chēē kātākumuyē boontēēng'uung' ānkumii bokumuyiing' nkinyiing'.” ");
INSERT INTO spyNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kōōryookyinē keey bakeenke ꞉cheebyoosyeet kērēēnkōōkaab Bētērō ānkumēē. Kuyitu ꞉bichoo kātākumuyē Anannyaa ankukalab cheebyoosyaanaa ānkubokumuchi kochonkeet nyoo kimii ꞉boontēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kinam kuut kaniseet tukul āk mbo biiko chēē kiyityi ꞉ng'aleechaa lētuunoo. ");
INSERT INTO spyNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kiituuyēēchinē keey *꞉lēbkēēyik tukul yoo bo Kēēloo bo Sōlōmōōn sukōōnēētē biiko lōkōōywēk kurubta keey Yēēsu. Kiyēyē mbo subak ng'al chēē chaang' chēē /kiilātē. ");
INSERT INTO spyNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kinyōkōriitu ꞉rubiik chuut alake kulumchi lēbkēēyichoo kubo kāāntōōyikaab Yuutayeek. Ānkoo kuwuu nyooto, kitākōōkoostooy ꞉biiko lēbkēēyichoo. ");
INSERT INTO spyNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kitas taay ꞉murēnik āk chēēbyōōsōōk kuchamta Mokoryoontēēt miisin kusiir yoo kibo taay. ");
INSERT INTO spyNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kiyey ꞉ng'aleechaa /kiilātē /kiimut biiko chēē kimnyoontōōs ām tiirboosyek āk kisyēērōōk si yoo kātiiny ꞉kitōōntōyēētaab Bētērō, kusobtōōs. ");
INSERT INTO spyNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kiiruruukoonunēē keey ꞉biiko kiriinkōōsyēk alak chēē kilēēkitēē Yēērusālēēm, kōōmutu biikwaa chēē kimnyoontōōs āk chēē kiiyiimē ꞉tāmirmirook chēē miyootēch. /Kikiisoob bichoo tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kimēēchi ꞉moo *kibkōrōs nyēē wōō āk biikyii chēē ki *Satukaayeek ām kiyēē kiyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yooto kunam ꞉icheek *lēbkēēyichoo ankukerta kō. ");
INSERT INTO spyNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nto mii kwēēmooy, kuchō *꞉malayikeet ānkuchokuyoot. Kimwoochi ꞉malayikaanaa bichooto kule, ");
INSERT INTO spyNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Obe ākoy biiwuutaab *Kōōtaab Yēyiin ānkubōōmwoochi biiko ng'aleek tukul kurubta keey sobooni lēēl.” ");
INSERT INTO spyNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yu kayyeech, kuba ꞉lēbkēēyichoo ākoy biiwuutaab Kōōtaab Yēyiin kuu wōloo /kikēēmwooytoochinē ānkutoow kōōnēētiis. Kikuur ꞉kibkōrōs nyēē wōō āk biikyii *kōōkwēētaab Yuutayeek kumukuul. Yooto, kōōyookto /bokēēkwērunēē lēbkēēyichoo wōloo /kikēēkērtooy. ");
INSERT INTO spyNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nto bērē kuyit ꞉riibiikaab *Kōōtaab Yēyiin wōlooto /kikēēkērtooy lēbkēēyichoo, mānāānyōōr chii. Kōōyēēyē bakeenke ");
INSERT INTO spyNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ānkubokumwooyē kule, “Ntēē kābokēēnyōōru tēmēloot ꞉kōōto ānkumii ꞉riibiik kuriibsē kurkat. Nto bērē keeyaat kurkootik, mii ānō ꞉chii kō!” ");
INSERT INTO spyNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yu kakas ꞉kāāyyoong'iintēētaab riibiikaab Kōōtaab Yēyiin āk nkicheek mbo kibkōrōs chēē wōōyēch ng'aleechaa, kunam kuut miisin kule mii kuwēētii ānō ꞉kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nto mii yoo, kuchō ꞉chiito ake ānkuchokumwooy kule, “Kookas, miitē kōōnēētiisyēē ꞉bichoo kwōōkērtooy kō biiwuutaab Kōōtaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kukāsē ꞉kāāyyoong'iintoonoo bo riibiik kuu nyooto, kuwēētooy biikyii ānkubokukwoontooy lēbkēēyik nyēē mānāākērchi koong', kuuyu kinyōkōriitu kule imuuchē kuwiirēē ꞉biiko rwoontōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Yu /kābokēēkwēryoon lēbkēēyichoo, /kiimutyi kōōkwēētaab Yuutayeek ānkukōrōmchi *꞉kibkōrōs nyēē wōō, ");
INSERT INTO spyNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","kumwoochinē kule, “Kikiikāloonwook kule ‑mātōōnēētiisyootēē kaaynaani bo chiichi! Nteenee kookoolaambuuch ꞉kāānēētiisyēēng'woong' Yēērusālēēm kumukuul, ōmwooyē kule acheek ꞉chēē kikēēbākāchē chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kukētyi ꞉Bētērō āk lēbkēēyik alak kule, “Māchāktōōs kiiywēyē Yēyiin kusiir yēē kātākiiywēyē biiko. ");
INSERT INTO spyNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kiing'eetee ꞉Yēyiintēētaab mbo kuuko Yēēsu meet nyoo kyōōbākāchē ōkwērtoochinē keet barak. ");
INSERT INTO spyNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kōōkukwēryoot ꞉Yēyiin kuwo kibkōōnkōy ānkumii āwunyii nyēbo taay kubāytooyiisyē anku *Kāārārookiintēēt, sukung'eet kuwēēkiis ꞉biikaab Isrāyēēl /ānkēēnyōōchi kaat ām choolwookātēēng'waa. ");
INSERT INTO spyNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kyoomtooy ꞉acheek ng'aleechu ānkwoomtooy mbo ꞉nkinee Tāmirmiryēētaab Yēyiin nyoo kiikōōkoochi ꞉Yēyiin biiko choo kāsyinē inee.” ");
INSERT INTO spyNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yu kakas ꞉kōōkwoonoo kuu nyooto, kung'woonchi miisin. Yooto, kumach kule kubakach lēbkēēyichoo. ");
INSERT INTO spyNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nteenee kimii *꞉Fārisooyiintēēt ake ām kōōkwoonoo nyēē /kikēēkuurēē Kāmālyēēl. Ki kāānēētiintēētaab kiruutēk nyēē kikoonyitē ꞉biiko tukul. Kimwooy kule, “Ōkwēryootē, baa, bichu kuba saang' kisich.” ");
INSERT INTO spyNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nto mii yoo, kōōrwookyi kōōkwoonoo kumwoochinē kule, “Kāābkōōnyoo, māchāktōōs ōrōōtootē kiyēē ōmāchē ōyēchi bichu. ");
INSERT INTO spyNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ām kēnyiisyēk chēē ng'ēri choo kookukeeyta, kōchō ꞉ake nyēē /kikēēkuurēē Teewuuta nyēē kiyey keey kule inee ku chiito ake nyēē wōō. Kuroob inee ꞉biiko chēē kimāchē kuyitē bokolwookik ang'wan. Nteenee /keebakach /ankiisereet biikyii tukul ankung'etee yoo ꞉ng'aleekyii. ");
INSERT INTO spyNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yooto subak, kookeer ꞉Yuuta nyēbo Kalilaaya ām bēsyōōsyēkaab kāāyiitiisyēēt nyēē wōō nyoo kibo biiko. Kiroob ꞉nkinee biiko chēē chaang', nteenee /kiiwaang'ta inee /ankiisereet biikyii. ");
INSERT INTO spyNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kunyoo, ām ng'ālyoontooni, āmwoowook kule obakaakte rubiichu bo Yēēsu kubēēchi keey kuuyu yēē ākoo chōōnēē ꞉kiyēē mwooyē ꞉bichu wōlēē mii ꞉biiko, kumāyēyē kiy. ");
INSERT INTO spyNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nto yēē ākoo chōōnēē wōlēē miitē ꞉Yēyiin, ‑mōōmuuchē kut okerekte bichu, nteenee, imuuchē bōōyiinēē ōmiitē ōbooryēē Yēyiin.” Kiyis ꞉ng'aleechaa kāāsōōtēywēēkaab bichooto. ");
INSERT INTO spyNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yooto, /kēēkuur lēbkēēyichoo kuba kō /ankeebas. Nto mii yoo, /kēēmwoochi bokusaanee keey kung'āloolootēē kaayneetaab Yēēsu. Yooto, /keebakaakta kubēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","King'ēētyēē ꞉lēbkēēyichoo yooto kibo kōōkwoonooto nyēē ng'ērēkootiin, kuuyu ki ng'ālyoo ꞉nyoo nyēbo koonyit miisin kuchamta icheek ꞉Yēyiin kule kunyāliil ām kaayneetaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kitas taay ꞉lēbkēēyichoo kutēē yēē tēē ꞉bēsyōōsyēk kōōnēētiisyē ānkwoomtootē lōkōōywēk chēē kāroomēch ām biiwuutaab *Kōōtaab Yēyiin āk mbo kung'eetee kōōto ake ākoy ake, kumwooyootē kule *Kāārārookiintēēt ꞉Yēēsu nyoo kimākōōyook ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ām bēsyōōsyēchooto yu kimii kuwōōyiitu ꞉laatitaab biikaab Kiriistō, kooteeyee keey ꞉Yuutayeek chēē king'āloolē kuutiitaab Kirikiik kule /kikēēbulbulē chēēbyōōsōōk choo ki Iburaneek /ānkēēsāsē chēēbyōōsōōkwaa chēē ki musuk ām wōlēē /kikēēbchēwuntooy āmiik. ");
INSERT INTO spyNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yooto, kōōruruuch *꞉lēbkēēyichoo ki taman āk āyēēng' bichooto tukul ānkumwooy kule, “Mēēbērē ng'ālyoo nyēbo man, yoo kakeebakaakte kyaamte ng'ālyoontēētaab Yēyiin ānkēēswēē ng'aleekaab āmit kityō. ");
INSERT INTO spyNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kunyoo ii, mbo ng'eetaabiya, okwey biiko tisab chēē tookunootiin kule /kiikiinyiityi Tāmirmiryēētaab Yēyiin ānkung'oomēch. Mākuwuulyēē ꞉bichooto ng'aleechuutēchu. ");
INSERT INTO spyNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nteenee +mākēēwuulyēē ꞉acheek saayeet āk ng'ālyoontēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","King'ērēkyi ꞉biiko tukul ng'aleechaa. Yooto, /keekwey Steefaan (kiikoosēē keey ꞉inee Yēyiin miisin anku /kikiinyiityi Tāmirmiryēēt), Filibō, Burokooro, Nikanoor, Timoon, Barmeena ākoo Nikolaawo (nyēē kibo *kiriinkēētaab Antyookya nyēē kikiikuweech keey kusaay Yēyiintēētaab Yuutayeek). ");
INSERT INTO spyNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yooto, /kēēkwērchi bichoo lēbkēēyik kusoochi ānkutiinyēē āwunnyēk. ");
INSERT INTO spyNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","/Kikyaamtaat ng'ālyoontēētaab Yēyiin kuyēstoochi kōōrēēt. Kitas taay ꞉laatitaab biikaab Kiriistō kuwōōyiit ām Yēērusālēēm ankuchamta ꞉mbo *kibkōrōs wōlēē wōō Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kiibēruuroot ꞉Steefaan ānkiboonto kāāmuukēywēēk miisin. Kiyey ꞉chiichoo ng'al chēbo kwōng'uut ānkōōboor tukuuk chēē /kiilātē ām wōlēē mii ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kimii ꞉Yuutayeek alake chēē kikuurē keey kule ‘Biikaab *kōōtaab saayeet chēē /kiikiityaakta’ ānkibo kōōrēētaab Kurēēn āk Alekisaantrya āk mbo yēēmōōsyēkaab Kiliikya āk Eesya. Kikwiil ꞉bichoo Steefaan. ");
INSERT INTO spyNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nteenee kimēēmuuchē kuyityi ng'oomnānēētaab Steefaan āk mbo Tāmirmiryēēt nyēē kiikoochinē kāāmuukēywēēk ām wōlēē king'ālooltooy. ");
INSERT INTO spyNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yooto, kumwoochi ꞉bichoo biiko chuut alak kumwaayaat kule kiikukas Steefaan kung'āloolēē *Muusa āk Yēyiin nyēē miyaat. ");
INSERT INTO spyNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kiiwuruur ꞉bichooto biiko chuut kunam wōlēē mii ꞉booyik āk kāānēētikaab kiruutēk. Yooto, /keenam Steefaan /ānkēēkwēryoot ākoy kōōk, ");
INSERT INTO spyNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","/ānkubokēēmōlōlchi ng'al chēē manaayey. Kimwooy ꞉bichooto kule, “‑Mākustēē ꞉chiichi kung'āloolēē *Kōōtaab Yēyiin nyēē miyaat āk mbo nkicheek kiruutēk. ");
INSERT INTO spyNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kookeekas kumwooyē kule makooburyeet ꞉chiichi /kēēbērē Yēēsu nyēbo Nāāsārēēt kōyi bo Yēyiin ankuweech ātēbuutēk choo kirōōbwēēch *꞉Muusa.” ");
INSERT INTO spyNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kiirōōtoot ꞉kōōkwoonoo tukul Steefaan. Yooto, kukas kule kerkeey ꞉eernyii āk nyēbo *malayikeet. ");
INSERT INTO spyNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nto mii yoo, kuteebee *꞉kibkōrōs nyēē wōō Steefaan kule, “Man ꞉ng'aleechu /kēēmwooyē kurubta keey āk inyiing'?” ");
INSERT INTO spyNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yooto, kukēt ꞉Steefaan kule, “Mbo araaba āk mbo baaba. Ōyēbchi yiit baa kiyēē āmiitē wāāmwoowook. Kichōōnchi ꞉Yēyiin nyoo tōrōōr baaba Abraam, yoo kitākumiitē Meesobotaamnya kutākutoombo wokuminyē Araan. ");
INSERT INTO spyNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kimwoochi ꞉Yēyiin Abraam kule, ‘Ibakaakte biikwook āk kōōrēēng'uung' 'ānkiiwē ākoy kōōrēēt nyēē +māābooruung'.’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kunyoo, kung'eetee ꞉Abraam kōōrēētaab Kaltaayeek ānkuwuuchi *kiriinkēētaab Araan. Yu kāwokume ꞉kwaan, kung'eetee ꞉Abraam kiriinkoonoo bo Araan ānkōōwuuw ꞉Yēyiin kuchō kōōrooniitēnyi ōminyē ꞉akweek. ");
INSERT INTO spyNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mēēbērē kirōōbchi ꞉Yēyiin Abraam kiy mbo akeenke ām kōōrooniitēnyi kule kuyēk nyeenyii ānkoo mbo kētiin nyēbo mbar. Nteenee kikuurtoochi ꞉Yēyiin Abraam āk biikyii chēē makookeer inee kule mākuyēk nyeeng'waa ꞉kōōroonooto ānkoo kimānāānyōōr ꞉Abraam leekwa yooto. ");
INSERT INTO spyNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kimwoochi ꞉Yēyiin Abraam kule, ‘Makuba ꞉biikaab mooyēēng'uung' bokuminyoot kōōrēētaab biiko alak ānkuyēkunoot motwoor. Mākunyāliil kēnyiisyēk bokolwookik ang'wan. ");
INSERT INTO spyNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nteenee +māāng'woonchi biiko chēē kayey icheek kuyēk motwoor. Nto yityo, mākuwuuwunēē kōōroonooto ānkubokukutung'woo ām yuutēyu.’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nto mii yoo, kōōkoochi ꞉Yēyiin Abraam kiirootyeetaab *kāāmurootāniisyēēt. Yooto kunyōōr Abraam wērinyii Isaka. /Kiimuraatan wēēroo kutinyē bēsyōōsyēk sisiit kuchakee /kākēēsich. Nto mii yoo, chokunyōōr ꞉Isaka Yāākōbō. Kichokusich ꞉nkinee Yāākōbō mbo kuuko taman āk āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kiituuyiityi mbo ꞉kuuko chuut Yōōsēēf moo. Yooto, kwooltoochi kōōrēētaab Miisir wokuyēk motwooriin. Nteenee kiyēētyēēchi ꞉Yēyiin Yōōsēēf kumii wōlooto ");
INSERT INTO spyNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ām wuuyin ake tukul nyēē kinyōōr. Kiikoochi mbo subak ng'oomnānēēt ankuyey bāytooyiintēētaab Miisir kung'ērēkyi Yōōsēēf kut kuyey inee kubayta kōōroonooto ānkōōyyoonkyi kiy ake tukul ām kanyii. ");
INSERT INTO spyNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nto mii yoo nanyuun, kuchō ꞉kēmēwuut Miisir kumukuul nyēē wōō miisin ākoy mbo kwoochi kōōrēētaab Kanaan. Kilal ꞉kēmēwuunoo biiko nyēē ‑/mākyoomu. Kimāmii wōlēē kiimuuchē kunyoorta mbo kuuko kiyēē kaam. ");
INSERT INTO spyNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yu kawokukas ꞉Yāākōbō kule kimiitē ꞉āmiik Miisir kōōyookto kāābkōōnyoo chuut kuba wōlooto nyēbo taay. ");
INSERT INTO spyNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ām baanta nyēbo āyēēng', kōōboorchi keey ꞉Yōōsēēf murēchuutēchu. Yooto, kōōnkēt *꞉Faraawo biikaab mbo Yōōsēēf. ");
INSERT INTO spyNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yu kāākuyēyākiis ꞉ng'aleechu, kōōyookto ꞉Yōōsēēf /bokēēkuurchi kwaan āk biikaab kōōng'waa tukul. Kiyitē ꞉kayaa tukul biiko tāmānwookik tisab āk muut. ");
INSERT INTO spyNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yooto, kuwēēto ꞉Yāākōbō kāābkōōnyoo tukul Miisir. Kiminy ꞉icheek wōlooto ākoy kubēk ꞉biiko tukul choo kibo taay. ");
INSERT INTO spyNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ānkoo kuwuu nyooto, /kikeeketita bōōrwēkwaa ām lētuunoo /ānkubokiitōōr wōlēē bo kochonkeet nyēē kikiikusimkwaalee ꞉Abraam wērikaab Amoor ām Syēkēm ām laatitaab beesaanik. ");
INSERT INTO spyNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Yu kimii kuriiku ꞉bēsyōōsyēk, kootyiich ꞉Yēyiin kuu yoo kikiikukuurtoochi Abraam, kuyēk ꞉biikyoo sērē ām Miisir. ");
INSERT INTO spyNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yooto, kubāytooyiis ꞉chiito ake nyēē kimēēnkētē kiy ake tukul kurubta keey ākoo Yōōsēēf. ");
INSERT INTO spyNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kwoowēsyi ꞉bāytooyiintoonoo biikyoo ankoonyaliil. Kimāchē kule kumētooy ꞉biiko lēēkōōk chēē /kātākiibuutu sukubēk. ");
INSERT INTO spyNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","/Kikēēsichē *Muusa ām bēsyōōsyēchooto ānkiibēruuroot ām wōlēē mii ꞉Yēyiin. /Kikeebayee kang'waa kō ām ārook sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yu /kabokiichuuw kuchō saang' /kēēmāchē /kēēmēto, kunam ꞉chēēbtaab Faraawo Muusa ankuyey kuyēk lakwanyii. ");
INSERT INTO spyNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","/Kikiineet Muusa ng'oomnān ake tukul ām Miisir kuyem. Kikōrōōm ꞉Muusa ām wōlēē king'ālooltooy āk wōlēē kiyēytooy yiisyēēnyii. ");
INSERT INTO spyNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Yu kiboonto ꞉Muusa kēnyiisyēk artam koosoot kuruutoochi biikyii bo Isrāyēēl. ");
INSERT INTO spyNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yooto, kukas chiinyii ake nyēē kimii kōōnyāliilē ꞉chiitaab Miisir. Kuwo ꞉Muusa bakeenke ankubakach chiichoo kibo Miisir kusār chiinyii. ");
INSERT INTO spyNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kiisōōtē ꞉Muusa kule tōōs kiimuuchē kōōnkēt ꞉biikwaa kule kimii ꞉Yēyiin kuyēyiisyēē inee kootyaakta icheek, nteenee kimēēnkētē ꞉biikyii. ");
INSERT INTO spyNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yu kāyyēēkunēē, kukas ꞉Muusa biikaab Isrāyēēl alak āyēēng' chēē kimii kuboortōōs. Kusyeem kumwoochi kule, ‘Murēchu, nto yu koo-am keey nkosyur ānkōōbooyē mooyēēt akeenke!’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nteenee kuwunukto Muusa ꞉chiito nyēē kikiikulālchi nyiin ānkumwoochi kule, ‘Ng'oo ꞉nyēē katooling' ibayteech? Inyiing' ꞉kētiintēēt? ");
INSERT INTO spyNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Imāchē ibara kuu wōloo 'kwēēbākāktooy Miisiriintēēt?’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yu kakas ꞉Muusa ng'aleechaa, kumwēy. Kimwēchi kōōrēētaab Miityaan. Kiibuur wōlooto kut kunyōōr wērikyii āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yu kāwokukeeyta ꞉kēnyiisyēk artamu, kuchōōnchi *꞉Malayikeetaab Yēyiin Muusa ām suurkwēēnēēt yēē kōōrikitiitēē ꞉maata ām sōntiit ake. Kilēēkitēē ꞉yooto Tulwēētaab Sinaay. ");
INSERT INTO spyNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nto bērē kukas ꞉Muusa kiyooto, kwaam mēt. Kōōnookyi kule kukas nyēē karaam. Yooto, kukas kuutiitaab Yēyiin nyēē kimii kukuuru ");
INSERT INTO spyNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","kule, ‘Anii ꞉Yēyiintēētaab mbo kuukoong', Yēyiintēētaab Abraam, Isaka ākoo Yāākōbō.’ Kibootan ꞉Muusa ām muyātēēt kut manaamach takukas yooto subak. ");
INSERT INTO spyNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yooto, kumwoochi ꞉Yēyiin Muusa kule, ‘Irēēku kwēyōōnik, kuuyu imiitē iyyoonyēē yēē tiliil. ");
INSERT INTO spyNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kaakas kubooyiit man wōlēē /kēēmii /kiitiing'tooy biikyuu ām Miisir āk wōlēē mii kōōtēēytooy. Kāārēku ꞉anii chaatyaakte kunyi, āmiitē wāāyooktiing' ākoy Miisir.’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ki Muusa nyiitēnyi ꞉nyooto /kikēētāyē /kēēmwoochinē kule, ‘Ng'oo nyēē kākōōning' kāāmuukēywēēkaab bāytooyiisyēēt āk chēbo kētiisyēēt?’ Inee mbo subak ꞉nyooto kiiyooktooy ꞉Yēyiin wokubayta ānkusār biikaab Isrāyēēl. Kikwēryootē Muusa ꞉Malayikeetaab Yēyiin nyoo kichōōnchinē ām yoo kibo sōntiinoo. ");
INSERT INTO spyNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kikwēryoon ꞉Muusa bichoo kung'ēētyēē Miisir kukaakuyey ng'al chēbo kwōng'uut ām wōlooto āk yoo kibo Araarayta nyēē Arraa āk mbo ām kēnyiisyēk artam choo kimii ꞉biikyoo suurkwēēn. ");
INSERT INTO spyNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ki Muusa ꞉nyiitēnyi nyoo kimwoochinē biikaab Isrāyēēl kule, ‘Mākukōōnook ꞉Yēyiin *wōōrkooyoontēēt nyēē wuu anii kuchōōnēē wōlēē miitē ꞉biikwook.’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kiboonto keey ꞉Muusa āk biikyoo ām wōlooto bo kōōr nyēē suurkwēēn. Kiboonto keey mbo kuuko ākoo mbo Malayikeetaab Yēyiin nyoo king'āloolchinē inee ām yoo kibo Tulwēētaab Sinaay. Kinyōōr yooto ꞉Muusa ng'al chēbo soboon chēē kirōōbwēēch. ");
INSERT INTO spyNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nteenee kichuunnyēē mbo ꞉kuuko ng'aleekaab Muusa ankookaykaay kooyeey Miisir. Kitay ꞉icheek Muusa ");
INSERT INTO spyNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ānkumwoochi *Āārōn kule, ‘So, kāwokwaam ꞉nee Muusa nyi kiirēētoonunēēnēēch Miisir? Kunyoo, chēēyēwēēch āynātēēt nyēē sukōōrēētootēēch.’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yooto yēē sukuyey ꞉bichooto kiito nyēē kerkeey mooyta. Kiyibu tukuuk chēē /kibokēēsooytooy ānkuyēyē sookwoonuutēk ānkung'ērēkyinē kiyēē kiyēyēē āwunnyēkwaa. ");
INSERT INTO spyNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yooto, kōōtuukyi ꞉Yēyiin batay kukutunkyinē icheek asiista, araaweet ākoo kookeelik. Tooku ꞉yuutēyu ām yoo /kikeesir ām kitaabuutaab *wōōrkooyik kule, ‘Kāālē ii, kōōtaab Isrāyēēl, ara kyōōkwērwoo tyoony bo kōrōs āk tuwēnuutēk ām kēnyiisyēk artam choo kyōōmiitē suurkwēēn? ");
INSERT INTO spyNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Acha! Kyoong'eet, okalab kēryēētaab *Moolek āk kookeelyeetaab āynātēēt Reefaan tukuuchoo kyōōyēyē kule sōōkutunkyinē. Kunyoo, +maakwetaak bookeeytee kiriinkēētaab Bābulōōn kut booyit kōōr nyēē mā nyēēng'woong'.’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kiboonto mbo ꞉kuuko *Kēryēētaab Yēyiin ām wōlooto bo suurkwēēn. Kikiyey ꞉Muusa kēryoonoo kuu wōlēē kimwooytoochi ꞉Yēyiin āk wōlēē kikiikōōboorchinto. ");
INSERT INTO spyNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yu kābokunyōōr mbo ꞉kuuko kēryoonoo, kukwaanta kōōntōōchinē ꞉Chooswa. Kikwaanta kēryoonooto yu kibokunāmē kōōrēētaab biiko choo kikwētē ꞉Yēyiin kukāsē mbo ꞉kuuko. Kiibuur ꞉kēryoonoo kuu nyooto ākoy bēsyōōsyēk choo kichokubāytooyiisyē *꞉Tāwuti ");
INSERT INTO spyNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","nyoo king'ērēkyi ꞉Yēyiin. Kimwooy ꞉Tāwuti kule mākuyēytoochi ꞉inee Yēyiintēētaab Yāākōbō wōlēē mākuminy. ");
INSERT INTO spyNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nteenee ki Sōlōmōōn nyēē kichokutēēkyi Yēyiin Kōōto. ");
INSERT INTO spyNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ānkoo kuwuu nyooto, mēēbērē minyē ꞉Yēyiin koorin chēē tēēchē ꞉biiko. Kuu yoo mwooyē *꞉wōōrkooyoontēētaab Yēyiin kule, ");
INSERT INTO spyNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mwooyē ꞉Yēyiin kule: Ābāytooyiisyoowunēē barak ānkuyitu ꞉kērēēnkōōkyuu ng'wēny. Kunyoo, kō nyēē wuu nee ꞉nyēē ōmāchē ōtēēkwoo? Nto ānō ꞉wōlēē ōmwooyē kule āmuunyēē? ");
INSERT INTO spyNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mā anii ꞉nyēē kyāāyēyē tukuuchu tukul?’ ");
INSERT INTO spyNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kunyoo ii, wuuyēch sōō mētēwookwook nyēē tyaa nyēē ‑mōōkāsē ng'al! Okerkeeye mbo kuukoong' ꞉akweek chu ōkwiilē Tāmirmiryēētaab Yēyiin kwaak. ");
INSERT INTO spyNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mii *꞉wōōrkooyoontēētaab Yēyiin nyēē mānāāwus mbo ꞉kuukoong'? Kibakach mbo choo king'ōōrē kule mākuchō ꞉Chii nyēē Churtaat. Ānkoo mbo raat kuu nyiitēnyi koochaamte ankoobakach ꞉akweek Nyooto Churtaat. ");
INSERT INTO spyNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kyōōnyōōru kiruutēkaab Yēyiin kubununēē malayikaanikyii, āmēēbērē ōrubē!” ");
INSERT INTO spyNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Yu kabokukas ꞉bichoo ng'aleechaa kimwoochinē ꞉Steefaan, kunyēērchi ankunyiy mooriik nyēē kāng'woonchi. ");
INSERT INTO spyNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","/Kiinyiityi Steefaan Tāmirmiryēētaab Yēyiin ankukas barak. Kukas lēbkēēyyēētaab Yēyiin ankukas Yēēsu nyēē kimii kēēyyoonyēē āwutaab taay nyēbo Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kumwooy ꞉Steefaan kule, “Okas baa, kaakuyaatakay ꞉wōliin bo barak. Miitē *꞉Wēritaab Chii kēēyyoonyēē āwutaab taay nyēbo Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yooto, kuker ꞉bichoo yiitiikwaa kukatay ng'aleekaab Steefaan ānkubōlchi barak miisin. Kutuchinē ꞉bichooto tukul Steefaan ");
INSERT INTO spyNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","/ānkiichuutootē ākoy kiriing' saang'. Kiirēēk ꞉bichoo kāāliikoonikwaa ānkōōtōōrchi āybēēryoontēēt ake nyēē /kikēēkuurēē Sāwulō kuriib. Nto yityo, kutoow kuwiiree Steefaan rwoontōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kitas taay ꞉bichoo kuwiir Steefaan nto yityo, kusaay ꞉Steefaan kule, “Mokoryoontēēt Yēēsu, itaach tāmirmiryēēnyuu.” ");
INSERT INTO spyNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kikutuny ānkukuurchi barak kule, “Mokoryoontēēt, ‑'meenaamte bichu ng'ōōki!” Kubēkunēē ꞉ng'aleechaa kuutiinyii kung'ētē. ");
INSERT INTO spyNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kichamta ꞉Sāwulō meetaab Steefaan. Ām bēsyoonooto, /kēēwus kaniseetaab Yēērusālēēm nyēē ‑/mākyoomu. Kisērētyi ꞉biiko chēē chaang' yēēmēētaab Yuuteeya āk nyēbo Samaaryaa. Nteenee king'ētunēē *꞉lēbkēēyik Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kimii ꞉biiko alake chēē kikoonyitē Yēyiin. Kiriiree ꞉bichoo Steefaan miisin nto yityo bokumuy. ");
INSERT INTO spyNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yooto, kutoow ꞉Sāwulō kwaaraantaat biikaab Kiriistō nyēē ‑/mākyoomu. Kiwēētootēē kō ake tukul kunāmootē murēnik āk chēēbyōōsōōk wokukērtooy kō. ");
INSERT INTO spyNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kyaamtaatee ꞉bichoo kisērēētōōs ng'ālyoontēētaab Yēyiin wōlto ake tukul wōloo kiba. ");
INSERT INTO spyNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Kiwo ꞉nkinee Filibō ākoy *Samaaryaa ankuwokwaamtee wōlooto lōkōōywēk chēē rubtooy keey āk *Kāārārookiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yu kawokukas ꞉biiko ng'aleek chēē kyoom ꞉Filibō āk tukuuk chēē /kiilātē chēē kiyey, kuyēbchi yiit ām kēēlto nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","/Kikiibēbēēto tāmirmirook chēē miyootēch kung'ēētyēē biiko wōlēē wōō. Kiwookyinē barak yu ng'ēētyēē bichoo. /Kikiisoob mbo chēē kisōnkōchootiin āk chēē kiing'wooltōōs. ");
INSERT INTO spyNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kunyoo, king'ērēkiis ꞉biiko ām kiriinkoonooto kumukuul. ");
INSERT INTO spyNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kimii ꞉chēēbsookēyoontēēt ake kiriinkoonooto nyēē /kikēēkuurēē Simōōni nyēē kiyēyē mosoonkoyeenikyii. Kiyey ꞉chiichoo kuu nyooto kut kikiikoolat ꞉biiko miisin ām *Samaaryaa. King'āsē keey kule inee ku chii nyēē wōō miisin. ");
INSERT INTO spyNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kunyoo, kiiywēyē ꞉biiko tukul chiichi kunam wōlēē mii ꞉chēē wōōyēch ām komostaab bāytooyiisyēēt āk mbo chēē minkēēch. Kiyēbchi yiit kāroomin ānkumwooy kule, “Boonto ꞉chiichi kāāmuukēywēēk kukwaanee wōlēē mii ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","/Kikēērubootē chiichooto, kuuyu kikiikuyey ng'al chēbo kwōng'uut kunyil chēē chaang' ām mosoonkoyeenikyii. ");
INSERT INTO spyNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nto yu koom ꞉Filibō lōkōōywēk chēē kāroomēch chēē rubtooy keey āk bāytooyiisyēētaab Yēyiin āk chēbo Yēēsu *Kiriistō, kōōyēnchi ꞉bichoo lōkōōywēchoo /ankeebatisan. /Kikeebatisan bichoo tukul kunam wōlēē miitē ꞉booyik āk chēēbyōōsōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kiiyēnchi ꞉nkinee Simōōni Yēēsu /ankeebatisan. Yooto, kurubaat ꞉Simōōni Filibō ām wōlto ake tukul. Kiimuuy miisin ꞉tukuuk chēē kikas kuyēyāktōōs. ");
INSERT INTO spyNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yu kabokukas *꞉lēbkēēyik ām Yēērusālēēm kule kaakuchamta ꞉biikaab *Samaaryaa ng'ālyoontēētaab Yēyiin, kōōyookto Bētērō ākoo Yoowaana kuba wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Yu kabokuyit ꞉icheek, kusoochi kule kunyōōr bichoo Tāmirmiryēētaab Yēyiin. Kisaay kuu nyooto, ");
INSERT INTO spyNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kuuyu kitākutoombo kut kurārākyi bichooto ꞉Tāmirmiryēētaab Yēyiin. /Kikiikeebatisan baateey ām kaayneetaab Mokoryoontēēt Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kitiinyēē ꞉Bētērō āk Yoowaana bichoo āwunnyēk. Yooto, kuchōōnchi bichooto ꞉Tāmirmiryēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nto yu kawokukas ꞉Simōōni kule kinyōōru ꞉biiko Tāmirmiryēēt yoo kātiinyēē ꞉lēbkēēyichoo āwunnyēk, kumwoochi kule, ");
INSERT INTO spyNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“+Māākwēwook beesaanik, yoo kōōkōōnoo kāāmuukēywēēchu sukung'eet yoo kāātiinyēē ꞉nkanii chii ake tukul āwunnyēkyuu, kunyōōr Tāmirmiryēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kukētyi ꞉Bētērō ꞉chiichooto kule, “Iwē kut wee-aran āk beesaanichaakuuk! Isōōtē kule /kiimuuchē /kyaalee rōōbtooywoontēētaab Yēyiin beesaan? ");
INSERT INTO spyNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","‑Meeyemaat iyey yiisyooni, kuuyu ‑meechuulaat ām wōlēē mii ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kunyi, iweekse ām miyootyooni ankiisaay Yēyiin. Imuuchē kunyōōwuung' ꞉Yēyiin kaat ām kāāsōōtēywēēkuuk choo miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ākāsē tuuyintaab moo nyēē iboontē anku kiikoolaambuuchiing' ꞉choolwookātēēt.” ");
INSERT INTO spyNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kumwooy ꞉Simōōni kule, “Lēyyē, ānkōōsoowoo sukung'eet māyēyākiis ꞉ng'aleechaa kōōmwooyē ām wōlēē āmiitē.” ");
INSERT INTO spyNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yu kāākōōrwookyi ꞉Bētērō āk Yoowaana biiko ām *kiriinkēētaab Samaaryaa, kwoomchinē ng'ālyoontēētaab Yēyiin, kooyeey Yēērusālēēm. Kyaamtaatee lōkōōywēchu kāroomēch soong'wēk chēē chaang' ām yēēmēētaab Samaaryaa. ");
INSERT INTO spyNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nto mii yoo, kumwoochi *꞉malayikeet Filibō kule, “Iwē komostaab cheeronko kut inyōōru kēēlto nyēē baraay ām suurkwēēnēēt, nyēē rēktēē Yēērusālēēm ākoy *kiriinkēētaab Kaasa.” ");
INSERT INTO spyNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kunam ꞉Filibō baanta nto kēchinē kēēloo baraay, kukas chiito ake nyēbo kōōrēētaab Etyoobya kumii kōrōkōchēēnyii kuchōōnēē kusooyē Yēyiin ām Yēērusālēēm. Ki chii nyēē wōō ām kōōrēēng'waa /ānkikiikoosēē keey. Kiiyyoonkyinē lēnkuutaab beesaanik chēbo cheebyoosyeet ake nyēē /kikēēkuurēē Kantaake nyēē ki bāytooyiintēētaab kōōroonooto. ");
INSERT INTO spyNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kimii ꞉chiichoo kusumānchinē barak kitaabuutaab *wōōrkooyoontēētaab Yēyiin *Isaaya. ");
INSERT INTO spyNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yooto, kumwoochi ꞉Tāmirmiryēētaab Yēyiin Filibō kule, “Iwē baa, yuun mii ꞉kōrōkōchooniin bo chiichiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kulabat ꞉Filibō ākoy yooto ankukas chiichoo kusumānē lōkōōywēk chēbo kitaabuutaab Isaaya. Kuteebee ꞉Filibō kule, “Ikāsē man kiyēē āmu ꞉lōkōōywēchoo?” ");
INSERT INTO spyNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kukēt ꞉chiichoo kule, “Ānkētēē nee yēē māmii ꞉chii nyēē kēēbāng'boong'woo? Ānkiichōō naas ōō, murooni chēēbuurēē yu.” ");
INSERT INTO spyNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kimiitē ꞉chiichooto kusumānē yēē mwooyē kule, “/Kikēēkwēryoot kuu kēēchiir ākoy yēē /bokēētilēē, kuu kuuchoo nyēē ‑mēēyitē yoo /kēētilchinē sabureekyii, mēēbērē king'aany kuutiinyii. ");
INSERT INTO spyNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","/Kikeemoonta /ānkēētāchi manta. Mātinyē biich chēbo siintaaryeenyii, kuuyu /kikiinēm soboonnyii ām kōōrooni.” ");
INSERT INTO spyNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yooto, kumwoochi ꞉chiichooto kibo Etyoobya Filibō kule, “Murooni, mwoowoo baa, ꞉inyiing', mii kung'āloolēē keey *꞉wōōrkooyoontooni nto ng'āloolēē chiito ake?” ");
INSERT INTO spyNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Koonaamee ꞉Filibō yooto bakeenke ānkwoomchi chiichooto lōkōōywēk chēē kāroomēch chēē rubtooy keey āk Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kumii ꞉tukwaay kubēētii ām kēēltaab too, kuyit yēē kimii ꞉bēēko. Yooto, kumwoochi ꞉chiichooto Filibō kule, “Kas, nto yu bēēko ꞉chu. Nee ake ꞉nyēē tākumāchāktōōs /sikeebatisanaa?” ");
INSERT INTO spyNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yooto bakeenke, kōōyyoong'to ꞉chiichooto kōrōkōchoonoo. Kurēk ꞉tukwaay ānkurēkto āyno ankubatisan ꞉Filibō. ");
INSERT INTO spyNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yu kābokuloong'unēē āyno, kusar ꞉Tāmirmiryēētaab Yēyiin Filibō areet akeenke ānkuwēēto. Manaawokukas ꞉chiichoo Filibō subak, nteenee kitas taay āk baannyii ām ng'erekweek. ");
INSERT INTO spyNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","/Kibokēēkāsyi Filibō *kiriinkēēt ake nyēē /kikēēkuurēē Asooto. Kiwēēsyētootēē kiriinkōōsyēk tukul ām yēēmoonoo kwoomtootē lōkōōywēk chēē kāroomēch ākoy wokuyit *kiriinkēētaab Kayisareeya. ");
INSERT INTO spyNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kitākumii ꞉Sāwulō kwoorēētānē kumāchē koonyokoorta ankubakach rubiikaab Yēēsu. Kuwo ākoy kaab kibkōrōs nyēē wōō ");
INSERT INTO spyNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ānkuwokusoom kōōkoochi bārōōnōōk chēē /kikēēsirchi kāāyyoong'ikaab kooriikaab saayeet ām Tamaasko. Kimāchē bārōōnōōchoo sukuchāmchi kunam chii ake tukul nyēē kiikurub kēēltaab Yēēsu, anku murēn nto koorko sukukwēryoot Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yu kariikta Tamaasko, koowech ꞉lēbkēēyyēēt ake nyēē kichōōnēē barak ankoolaambuuch Sāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kōōryookyi keey ng'wēny nto yityo kukuur ꞉kuutiit ake kule, “Sāwulō, wē, Sāwulō, 'kēē-āmchoo nee?” ");
INSERT INTO spyNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kulē ꞉Sāwulō, “Inyiing' ku ng'oo ōō, mokoryoontēēt?” /Kēēmwoochi kule, “Anii ku Yēēsu nyooto imiitē ibārē. ");
INSERT INTO spyNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kunyi, ng'eet ānkiiwē ākoy wōliin bo kiriinkēēt ankuweeyey kiyēē +/mābokiibooruung'.” ");
INSERT INTO spyNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kiboontootē keey ꞉Sāwulō biiko alak ām baanaa. Kinam kuut baateey bichoo ꞉kiyēē kiyeyakay. Kikāsē ꞉bichoo baateey /kēēkuuru ng'aleechaa, āmēēbērē kiinkētē kule kikwoonēē wōlēē mii ꞉ng'oo ānkimwooyē nee. ");
INSERT INTO spyNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Yooto, kung'eet ꞉Sāwulō. Nto bērē kung'aany koonyek, kumākāstooy. /Keenamaat āwut /ānkiirēētoot ākoy Tamaasko. ");
INSERT INTO spyNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kiibuur wōlooto bēsyōōsyēk sōmōk nyēē mākāstooy āmēēbērē kyoomē nto kuyye kiy ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kimii ꞉rubiintēēt ake nyēbo Yēēsu wōlooto bo Tamaasko nyēē /kikēēkuurēē Anannyaa. Kukuurchi ꞉Mokoryoontēēt ām ng'oong'uutyēēt kule, “Anannyaa!” Kōōyēn kule, “Wōōy, Mokoryoontēēt!” ");
INSERT INTO spyNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kumwoochi ꞉Mokoryoontēēt kule, “Iwē ākoy kaytaab chiito ake nyēē /kēēkuurēē Yuuta ām yēbo kēēloo /kēēkuurē kule ‘Nyēē Rootaat’. Yoo keeyit kayaata, iteeb chiito ake nyēē /kēēkuurēē Sāwulō nyoo bo Taarso. Miitē ꞉chiichi kusooyē ām wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kāāboorchi ām ng'oong'uutyēēt kule mii kuchōōnii ꞉chiito ake nyēē /kēēkuurēē Anannyaa nyēē mii wokutiinyēē inee āwunnyēk sukukasta subak.” ");
INSERT INTO spyNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kukēt ꞉Anannyaa kule, “Mokoryoontēēt! Nto yu kyaakas ng'aleek chēē chaang' chēē rubtooy keey āk chiichi. Kyaakas mbo tāng'āng'uutēk chēē kiikuyibchi ꞉chiichi biikuuk ām Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kwēēkoochi ꞉mbo *kibkōrōs chēē wōōyēch kāāmuukēywēēk kuchō wōli chokunam chii ake tukul nyēē kiikōōyēnuung' ām wōliitēnyi bo Tamaasko.” ");
INSERT INTO spyNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nteenee kimwoochi ꞉Mokoryoontēēt Anannyaa kule, “Iwē ankuweeyey kuu wōloo āmwooytoowuung'. Kāākuyēk ꞉chiichi kēēlnyuu nyēē /kaakeekwey sukuyityinēē ꞉lōkōōywēk biiko chēbo kōōrōōsyēk alak āk mbo nkicheek bāytooyikwaa āk biikaab Isrāyēēl. ");
INSERT INTO spyNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","+Māāboorchi ꞉anii kule makutang'any miisin, kuuyu makwaamtaat lōkōōywēk kurubta keey ākoo anii.” ");
INSERT INTO spyNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nto mii yoo, kuwo ꞉Anannyaa ānkuwokōōwut kōyooto. Kitiinyēē Sāwulō āwunnyēk kumwoochinē kule, “Araaba Sāwulō, kāākōōyookwoo ꞉Mokoryoontēēt Yēēsu nyoo kichōōnchiing' imiitē ichōōnii wōliitēnyi. Kēēyookwoo sukung'eet ikaste kuu kwaak /ānkiinyiituung' Tāmirmiryēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ām areet akeenke, kōōsuuwunēē ꞉tukuuk alake koonyekaab Sāwulō chēē wuu kebeemberik ankukasta. /Kikeebatisan, ");
INSERT INTO spyNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","nto mii yoo, /keebay. Yooto, kukēt keey ꞉nkuruukyii. Kiibuur ꞉Sāwulō Tamaasko āk rubiik chuut ām bēsyōōsyēk chēē ng'ēri. ");
INSERT INTO spyNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nyēē mā tyaa, kutoow kwaamtaat lōkōōywēk ām kooriikaab saayeet kumwoochinootē biiko kule, “Lakwataab Yēyiin ꞉Yēēsu.” ");
INSERT INTO spyNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kiilat ꞉biiko tukul chēē kikas ng'aleechaa /ankeeteebee keey kule, “So! Mā chiichi ꞉nyoo kimāchē koowaang'ta biiko choo kikiikōōyēnchi Yēēsu ām Yēērusālēēm? Mēēbērē kāmii kuchōōnii wōli chokunāmē bichooto sukukwēryoot kurātootiin ākoy wōlēē mii ꞉mbo kibkōrōs chēē wōōyēch?” ");
INSERT INTO spyNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kyaamta ꞉Sāwulō ng'ālyoontēētaab Yēyiin ām kiirnātēēt miisin nyēē māmii ꞉kiyēē kiimuuchē ꞉icheek kuwāl. Kimwoochinē Yuutayeek chēē kiminyē Tamaasko ām kēēlto nyēē yemaat kule *Kāārārookiintēēt ꞉Yēēsu nyēē chōōnēē wōlēē mii ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yu kabokukeeyta ꞉bēsyōōsyēk chēē chaang', kōōruruuch keey ꞉Yuutayeek ankubokusat wōlēē makubakakta Sāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nteenee kiinkēt ꞉Sāwulō kiyēē kimii ꞉bichooto kuchōbē. Kikēēyānootē ꞉bichoo Sāwulō bēēt āk kwēēmooy kukāsē ōrootunwēēk tukul chēbo kiriinkoonooto, kumāchē kule nto kas wōlēē kachuwunee sukunam ankubakach. ");
INSERT INTO spyNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nto mii bēsyēēt ake kwēēmooy, kunam ꞉biikyii kumii mōōnti ānkōōyokooytēē tiriisyeet nyēē kimii tōōtēētaab kiriinkoonoo. ");
INSERT INTO spyNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Yu kāwokuyit ꞉Sāwulō Yēērusālēēm, kusyeem kule kōōyoomo keey ākoo rubiikaab Yēēsu. Nteenee kiing'ōōyēnēē keey ꞉rubiik inee kuuyu kimanaachamta kule kikiikuyēk ꞉Sāwulō rubiintēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kinam ꞉Barnaaba Sāwulō ānkukwēryoot ākoy wōlēē kimiitē *꞉lēbkēēyik. Kirārchi ꞉Barnaaba lēbkēēyichoo wōlēē kikasta ꞉Sāwulō Mokoryoontēēt kumii kēēltaab too kuwēētii Tamaasko. Kimwooy mbo subak kule king'āloolchi ꞉Mokoryoontēēt Sāwulō. Kiiboorchi wōlēē kyoomtoochintooy ꞉Sāwulō biiko lōkōōywēk ām Tamaasko kuyēyiisyēē kaayneetaab Yēēsu nyēē kimā nyokoor. ");
INSERT INTO spyNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kunyoo, kōōbuurto keey ꞉Sāwulō lēbkēēyichoo kubēēsyētootē ꞉tukul nyēē kimēēng'ōōyēnē keey. Kiwēēsyētootēē Yēērusālēēm kwoomtootē lōkōōywēk ām nkuruuk tukul kuyēyiisyēē kaayneetaab Mokoryoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yooto, kukwiil keey ꞉Sāwulō āk Yuutayeek chēē king'āloolē kuutiitaab Kirikiik. Kimii ꞉bichoo kuchōbē kule kubakach Sāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yu kēēnkēt ꞉rubiik chuut kuu nyooto, kuwaayta Sāwulō kurēkto Kayisareeya ānkumwoochi kuwo kang'waa Taarso. ");
INSERT INTO spyNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kunyoo, kikoolyoon kisich ꞉kanisoosyek tukul chēbo Yuuteeya, Kalilaaya āk Samaaryaa. Kumii ꞉icheek kōōywēyē Yēyiin, kuyēētyēēchinē ꞉Tāmirmiryēētaab Yēyiin kukiiltōōs ānkutāsyinē keey kuchoong'ēkiitu. ");
INSERT INTO spyNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kiwēēsyētootēē ꞉Bētērō wōlooto tukul. Kiimuuch chokunyōōryo āk biikaab Kiriistō chēē kiminyē *kiriinkēētaab Luuta. ");
INSERT INTO spyNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kimii wōlooto ꞉chiito ake nyēē /kikēēkuurēē Ayineeya nyēē kichunkutoot ānkikiikuru kitiintiri kēnyiisyēk sisiit. ");
INSERT INTO spyNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Yooto, kukuur ꞉Bētērō chiichoo kule, “Ayineeya, kāākōōsoobiing' ꞉Yēēsu *Kiriistō. Kunyoo, ing'eet ankiiriiny tukuukuuk.” Kung'eet ꞉Ayineeya areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yu kakas ꞉biikaab Luuta āk chēbo Syāārōōn Ayineeya, kōōyēnchi ꞉tukul Mokoryoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kimii ꞉rubiintēēt ake nyēē ki cheebyoosya nyēē kibo *kiriinkēētaab Yooba. /Kikēēkuurēē cheebyoosyaanaa Tabiita (Nto ām kuutiitaab Kirikiik ku Toorkaas.) Kilēēl ꞉moo cheebyoosyaani ānkiyēētyēēchinē mbo biich chēē bānoon. ");
INSERT INTO spyNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nto mii yoo, kumnyaan ꞉cheebyoosyaanaa ankume. /Kikiiwuun bōōrnyii /ānkubokiitōōr koroofa. ");
INSERT INTO spyNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kilēēkityiin ꞉kiriinkoonoo bo Luuta āk nyoo kibo Yooba. Kunyoo, yu kabokukas ꞉rubiik chuut kule mii ꞉Bētērō Luuta, /kiiyookto biiko alak āyēēng' bokumwoochi Bētērō kule, “Boontēēt, /kēēmākyiing' wōliin areet akeenke.” ");
INSERT INTO spyNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kuwēēto keey ꞉Bētērō bichooto. Yu kabokuyit, /kēēkwēryoot koroofa. Kiiruruukyi keey Bētērō, ꞉chēēbyōōsōōk chēē chaang' chēē ki musuuk chēē kimii kuriirēē Tabiita. Kiiboorchi ꞉chēēbyōōsōōchoo Bētērō sirook chēē chaang' chēē kinābē ꞉Tabiita yoo kitākusobē. ");
INSERT INTO spyNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kumwoochi ꞉Bētērō chēēbyōōsōōchoo kuba saang'. Nto mii yoo, kukutuny ankusaay. Yu keewaany saayeet, kuwo yoo kimii ꞉muusyoontēēt ānkulēēnchi, “Tabiita, ng'eet baa ōō, chēē!” Yooto, kung'aany ꞉Tabiita koonyek. Nto bērē kukasta, kukas Bētērō. Kōōbuur ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kunam ꞉Bētērō āwut ānkuyēētyēēchi kōōyyo. Nto mii yoo, kukuur biikaab Kiriistō āk chēēbyōōsōōchoo ki musuuk ānkōōboorchi cheebyoosyaanaa kukāākusob. ");
INSERT INTO spyNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","/Kikeekasee ng'ālyoontooni kiriinkoonooto bo Yooba kumukuul. Kunyoo, kiiyēnchi ꞉biiko chēē chaang' Mokoryoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kiibuurto keey ꞉Bētērō ām Yooba chiito ake nyēē /kikēēkuurēē Simōōni nyēē ki kuutiin nyēbo mwēēnik. ");
INSERT INTO spyNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kimii ꞉chiito ake *kiriinkēētaab Kayisareeya nyēē /kikēēkuurēē Kōrnēēlyō. Ki kāāntōōyiintēētaab lukēētaab booryēēt ꞉chiichi nyēbo lukēēt nyēē /kikēēkuurē kule Itaalya. ");
INSERT INTO spyNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kikiikōōnēmchi keey ꞉Kōrnēēlyō āk biikaab kanyii tukul Yēyiin kuchurta. Kiikooytooy tukuuk ām mooyēēt nyēē lēēl, kōōkoochinē Yuutayeek choo kiyēmē /kēēyēētyēēchi. Kisooyē Yēyiin kibtaman. ");
INSERT INTO spyNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nto mii bēsyēēt ake, yēē ki asiistaab sokool nyēbo bēēt, kuchōōnchi ꞉ng'oong'uutyēēt Kōrnēēlyō. Kikas *malayikeet ake nyēē kikuurchi inee kule, “Kōrnēēlyō!” ");
INSERT INTO spyNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kiirōōtoot ꞉Kōrnēēlyō malayikaanaa nyēē kāmuy, nto mii yoo, kōōyēn kule, “Wōōy.” Kumwoochi ꞉malayikaanaa kule, “Kookuchamta ꞉Yēyiin wōlēē isooytooy āk wōlēē imiitē iyēētyēēchintooy bānoonik ām tukuuk choo ikoochinē. ");
INSERT INTO spyNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kunyi, iyooktē biiko kuba ākoy Yooba bokukwēryoon chiito ake nyēē /kēēkuurēē Simōōni nto kaayneet ake ku Bētērō. ");
INSERT INTO spyNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mii kaab chiito ake nyēē /kēēkuurēē Simōōni nyēē yēytooy mwēēnik ānkuminyē yēbo tabantaab araarayta.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yu kāākuwēēchi keey ꞉malayikaanaa, kukuur ꞉Kōrnēēlyō motwoorikyii alak āyēēng' āk chiinyii ake nyēbo komostaab lukēēt nyēē kikiikōōnēmchi keey ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kimwoochi bichooto kiy ake tukul nyēē kiyeyakay ānkōōyookto kuba Yooba. ");
INSERT INTO spyNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yu kāyyēēkunēē, kumakuyit asiistaab lo nyēbo bēēt, kikiikuriik kuyit ꞉bichooto Yooba. Kimii yooto ꞉Bētērō kuloong'tēē nkaasiit kuwēētii kōōto barak wokusooyē. ");
INSERT INTO spyNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kyaam ꞉kēmēwuut kut kumach kwaam kiy. Nto /tākēēmii /kēēyēyē āmiik, kuchōōnchi ꞉ng'oong'uutyēēt ānkubootyo ꞉kāāsōōtēywēēk. ");
INSERT INTO spyNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kikas wōliin bo barak kuyootāktōōs /ānkiirēēk ankeet ake nyēē tebees /kukakeenamaan kotootook tukul ang'wan. ");
INSERT INTO spyNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kimii ankaanaa ꞉tyoong'iik tukul choo bēēsyētēē kērēēnkōōk ang'wan āk tukul choo ichuutootēē keey ng'wēny āk mbo nkicheek tāriitēk. ");
INSERT INTO spyNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","/Kēēkuurchi kule, “Bētērō, ibakach tyoong'iichoo ankii-am.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kukētyi ꞉Bētērō kule, “Mokoryoontēēt, kubooyiit man, acha. Ntēē manaa-am bēsyēēt ake kiy nto tukuuk chēē mā *lubkoobēch.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","/Kēēmwoochi kule, “‑Mēēkuur kiy ake tukul nyēē kiyēyē ꞉Yēyiin kutililiit kule mā lubkoob.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kiyeyakay kuu nyooto areet sōmōk, nto mii yoo, /keesar ankaanaa areet akeenke kooyeey barak. ");
INSERT INTO spyNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kumii ꞉Bētērō tākōōlātē kiyēē kiibooru ꞉ng'oong'uutyoonoo, kunyōōr ꞉bichoo /kikiiyooku kaytaab chiichoo /kikēēkuurēē Simōōni. Kiiyyoong'iis yēbo oreetaab tuuyta ");
INSERT INTO spyNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ānkukuurso nto yityo kuteeb chiito ake nyēē /kikēēkuurēē Bētērō. ");
INSERT INTO spyNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kutākumiitē ꞉Bētērō kōōsōōtyēēchinē kiyēē kichōōnchi, kumwoochi ꞉Tāmirmiryēētaab Yēyiin kule, “Simōōni, mii ꞉biiko alake sōmōku kuchēēng'iing'. ");
INSERT INTO spyNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kunyoo, ing'eetee yuutēyu bo kōōto barak ānkiirēktē ng'wēny. ‑Mēētōmōch, nteenee iwēētē keey bichoo kuuyu anii ꞉nyēē kāāyooku icheek.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yooto, kurēkto ꞉Bētērō ānkuwokumwoochi bichooto kule, “Anii ꞉nyooto ōmiitē ōchēēng'ē. Kunyi, ōmāchē nee?” ");
INSERT INTO spyNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kukētyi ꞉bichooto kule, “Kwēēyookwēēch ꞉Kōrnēēlyō nyoo kāāntōōyiintēētaab lukēētaab booryēēt. Churtaat ꞉chiichoo ānkōōywēyē Yēyiin. Koonyitē ꞉Yuutayeek tukul chiichi. Kōchōōnchi *꞉malayikeet ake ānkumwoochi kule iwē ꞉inyiing' kanyii sukung'eet kukas kiyēē +meemwaay.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yooto, kutaach ꞉Bētērō bichoo kuyēk tāyēēkyii. Yu kāyyēēkunēē, kuwēēto keey ꞉Bētērō bichooto. Kitas ꞉biikaab Kiriistō alake ām Yooba ankubeeta keey. ");
INSERT INTO spyNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nto mii bēsyēēt nyēē kiikēērē, kuyit ꞉inee āk bichoo Kayisareeya. Kimii ꞉Kōrnēēlyō kukānyiisyē kaa ānkikiikukuur tilyōōnuutēk āk chōōrōōnuutēk choo kyoomchiintōōs ꞉tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Yu kayit ꞉Bētērō, kutorooch ꞉Kōrnēēlyō kukutunyēē yēbo kērēēnkōōkyii kukākoonyit. ");
INSERT INTO spyNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nteenee kumwoochi ꞉Bētērō kule, “Ng'eet, nto yu akerkeeye ꞉anii āk chii ake tukul.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kyaamaat ꞉Bētērō āk Kōrnēēlyō lōkōōy kumii kubēētii tukwaay kō. Yu kayit kō, kunyōōr biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yooto, kumwoochi ꞉Bētērō bichooto kule, “Ābērē ōnkētē ꞉akweek kule ‑/mākēēchāmu ām kiruutēkyoo kule kuyēmo ꞉Yuutāyiintō āk biiko chēē mā Yuutayeek. Nteenee kāākōōboorwoo ꞉Yēyiin kule māyēmāktōōs ākuur chii ake tukul kule mā tiliil. ");
INSERT INTO spyNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kunyoo, yoo /kibokēēkuuroo, āchōō nyēē mānāātōmōch. Kunyi ii, nee ꞉nyēē kēēkuurchoo?” ");
INSERT INTO spyNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kukētyi ꞉Kōrnēēlyō Bētērō kule, “Ām bēsyōōsyēk ang'wan choo kookukeeyta, āmiitē āsooyē ām kanyuu ām āsiiswēk chēē wuu chuutēchu, ku asiistaab sokool nyēbo bēēt, chokōōyyoonyēē ꞉chiito ake taayeenyuu nyēē boonto sirooy chēē ilēkēchēēchtōōs. ");
INSERT INTO spyNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kikuuro ꞉chiichoo kule, ‘Kōrnēēlyō, kaakukas ꞉Yēyiin wōlēē isooytooy ankaakukas wōlēē iyēētyēēchintooy choo bānoon. ");
INSERT INTO spyNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kunyoo, iyooktē biiko alak kuba Yooba bokukuur chiito ake nyēē /kēēkuurēē Simōōni, nto Bētērō ām kaayneet ake. Kōruutoochi ꞉inee chiito ake nyēē /kēēkuurē kule Simōōni nyēē yēytooy mwēēnik. Minyē ꞉chiichoo tabantaab araarayta.’ ");
INSERT INTO spyNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kwāāyooku /kēēkuuriing' areet akeenke. Kunyi, karaam yu kēēchōō. Kēēmiitē ꞉tukul yu ām taayeetaab Yēyiin kēēmāchē kēēyēbchi yiit kiy ake tukul nyēē kōōkumwoowuung' ꞉Yēyiin kule i-āmwēēch.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Yooto, kutoow ꞉Bētērō kumwooy kule, “Kāānkēt ra kule ākoo ‑mēēnkwēlē ꞉Yēyiin chii ake tukul. Māchāmē alak kusiir alak. ");
INSERT INTO spyNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nteenee chāmē ꞉Yēyiin biikaab yēēmēēt ake tukul choo iywēyē inee ānkuyēyē kiy nyēbo man. ");
INSERT INTO spyNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kiiyookyi ꞉Yēyiin biikaab Isrāyēēl lōkōōywēk chēē kāroomēch kurubta keey āk kaalyeet kubununēē Yēēsu *Kiriistō nyoo bāwu kiy ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ābērē ōnkētē kiyēē kiikuyeyakay ām kōōrēētaab Yuutayeek kutoowunēē Kalilaaya, yu kātoow ꞉Yoowaana kwaamta ng'aleekaab batisaneet. ");
INSERT INTO spyNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ānkāābērē kyookas kule king'oobchi ꞉Yēyiin Yēēsu nyēbo Nāāsārēēt Tāmirmiryēēnyii āk kāāmuukēywēēk. Kyōōnkēt oob kule kiwēēsyētootēē yēēmōōsyēk kuyēyootē tukuuk chēē kāroomēch? Kiityooktooy mbo chēē kikiikōōtiiny ꞉Kibrōkōsyoontēēt. Kiyēyē chooto tukul, kuuyu kiboonto kāāmuukēy kukwaanee wōlēē mii ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kikeekasee ꞉acheek koonyekyoo kiy ake tukul nyēē kiyēyē ꞉Yēēsu ām kōōrēētaab Yuutayeek āk mbo ām Yēērusālēēm. /Kikēēwuuytoochi Yēēsu kēētit /ankeebakach. ");
INSERT INTO spyNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nteenee kiing'eetee ꞉Yēyiin meet ām bēsyēētaab sōmōk kuchakee /kakeebakachee ankuyey kukas ꞉biiko. ");
INSERT INTO spyNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mēēbērē kikas ꞉biiko tukul, nteenee kikeekas ꞉acheek choo kikiisimkukweyeech ꞉Yēyiin choo kikyoomiisyootē āk inee yooto kikiikung'eetee meet. ");
INSERT INTO spyNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kiikāloonwēēch kule kyoomchinootē biiko ānkiiboorchinootē kule inee ꞉nyooto kiikukwey ꞉Yēyiin nyēē mākōōtiilchi choo sobtōōs āk choo kiikubēk ng'aleek. ");
INSERT INTO spyNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yēēsu nyiitēnyi ꞉nyooto ng'āloolēē *꞉wōōrkooyikaab Yēyiin tukul, yoo mwooyē kule chii ake tukul nyoo kēēyēnchi +/mākēēnyōōchi kaat ām choolwookātēēnyii.” ");
INSERT INTO spyNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kutākumii ꞉Bētērō kōōrwoochē, kōōsuuchi ꞉Tāmirmiryēētaab Yēyiin chii ake tukul nyēē kiyēbchi yiit ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Kutoow ꞉bichoo kung'alaal kuutuweek chēē kimēēnkētē kōōkoostooy Yēyiin. Yu kakas ꞉Yuutayeek choo kikwoontooy keey Bētērō chēē kikiikōōyēnchi Yēyiin kule /kikēēng'oobchi Tāmirmiryēētaab Yēyiin mbo biiko chēē mā Yuutayeek, koolat. Yooto, kumwoochi ꞉Bētērō kule, ");
INSERT INTO spyNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nee ꞉nyēē tākukērēktooy bichu /keebatisanee bēēko? Ntēē kāākunyōōr ꞉nkicheek Tāmirmiryēētaab Yēyiin kuu yoo kikēēnyōōru ꞉acheek!” ");
INSERT INTO spyNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yooto, kumwooy ꞉Bētērō kule /keebatisan bichoo ām kaayneetaab Yēēsu *Kiriistō. Kisaaysaay ꞉bichoo Bētērō kule tākōōbuurto keey icheek ām bēsyōōsyēk chēē ng'ēri. ");
INSERT INTO spyNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nto mii yoo, kukas *꞉lēbkēēyik āk biikaab Kiriistō ām yēēmēētaab Yuuteeya kumukuul kule kookutorooch mbo ꞉biiko choo mā Yuutayeek ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kunyoo, yu keetooch ꞉Bētērō Yēērusālēēm, kuwookuutyēē ꞉Yuutayeek chēē kikiikōōyēnchi Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Kimwoochi kule, “So, Bētērō, ntēē siwēē-āmiisyē āk biich chēē mā Yuutayeek?” ");
INSERT INTO spyNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kurārchi ꞉Bētērō bichooto kiy ake tukul ām kēēlto nyēē rootaat ");
INSERT INTO spyNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","kule, “Kimii yēē kyāāsooyē ām Yooba nto tāābērē, kuchōōnchoo ꞉ng'oong'uutyēēt. Kyaakas ankeet nyēē tebees nyēē /kikiirēēk kuchōōnēē barak /kukakeenamaan kotootook tukul ang'wan, ākoy yēē kyāāmiitē. ");
INSERT INTO spyNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nto bērē ārōōtootē, akas tyoong'in choo /kēēbāyē, tyoong'iikaab wuuyēēt, choo ichuutēē keey ng'wēny āk tāriitēk. ");
INSERT INTO spyNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yooto, /kēēkuurwoo kule, ‘Bētērō, ibakach tyoong'iichoo ankii-am.’ ");
INSERT INTO spyNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Yooto, āwālu kule, ‘Kubooyiit man ii, Mokoryoontēēt, acha! Manaa-am bēsyēēt ake kiy nyēē mā *lubkoob.’ ");
INSERT INTO spyNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","/Kēēkētwoo kule, ‘‑Mēēkuur kiy ake tukul nyēē kiyēyē ꞉Yēyiin kutililiit kule mā lubkoob.’ ");
INSERT INTO spyNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kiyeyakay kuu nyiitēnyi areet sōmōk, nto mii yoo, /keesar ankaanaa kooyeey barak. ");
INSERT INTO spyNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Yooto bakeenke, kukwa ꞉biiko alake sōmōku chēē /kikiiyookunēē Kayisareeya ānkubokōōyyoong'iis saang' ām kayaata kyāāmiitē. ");
INSERT INTO spyNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kumwoowoo ꞉Tāmirmiryēētaab Yēyiin kule ‑māātōmōch āwēētē keey bichooto. Kikeebeete keey mbo ng'eetaabiya lo chu kēēboontē keey ām yu ākoy kaytaab chiichoo. ");
INSERT INTO spyNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kimwoowēēch ꞉chiichooto wōlēē kichōōnchinto ꞉malayikeet ām kanyii ānkumwoochi kule, ‘Iyooktē biiko kuba ākoy Yooba bokukuur chiito ake nyēē /kēēkuurēē Simōōni, ");
INSERT INTO spyNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","nto kule Bētērō ām kaayneet ake. Mākuyibuung' ꞉chiichoo lōkōōywēk chēē makooraraachiing' ankooraraach mbo nkicheek biiko tukul ām kang'uung'.’ ");
INSERT INTO spyNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nto baanta nyooto kāātoowu ang'alaal, kōōsuuchi ꞉Tāmirmiryēētaab Yēyiin bichooto kuu wōloo kiisuuchintēēch nkacheek ām taay. ");
INSERT INTO spyNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yooto, asoot kiyēē kikiikumwoowēēch ꞉Mokoryoontēēt kule, ‘Kiibātisāniisyēē ꞉Yoowaana bēēko, nteenee +/makeebatisaneenaak akweek Tāmirmiryēētaab Yēyiin.’ ");
INSERT INTO spyNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kunyoo ii, yēē ākoo kiimuuchē ꞉Yēyiin kung'oobchi bichooto Tāmirmiryēēt kuu wōloo king'oobtēēch acheek yoo kikiiyēnchinē Mokoryoontēēt Yēēsu Kiriistō ii, ku anii ng'oo saasoot akwiil Yēyiin?” ");
INSERT INTO spyNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Yu kabokukas ꞉bichoo ām Yēērusālēēm ng'aleechaa, manaatakukwiil ng'ālyoo ake tukul. Kunyoo, kisilto Yēēsu kumwooyē kule, “Ākoo kāākōōkoochi ꞉Yēyiin nkicheek biiko choo mā Yuutayeek bārooyinto nyēē imuuchē kuweeksee choolwookātēēng'waa sukunyōōr soboonto.” ");
INSERT INTO spyNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kiba ꞉biiko choo kiisereet ꞉wusiisyēēt kubo ng'aleekaab Steefaan ākoy Fōyinikē, Kubrō ākoo Antyookya. Kyoomchinootē lōkōōywēk Yuutayeek nkit. ");
INSERT INTO spyNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kikwa Antyookya ꞉Yuutayeek chēē kibo Kubrō āk Kurēēn ānking'āloolē kuutiitaab Kirikiik. Kitoow ꞉bichu kwoomchi Kirikiik lōkōōywēk chēē kāroomēch kurubta keey Mokoryoontēēt Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kiboonto ꞉bichoo kāāmuukēywēēk kukwaanee wōlēē mii ꞉Yēyiin. Yooto, kuweek ꞉biiko chēē chaang' kōōyēnchi Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kiyityi ꞉ng'aleechaa kaniseetaab Yēērusālēēm. Yooto, /kiiyookto Barnaaba kuwo Antyookya. ");
INSERT INTO spyNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yu kāwokuyit wōlooto, ankukas kiyēē kikiikuyey ꞉Yēyiin ām kāāmuukēywēēkyii, kung'ērēkyi. Yooto kōōkiim bichooto tukul kōōbuurto Mokoryoontēēt ām mooyēēt akeenke. ");
INSERT INTO spyNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kilēēl ꞉moo chiichi. Kiboonto ꞉chiichoo Tāmirmiryēēt kuyem ānkōōkoosēē keey Yēyiin miisin. Kiyis keey yooto ꞉biiko chēē chaang' kukwa komostaab Mokoryoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nto mii yoo, kuwo Barnaaba ākoy Taarso wokucheeng'aat Sāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Yu kāwokunyōōr kuwēēto keey ākoy Antyookya. Kunyoo, ām kēnyiit akeenke, kiinēētē ꞉Barnaaba āk Sāwulō biikaab Kiriistō chēē chaang'. Antyookya ꞉wōlēē /kikēēkuurē rubiik nyēbo taay kule ‘Biikaab Kiriistō’. ");
INSERT INTO spyNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kimii ām bēsyōōsyēchooto yēē king'ēētyēē *꞉wōōrkooyikaab Yēyiin alake Yēērusālēēm kurēkto Antyookya. ");
INSERT INTO spyNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ake ām wōōrkooyichoo ku nyēē /kikēēkuurēē Akaabo. King'oor ām Tāmirmiryēētaab Yēyiin kule mākuchō ꞉kēmēwuut nyēē ng'waa miisin kōōrēētaab Rooma kumukuul. (Kichōōnii ꞉kēmēwuuni yu kibāytooyiisyēē ꞉Kilaawutiyo.) ");
INSERT INTO spyNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kunyoo, kisyeem ꞉rubiintēēt ake tukul wōlēē kiimuuktooy kōōruruuch beesaanik kuyēētyēēchi mbo ng'eetaabkaamet ām Yuuteeya. ");
INSERT INTO spyNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","/Kikiiyookto Barnaaba āk Sāwulō kuyib tukuuchoo bokutēbunēē āwunnyēkaab booyik chēbo kaniseetaab Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nto mii yoo, kunam ꞉bāytooyiintēēt *Ērōōtē nyoo /kikēēkuurē kule Akiriiba, biikaab Kiriistō alak ankoonyaliil. ");
INSERT INTO spyNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kibakachee ꞉Ērōōtē Yāākōbō nyoo ki ng'eetaabkaametiitaab Yoowaana chōōkiit. ");
INSERT INTO spyNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yu kawokukas ꞉Ērōōtē kule kiing'ereech ꞉ng'ālyoontoonoo Yuutayeek, kutas taay ankunam nkinee Bētērō. Kiyēyāksē ꞉ng'ālyoontoonoo /kyoomē Saakweetaab mukaatiin chēē mākuutunootiin. ");
INSERT INTO spyNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Yu /kabokeenam Bētērō, /keekerta kāābēērit. /Kikiikoochi bokuriib ꞉lukēēt nyēbo biiko taman āk lo chēē kibēētootēē ang'wan ang'wan kubārchinē keey bēsyō. Kimāchē ꞉Ērōōtē kule yoo kāākubēk ꞉āsiiswēkaab *Saakweetaab Keeytaayeet, /kēēkwēryoot Bētērō /bokiikuum kukāsē ꞉biiko tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kiibuur ꞉Bētērō kāābēērit, nteenee kisoochinē ꞉kaniseet miisin. ");
INSERT INTO spyNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nto ām kwēēmowuut nyi kimāchē ꞉Ērōōtē kule /sikēēkwēryoot Bētērō yoo kayyeech /bokiikuum, kimii ꞉Bētērō kāru kwēēnuutaab riibiik āyēēng' ankirataat nyōrōōrōōnik āyēēng'. Kimiitē ꞉riibiik alake āyēēnku kuriibsē kurkat saang'. ");
INSERT INTO spyNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Yooto, kutook ꞉malayikeet ake areet akeenke kulebkeyiit ꞉kōyooto kimiitē ꞉Bētērō. Kooluchluuch ꞉malayikaanaa Bētērō kumwoochinē kule, “Ng'eet areet akeenke.” Kōōtyookiis ꞉nyōrōōrōōnik ām āwunnyēkaab Bētērō. ");
INSERT INTO spyNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kōōtyooktōōs, kumwoochinē ꞉malayikeet Bētērō kule, “Siriny kaansuung'uung' ankiimoot nto yityo ilaach kwēyōōnik.” Kuyey ꞉Bētērō kuu nyooto. Nto mii yoo kumwoochi kule, “Ilaach kābuutiing'uung' ankiirubwaa.” ");
INSERT INTO spyNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kirub ꞉Bētērō malayikaanaa kut kuchuyta saang' ām wōloo /kikēērātyinē. Yooto tukul, kibērē ꞉Bētērō ki kiirwoot ꞉kiyēē kimii ꞉malayikeet kuyēyē. ");
INSERT INTO spyNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kikeeytee ꞉tukwaay riibiik chēbo taayta āk chēbo āyēēng'. Nto kuyitē oreet nyēbo karneet nyēē /kēēchuchinēē kiriinkēēt, kuyootāktōōs ꞉nyoo nkityō. Kuchuyta ꞉icheek ankutas taay āk baanng'waa. Nto kumānāāyitē wuy, kubot ꞉malayikeet. ");
INSERT INTO spyNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kusēw ꞉Bētērō ankumwaayee mooyēēnyii kule, “Kāānkēt man kule ākoo kā Yēyiin ꞉nyēē kēēyooku malayikaani kule chokootyaakteenaa āwunnyēkaab Ērōōtē āk kiyēē kimāchē ꞉Yuutayeek kuyeyeenaa.” ");
INSERT INTO spyNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Yooto, kuwo ꞉Bētērō kōōtaab cheebyoosyeet ake nyēē /kikēēkuurēē Maaryaa, kaametiitaab Yoowaana nyēē /kikēēkuurē ām kaayneet ake kule Māārkō. Kikiikōōruruukyi keey ꞉biiko chēē chaang' kōyooto chēē kimii kusooyē. ");
INSERT INTO spyNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kukuurso ꞉Bētērō ām oreetaab tuuyta. Kiwokukas ꞉chēēbto ake nyēē ki motwooriin nyēē /kikēēkuurēē Roota kule ki ng'oo ꞉nyoo kikuursē. ");
INSERT INTO spyNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Yu kēēnkēt kule bo ꞉kuutiit Bētērō, kung'erech nyēē ‑/mākyoomu. Kumānāāyootyinē oreet, kuweech keey kulabat ānkuwokumwoochi chuut kule, “Kookas, ntēē kāākuchō ꞉Bētērō!” ");
INSERT INTO spyNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kēēlēēnchi, “Karaam ꞉mēting'uung' man ēē?” Kulē ꞉chēēboo, “Biikyoo, ankookas ng'aleekyuu!” Kiyey kuu nyooto kut /kēēmwooy kule, “Ākoy ku malayikeetaab Bētērō ꞉nyooto.” ");
INSERT INTO spyNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yooto tukul, kimii ꞉Bētērō kutāsē taay kukuursē ām yooto bo oreet. Yu /kakeeyaat oreet, /kēēlē, “Māku Bētērō ꞉nyi!” Kinam kuut biiko miisin. ");
INSERT INTO spyNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Yooto, kumwechee ꞉Bētērō biiko āwut kule kusiisyo ānkurārchi wōlēē kiityaakta inee ꞉Yēyiin. Kimwooy mbo subak kule, “Bōōmwoochi Yāākōbō ākoo mbo ng'eetaabiya alak ng'ālyoontooni.” Yu kāmwooy kuu nyooto, kuwo yēēt ake. ");
INSERT INTO spyNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yu kayyeech ꞉kōōrēēt, kwoorookēniis ꞉riibiik yu kakas kule māmii ꞉Bētērō kuuyu kimēēnkētē kiyēē koyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yu kamach *꞉Ērōōtē Bētērō āmēēbērē kimii wōloo /kikēēkērtooy, kukuur riibiichoo /bokiikuum. Nto kuuyu kimēēmuuchē ꞉riibiichoo kurār wōlēē kibeeta ꞉ng'aleek, /keebakach. Nto mii yoo, kung'eetee ꞉Ērōōtē Yuuteeya ānkuwo ākoy Kayisareeya ānkōōbuur wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Kikiikuchuunchuun *꞉Ērōōtē āk biikaab Tiirō āk chēbo Sitōōn. Kuuyu kiikoosēē keey ꞉kōōrōōsyēchooto kōōrēētaab Ērōōtē kubo āmiik, /keekwey alamaalyeet nyēē kiruutoochi Ērōōtē. Kisimbokung'āloolchi chiito ake nyēē /kikēēkuurēē Blaasto nyēē kiiyyoonkyinē kaytaab bāytooyiintoonoo. Kibokusoomē ꞉bichoo bāytooyiintēēt Ērōōtē kule kuchō ꞉kaalyeet. ");
INSERT INTO spyNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nto yu kayit ꞉bēsyēēt nyēē /kikiikeekwey kubooyiit tuuyēēt, koolaach ꞉Ērōōtē sirookyii chēbo bāytooyiisyēēt. Kiibuurēē ng'echereenyii bo bāytooyiisyēēt ānkung'āloolchi biiko chēē kikiiruruukyi keey yooto. ");
INSERT INTO spyNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yooto kulē ꞉biiko, “Ntēē ng'āloolē kut wuu nyēē kāākuyēk Yēyiin ōō, lēyyē!” ");
INSERT INTO spyNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kuuyu king'ērēkyi ꞉Ērōōtē kiyēē kimwooy ꞉biiko āmēēbērē kiiywey Yēyiin, kuchō *꞉malayikeetaab Yēyiin areet akeenke ānkukwēr Ērōōtē kumilta! Kyaam ꞉kuutyek kut chokume lētuunoo. ");
INSERT INTO spyNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yooto tukul kuyesta ꞉ng'ālyoontēētaab Yēyiin kuyityi biiko chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Yu kaakoowaany ꞉Barnaaba āk Sāwulō yiisyoonoo kibēēchinē Yēērusālēēm, kooyeey Antyookya. Kibeeta Yoowaana nyoo /kikēēkuurē ām kaayneet ake kule Māārkō. ");
INSERT INTO spyNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kimii ām kaniseetaab Antyookya ꞉biiko chēē *wōōrkooyik āk kāānēētik. Bichooto ku: Barnaaba, Simiyōōn nyēē /kikēēkuurē ām kaayneet ake kule Kibtuuy, Lukiiyō nyēbo kōōrēētaab Kurēēn, Māānāyēēn nyoo kinērē ākoo *Ērōōtē Antibaas, nto ake ku Sāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nto mii bēsyēēt ake, kumii ꞉bichooto tukul kusiltooy Yēyiin ānkukirē kwoomiis, kumwooy ꞉Tāmirmiryēētaab Yēyiin kubununēē wōōrkooyoontēēt ake kule, “Ōtāboonwoo Barnaaba āk Sāwulō kubo yiisyēēt nyēē !kāākwēchi icheek.” ");
INSERT INTO spyNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kunyoo, kumii ꞉bichoo kukirē kwoomiis ānkusooyē, kutiinyēē Barnaaba āk Sāwulō āwunnyēk ānkōōyookto. ");
INSERT INTO spyNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yu kāākōōyookto ꞉Tāmirmiryēētaab Yēyiin mbo Barnaaba, kuba ākoy Selewukyaa. Kibeetee mwēēnkēēt ām wōlooto ākoy kuyit Kubrō. ");
INSERT INTO spyNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Yu kayit *kiriinkēēt ake nyēē /kikēēkuurēē Salaami ām Kubrō, kwaamtaat ng'ālyoontēētaab Yēyiin ām kooriikaab saayeet bo Yuutayeek. Kiboontootē keey Yoowaana nyoo kiyēētyēēchinootē icheek. ");
INSERT INTO spyNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kibeesyetaatee ꞉icheek komosaata bo Kubrō tukul ākoy yēēt ake yēē /kikēēkuurēē Bāāfō. Kinyoorta wōlooto chēēbsookēyoontēēt ake nyēē ki Yuutāyiin nyēē /kikēēkuurēē Araab Yēēsu. Kiyibē keey ꞉chiichoo kule *wōōrkooyoo. ");
INSERT INTO spyNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kiyēētyēēchinē ꞉chiichi bāytooyiintēētaab yēēmoonooto nyēē /kikēēkuurēē Sērkiiyō Bāwulō. Ki ng'oom ꞉bāytooyiintoonoo miisin. Kimwaayta /bokēēkuurchi Barnaaba āk Sāwulō kuuyu kimāchē kule kuyēbchi yiit ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kaayneetaab chēēbsookēyoontoonoo nyēbo Kirikiik ku Elimaas. Kikwiil ꞉Elimaas Barnaaba āk Sāwulō ankusyeem kumaas kāāsōōtēywēēkaab bāytooyiintoonoo simēēyēnchi ng'aleekwaa. ");
INSERT INTO spyNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","/Kikiinyiityi Sāwulō (nyoo /kibokēēkuur lētuunoo kule Bāwulō) Tāmirmiryēētaab Yēyiin, ānkōōrōōtoot Elimaas. ");
INSERT INTO spyNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Yooto, kumwoochi kule, “Ibooyē ꞉inyiing' Kibrōkōsyoontēēt! Iyēku buunyoo ām wōlēē mii ꞉kiy ake tukul nyēbo manta! Ibērbēēriisyē 'ankiicham imoosē biiko. Ām nee yu 'kiicham i-ābuchē ng'ālyoontēētaab Yēyiin? ");
INSERT INTO spyNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Makoorabaachiing' ꞉kāāmuukēywēēkaab Yēyiin ikor.” Ām areet akeenke, kuker chiichoo ꞉chēēbkēēruut āk mēēnānēēt. Kutorobēnoot kule nto nyōōr chii nyēē kanam āwut sukōōrēētoot. ");
INSERT INTO spyNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yooto, kōōyēnchi ꞉bāytooyiintoonoo Yēyiin, yu kawokukas kiyēē kiyeyakay ām wōlēē mii ꞉chēēbsookēyoontēēt. Kiilat miisin ām kāāmuukēywēēk kurubta keey āk Mokoryoontēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nto mii yoo, kuwēētēē ꞉Bāwulō mwēēnkēēt kung'eetee Bāāfō kuboontootē keey chōōrōōnuutēkyii ankuba ākoy Beerka ām yēēmēētaab Bamfulyaa. Kibakaaktee icheek ꞉Yoowaana yooto ankooyeey Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yu kāng'ēētyēē ꞉icheek Beerka, kuba ākoy Antyookya ām yēēmēētaab Bisiitya. Nto mii yēē ki bēsyēētaab *Sabaato, kōōwut ꞉icheek *kōōtaab saayeet nyēbo Yuutayeek ānkōōbuur ng'wēny. ");
INSERT INTO spyNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Yooto, /keesuman ng'aleek kukwaanee ꞉kitaabuunekaab Muusa āk chēbo *wōōrkooyikaab Yēyiin. Nto mii yoo, kumwoochi ꞉biiko chēē kiiyyoonkyinē kōyooto bo saayeet chiito ake wokuteebee Bāwulō āk Barnaaba, yoo mii ꞉ng'ālyoo nyēē māchē ꞉icheek kōōkiimēē biiko. ");
INSERT INTO spyNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Yooto, kung'eet ꞉Bāwulō ānkōōtōrōōr āwut. Nto yityo, kumwoochi kule, “Biikyoo bo *Isrāyēēl āk akweek Kirikiik choo ōyēnchinē Yēyiin, oyeb yiit. ");
INSERT INTO spyNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kikwey ꞉Yēyiintēētaab Isrāyēēl mbo kuuko ankuyey kuyēk sērē yoo kitākumii Miisir ankoong'eetee wōlooto ām kāāmuukēywēēkyii. ");
INSERT INTO spyNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kimuytoochi ng'aleekaab bichoo kumii suurkwēēnēēt ām kēnyiisyēk chēē kimāchē kuyitē artam. ");
INSERT INTO spyNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kiikarbuus ꞉Yēyiin bōrōryōōsyēk tisab chēē kiminyē Kanaan ānkurōōbchi biikyii kōōroonooto. ");
INSERT INTO spyNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kiyib ꞉ng'aleechaa tukul kēnyiisyēk chēē yitē bokolwookik ang'wan āk konom. Yu kāwokukeeyta ꞉yoo, kukōōn ꞉Yēyiin kubāytooyiis ꞉kiirwookik. Kibāytooyiis ꞉ake kōōkēērē ꞉ake ākoy bēsyēēt nyēē kichokubāytooyiisyē *꞉wōōrkooyoontēēt Sāmwēēl. ");
INSERT INTO spyNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kimākyi keey ꞉biiko bāytooyiintēēt nyēē nyeeng'waa. Yooto, /kiikoochi bichooto Sāwulō araab Kiis nyoo kichōōnēē kōōtaab Beenchamiin. Kibāytooyiis ꞉Sāwulō kēnyiisyēk artam. ");
INSERT INTO spyNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Yu /kābokiinēm Sāwulō ām bāytooyiisyēēt, kookeeree ꞉Yēyiin *Tāwuti. King'alaalee ꞉Yēyiin Tāwuti nyēē karaam kumwooyē kule, ‘Kaakwey Tāwuti araab Yēēsē, kuuyu chii nyēē chāmē ꞉mooyēēnyuu. Makuyey kiy ake tukul kuu wōlēē āmāktooy.’ ");
INSERT INTO spyNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kiyey ꞉Yēyiin kurutunēē *꞉Kāārārookiintēēt kōōtaab Tāwuti sukooraraach Isrāyēēl kuu yoo kikiikukuurtoowēēch. Nyooto ku Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kisimkwoomchi ꞉Yoowaana biikaab Isrāyēēl kutēē yēē tēē, kumānāāchō ꞉Yēēsu, kule kuweek ꞉tukul ām miyootyēēt /ankeebatisan. ");
INSERT INTO spyNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nto kumiitē ꞉Yoowaana kōōwoong'tooy yiisyēēnyii, kumwoochi biiko kule, ‘Ōsōōtē ꞉akweek kule anii ku ng'oo? Mā ꞉anii Kāārārookiintoonoo, nteenee, mii kuchōōnii ꞉nyēē ‑māāyēmē mbo ārēēkyi kwēyōōnik.’ ");
INSERT INTO spyNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Mbo ng'eetaabiya, kēēyibwook ꞉acheek lōkōōywēchu bo kaararaacheet akweek keseniisyekaab Abraam āk choo mā Yuutayeek choo ōywēyē Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Manaachamta ꞉biikaab Yēērusālēēm āk bāytooyikwaa kule *Kāārārookiintēēt ꞉Yēēsu, yooto kōōtiilchi meet. Nteenee kiityiich ꞉yuutēyu ng'aleekaab *wōōrkooyikaab Yēyiin choo /kikēēsumānē *Sabaato ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ānkoo kimāmii ꞉lēēlis nyēē kiimuuchē kuyey /kiitiilchi Yēēsu meet, kiikiimchi ꞉bichoo *Bilaato kule kubakach Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Yu keewaany ꞉icheek kuyeyee Yēēsu kiy ake tukul kuu wōloo kimwooytooy ꞉siruutēk, /bokiirēēkunēē kēētoo /kikēēwuuytoochinē /ānkubokiitōōr kochong'. ");
INSERT INTO spyNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nteenee koong'eetee ꞉Yēyiin Yēēsu meet. ");
INSERT INTO spyNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kikas ꞉biiko ām bēsyōōsyēk chēē chaang' ꞉choo kibēēsyētootē tukul kung'eetee Kalilaaya ākoy Yēērusālēēm. Bichooto ꞉chēē mii kumwoochinē biiko kurubta keey āk inee. ");
INSERT INTO spyNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Kiyēē kēēmiitē kyoomwook ku lōkōōywēk chēē kāroomēch kule kaakootyiich ꞉Yēyiin ām wōlēē kēēmiitē ꞉acheek keseniisyek, kiyēē kikiikukuurtoochi mbo kuuko kule mākōōyook wōōrkooyoontēēt nyēē wuu Muusa. Nto nyooto ku Yēēsu. /Kēēng'āloolēē mbo yuutēyu ām kitaabuutaab Tyēēnwookik kurkeetaab āyēēng' yoo mwooyē kule, ‘Inyiing' lakwanyuu. Kāāyēku ꞉anii kōōn ra.’ ");
INSERT INTO spyNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nto kurubta keey āk ng'eeteetaab meet bo Yēēsu nyēē mākoy kunun ꞉bōōrnyii, mwooyē ꞉Yēyiin kule, ‘+Maayey kuyityiin ꞉ng'aleechaa /kiikoosēē keey choo kyāākuurtoochinē *Tāwuti.’ ");
INSERT INTO spyNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mwooyē mbo ꞉siruutēk ām yēēt ake subak kule, ‘‑Mēē-āsyinē chiing'uung' nyoo churtaat kunun.’ ");
INSERT INTO spyNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kunyoo, yu keewaany ꞉Tāwuti kuyey kiyēē kimākyinē ꞉Yēyiin ām bēsyōōsyēkyii, kume. Yooto /kēēmuchi wōloo /kikēēmuchi mbo kuukaanyii. Kinunchi ꞉bōōrnyii wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nteenee manaanun ꞉bōōrtaab nyoo kiing'eetee ꞉Yēyiin meet. ");
INSERT INTO spyNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Kunyoo ii, mbo ng'eetaabiya, āmāchē āboorwook kule /kēēnyōōwook kaat ām choolwookātēēng'woong' kubununēē Yēēsu. Yoo kēēyēnchi ꞉chii ake tukul Yēēsu, kuchurtooy ām taayeetaab Yēyiin, ng'ālyoo nyēē mēēmuuchāktōōs /keeyey kubununēē kiruutēkaab Muusa. ");
INSERT INTO spyNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ōriib keey ām kiyēē kiikung'oor *꞉wōōrkooyikaab Yēyiin sukung'eet māyēyākiis ꞉ng'aleechaa ām wōlēē ōmiitē. /Kikēēmwooy kule, ");
INSERT INTO spyNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Okaste baa, ꞉akweek choo ōmōōntooyiisyē. Kookas ng'aleechu ankoolat, ānku +mōōbootyē, kuuyu ‑mōōchāmtooy kiyēē āyēyē kutōōmiitē kōōrēēt ānkoo /kākēērārwook.’” ");
INSERT INTO spyNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Yu kimii ꞉Bāwulō ākoo Barnaaba kung'ēētyēē *kōōtaab saayeet, /kēēmwoochi kule, “Tookwaa *Sabaato nyi chōōnii, bōō-āmwēēch ng'aleechu.” ");
INSERT INTO spyNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kiiyēnchi ꞉Yuutayeek chēē chaang' āk Kirikiik Yēēsu ankurub mbo Bāwulō. Kiirwookyinoot ꞉Bāwulō āk Barnaaba bichoo kōōkiimchinē kōōkēnēē keey chamateetaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nto yitu ꞉Sabaato nyoo kiikēērē, kōōruruuch keey ꞉biikaab *kiriinkēēt tukul bokuyēbchi yiit ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yu kakas ꞉kāāntōōyikaab Yuutayeek kuu nyooto, kōōtuuyiityi moo. Kikwiil kiyēē kimii ꞉Bāwulō kumwooyē. ");
INSERT INTO spyNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yooto, kumwoochi ꞉Bāwulō ākoo Barnaaba bichooto ām nyikanateet kule, “Ki nyēēng'woong' akweek ng'ālyoontēētaab Yēyiin. Nteenee kuuyu kootay ꞉akweek ra ānkōōyibē keey kule mānyoolchook *꞉soboontaab kibchuulyo, kēēwēēkyi kāāsōōtēywēēkyoo wōlēē mii ꞉bichu mā Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kimwooy ꞉Yēyiin kule, ‘Kaayeyiing' iyibchi biiko choo mā Yuutayeek lēbkēēyyēēt sukung'eet /kiimuuch /kiiraraach biiko ām komoswookik tukul chēbo kōōrēēt.’” ");
INSERT INTO spyNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nto bērē kukas ꞉biiko choo kimā Yuutayeek ng'aleechaa kibo Bāwulō, kung'ērēkiis miisin. Kikoonyit ng'ālyoontēētaab Yēyiin ankookaasee keey Yēēsu ꞉tukul choo /kikiikeetool kunyōōr soboontaab kibchuulyo. ");
INSERT INTO spyNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kiyestee ꞉ng'ālyoontēētaab Yēyiin yēēmoonooto kumukuul. ");
INSERT INTO spyNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nteenee kiiwuruur ꞉Yuutayeek chēēbyōōsōōkaab Kirikiik chēē kitookunootiin chēē kikiikurub ng'aleekaab Yuutayeek āk booyik chēē kitookunootiin ām kiriinkoonoo. Kiyey ꞉bichoo wōōrōōryēēt kut /keekwetee Bāwulō ākoo Barnaaba yēēmoonooto. ");
INSERT INTO spyNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kiitaarta ꞉icheek tēērtit ām kērēēnkōōkwaa sukōōsōōtēē keey ꞉bichoo ānkutākyi keey *kiriinkēēt ake nyēē /kikēēkuurēē Ikonnyaa. ");
INSERT INTO spyNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nteenee king'ērēkiis ꞉choo kiiyēnchi Kiriistō /ānkiinyiityi Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Yu kimii ꞉Bāwulō āk Barnaaba Ikonnyaa, kuba *kōōtaab saayeet nyēbo Yuutayeek kuu kwaak. Kyaamta ng'ālyoontēētaab Yēyiin nyēē kōrōōm miisin kut kōōyēnchi ꞉Yuutayeek āk Kirikiik chēē chaang' Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nteenee kōōwuruur ꞉Yuutayeek choo kitay kuchamta Yēēsu Kirikiik kukwiil mbo ng'eetaabiya. ");
INSERT INTO spyNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kiiwoonkyi ꞉Bāwulō āk Barnaaba bēsyōōs chēē chaang' wōlooto kung'āloolē nyēē kimānyōkōōrēch mbo kisich, kurubta keey chamateetaab Yēēsu. Kiiboor ꞉Mokoryoontēēt kule kibo man ꞉lōkōōywēchoo yoo kiikoochinē icheek kāāmuukēywēēk kuyeyee ng'al chēbo kwōng'uut. ");
INSERT INTO spyNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kichuunchuunootiin ꞉biikaab kiriinkoonoo. Kichoomtōōs ꞉alake āk kāāntōōyikaab Yuutayeek kuchoomtōōs ꞉alake ākoo lēbkēēyik. ");
INSERT INTO spyNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nteenee kinoomnyo ꞉Yuutayeek āk Kirikiik kuboonto keey kāāntōōyikwaa ānkuchōb koonyaliil lēbkēēyik ankuwiiree rwoontōōk kubakach. ");
INSERT INTO spyNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kisimkōōnkēt mbo ꞉Bāwulō ng'aleechaa. Kumwēy kutākyi keey yēēmēēt ake nyēē /kikēēkuurēē Lukawoonnya wōlēē kimii ꞉kiriinkēēt nyēē /kikēēkuurēē Luustra āk Tēērbē āk mbo soong'wēk alak chēē kilēēkitēē yooto. ");
INSERT INTO spyNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kitas taay ꞉icheek kwaamtaat lōkōōywēk chēē kāroomēch ām wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kimiitē ꞉chiito ake kiriinkoonoo bo Luustra nyēē kikiikuchunkuut ꞉kērēēnkōōk kung'eetee leekwaanti āmānāāwēēsyēt bēsyēēt ake. Kimii ꞉chiichoo kukēēbuur ng'wēny ");
INSERT INTO spyNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","kuyēbchinē yiit wōlēē kimii kung'ālooltooy ꞉Bāwulō. Yooto, kōōrōōtoot ꞉Bāwulō chiichooto ānkōōnkēt kule kiikoosēē keey ꞉chiichoo Yēyiin nyēē yēmāktōōs /kiisoob. ");
INSERT INTO spyNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kukuurchi ꞉Bāwulō chiichoo kule, “Ing'eet ānkiiyyoony.” Kung'eet ꞉chiichoo areet akeenke ānkuwēēsyētoot. ");
INSERT INTO spyNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Yu kakas ꞉biiko ng'aleechaa, kumwooy ām kuutiing'waa kule, “Nto yu kāākurārākyēēch ra āynātōōs chēē wuu biich.” ");
INSERT INTO spyNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kikuurēē ꞉bichooto Barnaaba *Sēēwus, kukuurēē Bāwulō *Ēērmē, kuuyu ki inee nyēē ki ng'ālooliintēēt nyēē wōō. ");
INSERT INTO spyNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kimii ꞉kōōto ake nyēē /kikēēsooyēē Sēēwus nyēē kilēēkitēē yēē kibo oreet nyēē iwutē kiriing'. Yooto kukwēryoon ꞉kibkōrōs nyēē kiiyyoonkyinē kōyooto wuunōōk āk toobtōōk ākoy oreetaab kiriinkoonoo. Kimāchē ꞉inee āk biiko chuut kule kuyēchi mbo Bāwulō kōrōsēēk. ");
INSERT INTO spyNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nteenee yu kakas ꞉Barnaaba āk Bāwulō ng'aleechaa, kukereer sirookwaa kōōboor kule katay ng'aleechaa. Kulabat wōlēē kikiiruruukyi keey ꞉biiko ānkubōlchi kule, ");
INSERT INTO spyNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Murēchu! Ām nee yu sooyey ng'al chēē tēē chu? Ntēē keekerkeeye acheek āk akweek. Kēēmiitē kēēyibwook lōkōōywēk chēē kāroomēch. Oweeksee mosoonkoyeenichu māsāru kiy ānkōōyēnchi Yēyiintēētaab manta, nyoo kiyēyē barak āk ng'wēny, araarayta āk tukuuk tukul choo mii wōlto. ");
INSERT INTO spyNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ām bēsyōōsyēk choo kibo taay kyoosyi ꞉Yēyiin kōōrootunwēēk kurub ātēbuutēkwaa. ");
INSERT INTO spyNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nteenee tukuuk chēē kāroomēch choo kikōōnook ꞉Yēyiin kōōbooru ꞉yooto wōlēē wuu ꞉inee. Kikōōnook roobta ānkuyēyē kubiityo ꞉āmiik ām bēsyōōsyēk chēē kiikuchōbchi. Kōōnook āmiik chēē chaang' ānkuyēyook ong'erech.” ");
INSERT INTO spyNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kimā kuskus kukerekta ꞉mbo Bāwulō bichoo kumayey kōrōsēēchoo ānkoo sinee kiimuukta. ");
INSERT INTO spyNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nto mii yoo, kukwaanee ꞉Yuutayeek alake Antyookya ākoo Ikonnyaa ānkubokutēwēch biiko kutayee keey mbo Bāwulō ānkōōyēnchi ng'aleekwaa icheek. Kuwiiree ꞉bichooto Bāwulō rwoontōōk ānkōōng'irtiitoot kuwo kiriinkoonooto saang' kubērē tōōs kaakume. ");
INSERT INTO spyNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nteenee kukwa ꞉biikaab Kiriistō ānkōōruruukyi keey Bāwulō. Kung'eet ꞉Bāwulō ankooyeey ākoy kiriinkoonoo. Nto yu kāyyēēkunēē, kung'eetee Luustra ākoo Barnaaba ānkutākyi keey Tēērbē. ");
INSERT INTO spyNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Yu kabokuyit ꞉icheek Tēērbē, kwaamta lōkōōywēk chēē kāroomēch ām wōlooto ānkōōyēnchi ꞉biiko chēē chaang'. Nto mii lētuunoo, kooyeey kaa. Kibuntēē Luustra, Ikonnyaa ākoo Antyookya nyēbo Bisiitya. ");
INSERT INTO spyNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kiititiirootē biikaab Kiriistō kutēē yooto tukul kutas taay kukiilchi ng'ālyoontēētaab manta. Kimwoochinootē biiko kule, “Ākoy kēēbuntēē nyāliluutēk chēē chaang' ām baani bo Kaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kiyēētyēēchi ꞉Bāwulō ākoo Barnaaba kanisoosyek ām wōlto ake tukul kukwey booyik. Kikir ꞉icheek kwoomiis ānkusoochi booyichoo. Nto mii yoo, kōōyokoochi bichooto Mokoryoontēēt nyoo kikiikookaasee keey. ");
INSERT INTO spyNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Yu kāwokumur ꞉Bāwulō ākoo Barnaaba yēēmēētaab Bisiitya, kuyit nyēbo Bamfulyaa ");
INSERT INTO spyNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ankwaamta ng'ālyoontēētaab Yēyiin ām kiriinkēētaab Beerka. Nto yityo, kurēkto ākoy kiriinkēēt nyēbo Atalyaa. ");
INSERT INTO spyNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nto mii yoo, kubeetee mwēēnkēēt kung'eetee Atalyaa kooyeey Antyookya wōloo /kikiikiiyiilchi icheek ām chamateetaab Yēyiin kubo yiisyēēt nyooto kikiikoowaany. ");
INSERT INTO spyNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Yu kabokuyit Antyookya, kukuur biikaab Kiriistō. Kirārchi bichooto kiy ake tukul nyēē kikiikuyey ꞉Yēyiin kubuntēē icheek āk wōlēē /kikeeyaatita kēēlto kookaasee keey ꞉biiko choo mā Yuutayeek Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kiibuurto keey ꞉Bāwulō āk Barnaaba bichoo bo Kiriistō ām bēsyōōsyēk chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nto yēē kitākumiitē ꞉Bāwulō ākoo Barnaaba Antyookya, kukwaanee ꞉biiko alake Yuuteeya ankuba wōlooto. Kibokooneet ꞉bichoo mbo ng'eetaabiya. Kimwooyē kule, “‑/Mākiirāroochook, yoo /kamakiimuraatanaak kuu wōloo mwooytooy ꞉siruutēkaab *Muusa.” ");
INSERT INTO spyNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kiyey ꞉ng'ālyoontoonoo Bāwulō ākoo Barnaaba kukwiil keey āk bichooto kut kuchuunchuun. Nto mii yoo, /kēēmwooy kule kuwo ꞉Bāwulō ākoo Barnaaba kuboonto keey āk mbo ng'eetaabiya alak Yēērusālēēm. /Kikēēmākyinē bokunyōōryo ākoo *lēbkēēyik chuut āk booyik kurubta keey āk ng'ālyoontooni. ");
INSERT INTO spyNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yooto, kōō-āmiisoot icheek ꞉kaniseet. Nto yu kimii kumurē Fōyinikē āk Samaaryaa kumwoochi ꞉icheek mbo ng'eetaabiya ām wōlooto kule kiikōōyēnchi ꞉biiko choo mā Yuutayeek Yēēsu. Kiing'ereech ꞉lōkōōywēchoo mbo ng'eetaabiya miisin. ");
INSERT INTO spyNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yu kabokuyit mbo ꞉Bāwulō Yēērusālēēm, kutorooch icheek ꞉lēbkēēyik, booyik āk biikaab Kiriistō chuut alak. Kiiboorchi bichooto kiyēē kiikuyey ꞉Yēyiin kubuntēē icheek. ");
INSERT INTO spyNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nteenee king'ēētyo *꞉Farisaayeek alake chēē kikiikuchamta Yēēsu ānkumwooy kule, “Māchāktōōs */kiimuraatan biiko choo mā Yuutayeek ānkumākyinē mbo kooywey kiruutēkaab *Muusa.” ");
INSERT INTO spyNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yooto, kukuur keey *꞉lēbkēēyik ākoo booyik bokoolyeb ng'ālyoontoonoo. ");
INSERT INTO spyNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Yu kabokung'alaalee ām kōōyinto, kung'eet ꞉Bētērō ānkumwooy kule, “Mbo ng'eetaabiya, ābērē ōnkēt kule kisimkutoola ꞉Yēyiin kēny ām wōlēē ōmiitē ꞉akweek, ā-āmchi biiko choo mā Yuutayeek lōkōōywēk chēē kāroomēch kukas ānkōōyēnchi. ");
INSERT INTO spyNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kiiboorunēē ꞉Yēyiin nyoo inkētē wōlēē wuu ꞉kāāsōōtēywēēkaab biiko kule kichāmē biiko choo mā Yuutayeek yoo kiikoochinē icheek Tāmirmiryēēt kuu yoo kikōōnēēch acheek. ");
INSERT INTO spyNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kuuyu kiikoosēē keey ꞉bichoo Yēyiin, /kiitiliil. Kunyi, ‑mākēēyēku teer ām wōlēē mii ꞉bichoo. ");
INSERT INTO spyNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kunyoo ii, ām nee yu ōmāchē okwiil Yēyiin ōkoochinē mbo ng'eetaabiya kukalab muchōōkiit nyēē ‑mākiimuuchē ꞉acheek keekalab, āmēēbērē kiimuuch ꞉mbo kuuko? ");
INSERT INTO spyNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mēērook oyey kuu nyooto. /Kikiiraraacheech acheek, yu kāwokunyōōwēēch ꞉Mokoryoontēēt Yēēsu kaat, ānkuwuu nyooto ām wōlēē miitē ꞉nkicheek.” ");
INSERT INTO spyNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kisiisyo ꞉biiko tukul kule much! Kiyēbchi yiit nkinee Barnaaba ākoo Bāwulō kumii kōōbooru tukuuk chēē /kiilātē chēē kikiikuyey ꞉Yēyiin ām wōlēē mii ꞉Kirikiik kubuntēē icheek. ");
INSERT INTO spyNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Yu keewaany, kumwooy ꞉Yāākōbō kule, “Mbo ng'eetaabiya, oyeb yiit baa. ");
INSERT INTO spyNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Kāākurārwēēch ꞉Simōōni wōlēē kichāmtooy ꞉Yēyiin choo mā Yuutayeek ām taay, kuyēk cheechii. ");
INSERT INTO spyNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mii ꞉ng'aleekaab *wōōrkooyik chēē ityiichē yuutēyu ām yoo /kikeesir kule, ");
INSERT INTO spyNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Yoo kāākubēk ꞉ng'aleechu, +māāyēēwu ānkuchāāyyoong'tē subak kōōtaab *Tāwuti nyoo kikiikuluul. +Maateech subak wōloo kikiikuburyet kut ākētyi kōōbuur kuu yoo kiwuu, ");
INSERT INTO spyNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","sukung'eet kucheeng'aat ꞉biiko choo kiikung'ēt Mokoryoontēēt āk choo mā Yuutayeek choo kyaakwey kule kuyēk cheechuu. Yēyiin ꞉nyēē kiiboor ng'aleechu ānku inee ꞉nyēē makuyey.’ ");
INSERT INTO spyNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tookunoot kuu nyooto kung'eetee kēny kule mākulumchi ꞉choo mā Yuutayeek biikaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kunyoo, kaatiil ꞉anii kule ‑mookany keeyey kunyikisyi choo mā Yuutayeek yoo mii kuyisu keey kukwoonii wōlēē mii ꞉Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Yoo kātāwuu nyoo, okany kēēsirchi barweet kēēmwoochinē kule kutayee keey kwoomē āmit choo /kākēēsooytoochi āynātōōs ankusaan martaayeet. Kutayee keey mbo subak kwoomē bany chēbo tyoong'in chēē /kakeekul ankutayee keey kwoomē kiisēēnik. ");
INSERT INTO spyNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nteenee yoo māchē ꞉chii kuyēk Yuutāyiin, kōōnkētē kiyēē /kēēmākyinē kule kuyey, kuuyu /kiikeesumanaan kiruutēkaab *Muusa ām kiriing' ake tukul ām bēsyōōsyēk choo kibo taay /ānkutākēēsumānē mbo lōkōōywēchoo ām kooriikaab saayeet ām bēsyēēt ake tukul nyēbo *Sabaato.” ");
INSERT INTO spyNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nto mii yoo, kootiil *꞉lēbkēēyik āk booyik kuboonto keey āk biikaab Kiriistō chuut alak kukwey biiko alak ām biikwaa /sikiiyookto kubeeta keey Bāwulō āk Barnaaba Antyookya. /Kikeekwey Yuuta nyoo /kikēēkuurē ām kaayneet ake kule Barsaaba ākoo Siila. Kitookunootiin ꞉bichoo ām wōlēē mii mbo ng'eetaabiya. ");
INSERT INTO spyNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kibeeta ꞉bichuutēchu barweet nyēē mwooyē kule: Kiisubooyook ꞉acheek lēbkēēyik ākoo booyik. Kēēmāchē kuyityi ꞉lōkōōywēchu biiko choo mā Yuutayeek choo mii Antyookya, Siirya ākoo Kiliikya choo kiikuchamta Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kookeekas kule kookukwa wōloo ōmiitē ꞉biiko alake chēē mānāākēēchāmchi ꞉acheek ankubokooyiimaak mētēwoy ām ng'al chēē kyoomwook ꞉acheek. ");
INSERT INTO spyNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kunyoo, kookiisoot ꞉acheek tukul kule keekwey biiko ānkiiyooku kukwa wōloo ōmiitē. Makukwaanta keey Barnaaba ākoo Bāwulō, choo chamanikyoo, ");
INSERT INTO spyNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","choo kookuchamta soboonwēkwaa kubo kaayneetaab Mokoryoontēēnyoo, Yēēsu Kiriistō. ");
INSERT INTO spyNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kunyi, kākiiyooku Yuuta ākoo Siila kutāsyi nyikiisinto ꞉ng'aleechu sirootiin. ");
INSERT INTO spyNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kookootiil ꞉Tāmirmiryēētaab Yēyiin ankiitiil ꞉nkacheek kule ‑/makiing'ireenaak kiruut chēē chaang'. Nteenee ");
INSERT INTO spyNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","osaanee keey āmit choo /kākēēsooytoochi āynātōōs ankootayee keey bany bo tyoong'in chēē /kēēkulē, kiisēēn āk martaayeet. Karaam yoo kooyey kuu nyooto. Chameetaab keey. ");
INSERT INTO spyNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kunam ꞉bichoo baanta kurēkto ākoy Antyookya. Kikuur kaniseet tukul ānkōōkoochi barwaanaa. ");
INSERT INTO spyNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Yu /kakeesuman lōkōōywēchoo, /kēēng'ērēkyi kuuyu kiikiimē biich. ");
INSERT INTO spyNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Kiititiirēē ꞉Yuuta ākoo Siila choo ki *wōōrkooyikaab Yēyiin biiko ng'al chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yu kāākubēēni ꞉bichoo /kikiiyooktooy wōlooto bēsyōōsyēk chēē ng'ēri, kung'ēētyo kumāchē kooyeey wōloo /kikiiyookunēē. Kii-āmiis ꞉mbo ng'eetaabiya kule kubeeta tāloosyēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Kunyoo, kiibuur ꞉Bāwulō ākoo Barnaaba Antyookya, kōōnēētē ānkwoomtooy ng'ālyoontēētaab Yēyiin kuboonto keey āk biiko alak chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Yu kaakukeeyta ꞉bēsyōōs, kumwoochi ꞉Bāwulō Barnaaba kule, “Murooni, ikany baa, kēēruutoochinootē mbo ng'eetaabiya ām kiriinkōōsyēk tukul choo kiikyaamtaatee ng'ālyoontēētaab Yēyiin. Māchāktōōs kiinkēt wōlēē wuu ꞉soboonwēkwaa.” ");
INSERT INTO spyNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kimāchē ꞉Barnaaba kule /keebeeta Yoowaana nyoo /kikēēkuurē ām kaayneet ake kule Māārkō. ");
INSERT INTO spyNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nteenee kiisoot ꞉Bāwulō kule kimayemaat kubeeta Yoowaana, kuuyu kibetyenyee Bamfulyaa koochuchuuyee keey yiisyoonoo. ");
INSERT INTO spyNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kichuunchuun ꞉Bāwulō āk Barnaaba nyēē kōrōōm kut kubchey keey. Kiwēēto ꞉Barnaaba Māārkō ām mwēēnkēēt kutākyi keey Kubrō. ");
INSERT INTO spyNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nteenee kikwey ꞉Bāwulō Siila kule kuwēēto keey. Kisaay ꞉mbo ng'eetaabiya kōōbēruur icheek ꞉Yēyiin, nto mii yoo, kuba. ");
INSERT INTO spyNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kiwēēsyētootēē ꞉Bāwulō yēēmēētaab Siirya ākoo nyēbo Kiliikya kōōkiimootē kanisoosyek. ");
INSERT INTO spyNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nto mii yoo, kuyit ꞉Bāwulō ākoo Siila Tēērbē ankukeeyta ākoy Luustra wōlēē kiminyē ꞉chiitaab Kiriistō nyēē /kikēēkuurēē Tēmētēēwō. Ki lakwataab cheebyoosya nyēē ki Cheebyuutayaa nyēē kikiikōōyēnchi Yēēsu. Nto kwaan ku Kirikiin. ");
INSERT INTO spyNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","King'āloolēē ꞉mbo ng'eetaabiya Tēmētēēwō ām Luustra ākoo Ikonnyaa nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Yooto, kumach ꞉Bāwulō kule kuwēēto keey Tēmētēēwō. Kunyoo, /kikiimuraatan kubo Yuutayeek chēē kiminyē wōlooto, kuuyu kiinkētē ꞉biiko tukul kule ki Kirikiin ꞉kwaan. ");
INSERT INTO spyNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kibuntootēē kiriinkōōsyēk kwoomtootē ng'aleek kutēē yooto tukul. Kikiikootiil *꞉lēbkēēyik āk booyik ām Yēērusālēēm kule kooywey ꞉biiko ng'aleechaata. ");
INSERT INTO spyNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kunyoo, kikimkimiitu ꞉kanisoosyek ām kiriinkōōsyēchooto ankookaasee keey Yēēsu miisin. Kitāsyinē keey ꞉laating'waa bēsyō ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Kiwēēto keey ꞉Bāwulō bichoo āyēēng' kuwēēsyētootēē yēēmēētaab Fruukya āk nyēbo Kalatyaa, kuuyu kimānāāchāmchi ꞉Tāmirmiryēētaab Yēyiin kwaamta ng'ālyoontēēt ām yēēmēētaab Eesya. ");
INSERT INTO spyNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yu kabokuyit kiyōōtēētaab Misiiya, kusyeem kule kuba yēēmēētaab Biituunnya, nteenee mānāāchāmchi ꞉Tāmirmiryēētaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Yooto, kukeeytee Misiiya ānkutākyi keey *kiriinkēētaab Turoowa. ");
INSERT INTO spyNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yu kayit kwēēmooy, kuchōōnchi ꞉ng'oong'uutyēēt Bāwulō. Kikas chiito ake nyēbo Maketoonnya kukēēyyo ānkumii kusoomē inee kule, “Bāwulō, ānkiichōō Maketoonnya chēēyēētyēēchēēch.” ");
INSERT INTO spyNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Yu kēēnkēt ꞉Bāwulō ng'oong'uutyoonoo, keeyeyte keey areet akeenke keebe Maketoonnya, kiiwoonkyinē kule kāākukuurēēch ꞉Yēyiin bokyoomchi bichoo lōkōōywēk chēē kāroomēch. ");
INSERT INTO spyNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yooto, kēēng'ēētyēē Turoowa ankeebeetee mwēēnkēēt ākoy Samooturake. Nto mii bēsyēēt nyēē kirubē keeyit Neeyabooli. ");
INSERT INTO spyNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nto yityo kēēng'ēētyēē yooto ankeebeetee kērēēnkōōk ākoy Filiibi. Ki wōō *꞉kiriinkooni ām yēēmēētaab Maketoonnya ankikiikunam ꞉kōōrēētaab Rooma ānkubāw. Kikēēbēēnii wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nto mii yēē ki bēsyēētaab *Sabaato, keechuyte kiriing' saang' ankeebe ākoy yēē kibo āynēēt wōlēē kikeenyoorte yēē kisooyēē ꞉Yuutayeek. Kiibuur ng'wēny ānkēētoowu kēēng'āloolchi chēēbyōōsōōk chēē kikiiruruukyi keey yooto. ");
INSERT INTO spyNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kimii ꞉cheebyoosyeet ake yooto nyēē /kikēēkuurēē Liitya nyēē kyooltootē sirooy chēē ki ārroonēch chēbo āliisyēēt nyēbo barak miisin. Kichōōnēē ꞉cheebyoosyaanaa kiriinkēēt ake nyēē /kikēēkuurēē Tyaatiira ānkikutunkyinē Yēyiin. Kiyey ꞉Yēyiin cheebyoosyaanaa kōōyēnchi ng'aleekaab Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Yu /kabokeebatisan āk biikyii, kumwoowēēch kule, “Yoo ōchāmē kule āyēnchinē ꞉anii Mokoryoontēēt, okwaa bōōbēēnii kōōnyuu.” Yooto, keecham keebe. ");
INSERT INTO spyNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nto mii bēsyēēt ake, yēē kikēēmiitē kēēbēētii yēē /kikēēsooyēē, kutuuyēēnēēch ꞉chēēbto ake nyēē ki motwooriin ānkiboonto *tāmirmiryēēt nyēē miyaat nyēē kiyēyē chēēbooto kuyey sookēyēēk. Kiyibchinē ꞉chēēbi biikyii choo kiyēchinē yiisyēēt beesaanik chēē chaang' chēē kinyōōrtooy sookēyēēchoo. ");
INSERT INTO spyNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Kiinoomootēēch ꞉chēēboo kukuurchinootē barak kule, “Yēchinē ꞉bichu yiisyēēt Yēyiin nyoo mii kibkōōnkōy ānkumii bokōōboorwook wōlēē +/makiiraraaktaak.” ");
INSERT INTO spyNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kimwaayaat kuu nyooto ām bēsyōōsyēk chēē chaang' kut kooyiim Bāwulō ꞉ng'aleekyii. Yooto, kuweech keey ꞉Bāwulō ānkōōburyoong'to tāmirmiryoonoo kule, “Āmwoowuung' ām kaayneetaab Yēēsu *Kiriistō kule ichuwunee chēēbi.” Kuchuwunee ꞉tāmirmiryoonoo chēēboo areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Yu kakas ꞉biiko choo kiyēchinē ꞉chēēboo yiisyēēt kule kāākubot ꞉kēēlng'waa nyēē kōnyōōrunēē beesaanik, kunam Bāwulō āk Siila ānkukwēryoot ākoy kōōk wōlēē /kibokiikuum. ");
INSERT INTO spyNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","/Kikēēmwoochi kōōkwēēt kule, “Yuutayeek ꞉bichu! Mii kuyibu wōōrōōryēēt kiriinkēēnyoo. ");
INSERT INTO spyNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Inēētē biikyoo kurub ātēbuutēk chēē mānyoolchēēch acheek biikaab Rooma.” ");
INSERT INTO spyNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yu kākēēmwooy kuu nyooto, kōōrōōbēr ꞉biiko chēē kikiiruruukyi keey yooto. Kumwooy ꞉kiirwookichoo kule, “Ōbuutēē sirook ānkōōbir!” ");
INSERT INTO spyNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Yu /kāākēēbir, /bokeekerta kō. /Kikiikāloonchi riibiintēētaab kōyooto kuriibso nyēē karaam. ");
INSERT INTO spyNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kiwēēto ꞉riibiintoonoo Bāwulō āk Siila ankuwokukerta kisēēnkēēt nyēē kibo āriit /ankiikiichee kērēēnkōōkwaa musukook /ankeekwiiliilee musukoochoo nyōrōōrōōnik. ");
INSERT INTO spyNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nto yu makuyit kwēēmooy kwēēn, kumii ꞉Bāwulō ākoo Siila kusooyē ānkutyēēnchinē Yēyiin kōōkoostooy, kimii ꞉kibratiisyek chuut alake kuyēbchinē yiit. ");
INSERT INTO spyNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nto nyēē mā tyaa, kuchō ꞉kibring'ring'nyēēt ankooluchluuch kōōto ng'wēny kut kuyootākiis ꞉kurkootik tukul kule bōt! Kōōtyookiis ꞉nyōrōōrōōnik choo /kikikeeratee chii ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Yooto, kukās ꞉chiito nyoo kiriibsē. Nto bērē kukas kuyootootiin ꞉kurkootik, kung'us chōōkiinyii kumāchē kule kubusuy keey kubērē tōōs kāākumwēy ꞉kibratiisyek. ");
INSERT INTO spyNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nteenee kubōlchi ꞉Bāwulō kule, “So! Imāchē i-āmchi keey nee? Ntēē acheek ꞉chu kēēmiitē ꞉tukul yu.” ");
INSERT INTO spyNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kumwooy ꞉riibiintoonoo kule, “Ōkwēng'woo, baa, maata!” Kuryaakta ām bōōtoonik ānkuwokōōbutyi kērēēnkōōkaab Bāwulō ākoo Siila. ");
INSERT INTO spyNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Yooto, koomut ꞉chiichooto mbo Bāwulō kukwa saang' ānkumwoochi kule, “Murēchu, +maayey ꞉anii kule nee /sikiiraraachaa?” ");
INSERT INTO spyNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","/Kēēkētyi kule, “Māchāktōōs iyēnchi Mokoryoontēēt Yēēsu. Yoo !keeyey kuu nyooto, +/makiiraraachiing' āk kang'uung' kumukuul.” ");
INSERT INTO spyNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Yooto, /kyoomchi chiichooto ng'ālyoontēētaab Yēyiin āk biikaab kanyii. ");
INSERT INTO spyNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kiwēēto ꞉chiichooto icheek kwēēmowuunooto ākoy kanyii ānkōōnyoochi ng'woowōōk. Yooto /keebatisan chiichoo āk biikaab kanyii tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kikwēryoot Bāwulō āk Siila kō ankubay. King'ērēkiis ꞉biikyii kutēē yēē tēē, kuuyu kikiikōōyēnchi ꞉icheek Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Yu kayyeech, kōōyookto ꞉kiirwookichoo biiko kuba kaab riibiintoonoo. Nto yitē, kumwoochinē kule, “/Kākēēmwooy kule ityaakte bichoo.” ");
INSERT INTO spyNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yooto, kumwoochi ꞉riibiintoonoo Bāwulō kule, “Kāākumwooy ꞉kiirwookichoo kule /kiityaaktaak. Kunyoo, obeete kaalyeet.” ");
INSERT INTO spyNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nteenee kumwoochi ꞉Bāwulō bichoo /kikiiyooku kule, “Kōbirēēnēēch ꞉kiirwookichoo wōlēē chaang' ꞉biich āmānyōōr kiy nyēē kikeeleel ānkēēyēku sinee ꞉nkacheek biikaab Rooma. Kokerteech mbo subak kāābēērit. Kunyoo ii, ām nee yu māchē ꞉icheek kootyaakteech kibchamumu? ‑Māwuu nyoo mbo kisich! Bōōmwoochi kukwa ꞉icheek nkit bokōō-āmiisootēēch keechuyte.” ");
INSERT INTO spyNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kibokumwaayta ꞉bichoo ng'aleechaa. Nto yu kēēnkēt ꞉kiirwookichoo kule kibo ꞉Bāwulō ākoo Siila kōōrēētaab Rooma, kunam kuut. ");
INSERT INTO spyNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kukwa ānkusoom mbo Bāwulō nyooyeetaab kaat. Nto mii yoo, kuyoot ānkōō-āmiisoot kung'ēētyēē kōyooto ankusaaysaay kule kung'ēētyēē ꞉icheek kiriinkoonooto. ");
INSERT INTO spyNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Yu /kābokēēyoot Bāwulō ākoo Siila, kuba ākoy kōōtaab Liitya. Kinyoorta mbo ng'eetaabiya wōlooto. Kiititiir icheek, nto mii yoo, kubēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nto mii yoo kumur ꞉mbo Bāwulō *kiriinkēētaab Āmfibōōli āk nyēbo Aboloonnya nto yityo, kuyit *kiriinkēētaab Tēēsālōōnikē. Kimii wōlooto *꞉kōōtaab saayeet nyēbo Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kwoomchi ꞉icheek Yuutayeek chēē kimii wōlooto ng'ālyoontēētaab Yēyiin kuu wōloo kwōōyēytooy kwaak. Kiirwookyinēē biiko *kōōtaab saayeet ām bēsyōōsyēkaab *Sabaato sōmōk, kurubta keey āk siruutēkaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kirārchi ꞉Bāwulō biiko ng'aleek kōōboorchinē kule kiyēmāktōōs kunyalil *꞉Kāārārookiintēēt ankung'eetee meet. Kimwooy kule, “Yēēsu nyiitēnyi āmiitē ā-āmwook ꞉nyēē Kāārārookiintēēt nyoo kikēēkānyoonu.” ");
INSERT INTO spyNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kichāmchiin ꞉Yuutayeek kereeryaanto ng'aleekaab Bāwulō ānkuris icheek. Kiiyēnchi nkicheek ꞉Kirikiik wōlēē wōō Yēyiin ākoo chēēbyōōsōōy chēē chaang' chēē kitookunootiin. ");
INSERT INTO spyNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nteenee kimēēchi ꞉moo Yuutayeek alak. Kibokōōruruukootēē biich chēē kāwōōt wōlēē chaang' ꞉biiko ānkutoow wōōrōōryēēt ām kiriinkoonooto. Kiba ꞉bichoo areet akeenke ākoy kaab chiito ake nyēē /kikēēkuurēē Chāāsōōn bokucheeng'ee Bāwulō ākoo Siila wōlooto, sukukwēryoot ākoy kōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nto yu kimānāānyōōr, kunam Chāāsōōn āk mbo ng'eetaabiya alak ankoobarbaartaat ākoy taayeetaab kāāntōōyikaab kiriinkoonooto. Kibōloobōl ꞉bichoo kule, “Kookutankwar ꞉bichu kōōrēēt kumukuul neennyi kookukwa ākoy wōli. ");
INSERT INTO spyNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yu kabokukwa wōli, kutaach ꞉Chāāsōōn ām kanyii. Chwēēsē ꞉bichu mākuutēk tukul chēbo *Kayisaar kumwooyē kule mii ꞉bāytooyiintēēt nkinee ake nyēē kālē /kēēkuurē kule Yēēsu.” ");
INSERT INTO spyNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Yu kabokukas ꞉biiko ākoo kāāntōōyikaab kiriinkoonoo kuu nyoo, kuchēy ꞉taariiryeet. ");
INSERT INTO spyNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nto mii yoo, /kēēmwoochi Chāāsōōn āk alak kule kukwey beesaanik chēē keetyaaktee keey /ankeebakaakta kuba. ");
INSERT INTO spyNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yu katuuyiit ꞉kōōrēēt, kumwoochi ꞉mbo ng'eetaabiya Bāwulō ākoo Siila kule kuba ākoy Bereeya. Kumii ꞉icheek wōlooto, kōōwut *kōōtaab saayeet nyēbo Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ki kāroomēch ꞉ātēbuutēkaab Yuutayeekaab Bereeya kusiir chēbo choo bo Tēēsālōōnikē. Kiityookootiin ꞉moonikwaa kumāchē kule kuyēbchi yiit ng'ālyoontēēt. Kiirōōtootē siruutēk ām bēsyō ake tukul kukas kule ki man ꞉kiyēē kimwooyē ꞉Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kiiyēnchi ꞉Yuutayeek ku chaang'. Kiiyēnchi ꞉nkicheek Kirikiik chēē kitookunootiin chēē chaang', booyik āk chēēbyōōsōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nto yu kēēnkēt ꞉Yuutayeek choo kimiitē Tēēsālōōnikē kule kimii ꞉Bāwulō kwoomtēē ng'ālyoontēēt Bereeya, kuba wōlooto bokōōwuruur biiko. ");
INSERT INTO spyNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yooto, kukwēryoot ꞉mbo ng'eetaabiya alake Bāwulō kuwo komosta nyēē kibo tabantaab araarayta. Nteenee kung'ētunēē ꞉Siila ākoo Tēmētēēwō Bereeya. ");
INSERT INTO spyNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Kii-āmiisoot Bāwulō ākoy *kiriinkēētaab Aaten. Nto mii yoo, kooyeey āk ng'ālyoo nyēē kiyibchi Siila āk Tēmētēēwō kule kimāchāktōōs ꞉icheek kusarta keey areet akeenke bokutuuyo āk Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nto kutākumiitē ꞉Bāwulō kukānyiisyē ām Aaten, kung'woonchi yu kawokukas kule kiboontootē ꞉biikaab kiriinkoonooto āynātōōs chēē chaang' chēē /kēēkutunkyinē. ");
INSERT INTO spyNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yooto, kōōrwookyi ꞉inee Yuutayeek ām *kōōtaab saayeet yēē ki Sabaato kunam wōlēē miitē ꞉Kirikiik chēē kiiywēyē Yēyiin. Kiirwoochē mbo subak bēsyō ake tukul ām wōloo chaang' ꞉biiko āk Kirikiik chēē kanyoorta wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kikwiil ꞉biiko alake Bāwulō chēē kimwooyē kule ibēliisyē ꞉ng'erekweek ām kōōrēēt tukul, ankukwiil mbo ꞉alake chēē kiikoosēē keey kiirnātēēng'waa /ānkimākēēwēēchē. Kiteebee keey ꞉alake kule, “Chokwooltumoonchinē ng'oo ꞉nyi ēē?” Kimwooy ꞉nkicheek alake ām yooto kule, “Nto yu wuu nyēē māchē kule kōōrērēēchēēch kule kēēkutunkyi āynāt nyēē mā nyēēnyoo.” Kimwooy ꞉bichooto kuu nyooto, kuuyu kimii ꞉Bāwulō kwoomchinē biiko kurubta keey āk Yēēsu āk ng'eeteetaab meet. ");
INSERT INTO spyNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nto mii yoo, /kēēkwēryoot Bāwulō ākoy yēē kibo lekemeet ake nyēē /kikēēkuurēē Areeyobaako yēē kibo kāābkiirwook. Nto yityo /keeteebee kule, “Mwoowēēch, baa, inēētē nee ꞉ng'aleechu imwooyē? ");
INSERT INTO spyNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Imiitē iyibwēēch ng'al chēē leelach kule keekas. Kunyoo, kēēmāchē kiinkēt kule ibooru nee.” ");
INSERT INTO spyNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kikicham ꞉biikaab Aaten ākoo biiko alak kōōwoonkyinē āsiiswēkwaa kuyēbchinē yiit ng'al chēē leelach. ");
INSERT INTO spyNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Yooto, kōōyyo ꞉Bāwulō ām kōōkwoonoo bo Areeyobaako ānkumwooy kule, “Lēyyē, biikaab Aaten! Ānkētē sinee kule ām kēēlto ake tukul kyoocham ōsooyē. ");
INSERT INTO spyNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kāānkāābērē āwēēsyētootēē wōlto ake tukul, ānyōōru tukuukwook chēē ōkutunkyinē. !Kaakas mbo yēēt ake yēē /kikeesir kule: YĒYIIN NYĒĒ ‑/MĀKIINKĒTĒ. Kunyi, nee ꞉kiyoo kyōōkutunkyinē āmēēbērē kyōōnkētē? Kiyooto nanyuun nyi āmiitē wāā-āmwook. ");
INSERT INTO spyNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yēyiin nyoo kiyēyē kōōrēēt āk kiy ake tukul nyoo mii āriit, ku Mokoryoontēētaab barak āk ng'wēny nyēē mēēbērē minyootē koorin chēē tēēkyinootē ꞉biich. ");
INSERT INTO spyNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Māmāchē kiy ake tukul nyēē imuuchē ꞉biiko kōōkoochi, kuuyu inee ꞉nyēē ikoochinē chii ake tukul soboonto ākoo kiy ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kiyey ꞉Yēyiin chiito akeenke kurook. Nto mii yoo, chokurōōbunēē keey ꞉biiko mooyēētaab chiichoo sukung'eet kuminy kōōrēēt. Kisat mbo subak ꞉Yēyiin bēsyōōsyēk chēē mākuminyēē ꞉bōrōryōōsyēk kōōrēēt āk wōlēē mābokuminyoot. ");
INSERT INTO spyNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kiyey kuu nyooto sukung'eet kutorobēnoot ꞉biiko nto anyuun kunyōōr inee, ānkoo sinee mēēbērē kiilōōyiityi keey chii ake tukul ām acheek. ");
INSERT INTO spyNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nto kimāmiitē ꞉inee, nto ‑mākēētinyē soboonto. Kuu yoo kisirē ꞉siriikwook alake kule, ‘Kēēyēku ꞉nkacheek cheechii.’ ");
INSERT INTO spyNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kunyoo, kuuyu kēēbooyē Yēyiin, keekerkeeye āk inee. Māmāchāktōōs kiisōōtē kule kerkeey ꞉Yēyiin āk tukuuk chēē kiyēyiisyēē ꞉biiko ng'oomnānēēt ankung'ulunee *ta-aabuut, *feeteet nto rwaanteet. ");
INSERT INTO spyNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ām taay, kikiimiiny ꞉Yēyiin mēt ām bēērbēēryo nyēē wuu nyoo, nteenee mwoochinē ra chii ake tukul kule māchāktōōs ꞉chii kureeny keey. ");
INSERT INTO spyNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kiikuchōb ꞉Yēyiin bēsyēēt nyēē ikuumunēē biich ām kēēlto nyēē rootaat kubununēē chii nyēē kiikutool. Kiikōōboorchinēē ꞉Yēyiin biiko tukul ng'ālyoontoonoo, yoo kiing'ēētēē chiichooto meet.” ");
INSERT INTO spyNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Yu kabokukas ꞉bichoo ng'aleek chēbo ng'eeteetaab meet, kuroorchi ꞉alake Bāwulō, nto alak kumwooy ꞉choo kule, “Tēēchōō subak tāchēē-āmwēēch ng'aleechaa ēē, wē.” ");
INSERT INTO spyNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yooto, kubakaakta ꞉Bāwulō bichoo. ");
INSERT INTO spyNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nteenee kikiilchi ꞉alake Bāwulō ānkōōyēnchi ng'ālyoontēēt. Ām bichooto kiiyēnchinē, kimii ꞉akeenke nyēē /kikēēkuurēē Tyoonisyō nyēē ki akeenke nyēē kibo kōōkwēētaab Areeyobaako ākoo mbo nkinee cheebyoosya nyēē /kikēēkuurēē Tamaari āk nkicheek biiko alak. ");
INSERT INTO spyNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yu kāwokubēk ꞉ng'aleechaa, kung'eetee ꞉Bāwulō Aaten ānkuwo ākoy Kōōriintō. ");
INSERT INTO spyNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kinyoorta wōlooto Yuutāyiintēēt ake nyēē /kikēēkuurēē Akiila. Kibo ꞉chiichi kōōrēēt ake nyēē /kikēēkuurēē Bōōntō. Kitākuchōōnēē ꞉chiichooto kōōrēētaab Itaalya kuboontoonu keey cheebyoosyeenyii nyēē /kikēēkuurēē Brisiila. King'ēētyēē ꞉bichoo Itaalya, kuuyu kimwooy ꞉Kilaawutiyo nyēē ki bāytooyiintēētaab wōlooto kule kung'ēētyēē ꞉Yuutayeek tukul Rooma. ");
INSERT INTO spyNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nto kuuyu kiyēytooy ꞉Bāwulō kēryōōsyēk kuyēwunēē mwēēnik, yiisyēēt nyēē kiyēyē ꞉nkicheek chuut, kuwo wokutēbto keey sukuyēyiisyē ꞉tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kiwēētii ꞉Bāwulō wokōōrwoochē āk biiko ām *kōōtaab saayeet bēsyō ake tukul nyēbo *Sabaato. Kisyēēmē ꞉Bāwulō kule nto yis Yuutayeek āk Kirikiik. ");
INSERT INTO spyNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Yooto, kuchōōnēē ꞉Siila ākoo Tēmētēēwō Maketoonnya, kunyōōru Bāwulō kōōkiilchinē keey amtaayeetaab ng'ālyoontēēt kumwoochinē Yuutayeek kule Yēēsu ku *Kāārārookiintēēt nyoo /kikēēkānyoonu. ");
INSERT INTO spyNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nteenee kikwiil ꞉Yuutayeechaa Bāwulō ānkuchubsēēt. Nto mii yoo, kōōrēēk ꞉Bāwulō kābuutiinyii ānkubirto kulēlēkyi keey ꞉tēērtit bichooto kukatay ng'aleekwaa, ānkumwoochi kule, “Kwaamaak ꞉korotiikwook nkityō. Ābēērē keey ꞉anii. Kunyi, kung'eetee raat ānkuwo taay, +māāwēētii wōlēē mii ꞉biiko choo mā Yuutayeek.” ");
INSERT INTO spyNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Yooto, kung'eetee ꞉Bāwulō kōyoo bo saayeet ānkuwo kayta ake nyēē kilēēkitēē yooto nyēbo chiito ake nyēē /kikēēkuurēē Tiitō Yuustō nyēē kikutunkyinē Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kimii ꞉chiito ake nyēē kiiyyoonkyinē kōyooto bo saayeet nyēē /kikēēkuurēē Kiriisbō. Yooto kuchamta ꞉chiichoo āk biikaab kanyii Yēēsu. Kiiyēnchi mbo nkicheek ꞉biiko alake chēē kibo Kōōriintō Mokoryoontēēt /ankeebatisan. ");
INSERT INTO spyNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nto mii kwēēmowuut ake, kukuurchi ꞉Yēyiin Bāwulō ām ng'oong'uutyēēt kule, “Bāwulō, ‑mēēmuy. Itas taay i-amte lōkōōywēk, ");
INSERT INTO spyNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kuuyu kēēboontē keey ꞉tukwaay nyēē mākoy kuyeyeeniing' ꞉chii kiy. Āboontē biikyuu chēē chaang' ām kiriinkooni.” ");
INSERT INTO spyNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kunyoo, kiibuur ꞉Bāwulō wōlooto ām kēnyiit akeenke āk ārook lo kōōnēētē biiko ng'ālyoontēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Yu kitākōōyyoonkyinē ꞉chiito ake nyēē /kikēēkuurēē Kāliiyō yēēmēētaab Akaaya, kōōyoomo keey ꞉Yuutayeek ānkubooryēē Bāwulō ānkukwēryoot ākoy kōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Yu /kakiiyiitita, kumwooy ꞉bichooto kule, “Mii ꞉chiichi kuwēēchē biiko kule kukutunkyi Yēyiin ām kēēlto nyēē mānāmē keey āk wōlēē mwooytooy ꞉kiruutēkyoo.” ");
INSERT INTO spyNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nto baanta nyooto māchē kutwēk ꞉Bāwulō, kumwoochi ꞉Kāliiyō Yuutayeek kule, “Nto kōōng'unyng'uunkyinē ꞉akweek ng'ālyoo nyēē miyaat nto nyēbo ng'ōōki nyēē /kakeeyey, nto kāāyēbchinē yiit. ");
INSERT INTO spyNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kukwaaneenaak wōlēē +moosatite, kuuyu rubtooy keey ꞉riirikwook āk ng'al, kooynōōk āk kiruutēkwook. Māmii ꞉kiyēē ātiilē ꞉anii kurubta keey āk ng'al chēē wuu choo.” ");
INSERT INTO spyNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kunyoo, kukwet bichooto kuba saang'. ");
INSERT INTO spyNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yooto, kuwēēkyi keey ꞉bichooto Sōōstēēn chiichoo kiiyyoonkyinē *kōōtaab saayeet. /Kēēbir kukāsē ꞉biiko ām kōōk, nteenee manaakas ꞉Kāliiyō yēēt kiy. ");
INSERT INTO spyNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Kibēēni ꞉Bāwulō Kōōriintō bēsyōōs chēē mā tyaa. Nto mii yoo, kubakaakta mbo ng'eetaabiya kumāchē kule kuwēētēē mwēēnkēēt kutākyi keey Siirya. Kiboonto keey Brisiila ākoo Akiila. Nto kumii yēēt ake yēē /kikēēkuurēē Keenkereeya kutākukānyē kuwo, /kēērwookyi buutēēk kuuyu kikiikoowaal keey kōōtāboonchi keey Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Yu /kaakeerwaach, kunam baanta. Nto yu kabokuyit wōlēē /kikēēkuurēē Ēfēēsō, kubakaakta ꞉Bāwulō Brisiila ākoo Akiila. Kiwo ku inee keey ānkōōwut *kōōtaab saayeet ānkutoow kōōrwooch āk Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Kisaaysaay ꞉bichooto Bāwulō kule tākōōbuurto keey tukul, nteenee kitāyiis. ");
INSERT INTO spyNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nto yu kimii kung'ēētēē yooto kumāchē kuwēēchi keey, kukuurtoochi kule, “Yoo kacham ꞉Yēyiin, +māāyēēwu.” Yooto, kung'eetee Ēfēēsō. ");
INSERT INTO spyNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Yu kāwokuyit ꞉Bāwulō Kayisareeya, kutas taay āk baannyii wokoosubaay kaniseetaab Yēērusālēēm. Yu kābēk ꞉bēsyōōs chēē ng'ēri, kurēkto Antyookya. ");
INSERT INTO spyNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kibēēni nkinee wōlooto bēsyōōsyēk chēē mā tyaa. Nto yityo, kuwēēsyētootēē komoswookik chēē chaang' chēbo yēēmēētaab Kalatyaa āk nyēbo Fruukya kōōtitiirootē biikaab Kiriistō kutēē yooto tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kimii ꞉Yuutāyiintēēt ake nyēē /kikēēkuurēē Ābōōlō nyēē kibo *kiriinkēētaab Alekisaantrya. Ki chii nyēē ki kibsumannyaa ānkiboonto kiirnātēēt nyēē wōō miisin ām komostaab siruutēkaab Yēyiin. Kiwo ꞉chiichoo Ēfēēsō. ");
INSERT INTO spyNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","/Kikiikiineet kunam kēēltaab Mokoryoontēēt ānking'āloolēē Yēēsu ām mooyēēt akeenke, kōōnēētē ām kēēlto nyēē karaam kurubta keey āk Yēēsu, nteenee, kiinkētē baateey kurubta keey āk bātisāniisyēētaab Yoowaana. ");
INSERT INTO spyNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kitoow ꞉chiichooto kung'alaal nyēbo nyikanat ām *kōōtaab saayeet. Yu kāwokuyēbchi yiit ꞉Brisiila āk Akiila ng'aleekaab Ābōōlō, kukuur kuwo kōōng'waa ānkubokurārchi ām kēēlto nyēē yemaat kurubta keey āk kēēltaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Yu kimāchē ꞉Ābōōlō kuwo Akaaya, kōōkimkiim inee ꞉mbo ng'eetaabiya /ānkēēsirchi biikaab Kiriistō chēē kimii yēēmēētaab Akaaya kule kutaach inee. Nto kuyitē, kuyēētyēēchi ꞉Yēyiin kōōtitiir biiko choo kikiikōōyēnchi Yēēsu kubununēē chamateetaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wuu nyooto, kuuyu kiibēl ꞉inee kwiilateetaab Yuutayeek ām nkuruuk tukul kukāsē ꞉biiko. Kōōboorunēē siruutēk kule *Kāārārookiintēēt ꞉Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nto yu kitākumiitē ꞉Ābōōlō Kōōriintō, kunam ꞉Bāwulō baanta kumur kēēltaab rōōrōōk ākoy Ēfēēsō. Kiwokunyoorta wōlooto rubiik alak. ");
INSERT INTO spyNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Yooto, kuteebee ꞉inee bichooto kule, “Ara kyōōnyōōru Tāmirmiryēētaab Yēyiin, yu kābōōyēnchi, nto nee?” /Kēēkētyi Bāwulō kule, “Acha, ntēē manaakeekas mbo kule ākoo mii ꞉Tāmirmiryēētaab Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kuteebee subak ꞉Bāwulō icheek kule, “Nto ii, bātisāniisyēēt nyēē wuu nee nyēē kyōōnyōōru akweek?” /Kēēkētyi kule, “Kikēēnyōōru nyoo kibo Yoowaana.” ");
INSERT INTO spyNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Yooto, kumwoochi ꞉Bāwulō kule, “Kibo ꞉bātisāniisyēētaab Yoowaana kule kuweek ꞉biiko. Kimwoochinē ꞉Yoowaana biiko kule kōōyēnchi chiito nyēē kimākuchō ām lētuunyii. Nto chiichooto ku Yēēsu.” ");
INSERT INTO spyNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Yu kakas ꞉bichoo kuu nyooto, /keebatisan bakeenke ām kaayneetaab Mokoryoontēēt Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Yu kātiinyēē ꞉Bāwulō bichooto āwunnyēk, kōōsuuchi ꞉Tāmirmiryēētaab Yēyiin. Yooto, kung'alaal ꞉alake kuutuweek chēē kimēēnkētē ankwaamta ꞉alake kiyēē kiiboorchi ꞉Tāmirmiryēētaab Yēyiin ām kuutiit nyēē kiinkētē. ");
INSERT INTO spyNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kimāchē kuyitē ꞉laatitaab bichooto tukul taman āk āyēēng'. ");
INSERT INTO spyNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kiiwutē ꞉Bāwulō *kōōtaab saayeet ānkwoomtooy lōkōōywēk ām nyikanateet. Kyaamta lōkōōywēchoo ārook sōmōk kōōrwoochē āk biiko kumāchē kule nto yis kurubta keey āk wōlēē wuu ꞉bāytooyiisyēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nteenee kiiyaam ꞉biiko alake mētēwoy. Kimwooy mbo ām taayeetaab biiko ng'al chēbo rōkōs kurubta keey āk ‘kēēltaab Yēēsu.’ Kunyoo, kubakaakta ꞉Bāwulō bichoo ānkuwēēto keey biiko choo kikiikuchamta Yēēsu. Kiirwookyinēē kaniseetaab bēsyō ake tukul kōōtaab kāānēētiisyēēt nyēē kiiyyoonkyinē ꞉chiito ake nyēē /kikēēkuurēē Turaano. ");
INSERT INTO spyNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kitas taay ꞉inee kuu nyooto kēnyiisyēk āyēēng' kut koomuuch kukas ꞉biiko tukul chēē kiminyē yēēmēētaab Eesya ng'ālyoontēētaab Yēyiin, kunam wōlēē mii ꞉Yuutayeek ākoo Kirikiik. ");
INSERT INTO spyNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kiyey ꞉Yēyiin tukuuk chēē /kiilātē kubuntēē Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","/Kyāānkēēyib mbo ankoosyek āk sirook chēē kikiikutiiny ꞉Bāwulō kuba wōlēē mii ꞉biiko chēē kimnyoontōōs kusobtōōs ānkuchuwunēē ꞉tāmirmirook chēē miyootēch. ");
INSERT INTO spyNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kimii ꞉Yuutayeek alake chēē kibērē nto ibēbēēto tāmirmirook chēē miyootēch kung'ēētyēē biiko. Kisyēēmē kule nto yēyiisyēē kaayneetaab Mokoryoontēēt Yēēsu ām choo kikiikunam ꞉tāmirmirook chēē miyootēch. Kiimuuchē kumwooy kule, “Āmwoowook ām kaayneetaab Yēēsu nyoo āmtootē ꞉Bāwulō kule ochuwu!” ");
INSERT INTO spyNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Biiko alak ām chooto ku wēērin tisab chēbo boontēēt ake nyēē /kikēēkuurēē Sikeefa nyēē ki kibkōrōs nyēē wōō. Yu kāmwoochi ꞉bichooto *tāmirmiryēēt nyēē miyaat kuu nyooto, ");
INSERT INTO spyNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","kukētyi ꞉tāmirmiryoonoo kule, “Ānkēt ꞉anii Yēēsu ānkāānkētē ng'ālyoo kurubta keey āk Bāwulō, nto akweek ku ng'oo?” ");
INSERT INTO spyNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kutēryēkyi ꞉chiichoo kiboonto tāmirmiryoonoo miyaat bichoo ankooluukset nyēē ‑/mākyoomu kut kunyulee ng'wēny. Kiryaakta ꞉bichooto kuba saang' kōōbēēnootē /ankaakeesaksakanee sirook kule tōng'! ");
INSERT INTO spyNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Yu kābokuyityi ꞉ng'aleechaa Yuutayeek ākoo Kirikiik chēē kiminyē Ēfēēsō, kumuuyo ꞉tukul. /Kikiikaasta kaayneetaab Mokoryoontēēt Yēēsu miisin. ");
INSERT INTO spyNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kikwa ꞉biiko chēē chaang' choo kikiikuchamta Yēēsu ānkumwooy choolwookātēēng'waa. ");
INSERT INTO spyNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kukwa mbo ꞉nkicheek alake chēē kiyēyootē mosoonkoyeenik ankubokubeel kitaabuunekwaa kukāsē ꞉biiko. Nto bērē kōōyiit ꞉bichooto tukuuk chēē kyooroon, kiyitē beesaan chēē mātēē chu. ");
INSERT INTO spyNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ām kēēliitēnyi kuchamta ꞉biiko chēē chaang' Yēēsu. Kiyesta ꞉ng'ālyoontēētaab Yēyiin ānkunyōōr nkuruuk. ");
INSERT INTO spyNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Yu kāākuyēyākiis ꞉ng'aleechu tukul, koosoot ꞉Bāwulō kule kuwo Yēērusālēēm kumāchē kule kubuntēē Maketoonnya āk Akaaya. Kimwooy kule, “Yoo kāābuur wōlooto, +māāruutoochi Rooma nkinee.” ");
INSERT INTO spyNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Yooto, kōōyookto Tēmētēēwō ākoo Eraasto chēē kiyēētyēēchinootē kuba Maketoonnya, nteenee king'ētunēē ꞉inee yēēmēētaab Eesya bēsyōōsyēk chēē ng'ēri. ");
INSERT INTO spyNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kitoow keey ꞉wōōrōōryēēt ām Eesya nyēē mā mining' kurubta keey āk kēēltaab Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kimii ꞉kiitoong'iintēēt ake nyēbo karin nyēē /kikēēkuurēē Tēmētēēryō. Kiitoonyē ꞉chiichi kiy nyēē kiikerkeeyee kōōtaab *Ārtēmiis nyēē āynāt koorko kung'ulunēē *feeteet. Kiboor ꞉biiko miisin chēē kiyēyē yiisyoonoo. ");
INSERT INTO spyNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Yooto, kukuur ꞉Tēmētēēryō bichooto āk alak chēē kiyēyē yiisyēēt nyēē wuu nyooto ānkumwoochi tukul kule, “Murēchu, ōnkētē kule kēēboorē ꞉acheek miisin ām yiisyooni. ");
INSERT INTO spyNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kookasee mbo koonyekwook āk yiitiik kule kookuweech ꞉chiichi /kēēbērē Bāwulō biiko ku chaang' ām wōli bo Ēfēēsō āk yēēmēētaab Eesya kumukuul. Mwooyē ꞉chiichi kule ng'al chēbo bēērbēēryo /kēēkutunkyinootē tukuuk chēē yēyootē ꞉biich ām āwunnyēkwaa. ");
INSERT INTO spyNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mii ꞉miyootyēēt nyēē mākutook āmēēbērē baateey kule +/makeenyiil yiisyooninyoo, nteenee makuchwees ꞉biiko kōōtaab Ārtēmiis. Inee ꞉nyoo /kēēkutunkyinē ām yēēmēētaab Eesya tukul āk kōōrēēt kumukuul. Yoo karubta yuutēyu, mākubot ꞉wōōyinto nyoo boonto.” ");
INSERT INTO spyNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Yu kakas ꞉bichooto ng'aleechaa, kunyēēr ānkubōloobōl kule, “Wōō *꞉Ārtēmiis nyoo bo biikaab Ēfēēsō!” ");
INSERT INTO spyNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kuchēy ꞉taariiryeet ām *kiriinkēēt kumukuul. Kunam ꞉biiko chiito ake nyēē /kikēēkuurēē Kāyō ākoo ake nyēē /kikēēkuurēē Aristaarko chēē kibo ꞉tukwaay Maketoonnya ānkiboontootē keey Bāwulō ām baannyii. /Kikeesar bichooto ākoy yēēt ake yēē /kikēēkāsēē ārēērōōsyēk. ");
INSERT INTO spyNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Kimach ꞉Bāwulō kule kuwo wōlooto kimii ꞉bichoo, nteenee kuket ꞉rubiik. ");
INSERT INTO spyNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kiisōōw Bāwulō ꞉chōōrōōnuutēkyii alake chēē ki biich chēē ki wōōyēch ām yēēmēēt kule māwo wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kichuunchuun ꞉biiko tukul ām yooto. Kimwooyē ꞉alake chu, kumwooyē ꞉alake choo. Kimēēnkētē mbo ꞉biiko chēē chaang' kiyēē kibēēchinē wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yooto, kuwunukto ꞉Yuutayeek Alekisaanta kuwo taay /ānkēēbōloobōlchi kung'alaal. Kumwechee biiko āwunnyēk kule kusiisyo sukung'eet kumwooy ām taayeetaab biiko ng'ālyoo nyēē tuuchēē ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nto yu kābokōōnkēt ꞉biiko kule ākoo ki Yuutāyiin ꞉Alekisaanta, kōōchuulyo ām āsiiswēk āyēēng' kukuurchinē barak kumwooyē kule, “Wōō ꞉Ārtēmiis nyoo bo biikaab Ēfēēsō.” ");
INSERT INTO spyNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Yooto, koosiis icheek ꞉chiito nyēē wōō nyēbo kiriinkoonooto, nto mii yoo, kumwoochi kule, “Murēchu bo Ēfēēsō! ‑/Mākiinkētē ām kōōrēēt kumukuul kule *kiriinkēētaab Ēfēēsō nyēē riibē kōōtaab Ārtēmiis nyoo wōō āk mbo kitōōntōyēēnyii nyoo /kikiirārooku kuchōōnēē barak? ");
INSERT INTO spyNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kunyoo, kuuyu ‑/mākēētuuchē ng'aleechu bo man, kumāchāktōōs ōsiisyē āmōōtēēltēēlēnē. ");
INSERT INTO spyNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kōōkwēru bichu kukwa yu, āmēēbērē kang'alaalee Ārtēmiis nyēē miyaat, nto mēēbērē mbo kābut kōōnyii kuchoor kiy. ");
INSERT INTO spyNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Yoo ākoo boonto ꞉Tēmētēēryō āk biikyii choo yēchinē inee yiisyēēt ng'ālyoo nyēē ng'woonchinē ām wōlēē mii ꞉chii, kuyootootiin ꞉kōōkwōōsyēk ānkumii ꞉booyikaab yēēmēēt chēē wōōyēch. Imuuchē ꞉icheek kuyib riirikwaa wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nto yēē kātākumii ꞉ng'ālyoo nyēē kātōōmāchē tōōmwoowu, kumāchāktōōs /kiilyeb ām kōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kuu wōloo wuu kuu nyiitēnyi, kēēmiitē ꞉acheek yēē mii ꞉chii, kuuyu /kiimuuchē /kēēmwooy kule acheek ꞉chēē kākēēyibu wōōrōōryooni ām ng'aleechu kāyēyākiis. Māmii ꞉wōlēē kēētuuktooy keey ām ng'aleechu.” ");
INSERT INTO spyNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Yooto, koochecheey bichoo kubēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Yu kikiikubēk ꞉taariiryaanaa, kōōyookto ꞉Bāwulō /bokēēkuurchi rubiik. Nto yu kikiikōōkimkiim, kubirchi chameetaab keey ānkuwēēchi keey ꞉inee Maketoonnya. ");
INSERT INTO spyNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kiwēēsyētootēē komosaata kōōkiimootēē biiko ng'aleek chēē chaang'. Nto mii yoo, kuyit yēēmēētaab Kiriki. ");
INSERT INTO spyNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kibēēni wōlooto ārook sōmōk. Kumii kuyēytooy keey kumāchē kuwēētēē mwēēnkēēt ākoy Siirya, kusēw kule kikiikuyey ꞉Yuutayeek ruurumuut kule /keebakach inee. Kunyoo, koosoot kule kooyeey kumur Maketoonnya. ");
INSERT INTO spyNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kiwēēto keey chiito ake nyēē /kikēēkuurēē Sobaatiro araab Biirō nyēbo *kiriinkēētaab Bereeya, Aristaarko āk Sēkuuntō chēē kibo ꞉tukwaay Tēēsālōōnikē, Kāyō nyēē kibo Tēērbē, Tēmētēēwō, Tukiikō ākoo Turōfiimō chēē kibo ꞉tukwaay yēēmēētaab Eesya. ");
INSERT INTO spyNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kisimkoonto ꞉bichooto ankubokukanyeech Turoowa. ");
INSERT INTO spyNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yu kāākubēk ꞉Saakweetaab mukaatiin chēē mākuutunootiin, kēēng'ēētyēē ꞉acheek Filiibi keebeetee mwēēnkēēt. Yu kakeeyta ꞉bēsyōōsyēk muutu, kiiyoomē keey āk biiko chuut ām Turoowa ānkēēbēēnii wōlooto bēsyōōsyēk tisab. ");
INSERT INTO spyNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ām bēsyēētaab taayta nyēbo wiikiit, keekwaa ꞉tukul yēēt akeenke sikyoomchiinē āmiik. Kyoomchi ꞉Bāwulō biiko ng'ālyoontēēt ākoy kwēēmooy kwēēn kuuyu kimāchē sukuwo yu kāyyēēkunēē. ");
INSERT INTO spyNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ki chaang' ꞉taariinek chēē kilāytōōs ām koroofa wōli kikēētuuytōōsii nyēē king'ētu ꞉maat. ");
INSERT INTO spyNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kimii ꞉āybēēryoontēēt ake nyēē /kikēēkuurēē Ēwutukō nyēē kimii kukēēbuur yēē kibo tiriisya. Kinam āybēēryoontoonoo ꞉rwoonik chēē nyikiisēch kumii ꞉Bāwulō kutāsē taay kwoomu lōkōōywēk. Yu kikiikōōnuuch kutukul, kōōsuuwunēē koroofeet nyēē kibo sōmōk ānkukwēr ng'wēny kule mbum. Nto bērē /bokeenam, kukaakume. ");
INSERT INTO spyNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Yooto kurēkto ꞉Bāwulō ankuwokwaamut chiichooto ānkumwoochi biiko kule, “‑Mōōmuuyē, nto yu tākusoboot.” ");
INSERT INTO spyNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kooyeey ꞉tukul koroofa. Kubetes ꞉Bāwulō mukaatiit kwoomiis ꞉tukul ankutas taay kung'alaal kuyyeech. Nto yu kayyeech, kuwēēchi keey. ");
INSERT INTO spyNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Yooto, /kiimut āybēēryoontoonoo kuwo kaa kukāākusob. Kibāybāyiitu ꞉bichooto miisin. ");
INSERT INTO spyNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","King'artam ꞉Bāwulō kēēlto kutākyi keey kiriinkēētaab Aaso nteenee kikeebeetee acheek mwēēnkēēt ākoy wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Yu kāwokunyōōrchēēch ꞉Bāwulō Aaso, kēētākyi keey Mituleen nyoo kiikwēēn ꞉bēēko. ");
INSERT INTO spyNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nto mii yu kāyyēēkunēē, kēēng'ēētyēē yooto ām mwēēnkēēt ankeebe ākoy Kiiyoos. Nto bēsyēēt nyēē kiikēērē, kyaay ākoy yēēt ake yēē /kikēēkuurēē Sāāmō. Nto yu kāyyēēkunēē, keeyit kiriinkēētaab Milēētō. ");
INSERT INTO spyNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kikiikootiil ꞉Bāwulō kule kukeeyta kumur Ēfēēsō simēēboot āsiiswēk ām yēēmēētaab Eesya. Kimii kusārtooy keey kumāchē kule yoo keemuuk, kuyit Yēērusālēēm yēē bēsyēētaab *Bēēntēkōōst. ");
INSERT INTO spyNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kumii ꞉Bāwulō Milēētō, kōōyookto /bokēēkuurchi booyik chēbo kaniseetaab Ēfēēsō. ");
INSERT INTO spyNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Yu kayit ꞉booyichooto, kumwoochi kule, “Ōnkētē wōlēē kyāābuurtooy āk akweek kuchakee kēēboontē keey bēsyēētaab taayta nyoo kyāāyitunēē yēēmēētaab Eesya. ");
INSERT INTO spyNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kyāāyibē keey ng'wēny ānkāāmuytooy āyēchinē Mokoryoontēēt yiisyēēt ānkāāmāsē lōōkik kutēē yooto tukul ānkumii ꞉Yuutayeek kuyēwoo ruurumuunēk. ");
INSERT INTO spyNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ōnkētē mbo subak kule mēēbērē kyāāyēēyē lēt ā-āmwook kiy nyēē mākuyēētyēēchook, ntēē kyāānēētē biiko tukul ām yēēt akeenke nto subak aneetaate ām koorin. ");
INSERT INTO spyNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kyāāboorchi Yuutayeek āk Kirikiik kule māchāktōōs ꞉icheek kuweek ām choolwookātēēng'waa ānkuyēēlchi komostaab Yēyiin ankookaasee keey Mokoryoontēēt Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ām yu raat, kāākukērchoo koong' ꞉Tāmirmiryēētaab Yēyiin kule āwē Yēērusālēēm āmāānkētē kiyēē mawokuyeyakay ām wōlēē āmiitē yoo kaayit. ");
INSERT INTO spyNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ānkētē kityō kule ām kiriing' ake tukul, mwoowoo ꞉Tāmirmiryēētaab Yēyiin kule kānyoonwoo ꞉rātiisyēēt āk nyāliluutēk. ");
INSERT INTO spyNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nteenee buch ꞉soboonnyuu yoo kamaawaany labateetaab yiisyēēt nyoo kōōkukōōno ꞉Mokoryoontēēt Yēēsu. Yiisyooni, ku ābooru lōkōōywēk chēē kāroomēch chēbo chamateetaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ānkētē mbo raat kule māmii ꞉chii ām akweek choo kookeebeetaate ꞉tukul kyoomtootē lōkōōywēk kurubta keey āk bāytooyiisyēētaab Yēyiin, ꞉nyēē mawokukasa subak. ");
INSERT INTO spyNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kunyoo, āboorwook raat kule mariireenaa ꞉chii ake tukul yoo kēēboot soboonnyii. ");
INSERT INTO spyNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mēēbērē kyāāmuuny mbo bēsyēēt akeenke ā-āmwook tukuuk tukul chēē māchē ꞉Yēyiin kule oyey. ");
INSERT INTO spyNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ōriib keey ānkōōriib mbo nkicheek biiko choo kiikukwēchook ꞉Tāmirmiryēētaab Yēyiin kule ōriibē. Akweek chēē ō-ākooy biikaab Kiriistō choo kiwālāng'unēē korotiikyii. ");
INSERT INTO spyNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ānkētē kule yoo kāāwēēchi keey ꞉anii, makukwa ꞉suuyiik chēē kōrōōmēch miisin chēē makusankatan kēēchiirēk nyēē māsooyēē. ");
INSERT INTO spyNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Makoobetyeenyee keey ꞉alake wōlēē ōmiitē ānkōōbotboot ng'aleekaab man sukung'eet kōōsōrto biiko kurub icheek. ");
INSERT INTO spyNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kunyoo, ōriib keey, wē, murēchu. Māchē mbo ōsōōtē kule ām kēnyiisyēk sōmōk choo kookukeeyta, kyāātāsē taay ānēētē chii ake tukul ām akweek bēēt āk kwēēmooy kut kutēwu ꞉lōōkik. ");
INSERT INTO spyNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Kunyoo, kāātōōrook āwunnyēkaab Yēyiin āk mbo wōlēē mii ꞉ng'ālyoontēēt nyēbo chamateenyii. Mākōōtitiirook ꞉ng'ālyoontoonoo ānkōōbēruurook tukul choo kiikootabaanaak ōyēku cheechii. ");
INSERT INTO spyNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Manaamach mbo beesyaa nto sira nyēbo chii ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ōnkētē ꞉akweek kubooyiit man kule kyāāyēyēē āwunnyēkyuu kiy ake tukul nyēē kyāāmāchē āk mbo chēē kimāchē ꞉chōōrōōnuutēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ām kiy ake tukul nyēē kyāāyēyē, kyāāboorwook kule ām yiisyō nyēē kyāātitirchinē ām kēēliitēnyi, mākwēēch kēēyēētyēēchinē choo kuskusēch kiisōōtē ng'aleekaab Mokoryoontēēt Yēēsu choo kimwooyē kule, ‘Ibēruuroot ꞉nyoo ikooytooy kusiir nyoo /kiikoochinē.’ ” ");
INSERT INTO spyNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Yu keewaany ꞉Bāwulō kumwooy ng'aleechu, kukutuny āk bichoo tukul ankusaay. ");
INSERT INTO spyNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Yooto kumoot ꞉icheek Bāwulō ānkuriirtōōs kutēē yooto tukul kubirchinē chameetaab keey. ");
INSERT INTO spyNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kiyēē king'woonchi bichooto miisin ku yu kimwooyē ꞉Bāwulō kule mēēbērē tābokukāsē ꞉icheek inee subak. Yooto, kōō-āmiis ākoy yēē kimii ꞉mwēēnkēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Yu kikiikeebchey keey āk bichoo, keebe ankubokeelaany mwēēnkēēt ankeechuul ākoy Kōōs. Nto mii yu kāyyēēkunēē, keenam baanta ākoy Rōōtō. Yu kākēēng'ēētyēē yooto keeyit Bataara. ");
INSERT INTO spyNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kibokeenyoorte mwēēnkēēt wōlooto nyēē kimii kwooytōōs ākoy Fōyinikē. Keelaany ankeebe. ");
INSERT INTO spyNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kikeebe, nto yu kābokēētoobēn Kubrō, kēēmur komostaab cheeronko kēētākyi keey Siirya. Yooto, wokōōyyoonyēē ꞉mwēēnkēēt Tiirō, kuuyu kimāchāktōōs /kiinēm tērēkōōk chēē kimii mwēēnkoonooto. ");
INSERT INTO spyNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kikēēnyōōru biikaab Kiriistō ām wōlooto ānkiibuurtē keey bēsyōōsyēk tisab. Kimwoochi ꞉bichoo Bāwulō kubununēē Tāmirmiryēētaab Yēyiin kule māwo Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Yu kikiikubēk ꞉bēsyōōsyēkyoo ām wōlooto, kēēng'ēētyē ankeetas taay āk baannyoo. Kitaseech ꞉mbo ng'eetaabiya tukul kuboonto keey kooruukwaa āk lēēkōōk. Kikeebe ānkubokēēkutunyēē yēbo sakaramteetaab araarayta ankeesaay. ");
INSERT INTO spyNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Yu kāākēēbirchi keey chameetaab keey, kēēsērēētyē ankubokeelaany ꞉acheek mwēēnkēētkēynyoo ankooyeey ꞉chuut tukul kēēstoonikwaa. ");
INSERT INTO spyNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kikeetas taay ꞉acheek āk baannyoo, kung'eetee Tiirō kut bokeeyit Tolemay. Kikiisubaay mbo ng'eetaabiya ām wōlooto ānkēēbēēnii bēsyēēt akeenke. ");
INSERT INTO spyNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nto yu kāyyēēkunēē, keenam baanta ākoy Kayisareeya. Kitaacheech ꞉āmtooyiintēēt Filibō nyoo ki akeenke ām choo ki tisab choo /kikēēkwēyē ām Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kiboonto ꞉chiichoo tibikyii ang'wan chēē kimanaaba koorin. King'āloolē ng'al chēē kiiboorchinē ꞉Tāmirmiryēētaab Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yu kābokēēbēēnii wōlooto bēsyōōsyēk chēē mā tyaa, kuchōōnēē *꞉wōōrkooyoontēēt ake Yuuteeya nyēē /kikēēkuurēē Akaabo. ");
INSERT INTO spyNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kinam anweetaab suwe nyēbo Bāwulō ankuratee keey bakeenke āwunnyēk āk kērēēnkōōk ānkumwooy kule, “Mwooyē ꞉Tāmirmiryēētaab Yēyiin kule, ‘Makurat ꞉Yuutayeekaab Yēērusālēēm chiitaab ꞉anwaani ām kēēliitēnyi, nto mii yoo kiiyokoochi biiko choo mā Yuutayeek.’ ” ");
INSERT INTO spyNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kēēkāsē ng'aleechaa kibo chiichoo, keesaaysaay ꞉acheek Bāwulō kēēboontē keey āk biiko chēē kimii yooto, kule māwo Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Yooto, kukētwēēch ꞉Bāwulō kule, “Ām nee yu ōriirēēnoo ānkōōyēyē mooyēēnyuu kunwaakan? Mēēbērē ayeytaat /keerata baateey, nteenee achamaat mbo kule āmēēchi Yēērusālēēm kubo kaayneetaab Mokoryoontēēt Yēēsu.” ");
INSERT INTO spyNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kuuyu kimēētākiimuuchē takeesaaysaay, keemwaay kule, “Kubāw ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Keerat keey ankeebe Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kitaseech ꞉rubiik alake ām Kayisareeya ānkukwērēēch ākoy kaytaab chiito nyēē /kikēēkuurēē Munāāsōōn wōlēē kikēēruuyē kwēēmowuunooto. Kibo ꞉chiichi Kubrō ānku inee akeenke ām choo kisimkōōyēnchi Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nto yu kabokeeyit Yēērusālēēm, kutaacheech ꞉mbo ng'eetaabiya ām ng'erekweek chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kikēēruuyē wōlooto, nto yu kāyyēēkunēē, bokeekas Yāākōbō. Kimii ꞉booyik tukul wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Yooto koosubaay ꞉Bāwulō booyichoo ānkurārchi ng'ālyoo ake tukul nyēē kiikuyēchi ꞉Yēēsu biiko choo mā Yuutayeek kubuntēē inee. ");
INSERT INTO spyNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Yu kakas ꞉bichooto ng'aleechaa, kookaasta Yēyiin. Nto mii yoo, kumwoochi Bāwulō kule, “Ng'eetaabiya, miitē ꞉Yuutayeek Yēērusālēēm chēē yitē kisyēērōōk chēē chaang' chēē kiikuchamta Yēēsu nteenee tākuriibē kiruutēkwaa nyēē kōrōōm miisin. ");
INSERT INTO spyNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","/Kōōkēēmwoochi kule 'kwēēnēētē Yuutayeek tukul choo kiikuburuch keey āk choo mā Yuutayeek kule kuweeksee ng'aleekaab *Muusa ameemuraatan lēēkōōk amarub ātēbuutēkaab Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ntēē ākoy kukas ꞉bichoo areet akeenke kule 'kēēchōō. Kunyi keeyey nee? ");
INSERT INTO spyNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kiito nyēē miitē, ku iyey kuu wōlēē +mākēēmwooytoowuung' ꞉acheek. Kēēboontē biiko alak ang'wan chēē kiikōōtāboonchi keey Yēyiin āmārwoochē buutēēk. ");
INSERT INTO spyNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Iwēētē keey bichu ānkiitiliil keey ꞉nkinyiing' nto iwutē *Kōōtaab Yēyiin. Nto yityo, ikweyte kiy ake tukul nyēē rubtooy keey āk ntasimnyaanaa sukung'eet /kiirēr mētēwookaab bichooto. Mākōōnkētēē ꞉chii ake tukul yooto kule māmii ꞉manta ām tukuuk chēē /kōōkēēmwoochi kurubta keey āk kiyēē iyēyē, nteenee kule imiitē irubē ātēbuutēkyoo. ");
INSERT INTO spyNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nto kurubta keey āk choo mā Yuutayeek choo kiikuchamta Yēēsu, kōōkēēsirchi choo barweet kurubta keey āk kiyēē /kookiitiil kule kutayee keey ꞉icheek kwoomē āmit choo /kākēēsooytoochi āynātōōs. Kutayee keey martaayeet, bany chēbo tyoong'in chēē /kakeekul āk kiisēēn.” ");
INSERT INTO spyNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yu kāyyēēkunēē, kuwēēto keey ꞉Bāwulō bichoo, nto yu kābokōōtiliil keey, kuba *Kōōtaab Yēyiin. Kiiboor bēsyēēt nyēē bēkunēē ꞉bēsyōōsyēk tisabu choo /kiitiliilēē keey āk yēē /kēēbēēlchinēē chii ake tukul kōrōsēēk. ");
INSERT INTO spyNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Yu kikiikuriik kubēk ꞉bēsyōōsyēchoo tisabu, kukas ꞉Yuutayeek alake chēē kibo yēēmēētaab Eesya kumii ꞉Bāwulō Kōōtaab Yēyiin. Kiiwuruur ꞉Yuutayeechaa biiko kunam Bāwulō ");
INSERT INTO spyNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ānkubōloobōl kule, “Biikyoo bo Isrāyēēl, ānkōōyēētyēēchēēch! Inēētootē ꞉chiichiitēnyi biiko tukul ām wōlto ake tukul kung'āloolootēē biikyoo nyēē miyaat, ātēbuutēkyoo āk mbo Kōyiitēnyi. Mā chooto baateey, kāākukwēr mbo subak Kirikiik kukwa biiwuutaab Kōōtaab Yēyiin, kōōntosuur mbo yuutēyu churtaat.” ");
INSERT INTO spyNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Kikisimkukas ꞉icheek chiichoo kibo kōōrēētaab Ēfēēsō nyoo /kikēēkuurēē Turōfiimō kuboontootē keey Bāwulō ām kiriing'. Kibērē ꞉icheek tōōs kikiikukwēryoot ꞉Bāwulō chiichoo kuwo Kōōtaab Yēyiin.) ");
INSERT INTO spyNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kuchēyē ꞉taariiryeet ām *kiriinkēēt kumukuul, kulābātunēē ꞉biiko komoswookik tukul chēbo kiriinkoonoo /ānkēēnāmē Bāwulō /ānkiichuutootē kung'eetee Kōyooto bo Yēyiin /ānkēēkērē ōrootunwēkaab biiwuut areet akeenke. ");
INSERT INTO spyNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kumii ꞉bichoo kusyēēmē kule kubakach Bāwulō, kuyityinē ꞉ng'aleechaa nyēē wōō nyēbo lukēētaab Rooma kule kimā mining' ꞉wōōrōōryēēt *kiriinkēētaab Yēērusālēēm tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Yooto kuwēētooy ꞉kāāntōōyiintoonoo bo lukēēt areet akeenke biiko alak chēbo lukēēt chēē wōōyēch āk chēē minkēēch ākoy wōlooto kimii ꞉wōōrōōryēēt. Nto kukāsē ꞉bichoo kiyēyē wōōrōōryēēt chiichoo bo lukēēt āk biikyii, mānāātākubirsēēt Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kinam ꞉kāāntōōyiintoonoo kibo lukēēt Bāwulō ankumwaayta /keeratee nyōrōōrōōnik āyēēng'. Nto mii yoo, kuteebee biiko kule, “Ng'oo ꞉chiichi nto subak kayey nee?” ");
INSERT INTO spyNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kiwiirunaat ꞉bichoo ng'al. Kimwooyē ꞉chuut chu, kumwooyē ꞉alake alak. Kunyi, maneemuuch ꞉kāāyyoong'iintoonoo kunyōōr ng'ālyoontēētaab manta. Kuuyu kibōltōōs ꞉bichoo miisin, kumwooy ꞉chiichoo bo lukēēt kule /kēēkwēryoot Bāwulō kuwo kiyēnkuutaab lukēētaab booryēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Yu makuyit ꞉Bāwulō yēē /kikēēloong'tēē, kukōrōmiit ꞉wōōrōōryēēt miisin kut kukalabaat ꞉biikaab lukēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kibōlootē ꞉biiko choo kirubootē Bāwulō kumwooyootē kule, “Owaang'te chiichi!” ");
INSERT INTO spyNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Yu kikiikuriik kooyiitita ꞉bichoo kibo lukēēt Bāwulō kiyēnkuung'waa, kumwoochi ꞉Bāwulō kāāntōōyiintoonoo bo lukēēt kule, “Ara imuuchāktōōs āmwoowuung' ng'ālyoo?” Kuteebee ꞉chiichooto kule, “Ing'āloolē kuutiitaab Kirikiik? ");
INSERT INTO spyNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ibooyē ꞉inyiing' oob Miisir ānku inyiing' ꞉nyoo kiwēēkyēēch keey intōōchi kāwōōtik kisyēērōōk ang'wan kuba suurkwēēn ām bēsyōōsyēk chēē ng'ēri choo kookukeeyta?” ");
INSERT INTO spyNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Kukētyi ꞉Bāwulō kule, “Āyēku anii Yuutāyiin nyēbo Taarso ām Kiliikya, chiitaab ꞉kōōrēēt nyēē mābo kiriing' nyēē mātookunoot. Lēyyē, kany baa, āng'āloolchi biiko.” ");
INSERT INTO spyNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yu /kākēēchāmchi, kōōyyoonyēē barak yēē /kikēēloong'tēē ankumwechee biiko āwunnyēk kusiisyo. Yu kāākusiisyo ꞉bichoo, kumwoochi ꞉Bāwulō Yuutayeek ām kuutiing'waa kule, ");
INSERT INTO spyNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mbo ng'eetaabiya, okas kiyēē āmwooyē nyēē āyēētē keey.” ");
INSERT INTO spyNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Yu kakas ꞉bichoo kung'āloolchinē icheek ꞉Bāwulō ām kuutiitaab Iburaneek, kusiisyo. Yooto kumwooy ꞉Bāwulō kule, ");
INSERT INTO spyNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Anii Yuutāyiin. /Kikēēsikyoo Taarso ām Kiliikya, nteenee kyāānērēē kiriinkooni bo Yēērusālēēm. Kiineetaa ꞉Kāmālyēēl ātēbuutēkaab mbo kuuko, ānkyāākiilchi ng'ālyoontēētaab Yēyiin kuu wōloo ōwuuyē ꞉akweek bēsyōōsyēchu. ");
INSERT INTO spyNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kyāāwusē biiko chēē kirubē kēēltaab Yēēsu kut āmāchē ābākāchē. Kyāānāmootē murēnik āk kooruuk ānkāārātē ākērtooy kō. ");
INSERT INTO spyNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Imuuchē mbo kōōboorwook *꞉kibkōrōs nyēē wōō āk booyikaab kōōk tukul kule man ꞉ng'aleechu āmwoowook. Kikōōno mbo ꞉kāāntōōyichoo bārōōnōōk āyibchi mbo ng'eetaabkaamet ām Tamaasko. Kunyoo, kyāāwē wōlooto āmāchē anam biiko sāākwēryoonu kukwa Yēērusālēēm /bokiing'woonchi. ");
INSERT INTO spyNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Yu kikiikuriik kuyit ꞉asiista lo nyēbo bēēt, kukariik ayit Tamaasko, kuchō ꞉lēbkēēyyēētaab Yēyiin ām barak ankoolaambuuchaa. ");
INSERT INTO spyNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Āryookyi keey ng'wēny. Nto mii yoo, akas kuutiit nyēē kikuurwoo kule, ‘Sāwulō, wē, Sāwulō, 'kēē-āmchoo nee?’ ");
INSERT INTO spyNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ākētyi kule, ‘Inyiing' ng'oo ōō, mokoryoontēēt?’ Kukētwoo kule, ‘Anii Yēēsu nyēbo Nāāsārēēt, nyooto imiitē ibārē.’ ");
INSERT INTO spyNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Kikas ꞉chōōrōōnuutēkyuu chēē kikēēboontootē keey lēbkēēyyēēt, āmēēbērē kiinkētē kiyēē /kikēēmii /kēēmwoowoo. ");
INSERT INTO spyNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Yooto, ateeb kule, ‘Ara ayey nee ōō, mokoryoontēēt?’ Kuwālwoo kule, ‘Ng'eet ānkiiwē ākoy Tamaasko. +/Mākiibooruung' ām wōlooto kiyēē +meeyey.’ ");
INSERT INTO spyNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kinama ꞉chōōrōōnuutēchooto āwut ānkōōrēētootoo ākoy Tamaasko, kuuyu kikiikutoora ꞉lēbkēēyyoonoo koonyek akor. ");
INSERT INTO spyNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Yooto, kuchō ꞉chiito ake ām wōlooto nyēē /kēēkuurēē Anannyaa chokukasa. Kirubē ꞉chiichooto mākuutēkaab Yēyiin miisin ānkikoonyitē inee ꞉Yuutayeek tukul chēē kimiitē wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kuchō ꞉chiichoo ānkuchokōōyyoonyēēnoo komos ānkumwoowoo kule, ‘Ng'eetaabiya Sāwulō, ikaste!’ Akaste yooto bakeenke ankaakas inee. ");
INSERT INTO spyNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nto mii yoo, kumwoowoo ꞉chiichooto kule, ‘Kookukweying' ꞉Yēyiintēētaab mbo kuuko kule 'inkēt kiyēē māchē ꞉Yēyiin kuyey 'ankiikas Nyoo Karaam Kuchurta 'ankiikas mbo ng'aleek chēē kwoonēē kuutiinyii. ");
INSERT INTO spyNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Inyiing' ꞉nyēē +māwēēmwoochi biiko tukul kiyēē !keekasee koonyekuuk āk yiitiikuuk. ");
INSERT INTO spyNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kunyoo ii, tēēkānyē nee? Ng'eet /keebatisaniing' ibuuktē ng'ōōkiswookikuuk ām kaayneenyii.’ ");
INSERT INTO spyNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Yu kawaayeey Yēērusālēēm, nto āmiitē āsooyē ām *Kōōtaab Yēyiin, kuchō ꞉ng'oong'uutyēēt mētinyuu. ");
INSERT INTO spyNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Kyaakas Mokoryoontēēt kung'āloolwoo. Kimwoowoo kule, ‘Ng'eetee Yēērusālēēm areet akeenke, kuuyu mēēbērē makucham ꞉bichu kiyēē imwooyē kurubta keey āk anii.’ ");
INSERT INTO spyNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Yooto, ākētyi kule, ‘Mokoryoontēēt, ntēē inkētē ꞉bichuutēchu kule kyāāwēētootē ꞉anii kung'eetee *kōōtaab saayeet ake ākoy ake ābirootē biiko choo kiiyēnuung' ānkāārātē alak ākērtooy kō. ");
INSERT INTO spyNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nto mbo bēsyoonoo /kikēēbākāchē Steefaan sāāyyoonyēē ꞉anii yooto āriibē sirookaab biiko choo kimii kurumiisyē ārōōbē icheek kule kikaraam ꞉kiyēē kimii kuyēyē.’ ");
INSERT INTO spyNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Yooto, kumwoowoo ꞉Mokoryoontēēt kule, ‘+Māāyooktiing' lōōyin wōlēē mii ꞉biiko choo mā Yuutayeek.’ ” ");
INSERT INTO spyNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Kiyēbchi yiit ꞉biiko Bāwulō, nto yu kāmwooy ng'aleechu, kubōloobōl ꞉biikēy kumwooyē kule, “Obakach chiichi, māyēmāktōōs /tākēēkāsē.” ");
INSERT INTO spyNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kumiitē ꞉bichoo tākubōltōōs ānkumētooy sirookwaa chēē kiiliiktēē keey ānkuwurē tēērtit, ");
INSERT INTO spyNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","kumwooy ꞉kāāntōōyiintoonoo kibo lukēēt /kēēkwēryoot Bāwulō kuwo kiyēnkuutaab bichoo bo lukēēt. Kimwooy mbo subak kule /bokeebas /ānkiikuum sukung'eet /kiinkēt kule kiy nee nyēē kibōlchinē ꞉biiko kurubta keey āk inee. ");
INSERT INTO spyNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Yu kimiitē kiimukuunkēnē kule /sikeebas, kumwoochi ꞉Bāwulō kāāyyoong'iintēēt ake nyēbo lukēēt nyēē kimii kēēyyo yooto kule, “So, bo man ām wōlēē ōmiitē ꞉akweek /keebas chii nyēbo kōōrēētaab Rooma ānku nyēē /mānāākiinkēt mbo kule boonto lēēlis nto buryo?” ");
INSERT INTO spyNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kukāsē ꞉chiichoo kibo lukēēt kuu nyooto, wokumwoochinē nyēē wōō nyēbo lukēēt kule, “Imiitē wēēyēyē nee? Nto yu ākoo bo ꞉chiichi kōōrēētaab Rooma!” ");
INSERT INTO spyNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Yooto, kuwo ꞉kāāntōōyiintoonoo bo lukēēt wōloo kimii ꞉Bāwulō. Nto yitē, kuteebee kule, “Mwoowu, baa, kālē ibooyē kōōrēētaab Rooma?” Kulē ꞉Bāwulō, “Ēē, ābooyē wōlooto.” ");
INSERT INTO spyNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kumwooy ꞉kāāntōōyiintoonoo kibo lukēēt kule, “Ntēē kyaakweyte ꞉anii beesaan chēē chaang' sāāyēku chiitaab Rooma.” Kumwooy ꞉Bāwulō kule, “/Kikēēsichoo āyēku chiitaab Rooma.” ");
INSERT INTO spyNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kiichuchuuy keey areet akeenke ꞉chēē kimāchē kule kōōkuum Bāwulō. Yooto, kunam kuut kāāntōōyiintoonoo, yu kēēnkēt kule ākoo kikiikuratee chii nyēbo kōōrēētaab Rooma nyōrōōrōōnik. ");
INSERT INTO spyNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nto yu kāyyēēkunēē, kimāchē ꞉kāāntōōyiintoonoo bo lukēēt kōōnkēt kiyēē kiitēēchinē ꞉Yuutayeek kurubta keey āk Bāwulō. Yooto, kootyaakta Bāwulō ānkumwoochi kōōkwēētaab Yuutayeek kōōruruuch keey kumiitē ꞉mbo kibkōrōs chēē wōōyēch. Nto tēē yoo, /kēēkwēryoon Bāwulō kuchō taayeetaab kōōkwoonoo. ");
INSERT INTO spyNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Yooto, kōōrōōtoot ꞉Bāwulō booyichooto ānkumwoochi kule, “Mbo ng'eetaabiya, ānkētē kule kyaayey ꞉anii ākoy kura yiisyēēnyuu kuyitita kuu wōlēē māktooy ꞉Yēyiin.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Yu kāmwooy ꞉Bāwulō kuu nyooto, kumwoochi ꞉Anannyaa nyoo *kibkōrōs nyēē wōō, biiko chēē kilēēkitēē Bāwulō kule, “Orabaach kuutiit.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Yooto, kumwoochi ꞉nkinee Bāwulō kule, “Makoorabaachiing' ꞉Yēyiin inyiing' nyoo iyibē keey kule itiliil ām wōlēēb saang'. Itiilchoo ng'al kurubta keey āk wōlēē wuu ꞉kiruutēkaab Yēyiin ānkiimiitē i-iryēē kiruutēchoo yoo imwooyē kule /kiirabaachaa.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Kumwoochi ꞉biiko chēē kimii yooto Bāwulō kule, “‑Mēētinyē koonyit? Kaaming' ꞉nee yu kēēntosuur kibkōrōs nyēē wōō bo Yēyiin?” ");
INSERT INTO spyNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Kukētyi ꞉Bāwulō kule, “Mbo ng'eetaabiya, ‑māānkētē mbo kule ākoo kā kibkōrōs nyēē wōō kuu yoo mwooyē ꞉siruutēkaab Yēyiin kule, ‘‑Meeng'alaal ng'ālyoo nyēē miyaat ām wōlēē mii ꞉bāytooyikaab biikwook.’” ");
INSERT INTO spyNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kiinkētē ꞉Bāwulō kule kiiliinyootiin ꞉bichoo. Ki *Satukaayeek ꞉alake, nto alak ku *Farisaayeek. Yooto, kukuur ām kōōk kule, “Mbo ng'eetaabiya, anii Fārisooyiin ānkāāsālu Farisaayeek. Āmiitē raat yu /kiikuumwoo, kuuyu ātinyē mooyēēt kule ng'ēētyēē ꞉biiko meet choo kiikubēk.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Yu kāmwooy ꞉Bāwulō kuu nyooto, kuchuunchuun ꞉Farisaayeechaa āk *Satukaayeek. Yooto mbo subak kubuntēē keey ꞉kōōkwēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mwooyē *꞉Satukaayeek kule māng'ēētēē ꞉chii meet, māmii ꞉malayikaan āk tāmirmiroy. Nteenee iyēnchinē ꞉Farisaayeek ng'aleechaa tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kichēy ꞉taariiryeet nyēē wōō kut kung'ēētyo ꞉kāānēētikaab kiruutēk alake chēē ki Farisaayeek ānkumwooy kule, “Nto yu ākoo māboonto ꞉chiichi lēēlis. Inkētē ꞉ng'oo, nto nyuun kāng'āloolchi inee ꞉tāmirmiryēēt nto ku *malayikeet.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kikōrōmiit ꞉wōōrōōryēēt kut koosoot ꞉nyēē wōō nyēbo lukēēt kule imuuchē ꞉bichoo kusankatan Bāwulō kule tōng'! Yooto kōōyookto biikyii alak chēbo lukēēt kurēkto bokōōsōrunēē Bāwulō kwēēnuutaab bichoo ānkukwēryoot kuwo kiyēnkuung'waa. ");
INSERT INTO spyNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nto mii kwēēmooy, kōōnookyi ꞉Mokoryoontēēt Bāwulō ānkulēēnchi, “Bāwulō, ‑mēēmuy, ikiil. Kuu yoo 'kwēē-āmchi biiko ām Yēērusālēēm kurubta keey āk anii, +maweeyey kuu nyooto ām Rooma.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nto mii bēsyēēt nyēē kiikēērē, kōōruruuch keey ꞉Yuutayeek ankuyey ruurumuut. Kyaam muumeek kule mākoy kwaam nto kuyye kiy kut kukas kurook kule kaakume ꞉Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kikēēytēē ꞉bichoo kiyēyē ruurumuunoo artam. ");
INSERT INTO spyNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kiba ākoy wōlēē kimii ꞉mbo kibkōrōs chēē wōōyēch āk booyikaab kōōk ānkubokumwooy kule, “Kaakyaam ꞉acheek muumeek nyēē ‑mākiiyēēyē lēt kule ‑mākyoomē āmnyoo ake tukul nto keeyyee kiy ake tukul ākoy kut keekas kule kaakeebakach Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Koong'eet ꞉akweek āk booyikaab kōōk ōyookyi nyēē wōō nyēbo lukēēt kuutiit kule /kēēkwēryoon chiichi kuchō taayeeng'woong' ōmāchē kule tōōnyōōru ng'aleek chēē yēmootiin kurubta keey āk chiichi. Kēēchōbootiin ꞉acheek keebakach chiichi kumanaayit yuutēyu!” ");
INSERT INTO spyNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nteenee yu kawokukas ꞉wēritaab chēēbto nyēbo Bāwulō ruurumuunoo, kuwo ākoy kiyēnkuutaab lukēētaab booryēēt ānkuwokuchiilchi Bāwulō ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kukuur ꞉Bāwulō kāāyyoong'iintēēt ake nyēbo lukēēt ānkumwoochi kule, “Kwēryootē, baa, wēēri kuwo wōlēē mii ꞉nyēē wōō nyēbo lukēēt. Ākāsē kule boonto ng'ālyoo nyēē māchē kumwoochi.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yooto, /kēēkwēryoot wēritkēy ākoy wōlēē mii ꞉nyēē wōō nyēbo lukēēt. Yu kayit, kumwoochi ꞉chiichoo kibo lukēēt nyiin ki wōō kule, “Kēēyookwoo ꞉kibratyaantaanaa /kēēbērē Bāwulō kuut. Nto āyitē yēē kāmii, kusoomo kule amutu wēēri kuchō wōlēē imiitē, kuuyu boonto ng'ālyoo nyēē māchē kumwoowuung'.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kunam ꞉nyēē wōō nyēbo lukēēt wēēroo āwut ānkuwēēto komos sukwaamee lōkōōy. Kiteebee kule, “'Kēēbērē nee?” ");
INSERT INTO spyNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kumwoochi ꞉wēritkēy kule, “Kāākuchāmchiin ꞉Yuutayeek kule ikwēryootē Bāwulō tuun /bokiiyyoong'tēē taayeetaab kōōkwēēt /sitākēēbēēr ng'aleek chēē yēmootiin kurubta keey āk inee. ");
INSERT INTO spyNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kunyi ii, boontēēt, ‑mēē-āsyi keey bichoo, kuuyu mii ꞉alake chēē kēēytēē artam chēē māchē kule kuriibchi Bāwulō kēēlto sukubakach. Kaakwaam ꞉bichoo muumeek kule mākoy kwaam āmnyoo nto kuyye kiy mbo kisich, nteenee ākoy kukas kurook kule kaakubakach Bāwulō. Chōbootiin mbo kuu nyiitēnyi kumāchē kukas kuutiing'uung' ām ng'ālyoontoonoo māchē kusoomiing'.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Yu keewaany ꞉wēēroo ng'aleechaa, kumwoochi ꞉nyēē wōō nyēbo lukēēt kule kuwēēchi keey, nteenee kiikāloonchi kule ‑māwokumwoochi chii ake tukul kule kāākumwoochi inee ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nto mii yoo, kukuur ꞉nyēē wōō nyēbo lukēēt kāāyyoong'ikyii āyēēng' chēbo lukēēt ānkumwoochi kule, “Obchey lukēēt nyēbo biiko chēē yitē bokolwookik āyēēng' kuyeyta keey kuba Kayisareeya. Nto yityo, oyeyte lukēēt nyēē bēētēē faraasiinek nyēbo biiko chēē yitē tāmānwookik tisab āk lukēēt nyēbo ng'otwēēk nyēbo biiko chēē yitē bokolwookik āyēēng' kuba ꞉tukul Kayisareeya kwēēmowuuni ku asiistaab sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ōyēytoochi nkinee Bāwulō faraasiinek cheechii sukuyitita nyēē karaam wōlēē mii ꞉kāāntōōyiintēēt Fēēliikis nyoo iyyoonkyinē yēēmoonooto.” ");
INSERT INTO spyNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kisirta ꞉nyēē wōō nyēbo lukēēt barweet kubeeta ꞉bichooto nyēē kimwooyē kule: ");
INSERT INTO spyNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Kuyityiing' ꞉barwaani inyiing' boontēēt nyēē koonyitoot, Fēēliikis. Āsubooyiing'. ");
INSERT INTO spyNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Āmāchē ābooruung' kule kinam ꞉Yuutayeek chiichoo, nto yu kikiikuriik kubakach, waararaach ꞉anii āk biikyuu kuuyu kyaakas kule ki chii nyēbo kōōrēētaab Rooma. ");
INSERT INTO spyNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nto kuuyu kyāāmāchē ānkēt kule ām nee sukōōtēēyiis ꞉bichoo miisin kurubta keey āk chiichoo, ākwēryootē ākoy kōōkwēētaab booyikwaa. ");
INSERT INTO spyNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Yooto ānkēt kule ākoo kirubtooy keey ꞉riirikwaa āk ng'ālyoo nyēē nāmē keey āk kiruutēkwaa, nteenee kimāmii mbo ꞉lēēlis nyēē kiyemaat /kiitiilchi kume nto mbo /keerat. ");
INSERT INTO spyNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Yu /kābokēēmwoowoo kule /kēēmiitē /kēēyēchinē ruurumuut kule /keebakach, atiil kule āyokoowu kuchō wōlooto imiitē. +Māāmwoochi biiko choo ing'unyng'uung'tōōs kubo inee kule kuyibuung' riirikwaa. Anii nyoo Kilaawutiyo Lusiiya. ");
INSERT INTO spyNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Kikoonyit ꞉lukoonoo bo booryēēt ng'aleekaab nyēē wōō. Kibeeta Bāwulō kwēēmowuunooto ākoy wōlēē /kikēēkuurēē Antibaatri. ");
INSERT INTO spyNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Yu kāyyēēkunēē, /kēēmwoochi lukēēt nyoo kibo faraasiinek kule kutas taay āk Bāwulō ankooyeey ꞉chuut kiyēnkuung'waa. ");
INSERT INTO spyNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nto yu kabokuyit ꞉choo Kayisareeya, kōōkoochi kāāntōōyiintoonoo kibo wōlooto barwaanaa ānkōōyokoochi nkinee Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kisuman ꞉bāytooyiintoonoo barwaanaa ankuteeb kule, “Bo ꞉Bāwulō yēēmēēt nkōnō?” Yu kakas kule ākoo kibo Kiliikya, ");
INSERT INTO spyNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kumwoochi kule, “+Maakas ng'aleekuuk, yoo kaakuyit ꞉biiko choo ing'unyng'uung'tōōs kubo inyiing'.” Nto mii yoo, kumwaayta ꞉bāytooyiintoonoo /kēēkwēryoot Bāwulō /bokiimiiny kaab *Ērōōtē /ānkēēriib. ");
INSERT INTO spyNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nto mii yoo, yu kaakukeeyta ꞉bēsyōōsyēk muutu kuchakee /kākēēkwēryoot Bāwulō, kuwo ꞉kibkōrōs nyoo wōō ākoy Kayisareeya. Kiwēēto keey booyik alak āk chiito ake nyēē /kikēēkuurēē Tērtuulō nyēē kikōrōōm ng'alaaleet. Kiyib riirikwaa kuba wōlēē mii ꞉bāytooyiintēētaab yēēmoonooto. ");
INSERT INTO spyNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Yu /kābokēēkuur Bāwulō kuwo kō, kōōyyo ꞉Tērtuulō ānkumwoochi Fēēliikis kule, “Boontēēt nyēbo koonyit, kōōkēēng'ērēkyi ꞉acheek bāytooyiisyēēng'uung' nyēbo tāloosyēēt ām bēsyōōsyēk chēē chaang'. !Kweeyey nyēē karaam simikas taay ankiiweechweech ng'aleek alak sukung'eet kutas taay ꞉kōōrēēnyoo. ");
INSERT INTO spyNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Boontēēt nyēē koonyitoot, Fēēliikis, karaam ꞉bāytooyiisyēēng'uung' ām wōlto ake tukul ānkēēng'ērēkyinē ām kēēlto ake tukul kuyitita. ");
INSERT INTO spyNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nteenee ii, nyēē wōō, āsoomiing' kule ‑meechaas iyēbchi yiit kiyēē kēēmāchē kēēmwoowuung' ām nwookinto. ");
INSERT INTO spyNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Boontēēt, mii ꞉chiichi kuyibu nyalilta kōōrooni. Iwuruurootē Yuutayeek ām kōōrēēt kumukuul kuyey wōōrōōryēēt. Inee mbo ꞉nyēē intōōchinē biiko choo kiikoobetyeeny keey ankurub nyoo bo Nāāsārēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kookusyeem mbo subak kunyeeree *Kōōtaab Yēyiin. Kiyeyeech ꞉ng'ālyoontoonooto keenam. ");
INSERT INTO spyNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kunyi, yoo 'kēēkuumu nkit, +meekas kule ākoo man ꞉kiyēē kēēmwooyē ꞉acheek kurubta keey ākoo chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Kiirōōbēr ꞉nkicheek Yuutayeek kule ki man ꞉ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Yu kānyōōr ꞉Bāwulō bārooyinto kung'alaal, kulē, “Ānkētē kule ām kēnyiisyēk chēē chaang' choo kookukeeyta, inyiing' ꞉nyēē kwēētiilchinē biiko ng'aleek ām yēēmooniitēnyi. Kunyoo, ang'erechaat ayeet keey ām taayeeng'uung'. ");
INSERT INTO spyNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Imuuchē chēēbēēru kule manaakeeyta ꞉bēsyōōsyēk tamanu āk āyēēng' kuchakee kyāāwē ꞉anii Yēērusālēēm wāākutunkyi Yēyiin. ");
INSERT INTO spyNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mānāānyōōrwoo mbo ꞉murēchu iyyoong'tēēnoo kōōk ākwiilē keey āk chii ake tukul ām *Kōōtaab Yēyiin nto, mbo āwuruurootē biiko ām kooriikaab saayeet nto, mbo ām wōlto ake tukul ām Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Māmii mbo ꞉kiyēē iboorunēē ꞉murēchu kule man ꞉ng'aleechu mwooyē ꞉icheek kurubta keey āk anii. ");
INSERT INTO spyNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ānkoo kuwuu nyooto, āchāmchiintōōsii kule ākutunkyinē Yēyiintēētaab mbo kuuko kuu chii nyēē rubē kēēlooto /kēēmwooyē kule machurtaat. Āyēnchinē kiy ake tukul nyoo chāmchiintōōs āk wōlēē wuu ꞉kitaabuutaab kiruutēk ānku nyoo /kikeesir ām kitaabuutaab *wōōrkooyik. ");
INSERT INTO spyNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Āboontēē Yēyiin mooyēēt kuu wōloo wuu ꞉murēchuutēchu kule mākung'ēētyēē meet ꞉biiko choo churtootiin ākoo choo bo ng'ōōki. ");
INSERT INTO spyNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kunyi, ātitirē kwaak āriibē keey ku ‑maayey ng'ālyoo nyēē ‑mēēng'ērēēchē Yēyiin āk biiko. ");
INSERT INTO spyNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Kikyaang'eetee Yēērusālēēm ānkāāminy saang' ām kēnyiisyēk chēē chaang'. Nto yityo, āchōō Yēērusālēēm āyibchi biikyuu chēē bānoon tukuuk chēē kāchāāyēētyēēchinēē ankuchaabeel kōrōsēēk. ");
INSERT INTO spyNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kyāātiliil yu kinyōōrwoo ꞉murēchooto ām biiwuutaab *Kōōtaab Yēyiin. Kimāāboontē keey biich chēē chaang' ām wōlooto, āmēēbērē mbo kyāāmiitē āyēyē wōōrōōr ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nteenee kimii ꞉Yuutayeek alake chēbo yēēmēētaab Eesya wōlooto. Yoo icheek chēē kimwooyē, kumāchāktōōs kumii taayeeng'uung' raat bokumwooy kiy nyēē boonto kurubta keey āk anii. ");
INSERT INTO spyNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nto yoo māwuu nyoo, kumwooy ꞉murēchuutēchu mii yuutēyu lēēlisto nyēē kinama, yoo kyāāmiitē taayeetaab booyikaab kōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Tōōs kiito akeenke baateey nyēē miyaat nyēē kyaayey ku yoo kyāāmwooyē kule, ‘Kōōyyoong'tēēnoo sōō, kōōk, kuuyu āboontēē mooyēēt kule ng'ēētyēē meet ꞉biiko choo kiikubēk.’ ” ");
INSERT INTO spyNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nto mii yoo, kumwooy ꞉Fēēliikis nyoo inkētē kēēliitēnyēēb Yēēsu nyēē karaam kule, “Kāāyyoong'tē ng'aleechu ākoy kut kuchō ꞉Lusiiya nyoo ꞉inee nyēē wōō nyēbo lukēētaab booryēēt.” ");
INSERT INTO spyNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Yooto, kumwoochi ꞉Fēēliikis kāāyyoong'iintēēt ake nyēbo lukēēt nyēē kimii yooto kule, “Riib Bāwulō āmēēbērē miisin. Ibākookyinē bārooyinto kisich nyēē kakasee keey āk chōōrōōnuutēkyii /sikēēyibchinē mbo kiyēē māchē.” ");
INSERT INTO spyNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Yu kakeeyta ꞉bēsyōōsyēk chēē ng'ēri, kuchōōnto keey ꞉Fēēliikis cheebyoosyeenyii Turusiila nyēē ki Cheebyuutayaa. Yooto, kōōyookto /bokēēkuurchi Bāwulō kuchō yēē kimiitē ꞉inee kumāchē kuyēbchi yiit ng'aleekyii. Nto yitu ꞉Bāwulō, kung'alaalee kule māchē kōōkoosēē keey ꞉biiko *Kāārārookiintēēt Yēēsu. ");
INSERT INTO spyNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nto yu kāwokumwooy ꞉Bāwulō kule māchāktōōs kuchurtootiin ꞉biiko, kuriibē keey, anku +/mākiitiilchi ng'al ām bēsyēēt nyēē mākuchō, kumuy ꞉Fēēliikis. Yooto, kumwoochi Bāwulō kule, “Kutēēniit chooto ra ēē, wē. Imuuchē iwēēchi keey ākoy ākuuriing' subak.” ");
INSERT INTO spyNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kiiyooktooy /kibokēēkuurchinē Bāwulō kibtaman chokwoomēē lōkōōy ānkumāchē kule kuyibchi inee ꞉Bāwulō chēēbkiisyoong'. ");
INSERT INTO spyNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Yu kakeeyta ꞉kēnyiisyēk āyēēnku, kookeer ꞉ake nyēē /kikēēkuurēē Bōrkiiyō Fēēstō bāytooyiisyēētaab yēēmoonoo. Nto kuuyu kimāchē ꞉Fēēliikis kule koong'ereech Yuutayeek kubakaakta Bāwulō kurataat. ");
INSERT INTO spyNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Yu kakeeyta ꞉bēsyōōsyēk sōmōku kuchakee /kakeetool Fēēstō kōōntōōchi yēēmoonooto bo Yuuteeya, kuwo Yēērusālēēm. ");
INSERT INTO spyNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Nto yu kayit, kukwoonchi ꞉mbo kibkōrōs chēē wōōyēch āk kāāntōōyikaab Yuutayeek ānkumwoochi riirikwaa kurubta keey āk Bāwulō. Kisoom mbo kule kōōwu Bāwulō kuwo Yēērusālēēm sukuriibchi kēēlto ankubakach. ");
INSERT INTO spyNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Yooto, kukētyi ꞉Fēēstō kule, “Rataat ꞉Bāwulō ām Kayisareeya ānkāāmiitē ꞉anii āwēētii wōlooto ām lēēkitō. ");
INSERT INTO spyNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Yoo ākoo mii ꞉ng'ālyoo nyēē miyaat nyēē kiikuyey, ōmwoochi biikwook alak kukwa wōlooto bokumwooy riirikwaa kurubta keey āk inee.” ");
INSERT INTO spyNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Yu kāākōōbuur ꞉Fēēstō Yēērusālēēm bēsyōōsyēk sisiit nto taman, kurēkto Kayisareeya. Nto yu kāyyēēkunēē, kukuur kōōkwēēt ankumwaayta /kēēkwēryoon Bāwulō kuchō kōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Yu /kakiiyiitita Bāwulō, kōōmuutmuut ꞉Yuutayeek chēē kikiikukwaanee Yēērusālēēm ānkumwooy ng'al chēē chaang' chēē kimāyēētyēēchinē kiy. ");
INSERT INTO spyNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Yooto, kutuuch keey ꞉Bāwulō kule, “Manaayey kiy ake tukul nyēē māchāmē ꞉kiruutēkaab Yuutayeek, nto anyeeree *Kōōtaab Yēyiin, nto mbo āntosuur *Kayisaar.” ");
INSERT INTO spyNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kuuyu kimāchē ꞉Fēēstō kule koong'ereech Yuutayeek, kuteebee Bāwulō kule, “Ara iyeytaat keey iwē Yēērusālēēm suwāāyyoong'tēēniing' kōōk ām wōlooto kurubta keey āk ng'aleechu?” ");
INSERT INTO spyNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Kukētyi ꞉Bāwulō kule, “Āmiitē ꞉anii raat taayeetaab kōōkwēētaab biikaab Rooma yēē yēmāktōōs kule /kiikuumunēēnoo. Mānāāyēchi Yuutayeek kiy ake tukul nyēē miyaat kuu wōloo inkētitooy ꞉nkinyiing'. ");
INSERT INTO spyNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nto yoo ākoo kāmii ꞉kiyēē miyaat nyēē kyaayey nyēē nyoolchoo /keebakachaa, ku ‑maanyokoor meet. Nto yoo ākoo mwooyē ꞉Yuutayeechu ng'aleek chēē mātinyē manta kurubta keey āk anii, kumāmii ꞉chii nyēē boonto kāāmuukēywēēk kōōyokoochoo icheek. Āmāchē /kiiyokoochoo *Kayisaar.” ");
INSERT INTO spyNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Yooto kōōrwooch ꞉Fēēstō āk kiirwookikyii, nto mii yoo, kumwoochi Bāwulō kule, “Keemwaay kule imāchē /kiiyokoochiing' Kayisaar, +mēēwē wōlooto.” ");
INSERT INTO spyNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Yu kabokukeeyta ꞉bēsyōōsyēk chēē ng'ēri, kuwo ꞉bāytooyiintēēt Akiriiba āk cheebyoosyeet ake nyēē /kikēēkuurēē Bēērnikē bokoosubaay Fēēstō. ");
INSERT INTO spyNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nto kuuyu kibēēnnyēē wōlooto bēsyōōsyēk ku chaang', kwaam ꞉Fēēstō lōkōōy āk bāytooyiintoonoo kurubta keey āk ng'aleekaab Bāwulō. Kimwoochi nyiin kule, “Miitē, naas, ꞉chiito ake nyēē kibakaakta ꞉Fēēliikis kurataat. ");
INSERT INTO spyNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Yu kāwāāwē Yēērusālēēm, kukwoonchoo ꞉mbo kibkōrōs chēē wōōyēch āk booyik chēbo Yuutayeek ānkubokumwoowoo ng'al chēē itēēyēē keey kurubta keey āk chiichi kumāchē kule /kiitiilchi ng'al. ");
INSERT INTO spyNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Yooto, āmwoochi bichoo kule mā ātēbuutēkaab biikaab Rooma /kiiruusta chii kumātuuyo āk nyoo riirēē keey kubo inee ānkunyōōr bārooyinto nyēē kayeetee keey. ");
INSERT INTO spyNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nto yu kabokeekwaante keey ākoy wōli, manaakaay keey mbo kisich, nteenee kyāākuur kōōkwēēt kutuuyo ām bēsyēēt nyēē kiikēērē ankaamwaayte /kēēkwēryoon chiichoo kuchō kōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nto yu kāwokung'alaal ꞉biiko choo kiyibu riirik, kumāmii mbo ꞉ng'ālyoo nyēē kimwooy kule kiyey ꞉chiichoo kuu wōlēē kyāāsōōtitooy. ");
INSERT INTO spyNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nteenee kimwoowoo ng'al chēē kichuunchuunootiin kurubta keey āk wōlēē kisooytooy ꞉icheek āk subak kurubta keey āk chii nyēē kiikume nyēē /kēēbērē Yēēsu nyēē kimwooy ꞉Bāwulō kule soboot. ");
INSERT INTO spyNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kimāātinyē wōlēē +maakuuyte ng'aleechaa. Kunyoo, ateebee inee yoo chāmē /kēēkwēryoot kuwo Yēērusālēēm /bokiikuumunēē wōlooto kurubta keey āk ng'aleechaa. ");
INSERT INTO spyNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Yu kāwokumwooy ꞉Bāwulō kule /takeekanyee ng'aleechaa *Kayisaar, amwaayte /tākēēriib ākoy /kēēkwēryoot kuwo wōlooto.” ");
INSERT INTO spyNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Yooto, kukētyi ꞉Akiriiba Fēēstō kule, “Āmāchē ꞉anii āyēbchi yiit chiichi.” Kumwoochi ꞉Fēēstō kule, “+Mēēyēbchi yiit tuun.” ");
INSERT INTO spyNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nto yu kāyyēēkunēē, kuwo ꞉Akiriiba āk Bēērnikē kuboonto keey biiko alak chēē ki wōōyēch āk chēē kitookunootiin ām kiriinkoonooto ankootenteen ꞉tukul ākoy kōōk. Kōōyookto ꞉Fēēstō kuut kule /kēēkwēryoon Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Yooto, kumwooy ꞉Fēēstō kule, “Bāytooyiintēēt Akiriiba āk biiko tukul choo ōboontē keey, okas chiichi. Kōōkukwoonchoo ꞉Yuutayeek kutēē yēē tēē ām Yēērusālēēm āk mbo ām wōli bo Kayisareeya kubōlē kule māyēmāktōōs /tākēēkāsē kusoboot. ");
INSERT INTO spyNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nto ābērē ārōōtootē, kumāmii ꞉kiy mbo nyēē kiikuyey ꞉chiichi nyēē misyinē /keebakach. Nteenee kuuyu kimāchē ꞉chiichi /kiiyyoong'tēē taayeetaab bāytooyiintēēt nyēē wōō, amwaayte /kēēkwēryoot kuwo Rooma. ");
INSERT INTO spyNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","27","Nto ābērē ālē, kumāmii mbo ꞉kiy nyēē āmuuchē asir kurubta keey āk chiichi nyēē +/mākēēyibchi nyēē wōō. Ākāsē kule mā karaam /kēēkwēryoot chii nyēē rataat /āmākiiboor lēēluutyēēt nyēē boonto. Kunyoo ii, boontēēt, kāākwēru kuchō taayeeng'woong' akweek tukul nto miisin kuchō taayeeng'uung' inyiing' Akiriiba, sukung'eet yoo kātook ꞉kiy ām wōlēē +/makeekuuyta, +māānyōōru kiyēē +maasir.” ");
INSERT INTO spyNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Yooto, kumwoochi ꞉Akiriiba Bāwulō kule, “/Kāākēēyootuung' iyeet keey.” Kōōtōrōōr Bāwulō āwut, ānkumwooy kule, ");
INSERT INTO spyNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Bāytooyiintēēt Akiriiba, ang'erechaat ra āyyoonyēē taayeeng'uung' āmwooyē ng'aleek chēē āyēētēē keey kurubta keey āk ng'aleek tukul choo mwooyē ꞉Yuutayeek kurubta keey āk anii. ");
INSERT INTO spyNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ang'erechaat kuuyu inkētē ꞉inyiing' nyēē karaam ātēbuutēkaab Yuutayeek āk mbo kiyēē kēēchuunchuunnyēē. Kunyoo ii, boontēēt, āsooyiing' kule imuyte ānkiiyēbchi yiit kiyēē āmiitē wāāmwooyē. ");
INSERT INTO spyNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Inkēt ꞉Yuutayeek tukul ām Yēērusālēēm wōlēē kiwuu ꞉soboonnyuu kung'eetee āmining'. ");
INSERT INTO spyNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Kiikōōnkētoo bēsyōōsyēk chēē chaang' ānkōōmuuchē mbo kōōboor, yoo chāmē, kule kyāābooyē *Farisaayeek choo kikōrōōmēch miisin ām riibsēētaab kiruutēk. ");
INSERT INTO spyNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Neennyi /kākiiyyoong'tēēnoo kōōk /kiikuumwoo, kuuyu ākēnēē keey kiyēē kikuurtoochi ꞉Yēyiin mbo kuuko. ");
INSERT INTO spyNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kumii ꞉Yuutayeek tukul kuyēyē yiisyēētaab Yēyiin bēēt āk kwēēmooy, kōōkēnēē keey kukas kule makuyeyakay kuu yoo /kikēēkuurtoochinē. Boontēēt nyēē wōō, ng'ālyoontooni /kiikēnēē keey ꞉nyēē kayey ꞉Yuutayeek kōōyyoong'tēēnoo kōōk. ");
INSERT INTO spyNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kunyoo, ātēēbē kule ām nee yu simōōyēnchinē ꞉akweek kule ing'ēētēē ꞉Yēyiin meet chii nyēē kaakume? ");
INSERT INTO spyNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Kyaachamte ꞉nkanii kule asyeem kēēlto ake tukul nyēē kiimuuchāktōōs akwiil Yēēsu nyēbo Nāāsārēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Kyaayey kuu nyooto ām Yēērusālēēm. Ām kāāmuukēywēēk chēē kikōōno ꞉mbo kibkōrōs chēē wōōyēch, kyāānāmootē biikaab Yēēsu wōlēē wōō ānkāākērtooy kō. Nto yoo /kābokiitiilchi kule /keebakach, ku anii akeenke nyēē kyāāyibē āwut barak āchāmchiintōōsii. ");
INSERT INTO spyNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kyāāwēēsyētootēē kooriikaab saayeet chēē chaang' āng'woonchinootē biiko ānkāāsyēēmē ākērchi koong' kutayee keey ng'aleekaab Yēēsu. Kyāākōrōmiitu miisin kut ā-āchinē mbo kiriinkōōsyēk chēbo saang' wāāwusē alak chēē kimii wōlooto. ");
INSERT INTO spyNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Nto mii bēsyēēt ake ām booniinēk chēē wuu chooto, kyāāmiitē āwēētii Tamaasko kukāākukōōno ꞉mbo kibkōrōs chēē wōōyēch kāāmuukēywēēk kule anam bichu. ");
INSERT INTO spyNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nto makuriik kuyit āsiiswēkaab bēēt, kutāāmiitē kēēltaab too āwēētii ii, mokoryoontēēt, kuchōōnēē ꞉lēbkēēyyēēt barak nyēē kiilēkēchēēchē kusiir asiista. Kiikweny yooto kyāāmiitē āk chōōrōōnuutēkyuu. ");
INSERT INTO spyNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kikiiryaakte keey ꞉tukul, nto mii yoo akas ꞉anii /kēēkuuru ām kuutiinyuu kule, ‘Sāwulō, wē, Sāwulō, 'kēē-āmchoo nee? Nto yu 'kēēlityi keey ng'ot, yoo imiitē iwēēkyoo keey kuu nyooto.’ ");
INSERT INTO spyNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Yooto, ateeb kule, ‘Inyiing' ng'oo ōō, mokoryoontēēt?’ /Kēēkētwoo kule, ‘Anii Yēēsu, nyooto imiitē ibārē. ");
INSERT INTO spyNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kunyi, ng'eet. Kāābooruung' keey saakweying' iyēku motwooriintēēnyuu ankiimwaaytaate kiyēē 'keekas kurubta keey āk anii āk mbo kiyēē +māābooruung'. ");
INSERT INTO spyNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","+Māāriibiing' yoo keenyaliiliing' ꞉biikuuk āk choo mā Yuutayeek. Āmiitē wāāyooktiing' ");
INSERT INTO spyNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","isōōwunootē icheek kuweeksee wōlēē mii ꞉mēēnānēēt kukwa wōlēē mii ꞉lēbkēēyyēēt ankung'eetee ꞉rātiisyēētaab Kibrōkōsyoontēēt kukwa wōlēē mii ꞉Yēyiin. Yoo keekaaseenaa keey ꞉bichoo, +māānyōōchi kaat /ānkiiyiityi wōlēē mii ꞉choo kyāātiliil.’ ");
INSERT INTO spyNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kunyoo ii, bāytooyiintēēt Akiriiba, manaatay ꞉anii āyēnchi ng'oong'uutyoonoo kichōōnēē barak. ");
INSERT INTO spyNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kyāā-āmchi kurook biiko chēē kimii Tamaasko kule kuweeksee choolwookātēēng'waa ankucham Yēyiin ānkōōboorunēē yēyuutēk kule kiikuweek. Nto yityo, chāā-āmchi nkicheek chēbo Yēērusālēēm āk chēbo Yuuteeya kumukuul āk mbo bōrōryōōsyēk tukul choo kimā Yuutayeek. ");
INSERT INTO spyNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ng'ālyoontoonooto ꞉nyēē kiyey Yuutayeechu kunama āmiitē biiwuutaab *Kōōtaab Yēyiin ankusyeem kule kubakachaa. ");
INSERT INTO spyNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nteenee kiyēētyēēchinoonwoo ꞉Yēyiin ākoy kura. Kunyoo, āmiitē ra kāāyyoony yuutēyu ā-āmchinē lōkōōywēchu biiko chēē minkēēch āk chēē wōōyēch. Mēēbērē āmiitē āmwooyē chēē kaatasee kusiir choo kimwooyē *꞉wōōrkooyikaab Yēyiin āk *Muusa kule makuyeyakay. ");
INSERT INTO spyNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kimwooy kule makunyalil *꞉Kāārārookiintēēt anku inee ꞉nyēē mākuyēk nyēbo taayta /kiing'eetee meet kwoorōōrchi Yuutayeek āk mbo choo mā Yuutayeek lēbkēēyyēēt.” ");
INSERT INTO spyNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Yu kāmwooy ꞉Bāwulō ng'aleechaa, kunam kuut ꞉Fēēstō ānkulēēnchi, “Kāākubunuung' mēt, wē, Bāwulō! Kaakuyeying' ꞉sumanaanaang'uung' kooraan ꞉mētit.” ");
INSERT INTO spyNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kukētyi ꞉Bāwulō kule, “Fēēstō, boontēēt nyēē wōō, mānāābunwoo ꞉mēt mbo kisich. Kiyēē āmiitē āmwooyē ku kiy nyēē yemaat anku bo manta. ");
INSERT INTO spyNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Inkētē mbo ꞉nkinee bāytooyiintēēt kubooyiit man ng'aleechaa kuuyu mēēbērē kiyēyāksēē wōlēē kimābo laat. Kunyoo, āmuuchē mbo āmwoochi nkinee nyēē māmii ꞉muyātēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Boontēēt, bāytooyiintēēt Akiriiba, iyēnchiintōōsii ꞉inyiing' āk ng'aleekaab *wōōrkooyik? Ābērē iyēnchiintōōsii.” ");
INSERT INTO spyNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kukētyi ꞉Akiriiba kule, “Lēēkit iweechaa āyēku chiitaab Kiriistō.” ");
INSERT INTO spyNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Kuwālchi ꞉Bāwulō kule, “Yoo kā lēēkit, nto ku lōō, āsooyē Yēyiin kule māyēk inyiing' baateey ꞉nyēē kaweek, nteenee chii ake tukul nyēē mii kuyēbchinē yiit kiyēē āmwooyē sookerkeyiitu anii, nteenee baateey kēētēērchiinē kubo nyōrōōrōōnichu.” ");
INSERT INTO spyNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kōōyyo ꞉Fēēstō, Akiriiba āk Bēērnikē ākoo mbo nkicheek choo kiboonto keey tukul ankuba saang'. ");
INSERT INTO spyNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Kibokumwoochiin kule, “Ntēē māmii ꞉chiichi kuyēyē ng'al chēē yēmāktōōs /keebakach, nto mbo kule /keekerta kō.” ");
INSERT INTO spyNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Yooto, kumwoochi ꞉Akiriiba Fēēstō kule, “Nto kāmānāāmwooy ꞉chiichi kule /bokiiyyoong'tēē taayeetaab *Kayisaar, nto /kaakiityaakta.” ");
INSERT INTO spyNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nto mii yu /kikiikiitiil kule keebe kōōrēētaab Itaalya, /kiiyokoochi Bāwulō āk kibratiisyek alak chiito ake nyēē /kikēēkuurēē Yuulyō nyēē ki nyēē wōō nyēbo lukēētaab kaab *Kayisaar. ");
INSERT INTO spyNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Yooto, keelaany mwēēnkēēt nyēē kitākyinē keey Atiramiito nyēē kimii wokumurē kiriinkōōsyēk chēē kimii sakaramteet nyēbo yēēmēētaab Eesya. Kikēēboontootē keey Aristaarko, chiitaab Maketoonnya nyēē kichōōnēē Tēēsālōōnikē. ");
INSERT INTO spyNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Yu kāyyēēkunēē, keeyit Sitōōn kosolēny. Yooto, kuyēchi ꞉Yuulyō Bāwulō nyēē karaam kuchāmchi kuwo wōlēē mii ꞉chōōrōōnuutēkyii /sikiikoochi kiy nyēē kāyēētyēēchinēē keey. ");
INSERT INTO spyNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nto mii bēsyēēt nyēē kiikēērē, kēēng'ēētyēē yooto subak ankeenam baanta ām mwēēng', nto kuuyu kitākyēēch keey ꞉wusōōnēēt nyēē nyikiis, keesyeb komosta nyēē kiiyeelaat nyēbo Kubrō ānkēētākyi keey tō. ");
INSERT INTO spyNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nto yu kikiikeebeetee mwēēnkēēt keekeeytee sakaramteetaab yēēmēētaab Kiliikya āk nyēbo Bamfulyaa, keeyit Muura, *kiriinkēēt nyēē kimii yēēmēētaab Lukiiya. ");
INSERT INTO spyNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kinyoorta yooto ꞉chiichoo ki wōō nyēbo lukēēt mwēēnkēēt ake nyēbo *kiriinkēētaab Alekisaantrya nyēē kimii kuwēētii Itaalya. Yooto, kumwoowēēch kule keelaany mwēēnkoonoo. ");
INSERT INTO spyNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kiwuuyiityēēch ꞉baanta miisin nto bokēēyitē Niitō. Nto kuuyu kiitaayeeneech ꞉wusōōnēēt keetas taay āk kēēloo, keeweech keey kēētākyi keey cheeronko ankeerub wōlēē kimāwusunēē ꞉yoomeet ām Kērēētē. Kikēēmur yēēt ake yēē /kikēēkuurēē Salmoone. ");
INSERT INTO spyNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kinyikisyēēch ꞉wusōōnēēt miisin yu kākēētākyi keey tinkeey. Kikeebe ām wuuyinto kut bokeeyit yēēt ake yēē /kikēēkuurēē ‘Sakaramteet nyēē Yimu’ nyēē kilēēkitēē *kiriinkēētaab Laseeya. ");
INSERT INTO spyNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kikiikiiboot āsiiswēk chēē chaang' kubo wusōōnoonoo ānkimii wokumiyātiitu ꞉baanta kuuyu kimii kuriiku ꞉bēsyōōsyēk chēē kōrōōm ꞉wusōōnēēt. Yooto, kumwooy ꞉Bāwulō kule, ");
INSERT INTO spyNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Murēchu, nto yu ākāsē kule mii wokumiyātiitu ꞉baani. Yoo katakeetas taay makunyeerakay ꞉mwēēnkēēt ānkubootyo ꞉tukuuchu mii mwēēng' ānkiiboot mbo soboonwēkyoo.” ");
INSERT INTO spyNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kitay ꞉Yuulyō kiyēē kimwooy ꞉Bāwulō ankucham ng'aleekaab chiitaab ꞉mwēēnkēēt āk chēbo nyēē kiiyyoonkyinē mwēēnkēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nto kuuyu kimāyēmāksē kōōbuur yooto bo sakaramtaanaa kut kukeeyta ꞉bēsyōōsyēkaab wusōōnēēt, kookaykaay ꞉biiko wōlēē wōō kule keetas taay ākoy Fōyinikē. Ki sakaramteet ꞉nyiitēnyi ām Kērēētē nyēē kikaraam bokiimuunyēē ānkiimuuchē ꞉chii kuyityi kubununēē tinkēēywōōsyēkaab cheeronko nto nyēbo tō. ");
INSERT INTO spyNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nto yu kāwus ꞉yoomeet muut nyēbo komostaab cheeronko, koosoot ꞉icheek kule kāākuyityiin ꞉kiyēē kiisōōtē. Kunyoo, kootyaach mwēēnkēēt ankutas āk baanng'waa kung'oosng'oosyootēē sakaramteetaab Kērēētē. ");
INSERT INTO spyNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nyēē mā tyaa, kuchō ꞉wusōōnēēt nyēē nyikiis nyoo /kikēēkuurēē ‘Tō-koong'asiis’ nyēē kiwusunēē Kērēētē. ");
INSERT INTO spyNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kunyoo, kikirkir mwēēnkēēt kut keechamte keey /keetwaareech. ");
INSERT INTO spyNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Yu kābokēēmur sakaramteetaab kōōr kisich nyēē kiikwēēn ꞉bēy nyēē /kikēēkuurēē Kawuuta, kyaam booryēēt kut kiichuutu mwēēnkēēt nyēē mining' nyoo kiichuutootē ꞉nyoo wōō kuchō nyiin āriit. ");
INSERT INTO spyNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Yu /kikiikiichuut kuchō āriit, /keekwiiliil mwēēnkoonoo ki wōō kuyaam kule tetete. Kuuyu kinyōkōriitu ꞉bichoo kule imuuchē koonach ꞉mwēēnkēēt ng'aayneet nyēbo sakaramteetaab Liibya, kuwiirchi araaray kiito ake nyēē kiichuchuuyē baantaab mwēēnkēēt ānkubākookyi yoomeet kōōrēētoot mwēēnkēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kitas taay ꞉wusōōnoonoo nyikiis kuwus. Nto yu kāyyēēkunēē, /kēēmēto tukuuk ām mwēēng' kule sukukuskusiit ꞉mwēēnkēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nto bēsyēēt nyēē kiikēērē, /keewiirta mbo tukuuk choo /kikēēkwoonyēē mwēēnkēēt āk tukuuk chuut alak tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kituuluunkēnoot ꞉wōliin bo barak ām bēsyōōsyēk chēē chaang' nyēē /kimākēēkāsē asiista nto mbo kookeelik. Kitas taay yooto tukul ꞉wusōōnēēt kwaawesiit, nto yityo, kubēk ꞉moonikyoo kule ākoo ‑mēētākōōmuuchāktōōs /kiiraraacheech. ");
INSERT INTO spyNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Yu kikiikumisyo ꞉moonik nyēē kimēēmāchē ꞉chii kwoomiis, kōōyyo ꞉Bāwulō ānkulē, “Murēchu, nto kōōkāswoo yoo kāāmwoowook kule ‑mōōng'ēētyēē Kērēētē, nto kāmāāmook ꞉kiy nto kāmōōbootē kiy. ");
INSERT INTO spyNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nteenee āmwoowook kule ōkich, kuuyu māmii ꞉chii nyēē makume, nteenee makuburyet ꞉mwēēnkooni. ");
INSERT INTO spyNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kōchōōnchoo *꞉malayikeetaab Yēyiintēēnyuu nyoo āyēchinē yiisyēēt kwēēmooy ānkumwoowoo kule, ");
INSERT INTO spyNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Bāwulō, ‑mēēmuy, +/mākiiyyoong'tēēniing' taayeetaab *Kayisaar ankaakuriiree ꞉Yēyiin biiko choo ōboontootē keey ām mwēēng' nyēē mākoy kubēk.’ ");
INSERT INTO spyNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kunyoo ii, murēkyoo, ōkiilyē, kuuyu ākoosēē keey Yēyiin kule makuyeyakay kuu yoo kāākumwooytoowoo. ");
INSERT INTO spyNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nteenee +/makeetwaareech ākoy kōōrēēt ake nyēē kiikwēēn ꞉bēēko.” ");
INSERT INTO spyNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kitas taay ꞉wusōōnēēt kutwaareech ām Araaraytaab Metitereennya. Nto mii yu makuriich kwēēmooy kwēēn ām kwēēmowuutaab taman āk ang'wan kukeeyiimeech ꞉wusōōnēēt, kumach kōōnkēt ꞉biiko choo kimii mwēēng' kule kikiikuriik keeyit kōōrēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Yooto, kuwiirta kiito ake nyēē nyikiis nyēē /kikiikēērātyi bōrōōwēēt sukukasee wōlēē tēē ꞉bēēko. Nto bērē kulē, kiyitē fuutiinēk bokol āk tibtēm kuwo ng'wēny. Nyēē mā tyaa /kiiyokooyto subak bōrōōwoonoo. Nto bērē /kēēlē, ku fuutiinēk sokool. ");
INSERT INTO spyNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kikēēmuuyē kule imuuchē ꞉mwēēnkēēt kuryaach rwoontōōk choo lēēkitēē sakaramteet. Yooto, kiiyokooytē karnaak ang'wan /kiiyyoong'tēē mwēēnkēēt ankeesaay kule kuyyēēkyēēch. ");
INSERT INTO spyNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kisyeem ꞉biiko choo kimii kōōrēētootē mwēēnkēēt kule kumwēy. Kinam mwēēnkoonoo ki mining' nyoo kimii nyiin āriit ankuyey keey kule kimii kōōyokooytooy karnaak alak choo /kiiyyoong'tēē mwēēnkēēt, nteenee ākoo kimāchē kule kumwēyēē kiyooto. ");
INSERT INTO spyNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nto mii yoo, kumwoochi ꞉Bāwulō Yuulyō āk biikyii bo lukēēt kule, “Yoo kāmēēbuur ꞉bichu wōlēēb mwēēnkooni, ku ‑mōōsobtōōsii.” ");
INSERT INTO spyNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yooto, kutil ꞉bichoo bo lukēēt bōrōōk chēē /kikikēērātiisyēē kōōsuuyto ꞉mwēēnkoonoo ki mining'. ");
INSERT INTO spyNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nto yu mākōōrir ꞉kōōrēēt, kumwoochi ꞉Bāwulō biiko kule, “Ām bēsyōōsyēk chēē yitē taman āk ang'wan choo kookukeeyta, kwoobeetee kuut ānkōōruuyē kuut. ");
INSERT INTO spyNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kunyi, āmwoowook kule ō-āmiisyē sōōnyōōru nkuruuk sōōsobchē kuuyu māmii ꞉chii mbo akeenke ām akweek nyēē makume.” ");
INSERT INTO spyNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Yu kēēwoong' ꞉Bāwulō ng'aleechu, kunam mukaatiit ānkubirchi Yēyiin kōōnkōy ām taayeetaab bichooto. Nto mii yoo, kubetes ānkutoow kwaam. ");
INSERT INTO spyNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kikimkimiitu ꞉bichoo ānkwoomiis ꞉nkicheek. ");
INSERT INTO spyNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kikēēyitē ꞉tukul chēē kikēēmiitē mwēēng' biiko bokolwookik āyēēng' tāmānwookik tisab āk lo. ");
INSERT INTO spyNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Yu kikiikwoomiis ꞉bichooto tukul kut kubiyoong'iis, kumētyi nkoonuuk araaray sukukuskusiit ꞉mwēēnkēēt. ");
INSERT INTO spyNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kuyyēēchē ꞉kōōrēēt, maneemuuch ꞉icheek kōōnkēt kōōrēēt nyēē kikas, nteenee kikas yēēt ake yēē kiiwulta keey ꞉bēēko yēē kitinyē ng'aayneet yēē /kikiitiil kule bokōōyyoong'tēē mwēēnkēēt yoo keemuuchakay. ");
INSERT INTO spyNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yooto, kootichtiich karnaak choo /kiiyyoong'tēē mwēēnkēēt ankootyaach tukuuk chēē /kēēwēēchwēēchēē mwēēnkēēt. Nto mii yoo, kōōtōrōōr tukuuk chēē toochē yoomeet sukung'eet kuwusto ꞉yoomeet mwēēnkēēt wokōōyyoonyēē sakaramteetaab araarayta. ");
INSERT INTO spyNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kitākyi mwēēnkēēt koonach ng'aayneet nyēē kikiituulākoy kukiilchi ꞉sēruutaab mwēēnkēēt yooto ānkutōōr ꞉wusōōnēēt bēēko kwiiri komostaab saaruuryeet. ");
INSERT INTO spyNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kichōb ꞉biiko choo kibo lukēēt kule kubakach kibratiisyek sukung'eet mābir bēēko kumwēy. ");
INSERT INTO spyNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nto kuuyu kimāchē ꞉Yuulyō kule kōōsoob Bāwulō, kuyeetee bichoo kuyey kuu wōloo kākāākuchōbto. Yooto, kumwoochi chēē kiimuuchē kubir bēēko kule koonto kubiroot bēēko ākoy taban. ");
INSERT INTO spyNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Nto choo king'ēt, kimāchāktōōs ꞉choo kubeetee keetiik choo kibētēkunēē keey mwēēnkēēt. Kiyit ꞉biiko tukul taban ām kēēlwookichooto tukwaay nyēē manaam ꞉kiy ake tukul. ");
INSERT INTO spyNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nto mii yu kabokeeyit araarayta taban, kēēbēēru kule ākoo ki Maalta ꞉kōōroonoo kikiikwēēn ꞉bēēko. ");
INSERT INTO spyNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Kitoroocheech ꞉biikaab kōōroonoo nyēē karaam. Nto kuuyu kimii ꞉roobta ānku kaytit ꞉kōōrēēt, kōōloowēēch maata. ");
INSERT INTO spyNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kiwokukweyaat ꞉Bāwulō kweenik alak, nto yu kēēkoochi ma, kusiikunee ꞉eereeneet kweenichaa yu kasyool ꞉maata ānkunooynoochi keey āwutaab Bāwulō. ");
INSERT INTO spyNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Yu kakas ꞉biikaab kōōroonoo kuu nyooto, koosoot kule, “Ākoy ku rumiin ꞉chiichi. Ānkoo kaakoomuuch kuchililee meet nyoo kātānyōōru ām araaray, tākurubē ꞉mnyaat.” ");
INSERT INTO spyNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nteenee kilelekta ꞉Bāwulō eereeneet kōōsuuchi mā nyēē manaam inee ꞉kiy. ");
INSERT INTO spyNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Kiisōōtē ꞉biiko kule makookwa ꞉āwut nto kule makooryaakta keey ankume. Kikānyiis ꞉bichooto kulōōyiit kumāchē kukas kiyēē makuyeyakay. Yu kukas kule māmii ꞉kiyēē kaam Bāwulō kulē, “Tōōs āynāt ꞉chiichi.” ");
INSERT INTO spyNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kimiitē yooto ꞉mbareetaab chiitaab kōōroonooto. Kitookunoot ꞉chiichoo /ānkikēēkuurēē Bubliiyō. Kitaacheech ꞉chiichoo ām mooyēēt nyēē lēēl kebe kanyii ānkuriibēēch nyēē karaam bēsyōōsyēk sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Kimnyoonē ꞉kwaaniitaab chiichooto ām kō ānkimii kāru kitiintiri. Kilāyēē ꞉maat ānkōōbuuntooy ꞉mooyēēt. Wokoorwaam ꞉Bāwulō ānkutiinyēē āwunnyēk ānkusoochi. Yooto, kusob ꞉boontoonoo. ");
INSERT INTO spyNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Yu kakas ꞉biikaab kōōroonoo chēē kimnyoontōōs, kukwa wōlēē mii ꞉Bāwulō ānkōōsoob. ");
INSERT INTO spyNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","/Kikēēkoonyitēēch ām kēēlwookik chēē chaang'. Nto yu kikēēmiitē kēēchōbē keey sikeebe, kukōōnootēēch ꞉bichoo tukun chēē chaang'. ");
INSERT INTO spyNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Yu kābēk ꞉ārook sōmōku, kēētoowu baanta subak. Kikeelaany mwēēnkēēt ake nyēbo *kiriinkēētaab Alekisaantrya nyēē kikiimuunyēē kōōroonooto kule kukeeyta ꞉wusōōnēēt. /Kikēēkuurēē mwēēnkoonoo “Āynātōōs saram Kastoor āk Bolukis.” ");
INSERT INTO spyNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kikeebe ākoy yēēt ake yēē /kikēēkuurēē Sirakuusa ānkēēbēēnii yooto bēsyōōsyēk sōmōk. ");
INSERT INTO spyNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nto bēsyēēt nyēē kiikēērē, keebe ākoy Rēkiyō. Nto yu kāyyēēkunēē, kuwusunēē ꞉yoomeet komostaab sōōy kuchaakteeneech ākoy *kiriinkēētaab Bōtyōōli. ");
INSERT INTO spyNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kikeenyoorte wōlooto bo kiriinkoonoo mbo ng'eetaabiya alak chēē kitaacheech kiibuurtē keey ām bēsyōōsyēk tisab. Nto mii yoo nanyuun, keebeetee kērēēnkōōk kēētākyi keey Rooma. ");
INSERT INTO spyNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Yu kāwokukas mbo ꞉n