﻿USE sofia;
DROP TABLE IF EXISTS sofia.sps_vpl;
CREATE TABLE sps_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sps_vpl WRITE;
INSERT INTO sps_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","I muan tan tatanik, tan nainy te kat faruak e Gov a gormirmir an puputaa, ");
INSERT INTO sps_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","an puputaa to aya gima faarei to te tagei fi rora ya roman. Sikia. U puputaa babainy an kat fuainy. A uurup te kookop a namaan, an Aaven ten Gov taan to patsun na namaam. ");
INSERT INTO sps_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ai Gov tsue to, “Arasan ruak,” ana arasan ruak to. ");
INSERT INTO sps_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Gov te tagei a arasan sa paparaa fiisok iny ya. Ai Gov kibei to na arasan ana uurup. ");
INSERT INTO sps_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ya koo to na arasan, “U Nainy” ya koo to na uurup, “A Voiny”. Voiny te kap na ana voinyvoiny ruak to ayein vaamuan nan nainy. ");
INSERT INTO sps_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Ai Gov tsue to, “Isen ta bei tap ma ruak a kibei to na aurom, ana aurom te takibaa tana fuan a pan.” Ana kat to ruak to kat to ai Gov kat to na bei tap sa kibei na aurom sa kat tap iny a aurom i fain ana aurom jias. ");
INSERT INTO sps_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Gov te koo na bei tap to aya na “Korosuu”. Voiny te kap na, ana voinyvoiny ruak to, ayei fafuan nan nainy. ");
INSERT INTO sps_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ai Gov tsue to, “Aurom iny fainy na korosuu ma faavot tan seiny pan, ma ruak a pan a parak,” ana pan a parak ruak to. ");
INSERT INTO sps_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ai Gov koo to na pan a parak “Puputaa”, ana fo aurom to te faavot tan seiny pan te koo ya na “Namaan”. Gov te tagei a fo mamatsiny ka te kat fakap ya, sa paparaa iny Ya. ");
INSERT INTO sps_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ai Gov tsue to, “Puputaa ma fagiainy a fo vir fareevreev, ana aufing to te natiny fuei non fua, an viirviir nau te natiny fuei non fua,” ana ri ruak to. ");
INSERT INTO sps_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","An puputaa fagiainy to na fo viir fareevreev, ai Gov tagei towa sa paparaa. ");
INSERT INTO sps_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Voiny te kap na ana voinyvoiny ruak to, ayein fafofopis nan nainy. ");
INSERT INTO sps_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ai Gov tsue pis to, “Nuaf ma ruak korosuu ma kibei yan nainy ana voiny, ai te faatok iny nainy tana fo nainy, ana fo iifaa, ana fo ingainy, an fo viirviir nainy tana ingainy. ");
INSERT INTO sps_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","A fo kurun to ari nan te ka ror i korosuu te fa'arasainy miror puputaa,” ana ri ruak to. ");
INSERT INTO sps_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Sen Gov kat fuan kurun tsian, kurun tsian a nuaf kainy faan iny a arasan tan nainy ana iifaa faan iny non a arasan tana voiny, ai Gov kat kainy to na fo kootsits. ");
INSERT INTO sps_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Gov fakei kainy to na fo kurun i korosuu ma fa'arasainy yan puputaa. ");
INSERT INTO sps_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ma tagaa ot iny ya nu nainy ana voiny, a nat iny kibei ton nainy ana voiny. Gov tagei to na fo mamatsiny ka te kat fakap ya sa paparaa fiisok tsun en nato. ");
INSERT INTO sps_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Voiny te kap naa ana voinyvoiny ruak to, ayein fafats nan nainy. ");
INSERT INTO sps_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ai Gov tsue to, “A namaan ma via men a fo mamatsiny viir jian a fasus fakinai to. Ana fo marei ma ruak, a ruaf vavis to korosuu,” ana fo mamatsiny ka ruak to. ");
INSERT INTO sps_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kat to sen Gov kat faruak a fo jian a fo tsian iny namaan, ana fo viir ka na fo kakaii iny tana aurom, ana fo viirviir marei. Gov tagei a fo mamatsiny ka te kat fakap ya, sa paparaa fiisok tsun en nato. ");
INSERT INTO sps_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ai Gov faparits ratuari, sa tsue, “Fo viirviir jian te nat iny ka ror namaan ma faagiir a piriats to na namaan. Ana fo marei roruaf kan ma faagiir fakinai a piriats to patsun puputaa.” ");
INSERT INTO sps_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Voiny te kap naa ana voinyvoiny ruak to, ayein fangim nan nainy. ");
INSERT INTO sps_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ai Gov tsue to, “Puputaa ma kamen viirviir marei sensen te kaa miror a toto, marei raif, an fo marei tsian vouts an fo marei kakaiin vouts,” ana ri ruak to. ");
INSERT INTO sps_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Te kat fakap e Gov a fo viirviir marei sensen te kaa miror a toto, ya tagei ratuarin rof fiisok ovei tsun. ");
INSERT INTO sps_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ai Gov tsue to, “Roman ra kat ror a mes a faarei ratua ra, ra ma bobot ya, ana ayei te tagaa ot ir fo jian an fo marei roruaf, an fo marei raif an fo marei sensen tsian an marei sensen kakaii iny ratsuu”. ");
INSERT INTO sps_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Sen Gov kat a mes sa mamatan faarei e Gov, a Gov kat to na tsoiny ana moun. ");
INSERT INTO sps_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Sen Gov faparits i rari, ya tsue to, “Ami na ina fuan fafaagiir rom guei kinai er piriats to na pan, ana ri te gum tana fo mamatsiny pan tan puputaa, ri te tagaa ot iny a foka te kanon tan puputaa. Nyo faan maromi na parits iny tagaa ot ir jian, an fo marei roruaf, an fo marei sensen tsian an marei sensen kakaii iny ratsuu.” ");
INSERT INTO sps_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ai Gov tsue to, “Nyo faan mami na fo viirviir fua te natiny kaa miror kainy ainy, ana fo viirviir nau te kaa miror kainy ainy natiny fua ror, a foka to aya kainy ainy tsumi. ");
INSERT INTO sps_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","San anyo te faan ir marei sensen tsian an kakaii iny ratsuu, ana fokinai marei roruaf a aufing a vuwiir, an noun nan nau fo fareevreev, faarei non a kainy ainy tsuri.” Ana foka to ruak to. ");
INSERT INTO sps_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Gov te tagei a fo mamatsiny ka te kat ya. Sa paparaa i fiisok tsun en. Voiny te kap na, ana voinyvoiny ruak to. Ayein fagonom nan nainy. ");
INSERT INTO sps_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","2","Tan nainy te kat faruak fakap e Gov a gormirmir an puputaa ana fo mamatsiny ka, Gov fakap to na fo mamatsiny binun Tsunia, an tan fafits nan nainy, Gov favusuan to tan nainy to aya nan. ");
INSERT INTO sps_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Gov faparits ton fafits nan nainy, ai Gov bobot ton nainy to aya ma agaagon ya, kainy faatouf e Gov. Tana sa Gov te kat fakap a fo mamatsiny ka, an tan nainy to aya nan Gov favusuan to. ");
INSERT INTO sps_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","Te kat e Gov a gormirmir an puputaa ana fo mamatsiny ka, Gov kat faruak to na gormirmir an puputaa, te sikia farokot ya ta fo nau ana aufing tan puputaa, tan sa, e Gov te sikia farokot ma faan iny me na ruat, ana sikia farokot ta mes iny kat tanun. ");
INSERT INTO sps_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Man pas koraa a sikia farokot ta ruat, san tan nainy to aya, a aurom te ruak me tan puputaa sa koor na tana fo mamatsiny pan sa fabub puputaa. ");
INSERT INTO sps_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Vou ai Gov nom ton puputaa ya kat towa na mes, ai Gov fuas of to na mes i uusun ya, ya kaa mito na toto. ");
INSERT INTO sps_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ai Gov kat to na isen na tanun i Iden, tana pan te ruak ising minon a nuaf, ai tana tanun to aya i Iden, a pan te fakei ya na mes te kat Ya. ");
INSERT INTO sps_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Gov kat a fo viir viir nau sa gian, fo nau a fo savits, ser fua na fo kainy ainy a fo rof, ai i fapoopoan nan na tanun pan te fakei e Gov nau, a vainy ainy ror kainy ainy nan ya ri te toto. Te kaa minon mes nau te ainy non a mes kainy ainy nan ya, ya te natiny a fo mamatsiny ka, kana rof, ana kana iring. ");
INSERT INTO sps_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A isen na aurom te poo me koman puputaa tana tanun iny Iden kainy fa aurom a tanun to aya. A aurom to aya te takibaa ya kat to na fats a naan aurom. ");
INSERT INTO sps_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Vaamuan na na aurom te koo rori na Pison, te natiny koor faafis non a gum iny fan tsian iny Havila. ");
INSERT INTO sps_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","A fan to aya te kaa minon gol rof te sab ari na aya, kaa kan minon sen nau, potsing nan yan tauf tsuraf te natiny koo rori Deliam. An te kaa kan minon na isen na viir fats a gautsiroun te natiny koo rori Oniks. Fuan na ka to aya, foiny nan ya nai jias fiisok. ");
INSERT INTO sps_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Fafuan nana aurom te koo rori Gihon, te natiny afis non a gum iny fan tsian iny Kus. ");
INSERT INTO sps_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Fafofopis nana aurom te koo rori Taigris, te koor fina non tana pan te ruak minon na nuaf i Asiria. Ana fafats nana aurom te koo rori na Yufreitis. ");
INSERT INTO sps_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Sen Gov nom a mes sa fakei ya tana tanun to aya i Iden ma binun ya, ana ayei te tagaa ot iny a tanun ana fo mamatsiny ka koman ya. ");
INSERT INTO sps_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Sen Gov tsue of fi na mes nei, “Nyi onot iny ainy fua nan fo mamatsiny nau iny tana tanun to aya. ");
INSERT INTO sps_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","San anyi gim on rom ma ainy fua nan nau te kat non na mes ya te nat iny a saf a ka na rof, ana saf a ka na iring, agaagon non tsumanyi tan ainy fua nan nau to aya, te ainy romanyi ya, nyi mat rom.” ");
INSERT INTO sps_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ai Gov fakats to sa tsue, “Te gim non ma rof te kaa tsivon non na mes, Nyo ma kat ta isen ta vaatau kainy faakouts ya.” ");
INSERT INTO sps_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kat to sen Gov nom puputaa sa kat yan marei sensen an marei roruaf. Sen Gov a ton ir a fokinai marei sensen an marei roruaf tana mes ma fakei ya na asanga rari. Kat to ana mes faan isiseiny raton a fokinai marei sensen an marei roruaf asangan ri na fokinai kaa miton asangan te faan rari na mes. ");
INSERT INTO sps_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kat to ana mes faan iny ton asangar fokinai marei sensen iny fan an fokinai marei sensen iny ratsuu, an fokinai marei roruaf. San a mes a sikia farokot ta vaatau kainy faakouts ya. ");
INSERT INTO sps_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Gov kat to na mes ana mes goros ya maguu enato, ai to te goros farokot a mes. Gov nom ton sen tsuan ririkin na mes ya faa'ngamuts fatabiny ton venoo tana pan te nom ya tsuan i ririkin na mes. ");
INSERT INTO sps_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Gov te kat a isen a moun tan as te nom ya ririkin na mes sen Gov mei naa na moun tana mes. ");
INSERT INTO sps_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ana mes tsue to, “Ai bus nan na vaatau faman tsonyo, ton tsuan nan ya te kat ari tan tsuan navanyo, an venoo nan ya te kat ari tan venoo navanyo. Gov te kat ya tan tsuan navanyo, to tsonyo koo rou ya na moun.” ");
INSERT INTO sps_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tan kat tsun to aya nan, ana mes onot iny naus osing e tsinan me taman ya, ya te nai kaa fisen me na moun tsunia, ana ri ina fuan te ruak iny isen. ");
INSERT INTO sps_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tsoiny ana moun te sikia ta kainy fatakop a pua rari na ina fuan, arin beerbeer san ari na ina fuan te gima rejiaf. ");
INSERT INTO sps_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","E Gov te kat a fo mamatsiny marei sensen, san a sikia ta ina isen tsuri te onot non ma fabiu na koraa, ana koraa rangats to na moun, “Kat fei, toroman e Gov te fa agagoiny mami na ina fuan ma ainy vaare mi na fo mamatsiny fua nan nau koman na tanun?” ");
INSERT INTO sps_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ana moun biny to na koraa sa tsue, “Mam ma ina fuan onot iny ainy fua nan fo mamatsiny nau te kanon tana tanun to aya. ");
INSERT INTO sps_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","San isen nau te tsutsuun non fapoopoan nan na tanun, mam ina fuan agaagon rom tan ainy fua nania, tsue fi Gov. ‘Te ainy romin fua nan nau to aya, ge te saras romi ya, mi na ina fuan mat rom’.” ");
INSERT INTO sps_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ana koraa biny to na moun sa tsue, “Gima man mi na ina fuan gim on rom ma mat. ");
INSERT INTO sps_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Te ainy romin fua nan nau to aya nan, mi na ina fuan natiny rom a ka na iring, ana ka na rof, ana mi na ina fuan te faarei e Gov. Gov nat iny non a ka to aya nan, to sen Gov fa agaagon i mami na ina fuan.” ");
INSERT INTO sps_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ana moun tagei ton nau, an nau to ayan mamatoong faarof an fua nanian rof fiisok tsun. Kat to ana moun fakats fi to nei, te nom ronyon fua nyo te ainy ya, nyo nom rou viir nat ai te rof fiisok. Kat to ana moun nom ton fua nan nau to aya sa ainy ya. Vou ya nom ton fua nan nau sa fainy ya natsoiny ya, sa ainy kainy ya. ");
INSERT INTO sps_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Sen tsun, ana ri na ina fuan tagaa fanatnat i ratuari na ina fuan na berber, kat to ser kuiny noun nan fik, ana ri na ina fuan ravrav towa. ");
INSERT INTO sps_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","San tana touraf te kour a pan, ana ri na ina fuan nongoiny to Gov te tatan non tanun, ana ri na ina fuan takop to fapoopoan na na fo nau. ");
INSERT INTO sps_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","San a Tsunaun e Gov te fikoo na mes sa tsue, “Fei te ka romanyi ei?” ");
INSERT INTO sps_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ana mes biny towa sa tsue, “Nyo te nongon i manyi te tatan i tanun. Nyo oraav to, nyo takop to, tana sa nyo na berber.” ");
INSERT INTO sps_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ai Gov rangats towa, “Sei te tsue of i manyi ee, anyi na berber, toroman anyi te ainy bus fua nan nau te fa agaagon im ma ainy vaare nyi ya?” ");
INSERT INTO sps_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ana mes biny towa sa tsue, “A moun a vatau tsonyo te faan iny anyi tsonyo, ayei te faan vanyon fua nan nau, tsonyo ainy ya.” ");
INSERT INTO sps_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ana Tsunaun e Gov rangats to na moun, “Sei tsue of i manyi ee, ma kat a ka to ee,” ana moun biny towa sa tsue, “A koraa te gam i vanyo, tsonyo ainy fua nan nau.” ");
INSERT INTO sps_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ana Tsunaun e Gov tsue to tan koraa, “Anyi te kat a ka to aya, ai tovei nyi nom rom a patang tsunia. Patang te govets romanyi, te fis pis non a patang tan fokinai mes marei. Roman an tan fokinai nainy te naa minon, nyi sensen iny rom a komam manyi, ana nyi ainy rom a fo nungan iny tan puputaa. ");
INSERT INTO sps_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nyo kat maromanyi na tafisuan tana moun, ana moun a tafisuan tsumanyi, vun tsumanyi tafisuan miror vun tana moun. Ayei pitei non a patsuu manyi, ana nyi te kots a moun ya.” ");
INSERT INTO sps_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ana Tsunaun e Gov tsue to tana moun, “Nyo faan maromanyi na patang te kaa miromanyin kura, ana nyi te kamen na kamits tsian te fagiir romanyi, san anyi kaa farokot mirom koman tana tsoiny tsumanyi ma tagaa ot manyi ya.” ");
INSERT INTO sps_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ana Tsunaun e Gov tsue to ten Adam, “Anyi te nongoiny tsue tana moun tsumanyi, ana nyi ainy ton fua nan nau, Anyo te fa agaagon manyi ya, ma ainy vaare nyi ya. Nyi kat firom nei aya, Nyo kat firing rou puputaa, ana kainy ainy te gima ruak faarof on. Anyi patsukanem binun fapaparits rom tan, kat a kainy ainy ma ruak ya tan puputaa. ");
INSERT INTO sps_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ana fo nau te kamiror kakarits, ana fo aufing a iring gian miror tan puputaa ana nyi ainy vavis rom a fo noun iny ratsuu. ");
INSERT INTO sps_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nyi binun rom an siva te buts ana kainy ainy te gian tan puputaa, nyi nag vaurep rom tana binun, onot non te mat romanyi, ana nyi te tabin tan puputaa. Tana sa, anyo te kat manyi tan puputaa, ana nyi tabin pis rom tan puputaa.” ");
INSERT INTO sps_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","A mes te asang e natsun ya e Ivi, tana sa, ayei a tsinar fokinai tsoiny an moun. ");
INSERT INTO sps_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Vou ana Tsunaun e Gov kat ton vau tana pempem nan na marei a sensen, Gov fainy towa Adam me natsun ya ana ri na ina fuan vau towa. ");
INSERT INTO sps_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Vou ana Tsunaun e Gov tsue to, “Tagaa a mes te naat bus iny a saf a ka na rof, ana saf a ka na iring, ana ayei faarei ratuara. Ara gim ror ma famanat iny ya ma naa fasiru ya panan nau te natiny faan iny non a toto. Kat non tsunia ainy fua nan nau to aya sa kaa ovei.” ");
INSERT INTO sps_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kat to ana Tsunaun e Gov gargar to na mes tana tanun i Iden. Sa faan iny naa towa ma binun ya tan puputaa te kat e Gov. ");
INSERT INTO sps_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Te gargar fakap e Gov a tsoiny ana moun Ya faka raton na fomes a fo morenan parits tana pan te natiny ruak ising minon a nuaf tana tanun iny Iden. Ya fakei ton sen kirat te mamatan faarei non guaf, ana ayei natiny takopis vavis non tan fo mamatsiny pan. A fo morena to ari nan fisen mena fo kirat te tagaa ot ror, kat non an ta isen ta mes te nai ruak tan nau to aya nan te natiny faan toto non. ");
INSERT INTO sps_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Kat to sen Adam fiinot fiisen me natsun ya e Ivi, ai natsun ya kuraa to, sa faagiir a isen na guei tsoiny, ya tsue to, “A Tsunaun te faakouts i vanyo, ana nyo faagiir to na guei tsoiny.” Ai Ivi koo tona guei to aya e Kein. ");
INSERT INTO sps_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Vou ana ayei faagiir to Ebol, a famuinyasiny ten Kein. Ebol ayei a tsoiny veis tan siip, ai Kein ayei a tsoiny katkat tanun. ");
INSERT INTO sps_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","I vou te agio fakap me Kein a kainy ainy i tanu ya atoiny to na fo mes, ya kat towan fifaan tana Tsunaun. ");
INSERT INTO sps_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ebol nom ton vaamuan na agiir tan fo siipsiip, ya atsun famat ratuari. Ana ayei nom ton na fo pan a fo rof a karap, sa kat yan fifaan. A Tsunaun te paparaa iny fifaan ten Ebol. ");
INSERT INTO sps_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","San e Gov te baainy iny fifaan ten Kein. E Kein te peits fiisok tsun en, ana matan ya matoong iny peits fiisok tsun en nato. ");
INSERT INTO sps_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ana Tsunaun tsue to ten Kein, “A saa te peits iny romanyi na? Ana saa te matoong iny peits of non a mata manyi na? ");
INSERT INTO sps_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Te kat romanyin fifaan rof tana sanaan a toobing, Nyo paparaa iny rou ya, san te kat bus anyin kat iring, sa komainy fabiu maromanyi kat iring te faarei non na marei a sensen te soon non, kakoun non tan atsun i manyi, fakats non ma fabiu manyi, san anyi ma fabiu ya.” ");
INSERT INTO sps_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ai Kein tsue to ten Ebol a famuinyasiny tsunia, “Nai vavis ara.” Te tataan na ri, Kein takopis of to e famuinyasiny tsunia e Ebol sa atsuiny famat ya. ");
INSERT INTO sps_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ana Tsunaun rangats to Kein, “E Ebol ei, a famuinyasiny tsumanyi?” Ai Kein tsue to, “Anyo gim rou ma nat. Nyi pon i vanyo na saa, ma tagaa ot iny anyo na famuinyasiny tsonyo?” ");
INSERT INTO sps_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kat to ana Tsunaun tsue to ten Kein, “Saa te kat anyi na? To san rafatsiny ten famuinyasiny tsumanyi tatsiiu tan puputaa, Anyo te nongoiny rafatsiny to aya te kuu faarei na isen na mes te fikoo Vanyo. ");
INSERT INTO sps_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Roman Nyo kat rou tsuen parits iny kat fiiring i manyi, anyi ma naus osing a painy puputaa to aya. Tana saa, anyi fatoobing te atsuiny famat e famuinyasiny tsumanyi tana nimam, an rafatsiny tatsiiu nato, an puputaa to aya te faarei non ngue te pangang non sa jiun rafatsiny to aya. ");
INSERT INTO sps_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Te binun romanyi, ana nyi te tanaf iny reev a kainy ainy, kainy ainy gim non ma gian ai te fua faarof. Ana nyi sikia rom ma kaa me ta fan tsuam fatoobing, nyi taan afafis tsun rom tan puputaa.” ");
INSERT INTO sps_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ai Kein tsue to tana Tsunaun, “U fasaraa to aya te faan iny romanyi tsonyo, na kaatsian fiisok. ");
INSERT INTO sps_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Anyi te tsue ma gargar vanyo tana painy puputaa to aya, an tana mata Manyi kan. Ana nyo sikia rou ma kaa me ta fan, nyo vavis babainy tsun rou tan puputaa. Ai to te sab varonyo ta isen ta mes, ayei atsuiny famat varonyo.” ");
INSERT INTO sps_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","San a Tsunaun te tsue, “Sikia. A isen ta mes te atsun maromanyi, Nyo tsue faman rou, Nyo pangis rou ya tan fasaraan tsian.” Ana Tsunaun fakei to na isen na mak nain e Kein, te sab fi rori yan na vainy ri te tagei a mak to aya, ri te gima atsuiny ya.” ");
INSERT INTO sps_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ai Kein bus osing to na matan na Tsunaun, sa nai kaa tan puputaa iny Not (kifon ya vavavis vavis) tana pan tan men panaainy Iden te ruak minon a nuaf. ");
INSERT INTO sps_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","E Kein te fiinot me natsun ya, ai natsun ya kuraa to ya faagiir to na isen na guei tsoiny ya koo towa Inok. Ai Kein kat to na isen na ngats fan, ya koo tsuktsuk towa na guei tsoiny tsuan. ");
INSERT INTO sps_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ai Inok faruak to na guei tsoiny ya koo towa Irat. Ai Irat faruak to na guei tsoiny ya koo towa Meyujel. Vou ai Meyujel faruak to na guei tsoiny ya koo towa Metusel. Vou ai Metusel faruak to na guei tsoiny, ya koo towa Lemek. ");
INSERT INTO sps_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek te fanging a ina fuan a moun asangan na ina isen e Eda, ana mesmes e Sila. ");
INSERT INTO sps_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Eda te faagiir e Jebel, E Jebel tsuvur vainy te natiny tagaa ot iny ror bulmakau, ana ri natiny kaa ror tana fo tovaar kandis. ");
INSERT INTO sps_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Famuinyasiny ten Jebel asangan ya e Jubal. E Jubal ayein tsuvur vainy te natiny saksak fatangis ror a gita, ri te puuf kobi/gopi. ");
INSERT INTO sps_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ai Sila faagiir to Tubal-Kein. E Tubal-Kein ayein tsuvur vainy te natiny kat ror a foka tan bras an aiyan. Fafinen e Tubal-Kein asangan ya e Nama. ");
INSERT INTO sps_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ai Lemek tsue to tana ina fuan a moun tsunia, “Ere Eda me Sila, nongon yam mi na ina fuan a moun ten Lemek. Mi na ina fuan nongon faarof yam te vegiau ronyo. Anyo te atsuiny famat a isen a mes a vurots, tana saa ayei te sapan (wounded/fatafisuan) i vanyo. ");
INSERT INTO sps_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Mes te atsuiny non e Kein ayei nom non a patang tsian, san a mes te a tsun varonyo, nom non a patang te karap fafis pis no.” ");
INSERT INTO sps_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Vou ai Adam me natsun ya fiinot pis to ai natsun ya faagiir to na guei tsoiny ya tsue to, “Gov te faan pis i vanyo na mes a guei, a pangis ten Ebol, e Kein te atsuiny famat ya.” Ana ayei koo towa Set. ");
INSERT INTO sps_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Vou ai Set faruak to na guei tsoiny ya koo towa Inos. Tan nainy tsun to aya, ana vainy tanik iny asang to na asangan na Tsunaun ana ri faatouf Towa. ");
INSERT INTO sps_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Tovein asangar aatai te tapogaar me ten Adam: Gov te kat e Adam, sa ruak faarei ya. ");
INSERT INTO sps_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Gov te kat a isen a tsoiny ana isen a moun. Te kat fakap rari ya na ina fuan, ya faparits ratuari na ina fuan, ya koo ratuari na ina fuan a Mes. ");
INSERT INTO sps_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","E Adam te kaakaa sa onots sen natus an fopis saafunu na ingainy, sa ruak iny taman a isen a guei te senviir faarei non ya. Sai Adam koo ya, e Set. ");
INSERT INTO sps_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Voun e Set te agir ya, ai Adam kaakaa to sa onots pis jian natus a ingainy, sa ka pis men guei tsoiny an guei moun. ");
INSERT INTO sps_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","E Adam te kaakaa sa onots sian natus an fopis saafunu na ingainy, ya mat to. ");
INSERT INTO sps_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set te kaakaa sa onots sen natus ana ngim a ingainy sa ruak iny taman a isen a guei tsoiny e Enos. ");
INSERT INTO sps_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set te kaan mes jian an fits a ingainy, ana ayei kaa miton mes guei tsoiny an guei moun. ");
INSERT INTO sps_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set te kaakaa sa onots sian natus ana saafunu ana fuan na ingainy ana ayei mat to. ");
INSERT INTO sps_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","E Enos te kaakaa sa onots sian saafunu na ingainy sa ruak iny taman na isen na guei tsoiny e Kainan. ");
INSERT INTO sps_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos te kaakaa sa onots jian natus ana saafunu ana ngim a ingainy, ana ayei kaa miton mes guei tsoiny an guei moun. ");
INSERT INTO sps_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","E Enos te kaakaa sa onots sian natus ana ngim a ingainy ya mat to. ");
INSERT INTO sps_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","E Kainan te kaakaa sa onots fits saafunu na ingainy. Sa ruak iny taman na isen na guei tsoiny e Mayalali. ");
INSERT INTO sps_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","E Kainan te kaakaan mes jian natus an fats saafunu na ingainy, ya kaa miton mes guei tsoiny an guei moun. ");
INSERT INTO sps_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ai Kainan kaakaa to sa onots sian natus ana saafunu na ingainy ya mat to. ");
INSERT INTO sps_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mayalali te kaakaa sa onots gonom saafunu ana ngim ma ingainy, sa ruak iny taman na isen na guei tsoiny e Jeret. ");
INSERT INTO sps_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mayalali te kaakaa pis sa onots jian natus an fopis saafunu na ingainy ya kaa miton mes guei tsoiny an guei moun. ");
INSERT INTO sps_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mayalali te kaakaa sa onots jian natus an sian saafunu ana ngim ma ingainy ya mat to. ");
INSERT INTO sps_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jeret te kaakaa sa onots sen natus an gonom saafunu ana fuan na ingainy sa ruak iny taman na isen na guei tsoiny e Inok. ");
INSERT INTO sps_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","E Jeret te kaakaa pis sa onots jian natus a ingainy, sa kamen mes guei tsoiny an guei moun. ");
INSERT INTO sps_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jeret te kaakaa onots sian natus an gonom saafunu ana fuan na ingainy ya mat to. ");
INSERT INTO sps_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","E Inok te gonom saafunu ana ngim ma ingainy ya kaa mito na guei tsoiny e Metusela. ");
INSERT INTO sps_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","E Inok te taan fiisen me Gov, Inok kaa ton mes fopis natus a ingainy sa ruak iny tamar mes guei tsoiny an guei moun kan. ");
INSERT INTO sps_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","E Inok te toto sa kan fopis natus an gonom saafunu ana ngim ma ingainy. ");
INSERT INTO sps_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","E Inok te taan fiisen me Gov, ai Gov nom towa, ana vainy gim to ma tagei pis ya. ");
INSERT INTO sps_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","E Metusela te kaan sen natus an fits saafunu na ingainy sa ruak iny taman na isen na guei tsoiny e Lemek. ");
INSERT INTO sps_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","E Metusela te kaan mes fits natus an jian saafunu ana fuan na ingainy ya kaa miton mes guei tsoiny an guei moun. ");
INSERT INTO sps_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","E Metusela te kaan sian natus an gonom saafunu an sia na ingainy ya mat to. ");
INSERT INTO sps_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","E Lemek te kaan sen natus an jian saafunu ana fuan na ingainy sa ruak iny taman na isen na guei tsoiny. ");
INSERT INTO sps_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ai Lemek tsue to, “A Tsunaun te fakei tsuen parits iny kat fiiring puputaa. A guei to aya favusuainy rarora tana nag tan puputaa”; kat to ai Lemek koo to na guei to aya e Noa. ");
INSERT INTO sps_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","E Lamek te kaan mes ngim natus an sian saafunu ana ngim ma ingainy, ya kaa miton mes guei tsoiny an guei moun kan. ");
INSERT INTO sps_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","E Lamek te ka sa onots fits natus an fits saafunu ana fits a ingainy ya mat to. ");
INSERT INTO sps_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","E Noa te kaan ngim natus a ingainy sa ruak iny taman na ina pis a guei tsoiny, ere Siem, Ham, ai Jafet. ");
INSERT INTO sps_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Te ruak fakap a vavainy tana fo mamatsiny pan tan puputaa, ana ri kaa miton guei moun, ri faagiir ton guei moun an guei tsoiny. ");
INSERT INTO sps_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","U guei tsoiny ten Gov te tagei ir moun te mamatoong faarof fiisok, an fo isen isen tsuri nom raton moun tan koman patsukan tsuri, ana ri fanging ratuari. ");
INSERT INTO sps_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ana Tsunaun tsue to, “Nyo gim on rou ma famanat iny a aavev Vanyo ma faan toto ya tana mes, a kaa ovei to, tana saa, arin vainy na iring tsun. Tanik non roman ayei kaa non onots non sen natus an fuan saafunu na ingainy.” ");
INSERT INTO sps_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tan nainy to aya, an tan nainy te naa yen, te kaa men vainy kaatsian te kaakaa tan puputaa. U vainy to ari, u guei tan moun, ari te fanging ir guei ten Gov. Arin vainy parits fiisok, ana ri kan te kaa men asangan tan nainy to aya. ");
INSERT INTO sps_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","A Tsunaun te tagei kat tana vavainy tana fo mamatsiny pan gim ma rof tan fokinai nainy, u aave rari te fakats tsuiny non a foka na iring. ");
INSERT INTO sps_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ana Tsunaun fakats fatabin pis to i muan, te kat fi ya na tsoiny ana moun ya paparaa to. San a Tsunaun te tagei ir tsoiny an moun, ari te fakats tsuiny a foka na fo iring, ya gim pis to ma paparaa iny a binun te kat ya muan. ");
INSERT INTO sps_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ana Tsunaun tsue to, “Nyo kat fiiring rou a fokinai vainy, nyo te kat rari, kainon na saf a pan ya na te kaa rori na. Nyo kat fiiring kani rarou marei sensen an marei roruaf ana fo mamatsiny ka. Anyo patsukan you te kat a foka to ari nan, san Anyo te gima paparaa pis iny rari.” ");
INSERT INTO sps_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","San a Tsunaun te paparaa iny e Noa. ");
INSERT INTO sps_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Tovein siisio ten Noa. Ayei te kaa men na ina pis a guei tsoiny, ere Siem, Ham, ai Jafet. Noa ayei a mes a rof, an tataan tsunian toobing matan e Gov. Ayei a vaatau faman ten Gov. ");
INSERT INTO sps_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","San a fo mes a fo vainy te kaa fiiring matan e Gov, an kat iring an kat iny fitaatsun via enato tana fo mamatsiny pan. ");
INSERT INTO sps_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","San Gov te matoong me tan puputaa ana ayei tagei ton kat tana vavainy, iring fiisok, tataan tana mes, a kuav tsun. ");
INSERT INTO sps_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ai Gov tsue of to Noa, “Fokinai vainy te natiny kat ror viirviir kat iring, to na ka te komainy kat fiiring of ronyo ri, Nyo fakap faman i rarou a fokinai vainy. ");
INSERT INTO sps_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Anyi ma nom om tan nau rof, ana nyi te kat yan sen puak tsian tsumanyi. Nyi ma kat a fo bebei i gagon koman ya, ana nyi te us a koman ya ai jiarasan nan ya tan kolta. ");
INSERT INTO sps_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Anyi ma kat puak tsian to aya, a bangbang nan ya onots non fits saafunu ana ngim (75) ma ngaf, ana viviakoo nan ya onots non sen/fats natus an ngim saafunu (450) ma ngaf, ana nai jias nan ya onots non fats saafunu ana ngim (45) ma ngaf. ");
INSERT INTO sps_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Nyi kat rom a tagaa rubong nan puak tsian to aya, san a tagaa rubong to aya, te gim non ma sopip fakap. Anyi fakei rom a fuan seir fapoopoan nan na tagaa rubong ana soopip. I gagon tana puak tsian, anyi kat rom a fopis a pan iny ka, isen putaa, isen fapoopoan ana mes i jias. Ana nyi te kat matai sobaa ririkin a puak tsian. ");
INSERT INTO sps_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nyo kat rou teisinuu tsian ai te ruak tan puputaa, ma kat fiiring ya na foka te kaa miror a toto. Fo mamatsiny ka mat ror. ");
INSERT INTO sps_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Anyo kat rou tsuen parits fiisen maminyi. Anyi ma sof gagon koman na puak tsian fiisen me natsum an guei tsumanyi fiisen men moun tsuri. ");
INSERT INTO sps_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nyi ma nom i rari ina fuan, ina fuan fo mamatsiny viir marei sensen, isen na tsoiny, isen na moun. Ana nyi te a ton ra naa ri gagon koman na puak tsian fiisen ma minyi, ma gima mat ari. ");
INSERT INTO sps_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ina fuan, ina fuan tan fo mamatsiny viir marei roruaf, an fo viir marei sensen kaatsian, an marei sensen kakaii, ari ma sof kan gagon, ma gima mat vaare ri. ");
INSERT INTO sps_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nyi ma nom viirviir kainy ainy i tsumanyi an tan marei sensen an marei roruaf.” ");
INSERT INTO sps_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Eye, e Noa te kat a fo mamatsiny ka te tsue of ya Gov ma kat. ");
INSERT INTO sps_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Vou na mat ten Moses kat to ana Tsunaun tsue to ten Josua na guei tsoiny ten Nan, ana ayei kan a faakouts nan e Moses, ");
INSERT INTO sps_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","sa tsue, “E Moses a tsoiny binun tsonyo te mat busen. Anyi ma kakoun ana nyi te nom ir a fokinai vainy iny Isrel ana mi te guas tan mes panainy aurom tana aurom iny Jodan mi te naa tan puputaa te faan bus iny Anyo tsumi. ");
INSERT INTO sps_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Faarei te tsue of finy Anyo Moses, pan te pitaa non a mou manyi tsunia, ayei nan puputaa te fan im yam. ");
INSERT INTO sps_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Vaana'on tsumi tatanik minon papatsuun na ratsuu na uur tan panainy saut, ya te nai fakifon me tana tobeer iny Lebonon tan panainy not. U puputaa tana vun tana taa Hitait ai te nai onot ovei tana Aurom tsian iny Yufereitis tan panan te ruak minon a nuaf, puputaa to aya nom kainy romi. Ya te nai tatangin tana Namaan tsian iny Mediterenian tan panaan te ruk ising nanon na nuaf. ");
INSERT INTO sps_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Josua, tana toto tsuam sikia ta tafisuan te onots non ma kat tap manyi, te naa romi tana puaan, tana saa, Nyo gim on rou ma anofe manyi, san Anyo kaa fiisen marom faarei te kaa fiisen fi minyo e Moses. ");
INSERT INTO sps_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Anyi ma fasiireits a komam ana nyi te tsun faparits, tana saa anyi te mumua ir rarori a vavainy na to ari tan nainy te nai gum romin puputaa to te fafaatai bus anyo na fo tsuvumami muan. ");
INSERT INTO sps_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Anyi tsun ma koma reits ana nyi kan ma parits, a ka tsun ma kat ami, ami ma makok a Faun faavot tan Faun te faan mami e Moses a tsoiny binun tsonyo. Te vovou faarof finy romanyin Faun faavot ana nyi te onot ma kat a foka te komainy romanyi ma kat; tana fo pan te naa romanyi. ");
INSERT INTO sps_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Josua, ami ma fagum vaare tan gogosias Buk tan Faun, tan nainy te faatouf romi. Gogosias yam a Faun tana fo mamatsiny nainy, ana mi te manaats a fo mamatsiny ka te tsue non na Faun, ana mi te sab nainy rof. ");
INSERT INTO sps_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Anofe vaaren vegiau te tsue of im, to ma siireits ana nyi te tsutsun faparits! Oraav ge fagagaar vaare tana sana Anyo Gov tsumanyi, ana Nyo kaa fiisen maromi tana fo pan te naa romi.” ");
INSERT INTO sps_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","11","Te vegiau fakap a Tsunaun ten Josua, kat to ai Josua tsue of raton na fo tsoiny mumua ma naa ri tana fo tovaar tana pan te totovaar ari er tsue fi to nei tana vavainy, “Kakoun onots yam ta kainy ainy iny tamar tan fopis nainy to te kaakaa non, tana saa ara te guas ror tan mes panainy aurom tana aurom iny Jodan. Ra te nai gum tan puputaa te faan rara na Tsunaun.” ");
INSERT INTO sps_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Josua tsue of ratuari na vavainy tana fopis a vun, a vun ten Ruben, ana vun ten Gad, an mes panan nar vainy tana vun ten Manase, ana ayei tsue to tsuri, ");
INSERT INTO sps_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Anofe vaare yam vegiau te fafaatai mami e Moses, to te tsue fi naa Tsunaun ma nom finy amin panainy puputaa tovei aya te kaa non tan panaan te ruak minon na nuaf, panainy aurom tana aurom iny Jodan to te kat fan romi tsunia. ");
INSERT INTO sps_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Fokinai, moun an guei tsumi fiisen me na fo marein sensen ton tsungan, kaakaa ror nei aya, san a vainy puaan tsumi to te kakoun of a puaan ser kaa miror a foka iny fapupuaan, te guas famumua iraror a fo famuinyasiny tsumi na taa Isrel er faakouts ratuari tan nainy te guas rorin mes panainy aurom. ");
INSERT INTO sps_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Onot non te ruak faarof rori tan puputaa tsuar tan mes pannan nan na Jodan tan panaan te ruak ising non na nuaf, a pan te faan rari na Tsunaun. Te ruak faarof ror a fo vun vun tana fo pan tsuar ana mi te see tatabin me tan panainy fan tsumi to te faan bus mami e Moses a tsoiny binun tana Tsunaun.” ");
INSERT INTO sps_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ana vavainy tana fopis a vun to ari, pangis ton vegiau ten Josua ser tsue, “Amam kat rom a foka te tsue nyi mam ma kat ana pan te jiat fi maroman anyi, mam naa rom. ");
INSERT INTO sps_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Mam nongoiny maromanyi, faarei te nongoiny finy amam e Moses, a Tsunaun kaa fiisen marom, faarei te kaa fiisen mi ya Moses. ");
INSERT INTO sps_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Sei ta isen ta mes te gim non ma vovou iny a kaa te tsue romanyi, a mes to aya te nai atsun famat non.” Ana vainy tsue to ten Josua, “Tsutsun faparits.” ");
INSERT INTO sps_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Vou bus ai Josua jiats to na ina fuan na tsoiny totoboo tsuri na taa Isrel tana pan te totovaar ari i Akasia, ma naa ri Kanan er nai tagaa famun to fei te kat fi non ya na pan ei, san fakats tsian tsuri ari te komainy fiisok a Jeriko. Tan nainy te ruak ari tana ngats fan iny Jeriko ari pon to ma nai goros numa ten Reheb a moun to te natiny faan vavis iny non a kifon tan tsoiny. ");
INSERT INTO sps_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","San a aatouf iny Jeriko te nongon fi nei, kaa miror vainy Isrel te ruak me Jeriko tana touraf, a tou toboo kabuts i rari, ");
INSERT INTO sps_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Ya kat to sana ayei faan iny naa to na vainy ma nai rangats ari, e Reheb, ana ri tsue to, “Vavainy naa to numaa tsuam ari na tou toboo kabuts a vun tsura. Fatafuts rame jiarasan!” ");
INSERT INTO sps_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","6","Reheb biny ton vegiau tsuri sa tsue, “Te kaa pas korei men vainy te naa me numaa tsonyo, san anyo gim rou ma nat fei faman te poo miri ei? Sai ari te tabin kan er tana touraf ovei, ana ri tabuiny ma siisiots matainy sobaa. Anyo kan te gima rangat fei te naa fi rori ei, san ami ma vovou tsikap ra naa ri ami onot rom ma nai sab irari ana mi te nots rari.” Reheb te nom ir a ina fuan na mes sa fatakop rari fain na fo kots guav te faparainy ya patsun na numaa tatabuan. ");
INSERT INTO sps_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Kat to an vavainy tana aatouf naus osing to na ngats fan, an matainy sobaa siisiot to vou rari. Ari vovou ira nato na ina fuan na tsoiny totoboo ser nai onot ovei tana sanaan tatangin na pan iny guas tana aurom iny Jodan. ");
INSERT INTO sps_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Tana voiny bus, te buiny goros rori na ina fuan na tsoiny Isrel, Reheb pas fatabin pis naa to jias tsuri, ");
INSERT INTO sps_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ya tsue of ratuari na ina fuan, “Anyo nat you te faan fi mami na Tsunaun puputaa tovei aya ana vainy faavot tana vun to, oraav fiisok maromi. ");
INSERT INTO sps_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","A mam te nongoiny vaanan te kat fi na Tsunaun a namaan te koo rori na Namaan iny Gautsiroun to sa mats, sam taan fa guas naa tan mes panaan, tan nainy te naus osing mi mi na Ijip. Mam nongoiny pis kainy ton mes vaanan te atsuiny faamat fi mi e Sihon me Og, a ina fuan na aatouf tana taa Amor te kaa ror tan panainy aurom iny Jodan te ruak nan nuaf. ");
INSERT INTO sps_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Tan nainy te nongoiny amam a foka to mam a fokinai iny Jeriko oraav fatsian tsun mato, mam fokinai te gagaar faavot em te nongoiny amam a ka to. E Gov a Tsunaun tsumi Ayei na Gov faman iny Gormirmir ai nei kan petoo. ");
INSERT INTO sps_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Sai tovei, ami ma kat tu tsuen man tana asangan e Gov, te faakouts faarof fi romin a vainy koman na numainy guei tsiau faarei non te kat faarof fi vanyo mi. ");
INSERT INTO sps_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Ami ma faatok vanyo ta ka te tagei ronyo nyo te famainy mami. Tsue faman of vanyo yam te gim finy romi ma atsun famat e tamanyo me tsinanyo, an fo famuinyasiny ana fafine vanyo ana ri kan guei tsuri! Ami ma atsun famat vaare mamam.” ");
INSERT INTO sps_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Ana ri ina fuan tsue of to Reheb, “Anyi ma tsue of vaare ta mes tana foka te kat amam. Amam tsue of marom tsuen man, tan nainy te faan maromam a Tsunaun puputaa to aya, mam kat faarof maromi, san te gim fi romam ma vovou iny vegiau to te tsue mam, te rof non tana Tsunaun ma atsuiny famat mamam ya.” ");
INSERT INTO sps_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","A numaa ten Reheb te sumainy tsuiny non a soopip nan na aunon, to te aunoiny afis ari na ngats fan. Ana numaa to aya te kaa minon na windua te matoong fi naa non jiarasan. Ai nan na windua te fauf ising naa ya na ina fuan na tsoiny totoboo tana taa Isrel. ");
INSERT INTO sps_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Te buiny fauf non ya na ina fuan na tsoiny totoboo, ya tsue of ratuari, sa tsue, “Ami nai takop tsom rom tan panainy west nan na Jodan pan te kaa minon a fo painy tobeer, kat ror san vainy tana aatouf iny Jeriko sab mami. Nainy te ruak romi tana fo tobeer ana mi te takop tsom, onots ton fopis nainy te naginy tsitsikoo maromi ri, ana ri te tabin fatabin me Jeriko. Fopis nainy te kap non mi te see tataan fi naa tana pan te totovar romi.” ");
INSERT INTO sps_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","Kat to ri ina fuan tsue of to Reiyab, “Amam kat nats rom a ka te tsue of mamam anyi, san anyi ma nongon faarof. Tan nainy te buiny ruak ror a taa Isrel nei, nyi nom rom a painy a foon to na gautsiroun to te natiny kat rori pous ana nyi te tang iny ya tana windua to aya te of ising romam ma gageits en ya. Ana nyi ma tsue of e tamam ai tsinam an famuinyasiny an fafine manyi ai sei pis ta mes ten tamamanyi ri fokinai nai ovot miror nei aya numaa tsumanyi. ");
INSERT INTO sps_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Sikia on ta mes te naus osing non a numaa tovei. Sei ta isen tsumi te naus osing non a numaa to ana ayei te sab a mat, a iring ruak non tsunia gima ka tsumam san a iring tsunia patsukanen. San tan nainy te sab non a isen a mat nei koman a numaa to, a iring ruak non tsunia naa minon tsumam. ");
INSERT INTO sps_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Taatag, nyi kan ma siisio of vaare taa isen ta mes tana saa te nai kat mimam na. Nyi siisio rom, ana mam te gima faakouts on mami faarei te tsue fi mam.” ");
INSERT INTO sps_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Reheb tsue faunot to, ya nom to na afoon ana ayei fauf osing bus ratuari tana windua, ri naa bus erato. Te naa bus ari na ina fuan, Reheb nom to na painy afoon na gautsiroun to te faan iny a ina fuan na tsoiny totoboo, ya tang bus iny towa tana windua. ");
INSERT INTO sps_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Ina fuan na tsoiny totoboo naa to tana fo painy tobeer ser takop, sa onots fopis nainy te tsitsikoo rari ri na vavainy tana aatouf iny Jeriko. Ri nag iny tsitsikoo rari, ri tabin buser rato Jeriko. ");
INSERT INTO sps_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","24","Kat to ana ina fuan na tsoiny totoboo iny Isrel naus osing miton fo painy tobeer, voun fopis nan nainy ri guas to naa aurom, ri nai ruak to ten Josua. Ri kat to ser siisio of ya na foka te tagei miri, ri tsue of kainy towa ser tsue, “Amam te nat firom nei a Tsunaun te faan ir rara nu puputa iny Jeriko tana saa, a fokinai vainy unya aya te oraav fiisok tsun rarora.” ");
INSERT INTO sps_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Tan na voinyvoiny nan mes nainy, a taa Isrel tagun to tana voinyvoiny ovei ser nom ton na fo mamatsiny ka te totovaar iny ari i Akasia ri nai totovaar pis to ririkin na Jodan anaanos arin nainy te guas rori tan mes panainy aurom. ");
INSERT INTO sps_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Tan fafofopis nan nainy te totovaar ari, kat to an fo tsoiny mumua taan vavis to tana fo tovaar ri tsue of raton na vavainy, ");
INSERT INTO sps_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","“Tan nainy te tagei romin a fo tsoiny faakor te sog rorin na Gen te kaa minon na fo tsuen man, an Faun ten Gov (covenant bokis) a Tsunaun tsura mi te pat ravainy pis a fo tovaar tsumi mi te vovou irari. ");
INSERT INTO sps_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ari taan famumua ror, ri faatok maromi na sanaan te taan romi tana saa ami te foun iny rom a pan to. Ami vovovou ir rarori, san ami ma fasiruu vaare tana Gen te kaa minon tsuen man an fo Faun kan ten Gov. Ami ma faveevian onots ton na pan nan na isen na mail. ");
INSERT INTO sps_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Josua tsue pis to tsuri, sa tsue, “Nom ravainy yam fo iring tsumi ma taabos ami, tana saa a Tsunaun te kat nats non a ka iny faatok fapoopoan na mani tamanainy.” ");
INSERT INTO sps_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Tana voinyvoiny bus Josua tsue of iraton tsoiny faakor ma sog bus ari na Gen te kaa minon tsuen man an Faun ten Gov ma taan famumua bus naa ri. Ri kato ser kat mamatsiny ka te tsue of rari e Josua, ri ma kat. ");
INSERT INTO sps_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Ana Tsunaun tsue to ten Josua sa tsue, “A ka te kat nats ronyo roman, te kat iraror a taa Isrel ri te nat manyi na mes tsian ana ri te fatsiitsii manyi, ma nat faman kan fi ri nei Anyo kaa fiisen maromanyi faarei te kaa fiisen fi minyo e Moses. ");
INSERT INTO sps_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ana nyi te tsue of ir tsoiny faakor to te natiny sog ror a Gen te kaa minon tsuen man an Faun, tan nainy te nom naa rori tana aurom, ana ri te fataan varik fi na koman na aurom vou ri te tsutsun. ");
INSERT INTO sps_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Kato ai Josua tsue of raton na vavainy, sa tsue, “Ami na fokinai ma naa me nei am nongon to tana saa te tsue of maromi na Tsunaun tsumi e Gov.” ");
INSERT INTO sps_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","11","Tan nainy te taan na rora Ayei jiat vavagein raror a taa Kanan ana taa Hiti, ana taa Peris ana taa Girgas, ana taa Amor, ana ri kan na taa Jebus. Ami te nai nat nats emarom to te kaa fiisen fi maromi e Gov ayei na toto tan nainy a Gen ten Gov a Tsunaun tana monaagits faavot te guas famumuei maromi ya tana aurom iny Jodan. ");
INSERT INTO sps_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Sai tovei pisainy yam ta ina safunuu ana fuan ta mes, isen na mes tana isen na vun tana safunuu ana fuan na vun iny Isrel. ");
INSERT INTO sps_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Tan nainy te pitei ror a fo tsoiny faakor to te natiny sog ror a Gen ten Gov a Tsunaun tana monaagits faavot to na aurom, ana aurom iny Jodan te gum ovei nanon gim on non ma koor on, ana aurom to te koor minon painy puta te nai ovot enanon tana isen na pan. ");
INSERT INTO sps_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","U nainy to aya, u nainy iny agio, to sana aurom urungat. Tan nainy te naus osing a vainy a pan te tovar ari ma guas bus ari tan mes panainy aurom tana aurom iny Jodan, kat to an tsoiny faakor sog to na Gen ten Gov te kaa minon tsuen man an Faun kan Tsunia ser taan famumua ra na ri. Tan a nainy te pitei fo tsoiny faakor a aurom, ");
INSERT INTO sps_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ana aurom gum enato sa gima koor sa fauvot en na na jias tana patsun na aurom unya, tana ngats fan iny Adam te gum non ririkin na Jaretan. Ana sikia ta aurom ma koor fi na painy putaa nai ruak to tana Namaan iny Mat. A vavainy taan faguas tsun eranato tan mes panainy aurom panaan na Jeriko. ");
INSERT INTO sps_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Tan nainy te taan faguas nan na vainy tan puputaa nu parak, an fo tsoiny faakor to te sog a Gen ten Gov tsutsun pas er koman na aurom iny Jodan sa onot ovei te guas fakap naa ari na fokinai. ");
INSERT INTO sps_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Tan nainy te guas fakap bus a fokinai vainy tana vun iny Isrel tan mes panainy aurom tana aurom iny Jodan, kat to ana Tsunaun tsue of to Josua, sa tsue, ");
INSERT INTO sps_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Tana safunuu ana fuan na vun iny Isrel anyi nom rom ta isen ta mes tana isen isen na vun, ");
INSERT INTO sps_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ana nyi te tsue of irari na ina safunuu ana fuan na mes to ari isen patsukan na mes nom non na isen ta fats, tsuan naa aya koman na aurom, tana inin na pan te tsutsun fo tsoiny faakor. Ana nyi te tsue of irari ma govets naa ri na fo fats to aya ana ri te fakei ya tana pan te nai tovaar nats romi tovei tana voiny.” ");
INSERT INTO sps_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Tan nainy te pisainy fakap bus e Josua na safunuu ana ina fuan na mes to ari, ana ayei fikoo ratuari. ");
INSERT INTO sps_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Ya tsue of ratuari sa tsue, “Kua famumua nats yam Jodan, mumua iny nats yam a Gen te kaa minon tsuen man an Faun ten Gov. Mes patsukan fatua gogon iny naa non a isen na fats tsuan, naa of non a nain ya na vun tana vun iny Isrel. ");
INSERT INTO sps_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Tan nainy te tagei ror a vainy fats to ari ana ri te fakats fatabiny a ka te kat a Tsunaun tana aurom iny Jodan. Tan nainy vou te rangats varomin guei tsumin saf man nan fats to ari na, ");
INSERT INTO sps_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Ana mi te tsue of irari tan nainy te guas a Gen te kaa minon tsuen man, an Faun ten Gov ana pan te guas ari mats enato sa gim to ma koor. Ai nan a man nan fats to aya, ma natiny tagei ari ya na vavainy ri te fakats fatabiny a ka te ruak fatoobing nei aya.” ");
INSERT INTO sps_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Ana vavainy kat ton a foka te tsue of rari e Josua ri ma kat. Ari nom a safunuu ana fuan na fats tana koman na aurom, isen na mes patsukan govets a nain ya na fats ri govets fi naa towa tana pan te tovaar rori tana voiny, ri faroso towa putaa. ");
INSERT INTO sps_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Josua te nom kan ir a te vainy ri fatsuiny ton na mes a safunuu ana fuan na fats inin a pan te tsutsun a fo tsoiny faakor to te sog a Gen te kaa minon tsuen man an Faun ten Gov, koman na aurom (onot roman u fats to ari te kaa farokot kan eraror.) ");
INSERT INTO sps_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","A fo tsoiny faakor to ari te tsutsun koman na aurom iny Jodan sa onot te kat fakap ari na fokinai ka to te tsue of a Tsunaun e Josua ma kat. A foka to aya te tsue kan iny e Moses. A vavainy te guas vevesau tsun er tan mes panan nan na aurom. ");
INSERT INTO sps_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Tan nainy te ruak bus a fokinai tan mes panainy aurom kat to an tsoiny faakor to te natiny sog ror a Gen te kaa minon tsuen man an Faun ten Gov taan famumua pis ratuari na fokinai vavainy. ");
INSERT INTO sps_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","A vainy tana vun ten Ruben ai tana vun kan ten Gad an mes panainy vavainy tana vun ten Manase ari to te kakoun iny fapupuan famumua kan ra nari na vavainy, faarei te tsue of irari e Moses. ");
INSERT INTO sps_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","A Tsunaun te kaa fisen ramiri, to sa onots ovein fats safunuu na tapan tana vainy te kakoun of a puan to ser guas tan mes panainy aurom ri na fi eranato tana pan a toobing panan na Jeriko. ");
INSERT INTO sps_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","A taa Isrel te tagein na ka te kat a Tsunaun to ser tagei fanatnat iny e Josua, ayei na gima mes babainy. Ri kat to ser fatsitsi bus to Josua onot te mat ya, faarei te fatsiitsii finy ari Moses. ");
INSERT INTO sps_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","16","Kat to ana Tsunaun tsue of to Josua ma tsue of yan tsoiny faakor to te natiny sog ror a Gen te kaa minon tsuen man ten Gov an Faun kan Tsunia, ma pasan osing bus ari na aurom. ");
INSERT INTO sps_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Josua vovou iny ton na ka te tsue of ya na Tsunaun ma kat. ");
INSERT INTO sps_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Tan nainy te pasan osing bus tsoiny faakor a tatangin na aurom, kat to ana aurom tanik iny koor fatabin busen nato faarei te natiny koor famuan fi ya. ");
INSERT INTO sps_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","A vavainy te guas a aurom tana faa safunuun nainy tana vaamuan nan na iifaa, ana ri tovaar to panan na ngats fan iny Gilgal, tatangin na Jeriko tan panan te natiny ruak osing minon na nuaf. ");
INSERT INTO sps_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Kat to ai Josua fatsutsuiny to na safunuu ana fuan na fats to te nom mi ya tana aurom iny Jodan. ");
INSERT INTO sps_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Ana ayei tsue of raton na taa Isrel sa tsue, “Tan nainy vou te tsikoo iny rangat ror guei tsumi saf man nan fats to ari na, ");
INSERT INTO sps_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","ana mi te tsue of irari te faakouts fi mami na Tsunaun tan nainy te famats ya na aurom to sam taainy guas a aurom iny Jodan tana mats. ");
INSERT INTO sps_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","A Tsunaun Ayei na Gov tsura te faamats of rara na aurom iny Jodan ma guas ara senvir minon te kat fiya tana aurom iny Riid (Red Si) sa onot ovei nainy te guas fakap ari tan mes panan. ");
INSERT INTO sps_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Tana ka tsun to aya te kat iraror a fokinai tana monaagits faavot to ana ri te nai nat iny a karap nan na parits ten Gov ana mi te fatsiitsii na Ya Ayei na Tsunaun, tan fo mamatsiny nainy.” ");
INSERT INTO sps_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","A fo atouf tana taa Amorait to te gum tatangin na Jodan tan panainy ruk nan na nuaf (west) ana ri kan na fo atouf tana taa Keinan to te gum erer tatangin na Naman nan na Meditereinian ari te nongon te faa mats fi na Tsunaun a aurom iny Jodan sa onot te guas fina fokinai vainy tan mes panainy aurom. Ana koma rari of enato tana sa ari te oraav ir a taa Isrel. ");
INSERT INTO sps_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Ana Tsunaun tsue of to Josua sa tsue, “Anyi ma nom ta fats nato ana nyi te kat tu fo pei fats ana nyi te peen u pempem nar mangai Isrel to te agiir tanik non tan nainy te naus osing mi mi na Ijip, ai te onot tan nainy te ruak ami tan puputaa to.” ");
INSERT INTO sps_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Ai Josua kat to na foka te tsue of ya na Tsunaun, ayei pee ots ton pempem nar mangai Isrel tana painy tet te koo bus rori painy tet te vaapee ri. ");
INSERT INTO sps_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","6","A fokinai guei tsoiny te pee bus a fo pempem nar ana ri te buiny ma naus osing a Ijip. Sai tan nainy te naus osing ari na Ijip ser taainy a buiny ratsuu na uur sa onots fats safunuu na ingainy, a sikia ta isen ta guei tsoiny te agir tan nainy to aya ma pee ravainy pempem nan. Ana ri kan a vainy to te mes buser ser onot er tan naa tana puaan, ari te mat fakap er tan nainy te naus osing miri na Ijip tana saa ari te gima vovou iny tsue tana Tsunaun. Faarei tan tsuen man te tsue of yan fo tsuvurari sa tsue, ayei gim non ma faamanat irari ma tagei arin puputaa to te via minon a masun ana kainy ainy a kinai onot ror ma gian tan puputaa to aya. ");
INSERT INTO sps_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Arin guei tana vainy to ari te gima peewee ravainy pempem nar, arin aatai iny guei to ari e Josua te peewee ravainy pempem narari. ");
INSERT INTO sps_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Tan nainy te peewee fakap bus arin pempem nar, ana ri na vun iny Isrel faavot kaa faamo to tan Tovaar tsuar, onot te maf a fo pee. ");
INSERT INTO sps_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ana Tsunaun tsue of to Josua, sa tsue, “Anyo nom ravainy rou a rejiaf na iring te kaa mi mi tan nainy te faarei amin tsoiny gog unya Ijip.” Ai nan a ka te koo of ari na fan to aya na Gilgal, u asangan to te asangan kan iny non ya roman. ");
INSERT INTO sps_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Tan nainy te totovaar a taa Isrel unya aya Gilgal tana pan a sikia ta tobeer, a pan a toobing tsun unya panan na Jeriko, ri kat ton fo mamatsiny ka iny makok Nainy Tan Fakats Fatabin tana faa safunuu an fafats nan nainy koman na iifaa. ");
INSERT INTO sps_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Ai tan mes nainy u nainy te vaamuan iny ainy bus arin kainy ainy te gian tan puputaa iny Kanan; a kainy ainy to ari a fo fuan monmon, an koinykoiny a sikia ma kaa me tu yis. ");
INSERT INTO sps_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Ana ri na taa Isrel gim to ma nom bus tu Mana to te poo me jias, san tan ar nainy to aya ri tanik iny ainy fatoobing bus ton kainy ainy te gian fatoobing tan puputaa iny Kanan. ");
INSERT INTO sps_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Tan nainy te taan fasiru na Josua i Jeriko, sen tsun ana ayei tagei to na isen na mes tsutsuun non matuen ya, ayei te kaa men kirat niman. Josua taan fatoobing naa to tsunia ai na mes to aya ana ayei rangats towa, “Fis ya, anyi na isen na tsoiny puaan tsumam ge, anyi na tafisuan tsumam?” ");
INSERT INTO sps_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Ana mes biny ton rangat ten Josua sa tsue, “Anyo sikia ma tsoiny puaan tsumi, ana Nyo kan a gima tafisuan tsumi. San Anyo naa faarei me na tsoiny mumua tan vainy puaan ten Gov.” ");
INSERT INTO sps_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Ana Tsunaun tan vainy puaan ten Gov tsue to tsunia, “Fafious ravainy suu nato moum manyi, anyi te tsutsun rom tan puputaan taabos.” Ai Josua kat to na ka te tsue of ya na Tsunaun tan vainy puaan ten Gov. ");
INSERT INTO sps_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","U matainy sobaa nan na soopip to te soopip afis ari na Jeriko nu pingping, an vainy tagaa ot iny towa tana sa ari te oraav kat ror sana taa Isrel sof na gagon. Ari sikia ma famanat kainy ta mes ma sof na gagon, ge ma tafuts osing a ngats fan. ");
INSERT INTO sps_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","A Tsunaun tsue of to Josua, sa tsue, “Ami te faduen nats rom a fan iny Jeriko, fiisen ramen na fo Aatouf tsuar, ana mi faduen nats rarom fo vainy puaan tsurin rof. ");
INSERT INTO sps_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Ana nyi taainy faafis rom a ngats fan iny Jeriko fiisen ramirin vainy puaan tsuam, onots non aunom ovein nainy, san tan isen isen nainy ami isen tsun rom tan taainy faafis a Jeriko, ami kat rom senviir kat onots non aunom ovein nainy. ");
INSERT INTO sps_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ana ina fits a tsoiny faakor, isen patsukan na tsoiny faakor govets non na nain ya na tsufing, ari to ari taan famumuei nats ror a Gen ten Gov tan fafits nan nainy, anyi fiisen ramirin vainy puaan tsuam, ami fits iny taainy faafis rom a ngats fan, an tan nainy to aya arin tsoiny faakor puuf ror a fo tsufing tsuar. ");
INSERT INTO sps_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Tan isen puuf te kat nats rori, ari puuf ror ana ri te ras a nguer, an tan nainy te nongoiny romin tangis na tsufing to aya, fokinai tsoiny vavia kuu faavot ror, tan nainy to aya a soopip nan na ngats fan te nai tarop faavot enanats non. Ana mi na fokinai vainy puaan faavot, taan fatoobing na rom koman na ngats fan.” ");
INSERT INTO sps_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Josua fiiko bus raton tsoiny faakor ya tsue of ratuari, sa tsue, “Sog yam a Gen te kaa minon tsuen man an Faun ten Gov, ana mi na ina fits nato ari, ami te mumua iny nats rom a Gen, san ami ma govets kainy nan tsufing tsumi.” ");
INSERT INTO sps_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Kat to ana ayei tsue of bus raton vainy puaan tsuan ser tanik iny taainy faafis bus to na ngats fan, an tatagaa ot iny to na Gen tana Tsunaun. ");
INSERT INTO sps_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","9","To te tsue of irari e Josua, u vainy tatagaa ot mumua bus raton tsoiny faakor to te puuf a fo tsufing; an mes fo tsoiny faakor vou rari govet ror tana Gen ten Gov te kaa minon tsuen man an Faun ten Tsunia, an mes tatagaa ot vou rari. Tan nainy to aya ri puuf ton tsufing tsuar. ");
INSERT INTO sps_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","San e Josua te tsue of irari ma kuu vaare ri, ge ma gim ari ma vegiau onot non faan finon yan tsue. ");
INSERT INTO sps_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Kat to ana ayei tsue of ratuari ma isen iny taainy faafis ari na ngats fan. Vou bus ari tabin fatabin to tana pan te tovaar ari, ser kaa tsom pis to na isen na voiny unya aya. ");
INSERT INTO sps_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","13","Josua tagun to tana voinyvoiny an fo tsoiny faakor an vainy puaan nai isen iny taainy faafis pis to faarei tsun te taan famuan firi tan vamuan nan nainy, u tatagaa ot te mumua ai vou rari, a ina fits a tsoiny faakor puuf ror tan nai rarin tsufing, ai vou rari, ari bus tsoiny faakor te govet iny a Gen te kaa minon tsuen man an Faun ten Gov, ai vou ovei u mes vainy tatagaa ot. Tan nainy to aya ari faavot puuf a fo tsufing tsuar. ");
INSERT INTO sps_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ai tan fafuan nan nainy ari isen iny taainy faafis pis to na ngats fan, ana ri kat to ser tabin fatabin pis to tana fo tovaar tsuar. Aunom ovein nainy kat arin senvir kat. ");
INSERT INTO sps_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Tan fafits nan nainy ri tagun to tan patsun na nainy ri kat to ser nai fits iny taainy faafis to na ngats fan, ari te taan faarei te taan famuan firi san to aya tsun isen nainy te fits iny taainy faafis rori na ngats fan. ");
INSERT INTO sps_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Tan nainy te fafits iny taainy faafis bus ari an tsoiny faakor puuf ton tsufing tsuar, Josua tsue of bus raton vainy tsuan ma kuu ri, ana ayei tsue to tsuri, “A Tsunaun te faan bus mami na ngats fan iny Jeriko! ");
INSERT INTO sps_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","A ngats fan fiisen mena mamatsiny kaa faavot kat firing romi, te kat faarei non u fifan tsumi ten Gov. San e Reheb to na moun to te natiny faan vavis iny non a puan tan tsoiny, ayei fiisen ramen fo nuatsin ya to te natiny kaa fiisen miror ya numaa tsuan, ari tsun to ari mi gim on rom ma atsun irari, tana sa e Reheb te fatakop ir a ina fuan na tsoiny toboo tsura tan nainy te nai toboo kabuts ari na Jeriko. ");
INSERT INTO sps_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Ami kan gim on rom ma nom ta isen ta ka tana fo mamatsiny ka te nai kat firing nats romi; sei ta mes te nom non ta ka tana foka to, e Gov te faan iny minon a iring tsian tana pan te tovaar rora na taa Isrel. ");
INSERT INTO sps_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Fokinai ka te kat ari tan silva ge tan gol, gen brons ge tan aiyan fakei fuainy of rora na Tsunaun. Foka to ari te nai fakei nats rora tana Guv tana Tsunaun.” ");
INSERT INTO sps_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Kat to an tsoiny faakor puuf to na fo tsufing. Tan nainy te nongoiny vainy a tsufing, ri kat to ser kuu faavot to, ana soopip tarop faavot bus enato. Kat to an vainy puaan pas nato na painy tet ri sof fatoobing nato koman na ngats fan ri nom to na fokinai ka. ");
INSERT INTO sps_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Ana ri nom ton fo kirat iny fitatsun tsuar ri atsun famat rato na fokinai guei tsoiny an moun vurots an koviou, tobo'an an tsokanei faavot, ri atsun famat kan iratoon foo bulumakau, an siipsiip, an fo dongki tsuri. ");
INSERT INTO sps_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Josua kat to sa tsue of to na ina fuan na tsoiny totoboo sa tsue, “Kuar yam tana numaa ten Reheb mi te nom mi ya fiisen ramen nuatsin ya to te kaakaa fiisen miror ya numaa tsuan, faarei te tsue of fi mi ya.” ");
INSERT INTO sps_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Ana ina fuan na tsoiny totoboo naa to ser nom mito Reheb fiisen mena fo nuatsin ya to te kaa fiisen mi ya numaa. Kat to ri ras ra natuari na fokinai fiisen ramirin vainy gog tsuri, ri na to tana te totovaar ror a taa Isrel, ser gim to ma sab ta iring. ");
INSERT INTO sps_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Kat to ana taa Isrel faakor ton guaf sa kuruiny faavots to na ngats fan, a sikia ta ka ma tsutsun san a fokinai kaa faavot gotsiny rato putaa, fiisen ramen fokinai ka tana fo numaa, san a foka te kat ari tan gol, an silva, an brons, an tan aiyan ri te nom ya ser fasof ya tana guuv tana Tsunaun. ");
INSERT INTO sps_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","San e Josua te gima atsuiny famat e Reheb a moun to te natiny faan vavis iny non a puan tan tsoiny, an fo nuatsin ya kan to ser gima mat. E Josua te kat a ka to tana sa e Reheb te fatakop ir a ina fuan na tsoiny totoboo tsuri na taa Isrel to te faan iny nats ari ma nai toboo kabuts ari Jeriko. (Fuainy tsubnaiin ten Reheb kai ror Isrel roman.) ");
INSERT INTO sps_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Voun a foka to Josua kat to ya faan iny ton tsuen parits tsuri na taa Isrel sa tsue: “Sikia on ta isen ta mes fapoopoan namami tanaf iny fatsutsun fatabiny non na ngats fan to aya nan. Mes te fatsutsun non ya, a Tsunaun fauf nats non a iring tsian tsunia. Sei taa mes te tanik non na poon, a vamuan nan na guei tsuan te nai kajia enanats non; ai sei taa mes te kat non matainy sobaa nan na ngats fan, a fafakap nan guei tsuan te nai kajia enanats non.” ");
INSERT INTO sps_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","A Tsunaun te kaa fiisen me Josua to sana fo mamatsiny pan koman na vun to aya natiny to na karap nan ne Josua. ");
INSERT INTO sps_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","I tovein fuainy tsuvun e Jisas Krais, e Jisas Krais a tsubnaain ten Devit, ai Devit a tsubnaain ten Abraham. ");
INSERT INTO sps_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ayei na taman e Aisak; Aisak ayei na taman e Jekop; Jekop ayei na taman e Juda an fuainy famuinyasiny tsunia; ");
INSERT INTO sps_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ayei na taman e Peres me Sira, tsinar rari Temar; Peres ayei na taman e Esron; Esron ayei na taman e Ram; ");
INSERT INTO sps_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ayei na taman e Aminadap; Aminadap ayei na taman e Nason; Nason ayei na taman e Salmon; ");
INSERT INTO sps_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ayei na taman e Boas, tsinan ya Reheb; Boas ayei na taman e Obet, tsinan ya Rut; Obet ayei na taman e Jesi; ");
INSERT INTO sps_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ayei na taman e Devit a Aatouf. Devit ayei na taman e Solomon tsinan ya Betsiba e natsun Uraia faamuan; ");
INSERT INTO sps_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ayei na taman e Riaboam; Riaboam ayei na taman e Abija; Abija ayei na taman e Eisa; ");
INSERT INTO sps_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Eisa ayei na taman e Jeosafat; Jeosafat ayei na taman e Joram; Joram ayei na taman e Usaia; ");
INSERT INTO sps_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia ayei na taman e Jotam; Jotam ayei na taman e Eihes; Eihes ayei na taman e Hesekaia; ");
INSERT INTO sps_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia ayei na taman e Manase; Manase ayei na taman e Amon; Amon ayei na taman e Josaia; ");
INSERT INTO sps_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ayei na taman e Jekonaia an fuainy famuinyasiny tsunia to tan nainy te nom finy ra naa ri rin vainy Isrel ser naa fi naa Babilon ri faarei ton vainy gog. ");
INSERT INTO sps_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Te faarei arin vainy gog unya Babilon ai Jekonaia faarei to taman Silatiel. Silatiel ayei na taman e Serababel; ");
INSERT INTO sps_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel ayei na taman e Abuid; Abuid ayei na taman e Eliakim; Eliakim ayei na taman e Eso; ");
INSERT INTO sps_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso ayei na taman e Sedok; Sedok ayei na taman e Ekim; Ekim ayei na taman e Eliud; ");
INSERT INTO sps_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ayei na taman e Eliasa; Eliasa ayei na taman e Matan; Matan ayei na taman e Jekop; ");
INSERT INTO sps_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ayei na taman e Josep, ai Josep faarei to natsioiny Meri, e tsinan Jisas te koo ri Krais, a Mes to te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy. ");
INSERT INTO sps_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","To sa faarei men safunuu ana fats a aatai tanik me ten Abraham sa nainy onot me ten Devit, an safunuu ana fats a aatai to tanik me ten Devit sa nainy ruak me tan nainy te naa fi naa ri Babilon sa ri faarein vainy gog, ana safunuu ana fats a aatai to ito te faarei fi rin tsoiny gog Babilon sai nainy ruak me te agiir fi Jisas. ");
INSERT INTO sps_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","To aya nan a sanaan te agiir fi me Jisas Krais. Tsinan ya Meri to te us of ari Josep, sai tabuiny fanging rori, Meri nat fi nei ayei nai faagiir non a guei tana parits tan Aaven Taabos. ");
INSERT INTO sps_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","E Josep a tsoiny fanging ten Meri na rof fiisok ana ya pon to ma gargar faamo tsuiny naa ya, ayei tsugainy ma farejiaf e Meri matar a vainy faavot. ");
INSERT INTO sps_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Te fakats farokot ya na ka to, ana morena tana Tsunaun ruak towa tan taraa sa tsue, “Josep tsubnaain ten Devit, oraav vaare ma fifanging minyi Meri a faarei to natsum, tana saa, to tan Aaven Taabos, ayei kuraa iny non ya. ");
INSERT INTO sps_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ayei nai faagiir non na guei tsoiny ana nyi te nai koo Ya Jisas, tana saa, Ayei nai saup fatabin rarori na vainy Tsuan, tana fasaraa tana fo aveto tsuri.” ");
INSERT INTO sps_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Fo mamatsiny ka to te ruak an vegiau tana Tsunaun ruak iny man ovei enato nguen na isen na kuigin muan, ");
INSERT INTO sps_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“A moun a 'aun to te nai kuraa nats non ana ya te faagiir a guei tsoiny ana ri te koo ya Imanuel” (kifon vegiau to Imanuel, “Gov kaa fiisen ramirora.”) ");
INSERT INTO sps_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Te tagun bus e Josep, ayei kat to na ka te tsue of ya na morena tana Tsunaun to sana ayei fanging bus e Meri. ");
INSERT INTO sps_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sana Ayei gima fiinot fiisen mi ya onot te faagiir finy e Meri na Guei Tsoiny. Ai Josep koo Towa Jisas. ");
INSERT INTO sps_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","E Meri faagiir e Jisas tana ngats fan iny Betlehem tana gum fan iny Judia, tan nainy te Aatouf e Herot. Te agiir fakap bus e Jisas rin mes vainy nat te natiny toobo raror kootsits, poo fi me tana pan te roruak minon a nuaf ser naa fi naa tana ngats fan tsian iny Jerusalem, ");
INSERT INTO sps_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ser rangat, “Fei te agiir a guei aatouf tana taa Jiu ei, tana saa, amam te tagei a kootsits tsunia te ruak ising me tana pan te roruak minon na nuaf, ana mam a tou faatouf Ya.” ");
INSERT INTO sps_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te nongoiny e Herot a Aatouf u vegiau to ana ya oraav fakap enato, ana fokinai faavot kan tana ngats fan tsian iny Jerusalem. ");
INSERT INTO sps_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ya fikoo vaaguam raton fokinai tsunaun tan tsoiny faakor tana taa Jiu ana rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses sa rangat rari, “Fei te agiir non a Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy ei?” ");
INSERT INTO sps_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ri biny towa, “Tana ngats fan iny Betlehem tana gum fan iny Judia, tana saa, ito te kirkir fi na kuigin muan sa tsue na ka, ");
INSERT INTO sps_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Amin gueiny Betlehem tana gum fan iny Judia ami kaa mirom asangan tsian tana tsunaun a karap iny Judia, tana saa, a isen a tsunaun na karap nai poo fi minon Betlehem, Ya te tagaa ot iny vavainy Tsonyo iny Isrel.’” ");
INSERT INTO sps_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","To sen Herot fikoo famun ir vainy nat tana pan te roruak minon a nuaf sa rangat rari tan nainy te ruak fatoobing a kootsits to. ");
INSERT INTO sps_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kat to, ya jiats ratuari Betlehem fiisen men vegiau to: “Kuar yam am tsikoo faarof to na guei, te sab finy romi Ya, tsue fanat of vanyo yam, ma nai fafaatouf patsu nyo Ya.” ");
INSERT INTO sps_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Te nongoiny fakap bus arin vegiau tana aatouf to, ser naa buser, te naa ri ser tagei pis a kootsits, ito na kootsits te tagei faamuainy ari tana pan te roruak minon a nuaf mumumua ra naa ri sa onot tana pan te kaa non a guei. ");
INSERT INTO sps_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Te tagei ari na kootsits an mamagat via tsitapuu enato tsuri. ");
INSERT INTO sps_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ri sof gagon numaa, ser tagei na guei fiisen me tsinan e Meri, ri fatukun ser faatouf Ya fiisen me na fo fifaan, gol, ana viir jiaf iny faakor tauf tsuraf, ana tapui kan na tauf tsuraf. ");
INSERT INTO sps_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gov tsue fanat of rari tan taraa, ma tabin vaare naa ri ten Herot, to ser tabin fatabin fan tsuar ising naa tana mes a sanaan kanen. ");
INSERT INTO sps_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Te naa fakap bus nan vainy nat, ana morena tana Tsunaun ruak to Josep tan taraa sa tsue na ka, “Tsun, nom ir muiny tsinan tsuam mi te bus fi naa tana gum fan iny Ijip. Kaa yam na aya onot non te tsue of marom yam, tana saa Herot nai sainy non a guei ma atsuiny ya Ya.” ");
INSERT INTO sps_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","To sen Josep tsun, sa nom ir muiny tsinan tsuan tana voiny ser naa fi er tana gum fan iny Ijip. ");
INSERT INTO sps_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","To ser kaa na aya Ijip onot te mat fi Herot, sa faonots vegiau tana Tsunaun te pokei Ya nguen a isen a kuigin muan te kat fi non to, “Guei Tsoiny Tsonyo te kaa Ijip, sa nyo fikoo mi Ya ana Ya naa mito.” Tan nainy te naus osing mi Ya na gum fan iny Ijip, an vegiau ruak iny man ovei nato. ");
INSERT INTO sps_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Te nat fakap bus iny e Herot fo vainy nat tana pan te roruak minon a nuaf te gima vovou iny vegiau tsunia, ana ya peits fiisok tsun en nato. Ya tsue faparits of ratuarin vainy puaan tsuan ma atsuiny famat ari rin guei tsoiny faavot iny Betlehem, ai tana fo mes a fo fan siruu to te onots ror a fuan a ingainy gen meran, tana saa u vainy nat te fafaatai yan nainy te ruak fi na kootsits to. ");
INSERT INTO sps_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tan kat to aya sa faonots a ka te tsue iny e Jeremaia na kuigin muan te kat fi non to: ");
INSERT INTO sps_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sen kuu tsian poo ising me tana ngats fan iny Rama, u kuu iny reesik, u tangis. Muiny Retsel tangis non fuainy guei tsuan; ana vainy gim ror ma onot ma famaangoiny ya, tana saa, fuainy guei tsunia mat fakap er.” Tan nainy te atsuiny famat ir vainy puaan fuainy guei, an vegiau ruak iny man ovei nato. ");
INSERT INTO sps_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Te mat fakap bus e Herot, ana morena tana Tsunaun ruak to Josep tan taraa tana gum fan iny Ijip. ");
INSERT INTO sps_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ana ya tsue to, “Tsun, nom ir muiny tsinan tsuam mi te tabin fatabin tana gum fan iny Isrel. A mes te pon ma atsuiny famat a Guei te maten.” ");
INSERT INTO sps_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sen Josep nom ir muiny tsinan tsuan ser tabin fatabin er tana gum fan iny Isrel. ");
INSERT INTO sps_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josep nongoiny e Akelas te nom gumgum ten taman e Herot faarei ya na aatouf tana gum fan iny Judia, ya oraav nato ma kaa unya aya. San tan taraa, Gov tsue fanat of bus e Josep ma naa vaare fi naa ya tana gum fan iny Judia, ayei ma naa fi en naanaa tana gum fan iny Galili. ");
INSERT INTO sps_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tan kat to aya ya naa to sa kaa en tana ngats fan iny Nasaret. Ka to te ruak, to san vegiau tan fo kuigin ruak iny man ovei nato, “Ayei nai koo rori na Guei iny Nasaret.” ");
INSERT INTO sps_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tan nainy nato aya Jon a Tsoiny Fapeenan naa me sa tanik iny favaanan koman a pan a uur ana nang iny nuaf tana gum fan iny Judia, ");
INSERT INTO sps_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ya tsue to tana vainy, “Faonot yam, mi reesik to am takopis osing to na fo aveto tsuam, ana mi te tap naa ten Gov, tana saa a Waan iny Gormirmir te sisiruu ename.” ");
INSERT INTO sps_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","E Jon ayei na mes te pokei iny e Aisaia na kuigin muan sa tsue na ka, “Ai isen te vegiau fabaasuan me koman a pan a uur, ‘Kakoun onots of yam a Tsunaun a aavem, mi te vatsvats of Yan kat tsuam ma faarei ya na sanaan iny naa me Tsunia.’” ");
INSERT INTO sps_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon popous iny funuu nana kamel faarei non pous tan kuigin, ana ya pous kan iny ton vakiri pempem nana kamel faarei yam pous tsunia. Ya ainy ton kookai an sisingif. ");
INSERT INTO sps_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vainy naa me tsunia poo fi me tana ngats fan tsian iny Jerusalem ai tana fo mes a fo ngats fan tana gum fan iny Judia ai tan fo mamatsiny fan tana aurom iny Jodan. ");
INSERT INTO sps_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ri pokein na fo aveto tsuar sen Jon fapeenainy rari tana aurom iny Jodan. ");
INSERT INTO sps_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","An fuainy Farasi (a gum tana taa Jiu to te vovovou faarof ror Faun te kirkir iny e Moses fiisen men kat tan tsuvurari) an fuainy Sadusi (a gum tana taa Jiu to te natiny tsue ror a sikia ta tou tsun fatabin tana mat), naa me ten Jon a Tsoiny Fapeenan. Te tagei ari Jon ri naa faavot mito tsunia a tou fapeenan sana ri tabuiny ma pokein a fo aveto tsuar, ya tsue to tsuri, “Amin guei tan koraa! Tana tou peenan ami pon fi rom nei mi onot rom ma fataanis osing koma seeve ten Gov to te naa naa minon? ");
INSERT INTO sps_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kat yam kat to te onot iny faatok maromi mi takopis osing bus fo aveto tsuam, ana nyo te see fapeepeenainy mami. ");
INSERT INTO sps_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Am tanik iny tsue fi vaare to nei fapoopoan namami, ‘Gov gim non ma fasaraa mamam, tana saa Abraham ayei na tsuvumamam.’ Nyo tsue of maromi Gov onot non ma nom marats to, Ya te kopis rari er faarei miton tsubnaainy ten Abraham! ");
INSERT INTO sps_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ami faarei rom nau, ana fo nau gim ror ma fua tan tu fua tu rof nai rop ravaa ror er faakor ravaa to tan guaf. Gov kakoun en tan kat, kat to tsumi. ");
INSERT INTO sps_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nyo peenainy maromi tana aurom tsun faatok maromi tsumi te reesik sam takopis osing fo aveto tsumi ana mi te tap naa ten Gov; sana Mes to te naa minon vou vanyo nai fapeenainy maromi tan Aaven Taabos an guaf. Ayei karap fafisfis varonyo; nyo gima onot faarof iny govets su Tsunia. ");
INSERT INTO sps_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ayei faarei non a taman tan tanun wit nom iny non a fok niman ka iny kat ravainy nungan nan wit ana ayei te nai guam wit ya te fakei naa ya tana numaa iny fatamaar ana ya te nom nungan ya te nai ravainy ya tan guaf to te gim non ma natiny mote.” ");
INSERT INTO sps_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tan nainy to aya Jisas naus osing me na gum fan iny Galili sa naa fi naa tana aurom iny Jodan a tou peenan ten Jon. ");
INSERT INTO sps_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sen Jon baainy sa tsue na ka, “Nyo onot rou ma peenan Tsumanyi, sana Nyi naa fasuar pis emame tsonyo?” ");
INSERT INTO sps_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisas biny towa, “Tanyiny korei, tan kat to ayei ara nai kat ror fo mamatsiny ka te koman fi non e Gov.” Sen Jon vovou iny vegiau Tsunia. ");
INSERT INTO sps_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Te fapeenan fakap bus e Jisas, sa ruak osing me na aurom. Sen tsun ana korosuu tapue to, ana Ya tagei ton Aaven Taabos ten Gov of mito Tsunia faarei na kurume. ");
INSERT INTO sps_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","An vegiau poo mito Gormirmir, “Tovei na Guei Tsoiny Tsonyo, te kaa non koman Tsonyo, Nyo koma rof marom Anyi.” ");
INSERT INTO sps_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","An Aaven Taabos mei naa to Jisas tana pan a uur ana nang iny nuaf ma amus Ya na Vinasaar. ");
INSERT INTO sps_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ai Jisas gim to ma ainy onots fats safunuun a nuaf an fats safunuun a voiny ana Ayei ves to. ");
INSERT INTO sps_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ana tsoiny fifiamus naa mito Tsunia sa tsue, “Anyi na Guei Tsoiny ten Gov, tsue of ir fats to ma ruak iny koinykoiny mi ri.” ");
INSERT INTO sps_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisas biny towa, “Te kirkir en tan Vegiau Ten Gov, ‘Mes te gim non ma toto ising tan koinykoiny tsun, san tan fo mamatsiny vegiau te poo minon nguen e Gov.’” ");
INSERT INTO sps_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ai Vinasaar mei fi naa Towa tana ngats fan a taabos, Jerusalem sa fatsutsuiny Ya tana pan a nai jias fiisok tana saape, ");
INSERT INTO sps_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ya tsue to Tsunia, “Anyi na Guei Tsoiny ten Gov, tsiak fi naa putaa, tana saa te kirkir en tan Vegiau Ten Gov, ‘Gov nai tsue of non morena Tsuan ma koup Manyi ri. Ana, Ri kan nai nom tap marom Anyi nimar ma tageev on vaare na moum Manyi tan ta fats.’” ");
INSERT INTO sps_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas biny towa, “San Vegiau Ten Gov tsue kainy a ka, ‘Nyi ma tanaf vaare na Tsunaun a Gov tsuam.’” ");
INSERT INTO sps_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ai Vinasaar mei pis naa to Jisas tana tobeer a nai tsig ya faatok Towa na fo mamatsiny waan nana monaagits to, an fo mamatsiny siinaiv tsuri. ");
INSERT INTO sps_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Fo mamatsiny ka to nyo nai faan marom Anyi ya,” tsue fi ya, “to te fatukun fi rom Anyi, Nyi te tsunguruu iny faatouf vanyo.” ");
INSERT INTO sps_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisas biny towa, “Feis osing you, Satan, tana saa te kirkir en tan Vegiau Ten Gov te tsue na ka, ‘Faatouf a Tsunaun a Gov tsuam ana nyi te vovou tsun iny mangiir Tsunia!’” ");
INSERT INTO sps_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ai Vinasaar naus osing Towa; an morena ten Gov naa mito Tsunia ser faakouts Ya. ");
INSERT INTO sps_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Te nongoiny e Jisas te fakei finy ari Jon tana numaa iny kotskots, Ya naus osing to na gum fan iny Judia, Ayei naa fi enato tana gum fan iny Galili. ");
INSERT INTO sps_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ya naus osing to na ngats fan iny Nasaret sa nai kaa en tana ngats fan iny Kapeniam. Kapeniam kaa non panan a naaman tana pan tere Sebulan me Naptali. ");
INSERT INTO sps_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","To san sen vegiau te kat e Gov nguen e Aisaia na kuigin muan, tsue na ka, ");
INSERT INTO sps_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Pan ten Sebulan, ana pan ten Naptali, tana pan te matoong fi naa non tana naaman tan mes panaainy aurom iny Jodan, Galili, a pan tan vainy sikia ma taa Jiu! ");
INSERT INTO sps_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Vainy uurup te tagei bus a arasan. Ai tsuri kan uurup fiisok tana aave rari, Gov faatok rari na arasan.” Tan nainy te kaakaa Jisas Kapeniam, an vegiau to ruak iny man ovei nato. ");
INSERT INTO sps_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tan nainy to aya Jisas tanik iny favaanan, sa tsue, “Reesik yam, am takopis osing to na fo aveto tsumi ana mi te tap naa ten Gov, tana saa a Waan iny Gormirmir te sisiruu ename.” ");
INSERT INTO sps_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas taan ereer naanaa tana naaman iny Galili, Ya tagei ton ina fuan mumuinyasiny ere Saimon to te koo ri Pita ai famuinyasiny tsuan e Anduru, te vavagaar naaman, tana saa arin tsoiny nawaan. ");
INSERT INTO sps_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas tsue to tsuri, “Taami yam, am vovou Vatuanyo, ana Nyo te faatsuts mamin kat iny nonom mes faarei to te saasauf jian fi mi.” ");
INSERT INTO sps_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sen tsun, ri fakei ravainy ton muav tsuar ser vovou iny naa Ya. ");
INSERT INTO sps_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ya naa pis naa to sa sab ir mes mumuinyasiny ina fuan Jemis me Jon, u guei tsoiny ten Sebedi. Ri kaakaa er koman puak fiisen me tamarari Sebedi um'um muav tsuar. Jisas fikoo ratuari. ");
INSERT INTO sps_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sen tsun ri naus osing ton puak tsuar fiisen me tamarari, ser vovou naa Jisas. ");
INSERT INTO sps_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas naa vavis to tan fo mamatsiny pan tana gum fan iny Galili. Ya faatsuts rato na vainy koman a fo numaa iny fafaatouf tana taa Jiu, favaanan iny Vurungan Rof tana Waan e Gov, ana Ya tsipaar kan rato na vainy fiisen men fo viir faadis an tameruts. ");
INSERT INTO sps_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","U vaanan nane Jisas saats vavis to na gum fan iny Siria, to sana vainy mei men vainy fiisen men fo viir faadis an kamits, an vainy masarau te tutuei rari, an vainy pua ra totoroor an vainy pengong, sen Jisas tsipaar rari. ");
INSERT INTO sps_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ana fokinai vainy vovou naa Towa, rin tagin tana fo ngats fan tana gum fan iny Galili, fiisen ramen tagin tana fo ngats fan tana pan iny Dekapolis, an tagin tana ngats fan tsian iny Jerusalem, ai tana fo mes a fo fan kaner tana gum fan iny Judia, ai to kan tana fo mes a fo fan kaner tan mes panaan nana aurom iny Jodan vovovou naa Towa. ");
INSERT INTO sps_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas tagei ir tagin Ya paas fi enato tana painy tet Ya vaagum to. Matisian Tsunia bau faafis Towa, ");
INSERT INTO sps_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ana Ya tanik iny faatsuts ratuari: ");
INSERT INTO sps_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Paparaa tsurin vainy te inainy fanatnat iny rora tsivor te aaruts ror tana aaver; a Waan iny Gormirmir a ka tsuri! ");
INSERT INTO sps_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Paparaa tsurin vainy te susuiny matan ror: Gov nai famaangoiny rarori! ");
INSERT INTO sps_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Paparaa tsurin vainy te fauf ror a tsivor; ri nai nom rora tafan tsuar te kakouiny onots e Gov! ");
INSERT INTO sps_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Paparaa tsurin vainy te mauts fiisok ror kat tavaron ten Gov; Gov nai faonots non koman tsuri. ");
INSERT INTO sps_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Paparaa tsurin vainy te tagtag rora mesmes; Gov nai tagtag kan rarori! ");
INSERT INTO sps_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Paparaa tsurin vainy te fakats fapaparits tsuiny ror e Gov; ri nai kaa fiisen miror Ya! ");
INSERT INTO sps_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Paparaa tsurin vainy bibinun fiisen miror a aaverof fapoopoan nar vainy, Gov nai koo rarorin guei Tsuan! ");
INSERT INTO sps_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Paparaa tsurin vainy te sab ror a patang ana kamits tan kat tavaron tana saa ri kat rora foka te komainy non e Gov; a Waan iny Gormirmir a ka tsuri! ");
INSERT INTO sps_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Paparaa tsumin vainy to te nom rom fo tsue fifiiring, ai to te sab romi na fo patang ana kamits tana mes a vainy, ai to kan te tsue kabuts fi maromi na mesapan tana saa amin vainy Tsonyo. ");
INSERT INTO sps_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ami ma mamagat am paparaa fatsian to, tana saa a tafan tsian tsumi te kaa non Gormirmir. Ayei kan a fo kat te sab romi na fo patang ana kamits to te kat fi ri tana fo kuigin muan.” ");
INSERT INTO sps_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ami faarei rom teis tan puputaa. Sai te kajiaa non teteisian nan teis to, a sikia pis ta sanaan iny kat fateteisian fatabiny ya. Te iring babainy enanon, onot tsun non ma ravaa en ana vainy ma taan patsun ya. ");
INSERT INTO sps_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ami faarei rom kurun tana monaagits to. A fan te kaa non tan tet gim non ma takop. ");
INSERT INTO sps_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sikia ta isen te fakuruiny non kurun ya te fakei ya fain kobuu; a sikia, ayei fakei non ya jias tana taran, ma fa'arasainy ya na vainy gagon numaa. ");
INSERT INTO sps_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tan kat to aya u kurun tsuam ma fa'arasan matar ra vainy faavot to, ma nai tagei arin kat rof tsuam, ri te vamarits e Tamamami te kaa non Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Pon fi vaare yam nei Nyo naa me ma nom ravainy Anyon Faun te kirkir iny e Moses ana fo fifaatsuts tan fuainy kuigin. A sikia. Nyo gima tou nom ravaa irari, sana Nyo naa me ma faruak Anyo na man nan fifaatsuts tsuri. ");
INSERT INTO sps_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nyo tsue faman of maromi, te nai kajiaa non a korosuu an puputaa, sana fo kirkir, ge ta isen ta pan nan Faun te gim non ma kajiaa on nats. U Faun kaa non onot non a fo mamatsiny ka nar Faun te ruak non. ");
INSERT INTO sps_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sai te kat fi non nei a mes te gim non ma vovou iny ta isen ta pan tan karan nan Faun tovei ana ya te faatsuts a mesapan tan senviir kat, asangan ya kan nai kakaii enanon tana Waan iny Gormirmir. Sana mes te vovou iny non Faun ana ya te faatsuts a mesapan tan senviir kat, nai nom non asangan karap tana Waan iny Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tsurin tsoiny fifaatsuts tan Faun an fo Farasi tsue fi ror nei, ‘Amam tavaron em matan e Gov tana saa amam vovovou faarof iny rom fo Faun te kirkir iny e Moses,’ sana Nyo tsue of maromi, To te gim fi romi ma tavaron men kat tsumi ya te gima tavaron fafisfis pis iny men fo kat tsurin tsoiny fifaatsuts tan Faun an fo Farasi to ari, ami kan gim rom ma nai sof naa tana Waan iny Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ami nongoiny vegiau nan faun te nom fuainy tsuvurara muan, ‘Bainy fitokon yam; e sei te fitokon non ee, ayei ma naa tan vaatsuk.’ ");
INSERT INTO sps_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sai tovei Nyo tsue of maromi; e sei te fapeepeits fiisen minon a mesmes tsuan ee ma naa fi en tan vaatsuk; ai sei te fijiar fifiiring non a mesmes tsuan ee ma naa fi en tan tsoiny vaatsuk; ai sei te koo non a mesmes tsuan a Vinasaar ee ma naa fi en tan guaf iny Hel. ");
INSERT INTO sps_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Te komainy kat rom anyi na faakor faarei non a fifaan tsumanyi ten Gov tan fatsung fafaatouf na aya, ana nyi te fakats a iring te kat anyi tana mesmes, ");
INSERT INTO sps_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","fakei tsom a fo fifaan tsuam matan fatsung fafaatouf ana nyi te veesau tsom fi naa tsunia nyi faroruak fiisen mi towa; nyi te see nai fafaan iny a fo fifaan tsuam ten Gov. ");
INSERT INTO sps_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Te komainy fakaa marom anyi ta mes tan vaatsuk, vivaatau fiisen me te kaa fi minon ya tu nainy to te mataanis fi minon yan nainy tan vaatsuk; kat non sana mes to ayei fakaa manyi tana tsoiny vaatsuk, ana ayei te faan ma naa nyi nimar kokokof, ana ri te fakaa manyi tana numaa iny kotskots. ");
INSERT INTO sps_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nyo tsue faman of marom anyi te gim fi rom anyi; ma biny a fo tavan tsuam, nyi gim rom ma naus osing a numaa iny kotskots.” ");
INSERT INTO sps_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ami nongoiny a mes a faun te tsue iny ari muan, ‘Bainy tsikoor yam.’ ");
INSERT INTO sps_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sai tovei nyo tsue of maromi; sei na mes te tagei non a moun ya te komainy tsuiny ya ee, ngats bus a faun tan kat iny tsikoor a moun to aya tana aaven ya. ");
INSERT INTO sps_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tan kat to aya te ras fi marom anyi na matam tan panainy matou tan aveto fas ravainy, nyi te ravainy ya. Te rof fiisok non tan pets a isen ta pan puam tan ravainy a puam faavot unya Hel. ");
INSERT INTO sps_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te ras fi marom nimainy matou tsuam tan aveto tek kobus nyi te ravainy ya. Te rof fiisok non tan pets ta isen ta pan puam tan ravainy a puam faavot unya Hel.” ");
INSERT INTO sps_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ana mes a faun te tsue kainy a ka, ‘Sei na mes te ots non fanging ten natsun ee ma kirkir of e natsun noun iny ots fanging.’ ");
INSERT INTO sps_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sai tovei Nyo tsue of maromi: to te kat iny ots fanging fi non a tsoiny e natsun, ai natsun ya te gima tsikoor, a mes to ayei kat e natsun sa tsikoor en, ito te fanging non a moun to na mes a tsoiny. Ai sei na mes te fanging non a moun to ayei, natsioiny ya te ots fanging fiisen mi ya, ayei kan te kat, kat iny tsikoor.” ");
INSERT INTO sps_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mi te nongoiny a mes a faun kanem te tsue fi ri tan vainy muan, ‘Ngats vaaren tsuen man, sana mi ma kat tsue man non jias te kat romi matan na Tsunaun.’ ");
INSERT INTO sps_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sai tovei Nyo tsue of maromi: kat vaare yam tsue man non jias te kat romin tsuen man; am tsue fi vaare to nei man ovei tsun non jias Gormirmir, tana saa Gormirmir a fan te kaa non tagan tsigtsig ten Gov; ");
INSERT INTO sps_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ge inei kan peto tan puputaa, tana saa pan iny tututua Tsunia Ya te favusuainy a moun; ge Jerusalem, tana saa a Jerusalem a ngats fan tsian tana aatouf a tsigtsig. ");
INSERT INTO sps_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kat kainy vaare yam tsuen man mi te tsue, man ovei non patsuu mamam, tana saa mi gim rom ma kat oiny ta isen ta painy funuu ma gosee ya ge ma bong ya. ");
INSERT INTO sps_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mi ma faonot tsuiny tsuen man tsuam, tan ‘Eye’ man non ge ‘Sikia’, an saf tsue pis ei naa te kat iny kat romi tan kat tsuen parits, poo minon tana Vinasaar.” ");
INSERT INTO sps_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ami te nongoiny a mes a faun kanen te tsue fi nei, ‘Te fas finy non ta mes a mata manyi, fas kainy yam a matan ya. Te tsuts boree non ta isen ta mes ta ngiis, tsuts boree kainy yam a ngiisin ya’. ");
INSERT INTO sps_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sai tovei Nyo tsue of maromi, Biny vaare yam a iring te kat ya tsumi. Te sapan maromi ta mes tan panainy matou asase mami, faan kan iny panainy keeruk asase mami ma sapainy kainy ya. ");
INSERT INTO sps_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te mei fi maromi ta mes tan vaatsuk ya te nom osing manyin vau iny jiarasan tsuam, tanyiny ma nom kainy yan vau iny gagon tsuam. ");
INSERT INTO sps_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ai te komainy maromi ta mes ma taan fiisen mi naa ya na isen a kilomita, taan fafis yam a isen ma nainy onots ya na fuan a kilomita. ");
INSERT INTO sps_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te sing fi non ta mes ta ka tsumi, faan iny tsunia, te komainy tavainy fi non ta mes ta ka tsumi; ma vabinun iny ya, tanyiny ma nom ya.” ");
INSERT INTO sps_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ami te nongoiny a mes a faun kanen te tsue fi nei, ‘Mangiir yam fuainy vaatau tsumi, mi te tsugei ir vainy te koma iring maromi’. ");
INSERT INTO sps_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sai tovei Anyo tsue of maromi, mangiir yam vainy te koma iring maromi, am faakats to ten Gov ma kat faarof rari Ya te kat fijior maromi ri, ");
INSERT INTO sps_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tan kat to aya ami kat faarei rom guei ten Tamamami te kaa non Gormirmir. Tsunia te natiny kat non a nuaf ma nang ya tan vainy rof an vainy pisiin kan, ana Ya te faan kan iny a ruat tan vainy te natiny kat ror kat rof ai tsuri kan vainy te natiny kat ror kat a fo pisiin. ");
INSERT INTO sps_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kat fei ma nom ami na tafan a rof tsumi ten Gov to te mangiir tsuiny finy romin fuainy vainy te mangiir maromi ei? Tsurin vainy nonom takis te natiny kat kainy ror kat to! ");
INSERT INTO sps_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te vevegiau tsun romi tan vaatau tsumi, mi sikia ma kat fuainy tana mesapan. Tsurin vainy vavaajets te kat kainy ror kat to! ");
INSERT INTO sps_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ami ma kaa fatavaron me, faarei tsuiny non e Tamamami te kaa non Gormirmir, a tavaron.” ");
INSERT INTO sps_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tamomots yam, kat faatok vaare mi yam kat rof matar a fokinai ma tagaa ri, er fapaas to na asanga mami. Te kat romin kat to mata rari, mi gim rom ma nom a tafan a rof tsumi ten Tamamami te kaa non Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Te faan iny romi na foka tsumi tan vainy aaruts, kat faatok iny vaare yam matar a fokinai to te katkat fi ror vainy kat mapam tan numaa iny fafaatouf tana taa Jiu ai unya kan sanaan. Ri kat fi ror to ma variri rari na vainy. Fakats faarof a ka to! Ri kaa bus me na tafan a rof tsuar. ");
INSERT INTO sps_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sai te komainy faakouts romin vainy aaruts, kat yam a sanaan iny faan ka, ma nat vaare ta mes an fuainy vaatau tsumi kan siruu, ");
INSERT INTO sps_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kat yam ma faarei tsuiny ya na fifaan tsumi na takop. Ai Tamamami te tagei kat rof tsumin takop, te nai faan mamimi na tafan a rof tsuam.” ");
INSERT INTO sps_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Te faakats romi, kat fi vaare yam to te katkat fi ror vainy kat mapam! Ri komainy fiisok ror ma tsutsun, er faakats to koman a numaa iny fafaatouf tana taa Jiu, ai tana fo tatangin sanaan ma tagei rari na fokinai. Fakats faarof a ka to! Ri kaa bus me na tafan a rof tsuar. ");
INSERT INTO sps_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Te komainy faakats romi, kuar yam gagon, am siisiots ton pingping, mi te faakats ten Tamamami te gim romi ma tagei. Ai Tamamami te tagei a foka te katkat romi tana uur, Ya te tafan mami. ");
INSERT INTO sps_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Koman faakats tsumi kat vaare yam a fo mamatsiny vegiau sikia ta kifon ya, to te katkat fi ror vainy kat mapam, tsuri te pon fi ror nei Gov nongoiny rarori tan faakats tsurin viviakoo. ");
INSERT INTO sps_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kat faarei vaare ir yam, tana saa, e Tamamami nat faamuan bus iny koman tsumi tabuiny rangats romi Ya. ");
INSERT INTO sps_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ami ma faakats fi to: ‘Tamamamam te kaa rom Gormirmir, Asanga Manyi na taabos; ");
INSERT INTO sps_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Waam Manyi ma naa me ma kat arin mangiir Tsumanyi nei petoo faarei te kat finy rori ya naa Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Faan mamimam a kainy ainy te onot maromam roman. ");
INSERT INTO sps_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nyi te anofe ravainy men kat iring te kat amam, faarei mam te anofe ravainy kat iring te kat a mesapan tsumam. ");
INSERT INTO sps_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Fatamee vaare mamimam tan fiamus, Nyi te bei ot mamimam tana Vinasaar. A Waam Manyi, na reits, an siinaiv kaa na suu. Man ovei.’ ");
INSERT INTO sps_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Te anofe ravainy fi romi na iring te kat a mesapan tsumi, Tamamami te kaa non Gormirmir nai anofe ravainy kainy non a iring tsumi. ");
INSERT INTO sps_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sai te gim fi romi ma anofe ravainy a iring te kat a mesapan tsumi, e Tamamami te kaa non Gormirmir gim kainy non ma nai anofe ravainy a iring te kat ami.” ");
INSERT INTO sps_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Te tavtaav romi, kat famegurainy vaare na puam faarei raror vainy kat mapam. Ri taan vavis miror megurainy ma tagei rari na vainy tsuri te tavtaav iny ror a kainy ainy. Nyo tsue faman of maromi, ri nom bus a tafan a rof tsuar. ");
INSERT INTO sps_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Te tavtaav romi, garus yam a nai mami, mi te siruk, ");
INSERT INTO sps_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ma nat vaare na mesapan tsumi te tavtaav rom, e Tamamami tsun te gim romi ma tagei te nat non. Ai Tamamami, te tagei a ka te katkat romi tana uur, nai tafan maromi.” ");
INSERT INTO sps_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Farosoo vaare yam a masun tsumi nei petoo, tana pan, peesung an aran te kat fifiiring ror ya an vainy kakabuts kan sof ror ri te boree, er kabuts to. ");
INSERT INTO sps_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sana mi ma farosoo na masun iny Gormirmir, a pan a fo peesung an aran te gim ror ma kat fifiiring ya, an vainy kakabuts gim ror ma boree ya, er kabuts to. ");
INSERT INTO sps_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tana pan te kaa non fo masun tsumi, a pan nato aya, u koman tsian tsumi, te kaa non tsunia.” ");
INSERT INTO sps_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“U matan faarei non arasan tan puan. Te arasan fi non a matam, puam mami faavot arasan faavot non; ");
INSERT INTO sps_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","San te kio non a mata mami, a pua mami uurup ovei nanon. Te pon fi romi nei, mi kaa rom tana arasan, sana mi kaa rom tana uurup, ana uurup to aya tsumi, na karap fiisok!” ");
INSERT INTO sps_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“A sikia ta mes te onot non ma binun tana ina fuan a tsoiny tatagaa ot, ayei nai tsugei non a isen ya te mangiir a mesmes; ayei nai manaats non a isen ana ya te fataivou a mesmes. Jesan mi gim rom ma onot ma binun faavot ten Gov ana painy moni. ");
INSERT INTO sps_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Sana Nyo tsue of maromi: Mi ma koma patang vaare, fei nom romi na kainy ainy ge na kainy jiu ei ma toto mi, ge na fo raarav nana pua mami. Fiisia! A toto gim non ma fis pis a kainy ainy? Ge, fiisia, a pua mami te gim non ma fis pis a fo raarav? ");
INSERT INTO sps_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tagaa yam tan marei te ruaf vavis ror! Ri gim ror ma reev tu fua, ge farosoo faavots rari tana numaa iny fatamaar, san e Tamamami kaa non Gormirmir makok rarori. Fiisia! Ami gim rom a rof fafis rari? ");
INSERT INTO sps_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sei tsumi ito tan koma patang te onot fi rori ma sumainy a toto nar tan ta fo ar nainy ee? A sikia ovei. ");
INSERT INTO sps_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“A saa te koma patang of romi tana fo raarav na? Tagaa yam tan fo sisinaan vouts te gian fi rori: te gim ror ma kat a binun ge kat a fo raarav tsuar. ");
INSERT INTO sps_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sin tovei Nyo tsue of maromi tana Aatouf E Solomon, a mes a masun, te gim kan ma kaa me tu fo vau tsuan saavits faarei non isen tsurin sisinaa tovei. ");
INSERT INTO sps_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E Gov tsun kat fasaavits raror fo sisinaan vouts to, sisinaa gian ror roman, ai tamanainy ri te maas, er kurun ravaa to. Fiisia, Ayei gim non ma makok faarof maromi? A saf a faason a gagaar tsumi to na? ");
INSERT INTO sps_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Koma patang vaare yam, mi te tsue na ka, ‘Fei poo fi mi non a kainy ainy tsonyo ei, ge na ka iny jiu, gen raarav tsonyo ei?’ ");
INSERT INTO sps_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ito ari na foka te komainy fiisok ror vainy vavaajets. E Tamamami kaa non Gormirmir natiny non a fo mamatsiny ka te kat kat romi. ");
INSERT INTO sps_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sana mi ma kat tsuktsuk faamuainy tsom a Waan Ya, an fo mamatsiny kat tavaron Tsunia, to te komainy non Ya, ana Ya te see fafaan iny a fo mes a foka to tsumi. ");
INSERT INTO sps_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Koma patang vaare iny yam nainy tamanainy; u nainy tamanainy te patang patsukan iny non a tsivon. Tanyiny isen nainy, ma govets patsukainy ya na patang tsuan.” ");
INSERT INTO sps_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ami ma faaroiny vaaren kat tana mesapan, ai Gov te gim kainy ma faaron mami, ");
INSERT INTO sps_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","tana saa Gov nai faaroiny maromi faarei tsun non to te fafaaron fi romi, ana Ayei nai vovou tsun iny non senviir faun te vovou iny romi tan faaroiny a mesapan. ");
INSERT INTO sps_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kat fei to tsumi mamatoong tsuiny rom a painy kikipoo na kakaii te kaa non matan e vamuinyasiny tsumi, sana mi gim rom ma fakats a buiny kikipoo te kaa non mata mami ei? ");
INSERT INTO sps_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Fiisia, nyi onot rom ma tsue of e vamuinyasiny tsuam, ‘Tanyiny you ma nom ravainy tsom anyon kikipoon kakaii te kaa non matan ya,’ sana buiny kikipoo te kaa non mata manyi? ");
INSERT INTO sps_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Anyi na mes a kat mapam, nom ravainy faamuainy tsom a buiny kikipoo matam, nyi te onot ma tagaa fa'arasan ma nom ravainy anyin kikipoon kakaii matan e vamuinyasiny tsuam. ");
INSERT INTO sps_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ami ma faan vaare iny naa ta ka ta taabos tan kas, kat ror ser takopis of mami er kot matuami, ana mi te tats of vaaren voon beruan, ri te pitaa fusfus irari mour.” ");
INSERT INTO sps_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“A tou faakats ten Gov, ami ma rangat, ana Ayei te nai faan mami, mi ma sainy Ya ai mi te nai sab Ya, mi ma tegteg tan matainy sobaa, ai Gov te nai pue of mami, ");
INSERT INTO sps_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","tana saa fokinai te rangat ror ten Gov, ri natiny nom ror a foka te rangat iny rori, tsuri kan te san ror, ri sab ror Ya, ai tsuri kan te tegteg ror, Gov nai pue of rarori. ");
INSERT INTO sps_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","E sei fapoopoan namami ito te sing finy non a guei tsoiny tsunia tu koinykoiny ana ayei te fainy ya ta fats ee? ");
INSERT INTO sps_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ge te sing fi non ya ta jian, ayei te fainy ya na koraa? ");
INSERT INTO sps_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kainon tsumin vainy te natiny kat rom aveto sana mi natiny faan iny rom a foka na fo rof tan guei tsumi, ami ma nat faman fi nei, e Tamamami te kaa non Gormirmir te gim non ma natiny kat aveto te nai faan iny non a foka na fo saavits to tana vainy te sing ror Tsunia. ");
INSERT INTO sps_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Fo kat te komainy romi tan ta vainy ma kat of mami, kat to aya mi ma kat of rari; ayein faatsuts nan Faun te kirkir iny e Moses an fifaatsuts tan fuainy kuigin.” ");
INSERT INTO sps_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ami ma sof fi naa tan matainy sobaan kapoo, tana saa, sanaan te naa fi non Hel, a ka tsian ana bangbang fiisok. Ana fokinai vainy natiny vovou iny rora sanaan to aya. ");
INSERT INTO sps_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","San matainy sobaan kapoo tana sanaan te naa fi non tana toto na suu, sab rori na nag ana tee vainy tsun naa fi naa ror tsunia.” ");
INSERT INTO sps_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Taatag yam fuainy kuigin gamgam. Ri faarei raror siip jiarasan, sana ri te faarei raror kas vouts gagon. ");
INSERT INTO sps_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ami onot rom ma nat rari tan kat tsuri. Fiisia, a vainy te onot ror ma patsik tu fua nan vei tan kakarits? Ge, ari onot ror ma avet tu ngainy tana aufing a ngarian? ");
INSERT INTO sps_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","U nau rof natiny fua faarof non, an nau iring natiny fua fiiring non. ");
INSERT INTO sps_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","U nau rof gim non ma fua fiiring an nau iring gim non ma fua faarof. ");
INSERT INTO sps_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","U fo nau te gim ror ma fua faarof tek ravaa ror, ri te nai ravaa tan guaf. ");
INSERT INTO sps_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ami onot rom ma inainy kuigin gamgam tan kat tsuri. ");
INSERT INTO sps_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ami ma fakats fi vaare nei, a fokinai to te koo Varonyo na ‘Tsunaun, Tsunaun’ te nai sof rora Waan iny Gormirmir, sei tsun te manaats iny non mangiir ten Tamanyo te kaa non Gormirmir ee, ayei tsun. ");
INSERT INTO sps_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Fokinai tan Nainy to aya ito tan nainy vaatsuk nai tsue ror Tsonyo, ‘Tsunaun, Tsunaun, mam favaanan iny a asanga Manyi, ai tana asanga Manyi mam buur ravainy masarau, mam kat to na foka iny faatok!’ ");
INSERT INTO sps_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sana Nyo nai tsue rou tsumi, ‘Nyo sikia rou ma nat mami. Feis osing Vanyo yam, amin vainy katkat kat tana ngi'arapaar.’” ");
INSERT INTO sps_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Jio, tsumi na fokinai to te nongoiny rom vegiau Tsonyo mi te manaats ya, faarei ror a isen a mes a nat te fatsuiny a numaa tsuan patsun fats. ");
INSERT INTO sps_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Te ruat mi ya, ana aurom urungat to, ana ainysat tsian tapoor mito sa taf naanaa numaa. Sana numaa to aya gima tarop, tana saa a numaa te fatsun patsun fats. ");
INSERT INTO sps_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Sana mi na fokinai te nongoiny rom vegiau Tsonyo mi te gima manaats ya, faarei non a mes a piou te fatsuiny a numaa tsuan patsun moonyon. ");
INSERT INTO sps_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Te ruat mi ya ana aurom urungat to ana ainysat tsian tapoor mito sa taf naanaa numaa, ana ya tarop enato sa tatamoor en.” ");
INSERT INTO sps_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sen Jisas fakap vegiau Tsuan, ana vainy a kinai karian fiisok tsun iny ton fifaatsuts Tsunia, ");
INSERT INTO sps_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tana saa, Ayei gima faarei fuainy Tsoiny Fifaatsuts tan Faun, Ayei kaa minon gumgum tan fafaatsuts. ");
INSERT INTO sps_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas of osing me na painy tet, ana vainy u tagin kinai vovovou iny Towa. ");
INSERT INTO sps_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ana mes a tatauba naa mito ten Jisas, ya tsunguruu to sa tsue, “Tsunaun, to te koman fi rom Anyi, Nyi onot rom ma fataabos vanyo.” ");
INSERT INTO sps_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisas faarua iny naa na niman sa saras ya sa tsue tsunia, “Nyo koman rou, taabos sanyi!” Sen tsun an tatauba naus osing towa, ya taabos enato. ");
INSERT INTO sps_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ai Jisas tsue to tsunia, “Tagaa, tsue vaare na ka to tan ta mes, sana nyi ma naa fatoobing tsun naa tana tsoiny faakor ma tagaa faarof ya tsumanyi; ana nyi te kat a faakor to te tsue iny Faun te kirkir iny e Moses muan, tan kat to aya, ma nat ari na fokinai nyi taabos em.” ");
INSERT INTO sps_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Te naa fi naa Jisas tana ngats fan iny Kapeniam, ana tsoiny mumua tan natus vainy puaan tana taa Roum tainytainy Towa ana ya rangats Towa ma faakouts Ya ya. ");
INSERT INTO sps_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tsunaun, a tsoiny binun tsonyo na pua mat te kamits fiisok non ana soon iny faadis numaa.” ");
INSERT INTO sps_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas tsue to tsunia, “Nyo nai tsipaar rou ya.” ");
INSERT INTO sps_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsoiny mumua tan vainy puaan biny Towa, “Sikia on Tsunaun, nyo gima onot faarof ma famanat Manyi ma naa me numaa tsonyo. Nyi ma tsue tsun ana tsoiny binun tsonyo te rof fatabin en. ");
INSERT INTO sps_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Anyo kan a mes te kaa rou fain gumgum tan tsoiny mumua tan vainy puaan te karap varonyo, ana nyo kan kaa mirou vainy puaan te kaa ror faiv vanyo. Te tsue ronyo tana mes to, ‘Kua,’ ana ayei te naa naa. Nyo te tsue of a mesmes, ‘Taame,’ ana ayei te naa me, ana nyo te tsue of a tsoiny binun babainy tsonyo, ‘Kat a ka to,’ ana ayei te kat ya.” ");
INSERT INTO sps_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te nongoiny e Jisas a ka to Ya ngian enato sa tsue tana vainy te vovovou iny Ya, “Nyo tsue faman of maromi, Nyo gima sab vaarik ta mes te kaa fi minon ya na faason tsian to ayei, a sikia kan tana taa Isrel. ");
INSERT INTO sps_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nyo tsue of maromi, a fokinai sikia ma taa Jiu te poo fi miror tana pan te roruak minon a nuaf ai tana pan te ruk naa non a nuaf te nai gum iny ainy fiisen miror e Abraham me Aisak ai Jekop tana Waan iny Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sana rin vainy pisiin tana taa Jiu, to ma naa fi tana Waan to aya, Gov nai gargar fi rarori jiarasan tana uurup tana pan iny fasaraa, unya aya ri nai tangis ror er kakuts ngiisngiis to na ngiisir.” ");
INSERT INTO sps_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ai Jisas tsue to tana tsoiny mumua tan vainy puaan, “Kua, te kat fi nanon to te faaman fi nyi.” Ana tsoiny binun tana tsoiny mumua tan vainy puaan tsipaar enato tan ar nainy naa to aya. ");
INSERT INTO sps_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Te naa na Jisas numaa ten Pita, ana Ya tagei to nuan e Pita na soon iny faadis, faadis minon a puan a fisikii. ");
INSERT INTO sps_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ai Jisas saras to na niman ya ana fisikii naus osing towa, ya tsun to sa kakouiny of e Jisas a kainy ainy. ");
INSERT INTO sps_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Te ananerof bus me na pan ana vainy atoiny mito na vainy a kinai tutuei iny masarau ten Jisas. Jisas tsue, sa buur ravainy masarau ana Ya tsipaar to na vainy to te kaa men faadis. ");
INSERT INTO sps_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ayei kat, kat to, san vegiau pokei iny to e Aisaia na kuigin muan ruak iny man ovei enato. Aisaia te tsue na ka, “Ayei nom ravainy a fo viir faadis tsura ana Ayei govets to na fo viir kamits tsura.” ");
INSERT INTO sps_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas nat ir tagin tsian te bau faafis Ya, ana Ya tsue to tan matisian Tsunia. “Ara ma guas naa tan mes panaan nana naaman.” ");
INSERT INTO sps_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ana tsoiny fifaatsuts tan Faun te kirkir iny e Moses naa mito ten Jisas sa tsue, “Nyo komainy vovou marom Anyi tana fo pan te naa rom Anyi.” ");
INSERT INTO sps_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas biny towa, “U kas vouts kaa miror matan tsuar tan puputaa, an marei kaa miror sai tsuar, sana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me na sikia ta pan iny fasooiny a patsuun.” ");
INSERT INTO sps_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ana mesmes a matisian tsue to, “Tsunaun, famanat you ma mat tsom e tamanyo ana nyo te kats tsom iny ya, vou nyo te vovou Manyi.” ");
INSERT INTO sps_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisas biny towa, “Vovou you, Tanyir mat ma kats iny arin vainy mat.” ");
INSERT INTO sps_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas jias tan puak, an matisian Tsunia naa fiisen mi Towa. ");
INSERT INTO sps_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sen tsun an sekeiny ratsuu tapoor mito naaman to san rau tsian kat iny faruk puak. Ai Jisas goros en. ");
INSERT INTO sps_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Matisian Tsunia naa ser guinyguiny Ya, ri tsue to “Tsunaun saup rara! Ara kat iny mat osto!” ");
INSERT INTO sps_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“Kat fei sam oraav rom ei,” biny finy rari Jisas. “A saf a faason tsumi na kakaii to na!” Ana Ya tsun to sa tsue ets'ets tana ainysat ana ainysat sariof ovei enato ana madaav ras to. ");
INSERT INTO sps_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ana fokinai saar to ser tsue, “A saf a mes to aya na, to tana ainysat an rau manaats Ya!” ");
INSERT INTO sps_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas naa fi naa tan mes panaan nana naaman tan mounan tana taa Gadara. Ana ina fuan a mes tutuei iny masarau tainytainy Towa. A ina fuan poo fi me tan katskats fain a varian. Ana sikia ta mes ma onot iny taan tana pan to aya tana saa, a ina fuan u vouts an reits fiisok. ");
INSERT INTO sps_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ri kuu fiisok ser tsue na ka. “Nyi na Guei tsoiny ten Gov, a saa te komainy kat rom Anyi tsumam na? Nainy te mataanis non, ana Nyi na tou fasaraa mamam a ina fuan?” ");
INSERT INTO sps_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sikia ma veevian fiisok te kaa men veis voon kinai te ainyainy. ");
INSERT INTO sps_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Masarau sing to Jisas, “Te komainy jiat fuainy fi maromam Anyi, jiat fi mamam tan veis voo.” ");
INSERT INTO sps_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas tsue to tsuri, “Kuar yam!” To ser tafuts osing rari ser sof ir voo. An veis voo faavot kuar to ser tsiak naa tana varian tsidup naaman ser ruk, ri mat rato. ");
INSERT INTO sps_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ana vainy to te tatagaa ot ir veis voo bus fi erato tana ngats fan, ser favaanan iny a ka to tana ka te ruak tana ina fuan a mes tutuei ir masarau. ");
INSERT INTO sps_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","To sana fokinai tana ngats fan naa ser tainytainy e Jisas. Te tagei ari Jisas, ri sing Towa ma naus osing Ya na pan tsuri. ");
INSERT INTO sps_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas jias to tan puak, sa guas fatabin en tan mes panaan nana naaman, ana Ya ruak to fan Tsuan fatoobing. ");
INSERT INTO sps_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mes vainy govets mito na mes a nima mat, ana mou mat soon non tan nenengan. Jisas tagei a faason tsuri, Ya tsue to tana mes a faadis, “Guei tsiau, u aveto tsumanyi te anofe ravaa en.” ");
INSERT INTO sps_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mesapan nar tsoiny fifaatsuts tan Faun te kirkir iny e Moses tsue to tsuri patsukaner, “A mes to te kat tsue to, Ayei fifanauti minon e Gov!” ");
INSERT INTO sps_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas nat faamuan iny fakats tsuri sa tsue, “Kat fei sam fakats fiiring rom ei? ");
INSERT INTO sps_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Saf vegiau te opaar non Tsonyo ma kat na? Te tamee non Tsonyo ma tsue, ‘Nyo anofe na fo aveto tsumanyi,’ ge te tamee fafis non tan tsue fi nei, ‘Tsun, nyi te taan?’ ");
INSERT INTO sps_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sai tovei Nyo faatok maromi ma nat fi nei, A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me kaa minon gumgum tana monaagits to tan anofe ravainy aveto.” Ai Jisas tsue to tana mes a nima mat an mou mat, “Tsun, nom nenengan tsuam nyi te naa numaa tsuam.” ");
INSERT INTO sps_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ana mes to tsun to sa naa fi en numaa tsuan. ");
INSERT INTO sps_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","An tagin vainy tagaa to ser oraav, ri vamarits to Gov, te faan iny gumgum to tana vainy. ");
INSERT INTO sps_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas naus osing a pan to aya. Ya tagei to na mes te koo rori Matiu vaagum non numaa tana pan iny nonom takis. Jisas tsue to tsunia, “Vovou you.” Matiu tsun to sa vovou iny e Jisas. ");
INSERT INTO sps_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Te gum iny ainy e Jisas numaa ten Matiu, an vavainy nonom takis kinai an mes a vainy pisiin naa mito ser ainy fiisen mi Ya an matisian Tsunia. ");
INSERT INTO sps_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasi tagei a ka to, ri rangats ton matisian Tsunia, “Kat fei sana Tsoiny fifaatsuts tsumi ainy fiisen minon vainy nonom takis an mes vainy pisiin ei?” ");
INSERT INTO sps_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas nongoiny vegiau to sa tsue rari, “Vainy toto faarof gim ror ma komainy a tsoiny tsipaar, a sikia, a vainy tsun ton faadis. ");
INSERT INTO sps_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kuar yam am nat faarof iny ton vegiau to: ‘Nyo komainy fiisok roun kat tan tagtag ir a mesmes rof fafis pis iny non fo fifaan tan katkat faakor.’ Nyo gima naa me ma fikoo Nyon vainy tavaron, sana Nyo te naa me ma fikoo Nyon vainy pisiin.” ");
INSERT INTO sps_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Matisian ten Jon a Tsoiny Fapeenan naa me ten Jisas ser rangats Ya, “Kat fei sana mam mi na taa Farasi natiny tavtaav rom, san matisian Tsumanyi gim ror ma natiny tavtaav ei?” ");
INSERT INTO sps_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas tsue fatabin to tsuri, “A vainy te naa miror tana kainy ainy tan fanging gim ror ma natiny tavtaav iny a kainy ainy, teeva? Sikia. Nainy te faarei Anyo na tsoiny fanging, Nyo kaa fiisen ramituarin fuainy matisian Tsonyo, mam ainy miton paparaa, sai vou, vainy nai nots Varonyo Nyo te kaa osing ir matisian Tsonyo, tan nainy to aya, matisian nai tavtaav miror reesik.” ");
INSERT INTO sps_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jisas tsue of ratuarin tsue fapapaar to: “Sikia ta mes te onot non ma keres ta painy vau foun a kuiny towa na takakaar tan vau tamuan, kat fi non nei ana pan a foun te kat kakaar fatsiainy a pan a tamuan, ana takakaar te nai bangbang fafis en. ");
INSERT INTO sps_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ai to kan tana mes te natiny itsuf non wain foun tana iikan a tamuan, kat fi non nei, an wain foun te kat pung a iikan an wain ana iikan nai kajiaa faavot raror. U wain foun te rof non tana iikan a foun ma kaa faarof ari.” ");
INSERT INTO sps_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas vegiau kanen nanon tsuri, ana tsoiny mumua tana numaa iny fafaatouf tana taa Jiu naa mito Tsunia fatukun matan Ya, ya tsue to, “A guei moun tsonyo te maten; taame Nyi fasaur tsuiny to na nimam patsuun Ya ma toto fatabin en ya.” ");
INSERT INTO sps_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jisas tsun, sa vovou iny naa ya an matisian Tsunia kan vovou iny naa Towa. ");
INSERT INTO sps_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A moun te kaa kan to te gum iny tataa'in onots a safunuu ana fuan a ingainy, ising me voun e Jisas sa saras nguen raarav Tsunia. ");
INSERT INTO sps_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ya tsue patsukan to tsivon, “Anyo ma saras toromainy tsuiny raarav Tsunia nyo te rof fatabin you.” ");
INSERT INTO sps_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas takopis, Ya tagei towa sa tsue, “Paparaa, Guei moun Tsiau, Nyi te faason Tsonyo to sa nyi rof fatabin em.” Sen tsun ana moun to rof fatabin nato. ");
INSERT INTO sps_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Te naa fi Jisas numaa tana tsoiny mumua tana numaa tana taa Jiu, te tagei ya na vainy te puuf ror tan koov iny vaa'ur ana pan goonen kan nato tana vainy, ");
INSERT INTO sps_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ya tsue to. “Tafuts yam fokinai! A kooviou to na gima mat, ayei te goros tsun non!” Ri na fokinai oor Towa. ");
INSERT INTO sps_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Te tafuts fakap bus naa na vainy, Jisas sof nato tana pan tana kooviou to, Ya nom to niman ya, ana ya tsun nato. ");
INSERT INTO sps_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","U vaanan nana ka to saats vavis to na gum fan naa aya. ");
INSERT INTO sps_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas naus osing a pan naa to aya, ai te taan farokot naa Ya ana ina fuan a mata kio tanik iny vovou naa Towa. “Tagtag mamimam, tsubnaain ten Devit,” te kuu fi ri. ");
INSERT INTO sps_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Te sof naa Jisas gagon numaa, ana ina fuan a mata kio to naa mito Tsunia ana Ya rangat ratuari. “Mi faaman rom Nyo onot rou ma kat a ka to?” “Eye, Tsunaun,” biny finy ari Ya. ");
INSERT INTO sps_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Sen Jisas saras a mata rari ana Ya tsue to, “A ka to nai ruak nats non tsumi tana saa ami te faason Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ana mata rari takarat nato. Jisas tsue tap rari ma tsue faruak vaare iny a ka to tan ta mes! ");
INSERT INTO sps_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sana ri naa, ri saats vavis to na ngats fan tan vaanan nane Jisas. ");
INSERT INTO sps_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Te naus osing a ina fuan a mes to Jisas, mes vainy mei mito na mes ten Jisas, a tutuei iny masarau ana gima vevegiau. ");
INSERT INTO sps_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te buur fakap e Jisas masarau tana mes, ya tanik iny vegiau bus nato. Fokinai saar fiisok ri tsue to, “Amam Sikia ma tagei ta ka ma kat fi nei i Isrel.” ");
INSERT INTO sps_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sana rin Farasi tsue na ka, “Ayei onot non ma buur ravainy masarau tana saa Ayei te nom a parits tana tsunaun tan masarau.” ");
INSERT INTO sps_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ai Jisas naa vavis to tana fo ngats fan ai tan fo fan. Ya fafaatsuts to tana fo numaa iny fafaatouf tana taa Jiu favaanan iny Vurungan Rof tana Waan iny Gormirmir, ana Ya tsipaar kainy ton viir faadis an viir kamits tana vainy. ");
INSERT INTO sps_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nainy te tagei Yan tagin, Ya kaa mito na tagtag tsian tsuri, tana saa, ari kaa men koma patang ana ri kaa iny nun kan ror faarei ror u siip a sikia ta tsoiny veis tsuri. ");
INSERT INTO sps_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ana Ya tsue to tan matisian Tsunia. “A kainy ainy a kinai tan tanun te matsua raravaa en, sana sikia ta vainy binun ta kinai ma agion tanun. ");
INSERT INTO sps_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Faakats of yam a Tsunaun tana tanun to ma jiats men vainy binun er agio ton tanun Tsunia.” ");
INSERT INTO sps_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas fikoo vaaguam ir a ina safunuu ana ina fuan a matisian Tsunia ana Ya faan ratuarin gumgum iny buur ravainy masarau er tsipaar ton viir faadis ana fo viir kamits. ");
INSERT INTO sps_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tovein asanga ra ina Safunuu ana ina fuan a amaraav: vaamuan to e Saimon, te koo ri Pita, ai famuinyasiny tsunia Anduru; Jemis ai famuinyasiny tsunia Jon, u guei tsoiny ten Sebedi; ");
INSERT INTO sps_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, ai Batolomiu, ai Tomas, ai Matiu, a tsoiny nonom takis, ai Jemis, a guei tsoiny ten Alfias, ai Tadias, ");
INSERT INTO sps_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ai Saimon, ayei na isen tsuri na gum iny vainy te kat iny nom ravainy ror gumgum iny Roum, ai Judas Iskariot, ayei na mes te nai faan iny e Jisas tan vainy ma atsuiny famat ari Ya. ");
INSERT INTO sps_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas jiat ra naa na ina safunuu ana ina fuan a mes to ari ana Ya faan ratuarin tsue fanat to: “Naa vaare yam tana vainy sikia ma taa Jiu. Am naa vaare kan to tana ngats fan iny Samaria. ");
INSERT INTO sps_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kuar yam tana taa Isrel to te faarei raror siip nun farokot. ");
INSERT INTO sps_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kuar yam am favaanan to. ‘A Waan iny Gormirmir te sisiruu ename.’ ");
INSERT INTO sps_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tsipaar yam fo faadis, fatoto ir yam vainy mat, kat faarof fatabin ir yam vainy tatauba, buur ravainy yam masarau. A parits te nom romi na sikia ma pats, ayei na ka ma faan babainy iny ami kainy faakouts ir a vainy, sikia ta pats nan. ");
INSERT INTO sps_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Govets vaare yam ta painy moni, ");
INSERT INTO sps_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","govets vaare kainy yam ta poraa ge tu vau, ge tu suu ge tu tsukan iny taataan fiisen me, tana saa a tsoiny binun ma nom tu fifaakouts tan vainy te faakouts ror ya, ma tamainy yan koman tsunia. ");
INSERT INTO sps_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Te naa fi naa romi tan ta ngats fan ge ta fan, kuar yam am tagaa faarof to tan ta mes te onot non ma fafasung mami onot non te naus osing romin a pan naa to aya. ");
INSERT INTO sps_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nainy te sof romi na numaa tsue yam a ka. ‘Aaverof kaa non fapoopoan nam mami.’ ");
INSERT INTO sps_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te makok fi marom yam ta vainy koman a numaa nato aya, fakei yam tsuen rof nana aaverof ma kaa ya; sai te gim fi rori ma fafasung mami, nom ravainy yam tsue nana aaverof. ");
INSERT INTO sps_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sai te gim fi non ta mes ma fasung mami ge te fanaginy tsue rori tsumi, tafoor yam kuaf mou mami, faatok iny non e Gov nai faan rarorin fasaraa ana mi te naus osing rari. ");
INSERT INTO sps_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Fakats yam a ka to, tan nainy vaatsuk, Gov nai fasaraa fifiiring rarori, fis nats non a fasaraa te nai faan iny non ya to tan vainy pisiin tana fan iny Sodom ai Gomora.” ");
INSERT INTO sps_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ai Jisas tsue pis to, “Nongon yam! Nyo jiat ma naa romi tovei tsun faarei rarom tsunei siip fapoopoan nar vainy iring to te faarei raror kas vouts. Mi ma tamomots, am vovou iny ton kat tan koraa, am fakats faarof to te kakan faamo fi rori. Mi ma vovou faarof iny kat tan marei iton kurume, am gim to ma biny ta fo iring tsuri. ");
INSERT INTO sps_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Taatag yam, te kaa miror tu vainy te pon ror ma nots mami er fakaa matuami tan vaatsuk, ri te rapits mami koman a fo numaa iny fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mi te nai tsutsun matar a fo gavana ana fo gotouf, tana saa, mi te faaman Vanyo to te favaanan finy romin Vurungan Rof to tsuri ai tana fo mes vainy sikia ma taa Jiu. ");
INSERT INTO sps_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Te mei maromi ri tan vaatsuk, fakats fakinai vaare yam a foka te vegiau iny romi, ge te nai tsue fi romi ei; tana saa, tan nainy vegiau mi nai nom rom fo vegiau te nai tsue iny romi. ");
INSERT INTO sps_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A fo vegiau te tsue iny romi, sikia ma vegiau tsumi, u vegiau te poo fi minon tan Aaven Taabos ten Tamamami te pokei romi ya. ");
INSERT INTO sps_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“A vainy te faan raror fo famuinyasiny tsuar fatoobing tsuri ma atsuiny famat rari ri, tana saa, ari te faaman Vanyo. Ana fo taman kat kan fi ror jesan tan guei tsuar; fo guei tamimiat of raror fo tamar an tsinar er faan ranaatuari ma atsuiny rari ri. ");
INSERT INTO sps_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","A fokinai te tsugei fiisok tsun maromi, tana saa, mi te faaman Vanyo, sai ten sei tsun te suu iny non a faaman tsuan onot non tan fafakap nan nainy ee, nai nom non a toto na suu. ");
INSERT INTO sps_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ai to te fakamits varomi ri tan ta isen ta ngats fan bus fuainy yam tan ta mes ta ngats fan tana saa Nyo tsue of maromi mi gim rom ma fakap a binun tsumi tana fo mamatsiny ngats fan iny Isrel onot non tan nainy tabuiny tabin minon a Guei Tsoiny te Bobot e Gov sa ruak iny mes me. ");
INSERT INTO sps_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sikia ta guei tan fifaatsuts te karap fafis iny non a tsoiny fifaatsuts tsuan; ana sikia ta tsoiny binun te karap fafis iny a tsoiny tatagaa ot tsuan. ");
INSERT INTO sps_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A ka te kat rori tan tsoiny fifaatsuts te kat kainy rori tan guei tan fifaatsuts. Ana ka te kat rori tana tsoiny tatagaa ot te kat kainy rori tan tsoiny binun te kat fi kanen nanon to jesan. Ri koo Vanyo Belsibul, ana mi faavot vainy Tsonyo nai nom kainy rom asangan iring vavajia.” ");
INSERT INTO sps_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Oraav vaare yam ta vainy tana saa, a fokan takop nai tapokaa eraror ana fo famun nai natiny rori. ");
INSERT INTO sps_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","U vegiau te tsue iny ronyo tana voiny mi ma favaanan iny ya tana nuaf an vegiau te nongoiny romi tana uur mi ma favaanan iny naa ya tana vainy. ");
INSERT INTO sps_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Oraav vaare ir yam te atsuiny famat fi rorin puainy mes, sana ri gim ror ma onot ma atsuiny famat aaven. Ami ma oraav e Gov tsun tsivon, Ayei onot non ma rureir puainy mes ana aaven unya Hel. ");
INSERT INTO sps_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mi onot rom ma foiny ta fuan ta tsutsupii tana isen ta takep; sana sikia on ta isen tsuri ma mat, ya te rus me putaa te faarof fi non e Tamamami. ");
INSERT INTO sps_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ai tsumi kan ai tan fo funuu patsuu mami Gov kaa bus me na as'as narari. ");
INSERT INTO sps_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jio, oraav vaare yam; mi karap fafis pis iny rom fokinai tsutsupii!” ");
INSERT INTO sps_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas tsue pis to na ka, “E sei te pokei Varonyo te fasito iny rou ya matar a fokinai ee, Nyo kan nai kat fi kan rou jesan tsunia matan e Tamanyo Gormirmir, ");
INSERT INTO sps_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","sen sei te faungis Varonyo matar a fokinai ee, jesan kan Nyo nai faungis kainy rou ya matan e Tamanyo Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Pon fi vaare yam nei Anyo te mei me naa aaverof tana monaagits to, a sikia, Nyo gima mei me naa aaverof, sana Nyo na tou kibei ir a vainy. ");
INSERT INTO sps_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nyo naa me na tou kat ir a vainy ma takibaa ri; er nai takibaa to: u guei tsoiny koma iring raror tamar, tana saa, ri te faaman Vanyo, ge u guei moun nai koma iring raror tsinar, an nyanabeir guei moun nai koma iring raror muiny nyanabeir; ");
INSERT INTO sps_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ana taman tana tsoiny koma iring minon numaa iny guei tsunia patsukanen. ");
INSERT INTO sps_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“E sei te mangiir fiisok non e taman ge tsinan ee to te mangiir fafis Varonyo, ayei gim non ma tamainy a fasito Vatuanyo. ");
INSERT INTO sps_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ai sei te gim non ma famanat a fa'orovus iny to na tsivon ee ai te vovou Vanyo, ayei gim non ma tamainy a fasito Vatuanyo. ");
INSERT INTO sps_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ai sei te mangiir non ma suu iny a toto tsuan ee nai kajiaa babainy enanon; ai sei te mangiir fiisok Varonyo ee ya te faan iny a toto tsuan tana binun Tsonyo ee nai nom non a tafan tsuan, ito na toto na suu.” ");
INSERT INTO sps_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisas tsue pis to na ka, “E sei te fafasung maromi ee, ayei kan te fafasung Varonyo, ai sei te fafasung Varonyo ee fafasung kainy non Ya to te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ai sei te fafasung non a kuigin ten Gov ee ya te makok faarof ya, tana saa, ayei na kuigin a tavaron nai nom non a tafan tsuan faarei te nonom finy a fo kuigin tavaron u tafan tsuar, ai sei te fafasung a tsoiny binun a tavaron ee ya te makok faarof ya tana saa, ayei na tsoiny binun na tavaron nai nom non a tafan tsuan faarei te nonom finy a fo tsoiny binun tavaron u tafan tsuar. ");
INSERT INTO sps_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Fakats faarof yam a ka to! E sei te fajiu non ta isen tsurin tsoiny binun babainy Tsonyo ta aurom ta kour ee tana saa, ayei na tsoiny binun Tsonyo nai nom famainy non a tafan tsuan.” ");
INSERT INTO sps_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Te faan fakap bus e Jisas fo tsue fanat to tana ina safunuu ana ina fuan a matisian Tsunia, Ya naus osing to na fan to aya, ana Ya naa to sa fafaatsuts, Ya favaanan to tana fo ngats fan naa aya siruu. ");
INSERT INTO sps_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon a Tsoiny Fapeenan kaa en tan kotskots nongon tana binun ten Krais, ya jiats naa ton matisian tsunia unya Tsunia. ");
INSERT INTO sps_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Tsue of mamimam”, rangats fi ri Jisas, “Anyi koraa Ya na mes to te tsue iny e Jon te naa minon ge mam ma anaanos farokots ta mesmes?” ");
INSERT INTO sps_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas biny ratuari, “Kuar fatabin yam am tsue of to Jon tana foka te nongoiny ami ana foka te tagei ami: ");
INSERT INTO sps_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","arin matar kio tagaa fatabin er, rin pengong taataan fatabin er, rin tatauba tsipaar fatabin er, rin teinar kuupio nongon fatabin er, rin vainy mat toto fatabin er an Vurungan Rof favaanan en tan vainy aaruts. ");
INSERT INTO sps_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Gov faparits non a mes te faamainy Varonyo to na mes te pokei iny e Jon sai te gim non ma vaa'ets Vanyo!” ");
INSERT INTO sps_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Te tabin naan matisian ten Jon, Jisas tanik iny vegiau iny to na mes to aya tan tagin. “Te naa fi mi ten Jon tana pan a uur, a saa te pon iny ami ma tagei na? Ami te pon ma tagei a mes a sikia ta faaman te faarein ngaar te tagugut non tana ainysat? A sikia. ");
INSERT INTO sps_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A saa te nai tagei ami na? A mes te vaun vau tsunian mamarof ge? Vainy te vau fi ror to, kaa ror tana numaa tana fo gotouf! ");
INSERT INTO sps_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tsue of Vaminyo yam a saa te nai tagei ami na? A kuigin? Eye, Nyo tsue of maromi mi tagei bus a kuigin to te karap fafis pis ir fo kuigin, ");
INSERT INTO sps_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","tana saa e Jon, ayei na mes to te tsue tsuk men Vegiau Ten Gov sa tsue, ‘Tovei na tsoiny favaanan Tsonyo,’ te tsue fi Gov, ‘Nyo nai jiats famumuei nats rou ya Tsumanyi ma kakouiny onots ya na sanaan Tsumanyi!’ ");
INSERT INTO sps_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Fakats faarof yam a ka to, Nyo tsue of maromi, Jon a Tsoiny Fapeenan karap fafis iny non a vainy to te agiir me tana monaagits to. Sana mes tana Waan iny Gormirmir to te fauf non a tsivon a faarei to na mes babainy ayei karap fafis pis iny non e Jon. ");
INSERT INTO sps_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tanik tan nainy te favaanan iny e Jon a Tsoiny Fapeenan vurungan onot me tan nainy roman vainy pisiin te pon ma kat tap iny a Waan iny Gormirmir, to ser komainy ma rurei ya. ");
INSERT INTO sps_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Rin Kuigin an Faun te kirkir iny e Moses pokei kan iny a Waan iny Gormirmir onot tan nainy ten Jon. ");
INSERT INTO sps_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te pon fi romi ma faamainy Vurungan Rof tsuri, mi ma nat fi nei, e Jon, ayei e Ilaija an Vegiau Ten Gov pokei faamuan iny ya te naa minon. ");
INSERT INTO sps_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nongon yam, te kaa fi miromin teinan, mi te nongon tan Vegiau to! ");
INSERT INTO sps_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ai fei te fapapaar finy Ronyo ya tsumin vainy iny roman ei? Ami faarei rom saa? Mi faarei rom guein kakaiin pisiin te goonen ror koman a fan. Isen a gum kuu fi naa ror tana mes a gum, ");
INSERT INTO sps_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mam kat of maromin babaato nan fanging sana mi baainy rom ma tajiat! Mam koomein fo vaa'ur sana mi gim to ma tangis!’ ");
INSERT INTO sps_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon naa me sa tavtaav, ya gim to ma ainy ana ya gim kainy to ma jiu tu wain ana fokinai tsue towa na tutuei iny masarau! ");
INSERT INTO sps_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ana Anyo na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa me, Ya ainy to, ana Ya jiu to, ana fokinai tsue to na ka, ‘Tagaa yam tana mes tovei! Ayei na mes a kokorom ana jijiu wain fiisok, a vaatau kan tana vavainy nonom takis an mes vainy aveto!’ Mi tsugei vegiau te kat amam me Jon, sana vainy te faarof vegiau Tsonyo te faatok maromi na nat ten Gov a tavaron tan kat tana toto tsuri.” ");
INSERT INTO sps_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sen Jisas tanik iny peits rato na vainy tan fo mar ngats fan tana saa, Ayei te faatok iny a fo binun iny faatok a kinai tsuri, sana vainy gima takopis osing a fo kat iny iring tsuri. ");
INSERT INTO sps_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Reesik tsian fiisok tsumi na taa Korasin! Reesik tsian fiisok tsumi na taa Betsaida! Mi tagei na fo binun iny faatok te kat Anyo, sai mi gim to ma reesik, mi takopis osing to na fo aveto tsumi. Tabuiny tagei arin vainy vavaajets tana taa Taia ai Saidon a fo binun iny faatok to te kat Anyo tsumi, ri tabuiny vau veesau vau iny ugun tsuar, ai to tan taf a tsivor kuaf, ri gum iny tangis ror faatok rarori te reesik fiisok ror, ri te takopis osing aveto tsuri. ");
INSERT INTO sps_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Fakats faarof yam a ka to, tan nainy vaatsuk Gov fasaraa maromi na taa Korasin ai Betsaida fis non a fasaraa te nom ror a taa Taia ana taa Saidon. ");
INSERT INTO sps_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ana mi na taa Kapeniam, mi pon iny rom ma fapaas a tsivom jias Gormirmir? A sikia. Gov nai fakaa maromi peto unya Hel. Tabuiny tagei vainy vavaajets tana taa Sodom a fo binun iny faatok to te kat Anyo tsumi, ri buiny takopis osing aveto tsuri, Nyo buiny gima rurei a Sodom. ");
INSERT INTO sps_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Fakats faarof yam a ka to tan nainy vaatsuk, Gov fasaraa maromi na taa Kapeniam fis non a fasaraa te nom a taa Sodom.” ");
INSERT INTO sps_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tan nainy na to aya Jisas tsue to, “O Tamau, Tsunaun iny Gormirmir ai nei petoo! Nyo faarof marom Anyi, tana saa, Nyi famuiny vegiaun man tan vainy nat an rin vainy te nom nat, sai Nyi faatok iny towa tan vainy babainy te faaman tsun faarei ror guein kakaii. ");
INSERT INTO sps_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eye, Tamau, Nyi vovou bus iny mangiir Tsumanyi te paparaa mirom Anyi.” ");
INSERT INTO sps_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tamanyo faan bus Vanyon fo mamatsiny ka. Sikia ta mes te natiny non a Guei Tsoiny, san a Taman tsun, ana sikia ta mes te natiny non a Taman, san a Guei Tsoiny tsun ana ri kan ton vainy te pisainy a Guei Tsoiny ma faatok rari Ya Taman. ");
INSERT INTO sps_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Taami yam Tsonyo mi na fokinai to te nag rom tan govets a patang, Nyo faan maromi na favusuan a rof. ");
INSERT INTO sps_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mi ma nom a nat Tsonyo am vovou faarof iny ton vegiau Tsonyo ana mi te kat a binun Tsonyo tana saa, Anyo na koma tamee ana Nyo fauf rou a Tsivou ana mi te sab a favusuan a rof tana aavem, ");
INSERT INTO sps_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","tana saa, binun te faan iny ronyo tsumi na kenak iny kat ana foka te faan iny Ronyo tsumi iny govet, a sikia ma patang.” ");
INSERT INTO sps_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tan nainy to aya Jisas taan naa koman a tanun wit tan Nainy Fafaatouf tana taa Jiu. Matisian Tsunia ves to, ri tanik iny ngats ton wit ser ainy ya. ");
INSERT INTO sps_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Te tagei Farasi na ka to ser tsue to ten Jisas, “Tagaa, te sikia non ma toobing tana Faun tsura te binun fi ror matisian Tsumanyi tan Nainy Fafaatouf!” ");
INSERT INTO sps_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisas biny ratuari, “Ami te gogosias a ka te kat e Devit a Aatouf, a tsuvurara fiisen men vainy tsuan te ves ari muan! ");
INSERT INTO sps_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ayei te naa sa sof a saape ten Gov ana tsoiny faakor famanat iny towa ma nom koinykoiny te faan iny ari matan e Gov sa ainy ya, ya fafaan ratuarin vainy tsuan. Sai tan Faun tsoiny faakor tsun onot ror ma ainy ya. ");
INSERT INTO sps_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ana mi gogosias kainy vegiau te kaa non tan Faun te kirkir iny e Moses to tan fo Nainy Fafaatouf, tsoiny faakor tana saape natiny ngats ror Faun ma binun vaare ri tan Nainy Fafaatouf sana ri na sikia tu aveto! ");
INSERT INTO sps_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nyo tsue of maromi tana mes te kaa non to, Ayei te karap fafis iny non a saape. ");
INSERT INTO sps_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","U Vegiau Ten Gov te tsue, ‘Nyo komainy fiisok roun kat tan tagtag ir a mesmes rof fafis pis iny non fo fifaan tan kat kat faakor.’ Te nat fi romi nei tan kat to ami gima sigan ta mes te sikia ma kat ta iring, ");
INSERT INTO sps_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","tana sana, a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me te Tsunaun iny non Nainy Fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas naus osing a pan naa to aya ana Ya naa fi enato tana isen a numaa iny fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A mes te kaakaa na aya a nima pengong. Ana mesapan tsuri te kaa kan na aya te komainy ma tsikoo ta sanaan ma fakei ari Jisas tan vaatsuk tana iring te kat Ya to ser rangats Ya, “Te toobing kan non tana Faun tsura tan tsipaar a mes tan Nainy Fafaatouf?” ");
INSERT INTO sps_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisas biny ratuari, “Fiisia, te kaa fi minon ta isen tsumi ta isen ta siip te gotsiny fi naa non tana matan ta gaguur tan Nainy Fafaatouf mi gim rom ma ras fatafuts ya? ");
INSERT INTO sps_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A mes te karap fafis pis iny non a isen a siip to. Tan kat to aya san Faun tsura famanat rarora tan faakouts a mes tan Nainy Fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ai Jisas tsue to tana mes, “Paroor a nimam.” Ya paroor to na niman sa rof fatabin en faarei tsuiny mes niman. ");
INSERT INTO sps_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farasi vavakas, ri vaagum ser kat a fo sanaan iny atsuiny e Jisas. ");
INSERT INTO sps_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Te nongoiny e Jisas a ka to Ya naus osing to na fan to aya; ana vainy a kinai vovou iny naa Towa. Ya tsipaar to na fo mamatsiny faadis, ");
INSERT INTO sps_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ana Ya tsue tap rato na fokinai ma tsue faruak iny vaare Ya, ");
INSERT INTO sps_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ma ruak iny man men Vegiau Ten Gov te pokei me Aisaia na Kuigin sa tsue na ka, ");
INSERT INTO sps_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Tovei na Tsoiny binun Tsonyo te pisainy fatoobing bus Anyo, ana Nyo kaa miroun mangiir tsian Tsunia, ana Nyo koma rof fiisok tsun kan iny rou Ya. Nyo faan iny rou Aaven Taabos Tsonyo Tsunia ana Ya te pokei vegiau iny vaatsuk Tsonyo naa non tana vainy faavot. ");
INSERT INTO sps_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Sana Ayei gim non ma fatsitsien ge ma kuu fabaasuan, ge ma vegiau vavis tana fo sanaan. ");
INSERT INTO sps_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A mes faarei non ngaar sikia ma parits, Ayei gim non ma ngats ya ana mes faarei non kurun sikia ma baraar, Ayei gim non ma famote ya, Ayei binun non ma kat faarof yan kat tavaron onot non kat tavaron te fabiu non ai te faduem aveto. ");
INSERT INTO sps_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ana fokinai te fakei a fo mamatsiny fakats tsuar Tsunia, ri te anaanos Ya a faakouts ratuari.” ");
INSERT INTO sps_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ana mesapan tsuri na vainy mei mito na mes a mata kio ana baaruu, tana saa ayei na tutuei iny masarau. Jisas tsipaar a mes to sana ayei vegiau ana ya matoong to. ");
INSERT INTO sps_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rin tagin saar ser rangat, “Ayei toroman a tsubnaain ten Devit?” ");
INSERT INTO sps_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Te nongoiny Farasi na ka to ri tsue to na ka, “Ayei buur ravainy non masarau, tana saa, Belsibul a tsunaun tan masarau te fainy Ya na parits iny kat a foka to.” ");
INSERT INTO sps_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas nat faamuan iny fakats tsuri ana Ya tsue of ratuari, “A vainy tana isen a gum fan takibaa ror ri te kat a fuan a pan ri te fataatsun, a gum fan to aya gim non ma nai kaa fapotsian nats. Ana ngats fan ge na vainy tana isen a numaa nai takibaa ror tana fo gum ri te fataatsun nai taruraa eraror. ");
INSERT INTO sps_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sai te buur ravainy non e Satan masarau, ri takibaa ror er fataatsun to, nai taruraa eraror tovei tsun. ");
INSERT INTO sps_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mi tsue rom a ka, Anyo buur ravainy rou masarau tana saa e Belsibul a tsunaun tan masarau te faan Vanyo na parits iny kat a foka to, sei pas te faan iny a parits tan vainy tsumi patsukan ee tan buur ravainy masarau? A vainy tsumi patsukan te faatok iny rora fo iring tsumi! ");
INSERT INTO sps_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A sikia ma Belsibul, u Aaven Taabos ten Gov to ayei te faan Vanyo na parits iny buur ravainy masarau faatok iny non a Waan Ya te naa bus naa me tsumi. ");
INSERT INTO sps_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“A sikia ta mes te onot non ma sof a numaa tana mes a parits a fag to na fo mamatsiny ka tsunia onot non tsunia ma kotskots tsom a mes a parits to, vou ya te see sofsof a numaa tsunia ya te fag a fo mamatsiny ka. ");
INSERT INTO sps_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“A mes a gima vaatau Tsonyo, ayei te iring Varonyo, ai sei na mes te gim non ma faakouts Vanyo ma favaaguam ir a vainy ee, ayei kat raror a vainy ma bus vavakas ari. ");
INSERT INTO sps_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tan kat to aya, Nyo tsue of maromi na fo mamatsiny kat iring te natiny kat ror a vainy ge te tsue rori Gov anofe ravainy non ya, san e sei te tsue vaaserere iny non Aaven Taabos ee Gov sikia on non ma anofe ravainy ya. ");
INSERT INTO sps_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ai sei na mes te tsue fiiring non a Guei Tsoiny te Bobot e Gov sa ruak iny mes me Gov anofe ravainy non ya; san ten sei te tsue fiiring non Aaven Taabos ee, Gov sikia on non ma anofe ravainy kat iring tsunia roman ai vou tana saa, ayei te kat kat iring suu.” ");
INSERT INTO sps_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jisas tsue pis to, “U nau rof kaa minon fuan rof. An nau iring kaa minon fuan iring. Te iring fi non nau u fua nan ya kan iring. Vainy natiny tagei faamuainy ror fua ri te natiny nau te rof fi non ya ge te iring fi non ya. ");
INSERT INTO sps_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Amin guei tan koraa amin vainy gamgam! Kat fei sam tsue iny rom a ka na rof to te via non koma mami na fo iring ei? Ton ngue pokei non fakats te via non komam. ");
INSERT INTO sps_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A mes a rof te pokei minon fo fakats tsuan a fo rof via non koman ya ana mes a iring te pokei minon fo fakats tsuan a fo iring via non koman ya. ");
INSERT INTO sps_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nyo tsue of maromi na ka to tan nainy vaatsuk ten Gov, vainy faavot tsutsun ror ri te tsue of e Gov, tana saa te vegiau iny ari na tan vegiau pinpin te kat ari, ");
INSERT INTO sps_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","tana saa, tan vegiau patsukan tsumanyi nai tsuk marom anyi an vegiau patsukan tsumanyi nai fatavaron marom anyi, ge vegiau tsumanyi nai sigan marom anyi.” ");
INSERT INTO sps_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ana mesapan tsurin tsoiny fifaatsuts tan Faun te kirkir iny e Moses ana mesapan tsurin Farasi tsue to ten Jisas, “Tsoiny fifaatsuts, mam komainy marom Anyi ma faatok mamimam ta kainy faatok ma nat fi mam nei Nyi kat rom a binun ten Gov.” ");
INSERT INTO sps_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisas biny ratuari sa tsue, “Amin vainy tan nainy roman, amin ngi'arapaar an gima kaa fasuu ten Gov, tana saa mi rangat Varonyo ma kat kainy faatok, sana sikia ta ka ta foun iny faatok mami sana kainy faatok mami to tan kainy faatok tsun to ten Jona na Kuigin. ");
INSERT INTO sps_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona kaakaa en koman tsinai nana meinainy onots fopis a nuaf ana fopis a voiny jesan kan te nai kat fi nats non a Guei Tsoiny te Bobot e Gov sa ruak iny mes me kaa non koman puputaa onots non a fopis a nuaf ana fopis a voiny. ");
INSERT INTO sps_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tan nainy vaatsuk ten Gov taa Ninive nai tsutsun ror tan vaatsuk ana ri te pokei aveto tsumi, tana saa, taa Ninive te takopis osing a fo aveto tsuri te nongon fi ri te favaanan fi Jona. Sai te kaa minon a mes fapoopoan namami te karap fafisfis pis iny non e Jona ana mi gim to ma nongoiny kainy Ya am takopis to. ");
INSERT INTO sps_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tan nainy vaatsuk ten Gov Muiny Aatouf tana gum fan iny Siba tana ainysat iny vou nai tsutsun non tan vaatsuk ai te pokei aveto tsumi tana saa, a Muiny Aatouf to te poo fi me veevian a tou nongon tana fo fifaatsuts rof ten Solomon a Aatouf a mes a nat, sai te kaa minon a mes fapoopoan namami te karap fafisfis pis iny non e Solomon sana mi gima nongoiny Ya am faarof Towa.” ");
INSERT INTO sps_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas tsue pis to na ka, “Nainy te tafuts osing non a masarau a mes, masarau to ayei naa vavis non tana pan a parak a uur a tsikoo vavis to ta pan ma favusuan ya. Te gim fi non ya ma sab ta pan, ");
INSERT INTO sps_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ya tsue to na ka, ‘Kainon, nyo ma tabin you tana numaa te naus osing mi nyo.’ Ayei te naa, ya te tagei na numaa na uur ana fifio vatsvats ana foka te kaa faarof tsun ror. ");
INSERT INTO sps_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ya te naa, a nom pis mito na ina fits a masarau, ngi'arapaar fafis pis iny ror ya er kaa to na aya. Ana mes to aya te nai nun fapinpin ovei en fis non a fo nun te kaa mi ya muan. Jesan kan te kat fi nats romin vainy ngi'arapaar tan nainy roman.” ");
INSERT INTO sps_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas vegiau kanen nanon tana vainy ai tsinan Ya an famuinyasiny Tsunia ruak mito ri tsutsun to jiarasan pon iny ma vegiau fiisen mi Ya. ");
INSERT INTO sps_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Isen tsuri na vainy tsue to ten Jisas, “E tsinamanyi an famuinyasiny Tsumanyi te tsutsun ror tuwa jiarasan komainy marom Anyi.” ");
INSERT INTO sps_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisas biny towa, “E sei tsinanyo ee? Ai sei fuainy famuinyasiny Tsonyo ee?” ");
INSERT INTO sps_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ya tsitoo na ton matisian Tsuan Ya tsue to na ka, “Tagaa! U fuainy tsinanyo an fuainy famuinyasiny Tsonyo to ari! ");
INSERT INTO sps_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tana saa, e sei tsun te kat non mangiir ten Tamanyo iny Gormirmir ee ayei famuinyasiny Tsonyo, fafinevanyo ai tsinanyo.” ");
INSERT INTO sps_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tan voun nainy to aya, Jisas naus osing a numaa ana Ya naa to sa gumgum en tatangin a naaman. ");
INSERT INTO sps_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A fokinai vaaguam ser bau faafis Ya, tsurin kinai fiisok, Jisas jias enato tan puak ana Ya gum to ana fokinai tsutsun er teis. ");
INSERT INTO sps_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jisas faatsuts iny a ka na kinai tan tsue fapapaar ana Ayei tsue of ratuarin tsue fapapaar to, “A mes iny rereev tanun te nai saats iny fua. ");
INSERT INTO sps_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te piat iny yan fua koman a tanun an mes fua gotsiny to sanaan an marei naa mito ser ainy ya. ");
INSERT INTO sps_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mes a fo fua gotsiny to tan puputaan fatsfats te kaa men ar kakaiiny puputaa tsun. An fua gian veesau tsun nato, tana saa, u puputaan sikia ma boo. ");
INSERT INTO sps_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Te paas me na nuaf jias ya nang to ana foka maas faavot enato, tana saa, u guan te sikia ma sua fagagon naa. ");
INSERT INTO sps_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","An mes fua gotsiny to tan puputaa te kaa men fua nan kakarits gagon tan puputaa fapoopoan narari an kakarits gian to ser pis ya sa sikia ma kaa me tu fua. ");
INSERT INTO sps_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","San mes a fo fua gotsiny tana pan te kaa men puputaan rof, koo ser gian ri karap to ser kaa men fua, mes fua sa onots tonuafunuun fua, mes aunom safunuun fua, an mes isen natus fua.” ");
INSERT INTO sps_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jisas tsue pis to na ka, “Mes kaa minon teinan iny nongon ma nongon faarof.” ");
INSERT INTO sps_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","An matisian naa mito ten Jisas ser rangats Ya, “Kat fei sa Nyi vegiau iny rom tsue fapapaar tana fokinai ka ei?” ");
INSERT INTO sps_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisas biny ratuari sa tsue, “Tsue te gim ami ma natiny muan nana Waan iny Gormirmir te tsue bus iny Ya tsumi san e Gov gima faatok ir mes a vainy. ");
INSERT INTO sps_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ana mes te kaa minon a nat Gov fainy pis non ya na nat fis pis non a nat te kaakaa mi ya ana ya te kaa me na nat a onot, sana mes te gim non ma komainy a nat Gov nom ravainy non a nat a kakaii te kaakaa mi ya. ");
INSERT INTO sps_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kifon a ka Tsonyo tsue tan tsue fapapaar tovei, ri matoong ror sana ri sikia ror ma tagaa fanatnat iny ya. Ri nongon ror sana ri sikia ror ma nongon fanatnat iny ya. ");
INSERT INTO sps_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","An tsue to te pokei iny e Aisaia na kuigin muan nai ruak iny man ovei nato roman, ‘Ari nongon ror sai te nongon tsun ror, ri sikia ror ma nongon fanatnat iny ya; ri matoong ror sai ri matoong tsun ror, ri sikia ror ma tagaa fanatnat iny ya, ");
INSERT INTO sps_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","tana saa, u fakats te nun ovei en to ser pip a teinar, ri kaput tap iny to na matar kat ror ser tagaa fanatnat, ri te nongon fanatnat an fakats tsuri te arasan me ri te nat, ana ri te takopis osing aveto tsuri er takopis mito Tsonyo, ana Nyo te anofe ravainy aveto tsuri,’ te tsue fi Gov. ");
INSERT INTO sps_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ai to tsumi, Gov faparits mami, tana saa, a mata mami te matoong non ana teina mami te nongon fanatnat kanen. ");
INSERT INTO sps_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Fakats yam a ka to! U fuainy kuigin an vainy ten Gov muan te komainy fiisok ma tagei na foka te tagei ami te kat Anyo sana sikia. Ri pon to ma nongoiny a foka te nongoiny ami te tsue iny Anyo, sa sikia kanen.” ");
INSERT INTO sps_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jisas tsue pis to na ka, “Nongon yam, am natiny ton man nan tsue fapapaar nana mes te saats fua tanun. ");
INSERT INTO sps_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tsurin vainy te nongoiny vurungan nana Waan iny Gormirmir ser gima arasan faarof iny ya te faarei raror fua te gotsiny sanaan. Vinasaar naa me sa nom ravainy veesau tsuiny vegiau te kaa aave rari. ");
INSERT INTO sps_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","An mes fua te gotsiny tan puputaan fatsfats faarei raror a vainy te nom vegiau ser paparaa mi ya, te nongoiny finy ari ya. ");
INSERT INTO sps_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sai te gima kaa fagagon naa aave rari, to ayei na ka te gima kaa fapotsian of ya aave rari. Tan nainy patang ge na kamits te ruak non tana saa ri faamainy vegiau ten Gov, ri faravaa veesau tsun iny ton vegiau ten Gov te kaa aave rari. ");
INSERT INTO sps_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","An mes fua gotsiny to koman puputaa te kaa men fua nan kakarits gagon faarei raror vainy te nongoiny vegiau sana ri koma patang fiisok iny a toto tan puputaa to ai tana masun to te komainy fiisok rori, to ayei na ka te kat fasasapam of rorin vegiau ten Gov to sa gima fua. ");
INSERT INTO sps_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","An mes fua gotsiny to tan puputaan rof te faarei raror vainy te nongoiny vegiau ten Gov ser arasan iny ya, ri faarof iny ya ser fua faarof, mes fuan kiok, mes fuan kinai, an mes fuan kinai fiisok.” ");
INSERT INTO sps_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas tsue of pis ratuari na vainy mes tsue fapapaar. “A Waan iny Gormirmir faarei non a isen a mes te saats fuan rof tanun tsuan. ");
INSERT INTO sps_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tana isen a voiny te goros a fokinai ana mes koma iring iny a mes to ayei naa mito sa piat vavis iny fua nana aufing a iring koman tanun wit ya naa enato. ");
INSERT INTO sps_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Te gian men wit sa kakoun ma fua, ana aufing a iring gian kan to, ");
INSERT INTO sps_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tsoiny binun tan taman tanun to ayei naa me ser tsue na ka tsunia, ‘Tsunaun, u fuan rof te reev anyi tanun tsuam; fei poo me na aufing a iring ei?’ ");
INSERT INTO sps_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ya biny ratuari, ‘A mes te koma iring vanyo ayei te kat, kat to.’ Ri rangats towa, ‘Nyi komainy maromam ma patpat ravainy a aufing a iring to?’ ");
INSERT INTO sps_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ya biny ratuari, ‘A sikia, tana saa, kat rom sam pon ma pat a aufing a iring mi te pat fapiny wit. ");
INSERT INTO sps_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tanyir yam wit ana aufing a iring ma gian faavot mi ri ai tan nainy agio nyo nai tsue of rarou vainy agio ma pat faamuainy tsom ari na aufing a iring, er kotskots faavots ratuari, ri te ravaa rari tan guaf; ana ri te farosoo ir wit ri te fakaa rari tana numaa iny fatamaar tsonyo.’” ");
INSERT INTO sps_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas tsue of pis ratuarin mes tsue fapapaar, “A Waan iny Gormirmir te faarei non fua nan Mastat, a mes te nom ya sa reev ya tanun tsuan. ");
INSERT INTO sps_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Te kakaii fafis iny non a fo fua, sai te gian non ya ai te kaatsian fafis pis. Te gian faarei non nau, ma naa men marei er kat to na fo sai tsuar tana fo naan nan ya.” ");
INSERT INTO sps_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas tsue of pis ratuarin mes tsue fapapaar, “A Waan iny Gormirmir te faarei non ar kakaii iny Yis te nom a moun ya sovaar vavis towa koman kobuu parawa vou an parawa faavot to aya tsub faavot nato.” ");
INSERT INTO sps_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas pokein fo tsue fapapaar to, te fafaatsuts Ya na fo mamatsiny ka tana vainy faavot Ayei gima kuar ta fo mes ta fo sanaan, Ayei vegiau fatatabin iny a fo tsue fapapaar. ");
INSERT INTO sps_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ayei te kat, kat to ma ruak iny man men vegiau tana isen a kuigin muan te tsue tsuk iny Ya Jisas, “Nyo nai pokei rou tsue fapapaar te vegiau Ronyo tsuri; Nyo nai tsue of rarori na fo mamatsiny kan takop muan fiisok te tapogaar me na monaagits to, onot kan non tan nainy roman.” ");
INSERT INTO sps_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas naus osing a vainy ana Ya naa fi enato numaa. Matisian Tsunia naa mito Tsunia ser tsue, “Fa'arasainy of mamimam man nan tsue fapapaar nana aufing a iring.” ");
INSERT INTO sps_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas biny ratuari, “A mes te reev fuan rof tanun, te faarei non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me. ");
INSERT INTO sps_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","U tanun ayein a monaagits to; an fuan rof iton vainy te fasito iny ror a Waan iny Gormirmir; ana aufing a iring ito na vainy te fasito iny ror a Mes A Ngi'arapaar, ");
INSERT INTO sps_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ana mes a koma iring to te piat vavis iny fua nana aufing a iring, ito na Vinasaar. Nainy agio iton nainy te kap non a monaagits to, an vainy agio iton fuainy morena. ");
INSERT INTO sps_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ai to na aufing a iring te farosoo faavot non ya te faakoor tan guaf nai faarei non jesan tan fafakap nana monaagits to, ");
INSERT INTO sps_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","a Guei Tsoiny te Bobot e Gov sa ruak iny mes me nai jiat ramiror fuainy morena Tsuan, ri te nom ravaa rari tana Waan Ya, iton fo mamatsiny ka te amus ir a vainy ana rin vainy katkat, kat tana ngi'arapaar, ");
INSERT INTO sps_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ri nai ravaa rarori tan guaf akakoor tana pan iny fasaraa, unya aya ri nai tangis ror er kakuts ngiisngiis to na ngiisir. ");
INSERT INTO sps_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","An vainy tavaron ten Gov nai kakanaf faarei ror a nuaf tana Waan ten Tamarari. A mes te kaa minon teinan iny nongon ma nongon faarof!” ");
INSERT INTO sps_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ai Jisas tsue pis to, “A Waan iny Gormirmir te faarei non a guuv iny fakaa moni a via tsitapuu a famun koman a tanun. A mes te katskats tanun sab towa ya famuiny pis towa. Ayei mamagat fiisok enato ya naa to sa fafiifoiny iny a fo mamatsiny ka tsunia te kaa mi ya, ana ya tabin to sa foiny tanun to aya. Ana ayei tsue to, ‘Nyo bus fasito iny rou a painy moni tana guuv tovei.’” ");
INSERT INTO sps_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas tsue pis to na ka, mes tsue fapapaar to, “A Waan iny Gormirmir te faarei non a mes te komainy foiny fiisok non a rovus a saavits fiisok. ");
INSERT INTO sps_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Te tagei finy ya na isen a saavits fiisok ya naa to sa fafiifoiny iny a fo mamatsiny ka te kaa mi ya, ana ya foiny to na rovus to.” ");
INSERT INTO sps_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas tsue pis to, u mes tsue fapapaar to, “A Waan iny Gormirmir te faarei non a muav te tats iny ari namaan san fo viir jian ot. ");
INSERT INTO sps_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te tsup a muav men jian tsoiny nawaan ras fasung to na muav mats, ser gum ri pisainy ton jian, jian rof fau ari tana vonaa, an mes jian iring te ravaa. ");
INSERT INTO sps_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tan fafakap nana monaagits to, te kat fi non jesan, u morena te naa miror ri te pisan ir vainy tavaron, ");
INSERT INTO sps_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","an vainy iring te ravaa ror tan guaf akakoor tana pan iny fasaraa, unya aya ri nai tangis ror er kakuts ngiisngiis to.” ");
INSERT INTO sps_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ai Jisas rangats ratuari, “Ami te arasan kan iny a fo vegiau te pokei anyo?” Ana ri biny Towa, “Eye.” ");
INSERT INTO sps_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ai Jisas tsue to na ka, “Te kat fi non nei, isisen tsoiny fifaatsuts tan Faun te kirkir iny e Moses nat bus kan iny Waan iny Gormirmir, kat faarei non a taman a numaa tsian, ya nom to na ka na fo foun tsuan an tee mes kan tamuan sa tatafas rari na mesapan. Te kat fi non jesan, ami ma naa am faatsuts iny ton vegiau faamuan ten Gov an vegiau Tsonyon foun.” ");
INSERT INTO sps_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te pokei fakap bus e Jisas a fo tsue fapapaar to, Ya naus osing to na pan naa to aya. ");
INSERT INTO sps_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ana Ya tabin fatabin enato tana ngats fan tsuan. Ya faatsuts to tana numaa iny fafaatouf tsuri, ana ri to te nongoiny Ya saar ser rangat, “Fei te nom a mes to na nat ana parits iny kat a foka iny faatok reits to ei? ");
INSERT INTO sps_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ayei koraa na guei tsoiny tana tsoiny fatsun numaa! Ai Meri, na tsinan Ya, ai ere Jemis me Josep ai Saimon me Judas fuainy famuinyasiny Tsunia! ");
INSERT INTO sps_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","An fuainy fafinen Ya te kaa kan ror tovei! Fei te nom Ya na nat ana parits iny kat a fo mamatsiny ka to, ei?” ");
INSERT INTO sps_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ana fokinai fataivou Towa. Jisas tsue to tsuri, “A kuigin te natiny famaari rori tan fo mamatsiny pan sai tana ngats fan tsunia fatoobing ai tana fo nuatsin ya fatoobing, a sikia.” ");
INSERT INTO sps_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ayei gima kat a fo binun iny faatok reits na aya, tana saa, ri na sikia ta faaman. ");
INSERT INTO sps_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tan nainy to aya Herot a aatouf tana gum fan iny Galili nongoiny e Jisas te kat finy ya na foka. ");
INSERT INTO sps_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ya tsue to tan tsoiny binun tsuan, “Ayei koraa Jon a Tsoiny Fapeenan to te tsun fatabin tana mat to sana fo mamatsiny parits iny faatok tapokaa ising me tsunia.” ");
INSERT INTO sps_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tabuiny mat non e Jon a Tsoiny Fapeenan, ai Herot faan iny ton tsue ma nots ari ya, ri te nai kotskots ya, er fakei naa towa tana numaa iny kotskots. Ayei kat kat to ma kat fapaparei ya Herodias, ten Herodias peits fiisok iny e Jon, ");
INSERT INTO sps_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","tana saa, Jon a Tsoiny Fapeenan tsue ets'ets e Herot, “Te sikia non ma toobing tsumanyi ma fipisui fiisen me natsun Filip a famuinyasiny tsuam!” ");
INSERT INTO sps_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot pon ma atsuiny famat e Jon sana ayei te oraav ir a taa Jiu, tana saa, a taa Jiu te faamainy e Jon ayei na kuigin. ");
INSERT INTO sps_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tan nainy tsian te fakats fatabiny arin nainy agiir ten Herot ana guei moun ten Herodias tajiat to matar vainy faavot. Herot kaa mito na paparaa tsian, ");
INSERT INTO sps_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ana ya fakei ton tsuen man tana guei moun to, “Man non jias nyo nai faan marom Anyi na foka te rangat iny rom anyi tsonyo!” ");
INSERT INTO sps_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tan fakats tana tsinan a kooviou to sa tsue of ya, ma tsue of ya Herot, “Nyo komainy marom anyi ma poote me na patsuun e Jon a Tsoiny Fapeenan tan kobuu ana nyi te faan vanyo ya.” ");
INSERT INTO sps_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ana aatouf reesik fiisok to, san tan tsuen man tan tsue man non jias te kat ya matar a fokinai ya vovou iny ton koman tana kooviou to. ");
INSERT INTO sps_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ana ya faan iny ton tsue ma govaar mi ri na patsuun e Jon koman a numaa iny kotskots. ");
INSERT INTO sps_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ri govets mito na patsuun e Jon gagon poote mi rin kobuu, ri faan iny towa tana kooviou, ana ya govets naa towa ten tsinan. ");
INSERT INTO sps_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Matisian ten Jon naa me, ri nom to na puan ya, ser nai kats iny ya, ri naa to ser tsue of e Jisas. ");
INSERT INTO sps_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te nongoiny fakap bus e Jisas vaanan to, Ya naus osing to na fan to aya ana Ya jias to tan puak sa naa fi en nanaa tana pan a uur ayei patsukanen. Tagin nongoiny e Jisas te naa fi naa Ya, ri naus osing to na fo ngats fan tsuar ser vovou iny naa Ya sanaan. ");
INSERT INTO sps_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Te sung naa ri ai Jisas of osing ton puak ai tan nainy te tagei Ya na vainy a kinai fiisok aaven Ya kaa miton tagtag tsuri, ana Ya tsipaar to na fo faadis tsuri. ");
INSERT INTO sps_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Te touraf busen an matisian Tsunia naa mito Tsunia ser tsue na ka, “Te kat iny ananerof osto ana pan a uur tovei, jiat ra naa na vainy ma naa ri tana fo fan er foiny to ta kainy ainy ma ainy ari.” ");
INSERT INTO sps_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisas biny ratuari sa tsue, “Ri sikia ror ma naa. Mi patsukanem yam ma faan rari ta kainy ainy.” ");
INSERT INTO sps_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“A ka te kaa tsun miromam to, a ngim a koinykoiny ana fuan a jian,” biny finy ari Jisas. ");
INSERT INTO sps_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisas tsue to, “Faan Vanyo yam.” ");
INSERT INTO sps_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ya tsue of ton tagin ma gum ari tana aufing: ana Ya nom to na ngim a koinykoiny ana fuan a jian, Ya matoong fi naa to Gormirmir, sa faarof naa ten Gov. Ya ivoo ton koinykoiny, sa fafaan iny ya tan matisian Tsunia, ri tatafas iny towa tana vainy. ");
INSERT INTO sps_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Fokinai te ainy ser viits. An matisian Tsunia nom to na safunuu an fuan a koverok ser fau favei yan ainy osing. ");
INSERT INTO sps_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Onots toromainy a ngim a tapan mes to te ainy gima as'as faavot ramen moun min guei kakaii. ");
INSERT INTO sps_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ai Jisas jiats raton matisian Tsunia ma jias ari tan puak er mumua fi naa to tan mes panaan nana naaman, Tsunia te komainy ma fataasua tsom ir a fokinai er vavakas to. ");
INSERT INTO sps_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Te fataasua fakap Ya na vainy, Ya paas fi to tana painy tet a tou faakats, Ayei tsivon. Te uurup bus a pan ana Ya kaa to tsivon na aya, ");
INSERT INTO sps_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","tan nainy to aya puak kan kaa busen fapoopoan nana naaman faton naa non tan kakai tana saa, ainysat tapoor me imus nan puak. ");
INSERT INTO sps_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Fapoopoan nana fopis a kilok ana aunom a kilok tana patsuu na nainy, Jisas naa fi to tsuri taan ising naa patsun a naaman. ");
INSERT INTO sps_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","An matisian Tsunia tagei Towa te taan fi mi Ya patsun a naaman ana ri oraav faavot rato. “A amatsuan” te tsue fi ri, ri rorojiainy faavot rato. ");
INSERT INTO sps_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sen tsun Jisas vegiau naa to tsuri sa tsue na ka, “Kaa faparits yam! Anyo vaa ei aa. Oraav vaare yam!” ");
INSERT INTO sps_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ai Pita tsue to, “Tsunaun, ma Nyi koraa Ya, jio, tsue of you ma taan fi naa nyo Tsumanyi patsun a naaman.” ");
INSERT INTO sps_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Taame!” biny finy ya Jisas. Ai Pita of osing ton puak ya tanik iny taan fi naa to ten Jisas, taan naa patsun a naaman. ");
INSERT INTO sps_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sai tan nainy te tagei e Pitan rau sa oraav, ya tanik iny ruk busen nato koman a naaman. “Saup you, Tsunaun!” tangis fi ya. ");
INSERT INTO sps_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sen tsun Jisas faarua naa to na niman ya ras towa sa tsue, “A faason tsumanyi Tsonyo na kakaii! Kat fei sa nyi vaa'ets rom ei?” ");
INSERT INTO sps_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ri jias faavot to koman puak ana ainysat sariof to. ");
INSERT INTO sps_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","An matisian te kaa koman puak fatukun to, ser faatouf e Jisas. “U man ovei, Anyi na Guei Tsoiny ten Gov!” te tsue fi ri. ");
INSERT INTO sps_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tan nainy te guas naa ri, ri nai sung to tana pan iny Genesaret ");
INSERT INTO sps_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ana vainy inainy to Jisas. Ri kuar vavis ton mamatsiny fan ser nom ir a men vainy faadis ten Jisas. ");
INSERT INTO sps_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ri sing maamaa Jisas ma famanat rarin vainy faadis ma saras tsuiny korei arin nguen vau ten Jisas, ana ri to te saras nguen vau Tsunia tsipaar rato. ");
INSERT INTO sps_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ri na tee Farasi ana rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses to te poo fi me tana ngats fan tsian iny Jerusalem vaaguam faavot fi to ten Jisas, ri rangats Towa, ");
INSERT INTO sps_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kat fei san matisian Tsumanyi gim ror ma vovou iny kat tan fuainy tsuvurara ei? Tana saa ri gim ror ma garus faarof tsom a nimar, vou ri te see ainyainy.” ");
INSERT INTO sps_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas biny ratuari, “Kat fei sam gim rom ma vovou iny Faun ten Gov to sam vovou iny rom kat tan fuainy tsuvumami ei? ");
INSERT INTO sps_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gov te tsue, ‘Fatsiitsii yam e tamamami ai tsinamami,’ ai ‘Sei na mes te fijiar non e taman ge tsinan ee ma atsun famat ravaa!’ ");
INSERT INTO sps_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sana mi tsue faarof rom a mes ma kaa me ta ka te onot non tan faakouts ya taman ge tsinan, sana ayei tsue, ‘A ka to te asang of bus anyo Gov.’ ");
INSERT INTO sps_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Sana ayei gim non ma faakouts e taman, tan kat to aya mi kat rom vegiau ten Gov ka babainy mi vovou iny ton kat tsumi patsukanem yam. ");
INSERT INTO sps_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Amin vainy kat mapam vegiau tsumi an kat tsumi gima senviir! E Aisaia na kuigin te tsue fatoobing en muan to te pokei fi mami ya! ");
INSERT INTO sps_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘A vainy to te faatouf Varonyo tana pengot nana ngue rari, sana aave rari veevian osing Varonyo. ");
INSERT INTO sps_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ri fafaatouf babainy tsun Varonyo, tana saa, ri fafaatsuts iny ror faun tana mes tsun sa faarei non Faun ten Gov!’” ");
INSERT INTO sps_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ai Jisas fikoo rato na fokinai sa tsue tsuri, “Nongon yam am natiny towa! ");
INSERT INTO sps_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sikia ta ka iny jiarasan te onot non ma naa koman a mes a kat fifiiring towa, a sikia, a ka te tafuts ising minon koman a mes te kat fifiiring non ya.” ");
INSERT INTO sps_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","An matisian Tsunia naa mito ser tsue, “Nyi nat kan ir a taa Farasi te koma iring iny vegiau te pokei Anyi?” ");
INSERT INTO sps_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisas biny ratuari, “A fo mamatsiny fareevreev te gima reev e Tamanyo Gormirmir nai pat ravaa ror. ");
INSERT INTO sps_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Fakats vaare ir yam! Arin tsoiny mumuan mata kio ai tovei te ras fi naa non a isen a mes a mata kio na mesmes tsuan, ri ina fuan tsidup faavot eraror koman a gaguur.” ");
INSERT INTO sps_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita tsue to, “Tsue of mamimam kifon tsue fapapaar.” ");
INSERT INTO sps_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisas tsue to tsuri, “Mi fapinpin kanem marom? ");
INSERT INTO sps_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mi gim rom ma nat fi nei, a ka iny jiarasan te naa fi non koman na mes naa fi naa non tan mokoor ana ya te nai taagio ravainy ya. ");
INSERT INTO sps_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sana ka te ruak ising minon nguen a mes poo fi minon koman ya, ito ayei te kat fifiiring non a mes. ");
INSERT INTO sps_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ito te ruak minon aaven a mes, ton fakats iring, an kat iny fitokon, kat iny tsikoor, fifiinaum, fipisui, kakabuts, gamgam an tsue fifiiring a mesmes. ");
INSERT INTO sps_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Fo kat iring to aya poo ising minon koman a mes, ya te kat fifiiring ya. Sai tan nainy ainy men niman gima garus ayei na ka te gim non ma kat fifiiring a mes.” ");
INSERT INTO sps_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas naus osing to na pan to aya sa naa fi en naa naa tana pan panan a fuan a ngats fan iny Taia ai Saidon. ");
INSERT INTO sps_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","A muiny Kenan a sikia ma faarei na muiny Jiu to te natiny kaakaa non tana pan naa to aya naa mito Tsunia sa tsue na ka, “Tsubnaain ten Devit tagtag vame! A guei moun tsonyo na tutuei iny masarau ana ayei gima kaa faarof non.” ");
INSERT INTO sps_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sen Jisas gima vegiau vaarik ta ar vegiau tsunia. Matisian ten Jisas naa mito Tsunia ser tsue na ka. “Gargar naa! Ayei vovovou rarora fiisen men goonen kinai!” ");
INSERT INTO sps_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisas biny ratuari, “Gov jiats fi Vaminyo tan guei nun iny Isrel.” ");
INSERT INTO sps_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kat to ana moun naa mito sa fatukun en matan Ya, “Faakouts you, Tsunaun!” tsue fi ya. ");
INSERT INTO sps_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisas biny towa sa tsue na ka, “Te gim non ma toobing tan fa'ainy ir kas a kainy ainy tan guei kakaii.” Jisas tanaf fakats tana moun. ");
INSERT INTO sps_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ya biny Towa sa tsue, “Man ovei Tsunaun, san kas natiny ainy ror ainy farurus tan guei kakaii fain a taran.” ");
INSERT INTO sps_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ai Jisas biny towa, “Moun faason tsumanyi Tsonyo na karap! A ka te komainy anyi nai ruak enanon tsumanyi.” Ai tan ar nainy to aya guei moun tsunia tsipaar fatabin enato. ");
INSERT INTO sps_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas naus osing a pan to aya Ya taan ereer fi enato tana naaman iny Galili. Ya paas fi naa to tana painy tet ana Ya vaagum to. ");
INSERT INTO sps_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tagin naa mito Tsunia mei men fo mou ra pengong, fo mata kio, fo mour mat, fo baaruu, fo teinar kuupio ana fo mes fo viir faadis to ser fakaa rari moun e Jisas ana Ya tsipaar ratuari. ");
INSERT INTO sps_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Vainy saar fiisok te tagei finy ari na fo baaruu te vegiau fatabin, fo mou ra pengong rof fatabin ner, fo mou ra mat tataataan fatabin ner ana fo mata kio tagaa fatabin ner, to ser vamarits a Gov tana taa Isrel. ");
INSERT INTO sps_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas fikoo ir matisian Tsuan ma naa mi ri Tsunia sa tsue na ka, “Nyo tagtag fiisok roun vainy a kinai to, tana saa ri kaa fiisen bus Vaminyon fopis nainy, ser sikia ma kaa me ta kainy ainy ma ainy ari. Nyo baainy rou ma jiat vesves ra naa ri fan tsuar, tana saa kat ror ser matauts ra naa sanaan.” ");
INSERT INTO sps_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Matisian Tsunia rangats Towa, “Fei nom roran a kainy ainy ta onot tana pan babainy ana uur tovei ei ma fa'ainy ara na vainy?” ");
INSERT INTO sps_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“A fis a koinykoiny te kaa miromi?” Ri biny Towa ser tsue, “A fits a koinykoiny ana tee mar jian a fo kakaii.” ");
INSERT INTO sps_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ai Jisas tsue of ratuari na fokinai ma gum ari tan puputaa. ");
INSERT INTO sps_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ana Ya nom to na fits a koinykoiny ana tee mar jian a fo kakaii tsue faarof naa to ten Gov, Ya ivoo towa, Ya faan iny towa tan matisian an matisian tatafas ratuarin tagin. ");
INSERT INTO sps_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ri na fokinai ainy, ser viits. An matisian nom to na fits a koverok a via taptap tan ainy osing. ");
INSERT INTO sps_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","U as'as nar tsoiny te ainy onots fats a tapan, gima as faavot ramen moun an guei. ");
INSERT INTO sps_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ai Jisas jiats ranaatuari na vainy, Ya jias to tan puak, Ya naa fi enato tana pan iny Magadan. ");
INSERT INTO sps_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A tee vainy Farasi ana tee vainy tana taa Jiu natiny faamainy ror a mes te gim non ma tsun fatabin tana mat koo rorin Sadusi naa me ten Jisas. Ri pon to ma fataraatsua Ya, ser rangats Ya ma kat of rari ta ka iny faatok, “Mam komainy nat rom to te poo faman fi mirom Anyi ten Gov.” ");
INSERT INTO sps_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ai Jisas biny ratuari, “Te ruk naa non a nuaf mi te tsue, ‘Ra kaa miror a madaav a rof tamanainy, tana saa, a koroo te a'aun en.’ ");
INSERT INTO sps_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ge tana voinyvoiny ovei mi tsue rom a ka, ‘Te nai ruat non, tana saa, a korosuu na a'aun ai te kum.’ Ami onot rom ma tsue fa'arasainy tou tatagaa tsumi tana korosuu, sana mi gim rom ma onot ma tsue fa'arasainy a foka te tagei romi ma kat Anyo tan nainy roman! ");
INSERT INTO sps_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Amin aatai iny roman, amin ngi'arapaar an gima kaa fasuu ten Gov! Mi rangat Varonyo ma kat kainy faatok, sana sikia ta ka ta foun iny faatok mami sana kainy faatok tsun to ten Jona na kuigin muan.” Ai Jisas naus osing ratuari sa naa en. ");
INSERT INTO sps_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Te sepuu faguas naa ri tan mes panaan nana naaman, ri anofe to ma tamaar iny naa tu koinykoiny. ");
INSERT INTO sps_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas tsue to tsuri, “Taatag yam, am tatanamots ton yis tana taa Farasi ana ri na taa Jiu te gim ror ma faamainy a tou tsun fatabin tana mes tana mat koo rorin Sadusi.” ");
INSERT INTO sps_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ri tanik iny favevegiau buser rato fapoopoan narari, “Ayei te tsue na ka to, tana saa, ra gima tamaar iny me tu koinykoiny.” ");
INSERT INTO sps_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas natiny a ka te vegiau tsuk iny ari ana Ya rangats ratuari, “Kat fei sam favevegiau rom fapoopoan namami ei te sikia ma kaa fi tu koinykoiny ei? Faason tsumi Tsonyo na kakaii! ");
INSERT INTO sps_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mi tabuiny nat rom ge? Fakats fatabin yam tan nainy to te ivivoo Nyo na ngim a koinykoiny tan ngim a tapan mes, fis a koverok a via taptap tan ainy osing te fau ami? ");
INSERT INTO sps_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Fakats fatabin yam tana fits a koinykoiny tana fats a tapan mes? Fis a koverok a via taptap tan ainy osing te fau ami? ");
INSERT INTO sps_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kat fei sam gim rom ma nat faarof ei? Tsonyo te gima vegiau tsuk mami tan koinykoiny. Tatanamots yam a tsivom tan yis tana taa Farasi ana tee vainy tana taa Jiu te koo rorin Sadusi!” ");
INSERT INTO sps_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","An matisian natiny Towa te gima vegiau tsuk iny yis faman nan koinykoiny to tsuri ma tatanamots ari, a sikia, sana fo faatsuts te poo minon tana taa Farasi ana rin vainy tana taa Jiu te gim ror ma faamainy a tou tsun fatabin tana mes tana mat te koo rorin Sadusi. ");
INSERT INTO sps_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas naa fi naa tana pan iny Sesaria Filipai, ana Ya rangats raton matisian Tsunia, “A vainy tsue rora Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, e sei ee?” ");
INSERT INTO sps_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Mesapan tsue ror, Anyi Jon a Tsoiny Fapeenan,” biny finy ari Ya, “Ana mesapan te tsue ror, Anyi Ilaija, ana mesapan tsue ror, Anyi Jeremaia ge na isen tan mes panainy kuigin to te toto fatabin me.” ");
INSERT INTO sps_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Ana mi pas?” rangat fi rari Ya, “Mi tsue Varonyo sei?” ");
INSERT INTO sps_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita biny Towa, “Anyi na Krais, a Mes to te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy, a Guei Tsoiny tana Gov a toto.” ");
INSERT INTO sps_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Gov faparits bus manyi Saimon, a guei tsoiny ten Jona,” biny finy ya Jisas, “tana saa, a man nan vegiau to gima poo fi me tana mes, sai te naa fatoobing fi me tsumanyi poo fi me ten Tamanyo i Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ana Nyo tsue of marom, Nyo koo marom anyi na fats a marats, Pita, ana fats a marats to te faarei non a man, ai patsun a man to ayei, Nyo nai fatsuiny rou a numaa iny fafaatouf Tsonyo ito na gum iny vainy fafaaman te faason Ronyo, an parits tana mat iny Hel gim on ror ma fabiu ya. ");
INSERT INTO sps_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nyo nai faan marom anyi na fo popue tana Waan iny Gormirmir, kat te gim rom anyi ma famanat iny nei petoo, Gov kan gim on non ma famanat iny ya i Gormirmir, an kat te famanat iny rom anyi petoo, Gov kan nai famanat iny non ya Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ai Jisas vusvus faparits raton matisian Tsunia ma tsue of vaare ri ta mes Ayei na Krais a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy. ");
INSERT INTO sps_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tan nainy to aya Jisas tanik iny tsue fanat of raton matisian Tsunia, “Nyo ma naa fi Jerusalem ma saraa kamits fatsian Anyo nimar tsunaun tana taa Jiu, an tsunaun tan tsoiny faakor ana rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses. Ri nai atsuiny famat Varonyo, ai tan fafofopis nan nainy Nyo nai tsun fatabin varou.” ");
INSERT INTO sps_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita mei naa Towa tatangin ana ya tsue ets'ets Towa, “Tsunaun, Gov famanat vaare iny a ka to ma ruak on ya Tsumanyi,” te tsue fi ya! ");
INSERT INTO sps_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas takopis to sa tsue ten Pita, “Fataanis osing you, Satan! Nyi bei ot iny rom a sanaan Tsonyo, tana saa u fakats tsumanyi nato ayan fakats tana mes tsun sikia ma fakats ten Gov!” ");
INSERT INTO sps_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ai Jisas tsue of raton matisian Tsuan, “Sei na mes te komainy vovou Varonyo ee, ayei ma anofe na tsivon, ayei ma fa'orovus iny a tsivon, ana ya te vovou Vanyo, ");
INSERT INTO sps_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","tana saa sei na mes te komainy makok faarof non a toto tsuan ee, nai nun enanon, san e sei te fa'orovus non a toto tsuan ee tan vovou Vanyo nai nom non a toto na suu. ");
INSERT INTO sps_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ta isen ta mes te mauts non a fo masun tana ratsuu iny peto ana toto tsunia te iring a nun enato, fo masun to aya te faakouts fi non ya ei? A sikia. A saf a tafan tana mes to na to te pats fi non ya na toto na suu tana masun tsuan na? A sikia ovei. ");
INSERT INTO sps_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa minon fiisen minon fo morena Tsunia koman siinaiv ten Taman ana Ya te nai tafan ir a fokinai vainy vovou tsun iny non kat te kat ari nei petoo. ");
INSERT INTO sps_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nyo tsue faman of maromi te kaa miror mesapan te tsutsun ror tovei tabuiny mat ror nai tagei nats ror a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa minon faarei minon a Aatouf.” ");
INSERT INTO sps_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Voun gonom nainy Jisas nom rato ere Pita, ai Jemis me famuinyasiny tsuan e Jon ana Ya mei ratuari tana tobeer a nainy jig, ri patsukaner. ");
INSERT INTO sps_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te tagaa ri ana puan Ya ruak iny pangis enato; ana nain Ya kanaf to sa faarei na nuaf an vau Tsunia faarei ton goseen kafof kakanaf. ");
INSERT INTO sps_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sen tsun ana rin matisian tagei to Moses ai Ilaija ruak ser favevegiau fiisen me Jisas. ");
INSERT INTO sps_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ai Pita tsue to ten Jisas, “Tsunaun, rof non te kaa fi rora nei te koman fi rom Anyi mam te kat ta fopis ta tovaar nei, isen Tsumanyi, ana isen ten Moses, ana isen ten Ilaija.” ");
INSERT INTO sps_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Te vegiau farokot ya, ana koroon kafof kakanaf pau ratuari an vegiau poo mito koroo sa tsue, “Tovei na Guei Tsoiny Tsonyo, te kaa non koman tsian Tsonyo. Anyo koma rof iny rou Ya; nongon yam Tsunia!” ");
INSERT INTO sps_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te nongoiny matisian vegiau tovei, ri oraav fakap rato ser fagotsiny nato na nair peto tan puputaa. ");
INSERT INTO sps_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas naa me tsuri Ya saras ratuari sa tsue na ka, “Tsun yam, oraav vaare yam!” ");
INSERT INTO sps_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ri matoong fi to jias ser gima tagei ta mes, e Jisas tsun Tsivon. ");
INSERT INTO sps_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Te of osing mi ri na tobeer Jisas tsue tap ratuari, “Pokei vaare yam a ka te tagei ami onot non te tsun fatabin fi non a Guei Tsoiny te Bobot e Gov sa ruak iny mes me tana mat.” ");
INSERT INTO sps_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ana rin matisian rangats to Jisas, “Kat fei san tsoiny fifaatsuts tan Faun te kirkir iny e Moses tsue Ilaija na kuigin ma mumua me ei?” ");
INSERT INTO sps_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Eye, Ilaija na kuigin te naa faamuan naa me,” Jisas biny rari, “ana ya te kakouiny onots fo mamatsiny ka. ");
INSERT INTO sps_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sana Nyo tsue of maromi na ka to a mes te faarei non e Ilaija na kuigin te naa ename ana vainy gim to ma inainy fanatnat iny ya, ri kat a fo mamatsiny ka na fo iring tsunia ito na sanaan te paparaa iny mi ri. Jesan kan tana Guei Tsoiny te Bobot e Gov sa ruak iny mes me nai kat non fo mamatsiny ka na fo iring Tsunia.” ");
INSERT INTO sps_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ana rin matisian natiny Towa te tsue tsuk iny non e Jon a Tsoiny Fapeenan. ");
INSERT INTO sps_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Te tabin mi ri tan tagin ana mes naa mito ten Jisas fatukun to matan Ya, ");
INSERT INTO sps_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ya tsue to na ka, “Tsunaun, tagtag a guei tsoiny tsonyo! Ayei kokonos non ai te gima kaa faarof tana saa ayei natiny gotsiny of non guaf ana aurom. ");
INSERT INTO sps_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nyo mei mi ya tan matisian Tsumanyi, ri gim to ma tsipaar ya.” ");
INSERT INTO sps_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas biny ratuari fiisen me na seeve, “Amin aatai iny roman, min vainy vavaajets an iring! Fis nainy ma kaa fiisen Vanyo mi? An fis nainy ma govets patang fiisen Vanyo mi? Mei mi yam a vurots nei Tsonyo!” ");
INSERT INTO sps_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisas buur to na masarau sa bus osing ya sen tsun ana vurots to tsipaar enato. ");
INSERT INTO sps_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kat to An matisian naa mito tana uur ten Jisas, ri rangats Towa, “Kat fei sa mam gima onot ma buur ravainy masarau ei?” ");
INSERT INTO sps_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jisas biny ratuari, “Tana saa, mi na sikia ta faason Tsonyo. Fakats yam a ka to! Te kaa fi miromi na faason a kakaii faarei non fuan kakaii nan Mastat, mi onot rom ma kat a fo mamatsiny ka! Mi onot kan rom ma tsue of a tobeer to, ‘Tasas osing a pan to nyi te naa fi unya!’ ana ya te tasas. ");
INSERT INTO sps_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","San faakats an tavtaav tsun onot non tan buur ravainy kainy masarau to aya.” ");
INSERT INTO sps_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Te naa faavot men matisian tana gum fan iny Galili, Jisas tsue to tsuri, “A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai faan iny naa rori nimar vainy te kaa miror a parits, ");
INSERT INTO sps_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ri te atsuiny famat Ya, san tan fafofopis nan nainy nai tsun fatabin enanon.” Ana rin matisian reesik fiisok tsun rato. ");
INSERT INTO sps_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Te naa me Jisas an matisian Tsunia tana ngats fan iny Kapeniam, rin tsoiny nonom takis tana saape naa mito ten Pita, ri rangats towa, “Tsoiny fifaatsuts tsumi te foiny takis of kainy non a saape?” ");
INSERT INTO sps_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ai Pita biny ratuari sa tsue na ka, “Eye!” Te sof naa Pita numaa Jisas tsue faamuan to, “Saimon, saf fakats tsumanyi na? E sei foiny non takis tana fo gotouf tan vainy petoo ee? Rin vainy tana gum fan fatoobing ge arin vainy sagoor?” ");
INSERT INTO sps_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita biny Towa, “U vainy sagoor.” Ai Jisas tsue to tsunia, “Te kat fi non nei, u vainy tana gum fan fatoobing to te gim ror ma foiny takis. ");
INSERT INTO sps_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sana ra gim ror ma fatsitsien fiisen ramiri. Kua fi naaman nyi te tats iny naan goraa, ras a vaamuan nana jian pue na nguen ya, nyi sab rom a painy moni onot non tan foiny takis tana saape of Vanyo ana nyi kan, nom naa nyi foiny of ratuaran takis.” ");
INSERT INTO sps_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tan ar nainy to aya matisian naa mito ten Jisas, ri rangats Towa, “E sei te karap non tana Waan iny Gormirmir ee?” ");
INSERT INTO sps_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisas fikoo to na guei a kakaii, sa fatsutsuiny ya fapoopoan narari, ");
INSERT INTO sps_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ya tsue to na ka, “Fakats yam a ka to! Mi gim rom ma onot ma sof on tana Waan iny Gormirmir onot romi ma takopis am faarei ton guein kakaii. ");
INSERT INTO sps_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","A mes te karap fiisok non tana Waan iny Gormirmir to na mes te fauf non a tsivon a faarei to na guei a kakaii tovei. ");
INSERT INTO sps_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ai sei na mes te faakouts non guei kakaii faarei non ya to ee tana asanga Vanyo, ayei faakouts Varonyo.” ");
INSERT INTO sps_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“E sei ta isen ta mes te ras raror guein kakaii to te faaman ror Tsonyo, tan kat iny aveto ee, te rof fafis non tan tang iny ta marats tsian googon a mes to aya, ai te nai faruk namaan bong. ");
INSERT INTO sps_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Saf a fasaraa tsian fiisok to na tana mes tan puputaa to te amus raror vainy tan kat kat iny aveto! Fo amus te kat fa'aveto non a mes nai ruak minon sana saf a fasaraa tsian fiisok tana mes te amus non a mesmes to na! ");
INSERT INTO sps_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Te amus fi marom anyi na nimam ge na moum tan kat kat iny aveto, kobus ravainy am ravaa ratuari. Te rof fiisok non tan nom a toto na suu, te kaa fiisen mirom anyin sen niman an sen mou, sai te gim non ma mamatan faarof tan kaa men fuan niman an fuan mou, kat ror ser ras manyi tan guaf te sikia non ma mote. ");
INSERT INTO sps_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ai te amus fi marom anyi na matam tan kat kat iny aveto, fas ravainy, nyi te ravainy naa ya! Te rof fiisok non tan nom a toto na suu te kaa mirom anyin sen matan, sai te gim non ma mamatan faarof tan kaa men fuan matan kat ror ser ras manyi tan guaf iny Hel te gim non ma natiny mote.” ");
INSERT INTO sps_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ai Jisas tsue to na ka, “Kat rom sam pon fi nei vainy kakaii to te faarei rora ka babainy. Nyo tsue of maromi, u morena tsuri te kaa ror Gormirmir natiny tagei fatoobing ror e Tamanyo i Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tana saa, a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, te naa me ma saup ir Ya na vainy te nun farokot ror. ");
INSERT INTO sps_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Saf fakats tsumi na? A saa te nai kat non a mes te kaa minon natus siip tsuan ana isen tsurin siip te kuar fuainy a nun to? Ayei fakaa raror sian safunuu ana sia to te gima nun er ainy to tan tet ya te nai tsikoo na mes a isen to te nun. ");
INSERT INTO sps_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nyo tsue faman of maromi te sab finy non ya na isen to te nun, ayei mamagat fiisok non fis non a mamagat tan sian safunuu ana sia na siip to te gima nun. ");
INSERT INTO sps_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jesan kan ten Tamamami te kaa non Gormirmir tsugainy non ta isen tan vainy kakaii to ari ma nun tana mat a suu.” ");
INSERT INTO sps_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Vamuinyasiny tsumanyi te kat non kat iring tsumanyi, kua tsunia nyi te tsue fatoobing of yan kat iring te kat ya, kat yam tana uur fapoopoan namami. Te nongoiny fi marom anyi ya, eye, nyi nom fatabiny bus ya. ");
INSERT INTO sps_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sai te gim finy non ya ma nongoiny manyi nom ta isen ge ta fuan ta mes, am naa faavot to ma nongoiny faarof ari tan fo vegiau te faraarar fi romi tana ina fuan, jesan te tsue fin Vegiau Ten Gov. ");
INSERT INTO sps_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sai te gim finy non ya ma nongon rari pokei yam a fo vegiau to tan gum iny vainy fafaaman. Ai to te gim fi non ya ma nongoiny a gum nar vainy fafaaman, aspeer yam, ma faarei ya na mes a vavaajets ge na tsoiny nonom takis.” ");
INSERT INTO sps_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ai Jisas tsue pis to, “Nyo tsue faman of maromi na fokinai, A ka te gim romi ma famanat iny nei peto, Gov kan gim non ma famanat iny ya Gormirmir; ana ka te famanat iny romi nei petoo, Gov kan nai famanat iny non ya Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nyo tsue faman of pis maromi te fatangan faarof fi ror a ina fuan tan ta ka te komainy faakats of rori, Tamanyo te kaa non Gormirmir te kat non koman tsuri, ");
INSERT INTO sps_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","tana saa ai to te vaaguam faavot ror a ina fuan ge ta ina pis er fakats vatuanyo tana asanga Vanyo, Nyo kaa rou fapoopoan narari.” ");
INSERT INTO sps_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ai Pita naa mito ten Jisas ya rangats Towa, “Tsunaun fis nainy te kat fifiiring varonyon vamuinyasiny tsonyo, nyo te anofen kat iring tsunia? Onots non fits nainy?” ");
INSERT INTO sps_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas biny towa sa tsue na ka, “A sikia, fits nainy te gim non ma onot, san fits safunuun nainy ana ya te nai onots ovein fits nainy, ");
INSERT INTO sps_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","tana saa, a Waan iny Gormirmir te faarei non aatouf te pon non ma fatoobing a fo tavan tana fo tsoiny binun tsunia. ");
INSERT INTO sps_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ayei te tanik iny fatoobing a tavan tsuri to sana ri mei me na isen tsuri te tavainy safunuu na tapan ana tapan painy moni. ");
INSERT INTO sps_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","A tsoiny binun sikia ma kaa me ta painy moni iny biny fatabiny a tavan tsuan, ana tsunaun tsunia faan iny ton tsuen parits ma fafiifoiny iny a tsoiny binun to aya ma faarei ya na tsoiny binun babainy, natsun ya an fuainy guei tsunia, an fo mamatsiny ka tsunia onot non te biny fatabiny non ya na tavan tsuan. ");
INSERT INTO sps_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tsoiny binun fatukun to matan a tsunaun tsuan, sing famamataaf sa tsue, ‘Anaanos faamo you, nyo biny fatabiny rou a tavan tsonyo tsumanyi!’ ");
INSERT INTO sps_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tsunaun tsunia reesik towa, sa anofe na tavan tsunia ana ya jiats naa towa. ");
INSERT INTO sps_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tsoiny binun tafuts to, ya tagei to na isen a tsoiny binun to te natiny binun fiisen minon ya ana ayei kan kaa minon a tavan tsunia onots non sen natus painy moni, sa ayei gima biny ya. Ya nots towa ana ya tanik iny ot towa, ‘Biny fatabiny me na tavan tsumanyi tsonyo!’ te tsue fi ya. ");
INSERT INTO sps_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ana tsoiny binun bibinun fiisen mi towa to te kaa minon a tavan tsunia fatukun to matan ya sa sing famamataaf, ‘Anaanos faamo you, nyo biny fatabiny rou a tavan tsonyo tsumanyi!’ ");
INSERT INTO sps_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sana ayei baainy en, ya fasof towa tana numaa iny kotskots onot non te biny fatabiny fi non ya na tavan tsuan. ");
INSERT INTO sps_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Te tagei arin mes panainy tsoiny binun te kat fi ya nei, ri peits rato, ana ri naa to tana tsunaun tsuri, ri tsue of towa na ka te ruak. ");
INSERT INTO sps_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ana tsunaun tsunia fikoo to na tsoiny binun. Ya tsue to, ‘Nyi na tsoiny binun a ngi'arapaar! Nyo anofe na fo tavan te kat a anyi tsonyo, tana saa, anyi rangat vanyo. ");
INSERT INTO sps_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nyi tabuiny tagtag kainy a mesmes a tsoiny binun to te kaa me na tavan tsunia tsumanyi faarei te tagtag finy anyo nyi.’ ");
INSERT INTO sps_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tsunaun tsunia seeve fiisok nato, ya fasof towa tana numaa iny kotskots onot non te biny fatabiny fi non ya na fo tavan tsuan.” ");
INSERT INTO sps_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ai Jisas tsue to na ka, “Jesan kan e Tamanyo kaa non Gormirmir nai kat fi non nei tsumi te gim fi romi ma anofe ravainy kat iring tan vamuinyasiny tsumi tana fo koma mami.” ");
INSERT INTO sps_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Te fakap bus e Jisas a fo vegiau Tsuan, Ya naus osing to na gum fan iny Galili sa naa fi en tana gum fan iny Judia, tan mes panaainy aurom iny Jodan. ");
INSERT INTO sps_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","An tagin a kinai vovou iny Towa, ana Ya tsipaar ratuari na aya. ");
INSERT INTO sps_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","A tee vainy Farasi naa mito Tsunia, ri tanik iny tanaf Towa tan rangat, “Te toobing kan non tana Faun tsura tana mes ma ots fanging fiisen me natsun tana fo mamatsiny kat to te koman fi non ya?” ");
INSERT INTO sps_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisas biny ratuari sa tsue na ka, “Mi gima gogosias Vegiau Ten Gov tovei? ‘Tan tatanik nan puputaa Gov fapogaar a vainy, Ayei kat faavots raton tsoiny min moun.’ ");
INSERT INTO sps_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ai Gov tsue to, ‘Tan kat to aya, a tsoiny ma naus osing e taman me tsinan ya te fanging e natsun ana ri na ina fuan te nai isen tsun me.’ ");
INSERT INTO sps_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ma faarei vaare mi ri na ina fuan, sana isen tsun. To sana mes ma pets vaare na ka te kotskots faavots bus e Gov.” ");
INSERT INTO sps_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tee vainy Farasi rangats Towa, “Kat fei, sen Moses tsue faparits tana mes te komainy ots non fanging ten natsun ee ma kirkir tsom noun iny ots fanging tana moun ma gargar ravainy ya ei?” ");
INSERT INTO sps_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas biny ratuari, “Moses tanyiny mami tan kat iny ots fanging tana saa, amin vainy pisiin, sai te gim non ma kat fi nei tan tatanik. ");
INSERT INTO sps_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nyo tsue faman of maromi, e sei na mes te ots fanging fiisen minon e natsun ee, ai natsun ya te gima tsikoor, ana mes to ayei te nai fanging pis a mes a moun, a mes to ayei kaa non tan kat iny tsikoor fiisen me na mes a moun to aya.” ");
INSERT INTO sps_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","An matisian Tsunia tsue to na ka Tsunia, “Tan kat to aya kaa non fapoopoan nar muiny mataa, sai te rof non tan gima fanging.” ");
INSERT INTO sps_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisas biny ratuari, “U fifaatsuts to te gim non ma naa of a fokinai, sai te naa of tsuiny non ere sei Gov te faan rari ya. ");
INSERT INTO sps_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kaa minon tee viir tsoiny gim ror ma fanging tana saa ari te agiir me tan tsinar, ri kaa patsukan fi raror to; an mes viir tsoiny kat fi ror to tana saa, a vainy patsukan potei rarori ma fanging vaare ri; ana mesapan baainy ror ma fanging, tana saa, ri komainy kat faarof ror a binun tana Waan iny Gormirmir. Tanyir yam te kat fi ror to, ma kat arin koman tsuar er vovou iny ton fifaatsuts tovei.” ");
INSERT INTO sps_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ana mesapan tsuri na vainy mei miton guein kakaii ten Jisas ma fasaur Ya na niman patsuu rari ana Ya te faakats of rari, san matisian tsue ets'ets rari. ");
INSERT INTO sps_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisas tsue to na ka, “Tanyir yam guein kakaii ma naa mi ri Tsonyo, tsue tap vaare ir yam, tana saa a Waan iny Gormirmir fasito raror vainy te faarei ror guei to ari.” ");
INSERT INTO sps_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ya fasaur to na niman patsuu rari, Ya faakats of ratuari ana Ya naus osing ratuari. ");
INSERT INTO sps_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ana isen a mes naa mito ten Jisas, sa rangats Ya, “Tsoiny Fifaatsuts, saf a ka na rof na te kat ronyo ma nom anyo na toto na suu?” ");
INSERT INTO sps_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Kat fei sa nyi rangat Vanyo tana ka na rof ei?” tsue fi Jisas tsunia. “Isen tsun a rof to, e Gov tsun. Sana nyi ma vovou faarof iny a fo Faun, te komainy nom rom anyi na toto na suu.” ");
INSERT INTO sps_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ya rangat to, “Saf a fo Faun na?” Jisas biny towa, “Bainy atsuiny, bainy tsikoor, bainy kabuts, bainy gamgam iny a mesmes, ");
INSERT INTO sps_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","fatsiitsii tamam me tsinam, ana nyi te mangiir fifakokoro tsuam faarei te mangiir finy rom anyi na tsivom.” ");
INSERT INTO sps_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Nyo vovou iny a fo Faun to aya,” te tsue fi na mes to aya, “a saf a ka ma kat pis anyo na?” ");
INSERT INTO sps_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas tsue to tsunia, “Te komainy kaa fatavaron fi rom anyi, kuar nyi fafiifoiny ravainy iny to na foka te kaa mirom anyi, nyi nom to na painy moni nyi fafaan ratuarin vainy aaruts, nyi te nom a masun iny Gormirmir; taame vovou you.” ");
INSERT INTO sps_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te nongoiny a see mes vegiau to, ana ya reesik fiisok nato, ana ya naa en nato, tana saa, ayei kaa me na masun a kinai. ");
INSERT INTO sps_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jisas tsue to tan matisian Tsunia, “Nyo tsue faman of maromi, Te opaar fiisok non tana mes a masun ma sof a Waan iny Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nyo tsue of pis maromi, te opaar non tana Kamel ma sof a tarobong tana tutusa, sai te opaar fafis fiisok non tana mes a masun ma sof tana Waan iny Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Te nongoiny matisian vegiau to, ri karian fiisok tsun rato. ri fararangat to. “E sei te onot non ma saup ai te nom a toto na suu ee?” ");
INSERT INTO sps_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas matoong fatoobing naa to tsuri sa biny rari, “A mes te gim non ma onot, sai ten Gov, Ayei onot non ma kat a fo mamatsiny ka.” ");
INSERT INTO sps_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ai Pita tsue to na ka ten Jisas, “Tagaa, mam naus osing a fo mamatsiny ka tsumam mam atou vovou Manyi. A saa te nai nom romam na?” ");
INSERT INTO sps_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas tsue to tsuri, “Nyo tsue faman of maromi, te nai gum non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me tan tagan siinaiv Tsuan tana Waan Ya na foun, ami na ina safunuu ana ina fuan to te vovovou Varonyo nai gum kanem marom tana fo tagan tsuam, mi te kat vaatsuk tana safunuu ana ina fuan a vun tana taa Isrel. ");
INSERT INTO sps_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ai tsuri to te faaman Vanyo ser naus osing a fo numaa tsuar, an fuainy famuinyasiny ge fafiner, an tamar min tsinar, ana fo guei tsuri ana fo tanun kan tsuri, tana saa, ri vovou Vanyo, nai nom ror a foka fis non a natus ka te naus osing mi ri, ana ri te nai nom kainy a toto na suu. ");
INSERT INTO sps_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sai tsurin vainy te kaa miror asangan karap tovei roman nai nom ror asangan kakaii, ana rin vainy te gim ror ma kaa men asangan nai nom ror asangan karap tan nainy vou.” ");
INSERT INTO sps_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“A Waan iny Gormirmir te faarei non taman tanun te toomat fi naa ya tana voinyvoiny ovei ma nom ir yan vainy binun er binun of towan tanun wain tsuan. ");
INSERT INTO sps_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ayei fatangan ma foiny ir yan vainy binun a isen a tarobong, foiny nan sen nainy, ya jiats ratuari ma nai binun tanun wain tsunia. ");
INSERT INTO sps_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ya naa fatabin fi nato tana tuan tana sia na kilok, ya tagei ton mes vainy tsutsun ror sikia ta binun. ");
INSERT INTO sps_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ana ya vegiau of ratuari, ‘Mi kan ma nai binun of vanyon tanun wain tsonyo, nyo te foiny mami na foiny a rof.’ Ri naa bus rato. ");
INSERT INTO sps_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tana safunuu ana fuan a kilok, ya tabin to tana tuan, a tou san ir ta mes iny binun, ai tana fopis a kilok ya tabin pis to. ");
INSERT INTO sps_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nuaf tageer, sisiruiny nom a ngim a kilok ya tabin pis fi to tana tuan ya tagei ton mes vainy tsutsun kaner raror na aya. ‘Kat fei sam kaakaa babainy rom ei, a sikia ta binun?’ te rangat finy rari ya. ");
INSERT INTO sps_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ri biny towa ser tsue na ka, ‘Tana saa a sikia ta mes ma foiny mamam.’ ‘Rof non, kuar yam, am binun of vatuanyon tanun wain tsonyo’, tsue fi ya tsuri. ");
INSERT INTO sps_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Te ananerof busen taman tanun tsue of to na tatagaa ot tsuan, ‘Fikoo ir vainy binun nyi te foiny rari, tanik tan vainy binun te naa fatouraf naa, nyi te nai fafakap naa tan vainy binun te tanik tan tatanik nana binun.’ ");
INSERT INTO sps_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Vainy binun tanik tana ngim a kilok nom a foiny tsuar onots a isen a tarobong. ");
INSERT INTO sps_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ana rin vainy binun te tanik faamuan nai nom mito na foiny tsuar, ri pon ma nom fapaas; sana ri kan nom senviir foiny a isen a tarobong tan isiseiny mes. ");
INSERT INTO sps_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ri nom foiny tsuar ana ri peits iny to na taman tanun. ");
INSERT INTO sps_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ri tsue to, ‘Vainy binun te binuiny a isen a aua tsun, ana mam siiva me na binun tan sen nainy urung tana nuaf a fisikii, ana nyi foiny ratuarin senviir foiny fiisen mamimam!’ ");
INSERT INTO sps_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Taman tanun biny to na isen tsurin vainy binun sa tsue na ka, ‘Vaatau tsonyo, nyo gima kat fiiring manyi, fiisia, ara gima fatangan iny a isen na tarobong a foiny nan sen nainy? ");
INSERT INTO sps_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nom a foiny tsuam nyi te naa. Nyo pon ma foiny ir vainy binun te binun fatouraf senviir foiny te faan im. ");
INSERT INTO sps_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Fiisia, nyo sikia ma onot ma vovou iny mangiir tsonyo tana painy moni tsonyo fatoobing? Ge nyi fitsufainy rom, tana saa, anyo koma rof rarou a vainy?’” ");
INSERT INTO sps_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ai Jisas fakap ton vegiau tsuan sa tsue, “To tsuri to te vovovou ror, nai mumua eraror, ai tsuri to te mumumua ror nai vovou eraror.” ");
INSERT INTO sps_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Te taataan fi naa Jisas Jerusalem, Ya mei nato na ina safunuu ana ina fuan a matisian Tsunia tatangin sa vegiau fiisen tsun ramiri. ");
INSERT INTO sps_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ya tsue to, “Nongon yam, ra naa fi ror Jerusalem, ana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa fi non nimar tsunaun tan tsoiny faakor tana taa Jiu an tsoiny fifaatsuts tan Faun te kirkir iny e Moses. Ri nai sigainy ror Ya ma atsuiny famat ari Ya. ");
INSERT INTO sps_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ana ri te faan iny naa Ya tan mes a vainy kaner sikia ma taa Jiu, er tsue taring iny Towa, ri te rapits Ya ana ri te tapaar iny Ya tana pagafuan ai tan fafofopis nan nainy Ayei nai tsun fatabin enanon.” ");
INSERT INTO sps_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ai tsinar guei tsoiny ten Sebedi naa to ten Jisas fiisen ramen guei tsoiny tsunia, ya fatukun to matan Ya ana ya sing to ten Jisas. ");
INSERT INTO sps_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“A saa te komainy rom anyi na?” te rangat finy ya Jisas. Ana ya biny Towa, “Tsue faarof ana ina fuan a guei tsoiny tsonyo te nai gum fiisen mami Nyi, isen tan panainy matou ana mesmes tan nimainy keeruk to te faarei rom Anyi na Aatouf.” ");
INSERT INTO sps_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Mi sikia rom ma natiny a ka te rangat iny romi,” te tsue fi Jisas tsuri. “Mi onot rom ma jiu iny a gotan iny saraa kamits to te jiu iny Ronyo?” Ri biny Towa ser tsue na ka, “Mam onot rom.” ");
INSERT INTO sps_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“U man, mi nai jiu kan nats rom tana gotan iny saraa kamits Tsonyo,” te tsue fi Jisas, “san tana tou gum tan nimainy matou ana mesmes tan nimainy keeruk a sikia ma ka Tsonyo ma faan im, a pan to aya e Tamanyo tsun tsivon te faan iny non ya tsurin vainy te nai kakouiny onots Ya.” ");
INSERT INTO sps_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Te nongoiny a ina safunuu na matisian a ka to, ri sewaar iny ton mumuinyasiny to. ");
INSERT INTO sps_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ai Jisas fikoo faavots ratuari sa tsue, “Mi natem fuainy tsunaun kaa miror a parits fis ror vainy babainy an fuainy tsoiny mumua te vakek rarori tan vovou iny vegiau tsuri. ");
INSERT INTO sps_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kat to aya ma ruak vaare fapoopoan namami a sikia ma sanaan nan ya. Ta isen tsumi te komainy karap non, ayei ma faarei me na tsoiny toukuar tsumi faavot, ");
INSERT INTO sps_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","an ta isen tsumi komainy non ma mumua mami, ayei ma faarei me na tsoiny binun babainy tsumi, ");
INSERT INTO sps_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","faarei non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, gima naa me ma kat a vainy a binun iny faakouts Ya, a sikia, Ayei te naa me ma kat Ya na binun iny faakouts ir a vainy faavot, ma faan iny Ya na Tsivon a mat to, a faarei to na pats ma puruur ravainy Ya na vainy a kinai te kaa ror tana numaa iny kotskots tan aveto.” ");
INSERT INTO sps_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Te naus osing naa ri na ngats fan iny Jeriko, an tagin tsian fiisok vovou iny to Jisas. ");
INSERT INTO sps_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ina fuan a mes a mata kio to te gumgum tatangin a sanaan nongon te naa fi me Jisas, ana ri tanik iny kuu bus rato, “Tsubnaain ten Devit! Tagtag mamimam Tsunaun!” ");
INSERT INTO sps_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ri na gum iny vainy tsue ets'ets ratuari, “Vanumui yam.” Sana ri kuu fatsian pis to, “Tsubnaain ten Devit! Tagtag mamimam, Tsunaun!” ");
INSERT INTO sps_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ai Jisas tsutsun to sa fikoo rari sa rangats rari, “A saa te komainy romi ma kat Anyo tsumi na?” ");
INSERT INTO sps_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ri biny Towa ser tsue na ka, “Tsunaun, mam komainy marom Anyi ma tsipaar mata mamam kio!” ");
INSERT INTO sps_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas reesik fiisok rari, Ya saras to na mata rari; sen tsun ana ri tagaa bus rato, ana ri vovou iny naa Towa. ");
INSERT INTO sps_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Te naa fasiruu naa ri tana ngats fan tsian iny Jerusalem, ri ruak to tana ngats fan iny Betpeits panan a Tobeer iny Oliv, Jisas fakuar ra naa na ina fuan a matisian sa tsue of rari, ");
INSERT INTO sps_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Kuar yam tana fan naa to aya mata mami, mi sab rom a isen a dongki tang iny ari ana tsunei dongki kan. Puruur ir yam am mei ramituari nei Tsonyo. ");
INSERT INTO sps_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te rangat fi maromi ta mes tsue of yam, ‘A Tsunaun kaa minon a binun tsuri’, ana Ayei nai faan veesau iramirori.” ");
INSERT INTO sps_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A ka to te ruak san vegiau te pokei me na kuigin muan ruak iny man ovei nato, ");
INSERT INTO sps_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tsue of ir vainy Jerusalem, ‘Tagaa, a Aatouf tsumi te naa minon tsumi, Ayei fauf a tsivon ana Ayei gum minon tounon a dongki, ayei na tsunei dongki, a guei tana dongki.’” ");
INSERT INTO sps_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","An matisian naa famumua naa to, ri kat to na foka te tsue of rari Jisas. ");
INSERT INTO sps_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ri mei me na dongki na tsinan ana tsunei dongki kan, ri ban iny fo vau tsuar tounor dongki, ai Jisas gum to tana tsunei dongki. ");
INSERT INTO sps_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A vainy a kinai ban iny a fo vau tsuar sanaan, ana mesapan tsuri tek miton fo paura ratsuu ser ban iny ya sanaan. ");
INSERT INTO sps_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Rin vainy te taan famumua naa ten Jisas ana ri na mesapan vovovou iny Ya tanik iny kuu bus rato, “Saup fatabin mamam yam, tsubnaain ten Devit! Gov faparits marom Anyi te naa mirom tana asangan a Tsunaun! Saup fatabin mamam yam roman, Anyi na Gov a tsigtsig!” ");
INSERT INTO sps_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te sof fi naa Jisas tana ngats fan tsian iny Jerusalem ana vainy a kinai kaakaa to na aya fakakarian ri rangat to, “E sei to aya ee?” ");
INSERT INTO sps_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“E Jisas a kuigin, Ayei a Guei Nasaret tana gum fan iny Galili,” te biny fi rari na vainy. ");
INSERT INTO sps_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas sof naa gagon tana aunon nana saape ana Ya jiaats vavagen rato na vainy te fafiifoiny iny a fo mamatsiny ka tsuar koman a saape, ana ri kan foiny ir fo mamatsiny ka. Ya kof raton taran tan vainy papangis moni ana Ya kof kan raton fo gumgum tana vainy te fafiifoiny iny baanus. ");
INSERT INTO sps_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ana Ya tsue to tsuri, “Te kirkir en tan Vegiau Ten Gov, Gov te tsue, ‘Numaa Tsonyo koo rori na numaa iny fafaakats,’ ‘Sana mi kat faarei ya na puts iny takop tan vainy kakabuts!’” ");
INSERT INTO sps_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Rin mata kio an mou ra pengong naa me Tsunia koman a saape ana Ya tsipaar ratuari. ");
INSERT INTO sps_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ana rin tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun te kirkir iny e Moses sewaar to te tagei ari na fo mamatsiny ka iny faatok to te kat e Jisas ana rin guei kakaii kuu to koman a saape, ri tsue to na ka, “Saup fatabin mamam yam, tsubnaain ten Devit!” ");
INSERT INTO sps_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ana rin tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun te kirkir iny e Moses tsue to ten Jisas, “Nyi nongoiny rom a ka te vevegiau iny rori?” Jisas biny ratuari sa tsue na ka, “Eye, Nyo nongon you. Mi sikia ma gogosias vaarik vegiau tan Vegiau Ten Gov to? ‘Gov fafaatsuts ir guein kakaii an meran ma variri faarof ari.’” ");
INSERT INTO sps_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisas naus osing ratuari ana Ya naus osing to na ngats fan tsian Jerusalem sa naa fi en tana ngats fan iny Betani, ana Ya kaa enato tana voiny. ");
INSERT INTO sps_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Te fatabin fi mi Ya tana ngats fan tsian tana voinyvoiny, Jisas ves nato. ");
INSERT INTO sps_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ya tagei ton nau, u Fig, tatangin a sanaan ana Ya naa fi nato tsunia, sana sikia tu fua, u noun tsun. Ana Ya tsue to tan Fig, “Nyi gim pis rom ma nai fua on nats!” sen tsun an Nau Fig to maas bus nato. ");
INSERT INTO sps_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Rin matisian tagei a ka to ri fakakarian to, “Kat fei san Fig to ayei maas veesau tsun enato ei?” ");
INSERT INTO sps_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas biny rari sa tsue, “Fakats yam a ka to! Te faason romi, ana mi na sikia tu vaa'ets, mi onot kan rom ma nai kat a ka to, te kat Anyo tan Fig to: sikia ma kaa tsun to aya, mi onot kan rom ma tsue of a tobeer to, ‘Tasas nyi te nai ruk em namaan,’ ana ya te tasas. ");
INSERT INTO sps_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te faason romi, mi nai nom rom a ka te rangat iny romi tan faakats.” ");
INSERT INTO sps_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas tabin fatabin me koman a saape; te fafaatsuts Ya, rin tsunaun tan tsoiny faakor an tsunaun tana vainy naa mito Tsunia, ri rangats Towa, “Saf gumgum Tsumanyi to na to Tsumanyi kat rom fo mamatsiny ka to na? Sei faan Manyin gumgum to ee?” ");
INSERT INTO sps_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas biny ratuari, “Nyo kan rangat maromin sen tsun rangat, te biny faarof fi Varonyo mi, Nyo te tsue of mamin saf gumgum to te kaa Mironyo na iny kat a fo mamatsiny ka to. ");
INSERT INTO sps_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mi ma tsue of Vanyo, a tou fapeenan ten Jon, fei te nom e Jon gumgum iny fapeenan ei, poo fi me ten Gov ge tana mes?” Ri tanik iny fatsitsien bus rato fapoopoan narari, “A saa te tsue rora na? Te tsue fi rora nei, ‘Te poo fi me ten Gov,’ ana Ayei te tsue na ka tsura, ‘Kat pas fei, sam gima faamainy e Jon ei?’ ");
INSERT INTO sps_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sai te tsue fi rora nei, ‘Te poo me tana mes,’ ara oraav rora vainy tana ta ka te kat nats rori, tana saa a vainy te faamainy e Jon ayei na kuigin faman.” ");
INSERT INTO sps_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ana ri biny to Jisas, “Mam gim rom ma nat.” Ana Ya tsue to tsuri, “Nyo kan gim rou ma tsue of mamin saf gumgum Tsonyo iny kat a foka na.” ");
INSERT INTO sps_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Saf fakats tsumi na? Te kaa me na mes ana ya kaa mito na ina fuan a guei tsoiny. Ya naa to tana karap narari ya tsue to, ‘Guei tsoiny tsiau, kuar nyi te binun tan tanun wain roman.’ ");
INSERT INTO sps_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Nyo baainy you,’ te tsue fi ya, ai vou ya reesik to sa kopis fakats tsuan, ya naa to tana tanun wain. ");
INSERT INTO sps_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ana taman naa of to na mesmes a guei tsoiny sa tsue of yan senviir vegiau. ‘Eye, tamau,’ te tsue fi ya, sana ayei gim to ma naa. ");
INSERT INTO sps_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","E sei tana ina fuan to ari te manaats e taman ee?” Ri biny Towa ser tsue na ka, “A vaamuan.” Jisas tsue to tsuri, “Nyo tsue of maromi na ka to, rin vainy nonom takis an vainy tsitsikoor to te reesik ser kopis fakats tsuar naa faamuan eraror tsumi tana Waan e Gov, ");
INSERT INTO sps_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","tana saa, Jon a Tsoiny Fapeenan naa me tsumi sa faatok mami na sanaan a tavaron, sana mi gim to ma faamainy ya; san vainy nonom takis ana rin tsitsikoor takopis ri faamainy towa. Kainon te tagei finy ami na ka to ana mi gim kainy to ma reesik, mi te takopis tan fakats tsuam am faamainy towa.” ");
INSERT INTO sps_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nongon yam tan mes tsue fapapaar to,” te tsue fi Jisas. “Te kaa me na taman tanun, ya reev ton wain tanun tsuan, ana ya aunoiny faafis ton tanun Gereip tsuan, kats to na gaguur iny memedak fua nan ngits Gereip, ana ya fatsuiny to na tovaar a nai jias, a pan tan tsoiny bei ot ma tagaa ri tan vainy kakabuts. Ana ya foiny ton tsoiny tatagaa ot iny tanun Gereip tsunia, er binun tanun of towa, ana ya naa enato tana mes a fan kanen veevian. ");
INSERT INTO sps_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ai tan nainy agio ya jiats naa ton tsoiny binun tsuan ma naa ya tan tsoiny tatagaa ot iny tanun ma nom of ya ta tee fua nan tanun tsuan. ");
INSERT INTO sps_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tsoiny tatagaa ot iny tanun nots ton tsoiny binun tsunia ri rapits to na isen, atsuiny famat to na mesmes ana ri totouruei to na mesmes. ");
INSERT INTO sps_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ya jiats pis naa ton mes panainy tsoiny binun tsuan kinai fafis iny non a te tsoiny binun tsunia to te jiats faamuainy naa ya ana ri kat kan fi erato jesan, tsuri. ");
INSERT INTO sps_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Fafakap nan ya, ya jiats fatoobing naa to na guei tsoiny tsunia. ‘U man ri famaari ror a guei tsoiny tsonyo,’ tsue fi ya. ");
INSERT INTO sps_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sai te tagei ari na guei tsoiny tsunia ri tsue to fapoopoan narari, ‘A guei tsoiny tana taman tanun tovei. Tanats yam ma atsuiny famat ara ya, ana ra te nom a fo mamatsiny ka tsunia!’ ");
INSERT INTO sps_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ri nots towa, ana ri ras tsitsikap iny naa towa jiarasan voun a tanun wain ser atsuiny famat ya. ");
INSERT INTO sps_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Te naa me na taman tanun to, a saa te kat ya tan tsoiny tatagaa ot tan tanun to na?” rangat fi Jisas. ");
INSERT INTO sps_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Ayei nai atsuiny famat raror vainy ngi'arapaar to ari,” biny finy ari Ya, “ana ya te faan rari yan mes panair tsoiny binun kaner er tagaa ot faarof iny towa ma nai nom faarof ya ta tee fua tsuan tan nainy agio fatoobing.” ");
INSERT INTO sps_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas tsue to tsuri, “Mi gima gogosias a ka to te tsue iny Vegiau Ten Gov? ‘A fats a marats to te tsugei fuainy tsoiny fatsun numaa ruak faarei na fats a karap ovei tana numaa. Tsunaun fapogaar ya ana ya mamatan faarof ovei tsun nato mata rara!’ ");
INSERT INTO sps_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","To sana Nyo tsue of maromi,” tsue fi Jisas, “A Waan e Gov te nai nom ravaa osing maromi na taa Jiu, ana ya te faan fi naa ya tana vainy kaner tana gum fan kaner te faruak ror fo fuan rof ovei. ");
INSERT INTO sps_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","A mes te tsukakab non tan fats a marats to aya ana ayei te gotsiny naa nai tatamoor ovei nanon; ana fats a marats te rus of ta mes, ayei nai oiny memedak ovei tsuiny non ya, ya te nai faarei nats kuaf.” ");
INSERT INTO sps_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Rin tsunaun tan tsoiny faakor ana taa Farasi nongoiny tsue fapapaar to te kat e Jisas, ri natiny towa Ayei vegiau tsuk rarori. ");
INSERT INTO sps_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ri tanik iny sainy to ta sanaan iny nots e Jisas, sana ri te oraav ir a vainy tana saa a vainy te faamainy e Jisas, Ayei na kuigin. ");
INSERT INTO sps_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas tsue of pis ratuarin mes tsue fapapaar. ");
INSERT INTO sps_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A Waan iny Gormirmir faarei non a isen a aatouf te kakouiny guainy nan fanging tana guei tsoiny tsunia. ");
INSERT INTO sps_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ya jiats raton tsoiny binun tsuan ma nai finaum mi ri tana vainy te nom vebus ma naa mi ri tan guainy nan fanging, ser baainy ma naa me. ");
INSERT INTO sps_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ya jiats pis nats ton mes panainy tsoiny binun tsuan fiisen men vegiau to, tsue of ir yam a vainy te nom vebus muan ma naa mi ri, ‘Guainy nan fanging te kakouiny bus anyo, a fo bulumakau tsoiny ana fo mes a fo venoo nan fafaruet te peepee er ana kakoun onot fiisen me na fo mes a foka kan, taami yam tan guainy nan fanging!’ ");
INSERT INTO sps_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Sana vainy to te nom vebus nan guainy nana fanging to baainy ma naa me, ri naa vavis erato a tou kat a fo binun tsuar: isen tsuri naa fi en tanun tsuan, ana mesmes naa kan fi enato tana numaa iny fafiifoiny tsuan. ");
INSERT INTO sps_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ana mesapan tsuri na vainy nots raton tsoiny binun, ri rarapits ratuari ser atsuiny famat kan ratuari. ");
INSERT INTO sps_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ana aatouf peits fiisok tsun nato, ya jiats raton vainy puaan tsuan, ana ri atsaatsun ratuari ri kuruiny ton ngats fan tsurin vainy to te atsuiny famat ir tsoiny binun tsunia. ");
INSERT INTO sps_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ana ya fikoo ton mes tsoiny binun tsuan, ‘Guainy nana fanging tsonyo kakoun en,’ te tsue fi ya, ‘sana ri na vainy te nom vebus pisiin ser gima tamainy ma naa me. ");
INSERT INTO sps_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jio, kuar fi yam tan fo sanaan te vivagutan ror ana mi te fanat rari na fokinai faavot te onot iny sab fi romi ri, er naa mito tan guainy nana fanging.’ ");
INSERT INTO sps_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","An tsoiny binun naa bus rato tana fo sanaan, ri guam rato na vainy a kinai te onot iny sab ari, rin vainy iring an vainy rof. Ri naa mito ana pan via enato tsuri na vainy te naa me tan guainy nana fanging. ");
INSERT INTO sps_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ana aatouf naa to gagon ma nak ya na vainy ana ya tagei to na isen a mes gima vau men vaun rof nana fanging. ");
INSERT INTO sps_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘O ka, fei te ising fi mi nyi ei, to sa nyi naa me gagon ana nyi na sikia tu vau nana fanging?’ rangats fi ya na aatouf. Sana mes to vanumui enato. ");
INSERT INTO sps_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ana aatouf tsue to tan tsoiny binun tsuan, ‘Kotskots yam a niman ya ana moun ya, mi te gargar naa ya jiarasan tana uurup tana pan iny fasaraa unya aya ayei nai tangis non ya te kakuts ngiisngiis a ngiisin.’” ");
INSERT INTO sps_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ai Jisas fakap ton vegiau Tsuan sa tsue na ka, “A vainy a kinai fiisok te nom vebus, sana ina tee karaup tsun te pisan rari.” ");
INSERT INTO sps_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farasi naa ri kat ton fakats ma fataraatsua ri Jisas tan fo rangat. ");
INSERT INTO sps_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ri jiats na ton matisian tsuri ana tee vainy ten Herot unya ten Jisas. “Tsoiny fifaatsuts,” tsue fi ri Tsunia, “Mam nat marom Anyi natiny tsue iny rom a man. Nyi fafaatsuts iny rom a man nane Gov tana vainy, ana Nyi gim kan rom ma aspeer ta mes tan fakats tsuri, tana saa, kainon to te kaa fi mirorin asangan gen vainy babainy. ");
INSERT INTO sps_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tsue of mamimam, saf fakats Tsumanyi na? Te toobing non tan faun tsura ma foiny takis fi naa ten Sisa na aatouf iny Roum ge na sikia?” ");
INSERT INTO sps_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisas nat faamuan iny fakat fanunun iring tsuri, ana Ya tsue to, “Amin vainy kat mapam! Kat fei sam fataraatsua Varonyo ei? ");
INSERT INTO sps_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Faatok Vanyo yam ta isen ta painy moni kainy foiny takis!” Ri mei mito na isen a painy moni, ");
INSERT INTO sps_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ana Ya rangats ratuari, “A nain e sei ana asangan e sei to aya ee, tana moni to?” ");
INSERT INTO sps_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ri biny Towa ser tsue na ka, “E Sisa na aatouf.” Ai Jisas tsue to tsuri, “Jio, fainy yam e Sisa na foka ten Sisa, am fainy to Gov, a foka ten Gov.” ");
INSERT INTO sps_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Te nongoiny arin vegiau to, ri ngian fiisok tsun rato: ana ri tsun osing Towa ser naa er. ");
INSERT INTO sps_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tan ar nainy to aya, ri na tee vainy tana taa Sadusi natiny tsue ror a sikia ta tou tsun fatabin tana mat, naa mito ten Jisas. ");
INSERT INTO sps_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tsoiny fifaatsuts,” te rangat fi ri Ya, “Moses fafaatsuts sa tsue na ka: ‘Te mat fi non a mes, a sikia tu guei, an famuinyasiny tsunia ma fanging a amov to, ma kaa mi ri tu guei, a faarei ton guei tan fo mumuinyasiny taman tsuan te mat.’ ");
INSERT INTO sps_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eye, te kaa me na fo mumuinyasiny ina fits te kaakaa. Vaamuan fanging to, ana ya maten nato a sikia tu guei, ana amov fanging to na fafuan narari. ");
INSERT INTO sps_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jesan te kat fi kan a fafuan ana fafofopis, nai ruak tan fafakap nar mumuinyasiny to, mat fakap er. ");
INSERT INTO sps_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ai tan fafakap, amov to mat patsu nato. ");
INSERT INTO sps_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eye, to tan nainy tana tou tsun fatabin tana mat, e sei tsurin ina fits mumuinyasiny to ari te nai faarei non a tsoiny tana moun to aya ee? Ari faavot to te fanging ya.” ");
INSERT INTO sps_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas biny ratuari, “Mi iring em, tana saa, mi pin iny rom Vegiau Ten Gov, ana parits ten Gov. ");
INSERT INTO sps_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","To te tsun fatabin fi ror vainy mat, ri faarei raror morena iny Gormirmir, an tsoiny min moun a sikia tu fifanging pis na aya. ");
INSERT INTO sps_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ai to kan, tana tou tsun fatabin tana mat, mi gima gogosias vegiau te tsue of mami Gov ge? ");
INSERT INTO sps_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Anyo na Gov ten Abraham, ana Gov ten Aisak, ana Gov ten Jekop.’ Faarei non a Gov, Ayei na sikia ma Gov tan vainy mat, Ayei na Gov tan vainy toto.” ");
INSERT INTO sps_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Te nongoiny vainy a kinai vegiau to, ri saar rato. ");
INSERT INTO sps_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Te nongoiny Farasin vegiau ten Jisas te kat favanumui na vainy te gim ror ma faamainy a tou tsun fatabin tana mes tana mat, ri suur faavot mito. ");
INSERT INTO sps_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ana isen tsuri na tsoiny fifaatsuts tan Faun te kirkir iny e Moses, pon to ma fataraatsua Yan rangat, ");
INSERT INTO sps_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tsoiny fifaatsuts, a saf a ar Faun te kirkir iny e Moses te karap fafis non tan fo faun faavot na?” ");
INSERT INTO sps_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas biny ratuari, “‘Nyi ma mangiir a Tsunaun a Gov tsumanyi fiisen men komam faavot, fiisen men aavem faavot, ai fiisen men fakats faavot tsumanyi.’ ");
INSERT INTO sps_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ayei na vaamuan nan faun te karap fafis non. ");
INSERT INTO sps_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ana fafuan nar faun te karap fafis non, ito te faarei kainy non ya: ‘Nyi ma mangiir fifakokoro tsuam faarei te mangiir rom anyi na tsivom.’ ");
INSERT INTO sps_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Fo Faun te kirkir iny e Moses ana fo fifaatsuts tan fo kuigin tsutsun ror tana fuan a Faun to.” ");
INSERT INTO sps_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Te vaaguam men Farasi, Jisas rangats ratuari, ");
INSERT INTO sps_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Saf fakats tsumi ten Krais na? Ana Ayei fatsubnaain fi naa non ten sei?” Ri biny Towa ser tsue na ka, “Ayei na tsubnaain ten Devit fatoobing.” ");
INSERT INTO sps_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ya tsue to tsuri, “Kat pas fei san Aaven Taabos pokei mi Ya nguen e Devit, sa koo Ya na ‘Tsunaun’ ei? Devit tsue na ka, ");
INSERT INTO sps_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tsunaun e Gov te tsue tana Krais a Tsunaun tsonyo, Gum nei tan panaainy matou Tsonyo, onot non te fakei finy Ronyon fo vainy te koma iring marom Anyi er kaa to fain a mou Manyi.’ ");
INSERT INTO sps_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit koo Krais, a ‘Tsunaun tsonyo,’ Sana ayei koo kainy Ya na tsubnaain Tsunia. Kat fei ma fatsubnaain pis Ya ei?” ");
INSERT INTO sps_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","A sikia ta isen tsuri ma biny e Jisas tan ta ar vegiau, ai tan ar nainy to aya ai tan mes a fo nainy kan, sikia ta isen tsuri ma su'eets Ya tan ta fo rangat, ri te oraav. ");
INSERT INTO sps_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ai Jisas tsue to tan vainy kinai ai tan matisian Tsunia, ");
INSERT INTO sps_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“U Tsoiny Fifaatsuts tan Faun ana taa Farasi ri fafaatsuts maromin Faun te kirkir iny e Moses. ");
INSERT INTO sps_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mi ma manaats rari am vovou ratuari tana fo mamatsiny ka te tsue of maromi ri, sana mi ma vovou vaare iny kat tsuri, tana saa, ri gim ror ma vovou iny kat ana ka te favaanan iny rori. ");
INSERT INTO sps_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ri natiny fapatang raror a vainy ma vovou fo kat tan tsuvurari faarei non a ong a patang googo rari, sana ri sikia vaarik ror ma natiny faan iny a nimar tan faakouts rari. ");
INSERT INTO sps_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ri kat ror a fo mamatsiny ka ma faarei arin vainy tavaron. Tagaa, ri kirkir ror vegiau ten Gov, ri te kitskits iny ya nai rari ai nima rari, ana fo vau iny jiarasan tsuri kan beberus! ");
INSERT INTO sps_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ri komainy fiisok ror ma tsun faamuan tan ainy tana fo guainy, ana fo gum tan gumgum matan tana numaa iny fafaatouf, ");
INSERT INTO sps_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ri komainy raror a vainy ma fatsiitsii rari er favoinyvoiny ratuari tana pan iny tuan ana vainy koo rarorin ‘Tsoiny Fifaatsuts.’ ");
INSERT INTO sps_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sana mi, ma tanyiny vaare ta mes ma koo manyi ya na ‘Tsoiny Fifaatsuts,’ tana saa, mi faavot mumuinyasiny fiisen me na mesapan ana mi kaa tsun mirom a isen a Tsoiny Fifaatsuts. ");
INSERT INTO sps_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Am koo vaare to ta isen tana monaagits to, ‘A Taman,’ tana saa, mi kaa tsun mirom a isen a Tamamami kaa non Gormirmir. ");
INSERT INTO sps_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ge tanyiny vaare yam ta isen ma koo manyi ya na ‘Tsunaun,’ tana saa a isen te tsutsun of maromi na Tsunaun, Ayei e Krais. ");
INSERT INTO sps_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ta isen fapoopoan namami komainy karap fiisok non, ayei ma faarei na tsoiny binun tsumi. ");
INSERT INTO sps_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sei te fapaas non a tsivon ee, Gov nai fauf non ya peto, ai sei te fauf non a tsivon ee, Gov nai fapaas non ya.” ");
INSERT INTO sps_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ma sekee, min Tsoiny Fifaatsuts tan Faun ana taa Farasi, taatag yam! Amin vainy kat mapam! Ami natiny siisiots rom pingping tana Waan iny Gormirmir matar a vainy, sana mi patsukanem gim rom ma sof gagon, ana mi kan gim rom ma famanat ir a vainy te tanaf ror ma sof gagon! ");
INSERT INTO sps_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ma sekee, min Tsoiny Fifaatsuts tan Faun ana taa Farasi, taatag yam! Amin vainy kat mapam! Mi natiny fataraatsua rarom fo amov, mi kabuts pasem numaa tsuri, ana mi kat faatok em mata rari tan kat a fo faakats a fo viviakoo ma famuiny amin a fo iring tsuam! Tan kat to aya fasaraa nai kaatsian fiisok enanon tsumi! ");
INSERT INTO sps_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ma sekee, min Tsoiny Fifaatsuts tan Faun ana taa Farasi, taatag yam! Min vainy kat mapam! Mi taan vavis rom namaan ai tana fo gum fan mi te nom a mes a faarei to na matisian tsumi, mi kat rom ya ana ayei te naa fi Hel faarei tsuiny maromi. Ayei nai iring fafisfis maromi tan kat iny pisiin tsunia! ");
INSERT INTO sps_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ma sekee, min mata kio, taatag yam! Mi fafaatsuts iny ka to: ‘A mes te tsue non a ka man non jias ya te koo na Saape Taabos, mi te tsue ya na ka babainy tan tsuen man tsunia, sai te tsue fi non ya nei man non jias tan gol nana Saape Taabos, ayei ma kat patsukan te tsue fi ya.’ ");
INSERT INTO sps_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Amin piou an mata kio! A saa te karap fafis non na, gol ge na Saape Taabos to te kat non gol ma taabos ya? ");
INSERT INTO sps_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mi kan fafaatsuts iny a ka, ‘A mes te tsue non a ka, man non jias tan fatsung fafaatouf mi te tsue, ka babainy tan tsuen man tsunia; sai te tsue fi non ya nei man non jias tana fo fifaan tan fatsung fafaatouf, ayei ma vovou iny tsuen man tsunia.’ ");
INSERT INTO sps_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Amin mata kio! A saa te karap fafis non na, fifaan ge na fatsung fafaatouf te kat non a fifaan a nai taabos to? ");
INSERT INTO sps_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Te tsue fi non ta mes, man non jias ya te koo na fatsung fafaatouf ayei te faparits non vegiau tsuan nana fatsung fafaatouf fiisen me na fo fifaan te kaa ror patsun ya. ");
INSERT INTO sps_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ai te tsue fi non ta mes, man non jias tana Saape Taabos, ayei faparits non vegiau tsuan tana Saape Taabos fiisen me Gov, ten Gov kaa non tana Saape Taabos. ");
INSERT INTO sps_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ai te tsue fi non ta mes nei, man non jias unya Gormirmir, ayei faparits non vegiau tsuan tan tagan ten Gov, Gov gum non tan tagan. ");
INSERT INTO sps_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ma sekee, min Tsoiny Fifaatsuts tan Faun ana taa Farasi, taatag yam! Amin kat mapam! Fo mamatsiny mar moros ana fo viir peroo ana fo mamatsiny fua nan tanun mi natiny kat rom a ar safunuu na pan ana isen a pan te naa of e Gov, kat to ayan rof an toobing sana mi baainy ma vovou iny fifaatsuts nan faun te karap fafis non, ito tan kat tavaron iny kat senviir kat tana vainy faavot, an kat iny tagtag a mesmes, an kat iny kat man tana mesmes. Faun tan faan iny a isen a pan tan fasafunuu nana pan ten Gov mi gim rom ma natiny anofe ya san tan kat faun a karap fafis to, mi ma kat kainy rari. ");
INSERT INTO sps_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Min mata kio mi komainy faatok rarom a vainy a sanaan! Tsumi te faarei rom vainy te gargar ror nang tan sewaan, sana ri korom a Kamel fiisen men sewaan! ");
INSERT INTO sps_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ma sekee, min Tsoiny Fifaatsuts tan Faun ana taa Farasi, taatag yam! Amin kat mapam! Mi natiny togas faarof tsuiny rom a puan a gotan an kofeer, sana koma mami via minon kat iny kakabuts an kat iny fatsing. ");
INSERT INTO sps_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mi na taa Farasi, amin mata kio! Mumua tsom non mi ma togas a gotan gagon, ai jiarasan te kaamos kan me! ");
INSERT INTO sps_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ma sekee, min Tsoiny Fifaatsuts tan Faun ana taa Farasi, taatag yam! Amin kat mapam! Mi faarei rom katskats te us arin gosee sa mamatan faarof non jiarasan, sai gagon, via minon fo tsuainy mes ana fo nungan a fo murak an iring vavajia. ");
INSERT INTO sps_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jesan kan, mi mamatan faarei rom vainy tavaron ovei jiarasan matar a vainy faavot, sai gagon mi via mirom kat mapam an kat iny ngi'arapaar. ");
INSERT INTO sps_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ma sekee, min Tsoiny Fifaatsuts tan Faun ana taa Farasi, taatag yam! Amin vainy kat mapam! Mi to te natiny kat faarof ovei tsuiny rom fo katskats tana fo kuigin, ana mi te reev a fo fareevreev gengen rof tan vainy tavaron. ");
INSERT INTO sps_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ana mi te tsue na ka, ‘To ma kaa fiisen ramiran fuainy tsuvurara muan tan nainy tsuri, ra buiny gima kat fi nei to te katkat fi ri ser atsun ir a fo kuigin.’ ");
INSERT INTO sps_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","To sami tsue fi rom nei amin tsubnaain tan vainy te atsuiny famat ir a fo kuigin! ");
INSERT INTO sps_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jio, kat yam, am fakap faarof ton kat te katkat fo tsuvumami te tanik ari! ");
INSERT INTO sps_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Amin guei tana koraa na iring! Mi gim on rom ma bus osing oiny a fasaraa ten Gov, Gov fakaa maromi unya Hel. ");
INSERT INTO sps_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sana Nyo tsue of maromi, Nyo nai jiats miroun fo kuigin, an vainy nat, ana fo tsoiny fifaatsuts; mi te nai atsuiny famat ir a mesapan, mi fagageits ir a mesapan tana pagafuan, ana mi te rapits ir a mesapan tana fo numaa iny fafaatouf tsumi, ana mi te jiaats vavagen rari tana fo ngats fan vavis. ");
INSERT INTO sps_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tan kat to aya, a fasaraa nan rafatsiny nar a fo mes tavaron to te atsun famat ari muan tana petoo tovei nai nom nats romi, tanik me tan rafatsiny te atsun famat ari Ebol, ai te naa fi tan rafatsiny te atsun famat ami Sakaraia, guei tsoiny ten Berekaia to te atsuiny famat ami fapoopoan nana pan a taabos a pan ten Gov ana pan iny fatsung fafaatouf. ");
INSERT INTO sps_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nyo tsue faman of maromi, fasaraa nan fo vainy to nai onot enanon tan aatai iny roman!” ");
INSERT INTO sps_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Poo! Taa Jerusalem, taa Jerusalem! Mi atsun famat ir kuigin, ana mi totouruei famat raton tsoiny favaanan te jiats me Gov tsumi! Nainy kinai poiny Anyo ma favaaguam mami pana Vanyo guei iny Jerusalem, faarei te natiny favaaguam fi non a koriou a moun fuainy guei tsuan fain pakpak tsunia, sana mi baainy Vanyo! ");
INSERT INTO sps_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sai tovei a fan tsumi nai uur enanon ai te tsubui en. ");
INSERT INTO sps_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nyo tsue fatoobing of maromi mi gim rom ma tagaa pis Vanyo, onot non te tsue fi romi nei, ‘Gov faparits non Ya to te naa minon tana asangan a Tsunaun.’” ");
INSERT INTO sps_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Te tafuts osing me Jisas a saape an matisian Tsunia naa mito Tsunia ma faatok ari Ya na numaa nana saape. ");
INSERT INTO sps_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ya tsue to na ka, “Eye, ami onot rom ma tagei fo mamatsiny ka to tovei roman. Nyo tsue faman of maromi, vou, sikia ta isen ta fats te fifatua on nats non a fifatua to tana iinin ya; fo fats to tarop miror nei peto, ri te nai soon er putaa.” ");
INSERT INTO sps_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Te gum e Jisas tan Tobeer iny Oliv, an matisian patsukaner naa mito Tsunia. “Tsue of mamimam, farainy te nai ruak nats non a ka to,” rangat fi ri, “ana saf a ka te nai ruak nats non na ana ya te faatok fatoobing iny nainy tabin me Tsumanyi ana fafakap nana monaagits to?” ");
INSERT INTO sps_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisas biny ratuari sa tsue na ka, “Tanamots yam, am famanat vaare to ta mes ma fagaug mami ya, ");
INSERT INTO sps_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","tana saa, vainy a kinai naa fiisen miror a asanga Vanyo, ri te tsue na ka, ‘Anyo na Krais!’ ana ri te fagaug ir a vainy a kinai. ");
INSERT INTO sps_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mi nai nongoiny nats rom sagoge nana puaan gen vaanan nana puaan faasai; sana mi ma onanun vaare. Foka to te ruak nats non, sana ri te gim ror ma faatok iny fafakap nan puputaa to. ");
INSERT INTO sps_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Fo gum fan te fapupuaan ramiror mes a fo gum fan kaner, ana isen na aatouf an tsoiny puaan tsuan vapupuaan miror a aatouf an tsoiny puaan tsuan, nainy ves nai ruak nats non ana fo nuu kan tana fo viir pan. ");
INSERT INTO sps_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Fo mamatsiny ka to te faarei tsuiny non te tanik iny kamits fi non a tsinan te kat iny faagiir fi non ya na guei tsuan. ");
INSERT INTO sps_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ana ri nai nots maromi er kat fapatang matuami er fakamits matuami, am mat kanem mato. Ana fokinai nai tsugei kan maromi tana saa mi kaa mirom a asanga Vanyo. ");
INSERT INTO sps_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Vainy a kinai te faonot ror tana faaman tan ar nainy to aya; ri te fafaatai iny a mesmes ana ri te tsugei kainy a mesmes. ");
INSERT INTO sps_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Rin kuigin kinai gamgam nai tapokaa ror ri te fagaug ir a vainy a kinai ma vovou rari ri. ");
INSERT INTO sps_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","An kat iny tagtag mes tan vainy a kinai nai kajiaa enanon, tana saa, a fo kat a fo ngi'arapaar nai saats pinpin non a pan. ");
INSERT INTO sps_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sen sei tsun te suu iny non a faaman tsuan ee, onot non tan fafakap nan puputaa to, Gov nai saup fatabiny non ya. ");
INSERT INTO sps_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","An Vurungan Rof nana Waan iny Gormirmir nai favaanan non tana monaagits faavot, faarei non a ka ma nongoiny ari ya na vainy faavot; ai voun ya an nainy fafakap tan puputaa to te see roruak me.” ");
INSERT INTO sps_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mi nai tagei nats rom a ‘Iring Tsian Fiisok’ te pokei iny e Daniel a kuigin muan, ana ka to te tsutsun koman a Pan a Taabos koman saape.” (A vainy ma gogosias vegiau to ma nat faarof iny arin kifon vegiau to!) ");
INSERT INTO sps_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Arin vainy te kaa ror tana gum fan iny Judia ma bus fapaas fi naa tana fo tobeer. ");
INSERT INTO sps_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ana mes kaa non patsun a numaa tsuan tana kofuak ma of me ya te bus veesau en ma kaa vaare mi ya tu nainy iny nai nom a foka tsuan gagon numaa, ayei ma bus tsun naa naa. ");
INSERT INTO sps_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ana mes kaa non tanun tsuan ma tabin vaare, a nai nom ton vau tsuan, ayei ma bus tsun naa naa. ");
INSERT INTO sps_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","O reesik fiisok, ma sekee fuainy moun kuraa, an fuainy moun see faagiir, ri gim ror ma onot tan bus! ");
INSERT INTO sps_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Faakats yam ten Gov ma bus vaare mi tan nainy tana tonok ge tan Nainy Fafaatouf tana taa Jiu, ");
INSERT INTO sps_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","tana saa, ito tan nainy ‘Iring Tsian Fiisok’ tan nainy to aya, nai iring fatsian pis naa non ya te iring fafis a fo nainy iring muan te tapogaar me na monaagits onot non tan ar nainy to aya. Nainy iring tsian fiisok to te gima ruak muan, ge vou kan. ");
INSERT INTO sps_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sen Gov nai fakakats bus a fo mar nainy; fiisia, Ayei gima kat a ka to, ai sei ta mes te toto nats non ee. San tana vainy te pisainy fatoobing Ya, to sana Ayei nai fakakats nainy. ");
INSERT INTO sps_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sai te tsue fi non ta mes tsumi nei, ‘Tagaa, e Krais to!’ ge ‘Ayei tuwa aya!’ faamainy vaare yam, ");
INSERT INTO sps_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","tana saa, fo Krais gamgam an fuainy kuigin gamgam nai ruak nats ror; ri te faatok iny a foka iny faatok, ma fagaug rari rin vainy fasito fatoobing ten Gov, te onot fi non ya. ");
INSERT INTO sps_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nongon yam! Nyo tsue faamuan of bus mami na ka to. ");
INSERT INTO sps_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ge, te tsue of maromi ta mes, ‘Tagaa, Ayei kaa non tana pan a uur!’ naa vaare yam unya aya; ge te tsue fi rori nei, ‘Ayei te tatakop non nei!’ faamainy vaare yam, ");
INSERT INTO sps_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","tana saa, a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa minon faarei non kanaf, Ya te kanaf faafis a korosuu tanik minon tana pan te roruak minon a nuaf ya te nai onot tana pan te ruk naa non a nuaf ana vainy faavot tagei ror Ya. ");
INSERT INTO sps_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tana pan te soon non puainy mes mat, manuu nai vaaguam ror tsunia.” ");
INSERT INTO sps_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Sen tsun voun nainy Iring Tsian Fiisok, ‘A nuaf nai uurup enanon, ana iifaa gim non ma nai tsingaar, fo kootsits nai tapatsik osing miror a korosuu, ana fo mamatsiny parits iny korosuu nai tatagut eraror, er tasas osing to naa fo iinir.’ ");
INSERT INTO sps_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ana ka na karap te faatok iny non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai ruak bus naa minon korosuu; ana fo vainy faavot tana monaagits to nai susuiny matan ror, ana ri te see tatagei bus a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me of fiisen minon a koroo poo fi minon Gormirmir fiisen minon a parits a reits an siinaiv karap fiisok. ");
INSERT INTO sps_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ana tsufing a karap te puuf, ana Ya te jiats ramen morena Tsuan tana fats a ainysat tana monaagits to ana ri te guam ir a vainy te pisainy Ya faarei rarora fasito fatoobing Tsunia, tanik non tan sen panaan nana monaagits to, ya te nai ruak tan mes panaan.” ");
INSERT INTO sps_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nom nat yam tan nau u vei, u nau ma faatsuts mami yan siisio, am nat faarof iny towa. Tan nainy te tagei romin vei te firaar non mi natiny rom fua nan vei te sisiruu en. ");
INSERT INTO sps_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jesan kan te tagei finy romi na fo mamatsiny ka te roruak non mi ma nat fi nei, nainy fatabin me Tsonyo te sisiruu ename. ");
INSERT INTO sps_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Fakats faarof yam a ka to! U aatai tovei te toto farokot kan raror tabuiny mat ror ana fo mamatsiny ka te tsue Nyo to nai ruak nats non. ");
INSERT INTO sps_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Korosuu an puputaa nai kajiaa enanon; san vegiau Tsonyo gim non ma nai kajiaa on.” ");
INSERT INTO sps_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Sana sikia ta mes te natiny non nainy ge na aua, tsuri kan morena iny Gormirmir, ge na Guei Tsoiny kan, san e Tamanyo tsun Tsivon te nat non. ");
INSERT INTO sps_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tou tabin fatabin me Tsonyo nai faarei tsuiny non a ka te ruak muan tan nainy ten Noa. ");
INSERT INTO sps_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tan nainy tabuiny ruak non urungat, ana vainy fakats tsuiny to na tsivor tan ainy, an jiu, an tsoiny min moun fifanging to onot tan nainy te sof e Noan ak tsunia; ");
INSERT INTO sps_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ri gim to ma faamainy a saf a ka te ruak non na, onot tan nainy te ruak urungat, sa ras faavot ir a fokinai, ri mat fakap rato. Jesan kan te nai faarei tsuiny non a ka te ruak tabuiny tabin fatabin Mironyo. ");
INSERT INTO sps_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tan ar nainy to aya te tabin fatabin Mironyo a ina fuan te binun ror tanun, ai Gov te nom a isen tsuri ana mesmes te kaakaa en vou. ");
INSERT INTO sps_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A ina fuan a moun te koinykoiny ror koinykoiny; ai Gov te nom a isen tsuri ana mesmes te kaakaa yen vou. ");
INSERT INTO sps_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kaa to yam, mi te kakoun, tana saa, mi gim rom ma natiny nainy iny tabin fatabin me tana Tsunaun tsumi. ");
INSERT INTO sps_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Fakats faarof a ka to; to te natiny non a mes tana numaa tan nainy te naa fi minon a mes a kakabuts, ana ya te tagun patsukanen, ayei gim non ma famanat iny a mes a kakabuts ma rabang ya na numaa tsunia, a sof to gagon. ");
INSERT INTO sps_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tan kat to aya, ami kan ma kakoun faarof tan mamatsiny nainy, tana saa, a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me te nai tabin fatabin minon tan ar nainy te gim fi romi ma naano.” ");
INSERT INTO sps_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“E sei to ayei na tsoiny binun a suu ana nat a rof ee? Ayei na tsoiny binun to na tsunaun tsunia te pisainy ya ma tatagaa ot ir yan mes painy tsoiny binun, ma tatafas rari yan a kainy ainy tana fo nainy fatoobing. ");
INSERT INTO sps_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Paparaa tsian tana tsoiny tatagaa ot to te sab finy non ya na tsunaun tsunia te kat finy non yan kat to te naa fi minon ya fan! ");
INSERT INTO sps_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Man ovei, Nyo tsue of maromi a tsunaun tsunia nai fagum non ya a faarei to na tsoiny tatagaa ot tana fo mamatsiny ka tsunia. ");
INSERT INTO sps_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sai to tsunia na tsoiny tatagaa ot a pisiin, ayei nai tsue non tana tsivon, ‘A tsunaun tsonyo gim non ma veesau fatabin me,’ ");
INSERT INTO sps_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ana ayei te tanik iny rapits ir mes panair tsoiny binun ya te ainy ana ya te jiu fiisen ramirin vainy jijiu famafuu. ");
INSERT INTO sps_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ana tsunaun tana tsoiny binun to ayei te tabin fatabin pis me tan ta fo mar nainy te gim finy non ya ma naano ai tan nainy kan te gim non ya ma kakoun of. ");
INSERT INTO sps_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A tsunaun nai tektek mormor non ya ana ayei te fagum ya tana pan iny fasaraa ma kaa fiisen mi yan vainy kat kat mapam unya aya ayei nai tangis non ya te kakuts ngiisngiis a ngiisin.” ");
INSERT INTO sps_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tan nainy te tabin Mironyo a Waan iny Gormirmir te faarei nats non na ina safunuu na kooviou to te nom ir kurun fiisen men konobo tsuar ser nai tainytainy a isen a tsoiny fanging. ");
INSERT INTO sps_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","A ina ngim tsurin piou ana mes a ina ngim, u nat. ");
INSERT INTO sps_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A ina ngim ton piou nom naan kurun tsuar ri gim to ma nom taatag naa tu mes tu konobo, ");
INSERT INTO sps_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ana ri na ina ngim ton nat nom taatag naan konobo kaa naan kurun tsuar. ");
INSERT INTO sps_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A tsoiny fanging vegits en naa mito, ana ina safunuun a kooviou tanik iny mata goros to ser goros famatmat ir. ");
INSERT INTO sps_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Te rot nana voiny tana voiny tsian an fikoo naa mito, ‘A tsoiny fanging to! Taami yam am tainytainy towa!’ ");
INSERT INTO sps_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A ina safunuu na kooviou tagun ri kakouiny ton kurun tsuar. ");
INSERT INTO sps_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ana ri na ina ngim a piou tsue to tana ina ngim a nat, ‘Faan mamimam yam tu konobo tsumi, tana saa, u kurun tsumam mats, sikia tu konobo.’ ");
INSERT INTO sps_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Sikia on,’ biny finy rari ri na ina ngim a nat, ‘U konobon sikia ma onot faavot rara. Kuar yam tana pan iny fafiifoiny am foiny to tu konobo tsumi.’ ");
INSERT INTO sps_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ana ri na ina ngim a piou to, naa buser rato a tou foiny konobo, vou rari ana tsoiny fanging ruak to. A ina ngim to te kakoun naa fiisen mi towa tan guainy iny fanging ana ri siisiots ton pingping. ");
INSERT INTO sps_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Vou ana rin mes panainy kooviou piou ruak to sa ri tsue na ka, ‘Tsunaun, tsunaun! Fasof mamimam yam gagon!’ ");
INSERT INTO sps_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sana tsoiny fanging tsue na ka, ‘Nyo tsue faman of maromi Nyo gim rou ma nat mami.’” ");
INSERT INTO sps_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ai Jisas tsue to na ka, “Kaa to yam, mi te kakoun tana saa, mi gim rom a natiny nainy ge na aua te tabin fatabin Mironyo.” ");
INSERT INTO sps_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Te faarei non a isen a mes te kakoun ma naus osing a fan a naa to tana gum fan veevian; ya fikoo raton tsoiny binun tsuan ya fakaa ratuari ma tagaa ot iny arin fo mamatsiny ka tsunia. ");
INSERT INTO sps_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ya fafaan ratuarin isiseiny tsoiny binun a painy moni ma tamainy yan fakats ana parits tsuri: tana isen ayei fainy ya na ngim a tapan moni, ya fainy to na mesmes a fuan a tapan moni, ana mesmes a isen a tapan moni. Ana ya naa busen nato tana gum fan veevian. ");
INSERT INTO sps_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A tsoiny binun to te nom a ngim a tapan moni naa veesau tsun nato sa fabinun iny a painy moni to sa nom a mes a ngim a tapan moni. ");
INSERT INTO sps_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jesan kan te kat fi na mes a tsoiny binun to te nom a fuan a tapan moni ya faruak kainy to na fuan a tapan moni. ");
INSERT INTO sps_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sana tsoiny binun to te nom a isen a tapan moni naa to, kats a matan tan puputaa, ya famuiny to na painy moni tana tsunaun tsuan. ");
INSERT INTO sps_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Voun nainy viviakoo tana tou vavis tana tsunaun tana fo tsoiny binun tabin fatabin mito a tou nak rari tana fo painy moni tsuan. ");
INSERT INTO sps_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A tsoiny binun to te nom a ngim a tapan moni naa mito sa faan iny a mes a ngim a tapan moni sa tsue na ka, ‘Nyi faan vanyo na ngim a tapan moni, tsunaun. Tagaa! A mes a ngim a tapan moni tovei to te vabinun iny anyo.’ ");
INSERT INTO sps_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Rof ovei tsun, nyi na tsoiny binun a rof ana kaa fasuu,’ te tsue fi na tsunaun tsunia. ‘Nyi kaa fasuu faarof fiisen me na painy moni ito na te ar karaup to sa nyo nai fakarap marom anyi ma tagaa ot iny anyi na painy moni a tee karap to. Taame ma paparaa fiisen vaminyo nyi!’ ");
INSERT INTO sps_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ana tsoiny binun to te nom a fuan a tapan moni naa mito sa tsue na ka, ‘Nyi faan vanyo na fuan a tapan moni to, tsunaun. Tagaa! A mes a fuan na tapan moni to te faruak anyo.’ ");
INSERT INTO sps_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Rof ovei tsun, nyi na tsoiny binun a rof ana kaa fasuu!’ tsue fi na tsunaun tsunia. ‘Nyi kaa fasuu faarof iny me na painy moni to na tee ar karaup, to tsonyo nai fakarap marom anyi ma tagaa ot iny anyi na painy moni a tee karap to. Taame ma paparaa fiisen vaminyo nyi!’ ");
INSERT INTO sps_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ana tsoiny binun to te nom a isen a tapan moni naa mito sa tsue na ka, ‘Tsunaun, nyo nat evarou nyi na mes a siireits; nyi agio rom tan tanun tana fo mes a fo vainy kaner, ana nyi te fag vavis a fo fua tan tanun tana mes a fo vainy kaner. ");
INSERT INTO sps_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nyo oraav, to tsonyo nai famuiny a painy moni tsumanyi koman puputaa. Tagaa! A painy moni tsumanyi to.’ ");
INSERT INTO sps_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Nyi na tsoiny binun a pisiin ana karous!’ tsue fi na tsunaun tsunia. ‘Fiisia nyi natiny a ka to, nyo agio tan tanun te gim ronyo ma fasito iny, ana nyo fag kainy to na fo fua te gima anyo ma reev? ");
INSERT INTO sps_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nyi tabuiny fasof a tee moni tsonyo tana guuv iny fatamaar ma nom fatabiny anyo ya fiisen me na tee ar moni patsun ya te tabin minyo. ");
INSERT INTO sps_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jio, nom osing yam a painy moni am fainy towa na tsoiny binun to te kaa minon a safunuu na tapan moni. ");
INSERT INTO sps_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ana mes kaa minon a nat, nyo fainy pis rou ya na nat fis pis non a nat te kaakaa mi ya ana ya te kaa me na nat a onot, sana mes te gim non ma komainy a nat nyo nom ravainy rou a nat a kakaii te kaakaa minon ya. ");
INSERT INTO sps_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ai tsunia na tsoiny binun a paku'ak to, gargar naa yam jiarasan tana uurup tana pan iny fasaraa, unya aya ayei nai tangis non ya te kakuts ngiisngiis a ngiisin.’” ");
INSERT INTO sps_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Te tabin fatabin minon a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me faarei minon Ya na Aatouf, an fo morena fiisen mi Ya, Ayei nai gum non tan tagan Tsuan tsigtsig. ");
INSERT INTO sps_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ana fo vainy faavot tana monaagits to te vaaguam faavot matan Ya. Ana Ya te kibei faavot rari tan fuan panaan, faarei te kibei finy non a tsoiny veis siip an meme: ");
INSERT INTO sps_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ya te nai fakei fuainy ir siip tan panaainy matou Tsuan an meme tan panaainy keeruk. ");
INSERT INTO sps_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ana Aatouf te nai tsue na ka tana vainy tan panaainy matou Tsuan. ‘Mi to te nom bus a parits ten Tamanyo: taami yam! Taami yam am fasito iny to na Waam mami te kakouiny of bus mami Tamanyo tan tatanik nana monaagits to. ");
INSERT INTO sps_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nyo te ves ana mi fa'ainy Vatuanyo, Nyo iinyu mi fajiu Vatuanyo; Nyo na ngap ana mi nom Vatuanyo numaa tsumi, ");
INSERT INTO sps_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nyo na beerbeer ana mi favau Vatuanyo; Nyo na faadis ana mi makok Vatuanyo, Nyo kaa to tan kotskots ana mi nak Vatuanyo.’ ");
INSERT INTO sps_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ana rin vainy tavaron nai tsue ror a ka Tsunia, ‘Farainy, Tsunaun, te tagei fi mam Anyi te ves mam fa'ainy Matuanyi, ge te iinyu Nyi mam fajiu Matuanyi? ");
INSERT INTO sps_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Farainy te tagei fi mam Anyi na ngap ana mam nom Matuanyi numaa tsumam, ge kaa iny beerbeer Anyi mam favau Matuanyi? ");
INSERT INTO sps_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Farainy te tagei amam Anyi te faadis ge kaa Nyi tan kotskots, ana mam nak Matuanyi?’ ");
INSERT INTO sps_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ana Aatouf biny fatabin to sa tsue na ka, ‘Nyo tsue faman of maromi, u kat to te kat nats romi ten sei na vamuinyasiny Tsonyo iton vainy sikia tu asangan, mi kat kainy rom ya Tsonyo!’ ");
INSERT INTO sps_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ana Ya te tsue na ka tsuri tan nimainy keeruk, ‘Feis osing Vanyo yam, mi kaa busem fain na fasaraa ten Gov, kuar fi yam tan guaf sikia ma natiny mote te kakouiny e Gov of e Vinasaar an fuainy morena tsunia! ");
INSERT INTO sps_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tana saa, Nyo te ves sana mi gima fa'ainy Vanyo, Nyo iinyu mi gim to ma fajiu Vanyo; ");
INSERT INTO sps_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nyo kainy ngap mi gim to ma nom fi Vanyo numaa tsuam, Nyo beerbeer mi gim to ma favau Vanyo; Nyo faadis ana Nyo kaa to tan kotskots mi gim to ma makok Vanyo.’ ");
INSERT INTO sps_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ana ri te biny Ya, ‘Tsunaun, farainy te tagei amam Anyi te ves, ge iinyu, ge ngap, ge beerbeer, ge faadis, ge kaa Nyi tan kotskots, ana mam gim to ma faakouts Manyi?’ ");
INSERT INTO sps_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ana Aatouf biny fatabiny ratuari, Ya te tsue na ka, ‘Nyo tsue faman of maromi te baainy fi mi ma faakouts ir vainy sikia tu asangan to, ami kan baainy Vanyo.’ ");
INSERT INTO sps_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tan kat to aya, vainy nai nom rora tafan tsuar, ito na fasaraa na suu. Ai tsurin vainy tavaron nai nom ror a toto na suu.” ");
INSERT INTO sps_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te fakap bus e Jisas fifaatsuts tana foka to, Ya tsue to tan matisian Tsunia, ");
INSERT INTO sps_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“U fuan tsun nainy te kaakaa non te nat fi romi, an nainy Guainy iny Fakats Fatabiny nainy te faakouts fi rari Gov ser naus osing me na Ijip, ana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa fi naa non nimar vainy to te fagageits rori Ya tana pagafuan.” ");
INSERT INTO sps_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","An tsunaun tan tsoiny faakor ana rin tsunaun tana taa Jiu vaaguam faavot to tana numaa tsian ten Kaiafas a Tsoiny Mumua Tan Tsoiny Faakor, ");
INSERT INTO sps_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ri sainy to ta fo sanaan takop ma nots ari Jisas, ri te atsuiny Ya. ");
INSERT INTO sps_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Ara ma kat vaare ya tan nainy guainy,” te tsue fi ri, “kat ror sana vainy fatsuiny fitaatsun.” ");
INSERT INTO sps_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas kaa enanon Betani, numaa ten Saimon to te kaa men tatauba muan, ");
INSERT INTO sps_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ana moun sof mito fiisen me na kepaa viainy minon tapui na tsuraf ana foiny nan ya na nai jias, ana ya tsiiu iny towa patsuun e Jisas, ai Jisas gum iny ainy en. ");
INSERT INTO sps_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Matisian tagei a ka to ri peits to, “Saf a rof nan ya na to sa tsiiu raravainy tapui tovei?” te rangat fi ri. ");
INSERT INTO sps_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“A tapui na tsuraf to te onot non ma fafiifoiny ravaa, a onots to na moni na kinai fiisok, ana moni to te onot ma tatafas iny ari, a naa of ton vainy aaruts!” ");
INSERT INTO sps_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas nat faamuan iny vegiau te kat ari ana Ya tsue to tsuri, “Kat fei sam kat tap iny rom a moun to ei? Ayei te kat a ka na saavits fiisok Tsonyo. ");
INSERT INTO sps_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mi nai kaa fatatabin ramirom vainy aaruts, sana Nyo gim rou ma nai kaa fatatabin fiisen mamiromi. ");
INSERT INTO sps_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A ka te kat ya to te tsiiu finy ya na tapui to pua Vanyo kakouiny of Varonyo tana kats. ");
INSERT INTO sps_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Man ovei Nyo tsue of maromi, te vasiisio iny rorin Vurungan Rof nane Krais tana monaagits to, ri te fakats kainy kat te kat a moun to Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ana isen tsuri na safunuu ana ina fuan a matisian koo ri Judas Iskariot naa fi enato tan tsunaun tan tsoiny faakor. ");
INSERT INTO sps_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ya tsue to na ka, “A saa te faan varonyo mi naa te faan iny naa ronyo Jisas tsumi?” Ri as to na painy moni sa onots a fopis safunuu na painy moni silva ser faan iny ya. ");
INSERT INTO sps_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ai tana ar nainy to aya, Judas sainy to tu nainy tu rof ma faan iny ya Jisas. ");
INSERT INTO sps_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tan vaamuan nan nainy Guainy te ainy rorin Koinykoiny Sikia ma kaa me tu Yis, rin matisian naa mito ten Jisas, ri rangats Towa. “Fei te komainy rom Anyi mam ma nai kakouiny Guainy iny Fakats Fatabin Tsumanyi ei?” ");
INSERT INTO sps_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“Kuar yam tana isen a mes koman a ngats fan tsian iny Jerusalem,” te tsue fi Ya tsuri, “am tsue of towa: ‘Tsoiny Fifaatsuts te tsue, nainy Tsonyo te sisiruu en; matisian Tsonyo nai ainy fiisen Vamironyo tan Guainy iny Fakats Fatabin tana numaa tsumanyi.’” ");
INSERT INTO sps_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","An matisian kat to na ka te tsue of rari Jisas ana ri kakouiny ton Guainy iny Fakats Fatabin. ");
INSERT INTO sps_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Te ananerof en ai Jisas an matisian Tsunia gum iny ainy bus rato. ");
INSERT INTO sps_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Te ainy farokot ari Jisas tsue to, “Nyo tsue faman of maromi a isen fapoopoan namami nai faan iny Varonyo nimar vainy ma nai atsuiny vanyo ri.” ");
INSERT INTO sps_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rin matisian koma patang fiisok tsun rato, ri tanik iny rangats Towa, rin isisen vegiau patsukan iny Ya, “A sikia ma nyo ge, Tsunaun?” ");
INSERT INTO sps_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisas biny ratuari, “A isen te fabub non koinykoiny tsuan koman kobuu fiisen Vaminyo, nai faan Varonyo. ");
INSERT INTO sps_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai mat non te tsue fin Vegiau Ten Gov, eye, nai mat non, sana sekeiny mes to te faan iny non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me! Gov nai fainy non ya na fasaraa tsian. Tabuiny rof fiisok tana mes to ayei ma agiir vaare ten tsinan!” ");
INSERT INTO sps_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas ayei na mes te faan iny e Jisas tan vainy ma nai atsuiny ari Ya, tsue to na ka, “Tsoiny Fifaatsuts, anyo ge?” rangat fi ya. Jisas biny towa, sa tsue na ka, “Te tsue fi rom anyi.” ");
INSERT INTO sps_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Te ainy farokot ari, Jisas nom a koinykoiny, sa faakats iny faarof of naa towa ten Gov, Ya ivoo towa, ana Ya fafaan ratuarin matisian Tsunia. Ya tsue to, “Nom yam am ainy towa, a pua Vanyo tovei.” ");
INSERT INTO sps_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ana Ya nom to na gotan, Ya faakats iny faarof of naa towa ten Gov, Ya fafaan ratuari sa tsue, “Jiu yam, mi faavot. ");
INSERT INTO sps_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Rafatsiny Tsonyo to aya te faparits non tsue faunot foun nane Gov, rafatsiny Tsonyo tatsiiu of non a fokinai tan kat iny anofe ravainy kat iny aveto. ");
INSERT INTO sps_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nyo tsue faman of maromi, Nyo gim rou ma jiu pis nats wain tovei onot non tan nainy te jiu Ronyon wain foun fiisen mamimi tana Waan e Tamanyo.” ");
INSERT INTO sps_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ana ri kooma iny faatouf to, ser naa fi tana Tobeer iny Oliv. ");
INSERT INTO sps_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ai Jisas tsue to tsuri, “Tana voiny tovei mi na fokinai te nai bus osing Varonyo, tana saa u Vegiau Ten Gov te tsue na ka, ‘Gov nai atsuiny non a tsoiny veis tan siip ana fo siip te nai saats vavis a pan.’ ");
INSERT INTO sps_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","San tan voun nainy tana tou tsun fatabin tana mat, Nyo nai mumua pis maromi tana gum fan iny Galili.” ");
INSERT INTO sps_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita tsue to na ka ten Jisas, “Nyo gim rou ma nai bus osing Manyi, kainon to te kat fi rori na fokinai to!” ");
INSERT INTO sps_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisas biny towa, “Nyo tsue faman of marom anyi tabuiny kokorooto non a koriou a tsoiny tana voiny roman nyi nai faungis Varonyon fopis nainy, nyi gim rom ma nat Vanyo.” ");
INSERT INTO sps_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita biny Towa, “Nyo gim rou ma tsue, nyo gim rou ma nat Manyi, kainon nyo mat fiisen mamirom Anyi.” An matisian faavot tsue kan fi rato jesan. ");
INSERT INTO sps_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ai Jisas naa fiisen ramiton fuainy matisian Tsuan tana pan te koo ri Getsemani, ana Ya tsue to tsuri, “Gum yam nei ma nai faakats Anyo unya aya.” ");
INSERT INTO sps_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ya ras rato Pita, ana ina fuan a guei tsoiny ten Sebedi. Koma patang tsian an reesik tsian fiisok paas Towa, ");
INSERT INTO sps_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ana Ya tsue to tsuri, “Aave Vanyo reesik fiisok non tovei kat iny atsuiny famat Varonyo. Kaakaa yam nei am kaa to fiisen Vamituanyo.” ");
INSERT INTO sps_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ayei taan fajesa naa to, Ya fagotsiny naa to na nain peto tan puputaa ana Ya faakats to, “O Tamau, te rof fi non ya, nom ravainy osing You a gotan iny saraa kamits to, san sikia ma tan mangiir Tsonyo, u mangiir tsun Tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ana Ya tabin fatabin of ramituari na ina pis a matisian ana Ayei sab ratuarin goros; ana Ya gungun ratuari, Ya tsue to ten Pita, “Fiisia, mi na ina pis gim rom ma kaa to fiisen Vaminyo tana isen a aua? ");
INSERT INTO sps_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kaa to faarof yam, am faakats to ma gotsiny vaare mi tan fiamus, aaven te koman non san puainy mes te ree'ats non.” ");
INSERT INTO sps_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ai Jisas fafuan iny tabin fatabin pis to Ya faakats to. “O Tamau, te gim fi non a gotan iny saraa kamits to ma nom ravaa, kainon te jiu Ronyo, ma faonots yan mangiir Tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ana Ya fatabin pis to sa sab ir matisian Tsunian goros ri gima karats vaarik a matar. ");
INSERT INTO sps_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ai Jisas naus osing pis ratuari, sa fafofopis iny faakats pis faakats fi kanen jesan. ");
INSERT INTO sps_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kat to ana Ya fatabin of pis ramiton matisian sa gungun rari ana Ya tsue to na ka, “Min goros ana mi favusuan kan emarom? Tagaa yam! U nainy te ruak en tana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa fi naa non nimar vainy pisiin reits. ");
INSERT INTO sps_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tsun tanats yam, ma naa ra. Tagaa yam, a mes te faan vanaa Ronyo to te ruak en.” ");
INSERT INTO sps_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas vegiau kanen nanon ai Judas, isen tsuri na safunuu ana ina fuan a matisian, naa mito. Fiisen men kinai mes govet kirat an vuts poo fi me tan tsunaun tan tsoiny faakor an tsunaun tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ana mes to aya to te faan iny e Jisas tsue faamuan of raton kinai tana ka te nai kat non ya: “A mes to ayei to te umei ronyo ayei koraa na mes te komainy romi. Nots yam!” ");
INSERT INTO sps_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Te ruak me Judas ya naa fatoobing nato ten Jisas sa tsue na ka, “A voiny, Tsoiny Fifaatsuts!” Ana ya umei Towa. ");
INSERT INTO sps_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas biny towa, “Vaatau, a ka to komainy kat rom anyi kat veesau!” Ana fokinai naa mito, ri nots to Jisas, ri nom tap faparits iny Towa. ");
INSERT INTO sps_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Isen tsuri to te kaakaa fiisen me Jisas gamus ton kirat nana puaan tsuan sa tek sapee na teinan a tsoiny binun babainy tan Tsoiny Mumua tan Tsoiny Faakor. ");
INSERT INTO sps_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ai Jisas tsue to tsunia, “Rog fatabin iny kirat tsuam tana pan tsunia, tana saa, a fokinai te nai fataatsun iny ror kirat nai mat kan iny ror kirat. ");
INSERT INTO sps_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nyi sikia rom ma nat, to ma sing Anyo ten Tamau tan tu fifaakouts, sen tsun ana Ya te jiats ramen safunuu ana fuan a tapan morenan kinai tana puaan ge? ");
INSERT INTO sps_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","San tan kat to aya, fei te man fi non Vegiau Ten Gov ei to te tsue fi ya, a ka to ma ruak fi kanen tana sanaan to?” ");
INSERT INTO sps_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ai Jisas vegiau to tan kinai, “Mi naa me fiisen men kirat an vuts iny nots Vanyo faarei Varonyo na mes a kakabuts? Mamatsiny nainy Nyo gum, Nyo fafaatsuts to tana saape, ana mi gim to ma nots Vanyo. ");
INSERT INTO sps_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sana fo mamatsiny ka to te ruak ma faruak mi ya na man nana fo kirkir na Vanyo tana fo kuigin tan Vegiau Ten Gov.” Ana rin matisian faavot naus osing Towa ser fabuubus vavis er. ");
INSERT INTO sps_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Rin vainy to te nots e Jisas nom finy naa Towa tana numaa ten Kaiafas a Tsoiny Mumua tan Tsoiny Faakor tana pan te vaaguam faavot a fokinai rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses ana rin tsunaun tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita vovou iny e Jisas gima naa fasiruu naa tana aunon nana numaa tana Tsoiny Mumua tan Tsoiny Faakor. Ya sof enato koman a aunon ya gum fiisen ramiton tsoiny bei ot ma tagei yan fo mamatsiny ka te ruak fi non Ya. ");
INSERT INTO sps_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Rin tsunaun tan tsoiny faakor ana rin Fuainy Tsunaun tan Kansol faavot tanaf iny sainy to ta fo vegiau tu gam nane Jisas ma atsuiny famat ari Ya; ");
INSERT INTO sps_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","sana ri gima sab vaarik ta ka kainon te faroruak faavot fi me na fokinai ana ri gam iny Towa. Ana ina fuan a mes ruak mito, ri tsue to na ka, ");
INSERT INTO sps_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“A mes to te tsue na ka, ‘Nyo onot rou ma rurei a saape ten Gov, ai tan fopis nainy Nyo fatsuiny fatabiny pis rou ya.’” ");
INSERT INTO sps_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ana Tsoiny Mumua tan Tsoiny Faakor tsutsun to sa tsue na ka ten Jisas, “Nyi na sikia tu vegiau iny pokei tan vegiau te sak Manyi ri?” ");
INSERT INTO sps_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sen Jisas vanumui en. Ana Tsoiny Mumua tan Tsoiny Faakor tsue pis to na ka Tsunia, “Koman a asangan e Gov a toto, nyo rangat faparits os Matuanyi ma tsue faman ovei Anyi: tsue of mamimam, Nyi koraa na Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy, ge na sikia? Nyi na Guei Tsoiny ten Gov, ge na sikia?” ");
INSERT INTO sps_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas biny towa, “Te tsue fi rom anyi. Sana Nyo tsue of maromi na fokinai: tan fo mar nainy te naa minon, mi nai tagei nats rom a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me gum non tana pan iny fatsiitsii tan panaainy matou ten Gov a siireits ana Ya te of fiisen me na koroo poo minon Gormirmir!” ");
INSERT INTO sps_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tan vegiau to aya ana Tsoiny Mumua tan Tsoiny Faakor kakaar ton vau tsuan ana ya tsue to na ka, “Nyi te tsue vaaserere tsun iny e Gov! Mam tsugainy pis rom tu mes tu vegiau! Tovei mi nongoiny fakap bus a mes to te kat tsue to, Ayei fifanauti minon e Gov! ");
INSERT INTO sps_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Saf a fasaraa tan fakats tsumi na?” Ri biny towa, “Ayei kat bus kat iring, tamainy non ma mat tsun busen.” ");
INSERT INTO sps_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ai ri kasuf to na nain Ya, ri tsuguur Towa, ana ri to te sapainy Ya ");
INSERT INTO sps_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tsue to na ka, “Jio, Nyi na kuigin ten Gov, pokei of mamimam, Krais, A Mes te pisainy e Gov ma Tsoiny Fiisaup Ya, e sei to aya te sapan Manyi ee?” ");
INSERT INTO sps_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita gumgum enanon koman a aunon jiarasan numaa, ana isen tsurin kooviou, a muiny binun tana Tsoiny Mumua tan Tsoiny Faakor naa mito tsunia sa tsue, “Nyi kan to te kaa fiisen me Jisas, a tsoiny Galili.” ");
INSERT INTO sps_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sana ayei faungis matar a fokinai faavot. “Nyo gim rou ma natiny a ka te tsue iny rom anyi,” te biny finy ya ya, ");
INSERT INTO sps_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ana ya naa fasiruu mito tan matainy sobaa nana aunon. Ana mes a muiny binun tagei towa sa tsue na ka tana fokinai na aya, “Ayei kaakaa fiisen me Jisas a tsoiny Nasaret.” ");
INSERT INTO sps_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ai Pita faungis pis nato, sa biny ya, “Nyo tsue faman rou man non jias Nyo gim rou ma natiny a mes to!” ");
INSERT INTO sps_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sikia ma potsian ana vainy tsutsun to na aya naa mito ten Pita. “Eye, nyi na isen tsuri,” te tsue fi ri. “Fiisia, mam onot rom ma pokei manyi, tana saa, a miam manyi faarei non a tsoiny Galili.” ");
INSERT INTO sps_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ai Pita faparits ton tsuen man tsuan sa tsue, “Nyo rangats rou e Gov ma fasaraa Vanyo Ya, te gim fi ronyo ma tsue iny man! Nyo gim rou ma natiny a mes to!” Sen tsun ana koriou a tsoiny kokorooto enato, ");
INSERT INTO sps_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ai Pita fakats fatabiny pis ton vegiau te tsue Jisas, tsunia muan, “Tabuiny kokorooto non a koriou a tsoiny, nyi nai faungis Varonyon fopis nainy, nyi te tsue nyi gim rom ma nat Vanyo.” Ya tafuts to, sa buts iny tangis. ");
INSERT INTO sps_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tana voinyvoiny ovei tsunaun tan tsoiny faakor faavot ana rin fuainy tsunaun tana taa Jiu kat ton fakats tsuar ma sak ari Jisas tu vegiau ri te atsuiny famat Ya. ");
INSERT INTO sps_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ri kotskots Ya, ri mei naa Towa, ser faan iny naa Ya ten Pailat a gavana tana gum fan iny Judia. ");
INSERT INTO sps_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas ayei na mes to te faan iny e Jisas nimar tsunaun tana taa Jiu tagaa te sigan ma atsun famat fi ri Jisas, ya reesik to ana ya mei fatabiny naa to na fopis safunuu na painy moni silva unya tan tsunaun tan tsoiny faakor an fuainy tsunaun tana taa Jiu, ");
INSERT INTO sps_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nyo aveto bus you. Nyo famanat iny a Mes a sikia ta iring to nima mami ma atsuiny ami Ya!” te tsue fi ya. “A sikia ma iring tsumam,” biny finy ari ya, “A iring tsumanyi!” ");
INSERT INTO sps_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas ravainy to na painy moni silva to tana saape, ana ya naus osing ratuari; sa nai ot en. ");
INSERT INTO sps_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","An tsunaun tan tsoiny faakor nom to na painy moni silva to, ri tsue to na ka, “A pats nan rafatsiny to te gima toobing tan faun tsura ma fasof ara na painy moni silva to tana guuv tana saape.” ");
INSERT INTO sps_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Voun tsue faunot, ri nom to na painy moni silva ser pats yan puputaa tana mes a katkat nas kepaa, a faarei ton katskats tan vainy Sagoor. ");
INSERT INTO sps_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tan kat to aya, u puputaa to te koo rin “Puputaa tan Rafatsiny” onot non tan fo nainy to. ");
INSERT INTO sps_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","To san Vegiau Ten Gov nguen e Jeremaia na kuigin muan ruak iny man ovei enato, “Ri nom a fopis safunuu na painy moni silva, vovou iny tsue faunot te kat vainy iny Isrel tan kat a tafan tana Mes to, ");
INSERT INTO sps_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ri nom towa ser pats yan puputaa tana mes a katkat nas kepaa, te tsue of fi vanyo ya na Tsunaun.” ");
INSERT INTO sps_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas tsutsun matan a Gavana Pailat ana Gavana rangats Towa, “Nyi Ya na Aatouf tana taa Jiu?” “Naa, toobing non tsue fi rom anyi.” biny finy ya Jisas. ");
INSERT INTO sps_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sana rin tsunaun tan tsoiny faakor ana rin fuainy tsunaun tana taa Jiu sak Towan fo vegiau a fo gam, sen Jisas gim to ma biny rari. ");
INSERT INTO sps_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ai Pailat tsue to Tsunia, “Nyi gima nongoiny a fo mamatsiny ka to te sak manyi ri?” ");
INSERT INTO sps_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sen Jisas gim to ma vegiau ta karainy vegiau, ai Pailat karian fiisok tsun nato. ");
INSERT INTO sps_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tan fo mamatsiny Guainy iny Fakats Fatabin, natiny kaa minon kat tana Gavana Pailat famanat iny non ta mes tan kotskots ma fatafuts ravaa te rangats finy rori yan tagin. ");
INSERT INTO sps_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tan nainy to aya te kaa me na isen a mes a kotskots fokinai faavot natiny ror ya koo rori Jisas Barabas. ");
INSERT INTO sps_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ana rin tagin tana taa Jiu vaaguam to, ai Pailat rangat ratuari, “E sei te komainy romi nyo ma fatafuts ravaa ee? Jisas Barabas ge Jisas koo rori Krais?” ");
INSERT INTO sps_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ayei nat fiisok rari tsuri te faan iny me Jisas tsunia, tana saa ri te fitsufainy. ");
INSERT INTO sps_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Te vaagum e Pailat tan gumgum iny kat vaatsuk, ai natsun ya faan iny ton vegiau tsuan tsunia: “Tanyiny yam a mes a tavaron to, tana saa, nyo tarei a mes a tavaron to tana voiny, sa nyo oraav rou tovei.” ");
INSERT INTO sps_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ana rin tsunaun tan tsoiny faakor ana rin fuainy tsunaun tana taa Jiu famonei ton tagin ma rangats e Pailat ma fatafuts ravainy ya Barabas ana ri te atsuiny famat e Jisas. ");
INSERT INTO sps_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sana Gavana rangats rari, “E sei to tsuri na ina fuan ee te komainy romi nyo ma famanat iny?” “Barabas!” biny finy ari ya. ");
INSERT INTO sps_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“A saa te kat ronyo ten Jisas te koo romi Krais na?” rangat fi rari Pailat. Ri na fokinai biny towa, “Fagageits yam tana pagafuan!” ");
INSERT INTO sps_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sen Pailat rangat, “Kat Fei? Saf a iring te kat Ya na?” Ana fokinai tanik iny vaposok iny kuu to, “Fagageits Yam tana pagafuan!” ");
INSERT INTO sps_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Te tagei e Pailat a ka to na sikia tu vegiau nan, kat non san fitaatsun ruak Ya nom to na aurom, sa garus a niman matar a vainy faavot faatok iny non a ka ayei sikia non ma ong rafatsiny ten Jisas, sa tsue na ka, “A mat tana mes tovei sikia ma ka tsonyo! A ka bus tsumi!” ");
INSERT INTO sps_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","An tagin faavot biny fatabiny to, “Tanyiny a fasaraa to tana mat Tsunia ma ong amam ya mam min fuainy guei tsumam!” ");
INSERT INTO sps_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ai Pailat famanat iny to Barabas ma tafuts ya te koman fi ri; ana ya famanat iny to Jisas ma rapits ari Yan vainy puaan er faan iny naa Towa ma gageits Ya tana pagafuan. ");
INSERT INTO sps_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","An vainy puaan ten Gavana Pailat mei naa to Jisas tana numaa ten Pailat, an vainy puaan faavot bau faafis Towa. ");
INSERT INTO sps_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ri fabeerbeer Towa, ser favau Yan vau tana aatouf u vaun goutsiroun. ");
INSERT INTO sps_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ana ri kat of Towa na sapou uupe kakarits ri fa'uupe Towa faarei na aatouf, ana ri fakei to na painy tsukan tan panaainy matou niman Ya; ana ri fatukun to matan Ya ri tsue taring iny Towa. Ri tsue na ka, “Kaakaa ovei, O Aatouf tana taa Jiu!” ");
INSERT INTO sps_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ri kasuf Towa, ana ri nom to na painy tsukan ri pour to na patsuun Ya. ");
INSERT INTO sps_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te tsue taring fakap bus iny ari Ya, ri puruur osing Towan vau beberus iny jiarasan an goutsiroun ana ri favau fatabin Towan vau Tsuan. Ana ri ras fatafuts naa Towa jiarasan a tou fagageits Ya tana pagafuan. ");
INSERT INTO sps_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te tafuts osing naa ri na ngats fan tsian ri sab to na mes te koo ri Saimon, a mes te poo fi me tana ngats fan koo rori Sairini, ana ri sogsog towa ma sog ya na pagafuan ten Jisas. ");
INSERT INTO sps_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ri naa mito tana pan te koo rori Golgota, kifon vegiau to, “Pan tan tonaar.” ");
INSERT INTO sps_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ri fainy Towan wain kopis mi ri na ito na aapeits ma jiu Ya na aya; te dam tanaf bus Ya, ana Ya gim to ma jiu ya. ");
INSERT INTO sps_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ri fagageits Towa tana pagafuan, ana ri tatafas ratuarin vau Tsunia fapoopoan narari to tan tats fabiririir iny a saatu. ");
INSERT INTO sps_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Voun ya ri gum to ser vaatok iny Ya. ");
INSERT INTO sps_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jias patsuun Ya, ri kirkir ton vegiau te sak ari Ya: “E Jisas to na Aatouf tana taa Jiu.” ");
INSERT INTO sps_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ana ri fagageits to na ina fuan a mes a kakabuts tana pagafuan fiisen me Jisas, isen tan panaainy matou ana mesmes tan panaainy keeruk. ");
INSERT INTO sps_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Vainy te taataan fabisbis iny patsuur ana ri tsue vaaserere iny to Jisas: ");
INSERT INTO sps_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Nyi tsue te rurei rom a saape ana Nyi te fatsuiny fatabiny ya tan fopis nainy! Jio, ito ma Guei Tsoiny faman Anyi ten Gov, saup bus a Tsivom! Nyi te of osing me na pagafuan.” ");
INSERT INTO sps_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jesan kan te kat fin tsunaun tan tsoiny faakor ana rin tsoiny fifaatsuts tan Faun ana ri kan tsunaun tana taa Jiu tsue taring kan iny Ya, ");
INSERT INTO sps_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ayei saup ir a mesapan, sana Ayei gima saup a Tsivon! Ayei koraa Ya na Aatouf tana taa Isrel? Ma Ayei koraa Ya, Ya te of osing me na pagafuan roman, ma faamainy amam Ya! ");
INSERT INTO sps_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ayei te faason ten Gov ana Ayei tsue to na ka, Ayei a Guei Tsoiny ten Gov. Jio, ma tagaa ra te saup finy non Ya Gov roman!” ");
INSERT INTO sps_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tsuri kan a ina fuan a mes a kakabuts te gageits fiisen mi Ya tsue taring fi kaner jesan. ");
INSERT INTO sps_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tana safunuu na fuan a kilok tana nuaf, monaagits faavot uurup faavot nato onots ovei a fopis a aua. ");
INSERT INTO sps_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tana fopis a kilok tana touraf, Jisas dau iny ton tangis tsian, “Eloi, Eloi, lama sabaktani?” vegiau tana ta Hiburu, kifon ya to, “Gov Tsiau, Gov Tsiau, kat fei sa Nyi naus osing Vanyo, ei?” ");
INSERT INTO sps_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Rin mes vainy tsutsun na aya nongoiny Towa ser tsue na ka, “Ayei te fikoo non e Ilaija ma faakouts Ya!” ");
INSERT INTO sps_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sen tsun ana isen tsuri nom ton tsuuyan sa fabub towan wain maajiin, kotskots towa nguen ngaar, ana ya tanaf to ma fajiu ya Jisas. ");
INSERT INTO sps_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sana mesapan tsuri tsue na ka, “Anaanos yam, ma tagaa ra te naa fi minon e Ilaija a saup Towa!” ");
INSERT INTO sps_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ai Jisas dau pis iny ton tangis tsian, ana Ya faan iny to na aaven. ");
INSERT INTO sps_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","An raarav boo an tatabuan te gageits koman a saape takakaar to fapoopoan sa kat a fuan a pan sa tapue en, tanik me jias sa nai onot me peto. An puputaa tatagut to an fats tatamoor faavot rato, ");
INSERT INTO sps_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","an katskats tapue to, an vainy taabos kinai u fasito ten Krais to te mat er tsun fatabin rato. ");
INSERT INTO sps_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ri naus osing ton katskats; ai voun a tou tsun fatabin ten Jisas tana mat ri naa fi erato tana ngats fan tsian a taabos i Jerusalem to sana fokinai tagaa rari. ");
INSERT INTO sps_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Te tagei a tsoiny mumua tan vainy puaan an vainy puaan tsunia to te bei ot iny e Jisas a nuu ana fo mamatsiny ka to te ruak, ri oraav fakap rato ri tsue to na ka, “Ayei faman a Guei Tsoiny ten Gov!” ");
INSERT INTO sps_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ana mesapan nar moun to te poo fi me tana gum fan iny Galili fiisen me Jisas ser fafaakouts mi Ya te kaa na aya tsutsun me veevian tagaa to. ");
INSERT INTO sps_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Fapoopoan narari Meri na muiny Magdala, ai Meri tsinan Jemis me Josep, ana tsinan a ina fuan a guei tsoiny ten Sebedi. ");
INSERT INTO sps_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Te touraf en ana mes te kaa minon a masun tana ngats fan iny Arimatia koo rori Josep ayei kan a matisian ten Jisas ruak to. ");
INSERT INTO sps_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ayei ruak fatoobing e Pailat, sa rangat iny a puan e Jisas. Ai Pailat tsue faarof iny to na puan e Jisas ma nom ya Ya. ");
INSERT INTO sps_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ai Josep nom Towa, sa paapau Yan raarav goseen kafof foun ovei, ");
INSERT INTO sps_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ana ya fasooiny Towa tan puts a foun te see kats non ya tan fats tsunia fatoobing. Ana ya fakukuur to na sen a fats karap sa bei ot iny yan matainy sobaa sa naa busen. ");
INSERT INTO sps_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri na muiny Magdala ana mesmes a Meri gumgum na aya mamatoong fi naa tan puts tan fats. Foka to te ruak tana faangim, nainy ma kakoun of a taa Jiun fo mamatsiny ka tsuri tan Nainy Fafaatouf tsuri. ");
INSERT INTO sps_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Voun faangim nan nainy tan mes nainy, tsunaun tan tsoiny faakor ana taa Farasi vaaguam fi naa to ten Pailat ");
INSERT INTO sps_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ri tsue to na ka, “Tsunaun, mam natem te tototo farokot a mes a gamgam to ana Ya tsue to na ka, ‘Nyo nai tsun fatabin rou tana mat voun fafofopis nan nainy.’ ");
INSERT INTO sps_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Faan iny tsue faarof ma bei ot faarof iny arin puts onot non tan fafofopis nan nainy ma kabuts vaaren matisian Tsunia na puan Ya, er tsue of rato na vainy, ‘Ayei tsun fatabin en tana mat.’ Fafakap nan gam tovei, te iring fafis iny non a vaamuan.” ");
INSERT INTO sps_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Nom ir yam tsoiny bei ot,” Pailat tsue of rari, “kuar yam am bei ot faarof iny to na puts.” ");
INSERT INTO sps_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ana ri naa bus rato, ri aatsits to na fats, naus osing ramen tsoiny bei ot ma bei ot iny ari ya. ");
INSERT INTO sps_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Voun Nainy Fafaatouf tana taa Jiu, tana patsuu na nainy tana Sande tan vaamuan nan nainy tana wik, Meri na muiny Magdala ai Meri ito na mesmes kanen, naa a tou nak a puts te soon e Jisas. ");
INSERT INTO sps_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sen tsun ana nuu na parits fiisok gunainy to na pan; ana morena tana Tsunaun of mito peto poo fi me Gormirmir fakukuur ravainy to na fats ana ya gum enato. ");
INSERT INTO sps_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Puan Ya te faarein kanaf an raarav tsunia te faarein kafof gosee. ");
INSERT INTO sps_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Rin tsoiny bei ot oraav fiisok tsun rato ser totoroor er, ri faarei ton vainy mat. ");
INSERT INTO sps_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ana morena vegiau to tan moun, “Oraav vaare yam,” tsue fi ya, “nyo nat you mi sainy rom e Jisas to te gageits tana pagafuan. ");
INSERT INTO sps_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ayei gima kaa bus non tovei; Ayei te tsun fatabin en, to te tsue fi Ya. Taami yam am tagaa to tana pan te soon Ya. ");
INSERT INTO sps_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kuar veesau yam am tsue of ton matisian Tsunia, ‘Ayei te tsun fatabin en tana mat, ana Ayei mumua maromi unya Galili; ana mi te nai tagei Ya na aya!’ Nyo tsue of bus mami.” ");
INSERT INTO sps_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ana ri naus osing veesau tsuiny ton puts te soon e Jisas, ri oraav sana ri mamagat fiisok ror ri kuar to ser nai tsue of ir matisian Tsunia. ");
INSERT INTO sps_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sen tsun ai Jisas tainytainy ratuari sa tsue na ka, “Aaverof kaa non fapoopoan namami.” Ri naa mito siruu panan Ya ri saras to na moun Ya ana ri faatouf Towa. ");
INSERT INTO sps_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Oraav vaare yam,” tsue fi Jisas tsuri. “Kuar yam am tsue of raton fuainy vamuinyasiny Tsonyo ma naa fi ri tana gum fan iny Galili, ana ri te nai tagaa Vanyo na aya.” ");
INSERT INTO sps_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te taataan fi naan moun sanaan, rin tsoiny bei ot to te bei ot iny a puts tabin fatabin rato tana ngats fan tsian Jerusalem ser tsue fanat tan tsunaun tan tsoiny faakor a fo mamatsiny ka te ruak. ");
INSERT INTO sps_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Rin tsunaun tan tsoiny faakor vaaguam fiisen ramiton tsunaun tana taa Jiu ri kat ton fakats tsuar; ri faan ir tsoiny bei ot painy moni na karap fiisok ");
INSERT INTO sps_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ser tsue na ka, “Mi tsue of rom a vainy a ka tovei, ‘U matisian Tsunia te naa me tana voiny, ri kabuts to na puan Ya ana mi goros em.’ ");
INSERT INTO sps_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ai to te nongoiny fi non a Gavana Pailat a ka to, mam tsue faparits of rom Ya mi te gima govets a patang to.” ");
INSERT INTO sps_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Rin tsoiny bei ot nom to na painy moni ri kat to na ka te tsue of rari ri. An vaanan to saats vavis to na taa Jiu onot patsukan non to roman. ");
INSERT INTO sps_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ri na ina safunuu ana isen a matisian naa to tana gum fan iny Galili tana tobeer to te tsue of rari Jisas ma naa fi naa ri. ");
INSERT INTO sps_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te tagei ari Ya, ri faatouf Towa, sana mesapan tsuri vaa'ets kan. ");
INSERT INTO sps_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas fasiruu naa tsuri sa tsue na ka, “Gov faan Vanyon gumgum faavot ma tatagaa ot iny Anyon fo mamatsiny ka iny Gormirmir ai nei petoo. ");
INSERT INTO sps_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","To tsumi ma kuar yam, tana vainy faavot tan fo mamatsiny pan faavot am faatsuts ratuari er faarei miton matisian Tsonyo: fapeenainy ir yam tana asangan a Taman, tana Guei Tsoiny an tan Aaven Taabos, ");
INSERT INTO sps_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","am faatsuts ratuari ma manaats arin fo mamatsiny vegiau to te tsue of im yam. Anofe vaare yam, Nyo nai kaa fiisen mamiromi tan mamatsiny nainy, onot non tan fafakap nana monaagits to.” ");
INSERT INTO sps_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tovein Vurungan Rof nane Jisas Krais a Guei Tsoiny ten Gov. ");
INSERT INTO sps_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Faarein tsuiny kainy non to te kirkir bus iny e Aisaia na kuigin ten Gov muan sa tsue na ka, “Tovei na tsoiny favaanan Tsonyo,” te tsue fi Gov ten Jisas, “te jiats famumuei nats Ronyo Tsumanyi, ma kakoun ya na sanaan Tsuan. ");
INSERT INTO sps_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ayei na isen te vegiau fabaasuan me koman a pan a uur, ‘Kakoun onots of yam a Tsunaun a aavem, mi te vatsvats of Yan kat tsuam ma faarei ya na sanaan iny naa me Tsunia.’” ");
INSERT INTO sps_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","To sen Jon a tsoiny fapeenan ruak me koman a pan a uur sa favaanan, ya tsue to, “Faonot yam, mi reesik to am takopis osing to na fo aveto tsuam, ana mi te tap naa ten Gov, tana ka to aya Gov nai anofe ravainy non a fo aveto tsumi, nyo te nai peenainy mami.” ");
INSERT INTO sps_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vainy naa me tsunia poo fi me tana ngats fan tsian iny Jerusalem ai tana fo mes a fo ngats fan tana gum fan iny Judia a tou nongon ten Jon. Ri pokein fo aveto tsuar sen Jon fapeenainy rari tana aurom iny Jodan. ");
INSERT INTO sps_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon popous iny funuu nana kamel faarei non pous tan kuigin, ya kaa kan miton vakiri u pous tsunia. Ya ainy ton kookai an sisingif. ");
INSERT INTO sps_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ya favaanan to tana vainy, “Te vovou minon tsonyo, Ayei karap fafisfis varonyo, nyo gima onot faarof kan ma tsunguruu, nyo te puruur a patom nan su Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nyo peenainy maromi tana aurom, sana Ayei nai peenan maromi tan Aaven Taabos.” ");
INSERT INTO sps_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tan nainy to aya Jisas poo mito tana ngats fan iny Nasaret tana gum fan iny Galili ai Jon peenainy Towa tana aurom Jodan. ");
INSERT INTO sps_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te ruak osing me Jisas a aurom, sen tsun Ya tagei na korosuu tapue an Aaven Taabos of mito Tsunia faarei na kurume. ");
INSERT INTO sps_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","An sen vegiau poo mito Gormirmir, “Anyi na Guei Tsoiny Tsonyo te kaa non koman Tsonyo, Nyo koma rof marom Anyi.” ");
INSERT INTO sps_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sen tsun, an Aaven Taabos nom finy naa Towa tana pan a uur ana nang iny nuaf. ");
INSERT INTO sps_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ya kaa ton fats safunuun nainy tan fiamus ten Satan, Ya kaa fiisen ra miton marei sensen vouts, an morena ten Gov naa mito ser faakouts Ya. ");
INSERT INTO sps_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Te kaa bus e Jon tana numaa iny kotskots Jisas naus osing to na gum fan iny Judia, Ayei naa fi enato tana gum fan iny Galili sa favaanan iny Vurungan Rof te poo me ten Gov, ");
INSERT INTO sps_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ya tsue to, “Nainy te ruak en, a Waan e Gov te sisiruu ename, Reesik yam, am takopis osing ton fo kat iny aveto tsumi, ana mi te tap naa ten Gov, mi te faamainy Vurungan Rof!” ");
INSERT INTO sps_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas taan ereer naa non tana naaman iny Galili, Ya tagei rato ere Saimon me Anduru u mumuinyasiny vavagaar jian naaman men muav tsuar, tana saa arin tsoiny nawaan. ");
INSERT INTO sps_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas tsue to tsuri, “Taami yam, am vovou Vatuanyo, ana Nyo te faatsuts mamin kat iny nonom mes faarei to te saasauf jian fi mi.” ");
INSERT INTO sps_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sen tsun, ri fakei ravainy ton muav tsuar ser vovou naa Ya. ");
INSERT INTO sps_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ri fataan vaarik naa to, ai Jisas tagei raton mes mumuinyasiny, Jemis me Jon guei tsoiny ten Sebedi. Ri kaakaa er koman puak um'um muav tsuar. ");
INSERT INTO sps_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sen tsun Ya fikoo ratuari, ri naus osing to tamar e Sebedi an vainy binun tsuri koman puak ser vovou naa Jisas. ");
INSERT INTO sps_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ri naa fi naa to tana ngats fan iny Kapeniam tana gum fan iny Galili an tan Nainy fafaatouf tana taa Jiu Jisas sof to tana numaa iny fafaatouf tana taa Jiu Ya faatsuts rato na vainy. ");
INSERT INTO sps_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ri saar tana sanaan to te fafaatsuts fi Ya tana saa Ayei kaa me na parits faarei non a mes te fa'asangan non tan gumgum, sikia ma faarein Tsoiny Fifaatsuts tan Faun tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gima potsian, koman a numaa iny fafaatouf na aya te kaa me na mes a tutuei iny masarau, sa kuu fatsian en, ");
INSERT INTO sps_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“A saa te komainy kat rom Anyi tsumam na, O Jisas iny Nasaret? Kat fei, Nyi of me naa tou ruraa mamam? Anyo nat marom Anyi, Anyi na Mes a Taabos poo fi me ten Gov!” ");
INSERT INTO sps_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ai Jisas tsue ets'ets to na masarau, “Tomani, nyi te tafuts osing a mes tovei.” ");
INSERT INTO sps_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ana masarau kat fatotoroor towa sa kuu men tangis tsian, ya tafuts osing towa. ");
INSERT INTO sps_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ana ri na fokinai saar fiisok to ser fararangat fatabin ir, “A saa bus to aya nan na? U fafaatsuts foun kaa minon parits? A mes to te kaa minon gumgum iny faan iny tsuen parits tan masarau ri te manaats Ya.” ");
INSERT INTO sps_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","An vaanan nane Jisas saats vavis to na ngats fan faavot tana gum fan iny Galili. ");
INSERT INTO sps_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sen Tsun ri naus osing to na numaa iny fafaatouf tana taa Jiu, ri toobing naa to numaa ten Saimon me Anduru, Jemis me Jon naa fiisen kan ra naa ri. ");
INSERT INTO sps_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","E nuan e Saimon a soon iny faadis, faadis me na puan a fisikii. Sen tsun ri tsue of to Jisas tsunia. ");
INSERT INTO sps_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ya naa to sa nom niman ya Ya ras fatsuiny towa, ana faadis naus osing towa sa kakoun of ratuari na kainy ainy. ");
INSERT INTO sps_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te ananerof busen, te ruk nana nuaf ri atoiny miton vainy faadis ten Jisas an vainy kan tutuei iny masarau. ");
INSERT INTO sps_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ana fokinai tana ngats fan vaaguam mito matan a numaa te kaa non e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisas tsipaar ton vainy a kinai te kaa men fo viir faadis sa buur ravainy kainy fo masarau komar a vainy. Ana Ayei gima famanat raton masarau ma tsue ri ta ka, tana saa ri nat iny Ya, Ayei na Krais. ");
INSERT INTO sps_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Patsuu na nainy tabuiny arasan minon a pan, Jisas tsun Ya naus osing to na ngats fan sa naa naa tana pan a tomani Ayei Tsivon, Ya faakats to na aya. ");
INSERT INTO sps_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ai Saimon fiisen men vaatau tsuan naa to ser vovou naa Ya. ");
INSERT INTO sps_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te sab ari Ya ri tsue to Tsunia, “A fokinai tsikoo marom Anyi!” ");
INSERT INTO sps_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ana Ayei tsue to tsuri, “Tanats yam, ra ma naa tana mes a fo fan siruu ma favaanan kan Anyo na aya, tana saa ayei na ka te of mi Nyo.” ");
INSERT INTO sps_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ya naa vavis to tan fo mamatsiny pan tana gum fan iny Galili, sa favaanan koman a fo numaa iny fafaatouf tana taa Jiu, Ya buur ravainy ton fo masarau tana vainy. ");
INSERT INTO sps_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ana mes a tatauba naa mito ten Jisas, ya tsunguruu to, sa sing ta fifaakouts. “Te koman fi rom Anyi, Nyi onot rom ma fataabos vanyo.” ");
INSERT INTO sps_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas kaa men reesik Ya faarua iny naa to na niman sa saras ya sa tsue tsunia, “Nyo koman rou, taabos sanyi!” ");
INSERT INTO sps_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sen tsun an tatauba naus osing towa, ya taabos enato. ");
INSERT INTO sps_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ai Jisas tsue faparits of towa, Ya jiats veesau towa fiisen men vegiau parits, ");
INSERT INTO sps_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tagaa, tsue vaare na ka to tan ta mes; sana nyi ma naa fatoobing tsun naa tana tsoiny faakor ma tagaa faarof ya tsumanyi, ana nyi te kat a faakor to te tsue iny Faun te kirkir iny e Moses muan, tan kat to aya ma nat ari na fokinai nyi taabos em.” ");
INSERT INTO sps_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Te naa bus naa na mes ya tanik iny saats vavis ton vaanan tan mamatsiny fan, tana ka te kat e Jisas tsunia, tan kat to aya Jisas gim to ma naa koman a ngats fan ana ya kaa osing to na vainy tana pan a uur. Sana vainy poo fi me tan fo fan vavis, naa mito Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tan mes nainy Jisas fatabin pis to tana ngats fan iny Kapeniam ser favaanan iny Ya te kaa non numaa. ");
INSERT INTO sps_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Fokinai vaaguam to ser ovot, ana numaa pan faavot nato. Sikia ta pan matainy sobaa, Ya favaanan to tsuri. ");
INSERT INTO sps_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ina fats a mes govets mito na mes a nima mat ana mou mat ten Jisas. ");
INSERT INTO sps_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sana ri sikia ma onot ma atoiny naa ya Tsunia, tana saa vainy a kinai. Ri des to na painy gotof matuen ya, te nom ravainy ari na painy gotof, ri fasooiny towa tan nenengan ri fauf naa towa. ");
INSERT INTO sps_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas tagei a faason tsuri, Ya tsue to tana mes a faadis, “Guei tsiau, aveto tsumanyi te anofe ravaa en.” ");
INSERT INTO sps_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mesapan nar tsoiny fifaatsuts tan Faun te kirkir iny e Moses te gumgum fafakats komar, ");
INSERT INTO sps_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kat fei tana mes tsue to ei, Ayei fifanauti minon e Gov ei! Sikia ta mes te onot non ma anofe ravainy aveto, e Gov tsun Tsivon!” ");
INSERT INTO sps_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sen tsun, Jisas nat rari tana aaven, te kaa fi mi rin fakats to komar, Ya tsue to tsuri, “Kat fei tsumi kaa men fakats fi nei koma mami ei? ");
INSERT INTO sps_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Saf vegiau te opaar non Tsonyo ma kat na? Te tamee non Tsonyo ma tsue tana mes a nima mat ana mou mat, ‘Nyo anofe ravainy fo aveto tsumanyi,’ ge tamee fafis non tan tsue fi nei, ‘Tsun, nom nenengan tsuam, nyi te taan?’ ");
INSERT INTO sps_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Sai tovei nyo faatok maromi ma nat fi nei, A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me kaa minon gumgum tana monaagits to tan anofe ravainy aveto.” Ai Jisas tsue to tana mes a nima mat ana mou mat, ");
INSERT INTO sps_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nyo tsue rou tsumanyi, tsun, nom nenengan tsuam nyi te naa numaa tsuam!” ");
INSERT INTO sps_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ana mes tsun to sa nom veesau tsuiny nenengan sa taan fatoobing tsun naanaa mata rari na fokinai. A ka to aya te kat rari ser saar ri vamarits to Gov, ser tsue, “Ara sikia ma tagei ta ka ma kat fi nei muan.” ");
INSERT INTO sps_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas fatabin fi naa mou poporos tana naaman iny Galili. Ana fokinai naa faavot mito Tsunia, Ya faatsuts ratuari. ");
INSERT INTO sps_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ayei taan naa to, Ya tagei to Livai a guei ten Alfias vaagum non numaa tana pan iny nonom takis. Jisas tsue to tsunia, “Vovou you.” Livai tsun to sa vovou iny e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Te gum iny ainy e Jisas numaa ten Livai an vainy nonom takis an vainy pisiin gum fiisen mito Jisas an matisian Tsunia, tana saa a fokinai to ari natiny vovou iny ror Ya. ");
INSERT INTO sps_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mesapan tsurin tsoiny fifaatsuts tan Faun te kirkir iny e Moses, te koo rorin Farasi tagei e Jisas te ainy fiisen ramen vainy pisiin an tsoiny nonom takis, ri rangat raton matisian Tsunia, “Kat fei sa ainy Ya jiu fiisen ramirorin vainy nonom takis an mes vainy pisiin ei?” ");
INSERT INTO sps_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas nongoiny vegiau to sa tsue rari, “Vainy toto faarof gim ror ma komainy a tsoiny tsipaar, a sikia, vainy tsun ton faadis. Nyo gima naa me ma fikoo Nyon vainy tavaron sana Nyo te naa me ma fikoo Nyon vainy pisiin.” ");
INSERT INTO sps_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","U matisian ten Jon a tsoiny fapeenan ana taa Farasi natiny tavtaav ror tan nainy faakats ten Gov. Ana vainy naa mito ten Jisas ser rangats Ya, “Kat fei san matisian ten Jon an matisian tana taa Farasi natiny tavtaav ror ma ainy, san matisian Tsumanyi gim ror ma natiny tavtaav ei?” ");
INSERT INTO sps_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas tsue fatabin to tsuri, “A vainy naa miror tan guainy tan fanging vaagum fiisen miror tsoiny fanging gim ror ma natiny tavtaav iny kainy ainy teeva? Sikia. Nainy te faarei Anyo na tsoiny fanging, Nyo kaa fiisen ramituarin fuainy matisian Tsonyo, mam ainy to. ");
INSERT INTO sps_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sai vou, vainy nai nots Varonyo, Nyo te kaa osing ir matisian Tsonyo tan nainy to aya, matisian nai tavtaav ror.” ");
INSERT INTO sps_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Sikia ta mes te onot non ma keres ta painy vau foun a kuiny towa na takakaar tan vau tamuan. Te kat fi non ya nei, ana pan a foun te kat kakaar fatsiainy a pan a tamuan, ana takakaar te nai bangbang fafis en. ");
INSERT INTO sps_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sikia ta mes te onot non ma itsuf wain foun tana iikan a tamuan. Te kat fi non nei, an wain foun te kat pung a iikan a tamuan, an wain te tatsiiu ravaa ana iikan te nai kajiaa en. U wain foun te rof non tana iikan a foun.” ");
INSERT INTO sps_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tan sen Nainy Fafaatouf tana taa Jiu, Jisas taan naa koman tanun wit. Te taan fiisen mi naa Yan matisian Tsunia, ri tanik iny ngats ton wit ser ainy ya. ");
INSERT INTO sps_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kat to ana Farasi tsue to ten Jisas, “Tagaa, te sikia non ma toobing tana Faun tsura te binun fi ror matisian Tsumanyi tan Nainy Fafaatouf!” ");
INSERT INTO sps_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisas biny ratuari, “Mi gogosias a ka te kat e Devit a Aatouf a Tsuvurara fiisen men vainy tsuan te ves ari muan! ");
INSERT INTO sps_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tan nainy ten Abiata a Tsoiny Mumua tan Tsoiny Faakor, ayei naa sa sof a saape ten Gov ana tsoiny faakor famanat iny towa ma nom koinykoiny te faan iny ari matan e Gov sa ainy ya, ya fafaan ratuarin vainy tsuan. Sai tan Faun tsoiny faakor tsun onot ror ma ainy ya. Devit gima kat aveto an matisian Tsonyo kan gima kat aveto.” ");
INSERT INTO sps_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ai Jisas tsue to tsuri, “Gov kat Nainy Fafaatouf iny faakouts a mes. San te sikia ma kat a mes ma vovou tsun iny yan Faun nan Nainy Fafaatouf, ayei tapuruur ma kat a fo ka ayei ma kat tan Nainy Fafaatouf, ");
INSERT INTO sps_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","tana saa a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me te Tsunaun kan iny non Nainy Fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ai Jisas tabin fatabin naa to tana numaa iny fafaatouf tana taa Jiu. A mes te kaakaa na aya a nima pengong. ");
INSERT INTO sps_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mesapan tsuri te kaa kan na aya komainy ma tsikoo ta sanaan ma fakei ari Jisas tan vaatsuk tan ta iring te kat non Ya to ser vavaatok iny Ya to te tsipaar finy non Ya ta mes tan Nainy Fafaatouf tana taa Jiu. Kat to Ayei te ngats non Faun te tsue fi non nei, “Binun vaare tan Nainy Fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas tsue to tana mes a nima pengong, “Taame nei matan.” ");
INSERT INTO sps_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ya kat to saa rangats ir a vainy, “Fei te famanat fi roran Faun ei tan ta ka ta rof ma faakouts ara na mes tan Nainy Fafaatouf ge kat fifiiring ror ya? Iny saup a toto tana mes ge kat famat ya?” Ana ri sikia to ma tsue ta ka. ");
INSERT INTO sps_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas matoong fagoguas ratuari fiisen me na peits, tana saa Ayei te koma patang iny a komar a fokinai te tsuu men kat iring. Ya tsue to tana mes, “Paroor a nimam.” Ya paroor to na niman sa rof fatabin en. ");
INSERT INTO sps_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Te vavakas osing a taa Farasi na numaa iny fafaatouf tana taa Jiu, ri vaagum fiisen ramiton mes panainy vainy ten Herot a Aatouf ser kat a fo sanaan iny atsuiny e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas an matisian Tsunia te naus osing a fan ser naa tana naaman iny Galili ana fokinai vovou iny Towa. Ri poo fi me tana gum fan iny Galili ai tana gum fan iny Judia, ");
INSERT INTO sps_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ai tana ngats fan iny Jerusalem ai tana gum fan iny Idumia, ai tan mes panainy aurom iny Jodan ai tana fuan a ngats fan iny Taia ai Saidon. A fokinai naa me ten Jisas a tou tagaa tana saa te nongoiny ari tana foka te kat Ya. ");
INSERT INTO sps_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tagin tsian sen Jisas tsue of ir matisian Tsuan, “Kakoun onots of Vanyo yam puak ma jias Anyo tana vainy te fasoksok ror kat ror ser sok Vanyo.” ");
INSERT INTO sps_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jisas tsipaar a vainy a kinai san vainy faadis fifaruaa tsun iny me naa tsivor ma saras ari Jisas. ");
INSERT INTO sps_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Arin vainy te kaa men masarau tagei tsuiny ror e Jisas, ri naa miror Tsunia ri te fatukun ri te tsunguruu matan ya fiisen me na pua rarin totoroor ri te kuu, “Anyi na Guei Tsoiny ten Gov!” ");
INSERT INTO sps_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisas tsue tap raton masarau ma pokei vaare ri na asangan Ya. ");
INSERT INTO sps_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas naa to patsun a painy tet, Ya fikoo rato na vainy te komainy non Ya ma naa mi ri Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ya pisainy to na safunuu ana ina fuan to te koo rorin Amaraav sa tsue na ka, “Nyo pisan mami ma kaa fiisen Vaminyo, Nyo jiats maromi ma nai favaanan iny Vurungan Rof, ");
INSERT INTO sps_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ana mi te kaa me na parits iny buur ravainy masarau.” ");
INSERT INTO sps_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tovei na safunuu ana ina fuan te pisan Ya: Saimon Jisas faan iny a asangan to Pita, ");
INSERT INTO sps_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemis an famuinyasiny tsunia Jon, u guei tsoiny ten Sebedi (Jisas faan rarin asangan to Boanajes, man nan ya “A vainy parits faarei ror barak”), ");
INSERT INTO sps_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduru, ai Filip, ai Batolomiu, ai Matiu, ai Tomas, ai Jemis a guei tsoiny ten Alfias, ai Tadias, ai Saimon ayei na isen tsuri na gum iny vainy te kat iny nom ravainy ror gumgum iny Roum, ");
INSERT INTO sps_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ai Judas Iskariot, ayei na mes te nai faan iny e Jisas tan vainy ma atsuiny famat ari Ya. ");
INSERT INTO sps_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas naa to tana fan, ana vainy a kinai vaaguam mito ten Jisas ser sikia ma kaa me tu nainy iny ainy fiisen ramen matisian. ");
INSERT INTO sps_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nainy te nongoiny nuatsin Ya na ka to ri naa mito a tou nom Ya, tana saa, a vainy tsue ror, “Piou busen!” ");
INSERT INTO sps_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","U tsoiny fifaatsuts tan Faun te poo me Jerusalem te tsue na ka, “E Belsibul a masarau te tutuei Ya! Ayei natiny buur ravainy non masarau tana saa Belsibul a tsunaun tan masarau te faan Ya na parits iny kat a foka to.” ");
INSERT INTO sps_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisas fikoo rato na vainy ma naa mi ri Tsunia ai te tsue of rarin tsue fapapaar. “Fei te kat fi non e Satan a buur ravainy ton masarau ten Satan ei? ");
INSERT INTO sps_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","A vainy tana isen a gum fan takibaa ror ri te kat a fuan a pan ri te fataatsun, a gum fan to aya gim non ma nai kaa fapotsian nats. ");
INSERT INTO sps_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A vainy tana isen a numaa nai takibaa ror tana fuan a gum ana ri te fataatsun a numaa iny guei to aya nai taruraa eraror. ");
INSERT INTO sps_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ana waan e Satan te nai takibaa ror tana fuan a gum ri te fataatsun sikia non ma potsian nai taruraa eraror ana ayei te nai kajiaa ovei en. ");
INSERT INTO sps_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","A sikia ta mes te onot non ma sof a numaa tana mes a parits a fag to na fo mamatsiny ka tsunia onot non tsunia ma kotskots tsom a mes a parits to, vou ya te see sofsof a numaa tsunia ya te fag a fo mamatsiny ka. To te faarei kainy Varonyo, Nyo onot rou tan rurei ravainy a parits ten Satan. Ka to te faatok iny non a ka Nyo onot rou ma buur ravainy masarau. ");
INSERT INTO sps_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nyo tsue faman of maromi, na fo mamatsiny kat iring te natiny kat ror a vainy ge te tsue rori Gov anofe ravainy non ya, ");
INSERT INTO sps_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","san e sei te tsue vaaserere iny non Aaven Taabos ee Gov sikia on non ma anofe ravainy ya, tana saa ayei te kat, kat iring suu.” ");
INSERT INTO sps_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas tsue na ka to, tana saa mes panan te tsue na ka, “E Belsibul a masarau te tutuei Ya.” ");
INSERT INTO sps_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsinan Jisas an famuinyasiny Tsunia ruak ser tsutsun jiarasan tana numaa ri faan iny naa ton vegiau Tsunia ma naa mi Ya tsuri. ");
INSERT INTO sps_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A vainy a kinai gum faafis e Jisas, ana ri tsue of Towa, “Tagaa, e tsinamanyi an famuinyasiny Tsumanyi te kaa ror jiarasan te komainy marom Anyi.” ");
INSERT INTO sps_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ai Jisas biny ratuari, “E sei tsinanyo ee, ai sei fuainy famuinyasiny Tsonyo ee?” ");
INSERT INTO sps_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ya matoong rato na fokinai te gum faafis Ya sa tsue, “Tagaa! U fuainy tsinanyo an fuainy famuinyasiny Tsonyo to ari! ");
INSERT INTO sps_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","E sei tsun te kat non mangiir ten Gov ee, ayei famuinyasiny Tsonyo, ai fafinevanyo ai tsinanyo.” ");
INSERT INTO sps_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas tanik iny faatsuts pis panan a naaman iny Galili. An tagin vaaguam to ser bau faafis Ya, tsurin kinai fiisok, Jisas jias enato tan puak ana Ya gum to koman ya ana fokinai tsutsun er teis. ");
INSERT INTO sps_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jisas fafaatsuts iny a ka na kinai tan tsue fapapaar, ai tan fafaatsuts Tsunia, Ayei tsue na ka, ");
INSERT INTO sps_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nongon yam, a mes iny rereev tanun te nai saats vavis iny fua. ");
INSERT INTO sps_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te piat iny yan fua koman a tanun, an mes fua gotsiny to sanaan an marei naa mito ser ainy ya. ");
INSERT INTO sps_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mes a fo fua gotsiny to tan puputaan fatsfats te kaa men ar kakaiiny puputaa tsun. An fua gian veesau tsun nato, tana saa, u puputaan sikia ma boo. ");
INSERT INTO sps_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Te pas me na nuaf jias ya nang to ana foka maas faavot nato, tana saa, u guan te sikia ma sua fagagon naa. ");
INSERT INTO sps_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","An mes fua gotsiny to tan puputaa te kaa men fua nan kakarits gagon tan puputaa fapoopoan narari, an kakarits gian to ser pis ya sa sikia ma kaa me tu fua. ");
INSERT INTO sps_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","San mes a fo fua gotsiny tana pan te kaa men puputaan rof, koo ser gian ser karap ri kaa miton fua; mes fua sa onots tonuafunuun fua, mes aunom safunuun fua, an mes isen natus fua.” ");
INSERT INTO sps_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ai Jisas tsue pis to na ka, “Mes kaa minon teinan iny nongon ma nongon faarof!” ");
INSERT INTO sps_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Te kaa tsivon e Jisas, ana ri to te nongon fiisen ramen safunuu ana ina fuan a matisian Tsunia ser rangats Ya ma fa'arasainy Yan fo tsue fapapaar. ");
INSERT INTO sps_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ya tsue to tsuri, “A nat nana ka na takop muan nana Waan e Gov te faan fakap en tsumi sai tana mesapan te kaa ror jiarasan Nyo vegiau tan kat tan tsue fapapaar, ");
INSERT INTO sps_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","tovei ri matoong ror sana ri sikia ror ma tagaa fanatnat iny ya, ‘Ri nongon ror sana ri nongon tsun ror sikia ror ma nongon fanatnat iny ya. To te nongon fanatnat iny rori ya, ri onot ror ma takopis osing aveto, ai Gov te anofe ravainy fo aveto tsuri, sana ri baainy er.’” ");
INSERT INTO sps_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas rangat ratuari, “Mi sikia ma arasan tan tsue fapapaar to? Fei te kat fi romi ei, mi te natiny fo tsue fapapaar ei? ");
INSERT INTO sps_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nongon yam, am natiny ton man nan tsue fapapaar nana mes te saats fua tanun. A tsoiny sasaats te saats iny fua te faarei ror vegiau ten Gov. ");
INSERT INTO sps_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A fo fua te gotsiny panan a sanaan faarei ror a vainy te nongoiny vegiau sa sikia ma potsian Satan naa me ya nom ravainy ton vegiau te kaa aave rari. ");
INSERT INTO sps_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","An mes fua gotsiny to tan puputaan fatsfats faarei raror a vainy te nongoiny vegiau ser paparaa tan nom ya. ");
INSERT INTO sps_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sai te gima kaa fagagon naa aave rari to ayei na ka te gima kaa fapotsian of ya aave rari. Tan nainy patang ge kamits te ruak non tana saa ri faamainy vegiau ten Gov, ri faravaa veesau tsun iny vegiau ten Gov te kaa aave rari. ");
INSERT INTO sps_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","An mes fua gotsiny koman puputaa te kaa men fua nan kakarits gagon faarei raror vainy te nongoiny vegiau, ");
INSERT INTO sps_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sana ri koma patang fiisok iny a toto tan puputaa to ai tana masun to te komainy fiisok rori, to ayei na ka te kat fasasapam of rorin vegiau ten Gov to sa gima fua. ");
INSERT INTO sps_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","An mes fua gotsiny to tan puputaan rof faarei raror vainy te nongoiny vegiau ten Gov ser arasan iny ya, ri faarof iny towa ser fua faarof, mes fuan kiok, mes fuan kinai, an mes fuan kinai fiisok.” ");
INSERT INTO sps_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas tsue pis to tsuri, “A sikia ta mes te govets minon kurun ya te fakei ya fain kobuu ge fain a fetan. A sikia, ayei fagum non ya tana pan iny fafagum kurun. ");
INSERT INTO sps_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Saf a fokan takop na nai kat faruak non ana saf a foka na famun naa nai sab non ri te fakei ya tana arasan. ");
INSERT INTO sps_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nongon yam, mes kaa minon teinan iny nongon ma nongon faarof!” ");
INSERT INTO sps_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ana Ayei tsue to tsuri, “A foka te nongoiny romi mi ma fakats faarof. Gov faan faonot tsun iny non ya tana nat te kaa mirom anyi to te vanongon faarof fi rom anyi, ");
INSERT INTO sps_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","tana saa, e sei na mes te kaa minon a nat a man nana Waan e Gov ee, Gov nai faan pis iny non a nat nana Waan Ya. Ai sei na mes a sikia ee, Gov nai nom ravainy non a ar kakaii nat kan tana Waan e Gov te nai kaa minon ya.” ");
INSERT INTO sps_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ai Jisas tsue pis to, “A Waan e Gov faarei non a mes te piat vavis iny fua tanun tsunia. ");
INSERT INTO sps_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sa goros tana voiny ya tagun to tana nuaf an fua gian patsukan raror. Sana ayei sikia non ma nat iny a sa te fagiainy non ya na. ");
INSERT INTO sps_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","U puputaa patsukan te kat non a foka te reev rora ai te nai gian vou ai te fua, u toguur ruak faamuan minon vou an vorag ai te firaar patsun ya. ");
INSERT INTO sps_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te matsua fakap non fua ana mes te taan men kirat tsuan, tana saa u nainy agio te ruak busen.” ");
INSERT INTO sps_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ai Jisas rangat pis to, “Fei te fapapaar finy rora na Waan e Gov ei? An saf tsue fapapaar te onot rora ma fa'arasainy na? ");
INSERT INTO sps_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Te faarei non fua nan Mastat, a mes te nom ya sa reev ya tan puputaa. Te kakaii fafis iny non a fo fua faavot tana monaagits to, ");
INSERT INTO sps_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","sai te gian non ya te kaatsian fafis pis raror fo mamatsiny ka koman tanun ana fo naan fasua ror ri te karap onot ror marei ma kat sai tsuar tana maruf nan ya.” ");
INSERT INTO sps_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Fiisen men fokinai senviir tsue fapapaar Jisas vegiau tsuri faonots ya tsuri ma nat faarof iny ari ya. ");
INSERT INTO sps_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ayei gima kuar ta fo mes ta fo sanaan, Ayei vegiau fatatabin iny a fo tsue fapapaar to. Sai tan nainy te kaa fiisen ramirori matisian Tsunia, Ayei natiny fa'arasainy non fo mamatsiny ka. ");
INSERT INTO sps_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tana ananerof tan nainy patsukan to aya. Jisas tsue to tan matisian Tsunia, “Tanats yam ma guas naa ra tan mes panaan nana naaman.” ");
INSERT INTO sps_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ri naus osing ir tagin, an matisian jias to tan puak te kaa Jisas ri naa fiisen mi naa Towa. Mes fo puak te kaa kan. ");
INSERT INTO sps_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","An sekeiny ratsuu tapoor mito naaman an rau tsian tangats mito san puak fabuu nato. ");
INSERT INTO sps_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sen Jisas kaa en tau nan puak Ya soon to sa itong tan ititong ya goros to. An matisian guinyguiny Towa ser tsue Tsunia, “Tsoiny Fifaatsuts, Nyi sikia rom ma tagtag rara, tsura kat iny mat osto.” ");
INSERT INTO sps_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisas tsun to sa tsue ets'ets a ainysat, Ya tsue to tan rau, “Madaav! Tomani!” Ana ainysat sariof ovei nato, ana madaav ras to. ");
INSERT INTO sps_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ai Jisas tsue to tsuri, “Kat fei sam oraav rom ei? Ami na sikia taa faason farokot Tsonyo?” ");
INSERT INTO sps_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sana ri saar rato, “E sei na mes to aya ee, to tana ainysat an rau manaats Ya?” ");
INSERT INTO sps_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ri ruak to tan mes panaan nana naaman iny Galili tan mounan tana taa Gerasa. ");
INSERT INTO sps_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tan nainy te tsun e Jisas ya of osing ton puak, ana mes tutuei iny masarau tainytainy Towa poo fi me tan katskats fain a varian, ");
INSERT INTO sps_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","tana saa mes to aya natiny kaakaa non tan katskats te kat ari tana varian, sikia ta mes te onot non ma kotskots pis ya tan taa tseen. ");
INSERT INTO sps_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Fokinai nainy, ri natiny kotskots ror a niman ya ana moun ya na tseen sana ayei natiny nepong raravainy non ya, sikia ta mes te onot non ma kat tap iny ya. ");
INSERT INTO sps_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mamatsiny nainy tan nuaf ai tan voiny ayei natiny kaa vavis non fapoopoan nan katskats ai patsun a tobeer, natiny dau iny mat non, ana ayei pee kainon a tsivon fats. ");
INSERT INTO sps_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nainy te tagei naa ya Jisas te veevian vaarik kanen nanon ya kuar to sa fatukun, ya tsunguruu to moun e Jisas, ");
INSERT INTO sps_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","sa kuu men tangis tsian, “Jisas, Guei Tsoiny tana Gov a tsigtsig! A saa te komainy kat rom Anyi tsonyo na? Tana Asangan e Gov nyo sing marom Anyi fakamits vaare you!” ");
INSERT INTO sps_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ayei tsue fi nei tana saa Jisas tsue faparits of bus ir masarau ngi'arapaar ma tafuts osing ari na mes to. ");
INSERT INTO sps_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ai Jisas rangats towa, “E sei na asanga manyi ee?” Ana mes biny towa sa tsue, “Asanga vanyo, Tagin Tsian, tana saa amam kinai fiisok.” ");
INSERT INTO sps_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Masarau sing faparits to Jisas ma gargar vaare rari Ya tana pan to aya. ");
INSERT INTO sps_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","U veis voon kinai fiisok siruu te ainyainy tan panaan tet. ");
INSERT INTO sps_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","An masarau sing to Jisas, “Jiat fi mamam tan veis voo, nyi ma famanat mamam ma sof amam tsuri.” ");
INSERT INTO sps_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ana Ya famanat ratuari. An masarau ngi'arapaar tafuts osing mito na mes ri sof ton voo. An veis voo faavot, onots toromainy non fuan a tapan, kuar to ser tsiak naa tana varian tsidup a naaman ser ruk faavot er ri mat rato. ");
INSERT INTO sps_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ana vainy te tatagaa ot ir veis voo bus fi rato ri saats vavis to na pan tan vaanan tan ngats fan ai tana fo mes a fo fan. Ana vainy naa to, a tou tagaa tana saa te ruak na. ");
INSERT INTO sps_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ri naa me ten Jisas, ri tagei to na mes iton masarau kinai fiisok te tafuts osing ya gum non petoo te kaa men vau an fakats arasan ser oraav ya. ");
INSERT INTO sps_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A vainy te tagei a foka te ruak tsunia tsue of rato na vainy a foka te ruak tana mes ton masarau te tafuts osing ya an voo. ");
INSERT INTO sps_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ana ri sing to Jisas ma naus osing Ya na pan tsuri. ");
INSERT INTO sps_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisas jias naa non koman puak, ana mes ton masarau te tafuts osing ya sing to Jisas, “Nyo komainy naa fiisen ma mirom anyi.” ");
INSERT INTO sps_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sen Jisas sikia ma nongoiny ya, Ya tsue to tsunia, “Kuar fan tan vainy tsumanyi, ana nyi te tsue of ir a vainy tana ka te kat a Tsunaun tsumanyi, ana tagtag te kaa mi Ya tsumanyi!” ");
INSERT INTO sps_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kat to ana mes to aya taan naa to sa tanik iny favaanan Dekapolis (safunuu na ngats fan) tana foka te kat e Jisas tsunia; ana vainy a kinai ngian erato. ");
INSERT INTO sps_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nainy te jias e Jisas puak Ya guas fatabin pis naa to tan mes panaan nana naaman tagin tsian faavot naa ser bau Ya ana Ayei kaa en mou poporos. ");
INSERT INTO sps_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kat to ana mes ruak mito koo rori Jairus ayei na tsoiny mumua tana numaa iny fafaatouf tana taa Jiu naa mito, ayei tagei e Jisas, ya fatukun to sa tsunguruu moun e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ya sing to sa tsue, “Guei moun tsonyo na kakaii te kat iny mat osto. Taame Nyi fasaur tsuiny to na nimam patsuun Ya, ana ayei te rof fatabin en ya te toto.” ");
INSERT INTO sps_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ai Jisas naa fiisen mi naa towa. An tagin vovou naa Towa ser fasoksok fiisen mi naa Ya. ");
INSERT INTO sps_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A moun te kaa kan to te gum iny tataa'in onots safunuu ana fuan a ingainy. ");
INSERT INTO sps_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ayei natiny naa fatatabin kan non tan tsoiny tsipaar ri te iitoo kainy ya. Ya foiny kainy ratuari na painy moni sa kap ovei en, pon fi non nei ayei ruak faarof fatabin non sana ayei nai ruak fifiiring ovei tsun en. ");
INSERT INTO sps_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ana ayei nongoiny ton vaanan nane Jisas, ya vovou ising mito voun Ya fapoopoan nar tagin ya saras ton raarav Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tana saa, te tsue en, “Anyo ma saras tsuiny korei raarav Tsunia nyo te rof fatabin you.” ");
INSERT INTO sps_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sen tsun an tataa'in tsunia parak nato. Ya sarei to na puan ya te rof fatabin en tana faadis te kaa mi ya. ");
INSERT INTO sps_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sen tsun, Jisas natiny to na parits te naus osing ya. Ya takopis fi naa to tan tagin ya rangats ratuari, “Sei te saras raarav Tsonyo ee?” ");
INSERT INTO sps_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","An matisian Tsunia tsue to, “Anyi te tagaa kan rom tan tagin te bau Manyi ser sok Manyi, to Tsumanyi tsue rom, ‘Sei te saras vanyo ee?’” ");
INSERT INTO sps_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ai Jisas matoong vavis ratuari te komainy ma tagei e sei te kat a ka to ee. ");
INSERT INTO sps_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sana moun natiny a ka te kat Ya Tsunia, ya naa mito ten Jisas fiisen me na oraav ana puan ya na totoroor. Ya fatukun to sa tsunguruu Tsunia sa tsue of Ya na fo mamatsiny kan man. ");
INSERT INTO sps_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ai Jisas tsue to tsunia, “Guei Tsiau, faason tsumanyi te tsipaar manyi. Kua mi naa na aaverof, nyi tsipaar em tana faadis te kaa mi nyi.” ");
INSERT INTO sps_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas vegiau kanen nanon ana tee vainy poo mito numaa ten Jairus ser tsue, “A guei moun tsumanyi te maten. Fanag pis vaare na Tsoiny Fifaatsuts.” ");
INSERT INTO sps_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisas tsugainy ma nongoiny a foka te tsotsue ri, sana Ayei tsue na ka ten Jairus, “Vaa'ets vaare, faason Tsonyo tsun.” ");
INSERT INTO sps_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ayei gima famanat iny ta mes ma vovou iny Ya, ere Pita tsun ai Jemis me famuinyasiny tsunia Jon. ");
INSERT INTO sps_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nainy te ruak ari numaa tana tsoiny mumua tana numaa iny fafaatouf, Jisas tagei a pan an goonen kan tana vainy te tangis vevegiau ror ana rin ugun. ");
INSERT INTO sps_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","An nainy te sof naa ya gagon, ya tsue to tsuri, “Kat fei tsumi tangis vevegiau rom ei? A kooviou to na gima mat ayei te goros tsun non.” ");
INSERT INTO sps_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ri na fokinai oor Towa. Ana Ayei kat to sa jiat fi rari jiarasan, Ya nom rato taman ya me tsinan ya ana ina pis a matisian Tsunia ser sof naa tana pan te soon non a guei. ");
INSERT INTO sps_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ya nom to niman ya sa tsue tsunia, “Talita, kumi,” man nan ya, “Kooviou, nyo tsue rou tsumanyi, tsun.” ");
INSERT INTO sps_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sen tsun ana kooviou tsun to ya taan vavis nato ana ri ngian faavot rato, a ingainy tsunia onots non a safunuu ana fuan. ");
INSERT INTO sps_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisas vusvus ratuari ma tsue of vaare ri ta mes ma nat vaare iny ari na ka to, ya tsue of ratuari ma fainy ari ya ta ka ma ainy ya. ");
INSERT INTO sps_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas naus osing a fan to aya, Ya tabin fatabin fi naa to tana fan Tsunia; an matisian Tsunia vovou iny Towa. ");
INSERT INTO sps_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","An tan Nainy Fafaatouf tana taa Jiu Ya tanik iny faatsuts to tana numaa iny fafaatouf tana taa Jiu ana fokinai nongoiny Towa saar ser rangat, “Fei te nom a mes a fo vegiau to ei? Saf a nat to ei na te nom Ya na? Kat fei sa kat a foka iny faatok to ei? ");
INSERT INTO sps_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ayei koraa Ya na tsoiny fatsun numaa, ito na guei tsoiny ten Meri ge? Ayei koraa Ya na famuinyasiny ten Jemis me Josep ai Judas me Saimon? An fuainy fafinen Ya te kaa kan ror tovei!” Ana fokinai fataivou Towa. ");
INSERT INTO sps_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisas tsue to tsuri, “A kuigin te natiny famaari rori tan fo mamatsiny pan, sai tana ngats fan tsunia fatoobing ai tana fo nuatsin ya fatoobing ai numaa tsunia fatoobing a sikia.” ");
INSERT INTO sps_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ayei gim non ma onot ma kat a fo binun iny faatok reits na ya, sai te onot tsun non ma fasaur Ya na niman patsuur a tee vainy te faadis ror Ya te tsipaar rari. ");
INSERT INTO sps_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ana Ayei karian fiisok nato tana saa, ri na sikia ta faaman. Ya naa vavis mito na tou fafaatsuts ir a vainy fapoopoan nar a fo fan. ");
INSERT INTO sps_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ya fikoo vaaguam rato na safunuu ana ina fuan a matisian Tsunia, Ya jiats i'ina fuan ratuari, ana Ya faan ratuarin gumgum iny buur ravainy masarau. ");
INSERT INTO sps_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ya faan ratuarin tsue fanat to: “Govets vaare yam ta isen ta ka tana tou tavet tsumi, san tsukan tsun ana sikia kan tu koinykoiny, ge ta poraa, ge ta painy moni koman a fo poraa tsumi.” ");
INSERT INTO sps_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","San u sandol tsun te fasobok romi ana mi te vau vaaren fuan vau. ");
INSERT INTO sps_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ana ayei tsue to tsuri, “Tana fo ngats fan te ruak romi an tana numaa te sof romi, kaa yam na aya onot non te naus osing romi na ngats fan. ");
INSERT INTO sps_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ai te ruak romi tana saf a fan ei na, ana vainy te gima fafasung faarof mami ge fanaginy tsue ror tsumi naus osing yam a fan mi te tafoor ravainy kuaf mou mami faatok rarori Gov te nai faan rarorin fasaraa.” ");
INSERT INTO sps_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Matisian naa ser favaanan of ir a vainy ma reesik ari er takopis osing ton kat iny aveto tsuri. ");
INSERT INTO sps_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ana ri buur ravainy ton masarau kinai, ser tsiiu kan ir vainy faadis a tapui ser tsipaar rari. ");
INSERT INTO sps_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Aatouf Herot nongoiny a ka to, tana saa asangan e Jisas te saats a pan ser natiny ya. Mes panainy vainy tsue tsuk iny e Jisas, ser tsue, “E Jon a Tsoiny Fapeenan te tsun fatabin en tana mat, to sana fo mamatsiny parits iny faatok tapokaa ising me Tsunia.” ");
INSERT INTO sps_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","San mes panan tsue to, “Ayei e Ilaija.” Ana mesapan tsue to, “A kuigin te faarei ror kuigin iny muan.” ");
INSERT INTO sps_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sai tan nainy te nongoiny ya Herot ya tsue to, “E Jon a Tsoiny Fapeenan ito te govaar anyo na patsuun ya, ito aya te tsun fatabin en tana mat.” ");
INSERT INTO sps_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tabuiny mat non e Jon a Tsoiny Fapeenan, ai Herot faan iny ton tsue ma nots ari ya, ri te nai kotskots ya, er fakei naa towa tana numaa iny kotskots. Ayei kat kat to ma kat fapaparei ya Herodias, ten Herodias te peits fiisok iny e Jon, ");
INSERT INTO sps_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","tana saa Jon a Tsoiny Fapeenan te tsue ets'ets e Herot, “Te sikia non ma toobing tsumanyi ma fipisui fiisen me natsun Filip a famuinyasiny tsumanyi!” ");
INSERT INTO sps_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias kaa me na peits ten Jon sa komainy ma atsuiny famat ya. Sai te sikia ma onot ");
INSERT INTO sps_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tana saa e Herot te kaa me na oraav ten Jon, tana saa ayei te nat e Jon a mes a tavaron ana taabos matan e Gov to sa komainy makok ya. Ya komainy kainy to ma vanongon tsunia, ana ayei kaa miton fakats kinai patang, sana ayei kaa men koman iny vanongon tsunia. ");
INSERT INTO sps_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tan sen nainy ai Herodias sab to naa isen a sanaan a rof ma kat yan koman tsunia. Tan nainy tsian te fakats fatabiny arin nainy agiir ten Herot to te kat arin a kainy ainy tsian sa vebus ir vainy karap tana gamaman tsunia, an tsoiny mumumua tan vainy puaan ana rin tsunaun tsian iny Galili. ");
INSERT INTO sps_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tan nainy te sof a guei moun ten Herodias gagon ya tajiat to matar vainy faavot to sa fapaparei e Herot fiisen ramirin vainy te ainy, ai Herot rangats to na kooviou, “Ta saa te komainy rom anyi na? Nyo onot rou ma faan manyi.” ");
INSERT INTO sps_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ana ayei kat ton tsuen man tana kooviou, “Man non jias, ta saa te rangat iny rom anyi tsonyo na, Nyo nai faan marom anyi, ito te tsue fi rom anyi nei ma kibei anyo na waau ana nyi te kaa men mes panan te onot non.” ");
INSERT INTO sps_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ana kooviou tafuts to jiarasan, sa tsue na ka ten tsinan, “Ta saa te rangat iny ronyo na?” Tsinan ya tsue to na ka, “A patsuun e Jon a Tsoiny Fapeenan ma tek govaar ri te govets mi ya.” ");
INSERT INTO sps_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ana kooviou veesau fatabin tsun en naa to tana aatouf, sa tsue, “Anyo komainy marom anyi ma poote veesau tsun me na patsuun e Jon a Tsoiny Fapeenan tan kobuu ana nyi te faan vanyo ya.” ");
INSERT INTO sps_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ana aatouf reesik fiisok to; sai tan tsuen man tan tsue man non jias te kat ya matar a vainy te faan iny yan vebus tsuri to sa sikia ma ngats tsue tsunia tana kooviou. ");
INSERT INTO sps_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sen tsun ana aatouf jiats to na tsoiny bei ot ma atoiny mi ya na patsuun e Jon. Tsoiny bei ot naus ratuari, ya toobing naa to tana numaa iny kotskots ya tek govaar to na patsuun e Jon. ");
INSERT INTO sps_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ana ayei poote mito na patsuun e Jon tan kobuu, sa nai faan iny towa tana kooviou ana kooviou faan iny towa ten tsinan. ");
INSERT INTO sps_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Te nongon arin matisian ten Jon ri naa mito ser nom a puan ya ser nai fasooiny ya tan puts te kats tan fats. ");
INSERT INTO sps_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","An amaraav tabin to ten Jisas, ser tsue of Ya na foka te kat ari ana foka te faatsuts iny ari. ");
INSERT INTO sps_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ana ayei tsue to tsuri, “Ami tsun ma naa tsom me tana pan a tomani, am favusuan tsom to,” tana saa a vainy a kinai naa ramiror ana ri naa ra naa to ser sikia kan ma ainy ta kainy ainy. ");
INSERT INTO sps_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ri kat to ser jias tan puak ri kovoo fi naa to tan a pan a uur ana tomani ri patsukaner. ");
INSERT INTO sps_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sana vainy a kinai tagaa rari te naa fi naa ri, ri nat ratuari, ser fakookuar fi naa matan, ton kinai te tsun me tana fo ngats fan ser nai ruak faamuan rari. ");
INSERT INTO sps_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Te sung naa ri ai Jisas of osing ton puak ai tan nainy te tagei Ya na vainy a kinai fiisok aaven Ya kaa miton tagtag tsuri, tana saa ri te faarein siip a sikia ta tsoiny veis, sa tanik iny faatsuts rari na ka na kinai. ");
INSERT INTO sps_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Te kat iny ananerof osto, an matisian Tsunia naa mito Tsunia ser tsue na ka, “Ito aya na pan a uur ana tomani, san nainy te naa busen; ");
INSERT INTO sps_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","jiat ir a vainy ma naa ri tana fo fan te siruu non er foiny to ta kainy ainy tsuar iny ainy.” ");
INSERT INTO sps_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisas biny ratuari sa tsue, “Mi patsukanem yam ma faan rari ta kainy ainy.” Ri tsue to Tsunia, “Nyi komainy maromam ma faan iny ta painy moni te onots non fuan a natus a kina a onots to ta koinykoiny iny fa'ainy rari?” ");
INSERT INTO sps_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ai Jisas rangats ratuari, “Fis a koinykoiny te kaa miromi? Ami ma nai tagaa,” Ai te nat fi ri nei, ri kaa miror, ri tsue to, “A ngim koinykoiny ana fuan a jian.” ");
INSERT INTO sps_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisas tsue of ton matisian Tsunia, ma tsue of ir a vainy ma vaagum ari, er kat to na fo gum patsun a aufing a wuwiir. ");
INSERT INTO sps_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ri kat to ser kat a fo gum, sen vaagum onots sen natus an mes vaagum onots ngim safunuu. ");
INSERT INTO sps_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ai Jisas nom to na ngim a koinykoiny ana fuan a jian Ya matoong fi naa to Gormirmir, sa faarof naa ten Gov, Ya ivoo ton koinykoiny, sa fafaan ir ya tan matisian Tsunia ma tatafas rari ya tana vainy. Ana Ayei mormor kainy to na fuan a jian fapoopoan narari faavot. ");
INSERT INTO sps_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Fokinai ainy ser viits. ");
INSERT INTO sps_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","An matisian Tsunia nom to na safunuu an fuan a koverok ser fau favei yan ainy osing tan koinykoiny an jian. ");
INSERT INTO sps_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ari to te ainy tan koinykoiny onots toromainy a ngim a tapan mes gima as'as faavot me na fo moun min guei kakaii. ");
INSERT INTO sps_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Vou na foka to aya Jisas faveveesau raton matisian Tsunia ma jias ari tan puak er mumua fi naa to tan mes panaan nan naaman tana ngats fan iny Betsaida, Tsunia te komainy ma fataasua tsom ir a fokinai er vavakas to. ");
INSERT INTO sps_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te fataasua fakap ya na vainy Ya paas fi to tana painy tet a tou faakats. ");
INSERT INTO sps_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te uurup bus a pan, san puak kaa busen fapoopoan nana naaman, ana ayei Tsivon kaa yen mats. ");
INSERT INTO sps_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ya tagei raton matisian Tsunia te nag er tana tou suein puak, tana saa, ainysat tapoor me imus nan puak. Fapoopoan nana fopis a kilok ana aunom a kilok tana patsuu na nainy Jisas naa fi to tsuri taan ising naa patsun a naaman. Te komainy ma taan fafis rari. ");
INSERT INTO sps_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","San tan nainy te tagei ri Ya te taan fi mi Ya patsun a naaman, ri pon iny to na amatsuan, ser vaanei iny na Ya ri rorojiainy faavot rato, ");
INSERT INTO sps_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tana saa ri tagei faavots Ya ser oraav faavot rato. Sen tsun Jisas vegiau naa to tsuri sa tsue, “Kaa faparits yam! Anyo vaa ei aa. Oraav vaare yam!” ");
INSERT INTO sps_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ya jias to koman puak sa kaa fiisen ramiri ana ainysat sariof to. An matisian Tsunia saar faavot rato, ");
INSERT INTO sps_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tsuri te gima fakats fanatnat iny a man nan koinykoiny te ivivoo Jisas, a aave rari te kio ovei en. ");
INSERT INTO sps_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tan nainy te guas naa ri, ri nai sung to tana pan iny Genesaret, ri tang iny ton puak. ");
INSERT INTO sps_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te of osing arin puak, ana vainy inainy veesau tsuiny to Jisas, ");
INSERT INTO sps_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ser kuar vavis tan mamatsiny fan, ser nom ir vainy faadis, ser fasoon rari tana fo nenengan ri govet fi ratuari tana pan te kaa Ya. ");
INSERT INTO sps_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ai tana fo pan te taan e Jisas tan fo fan, ai tan ngats fan ai tana fo pan te totovaar vavis rori, ana ri fateif raton vainy faadis tana pan iny totuan ana ri sing maamaa naa ten Jisas ma famanat rarin vainy faadis ma saras tsuiny korei arin nguen vau Tsunia ana ri to te saras nguen vau Tsunia tsipaar rato. ");
INSERT INTO sps_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Taa Farasi vaaguam faavot fi to ten Jisas fiisen ramirin mes panan tan tsoiny fifaatsuts tan Faun tana taa Jiu to te poo fi me Jerusalem, ");
INSERT INTO sps_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ser tagei ir mes panan tsurin matisian Tsunia ainy fiisen me na nima rarin kukutsuan a sikia ma garus to te tsue fi non faun tsuri. ");
INSERT INTO sps_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A Farasi ana taa Jiu kan, sikia ror ma natiny ainy me na nimar a kukutsuan, ri natiny garus tsom ror a nimar vovou iny ror faun tan tsuvurari muan. ");
INSERT INTO sps_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nainy te natiny tabin mirori tana tuan, ri sikia ror ma natiny ainy onot non te garus vatsvats tsom finy rori na tsivor. Mes Faun kinai iny muan te kainon natiny vovou iny rori to te sumainy rorin Faun te nom e Moses ten Gov tan kat iny garus gotan an nas an fo mes a fo nas kepaa. ");
INSERT INTO sps_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ana Farasi an tsoiny fifaatsuts tan Faun rangats to Jisas, “Kat fei san matisian Tsumanyi gim ror ma vovou faarof iny kat tan fuainy tsuvurara ei, tana saa ri natiny ainy miror a nimar a kukutsuan?” ");
INSERT INTO sps_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ai Jisas tsue fatabin of ratuari, “E Aisaia na Kuigin te favaanan iny ya, amin vainy kat mapam, te gum fi non ya tan kirkir, ‘A vainy to te faatouf Varonyo tana pengot nana ngue rari, sana aave rari veevian osing Varonyo. ");
INSERT INTO sps_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ri fafaatouf babainy tsun Varonyo, tana saa, ri fafaatsuts iny ror faun tana mes tsun sa faarei non Faun ten Gov.’ ");
INSERT INTO sps_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mi baainy Faun ten Gov, ana mi nom tap fapaparits iny rom kat tana tei muan.” ");
INSERT INTO sps_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisas tsue pis to tsuri, “Amin vainy katkat sanaan rof iny fataanis osing Faun ten Gov, ana mi makok faarof rom kat tan fuainy tsuvumami, ");
INSERT INTO sps_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","tana saa te faarei non kirkir ten Moses te faan iny e Gov, ‘Fatsiitsii yam e tamamami ai tsinamami,’ ai ‘Sei na mes te fijiar non e taman ge tsinan ee ma atsun famat ravaa!’ ");
INSERT INTO sps_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sana mi tsue faarof rom a mes ma kaa me ta ka te onot non tan faakouts ya taman ge tsinan, sana ayei tsue, ‘A ka to te asang of bus anyo Gov,’ ");
INSERT INTO sps_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ai tan tsue to, te faarei non a sanaan sikia ma kainy faakouts e taman ge tsinan. ");
INSERT INTO sps_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tan kat to aya mi kat rom vegiau ten Gov ka babainy tan kat tsumi te faan bus iny ami tana mesapan. A ka na kinai te kat fi non nei aya, te vovou iny romi.” ");
INSERT INTO sps_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ai Jisas fikoo pis rato na fokinai Tsunia sa tsue tsuri, “Nongon yam Tsonyo, ami na fokinai, am natiny towa. ");
INSERT INTO sps_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sikia ta ka iny jiarasan te onot non ma naa koman a mes a kat fifiiring towa matan e Gov, a sikia, a ka te tafuts ising minon koman a mes te kat fifiiring non ya. ");
INSERT INTO sps_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nongon yam, mes kaa minon teinan iny nongon ma nongon faarof.” ");
INSERT INTO sps_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Te naus osing Ya naa vainy, Ya sof to tana numaa, an matisian Tsunia rangats Towa na fo tsue fapapaar. ");
INSERT INTO sps_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ana Ayei tsue to tsuri, “Ami fapinpin kanem marom ge? Mi ma nat fi nei, ka iny jiarasan te naa fi non koman a mes a gim rom ma kat fiiring ya, ");
INSERT INTO sps_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tana saa to te naa non ya gagon, sikia non ma naa aaven ya, sai te naa non tana mokoor koman a mes ai te nai taagio ravainy ya.” (Tan kat to aya ai Jisas fa'arasainy to na ka to, mamatsiny kainy ainy onot non tan ainy.) ");
INSERT INTO sps_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ana Ayei tsue pis to, “A ka te ruak ising minon nguen a mes te kat fifiiring non a mes, ");
INSERT INTO sps_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","tana saa ito te ruak minon aaven a mes, ton fo fakats iring, fifaanaum, kakabuts, kat iny fitokon, ");
INSERT INTO sps_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kat iny tsikoor, mataguas iny a ka tana mesapan, fo kat iny ngi'arapaar, gamgam, tsue fifiiring a mesmes, fitsufainy, govet vegiau, fapaas a tsivom, kat fapeepiou. ");
INSERT INTO sps_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Fo kat iring to aya poo ising minon koman a mes, ai te kat fifiiring ya.” ");
INSERT INTO sps_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas kat to sa tsun Ya naus osing to na pan to aya, sa naa fi en naanaa panan a fuan a ngats fan iny Taia ai Saidon. Ya sof to koman a numaa tsugainy ta mes ma natiny Ya te kaa fi non Ya naa; sana Ayei gima nai kaa fatakop. ");
INSERT INTO sps_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Gima potsian ana moun, ito na guei moun tsunia a kakaii a tutuei iny masarau, nongoiny to Jisas ya naa veesau tsun mito Tsunia, ya ngats to na moun sa tsunguruu moun Ya. ");
INSERT INTO sps_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A moun to aya na moun te agiir Finisia a muiny Grik tan gum fan tsian iny Siria kat fuainy ror tana taa Jiu. Ana ayei sing maamaa to Jisas ma buur ravainy Yan masarau tana guei moun tsunia. ");
INSERT INTO sps_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ai Jisas tsue to tsunia, “Fa'ainy faamuainy tsom ir guei kakaii, er viits to, tana saa te gim non ma toobing tan fa'ainy ir kas a kainy ainy tan guei kakaii.” Jisas tanaf fakats tana moun. ");
INSERT INTO sps_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ya biny towa sa tsue, “Man ovei Tsunaun, san kas kan fain a taran natiny ainy ror ainy farurus tan guei kakaii.” (A taa Jiu natiny asang raror a vainy sikia ma taa Jiun kas.) ");
INSERT INTO sps_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jisas tsue to tsunia, “Ito na ka te tsue nyi na man, anyi onot rom tan tabin numaa tsuam; a masarau naus osing fakap bus a guei moun tsumanyi!” ");
INSERT INTO sps_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ana ayei tabin to fan sa nai sab a guei moun tsunia te soon non fetan, a masarau te naus osing ya. ");
INSERT INTO sps_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas tsun sa naus osing a pan iny Taia, Ya toobing fi naa to fapoopoan nana Saidon ai tana gum fan iny Dekapolis sa nai ruak naa tana naaman iny Galili. ");
INSERT INTO sps_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ana vainy atoiny mito na mes a teina kuupio ana sikia kan ma natiny vegiau Tsunia ser sing maamaa Jisas ma fasaur Yan a niman patsuun ya. ");
INSERT INTO sps_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jisas nom fajesa patsukainy finy naa na mes Tsivon, ya rog iny to na karoor nan teinan a mes, ya kisuf to sa saras a riam nana mes. ");
INSERT INTO sps_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jisas matoong naa to Gormirmir, Ya fuas fakeits to, sa tsue tana mes, “Efata” man nan ya “Tapue!” ");
INSERT INTO sps_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ana teinan ya arasan to, ana mian ya kenak kan nato, ya tanik iny vegiau faarof bus nato. ");
INSERT INTO sps_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ai Jisas tsue faparits of ratuari, ma siisio vaare ri na ka to tan ta mes; ya tsue faparits fatsian of pis ratuari, sana ri nai kuu fatsian vavis iny ya. ");
INSERT INTO sps_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ana ri na fokinai te nongon saar rato. “Ayei kat faarof a fo mamatsiny ka,” te tsue fi ri, “Ana Ayei kan te kat a mes a koosi nongon faarof to ana baaoo vegiau fa'arasan faarof nato!” ");
INSERT INTO sps_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tana fo nainy to aya an tagin tsian vaaguam pis mito. Ri sikia ma kaa mito ta kainy ainy, ai Jisas fikoo raton matisian Tsuan ser naa me Tsunia sa tsue na ka, ");
INSERT INTO sps_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nyo tagtag fiisok roun tagin to, tana saa ri kaa fiisen bus Vaminyon fopis nainy, ser sikia ma kaa me ta kainy ainy. ");
INSERT INTO sps_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","To te jiats vesves fi vanaa Ronyo ri tana fo fan tsuar, ri matauts ra naa ror sanaan, tana saa mesapan tsuri taainy bus me na sanaan a veevian.” ");
INSERT INTO sps_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","An matisian Tsunia biny Towa, “Fei nom non a mes tu koinykoiny tana pan babainy a sikia tu koinykoiny a fa'ainy rato na fokinai to ei?” ");
INSERT INTO sps_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisas rangats ratuari, “Fis koinykoiny te kaa miromi?” Ri tsue to, “U fits.” ");
INSERT INTO sps_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ai Jisas tsue of ratuari na fokinai ma gum ari patsun puputaa. Ya nom to na fits a koinykoiny, Ya tsue faarof naa to ten Gov, Ya ivoo towa, Ya faan iny towa tan matisian Tsunia ma tatafas rari yan tagin, ana rin matisian Tsunia vovou iny ton tsue Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ana ri kaa kan mito na tee jian a kakaii, ai Jisas faarof to ten Gov ya tsue of ratuarin matisian ma faan kan rari ya na fokinai. ");
INSERT INTO sps_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ri na fokinai ainy, ser viits ri fag to na fo ainy osing ser fau ya sa onots a fits a koverok a via. ");
INSERT INTO sps_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te onots toromainy non a fats a tapan vainy. ");
INSERT INTO sps_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ya jiat ratuari sen tsun Ya jias to tan puak fiisen ramirin matisian Tsunia, ser naa fi naa tana pan iny Dalmanuta. ");
INSERT INTO sps_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A tee vainy Farasi naa me ten Jisas ser tanik iny fatsutsue fiisen mi Ya, komainy ma tagei ta kainy faatok ma poo me Gormirmir ten Gov, ri tanaf Ya to te poo faman man fi minon Ya ten Gov. ");
INSERT INTO sps_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas fuas fakeits miton fakats tsian aaven sa tsue, “Kat fei san aatai to komainy ror ta kainy faatok ei? Man ovei, Nyo tsue rou tsumi, sikia ta ka ta foun iny faatok te tagei nats romi tana aatai to.” ");
INSERT INTO sps_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jisas naus osing ratuari, sa jias pis tan puak ser sepuu faguas naa tan mes panaan nana naaman. ");
INSERT INTO sps_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Matisian anofe ma tamaar iny naa tu koinykoiny ser tamaar tsuiny men sen koinykoiny koman puak. ");
INSERT INTO sps_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas tsue to tsuri, “Taatag yam, am tatanamots ton yis tana taa Farasi an yis ten Herot, ito na fo fafaatsuts a fo iring.” ");
INSERT INTO sps_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ri tanik iny favevegiau bus rato fapoopoan narari ser tsue, “Ayei tsue na ka to tana saa ra gima tamaar iny me tu koinykoiny.” ");
INSERT INTO sps_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas natiny a ka te vegiau tsuk iny ari ana Ya rangats ratuari, “Kat fei tsumi tsue tsuk rom a sikia tu koinykoiny ei? Kat fei mi tabuiny nat rom ge? Aave mami tabuiny arasan kan non? ");
INSERT INTO sps_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mi kaa mirom matan iny tagaa sana mi sikia rom ma inan fanatnat, mi kaa mirom teinan sana mi sikia rom ma nongon. Mi sikia ma fakats! ");
INSERT INTO sps_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tan nainy to te ivivoo Nyo na ngim ma koinykoiny tan ngim a tapan mes, fis a koverok a via taptap tan ainy osing te fau ami?” Ri tsue to Tsunia, “Safunuu ana fuan.” ");
INSERT INTO sps_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Fakats fatabin yam tana fits a koinykoiny tana fats a tapan mes, fis a koverok a via taptap tan ainy osing te fau ami?” Ana ri tsue to Tsunia, “A fits.” ");
INSERT INTO sps_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ai Jisas tsue to tsuri, “Mi tabuiny nat kan rom?” ");
INSERT INTO sps_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ri naa me Betsaida, ana ri atoiny mito na mes a mata kio ten Jisas, ri sing Towa ma saras ya. ");
INSERT INTO sps_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas nom to niman a mes a mata kio, sa ras fajesa osing ya na fan; ana Ayei kisuf of to na mata na mes sa fasaur a niman matan a mes a kio, Ya rangats towa, “Nyi tagei kainy rom ta ka?” ");
INSERT INTO sps_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ana mes matoong fapaas to sa tsue, “Nyo tagei rou a vainy; sai te mamatan faarei ror nau te taan ror.” ");
INSERT INTO sps_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas kat to sa fasaur pis a niman matan a mes a kio; ana mes kat to sa matoong famimirik iny a matan ya matoong faarof fatabin bus nato onot non ma tagei mamatsiny ka. ");
INSERT INTO sps_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisas jiats finy na towa numaa tsunia sa tsue faparits of ya, “Tabin fi vaare fan, sai numaa tsumanyi fatoobing.” ");
INSERT INTO sps_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas naa fiisen mi naa matisian Tsunia tana fo fan tana pan iny Sesaria Filipai, te taataan naa ri sanaan ai Jisas rangats raton matisian Tsunia, “A vainy tsue Varonyo sei ee?” ");
INSERT INTO sps_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ana ri biny Towa, “Mesapan tsue ror, Anyi Jon a Tsoiny Fapeenan ana mesapan tsue ror, Anyi Ilaija na kuigin ten Gov, ana mesapan tsue ror a isen tan mes panair kuigin to te toto fatabin me.” ");
INSERT INTO sps_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ai Jisas rangat ratuari, “Ami pas, mi tsue Varonyo sei?” Pita biny Towa, “Anyi na Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy.” ");
INSERT INTO sps_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ai Jisas vusvus faparits ratuari ma fafaatai vaare ri ta isen ta mes Anyo Krais. ");
INSERT INTO sps_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas tanik iny faatsuts matisian Tsunia, “A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me ma saraa kamits fatsian nimar tsunaun tana taa Jiu, an tsunaun tan tsoiny faakor, ana rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses, ri nai tsugei ror Ya. Ri nai atsuiny famat ror Ya, ai voun fopis nainy Ayei nai tsun fatabin non.” ");
INSERT INTO sps_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ayei fa'arasainy faarof of rari ya. Ai Pita mei naa Towa tatangin ana ya tsue ets'ets Towa. ");
INSERT INTO sps_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ai Jisas takopis fatabin faavou fi naa to tan matisian Tsuan, Ya tsue ets'ets to Pita sa tsue, “Fataanis osing you, Satan! Tana saa fakats tsumanyi naa to ayan fakats tana mes tsun sikia ma fakats ten Gov.” ");
INSERT INTO sps_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ai Jisas fikoo faavot rato na fokinai fiisen ramirin matisian Tsunia ser naa fi Tsunia, ana Ayei tsue to tsuri, “Sei na mes te komainy vovou Varonyo ee, ayei ma anofe na tsivon, ai te fa'orovus iny a tsivon, ana ya te vovou Vanyo, ");
INSERT INTO sps_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","tana saa sei na mes te komainy makok faarof non a toto tsuan ee, nai nun enanon, san e sei te fa'orovus non a toto tsuan ee tan vovou Vanyo ai tan pokei iny Vurungan Rof Tsonyo nai nom non a toto na suu. ");
INSERT INTO sps_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ta isen ta mes te mauts non a fo masun tana ratsuu iny peto ana toto tsunia te iring a nun enato, fo masun to aya te faakouts fi non ya ei? A sikia. ");
INSERT INTO sps_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A saf a tafan tana mes to na to te pats fi non ya na toto na suu tana masun tsuan na? A sikia ovei. ");
INSERT INTO sps_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","E sei na mes te rejiaf Varonyo an vegiau Tsonyo tan nainy tovei roman ee te naus osing Varonyo ri te vovou iny kat tana ngi'arapaar tan nainy vou, a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai rejiaf kan iny non Ya tan nainy te naa minon Ya fiisen minon fo morenan taabos koman siinaiv ten Taman Ya.” ");
INSERT INTO sps_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ai Jisas tsue to tsuri, “Nyo tsue faman of maromi te kaa miror mesapan te tsutsun ror tovei tabuiny mat ror tagei nats ror a Waan e Gov naa fiisen minon a parits.” ");
INSERT INTO sps_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Voun gonom nainy Jisas nom rato ere Pita me Jemis ai Jon ana Ya naa fiisen ramituari tana tobeer a nainy jig ri patsukaner. Ana puan Ya ruak iny pangis enato mata rari. ");
INSERT INTO sps_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","An vau Tsunia pangis kan to sa faarein goseen kafof kakanaf, gosee fafis iny non kan gosee te natiny garus ror a vainy tana monaagits to. ");
INSERT INTO sps_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ana ina pis a matisian tagei to Ilaija me Moses te ruak ser favevegiau fiisen me Jisas. ");
INSERT INTO sps_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ai Pita tsue to ten Jisas, “Tsunaun, rof non te kaa fi rora nei, mam ma kat ta fopis ta tovaar, isen Tsumanyi, ana isen ten Moses ana isen ten Ilaija.” ");
INSERT INTO sps_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita fapinpin iny ma tsue ta ka, tana saa ri te oraav fiisok. ");
INSERT INTO sps_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ana koroo ruak to sa pau rari, an vegiau poo mito koroo sa tsue, “Tovei na Guei Tsonyo te kaa non koman Tsonyo, nongon yam Tsunia.” ");
INSERT INTO sps_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sen tsun ri matoong vavis to ser gima tagei ta isen fiisen ramiri, e Jisas tsun Tsivon. ");
INSERT INTO sps_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Te of osing mi ri na tobeer, Jisas tsue faparits of ratuari ma pokei vaare ri na ka te tagei ri tan ta mes onot non te tsun fatabin fi non na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me tana mat. ");
INSERT INTO sps_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ana ri nongoiny ton tsue Tsunia, sai fapoopoan narari ri tanik iny rangat vavis ser tsue, “A saa to na tou tsun fatabin tana mat na?” ");
INSERT INTO sps_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ana ri rangats to Jisas, “Kat fei san tsoiny fifaatsuts tan Faun te kirkir iny e Moses tsue, Ilaija na kuigin ma mumua me ei?” ");
INSERT INTO sps_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ai Jisas tsue to tsuri, “Eye, Ilaija na kuigin ma mumua me a kakouiny to na fo mamatsiny ka, sa kat fei san Vegiau Ten Gov tsue to na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, nai sarei non a kamits tsian fiisok ri te tsugei Ya ei? ");
INSERT INTO sps_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sana Nyo tsue of maromi, a mes te faarei non e Ilaija na kuigin te naa en naa me, ser kat kainy ya Tsunia, to na sanaan te paparaa iny ari to te kat ari tsunia te kaa fi non Ya to tan Vegiau Ten Gov.” ");
INSERT INTO sps_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Te tabin mi ri tan mes matisian ri tagei ton tagin tsian na aya. Mesapan tsurin tsoiny fifaatsuts tan Faun fatsutsuar fiisen ramirin matisian. ");
INSERT INTO sps_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sen tsun te tagei a fokinai e Jisas ana ri fakakarian faavot rato, ri fakookuar naa to Tsunia a tou tainytainy Ya. ");
INSERT INTO sps_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas rangat ratuarin matisian Tsunia, “A saa te fa'ararat fiisen vamiromi ri na?” ");
INSERT INTO sps_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A isen fapoopoan nar tagin tsue mito Tsunia, “Tsoiny Fifaatsuts, nyo mei me na guei tsoiny tsonyo Tsumanyi, tana saa masarau te tutuei ya sa sikia non ma natiny vegiau. ");
INSERT INTO sps_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tan nainy te kat non yan masarau, ayei natiny gotsiny non putaa an popojiain te ruak nguen ya ana ayei te kakuts ngiisngiis a ngiisin ana ayei te toobing kan en. Nyo rangat ir matisian Tsumanyi ma buur ravainy arin masarau, sana ri gima onot.” ");
INSERT INTO sps_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ai Jisas tsue fatabin to tsuri, “Amin aatai iny roman amin vainy vavaajets! Fis nainy te kaa fiisen Vanyo mi? An fis nainy ma govets patang fiisen Vanyo mi? Mei mi yam a vurots nei Tsonyo!” ");
INSERT INTO sps_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ana ri mei naa to na vurots ten Jisas, an nainy te tagei a masarau e Jisas, sen tsun ana masarau kat fatotoroor to na vurots ana ayei gotsiny to putaa ya kukuur vavis nato an popojiainy ruak to nguen ya. ");
INSERT INTO sps_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas rangats to taman ya, “Farainy te tanik yan kat to?” Taman a vurots tsue to, “Te tanik te memeran patsukan ya. ");
INSERT INTO sps_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mamatsiny nainy natiny tanaf iny atsuiny non ya ito tan fagotsiny naa ya koman guaf ai koman a aurom. Nyi onot rom ma kat ta ka tsunia, rof non reesik mamimam Nyi te faakouts mamam.” ");
INSERT INTO sps_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisas tsue to tsunia kat fei tsumanyi tsue rom, “Anyi onot rom! A mes te kaa minon a faaman onot non ma kat fo mamatsiny ka.” ");
INSERT INTO sps_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sen tsun ana taman a guei tangis to sa tsue, “Nyo kaa mirou a faaman, sana sikia ma onot. Faakouts sa Nyi you ma parits a faaman tsonyo!” ");
INSERT INTO sps_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nainy te tagei e Jisas mes pis tagin te fakookuar faavot fi me tsuri, Ya tsue ets'ets to na masarau, sa tsue tsunia, “Anyi na masarau a teina kuupio ana baaruu, Nyo tsue faparits of marom anyi tafuts osing, ana nyi te sof fatabin pis vaare tsunia!” ");
INSERT INTO sps_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ana masarau kat fakuu fatsiainy towa, sa kat fatotoroor a vurots ya tafuts osing towa ana vurots soon faamo mito na puan a raavraav, ser tsue, “Ayei na mat!” ");
INSERT INTO sps_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sen Jisas nom niman a vurots ya ras fatsuiny towa, ya tsutsun to. ");
INSERT INTO sps_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Vou bus Ya sof naa to numaa an matisian Tsunia rangats Towa tana uur, “Kat fei sa mam gima onot ma buur ravainy masarau ei?” ");
INSERT INTO sps_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ai Jisas tsue to tsuri, “Tan faakats an tavtaav tsun onot non tan buur ravainy kainy masarau to aya.” ");
INSERT INTO sps_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Te naus osing ari na fan to aya, ana ri ising fi naa to koman a gum fan iny Galili. Jisas tsugainy ta mes ma natiny a pan te kaa non Ya, ");
INSERT INTO sps_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tana saa, Jisas faatsuts non matisian Tsuan sa tsue tsuri, “A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai faan iny naa rori nimar vainy ana ri te nai atsuiny famat Ya, ai vou te atsuiny rori Ya, nai tsun fatabin non voun fafofopis nan nainy.” ");
INSERT INTO sps_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sana ri gima arasan iny a man nan tsue to tsuri te oraav ma rangat. ");
INSERT INTO sps_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ana ri ruak to Kapeniam, an nainy te kaa Jisas numaa Ya rangats ratuari, “A saa te fatsutsue iny ami sanaan na?” ");
INSERT INTO sps_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sana ri kaa faamo er, tana saa ri te fa'ararat tsuk iny mi ya sanaan, e sei tsuri te karap fafis non ee. ");
INSERT INTO sps_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nainy te gum e Jisas ya fikoo raton safunuu ana ina fuan a matisian Tsunia sa tsue tsuri, “Sei na mes te komainy tsoiny mumua non ee; rof non tsunia ma fauf a tsivon tana fokinai ana ayei te faarei a tsoiny binun tana fokinai.” ");
INSERT INTO sps_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ana Ayei nom to na guei a kakaii, sa fatsutsuiny ya fapoopoan narari Ya fijapou mi towa niman, Ya tsue to tsuri. ");
INSERT INTO sps_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sei te faakouts non a guei to tana asanga Vanyo ee ayei faakouts Varonyo. Ai sei te faakouts Varonyo ee gim non ma faakouts tsuiny Vanyo, sai to Tsunia to te jiats Vaminyo.” ");
INSERT INTO sps_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon tsue to Tsunia, “Tsoiny Fifaatsuts, mam tagei na mes te buur ravainy masarau tana vainy tana asanga Manyi ana mam tsue tap iny towa tana saa ayei na sikia ma mes tana gum tsura.” ");
INSERT INTO sps_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sen Jisas tsue tsuri, “Kat tap vaare yam, tana saa sikia ta mes te kat non a binun iny faatok reits tana asanga Vanyo te onot non ma vegiau fiiring Vanyo, ");
INSERT INTO sps_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tana saa a mes te gim non ma veer ramira, ayei na vaatau tsura. ");
INSERT INTO sps_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nyo tsue faman of maromi, e sei ta mes te faan maromi ta gotan aurom iny jiu ee, tana saa nyi kaa mirom a asangan e Krais, nai nom non a tafan tsunia.” ");
INSERT INTO sps_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","E sei ta isen ta mes te ras raror guein kakaii to te faaman ror Tsonyo, tan kat iny aveto ee, te rof fafis non tan tang iny ta marats tsian googon a mes to aya, ai te nai faruk namaan bong. ");
INSERT INTO sps_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ai to te amus fi marom anyi na nimam tan kat kat iny aveto, kobus ravainy. Te rof fiisok non tan nom a toto na suu te kaa fiisen mirom anyin sen niman, sai te gim non ma mamatan faarof tan kaa men fuan niman kat ror ser ras ma naa nyi unya Hel, tana pan te kaa non guaf te sikia non ma natiny mote. ");
INSERT INTO sps_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tana pan te kaa ror kad to te kaa ror pua rari te sikia ror ma natiny mat an guaf sikia kan non ma natiny mote. ");
INSERT INTO sps_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","A mou manyi te amus fi marom anyi tan kat kat iny aveto, kobus ravainy, tana saa, te rof fiisok non tan nom a toto na suu te kaa fiisen mirom anyin sen mou, sai te gim non ma mamatan faarof tan kaa men fuan mou kat ror ser ras ma naa nyi unya Hel, ");
INSERT INTO sps_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","U kad tana pan nato aya sikia ror ma natiny mat, an guaf kan sikia non ma natiny mote. ");
INSERT INTO sps_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A mata manyi te amus fi marom anyi tan kat kat iny aveto, fas ravainy. Te rof fiisok non tan sof mi naan sen matan tana Waan e Gov, sai te gim non ma rof tan kaa men fuan matan ma ras ma naa ri nyi unya Hel. ");
INSERT INTO sps_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tana pan te sikia ror kad ma natiny mat an guaf sikia non ma natiny mote. ");
INSERT INTO sps_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Fokinai nai sarei ror a kamits koman guaf tan tanaf faarei non teteisian sikia non ma nom ravaa. ");
INSERT INTO sps_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Teis kan rof, sai te kajiaa non teteisian nan teis, a binun tsunia te kap en, a sikia pis ta sanaan iny kat fateteisiainy fatabiny pis ya. Ami ma kaa me ta teis ana mi te kaa me na aaverof fiisen rame na mesapan.” ");
INSERT INTO sps_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas naus osing to na gum fan iny Galili sa naa fi en tana gum fan iny Judia, tan mes panaainy aurom iny Jodan, ana fo tagin varosoo fatabin rato Tsunia, Ya fafaatsuts pis ratuari faarei te kat fi Ya muan. ");
INSERT INTO sps_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A taa Farasi naa mito Tsunia ma tanaf ari Ya ser rangat, “Te toobing kan non tana Faun tsura tana mes ma ots fanging fiisen me natsun?” ");
INSERT INTO sps_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas biny ratuari, “Saf a Faun te faatsuts iny e Moses tsumi na?” ");
INSERT INTO sps_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ser tsue na ka, “Moses tanyiny a mes ma kirkir tsom noun iny ots fanging tana moun ana ayei te gargar ravainy ya.” ");
INSERT INTO sps_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sen Jisas biny ratuari, “Moses kirkir iny a Faun to aya tana saa aavem mami te kio ovei en ana min fanaginy fafaatsuts. ");
INSERT INTO sps_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","‘Tan tatanik nan puputaa Gov fapogaar a vainy, Ayei kat faavots raton tsoiny min moun.’ ");
INSERT INTO sps_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Tan kat to aya, a tsoiny ma naus osing e taman me tsinan ya te fanging e natsun ana ri na ina fuan te nai isen tsun me.’ ");
INSERT INTO sps_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ma faarei vaare mi ri na ina fuan, san isen tsun. ");
INSERT INTO sps_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","To sana mes ma pets vaare na ka te kotskots faavots bus e Gov.” ");
INSERT INTO sps_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Te tabin naa ri numaa, matisian Tsunia rangats fatabiny Towan vegiau iny ots fanging. ");
INSERT INTO sps_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ya tsue to tsuri, “E sei na mes te ots fanging fiisen minon e natsun ee, ana mes to ayei te nai fanging pis a mes a moun, a mes to ayei kaa non tan kat iny tsikoor fiisen me na mes a moun to aya. ");
INSERT INTO sps_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ai sei na moun te ots fanging fiisen minon e natsioiny ee ana moun to ayei te nai fanging pis a mes tsoiny, ayei kan a moun to aya kaa non tan kat iny tsikoor fiisen me na mes a tsoiny to aya.” ");
INSERT INTO sps_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ri mei miton guein kakaii ten Jisas ma fasaur Ya na niman patsuu rari, san matisian Tsunia tsue ets'ets ratuari. ");
INSERT INTO sps_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisas tagaa rari, Ya peits ratuari sa tsue na ka, “Tanyir yam guein kakaii ma naa mi ri Tsonyo, tsue tap vaare ir yam, tana saa a Waan e Gov fasito raror vainy te faarei ror guei to ari. ");
INSERT INTO sps_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Man ovei nyo tsue of maromi, sei te gim non ma faarof a Waan e Gov ee, a faarei to na guei na kakaii te faarof iny non ya ayei gim non ma onot a sof to gagon koman a Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ya fijapou ratuari, ana Ya fasaur to na niman patsuu rari Ya faparits ratuari. ");
INSERT INTO sps_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas tanik iny taan non ana mes kuar mito fatukun matan Ya sa rangats Ya, “Tsoiny Fifaatsuts a rof, saa te kat ronyo nyo te nom a toto na suu na?” ");
INSERT INTO sps_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas biny towa, “Kat fei tsumanyi koo Varonyo na mes a rof ei? Sikia ta isen ta mes ta rof, e Gov tsun Tsivon. ");
INSERT INTO sps_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nyi nat bus iny Faun te kirkir iny e Moses: ‘Bainy atsuiny, bainy tsikoor, bainy kabuts, bainy gamgam iny a mesmes, bainy gamgam nyi te fagaug a mesmes, bainy mataguas, fatsiitsii tamam me tsinam.’” ");
INSERT INTO sps_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ya tsue to ten Jisas, “Tsoiny Fifaatsuts, fo mamatsiny faun to aya te vovou faarof iny anyo ana nyo vurots you onot roman.” ");
INSERT INTO sps_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas matoong fatoobing naa tsunia fiisen men mangiir. Ya tsue to na ka tsunia, “Nyi kakat iny rom a isen a ka, kuar, nyi fafiifoiny iny to na fo mamatsiny ka te kaa mirom anyi nyi nom to ta moni nyi fafaan ratuarin vainy aaruts, nyi te nai kaa me na masun iny Gormirmir; taame vovou You.” ");
INSERT INTO sps_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te nongoiny yan tsue to ya mataaf fiisok ovei tsun nato, ya naa fiisen mito na aaven a reesik, tana saa ayei kaa me na masun a kinai. ");
INSERT INTO sps_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas takopis of ir matisian Tsunia, Ya tsue to na ka tsuri, “Te opaar fiisok tsun non tana mes te kaa minon masun a nai sof to na Waan e Gov!” ");
INSERT INTO sps_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Matisian karian fiisok tsun iny vegiau to. Ai Jisas tsue pis to na ka tsuri, “Guei tsiau, te opaar non tan vainy te faason ror tana masun ma sof a Waan e Gov! ");
INSERT INTO sps_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Te opaar non tana Kamel ma sof a tarobong tana tutusa, sai te opaar fafis fiisok non tana mes a masun ma sof tana Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Matisian karian fiisok tsun iny vegiau to ser favevegiau patsukaner, “Ai sei te onot non ma saup ai te nom a toto na suu ee?” ");
INSERT INTO sps_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas matoong ratuari sa biny rari, “A mes te gim non ma onot, san ten Gov, a sikia, Ayei onot non ma kat a fo mamatsiny ka.” ");
INSERT INTO sps_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita tsue to na ka ten Jisas, “Tagaa, mam naus osing a fo mamatsiny ka tsumam mam atou vovou Manyi.” ");
INSERT INTO sps_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisas tsue to, “Nyo tsue faman of maromi, vainy te faaman Vanyo ri vovou iny ton Vurungan Rof nane Krais ser naus osing fo numaa tsuar, an fuainy famuinyasiny, ge fafiner, an tsinar min tamar, ana fo guei tsuri, gen fo tanun kan tsuri, ");
INSERT INTO sps_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nai nom ror a foka fis non natus ka te naus osing mi ri, ito tan fo numaa, an famuinyasiny, an fafinen, an tsinan, an taman, an guei an tanun, ai te nai nom fakamits an patang roman, sai tan nainy te naa minon nai nom non a toto na suu. ");
INSERT INTO sps_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sana ri na vainy a kinai te kaa men asangan karap tovei roman nai nom ror asangan kakaii, ana rin vainy kinai te gim ror ma kaa men asangan nai nom ror asangan karap tan nainy vou.” ");
INSERT INTO sps_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisas an matisian Tsuan taan sanaan te naa fi naa non Jerusalem. Jisas taan famumua an matisian vovou iny Towa, ser fakakarian er; ana rin vainy te vovou me oraav fakap rato, Jisas mei pis ir safunuu ana ina fuan a matisian Tsuan tatangin, Ya tanik iny tsue of pis ratuari na saa te ruak non Tsunia na. ");
INSERT INTO sps_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nongon yam, ra naa fi ror Jerusalem ana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa fi naa non nimar tsunaun tan tsoiny faakor tana taa Jiu, an tsoiny fifaatsuts tan Faun te kirkir iny e Moses. Ri nai sigainy ror Ya ri te tsue of Ya ma mat. Ana ri te faan iny naa Ya tan mes vainy kaner sikia ma taa Jiu. ");
INSERT INTO sps_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Er tsue taring iny Towa, kasuf iny Towa, rapits Towa, er tokoiny Towa; san tan fafofopis nan nainy Ayei nai tsun fatabin enanon.” ");
INSERT INTO sps_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jemis me Jon a ina fuan a guei tsoiny ten Sebedi, naa me ten Jisas, ser tsue Tsunia, “Tsoiny Fifaatsuts, mam komainy rangat marom Anyi ma kat of mamimam ta ka.” ");
INSERT INTO sps_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisas tsue to tsuri, “A saa te komainy romi Nyo ma kat tsumi na.” ");
INSERT INTO sps_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ari te komainy ma fakarap a tsivor to ser tsue Tsunia, “Te nai gum fi rom Anyi tan tagan Tsuam fiisen men siinaiv tana Waam Anyi, mam komainy gum rom fiisen mamirom Anyi, isen tan nimainy matou Tsumanyi ana mesmes tan nimainy keeruk.” ");
INSERT INTO sps_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisas tsue to tsuri, “Mi sikia rom ma natiny a ka te rangat iny romi. Mi onot rom ma jiu iny a gotan iny Saraa kamits to te jiu iny Ronyo? Mi onot rom ma fapeenan iny mat, vovou iny rom a tou fapeenan iny mat te peenan fi Nyo?” ");
INSERT INTO sps_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Mam onot rom,” tsue fi ri. Jisas tsue to tsuri, “A gotan iny saraa kamits te jiu iny Ronyo mi nai jiu iny nats rom ya; an tana tou fapeenan iny mat te peenan fi Nyo, ami nai fapeenan fi kanem marom jesan; ");
INSERT INTO sps_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","san tana tou gum tan nimainy matou ge tan nimainy keeruk, a sikia ma ka Tsonyo iny faan im, san a pan to aya tsun ten Gov te faan iny non ya tsurin vainy te nai kakouiny onots Ya.” ");
INSERT INTO sps_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Te nongoiny a ina safunuu na matisian a ka to, ri sewaar iny to ere Jemis me Jon. ");
INSERT INTO sps_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sen Jisas fikoo faavots ratuari sa tsue, “Mi natem a vainy faarei raror tsunaun tana vainy te kaa miror a parits fis ror vainy babainy an fuainy tsoiny mumua te vakek rarori tan vovou iny vegiau tsuri. ");
INSERT INTO sps_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","San kat to ayei ma ruak vaare fapoopoan namami a sikia ma sanaan nan ya. Ta isen tsumi te komainy karap non, ayei ma faarei me na tsoiny toukuar tsumi faavot, ");
INSERT INTO sps_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","an ta isen tsumi komainy non ma mumua mami, ayei ma tsoiny binun babainy tsumi faavot, ");
INSERT INTO sps_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","faarei non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, gima naa me ma kat a vainy a binun iny faakouts Ya, a sikia, Ayei te naa me ma kat Ya na binun iny faakouts ir a vainy faavot ma faan iny Ya na Tsivon a mat to, a faarei to na pats ma puruur ravainy Ya na vainy a kinai te kaa ror tana numaa iny kotskots tan aveto.” ");
INSERT INTO sps_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ri nai ruak mito Jeriko, sen Jisas an matisian Tsunia fiisen kan ramirin tagin tsian fiisok naus osing a fan Jeriko, ana mes a mata kio koo rori Batimias, a guei tsoiny ten Timias gumgum en tatangin a sanaan sing maamaa non ta foka. ");
INSERT INTO sps_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te nongoiny ya Jisas a tsoiny Nasaret, ya tanik iny kuu busen nato, “Jisas, tsubnaain ten Devit, tagtag vame!” ");
INSERT INTO sps_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Fokinai tsue ets'ets iny towa ser tsue of ya ma vanumui sana ayei kuu fatsian pis to, “Tsubnaain ten Devit, tagtag vame!” ");
INSERT INTO sps_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ai Jisas tsutsun to, sa tsue na ka, “Fikoo finy mi yam nei.” Ser fikoo na mes a mata kio to, “Rof non, tsue fi ri. Tsun, Ayei te fikoo marom anyi.” ");
INSERT INTO sps_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ya ravainy ton vau iny jiarasan tsuan, ya tsetsiak to, ya naa fi to ten Jisas, ");
INSERT INTO sps_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“A saa te komainy rom anyi ma kat Anyo tsumanyi na,” rangat finy ya Jisas. “Tsunaun,” biny fi ya na mata kio to, “nyo komainy matoong rou.” ");
INSERT INTO sps_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ai Jisas tsue of towa, “Kuar sanyi faason tsumanyi te tsipaar manyi.” Sen tsun ana ayei tagaa bus nato, ya vovou iny naa to Jisas. ");
INSERT INTO sps_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Te naa fasiruu naa ri tana ngats fan tsian iny Jerusalem, ri ruak to tana fuan a ngats fan iny Betpeits ai Betani tan tobeer te koo rori na Tobeer tan Oliv. Jisas fakuar famumuei ra naa to na ina fuan a matisian Tsunia, ");
INSERT INTO sps_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","sa tsue of rari, “Kuar yam tana fan naa to aya mata mami, ai te sof naa romi mi sab rom a tsunei dongki te tang iny ari na aya a sikia ta mes ma gum voun ya a taataan iny towa, puruur yam mi te mei mi ya nei. ");
INSERT INTO sps_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ta mes te rangat maromi, ‘A saa te puruur of romi ya na?’ Tsue of yam, ‘A Tsunaun kaa minon a binun tsunia ana ayei faan fatabin veesau iny minon ya.’” ");
INSERT INTO sps_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ri naa ser sab a tsunei dongki sanaan tang iny ari tan matainy sobaa nana aunon i jiarasan. Te puruur kaner raror tana tsunei dongki, ");
INSERT INTO sps_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mesapan tsuri tsutsun panan ari rangat ratuari, “A saa te puruur of romi na tsunei dongki na?” ");
INSERT INTO sps_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ri pangis raton a vainy te tsutsun pana rari tan vegiau te tsue of rari Jisas, rin vainy famanat ratuari. ");
INSERT INTO sps_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ana ri mei naa to na tsunei dongki ten Jisas. Matisian ban iny fo vau tsuar tounon a tsunei dongki ai Jisas gum to tana tsunei dongki. ");
INSERT INTO sps_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A vainy a kinai ban iny a fo vau tsuar sanaan, ana mesapan tsuri tek miton fo paura ratsuu ser ban iny ya sanaan. ");
INSERT INTO sps_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Rin vainy te taan famumua naa ten Jisas ana ri na mesapan vovovou iny naa Ya tanik iny kuu bus rato, “Saup fatabin mamam yam! “Gov faparits marom Anyi te naa mirom tana asangan a Tsunaun! ");
INSERT INTO sps_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Gov faparits a Aatouf tsumam te mei minon a Waan e Devit a tsuvumam. “Saup fatabin mamam yam, Anyi na Gov a tsigtsig!” ");
INSERT INTO sps_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas sof Jerusalem, Ya naa fi enato tana saape; te tagei Ya na fo mamatsiny ka na aya, sai te ananerof busen, Ya naa fi naa to tana ngats fan iny Betani fiisen ramiri na ina safunuu ana ina fuan a matisian. ");
INSERT INTO sps_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tan mes nainy te naus osing fatabiny mi ri na Betani, Jisas ves nato. ");
INSERT INTO sps_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ya matoong fi naa tan nau u Fig kaa men noun kinai tsutsun minon veevian, ana Ya naa fi naa to tan Fig, pon iny nau ma kaa me tu fua; te ruak naa Ya tan nau sana sikia tu fua, noun babainy tsun tana saa sikia ma nainy tan Fig iny fua. ");
INSERT INTO sps_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisas tsue to tan Nau Fig to aya, “Sikia ta mes te onot iny ainy pis nats non tu fua tsumanyi.” San matisian Tsunia nongoiny Ya te vegiau fi Ya. ");
INSERT INTO sps_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te ruak naa ri Jerusalem, Jisas sof naa gagon tana aunon tana saape ana Ya tanik iny jiaats vavagen raton a vainy te fafiifoiny iny a fo mamatsiny ka tsuar koman a saape, ana ri kan foiny ir fo mamatsiny ka. Ya kof raton taran tan vainy papangis moni ana Ya kof kan raton fo gumgum tana vainy te fafiifoiny iny baanus. ");
INSERT INTO sps_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ya fa'agaagoiny to na pan tana saape ma govets vaare naa ta vainy ta ka unya. ");
INSERT INTO sps_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ya faatsuts raton a vainy, Ya tsue to tsuri, “Te kirkir en tan Vegiau Ten Gov, Gov te tsue, ‘Numaa Tsonyo koo rori na numaa iny fafaakats. (Aisaia 56.7) Sana mi kat faarei ya na puts iny takop tan vainy kakabuts.’” ");
INSERT INTO sps_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Rin tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun nongoiny to na ka to, ser tanik iny tsikoo ta fo sanaan iny atsuiny e Jisas. Ri gima onot, tsuri te oraav kainy Ya tana saa gum iny vainy te saar iny fafaatsuts Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tana touraf Jisas an matisian Tsunia naus osing to na ngats fan tsian. ");
INSERT INTO sps_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tana voinyvoiny ovei te taan naa ri sanaan ri tagein nau u Fig te maas tanik me tan kopurun ya nai ruak nato tan guan. ");
INSERT INTO sps_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita gima anofe na ka to an vegiau te kat e Jisas, sa tsue Tsunia, “Tagaa! Tsoiny Fifaatsuts, nau u Fig te peits Anyi te maas en.” ");
INSERT INTO sps_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisas biny ratuari, “Ami ma faason ten Gov. ");
INSERT INTO sps_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nyo tsue faman of maromi, sei te onot iny tsue of a tobeer to, ‘Tasas nyi te nai ruk em namaan,’ te gim fi non ya ma vaa'ets aaven, sai te faamainy non yan tsue tsunia tana ka te nai ruak non onot non ma nai ruak faman ovei tsun en. ");
INSERT INTO sps_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tan kat to aya nyo tsue of maromi, te rangat fi romi tan faakats, faaman yam mi te nom ya, ana ka to aya a ka tsumi. ");
INSERT INTO sps_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ai te tsutsun iny faakats romi, anofe ravainy yam a iring te kat a mesmes tsumi, tan kat to aya Tamamami te kaa non Gormirmir nai anofe ravainy kainy non a iring tsumi. ");
INSERT INTO sps_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Te gim fi romi ma anofe ravainy a iring te kat a mesmes, e Tamamami te kaa non Gormirmir gim kainy non ma nai anofe ravainy a iring te kat ami.” ");
INSERT INTO sps_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri fatabin pis mito Jerusalem. Te taataan e Jisas koman a saape, tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun, an tsunaun tana taa Jiu naa mito Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ser rangats Ya, “Saf gumgum Tsumanyi to na to Tsumanyi kat rom fo mamatsiny ka na? Sei faan Manyin gumgum iny kat a fo mamatsiny ka to ee?” ");
INSERT INTO sps_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas biny ratuari, “Nyo kan rangat maromin sen tsun rangat, te pangis fi Varonyo mi, Nyo te tsue of mamin saf gumgum to te kaa Mironyo na iny kat a fo mamatsiny ka to. ");
INSERT INTO sps_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mi ma tsue of Vanyo a tou fapeenan ten Jon, fei te nom e Jon gumgum iny fapeenan ei, poo fi me ten Gov ge tana mes?” ");
INSERT INTO sps_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ri tanik iny fatsitsien bus rato fapoopoan narari, “A saa te tsue rora na? Te tsue fi rora nei, ‘Te poo fi me ten Gov,’ ana Ayei te tsue na ka tsura, ‘Kat pas fei, sam gima faamainy e Jon ei?’ ");
INSERT INTO sps_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sai te nai tsue fi rora nei, ‘Poo me tana mes?’” (Ari te oraav ir a vainy, tana saa a fokinai te faamainy e Jon ayei na kuigin faman.) ");
INSERT INTO sps_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","To ser biny e Jisas, “Mam gim rom ma nat.” Jisas tsue to tsuri, “Nyo kan gim rou ma tsue of mamin saf gumgum Tsonyo iny kat a foka na.” ");
INSERT INTO sps_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas tsue of rarin fo tsue fapapaar, “A mes te reev tanun Gereip. Ya aunoiny faafis ton tanun wain tsuan, kats to na gaguur iny memedak fua nan ngits Gereip, ana ya fatsuiny to na tovaar a nai jias a pan tan tsoiny bei ot ma tagaa ri tan vainy kakabuts. Ya foiny ton tsoiny tatagaa ot iny tanun Gereip tsunia, er binun tanun of towa, ana ya naa enato tana mes a fan kanen veevian. ");
INSERT INTO sps_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ai tan nainy bus iny patsik fua ya jiats naa to na isen a tsoiny binun tsuan ma nom ya ta tee fua nan tanun tsuan tan tsoiny tatagaa ot iny tanun tsunia. ");
INSERT INTO sps_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","San tsoiny tatagaa ot iny tanun to nots a tsoiny binun to ser rapits ya ri jiats babainy fatabiny naa towa. ");
INSERT INTO sps_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kat to an taman tanun wain jiats pis naa to na mesmes a tsoiny binun, ri kat tafisuan towa patsuun ya ser kat farejiaf ya. ");
INSERT INTO sps_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Taman tanun wain to ayei jiats pis nats to na mesmes a tsoiny binun, ri atsuiny famat towa, senviir kat te kat ari tan fo mes a fo tsoiny binun, pongpong ir a mesapan, ri atsuiny famat kan raton a mesapan. ");
INSERT INTO sps_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“A isen tsun te kaakaa, ma jiats naa ya, a guei tsunia fatoobing te kaa non koman tsian tsunia. Fafakap nan ya, ya jiats naa towa sa tsue fi nei, ‘U man ri famaari ror a guei tsoiny tsonyo.’ ");
INSERT INTO sps_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“San vainy tatagaa ot iny tanun vegiau fapoopoan narari patsukaner, ‘Ayei bus a guei tsoiny tan taman tanun to. Tanats yam ma atsuiny famat ara ya, ana fo mamatsiny ka tsunia tovei fasito iny rora.’ ");
INSERT INTO sps_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ser nots a guei tsoiny to aya ser atsuiny ya, ri nom to na puan ya ser faviir fajesa osing ya na tanun wain. ");
INSERT INTO sps_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“A saa te kat non taman tanun tan tsoiny tatagaa ot tan tanun na,” rangat fi Jisas, “Ayei naa minon ana ayei te nai atsuiny famat ir a vainy tatagaa ot iny tanun to, ana ayei te faan iny tanun wain tan mes panainy vainy tatagaa ot ma tagaa ot iny ari ya.” ");
INSERT INTO sps_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jisas tsue to tsuri, “Mi gima gogosias a ka to te tsue iny Vegiau Ten Gov? ‘A fats a marats to te tsugei fuainy tsoiny fatsun numaa ruak faarei na fats a karap ovei tana numaa. ");
INSERT INTO sps_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tsunaun fapogaar ya ana ya mamatan faarof ovei tsun enato mata rara.’” ");
INSERT INTO sps_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun an tsunaun tana taa Jiu tanaf iny nots e Jisas, tana saa ri natiny e Jisas te tsue faruak iny tsue fapapaar te sak rari, sana ri oraav ir tagin kinai, ser naus osing Ya ri naa bus rato. ");
INSERT INTO sps_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ri jiats naa to na tee Farasi ana tee vainy ten Herot unya ten Jisas, ma tanaf ari Ya er fataraatsua iny Towa tan fo rangat. ");
INSERT INTO sps_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ri naa mito Tsunia ser tsue na ka, “Tsoiny Fifaatsuts, mam nat marom Nyi natiny tsue iny rom a man ana Nyi gim kan rom ma aspeer ta mes, kainon to te kaa fi mirorin asangan, gen vainy babainy, sana Nyi faatsuts iny rom a man nane Gov tana vainy. Tsue of mamimam, te toobing non tan faun tsura ma foiny takis fi naa ten Sisa na aatouf iny Roum ge na sikia? Saf fakats Tsumanyi na, mam ma foiny ge sikia?” ");
INSERT INTO sps_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sen Jisas nat faamuainy iny kat mapam tsuri sa tsue na ka, “Kat fei sam fataraatsua Varonyo ei? Faan Vanyo yam ta isen ta painy moni kainy foiny takis ma tagaa Nyo tsunia.” ");
INSERT INTO sps_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ri mei mito na isen a painy moni, Ya rangats ratuari, “A nain e sei an asangan e sei to aya ee?” Ri biny Towa ser tsue na ka, “E Sisa na aatouf.” ");
INSERT INTO sps_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sen Jisas tsue to tsuri, “Jio, fainy yam e Sisa na foka ten Sisa, am fainy to Gov, a foka ten Gov.” Ana ri karian fiisok tsun erato ten Jisas. ");
INSERT INTO sps_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ri na tee vainy tana taa Sadusi te natiny faamainy ror a mes te gim non ma tsun fatabin tana mat naa mito ten Jisas ser rangats Ya, ");
INSERT INTO sps_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tsoiny Fifaatsuts, Moses te kirkir iny a Faun to tsumam, te mat osing non a mes a moun tsuan, ana sikia ta guei, a famuinyasiny tana mes to aya ma fanging a amov to ma faruak of ya famuinyasiny tsuan to te mat ta guei. ");
INSERT INTO sps_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eye, te kaa men mumuinyasiny ina fits ana vaamuan fanging to, ana ya maten nato a sikia tu guei, ");
INSERT INTO sps_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ana fafuan narari fanging to na amov to, ana ya gim pis to ma faruak ta guei. Jesan te kat fi kan a fofopis nararin mumuinyasiny. ");
INSERT INTO sps_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Rin mumuinyasiny ina fits to ari te kat senviir kat, gima faruak ir ta fo guei tana moun to aya. Fafakap nan ya ana amov to aya mat to. ");
INSERT INTO sps_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ai to tan nainy tana tou tsun fatabin tana mat, e sei tsuri te nai faarei non a tsoiny tana moun to ee, tana saa, ri na ina fits ovei mumuinyasiny te fanging a amov to.” ");
INSERT INTO sps_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas biny ratuari, “A iring tsumi, tana saa mi gima natiny Vegiau Ten Gov ana parits Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tan vainy mat to te tsun fatabin fi rori tana mat tsuar, ri faarei raror morena iny Gormirmir, an tsoiny min moun a sikia tu fifanging pis na aya. ");
INSERT INTO sps_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ai to kan tana tou tsun fatabin tana mes tana mat, mi gima gogosias vegiau te kirkir iny e Moses, Gov a Tsunaun te tsue of ya tan koman guaf te ruak tan nau kakaii sa gima maas sa tsue, ‘Anyo na Gov ten Abraham, ana Gov ten Aisak, ana Gov ten Jekop.’ ");
INSERT INTO sps_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Faarei non a Gov, Ayei na sikia ma Gov tan vainy mat, Ayei na Gov tan vainy toto. Mi piou fiisok tsun rom.” ");
INSERT INTO sps_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A isen a tsoiny fifaatsuts tan Faun naa me sa nongoiny rari te fatsutsue ror. Natiny e Jisas te pangis faarof ovei tsun ir a vainy te gim ror ma natiny faamainy a tou tsun fatabin tana mes, ya rangats pis kainy to Jisas, “A saf a Faun te kirkir iny e Moses te karap fafis non tana fo faun faavot na?” ");
INSERT INTO sps_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas biny ya, “Tovei na Faun te karap fafis non, ‘Nongon yam guei iny Isrel: Tsunaun a Gov tsura, Ayei na isen tsun a Tsunaun. ");
INSERT INTO sps_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nyi ma mangiir a Tsunaun a Gov tsumanyi fiisen men komam faavot, fiisen men aavem faavot, ai fiisen men fakats faavot, fiisen kan men a fo parits faavot tsumanyi.’ ");
INSERT INTO sps_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ana fafuan nar faun a karap to: ‘Nyi ma mangiir fifakokoro tsuam faarei te mangiir rom anyi na tsivom.’ A sikia pis ta Faun te karap fafis iny non a fuan a faun to.” ");
INSERT INTO sps_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tsoiny fifaatsuts tan faun tsue to ten Jisas, “Man ovei Tsoiny Fifaatsuts, vegiau te kat Anyin rof ovei tsun, Gov tsun Tsivon a isen te karap fafis non, Ana sikia pis ta mes ta Gov te karap non, sana Ayei tsun Tsivon. ");
INSERT INTO sps_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A mes ma mangiir e Gov fiisen me na koman faavot, fiisen men fakats tsuan faavot, fiisen me na parits tsuan faavot ana ayei ma mangiir kainy fifakokoro tsuan faarei te mangiir finy non ya na tsivon, manaats fuan a faun to aya te karap fafisfis pis iny non fo kat faakor an fo fifaan ten Gov.” ");
INSERT INTO sps_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas natiny vegiau tsunian man ovei tsun, “Anyi gima veevian osing a Waan e Gov.” Sana sikia ta isen tsuri ma ongoor iny rangat pis. ");
INSERT INTO sps_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nainy te fafaatsuts e Jisas koman a saape. Ya rangat to, “Kat fei sana fo tsoiny fifaatsuts tan Faun tsue ror e Krais a Tsoiny Fiisaup a tsubnaain ten Devit ei? ");
INSERT INTO sps_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aaven Taabos tovei te pokei mi Ya nguen e Devit ana Ya tsue to na ka, ‘A Tsunaun e Gov te tsue tana Krais a Tsunaun tsonyo, Gum nei tan panaainy matou Tsonyo, onot non te fakei finy Ronyon fo vainy te koma iring marom Anyi er kaa to fain a mou Manyi.’ ");
INSERT INTO sps_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit kan koo Ya Krais ‘A Tsunaun tsonyo,’ a tsubnaain tsunia. Fei te kat fi na Krais, a Tsoiny Fiisaup sa gima tsubnaain babainy ten Devit ei, Ayei karap fafis iny non e Devit, taava?” Rin tagin tsian paparaa ma nongoiny vegiau Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Te fafaatsuts e Jisas a vainy, Ya tsue to, “Tanamots yam tsoiny fifaatsuts tan Faun te kirkir iny e Moses te komainy taan vavis men vau beberus iny jiarasan, er komainy to ta mes ma favoinyvoiny rari tana pan iny tuan, ");
INSERT INTO sps_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ai tovei tan komainy gum matan tan numaa iny fafaatouf tana taa Jiu ai tan tsutsun tana vaamuan nana pan iny guainy. ");
INSERT INTO sps_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ana ri fagaug raror fo amov er kabuts paser numaa tsuri, ana ri kat faatok er mata rari tan kat a fo faakats viviakoo ma famuiny ari na fo iring tsuri. Tan kat to aya fasaraa tsuri nai karap fafis non.” ");
INSERT INTO sps_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Te gum e Jisas panan a guuv tana saape, Ya tagei to na vainy te faan iny a fo painy moni tsuar koman a guuv. Vainy masun a kinai faan iny a fo moni tsuar kinai fiisok. ");
INSERT INTO sps_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ana amov a aaruts naa mito sa faan iny a fuan a painy takep te onots non a fuan a toea. ");
INSERT INTO sps_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisas fikoo faavot ir matisian Tsuan, ana Ya tsue to tsuri, “Nyo tsue faman of maromi, a amov a aaruts tovei te faan fafis pis tana mesapan te faan iny painy moni tsuri koman a guuv, ");
INSERT INTO sps_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","tana saa, mesapan to ari te faan ravainy a kakaii tsun tana fo masun tsuri, sana amov a aaruts tovei faan seerep iny a pan iny ainy tsunia tana kainy aaruts tsunia.” ");
INSERT INTO sps_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Te tafuts osing me Jisas a saape, isen tsurin matisian Tsunia tagei to na saape sa tsue ten Jisas, “Tsoiny Fifaatsuts, tagaa tan fo fats a fo rof ana fo numaan saavits fiisok tsun!” ");
INSERT INTO sps_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisas tsue to tsunia, “Eye, anyi onot rom a tagei fo numaa tsian to roman. Vou, sikia ta isen ta fats te fifatua on nats non a fifatua to tana iinin ya, fo fats to tarop miror nei peto, ri te nai soon er putaa.” ");
INSERT INTO sps_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Te gum e Jisas tan Tobeer iny Oliv tana pan a tomani, Ya tagaa fi naa to tana saape, Pita me Jemis ai Jon ai Anduru naa me ser rangats Ya. ");
INSERT INTO sps_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tsue of mamimam, farainy te nai ruak nats non a ka to? Ana saf a ka te nai ruak nats non na ana ya te faatok fatoobing iny nainy te ruak en naa me?” ");
INSERT INTO sps_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisas tanik iny tsue of ratuari, “Tanamots yam, am famanat vaare to ta mes ma fagaug mami ya. ");
INSERT INTO sps_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vainy a kinai naa fiisen miror a asanga Vanyo, ri te tsue na ka, ‘Anyo na Krais,’ ana ri te fagaug ir a vainy a kinai. ");
INSERT INTO sps_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mi nai nongoiny nats rom sagoge nana puaan gen vaanan nana puaan faasai sana mi ma onanun vaare. Foka to te ruak nats non, sana sikia ma fafakap nan puputaa to. ");
INSERT INTO sps_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Fo gum fan te fapupuaan ramiror mes a fo gum fan kaner, ana isen a aatouf an tsoiny puaan tsuan vapupuaan miror a aatouf an tsoiny puaan tsuan kaa kan minon a fo nuu tan fo viir pan, an nainy ves nai ruak kan nats non, fo mamatsiny ka to te faarei tsuiny non te tanik iny kamits fi non a tsinan te kat iny faagiir fi non ya na guei tsuan. ");
INSERT INTO sps_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Sana mi ma tanamots a tsivom, kat ror ser ras ma naa mi tan vaatsuk, er rapits matuami koman a fo numaa iny fafaatouf tana taa Jiu, ana ri te fatsutsun mami matar gotouf an tsoiny tsian tana gamaman, tana saa mi te faaman Vanyo, sana ayei nainy rof tsumi iny favaanan iny Vurungan Rof tsuri. ");
INSERT INTO sps_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vainy ma favaanan famumua tsom iny Vurungan Rof nane Krais tana fo mamatsiny pan faavot. ");
INSERT INTO sps_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ai tan nainy te nots maromi ri ri te ras mami tan vaatsuk, koma patang faamuan vaare yam, vegiau nai tsue iny romi, tan ar nainy to aya u vegiau sikia ma vegiau tsumi, sai te poo fi minon tan Aaven Taabos to ayei te vegiau fiisen mamiromi. ");
INSERT INTO sps_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Vainy faan iny naa ror fo famuinyasiny tsuar er atsuiny famat ratuari. Jesan kan te kat fi nats ror tamar guei tan fuainy guei tsuar, an fuainy guei te tamimiat of ir tamar min tsinar ana mesapan te atsuiny famat rari. ");
INSERT INTO sps_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ana fokinai te koma iring fiisok tsun iny mami tana saa mi te faaman Vanyo. Sana mes te suu iny non a faaman tsuan onot non tan fafakap nan puputaa to, Gov nai saup fatabiny non ya ana ayei te nom a toto na suu.” ");
INSERT INTO sps_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Sen Jisas tsue na ka, “Mi nai tagei nats rom a ‘Iring Tsian Fiisok’ ruak nats non tan ta pan te gim non ma fasito iny, (A vainy te gogosias ror vegiau to ma nat faarof iny arin kifon vegiau to,) arin vainy te kaa ror tana gum fan iny Judia ma bus fapaas fi naa tana fo tobeer. ");
INSERT INTO sps_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ana mes te kaa non jiarasan numaa tsuan ma sof fatabin vaare gagon numaa ma nom ya ta foka tsuan, ayei ma bus tsun naa naa. ");
INSERT INTO sps_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ana mes kaa non tanun tsuan ma tabin vaare a nai nom ton vau tsuan, ayei ma bus tsun naa naa. ");
INSERT INTO sps_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","O reesik fiisok, ma sekee fuainy moun kuraa, an fuainy moun see faagiir, ri fasus ror tan guei tsuri tan nainy to. ");
INSERT INTO sps_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Faakats yam ten Gov tana foka to ma ruak on vaare yan nainy tana tonok tsian, ");
INSERT INTO sps_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","tana saa ito tan nainy ‘Iring Tsian Fiisok’ tan nainy to aya, nai iring fatsian pis naa non ya te iring fafis a fo nainy iring muan to te fapogaar finy e Gov a monaagits to onot non tan ar nainy to aya. Nainy iring tsian fiisok to te gima ruak muan, ge vou kan. ");
INSERT INTO sps_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sana Tsunaun nai fakakats bus a fo mar nainy, fiisia, Ayei gima kat a ka to, ai sei ta mes te toto nats non ee. San tana vainy te pisainy fatoobing Ya, to sana Ayei fakakats nainy. ");
INSERT INTO sps_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“San tan nainy to, te tsue fi non ta mes tsumi, ‘Tagaa, e Krais to!’ ge, ‘Tagaa, ayei tuwa aya!’ —faamainy vaare yam, ");
INSERT INTO sps_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","tana saa, fo Krais gamgam an fuainy kuigin gamgam nai ruak nats ror, er faatok iny to na foka iny faatok ma fagaug rari rin vainy te pisainy rari Gov ana ri fasito fatoobing ratuari Ya sana sikia ma onot. ");
INSERT INTO sps_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ami ma tamomots faarof a ka to, Nyo tsue faamuan of bus mami na ka to.” ");
INSERT INTO sps_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“San tan nainy to aya, voun nainy ‘Iring Tsian Fiisok,’ ‘A nuaf nai uurup enanon, ana iifaa gim non ma nai tsingaar; ");
INSERT INTO sps_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","fo kootsits nai tapatsik osing miror a korosuu, ana fo mamatsiny parits iny korosuu nai tatagut eraror, er tasas osing to naa fo iinir.’ ");
INSERT INTO sps_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ana ri na fokinai te tagei bus a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me of minon koroo fiisen minon a parits a siireits an siinaiv. ");
INSERT INTO sps_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ana Ayei te jiats ramen morena Tsuan tana fats a ainysat tana monaagits to, tanik non tan sen panaan nan puputaa, ya te nai ruak tan mes panaan, ana ri nai vaaguam raror a vainy te pisainy Ya faarei raror fasito Tsunia.” ");
INSERT INTO sps_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisas te tsue, “Nom nat yam tan nau u vei, ma faatsuts mami yan siisio, am nat faarof iny towa. Tan nainy te tagei romin vei te firaar non mi natiny rom fua nan vei te sisiruu en. ");
INSERT INTO sps_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jesan kan, te tagei finy romi na fo mamatsiny ka te roruak non, mi ma nat fi nei, nainy tabin fatabin me Tsonyo te sisiruu ename. ");
INSERT INTO sps_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Fakats faarof yam a ka to! Nyo tsue faman of maromi, u aatai tovei te toto farokot kan raror tabuiny mat rori ana fo mamatsiny ka te tsue Nyo to nai ruak nats non. ");
INSERT INTO sps_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Korosuu an puputaa nai kajiaa enanon, san vegiau Tsonyo gim non ma nai kajiaa on.” ");
INSERT INTO sps_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Sana sikia ta mes te natiny non nainy ge na aua tana tou tabin fatabin me Tsonyo, tsuri kan morena iny Gormirmir, ge na Guei Tsoiny kan, san e Tamanyo tsun Tsivon te nat non. ");
INSERT INTO sps_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tamomots yam. Kaa to yam, faakats yam, am kakoun faarof to, tana saa, mi gim rom ma natiny nainy iny tabin fatabin me Tsonyo. ");
INSERT INTO sps_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","U nainy to aya te faarei tsuiny non a isen a mes te naus osing fi non ya na numaa tsuan tan tsoiny binun tsuan ma binun ari tan fo isiseiny binun tsuar a tsue faparits of to na tsoiny tatagaa ot tan matainy sobaa ma kaa to faarof ya. ");
INSERT INTO sps_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sana mi ma kaa to, mi te kakoun tana saa, mi gim rom ma nat iny nainy iny tabin fatabin me tana taman a numaa to, tana touraf, ge tana tangats iny voiny, ge te kokorooto non a koriou a tsoiny, ge tana voinyvoiny. ");
INSERT INTO sps_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kaa to yam, mi te kakoun, kat non Tsunia tabin veesau me ya te sab mami te goros farokot rom. ");
INSERT INTO sps_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","An vegiau te tsue of marom yam an tana vainy faavot kan: Kaa to yam!” ");
INSERT INTO sps_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","U fuan tsun nainy te kaakaa non ana taa Jiu te Fakats Fatabiny nainy te faakouts e Gov a taa Isrel ser naus osing me na gum fan iny Ijip, an nainy Guainy te ainy rorin Koinykoiny Sikia ma kaa me tu Yis. An tsunaun tan tsoiny faakor ana rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses komainy to ma sainy ta sanaan ta takop iny nots er atsun famat to Jisas. ");
INSERT INTO sps_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ana ri tsue to, “Ara ma kat vaare ya tan nainy guainy, kat ror san a fokinai fatsuiny fitaatsun.” ");
INSERT INTO sps_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas kaa enanon Betani, numaa ten Saimon to te kaa men tatauba muan, Jisas gum iny ainy non ana moun sof mito fiisen me na kepaa viainy minon tapui na tsuraf ana foiny nan ya na nai jias, ana moun to boree to na fiong nan kepaa ana ya tsiiu iny towa patsuun e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sana mesapan tsuri na vainy te kaa na aya peits ser favevegiau patsukaner ser tsue, “Saf a rof nan ya na to sa tsiiu raravainy tapui tovei?” ");
INSERT INTO sps_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A tapui na tsuraf to te onot non ma fafiifoiny ravaa a onots to na fopis natus moni ana painy moni te ruak te onot ma tatafas rari rin vainy aaruts. Ana ri peits iny to na moun to. ");
INSERT INTO sps_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sen Jisas tsue, “Tanyiny yam a moun to, kat fei sam kat tap iny rom ya ei? Ayei te kat a ka na saavits fiisok Tsonyo. ");
INSERT INTO sps_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mi nai kaa fatatabin ramirom vainy aaruts, ana mi te faakouts fatatabin kan rari te koman fi romi, sana Nyo gim rou ma nai kaa fatatabin fiisen mamiromi. ");
INSERT INTO sps_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A moun to te kat kat te onots ya ma kat ayei te tsiiu iny a tapui na tsuraf to pua Vanyo kakouiny onots non a pua Vanyo te naa fi non tana kats tan nainy te naa minon. ");
INSERT INTO sps_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Man ovei Nyo tsue of maromi, te vasiisio iny rorin Vurungan Rof nane Krais tana monaagits to, ri te fakats kainy kat te kat a moun to Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskariot a isen tsuri na safunuu ana ina fuan a matisian naa fi enato tan tsunaun tan tsoiny faakor, tana saa ayei komainy ma vegiau tsuk iny a sanaan fei te nai faan finy non ya Jisas nima rari ei. ");
INSERT INTO sps_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Te nongoiny arin vegiau ten Judas, ri paparaa mi towa, ser tsue faman ma faan iny e Judas ta moni. Sen Judas tanik iny sainy to tu nainy tu rof ma faan iny ya Jisas tsuri. ");
INSERT INTO sps_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tan vaamuan nan nainy Guainy te ainy rorin Koinykoiny Sikia ma kaa me tu Yis ito nainy te atsuiny kainy rorin tsunei siip nan nainy Guainy iny Fakats Fatabin ton nainy te faakouts e Gov a taa Isrel, ser naus osing me na Ijip, rin matisian ten Jisas rangats Towa, “Fei te komainy rom Anyi mam ma nai kakouiny Guainy iny Fakats Fatabin Tsumanyi ei?” ");
INSERT INTO sps_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sen Jisas jiats ra naan a ina fuan a matisian Tsuan sa tsue of rari, “Kuar yam koman a ngats fan tsian, ana isen a mes a govet kepaa aurom tainytainy maromi, vovou iny naa yam, ");
INSERT INTO sps_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","tana numaa te nai sof non ya, mi te tsue tana taman a numaa, ‘Tsoiny Fifaatsuts te tsue, Fei te kaa non a pan te nai ainy Ronyon Guainy iny Fakats Fatabin fiisen ramen matisian Tsonyo ei?’ ");
INSERT INTO sps_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ayei faatok maromi na pan tsian jias te kaa minon a fo mamatsiny ka iny kakoun a kainy ainy tana numaa, ayei na pan te nai kakoun romi na fo mamatsiny ka.” ");
INSERT INTO sps_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ri na ina fuan a matisian naa bus fi ra naa to tana ngats fan tsian ser sab a fo mamatsiny ka to te tsue of rari Jisas, ser kakouiny a kainy ainy iny Fakats Fatabin. ");
INSERT INTO sps_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Te ananerof bus ya, Jisas ruak fiisen me na ina safunuu ana ina fuan a matisian. ");
INSERT INTO sps_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ri gum to tana taran iny ainy Jisas tsue, “Man ovei Nyo tsue of maromi, isen tsumi nai faan iny Varonyo nimar vainy er nai atsuiny Vatuanyo, ana ayei kan te ainy fiisen Vamironyo.” ");
INSERT INTO sps_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rin matisian koma patang faavot rato, ser vegiau isisen patsukan iny Ya, “A sikia ma nyo?” ");
INSERT INTO sps_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ya tsue to tsuri, “A isen tsumi a ina safunuu ana ina fuan, ayei to te fabub non a koinykoiny koman kobuu fiisen Vaminyo. ");
INSERT INTO sps_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai mat non te tsue fin Vegiau Ten Gov, eye, nai mat non, sana sekeiny mes to te faan iny non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me! Gov nai fainy non ya na fasaraa tsian. Tabuiny rof fiisok tana mes to aya ma agiir vaare ten tsinan.” ");
INSERT INTO sps_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Te ainy farokot raror, Jisas nom to na koinykoiny, sa faakats iny faarof of naa towa ten Gov, Ya ivoo towa, sa fafaan rari ana Ya tsue to, “Nom yam am ainy towa, pua Vanyo tovei.” ");
INSERT INTO sps_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ana Ya nom to na gotan, Ya faarof iny naa towa ten Gov, Ya fafaan ratuari, ri na fokinai jiu towa, ");
INSERT INTO sps_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jisas tsue to, “U rafatsiny Tsonyo to aya te faparits non tsue faunot foun nane Gov, rafatsiny Tsonyo tatsiiu of non a fokinai tan kat iny anofe ravainy kat iny aveto. ");
INSERT INTO sps_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nyo tsue faman of maromi, Nyo gim rou ma jiu pis nats wain tovei, onot non tan nainy te jiu Ronyon wain foun tana Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ri kooma iny faatouf to ser naa fi tana Tobeer iny Oliv. ");
INSERT INTO sps_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ai Jisas tsue to tsuri, “Mi na fokinai te nai bus osing Varonyo, tana saa u Vegiau Ten Gov te tsue, ‘Gov nai atsuiny non a tsoiny veis tan siip ana fo siip te nai saats vavis a pan.’ ");
INSERT INTO sps_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","San tan voun nainy tana tou tsun fatabin tana mat, Nyo nai mumua pis maromi tana gum fan iny Galili.” ");
INSERT INTO sps_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita tsue to Tsunia, “Kainon to te kat fi rori na fokinai to, nyo gim rou ma nai bus osing Manyi.” ");
INSERT INTO sps_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas biny to Pita, “Man ovei, Nyo tsue of marom, tana voiny tovei roman tabuiny kokorooto non a koriou a tsoiny tan fafuan nan nainy, nyi nai faungis Varonyon fopis nainy, nyi gim rom ma nat Vanyo.” ");
INSERT INTO sps_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita pangis faparits Towa, “Kainon nyo nai mat fiisen mamirom Manyi, nyo gim rou ma faungis Manyi,” ana rin fokinai matisian tsue kan fi rato jesan. ");
INSERT INTO sps_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ri na fokinai naa fi rato tana pan te koo ri Getsemani, ana Ya tsue to tan matisian Tsuan, “Gum yam nei, ma nai faakats Anyo.” ");
INSERT INTO sps_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ana Ayei ras rato Pita ai Jemis me Jon sen Jisas fuas fakeits ana Ya koma patang fiisok ovei tsun nato. ");
INSERT INTO sps_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ya tsue to tsuri, “Aave Vanyo reesik fiisok non tovei kat iny atsuiny famat Varonyo, kaakaa yam nei am kaa to faarof to.” ");
INSERT INTO sps_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ayei taan fajesa naa to, Ya fagotsiny naa to na puan peto tan puputaa ana Ya faakats to, te rof fi non ya tan nainy saraa kamits to ma ruak vaare ya Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ya tsue to, “O Tetee, O Tamau, Anyi onot rom ma kat a fo mamatsiny ka, ayei tamee fiisok non Tsumanyi nom ravainy bus a gotan iny saraa kamits tovei Tsonyo, san sikia ma tan mangiir Tsonyo u mangiir tsun Tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ya tabin fatabin to sa sab ir a ina pis a matisian Tsuan goros ror, Ya gungun ratuari, Ya tsue to ten Pita, “Saimon amin goros? Mi sikia ma onot iny tagun ma kaa to mi tana isen a aua tsom?” ");
INSERT INTO sps_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ana Ayei tsue to tsuri, “Kaa to faarof yam am faakats to ma gotsiny vaare mi tan fiamus, aaven te koman non san puainy mes te ree'ats non.” ");
INSERT INTO sps_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ya tabin fatabin pis to sa faakats. Faakats patsukan fi kanen jesan. ");
INSERT INTO sps_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ana Ya fatabin pis to sa sab ir matisian Tsunian goros, mata rarin kaput farokot ser gima nat vaarik iny tu vegiau iny vegiau fiisen mi Ya. ");
INSERT INTO sps_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Te fafofopis iny tabin mi Ya, Ya tsue to tsuri, “Min goros ana mi favusuan kanem marom? Te onot busen! U nainy te ruak en tana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa fi naa non nimar vainy pisiin reits. ");
INSERT INTO sps_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tsun tanats yam, ma naa ra. Tagaa yam, a mes te faan vanaa Ronyo to, te ruak en.” ");
INSERT INTO sps_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas vegiau kanen nanon, sen tsun Judas, isen tsuri na safunuu ana ina fuan a matisian naa mito, fiisen men kinai mes govet kirat an vuts poo fi me tan tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun ana rin tsunaun tana taa Jiu te jiats ramiri. ");
INSERT INTO sps_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ana mes to aya to te faan iny e Jisas tsue faamuan of raton kinai tana ka te nai kat non ya: “A mes to ayei to te umei ronyo ayei koraa na mes te komainy romi. Nots yam am mei faarof naa Towa.” ");
INSERT INTO sps_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Te ruak me Judas ya naa fatoobing nato ten Jisas sa tsue na ka, “Tsoiny Fifaatsuts!” Ana ya umei Towa. ");
INSERT INTO sps_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ri nots Towa. ");
INSERT INTO sps_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sana isen tsuri to te tsutsun panan e Jisas gamus kirat nana puaan tsuan sa tek sapee na teinan a tsoiny binun babainy tan Tsoiny Mumua tan Tsoiny Faakor. ");
INSERT INTO sps_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ai Jisas tsue to tsuri, “Kat fei Anyo na kakabuts sam naa me iny nots Vanyo fiisen men kirat an vuts? ");
INSERT INTO sps_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Fo mamatsiny nainy Nyo kaa fiisen mamimi Nyo fifaatsuts you tana saape ana mi gim to ma nots Vanyo. San vegiau tan Vegiau Ten Gov to ma nai ruak iny man mi ya.” ");
INSERT INTO sps_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ana rin matisian faavot naus osing Towa ser fabuubus vavis er. ");
INSERT INTO sps_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ana isen a mes a vurots vau raarav gosee vovou iny e Jisas. Ri pon to ma nots ya, ");
INSERT INTO sps_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ya bus beerbeer naa to sa naus osing raarav gosee tsuan. ");
INSERT INTO sps_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ri mei naa to Jisas tana numaa tana Tsoiny Mumua tan Tsoiny Faakor. Ser vaaguam faavot mi Ya, rin tsunaun tan tsoiny faakor, an tsunaun tana taa Jiu an tsoiny fifaatsuts tan Faun te kirkir iny e Moses. ");
INSERT INTO sps_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita vovou iny naa Jisas gima naa fasiruu naa ya sof nato koman a aunon nana numaa tana Tsoiny Mumua tan Tsoiny Faakor. Ya gum fiisen ramiton tsoiny bei ot, mamangin en tan guaf. ");
INSERT INTO sps_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Rin tsunaun tan tsoiny faakor ana rin Fuainy Tsunaun tan Kansol tana taa Jiu tanaf iny sainy to ta fo vegiau nane Jisas ma atsuiny famat ari Ya, sana ri gima sab vaarik ta ka, ");
INSERT INTO sps_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","kainon to na vainy a kinai gam fiisok iny e Jisas an siisio tsurin gima senviir. ");
INSERT INTO sps_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ri na mesapan tsun to ser tsue faruak iny gam to ten Jisas, ");
INSERT INTO sps_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mam nongoiny Ya te tsue, ‘Anyo nai rurei rou a saape to aya te kat a vainy nimar ai tan fopis nainy Nyo nai fatsuiny rou ta isen te gim rori ma fatsuiny nimar.’” ");
INSERT INTO sps_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","An vegiau tsuri kan te gima senviir. ");
INSERT INTO sps_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ana Tsoiny Mumua tan Tsoiny Faakor tsutsun to mata rari ya rangats to Jisas, “Nyi na sikia tu vegiau iny fasakaa tap iny vegiau te sak Manyi ri?” ");
INSERT INTO sps_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","sen Jisas vanumui en Ya gim to ma vegiau vaarik. Ana Tsoiny Mumua tan Tsoiny Faakor rangats pis Towa, “Anyi na Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy ge na sikia? Nyi na Guei Tsoiny ten Gov to te faatouf rora ge na sikia?” ");
INSERT INTO sps_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas tsue to, “Eye, Anyo. Sana mi nai tagei nats rom a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me gum non tana pan iny fatsiitsii tan nimainy matou ten Gov a siireits, ana Ya te of fiisen me na koroo poo minon Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tan vegiau to aya ana Tsoiny Mumua tan Tsoiny Faakor peits to sa kakaar vau tsuan Ya tsue to, “Ara sikia ror ma komainy bus ta mesmes ma tsue tsuk iny Ya. ");
INSERT INTO sps_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tovei mi nongoiny fakap bus tsue vaaserere Tsunia, Tsunia te tsue, Ayei na Guei Tsoiny ten Gov te kat iny fifanauti minon e Gov! Saf a fasaraa tan fakats tsumi na?” Ana ri fatangan faavot to Ayei kat bus kat iring tamainy non ma mat tsun busen. ");
INSERT INTO sps_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sana mesapan tsuri tanik iny kasuf to Jisas, ping to na matan Ya, ser tsuguur Ya, ana ri tsue to na ka, “Jio, Nyi na kuigin, e sei te tsuguur Manyi ee!” Rin tsoiny bei ot sapainy Towa. ");
INSERT INTO sps_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita kaa enanon koman a aunon jiarasan numaa ana isen a kooviou, a muiny binun tana Tsoiny Mumua tan Tsoiny Faakor naa me, ");
INSERT INTO sps_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ya tagei to Pita te mangin non ya matoong towa, ya tsue to, “Nyi kan to te kaa fiisen me Jisas a tsoiny Nasaret.” ");
INSERT INTO sps_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sen Pita faungis to, “Nyo gim rou ma nat ana anyo gim kan rou ma natiny a ka te tsue iny rom anyi,” te biny finy ya ya, ai Pita naa fasiruu mito tan matainy sobaa nana aunon. Ana koriou kokorooto nato. ");
INSERT INTO sps_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ana mes a muiny binun tagei towa sa tsue of pis ratuarin vainy te tsutsutsun siruu, “Ayei na isen tsuri.” ");
INSERT INTO sps_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sen Pita faungis pis nato. Sikia ma potsian ana vainy tsutsun siruu tsue to ten Pita, “Man ovei nyi ma faungis vaare, nyi na isen tsuri tana saa nyi kan a tsoiny Galili.” ");
INSERT INTO sps_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sen Pita kat tsuen parits: “Gov tsun Tsivon faaroiny varonyo te pokei finy ronyon tsuen man tsumi. Nyo gim rou ma natiny a mes to te tsue tsuk iny romi!” ");
INSERT INTO sps_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sen tsun ana koriou kokorooto pis naton fuan nainy, sen Pita fakats fatabiny vegiau te tsue of ya Jisas. “Tabuiny kokorooto non a koriou a tsoiny tan fafuan nan nainy, nyi nai faungis Varonyon fopis nainy, nyi gim rom ma nat Vanyo.” Pita fakats a ka to, ya tangis fiisok enato. ");
INSERT INTO sps_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tana voinyvoiny ovei tsunaun tan tsoiny faakor fiisen ramirin fuainy tsunaun tana taa Jiu an tsoiny fifaatsuts tan Faun, iton Kansol faavot te vaagum ser kat vegiau, ana ri kotskots to Jisas, ri mei naa Towa ser faan iny naa Ya ten Pailat a gavana tana gum fan iny Judia. ");
INSERT INTO sps_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat rangats Towa, “Nyi Ya na Aatouf tana taa Jiu?” Ana Ya biny towa, “Naa, toobing non tsue fi rom anyi.” ");
INSERT INTO sps_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","An tsunaun tan tsoiny faakor sak Towan mamatsiny ka. ");
INSERT INTO sps_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ai Pailat rangat pis Towa, “Tagaa, saf fo mamatsiny vegiau to te sak Manyi ri na? Nyi na sikia tu vegiau iny fasakaa tap Manyi tan vegiau te sak Manyi ri?” ");
INSERT INTO sps_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sen Jisas gim to ma vegiau ta isen ta karainy vegiau, ai Pailat karian fiisok nato. ");
INSERT INTO sps_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tan fo mamatsiny Guainy Fakats Fatabin Pailat te natiny famanat iny non a isen a mes a kotskots ma tafuts ya te rangat finy rori ya na vainy. ");
INSERT INTO sps_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tan nainy to aya a mes te pisiin te koo rori Barabas te kaa tana numaa iny kotskots, tana saa ayei te kaa fiisen ramirin vainy te fapupuaan fiisen me na gamaman iny Roum, ana ayei kan te atsuiny famat ir mes vainy. ");
INSERT INTO sps_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Te vaaguam men kinai ser tanik iny rangats e Pailat ma kat to te natiny kat finy non yan kat to aya tan fatafuts a isen a mes a kokokots. ");
INSERT INTO sps_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ai Pailat biny ratuari, “Mi komainy varonyo ma puruur osing mami na Aatouf tana taa Jiu?” ");
INSERT INTO sps_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat nat fiisok ir tsunaun tan tsoiny faakor te faan iny me Jisas tsunia, tana saa ri te fitsufainy mi Ya. ");
INSERT INTO sps_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sana rin tsunaun tan tsoiny faakor fatsuiny komar tagin ma rangats ari Pailat ma fatafuts ravainy ya Barabas, san gima Jisas. ");
INSERT INTO sps_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat vegiau pis to tsurin tagin, “Fiisia, fei te kat finy ronyo na mes te koo mi na Aatouf tana taa Jiu ei?” ");
INSERT INTO sps_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ri kuu pis to, “Fagageits yam, fagageits tana pagafuan!” ");
INSERT INTO sps_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ai Pailat rangats ratuari, “Kat fei? Saf a iring te kat Ya na?” Ri vaposok iny kuu fatsian pis to, “Fagageits yam tana pagafuan!” ");
INSERT INTO sps_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat komainy ma kat fapapareir tagin ana ya fatafuts to Barabas tsuri, Ya faan iny naa to Jisas ma rapits ari Ya, er fagageits Towa tana pagafuan. ");
INSERT INTO sps_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","An vainy puaan mei naa to Jisas gagon tana aunon tan pan tana numaa te natiny kaa non e Pailat, ri fikoo vaaguam faavot raton vainy puaan. ");
INSERT INTO sps_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ana ri taring fiisok iny to Jisas, ri favau towan vau te natiny vau ror a fo aatouf, ton vaun mamaato, ana ri kat of Towa na sapou uupe kakarits, ser fa'uupe ya Jisas. ");
INSERT INTO sps_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ri faarua naa ton fo nimar Tsunia, “Kaakaa ovei, O Aatouf tana taa Jiu.” ");
INSERT INTO sps_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ri pour to na patsuun Ya na painy tsukan, ri kasuf Towa, ana ri fatukun to matan Ya faarei te fatsiitsii finy rorin vainy a aatouf. ");
INSERT INTO sps_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Te taring fakap bus iny ari Jisas, ri puruur osing Towan vau beberus iny jiarasan an mamaato ser favau fatabiny Yan vau Tsuan. Ri ras fatafuts naa Towa jiarasan tana ngats fan tsian a tou fagageits Ya tana pagafuan. ");
INSERT INTO sps_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sanaan ri sab a mes te koo rori Saimon a tsoiny Sairini taman Aleksanda me Rufas poo fi me tana tanun sa taataan fi naa tana ngats fan tsian ser sogsog ya, ri fagovets towa na pagafuan ten Jisas, ri tsue of towa ma vovou iny naa ya Jisas. ");
INSERT INTO sps_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ri ras naa to Jisas tana pan te koo rori Golgota, kifon vegiau to, “Pan tan tonaar.” ");
INSERT INTO sps_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na aya ri tanaf iny fainy Towan wain kopis mi rin nau aapeits koo rorin Mer, ma mafuu na puan Ya, Ya te gima sarei ta kamits, sen Jisas gima jiu ya. ");
INSERT INTO sps_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ai ri tapaar Towa tana pagafuan ser fagageits ya, ri tatafas ratuarin fo painy vau tsunia fapoopoan narari to tan tats fabiririir iny a saatu, ser fakiki sei te nom non isisen painy vau Tsunia. ");
INSERT INTO sps_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ri fagageits Ya tana sia na kilok tana voinyvoiny. ");
INSERT INTO sps_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","U vegiau to aya te kirkir te sak ari Jisas to, “Aatouf tana taa Jiu.” ");
INSERT INTO sps_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ana ri fagageits to na ina fuan a mes a kakabuts tana pagafuan fiisen me Jisas, isen tan panaainy matou ana mesmes tan panaainy keeruk. ");
INSERT INTO sps_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tan kat to aya vegiau tan vegiau Ten Gov ruak iny man ovei nato, “A vainy tagei ror Ya faarei me na mes a iring.” ");
INSERT INTO sps_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vainy te taataan fabisbis iny patsuur ana ri tsue vaaserere iny to Jisas, “Jio! Nyi tsue te rurei rom a saape, ana Nyi te fatsuiny fatabiny ya tan fopis nainy! ");
INSERT INTO sps_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Saup a Tsivom! Of osing me na pagafuan!” ");
INSERT INTO sps_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jesan kan te kat fin tsunaun tan tsoiny faakor ana rin tsoiny fifaatsuts tan Faun, tsue taring iny e Jisas fapoopoan narari, “Ayei saup ir a mesapan, sana Ayei gima saup a Tsivon! ");
INSERT INTO sps_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tanyi yam e Krais a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy, a Aatouf tana taa Isrel, ma of osing mi Ya na pagafuan roman, ma tagaa ra ana ra te faamainy Ya!” Tsuri kan a ina fuan te gageits fiisen me Jisas tsue fiiring kan iny Towa. ");
INSERT INTO sps_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tana safunuu ana fuan a kilok tana nuaf, monaagits faavot uurup faavot nato onots ovei a fopis a kilok tana touraf. ");
INSERT INTO sps_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tana fopis a kilok Jisas dau iny ton tangis tsian, “Eloi, Eloi, lama sabaktani?” kifon ya to, “Gov Tsiau, Gov Tsiau, kat fei sa Nyi naus osing Vanyo ei?” ");
INSERT INTO sps_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Rin mes vainy tsutsun na aya nongoiny Towa ser tsue na ka, “Nongon yam, Ayei te fikoo non e Ilaija ma faakouts Ya!” ");
INSERT INTO sps_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ana ina isen tsuri kuar to sa nom tsuuyan ya fabub towan wain maajiin, ya kotskots towa nguen ngaar ana ya tanaf to ma fajiu ya Jisas ana ayei tsue to, “Anaanos yam, ma tagaa ra te naa fi minon e Ilaija ma fauf ya Jisas tana pagafuan.” ");
INSERT INTO sps_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ai Jisas dau iny ton tangis tsian, Ya tauts to. ");
INSERT INTO sps_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","An raarav boo an tatabuan te gageits koman a saape takakaar to fapoopoan sa kat a fuan a pan sa tapue en, tanik me jias sa nai onot me peto. ");
INSERT INTO sps_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te tagei a tsoiny mumua tan vainy puaan te tsutsun na aya matan a pagafuan, ito te tagaa te tangis ai te mat fi Jisas, ya tsue to, “Man ovei, Ayei faman a Guei Tsoiny ten Gov!” ");
INSERT INTO sps_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ana mesapan nar moun to te kaakaa na aya tsutsun me veevian tagaa to fapoopoan narari e Meri na muiny Magdala, ai Meri kan tsinan Jemis te vurots iny non e Joses, ai Salome. ");
INSERT INTO sps_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Arin moun to aya vovovou iny e Jisas te kaakaa Ya Galili ana ri fafaakouts kainy Towa. Ana rin mes panainy moun kinai te kaa kan na aya, te naa fiisen mi naa Ya Jerusalem. ");
INSERT INTO sps_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Te touraf en an nainy iny kakoun onots a fo mamatsiny ka, tana saa u Nainy Fafaatouf tana taa Jiu tamanainy. ");
INSERT INTO sps_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep a tsoiny Arimatia natiny famaari rori ruak me. Ayei kan a isen tsurin tsoiny mumua tana taa Jiu te vaagum tana Kansol te anaanos kainy non a tou naa me tana Waan e Gov, ayei te ongoor sa nai ruak e Pailat, ya rangats towa na puan e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat karian te nongoiny finy ya Jisas te maten. Ya fikoo to na tsoiny mumua tan vainy puaan ana ya rangats towa te mat fi Jisas. ");
INSERT INTO sps_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Te nongoiny fakap bus e Pailat vegiau to tana tsoiny mumua tan vainy puaan, Pailat tsue of to Josep ayei onot non ma nom a puan e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep foiny raarav saavits goseen kafof Ya fauf to na puan e Jisas, paapau towan raarav goseen kafof foun, ya fasooiny Towa tan puts te kats ya tan fats. Ya fakukuur to na sen a fats a karap sa bei ot iny yan matainy sobaa tan puts. ");
INSERT INTO sps_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri na muiny Magdala ai Meri tsinan Joses te tagaa te soon fi na puan e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Voun Nainy Fafaatouf tana taa Jiu, Meri na muiny Magdala, ai Meri tsinan Jemis, ai Salome, ri foiny fungan jiaf tauf tsuraf, ser komainy ma nai tsiiu iny ya puan e Jisas. ");
INSERT INTO sps_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tana voinyvoiny ovei te toomat naa ri tana Sande tan vaamuan nan nainy tana wik, ri naa fi to tan puts. ");
INSERT INTO sps_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te taan naa ri, ri vegiau patsukan rato fapoopoan narari, “E sei te fakukuur of rarora na fats tan puts ee?” ");
INSERT INTO sps_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ri matoong naa ton puts ser tagei na fats a karap te kukuur en. ");
INSERT INTO sps_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ri sof koman puts, ser tagei na isen a see tsoiny gum non tan panaainy matou, kaa minon vaun beberus iny jiarasan goseen kafof, ri karian fiisok tsun rato. ");
INSERT INTO sps_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ana see tsoiny tsue of ratuari, “Karian vaare yam, nyo nat you mi sainy rom e Jisas iny Nasaret, to te gageits tana pagafuan. Ayei gima kaa bus non tovei, Ayei te tsun fatabin en! Tagaa yam tana pan te fasooiny ari Ya. ");
INSERT INTO sps_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kuar yam am fafaatai raton matisian Tsunia, fiisen me Pita, ‘Ayei mumua maromi unya Galili, mi te nai tagei Ya na aya, te tsue of fi mami Ya.’” ");
INSERT INTO sps_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sana ri tafuts ser bus osing puts, tana saa ri te oraav ser totoroor er. Ri munmun iny a ka to, ser gima tsue faruak iny ya tan ta mes, tana saa ri te oraav fiisok. ");
INSERT INTO sps_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Vou na tou mat ten Jisas, te toto fatabin Ya tana voinyvoiny ovei tana Sande tan vaamuan nan nainy tana wik, Jisas ruak faamuan ovei ten Meri na muiny Magdala, ayei na moun Jisas te buur ravainy a ina fits a masarau tsunia. ");
INSERT INTO sps_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meri naa sa tsue of rarin vainy ten Jisas, rin vainy te susuiny matan ser tangis. ");
INSERT INTO sps_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Te nongoiny arin vegiau ten Meri, to te kat ya ten Jisas te toto fatabin fi Ya, ai to kan te tagei finy ya Jisas, ri gim to ma faamainy ya. ");
INSERT INTO sps_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Voun a ka to, Jisas ruak sa kat gengen of ir a ina fuan a matisian te taataan fi naa ri sanaan tana gum fan. ");
INSERT INTO sps_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ri tabin me ser fafaatai iny a ka to tsurin mes panainy matisian, sana ri gim kainy to ma faaman rari. ");
INSERT INTO sps_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vou ovei Jisas ruak raton safunuu ana isen a matisian te gum iny ainy ari. Ya peits ratuari, tana saa aaver rari te kio ovei men vaajets. Ana ri vaajets kan iny to na vainy te tagei Ya te toto fatabin fi Ya. ");
INSERT INTO sps_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ya tsue to tsuri, “Kuar yam tana monaagits faavot mi te favaanan iny Vurungan Rof nane Krais tana vainy faavot. ");
INSERT INTO sps_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sei te faaman non ana ya te fapeenan te nai saup fatabin non; san e sei te gim non ma faaman e, vou ayei nai nom non a fasaraa unya Hel. ");
INSERT INTO sps_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Vainy fafaaman mei miror a parits iny faatok to ayei, ri onot ma buur ravainy masarau tana asanga Vanyo; ri nai vegiau fafoofan kan ror tan mes vegiau kanen; ");
INSERT INTO sps_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","te govets rorin koraa ge te jiu rorin amatsuan, gim ror ma kat fiiring rari; ri nai fasaur ror a nimar tan vainy faadis, nai rof fatabin eraror.” ");
INSERT INTO sps_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Te fakap iny vegiau bus a Tsunaun e Jisas fiisen ramiri, Gov nom finy naa Towa Gormirmir Ya gum to tana pan iny fatsiitsii tan nimainy matou ten Gov. ");
INSERT INTO sps_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Rin matisian naa ser favaanan tan fo mamatsiny pan, ana Tsunaun binun fiisen ramituari, ana Ya faparits ton vegiau Tsuan te favaanan iny ari tana parits iny faatok. ");
INSERT INTO sps_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Te naa non tsumanyi, Tsunaun Tiofilas, vainy kinai te kirkir a fo siisio na fo rof tana foka te ruak fapoopoan narara tana tou kaakaa ten Jisas. ");
INSERT INTO sps_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ri kirkir iny a ka na kinai te tsue of rara ri, ito na mes a vainy te tagaa tana foka to aya tan tatanik ser favaanan fatatabin iny vegiau. ");
INSERT INTO sps_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tana ka tsun to aya, nyo tagaa fanatnat bus iny a fo siisio tan fo nainy te naa en to tsonyo faarof iny rou ya tan fakats tsonyo ma kirkir of tsun manyi to na fo mamatsiny ka na fo rof te kat e Jisas muan. ");
INSERT INTO sps_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tana ka to aya, ma nat faarof iny anyi na fo mamatsiny ka te nongoiny bus anyi na fo man. ");
INSERT INTO sps_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tan nainy te Aatouf e Herot tana gum fan iny Judia, ai Sakaraia na tsoiny faakor kaa non tana gum tan tsoiny faakor ten Abija. Ana moun tsunia Elisabet ayei na tsubnaain ten Eron, a tsoiny faakor iny muan. ");
INSERT INTO sps_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri ina fuan toobing tan kat tsuri matan e Gov. Ri natiny vovou faarof iny ror fo Faun tana Tsunaun ana fo mamatsiny ka te tsue iny Ya ma kat. ");
INSERT INTO sps_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ana ri kan a sikia ta guei, tana saa, e Elisabet a visiir to tsunia tobo'an babainy en, ai Sakaraia tsokanei babainy kan enato. ");
INSERT INTO sps_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tan sen nainy ai Sakaraia katkat to na binun tsunia faarei na tsoiny faakor matan e Gov faarei non nainy tsunia iny binun koman a saape. ");
INSERT INTO sps_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Te vovou iny non kat tan tsoiny faakor, to te nom finy ari ya iny kat faakor jiaf tauf tsuraf tan fatsung nan katkat faakor tauf tsuraf koman a saape. ");
INSERT INTO sps_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","To tsunia naa koman a saape tana Tsunaun, ana fokinai faakats er jiarasan tan nainy faakor ma ruak um nan jiaf tauf tsuraf. ");
INSERT INTO sps_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ana morena tana Tsunaun ruak towa, sa tsutsun tan panaainy matou tan fatsung nan katkat faakor tauf tsuraf. ");
INSERT INTO sps_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tan nainy te tagei e Sakaraia na morena ya karian to, ana ya oraav fiisok kan nato. ");
INSERT INTO sps_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sana morena tsue tsunia, “Oraav vaare, Sakaraia, Gov nongoiny faakats tsumanyi ai natsumanyi Elisabet nai kuraa nats non ana ayei te faagiir a guei tsoiny. Te nai koo romi Jon. ");
INSERT INTO sps_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mi nai paparaa ana mamagat mirom ya, ana fokinai kan nai mamagat miror a tou agiir tsunia, ");
INSERT INTO sps_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tana saa, ayei nai karap nats non matan a Tsunaun. Ayei sikia non ma jiu tu wain ge tu mes tu viir jiu te natiny famafuu non. Tabuiny agiir non ya, ayei nai via minon Aaven Taabos. ");
INSERT INTO sps_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ayei nai kopis fatabiny non a vainy Isrel tana Tsunaun e Gov tsuri. ");
INSERT INTO sps_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ayei nai mumua iny non a Tsunaun ana fo kat, ana parits nai kaa minon ya faarei non e Ilaija. Ayei nai kopis non komar taman ana rin guei te nai kaa faavot fatabin ana ayei te nai kat ir vainy fanaginy tsue ma nai kaa fatabin mi rin fakats tu rof tan vainy tavaron. Ayei te kat ir a vainy ma kakoun onot of ari na tou tabin me tana Tsunaun.” ");
INSERT INTO sps_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaraia tsue to tana morena, “Fei te nat fi ronyo na ka to ei? Anyo na tsokanei ana moun tsonyo kan a tobo'an.” ");
INSERT INTO sps_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ana morena biny towa, “Anyo Gebriel. Anyo natiny tsutsun rou matan e Gov, to Tsunia jiat vaminyo ma nai vegiau me tsumanyi, nyo te tsue of manyin vaanan rof to. ");
INSERT INTO sps_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sana nyi sikia ma faamainy vaanan te faan im to te nai ruak iny man nats non vegiau tan nainy fatoobing tsunia. To sana ngue manyi nai tomani non ana nyi te gima nai vegiau nats onots non nainy te agiir non a guei tana saa nyi sikia ma faaman.” ");
INSERT INTO sps_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tan nainy na to aya vainy a kinai te anaanos e Sakaraia, sana ri fapinpin ser tsue, kat fei sa kaa fapotsian en ei koman a saape. ");
INSERT INTO sps_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nainy te tafuts mi ya, ya sikia to ma vegiau tsuri ana vainy nat erato ayei tagei na ka te faarein taraa koman a saape. Ya sikia to ma tsue ta isen ta painy vegiau, ayei te vegiau tsun me na niman tsuri na vainy. ");
INSERT INTO sps_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakaraia tabin to fan te kap nainy tsunia iny binun tana saape. ");
INSERT INTO sps_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Voun a fo nainy, ai Elisabet natsun Sakaraia kuraa bus enato sa gima naus osing a numaa tana ngim a iifaa. ");
INSERT INTO sps_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ai Elisabet tsue to na ka, “Tan fafakap ana Tsunaun faakouts vatuanyo tana sanaan to aya. Ayei nom ravainy a tou rejiaf te visiir fi nyo.” ");
INSERT INTO sps_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet kuraa sa onots a aunom a iifaa, ai Gov faan iny mito na morena e Gebriel tana gum fan iny Galili tana ngats fan te koo ri Nasaret. ");
INSERT INTO sps_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ayei kaa men vegiau tana kooviou na 'aun te us of ari Josep a tsubnaain ten Devit a Aatouf. Ana asangan a kooviou e Meri. ");
INSERT INTO sps_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Morena naa me tsunia sa tsue, “A Tsunaun kaa fiisen mamirom anyi, fiisen men koma rof ana Ayei faparits fiisok en tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri nongoiny a ka to tana morena ana koman ya nun enato sa fapinpin en fei te kat fi non a ka to aya nan ei. ");
INSERT INTO sps_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ana morena tsue to tsunia, “Oraav vaare, Meri, tana saa Gov faarof fiisok tsun marom anyi. ");
INSERT INTO sps_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nyi kuraa nats rom, ana nyi te faagiir a guei tsoiny, nyi te nai koo ya Jisas. ");
INSERT INTO sps_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ayei nai karap non, ri te nai koo ya na Guei Tsoiny tana Gov a Tsigtsig Fiisok. E Gov a Tsunaun nai fa'atouf non Ya a faarei to Devit a tsuvun Ya. ");
INSERT INTO sps_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ai te nai aatouf kan ir tsubnaain ten Jekop a kaa suu, ana Waan Ya na sikia ta fafakap.” ");
INSERT INTO sps_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri tsue to tana morena, “I fei te kat fi non a ka to aya ei, anyo na 'aun!” ");
INSERT INTO sps_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ana morena tsue to ten Meri, “U Aaven Taabos naa minon tsumanyi, ana parits ten Gov te nai kaa me tsumanyi. Tana ka tsun to aya a Guei a Taabos nai koo rori na Guei Tsoiny ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nongon, e nuatsi manyi Elisabet nai kaa minon a guei to te tsue ri ayei na visiir sa tobo'an kanen, san kuraa tsunia te nom bus a aunom a iifaa, ");
INSERT INTO sps_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","tana saa, e Gov te onot non ma kat a fo mamatsiny ka.” ");
INSERT INTO sps_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ai Meri tsue to tana morena, “Anyo na muiny binun tana Tsunaun. Kat ma ruak ya tan tsue tsumanyi,” te tsue fi Meri. Ana morena naus osing towa. ");
INSERT INTO sps_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tan nainy na to aya, Meri kakoun to sa veesau tsun nanaa tana ngats fan tan tet tana gum fan iny Judia. ");
INSERT INTO sps_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ya naa to sa sof koman a numaa ten Sakaraia, sa tsue iny paparaa tsunia ten Elisabet. ");
INSERT INTO sps_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nainy te nongoiny e Elisabet tsue iny paparaa ten Meri ana guei koman e Elisabet kunik nato, ai Elisabet via miton Aaven Taabos. ");
INSERT INTO sps_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabet vaputs sa tsue, “Gov faparits marom anyi fis non moun faavot, ana guei kan te nai faagiir rom anyi Gov faparits non Ya! ");
INSERT INTO sps_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Anyo na saa, sana ka na karap to ruak tsonyo, to tana tsinan a Tsunaun tsonyo nai nak vaminyo? ");
INSERT INTO sps_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tagaa! Tan nainy te nongoiny anyon tsue iny paparaa tsumanyi tsonyo ana guei koma vanyo kunik miton mamagat. ");
INSERT INTO sps_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gov faparits bus manyi te faamainy fi nyi na ka te tsue na Tsunaun te nai ruak iny man nats non tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Ai Meri tsue to: “Koma vanyo te variri non a Tsunaun; ana aave vanyo mamagat minon e Gov a Tsoiny Fiisaup tsonyo, ");
INSERT INTO sps_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","tana saa Ayei te fakats vanyo na muiny binun babainy Tsunia. Te onot non roman a vainy tana fo aatai, nai koo varonyo na muiny paparaa, ");
INSERT INTO sps_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tana saa, a Gov a Reits kat a ka na karap fiisok tsonyo. A asangan Ya na taabos. ");
INSERT INTO sps_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Te faatok iny a tagtag tsuri te natiny oraav ror Ya, tanik me tan tatanik nan aatai ai te naa kan naa tan mes aatai. ");
INSERT INTO sps_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ayei faatok iny a parits Tsunia fiisen me na niman a reits Tsuan, sa vavakas ir a vainy sarakouts a tsivor tana fo fakats tsuri. ");
INSERT INTO sps_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ayei te fauf ir gotouf siireits tana fo tagan tsuri, Ya fapaas ratuari te fauf a tsivor. ");
INSERT INTO sps_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ya faasom ratuari te kainy ves ror tana foka na fo rof, Ya jiat ravaa raton vainy masun fiisen men na nimar babainy. ");
INSERT INTO sps_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jesan tsun non tan tsuen man Tsunia tan tsuvurara, Ayei te faakouts ir a taa Isrel, vainy binun Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ayei gima anofe ma faatok iny a tagtag Tsunia ten Abraham an fo tsubnaain tsunia tan mamatsiny nainy a sikia ta fafakap nan.” ");
INSERT INTO sps_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri kaa fiisen me Elisabet tana fopis a iifaa toroman, vou ya tabin to fan tsunia. ");
INSERT INTO sps_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Te ruak bus nainy iny faagiir ten Elisabet a kukurik ya faagiir to na guei tsoiny. ");
INSERT INTO sps_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","U fifakokoro tsunia an nuatsin ya nongon to tana ka na rof fiisok te faatok a Tsunaun e Elisabet, ana ri na fokinai mamagat fiisen mi towa. ");
INSERT INTO sps_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nainy te karap a guei, sa onots jian nainy ri mei to na guei ma kat vaapee ri ya tana Faun te kirkir iny e Moses ana ri te koo ya Sakaraia a asangan e taman ya. ");
INSERT INTO sps_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sen tsinan ya tsue, “Sikia! A asangan te koo romi ya e Jon.” ");
INSERT INTO sps_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ana ri tsue to ten Elisabet, “A sikia koraa ta nuatsi manyi ma fikoo iny a asangan to aya.” ");
INSERT INTO sps_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ana ri vegiau of to taman ya tana nimar rangats ari tan ta saf ta asangan te komainy non ya na ma kaa me na guei. ");
INSERT INTO sps_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaraia rangat iny to ta painy pepa, sa kirkir, “A asangan ya Jon.” Ana fokinai karian faavot erato. ");
INSERT INTO sps_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sen tsun ai Sakaraia vegiau fatabin bus enato sa tanik iny variri Gov. ");
INSERT INTO sps_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","An fifakokoro tsunia saar fiisok towa, an vaanan saats faavots ton tet tana gum fan iny Judia. ");
INSERT INTO sps_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ana fokinai to te nongon, fakats to komar, ser rangat iny ya, “Te nai kat fi nats non a guei to ei?” Te nat fi ror nei, a parits ten Gov kaa non tsunia. ");
INSERT INTO sps_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakaraia, taman a guei via men Aaven Taabos, sa pokei iny vegiau ten Gov, sa tsue, ");
INSERT INTO sps_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ara ma variri na Tsunaun, a Gov tana taa Isrel! Ayei te naa me ma pats Ya na tou tapuruur nar vainy Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ayei te faan iny me na Tsoiny Fiisaup a reits tsura, ana Ayei na tsubnaain ten Devit a tsoiny binun tana Tsunaun, ");
INSERT INTO sps_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ito te tsue fi Ya nguer kuigin taabos muan: ");
INSERT INTO sps_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ayei kat tsuen man iny saup rara nimar vainy te koma iring rarora ana Ayei te nom rara osing parits tan vainy te tsugei rarora, ");
INSERT INTO sps_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","faatok iny non a tagtag tan tsuvurara, ana Ayei te sikia ma soropaar vegiaun man tan tsue faunot taabos Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Gov kat tsuen man men tsue man non jias tana tsuvurara Abraham, tan fious rara nimar vainy te koma iring rarora ma tanyi rara ma binun ara Tsunia gima fiisen me na oraav, ");
INSERT INTO sps_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tan kaa faarei a mes a tavaron ana taabos matan Ya tan mamatsiny nainy tana toto tsura. ");
INSERT INTO sps_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Ana nyi, guei tsiau, ri nai asang marom anyi na kuigin tana Gov a Tsigtsig Fiisok, tana saa, nyi nai mumua iny rom a Tsunaun, ma kakoun onots of Ya na sanaan Tsunia, iny fanat of rari na vainy Tsunia, Ya te saup fatabin rara, tan anofe ravainy fo aveto tsura, ");
INSERT INTO sps_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","tana saa, a Gov tsura na fifaakouts ana fifatagtag, sa faan iny me naa Tsunaun poo fi me Gormirmir ma nang me tsura faarei na nuaf, ");
INSERT INTO sps_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","a arasan nan ya nai nang naa non tsuri te kaa ror tana uurup ito na vainy te kainy mat ror tan aaven, Ya te ras fatoobing fi ra naa ra tana sanaan a aaverof.” ");
INSERT INTO sps_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A guei to aya, karap non puan ya ana aaven ya kan kaa minon a parits. Ya te kaakaa tana pan a uur, onots non nainy te ruak non ya matar a vainy faavot iny Isrel. ");
INSERT INTO sps_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tan nainy to aya Sisa Ogastas fakei na faun ma fagum asangan a fokinai tana tou gumgum tana Roum. ");
INSERT INTO sps_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ayein vaamuan nan nainy iny fagum asangan te gavana Sairinias tana gum fan iny Siria. ");
INSERT INTO sps_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A fokinai te naa fatabin fi naa tana fo ngats fan tan fo tsuvurari iny fagum asangan. ");
INSERT INTO sps_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep te naa, poo tana ngats fan iny Nasaret tana gum fan iny Galili sa naa fi naa tana gum fan iny Judia to te agiir e Devit a Aatouf tana ngats fan te koo ri Betlehem, tana saa, ayei na tsubnaain e Devit. ");
INSERT INTO sps_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ayei te naa na aya, a tou fagum asangan fiisen me Meri to te kat arin tsuen man ma fanging ya Josep ana ayei kaa men kuraa. ");
INSERT INTO sps_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ari kaa raror na aya, an nainy faagiir tsunia kakoun en. ");
INSERT INTO sps_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ana ayei faagiir to na vaamuan tsunia, a guei tsoiny. Ya paapau Towan raarav sa fasooiny Ya tana gen iny ainyainy tan bulumakau, tana saa, a sikia ta pan iny kaa tsuri, a fo numaa te via tsup en. ");
INSERT INTO sps_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tana voiny tsoiny veis te tatagaa ot ir siip tana aufing a wuwiir gima veevian tana ngats fan. ");
INSERT INTO sps_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ana morena tana Tsunaun ruak ratuari an siinaiv tana Tsunaun kanaf faafis ratuari ri oraav erato. ");
INSERT INTO sps_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sana morena tana Tsunaun tsue of rari, “Oraav vaare yam, nyo mei men vurungan rof te kat famamagat fatsian raror a vainy a kinai. ");
INSERT INTO sps_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Roman, tana ngats fan ten Devit a Aatouf, a Tsoiny Fiisaup tsumi te agiir en, Ayei na Krais, a Tsunaun, ");
INSERT INTO sps_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","A ka te nai faatok maromi tovei, ami nai sab rom a kukurik te paapau arin raarav sa soon non tana gen iny ainyainy tan bulumakau.” ");
INSERT INTO sps_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sen tsun an vavarioiny morena iny Gormirmir ruak fiisen mito na morena, variri me Gov ser tsue, ");
INSERT INTO sps_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Vamarits ror a asangan e Gov a tsigtsig jias ovei, ai nei petoo tana vainy Gov rof rarori, ri kaa miror a aaverof.” ");
INSERT INTO sps_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nainy te naus osing rarin morena ser tabin fi naa Gormirmir, an tsoiny veis favevegiau to fapoopoan narari, “Jio, tanats yam naa ra Betlehem ma tagaa ra tana ka tovei te ruak ito te tsue of rara na Tsunaun.” ");
INSERT INTO sps_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ri kat veveesau ri naa to ser sab e Meri me Josep, ana kukurik soon non tana gen iny ainyainy tan bulumakau. ");
INSERT INTO sps_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nainy te tagei ari Ya, ri siisio iny ton vurungan tana kukurik te tsue of rari na morena. ");
INSERT INTO sps_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","A fokinai to te nongon tana saa te tsuen tsoiny veis tsuri na, ana koma rari saar fiisok rato. ");
INSERT INTO sps_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meri makuts a foka to sa fafakats patsukainy ya. ");
INSERT INTO sps_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tsoiny veis tabin fatabin naa, ri vamarits ana ri variri to Gov tana saa te nongoiny ari, ana foka te tagei ari te faarei tsuiny te tsue of fi rari na morena. ");
INSERT INTO sps_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tan fajian nan nainy, nainy te vaapee ri Ya, ri koo Towa Jisas, a asangan te faan iny a morena ana Ya tabuiny ma ruak iny guari koman e tsinan. ");
INSERT INTO sps_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Te ruak nainy tsuri iny kat faakor iny fataabos e Meri te tsue fi ya tana Faun te kirkir iny e Moses, ai Josep me Meri mei naa to na guei tsoiny unya tana ngats fan tsian iny Jerusalem ser faan iny Ya tana Tsunaun, ");
INSERT INTO sps_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","te vovou iny ror te kirkir fi non ya tana Faun tana Tsunaun: “Muinymataa ma faan iny a vaamuan nan a guei tsoiny tsuri tana Tsunaun.” ");
INSERT INTO sps_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","An tan faan iny fifaan tan kat faakor tana guei tan kat iny makuts a ka te tsue iny a Faun tana Tsunaun, “a fuan a Baanus ge na fuan a tsunei Kuusia.” ");
INSERT INTO sps_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tan nainy to aya, a mes te kaa tana ngats fan tsian iny Jerusalem te koo ri Simion, ayei na mes a tavaron ana man matan e Gov. Ayei te anaanos a mes iny saup a taa Isrel a kat famaun to na koma rari. U Aaven Taabos te tutuei Ya. ");
INSERT INTO sps_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aaven Taabos faatok Ya, ayei gim non ma mat, onot non te tagei finy non ya na Krais a Tsunaun. ");
INSERT INTO sps_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","An Aaven Taabos mei finy to Simion koman a saape. Muinymataa mei naa na kukurik e Jisas ma faan iny ari Ya tana Tsunaun vovou iny ror Faun, ");
INSERT INTO sps_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","te tagei ya na guei, Simion govets Towa sa fijapou mi Ya niman sa tsue faonot to iny faparits e Gov, ya tsue to: ");
INSERT INTO sps_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Fafaonot nan, Tsunaun, Nyi makuts tsuen man Tsuam, tanyiny sa Nyi na tsoiny binun Tsuam ma mat fiisen mi Ya na aaverof. ");
INSERT INTO sps_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nyo tagaa fatoobing iny a matau tana Tsoiny Fiisaup, ");
INSERT INTO sps_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","te kakouiny Anyi ma ruak matar a vainy faavot. ");
INSERT INTO sps_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ayein sen kurun iny faan iny a arasan tana vainy sikia ma taa Jiu, Ya te faan iny siinaiv man tana vainy Tsumanyi na taa Isrel.” ");
INSERT INTO sps_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E taman Ya me tsinan Ya te saar tana foka te tsue iny e Simion tana guei. ");
INSERT INTO sps_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ai Simion tsue faonot to iny faparits rari, ya tsue to ten Meri, tsinan Ya, “A guei to te bobot e Gov nai rurei non a fokinai vainy iny Isrel, ge saup non fokinai vainy iny Isrel. Ana Ayei nai faatok rarori Gov, sana fokinai te nai tsugei pakaa ror Ya, ");
INSERT INTO sps_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","san fakats iring tana fokinai nai kaa non tana arasan. An reesik faarei non kirat iny puaan nai ots non a aave manyi tsivom.” ");
INSERT INTO sps_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Anna, na muiny kuigin, a guei moun ten Panuel tana vun ten Asa, a tobo'an, a fanging sa kaa fiisen me natsioiny tana fits a ingainy. ");
INSERT INTO sps_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ayei na amov, an ingainy tsunia onots jian safunuu ana fats a ingainy, gima naus osing a saape, te kaa iny faatouf e Gov, an tavtaav fiisen men faakats tan voiny min nuaf. ");
INSERT INTO sps_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ayei naa me tsuri tan nainy to aya, ya faarof iny to Gov, ana ayei tsue of ratuari na fokinai siisio nana guei te anaanos rori, ma saup fatabin Ya na tou tapuruur nar taa Jerusalem. ");
INSERT INTO sps_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nainy te fakap ari na fo mamatsiny ka te tsue fi na Faun tana Tsunaun, ana ri tabin to tana gum fan iny Galili tana ngats fan tsuri iny Nasaret. ");
INSERT INTO sps_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A guei te karap, Ya via mito na nat a rof an koma ree'un ten Gov kaa to Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mamatsiny ingainy taman Jisas me tsinan Ya natiny naa ror tana ngats fan tsian iny Jerusalem tan Guainy iny Fakats Fatabin nainy te faakouts e Gov fo tsuvurari ser naus osing me na Ijip. ");
INSERT INTO sps_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nainy te safunuu ana fuan a ingainy Ya, ri fiisen me Jisas naa to tan guainy te natiny kat fi rori. ");
INSERT INTO sps_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Te kap nainy tana kainy ainy ri tabin to fan tsuar sana vurots, e Jisas kaakaa fatabin en Jerusalem. Taman Ya me tsinan Ya gima natiny a ka to. ");
INSERT INTO sps_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ri pon iny Ya te kaa non tana gum, to ser naa patsukaner ra naa tan nainy to aya, ri kat to ser tanik iny tsikoo Ya fapoopoan nar nuatsi rari an vaatau tsuri. ");
INSERT INTO sps_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nainy te gima sab ari Ya, ri kat to ser tabin Jerusalem a tou tsikoo Ya. ");
INSERT INTO sps_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tan fafofopis nan nainy, ri sab Towa koman a saape gum fiisen ramirorin tsoiny fifaatsuts tana taa Jiu, vanongon non tsuri, Ya rangat en. ");
INSERT INTO sps_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ri na vavainy te nongon Tsunia te biny fi Ya na fo rangat fiisen me na nat Tsunia, ri saar Towa. ");
INSERT INTO sps_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nainy te tagei ari Ya ere taman Ya me tsinan Ya ri ngian iny Towa sen tsinan Ya tsue of Ya, “Guei tsiau, kat fei Tsumanyi kat kat to tsumam ei? E tamamanyi ana nyo reesik fiisok tan tsikoo manyi.” ");
INSERT INTO sps_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ya biny ratuari, “Kat fei to tsumi tsikoo vanyo ei? Mi gim rom ma nat, Anyo ma kaa koman a numaa ten Tamanyo?” ");
INSERT INTO sps_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sana ri gima arasan fanatnat iny a ka te tsue of rari Ya. ");
INSERT INTO sps_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kat to, ai Jisas tabin fiisen ramituari Nasaret te nongoiny tsue tsuri Ya manaats ratuari. Tsinan Ya nom a fo vegiau to sa makuts ya koman. ");
INSERT INTO sps_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas karap iny mes me an nat a rof kaatsian mito, ai Gov paparaa mi Towa ana vainy kan. ");
INSERT INTO sps_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","E Sisa Taibirias te gum iny aatouf sa onots safunuu ana ngim a ingainy tan nainy te gavana Pontias Pailat tana gum fan iny Judia; ai Herot a gavana tana gum fan iny Galili; ai famuinyasiny tsunia Pilip a gavana tana fuan a gum fan Ituria ai Tarakonis; ai Laisanias a gavana tana gum fan iny Abilene. ");
INSERT INTO sps_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","An tan nainy to aya, Anas me Kaiafas arin Tsoiny Mumua tan Tsoiny Faakor, an vegiau ten Gov ruak to ten Jon, a guei ten Sakaraia tana pan a uur. ");
INSERT INTO sps_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ya taainy to na fo pan tana aurom iny Jodan, sa favaanan, ya tsue to, “Faonot yam, mi reesik to am takopis osing to na fo aveto tsuam, ana mi te tap naa ten Gov, tana ka to aya Gov nai anofe ravainy non a fo aveto tsumi, anyo te nai peenainy mami.” ");
INSERT INTO sps_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Faarei kainy non to te kirkir bus iny Aisaia na kuigin muan sa tsue na ka, “A isen te vegiau fabaasuan me koman a pan a uur, ‘Kakoun onots of yam a Tsunaun a aavem, mi te vatsvats of Yan kat tsuam ma faarei ya na sanaan iny naa me Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A fo govee ma tafun, ana fo tet an tobeer ma fatoobing, a fifaanauti to. An sanaan geegio vavis ma fatoobing. ");
INSERT INTO sps_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ana fokinai nai tagei ror a binun iny fiisaup ten Gov.’” ");
INSERT INTO sps_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ana fokinai ruak mito, a tou peenan ten Jon, sana ri tabuiny ma pokein na fo aveto tsuar, ya tsue to tsuri, “Amin guei tan koraa! Tana tou peenan, mi pon fi rom nei, mi onot rom ma fataanis osing koma seeve ten Gov to te naanaa minon? ");
INSERT INTO sps_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kat yam kat to te onot iny faatok maromi mi te takopis osing bus fo aveto tsuam, ana nyo te see fapeenainy mami. Am tanik iny tsue fi vaare to nei fapoopoan namami, ‘Gov gim non ma fasaraa mamam, tana saa Abraham ayei na tsuvumamam.’ Nyo tsue of maromi, Gov onot non ma nom marats to, Ya te kopis rari er faarei miton tsubnaainy ten Abraham! ");
INSERT INTO sps_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ami faarei rom nau, ana fo nau gim ror ma fua tu fua tu rof nai rop ravaa ror er faakor ravaa to tan guaf. Gov kakoun en tan kat, kat to tsumi” ");
INSERT INTO sps_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ana vainy rangats towa, “Ana mam te nai kat fei?” ");
INSERT INTO sps_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ana ayei biny ratuari, “E sei te kaa minon fuan vau ee, ayei ma faan iny sen tana mes a sikia, ai sei te kaa minon a kainy ainy ee, ayei ma tatafas iny ya.” ");
INSERT INTO sps_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mesapan tsurin tsoiny nonom takis nai peenan me, ser rangats ya, “Tsoiny fifaatsuts a saa te kat romam na?” ");
INSERT INTO sps_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ya tsue of ratuari, “Ami ma nom takis, sana mi ma nom fapaas pis vaare.” ");
INSERT INTO sps_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mesapan tsurin tsoiny puaan rangats towa, “Amam paas? Sa kat romam na?” Ya tsue to tsuri, “Kat fiiring vaare ir yam a mes a vainy, am kabuts vaare to na moni ana mes a foka tsuri, am kat vaare ton vaatsuk gam. Sana ami ma nom faonot tsun te nonom fi romi am paparaa mito na foiny tsumi.” ");
INSERT INTO sps_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A vainy te tagaa fi nei an fakats iny naano tsun to, ser fakats vavis iny e Jon, ser pon fi nei, ayei toroman na Krais, a Tsoiny Fiisaup. ");
INSERT INTO sps_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon biny ratuari na fokinai, “Anyo peenainy maromi tana aurom, sana Ayei te karap fafisfis varonyo te naa minon, nyo gima onot faarof iny puruur a patom nan su Tsunia, Ayei nai peenainy maromi tan Aaven Taabos an guaf. ");
INSERT INTO sps_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ayei faarei non a taman tan tanun wit nom iny non a fok niman ka iny kat ravainy nungan nan wit ana ayei te nai guam wit ya te fakei naa ya tana numaa iny fatamaar ana ya te nom nungan ya te nai ravainy ya tan guaf to te gim non ma natiny mote.” ");
INSERT INTO sps_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon kat a fo vegiau parits iny kopis a komar a vainy, ai tan kat to aya, ayei dadaav iny Vurungan Rof tsuri. ");
INSERT INTO sps_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ai Jon tsue ets'ets of to Gavana Herot matan ya, tana saa, ayei te fipisui me Herodias a moun ten famuinyasiny tsunia ana fo mes a fo kat iring te kat ya. ");
INSERT INTO sps_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tan kat to aya Herot kat pis mes kat iring tsian tan fasof e Jon a Tsoiny Fapeenan tana numaa iny kotskots. ");
INSERT INTO sps_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nainy te peenan a fokinai ai Jisas peenan kan to. Ayei faakats enanon ana korosuu tapue to, ");
INSERT INTO sps_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","an Aaven Taabos of mito Tsunia faarei na kurume. An sen vegiau poo mito Gormirmir, “Anyi na Guei Tsoiny Tsonyo, te kaa non koman Tsonyo, Nyo koma rof marom Anyi.” ");
INSERT INTO sps_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas te karap sa onots toromainy fopis safunuu na ingainy vou Ya tanik to na binun, Ayei na guei tsoiny faarei te fakats fi na vainy Ayei na guei ten Josep, ai Josep a guei ten Eli, ");
INSERT INTO sps_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ai Eli na guei ten Matat, ana ayei na guei ten Livai. Livai na guei ten Melki, ai Melki na guei ten Janai, ai Janai na guei ten Josep. ");
INSERT INTO sps_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ai Josep a guei ten Matatias, ai Matatias a guei ten Amos. Amos a guei ten Neiam, ai Neiam a guei ten Esli. Esli na guei ten Nagai. ");
INSERT INTO sps_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ai Nagai na guei ten Maat, ai Maat a guei ten Matatias. Matatias a guei ten Semein ana ayei na guei ten Josek, ai Josek a guei ten Joda. ");
INSERT INTO sps_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda na guei ten Joanan, ai Joanan a guei ten Resa. Resa na guei ten Serababel, ai Serababel a guei ten Silatiel. Silatiel a guei ten Neri, ");
INSERT INTO sps_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ai Neri na guei ten Melki, e Melki na guei ten Adi, ai Adi na guei ten Kosam. Kosam a guei ten Elmadam. Ai Elmadam, ayei na guei ten Er. ");
INSERT INTO sps_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er a guei ten Josua, ai Josua na guei ten Eliesa. Ai Eliesa na guei ten Jorim. Jorim a guei ten Matat, ai Matat a guei ten Livai. ");
INSERT INTO sps_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai na guei ten Simion, ai Simion a guei ten Juda. Juda na guei ten Josep, ai Josep a guei ten Jonam. ");
INSERT INTO sps_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Jonam a guei ten Eliakim ana ayei na guei ten Melea, ai Melea na guei ten Mena. E Mena na guei ten Matata, ai Matata na guei ten Natan, ai Natan a guei ten Devit. ");
INSERT INTO sps_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit a guei ten Jesi, ai Jesi na guei ten Obet. Obet a guei ten Boas, ai Boas a guei ten Salmon. Salmon a guei ten Nason. ");
INSERT INTO sps_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason a guei ten Aminadap, ai Aminadap a guei ten Atmin. Atmin a guei ten Arni, ai Arni na guei ten Esron, ai Esron a guei ten Peres, ai Peres a guei ten Juda. Juda na guei ten Jekop, ");
INSERT INTO sps_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ai Jekop a guei ten Aisak. Aisak a guei ten Abraham ai Abraham a guei ten Tera. Tera na guei ten Neior, ai Neior a guei ten Seruk. ");
INSERT INTO sps_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruk a guei ten Reu, ai Reu na guei ten Pelek. Pelek a guei ten Eber, ai Eber a guei ten Sela. ");
INSERT INTO sps_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela na guei ten Kainan, ai Kainan a guei ten Afaksat. Afaksat a guei ten Siem, ai Siem a guei ten Noa. Noa na guei ten Lemek. ");
INSERT INTO sps_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek a guei ten Metusela, ai Metusela na guei ten Inok. Inok a guei ten Jeret, ai Jeret a guei ten Mayalali, ai Mayalali na guei ten Kainan. ");
INSERT INTO sps_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan, ayei na guei ten Enos, ai Enos a guei ten Set, ai Set a guei ten Adam, Adam a guei ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisas via men Aaven Taabos te tabin mi Ya tana aurom iny Jodan an Aaven Taabos mei naa Towa tana pan a uur ana nang iny nuaf. ");
INSERT INTO sps_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ya kaa to onots fats safunuu nainy te amus Ya na Vinasaar. Ya gim to ma ainy, voun a fo nainy to aya, Ayei ves to. ");
INSERT INTO sps_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ana Vinasaar tsue to Tsunia, “Ayei na Guei Tsoiny ten Gov, tsue of a fats to ma ruak iny koinykoiny mi ya.” ");
INSERT INTO sps_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas biny towa, “Te kirkir en tan Vegiau Ten Gov, ‘Mes te gim non ma toto ising tan koinykoiny tsun.’” ");
INSERT INTO sps_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ana Vinasaar mei fi naa Towa tana pan a nai tsig, sen tsun ana Vinasaar faatok Towa na fo mamatsiny waan nana monaagits to. ");
INSERT INTO sps_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ana ayei tsue to Tsunia, “Nyo nai faan marom Anyin fo mamatsiny parits tsuri ana masun, tana saa fo mamatsiny ka faavot te faan vanyo Gov to tsonyo onot rou ma faan rari tan ta mes tan mangiir tsonyo. ");
INSERT INTO sps_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sana Anyi ma fatukun Nyi te tsunguruu iny faatouf vanyo, ana fo mamatsiny ka tovei nai fasito iny rom Anyi.” ");
INSERT INTO sps_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas biny towa, “Te kirkir en tan Vegiau Ten Gov, ‘Faatouf a Tsunaun a Gov tsuam ana nyi te vovou tsun iny mangiir Tsunia!’” ");
INSERT INTO sps_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ai Vinasaar mei fi naa Towa tana ngats fan tsian Jerusalem sa fatsutsuiny Ya tana pan a nai jias fiisok tana saape, ya tsue to Tsunia, “Anyi na Guei Tsoiny ten Gov, tsiak fi naa putaa osing a pan to, ");
INSERT INTO sps_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tana saa, te kirkir en tan Vegiau Ten Gov, ‘Gov nai tsue of non morena Tsuan ma koup Manyi ri, ri te tagaa ot faarof Manyi.’ ");
INSERT INTO sps_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ana, ‘Ri kan nai nom tap marom Anyi nimar ma tageev on vaare na moum Manyi tan ta fats.’” ");
INSERT INTO sps_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisas biny towa, “San Vegiau Ten Gov tsue kainy a ka, ‘Nyi ma tanaf vaare na Tsunaun a Gov tsuam.’” ");
INSERT INTO sps_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nainy te faonot a Vinasaar tan amus e Jisas, ya naus osing tsom Towa onot te sab non ya tu mes tu nainy. ");
INSERT INTO sps_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ai Jisas fatabin fi to tana gum fan iny Galili ana parits tan Aaven Taabos kaa fiisen mi Towa an vaanan nan Ya saats faafis to na gum fan. ");
INSERT INTO sps_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ya fifaatsuts to tana numaa iny fafaatouf tana taa Jiu ana fokinai fapaas to na asangan Ya. ");
INSERT INTO sps_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ya naa fi to tana ngats fan iny Nasaret tana pan te karap Ya, ai tan Nainy Fafaatouf tana taa Jiu, Ya naa to tana numaa iny fafaatouf tsuri faarei te natiny kat fi non Ya. Ya tsun to sa gogosias vegiau tan Vegiau Ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","U kots noun tana kuigin e Aisaia te fanom ari Ya. Ya karats towa, sa sab a pan te kaa non kirkir te tsue na ka, ");
INSERT INTO sps_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“U Aaven tana Tsunaun te kaa non Tsonyo, tana saa, Ayei te pisainy Vanyo ma favaanan iny Vurungan Rof tsuri te aaruts ror. Ya jiat Vamituanyo ma pokei a tou tapuruur tsuri te kaa iny kotskots ror; ai tsurin matar kio ma matoong fatabin ari ai tan nom fatafuts ir vainy te kaa ror fain nimar vainy te kat fifiiring rari. ");
INSERT INTO sps_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ai tan favaanan iny a ingainy te kat non a Tsunaun, a rof Tsunia tana vainy te fasito iny non Ya.” ");
INSERT INTO sps_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ai Jisas tap ton kots noun ya faan fatabin iny towa tana mes te natiny kat non a binun tan fafaan iny kots noun Ya gum fatabin to. Ana fokinai koman a numaa iny fafaatouf tana taa Jiu suu iny to na matar Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ana Ya tsue to tsuri, “Roman u vegiau tan Vegiau Ten Gov te nongoiny ami te ruak iny man ovei en.” ");
INSERT INTO sps_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A fokinai saar iny men vegiaun saavits fiisok te pokei Ya. Ana ri fararangat to, “Ayei koraa na guei tsoiny ten Josep?” ");
INSERT INTO sps_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ai Jisas tsue to tsuri, “U man, mi nonom naa rom vegiau te kat a vainy Tsonyo: ‘Sana nyi na Tsoiny Tsipaar, anyi ma tsipaar a tsivom.’ Ami nai tsue Vanyo, ‘Anyi ma kat ya nei tana ngats fan tsuam to na foka te kat Anyi tana ngats fan Kapeniam te nongon fi mam.’ ");
INSERT INTO sps_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nyo tsue faman of maromi,” Ya farong pis towa, “a vainy tana ngats fan fatoobing tana kuigin te sikia ror ma nat faarof iny Ya ge nongoiny Ya. ");
INSERT INTO sps_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nyo tsue faman rou tsumi te man non u amov kinai iny Isrel tan nainy ten Ilaija na kuigin muan te sariof a ruat sa onots a fopis a ingainy ana aunom a iifaa. Nainy ves tsian sa nom faavots a fan a kinai. ");
INSERT INTO sps_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gov faan iny naa Ilaija sai te gima naa of naan vainy fatoobing tsunia, san tana amov a sikia ma taa Jiu tana ngats fan iny Serefat tana gum fan iny Saidon. ");
INSERT INTO sps_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“A vainy a kinai iny Isrel kaa men tatauba tan nainy ten Ilaisa na mes a kuigin iny muan. Gov faan iny naa Ilaisa, sana sikia ta isen tsuri ma taabos Neaman tsun a isen a sikia ma taa Jiu a mes tana gum fan iny Siria.” ");
INSERT INTO sps_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A vainy koman a numaa iny fafaatouf tana taa Jiu kaa men koma peits te nongoiny arin tsue to. ");
INSERT INTO sps_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ri tsun faavot ri ras tsitsikap to Jisas ser fatafuts osing Ya na fan tsian ser mei finy naa Ya patsun tet tana pan te fatsuiny arin fan tsian ma tsug fajiak iny naa ri Ya tana varian ");
INSERT INTO sps_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","sana Ayei taan patsukan nanaa fapoopoan nara fokinai sa nai nanaa. ");
INSERT INTO sps_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ai Jisas taan fi naa to tana ngats fan iny Kapeniam tana gum fan iny Galili, Ayei faatsuts rato na vainy tan Nainy Fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ri saar tana sanaan to te fafaatsuts fi Ya tana saa, u vegiau Tsunia te kaa me na parits faarei non a mes te fa'asangan non tan gumgum. ");
INSERT INTO sps_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Koman a numaa iny fafaatouf tana taa Jiu na aya, te kaa me na mes a tutuei iny masarau rorojiainy iny men kuu tsian, ");
INSERT INTO sps_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Poo! A saa te komainy kat rom Anyi tsumam na, O Jisas iny Nasaret? Nyi of me naa tou ruraa mamam? Anyo nat marom Anyi, Anyi na Mes a Taabos poo fi me ten Gov!” ");
INSERT INTO sps_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisas tsue ets'ets ton masarau, “Tomani, nyi te tafuts osing a mes tovei!” An masarau fagotsiny to na mes peto matar a fokinai ya tafuts osing towa sa gima kat fiiring ya. ");
INSERT INTO sps_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ana ri na fokinai saar fiisok Towa ser favevegiau patsukaner, “Saf a fo vegiau to aya nan na? Te faarei non a mes te fa'asangan non tan gumgum ana parits to Tsunia tsue faparits iny fataanis tan masarau to ser tafuts!” ");
INSERT INTO sps_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","An vaanan nan Ya saats vavis to na ngats fan faavot tana gum fan iny Galili. ");
INSERT INTO sps_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas naus osing a numaa iny fafaatouf tana taa Jiu sa naa fi naa numaa ten Saimon. E nuan e Saimon a faadis, faadis minon a puan a fisikii tsian, ser sing e Jisas ma faakouts ya. ");
INSERT INTO sps_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ya naa to sa tsutsun panan a fetan tsunia, Ya tsue ets'ets of to na faadis naus osing a moun to. Sen tsun ana fisikii naus osing towa, ya tsun to sa kakoun of ratuari na kainy ainy. ");
INSERT INTO sps_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Te ananerof bus en te ruk nana nuaf ana vainy te kaa men nuatsir te kaa men fo viir faadis vavis atoiny ramituari ten Jisas sa fasaur a niman tan isiseiny mes ana ri na fokinai tsipaar faavot rato. ");
INSERT INTO sps_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ai Jisas buur ravainy raton masarau tana vainy a kinai ai te kat iny tafuts ari ri rorojiainy men kuu tsian, “Anyi na Guei Tsoiny ten Gov!” Jisas tsue ets'ets ratuari, sa gima famanat rari ma tsue ri ta ka, tana saa, ri nat er Ayei na Krais, a Tsoiny Fiisaup. ");
INSERT INTO sps_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te takiir me na nainy, ai Jisas naus osing to na ngats fan, sa naa naa tana pan a tomani Ayei Tsivon. Ana vainy tanik i tsikoo Towa ai te sab ari na pan te kaakaa Ya ri tanaf iny kat Towa ma naus osing vaare rari. ");
INSERT INTO sps_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sana Ayei tsue na ka tsuri, “Anyo ma favaanan iny Vurungan Rof nana Waan e Gov tana fo mes a fo ngats fan kan tana saa, ayei na ka te jiats of Vaminyo Gov ma kat Anyo.” ");
INSERT INTO sps_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ana Ayei favaanan to koman a fo numaa iny fafaatouf tana taa Jiu sa pot faafis a gum fan iny Judia. ");
INSERT INTO sps_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tan sen nainy Jisas tsutsun to moun poporos nana naaman iny Genesaret fiisen me na vainy a kinai, u tagin fasoksok nai vanongon Tsunia tan vegiau ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ayei tagein fuan puak te fasung tsoiny nawaan moun poporos ser naus osing ya ri gainygainy ton muav. ");
INSERT INTO sps_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas jias to tan puak u puak ten Saimon Ya rangats towa ma tsug fakovoo vaarik na ya. Jisas gum tan puak Ya faatsuts raton tagin. ");
INSERT INTO sps_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nainy te fakap yan vegiau, Ya tsue to ten Saimon “Sua fakovoo nan puak tana pan a fakakeits ana mi min faakouts nam te fauf a muav ma sauf ami ta jian.” ");
INSERT INTO sps_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon biny Towa, “Tsunaun, mam vaanainy babainy em tana voiny, sana mam gima sauf vaarik ta jian. San tan tsue Tsumanyi nyo onot rou ma faatua pis iny a muav.” ");
INSERT INTO sps_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ri faatua iny to na muav, ser sauf jian kinai sana muav kat iny tata'ots en. ");
INSERT INTO sps_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ri kat to ser faap ir vaatau tsuri tan mes puak ma naa mi ri er faakouts ratuari. Ri naa me, ri nusainy ton fuan puak faavot tana jian san fuan puak namnam iny gagon en. ");
INSERT INTO sps_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nainy te tagei e Saimon Pita na ka te ruak fi nei ya fatukun to sa tsunguruu matan e Jisas sa tsue, “Tsunaun, naus osing you! Anyo na mes a aveto.” ");
INSERT INTO sps_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pita an mes panan to te faakouts mi ya, ri ngian iny a garejiaf a kinai te sauf ari. ");
INSERT INTO sps_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ina fuan a vaatau tsunia ere Jemis me Jon arin guei ten Sebedi ngian kan to. Ai Jisas tsue to ten Saimon, “Oraav bus vaare, muan nyi natiny kat iny nonom jian, sai te tanik non roman Nyo faatsuts marom anyi tan kat iny nonom mes iny kopis rari ma naa mi ri Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ri ras fasung ton fuan puak moun poporos, ri naus osing to na fo mamatsiny ka ser vovou naa Jisas. ");
INSERT INTO sps_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tan nainy te kaa Jisas tana isen a ngats fan to te kaa na mes a tatauba te pau faavots ya. Nainy te tagei ya Jisas ya fauf to na tsivon sa tsunguruu, ya sing to Jisas, “Tsunaun, to te koman fi rom Anyi, Nyi onot rom ma fataabos vanyo.” ");
INSERT INTO sps_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisas faarua iny naa na niman sa saras ya, sa tsue tsunia, “Nyo koman rou, taabos sanyi!” Sen tsun an tatauba naus osing towa. ");
INSERT INTO sps_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisas tsue faparits of towa, “Tsue vaare na ka to tan ta mes, sana nyi ma naa fatoobing tsun naa tana tsoiny faakor ma tagaa faarof ya tsumanyi; ana nyi te kat a faakor to te tsue iny Faun te kirkir iny e Moses muan, tan kat to aya, ma nat ari fokinai nyi taabos em.” ");
INSERT INTO sps_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","San vaanan nane Jisas saats faafis pis a fo pan, an tagin tana vainy naa mito Tsunia a tou nongon, ana ri te fatsipaar kan iny a fo faadis tsuri. ");
INSERT INTO sps_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sen Jisas natiny naus osing non a vainy ai te naa tana pan a tomani, a tou faakats. ");
INSERT INTO sps_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tan sen nainy Jisas faatsuts enanon tana vainy, mesapan tsuri na Farasi (a gum tana taa Jiu to te vovovou faarof ror Fuan te kirkir iny e Moses fiisen men kat tan tsuvurara) an tsoiny fifaatsuts tan Faun vaagum er naa, to te poo fi me tana fo ngats fan tana gum fan iny Galili, ai tana gum fan iny Judia, ai tana ngats fan tsian iny Jerusalem. Ana parits tana Tsunaun iny tsipaar kaa to ten Jisas Ya fatoto raton vainy faadis. ");
INSERT INTO sps_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mesapan tsuri govets mito na mes a nima mat ana mou mat soon non tan nenengan ana ri tanaf iny nom naa towa gagon numaa ma fasooiny ari ya matan e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","San a vainy te fasoksok ser gima onot ma sab ta sanaan ma nom naa ri ya gagon. Ri kat to ser govets finy naa ya tana kofuak nana numaa, ri kap to na isen a pan tana kofuak, ri fauf fiisen mi naa towan nenengan fapoopoan nar a fokinai matuen e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nainy te tagei e Jisas a faason, Ya tsue to tana mes a faadis, “Vaatau Tsiau, u aveto tsumanyi te anofe ravaa en.” ");
INSERT INTO sps_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tsoiny fifaatsuts tan Faun te kirkir iny e Moses, an Farasi, tanik iny favevegiau fapoopoan narari ser tsue, “E sei na mes to ee, tan kat tsue to, Ayei fifanauti minon e Gov! Sikia ta mes te onot non tan anofe ravainy aveto, e Gov tsun Tsivon.” ");
INSERT INTO sps_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas natiny fakats tsuri Ya tsue to, “Kat fei tsumi kaa men fakats fi nei koma mami ei? ");
INSERT INTO sps_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Saf vegiau te opaar non tsonyo ma kat na? Te tamee non Tsonyo ma tsue, ‘Nyo anofe ravainy fo aveto tsumanyi,’ ge te tamee fafis non tan tsue fi nei, ‘Tsun, nyi te taan?’ ");
INSERT INTO sps_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sai tovei Nyo faatok maromi ma nat fi nei, A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me kaa minon gumgum tana monaagits to tan anofe ravainy aveto.” Ai Jisas tsue to tana mes a nima mat ana mou mat, “Nyo tsue rou tsumanyi, tsun, nom nenengan tsuam, nyi te naa numaa tsuam.” ");
INSERT INTO sps_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sen tsun ana mes tsun to mata rari na fokinai govets ton nenengan te sosoon ya ya naa to numaa tsunia fiisen men vamarits naa ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ana ri na fokinai saar faavots Towa. Ri kaa mito na oraav ser vamarits to Gov ser tsue, “Saf a ka na kaatsian to na te tagei ara roman!” ");
INSERT INTO sps_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Voun a ka to, ai Jisas taan naa to Ya tagei to na tsoiny nonom takis te koo rori Livai vaagum non numaa tana pan iny nonom takis. Jisas tsue to tsunia, “Vovou you.” ");
INSERT INTO sps_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livai tsun to sa naus osing a fo mamatsiny ka, ya vovou iny to e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ai Livai kat to na kainy ainy guainy numaa tsunia nane Jisas, ya faan iny ton vebus tan vainy nonom takis kinai ana mes a vainy kan, tana taran te ainy fiisen ramiri. ");
INSERT INTO sps_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mesapan tana Farasi an tsoiny fifaatsuts tan Faun tagei a ka to ser tsue tsuk matisian ten Jisas. “Kat fei tsumi ainy ana mi jiu fiisen ramirorin vainy nonom takis an mes vainy pisiin ei?” ");
INSERT INTO sps_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisas biny ratuari, “Vainy toto faarof gim ror ma komainy a tsoiny tsipaar, a sikia a vainy tsun ton faadis. ");
INSERT INTO sps_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nyo gima naa me ma fikoo Nyon vainy tavaron sana Nyo te naa me ma fikoo Nyon vainy pisiin ma reesik ari er takopis osing ton kat iny aveto.” ");
INSERT INTO sps_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ana ri na vainy tsue to ten Jisas, “U matisian ten Jon a Tsoiny Fapeenan natiny tavtaav vaurep ror, ri faakats er, an matisian tan Farasi kat ror senviir kat, san matisian Tsumanyi ainy ror ri jiu er, ri gim ror ma natiny tavtaav.” ");
INSERT INTO sps_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisas tsue fatabin to tsuri, “A vainy te naa miror tan guainy tana fanging ser vaagum fiisen men tsoiny fanging gim ror ma natiny tavtaav iny a kainy ainy teeva? Sikia. ");
INSERT INTO sps_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nainy te faarei Anyo na tsoiny fanging, Nyo kaa fiisen ramituari rin fuainy matisian Tsonyo, mam ainy sai vou, vainy nai nots Varonyo Nyo te kaa osing ir matisian Tsonyo tan nainy to aya, matisian nai tavtaav ror.” ");
INSERT INTO sps_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisas tsue of ratuarin tsue fapapaar to, “Sikia ta mes te onot non ma keres ta painy vau foun a kuiny towa na takakaar tan vau tamuan. Te kat fi non ya nei, ayei kat kakaar non vau foun ana painy raarav a foun sikia non ma tamainy a painy raarav a tamuan. ");
INSERT INTO sps_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ana sikia ta mes te onot non ma itsuf u wain foun tana iikan a tamuan. Te kat fi non nei, an wain foun te kat pung a iikan a tamuan, an wain te tatsiiu ravaa ana iikan te nai kajiaan en. ");
INSERT INTO sps_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sikia, u wain foun ma itsuf tana iikan a foun. ");
INSERT INTO sps_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","E sei na mes te jiu non wain tamuan te sikia non ma komainy tu wain foun. Ayei te tsue, ‘A ka na tamuan a rof fafis.’” ");
INSERT INTO sps_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tan sen Nainy Fafaatouf tana taa Jiu, Jisas taan naa koman tanun wit. An matisian Tsunia kat to ser ngats wit ri nom ton fua nan wit ser wusas ya na nimar an pem rus ravaa to ri ainy ton fua. ");
INSERT INTO sps_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mesapan tsurin Farasi naa me ser tsue, “Kat fei tsumi kat a ka to ei to te sikia non ma toobing tana Faun tsura ma binun vaare ra tan Nainy Fafaatouf?” ");
INSERT INTO sps_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisas biny ratuari, “Ami te gogosias a ka te kat e Devit a Aatouf a tsuvurara fiisen men vainy tsuan te ves ari muan! ");
INSERT INTO sps_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ayei te naa sa sof a saape ten Gov ana tsoiny faakor famanat iny towa ma nom koinykoiny te faan iny ari matan e Gov sa ainy ya, ya fafaan ratuarin vainy tsuan. Sai tan Faun tsoiny faakor tsun onot ror ma ainy ya.” ");
INSERT INTO sps_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ai Jisas tsue to tsuri, “Devit gima kat aveto. An matisian Tsonyo kan gima kat aveto tana saa, Nyo na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me Tsunaun iny non Nainy Fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tan mes Nainy Fafaatouf tana taa Jiu, Jisas naa to tana numaa iny fafaatouf sa faatsuts. Isen a mes te kaa kan, nimainy matou tsunian pengong. ");
INSERT INTO sps_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mesapan Farasi an tsoiny fifaatsuts tan Faun te kirkir iny e Moses te komainy ma tsikoo ta sanaan ma fakei ari Jisas tan vaatsuk tan ta iring te kat non Ya to ser vavaatok iny Ya to te tsipaar finy non Ya ta mes to aya. Tan kat to Ayei te ngats non Faun te tsue fi non nei, “Binun vaare tan Nainy Fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sen Jisas natiny fakats tsuri sa tsue tana mes a nima pengong, “Tsun, taame nei matan.” Ana mes tsun to sa taan naa. ");
INSERT INTO sps_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ai Jisas tsue to tsuri, “Nyo rangat maromi, fei te famanat fi roran Faun ei tan ta ka ta rof ma faakouts ara na mes tan Nainy Fafaatouf ge kat fifiiring ror ya? Iny saup a toto tana mes ge kat famat ya?” ");
INSERT INTO sps_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ya matoong fagoguas ratuari na fokinai kat to sa tsue tana mes to aya, “Paroor a nimam.” Ana mes paroor to na niman ana niman ya rof enato. ");
INSERT INTO sps_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Farasi an tsoiny fifaatsuts tan Faun koma rari te iring ser seeve er, ri favevegiau to fapoopoan narari tan ta saa te kat rori na ten Jisas. ");
INSERT INTO sps_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","“Tan sen nainy, Jisas naa to patsun a painy tet a tou faakats sa kaa na isen a voiny a urung na aya sa faakats ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tana voinyvoiny Ya fikoo raton matisian Tsunia ma naa ri Tsunia. Ya pisainy to na safunuu ana ina fuan a matisian sa koo rarin Amaraav. ");
INSERT INTO sps_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon, ito te koo kainy Ya Pita, ai famuinyasiny tsunia Anduru, ai Jemis, ai Jon, ai Pilip, ai Batolomiu, ");
INSERT INTO sps_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ai Matiu, ai Tomas, ai Jemis a guei tsoiny ten Alfias, ai Saimon, ayei na isen tsurin a gum iny tsoiny te koo ri Selot te kat iny nom ravainy ror gumgum iny Roum, ");
INSERT INTO sps_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ai Judas Tadias, a guei tsoiny ten Jemis, ai Judas Iskariot, ayei na mes te nai faan iny e Jisas tan vainy ma atsuiny famat ari Ya. ");
INSERT INTO sps_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas kat to sa of osing men tet fiisen ramiri ser nai tsutsun me tana pan a toobing fiisen ramirin tagin tsian an matisian Tsunia ana vainy kinai poo me tana ngats fan tsian iny Jerusalem, ai ri poo me tana fo mes fan tana gum fan iny Judia, ai te poo me tan teis tana fuan a ngats fan iny Taia ai Saidon. ");
INSERT INTO sps_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ri na tou nongoiny vaanan Tsunia ana ri te fatsipaar iny a fo faadis tsuar. Ari to te tutuaa iny masarau naa me ser rof fatabin er. ");
INSERT INTO sps_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A vainy a kinai te tanaf ma saras Ya, tana saa a parits to te poo non Tsunia, ai te guas rari ana fokinai te rof fatabin er. ");
INSERT INTO sps_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas matoong ton matisian Tsunia sa tsue, “Paparaa tsumin vainy te aaruts rom tan aavem; a Waan e Gov a ka tsumi. ");
INSERT INTO sps_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Paparaa tsumin vainy te kainy ves rom ten Gov, Ayei nai faonots non koman tsumi. “Paparaa tsumin vainy te tangis rom tan aveto tsumi, mi nai vavakaar nats rom. ");
INSERT INTO sps_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Paparaa tsumin vainy te koma iring maromi na vainy ana ri te tsugaa mami, ri te tsue fifiiring mami ana ri te fa'avesaat mami, tana saa, amin vainy Tsonyo na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me. ");
INSERT INTO sps_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Te ruak non a foka to, ami ma paparaa fatsian tsun, tana saa, tsuvurari te kat kainy senviir kat tan fuainy kuigin. Mi te tajiat men mamagat, tana saa, a tafan tsian tsumi te kaa en Gormirmir. ");
INSERT INTO sps_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ma sekee, mi kaa mirom masun tovei, mi nom bus a paparaa tsumi, mi sikia pis rom ma paparaa nats vou. ");
INSERT INTO sps_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ma sekee, mi viits rom tovei, mi nai ves rom vou. “Ma sekee, mi oor rom tovei, mi nai ugun rom am tangis to vou unya Hel. ");
INSERT INTO sps_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ma sekee, nainy te nai siisio faarof marom anyi ri, tana saa, senviir tsue to aya nan te tsue ri tan tsuvumami tan kuigin gamgam. ");
INSERT INTO sps_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Sana Nyo tsue of maromi te natiny nongoiny Varonyo; mangiir yam vainy te koma iring maromi, ana mi te kat, kat rof tsuri te tsugei maromi, ");
INSERT INTO sps_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","faparits ir te ramos maromi, am faakats to ten Gov ma kat faarof rari Ya te kat fijior maromi. ");
INSERT INTO sps_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta isen te sapan marom anyi tan panainy asase manyi, faan iny mes panan ma sapainy kainy ya, ta mes te nom non vau iny jiarasan, tanyiny ma nom kainy yan vau iny gagon tsumanyi. ");
INSERT INTO sps_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sei ta mes te sing marom anyi ta ka ee fainy ai to te nom babainy non a mes ta ka tsumanyi, rangat fatabin iny vaare. ");
INSERT INTO sps_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","To te koman fi rom anyi ri ma kat of manyi, kat to aya nyi ma kat of rari. ");
INSERT INTO sps_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Te mangiir tsuiny rom anyi na vainy to te mangiir marom anyi, nyi gim rom ma nai nom a tafan a rof ten Gov. U vainy aveto kan te natiny mangiir ror a vainy te mangiir rarori. ");
INSERT INTO sps_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ai te kat rom anyin kat rof tsuri tsun te kat kat rof tsumanyi nyi gim rom ma nai nom a tafan a rof ten Gov. Vainy aveto kan te kat ror senviir kat. ");
INSERT INTO sps_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ai te fafaan rom anyi na vainy te naano fi rom anyi nei ri biny fatabiny ror ya, nyi gim rom ma nai nom a tafan a rof ten Gov. Senviir kan non tsurin vainy aveto famanat rarorin vainy aveto pon kan ror te nai nom ror senviir as'as. ");
INSERT INTO sps_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sikia, mangiir ir yam te koma iring maromi ana mi te kat, kat rof tsuri, famanat iny mi te fakats vaare ma nom fatabiny ya, sana mi ma fakats faarof ai Gov te nai faan mami na tafan tsian. Sai te kat fi romi na foka to aya, mi kat faarei rom guei ten Gov a Tsigtsig Fiisok, tana saa, Ayei te kat non a sanaan to aya, Ayei te rof rarori te gim ror ma natiny tsue faarof, ai tsuri kan vainy ngi'arapaar fiisok. ");
INSERT INTO sps_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ami ma kaa men koma tagtag am faarei to Tamamami na koma tagtag.” ");
INSERT INTO sps_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ai Jisas tsue pis to, “Mi ma faaroiny vaaren kat tana mesapan ai Gov gim kainy non ma nai faaron mami. Ami ma sigan vaare na mesapan ai Gov gim kainy non ma nai sigan mami. Ami ma anofe ravainy aveto tsuri, ai Gov te nai anofe ravainy aveto tsumi. ");
INSERT INTO sps_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ami ma faan tana mesapan, ai Gov te nai faan kan maromi ana mi te nom fapaas tan as'as a fifaakouts a kinai ai te tsiiu me nima mami ai mi te nom fatsitapuu iny ya. A as'as te faan iny romi tan mesapan, Gov nai faan fatabin fasenviir kan iny non Ya tsumi.” ");
INSERT INTO sps_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ai Jisas tsue of ratuarin tsue fapapaar to, “A mes a mata kio gim non ma mumua iny a mesmes tsunia na kio kat fi non nei ri nai gotsiny faavot eraror tana gaguur. ");
INSERT INTO sps_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sikia ta guei tan fifaatsuts te karap fafis iny non nan a tsoiny fifaatsuts tsuan te fakap non yan fifaatsuts tsunia, ana ayei te faarei na tsoiny fifaatsuts tsunia. ");
INSERT INTO sps_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kat fei to tsumi mamatoong tsuiny rom a painy kikipoo na kakaii te kaa non matan e vamuinyasiny tsumi, sana mi gim rom ma fakats a buiny kikipoo te kaa non mata mami ei? ");
INSERT INTO sps_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fiisia, nyi onot rom ma tsue of e vamuinyasiny tsuam, ‘Vamuinyasiny, tanyiny you ma nom ravainy tsom anyon kikipoo kakaii te kaa non matan ya,’ sana nyi gima nom ravainy faamuainy tsom a buiny kikipoo mata manyi, Anyi na mes a kat mapam, nom ravainy faamuainy tsom a buiny kikipoo matam, nyi te onot ma tagaa fa'arasan ma nom ravainy anyin kikipoon kakaii matan e vamuinyasiny tsuam. ");
INSERT INTO sps_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nau rof sikia non ma natiny fua fiiring, ge nau iring sikia non ma natiny fua faarof. ");
INSERT INTO sps_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A nau faavot ra nat fi rarori tan fua nar, nyi onot rom ma patsik tu fua nan vei tan kakarits? Ge te onot rom ma avet tu fua nan ngainy tana aufing a ngarian. ");
INSERT INTO sps_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A mes a rof faruak minon a rof tan kat rof tsunia koman, ana mes a iring faruak minon kat iring tsunia tan kat iring te kaa non koman ya. A ngue na mes te faruak minon a saa te via non koman ya. ");
INSERT INTO sps_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kat fei tsumi koo Varonyo na Tsunaun, Tsunaun, ana mi gim rom ma kat a ka te tsue of im yam? ");
INSERT INTO sps_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","E sei na mes te naa minon Tsonyo ee, ana ayei te nongon tan vegiau Tsonyo ee, ana ayei te manaats ya, Nyo faatok maromi te faarei fi non ya. ");
INSERT INTO sps_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ayei te faarei non a tsoiny fatsun numaa te kats a matan a gaguur ya fatsuiny to na poon nana numaa patsun fats. Te koor me naa urungat sa ong a numaa sana ayei gima fagunainy ya, tana saa te fatsun tan poon rof. ");
INSERT INTO sps_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","San tana mes te nongoiny non vegiau Tsonyo sa gima manaats ya faarei non a mes te fatsuiny a numaa tan puputaa babainy tsun tana poon nana numaa, te naa me na urungat sa ong a numaa ya tarop faavot enato sa taruraa faavot en.” ");
INSERT INTO sps_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tan nainy te favaanan fakap iny e Jisas a fo mamatsiny ka to tana vainy Ya naa fi naa to tana ngats fan iny Kapeniam. ");
INSERT INTO sps_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Isen a tsoiny mumua tan natus vainy puaan tana taa Roum te kaa naa ya. Ayei te kaa me na isen a tsoiny binun te kaa non koman tsunia sana ayei kaa me na faadis sa kaa tana pan iny mat. ");
INSERT INTO sps_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nainy te nongoiny ya na tsoiny mumua tan vainy puaan siisio nane Jisas ya jiats ton tsunaun tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ri naa ten Jisas ri su'eets Towa, “A mes to aya te onot famainy non ma nom a fifaakouts Tsuam, ");
INSERT INTO sps_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tana saa ayei te kaa me na tagtag tsura na taa Jiu, ana ayei patsukanen fatsuiny of ratuara na numaa iny fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kat to ai Jisas naa fiisen ramituari. Jisas gima veevian tana numaa ana tsoiny mumua tan vainy puaan jiats miton vaatau ma tsue of ari Ya, “Tsunaun, fanag vaare na puam. Nyo gima onot faarof ma famanat Manyi ma naa me numaa tsonyo, ");
INSERT INTO sps_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ge nyo gima onot faarof ma naa me Tsuam, sai nyi ma tsue tsun ana tsoiny binun tsonyo te rof fatabin en. ");
INSERT INTO sps_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Anyo kan a mes te kaa rou fain gumgum tan tsoiny mumua tan vainy puaan te karap varonyo, ana nyo kan kaa mirou vainy puaan te kaa ror faiv vanyo. Te tsue ronyo tana mes to, ‘Kua!’ ana ayei te naa naa. Nyo te tsue of a mesmes, ‘Taame!’ ana ayei te naa me. Ana Nyo te tsue of a tsoiny binun babainy tsonyo, ‘Kat a ka to!’ ana ayei te kat ya.” ");
INSERT INTO sps_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nainy te nongoiny e Jisas a ka to Ya ngian enato ana Ya takopis faavou of to na vainy sa tsue tsurin tagin te vovou iny Ya, “Nyo tsue of maromi, Nyo gima sab vaarik ta mes te kaa fi minon ya na faason tsian to ayei, a sikia kan tana taa Isrel!” ");
INSERT INTO sps_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","U tsoiny govet vurungan tabin to numaa tana tsoiny mumua tan vainy puaan ser sab a tsoiny binun te rof fatabin en. ");
INSERT INTO sps_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gima potsian, vou ai Jisas naa to tana ngats fan te koo rori Nen fiisen kan mi yan matisian an tagin tsian te naa fiisen mi naa Ya. ");
INSERT INTO sps_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te ruak Ya tan matainy sobaa nana ngats fan Ya tainytainy rato na vainy te govets faruak miror a mes a mat. A mes a mat to aya, ayei na isen tsun a guei tsoiny tana amov to aya, an tagin te poo me tana ngats fan to aya kaa fiisen mi towa. ");
INSERT INTO sps_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nainy te tagei e Jisas a moun ana koman Ya via miton tagtag tana moun Ya tsue to tsunia, “Tangis vaare.” ");
INSERT INTO sps_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kat to, Ya taan fasiruu naa to sa saras a gen, ana vainy to te govets a gen tsutsun faavot rato. Jisas tsue to, “Tsoiny vurots! Nyo tsue of marom anyi, tsun!” ");
INSERT INTO sps_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ana mes a mat tsun to ya tanik iny vegiau to, ai Jisas faan fatabin iny towa ten tsinan ya. ");
INSERT INTO sps_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ana fokinai via mito na oraav ri vamarits to Gov. Ri tsue to, “A karap nar kuigin te ruak fapoopoan narara!” Ana ri tsue pis to, “A Gov te ruak en a tou saup ir a vainy Tsunia!” ");
INSERT INTO sps_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","U vaanan nane Jisas to aya, saats faafis to na fo gum fan iny Judia ai tana fafakap nana fo fan vavis. ");
INSERT INTO sps_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","U matisian ten Jon a Tsoiny Fapeenan te tsue of ya na fo mamatsiny ka te kat e Jisas. Ai Jon fikoo rato na ina fuan tsuri ma naa mi ri tsunia, ");
INSERT INTO sps_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ana ayei jiat fi ranaatuari tana Tsunaun ser rangats Ya, “Anyi koraa Ya na mes to te tsue iny e Jon to te naa minon ge mam ma anaanos farokots ta mesmes?” ");
INSERT INTO sps_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nainy te ruak ari ten Jisas ri tsue to, “Jon a Tsoiny Fapeenan jiat mamimam ma rangat manyi, ‘Anyi koraa Ya na mes to te tsue iny e Jon te naa minon ge mam ma anaanos farokots na ta mesmes?’” ");
INSERT INTO sps_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tan nainy patsukan to aya Jisas tsipaar vainy a kinai te kaa men fo viir faadis an fo viir kamits, an masarau, an matar kio tagaa fatabin er. ");
INSERT INTO sps_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ayei faonots vegiau ten Jon to sa tsue, “Kuar fatabin yam, am tsue of to Jon tana foka te tagei ami ana foka te nongoiny ami: arin matar kio tagaa fatabin er, rin pengong taataan fatabin er, rin vainy tatauba tsipaar fatabin er, rin teinar kuupio nongon fatabin er, rin vainy mat toto fatabin er, an Vurungan Rof favaanan en tan vainy aaruts. ");
INSERT INTO sps_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Gov faparits non a mes te faamainy Varonyo to na mes te pokei iny e Jon sai te gima vaa'ets Vanyo!” ");
INSERT INTO sps_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Te tabin naa rin matisian ten Jon, Jisas tanik iny vegiau tsuk to Jon tan tagin, “Nainy te naa fi mi ten Jon tana pan a uur, a saa te pon iny ami ma tagei na? Ami pon ma tagei a mes a sikia ta faaman te faarein ngaar te tagugut non tana ainysat? A sikia. ");
INSERT INTO sps_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A saa te nai tagei ami na? A mes te vaun vau tsunian mamarof ge? Vainy te vau fi ror nei kaa miror a masun ai ri kaa ror tana numaa tana fo gotouf. ");
INSERT INTO sps_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tsue of Vaminyo yam, a saa te nai tagei ami na? A kuigin? Eye, Nyo tsue of maromi mi tagei bus a kuigin to te karap fafis pis a fo kuigin, ");
INSERT INTO sps_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","tana saa, e Jon ayei na mes to te tsue tsuk men Vegiau Ten Gov sa tsue, ‘Tovei na tsoiny favaanan Tsonyo’ te tsue fi Gov, ‘Nyo nai jiats famumuei nats rou ya Tsumanyi ma kakouiny onots ya na sanaan Tsumanyi.’ ");
INSERT INTO sps_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nyo tsue of maromi, Jon a Tsoiny Fapeenan karap fafis iny non a vainy to te agiir tana monaagits to, sana mes tana Waan e Gov to te fauf non a tsivon a faarei to na mes babainy ayei karap fafis pis iny non e Jon.” ");
INSERT INTO sps_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nainy te nongon arin vainy faavot an tsoiny nonom takis e Jisas ana ri tsue to, “Mangiir ten Gov tavaron ovei.” tana saa, arin vainy te vovou iny ror a tou tavaron ten Gov, ri peenan to ten Jon. ");
INSERT INTO sps_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sana ri na Farasi an tsoiny fifaatsuts tan Faun te kirkir iny e Moses tsugei mangiir ten Gov to ser baainy ma peenan ten Jon. ");
INSERT INTO sps_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisas tsue pis to, “Fei te fapapaar finy Ronyo ya tsumin vainy iny roman ei? Mi faarei rom a saa? ");
INSERT INTO sps_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mi faarei rom guein kakaiin pisiin te goonen ror koman a fan. Isen a gum kuu fi naa ror tana mes a gum, ‘Mam kat of maromin babaato nan fanging, sana mi baainy rom a tajiat! Mam koomein fo vaa'ur sana mi gima tangis.’ ");
INSERT INTO sps_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon a Tsoiny Fapeenan naa me sa tavtaav ya gim to ma ainy tu koinykoiny ana ya gim kainy to ma jiu tu wain, ana mi tsue towa na tutuei iny masarau! ");
INSERT INTO sps_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ana Anyo na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa me, Ya ainy to, ana Ya jiu to, ana mi tsue, ‘Tagaa yam tana mes tovei! Ayei na mes a kokorom ana jijiu wain fiisok, a vaatau kan tana vavainy nonom takis an mes vainy aveto.’ ");
INSERT INTO sps_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mi tsugei vegiau te kat amam me Jon, sana vainy faarof vegiau Tsonyo faatok maromi na nat ten Gov a tavaron tan kat tana toto tsuri.” ");
INSERT INTO sps_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A Tsoiny Farasi faan iny vebus ten Jisas ma nainy ainy fiisen mi ya Ya. Jisas naa tana numaa tana tsoiny Farasi sa gum iny ainy en. ");
INSERT INTO sps_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Te kaa me na moun te kaa koman a ngats fan to aya natiny kat non kat aveto. Te nongon finy ya Jisas te ainy fiisen minon a tsoiny Farasi koman a numaa tsuan, ya sof mito fiisen me na kepaa viainy minon tapui na tsuraf. ");
INSERT INTO sps_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sa tsutsun voun e Jisas panaan a moun Ya fiisen men tangis, san susuiny matan tsinik fabub naa na moun Ya. Kat to ana moun faparak to na moun e Jisas a funuu nan ya umei to na moun Ya, sa tsiiu iny a tapui na tsuraf moun Ya. ");
INSERT INTO sps_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","A tsoiny Farasi faan iny vebus ten Jisas tagei a ka to ya tsue to tsivon, “A mes tovei tabuiny kuigin faman ya Ayei onot non ma natiny e sei to aya na moun te saras Ya ee, ana Ayei onot kan non ma natiny saf a toto iny aveto te kaa non ya na!” ");
INSERT INTO sps_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas tsue to tsunia, “Saimon Nyo kaa mirou a ka iny tsue of manyi.” Saimon tsue to Tsunia, “Rof non Tsoiny Fifaatsuts tsue of you.” ");
INSERT INTO sps_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisas tsue to, “A ina fuan a mes te tavan tana isen a mes te kaa me na moni. Isen te tavainy ngim ma natus moni ana mesmes a ngim safunuu na moni. ");
INSERT INTO sps_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sikia ta isen tsuri ma famatainy a tavan, ya kat to sa anofe ravainy a tavan tana ina fuan a mes. E sei tsuri ee, tana ina fuan te mangiir fafis pis ror ya?” ");
INSERT INTO sps_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon biny Towa, “Nyo pon fi rou nei, to na mes te kaa minon a tavan tsian tsunia ayei te anofe ya.” Jisas tsue of towa, “U fakats tsumanyi te toobing non.” ");
INSERT INTO sps_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ya kat to sa takopis of a moun ya tsue to ten Saimon, “Nyi tagei kainy rom a moun tovei? Nyo naa me numaa tsumanyi, nyi gim to ma fakei ta aurom ka iny garus a mou vanyo, sana ayei te garus a mou Vanyon susuiny matan tsunia ya sap faparak towa na funuu nan. ");
INSERT INTO sps_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Anyi gima fafasof Vanyo tan umei Vanyo, sana ayei gima faonot tan umei a mou Vanyo onot non te naa mi Nyo. ");
INSERT INTO sps_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Anyi gima tsiiu iny ta tapui patsuu Vanyo, sana ayei kookop faavots tsuiny a mou Vanyo na tapui na tsuraf. ");
INSERT INTO sps_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","To sana Nyo tsue of marom anyin mangiir tsian te faatok iny ya, te pokei non a fokinai aveto tsunia te anofe ravaa en, sen sei na mes e Gov te anofe ravainy a tee aveto tsunia ee, ayei faatok kan iny non mangiir a kakaii.” ");
INSERT INTO sps_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kat to ai Jisas tsue to tana moun, “A fo aveto tsumanyi te anofe ravaa en.” ");
INSERT INTO sps_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A mesapan tsuri te gumgum tanik iny favevegiau rato fapoopoan narari, “E sei to aya te onots non ma anofe ravainy aveto ee?” ");
INSERT INTO sps_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sen Jisas tsue tana moun, “A faason tsumanyi te saup manyi tana parits tan aveto, kua min naan aaverof.” ");
INSERT INTO sps_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Voun mes a fo nainy Jisas taainy to na fo ngats fan ana Ya favaanan iny ton Vurungan Rof nana Waan e Gov. Safunuu ana ina fuan a matisian naa fiisen mi Ya, ");
INSERT INTO sps_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","an mesapan iton moun kan Jisas te buur ravainy masarau ana Ya tsipaar ton fo faadis tsuri, ere Meri na moun to te koo ri Meri na muiny Magdala, ayei to Jisas te buur ravainy osing ya na fits a masarau, ");
INSERT INTO sps_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ai Joana, natsun Tsusa, ayei na tsoiny tatagaa ot tana numaa tsian ten Herot, ai Susana min mes moun kinai, ri fafaakouts e Jisas an matisian Tsuan tana fo mar ka tsuri fatoobing. ");
INSERT INTO sps_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Vainy a kinai gima faonot tan naa me ten Jisas tan fo ngats fan fifatsuktsuk tsun me ai te ovot bus ari, Jisas tsue of ratuarin tsue fapapaar, ");
INSERT INTO sps_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“A mes iny rereev tanun te nai saats iny fua te piat iny yan fua koman a tanun an mes fua gotsiny to sanaan to ser pitei ya an marei naa mito ser ainy ya. ");
INSERT INTO sps_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mes a fo fua gotsiny to tan puputaan fatsfats te gian ya, ri maas rato tana saa u puputaan gima bub. ");
INSERT INTO sps_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","An Mes fua gotsiny to tan puputaa te kaa men fua nan kakarits gagon tan puputaa fapoopoan narari an kakarits gian to ser pis ya sa sikia ma kaa me tu fua. ");
INSERT INTO sps_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","San mes a fo fua gotsiny tana pan te kaa men puputaan rof, koo ser gian ri karap to ser kaa men fokinai fua onots natus tan isisen fua.” Jisas tsue pis to na ka, “Mes kaa minon teinan iny nongon ma nongon faarof.” ");
INSERT INTO sps_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","An matisian Tsunia rangats Towa, saf a man nan tsue fapapaar to naa, ");
INSERT INTO sps_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisas tsue fatabin to, “A nat nana ka na takop nana Waan e Gov te faan fakap en tsumi san tana mesapan Nyo vegiau tan kat tan tsue fapapaar to ma matoong ari sana ri sikia ror ma tagaa fanatnat iny ya, ana ri nongon ror sana ri sikia ror ma nongon fanatnat iny ya.” ");
INSERT INTO sps_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tovei na man nan tsue fapapaar, u fua ayein vegiau ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","U fua te gotsiny tana sanaan te faarei non a vainy te nongon, sana Vinasaar naa me ya nom ravainy ton vegiau aave rari iny kat rari ma faaman vaare ri ten Gov te saup fatabin rarori. ");
INSERT INTO sps_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","U fua te gotsiny tan puputaan fatsfats faarei raror vainy te nongoiny vegiau ser paparaa tan nom ya sai te gima kaa fagagon naa aave rari ri te faaman sai te gima potsian, ana ri gotsiny rato te naa men fo nainy iny fiamus. ");
INSERT INTO sps_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","U fua te gotsiny koman puputaa te kaa men fua nan kakarits gagon faarei raror vainy te nongon san reesik iny kaa me ta ka ana fo koman iny ma kaa me na masun, an paparaa iny a toto roman ovot non koma rari sa nom ravainy vegiau, an fua tsuri gim to ma fuur. ");
INSERT INTO sps_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","U fua te rus tan puputaan rof faarei raror vainy te nongoiny vegiau ten Gov ser nom tap iny ya tan aaven rof iny manaats iny vovou iny ya, sa gima faonot tan fua. ");
INSERT INTO sps_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Sikia ta isen te fakuruiny non kurun ana ayei te kookop yan kobuu ge ma fakei ya fain a fetan sai te fagum non tana pan iny fafagum kurun ma tagei a vainy a arasan ri te sof me gagon. ");
INSERT INTO sps_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Saf a fokan takop na nai kat faruak non ana saf a foka na famun nai sab non ri te fakei ya tana arasan. ");
INSERT INTO sps_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mi ma fakats faarof tana tou nongon tsuam tana saa, e sei na mes te kaa minon a nat a man nana Waan e Gov ee, Gov nai faan pis iny non ya na nat nana Waan Yan. Ai sei na mes a sikia ee, e Gov nai nom ravainy non a ar nat tana Waan Ya to te pon iny non ya ma fasito iny.” ");
INSERT INTO sps_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsinan Jisas an famuinyasiny Tsunia a tou tagei Ya sana ri gima onot ma naa na panan Ya, tana saa u tagin. ");
INSERT INTO sps_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mesapan tsuri tsue to ten Jisas, “E tsinamanyi an famuinyasiny Tsumanyi te tsutsun ror jiarasan te komainy tagei marom Anyi.” ");
INSERT INTO sps_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ai Jisas tsue to tsuri na fokinai, “E sei tsun te nongoiny non vegiau ten Gov ee ana ayei te manaats ya, te faarei non e tsinanyo an fuainy famuinyasiny Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tan sen nainy Jisas jias tan puak fiisen ramirin matisian Tsunia sa tsue tsuri, “Tanats yam ma guas naa ra tan mes panaan nana naaman.” Ana ri tanik iny sua faguas bus rato. ");
INSERT INTO sps_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Te sepuu naa ri ai Jisas goros bus nato. An sekeiny ratsuu tapoor mito naaman an puak tanik iny fabuu nato sa fakaa rari tana iring tsian. ");
INSERT INTO sps_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","An matisian naa to Tsunia ser guinyguiny Ya ri tsue to, “Tsunaun, Tsunaun, ara kat iny mat osto!” Jisas tsun to sa tsue ets'ets a ainysat an rau sariof ovei nato ana madaav ras to. ");
INSERT INTO sps_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ya kat to sa tsue tan matisian, “Aya na faason tsumi ei?” Sana ri saar ri oraav rato ser favevegiau patsukaner, “E sei na mes to aya ee, to Tsunia faan iny tsuen parits tana ainysat an rau, ser manaats Ya!” ");
INSERT INTO sps_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ana ri sepuu faguas fakap naa to tan mes panaan nana naaman iny Galili, tana pan iny Gerasa. ");
INSERT INTO sps_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Te of naa Jisas mats, Ya tainytainy to na mes te poo me tana ngats fan a tutuei iny masarau. Ayei te naa en naangis to sa beerbeer en ya gim to ma kaa fan sana ayei kaa vavis patsukanen tana fo puts tan katskats. ");
INSERT INTO sps_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nainy te tagei ya Jisas, sa kuu fiisok ya gotsiny to matan Ya, ya kuu to sa tsue, “Jisas, Guei Tsoiny tana Gov a Tsigtsig Fiisok! A saa te komainy kat rom Anyi tsonyo na? Nyo sing marom Anyi fakamits vaare you!” ");
INSERT INTO sps_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ayei te tsue fi nei tana saa Jisas tsue faparits bus a masarau ngi'arapaar ma tafuts osing ya na mes. Tan nainy kinai masarau tutuei non ya ana vainy kotskots kainy ya na tseen niman ana moun ya sana ayei natiny ots non ya an masarau te mei finy ya tana pan a uur. ");
INSERT INTO sps_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas rangats towa, “E sei na asanga manyi ee?” Ya tsue to, “A asanga vanyo, Tagin Tsian,” tana saa, u masarau kinai te sof ya. ");
INSERT INTO sps_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Masarau sing to Jisas, jiat fi vaare mamam tana matan a gaguur fiisok a sikia ta faatain nan koo rori Abiis. ");
INSERT INTO sps_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","U veis voon kinai fiisok siruu te ainyainy tan panaan tet. An masarau sing to Jisas ma famanat rari er nai sof ton voo, ana Ya famanat ratuari. ");
INSERT INTO sps_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","To ser tafuts osing a mes ri sof ton voo. An veis voo faavot kuar to ser tsiak naa tana varian tsidup na naaman ser ruk faavot er ri mat rato. ");
INSERT INTO sps_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vainy te tatagaa ot ir voo tagei to na ka te ruak fi nei ri fakookuar naa to ser saats a pan tan vaanan tana ngats fan ai tana fo mes a fo fan. ");
INSERT INTO sps_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ana vainy naa faavot naa to a tou tagaa tana saa te ruak na. Ri naa me ten Jisas ri sab to na mes ton masarau te tafuts osing ya gum non petoo moun e Jisas kaa men vau, an fakats arasan ana ri na fokinai oraav to. ");
INSERT INTO sps_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A vainy te tagei a foka te ruak tsunia tsue of rato na vainy faavot to te rof fatabin fi ya. ");
INSERT INTO sps_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kat to ana vainy faavot tana gum fan iny Gerasa rangats to Jisas ma naus osing rari tana saa, ri te oraav fiisok ovei tsun er. Jisas kat to sa jias tan puak ya naus ratuari. ");
INSERT INTO sps_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ana mes ton masarau te tafuts osing ya sing to Jisas, “Nyo komainy naa fiisen ma mirom anyi.” Sen Jisas tsue of ya, ");
INSERT INTO sps_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Tabin fan ana nyi te tsue of ir a vainy tana ka te kat e Gov tsuam.” Ana mes taan naa to koman a ngats fan sa tsue of rari na foka te kat e Jisas tsunia. ");
INSERT INTO sps_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nainy te tabin fi naa Jisas tan mes panaan nana naaman an tagin fafasung faarof Towa tana saa, ri na fokinai te anaanos Ya. ");
INSERT INTO sps_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kat to ana mes ruak mito koo rori Jairus ayei na tsoiny mumua tana numaa iny fafaatouf tana taa Jiu naa mito Tsunia fatukun to sa tsunguruu moun e Jisas ya sing Towa ma naa ya numaa tsunia, ");
INSERT INTO sps_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tana saa, a guei moun tsunia na isen tsun ana ingainy te karap ya onots safunuu ana fuan sa kat iny mat osto. Te naa na Jisas fiisen kan ramiri na fokinai ser fasoksok fiisen mi naa Ya. ");
INSERT INTO sps_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A moun te kaa kan na aya a gum iny tataa'in onots a safunuu ana fuan na ingainy, ayei foiny fakap kan iny a te moni tsunia tan tsoiny tsipaar sana sikia ta mes ma onot tan tsipaar ya. ");
INSERT INTO sps_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ya sokiir mito tana fokinai sa ising me voun e Jisas sa saras nguen raarav Tsunia sen tsun, tataa'in parak enato. ");
INSERT INTO sps_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisas rangat to, “Sei te saras Vanyo ee?” Vainy faavot te faungis sen Pita tsue na ka, “Tsunaun, u kinai te bau Manyi ser sok Manyi.” ");
INSERT INTO sps_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sen Jisas tsue, “A isen te saras Vanyo, tana saa, Anyo sarei a parits te naus Vanyo.” ");
INSERT INTO sps_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A moun te nat fi nei Jisas te nat en ya naa mito na babasas sa fatukun Ya tsunguruu to moun e Jisas ya tsue of to Jisas matar a fokinai a saa te saras of yan raarav Tsunia na ai to te tsipaar fatabin veesau fi ya. ");
INSERT INTO sps_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisas tsue to tsunia, “Guei Tsiau, a faason tsumanyi tsipaar manyi. Kua mi naa na aaverof.” ");
INSERT INTO sps_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas vegiau kanen nanon ana tsoiny toukuar poo mito numaa ten Jairus sa tsue ten Jairus, “A guei moun tsumanyi te mat en. Fanag pis vaare na Tsoiny Fifaatsuts.” ");
INSERT INTO sps_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sen Jisas nongon en sa tsue of e Jairus, “Vaa'ets vaare, faason tsun ana guei moun tsumanyi te toto fatabin en.” ");
INSERT INTO sps_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nainy te ruak Ya numaa ten Jairus Ya gim to ma famanat iny ta mes ma sof fiisen mi naa Ya sana Ayei nom ere Pita me Jon ai Jemis ana taman ya ai tsinan a kooviou ser sof naa. ");
INSERT INTO sps_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A fokinai na aya kaa iny ugun er ana ri tangis er tana kooviou. Ai Jisas tsue to tsuri “Maangon yam, a kooviou to na gima mat ayei goros tsun non!” ");
INSERT INTO sps_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ri na fokinai oor Towa tana saa, ri nat fi ror nei a kooviou na mat. ");
INSERT INTO sps_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ai Jisas nom to niman ya sa tsue, “Guei Tsiau, tsun!” ");
INSERT INTO sps_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ana aaven ya tabin mito ya tsun fatabin nato ai Jisas tsue of ratuari ma fainy ari ya ta ka ma ainy ya. ");
INSERT INTO sps_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","E taman ya me tsinan ya ngian fiisok er sen Jisas vusvus ratuari ma siisio vavis vaare ri na ka te ruak te kat e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas fikoo vaaguam ir a safunuu ana ina fuan a matisian, ana Ya faan ratuari na parits an gumgum iny buur ravainy masarau an tsipaar a fo viir faadis. ");
INSERT INTO sps_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ya jiat ratuari ma nai favaanan iny ari na Waan e Gov ai tan tsipaar ir vainy faadis. ");
INSERT INTO sps_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ya tsue to tsuri, “Govets vaare yam ta ka fiisen mamimi tana tou tavet: tu tsukan iny taataan tavet, ge ta poraa, ge koinykoiny, ge ta painy moni ge tu fuan tu vau. ");
INSERT INTO sps_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Saf a numaa te fasof maromi ri na, kaa yam tana numaa to aya onot non te naus romi na ngats fan to aya. ");
INSERT INTO sps_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ana saf a vainy te gim ror ma fafasung mami na naus osing yam a ngats fan ana mi te tsue of rari, ‘Kaakaa na yam,’ tafoor yam kuaf mou mami faatok iny non e Gov te nai faan rarorin fasaraa.” ");
INSERT INTO sps_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","U matisian te taainy fo fan vavis ser favaanan iny nan Vurungan Rof ri tsipaar kan raton vainy faadis a kinai tana fo pan te naa naa ri. ");
INSERT INTO sps_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herot a gavana tana gum fan iny Galili te nongoiny a foka te ruak te kat e Jisas ya fapinpin iny Towa tana saa, mesapan te tsue e Jon a Tsoiny Fapeenan te tsun fatabin me tana mat! ");
INSERT INTO sps_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mesapan tsue to e Ilaija te ruak fatabin sana mesapan tsue, a kuigin iny muan te tsun fatabin me tana mat. ");
INSERT INTO sps_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ai Herot tsue to, “Nyo tek govaar a patsuun e Jon, san e sei na mes to aya nan ee to te nonongoiny Ronyo na foka te roruak non?” Ayei te kaa men koman iny tagei fiisok e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","An amaraav tabin mito ser tsue of e Jisas a foka te kat ari. Ya nom ratuari ser naa fiisen mi naa Ya ari patsukaner tana ngats fan te koo ri Betsaida. ");
INSERT INTO sps_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nainy te nongoiny u tagin Ayei te naa en ana ri vovou iny Towa Ya paparaa ramituari Ya tsue of ratuarin a Waan e Gov, Ya tsipaar rato na vainy te komainy ta fifaakouts ");
INSERT INTO sps_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Te tanik iny ruk nana nuaf ana safunuu ana ina fuan a matisian naa mito Tsunia ser tsue, “Jiat ir a vainy ma naa ri tana fo mar fan an tana fo tanun er tsikoo to ta kainy ainy an ta numaa, tana saa a pan to na uur.” ");
INSERT INTO sps_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sen Jisas te tsue tsuri, “Mi patsukanem yam ma faan rari ta kainy ainy.” Ri biny Towa, “Mam kaa tsun mirom a ngim ma koinykoiny ana fuan a jian. Nyi koman maromam ma nai foiny ta kainy ainy nar tagin tovei?” ");
INSERT INTO sps_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Te onots toromainy a ngim a tapan tsoiny te kaa na aya. Jisas tsue to tan matisian Tsunia, “Tsue of ir yam a vainy ma vaagum ari, ngim safunuu tan isisen a gum.” ");
INSERT INTO sps_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","An matisian kat fi to te tsue fi Ya ser fagum rari petoo. ");
INSERT INTO sps_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisas nom to na ngim a koinykoiny ana fuan a jian, Ya matoong fi naa to Gormirmir, sa faarof naa to Gov. Ya ivoo ton koinykoiny sa fafaan iny ya tan matisian ma tatafas rari ri na vainy. ");
INSERT INTO sps_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Fokinai ainy ser viits. An matisian fau to na ainy osing sa onots a safunuu ana fuan a koverok. ");
INSERT INTO sps_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tan sen nainy Jisas faakats to Tsivon an matisian Tsunia naa mito Tsunia, Ya rangats ratuari, “A vainy tsue Varonyo e sei ee?” ");
INSERT INTO sps_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ana ri biny Towa, “Mesapan tsue ror, Anyi Jon a Tsoiny Fapeenan ana mesapan te tsue ror, Anyi Ilaija, ana mes panan tsue ror a isen a kuigin iny muan ovei to te toto fatabin me.” ");
INSERT INTO sps_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Ana mi pas?” rangat fi rari Ya, “Mi tsue Varonyo sei?” Ai Pita biny Towa, “Anyi na Krais ten Gov, a Mes to te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy.” ");
INSERT INTO sps_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ai Jisas vusvus faparits ratuari ma tsue of vaare ta mes tana ka te tsue iny non Ya, ");
INSERT INTO sps_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","sa tsue pis a ka, “A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me ma saraa kamits fatsian nimar tsunaun tana taa Jiu, an tsunaun tan tsoiny faakor, ana rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses, ana ri nai tsugei ror Ya. Ri nai atsuiny famat ror Ya, ai tan fafofopis nan nainy Ayei nai tsun fatabin non.” ");
INSERT INTO sps_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ya tsue to na ka tsuri na fokinai, “Sei na mes te komainy vovou Varonyo ee, ayei ma anofe na tsivon, ayei ma fa'orovus iny a tsivon tan mamatsiny nainy, ana ya te vovou Vanyo, ");
INSERT INTO sps_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","tana saa sei na mes te komainy makok faarof non a toto tsuan ee, nai nun enanon, san e sei te fa'orovus non a toto tsuan ee tan vovou Vanyo nai nom non a toto na suu. ");
INSERT INTO sps_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ta isen ta mes te mauts non a fo masun tana ratsuu iny peto ana toto tsunia te iring a nun enato, fo masun to aya te faakouts fi non ya ma nom a toto na suu? A sikia ovei ");
INSERT INTO sps_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","E sei na mes te rejiaf Varonyo an vegiau Tsonyo ee, vou tana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai rejiaf kan iny non Ya tan nainy te naa minon Ya koman siinaiv Tsunia, an siinaiv ten Taman, an siinaiv tana morena na taabos. ");
INSERT INTO sps_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nyo tsue faman of maromi te kaa miror mesapan te tsutsun ror tovei tabuiny mat ror nai tagei nats ror a Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Voun jian nainy te tsue fakap iny Yan foka to aya, Jisas mei rato ere Pita, ai Jon me Jemis tana tobeer a tou faakats. ");
INSERT INTO sps_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jisas faakats enanon ana nain ya pangis enato, an vau Tsunian faarei ton goseen kafof kakanaf. ");
INSERT INTO sps_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sen tsun ana ina fuan a mes ruak to ser favevegiau fiisen me Jisas, ere Moses ai Ilaija. ");
INSERT INTO sps_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ari te ruak men puan iny Gormirmir kakanaf ser favevegiau tsuk iny mangiir ten Gov te kat iny ruak non ten Jisas te nai mat fi non Ya Jerusalem. ");
INSERT INTO sps_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita an vaatau tsuan mata rari te patang ser kat iny goros er sai te tagun ari, ri tagei ton siinaiv ten Jisas ana ina fuan a mes tsutsun fiisen miror Ya. ");
INSERT INTO sps_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nainy te naus osing a ina fuan a mes e Jisas, ai Pita tsue to Tsunia, “Tsunaun, rof non te kaa fi rora nei, mam ma kat ta fopis ta tovaar, isen Tsumanyi, ana isen ten Moses, ana isen ten Ilaija.” (Ayei gima nat vaarik iny a ka te tsue non ya.) ");
INSERT INTO sps_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ayei vegiau kanen nanon ana koroo ruak to sa pau rari an matisian oraav rato te kookop fi rari na koroo. ");
INSERT INTO sps_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","An vegiau poo mito koroo sa tsue, “Tovei na Guei Tsoiny Tsonyo, a Mes te pisainy Anyo, nongon yam Tsunia.” ");
INSERT INTO sps_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nainy te faonot vegiau, ai Jisas Tsivon kaa kaa to. An matisian kaa faamo mito na ka te tagei ari ser gima tsue of ya ta mes. ");
INSERT INTO sps_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ai tan mes nainy te poo mi ri tan tet ser of me, an tagin kaatsian naa mito ser tainytainy Ya. ");
INSERT INTO sps_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ana mes kuu to fapoopoan nar tagin, “Tsunaun, tagaa, nyo sing marom anyi ma tagaa tana isen tsun a guei tsoiny tsonyo. ");
INSERT INTO sps_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A masarau natiny tutuei non ya, ana ayei te kuu men rorojiainy, ai te gotsiny veesau tsun nanaa petoo sa kat totoroor, an popojiainy te ruak nguen ya natiny fakamits non ya, ana masarau te tsugainy ma naus osing veesau ya. ");
INSERT INTO sps_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nyo sing ir matisian Tsumanyi ma buur ravainy ari ya, sana ri gima onot.” ");
INSERT INTO sps_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas biny ratuari fiisen men seeve, “Amin aatai iny roman min vainy vavaajets an iring! Fis nainy ma kaa fiisen Vanyo mi? An fis nainy ma govets patang fiisen Vanyo mi?” Kat to sa tsue na mes, “Mei me na guei tsuam nei.” ");
INSERT INTO sps_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ai te naa me na guei, ana masarau fagotsiny towa petoo sa kat fatotoroor ya. Jisas tsue ets'ets ton masarau, Ya tsipaar to na guei, Ya faan fatabin iny towa ten taman. ");
INSERT INTO sps_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A vainy a kinai saar fiisok an siinaiv iny Gormirmir ten Gov tagei ari. Fakats tana vainy te atsun fiisok tana fo mamatsiny ka te kat e Jisas Ya tsue to matisian Tsunia, ");
INSERT INTO sps_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Anofe vaare yam a ka te kat iny tsue of maromi yam, tana saa a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai faan iny naa rori nimar vainy te kaa miror a parits.” ");
INSERT INTO sps_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sana ri gima arasan iny a man nan tsue to. Te kainy takop patsukanen tsuri, to ser gima natiny ya, ri oraav to ma rangats Ya ma nat iny arin kifon vegiau to. ");
INSERT INTO sps_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Fapoopoan nar matisian ri kaa men fatsutsue tsian, ri fa'ararat iny e sei tsuri te karap fafis non ee. ");
INSERT INTO sps_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sen Jisas natiny fakats tsuri, sa nom a guei sa fatsutsuiny ya panaan, ");
INSERT INTO sps_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ya tsue to tsuri, “Sei te faakouts non a guei to tana asanga Vanyo ee ayei faakouts Varonyo. Ai sei te faakouts Varonyo ee, te faakouts non e Tamanyo to te jiat Vaminyo. Ai sei te fauf non a tsivon ee fapoopoan namami, ayei te karap fafis non tsumi.” ");
INSERT INTO sps_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon tsue to Jisas, “Tsunaun, mam tagei na mes te buur ravainy masarau tana vainy tana asanga Manyi ana mam tsue tap iny towa tana saa, ayei na sikia ma mes tana gum tsura.” ");
INSERT INTO sps_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sen Jisas te tsue of finy ya nei, “Kat tap iny vaare yam, tana saa a mes te gim non ma veer mami, ayei na vaatau tsumi.” ");
INSERT INTO sps_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nainy tabin ten Jisas unya Gormirmir te sisiruu ename, to sa kaa men fakats parits ma naa Ya Jerusalem, ");
INSERT INTO sps_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","to sa jiat famumuei, a tee tsoiny Tsunia ma mumua naa ri. Ri naus osing to na pan ser naa naa fan tana gum fan iny Samaria ma kakoiny of ari na tou naa me Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sana vainy na aya baainy ma nom Ya, tana saa, Ayei taan fatoobing naa non Jerusalem. ");
INSERT INTO sps_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","U matisian, ere Jemis, me Jon, tagei a ka to ana ri tsue to, “Tsunaun, Nyi koman rarora ma sing guaf iny Gormirmir ma popoon rari?” ");
INSERT INTO sps_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisas takopis to tsuri sa tsue ets'ets rari, ");
INSERT INTO sps_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ana ri naa naa to tana mes a fan. ");
INSERT INTO sps_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Te taataan naa ri sanaan, ana mes tsue to ten Jisas, “Nyo komainy vovou marom Anyi tana fo pan te naa rom Anyi.” ");
INSERT INTO sps_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisas biny towa, “U kas vouts kaa miror matan tsuar tan puputaa, an marei kaa miror sai tsuar, sana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me na sikia ta pan iny fasooiny a patsuun.” ");
INSERT INTO sps_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ya tsue to tana mesmes a mes, “Vovou you.” Sana mes tsue, “Tsunaun, famanat you ma mat tsom e tamanyo ana nyo te kats tsom iny ya, vou nyo te vovou Manyi.” ");
INSERT INTO sps_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisas biny towa, “Tanyir mat ma kats iny arin vainy mat. Sana nyi ma naa, kua favaanan iny a Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ana mesmes tsue to, “Nyo kat iny vovou marom Anyi Tsunaun, san Anyi ma famanat tsom vanyo ma nai tsue nyo na ka, ‘Kaakaa bus yam,’ tana numaa tsonyo.” ");
INSERT INTO sps_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ai Jisas biny towa, “Sikia, ta mes te tanik iny kat non a binun Tsonyo, ai te matoong fatabin fi naa vou tana foka te faravaa iny ya, ayei gim non ma onot faarof ma kat a binun tana Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kat to, ana Tsunaun pisan pis ton mes fits safunuu ana ina fuan a mes, sa jiat na naa ri ina fuan ina fuan er mumua iny naa towa tana fo ngats fan an tana fo fan te kat iny nai taainy non Ya. ");
INSERT INTO sps_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ya tsue to tsuri, “A kainy ainy a kinai tan tanun te matsua raravaa er, san sikia ta vainy binun ta kinai ma agion tanun. Faakats of yam a Tsunaun tana tanun to ma jiats men vainy binun, er agio ton tanun Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Amin tsoiny agio. Kuar bus yam! Nyo jiat ma naa romi tovei tsun faarei rarom tsunei siip fapoopoan nar vainy iring to te faarei raror kas vouts. ");
INSERT INTO sps_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Govets vaare naa yam ta poraa moni, ge tu vio, ge tu suu, ana mi te nak vaare ta mes naa sanaan. ");
INSERT INTO sps_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","An nainy te sof romi ta numaa, mi tsue tsom rom, ‘Aaverof kaa non tsumi te kaa rom numaa to.’ ");
INSERT INTO sps_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","To te koman fi non ta mes a aaverof gagon numaa, rof non tanyi nan tsue tsuam aaverof tsunia, sai te gim non ta mes ma nom tu tsue aaverof, aaverof tabin non tsumi. ");
INSERT INTO sps_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nainy te fasof maromi ri gagon numaa, goros yam numaa to aya onot non te naus osing romi na fan na to aya, sa mi ma goros vavis vaare, tana fo isiseiny numaa vavis, ainy yam ana mi te jiu na ka te faan maromi ri, tana saa a tsoiny binun ma nom tu fifaakouts tan vainy te faakouts ror ya. ");
INSERT INTO sps_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nainy te sof romi gagon tana ngats fan ana ri te fafasof mami, ainy yam a kainy ainy te faan maromi ri. ");
INSERT INTO sps_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ana mi te tsipaar kan ir vainy faadis tana fan na to aya mi te tsue of rari, ‘A Waan e Gov te siruu en pana mami!’ ");
INSERT INTO sps_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sai te sof naa romi gagon koman a ngats fan, ana ri te gima fafasung mami, kua naa yam tana sanaan, ana mi te tsue, ");
INSERT INTO sps_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kaakaa na yam! Kuaf nana ngats fan tsumi te paut mou mamam, mam tegteg ravainy rom ya faatok iny non ami te kat a iring. Sana mi ma fakats faarof, a Waan e Gov te siruu en!’ ");
INSERT INTO sps_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Fakats yam a ka to, tan nainy vaatsuk, Gov nai faan iny nats non a fasaraa na iring tana vainy tana ngats fan to aya, fis nats non a fasaraa te nai faan iny non ya tan vainy pisiin tana fan Sodom. ");
INSERT INTO sps_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Reesik tsian fiisok tsumi na taa Korasin! Reesik tsian fiisok tsumi na taa Betsaida! Mi tagei na fo binun iny faatok te kat Anyo, sai mi gim to ma reesik, mi takopis osing to na fo aveto tsumi. Tabuiny tagei arin vainy vavaajets tana taa Taia ai Saidon a fo binun iny faatok to te kat Anyo tsumi, ri tabuiny vau veesau vau iny ugun tsuar, ai to tan taf a tsivor kuaf, ri gum iny tangis ror faatok raror ri te reesik fiisok ror, ri te takopis osing aveto tsuri. ");
INSERT INTO sps_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tan nainy vaatsuk Gov fasaraa maromi na taa Korasin ai Betsaida fis non a fasaraa te nom ror a taa Taia ana taa Saidon. ");
INSERT INTO sps_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ana mi na taa Kapeniam, mi pon iny rom ma fapaas a tsivom jias Gormirmir? A sikia. Gov nai fakaa maromi petoo unya Hel.” ");
INSERT INTO sps_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas tsue to tan matisian Tsuan, “Sei na mes te nongon maromi ee, ayei te nongon Varonyo. Ai sei te tsugaa maromi ee, te tsugaa kan Varonyo, ai sei te tsugaa Varonyo ee te tsugei non a Mes to te jiat Vaminyo.” ");
INSERT INTO sps_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Fits safunuu ana ina fuan a mes Jisas te jiats rari te tabin fiisen me na mamagat tsian, ser tsue, “Tsunaun mam buur ravainy ir masarau tana asanga Manyi, ri manaats matuamam!” ");
INSERT INTO sps_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisas biny ratuari, “Nyo tagei e Satan te gotsiny me Gormirmir faarei men ubaar. ");
INSERT INTO sps_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nongon yam, Nyo faan maromin gumgum ma tutua mi patsun koraa an aifang, ai mi te fabiu na fo mamatsiny parits vavis tan Vinasaar, an ta ka te gima onot ma kat fifiiring mami. ");
INSERT INTO sps_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sana mi ma mamagat fi vaare nei, u masarau te manaats mami, sana mi ma mamagat tana saa, a asanga mami te kirkir en Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tan nainy to aya u Aaven Taabos te famamagat e Jisas, sa tsue, “Tamau, Tsunaun iny Gormirmir ai nei petoo, Nyo faarof marom Anyi, tana saa, Nyi famuiny vegiau man tan vainy nat an rin vainy te nom nat, sai Nyi faatok iny towa tan vainy babainy te faaman tsun faarei ror guein kakaii. Eye, Tamau, Nyi vovou bus iny mangiir Tsumanyi te paparaa mirom Anyi. ");
INSERT INTO sps_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tamanyo faan bus Vanyon fo mamatsiny ka. Sikia ta mes te natiny non a Guei Tsoiny, san e Taman tsun, ana sikia ta mes te natiny non a Taman, sana Guei Tsoiny tsun ana ri kan ton vainy te pisainy a Guei Tsoiny ma faatok rari Ya Taman.” ");
INSERT INTO sps_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kat to, ai Jisas takopis of ratuarin matisian sa tsue of tsun rari, “Gov faparits maromi, tana saa, mi tagei rom a foka to te natiny tagei romi. ");
INSERT INTO sps_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nyo tsue of maromi, u kuigin kinai an aatouf te komainy ma tagei na foka te kat Anyo, sana ri gima tagei ya, ana ri nongoiny to na foka te tsue Nyo tsumi, sana ri gima nongoiny ya.” ");
INSERT INTO sps_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tan sen nainy ana tsoiny fifaatsuts tan Faun te kirkir iny e Moses naa mito a tou tanaf e Jisas sa tsue, “Tsoiny Fifaatsuts, a saa te kat ronyo na nyo te nom a toto na suu?” ");
INSERT INTO sps_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ai Jisas rangats towa, “A saa te tsuen Faun te kirkir iny e Moses na? Ai fei te gogosias finy anyi ya ei?” ");
INSERT INTO sps_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ana mes biny Towa, “Anyi ma mangiir a Tsunaun a Gov tsumanyi, fiisen men komam faavot, fiisen men aavem faavot, fiisen men a fo parits faavot tsumanyi, ai fiisen men fakats faavot tsumanyi, ana nyi te mangiir fifakokoro tsuam te mangiir finy rom anyi na tsivom.” ");
INSERT INTO sps_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“U tsue tsumanyin toobing,” te biny finy ya Jisas, “Nyi kat fi rom nei aya, ana nyi te nom a toto na suu.” ");
INSERT INTO sps_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","A tsoiny fifaatsuts tan Faun komainy ma fakei a tsivon tana toobing, to sa rangats finy e Jisas nei, “Ai sei na fifakokoro tsonyo ee?” ");
INSERT INTO sps_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas biny towa, “Tan sen nainy a tsoiny Jiu poo fi me tana ngats fan tsian Jerusalem sa ofof fi naa tana ngats fan Jeriko, kat to an vainy kakabuts noov towa ser fious osing ya na foka, ri rapits towa, ser bainy iny ya na matauts. ");
INSERT INTO sps_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tan nainy to aya a tsoiny faakor tana taa Jiu ofof naa sanaan ya tagei to na mes te soon non sanaan, ya fis naa towa sa naa enanaa tan mes panaainy sanaan. ");
INSERT INTO sps_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kat to, ana tsoiny binun ten Gov, a tsoiny Livai, vovou kan iny me naa sanaan to aya, sa tagei na mes, kat to sa fis naa ya, tan mes panaainy sanaan. ");
INSERT INTO sps_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","San a mes, iny Samaria sikia ma tsoiny Jiu, ayei kan te taan me tana sanaan to aya, sa ruak tana mes to aya. Ya tagei to na mes to aya, ana koman ya reesik fiisok towa. ");
INSERT INTO sps_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ya taan fasiruu naa to tsunia, ya tsiiu to na fo tageev a tapui an wain, ya pau towa, ya kat to sa govets a mes sa fagum ya tana dongki tsunia, ya mei naa towa tana isen a numaa tana vainy ruak, sa tagaa ot iny ya. ");
INSERT INTO sps_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tan mes nainy ya nom to na fuan a silva moni sa faan iny ya tana mes te tatagaa ot iny a numaa iny ruak, ya tsue to, ‘Tagaa ot iny rom anyi ai te tabin fi mironyo nei, nyo biny rou a fis te faan of anyi ya.’” ");
INSERT INTO sps_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ai Jisas fakap to sa tsue tana tsoiny fifaatsuts tan Faun, “Saf fakats tsumanyi na, ai sei ta isen tsuri tana ina pis to ee, te mangiir famainy a fifakokoro te tafisuan tan vainy kakabuts ee?” ");
INSERT INTO sps_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ana tsoiny fifaatsuts tan Faun biny Towa sa tsue, “A mes to te koma tagtag iny ya.” Ai Jisas biny towa sa tsue, “Kua ana nyi te kat fi to aya te kat fi na mes to.” ");
INSERT INTO sps_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas an matisian Tsunia taataan naa tana sanaan te naa naa ri, Ya toobing naa to tana isen a fan te kaa non a moun te koo rori Mata, sen Mata fafasof faarof naa Ya numaa tsunia. ");
INSERT INTO sps_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ayei kaa me na famuinyasiny tsunia, asangan ya Meri. Meri nai gum mito petoo panan a moun a Tsunaun, sa vanongon tana fo fifaatsuts Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sai Mata kaa men fakats kinai tana fo binun tsian te kat ya tan kakoun a kainy ainy. To sa naa ten Jisas sa tsue, “Tsunaun, e famuinyasiny tsonyo te naus vaminyo to, tsonyo tsivou tsun kakoun a kainy ainy. Anyi toroman gima tagaa fanatnat iny a ka to ge? Anyi ma tsue of ya ma naa mi ya a faakouts vatuanyo.” ");
INSERT INTO sps_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sana Tsunaun biny ya sa tsue, “Mata, Mata, koma manyi te atsun fiisok sa fareesik manyi tana ka na kinai fiisok, ");
INSERT INTO sps_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","sana isen a ka tsun te aaruts iny rom anyi, Meri pisainy a ka na rof pis, sana sikia ta mes te onot non ma nom ravainy a ka to aya tsunia.” ");
INSERT INTO sps_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tan sen nainy Jisas faakats to tana isen a pan. Te faakats fakap Ya, ana isen a matisian Tsunia tsue to Tsunia, “Tsunaun, Anyi ma faatsuts mamam tan kat iny faakats to te faatsuts finy e Jon matisian tsuan.” ");
INSERT INTO sps_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ai Jisas tsue to tsuri, “Nainy te faakats romi, mi ma tsue na ka, ‘Tamamamam, Asangam Manyi ma kaa iny taabos, Waam Manyi ma naa me. ");
INSERT INTO sps_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Faan mamimam a kainy ainy tan fo isiseiny nainy te onot maromam roman. ");
INSERT INTO sps_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nyi te anofe ravainy a fo aveto tsumam, faarei mam te anofe ravainy a fo aveto te kat a mesapan tsumam. Fatamee vaare mamimam tan fiamus.’” ");
INSERT INTO sps_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ai Jisas tsue to tan matisian Tsunia, “Sana isen fapoopoan namami ma kaa me ta vaatau ana ayei te naa numaa tsunia tana rot iny voiny, ana ayei kuu naa to tsunia, ‘Vaatau, faan tsom you tu fopis tu koinykoiny, biny ronyo, ");
INSERT INTO sps_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","a mes a vaatau tsonyo te naa me a tou vavis te see ruak tsun non numaa tsonyo, sana nyo na sikia ta kainy ainy iny fa'ainy ya.’ ");
INSERT INTO sps_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","sana mes tuwa gagon koman a numaa tsue me, ‘Fasasapam vaare you, u matainy sobaa te sisiots en, an guei tsonyo te goros fakap er. Nyo gim rou ma onot ma tsun nyo te faan manyi ta ka.’ ");
INSERT INTO sps_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ana saa pis? Anyo tsue of maromi, kainon to te gima tsun fi ya, a faan matuami tu koinykoiny tana saa, ayei a vaatau tsumanyi, sana ayei te tsun me na ree'ats ya faan matuami na foka te komainy romi, tana saa, anyi te gim rom ma rejiaf, a faunots ton sing maamaa Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“To Tsonyo tsue rou tsumi tan kat iny faakats, rangat ai Gov te nai faan mami, mi ma sainy Ya ai mi te nai sab Ya, mi ma tegteg tan matainy sobaa ai Gov te nai pue of mami, ");
INSERT INTO sps_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","tana saa fokinai te rangat ror ten Gov, ri natiny nom ror ya, ai sei te san non ee, ayei sab non Ya, ai tsunia te tegteg non, Gov nai pue of non ya. ");
INSERT INTO sps_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","E sei tsumin fo taman ee to te sing ror guei tsumi ta jian, ana mi te faan rari na koraa? ");
INSERT INTO sps_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ge to te sing rori ta tag, mi faan rarori ta suu? ");
INSERT INTO sps_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kainon tsumin taman te natiny kat rom aveto sana mi natiny faan iny rom a foka na fo rof tan guei tsumi mi ma nat faman fi nei, e Tamamami te kaa non Gormirmir te gim non ma natiny kat aveto nai faan iny non Aaven Taabos to tana vainy te sing ror Tsunia!” ");
INSERT INTO sps_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas buur ravainy a isen a masarau te tutuei a mes sa baaruu ya gim to ma vevegiau. Te tafuts fakap masarau ana ya tanik iny vegiau fatabin to. A vainy te tagei ya ri saar fiisok rato. ");
INSERT INTO sps_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sana mesapan tsuri na vainy tsue, “Ayei natiny buur ravainy non masarau, tana saa Belsibul a tsunaun tan masarau te fainy Ya na parits iny kat a foka to.” ");
INSERT INTO sps_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mesapan tsuri komainy to ma fataraatsua Jisas, ser rangats Ya ma kat Ya ta isen ta ka iny faatok to te kat famainy fi non Ya na binun ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sen Jisas nat faamuan iny fakats tsuri sa tsue of rari, “A vainy tana isen a gum fan te takibaa ror tana fuan a pan ri te fataatsun, a gum fan to aya nai iring raror, ge na vainy tana isen a numaa nai takibaa ror tana fo gum ri te fataatsun nai taruraa raror. ");
INSERT INTO sps_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ai te takibaa ror a vainy ten Satan tana fuan a pan er fataatsun to nai taruraa eraror tovei tsun. Ami te tsue na ka, Nyo natiny buur ravainy rou masarau tana parits ten Belsibul a tsunaun tan masarau. ");
INSERT INTO sps_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Te man fi non ya, e Belsibul natiny faakouts Varonyo ana Nyo te buur ravainy masarau, e sei pas te natiny faakouts non panaan tsumi ee, to ser natiny buur ravainy ror masarau? A vainy tsumi patsukan te faatok iny ror a fo iring tsumi. ");
INSERT INTO sps_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","San e Gov patsukan te faparits Varonyo to Tsonyo buur ravainy rou masarau, to aya na ka te faatok maromi na Waan e Gov te naa bus name tsumi. ");
INSERT INTO sps_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nainy te kaa minon a mes a parits a foka iny puaan tsuan a kakoun onot, a bei ot iny to na numaa tsuan fo mamatsiny ka tsunia kaa faarof ror. ");
INSERT INTO sps_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sana mes a parits fafis te ruak non ai te fataatsun me na mes a parits to, ai te faduen ya, ayei nai nom fakap non a fo mamatsiny tek ana fo kirat iny puaan to te saasaar mi ya. Ayei nai tatafas iny non a fo mamatsiny ka tana fo vaatau tsunia. ");
INSERT INTO sps_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","A mes a gima vaatau Tsonyo ayei te iring Varonyo, ai sei na mes te gim non ma faakouts Vanyo ma favaaguam ir a vainy ee ayei kat raror a vainy ma bus vavakas ari.” ");
INSERT INTO sps_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisas tsue pis to na ka, “Nainy te tafuts osing non a masarau a mes, masarau to ayei naa vavis non tana pan a parak a uur a tsikoo vavis to ta pan ma favusuan ya. Te gim fi non ya ma sab ta pan, ya te tsue na ka, ‘Kainon, nyo ma tabin you tana numaa te naus osing mi nyo.’ ");
INSERT INTO sps_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nainy te ruak ya tana numaa, ya tagei to na numaa na fifio vatsvats, ana foka te kaa faarof tsun ror. ");
INSERT INTO sps_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ya te naa, a nom pis miton a ina fits a masarau ngi'arapaar fafis pis iny ror ya, er kaa to na aya. Ana mes to aya te nai nun fapinpin ovei yen fis non a fo nun te kaa mi ya muan.” ");
INSERT INTO sps_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Te tsue fakap iny e Jisas a ka to tana vainy faavot, ana moun fapoopoan nara vainy kuu mito sa tsue, “Gov faparits non a moun to te faagiir Manyi ya fasus Matuanyi.” ");
INSERT INTO sps_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ai Jisas biny towa, “Te rof pis non tan tsue fi nei, ‘Gov faparits non vainy te nongoiny vegiau Tsunia ser manaats ya.’” ");
INSERT INTO sps_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A vainy kinai farokot naa kaner rame ten Jisas, Ya tsue to tsuri, “Amin vainy tan nainy roman, min ngi'arapaar tana saa mi rangat Varonyo ma kat kainy faatok ma nat fi mi nei Nyo kat rou a binun ten Gov, sana sikia ta ka ta foun iny faatok mami sana ka te ruak tsun ten Jona na kuigin muan. ");
INSERT INTO sps_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","A ka te ruak ten Jona na kuigin faarei non a kainy faatok tana vainy Ninive, jesan kan a ka te nai ruak non Tsonyo, na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me faarei non a kainy faatok tana vainy tan nainy roman. ");
INSERT INTO sps_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tan nainy vaatsuk ten Gov Muiny Aatouf tana gum fan iny Siba tana ainysat iny vou nai tsutsun non tan vaatsuk ai te pokei aveto tsumi tana saa a muiny Aatouf to te poo fi me veevian a tou nongon tana fo fifaatsuts rof ten Solomon a Aatouf a mes a nat, sai te kaa minon a mes fapoopoan namami te karap fafisfis pis iny non e Solomon sana mi gima nongoiny Ya am faarof Towa. ");
INSERT INTO sps_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tan nainy vaatsuk ten Gov taa Ninive nai tsutsun ror tan vaatsuk ana ri te pokei aveto tsumi, tana saa, taa Ninive te takopis osing a fo aveto tsuri te nongoiny fi ri te favaanan fi Jona. Sai te kaa minon a mes fapoopoan namami te karap fafisfis pis iny non e Jona ana mi gim to ma nongoiny kainy Ya am takopis to.” ");
INSERT INTO sps_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Sikia ta isen te fakuruiny non kurun ya te famuiny ya ge fakei ya fain kobuu, a sikia, ayei fakei non ya patsun a taran, ma fa'arasainy ya na vainy te naa miror gagon numaa. ");
INSERT INTO sps_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A mata manyi te faarei non arasan tana pua manyi. Nainy te arasan fi non a mata manyi, pua manyi faavot arasan faavot non, san nainy te kio non a mata manyi, a pua manyi uurup ovei nanon. ");
INSERT INTO sps_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tanamots, u arasan gagon tsumanyi ma ruak iny uurup vaare. ");
INSERT INTO sps_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","To te kaa faavot minon a pua manyi na arasan, ana sikia ta pan ma kaa tana uurup, a pua manyi kaa non tana arasan faarei tsuiny non kurun tan lam te nang non tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nainy te fakap e Jisas tana tou favaanan ana tsoiny Farasi faan iny ton vebus Tsunia ma ainy fiisen mi ya, kat to sa sof naa, Ya gum iny ainy to. ");
INSERT INTO sps_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A tsoiny Farasi karian te tagei finy ya Jisas gima garus tsom a niman vou Ya te ainy. ");
INSERT INTO sps_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kat to ana Tsunaun tsue to tsunia, “Ami na taa Farasi natiny togas faarof tsuiny rom a puan a gotan an kofeer, sana koma mami via minon kat iny nom ka na kinai, ana fo kat iny ngi'arapaar. ");
INSERT INTO sps_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Min vainy piou, Gov gima kat tsuiny a pan jiarasan, sana Ayei kat kainy a pan gagon. ");
INSERT INTO sps_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sana mi ma faan iny a foka fiisen men fakats kaamos tsuam tsuri te aaruts ror kainy faakouts rari, mi kat fi rom nei, an fo mamatsiny ka tsumi te kaa iny kaamos me. ");
INSERT INTO sps_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ma sekee, min Farasi, taatag yam! A fo mamatsiny mar moros ana fo viir peroo ana fo mamatsiny fua nan tanun mi natiny kat rom a ar safunuu na pan ana isen a pan of e Gov, kat to ayan rof an toobing sana mi baainy rom kat tavaron iny kat senviir kat tana vainy faavot, an kat iny mangiir e Gov. Faun tan faan iny a isen a pan tan fasafunuu nana pan ten Gov mi gim rom ma natiny anofe ya san tan kat kainy a fo mes a fo faun. ");
INSERT INTO sps_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ma sekee, ami na Farasi, taatag yam! Mi komainy fiisok rom ma gum tan gumgum matan tana numaa iny fafaatouf, ana mi komainy rom a vainy ma fatsiitsii mami er favoinyvoiny matuami tana pan iny tuan. ");
INSERT INTO sps_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ma sekee, taatag yam! Mi faarei rom katskats te gima kaa me ta kainy faatok, ana vainy taan tsun ror patsun ya gim ror ma natiny ta ka gagon, jesan vainy gim ror ma natiny a koma mami te via minon ngi'arapaar, ri te tsue, mi rof tsun rom.” ");
INSERT INTO sps_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Isen a tsoiny fifaatsuts tan Faun te kirkir iny e Moses te tsue na ka Tsunia, “Tsoiny fifaatsuts, nainy te tsue Nyi na ka to, Nyi tsue fifiiring kan matuamam.” ");
INSERT INTO sps_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisas pangis towa, “Ma sekee, min tsoiny fifaatsuts tan Faun, taatag yam! Mi natiny fapatang rom a vainy ma vovou fo kat tan tsuvumami faarei non a ong a patang googo rari sana mi sikia vaarik rom ma natiny faan iny a nimam tan faakouts rari. ");
INSERT INTO sps_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ma sekee, taatag yam! Mi to te natiny kat faarof ovei tsuiny rom a fo katskats tana fo kuigin, ton kuigin te atsuiny tsuvumami muan. ");
INSERT INTO sps_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ami patsukanem te pokei ya, to tsumi faarof fo kat te kat tsuvumami muan, tana saa, ri atsun ir kuigin ana mi kat to na foka tan katskats tsuri ma mamatainy rof ya. ");
INSERT INTO sps_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tana ka tsun to aya, a nat a karap ten Gov te tsue iny ya muan, ‘Nyo nai jiats miroun fo kuigin an amaraav ma govet vurungan Tsonyo tana vainy, ana ri te nai atsun famat ir a mesapan, ana ri te nai fakamits ir a mesapan.’ ");
INSERT INTO sps_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tan kat to aya min aatai iny roman, mi tsun bus nai ong rom a patang nan rafatsiny nar a fo kuigin to te atsun famat muan tana tatanik tana monaagits tovei, ");
INSERT INTO sps_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","te tanik me tan rafatsiny te atsun famat ari Ebol sa naa naa, ya onot to tan rafatsiny te atsun famat ami Sakaraia, to te atsuiny ami fapoopoan nana pan iny fatsung fafaatouf ana pan a taabos a pan ten Gov. Eye, Nyo tsue of maromin aatai iny roman, fasaraa nan fo vainy to nai onot enanon tan aatai iny roman. ");
INSERT INTO sps_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ma sekee, min tsoiny fifaatsuts tan Faun, taatag yam! Mi nom tap fiisok iny rom a popue kainy puen pingping nana numaa iny nom nat ten Gov, to tsumi patsukanem yam gim rom ma onot ma sof naa gagon, ana mi kat tap rarori to te tanaf iny sof ror gagon.” ");
INSERT INTO sps_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nainy te naus osing e Jisas a pan to aya, an tsoiny fifaatsuts tan Faun ana Farasi tanik iny faveerveer mito Jisas, ri rangats Towa na fo tsue iny rangat nana fo mamatsiny ka, ");
INSERT INTO sps_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","a tou tanaf iny fataraatsua Ya, ma nom ari ta iring tan vegiau te tsue iny non Ya, to ser fakei Ya tan vaatsuk. ");
INSERT INTO sps_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jisas vegiau koraa kanen nanon an kinai tapan vainy tan tsoiny an moun nai vaaguam mito ser fapanpan ir, ri pitei ton mour a mesapan. Jisas vegiau faamuan to tan matisian Tsuan sa tsue, “Tatanamots yam ton yis tana taa Farasi, iton kat mapam tsuri, ai ton vegiau tsuri an kat tsumi gima senviir. ");
INSERT INTO sps_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A fokan takop nai tapokaa eraror ana fo famun nai natiny rori. ");
INSERT INTO sps_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","An vegiau te tsue nyi na tana uurup, nai tapokaa non, ri te nongoiny ya tana arasan, ana saa te fasisiraa iny ari tan teinar vainy na, tana pan a sisiot, nai kuu pokei rori jiarasan, ma nongoiny yan vainy.” ");
INSERT INTO sps_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“U vaatau Tsiau, oraav vaare ir yam te atsuiny famat fi rorin puainy mes, ai vou ri gim ror ma kat pis ta ka, ");
INSERT INTO sps_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","sana nyo tsue of maromi na mes ma oraav ami. Ami ma oraav tsuiny e Gov, te kaa minon a parits iny atsun puan ai te ravainy mami tan guaf Hel. Nyo tsue fatoobing rou tsumi, ami ma oraav tsuiny e Gov! ");
INSERT INTO sps_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Mi onot rom a foiny ta ngim ta tsutsupii tana fuan a takep moni tsun, sai Gov gim non ma onot ma anofe ta isen ta tsutsupii. ");
INSERT INTO sps_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Te faarei non funuu to patsuu mami Gov te kaa bus me na as'as narari. Jio, oraav vaare yam, mi karap fafis pis iny rom fokinai tsutsupii!” ");
INSERT INTO sps_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nyo tsue of maromi, e sei te pokei Varonyo te fasito iny rou ya matar a fokinai ee, Nyo, na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, nai kat fi kan rou jesan tsunia matar morena ten Gov, ");
INSERT INTO sps_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","sen sei te faungis Varonyo matar a fokinai ee, a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, nai faungis kainy non ya matar morena ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“E sei na mes te tsue vaaserere iny non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me ee, Gov nai anofe ravainy non ya, san e sei te aar'aar fifiiring non Aaven Taabos ee, Gov sikia non ma anofe ravainy oiny ya. ");
INSERT INTO sps_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nainy te mei marom anyi ri tan vaatsuk tana fo numaa iny fafaatouf ge matar gamaman an tan mes tsoiny mumua, fakats fakinai vaare yam, fei te nai tsue fi rom anyi ei, kainy kat tap manyi, ge a saa te tsue rom anyi na, ");
INSERT INTO sps_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tana saa Aaven Taabos tsun nai faatsuts marom anyi tan nainy to aya tana saa te nai tsue rom anyi na.” ");
INSERT INTO sps_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A mes koman tagin te tsue na ka ten Jisas, “Tsoiny Fifaatsuts, tsue of e famuinyasiny tsonyo ma kibei amam a foka fapoopoan namamam, ito na foka te mat osing e tamamamam sa naus osing ya tsumam.” ");
INSERT INTO sps_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisas pangis towa, “Tsoiny ka, sei te faan Vanyo tu tsue iny kat vaatsuk ee, ge tan kibei a fo mamatsiny ka fapoopoan namami na ina fuan ee?” ");
INSERT INTO sps_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kat to ai Jisas tsue na to tsuri na fokinai, “Taatag yam, tanamots faarof yam a tsivom tan mataguas iny a fo mamatsiny ka, tana saa a toto tana mes gim non ma kaa tsun tana fo mamatsiny ka te fasito iny non ya, kainon te kaa fi minon ya na masun.” ");
INSERT INTO sps_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kat to ai Jisas tsue of ratuarin tsue fapapaar to, “A mes a masun te kaa me na painy puputaa te kaa minon a fua na rof a kinai. ");
INSERT INTO sps_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ya kaa miton fakats koman, ‘Anyo na sikia ta pan iny fakei a fo mamatsiny fua tsonyo, a saa te kat ronyo na? ");
INSERT INTO sps_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","I tovei na ka te kat ronyo, nyo des rou a fo numaa iny fatamaar nana fo kainy ainy tsonyo ana nyo te fatsuiny fo numaa iny fatamaar buiny tamuk, ana nyo te guam a fo fua, ana fo kainy ainy, ana fo mamatsiny ka tsonyo koman a fo numaa iny fatamaar to aya. ");
INSERT INTO sps_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ana nyo te tsue na ka tana tsivou, Mananyo patsu, kaa mirou a fo mamatsiny kan rof onots non ma nom a ingainy a kinai. Nyo kainy paapou tsun bus rou. Nyo te kat a kainy ainy an jiu tan mamatsiny nainy iny paparaa tsun me.’ ");
INSERT INTO sps_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sen Gov tsue fi nei tsunia, ‘Anyi na mes a piou, tana voiny tsun to aya toto tsumanyi naus marom anyi, ai sei nai fasito iny non fo mamatsiny ka te fasito iny anyi ee?’” ");
INSERT INTO sps_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ai Jisas fakap ton vegiau Tsunia, sa tsue, “Te kat fi nats non ya tsuri na vainy te mawats of ror a tsivor a fo mamatsiny ka, san ari te kaa iny aaruts ovei ror matan e Gov.” ");
INSERT INTO sps_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisas tsue to tan matisian Tsunia, “Sana Nyo tsue of maromi, koma patang vaare, fei nom romi na kainy ainy ma toto mi ei, ge na fo raarav nana pua mami. ");
INSERT INTO sps_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Fiisia! A toto gim non ma fis pis a kainy ainy, ge puainy mes te gim non ma fis pis a fo raarav. ");
INSERT INTO sps_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tagaa yam tan au'au; ri gim ror ma reev tu fua, ge ma natiny agio, ge farosoo faavots rari tana numaa iny fatamaar ge ta pan iny fakaa masun, sen Gov natiny fa'ainy rarori. Sana mi na vainy faavot, mi rof fafis rarom marei faavot. ");
INSERT INTO sps_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sei tsumi ito tan koma patang te onot fi rori ma sumainy a toto nar tan ta fo ar nainy ee? A sikia ovei! ");
INSERT INTO sps_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Koma patang gim non ma onot tan faakouts vaarik manyi tan nom ta ka, sa kat fei tsumanyi fakats fiisok rom ei? ");
INSERT INTO sps_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tagaa yam tan fo sisinaan vouts te gian fi rori, te gim ror ma kat a binun ge kat a fo raarav tsuar. Sin tovei Nyo tsue of maromi, tana Aatouf E Solomon, a mes a masun, te gim kan ma kaa me tu fo vau tsuan saavits faarei non isen tsurin sisinaa tovei. ");
INSERT INTO sps_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","E Gov tsun kat fasaavits raror fo sisinaa vouts to, sisinaa gian ror roman, ai tamanainy ri te maas, er kurun ravaa to. Fiisia, Ayei gim non ma makok faarof mami? Amin vainy te kaa mirom a faason a kakaii! ");
INSERT INTO sps_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Fagum vaare yam koman tsumi tana saa te nai ainy romi ge jiu romi na, fakats fakinai vaare yam a fo mamatsiny ka to aya. ");
INSERT INTO sps_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vainy vavaajets tana monaagits tovei komainy fiisok ror ma kaa me na foka fi nei. San e Tamamami natiny non fo mamatsiny ka te aaruts iny romi. ");
INSERT INTO sps_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sana mi ma fagum tsom fakats tsumi tana Waan Ya, ana Ya te see fafaan iny a fo mes a foka to tsumi.” ");
INSERT INTO sps_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ami na tee veis siip u kakaii, oraav vaare yam, tana saa, e Tamamami te kaa minon a paparaa, tan fafasof mami tana Waan Ya. ");
INSERT INTO sps_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ami ma fiifoiny iny a fo mamatsiny ka tsumi, ana fo painy moni faan iny romi tan vainy aaruts, tan kat to aya mi farosoo rom a masun iny Gormirmir to te gim ror ma natiny iring, ai te gim ror ma natiny kap, an vainy kakabuts kan te gim ror ma fasiruu naa, an peesum ma kat fifiiring rari. ");
INSERT INTO sps_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tana pan te kaa non fo masun tsumanyi, a pan nato aya u koman tsian tsumi te kaa non tsunia. ");
INSERT INTO sps_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kakoun onot, farots raarav tsuam, an lam tsumanyi ma kurun onot kan nyi te anaanos, ");
INSERT INTO sps_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","te faarei ror u tsoiny binun te anaanos ror a tsunaun tsuri te tabin os mito poo minon tan guainy nan fanging. Nainy te naa minon ya ana ayei te tegteg ana ri te veesau tsun tan pue of yan pingping. ");
INSERT INTO sps_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Paparaa tsian fiisok tan tsoiny binun te tabin fi minon a tsunaun tsuri, ya te sab rarin kakoun an tagun. Nyo tsue faman of maromi ayei patsukan te faraarav non a tsivon, u raarav iny binun ya te root tap iny yan vakiri, ana ya te tsue of rari ma gum ari tana taran iny ainy, ana ayei patsukan te fa'ainy rari. ");
INSERT INTO sps_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Paparaa tsian fiisok tan tsoiny binun to te naa fi minon a tsunaun ai te sab ir vainy binun tagun an kakoun, kainon to te vegits ovei fi minon ya, tana rot iny voiny ge patsuu na nainy. ");
INSERT INTO sps_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ami gima anofe na ka tovei, tabuiny natiny non a mes tana numaa u nainy te naa minon a kakabuts, ayei onot non ma fasakaa tap iny a mes a kakabuts ya te gima onot, a boree to na numaa ana ya te sof naa gagon. ");
INSERT INTO sps_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ami kan ma kakoun onot, tana saa, a sikia ta mes te natiny non nainy, an saf nainy to te ruak minon a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me na, tan nainy te gim romi ma naano Ya te tabin fi minon Ya.” ");
INSERT INTO sps_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ai Pita tsue to, “Tsunaun, tsue fapapaar to te faan iny Anyi, ka tsumam ge ka tana fokinai?” ");
INSERT INTO sps_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ana Tsunaun biny towa, “Nyo tsue tsuk iny rou viir vainy vavis tana tsoiny binun ge muiny binun a suu ana nat a rof. Ayei faarei non a tsoiny binun to te pisainy a tsunaun tsunia ma tatagaa ot faarof ir yan mes panainy vainy binun ma tatafas rari ya na kainy ainy tana fo nainy fatoobing. ");
INSERT INTO sps_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Paparaa tsian tana tsoiny tatagaa ot to te sab finy non ya na tsunaun tsunia te kat finy non yan kat to te naa fi minon ya fan! ");
INSERT INTO sps_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Man ovei, Nyo tsue of maromi, a tsunaun tsunia nai fagum non ya a faarei to na tsoiny tatagaa ot tana fo mamatsiny ka tsunia. ");
INSERT INTO sps_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sai to tsunia na tsoiny tatagaa ot a pisiin, ayei tsue non tana tsivon, ‘A tsunaun tsonyo gim non ma veesau fatabin me,’ ana ayei te tanik iny rapits ir mes panair vainy binun tsurin tsoiny min moun ya te ainy ana ya te jiu ya te mafuu en. ");
INSERT INTO sps_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ana tsunaun tana tsoiny binun to aya te tabin fatabin pis me tan ta fo nainy te gim finy non ya ma naano ai tan nainy kan te gim non ya ma kakoun of. A tsunaun nai tektek mormor non ya, ana ayei te fagum ya tana pan iny fasaraa ma kaa fiisen mi yan vainy vavaajets.” ");
INSERT INTO sps_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jisas fa'arasainy man nan tsue fapapaar, “A tsoiny binun te natiny non a binun te komainy non a tsunaun ayei ma kat ya, sana ayei te gima komainy kat a ka tan koman tana tsunaun tsunia, te nai rapits fatsiainy fiisok rori ma saraa ya, ");
INSERT INTO sps_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","sana tsoiny binun te gim non ma natiny a sa te komainy non a tsunaun na, te rapits faonots tsuiny rori, tana iring te kat ya. Jesan Gov faan iny non a nat iny kat a binun ten sei ma kat a binun ee, Ayei naano non a mes ma kat a binun a tavaron. Ge e Gov faan iny non a nat tsian iny kat a binun ten sei ma kat ee, Ayei naano non a mes ma kat a binun a tavaron fiisok ana suu. ");
INSERT INTO sps_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Anyo of me nei petoo ma atoiny mi Nyon guaf, ana Nyo komainy rou guaf to aya ma akoor busen. ");
INSERT INTO sps_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sana Nyo ma nom tsom a kamits tsian tabuiny nom ronyo, to sana koma Vanyo patang fiisok tsun non, onot non te kap non ya. ");
INSERT INTO sps_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pon fi vaare yam nei, Nyo naa me ma fakap Anyo na fo puaan nei petoo. A sikia ovei, Nyo tsue of maromi, Nyo na tou kat ir a vainy ma takibaa ri. ");
INSERT INTO sps_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tovei roman an tana fo nainy te naa minon, to te kaa fi ror a ina ngim tana isen a numaa, ri nai takibaa ror tana fuan panaan, ina pis nai koma iring raror a ina fuan, tana saa, ri te faaman Vanyo, ge ina fuan nai koma iring raror a ina pis. ");
INSERT INTO sps_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ari nai takibaa nats ror, u taman nai koma iring raror u guei tsoiny, tana saa, ri te faaman Vanyo, ge u guei tsoiny nai koma iring raror tamar, an tsinar nai koma iring raror u guei moun, tana saa, ri te faaman Vanyo, ge u guei moun nai koma iring raror tsinar, an muiny nyanabeir nai koma iring raror nyanabeir guei moun, ge nyanabeir guei moun nai koma iring raror muiny nyanabeir, tana saa, ri te faaman Vanyo.” ");
INSERT INTO sps_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ai Jisas tsue to tan tagin, “Te tagei romi na koroo te paas fi minon ya tan panainy kabas, mi tsue veesau tsun rom, ‘Te kat iny ruat non,’ sa man non te natiny ruak non. ");
INSERT INTO sps_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","An nainy te taf non a ainysat iny vou, ami natiny tsue rom, ‘Te nai fisikii non,’ sa man non te nai ruak non. ");
INSERT INTO sps_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Amin kat mapam, mi onot rom ma tsue fa'arasainy tou tatagaa tsumi tan petoo an tana korosuu, sana mi gim rom ma onot ma tsue fa'arasainy a foka te tagei romi te kat Anyo tan nainy roman! ");
INSERT INTO sps_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kat fei tsumi patsukanem gim rom ma faaroiny faarof tsom a tsivom ei, tana saa te tavaron non na? ");
INSERT INTO sps_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Te komainy fakaa marom anyi ta mes tan vaatsuk, fatoobing yam vegiau te kaa fi minon ya tu nainy, te mataanis fi non nainy iny vaatsuk, kat non sana mes to ayei fakei manyi tana tsoiny vaatsuk, ana tsoiny vaatsuk te faan ma naa nyi nimar kokokof, ana kokokof te fasof manyi tana numaa iny kotskots. ");
INSERT INTO sps_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nyo tsue of marom anyi te gim fi rom anyi ma biny a fo tavan tsuam, nyi gim rom ma naus osing a numaa iny kotskots.” ");
INSERT INTO sps_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tan nainy to aya, te kaa men mes vainy te siisio of e Jisas tana vainy Galili te naa tana ngats fan tsian iny Jerusalem a tou kat faakor ten Gov tana saape, ai Pailat, a gavana tana gum fan iny Judia, tsue of ton vainy puaan tsunia ser atsun famat rari. Vainy puaan kat, kat to tan nainy te kat faakor ari ten Gov, ser sovaar men rafatsiny narari fiisen men rafatsiny nar marei sensen. ");
INSERT INTO sps_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ai Jisas biny ratuari, “Mi pon fi rom nei, vainy Galili te mat er, te kat aveton kinai te fis non a mesapan tsuri na taa Galili, ana ka to aya na kifon a fo iring te ruak tsuri? ");
INSERT INTO sps_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sikia ma ayei, nyo tsue fatoobing of maromi, to te gim fi romi ma reesik am takopis osing to na fo aveto tsumi, ami kan nai nom rom a mat a suu. ");
INSERT INTO sps_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kat fei tana safunuu an ina jian a mes mat te tarop a numaa na viviakoo tana pan iny Siloam ee? Mi pon fi rom nei, aveto tsurin kaatsian fis non aveto tan mes a vainy te kaa ror Jerusalem? ");
INSERT INTO sps_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nyo tsue faman of maromi, a sikia. To te gim fi romi ma reesik am takopis osing to na fo aveto tsumi, ami kan nai nom rom a mat a suu.” ");
INSERT INTO sps_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ai Jisas tsue of ratuarin sen tsue fapapaar, “A mes te kaa men sen nau, u Fig te reev ya tan tanun tsunia. Sa naa tan tanun a tou tagei tu fua nan nau. Sai te gima sab tu fua. ");
INSERT INTO sps_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ya kat to sa tsue of a mes te tatagaa ot iny tanun. ‘Tagaa, fopis a ingainy ovei te naa mi nyo nei, tou tagei tu fua nan nau Fig, tsonyo gima tagei vaarik tu fua patsun nau. Anyi ma tek fagotsiny ya, kat fei sa fakap babainy tsuiny non a kainy ainy tan puputaa ei?’ ");
INSERT INTO sps_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sana tsoiny tatagaa ot iny tanun biny ya sa tsue Tsunaun, ‘Rof non, ma fakei tsom ya, a kaa tsom to na isen a ingainy. Nyo nom rou a nungan, nyo te kats iny ya gagon kifon nau. ");
INSERT INTO sps_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Te fua fi non ya tana ingainy te naa minon, te rof non. Sai te sikia non ya, nyo tek fagotsiny rou ya.’” ");
INSERT INTO sps_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tan sen Nainy Fafaatouf tana taa Jiu ai Jisas faatsuts to tana numaa iny fafaatouf. ");
INSERT INTO sps_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A isen a moun te kaa kan ayei na sofsof iny masarau, sa kat ya sa kaa me na faadis tana safunuu ana jian a ingainy. A faadis te kat ya sa kokoboo ovei en, sa gima tsutsun fatoobing vaarik tan tu nainy. ");
INSERT INTO sps_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nainy te tagei e Jisas a moun, Ya fikoo towa ma naa mi ya Tsunia, Ya tsue to tsunia, “Muiny ka, nyi tapuruur em tana faadis tsuam!” ");
INSERT INTO sps_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ya fasaur to na niman tsunia, sen tsun ana moun tsutsun faparoor to na tsivon, ya variri to Gov. ");
INSERT INTO sps_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sana tsoiny tatagaa ot tana numaa iny fafaatouf tana taa Jiu kaa me na seeve te tsipaar finy e Jisas a moun tan Nainy Fafaatouf. To sana tsoiny tatagaa ot tsue of ir a vainy faavot, “Te kaa minon aunom nainy iny binun, sai te komainy romi ta mes ma kat ravainy a faadis tsumi, rof non mi ma naa me tan nainy binun, ana sikia ma tan Nainy Fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ana Tsunaun biny towa sa tsue, “Min kat mapam, mi natiny naa rom tan bulumakau ge u dongki, mi te puruur rari ana mi te mei ranaari tana aurom ma jiu ri tan Nainy Fafaatouf tana taa Jiu, taava. ");
INSERT INTO sps_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sana moun tovei, a tsubnaain ten Abraham sen Vinasaar kotskots ya sa onots safunuu ana jian a ingainy. Sa kat fei, to ma gima puruur Anyo na ka te kat tap iny ya ei, tan Nainy Fafaatouf tana taa Jiu?” ");
INSERT INTO sps_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Te vegiau fi Ya nei, ana vainy koma iring iny Towa, rejiaf erato. Ana rin mes panaan kaa mito na paparaa tana foka na fo rof fiisok te kat Ya. ");
INSERT INTO sps_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas rangat to, “A Waan e Gov faarei non a saa? Anyo onot rou ma fapapaar fiisen mi ya na saa? ");
INSERT INTO sps_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Te faarei non fuan kakaii ovei nan Mastat to te nom a mes sa reev ya tan tanun tsunia, sa gian faarein nau an marei kat ton sai tsuar tana fo naan nan ya.” ");
INSERT INTO sps_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ai Jisas rangat pis to, “Anyo onot rou ma fapapaar a Waan e Gov fiisen me na saa? ");
INSERT INTO sps_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Te faarei non ar kakaii iny Yis te nom a moun ya sovaar vavis towa koman kobuu parawa vou an parawa faavot to aya tsub faavot nato.” ");
INSERT INTO sps_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas taan naa, tana sanaan te toobing naa non Jerusalem. Sana Ayei ruak naa tana fo ngats fan ana fo mar fan sa faatsuts naa tan tsoiny min moun. ");
INSERT INTO sps_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ana isen a mes rangats Towa, “Tsunaun, a tee vavainy tsun te saup fatabiny non e Gov?” Jisas biny ratuari, sa tsue, ");
INSERT INTO sps_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ami ma vaputs tan sof naa tan matainy sobaan kapoo, tana saa a vainy a kinai te tanaf iny sof ror, sai ri gim ror ma onot. ");
INSERT INTO sps_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A tsunaun tana numaa tsun nats non, ai te siisiots matainy sobaa, ana mi te vatsutsun jiarasan, mi te tanik iny tegteg naa tan pingping mi te tsue, ‘Pue men pingping tsumam, Tsunaun!’ ana Ayei te nai tsue me tsumi, ‘Nyo sikia rou ma nat mami fei poo mimi ei?’ ");
INSERT INTO sps_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ana mi te biny naa Ya, ‘Amam te ainy mam jiu fiisen mamitua Nyi ana Nyi faatsuts kan to koman a ngats fan tsumam!’ ");
INSERT INTO sps_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ana Ayei te nai tsue pis tsumi, ‘Nyo sikia rou ma nat mami, fei te poo mimi ei. Feis osing Vanyo yam, amin vainy katkat tana ngi'arapaar!’ ");
INSERT INTO sps_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ami nai tagei rom e Abraham me Aisak ai Jekop an fo kuigin faavot koman a Waan e Gov, sana mi nai kaa emarom jiarasan tana pan iny fasaraa, unya aya mi nai tangis rom am kakuts ngiisngiis to na ngiisim. ");
INSERT INTO sps_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","A vainy poo fi miror tana pan te roruak minon a nuaf ai tana pan te ruk naa non a nuaf ai tana pan tana matainy sia ai tana pan tana ainysat iny vou nai gum ror tana pan iny ainy tana Waan e Gov. ");
INSERT INTO sps_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ai tovei bus, a vainy te vovou ror nai mumua ror, ana vainy te mumua ror nai vovou ror.” ");
INSERT INTO sps_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tan nainy to aya a tee Farasi naa mito ten Jisas ser tsue Tsunia, “Naus osing a pan tovei, ai Nyi te naanaa tan ta pan, tana saa, Herot komainy atsun marom anyi.” ");
INSERT INTO sps_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisas tsue to tsuri, “Ami ma naa mi te tsue of a kas a vouts to, Nyo nai buur ravainy rou masarau, Nyo te tsipaar ir a vainy roman ai tamanainy, ai tan fafofopis nan nainy, Nyo fakap rou a fo mamatsiny binun Tsonyo. ");
INSERT INTO sps_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sana Nyo ma naa patsukan you Jerusalem roman ai tamanainy, an tan mes nainy, tana saa, te gim non ma rof tan atsuiny famat a kuigin tana mes a pan patsukanen, san i Jerusalem tsun. ");
INSERT INTO sps_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Poo! Taa Jerusalem, taa Jerusalem! Mi atsun famat ir kuigin, ana mi totouruei famat raton tsoiny favaanan te jiats me Gov tsumi! Nainy kinai poiny Anyo ma favaaguam mami pana Vanyo guei iny Jerusalem, faarei te natiny favaaguam fi non a koriou a moun fuainy guei tsuan fain pakpak tsunia, sana mi baainy Vanyo! ");
INSERT INTO sps_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sai tovei, a fan tsumi nai uur enanon ai te tsubui en. Nyo tsue fatoobing of maromi mi gim rom ma tagaa pis Vanyo, onot non te tsue fi romi nei, ‘Gov faparits non Ya to te naa minon tana asangan a Tsunaun.’” ");
INSERT INTO sps_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tan sen Nainy Fafaatouf tana taa Jiu, ai Jisas naa to a tou ainy numaa tana isen a tsoiny mumua tan Farasi, ai ri vavaatok faarof ovei iny Towa. ");
INSERT INTO sps_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ana mes kaa minon faadis a mou pua naa me ten Jisas, ");
INSERT INTO sps_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ai Jisas rangat to sa tsue tan tsoiny fifaatsuts tan Faun te kirkir iny e Moses ana Farasi, “Te toobing kan non tana Faun tsura tan tsipaar a mes tan Nainy Fafaatouf tana taa Jiu ge a sikia?” ");
INSERT INTO sps_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sana ri te gima tsue ta isen ta ka. Jisas saras to na mes, sa tsipaar ya, Ya jiats naa towa. ");
INSERT INTO sps_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kat to ana Ayei tsue to tsuri, “Ta isen tsumi kaa minon ta isen ta guei tsoiny ge ta bulumakau ana ayei te gotsiny naa koman a matan tan Nainy Fafaatouf, toroman anyi onot rom ma ras fatafuts fatabiny veesau ya tan Nainy Fafaatouf ge?” ");
INSERT INTO sps_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ana ri gim to ma biny tsue Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas tagaa fi nei, ari to te vebus rari tana kainy ainy, komainy nai gum ror tana fo gumgum matan, to sa faan iny sen tsue fapapaar tsuri, ");
INSERT INTO sps_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“To te vebus marom anyi ta isen ta mes tan guainy nan fanging, anyi gim rom ma nai mumua iny nom a kainy ainy, a sikia, te kaa bus me naa mes te nom ari, a mes te kaa minon asangan tsian, te karap marom anyi. ");
INSERT INTO sps_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","To te naa faamuan rom anyi matan tana kainy ainy tana mes to te vebus manyi, ai te naa me ya te tsue na ka tsumanyi, ‘Nyi ma faan faamuan iny a pan tana mes tovei.’ Anyi nai rejiaf fiisok ovei tsun marom ana nyi te tsun, nyi te nai ainy vou ovei. ");
INSERT INTO sps_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Te nom rom anyin vebus, nyi ma nai tsutsun vou ovei, tana saa, te naa minon a mes te faan iny vebus, ayei onot non ma tsue, ‘Vaatau tsiau, tsun ana nyi te nai tsutsun tana pan a rof.’ Ana vainy te naa me tan guainy nai fapaas marom anyi. ");
INSERT INTO sps_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","A mes te fapaas non a tsivon, Gov nai fauf non ya peto, sana mes te fauf non a tsivon, Gov nai fapaas non ya.” ");
INSERT INTO sps_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisas tsue to tana mes te vebus ya ma naa mi ya tan guainy, “Te kat rom anyi ta pati gen guainy, vebus vaare ir vaatau tsuam an famuinyasiny tsuam, an nuatsim ge fifakokoro te kaa miror a masun, kat ror ser vebus fatabin manyi, ri te biny a fo saa te kat anyi tsuri na. ");
INSERT INTO sps_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sai te kat rom anyin guainy, faan iny vebus tsurin aaruts, mour a tavenek, an pengong an matar a kio. ");
INSERT INTO sps_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kainon a vainy to aya gim ror ma onot biny a fo saa te kat anyi tsuri na, Gov nai faparits marom anyi tovei Ya te nai biny a fo saa te kat anyi na, tan fatsun manyi tana mat fiisen ramirorin vainy tavaron.” ");
INSERT INTO sps_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A isen tsuri na mes te gum fiisen me Jisas tan guainy, nongon sa tsue Tsunia, “Paparaa tsian tsuri te nai gum ror tan guainy tana Waan e Gov!” ");
INSERT INTO sps_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sen Jisas tsue tsunia, “Sen nainy a mes te kakouiny a guainy tsian, sa vebus ir a vainy a kinai ma naa mi ri tan guainy. ");
INSERT INTO sps_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tan nainy to aya nan guainy, ya jiats raton vainy binun ma nai tsue of rari na vainy te nom vebus, ‘Taami yam a fo mamatsiny ka te kakoun en.’ ");
INSERT INTO sps_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ana ri na fokinai, kat ton tsue iny ree'ats, sana isen tsuri tsue, ‘Nyo see foiny tsuiny rou a tanun to tsonyo nai tagaa rou, reesik fiisok, nyo gim rou ma naa me.’ ");
INSERT INTO sps_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ana mesmes tsue to, ‘Anyo te foiny fakap a safunuu na bulumakau iny binun to tsonyo nai tanaf rarori, reesik fiisok, nyo gim rou ma naa me.’ ");
INSERT INTO sps_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ana mesmes tsue to, ‘Anyo see fanging tsun rou, to tsonyo gim rou ma onot ma naa me.’ ");
INSERT INTO sps_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kat to ana tsoiny binun, mei fatabiny naa ton fo vegiau tovei tana tsunaun tsuan. Te nongoiny a tsunaun a fo vegiau tovei, ya seeve fiisok ovei tsun nato, sa tsue of a tsoiny binun tsunia, ‘Veesau tsun naa, tana fo sanaan garas, ai tana fo mar sanaan koman a ngats fan, ai nyi te nom ir a men vainy aaruts, mour a tavenek, an vainy matar a kio, an vainy pengong.’ ");
INSERT INTO sps_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kat to ana tsoiny binun tabin to sa tsue, ‘Tsunaun, a foka te tsue nyi te kat fakap en, sana numaa te kaa farokot minon a fo pan a fo uur.’ ");
INSERT INTO sps_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ana tsunaun tsue to tana tsoiny binun, ‘Kuar naa, tana fo sanaan garas jiarasan tana ngats fan, ana fo mar sanaan ririkin a fo tanun, ana nyi te kat ir a vainy ma sof mi ri ma tsup a numaa tsonyo. ");
INSERT INTO sps_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nyo tsue of maromi, a sikia ovei ta isen tsuri na vainy te nom vebus ser faan iny tsue ree'ats to te nai tanaf ror a kainy ainy tsonyo.’” ");
INSERT INTO sps_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","U tagin tsian te taataan fiisen me Jisas Ya kat to sa takopis of rari, sa tsue, ");
INSERT INTO sps_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“E sei na mes te komainy naa minon Tsonyo ee, sana ayei mangiir fiisok non e taman, tsinan, ai natsun an fo guei tsunia, an famuinyasiny tsunia, an fafinen ya, ana tsivon, fis pis Varonyo, te gim nats non ma faarei a matisian Tsonyo. ");
INSERT INTO sps_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ana mes te gim non ma famanat iny fa'orovus to na tsivon, ai te vovou Vanyo ee, gim nats non ma faarei a matisian Tsonyo. ");
INSERT INTO sps_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ta isen tsumi kaa minon komainy fatsuiny a numaa na nai jias, ma gum tsom ai te fakats faarof ta foka te onot non, ai te tagaa tana moni te onot fi non ya tan fakap faarof a numaa na nai jias. ");
INSERT INTO sps_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","To te fagum non ya na poon nana numaa ana ayei te gima fakap ya, ana fokinai tagaa ri te tsue vaaserere iny ya, ");
INSERT INTO sps_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘A mes to te tanik iny fatsuiny a numaa sa gima onot ma fakap ya.’ ");
INSERT INTO sps_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Te nai fapupuaan non a aatouf me na mes a aatouf fiisen men safunuun a tapan mes iny puaan, sana mes a aatouf naa fiisen minon a tangau a tapan mes iny puaan, to sa komainy nat non, ayei onot non ma fapupuaan fiisen me na mes a aatouf ge sikia? ");
INSERT INTO sps_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Te gim non ya ma onot ana ayei te faan iny naa tu tsoiny govet vegiau a nai tagei to na mes a aatouf, sai te kaa farokot non ya veevian ya te vegiau iny kat a aaverof. ");
INSERT INTO sps_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jesan a mes ma fakats faparits tsom ten sei te gim non ma faravaa tana fo mamatsiny ka te kaa minon ya, gim nats non ma faarei na matisian Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“U teis kaan rof, sai te kajiaa non teteisian nan teis a binun tsunia te kap en, a sikia pis ta sanaan iny kat fateteisiainy fatabiny pis ya. ");
INSERT INTO sps_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Te gim non ma rof bus tan ta isen ta binun. Te nom ravaa tsun non ai te ravaa. Mes kaa minon teinan iny nongon ma nongon faarof.” ");
INSERT INTO sps_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","U tsoiny nonom takis an vainy kat kat aveto, nai nongon me ten Jisas. ");
INSERT INTO sps_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","San Farasi an tsoiny fifaatsuts tan Faun te kirkir iny e Moses tanik iny ngun'ngun rato, “A mes tovei te rof fiisok raror vainy aveto, ana Ayei ainy fiisen kan ramirori.” ");
INSERT INTO sps_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kat to ai Jisas tsue of ratuarin, tsue fapapaar to, ");
INSERT INTO sps_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“To ta isen tsumi te kaa minon ta natus siip, an ta isen tsurin siip te nun, a saa te kat rom anyi na? Nyi naus osing tsom rarom sian safunuu ana sia na siip er ainy to tana aufing, nyi te nai tsikoo na isen te nun, onot non te sab fatabiny rom anyi ya. ");
INSERT INTO sps_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te sab rom anyi na siip, nyi te faatua googon iny mi ya, fiisen me na paparaa nyi mei naa towa fan. ");
INSERT INTO sps_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nyi te fikoo vaaguam ir vaatau tsuam an fifakokoro ana nyi te tsue tsuri, ‘Mi ma mamagat fiisen vaminyo, nyo sab a siip tsonyo te nun.’ ");
INSERT INTO sps_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nyo tsue of maromi te senviir tsun non, te kaa minon a mamagat tsian Gormirmir, to tana isen a mes a katkat aveto te reesik non ya te takopis osing a fo aveto tsuan, fis pis non to tan sian safunuu ana ina sia te rof er, ana sikia tu koman iny tabin pis tan aveto.” ");
INSERT INTO sps_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“To na moun te kaa me na safunuu na silva moni ya fanuiny to na isen. A saa te kat non ya na? Te fakuruiny non kurun, ya te fifio na numaa tsunia ya te matoong tsikoo vavis faarof a fo mamatsiny pan onot non te sab non ya na moni. ");
INSERT INTO sps_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nainy te sab non ya na moni, ya te fikoo vaaguam ir vaatau an fifakokoro tsuan, ya te tsue tsuri, ‘Mi ma mamagat fiisen vaminyo, nyo sab fatabiny a silva moni te fanuiny anyo.’ ");
INSERT INTO sps_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nyo tsue of maromi te senviir tsun non, te kaa minon a mamagat tsian matar morena ten Gov to tana isen a mes te reesik ya takopis osing to na fo aveto tsuan.” ");
INSERT INTO sps_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas kat ton mes siisio, sa tsue, “A mes, kaa me na ina fuan a guei tsoiny. ");
INSERT INTO sps_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ana fafuan nana guei tsoiny tsue to ten taman ya, ‘Tamau, a foka tsumanyi te komainy faan iny rom anyi tsumam mumuinyasiny, faan bus you a pan tsiau.’ Kat to ai tamarari kibei to na foka tsunia fapoopoan nari ina fuan a guei tsoiny tsunia. ");
INSERT INTO sps_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Gima potsian, ana fafuan nana guei tsoiny guam to na foka te kaa mi ya, kat to ya naa to tana gum fan veevian, ana ayei kat raravainy to na moni tsuan na aya tana fo kat iny aveto sa kap en. ");
INSERT INTO sps_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Te kap bus a fo mamatsiny ka tsunia, kat to an nainy ves tsian ruak to tana gum fan faavot to aya, ana ayei kaa iny aaruts bus nato. ");
INSERT INTO sps_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ya kat to sa nom binun tana isen a mes, tana gum fan to aya, ya jiats naa towa tana aunon ma nai tatagaa ot iny yan voo. ");
INSERT INTO sps_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Te ainy bus voon pem, ya ves fiisok to sa kaa men koman iny ainy, ya ainy kainy ton pem te ainy voo a faviits to na koman te ves fiisok, tana saa, a sikia ta mes ma fa'ainy ya. ");
INSERT INTO sps_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kat to an fakats rof ruak to tsunia, sa tsue, ‘U fuainy tsoiny binun ten tamanyo kaa miror a kainy ainy a kinai, ai tovei, nyo mat mirou ves, ");
INSERT INTO sps_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","te rof non, nyo ma tsun, nyo te nai tabin naa ten tamau nyo te tsue tsunia, Tamau, nyo kat aveto matan e Gov ai mata manyi. ");
INSERT INTO sps_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nyo gima onot ma tamainy ma asang vanyo nyi na guei tsumanyi, sana nyi ma kat faarei vanyo na tsoiny binun tsumanyi.’ ");
INSERT INTO sps_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ya kat to sa tsun, ya tanik iny taan bus fi na naa to ten taman ya. “Ayei kaa enanaa non veevian fan, ai taman ya tagei naa towa, ana koman ya via mito na tagtag tsian tsunia, ya kookuar naa to sa nots a guei tsuan, ya tangis mi towa me na mamagat. ");
INSERT INTO sps_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ana guei tsue to, ‘Tamau, nyo kat aveto matan e Gov ai mata manyi. Nyo gima onot ma tamainy ma asang vanyo nyi na guei tsumanyi.’ ");
INSERT INTO sps_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Sana taman fikoo ir vainy binun tsunia sa tsue tsuri, ‘Veesau yam, mi te mei men vau beberus saavits tsonyo ma favau ara ya. Fakei yam a purei karoor nan ya, an suu tan pipita nan ya. ");
INSERT INTO sps_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ana mi te nai nots me ta moof mi te atsuiny ya, ma kat aran guainy iny fafaruak fatabiny me na mamagat, ");
INSERT INTO sps_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","tana saa a guei tsonyo to te mat, sai tovei te toto fatabin en, te nun, sai tovei te sab fatabin en.’ Kat to ana kainy ainy tanik bus nato. ");
INSERT INTO sps_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tan nainy to aya, a vaamuan nan a guei tsoiny kaakaa me tanun, ai te tabin mi ya, sa naa fasiruu me numaa, ya nongoiny ton koov ana fokinai te tajiat ror. ");
INSERT INTO sps_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ya fikoo to na isen tan tsoiny binun sa rangats ya, ‘A saa bus te katkat rori na?’ ");
INSERT INTO sps_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ana tsoiny binun tsue to, ‘E famuinyasiny tsumanyi te ruak fatabin naa me fan, to ten tamamanyi atsuiny a moof, tana saa, ayei te nom fatabiny ya, na rof, fiisen me na mamagat.’ ");
INSERT INTO sps_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“A vaamuan nana guei te kaa me na peits tsian, sa gima sof na gagon koman a numaa, to ten taman ya tafuts sa vegiau faarof fiisen mi ya ma sof ya. ");
INSERT INTO sps_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ya biny to taman sa tsue, ‘Tagaa, ingainy a kinai to aya, te binun faarei anyo na tsoiny binun babainy tsumanyi, nyo gima fanaginy tsue tsumanyi. Ana saa te faan iny anyi tsonyo na? A sikia ovei, a sikia ta meme ta kakaii ma faan vanyo nyi ma ainy fiisen mi nyon vaatau tsonyo! ");
INSERT INTO sps_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sana guei tsoiny tsumanyi tovei, te kat raravaa tsuiny a fo mamatsiny ka tsumanyi tan moun tsitsikoor, an nainy te tabin mi ya fan, nyi atsuiny of towa na moof.’ ");
INSERT INTO sps_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ana taman biny towa sa tsue, ‘Guei tsoiny tsiau, nyi natiny kaa fiisen vamironyo nei tan mamatsiny nainy, ana fo mamatsiny ka tsonyo a foka tsumanyi. ");
INSERT INTO sps_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sai tovei, ara ma mamagat me na kainy ainy, tana saa, e famuinyasiny tsumanyi te mat, sai tovei te toto fatabin en, te nun, sin tovei te sab fatabin en.’” ");
INSERT INTO sps_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas tsue of raton matisian Tsunia, “A mes a masun te kaa me na tsoiny tatagaa ot tana binun tsunia. Ya nom ton tsue, te kat fi non nei, ‘A tsoiny tatagaa ot tana binun te kat raravaa tsun iny a moni tsumanyi.’ ");
INSERT INTO sps_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ya fikoo fasof na towa gagon sa rangats ya, ‘Vegiau saa to aya nan na, te nongon anyo te kat anyi? Nyi kirkir rom tu vegiau iny fa'arasan tana binun te kat anyi tana foka tsonyo te tatagaa ot iny anyi, tana saa nyi gim bus rom ma tsoiny tatagaa ot iny a fo mamatsiny ka tsonyo.’ ");
INSERT INTO sps_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ana tsoiny tatagaa ot fakats to koman, ‘A saa te kat bus ronyo na, tana mes a masun to te fakap bus varonyo tana binun. Anyo gima onot tan guap puputaa faarei na tsoiny binun, ana nyo kan rejiaf rou tan sing maamaa tana vainy. ");
INSERT INTO sps_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tovei, nyo nat bus you tana saa te kat nats ronyo na, nyo nai faakouts rarori na vainy te kaa miror tavan tana tsunaun tsonyo, ai vou te gargar Varonyo ya tana binun, nyo kaa mirou vaatau nai faakouts varonyo, ri fasof varonyo tana numaa tsuri ana ri te kat faarof vanyo.’ ");
INSERT INTO sps_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ya kat to, sa fikoo isiseiny rari na vainy te kaa me na fo tavan tana tsunaun tsunia. Ya rangats to na vaamuan, ‘A fis te tavainy anyi tana tsunaun tsonyo?’ ");
INSERT INTO sps_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ya tsue to, ‘A isen a natus plastik tan suun.’ Ana tsoiny tatagaa ot tsue to tsunia, ‘Neen pepa te kirkir ari na fo tavan tsumanyi tana tsunaun tsonyo, nyi te gum, nyi te kirkir pangis veesau nan natus plastik tan ngim safunuu.’ ");
INSERT INTO sps_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ana tsoiny tatagaa ot tsue to tana mesmes, ‘Ana nyi, fis te tavainy anyi?’ Ya tsue to, ‘U natus vio rais.’ Ana tsoiny tatagaa ot tsue to tsunia, ‘Neen pepa te kirkir arin tavan tsumanyi, ana nyi te kirkir pangis natus vio rais tan jian safunuun vio.’ ");
INSERT INTO sps_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ana tsunaun nongon to te kat fi naa tsoiny tatagaa ot nei, kainon to tan kat gam tsunia, tsunaun saar to na tsoiny tatagaa ot te kaa men fakats nan nainy vou. A vainy te natiny vovou iny ror uurup, te binun fafaparits ror tan nainy roman te kavuu ror nainy vou tan patsun puputaa to ri te fakats fapaas fafis raror vainy tana arasan te fakats ror tan nainy vou tana gormirmir.” ");
INSERT INTO sps_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jisas tsue pis to tsuri, “A vainy tana monaagits tovei, onot ror ma kat a masun of a tsivor, sai tovei Nyo tsue rou tsumi, ami ma faan iny a fo masun tsumi tana tou faakouts ir a vainy aaruts ana ri te ruak iny vaatau tsumi. Sai vou, te kap non a fo mamatsiny masun tovei, Gov nai fasof maromi tana fan a gum suu Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“A vainy te onot ror ma faason tsumi te tavaron fi romi iny makok a moni na kakaii ana foka, ari kan onot ror ma faason tsumi te tavaron kan fi romi iny makok a moni na kinai ana foka. Sai te gim romi ma kat fatavaron iny makok moni na kakaii, mi kan gim rom ma nai kat fatavaron iny makok a masun tsian. ");
INSERT INTO sps_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","To te gim romi ma onot iny makok faarof a masun tana monaagits tovei, Gov gim kainy non ma nai faason tsumi tana masun a man iny Gormirmir. ");
INSERT INTO sps_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ai to te gim finy romi ma kat fatavaron tan makok a moni ana foka Gov faan iny Ya tsumi nei petoo, Ayei kan gim non ma nai faan mami ta ka na suu iny Gormirmir iny fasito tsumi. ");
INSERT INTO sps_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Sikia ta tsoiny binun te onot non ma binun tana ina fuan a tsoiny tatagaa ot, ayei nai tsugei non a isen ya te mangiir a mesmes, ayei nai manaats non a isen ana ya te fataivou a mesmes. Jesan mi gim rom ma onot ma binun faavot ten Gov ana painy moni.” ");
INSERT INTO sps_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A Farasi te nongoiny a ka to, ana ri tsue vaaserere iny to Jisas, tana saa u koman tsuri kaa non tana moni. ");
INSERT INTO sps_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ai Jisas tsue to tsuri, “Ami na vainy natiny kat fatavaron ovei rom a tsivom matar a fokinai, sen Gov natiny non a koma mami. A saa te fakats non a mes to te kaatsian fiisok non na, faarei non a ka babainy matan e Gov. ");
INSERT INTO sps_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","U Faun te kirkir iny e Moses an vegiau te kirkir kuigin te favaanan tsoiny fifaatsuts sa onot ten Jon a Tsoiny Fapeenan. Tan nainy naa to aya, Vurungan Rof nana Waan e Gov te favaanan kanen na naa non. Ana fokinai vaputs to ma sof naa gagon. ");
INSERT INTO sps_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kainon a korosuu an puputaa nai kajiaa non, sikia ta isen ta karainy vegiau nan Faun te kirkir iny e Moses te naa babainy non. ");
INSERT INTO sps_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“A isen a faun to, a faun iny fanging, sei na mes te ots non fanging ten natsun ee, ana ayei te fifanging me na mes a moun, ayei kat, kat iny tsikoor, ana mes te fifanging me na moun to natsioiny ya te ots fanging fiisen mi ya, ayei kan te kat, kat iny tsikoor.” ");
INSERT INTO sps_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ai Jisas tsue pis to na ka, “A mes a masun te kaakaa kan, te kaa men vau maato saavits ana tou kaakaa tsunian rof fiisok ovei tan mamatsiny nainy. ");
INSERT INTO sps_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ana mes a aaruts kaakaa kan, a asangan ya Lasarus te kaa men pipiirots, ser memei naa ya tan matainy sobaa tana mes a masun, ");
INSERT INTO sps_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","te pon ma veverok tu momorian nar kainy ainy, to te rurus minon tana taran iny ainyainy tana mes a masun a faviits to na koman. U kas kan te naa me ser damdam pipiirots tsunia. ");
INSERT INTO sps_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Tan nainy te mat bus a mes a aaruts an morena nom na towa ser mei finy naa ya tana pan ten Abraham. Kat to ana mes a masun mat patsu to ser kats iny ya. ");
INSERT INTO sps_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ya nai tsun to Hel, tana pan te kaa non a kamits tsian, ya matoong fapaas to, sa tagei na Abraham veevian fiisok fiisen me Lasarus panaan ya. ");
INSERT INTO sps_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ya kat to sa kuu naa, ‘Tamau Abraham, nyi ma reesik vanyo, ana nyi te jiats me Lasarus ma fabub ya na karoor nan tana aurom ma fakour ya na riam na vanyo, tana saa, nyo kaa rou tana pan te kaa non a kamits tsian tan guaf.’ ");
INSERT INTO sps_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Sen Abraham biny ya, ‘Guei tsoiny, fakats fatabin to te toto fi nyi, nyi nom a foka na fo rof, ai Lasarus nom to na foka na fo iring, sai tovei, ayei kaa iny famaun osto, nainy te kaa rom anyi tana kamits tsian. ");
INSERT INTO sps_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ana mes a ka pis tovei, fapoopoan narara a gaguur tsian te kaa non to tana vainy nei komainy ror ma naa nats, sai te opaar ror, ge ma poo me naa, ri te guas me nei!’ ");
INSERT INTO sps_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ana mes a masun tsue to, ‘Kainon tamau Abraham, nyo sing marom anyi jiats naa Lasarus ma naa naa ya numaa ten tamanyo, ");
INSERT INTO sps_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","te kaa ror a ina ngim a famuinyasiny tsonyo, jiats naa a tsue taatag of ratuari, er naa vaare mito nei tana pan te kaa non a kamits.’ ");
INSERT INTO sps_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ai Abraham tsue to, ‘Ri kaa miror vegiau te kirkir iny e Moses an fo kuigin, ri ma nongon tsuri.’ ");
INSERT INTO sps_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ana mes a masun biny towa, ‘Tamau Abraham, gim non ma onot, san a rof nan ya to, isen te mat ma tsun ai te naa tsuri, ari onot ror ma reesik, ana ri te takopis osing a fo aveto tsuar!’ ");
INSERT INTO sps_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Sen Abraham tsue, ‘Te gim finy rori ma nongoiny e Moses an kuigin, ari gim kan ror ma onot ma faaman tan ta isen te tsun fatabin non tana mat.’” ");
INSERT INTO sps_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ai Jisas tsue to tan matisian Tsunia, “A fo amus te kat fa'aveto non a mes nai ruak minon, san e Gov nai fasaraa fiisok non a mes te amus non a mesmes ai te kat aveto. ");
INSERT INTO sps_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Te rof fafis non tan tang iny ta marats tsian googon ya, ai te nai faruk namaan bong, kat non sa kat ta isen tsurin vainy to te kaa miror a faaman a kakaii ser kat aveto. ");
INSERT INTO sps_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tan kat to aya mi ma vaatok a tsivom. Sai te kat non e vamuinyasiny fafaaman tsumanyi tu aveto, nyi ma tsue ets'ets iny ya, ma faonot ya, ai te takopis osing non ya na fo aveto tsuan, ai te tsue iny reesik naa ten Gov, nyi ma anofe ravainy aveto tsunia. ");
INSERT INTO sps_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ai te kat aveto onots non yan fits nainy tsumanyi tan koman sen nainy, ya fatabin mito tsumanyi tan fits nainy koman sen nainy sa tsue tsumanyi, ‘Nyo reesik, faonot bus you tan kat aveto,’ nyi ma anofe ravainy a fo aveto tsunia.” ");
INSERT INTO sps_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","An amaraav tsue to tana Tsunaun, “Anyi ma fakorot me na faason tsumam.” ");
INSERT INTO sps_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ana Tsunaun biny ratuari, “To te kaa fi miromi na faason a kakaii faarei non fuan kakaii nan Mastat, mi onot rom ma tsue tan nau to, ‘Pat a tsivom, ana nyi te nai reev iny a tsivom namaan,’ ayei manaats marom anyi” ");
INSERT INTO sps_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ai to te kaa minon ta isen fapoopoan namami ta tsoiny binun babainy ana ayei te vaar tan tanun ge te tatagaa ot iny siip. Ai te fakap binun tanun, ya te naa me numaa, nyi onot rom ma tsue tana tsoiny binun babainy, ‘Taa bus me, nyi te gum ana nyi te ainy ta kainy ainy tsuam?’ ");
INSERT INTO sps_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Toroman a sikia! Sai te tsue fi non nei tsunia, ‘Pau a puam raarav ana nyi te kakoun onots a kainy ainy tsonyo, nyi te anaanos vanyo te ainy rou ana nyo te jiu, ivou bus ana nyi te ainy, nyi te jiu.’ ");
INSERT INTO sps_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nyi toroman te faan kan iny rom tsue iny paparaa tana tsoiny binun to te vovou finy yan tsue tsumanyi? A sikia. ");
INSERT INTO sps_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Te senviir faarei maromi, nainy te kat fakap romi na foka te tsue of mami na tsunaun tsumi tan kat ya, tsue yam, ‘Amam tsoiny binun babainy tsun kan, mam kat fakap tsuiny a binun tsumam.’” ");
INSERT INTO sps_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas taataan fi naa tana ngats fan tsian iny Jerusalem sa ruak naa fapoopoan nana fuan a gum fan iny Samaria ai Galili. ");
INSERT INTO sps_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ya ruak naa to tana isen a fan, ana safunuu na mes a tatauba tainytainy Towa. Ri tsutsun me veevian, ");
INSERT INTO sps_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ser kuu naa, “Jisas! Tsunaun tsumam, reesik mamimam!” ");
INSERT INTO sps_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas tagaa rari Ya tsue to tsuri, “Kua yam tan tsoiny faakor mi te faatok iny a pua mami, er tsir matuami.” Te taataan naa ri, ana pua rari taabos nato. ");
INSERT INTO sps_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nainy te tagaa fi na isen tsuri to te tsipaar fi ya, ya fatabin to iny vamarits e Gov fiisen men kuu tsian. ");
INSERT INTO sps_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ya naa to sa fagotsiny a tsivon moun e Jisas, ya faarof iny Towa. A mes to aya a sikia ma tsoiny Jiu, ayei na tsoiny Samaria. ");
INSERT INTO sps_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Ai Jisas tsue to tana mes, “Nyo pon fi nei a ina safunuu na mes te tsipaar. Kat fei tana tsoiny sagoor tsun tsivon to nai tsue iny faarof me ten Gov ei? Ari pas a ina sia ei?” ");
INSERT INTO sps_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kat to ai Jisas tsue to tsunia, “Tsun nyi te taan, a faason tsumanyi te fatoto manyi.” ");
INSERT INTO sps_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mes panan tsuri na Farasi rangats to Jisas, “Farainy te ruak minon a Waan e Gov?” Ya biny ton tsue, “A Waan e Gov te gim non ma naa me faarei non mi onot rom ma tagei ya. ");
INSERT INTO sps_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sikia ta mes te onot non ma tsue, ‘Tagaa yam, tovei aya nan!’ ge, ‘Tuwa aya nan!’ tana saa, a Waan e Gov te kaa bus en fapoopoan namami.” ");
INSERT INTO sps_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jisas kat to sa tsue tan matisian Tsuan, “U nainy te naa minon, ana mi te komainy ma tagei fiisok tu nainy tana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, sana mi te gim rom ma onot ma tagei ya. ");
INSERT INTO sps_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta vainy te nai tsue nats ror tsumi, ‘Tagaa yam, tuwa Ayei!’ ge ‘I tovei Ayei nan!’ Sana mi ma nai kat tsuktsuk vaare rari, ");
INSERT INTO sps_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","tana saa, a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me naa minon faarei non kurun nan kanaf, ya te sak faavot naa jias tan mes panaan ana vainy te tagei faavots Ya. ");
INSERT INTO sps_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sana Ayei ma saraa kamits fiisok tsom, ana vainy tan nainy roman te tsugei Ya. ");
INSERT INTO sps_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tou tabin me Tsonyo, na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, nai faarei tsuiny non a ka te ruak muan tan nainy ten Noa. ");
INSERT INTO sps_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tan nainy ten Noa vainy fakats tsuiny to na tsivor tan ainy, an jiu, an tsoiny min moun fifanging to onot tan nainy te sof naa Noa tan Ak, ana urungat tsian naa mito sa ras faavot ir a fokinai, ri mat fakap rato. ");
INSERT INTO sps_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Te faarei tsuiny kainy non a fo nainy ten Lot. A vainy te ainy, jiu, fafiifoiny ri foiny to, ri reev ana ri fatsun numaa to. ");
INSERT INTO sps_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","San tan nainy te naus osing e Lot a ngats fan iny Sodom, guaf to te akoor Solfa jiaf fisikii gotsiny faarei mito na ruat Gormirmir sa popoon fakap rari. ");
INSERT INTO sps_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Te senviir minon nainy tana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me ruak non tana arasan. ");
INSERT INTO sps_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Tan nainy to aya, a mes te kaa non jiarasan a numaa tsuan, ma sof fatabin vaare gagon numaa ma nom ya ta foka tsuan, ayei ma bus tsun naa naa. Te senviir minon a mes kaa non tanun tsuan ma tabin vaare fi numaa ma nom ya na ka, ayei ma bus tsun naa naa. ");
INSERT INTO sps_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Fakats e natsun Lot, te tagaa fatabin naa ya mat to! ");
INSERT INTO sps_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sei na mes te tanaf iny makok non a toto tsuan ee, nai kajiaa enanon, ai sei na mes te fa'orovus non a toto tsuan ee, nai nom non toto na suu. ");
INSERT INTO sps_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nyo tsue of maromi, tana voiny to aya te goros faavot ror a ina fuan a mes tana isen a numaa, ai Gov te nai nom naa na isen tsuri ana mesmes te kaakaa en vou. ");
INSERT INTO sps_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ina fuan a moun te koinykoiny ror koinykoiny, ai Gov te nom a isen tsuri ana mesmes te kaakaa en vou. ");
INSERT INTO sps_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ina fuan a tsoiny te binun ror tanun, ai Gov te nom naa na isen tsuri, ana mesmes te kaakaa en vou.” ");
INSERT INTO sps_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","An matisian Tsunia rangats Towa, “Tsunaun, fei te ruak fi naa rori ei?” Ai Jisas tsue of ratuari, “Tana pan te soon non puainy mes mat manuu nai vaaguam ror tsunia.” ");
INSERT INTO sps_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kat to ai Jisas tsue of ratuarin tsue fapapaar to, iny faatsuts rari ma natiny faakats vaurep ari, er ree'ats vaare to! ");
INSERT INTO sps_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ya tsue to, “Koman a isen a ngats fan te kaa me na isen a tsoiny vaatsuk te gim non ma natiny oraav e Gov ana ayei kan gim non ma natiny famaari ir a vainy. ");
INSERT INTO sps_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tana ngats fan nato aya te kaa non a amov natiny naa vaurep non tana tsoiny vaatsuk to ai te tsue of ya ma kat ya tu vaatsuk, a faakouts towa tana patang te katkat non a mes tsunia. ");
INSERT INTO sps_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Sai te potsian en, ayei baainy ma faakouts ya. Vou te nom yan fakats rof ya tsue to koman, ‘Tana saa a amov tovei te fasasapam vaurep vanyo, kainon nyo gima oraav e Gov, nyo gim kan to ma famaari ir a vainy, sai tovei nyo nai faakouts rou ya ma toobing ya, ge kat non sa naa vaurep me ai te fanag vanyo.’” ");
INSERT INTO sps_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ana Tsunaun tsue pis to, “Fakats yam tsue tana tsoiny vaatsuk to na iring, ");
INSERT INTO sps_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ana mi te fakats kainy naa Gov tan kat te nai kat non Ya ma faakouts Ya na vainy te pisainy Ya. Tsoiny vaatsuk to na iring te fatoobing fo iring te kat a mes tana amov, jio, e Gov, a Tsoiny Vaatsuk a tavaron nai fatoobing famainy non fo iring tan vainy vavaajets te kat ari tana vainy te pisainy Ya, ari to te faakats vaurep naa Tsunia tana nuaf ana voiny, Ayei nai potsian non tan anaanos tan faakouts rari. ");
INSERT INTO sps_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Sikia, Nyo tsue of maromi, Ayei faakouts veesau rarori, sana Nyo rangats maromi, tan nainy te tabin fatabin mironyo na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me tan puputaa tovei, Nyo nai sab rou e sei ta mes ee, te faason sa anaanos patsukanen nanon to, Nyo te tabin me ma fakei fatoobing anyon fo mamatsiny ka ge na sikia?” ");
INSERT INTO sps_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ai Jisas tsue pis ton tsue fapapaar tovei tana vainy te faamainy ror a tsivor te tavaron er ana ri te tagaa fafauf ir a mesapan. ");
INSERT INTO sps_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“A ina fuan a mes a tou faakats ser naa tana saape, a isen a Farasi ana mesmes a tsoiny nonom takis. ");
INSERT INTO sps_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ana tsoiny Farasi tsun to sa faakats of iny a tsivon, ‘Gov, nyo tsue rof non Tsumanyi, tana saa, nyo gim rou ma faarei mes panainy vainy kakabuts, katkat aveto, an tsitsikoor, ge ma faarei na tsoiny nonom takis tovei. ");
INSERT INTO sps_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nyo natiny tavtaav rou fuan nainy tana isen a wik, ana nyo natiny faan iny rou a isen a pan tan fasafunuu nana pan tana fo mamatsiny ka te sab ronyo Tsumanyi.’ ");
INSERT INTO sps_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Sana tsoiny nonom takis tsutsun fajesa naa, ya gim kan to ma matoong fi naa Gormirmir, tana saa ayei te rejiaf men aveto tsunia, ana ya buts to na buen, tana saa, ayei te reesik tsunia na aveto, ya tsue to, ‘O Gov, reesik vame, nyo na aveto!’” ");
INSERT INTO sps_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ai Jisas tsue to, “A tsoiny nonom takis, gima tsoiny Farasi, to te tabin naa numaa te kaa fatavaron non matan e Gov. A mes te fapaas non a tsivon, Gov nai fauf non ya peto, ana mes te fauf non a tsivon, Gov nai fapaas non ya.” ");
INSERT INTO sps_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mes panan tana vainy mei miton guei kakaii an kukurik ten Jisas ma fasaur Ya na niman patsuu rari. Nainy te tagei matisian a ka to, ri tsue ets'ets rato na vainy. ");
INSERT INTO sps_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sen Jisas fi koo ir guei kakaii ma naa mi ri Tsunia, sa tsue, “Tanyir yam guein kakaii ma naa mi ri Tsonyo, tsue tap vaare ir yam, tana saa a Waan e Gov fasito raror vainy te faarei ror guei to ari. ");
INSERT INTO sps_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Man ovei nyo tsue of maromi, sei te gim non ma faarof a Waan e Gov ee, a faarei to na guei na kakaii te faarof iny non ya ayei gim non ma onot a sof to gagon koman a Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A isen a tsoiny mumua tana taa Jiu te rangats e Jisas sa tsue, “Tsoiny Fifaatsuts a rof, a saa te kat ronyo, nyo te nom a toto na suu na?” ");
INSERT INTO sps_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisas biny towa, “Kat fei tsumanyi koo Varonyo na mes a rof, ei? Sikia ta isen ta mes ta rof, e Gov tsun Tsivon! ");
INSERT INTO sps_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nyi nat bus iny Faun te kirkir iny e Moses: Bainy tsikoor, bainy atsuiny, bainy kabuts, bainy gamgam iny a mesmes, fatsiitsii tamam me tsinam.” ");
INSERT INTO sps_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ayei biny Towa, “A fo faun to aya te vovou faarof iny anyo ana nyo vurots you onot roman.” ");
INSERT INTO sps_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nainy te nongoiny e Jisas a ka to, Ya tsue to tsunia, “Isen a ka tabuiny kat rom anyi, fafiifoiny iny a foka te kaa mirom anyi, nyi nom to na moni nyi fafaan ratuarin vainy aaruts, nyi te nai kaa me na masun iny Gormirmir; taame vovou You.” ");
INSERT INTO sps_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","San nainy te nongoiny yan vegiau to, ya mataaf fiisok ovei tsun nato, tana saa ayei kaa me na masun a kinai. ");
INSERT INTO sps_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas matoong towa sa tsue, “Te opaar fiisok tsun non tana mes te kaa minon a masun a nai sof to na Waan e Gov! ");
INSERT INTO sps_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Te opaar non tana Kamel ma sof a tarobong tana tutusa, sai te opaar fafis fiisok non tana mes a masun ma sof tana Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ana vainy to te nongon Tsunia rangat to, “E sei te onot non ma saup ai te nom a toto na suu ee?” ");
INSERT INTO sps_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisas biny ratuari, “A saa te opaar non tana mes ma kat na, Gov onot non tan kat ya.” ");
INSERT INTO sps_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kat to ai Pita tsue to, “Tagaa, mam naus osing me naa fo fan ana fo mamatsiny ka tsumam ana mam atou vovou Manyi.” ");
INSERT INTO sps_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisas tsue to tsuri, “Nyo tsue faman of maromi, a vainy te fakats ror a Waan e Gov, ri te naus osing a fan tsuar, ge natsur, ge fuainy famuinyasiny, ge tamar min tsinar, an guei, ");
INSERT INTO sps_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ri nai nom faaboo pis ror tan nainy tovei, ai tana toto na suu tan nainy te naa minon vou.” ");
INSERT INTO sps_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","E Jisas mei rato na ina safunuu ana ina fuan a matisian Tsuan tatangin, Ya tsue of ratuari, “Nongon yam, ra naa fi ror Jerusalem ana fo mamatsiny ka te kirkir iny kuigin nana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai ruak iny man non. ");
INSERT INTO sps_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ayei nai faan iny naa rori tan mes vainy kaner sikia ma taa Jiu er nai tsue taring iny Towa, ri te kat fifiiring iny Ya, kisuf iny Towa. ");
INSERT INTO sps_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ri te nai rapits Ya, ana ri te atsuiny Ya, ai tan fafofopis nan nainy, Ayei nai tsun fatabin enanon.” ");
INSERT INTO sps_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Matisian Tsunia gima fakats fanatnat iny a foka to aya. A man nana fo vegiau gima arasan tsuri ser gima natiny ta ka tana foka te tsotsue tsuk iny e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ai Jisas taan fasiruu mito Jeriko a isen a mes a mata kio gumgum tatangin a sanaan kat non sing maamaa. ");
INSERT INTO sps_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nainy te nongoiny yan tagin te fis naa, ya rangat to, “A saa to aya naa na?” ");
INSERT INTO sps_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ana ri tsue of towa, “E Jisas, a tsoiny Nasaret to te naa fi enaanaa.” ");
INSERT INTO sps_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ana mes a mata kio vaputs to sa kuu, “Jisas, tsubnaain ten Devit, tagtag vame!” ");
INSERT INTO sps_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ana ri te mumua naa tsue ets'ets iny towa, “Vanumui.” Sana ayei kuu fatsian pis to, “Tsubnaain ten Devit, tagtag vame!” ");
INSERT INTO sps_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kat to ai Jisas tsutsun to, sa tsue naa ma mei mi ri ya nei Tsunia. Nainy te naa mi ya siruu, ai Jisas rangats towa, ");
INSERT INTO sps_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“A saa te komainy rom anyi ma kat Anyo tsumanyi na?” “Tsunaun, nyo komainy matoong rou.” ");
INSERT INTO sps_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ai Jisas tsue fatabin to tsunia, “Mata manyi tagaa en, a faason tsumanyi tsipaar manyi.” ");
INSERT INTO sps_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sen tsun, ana ayei tagaa bus nato, ya vovou iny naa to Jisas, vamarits to Gov. Ana vainy tagei to na ka to aya ri variri kainy to Gov. ");
INSERT INTO sps_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ai Jisas sof naa to Jeriko, sa taan fafis enanaa. ");
INSERT INTO sps_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A mes te kaa na aya, a asangan ya Sakias a tsoiny mumua tan tsoiny nonom takis ana ayei a mes a masun. ");
INSERT INTO sps_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ayei komainy ma tagei e Jisas a saf a mes Ya na, ai Sakias kan a kakat to sa gima onot ma tagaa, tana saa, u tagin. ");
INSERT INTO sps_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","To sa kookuar famumua osing nan tagin, ya paas to tan Nau Sikamoo komainy ma tagaa ten Jisas to te ising fi naa non Ya na aya. ");
INSERT INTO sps_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tan nainy te nom naa Jisas tana pan na to aya Ya tagag to sa tagei naa Sakias, Ya tsue to tsunia, “Sakias, of veesau tsun me. Nyo nai kaa rou numaa tsumanyi roman.” ");
INSERT INTO sps_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakias of veesau tsun me putaa, sa mei naa Jisas numaa tsuan fiisen me na mamagat tsian. ");
INSERT INTO sps_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nainy te tagaa fi na fokinai nei, ri fangun'ngun to fapoopoan narari me na seeve ser tsue, “Ayei nai kaa fiisen minon mes a aveto.” ");
INSERT INTO sps_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ai Sakias tsun to, faatok iny a tsivon te reesik ya takopis osing ton aveto tsuan sa tsue, “Tsunaun, nyo faan iny rou panainy ka tsonyo tan vainy aaruts, sai te gam finy ronyo ta mes, tsonyo te nom rou a ka tsunia, nyo nai faan fapaas rou tan biny ya, onots non fats nainy tana fis a ka te nom anyo.” ");
INSERT INTO sps_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ai Jisas tsue to tsunia, “Te nun guei ten Abraham anyi kan, tovei roman Gov saup fatabiny manyi tan aveto, nyi an numaa iny guei tsuam, ");
INSERT INTO sps_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","tana saa Nyo, na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me te naa me a tou tsikoo rari te nun ror, Nyo te saup fatabin rari tan aveto.” ");
INSERT INTO sps_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A vainy vanongon kaner raror ten Jisas tana ka to, sa farong naa Ya, sa tsue of rarin tsue fapapaar, tana saa Ayei te nom fasiruu en Jerusalem to tana vainy fakats fi nei, nainy ten Gov iny fa'atouf e Jisas te sisiruiny ruak en. ");
INSERT INTO sps_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ana Ayei tsue to, “A isen a tsunaun te kat iny naa tana gum fan veevian ma nai bobot ari ya a faarei to na aatouf, vou ana ayei te tabin fan tsunia. ");
INSERT INTO sps_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Te kat iny tsun naa ya, ya fikoo raton safunuu na tsoiny binun tsuan, sa fafaan rarin, isiseiny tsoiny binun a gol moni te onots non a foiny tana isen a iifaa, ya tsue to tsuri, ‘Mi naa rom mi te vabinun iny ya, onot non te tabin mironyo.’ ");
INSERT INTO sps_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sana mesapan tana vainy tana gum fan tsunia koma iring iny ya ser jiat vovou ra naa na vainy tana pan te naa ya, ser tsue of ya, ‘Mam gim rom ma komainy manyi ma aatouf tsumam.’ ");
INSERT INTO sps_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Sai te fa'atouf fakap ari na tsunaun to aya, vou ya tabin to. Sen tsun ya faan iny naa ton tsue tan vainy binun tsunia, to na vainy te faan iny ya na gol moni, a natiny to na fis to te ruak te vabinun iny ari. ");
INSERT INTO sps_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A vaamuan naa me sa tsue, ‘Tsunaun, isen a gol moni tsumanyi te faan vanyo nyi te vabinun iny anyo sa faruak pis a mes a safunuu na gol moni.’ ");
INSERT INTO sps_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ana aatouf tsue to tsunia, ‘Rof ovei tsun, nyi na tsoiny binun a rof. Anyi kaa fasuu faarof me na taatsuan tana ka na kakaii, nyo nai fakaa marom anyi ma tatagaa ot iny anyi na safunuu na ngats fan tsian.’ ");
INSERT INTO sps_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ana fafuan nana tsoiny binun naa mito sa tsue, ‘Tsunaun, isen a gol moni tsumanyi te faan vanyo nyi te vabinun iny anyo sa faruak pis a mes a ngim a gol moni.’ ");
INSERT INTO sps_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ana aatouf tsue to tsunia, ‘Anyi nai tatagaa ot iny rom a ngim a ngats fan tsian.’ ");
INSERT INTO sps_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mesmes a tsoiny binun naa mito sa tsue, ‘Tsunaun, tovei a isen a gol moni tsumanyi te faan vanyo nyi, nyo paapau yan a painy raarav tsonyo famuiny ya. ");
INSERT INTO sps_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Anyo te oraav manyi tana saa nyi na mes a siireits, tana saa nyi natiny nom rom a ka gima kaa tsumanyi, ana nyi natiny agio rom tan tanun tana fo mes a fo vainy kaner te reev en.’ ");
INSERT INTO sps_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aatouf tsue to tsunia, ‘Nyi na tsoiny binun a pisiin! A fo vegiau te kat anyi, nyo kat rou ya iny fakaa manyi tan vaatsuk. Nyi nat vanyo na mes a siireits, natiny nom rou a ka tana mesmes ana nyo natiny agio rou a ka te gima anyo ma reev, ");
INSERT INTO sps_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kat fei to tsumanyi gima fasof a moni tana guuv iny fatamaar ei? To ma nom fatabiny anyo na moni tsonyo fiisen me na moni na takorot patsun!’ ");
INSERT INTO sps_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kat to ya tsue naa to tsuri te vatsutsun ror, ‘Nom osing yam a isen a gol moni naa to tsunia, am fainy towan a tsoiny binun to te kaa minon a safunuu na gol moni.’ ");
INSERT INTO sps_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ri tsue to tsunia, ‘Tsunaun, ayei kaa bus me na safunuu na gol moni.’ ");
INSERT INTO sps_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ya biny ratuari, ‘Nongon yam! E sei te kat non ta ka tana tee mar ka te faan iny e Gov ee, Gov nai faan pis iny non a ka na takorot tsunia, sai sei te gim non ma kat ta ka tana foka te faan iny e Gov ee, Ayei nai nom ravaa osing non ya na ka te kaa minon ya. ");
INSERT INTO sps_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ai tsuri to na vainy te koma iring varonyo, te tsugainy varonyo ma aatouf tsuri, ma mei ramiri nei er atsun famat to mata vanyo.’” ");
INSERT INTO sps_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Te fakap e Jisas tsue fapapaar, vou Ya taan famumua fi naa to tana ngats fan tsian iny Jerusalem. ");
INSERT INTO sps_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Te naa fasiruu naa ri tana fuan a ngats fan iny Betpeits ai Betani tan tobeer te koo rori na Tobeer tan Oliv, ya fakuar ra naa to na ina fuan a matisian Tsunia sa tsue tsuri, ");
INSERT INTO sps_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kuar yam tana fan naa to aya mata mami, ai te sof naa romi mi tagei rom a tsunei dongki te tang iny ari na aya a sikia ta mes ma gum voun ya a taataan iny towa, puruur yam mi te mei mi ya nei. ");
INSERT INTO sps_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta mes te rangat maromi, ‘A saa, te puruur of romi ya na?’ Tsue of yam, ‘A Tsunaun kaa minon a binun tsunia.’” ");
INSERT INTO sps_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Te naa naa ri sanaan, ri nai sab to na fo mamatsiny ka te tsue of rari Jisas te kaa patsukan fi kanen. ");
INSERT INTO sps_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Te pupuruur ari na tsunei dongki, ana vainy te fasito iny ya tsue to tsuri, “A saa te puruur of romi ya na?” ");
INSERT INTO sps_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“A Tsunaun kaa minon a binun tsunia,” te tsue fi ri. ");
INSERT INTO sps_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ana ri mei naa to na tsunei dongki ten Jisas. Ri nom ton vau tsuar ser ban iny ya tounon a tsunei dongki, ri fapaas Towa voun a tsunei dongki. ");
INSERT INTO sps_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Te gum Ya voun a tsunei dongki, Ya taan naa to ana vainy nom ton fo vau tsuar ser ban iny ya sanaan. ");
INSERT INTO sps_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nainy te naa fasiruu na Ya tana sanaan te of ising non tana Tobeer tan Oliv, an tagin iny matisian faavot tanik iny vaposok mito na mamagat iny variri Gov, men kuu tsian tana fo binun tsian iny faatok ana a fo tsipaar te tagei ari, ");
INSERT INTO sps_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Gov faparits non a Aatouf te naa minon tana asangan a Tsunaun! Aaverof jias Gormirmir ana vamarits naa non ten Gov a tsigtsig.” ");
INSERT INTO sps_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ana mesapan tsuri na Farasi tan tagin tsue to ten Jisas, “Tsoiny Fifaatsuts, tsue tap ir matisian Tsuam ma kaa faamo ri.” ");
INSERT INTO sps_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ai Jisas biny ratuari sa tsue, “U fats tovei onot ror ma vaposok men kuu tsian te kaa faamo fi rori.” ");
INSERT INTO sps_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Te naa fasiruu Jisas tana ngats fan tsian, ai tan nainy te tagei Ya na Jerusalem, Ya fakats rato na vainy, Ya tangis to. ");
INSERT INTO sps_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ana Ayei tsue to, “Jerusalem, Anyo komainy a vainy tsumanyi ma nat roman tana sanaan iny aaverof, sai tovei te takop busen mata rari, ");
INSERT INTO sps_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","tana saa, tana fo nainy te naa minon vou vainy koma iring marom anyi naa miror ri te nai aunoiny faafis farosoo ot puputaa na aunon fats tsumanyi, ana ri te kat tap iny a fo mamatsiny pan ana vainy gagon gim ror ma tafuts on me. ");
INSERT INTO sps_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ri nai kat rurei ovei marom anyi ana ri te atsuiny famat a vainy faavot tsumanyi gagon tana aunon. Ana sikia ta isen ta fats te kaa on nats non a fifatua to tana iinin ya, u fats to te tarop miror nei peto, tana saa, a vainy tsumanyi gim ror ma tagaa fanatnat iny e Gov te jiat Vaminyo ma saup rari, kat to aya ri te tsugei Vanyo.” ");
INSERT INTO sps_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas kat to sa sof naa gagon tana aunon tana saape ana Ya jiaat vavagen fatafuts rato na vainy te fafiifoiny iny a foka tsuar koman a saape. ");
INSERT INTO sps_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Sa tsue tsuri, “Te kirkir en tan Vegiau Ten Gov, Gov te Tsue, ‘Numaa Tsonyo koo rori na numaa iny fafaakats,’ ‘sana mi kat faarei ya na puts iny takop tan vainy kakabuts.’” ");
INSERT INTO sps_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ya fafaatsuts to tana saape tan mamatsiny nainy. Rin tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun Te kirkir iny e Moses an tsunaun nar vainy kaa men koman iny atsuiny Ya. ");
INSERT INTO sps_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sana ri gima onot ma kaa me ta sanaan iny kat a ka to aya, tana saa, a fokinai te kaa iny vanongon tsun Tsunia, komainy ma vanongon fiisok tana fo vegiau te kat Ya. ");
INSERT INTO sps_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tan sen nainy Jisas faatsuts to na vainy gagon tana saape, Ya favaanan kainy ton Vurungan Rof, an tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun te kirkir iny e Moses, an tsunaun tana taa Jiu naa mito Tsunia, ");
INSERT INTO sps_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ser tsue, “Nyi ma tsue of mamam, saf gumgum Tsumanyi to na, to Tsumanyi kat rom fo mamatainy ka to na? Sei faan Manyin gumgum to ee?” ");
INSERT INTO sps_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisas biny ratuari, “Nyo kan rangat maromin sen rangat. Ami ma tsue of Vanyo, ");
INSERT INTO sps_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","a tou fapeenan ten Jon, fei te nom e Jon gumgum iny fapeenan ei, poo fi me ten Gov ge tana mes?” ");
INSERT INTO sps_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ana ri tanik iny fatsitsien bus rato fapoopoan narari, “A saa te tsue rora na? Te tsue fi rora nei, ‘Te poo fi me ten Gov,’ ana Ayei te tsue na ka tsura, ‘Kat pas fei sam gima faamainy e Jon ei?’ ");
INSERT INTO sps_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sai te tsue fi rora nei, ‘Te poo me tana mes,’ a gum iny vainy tovei nai totouruei rarora, tana saa, ri faamainy e Jon ayei na kuigin faman.” ");
INSERT INTO sps_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ana ri tsue to Tsunia, “Mam gim rom ma nat fei to te poo fi mi ya ei.” ");
INSERT INTO sps_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ai Jisas tsue to tsuri, “Nyo kan gim rou ma tsue of mami to ten sei te faan Vanyon gumgum to Tsonyo kat a foka to ei.” ");
INSERT INTO sps_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kat to ai Jisas tsue of raton vainy tsue fapapaar sa tsue, “A mes te reev Gereip tanun tsuan, ana ya foiny ton tsoiny tatagaa ot iny tanun tsunia er binun tanun of towa, ana ya naa enato tana mes a fan kanen veevian sa nai kaan nainy viviakoo. ");
INSERT INTO sps_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ai tan nainy agio ya jiats to naa isen a tsoiny binun tsuan ma naa ya tan tsoiny tatagaa ot iny tanun er fainy towa ta tee fua nan tanun tsuan. San tsoiny tatagaa ot iny tanun nots ya ser rapits ya ri jiats babainy fatabiny naa towa. ");
INSERT INTO sps_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kat to an taman tanun jiats naa to na mesmes a tsoiny binun, san tsoiny tatagaa ot iny tanun nom ya ri rapits kainy towa, ri kat farejiaf ya, ri jiats babainy fatabiny naa towa. ");
INSERT INTO sps_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ya jiats pis naa to naa fafofopis nana tsoiny binun, san tsoiny tatagaa ot iny tanun fatafisuainy ya ri nom towa ser faviir iny naa towa jiarasan. ");
INSERT INTO sps_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kat to ana taman tanun wain tsue to, ‘A saa te kat ronyo na? Nyo jiats rou a guei tsoiny tsonyo te kaa non koman tsonyo, u man ri famaari ror ya.’ ");
INSERT INTO sps_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sai tan nainy te tagei ari ya, an tatagaa ot iny a tanun, favevegiau to fapoopoan narari ser tsue, ‘Ayei bus a guei tsoiny tan taman tanun to. Tanats yam ma atsuiny famat ara ya, ana fo mamatsiny ka tsunia fasito iny rora.’ ");
INSERT INTO sps_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ana ri nots towa ser ras tsitsikap iny naa towa jiarasan voun a tanun wain ser atsuiny famat ya. “A saa te kat non a taman a tanun tan tsoiny tatagaa ot tan tanun to na?” rangat fi Jisas. ");
INSERT INTO sps_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Ayei naa minon ana ayei te nai atsuiny famat faavot rari ana ayei faan iny tanun tana mesapan ma tatagaa ot iny ari ya.” Te nongoiny a vainy vegiau to ri tsue to, “Te gim non ma ruak fi nei!” ");
INSERT INTO sps_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisas matoong rari Ya rangat to, “Saf a man nan a ka to te tsue iny Vegiau Ten Gov na? ‘A fats a marats to te tsugei fuainy tsoiny fatsun numaa ruak faarei na fats a karap ovei tana numaa.’ ");
INSERT INTO sps_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A mes te tsukakab non tan fats a marats to aya ana ayei te gotsiny naa nai tatamoor ovei nanon, ana fats a marats te rus of ta mes, ayei nai oiny memedak ovei tsuiny non ya, ya te nai faarei nats kuaf.” ");
INSERT INTO sps_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","U Tsoiny fifaatsuts tan Faun te kirkir iny e Moses an tsunaun tan tsoiny faakor tanaf iny nots e Jisas tan nainy patsukan to aya tana saa, Ayei pokein tsue fapapaar te sak rari sana ri oraav ir a vainy. ");
INSERT INTO sps_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","To ser vavaatok Ya ri anaanos to tu nainy tu rof. Ri jiats naa to na tee vainy iny toobo er faarei naa ton vainy tavaron iny nai fataraatsua iny e Jisas me na fo rangat iny nots Ya, ri te faan iny naa Ya tana Roum gavana tana gum fan iny Judia. ");
INSERT INTO sps_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ana rin tsoiny fataraatsua tsue to ten Jisas, “Tsoiny Fifaatsuts, mam nat rom foka te tsue Nyi ge te fafaatsuts iny Anyin man, ana Nyi gim kan rom ma aspeer ta mes tan fakats tsuri, tana saa, kainon to te kaa fi mirorin asangan gen vainy babainy, sana Nyi fafaatsuts iny rom a man nane Gov tana vainy. ");
INSERT INTO sps_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nyi ma tsue of mamam te toobing non tan faun tsura ma foiny takis fi naa ten Sisa na aatouf iny Roum ge na sikia?” ");
INSERT INTO sps_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sen Jisas tagei faavots a fo gam tsuri Ya tsue to, ");
INSERT INTO sps_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Faatok Vanyo yam ta isen ta painy moni kainy foiny takis.” Ri mei mito na isen a painy moni. Ya rangats ratuari, “A nain e sei ana asangan e sei to aya ee, tana moni to?” Ri biny Towa ser tsue na ka, “E Sisa na aatouf.” ");
INSERT INTO sps_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ai Jisas tsue to tsuri, “Jio, fainy yam e Sisa na foka ten Sisa, am fainy to Gov a foka ten Gov.” ");
INSERT INTO sps_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ri gima onot ma tsue matar a vainy ma kat tu fataraatsua nan Ya tana fo vegiau te tsue Ya to ser kaa faamo er, sana ri ngian tana fo tsue te biny rari Ya. ");
INSERT INTO sps_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mesapan tana taa Sadusi te natiny tsue ror a sikia ta tou tsun fatabin tana mat naa mito ten Jisas, ri rangats Towa, ");
INSERT INTO sps_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tsoiny Fifaatsuts, Moses kirkir of raran faun sa tsue, Te mat osing non a mes, a moun tsuan, sana ayei gima faruak ta guei, ana famuinyasiny tsunia fanging to na amov ma faruak ari tu guei ten famuinyasiny tsunia to te mat a sikia ta guei. ");
INSERT INTO sps_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Eye, te kaa men mumuinyasiny ina fits ana vaamuan fanging to, sa gima potsian ya mat enato a sikia ma faruak ta guei. ");
INSERT INTO sps_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kat to ana fafuan nana famuinyasiny fanging pis to na moun to aya, ");
INSERT INTO sps_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ana fafofopis nana famuinyasiny fanging pis kainy towa. Sa onot ovei rari na ina fits mumuinyasiny, ser mat faavot er, a sikia ma faruak ta guei. ");
INSERT INTO sps_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ai voun ya, ana moun mat kan nato. ");
INSERT INTO sps_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ai to tan nainy tana tou tsun fatabin tana mat, e sei tsuri te nai faarei non a tsoiny tana moun to ee, tana saa, ari na ina fits ovei mumuinyasiny te kaakaa mi ya.” ");
INSERT INTO sps_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ai Jisas biny ratuari, “U tsoiny an moun tan nainy roman te rof ror tan fifanging. ");
INSERT INTO sps_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sana rin tsoiny min moun to te tamainy ror a tou tsun fatabin tana mat tan nainy vou, gim ror ma nai fifanging pis. ");
INSERT INTO sps_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ri gim ror ma mat pis, sai te nai faarei ror morena. Arin guei ten Gov, tana saa, Gov fatsun fatabin rari tana mat. ");
INSERT INTO sps_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ai Moses faatok ratuara tana mes a mat nai tsun fatabin non ya te kaa me na toto, tan nainy te kirkir yan vegiau, Gov a Tsunaun te tsue of ya tan koman guaf te ruak tan nau kakaii sa gima maas sa tsue, ‘Anyo na Gov ten Abraham, ana Gov ten Aisak, ana Gov ten Jekob.’ ");
INSERT INTO sps_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A man nan tsue to aya, Ayei na Gov tan vainy te toto ror, a sikia ma Gov tan vainy mat, tana saa, i Tsunia tsun te toto ror a vainy.” ");
INSERT INTO sps_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mesapan tsurin tsoiny fifaatsuts tan Faun te kirkir iny e Moses nongon to ser tsue, “Tsoiny Fifaatsuts, Nyi biny faarof tsuiny rangat.” ");
INSERT INTO sps_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sana sikia ta isen tsuri ma ongoor iny rangat pis. ");
INSERT INTO sps_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ai Jisas tsue to tsuri, “Kat fei to tsuri tsue ror a Krais a Tsoiny Fiisaup a tsubnaain ten Devit ei, ");
INSERT INTO sps_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","tana saa, e Devit patsukan te kat kirkir nane Krais a Tsoiny Fiisaup tan Kooma iny Vadou, ‘A Tsunaun e Gov te tsue tana Krais a Tsunaun tsonyo, Gum nei tan panaainy matou Tsonyo, ");
INSERT INTO sps_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","onot non te fakei finy Ronyon fo vainy te koma iring marom Anyi er kaa to fain a mou Manyi.’ ");
INSERT INTO sps_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit koo Ya, Krais, ‘A Tsunaun tsonyo,’ a tsubnaain tsunia. Fei te kat fi na Krais a Tsoiny Fiisaup sa gima tsubnaain babainy ten Devit ei, Ayei karap fafis iny non e Devit, taava?” ");
INSERT INTO sps_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A vainy kaa iny vanongon eraror, ai Jisas tsue to tan matisian Tsunia, ");
INSERT INTO sps_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tanamots yam tsoiny fifaatsuts tan Faun te kirkir iny e Moses. Te kaa miror koman iny taan vavis men vau beberus iny jiarasan er komainy to ta mes ma favoinyvoiny rari tana pan iny tuan ai tan gum tan gumgum matan tana numaa iny fafaatouf, ai tan tsutsun tana vaamuan nana pan iny guainy. ");
INSERT INTO sps_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ana ri fagaug raror fo amov er kabuts paser numaa tsuri, ana ri kat faatok er mata rari tan kat a fo faakats viviakoo ma famuiny ari na fo iring tsuri. Tan kat to aya fasaraa tsuri nai karap fafis non.” ");
INSERT INTO sps_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","E Jisas matoong, Ya tagei ton vainy masun te fau iny fo fifaan tsuar koman a guuv tana saape. ");
INSERT INTO sps_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ya tagei kainy to na amov a aaruts te fau na fuan a painy takep moni. ");
INSERT INTO sps_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ya tsue to, “Nyo tsue faman of maromi, a amov a aaruts tovei te faan fafis pis tana mesapan, ");
INSERT INTO sps_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","tana saa, mesapan to ari te faan ravainy a kakaii tsun tana fo masun tsuri ser faan iny ya, sana amov tovei faan seerep iny a pan iny ainy tsunia tana kainy aaruts tsunia.” ");
INSERT INTO sps_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mesapan tsurin matisian Tsunia, tsue tsuk iny a saape, tana tou mamatainy saavits tsunia fiisen me na fo fats a fo rof fiisok ana fo fifaan te faan iny a vainy ten Gov ser kat ya na saape. Sen Jisas tsue, ");
INSERT INTO sps_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“To tana foka te onot romi ma tagei roman, tan nainy te naa minon sikia ta isen ta fats te fifatua on nats non a fifatua to tana iinin ya; fo fats to tarop miror nei peto, ri te nai soon er putaa.” ");
INSERT INTO sps_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ana vainy rangats to Jisas, “Tsoiny Fifaatsuts, farainy te nai ruak nats non a ka to? Ana saf a ka te nai ruak nats non na ana ya te faatok fatoobing iny nainy te sisiruiny ruak ename?” ");
INSERT INTO sps_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ai Jisas tsue to, “Tanamots yam, am famanat vaare to ta mes ma fagaug mami ya, tana saa vainy a kinai naa fiisen miror a asanga Vanyo ri te tsue na ka, ‘Anyo na Krais! Nainy te ruak en.’ Vovou vaare ir yam. ");
INSERT INTO sps_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nainy te nongoiny romin sagoge nana puaan, gen nainy vapupuaan, a foka to aya ma ruak faamuan tsom, sana mi ma oraav vaare. Te gim non ma faatok iny a fafakap te siruu en.” ");
INSERT INTO sps_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ana Ayei tsue to tsuri, “Fo gum fan te fapupuaan ramiror mes a fo gum fan kaner, ana isen a aatouf an tsoiny puaan tsuan vapupuaan miror a aatouf an tsoiny puaan tsuan; ");
INSERT INTO sps_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","fo nuu tsian nai ruak nats ror, an nainy ves nai ruak nats non tana fo viir pan, an nainy faadis nai ruak non, ana foka iny fa'oraav, ana fo ka iny faatok ruak minon jias. ");
INSERT INTO sps_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sana foka to aya tabuiny ruak ror, ri nai nots maromi er kat fapatang matuami er fakamits matuami. Ana ri te nai kat vaatsuk tsumi tan numaa iny fafaatouf tana taa Jiu ana ri te nai kotskots mami. Ana ri te fatsutsun mami matar gotouf an tsoiny tsian tana gamaman, tana saa, mi govets rom a asanga Vanyo. ");
INSERT INTO sps_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tan kat tsun to aya, ayei nainy rof tsumi iny favaanan iny Vurungan Rof tsuri. ");
INSERT INTO sps_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sana mi ma fatsuiny a fo fakats tsumi, mi te fakats pinpin faamuan vaare fei te nai tsue fi romi ei, kainy kat tap tsue tsuri, ");
INSERT INTO sps_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tana saa, Nyo faan maromin vegiau ana nat tsian to te sikia non ta mes te koma iring maromi, te onot non ma aspeer fo vegiau tsumi, ge ma faungis iny ya, to te tsue romi ta ka. ");
INSERT INTO sps_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Fo tamamami an tsinamami an famuinyasiny, an nuatsi mami an vaatau tsumi nai fafaatai faruak maromi ana ri te faan mami, ari to te nai kat fijior mami, ana mesapan tsumi ri nai atsun famat rarori. ");
INSERT INTO sps_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A fokinai nai tsugei maromi, tana saa mi kaa mirom a asanga Vanyo. ");
INSERT INTO sps_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sana sikia ta ar funuu patsuu mami te nai nun non. ");
INSERT INTO sps_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Suu iny yam a faason tsumi Tsonyo onot non tan fafakap nan puputaa to, mi te nai nom a toto na suu.” ");
INSERT INTO sps_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nainy te tagei romin tsoiny puaan te bau faafis ror a Jerusalem mi nat bus em, a iring tsian fiisok naa osto mito ana Jerusalem nai taruraa enanon tovei tsun. ");
INSERT INTO sps_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ana ri te kaa ror tana gum fan iny Judia ma bus naa tana fo tobeer, ana ri te kaa ror koman a ngats fan tsian ma naus osing a ngats fan tsian, ana ri te kaa ror jiarasan tana ngats fan tsian ri ma sof vaare naa tana ngats fan tsian iny Jerusalem, ");
INSERT INTO sps_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","tana saa a fo nainy to aya, a fo nainy nan nainy iny fasaraa tsian to te faruak non a man tana foka te tsue iny Vegiau Ten Gov. ");
INSERT INTO sps_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","O reesik fiisok, ma sekee fuainy moun kuraa, an fuainy moun see faagiir, ri fasus ror tan guei tsuri, tana saa, te nai kaa minon nainy saraa kamits tsian tana gum fan iny Judia faavot, ana koma seeve ten Gov nai kat fiiring raror a vainy tan puputaa to aya. ");
INSERT INTO sps_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mesapan tsuri nai atsun rarorin kirat tana puaan ana mesapan ri gog rarori, ri te mei ra naa ri tana mes a fo gum fan. An vainy vavaajets a sikia ma taa Jiu nai pitei miror a Jerusalem onot to tan nainy te fagum e Gov, ito tan fo nainy te faonot fi rorin vainy sikia ma taa Jiu.” ");
INSERT INTO sps_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Te kaa mi nats non ta ka iny faatok tana nuaf, ana iifaa an fo kootsits. Tan petoo tovei, fakats tan vainy koman a fo gum fan nai onanun eraror, ana fokinai nai oraav ror te tangats fi minon posaa tsian, an ras. ");
INSERT INTO sps_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A vainy a kinai oraav ror ana pua rari te tameruts en tana foka te ruak minon tana monaagits tovei, tana saa fo mamatsiny parits iny korosuu nai tatagut eraror er tasas osing to naa fo iinir, ");
INSERT INTO sps_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ana vainy faavot te see tatagei bus a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me of fiisen minon a koroo fiisen minon a parits a reits an siinaiv karap fiisok. ");
INSERT INTO sps_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tan nainy te tanik iny ruak non a fo mamatsiny ka, Nyo tsue of bus mami, tsutsun yam am matoong fi naa to jias tana saa, a mes te pats mami, tou puruur mami kat iny naa os mito a tou saup mami.” ");
INSERT INTO sps_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kat to ai Jisas tsue of ratuarin tsue fapapaar tovei, “Tagaa yam tan nau u vei. ");
INSERT INTO sps_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tan nainy te tagei romin vei te firaar non mi natiny rom fua nan vei te sisiruu en. ");
INSERT INTO sps_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jesan kan te tagei finy romi na fo mamatsiny ka te roruak non mi ma nat fi nei, nainy ten Gov te jiats Varonyo Ya na Aatouf te sisiruu ename. ");
INSERT INTO sps_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Fakats faarof yam a ka to! U aatai tovei te toto farokot kan raror tabuiny mat ror ana fo mamatsiny ka te tsue Nyo to nai ruak nats non. ");
INSERT INTO sps_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Korosuu an puputaa nai kajiaa enanon san vegiau Tsonyo gim non ma nai kajiaa on.” ");
INSERT INTO sps_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Tanamots yam, mi ma kat vaare na tsivom tana sanaan iny kat guainy vaurep, jiun mafuu, an fakats fiisok a fo mamatsiny ka tana toto iny roman, kat non san kat nana tou tabin me tana Tsunaun fakarian me faarei non a vavaatsu te fakarian non a voo, te pon fi romi nei, tabuiny nainy non, ");
INSERT INTO sps_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","tana saa a ka to aya te ruak nats non tana vainy faavot tana monaagits to. ");
INSERT INTO sps_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ami ma kaa iny vavaatok tan mamatsiny nainy, am kaa iny faakats to mi te onot ma tsutsun faparits am aruwas osing to na foka te ruak nats non, ana mi te nai tsutsun matan a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me.” ");
INSERT INTO sps_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tana fo isiseiny nainy Jisas natiny fafaatsuts non koman a saape, ai tana fo ananerof, ayei natiny tafuts osing non a ngats fan Ya te nai kaa tana Tobeer iny Oliv, onots ovei non a voiny. ");
INSERT INTO sps_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ai tana voinyvoiny vainy kinai natiny fasaar miror iny vanongon Tsunia koman a saape. ");
INSERT INTO sps_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","U nainy Guainy te ainy rorin Koinykoiny Sikia ma kaa me tu Yis te siruu en naa me te koo rorin Nainy iny Fakats Fatabin nainy te faakouts e Gov a taa Isrel ser naus osing me na gum fan iny Ijip. ");
INSERT INTO sps_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","An tsunaun tan tsoiny faakor ana rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses komainy ma sainy ta sanaan iny nots e Jisas, er atsun famat Towa, sana ri te oraav ma kat ya tana arasan, kat ror sana vainy fatsuiny fitaatsun fiisen ramiri. ");
INSERT INTO sps_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kat to, ai Satan sof to na koman e Judas to te koo ri Iskariot, a isen tsuri na safunuu ana ina fuan a matisian. ");
INSERT INTO sps_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ai Judas naa fi naa to tan tsunaun tan tsoiny faakor an tsoiny mumua tan fuainy tsoiny bei ot tana saape ma vegiau tsuk iny ari fei te nai faan finy non ya e Jisas nima rari ei. ");
INSERT INTO sps_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ri paparaa ri fatangan to ma faan iny ta moni tsunia. ");
INSERT INTO sps_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas kan te faarof iny ya, kat to ana ayei tanik sainy to tu nainy tu rof ma faan iny ya Jisas tsuri, sana vainy ma nat vaare iny a ka to aya. ");
INSERT INTO sps_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","U nainy nan Guainy te ainy rorin Koinykoiny Sikia ma kaa me tu Yis te ruak en iton nainy te atsuiny kainy rorin fo tsunei siip nan u Guainy iny Fakats Fatabin ton nainy te faakouts e Gov a taa Isrel ser naus osing me na gum fan iny Ijip. ");
INSERT INTO sps_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ai Jisas jiat rato ere Pita me Jon sa tsue tsuri, “Kua yam mi te kakoun a pan iny ainy tsuran Guainy iny Fakats Fatabin.” ");
INSERT INTO sps_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ana ri rangats Towa, “Fei te komainy rom Anyi mam ma nai kakouiny Guainy iny Fakats Fatabin ei?” ");
INSERT INTO sps_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ya tsue to tsuri, “Nongon yam! Te sof naa romi tana ngats fan tsian ana isen a mes a govet kepaa aurom te sab maromi sanaan, vovou iny naa yam mi te sof naa tana numaa te sof naa non ya, ");
INSERT INTO sps_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ana mi te tsue tana taman a numaa, ‘A Tsoiny Fifaatsuts te rangat mami nyi, Fei te kaa non a pan te nai ainy Ronyon Guainy iny Fakats Fatabin fiisen ramen matisian Tsonyo ei?’ ");
INSERT INTO sps_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ayei faatok maromi na pan tsian jias te kaa minon a fo mamatsiny ka iny kakoun a kainy ainy tana numaa, ayei na pan te nai kakoun romi na fo mamatsiny ka.” ");
INSERT INTO sps_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ana ri naa naa to, ser sab a fo mamatsiny ka to te tsue of rari Jisas, ser kakouiny Guainy iny Fakats Fatabin. ");
INSERT INTO sps_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Te ruak bus nainy ai Jisas an amaraav Tsunia gum to tana taran iny ainy. ");
INSERT INTO sps_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ya tsue to tsuri, “Anyo kaa mirou koman tsian iny ainy fiisen mamimi tan Guainy iny Fakats Fatabiny, tabuiny nai sarei Ronyo na kamits, ");
INSERT INTO sps_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","tana saa, Nyo tsue of maromi, Nyo gim rou ma nai ainy pis ya fiisen mamimi, onot non a man nan koinykoiny an wain te nai ruak iny man non koman a Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kat to ai Jisas nom to na gotan wain, Ya faarof iny towa ten Gov, sa tsue, “Nom yam a ka tovei, ana min isisen te jiu ya fapoopoan namami. ");
INSERT INTO sps_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sai tovei Nyo tsue rou tsumi, Nyo gim rou ma jiu pis nats wain tovei onot non te naa minon a Waan e Gov.” ");
INSERT INTO sps_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ya nom to na koinykoiny, sa faakats iny faarof of naa towa ten Gov, Ya ivoo towa, sa fafaan rari ya, Ya tsue to, “A pua Vanyo tovei, te orovus of mami. Kat vaurep yam a ka tovei kainy fakats fatabiny Vanyo.” ");
INSERT INTO sps_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Te ainy fakap arin Guainy iny Fakats Fatabiny, jesan, Jisas nom to na gotan wain sa tsue, “U rafatsiny Tsonyo tovei te faparits non tsue faunot foun ten Gov, rafatsiny Tsonyo tatsiiu of maromi. ");
INSERT INTO sps_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tagaa, a mes te faan iny Varonyo tan vainy ma nai atsuiny Vanyo ri a niman ya te kaa fiisen bus Vamironyo tovei tana taran iny ainy, ");
INSERT INTO sps_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","tana saa, A Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai mat non to te fagum fi Gov, sana sekeiny, mes to te faan iny Ya, Gov nai fainy non ya na fasaraa tsian.” ");
INSERT INTO sps_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kat to ser fararangat fatabin ir fapoopoan narari, “E sei bus ee te kat non a ka to, ee?” ");
INSERT INTO sps_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","An matisian fa'ararat iny to e sei tsuri te karap fafis non ee? ");
INSERT INTO sps_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ai Jisas tsue to tsuri, “U aatouf vavaajets tana monaagits tovei te tsunaun kookop faavot raror a vainy tsuar, ana ri to te gumgum ror ana fo parits te natiny vakek rari to te kaa ror fain nimar tsunaun tsian. ");
INSERT INTO sps_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sana mi ma kat fi vaare nei. Ami ma kat fi nei, a karap fapoopoan namami nai faarei non a mes a see mes, ana tsoiny mumua nai faarei non a tsoiny binun tsumi. ");
INSERT INTO sps_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ai sei to te karap fafis non ee? A mes te gum iny ainy non, ge na mes to te kat of non a mesmes a kainy ainy? A mes to te gum iny ainy non, taava? Sana Anyo tsun vaa ei aa, to te kaa rou fapoopoan namami, faarei rou a tsoiny binun tsumi. ");
INSERT INTO sps_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ami koraa to ari to te tsutsutsun pana Vanyo tan nainy te ruak me na fo tanaf Tsonyo, ");
INSERT INTO sps_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","to te faarei tsuiny non e Tamanyo te faan iny tsue faunot ma tagaa ot iny Anyo na Waan Ya, jesan kan non, Anyo te faan iny tsue faunot tsumi ");
INSERT INTO sps_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","to, ami nai ainy rom, mi te jiu tana taran tana Waa Vanyo, to ami te nai gum kanem marom tana fo tagan tsuam iny kat vaatsuk tana safunuu ana fuan a vun tana taa Isrel.” ");
INSERT INTO sps_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kat to ai Jisas tsue to, “Saimon, Saimon Satan te nom bus tsue faunot iny tanaf a faaman tsumi faavot faarei non te kat fi ror tsoiny binun tanun, to te tegteg iny rorin wit an pem te rus ravaa naa. ");
INSERT INTO sps_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sana Nyo te faakats of bus manyi Saimon, ma kap faavot vaare na faaman tsumanyi. Eye, a faaman tsumanyi nai gagaar non, sai te takopis fatabin fi rom anyi Tsonyo, nyi kan ma faparits kan ir fo vamuinyasiny tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ai Pita biny Towa sa tsue, “Tsunaun, nyo kakoun iny naa fiisen ma mirom Anyi tana numaa iny kotskots iny mat fiisen ma Minyi!” ");
INSERT INTO sps_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas biny towa, “Nyo tsue of marom anyi Pita, tabuiny kokorooto non a koriou a tsoiny roman, nyi nai faungis Varonyon fopis nainy, nyi gim rom ma nat Vanyo.” ");
INSERT INTO sps_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kat to, ai Jisas rangat ratuari, “Farainy te jiat babainy im yam a sikia ta poraa moni, ge vio, ge tu suu, sana mi aaruts iny ta ka?” Ana ri tsue to, “A sikia.” ");
INSERT INTO sps_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ai Jisas tsue to tsuri, “Sai tovei u nainy tana fo patang to te govets romin vegiau Tsonyo, e sei te kaa minon ta poraa moni ee, mei naa fiisen men vio, ai sei te gim non ma kaa me tu kirat iny puaan ee, ma fafiifoiny iny vau tsian tsuan ai te foiny tu kirat iny puaan, ");
INSERT INTO sps_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","tana saa, te nai ruak non tsonyo te vovou iny non Vegiau Ten Gov te tsue en, ‘A vainy tagei ror Ya faarei me na mes a iring.’ Nyo tsue of maromi, na ka to aya ma ruak Tsonyo, tana saa, a foka te kirkir of Vanyo ri tan Vegiau Ten Gov te ruak iny man nats non.” ");
INSERT INTO sps_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","An matisian tsue to Tsunia, “Tagaa Tsunaun, fuan kirat iny puaan tovei.” Ya tsue to tsuri, “Te onot en tan vegiau.” ");
INSERT INTO sps_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas naus osing a ngats fan tsian to te kat kat fi Ya tan nai faakats tana Tobeer iny Oliv, an matisian Tsunia vovou kan iny naa Towa. ");
INSERT INTO sps_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nainy te ruak Ya tana pan na aya, Ya tsue to tsuri, “Ami ma faakats kat non sana foka iny tanaf naa me a fagotsiny matuami.” ");
INSERT INTO sps_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ayei taan fajesa naa to, sa onots a veevian to te tats finy naa non a mes a fats, sa fatukun Ya tsunguruu to, sa faakats fi nei, ");
INSERT INTO sps_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamau, tan mangiir tsun Tsumanyi nom ravainy osing You a gotan iny saraa kamits to Tsonyo, san sikia ma tan mangiir Tsonyo, u mangiir tsun Tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kat to ana morena iny Gormirmir ruak to Tsunia sa faparits Ya. ");
INSERT INTO sps_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ai Jisas sarei to na patang tsian, Ya suu faparits iny ton faakats, an siiva ruak to Tsunia sa faarein rafatsiny sa tsinik fi naa tan puputaa. ");
INSERT INTO sps_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nainy te fakap Yan faakats Tsunia, Ya tsun to sa tabin fi naa tan matisian Tsunia, sa sab rarin goros, tana saa, ri te kaa men koma reesik tsian. ");
INSERT INTO sps_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ya rangat ratuari, “Kat fei tsumi gogoros rom ei? Tsun yam am faakats to ma gotsiny vaare mi tan fiamus.” ");
INSERT INTO sps_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas vegiau kanen nanon an tagin ruak mito ana mes te koo ri Judas, a isen tsuri na safunuu ana ina fuan a matisian, to te mumua ra mi ri naa mito ten Jisas sa umei Ya. ");
INSERT INTO sps_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sen Jisas rangats ya, “O Judas, nyi na tou umei iny faan Vanyo, na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, nima rari?” ");
INSERT INTO sps_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tan nainy te tagaa fin matisian Tsunia nei to te kat iny ruak fi na ka to, ana ri tsue to, “Tsunaun, mam onot rom ma tek rarin kirat iny puaan?” ");
INSERT INTO sps_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kat to ana isen tsurin matisian tek sapee na teinan tan panaainy matou tana tsoiny binun babainy tan Tsoiny Mumua tan Tsoiny Faakor. ");
INSERT INTO sps_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ai Jisas tsue ratuari, “Kat pis vaaren kat to!” Ya saras to na teinan a mes, ya rof fatabin nato faarei muan. ");
INSERT INTO sps_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kat to ai Jisas tsue to tan tsunaun tan tsoiny faakor an tsoiny mumua tan tsoiny bei ot tana saape an tsunaun tana taa Jiu to na tou nots Ya, “Mi naa me fiisen men kirat an vuts iny nots Vanyo faarei Varonyo na mes a kakabuts. ");
INSERT INTO sps_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nyo kaa fiisen mamimi gagon tana saape tan mamatsiny nainy, ana mi gim to ma nots Vanyo. Sai tovei u nainy tsumi, a parits tana uurup te kookop mami.” ");
INSERT INTO sps_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ana ri kat to ser nots e Jisas, ri mei naa Towa tana numaa tana Tsoiny Mumua tan Tsoiny Faakor, ai Pita tsuktsuk naa Towa, sana ayei taan faveevian kanen na minon. ");
INSERT INTO sps_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sai tan nainy te faakor arin guaf fapoopoan nana pan koman a aunon nana numaa ser gum babau iny mangin ror tan guaf, ai Pita gum fiisen kan ramituari. ");
INSERT INTO sps_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ana kooviou, a muiny binun tana Tsoiny Mumua tan Tsoiny Faakor inainy e Pita te mangin fi ya tan guaf. Ya fasiruu naa to tsunia sa tsue tsuri na mesapan, “A mes to aya te kaa fiisen me Jisas!” ");
INSERT INTO sps_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sana ayei faungis, sa tsue, “O kaa, nyo gim rou ma natiny a mes to aya!” ");
INSERT INTO sps_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gima potsian, ana mes te tagei ya tsue to, “Anyi koraa na isen tsuri, ge!” Sen Pita biny ya sa tsue na ka, “A poo! Sikia ma nyo!” ");
INSERT INTO sps_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Voun a isen a aua, ana mesmes ruak mito sa tsue faparits, sa tsue, “U man, a mes to aya te kaakaa fiisen mami nyi, tana saa, ayei kan a tsoiny Galili!” ");
INSERT INTO sps_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sen Pita biny ya sa tsue, “Paai! Nyo gim rou ma natiny a ka tsue rom anyi!” Pita vegiau farokot kanen nanon sen tsun ana koriou a tsoiny kokorooto nato. ");
INSERT INTO sps_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ana Tsunaun takopis to sa matoong fatoobing naa Pita, ai Pita fakats fatabiny pis ton vegiau te tsue iny a Tsunaun tsunia, “Tabuiny kokorooto non a koriou a tsoiny roman, nyi nai faungis Varonyon fopis nainy, nyi te tsue nyi gim rom ma nat Vanyo.” ");
INSERT INTO sps_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ai Pita tafuts to jiarasan, sa buts iny tangis fa'og'og. ");
INSERT INTO sps_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A vainy te tatagaa ot iny naa Jisas te taring iny Ya, ri rapits Towa. ");
INSERT INTO sps_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ana ri kat to ser ping a matan Yan raarav, ana ri rangats Towa, “Jio, Nyi na kuigin ten Gov, pokei of mamimam e sei to aya te sapan Manyi ee?” ");
INSERT INTO sps_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ser tsue vaaserere iny Ya tan vegiau kinai. ");
INSERT INTO sps_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Te takiir me na nainy, an tsunaun tana taa Jiu, an tsunaun tan tsoiny faakor, an tsoiny fifaatsuts tan Faun te kirkir iny e Moses, vaaguam faavot to, ana tsoiny bei ot tana saape mei naa Jisas matar Kansol tsuri ser tsue, ");
INSERT INTO sps_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Tsue of mamimam, Anyi koraa na Krais, a mes to te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy ge na sikia?” San Ayei tsue of rari, “Nyo tsue of maromi, ami gim rom ma faamainy tsue Tsonyo. ");
INSERT INTO sps_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ana Nyo rangat maromi, ami gim rom ma biny tsue Tsonyo. ");
INSERT INTO sps_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sai te tanik non roman an tana fo nainy te naa minon a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai gum non tan panaainy matou tana Gov a Siireits.” ");
INSERT INTO sps_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ana ri na fokinai rangats faavots Towa, “Nyi na Guei Tsoiny ten Gov a?” Ya biny ratuari, “Te toobing non to te tsue fi romi, Anyo koraa to aya.” ");
INSERT INTO sps_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ana ri kat to ser tsue, “Saa kat fei to tsura komainy pis ror tu mes tu vegiau ei ma poo me tana mes a vainy? Ra nongon fatoobing er nguen Ya fatoobing.” ");
INSERT INTO sps_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","An tsoiny tsian vaaguam faavot tsun to ser mei naa Jisas, Ya tsutsun to matan e Pailat a gavana tana gum fan iny Judia. ");
INSERT INTO sps_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ana ri tanik iny sak Towan vegiau matan e Pailat, “Mam sab a mes to te natiny ras fuainy raror a vainy tsumam natiny tsue of raror a vainy ma foiny vaare rin takis ten Sisa na aatouf iny Roum, ana Ayei kan natiny tsue non Ayei na Krais, a aatouf te nai saup mamiromam.” ");
INSERT INTO sps_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kat to, ai Pailat rangats Towa, “Nyi Ya na Aatouf tana taa Jiu?” Ai Jisas biny towa sa tsue, “Na, toobing non tsue fi rom anyi.” ");
INSERT INTO sps_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kat to, ai Pailat tsue to tan tsunaun tan tsoiny faakor an tagin, “Nyo gima sab ta ka ta iring tana mes tovei te onot ronyo ma pokei Ya a mat to.” ");
INSERT INTO sps_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sana ri te parits patsukaner iny tsue, “Ayei te fatsuiny fakats tana vainy faavot tana gum fan iny Judia tana fo fafaatsuts Tsunia, Ayei tanik me tana gum fan iny Galili sa naa ovei naa me nei.” ");
INSERT INTO sps_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tan nainy te nongoiny e Pailat fo vegiau to, ya rangat to, “A mes to na tsoiny Galili ge?” ");
INSERT INTO sps_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nainy te nat fi Pailat nei, Ayei kaa non tana gum fan te tagaa ot iny non e Herot, ya kat to sa jiats finy naa Ya ten Herot, tana saa ayei kan te kaa Jerusalem tan nainy na to aya. ");
INSERT INTO sps_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tan nainy te tagei e Herot e Jisas, ana ayei kaa mito na paparaa tsian, tana saa, ayei te komainy ma tagei fiisok Ya tan nainy viviakoo. Ana ayei kan te kaa men koman iny tagei ta ka iny faatok ma kat e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","To sa rangats e Jisas rangat kinai, sen Jisas gima biny ta isen ta karainy vegiau. ");
INSERT INTO sps_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Fuainy tsunaun tan tsoiny faakor an tsoiny fifaatsuts tan Faun te kirkir iny e Moses, tsutsun faruak to ser sak e Jisas fo vegiaun parits. ");
INSERT INTO sps_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ai Herot min tsoiny puaan tsunia tsue taring iny to Jisas ser tsue vaaserere iny Ya. Ri kat to ser nom vau saavits iny aatouf ser favau Ya. Ri jiats fatabiny naa Towa ten Pailat. ");
INSERT INTO sps_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ai tan ar nainy farokot to aya, Herot me Pailat ruak iny vaatau bus rato, sai muan ri koma iring iny isisen tsuri patsukaner. ");
INSERT INTO sps_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ai Pailat fikoo vaaguam raton fuainy tsunaun tan tsoiny faakor, fuainy tsunaun ana vainy faavot, ");
INSERT INTO sps_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","sa tsue tsuri, “Mi atoiny me naa mes tovei tsonyo, to tsumi tsue, ‘Ayei te raras fuainy raror a vainy.’ Sai tovei, nyo te kat vegiau iny saaiv Ya mata mami, nyo gima sab ta ka ta iring Tsunia, to tana fo tsue na fo iring te kat ami Tsunia. ");
INSERT INTO sps_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot kan to te gima sab ta iring Tsunia, to sa faan fatabin iny mi Ya nei tsura. A mes to aya te gima kat ta iring to te onot non Ya ma mat of ya. ");
INSERT INTO sps_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sai tovei, vainy puaan tsonyo rapits Ya, nyo jiats fatafuts rou Ya.” ");
INSERT INTO sps_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tana fo isiseiny Guainy iny Fakats Fatabiny, Pailat natiny fatafuts non a isen tsurin vainy kotskots. ");
INSERT INTO sps_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","An tagin biny towa ser kuu fatsian faavot, “Atsuiny Yam! Ana mi te fatafuts me Barabas nei tsumam!” ");
INSERT INTO sps_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(E Barabas te fasof ari tana numaa iny kotskots, tana saa, ayei te kaa fiisen ramirin vainy te fapupuaan fiisen me na gamaman iny Roum tana ngats fan tsian iny Jerusalem, ana ayei kan a fifitokon.) ");
INSERT INTO sps_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat kaa men koman iny fatafuts e Jisas, to sa vegiau pis naa tan tagin. ");
INSERT INTO sps_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sana vainy kuu fatabiny naa ser tsue, “Fagageits yam, fagageits yam e Jisas tana pagafuan!” ");
INSERT INTO sps_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ai Pailat tsue pis naa to tsuri tan fafofopis nan nainy, “Kat fei? Saf a iring te kat Ya na? Nyo gima sab ta iring te kat a mes to, ai te onot ma mat of Ya. Sai tovei, tsoiny puaan tsonyo te rapits ror Ya, nyo te jiats fatafuts nats Ya.” ");
INSERT INTO sps_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sana ri kuu fatsian faparits patsukaner ra naa ma fagageits ari Jisas tana pagafuan, ana ri kat to ser fabiu Pailat. ");
INSERT INTO sps_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tan kat to aya, Pailat famanat iny to e Jisas ma mat to te tsue faparits fi ri. ");
INSERT INTO sps_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ya fatafuts to Barabas to te koman fi ri, tsunia te kaa koman a numaa iny kotskots tana saa ayei fapupuaan fiisen me na gamaman iny Roum, ana ayei a fifitokon, sen Pailat fatafuts ya. Ya nom to Jisas sa faan iny Ya nimar tsoiny puaan vovou iny koman tan tagin. ");
INSERT INTO sps_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Te mei naa ri Jisas, ser sab a isen a mes a tsoiny Sairini, koo rori Saimon, ayei te poo fi me tanun sa taataan fi naa tana ngats fan, ser tsue sosos of ya, ri fagovets towa na pagafuan ten Jisas, ri tsue of towa ma vovou iny naa ya Jisas. ");
INSERT INTO sps_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","U tagin vovou iny naa Ya, ai fapoopoan narari moun kinai iny Jerusalem te kaa kan, ri tatangis na Ya fiisen men vaa'ur. ");
INSERT INTO sps_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ai Jisas takopis of ratuari sa tsue, “Muiny Jerusalem, mi ma tangis vaare Vanyo, sana mi ma tangis a tsivom an guei kakaii tsumi, ");
INSERT INTO sps_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","tana saa, te ruak nats non nainy iring ana vainy te tsue, ‘Rof ovei tsurin moun visiir, an moun gima fafaagiir guei, an tan moun gima natiny fifasus ror tan guei, tana saa, ri onot ror ma bus tana tobeer.’ ");
INSERT INTO sps_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ana vainy te nai tsue tana tobeer, ‘Tarop of mamimam,’ ana ri te tsue tan tet, ‘Kookop mamimam,’ ");
INSERT INTO sps_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","tana saa, vainy te koma iring Varonyo te kat fifiiring Varonyo, to Tsonyo faarei rou nau rof, san vainy koma iring maromi nai kat fifiiring fafis fatsian varomi to tsumi faarei rom nau maas iring ma tek ravaa tsun en.” ");
INSERT INTO sps_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","An tsoiny puaan nom kainy naa to na ina fuan a mes, u vainy iring, ser nai mat fiisen me Jisas. ");
INSERT INTO sps_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Te ruak naa ri tana pan te koo rori, “A Tonaar,” na aya ri fagageits to Jisas tana pagafuan, ana ina fuan a mes a iring, a isen tan panaainy matou ana mesmes tan panaainy keeruk. ");
INSERT INTO sps_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ai Jisas tsue to, “Tamau, anofe ravainy kat iring te kat ari, tana saa, ri gim ror ma natiny a sa te kat ror ri na!” An tsoiny puaan kat to ser tats fabiririir iny a saatu, ri tatafas ton vau Tsunia fapoopoan narari. ");
INSERT INTO sps_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A vainy te tsutsutsun, vavaatok iny naa ton tsoiny mumua tana taa Jiu te tsue taring finy ari Ya ser tsue, “Ayei saup fatabiny tsun raror a mesapan, tanyi Yam a saup fatabiny to naa Tsivon to te man fi non Ya Tsunia na Krais ten Gov, Ayei na Tsoiny Fiisaup faman te pisainy e Gov!” ");
INSERT INTO sps_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","U tsoiny puaan kan te naa Tsunia ser taring iny Ya. Ri naa me Tsunia ser tanaf iny fainy Yan wain maajiin ma jiu Ya. ");
INSERT INTO sps_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ser tsue, “Te Aatouf faman fi rom Anyi tana taa Jiu, saup bus a Tsivom.” ");
INSERT INTO sps_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","U vegiau to aya te kirkir jias patsuun Ya, “E Jisas to na Aatouf tana taa Jiu.” ");
INSERT INTO sps_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ana isen tsuri na ina fuan a mes a iring te gageits fiisen me Jisas tana pagafuan tsue vaaserere iny Towa, “Anyi koraa na Krais, a Mes te pisainy e Gov, saup a Tsivom ana Nyi te saup kan mamimam!” ");
INSERT INTO sps_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sana mesmes tsue ets'ets iny ya sa tsue, “Kat fei nyi gima oraav vaarik e Gov? Ara kaa ror tan senviir fasaraa tsun. ");
INSERT INTO sps_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ara ina fuan te onot ror ma mat of a fo iring tsura, sana mes tovei gima kat ta isen ta iring.” ");
INSERT INTO sps_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kat to, ana mes to aya tsue to, “Jisas, Anyi fakats varonyo te naa mirom Manyi faarei rom Anyi na Aatouf tana Waam Manyi.” ");
INSERT INTO sps_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ai Jisas biny towa sa tsue, “Nyo tsue faman of marom anyi, roman anyi nai kaa fiisen Vamironyo Paradais.” ");
INSERT INTO sps_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Safunuu ana fuan a kilok osto tana nuaf, monaagits faavot uurup faavot nato onots ovei a fopis a aua, ");
INSERT INTO sps_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","te uurup farokot ya an raarav boo an tatabuan te gageits tana saape takakaar to fapoopoan sa kat a fuan a pan. ");
INSERT INTO sps_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kat to ai Jisas dau iny ton kuu tsian sa tsue, “Tamau, Nyo fakei rou a aavev nima Manyi!” Ai vou, Ya tauts to. ");
INSERT INTO sps_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te tagei a tsoiny mumua tan vainy puaan a fo mamatsiny ka to te ruak fi nei, ana ayei variri to Gov sa tsue, “U man ovei, a mes tovei a tavaron.” ");
INSERT INTO sps_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A vainy te ovot faavot me atou tagaa te gageits fi Jisas, ser tagei a foka to aya te ruak fi nei, ri tabin to fan ri butsbuts naa to na fo buer, tana saa, ri te reesik aveto tsuri. ");
INSERT INTO sps_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A vainy to te nat faarof iny ror e Jisas, fiisen kan rame moun to te vovou iny mi Ya tana gum fan iny Galili tsutsun fajesa naa to ser tagaa tana fo ka to aya. ");
INSERT INTO sps_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","A mes, a asangan ya Josep, ayei na mes tana ngats fan tana taa Jiu te koo rori Arimatia. Ayei na isen a mes a tavaron ana rof, te anaanos te naa fi minon a Waan e Gov. Ayei na isen tsurin tsoiny mumua te vaagum tana Kansol tana taa Jiu, sana ayei gima faarof men fakats te kat ari iny atsuiny e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ayei ruak fatoobing e Pailat sa rangat iny a puan e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ya famanat to, sai Josep fauf a puan e Jisas, sa paapau Yan raarav goseen kafof ana ya fasooiny Towa gagon tan puts te kats ya tan fats a sikia ta mes ma soon vaarik na aya. ");
INSERT INTO sps_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A foka to aya te ruak tana Faangim, u nainy kakoun tan Nainy Fafaatouf tana taa Jiu kat iny tanik osto. ");
INSERT INTO sps_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","U moun te vovou iny me Jisas to te poo fi me tana gum fan iny Galili, ri vovou iny e Josep te komainy ma nai tagaa tan puts tan fats ai te fasooiny finy rori na puan Ya. ");
INSERT INTO sps_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ana ri kat to ser tabin fan atou kakoiny a tapui na tauf tsuraf ana fungan jiaf tauf tsuraf ma fakaa puan e Jisas. Ai tan Nainy Fafaatouf tana taa Jiu ri favusuan to tana saa ri vovou iny ror Faun te kirkir iny e Moses. ");
INSERT INTO sps_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tana voinyvoiny tana patsuu na nainy tana Sande tan vaamuan nan nainy tana wik, an moun naa to tan puts, ri mei naa na tapui ana fungan te kakoun onots ari. ");
INSERT INTO sps_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ri naa ser sab a fats te kukuur osing matainy sobaa tan puts, ");
INSERT INTO sps_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","to ser sof naa gagon, ri gima sab a puan a Tsunaun e Jisas. ");
INSERT INTO sps_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tsutsun ri fapinpin rato, sana ina fuan a mes karainy ruak men vau goseen kafof kakanaf tsutsun er pana rari. ");
INSERT INTO sps_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kat to ana rin moun tsunguruu fi to petoo fiisen me na oraav, ana ina fuan a mes tsue to tsuri, “Kat fei, a saa te nai tsikoo of mimi na mes a toto na tana pan tan vainy mat? ");
INSERT INTO sps_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ayei gima kaa bus nei, te tsun fatabin en. Mi ma fakats tsue te kat Ya tsumi ana Ayei kaa en fiisen mamimi tana gum fan iny Galili. ");
INSERT INTO sps_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ayei te tsue na ka, ‘Vainy aveto te nai nom ror a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, ana ri te fagageits Ya tana pagafuan, ai tan fafofopis nan nainy, Ayei nai tsun fatabin non.’” ");
INSERT INTO sps_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","An moun fakats ton tsue Tsunia te kat Ya muan. ");
INSERT INTO sps_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nainy te poo ri tan puts ser tabin naa, ana ri tsue of rato na safunuu ana isen a matisian an mesapan kan tsuri tana fo mamatsiny ka. ");
INSERT INTO sps_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iton moun, ere Meri na muiny Magdala, ai Joana, ai Meri tsinan Jemis ana rin mes moun te kaa fiisen ramiri ser tsue of ir amaraav a foka to aya. ");
INSERT INTO sps_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sana rin amaraav gima faamainy ir moun tana saa, u vegiau tsuri te faarein vegiau babainy. ");
INSERT INTO sps_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sen Pita tsun, ya kookuar naa to tan puts, ya fakokop naa to sa matoong naa tan puts, ya tagei tsuiny ton raarav te paapau ari Ya, ana sikia pis ta mes ta ka. Ya kat to, sa tabin fan, fapinpin ovei iny a ka to aya te ruak. ");
INSERT INTO sps_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tan nainy patsukan to aya ana ina fuan a mes tana gum vainy te vovou iny e Jisas naa fi naa to tana fan te koo ri Emeas, a veevian nan ya na safunuu ana isen kilomita poo fi minon Jerusalem, ");
INSERT INTO sps_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ser favevegiau patsukan iny a foka te ruak. ");
INSERT INTO sps_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ari favevegiau raror ana ri faraarar er, ai Jisas fasiruu mito tsuri, sa taataan fiisen ramiri, ");
INSERT INTO sps_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ri tagei Ya sana parits ten Gov kat tap iny a mata rari, ser gim ma inainy fanatnat iny Ya. ");
INSERT INTO sps_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kat to, ai Jisas rangat ratuari, “A saa te faraarar tsuk iny romi na, ana mi taan em?” Ana ri kat to, ser tsutsun faamo er, fiisen me na mataaf mata rari. ");
INSERT INTO sps_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ana isen tsuri asangan ya Kliopas, rangats Towa, “Anyi tsun a isen a mes iny Jerusalem te gim rom ma nat tana foka te ruak na tana tee nainy te naa en?” ");
INSERT INTO sps_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ya rangat to, “A saf a ka ei na?” Ana ri biny Towa, “A ka te ruak ten Jisas a tsoiny Nasaret. Ayei na kuigin, ana parits a siireits tan vegiau ai tan kat a ka matan e Gov ai mata rari na vainy faavot. ");
INSERT INTO sps_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Fuainy tsunaun tan tsoiny faakor an tsunaun tsumam sigainy Ya ser pokei Ya ma nai mat Ya, ri kat to, ser fagageits Ya tana pagafuan. ");
INSERT INTO sps_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sana mam pon fi nei, Ayei na mes to ma pats Ya na tou tapuruur tsumam a taa Isrel nimar Roum! Sana ri fagageits Ya tana pagafuan, ai tovei bus fafofopis nan nainy te ruak a ka to. ");
INSERT INTO sps_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A tee moun tana gum tsumam te kat mamam tsumam ngian em. Ari te toomat naa tan puts te fasooiny ari Ya, ");
INSERT INTO sps_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ser gima sab a puan Ya. Ri naa me ser tsue of mamam ri tageir morena te tsue na ka, Ayei te toto en. ");
INSERT INTO sps_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ana mesapan tana gum tsumam naa to tan puts, ser sab tsuiny a ka te tsue fin moun, ri gima tagei Ya.” ");
INSERT INTO sps_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ai Jisas tsue to tsuri, “Amin parainy piou ge? Ana mi kan fanagin faaman tsun em koma mami, to sam gima faamainy a foka te tsuen kuigin! ");
INSERT INTO sps_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Fiisia, u kuigin te tsue na Krais a Tsoiny Fiisaup ma sarei Ya na kamits tana fo mamatsiny ka to, ai vou Ya te sof naa tana pan tan siinaiv Tsunia, taava?” ");
INSERT INTO sps_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ai Jisas fa'arasainy Towa tsuri, tana ka te tsue tsuk iny ari Ya koman Vegiau Ten Gov, te tanik me tan Buk ten Moses sa naa me tan kirkir tan fuainy kuigin. ");
INSERT INTO sps_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ana ri nom fasiruu naa to panan a fan to te naa naa ri tsunia, ai Jisas kat faarei to te komainy ma fis naa, ");
INSERT INTO sps_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","sana ri te tsue tap iny Ya, ser tsue, “Anyi ma kaa fiisen tsom mamimam, tana saa u nainy te naa en ana ayei kan uurup osto.” kat to Ya naa fiisen ramituari sa nai kaa fiisen ramiri. ");
INSERT INTO sps_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ana Ayei gum fiisen ramituari tana taran iny ainy, Ya nom ton koinykoiny sa tsue faarof naa ten Gov, Ya ivoo ton koinykoiny Ya faan iny towa tsuri. ");
INSERT INTO sps_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kat to, an fakats tsuri arasan to, ri inainy Towa, sana Ayei karainy kajiaa en fapoopoan narari. ");
INSERT INTO sps_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ana ri favevegiau to, “Fiisia, te gima faarein guaf fisikii koma rara to te vegiau fi Ya tsura sanaan to sa fa'arasainy vegiau tan Vegiau Ten Gov to tsura, taava?” ");
INSERT INTO sps_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ana ri kat to, ser taan veesau fatabin ra naa to i Jerusalem, ri sab to na safunuu ana isen a matisian te ovot ror na aya fiisen rame na mesapan, to ser tsue of rari na ina fuan, ");
INSERT INTO sps_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ser tsue, “A Tsunaun te tsun faman fatabin ovei en! Ayei te ruak ten Saimon Pita!” ");
INSERT INTO sps_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ana ri ina fuan fa'arasainy to na foka te ruak tsuri sanaan, ai to te inainy ari na Tsunaun tan nainy te ivoo Yan koinykoiny. ");
INSERT INTO sps_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Arin matisian vegiau farokot kaner raror, sen tsun Jisas tsutsun to fapoopoan narari, Ya tsue to tsuri, “Aaverof kaa fiisen mamiromi.” ");
INSERT INTO sps_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ana ri karian to ser oraav er, ri pon fi nei, ri tagei a amatsuan. ");
INSERT INTO sps_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ya tsue to tsuri, “Kat fei tsumi koma patang rom ei? Kat fei sana fo vaa'ets tovei paas a nai mami ei? ");
INSERT INTO sps_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tagaa yam, nima Vanyo ai mou Vanyo ana mi te tagaa, Anyo vaa ei aa. Saras Vanyo yam, ma tagaa mi, tana saa, a amatsuan a sikia tu venoo, an tu tsuan, to te tagaa fi romi Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nainy te tsue fakap iny Ya na ka to, Ya faatok ratuari na niman ana moun Ya. ");
INSERT INTO sps_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ri mamagat ovei sana ri tabuiny ma faaman kan, tana saa, ri onanun ror, Ya rangat ratuari, “Mi te kaa mirom ta ka iny ainy tovei?” ");
INSERT INTO sps_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ana ri fainy Towa na painy jian a tsufas. ");
INSERT INTO sps_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ya nom towa sa ainy ya fapoopoan mata rari. ");
INSERT INTO sps_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kat to, Ya tsue to tsuri, “A foka to aya na foka to te tsue of im tan nainy kaa farokot fiisen mami Nyo mi, a fo mamatsiny ka nai ruak iny man nats non, ito te kirkir tsuk of Vanyo ri tan Faun te kirkir iny e Moses, an kuigin ai tan Kooma iny Vadou.” ");
INSERT INTO sps_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ana Ya kat ratuari ser nom fakats patsu rari ma natiny arin tsue tan Vegiau Ten Gov, ");
INSERT INTO sps_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ana Ayei tsue to tsuri, “A ka to aya te kirkir en tan Vegiau Ten Gov, ‘E Krais a Tsoiny Fiisaup ma saraa kamits tsom ana Ayei te tsun fatabin tana mat, tan fafofopis nan nainy, ");
INSERT INTO sps_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ai tana asangan Ya vegiau nana tou reesik a fo aveto ana tou takopis osing a fo aveto te tap naa ten Gov, ana Ayei te anofe ravainy a fo aveto, ma favaanan tana vainy faavot, sai ma tanik tsom en Jerusalem, ai te naa fi naa tana fo mamatsiny pan faavot tana monaagits.’ ");
INSERT INTO sps_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ana mi to nai pokei rom a fo mamatsiny ka tovei te tagei ami, ai te nongoiny ami. ");
INSERT INTO sps_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nongon yam, Nyo nai faan iny mirou Aaven Taabos tan tsuen man ten Tamanyo, sana mi nai kaa tsom rom tana ngats fan tsian iny Jerusalem onot non te kookop maromi na parits iny jias.” ");
INSERT INTO sps_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ana Ya mei ratuari tana ngats fan iny Jerusalem, ser naa fi naa tana ngats fan iny Betani, na aya, Ayei fapaas a niman jias patsuu rari Ya faparits ratuari, ");
INSERT INTO sps_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ayei faparits ratuari, ai Gov nom fapaas finy naa Towa Gormirmir. ");
INSERT INTO sps_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kat to ana ri fafaatouf Towa ri tabin fi naa to Jerusalem fiisen me na mamagat tsian. ");
INSERT INTO sps_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ai tan mamatsiny nainy ri natiny naa ror tana saape a tou variri e Gov. ");
INSERT INTO sps_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tabuiny tapogaar non a monaagits to, a isen te koo rin Vegiau te kaa busen, Ayei kaa fiisen mito Gov, ana Ayei kan, a Gov. ");
INSERT INTO sps_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","A isen te koo rin Vegiau te kaa kaa fiisen me Gov tanik me tan tatanik. ");
INSERT INTO sps_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gov ana isen te koo rin Vegiau te fapogaar a fo mamatsiny ka, ana sikia ta isen ta ka te fapogaar e Gov tan tatanik, ma pet iny a isen to te koo rin Vegiau. ");
INSERT INTO sps_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A isen te koo rin Vegiau te fakifon iny non a toto faman, ana toto to ayei na arasan tan vainy ma nat faarof iny ari na man. ");
INSERT INTO sps_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A arasan te biainy a uurup, ana uurup gim to ma onot ma famote oiny ya. ");
INSERT INTO sps_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gov jiats naa na tsoiny favaanan Tsuan, a mes te koo ri Jon. ");
INSERT INTO sps_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ayei te naa me ma tsue of ir ya na vainy, tan vegiau nan a arasan. Tan kat to aya, ari onot ror ma nongoiny vegiau tsunia er faaman to. ");
INSERT INTO sps_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ayei patsukanen na gima arasan, ayei te naa me ma pokei iny ya na arasan. ");
INSERT INTO sps_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ana arasan to ayei a arasan famanman ovei, ana arasan to te naa of minon a monaagits to, ma biainy ya na arasan tana vainy ma inainy fanatnat iny ari, Gov. ");
INSERT INTO sps_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ana isen te koo rin Vegiau te kaa en tana monaagits to. Ai Gov fapogaar to na monaagits to, i Tsunia tsun, sana vainy tana monaagits to, gim to ma inainy fanatnat iny Ya. ");
INSERT INTO sps_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ayei te naa me tana gum fan Tsuan fatoobing, sana vainy Tsunia fatoobing gima faarof iny Ya. ");
INSERT INTO sps_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sana mesapan tsuri faarof iny Ya, ri faaman to Tsunia, to sana Ayei faan rarin gumgum ma faarei arin guei ten Gov. ");
INSERT INTO sps_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ana ri gima agiir ma faarei mi rin guei ten Gov tan kat tan puputaa tovei, ge ari gima agiir vovou iny koman tan puainy mes, ge mangiir iny fakats tan tamar min tsinar, a sikia, ri agiir me ten Gov. ");
INSERT INTO sps_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A isen te koo rin Vegiau te ruak iny mes me, via minon a man ana koma ree'un, sa kaa en fapoopoan narara. Mam tagein siinaiv Tsunia, siinaiv to aya te nom mi Ya, tana saa, Ayei na isen a Guei Tsoiny ten Gov fatoobing. ");
INSERT INTO sps_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon a tsoiny fapeenan te pokei faruak Ya. Ya kuu fatsian to sa tsue, “A isen a mes to ayei te tsue tsuk iny anyo, to te tsue fi nyo, ‘Ayei to te naa minon vou vanyo, Ayei karap fafis varonyo, tana saa, Ayei te kaa busen muan tabuiny agiir ronyo.’” ");
INSERT INTO sps_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ayei te faparits rara faavot, Ya faan fatatabin ratuara na fo parits a sikia ta fafakap nan te tapogaar ising me tana koma ree'un Tsunia to aya. ");
INSERT INTO sps_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Fo Faun ten Gov te poo me ten Moses, sana man ana koma ree'un to aya te poo me ten Jisas Krais. ");
INSERT INTO sps_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","A sikia ta isen ta mes ma tagei e Gov. A Isen tsun, to te faarei non ne Gov, ana Ayei kaa non panaan e Taman, ana Ya pokei faruak Towa. ");
INSERT INTO sps_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Fuainy tsoiny mumua tana taa Jiu, te kaakaa tana ngats fan tsian iny Jerusalem, to te jiats ra naa na tee tsoiny faakor ana tee tsoiny faakor tana vun ten Livai ten Jon ma rangats ari ya, “Anyi na saf a mes ei na?” ");
INSERT INTO sps_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon gima baainy ma biny rari, ana ya vegiau fa'arasan of ratuari. U vegiau to te pokei ya tsuri, “Anyo na gima Krais a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy.” ");
INSERT INTO sps_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Ana nyi na saf a mes ei na?” rangat fi ri. “Anyi koraa ya na mes te faarei rom e Ilaija na kuigin iny muan to te tsun fatabin em?” “A sikia ma nyo,” biny fi rari Jon. “Anyi koraa ya na mes te faarei rom e Moses a kuigin to te anaanos romam?” rangat fi ri. “A sikia,” biny fi rari ya. ");
INSERT INTO sps_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ana ri rangats towa, “Tsue of mamimam, anyi sei? Amam komainy rom tu tsue fatabin mam te tsue of rari to te jiat mamimam nei tsumanyi, e sei pas te koo rom anyi na tsivom ee?” ");
INSERT INTO sps_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon biny ratuari, sa tsue na ka, “Anyo na isen te vegiau fabaasuan mirou koman a pan a uur, ‘Vatsvats of a Tsunaun kat tsuam ma faarei ya na sanaan iny naa me Tsunia!’” (E Aisaia na kuigin te pokein vegiau to muan.) ");
INSERT INTO sps_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Taa Farasi, (a gum tana taa Jiu te vovou faarof ror Faun te kirkir e Moses fiisen men kat tan tsuvurari), ri jiats ramen vainy gogovet vegiau, ser rangats e Jon, “Te gim fi rom anyi ma faarei na Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy, ge Ilaija na kuigin, ge na mes a kuigin to te anaanos romam, kat fei sanyi kat rom a binun iny fapeenan ei?” ");
INSERT INTO sps_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon biny ratuari, “Anyo fapeenan iny rou a aurom, sana isen te kaa en fapoopoan a mami ana mi tabuiny ma natiny Ya. ");
INSERT INTO sps_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ayei te naa minon vou vanyo, te karap fafis varonyo, nyo gima onot faarof ma puruur a patom nan suu Tsunia.” ");
INSERT INTO sps_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Fo mamatsiny ka to te ruak tana ngats fan iny Betani, pan te roruak minon a nuaf tana aurom iny Jodan tana pan te fapeenainy e Jon a vainy. ");
INSERT INTO sps_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tan mes nainy Jon tagei e Jisas te tataan me tsunia, sa tsue na ka, “A Tsunei Siip ten Gov tovei te nom ravainy non aveto tana vainy tana monaagits to! ");
INSERT INTO sps_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ayei koraa na mes to te pokei faruak anyo to tsonyo tsue, ‘A mes te naa minon vou vanyo to, Ayei karap fafis varonyo tana saa Ayei te kaa busen muan tabuiny agiir ronyo.’ ");
INSERT INTO sps_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Anyo gima natiny Ya, sana nyo naa me ma fapeenan iny anyo na aurom ma natiny a taa Isrel a Mes tovei, to te naa minon Ya!” ");
INSERT INTO sps_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","U vegiau te pokei iny e Jon sa faan iny ya to: “Anyo tagein Aaven Taabos te of me Gormirmir faarei na kurume sa kaa Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nyo kan gima natiny Ya, san e Gov te jiat vaminyo ma fapeenan iny a aurom, te tsue fi Gov tsonyo muan sa tsue na ka, ‘Anyi tagei nats rom Aaven Taabos of minon a kaa to Tsunia, Ayei koraa na mes to aya te fapeenan iny non Aaven Taabos.’ ");
INSERT INTO sps_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Anyo tagei to na ka to te ruak, ana nyo tsue of maromi, Ayei na Guei Tsoiny ten Gov,” tsue fi Jon. ");
INSERT INTO sps_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tan mes nainy Jon a Tsoiny Fapeenan kaa pis to na aya fiisen rame na ina fuan a matisian tsunia, ");
INSERT INTO sps_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","te tagei ya Jisas te tataan me, ya tsue to na ka, “To Ayei na Tsunei Siip ten Gov!” ");
INSERT INTO sps_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ri na ina fuan a matisian nongoiny towa te tsue ya na ka to, ri naa fi erato ten Jisas. ");
INSERT INTO sps_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas takopis, Ya tagei ratuari te vovou iny Ya, Ya rangat to, “A saa te komainy romi na?” Ri biny Towa, “Fei te kaa rom Anyi ei, Rabai?” (Man nan vegiau to, Tsoiny Fifaatsuts.) ");
INSERT INTO sps_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Taami yam am tagaa to,” te biny fi rari Ya. (A fats a kilok tana touraf.) Ana ri naa fiisen mi Towa ri tagei to na pan te kaakaa non Ya, ri kaa fiisen mi Ya, sa onots a ananerof. ");
INSERT INTO sps_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","E Anduru, a famuinyasiny ten Saimon Pita, ayei na isen tsuri na ina fuan te nongon te tsue fi Jon ana ya vovou iny to Jisas. ");
INSERT INTO sps_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Voun a tou kaakaa tsunia fiisen me Jisas, sen tsun ai Anduru tainytainy to famuinyasiny tsuan e Saimon ana ya tsue to na ka, “Amam te sab bus a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy, mes to aya amam a taa Jiu koo rom Ya na Mesaia.” (A taa Grik te koo ror Ya, na Krais.) ");
INSERT INTO sps_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ana Ya mei naa to Saimon unya ten Jisas. Jisas tagei towa ana Ya tsue to, “Anyi Saimon, a guei tsoiny ten Jon. Asanga manyi nai koo rori Sifas.” (Faarei tsuiny non e Pita, man nan vegiau to, a fats.) ");
INSERT INTO sps_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tan mes nainy Jisas pon to ma naa fi tana gum fan iny Galili. Ya sab to Filip ana Ya tsue to tsunia, “Taame vovou you!” ");
INSERT INTO sps_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filip a mes tana ngats fan iny Betsaida, a ngats fan to ayei te natiny kaakaa ror e Anduru me Pita.) ");
INSERT INTO sps_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip sab e Nataniel ana ya tsue of towa, “Amam te sab bus a isen to te kirkir iny e Moses muan tan Buk tana Faun, ai tsuri kan a fo kuigin te kirkir iny Ya. Ayei e Jisas a mes tana ngats fan iny Nasaret ana Ayei a guei tsoiny ten Josep.” ");
INSERT INTO sps_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Te kaa kan minon ta ka ta mamarof te tapogaar ising minon tana ngats fan babainy tsun iny Nasaret?” rangat fi Nataniel. Filip biny towa, “Taame, nyi te tagaa.” ");
INSERT INTO sps_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Te tagei e Jisas e Nataniel te naa me Tsunia, ana Ya tsue to tsunia, “A tsoiny Isrel fatoobing tovei, a sikia ta painy gam tapokaa minon tsunia!” ");
INSERT INTO sps_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel rangats Towa, “Kat fei sanyi nat Vanyo ei?” Jisas biny towa, “Nyo tagei manyi te kaakaa fain nus tabuiny fikoo marom anyi Filip.” ");
INSERT INTO sps_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Tsoiny Fifaatsuts,” biny finy Ya Nataniel, “Anyi na Guei Tsoiny ten Gov faman! Ana Nyi kan a Aatouf tana taa Isrel!” ");
INSERT INTO sps_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisas tsue to na ka, “Fiisia nyi faaman tana saa Anyo tsue of manyi te kaakaa fi nyi fain nus? Nyi nai tagei nats rom a fo mamatsiny kan karap fis nats non a foka to!” ");
INSERT INTO sps_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ana Ya tsue to tsuri, “Nyo tsue faman of maromi, ami nai tagei nats rom a Gormirmir tapue non an fuainy morena ten Gov paas fi naa ror jias ai ri te of kan me nei petoo Tsonyo, Tsonyo na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me.” ");
INSERT INTO sps_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Voun fuan nainy te kaa me na fanging tana ngats fan iny Kena tana gum fan iny Galili. Tsinan Jisas kaa kanen na aya, ");
INSERT INTO sps_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ai Jisas an matisian Tsunia nom kainy ton vebus tana fanging ser naa. ");
INSERT INTO sps_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te kap seerep bus nan wain tsinan Jisas tsue of Towa, “U wain te kap osing bus ir a fokinai.” ");
INSERT INTO sps_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Anyi ma tsue of vaare you ta ka ma kat Anyo, tsinau,” biny fi ya Jisas. “U nainy Tsonyo tabuiny naa minon.” ");
INSERT INTO sps_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tsinan Jisas tsue of ton tsoiny binun, “Kat yam a ka te tsue of maromi Ya.” ");
INSERT INTO sps_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Te kaa me na aunom a kepaa fats nan a aurom te kaa siruu, ka iny gagarus puan ma taabos mi ri matan e Gov, isisen narari onots non a tangau a galan gen fopis safunuu na galan. ");
INSERT INTO sps_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas tsue to tan tsoiny binun, “Itsuf favei yam kepaa fats to tana aurom.” Ri itsuf ser favei taptap ovei rari. ");
INSERT INTO sps_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ana Ya tsue of ratuari, “Jio, kasuiny sanyi yam ta aurom am govets naa towa tana mes te tagaa ot iny non guainy tana fanging.” Ri govets naa towa tsunia, ");
INSERT INTO sps_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ana ya jiu tanaf to na aurom sa faarein wain. Ya gim to ma nat fei te poo fi men wain to aya ei. (Sana tsoiny binun to te kasuiny a aurom nat iny a ka to), tan kat to aya, ya fikoo to na tsoiny fanging, ");
INSERT INTO sps_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ya tsue of towa, “Tan kat tana mes a vainy te faan famumei ror wain saavits ovei, ai voun ya te jiu fakap a fokinai, ri te faan iny wain babainy. Sana nyi fakei patsukainy wain saavits fiisok ovei, onot non tovei!” ");
INSERT INTO sps_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisas vaamuan iny kat a ka iny faatok to na karap, tana ngats fan iny Kena tana gum fan iny Galili, ana Ya pokei ton siinaiv reits Tsuan, an matisian Tsunia faamainy Towa. ");
INSERT INTO sps_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Voun a ka to, Jisas me tsinan Ya an fuainy famuinyasiny Tsunia ana rin matisian naa fi to tana ngats fan iny Kapeniam, ana ri kaa erato na aya tan fo mar nainy. ");
INSERT INTO sps_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Te sisiruu bus men nainy Guainy tana taa Jiu iny Fakats Fatabin nainy te faakouts rari e Gov ser naus osing me na gum fan iny Ijip, ai Jisas naa fi enato tana ngats fan tsian iny Jerusalem. ");
INSERT INTO sps_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ya sof naa to gagon tana aunon nana saape, Ya sab rato na vainy te fafiifoiny iny a fo marei sensen, siip, an marei u baanus, kainy kat faakor tana saape, ana ri kan vainy papangis moni te gumgum panaan fo taran tsuar. ");
INSERT INTO sps_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ya kat to na wip tana fo aafon, ana Ya jiaats vavagen ra ton fo marei sensen faavot jiarasan iton fuainy siip an bulumakau tana saape, Ya kof ton taran tan vainy papangis moni ana Ya piat vavis iny ton fo takep moni tsuri, ");
INSERT INTO sps_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ana Ya tsue of rato na vainy te fafiifoiny iny marei u baanus, “Fatafuts ir yam nei! Kat vaare yam a numaa ten Tamanyo ma faarei ya na numaa iny tuan!” ");
INSERT INTO sps_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Matisian Tsunia fakats fatabiny Vegiau Ten Gov te kirkir en muan te tsue na ka, “Fo mamatsiny parits, fakats ana toto tsonyo tana numaa Tsumanyi, Gov, faarei non guaf kurun to koma vanyo.” ");
INSERT INTO sps_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Rin tsoiny mumua tana taa Jiu fatanai Towa ser rangats Ya, “Saf ta ka iny faatok ei na te faatok iny rom Anyi tsumam, tan gumgum Tsumanyi ma kat a foka to te poo fi me ten Gov na?” ");
INSERT INTO sps_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisas biny ratuari, “Rurei ravainy yam a saape ten Gov tovei, Nyo te nai fatsuiny fatabiny ya tan fopis nainy.” ");
INSERT INTO sps_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ana rin tsoiny mumua tana taa Jiu rangats Towa, “Fiisia, Anyi onot rom a fatsuiny fatabiny a saape tan fopis nainy? Te onots ovein fats safunuu ana aunom a ingainy tan fatsuiny a saape tovei!” ");
INSERT INTO sps_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sana saape to te tsue tsuk iny e Jisas, ito na puan Ya. ");
INSERT INTO sps_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ai vou na tou tsun fatabin Tsunia tana mat, matisian Tsunia fakats fatabiny ton vegiau te kat Ya, ana ri faamainy to na painy vegiau tan Vegiau Ten Gov, an vegiau te tsue iny e Jisas. ");
INSERT INTO sps_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tan nainy te kaa Jisas tana ngats fan tsian iny Jerusalem tan Guainy tan Nainy Fakats Fatabin ana fokinai faamainy Towa, Tsunia na Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy to te tagei finy ari Ya te kat a foka iny faatok reits te kat Ya. ");
INSERT INTO sps_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sen Jisas gima faason tsuri, tana saa Ayei nat faarof bus iny kat tana vainy faavot. ");
INSERT INTO sps_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jisas nat faamuainy bus ir vainy, an vegiau tan mes vainy te gim non ma faakouts Ya, tana saa Ayei nat faamuan bus iny a ka to koma rari. ");
INSERT INTO sps_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Te kaa me na mes te koo ri Nikodimas a tsoiny mumua tana taa Jiu, ana ayei kan a isen tsuri na taa Farasi. ");
INSERT INTO sps_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ayei te naa ten Jisas tana isen a voiny sa tsue Tsunia, “Tsoiny Fifaatsuts, amam nat rom, Anyi na isen a tsoiny fifaatsuts te jiats me Gov. Sikia ta isen ta mes te onot non ma kat a binun a reits iny faatok te katkat Anyi, onot non te kaa fiisen minon Ya Gov, ana Ya te faakouts Ya tan kat a foka to.” ");
INSERT INTO sps_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas biny towa, “Nyo tsue faman of marom anyi, sikia ta isen ta mes te onot non ma sof a Waan e Gov, onot non te agiir fatabin pis non ya.” ");
INSERT INTO sps_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Kat fi non ta mes tsian ai te nai agiir fatabin pis ei?” rangat fi Nikodimas, “Ge ayei te onot non ma sof pem iny agiir ten tsinan ya te agiir tan fafuan nan nainy?” ");
INSERT INTO sps_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas biny towa, “Nyo tsue faman of marom anyi, a sikia ta isen ta mes te onot non ma sof a Waan e Gov, onot non te agiir fiisen minon ya na aurom an Aaven Taabos. ");
INSERT INTO sps_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Puainy mes te faagiir non puainy mes, san Aaven Taabos te faagiir non a toto na foun tan aaven. ");
INSERT INTO sps_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Koma karian vaare Tsonyo te tsue of manyi, ami ma agiir pis tan Aaven Taabos. ");
INSERT INTO sps_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A ainysat te taf minon tana pan te komainy taf fi naa non ya, ana nyi te nongoiny vuu nan ya, sana nyi gim rom ma natiny a pan te poo minon ya, ge te naa fi naa non ya, jesan te kat fi ror a fokinai te agiir miror Aaven Taabos” ");
INSERT INTO sps_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Fei te ruak fi non a ka to aya ei?” rangat fi Nikodimas. ");
INSERT INTO sps_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisas biny towa sa tsue na ka, “Anyi na tsoiny fifaatsuts a reits tana taa Isrel, ana nyi gim rom ma natiny a foka to? ");
INSERT INTO sps_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nyo tsue faman of marom anyi, amam vegiau iny rom a ka te natiny romam, ana mam vegiau iny rom a ka te tagei romam, sana sikia ta isen tsumi ma faarof iny a foka te vegiau romam. ");
INSERT INTO sps_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ami te vaa'ets Vanyo to te tsue of im yam tana foka tana monaagits to, ana mi nai vaa'ets kan Vatuanyo, te tsue of fi marom yam a foka iny Gormirmir. ");
INSERT INTO sps_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A sikia ta isen ta mes ma naa fi Gormirmir ana ya te of fatabin me a tsue of matuami, sana Guei Tsoiny tsun te Bobot e Gov sa ruak iny Mes me te of fi me Gormirmir, to sa tsue non tsumi. ");
INSERT INTO sps_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“To te govets fapaas finy e Moses a koraa te kat ari tan ayan muan, ya fagageits towa tan nau tana pan a uur, jesan kan te kat fi nats non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, govet fapaas rori a nai gageits to, ");
INSERT INTO sps_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tan kat to aya, ere sei tsun te faaman ror Tsunia ee, nai kaa miror a toto na suu, ");
INSERT INTO sps_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","tana saa Gov mangiir fiisok a vainy tana monaagits to, ana Ya faan iny to na isen tsun a Guei Tsoiny Tsuan, tan kat to aya ere sei tsun te faaman ror Tsunia ee, gim ror ma nai nom a mat a suu, sana ri kaa bus me na toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gov gima jiats me na Guei Tsoiny Tsuan tana vainy tana monaagits to, ma faarei Ya na tsoiny vaatsuk ma pokei rari Ya, er nom to na fasaraa tan mat a suu, a sikia, sai te faarei non a Tsoiny Fiisaup tana vainy tana monaagits to. ");
INSERT INTO sps_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“E sei tsun te faamainy non a Guei Tsoiny ten Gov ee, sikia non ma nom a fasaraa tan mat a suu, ai sei tsun te gim non ma faaman ee, fasaraa tsunia te tapokaa busen, ana fasaraa tsunia to nai kaa enanon tana mat a suu, tana saa ayei gima faamainy a isen tsun a Guei Tsoiny ten Gov. ");
INSERT INTO sps_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A fasaraa ten Gov te kat fi non nei, a arasan ana man nan e Gov te of osing me naa Gormirmir, sa naa ename tana vainy tana monaagits to, sana vainy mangiir fiisok a uurup ri biak ravainy to na arasan, tana saa ari te mauts fiisok kat tana ngi'arapaar. ");
INSERT INTO sps_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sei te kat non a fo kat ngi'arapaar ee te tsugei non a arasan ana ya te gima naa me tana arasan, tana saa ayei te tsugainy non fo kat ngi'arapaar tsuan ma tapokaa fa'arasan. ");
INSERT INTO sps_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","San e sei te kat non kat man ee naa minon tana arasan, tan kat to aya a arasan te nai tapokaa non ana fo binun te katkat non ya, nai faatok iny non a ka ayei te manaats non e Gov.” ");
INSERT INTO sps_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Voun a ka to, Jisas an matisian Tsunia naa fi erato tana gum fan iny Judia. Ya kaa fiisen ramituari na aya tan fo mar nainy ana Ya fapeenainy kainy to na mes a vainy. ");
INSERT INTO sps_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon kan fapeenainy ir a vainy tana ngats fan iny Ainon, sikia kan ma veevian osing a ngats fan iny Salim, tana saa a aurom a kinai te kaa na aya. Vainy te naa tsunia ana ya fapeenainy ratuari. ");
INSERT INTO sps_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Jon tabuiny ma naa tana numaa iny kotskots.) ");
INSERT INTO sps_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mesapan nar matisian ten Jon tanik iny fa'ararat mito na isen a tsoiny Jiu, tan kat iny fataabos a mes tan fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ana ri naa fi to ten Jon ri tsue to tsunia, “Tsoiny Fifaatsuts, anyi natiny rom a mes te kaakaa fiisen mi nyi tan mes panainy aurom iny Jodan, ito na mes te tsue tsuk anyi? Eye, Ayei fapeenainy rarora vainy, ana fokinai suur fi naa ror Tsunia!” ");
INSERT INTO sps_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon biny ratuari, sa tsue na ka, “Gov kaa non Gormirmir te faan bus iny a binun to tan isiseiny mes. ");
INSERT INTO sps_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ami to ari te tagaa fanatnat em to sanyo tsue fi rou nei, ‘Anyo na gim ma Guei Tsoiny te pisainy e Gov ma Tsoiny Fiisaup anyo tana vainy a sikia, san e Gov te jiats famumuei vaminyo muan ma mumua iny minyo Ya.’ ");
INSERT INTO sps_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A tsoiny fanging ayei na mes te fanging naa non tana muiny fanging to, ana vaatau tana tsoiny fanging to te anaanos non ya te vanongon ana ya te paparaa te nongoiny fi non ya na ngue na tsoiny fanging to. U paparaa tsian te kaa mi ronyo to tana saa a vainy te nongon, ri vovou iny Towa. ");
INSERT INTO sps_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ayei ma kaa men asangan karap ana nyo ma kaa vaare me tu asangan.” ");
INSERT INTO sps_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ai Tsunia to te poo fi me Gormirmir te karap fafis pis iny non a fokinai faavot. Ai tsunia to te poo me tan puputaa te fasito iny non a foka tan puputaa ana ayei te vegiau tsuk iny a foka tan puputaa. Ai Tsunia to te poo fi me Gormirmir te karap fafis iny non a fo mamatsiny ka. ");
INSERT INTO sps_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ayei te vegiau tsuk iny non a ka te tagei Ya ana ka te nongoiny Ya Gormirmir, sana sikia ta mes ma faarof iny vegiau Tsunia, a tee vainy tsun to ari te faarof iny Ya ri faamainy ton vegiau Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","E sei to aya te faarof iny Ya ana ya faamainy ton vegiau Tsunia ee, te pokei minon e Gov, Ayei na man. ");
INSERT INTO sps_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ai Tsunia to te jiats me Gov, te vegiau tsuk iny non vegiau ten Gov, tana saa Gov te fainy faavots Yan Aaven Taabos, ana sikia ma panpan. ");
INSERT INTO sps_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","E Tamarara Gov mangiir fiisok a Guei Tsoiny Tsunia ana Ya fainy Towa na fo mamatsiny parits reits niman Ya. ");
INSERT INTO sps_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","E sei te faamainy non a Guei Tsoiny ee te kaa bus me na toto na suu, ai sei te tsugei non a Guei Tsoiny ee te gim non ma nom on a toto na suu, sana koma seeve ten Gov nai kaa enanon tsunia a sikia ta fafakap nan. ");
INSERT INTO sps_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Taa Farasi nongon te nonom finy e Jisas matisian kinai ana Ya fapeenan kanen, ana Ya kat sabuts fafisfis pis iny e Jon. ");
INSERT INTO sps_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(U matisian Tsunia tsun to ari te fapeenainy ir a vainy, ai Jisas, a sikia, Ayei gima peenainy ta isen ta mes.) ");
INSERT INTO sps_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Te nongoiny fakap bus e Jisas vegiau to, Ya naus osing to na gum fan iny Judia ana Ya tabin fatabin enato tana gum fan iny Galili, ");
INSERT INTO sps_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","unya sanaan Ya naa fi naa to tana gum fan iny Samaria. ");
INSERT INTO sps_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ya naa mito tana gum fan iny Samaria tana ngats fan te koo rori Saika, a sikia ma veevian osing peto te faan iny e Jekop tana guei tsoiny tsunia Josep. ");
INSERT INTO sps_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A gaguur aurom ten Jekop te kaakaa na aya, ai Jisas nag enato sanaan, Ya gum to panan a gaguur aurom. Te faarei non a gagoiny nuaf. ");
INSERT INTO sps_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","A muiny Samaria naa mito a tou itsuf aurom, ai Jisas rangat towa, “Faan You ta aurom ma jiu Nyo.” ");
INSERT INTO sps_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Matisian Tsunia naa er tana ngats fan a tou foiny ta kainy ainy ana Ayei kaa Tsivon en.) ");
INSERT INTO sps_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ana muiny Samaria biny Towa, “Anyi na tsoiny Jiu ana nyo na muiny Samaria. Saa te rangat of rom Anyi ma fajiu im na?” (Taa Jiu gim ror ma sovaar mamam a taa Samaria.) ");
INSERT INTO sps_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisas biny towa sa tsue na ka, “Te nat fi rom anyi nei tana ka te faan iny non e Gov, ai to kan, ten sei te rangat marom anyi ma fajiu ya na aurom ee, nyi te rangats Ya, Ayei faan marom anyi na aurom te kifon iny non na toto.” ");
INSERT INTO sps_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Mes tsian,” te tsue fi na moun to, “Anyi na sikia ta ka iny kasun aurom ana aurom to na gaguur fiisok. Fei te nom rom Anyi na aurom te kifon iny non a toto ei? ");
INSERT INTO sps_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Anyi te karap fafis iny rom e tsuvumamam e Jekop? Fiisia, ito na mes te faan mamam a gaguur aurom to, sa mam jiu tsun rom tsunia, ana ri kan fuainy guei tsoiny tsunia an fuainy marein sensen tsunia.” ");
INSERT INTO sps_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisas biny towa, sa tsue na ka, “E sei te jiu non tana aurom to ee nai iinyu pis enanon. ");
INSERT INTO sps_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Sen sei te jiu non tana aurom te faan iny Ronyo ee, te gim non ma iinyu on pis nats. A aurom nai faan iny nats Ronyo nai faarei nats non a kookue koman ya to te kifon iny non a toto, ana ya te fainy ya na toto na suu.” ");
INSERT INTO sps_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Mes Tsian,” te tsue fi na moun to, “faan you a aurom to aya! Ma nai iinyu on pis vaare nyo, ge ma naa on pis vaare minyo nei a tou itsuf.” ");
INSERT INTO sps_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Kuar tsue of me natsiom,” te tsue fi Jisas tsunia, “am tabin fatabin mito.” ");
INSERT INTO sps_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Anyo na sikia ta tsoiny,” te tsue fi na moun to. Jisas biny towa sa tsue na ka, “Te toobing non te tsue fi rom anyi, anyi na sikia ta tsoiny. ");
INSERT INTO sps_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nyi fanging bus a ina ngim a tsoiny, ana mes to te kaa mirom anyi a sikia ma tsoiny tsumanyi. Anyi tsue faman of Vanyo.” ");
INSERT INTO sps_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Anyo nat you Anyi na kuigin, mes tsian,” te tsue fi na moun to. ");
INSERT INTO sps_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Fuainy tsuvumamam iny Samaria fafaatouf ror e Gov tana tobeer to, kat pas fei sa mi na taa Jiu tsue na ka ei, i Jerusalem tsun ayei na pan ma fafaatouf ara Gov.” ");
INSERT INTO sps_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisas tsue to tsunia, “Faaman You, moun, tan nainy te naa minon, vainy a kinai gim ror ma fafaatouf e Tamanyo tana tobeer to, ge unya Jerusalem. ");
INSERT INTO sps_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ami na taa Samaria gim rom a natiny e sei te fafaatouf romi ee, amam a taa Jiu natiny rom e sei natiny fafaatouf romam ee, tana saa Ayei te saup fatabin ir a vainy to te poo fi me tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","San nainy te naa minon, ai tovei ruak busen, an tan nainy to aya vainy fafaatouf faman faatouf ror e Tamanyo tan aaven ai tan kat man. Arin vainy fafaatouf to aya, e Tamanyo komainy rarori ma fafaatouf Ya. ");
INSERT INTO sps_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gov, Ayein Aaven, ai tsuri na vainy to te fafaatouf ror Ya, ma fafaatouf Ya tan aaven ai tan fo kat man.” ");
INSERT INTO sps_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ana moun tsue to Tsunia, “Anyo nat you, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy koo rori Krais, te naa minon. Nainy te naa minon Ya, Ayei nai pokei of rarora na fo mamatsiny ka.” ");
INSERT INTO sps_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisas biny towa sa tsue, “Anyo tsun tovei te vevegiau fiisen mamirom anyi, Anyo na Krais.” ");
INSERT INTO sps_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tan ar nainy to aya matisian ten Jisas tabin fatabin mito, ana ri karian fiisok tsun rato te sab finy ari Jisas te vegiau fiisen minon a moun. Sana sikia ta isen tsuri ma vegiau fiisen me na moun to, “A saa te komainy rom anyi na?” ge rangats e Jisas, “A saa te vevegiau fiisen of mirom Anyi na moun to na?” ");
INSERT INTO sps_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ana moun to naus osing to na kepaa aurom tsuan, ana ya tabin fatabin en naa to tana ngats fan, ya tsue to tana vainy na aya, ");
INSERT INTO sps_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Taami yam am tagaa to tana mes te gima tatagei vaarik ara muan ana Ya tsue of kan vatuanyo na fo mamatsiny kat te katkat anyo muan. Fiisia, ai toroman Ya na Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy?” ");
INSERT INTO sps_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ana ri naus osing to na ngats fan ri naa fi to ten Jisas. ");
INSERT INTO sps_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ai tan nainy te naus osing a moun to Jisas an matisian rangats Towa, “Tsoiny Fifaatsuts, ainy tsom ta kainy ainy!” ");
INSERT INTO sps_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sana Ya biny rari, “Nyo kaa mirou na kainy ainy iny ainy gim romi ma natiny.” ");
INSERT INTO sps_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","An matisian tanik iny fararangat patsukan rato fapoopoan narari, “Fiisia, kaa minon ta vainy te mei of mi Ya ta kainy ainy?” ");
INSERT INTO sps_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisas tsue to tsuri, “Kainy ainy Tsonyo, ito tan manaats mangiir Tsunia to te jiats Vaminyo, ana binun te faan iny Ya Tsonyo ma kap faarof. Ayei na binun te faarei non a kainy ainy te viits iny Ronyo. ");
INSERT INTO sps_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ami natiny reev rom mi te tsue na ka, ‘A mes a fats a iifaa te kaakaa non an nainy bus iny agio!’ Nyo tsue of maromi, tagaa faarof yam te naa miror a vainy unya, ri faarei ror kainy ainy te matsua en, kakoun os to ma agio ravaa! ");
INSERT INTO sps_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A mes te agio non mei minon a vainy ma faamainy Vanyo ri, nai kaa miror a toto na suu, ayei nai nom non a foiny tsuan. Ai sei na mes te reev non vegiau Tsonyo koma rari ee, ana mes to te agio of Varonyo nai paparaa faavot raror, ");
INSERT INTO sps_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","te faarei non u vegiau tovei, ‘A isen a mes te reev non, ana mesmes te agio.’ An u vegiau tovei man ovei, ");
INSERT INTO sps_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","tana saa, mesmes te reev vegiau Tsonyo tana komar a vainy, ana Nyo jiats ma naa mi ma mei ramiri ma faaman ari Tsonyo. Tan kat to aya ami te agio rom of Vanyo, sana mi nai nom rom a tafan tsuam, tana binun tana mes mes kanen.” ");
INSERT INTO sps_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ana taa Samaria na kinai tana ngats fan naa to aya faaman to ten Jisas tana saa a moun te tsue na ka, “Ayei te tsue of vanyo na fo mamatsiny ka te katkat anyo muan.” ");
INSERT INTO sps_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Te nai tagei mi ri Ya tana gaguur aurom, ri rangats Towa ma kaa fiisen mi ri Ya fan tsuar, ana Ya kaa enato onots fuan nainy. ");
INSERT INTO sps_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ana fokinai faaman to tana saa tan vegiau tsun Tsunia, ");
INSERT INTO sps_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ana ri tsue to tana moun, “Amam faaman os to tana saa, sikia ma tan vegiau te kat anyi sana mam patsukanem te nongoiny fatoobing Ya, ana mam nat fi rom tovei, Ayei na Krais faman a Tsoiny Fiisaup tana vainy tana monaagits to.” ");
INSERT INTO sps_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Voun fuan nainy te kaakaa Ya na aya. Jisas naus osing to na fan sa naa fi en tana gum fan Tsuan fatoobing unya Galili. ");
INSERT INTO sps_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ai Jisas tsue patsukan to, “A kuigin te gim rori ma fatsiitsii faarof tana gum fan Tsunia fatoobing.” ");
INSERT INTO sps_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Te ruak mi Ya tana gum fan iny Galili ana vainy koma paparaa mi Towa, tana saa ari te naa fi tan Guainy iny Fakats Fatabin unya tana ngats fan tsian iny Jerusalem ana ri tagei ton fo mamatsiny ka te kat Ya tan nainy tan guainy. ");
INSERT INTO sps_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ai Jisas naa fatabin fi enato tana ngats fan iny Kena tana gum fan iny Galili tana pan te kopis Ya na aurom sa faarein wain. Te kaa men a tsoiny mumua tana gamaman na aya, a guei tsoiny tsunia na soon iny faadis kaakaa kanen na aya tana ngats fan iny Kapeniam. ");
INSERT INTO sps_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Te nongoiny ya Jisas te naus osing fi mi ya na gum fan iny Judia sa naa fi en tana gum fan iny Galili, ya naa fi nato Tsunia sa rangats Ya ma naa fi Ya tana ngats fan iny Kapeniam ma tsipaar Ya na guei tsoiny tsunia, a soon iny faadis ana matauts. ");
INSERT INTO sps_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisas tsue to tsunia, “A sikia ta isen tsumi te faaman non onot non te tagei finy romin kan karap ana fo binun saar iny faatok.” ");
INSERT INTO sps_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Mes tsian,” biny finy ya na tsoiny mumua tana gamaman, “Taame ma naa ra tabuiny mat non a guei tsonyo.” ");
INSERT INTO sps_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisas tsue to tsunia, “Kua, guei tsoiny tsumanyi nai toto enanon.” Ana mes to faamainy ton vegiau ten Jisas sa naa en. ");
INSERT INTO sps_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te taataan naa ya sanaan ana tsoiny binun tsunia tainytainy towa fiisen men vaanan to, “A guei tsoiny tsumanyi te toto en!” ");
INSERT INTO sps_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ya rangats ratuari saf nainy ei na te toto na guei tsoiny tsunia ana ri tsue to, “Naanaf tana isen a kilok tana touraf ana fisikii to naus osing towa.” ");
INSERT INTO sps_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ana tetee fakats fatabiny to na ka to tan ar nainy to aya te tsue of finy ya Jisas, “A guei tsoiny tsuam nai toto enanon.” Ana ayei ana fokinai faavot numaa tsunia faaman to ten Jisas. ");
INSERT INTO sps_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ayein fafuan nana binun a karap iny faatok reits ten Gov te kat e Jisas tana gum fan iny Galili to te naus osing fi mi Ya na gum fan iny Judia. ");
INSERT INTO sps_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Voun a foka to, Jisas naa fi enato tana ngats fan tsian iny Jerusalem tan guainy nan fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Unya gagon Jerusalem, panan matainy sobaa tana aunon to te bau faafis a Jerusalem koo rorin Matainy Sobaa tan Siip, a aurom kepak kaa minon a ngim a tovaar te faafis ror ya tan faa Hiburu koo rori Betesda. ");
INSERT INTO sps_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ana gum iny vainy faadis sosoon tsun ror tan saparoon nan tovaar rin vainy mata kio, mour a tavenek, an pengong. Ari anaanos ror a aurom kepak ma vasaguat ya, ");
INSERT INTO sps_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tana saa a morena tana Tsunaun natiny guats non a aurom kepak tan nainy te ruak minon ya. Te guats non ya ana mes a faadis to te tsiak faamuan naa gagon nana kepak nai toto nanon tana faadis te kaa minon ya. ");
INSERT INTO sps_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A mes a faadis te kaa na aya sa onots tonuafunuu ana jian a ingainy. ");
INSERT INTO sps_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas tagei towa te soon non ana ya natiny towa na faadis tan nainy viviakoo, ana Ya tsue to tsunia, “Fiisia, anyi komainy toto rom?” ");
INSERT INTO sps_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ana mes a faadis to biny Towa, “Mes tsian, anyo na sikia ta mes ma nai fasiuf vanyo ya gagon nana kepak te vasaguat fi non ya, te kat iny siuf ronyo gagon mes vainy siuf faamuan buser.” ");
INSERT INTO sps_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisas tsue to tsunia, “Tsun, nom nenengan tsuam nyi te taan.” ");
INSERT INTO sps_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sen tsun ana mes to rof enato, ana ya govets ton nenengan tsuan sa taan en. A ka to te ruak tan Nainy Fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","An tsoiny mumua tana taa Jiu tsue to tana mes to te rof fatabin, “U Nainy Fafaatouf to, Faun te kirkir iny e Moses tsura te gim non ma famanat manyi ma govets nenengan tsuam tan Nainy Fafaatouf.” ");
INSERT INTO sps_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ana ya biny ratuari sa tsue na ka, “A mes to te tsipaar vanyo te tsue of vanyo ma ‘Govets nenengan tsonyo, nyo te taan.’” ");
INSERT INTO sps_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ri rangats towa, “E sei na mes to ayei te tsue of manyi ma govets nenengan tsuam nyi te taan ee?” ");
INSERT INTO sps_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sana mes to te rof fatabin gima natiny e sei na mes fatoobing to aya ee, tana saa a vainy a kinai fiisok te vaaguam na aya ai Jisas naus osing ratuari sa naa en. ");
INSERT INTO sps_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Vou, ai Jisas sab towa tana saape, Ya tsue to tsunia, “Nongon rom, anyi rof fatabin em, nyi ma fakap ovei bus a fo kat iny aveto tsuam kat non sana iring tsian fiisok ruak manyi.” ");
INSERT INTO sps_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ana mes naa bus naa to sa tsue of ir fuainy tsoiny mumua tana taa Jiu, “A mes to ayei te tsipaar vanyo, Ayei koraa e Jisas.” ");
INSERT INTO sps_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tan kat to aya ri tanik iny fapatang to Jisas, tana saa Ayei te kat kat iny tsipaar tan Nainy Fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas biny ratuari sa tsue, “E Tamanyo binun fiisok non tana binun Tsuan tan mamatsiny nainy, ana Nyo kan ma bibinun fi kan you jesan.” ");
INSERT INTO sps_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","U vegiau to te kat faseeve fiisok ir fuainy tsoiny mumua tana taa Jiu, ri vusvus faparits iny towa ma atsuiny famat ari Ya, sikia ma to te ngats fi Ya na Faun te kirkir iny e Moses tan Nainy Fafaatouf tana taa Jiu tsun, sana Ayei te tsue na ka e Gov te faarei non e Taman Ya fatoobing, tan kat to aya, Ayei kat a Tsivon sa faarei Ayei senviir minon e Gov. ");
INSERT INTO sps_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ai Jisas biny ratuari sa tsue na ka, “Nyo tsue faman of maromi, a Guei Tsoiny gim non ma kat ta isen ta ka tan mangiir Tsunia patsukanen, Ayei kat tsuiny non kat te tagei non Ya ten Taman te natiny kat non ya, tana saa, a fo kat te natiny katkat non a Taman, a Guei Tsoiny kan katkat kainy non ya. ");
INSERT INTO sps_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tan kat to aya a Taman mangiir fiisok non a Guei Tsoiny ana Ya te faatok Ya na fo mamatsiny ka te natiny katkat non Ya. Ayei nai faatok non Ya na fo mes a foka te karap fafisfis pis iny non a foka to te nai katkat non Ya, ana mi te nai mata karian fiisok emanats. ");
INSERT INTO sps_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","To kan a Taman fatoto non vainy mat, ri te toto fatabin er, jesan kan, a Guei Tsoiny fatoto non ere sei tan mangiir Tsunia tsun, ee. ");
INSERT INTO sps_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ai Taman kan gim non ma kat vaatsuk ten sei na mes ee. Ayei faan fakap bus iny kat iny vaatsuk to tana Guei Tsoiny Tsuan, ");
INSERT INTO sps_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","to ma nai fatsiitsii faavots a fokinai a Guei Tsoiny, jesan kan ma kat fi kan ari ten Taman. E sei na mes te gim non ma fatsiitsii na Guei Tsoiny ee, gim kainy non ma fatsiitsii na Taman to te jiats mi Ya. ");
INSERT INTO sps_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nyo tsue faman of maromi, e sei te nongoiny non vegiau Tsonyo ee, ya te manaats ya ana ayei te faamainy Ya to te jiats Vaminyo kaa bus me na toto na suu, ai te gima nai pokei ya, ai te nom a fasaraa nana mat a suu, sana ayei aruwas osing bus a mat a suu ana ayei kaa bus me na toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nyo tsue faman of maromi, nainy te naa minon, an nainy te ruak busen to, te nongoiny fi ror vainy to te faarei raror vainy mat tan aaven, nai nongoiny rora ngue na Guei Tsoiny ten Gov, ai tsuri to te nongon ana ri te faamainy ya nai toto ror. ");
INSERT INTO sps_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ai to kan ten Tamanyo Ayei na kifon a toto tan aaven, jesan, Ayei kat a Guei Tsoiny Tsuan sa faarei na kifon a toto kan tan aaven. ");
INSERT INTO sps_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ana Ayei faan iny ton gumgum tan kat vaatsuk tana Guei Tsoiny, tana saa, Ayei na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me. ");
INSERT INTO sps_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Koma karian vaare yam tana ka to tana saa, nainy te naa minon ana fo vainy mat tan katskats te nai nongoiny rora nguen Ya, ");
INSERT INTO sps_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ana ri te tafuts osing men kats tsuar, ai to tsuri te kat fo binun a fo rof nai tsun fatabin ror ri te toto ovei er, ai to tsuri te kat, kat iny ngi'arapaar nai tsun fatabin ror, ai te nai pokei rari ma nom a fasaraa nana mat a suu.” ");
INSERT INTO sps_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nyo patsukan you gima onot ma kat ta isen ta ka, Nyo kat rou kat iny faaron tsun te tsue of Varonyo Gov, an kat iny faaron te kat Ronyon toobing ovei, tana saa, Anyo gim rou ma tanaf ma kat Anyon kat tan mangiir Tsonyo, san tan mangiir Tsunia to sa jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Te tsue pokaa iny Ronyo na Tsivou, Anyo sei ana fo binun te kat Ronyo, a sikia ta mes te faarof iny non ya a faarei to na man. ");
INSERT INTO sps_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sen Tamanyo to te pokei Vanyo, ana Nyo nat you tana ka te tsue pokei iny Ya Tsonyon man ovei. ");
INSERT INTO sps_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ami te jiats ra naa na vainy tsumi ten Jon a Tsoiny Fapeenan ma nongoiny arin vegiau tsunia, ana ayei tsutsun of Vatuanyo sa tsue pokaa iny a mana Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nyo tsugei rou vegiau tan ta mes ma pokei faruak Vanyo, Anyo sei, sana Nyo tsue tsuk iny rou e Jon, ma faamainy ami Nyo ma saup fatabin Anyo mi tana mat a suu. ");
INSERT INTO sps_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon faarei kurun, kurun sa baraar, ana mi mangiir towa tan ar nainy sam paparaa men kurun tsunia. ");
INSERT INTO sps_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Sana Nyo kaa mirou a foka te tsutsun of Varonyo te karap fafis iny non vegiau to te pokei iny e Jon, ito na fo binun te katkat Anyo, na fo binun te faan iny e Tamanyo ma kat Anyo, to te tsutsun of Varonyo, ana fo binun te pokei faruak irari te faatok iny non e Tamanyo te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ai Tamanyo to te jiats Vaminyo te tsutsun of Ronyo tsue pokaa kan Varonyo. Ami gim rom ma nongoiny a nguen Ya ge tagei kainy a matan Ya, ");
INSERT INTO sps_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ana mi gim to ma nom vegiau Tsunia to koma mami tana saa ami te gima faamainy Ya to te jiats fi Vaminyo Ya. ");
INSERT INTO sps_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mi tsue tsuk kifon vegiau tan Vegiau Ten Gov tana saa ami te pon ma nom a toto na suu tsunia. An fo vegiau tan Vegiau Ten Gov to, tsue pokei Varonyo! ");
INSERT INTO sps_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sana mi gima fakats ma naa me am faamainy Vatuanyo ma faan im yam a toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nyo tsugainy rou ta mes ma fakarap Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Sana Nyo nat maromi ami na sikia tu mangiir ten Gov tana fo koma mami. ");
INSERT INTO sps_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Anyo te mei me na parits ten Tamanyo, sana mi tsugei Vanyo, ai to ten sei na mes te mei minon a parits tsuan ee mi te faarof ya. ");
INSERT INTO sps_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ami gim on rom ma faaman, tana saa ami komainy rom a vainy ma fakarap mami, sana mi gim rom ma siiva of a tou karap te poo fi minon tana isen tsun a Gov. ");
INSERT INTO sps_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sana mi ma pon fi vaare nei Nyo pokei iny a fo iring tsumi matan ne Tamanyo. A sikia, a mes te pokei maromi to, e Moses ito na mes te pon fi romi nei ayei faakouts maromi ma naa fi Gormirmir. ");
INSERT INTO sps_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tabuiny faaman famainy ami Moses, ami tabuiny faamainy Vanyo, tana saa Moses kirkir tsuk Vanyo. Sana mi gim to ma faamainy e Moses, jesan mi gim kan ma faamainy Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ai to te gim fi romi ma faamainy a ka te kirkir iny e Moses, kat pas fi romi ei, mi te faamainy vegiau te tsue iny Ronyo?” ");
INSERT INTO sps_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Voun a ka to, Jisas tabin fatabin nato tan mes panan nana naaman koo rori Galili (ge koo kainy rori na Naaman iny Taiberias). ");
INSERT INTO sps_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ana vainy a kinai vovou iny Towa, tana saa ari tagein fo binun iny faatok Tsunian reits tan tsipaar vainy faadis. ");
INSERT INTO sps_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas taan fapaas naa to tana painy tet ana Ya vaagum fiisen miton fuainy matisian Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","U nainy Guainy tana taa Jiu iny Fakats Fatabiny te sisiruu ename. ");
INSERT INTO sps_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas tagaa vavis ana Ya tagei raton vainy a kinai fiisok te naa fi miror Tsunia, ana Ya tsue to ten Filip, “Fei te foiny rora ta kainy ainy ta onot ma fa'ainy ara na vainy a kinai to ari ei?” ");
INSERT INTO sps_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ayei te vegiau iny a ka to ma tanaf Ya na faaman ten Filip, sana Ayei nat faamuan bus iny a ka te nai kat non Ya.) ");
INSERT INTO sps_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip biny Towa, “Te nai karap fafis toromainy non fuan a natus a kina tan foiny fo koinykoiny to, tsuri na fokinai komainy ainy ror mormor tana kainy ainy.” ");
INSERT INTO sps_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ana mesmes a matisian Tsunia, Anduru, ayei na famuinyasiny ten Saimon Pita tsue to, ");
INSERT INTO sps_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“A isen a guei tsoiny tovei kaa minon a ngim ma koinykoiny ana fuan a jian. Sana saf a rof narari matar a fokinai vainy faavot to na?” ");
INSERT INTO sps_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisas tsue to tsuri, “Tsue of ir yam a vainy ma gum ari petoo.” (Te kaa me na aufing a kinai na aya.) Ana vainy a kinai gum to, kaa me na ngim a tapan mes tsun moun an guei sikia ma as faavot. ");
INSERT INTO sps_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisas nom to na koinykoiny, Ya faarof iny naa towa ten Gov ana Ya faan iny ton koinykoiny tan matisian Tsunia ser tatafas rari na vainy te gumgum na aya. Ana Ya kat fi kanen nato jesan tana fuan a jian, ana ri viits rato tan mangiir tsuri. ");
INSERT INTO sps_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Te viits guas ari, Ya tsue to tan matisian Tsunia, “Fag yam a fo ainy osing to, kat raravainy vaare yam fo ainy osing to.” ");
INSERT INTO sps_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ana ri fag faavots ratuari, ana ri fau favei to na safunuu ana fuan a koverok nan ainy osing tana ngim a koinykoiny te ainy a vainy. ");
INSERT INTO sps_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ana vainy a kinai na aya, tagei to na binun iny faatok reits to te kat e Jisas ri tsue to na ka, “Man ovei, Ayei na kuigin to aya, te pokei iny ari muan te naa minon tana monaagits to!” ");
INSERT INTO sps_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas nat faamuan bus rari na tou nom Ya, er sogsog Towa ma faarei Ya na Aatouf, ana Ya tabin fatabin pis nato tana painy tet Ayei patsukanen. ");
INSERT INTO sps_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Te touraf busen an matisian Tsunia of fi naa to tana naaman, ");
INSERT INTO sps_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","jias to tan puak, ser tanik iny sepuu faguas fi naa tan mes panaan nana naaman tana ngats fan iny Kapeniam. Te voiny busen, ai Jisas tabuiny ma naa fi tsuri. ");
INSERT INTO sps_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A ainysat a parits te taf me an rau guats to na naaman. ");
INSERT INTO sps_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Matisian sepuu sa onots toromainy a ngim ge na aunom a kilomita veevian ana ri tagei to Jisas taan non patsun a naaman, taan fasiruu minon tan puak ana ri oraav faavot ovei rato. ");
INSERT INTO sps_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","“Oraav vaare yam,” Jisas tsue of rari, “Anyo vaa ei aa!” ");
INSERT INTO sps_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ri komainy ma fajias e Jisas tan puak sen tsun an puak sung nato tana pan te naa ri. ");
INSERT INTO sps_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tan mes nainy an tagin to te daup tan mes panaan nana naaman komainy to ma tagei e Jisas. Ri tagaa to te kaa farokot fin sen puak na aya. To sana ri nat fi rato nei Jisas gima jias tan puak fiisen ramen fuainy matisian Tsunia sana ri patsukaner. ");
INSERT INTO sps_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ana fo mes a fo puak poo fi me Tiberias sung mito panan a pan te guainy a vainy te ainy arin koinykoiny to te faarof iny a Tsunaun. ");
INSERT INTO sps_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Te gima tagei finy a vainy a kinai e Jisas na aya fiisen ramen matisian Tsunia, ri jias to tana fo puak ana ri naa fi rato tana ngats fan iny Kapeniam a tou sainy Ya. ");
INSERT INTO sps_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Te sab finy a vainy e Jisas tan mes panaan nana naaman ri tsue to na ka, “Tsoiny Fifaatsuts farainy te naa mi Nyi nei?” ");
INSERT INTO sps_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisas biny ratuari sa tsue na ka, “Nyo tsue faman of maromi, ami sainy Vanyo, sikia ma tana ka iny faatok reits te tagei ami, san tan koinykoiny te ainy ami sa mi viits guas im. ");
INSERT INTO sps_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Anofe yam a kainy ainy te natiny kuav non ana mi te siiva of a kainy ainy a sikia ta fafakap nan, ito na toto na suu te faan iny Ronyo na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me tsumi tana saa, Gov, a Taman te fainy Vanyo na parits poo fi me Gormirmir faatok maromi, Gov pisainy fatoobing Vanyo.” ");
INSERT INTO sps_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ana ri rangats Towa, “A saf a binun ma kat amam ma kat fapaparei amam e Gov na?” ");
INSERT INTO sps_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisas biny ratuari, sa tsue na ka, “A binun to te mangiir non e Gov ami ma kat to, faaman yam tana isen tsun to te jiats me Gov.” ");
INSERT INTO sps_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ri biny Towa, “Saf a ka iny faatok na te nai kat pokei rom Anyi faatok maromam ten Gov te pisan Manyi ma faaman amam? A saa te kat rom Anyi na? ");
INSERT INTO sps_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Fuainy tsuvumamam muan te ainy koinykoiny te koo rin Mana tana pan a uur te tsue fin Vegiau Ten Gov, ‘Ayei te faan iny men koinykoiny te poo fi me Gormirmir kainy ainy tsuri.’” ");
INSERT INTO sps_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisas tsue to, “Nyo tsue faman of maromi, ka te faan iny e Moses tsumin sikia ma koinykoiny te poo fi me Gormirmir, E Tamanyo tsun to te faan maromin koinykoiny faman poo fi minon Gormirmir. ");
INSERT INTO sps_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tan koinykoiny faman to te faan iny non e Gov tovei, Ayei to te of me poo fi me Gormirmir ana Ya faan rato na vainy tana monaagits to na toto na suu.” ");
INSERT INTO sps_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Tsunaun,” rangats fi ri Ya, “fafaan fatatabin mamimam koinykoiny to aya tan mamatsiny nainy.” ");
INSERT INTO sps_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","“Anyon koinykoiny te kifon iny non a toto.” Jisas tsue tsuri, “E sei to te naa minon ya te faaman Vanyo ee, gim non ma nai ves on nats, ai sei to te faaman non Tsonyo ee, gim non ma nai iinyu on nats. ");
INSERT INTO sps_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nyo tsue of maromi, ami tagei bus Vanyo sana mi gima faaman. ");
INSERT INTO sps_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ere sei tsun to te faan iny e Gov Tsonyo ee, naa miror Tsonyo. Nyo gim rou ma biak ravaa ir ere sei te naa miror Tsonyo ee, ");
INSERT INTO sps_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","tana saa, Nyo of me poo fi me Gormirmir ma kat Anyon mangiir Tsunia to te jiats Vaminyo, sikia ma tan mangiir Tsonyo tsun. ");
INSERT INTO sps_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","An mangiir Tsunia to te jiats Vaminyo tovei, ma makok faarof Anyo ere sei te faan iny e Gov Tsonyo ee, ma nun vaare ta isen, sana Nyo nai ras fatsun rarori tana mat tan nainy fafakap. ");
INSERT INTO sps_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mangiir ten Tamanyo tovei, tsuri tsun te suu iny ror a matar tana Guei Tsoiny ri te faamainy Ya, nai kaa miror a toto na suu, ana Nyo nai ras fatsun rarori tana mat tan nainy fafakap.” ");
INSERT INTO sps_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ana ri na taa Jiu tanik iny ngun'ngun iny Towa, tana saa Ayei te tsue na ka, “Anyon koinykoiny to te poo fi me Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ana ri tsue to, “A mes to aya Jisas a guei tsoiny ten Josep, Ayei koraa Ya? Amam natiny rom e taman Ya me tsinan Ya. Kat pas fei sa tsue na ka, Ayei te of fi me Gormirmir ei?” ");
INSERT INTO sps_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisas biny ratuari, “Onot en ngun'ngun vaare yam fapoopoan namami tan vegiau te pokei Anyo. ");
INSERT INTO sps_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","A sikia ta isen ta mes te onot non ma naa Tsonyo onot non e Tamanyo to te jiat Vaminyo te ras fatap fi non ya, a naa mito Tsonyo, ana Nyo te nai ras fatsun ya tana mat tan fafakap nan nainy. ");
INSERT INTO sps_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Fuainy kuigin te kirkir muan, ‘Gov nai faatsuts raror fo vainy faavot.’ Ere sei tsun te nongoiny ror e Tamanyo ana ri te nom a nat poo mi non Tsunia ee, naa miror Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","A sikia ta isen ta mes te tagei a Taman, Ayei tsun Tsivon to te poo fi me ten Gov Ayei na mes te tagei e Taman. ");
INSERT INTO sps_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nyo tsue faman of maromi, e sei tsun te faaman non ee, kaa minon a toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Anyon koinykoiny te kifon iny non a toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Fuainy tsuvumami te ainy koinykoiny te koo rin Mana tana pan a uur, sana ri mater. ");
INSERT INTO sps_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","San koinykoiny to te poo fi me Gormirmir te faan iny non a toto na suu ten sei na mes te ainy non ya ee gim non ma nai mat. ");
INSERT INTO sps_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Anyon koinykoiny te kifon iny non a toto na suu to te poo fi me Gormirmir. Te ainy fi non a isen ta mes koinykoiny to, te nai toto ovei enanon. Koinykoiny te faan iny Ronyo to tsuri, a pua Vanyo, orovus of Anyo na vainy tana monaagits ma kaa mi ri na toto na suu.” ");
INSERT INTO sps_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ka to te tanik sa fatsuiny fapeepeits fapoopoan nara taa Jiu. “Fei te fa'ainy fi rora na mes a puan Ya ma ainy ara ei?” te rangat fi ri. ");
INSERT INTO sps_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisas tsue to tsuri, “Nyo tsue faman of maromi te gim fi romi ma ainy a puan a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me ana mi te jiun rafatsiny Tsunia ami gim rom ma kaa me na toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","E sei te ainy non a pua Vanyo ana ya te jiun rafatsiny Tsonyo ee kaa bus me na toto na suu, ana Nyo nai ras fatsun rou ya tana mat tan fafakap nan nainy. ");
INSERT INTO sps_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","To, pua Vanyo na kainy ainy faman ovei an rafatsiny na Vanyo, na kainy jiu faman ovei. ");
INSERT INTO sps_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","E sei te ainy non a pua Vanyo ana ya te jiun rafatsiny Tsonyo ee kaa non Tsonyo ana Nyo kaa rou tsunia. ");
INSERT INTO sps_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","E Taman, Ayei na kifon a toto to te jiat Vaminyo. Nyo toto kan rou, tana saa i Tsunia tsun, jesan kan ten sei na mes te ainy Varonyo ee nai toto enanon tana saa, i Tsonyo tsun. ");
INSERT INTO sps_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Koinykoiny te poo fi me Gormirmir ito te sikia non ma faarein koinykoiny te ainy fuainy tsuvumami muan sana ri mater. E sei na mes te ainy non koinykoiny to aya ee, nai toto ovei enanon.” ");
INSERT INTO sps_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas te tsue iny a ka to te fafaatsuts fi Ya koman a numaa iny fafaatouf tana taa Jiu tana ngats fan iny Kapeniam. ");
INSERT INTO sps_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","An fo matisian Tsunian kinai nongoiny ton vegiau ri tsue to na ka, “U fifaatsuts tovein opaar fiisok, ana sikia ta isen ma onot tan faamainy ya.” ");
INSERT INTO sps_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tabuiny nom non Yan vegiau to, Jisas nat faamuan ir matisian Tsunia te ngun'ngun iny faatsuts to, ana Ya tsue to tsuri, “U faatsuts tovei te kat mami sam komainy faterof rom tan vovou Vanyo? ");
INSERT INTO sps_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ami pon iny rom a saa, to te tagei finy romi na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me te tabin fatabin fi naa non Ya tana fan te poo fi mi Ya muan? ");
INSERT INTO sps_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","U Aaven Taabos tsun Tsivon to, Ayei kat fatoto non a mes aaven ya. Puainy mes a sikia ta parits iny kat fatoton aaven. Sai tovei, Nyo tsue faamuan of bus mami yam tan kat iny nom a toto faman tan aaven. ");
INSERT INTO sps_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sana mesapan tsumi gima faaman Vanyo.” (Jisas nat faamuan en tan tatanik ten sei te gim non ma faaman ee, ai sei te nai faan iny non Ya ma atsuiny ari Ya.) ");
INSERT INTO sps_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ana Ya tsue pis to na ka, “Ayei koraa na kifon a ka to sa Nyo tsue of mami na sikia ta isen ta mes te onot non ma naa me Tsonyo onot non te famanat fi non e Tamanyo ma naa mi ya.” ");
INSERT INTO sps_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tan kat to aya, ana fokinai to te vovovou iny Ya naus osing Towa ri tabin fatabin rato tan kat mangiir tsuar sana ri gima vovou pis iny naa Ya. ");
INSERT INTO sps_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ai Jisas tsue to tana ina safunuu ana ina fuan a matisian Tsunia, “Ami paas, ami komainy naus osing kan Varonyo?” ");
INSERT INTO sps_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita biny Towa, “Tsunaun, fei te naa romam ei? Anyi kaa mirom vegiau te kifon iny non a toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tovei roman amam faaman ovei rom ana mam nat fi rom nei i Tsumanyi tsun Anyi na Isen a Taabos te poo fi me ten Gov.” ");
INSERT INTO sps_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisas biny ratuari sa tsue na ka, “Anyo pisan bus mami na ina safunuu ana ina fuan sana isen fapoopoan namami na vinasaar!” ");
INSERT INTO sps_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ayei te vevegiau tsuk iny e Judas, a guei tsoiny ten Saimon Iskariot. Ai Judas, to na isen tsuri na ina fasafunuu ana ina fuan a matisian to te faan iny naa non Ya nima rari ma atsuiny ari Ya. ");
INSERT INTO sps_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Voun a ka to, Jisas taan vavis naa to koman tana gum fan iny Galili, Ayei te baainy ma naa fi tana gum fan iny Judia, tana saa fuainy tsoiny mumua tana taa Jiu te komainy ma atsuiny Ya. ");
INSERT INTO sps_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","U nainy Guainy tana taa Jiu tan Fatsuiny fo Tovaar Kandis ma kaa taataun tsom ari te sisiruu naa me, ");
INSERT INTO sps_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","4","an fuainy famuinyasiny ten Jisas tsue taring iny Towa, “Te komainy fapaas rom Anyi na Tsivom, naus osing a fan to kua tana gum fan iny Judia ma tagaan fuainy matisian Tsumanyi tana fo binun iny faatok te katkat rom Anyi. Fiisia, sikia ta isen ta mes te famuiny non kat te natiny katkat non ya ma tagaa na fokinai. Tan kat te katkat rom Anyi tanyir a monaagits to ma inainy fanatnat Manyi ri!” ");
INSERT INTO sps_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Sana sikia ta isen nar famuinyasiny Tsunia ma faamainy Ya.) ");
INSERT INTO sps_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisas tsue to tsuri, “U nainy fatoobing Tsonyo te mataanis minon, ana fo nainy tsumi, mi kaa mirom nainy kinai iny vavis babainy te naa fi romi tan guainy. ");
INSERT INTO sps_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A vainy tana monaagits mangiir maromi, ana ri te tsugei Vanyo, tana saa, Anyo tsue patsukan You tan kat tsurin iring ovei. ");
INSERT INTO sps_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ami ma naa fi tan guainy Nyo gim rou ma naa tsom, tana saa nainy fatoobing Tsonyo te mataanis minon.” ");
INSERT INTO sps_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ayei tsue na ka to, ana Ya kaa farokot en tana gum fan iny Galili. ");
INSERT INTO sps_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Voun fuainy famuinyasiny Tsunia te naa fi naa ri tan guainy, Jisas naa kanen nato, ana Ayei gim to ma ising fi naa matar a fokinai, a sikia, Ayei ising fatakop en. ");
INSERT INTO sps_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fuainy tsoiny mumua tana taa Jiu gima faterof tan sainy vavis e Jisas tan guainy. “Fei te kaa non a Mes to aya ei?” rangat fi ri. ");
INSERT INTO sps_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","U fasisiraan kinai te kat ari Tsunia komar a vainy a kinai. Mesapan tsuri na vainy tsue to, “Ayei na mes a rof fiisok,” ana mesapan tsuri tsue to na ka, “A sikia, Ayei fagaug non a vainy.” ");
INSERT INTO sps_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sana sikia ta isen tsuri ma tsue pokei Ya tana arasan, tana saa ari te oraav ir fuainy tsoiny mumua tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nainy guainy te onot en koman, ai Jisas naa fi naa to tana veevio nana saape ana Ya tanik iny faatsuts ratuari. ");
INSERT INTO sps_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Rin fuainy tsoiny mumua tana Jiu koma karian fiisok rato ri tsue to na ka, “Fei te nom ising finy a mes to ayei a nat ei? Tsunia te gima nom a nat tana pan tan fafaatsuts.” ");
INSERT INTO sps_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisas biny ratuari sa tsue, “U fifaatsuts te faatsuts iny Ronyon sikia ma faatsuts Tsonyo, san u faatsuts te poo fi me ten Gov to te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","E sei na mes te komainy kat non mangiir ten Gov ee nai natiny ror fafaatsuts te faatsuts iny Ronyo to te poo fi me ten Gov ge te nai vegiau kan iny Ronyo na parits Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A mes te pokei iny non a tsivon te komainy tsuiny non ma nom a vamarits tana tsivon. Sana ayei to te komainy non ma nom vamarits tana isen to te jiats mi ya, ayei na man ana sikia ta gam ma kaa tsunia. ");
INSERT INTO sps_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses faan mamin Faun teeva, sana sikia ta isen tsumi ma manaats ya. Kat fei sam pon rom ma atsuiny Vanyo ei?” ");
INSERT INTO sps_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Rin vainy faavot biny Towa ser tsue na ka, “Anyi na tutuei iny masarau! Sei te pon non ma atsuiny ma Nyi ee?” ");
INSERT INTO sps_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ai Jisas tsue to tsuri, “Nyo kat a isen a binun iny faatok tan Nainy Fafaatouf tana taa Jiu sa mi mata karian em. ");
INSERT INTO sps_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ami nai kat rom kat iny vaapee tan guei tsoiny tsumi tan Nainy Fafaatouf tana taa Jiu tana saa, Moses tsue faparits of bus mami ma kat kat iny vaapee tan guei tsoiny tsumi tan Nainy Fafaatouf. (U kat iny vaapee to sikia ma poo fi me ten Moses a sikia, kat to te tanik en muan tan fuainy tsuvumami.) ");
INSERT INTO sps_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","To te vaapee fi non a guei tsoiny tan Nainy Fafaatouf tana taa Jiu, kat to aya gima ngats Faun te kirkir iny e Moses, kat pas fei sam peits Varonyo ei, tana saa, Anyo te fatoto na mes tan Nainy Fafaatouf tana taa Jiu? ");
INSERT INTO sps_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Fakats faarof yam a ka to. Faonot yam tan faaroiny a mes ana ka te kaa non jiarasan tan puainy mes tsun, mi ma faaroiny fatoobing a ka tana man.” ");
INSERT INTO sps_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mesapan tsuri na vainy tana ngats fan tsian iny Jerusalem tsue to na ka, “Ayei koraa Ya na mes te komainy rori ma atsuiny? ");
INSERT INTO sps_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tagaa Yam! Ayei te vegiau non matar a fokinai, ana sikia ta isen ma biny vaarik a nguen Ya! Toroman fuainy tsoiny mumua tana taa Jiu nat kan iny ror Ya Ayei koraa na Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy? ");
INSERT INTO sps_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ara na fokinai natiny ror a pan te poo fi mi Ya, ana sikia ta mes nai natiny non a pan te poo fi minon e Krais.” ");
INSERT INTO sps_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ai Jisas fafaatsuts to koman a saape Ya vegiau fatsian to, “Eye mi pon iny rom mi nat faman iny rom a fo mamatsiny ka na Vanyo ai mi nat kan iny rom ma pan te poo fi Minyo. Nyo gima naa me Tsivou. Ayei to te jiat Vaminyo, Ayei kaa faman non. Ami gim rom ma natiny Ya, ");
INSERT INTO sps_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","sana Nyo nat faman ovei rou Ya, tana saa Anyo kaa fiisen me Tamanyo, sa jiats Vaminyo to Tsonyo naus osing mi Ya.” ");
INSERT INTO sps_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ana ri pon to ma nots Ya, sana sikia ta isen ma saras vaarik Ya, tana saa nainy Tsunia te mataanis minon. ");
INSERT INTO sps_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sana ri na fokinai faamainy Ya, ri tsue to, “Fiisia, te naa minon ne Krais a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy, Ayei nai kat kainy non a fo mamatsiny binun iny faatok reits fis non a fo kat to te katkat a mes to Jisas?” ");
INSERT INTO sps_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Taa Farasi nongon ir a vainy te fasisiraa iny a foka to, to te tsue tsuk iny ari Ya, ana ri, min fuainy tsunaun tan tsoiny faakor tana taa Jiu jiats raton fo tsoiny bei ot tana saape ma nots ari Jisas. ");
INSERT INTO sps_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas tsue to, “Nyo nai kaa taataun tsun fiisen maromi ana Nyo te tabin fatabin pis Tsunia to te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ami nai san Varonyo, sana mi gim rom a sab Vanyo, tana saa, tana pan te nai kaa Ronyo ami gim rom ma naa on.” ");
INSERT INTO sps_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Rin tsoiny mumua tana taa Jiu tsue patsukan rato fapoopoan narari, “Fei te pon non Ya ma naa ma fanaginy sainy ara Ya ei? Ayei pon non ma naa fi tana fo ngats fan tana taa Grik tana pan te kaa ror a tee Jiu, a faatsuts rato na taa Grik? ");
INSERT INTO sps_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ayei te tsue na ka, ‘Ami nai sainy Varonyo sana mi gim rom ma sab Vanyo, ana mi te gima onot ma naa tana pan te nai kaa Ronyo.’ Saf kifon vegiau Tsunia to na?” ");
INSERT INTO sps_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","U nainy tsian te ruak tan fafakap tan nainy guainy. Tan nainy to aya Jisas tsun to sa vegiau fatsian en, “Sei te iinyu non ee ma naa me Tsonyo a jiu to, ");
INSERT INTO sps_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","faarei u Vegiau Ten Gov te tsue, ‘Sei te faaman non Tsonyo ee, a aurom te kifon iny non a toto te nai koor ising minon koman ya.’” ");
INSERT INTO sps_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas tsue tsuk iny Aaven Taabos, to ten sei te faaman ror Tsunia ee nai nom ror Ya. Tan nainy to aya Aaven Taabos gima naa me, tana saa Jisas tabuiny toto fatabin non Ya te tabin fatabin pis en tana pan tan fuainy siinaiv Tsuan Gormirmir. ");
INSERT INTO sps_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A vainy a kinai komar a gum iny vainy nongoiny Towa te tsue na ka to, “A mes to ayei na kuigin faman ovei!” ");
INSERT INTO sps_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mesapan tsuri tsue to na ka, “Ayei e Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy!” Sana mesapan tsuri tsue na ka, “A Krais, a Tsoiny Fiisaup gima poo fi me tana gum fan iny Galili! ");
INSERT INTO sps_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","U Vegiau Ten Gov te tsue, a Krais, a Mes to te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy nai tapogaar minon tana vun ten Devit, ana Ya te nai agiir unya tana gum fan iny Judia tana ngats fan iny Betlehem ito na ngats fan te agiir e Devit a aatouf.” ");
INSERT INTO sps_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tan kat to aya ten Jisas tsun ana vainy takibaa bus rato fapoopoan narari. ");
INSERT INTO sps_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mesapan tsuri kes ma nots Ya, sana sikia ta isen ma saras vaarik Ya. ");
INSERT INTO sps_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Rin tsoiny bei ot tana saape tabin fatabin to tan fuainy tsunaun tan tsoiny faakor ana taa Farasi, ri rangats ton tsoiny bei ot, “Kat fei sam gima mei mi Ya ei?” ");
INSERT INTO sps_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Rin tsoiny bei ot biny ratuari, “A sikia ta mes ma vegiau faarei na mes to!” ");
INSERT INTO sps_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A taa Farasi pitei ton puputaa fiisen men rangat iny peits tan tsoiny bei ot, “Fiisia, Ayei te fagaug kan mami? ");
INSERT INTO sps_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ami natem marom sikia ta isen tsumam fuainy tsoiny mumua tana taa Jiu ge taa Farasi ma faamainy vaarik Ya. ");
INSERT INTO sps_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Eye, gum iny vainy tovei faaman ror, sana ri gim ror ma natiny a Faun te kirkir iny e Moses, to sa ri kaa os to fain a fasaraa na suu ten Gov!” ");
INSERT INTO sps_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas ayei na isen tsuri na taa Farasi, ayei kan a mes to te naa sa tagei e Jisas muan, tsue to na ka tsuri, ");
INSERT INTO sps_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ito tana faun tsura, ara gim ror ma pokei faamuainy tsom a mes ma mat tabuiny nongoiny roran vegiau tsunia tan vaatsuk ra faaroiny faarof tsom to na saf a iring te kat ya na.” ");
INSERT INTO sps_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","“Eye,” te biny fi ri ya, “Anyi toroman kan a tsoiny Galili ge? Tagaa faarof tan Vegiau Ten Gov ana nyi te nat faarof a sikia ta isen ta kuigin nai tapogaar ising minon tana gum fan iny Galili.” ");
INSERT INTO sps_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ana fokinai vavakas rato tana fo numaa tsuar. ");
INSERT INTO sps_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ai Jisas naa fi nato tana tobeer iny Oliv. ");
INSERT INTO sps_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","San tana voinyvoiny ovei tan mes nainy Ya tabin fatabin enato tana saape. Ana gum iny vainy naa mito ser vaaguam faafis Ya, ana Ya gum naa to putaa Ya tanik iny faatsuts bus ratuari. ");
INSERT INTO sps_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Rin tsoiny fifaatsuts tan Faun te kirkir iny e Moses ana taa Farasi mei mito na moun to te sab ari te tsikoor ana ri fatsutsuiny towa matar a fokinai faavot. ");
INSERT INTO sps_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Tsoiny Fifaatsuts,” tsue fi ri ten Jisas, “A moun a fanging to te sab amam te tsikoor fiisen me na mesmes a tsoiny kanen. ");
INSERT INTO sps_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tana Faun tsura, Moses tsue faparits, a moun te kat non kat to ma totouruei famat ravaa men fats. Jio, a saa te tsue patsu rom Anyi na?” ");
INSERT INTO sps_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri tsue iny a ka to ma fataraatsua ri Ya er fakei naa Towa tan vaatsuk. Sen Jisas fakokop sa kirkir tan puputaa fiisen me na karoor nan. ");
INSERT INTO sps_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Te tsutsun ari na aya ri gima faonot tan rangats Ya, Ya paroor to na puan ana Ya tsue to tsuri, “E sei pas to tsumi na sikia ma kat kat aveto ee ma nom ya na vaamuan nana fats a touruei to na moun to.” ");
INSERT INTO sps_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ana Ya fakokop fatabin pis to sa kirkir tan puputaa. ");
INSERT INTO sps_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Te nongoiny ari na ka to ana ri na fokinai fabuubus osing Towa, a fo isisen tsuri fabuubus fi naa ri, rin fuainy tsunaun mumua naa. Ai Jisas kaa en na aya, ana moun tsutsun en. ");
INSERT INTO sps_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ya paroor to sa tsue tsunia na moun, “Fei te naa fi ri ei? Te kaa kan minon ta mes ma pokei manyi ma mat?” ");
INSERT INTO sps_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“A sikia ta mes, Tsunaun,” biny finy Ya na moun to. “Jio, Anyo kan gim rou ma tsue pokei manyi ma mat. Kua, nyi te kat pis vaare tu mes tu aveto,” te tsue fi Jisas. ");
INSERT INTO sps_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas vegiau pis to tsuri, “Anyo na arasan tana monaagits to. E sei na mes te vovou Varonyo ee nai kaa non tana toto te kaa non a arasan ana ya te gima taan koman a uurup.” ");
INSERT INTO sps_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Taa Farasi tsue to Tsunia, “Anyi pokei iny rom a Tsivom, foka te vegiau iny rom Anyi, a sikia ta mes te faarof iny non ya a faarei ton vegiau man.” ");
INSERT INTO sps_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisas biny ratuari sa tsue na ka, “A sikia, kainon to te pokei finy Ronyo na Tsivou, foka te vegiau iny Ronyon man, tana saa Anyo natiny rou a pan te poo Minyo ana pan te naa Ronyo. Ami gim rom ma natiny a pan te poo Minyo ge ami gim rom ma natiny a pan te naa Ronyo. ");
INSERT INTO sps_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ami te faaroiny rom a mes tan vovovou iny fakats tana mes babainy tsun. Anyo gim rou ma faaroiny ta mes. ");
INSERT INTO sps_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sai te kat Ronyon faaron, kat iny faaron Tsonyon toobing ovei, tana saa sikia ma Nyo Tsivou to, e Taman, to te jiats Vaminyo te kaa fiisen Vamironyo. ");
INSERT INTO sps_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Te kirkir en tan Faun tsumi to te tagaa iny matan fi ror a ina fuan ri te faarof faavot, a ka te vegiau iny rorin man. ");
INSERT INTO sps_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nyo pokei iny rou a Tsivou, ana Taman to te jiat Vaminyo, Ayei kan pokei Varonyo.” ");
INSERT INTO sps_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ri rangats Towa, “Fei te kaa non e Tamamanyi ei?” Jisas biny ratuari, “Ami gim rom ma nat Vanyo ge Tamanyo kan. To te nat Varonyo mi, mi tabuiny nat kan iny e Tamanyo.” ");
INSERT INTO sps_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas tsue iny a foka te fafaatsuts Ya tana saape gagon tana pan te kaa ror fo guuv iny fafakaa moni. Sana sikia ta mes ma nots Ya, tana saa u nainy Tsunia te mataanis minon. ");
INSERT INTO sps_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas tsue pis to na ka tsuri, “Nyo naa evarou ana mi te nai sainy Vanyo, mi nai matem marom tana fo aveto tsumi. Mi gim rom ma naa tana pan te naa Ronyo.” ");
INSERT INTO sps_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","An fuainy tsoiny mumua tana taa Jiu favevegiau patsukan rato fapoopoan narari ri tsue to na ka, “Ayei te tsue, ‘Mi gim rom a naa tana pan te naa Ronyo.’ A saa bus to ayei na, Ayei te pon non ma nai atsuiny famat a Tsivon?” ");
INSERT INTO sps_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisas biny ratuari sa tsue, “Ami te poo tsun me nei petoo, sana Nyo te poo fi me Gormirmir. Amin fasito tana monaagits tovei, sana Nyo na gima fasito tana monaagits to. ");
INSERT INTO sps_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tan kat to aya sa Nyo tsue of bus mami, mi nai matem marom tana fo aveto tsumi. To te gim fi rom mi ma faaman Vanyo, Anyo na Ayei mi nai mat emarom tan fo aveto tsumi.” ");
INSERT INTO sps_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ri rangats Towa, “Anyi pas e sei?” Jisas biny ratuari, “Anyo tsue of bus mami muan tanik me tan tatanik. ");
INSERT INTO sps_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Anyo kaa miroun fo vegiau kinai iny tsue of mami tan faaroiny mami sana Nyo sikia rou ma kat fi nei Nyo tsue of rou a monaagits to tana ka te nongoiny Anyo Tsunia to te jiats Vaminyo ana Ayei na man ovei.” ");
INSERT INTO sps_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ari sikia ma arasan iny a ka to Tsunia te vegiau tsuk iny e Taman te kaa non Gormirmir. ");
INSERT INTO sps_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ai Jisas tsue to tsuri, “Te fapaas finy romi na Guei Tsoiny te Bobot e Gov sa ruak iny Mes me tana pagafuan mi nai natiny rom ka to, ‘Anyo na Ayei’, ana mi te nat fi nei Anyo gim rou ma kat babainy ta ka tan koman tsun Tsonyo, a sikia, sana Nyo tsue tsun iny rou a ka te faatsuts Vanyo Tamanyo. ");
INSERT INTO sps_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ana Ayei to te jiats Vaminyo i tovei te kaa fiisen Vamironyo, Ayei gim non ma naus osing babainy on Vanyo, tana saa Anyo kat rou a foka te kat fapaparei non Ya.” ");
INSERT INTO sps_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ana fokinai tsuri faamainy to Jisas te nongoiny fi ri Ya te vegiau tsuk iny Ya na foka to. ");
INSERT INTO sps_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ai Jisas tsue to tana taa Jiu to te faamainy Ya, “To te manaats finy romin fafaatsuts Tsonyo, mi faarei famainy rom matisian Tsonyo, ");
INSERT INTO sps_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ana mi te nai natiny a man ana man to ayei nai puruur maromi tana parits tan aveto.” ");
INSERT INTO sps_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ri biny to Jisas, “Amam tsubnaainy ten Abraham fatoobing ana mam sikia ma tsoiny gog tan ta mes. A saa te tsue rom Anyi na Ami te nai tapuruur marom?” ");
INSERT INTO sps_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisas tsue to tsuri, “Nyo tsue faman of maromi, e sei tsumi na katkat aveto ee, ayei te faarei non a tsoiny gog tan kat aveto. ");
INSERT INTO sps_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ana tsoiny gog sikia non ma kaa fiisen ramen mumuiny taman to tana numaa tan mamatsiny nainy sana guei tsoiny ayei te faarei non a isen tsuri koman mumuiny taman to tana numaa na sikia ta fafakap nan. ");
INSERT INTO sps_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Te puruur maromi na Guei Tsoiny tana parits tan aveto, mi nai tapuruur faman ovei marom. ");
INSERT INTO sps_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nyo nat you amin tsubnaainy ten Abraham fatoobing. Sana mi pon iny rom ma atsuiny famat Vanyo, tana saa ami te tsugei rom fafaatsuts Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nyo vegiau tsuk iny rou a ka te faatok bus Vanyo, Tamanyo sana mi kat rom a ka ten tamamami te tsue of bus mami ya.” ");
INSERT INTO sps_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ri biny Towa, “E tamamamam e Abraham.” Jisas tsue to tsuri, “To ma guei ten Abraham fatoobing ami mi tabuiny kat a fo binun te katkat ya muan. ");
INSERT INTO sps_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","A fo mamatsiny ka te katkat Anyo to, Nyo tsue of bus mami na man te nongoiny Minyo ten Gov. Ana mi kes korei marom ma atsuiny famat Vanyo. E Abraham gima katkat kat to aya! ");
INSERT INTO sps_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ami katkat rom kat te kat non e tamamami.” Ri biny Towa ser tsue na ka, “Mam gima guei ratsuu! E Gov, Ayei tsun Tsivon a Tamamamam.” ");
INSERT INTO sps_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisas tsue to tsuri, “To ma tamamami koraa Ya Gov, mi tabuiny mangiir Vanyo, tana saa Anyo poo fi me ten Gov sin tovei, Anyo to Anyo gima naa me Tsivou, a sikia, Ayei tsun to te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kat fei sam gim rom ma nat faarof iny a ka te tsue iny Ronyo ei? Tana saa, amin fanaginy nongon tan vaanan Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amin guei ten Vinasaar a tamamami, ana mi komainy vovou iny rom koman tsunia. Tanik me tan tatanik, ayei na tsoiny fitokon. Ana ayei sikia ma kaa tan panaan tana man, tana saa a sikia ta man te kaa non tsunia. Te tsue iny non yan gam, ayei te faarei tsuiny non kat tsunia, tana saa ayei na gamgam ana ayei te fataman iny non a fo mamatsiny gam. ");
INSERT INTO sps_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Sana Nyo tsue iny rou a man, ana kifon ya to tsumi gim rom ma faaman Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","E sei tsumi to te onot non ma pokei iny man nan aveto Tsonyo tan saf a fo aveto te katkat Anyo na? San tsue Tsonyon man, kat pas fei sam gim ma faamainy Vanyo ei? ");
INSERT INTO sps_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","E sei na mes to ayei, Gov te fasito iny non ya ee, ayei te nongoiny non vegiau Tsunia, ana kifon ya to tsumi gim rom ma nongoiny ya, amin gim ma fasito ten Gov.” ");
INSERT INTO sps_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","An fuainy tsoiny mumua tana taa Jiu biny Towa, “Mam tsue iny rom a man te tsue fi romam, Anyi na tsoiny sagoor ana masarau tutuei bus Manyi.” ");
INSERT INTO sps_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisas tsue to, “Anyo na sikia ma tutuei iny masarau, Anyo te fatsiitsii rou e Tamanyo, sana mi tsue vaabos Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Anyo gim rou ma sainy vavis a fatsiitsii to kainy fapaas a Tsivou, a sikia, kaa minon a isen a mes te komainy fapaas non a asanga Vanyo, ana Ayei na Tsoiny Vaatsuk. ");
INSERT INTO sps_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nyo tsue faman of maromi, e sei te manaats non Vegiau Tsonyo ee gim non ma nai mat on nats.” ");
INSERT INTO sps_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","An fuainy tsoiny mumua tana taa Jiu tsue to Tsunia, “Mam natem marom Anyi na tutuei iny masarau koma Manyi! Abraham te maten ana rin fuainy kuigin kan te mater, ana Nyi tsue fi kan e marom to, ‘E sei te manaats non vegiau Tsonyo ee te gim non ma nai mat on nats.’ ");
INSERT INTO sps_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","E tsuvurara Abraham te maten, ana Nyi pon rom ma karap fafis iny Ya ge? An fuainy kuigin kan te mater. Anyi pon rom Anyi sei?” ");
INSERT INTO sps_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisas biny ratuari sa tsue na ka, “To te fatsiitsii Ronyo na Tsivou, fatsiitsii Tsonyon kaa babainy. Ayei te fatsiitsii Varonyo to, e Tamanyo, Ayei na isen tsun Tsivon te tsue romi na Gov tsumi. ");
INSERT INTO sps_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ami gim rom ma natiny Ya sana Nyo nat faarof iny rou Ya. Te tsue fi Ronyo nei Anyo fapinpin iny rou Ya, Anyo na gamgam faarei maromi. Sana Nyo nat faarof iny rou Ya, ana Nyo manaats rou vegiau Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","E tsuvumami Abraham paparaa fiisok tan fakats ma tagei yan nainy Tsonyo ana Ya tagei ton nainy Tsonyo, ya paparaa mi towa.” ");
INSERT INTO sps_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","An fuainy tsoiny mumua tana taa Jiu tsue to Tsunia, “Anyi tabuiny ngim safunuu na ingainy rom ma tagei Anyi Abraham?” ");
INSERT INTO sps_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisas biny ratuari sa tsue, “Nyo tsue faman of maromi, tabuiny agiir non e Abraham, Nyo kaa bus you.” ");
INSERT INTO sps_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ri nom ton fats ser pon ma totouruei Ya Jisas, sen Jisas famuiny a Tsivon sa naus osing a saape. ");
INSERT INTO sps_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Te tataan naa Jisas Ya tagei to na mes te agiir, a mata kio. ");
INSERT INTO sps_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Matisian Tsunia rangats Towa, “Tsoiny Fifaatsuts, u aveto tsuan ne to aya te kat fiiring ya to sa agiir me na matan a kio ee? U aveto tsunia ge ten tsinan ya me taman ya?” ");
INSERT INTO sps_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisas biny ratuari sa tsue na ka, “U mata kio tovein sikia ma aveto tsunia ge ten taman ya me tsinan ya. Kainy kio tsunia to, te faruak nats non a parits ge na binun ten Gov ma tagei nats a fokinai tana ka te ruak tsunia. ");
INSERT INTO sps_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Te arasan farokot non a nuaf, ara ma kat a binun ten Gov to te jiats Vaminyo, ana uurup kat iny voiny osto, sikia ta mes te binun on non. ");
INSERT INTO sps_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nainy te kaa farokot ronyo tana monaagits to, Anyo na arasan tana monaagits.” ");
INSERT INTO sps_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Te vegiau fakap bus iny Ya na ka to, ai Jisas kisuf of to na painy puputaa sa kopis a painy puputaa fiisen men kisuf sa faarein medok ana Ya aatsits towa na matan a mes, ");
INSERT INTO sps_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ana Ya tsue to tsunia, “Kuar garus a matam tana Naaman iny Siloam.” (Kifon asangan tovei, “Jiats.”) Ana mes naa bus nato, sa garus a matan, ana ya tabin mito numaa tsuan fiisen me na matan a takarat ana matoong. ");
INSERT INTO sps_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Fuainy fifakokoro tsunia ana ri kan to te tagei ya, to te sing famamataaf fi non ya ta ka rangat to ser tsue, “Ayei koraa ya na mes a mata kio to ayei to te vavaagum non ana ya te sing famamataaf ta ka?” ");
INSERT INTO sps_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mesapan tsuri tsue to, “Ayei koraa.” Ana mesapan tsue to, “A sikia, a mes to te mamatan faarei non ya.” Sana ayei tsue na ka, “Anyo fatoobing a mes to.” ");
INSERT INTO sps_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Kat fei sana matam anyi takarat ei?” rangats fi ri ya. ");
INSERT INTO sps_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ya biny ratuari sa tsue, “A mes te koo ri Jisas te kopis vavis medok, sa aatsits ya na mata vanyo, ana Ya tsue of vatuanyo ma naa fi tana Naaman iny Siloam nyo te garus a matau. Ana nyo naa bus vato te garus anyo na matau, nyo matoong bus vato.” ");
INSERT INTO sps_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Fei te kaa non Ya ei?” rangats finy ari ya. Ya biny ratuari sa tsue na ka, “Anyo sikia rou ma nat.” ");
INSERT INTO sps_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ana ri mei naa to na mes a mata kio iny muan to tana taa Farasi. ");
INSERT INTO sps_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","U nainy to te kopis e Jisas medok ana Ya karats to na matan a mes to aya, u Nainy Fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Taa Farasi rangats pis to na mes to, “Fei te takarat fi na mata manyi ei?” Ya tsue to tsuri, “Ayei te aatsits a mata vanyon medok nyo garus to na matau, tovei roman nyo matoong rou.” ");
INSERT INTO sps_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ana mesapan tsuri na taa Farasi tsue to na ka, “A mes to te kat a ka to te gima poo fi me ten Gov tana saa, Ayei gima makok Faun tan Nainy Fafaatouf.” Mesapan tsuri tsue to na ka, “A mes a aveto te gim non ma onot ma kat a fo binun iny faatok reits te kat non ya.” Ana ri takibaa to fapoopoan narari. ");
INSERT INTO sps_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ana taa Farasi rangats fapaas pis to na mes a mata kio to iny muan, “Anyi te tsue Ayei te karats a mata manyi, jio, a saa te tsue rom anyi Tsunia na?” Ya biny ratuari sa tsue na ka, “Ayei na kuigin.” ");
INSERT INTO sps_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Rin fuainy tsoiny mumua tana taa Jiu gim to ma faamainy ya to te kio fi ya, ai tovei te onot fi non ya tan matoong onot te fikoo finy ari tsinan ya me taman ya. ");
INSERT INTO sps_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ser rangats rari, “A guei tsoiny tsumi to ayei? Ami te tsue na ka, ayei te agiir a mata kio, kat fei sana ayei onot ma matoong en to roman ei?” ");
INSERT INTO sps_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tsinan ya me taman ya biny ratuari ser tsue, “Amam natem marom ayei na guei tsoiny tsumam ana mam natiny towa ayei te agiir fiisen me na matan a kio fi kanen. ");
INSERT INTO sps_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sana mam sikia rom ma nat fei te matoong fi ya ei roman ge e sei te karats a matan ya ee. Rangats yam, ayei te mes tsian en ana ayei onot non ma pokei iny a tsivon tana saf a ka te ruak en tsunia na.” ");
INSERT INTO sps_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Taman ya me tsinan ya tsue faruak iny vegiau to, tana saa, ari te oraav ir fuainy tsoiny mumua tana taa Jiu te faarof iny vegiau to, e sei na mes te tsue pokei iny non e Jisas, “Ayei na Krais, a Tsoiny Fiisaup tana vainy ee,” ma nai kaa en jiarasan tana numaa iny fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","To aya na kifon a ka sen tsinan ya me taman ya tsue na ka, “Ayei te karap faonot en, rangats sanyi yam!” ");
INSERT INTO sps_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ri fafuan iny fikoo fatabiny to na mes te agiir me na matan a kio, ri tsue to na ka tsunia, “Nyi ma tsue iny man matan e Gov tan pokei iny a man! Amam natem marom e Jisas Ayei na mes a aveto.” ");
INSERT INTO sps_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ya biny ratuari sa tsue na ka, “Nyo gim rou ma nat Tsunia na mes a aveto ge na sikia. A isen tsun a ka te natiny ronyo to a mata vanyo na kio muan, sin tovei nyo matoong os to.” ");
INSERT INTO sps_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ri rangats towa, “A saa te kat Ya tsumanyi na? Fei te karats fi Ya na mata manyi ei?” ");
INSERT INTO sps_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ya biny ratuari sa tsue na ka, “Nyo tsue of bus mami ai mi gim to ma nongon. Kat fei sam komainy nongon fatabin pis rom ei? Ami toroman kan te komainy rom ma faarei fuainy matisian Tsunia, ge?” ");
INSERT INTO sps_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ana taa Farasi sewaar iny towa ser tsue vasuar iny ya, “Anyi na matisian tana mes tuwa e Jisas, to sa nyi vovou iny rom vegiau te pokei iny Ya sana mam matisian ten Moses to mam vovou patsukan iny rom vegiau te pokei iny e Moses. ");
INSERT INTO sps_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amam te natem Gov vegiau ten Moses ai to tana mes tuwa Jisas, mam gim rom ma natiny a pan te poo ising fi mi Ya!” ");
INSERT INTO sps_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ana mes to ayei biny ratuari sa tsue, “Saf tsue gengen tsumi to aya nan na! Ami gim rom ma natiny a pan te poo fi me naa mes to aya, sana Ayei karats a mata vanyo! ");
INSERT INTO sps_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mam natem marom Gov gim non ma nongon ir vainy aveto, Ayei nongoiny tsuiny non a vainy te faatouf ror Ya ana ri te kat mangiir Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","A sikia ta isen ma nongoiny vaarik ta mes ma karats a matan tan ta isen ta mes te agiir fiisen me na matan a kio. ");
INSERT INTO sps_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","To ma gima poo fi me Jisas unya jias ten Gov, Ayei kan gim non ma kat ta ka.” ");
INSERT INTO sps_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tan kat to ayei ri biny towa ser tsue, “Anyi te agiir fiisen men aveto ana nyi pon rom ma fafaatsuts mamam?” Ana ri gargar naa towa jiarasan tana numaa iny fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas nongon te gargar fi naa ri na mes a mata kio iny muan to jiarasan tana numaa iny fafaatouf, Ya sab towa sa tsue na ka tsunia, “Anyi faamainy kainy rom a Guei Tsoiny te Bobot e Gov sa ruak iny Mes me ge na sikia?” ");
INSERT INTO sps_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ana mes to biny Towa, “Mes tsian, tsue of you e sei to aya, ma faamainy anyo Ya.” ");
INSERT INTO sps_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisas tsue to tsunia, “Anyi tagei bus Ya ana Ayei koraa na mes to aya to te vegiau fiisen marom anyi to roman.” ");
INSERT INTO sps_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Nyo faaman you Tsunaun,” te tsue fi na mes to ana Ya fatukun to matan e Jisas. ");
INSERT INTO sps_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisas tsue to na ka, “Nyo naa me tana monaagits to ma faaroiny Anyo ri na vainy tana faaman tsuri iton matar a kio aave rari nai matoong ror ai tsuri to te pon ror matoong ri kaa iny kio ror aave rari.” ");
INSERT INTO sps_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Rin mes panainy Farasi to te kaakaa fiisen mi Ya nongon te tsue fi Ya na ka to ser rangats Ya, “Fiisia, Anyi te os kan mamam a fo matar a kio?” ");
INSERT INTO sps_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisas biny ratuari sa tsue na ka, “To te kio faman fi romi mi tabuiny sikia ma kaa me ta fasaraa tan aveto sana mi te tsue na ka, ‘Amam matoong rom.’ ai tan kat to aya, aveto kotskots faavots mami.” ");
INSERT INTO sps_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Nyo tsue faman of maromi a mes te gim non ma sof ising naa tan matainy sobaa nana aunon tan siip sana ayei paas ising tsun naa non tana mes a sanaan kanen sa faarei non a kakabuts ana mes a fafauraav mes ana kakarainy sei ka. ");
INSERT INTO sps_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mes te ising naa non tan matainy sobaa ayei na tsoiny veis tan siip. ");
INSERT INTO sps_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A tsoiny bei ot tan matainy sobaa pue of non a tsoiny veis ana ya te fikoon fuainy siip tana fo isiseiny asanga rari fatoobing, ri nongoiny ror ya ana ayei te fatafuts rari. ");
INSERT INTO sps_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Te fatafuts fi rarorin siip ya te mumua ra naa ri an siip te vovou iny ya, tana saa ari te nongoiny fanatnat iny rora nguen ya. ");
INSERT INTO sps_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ri gim ror ma vovou iny a mesmes a mes kanen, tan kat to aya ri bus osing ror a mes fuainy to, tana saa ri fanaginy nongoiny fanatnat iny ror a ngue na mesmes a mes to.” ");
INSERT INTO sps_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas te tsue of rarin tsue fapapaar to sana ri gima natiny a kifon a ka te tsue iny Ya tsuri. ");
INSERT INTO sps_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ai Jisas tsue pis to na ka, “Nyo tsue faman of maromi, Anyon matainy sobaa tan siip. ");
INSERT INTO sps_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mesapan tsuri to te mumua i Vaminyo arin kakabuts an fafauraav mes an kakarainy sei ka san fuainy siip gim to ma nongoiny rari. ");
INSERT INTO sps_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anyon matainy sobaa. E sei te pon non ma naa fi me Tsonyo ee nai saup fatabiny Ronyo ayei naa minon ana ya te tafuts a nai sab to na kainy ainy tan aaven. ");
INSERT INTO sps_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mes a kakabuts naa minon ma nai kabuts mi ya, ya te atsuiny famat ir a mesapan ana ayei te rurei vavis a foka. Nyo naa me ma kaa me na vainy a toto ana toto to ayei te via tsitapuu minon a fo mamatsiny kan karap fiisok. ");
INSERT INTO sps_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Anyon a tsoiny veis a rof tan siip. Ana tsoiny veis a rof to aya kakoun non ma mat of ir siip. ");
INSERT INTO sps_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A tsoiny binun nononom foiny ito ayei na sikia ma tsoiny veis tan siip ayei kan sikia non ma fasito ir fuainy siip, ayei naus osing raror fuainy siip ya te bus osing rari te tagei fi non ya na kas a vouts te kuar fi minon ya, ana kas a vouts to te nots a siip an fuainy siip te bus vavis er, ri te saats vavis a pan. ");
INSERT INTO sps_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A tsoiny binun a nononom foiny bus vavis non tana saa, ayei na tsoiny binun a nononom foiny tsun, ana Ya te gima ningainy ir fuainy siip. ");
INSERT INTO sps_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Anyon a tsoiny veis a rof tan siip. E Tamanyo nat Varonyo ana Nyo natiny rou Ya jesan kan Nyo natiny roun fuainy siip Tsonyo ana ri nat Varonyo. Ana Nyo kakoun rou ma mat of ir siip. ");
INSERT INTO sps_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Te kaa miror mes panar siip Tsonyo te gim ror ma kaa koman a aunon to. Nyo ma mei kan ramiri ri te nai nongoiny men vegiau Tsonyo ana ri te nai faarei me na isen a aunon veis nar siip te kaa miror a isen a tsoiny veis. ");
INSERT INTO sps_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tamanyo mangiir Varonyo tana saa, Anyo orovus rou ma mat, tan kat to aya, Nyo nai toto fatabin e varou. ");
INSERT INTO sps_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sikia ta isen te onot non ma pets a toto Tsonyo. Nyo pets rou ya tan koman tsun Tsonyo. Ana Nyo faarof rou ma fa'orovus iny ya ana Nyo te faarof tan nom fatabiny pis ya. E Tamanyo te tsue faparits of bus Vanyo ma kat ya.” ");
INSERT INTO sps_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ana taa Jiu takibaa pis rato fapoopoan narari tana saa, tana fo mar vegiau to. ");
INSERT INTO sps_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ana mesapan tsuri tsue to na ka, “Ayei na tutuei iny masarau! Ana Ayei na piou! Kat fei sam nongoiny rom Ya ei?” ");
INSERT INTO sps_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sana mesapan tsuri tsue na ka, “A mes a tutuei iny masarau gim non ma onot ma vegiau fi to ayei! Tabuiny tutua iny masarau a mes to aya, ayei tabuiny gima onot ma karats matar vainy kio teeva?” ");
INSERT INTO sps_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tan nainy Guainy tan fakats fatabin tan Tsue Faarof of a Saape tana ngats fan tsian iny Jerusalem, u nainy to aya u nainy tana tonok. ");
INSERT INTO sps_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas taataan en, tana saparoon tana saape te koo ri na Saparoon Ten Solomon, ");
INSERT INTO sps_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","an fuainy tsoiny mumua tana taa Jiu bau faafis Towa ser tsue na ka, “Fiisia, kat fei sa Nyi gum iny tomani ovei em ei, to sanyi gima biny a fo rangat? Tsue fa'arasan of mamimam, Anyi koraa na Krais a Mes to te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy ge na sikia?” ");
INSERT INTO sps_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisas biny ratuari sa tsue na ka, “Nyo tsue of bus mami sana mi gima faaman Vanyo. Fo binun te kat Ronyo tana asangan e Tamanyo te pokei faruak Varonyo, ");
INSERT INTO sps_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","sana mi gim ma faaman tana saa amin sikia ma siip Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Fuainy siip Tsonyo nongoiny ror fikoo Tsonyo Nyo te nat irari ana ri te vovou Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nyo faan rarori na toto na suu ana ri te gima nai nom on a mat a suu ana sikia ta isen ta mes te onot ma pets osing Vanyo ri. ");
INSERT INTO sps_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","E Tamanyo to te faan Vanyo ri Ayei kan te karap faafis pis iny non a fo mamatsiny ka ana sikia ta isen ta mes te onot ma pets osing e Tamanyo ri. ");
INSERT INTO sps_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Anyo ai Tamanyo mam a ina fuan, isen tsun.” ");
INSERT INTO sps_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","An tsoiny mumua tana taa Jiu nom pis ton fats ma totouruei ari Ya. ");
INSERT INTO sps_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ai Jisas tsue to tsuri, “Nyo faatok bus mami na fo binun iny faatok reits to te poo fi me ten Tamanyo. A saf ta isen ta ka iny faatok ei na to sami pon rom ma totouruei Vanyon fats?” ");
INSERT INTO sps_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","An tsoiny mumua tana taa Jiu biny fatabiny Towa ser tsue, “Mam gim rom ma totouruei Manyin fats tan ta foka to san tan tsue vaaserere tsun ten Gov tana saa, Anyi na mes babainy tsun ana Nyi koo rom a Tsivom e Gov.” ");
INSERT INTO sps_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisas biny ratuari sa tsue, “Te kirkir en tan Faun tsumi to te tsue fi Gov tsuri te fainy Yan vegiau Tsunia, ‘Amin fo gov.’ ");
INSERT INTO sps_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Saf kirkir tan Vegiau Ten Gov te gim on non ma pangis na. Gov koo rarin, ‘fo gov’, kat pas fi non ya to Tsonyo ei? ");
INSERT INTO sps_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","E Tamanyo te pets Vanyo ana Ya jiats vamituanyo tana monaagits tovei kat pas fei sam tsue fi rom nei Anyo te tsue vaaserere iny e Gov ei, tana saa Anyo te tsue na ka, Anyo na Guei Tsoiny ten Gov? ");
INSERT INTO sps_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Faamainy sanyi vaare Vanyo yam, te gim fi Ronyo ma kat a fo binun iny faatok ten Tamanyo. ");
INSERT INTO sps_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sai te kat Ronyo na fo binun iny faatok to, kainon te gim fi romi ma faamainy Vanyo, ami ma faamainy tsuiny a fo binun iny faatok to ma nat faarof ami na fokinai e Tamanyo te kaa non koma Vanyo ana Nyo kaa rou koman e Tamanyo.” ");
INSERT INTO sps_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ri pon pis to ma nots Ya sana Ayei aruwas osing a nima rari. ");
INSERT INTO sps_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ai Jisas tabin fatabin enato sa ngats nana aurom iny Jodan tana pan te fapeenainy e Jon a vainy sana Ayei kaa en na aya. ");
INSERT INTO sps_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ana vainy a kinai naa mito Tsunia. Ri tsue to na ka, “Jon gima kat a fo binun iny faatok reits sana fo vegiau te pokei tsuk iny ya tana mes to Jisas, u man ovei.” ");
INSERT INTO sps_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ana vainy a kinai te kaakaa na aya faamainy Towa. ");
INSERT INTO sps_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A mes te koo ri Lasarus a soon iny faadis. Ayei te kaakaa tana ngats fan iny Betani. Betani na ngats fan te kaakaa kan ror ere Meri me Mata u mumuinyasiny moun. ");
INSERT INTO sps_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(E Meri to te tsiiu iny a tapui na tauf tsuraf moun a Tsunaun ana ya sap fatabiny towa na funuu nan ai Lasarus a fafinen ya to na soon iny faadis.) ");
INSERT INTO sps_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Rin mumuinyasiny moun to faan iny naa ton vegiau ten Jisas, “Tsunaun, a mes te mangiir rom Anyi na soon iny faadis.” ");
INSERT INTO sps_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Te nongoiny e Jisas vaanan to Ya tsue to na ka, “A faadis to te gim non ma nai faruak a mat. A sikia, ayei te pokei nats non siinaiv ten Gov tan kat to aya, Guei Tsoiny ten Gov nai kaa kan minon a fo siinaiv tan kat a ka to.” ");
INSERT INTO sps_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas mangiir fiisok e Mata me famuinyasiny tsuan, ai Lasarus. ");
INSERT INTO sps_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Te nongoiny Yan vaanan nane Lasarus a soon iny faadis ana Ya kaa enato na aya onots fuan nainy. ");
INSERT INTO sps_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Voun fafuan nan nainy ana Ya tsue to tan matisian Tsunia, “Tanats yam ma tabin fatabin naa ra tana gum fan iny Judia.” ");
INSERT INTO sps_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ana rin matisian Tsunia tsue to na ka, “Tsoiny Fifaatsuts sikia ma naangis vaarik te pon ma totouruei Manyi ri tsoiny mumua tana taa Jiun fats, ana Nyi pon rom ma tabin fatabin pis ma naa unya aya?” ");
INSERT INTO sps_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas biny ratuari sa tsue, “Tan sen nainy te kaa minon a safunuu ana fuan a aua tana arasan teeva? To te taan non a mes tana arasan ayei gim non ma tsukakab on, tana saa ayei tagei non a arasan tana monaagits to. ");
INSERT INTO sps_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sai te taan non ya tana uurup ayei tsukakab non tana saa, a sikia ta arasan tsunia.” ");
INSERT INTO sps_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ai Jisas farong pis ton vegiau Ya tsue to na ka, “A vaatau tsura Lasarus te goros tsun non sana Nyo naa rou Nyo te nai guinyguiny ya.” ");
INSERT INTO sps_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","An matisian biny Towa ri tsue to na ka, “Tsunaun to te goros fi non ya, ayei nai rof fatabin enanon.” ");
INSERT INTO sps_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","San kifon vegiau te kat e Jisas to Lasarus a mat, ana ri pon to Jisas te tsue iny e Lasarus soon iny goros tsun non. ");
INSERT INTO sps_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ai Jisas tsue faarof of ratuari, “Lasarus a mat, ");
INSERT INTO sps_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","sai to tsumi Nyo paparaa rou tsonyo gima kaa fiisen mi ya te mat ya unya aya tana saa, mi nai tagei rom a ka te nai kat Ronyo ana mi te faaman. Tanats yam ma naa ra tsunia.” ");
INSERT INTO sps_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas to te koo rin Punaa tsue to tan mes panainy matisian, “Tanats yam ma naa fiisen mi raa na tsoiny fifaatsuts to ma nai mat fiisen mi raa Ya!” ");
INSERT INTO sps_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Te ruak naa Jisas, Ya natiny to Lasarus te soon en tana kats sa onots fats nainy. ");
INSERT INTO sps_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani te siruu non Jerusalem faarei non a fopis a kilomita, ");
INSERT INTO sps_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ana taa Jiu na kinai naa mito a tou tagei e Mata me Meri, er kat famaun ton fakats tsuri tana mat ten fafinerari. ");
INSERT INTO sps_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Te nongoiny e Mata na tou naa me ten Jisas, Ya naa enato a tou tainytainy Ya, ai Meri kaa en numaa. ");
INSERT INTO sps_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata tsue to ten Jisas, “Tsunaun, tabuiny kaa Nyi nei e fafinevanyo tabuiny gima mat! ");
INSERT INTO sps_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sana nyo nat rou te rangats fi rom Anyi Gov ta isen ta ka Tsunia Gov faan marom Anyi.” ");
INSERT INTO sps_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisas tsue to ten Mata, “E fafinemanyi nai tsun fatabin enanon tana mat.” ");
INSERT INTO sps_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Nyo nat you,” te biny fi ya Mata, “ayei nai tsun fatabin enanon tan nainy tana tou tsun fatabin tana mat tan fafakap nan nainy.” ");
INSERT INTO sps_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisas tsue to tsunia, “Anyo na kifon a tou tsun fatabin tana mat ana kifon a toto na suu. E sei te faaman non Tsonyo ee nai toto fatabin enanon kainon to te mat fi non ya, ");
INSERT INTO sps_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ai sei te toto non ee ana ya te faaman Vanyo gim non ma nai nom on a mat a suu. Nyi faamainy rom vegiau to?” ");
INSERT INTO sps_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Eye, Tsunaun,” te biny fi Ya Mata, “anyo faaman rou Tsumanyi na Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy a Guei Tsoiny ten Gov, a mes to te tsuen fo kuigin ma naa me tana monaagits to.” ");
INSERT INTO sps_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Te vegiau fakap bus iny e Matan vegiau to ya tabin fatabin naa to sa fikoo faamo tsuiny e Meri sa fasisiraa of tsuiny ya, “A Tsoiny Fifaatsuts tovei Ayei komainy tagei marom anyi.” ");
INSERT INTO sps_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te nongoiny e Merin vegiau to ya tsun to sa veesau tsun en a tou tainytainy e Jisas. ");
INSERT INTO sps_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jisas tabuiny ruak naa non fan Ayei kaa farokot enanon tana pan te tainytainy Ya Mata.) ");
INSERT INTO sps_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ana ri na taa Jiu to te kat kat famaun a koman e Meri ai to kan te kaakaa numaa tsunia vovou naa towa to te tagei finy ari ya te tsun fi ya ana ya veesau tsun enato. Ri pon iny e Meri te naa fi en tan kats a tou tangis na aya. ");
INSERT INTO sps_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Te ruak naa Meri tana pan te kaakaa Jisas ana ya tagei Towa, fatukun to moun Ya, ya tsue to Tsunia, “Tsunaun, tabuiny kaa Nyi nei e fafinevanyo tabuiny gima mat!” ");
INSERT INTO sps_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas tagei towa te tangis ana taa Jiu kan to te naa fiisen mi ya tangis kan rato, ana koma ne Jisas reesik kan enato sa tsuu en. ");
INSERT INTO sps_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ya rangat ratuari, “Fei te kats iny ami ya ei?” Ri biny Towa ser tsue, “Taame tagaa, Tsunaun.” ");
INSERT INTO sps_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas susuiny matan to. ");
INSERT INTO sps_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ana taa Jiu tsue to na ka, “Tagaa yam tana fis a tagtag te kaa minon Ya ten Lasarus!” ");
INSERT INTO sps_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sana mesapan tsuri tsue na ka, “Ayei te karats a matan na mes a mata kio ge? Sa kat pas fei sa gima kat tap iny a mat ten Lasarus ei?” ");
INSERT INTO sps_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","An reesik tsian paas pis to na koman Ya ana Ya dau enato ai Jisas naa fi enato tan katskats to te kats ari tana varian an matainy sobaa nan ya na kookop tap fiisen me na fats. ");
INSERT INTO sps_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Fakukuur ravainy yam a fats!” tsue fi Jisas. Mata ayei na fafinen e Lasarus biny Towa sa tsue na ka, “Tsunaun, kaa toromainy bus minon a tauf kuav, tana saa ayei te kaa tan kats sa onots fats nainy!” ");
INSERT INTO sps_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisas tsue to tsunia, “Fiisia, Anyo gima tsue of manyi ma tagei anyin siinaiv ten Gov to te faaman fi rom anyi?” ");
INSERT INTO sps_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ri fakukuur ravainy to na fats. Jisas matoong fi naa to jias ana Ya tsue to, “Nyo tsue faarof naa rou Tsumanyi Tamau, Tsumanyi te nongoiny Varonyo. ");
INSERT INTO sps_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nyo nat you Tsumanyi te natiny nongoiny fatatabin Varonyo sai te tsue iny Ronyo na ka to, tana saa to tana vainy a kinai tsun tovei ma nai faaman ari Tsumanyi to te jiat Vaminyo.” ");
INSERT INTO sps_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Te vegiau fakap bus iny Ya na ka to Ya fikoo fatsian to sa tsue na ka, “Lasarus! Tafuts me!” ");
INSERT INTO sps_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ana mes a mat tafuts mito, niman ya an moun ya na pau men raarav nan vainy mat tan kats ana painy raarav pau me na nain ya. “Puruur ravainy osing yam,” te tsue fi Jisas tsuri, “am fatsuruwa naa towa.” ");
INSERT INTO sps_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Taa Jiu na kinai to te naa me ten Meri te tagei a ka te kat e Jisas ri faamainy Towa. ");
INSERT INTO sps_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sana mesapan tsuri tabin ra naa to tana taa Farasi ri tsue of ratuari na ka te kat e Jisas. ");
INSERT INTO sps_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ana ri na taa Farasi an fuainy tsunaun tan tsoiny faakor fiisen ramirin fuainy tsoiny mumua tana taa Jiu vaaguam faavot to tan vaagum tan Kansol, ri tsue to na ka, “Saa te kat rora na? Tana saa a mes to, katkat a fo mamatsiny binun iny faatok reits to! ");
INSERT INTO sps_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","To te famanat iny rora Ya tan kat a foka to a fokinai te nai faason ror Tsunia an fuainy tsoiny mumua tana gamaman tana taa Roum te nai fasaraa rara ana ri te nai rurei me na saape taabos ana vainy faavot tsura fatoobing.” ");
INSERT INTO sps_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","A isen tsuri te kaa non a Tsoiny Mumua tan Tsoiny Faakor tana taa Jiu tana ingainy to aya, te koo ri Kaiafas tsue to na ka, “Amin piou, ami gim rom a natiny ta isen ta ka! ");
INSERT INTO sps_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ami ma natiny a ka to, te rof non tan ta isen ta mes ma mat of ir a fokinai, ge ra na taa Jiu faavot nai mat nats ror!” ");
INSERT INTO sps_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ayei gima pokei iny vegiau to tan mangiir tsun tsunia san tan gumgum tsunia faarei finy Ya na Tsoiny Mumua tan Tsoiny Faakor tana ingainy to aya ayei pokei faruak iny a mat nane Jisas ma mat of Ya na taa Jiu, ");
INSERT INTO sps_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Sikia ma tana taa Jiu tsivor san tana vainy ten Gov to te kaa vavis ror ma naa faavot mi ri er isen tsun mito. ");
INSERT INTO sps_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tanik tan ar nainy to aya rin fuainy tsoiny mumua tana taa Jiu kat ton vegiau iny sainy sanaan iny atsuiny famat e Jisas. ");
INSERT INTO sps_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tan kat to aya Jisas gim to ma taan vavis matar a vainy tana gum iny fan iny Judia sana Ayei naa fi enanaa tana pan te kaa non panan a pan a uur te koo ri na ngats fan iny Efraim, a fan to te kaa tsom en Ya fiisen ramen matisian Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Te sisiruu men nainy Guainy tana taa Jiu iny Fakats Fatabin ana vainy a kinai naus osing mito na fo fan tsuar ma naa fi naa ri Jerusalem, a tou kakouiny a tsivor ma fataabos ari na tsivor an nainy guainy mataanis ename. ");
INSERT INTO sps_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ri sainy vavis e Jisas ai tan nainy te vaaguam naa ri tana saape, ri fararangat patsukan rato fapoopoan narari, “Saf fakats tsumi na? Ayei naa kan minon tan nainy guainy ge na sikia?” ");
INSERT INTO sps_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Rin fuainy tsunaun tan tsoiny faakor ana ri na taa Farasi faan iny ton tsuen parits ten sei na mes te tagei sab non a pan te kaa non e Jisas ee, ayei ma pokei faruak iny ya, ma nots ari Ya. ");
INSERT INTO sps_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Gonom nainy kaakaa non an Guainy iny Fakats Fatabin mataanis ename, Jisas naa fi to tana ngats fan iny Betani tana pan te kaakaa non e Lasarus, Lasarus ito na mes e Jisas te fatoto fatabiny ya. ");
INSERT INTO sps_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ri kakouiny of e Jisas a kainy ainy tana touraf na aya ai Mata akat en tana kainy ainy ai Lasarus gum en taran fiisen me Jisas. ");
INSERT INTO sps_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ai Meri nom to na isen lita tapui foiny nan ya na nai jias fiisok kat ari tan nau tauf tsuraf tobeer, ya tsiiu iny towa moun e Jisas ana ya sap fatabiny towa na funuu nan. An tauf nana tapui to na tsuraf tauf sa kookop faavots a numaa. ");
INSERT INTO sps_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ana isen tsurin matisian ten Jisas to te koo ri Judas Iskariot ito na mes te faan iny naa non e Jisas nimar vainy ma atsuiny famat ari Ya, tsue to na ka, ");
INSERT INTO sps_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kat fei sana tapui na tauf tsuraf to ma fafiifoiny ravaa a onots to na fopis a natus a moni silva ra faan ratuari yan vainy aaruts ei?” ");
INSERT INTO sps_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ayei te tsue iny a ka to tana saa ayei gima fakats ir vainy aaruts, ayei vakakai me na poraa moni sa ainy tsivoiny fo mes mar moni, tana saa ayei na kakabuts. ");
INSERT INTO sps_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Sen Jisas tsue na ka, “Tanyiny yam a moun to! Ayei te kakouiny onots a ka to onot non tan nainy kats Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ami onot rom ma kaa fiisen men vainy aaruts fapoopoan namami tan mamatsiny nainy sana Nyo gim rou ma nai kaa fiisen mamimi tan mamatsiny nainy.” ");
INSERT INTO sps_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","U taa Jiun kinai te nongon te kaa fi Jisas tana ngats fan iny Betani to ser naa fi ra naa unya aya, ri sikia ma naa of tsuiny naa Jisas unya aya, sana ri naa tou tagei e Lasarus, ito na mes te fatsuiny fatabiny e Jisas tana mat. ");
INSERT INTO sps_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ana rin fuainy tsunaun tan tsoiny faakor sainy to ta sanaan ma atsuiny kainy ari Lasarus, ");
INSERT INTO sps_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tana saa ito tsunia tsun, sana taa Jiu na kinai fabuubus osing ir fuainy tsoiny mumua tsuri ri faamainy to Jisas. ");
INSERT INTO sps_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Voun mes nainy ana vainy a kinai to te naa of men nainy Guainy iny Fakats Fatabin nongon te naa fi minon e Jisas tana ngats fan tsian iny Jerusalem. ");
INSERT INTO sps_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ana ri tek ton fo naainy Paura, ser naa a tou tainytainy Ya. Ri vaputs iny kuu ser tsue na ka, “Saup fatabin mamam yam! Gov faparits marom Anyi te naa mirom tana asangan a Tsunaun! Gov faparits non a Aatouf tana taa Isrel!” ");
INSERT INTO sps_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas nom a tsunei dongki ana Ya jias to tounon ya to te faarei fin vegiau tan Vegiau Ten Gov, ");
INSERT INTO sps_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Oraav vaare yam, amin vainy iny Jerusalem! Tagaa, a Aatouf tsumi te naa minon, Ayei fauf a tsivon ana Ayei gum minon tounon a guei tana dongki.” ");
INSERT INTO sps_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","An matisian Tsunia gim to ma nat faamuan iny a foka to, san tan nainy to te tsun fatabin fi Jisas sa naa fi tana pan tan fuainy siinaiv Tsuan Gormirmir, ri fakats fatabiny ton vegiau te pokei tsuk mi Ya tan Vegiau Ten Gov, ana foka to te kat ari ten Jisas te pokei faruak mi ri tan Vegiau Ten Gov. ");
INSERT INTO sps_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ana rin vainy to te kaa fiisen me Jisas tan nainy te fikoo fatafuts fi mi Ya Lasarus ana Ya fatoto fatabiny towa tana mat pokei to na ka te ruak. ");
INSERT INTO sps_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tan kat to aya ana rin vainy tainytainy Towa tana saa ari te nongoiny Ya te kat binun iny faatok reits. ");
INSERT INTO sps_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kat to ana taa Farasi tsue patsukan to fapoopoan narari, “Tagaa yam, ara te biu er tan kat tap iny a binun Tsunia, a vainy faavot tana monaagits to te vovou iny naa ror Ya!” ");
INSERT INTO sps_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mesapan tsuri na taa Grik te kaakaa fapoopoan nararin vainy to te naa fi naa tana ngats fan tsian iny Jerusalem a tou fafaatouf tan nainy Guainy iny Fakats Fatabin. ");
INSERT INTO sps_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ri naa me ten Filip a mes te poo fi me tana ngats fan iny Betsaida tana gum fan iny Galili, tsue to na ka, “Mes tsian mam komainy tagei rom e Jisas.” ");
INSERT INTO sps_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip naa sa tagei e Anduru ana ri na ina fuan naa to ser vegiau fiisen me Jisas. ");
INSERT INTO sps_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisas biny ratuari sa tsue na ka, “Ar nainy tana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me te sisiruu os mito ma vamarits e Gov a asangan Ya. ");
INSERT INTO sps_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nyo tsue faman of maromi te gim fi non fua nan wit ma reev naa tan puputaa ya te mat kaa faarei non isen tsun fua. Sai te mat non ya ayei nai fua faarei non fuan kinai, jesan kan Anyo ma mat ma kaa me na vainy a kinai a toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","E sei te mawats non a toto nan ee nai kajiaa babainy enanon ai sei te tsugei non a toto tsuan tan puputaa to ee nai makuts non a toto ito na toto na suu. ");
INSERT INTO sps_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","E sei te komainy binun of Varonyo ee, ma vovou Vanyo, tan kat to aya a tsoiny binun Tsonyo te nai kaakaa fiisen Vamironyo tana pan te kaakaa Ronyo. E Tamanyo te nai fatsiitsii non ya ito na mes te binun of Varonyo.” ");
INSERT INTO sps_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Tovei roman a koma Vanyo te onanun os to ana saa te tsue Ronyo na? To ma tsue fi Nyo nei, ‘Tamau, famanat iny vaare na ka to ma ruak ya Tsonyo?’ A sikia, ai tsun a ka te naa of Minyo, ma naa of Anyon nainy saraa kamits. ");
INSERT INTO sps_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamau, nom a asangam iny vamarits matar a fokinai!” An vegiau poo mito Gormirmir sa tsue, “Nyo vamarits bus a asanga Vanyo, ana Nyo nai kat pis nats rou ya.” ");
INSERT INTO sps_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ana vainy a kinai te tsutsun na aya nongoiny ton vegiau ri tsue to na ka, “U barak vaa!” Ana mesapan tsuri tsue to, “A morena vaa ei ya, to te vegiau non Tsunia!” ");
INSERT INTO sps_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sen Jisas tsue tan matisian Tsunia, “Sikia ma kaa iny faakouts Vanyo to san vegiau tapokaa me, a sikia, sai te tapokaa of mamimi kainy faakouts mami. ");
INSERT INTO sps_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tovei roman u nainy vaatsuk bus tana monaagits to ai tovei kan e Vinasaar, a tsoiny tatagaa ot tana monaagits to nai duem en naa non. ");
INSERT INTO sps_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nainy te fagageits Varonyo ri tana pagafuan Nyo nai ras faavots rarou a vainy ma naa mi ri Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ayei te tsue iny a ka to ma faatok iny Ya na saf a mat ei na te nai sarei non Ya. ");
INSERT INTO sps_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","An tagin biny Towa ser tsue na ka, “A Faun tsumam te kirkir iny e Moses te faatsuts fi mamam to, a Krais a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy nai toto ovei nanon. Kat pas fei sana Nyi tsue rom a ka to ei, tana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me nai gageits non tana pagafuan ei? E sei to aya na Guei Tsoiny te Bobot e Gov ee?” ");
INSERT INTO sps_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisas biny ratuari Ya tsue to na ka, “A arasan kaa non fapoopoan namami kaa tsun non tan fo ar nainy. Taan yam te kaa farokot minon ya na arasan ma kookop vaare mami na uurup tana saa e sei na mes te taan uruurup non ee gim non ma natiny a pan te naa non ya. ");
INSERT INTO sps_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Faaman yam tana arasan ito te kaa fi miromi ya, tan kat to aya mi faarei mirom vainy tana arasan.” Voun vegiau ten Jisas tana ka to Ya naa to sa fatakop a tsivon mata rari. ");
INSERT INTO sps_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kainon to te kat Ya na fo binun iny faatok reits mata rari, ri gim kainy to ma faamainy Ya, ");
INSERT INTO sps_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","tan kat to aya u vegiau te pokei iny e Aisaia na kuigin muan ruak iny man ovei nato, “Tsunaun, e sei te faamainy vegiau te tsue iny a mam ee? Ai to ten sei na mes to na Tsunaun te faatok Ya na parits Tsuan ee?” ");
INSERT INTO sps_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tan kat to aya ri gima onot ma faaman, tana saa e Aisaia te tsue kainy a ka, ");
INSERT INTO sps_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gov kat fakio na mata rari, ana Ya kat fanuuiny ton fakats tsuri ma tagaa on vaare ri an fakats tsuri nai nun ovei enanon, ‘ana ri te gima takopis on me Tsonyo ma tsipaar Anyo ri,’ te tsue fi me Gov.” ");
INSERT INTO sps_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia pokei iny a ka to, te ruak nats non tana fo siinaiv ten Jisas, tana saa ayei te inainy faamuainy bus ya. ");
INSERT INTO sps_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Man pas koraa non mesapan tsurin fuainy tsoiny mumua tana taa Jiu te pon ma faaman Tsunia san tan kat tana taa Farasi ri oraav to ma pokei faruak iny a faaman tsuri, tana saa a taa Farasi te jiats fatafuts rarori tana numaa iny fafaatouf tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ri komainy fiisok a vainy ma tsue iny paparaa rari fis pis non tsue iny paparaa te poo fi minon ten Gov. ");
INSERT INTO sps_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas tsue fatsian to, “E sei na mes te faamainy Varonyo ee, gim non ma faamainy tsuiny Vanyo, sai to Tsunia to te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ai sei na mes to te tagei Vanyo ee, faarei non te tagei kainy Ya to te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nyo naa me tana monaagits to faarei me na arasan, tan kat to aya ere sei te faaman ror Tsonyo ee, gim on ror ma kaa tana uurup. ");
INSERT INTO sps_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","E sei na mes te nongoiny non vurungan rof Tsonyo ee ana ayei te gim ma manaats ya, Nyo gim rou ma kat vaatsuk tsunia. Nyo naa me ma gima faarei Anyo na tsoiny vaatsuk tana vainy tana monaagits to, a sikia, Nyo naa me ma saup fatabiny Anyo rari. ");
INSERT INTO sps_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“E sei na mes te tsugei Varonyo ya te gima faarof vurungan rof Tsonyo ee naa fi naa non tan vaatsuk tana isen a ka, ito tan vegiau te pokei bus Anyo te nai kat non vaatsuk tsunia tan fafakap nan nainy! ");
INSERT INTO sps_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Man, tana saa Anyo gim rou ma pokei vegiau to tsivou, sai ten Tamanyo to te jiats Vaminyo Ayei te tsue faparits of Vanyo na fo mamatsiny ka ma vegiau iny Anyo. ");
INSERT INTO sps_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ana Nyo nat you tan tsuen parits Tsunia te kifon iny non a toto na suu. A saa te tsue iny Anyo na ayein vegiau to te tsue iny e Tamanyo, Nyo ma pokei.” ");
INSERT INTO sps_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tamanainy u nainy Guainy iny Fakats Fatabin ai tovei roman Jisas natiny ton nainy Tsunia te siruu ename te naus osing fi non Ya na monaagits to ana Ayei te naa fi en ten Taman. Ayei mangiir fiisok ir vainy fasito Tsunia fatoobing tana monaagits to ana Ya mangiir fiisok kainy ratuari onot tan fafakap nan nainy mat Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisas an matisian Tsunia gum iny ainy ror tan sewaan tana ananerof. Ai Vinasaar faan iny ton fakats tsuan ten Judas a guei tsoiny ten Saimon Iskariot ma faan iny naa ya Jisas nimar a vainy ma atsuiny famat ari Ya. ");
INSERT INTO sps_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas nat faamuainy e Taman te fainy Yan fo mamatsiny parits, Ya naten nato, Ayei te poo fi me ten Gov ana Ayei kan te naa fi naa non ten Gov. ");
INSERT INTO sps_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ai Jisas tsun osing to na taran fious ton vau Tsuan iny jiarasan ana Ya pous iny ton sapsap Tsuan. ");
INSERT INTO sps_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ana Ya tsiiu iny to na aurom koman a kepaa na faakok ana Ya tanik iny garus ton mour matisian Tsunia ana Ya sap faparak ratuari fiisen men sapsap te popous iny Ya, kat to te faarei non a binun tan tsoiny binun. ");
INSERT INTO sps_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ya naa mito ten Saimon Pita ai Saimon Pita tsue to na ka Tsunia, “Fiisia Anyi komainy garus kainy rom a mou vanyo ge Tsunaun?” ");
INSERT INTO sps_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisas biny towa sa tsue na ka, “Nyi gim rom ma natiny a ka te kat Ronyo tovei roman, sana nyi nai natem marom vou.” ");
INSERT INTO sps_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita baainy sa tsue na ka, “Anyi gim on rom ma garus oiny a mou vanyo!” “Te gim fi Ronyo ma garus a moum manyi, nyi gim rom ma tap fiisen Vaminyo,” biny finy ya Jisas. ");
INSERT INTO sps_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita biny Towa sa tsue na ka, “Tsunaun, garus tsuiny korei vaare na mou vanyo, garus me na nimau ana patsu vanyo kan!” ");
INSERT INTO sps_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisas tsue to, “E sei na mes te sisiuf ee te kaamos faavot ovei nanon ana ya te gima onot ma sisiuf pis a tsivon, sana ayei te onot non ma garus tsuiny a moun nainy te kookuaf non ya. A fokinai tsumi ton kaamos sana isen tsumi na sikia.” ");
INSERT INTO sps_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Jisas nat faamuan iny e sei te faan iny non Ya nimar vainy te nai atsuiny ror Ya, ka te tsue fi ya nei, “A fokinai tsumin kaamos, sana isen tsumi na sikia.”) ");
INSERT INTO sps_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Te garus fakap bus Ya na mou rari Jisas vau fatabiny pis ton vau iny jiarasan Tsunia ana Ya tabin fatabin enaa to tana pan Tsunia tana taran. “Fiisia, ami nat kan iny rom a ka te kat Anyo tsumi?” rangat fi Ya. ");
INSERT INTO sps_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Mi koo Vanyo na Tsoiny Tatagaa Ot ana Tsunaun te toobing non te tsue fi mi, tana saa Anyo tsun to. ");
INSERT INTO sps_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Anyo na Tsunaun tsumi ana Tsoiny Tatagaa Ot, ana Nyo te see garus tsuiny rou a fo mou mami. Jesan, ami kan ma fauf a tsivom am garus ton fo isiseiny mou tsumi. ");
INSERT INTO sps_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nyo faatok bus mamin kat Tsonyo to te fauf finy Anyo na Tsivou, ma kat kan fi mi jesan te kat fi Nyo tsumi. ");
INSERT INTO sps_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nyo tsue faman of maromi a sikia ta isen ta tsoiny binun te karap fafis iny non a tsoiny tatagaa ot tsuan, ge na tsoiny gogovet vegiau te karap fafis iny non a mes te jiats naa non ya. ");
INSERT INTO sps_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mi nat bus iny a man nana fo kat to kat yam, ma nai kaa mimi na paparaa tsian te kat fi romi tsuri. ");
INSERT INTO sps_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nyo gim rou ma tsue tsuk mami faavot Nyo nat rarori na vainy te pisainy Anyo. San vegiau tan Vegiau Ten Gov ma ruak iny man me, ‘A mes te ainy a kainy ainy Tsonyo koma iring Varonyo.’ ");
INSERT INTO sps_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nyo tsue of bus mamin foka to tabuiny tapokaa non ya sai te ruak nats non ya, mi nai faaman Varonyo, Anyo na Ayei, a Mes to te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy. ");
INSERT INTO sps_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nyo tsue faman of maromi, e sei te faarof non a mes te jiats mi Ronyo ee, te faarof kainy Varonyo, ai sei te faarof Varonyo ee, te faarof non a mes to te jiats Vaminyo.” ");
INSERT INTO sps_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Te vegiau fakap bus iny e Jisas a ka to, ana Ayei kaa miton koma patang koman Ya ana Ya tsue faruak to tsuri na fokinai, “Nyo tsue faman of maromi a isen fapoopoan namami nai faan iny Varonyo nimar a vainy ma nai atsuiny vanyo ri.” ");
INSERT INTO sps_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Rin matisian fi mamatoong rato fapoopoan narari, ri fapinpin iny to e sei te tsue tsuk iny non Ya ee. ");
INSERT INTO sps_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jon a matisian to te mangiir fiisok non e Jisas gumgum en panan Ya. ");
INSERT INTO sps_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita fasisiraa faamo of tsuiny vanyo sa tsue na ka, “Rangats, sei to aya te tsue tsuk iny non ya ee?” ");
INSERT INTO sps_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ana nyo fasak fasiruu naa to panan e Jisas ana nyo rangats Towa, “Tsunaun, e sei fatoobing to ayei ee?” ");
INSERT INTO sps_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas biny towa sa tsue na ka, “Nyo nai fabub rou a painy koinykoiny to koman kobuu Nyo te faan iny ya tsunia ayei nan a mes.” Ana Ya nom to na painy koinykoiny sa fabub ya ana Ya faan iny towa ten Judas a guei tsoiny ten Saimon Iskariot. ");
INSERT INTO sps_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Te nom e Judas a painy koinykoiny to ai Satan sof towa sa tagaa ot iny ya. Jisas tsue to tsunia, “Veesau tsun kat a ka te komainy kat rom anyi!” ");
INSERT INTO sps_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sana sikia ta isen tsuri te kaa tana taran ma nat kat fei sen Jisas tsue iny a ka to tsunia ei. ");
INSERT INTO sps_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas, ayei na tatagaa ot tana poraa moni mam mes matisian pon iny to Jisas te tsue of ya ma nai foiny ta ka te komainy romam nan guainy, ge te tsue of ya ma faan ir yan vainy aaruts ta ka. ");
INSERT INTO sps_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas ainy to na painy koinykoiny sa tafuts veesau tsun en. Te voiny busen ana ya tafuts to. ");
INSERT INTO sps_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Te tafuts bus na Judas, ai Jisas tsue to, “U nainy te nom non a Guei Tsoiny te Bobot e Gov sa ruak iny Mes men asangan iny vamarits ruak nats non, an Siinaiv ten Gov te nai afis Varonyo ai Gov te nom kainy asangan iny vamarits, tana saa ito tan fo mamatsiny ka to te nai ruak non Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ai to te pokei Ronyon asangan iny vamarits ten Gov, Gov patsukanen nai pokei non a asangan iny vamarits tana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me, ana Ayei kat veesau tsuiny non ya. ");
INSERT INTO sps_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Fuainy guei Tsiau, Nyo nai kaa taataun tsun fiisen maromi. Mi te nai sainy vavis Vanyo to te tsue of Anyo rin tsoiny mumua tana taa Jiu, sin tovei Nyo tsue of maromi, ‘Tana pan te naa Ronyo mi gim rom ma naa me.’ ");
INSERT INTO sps_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A faun a foun to te tsue faparits of marom yam mi ma mangiir isiseiny mes. To te mangiir fi Nyo mi, jesan mi ma mangiir isiseiny mes. ");
INSERT INTO sps_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","To te kaa mirom min mangiir tan isiseiny mes a fokinai faavot te nat maromi, amin fuainy matisian Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita rangats Towa, “Fei te naa fi rom Anyi ei Tsunaun?” Jisas biny towa sa tsue na ka, “Nyi gim rom ma vovou on Vanyo tan ar nainy to tana pan te naa Ronyo sin vou, nyi nai vovou Varonyo.” ");
INSERT INTO sps_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Tsunaun, kat fei ma gima vovou im roman ei?” te rangat fi Pita. “Nyo kakoun you ma mat of Manyi!” ");
INSERT INTO sps_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisas biny towa sa tsue na ka, “Anyi kakoun faman rom ma mat of Vanyo? Nyo tsue faman of marom anyi tabuiny kokorooto non a koriou a tsoiny nyi nai faungis Varonyon fopis nainy, nyi gim rom ma nat Vanyo.” ");
INSERT INTO sps_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Koma patang vaare yam,” te tsue fi Jisas tan matisian Tsunia, “Mi faason busem ten Gov, mi te faason kan Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gagon numaa ten Tamanyo te kaa minon fo mamatsiny ar bei ot na aya Nyo nai kakouiny onots of maromi ya. Nyo tabuiny tsue of mami te gim fi non ya ma man. ");
INSERT INTO sps_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ai to te naa fi Ronyo ma kakouiny Anyo na pan tsumi. Nyo nai tabin mirou Nyo te nom fi mami Tsonyo, tan kat to aya mi nai kaa emarom tana pan te kaa Ronyo. ");
INSERT INTO sps_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ami natiny rom a sanaan te naa fi non tana pan te naa Ronyo.” ");
INSERT INTO sps_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas tsue to Tsunia, “Tsunaun, mam gim rom ma natiny a pan te naa fi rom Anyi, fei te nat finy romam a sanaan te naa fi naa non unya ei?” ");
INSERT INTO sps_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas biny towa sa tsue, “Anyo na sanaan, ana man, ana toto, sikia ta isen ta mes te naa faamuan fi naa non ten Tamanyo, a sikia, ayei ma naa tsom fi me Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","To ma nat faman fi Minyo, mi nai nat faman kan iny rom e Tamanyo tanik non tan nainy tovei, mi natiny rom Ya, ai mi te tagei bus Ya.” ");
INSERT INTO sps_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip tsue to Tsunia, “Tsunaun, faatok mamimam e Tamam ai te onots koman tsumam.” ");
INSERT INTO sps_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas biny towa sa tsue na ka, “Filip, Nyo kaa fiisen mamimi naangis fiisok, ai tovei, nyi tsue rom a ka anyi gim rom ma nat Vanyo? E sei na mes to te tagei Vanyo ee, te tagei bus e Tamanyo. Kat pas fei sanyi tsue rom a ka ei, ‘Faatok mamimam e Tamam’? ");
INSERT INTO sps_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filip nyi gim rom ma faaman, Nyo kaa rou koman e Tamanyo ai Tamanyo kaa non koma Vanyo? U vegiau te pokei naa Nyo tsumi gima poo fi me Tsonyo, ito e Tamanyo to te kaa kaa non koma Vanyo te kat non a binun Tsuan fatoobing. ");
INSERT INTO sps_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Faamainy yam vegiau to, Nyo kaa rou koma ne Tamanyo, ai Tamanyo te kaa non koma Vanyo, sikia non, ami te faaman tana saa tana fo mamatsiny binun iny faatok reits to. ");
INSERT INTO sps_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nyo tsue faman of maromi, e sei na mes te faason non Tsonyo ee nai kat kainy non a fo binun te kat Ronyo, eye, ayei nai kat non a foka te karap fafisfis iny non a fo binun te kat Anyo tana saa Nyo naa fi rou ten Tamanyo. ");
INSERT INTO sps_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ana Nyo te nai kat a foka te rangat fi romi tana asanga Vanyo ma tapokaa ising me na fo siinaiv ten Tamanyo ito tana Guei Tsoiny. ");
INSERT INTO sps_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Te rangat fi Varonyo mi tan ta ka tana asanga Vanyo, Nyo nai kat rou ya.” ");
INSERT INTO sps_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“To te mangiir Varonyo mi, mi nai manaats rom a fo faun te tsue faparits Ronyo. ");
INSERT INTO sps_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Nyo nai rangats rou e Tamanyo ana Ayei te nai faan mami na mes a Tsoiny Fifaakouts, iton Aaven te pokei non a man nane Gov, Ayei kaa ovei nanon fiisen mamiromi. Ana vainy tana monaagits tovei te gim ma faarof Ya, tana saa ri gima inainy fanatnat iny Ya ge te gima nat iny Ya. Sana mi natiny rom Ya tana saa Ayei te kaa fiisen maromi ana Ayei kaa non koma mami. ");
INSERT INTO sps_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nyo gim rou ma nai naus osing babainy mami faarei maromin guei ngap, Nyo nai tabin mirou tsumi. ");
INSERT INTO sps_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tan ta fo mar nainy to vainy tana monaagits te gim ror ma nai tagei oiny pis Vanyo, sana mi te nai tagei Varonyo. Mi kan nai toto emarom tana saa Anyo te toto fatabin You. ");
INSERT INTO sps_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Te naa minon nainy mi nai nat Varonyo Anyo kaa rou koman e Tamanyo, ana mi kaa kan rom koma Vanyo faarei tsuiny non te kaa Ronyo koma mami. ");
INSERT INTO sps_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“E sei na mes te faarof iny non a fo faun te tsue faparits iny Ronyo ee ana ayei te manaats rari ayei na mes to te mangiir Varonyo. E sei na mes te mangiir Varonyo ee, e Tamanyo kan nai mangiir non ya tsunia te mangiir vanyo, Nyo kan te nai mangiir rou ya ana Nyo te pokei iny a Tsivou tsunia.” ");
INSERT INTO sps_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (sikia ma Judas Iskariot) tsue to, “Tsunaun, kat fei ma pokei iny Anyi na Tsivom tsumam ei ana sikia ma tana vainy tana monaagits to?” ");
INSERT INTO sps_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas biny towa, “Tana saa, a vainy tana monaagits to te gima mangiir Vanyo, Anyo nai pokei tsuiny rou a Tsivou ten sei na mes te mangiir Varonyo ee ai sei te mangiir Vanyo ee ayei manaats Varonyo. Tamanyo nai mangiir non ya, ai Tamanyo ana Nyo naa mirom tsunia ana mam te nai kaa koman ya. ");
INSERT INTO sps_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","E sei na mes te gim non ma mangiir Vanyo ee, te gim kainy non ma manaats vegiau Tsonyo. U vegiau te nongoiny amin sikia ma vegiau Tsonyo, sai te poo fi me ten Tamanyo to te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nyo tsue of bus mami na ka to te kaa taataun fiisen Vamironyo mi. ");
INSERT INTO sps_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A Tsoiny Fifaakouts ton Aaven Taabos to te nai jiats minon e Tamanyo tana asanga Vanyo nai faatsuts maromi na fo mamatsiny ka ana Ya te kat mami ma fakats fatabiny ami na foka te tsue of im yam. ");
INSERT INTO sps_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nyo naus osing fiisen mamiromi na aaverof ana aaverof Tsonyo fatoobing Nyo faan maromi ya. Nyo gima faan mami ya faarei te faan fi maromi ya na vainy tana monaagits to. To tsumi ma koma patang vaare am oraav vaare to. ");
INSERT INTO sps_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ami te nongon Vanyo te tsue tsumi, ‘Nyo naa evarou, sana Nyo nai tabin mirou tsumi.’ To ma mangiir faman Vanyo mi, mi tabuiny mamagat Tsonyo te naa fi rou ten Tamanyo tana saa, Ayei te karap fafis Varonyo. ");
INSERT INTO sps_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nyo tsue of bus mami na ka to roman, tabuiny ruak nats non ya to te ruak fi non ya, mi nai faaman rom. ");
INSERT INTO sps_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nyo gim rou ma vegiau fiisen mamimi tan ar nainy viviakoo tana saa a tsoiny tatagaa ot tana monaagits to te naa minon. Ayei gima parits fafis Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sana vainy tana monaagits to ma nat, Nyo mangiir rou e Tamanyo ito na ka te kat of Ronyo na fo mamatsiny ka te tsue faparits of Vaminyo Ya. Taami yam, naus osing ara na pan to.” ");
INSERT INTO sps_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Anyon ngits Gereip faman ai Tamanyo na tsoiny makok tan tanun. ");
INSERT INTO sps_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ayei tek saviir non fo naan Tsonyo te gim ror ma fua faarof ana ayei te ots firak fakakats a fo naan to te fua faarof er, tan kat to aya, ana fo naan te arasan ana ri te fua faarof fakinai ovei. ");
INSERT INTO sps_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","U vegiau te tsue of im yam te kat mami sam ruak iny taabos busem. ");
INSERT INTO sps_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kaa mi yam koma Vanyo ana Nyo te nai kaa me koma mami. A naan te gim non ma fua tana ar naan patsukanen, te fua non te kaa fi non ya koman a ngits wain. Jesan kan ami gim rom ma fua faarof te gim fi romi ma kaa koma Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Anyon ngits wain, ana min fo naan. E sei te kaa non koma Vanyo ee ana Nyo te kaa koman ya nai fua faarof fakinai ovei nanon tana saa, ami te gim rom ma kat ta isen ta ka patsukanem miam te gim fi romi ma kaa koma Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","E sei te gim non ma kaa koma Vanyo ee te nai ravaa non faarei non a naan a maas ana fo naan to ari te guam faavot a nai faakoor ravaa to tan guaf. ");
INSERT INTO sps_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Te kaa romi koma Vanyo an vegiau Tsonyo te kaa kan koma mami ai to te rangat fi romi tan ta ka tan koman tsumi mi nai nom rom ya. ");
INSERT INTO sps_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Siinaiv ten Tamanyo nai tapokaa non tsumi te fua faarof fakinai ovei romi to sami faarei mirom matisian Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nyo mangiir maromi faarei te mangiir fi Varonyo Tamau, mi ma kaa me koman mangiir Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","To te manaats romin faun tan tsue faparits Tsonyo, mi nai kaa mirom koman mangiir Tsonyo faarei te manaats finy Anyon faun tan tsuen parits ten Tamanyo ana Nyo kaa vato koman mangiir Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nyo tsue of bus mami na foka to, to ma kaa patsu mimi na mamagat Tsonyo naa tsumi ana mamagat to te nai via tsitapuu ovei en tsumi. ");
INSERT INTO sps_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A faun te tsue faparits Ronyo to, mangiir yam isiseiny mes faarei te mangiir fi Ronyo mi. ");
INSERT INTO sps_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mangiir tsian te fis non fo mes mangiir tovei: a mes te orovus iny non a toto tsuan tan vaatau tsunia. ");
INSERT INTO sps_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amin vaatau Tsonyo to te kat fi romin fo faun te tsue faparits of Ronyo mi. ");
INSERT INTO sps_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nyo gim rou ma koo pis mamin fuainy tsoiny binun, a sikia, tana saa, a tsoiny binun te gim non ma natiny a ka te katkat non a tsoiny tatagaa ot tsuan tan kat to ayei, Nyo koo maromin fo vaatau Tsonyo, tana saa Anyo te tsue of bus mamin fo mamatsiny ka te nongoiny Anyo ten Tamanyo. ");
INSERT INTO sps_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ami te gima pisan Vanyo, sana Nyo te pisan bus mami, Nyo bobot matuami ma naa am fua faarof ovei mato, iton fua te nai kaa ovei nanon. Ai Tamanyo te nai faan mami na foka te rangats romi Ya tana asanga Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","U tsuen parits Tsonyo tsumi tovei, ami ma mangiir isiseiny mes.” ");
INSERT INTO sps_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Te tsugei maromin vainy vavaajets tana monaagits to mi ma fakats a ka to, ari tsugei faamuainy bus Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tabuiny fasito mamirin vainy vavaajets tana monaagits to, vainy tabuiny mangiir mami faarei maromin vainy tsuri fatoobing. Sana Nyo te pisan bus mami komar a vainy, ma fasito vaare mamiri tan kat to aya ri tsugei mami. ");
INSERT INTO sps_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Fakats yam a ka te tsue of im yam, ‘A tsoiny binun a sikia ma karap fafis iny a tsoiny tatagaa ot tsuan.’ Ri na mesapan fakamits Vanyo, ana ri nai fakamits kan maromi, sana mesapan tsuri manaats vegiau te tsue iny Anyo, ana ri te nai manaats kainy vegiau te tsue romi. ");
INSERT INTO sps_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Sana mi Tsonyo, ai tan kat to aya ri nai kat ror a fo mamatsiny kat to tsumi tana saa ri gim ror ma natiny Ya to te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tabuiny gima naa Minyo ma tsue of Anyo ri, ri tabuiny gima kaa me ta fo aveto tsuar, sin tovei, ari na sikia tu vegiau ma kat tap iny ari na fo aveto tsuar. ");
INSERT INTO sps_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","E sei te tsugei Varonyo ee te tsugei kainy non e Tamanyo. ");
INSERT INTO sps_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tabuiny gima kat Anyo ta ka fapoopoan narari to te gima kat ta isen ta mes ri tabuiny gima kaa me ta fo aveto tsuar, sin tovei ri tagei bus a foka iny faatok fapoopoan narari ana ri pon ror ma tsugei Vanyo ai Tamanyo, ai tan kat to ayei ri kaa erato tan aveto tsuar. ");
INSERT INTO sps_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sana ka to ma pokei me na man nan kirkir ten Moses tana faun tsuri, ‘Ari te tsugei Varonyo, ana sikia ta kifon Ya.’ ");
INSERT INTO sps_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“A Tsoiny Fifaakouts te naa minon, Ayein Aaven te pokei non a man nane Gov to te poo fi minon ten Tamanyo. Nyo nai jiats mirou Ya tsumi poo fi minon ten Tamanyo, ana Ayei te pokei Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ana mi kan nai pokei iny Varonyo, tana saa mi kaa fiisen bus Vaminyo tanik me tan tatanik nana binun Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nyo tsue of bus mami na foka to ma faterof faavot vaare mi tan faason Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ri nai gargar fatafuts maromi tana fo numaa iny fafaatouf tsuri. Ai tan nainy te naa minon te atsuiny famat maromi sei na mes ee, ana ya te fakats kat to aya, ayei te faarei te bibinun of non e Gov. ");
INSERT INTO sps_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ri nai kat rora fo mamatsiny kat to tsumi tana saa ri gim ror ma natiny e Tamanyo ge Anyo. ");
INSERT INTO sps_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sana Nyo tsue of bus mami na ka to, to te naa minon nainy tsuri tan kat a fo mamatsiny ka to, mi nai tamomots rom a ka te tsue of bus im yam.” “Nyo gima tsue of mami na foka to tan tatanik nan fafaatsuts Tsonyo tsumi tana saa Anyo kaa fiisen mamimi. ");
INSERT INTO sps_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sin tovei Nyo naa os to Tsunia to te jiats Vaminyo ana sikia vaarik ta isen tsumi ma rangats Vanyo, ‘Fei te naa rom Anyi ei?’ ");
INSERT INTO sps_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ai tovei Nyo tsue of bus mami Nyo naa rou an reesik via os to koma mami. ");
INSERT INTO sps_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sana Nyo tsue faman of maromi ayei na rof namami to ma naa Nyo, tana saa te gim fi Ronyo ma naa, a Tsoiny Fifaakouts te gim non ma naa on me tsumi. Sana Nyo te naa rou ana Anyo te nai jiats mi Ya tsumi. ");
INSERT INTO sps_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ai to te naa minon Ya Ayei nai kat raror a vainy tana monaagits to ma nat ari tan kat aveto tsuri, ai to kan tan kat tavaron Tsonyo ai to tan vaatsuk ten Gov. ");
INSERT INTO sps_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ri nat ror tan aveto, tana saa ari te gima faaman Tsonyo; ");
INSERT INTO sps_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ito kan tan kat tavaron Tsonyo, tana saa Anyo naa rou ten Tamanyo ana mi te gima tagei pis Vanyo; ");
INSERT INTO sps_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ito kan tan vaatsuk ten Gov, tana saa a tsoiny tatagaa ot tana monaagits to te kaa busen tan vaatsuk sa biu ovei en. ");
INSERT INTO sps_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nyo kaa mirou vegiau kinai iny tsue of im yam, sin tovei ami sikia ma onot ma natiny ya. ");
INSERT INTO sps_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sai te naa minon Aaven Taabos Ya te pokei iny a man, Ayei nai mei maromi tana fo man. Ayei te gim ma tsue tsuk iny a Tsivon. Sana Ayei nai tsue tsuk iny non a ka te nongoiny Ya, ana Ya te tsue of mami na foka te naa minon. ");
INSERT INTO sps_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ayei nai pokei faruak non a tou kainy Tsunaun Tsonyo to sa vamarits Varonyo, tana saa Ayei te nai nom non vegiau te fainy Ronyo Ya ma tsue of mami Ya. ");
INSERT INTO sps_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","A foka te kaa minon e Tamanyo, a foka Tsonyo, to sa Nyo tsue rou, u Aaven Taabos nai nom non a ka te fainy Ronyo Ya, Ya te tsue of mami.” ");
INSERT INTO sps_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Tana fo ar nainy to mi gim rom ma tagei pis Vanyo ai to tan fo mar nainy te naa minon mi nai tagei pis Varonyo.” ");
INSERT INTO sps_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mesapan tsurin matisian Tsunia tsue to tsuri na mesapan, “Saf a kifon ya to na? Ayei te tsue of rara, ‘Tan fo ar nainy to mi gim rom ma tagei Vanyo, ai to tan fo mar nainy te naa minon mi nai tagei pis Varonyo.’ Ana Ya tsue pis to na ka, ‘Ito tana saa Anyo naa fi rou ten Tamanyo.’ ");
INSERT INTO sps_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Saf kifon vegiau to ayei na, ‘Ito tan ar nainy?’” te rangat fi ri. “Ara gim ror ma natiny a ka te tsue iny non Ya!” ");
INSERT INTO sps_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas nat rari te pon ma rangats Ya ana Ya tsue to tsuri, “Nyo te tsue, ‘Tan ar nainy mi gim rom ma tagei pis Vanyo ai to tan fo mar nainy te naa minon mi nai tagei pis Varonyo.’ Ai koraa na ka te rangat iny romi fapoopoan namami? ");
INSERT INTO sps_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nyo tsue faman of maromi mi nai tangis emarom am susuiny matan to, sana taa Jiu ton vavaajets nai mamagat eraror; mi nai reesik emarom, san reesik tsumi nai takopis enanon a faarei miton mamagat. ");
INSERT INTO sps_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Te sisiruu iny faagiir non a moun a guei a meran ayei reesik non, tana saa nainy saraa kamits tsunia te naa os mito, sai te agiir fi non a guei a meran to a moun to aya te anofe non a kamits tsuan tana saa ayei te mamagat iny non a guei a meran te agiir en. ");
INSERT INTO sps_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jesan te kat fi non ya to tsumi tovei roman mi reesik rom, sana Nyo nai tagei pis maromi, ana koma mami te nai via me na mamagat tsian ito na mamagat a sikia ta mes te pets osing maromi Ya. ");
INSERT INTO sps_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Te naa minon nainy to aya, mi sikia rom ma nai rangats Vanyo tan ta ka. Nyo tsue faman of maromi, e Tamanyo te faan maromi na ka te rangat fi romi Ya tana asanga Vanyo. ");
INSERT INTO sps_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Onot roman mi sikia ma rangat iny ta ka tana asanga Vanyo, rangats yam, mi te nom ya, ana mamagat to ayei tsumi te nai via tsitapuu ovei en.” ");
INSERT INTO sps_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nyo tsue of bus mami na fo mamatsiny ka to tana fo tsue fapapaar. Sai tan nainy te naa minon Nyo sikia rou ma tsue iny a fo tsue fapapaar, Nyo nai tsue fatoobing of maromi Tamanyo. ");
INSERT INTO sps_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Te naa minon nainy mi nai rangats rom Ya tana asanga Vanyo ana Nyo gim rou ma rangat of mami, to ma rangat of mami yam e Tamanyo ma faakouts mami Ya, ");
INSERT INTO sps_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tana saa e Tamanyo tsun Tsivon patsukanen te mangiir maromi. Ayei mangiir maromi tana saa mi te mangiir Varonyo ana mi faaman to Tsonyo te poo fi me ten Gov. ");
INSERT INTO sps_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nyo poo fi me ten Tamanyo ana Nyo naa mito tana monaagits to; ai tovei roman Nyo naus osing rou a monaagits to ana Nyo te tabin fi you ten Tamanyo.” ");
INSERT INTO sps_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","An matisian Tsunia tsue to, “Tagaa, Nyi te tsue fatoobing ovei bus em, ana Nyi sikia ma tsue iny rom fo tsue fapapaar. ");
INSERT INTO sps_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Amam nat busem roman, Tsumanyi te natiny rom ma fo mamatsiny ka, Anyi sikia rom ma anaanos ta mes ma rangats Manyi tan tu rangat tana saa Nyi nat faamuan bus iny fakats tana mes. Ka to te kat mamam sa mam faaman Manyi to te poo fi me ten Gov.” ");
INSERT INTO sps_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas biny ratuari sa tsue na ka, “Ami faaman osto ge? ");
INSERT INTO sps_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","U nainy te naa os mito ai tovei te ruak en, mi nai fabuubus vavis fi naa rom tana fo numaa tsuam ana Nyo kaa patsukan You Tsivou. Sana Nyo sikia ma Tsivou tovei, tana saa e Tamanyo te kaa fiisen Vamironyo. ");
INSERT INTO sps_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nyo tsue of bus mami na ka to mi kaa rom koma Vanyo ma nai kaa mimi na aaverof. U kat tana monaagits to te fakamits maromi. Sana mi ma tsutsun faparits! Nyo kat fabiu bus kat tana monaagits to!” ");
INSERT INTO sps_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Te fakap bus e Jisas vegiau Tsunia, ana Ya matoong fi naa to Gormirmir sa tsue na ka, “Tamau nainy te ruak en, Nyi ma pokei of ir a vainy saf asangan iny vamarits tana Guei Tsoiny Tsumanyi to na, tan kat to aya a Guei Tsoiny kan te faan marom Anyin asangan iny vamarits to, ");
INSERT INTO sps_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","tana saa Nyi faan bus iny gumgum to Tsunia, tan kat to aya, Ayei faan rarori na vainy a toto na suu ten sei na mes to te faan bus iny Anyi Tsunia ee. ");
INSERT INTO sps_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ana toto na suu tovei, ito ma nat Manyi na vainy a isen tsun a Gov a man ana ri te natiny e Jisas Krais, to te jiats mi Nyi. ");
INSERT INTO sps_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nyo fakap bus a fo binun te faan iny Anyi ma kat Anyo, tan kat to aya Nyo faatok bus Manyin asangan iny vamarits tan puputaa. ");
INSERT INTO sps_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamau, faan You asangan iny vamarits mata Manyi roman, iton senviir asangan iny vamarits te kaa fiisen Vaminyo Nyi, tabuiny tapogaar minon a monaagits to. ");
INSERT INTO sps_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nyo pokei Manyi tana vainy te faan iny Anyi Tsonyo, ito te poo fi me fapoopoan nar vainy vavaajets tana monaagits to. Ari fasito marom Anyi, ana Nyi faan Vatuanyo ri. Ana ri manaats ton vegiau Tsumanyi. ");
INSERT INTO sps_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ai tovei roman ri nat fi ror nei, fo mamatsiny ka te faan iny Anyi Tsonyo te poo fi me Tsumanyi, ");
INSERT INTO sps_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","tana saa, Nyo faan rarin vaanan te faan Vanyo Nyi ana ri faarof towa; ri natiny ton man Tsonyo te poo fi me Tsumanyi ana ri faaman to Tsumanyi te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nyo faakats of rarori. Nyo gima faakats of rou a monaagits to, sana Nyo faakats of rou na vainy te faan iny Anyi Tsonyo, tana saa rin fasito Tsumanyi. ");
INSERT INTO sps_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A fokinai vainy te kaa Mironyon fasito Tsumanyi, an vainy fasito Tsumanyi, arin fasito Tsonyo, an asangan iny vamarits Tsonyo te tapokaa ising me tsuri. ");
INSERT INTO sps_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ai tovei roman Nyo naa os fi naa to Tsumanyi, ana Nyo te gima kaa on pis nats tana monaagits to sana ri to te fasito Varonyo te kaa ror fapoopoan nar vainy vavaajets tana monaagits to. Tamau a Taabos, bei ot rame tana parits tana asanga Manyi, iton asangan te faan iny Anyi Tsonyo, tan kat to aya ri ma isen tsun me, faarei marom Anyi ana Nyo, aran isen tsun. ");
INSERT INTO sps_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nainy te kaakaa fiisen Vaminyo ri Nyo bei ot faarof ratuari tana parits tana asanga Manyi, iton asangan te faan Vanyo Nyi. Nyo makok faarof rari ana sikia ta isen tsuri ma nun ito tsun a isen te nun a guei iny Hel, tan kat to aya vaanan nan Vegiau Ten Gov nai ruak iny man ovei naa to. ");
INSERT INTO sps_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ai to roman Nyo naa os mito Tsumanyi, ana Nyo tsue of ratuarin fo mamatsiny ka to te kaakaa fiisen Minyo ri, tan kat to aya, koma rari te via tsitapuu me na mamagat Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nyo faan rarin vaanan Tsumanyi an vainy vavaajets tana monaagits to tsugei ratuari, tana saa ari na sikia ma vainy tana monaagits to faarei Varonyo, Anyo na sikia ma mes tana monaagits tovei. ");
INSERT INTO sps_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nyo gima rangat Manyi ma nom ravaa rari tan vainy vavaajets tana monaagits to, sana Nyo rangat marom Anyi ma bei ot rari tana isen a ngi'arapaar fiisok. ");
INSERT INTO sps_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Faarei Varonyo, Nyo sikia ma mes tana monaagits to ana ri kan a sikia ma vainy tana monaagits to. ");
INSERT INTO sps_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Vegiau Tsumanyin man ovei tsun. Ana Nyo komainy roun vegiau man Tsumanyi ma binun koma rari ma pets rari er faarei miton vainy taabos Tsumanyi fatoobing. ");
INSERT INTO sps_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nyo jiats rarori ma naa tan vainy tana monaagits to faarei te jiats fi Vanyo Nyi tan vainy tana monaagits to. ");
INSERT INTO sps_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nyo pets to na toto Nau Tsumanyi ma faakouts Anyo ri, tan kat to aya ri pets to na toto tsuri Tsumanyi tanyiny vegiau man Tsumanyi ma binun ya koma rari er faarei miton vainy taabos Tsumanyi fatoobing, ma kat yan mangiir Tsumanyi. ");
INSERT INTO sps_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nyo gima faakats of tsuiny rarori sana Nyo faakats kan of rarori to te nai faaman Varonyo tana saa ito tsun kan te nongoiny fi rorin vaanan tsuri. ");
INSERT INTO sps_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nyo faakats of rou vainy faaman faavot tovei ma isen tsun mi ri faarei marom Anyi ai Anyon isen tsun. Tamau, kat ramiri ma faavot mi ri er kaa to koma rara, faarei marom Anyi te kaa rom koma vanyo ana Nyo te kaa koma manyi. Kat ramiri er isen tsun mito, tan kat to aya vainy vavaajets tana monaagits to te nai faaman marom Anyi te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nyo faan bus rarin senviir asangan iny vamarits faarei te faan Vanyo Nyi tan kat to aya ri isen tsun miror, faarei marom Anyi ana Anyon isen tsun. ");
INSERT INTO sps_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nyo kaa rou koma rari ana Nyi te kaa koma vanyo, to ma isen faavot tsun mi ri, tan kat to aya a vainy vavaajets tana monaagits to te nat marom Anyi te jiats Vaminyo ana mes a ka Nyi mangiir fiisok rarori faarei te mangiir fiisok Vanyo Nyi. ");
INSERT INTO sps_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamau, Nyi faan Vanyo ri, ana Nyo koman rarori ma nai kaa tana pan te nai kaa Ronyo, tan kat to aya ri nai tagei nats rora asangan iny vamarits te kaa mironyo, iton asangan iny vamarits te faan iny Anyi Tsonyo, tana saa Anyi te mangiir fiisok Vanyo tabuiny tapogaar minon a monaagits tovei. ");
INSERT INTO sps_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamau a tavaron, vainy vavaajets tana monaagits to te gim ror ma nat Manyi sana Nyo nat marom Anyi ana ri to te fasito Varonyo nat fi ror nei, Anyi te jiats Vaminyo. ");
INSERT INTO sps_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nyo pokei faruak ma Nyi tsuri, ana Nyo kat patsukan fi kan evarou jesan, tan kat to aya u mangiir tsian fiisok te kaa mirom Anyi Tsonyo nai kaa enanon koma rari ana Nyo te nai kaa kan koma rari.” ");
INSERT INTO sps_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Te fakap bus e Jisas faakats Tsuan Ya naus osing to na pan naa to aya fiisen ramen matisian Tsunia. Ri taainy guas fi naa to tan panaainy gaguur tana aurom iny Kidron. Te kaa me na tanun na aya ai Jisas min fuainy matisian Tsunia naa fi naa to koman ya. ");
INSERT INTO sps_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, ayei na mes to te faan iny e Jisas nimar vainy te atsuiny famat ror Ya nat faamuan bus iny a pan to aya, tana saa Jisas guam vaurep raror matisian Tsunia tana pan naa to aya tana fo mes a fo nainy i muan. ");
INSERT INTO sps_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ai Judas naa bus naa to tanun ya mumua rato na gum iny vainy puaan tana taa Roum ana rin mes tsoiny bei ot tana saape tana taa Jiu. Rin fuainy tsunaun tan tsoiny faakor ana taa Farasi jiats ranaatuari fiisen men foka iny puaan, an kurun, an vit kurun. ");
INSERT INTO sps_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas nat faamuan bus iny a fo mamatsiny ka te ruak non Tsunia ana Ya taan famumua naa to matan, Ya tsue to tsuri, “E sei to aya te sainy romi ee?” ");
INSERT INTO sps_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ri biny Towa ser tsue na ka, “E Jisas a mes tana ngats fan iny Nasaret.” Ana Ya tsue to na ka, “Anyo na Ayei.” Judas, ayei na mes to te faan iny e Jisas nimar rari tsutsun fiisen ramen vainy puaan na aya. ");
INSERT INTO sps_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te tsue Jisas a ka tsuri, “Anyo na Ayei,” ri sos iny vou to ana ri gotsiny faavou naa to petoo. ");
INSERT INTO sps_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jisas rangats pis ratuari sa tsue na ka, “E sei to aya te sainy romi ee?” Ri tsue to na ka, “E Jisas a mes tana ngats fan iny Nasaret.” ");
INSERT INTO sps_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Nyo tsue faamuan of bus mami, Anyo na Ayei,” te tsue fi Jisas tsuri. “To te sainy fi Varonyo mi tanyir yam a mesapan to ari ma naa ri.” ");
INSERT INTO sps_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Jisas tsue na ka to ma ruak iny man men vegiau Tsunia, “Tamau, Nyo sikia ma kaa me ta isen ta mes ma nun to te faan iny Anyi Tsonyo.”) ");
INSERT INTO sps_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita te kaa men kirat nana puaan, gamus to ya sa tek sapee na teinan tan panaainy matou tana tsoiny binun babainy tana Tsoiny Mumua tan Tsoiny Faakor. Asangan a tsoiny binun babainy to te koo rori Malkus. ");
INSERT INTO sps_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisas tsue to ten Pita, “Rog fatabiny iny kirat nana puaan tsuam tana susukap nan! Anyi pon iny rom a saa, Anyo gim rou ma nai ong a patang iny saraa kamits to te faarof iny e Tamanyo? Eye, Anyo nai ong rou ya.” ");
INSERT INTO sps_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ana gum iny vainy puaan tana taa Roum fiisen me na tsoiny mumua tsuri an tsoiny bei ot tana saape tana taa Jiu nots to Jisas ri kotskots Towa, ");
INSERT INTO sps_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ana ri mei faamuainy naa Towa ten Anas. Anas ayei na vaanis ten Kaiafas, ayei faarei na Tsoiny Mumua tan Tsoiny Faakor tan nainy to aya. ");
INSERT INTO sps_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","E Kaiafas ayei koraa na mes to te tsue ir fuainy tsoiny mumua tana taa Jiu te rof fiisok non tan ta isen ta mes ma mat of ir a fokinai. ");
INSERT INTO sps_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ana mesmes a matisian vovou iny naa to Jisas. Mesmes a matisian to na Tsoiny Mumua tan Tsoiny Faakor nat faarof iny non ya ana ayei naa fiisen mito Jisas koman a aunon tana numaa tana Tsoiny Mumua tan Tsoiny Faakor. ");
INSERT INTO sps_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita kaakaa en jiarasan tan matainy sobaa nana aunon. Ana nyo Jon a matisian to na Tsoiny Mumua tan Tsoiny Faakor te nat faarof iny non ya tafuts fatabin mito jiarasan, sa tsue tana guei moun to te tatagaa ot iny matainy sobaa sa ras fatabiny na Pita gagon. ");
INSERT INTO sps_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ana guei moun to te tatagaa ot iny matainy sobaa tsue to ten Pita, “Anyi koraa ya na matisian tana mes tuwa aya?” Pita biny towa sa tsue na ka, “A sikia, anyo na sikia.” ");
INSERT INTO sps_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nainy tana tonok an tsoiny binun ana rin vainy bei ot kat ton gonif ri faakor towa ana ri tsutsun faafis towa, ser mangin. Pita naa sa tsutsun fiisen ramiri sa mamangin en. ");
INSERT INTO sps_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ai Anas a Tsoiny Mumua tan Tsoiny Faakor rangats to Jisas tan fuainy matisian Tsunia an fifaatsuts Tsunia. ");
INSERT INTO sps_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisas biny towa sa tsue na ka, “Nyo vegiau fatatabin you matar a fokinai tan mamatsiny nainy an fo mamatsiny fifaatsuts Tsonyo kat bus Anyo koman a fo numaa iny fafaatouf tana taa Jiu ai koman a saape tana pan te vaaguam faavot rori na taa Jiu. Nyo gima munmun iny tu vegiau tana pan a takop. ");
INSERT INTO sps_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kat fei, sam rangat Varonyo ei? Mi ma rangat ir a vainy to te nongon Vanyo, rangats ir yam a ka te tsue of Anyo ri, ri natiny ror a ka te tsue Nyo tsuri.” ");
INSERT INTO sps_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Te tsue iny e Jisas a ka to ana isen tsurin bei ot sapainy Towa ya tsue to, “Saf vegiau te kat rom Anyi tana Tsoiny Mumua tan Tsoiny Faakor na?” ");
INSERT INTO sps_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisas biny towa sa tsue na ka, “To ma tsue Nyo na ka na iring, tsue of ir a fokinai te kaa ror to na saf a ka ei na, sai te man fi non na ka te tsue iny Anyo te gim non ma rof tsumanyi ma sapan Vanyo.” ");
INSERT INTO sps_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ai Anas jiats naa Towa ten Kaiafas a Tsoiny Mumua tan Tsoiny Faakor fiisen me na niman a kotskots. ");
INSERT INTO sps_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita tsutsun kanen nanon na aya mamangin en tan guaf. Ana mesapan tsuri tsue to tsunia, “Anyi koraa ya na isen a matisian tana mes tuwa aya?” Sai Pita faungis ya tsue to, “A sikia, nyo na sikia.” ");
INSERT INTO sps_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Isen tsurin tsoiny binun babainy tan Tsoiny Mumua tan Tsoiny Faakor ana ayei kan a nuatsin a mes to te tek sapee Pita na teinan ya tsue to na ka. “Anyo ya te gima tagei manyi fiisen mi Ya tanun?” ");
INSERT INTO sps_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita faungis sa tsue pis to, “A sikia.” Sen tsun ana koriou a tsoiny kokorooto to. ");
INSERT INTO sps_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ri nom e Jisas ri naus osing to na numaa ten Kaiafas, ser mei naa Towa tana pan te kaa non e Pailat a gavana tana gum fan iny Judia. Tana voinyvoiny ovei. Ri na taa Jiu gim to ma sof a numaa to tana saa ito te sof rori numaa, ri pon iny ror aveto ma gima ainy arin Guainy iny Fakats Fatabin. ");
INSERT INTO sps_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ai Pailat tafuts naa to tsuri jiarasan sa rangat rari, “Saf a iring to te sak ami na mes to na?” ");
INSERT INTO sps_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ri biny towa ser tsue na ka, “Amam tabuiny gima mei mi Ya nei tsumanyi ma faarei vaare Ya na mes a pisiin a kat kat iring.” ");
INSERT INTO sps_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat tsue to tsuri, “Ami patsukanem ma mei naa Ya am faaroiny Towa tana fo faun tsumi fatoobing.” Rin fuainy tsoiny mumua tana taa Jiu biny towa ser tsue na ka, “Mam gim rom ma famanat iny ta mes ma gageits ya.” ");
INSERT INTO sps_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Ka to te ruak ma tapokaa me na man nan vegiau te kat e Jisas, tana saf a sanaan ei naa te nai mat fi non Ya.) ");
INSERT INTO sps_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat sof fatabin naanaa tana pan tsunia sa fikoo Jisas ya rangats Towa, “Anyi Ya na Aatouf tana taa Jiu?” ");
INSERT INTO sps_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas biny towa, “U rangat to aya, fei te poo fi mi ya ei i naa tsumanyi ge ta mes te tsue of manyi Tsonyo?” ");
INSERT INTO sps_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat biny Towa, “Kat fei sanyi rangat varonyo ei nyo na gima tsoiny Jiu! A vainy Tsumanyi fatoobing to ari an fuainy tsunaun tan tsoiny faakor to te faan vaminyo Nyi. A saa te kat Anyi na?” ");
INSERT INTO sps_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisas tsue to, “A Waa Vanyo na sikia ma tana monaagits to. Ito ma kaa tsun ya tana monaagits to vainy to te vovovou Varonyo tabuiny kat a puaan ma bei ot Vanyo ri ma faan vaare Vanyo rin tsoiny mumua tana taa Jiu. Sikia, a Waa Vanyo na sikia ma tana monaagits to!” ");
INSERT INTO sps_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ai Pailat rangats Towa, “Anyi pas a saa, a aatouf?” Jisas biny towa, “Nyi tsue Nyo na aatouf. Nyo naa me tana monaagits Nyo agiir of tsuiny a isen a ka ma tsue iny Anyo na kifon a man. E sei te kaa non tan panan tana kifon a man ee nongoiny non vegiau Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat rangats Towa, “Ana saf a man na?” Ai Pailat tafuts fatabin naa to tana taa Jiu, ya tsue to tsuri, “Nyo gima sab ta iring Tsunia ma sak anyo Ya. ");
INSERT INTO sps_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","San tan kat tan fuainy tsuvumami te kaa miromi nyo natiny famanat maromi na isen a mes a kotskots ma tafuts osing ya na numaa iny kotskots tan nainy Guainy iny Fakats Fatabin. Ami komainy varonyo ma puruur osing mami na Aatouf tana taa Jiu?” ");
INSERT INTO sps_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ri biny towa ser kuu fatsian, “A sikia, sikia ma Ayei! Amam komainy rom e Barabas!” (Barabas ayei na mes a kakabuts.) ");
INSERT INTO sps_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ai Pailat mei naa to Jisas gagon numaa tsuan ana ri rapits Towa. ");
INSERT INTO sps_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","An vainy puaan kat to na sapou uupe kakarits, ri fa'uupe towa patsun Ya, ri favau Towan vaun mamaato tana fo aatouf, ");
INSERT INTO sps_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ana ri naa mito Tsunia ser tsue taring iny Ya ana ri tsue to na ka, “Kaakaa ovei, O Aatouf tana taa Jiu!” Ana ri naa to ri sapainy Towa. ");
INSERT INTO sps_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat tafuts fatabin pis naa to sa tsue tana gum iny vainy, “Tagaa yam, Nyo nai fatafuts mirou Ya nei tsumi ma tagaa mi tsonyo te gima sab ta iring ma sak Anyo Ya.” ");
INSERT INTO sps_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ai Jisas tafuts mito jiarasan kookof me na sapou uupe kakarits an vaun mamaato. Pailat tsue pis to na ka tsuri, “Tagaa yam, to aya na mes nan!” ");
INSERT INTO sps_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Te tagei fuainy tsunaun tan tsoiny faakor an fuainy bei ot tana saape e Jisas ri kuu to, “Fagageits yam tana pagafuan! Fagageits yam tana pagafuan!” Pailat tsue to tsuri, “Mi ma mei naa Ya, am fagageits Towa tana pagafuan. Nyo gima sab ta iring, to ma sak anyo Ya.” ");
INSERT INTO sps_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ri na taa Jiu biny fatabiny towa ser tsue, “Mam kaa mirom a faun tsumam te tsue non a ka, Ayei ma mat, tana saa Ayei te tsue na ka Ayei na Guei Tsoiny ten Gov.” ");
INSERT INTO sps_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Te nongoiny e Pailat te tsue iny ari na ka to, ana Ya oraav fiisok tsun naa to. ");
INSERT INTO sps_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ya tabin fatabin pis naa to gagon numaa tsuan fiisen me Jisas ana ya rangats to Jisas, “Fei te poo fi mi Nyi ei?” Sen Jisas gim to ma biny ya. ");
INSERT INTO sps_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat tsue ets'ets Ya, “Nyi gima vegiau tsonyo? Fakats faarof, nyo kaa mirou a parits tan puruur Manyi, ai to kan tan fagageits Manyi tana pagafuan.” ");
INSERT INTO sps_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas biny towa, “Nyi kaa tsun mirom a parits te fis Varonyo tana saa, Gov faan iny ya tsumanyi. Ai to tana vainy te faan i Vanyo naa tsumanyi te kaa ror tan aveto tsian fiisok te karap fafis iny non aveto tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Te nongoiny e Pailat a ka to, ya pon to ma sainy ta sanaan ma puruur ya Jisas. Sana taa Jiu kuu fatsian fatabin pis ser tsue na ka, “To te puruur rom anyi Ya, te faarei marom anyi na gima vaatau ten Aatouf e Sisa! E sei na mes te pon non ma faarei na aatouf ee ayei koma iring iny non a Aatouf e Sisa.” ");
INSERT INTO sps_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Te nongoiny e Pailat a fo vegiau to, ya mei naa to Jisas jiarasan ana ya vaagum nato tan gumgum tan tsoiny vaatsuk tana pan te koo ri na “Poon a tatabuan te kat ari tan fats.” (Te koo ri “Gabata” tan faa Hiburu.) ");
INSERT INTO sps_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te siruiny gagoiny nuaf osto tan nainy kakoun a foka of Nainy Fafaatouf tana taa Jiu, ai tamanainy u Nainy Fafaatouf tsian tan Guainy iny Fakats Fatabin. Pailat tsue to tana taa Jiu, “A Aatouf tsumi tovei!” ");
INSERT INTO sps_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ri kuu fatsian fatabin to, “Atsuiny yam! Atsuiny yam! Fagageits yam tana pagafuan!” Pailat rangats rari, “Ami koman varonyo ma fagageits a aatouf tsumi tana pagafuan?” An fuainy tsunaun tan tsoiny faakor biny towa ser tsue, “A isen tsun a aatouf te kaa miromam to e Aatouf Sisa!” ");
INSERT INTO sps_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ai Pailat faan ratuari Jisas ma nai gageits Ya tana pagafuan. An vainy puaan mei naa to Jisas. ");
INSERT INTO sps_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ya naa to, sa govets a pagafuan Tsuan, ana Ya ruak to tana pan te koo ri “Pan tan Tonaar.” (Tan faa Hiburu te koo ri “Golgota.”) ");
INSERT INTO sps_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ri fagageits Ya tana pagafuan na aya, ana ri fagageits kainy to na ina fuan a mes tan pagafuan isen tan panaan ana mesmes tan mes panaan fiisen me Jisas fapoopoan narari. ");
INSERT INTO sps_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat kirkir ton vegiau sa tapaar iny ya tana pagafuan. “Jisas iny Nasaret, a Aatouf tana taa Jiu,” ayein vegiau nan. ");
INSERT INTO sps_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Taa Jiun kinai naa me ser gogosias vegiau to, tana saa a pan to aya te gageits e Jisas sikia ma veevian osing a ngats fan. U vegiau te kirkir tan faa Hiburu, ai tan faa Latin ai tan faa Grik. ");
INSERT INTO sps_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Fuainy tsunaun tan tsoiny faakor tana taa Jiu tsue to ten Pailat. “Kirkir vaare iny ‘A Aatouf tana taa Jiu’ sai nyi ma kirkir fi nei, ‘A mes to te tsue na ka, Anyo na Aatouf tana taa Jiu.’” ");
INSERT INTO sps_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat biny ratuari sa tsue, “Vegiau te kirkir iny anyo te kirkir busen, sikia tu pangis nan.” ");
INSERT INTO sps_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Te tapaar fakap bus iny vainy puaan e Jisas tana pagafuan, ri nom ton fo vau Tsunia ser kibei rari tana fats a pan isiseiny pan tana isen a tsoiny puaan. Ri nom kan iny ton vau beberus iny jiarasan kat ari tan raarav sikia ma kun. ");
INSERT INTO sps_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rin vainy puaan tsue to fapoopoan narari, “Ara ma kakaar vaaren vau beberus iny jiarasan to ra ma tats fabiririir iny a saatu ma tagei ara sei na mes te nom non ya ee.” A ka to te ruak an vegiau tan Vegiau Ten Gov ruak iny man ovei nato. “Ri kibei fo vau Tsonyo fapoopoan narari ana ri tats fabiririir iny a saatu of vau beberus iny jiarasan Tsonyo.” An vainy puaan kat ton kat to aya. ");
INSERT INTO sps_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tsinan Jisas me famuinyasiny ten tsinan Ya, ai Meri to natsun Kolopas, ai Meri a muiny Magdala tsutsun panan a pagafuan. ");
INSERT INTO sps_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisas tagei e tsinan Ya ana nyo na matisian to te mangiir fiisok non Ya tsutsun ror na aya, ai Jisas tsue to ten tsinan, “Tsinau, a guei tsoiny tsumanyi tovei.” ");
INSERT INTO sps_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ana Ya tsue of vatuanyo, Jon, “E tsinamanyi to.” Tan ar nainy to aya, nyo mei naa towa numaa tsonyo makok towa faarei ya tsinanyo. ");
INSERT INTO sps_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas naten tana fo mamatsiny ka to te jiats of mi Ya Gov ma kat ya te kap busen, ai to kan ma ruak iny man men vegiau tan Vegiau Ten Gov ana Ya tsue to, “Nyo iinyu rou.” ");
INSERT INTO sps_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kobuun faakok te kaa na aya viainy minon wain maajiin, ri fabub yan tsuuyan kotskots towan naainy nau viviakoo faarei non ngaar tan faa Grik te koo rorin “Isop”, ri faruaa iny naa towa ngue ne Jisas. ");
INSERT INTO sps_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Te tanaf bus e Jisas wain, Ya tsue to, “Te kap busen.” Ya tsunguruu to na patsuun ana Ya faan iny to naa aaven, Ya tauts to. ");
INSERT INTO sps_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","An fuainy tsoiny mumua tana taa Jiu rangats to Pailat ma famanat rari ma ngats ir fo mour vainy ma mat, ri te fauf ramiri tana fo pagafuan. Ri kat a ka to tana saa a Faangim roman ana ri baainy ton puainy mes ma gageits patsukanen ya tana fo pagafuan tan Nainy Fafaatouf tana taa Jiu. U Nainy Fafaatouf tana taa Jiu to aya te karap fafis pis iny non a fo Nainy Fafaatouf, tana saa ito tsun tan nainy Guainy iny Fakats Fatabin. ");
INSERT INTO sps_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ana rin vainy puaan naa to ri ngats ton moun a vaamuan nana mes, ri kat kan fi to tana mesmes te gageits fiisen me Jisas. ");
INSERT INTO sps_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sai te naa mi ri ten Jisas ri tagei Towa te maten ri gim to ma ngats a moun Ya. ");
INSERT INTO sps_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Isen tsurin vainy puaan nom to na tapomas tsuan sa sak Ya na ririkin e Jisas, sen tsun an rafatsiny ana aurom tatsiiu to. ");
INSERT INTO sps_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(A mes te tagei a ka to te ruak te pokei iny ya, ma faaman kan ami. A ka te tsue iny yan man, ana ayei te natiny tsue iny non a man.) ");
INSERT INTO sps_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A ka to te ruak ma man men vegiau tan Vegiau Ten Gov, “A sikia ta isen ta pan nan tsuan Tsunia ma tangats on.” ");
INSERT INTO sps_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ana mesapan nar ar vegiau tan Vegiau Ten Gov te tsue non a ka, “Vainy te nai tagei a isen to te sak ari.” ");
INSERT INTO sps_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Voun a ka to, Josep, ayei na mes to te poo fi me tana ngats fan iny Arimatia, rangats to Pailat ma nom ya na puan e Jisas. (Josep ayei na matisian ten Jisas ana isen kan nararin tsoiny mumua tana taa Jiu, ayei te ororaav ir mes panainy tsoiny mumua tana taa Jiu to sa fafamuiny a faaman tsuan,) ai Pailat fatangan iny to Josep ma nom ya na puan e Jisas, ai Josep naa to sa nom naa ya. ");
INSERT INTO sps_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas, ito na mes te tagei faamuainy e Jisas tana voiny naa fiisen me Josep, Ya govets naa ton rafatsiny nan fuan nau kopis vavis ma kuav vaaren puan a patang sa onots fopis safunuun a kilo. ");
INSERT INTO sps_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ri na ina fuan a mes to fauf to na puan e Jisas ri tafuiny to na puan e Jisas a fungan jiaf tauf tsuraf ser paapau Yan raarav goseen kafof kat to ayei te natiny kat rora taa Jiu te kakouiny of rorin puainy mes tan kats. ");
INSERT INTO sps_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Te kaa me na isen a tanun na aya to na pan te fagageits ari Jisas ana puts a foun te kats ari tan fats a sikia ta mes ma soon vaarik na aya. ");
INSERT INTO sps_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tovei roman u nainy kakouiny of Nainy Fafaatouf tana taa Jiu ai tamanainy u nainy Guainy iny Fakats Fatabin ana puts tan fats kaa kan en siruu, ri na ina fuan a mes fasooiny to Jisas na aya. ");
INSERT INTO sps_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tana patsuu na nainy tana Sande tan vaamuan nan nainy tana wik ana pan uurup farokot en, Meri a muiny Magdala toomat naa to tan puts te kats tan fats ana ya tagei to na fats te kukuur osing matainy sobaa. ");
INSERT INTO sps_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ya kuar to sa naa fi en ten Saimon Pita ana nyo, Jon, a matisian to te mangiir fiisok non e Jisas, ana ya tsue to tsumam, “Ari te nom bus a Tsunaun tana kats ana ra gim ror ma nat fei te fasooiny ari Ya ei!” ");
INSERT INTO sps_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ai Pita ana nyo, Jon, naa to tan puts. ");
INSERT INTO sps_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mam a ina fuan kokuar bus mato, sana nyo kuar fafis e Pita sa nyo ruak faamuan tan puts. ");
INSERT INTO sps_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nyo fakokop to sa nyo tagein raarav goseen kafof, sana nyo gima sof naa gagon. ");
INSERT INTO sps_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita naa me vou vanyo ana ya sof fatoobing naa to gagon tan puts. Ayei tagei ton raarav goseen kafof soon non na aya, ");
INSERT INTO sps_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ana painy raarav to te pau ari na patsuun e Jisas. A painy raarav to ayei te gima kaa siruu panan raarav goseen kafof, a tap patsukanen. ");
INSERT INTO sps_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ana nyo to te ruak faamuan tan puts naa kan naa to gagon tan puts tagaa sa nyo faamainy vegiau te tsue Meri. ");
INSERT INTO sps_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Mam gim kainy to ma arasan iny Vegiau Ten Gov to te tsue na ka, Ayei ma tsun fatabin tana mat.) ");
INSERT INTO sps_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ana mam a ina fuan a matisian tabin fatabin to fan. ");
INSERT INTO sps_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meri ruak me sa tsutsun men tangis jiarasan tan puts. Tangis kan nanon ya fakokop to sa tagaa gagon tan puts, ");
INSERT INTO sps_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ana ya tagei to na ina fuan a morena na aya vau men vaun gosee, ser gumgum er tana pan te soon e Jisas, isen tan patsuun ana mesmes tan mou. ");
INSERT INTO sps_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ri rangats towa, “Moun, kat fei sa nyi tangis rom ei?” Ana ya biny ratuari, “Ri nom osing vanyo na Tsunaun tsonyo ana nyo gim rou ma natiny a saf a pan te fasooiny ari Ya na!” ");
INSERT INTO sps_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Te tsue iny ya na ka to ya takopis to sa tagei e Jisas tsutsun non na aya, sana ayei gim to ma nat, Ayei e Jisas. ");
INSERT INTO sps_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Moun, kat fei sa nyi tangis rom ei?” rangats finy ya Jisas, “E sei to aya te sainy rom anyi ee?” Ya pon iny to na mes tsoiny tatagaa ot iny tanun, ana ya tsue to Tsunia, “Te natiny rom anyi na pan te fakei anyi Ya, mes tsian, tsue of you ma naa nyo, nyo te nai nom Ya.” ");
INSERT INTO sps_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisas tsue to tsunia, “Meri!” Ya takopis naa to Tsunia ana ya tsue to tan faa Hiburu, “Raboni!” (Kifon vegiau to, “Tsoiny Fifaatsuts.”) ");
INSERT INTO sps_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisas tsue to tsunia, “Saras vaare you, tana saa Nyo tabuiny naa fatabin fi rou ten Tamanyo. Sana nyi ma naa fi tan fuainy vamuinyasiny Tsonyo, nyi te tsue of rari Tsonyo, ‘Nyo tabin fatabin pis rou Tsunia, e Tamanyo, Ayei na Tamamami, a Gov Tsonyo, Ayei na Gov tsumi’” ");
INSERT INTO sps_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ai Meri na muiny Magdala naa sa tsue of ir matisian to te tagei finy ya na Tsunaun, ai to kan te tsue of fi Ya na ka to. ");
INSERT INTO sps_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tana Sande tana voiny, rin matisian vaaguam to, ri pingping ot ir a tsivor tana saa ari te oraav ir fuainy tsoiny mumua tana taa Jiu. Ai Jisas naa mito sa tsutsun fapoopoan narari, sa tsue na ka, “Aaverof kaa fiisen maromi.” ");
INSERT INTO sps_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Te fakap yan vegiau Tsunia Ya faatok ratuari na niman ana ririkin Ya. Kat to ana rin matisian paparaa fiisok tsun rato te tagei fi ri na Tsunaun. ");
INSERT INTO sps_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ai Jisas tsue pis to tsuri, “Aaverof kaa fiisen maromi. To te jiats fi Vaminyo Tamanyo, jesan Nyo jiats kan maromi.” ");
INSERT INTO sps_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ayei te tsue iny a ka to, ana Ya fuas of ratuari sa tsue na ka, “Famanat iny yam Aaven taabos ma kaa Ya koma mami. ");
INSERT INTO sps_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Te anofe romi na fo aveto tana mes, u aveto to aya te anofe ravaa kan non. Sai te gim fi romi ma anofe na fo aveto tana mes, u aveto kan te gim non ma anofe ravaa.” ");
INSERT INTO sps_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Isen tsurin matisian, e Tomas (te koo rin Punaa) te gima kaa fiisen ramiri to te naa me Jisas. ");
INSERT INTO sps_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Arin mes matisian tsue of towa, “Amam te tagei a Tsunaun!” Tomas tsue to tsuri, “Ma tagei korei anyo na fo inir sos niman ya, ana nyo te taakan iny a karoor nau tana fo inir ari, nyo te saras a ririkin Ya nyo te faaman pas mami te tagei fi mi Ya.” ");
INSERT INTO sps_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Isen a wik te kap naa an matisian vaaguam to, ri pingping ot pis ratuari, ai Tomas kaa fiisen ramituari. Fo pingping fo siisiot tap, sai Jisas naa me, Ya tsutsun to fapoopoan narari Ya tsue to na ka, “Aaverof kaa fiisen maromi.” ");
INSERT INTO sps_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ana Ya tsue to ten Tomas, “Taakan iny a karoor nam nei, nyi te tagaa nima Vanyo, faarua me na nima nyi te saras a ririki Vanyo. Vaa'ets vaare nyi ma faaman tsun!” ");
INSERT INTO sps_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas biny Towa, “O Tsunaun tsonyo ana Gov tsonyo!” ");
INSERT INTO sps_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisas tsue to tsunia, “Fiisia, nyi faaman em tana saa nyi tagei bus Vanyo? Saf a faparits tsian to naa, ten sei na mes te faaman Varonyo, tabuiny tagaa Varonyo ri!” ");
INSERT INTO sps_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas kat a fo mes a fo binun iny faatok reits mata mamam fo matisian Tsunia sai te gima kirkir koman Buk tovei. ");
INSERT INTO sps_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Fo mar kirkir to te kaa en ma faaman ami, to Jisas, Ayei a Krais, a Mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy, a Guei Tsoiny ten Gov, ai to tan kat iny faaman, ami nai kaa mirom a toto na suu tana asangan Ya. ");
INSERT INTO sps_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Voun a ka to, Jisas faatok pis iny to na Tsivon tana tee ar matisian Tsunia tana naaman iny Taiberias. ");
INSERT INTO sps_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ayei te ruak tere Saimon Pita me Tomas (te koo rin Punaa) ai Nataniel (a isen to te poo fi me tana ngats fan iny Kena tana gum fan iny Galili) ana ina fuan a guei tsoiny ten Sebedi fiisen ramiri na mes a ina fuan a matisian ten Jisas te vaaguam faavot. ");
INSERT INTO sps_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita tsue to tana mesapan nar matisian, “Nyo nai nawaan rou.” “Amam naa fiisen mamirom anyi,” tsue fi ri tsunia. Ana ri naa to, ri jias to tan puak sai tana voiny a urung, ri sikia ma nom vaarik ta isen ta jian. ");
INSERT INTO sps_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tana voinyvoiny ovei te arasan me na nuaf, Jisas tsutsun moun poporos san matisian gim to ma natiny Ya, Ayei e Jisas. ");
INSERT INTO sps_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ana Ya tsue to tsuri, “Fuainy Guei, mi nom kainy ta jian?” Ri biny Towa ser tsue na ka, “Sikia, babainy.” ");
INSERT INTO sps_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ya tsue to tsuri, “Tats iny yam a muav tsumi tan panainy matou nan puak, ana mi te sauf ta tee ka.” Ana ri tats iny towa, ri nag iny raras tana saa ri sauf jian kinai fiisok. ");
INSERT INTO sps_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ana nyo, Jon, a matisian to Jisas te mangiir fiisok non ya tsue to ten Pita, “A Tsunaun vaa yei aa.” Nainy te nongoiny e Saimon Pita, “Ayei na Tsunaun,” ya pau to na tsivon vau iny jiarasan (tsunia te puruur faamuainy vau iny jiarasan tsuan) ana ya tsiak naa to naaman. ");
INSERT INTO sps_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","An mesapan tsurin matisian sung mito mats tan puak, ri tanik iny ras fasung mito na muav via men jian. Ari sikia ma veevian osing a teis, veevian toroman faarei non a isen a natus a mita. ");
INSERT INTO sps_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nainy te sung mi ri mats, ri tagei ton guaf gonif na aya ana jian kaa en tan gonif ana tee koinykoiny. ");
INSERT INTO sps_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ai Jisas tsue to tsuri, “Mei mi yam ta tee Jian te see sauf miromi.” ");
INSERT INTO sps_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita jias tan puak ana ya ras fasung to na muav via men jian kaatsian, as'as nan jian te onots a isen a natus an ngim safunuu ana fopis, te kaa men jian kinai fiisok koman a muav sana muav gim to ma tades. ");
INSERT INTO sps_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas tsue to tsuri, “Taami yam, ainy yam.” A sikia ta isen tsurin matisian ma ongoor to ma rangats Ya, “Anyi sei?” tana saa ari te natiny Ya, Ayei na Tsunaun. ");
INSERT INTO sps_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ai Jisas naa to nom ton koinykoiny sa faan rari ya ana Ya kat kan fi to tan jian. ");
INSERT INTO sps_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Fafofopis nan nainy to aya, te faatok iny a Jisas a Tsivon tan matisian, vou te fatoto fatabiny fi Ya Gov tana mat. ");
INSERT INTO sps_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Te fakap iny ainy ari, Jisas tsue to ten Saimon Pita, “Saimon, guei tsoiny ten Jon, nyi mangiir faman ovei Varonyo fis non mangiir te kaa mirorin mes matisian Tsonyo ge?” Ya biny Towa sa tsue, “Eye Tsunaun, Nyi natem nyo mangiir marom Anyi.” Jisas tsue to tsunia, “Makok ir fuainy tsunei siip Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisas fafuan iny tsue pis to tsunia, “Saimon, guei tsoiny ten Jon, nyi mangiir kan Varonyo?” Ya biny Towa sa tsue, “Eye Tsunaun, Nyi natem nyo mangiir marom Anyi.” Jisas tsue to tsunia, “Makok ir fuainy siip Tsonyo.” ");
INSERT INTO sps_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas fafofopis iny tsue to ten Saimon, “Saimon, guei tsoiny ten Jon, nyi mangiir kan Varonyo?” Pita reesik fiisok, tana saa Jisas fafofopis en tan rangats ya, “Nyi mangiir kan Varonyo?” ana ya tsue to Tsunia, “Tsunaun, Nyi natiny rom ma fo mamatsiny ka, ana Nyi natem nyo mangiir marom Anyi!” Jisas tsue to tsunia, “Makok ir fuainy siip Tsonyo. ");
INSERT INTO sps_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nyo tsue faman of marom anyi to te vurots anyi, nyi pous faparits iny pous tsumanyi nyi naa to tana mesapan kanen te komainy fi rom anyi ma naa, sai te tsokanei rom anyi mesmes a mes nai pous marom anyi; nyi nai faruaa iny rom a nimam ana ayei te nai ras manyi tana pan te baainy rom anyi ma naa.” ");
INSERT INTO sps_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Tan vegiau to aya, Jisas tsue faruak iny a mat ten Pita, ito na mat, te nai sab non ya, ma fapaas ari ya na asangan e Gov.) Ai Jisas tsue to tsunia, “Vovou you!” ");
INSERT INTO sps_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","To te taataan naa ri, Pita takopis faavou to ya tagei vatuanyo na matisian Jisas te mangiir fiisok non ya, ai to kan te fasiruu naa panan e Jisas te ainy amam tana taran, ana nyo rangat to, “Tsunaun, e sei to aya te nai faan marom Anyi nimar a vainy ma nai atsuiny Manyi ee?” ");
INSERT INTO sps_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nainy te tagei vanyo e Pita, ya tsue to ten Jisas, “Tsunaun, kat pas fei tana mes to aya ei?” ");
INSERT INTO sps_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas biny towa sa tsue na ka, “To te mangiir Anyo ya ma toto ya onot non tana tou tabin me Tsonyo, a sikia ma ka tsumanyi. Vovou tsun You!” ");
INSERT INTO sps_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","An vaanan saats vavis to fapoopoan nar vainy to te vovovou iny e Jisas, ito nyo, Jon, te gim non ma mat. Sen Jisas gima tsue na ka nyo gim rou ma mat, Ayei te tsue na ka, “To ma komainy Anyo ya ma toto ya onot non tan tou tabin me Tsonyo, a sikia ma kaa tsumanyi.” ");
INSERT INTO sps_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Anyo na matisian to te tagaa nyo pokei to na foka te ruak, ana nyo kan kirkir ratuari tan Buk tovei, ana ra natiny ror a fo vegiau te pokei iny anyon man ovei. ");
INSERT INTO sps_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Te kaa men a fo mes a fo mamatsiny ka te kat e Jisas. Ito ma kirkir iny ari na fo mamatsiny ka faavot, nyo pon iny rou a monaagits tovei gim non ma kaa me ta pan ma fakei ari na fo buk faavot to, tana saa buk tabuiny kinai fiisok ovei er. ");
INSERT INTO sps_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiofilas, tan vaamuan nan Buk te kirkir anyo te tsue tsuk iny non a foka te kat e Jisas ana foka te faatsuts iny Ya tan nainy te tanik Ya na fo binun Tsunia, ");
INSERT INTO sps_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","onot tan nainy te naa fi Ya Gormirmir. Tabuiny naa non Ya Gormirmir, Ya fa'arasainy towa tana parits tan Aaven Taabos tana vainy te pisainy Ya ser faarei men amaraav Tsunia. ");
INSERT INTO sps_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tan fats safunuun nainy voun a mat Tsunia, Ya faatok vavis iny to na tsivon tsuri ma vaa'ets vaare ri Tsunia te toto en ana Ayei tsue tsuk kan iny to na Waan e Gov. ");
INSERT INTO sps_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Te faavot mi ri ten Jisas, Ya tsue faparits of ratuari na fokinai, “Ami sikia rom ma naus osing tsom a Jerusalem, sana mi ma anaanos a fifaan tan tsuen man ten Tamanyo to te tsue of im yam. ");
INSERT INTO sps_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon peenainy mami tana aurom, sai voun a tee nainy te naa minon, Nyo nai peenainy maromi tan Aaven Taabos.” ");
INSERT INTO sps_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nainy te vaaguam faavot men guamaraav fiisen me Jisas ana ri rangats Towa, “Tsunaun, farainy te nom ravainy rom Anyi gumgum iny Roum, Nyi te faan fatabin ir ya na taa Isrel, tovei tsun roman, ge?” ");
INSERT INTO sps_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jisas tsue to tsuri, “Sikia ma kaa tsumi ma natiny ami ya to tan nainy ge na ingainy a ka tsun ten Tamanyo, Ayei patsukanen te fagum bus ya tana parits Tsunia. ");
INSERT INTO sps_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sana mi nai via mi nats rom a parits to te of maromin Aaven Taabos; ai mi te favaanan iny Vanyo tana ngats fan iny Jerusalem, an tana fo fan faavot tana gum fan iny Judia, ai tana gum fan iny Samaria, ai tana fo pan faavot tana monaagits to.” ");
INSERT INTO sps_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Te tsue fakap iny Ya na ka to, ai Gov nom finy naa Towa Gormirmir, ana ri matoong er Tsunia, ana painy koroo naa mito sa fatakop osing rari Ya mata rari. ");
INSERT INTO sps_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ri suu iny a matar tan matoong fi naa jias te naa fi Jisas Gormirmir gima potsian ana ina fuan a mes kaa men vau goseen kafof tsutsun to pana rari. ");
INSERT INTO sps_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ana ina fuan a mes tsue to, “Vainy iny Galili, kat fei tsumi tsutsun rom mi mamatoong fi emanaa korosuu ei? E Jisas to aya te nom osing mami Gov sa mei fi naa Ya Gormirmir tabin minon senviir tsun non to te tagei finy ami Ya te naa fi Ya Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","An amaraav tabin to tana ngats fan tsian iny Jerusalem poo fi me tana tobeer iny Oliv a veevian vaarik tana ngats fan. ");
INSERT INTO sps_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Te sof naa ri Jerusalem ri naa to tana pan jias te natiny kaa ror ere: Pita, ai Jon, ai Jemis, ai Anduru, ai Pilip, ai Tomas, ai Batolomiu, ai Matiu, ai Jemis a guei ten Alfias, ai Saimon, (Ayei na isen tsuri tana gum to te kat iny nom ravainy ror gumgum iny Roum), ai Judas, a guei ten Jemis. ");
INSERT INTO sps_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ri natiny vaaguam vaurep ror tan faakats fiisen kan ramirin moun, ai Meri tsinan Jisas, an fuainy famuinyasiny Tsunia. ");
INSERT INTO sps_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Voun a tee ar nainy vainy fafaaman vaaguam to onots sen natus an tangau, ai Pita tsun to sa tsue, ");
INSERT INTO sps_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Vamuinyasiny fafaaman tsonyo tsue tan Vegiau Ten Gov ruak iny man busen to tan Aaven Taabos pokei mi ya nguen e Devit tana ka te nai ruak nats non ten Judas te ras fi rarori yan vainy puaan ya te faatok rari Jisas. ");
INSERT INTO sps_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas ayei na isen tana gum tsura, tana saa, Jisas pisainy bus ya tana binun tsura.” ");
INSERT INTO sps_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas nom a painy moni foiny nan kat iring tsunia, sa foiny ya na painy puputaa to te gotsiny fi ya sa on fatsipaf iny tan puputaa ana koman ya takakaar faavot en an tsinai taruur faavot enato jiarasan. ");
INSERT INTO sps_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","A vainy te kaakaa Jerusalem nongoiny kainy a ka to aya; ser koo na painy puputaa to aya Akedama man nan ya Puputaa tan Rafatsiny.) ");
INSERT INTO sps_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita kat to sa tsue, “Te kirkir busen tan Buk iny Vadou, ‘Te rof non tana numaa tsunia ma kaa iny uur, ana sikia ta mes te nai kaa tsunia.’ An Vegiau Ten Gov kan te tsue kainy a ka, ‘Te rof non tan ta mes ma nom a binun tsunia.’ ");
INSERT INTO sps_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Sai tovei, te rof non tan nom taa isen to te tagaa iny matan te tsun fatabin fi Ya. Ayei kan te kaa fiisen ramira tan nainy viviakoo te taataan fiisen mira na Tsunaun e Jisas fapoopoan narara tanik tan nainy ten Jon a tsoiny fapeenan sa nai nom naa me tan nainy te tabin fi Jisas Gormirmir.” ");
INSERT INTO sps_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ri kat to ser nom a ina fuan a mes. Josep te koo ri Basabas mesa asangan ya Jastas, ai Matias. Ana ri vaaguam faavot to ser faan iny fakats tsuar ten sei te kaa non tan koman tsuri ee. ");
INSERT INTO sps_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ana ri faakats to ten Gov, ser tsue, “Tsunaun, Anyi natiny rom a aaver a fokinai. Faatok mamimam tana ina fuan to, e sei te bobot bus Anyi ee! ");
INSERT INTO sps_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","A tsoiny to aya nom non gumgum tan amaraav iton gumgum te naus osing e Judas sa naa fi en tana pan iny fasaraa unya Hel, a pan tsunia.” ");
INSERT INTO sps_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ri vovou iny kat tsuri tana sanaan iny nom mes. Asangan e Matias ruak ser as ya, ri faavot onots safunuu ana ina fuan a amaraav. ");
INSERT INTO sps_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Te ruak nainy iny faarof e Gov tan Tanun Foun, ge nainy guainy tana taa Jiu te koo rorin Pentikos vainy fafaaman vaaguam to tana isen a pan. ");
INSERT INTO sps_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sen tsun ana ka vuu faarei mito na ainysat a parits poo fi me jias, sa fapainy a numaa tana pan te gumgum ari. ");
INSERT INTO sps_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ri tagei na ka te faarein u mian tan guaf kurun, ya saats vavis to sa nai kaa toobing patsuu rarin isisen. ");
INSERT INTO sps_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","An isisen tsuri na fokinai via tsitapuu miton Aaven Taabos ser kat vegiau fafoofan Aaven Taabos favegiau rari. ");
INSERT INTO sps_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tan nainy to aya taa Jiu te kaa Jerusalem ana rin vainy fafaatouf te poo fi me tana fo gum fan vavis tana monaagits to. ");
INSERT INTO sps_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Te nongoiny arin goonen to aya ana fokinai vaaguam faavot to. Ri na fokinai fakakarian ir te nongoiny fi rin vainy fafaaman favevegiau ror tana fo vegiau fafoofan. ");
INSERT INTO sps_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ri saar fiisok ovei erato, “A vainy to te favevegiau ror poo fi me tana gum fan iny Galili! ");
INSERT INTO sps_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Saf a ka to na ra faavot onot ror ma nongon rari kat ror vegiau tsura fatoobing. ");
INSERT INTO sps_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mam poo fi me tana gum fan Patia, ai Media, ai Elam, ana mesapan iny Mesopotemia, ai Judia, ai Kapadosia ana mesapan poo fi me Pontas, ai Esia, ");
INSERT INTO sps_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, ai Pamfilia, ai Ijip, an tana fo pan iny Libia panan a Sairini, ana mesapan tsura kan poo fi me Roum, ");
INSERT INTO sps_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ara na Jiu an vainy sikia ma taa Jiu takopis fi er tan fafaatouf tana taa Jiu, ana mesapan tsura kan iny Krit, ai Ereb, sana ra faavot nongon rari te favaanan fiisen me na parits tsian ten Gov tana ngue rara fatoobing!” ");
INSERT INTO sps_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ri na fokinai saar ser fapinpin ri fararangat fatabin ir, “A saf a man nana ka to na?” ");
INSERT INTO sps_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sana mesapan taring rarin vainy fafaaman ser tsue, “Ri jiu fiisok ser mafuu.” ");
INSERT INTO sps_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ai Pita tsutsun to fiisen ramiri na safunuu ana isen a amaraav, ya kuu to sa tsue tana fokinai, “Ami na taa Jiu ana mi na fokinai to te naa me nei Jerusalem nyo komainy fa'arasainy rou a ka to tsumi, vanongon faarof yam tana ka te tsue iny ronyo. ");
INSERT INTO sps_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Amam sikia ma jiu mam te mafuu to te buk fi romi. Te see sia na kilok tsun non tana voinyvoiny! Kat tana taa Jiu sikia ror ma jiu tana voinyvoiny. ");
INSERT INTO sps_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sana ka to aya te tsue fakap bus iny a kuigin e Joel sa tsue: ");
INSERT INTO sps_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tan fafakap nan nainy tsue fi Gov, Nyo nai tsiiu nats iny rou Aaven Taabos Tsonyo patsuur vainy faavot. U guei tsoiny an guei moun tsumi nai favaanan ror, an vurots tsumi nai tagei ror a man nane Gov tan taraa tsuri te tagun farokot fi rori. An tsokanei tsumi nai tagei ror a man nane Gov tan taraa tsuri te goros fi rori. ");
INSERT INTO sps_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ai tsuri kan vainy binun Tsonyo, tsoiny an moun Nyo nai tsiiu iny nats rou Aaven Taabos Tsonyo tana fo nainy tuwa aya, ana ri te favaanan nats. ");
INSERT INTO sps_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Anyo nai faatok nats rou ta foka ta karap iny faatok jias korosuu an ta ka iny faatok nei peto tan puputaa, rafatsiny an guaf an um tsian ruak ror. ");
INSERT INTO sps_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A nuaf nai takopis non ana ayei te uurup ana iifaa nai ruak iny goutsiroun non faarei non rafatsiny foka to te ruak faamuan non tan nainy fafakap, vou an Nainy tsian an siinaiv tana Tsunaun te naa bus me. ");
INSERT INTO sps_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ai sei te komainy non tagtag ten Gov te sing fi non ya tana Asangan a Tsunaun ee, a Tsunaun nai saup fatabiny non ya.’ ");
INSERT INTO sps_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ami na taa Isrel, nongon yam tan vegiau tovei! E Jisas iny Nasaret Ayei na mes Gov fainy Yan gumgum ma kat a fo mamatsiny ka na fo karap iny faatok tana parits ten Gov fapoopoan namami to te nat fi romi. ");
INSERT INTO sps_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tan mangiir ten Gov an tana nat Tsunia sa faan iny a mes to nima mami ana mi atsuiny Towa, sam faan iny naa Ya tan vainy aveto ma fagageits ari Ya tana pagafuan. ");
INSERT INTO sps_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sen Gov fatsuiny fatabiny Ya tana mat sa fatafuts Ya tana kamits iny mat, tana saa a mat sikia ma onot ma kotskots tap iny Ya. ");
INSERT INTO sps_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","E Devit tsue bus iny Ya, ‘Anyo tagei na Tsunaun te tsutsun non mata vanyo tan mamatsiny nainy. Ayei kaa non tan panaainy matou tsonyo, to aya na ka te faakouts varonyo ai te faparits vanyo tan nainy iring. ");
INSERT INTO sps_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","A koma vanyo paparaa fiisok tsun en ana mia vanyo vegiau iny non a mamagat, ana pua vanyo nai favusuan faarof non nyo te naano anaanos tana saa nyo faason rou ten Gov an fo tsuen man Tsunia tana foka te nai ruak ror vou, ");
INSERT INTO sps_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tana saa, Nyi gim rom ma tanyiny na aave vanyo ma kaa ya fiisen ramiri te mat buser ge ma fatamee iny a Tsoiny Binun a Taabos Tsuam ma kaa Ya tana pan a kuav tan katskats. ");
INSERT INTO sps_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nyi fanat bus vanyo na sanaan te naa non tana pan tana toto na suu ana Nyi nai favei varonyo na mamagat tana pan to aya, tana saa nyo kaa fiisen vamirom Anyi.’” ");
INSERT INTO sps_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ai Pita tsue pis to, “Vamuinyasiny fafaaman tsonyo, anyo komainy fa'arasainy rou ya tsumi, e Devit a tsuvurara te mat en ser kats iny ya an katskats tsunia kaa non tovei roman. ");
INSERT INTO sps_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Sana ayei na kuigin kan ana ayei natiny non tsuen man te kat e Gov tsunia: Gov tsue faman iny a ka fiisen men tsue man non jias tana isen a tsubnaain e Devit fatoobing nai aatouf nats non ana ayei te nai kaa tan tagan tsunia. ");
INSERT INTO sps_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","E Devit natiny a ka te kat nats non e Gov, to sa tsue tsuk iny a tou tsun fatabin tana mat ten Krais, ‘te gim non ma kaa fiisen men vainy te mat buser ana puan Ya gim non ma kuav tan katskats.’ ");
INSERT INTO sps_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Gov fatsuiny fatabiny e Jisas tana mat ai tovei mam a fokinai te tagei e Jisas te toto fatabin fi Ya vou na mat Tsunia. ");
INSERT INTO sps_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ayei tsun fatabin sa nai gum en tan panaainy matou nane Gov a Taman Ya. Jisas nom Aaven Taabos ten Taman kat fi non tsuen man tana saa te tagei romi ai te nongoiny romi roman, ayei na fifaan te tsiiu iny mi Ya tsumam. ");
INSERT INTO sps_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit gima naa Gormirmir, sana ayei tsue, ‘A Tsunaun e Gov te tsue tana Krais a Tsunaun tsonyo, Gum nei tan panaainy matou Tsonyo, ");
INSERT INTO sps_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","onot non te fakei finy Ronyon fo vainy te koma iring marom Anyi er kaa to fain a mou Manyi.’ ");
INSERT INTO sps_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Te kat fi non nei amin vainy iny Isrel ma nat fi nei; e Jisas to te fagageits ami tana pagafuan, Gov kat Ya sa Tsunaun non ana Ayei kan a Krais a mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy.” ");
INSERT INTO sps_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nainy te nongoiny a vainy a ka to an vegiau sak fatoobing to na aave rari ser tsue na ka ten Pita ana mesapan tsurin amaraav, “Vamuinyasiny, a saa te kat romam na?” ");
INSERT INTO sps_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ai Pita tsue to tsuri, “Reesik yam, am takopis osing to na fo aveto tsumi ana mi te tap ten Gov, ana mi te peenan tana asangan e Jisas Krais, ai Gov te anofe ravainy aveto tsumi, ana Ayei te faan mamin fifaan tan Aaven Taabos. ");
INSERT INTO sps_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gov kat tsuen man ma faan iny mi Yan Aaven Taabos tsumi an fuainy guei tsumi, ai tsuri kan vainy veevian, ana ri faavot to te fikoo na Tsunaun e Gov tsura ma naa me Tsunia.” ");
INSERT INTO sps_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita tsue faparits of ratuari ana fo mes a fo vegiau kan iny fanongon rari; sa tsue, “Tanamots a tsivom tana fasaraa te nana minon tan aatai iring tovei.” ");
INSERT INTO sps_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ri na vainy faarof vegiau ten Pita ser faaman ri peenan to, sa onots toromainy fopis tapan, san as'as te paas pis tan nainy to aya. ");
INSERT INTO sps_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ri kaa faavot fiisen men guamaraav ser nom fifaatsuts tsuri, ai tana tou vivangura tsuri, ai tana tou ivivoon koinykoiny kan tan fakats fatabiny e Jisas, ana tou faakats. ");
INSERT INTO sps_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Vainy fafaaman faavot te saar ir tan nainy te kat amaraav ka na kinai iny faatok reits ana fo binun saar iny faatok. ");
INSERT INTO sps_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Rin vainy fafaaman sikia ma faravaa tan kaa faavot, ai tan tatafas iny a foka fapoopoan narari. ");
INSERT INTO sps_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ri fafiifoiny iny a foka tsuar ri nom ton moni ser faan rari ya te kakat ror. ");
INSERT INTO sps_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tan mamatsiny nainy ri natiny kaa faavot ror faarei ror a gum tana saape tana taa Jiu. Ri natiny ivivoo ror koinykoiny tana tou fakats fatabiny e Jisas koman a fo numaa tsuar ana ri te ainy kainy ainy iny vivangura faavot fiisen men sen koman ana paparaa aave rari. ");
INSERT INTO sps_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mamatsiny nainy ri natiny fapaas ror a Asangan e Gov fiisen men koma rof an mamagat tana vainy faavot. Tan mamatsiny nainy Tsunaun natiny fakorots non as'as tana vainy te saup fatabiny Ya. ");
INSERT INTO sps_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tan sen nainy tana fopis a kilok tana touraf, Pita me Jon naa fi to tana saape tana aua iny faakats. ");
INSERT INTO sps_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A mes agiir me a moun ya na mat natiny govets finy naa rori tana pan te koo ri, Matainy Sobaa Na Saavits nana saape natiny fagum rori ya te sing maamaa ta ka tana vainy tan mamatsiny nainy. ");
INSERT INTO sps_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tan nainy te tagei ya Pita me Jon te sof naa ana ayei sing to Pita me Jon ma fainy ari ya ta painy moni. ");
INSERT INTO sps_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ri kat to ser matoong fatoobing naa to tsunia ai Pita tsue to, “Matoong me tsumam!” ");
INSERT INTO sps_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ana ayei matoong ratuari ayei pon fi nei ri na ina fuan komainy faan iny ror ta ka tsunia. ");
INSERT INTO sps_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kat to ai Pita tsue to tsunia, “Anyo sikia ta painy moni, sana anyo faan marom anyi na ka te kaa mironyo: tana asangan e Jisas tana ngats fan iny Nasaret nyo tsue of marom anyi, tsun, nyi te taan!” ");
INSERT INTO sps_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ya nom to tan nimainy matou tsunia na mes to aya ya ras fatsuiny towa. Sen tsun ana moun a mes to parits fatabin bus enato. ");
INSERT INTO sps_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ayei tsiak to jias, tsutsun to moun ana ayei tanik iny taan to. Kat to ana ayei sof fiisen ramituari gagon tana saape, taan non ya tsiak en variri non e Gov. ");
INSERT INTO sps_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ana gum iny vainy tagei towa te taan fi ya ana ya variri en ten Gov, ");
INSERT INTO sps_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ai tan nainy te inainy ari ya, ayei na mes te gumgum tana “Matainy Sobaa Na Saavits” tana saape, ri karian ser saar rato tana ka te ruak tsunia. ");
INSERT INTO sps_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tan nainy te nom tap ya ten Pita me Jon, vainy a kinai fakakarian ri kookuar naa to tsuri tana saparoon tana saape te koo ri Saparoon Ten Solomon. ");
INSERT INTO sps_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Te tagei e Pita na vainy ya tsue to tsuri, “Amin vainy Isrel, kat fei sa mi karian iny a ka to ei, ana saa te matoong romi tsumam na? Mi pon iny rom a parits te kaa miromam ge tana ka iny tavaron tsumam matan e Gov to sana mam kat a mes to sana ayei taan en? Sikia, e Jisas te tsipaar ya. ");
INSERT INTO sps_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","E Gov ten Abraham me Aisak ai Jekop, ana Ayei kan a Gov tan fo tsuvurara ana Ayei kat to na foka to aya iny faatok, Jisas kaa minon gumgum iny vamarits Ayei na Tsoiny Binun Tsunia. E Jisas to aya te faan iny naa mi ma atsuiny famat ari Ya. Mi tsugei Ya matan e Pailat. Pailat pon ma puruur Ya sana mi baainy em. ");
INSERT INTO sps_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ayei na Isen a Taabos ana Tavaron, sana mi tsugei Ya mi komainy e Pailat ma vovou iny mangiir tsumi to sam komainy ma puruur e Barabas a mes to na fifitokon. ");
INSERT INTO sps_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mi kat to sam atsuiny a mes to te kifon iny non a toto na suu. San e Gov fatsuiny fatabiny Ya tana mat ana mam tagei e Jisas te toto fi Ya voun a mat Tsunia. ");
INSERT INTO sps_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A parits tana asangan e Jisas to te faparits a mes to na mou mat a pin iny taan. A ka to te tagei ami, mi natiny towa te kat amam tana faason te kaa miromam tana asangan Ya ai tana faason tsumam ten Jisas to sa kat faarof a mes to mata mami fokinai. ");
INSERT INTO sps_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Sai tovei, fo vamuinyasiny tsonyo, nyo natiny rou a ka te kat ami fiisen kan men tsoiny mumua tsumi ten Jisas, mi kat ya tan fakats tsumin onanun, ");
INSERT INTO sps_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","sai tan kat to ayei Gov pokei faruak iny a man nana ka te pokei iny fuainy kuigin Tsunia muan, ten Krais a mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy nai saraa kamits non. ");
INSERT INTO sps_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Reesik yam, am naus osing ton kat iny aveto tsumi am takopis to ana mi te tap ten Gov ma anofe Yan aveto tsumi. ");
INSERT INTO sps_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mi tsikoiny kat fi rom nei, Tsunaun faan iny non nainy iny faparits fo aave mami. Ayei faan pis iny naa Jisas a mes te pisainy e Gov ma Tsoiny Fiisaup Ya tsumi. ");
INSERT INTO sps_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ana Ayei kaa non Gormirmir onot non tan nainy te ruak fafoun non mamatsiny ka te tsue faman bus iny e Gov san kuigin taabos pokei ya muan, ");
INSERT INTO sps_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","tana saa Moses te tsue, ‘A Tsunaun e Gov tsumi nai jiats minon a isen a kuigin, faarei te jiats fi vaminyo Ya, ana Ayei na isen a mes tana vainy tsumi na taa Jiu fatoobing. Ana mi ma nongoiny a fo mamatsiny ka te tsue of maromi Ya. ");
INSERT INTO sps_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","E sei tsumi te gim non ma nongoiny a ka te tsue non Ya ee ri nai nom ravainy nats ror ya tana vainy Tsunia ana Ayei te kat fiiring nats ya.’ ");
INSERT INTO sps_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel a kuigin ana fo kuigin kan to te ruak vovou me tsunia, ari na fokinai te kaa me na fo vaanan iny pokei a foka te ruak nats non tan nainy roman. ");
INSERT INTO sps_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","An tsuen man ten Gov te pokei iny kuigin, a fo vegiau to te naa of mamimi, mi kaa kan koman tsuen man te kat e Gov tan tsuvumami. Ayei te tsue of e Abraham sa tsue, ‘Tan fo tsubnaain tsumanyi fatoobing Nyo nai faparits rou a fokinai vainy tana monaagits to.’ ");
INSERT INTO sps_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tan nainy te fatsuiny e Gov a Tsoiny Binun Tsuan tana mat, Ayei jiats faamuan naa Ya tsumi ma faparits mami Ya, Ayei te kat mami mi te takopis osing kat iny ngi'arapaar tsumi.” ");
INSERT INTO sps_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita me Jon vegiau kaner raror tana vainy an fo tsoiny faakor tana taa Jiu an tsoiny mumua tana fo tsoiny bei ot tana saape ana mesapan tana taa Sadusi ruak to tsuri. (Sadusi a gum tana taa Jiu to te natiny tsue ror a sikia ta tou tsun fatabin tana mat.) ");
INSERT INTO sps_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ri faavot peits ir a ina fuan a amaraav, tana saa, ri faatsuts ir a vainy ten Jisas te tsun fatabin en tana mat sa faatok iny non a ka vainy mat te nai tsun fatabin ror tana mat tsuar. ");
INSERT INTO sps_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ana ri kat to ser nots ir a ina fuan, ri fasof ratuari tana numaa iny kotskots ana ri kaa to gagon sa onots mes nainy, tana saa, te touraf busen. ");
INSERT INTO sps_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sana ri na fokinai nongoiny vaanan ten Pita, ri faaman to an as'as nar vainy onots toromainy to na ngim a tapan. ");
INSERT INTO sps_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ai tan mes nainy fo tsoiny mumua tana taa Jiu an tsunaun tana taa Jiu fiisen ramirin fo tsoiny faatsuts tan Faun te kirkir iny e Moses vaaguam faavot to tana ngats fan tsian iny Jerusalem. ");
INSERT INTO sps_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","E Anas a Tsoiny Mumua Tan Tsoiny Faakor fiisen kainy me Kaiafas, ai Jon ai Aleksanda, an mes panair numaa iny guei tana Tsoiny Mumua Tan Tsoiny Faakor ");
INSERT INTO sps_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","nom ir a fuan a amaraav to, ri fatsutsun ratuari matan, ser rangats rari na ina fuan, “Fei te nom ami na parits to te kat ami na ka to ei, ge na asangan e sei to tsumi kat a ka to?” ");
INSERT INTO sps_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita via men Aaven Taabos biny ratuari sa tsue, “Tsoiny mumua an tsunaun tana vainy! ");
INSERT INTO sps_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","To ma rangats ami mam tana ka na rof to te ruak tana mes a mou mat a gima natiny taataan ai to te kat fi ya sa rof fatabin ei, ");
INSERT INTO sps_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ami ma nat faarof, min fokinai vainy Isrel, a mes to te rof fatabin sa tsutsun non mata mami ito tsun kan tana parits tana asangan e Jisas Krais a tsoiny Nasaret. Jisas, Ayei na mes te atsuiny famat ami mi fagageits Towa tana pagafuan, sen Gov fatsuiny fatabiny Ya tana mat. ");
INSERT INTO sps_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ai koraa Jisas to te kirkir iny Vegiau Ten Gov sa tsue fi nei, ‘A fats a marats to te tsugei fuainy tsoiny fatsun numaa ruak faarei na fats a karap ovei tana numaa.’ ");
INSERT INTO sps_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ai tsun Tsivon onot non ma saup fatabin rara sikia pis ta mes tana monaagits faavot, Gov faan rara na asangan e Jisas tsun ma saup fatabin rara Ya.” ");
INSERT INTO sps_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ana fokinai tana gum tan tsoiny tsian vaaguam to ser saar ir, tana saa, Pita me Jon gima oraav ana ri na ina fuan kan gima nom tu faatsuts tsian. Ri nat fi to nei ari na ina fuan a mes to te kaakaa fiisen me Jisas. ");
INSERT INTO sps_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sana ri sikia ma onot ma tsue ta ka, tana saa a mes to te kat faarof ari tsutsun kan enanon fiisen me Pita me Jon. ");
INSERT INTO sps_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ri tsue of ratuari na ina fuan ma tafuts osing ari na pan te vaaguam arin fuainy tsunaun, ri favevegiau patsukan rato fapoopoan narari, ");
INSERT INTO sps_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Saf ta ka te kat rora tana ina fuan a mes to na?” rangat fi ri. “A fokinai kaakaa ror Jerusalem nat ror tana ka iny faatok te kat ari, ana ra kan gim ror ma faungis. ");
INSERT INTO sps_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","San tan kat tap iny a ka to ma saats vavis vaare ri ya na vainy, ara ma tsue faparits of irari na ina fuan ma gim ari ma vegiau me ta mes tana asangan e Jisas.” ");
INSERT INTO sps_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ri kat to ser fikoo fasof fatabiny rari na ina fuan, ri tsue faparits of ratuari ma gim ari ma vegiau tan ta mes ge ma faatsuts vaare ri na asangan e Jisas. ");
INSERT INTO sps_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sen Pita me Jon biny rari ser tsue, “Ami patsukanem ma faaroiny a ka te toobing non matan e Gov, tsumam ma nongoiny mami ge mam ma nongoiny e Gov. ");
INSERT INTO sps_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mam gim on rom ma faonot tan tsue faruak iny a foka te tagei fatoobing amam ana foka kan te nongoiny amam.” ");
INSERT INTO sps_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","An tsunaun tsue faparits of pis ratuari, ri kat to ser tsue of rari ma naa. Ri gima sab ta ka ta iring ma kat ari to ma nom ari tu fasaraa, tana saa, vainy te faatouf e Gov tana ka te tagei ari te ruak. ");
INSERT INTO sps_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A mes to te tsipaar ari sa toto te onots non fats safunuu na ingainy. ");
INSERT INTO sps_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Voun nainy te tafuts ari, Pita me Jon tabin fi naa to tana gum iny vainy tsuar ser fafaatai rari tan tsue te kat fo tsunaun tan tsoiny faakor tana taa Jiu an ri kan tsunaun tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Te nongoiny arin tsue to ri faakats faavot to ten Gov, “Tsunaun a Gov siireits, Nyi kat a Gormirmir ai nei petoo ana namaan an fo mamatsiny ka te kaa ror tsuri. ");
INSERT INTO sps_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tan Aaven Taabos Nyi vegiau of to tsuvumamam e Devit, a tsoiny binun Tsuam, sana ayei tsue, ‘Kat fei sana vainy sikia ma taa Jiu peits fiisok ei? Kat fei ser kat tanuu babainy ei? Tana saa, ri gima onot ma fabiu na Tsunaun. ");
INSERT INTO sps_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","A fo gotouf tana monaagits to an tsoiny mumua tana vainy vaaguam, ser kakouiny a tsivor ma fataatsun fiisen mi ri na Tsunaun ai Krais Tsunia, ito na mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy.’ ");
INSERT INTO sps_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sa man kanen Herot me Pontias Pailat gum faavot tana ngats fan tsian to fiisen kan ramirin vainy sikia ma taa Jiu ana taa Isrel, ri takopis ser kat fifiiring e Jisas a Tsoiny Binun a Taabos Tsumanyi to te kat Anyi ma Tsoiny Fiisaup Ya tana vainy. ");
INSERT INTO sps_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ri vaaguam ser kat a ka te fatangan bus iny Anyi ma kat ari, tana saa, ayei tanuu bus iny a foka te ruak tan mangiir ana parits Tsumanyi. ");
INSERT INTO sps_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sai tovei Tsunaun Nyi nat em tan tsue tap te kat ari, Nyi natiny famanat maromam tsoiny binun ma favaanan iny amam vaanan Tsumanyi fiisen me na parits ana ongoor. ");
INSERT INTO sps_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nyi ma karats a nima Manyi tsipaar, ana Nyi te faan iny me na foka iny faatok reits ana fo kan karap te tagei rori, ana fo binun saar iny faatok ma kat amam tana asangan a Tsoiny Binun Tsumanyi na Taabos e Jisas.” ");
INSERT INTO sps_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Te faakats fakap ari ana pan te vaaguam ari tatagut nato. Ri na fokinai via men Aaven Taabos, ri tanik iny favaanan fiisen mito na parits ana ongoor. ");
INSERT INTO sps_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Vainy fafaaman kaa tsun men sen fakats aave rari. A sikia ta isen tsuri ma tsue ayei tsun fasito iny non a fo mamatsiny ka tsuan, sana ri faavot fikavuu iny rora foka to. ");
INSERT INTO sps_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","An fo amaraav binun fiisen mito na parits ri favaanan iny to na tou tsun fatabin ten Jisas tana mat. Sen Gov faan iny koma ree'un tsian tsuri faavot a fokinai. ");
INSERT INTO sps_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","A sikia ta mes fapoopoan nana gum nar vainy fafaaman to ma kakat iny ta isen ta ka, tana saa, sei tsuri te kaa men tanun ge na numaa ee ri fafiifoiny iny ya, ");
INSERT INTO sps_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ri mei me na painy moni ri faan ratuari amaraav ma tatafas rariri te kakat iny ror ta foka. ");
INSERT INTO sps_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josep a isen a tsoiny tana vun ten Livai te agiir Saipras, an amaraav natiny koo ror ya Banabas, tana saa a man nan asangan to “Mes natiny faparits non a mesmes,” ");
INSERT INTO sps_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ayei fafiifoiny iny a painy petoo tsuan, ya nom to na painy moni sa faan rarin amaraav. ");
INSERT INTO sps_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sana isen a mes te koo ri Ananaias, ai natsun ya koo kainy ari Safaira, ayei fafiifoiny iny painy petoo tsuri. ");
INSERT INTO sps_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ai Ananaias faan iny to na painy moni pon fi rori nei, ayei te faan fakap iny ya, sana ayei famuiny a mesapan. Ai natsun ya nat en, ya faan seerep iny naa ton mes panainy painy moni unya tan guamaraav. ");
INSERT INTO sps_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita tsue to tsunia, “Ananaias, kat fei sa nyi famanat iny e Satan ma sof ya na aave manyi ei, nyi gam ton Aaven Taabos to te famuiny finy nyin mes panainy painy moni nyi nom towa tan petoo te fafiifoiny iny anyi. ");
INSERT INTO sps_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tan nainy tabuiny fafiifoiny iny rom anyi ya nyi fasito iny ton petoo to, ai to te fafiifoiny fi nyi ya nyi fasito iny to na painy moni to. A saa te fakats ma kat of anyi na ka to na? Nyi gima gam ir a vainy tsun, san e Gov.” ");
INSERT INTO sps_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Te nongoiny e Ananaias vegiau to, sen tsun ya gotsiny to peto sa mat en ana ri na fokinai to te nongoiny a ka to oraav fakap kan rato. ");
INSERT INTO sps_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","An vainy vurots sof to ser nai pau a puan yan raarav, ri govets fatafuts naa towa ser kats iny ya. ");
INSERT INTO sps_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Vou na fopis a aua te kap naa ai natsun ya sof mito sikia ma natiny a ka te ruak ten natsioiny ya. ");
INSERT INTO sps_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita tsue to tsunia, “Nyi ma tsue of vanyo, fiisia a painy moni to aya te nom ami me natsiom tan petoo te fafiifoiny iny ami, ayei na painy moni te faan fakap ovei iny naa mi?” “Eye, a painy moni na urung,” te tsue fi ya. ");
INSERT INTO sps_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita tsue to tsunia, “Kat fei sa mi me natsiom pon ma gam iny Aaven Taabos tana Tsunaun ei? Mi sikia ma oraav fasaraa ten Gov? Sai tovei, a vainy kats iny me natsiom te tsutsun ror tan matainy sobaa ana ri kan govets kainy marom anyi.” ");
INSERT INTO sps_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sen tsun ya gotsiny naa to putaa moun e Pita ana ya mat enato. Rin vainy vurots sof mito gagon ser govets fatafuts naa ya, ri kats iny towa panaan e natsioiny ya. ");
INSERT INTO sps_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ana fokinai gum nar vainy fafaaman faavot ana mesapan kan nongoiny a ka to ser oraav fakap er. ");
INSERT INTO sps_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Fo mamatsiny kainy faatok reits ana fo binun saar a kinai te ruak fapoopoan nar vainy nimar guamaraav. Rin vainy fafaaman natiny vaaguam ror tan Saparoon Ten Solomon tana saape. ");
INSERT INTO sps_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Rin mes vainy vavaajets oraav to ma sof irari, kainon to te famaari finy rori vainy fafaaman. ");
INSERT INTO sps_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sana ri na fokinai vainy sofsof ir gum nar vainy fafaaman ri faaman to tana Tsunaun. ");
INSERT INTO sps_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ai tan kat tan guamaraav to aya vainy a kinai mei miton vainy faadis ser farosoo rari sanaan, ri fasooiny ratuari tan fo mar fetan an nenengan ma taataan tsun me Pita ana aaven ya te tsiny rari, ri te rof fatabin. ");
INSERT INTO sps_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","An fo tagin kinai naa mito poo fi me tan fo mar ngats fan iny Jerusalem, atou aton ir vainy faadis ana ri na mesapan sofsof ir masarau ana ri faavot tsipaar rato. ");
INSERT INTO sps_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kat to ana Tsoiny Mumua Tan Tsoiny Faakor tana taa Jiu fiisen ramirin fuainy fafaakouts nan ito na vainy tana gum tan vainy Sadusi fitsufainy ramiton guamaraav. ");
INSERT INTO sps_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ri nots ir guamaraav ser fasof rari tan numaa iny kotskots. ");
INSERT INTO sps_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sai tana voiny to aya morena tana Tsunaun pue ton matainy sobaa nana numaa iny kotskots ya fatafuts ratuari jiarasan, ");
INSERT INTO sps_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kua yam am nai tsutsun to tana saape, am tsue of rato na vainy tan fo mamatsiny ka tana toto na foun to ayei.” ");
INSERT INTO sps_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ana ri nom ton tsue tana morena ri sof to tana saape tana patsuu na nainy ser tanik iny faatsuts ir a vainy. Kat to ana Tsoiny Mumua Tan Tsoiny Faakor tana taa Jiu fiisen men fafaakouts nan fikoo vaaguam raton fuainy tsunaun tan tsoiny faakor an tsunaun tana taa Jiu an tsoiny mumua tana taa Farasi an tsoiny mumua tana taa Sadusi koo rorin Kansol ge Sanhedrin, ser faan iny naan tsue tana numaa iny kotskots ma mei mirin guamaraav nei tsuri. ");
INSERT INTO sps_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","San tan nainy te ruak men tsoiny bei ot tana saape tana numaa iny kotskots ri gim to ma sab ir guamaraav ana ri tabin fatabin rato tan vaagum tsurin Fuainy Tsunaun tan Kansol ser fafaatai rari tana ka te ruak. ");
INSERT INTO sps_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ana ri tsue to tsuri, “Tan nainy te ruak naa mam tana numaa iny kotskots mam sab fo matainy sobaan pingping faparits fiisok fiisen ramirin tsoiny bei ot tsutsun ror tan fo matainy sobaa sai to te pue mam fo matainy sobaa, mam sikia ma tagei ta isen gagon.” ");
INSERT INTO sps_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tan nainy te nongoiny tsoiny mumua tan tsoiny bei ot tana saape ana rin tsunaun tan tsoiny faakor tana taa Jiu a ka to ser fakats fakinai er. ");
INSERT INTO sps_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ana mes sof mito sa tsue, “Nongon yam, a vainy to te fakei ami koman na numaa iny kotskots tsutsun ror gagon koman a saape fafaatsuts raror a vainy.” ");
INSERT INTO sps_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sana tsoiny mumua tan tsoiny bei ot tana saape naa fiisen ramen tsoiny bei ot tsunia ser nom fatabin ramen guamaraav. Ri gima rapits ir guamaraav tana saa ri te oraav ir a vainy kat ror ser totouruei rarin fats. ");
INSERT INTO sps_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ri mei men guamaraav gagon ser fatsutsun rari matar Fuainy Tsunaun tan Kansol. Ana Tsoiny Mumua Tan Tsoiny Faakor tana taa Jiu rangat ratuari. ");
INSERT INTO sps_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Mam tsue tap faparits of maromi ma faatsuts iny vaare na asangan a Mes to,” te tsue fi ya. “Sai tovei tagaa yam tana foka te kat ami! Mi saats vavis faavots fo ngats fan tsian Jerusalem fafaatsuts iny fifaatsuts tsuam, to sana mi pon rom ma sak mamam tana mat Tsunia!” ");
INSERT INTO sps_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita an mes guamaraav biny fatabiny ratuari, “Mam manaats rom ma vovou iny e Gov, sikia ma vainy. ");
INSERT INTO sps_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","E Gov tan fuainy tsuvurara te fatsuiny fatabiny e Jisas tana mat vou mi atsuiny Towa to te fagageits fi mi Ya tana pagafuan. ");
INSERT INTO sps_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Gov nom finy naa Towa jias sa fakei Ya tana pan iny fatsiitsii tan panaainy matou Tsuan, ana Ya faarei to na Tsoiny Mumua ana Tsoiny Fiisaup ma kat rara Ya na taa Isrel ma takopis osing aran aveto tsura, ana Ya te anofe ravainy fo aveto tsura. ");
INSERT INTO sps_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mam tagei a man nana foka to te kat e Gov, to tsumam favaanan iny rom ya an Aaven Taabos kan faatok iny a man nana ka to te faan bus iny e Gov tana vainy te manaats ror vegiau Tsunia.” ");
INSERT INTO sps_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nainy te nongoiny Fuainy Tsunaun tan Kansol vegiau to, ri sewaar fiisok tsun ir guamaraav ser pon ma atsuiny famat rari. ");
INSERT INTO sps_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sana isen tsurin a taa Farasi koo rori Gamiliel a tsoiny fifaatsuts tan Faun ana vainy faavot natiny fatsiitsii fiisok ror ya tsutsun to sa tsue of rari ma fatafuts tsom ir guamaraav jiarasan. ");
INSERT INTO sps_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kat to ana ya tsue to tan Fuainy Tsunaun tan Kansol tana taa Jiu, “Mi na taa Isrel, tamomots yam kat te komainy kat romi tan guamaraav to. ");
INSERT INTO sps_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","I muan, Tiudas tsun sa tsue, ‘Anyo na mes a karap’, to san fats a natus mes vovovou iny ya. Sana ri atsuiny famat ya ana vainy to te vovovou iny ya bus vavakas rato sana binun tsunia nai kajiaa babainy enato. ");
INSERT INTO sps_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Voun nainy to aya te nonom a gamaman asangar a vainy, Judas a tsoiny Galili tsun sa ras ir mes panan vainy ma vovou iny arin fakats tsunia, sana ri kan atsuiny famat ya ana tee vainy tsunia bus vavakas kan rato. ");
INSERT INTO sps_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Sai tovei nyo tsue of maromi kat vaare yam ta fo kat tan guamaraav to tanyir yam, tana saa iton fo tanuu ana fo binun tsuri poo minon tana mes, foka to nai kajiaa enanon. ");
INSERT INTO sps_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Sana fo binun to te poo minon ten Gov mi biu emarom! Kat rom sam fitaatsun fiisen me Gov!” Sana rin Fuainy Tsunaun tan Kansol tana taa Jiu vovou iny fakats ten Gamiliel. ");
INSERT INTO sps_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ri fikoo ir guamaraav gagon ser rapits rari, ri tsue tap raton guamaraav ma tsue tsuk vaare rin a asangan e Jisas to ser famanat rari ma naa. ");
INSERT INTO sps_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Rin guamaraav naus osing raton Fuainy Tsunaun tan Kansol ser via tsitapuu men mamagat tana saa, Gov fakats fiisok tsun rari sa tamainy non kat iny govets kamits an rejiaf tana asangan e Jisas. ");
INSERT INTO sps_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ai tan mamatsiny nainy ri natiny fafaatsuts ror ra asangan e Jisas a mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy ana ri te favaanan kan iny Vurungan Rof nan Ya tana saape ai tana fo numaa tana vainy. ");
INSERT INTO sps_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tan nainy to aya, as'as nar matisian paas enato jias, ana rin matisian te natiny ror faa Grik koma suar raton matisian te natiny ror faa Hiburu. Rin matisian te natiny faa Grik ror tsue to na ka, “Tan mamatsiny nainy mi natiny faakouts rarori na vainy te kakat iny rora kainy ainy sana mi gim rom ma faakouts ir a fo amov tsumam.” ");
INSERT INTO sps_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","To sana ina safunuu ana ina fuan a amaraav fikoo vaaguam ir matisian faavot ser tsue tsuri, “Te gim non ma rof te anofe roran kat iny favaanan iny vegiau ten Gov ra te tatafas tsun iny a kainy ainy. ");
INSERT INTO sps_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Vamuinyasiny fafaaman tsonyo pisan ir yam ta ina fits ta mes fapoopoan namami te via miror Aaven Taabos ana nat a rof ma tagaa ot iny ari na fo kainy ainy to. ");
INSERT INTO sps_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ana mam te faan faavot iny nainy tsumam tan faakats ana binun tan favaanan iny vegiau ten Gov.” ");
INSERT INTO sps_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Rin gum iny vainy faavot komainy fiisok vegiau te kat guamaraav, to ser nom e Stivin a mes kaa minon a faason a reits ten Krais ana ayei via kan minon Aaven Taabos ana nat a rof ai Filip kan, ai Porokoras, ai Naikeno, ai Timon, ai Pamenas me Nikolas. Nikolas a tsoiny Entiok to te sof ir a taa Jiu tan fafaatouf tsuri. ");
INSERT INTO sps_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Rin gum iny vainy faan ratuari na tee vainy to tan guamaraav, ana rin guamaraav faakats to ser fasaur nimar jias tsuri. ");
INSERT INTO sps_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","To san vegiau ten Gov saats vavis a pan. An as'as nar matisian te kaa Jerusalem paas enato jias ana rin tsoiny faakor tana taa Jiu na kinai taun miton a faason. ");
INSERT INTO sps_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stivin, ayei na mes te kaa me na koma ree'un tsian ana parits a reits te faan iny e Gov tsunia kat a fo mamatsiny kat ana fo mamatsiny parits iny faatok fapoopoan nar vainy. ");
INSERT INTO sps_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Sana mesapan tsurin vainy vavaajets koma suar iny ya ito na tee vainy tan vainy binun babainy muan sai tovei tapuruur buser ser gum tana isen a numaa iny fafaatouf tana taa Jiu ma fafaatouf ari Gov u taa Jiu iny Sairini ai Aleksandria ai tana gum fan iny Silisia ai Esia. Ri fatsitsien me Stivin. ");
INSERT INTO sps_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","San Aaven Taabos faan iny a nat a rof ten Stivin to te vegiau fi ya, ri gim to ma onot ma tsue tap iny ya. ");
INSERT INTO sps_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ri pats ir a mesa vainy ser gam ri tsue to na ka, “Amam te nongoiny ya te tsue vasuar iny e Moses me Gov.” ");
INSERT INTO sps_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tan kat to aya ri fatsuiny to na komar a vainy an tsunaun tana taa Jiu an tsoiny fifaatsuts tan Faun. Ri naa me ten Stivin ser nots ya, ri mei naa towa matar Fuainy Tsunaun tan Kansol tana taa Jiu. ");
INSERT INTO sps_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ri fikoo ir mesa vainy ser gam iny e Stivin ri tsue to na ka, “A mes to te natiny tsue fifiiring fatatabiny non a saape na taabos an Faun te kirkir iny e Moses. ");
INSERT INTO sps_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mam nongoiny ya te tsue na ka e Jisas a tsoiny Nasaret rurei non a saape ana ya te pangis fo kat tan tsuvurara te faan iny e Moses tsura muan.” ");
INSERT INTO sps_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ana ri na fokinai to te vaagum matoong faparits tsuiny to Stivin ana ri tagei to na nain e Stivin te faarei na morena. ");
INSERT INTO sps_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ana Tsoiny Mumua Tan Tsoiny Faakor tsue to, “U tsue to ayan man?” ");
INSERT INTO sps_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ai Stivin tsue to, “Fuainy vamuinyasiny an fuainy tetee, nongon yam! A Gov tan mamatsiny siinaiv ruak a tsuvurara Abraham te kaakaa ya tana gum fan iny Mesopotemia ana ayei tabuiny ma naa farokot na tana gum fan iny Haran, ");
INSERT INTO sps_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ai Gov tsue to ten Abraham, ‘Naus osing puputaa tsuam an fuainy famuinyasiny tsumanyi nyi naa to tan sen puputaa to te komainy faatok marom.’ ");
INSERT INTO sps_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Kat to ai Abraham naus osing ton puputaa tana taa Kaldia te koo ri Mesopotemia, sa naa kaa en tana gum fan iny Haran. Vou na mat ten taman ya, ai Gov faan iny naa towa tan puputaa to te kaa romi roman. ");
INSERT INTO sps_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gov gima faan iny ta painy puputaa ten Abraham ma fasito fatoobing iny ya. Ana sikia kan ta ar kakaii iny pan onot faarei non a isen a ngaf, a sikia. San e Gov te tsue vou Ayei faan iny non puputaa to aya tsunia ma tagaa ot iny ya ya an fuainy tsubnaain faavot tsunia, ri kan tagaa ot iny ror ya. Tabuiny kaa farokot minon e Abraham ta guei ai Gov kat ton tsuen man to aya. ");
INSERT INTO sps_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gov tsue fi nei, ‘Tsubnaain tsumanyi, kaa kan nats ror tan puputaa tan mes vainy kaner tana gum fan kaner ana ri te kaa faarein vainy gog tsuri. Ana vainy te fasito ir fuainy guei tsumanyi nai kat fifiiring kan rarori onots non fats natus a ingainy. ");
INSERT INTO sps_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Vou Nyo te fakaa ir aatai tan tsoiny min moun te fasito iny ror tsubnaain tsumanyi tan vaatsuk. An fuainy aatai tan guei tsumanyi te naus osing puputaa to aya Ijip. Ana ri te nai faatouf Vanyo tan puputaa to aya i Kenan,’ Gov tsue fi nei aya. ");
INSERT INTO sps_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ai Gov tsue of to Abraham ma kat ya na vaapee tsunia faarei non a bobot faatok iny non tsuen man tan Tsue Faunot te tsue faman iny Ya tsunia. Abraham kaa me na guei tsoiny e Aisak ana ya kat to na vaapee tsunia tan fajian nan nainy te agiir fi ya. Aisak ayei na taman e Jekop ai Aisak kat kainy to na vaapee ten Jekop. Ai Jekop ayei na tamar safunuu ana ina fuan na vun kat kainy ton vaapee tsuri faavot, ana isen tsuri Josep. ");
INSERT INTO sps_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Mes a ina safunuu ana isen a famuinyasiny ten Josep fitsufainy mi towa, ri fafiifoiny iny naa towa tan mes vainy kaner ser mei fi naa ya tana gum fan Ijip. Sen Gov kaa fiisen mi ya, ");
INSERT INTO sps_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ya faakouts Josep sa saup ya tana fo mamatsiny patang tsunia. Tan nainy te vegiau fiisen mi ya Fero, na aatouf iny Ijip, Gov fainy ya na nat a rof Ya kat to na aatouf iny Ijip ma komainy ya ya, kat to ana aatouf iny Ijip bobot to Josep ma faarei ya na Gavana tana Ijip faavot, ma tatagaa ot iny ya na fo mamatsiny ka tana numaa tana aatouf ai tana gum fan kan to aya. ");
INSERT INTO sps_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Vou an nainy ves ruak to na pan faavot iny Ijip, ana pan faavot iny Kenan, ser kaa me na patang tsian. An fuainy tsuvurara gim to ma sab vaarik ta kainy ainy. ");
INSERT INTO sps_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sen Jekop nongoiny a kainy ainy te kaa non Ijip ya jiats ra naa ton fuainy guei tsoiny tsunia iton fuainy tsuvurara ser naanaa tan vaamuan nana tou taataan. ");
INSERT INTO sps_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Vou ri tabin fatabin pis to tan fafuan nana tou taataan, ai Josep pokei faruak to na tsivon tan fuainy famuinyasiny tsunia, ‘Anyo Josep.’ Ana aatouf iny Ijip nat raton fuainy nuatsin e Josep. ");
INSERT INTO sps_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ai Josep faan iny naa ton vegiau ten taman ya Jekop ma naa mi ya tsunia, fiisen ramirin vainy tsunia onots ror fits safunuu ana ngim tsoiny min moun faavot. ");
INSERT INTO sps_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kat to ai Jekop of fi naa to Ijip. Vou ya mat to, an fuainy tsuvurara mat kan rato. ");
INSERT INTO sps_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ser govets fatabiny naan, pua rari unya Sekem ser nai kats rari tan katskats na aya, ito na pan te pats of e Abraham fuainy guei tsuri ten Hemo unya Sekem. ");
INSERT INTO sps_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Te sisiruu men nainy te komainy ma kat e Gov tsuen man te kat Ya ten Abraham an aatai iny Isrel ruak iny karap mito unya Ijip. ");
INSERT INTO sps_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Vou ana isen a mes ruak iny aatouf mito Ijip, ya gim to ma tos e Josep. ");
INSERT INTO sps_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A mes to aya kat gam tan fuainy vainy tsura. Ya kat fifiiring ton tsuvurara, ya sogsog fiisok tsun ratuari ma naus osing ir fuainy meran tsuri ma kaa ri jiarasan tana fo numaa tsuar er mat to. ");
INSERT INTO sps_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Tan nainy to aya, tsinan Moses faagiir ya, sa faarei na guei na saavits, taman ya me tsinan ya makok ya tana numaa tsuri onots a fopis a iifaa. ");
INSERT INTO sps_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Vou ser fakei ya ma kaa ya jiarasan, ana guei moun tana aatouf iny Ijip nom towa sa tsungainy faarei yan a guei tsunia. ");
INSERT INTO sps_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ai Moses nom ton fifaatsuts tana nat a rof tana taa Ijip, ana ayei na mes a parits iny vegiau an tana binun tsunia. ");
INSERT INTO sps_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses fats safunuu na ingainy busen ya fakats to ma nai nak ir taa Isrel, a vainy tsunia fatoobing. ");
INSERT INTO sps_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ayei tagei a isen a guei Ijip te kat fifiiring a isen a guei Isrel. Ai Moses biny to na iring tana guei Ijip to aya to te kat kat iring tana guei Isrel, ya atsuiny famat towa. ");
INSERT INTO sps_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ya pon iny to na vainy tsunia fatoobing te fakats fi ror nei Gov komainy saup rarori niman e Moses, sana sikia. ");
INSERT INTO sps_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Voun mes nainy ai Moses ruak sab naa to na ina fuan a guei Isrel fitaatsun ror, ya pon to ma fakap fitaatsun tsuri na ina fuan. Ya tsue to, ‘Mi na ina fuan fo mumuinyasiny fatoobing. Kat fei tsumi kat fifiiring rom a tsivom ei?’ ");
INSERT INTO sps_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Sana mes to aya to te kat fifiiring e famuinyasiny tsunia, tsug fuainy e Moses, ya tsue to, ‘Sei kat manyi ma kaa faarei anyi na tsoiny tatagaa ot ana tsoiny vaatsuk tsumam ee? ");
INSERT INTO sps_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Toroman anyi komainy atsun famat varonyo, faarei te atsuiny famat fi nyi na guei Ijip naanaf?’ ");
INSERT INTO sps_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses nongoiny vegiau to, sa naa fi en tan puputaa tana taa Midian. Vou ya fanging to, ana ya kaa mito na ina fuan a guei tsoiny. ");
INSERT INTO sps_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Voun fats safunuun a ingainy, ana isen a morena ten Gov ruak to Moses tana pan a uur panan a tobeer iny Sainai a morena kaa gagon koman guaf ruak tan nau kakaii kaa minon saksak. ");
INSERT INTO sps_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses tagei a ka to, ya fakats fakinai nato te ruak fi na ka to ya naa fasiruu naa to ma tagaa faarof ya, ana Tsunaun tsue of towa, ");
INSERT INTO sps_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nyo na Gov tan fuainy tsuvumanyi, Nyo na Gov ten Abraham ai Aisak ai Jekop.’ Ai Moses totoroor nato, ya oraav to ma tagaa pis na. ");
INSERT INTO sps_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ana Tsunaun tsue of towa, ‘Nom ravainy fuan suu naa to mou manyi, pan to aya te tsutsun rom anyi tsunia, ayein puputaan taabos. ");
INSERT INTO sps_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nyo tagei fakap bus fo mamatsiny kat iring te kat ari tan fuainy tsoiny min moun Tsonyo i Ijip. Nyo nongoiny fakap tangis tsuri. Tovei roman, Nyo of me ma saup Anyi ri kainy nom osing rari na patang tsun. Nyo komainy jiats fi marom anyi, tana gum fan iny Ijip.’” ");
INSERT INTO sps_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ai Stivin tsue pis to, “E Moses to aya te baainy iny ari ma nongoiny, ser tsue of ya, ‘Sei tsue of manyi ma kaa faarei anyi na tsoiny tatagaa ot ana tsoiny vaatsuk ee?’ Ayei koraa ya na mes ten Gov to te jiats naa ya, ma faarei ya na tsoiny tatagaa ot ana mes te saup fatabin rarori, Gov faparits ya tana fifaakouts tana morena to te ruak ya tana painy nau a kakaii na akoor. ");
INSERT INTO sps_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ai Moses kat ton fo kainy faatok reits an fo kan karap te tagei rori an fo binun saar iny faatok unya Ijip, vou ya fatafuts osing ratuari sa kat kainy ya tana Namaan A Goutsiroun, ai tana pan a uur, onots fats safunuu na ingainy. ");
INSERT INTO sps_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ayei koraa na Moses to aya te tsue of ir a taa Isrel, ‘Gov nai jiats minon ta ina isen ta kuigin tana vainy tsumi, ma faarei vaminyo Ya.’ ");
INSERT INTO sps_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Vou ser faavot tana pan a uur, ai Moses kaa fiisen ramiton fuainy tsuvurara, fiisen me na morena to te vevegiau of ya tana tobeer iny Sainai, ayei kan te nom vegiau ten Gov, an vegiau to aya kaa minon a toto na sikia ta fafakap nan ya, ayei faan iny ya tsura. ");
INSERT INTO sps_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“San fuainy tsuvurara baainy ma nongoiny tsue tsunia. Ser tsugei ya, tana saa, aave rari kaa farokot non unya Ijip. ");
INSERT INTO sps_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kat to ser tsue of e Eron, ‘Kat of mamam ta fo gov, ma mumua mamam ari. Moses to te fatafuts fi mamimam ya unya Ijip ya mei fi mamituamam nei mam gim rom ma nat a saa te ruak tsunia na.’ ");
INSERT INTO sps_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tan nainy to aya ser kat a kaisa faarei non a guei bulumakau, ri kat faakor tana gov gamgam to aya, ser kat guainy, ri paparaa mito na ka to aya te kat ari nimar. ");
INSERT INTO sps_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sen Gov faan iny a tounon tsuri Ya tanyiny to ma fafaatouf ari na nuaf ana iifaa an kootsits to te kirkir fi en ya tan fuainy kuigin tan Vegiau Ten Gov, ‘Amin vainy Isrel, muan tsumi kaakaan fats safunuu na ingainy tana pan a uur, mi atsuiny ton bulumakau an siip, mi kat ton faakor sam pon fi nei, mi kat a fo fifaan to aya Tsonyo? A sikia! ");
INSERT INTO sps_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mi nom a saape kandis tana gov gamgam, Molok, sam govets fiisen mi ya na kaisa faarei na kootsits tana gov gamgam e Refan, a fo kaisa to aya mi kat rari kainy fafaatouf rari. Nyo jiat fi maromi unya tana gum fan iny Babilon.’ ");
INSERT INTO sps_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Fuainy tsuvurara muan kaa me na saape kandis, kaa me na foka, faatok iny non E Gov te kaakaa fiisen ramirori tana pan a uur. Ri kat faarei tsuiny ya to te faatok fin ya Gov e Moses tan tanuu Tsunia. ");
INSERT INTO sps_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Vou na fo ingainy te kap naa an fuainy tsuvurara naa fiisen mito Josua ser govets naa na saape kandis, ri nom ton puputaa tan mes vainy kaner tan mes gum fan to te gargar fi rari Gov. Ana saape kandis to aya kaa enato tan puputaa to aya onot tan nainy ten Devit. ");
INSERT INTO sps_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Gov koma rof iny e Devit, ya faakats to sa rangats e Gov ma famanat iny Ya, ya ma fatsuiny ya ta isen ta saape ten Gov ten Jekop. ");
INSERT INTO sps_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sen Solomon fatsuiny of Ya na saape. ");
INSERT INTO sps_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Sana Gov a Tsigtsig Fiisok gim non ma natiny kaa tana numaa te fatsuiny vainy nimar to te tsue fi na kuigin, ");
INSERT INTO sps_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Gormirmir ayein tagan Tsonyo, tsue fi na Tsunaun, an puputaa ayei na pan te fakei Ronyon mou patsun ya. Saf viir numaa ei na, te kat of Varonyo mi? Saf a pan ya na te gum Ronyo, Nyo te favusuan? ");
INSERT INTO sps_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Fiisia, mi gima nat Vanyo te kat fo mamatsiny ka to aya, nimau?’ ");
INSERT INTO sps_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Min vainy patsuu ra koovar, aave mami faarei raror aaver vainy vavaajets, ana mi gim rom ma natiny faan iny a aavem ma nongoiny yan vegiau ten Gov. Mi senviir tsun mirom fuainy tsuvumami, ami kan natiny fanaginy tsue vaurep rom tan Aaven Taabos. ");
INSERT INTO sps_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Saf a kuigin ya na te kaa muan san fuainy tsuvumami gima kat, kat iring tsunia? Sikia, ri atsuiny famat ir vainy muan te favaanan iny vegiau nana Tsoiny Binun a Tavaron ten Gov na fi minon Ya. Tovei roman mi faan iny naa Towa nimar vainy fifitokon ser atsuiny famat Ya. ");
INSERT INTO sps_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mi nom bus Faun ten Gov tan nimar fuainy morena, sana mi gima manaats ya,” tsue fi Stivin. ");
INSERT INTO sps_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Te nongoiny arin tsue to te sak a koma rari ser kot ngiisngiis ana ri koma seeve iny to Stivin. ");
INSERT INTO sps_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","San e Stivin via men Aaven Taabos ya matoong fi naa to Gormirmir. Sa tagein siinaiv ten Gov, ya tagei to Jisas te tsutsun minon tan panaainy matou ten Gov. ");
INSERT INTO sps_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ai Stivin tsue to, “Nongon, anyo tagei a Gormirmir a tapue ana Guei Tsoiny te Bobot e Gov sa ruak iny Mes me tsutsun non tan panaainy matou Tsunia.” ");
INSERT INTO sps_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kat to ser vaposok iny kuu ana ri pip to na fo teinar rari na fo nimar, ana ri fakookuar naa to ser nots e Stivin. ");
INSERT INTO sps_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ser ras fatafuts osing yan a ngats fan tsian, ana ri totouruei towan fats. An vainy to te sak faamuainy yan vegiau fious ton fo vau tsuar ser fakei fo raarav tsuar panan a isen a mes a vurots, koo rori Sol. ");
INSERT INTO sps_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ri binuiny a totouruei famat e Stivin fats, ai Stivin faakats fi to nei, “Tsunaun Jisas, nom a aave vanyo.” ");
INSERT INTO sps_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ya fatukun to sa kuu fatsian iny faakats, “Tsunaun! Anofe ravainy kat te kat ari tsonyo!” tsue fi Stivin, ya mat busen nato. ");
INSERT INTO sps_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sen Sol fatangan iny e Stivin ma atsuiny famat ari Ya. Tanik kan tan nainy to aya, ri tanik iny toptop rato na gum iny vainy fafaaman te kaakaa Jerusalem, ri kat fifiiring fiisok ir vainy fafaaman ser fabuubus vavis er koman a gum fan iny Judia an mes panan unya Samaria. San guamaraav tsun kaakaa Jerusalem. ");
INSERT INTO sps_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mes vainy te fafaatouf e Gov tangis fiisok e Stivin ser nai kats iny ya. ");
INSERT INTO sps_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sen Sol tanik iny fafauf rato na gum nar vainy fafaaman te natiny vaaguam ror iny fafaatouf, ya sof to na fo numaa sa ras fatafuts ir tsoiny min moun faavot te faaman ror ten Jisas, sa fasof rari tan numaa iny kotskots. ");
INSERT INTO sps_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Vainy fafaaman bus vavakas tan fo fan ser nai favaanan iny Vurungan Rof ten Jisas. ");
INSERT INTO sps_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip of naa to tana ngats fan tsian tana gum fan iny Samaria ana ya favaanan iny to Jisas, Ayei na Krais a mes te pisainy e Gov ma Tsoiny Fiisaup Ya tana vainy na aya. ");
INSERT INTO sps_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Rin tagin vanongon to te favaanan fi Filip, ser suu iny koman iny vanongon tsuar tsunia, tana saa, ri tagein fo mamatsiny parits iny faatok ten Gov te faruak finy ya Filip. ");
INSERT INTO sps_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Foka to, faarein masarau sofsof ir a vainy a kinai, ser kuu men tangis ri naus osing ratuari, vainy a kinai mou rarin mat, an pengong, mat faseinypan ri fokinai tsipaar fatabin er. ");
INSERT INTO sps_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","An paparaa tsian ruak to tana ngats fan tsian to aya. ");
INSERT INTO sps_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Te kaa me na isen a mes tana ngats fan tsian, koo rori Saimon. A mes a fifiamatsuan, a viraako tan fo nainy te naa en. Vainy tana gum fan iny Samaria natiny toobo ror ya te kat fi non ya na foka to, ri te saar ir, sen Saimon tsue of rari, “Anyon a mes a karap.” ");
INSERT INTO sps_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Vainy tana ngats fan tsian to te kaa miror a asangan an vainy sikia tu asangan natiny nongon fiisok ror e Saimon. Natiny tsue ror, “A mes to kaa minon ‘Na Parits A Reits’ ten Gov.” ");
INSERT INTO sps_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ri natiny vovou faparits ror vegiau tsunia, tana saa ayei natiny kat non a foka na fo kat gengen tana fo amatsuan, a viraako tsunia, ka te saar of rori. ");
INSERT INTO sps_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Vou ai Filip favaanan iny ton Vurungan Rof tana Waan e Gov ai tana asangan e Jisas Krais, ai tan nainy to aya fuainy tsoiny min moun faaman to ten Jisas, ser fapeenan. ");
INSERT INTO sps_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ai Saimon faaman kan to, ya fapeenan to, sa ka fiisen me Filip. Tan nainy to aya ayei tagein viir kainy faatok te ruak ana ya karian fiisok tsun nato. ");
INSERT INTO sps_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Guamaraav iny Jerusalem nongon te kaa fi me na taa Samaria vegiau ten Gov, ri jiats naa to Pita me Jon unya Samaria. ");
INSERT INTO sps_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nainy te ruak ari ana ri faakats of raton vainy fafaaman ser nom Aaven Taabos, ");
INSERT INTO sps_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","tana saa, u Aaven Taabos tabuiny of non tan ta mes tsuri, sana ri te peenan tsun er tana asangan a Tsunaun E Jisas. ");
INSERT INTO sps_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ai Pita me Jon fasaur to na nimar patsuu rari, ser faakats of ratuari, ri nom ton Aaven Taabos. ");
INSERT INTO sps_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tan nainy te tagei e Simon a parits tan Aaven Taabos te of rari, to te fasaur fin guamaraav nimar patsuu rari, ya pon to ma faan iny ta painy moni ten Pita me Jon ma foiny ya na parits tana Aaven Taabos, ");
INSERT INTO sps_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","sa tsue, “Ami ma faan kan vanyo na parits to aya, ai sei na mes to te fasaur ronyo na nimau tsunia ee, onot non ma nom Aaven Taabos.” ");
INSERT INTO sps_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sen Pita biny e Saimon, “Nyi ana painy moni tsumanyi onot non ma kajiaa babainy en unya Hel to te pon fi rom anyi ma pats a fifaan ten Gov tana painy moni! ");
INSERT INTO sps_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nyi sikia ma kaa me ta pan iny binun tana binun tovei tana saa fakats aave manyi sikia ma toobing fiisen me Gov. ");
INSERT INTO sps_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Reesik nyi takopis osing ton kat iny ngi'arapaar tsumanyi ana nyi te faakats tana Tsunaun ma anofe Yan aveto nato to te fakats fi rom anyi. ");
INSERT INTO sps_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nyo tagei marom anyi te kaa mirom kat iny fitsufainy nato komam an aveto tsumanyi kotskots faavot marom anyi.” ");
INSERT INTO sps_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ai Saimon biny ton tsue ten Pita me Jon, “Mi na ina fuan ma faakats of vanyo tana Tsunaun ma faakouts vanyo Ya, ana foka to aya te tsue mi te gima ruak on tsonyo.” ");
INSERT INTO sps_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tan nainy te pokei fakap ari na ka to te tagei ari te ruak ten Jisas ri favaanan iny ton Vurungan Rof tana Tsunaun tana taa Samaria, Pita me Jon tabin fatabin rato Jerusalem. Ser favaanan iny Vurungan Rof ten Jisas sanaan ai tana fo fan tana gum fan iny Samaria. ");
INSERT INTO sps_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ana morena tana Tsunaun tsue of to Filip, “Tsun, kakoiny a tsivom nyi te naa fi painy vou tana sanaan te naus osing non a Jerusalem ai te of fi naa Gasa, sanaan to aya ka non tana pan a uur.” ");
INSERT INTO sps_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ai Filip kakoun fakap to ya naa bus nato, te naa ya sanaan ya tagei to na isen a mes iny Itiopia. Ayei na mes a karap kaa minon a binun tana muiny aatouf iny Itiopia, asangan a moun to aya, Kandis. Ayei tagaa ot iny non a painy moni tsunia. A mes to aya poo fi me Jerusalem fafaatouf me Gov, sa tabin fatabin fi naa fan tsuan. ");
INSERT INTO sps_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Te tabin fatabin naa ya, ya jias to tana Kares, ana ya gogosias fatsiainy ton kirkir tana kuigin e Aisaia. ");
INSERT INTO sps_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","An Aaven Taabos tsue of to Filip, “Taan fasiruu naa panan a Kares.” ");
INSERT INTO sps_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kat to ai Filip taan fasiruu naa to ya nongoiny to na tsoiny Itiopia te gogosias non kirkir tana kuigin e Aisaia. Ai Filip rangats towa, “Nyi natiny rom a ka te gogosias rom anyi ge?” ");
INSERT INTO sps_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ana mes to aya biny towa sa tsue, “Fei nat fi ronyo ei, onot non te fa'arasainy fi non ya ta isen ta mes a ka to tsonyo?” Ya tsue to ten Filip, “Jias faguas fi me tsonyo nyi gum fiisen vamituanyo.” ");
INSERT INTO sps_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A painy kirkir nan Vegiau Ten Gov te tsue tsuk iny e Jisas te tsue fi nei, “Ri atoiny mi Ya, faarei na siip to te komainy tseetsior rori, faarei non a guei siip te ots ari na funuu nan, ana ya gi