﻿USE sofia;
DROP TABLE IF EXISTS sofia.spp_vpl;
CREATE TABLE spp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES spp_vpl WRITE;
INSERT INTO spp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Diɲyɛ tasìige e, Kile à nìɲyiŋi ná ɲìŋke dá. ");
INSERT INTO spp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ɲìŋke yyaha baa woge niŋgage ku mpyi. Lùbwɔhɔ ná numpini mpyi ku cyeyi puni i. *Kile Munaani sí mpyi na mpéele kuru lùbwɔhe nìɲyiŋi na. ");
INSERT INTO spp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ka Kile si jwo: «Bɛ̀ɛnmpe pu fworo» ka bɛ̀ɛnmpe si fworo. ");
INSERT INTO spp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kile à bɛ̀ɛnmpe ɲya p'à ɲwɔ, ka u u pu ná numpini láha yiye na. ");
INSERT INTO spp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Maa bɛ̀ɛnmpe mɛge le canŋke, maa numpini mɛge le numpilage. Ka numpilage si wwɔ̀, ka ɲyɛ̀ge si múgo, ka kuru si mpyi canɲcyiige. ");
INSERT INTO spp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ɲyɛ ka Kile si núr'a jwo: «Lwɔhe ku táa, laaga ku pyi ku shwɔhɔl'e.» ");
INSERT INTO spp_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Maa kuru laage yaa, mà tɛ̀g'a ɲìŋke lwɔhe ná nìɲyiŋi lwɔhe láha yiye na. Ka lire si mpyi li jwuŋkanni na. ");
INSERT INTO spp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ka Kile si kuru laage mɛge le nìɲyiŋi. Ka numpilage si wwɔ̀, ka ɲyɛ̀ge si múgo, ka kuru si mpyi canzhɔnwoge. ");
INSERT INTO spp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ɲyɛ ka Kile si núr'a jwo: «Nìɲyiŋi ɲwɔhɔ lwɔhe ku bínni cyaga niŋkin i, cyage sanŋke ku pyi tawaga.» Ka lire si mpyi li jwuŋkanni na. ");
INSERT INTO spp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ka u u tawage mɛge le ɲìŋke, lwɔh'à bínni cyage ŋkemu i ke, maa kuru mɛge le suumpe lwɔhe. Maa lire ɲya l'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ɲyɛ ka Kile si jwo na yaayi shiŋi puni yi fyîn ɲìŋke na, sùmaŋi ná cire, yi i yasɛrɛ pyi yi tàanna ná yi shiŋi i. Ka lire si mpyi li jwuŋkanni na. ");
INSERT INTO spp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ka yaayi shiŋi puni si fyîn ɲìŋke na, sùmaŋi ná cire, maa yasɛrɛ pyi mà tàanna ná yi shiŋi i. Ka Kile si lire ɲya l'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ka numpilage si wwɔ̀, ka ɲyɛ̀ge si múgo, ka kuru si mpyi canntanrawoge. ");
INSERT INTO spp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ɲyɛ ka Kile si núr'a jwo na bɛ̀ɛnmpe yaayi yi pyi nìɲyiŋi na, yi i canŋke ná numpilage tɛgɛni láha. Yire yi pyi tàafyee mpiimu pi sí raa katáangii ná canyi ná yyeegii cyêre ke. ");
INSERT INTO spp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Yire yaayi yi pyi nìɲyiŋi na, yi raa bɛ̀ɛnmpe tîrige ɲìŋke na. Ka lire si mpyi li jwuŋkanni na. ");
INSERT INTO spp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ka Kile si bɛ̀ɛnmɛ yaaya nimbwoyo shuunni yaa. Maa yi puni nimbwɔhe yaha canŋke ɲùŋɔ na, maa nimbileni yaha numpilage ɲùŋɔ na. Maa wɔrigii mú yaa. ");
INSERT INTO spp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kile à yire yaayi yaha nìɲyiŋi na, bà yi si mpyi s'a bɛ̀ɛnmpe kaan ɲìŋke na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Maa yi tìŋɛ canŋke ná numpilage ɲùŋɔ na, bà yi si mpyi si numpini ná bɛ̀ɛnmpe tɛgɛni láha yiye na mɛ. Ka Kile si lire ɲya l'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ka numpilage si wwɔ̀, ka ɲyɛ̀ge si múgo, ka kuru si mpyi cansicyɛre woge. ");
INSERT INTO spp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ɲyɛ ka Kile si núr'a jwo: «Ɲyii yaayi yi ɲyaha teetee lwɔhe e, saɲcyɛɛnre mú ti yîri t'a mpéele ɲjaampe e.» ");
INSERT INTO spp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Maa lwɔhe ɲyii yaayi nimbwoyi ná lwɔhe ɲyii yaayi shiŋi sanŋi puni yaa teetee, maa yi pyi yi ɲyaha yi tàanna ná yi shiŋi puni i. Maa saɲcyɛɛnre yaa mú mà tàanna ná ti shiŋi i. Maa lire ɲya l'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kile à jwó le y'á, maa jwo yi si teetee yi i suumpe lwɔhe ɲî. Maa jwo na saɲcyɛɛnre mú ti ɲyaha ɲìŋke na. ");
INSERT INTO spp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ka numpilage si wwɔ̀, ka ɲyɛ̀ge si múgo, ka kuru si mpyi canŋkaŋkuro woge. ");
INSERT INTO spp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ɲyɛ ka Kile si núr'a jwo ɲìŋke ku ɲî ɲyii yaayi shiŋi puni na, mu à jwo yatɔɔre, ɲìŋke yafiliyi, ná sige yaare, yi puni ná yi shiŋi. Ka lire si mpyi li jwuŋkanni na. ");
INSERT INTO spp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ka Kile si sige yaare yaa ti shiŋi puni, maa yatɔɔre yaa ti shiŋi puni, maa ɲìŋke yafiliyi yaa yi shiŋi puni mú. Ka u u lire ɲya l'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Cyire puni ɲwɔhɔ na, Kile à jwo: «Ɲyɛ numɛ, wuu sùpyaŋi yaa wuye fiige, u u mpyi wuu málwɔrɔ. Bà u si mpyi si mpyi fyaabii puni ɲùŋɔ na, si mpyi saɲcyɛɛnre ɲùŋɔ na, si mpyi yatɔɔre ɲùŋɔ na, si mpyi ɲìŋke ná ku ɲùŋɔ yafiliyi puni ɲùŋɔ na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ka Kile si sùpyaŋi yaa uye málwɔrɔ. U à u yaa u yabiliŋi fiige. Maa u yaa nɔ̀ ná ceewe. ");
INSERT INTO spp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ka Kile si jwó le pi na, maa jwo: «Yii si, yii ɲìŋke ɲî, yii i ntɛ̀ɛn ku ɲùŋɔ na. Yii i mpyi fyaabii ná saɲcyɛɛnre ná ɲyii yaaga maha ɲyii yaaga ku ɲyɛ ɲìŋke na ke, yire ɲùŋɔ na.» ");
INSERT INTO spp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ɲyɛ ka Kile si núr'a jwo: «Yii wíi. Mii à ɲìŋke sùmaŋi shiŋi puni ná cire shiŋi puni yasɛɛre kan yii á, yi pyi yii yalyîre. ");
INSERT INTO spp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mii à ɲyɛpuruge (ɲyapuruge)* ná wyempuruyi puni kan sige yaare ná yatɔɔre ná saɲcɛɛnr'á, yire si mpyi ti yalyîre.» Ka lire si mpyi li jwuŋkanni na. ");
INSERT INTO spp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ka Kile si li ɲya na uru kapyiiŋkii pun'à ɲwɔ sèe sèl'e. Ka numpilage si wwɔ̀, ka ɲyɛ̀ge si múgo, ka kuru si mpyi canbaani woge. ");
INSERT INTO spp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ɲyɛ nìɲyiŋi ná ɲìŋke ná yi funŋɔ yaayi pun'à yal'a kwɔ̀ amuni. ");
INSERT INTO spp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kile à kwɔ̀ u báaraŋi puni na ke, ka u u ŋɔ̀ canŋke baashɔnwoge e. ");
INSERT INTO spp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Puru ŋɔmpe kurugo, u à báraga le canŋke baashɔnwoge e, maa kuru pyi u wogo, ka kuru canŋke si kuye wwû canyi sanɲyi i. ");
INSERT INTO spp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ɲyɛ nìɲyiŋi ná ɲìŋke yaaŋkanni l'à pyi lire. Ɲyɛ tèni i Kafooŋi Kile à nìɲyiŋi ná ɲìŋke yaa ke, ");
INSERT INTO spp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","cige mpyi na sàha ŋkwɔ̀ a fyîn ɲìŋke na mɛ, sùma mú mpyi na sàha ŋkwɔ̀ a fyîn mɛ, ɲaha na yɛ Kafooŋi Kile mpyi na sàha zànha cyán mɛ. Sùpya mú mpyi ɲìŋke na si ŋkwɔ̀ raa ku fàa mɛ. ");
INSERT INTO spp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kàŋkuraŋɔ* mpyi maha fwore ɲìŋke e, maha mpyi lwɔhɔ na ku puni lwúu. ");
INSERT INTO spp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ka Kafooŋi Kile si ɲìŋke pwoore tà lwɔ́ mà tɛ̀g'a nɔ̀ŋi* cyeere yaa. Lire kàntugo, ka u u shìŋi kafɛɛge fwɔ a le u múnawyiini i, ka tire cyeere si mpyi ɲyii yaaga. ");
INSERT INTO spp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ka Kafooŋi Kile si cikɔɔgɔ yaa Edɛni kìni canŋa fworompe e, nàŋi u à yaa ke, maa uru yaha wani. ");
INSERT INTO spp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Maa ciyi shiŋi puni pyi y'à fyîn ɲìŋke na, cire nisìnante ntemu yasɛɛre t'à táan ke. Maa shìŋi cige yaha cire puni niŋke e, ná cige ŋkemu ku maha sùpyaŋi pyi u à kacɛnni cè a wwû kapiini i ke. ");
INSERT INTO spp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Baŋi wà lwɔhɔ mpyi na fwu na fwore Edɛni kìni i, kuru ku mpyi na fwu cire ɲwɔh'i, wani u mpyi a táa baŋkeɲyi sicyɛɛre. ");
INSERT INTO spp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Baŋkeŋke niɲcyiige mɛge ɲyɛ Pishɔn, kuru na fwu na ntùuli Kyavila kìni puni funŋke e. Sɛɛnŋi na ɲyɛ lire kìni i. ");
INSERT INTO spp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Uru sɛɛnŋi ɲyɛ sɛɛnŋi yabili biliŋi. Sìnmɛ nùguntanga wumɔ mú na ntaa wani, pu mɛge ɲyɛ bideliyɔmu, ná lulushiŋi wà, u mɛge ɲyɛ onikisi. ");
INSERT INTO spp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Baŋkeŋke shɔnwoge mɛge ɲyɛ Gikyɔn, kuru na fwu na ntùuli Kushi kìni puni funŋke e. ");
INSERT INTO spp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Baŋkeŋke tanrawoge mɛge ɲyɛ Tigiri. Kuru na fwu Asiri kìni canŋafyinmpe e. Sicyɛrewoge mɛge ɲyɛ Efirati. ");
INSERT INTO spp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ɲyɛ ka Kafooŋi Kile si sùpyaŋi yaha Edɛni cikɔɔge e, ur'à ku fàa, u s'a ku kàanmucaa. ");
INSERT INTO spp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Maa yi jwo u á: «Mu sí n-jà raa nte cire puni yasɛɛre lyî, ");
INSERT INTO spp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ŋka mu aha bú kapiini ná kacɛnni ɲcèŋi cige yasɛɛre tà lyî canŋke ŋkemu i ke, mu sí n-sìi n-kwû.» ");
INSERT INTO spp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ɲyɛ lire kàntugo, ka Kafooŋi Kile si jwo: «Nàŋi u kwôro uye niŋkin, lire ɲyɛ a ɲwɔ mɛ. Mii sí tɛgɛfoo yaa u á ŋgemu u sí n-yaa ná u e ke.» ");
INSERT INTO spp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kafooŋi Kile mpyi a pwoore tà lwɔ́ mà tɛ̀g'a sige yaare ná saɲcyɛɛnre puni yaa, ɲyɛ, maa ti puni yaha sùpyaŋi taan, maa u kàanmucya, pyiŋkanni na u sí ti mɛyi le ke, mɛgɛ maha mɛgɛ u à le ti mú niŋkin niŋkin na ke, yire mɛyi y'à pyi ti mɛyi. ");
INSERT INTO spp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Nàŋi mpyi a mɛyi le yatɔɔre puni na, maa mɛyi le saɲcyɛɛnre puni na, maa mɛyi le sige yaare puni na, mà li ta yire yaayi puni i u mpyi a tɛgɛfoo ta uye na, ŋgemu u sí n-yaa ná u e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ɲyɛ ka Kafooŋi Kile si nàŋi ŋɔ́n'a cùnnɔ. Mà u yaha puru ŋɔɔmpe na, ka u u u bèeɲcibileni là niŋkin wwû, maa kyambyimpe pà tɛ̀g'a lire wyiini tò. ");
INSERT INTO spp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Lire bèeɲcibileni, Kafooŋi Kile à yaa ceewe, mà kan nàŋ'á. ");
INSERT INTO spp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tèni i nàŋ'à ceeŋi ɲya ke, ka u funntangawuŋi si jwo «Anhaan, numɛ sa, mii shiŋi u ŋge. U kaciiy'à fworo mii kaciiyi i. U cyeer'à fworo mii cyeere e. U mɛge sí n-le ceewe, Ɲaha na yɛ u à fworo nɔ̀ŋi i.» ");
INSERT INTO spp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Lire kurugo nɔ̀ŋi sí u tuŋi ná u nuŋi yaha si mpwɔ u cwoŋi na, pi mú shuunni si mpyi shin niŋkin. ");
INSERT INTO spp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nɔ̀ŋi ná ceeŋi cípyire wuu pi mpyi. Ŋka wà ɲyɛ a mpyi a cwɔ̂nrɔ ná w'e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ɲyɛ Kafooŋi Kile mpyi a sige yaare ntemu yaa ke, wwòŋi u mpyi a cyîige tire puni na. Canŋka, ka wwòŋi si jwo ceeŋ'á: «Sèe wi na Kile à jwo, yii àha ŋkwɔ̀ cikɔɔge cire yasɛɛre tà lyî mà?» ");
INSERT INTO spp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ka ceeŋi si jwo: «Wuu sí n-jà cikɔɔge cire yasɛɛre lyî yoo!» ");
INSERT INTO spp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ŋka cige ku ɲyɛ cikɔɔge niŋke e ke, Kile à jwo wuu àha kuru woore lyî mɛ, na wuu bá ká n-sìi n-bwɔ̀n ti na mɛ, na lire ká mpyi, wuu sí n-kwû!» ");
INSERT INTO spp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ka wwòŋi si jwo ceeŋ'á: «Sèe bà mɛ, yii sì n-sìi n-kwû mɛ! ");
INSERT INTO spp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kile à yire jwo, ɲaha na yɛ u à cè yii aha kure cige yasɛɛre tà lyî canŋke ŋkemu i ke, yii sí n-pyi uru Kile yabiliŋi fiige, yii ɲyiigii sí múgo, yii sí kacɛnni cè n-wwû kapiini i.» ");
INSERT INTO spp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ɲyɛ ka ceeŋi si li ɲya na ŋke cige yasɛɛre sí n-táan sèl'e, ti lem'à ɲwɔ, ti mú sí n-jà sùpya yákili múgo, si mu pyi kacèŋɛ. Ka u u tà kwɔ̀n a lyî, maa tà kan u pooŋ'á, u à lyî, uru na mpyi wani ná u e. ");
INSERT INTO spp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Pi à tire lyî ke, ka pi i piye pyiŋkanni ɲya, maa ɲcè na pire cípyire wuu pi ɲyɛ. Ka pi i ntashan cige weɲyi yà kwɔ̀n a tutu mà le piye na. ");
INSERT INTO spp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ɲyɛ yàkoŋke, nàŋi ná ceeŋ'à Kafooŋi Kile tùnmpe lógo, u u uye ɲaare cikɔɔge e ke, ka pi i fê a ŋwɔhɔ u yyaha na cire shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ka Kafooŋi Kile si nàŋi yyere: «Taa mu de?» ");
INSERT INTO spp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ka u u Kile pyi: «Mii à mu tùnmpe lógo cikɔɔge funŋke e ke, ka mii i fyá, ɲaha na yɛ mii cípyire wu u ɲyɛ, lire l'à mii pyi mii à ŋwɔhɔ.» ");
INSERT INTO spp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ka Kile si jwo: «Jofoo u à mu pyi na mu cípyire wuŋi u ɲyɛ yɛ? Mii à mu sige cige ŋkemu yasɛɛre na ke, tire tà bà mu à lyî mà?» ");
INSERT INTO spp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ka nàŋi si jwo: «Ceeŋi mu à kan mii á ke, uru u à tà kan mii à lyî dɛ!» ");
INSERT INTO spp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ka Kafooŋi Kile si ceeŋi yíbe: «Ɲaha shi mu à pyi amɛ yɛ?» Ka ceeŋi si jwo: «Wwòŋ'à mii ɲwɔfaanŋa, ka mii i tà lyî.» ");
INSERT INTO spp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ka Kafooŋi Kile si jwo wwòŋ'á: «Ná mu s'à ɲɛn'a lire pyi, mii à mu láŋa yatɔɔre ná sige yaare sannte puni shwɔhɔl'e, mu sí raa filili ma yaceni na s'a nticyɛnŋi mûre ma shìŋi canmpyaagii puni i. ");
INSERT INTO spp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mii sí pege le mu ná ceeŋi shwɔhɔl'e, si kuru pege ninuge le mu yasege ná ceeŋi woge shwɔhɔl'e. U aha mu ta, u sí mu ɲùŋke bwɔ̀n n-jya, mu mú ká u ta, maa u nɔ nintaani na.» ");
INSERT INTO spp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Maa jwo ceeŋ'á «Mii sí là bâre mu laani ɲjyàŋi na. Mu lahigii ziŋi sí n-waha sèl'e. Mu la si mpyi si ma pooŋi jà, ŋka uru u sí n-pyi mu ɲùŋɔ na.» ");
INSERT INTO spp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Maa jwo nàŋ'á «Mu à ɲɛn'a taha ma cwoŋi ɲwɔmɛɛni fye e, mii à yi jwo mu á ma hà cige ŋkemu yasɛɛre lyî mɛ, tire mu à lyî. Ɲyɛ ɲìŋk'à kɛ̀ɛge mu kurugo, mu sí raa ŋkànre sèl'e s'a ma ɲwɔlyiŋi taa ɲìŋke e ma shìŋi canmpyaagii puni funŋke e. ");
INSERT INTO spp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ŋgure ná ɲyɛpege sí n-fyîn ɲìŋke na, mu ɲjyìŋi sí raa fworo mu yafaaɲyi i. ");
INSERT INTO spp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mu sí raa lyî ma byɛɛni fùnmpe e, fo zà mu núruŋɔ ɲìŋke e, ɲaha na yɛ pworo ti ɲyɛ mu, mu sí núru n-pa n-pyi tire pwoore ninure.» ");
INSERT INTO spp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ɲyɛ cyire karigii puni kàntugo, Adama à u cwoŋi mɛge le Awa, ɲaha na yɛ uru u à pyi sùpyire puni nuŋi. (Awa mɛge ɲwɔhe ku ɲyɛ shìŋi.) ");
INSERT INTO spp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ka Kafooŋi Kile si yatɔɔre tà seeyi pyi vàanya mà le Adama ná u cwoŋi na. ");
INSERT INTO spp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Maa jwo «Numɛ, sùpyaŋi ɲyɛ wuu fiige, u à kacɛnni ná kapiini cè a wwû yiye e. Wuu u sige u àha ŋkwɔ̀ shìŋi cige yasɛɛre tà kwɔ̀n ɲjyî si ŋkwôro shì na fo tèekwombaa mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Amuni l'à pyi, ka Kafooŋi Kile si u kɔ̀r'a yige Edɛni kìni cikɔɔge e, maa u pyi u sà a ɲìŋke fàa, Kile à u yaa ná ɲìŋke ŋkemu pwoore e ke. ");
INSERT INTO spp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ɲyɛ amuni Kile à Adama ná Awa kɔ̀rɔ. Maa sherubɛnbii pìi yaha cikɔɔge canŋa fworompe e pi a ku kàanmucaa. Maa ŋwɔtɔɔngɔ nawogo yaha ku u fyínge, maa sùpyire tɛgɛlɛ kwɔ̀n shìŋi cige na. ");
INSERT INTO spp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ɲyɛ Adama à wwɔ̀ ná u cwoŋi Awa e, ka u u laa lwɔ́ maa Kaɲɛ si, maa jwo: «Ei! Mii à pùnambile si Kafooŋi Kile barag'e.» ");
INSERT INTO spp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Lire ɲwɔhɔ na, ka u u núr'a laa lwɔ́, maa Kaɲɛ cɔɔnŋi *Abɛli si. Ka Abɛli si mpa mpyi mpàbyi, ka Kaɲɛ si mpa mpyi faapyi. ");
INSERT INTO spp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Tèni là à tòro ke, ka Kaɲɛ si u kɛrɛge yasɛɛre tà pyi sáraga Kafooŋi á. ");
INSERT INTO spp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ka Abɛli mú si u mpàbilini là cû mpàpyire niɲcyiire e mà bò, maa li sìnmpe kyaare pyi sáraga Kafooŋi á. Ka Abɛli ná u sárage kyaa si ntáan Kafooŋi á. ");
INSERT INTO spp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ŋka Kaɲɛ ná u woge kyaa ɲyɛ a mpyi a táan u á mɛ. Ka lire si Kaɲɛ lùuni yîrige sèl'e, ka u u yyaha tanha. ");
INSERT INTO spp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ɲyɛ ka Kafooŋi si Kaɲɛ yíbe: «Ɲaha k'à mu lùuni yîrige fo mu à yyahe tanha amɛ yɛ? ");
INSERT INTO spp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mu kapyiiŋkii ká ɲwɔ, tá mu ɲùŋke sì n-yîrige mii yyaha taan mà? Ŋka mu kapyiiŋkii ká mpi, kapiini mpyiŋi lage sí n-pyi mu na bà naŋiyaaga maha mpyi ná kyaare lage e, maa yatɔɔge pɛr'a sige si ku ta ɲcû mɛ. Ŋka mu s'à yaa mu u ɲcû maye na.» ");
INSERT INTO spp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ɲyɛ canŋka, ka Kaɲɛ si u cɔɔnŋi pyi na pi shà sige e. Mà pi yaha wani, ka Kaɲɛ si ɲcwo u cɔɔnŋi Abɛli na a bò. ");
INSERT INTO spp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Lire kàntugo, ka Kafooŋi si Kaɲɛ yíbe: «Taa mu cɔɔnŋi, Abɛli ɲyɛ ke?» Ka Kaɲɛ si u pyi: «Mii à cè la? Taha mii u ɲyɛ na cɔɔnŋi saɲcwɔnsigiŋi la?» ");
INSERT INTO spp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ka Kafooŋi si jwo: «Ɲaha kafiile mu à pyi amɛ yɛ? Mu à ma cɔɔnŋi bò kɛ? Mii à u sìshange ɲya ɲìŋke na ke, l'à pyi mu à jwo u na ŋkwúuli na mii u uru ŋkooŋi wwû. ");
INSERT INTO spp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ɲyɛ ɲìŋke k'à mu cɔɔnŋi sìshange bya mu cye kurugo ke, kur'à mu láŋa. ");
INSERT INTO spp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mà lwɔ́ numɛ na, mu aha núr'a ɲìŋke fàa, mu saha sì raa nta pyi k'e mɛ. Mu sí raa fahafaha raa ntùuli ɲìŋke na.» ");
INSERT INTO spp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ka Kaɲɛ si jwo Kafooŋi á: «Mu à mii lùbyage pyi wɛɛge lwɔhɔ, mii sì n-jà ku bya mɛ. ");
INSERT INTO spp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ɲyɛ mu à mii kɔ̀r'a yîrige faaŋi tapyige e. Mii sí n-sà ŋwɔhɔ mu yyaha na tatɔɔnge e, s'a fahafaha raa ntùuli ɲìŋke na. Shin maha shin u à mii ta ke, uru sí mii bò.» ");
INSERT INTO spp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ka Kafooŋi si jwo Kaɲɛ á: «Lire mpyi ɲyɛ mɛ, shin maha shin u à mu bò ke, lire kapiini fwooni sí n-tò urufoo na fo tooyi baashuunni.» Ka u u fyè bwɔ̀n Kaɲɛ na, shin maha shin u á círe ná u e ke, urufoo kà ŋkwɔ̀ u bò mɛ. ");
INSERT INTO spp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ka Kaɲɛ si yîri Kafooŋi taan, maa ŋkàr'a sà ntɛ̀ɛn Nɔdi kìni i Edɛni canŋa fworompe e. ");
INSERT INTO spp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Lire ɲwɔhɔ na, ka Kaɲɛ si ceewe lèŋɛ, maa pùnambile si u na, maa li mɛge le Enɔki. Ka u u kànha faanra maa u jyaŋi Enɔki mɛge le kuru na. ");
INSERT INTO spp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ɲyɛ Enɔki à Iradi si, ka Iradi si Mɛkwuyayɛli si, ka Mɛkwuyayɛli si Mɛtushayɛli si, ka uru si Lemɛki si. ");
INSERT INTO spp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemɛki mpyi ná cyee shuunni i. Wà mɛge na mpyi Ada, u saanŋi woge sí mpyi Zila. ");
INSERT INTO spp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada à pùnambile si, lire mɛge ɲyɛ Yabali. Uru tùluge shiinbii pi na yatɔɔre byíi, marii ɲaare na ntùuli. ");
INSERT INTO spp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabali cɔɔnŋi u mpyi Yubali, uru u mpyi ŋkɔ̀nɔbwɔnbii ná tìmpirewyiibii tulyage. ");
INSERT INTO spp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila mú a pùnambile si, lire mɛge mpyi Tubali Kaɲɛ. Ur'à pyi tunntun. U mpyi maha dàɲyaŋi ná tɔɔnntire yaayi yaa. Tubali Kaɲɛ cɔɔnŋi mpyi pùceebile, u mɛge mpyi Naama. ");
INSERT INTO spp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Canŋka, Lemɛki à jwo u cyeebil'á: «Ada ná Zila, yii lógo na ɲwɔ na. Yii niŋgyiigii múgo. Nɔ̀ maha nɔ̀ cyɛge ká nɔ mii na ke, mii sí n-sìi urufoo bò. Nàɲjiibile maha nàɲjiibile l'à kampee tìri mii na ke, mii sí n-sìi urufoo bò.» ");
INSERT INTO spp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","L'à cyêe na Kaɲɛ mbòŋi fwooni sí n-tò urufoo na fo tooyi baashuunni. Ŋka, mii, Lemɛki, mii mbòŋi fwooni sí n-tò urufoo na fo tooyi beetaanre ná kɛ ná baashuunni.» ");
INSERT INTO spp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ɲyɛ ka Adama si núr'a pùnambile si u cwoŋi na maa lire mɛge le Sɛti. Ka Awa si jwo: «Kaɲɛ à *Abɛli bò. Lire e, Kile à pùnambilini labɛrɛ kan mii á Abɛli cyaga.» ");
INSERT INTO spp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ɲyɛ ka Sɛti mú si pùnambile si, maa li mɛge le Enɔshi. Lire tèni i, ka sùpyire si nta a li ɲwɔ cû na Kile pêre maa u pyi Kafooŋi Kile. ");
INSERT INTO spp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama tùluge shiinbii mɛyi yi ɲyɛ ɲje. Canŋke Kile à sùpyaŋi yaa ke, u à u yaa uye fiige. ");
INSERT INTO spp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","U à u yaa nɔ̀ ná ceewe, maa jwó le pi á, maa pi mɛge le sùpya. ");
INSERT INTO spp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adama à yyee ŋkuu ná beɲjaaga ná kɛ ta, maa pùnambile si uye málwɔrɔ. Maa u mɛge le Sɛti. ");
INSERT INTO spp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛti siŋkwooni ɲwɔhɔ na, Adama à yyee ŋkwuu baataanre pyi sahaŋki. Cyire funŋke e u à pyìibii piibɛrii si. ");
INSERT INTO spp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","U shìŋi canmpyaagil'à pyi yyee ŋkwuu baaricyɛɛre ná beɲjaaga ná kɛ, ka u u ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɛti à yyee ŋkuu ná kaŋkuro ta maa Enɔsi si. ");
INSERT INTO spp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enɔsi siŋkwooni kàntugo na, Sɛti à yyee ŋkwuu baataanre ná yyee baashuunni ta. Cyire funŋke e u à pyìibii piibɛrii si. ");
INSERT INTO spp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛti shìŋi canmpyaagii pun'à pyi yyee ŋkwuu baaricyɛɛre ná yyee kɛ ná shuunni, ka u u ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enɔsi à yyee beecyɛɛre ná kɛ ta, maa u jyaŋi Kena si. ");
INSERT INTO spp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kena siŋkwooni kàntugo na, Enɔsi à yyee ŋkwuu baataanre ná kɛ ná kaŋkuro ta. Cyire funŋke e u à pyìibii piibɛrii si. ");
INSERT INTO spp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enɔsi shìŋi canmpyaagil'à pyi yyee ŋkwuu baaricyɛɛre ná kaŋkuro, ka u u ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kena à yyee beetaanre ná kɛ ta, maa u jyaŋi Malalɛli si. ");
INSERT INTO spp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Malalɛli siŋkwooni kàntugo na, Kena à yyee ŋkwuu baataanre ná beeshuunni ta. Cyire funŋke e, u à pyìibii piibɛrii si. ");
INSERT INTO spp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kena shìŋi canmpyaagil'à pyi yyee ŋkwuu baaricyɛɛre ná kɛ, ka u u ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malalɛli à yyee beetaanre ná kaŋkuro ta, maa u jyaŋi Yɛrɛdi si. ");
INSERT INTO spp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yɛrɛdi siŋkwooni kàntugo, Malalɛli à yyee ŋkwuu baataanre ná beɲjaaga ná kɛ ta. Cyire funŋke e u à pyìibii piibɛrii si. ");
INSERT INTO spp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Malalɛli shìŋi canmpyaagil'à pyi yyee ŋkwuu baataanre ná yyee beecyɛɛre ná yyee kɛ ná kaŋkuro, ka u u ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Zherɛdi à yyee ŋkuu ná beetaanre ná shuunni ta, maa u jyaŋi Enɔki si. ");
INSERT INTO spp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enɔki siŋkwooni kàntugo na, Zherɛdi à yyee ŋkwuu baataanre ta. Cyire funŋke e u à pùnampyire ná pùceepyire si. ");
INSERT INTO spp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Zherɛdi shìŋi canmpyaagil'à pyi yyee ŋkwuu baaricyɛɛre ná yyee beetaanre ná shuunni, ka u u ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enɔki à yyee beetaanre ná kaŋkuro ta, maa u jyaŋi Mɛtushala si. ");
INSERT INTO spp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mɛtushala siŋkwooni kàntugo, Enɔki à ɲaare Kile kuni i yyee ŋkwuu taanre funŋ'i. Cyire funŋke e u à pyìibii piibɛrii si. ");
INSERT INTO spp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enɔki shìŋi canmpyaagil'à pyi yyee ŋkwuu taanre ná yyee beetaanre ná yyee kaŋkuro. ");
INSERT INTO spp_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enɔki à u shìŋi puni pyi Kile kuni i. Lire kàntugo, u saha ɲyɛ a kwôro naha diɲyɛŋi i mɛ, ɲaha na yɛ Kile à u lwɔ́ a kàr'a sà yaha uye taan. ");
INSERT INTO spp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mɛtushala à yyee ŋkuu ná beecyɛɛre ná baashuunni ta, maa u jyaŋi Lemɛki si. ");
INSERT INTO spp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemɛki siŋkwooni kàntugo na, Mɛtushala à yyee ŋkwuu baashuunni ná beecyɛɛre ná shuunni pyi. Cyire funŋke e u à pyìibii piibɛrii si. ");
INSERT INTO spp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mɛtushala shìŋi canmpyaagil'à pyi yyee ŋkwuu baaricyɛɛre ná beetaanre ná baaricyɛɛre, ka u u ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tèni i Lemɛki shìŋi mpyi yyee ŋkuu ná beecyɛɛre ná shuunni ke, u cwoŋ'à pùnambile si u á. ");
INSERT INTO spp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","U à li mɛge le Nuhu, maa jwo: «Kafooŋi Kile à ɲìŋke kɛ̀ɛge, maa wuu yaha báarawayi ɲjemu na ke, ŋge pyàŋi u sí n-pa wuu funɲyi ɲíŋɛ, si wuu yige tire kanhare e.» ");
INSERT INTO spp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuhu siŋkwooni kàntugo na, Lemɛki à yyee ŋkwuu kaŋkuro ná beecyɛɛre ná yyee kɛ ná yyee kaŋkuro pyi. Cyire funŋke e u à pyìibii piibɛrii si. ");
INSERT INTO spp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemɛki shìŋi canmpyaagil'à pyi yyee ŋkwuu baashuunni ná yyee beetaanre ná yyee kɛ ná yyee baashuunni, ka u u ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tèni i Nuhu shìŋi mpyi yyee ŋkwuu kaŋkuro ke, u cwoŋ'à pùnampyire taanre si a taha tiye na. Tire ti ɲyɛ Shɛmu ná Kyamu ná Zhafɛti. ");
INSERT INTO spp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Tèni i sùpyir'à li ɲwɔ cû na ɲyahage ɲìŋke na ke, Kile à ɲyii yaayi ɲjemu dá nìɲyiŋi na ke, ka yire si li ɲya na pùceepyire t'à si ɲìŋke na ke, tire lem'à ɲwɔ, maa tire tà cwɔɔnrɔ mà pyi pi cyee. ");
INSERT INTO spp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Lire e, Kafooŋi Kile à jwo: «Mii sì ɲɛɛ sùpyire ti kwôro shì na mɛ, ɲaha na yɛ pi à cyé mii jwumpe na. Mii sí pi yaha pi yyee ŋkuu ná beɲjaaga ta, si nta pi shi bò. ");
INSERT INTO spp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mà lwɔ́ lire tèni i, yire Kile yaday'à wwɔ̀ ná sùpyiibii pworibil'e, maa pyìi si pi na, pire pyìibii na mpyi sùpyibwoyo nintɔɔnyo. Pire pi mpyi tèecyiini nàntefeebii, pi mɛge mpyi a fworo sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ɲyɛ Kafooŋi à li ɲya na sùpyire peg'à pêl'a tòro ɲìŋke na, na pi funŋɔ sɔ̀nŋɔre ɲyɛ a sìi yaaga mɛ, fo kapiini kanni canŋa maha canŋa. ");
INSERT INTO spp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Lire kurugo, u à núr'a li ta sùpyire ɲjaambaaŋ'à pwɔ́rɔ ti ɲjaaŋi na. Ka u u yyaha tanha sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Maa jwo: «Mii à sùpyire yaa, ŋka mii sí ti shi bò ɲìŋke na, mà bâra yatɔɔre ná sige yaare ná yafiliyi ná saɲcyɛɛnre na, ɲaha na yɛ numɛ mii ɲyin'à fworo yi ɲjaambaaŋi na.» ");
INSERT INTO spp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ŋka Nuhu wi ke, u kyaa mpyi a táan Kafooŋi Kile á. ");
INSERT INTO spp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuhu taɲjaaŋi u ɲyɛ ŋge: Nuhu mpyi a tíi, tìgire cyaga mpyi u na u tìiŋi sùpyire shwɔhɔl'e mɛ. Kile kuni kanni i u mpyi na ɲaare. ");
INSERT INTO spp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Pùnampyire taanreŋi u à ta ke, pire pi ɲyɛ Shɛmu ná Kyamu ná Zhafɛti. ");
INSERT INTO spp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Lire tèni i, diɲyɛŋ'à kɛ̀ɛge Kile ɲyii na. Sùpyire mpyi a pi tiye na, cyeyi puni i. ");
INSERT INTO spp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kile à pa li ɲya na diɲyɛŋ'à kɛ̀ɛge, sùpyire puni kapyiiŋkil'à pyi kapegii, ");
INSERT INTO spp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","kuru cyage e, ka Kile si jwo Nuhu á: «Ná ɲìŋke kàmpanɲyi pun'à ɲî pege na, lire kurugo, mii à li yaha si sùpyire puni shi bò. Mii sí n-sìi ti ná ɲìŋke kɛ̀ɛge siɲcyan. ");
INSERT INTO spp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Lire e, mu sí batobwɔhɔ yaa ná cige shìwoge e ná ɲyɛge e maa u funŋke ná u kàntuge wɔɔgɔ ná mánalwɔhe e. ");
INSERT INTO spp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","U yaaŋkanni li nde, u tɔɔnmpe ɲyɛ mɛtɛrii ŋkuu ná beeshuunni ná kɛ, u yyeparampe ɲyɛ mɛtɛrii beɲjaaga ná kaŋkuro, u yerempe ɲyɛ mɛtɛrii kɛ ná kaŋkuro. ");
INSERT INTO spp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Yapwɔgɔ yaa u na, maa mɛtɛrɛ taaga yaha yapwɔge ná batoŋi ŋkèreŋkii shwɔhɔl'e. Maa tajyìge yaa u ŋkère na, maa u yaa sankazuu: ɲwɔhɔbaga, niŋibaga ná nìɲibaga. ");
INSERT INTO spp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mii wi ke, mii sí n-pa zànbwɔhɔ cyán ɲìŋke na, yaaga maha yaaga ku na ŋɔ̀ni ke, si yire puni shi bò. Yafyin sì n-kwôro ɲyii na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mii sí tunmbyaara le ná mu i. Jyè batoŋi i ná ma jyaabii ná ma cwoŋi ná ma napworibil'e. ");
INSERT INTO spp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ɲyii yaayi shiŋi puni sí n-pa mu á, saɲcyɛɛnre ná yatɔɔre ná sige yaare ná yafiliyi, bà yire si mpyi si ŋkwôro ɲyii na mɛ. Ma a yi shiŋi puni shuunni shuunni nɔ̀ ná ceewe le bakwɔɔge e. ");
INSERT INTO spp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma a yalyîre shiŋi puni lwɔ́ a le k'e, yii ná yir'á.» ");
INSERT INTO spp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ɲyɛ lire Nuhu à pyi. Kile à kyaa maha kyaa jwo u á ke, u à lire pyi. ");
INSERT INTO spp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Lire kàntugo, ka Kafooŋi Kile si yi jwo Nuhu á: «Numɛ, yii jyè uru batoŋi i, mu ná ma pyɛnge shiinbii, ɲaha na yɛ mii à li ɲya mu kanni u à tíi mii yyahe taan sùpyire puni shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Múnayaayi shiŋi puni yi sí n-jà n-kan sáraga Kile á ke, mu sí yire nàmbaa baashuunni ná cyee baashuunni lèŋɛ batoŋi i. Múnayaayi shiŋi puni yi ɲyɛ yi sì n-jà n-kan sáraga Kile á mɛ, ma a yire nɔ̀ niŋkin ná ceewe niŋkin lèŋɛ. ");
INSERT INTO spp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ma a saɲcyɛɛnre shiŋi puni nàmbaa baashuunni ná cyee baashuunni lèŋɛ, bà ti shiŋi si mpyi t'àha mpîni mɛ. ");
INSERT INTO spp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ɲaha na yɛ ku sanŋa ɲyɛ cibilaaga niŋkin, mii sí zànhe cyán ɲìŋke na, si nta canmpyaa beeshuunni ná numpiliyi beeshuunni. Mii à múnayaaga maha múnayaaga yaa ke, mii sí yire puni shi bò ɲìŋke na.» ");
INSERT INTO spp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kafooŋi à kyaa maha kyaa jwo Nuhu á ke, u à lire pyi. ");
INSERT INTO spp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ɲyɛ canŋke zànbwɔh'à pa ɲìŋke na ke, lir'à pyi mà Nuhu shìŋi ta yyee ŋkwuu baani. ");
INSERT INTO spp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ka Nuhu ná u jyaabii ná u cwoŋi ná u napworibii si jyè batoŋi i, si shwɔ zànbwɔhe na. ");
INSERT INTO spp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Múnayaayi yi sí n-jà n-pyi sáraga Kile á, ná ɲje yi ɲyɛ yi sì n-jà n-pyi sáraga Kile á mɛ, ná saɲcyɛɛnre ná ɲìŋke yafiliyi pun'à pa jyè Nuhu fye e batoŋi i, shuunni shuunni, nɔ ná ceewe, bà Kile yabiliŋi mpyi a yi jwo Nuhu á mɛ. ");
INSERT INTO spp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Cibilaaga à tòro ke, ka zànbwɔhɔ si ɲcwo ɲìŋke na. ");
INSERT INTO spp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Lir'à pyi mà Nuhu shìŋi ta yyee ŋkwuu baani. Lire yyeeni yiŋke shɔnwoge, canmbilini kɛ ná baashɔnwuuni, kuru canŋke ɲìŋke lùbilibii ná nìɲyiŋi wuubii pun'à múgo, ka lwɔhe si fworo mà ɲìŋke cû. ");
INSERT INTO spp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ɲyɛ ka zànhe si ɲcwo ɲìŋke na, canmpyaa beeshuunni ná numpiliyi beeshuunni. ");
INSERT INTO spp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kuru canŋke yabiliŋi, Nuhu ná u cwoŋi ná u napworibii ná u jyaabii taanreŋi, Shɛmu, Kyamu, ná Zhafɛti à jyè batoŋi i, ");
INSERT INTO spp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ná sige yaare ná yatɔɔre shiŋi puni, ná ɲìŋke ɲyiiyaare puni ná saɲcyɛɛnre shiŋi puni. ");
INSERT INTO spp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Yire múnayaayi pun'à jyè batoŋi i Nuhu fye e, yaaga maha yaaga ku na ŋɔ̀ni ke, yire puni shuunni shuunn'à jyè. ");
INSERT INTO spp_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Múnayaayi puni, yi puni shuunni shuunn'à jyè batoŋi i, nɔ̀ ná ceewe, mu à jwo bà Kile à yi jwo Nuhu á mɛ. Lire kàntugo, ka Kafooŋi si ku ɲwɔge tò. ");
INSERT INTO spp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ɲyɛ zànbwɔh'à cwo ɲìŋke na, maa mpa canmpyaa beeshuunni. Lwɔh'à ɲyaha fo mà batoŋi yîrig'a taha, marii ŋkɛ̀ɛge ná u e. ");
INSERT INTO spp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Lwɔh'à pa ɲyaha mà dùgo sèl'e ɲìŋke nìɲyiŋi na, ka batoŋi si yîr'a taha. ");
INSERT INTO spp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ka lwɔhe si wá na ɲyahage fo mà ɲaɲyi nintɔɔnyi puni ɲùŋɔ jò. ");
INSERT INTO spp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Lwɔh'à ɲaɲyi tò, mà dùg'a nɔ mɛtɛrii baashuunni na. ");
INSERT INTO spp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Múnayaayi puni yi mpyi ɲìŋke na ke, yire pun'à kwû: saɲcyɛɛnre ná yatɔɔre ná sige yaare ná yafiliyi ná sùpyire. ");
INSERT INTO spp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Múnayaaga maha múnayaaga ku mpyi ɲìŋke na ke, yire pun'à kwû, lwɔhe wuyi kanni y'à kwôro ɲyii na. ");
INSERT INTO spp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kile à yi puni shi tò, mà lwɔ́ sùpyire na mà kàre yatɔɔre na, mà sà nɔ yafiliyi ná saɲcyɛɛnre na. Nuhu ná múnayaayi yi mpyi ná u e batoŋi i ke, yire kanni y'à kwôro ɲyii na. ");
INSERT INTO spp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ka lwɔhe si ɲìŋke ɲùŋɔ jò mà ta canmpyaa ŋkuu ná beeshuunni ná kɛ. ");
INSERT INTO spp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ŋka Kile ɲyɛ a funŋɔ wwɔ̀ Nuhu ná sige yaare ná yatɔɔre na batoŋi funŋke e mɛ. U à kafɛɛge pyi ku u fwu ɲìŋke na, ka lwɔhe si wá na ntîre. ");
INSERT INTO spp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ka ɲìŋke lùbilibii ná nìɲyiŋi zànhe wyigigii si ntò, ka ku u yyére. ");
INSERT INTO spp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ka lwɔhe si wá na fwu na ŋkɛ̀ɛge, canmpyaa ŋkuu ná beeshuunni ná kɛŋ'à ta cyi tòro ke, ka lwɔhe fànhe si ɲcyɛ̀rɛ. ");
INSERT INTO spp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yiŋke baashɔnwoge, canmpyikɛ ná baashɔnwuuni, ka batoŋi si ntîg'a tɛ̀ɛn Arara kìni ɲaŋke kà ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ka lwɔhe si ŋkwôro na ntîre fo mà sà nɔ̀ yiŋke kɛ woge na, kuru canmpyicyiini ɲaɲyi ɲùɲy'à fworo. ");
INSERT INTO spp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Canmpyaa beeshuunni kàntugo, Nuhu mpyi a ɲwɔge ŋkemu yaa batoŋi na ke, ka u u ku múgo. ");
INSERT INTO spp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ka u u fwɔnrɔgɔ yaha a fworo, ka kuru si wá na sì, marii ma, fo ka ɲìŋke lwɔh'à sà ŋkwɔ̀. ");
INSERT INTO spp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ka u u mpánmpɔrɔgɔ yaha k'à fworo, ku sà wíi kampyi lwɔh'a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ŋka mpánmpɔrɔg'à fworo ke, ku ɲyɛ a tatɛ̀ɛnge ta mɛ, lwɔhe mpyi ɲìŋke cyeyi puni i, ka ku u núr'a kàre Nuhu yyére. Ka u u cyɛge yige mà tɛ̀g'a ku cû a lèŋɛ batoŋi i. ");
INSERT INTO spp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Maa canmpyaa baashuunni yaha cyi à tòro, maa núr'a mpánmpɔrɔge yaha k'à fworo. ");
INSERT INTO spp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Yàkoŋke, ka mpánmpɔrɔge si láha a jyè batoŋi i ná olive cige wyempurug'e ɲwɔge e. Lire e, Nuhu à cè na pà a fworo lwɔhe e sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Maa canmpyaa baashuunni yaha cyi à tòro sahaŋki, maa núr'a mpánmpɔrɔge yige. K'à fworo kuru tɔɔge e ke, ku saha ɲyɛ a núr'a pa u yyére mɛ. ");
INSERT INTO spp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Yyeeni Nuhu shìŋ'à pyi yyee ŋkwuu baani ná yyee niŋkin ke, lire yyeeni canmpyicyiini, ɲìŋke mpyi a li ɲwɔ cû na lwɔhe byii. Ka Nuhu si batoŋi nìɲiɲwɔge múgo maa wíi, maa li ɲya na lwɔhe mpyi na ŋkwùu ɲìŋke na. ");
INSERT INTO spp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Lire yyeeni yizhwɔnwoge canmpyibeeɲjaaga ná baashwɔnwuuni, lwɔh'à kwɔ̀ ɲìŋke na feefeefee. ");
INSERT INTO spp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Lire tèni i, ka Kile si jwo Nuhu á ");
INSERT INTO spp_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Fworo batoŋi i, mu ná ma cwoŋi, ná ma jyaabii ná ma napworibii. ");
INSERT INTO spp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Sige yaare ná yatɔɔre ti ɲyɛ ná mu i ke, ti shiŋi puni ná ɲìŋke yafiliyi ná saɲcyɛɛnre, yi puni yige, yi raa sì ɲìŋke cyeyi puni i, yi raa sini yi raa ɲyahage.» ");
INSERT INTO spp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ɲyɛ Nuhu à fworo batoŋi i ná u jyaabii ná u cwoŋi ná u napworibil'e. ");
INSERT INTO spp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sige yaare ná yatɔɔre ná ɲìŋke yafiliyi ná saɲcyɛɛnre pun'à fworo batoŋi i, yi shiŋi pun'à fworo yiye niŋkin niŋkin. ");
INSERT INTO spp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ka Nuhu si sáraya tawwûgo yaa Kafooŋi Kile mɛge na. Sige yaare ná yatɔɔre ná saɲcyɛɛnre ti sí n-jà n-kan sáraga Kile á ke, u à tire tà pyi sáraya nizógoyo Kile á. ");
INSERT INTO spp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ka yire *sárayi nùgutaangawuyi si Kafooŋi Kile lùuni bò. Ka u u jwo uye funŋ'i: «Mii saha sì ɲɛɛ ɲìŋke kɛ̀ɛge sùpyire kurugo mɛ, sùpyaŋi múnaani mɛ́ɛ ká ntaha kapegigii mpyiŋi na, fo u nimbilere wuŋi. Mii saha sì ɲɛɛ múnayaayi puni shi bò, bà mii à li pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mà ɲìŋke yaha wani, ɲɛɛmpe ná sùmakwɔngigii sì n-kwɔ̀ mɛ, wyeere ná kafwuge sì n-kwɔ̀ mɛ, nùŋgwɔhe ná bɛ̀nge sì n-kwɔ̀ mɛ, numpilage ná canŋke mú sì n-kwɔ̀ mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ɲyɛ Kile à jwó le Nuhu ná u jyaabil'á, maa jwo pi á: «Sege ku táan yii na, yii pyìi niɲyahamii si, yii i ɲìŋke ɲî.» ");
INSERT INTO spp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Yii sí n-sìi n-pyi fyagara yaaga ɲìŋke múnayaayi pun'á, sige yaare ná yatɔɔre ná saɲcyɛɛnre ná ɲìŋke yafilyi ná fyaabii. Mii sí yi yaha yire puni ɲùŋɔ na. ");
INSERT INTO spp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mii sí yire múnayaayi puni kan yii á yi pyi kyara, bà mii à fyânha a sùmaŋi kan yii á mɛ. ");
INSERT INTO spp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ŋka yii àha múnayaage kà pyi kyara si ku múnaani yaha k'e mɛ, lire ɲwɔhɔ ku ɲyɛ, yii àha ku sìshange yaha k'e si ku pyi kyara mɛ. ");
INSERT INTO spp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Yii sìshange ku ɲyɛ yii múnaani ke, yaaga maha yaaga k'à ku pyi k'à wu ke, mii sí yibige pyi ku kyaa na. Naŋiyaaga ká sùpya bò, mii sí uru múnaani kyaa yíbe kuru naŋiyaag'á, sùpya ká u supyiɲɛɛ bò, mii sí uru múnaani kyaa yíbe urufol'á. ");
INSERT INTO spp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kile à sùpyaŋi yaa uye málwɔrɔ. Lire e, sùpya ká u supyiɲɛɛ múnaani kwɔ̀n, urufoo wun'à yaa li kwɔ̀n sùpya cye kurugo mú. ");
INSERT INTO spp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ɲyɛ yii pi ke, sege ku táan yii na, yii pyìi niɲyahamii si, yii tɛ̀g'a ɲìŋke ɲî.» ");
INSERT INTO spp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Lire kàntugo, Kile à núr'a jwo Nuhu ná u pyìibil'á ");
INSERT INTO spp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Numɛ, mii yabiliŋi sí *tunmbyara le mii ná yii shwɔhɔl'e si ti le ná yii tùluge e, ");
INSERT INTO spp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","si ti le ná múnayaayi puni i, mu à jwo saɲcyɛɛnre, yatɔɔre, sige yaare ná yaaga maha yaaga k'á fworo batoŋi i ná yii e ke. ");
INSERT INTO spp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Tire tunmbyaare ti ɲyɛ: zànbwɔhɔ saha sì múnayaayi shi tò ɲìŋke na mɛ, zànbwɔhɔ saha sì ɲìŋke kɛ̀ɛge mɛ. ");
INSERT INTO spp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ɲyɛ mii à zànhaŋwɔɔge yaa. Kuru ku sí n-pyi mii ná yii ná múnayaayi puni tunmbyaare tàfyɛŋi. Tire tunmbyaare sí n-kwôro n-yaha fo mu tùluge tɛ̀gɛni. ");
INSERT INTO spp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mii aha ɲahaɲyi bínni ɲìŋke nìɲyiŋi na, zànhaŋwɔɔge sí n-fworo. ");
INSERT INTO spp_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Lire tèni i, tunmbyaare mii à le mii ná yii ná múnayaayi puni shwɔhɔl'e ke, tire sí n-kwôro mii funŋ'i. Mii saha sì zànbwɔhɔ cyán ku kwɔ̀ a múnayaayi puni shi tò mɛ. ");
INSERT INTO spp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Zànhaŋwɔɔge sí raa n-fworo ɲahaɲyi i. Mii aha kuru ɲya tère o tère e ke, mii funŋɔ sí n-cwo na tunmbyaare na, nte mii Kile à le mii ná ɲìŋke múnayaayi puni shwɔhɔl'e ke.» ");
INSERT INTO spp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ɲyɛ lire pyiŋkanni na, tunmbyaare Kile à le ná ɲìŋke múnayaayi puni i ke, Kile à jwo Nuhu á na tire tafyɛŋi u ɲyɛ zànhaŋwɔɔge. ");
INSERT INTO spp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ɲyɛ Nuhu jyaabii pi ɲyɛ Shɛmu ná Kyamu ná Zhafɛti, u ná pire pi à fworo batoŋi i. Kyamu u ɲyɛ *Kana tuŋi. ");
INSERT INTO spp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Pire pi ɲyɛ Nuhu jyaabii taanreŋi. Ɲìŋke sùpyishiŋi pun'à fworo pire tùluyi i. ");
INSERT INTO spp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ɲyɛ Nuhu na mpyi faapyi. Uru u ɲyɛ shincyiiwe mà *ɛrɛzɛnŋi fàa. ");
INSERT INTO spp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Canŋka, Nuhu à ɛrɛzɛnŋi sinmpe pà bya, ka pu u u cyán, ka u u ŋkàr'a sà sínni vàanŋke bage e u cípyire wuŋi i. ");
INSERT INTO spp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ɲyɛ Kana tuŋi Kyamu, ur'à kàr'a sà u tuŋi Nuhu cípyire wuŋi ta u à sínni. Ka u u fwor'a kàr'a sà yi jwo u sìɲɛɛbii sanmpii shuunniŋ'á, cyíinŋi na. ");
INSERT INTO spp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ka Shɛmu ná Zhafɛti si vàanntinmbwɔhe kà lwɔ́ a yaha pi fukanyi na, maa jyè kàntugo mà sà pi tuŋi cípyire wuŋi tò. Pi à kàntugo wà pi tuŋ'á, lire e pi ɲyɛ a u vàanɲyibaawuŋi ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sinmp'à pa Nuhu yaha ke, ka u yyahe si ɲcwo, nde u pyìibii puni kàntugowuŋ'à pyi ke, ka u u lire cè. ");
INSERT INTO spp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Maa jwo «Mii à Kana láŋa, u pyi u sìɲɛɛbii bilibii kàntugowuŋi.» ");
INSERT INTO spp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Maa núr'a jwo «Mii à Kafooŋi Kile mɛtanga yyere, uru u ɲyɛ Shɛmu u Kileŋi. Kana u pyi Shɛmu biliwe. ");
INSERT INTO spp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kile u Zhafɛti cyeyaayi ɲyaha, u u u yaha u sà ntɛ̀ɛn u sìɲɛɛŋi Shɛmu yyére. U u Kana yaha u pyi pi biliŋi.» ");
INSERT INTO spp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ɲyɛ zànbwɔhe paŋkwooni kàntugo, Nuhu à yyee ŋkwuu taanre ná beeshuunni ná kɛ pyi sahaŋki. ");
INSERT INTO spp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","U à kwû mà u shìŋi yaha yyee ŋkwuu baaricyɛɛre ná beeshuunni ná kɛ. ");
INSERT INTO spp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ɲyɛ zànbwɔhe toroŋkwooni kàntugo na, Nuhu pùnampyire taanreŋi, Shɛmu, Kyamu ná Zhafɛti, pir'à pùnampyire tà ta. Pire tùluge ku ɲyɛ ŋke. ");
INSERT INTO spp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Zhafɛti u pùnampyire ti ɲyɛ, Gomɛri, ná Magɔgi, ná Madayi, ná Yavani, ná Tubali, ná Mɛshɛki, ná Tirasi. ");
INSERT INTO spp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ɲyɛ Asikɛnazi, ná Irifati, ná Togarama tùluy'à fworo Gomɛri i. ");
INSERT INTO spp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Elisiya, ná Tarisisi, ná Kitimu, ná Dodanimu tùluyi s'à fworo Zhavani i. ");
INSERT INTO spp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Pire pi à kàr'a sà ntɛ̀ɛn suumpe lwɔhe ɲwɔge taare e, pimu ná pi cyaga, pimu ná pi shɛɛnrɛ, pimu ná pi tubaya, pimu ná pi shi. ");
INSERT INTO spp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kyamu u pùnampyire ti ɲyɛ Kushi, ná Misirayimu, ná Puti, ná Kana. ");
INSERT INTO spp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kushi u pùnampyire ti ɲyɛ Seba, ná Kyavila, ná Sabita, ná Arayema, ná Sabiteka. Ɲyɛ Shɛba ná Dedan tùluy'à fworo Arayema e. ");
INSERT INTO spp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi u pyàŋi wà mú u ɲyɛ Nimirɔdu. Uru u à pyi shincyiiwe ɲìŋke na mà fànhe pyi. ");
INSERT INTO spp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Maa mpyi lùuzupege. Lire kurugo, pi mpyi maha ŋko na mucyiin'à pyi lùuzupege Nimirɔdu fiige. ");
INSERT INTO spp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimirɔdu à fyânha a tɛ̀ɛn fànhe na Shiniyari kìni kànyi ɲuŋ'i, yire yi ɲyɛ: Babɛli ná Erɛki ná Akadi ná Kalinɛ. ");
INSERT INTO spp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","U à pa yîri lire kìni i, mà kàre Asiri wuuni i, maa kànya niɲyahaya faanra wani: Ninive ná Erobɔti Iri ná Kalaka ");
INSERT INTO spp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ná Eresɛni, Ninive kànhe ná Kalaka kànbwɔhe shwɔ̀hɔŋi i. ");
INSERT INTO spp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirayimu, u à pyi Ludi shiinbii, ná Anami shiinbii, ná Lehabi shiinbii, ná Nafitu shiinbii, ");
INSERT INTO spp_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ná Paturusi shiinbii, ná Kasiluki shiinbii, ná Kafitori shiinbii tuŋi. Ɲyɛ Filisiti shiinbil'à fworo Kasiluhi shiinbil'e. ");
INSERT INTO spp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kana à Sidɔn ta u pyàŋi niɲcyiiŋi. Lire kàntugo, u à Kyeti ta. ");
INSERT INTO spp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi shiinbii, ná Amɔri shiinbii, ná Girigashi shiinbii mú à fworo Kana e, ");
INSERT INTO spp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ná Kyivi shiinbii, ná Ariki shiinbii, ná Sini shiinbii, ");
INSERT INTO spp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ná Arivadi shiinbii, ná Zimari shiinbii, ná Kyamati shiinbii. Ɲyɛ lire kàntugo, Kana bagashiinbil'à caala. ");
INSERT INTO spp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kana shiinbii kìn'à sìi Sidɔn na, mà kàre Gerari kànmpanŋke na, Gaza taan, maa ŋkàre Sɔdɔmu kànmpanŋke na, ná Gɔmɔri, ná Adima, ná Zeboyimu, mà sà nɔ̀ fo Lesha na. ");
INSERT INTO spp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ɲyɛ Kyamu tùluyi yi mpyi wani, yi puni ná yi tubaya, ná yi shɛɛnrɛ, ná yi cyaga, ná yi shi. ");
INSERT INTO spp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shɛmu mú à pùnampyire si. Uru Shɛmu u à pyi Ebɛri shiinbii tulyage. Zhafɛti yyahawuŋi u mpyi u wi. ");
INSERT INTO spp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shɛmu pùnampyire t'à pyi Ɛlamu, ná Ashuri, ná Arifasadi, ná Ludi, ná Aramu. ");
INSERT INTO spp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramu pùnampyire t'à pyi, Uzi, ná Uli, ná Gɛtɛri, ná Masi. ");
INSERT INTO spp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arifasadi, ur'à Shelaki si, ka Shelaki si Ebɛri si. ");
INSERT INTO spp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebɛri à pùnampyire shuunni si. Wà mɛge na mpyi Pelɛgi ɲaha kurugo yɛ uru tìiŋi i ɲìŋk'à táa. U sìɲɛɛŋi mɛge na mpyi Yokitan. ");
INSERT INTO spp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ur'à Alimɔdadi si, ná Shelɛfu, ná Kyazamawɛti, ná Yeraki, ");
INSERT INTO spp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ná Adoramu, ná Uzali, ná Dikila, ");
INSERT INTO spp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ná Obali, ná Abimayɛli, ná Seba, ");
INSERT INTO spp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ná Ofiri, ná Kyavila, ná Yobabu. Ɲyɛ pire puni pi ɲyɛ Yokitan tùluyi. ");
INSERT INTO spp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Pi mpyi a tɛ̀ɛn Mɛsha ná Sefari ɲaɲyi shwɔ̀hɔŋi canŋa fworompe e. ");
INSERT INTO spp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ɲyɛ Shɛmu tùluyi yi mpyi wani, yi ná yi tubaga, ná yi shɛɛnrɛ, ná yi cyaga, ná yi shi. ");
INSERT INTO spp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ɲyɛ Nuhu pyìibii bayi y'à pyi yire, yi mú ná yi tùluyo, ná yi shi. Sùpyire shiŋi u à caala cyeyi puni i ɲìŋke na, zànbwɔhe paŋkwooni kàntugo na ke, uru pun'à fworo Nuhu pyìibil'e. ");
INSERT INTO spp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tèecyiini i, diɲyɛŋi sùpyire puni mpyi na shɛɛnrɛ niŋkin yu, pi ɲjirigii kɛɛnŋkanni mú mpyi niŋkin. ");
INSERT INTO spp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Pi à yîri canŋa fworompe e mà kàr'a sà kaceebwɔhe kà ta Shiniyari kìni i, maa ntɛ̀ɛn kuru cyage e. ");
INSERT INTO spp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Canŋka, pi à yi jwo piy'á: «Yii a wá, wuu làfa wu, wuu u u fwɔ a waha.» Uru làfaŋi u pyi bage kafaayi, mánalwɔhe sí mpyi pwoore cyaga. ");
INSERT INTO spp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ka pi i jwo: «Yii a ma, wuu u kànha faanra, wuu u etazhi faanra, ŋge u sí raa bwùun kileŋi na ke. Lire pyiŋkanni na, wuu mɛge sí n-pêe, wuu sí n-wwɔ̀, yaaga sì n-jà wuu caala ɲìŋke na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ɲyɛ ka Kafooŋi Kile si ntîge mà pa kànhe ná etazhiŋi wíi, ɲje sùpyire mpyi na faanre ke. ");
INSERT INTO spp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Maa jwo: «Ɲyɛ yii pi wíi, pi pun'à pyi mu à jwo kìre niŋkin sùpyire ti, pi puni na jwumɔ niŋkin yu mú. Numɛ, pi à báaraŋi sìi. Pi aha ŋkwôro amɛ, pi aha yîri si kyaa maha kyaa pyi ke, yaaga sì n-jà pi sige lire na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wuu tîge, wuu u sà shɛɛnrɛ niɲyahara tîrige bà pi si mpyi pi àha raa piye jwumpe núru mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Lire Kafooŋi à pyi, maa pi caala a láha piye na, mà tùugo ɲìŋke cyeyi puni i. Ka pi i kànhe vàanreŋi ɲwɔ yyéreŋɛ. ");
INSERT INTO spp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Lire kurugo, kuru cyage mɛg'à le Babɛli, ɲaha na yɛ wani Kafooŋi à diɲyɛŋi sùpyire puni jwumpe wùrugo, wani Kile à sùpyire kɔ̀r'a caala ɲìŋke cyeyi puni i. (Babɛli ɲwɔge ku ɲyɛ ɲyàhaŋguruguŋi.) ");
INSERT INTO spp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ɲyɛ Shɛmu tùluge ku ɲyɛ ŋke. Mà Shɛmu shìŋi yaha yyee ŋkuu, u à Arifasadi si. Zànbwɔh'à tòro yyee shuunni ka lire si mpyi. ");
INSERT INTO spp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arifasadi zìŋi kàntugo, Shɛmu à yyee ŋkwuu kaŋkuro ta sahaŋki. Cyire funŋke e u à pyìibii piibɛrɛ ta. ");
INSERT INTO spp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Mà Arifasadi shìŋi yaha yyee beɲjaaga ná kɛ ná kaŋkuro, u à Shelaki si. ");
INSERT INTO spp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shelaki ziŋi kàntugo, Arifasadi à núr'a yyee ŋkwuu sicyɛɛre ná yyee taanre ta sahaŋki. Cyire funŋke e u à pyìibii piibɛrɛ ta. ");
INSERT INTO spp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Mà Shelaki shìŋi yaha yyee beɲjaaga ná kɛ, u à Ebɛri si. ");
INSERT INTO spp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebɛri ziŋi kàntugo Shelaki à yyee ŋkwuu sicyɛɛre ná yyee taanre pyi sahaŋki. Cyire funŋke e u à pyìibii piibɛrɛ ta. ");
INSERT INTO spp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Mà Ebɛri shìŋi yaha yyee beɲjaaga ná kɛ ná sicyɛɛre, u à Pelɛgi si. ");
INSERT INTO spp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelɛgi ziŋi kàntugo na, Ebɛri à yyee ŋkwuu sicyɛɛre ná yyee beɲjaaga ná kɛ pyi sahaŋki. Cyire funŋke e u à pyìibii piibɛrɛ ta. ");
INSERT INTO spp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Mà Pelɛgi shìŋi yaha yyee beɲjaaga ná kɛ, u à Erehu si. ");
INSERT INTO spp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Erehu ziŋi kàntugo Pelɛgi à yyee ŋkwuu shuunni ná baaricyɛɛre pyi sahaŋki. Cyire funŋke e u à pyìibii piibɛrɛ ta. ");
INSERT INTO spp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Mà Erehu shìŋi yaha yyee beɲjaaga ná kɛ ná shuunni, u à Serugi si. ");
INSERT INTO spp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugi ziŋi kàntugo, Erehu à yyee ŋkwuu shuunni ná baashuunni pyi sahaŋki. Cyire funŋke e u à pyìibii piibɛrɛ ta. ");
INSERT INTO spp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Mà Serugi shìŋi yaha yyee beɲjaaga ná kɛ, u à Nakwɔri si. ");
INSERT INTO spp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nakwɔri ziŋi kàntugo, Serugi à yyee ŋkwuu shuunni pyi sahaŋki. Cyire funŋke e u à pyìibii piibɛrɛ ta. ");
INSERT INTO spp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Mà Nakwɔri shìŋi yaha yyee beɲjaaga ná baaricyɛɛre u à Teraka si. ");
INSERT INTO spp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teraka ziŋi kàntugo, Nakwɔri à yyee ŋkuu ná yyee kɛ ná baaricyɛɛre pyi. Cyire funŋke e u à pyìibii piibɛrɛ ta. ");
INSERT INTO spp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mà Teraka shìŋi yaha yyee beetaanre ná kɛ, u à Burama ná Nakwɔri ná Aran si. ");
INSERT INTO spp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teraka u tùluge ku ɲyɛ ŋke. U à Burama ná Nakwɔri ná Aran si, ka Aran si Loti si. ");
INSERT INTO spp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aran à kwû mà tufooŋi yaha ɲyii na. U mpyi a si Kalide kìni i, wani u mú à kwû, Uri kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Burama ná Nakwɔri, ka pire si cyee lèŋɛ. Burama cwoŋi mɛge mpyi Sarayi, Nakwɔri wuŋi mɛge sí mpyi Milika, uru na mpyi Aran pworo. U pworoŋi wabɛrɛ mɛge na mpyi Yisika. ");
INSERT INTO spp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi na mpyi cijiriŋɛ, lire e ur'à pyi pyà baa. ");
INSERT INTO spp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ɲyɛ ka Teraka si Burama, ná Loti, ná Burama cwoŋi, Sarayi lwɔ́ a fworo Uri kànhe e, Kalide kìni i. Burama na mpyi Teraka jya, Loti sí ɲyɛ u ɲampyige, Sarayi sí ɲyɛ u napworo. Ka pi i yîri na ŋkɛ̀ɛge zà ntɛ̀ɛn *Kana kìni i. Ŋka pi à nɔ Kyaran kànhe e ke, ka pi i ŋkwôro wani. ");
INSERT INTO spp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teraka shìŋi canmpyaagil'à pyi yyee ŋkwuu shuunni ná kaŋkuro, maa ŋkwû Kyaran kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ɲyɛ Kafooŋi Kile mpyi a jwo Burama á: «Burama, fworo ma tupyɛnge e, fworo ma kànhe e, fworo ma kìni i; kìni mii sí n-cyêe mu na ke, ma a sà ntɛ̀ɛn lire e. ");
INSERT INTO spp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mii sí mu pyi sùpyishi niɲyahawa tu, si jwó le mu á, si mu mɛge pêe, si sùpyire sannte pyi ti jwó ta mu cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Shin maha shin u à jwó le mu á ke, mii sí jwó le urufol'á. Ŋka shin maha shin u à mu cùmɔ lemɛ pi ke, mii sí urufoo láŋa. Mii sí jwó le ɲìŋke sùpyishiŋi pun'á, mu cye kurugo.» ");
INSERT INTO spp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Ka Burama si ŋkàre bà Kafooŋi à yi jwo u á mɛ. U yyahafooŋi jyaŋi Loti mú à kàre ná u e. Burama à yîri Kyaran kìni i mà u shìŋi ta yyee beetaanre ná kɛ ná kaŋkuro, maa u cwoŋi Sarayi ná Loti ná pi cyeyaayi puni lwɔ́, ná pi báarapyiibii puni, ná yaaga maha yaaga pi à ta Kyaran kìni i ke, maa fwor'a kàre ná y'e *Kana kìni i. ");
INSERT INTO spp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Pi à nɔ Kana kìni i ke, maa ŋkàre fo Sikɛmu kànhe e, fo Mɔri cibwɔhe cyage e. Lire tèni i, Kana shiinbii na mpyi kìni i. ");
INSERT INTO spp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ka Kafooŋi si uye cyêe Burama na, maa yi jwo u á: «Mii sí nde kìni kan mu tùlug'á.» Ka Burama si sáraya tawwûgo yaa wani Kafooŋi á, ŋge u à uye cyêe u na ke. ");
INSERT INTO spp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Maa yîri kuru cyage e mà kàre ɲàɲyi woge e, Betɛli canŋafyinmpe e. Maa vàanŋa baya kwòro Betɛli kànhe ná Ayi woge shwɔ̀hɔŋi i. Betɛli à pyi canŋacwumpe e, Ayi sí ɲyɛ canŋafyinmpe e. Ka u u núr'a sáraya tawwûgo yaa wani Kafooŋi Kile á, maa u mɛge pêe. ");
INSERT INTO spp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Maa yîri kuru cyage e mà kàre yyaha na, na ntɛ̀n na wá Nɛgɛvi síwage kànmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ɲyɛ lire tèni i, katibwɔh'à cwo kìni na. Ka Burama si ŋkàre *Misira kìni i, si sà tɛɛnlɛ pyi wani, ɲaha na yɛ katege mpyi a pêe kìni i sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Pi niɲjyìibii Misira e, ka Burama si jwo u cwoŋi Sarayi á: «Mii à cè na mu lem'à ɲwɔ sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Misira shiinbii ká mu ɲya, pi sí n-jwo na mii cwoŋi u ɲyɛ mu, si mii bò, si mu yaha ɲyii na. ");
INSERT INTO spp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Lire e, mii na mu ɲáare, wuu aha nɔ wani, maa jwo na mu na ɲyɛ mii cɔɔn, bà pi si mpyi si mii cùmɔ lemɛ ɲwɔ mu kurugo, pi àha bú ŋkwɔ̀ na bò mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Burama ná u cwoŋ'à nɔ Misira e ke, ka Misira shiinbii si li ɲya na u cwoŋi lem'à ɲwɔ sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Misira saanŋi, Farɔn fyèɲwɔhɔshiinbii mú à u ɲya, maa u kyaa jwo u á ke, ka pi i u lwɔ́ a kàre Farɔn bage e. ");
INSERT INTO spp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Lire e, ka Farɔn si Burama cùmɔ lemɛ ɲwɔ Sarayi kurugo, maa mpàa ná sikyaa, ná nìiyi, ná dùfaanya, ná bilinambaa, ná bilicyee, ná dùfanɲcyee ná ɲwɔhɔɲya mú kan u á. ");
INSERT INTO spp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ŋka Kafooŋi Kile à pa yampimɛ wá Farɔn ná u pyɛnge shiinbii na, Burama cwoŋi Sarayi kurugo. ");
INSERT INTO spp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Farɔn à li ɲya amuni ke, ka u u Burama yyere, maa yi jwo u á: «Ɲaha mu à pyi mii na amɛ yɛ? Ɲaha na mu ɲyɛ a sèeŋi jwo mii á na mu cwoŋi wi mà yɛ? ");
INSERT INTO spp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ɲaha na mu à mii pyi na mu cɔɔnŋi wi yɛ, maa mii yaha mii à u lwɔ́ a pyi na cwo yɛ? Ma cwoŋi we, u lwɔ́ a yîri naha!» ");
INSERT INTO spp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Maa u shiinbii pyi na pi Burama ná u cwoŋi yige Misira kìni i, pi ná pi cyeyaayi puni. ");
INSERT INTO spp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ka Burama si yîri *Misira kìni i maa nta a kàre Nɛgɛvi síwage e ná u cwoŋi ná u cyeyaayi puni i. Loti mú mpyi ná u e. ");
INSERT INTO spp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Yatɔɔre ná wyɛ́rɛfyinŋi ná sɛɛnŋi mpyi a ɲyaha Burama á. ");
INSERT INTO spp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Lire kàntugo, ka u u yîri Nɛgɛvi síwage e na ntɛ̀n na ŋkɛ̀ɛge fo Betɛli kànmpanŋke na, fo cyage e u mpyi a fyânha a u vàanŋke bayi kwòro ke, Betɛli ná Ayi kànyi shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Cyage e u mpyi a fyânha a *sárayi tawwûge yaa ke, u à nɔ wani ke, maa Kafooŋi Kile mɛge pêe. ");
INSERT INTO spp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti u mpyi ná Burama e ke, u yatoore ná u pyɛngɛ shiinbii mpyi a ɲyaha mú. ");
INSERT INTO spp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Lire na, tatɛɛng'à cyɛ́rɛ pi mú shuunni i, ɲaha na yɛ pi cyeyaayi mpyi a ɲyaha sèl'e, pi mú shuunni mpyi na sì n-jà n-kwú cyage niŋkin i mɛ. ");
INSERT INTO spp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Mà bâra lire na, *Kana shiinbii ná Perezi shiinbii mú na mpyi kuru cyage e. Canŋka, ka yogo si mpa yîri Burama yatonahabii ná Loti wuubii shwɔhɔl'e, tatɛɛnge kurugo. ");
INSERT INTO spp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Burama à lire ɲya ke, ka u u jwo Loti á: «Maye sanŋa yaha, Loti, wuu àha yogo yaha ku yîri mii ná mu shwɔhɔl'e mɛ, lire ɲyɛ mɛ mii yatonahabii ná mu wuubii shwɔhɔl'e mɛ, ɲaha na yɛ wuu na ɲyɛ cìnmpyii. ");
INSERT INTO spp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kìn'à pêe. Ŋke puni ɲyɛ tatɛ̀ɛngɛ mà? Ta wá wuu u ntɛ̀ɛn tɛ̀ɛn wuu mɛgɛ cyeyi i. Kampyi kàmɛni kànmpanŋke k'à mu táan, ta sì wani, mii sí raa sì kàniŋɛ woge na. Kàniŋɛ kànmpanŋke sí ká nta kuru k'à táan mu á, ta sì wani, mii sí raa sì kàmɛni woge na.» ");
INSERT INTO spp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ka Loti si ɲùŋke yîrig'a Zhurudɛn bafage wíi, lwɔhe mpyi a ɲyaha kuru cyage e. Lire tèni i Kafooŋi mpyi na sàha ŋkwɔ̀ a Sɔdɔmu kànhe ná Gɔmɔri kànhe jyà mɛ, kuru cyage lemɛ mpyi a ɲwɔ fo mà sà nɔ Zowari kànhe na. K'à pyi mu à jwo Kafooŋi cikɔɔge nisìnaŋke ki, mu à jwo Misira kìni li. ");
INSERT INTO spp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Loti à kuru ɲya ke, ka u u Zhurudɛn bafage puni lwɔ́ a pyi u wogo, maa ŋkàr'a sà ntɛ̀ɛn kuru cyage e Betɛli canŋafyinmpe e. Lire pyiŋkanni na, Burama ná Loti à tɛ̀ɛn tɛ̀ɛn piye piye. ");
INSERT INTO spp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ka Burama si ntɛ̀ɛn Kana kìni i. Ka Loti si ŋkàr'a sà ntɛ̀ɛn kuru bafage kànyi yà shwɔhɔl'e, maa u vàanŋke bayi kwòro kwòro fo mà sà nɔ Sɔdɔmu kànhe byanhampe e, ");
INSERT INTO spp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sɔdɔmu kànhe shiinbii mpyi shinmpii. Pi mpyi na kapegigii niɲyahagii pyi Kafooŋi yyahe taan. ");
INSERT INTO spp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loti ná Burama tɛɛnŋkwooni kàntugo piye, ka Kafooŋi Kile si jwo Burama á: «Burama, ma ɲyiigii yîrige nìɲyiŋi na, cyage e mu ɲyɛ ke, tɛ̀ɛn wani ma a wíi suumɔkulo ná wòrokulo yyére, canŋafyinmɛ ná canŋacwumɔ yyére. ");
INSERT INTO spp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mu ɲyii wá kìni ndemu na ke, mii sí lire kan mu ná ma tùlug'á tèekwòmbaa. ");
INSERT INTO spp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mii sí mu tùluge ɲyaha bà ɲìŋke nticɛnŋi ɲyɛ mɛ. Kàmpyi sùpya sí n-jà ɲìŋke nticɛnŋi tɔ̀rɔ, ɲyɛ, sùpya mú sí n-jà mu tùluge sùpyire tɔ̀rɔ. ");
INSERT INTO spp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Yîri ma a kìni ɲaare, ma a li tɔɔnmpe ná li pèempe wíi, ɲaha na yɛ mu á mii sí li kan.» ");
INSERT INTO spp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ka Burama si vàanɲyi bayi kɔ̀ɔngɔ, ma a sà ntɛ̀ɛn Mamire cibwɔyi cyage e, kuru cyage na ɲyɛ Eburɔn taan. Ka u u núr'a sáraya tawwûgo yaa wani Kafooŋi mɛge na. ");
INSERT INTO spp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ɲyɛ lire tèni i, Amurafɛli à pyi Shiniyari kìni saanŋi, ka Ariyɔki si mpyi Elasari kànhe saanŋi, ka Kidɔlamɛri si mpyi Elami kìni saanŋi, ka Tidɛli si mpyi Golimi kùligii saanŋi, ");
INSERT INTO spp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","pire saanbii shiin sicyɛɛreŋ'à wwɔ̀ maa sà saanli kaŋkuro tùn. Pire saanbii mɛyi yi ɲyɛ ɲje: Sɔdɔmu saanŋi Bera, ná Gɔmɔri saanŋi Birisa, ná Adima saanŋi Shinɛyabi, ná Zeboyimi saanŋi Shɛmɛbɛri, ná Bela kànhe saanŋi, Bela mɛge ku ɲyɛ Zowari niɲjaa ke. ");
INSERT INTO spp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","4","Kuru kàshige ɲùŋke ku mpyi: yyee kɛ ná shuunni funŋ'i, saanŋi Kedolamɛri na mpyi pire saanbii kaŋkuruŋi ɲùŋɔ na. Ŋka yyeeni kɛ ná taanre wuuni i, pi à ɲùŋɔ kyán u na, maa piye ta Sidimi bafage e. (Suumpe Lwɔhe Ɲyii Yaaga Baa Woge ku ɲyɛ kuru cyage e niɲjaa.) ");
INSERT INTO spp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Lir'à pyi ke, yyeeni kɛ ná sicyɛɛre wuuni i, ka Kedolamɛri ná u saanɲɛɛbii si yîri, maa sí ta Arafayiti shiinbii na, lir'à pyi Asiterɔti Karinayimu kànhe e, maa sí ta Zuzi shiinbii na mú, lir'à pyi Amu kànhe e, maa sí ta Emi shiinbii na mú, Shave Kiriyatamu kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Maa sí ta Kwori shiinbii na mú, pi ɲaɲyi shwɔhɔl'e, na pi maha yire ɲaɲyi pyi Seyiri; maa pi kɔ̀r'a sà nɔ fo *Eli Paran taan, síwage ŋkère na. ");
INSERT INTO spp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Lire kàntugo, ka pi i mâhana a kàre Enimishipati kànhe e, pi maha kuru pyi Kadɛshi mú, maa Amalɛki shiinbii tùn mú, maa sí ta pi kùligii puni na, ná Amɔri shiinbii, pire mpyi a tɛ̀ɛn Kyazazɔn Tamari kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ɲyɛ Sɔdɔmu saanŋi, ná Gɔmɔri saanŋi, ná Adima saanŋi, ná Zeboyimu saanŋi, ná Bela kànhe wuŋi ná pi maha kuru kànhe pyi Zowari ke; pire saanbil'à bégel'a pa yyére kàshige mɛɛ na, Sidimi bafage e, ");
INSERT INTO spp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","maa jwo na pire sí Elami saanŋi Kedolamɛri, ná Goyimi saanŋi Tidɛli, ná Shiniyari saanŋi Amurafɛli, ná Elasari saanŋi Ariyɔki tùn. Ka pire saanbii sicyɛɛreŋi, ná pire saanbii kaŋkuruŋi si ntùyi taha piye na kàshige e. ");
INSERT INTO spp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ɲyɛ Sidimi bafage mpyi a ɲî mána lwɔhe kacyewyiyi na. Mà pi yaha kàshige na, ka Sɔdɔmu saanŋi ná Gɔmɔri wuŋi si fê, maa ntîg'a ŋwɔhɔ yire kacyewyiyi i, ka pi sanmpii si fê a kàre ɲaɲyi ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tèni i Kedolamɛri ná u fyèɲwɔhɔshiinbil'à jà pi na ke, ka pi i Sɔdɔmu ná Gɔmɔri shiinbii nàfuuŋi ná pi ɲwɔlyiŋi puni kul'a kàre. ");
INSERT INTO spp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Burama yyahawuŋi jyaŋi, Loti u mpyi a tɛ̀ɛn Sɔdɔmu kànhe e ke, ka pi i uru ná u cyeyaayi puni kul'a kàre piye cye e mú. ");
INSERT INTO spp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ka nàŋi wà si fê a shwɔ kàshige na, maa sà yire yyaha jwo Burama á. (Burama mpyi *Eburu shiŋi nàŋi wà.) Lir'à u ta u à tɛ̀ɛn Mamire cire cyage e. Mamire à pyi Amɔri u tùluge shinŋi wà. Esikɔli ná Anɛri mpyi u sìɲɛɛ. Pire mpii ná Mamire mpyi Burama wwoɲɛɛ. ");
INSERT INTO spp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tèni i Burama à lógo na u cìnmpworoŋi Loti na ɲyɛ cye e ke, ka u u u nàmbaabii pìi ŋkwuu taanre ná kɛ ná baataanre bégele kàshige mɛɛ na, mpii pi à si u yabiliŋi pyɛnge e ke. Ka pi i pire saanbii fyè tɔ̀rɔ fo Dan kùluni i. ");
INSERT INTO spp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ka u u u kàshikwɔɔnbii táa kuruyo kuruyo, maa pire saanbii tùn numpilag'e, maa sí ta pi na, maa pi kɔ̀r'a sà nɔ Kwoba kànhe na, kuru kànhe na ɲyɛ Damasi suumɔ kùlo kànmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Maa mpa ná pire saanbii nàfuuŋi niŋkuuŋi i ná u cìnmpworoŋi Loti ná u cyeyaayi puni ná cyeebii ná sùpyire puni pi mpyi a cû a kàre ke. ");
INSERT INTO spp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ɲyɛ Burama à kàr'a sà Kedolamɛri ná u saanɲɛɛbii tùn maa sí ta pi na ke, u nimpaŋi ka Sɔdɔmu saanŋi si fwor'a u ɲùŋɔ bɛ̂ Shava bafage e. Pi mpyi a kuru ŋke mɛge le Saanŋi Bafage. ");
INSERT INTO spp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ɲyɛ ka Salɛmu saanŋi Mɛlikisedɛki si mpa ná bwúuru ná *ɛrɛzɛn sinm'e Burama á, uru ŋge sí na mpyi Kile nìɲyi wuŋi sáragawwuŋi wà. ");
INSERT INTO spp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ka u u jwó le Burama á, maa jwo «Kile nìɲyi wuŋi ná uru u ɲyɛ nìɲyiŋi ná ɲìŋke yaafooŋi ke, uru u jwó le mu á, Burama. ");
INSERT INTO spp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kile nìɲyi wuŋi u kêe, ŋgemu u à mu zàmpɛɛnbii le mu cye e ke.» Ka Burama si u cyeyaayi puni yahaŋi wwû mà kan Mɛlikisedɛki á. ");
INSERT INTO spp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Lire kàntugo, ka Sɔdɔmu saanŋi si jwo Burama á: «Ɲyɛ na shiinbii kan na á, ma a ŋkwôro ná na nàfuuŋi i.» ");
INSERT INTO spp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ka Burama si u pyi: «Mii sí n-kâa Kafooŋi Kile na, Kile nìɲyi wuŋi, nìɲyiŋi ná ɲìŋke yaafooŋi, ");
INSERT INTO spp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","na mii sì yafyin shwɔ mu na mɛ, ali dìizi mɛɛ, lire ɲyɛ mɛ tanhaŋa mɛɛrɛ, ɲaha na yɛ ma hà bú ŋkwɔ̀ ɲjwo na mu à mii Burama pyi yaarafoo mɛ. ");
INSERT INTO spp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mii sì yafyin shwɔ mu na mɛ, mii ɲyɛ a jwo nàɲjiibil'á ɲjyìŋi ŋgemu lyî wani, ná mpii pi à kàre ná mii i kàshige takwɔ̀nge e ke, Anɛri, ná Ɛsikɔli, ná Mamire, pire mpii kɔni sí pi nàzhanŋi lwɔ́. ");
INSERT INTO spp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ɲyɛ ɲcyii karigii puni kàntugo na, ka Kafooŋi Kile si uye cyêe Burama na, maa jwo u á: «Burama, ma hà vyá mɛ, mii u ɲyɛ mu sancwɔnsigiŋi, mii sí kacɛnŋii niɲyahagii pyi mu á.» ");
INSERT INTO spp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Ka Burama si u pyi: «Kafooŋi, mii Kileŋi, pyà ɲyɛ mii á mɛ. Ɲaha mu sí n-sìi n-jà n-kan mii á, ŋkemu ku sí n-jà là ɲwɔ mii na yɛ? Mu ɲyɛ a tùlugo kan mii á mɛ. Mii bilinaŋi, Eliyezɛri, u à si mii pyɛnge e, ná u tuŋ'à yîri Damasi i ke, uru u sí n-pyi mii koolyiŋi.» ");
INSERT INTO spp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ka Kafooŋi si Burama pyi: «Uru ŋge bà u sì n-pyi mu koolyiŋi mɛ, mu yabiliŋi sí pyàŋi ŋgemu si ke, uru u sí mu kɔɔge lyî.» ");
INSERT INTO spp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Lire kàntugo, ka Kile si Burama yige ntàani na, maa yi jwo u á: «Burama, ma ɲùŋke yîrige ma a wɔrigii tɔ̀rɔ kàmpyi mu sí n-jà, ɲaha na yɛ mu tùluge mú sí ɲyaha amuni.» ");
INSERT INTO spp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ɲyɛ ka Burama si dá Kafooŋi Kile ɲwɔmugure na, ka Kafooŋi Kile si jwo na u à tíi u dániyaŋi cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Lire kàntugo ka Kafooŋi si jwo u á sahaŋki: «Mii u ɲyɛ Kafooŋi, ŋge u à mu yige Uri kànhe e, Kalide kìni i, maa nde kìni kan mu á ke.» ");
INSERT INTO spp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ka Burama si u pyi: «Kafooŋi, mii Kileŋi, ɲaha ku sí li cyêe mii na, si mii pyi mii u dá li na, na nde kìni sí n-pa n-pyi mii wuu yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ka u u jwo u á: «Yyee taanre nùcwo, ná yyee taanre sikacwo, ná yyee taanre mpàpoo cû, ná kuumpaan niŋkin ná mpánmpɔrɔgɔ niɲjaaga niŋkin.» ");
INSERT INTO spp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ka Burama si yire yaayi puni cû maa yi puni niŋkin niŋkinŋi táa niŋke e, maa yi kwɔnyi yaha yaha yiye sicama na. Saɲcyɛɛnre ti ke, u ɲyɛ a tire kwɔ̀n kwɔ̀n mɛ. ");
INSERT INTO spp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Saɲcyɛɛnre ti maha tiye ɲwɔ caa ná kyaare e ke, ka tire si wá na ntîre yatɔɔre nimbonte kurugo, ka Burama si wá na ti kɔ̀re. ");
INSERT INTO spp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ɲyɛ canŋaɲyiin'à pa a ŋkɛ̀ɛge tacwuge e ke, ka Burama si ŋɔ́n'a cùnnu. Ka numpini si u mâhana ka u u fyá sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ka Kafooŋi si jwo u á: «Burama, li cè na canŋka, mu tùluge sí n-kàre kìni labɛr'e si sà mpyi nàmpwuun. Pi sí n-pyi bilii lire kìni i, pi sí kànha fo si nɔ yyee ŋkwuu sicyɛɛre (400) na. ");
INSERT INTO spp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ŋka kìni li sí pi le tire bilere e ke, lire kìni sí n-kyaala mii cye e, lire kàntugo, mu tùluge sí n-yîri lire kìni i ná nàfuubwɔhe e. ");
INSERT INTO spp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mu wi ke, mu sí n-kwû yyeɲiŋke e. Mu sí lyɛge lage kwɔ̀ si nta ŋkwû. ");
INSERT INTO spp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Mu tùluge bage sicyɛɛre woge, ku sí núru n-pa naha, ɲaha na yɛ kìni sùpyire ti ɲyɛ Amɔri shiinbii ke, pi kapegigii ká nɔ tɛgɛni na, mii sí pi kɔ̀rɔ.» ");
INSERT INTO spp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ɲyɛ canŋa ɲyiin'à cwo mà numpini lèŋɛ tèni ndemu i ke, ka Kile si naŋkyanhii pyi cyi i nàŋguruge yige marii ɲî na ntùuli yatɔɔre kyaare nintáare ná tiye shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kuru canŋke yabiliŋi i, ka Kafooŋi si tunmbyaara le ná Burama e, maa yi jwo u á: «Mii sí nde kìni kan mu tùlug'á, mà lwɔ́ *Misira baŋi na, mà kàre babwɔhe na, ná pi maha kuru pyi Efirati. ");
INSERT INTO spp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Keni shiinbii ná Kenizi shiinbii, ná Kadimɔni shiinbii, ");
INSERT INTO spp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ná Kyeti shiinbii, ná Perezi shiinbii, ná Arafayi shiinbii, ");
INSERT INTO spp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ná Amɔri shiinbii, ná *Kana shiinbii, ná Girigashi shiinbii, ná Zhebusi shiinbii, pi à tɛ̀ɛn kuru cyage e.» ");
INSERT INTO spp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Ɲyɛ Burama à nɔ yyee kɛ na *Kana kìni i, mà u cwoŋi Sarayi ta u sàha ŋkwɔ̀ a pyà si u á mɛ. Ɲyɛ bilicwoŋi wà na mpyi Sarayi á, u mɛge mpyi Agari, *Misira shin u mpyi u wi. Ka Sarayi si jwo Burama á: «Wíi, Kafooŋi Kile à mii pyi cijiriŋɛ. Maye sanŋi yaha, ma a wwɔ̀ ná mii báarapyiŋi i, li sí n-jà n-ta uru sí pyà si mii á.» Ka u u ɲɛɛ Sarayi jwumpe na. Ɲyɛ Sarayi à u báarapyiŋi Misira shinŋi lwɔ́ lire pyiŋkanni na, mà kan u pooŋi Burama á, u pyi u cwo. ");
INSERT INTO spp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ka Burama si wwɔ̀ ná Agari e, ka u u yyére. Tèni i u à li ta na ur'à yyére ke, ka u u wá na yyejyeere pyi ná u kàfeɲcwoŋi i. ");
INSERT INTO spp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarayi à lire ɲya ke, ka u u yi jwo Burama á: «Nde Agari à pyi mii na numɛ ke, lir'à fworo mu i. Mii à na bilicwoŋi kan mu á. U à uye ɲya u à yyére ke, ka u yyahe si jyè mii woge e. Ɲyɛ Kafooŋi Kile u wuu láha wuye na!» ");
INSERT INTO spp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ka Burama si Sarayi pyi: «Mu bilicwoŋi na ɲyɛ mu yahare e, nde l'à táan mu á ke, lire mu sí n-pyi u na.» Yir'à jwo ke, ka Sarayi si kyaayi shiŋi puni tɛ̀gɛ Agari ɲuŋ'i, fo ka u u fê a fworo pyɛnge e mà kàre tatɔɔnge e. ");
INSERT INTO spp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ka Kafooŋi Kile Mɛlɛkɛŋi si Agari ɲya síwage e lùbiliŋi wà taan, uru lùbiliŋi na ɲyɛ Shuri síwage kuni taan. ");
INSERT INTO spp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Maa jwo Agari á: «Agari, Sarayi bilicwoŋi, taa mu à yîri ke, taa mu sì ke?» Ka u u jwo: «Mii na fî na kafeɲcwoŋi Sarayi yyaha na.» ");
INSERT INTO spp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ka Kafooŋi Kile Mɛlɛkɛŋi si jwo: «Núru ma a sì ma kafeɲcwoŋi yyére, ma a sà maye kan u á. ");
INSERT INTO spp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mii sí mu tùluge ɲyaha, fo ku sì n-jà n-tɔ̀rɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Wíi, mu yacerewu u ɲyɛ, mu sí n-si pùnambile, ma a u mɛge le Sumayila ɲaha na yɛ Kafooŋi à mu nàvunŋɔ parage lógo. ");
INSERT INTO spp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Uru pyàŋi sí n-pyi sige dùfaanŋa fiige, U sí n-pyi sùpyire puni kàshifoo, sùpyire puni mú sí n-pyi u kàshifoo. U sí n-láha u cìnmpyiibii na.» ");
INSERT INTO spp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ka Agari si jwo: «Ei! Sèe wi na ŋge u ɲyɛ na mii ɲaa ke, mii à uru ɲya la?» Maa kuru mɛge le Kile na: «Kileŋi u ɲyɛ na mii ɲaa ke». ");
INSERT INTO spp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Lire kurugo, Agari mpyi lùbiliŋi ŋgemu taan ke, uru mɛg'à le Lakyayi Ɔrɔyi (kuru mɛge ɲwɔhe ku ɲyɛ: «Ŋgemu u ɲyɛ ɲyii na ke, uru na mii ɲaa.») Uru lùbiliŋi na ɲyɛ Kadɛshi kànhe ná Bɛrɛdi kànhe shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ɲyɛ puru ɲwɔhɔ na, Agari à pùnambile si Burama á. Ka u u li mɛge le Sumayila. ");
INSERT INTO spp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Agari à Sumayila si Burama á, mà Burama shìŋi yaha yyee beecyɛɛre ná baani. ");
INSERT INTO spp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ɲyɛ mà Burama shìŋi yaha yyee beecyɛɛre ná kɛ ná baaricyɛɛre, ka Kafooŋi Kile si núr'a uye cyêe u na, maa u pyi: «Mii u ɲyɛ Kile síŋi puni foo. Ta mii ɲyii wogigii kanni pyi tìgire cyaga baa. ");
INSERT INTO spp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Lire e, mà tàanna ná wuu *tunmbyaare e, mii sí mu tùluge ɲyaha sèl'e.» ");
INSERT INTO spp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Burama à yire lógo ke, ka u u niŋkure sín, maa ɲùŋke sôgo maa Kile pêe. Ka Kile si núr'a jwo u á sahaŋki ");
INSERT INTO spp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Ɲyɛ wíi, tunmbyaare mii à le ná mu i ke, tire ti ɲyɛ nte: mu sí n-pyi sùpyishi niɲyahawa tu. ");
INSERT INTO spp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Mu mɛge saha sì n-pyi Burama mɛ. Ku sí n-kɛ̂ɛnŋɛ n-pyi *Ibirayima (Ibirayima mɛge ɲwɔhe ku ɲyɛ sùpyishi niɲyahawa tu), ɲaha na yɛ sùpyishi niɲyahawa sí n-fworo mu i. ");
INSERT INTO spp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mii sí mu pyìibii ɲyaha sèl'e. Mu pyìibii sí n-pyi sùpyishiŋi niɲyahawa, saanlii niɲyahamii sí n-fworo mu tùluyi i. ");
INSERT INTO spp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Tire tunmbyaare sí n-kwôro mii ná mu shwɔhɔl'e, ti sí n-pyi mii ná mu tùluyi shwɔhɔl'e tèrigii puni i mú. Ti sì n-kwɔ̀ mɛ. Lire kurugo, mii sí n-pyi mu ná ma tùluyi u Kileŋi. ");
INSERT INTO spp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","*Kana kìni i mu ɲyɛ niɲjaa nàmparantɛɛnre ke, mii sí lire kan mu ná ma tùluy'á. Li sí n-pyi pi wuu tèrigii puni i, mii sí n-pyi pi Kileŋi.» ");
INSERT INTO spp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ka Kile si núr'a jwo *Ibirayima á sahaŋki: «Mu ná ma tùluyi nimpaɲy'à yaa yii yákili yaha mii *tunmbyaare na, mà tàanna ná pi lyeɲwɔyi i. ");
INSERT INTO spp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nde yii à yaa yii pyi mà yyaha tíi ná tire tunmbyaare e ke, lire li ɲyɛ nde: mu ná ma tùluyi nimpaɲy'à yaa yii a pùnampyire puni kwùun. ");
INSERT INTO spp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Yii à yaa yii a ŋkwùun, lire li sí n-pyi mii ná yii tunmbyaare tafyeeŋi. ");
INSERT INTO spp_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Pùnampyire pun'à yaa ti kwɔ̀n ti canzege canmpyibataanre wuuni na mà tàanna ná pi lyeɲwɔyi i. Bilibii pi à si mu pyɛnge e ná mpii mu à shwɔ ke, pire pun'à yaa pi *kwɔ̀n. Lire e, tunmbyaare tafyeeŋi sí n-pyi yii sɛɛge na si li cyêe na ti sí n-pyi niŋkwombaara. ");
INSERT INTO spp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Pùnambilini ndemu ká mpyi li ɲyɛ a kwɔ̀n, maa uru fyèŋi yaha u sɛɛge na mɛ, ur'à yaa u kɔ̀r'a láha u kìni shiinbii na, ɲaha na yɛ u ɲyɛ a yákili yaha mii tunmbyaare na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ɲyɛ puru ɲwɔhɔ na, Kile à yi jwo *Ibirayima á sahaŋki: «Ma hà núru raa ma cwoŋi Sarayi yiri sahaŋki Sarayi mɛ. Numɛ u mɛge sí n-kɛ̂ɛnŋɛ n-pyi Sara ");
INSERT INTO spp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mii sí jwó le u á, si pyà kan u á mu á. Mii sí jwó le u á si u pyi sùpyishi niɲyahawa nu. Saanlii sí n-fworo u e mú.» ");
INSERT INTO spp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibirayima à puru lógo ke, ka u u niŋkure sín maa ɲùŋke sôgo, maa Kile pêe. Maa ɲcyàha maa jwo uye funŋ'i: «Sùpyaŋi u à yyee ŋkuu ta ke, di uru sí pyà ta n-jwo yɛ? Sara shìŋi na ɲyɛ yyee beecyɛɛre ná kɛ, di uru sí n-jà pyà ta n-jwo sahaŋki yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Maa jwo Kile á: «Sumayila yaha u shì ta, ma a jwó le u á.» ");
INSERT INTO spp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ka Kile si u pyi: «Mii à lógo mu ɲwɔ na, ŋka mu cwoŋi Sara sí n-sìi pùnambile si. Ma a li mɛge le Ishaka. Mii sí n-kwôro na *tunmbyaare na ná u e, ná u tùluge e. Tire tunmbyaare sì n-kwɔ̀ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Sumayila wi ke, nde mu à ɲáare u kyaa na ke, mii sí lire pyi mu á. Mii si jwó le á, si u pyìibii ɲyaha, si u tùluge ɲyaha sèe sèl'e. U sí ɲùŋufee kɛ ná shuunni si, mii sí u pyi tùlubwɔhɔ tu. ");
INSERT INTO spp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ŋka nde li ɲyɛ mii tùnmbyɛɛre e ke, pyàŋi Sara sí n-si mu á yyeela numɛ cyiin ke, tire sí n-pyi mii ná ure shwɔhɔl'e mú.» ");
INSERT INTO spp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ɲyɛ Kile à puru jwumpe jwo a kwɔ̀ *Ibirayima á ke, ka u u yîri u taan maa dùgo nìɲyiŋi na. ");
INSERT INTO spp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ɲyɛ kuru canŋke, Ibirayima à Sumayila *kwɔ̀n, bilibii pi à si u pyɛnge e ná mpii u à shwɔ ke, maa pire kwɔ̀n. Pùnambile maha pùnambile li ɲyɛ u pyɛnge e ke, Ibirayima à pire puni kwɔ̀n, bà Kile à yi jwo u á mɛ. ");
INSERT INTO spp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibirayima yabiliŋ'à kwɔ̀n mà u shìŋi yaha yyee beecyɛɛre ná kɛ ná baaricyɛɛre. ");
INSERT INTO spp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","U jyaŋi Sumayila à kwɔ̀n mà u shìŋi yaha yyee kɛ ná taanre. ");
INSERT INTO spp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ɲyɛ lire pyiŋkanni na, Ibirayima ná u jyaŋi Sumayila à kwɔ̀n cannugo. ");
INSERT INTO spp_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Bilinambaabii pi à si u pyɛnge e ná mpii u à shwɔ ke, u à pire puni kwɔ̀n mú. ");
INSERT INTO spp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ɲcyii karigii puni kàntugo na, Kafooŋi Kile à uye cyêe *Ibirayima na sahaŋki Mamire cibwoyi taan. Pyiŋkanni na u à uye cyêe Ibirayima na ke, lire li ɲyɛ nde. Canŋka, mà u nintɛɛnŋi yaha u vàanŋke bage ɲwɔge na canvwuge tèni i, ");
INSERT INTO spp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","u à pa u ɲùŋke yîrige, maa wíl'a nàmbaa taanre ɲya pi à yyére u yyetiimpe na. Tèni i u à pi ɲya ke; ka u u fê a pi ɲùŋɔ bɛ̂, maa niŋkure sín pi taan maa ɲùŋke sôgo, maa pi shɛ́ɛre, ");
INSERT INTO spp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","maa jwo pi wà niŋkin á: «Mii ɲùŋufooŋi, kampyi mii kyal'à táan mu á, mii na mu ɲáare, mii u ɲyɛ mu bilinaŋi ke, ma hà ntòro na pyɛnge taan mɛ. ");
INSERT INTO spp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yii yyére, pi i mpa ná lwɔhe e, yii tooyi si jyé. Yii i ŋɔ̀ naha ŋke cige ɲwɔh'i. ");
INSERT INTO spp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mii sí n-sà yalyîre cya mpa ŋkan yii á, bà yii si mpyi si fànha ta si nta yii kuni lwɔ́ mɛ. Ɲaha kurugo yɛ yii à tòro yii bilinaŋi yyére.» Ka pi i jwo: «Li pyi amuni.» ");
INSERT INTO spp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ka Ibirayima si fyâl'a jyè Sara fye e u vàanŋke bage e, maa yi jwo u á: «Ta fyâa, maa mbyìmɛ yaɲyɛyi taanre súma, maa tàntɛɛnɲyɛ te.» ");
INSERT INTO spp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","U à puru jwo ke, maa fê a kàre u kàcwɔge na, maa u ninage sìnmɛ woge kà cû mà kan u báarapyiŋi wà á. Ka u u kuru bò, maa ku yal'a shwɔhɔ fwɔfwɔ. ");
INSERT INTO spp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Puru ɲwɔhɔ na, ka Ibirayima si mpa ná nùjirintanhaga ná nimpuruge e, ná nùkyaare nizhwɔhɔre e, mà pa yaha nàmbaabii taanreŋi taan, maa yyére pi taan cige mbyìmpe e, ɲjyìŋi ká ŋkùuŋɔ si wà kan pi á. Ka pi taanreŋi si wá na lyî. ");
INSERT INTO spp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ka pi i Ibirayima yíbe: «Taa mu cwoŋi Sara ɲyɛ ke?» Ka u u pi pyi: «U na ɲyɛ naha vàanŋke bage e.» ");
INSERT INTO spp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ka pi wà niŋkin si jwo: «Nàkaana ɲyɛ mɛ, mii sí núru n-pa naha mu yyére yyeela numɛ cyiin. Lire sí mu cwoŋi ta u à pùnambile si.» Sara mpyi u pooŋi kàntugo, vàanŋke bage e, marii puru jwumpe núru. ");
INSERT INTO spp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Lire tèni i, Ibirayima ná Sara mpyi a lyɛ sèe sèl'e. Sara pyìtaani tèni mpyi a tòro. ");
INSERT INTO spp_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ɲyɛ Sara à yire lógo ke, ka u u ɲcyàha uye funŋ'i. Maa jwo: «Tatange ŋkire mii niɲjyeŋkwoŋi saha sí n-ta nàŋkwu i fo si zà nɔ pyà nta na yɛ? Mii pyɛngefoo mú à lyɛ.» ");
INSERT INTO spp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ka Kafooŋi si jwo Ibirayima á: «Ɲaha kurugo Sara à cyàha uye funŋ'i, maa jwo na uru niɲjyeŋkwoŋi saha sì n-jà pyà ta sèeŋi na mà yɛ? ");
INSERT INTO spp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kani ndire li sí n-jà n-waha fo si Kafooŋi, mii Kile jà yɛ? Yyeela numɛ cyiin, mii sí n-pa mu yyére. Lire sí mu cwoŋi Sara ta u à pyà ta.» ");
INSERT INTO spp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Puru jwump'à jwo ke, ka Sara fyagara wuŋi si yi kyáala maa jwo: «Mii ɲyɛ a cyàha a dɛ!» Ka Kafooŋi Kile si jwo: «Mu à sàa cyàha.» ");
INSERT INTO spp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ɲyɛ lire kàntugo, ka pire nàmbaabii taanreŋi si yîri na ŋkɛ̀ɛge maa dùgo ɲaŋke kà na maa Sɔdɔmu kànhe kànmpanŋke wíi. Ka *Ibirayima si pi tùugo. ");
INSERT INTO spp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ka Kafooŋi Kile si uye yíbe: «Nde mii sí n-pyi Sɔdɔmu ná Gɔmɔri kànyi na ke, tá mii à yaa mii u lire ŋwɔhɔ Ibirayima na bɛ? ");
INSERT INTO spp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ɲaha na yɛ nàkaana ɲyɛ sìi mɛ, Ibirayima sí n-pyi tùlubwɔhɔ tu, kuru tùluge fànhe sí n-pêe. Diɲyɛ tùluyi sanɲyi sí jwó ta u cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mii à u cwɔɔnrɔ bà u si mpyi si yi jwo u pyìibii ná u pyɛnge shiinbil'á mpii pi na ma u kàntugo ke, na pi à Kafooŋi, mii Kile kuni ɲaare li ɲaareŋkanni na, pi à li ɲaare ntìiŋi ná sèeŋi ɲuŋ'i. Lire ká mpyi, mii à kyaa maha kyaa ɲwɔmɛɛ lwɔ́ Ibirayima á ke, mii sí lire pyi u á.» ");
INSERT INTO spp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Lire kurugo, Kafooŋi à jwo Ibirayima á: «Sɔdɔmu kànhe ná Gɔmɔri kànhe shiinbil'à lawwuge ŋkemu ta ke, kur'à pêe fo mà tòro, pi kapegigil'à ɲyaha sèe sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Lire na, mii sí n-tîge n-sà wíi, l'aha nta ɲje pi na yu pi na ke, yire na ntùuli yi jwuŋkanni na, sèeŋi na, si ɲcè.» ");
INSERT INTO spp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ka nàmbaabii shuunniŋi sanmpii si yîri Ibirayima taan mà kàre Sɔdɔmu kànha kànmpanŋke na. Ŋka Ibirayima niɲjyéreŋ'à kwôro Kafooŋi yyaha taan. ");
INSERT INTO spp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Maa file u na maa jwo: «Mu sí ɲɛɛ shiincɛɛnmpii ná shiinmpiibii shi bò siɲcyan la? ");
INSERT INTO spp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Li sí n-jà n-ta shiincɛɛnmii beeshuunni ná kɛ na ɲyɛ kànhe e. Mu sí ɲɛɛ pire shi bò mú la? Mu sì kànhe yaha wani pire mpii kurugo mà? ");
INSERT INTO spp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Mà shiincɛɛnmpii ná shiinmpiibii puni shi bò siɲcyan, lire ɲyɛ mɛ mà pi sàraŋi tàanna, mii à cè na mu sì n-sìi ɲɛɛ lire shiŋi i mɛ. Mu u ɲyɛ diɲyɛŋi sùpyire puni sàrafooŋi mà tàanna ná pi kapyiiŋkil'e ke, mu sí n-jà n-pyi na mu ɲyɛ a kacɛnni cè a wwû kapiini i mà?» ");
INSERT INTO spp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ka Kafooŋi si u pyi: «Mii aha shiincɛɛnmii beeshuunni ná kɛ ta Sɔdɔmu i, mii sí kànhe puni yaha wani pire mpii kurugo.» ");
INSERT INTO spp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ka Ibirayima si u pyi: «Mii kàfooŋi, mii à cè na mii ɲyɛ yafyin mu taan mɛ, ŋka mii na mu ɲáare ma a na yaha si jwo sahaŋki. ");
INSERT INTO spp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Li sí n-jà n-ta kànhe shiincɛɛnmpii ɲyɛ a beeshuunni ná kɛ kwɔ̀ mɛ. Shiin kaŋkuro sí n-jà n-fô. Ɲyɛ kaŋkuro kanna ká fô shiin beeshuunni ná kɛŋi i, pire kaŋkuruŋi kurugo mu sí kànhe puni shi bò la?» Ka u u jwo: «Mii aha beeshuunni ná kaŋkuro ta, mii sí kànhe yaha wani pire mpii kurugo.» ");
INSERT INTO spp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ka Ibirayima si núr'a jwo: «Li sí n-jà n-ta kànhe shiincɛɛnmpii ɲyɛ a tòro beeshuunni na mɛ.» Ka Kafooŋi Kile si jwo: «Pire mpii kurugo mii sì yaaga pyi kànhe na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ka Ibirayima si núr'a jwo: «Mii kàfooŋi, ma hà lùuni yîrige na taan mɛ. Mii sí n-jwo sahaŋki, l'aha nta kànhe shiincɛɛnmpii pun'à bɛ̂ beɲjaaga ná kɛ na de?» Ka u u jwo: «Mii aha beɲjaaga ná kɛ ta wani, mii sì yaaga pyi kànhe na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ka Ibirayima si jwo: «Mii kàfooŋi, mii na mu ɲáare si jwo sahaŋki, li sí n-jà n-ta kànhe shiincɛɛnmpii pun'à bɛ̂ beɲjaaga na?» Ka u u jwo: «Pire beɲjaagaŋi kurugo, mii sì kànhe shi bò mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ka u u núr'a jwo: «Mii kàfooŋi, ma hà lùuni yîrige na taan mɛ, mii jwumpe sí n-yyére ŋke cyage e. Ɲyɛ kànhe shiincɛɛnmpii puni ká mpyi kɛ de?» Ka u u jwo: «Pire kɛŋi kurugo, mii sì kànhe shi bò mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kafooŋi Kile à jwo a kwɔ̀ ná Ibirayima e ke, maa yîri u taan. Ka Ibirayima si núr'a kàre u pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ɲyɛ pire *Kile mɛlɛkɛɛbii shuunniŋi pi à yîri *Ibirayima yyére ke, pir'à nɔ Sɔdɔmu i kuru canŋke yàkoŋke. Maa Loti nintɛɛnŋi ta kànhe shiinbii piyetabeŋke e. U à pi ɲya ke, ka u u yîr'a pi ɲùŋɔ bɛ̂. Maa niŋkure sín, maa ɲùŋke sôgo, maa pi shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Maa jwo: «Mii ɲùŋufeebii, mii na yii ɲáare, yii sumbage lèŋɛ mii, yii bilinaŋi, pyɛnge e, si lwɔhe kan yii á, yii i yii tooyi jyé, yii i shwɔ̀n naha. Nùmpanŋa ɲyɛsɔɔge na, yii i ntòro ná yii kùsheeni i.» Ka Kile mɛlɛkɛɛbii si u pyi: «Ɔnhɔ, wuu sí n-shwɔ̀n naha cyíinŋi na.» ");
INSERT INTO spp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ka Loti si yi jwo a waha pi á, fo pi à kàr'a sà shwɔ̀n u pyɛnge e. Maa ɲjyì nintan shwɔhɔ, maa bwúuruŋi niɲjîrimbaaŋi wà yaa, ka pi i lyî. ");
INSERT INTO spp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mà nàmpwuunbii yaha sínimbaa, ka Sɔdɔmu kànhe shiinbii si mpa pyɛnge kwûulo. Nàɲjiibii ná nàŋkolyeebii puni na mpyi wani. ");
INSERT INTO spp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ka pi i Loti yyere maa yi jwo u á: «Nàmpwuunbii pi à sumbage lèŋɛ mu pyɛnge e ŋke numpilage e ke, taa pi de? Pi yige naha, wuu u pi shwɔ̀n!» ");
INSERT INTO spp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ka Loti si fwor'a pa pi fye e cyíinŋi na, maa tajyìge ɲwɔge shwɔhɔ nàmpwuunbii na. ");
INSERT INTO spp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Maa jwo sùpyir'á: «Mii cìnmpyiibii, mii à yii ɲáare, yii àha kapii pyi pi na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mii pùcɛrii shuunni na ɲyɛ naha, pi sàha nàmbaa cè mɛ, mii sí pire yige yii á, nde l'à táan yii á ke, yii i lire pyi pi na. Yii àha yaaga pyi mii nàmpwuunbii na mà dɛ!» ");
INSERT INTO spp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ka kànhe shiin si jwo Loti á: «Mu u yîr'ani dɛ!» Ka pìi si jwo: «Yii pi ŋge nàŋi wíi dɛ, uru nàmpɔnŋi u à núr'a kɛ̂ɛnŋɛ na *saliyaŋi cyêre wuu na numɛ!» Ka pi i jwo Loti á: «Mu aha mpyi mu ɲyɛ a yîri wuu yyaha na numɛ mɛ, nde wuu sí n-pyi mu na ke, lire sí n-pi mà tòro nàmpwuunbii wuuni na.» Pi à yire jwo ke, maa Loti ŋɔɔŋ'a lwɔ́ wani fànhe e, maa file na pire na si pyɛnge ɲwɔge kebe. ");
INSERT INTO spp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Lire tèni i, ka Kile mɛlɛkɛɛbii mú shuunniŋi si pyɛnge múgo, maa Loti cû a lèŋɛ ku funŋke e, maa ku shwɔ̂hɔ. ");
INSERT INTO spp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Sùpyire puni ti mpyi pyɛnge ɲwɔge na ke, mɛlɛkɛɛbil'à tire puni pyi fyinmii, nàɲjii bâra nàŋkolyee na. Pi à pyi fyinmii ke, ka pi i pyɛnge ɲwɔge cya a kànha. ");
INSERT INTO spp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ka Kile mɛlɛkɛɛbii mú shuunniŋi si jwo Loti á: «Mu nafeebii, mu pùnampyire, mu pùceepyire, shin maha shin u ɲyɛ mu sùpya ke, pi puni yige ŋke kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Wuu sí ŋke kànhe shi bò, ɲaha na yɛ tìgire pi na ɲcyáan ku shiinbii na ke, tire tìgir'à pêe sèl'e Kafooŋi Kile yyahe taan. Lire e, u à wuu tun wuu u pa ku shi bò.» ");
INSERT INTO spp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ɲyɛ ka Loti si fworo mà kàr'a sà jwo ná u pùcɛribii tanambaabil'e, maa jwo pi á: «Yii fworo ŋke kànhe e, ɲaha na yɛ Kafooŋi Kile sí n-pa ku shi bò!» Ŋka pire mpyi a li yaha bàhaga na u ɲyɛ. ");
INSERT INTO spp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ɲyɛ ɲyɛ̀kwɔng'à nɔ ke, ka Kile mɛlɛkɛɛbii si li jwo a waha Loti á sahaŋki: «Yîri wahawaha, ma a ma cwoŋi ná ma pùceepyire mú shuunniŋi cû cyɛge na, bà pi si mpyi pi àha bú ŋkwû ná kànhe e tasógoge e mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ɲyɛ Kile mɛlɛkɛɛbil'à li ɲya pi à ɲíŋɛ karigii tapyige e ke, ka pi i Loti cû cyɛge na, ná u cwoŋi ná u pùceepyire mú shuunniŋi, maa fworo ná pi e mà sà yaha kànhe kàntugo, ɲaha na yɛ Kafooŋi Kile la mpyi si pi shwɔ kwùŋi na. ");
INSERT INTO spp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Pi à fwor'a kwɔ̀ kànhe e ke, ka Kile mɛlɛkɛŋi wà si jwo: «Yii a fî shwomɔ. Yii àha raa wíi kàntugo mɛ. Yii mú sí kà n-yyére ŋke bafage cyage k'e mɛ. Yii a fî, yii a sì ɲaɲyi cyage e, bà yii si mpyi si shwɔ kwùŋi na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ka Loti si jwo: «Aa! mii ɲùŋufooŋi, wuu sí n-jà kuru cyage ta la? ");
INSERT INTO spp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mu à ɲwɔ wuu na, maa wuu ɲùɲaara ta mà nɔ fo naha, ŋka wuu sì n-jà n-fê nɔ ɲaɲyi cyage e mɛ, ɲaha na yɛ mà jwo wuu nɔ wani ke, kakyaare sí n-pyi, wuu sí n-kwû. ");
INSERT INTO spp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kànhe kà ku ŋke, kuru laage ɲyɛ a tɔɔn mɛ. Wuu sí n-jà n-fê nɔ wani, si sà ŋwɔhɔ, kuru kànhe mú ɲyɛ a pêe mɛ. Yii yiye sanmii yaha, yii kuni kan wuu á, wuu sà ŋwɔhɔ wani lire kànbileni na. Kànbwɔhɔ bà mo. Yii wuu yaha wuu sà wuye shwɔ wani.» ");
INSERT INTO spp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ka Kile mɛlɛkɛŋi si jwo Loti á: «Ɲyɛ mii sí nde kani niŋkin pyi mu á sahaŋki. Kànhe kyaa mu à jwo ke, mii sì yaaga pyi ku na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Yii a fyâa, yii sà ŋwɔhɔ wani, ɲaha na yɛ ná yii ɲyɛ a nɔ wani mɛ, kuni ɲyɛ a kan mii á mii i jà a yafyin pyi mɛ. Loti à kuru kànhe yyere nimbilere, lire e, kuru kànhe mɛg'à le Zowari. (Zowari mɛge ɲwɔhe ku ɲyɛ nimbilere.) ");
INSERT INTO spp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Loti tèenɔni Zowari kànhe e, lir'à bɛ̂ ná canŋaɲyiini tèefworoni i. ");
INSERT INTO spp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Lire tèni i, ka Kafooŋi Kile si nage ná ŋkirigiŋi tîrige Sɔdɔmu ná Gɔmɔri ɲuŋ'i zànpya fiige. Kafooŋi yabiliŋi u à lire pyi. ");
INSERT INTO spp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Maa yire kànyi puni shi tò, ná bafage, ná ku kànyi shiinbii puni, ná yaaga maha yaaga ku mpyi a fyîn kuru ɲìŋke na ke, yire pun'á súugo kuru nage cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ɲyɛ pi niŋkàribii na, Loti cwoŋ'à yyaha kɛ̂ɛnŋ'a wíi kàntugo. Ka u u ŋkɛ̂ɛnŋ'a pyi suuŋkunuŋɔ sùpya fiige. ");
INSERT INTO spp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ɲyɛ kuru canŋke ɲyɛsɔɔge na, cyage e Ibirayima à jwo ná Kafooŋi i ke, ka u u yîr'a kàre wani kuru tanuge e. ");
INSERT INTO spp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Maa ɲùŋke yîrig'a wíi Sɔdɔmu ná Gɔmɔri kànyi ná kuru bafage kànmpanŋke puni i. Maa naŋgurugo ɲya ku u yîri ɲìŋke na, mu à jwo maan naŋgurugo. ");
INSERT INTO spp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Canŋke Kile mpyi na kuru bafage kànyi súuge ke, u funŋk'à cwo Ibirayima na, maa Loti shwɔ nage na. Lire pyiŋkanni na, kànyi na Loti mpyi a tɛ̀ɛn ke, nag'à yire puni shi tò. ");
INSERT INTO spp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ɲyɛ Loti ɲyɛ a ɲɛn'a kwôro Zowari kànhe e mɛ, maa ŋkàr'a sà ntɛ̀ɛn ɲaŋke kànmpanŋke na, ɲaha na yɛ u mpyi na fyáge. U ná u pworibii mú shuunniŋ'à sà ntɛ̀ɛn ɲaŋke wyige k'e. ");
INSERT INTO spp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Canŋka, Loti pworoŋi niɲjyêŋ'à jwo nimbilen'á: «Wuu tuŋ'à lyɛ, nɔ̀ mú sì ɲyɛ naha ŋgemu u sí wuu lèŋɛ nàmbaga na, bà li ɲyɛ cyeyi puni i mɛ. ");
INSERT INTO spp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Wuu *ɛrɛzɛn sinmɛ kan u bya, bà u funŋke si mpyi si wùrugo mɛ. Lire ká mpyi, wuu u wwɔ̀ ná u e, bà wuu si mpyi si pyìi ta wuu tuŋi tùluge kà mpîni mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kuru canŋke numpilage e, ka pi i sinmpe kan pi tuŋ'á. P'à u cyán ke, ka pworofooŋi niɲjyêŋi si sà sínni ná u e. Ŋka tufooŋi ɲyɛ a u tèesinnini ná u tèeyirini cè mɛ. ");
INSERT INTO spp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ɲyɛ̀g'à múgo ke, ka mucwofooŋi si cɔɔnfooŋi pyi: «Pìlaga mii à sínni ná wuu tuŋi i. Niɲjaa numpilage e, wuu sinmpe pà kan u á, u àha bya a wùrugo, mu sí n-sà sínni ná u e, bà mu mú si mpyi si pyàŋi wà ta, wuu tuŋi tùluge kà mpîni mɛ. ");
INSERT INTO spp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kuru canŋke numpilage e, ka pi i sinmɛ kan tufooŋ'á sahaŋki, ka u u bya fo mà wùrugo. Ka pworofooŋi nimbileni si sínni ná u e. Tufooŋi ɲyɛ a u tèesínnini ná u tèeyirini cè mú mɛ. ");
INSERT INTO spp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ɲyɛ amuni Loti pworibii mú shuunniŋ'à lahigii lwɔ́ u á. ");
INSERT INTO spp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ka pworofooŋi niɲjyeŋi si si pùnambile na, maa u mɛge le Mwabi. (Mwabi mɛge ɲwɔhe ku ɲyɛ: «Tufooŋ'à laa tɛ̀gɛ u na.») Uru u ɲyɛ Mwabi shiŋi tulyage fo mà pa nɔ niɲjaa na. ");
INSERT INTO spp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ka cɔɔnfooŋi si si pùnambile na mú, maa u mɛge le Bɛni Ami. Uru u ɲyɛ Amɔni shiŋi tulyage fo mà pa nɔ niɲjaa na. ");
INSERT INTO spp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ɲyɛ ka *Ibirayima si yîri u tatɛɛnɲjyɛge e, mà sà ntɛ̀ɛn Nɛgɛvi síwage yyére, Kadɛshi kànhe ná Shuri kùluni shwɔhɔl'e. Puru ɲwɔhɔ na, u à tɛɛnlɛ pyi Gerari i mú. ");
INSERT INTO spp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ɲyɛ u à nɔ wani ke, maa yi jwo sùpyir'á na Sara na ɲyɛ uru cɔɔn. Canŋka, ka Gerari saanŋi Abimɛlɛki si Sara ɲya maa u lwɔ́ si mpyi u cwo. ");
INSERT INTO spp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Numpilage k'e, ka Kile si uye cyêe Abimɛlɛki ná ŋɔɔge k'e, maa yi jwo u á: «Abimɛlɛki, mu sí n-kwû, ceeŋi mu à lwɔ́ ke, nɔ na ɲyɛ u á.» ");
INSERT INTO spp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ɲyɛ lir'à ta Abimɛlɛki sàha ŋkwɔ̀ a wwɔ̀ ná Sara e mɛ. Ka u u jwo Kile á ŋɔɔge e: «Kafooŋi, mu sí ɲɛɛ mii ná na tùluge shi bò mà li ta wuu ɲyɛ a kapii pyi mà? ");
INSERT INTO spp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nàŋi yabiliŋi bà u à mii pyi na uru cɔɔn wi mà? Ka ceeŋi mú si jwo na uru yyahafoo wi mà? Mii à nde kani pyi ná funvyinge e, mii ɲyɛ a kapii pyi mà dɛ!» ");
INSERT INTO spp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ka Kile si yi jwo Abimɛlɛki á kuru ŋɔɔge niŋkinŋi i: «Mii à cè na mu à nde kani pyi ná funvyinge e, na mu ɲyɛ a kapii pyi mɛ, lire na mii ɲyɛ a ɲɛn'a mu yaha mu u wwɔ̀ ná ceeŋi i, si ŋkwɔ̀ kapii pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Numɛ, nàŋi cwoŋi kan u á. U sí jwó le mu á bà mu si mpyi si shwɔ kwùŋi na mɛ, ɲaha na yɛ Kile sùpya u ɲyɛ u wi. Ŋka mu aha mpyi mu ɲyɛ a u cwoŋi kan u á mɛ, li cè na mu ná ma pyɛnge shiinbii puni sí n-kwû.» ");
INSERT INTO spp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ka Abimɛlɛki si yîri kuru ɲyɛsɔɔge na, maa u bilibii puni yyere, maa yi yyahe jwo pi á. Pir'à yi lógo ke, ka pi i fyá sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ka Abimɛlɛki si Ibirayima mú yyere, maa u pyi: «Ɲaha shi mu à pyi wuu na amɛ yɛ? Lire tèni i ke, kapiini ndire mii à pyi mu na, fo mà pa nɔ mu u ŋke lawwuge fiige nɔ mii ná na kìni shiinbii na yɛ? Nde mu à sà a pyi amɛ ke, li ɲyɛ a sìi kapyii mɛ. ");
INSERT INTO spp_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ɲaha na mu à nde pyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ka Ibirayima si jwo: «Mii mpyi na sɔ̂nŋi na sùpya ɲyɛ a sìi nde kìni i ŋgemu u na Kile pêre mɛ. Maa li yaha naye funŋ'i, na pi sí mii bò na cwoŋi kurugo. Lire na, mii à jwo na mii cɔɔn wi. ");
INSERT INTO spp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Lire na li wuuni mú i, mii cɔɔn mú wi dɛ! Wuu na ɲyɛ tu na, ŋka wuu ɲyɛ nu na mɛ. Mii cwo mú sí u ɲyɛ u wi. ");
INSERT INTO spp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lire kurugo, canŋke Kile à mii yige na tupyɛnge e ke, mii à yi jwo Sara á: «Nde mii na ɲáare mu á ke, wuu aha nɔ cyaga maha cyag'e, ma a yi jwo sùpyir'á na mii na ɲyɛ mu yyahafoo.» ");
INSERT INTO spp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ka Abimɛlɛki si sikyaa ná mpàa ná nìiyɛ, ná bilinambaa ná bilicyee kan Ibirayima á, maa u cwoŋi Sara núruŋ'a kan u á. ");
INSERT INTO spp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Maa jwo Ibirayima á: «Mii kìni li nde mu taan, cyage k'à mu táan ke, sà ntɛ̀ɛn wani.» ");
INSERT INTO spp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Maa jwo Sara á mú: «Mii sí wyɛ̀rɛfyinŋi darashii kampwoo kan mu yyahafooŋ'á, lire li sí li cyêe na mu zòvyinre wu u ɲyɛ nde kani i, mu shiinbii puni ɲyii na.» ");
INSERT INTO spp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ka Ibirayima si jwó le Abimɛlɛki á, ka Kile si u cùuŋɔ, maa u cwoŋi ná u bilicyeebii puni cùuŋɔ, ka pi i jà a pyìi si sahaŋki, ");
INSERT INTO spp_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ɲaha na yɛ Kafooŋi Kile mpyi a zimbaa yama yaha u pyɛnge shiinbii na, Ibirayima cwoŋi Sara ŋkwɔ̀n ɲjwoŋi kurugo. ");
INSERT INTO spp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ɲyɛ Kafooŋi Kile mpyi a jwumpe mpemu jwo Sara á ke, u funŋɔ mpyi a wwɔ̀ puru na mɛ. Pyàŋi ɲwɔmɛɛni u mpyi a lwɔ́ Sara á ke, u à lire funŋɔ. ");
INSERT INTO spp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tèni kyaa Kile mpyi à jwo *Ibirayima á ke, lir'à nɔ ke, ka Sara si laa lwɔ́ maa pùnambile si Ibirayima niɲjyeŋkwoŋ'á. ");
INSERT INTO spp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ɲyɛ lire pùnambilini Sara à si ke, ka Ibirayima si li mɛge le Ishaka. ");
INSERT INTO spp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ishaka ziŋi canmpyibaataanrewuni na, ka Ibirayima si u *kwɔ̀n, bà Kile mpyi a fyânha a yi jwo u á mɛ. ");
INSERT INTO spp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibirayima na mpyi yyee ŋkuu u jyaŋi Ishaka tèesiini i. ");
INSERT INTO spp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ka Sara si jwo: «Ei! Kile à funntanga ná katanra kyaa pyi mii á nde dɛ! Shin maha shin ká li lógo, urufoo funŋke sí n-táan sèl'e.» ");
INSERT INTO spp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ka Sara si núr'a jwo: «Jofoo u mpyi si ɲɛɛ ɲjwo Ibirayima á na Sara na sí pùnambile si fo si jirini kan u ŋwɔrɔ yɛ? Ŋka kuru canŋke ku ɲyɛ niɲjaa, mii à pùnambile si u niɲjyeŋkwoŋ'á.» ");
INSERT INTO spp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ɲyɛ pyàŋ'à pa lyɛ a nɔ láhama jirimɛ na ke, ka *Ibirayima si ɲjyì niɲyahawa shwɔhɔ maa katáan nimbwoo pyi. ");
INSERT INTO spp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Pùnambilini *Misira shiinbii pworoŋi Agari à si Ibirayima á ke, ka Sara si lire ɲya li i Ishaka fwɔ́hɔre. ");
INSERT INTO spp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Maa jwo Ibirayima á: «Ŋge bilicwoŋi ná u jyaŋi kɔ̀rɔ, ɲaha na yɛ u ná mii jyaŋi Ishaka ɲyɛ a yaa pi wwɔ̀ kɔɔge na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Puru jwump'à waha Ibirayima na sèl'e, ɲaha na yɛ Sumayila mú ɲyɛ u pyàŋi wà. ");
INSERT INTO spp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ŋka Kile à jwo Ibirayima á: «Ma hà mpe jwumpe waha maye na mɛ. Sara ká yaaga maha yaaga cya mu á mà yyaha tíi ná bilicwoŋi ná u jyaŋi i ke, ma a lire pyi u á. Ɲaha na yɛ tùluge ɲwɔmɛɛni mii à lwɔ́ mu á ke, Ishaka e kuru sí n-fworo ");
INSERT INTO spp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ŋka mu bilicwoŋi jyaŋi wi ke, mii sí supyishiŋi wà yige u e mú, ɲaha na yɛ mu jya wi.» ");
INSERT INTO spp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kuru canŋke nùmpanŋa ɲyɛ̀sɔɔge na, Ibirayima à yîri maa yalyîre kan Agari á, maa lwɔhe le bùl'i mà kan u á mú, maa pyàŋi kan u á, maa u kɔ̀rɔ, ka u u ŋkàr'a sà a ɲaare na mâre Bɛrisheba síwage e. ");
INSERT INTO spp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Lwɔh'à kwɔ̀ ke, ka Agari si pyàŋi yaha tahe kà ɲwɔh'i. ");
INSERT INTO spp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Maa ntɛ̀ɛn u yyetiimpe na mà laaga wwû mɛtɛrii lada fiige, ɲaha na yɛ u la mpyi sì u jyaŋi ɲya takwûge e mɛ. U à tɛ̀ɛn wani ke, maa wá na mɛɛ súu fo na ŋkwúuli. ");
INSERT INTO spp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ka Kile sí pyàŋi mɛɛni lógo. Ka Kile Mɛlɛkɛŋi si ntɛ̀ɛn nìɲyiŋi na, maa Agari yyere maa yi jwo u á: «Agari, ɲaha k'à pyi yɛ? Ma hà vyá mɛ, ɲaha na yɛ Kile à pyàŋi mɛɛni lógo mà u yaha tahe ɲwɔh'i. ");
INSERT INTO spp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Yîri, ma a ma jyaŋi lwɔ́, ma a u cû ná cyeyi shuunniŋi i. Mii sí sùpyishi niɲyahawa yige u e.» ");
INSERT INTO spp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ka Kile si Agari ɲyiigii múgo, ka u u lùbiliŋi wà ɲya maa kuru lwɔhe kà kwó a le u bùluŋi i mà pa ŋkan pyàŋ'á, u a bya. ");
INSERT INTO spp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ka Kile si pyàŋi ɲwɔhɔ tò, ka u u mpa lyɛ maa ntɛ̀ɛn Paran síwage e, maa mpa mpyi lùuzu niɲcɛnŋɛ ná sintaage e. Ka u nuŋi si u pyi u à Misira kìni shiinbii pworoŋi wà lèŋɛ. ");
INSERT INTO spp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Canŋka, Abimɛlɛki à pa ná u kàshikwɔɔnbii ɲùŋufooŋi Pikɔli i, si jwo ná *Ibirayima i. Maa jwo u á: «Mii à li ɲya na Kile ɲyɛ ná mu i ma karigii puni i. ");
INSERT INTO spp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ɲyɛ numɛ, mii la ɲyɛ ma a ŋkâa Kile na mii á na mu sì ɲɛɛ mii Abimɛlɛki, lire ɲyɛ mɛ mii tùluge ɲwɔhɔ yaha, si kapii pyi wuu wà na mɛ, na mu sí raa kacɛnŋkii kanni pyi mii na, s'a cyi pyi kìni i mu ɲyɛ nàmpantɛɛnre e ke, bà mii à fyânha a cyi pyi mu á mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ka Ibirayima si jwo: «Mii sí n-kâa lire na.» ");
INSERT INTO spp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ŋka bɛ̀ɛnŋke Abimɛlɛki báarapyiibil'à shwɔ Ibirayima na ke, u à Abimɛlɛki cɛ̂ɛge lire na. ");
INSERT INTO spp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ka Abimɛlɛki si Ibirayima pyi: «Mii báarapyiŋi u à lire pyi ke, mii ɲyɛ a u cè mɛ, mu sí ɲyɛ a yi jwo mii á mɛ. Niɲjaa mii à yi lógo. ");
INSERT INTO spp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ka Ibirayima si mpàa ná sikyaa ná nìiyi kan Abimɛlɛki á, ka pi i wwoɲɛɛge le piye shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Lire ɲwɔhɔ na, ka Ibirayima si mpàayaali baashuunni wwû u mpàabil'e mà yaha piyɛ. ");
INSERT INTO spp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ka Abimɛlɛki si u yíbe: «Ɲaha na mu à mpii mpàabii baashuunniŋi wwû mà yaha ŋkère na yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ka u u jwo: «Mu aha ɲɛn'a mpii mpàabii shwɔ mii cye e, lire li sí li cyêe na mii u à ŋke bɛ̀ɛnŋke tùgo.» ");
INSERT INTO spp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Lire e, pi à kuru cyage mɛge le Bɛrisheba, ɲaha na yɛ kuru cyage e Ibirayima ná Abimɛlɛki à kâa piy'á. ");
INSERT INTO spp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tèni i pi à kâa piy'á mà kwɔ̀ ke, ka Abimɛlɛki ná u kàshikwɔɔnbii ɲùŋufooŋi Pikɔli si núr'a kàre Filisiti shiinbii kìni i. ");
INSERT INTO spp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ka Ibirayima si támara cige cɛnmɛ Bɛrisheba i, maa Teekwombaa Kafooŋi Kile mɛge pêe. ");
INSERT INTO spp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Lire kàntugo, ka u u ntɛ̀ɛn nàmpantɛɛnre e mà mɔ Filisiti shiinbii kìni i. ");
INSERT INTO spp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ɲyɛ ɲcyii karigii puni kàntugo, Kile à *Ibirayima kàanmucya mà wíi. Pyiŋkanni na u à u kàanmucya ke, lire li nde. Canŋka Kile à u yyere: «Ibirayima!» ka u u jwo: «Yo! Mii u ŋge.» ");
INSERT INTO spp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ka Kile si yi jwo u á: «Mu jyaŋi niŋkinŋi, Ishaka kyaa l'à táan mu á ke, ta sì ná u e Mɔriya kìni i. Mii sí ɲaŋke kà cyêe mu na, mu aha nɔ wani, ma a u pyi sáraga nizógogo kuru cyage e.» ");
INSERT INTO spp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ka Ibirayima si sôl'a yîri, maa u dùfaanŋke kà cû, maa u báarapyiibii pìi shuunni yyere ná u jyaŋi Ishaka. Maa kàɲciiyi yà jya maa yire lwɔ́ na ŋkɛ̀ɛge sárage tawwûge e, cyage kyaa Kile à jwo u á ke. ");
INSERT INTO spp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Canmpyaa taanre ɲara pi à pyi. Canntanrawoge, ka Ibirayima si ɲùŋke dùrug'a wíl'a kuru cyage ɲya tatɔɔnge e. ");
INSERT INTO spp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Maa jwo u báarapyiibil'á: «Yii tɛ̀ɛn naha ná dùfaanŋke e. Mii ná na pyàŋi sí n-kàre ɲaŋke ɲuŋ'i zà Kile pêe. Wuu aha ŋkwɔ̀, wuu si núru n-pa.» ");
INSERT INTO spp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","U à yire jwo ke, maa ntíl'a u jyaŋi tugo sárage súugo súugo kàɲciiyi na, maa na ná ŋwɔɔ lwɔ́, ka pi i wá na ɲaare na ŋkɛ̀ɛge sìɲcyan kuru cyage e. ");
INSERT INTO spp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ka Ishaka si jwo u tuŋ'á: «Baba!» ka Ibirayima si jwo: «Yo, na jya.» Ka Ishaka si jwo: «Nage ɲyɛ wuu á, kàɲciiyi mú ɲyɛ wuu á, ŋka mpàbilini li sí n-pyi sárage ke, taa lire si ɲyɛ ke?» ");
INSERT INTO spp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ka Ibirayima si jwo: «Mpàbilini li sí n-pyi sárage ke, Kile yabiliŋi u sí yire cwɔɔnrɔ.» Ka pi mú shuunni si wá na ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Cyage Kile mpyi a cyêe pi na ke, pi à nɔ wani ke, ka Ibirayima si sárage tawwûge yaa, maa kàɲciiyi dùrugo ku ɲuŋ'i. U à kwɔ̀ ke, maa u jyaŋi Ishaka cû a pwɔ, mà dùrugo ku ɲuŋ'i kàɲciiyi na. ");
INSERT INTO spp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Maa ŋwɔɔni wwû si ntɛ̀gɛ raa u jyaŋi kɔnre. Tèni i u à jwo u sí li taha jyafooŋi yacige e ke, ");
INSERT INTO spp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","lire tèenuuni i, ka Kafooŋi Kile Mɛlɛkɛŋi si ntɛ̀ɛn nìɲyiŋi na maa sêe: «Ibirayima! Ibirayima!» Ka u u jwo: «Yo!» ");
INSERT INTO spp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ka Kafooŋi Mɛlɛkɛŋi si jwo: «Ma hà ma cyɛge yaha ku nɔ pyàŋi na mɛ! Ma hà yaaga pyi u na mɛ! Numɛ, mii à li cè, sèeŋi na, mu na Kile pêre, ɲaha na yɛ mu ɲyɛ a cyé mà ma jyaŋi tàange wuŋi pyi sáraga mà kan mii á mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ka Ibirayima si yyahe kɛ̂ɛnŋ'a wíi wíi, maa mpâl'a mpàpoo ɲya, u ɲɛŋkil'à sùr'a yyére tahe k'e. Ka u u sà uru mpàpooŋi cû a pyi sáraga nizógogo u jyaŋi cyaga. ");
INSERT INTO spp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Maa kuru cyage mɛge le Yawe-Jire. (Yawe-Jire mɛge ɲwɔhɔ ku ɲyɛ: «Kafooŋi Kile sí yi yyaha cwɔɔnrɔ.») Lire kurugo, sùpyire puni maha ŋko niɲjaa: «Wuu aha nɔ Kafooŋi Kile ɲaŋke ɲuŋ'i, Kafooŋi Kile yabiliŋi sí yi yyahe cwɔɔnre.» ");
INSERT INTO spp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ɲyɛ ka Kafooŋi Kile Mɛlɛkɛŋi si ntɛ̀ɛn nìɲyiŋi na, maa Ibirayima yyére tozhɔnwogo, ");
INSERT INTO spp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","maa yi jwo u á: «Kafooŋi Kile jwumpe pu ɲyɛ mpe: «Mii sí n-kâa naye mɛge na, nde mu à pyi amɛ ke, mu ɲyɛ a cyé mà ma jyaŋi tàange wuŋi kan sáraga mii á mɛ, ");
INSERT INTO spp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","lire kurugo, mii sí jwó le mu á, si mu tùluge ɲyaha wɔrigii fiige, ná suumpe lwɔhe nticɛnŋi fiige mú. Mu tùluge sí raa jìni ku zàmpɛɛnbii na. ");
INSERT INTO spp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Diɲyɛŋi sùpyishiŋi puni sí raa jwóŋi taa mu tùluge cye kurugo, ɲaha na yɛ mu à ɲɛn'a mii ɲwɔmɛɛni cû.» ");
INSERT INTO spp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Puru ɲwɔhɔ na, ka Ibirayima ná u jyaŋi si núr'a kàre báarapyiibii taan. Ka pi i kuni lwɔ́ a núru na ŋkɛ̀ɛge Bɛrisheba e, Ibirayima tatɛ̀ɛnge e. ");
INSERT INTO spp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ɲyɛ cyire karigii puni kàntugo, y'à pa jwo *Ibirayima á. na u yyahafooŋi Nakwɔri cwòŋi Milika mú à pùnampyire ta. ");
INSERT INTO spp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Jyafooŋi niɲcyiiŋi mɛge ɲyɛ Uzi, shɔnwuŋi mɛge sí ɲyɛ Buzi, tanrawuŋi mɛge ɲyɛ Kemuyɛli. Kemuyɛli u à Aramu si. ");
INSERT INTO spp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Milika jyaŋi sicyɛrewuŋ'à pyi Kesɛdi, maa Kyazo taha uru na, maa Pidilashi taha uru na, maa Yidilafi taha uru na, maa nta a Betuyɛli taha uru na. ");
INSERT INTO spp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ka Betuyɛli si mpa Erebeka si. Ɲyɛ tire pùnampyire baataanreŋi Milika à si Ibirayima yyahafooŋi Nakwɔri á. ");
INSERT INTO spp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nakwɔri cwoŋi shɔnwuŋi mɛge na mpyi Ereyuma, uru mú à pùnampyire si. Tire pùnampyire ti ɲyɛ nte: Tebaki ná Gakyamu ná Takyashi ná Maaka. ");
INSERT INTO spp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara à yyee ŋkuu ná beɲjaaga ná baashuunni pyi ke, ");
INSERT INTO spp_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","maa ŋkwû Kiriyati Ariba kànhe e *Kana kìni i. Kuru kànhe mɛge mú ku ɲyɛ Eburɔn. Ka *Ibirayima si mpa ntɛ̀ɛn u cwoŋi buwuŋi taan marii yamɛɛni súu. ");
INSERT INTO spp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Maa ŋkwɔ̀ a pa yîri u taan, mà sà jwo ná Kyiti tùluge shiinbil'e. ");
INSERT INTO spp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Maa jwo pi á: «Mii na ɲyɛ nàmpɔnŋɔ naha yii yyére. Yii taare cyage kà pɛ́rɛ na á, si na cwoŋi buwuŋi lwɔ́ naye yyaha taan zà ntò.» ");
INSERT INTO spp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ka Kyiti shiinbii si Ibirayima pyi: ");
INSERT INTO spp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Wuu ɲùŋufooŋi, mu ɲyɛ shinbwo wuu shwɔhɔl'e. Wuu fanɲyi cyaga maha cyaga k'à mu táan ke, sà ma cwoŋi tò wani. Wuu wà sì ɲcyé si u kwùubii tatoŋke yaha mu á, mu u ma cwoŋi tò mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ka Ibirayima si lyêele, maa Kyiti shiinbii shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Maa yi jwo pi á: «Ɲyɛ yii aha mpyi a ɲɛɛ mii u na cwoŋi tò, lire e mii à yii ɲáare yii Zokyari jyaŋi Efurɔn ɲáare na á. ");
INSERT INTO spp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ɲàŋgyige ku ɲyɛ u á Makipela e, u kɛrɛge tɛgɛni na ke, na u kuru kan na á. Mii sí ku wyɛ́rɛŋi puni kan u á mà tàanna ná ku lwɔɔre e, bà kuru cyage si mpyi mii u kwùubii tatoŋke naha yii shwɔhɔl'e mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ɲyɛ mà pi yaha puru jwumpe na kànhe shiinbii piyetabeŋke e, Efurɔn yabiliŋi na mpyi wani ná Kyiti shiinbii sanmpil'e. Ka u u Ibirayima pyi pi puni ɲyii na: ");
INSERT INTO spp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Ɔɔn, mii ɲùŋufooŋi, wíi, mii sí ɲaŋgyige kan mu á, si kɛrɛge kan mu á si ntaha. Mii sí yire puni kan mu á na kànhe shiinbii puni ɲyii na. Sà ma buŋi tò.» ");
INSERT INTO spp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ka Ibirayima si lyêele kànhe shiinbii ɲyii na, maa u shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Maa jwo Efurɔn á pi puni ɲyii na: «Mii á mu ɲáare, maa kɛrɛge lwɔɔre shwɔ si nta zà na cwoŋi tò wani.» ");
INSERT INTO spp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ka Efurɔn si jwo Ibirayima á: ");
INSERT INTO spp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Mii ɲùŋufooŋi, ŋke kɛrɛge lwɔɔre sì n-tòro wyɛ́rɛfyinŋi darashii ŋkwuu sicyɛɛre (400) na mɛ. Ɲaha shi lire sí n-jà n-kɛ̀ɛge mii ná mu shwɔhɔl'e yɛ? Sà mà cwoŋi tò.» ");
INSERT INTO spp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Efurɔn à wyɛ́rɛŋi ɲwɔge ŋkemu jwo ke, kur'à bɛ̂ Ibirayima á, ka u u uru wyɛ́rɛŋi tɔ̀rɔ Kyiti shiinbii ɲyii na mà kan Efurɔn á wyɛ́rɛfyinŋi darashii ŋkwuu sicyɛɛre mà tàanna ná cwɔ̀hɔmpii tɔrɔmpe e. ");
INSERT INTO spp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","K'à ta amuni ke, Efurɔn kɛrɛge ku mpyi Makipela e, Mamire cyage canŋa fworompe e ke, kɛrɛge ná ɲaŋgyige ku mpyi kuru cyage e ke, ná cige maha cige ku ɲyɛ kɛrɛge e ke, ");
INSERT INTO spp_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","yire pun'à pyi Ibirayima wuyo. Kyiti shiinbii puni, pi mpyi kànhe shiin piye tabeŋke e ke, l'à pyi pire puni ɲyii na. ");
INSERT INTO spp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Lire kàntugo, ka Ibirayima si u cwoŋi Sara tò Makipela kɛrɛge ɲaŋgyige e, kuru cyage ɲyɛ Mamire cyage canŋa fworompe e. Kuru cyage mɛge mú ku ɲyɛ Eburɔn, maa mpyi Kana kìni i. ");
INSERT INTO spp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Lire pyiŋkanni na, kɛrɛge ná ɲaŋgyige ku mpyi wani ke, yire pun'à pyi Ibirayima wuyo, k'à pyi u kwùubii tatoŋke. Kyiti shiinbil'á u à ku shwɔ. ");
INSERT INTO spp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ɲyɛ Kafooŋi Kile mpyi a jwó le *Ibirayima á u karigii puni i fo u à pa lyɛ sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ɲyɛ canŋka, Ibirayima á jwo u báarapyiibii puni niɲjyeŋ'á, ŋge u mpyi na u karigii puni cwɔɔnre ke: «Mii à mu ɲáare, ma cyɛge le na cyiini ɲwɔh'i, ");
INSERT INTO spp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","maa ŋkâa Kafooŋi Kile na, nìɲyiŋi ná ɲìŋke foo, na *Kana kìni i mii à tɛ̀ɛn ke, na mu sì ɲɛɛ lire kìni pùceebilini là lwɔ́ ŋkan mii jyaŋi Ishaka á u cwo mɛ, ");
INSERT INTO spp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ŋka mu sí n-kàre mii kìni i, mii cìnmpyiibii yyére zà ceewe cya u á.» ");
INSERT INTO spp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ka báarapyiŋi si u ɲwɔ shwɔ: «Ceeŋi ká mpyi u ɲyɛ a ɲɛn'a taha mii fye e lire kìni i mɛ, lire sanni i ke, tá mii à yaa mii u kàre ná mu jyaŋi i mu cìnmpyiibii yyére u sà ntɛ̀ɛn wani ná ceeŋi i la? ");
INSERT INTO spp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ka Ibirayima si jwo: «Ɔnhɔ dɛ! ma hà zìi ŋkàre ná na jyaŋi i wani mɛ. ");
INSERT INTO spp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Kafooŋi Kile, nìɲyiŋi foo, u à mii yige na tupyɛnge e ná mii kìni i bà mii si mpyi si mpa naha nde kìni i mɛ, uru u à jwo ná mii i, maa ŋkâa na uru sí nde kìni kan mii tùlug'á. Uru yabiliŋi Kile, u sí u mɛlɛkɛŋi yaha mu yyaha na bà mu si mpyi si sà ceewe lwɔ́ na tupyɛnge e mii jyaŋi mɛɛ na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ceeŋi ká ɲcyé paŋa ná mu i, mii kàage tugure sí n-láha mu na, ŋka mii na li caa mu á, ma hà ŋkàre ná na jyaŋi i wani mɛ!» ");
INSERT INTO spp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ka báarapyiŋi si cyɛge le u ɲùŋufooŋi Ibirayima cyiini ɲwɔh'i, maa ŋkâa, na nde u à jwo ke, na lire uru sí n-pyi. ");
INSERT INTO spp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","U à yire jwo ke, maa ɲwɔhɔɲyɔ kɛ cû u ɲùŋufooŋi, Ibirayima ɲwɔhɔɲyi i, maa u ɲùŋufooŋi yacɛnɲyi shiŋi puni yà lwɔ́ a kàre, Mɛsopotami kìni i, Nakwɔri kànhe na. ");
INSERT INTO spp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","U à nɔ wani ke, ka u u ɲwɔhɔɲyi pyi y'á sínni kànhe kàntugo ɲcwòoni là ɲwɔ na. Lir'á bɛ̂ ná cyeebii yàkoŋɔ ɲwɔ lùkwuuni i. ");
INSERT INTO spp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Maa jwo: «Kafooŋi Kile, mu u ɲyɛ mii ɲùŋufooŋi, Ibirayima u Kileŋi ke, mii na mu ɲáare, maa na niɲjaa karigii cwɔɔnrɔ na á, maa ɲwɔ na ɲùŋufooŋi na. ");
INSERT INTO spp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ɲyɛ mii niɲjyéreŋi u ŋge, nde ɲcwòoni taan. Kànhe shiinbii pùcyaabii sí n-pa a lwɔhe kwóre. ");
INSERT INTO spp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mii aha bú pùcwoŋi ŋgemu pyi: «Mii à mu ɲáare ma lùkwoyaage fɛ̂ɛn, si bya» ka u u ɲɛn'a mii ɲwɔ shwɔ: «Bya, si ma ɲwɔhɔɲyi kan yi bya mú» ke, uru u pyi mu bilinaŋi Ishaka cwoŋi, ŋgemu mu yabiliŋ'à cyêe mii na ke. Lire e, mii sí n-cè na mu à ɲwɔ mii ɲùŋufooŋi, Ibirayima na.» ");
INSERT INTO spp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mà u yaha puru jwumpe na, ka Betuyɛli pworoŋi Erebeka si mpa ná u lùkwoyaage e fukange na, lwɔhe takwóge e. Betuyɛli tuŋi sí mpyi Ibirayima cɔɔnŋi Nakwɔri, u nuŋi sí mpyi Milika. ");
INSERT INTO spp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Pùceebile nisìnana li mpyi lili. Li mpyi a nɔ̀ shi cè mɛ. Ka u u ntîge ɲcwòoni i maa u lùkwoyaage ɲî a fworo. ");
INSERT INTO spp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ka Ibirayima báarapyiŋi si fyâl'a file u na, maa u pyi: «Mii à mu ɲáare, ma lùkwoyaage tîrige, si bya.» ");
INSERT INTO spp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ka pùcwoŋi si jwo: «Pa bya, Baba!» maa fyâl'a lwɔhe tîrige, maa u kan u a bya. ");
INSERT INTO spp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","U à bya a kwɔ̀ ke, ka pùcwoŋi si jwo: «Mii sí mu ɲwɔhɔɲyi kan yi bya mú.» ");
INSERT INTO spp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Maa fyâl'a lwɔhe kɛ̂ɛnŋɛ yatɔɔre yabyage e, maa núr'a kàre fwɔfwɔ mà sà kabɛrɛ kwó. Amuni u à lwɔhɔ niɲyahaga kwó a kan ɲwɔhɔɲy'á y'à bya. ");
INSERT INTO spp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ka nàŋi si yyére na wíi jwumɔbaa, si ɲcè kampyi Kafooŋi sí n-sìi ɲɛɛ uru kùsheeni táan uru na. ");
INSERT INTO spp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ɲwɔhɔɲy'à bya a kwɔ̀ ke, ka nàŋi si múnafegewe sɛɛnwu wwû uye ɲuŋ'i, u mpyi a garamu baani kwɔ̀, ná sɛɛn kanɲcyinŋii shuunni, cyire niŋkin niŋkinŋi mpyi a ɲyaha garamu ŋkuu na. Maa yire kan Erebeka á. ");
INSERT INTO spp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Maa u yíbe: «Jofoo pworo u ɲyɛ mu yɛ? Na pwɔhɔ, tá wuu sí tashwɔngɔ ta mu tuŋi pyɛnge e bɛ?» ");
INSERT INTO spp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ka Erebeka si jwo: «Nakwɔri ná Milika jyaŋi Betuyɛli pworo u ɲyɛ mii.» ");
INSERT INTO spp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Maa núr'a jwo: «Yatɔɔrɔ yalyîre niɲyahara sí n-ta wani, yii tashwɔngɔ mú sí n-ta wuu yyére.» ");
INSERT INTO spp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nàŋ'à yire lógo ke, ka u u niŋkure sín, maa Kafooŋi shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Maa jwo: «Mii à Kafooŋi Kile kêe, mii ɲùŋufooŋi, Ibirayima u Kileŋi, ɲaha na yɛ u à kacɛnɛ pyi u na ma u ɲwɔmɛɛfente cyêe mii ɲùŋufooŋi na sèl'e. Kafooŋi yabiliŋi u à kàre ná mii i, mii ɲùŋufooŋi cìnmpyiibii yyére.» ");
INSERT INTO spp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ka pùcwoŋi si fê a kàr'a sà yire yyahe jwo u nuŋ'á. ");
INSERT INTO spp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","U yyahafooŋi wà mɛgɛ na mpyi Laban. Tèni i ur'à múnafegeŋi ná kaɲciinŋkii ɲya u cɔɔnŋi cyɛge na, maa u jwumpe lógo nàŋi kànmpanŋke na ke, ka u u yîr'a fê a kàre ɲcwòoni na, nàŋi fye e mà sà u niɲjyéreŋi ta ɲwɔhɔɲyi taan. ");
INSERT INTO spp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","U à nɔ u na ke, maa jwo: «Yîr'a jyè pyɛnge e. Kafooŋi Kile à jwó le mu á. Ɲaha na mu à tɛ̀ɛn ntàani na yɛ? Mii à cyage kà bégele mu ná ma yatɔɔre mɛɛ na.» ");
INSERT INTO spp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ka pi i yîr'a kàre siɲcyan Laban pyɛnge e. Pi à nɔ ke, ka pi i ɲwɔhɔɲyi tugure tîrige, maa yatɔɔrɔ ɲjyì kan y'á, wyɛrɛ ná ɲyɛ, maa lwɔhe kan nàŋi ná u fyèɲwɔhɔshiinbil'á pi à pi tooyi jyé. ");
INSERT INTO spp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Puru ɲwɔhɔ na, pi à pa ná ɲjyì i pi á, ka nàŋi si jwo: «Ná mii ɲyɛ a na kapani jwo mɛ, mii sì n-lyî mɛ. Ka Laban si jwo: «Mpe pu ɲyɛ mu á ke, pu jwo sá.» ");
INSERT INTO spp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ka nàŋi si jwo: «Mii na ɲyɛ Ibirayima báarapyi. ");
INSERT INTO spp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Kafooŋi Kile à jwó le mii ɲùŋufooŋ'á sèl'e, maa u pyi yaarafoo, u à mpàa ná sikyaa ná nìiye kan u á, ná wyɛ́rɛfyin ná sɛɛn, ná báarapyii, nàmbaa bâra cyee na, ná ɲwɔhɔɲyɔ ná dùfaanya. ");
INSERT INTO spp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Mii ɲùŋufooŋi cwoŋi Sara niɲjyeŋkwoŋ'à pùnambile si u á. Lire pùnambilin'á, u à u cyeyaayi puni kan. ");
INSERT INTO spp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Canŋka, u à jwo mii á na mii u kâa uru ɲyii na, na Kana kìni i ur'à tɛ̀ɛn ke, na mii sì ceewe lwɔ́ uru jyaŋ'á lire kìni i mɛ, ");
INSERT INTO spp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","na mii u kàre uru tukanhe na, uru shiinbii yyére, si ceewe cya wani uru jyaŋ'á. ");
INSERT INTO spp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ka mii i u pyi: «Ceeŋi ká mpyi u ɲyɛ a ɲɛn'a pa ná mii i mà dɛ?» ");
INSERT INTO spp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ka u u jwo: «Kafooŋi Kile ɲwɔmɛɛni mii à cû tèrigii puni i ke, uru yabiliŋi u sí u mɛlɛkɛŋi wà le ná mu i, bà mu kuni si mpyi si ntáan, maa ceewe lwɔ́ mii tukanhe na ma kan na jyaŋ'á mɛ. ");
INSERT INTO spp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mu aha shà ceeŋi ɲáare mii pyɛngɛ shiinbil'á, pi mɛ́ɛ ká ɲcyé si u kan mu á, lire tèni i mu kàage tugure sí n-láha mu na.» ");
INSERT INTO spp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ɲyɛ lire e mii à pa yyére nde ɲcwòoni ɲwɔge na, maa jwo: «Kafooŋi Kile, mii ɲùŋufooŋi Ibirayima u Kileŋi, kampyi mu la ɲyɛ mii kùsheeni si ntáan, ");
INSERT INTO spp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","lire tèni i ke, mii sí n-yyére naha nde ɲcwòoni ɲwɔge na, pùcwoŋi u sí n-pa lwɔhe kwó ke, mii aha bú jwo u á: «Na pwɔhɔ, si bya ma lwɔhe e.» ");
INSERT INTO spp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ka u u mii ɲwɔ shwɔ: «Bya, mii sí n-kwɔ̀ kà kan mu ɲwɔhɔɲy'á mú» ke, uru u sí n-pyi mii ɲùŋufooŋi jyaŋi cwoŋi, Kafooŋi Kile yabiliŋ'à ŋgemu cyêe ke.» ");
INSERT INTO spp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ɲyɛ mà mii yaha puru jwumpe na, ka Erebeka si nɔ ná u lùkwoyaage e, fukange na, maa ntîg'a lwɔhe kà kwó ɲcwòoni i. Ka mii u u pyi: «Na pwɔhɔ, si bya.» ");
INSERT INTO spp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ka u u ntíl'a lwɔhe tîrige na mii u bya, maa jwo na uru sí kà yige ŋkan ɲwɔhɔɲy'á. Ɲyɛ ka mii i bya. Puru ɲwɔhɔ na, ka u u kà kwó a kan mii ɲwɔhɔɲy'á y'a bya. ");
INSERT INTO spp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ka mii i u yíbe: «Jofoo pworo u ɲyɛ mu yɛ?» Ka u u jwo: «Nakwɔri ná Milika jyaŋi Betuyɛli pworo u ɲyɛ mii.» Ka mii i fègewe le u múnaani na, maa kaɲcinŋii le u cyeyi na. ");
INSERT INTO spp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Lire kàntugo, ka mii i niŋkure sín Kafooŋi Kile yyahe taan mii ɲùŋufooŋi Ibirayima u Kileŋi, maa u shɛ́ɛre, ɲaha na yɛ uru u à kuni niɲcɛnni le mii taan, maa mii pyi mii à ceewe ta na ɲùŋufooŋi jyaŋi mɛɛ na, u cìnmpyiibii shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kampyi yii la ɲyɛ si kacɛnnɛ pyi mii ɲùŋufooŋ'á si li cyêe na yii na ɲyɛ u cìnmpyii, lire tèni i, yii lire jwo na á, yii aha nta yii mú sì n-jà lire pyi mɛ, yii yire jwo mú, bà mii si mpyi si na takàrege cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ɲyɛ ka Laban ná Betuyɛli si Ibirayima báarapyiŋi ɲwɔ shwɔ: «Nde kan'à fworo Kafooŋi e. Wuu sì n-jà n-cyé mɛ. ");
INSERT INTO spp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Erebeka u ŋge, u lwɔ́ ma a sì, u u sà mpyi mu ɲùŋufooŋi jyaŋi cwoŋi, bà Kafooŋi à li yaa mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ibirayima báarapyiŋ'à yire lógo ke, ka u u niŋkure sín maa yyahe cyígile, maa Kafooŋi pêe. ");
INSERT INTO spp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Maa pùcyaga yaaya wwû uye ɲuŋ'i mà kan Erebeka á, wyɛ́rɛfyinwuyo, ná sɛɛnwuyo ná vàanɲya, maa yacɛnɲyɛ mú kan pùcwoŋi yyahawuŋi ná u nuŋ'á. ");
INSERT INTO spp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Puru ɲwɔhɔ na, ka u ná u fyèɲwɔhɔshiinbii si lyî maa bya, maa sínni. Ɲyɛ̀g'à múgo ke, ka Ibirayima báarapyiŋi si jwo Erebeka yyahawuŋi ná u nuŋ'á: «Yii kuni yaha, mii sí núru na ɲùŋufooŋi yyére.» ");
INSERT INTO spp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ka pi i jwo: «Pùcwoŋi yaha u tère nimbilere pyi ná wuu e, canmpyaa kɛ fiige. Cyire ká ntòro, yii raa sì ná u e.» ");
INSERT INTO spp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ka nàŋi si jwo: «Kafooŋi à mii kuni táan mà kwɔ̀, yii àha núru na cû n-yaha mɛ. Yii na yaha s'a ŋkɛ̀ɛge na ɲùŋufooŋi yyére.» ");
INSERT INTO spp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ka Erebeka shiinbii si jwo: «Ɲyɛ wuu pùcwoŋi yyere, wuu u u yíbe.» ");
INSERT INTO spp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ka pi i u yyer'a yíbe: «Mu la ɲyɛ si ŋkàre ná ŋge nàŋi i numɛ la?» Ka u u jwo: «Mii kɛ̀ɛge.» ");
INSERT INTO spp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Lire pyiŋkanni na, pi à pi cìnmpworocwoŋi Erebeka yaha a kàre ná Ibirayima báarapyiŋi ná u fyèɲwɔhɔshiinbil'e. Báarapyicwoŋi u mpyi a Erebeka byé ke, uru mú a kàre ná pi e. ");
INSERT INTO spp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Mà jwo pi kuni lwɔ́ ke, pi à jwó le Erebeka á maa jwo «Wuu cìnmpworocwoŋi, Kile u pyìi niɲyahaɲyahamii kan ma á, Kile u pi yaha pi jà pi zàmpɛɛnbii na.» ");
INSERT INTO spp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ka Erebeka ná u báarapyicyeebii si yîr'a kàr'a sà dùgo ɲwɔhɔɲyi ɲuŋ'i, maa ntaha nàŋi fye e. amuni pi à kàre ná Erebeka e. ");
INSERT INTO spp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Lir'á ta Ishaka á yîri Lakyayi Ɔrɔyi lùbiliŋi cyage e maa mpa ntɛ̀ɛn Nɛgɛvi síwage kànmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Canŋka yàkoŋɔ, Ishaka à fwor'a kàr'a sà a uye ɲaare sige e, marii funŋke caa. U à ta u ɲùŋke yîrige si wíi ke, ka u u ɲwɔhɔɲyi ɲya yi i ma. ");
INSERT INTO spp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tèni i Erebeka nimpaŋ'à ɲùŋke yîrig'a Ishaka ɲya ke, ka u u ntîge ɲwɔhɔŋke ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Maa jwo Ibirayima báarapyiŋ'á: «Nàŋi ŋgire u na wuu bêni amɛ sige e yɛ?» Ka u u jwo: «Mii ɲùŋufooŋi Ishaka wi.» Erebeka á yire lógo ke, ka u u u vàanŋke kà tɛ̀g'a yyahe tò. ");
INSERT INTO spp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ɲyɛ ka nàŋi si karigii toroŋkanni yyaha jwo Ishaka á. ");
INSERT INTO spp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ɲyɛ ka Ishaka si ŋkàr'a sà Erebeka yaha u nuŋi Sara bage e, maa u pyi u cwo, maa u kyaa táan uy'á. Ka lire si Ishaka funŋke ɲíŋɛ u nuŋi kwùŋi woge na. ");
INSERT INTO spp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ɲyɛ ɲcyii karigii puni kàntugo, ka *Ibirayima si ceeŋi wabɛrɛ lèŋɛ, uru mɛge na mpyi Ketura. ");
INSERT INTO spp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Pùnampyire u à si Ibirayima á ke, tire mɛyi yi ɲyɛ ɲje: Zimiran, ná Yokishan, ná Mɛdan, ná Madiyan ná Yishibaki, ná Shukya. ");
INSERT INTO spp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokishan mú à pùnampyire shuunni si: Sheba ná Dedan. Uru u tùluyi yi ɲyɛ Ashuri shiinbii ná Letushi shiinbii ná Lemi shiinbii. ");
INSERT INTO spp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiyan u pùnampyire ti mpyi Efa, ná Efɛri, ná Kyanɔki, ná Abida, ná Elida. Ɲyɛ pire pun'á pyi Ketura pyìibii ná u ɲampyire. ");
INSERT INTO spp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ɲyɛ Ibirayima á u kɔɔge puni kan Ishaka á ");
INSERT INTO spp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ŋka mà jwo u kwû ke, u à bùɲyɛ pyi cyeebii sanmpii pyìibil'á maa pi tùugo canŋa fworompe kìrigil'e mà laage tɔɔn u jyaŋi Ishaka na. ");
INSERT INTO spp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ɲyɛ Ibirayima shìŋi canmpyaagil'à pyi yyee ŋkuu ná beetaanre ná kɛ ná kaŋkuro. ");
INSERT INTO spp_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","U à lyɛ fo mà lyɛge la kwɔ̀. Puru ɲwɔhɔ na, u à kwû maa sà bâra u tulyeyi na. ");
INSERT INTO spp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Ka u jyaabii mú shuunni, Ishaka ná Sumayila, si u buwuŋi tò Makipela ɲaŋgyige e. Kuru ɲaŋgyige na mpyi Kyiti shiinbii kɛrɛge k'e Mamire canŋa fworompe e. Kuru cyage Ibirayima mpyi a shwɔ Kyiti shinŋi Zokyari jyaŋi Efurɔn á. Ɲyɛ wani Ibirayima ná u cwoŋi Sara à tò. ");
INSERT INTO spp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibirayima kwùŋi kàntugo, Kile à jwó le u jyaŋi Ishaka á sèl'e. Ishaka mpyi a tɛ̀ɛn Lakyayi Ɔrɔyi lùbiliŋi cyage e. ");
INSERT INTO spp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","*Ibirayima jyaŋi Sumayila u tùluge ku ɲyɛ ŋke: *Misira shiinbii pworoŋi Agari, Sara bilicwoŋ'à ŋgemu si Ibirayima á ke, ");
INSERT INTO spp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","u pùnampyire mɛyi yi ɲyɛ ɲje mà tàanna ná pi tèesiini i: pùnambilini niɲcyiini mɛge ku ɲyɛ Nɛbayɔti, uru kàntugo Kedari ná Adibɛli ná Mibisamu ");
INSERT INTO spp_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ná Mishima ná Duma ná Masa ");
INSERT INTO spp_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ná Kyadadi ná Tema ná Yeturi ná Nafishi ná Kedima á si. ");
INSERT INTO spp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Sumayila pùnampyire ti ɲyɛ tire. Pi mɛyi yi ɲyɛ ɲje mà tàanna ná pi kànyi i. Pi à pyi ɲùŋufee kɛ ná shuunni mà tàanna ná pi tatɛ̀ɛnɲyi i. ");
INSERT INTO spp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Yyee ŋkuu ná beɲjaaga ná kɛ ná baashuunni Sumayila à pyi maa ŋkwû maa sà bâra u tulyeyi na. ");
INSERT INTO spp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","U pyìibii mpyi a tɛ̀ɛn mà lwɔ́ Kyavila kànhe na, mà kàre fo Shuri woge na, kuru cyage ɲyɛ *Misira kìni ŋkère na, mà kàre Asiri kìni kànmpanŋke na; pi à tɛ̀ɛn wani pi cìnmpyiibii puni ŋkère na. ");
INSERT INTO spp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","*Ibirayima jyaŋi Ishaka taɲjaaŋi u ɲyɛ ŋge. Ɲyɛ Ibirayima jya u mpyi Ishaka. ");
INSERT INTO spp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Mà Ishaka shìŋi yaha yyee beeshuunni na, u à Betuyɛli pworoŋi Erebeka lèŋɛ mà pyi u cwo. Erebeka na mpyi Laban cɔɔn. Aramu tùluge shiin pi mpyi pi pi, Mɛsopotami kìni i. ");
INSERT INTO spp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ishaka cwoŋi Erebeka na mpyi cijiriŋɛ, ka u u Kafooŋi Kile ɲáare u na, ka Kile si u ɲaarage shwɔ, ka u u yyere ŋamii laa na. ");
INSERT INTO spp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Yacen'à pa lyɛ ke, ka pyìibii si wá na piye fuuli nufooŋi funŋke e, ka u u jwo: «Kampyi amɛ li ɲyɛ, tá ɲùŋɔ saha na ɲyɛ mii u kwôro shì na bɛ?» Maa ŋkàr'a sà Kafooŋi Kile yíbe. ");
INSERT INTO spp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ka Kafooŋi Kile si jwo: «Sùpyishi shuunni u ɲyɛ mu funŋke e, mu aha pi si, pi sì n-bɛ̂ niŋkin na mɛ, pi sí n-láhala. Pi mú shuunni i, wà fànha sí ɲyaha wà wogo na. Yyahawuŋi sí n-pyi cɔɔnfooŋi biliwe.» ");
INSERT INTO spp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ɲyɛ Erebeka canzeg'à nɔ, ka u u si ŋamii. ");
INSERT INTO spp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ka pyàŋi niɲcyiiŋi si si maa mpyi bòmbeewe, maa mpyi ná shire e, mu à jwo shire yaaga. Ka pi i u mɛge le Ezawu. ");
INSERT INTO spp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Lire kàntugo, ka cɔɔnfooŋi si si, uru nimpaŋ'à yyahafooŋi nintaani cû, ka pi i uru mɛge le *Yakuba. Pire ŋampil'à si mà Ishaka shìŋi ta yyee beetaanre na. ");
INSERT INTO spp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ɲyɛ pi à pa yyaha cwo, ka Ezawu si wá na lùuzoge pyi fo mà pa mpyi lùuzupege. Ŋka Yakuba sí wi ke, uru ɲùŋke mpyi a ɲíŋɛ, ka uru si ntɛ̀ɛn pyɛnge e. ");
INSERT INTO spp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ezawu kyaa li mpyi a táan Ishaka á, uru cye kurugo u mpyi maha kyaare taa na ŋkyàa. Ŋka Yakuba kyaa li mpyi a táan Erebeka á. ");
INSERT INTO spp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","30","Canŋka, Yakuba mpyi na jàhii sore, cyire yyaha mpyi a ɲáaŋa. Ka Ezawu kategewuŋi si yîri sige e mà pa. Maa Yakuba pyi: «Katege naha na ŋko si mii bò, ma jàhigii niɲyɛgii cyìi kan na á ɲjyî.» Lire kurugo, Ezawu mɛg'a le Edɔmu (kuru mɛge ɲwɔhɔ ku ɲyɛ ku yyah'à ɲáaŋa.) ");
INSERT INTO spp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ka Yakuba si jwo: «Mu aha ɲɛn'a ma lyɛge tɔ̀ɔnŋi fáa mii á jàhigii na fɔlɔ, lire e mii sí cyìi kan mu á.» ");
INSERT INTO spp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ka Ezawu si jwo: «Ei! Katege na ŋko si mii bò, ɲaha lyɛge tɔ̀ɔnŋi sí ɲwɔ mii á yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ka Yakuba si jwo: «Kâa na ɲyii na» ka Ezawu si ŋkâa, maa u lyɛge tɔ̀ɔnŋi fáa Yakuba á jàhigii na. ");
INSERT INTO spp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ka Yakuba si nta a jàhigii cyìi ná bwuuruŋi wà kan u á. Ka u u yire lyî maa bya, maa yîr'a tòro. Lire pyiŋkanni na, Ezawu à u lyɛge ɲjini faha. ");
INSERT INTO spp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ɲyɛ lire kàntugo, ka katege si mpa jyè lire kìni i. Kuru katege ná *Ibirayima tìiŋi woge ɲyɛ a núr'a pyi niŋkin mɛ. Ka Ishaka si yîri mà kàre Filisiti shiinbii saanŋi Abimɛlɛki yyére, Gerari kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ka Kafooŋi Kile si uye cyêe Ishaka na, maa yi jwo u á: «Ma hà ŋkàre *Misira kìni i mà dɛ! Kìni mii sí n-cyêe mu na ke, maa ntɛ̀ɛn wani. ");
INSERT INTO spp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tɛ̀ɛn naha nde kìni i. Mii sí n-pyi ná mu i si jwó le mu á, si nde kìni puni kan mu ná ma tùlug'á. Lire pyiŋkanni na, ɲwɔmɛɛni mii à lwɔ́ mu tuŋi Ibirayima á ke, lire sí n-fûnŋɔ. ");
INSERT INTO spp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mii sí mu tùluge ɲyaha, bà wɔrigil'à á ɲyaha mɛ, si ŋke cyage puni kan k'á. Ɲìŋke sùpyishiŋi puni si jwóŋi ta mu tùluge cye kurugo, ");
INSERT INTO spp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ɲaha na yɛ Ibirayima á mii ɲwɔmɛɛni cû, nde mii à jwo u á ke, lire u à pyi, u à mii tùnnture ná mii *saliyaŋi kurigii ɲaara.» ");
INSERT INTO spp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ɲyɛ ka Ishaka si ŋkwôro Gerari i. ");
INSERT INTO spp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Pi n'a mpyi a Ishaka yíbe u cwoŋi kyaa na, u mpyi maha jwo na uru cɔɔn wi. U mpyi na fyáge na uru ká jwo uru cwoŋi wi, pi sí uru bò, ɲaha na yɛ Erebeka lemɛ mpyi a ɲwɔ sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Pi à pa mɔ Gerari i ke, canŋka Filisiti shiinbii saanŋi Abimɛlɛki à wíi finɛtiriŋi i, mà Ishaka ná u cwoŋi Erebeka ɲya, pi i bâhare siɲcyan mu à jwo wà ná u cwo, ");
INSERT INTO spp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ka u u Ishaka yyere maa yi jwo u á: «Nàkaana baa, mu ná ŋge ceeŋi baharaŋkann'à li cyêe na mu cwoŋi wi, ɲaha na mu à jwo mii á na mu cɔɔn u ɲyɛ wi yɛ?» Ka Ishaka si jwo: «Mii à yi jwo ɲaha na yɛ mii mpyi na fyáge na yii sí mii bò u kurugo.» ");
INSERT INTO spp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ka Abimɛlɛki si jwo: «Ɲaha kafiile mu à pyi amɛ yɛ? L'à kwôro ɲcyɛrɛ, mii shinŋi wà mpyi na sí n-wwɔ̀ ná mu cwoŋi i, mu mpyi na sí wuu pyi wuu lawwuugo ta.» ");
INSERT INTO spp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Maa li jwo a waha u shiinbii pun'á: «Shinŋi ŋgemu ká bwɔ̀n Ishaka na, lire ɲyɛ mɛ u cwoŋi na ke, urufoo sí n-bò.» ");
INSERT INTO spp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ɲyɛ ka Ishaka si ŋkwôro Gerari i na faaŋi pyi. Ka Kile si jwó le u á, ka faaŋi si ntáan u na sèe sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ka u cyeyaayi si wá na ɲyahage, fo u à pa mpyi nàfuufembwɔhɔ. ");
INSERT INTO spp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yatoŋkuruɲwɔ shi niɲyahaya na mpyi u á, ná báarapyii niɲyahamii. Ka u ɲyipɛɛnni si jyè Filisiti shiinbil'e. ");
INSERT INTO spp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Lire e, u tuŋi Ibirayima báarapyiibil'à bɛ̀ɛnŋɛ maha bɛ̀ɛnŋɛ tùgo u tìiŋi i ke, ka pi i yire puni tò. ");
INSERT INTO spp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Puru ɲwɔhɔ na, ka Abimɛlɛki si jwo Ishaka á: «Ta sì, maa yîri wuu taan, ɲaha na yɛ mu à fànha tò wuu na. ");
INSERT INTO spp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ka Ishaka si yîri kuru kànhe e, maa ŋkàre Gerari bafage e. Maa ntɛ̀ɛn kuru cyage e. ");
INSERT INTO spp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ɲyɛ bɛ̀ɛnɲyi Ishaka tuŋi Ibirayima mpyi a tùgo, ka Filisiti shiinbii si yi tò Ibirayima kwùŋkwooni kàntugo ke, ɲyɛ, Ishaka á núr'a yire bɛ̀ɛnɲyi pwoore wwû. Mɛyi Ibirayima mpyi a le yi na ke, maa yire mɛyi ninuyi le yi na sahaŋki. ");
INSERT INTO spp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ɲyɛ canŋka, Ishaka báarapyiibil'à bɛ̀ɛnŋke kà tùgo kuru bafage e mà nɔ lwɔhe na. ");
INSERT INTO spp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerari yatɔɔnahabil'à lire ɲya ke, ka pi i Ishaka wuubii tùn, maa jwo: «Ŋke lwɔhe ɲyɛ wuu wogo.» Ka Ishaka si kuru bɛ̀ɛnŋke mɛge le Yogo. ");
INSERT INTO spp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ka Ishaka báarapyiibii si núr'a bɛ̀ɛnŋke kabɛrɛ tùgo, ka pi i núr'a tùn kuru kurugo. Ka Ishaka si kuru cyage mɛge le Mbembaaŋi. ");
INSERT INTO spp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ka pi i yîri wani, maa sà bɛ̀ɛnŋke kabɛrɛ tùgo. Sùpya ɲyɛ a yogo *kwɔ̀n pi na kuru kurugo mɛ. Ka u u kuru mɛge le Tafabwɔhɔ maa jwo: «Numɛ Kafooŋi Kile à wuu funŋke ɲíŋɛ maa tafabwɔhɔ kan wuu á, wuu sí n-jà ɲyaha numɛ kuru cyage e.» ");
INSERT INTO spp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Puru ɲwɔhɔ na, ka Ishaka si yîri kuru cyage e, maa ŋkàre Bɛrisheba kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","U canŋkarege numpilage e, Kafooŋi Kile à uye cyêe u na, maa u pyi: «Mii u ɲyɛ mu tuŋi Ibirayima u Kileŋi, ma hà raa fyáge mɛ, ɲaha na yɛ mii ɲyɛ ná mu i. Mii sí jwó le mu á, si mu tùluge ɲyaha, mii báarapyiŋi Ibirayima kurugo.» ");
INSERT INTO spp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ka Ishaka si sáraya tawwûgo yaa kuru cyage e, maa Kafooŋi Kile mɛge pêe. Maa u vàanŋke bage kwòro wani, ka u báarapyiibii si bɛ̀ɛnŋke kà wwû. ");
INSERT INTO spp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Canŋka, Abimɛlɛki ná u ceevooŋi Ahusati ná u kàshikwɔɔnbii ɲùŋufooŋi Pikɔli à yîri Gerari i mà kàre Ishaka yyére. ");
INSERT INTO spp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ka Ishaka si pi pyi: «Ɲaha kurugo yii à pa mii yyére sahaŋki mà li ta mii kyal'à pɛn yii á, yii mú s'a mii kɔ̀r'a yîrige yii cyage e yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ka pi i jwo: «Wuu à li ɲya na Kafooŋi Kile ɲyɛ ná mu i, lire kurugo wuu à pa mu yyére, wuu u mpa ŋkâa, wuu u wwoɲɛɛge le wuye shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Mii la ɲyɛ maa ŋkâa, na mu sì kawaa pyi wuu wà na mɛ, mu à jwo bà wuu ɲyɛ wuu ɲyɛ a kapii pyi mu na mɛ, kacɛnŋkii kanni wuu à pyi mu na. Wuu à mu yaha a yîri wuu yyére yyeɲiŋke e. Ɲyɛ numɛ Kafooŋi Kile mú à jwó le mu á.» ");
INSERT INTO spp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ka Ishaka si lyìmbwoo shwɔhɔ pi á, ka pi i lyî maa bya. ");
INSERT INTO spp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kuru canŋke nùmpanŋa ɲyɛsɔɔge na, ka pi i yîri maa wwoɲɛɛge le ná Ishaka e, maa ɲwɔmɛɛ lwɔ́ piye shwɔhɔl'e. Lire ɲwɔhɔ na, ka Ishaka si kuni kan pi á, ka pi i ŋkàre yyeɲiŋke e. ");
INSERT INTO spp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ɲyɛ kuru canŋke yabiliŋi, Ishaka báarapyiibii mpyi na bɛ̀ɛnŋɛ tùru, maa mpa kuru bɛ̀ɛnŋke kyaa jwo Ishaka á na pir'à ku tùg'a nɔ lwɔhe na. ");
INSERT INTO spp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ka Ishaka si kuru bɛ̀ɛnŋke mɛge le Sheba. Lire kurugo, kuru kànhe mɛg'a pa le Bɛrisheba. Kuru mɛge ku na yîri fo niɲjaa. ");
INSERT INTO spp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Mà Ezawu shìŋi yaha yyee beeshuunni na, u à Kyiti tùluge cyeebii pìi shuunni lèŋɛ nàmbaga na, Bɛri pworoŋi Yuditi ná Elɔn pworoŋi Basimati. ");
INSERT INTO spp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Pire cyeebii shuunniŋi kan'à Ishaka ná u cwoŋi Erebeka lùgigii yîrige sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Tèni i lyɛg'à pa nɔ Ishaka na ke, ka u ɲyiɲyaanni si li ɲwɔ cû na ɲcyɛrɛge fo u à pa mpyi u sàha ɲyɛ na ɲaa na ɲcúu mɛ. Canŋka, ka u u u jyaŋi niɲjyeŋi Ezawu yyere, ka u u shwɔ: «Yo!» ");
INSERT INTO spp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ka Ishaka si jwo: «Na jya, ku ke, mii à lyɛ a kwɔ̀, ŋka mii ɲyɛ a naye tèekwûu cè mɛ. ");
INSERT INTO spp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ɲyɛ mii à mu ɲáare, maa ma lùuzoge yaayi lwɔ́, sintaage ná taanpyaagii, maa sà kyara cya maa ma na á. ");
INSERT INTO spp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kyaare shwɔ̀hɔŋkanni l'à táan mii á ke, maa ti shwɔhɔ amuni ma kan na á ŋkyà, bà mii si mpyi si jwó le mu á si yaa ná na tèekwûuni i mɛ. ");
INSERT INTO spp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ɲyɛ puru jwumpe Ishaka á jwo u jyaŋi Ezawu á ke, Erebeka mpyi a puru lógo. Ɲyɛ Ezawu à pa ŋkàre sige e kyaare tacyag'e ke, ");
INSERT INTO spp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ka Erebeka si jwo u jyaŋi *Yakuba á: «Mii à mu tuŋi jwumpe lógo, mpemu u à jwo mu yyahafooŋi Ezawu á ke. ");
INSERT INTO spp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","U à jwo u á: “Sà kyaare cya na á, kyaare shwɔ̀hɔŋkanni l'à táan mii á ke, maa ti shwɔhɔ amuni, ma kan na á, lire ká mpyi, mii sí jwó le mu á Kafooŋi Kile yyahe taan, si nta ŋkwû.”» ");
INSERT INTO spp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ɲyɛ Yakuba, ɲje mii sí n-jwo mu á ke, yire lóg'a tàra, maa li pyi li jwuŋkanni na. ");
INSERT INTO spp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Sà sikyaa niɲcɛnmii shuunni cû maa ma. Kyaare shwɔ̀hɔŋkanni l'à táan mu tuŋ'á ke, mii sí ti shwɔhɔ amuni, ");
INSERT INTO spp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ma sà ŋkan u á u kyà, u u jwó le ma á, mà jwo u kwû ke.» ");
INSERT INTO spp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ka Yakuba si jwo u nuŋ'á: «Nàa, mii tuŋ'à cè na shire na ɲyɛ Ezawu na, shire sí ɲyɛ mii na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mii tuŋi ká bú mpa jwo u sí n-bwɔ̀n mii na, u sí n-cè na Ezawu bà u ɲyɛ mii mɛ, mii sí n-pyi kafiniviniwe. Lire tèni i ke, mà jwo mii u jwó ta ke, laŋaga mii sí n-ta.» ");
INSERT INTO spp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ka nufooŋi si jwo: «Lire ká bú mpyi, na jya, Kile u kuru laŋaŋke yaha ku cwo na na. Ɲje mii à jwo ke, lire pyi kanna, sà sikaabii cû a pa.» ");
INSERT INTO spp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ka Yakuba si ntíl'a kàr'a sà pire sikyaabii shuunniŋi cû a pa ŋkan u á. Kyaare shwɔ̀hɔŋkanni l'à táan u tuŋ'á ke, ka nufooŋi si ti shwɔhɔ amuni. ");
INSERT INTO spp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Maa u jyaŋi niɲcyiiŋi Ezawu vàanɲyi nisìnaɲyi yà lwɔ́ bage e mà le Yakuba na. ");
INSERT INTO spp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Maa pire sikyaabii seeyi tɛ̀g'a Yakuba cyeyi ná u yacige tò. ");
INSERT INTO spp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Bwuruŋi ná kyaare nintáanre u à shwɔhɔ ke, maa yire kan Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ka Yakuba si ŋkàre ná y'e, u tuŋi yyére. Maa u yyere: «Baba.» Ka Ishaka si jwo: «Yo! Mii jyaŋi ŋgi u ɲyɛ mu yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ka Yakuba si u tuŋi ɲwɔ shwɔ: «Mii u ɲyɛ mu jyaŋi niɲcyiiŋi Ezawu. Nde mu mpyi a jwo mii á ke, lire mii à pyi. Mii à mu ɲáare, maa yîr'a tɛ̀ɛn, maa na kyaare tà kyà, maa jwó le na á.» ");
INSERT INTO spp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ka Ishaka si jwo u jyaŋ'á: «Ei! mu à kwɔ̀ a kyaare ta la?» Ka Yakuba si jwo: «Mu Kafooŋi Kile yabiliŋi u à sige táan mii na.» ");
INSERT INTO spp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ka Ishaka si jwo: «Na jya, file na na, si bwɔ̀n ma na, si ɲcè kampyi sèe mii jyaŋi Ezawu u ɲyɛ mu.» ");
INSERT INTO spp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ka Yakuba si file u tuŋi na, ka u u u taala a wíi, maa jwo: «Ei! Yakuba mɛjwuuni li ɲyɛ nde dɛ! Ŋka u cyeyi ɲyɛ Ezawu wuyi fiige.» ");
INSERT INTO spp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ishaka mpyi a cè na Yakuba wi mɛ, ɲaha na yɛ shire mpyi u cyeyi na, u yyahafooŋi Ezawu fiige. Ka u u wá na bégele si jwóŋi le u á. ");
INSERT INTO spp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ŋka mà jwo u jwóŋi le u á ke, u à u yíbe: «Sèe wi, mu u ɲyɛ mii jyaŋi, Ezawu la?» Ka Yakuba si jwo: «Mii wi.» ");
INSERT INTO spp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ka Ishaka si jwo: «Na jya, lire tèni i, kyaare tîrige na taan si tà kyà si nta jwóŋi le ma á.» Ka Yakuba si kyaare tîrige u taan, ka u u tà kyà. Ka Yakuba si mpa ná *ɛrɛzɛn sinm'e, ka u u puru bya mú. ");
INSERT INTO spp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Maa jwo: «Na jya, file na na, maa na pur'a cû, maa na shɛ́ɛre.» ");
INSERT INTO spp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ka Yakuba si file u na, maa u shɛ́ɛre amuni. Ishaka à u vàanɲyi nùge ta ke, ka u u jwó le u á, maa jwo: «Sèeŋi na, kɛrɛge na Kafooŋi à jwó le? ke, mii jyaŋi nùg'à táan kuru kɛrɛge fiige. ");
INSERT INTO spp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Na jya, Kile u nìɲyiŋi kamɛŋke kan ma á, u u ɲìŋke nàfuuŋi kan ma á mú, u u sùmaŋi ná ɛrɛzɛnŋi niɲyahawa kan ma á. ");
INSERT INTO spp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kile u ma yaha kìrigii ɲùŋɔ na, sùpyishi niɲyahawa s'a niŋkure sínni mu taan. Kile u ma yaha mà pyi ma sìɲɛɛbii saanwa, mu sìɲɛɛbii pi a niŋkure sínni mu taan. Shin maha shin u à mu cùmɔ lemɛ pi ke, Kile u urufoo láŋa. Shin maha shin sí u à mu cùmɔ lemɛ ɲwɔ ke, Kile u jwó le urufol'á.» ");
INSERT INTO spp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ɲyɛ tèni i Ishaka á kwɔ̀ jwóŋi ndeŋi na Yakuba á, Yakuba mú s'à yîri u taan mà kwɔ̀ ke, ka lire si bɛ̂ ná Ezawu e, u à yîri sige e mú. ");
INSERT INTO spp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ka uru mú si kyaare tà shwɔhɔ a tîrige tufooŋi Ishaka taan. Maa jwo tufooŋ'á: «Baba, yîri maa ma jyaŋi kyaare nizhwɔhɔre tà kyà maa jwó le u á.» ");
INSERT INTO spp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ka tufooŋi si jwo: «Jofoo u ɲyɛ mu yɛ?» Ka u u jwo: «Mii u ɲyɛ mu jyaŋi niɲcyiiŋi Ezawu.» ");
INSERT INTO spp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tèni i Ezawu à yire jwo ke, ka Ishaka si fyá fo na ɲcyɛ̂ɛnni sèl'e. Maa jwo: «Jofoo sí u à kyaare bò a shwɔh'a pa ŋkan mii á, mà mu ta mu sàha mpa mà yɛ? Wà a pa ná kyaare e naha, ka mii i tà kyà maa jwó le u á, u mú sí uru jwóŋi ta.» ");
INSERT INTO spp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ɲyɛ Ezawu à puru lógo u tuŋi ɲwɔ na ke, ka u lùuni si yîri, ka u u ŋkyáala fànha na, maa tufooŋi ɲáare: «Baba, jwóŋi wà le mii á mú kɛ!» ");
INSERT INTO spp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ka Ishaka si jwo: «Mu cɔɔnŋi u à fini maa wwû mu ɲwɔh'i, maa mu jwóŋi naɲwɔhɔrɔ dɛ!» ");
INSERT INTO spp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ka Ezawu si jwo: «Ei! Mɛge k'à le u na Yakuba, kur'à u cû ke, lire kurugo u à mii nàɲwɔhɔrɔ tooyi shuunni kɛ? U à mii lyɛge tɔ̀ɔnŋi shwɔ a ta, numɛ maa núr'a mii jwóŋi nàŋkaaga mú.» Maa núr'a jwo tufooŋ'á: «Lire tèni i ke, mu ɲyɛ a sà a jwóŋi wà yaha mii á mà?» ");
INSERT INTO spp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ka Ishaka si jwo Ezawu á: «Na jya, sèeŋi na, mii à jwóŋi le u á na u pyi mu ɲùŋɔ na, maa jwóŋi le u á, bà u cìnmpyiibii puni si mpyi u bilii mɛ, maa sùmaŋi ná ɛrɛzɛnŋi jwóŋi le u á. Jwóŋi ŋgire mii sí núru n-le mu á yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ka Ezawu si jwo: «Baba, lire tèni i ke, uru jwóŋi kanni u ɲyɛ mu á la? Jwóŋi wà le na á mú!» U à puru jwo ke, maa mɛɛ le na súu. ");
INSERT INTO spp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ka tufooŋi si jwo: «Mu sì ɲìŋke nàfuuŋi ta mɛ, mu taare sí n-pyi kamɛŋɛ baa. ");
INSERT INTO spp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mu kàshikwɔnŋwɔɔni li sí raa mu ɲwɔ caa. Mu sí n-pyi ma kàntugowuŋi biliwe, mu sí raa báare u á mu à jwo faapyinupee, ŋka canŋka, mu sí tire bilere zhwúŋi kebe n-láha ma yacige e si mpyi may'á. ");
INSERT INTO spp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","«Ɲyɛ Ishaka à jwóobii mpiimu le Yakuba á ke, pir'à u ɲyipɛɛnni le Ezawu e. L'à pa nɔ cyage k'e fo Ezawu na yu uye funŋ'i: «Mii tuŋi tèekwûun'á byanhara, u àha ŋkwû, ka wuu u kwùge pyi a kwɔ̀, mii sí na cɔɔnŋi Yakuba bò.» ");
INSERT INTO spp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ka wà si ŋkàre Erebeka yyére, maa sà u jyaŋi Ezawu funzɔnŋɔre jwo u á. Ka Erebeka si u jyaŋi Yakuba yyere maa yi jwo u á: «Wíi, mu yyahafooŋi Ezawu à jwo uru sí mu bò, bà uru funŋke si mpyi si ɲíŋɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Lire e, nde mii sí n-jwo mu á ke, yire lóg'a tàra, mu à yaa mu u fê a kàre Kyaran kìni i, mii yyahafooŋi Laban yyére. ");
INSERT INTO spp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Maa ntɛ̀ɛn uru yyére mà tère pyi, mà jwo mu yyahafooŋi lùuni li tɛ̀ɛn ke. ");
INSERT INTO spp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Sà ntɛ̀ɛn wani fo mu yyahawuŋi lùuni ká ntɛ̀ɛn, nde mu à pyi ke, fo u funŋɔ ká wwɔ̀ lire na. U funŋɔ ká mpa wwɔ̀, mii sí n-jà mu núruŋɔ n-pa naha. Ná lire bà mɛ, mii sí n-pɔ̂ɔn yii mú shuunni i cannugo.» ");
INSERT INTO spp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ɲyɛ ka Erebeka si ŋkàr'a sà yi jwo Ishaka á na Kyiti shiinbii pworibii Esawu à lèŋɛ ke, na pire cyeebil'à uru tɛgɛlɛ ta fo mà diɲyɛ la wwû uru na. Maa núr'a jwo na *Yakuba mú ká uru ceeŋi wà lèŋɛ, lire tèni i ke, ur'à ɲyii yige kwùŋi kurugo mà tòro lire na. ");
INSERT INTO spp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ka Ishaka si *Yakuba yyere maa jwó le u á, maa u pyi: «Ma hà ŋkwɔ̀ ma cwoŋi lwɔ́ *Kana kìni pùceepyire e mà dɛ! ");
INSERT INTO spp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ta sì fo Mɛsopotami kìni i, ma nuŋi tuŋi Betuyɛli yyére, maa sà ma nuŋi yyahafooŋi Laban pwɔrɔŋi wà lwɔ́ a pyi ma cwo kuru cyage e. ");
INSERT INTO spp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kile Siŋi Punifoo u jwó le ma á, u u pyìi niɲyahamii kan ma á, u ma pyi tùlubwɔhɔ tu. ");
INSERT INTO spp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Jwóŋi Kile à le *Ibirayima á ke, u u uru fiige le mu ná ma tùlug'á, kìni i mu à tɛ̀ɛn nàmpɔnnte e, ná l'à kan Ibirayima á ke, bà mu si mpyi si lire ta mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Lire e, Ishaka á Yakuba yaha a kàre Mɛsopotami kìni i, Aramu shinŋi Betuyɛli jyaŋi Laban yyére. Laban sí u mpyi Yakuba ná Ezawu nuŋi Erebeka yyahafooŋi. ");
INSERT INTO spp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ɲyɛ Ezawu à pa li ɲya na Ishaka á jwó le *Yakuba á, maa u pyi u sà u cwoŋi lwɔ́ Mɛsopotami kìni i ke, maa li ɲya mú na u à jwó le u á, maa yi jwo u á na u àha ceewe lwɔ́ *Kana shiinbii pùceepyire e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Maa li ɲya mú na Yakuba á u tuŋi ná u nuŋi ɲwɔmɛɛni cû, maa ŋkàre Mɛsopotami kìni i ke, ");
INSERT INTO spp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","lire e Ezawu à cè na Kana pùcyaabil'à pɛn u tuŋi Ishaka á. ");
INSERT INTO spp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","U à li ɲya amuni ke, ka u u yîr'a kàre *Ibirayima jyaŋi Sumayila yyére, maa u pwɔrɔŋi wà lwɔ́ nàmbaga na, mà bâra u cyeebii na. Uru pùcwoŋi mɛge na mpyi Makyalati, u muɲcwoŋi mɛge sí ɲyɛ Nɛbayɔti. ");
INSERT INTO spp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ɲyɛ *Yakuba á yîri Bɛrisheba kànhe e na ŋkɛ̀ɛge Kyaran kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","U niŋkàriŋ'à sà nɔ cyage k'e, numpilag'à wwɔ̀ ke, ka u u shwɔ̀n wani, maa kafaage kà lwɔ́ a pyi ɲùntahaga, maa sínni. ");
INSERT INTO spp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","U à ŋɔ́ɔ, mà katanŋaɲcyiin ɲya l'à sín ɲìŋke na, fo nìɲyiŋi na, ka *Kile mɛ̀lɛkɛɛbii si wá na dùru, marii ntîre li na. ");
INSERT INTO spp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kafooŋi Kile yabiliŋi mpyi a yyere Yakuba taan, maa yi jwo u á: «Mii u ɲyɛ Kafooŋi Kile, mu tulyage *Ibirayima ná mu tuŋi Ishaka u Kileŋi. Cyage e mu à sínni amɛ ke, mii sí kuru cyage kan mu ná ma tùlug'á. ");
INSERT INTO spp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Mu tùluge sí ɲyaha ɲìŋke nticyɛnŋi fiige. Mu sí n-pìli canŋafyinmpe ná canŋacwumpe e, si mpìli suumɔkulo ná wòrokul'e. Ɲìŋke supyishiŋi puni sí jwó ta mu ná ma pyɛnge shiinbii cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ma niŋgyiini táan maa lógo, mii sí n-pyi ná mu i ma tashèyi puni i, s'a mu kàanmucaa, si núru ná mu i nde kìni i sahaŋki. Mii sì n-sìi mu yyaha maye niŋkin mɛ, ɲwɔmɛɛ maha ɲwɔmɛɛ mii à lwɔ́ mu á ke, mii sí cyire puni fûnŋɔ.» ");
INSERT INTO spp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Puru ɲwɔhɔ na, ka Yakuba si ɲcêl'a ɲɛ̀, maa jwo: «Nàkaana baa, Kafooŋi na ɲyɛ ŋke cyage e, mii sí ɲyɛ a mpyi a li cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ka u fyagarawuŋi si jwo: «Ŋke cyage ɲyɛ fyagara cyaga dɛ! Numɛ mii à cè na Kile pyɛnge ná nìɲyiŋi tajyìge ku ɲyɛ naha.» ");
INSERT INTO spp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ɲyɛ u à yîri kuru ɲyɛsɔɔge na ke, kafaage u mpyi a tɛ̀g'a u ɲùŋke taha ke, maa kuru yîrig'a yyéeŋɛ mà pyi funɲcwogoyaaga, maa sìnmpe pà wu ku na, maa ku pyi Kile wogo. ");
INSERT INTO spp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Maa kuru cyage mɛge le Betɛli, (kuru ɲwɔhɔ ku ɲyɛ Kile pyɛnge) mà li ta tèecyiini i, kuru cyage mɛge na mpyi Luzi. ");
INSERT INTO spp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Ka Yakuba si ɲwɔfaaga fáa Kile á maa jwo: «Kafooŋi Kile, mu aha ɲɛn'a mii tɛ̀gɛ, maa mii shwɔ kawagigii na, nde ɲani i, maa yalyîre ná vàanɲyi nindeyi kan mii á, maa mii pyi mii à núr'a pa yyeɲiŋke e na tupyɛnge e, maa mpyi mii u Kileŋi, ");
INSERT INTO spp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","lire ká mpyi, ŋke kafaage mii à yyéeŋɛ amɛ, mà pyi funɲcwogoyaaga ke, kuru cyage ku sí n-pyi Kile pyɛnge. Mii aha yaaga maha yaage ta ke, mii sí kuru yáhaŋi wwû ŋkan mu, Kile á.» ");
INSERT INTO spp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Lire kàntugo, ka *Yakuba si kuni lwɔ́ a kàre canŋafyinmpe kìrigii kànmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mà u niŋkàriŋi yaha, u à sà nɔ bɛ̀ɛnŋke kà na sige funŋke e. Mpàkuruyo taanre ná sikyaa mpyi a sínni sínni ku ɲwɔge na. Yatɔɔre tabyage ku mpyi ku ki, kuru bɛ̀ɛnŋke ɲwɔge mpyi maha ntùni ná kafaabwɔh'e. ");
INSERT INTO spp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Yatɔɔre puni n'a mpyi a pa bínni, pi mpyi maha kuru kafaage kùuŋkul'a láha bɛ̀ɛnŋke ɲwɔge na maa ti kan t'a bya, maa ŋkwɔ̀ maa kuru fáage tɛ̀g'a ku ɲwɔ tò. ");
INSERT INTO spp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ka Yakuba si pire yatonahabii yíbe: «Mii cìnmpyiibii, taa yii à yîri ke?» Ka pi i u pyi: «Wuu à yîri Kyaran kànhe e.» ");
INSERT INTO spp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ka u u jwo: «Ta yii à Nakwɔri ɲambilini, Laban cè bɛ?» ka pi i jwo: «Ɔɔn.» ");
INSERT INTO spp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ka u u jwo: «U à cùuŋɔ la?» Ka pi i jwo: «Ɔɔn, u à cùuŋɔ, u pworoŋi Arasɛli nimpaŋi u ŋge ná mpàabil'e.» ");
INSERT INTO spp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ɲyɛ ka Yakuba si jwo yatonahabil'á: «Yatɔɔre tèebínini sàha nɔ mà dɛ! Yii ɲyɛ a cè na canŋke saha a ɲyaha mà? Yii yatɔɔre yaha ti i bya, lire kàntugo yii sà a ti nâha.» ");
INSERT INTO spp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ka yatonahabii si jwo: «Ná yatɔɔre puni ɲyɛ a bín'a kwɔ̀ mɛ, wuu ɲyɛ na lire pyi mɛ. T'aha bín'a kwɔ̀, wuu maha nta a kafaage láha bɛ̀ɛnŋke ɲwɔge na, maa ti kan t'a bya.» ");
INSERT INTO spp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mà Yakuba yaha u u yu ná pi e, ka Arasɛli si nɔ wani ná u tuŋi yatɔɔre e. Uru u mpyi na ti nâha. ");
INSERT INTO spp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tèni i Yakuba à u yalwoŋi Laban pworoŋi Arasɛli ɲya ná yatɔɔre e ke, ka u u ŋkàr'a sà kafaage láha bɛ̀ɛnŋke ɲwɔge na, maa ti kan t'à bya. ");
INSERT INTO spp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Maa Arasɛli pûr'a cû maa u yal'a shɛ́ɛre sèl'e, ka u ɲyaŋi funntange si ɲyilwɔhe pyi ku u ntîri u ɲyiigil'e. ");
INSERT INTO spp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Maa jwo Arasɛli á na u tuŋi cìnmpworo u ɲyɛ ure, na uru na ɲyɛ Erebeka jya. Ka Arasɛli si fê a kàre pyɛngɛ maa sà yi jwo u tuŋ'á. ");
INSERT INTO spp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tèni i Laban à u cɔɔnŋi jyaŋi Yakuba kyaa lógo ke, ka u u fê a kàre u fye e, maa sà u pûr'a cû, maa u shɛ́ɛre, maa ŋkàre ná u e pyɛngɛ. Kyaa maha kyaa l'à pyi ke, ka Yakuba si cyire puni jwo u á. ");
INSERT INTO spp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban à yire lógo ke, ka u u jwo: «Mà sèeŋi jwo, mii ná mu na ɲyɛ cìnmpyii. Ka Yakuba si ŋkwôro na báaraŋi pyi Laban yyére mà nɔ yiŋɛ niŋkin na. ");
INSERT INTO spp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ɲyɛ ka Laban si jwo u á canŋka: «Mii sùpya u ɲyɛ mu, ŋka lire ná li wuuni mu i, mu ɲyɛ a yaa mu u a báare mii á mana mɛ. Ma sàraŋi jwo na á, s'a uru kaan ma á.» ");
INSERT INTO spp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ɲyɛ lir'à ta pworii shuunni na ɲyɛ Laban á. Niɲjyeŋi mɛge mpyi Leya, nimbileni woge sí ɲyɛ Arasɛli. ");
INSERT INTO spp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya lemɛ mpyi a ɲwɔ mà Arasɛli kwɔ̀ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ka Arasɛli kyaa si ntáan Yakuba á. Ka u u jwo Laban á: «Mii sí báaraŋi pyi yyee baashuunni i mu pworoŋi nimbileŋi, Arasɛli kurugo.» ");
INSERT INTO spp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ka Laban si jwo: «Mii u u kan mu á, lir'à pwɔ́rɔ mii u u kan wabɛr'á. Tɛ̀ɛn naha ná mii i.» ");
INSERT INTO spp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","amuni Yakuba à kwôro Laban yyére, maa báaraŋi pyi yyee baashuunni Arasɛli kurugo. Bà Arasɛli kyal'à táan Yakuba á sèl'e mɛ, ɲcyii yyeegii baashuunniŋ'à pyi u á canmpyaa fiige. ");
INSERT INTO spp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Cyire yyeegil'à tòro ke, ka Yakuba si jwo Laban á: «Na cwoŋi kan na á, tèn'à fûnŋɔ. Mii la ɲyɛ si u lèŋɛ numɛ.» ");
INSERT INTO spp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ka Laban si kuru cyage sùpyire puni bínni, maa katáan nimbwoo pyi. ");
INSERT INTO spp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ɲyɛ kuru canŋke numpilage e, ka Laban si u pworoŋi Leya lwɔ́ a kàre Yakuba yyére. Ka Yakuba si shwɔ̀n ná u e kuru numpilage e. ");
INSERT INTO spp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban mpyi a u báarapyipucwoŋi wà kan Leya á, uru mɛge mpyi Zilipa. ");
INSERT INTO spp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ɲyɛ̀g'à pa múgo ke, ka Yakuba si li ta na Arasɛli bà mɛ, ŋka Leya wi. Maa jwo Laban á: «Ɲaha mu à pyi ná mii i amɛ yɛ?» Lire tèni i ke, Arasɛli kurugo bà mii à báaraŋi pyi mu á mà? Ɲaha na mu à mii naɲwɔhɔrɔ yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ka Laban si jwo u á: «Mà tàanna ná wuu tɛɛnni i, cɔɔnfooŋi ɲyɛ na jà a kan nàmbage e muɲcwofooŋi yyaha na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Cikwɔɔnre cibilaage sanŋke pyi ná Leya e. K'aha ŋkwɔ̀, wuu sí cɔɔnfooŋi kan mu á mú, maa núr'a yyee baashuunniŋi wabɛrɛ báara pyi mii á.» ");
INSERT INTO spp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ka Yakuba si kuru cibilaage sanŋke pyi ná Leya e, ka Laban si u pworoŋi Arasɛli kan u á. ");
INSERT INTO spp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban mpyi a u báarapyipucwoŋi wà kan Arasɛli á, uru mɛge mpyi Bila. ");
INSERT INTO spp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ɲyɛ ka Yakuba si shwɔ̀n ná Arasɛli e mú. Ka u kyaa si ntáan u á mà tòro Leya na. Ka Yakuba si núr'a báaraŋi pyi Laban á sahaŋki fo yyee baashuunni. ");
INSERT INTO spp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ka Kafooŋi Kile si li ɲya na Leya kyaa ɲyɛ a táan *Yakuba á mɛ, ka u u sege táan u na. Maa sege pɛn Arasɛli na. ");
INSERT INTO spp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ka Leya si yyére maa si pùnambile, maa li mɛge le Urubɛn: «Kafooŋi Kile à mii nàvunŋke ɲya, numɛ mii kyaa sí n-táan na pooŋ'á.» ");
INSERT INTO spp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ka u u núr'a yyére, maa si pùnambile, maa jwo: «Kafooŋi Kile à lógo na mii kyaa ɲyɛ a táan na pooŋ'á mɛ, lire kurugo u à nde pùnambilini kan mii á mú.» Maa li mɛge le Simiyɔn. ");
INSERT INTO spp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ka Leya si núr'a yyére maa si pùnambile, maa jwo: «Numɛ kɔni, mii pooŋi sí mii mâra, ɲaha na yɛ mii à pùnampyire taanre si u á.» Maa li mɛge le Levi. ");
INSERT INTO spp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ka u u núr'a yyére, maa pùnambile sicyɛrewu si, maa jwo: «Numɛ, mii sí Kafooŋi kêe.» Lire kurugo, u à lire mɛge le *Zhuda. Lire kàntugo, ka u sege si yyére mà tère pyi. ");
INSERT INTO spp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ɲyɛ Arasɛli à pa li ɲya na uru sàha ŋkwɔ̀ a pyà ta *Yakuba á mɛ, ka u muɲcwoŋi yiɲcyɛge si jyè u e. Ka u u jwo Yakuba á: «Pyìibii pìi kan mii á mú. Fo lire bà mɛ, mii sí n-kwû.» ");
INSERT INTO spp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ka Yakuba lùuni si yîri Arasɛli taan, maa jwo: «Lire tèni i ke, mii u ɲyɛ Kile la? Kile bà u à mu sige pyìsini na mà?» ");
INSERT INTO spp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ka Arasɛli si jwo: «Mii báarapyipucwoŋi Bila u ŋge, u lwɔ́ a pyi ma cwo, bà u si mpyi si pyìi ta mii á mɛ. Lire ká mpyi, pire pyìibii sí n-pyi mii wuu.» ");
INSERT INTO spp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Lire pyiŋkanni na, Arasɛli à u báarapyipucwoŋi Bila kan Yakuba á, u à pyi u cwo. Ka Yakuba si u lèŋɛ. ");
INSERT INTO spp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ka Bila si mpa laa ta, maa pùnambile si Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ka Arasɛli si jwo: «Kile à mii tànga kan. Nde mii à jwo u á ke, u à lire lógo, maa pùnambile kan mii á. Lire kurugo, Arasɛli à li mɛge le Dan. ");
INSERT INTO spp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ka Arasɛli báarapyipucwoŋi Bila si núr'a laa lwɔ́ maa pùnambile shɔnwuu si Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ka Arasɛli si jwo: «Sèeŋi na, mii à zhìŋi le ná na muɲcwoŋi i, maa jà u na.» Lire kurugo, u à lire pùnambilini mɛge le Nɛfitali. ");
INSERT INTO spp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ɲyɛ Leya à pa li ɲya na uru seg'à *kwɔ̀n mà tère pyi ke, ka u u u báarapyipucwoŋi Zilipa kan Yakuba á, u à pyi u cwo. ");
INSERT INTO spp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ka Zilipa si laa lwɔ́, maa pùnambile si Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ka Leya si jwo: «Mii ɲùŋk'à táan dɛ!» Lire kurugo, u à li mɛge le Gadi. ");
INSERT INTO spp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ka Zilipa si núr'a pùnambile si Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ka Leya si jwo: «Ei! funntange kyaa li ɲyɛ nde dɛ! Cyeebii sí n-jwo na mii wuun'à ɲwɔ.» Maa lire pùnambilini mɛge le Ashɛri ");
INSERT INTO spp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ɲyɛ canŋka, sùmakwɔɔngii tèni i, Urubɛn à fwor'a kàr'a sà mandaragɔri cige kà ɲya kɛrɛge e. Ka u u kuru cige fwuugii cyìi tùgo a pa ŋkan u nuŋi Leya á. Ka Arasɛli si jwo Leya á: «Na pwɔhɔ, maa ma jyaŋi mandaragɔri cige fwuugii cyìi kan na á.» ");
INSERT INTO spp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ka Leya si jwo: «Na ɲaha? Mu à mii pooŋi shwɔ mii na, lire ɲyɛ a mu funŋke ɲíŋɛ mɛ, fo mu sàha na ŋko mii u na jyaŋi fwuugii kan mu á si ntaha lire na kɛ?» Ka Arasɛli si jwo: «Ɲyɛ kampyi lire li, u sí n-pa niɲjaa numpilage pyi ná mu i. Lire sí n-pyi mu jyaŋi fwuugii cyaga.» Ka Leya si ɲɛɛ. ");
INSERT INTO spp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ɲyɛ yàkoŋke Yakuba niɲjîriŋi kɛrɛge e, ka Leya si ŋkàr'a sà u ɲùŋɔ bɛ̂, maa yi jwo u á: «Mu sí n-shwɔ̀n mii yyére niɲjaa. Mii à na jyaŋi fwuugii tɛ̀g'a mu fáa Arasɛli á niɲjaa kàzhwɔɔnni mɛɛ na.» Ka Yakuba si ŋkàr'a sà shwɔ̀n Leya yyére kuru canŋke numpilage e. ");
INSERT INTO spp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ka Kile si Leya ɲaarage shwɔ. Ka u u laa lwɔ́ maa pùnambilini kaŋkurowuuni si Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Maa jwo: «Mii à na báarapyipucwoŋi kan na pooŋ'á ke, lire sàraŋi Kile à kan mii á amɛ.» Lire kurugo, u à lire pùnambilini mɛge le Isakari. ");
INSERT INTO spp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ka u u núr'a pa laa lwɔ́ maa pùnambilini baaniwuuni si Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Maa jwo: «Kile à bùɲyɛbwɔhɔ pyi mii á. Numɛ, mii pooŋi sí mii le ɲjire e, ɲaha na yɛ mii à pùnampyire baani si u á.» Ka u u lire pùnambilini mɛge le Zabulɔn. ");
INSERT INTO spp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Lire kàntugo, ka u u pùceebile si, maa lire mɛge le Dina. ");
INSERT INTO spp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ɲyɛ ka Kile si funŋɔ cwo Arasɛli na, maa u ɲaariyi shwɔ, ka u sege si ɲwɔ cû. ");
INSERT INTO spp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ka u u laa lwɔ́ maa si pùnambile. Maa jwo: «Kile à silege láha mii na numɛ.» ");
INSERT INTO spp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Maa lire pùnambile mɛge le Yusufu. Maa jwo: «Kile u pùnambilini labɛrɛ bâra nde na mii á.» ");
INSERT INTO spp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ɲyɛ Yusufu siŋkwooni kàntugo Arasɛli á, ka *Yakuba si jwo canŋka Laban á: «Kuni kan na á, mii sí núru n-kàre na tupyɛnge e. ");
INSERT INTO spp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Na cyeebii ná na pyìibii kan na á, pire kurugo mii à báaraŋi pyi mu á. Pi kan na á, mii kɛ̀ɛge na tupyɛnge e. Nde mii à pyi mu á ke, mu yabiliŋ'à li cè.» ");
INSERT INTO spp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ka Laban si u pyi: «Kampyi mii kyal'à táan mu á, mii la ɲyɛ maa ntɛ̀ɛn naha. Ɲaha kurugo yɛ mii à cɛɛre pyi mà li ɲya na Kafooŋi Kile à jwó le mii á mu cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mu sàraŋi ɲyɛ yaage ŋkemu ke, kuru jwo na á, si kuru kan ma á.» ");
INSERT INTO spp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ka Yakuba si jwo: «Báareŋkanni na mii à báara mu á, ná ɲyahaŋkanni na mu yatɔɔr'à ɲyaha mii cye e ke, mu à li cè. ");
INSERT INTO spp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Yatɔɔre nimpyigire ti mpyi mu á, mà mii ta mii sàha mpa mɛ, tir'à púgo a pyi kurumbwɔhɔ. Kafooŋi Kile à jwó le mu á mii cye kurugo. Numɛ, mà mii yaha naha, tèni ndire mii sí n-ta si mbáare na pyɛnge shiinbil'á yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ka Laban si jwo: «Ɲaha mu la ɲyɛ mii u kan mu á ma sàraŋi yɛ?» Ka Yakuba si jwo: «Mii ɲyɛ a tîge yaage kabɛrɛ kurugo mɛ, ɲje mii sí n-jwo mu á ke, mu aha ntɛ̀ɛn yire taan, mii sí núru raa mu yatɔɔre nâha. ");
INSERT INTO spp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ɲyɛ niɲjaa, mii sí n-jyè mu yatɔɔre shwɔhɔl'e si ti wíi niŋkin niŋkin. Mpàabii puni pi ɲyɛ pi ɲyɛ a fíniŋɛ mɛ, ná sikaabii puni pi à ɲɛ́ŋɛ ke, pire pi sí n-pyi mii sàraŋi. ");
INSERT INTO spp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mu aha mpa mii yatɔɔre kàanmucya canŋke ŋkemu i ke, kampyi mii à tíi, mu sí n-cè. Mu aha bú mpa sika maha sika ta ti shwɔhɔl'e ŋgemu u ɲyɛ u ɲyɛ a ɲɛ́ŋɛ mɛ, lire ɲyɛ mɛ mpà maha mpà u à fíniŋɛ ke, mu kú n-cè n-jwo na mii à uru yû. ");
INSERT INTO spp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ɲyɛ ka Laban si jwo: «Bà mu à yi jwo mɛ, wuu yi pyi amuni.» ");
INSERT INTO spp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ŋka kuru canŋke yabiliŋi i, Laban à yîri maa sikaabii niɲɛ̀ŋɛbii, ná mpàabii niŋgwòobii cwɔɔnr'a yaha piye kanni na, ");
INSERT INTO spp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","maa pire kan u pyìibil'á pi sà a pire nâha cyage kabɛr'e, bà pi laage si mpyi si ntɔɔn Yakuba na mɛ. Canmpyaa taanre ɲara pi à pyi, maa nɔ kuru cyage e. Ka Yakuba si ŋkwôro na Laban yatɔɔre sannte nâha. ");
INSERT INTO spp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ɲyɛ ka Yakuba si kabiipuruyo *kwɔ̀n, pepiliye cige na, ná amandiye cige na, ná pilatani cige na. Maa cyire kàbigigii kwooyi nimpuruyi yà láhala láhala maa yire tafyinyi yige yig'a yaha. ");
INSERT INTO spp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Maa cyi le le yatɔɔre yabyayi i, bà yatɔɔre si mpyi t'aha a ma tabyage e ti raa cyi ɲaa mɛ. Ɲyɛ yatɔɔre tiye tèekɔ̀rɔŋ'à nɔ ke, ");
INSERT INTO spp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ka ti i wá na tiye dùru tabyage e, marii cyire kàbigigii ɲaa, ka li i mpyi amuni, yatɔɔr'à pa a sini ke, ka ti pyìre si ɲɛ́ŋɛ. ");
INSERT INTO spp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakuba mpyi a mpànɛɛbii cwɔɔnr'a yaha piye kanni na. Mpàpeebii n'a mpyi na ŋkor'a pi dùru tèni ndemu i ke, u mpyi maha pi yaha pi i Laban yatɔɔre niɲɛ̀ŋɛre ná niŋgwòore ɲaa, bà pi si mpyi pi aha si, pi pyìibii si ɲɛ́ŋɛ mɛ. Amuni Yakuba á pyi maa yatɔɔrɔ niɲyahara ta, maa ti yaha tiye kanni na. ");
INSERT INTO spp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Mà bâra lire na, yatɔɔre sèewoore n'a mpyi na ŋkòr'a tiye dùru tabyage e, Yakuba mpyi maha cyire kàbigigii ɲɛmpe wogigii le lùbyayaayi i, ti i ɲaa. ");
INSERT INTO spp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ŋka niɲcwɔgɔre n'a mpyi na ma tabyage e, u mpyi maha ɲɛn'a kàbigigii le lwɔhe e mɛ. Ɲyɛ lire pyiŋkanni na, mpàpyire ná sikapyire niɲcwɔgɔr'à pyi Laban woro, ka nintubuunte si mpyi Yakuba woro. ");
INSERT INTO spp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ɲyɛ amuni Yakuba à pa mpyi nàfuufeembwɔhɔ, u à sikyaa ná mpàa niɲyahamii ta. Báarapyicyee ná báarapyinambaa na mpyi u á, ná ɲwɔ́hɔɲyi ná dùfaanya. ");
INSERT INTO spp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ɲyɛ l'à pa nɔ cyage k'e, fo Laban pyìibil'à jwo na: «*Yakuba à wuu tuŋi cyeyaayi puni lwɔ́ a pyi u wuyo. Lire pyiŋkanni na, u à uye pyi yaarafoo.» Ka puru jwumpe si nɔ Yakuba na. ");
INSERT INTO spp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ka Yakuba mú si li ɲya na yyetange ku mpyi Laban á mà yyaha tíi ná ur'e ke, na u sàha ɲyɛ ná kur'e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ɲyɛ canŋka Kafooŋi Kile à jwo Yakuba á: «Núru ma tupyɛnge e, cyage e mu à si ke. Mii sí n-pyi ná mu i.» ");
INSERT INTO spp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Pur'à jwo ke, ka Yakuba si ntɛ̀ɛn u yatɔɔre cyage e sige e, maa wà tun u à Arasɛli ná Leya yyere. ");
INSERT INTO spp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Pi à pa ke, ka u u yi jwo pi á: «Mii à li ɲya yii tuŋi yyahe e, cùŋkanni na u mpyi a fyânha a mii cû ke, u sàha ɲyɛ amuni ná mii i mɛ. Ŋka mii tuŋi u Kileŋi à kwôro ná mii i. ");
INSERT INTO spp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yii yabilimpil'à cè na mii à báare yii tuŋ'á ná na fànhe puni i. ");
INSERT INTO spp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Lire ná li wuuni mú i, yii tuŋ'à mii naɲwɔhɔrɔ, maa mii sàraŋi kɛ̂ɛnŋɛ fo tooyo kɛ. Ŋka Kile ɲyɛ a ɲɛɛ u kapii pyi mii na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","U n'a mpyi a jwo na mii sàraŋi u sí n-pyi yatɔɔre t'à ɲɛ́ŋɛ sèe sèl'e ke, ti puni pyìibii mpyi maha ɲɛ́ŋɛ sèl'e. Ɲyɛ u n'a mpyi a núr'a yi kɛ̂ɛnŋɛ, maa jwo mii sàraŋi u sí n-pyi ntemu ti ɲyɛ ti ɲyɛ a ɲɛ́ŋɛ sèe sèl'e mɛ, yatɔɔre pyìre puni mpyi maha sini amuni. ");
INSERT INTO spp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kile u à yii tuŋi yatɔɔre shwɔ u na mà kan mii á. ");
INSERT INTO spp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ɲaha kurugo yɛ tèni i yatɔɔre mpyi na tiye dùru ke, mii à ŋɔɔgɔ ŋɔ́ɔ, mà li ɲya sikaperigii cyi mpyi na sikacyeebii dùru ke, cyire pun'á ɲɛ́ŋɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Lire tèni i, Kile Mɛlɛkɛŋi à mii yyere ŋɔɔge e: «Yakuba» ka mii i shwɔ. ");
INSERT INTO spp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ka u u jwo: «Ma yyahe yîrige maa wíi: Sikaperigii cyi wá na dùru sikacyeebii na ke, cyire pun'á ɲɛ́ŋɛ ɲɛ́ŋɛ.» Maa jwo: «Mii à lire pyi, ɲaha na yɛ ɲcyii puni Laban à pyi mu na ke, mii à cyire ɲya. ");
INSERT INTO spp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Kileŋi u à uye cyêe mu na Betɛli i ke, mii u ɲyɛ ure. Kuru cyage e, mu à sìnmpe wu kafaage na, maa ku pyi funɲcwoyaaga, maa ɲwɔ fáa mii, Kile á. Ɲyɛ numɛ yîr'a fworo nde kìni i maraa sì ma tasege e.» ");
INSERT INTO spp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ɲyɛ Arasɛli ná Leya á puru jwumpe lógo ke, ka pi i jwo: «Wuu nàzhan yaaga sàha ɲyɛ naha mɛ, wuu mú sì kɔɔgɔ ta wuu tuŋi pyɛnge e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Wuu tuŋ'à wuu cû nàmpwuun fiige numɛ, u à wuu pɛ́rɛ maa uru wyɛ́rɛŋi lyî a kwɔ̀.» ");
INSERT INTO spp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Maa jwo Yakuba á sahaŋki: «Kile à nàfuuŋi ŋgemu shwɔ u na, mà kan mu á ke, uru na ɲyɛ wuu ná wuu pyìibii wuu numɛ. Lire e ke, Kile à ndemu jwo mu á ke, lire pyi.» ");
INSERT INTO spp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Ka Yakuba si yîri, maa u cyeebii ná u pyìibii dùrugo ɲwɔhɔɲyi ɲuŋ'i, maa kuni lwɔ́ na ŋkɛ̀ɛge u tuŋi Ishaka yyére, *Kana kìni i. Maa ŋkàre ná u yatɔɔre ná u cyeyaayi puni i, ɲje u à ta Mɛsopotami kìni i ke. ");
INSERT INTO spp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tèni i Yakuba a fê ke, lir'à Laban ta u à kàre u mpàabii shire takwɔ̀nge e. Ɲyɛ pi niŋkàribii na, ka Arasɛli si u tuŋi kacyanhigii yû. ");
INSERT INTO spp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Lire pyiŋkanni na, Yakuba á wwû Aramu shinŋi Laban ɲwɔh'i, maa fwor'a kàre, u ɲyɛ a jwo ná u e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yaaga maha yaaga ku mpyi u woge ke, u à fyâl'a yire puni lwɔ́ a kàre. U à Efirati baŋi *kwɔ̀n, maa ŋkàre Galadi ɲaɲyi kànmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","*Yakuba á canmpyaa taanre ɲaara, ka pi i nta a yi jwo Laban á na u à fê. ");
INSERT INTO spp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ka Laban ná u shiinbii pìi si yîri, maa Yakuba fyè tɔ̀rɔ canmpyaa baashuunni i, mà sà u ta Galadi ɲaɲyi shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ŋka kuru canŋke numpilage e, Kile à uye cyêe Aramu shinŋi Laban na ŋɔɔg'e, maa yi jwo u á: «Maye kàanmucya. Ma hà yaaga pyi Yakuba na mà dɛ!» ");
INSERT INTO spp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ɲyɛ tèni i Laban a Yakuba kɔ̀r'a ta ke, lir'à u ta u à u vàanŋke bayi kwòro kwòro Galadi ɲaɲyi shwɔhɔl'e. Ka Laban ná u fyèɲwɔhɔshiinbii mú si pi wuyi kwòro wani cyage kabɛr'e. ");
INSERT INTO spp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kàntugo, ka Laban si ŋkàr'a sà Yakuba yíbe: «Ɲaha mu à pyi amɛ yɛ? Ɲaha na mu à mii ɲwɔhɔ yaha maa mii pùcɛribii cû a fworo, mu à jwo bilii pi à cû kàshige takwɔ̀nge e yɛ? ");
INSERT INTO spp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ɲaha na mu à wwû mii ɲwɔh'i maa ŋwɔh'a fworo, mu ɲyɛ a yi jwo mii á mà yɛ? Kàmpyi mu mpyi a yi jwo mii á, mii mpyi na sí katáan nimbwo pyi mu ŋkàraŋi mɛgɛ na, ná myahigil'e, ná bàribii ná kɔ̀nɔbil'e. ");
INSERT INTO spp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Mu bà ɲyɛ a yyére mii u pishɛɛre kan na pyìibii ná na ɲampyir'á mɛ! Ɲaha funŋɔ baara mu à pyi amɛ yɛ? ");
INSERT INTO spp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Cyage e mu ɲyɛ numɛ ke, mii sí n-jà kapii pyi mu na. Ŋka taɲjaa, mu tuŋi u Kileŋi à jwo ná mii i. U à jwo: «Maye kàanmucya, ma hà yaaga pyi Yakuba na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ɲyɛ mii à cè na mu funŋk'à wyɛ̀rɛ, mu la ɲyɛ si ŋkàre ma tukanha na. Ŋka ɲaha kurugo mu niŋkàriŋ'à mii kacyanhigii yû yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ka Yakuba si u ɲwɔ shwɔ: «Mii mpyi na fyáge na mu sí ma pwɔ̀ribii shwɔ mii na, lire kurugo mii à ŋwɔh'a fê a yîri mu taan. ");
INSERT INTO spp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ŋka mu aha ma kacyanhigii ta naha shin maha shin á, urufoo sí n-bò. Cìnmpyiibii puni pi mpii naha, kampyi mu wá ma yaaga ɲya, ku lwɔ́.» Lir'à ta Yakuba mpyi a cè na Arasɛli u à u tuŋi kacyanhigii yû mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ɲyɛ ka Laban si sà jyè Yakuba vàanŋke bage e, maa cyeyi puni wíi, maa sà jyè báarapyicyeebii mú shuunni wuyi i, maa wíi mú, maa jyè Leya woge e, maa kuru wíi. Puru ɲwɔhɔ na, maa sà jyè Arasɛli woge e. ");
INSERT INTO spp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Taa Arasɛli u mpyi a u tuŋi kacyanhigii ŋwɔhɔ a lwɔ́ a le ɲwɔ́hɔŋke yatɛ̀ɛnŋke ɲwɔh'i, maa ntɛ̀ɛn ku ɲuŋ'i. Ka Laban si cyeyi puni wíi, u ɲyɛ a yaaga ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ka Arasɛli si jwo: «Baba, maye sanŋa yaha, cyeebii làdaŋi u naha mii na niɲjaa, lire kurugo mii nàha na sì n-jà n-yîri mɛ.» Ka Laban si u kacyanhigii cya shiŋi puni, u ɲyɛ a cyi ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ka Yakuba lùuni si yîri u taan, fo ka ku pyi kàshi maa jwo u á: «Kapiini ndire mii à pyi yɛ? Ɲaha kafiile mii à pyi, ka mu u wá na mii fyè tɔ̀rɔ amɛ yɛ? ");
INSERT INTO spp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Mu à mii yaayi puni wíi ke, mu à ma yaaga ɲya la? Mu aha nta mu à kà ɲya, ku cyêe ma shiinbii ná mii wuubii na, pire sí mii ná mu láha wuye na. ");
INSERT INTO spp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Yyee beɲjaaga mii à pyi mu á báaraŋi na. Mu mpàacyeebii ná mu sikacyeebil'à pyà maha pyà si ke, pire puni ɲyii wuubii pi à si. Canŋa niŋkin mii ɲyɛ a mu mpàpooŋi wà bò a kyà mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Naŋiyaaga n'a mpyi a mu yatɔɔge kà cû, mii mpyi maha ntɛ̀ɛnn'a yi jwo mu á mɛ, mii yabiliŋi mpyi maha kuru faare cya. Yatɔɔge kà n'a mpyi a yû, l'à pyi canŋke e yoo, l'à pyi numpilage e yoo, mu mpyi maha jwo na mii u ku cyage cya. ");
INSERT INTO spp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Canŋke e, kafwuge mpyi maha mii sore, numpilage e, wyeere mpyi maha mii ndîri, fo mii sì n-jà ŋɔ́ɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Cyii yyee beɲjaaga u ɲyɛ ŋge, mii ɲyɛ mu pyɛnge e. Mii à báara mu á yyee kɛ ná sicyɛɛre, mu pworibii mú shuunni kurugo. Puru ɲwɔhɔ na, mii à yyee baani pyi báaraŋi na sahaŋki si nta yatɔɔre tà ta. Ŋka mu à mii sàraŋi kɛ̂ɛnŋɛ fo tooyi kɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mii tulyage *Ibirayima u Kileŋi, ŋgemu yyaha fyagare e mii tuŋi Ishaka na ɲaare ke, kàmpyi uru Kileŋi mpyi ná mii i mɛ, mu mpyi na sí mii cyeŋgayi wuŋi yaha, mii u kàre. Kile à mii kanhare ná mii báaraŋi ɲya, lire kurugo u à tànge kan mii á taɲjaa mu ŋɔɔge e. ");
INSERT INTO spp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ɲyɛ ka Laban si *Yakuba ɲwɔ shwɔ: «Mii pyìi pi ɲyɛ mu cyeebii, pi pyìibii mú na ɲyɛ mii pyìi. Nte yatɔɔre ɲyɛ mii woro, yaaga maha yaaga na mu ɲyii ɲya ke, yire puni ɲyɛ mii wuyo. Ɲaha mii sí n-jà n-pyi na pworibii ná pi pyìibil'á niɲjaa yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Maa núr'a jwo Yakuba á: «Wuu wwoɲɛɛgɛ le, wuu u yaaga yaa mu à jwo shéere wuu ná wuye shwɔhɔl'e, bà kuru si mpyi s'a wuu funŋɔ cwo tèrigii puni i mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ka Yakuba si kafaage kà lwɔ́ a yyéeŋɛ mà pyi funɲcwogoyaaga, ");
INSERT INTO spp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","maa jwo u shiinbil'á na pi kafaayi yà bíl'a bínni. Y'à bíl'a bín'a kwɔ̀ ke, ka pi puni si wwɔ̀ maa lyî yire kafaayi ŋkère na. ");
INSERT INTO spp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ka pi i yire kafaayi mɛge le Shéere. Kuru mɛge ku ɲyɛ Laban shɛɛnre e Yegari Sahaduta maa mpyi Yakuba woore e Galɛdi. ");
INSERT INTO spp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ka Laban si jwo: «Ŋke kafaaɲaŋke ku pyi mu à jwo shéere mii ná mu shwɔhɔl'e niɲjaa. Lire kurugo, kuru cyage mɛg'à le Galeedi.» ");
INSERT INTO spp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ŋka kuru cyage mɛg'a pa le Mizipa mú, ɲaha na yɛ Laban à jwo Yakuba á: «Wuu aha mpa mpyi wuu saha ɲyɛ na wuye ɲaa mɛ, Kafooŋi Kile u pyi wuu kàanmucyafoo.» ");
INSERT INTO spp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ka Laban si jwo Yakuba á sahaŋki: «Mu aha mii pùcɛribii cùmɔ lemɛ pi, maa cyeebii piibɛrii lwɔ́, sùpya ɲyɛ wuu shɛ̀rɛfoo mà dɛ! Ta maye kàanmucaa, ɲaha na yɛ Kile u ɲyɛ wuu shɛ̀rɛfoo.» ");
INSERT INTO spp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Maa jwo sahaŋki: «Ŋke kafaaɲaŋke wíi, na kafaage mii à yyéeŋɛ mà pyi funɲcwogoyaaga ke, ");
INSERT INTO spp_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","yire yi pyi wuu shɛ̀rɛfoo, mii ɲyɛ a yaa mii u tòro yire kafaayi taan ná funmpege e si ŋkàre mu yyére mɛ, mu mú sí ɲyɛ a yaa mu u tòro yi taan si mpa mii fye e ná funmpege e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","*Ibirayima u Kileŋi ná Nakwɔri u kileŋi, pire pi pyi wuu yukyaabii.» Ka Yakuba si ŋkâa Kile na, uru ŋgemu yyahafyagare e u tuŋi Ishaka na ɲaare ke. ");
INSERT INTO spp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Lire kàntugo, ka Yakuba si yatɔɔge kà pyi sáraga kuru kafaaɲaŋke cyage e. Maa pi yyer'a pa, ka pi i lyî siɲcyan maa shwɔ̀n wani. ");
INSERT INTO spp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kuru canŋke nùmpanŋa ɲyɛ̀sɔɔge na, Laban à yîri maa pishɛɛre kan u pucɛrɛbii ná u ɲampyir'á, maa jwó le pi á. Puru ɲwɔhɔ na, maa núr'a kàre u pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ɲyɛ ka *Yakuba si ntòro ná ɲaani i. Mà u yaha u u ŋkɛ̀ɛge u à círi ná *Kile mɛ̀lɛkɛɛbii pìl'e. ");
INSERT INTO spp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Tèni i u à pi ɲya ke, ka u u jwo: «Kile tatɛ̀ɛnge kà ku ɲyɛ ŋke!» Lire kurugo, pi à kuru cyage mɛge le Tatɛɛnyi Shuunni. ");
INSERT INTO spp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Lire kàntugo, ka Yakuba si u shiinbii pìi tun u yyahafooŋi Ezawu yyére Seyiri ɲaɲyi i, Edɔmu kùluni i. ");
INSERT INTO spp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Maa yi jwo pi á na pi sà yi jwo uru ɲùŋufooŋi Ezawu á na u bilinaŋi Yakuba u à pire tun, na uru na mpyi Laban yyére fo mà pa nɔ niɲjaa na. ");
INSERT INTO spp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Maa núr'a jwo pi á sahaŋki na pi yi jwo u á na nìiyi na ɲyɛ ur'á, mà bâra dùfaanyi na, ná sikyaa ná báarapyinambaa ná báarapyicyee, na ur'à yire ɲje jwo u ɲùŋufooŋ'á, bà u si mpyi si uru cùmɔ lemɛ ɲwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ɲyɛ ka tùnntunmpii si ŋkàr'a sà tire tùnnture jwo Ezawu á maa núr'a pa yi jwo Yakuba á: «Wuu à shà mu yyahafooŋi yyére. Nàmbaa ŋkwuu sicyɛɛre na wá u fye e na mu bêni.» ");
INSERT INTO spp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tèni i Yakuba á yire lógo ke, ka u u fyá fo na ɲcyɛ̂ɛnni. Sùpyire ti mpyi u á ke, ná sikaabii ná mpàabii ná nìiyi, ná ɲwɔhɔɲyi, u à yire puni táa mà pyi kuruyɔ shuunni. ");
INSERT INTO spp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Maa jwo uye funŋ'i: «Ezawu ká bú ɲcwo kuruŋke kà na, ku sanŋke sí tashwɔgɔ ta.» ");
INSERT INTO spp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Maa Kile ɲáare maa jwo: «Kafooŋi Kile, mii tulyage *Ibirayima ná mii tuŋi Ishaka u Kileŋi, mu à jwo mii á na mii u núru na kìni i, na tasege e, na mu sí ɲwɔ mii na. ");
INSERT INTO spp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mu à kacɛnŋii pyi mii á, maa ma ɲwɔmɛɛfente cyêe mii na, mii u ɲyɛ mu bilinaŋi ke, mà li ta mii mpyi a yaa ná lire e mɛ. Mii niŋkàriŋi Laban yyére, tèni i mii à Zhurudɛn baŋi jyiile ke, yafyin mpyi mii cye e mɛ, fo kàbii kanna. Ŋka niɲjaa, mii à na sùpyire ná na yatɔɔre táa táa kuruɲyi shuunni. ");
INSERT INTO spp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mii à mu ɲáare maa na shwɔ na yyahafooŋi Ezawu na, ɲaha na yɛ mii na fyáge u aha ŋkwɔ̀ mii ná na cyeebii ná na pyìibii bò mɛ. ");
INSERT INTO spp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Kafooŋi Kile, mu yabiliŋi u à jwo na mu sí ɲwɔ mii á, si mii tùluge ɲyaha bà suumpe lwɔhe nticyɛnŋi ɲyɛ mɛ, fo wà sì n-jà ku tɔ̀rɔ mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ɲyɛ Yakuba á Kile ɲáara a kwɔ̀ ke, maa shwɔ̀n wani. Maa yà wwû u cyeyaayi i mà tùugo u yyahafooŋi Ezawu á mà pyi bùɲyɛ. ");
INSERT INTO spp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Sikacyee ŋkwuu shuunni ná sikaperii beɲjaaga ná mpacyee ŋkwuu shuunni ná mpàpee beɲjaaga, ");
INSERT INTO spp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ná ɲwɔ́hɔɲcyee beɲjaaga ná kɛ ná yi pyìi, ná nùcyee beeshuunni ná nùpyahahii kɛ ná dùfaanɲcyee beɲjaaga ná dùfaanmpee kɛ, ");
INSERT INTO spp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","maa yire kan u báarapyiibii pi mâra, pi puni ná pi mɛgɛ yatoŋkuruŋɔ. Maa yi jwo pi á: «Yii yaha na yyaha na, yii i laaga le le yatoŋkuruyi ná yiye shwɔhɔl'e» ");
INSERT INTO spp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Maa yi jwo yatoŋkuruŋke niɲcyiige fooŋ'á: «Mii yyahafooŋi Ezawu ká bɛ̂ ná mu i, maa mu yíbe: «Taa mu sì ke? Jofoo u báarapyi u ɲyɛ mu yɛ? Yatokuruŋke ku ŋke mu yyaha na ke, jofoo wogo ki yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Maa u ɲwɔ shwɔ: «Mu bilinaŋi Yakuba woge ki, u ɲùŋufooŋi Ezawu u bùɲyɛ u ɲyɛ u wi. Uru yabiliŋi mú sí ɲyɛ kàntugo na ma. ");
INSERT INTO spp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Puru ninumpe Yakuba á jwo yatoŋkuruyi sanɲyi feebii niŋkin niŋkin á. Maa yi jwo pi á na pi aha ɲcíri ná Ezawu i, pi i puru jwumpe ninumpe taha u á. ");
INSERT INTO spp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Maa núr'a jwo pi á: «Yii yi jwo u á na u bilinaŋi Yakuba sí n-pa kàntugo yyére.» Yakuba mpyi na yu uye funŋ'i: «Yatɔɔre nte mii à yaha a kàre naye yyaha na ke, tire ká ŋkan u á, u funŋke sí ɲíŋɛ. Lire e, wuu aha bá wuye ɲya tèni ndemu i ke, lire kú n-jà u pyi u mii bɛ̂ ná funntange e. ");
INSERT INTO spp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ɲyɛ *Yakuba á yire bùɲyɛyaayi yaha a kàre uye yyaha na ke, ka u yabiliŋi si ntɛ̀ɛn wani kuru canŋke numpilage e. Numpilag'à nɔ cyage e ke, ");
INSERT INTO spp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","24","ka u u u cyeebii mú shuunniŋi ná u báarapyicyeebii shuunniŋi, ná u pyìibii kɛ ná niŋkinŋi pyi pi à Yabɔki baŋi jyiile ná u cyeyaayi puni i. ");
INSERT INTO spp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Puru ɲwɔhɔ na, maa ntɛ̀ɛn uye niŋkin wani, ka nàŋi wà si mpa zhì le ná u e mà nɔ fo ɲyɛ̀kwɔnge na. ");
INSERT INTO spp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nàŋ'à pa li ɲya na uru sì n-jà Yakuba cyán mɛ, ka u u u bwɔ̀n dìshige na, ka ku u ŋwɔ́hɔrɔ. ");
INSERT INTO spp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Maa jwo Yakuba á: «Na yaha s'a ŋkɛ̀ɛge, ɲaha na yɛ ɲyɛ̀g'à múgo.» Ka Yakuba si jwo: «Ná mu ɲyɛ a jwó le mii á mɛ, mii sì mu yaha mu u ŋkàre mà dɛ!» ");
INSERT INTO spp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ka u u jwo: «Di mu mɛge ɲyɛ yɛ?» Ka u u jwo: «Yakuba.» ");
INSERT INTO spp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ka nàŋi si jwo: «Mu mɛge saha sì n-pyi Yakuba mɛ, ku sí n-pyi *Izirayɛli, ɲaha na yɛ mu à zhì le ná Kile e, mà bâra lire na, mu à sí ta sùpyire na.» ");
INSERT INTO spp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ka Yakuba si u pyi: «Mii na mu ɲáare, maa ma mɛge jwo na á.» Ka nàŋi si jwo: «Ɲaha na mu na mii mɛge yíbili yɛ?» U à yire jwo ke, maa jwó le Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ka Yakuba si kuru cyage mɛge le Peniyɛli, maa jwo: «Mii yábiliŋi ɲyiigil'à Kile ɲya, lire na li wuuni mú i, mii à kwôro ɲyii na.» ");
INSERT INTO spp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tèni i Yakuba à yîri Peniyɛli i, mà baŋi *kwɔ̀n ke, lir'à canŋa ɲyiini ta li i fwore. Dìshige ɲjàŋi mpyi a u pyi u u sêgere taɲaarege e. ");
INSERT INTO spp_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Mà lwɔ́ kuru canŋke na, fo mà pa nɔ niɲjaa na, Izirayɛli shiinbii ɲyɛ na yatɔɔgɔ dìshige kapaanre tasogoge kyaare kyàa mɛ, ɲaha na yɛ kuru cyage kapaanre tasogoge e Kile à Yakuba bwɔ̀n. ");
INSERT INTO spp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ɲyɛ tèni i *Yakuba à pa ɲùŋke yîrig'a wíi mà Ezawu ɲya u u u bêni ná nàmbaa ŋkwuu sicyɛɛre ke, ka u u u pyìibii táa Leya ná Arasɛli, ná báarapyicyeebii shuunniŋi shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Maa báarapyicyeebii yaha yyaha yyére ná pi pyìibil'e, maa Leya ná u pyìibii taha pire na. Maa nta a Arasɛli ná Yusufu yaha pi puni kàntugo. ");
INSERT INTO spp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ka u yabiliŋi si ntòro pi yyaha na, maa niŋkure sín sín fo tooyi baashuunni, mà jwo u ɲaar'a nɔ u yyahafooŋi Ezawu na ke. ");
INSERT INTO spp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ka Ezawu si fê a u ɲùŋɔ bɛ̂, maa u pur'a cû, maa u shɛ́ɛre. Ka pi mú shuunni si wá na myahii súu funntange na. ");
INSERT INTO spp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Tèni i Ezawu à ɲùŋke yîrig'a cyeebii ná pyìibii ɲya ke, ka u u jwo: «Nte sùpyire ti nte mu fye e ke, mpirefee pi yɛ?» Ka Yakuba si jwo: «Mii, u ɲyɛ mu bilinaŋi ke, Kile à ɲwɔ mii na, maa pyìibii mpiimu kan mii á ke, pire pi.» ");
INSERT INTO spp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ka báarapyicyeebii ná pi pyìibii si file maa niŋkure sín. ");
INSERT INTO spp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ka Leya ná u pyìibii mú si file, maa niŋkure sín. Kàntugo, ka Yusufu ná u nuŋi Arasɛli si file maa niŋkure sín. ");
INSERT INTO spp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Pi à kwɔ̀ ke, ka Ezawu si Yakuba yíbe: «Ná yatokuruŋke e mu à pa ke, ɲaha wogo ki yɛ?» Ka Yakuba si u ɲwɔ shwɔ: «Mii la ɲyɛ si ti kan na ɲùŋufooŋ'á bà mii kyaa si mpyi si ntáan u á mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ka Ezawu si jwo: «Mii cɔɔnŋi, yatɔɔrɔ niɲyahara na ɲyɛ mii á mà kwɔ̀, tɛ̀ɛn ná ma woore e.» ");
INSERT INTO spp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ka Yakuba si jwo: «Mii na mu ɲáare, kampyi yog'à kwɔ̀ mii ná mu shwɔhɔl'e, maa ŋge bùɲyɛŋi shwɔ. Mu mii bɛŋkann'à ɲwɔ mu à jwo Kile u à mii ɲùŋɔ bɛ̂. ");
INSERT INTO spp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mii na mu ɲáare maa ŋge bùɲyɛŋi shwɔ, ɲaha na yɛ Kile à jwó le mii á sèl'e, yaaga kuu ɲyɛ mii na mɛ.» Yakuba á pu jwo a waha amuni ke, ka Ezawu si nta a ɲɛɛ uru bùɲyɛŋi na. ");
INSERT INTO spp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Puru ɲwɔhɔ na, ka Ezawu si jwo: «Ɲyɛ wuu kuni lwɔ́, wuu a sì siɲcyan.» ");
INSERT INTO spp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ka Yakuba si jwo: «Mii ɲùŋufooŋi, nàŋkopyire karigil'à waha, mpàpyire mú na ɲyɛ mii á, nùnaare tà na ŋwɔre. Wuu aha ɲani pêe yi fànhe na, canŋa niŋkin kanna, yatɔɔre sí n-kwû. ");
INSERT INTO spp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Lire e, mii ɲùŋufooŋi, yaha ma bilinaŋi yyaha na. Mii sí raa ŋkɛ̀ɛge lùtaan na, yatɔɔre kàntugo ná nàŋkopyire e, fo zà nɔ na ɲùŋufooŋi yyére Seyiri kùluni i.» ");
INSERT INTO spp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ka Ezawu si jwo: «Lire tèni i, mii sí na sùpyire tà le ná mu i kuni i.» Ka Yakuba si jwo: «Mii ɲùŋufooŋi, ɲùŋɔ ɲyɛ lire na mɛ, mii kyaa ká jà a táan mu á mà kwɔ̀, lire kanni sí mii tìn.» ");
INSERT INTO spp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ɲyɛ kuru canŋke yabiliŋi, Ezawu à núr'a kàre Seyiri kùluni i. ");
INSERT INTO spp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ŋka Yakuba ɲyɛ a ɲɛn'a kàre Ezawu fye e mɛ, maa ŋkàre cyage kabɛr'e, maa baga faanra wani, maa kàcwɔgɔ yaa u yatɔɔr'á. Lire kurugo, pi à kuru cyage mɛge le Kacwɔgɔ. ");
INSERT INTO spp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakuba à fworo Mɛsopotami kìni i, ka u niɲcɛnŋɛ wuu si nɔ fo Sikɛmu kànhe e *Kana kìni i. Ka u u u vàanŋke bayi kwòro kànhe yyaha yyére. ");
INSERT INTO spp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Cyage e u mpyi a u vàanŋke bayi kwòro ke, u à pa kuru cyage shwɔ Kyamɔri shiinbil'á ná wyɛ́rɛfyinŋi darashii ŋkul'e. Kyamɔri u mpyi Sikɛmu tuŋi. ");
INSERT INTO spp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ka Yakuba si sáraga tawwûgo faanra wani, maa ku mɛge le Eli Ɛlohe *Izirayɛli. ");
INSERT INTO spp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ɲyɛ Leya mpyi a pùceebileni ndemu si *Yakuba á, ná li mɛge ɲyɛ Dina ke, canŋka lire pùceebilin'à kàr'a sà fworo kuru kànhe pùcyepyire tà na. ");
INSERT INTO spp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tèni i Kyivi kùlunifoo, Kyamɔri jyaŋi, Sikɛmu à Dina ɲya ke, ka u u u cyán a cû maa wwɔ̀ ná u e. Amuni, Sikɛmu à Dina ɲjini láha u na. ");
INSERT INTO spp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ɲyɛ lir'à pyi ke, ka Yakuba pworoŋi Dina kani si ŋɔɔmɔ para Sikɛmu yyahe e, ka u u wá na u fɔ̀ɔnŋi si u ta ndèŋɛ mpyi u cwo. ");
INSERT INTO spp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Li ɲyɛ a pa ɲwɔ mɛ, fo Sikɛmu à kàr'a sà yi jwo u tuŋi Amɔri á, na u Dina cya a kan ur'á, uru u pyi u cwo. ");
INSERT INTO spp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ɲyɛ ka Yakuba si mpa lógo na Sikɛmu à uru pworoŋi Dina ɲjini láha u na. Lir'à Yakuba jyaabii ta sige e ná yatɔɔre e, ka u u fyâha, u ɲyɛ a yaaga jwo mɛ, fo tèni i pi à pa yîri sige e ke. ");
INSERT INTO spp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ɲyɛ lire ɲwɔhɔ na, ka Kyamɔri ná u jyaŋi Sikɛmu si ŋkàre Yakuba yyére mà sà jwo ná u e. ");
INSERT INTO spp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Lir'à Yakuba jyaabii ta pi à pa mà yîri sige e, ka pi i puru jwumpe lógo, ka li i waha pi na sèl'e, ka pi lùgigii si yîri sèl'e, ɲaha na yɛ Sikɛmu à kyaa pyi, ndemu *Izirayɛli shiinbii na fún ke, u à wwɔ̀ ná pi cɔɔnŋi Dina e fànhe e, kapyii sí bà mɛ. ");
INSERT INTO spp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ka Kyamɔri si yi jwo Yakuba ná u jyaabil'á, na pi pworoŋi kyal'à táan uru jyaŋi Sikɛmu á, na ur'à pi ɲáare pi u kan u á u pyi u cwo. ");
INSERT INTO spp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Maa núr'a jwo pi á: «Yii wwoɲɛɛge le ná wuu e, yii sí raa yii pùceepyire kaan wuu á nàmbaga na, yii raa wuu wuubii leŋi mú. ");
INSERT INTO spp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Yii sí n-kwôro naha ná wuu e. Kìni sí n-yaha yii á, ndemu ká yii táan ke, yii a lire pyi. Yii kwôro naha, yii raa sì yii ɲyii cyeyi puni i, yii ɲìŋke kà shwɔ yiy'á.» ");
INSERT INTO spp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ka Sikɛmu mú si jwo Dina sìɲɛɛbii ná pi tuŋ'á: «Yii ɲɛɛ, yii i nde niŋkinŋi pyi na á sa! Yii aha yaaga maha yaaga ɲáare mii á, mii sí kuru kan yii á. ");
INSERT INTO spp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","L'aha yii táan, yii cikwɔnwyɛrɛŋi ɲyaha sèe sèl'e, mii sí uru kan yii á, li tɛgɛni li ɲyɛ, yii i pùcwoŋi kan mii á.» ");
INSERT INTO spp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ka Yakuba jyaabii si Sikɛmu ná u tuŋi Kyamɔri ɲwɔ shwɔ ná cwɔ̀ɔre e, pi ɲyɛ a ɲɛn'a tíi u á mɛ, ɲaha na yɛ Sikɛmu mpyi a pi sìɲɛɛŋi Dina ɲjini láha u na. ");
INSERT INTO spp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Maa yi jwo Sikɛmu á: «Mà wuu cɔɔnŋi kan nɔ̀ á, ŋgemu u ɲyɛ u ɲyɛ a *kwɔ̀n mɛ, lire na ɲyɛ kyaa wuu sì ɲɛɛ ndemu pyi mɛ. Kuru mú sí n-pyi silege wuu á. ");
INSERT INTO spp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ɲje yii à jwo ke, wuu sì ɲɛɛ yire e mɛ, fo yii aha mpyi wuu fiige. Lire ɲwɔhɔ ku ɲyɛ, yii pùnampyire pun'à yaa ti kwɔ̀n. ");
INSERT INTO spp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ɲyɛ yii aha ɲɛɛ lire e, lire tèni i wuu sí raa wuu pworibii kaan yii á, s'a yii wuubii lwúu mú. Wuu sí n-kwôro yii yyére, wuu puni sí n-pyi niŋkin. ");
INSERT INTO spp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ŋka yii aha mpyi yii ɲyɛ a ɲɛɛ wuu jwumpe na, maa yii pùnampyire kwɔ̀n mɛ, wuu sì wuu pworoŋi kan yii á mɛ, wuu mú sí n-kàre.» ");
INSERT INTO spp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ɲyɛ ka puru jwumpe si bɛ̂ Kyamɔri ná u jyaŋi Sikɛmu á. ");
INSERT INTO spp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ka Sikɛmu si lire kani cû ná sèl'e, ɲaha na yɛ Yakuba pworoŋi kyaa mpyi a táan u á. Pi pyɛnge shiinbii puni mpyi a cyɛge taha Sikɛmu na. ");
INSERT INTO spp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ka Kyamɔri ná u jyaŋi Sikɛmu si ŋkàre kànhe shiinbii piyetabeŋke e, maa sà jwo ná kànhe shiinbil'e, maa jwo: ");
INSERT INTO spp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Nte sùpyir'à pa ná funɲcɛnŋ'i wuu yyére, wuu pi yaha pi i n-tɛ̀ɛn wuu kìni i, pi raa ɲaare pi a sì pi ɲyii cyeyi puni i. Wuu kìn'à pêe, pi tatɛ̀ɛngɛ sì n-cya n-kànha mɛ. Wuu sí raa pi pworibii lèŋɛ, s'a wuu wuubii kaan pi á mú. ");
INSERT INTO spp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ŋka, wuu nàmbaabii puni niŋkin niŋkinŋi, kà mpyi pi ɲyɛ a kwɔ̀n, bà pi à li pyi mɛ, pi sì ɲɛɛ ntɛ̀ɛn ná wuu e, wuu u mpyi shin niŋkin mɛ. ");
INSERT INTO spp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Pi aha ntɛ̀ɛn wuu á, lire tèni i ke, pi yatɔɔre, ná pi cyeyaayi puni sì n-pyi wuu wuyo mà? Pi aha ɲjemu jwo ke, wuu ɲɛɛ yire e.» ");
INSERT INTO spp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Shin maha shin u à pa kànhe shiinbii piyetabeŋke e ke, pire pun'à ɲɛɛ Kyamɔri ná u jyaŋi Sikɛmu ɲwɔjwumpe na, ka kànhe nàmbaabii puni si ŋkwɔ̀n. ");
INSERT INTO spp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ɲyɛ pi kwɔnŋkwooni canmpyitanrawuuni na, mà pi yaha ná nɔɔyi i, li síŋi mpyi pi na mà jà a kàshi sûulo mɛ, ka Yakuba jyaabii pìi shuunni, Dina yyahawuubii, Simiyɔn ná Levi, si pi ŋwɔhɔgii lwɔ́ a kàr'a sà ɲcwo kànhe shiinbii na, maa nàmbaabii puni bò. ");
INSERT INTO spp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Maa Kyamɔri ná u jyaŋi Sikɛmu bò mú, maa pi cɔɔnŋi Dina yige Sikɛmu bage e mà kàre. ");
INSERT INTO spp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Lire kàntugo, ka pi ná Yakuba jyaabii sanmpii si mpa kwùubii yaayi niɲcɛnɲyi wwû pi na, maa kuru kànhe nàfuuŋi puni tugo, ɲaha na yɛ Sikɛmu mpyi a pi cɔɔnŋi ɲjini láha u na. ");
INSERT INTO spp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Yatɔɔre puni ti mpyi kànhe ná kɛriyi i ke, pi à tire puni lwɔ́, mu à jwo sikaabii ná mpàabii ná nìiyi ná dùfaanyi. ");
INSERT INTO spp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Maa kànhe nàfuuŋi puni ná pyìibii, ná cyeebii, ná yaaga maha yaaga ku mpyi kànhe e ke, maa yire puni lwɔ́. ");
INSERT INTO spp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Lire kàntugo, ka Yakuba si sêe maa jwo Simiyɔn ná *Levi á: «Yii à mii mɛge kɛ̀ɛge, maa mii la wwû *Kana shiinbii ná Perezi shiinbii ná kìni shiinbii sanmpii puni na. Mii shiinbii ɲyɛ a ɲyaha mɛ, pi sí n-wwɔ̀, si mpa mii ná na pyɛnge shiinbii puni bò. ");
INSERT INTO spp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ka Simiyɔn ná Levi si u ɲwɔ shwɔ: «Ɲaha na pi mú à wuu cɔɔnŋi pyi mu à jwo fworobacwo yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ɲyɛ canŋka Kile à jwo *Yakuba á: «Yîri, mà sà ntɛ̀ɛn Betɛli i. Mu aha nɔ wani, maa *sárayi tawwûgo faanra, mii, Kile á. Mii u à naye cyêe mu na, mu nivêŋi ma yyahawuŋi Ezawu yyaha na ke.» ");
INSERT INTO spp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ka Yakuba si yi jwo u pyɛngɛ shiinbii ná u fyèɲwɔhɔshiinbii pun'á: «Yii kacyanhigii puni yige yii shwɔhɔl'e. Mɛsopotami kìni yii à cyi ta. Yii yiye jyè a fíniŋɛ, yii vàanɲyi yabɛrɛ le bà yii kyaa si mpyi si ntáan Kile á mɛ. ");
INSERT INTO spp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ɲaha na yɛ wuu sí n-kàre Betɛli i, mii sí sárayi tawwûgo yaa Kile á wani, uru ŋgemu u à mii ɲaariyi lógo maa mii tɛ̀gɛ na kanhare tèrigil'e, maa ŋkwôro ná mii i na ɲaani i ke.» ");
INSERT INTO spp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ɲyɛ ka Yakuba shiinbii si pi kacyanhigii puni kan u á, ná pi sáraga fègempii. Ka Yakuba si wyige tùgo cibwɔhe kà ɲwɔh'i Sikɛmu taan maa yi le wani. ");
INSERT INTO spp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Lire kàntugo, ka pi i ŋkàre. Ka Kile si kuru cyage kànyi shiinbii fùguro sèl'e. Pi sùpya ɲyɛ a ɲɛn'a taha Yakuba shiinbii fye e, si kàshi *kwɔ̀n pi na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ɲyɛ Yakuba ná u fyèɲwɔhɔshiinbil'à kàre, mà sà nɔ Luzi i, kuru kànhe mɛge mú na ɲyɛ Betɛli, ku na ɲyɛ *Kana kìni i. ");
INSERT INTO spp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ka Yakuba si sárayi tawwûgo yaa wani, maa ku mɛge le *Eli Betɛli, ɲaha na yɛ Kile à uye cyêe uru na kuru cyage e tèni i uru mpyi na fî u yyahafooŋi yyaha na ke. ");
INSERT INTO spp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ɲyɛ lire tèni i, ceeŋi u mpyi a Erebeka byé ke, ur'à kwû. Ka pi i u tò Betɛli taan, cige kà ɲwɔh'i, kuru cige mɛge k'à pa le: «Mɛɛsuuni Cige». ");
INSERT INTO spp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ɲyɛ ka Kile si núr'a uye cyêe Yakuba na, maa jwó le u á, lir'à u ta u à yîri Mɛsopotami kìni i. ");
INSERT INTO spp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Maa jwo u á: «Mu mɛge ɲyɛ Yakuba, ŋka mu mɛge saha sì n-pyi Yakuba mɛ, ku sí n-pyi *Izirayɛli.» Lire pyiŋkanni na, Kile à Yakuba mɛge le Izirayɛli. ");
INSERT INTO spp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Maa núr'a jwo u á: «Mii u ɲyɛ Kile Siŋi Punifoo. Mii sí pyìi niɲyahamii kan mu á, si mu pyi sùpyishiŋi wà tulyaga, sùpyishi niɲyahawa ná saanlii sí n-fworo mu tùluge e. ");
INSERT INTO spp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kìni mii à kan Ibirayima ná Ishaka á ke, mii sí lire kìni kan mu ná ma tùlug'á.» ");
INSERT INTO spp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ɲyɛ Kile à yîri cyage e u à jwo ná Yakuba e ke. ");
INSERT INTO spp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ka Yakuba si kafaabwɔhɔ yyéeŋɛ kuru cyage e mà pyi funɲcwogoyaaga, maa *ɛrɛzɛn sinmpe pà pyi sáraga mà wu ku na, lire kàntugo maa sìnmpe pà wu ku na, maa ku pyi Kile wogo. ");
INSERT INTO spp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ɲyɛ cyage Kile à jwo ná Yakuba e ke, ka u u kuru mɛge le Betɛli. Bɛnzhama ziŋi ná Arasɛli kwùŋi kani ");
INSERT INTO spp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ɲyɛ ka Yakuba ná u shiinbii si mpa yîri Betɛli i na ŋkɛ̀ɛge Efirata kànhe kànmpanŋke na. Mà pi laage sanŋke yaha ku ɲyɛ a tɔɔn Efirata na mɛ, ka Arasɛli laani si yîri, ka u ziŋi si waha sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mà u yaha u u laani yà, tèni i pyàŋ'à pa li ɲwɔ cû na fwore ke, ka lashwoŋi si jwo u á: «Ma hà vyá mɛ, mu à pùnambilini labɛrɛ ta.» ");
INSERT INTO spp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ɲyɛ Arasɛli mpyi na kuro caa. Tèni i u múnaani mpyi na ŋko si fworo u e ke, ka u u pyàŋi mɛge le Bɛni Oni Ŋka kàntugo, tufooŋ'à pa pyàŋi mɛge le Bɛnzhama. ");
INSERT INTO spp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ɲyɛ kuru cyage e Arasɛli à kwû. Ka pi i u tò Efirata kànhe kuni na. Kuru kànhe mɛge k'à pa le Bɛtilehemu. ");
INSERT INTO spp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ka Yakuba si kafaabwɔhɔ yyéeŋɛ Arasɛli kwùunni ɲuŋ'i. Ali niɲjaa kuru kafaage na ɲyɛ wani na Arasɛli kwùunni cyêre. ");
INSERT INTO spp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ka *Yakuba si yîri wani mà kàre Migidali Edɛri wòrokulo kànmpanŋke na, maa u vàanŋke bayi kwòro wani, ");
INSERT INTO spp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mà Yakuba yaha kuru cyage e, Urubɛn à wwɔ̀ ná u nubileni Bila e. Yakuba à pa yire cè ke, ka li i waha u na sèl'e. *Yakuba pùnampyire na mpyi kɛ ná shuunni. ");
INSERT INTO spp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Mpii u cwoŋi Leya à si ke, pire pi ɲyɛ Urubɛn, jyafooŋi niɲcyiiŋi, ná Simiyɔn, ná Levi, ná *Zhuda, ná Isakari, ná Zabulɔn. ");
INSERT INTO spp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","U cwoŋi Arasɛli wuubii pi mpyi Yusufu ná Bɛnzhama ");
INSERT INTO spp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","U cwoŋi Arasɛli u báarapyicwoŋi Bila wuubii pi mpyi Dan ná Nɛfitali. ");
INSERT INTO spp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","U cwoŋi Leya u báarapyicwoŋi Zilipa wuubii pi mpyi Gadi ná Ashɛri. Pire pi ɲyɛ Yakuba jyaabii. Mɛsopotami kìni i pi à si. ");
INSERT INTO spp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ɲyɛ *Yakuba à kàr'a sà nɔ Mamire cyage e, Kiriyati Ariba kànhe taan, cyage e u tulyage Ibirayima mpyi ke, ná u tuŋi Ishaka mú sí ɲyɛ ke. Kuru kànhe ku ɲyɛ Eburɔn mú. ");
INSERT INTO spp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Ɲyɛ Ishaka à pa ŋkwû mà u shìŋi yaha yyee ŋkuu ná beecyɛɛre, ka u jyaabii Ezawu ná Yakuba si u tò. Ka u u sà bâra u tulyeyi na. U mpyi a lyɛ fo mà lyɛge la kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ezawu ná pi maha u yiri Edɔmu mú ke, u tùluge ku ɲyɛ ŋke. ");
INSERT INTO spp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezawu mpyi a u cyeebii lwɔ́ *Kana kìni pùcyaabii shwɔhɔl'e. U cwoŋi wà mɛge na mpyi Ada, Kyiti shinŋi Elɔn pworo u mpyi uru ŋge. Wà mɛge na mpyi Olibama, uru na mpyi Ana pworo, Ana yabiliŋi tuŋi u mpyi Zibeyɔn. Zibeyɔn na ɲyɛ Kyivi shin. ");
INSERT INTO spp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ezawu cwoŋi tanrawuŋi mɛge mpyi Basimati. Uru na mpyi Sumayila pworo, Nɛbayɔti cɔɔn u mpyi uru ŋge. ");
INSERT INTO spp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ezawu cwoŋi Ada u à Elifazi si. Ka u cwoŋi Basimati si Erewɛli si. ");
INSERT INTO spp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ka u cwoŋi Olibama si Yeshi ná Yalamu, ná Kora si. Ezawu pùnampyire ti mpyi tire, Kana kìni i t'à si. ");
INSERT INTO spp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ɲyɛ canŋka Ezawu à yîri ná u cyeebii ná u pyìibii ná u shiinbii sanmpii puni i, ná u yatɔɔre puni, ná yaaga maha yaaga u mpyi a ta Kana kìni i ke, maa ŋkàre kìni labɛr'e mà laaga tɔɔn u cɔɔnŋi *Yakuba na. ");
INSERT INTO spp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Pi cyeyaayi ɲyahaŋi kurugo pi mpyi sì n-jà ntɛ̀ɛn piye taan mɛ. Kuru cyage mpyi a cyɛ́rɛ pi yatɔɔre e. ");
INSERT INTO spp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Lire l'à pyi kaɲuŋɔ, ka Ezawu si ŋkàr'a sà ntɛ̀ɛn Seyiri ɲaɲyi i. Ezawu mɛge kà mú ku ɲyɛ Edɔmu. ");
INSERT INTO spp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ɲyɛ Ezawu u mpyi a tɛ̀ɛn Seyiri ɲaɲyi i ke, uru u ɲyɛ Edɔmu shiinbii tulyage. U tùluge ku ɲyɛ ŋke. ");
INSERT INTO spp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","U yabiliŋi jyaabii mɛyi yi ɲyɛ ɲje: Elifazi, u cwoŋi Ada jya u ɲyɛ ure, Rewɛli, u cwoŋi Basimati jya u ɲyɛ ure. ");
INSERT INTO spp_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazi yabiliŋi pyìibii pi ɲyɛ: Temani ná Omaru, ná Zefo, ná Gatamu, ná Kenazi. ");
INSERT INTO spp_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazi mpyi a bilicwoŋi ŋgemu lèŋɛ ná u mɛge ɲyɛ Timina ke, uru u à Amalɛki si. Pire pi ɲyɛ Ezawu cwoŋi Ada ɲampyire. ");
INSERT INTO spp_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ɲyɛ Ezawu jyaŋi Erewele jyaabii pi mpyi Nakyati, Yeraki, Shama ná Miza. Pire pi ɲyɛ Ezawu cwoŋi Basimati ɲampyire. ");
INSERT INTO spp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ezawu cwoŋi wà mɛge na mpyi Olibama, Ana pworo u mpyi u wi, u tulyage ku ɲyɛ Zibeyɔn. Pùnampyire u à si Ezawu á ke, tire ti ɲyɛ Yeshi, ná Yalamu ná Kora. ");
INSERT INTO spp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ɲyɛ tùluyi y'à fworo Ezawu e ke, yire yi ɲyɛ ɲje. U jyaŋi niɲcyiiŋi Elifazi u tùluyi yi ɲyɛ ɲje: Tɛmana shiinbii ná Omaru wuubii ná Zefo wuubii ná Kenazi wuubii, ");
INSERT INTO spp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ná Kora wuubii, ná Gatamu wuubii, ná Amalɛki wuubii. Pire puni pi à pyi Ezawu cwoŋi Ada u ɲampyire. ");
INSERT INTO spp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ezawu jyaŋi Erewele u tùluyi yi mpyi a tɛ̀ɛn Edɔmu kìni i ke, yire yi ɲyɛ ɲje: Nakyati shiinbii ná Yeraki wuubii ná Shama wuubii ná Miza wuubii. Ezawu cwoŋi Basimati ɲampyire ti ɲyɛ tire. ");
INSERT INTO spp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Tùluyi y'à fworo Ezawu ná u cwoŋi Olibama e ke, yire yi ɲyɛ ɲje: Yeshi shiinbii ná Yalamu wuubii ná Kora wuubii. Olibama sí na mpyi Ana pworo. ");
INSERT INTO spp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ɲyɛ yire tùluyi pun'à fworo Ezawu e, pire pi ɲyɛ Ɛdɔmu shiinbii. ");
INSERT INTO spp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ɲyɛ Ezawu ná u jyaabil'à sà sùpyire ntemu ta Edɔmu kìni i ke, pire pi mpyi Seyiri jyaabii. Seyiri sí mpyi Ɔri tùluge shin. Ɲyɛ tùluyi y'à fworo Seyiri i ke, yire yi ɲyɛ ɲje: Lotan shiinbii, ná Shobali wuubii, ná Zibeyɔn wuubii, ná Ana wuubii, ná Dishɔn wuubii, ná Ezɛri wuubii, ná Dishan wuubii. ");
INSERT INTO spp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Tùluyi y'á fworo Lotan e ke, yire yi ɲyɛ ɲje Ɔri shiinbii ná Ɛmanu wuubii. U cìnmpworocwoŋi mɛge na mpyi Timina. ");
INSERT INTO spp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Tùluyi y'à fworo Shobali i ke, yire yi ɲyɛ ɲje Alivan shiinbii ná Manakyati wuubii ná Ebali wuubii ná Shefo wuubii ná Onami wuubii. ");
INSERT INTO spp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeyɔn jyaabii pi mpyi: Aya, ná Ana. Uru Anaŋi u à kàr'a sà fworo síwage e lùbilibii pìi na, pire mpyi na lùfwuge yige, mà u ta u u u tuŋi Zibeyɔn dùfaanyi nâha. ");
INSERT INTO spp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana jyaŋi mɛge mpyi Dishɔn, u pworoŋi mɛge sí mpyi Olibama. ");
INSERT INTO spp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Tùluyi y'à fworo Dishɔn e ke, yire yi ɲyɛ ɲje Ɛmadan shiinbii, ná Esibɔn wuubii, ná Yitiran wuubii, ná Keran wuubii. ");
INSERT INTO spp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Tùluyi y'à fworo Ezɛri e ke, yire yi ɲyɛ ɲje: Bilan shiinbii, ná Zaavan wuubii, ná Akan wuubii. ");
INSERT INTO spp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Tùluyi y'à fworo Dishan e ke, yire yi ɲyɛ ɲje: Uzi shiinbii, ná Aran wuubii. ");
INSERT INTO spp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ɲùŋufeebii pi à fworo Ɔri tùluge e ke, pire pi ɲyɛ mpii: Lotan, ná Shobali, ná Zibeyɔn, ná Ana, ");
INSERT INTO spp_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ná Dishɔn, Ezɛri, ná Dishan. Pire pi à ɲùŋufente pyi Seyiri kìni i. ");
INSERT INTO spp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Saanbii pi à *saanre pyi Edɔmu kìni i, mà *Izirayɛli kìni ta li saha ŋkwɔ̀ a saanwa ta mɛ, pire mɛyi yi ɲyɛ ɲje: uru saanŋi ");
INSERT INTO spp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","niɲcyiiŋi u ɲyɛ Beyɔri jyaŋi Bela, u kànhe mɛge na mpyi Dinaba. ");
INSERT INTO spp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela à kwû ke, ka Yeraki jyaŋi Yobabu si ntɛ̀ɛn saanre tatɛ̀ɛnge e, Bozura kànha shin u mpyi ure. ");
INSERT INTO spp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu à pa ŋkwû ke, ka Kwushamu si ntɛ̀ɛn saanre tatɛ̀ɛnge e. Uru mpyi na yîri Temani shiinbii kìni i. ");
INSERT INTO spp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kwushamu à pa ŋkwû ke, ka Bedadi jyaŋi Kyadadi si ntɛ̀ɛn u tatɛ̀ɛnge e. Ur'à Madiyan shiinbii bò Mwabi kìni i. U kànhe mɛge na mpyi Aviti. ");
INSERT INTO spp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kyadadi à pa ŋkwû ke, ka Samula si ntɛ̀ɛn saanre e u tatɛ̀ɛnge e. Uru mpyi na yîri Masireka e. ");
INSERT INTO spp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula à pa ŋkwû ke, ka Shawuli si ntɛ̀ɛn saanre e u tatɛ̀ɛnge e. Uru mpyi na yîri Erebɔti kànhe e baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shawuli à pa ŋkwû ke, ka Akibori jyaŋi Bala Kyanani sí ntɛ̀ɛn saanre e u tatɛ̀ɛnge e. ");
INSERT INTO spp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ur'à pa ŋkwû ke, ka Kyadari si ntɛ̀ɛn saanre tatɛ̀ɛnge e. U kànhe mɛge na mpyi Pawu. U cwoŋi mɛge na mpyi Mahatabɛli. Mahatabɛli nuŋi u ɲyɛ Matirɛdi, Matirɛdi tuŋi u mpyi Mɛzahabu. ");
INSERT INTO spp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Ɲyɛ ɲùŋufeebii pi à fworo Ezawu pyìibil'e ke, pire mɛyi yi ɲyɛ ɲje: Timina, ná Aliva, ná Yekyɛti, ná Olibama, ná Ela, ná Pinɔ, ná Kenazi, ná Tɛmana, ná Mibizari, ná Magadiyɛli, ná Iramu. Pire pi à ɲùŋufente pyi Edɔmu kìni i. Pi puni mpyi a tɛ̀ɛn pi mɛgɛ kùligil'e. Ezawu u à pyi Edɔmu shiinbii tulyage. ");
INSERT INTO spp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ɲyɛ Yakuba á tɛ̀ɛn *Kana kìni i. U tuŋi Ishaka mú mpyi a tɛɛnlɛ pyi wani. ");
INSERT INTO spp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yakuba tùluge taɲjaaŋi u ɲyɛ ŋge.* Mà Yusufu yaha yyee kɛ ná baashuunni na, u ná u sìɲɛɛbii, Bila jyaabii ná Zilipa wuubii, mpyi maha mpàabii ná sikyaabii nâha siɲcyan. Yusufu mpyi maha mpaa pire kakuuyi yu pi tuŋi Yakuba á. ");
INSERT INTO spp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ɲyɛ Yusufu kyaa li mpyi a táan Yakuba á mà tòro u jyaabii sanmpii na, ɲaha na yɛ u niɲjyewuŋi u à Yusufu ta. Lire e, Yakuba mpyi a vàanntinmbwɔhɔ nisìnaŋa jwool'a kan u á. ");
INSERT INTO spp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yusufu yyahafeebil'à li ɲya na pi tuŋ'à u kyaa táan uy'á mà tòro pire na ke, ka Yusufu kyaa si ntíl'a pɛn pi á. Ali pi sàha mpyi na jwuɲcɛnmɛ yu ná u e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Canŋka, ka Yusufu si ŋɔɔgɔ ŋɔ́ɔ, maa kuru yyaha jwo u yyahafeebil'á, ka lire si là bâra pi shwɔ̀hɔŋi mpɛnŋi na. ");
INSERT INTO spp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","U à yi jwo pi á «Yii na ŋɔɔge lógo! ");
INSERT INTO spp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mii à ŋɔ́ɔ mà wuu ɲya kɛrɛge e, wuu u sùmaŋi kwùun, marii u pwu kàmpahii. Ka mii u kàmpaani là si mpa yîr'a yyére, ka yii wogigii si wá na ɲcwo na bûruli na yyéreli na mii wuuni kwûuli, mu à jwo cyi na mii wuuni pêre.» ");
INSERT INTO spp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ka u yyahawuubii si jwo «Lire tèni i, mu na sɔ̂nŋi si ntɛ̀ɛn wuu ɲùŋɔ na si mpyi wuu fànhafoo bɛ?» Ka pi i là bâra pi shwɔ̀hɔŋi mpɛnŋi na, u ŋɔɔge kurugo. ");
INSERT INTO spp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Lire kàntugo, Yusufu à núr'a ŋɔɔge kabɛrɛ ŋɔ́ɔ, maa kuru mú yyaha jwo u yyahafeebil'á. U à jwo «Mii à ŋɔɔge kabɛrɛ ŋɔ́ɔ sahaŋki, mii à canŋa ɲyiini, ná yiŋke, ná wɔrii kɛ ná niŋkin ɲya cyi à pa cyiye tîrige mii taan.» ");
INSERT INTO spp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Maa kuru ŋɔɔge yyaha jwo u tuŋi ɲyii na mú. Ka tufooŋi si yogo jwo u na, maa u pyi «Ɲaha ŋɔɔgɔ fiige mu à ŋɔ́ɔ amɛ yɛ? Lire tèni i ke, mu la ku ɲyɛ mii ná mu nuŋi ná mu sìɲɛɛbii, wuu puni s'a niŋkure sínni mu taan kɛ?» ");
INSERT INTO spp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ɲyɛ ka Yusufu ɲyipɛɛnni si jyè u yyahawuubil'e u ŋɔɔyi kurugo, ŋka u tuŋ'à puru jwumpe yaha uye funŋ'i, marii sɔ̂nŋi pu na. ");
INSERT INTO spp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ɲyɛ Yusufu yyahawuubil'à pa ŋkàre Sikɛmu kùluni i ná pi tuŋi yatɔɔre e zàa nâha. ");
INSERT INTO spp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Canŋka, Yusufu tuŋi Yakuba à u yyer'a tun, maa jwo u á «Mu yyahawuubil'à kàre ná yatɔɔre e Sikɛmu i, ta ma si ma tun pi yyére.» Ka Yusufu si u pyi «Ɔɔn.» ");
INSERT INTO spp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ka u u jwo «Sà wíi, kampyi mu yyahawuubii ná yatɔɔre wá cùuŋɔ, maa mpa ná yyaha wwû kur'e.» Ka Yusufu si yîri Eburɔn bafage e u tuŋi taan mà kàre Sikɛmu kùluni i. ");
INSERT INTO spp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ka nàŋi wà si sà bɛ̂ ná u e sige e u u ɲaare na u yyahawuubii caa, ka u u u yíbe «Ɲaha mu na ɲcaa yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ka u u jwo «Mii na na yyahawuubii caa. Taa pi maha yatɔɔre nâha ke? Na pwɔhɔ, maa pi saha cyêe na na.» ");
INSERT INTO spp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ka nàŋi si jwo «Pi à yîri naha, mii à lógo pi ɲwɔ na, na pire na ŋkɛ̀ɛge Dotan e.» Ka Yusufu si ŋkàre pi fye e mà sà pi ta wani kuru cyage e. ");
INSERT INTO spp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ka u yyahawuubii si u ɲya tatɔɔnge e u u ma, maa ɲwɔ li na, na pi u bò. ");
INSERT INTO spp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Maa jwo piye shwɔhɔl'e «Wuu ŋɔɔyifoo nimpaŋi u ŋge! ");
INSERT INTO spp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Yii a wá, wuu u bò a cyán wyikuuŋke k'e, wuu u sà yi jwo na sige yaage kà k'à u bò a kyà. Wuu fyâha, wuu raa wíi u ŋɔɔyi ká bú jà a pyi sèe.» ");
INSERT INTO spp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ɲyɛ pi puni niɲjyeŋi, Urubɛn à u cɛɛnbii jwumpe lógo ke, ka u la si mpyi si Yusufu shwɔ pi na, maa jwo «Wuu àha u bò mɛ! ");
INSERT INTO spp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Yii àha ɲɛɛ sùpya bò mɛ! Yii u wà ŋke wyige e, naha sige e, yii àha kapii pyi u na mɛ.» Urubɛn à puru jwo, ɲaha na yɛ u la mpyi si Yusufu yige pi kàntugo, si núru ná u e zà ŋkan pi tuŋ'á. ");
INSERT INTO spp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ɲyɛ Yusufu à pa nɔ pi na ke, ka pi i vàanntinmbwɔhe nisìnaŋke dìr'a wwû u na. ");
INSERT INTO spp_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Maa u ŋɔɔŋ'a cyán wyige e, lwɔhe mpyi k'e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Puru ɲwɔhɔ na, maa ntɛ̀ɛn na lyî. Mà pi yaha ɲjyìŋi na, ka pi i mpa ɲùɲyi yîrig'a wíi mà Sumayila tùluge cwɔhɔmpii pìi nimpamii ɲya ná ɲwɔ́hɔ kuruŋ'i mà yîri Galadi kùluni i, yire ɲwɔ́hɔɲyi mpyi a tugo sìnmpe nùgontaanwumpe ná làtikoloŋi na, na ŋkɛ̀ɛge *Misira kìni i. ");
INSERT INTO spp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tèni i Zhuda à pi ɲya ke, ka u u yi jwo u sìɲɛɛbil'á «Wuu aha wuu cɔɔnŋi bò maa li ŋwɔhɔ, ɲaha lire sí ɲwɔ wuu na yɛ? ");
INSERT INTO spp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Yii a wá, wuu u u pɛ́rɛ mpii cwɔhɔmpil'á. Wuu àha u bò mɛ. Ŋka wuu li cè a jwo wuu cɔɔnŋi wi, wuu wà wi.» Ka pi sanmpii si ɲɛɛ u jwumpe na. ");
INSERT INTO spp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ɲyɛ pire Sumayila tùluge cwɔhɔmpil'à nɔ wani ke, ka pi i Yusufu yige wyige e, mà pɛ́rɛ pi á wyɛ́rɛfyinŋi darashii beɲjaaga na. Ka pi i ŋkàre ná u e Misira kìni i. ");
INSERT INTO spp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ɲyɛ lire kàntugo, Urubɛn à núr'a pa wyige ɲwɔge na, na uru sí Yusufu yige. U à nɔ wani ke, ka u u fô Yusufu i wyige e. Ka u nàvunŋɔ wuŋi si u vàanntinŋke cû na ɲcwuun. ");
INSERT INTO spp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Maa ŋkàre u cɛɛnbii cyage e, maa yi jwo pi á «Ei! Pyàŋi sàha wá bɛ̀ɛnŋke e mà de! Di mii sí nde kani pyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ka pi i Yusufu vàanntinmbwɔhe lwɔ́, maa sikapeni là bò, maa ku le kuru sìshange e. ");
INSERT INTO spp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Puru ɲwɔhɔ na, maa kuru vàanntinŋke tùugo pi tuŋ'á maa yi jwo u á «Wuu à ŋke vàanntinŋke ta sige e, ku wíi, kampyi mu jyaŋi woge ki.» ");
INSERT INTO spp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ka *Yakuba si ku wíi mà ku ta u jyaŋi Yusufu woge ki. Maa jwo «Ei! mii jyaŋi vàanntinŋke ku ɲyɛ ŋke! Sige yaage kà k'à u cû maa u sulugo sulugo amɛ.» ");
INSERT INTO spp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ka nàvunŋke si Yakuba pyi u u u vàanntinŋke cwuun, maa kwùŋi vàanɲyi le, marii mɛɛ súu u jyaŋi kwùŋi na, canmpyaa niɲyahagii funŋ'i. ");
INSERT INTO spp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ka u jyaabii ná u pworibii puni si mpa si u fɔ̀ɔnŋɔ, ŋka u la ɲyɛ a mpyi wà si uru fɔ̀ɔnŋɔ mɛ. U mpyi na ŋko «Mii sí n-kwôro mɛɛsuuni na fo sí n-kwû si ŋkàre kwùu kànha na, na jyaŋi fye e.» Maa ŋkwôro mɛɛsuuni na. ");
INSERT INTO spp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ɲyɛ pire cwɔhɔmpil'à nɔ Misira kìni i ke, ka pi i Yusufu pɛ́rɛ Potifara á. Uru u mpyi Misira kìni saanŋi Farɔn sòrolashiibii ɲùŋufooŋi. ");
INSERT INTO spp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ɲyɛ ɲcyii karigii puni kàntugo na, *Zhuda à yîri u sìɲɛɛbii taan mà sà ntɛ̀ɛn Adulamu kànhe shinŋi wà yyére; uru mɛge na mpyi Kyira. ");
INSERT INTO spp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Mà u yaha wani kuru cyage e, ka u u ɲyii yige *Kana kìni pùcwoŋi wà kurugo maa uru lèŋɛ nàmbaga na, uru pùcwoŋi mɛge na mpyi Shuwa. ");
INSERT INTO spp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ka u u laa lwɔ́ maa si pùnambile, ka Zhuda si li mɛgɛ le Ɛri. ");
INSERT INTO spp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ka u u núr'a yyére sahaŋki maa si pùnambile, maa lire mɛgɛ le Ona. ");
INSERT INTO spp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Lire kàntugo, ka u u núr'a yyére, maa Ona tahare si pùnambile maa lire mɛgɛ le Shela, lir'à Zhuda ta u à tɛ̀ɛn Kezibi kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ɲyɛ Zhuda jyaŋi niɲcyiiŋi Ɛri à pa nɔ cipɛɛre na ke, ka u u ceewe kan u á, uru ceeŋi mɛge mpyi Tamari. ");
INSERT INTO spp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ŋka Ɛri mpyi shinpi Kafooŋi Kile ɲyii na. Lire kurugo, u à u múnaani wwû u e, u ɲyɛ a jà a shì ta mɛ. ");
INSERT INTO spp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ka Zhuda si yi jwo Ɛri cɔɔnŋi Ona á: «Ma yyahafooŋi cwoŋi lèŋɛ zàbanngara na, bà mu si mpyi si pyìi si u na, mu yyahawuŋi sì mpyi ná tùluge e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ŋka Ona mpyi a cè na uru ká pyà ta u na, kuru tùluge sì n-pyi uru wogo mɛ, lire e tère o tère u à wwɔ̀ ná u e ke, ka u u li pyi, bà u si mpyi u àha pyà ta u na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ɲyɛ bà u à pyi u ɲyɛ a ɲɛɛ si pyìi ta u na mɛ, ka lire si mpɛn Kafooŋi Kile e, ka u u u múnaani wwû u e, uru mú ɲyɛ a jà a shì ta mɛ. ");
INSERT INTO spp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ka Zhuda si yi jwo u napworoŋi Tamari á: «Ta sì ma tupyɛnge e, maa ntɛ̀ɛn wani leŋkwucwɔgɔre e nɔ̀ baa, fo mii jyaŋi sanŋi Shela ká lyɛ a nɔ cipɛɛrɛ na. Zhuda à yire jwo, ɲaha na yɛ u mpyi na fyáge Shela kà ŋkwɔ̀ ŋkwû u yyahawuubii fiige mɛ, ka Tamari si ŋkàr'a sà ntɛ̀ɛn u tuŋi pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ɲyɛ canmpyal'à tòro ke, ka Zhuda cwoŋi si ŋkwû, uru na mpyi Shuwa pworo. U à u cwoŋi kwùŋi yamɛɛni sú a kwɔ̀, ka u funŋke si ɲíŋɛ tèni ndemu i ke, ka u ná u cevooŋi Kyira, Adulamu shinŋi si ŋkàre Tima e u mpàabii shire takwɔ̀nge e. ");
INSERT INTO spp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mà pi yaha pi sàha ŋkwɔ̀ a kuni lwɔ́ mɛ, ka wà si sà yire yyaha jwo Tamari á na u natuŋi wá na ŋko raa ŋkɛ̀ɛge Tima e, u mpàabii shire takwɔ̀nge e. ");
INSERT INTO spp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tèni i Tamari à yire lógo ke, ka u u u leŋkwucwɔgɔre vàanɲyi wwûl'a yaha, maa vàanŋke kà tɛ̀g'a u ɲùŋke tò, maa uye sanŋi puni tò mú, maa ŋkàr'a sà ntɛ̀ɛn Enayimu kànhe tajyìɲwɔge na, Tima kànhe kuni mpyi a tòro kuru kànhe funŋke e. U à nɔ wani ke, maa uye pyi mu à jwo fworobacwo. Ɲyɛ Tamari à lire pyi, ɲaha na yɛ Shela á pa lyɛ a nɔ cipɛɛrɛ na, ŋka Zhuda ɲyɛ a u pyi u a uru lèŋɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Ɲyɛ Zhuda niŋkàriŋ'à sà nɔ wani, maa u ɲya ke, ka u u wá na sɔ̂nŋi na fworobacwoŋi wà u ɲyɛ u wi, ɲaha na yɛ u mpyi a yyahe tò ná vàanŋ'i, u mpyi a cè na uru napworoŋi wi mɛ. Ka u u file u na, maa u pyi: «Ceewe, na pwɔhɔ, mu kyaa na naha mii na» ka Tamari si u natuŋi pyi: «Mii aha ɲɛɛ mu na, ɲaha mu sí n-kan mii á yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ka u natuŋi si jwo: «Mu aha ɲɛɛ, mii sí sika kan mu á.» Ka u napworoŋi si jwo: «Mu à mii ɲya mii à ɲɛɛ mu na, mu sí ma cyeyaage kà kan mii á, mà jwo sikaŋi u nɔ mii na ke.» ");
INSERT INTO spp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ka Zhuda si jwo: «Na cyeyaage ŋkire mii sí n-kan mu á yɛ?» Ka ceeŋi si u ɲwɔ shwɔ: «Mu mɛge tafyeŋ'à sémɛ yaage ŋkemu na ke, ná ku mɛɛre, ná kàbiini li nde mu cye e ke. Ka Zhuda si yire puni kan u napworoŋ'á, maa sà wwɔ̀ ná u e, ka u u laa lwɔ́. ");
INSERT INTO spp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Lire kàntugo, ka napworoŋi si yîri kuru cyage e maa ŋkàre u tupyɛnge e. Vàanɲyi yi mpyi u na ke, maa yire wwûl'a yaha, maa núr'a u leŋkwucwɔgɔre vàanɲyi lwɔ́ a le sahaŋki. ");
INSERT INTO spp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ɲyɛ lire ɲwɔhɔ na, ka Zhuda si uru sikaŋi kan u cevooŋi, Adulamu shinŋ'á, u sà ŋkan ceeŋ'á, u u uru cyeyaayi shwɔ, u à ma. Ŋka uru ɲyɛ a sà ceeŋi cya a ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Maa kuru cyage shiinbii yíbe: «Fworobaacwoŋi u mpyi naha ke, taa u ɲyɛ ke? U mpyi naha kuni ɲwɔge na.» Ka pi i u pyi: «Fworobaacwo ɲyɛ a têl'a pyi naha mà ɲya mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ka u u núr'a kàre Zhuda yyére, maa yi jwo u á: «Mii ɲyɛ a jà a u cya a ɲya mɛ. Mpii mii à ta wani kuru cyage e ke, pir'à jwo na fworobacwo sàha ntêl'a pyi wani mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ka Zhuda si jwo: «Ceeŋi u kwôro ná y'e kɛ! Wuu àha silege cya ɲjaha wuye ɲuŋ'i mɛ, mii nɔ̀, mii kɔn'à sika tùugo u á. Mu aha mpyi mu ɲyɛ a u ɲya mɛ, y'á kwɔ̀.» ");
INSERT INTO spp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ɲyɛ yiɲyi taanre tatòroge e, ka pi i sà yi jwo Zhuda á, na u napworoŋi Tamari, na u à pyi fworobacwo, na u laa wu bá u ɲyɛ. Ka Zhuda si jwo: «Yii u yige kànha kàntugo, yii i u bò, yii u súugo!» ");
INSERT INTO spp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tèni i pi à jwo na pi sí raa u cwôre ke, ka u u wà tun u natuŋ'á, maa jwo: «Nàŋi ŋgemu u à laani tɛ̀gɛ mii na ke, uru mɛge tafyeŋi ɲyɛ yaage ŋkemu na ke, ná ku mɛɛre ná u kàbiini yi ɲyɛ ɲje, yi kàanmucya kampyi mu à yifooŋi cè.» ");
INSERT INTO spp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ka Zhuda si ntɛ̀ɛn li taan na uru wuyo yi, maa jwo na ŋge ceeŋ'à tànga ta uru na. U à nde kani pyi uru na, ɲaha na yɛ uru ɲyɛ a ɲɛn'a u kan u jyaŋi, Shela á, zàbangara na mɛ. Ɲyɛ mà láha lire tèni na, Zhuda saha ɲyɛ a sínni ná u e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ceeŋi tèetîgin'à pa nɔ ke, ka li i nta ŋamii laa li ɲyɛ u á. ");
INSERT INTO spp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tèni i laan'à pa yîri ke, ka pyàŋi wà si cyɛge yige, ka lashwoŋi si ku cû, maa dizimɛɛ niɲyaa pwɔ ku na, maa jwo na ŋge u ɲyɛ niɲcyiiŋi. ");
INSERT INTO spp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ka pyàŋi si núr'a cyɛge lèŋɛ wani, ka shɔnwuŋi si fworo, ka lashwoŋi si jwo na u à kuni múgo, ka pi i uru mɛge le Perɛzi. ");
INSERT INTO spp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Lire kàntugo, ka u sanŋi si si, ná dizimɛɛni niɲyaani i cyɛge na, ka pi i uru mɛge le Yeraki. ");
INSERT INTO spp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ɲyɛ pire Sumayila tùluge cwɔhɔmpil'à kàre ná Yusufu i *Misira e, maa u pɛ́rɛ Potifara á, Farɔn sòrolashiibii ɲùŋufeembwɔh'á. ");
INSERT INTO spp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mà u yaha u ɲùŋufooŋi Potifara pyɛnge e, ka Kafooŋi Kile si ŋkwôro ná u e, maa u karigii puni ɲwɔ u á. ");
INSERT INTO spp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ka Potifara si mpa li ɲya na Kafooŋi Kile na ɲyɛ ná Yusufu i, u àha cye le kyaa maha kyal'e ke, u maha lire ɲwɔ u cye e. ");
INSERT INTO spp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ka Yusufu kyaa si ntáan u ɲùŋufooŋ'á fo u à u yaha u pyɛnge karigii ɲùŋɔ na, maa u cyeyaayi puni le u cye e. ");
INSERT INTO spp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Potifara à Yusufu yaha u pyɛnge karigii ná u cyeyaayi ɲùŋɔ na ke, ka Kafooŋi Kile si jwó le Potifara á, maa u pyɛnge ná u sige karigii puni ɲwɔ Yusufu cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Lire kurugo, ka Potifara si u karigii puni puni le Yusufu cye e. U sàha mpyi na bwùun u cyeyaage kà na sahaŋki mɛ, fo u yalyîre kanni. *Ɲyɛ Yusufu na mpyi nàɲjiiwe nisìnaŋa, u lempe mpyi a ɲwɔ sèe sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Canŋka, Yusufu ɲùŋufooŋi cwoŋ'à ɲyii yige Yusufu kurugo. Maa jwo «Síni ná mii i.» ");
INSERT INTO spp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ka u u ɲcyé maa jwo u á «Ɔnhɔ dɛ! Mii ɲùŋufooŋi sàha ɲyɛ na cye leni kyal'e pyɛnge e mɛ. U à u cyeyaayi puni le mii cye e. ");
INSERT INTO spp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mii ná uru mú à pyi niŋkin ŋke pyɛnge e. U ɲyɛ a mii sige kyaa na mɛ, fo muye niŋkin, ɲaha na yɛ mu u ɲyɛ u cwoŋi. Di mii sí ɲɛɛ lire kapiini fiige pyi n-jwo Kile na yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Canŋa maha canŋa, ceeŋi mpyi maha Yusufu yiri, ŋka Yusufu ɲyɛ a ɲɛn'a sínni ná u e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ɲyɛ canŋka Yusufu à jyè bage e na báaraŋi pyi, lir'à pyɛnge shiinbii puni ta pi à fworo. ");
INSERT INTO spp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ka ceeŋi si Yusufu cû vàanntinŋke na, maa jwo na u sínni ná ur'e. Ka Yusufu si uye dìr'a shwɔ u na, maa u vàanntinŋke fwôr'a yaha u cye e, maa fê a fworo ntàani na. ");
INSERT INTO spp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ɲyɛ ceeŋ'à Yusufu ɲya u à vàanntinŋke yaha u cye e, maa fworo ntàani na ke, ");
INSERT INTO spp_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ka u u u pyɛnge shiinbii puni yyere, maa yi jwo pi á «Yii wíi, ná *Eburu nàŋi i mii pooŋ'à pa ke, u à pa mpa wuu pyɛnge mɛge kɛ̀ɛge. U à pa mii fye e si ɲcwo mii na, ka mii i ŋkwúulo fànha na. ");
INSERT INTO spp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","U à mii ɲya mii i ŋkwúuli ke, ka u u u vàanntinŋke wwûl'a yaha mii cye e, maa fê a fworo ntàani na.» ");
INSERT INTO spp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ɲyɛ ka ceeŋi si ntɛ̀ɛn ná Yusufu vàanntinŋke e na u pooŋi sigili. ");
INSERT INTO spp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","U pooŋ'à pa ke, ka u u jwo «Wíi, Eburu bilinaŋ'i mu à pa ke, u la mpyi si mii ɲjini láha mii na. ");
INSERT INTO spp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ka mii i ŋkwúulo, ka u u u vàanntinŋke yaha mii cye e, maa fê a fworo ntàani na.» ");
INSERT INTO spp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ɲyɛ ceeŋ'à yire jwo Yusufu na ke, ka u pooŋi lùuni si yîri sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ka u u Yusufu cû a le kàsuŋi i ná saanŋi kàsujyiibil'e. U à mɔ wani. ");
INSERT INTO spp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ŋka lire ná li wuuni mu i, Kafooŋi Kile à kwôro ná Yusufu i, maa ɲwɔ u na, ka Yusufu kyaa si ntáan kasubage ɲùŋufooŋ'á. ");
INSERT INTO spp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ka uru si Yusufu yaha kàsujyiibii puni ɲùŋɔ na, maa u pyi u a pi kàanmucaa. Ɲyɛ lire pyiŋkanni na, Yusufu mpyi na karigii puni yyaha cwɔɔnre kasubage e. ");
INSERT INTO spp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kasubage kàanmucyafooŋ'à pa cyeyi láha karigii puni na, maa cyi kan Yusufu u u mpyi, ɲaha na yɛ Kafooŋi mpyi ná u e, marii u karigii puni ɲwɔge. ");
INSERT INTO spp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ɲyɛ ɲcyii karigii kàntugo, *Misira saanŋi Farɔn yabyaare kanfeebii ɲùŋufooŋi ná bwúurufwoobii ɲùŋufooŋ'à kyaa pyi, ndemu lemɛ p'à pi Farɔn ɲyii na ke. ");
INSERT INTO spp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ka u lùuni si yîri pire ɲùŋufeebii mú shuunniŋi taan. ");
INSERT INTO spp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Maa jwo na pi pi cû a le kàsuŋi i. Kuru kasubage na mpyi sòrolashiibii ɲùŋufembwɔhe pyɛnge e, Yusufu mpyi kàsuŋi ŋgemu i ke. ");
INSERT INTO spp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sòrolashiibii ɲùŋufeembwɔh'à pi lèŋɛ ná Yusufu i, maa u pyi u a pi kàanmucaa. Yusufu u mpyi na pi karigii puni cwɔɔnre. Pi à tère pyi wani kasubage e. ");
INSERT INTO spp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Canŋka, mà pi yaha kasubage e, yabyaare kanfeebii ɲùŋufooŋi ná bwúurufwɔɔbii ɲùŋufooŋ'à ŋɔɔyɔ ŋɔ́ɔ numpilage ninuge e. Pi shin maha shin ná u wogo, wà ná wà wogo ɲwɔhɔ ɲyɛ niŋkin mɛ. ");
INSERT INTO spp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ɲyɛ ɲyɛsɔɔge na, Yusufu à pa pi kàanmucya ke, ka u u pi yyahayi ɲya y'à tanha. ");
INSERT INTO spp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ka u u pi yíbe: «Ɲaha na yii yyahay'à tanha niɲjaa yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ka pi i jwo: «Wuu à ŋɔɔyɔ ŋɔ́ɔ, sùpya sí nàha naha ŋgemu u sí n-jà yi ɲwɔhe cè ɲjwo wuu á mɛ.» Ka Yusufu si jwo «Yii ɲyɛ a cè na Kile u sí n-jà ŋɔɔyi ɲwɔhe jwo mà? Yii yii ŋɔɔyi jwo na á.» ");
INSERT INTO spp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ka saanŋi yabyaare kanfeebii ɲùŋufooŋi si u u ŋɔɔge jwo Yusufu á na «Mii ŋɔɔge e, *ɛrɛzɛn cige mii à ɲya naye yyaha na, ");
INSERT INTO spp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ŋkéɲyi taanre na mpyi ku na, ku mpyi a fyɛ̀n, maa se, yasɛɛre s'à nɔ. ");
INSERT INTO spp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Farɔn lùbyaceni mpyi mii cye e, ka mii i ɛrɛzɛnŋi nimpiŋi lwɔ́ a yûg'a le lùbyaceni i mà kan u á.» ");
INSERT INTO spp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ka Yusufu si jwo u á «Mu ŋɔɔge ɲwɔhe ku ɲyɛ ŋke: cige ŋkéɲyi taanreŋi ɲwɔhe ku ɲyɛ canmpyaa taanre. ");
INSERT INTO spp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Canmpyaa taanreŋi ká fûnŋɔ, Farɔn sí mu yige kàsuŋi i si mu pêe si mu le ma báaraŋi niɲjyeŋi i. Mu sí raa yabyare kaan u á bà mu mpyi a fyânha na li pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ŋka mu aha fɛ̀rɛmɛ ta tèni ndemu i ke, ma hà funŋɔ wwɔ̀ na na mɛ, maa ɲwɔ na na, maa na kyaa jwo Farɔn á, bà u si mpyi si mii yige kàsuŋi i mɛ. ");
INSERT INTO spp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ɲaha kurugo yɛ pi à mii cû fànhe e mà yîri *Eburu shiinbii kìni i mà kàre naha. Pi à mii le kàsuŋi i mà li ta mii ɲyɛ a kapii pyi mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ɲyɛ bwúurufwoobii ɲùŋufooŋ'à li ɲya na Yusufu à u shɛ̀rɛfooŋi ŋɔɔge ɲwɔhe jwo a táan u na ke, ka uru mú si jwo «Mii ŋɔɔge e, sàhagii taanre na mpyi mii a tugo ɲùŋke e, bwúuru na mpyi cyi e. ");
INSERT INTO spp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Sàhani li mpyi cyi puni nìɲyiŋi na ke, Farɔn ɲyii bwúuruŋi shiŋi puni na mpyi lire e. Ɲyɛ ka saɲcyɛɛnre tà si mpaa uru bwúuruŋi jòore sàhani i mii ɲuŋ'i.» ");
INSERT INTO spp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ka Yusufu si jwo «Mu ŋɔɔge ɲwɔhe ku ɲyɛ ŋke. Sàhagii taanreŋi mú na ɲyɛ canmpyaa taanre. ");
INSERT INTO spp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Canmpyaagii taanre ká fûnŋɔ, Farɔn sí mu yige kàsuŋi i si mu dùrugo cige k'e si mu bò. Saɲcyɛɛnre sí n-pa a mu jòore.» ");
INSERT INTO spp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ɲyɛ canmpyaagii taanreŋ'à fûnŋɔ ke, ka canmpyitanrewuuni si mpa bɛ̂ Farɔn canzege canmbilini na. Kuru canŋke katáanni mɛge na, u à ɲjyì niɲyahawa shwɔhɔ kìni shinbwoobii puni mɛɛ na. Maa yabyare kanfeebii ɲùŋufooŋi ná bwúurufwɔɔbii ɲùŋufooŋi yige kàsuŋi i, u kìni shiinbwobii puni ɲyii na. ");
INSERT INTO spp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Maa yabyare yaafeebii ɲùŋufooŋi le u báaraŋi niɲjyeŋi i, ka uru si wá na yabyaare kaan u á. ");
INSERT INTO spp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ŋka u à bwúuruŋi yaafeebii ɲùŋufooŋi pwɔ cige e, mà tàanna ná Yusufu jwumpe e. ");
INSERT INTO spp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Lire ná li wuuni mú i, mà lwɔ́ yabyaare kanfeebii ɲùŋufooŋ'à fworo kàsuŋi i ke, u ɲyɛ a sɔ̂nŋ'a nɔ Yusufu na mɛ, u à funŋɔ wwɔ̀ u na punɔ punɔ. ");
INSERT INTO spp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ɲyɛ yyee shuunni kàntugo, ka Farɔn yabiliŋi si ŋɔɔge kà ŋɔ́ɔ. U à ŋɔ́ɔ mà uye ɲya Nili baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Maa nìiye nimbwoyo baashuunni ɲya, yi lem'à ɲwɔ sèl'e, y'à fworo lwɔhe e, mà paa lyî baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Maa nìiye niɲcwɔgɔrɔ baashuunni ɲya, yi lem'à pi sèl'e, yire mú à fworo lwɔhe e, nìiyi niɲcɛnɲyi baashuunniŋi kàntugo, mà pa yyére yi taan baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ka nìiɲyi niɲcwɔgɔre baashuunniŋi si nìiɲyi nimbwoyi baashuunniŋi kyà. Puru ɲwɔhɔ na, ka Farɔn si ɲɛ̀ ŋɔɔmpe na. ");
INSERT INTO spp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ɲyɛ lire ɲwɔhe na, ka u u núr'a ŋɔɔge kabɛrɛ ŋɔ́ɔ. Maa sùmaɲcahaya baashuunni ɲya y'à fworo sùmacige niŋkin na, yi puni pyàŋi mpyi a bùuŋɔ, u lemɛ mú s'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Lire kàntugo, ka sùmaɲcahayi yabɛrɛ baashuunni si fworo kuru sùmacige ninuge na, yire sùmaɲcahayi mpyi a cyɛ́rɛ cyɛ́rɛ, síwage kafɛɛge mpyi a yi waha. ");
INSERT INTO spp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ɲyɛ sùmaɲcahayi y'á waha waha ke, yir'à sùmaɲcahayi niɲcɛnɲyi lyî. Puru ɲwɔhɔ na, ka Farɔn si ɲɛ̀ mà li ta na ŋɔɔgɔ ur'à ŋɔ́ɔ. ");
INSERT INTO spp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ɲyɛ kuru ɲyɛ̀sɔɔge na, ka Farɔn funŋke si mpɛn, ka u u *Misira kìni céefeebii ná ɲcèfeebii puni yyere, maa u ŋɔɔyi yyahe jwo pi á, ŋka pi wà ɲyɛ a jà a ku kà yyaha cè a jwo u á mɛ. ");
INSERT INTO spp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Lire tèni i ke, ka Farɔn yabyaare kanfeebii ɲùŋufooŋi si puru jwumpe lógo, maa jwo u á «Ŋgurugoŋi u à mii ta ke, mii funŋ'à cwo uru na niɲjaa.» ");
INSERT INTO spp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Maa jwo «Canŋka, mu, Farɔn lùuni mpyi a yîri ma kìni shiinbwoobii pìi taan. Mu mpyi a mii ná bwúurufwoobii ɲùŋufooŋi cû lire tèni i, mà le sòrolashiibii ɲùŋufembwɔhe kàsuŋi i. ");
INSERT INTO spp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Mà wuu yaha wani, wuu mú shuunniŋ'à ŋɔɔyɔ ŋɔ́ɔ numpilage ninuge e, yi ŋɔɔyi ɲyɛ a pyi niŋkin mɛ, yi ɲwɔhe mú ɲyɛ a pyi niŋkin mɛ. ");
INSERT INTO spp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","*Eburu nàɲjiiŋi wà u mpyi ná wuu e kàsuŋi i, sòrolashiibii ɲùŋufooŋi báarapyiŋi wà u mpyi a fyânha a pyi u wi. Ur'á wuu à wuu ŋɔɔyi yyaha jwo, ka u u yi ɲwɔhe cè a jwo u á. ");
INSERT INTO spp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Pyiŋkanni na u à yi ɲwɔhe jwo wuu á ke, y'à tòro li jwuŋkanni na. Mii à le na báaraŋi niɲjyeŋi i, ka bwúurufwoobii ɲùŋufooŋi si mpwɔ cige e.» ");
INSERT INTO spp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ɲyɛ Farɔn à puru lógo ke, ka u u wà tun u sà Yusufu yyere. Ka pi i fyâl'a sà u yige kàsuŋi i, maa u ɲùŋke ná u mahajwoŋi kûlu, maa vàanɲyi yabɛrɛ le u na, maa ŋkàre ná u e Farɔn yyére. ");
INSERT INTO spp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Yusufu à nɔ wani ke, ka Farɔn si jwo u á «Mii à ŋɔɔgɔ ŋɔ́ɔ, sùpya sí ɲyɛ a jà a ku ɲwɔhe cè a jwo mii á mɛ. Mii s'à lógo na ŋɔɔgɔ ká jwo mu á, mu maha jà a ku ɲwɔhe jwo.» ");
INSERT INTO spp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ka Yusufu si jwo saanŋ'á «Sèeŋi na, Kile yabiliŋi u sí mu funŋke ɲíŋɛ si mu ŋɔɔge ɲwɔhe jwo mu á.» ");
INSERT INTO spp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ka Farɔn si u pyi «Mii ŋɔɔge e, mii à naye ɲya Nili baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Maa nìiye nimbwɔyo baashuunni ɲya, yi lem'à ɲwɔ sèl'e, y'à fworo lwɔhe e mà pa a lyî baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Lire ɲwɔhe na maa nìiye niɲcwɔgɔrɔ baashuunni ɲya, yi lem'à pi sèl'e, y'à fworo lwɔhe e. Misira kìni puni i, mii ɲyɛ a yi nìiyi lempe piŋkanni fiige ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ɲyɛ ka nìiyi niɲcɔgɔyi si mpa nimbwoyi kyà. ");
INSERT INTO spp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ŋka lire ná li wuuni mú i, l'à pyi mu à jwo yaaga ɲyɛ yi funɲyi i mɛ. Ka yi i ŋkwôro bà yi mpyi mɛ. Lire kàntugo, mii à ɲɛ̀. ");
INSERT INTO spp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ɲyɛ mii à núr'a ŋɔɔge kabɛrɛ ŋɔ́ɔ. Kur'e, mii à sùmaɲcahaya baashuunni ɲya y'à fworo sùmacige niŋkin na, yi puni pyàŋ'à bùuŋɔ, u lemɛ mú s'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Sùmaɲcahayi yabɛrɛ baashuunn'à fworo yire kàntugo, yi mpyi a cyɛ́rɛ cyɛ́rɛ, maa waha síwage kafɛɛge cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ɲyɛ sùmaɲcahayi y'à cyɛ́rɛ ke, ka yire si niɲcɛnɲyi jò. Ɲyɛ ɲje ŋɔɔyi mii à jwo na céefeebil'á, ŋka pi wà ɲyɛ a jà a yi ɲwɔhe cè a jwo mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ka Yusufu si yi jwo Farɔn á «Ŋɔɔyi shuunniŋi mu à ŋɔ́ɔ ke, yi ɲyɛ niŋkin, nde Kile sí n-pa n-pyi ke, lire u à cyêe mu na. ");
INSERT INTO spp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nìiyi niɲcɛnɲyi baashuunniŋi ɲyɛ yyee baashuunni, sùmaɲcahayi niɲcɛnɲyi baashuunniŋi mú ɲyɛ yyee baashuunni. Yire puni na ɲyɛ ŋɔɔgɔ niŋkin. ");
INSERT INTO spp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nìiyi niɲcwɔgɔyi baashuunniŋi (y'à fworo ɲje sanɲyi kàntugo ke), yire ɲyɛ yyee baashuunni katege. Sùmaɲcahayi baashuunniŋi y'à cyɛ́rɛ, kafɛɛge s'à yi waha ke, yire mú na ɲyɛ yyee baashuunni katege. ");
INSERT INTO spp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Bà mii à yi jwo mu Farɔn á numɛ mɛ, nde Kile sí n-pa n-pyi ke, lire u à cyêe mu na. ");
INSERT INTO spp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ɲyɛ yyeegii baashuunniŋi cyi na ma ke, sùmaŋi sí ɲwɔ Misira kìni i sèe sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ŋka yyeegii cyibɛrii baashuunni sí n-pa kàntugo, cyire ɲyɛ katege, li sí n-pyi fo sùpyire funŋɔ sí n-wwɔ̀ yyeegii baashuunniŋi sùmataani na. Katege sí kìni puni kɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Katege piŋkanni sí n-sìi sùpyire funŋɔ pyi ku wwɔ̀ yyeegii nintòrogii sùmatani na. ");
INSERT INTO spp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kampyi mu à ɲje ŋɔɔyi ŋɔ́ɔŋkanagii shuunni ŋɔ́ɔ, lir'à li cyêe sèeŋi na, Kile kayaana li, li sì mɔ si mpyi mɛ. ");
INSERT INTO spp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ɲyɛ numɛ, mu à yaa mu u wà cya, ŋgemu ɲyɛ yákilifoo maa mpyi kacèŋɛ ke, ma yaha Misira kìni puni ɲuŋɔ na. ");
INSERT INTO spp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Maa sùpyire tà tìŋɛ kìni ɲuŋɔ na ná u e, bà li si mpyi sùmaŋi ŋgemu ká nta ke, uru u táa tatayi kaŋkuro, si taage niŋkin yaha ŋkère na, Misira kìni puni yyeegii niɲcɛnŋkii baashuunniŋi funŋke e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Sùmaŋi ká ɲwɔ yyeegii ɲcyiimu i ke, pi i wà bégel'a yaha mu, Farɔn mɛge na, kànyi puni na, pi raa u kàanmucaa. ");
INSERT INTO spp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yyeegii baashuunniŋi katege ká nɔ Misira kìni na tèni ndemu i ke, sùmaŋi u à bégel'a yaha ke, uru u sí n-tɛ̀gɛ raa sùpyire ɲwɔ caa. Lire ká mpyi, katege saha sì kìni kɛ̀ɛge mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ɲyɛ ɲje Yusufu à jwo ke, yir'à táan Farɔn ná u kìni yyaha yyére shiinbil'á. ");
INSERT INTO spp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ka Farɔn si jwo pi á «Sùpyaŋi ŋgi u sí n-jà n-ta, Kile à yákili niɲcɛnɲɛ le ŋgemu i ŋge nàŋi fiige yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Maa jwo Yusufu á «Bà Kile à ɲcyii karigii cyêe mu na mɛ, sùpya saha sì nta ŋgemu u ɲyɛ yákilifoo, maa mpyi kacèŋɛ mà mu kwɔ̀ mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Maa núr'a jwo: «Mii sí mu tìŋɛ na pyɛnge ná na kìni shiinbii ɲùŋɔ na. Mu aha ndemu jwo ke, lire pi sí n-pyi. Mii kanni u sí n-pyi mu ɲùŋɔ na *saanre tatɛ̀ɛnge kurugo. ");
INSERT INTO spp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mii à *Misira kìni puni ɲùŋufente le mu cye e niɲjaa.» ");
INSERT INTO spp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","U à puru jwo a kwɔ̀ ke, maa u yabiliŋi fànhe kampefegeŋi wwû mà le Yusufu kampeeni na, maa vàanɲcɛnɲyi le u na, maa sɛɛn ŋkèɲcuro le u na. ");
INSERT INTO spp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Maa Yusufu dùrugo shɔngɔ wòtoro ɲuŋ'i mà taha u yabiliŋi wuŋi fye e. Sùpyire tà na mpyi pi yyaha yyére na ŋkwúuli, marii yu «Yabwɔhe, yabwɔhe na ma!» Ɲyɛ lire pyiŋkanni na, Farɔn à Misira kìni ɲùŋufente puni kan Yusufu á. ");
INSERT INTO spp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Maa jwo Yusufu á sahaŋki «Mii u ɲyɛ saanŋi Farɔn. Ŋka sùpya saha ɲyɛ a yaa u kyaa pyi Misira kìni puni funŋke e na mu bà u à kuni kan urufol'á mà yɛ.» ");
INSERT INTO spp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Maa Yusufu mɛge le Zafinati Panɛkya. Maa ceewe kan u á, ceeŋi mɛge na mpyi Asanati. Ceeŋi tuŋi mɛge mpyi Potifira, uru u mpyi Ɔni kànhe sáragawwuŋi. Ka Yusufu si ntɛ̀ɛn lire pyiŋkanni na Misira kìni puni ɲùŋɔ na. ");
INSERT INTO spp_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","U à báaraŋi sìi Misira saanŋi Farɔn á, mà u shìŋi ta yyee beɲjaaga ná kɛ. Puru ɲwɔhɔ na, u à yîri Farɔn taan, mà sà Misira kìni puni ɲaara. ");
INSERT INTO spp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ɲyɛ yyee baashuunni funŋ'i, sùmaŋ'à ɲwɔ sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ka Yusufu si cyire yyeegii baashuunniŋi sùmaŋi wà bégele mà yaha Misira kìni cyeyi puni i. U à kànha maha kànha wu bégele kuru kànhe e uye kanna na. ");
INSERT INTO spp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Sùmaŋi u à bínni ke, uru mpyi a ɲyaha mu à jwo suumpe lwɔhe ɲwɔge nticyɛnŋi fiige. Pi mpyi a li ɲwɔ cû na u peseli, ŋka pi à pa li ɲwɔ yyéeŋɛ, ɲaha na yɛ u pɛ̀rɛge mpyi na sì n-jà n-cè mɛ. ");
INSERT INTO spp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ɲyɛ mà jwo katege tèni li nɔ ke, Yusufu mpyi a pùnampyire shuunni si u cwoŋi Asanati na, Ɔni kànhe sáragawwuŋi Potifira pworoŋi u mpyi u wi. ");
INSERT INTO spp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ka Yusufu si u jyaŋi niɲcyiiŋi mɛgɛ le Manase, ɲaha na yɛ Kile à uru funŋɔ wwɔ̀ u yyefuge karigii puni na, ɲcyii cyi à u ta mà u yaha u tupyɛnge e ke ");
INSERT INTO spp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Maa u jyaŋi shɔnwuŋi mɛge le Efirayimu, ɲaha na yɛ ur'à kyaala kìni ndemu i ke, Kile à pyìibii kan ur'á lire kìni i. ");
INSERT INTO spp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ɲyɛ yyeegii baashuunniŋi sùmaŋi u mpyi a ɲwɔ Misira kìni i ke, cyir'à pa ŋkwɔ̀. ");
INSERT INTO spp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Lire kàntugo, bà Yusufu mpyi a yi jwo mɛ, ka yyeegii baashuunniŋi katege si sìi. Katege mpyi kìrigii sanŋkii puni i, ŋka yalyîre na mpyi Misira kìni cyeyi puni i. ");
INSERT INTO spp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ɲyɛ katege mú a pa nɔ Misira kìni puni na tèni ndemu i ke, sùpyir'à paa ŋkwúuli Farɔn taan na u yalyîre kan pir'á. Ka u u pi pyi «Yii a sì Yusufu yyére, u àha ɲjemu jwo yii á ke, yii i lire pyi.» ");
INSERT INTO spp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kuru kateg'à cwo Misira kìni puni na. Ka Yusufu si sùmaŋi tayahayi ɲwɔ múgo, marii u pɛ́rɛli Misira shiinbil'á, ɲaha na yɛ katege mpyi a pêe sèl'e kìni i. ");
INSERT INTO spp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mà bâra lire na, katege mpyi a jyè diɲyɛŋi puni i. Ka sùpyire si wá na yîri kìrigii puni i, na ma na sùmaŋi shuu Yusufu á, Misira kìni i. ");
INSERT INTO spp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ka *Yakuba si mpa lógo na sùmaŋi na ntaa *Misira e. Ka u u yi jwo u jyaabil'á «Ɲaha kurugo yii à tɛ̀ɛn naha na yiye wíi yɛ? ");
INSERT INTO spp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mii à lógo na sùmaŋi na ntaa Misira e. Yii a sì, yii sà wà shwɔ wani wuu á, bà wuu si mpyi si shwɔ katege na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ka Yusufu yyahawuubii kɛŋi si yîr'a kàr'a sà sùmaŋi wà shwɔ Misira e. ");
INSERT INTO spp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ŋka Yakuba ɲyɛ a Yusufu cɔɔnŋi Bɛnzhama yaha u à kàre ná pi e mɛ, u mpyi na fyáge na kapii kà ŋkwɔ̀ u ta wani mɛ. ");
INSERT INTO spp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ɲyɛ Yakuba jyaabii kanni bà pi mpyi na sùmaŋi shuu mɛ, ɲaha na yɛ katege mpyi a jyè *Kana kìni puni i. ");
INSERT INTO spp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Lir'à ta Yusufu u ɲyɛ Misira kìni puni ɲuŋɔ na, uru u mpyi na sùmaŋi pɛ́rɛli sùpyir'á. Yusufu yyahawuubil'à pa nɔ wani ke, ka pi i niŋkure sín, maa yyahayi sôgo u taan. ");
INSERT INTO spp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu à u yyahawuubii ɲya tèni ndemu i ke, maa ntíl'a pi cè, ŋka u à uye yaha mu à jwo u ɲyɛ a pi cè mɛ. Maa yu ná pi e, mu à jwo u lùun'à yîri pi taan. Maa jwo «Taa yii à yîri ke?» Ka pi i u pyi «Wuu à yîri Kana kìni i mpa sùma shwɔ naha.» ");
INSERT INTO spp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufu mɛ́ɛ mpyi a u yyahawuubii cè ke, ŋka pire mpyi a u cè mɛ. ");
INSERT INTO spp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ŋɔɔyi Yusufu mpyi a ŋɔ́ɔ u yyahawuubii kyaa na ke, ka u funŋke si ɲcwo yire na. Maa jwo pi á «Yii à pa mpa kìni ŋwɔhɔ ŋgíi, cyeyi yii sí n-jà n-tùn l'e ke, si yire cè.» ");
INSERT INTO spp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ka u yyahawuubii si jwo «Wuu ɲùŋufooŋi, lire bà mɛ! Mu bilibil'à pa mpa sùma shwɔ kanna. ");
INSERT INTO spp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wuu puni ɲyɛ tu niŋkin pyìi. Sèeŋi wuu na yu. Wuu ɲyɛ a pa mpa kìni ŋwɔhɔ ŋgíi mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ka Yusufu si núr'a jwo «Sèe bà mɛ! Yii à pa kìni tawíige e, cyeyi yii sí n-jà n-tùn ke, si yire cè.» ");
INSERT INTO spp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ka pi i jwo «Wuu na ɲyɛ mu bilii. Wuu na mpyi sìɲɛɛ kɛ ná shuunni, wuu puni na ɲyɛ tu niŋkin pyìi, wuu à tɛ̀ɛn Kana kìni i. Wuu puni kàntugo wuŋi ɲyɛ ná wuu tuŋi i pyɛngɛ, wà niŋkin à pînni.» ");
INSERT INTO spp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ka Yusufu si jwo «Ɲje mii à jwo ke, yire yi ɲyɛ sèeŋi. Yii à pa mpa wuu kìni ŋwɔhɔ ŋgíi kanna. ");
INSERT INTO spp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mii sí yii kàanmucya, ná yii puni nimbileni ɲyɛ a pa mɛ, mii à kâa Farɔn mɛge na, yii sì n-yîri naha mɛ. ");
INSERT INTO spp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Yii wà niŋkin u núru u a sì yii cɔɔnŋi fye e, u raa ma ná u e. Yii sanmpii sí n-kwôro naha kàsuŋi i. Mii sí yii jwumpe kàanmucya si ɲcè kampyi sèe yii à jwo. Yii aha mpyi yii ɲyɛ a lire pyi mɛ, lire tèni i ke, mii à kâa Farɔn mɛge na, na yii à pa kìni ŋwɔh'a wíi.» ");
INSERT INTO spp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yusufu à yire jwo ke, maa pi le kàsuŋi i canmpyaa taanre. ");
INSERT INTO spp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Canntanrawoge, ka u u jwo pi á «Numɛ, nde mii sí n-jwo yii á ke, yii aha lire pyi, lire tèni i ke, mii saha sì yaage pyi yii na mɛ, ɲaha na yɛ mii na fyáge Kile na. ");
INSERT INTO spp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","L'aha nta yii na sèeŋi yu, lire tèni i ke, yii wà niŋkin u tɛ̀ɛn naha kàsuŋi i, yii sanmpii s'a sì ná sùmaŋi i, yii sà ŋkan yii pyɛngɛ shiinbii katege wuubil'á. ");
INSERT INTO spp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Puru ɲwɔhɔ na, yii ninúrubii yii raa ma ná yii cɔɔnŋi nimbileni i naha, lire ká mpyi, mii sí n-cè na yii à sèe jwo. Lire e, mii sì yii bò mɛ.» Ka u yyahawuubii si ntɛ̀ɛn lire taan. ");
INSERT INTO spp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ka pi i wá na yu piy'á «Sèeŋi na, wuu à kapii pyi wuu cɔɔnŋi Yusufu na, u kyaaga wuŋ'à wuu ɲáare na wuu uru ɲùɲaare ta, ŋka wuu ɲyɛ a ɲɛɛ mɛ. Lire kurugo, ŋke yyefuge pun'à wuu ta niɲjaa.» ");
INSERT INTO spp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ka Urubɛn si jwumpe lwɔ́ maa jwo «Mii ná yi jwo yii á na wuu àha kapii pyi ŋge pyàŋi na mà? Yii ɲyɛ a ɲɛn'a mii jwumpe lógo mɛ. Ku ke numɛ, kuru kyaage fwooni Kile na ntùni wuu na amɛ.» ");
INSERT INTO spp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ɲyɛ pi ɲyɛ a mpyi a cè na Yusufu na pire jwumpe núru mɛ, ɲaha na yɛ wà u mpyi na Yusufu jwumpe kɛ̂ɛnŋi pi á. ");
INSERT INTO spp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu à puru jwumpe lógo pi ɲwɔ na ke, ka u u yîri pi taan mà sà mɛɛ sú. Maa núr'a pa jwo ná pi e. Lire kàntugo, maa Simiyɔn cû pi ɲyii na, mà le kàsuŋi i. ");
INSERT INTO spp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Maa u báarapyiibii pyi na pi pi bɔrigii ɲî sùmaŋi na, pi i pi puni sùmaŋi lwɔɔre le pi bɔrigil'e, pi i pi kuni ɲjyìŋi kan pi á. Ka báarapyiibii si li pyi amuni. ");
INSERT INTO spp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ka pi i pi bɔrigii dùrugo dùfaanyi ɲuŋ'i na ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Pi à sà nɔ cyage k'e, lir'à numpilage ta k'à wwɔ̀, ka pi i shwɔ̀n wani. Ka pi wà niŋkin si u boni ɲwɔ múgo si yalyîre kan u dùfaanŋk'á, maa u sùmaŋi lwɔɔre ta wani. ");
INSERT INTO spp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Maa jwo pi sanmpil'á «Ei! pi naha mii sùmaŋi lwɔɔre núruŋ'a le mii boni i, u we.» Pi sanmpil'à lire ɲya ke, ka li i mpɛn pi e. Ka pi i fyá fo na ɲcyɛ̂ɛnni, maa jwo «Ɲaha Kile à pyi wuu na amɛ yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ɲyɛ pi à pa nɔ pi tuŋi Yakuba yyére, Kana kìni i ke, nde l'à pi ta ke, ka pi i lire puni jwo u á, maa jwo ");
INSERT INTO spp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Misira ɲùŋufooŋi ɲyɛ a jwo ná wuu e tìcɛnmɛ na mɛ. U à jwo na wuu à kàr'a sà pire kìni ŋwɔhɔ ŋgíi kanna. ");
INSERT INTO spp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wuu à yi jwo na sèeshiin pi ɲyɛ wuu, na wuu ɲyɛ a pa mpa kìni ŋwɔhɔ ŋgíi mɛ. ");
INSERT INTO spp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Wuu à yi jwo u á na wuu na mpyi sìɲɛɛ kɛ ná shuunni wuu tuŋi na, wà niŋkin sàha ɲyɛ mɛ, wuu puni kàntugo wuŋi na ɲyɛ ná wuu tuŋi i, Kana kìni i. ");
INSERT INTO spp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ɲyɛ ka u u jwo «Kani li sí mii pyi mii u dá na yii na ɲyɛ sèeshiin ke, lire li nde. Yii yii sìɲɛɛŋi wà niŋkin yaha naha, yii sanmpii sí sùmaŋi lwɔ́ a sà ŋkan yii pyɛnge shiinbii katege wuubil'á. ");
INSERT INTO spp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Yii aha ŋkàre, yii núr'a pa ná yii puni kàntugo wuŋi i naha mii yyére. Lire e, mii sí n-cè na yii ɲyɛ a pa mpa kìni ŋwɔhɔ ŋgíi mɛ, na yii na ɲyɛ sèeshiin. Lire ká mpyi, mii sí yii sìɲɛɛŋi yaha. Lire kàntugo, yii sí n-jà raa sì kìni cyeyi puni i s'a pɛrɛmpe ná zhwoŋi pyi yiy'á.» ");
INSERT INTO spp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ɲyɛ tèni i pi à pa sùmaŋi wwû pi bɔrigil'e ke, ka pi puni si pi wyɛ́rɛŋi ta wani. Pi à u ɲya ke, ka pi ná pi tuŋi si fyá sèe sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ka pi tuŋi Yakuba si jwo «Ei! yii sí mii pyi mii u pɔ̂ɔn ná pyìibil'e dɛ! Yusufu sàha ɲyɛ mɛ, Simiyɔn mú sàha ɲyɛ mɛ, ka yii la si núr'a pyi si Bɛnzhama shwɔ mii na la? Ɲaha na yii à tire tugure puni tɛ̀gɛ mii ɲuŋ'i yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ka Urubɛn si jwo tufooŋ'á «Mii aha mpyi mii ɲyɛ a núr'a pa ná Bɛnzhama e mu yyére mɛ, maa na jyaabii mú shuunni bò! Bɛnzhama yaha na cye e, l'aha fworo cyaga maha cyag'e, mii sí núru n-pa ná u e mu yyére.» ");
INSERT INTO spp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ka Yakuba si jwo «Ɔnhɔ, mii jyaŋi sì n-sìi n-kàre ná yii e Misira e mɛ, ɲaha na yɛ u ná ŋge u ɲyɛ jirini na ke, ur'à kwû, maa uye niŋkin yaha. Kyaa ká bú u kùshewuŋi ta, yii sí mii niɲjyeŋkwoŋi nàvunŋɔ wuŋi yaha mii u kàre kwùu kànha na.» ");
INSERT INTO spp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ɲyɛ katege mpyi na nâare *Kana kìni i. ");
INSERT INTO spp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","*Yakuba jyaabii mpyi a pa ná sùmaŋi ŋgemu i, mà yîri *Misira e ke, uru mpyi a kwɔ̀, ka Yakuba si yi jwo pi á «Yii núru, yii a sì Misira e, yii sà sùmaŋi wà cya.» ");
INSERT INTO spp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ka u jyaŋi *Zhuda si u pyi «Misira nàŋ'à yi jwo a waha, na wuu aha mpyi wuu ɲyɛ a núr'a shà ná wuu cɔɔnŋi i mɛ, na uru sì wuu cumɔ lemɛ ɲwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Lire e, kampyi mu sí ɲɛɛ wuu cɔɔnŋi yaha u kàre ná wuu e, wuu sí sà sùmaŋi shwɔ mpa mu á. ");
INSERT INTO spp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ŋka mu aha mpyi mu sì ɲɛɛ u yaha u kàre ná wuu e mɛ, wuu sì mɛ, ɲaha na yɛ nàŋ'à jwo na wuu cɔɔnŋi ká mpyi u ɲyɛ ná wuu e mɛ, na uru si wuu cumɔ lemɛ pi.» ");
INSERT INTO spp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ka tufooŋi Yakuba si jwo «Yii à kapii pyi mii na dɛ! Ɲaha na yii à yi jwo ŋge nàŋ'á na cɔɔnfooŋi wabɛrɛ na ɲyɛ yii á yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ka u pyìibii si u pyi «Nàŋi u à wuu yyahayi fwɔhɔrɔ ná yibiyi i, wuu ná wuu pyɛngɛ shiinbii kyaa na, u à jwo «Yii tuŋi na ɲyɛ shì na la? Sìɲɛɛŋi wabɛrɛ na ɲyɛ yii á la?» Ka wuu mú si u ɲwɔ shwɔ: «Ɔɔn.» Di wuu mpyi na sí n-jà n-cè, na u sí n-jwo, wuu a ma ná wuu cɔɔnŋi i yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ka Zhuda si jwo «Baba, pyàŋi yaha na cye e, u raa sì ná wuu e, wuu yaha wuu yîri, wuu a sì, wuu sà yalyîre cya bà katege si mpyi k'àha wuu puni bò naha mɛ. ");
INSERT INTO spp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mii sí n-yyére ná pyàŋi ɲùŋɔ karigil'e. Kyaa ká u ta, maa na yíbe. Mii aha mpyi mii ɲyɛ a núr'a pa ná u e mu yyére mɛ, lire tèni i, mii ɲcɛ̂ɛgɛ wuu u sí n-pyi tèrigii puni i mu yyahe taan. ");
INSERT INTO spp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kàmpyi wuu mpyi a cwùunnɔ mɛ, numɛ mpyi a wuu ta wuu à tooyi shuunni pyi mà kwɔ̀.» ");
INSERT INTO spp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ka pi tuŋi Yakuba si jwo «Ɲyɛ ná yii ŋkàriŋi sí naha pyi fànha, lire tèni i, nde yii sí n-pyi. Yii wuu kìni yacɛnyi yà le yii bɔrigil'e, yii a sì yii sà ŋkan Misira nàŋ'á: wyɛɛre tà ná nùguntanga yaayi yà ná sɛɛre tà, ná cire yasɛɛre tà mu à jwo pisitasi ná amandi woore tà. ");
INSERT INTO spp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Yii yii wyɛ́rɛŋi fiigii shuunni lwɔ́, lire e wyɛ́rɛŋi pi à le yii bɔrigil'e ke, yii núru ná u e, pi sí n-jà n-ta pi à wurugo. ");
INSERT INTO spp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ɲyɛ yii yii cɔɔnŋi lwɔ́, yii i núru yii a sì Misira nàŋi yyére. ");
INSERT INTO spp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kile Siŋi Punifoo u yii ɲùɲaare le nàŋi i, bà u si mpyi si yii sìɲɛɛŋi sanŋi ná Bɛnzhama yaha pi a ma mɛ. Ŋka kampyi mii à yaa mii u pɔ̂ɔn ná pyìibil'e, lire tèni i sí n-pɔ̂ɔn pi e.» ");
INSERT INTO spp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ɲyɛ Yusufu yyahafeebil'à uru bùɲyɛŋi lwɔ́, wyɛ́rɛŋi i pi mpyi a yaa pi à ŋkɛ̀ɛge ke, maa uru fiigii shuunni lwɔ́. Ka pi ná Bɛnzhama si yîri mà kàre Yusufu yyére Misira e. ");
INSERT INTO spp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tèni i Yusufu à Bɛnzhama ɲya ná pi e ke, ka u u jwo u báarapyiibii ɲùŋufooŋ'á «Mpii shiinbii lèŋɛ pyɛnge e, maa yatɔɔge kà bò a shwɔhɔ, pi sí canŋalyige lyî ná mii yabiliŋi i niɲjaa.» ");
INSERT INTO spp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ka nàŋi si lire pyi. Maa ŋkàre ná pi e Yusufu pyɛnge e. ");
INSERT INTO spp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yusufu yyahafeebil'à pi ɲya pi à kàre ná pire e Yusufu pyɛnge e ke, ka pi i fyá, maa jwo «Wyɛ́rɛŋi u à kwôro toɲcyiige e wuu bɔrigil'e ke, mu sí n-ta lire kurugo, pi à pa ná wuu e naha ŋke cyage e. sí wwɔ̀ wuu na ɲcû mpyi pi bilii, si wuu dùfaanyi ta mú.» ");
INSERT INTO spp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tire fyagare funŋke e, pi à file Yusufu báarapyiibii ɲùŋufooŋi na, pyɛnge ɲwɔge na, maa jwo ná u e. ");
INSERT INTO spp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Pi a jwo: «Yàkeŋi yaha, wuu ɲùŋufooŋi, wuu à têl'a pa sùma shwɔ naha. ");
INSERT INTO spp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Wuu sùmaŋi shwɔɲcyiini na, wuu à núr'a nɔ wuu tashwɔnge e ke, wuu à bɔrigii múgo mà sùmaŋi lwɔɔre ta wani, uye ɲwɔ na. Wuu ɲyɛ a wyɛ́rɛŋi lefooŋi cè wuu bɔrigil'e mɛ. Numɛ wuu à núru ná uru wyɛ́rɛŋi i wuye cye e mpa ŋkan. Wuu à pa ná wyɛ́rɛŋi wabɛr'e mpa sùmaŋi wà shwɔ.» ");
INSERT INTO spp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ka báarapyiibii ɲùŋufooŋi si jwo pi á «Tapege ɲyɛ mɛ, yii àha lire tɛ̀gɛ yiye funŋɔ pɛn mɛ. Yii Kileŋi, yii tuŋi u Kileŋi, uru u à uru wyɛ́rɛŋi yaha yii bɔrigil'e. Ná lire bà mɛ, sùmaŋi lwɔɔre yii à kan ke, ur'à nɔ mii na.» Nàŋ'à puru jwo a kwɔ̀ ke, maa mpa ná Simiyɔn e mà pa ŋkan pi á. ");
INSERT INTO spp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Maa pi lèŋɛ Yusufu bage e, maa lwɔhɔ kan pi à pi tooyi jyé, maa yalyîre kan pi dùfaanɲy'á. ");
INSERT INTO spp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Pi à pa ná bùɲyɛŋi yaayi ɲjemu i Yusufu mɛɛ na ke, ka pi i yire bégel'a yaha, na u sigili canvwuge na. Yi mpyi a jwo pi á na pi ná Yusufu sí n-pa lyî siɲcyan u pyɛnge e. ");
INSERT INTO spp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu à pa tèni ndemu i ke, ka pi i yire yaayi kan u á, maa niŋkure sín u taan, maa fwù kan u á sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ka Yusufu si pi yíbe «Yii à cùuŋɔ la? Yii tuŋi kyaa yii à jwo na u à lyɛ ke, u à cùuŋɔ la? U saha na ɲyɛ ɲyii na la?» ");
INSERT INTO spp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ka pi i u pyi «Mu bilinaŋi u ɲyɛ wuu tuŋi ke, u ɲyɛ ɲyii na, u à cùuŋɔ.» Ka pi i núr'a niŋkure sín Yusufu taan, maa u shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tèni i Yusufu à u jiriŋwɔrɔɲɛɛŋi Bɛnzhama ɲya ke, maa jwo «Yii cɔɔnŋi kyaa yii à jwo ke, uru u ɲyɛ ŋge la?» Ka pi i jwo «Uru wi.» Ka Yusufu si jwo Bɛnzhama á «Mii jyaŋi, Kile u jwó le ma á.» ");
INSERT INTO spp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ka Bɛnzhama ɲyaŋi funntange si Yusufu ta fo mà mɛɛsuu tîrige u funŋ'i. Ka u u fyâl'a jyè u baashɔnge e, maa mɛɛ sú. ");
INSERT INTO spp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Puru ɲwɔhɔ na, u à u yyahe jyé, maa fworo u baashɔnge e. Mɛɛsuuni lage saha mpyi u na, ŋka u à jà a cû uye na. Maa jwo u báarapyiibil'á na pi a ma ná yalyîre e. ");
INSERT INTO spp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ka pi i Yusufu ɲjyìŋi wwû uye kanni na, maa u sìɲɛɛbii wuŋi wwû uye kanni na. Misira shiinbii pi mpyi ná pi e ke, maa pire wuŋi wwû uye kanni na, ɲaha na yɛ Misira shiinbii mpyi na ɲɛɛg'a lyî ná *Eburu shiinbil'e mɛ. Mà tàanna ná pi Kile kuni i, lire ɲyɛ a tíi mɛ. ");
INSERT INTO spp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ka pi i Yusufu sìɲɛɛbii tìŋɛ u yyaha na, lyɛga lyɛga, mà lwɔ́ niɲjyeŋi na mà kàre nimbileni na. Ka pi kàkyanhala wuubii si wá na piye wíi. ");
INSERT INTO spp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yalyîre ti mpyi Yusufu taan ke, ka u u tire tà kan pi á. Maa pi sanmpii nàzhanŋi fiigii kaŋkuro kan Bɛnzhama á. Ka pi i lyî maa bya, maa mùguro ná Yusufu i. ");
INSERT INTO spp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ɲyɛ puru ɲwɔhɔ na, Yusufu à yi jwo u báarapyiibii ɲùŋufooŋ'á «Mpii shiinbii bɔrigii ɲî ɲî sùmaŋi na, pi fànhe sí n-jà ŋgemu na ke, uru kan pi á. Maa pi puni wyɛ́rɛŋi taha taha sùmaŋi na pi bɔrigil'e. ");
INSERT INTO spp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Maa nta a mii wyɛ̀rɛfyiiŋi fùnɲcwokwuuni le pi puni nimbileni boni i, u wyɛ́rɛŋi ɲuŋ'i.» Ɲyɛ bà Yusufu à yi jwo mɛ, ka báarapyiibii ɲùŋufooŋi si li pyi amuni. ");
INSERT INTO spp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ɲyɛ̀g'à múgo ke, ka pi i kuni kan *Yakuba jyaabil'á. Ka pi i pi tugure taha pi dùfaanyi ɲuŋ'i mà kàre. ");
INSERT INTO spp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pi à fworo kànhe e ke, mà pi ta pi sàha ŋkwɔ̀ a laaga wwû mɛ, ka Yusufu si u báarapyiibii ɲùŋufooŋi yyere, maa yi jwo u á na u yîr'a taha pi fye e wahawaha, na u aha nɔ pi na, u u yi jwo pi á «Ɲaha na yii à kacɛnni fwooni tò ná kapiini i yɛ? ");
INSERT INTO spp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ta yii ɲyɛ a mii ɲùŋufooŋi fùnɲcwokwuuni lwɔ́ mɛ, ná nde e u maha cɛɛre pyi ke? Yii à kapii nimbwoo pyi amɛ dɛ!» ");
INSERT INTO spp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ɲyɛ báarapyiibii ɲùŋufooŋ'à pi kɔ̀r'a ta ke, maa yi jwo pi á amuni. ");
INSERT INTO spp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ka pi i u pyi «Wuu ɲùŋufooŋi, ɲaha na mu na puru jwumpe shiŋi yu yɛ? Kile u wuu shwɔ lire kani shiŋi na. ");
INSERT INTO spp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Wyɛ́rɛŋi wuu à ɲya wuu bɔrigil'e ke, wuu ɲyɛ a yîri ná u e *Kana kìni i mà pa ŋkan mu á mà? Di wuu sí n-pyi si wyɛ̀rɛfyin, lire ɲyɛ mɛ sɛɛn yu mu ɲùŋufooŋi bage e yɛ? ");
INSERT INTO spp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ɲyɛ nde fùnɲcwokwuuni ká ɲyɛ wuu shin maha shin ɲuŋ'i ke, yii urufoo bò, wuu sanmpii sí n-pyi yii bilii.» ");
INSERT INTO spp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ka báarapyiibii ɲùŋufooŋi si jwo «Ɲyɛ ɲje yii à jwo ke, mii à ɲɛɛ, ŋka fùnɲcwokwuuni ká nta shinŋi ŋgemu ɲuŋ'i ke, urufoo u sí n-pyi mii biliwe, yaaga sì n-pyi yii sanmpii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ka pi puni si ntíl'a pi bɔrigii tîrige, maa cyi múgo. ");
INSERT INTO spp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ka báarapyiibii ɲùŋufooŋi si wá na bɔrigii funɲyi wíi. Maa ku sìi pi puni niɲjyeŋi na, mà pa ŋkwɔ̀ nimbileni na. Ka fùnɲcwokwuuni si sà nta Bɛnzhama boni i. ");
INSERT INTO spp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","L'à pyi amuni ke, ka li i tatɛ̀ɛnge fô pi na fo pi na pi vàanntiɲyi cwuun. Maa núr'a pi tugure taha dùfaanyi na, maa núru kànhe e. ");
INSERT INTO spp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ka *Zhuda ná u sìɲɛɛbii si ŋkàre Yusufu pyɛnge e, mà sà u ta wani sahaŋki, maa niŋkure sín u taan maa u shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ka u u jwo pi á «Ɲaha kafiile yii à pyi amɛ yɛ? Yii ɲyɛ a cè na mii shiŋi maha kaŋwɔhɔni ɲaa mà?» ");
INSERT INTO spp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ka Zhuda si jwo «Wuu ɲùŋufooŋi, ɲaha wuu sí n-jwo bɛ? Jwumɔ sàha ɲyɛ wuu á mɛ, di wuu sí wuye shwɔ n-jwo nde kani na yɛ? Kile à wuu ɲwɔhɔ múgo wuu kapyiiŋkil'e. Numɛ, wuu mpii wuu à pyi wuu ɲùŋufooŋi bilii, wuu ná ŋge u boni i fùnɲcwokwuun'à ɲya ke.» ");
INSERT INTO spp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ka Yusufu si jwo: «Kile u na shwɔ nde kani shiŋi mpyiŋi na. Mii fùnɲcwokwuun'à ɲya ŋgemu u bor'e ke, uru kanni, u sí n-pyi mii biliwe. Yii sanmpii pi ke, yaaga ɲyɛ mii ná yii shwɔhɔl'e mɛ. Yii a sì yii tuŋi yyére.» ");
INSERT INTO spp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ka Zhuda si file Yusufu na, maa yi jwo u á: «Mii ɲùŋufooŋi, maye sanŋa yaha, maa ma bilinaŋi yaha u jwo ná mu i. Ma hà lùuni yîrige na taan mɛ. Sèeŋi na, mu ná saanŋi Farɔn tayîrige ɲyɛ niŋkin fànhe e. ");
INSERT INTO spp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mii ɲùŋufooŋi, wuu paɲcyiini naha, mu u ná wuu yíbe na wuu tuŋi saha na ɲyɛ wani la? Na cɔɔnfooŋi wabɛrɛ na ɲyɛ wuu á la? ");
INSERT INTO spp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ka wuu u mu pyi na wuu tuŋi na ɲyɛ wani, u à lyɛ, na wuu cɔɔnŋi wà na ɲyɛ wani mú, wuu tuŋ'à uru si, mà u ta u à lyɛ sèl'e mà kwɔ̀. Yyahafoo ná mpyi uru ŋge cɔɔnŋ'á mú, ŋka ur'à kwû, pi shuunniŋi mpyi jiriŋwɔrɔɲɛɛ. Ɲyɛ cɔɔnfooŋi kanni u ɲyɛ wani numɛ, u kyal'à táan wuu tuŋ'á sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mu à jwo na wuu a ma ná u e mu yyére, bà mu si mpyi si u ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ka wuu u mu pyi na pyàŋi sì n-jà n-yîri u tuŋi taan mɛ. Lire ká mpyi, tufooŋi sí n-kwû. ");
INSERT INTO spp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ka mu u jwo wuu á na, wuu cɔɔnŋi ká mpyi u ɲyɛ a pa mɛ, na mu saha sì wuu cumu lemɛ ɲwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tèni i wuu à núr'a kàre wuu tuŋi yyére ke, ka wuu u mu jwumpe niɲjwumpe taha u á. ");
INSERT INTO spp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Canŋke wuu tuŋ'à jwo na wuu núr'a pa sùmaŋi wà shwɔ ke, ");
INSERT INTO spp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","wuu à yi jwo u á, na wuu sì n-jà n-pa ná wuu cɔɔnŋi ɲyɛ ná wuu e mɛ, ɲaha na yɛ *Misira nàŋ'à jwo na, wuu cɔɔnŋi ká mpyi u ɲyɛ ná wuu e mɛ, uru sì wuu cumu lemɛ ɲwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mu bilinaŋi, wuu tuŋ'à jwo «Yii à cè na mii cwoŋi Arasɛli à pùnampyire shuunni si mii á, ");
INSERT INTO spp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","niŋkin à wil'a fô, mii na sɔ̂nŋi sige yaage kà ku si nta k'à uru cû. ");
INSERT INTO spp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Yii aha mpa ŋge lwɔ́ mú, yaaga ká u ta wani, yii sí mii niɲjyekwɔŋi yaha mii u kwû nàvunŋke e.» ");
INSERT INTO spp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ɲyɛ numɛ wuu aha núr'a kàre mu bilinaŋi, wuu tuŋi yyére, mà li ta pyàŋi u ɲyɛ u karigii puni ke, uru ɲyɛ ná wuu e mɛ, ");
INSERT INTO spp_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","nàvuŋke sí u niɲjyekwɔŋi bò. Lire tèni i, wuu pi ɲyɛ mu bilibii ke, wuu pi sí n-pyi lire ɲùŋke. ");
INSERT INTO spp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mii ɲùŋufooŋi, mii u à jwo na mii sí n-yyére ná pyàŋi ɲùŋɔ karigii puni i. Mii aha mpyi mii ɲyɛ a núru ná u e u tuŋi yyére mɛ, lire tèni i, mii ɲcɛ̀ɛgɛ wuu, u sí n-pyi tèrigii puni i u yyahe taan. ");
INSERT INTO spp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Lire kurugo, mii ɲùŋufooŋi, maye sanŋa yaha, maa na yaha si ŋkwôro naha pyàŋi cyaga, si mpyi mu biliwe, maa pyàŋi yaha u a sì ná u yyahafeebil'e pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Di mii sí n-kàre n-jwo na tuŋi yyére mà li ta pyàŋi ɲyɛ ná mii i mà yɛ? Ei! Mii sì n-jà n-kàre zà na tuŋi kyaaga wuŋi ɲya mɛ!» ");
INSERT INTO spp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ɲyɛ *Zhuda à kwɔ̀ puru jwumpe na ke, Yusufu ɲyɛ a jà a cû uye na sùpyire shwɔhɔl'e mɛ, ka u u sêe maa jwo sùpyire puni ti fworo bage e. Tèni i Yusufu à uye cyêe u sìɲɛɛbii na ke, sùpyaŋi wabɛrɛ mpyi ná pi e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yusufu à mɛɛ sú, fo *Misira shiinbii pi mpyi ntaani na ke, pir'à u mɛɛni lógo, ka pure jwumpe si nɔ Farɔn pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ka Yusufu si yi jwo u sìɲɛɛbil'á «Mii u ɲyɛ Yusufu! Mii tuŋi saha na ɲyɛ shì na la?» ka pi i fyá fo pi ɲyɛ a jà a u ɲwɔ shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ka u u yi jwo pi á lùtaan na «Yii file na na.» Pi à file u na ke, ka u u jwo «Mii u ɲyɛ yii sìɲɛɛŋi Yusufu, ŋge yii à pɛ́rɛ cwɔhɔmpil'á pi i ŋkɛ̀ɛge Misira e ke. ");
INSERT INTO spp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Yii wà ɲyɛ a yaa u funŋke pɛn u u uye la wwû na yii à mii pɛ́rɛ naha mɛ. Kile u à mii tùugo naha yii yyaha na, bà mii si mpyi si sùpyire tà shwɔ kwùŋi na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Katege yyee shuunni cyi ɲyɛ ɲcyii kìni i. Ɲyɛ faaŋi saha sì n-jà n-pyi mɛ, sùmaŋi mú sì n-kwɔ̀n mɛ, fo yyee kaŋkuro ká ntòro sahaŋki ");
INSERT INTO spp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kile u à mii tùugo yii yyaha na naha, bà yii tùluge si mpyi si ŋkwôro ɲìŋke na si ɲyaha mɛ. ");
INSERT INTO spp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Yii bà pi à mii tun naha mɛ, Kile yabiliŋi wi. U à mii tìŋɛ naha, maa mii pyi Farɔn kacwɔnrɔŋi niɲcyiiŋi, maa mii yaha u bage puni ɲùŋke na, maa mii pyi Misira kìni puni ɲùŋufembwɔhe. ");
INSERT INTO spp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ɲyɛ yii a fyâa, yii a sì mii tuŋi yyére, yii i sà yi jwo u á na u jyaŋi Yusufu à jwo na Kile à uru pyi Misira kìni puni ɲùŋufooŋi. Na u a fyâa, u a ma naha uru yyére. ");
INSERT INTO spp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Na u sí n-pa n-tɛ̀ɛn uru taan Gozheni i, u ná u pyìibii ná u ɲampyiyi, ná u yatɔɔre ná u cyeyaayi puni. ");
INSERT INTO spp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Na uru sí n-pa yalyîre kan u á, ɲaha na yɛ katege sí n-pyi yyee kaŋkuro funŋ'i sahaŋki. U aha mpa naha u ná u pyɛngɛ shiinbii ná u yatɔɔre sì n-fô yaag'e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yii yabilimpii ɲyii wà li na, mii kàntugo wuŋi Bɛnzhama yabiliŋi ɲyii ɲyɛ li na, na mii Yusufu u ɲyɛ na yu ná yii e. ");
INSERT INTO spp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Pèente ti ɲyɛ mii i naha Misira kìni i ke, ná yii yabilimpii mu à ndemu ɲya ke, yii a sì, yii sà li jwo mii tuŋ'á. Lire kàntugo, yii i nta, yii a ma ná na tuŋi i naha fwɔfwɔ.» ");
INSERT INTO spp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ɲyɛ Yusufu à puru jwo ke, maa cyeyi míginɛ u cɔɔnŋi Bɛnzhama yacige e maa mɛɛ sú, ka Bɛnzhama mú si u wuyi míginɛ Yusufu yacige e, maa mɛɛ sú. ");
INSERT INTO spp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ka Yusufu mɛɛsuwuŋi si u cyeyi míginɛ u yyahawuubii puni niŋkin niŋkin yaciy'e. Ka pi i nta a jwo ná u e. ");
INSERT INTO spp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ɲyɛ tèni i Yusufu sìɲɛɛbii mpaŋ'à nɔ Farɔn ná u kìni yyaha yyére shiinbii na ke, ka lire si ntáan pi e. ");
INSERT INTO spp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ka Farɔn si Yusufu yyere, maa yi jwo u á «Yi jwo ma sìɲɛɛbil'á na pi pi dùfaanyi tugo sùmaŋi na, pi núru pi a sì *Kana kìni i. ");
INSERT INTO spp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Na pi aha nɔ wani, pi pi tuŋi ná pi pyɛngɛ shiinbii puni lwɔ́, pi a ma, pi pa ntɛ̀ɛn naha na taan. Mii sí *Misira kìni tacɛnŋke kà kan pi á. Pi sí n-pa a kìni ɲjyìŋi niɲcɛnŋi lyî.» ");
INSERT INTO spp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Maa jwo Yusufu á sahaŋki «Yi jwo ma sìɲɛɛbil'á na mii à jwo pi shɔnyi wòtorobii pìi lwɔ́ naha Misira e, pi i sà pi pyìibii ná pi cyeebii ná pi tuŋi lwɔ́, pi a ma. ");
INSERT INTO spp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Pi aha mpyi pi ɲyɛ a jà a pa ná yaayi y'e mɛ, lire kà pi funŋɔ pɛn mɛ, ɲaha na yɛ Misira kìni tacɛnyi puni niɲcɛnŋke ku sí n-kan pi á.» ");
INSERT INTO spp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ɲyɛ Farɔn à ndemu jwo ke, ka *Yakuba jyaabii si lire pyi. Ka Yusufu si shɔnyi wòtorobii pìi kan pi á, mà tàanna ná Farɔn jwumpe e. Maa ɲjyìŋi wà kan pi á na pi a uru lyî kuni na. ");
INSERT INTO spp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Maa vàanvɔnyɔ kan pi puni niŋkin niŋkinŋ'á, maa wyɛ̀rɛfyiŋi darashii ŋkwuu taanre ná vàanvɔnyɔ kaŋkuro kan Bɛnzhama á. ");
INSERT INTO spp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Maa dùfaanmpeeye kɛ tugo Misira ɲjyìŋi niɲcɛnŋi na, maa dùfaancyaa kɛ tugo sùmapyaŋi ná bwúuruŋi ná ɲjyìŋi shiŋi wabɛrɛ na, pi i sà yire puni kan uru tuŋ'á, bà pi si mpyi pi aha ma, pi uru pyi kuni ɲjyìŋi mɛ. ");
INSERT INTO spp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Lire ɲwɔhɔ na, u à kuni kan u sìɲɛɛbil'á na pi a sì. Maa jwo pi á «Yii àha ŋkwɔ̀ ntùn kuni na mà dɛ!» ");
INSERT INTO spp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ka pi i yîri Misira e, mà kàr'a sà nɔ Kana kìni i, pi tuŋi Yakuba yyére. ");
INSERT INTO spp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Pi à nɔ ke, ka pi i yi jwo pi tuŋ'á «Yusufu na wá shì na! Uru yabiliŋi u à tɛ̀ɛn Misira kìni ɲùŋɔ na.» Ka li i Yakuba pâa maa u yákiliŋi wurugo fo u à fyâha fyiii, ɲaha na yɛ u ɲyɛ a dá pi jwumpe na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ŋka jyafeebil'à pa a Yusufu jwumpe puni yu u á tèni ndemu i ke, shɔnyi wòtorobii Yusufu mpyi a yaha a pa u talwɔ́ge e, ka u u pire ɲya ke, ka u yákiliŋi si nta a tɛ̀ɛn. ");
INSERT INTO spp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Maa jwo «Mii jyaŋi Yusufu na ɲyɛ shì na la? Mii saha ɲyɛ na yaaga caa mà tòro lire na mɛ. Mii kɛ̀ɛge zà na ɲyiini tɛ̀gɛ u na mà jwo mii u kwû ke.» ");
INSERT INTO spp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","*Yakuba niŋkàriŋi *Misira e, u à kàre ná u cyeyaayi puni i. U à sà nɔ Bɛrisheba e ke, maa sáraya wwû u tuŋi Ishaka u Kileŋi á. ");
INSERT INTO spp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ka Kile si uye cyêe u na kuru numpilage e, maa u yyere «Yakuba, Yakuba!» Ka u u jwo «Yo!» ");
INSERT INTO spp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ka Kile si jwo «Mii u ɲyɛ Kile, mu tuŋi u Kileŋi. Ma hà raa fyáge si ŋkàre Misira e mɛ, ɲaha na yɛ mii sí mu tùluge ɲyaha wani kuru cyage e. ");
INSERT INTO spp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mii, Kile yabiliŋi u sí n-kàre ná mu i Misira e, mii yabiliŋi mú u sí n-pa mu yige wani si núru mpa naha. Yusufu yyére, mu sí n-kwû, uru mú u sí mu ɲyiigii tò.» ");
INSERT INTO spp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ɲyɛ Yakuba à yîri Bɛrisheba kànhe e. Farɔn mpyi a wòtorobii mpiimu yaha pi sà u lwɔ́ ke, ka u jyaabii si u lèŋɛ pire wòtorobil'e, ná pi cyeebii ná pi pyìibii. ");
INSERT INTO spp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Maa pi yatɔɔre mú lwɔ́, ná yaayi puni pi mpyi a ta *Kana kìni i ke. Ka Yakuba ná u pyɛnge shiinbii puni si ŋkàre Misira e ");
INSERT INTO spp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Lire pyiŋkanni na Yakuba à kàre Misira kìni i ná u pyɛnge shiinbii puni i: u jyaabii, ná u pùcɛribii, ná u ɲampyire. ");
INSERT INTO spp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ɲyɛ *Yakuba pyìibii ná u ɲampyire pi à kàre *Misira e ke, pire mɛyi yi ɲyɛ ɲje. U jyaŋi niɲcyiiŋi mɛge ku ɲyɛ Urubɛn. ");
INSERT INTO spp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Urubɛn jyaabii pi mpyi, Kyanɔki, Palu, Kyezirɔn, ná Karimi. ");
INSERT INTO spp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiyɔn wuubii pi mpyi Yemuwoli, Yamini, Owadi, Yakɛn, Zokyari, Shawuli. *Kana shin u mpyi Shawuli nuŋi. ");
INSERT INTO spp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","*Levi wuubii pi mpyi Gerishɔn, Kehati, Mɛrari. ");
INSERT INTO spp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","*Zhuda wuubii pi mpyi Ɛri, Ona, Shela, Pɛrɛzi, ná Yeraki. Ŋka Ɛri ná Ona mpyi a kwû Kana kìni i. Perɛsi u jyaabii pi mpyi Kyezirɔn ná Kyamuli. ");
INSERT INTO spp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakari wuubii pi mpyi Tola, Puva, Yobo ná Shimirɔn. ");
INSERT INTO spp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulɔn wuubii pi mpyi Sɛrɛdi, Elɔn, ná Yalɛli. ");
INSERT INTO spp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Tire pùnampyire Leya à si Yakuba á, mà pi yaha Mɛsopotami kìni i, ná u pworoŋi Dina. Leya pyìibii ná u ɲampyire na mpyi shiin beɲjaaga ná kɛ ná taanre. ");
INSERT INTO spp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Ɲyɛ bilicwoŋi Laban mpyi a kan u pworoŋi Leya á ke, uru mɛge mpyi Zilipa, u à Gadi ná Ashɛri si Yakuba á. Gadi jyaabii pi mpyi Sifiyɔn, Kyagi, Shuni, Ezibɔn, Eri, Arɔdi, ná Arɛli. Ashɛri wuubii pi mpyi Yimina, Yishiva, Yishiwi, Beriya ná pi pùcɛrɛŋi Serakyi. Beriya wuubii pi mpyi Kyɛbɛri, ná Malikiyɛli. Zilipa pyìibii ná ɲampyire mpyi shiin kɛ ná baani. ");
INSERT INTO spp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakuba cwoŋi Arasɛli u jyaabii mpyi Yusufu ná Bɛnzhama. ");
INSERT INTO spp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusufu à jyaa shuunni ta Misira e, pire pi mpyi Manase ná Efirayimu. U cwoŋi Asanati, u à pire si u á. Asanati na mpyi Potifira pworoŋi wà. Potifera na mpyi Ɔni kànhe sáragawwuŋi wà. ");
INSERT INTO spp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bɛnzhama jyaabii pi mpyi Bela, Bɛkɛri, Ashibɛli, Gera, Naamani, Ɛki, Ɔrɔshi, Mupimi, Kwupimi ná Aridi. ");
INSERT INTO spp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Arasɛli pyìibii ná ɲampyire mpyi shiin kɛ ná sicyɛɛre. ");
INSERT INTO spp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Ɲyɛ bilicwoŋi Laban mpyi a kan u pworoŋi Arasɛli á, na u mɛge mpyi Bila ke, u à Dan ná Nɛfitali si Yakuba á. Dan jyaŋi u mpyi Kwushima. Nɛfitali jyaabii pi mpyi Yazɛli, ná Guni, Yezɛri, ná Shilɛmu. Zilipa pyìibii ná u ɲampyire na mpyi shiin baashuunni. ");
INSERT INTO spp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Sùpyire t'à kàre Misira e ná Yakuba e ke, u yabiliŋi jyaabii ná u ɲampyire, pi puni mpyi shiin beetaanre ná baani. U napworibii ɲyɛ a tòro mɛ. ");
INSERT INTO spp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ɲyɛ jyaa shuunni mú à si Yusufu á Misira e, lire pyiŋkanni na, Yakuba ná u shiinbii pun'à bɛ̂ shiin beetaanre ná kɛ na Misira e. ");
INSERT INTO spp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ɲyɛ mà jwo *Yakuba u kuni lwɔ́ u a ŋkɛ̀ɛge *Misira kìni i ke, u à *Zhuda yaha a kàre uye yyaha na, Yusufu yyére, u sà yi jwo u á na uru wá na ma Misira e, Gozheni kùluni i. ");
INSERT INTO spp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu à yire lógo ke, ka u u shɔnge wòtoroŋi wà bégel'a kàr'a sà u tuŋi Yakuba ɲùŋɔ bɛ? Gozheni i. U à nɔ u tuŋi na ke, maa u cyeyi míginɛ u tuŋi yacige e, maa mɛɛ sú sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ka Yakuba si jwo Yusufu á «Numɛ, mii mɛ́ɛ ká ŋkwû, lire ɲyɛ a waha mii na mɛ, ɲaha na yɛ mii à mu ɲya a kwɔ̀, mà cè na mu saha na ɲyɛ shì na.» ");
INSERT INTO spp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ka Yusufu si yi jwo u sìɲɛɛbii ná u pyɛngɛ shiinbii sanmpil'á «Mii sí sà yi jwo Farɔn á na mii sìɲɛɛbii ná mii tuŋi shiinbii pi mpyi *Kana kìni i ke, na pi à pa. ");
INSERT INTO spp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mii sí yi jwo u á na mii shiinbii na ɲyɛ yatombyii, si yi jwo u á na yii à pa ná yii sikyaabii, ná yii mpàabii, ná yii nìiyi, ná yii cyeyaayi puni i. ");
INSERT INTO spp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Farɔn ká yii yyere, maa yii yíbe «Ɲaha báara fiiwe yii na mpyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","yii yi jwo u á «Mu bilibii na yatɔɔre byíi mà lwɔ́ pi nàŋkocyɛɛre e fo numɛ, wuu ná wuu tiibii pun'à lire pyi.» Lire ká mpyi, u sí yii yaha yii pi tɛ̀ɛn Gozheni kùluni i, ɲaha na yɛ mà tàanna ná pi Kile kuni i, Misira shiinbii ɲyɛ a yaa pi a wwûu karii na ná yatombyiibil'e mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Ɲyɛ Yusufu à kàre ná u sìɲɛɛbii pìi kaŋkure e, maa sà yi jwo Farɔn á «Mii tuŋi ná mii sìɲɛɛbil'à yîri *Kana kìni i mà pa, ná pi mpàabii, ná sikyaabii, ná nìiyi, ná pi cyeyaayi puni i. Pi ɲyɛ Gozheni kùluni i.» U à puru jwo a kwɔ̀ ke, maa pire sìɲɛɛbii kaŋkuruŋi cyêe u na. ");
INSERT INTO spp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ka Farɔn si pi yíbe «Báaraŋi ŋgire yii na mpyi yɛ?» Ka pi i u pyi: «Wuu ɲùŋufooŋi, wuu na ɲyɛ yatombyii, wuu tiibii fiige. ");
INSERT INTO spp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Wuu à pa nàmpantɛɛnre na mu kìni i. Wuu wuuni i, yalyîre sàha ɲyɛ wuu yatɔɔr'á mɛ. Kateg'à pêe Kana kìni i. Wuu yaha wuu u ntɛ̀ɛn Gozheni kùluni i.» ");
INSERT INTO spp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ka Farɔn si jwo Yusufu á «Ɲyɛ ná mu tuŋi ná mu sìɲɛɛbii s'à pa mu yyére, ");
INSERT INTO spp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","*Misira kìni li nde mu taan, ma tuŋi ná ma sìɲɛɛbii yaha kìni tacɛnɲyi puni niɲcɛnŋke e, Gozheni kùluni i. Mu aha pìi ta ma cìnmpyibiil'e mpiimu pi à yatombyiini cè sèl'e ke, maa pire yaha pi a mii yabiliŋi yatɔɔre nâha.» ");
INSERT INTO spp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ka Yusufu si mpa ná u tuŋi *Yakuba e mà pa ɲcyêe Farɔn na. Ka Yakuba si jwó le Farɔn á. ");
INSERT INTO spp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farɔn à Yakuba ɲya u à lyɛ ke, ka u u u yyeegii dáŋi yíbe. ");
INSERT INTO spp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ka Yakuba si u pyi: «Mii yyee ŋkuu ná beɲjaaga ná kɛ u ɲyɛ niɲjyee, cyire mii à pyi ɲani na. Mii ɲyɛ a lyɛ sèl'e mɛ, mii tìiŋi mú s'à waha, mii sì n-jà shì nintɔɔnwɔ ta, na tiibii fiige mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","U à puru jwo ke, maa jwó le Farɔn á sahaŋki, maa nta a kàre. ");
INSERT INTO spp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ka Yusufu si cyage kà kan u tuŋi ná u sìɲɛɛbil'á bà Farɔn mpyi a yi jwo mɛ, u à kìni tacɛnŋke kà kan pi á, Gozheni kùluni i. ");
INSERT INTO spp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Maa ɲjyì kan pi á mà tàanna ná sùpyire dáŋi i. ");
INSERT INTO spp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ɲyɛ ɲjyì yaaga sàha mpyi na ntaa *Misira kìni puni i mɛ, katege mpyi a nâara sèl'e. Ka Misira ná *Kana kìrigii sùpyire fànhe si ŋkwɔ̀ fo mà cwɔgɔ katege cye e. ");
INSERT INTO spp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ka Yusufu si sùmaŋi pɛ́rɛ pi á, maa cyire kìrigii wyɛ́rɛŋi puni shwɔ mà yaha nàfuuŋi tamârage e Farɔn mɛɛ na. ");
INSERT INTO spp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Misira kìni ná Kana kìni wyɛ́rɛŋ'à pa ŋkwɔ̀ tèni ndemu i ke, ka Misira shiinbii si mpa Yusufu yyére maa yi jwo u á «Yalyîre kan wuu á, ma hà wuu yaha katege ku bò mɛ. Wyɛ́rɛ saha ɲyɛ a sìi wuu á mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ka Yusufu si yi jwo pi á «Wyɛ́rɛ ká mpyi u ɲyɛ yii á mɛ, yii pa yii yatɔɔre fáa sùmaŋi na.» ");
INSERT INTO spp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ka pi i wá na ma ná pi yatɔɔre e yyeeni puni i Yusufu yyére. Ka u u wá na pi shɔnyi ná mpàabii ná sikyaabii ná nìiyi ná dùfaanyi fáre sùmaŋi na. ");
INSERT INTO spp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lire yyeen'à pa ŋkwɔ̀ ke, ka pi i mpa Yusufu yyére sahaŋki, maa yi jwo u á «Wuu ɲùŋufooŋi, wuu wyɛ́rɛŋ'à kwɔ̀, wuu à pa ná wuu yatɔɔre puni i mu yyére. Wuu sì li ŋwɔhɔ mu na mɛ, yaaga sàha ɲyɛ wuu pi kan mu á ná wuu yabilimpii ná wuu taare bà mɛ. ");
INSERT INTO spp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ma hà ɲɛɛ wuu yaha wuu kwû ma taan mɛ, wuu taare kà ŋkwôro sùpyiibaa mɛ. Wuu ná wuu taare shwɔ, yalyîre kan wuu á. Wuu ná wuu taare sí n-pyi Farɔn yahare e. Wuu la ɲyɛ sì ŋkwû si wuu taare yaha sùpyiibaa mɛ, sùma kan wuu á, wuu nûgo. ");
INSERT INTO spp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ka Yusufu si Misira taare puni shwɔ Farɔn mɛgɛ na, ɲaha na yɛ, kateg'à ta Misira shiinbil'e ke, ka pi i pi taare puni pɛ́rɛ Farɔn á. Lire pyiŋkanni na taare pun'à pa mpyi Farɔn woro. ");
INSERT INTO spp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ka Misira kìni sùpyire puni si mpa mpyi Farɔn bilii, mà lwɔ́ kìni ɲùŋke kà na, ma sà fworo ku sanŋke na. ");
INSERT INTO spp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Taare t'à kwôro shwombaa ke, tir'à pyi sáragawwuubii woore. Farɔn mpyi a *saliyaŋi wà tìŋɛ sáragawwuubii kurugo, nte u mpyi na ŋkaan pi á ke, tire mpyi a jà na pi ɲwɔ caa. Lire l'à pi ta pi ɲyɛ a pi taare pɛ́rɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ka Yusufu si yi jwo sùpyir'á «Ɲyɛ numɛ, mii à yii ná yii taare shwɔ a kan Farɔn á niɲjaa. Mii sí sùmashiŋi kan yii á yii nûgo. ");
INSERT INTO spp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ŋka sùmakwɔɔngii ká nɔ, yii sí sùmaŋi táa tatáayi kaŋkuro, si taaga niŋkin kan Farɔn á. U sanŋi sí n-pyi shiŋi, ná yii pyɛngɛ shiinbii ɲwɔlyiŋi. ");
INSERT INTO spp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ka pi i Yusufu pyi «Wuu ɲùŋufooŋi, mu à wuu shwɔ katege na. Ɲyɛ ná mu s'à lire kacɛnni nimbwoni pyi wuu á, wuu sí n-pyi Farɔn bilii.» ");
INSERT INTO spp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ka Yusufu si to le Misira kìni i: «Nùŋgwɔhɔ maha nùŋgwɔhɔ, yii sí yii sùmaŋi nintaŋi táa tatáayi kaŋkuro si taaga niŋkin kan Farɔn á.» Uru toŋi ɲyɛ wani fo niɲjaa. Sáragawwuubii u taare kanni t'à kwôro ti ɲyɛ a pyi Farɔn wooro mɛ. ");
INSERT INTO spp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ɲyɛ lire pyiŋkanni na, *Izirayɛli shiinbil'à tɛ̀ɛn Gozheni kùluni i, Misira kìni i. Ka pi cyeyaayi ná pi pyìibii si mpa ɲyaha. ");
INSERT INTO spp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Lire kàntugo, *Yakuba à yyee kɛ ná baashuunni pyi Misira kìni i. U shìŋi yyeegii pun'à bɛ̂ yyee ŋkuu ná beeshuunni ná baashuunni na. ");
INSERT INTO spp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","U tèekwûun'à nɔ ke, ka u u u jyaŋi Yusufu yyere, maa yi jwo u á «Kampyi mii kyal'à táan mu á, ma tàange ná ma ɲwɔmɛfente cyêe na na. Mii aha ŋkwû ma hà na tò Misira e mɛ, mii la ɲyɛ maa ma cyɛge le na cyiini ɲwɔh'i, maa ŋkâa, na mu sì ɲɛɛ mii tò Misira e mɛ. ");
INSERT INTO spp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mii aha ŋkwû, maa na buwuŋi lwɔ́ a yige Misira kìni i, mà sà ntò na tulyeyi tatoŋke e.» Ka Yusufu si jwo ur'à yi lógo, na uru sí li pyi, bà u à yi jwo mɛ. ");
INSERT INTO spp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ka Yakuba si jwo «Lire tèni i, mu sí n-kâa mii á.» Ka Yusufu si ŋkâa. Lire kàntugo, ka Yakuba si niŋkure sín u yasínniŋke ɲùŋɔ yyére, maa Kile pêe. ");
INSERT INTO spp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Lire kàntugo, ka pi i mpa yi jwo Yusufu á, na u tuŋi *Yakuba ɲyɛ a cùuŋɔ mɛ. Ka Yusufu ná u jyaabii shuunniŋi, Manase ná Efirayimu, si ŋkàre Yakuba taan. ");
INSERT INTO spp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tèni i y'à jwo Yakuba á na u jyaŋi Yusufu wá na ma u yyére ke, ka u u ŋkárama a yîr'a tɛ̀ɛn u yasínniŋke na. ");
INSERT INTO spp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yusufu à pa ke, ka u u yi jwo u á «Kile Siŋi Punifol'à uye cyêe mii na Luzi kànhe e, *Kana kìni i, maa jwó le mii á. ");
INSERT INTO spp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Maa jwo mii á «Mii sí pyìi niɲyahamii kan mu á, si mu shiinbii ɲyaha, si pi pyi sùpyishi niɲyahawa, si nde kìni kan mu tùlug'á, li sí n-pyi pi wuu tèrigii puni i.»» ");
INSERT INTO spp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Maa núr'a yi jwo Yusufu á «Pùnampyire shuunniŋi mu à ta naha *Misira kìni i, mà mii ta mii sàha mpa mu yyére naha mɛ, Efirayimu ná Manase, pire sí n-pyi mii pyìi, bà Urubɛn ná Simiyɔn ɲyɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ŋka pyìibii mu sí n-ta pire kàntugo ke, pire sí n-pyi mu yabiliŋi wuu. Pi sí pi nàntan kɔɔge ta Efirayimu ná Manase cye kurugo. ");
INSERT INTO spp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mii na lire pyi Arasɛli kurugo, ɲaha na yɛ mii niɲjîriŋi Mɛsopotami kìni i, mu nuŋi Arasɛli à kwû mii á Kana kìni i, Efirata kànhe taan. Ka mii i u tò kuru cyage e Efirata kànhe kuni na.» (Efirata kànhe pi maha mpyi Bɛtilehemu numɛ.) ");
INSERT INTO spp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakuba à Yusufu pyìibii ɲya ke, ka u u jwo «Mpii pi ɲyɛ mpii yɛ?» ");
INSERT INTO spp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ka Yusufu si jwo «Kile à pùnampyire shuunniŋi ntemu kan mii á naha Misira e ke, tire ti.» Ka Yakuba si jwo «Maye sanŋa yaha, maa pi file na na, bà mii si mpyi si jwó le pi á mɛ.» ");
INSERT INTO spp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ɲyɛ lyage mpyi a Yakuba ɲyiɲyaani cyɛ́ɛŋɛ. U sàha mpyi na ɲaa na ɲcúu mɛ. Ka Yusufu si u pyìibii file u na, ka u u pi lwɔ́ a taha u tooyi na, maa pi pur'a cû. ");
INSERT INTO spp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Maa jwo Yusufu á «Mii mpyi a tɛ̀ɛn ná l'e na mii saha sí mu ɲya mɛ. Ŋka li le, Kile à li yaa mii à mu pyìibii yabilimpii ɲya.» ");
INSERT INTO spp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ka Yusufu si u pyìibii láha u tuŋi tooyi na, maa niŋkure sín ɲìŋke na u taan maa yyahe cyígile. ");
INSERT INTO spp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Lire kàntugo, maa u jyaŋi Efirayimu yaha u kàniŋɛ cyage na, maa Manase yaha u kàmɛnɛ woge na. Maa file ná pi e u tuŋi na, maa Efirayimu yyéreŋɛ tufooŋi kàmɛni na, maa Manase yyéreŋɛ u kàniŋke na. ");
INSERT INTO spp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ŋka u tuŋi Yakuba à u cyeyi para a taha, maa u kàniŋɛ cyɛge taha Efirayimu ɲùŋke na, mà li ta uru u ɲyɛ cɔɔnfooŋi, maa u kàmɛni taha yyahafooŋi Manase woge na. ");
INSERT INTO spp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Maa jwó le Yusufu á maa jwo «Mii tulyage *Ibirayima ná mii tuŋi Ishaka, pir'à Kileŋi ŋgemu pêe ke, uru u jwó le mpii pyìibil'á. Uru Kileŋi ɲyɛ ná mii i, mà lwɔ́ mii canzege na, mà pa bwɔ̀n numɛ na. ");
INSERT INTO spp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Kile Mɛlɛkɛŋi u à mii shwɔ kawagii puni na ke, Uru u jwó le mpii pyìibil'á. Mpii pyìibii pi mii mɛge pyi ku kwôro shi, Mii tulyage Ibirayima ná mii tuŋi Ishaka mɛge kà mpîni mɛ. Pi tùluge ku ɲyaha ɲìŋke na.» ");
INSERT INTO spp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ɲyɛ Yusufu à li ɲya na u tuŋ'à u kàniŋɛ cyɛge taha cɔɔnfooŋi Efirayimu ɲùŋke na ke, ka li i mpɛn u e, ka u u tufooŋi kàniŋɛ cyɛge láha Efirayimu ɲùŋke na mà taha Manase woge na. ");
INSERT INTO spp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Maa jwo «Baba, mu à wurugo, ŋge u ɲyɛ jyafooŋi niɲcyiiŋi ke, uru u ɲùŋke na mu mpyi a yaa mu u ma kàniŋɛ cyɛge taha.» ");
INSERT INTO spp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ŋka tufooŋi ɲyɛ a ɲɛɛ mɛ, maa jwo «Mii jyaŋi, mii à yi cè fo mà ɲwɔ. Manase u tùluge mú sí ɲyaha n-pyi shiŋi wà. U sí n-pyi shinbwo, ŋka u kàntugo wuŋi sí n-pêe u na. U cɔɔnŋi tùluge sí ɲyaha n-pyi shi niɲyahawa.» ");
INSERT INTO spp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ka Yakuba si jwó le pi á kuru canŋke, maa jwo «*Izirayɛli shiinbii sí raa jwóŋi leni ná yii mɛge e. Pi sí n-pa a ŋko «Kile u jwó le yii á, bà u à u le Efirayimu ná Manase á mɛ.»» Lire pyiŋkanni na, Yakuba à Efirayimu yaha Manase yyaha na. ");
INSERT INTO spp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Lire ɲwɔhɔ na, ka u u yi jwo Yusufu á «Mii à na tashàge byanhara, ŋka Kile sí n-pyi ná yii e. U sí yii pyi yii núru yii tulyeyi kìni i, Kana kìni i. ");
INSERT INTO spp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mà bâra lire na, mii sí mu kɔɔge ɲyaha n-tòro mu sìɲɛɛbii sanmpii woge taan. Mii sí Sikɛmu kùluni kan mu á. Mii à kuru shwɔ Amɔri shiinbii na, ná na kàshikwɔnŋwɔɔni ná sintaage e. ");
INSERT INTO spp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Lire kàntugo, ka *Yakuba si u jyaabii yyere maa jwo: «Yii a ma, yii i mpa bínni na taan, karigii nimpaŋkii cyi sí nɔ yii na ke, mii sí cyire jwo yii á. ");
INSERT INTO spp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yakuba jyaabii, yii a ma yii i mpa bínni, yii lógo yii tuŋi *Izirayɛli ɲwɔ na. ");
INSERT INTO spp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Urubɛn, mu u ɲyɛ mii jyaŋi niɲcyiiŋi, Mu u ɲyɛ mii nànte yaage, mii à mu si mà mii ta nàɲjiiwe. Pèente mu à ta ke, tir'a fànha tò mu sìɲɛɛbii sanmpii woore na. Fànhe ku ɲyɛ mu i ke, kur'à ɲyaha mu sìɲɛɛbii sanmpii woge na. ");
INSERT INTO spp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ŋka mu na ɲyɛ mu à jwo lwɔhɔ ŋkemu k'à dùgo ɲî a fworo na fwu ke, mu tɛɛnm'à pɛn. Mu à dùgo ma tuŋi yasínniŋke ɲuŋ'i, maa wwɔ̀ ná ma tuŋi cwoŋi w'e. Lire kurugo, mu saha sì yyaha yyereŋi ta mɛ ");
INSERT INTO spp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiyɔn ná *Levi kapyiiŋkii ɲyɛ niŋkin, pi maha pi kàshikwɔnŋwɔhɔgii lwúu marii kakyaare pyi. ");
INSERT INTO spp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mii ɲyɛ a sìi ná pi e pi ŋgwòŋi i mɛ Pi kapyiiŋkii mú sí ɲyɛ a táan mii á mɛ Ɲaha kurugo yɛ mà pi lùyiriwuubii yaha, pi à sùpyire tà bò, pi pege kurugo. Mà pi yaha bàhage na, pi à nùpyahii cyì sirakapanya *kwɔ̀n. ");
INSERT INTO spp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mii à pi láŋa pi lùyirini kurugo, ɲaha na yɛ lùyirini l'à pi wà lire kapiini mpyiŋi na. Mii à pi láŋa pi lùyirintoroni kurugo, ɲaha na yɛ lùyirintoroni l'à pi wà lire kapiini mpyiŋi na Mii sí pi tùluyi pyi yi láha yiye na Izirayɛli kìni i, Yi sí n-tɛ̀ɛn n-tɛ̀ɛn yiye Yakuba kìni puni yyaha kurugo. ");
INSERT INTO spp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","*Zhuda, mu sìɲɛɛbii sí raa mu pêre, mu sí ma cyɛge taha ma zàmpɛɛnbii kaɲɛkwuunni na, mu sìɲɛɛbii sí raa niŋkure sínni mu á. ");
INSERT INTO spp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Mii jyaŋi, Zhuda, mu na ɲyɛ mu à jwo cànraga ku maha sà ɲaare maa sige yaare tà cû a kyà, maa núr'a pa sínni, maa tooyi sànhana. Mà ku yaha tasínage e, jofoo u sí ɲɛɛ n-jwo na uru sí ku kɔ̀rɔ n-yîrige yɛ? ");
INSERT INTO spp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","*Saanre kàbiini sì n-fworo Zhuda pyɛnge e mɛ, ɲùŋufente kàbiini sí n-kwôro u tùluge cye e, *supyishiŋi sanŋi sí raa làampuŋi kaan u á, si ŋkúu u á. ");
INSERT INTO spp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Zhuda, mu *ɛrɛzɛn cikɔɔge sí ɲwɔ sèe sèl'e, fo si mpyi mu mɛ́ɛ ká dùfaanŋke pwɔ k'e, lire sì yaaga kɛ̀ɛge mɛ. Mu sí raa ma vàanntinŋke jyíi ɛrɛzɛnŋi lwɔh'e s'a ma vàanntinmbwɔhe jyíi ɛrɛzɛnŋi sinmpe e. ");
INSERT INTO spp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mu ɲyiigii sí raa ɲî ɛrɛzɛnŋi lwɔhe cye kurugo, nùjirimpe sí mu ŋkyanhagii pyi cyi fíniŋɛ. ");
INSERT INTO spp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulɔn tatɛ̀ɛnge sí n-pyi suumpe lwɔhe ɲwɔge na, batoo nimbwoo sí raa yyereli kuru cyage e, mu kìni sí n-kàre sà nɔ fo Sidɔn kànha na. ");
INSERT INTO spp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakari fành'à ɲyaha dùfaanŋa fiige, u tatɛ̀ɛng'à bɛ yatɔɔre tabyige na, ");
INSERT INTO spp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","u à tatɛ̀ɛnge ɲya k'à ɲwɔ, kìni mú s'à táan ke, ka u u wá na báaraŋi niŋgaŋi pyi mu à jwo biliwe. ");
INSERT INTO spp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan sí u kìni shiinbii shwɔ u zàmpɛɛnbii na, Izirayɛli tùluyi sanɲyi fiige. ");
INSERT INTO spp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","U na ɲyɛ mu à jwo wwɔ̀ ŋgemu u à sínni kuni i ke, mu à jwo màcwɔn kuɲcwɔre e, u maha shɔnyi nɔni tooyi na, shɔndugubil'a sì wá na ɲcwo. ");
INSERT INTO spp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Kafooŋi Kile, mii à tɛ̀ɛn ná l'e na mu sí mii shwɔ. ");
INSERT INTO spp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadi wi ke, kakuumpyiibii pìi sí n-pa n-cwo u na, si u tun. Ŋka u sí pi kɔ̀rɔ n-caala. ");
INSERT INTO spp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ashɛri wi ke, yafaayi sí raa ɲwɔge u kìni i. Saanbii ɲjyìŋi niɲcɛnŋi sí raa ntaa l'e. ");
INSERT INTO spp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nɛfitali na ɲyɛ mu à jwo cèŋɛ, ŋkemu ku ɲyɛ kuy'á ke, ku maha cèmpyire nisìnante sini. ");
INSERT INTO spp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu fành'à ɲyaha mu à jwo sige dùfaanŋa ku ɲyɛ lwɔhɔ ɲwɔ na; mu à jwo sige dùfaanmbile kafaawaga ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Sintaayifeebil'à taha u fye e, maa u ŋwɔ ná tàanbil'e, maa u kànha sèl'e. ");
INSERT INTO spp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ŋka u sintaag'à kwôro u cye e, Yakuba u Kileŋi Siŋifol'à fànha kan u cyey'á. Uru Kileŋi u ɲyɛ Izirayɛli kàanmucyafooŋi, uru mú u ɲyɛ Izirayɛli taŋwɔhɔge. ");
INSERT INTO spp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mu tuŋi u Kileŋi u sí mu tɛ̀gɛ, Kile Siŋi Punifoo u sí jwó le mu á, si nìɲyiiŋi zànhe kan mu á, si jwó le mu á, si ɲìŋke lùbilibii kan mu á, si mu pyìibii pyi pi ɲyaha; si mu yatɔɔre pyi ti púgo. ");
INSERT INTO spp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Jwóobii Kile à le mu tuŋ'á ke, pir'à fànha tò ɲaɲyi niɲjyeyi yacɛnyi na, Kile u jwó le Yusufu á amuni, Kile u jwó le u á, uru ŋgemu u ɲyɛ u cìnmpyiibii ɲùŋɔ na ke. ");
INSERT INTO spp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bɛnzhama na ɲyɛ mu à jwo sige pwun katege wu. Ɲyɛ̀ge na, u maha sige yaare tà cû a kyà, yàkoŋke u maha tà táa táa u pyìibii na.» ");
INSERT INTO spp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ɲyɛ Izirayɛli tùluyi kɛ ná shuunniŋ'à fworo mpii shiin kɛ ná shuunniŋi i. Pi tuŋi Yakuba jwumpe nizanmpe pu mpyi mpe mà yyaha tíi ná pi puni niŋkin niŋkinŋi i, wà ná wà wumɔ ɲyɛ a pyi niŋkin mɛ. ");
INSERT INTO spp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ɲyɛ lire kàntugo, ka *Yakuba si yi jwo a waha u jyaabil'á na: «Mii aha bú ŋkwû, yii i sà na tò na tulyeyi tatoŋke e, ɲaŋgyige ku ɲyɛ Kyiti shinŋi Efirɔn kɛrɛge e ke, wani yii sí n-sà mii tò na tulyeyi taan. ");
INSERT INTO spp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kuru ɲaŋgyige na ɲyɛ Makipela kɛrɛge e, Mamire cyage e, *Kana kìni i. *Ibirayima u à kuru cyage shwɔ Kyiti tùluge shinŋi Efurɔn á, mà pyi u kwùu tatòŋɔ. ");
INSERT INTO spp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Wani Ibirayima ná u cwoŋi Sara, ná Ishaka ná u cwoŋi Erebeka à tò, wani mii à na cwoŋi Leya tò mú. ");
INSERT INTO spp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kuru kɛrɛge ná ɲaŋgyige ku ɲyɛ k'e ke, yire pun'à shwɔ Kyiti shiinbil'á.» ");
INSERT INTO spp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ɲyɛ Yakuba à puru jwumpe jwo a kwɔ̀ u jyaabil'á ke, maa tooyi dùrugo yasínniŋke na, maa sínni, ka u múnaani si fworo u e. ");
INSERT INTO spp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tèni i Yusufu à cè na u tuŋ'à kwû ke, ka u u u yyahe bûru u woge na, maa mɛɛ sú. ");
INSERT INTO spp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","U à kwɔ̀ mɛɛsuni na ke, maa u wyempyiibii pyi pi à u tuŋi buwuŋi yal'a yaa ná nùguntangayaayi i mà yaha. ");
INSERT INTO spp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ka pi i ŋkwôro u ɲjaaŋi na fo mà sà nta canmpyaa beeshuunni, ɲaha na yɛ *Misira kìni làda u mpyi ure. Ka Misira shiinbii si yamɛɛni sú fo canmpyaa beetaanre ná kɛ. ");
INSERT INTO spp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Cyire canmpyaagil'à fûnŋɔ ke, ka Yusufu si yi jwo Farɔn fyèɲwɔhɔshiinbil'á «Kampyi sèe wi, mii kyal'à táan yii á, yii na pwɔhɔ yii sà yi jwo Farɔn á, ");
INSERT INTO spp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","na mà mii tuŋi yaha u sàha ŋkwû mɛ, u à yi jwo mii á na uru ká ŋkwû, mii i sà uru tò u fanŋke nintùgoge e *Kana kìni i, mii s'à kâa u á na mii sí li pyi. Lire kurugo, mii la ɲyɛ si sà na tuŋi tò si láha núru mpa.» ");
INSERT INTO spp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ɲyɛ puru jwump'à nɔ Farɔn na ke, ka u u yi jwo Yusufu á «Sà ma tuŋi tò Kana kìni i, maa núru, ɲaha na yɛ mu à kâa mà kwɔ̀ u á na mu sí lire pyi». ");
INSERT INTO spp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yusufu niŋkàriŋi ná u tuŋi buwuŋi i, Farɔn kìni ɲùŋufeebii pun'á sà u tùugo, Farɔn nàŋkolyeebii ná Misira kìni nàŋkolyeebii sanmpii puni, ");
INSERT INTO spp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ná Yusufu pyɛngɛ shiinbii puni, ná u sìɲɛɛbii, ná u tuŋi pyɛngɛ shiinbii puni. Pyìibii ná yatɔɔre kanni t'à kwôro Gozheni kùluni i, Misira kìni i. ");
INSERT INTO spp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Shɔnyi wòtorobii ná shɔndugubii mú na mpyi ná pi e. Sùpyiɲyahara ti mpyi tiye fye e na ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tafafyinge ku ɲyɛ Zhurudɛn baŋi kàntugo, ná ku mɛge ɲyɛ Atadi ke, pi à nɔ wani maa yamɛɛni sú, maa kwuuyi wà sèl'e. Canmpyaa baashuunni pi à pyi kuru kwùge na wani. ");
INSERT INTO spp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kana shiinbii pi ɲyɛ lire kìni i ke, pir'à kuru kwùge pyiŋkanni ɲya Atadi tafafyinge e ke, maa jwo «Ŋke à pyi kwùbwɔhɔ Misira shiinbil'á dɛ!» Lire kurugo, pi à kuru cyage mɛge le na *Abɛli Misirayimu, kuru cyage na ɲyɛ Zhurudɛn baŋi kàntugo ");
INSERT INTO spp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Lire pyiŋkanni na, *Yakuba mpyi a ɲjemu jwo u pyìibil'á u kwùge kyaa na ke, lire pi à pyi. ");
INSERT INTO spp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Pi à kàre ná u buwuŋi i Kana kìni i. Ɲaŋgyige ku ɲyɛ Makipela kɛrɛge e ke, mà sà ntò wani. *Ibirayima u mpyi a kuru cyage shwɔ Kyiti tùluge shinŋi Efirɔn á, mà yaha kwuutatoŋɔ, kuru cyage laage ɲyɛ a tɔɔn Mamire woge na mɛ. ");
INSERT INTO spp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusufu à u tuŋi tò a kwɔ̀ ke, ka u u núr'a kàre Misira kìni i. U sìɲɛɛbii ná shin maha shin u mpyi a kàre ná u e tufooŋi tatoŋke e ke, ka pire puni si núr'a pa Misira e. ");
INSERT INTO spp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ɲyɛ Yusufu sìɲɛɛbil'à li ɲya na pire tuŋ'à kwû ke, ka pi i jwo: «Yusufu ká yîri wuu kurugo numɛ de! Wuu à kapiini ndemu pyi u na ke, u aha jwo u sí lire fwooni tò wuu na de!» ");
INSERT INTO spp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ka pi i wà yaha a kàr'a sà yi jwo Yusufu á «Mà jwo mu tuŋi u kwû ke, u mpyi a jwo na ");
INSERT INTO spp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","wuu sà jwo ná mu i, wuu u mu ɲáare, maa náaŋi maa yàfa ma sìɲɛɛbii na, ɲaha na yɛ pi à kapii pyi mu na.» Ka pi i jwo Yusufu á «Wuu na ɲyɛ mu tuŋi Kileŋi bilii, náaŋi (maa yàfa*) maa ma sìɲɛɛbii kapiini yàfa pi na.» Yusufu à puru jwumpe lógo ke, ka u u mɛɛ sú. ");
INSERT INTO spp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ka u yyahawuubii si ŋkàr'a sà niŋkure sín u taan, maa jwo «Mu bilibii pi mpii.» ");
INSERT INTO spp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ka u u pi pyi «Yii àha vyá mɛ, mii u ɲyɛ Kile la? ");
INSERT INTO spp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yii pi ke, yii la mpyi si kapii pyi mii na, ŋka Kile à li kɛ̂ɛnŋ'a pyi kacɛnnɛ, maa li kàntugo pyi nde niɲjaa, bà sùpyire niɲyahara si mpyi si shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Lire e ke, yii àha raa fyáge mɛ, mii sí yii ná yii pyìibii puni le na kaloge ɲwɔh'i.» Maa jwo ná pi e tìpoom'i, mà pi zòmpii tìŋɛ. ");
INSERT INTO spp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Lire kàntugo, Yusufu ná u cìnmpyiibil'à kwôro *Misira e. Yusufu shìŋi tɛgɛn'à pyi yyee ŋkuu ná kɛ. ");
INSERT INTO spp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","U à u jyaŋi Efirayimu pyìibii ná u ɲampyire ɲya. Ɲyɛ Manase ɲampyir'à si ke, ka Yusufu si pire pyi u pyìi. Manase ɲampyire na mpyi Makiri pyìi. ");
INSERT INTO spp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Canŋka Yusufu à jwo u sìɲɛɛbil'á «Li sì mɔ mɛ, mii sí n-kwû, ŋka yii i dá li na na Kile sí yii le u kaloge ɲwɔh'i, si yii yige nde kìni i. Kìni ɲwɔmɛɛni u à lwɔ́ wuu tulyeyi *Ibirayima ná Ishaka ná *Yakuba á ke, u sí n-kàre ná yii e wani.» ");
INSERT INTO spp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Lire kàntugo, Yusufu à u sìɲɛɛbii pyi «Yii kâa na ɲyii na, na Kile ká bú yii yige Misira e, yii niŋkàribii, yii sí n-kàre ná mii kaciiyi i.» ");
INSERT INTO spp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ɲyɛ Yusufu à pa ŋkwû mà u shìŋi yaha yyee ŋkuu ná kɛ ke, ka pi i u buwuŋi bégele ná latikol'e mà le keshu funŋ'i mà tò Misira kìni i. ");
INSERT INTO spp_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Tèni i *Izirayɛli fànhe mpyi yukyaabil'a ke, katibwɔhɔ mpyi kìni i. Lire kurugo, nàŋi wà ná u cwo ná u jyaabii shuunniŋ'a fworo Bɛtilehemu i, kuru ɲyɛ *Zhuda kìni kànhe kà, sà tɛɛnlɛ pyi Mwabi kìni i. ");
INSERT INTO spp_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Nàŋi mɛge na mpyi Elimɛlɛki, ceeŋi woge sí i mpyi Nahami, pyìibii wuyi sí i mpyi Makulɔn ná Kiliyɔn. Efirata tùluge wuubii pìi pi, mà yîri Bɛtilehemu kànhe e, Zhuda kìni i. Lire tɛɛnni funŋke e Mwabi i, ");
INSERT INTO spp_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","ka Elimilɛki si ŋkwû, maa Nahami ná u jyaabii yaha. ");
INSERT INTO spp_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ka pire si Mwabi kìni cyeebii pìi lèŋɛ, wà mɛge na mpyi Oripa, sanŋi woge sí ɲyɛ Uruti. Yyee kɛ fiige pi a pyi, ");
INSERT INTO spp_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","ka Makulɔn ná Kiliyɔn si ŋkwû mú. Ka Nahami si ŋkwôro nɔ̀ ná pyìi baa. ");
INSERT INTO spp_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ka Nahami si lógo na Kafooŋi Kile na wá u kìni shiinbii tɛ̀gɛ ná yalyire e. Lire e, ka u u wá na bégele si yîri Mwabi kìni i, s'a wá u kìni i ná u napworibii mú shuunni i. ");
INSERT INTO spp_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ka u u yîri u tatɛɛnge e, u ná u napworibii mú shuunni i, mà kuni lwɔ́ a núru na ŋkɛ̀ɛge *Zhuda kìni i. ");
INSERT INTO spp_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ka Nahami si yi jwo pi a: «Yii núru, yii a sì yii nɛɛbii yyére. Tɛgɛŋkanni na yii a mii ná niŋkwûubii tɛ̀gɛ ke, Kile u yii tɛ̀gɛ amuni. ");
INSERT INTO spp_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Kile u yyeɲiŋke kan yii mú niŋkin niŋkin a, yii nàmbayi i.» Maa tàange fwùu kan pi a, ka pi mú shuunni si mɛɛ le na súu. ");
INSERT INTO spp_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ka pi i u pyi: «Ɔnhɔ, wuu sí raa ŋkɛ̀ɛge ná mu i mu shiinbii yyére.» ");
INSERT INTO spp_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ka Nahami si yi jwo pi a: «Mii napworibii, yii núru, yii a sì. Ɲaha kurugo yii sí n-tɛ̀ɛn mii yyére yɛ? Mii yyeegil'a nɔ cyage ŋkemu i ke, mii saha sì n-jà pyìi si, mpiimu pi sí n-jà n-pyi yii nàmbaa mɛ. ");
INSERT INTO spp_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yii na yaha naha, yii núru yii a sì yii shiin pyɛngɛ, ɲaha na yɛ mii a lyɛ a kwɔ̀, mii saha sì n-jà nàmbaga jyé mɛ. Mii mɛ́ɛ n'a mpyi na sí nɔ̀ ta niɲjaa, si pùnampyire ta u a, ");
INSERT INTO spp_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","yii sì n-jà pire sige fo pi aha lyɛ mɛ. Yii sì n-jà nàmbaabii sanmpii cyé mɛ. Kafooŋi Kile a yyefuge yaha mii na, yii s'aha ntaha mii fye e, yii sí n-ta kuru yyefuge e, lire laage sí i ɲyɛ mii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Ka pi mú shuunni si myahii le na súu sahaŋki, ka Oripa si tàange fwùu kan, maa kàntugo wà pi nacwoŋ'a, ka Uruti si ɲcyé, maa yyére u taan. ");
INSERT INTO spp_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Ka Nahami si yi jwo u a: «Mu ɲyii wà ma na yyahafooŋi cwoŋi na, u a núru na ŋkɛ̀ɛge u shiinbii ná u yasunɲy'a. Ma mú u núru u fiige mà sì ma shiinbii pyɛngɛ.» ");
INSERT INTO spp_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ka Uruti si yi jwo: «Ma hà na kárama si ɲjîri ma taan, s'a ŋkɛ̀ɛge na shiinbii yyére mɛ. Cyage maha cyage e mu a kàre ke, mii mú sí n-kàre wani. Cyage maha cyage e mu a tɛ̀ɛn ke, mii mú sí n-tɛ̀ɛn wani. Mu shiinbii mú sí n-pyi mii shiinbii, mu Kileŋi mú sí n-pyi mii Kileŋi. ");
INSERT INTO spp_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Mu aha ŋkwû cyage ŋkemu i ke, kuru cyage e mii sí n-kwû. Mii sí n-tɛ̀ɛn ná mu i, fo mà sà nɔ kwùŋi na. Cyage e mu sí n-tò ke, wani mii mú sí n-tò. Lire ká mpyi li ɲyɛ a pyi mɛ, Kafooŋi u kawaa pyi mii na!» ");
INSERT INTO spp_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nahami a pa ntɛ̀ɛn ná l'e na Uruti na sí n-sìi n-kàre ná u e ke, ka u u puru jwumpe yyéŋɛ. ");
INSERT INTO spp_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ka pi mú shuunni si ŋkàre Betilɛhɛmi i. Pi a nɔ Bɛtilehemu i ke, ka li i kànhe shiinbii puni kàkyanhala, ka cyeebii si jwo: «Ei! Nahami u ɲyɛ amɛ la?» ");
INSERT INTO spp_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ka Nahami si jwo: «Yii àha núru na yyere Nahami mɛ (Nahami ɲwɔhe ɲyɛ ɲùntangafoo), yii a na yire Mara (Mara ɲwɔhe sí ɲyɛ ɲùmpɛngɛfoo), ɲaha na yɛ Kafooŋi Siŋi Punifoo la mii lùbyage pyi wɛɛge lwɔhɔ mii shìŋi funŋke e. ");
INSERT INTO spp_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Mii niŋkariŋi cyeyi mpyi a ɲî, Kile s'a mii pyi mii a núru ná cyeŋgaayi i. Yii àha zìi núru na yyere Nahami mɛ. Kafooŋi Siŋi Punifoo u ɲyɛ kani ɲyafoo ná li cèvoo ke, uru u a pɔ̀nŋi nɔ mii na.» ");
INSERT INTO spp_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Lire pyiŋkanni na, Nahami a núr'a pa, mà yîri Mwabi kìni i, ná u napworoŋi Uruti i, u ɲyɛ Mwabi kìni shin ke. Pi tèepani Bɛtilehemu i, lir'a bɛ̂ ná sùmakwɔɔngil'e. ");
INSERT INTO spp_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ɲyɛ Nahami pooŋi Elimilɛki pyɛngɛ shin maa mpyi u cévoo, ur'a pyi wani. U mɛge na mpyi Bwazi, maa mpyi yaara ná mɛgɛfoo. ");
INSERT INTO spp_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Canŋka, Mwabi Uruti a yi jwo Nahami a: «Mii kɛ̀ɛge sige e. Ŋgemu ká bú sà mii ɲùɲaara ta ke, mii sí sà sùma fûgo urufoo fye e. Ka Nahami si jwo: «Ta sì, mii pworoŋi.» ");
INSERT INTO spp_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ka Uruti si yîri, maa ŋkàr'a sà sùmaŋi kɔɔge fûru sùmakwɔɔnbii fye e. U ɲùntancyage k'a pa mpyi, u a sà bɛ̂ ná Bwazi kɛrɛge e, Elimilɛki pyɛngɛ shinŋi wà. ");
INSERT INTO spp_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Canŋk'a ta ku nɔ cyage e ke, ka Bwazi si yîri Bɛtilehemu i mà nɔ wani, maa pi shɛ́ɛre, maa jwo: «Kile u pyi ná yii e.» Ka pi i u ɲwɔ shwɔ,: «Kile u jwó le ma a.» ");
INSERT INTO spp_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Ka Bwazi si sùmakwɔɔnbii ɲùŋufooŋi yíbe na: «Jofoo wu u ɲyɛ nde cibileni yɛ?» ");
INSERT INTO spp_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ka u u u ɲwɔ shwɔ mà jwo: «Mwabi kìni cibileni l'a pa ná Nahami i mà yîri Mwabi i ke, lire li. ");
INSERT INTO spp_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","U a kuni cya mii a, si ntaha sùmakwɔɔnbii fye e, s'a fûru pi kantugo. Mà lwɔ́ ɲyɛge na, u na ɲyɛ u tooyi na, numɛ u a nɛ̀ na tɛ̀ɛn vùŋke e si ŋɔ̀.» ");
INSERT INTO spp_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Lire kantugo, ka Bwazi si yi jwo Uruti a na: «Niŋgyiini tɛ̀gɛ, mii pworoŋi, ma hà núru ɲjîri naha ŋke kɛrɛge taan, s'a ŋkɛ̀ɛge kabɛr'e s'a sùma fûru mɛ. Ma hà laaga tɔɔn naha na mɛ, tɛ̀ɛn mii sùmakwɔɔncyeebii taan. ");
INSERT INTO spp_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ma wíi sèl'e, cyage e pi na ntùuli ke, maa ntaha pi fye e. Mii sí yi jwo nàɲjiipyir'a pi àha raa bâhare ná mu i mɛ. Byage ká ma ta, maa sà bya pi kucwɔhil'e. ");
INSERT INTO spp_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ka Uruti si niŋkure sín, maa yyahe cyígile, maa jwo: «Mii na ɲyɛ nàmpɔnŋɔ, ka ɲaha sí mu pyi mu a mii ɲaare ta yɛ?» ");
INSERT INTO spp_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Ka Bwazi si u ɲwɔ shwɔ: «Nde mu a pyi ma nacwoŋ'a, mu pooŋi ŋkwùŋi kantugo ke, pi a li jwo mii a. Mà bâre lire na, mu a yîri ma tuŋi ná ma nuŋi taan ma tasege e, maa mpa ntɛ̀ɛn kìni labɛr'e ná sùpyishiŋi w'e, ŋgemu u ɲyɛ mu ɲyɛ a pyi a u cè a lyɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Nde mu a pyi ke, Kile u ma sâra lire na. Kafooŋi, *Izirayɛli Kileŋi ŋge fukanyi ɲwɔh'i mu a maye ŋwɔhɔ ke, u ma kan sèe sèl'e.» ");
INSERT INTO spp_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ka Uruti si jwo: «Kàfooŋi Bwazi, mu a sùpygire pyi ná mii i. Mu a màban le mii i, maa lùtaanjwumbo jwo ná mii i, mà li ta, mii bá ɲyɛ mu bilicwɔŋi wà kwɔ̀ mɛ.» ");
INSERT INTO spp_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Tèelyîin'a nɔ ke, ka Bwazi si Uruti yyere u pa lyî ná pire e, maa bwúurukwɔnga kan, u a nígini cyɛnge e, u a lyî. Uruti a pa ntɛ̀ɛn sùmakwɔɔnbii taan, ka Bwazi si u kan sùmakaaga na. Ka u u lyî a tìn fo mà u sanŋi yaha. ");
INSERT INTO spp_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Uruti a sà a fworo sahaŋki, ka Bwazi si yi jwo u sùmakwɔɔnbil'a: «Yii u yaha ba, u a yúu niŋkwɔnyahaŋi i jwuɲyahama baa.» ");
INSERT INTO spp_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Yii a sùmaɲcyahayii yà cyán, ur'a yire bílili. Yii bà sàha yaaga jwo lire na mɛ. ");
INSERT INTO spp_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ka Uruti si sùmaŋi fûg'a canŋke kwɔ̀ Bwazi kɛrɛge e. Yàkoŋke, ka u u u nintaŋi bwɔ̀n mà taha a sàhala ɲî. ");
INSERT INTO spp_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","U a yîri sige e mà pa, maa mpa u sùmaŋi nivugutaŋi cyêe u nacwoŋi na. Maa u canŋa lyìge sanŋke wu mà kan u a. ");
INSERT INTO spp_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ka nacwoŋi si u yíbe na: «Taa mu a ŋge sùmaŋi puni fûg'a ta niɲjaa ke? Taa mu a canŋke pyi ke? Kile u jwó le ŋgemu u a ɲùɲaara ta ma na ke, ur'a.» Ka u u nacwoŋi pyi na ur'a canŋke pyi nàŋi ŋgemu kɛrɛge e ke, na u mɛge na ɲyɛ Bwazi. ");
INSERT INTO spp_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ka Nahami si jwo: «Bwazi mú na ɲyɛ wuu byanhama shin, u na ɲyɛ wuu kɔɔge lyìfooŋi wà, u sàha ŋkwɔ̀ u cyɛge láha wuu ɲyii wuubii ná niŋkwuubii na mɛ, Kile u jwó le u a.» ");
INSERT INTO spp_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ka Uruti si yi jwo u a, na uru ŋge nàŋi bá a jwo, na uru u ntɛ̀ɛn u kɛrɛge e sùmakwɔɔnbii kantugo, fo uru sùmaŋi ká *kwɔ̀n a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ka Nahami si yi jwo Uruti ɲyii na sahaŋki, na lire nde a táan ur'e, ɲaha na yɛ u aha ŋkàre wabɛrɛ u kɛrɛge e, u sí n-jà yyefugo ta wani. ");
INSERT INTO spp_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ka Uruti si ntɛ̀ɛn Bwazi kɛrɛge e ná u sùmakwɔɔnbil'e, fo ka pi i sà sùmaŋi kùuyi puni kwɔ̀n mà kwɔ̀. Lire tèni i, u mpyi na shùun nacwoŋi yyére. ");
INSERT INTO spp_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Canŋka, Nahami a jwo Uruti a: «Mii pworoŋi, mii sí mu le nàmbage e, bà mu si mpyi sà fɛ̀rɛmɛ ná yyeɲiŋɛ ta mɛ. ");
INSERT INTO spp_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ŋge nàŋi, Bwazi u mpyi a mu yaha mu u sùmaŋi fûru u báarapyiibii ɲwɔh'i ke, mu a li cè wuu byanhamu shin u ɲyɛ u wi. Ŋke numpilage e, u sí n-sà u sùmaŋi pyàŋi wwû fyiini na. ");
INSERT INTO spp_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Lire tèni i, mu a yaa mu u wìli, maa ntìri, maa ma vàanɲyi nisìnaɲyi lwɔ́ a le, maraa sì fyiini na. Ŋka ma hà u yaha u ma cè mà u ta u sàha ŋkwɔ̀ a lyî maa bya a kwɔ̀ mɛ. ");
INSERT INTO spp_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Mu aha shà, mu sí n-sà wíi u tasínage e, cyage e u na uye ŋɔ́ni ke, maa wíi u tooyi yyére, maa vàanntoŋi yîrige, mu sí tasínage ta, maa sínni wani. Nde mu a yaa mu u mpyi ke, u sí lire jwo mu a.» ");
INSERT INTO spp_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ka Uruti si u ɲwɔ shwɔ na: «Mu aha ndemu jwo mii a ke, mii sí lire pyi.» ");
INSERT INTO spp_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Maa ŋkàre sùmaŋi fyiini na. Bà u nacwoŋ'a yi jwo u a mɛ, ka u u sà ntòro amuni. ");
INSERT INTO spp_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bwazi a lyî maa bya, u múguro wuŋi, maa ŋkàr'a sà sínni sùmapyaŋi ŋkwùunni taan. Tèni i u a ŋɔ́ɔ ke, ka Uruti si mpeel'a file u na, maa tasínaga ta u tooyi yyére, vàanntoŋi ɲwɔh'i, maa uye sànhana. ");
INSERT INTO spp_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Numpilag'a lyɛ ke, ka Bwazi si ɲɛ̀, fo na ɲcyɛ̂ɛnni. L'a pâa u e sèl'e, u a yîr'a ceewe ta u a sínni u tooyi yyére. ");
INSERT INTO spp_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Ka u u yíbe: «Jo u ɲyɛ mu yɛ?»: «Mii u ɲyɛ Uruti, mu bilicwoŋi. Mii na li ɲáare mu a, maa vànŋke cyɛge kà tò na na, maa na lwɔ́ mà le ma màrampe e. Mu na ɲyɛ wuu pyɛnge kòolyibil'e.» ");
INSERT INTO spp_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ka Bwazi si yi jwo Uruti a: «Kile u jwó le ma a. Mu a li cyêe sahaŋki ma nacwoŋi pyɛngɛ shiinbii na, na mu na ɲyɛ ceewe niɲcɛnŋɛ. Mu numɛ kacɛnn'a ɲwɔ niɲcyiini na, ɲaha na yɛ mu ɲyɛ a ɲyii yige si nàmbaga lèŋɛ nàɲjiiw'a mɛ, fòŋɔfoo bâre ntafoo na mɛ. ");
INSERT INTO spp_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Lire tèni i, mii pworoŋi, ma hà núru raa fyáge mɛ, mu aha yaaga maha yaaga cya, mii sí lire pyi mu a, ɲaha na yɛ ŋke kànhe shiinbii pun'a li cè na mu na ɲyɛ ceewe niɲcɛnŋɛ. ");
INSERT INTO spp_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Kuru cyage e, sèe u ɲyɛ u wi, mii na ɲyɛ mu pyɛnge kòolyiŋi wà, ŋka wà a núr'a mu pyɛngɛ shiinbii byanhara mà tòro mii na. ");
INSERT INTO spp_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Numpilage sanŋke pyi naha. Ɲyɛ̀ge na, mu kyaa ká mpyi u na, u a bú mu lwɔ́, li sí n-pyi kacɛnnɛ. Ŋka u aha mpyi u ɲyɛ a li pyi mɛ, mii s'a na ɲwɔmɛɛni kan mu a, Kafooŋi Kile ɲyii wuŋi mɛge na, mii sí mu lwɔ́. Síni fo ɲyɛ̀ŋkwɔnge. ");
INSERT INTO spp_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ka Uruti si ntɛ̀ɛn Bwazi tooyi yyére fo ɲyɛ̀ŋkwɔnge, maa yîri. Bwazi la mpyi wà sì ɲcè na ŋge ceeŋ'a yîri uru yyére fyiini na mɛ. ");
INSERT INTO spp_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ka u u jwo na Uruti u u vànŋke sànha u u ku cû sèl'e. U a ku sànha ke, maa ku cû. Ka Bwazi si sùmaŋi yaɲyɛɛyi baani le k'e, maa u tɛ̀gɛ, ka u u ku tugo maa núr'a kàre pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Uruti a núr'a pa u nacwoŋi yyére ke, ka uru si u yíbe: «Di y'a tòr'a jwo yɛ, mii napworoŋi?» Nde Bwazi a pyi u a ke, ka u u jyè yi yyahe e mà jwo, ");
INSERT INTO spp_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","maa sùmaŋi cyêe mú, maa núr'a jwo na li ɲyɛ a mpyi a táan Bwazi a uru cyeŋgayi wuŋi si mpa Nahami yyére mɛ. ");
INSERT INTO spp_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ka Nahami si jwo: «Tɛ̀ɛn naha, mii napworoŋi fo wuu aha nde tùgo mà nɔ li tɛgɛni na. Ná Bwazi ɲyɛ a nde kani cwɔɔnrɔ mɛ, u sì taŋɔŋɔ ta wuu ɲyii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ka Bwazi si ŋkàre kànhe bàanni i, maa sà ntɛ̀ɛn, koolyiŋi shɛɛnre u a jwo ke, ka uru si mpaa ntùuli, ka Bwazi si u yyere: «Mucyiin pa naha, maa mpa ntɛ̀ɛn» ka nàŋi si mpa maa ntɛ̀ɛn. ");
INSERT INTO spp_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Ka Bwazi si kànhe yyecwugofeebii shiin kɛ yyere mà pa ntìŋɛ ná piye e. Tèni i pir'a pa ntɛ̀ɛn ke, ");
INSERT INTO spp_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","ka u u yi jwo koolyiŋi ɲyii na: «Mu a li cè, Nahami, u a yîri Mwabi kìni i mà pa, si mpaa lwɔ́foo caa wuu cìnmpworoŋi Elimɛlɛki kɛrɛge na. ");
INSERT INTO spp_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Mii a li ta maa yi jwo mu niŋgyiigii taan, si yi cyêe mu na naha, mpii pi naha naha ná wuu shiinbii yyecwugofeebii pi naha naha ke, pire ɲyii na. Mu u ɲyɛ koolyiŋi, kampyi mu sí kɛrɛge lwɔ́, maa ku lwɔ́ Nahami cye e. Kampyi mu sì ku lwɔ́ mɛ, maa yi jwo sí li cè, ɲaha na yɛ wà ɲyɛ mu ná ŋke kɛrɛge shwɔhɔl'e mɛ, mii u a taha mu na.» Ka u u jwo uru sí ku lwɔ́. ");
INSERT INTO spp_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ka Bwazi si jwo: «Mu aha kɛrɛge lwɔ́, mu a yaa u leŋkwucwoŋi Uruti lwɔ́ mà pyi ma cwo bà kɔɔge si mpyi si ŋkwôro kufooŋi niŋkwûŋi pyɛnge e mɛ.» ");
INSERT INTO spp_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ka nàŋi si jwo: «L'aha mpyi amuni, mii a fworo kɔɔge e, ɲaha na yɛ, mii na fyáge mii kɔɔge kà ŋkwɔ̀ mpîni mɛ. Lire tèni i, Bwazi, mu yabiliŋi u ku lwɔ́, sèeŋi na, mii sì n-jà ku lwɔ́ mɛ.» ");
INSERT INTO spp_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Tèecyiini i, *Izirayɛli shin n'a mpyi na sí li cyêe na nde kani cyiin na yal'a kwɔ̀, u mpyi maha u tanhaŋke wwû maha kan u shɛ̀refooŋ'a. Lir'a pyi kalyee Izirayɛli a ndemu l'a li cyêe na mbè a pyi nde kani na ke. ");
INSERT INTO spp_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kuru cyage e, koolyiŋi, ka uru si yi jwo Bwazi a: «Mu yabiliŋi mu u ku lwɔ́.» Maa u tanhaŋke wwû mà kan u a. ");
INSERT INTO spp_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Bwazi, ka uru si yi jwo yyecwugofeebii ɲyii na, na sùpyire ti mpyi wani u shiinbii ke: «Mii a ku lwɔ́ Nahami cye e, yii mú puni ɲyii na. Yaaga maha yaaga ku ɲyɛ Elimilɛki, Kilwɔn ná Makilwɔn wogo ke, ");
INSERT INTO spp_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","niɲjaa mii a ŋge ceeŋi Mwabi shinŋi Uruti lwɔ́ mà pyi na cwo, Makilwɔn leŋkwucwoŋi, bà kɔɔgefoo mɛge ku mpyi si ŋkwôro ku na mɛ.» ");
INSERT INTO spp_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Bàanni shiinbii puni, ka pire si jwo l'a pyi pire ɲyii na, maa jwo: «Kile u li pyi ŋge ceeŋi u ŋge u u ŋkor'a jyè mu pyɛnge e ke, u pyi Arasɛli ná Leya fiige, mpii mú shuunni pi a Izirayɛli bage sìi ke. Ma nàfuuŋi u púgo, Efirata tùluge e, mu mɛge ku táan, Kile u ma yaha mà pyà mɛge le Bɛtilehemu kànhe e. ");
INSERT INTO spp_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Kile u pyìi niɲyahamii kan ma a, nde cibileni na. Ma pyɛnge sí n-pyi Perɛzi woge fiige, ŋge Tamara a si *Zhuda a ke.» ");
INSERT INTO spp_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ka Bwazi si Uruti lèŋɛ u cwo, maa wwɔ̀ ná u e tasínage na. Ka Kafooŋi Kile si mpa ná l'e, ka u u laa ta, maa mpa si pùnambile. ");
INSERT INTO spp_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ka cyeebii si jwo Nahami a: «Kafooŋi Kile a yaa u kêe. Niɲjaa, u sàha ɲyɛ mu yaha koolyi baa mɛ. Kile u yaha u pyi mɛtangafoo Izirayɛli. ");
INSERT INTO spp_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Mu ɲyii na yal'a fworo ma napworoŋi na, mà tòro pùnampyire baashuunni na. U na ɲcáa mu na, ur'a si, pyà na ŋgemu u sí n-pa fànhe kabɛrɛ kan mu a, si mu tɛ̀gɛ ma canmpyaagii sanŋkil'e ke.» ");
INSERT INTO spp_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ka Nahami si pyàŋi lwɔ́, maa u ta uye na, maa mpyi u byifoo. ");
INSERT INTO spp_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ka u ciɲɛɛbii si múguroŋi pyi ná u e sèl'e, maa pyàŋi mɛgɛ le Obɛdi. Ɲyɛ Obɛdi u a pa mpyi Zhɛse tuŋi, ka uru si mpyi saanrefooŋi *Dawuda tuŋi. ");
INSERT INTO spp_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Saanrefooŋi Dawuda tasìige ku ŋke: Perezi u a pyi Ezirɔn tuŋi, ");
INSERT INTO spp_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","ka uru si Aramu si, ka Aramu si Aminadabi si, ");
INSERT INTO spp_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","ka uru si Nakisɔn si, ka Nakisɔn si Salamɔ si, ");
INSERT INTO spp_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","ka uru si Bwazi si, ka Bwazi si Obɛdi si, ");
INSERT INTO spp_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","ka uru si Zhɛse si, ka Zhɛse si Dawuda si.");
INSERT INTO spp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ɲyɛ Yesu Kirisita à fworo mpiimu i ke, pire mɛyi yi ɲyɛ ɲje: Yesu à fworo saanŋi Dawuda e, Dawuda s'à fworo Ibirayima tùluge e. ");
INSERT INTO spp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ɲyɛ Ibirayima à Ishaka si, ka Ishaka si Yakuba si, ka Yakuba si Zhuda ná u sìɲɛɛbii si, ");
INSERT INTO spp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ka Zhuda si Pɛrɛzi ná Zera si. (Pire nuŋi mɛge mpyi Tamari.) Ka Pɛrɛzi si Ɛsirɔn si, ka Ɛsirɔn si Aramu si, ");
INSERT INTO spp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ka Aramu si Aminadabu si, ka Aminadabu si Nashɔni si, ka Nashɔni si Salamani si, ");
INSERT INTO spp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ka Salamani si Bwazi si. (Uru nuŋi mɛge mpyi Arahabu.) Ka Bwazi si Obɛdi si. (Uru nuŋi mɛge mpyi Uruti.) Ka Obɛdi si Zhese si, ");
INSERT INTO spp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ka Zhese si saanŋi Dawuda si. Ka saanŋi Dawuda si Solomani si. (Uru nuŋi u mpyi Uri cwoŋi.) ");
INSERT INTO spp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ka Solomani si Oroboyamu si, ka Oroboyamu si Abiya si, ka Abiya si Azafu si. ");
INSERT INTO spp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ka Azafu si Zhozafati si, ka Zhozafati si Zhoramu si, ka Zhoramu si Oziyasi si. ");
INSERT INTO spp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ka Oziyasi si Zhoyatamu si, ka Zhoyatamu si Akazi si, ka Akazi si Ezekiyasi si, ");
INSERT INTO spp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ka Ezekiyasi si Manase si, ka Manase si Amɔni si, ka Amɔni si Zhoziyasi si, ");
INSERT INTO spp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ka Zhoziyasi si Zhekoniya ná u sìɲɛɛbii si. (Lire tèni i Babilɔn shiinbil'à Izirayɛli shiinbii kul'a kàre piye yyére.) ");
INSERT INTO spp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ɲyɛ pi à pi cye yaha Babilɔn i, ka pi i núr'a pa ke, ka Zhekoniya si Salatiyɛli si, ka Salatiyɛli si Zorobabɛli si, ka Zorobabɛli si Abiyudi si, ");
INSERT INTO spp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ka Abiyudi si Eliyakimu si, ka Eliyakimu si Azori si, ka Azori si Sadɔki si, ");
INSERT INTO spp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ka Sadɔki si Akimu si, ka Akimu si Eliyudi si, ka Eliyudi si Eliyazari si, ");
INSERT INTO spp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ka Eliyazari si Matan si, ka Matan si Yakuba si, ");
INSERT INTO spp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ka Yakuba si Yusufu si. Ɲyɛ Yusufu cwoŋi mɛge mpyi Mariyama. Uru u à Yesu si, ŋgemu pi maha yiri Kile Niɲcwɔnrɔŋi ke. ");
INSERT INTO spp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mà lwɔ́ Ibirayima tèni na mà pa nɔ saanŋi Dawuda wuuni na, tulyeye kɛ ná sicyɛɛr'à tòro. Mà lwɔ́ saanŋi Dawuda tèni na fo mà sà nɔ tèni i Babilɔn shiinbil'à Izirayɛli shiinbii kul'a kàre piye yyére ke, ka tulyeye kɛ ná sicyɛɛre si ntòro mú. Mà lwɔ́ Izirayɛli shiinbii tèecûni na Babilɔn shiinbil'á, mà sà nɔ Kile Niɲcwɔnrɔŋi tèesini na, ka tulyeye kɛ ná sicyɛɛre si ntòro mú. ");
INSERT INTO spp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ɲyɛ Yesu Kirisita siŋkanni l'à pyi nde: Mariyama u ɲyɛ u nuŋi ke, uru na mpyi Yusufu tàcwo. Ŋka mà jwo Yusufu u u lèŋɛ ke, u yacere wu u mpyi Kile Munaani sífente cye kurugo. ");
INSERT INTO spp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","U tànɔŋi Yusufu mpyi a tíi, u la ɲyɛ a mpyi si Mariyama mɛge kɛ̀ɛge mɛ. U la mpyi si u nàmbage fyìinnɛ ŋwɔhɔre e. ");
INSERT INTO spp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mà u yaha ná tire sɔ̀nŋɔre e, ka Kafooŋi Kile mɛ̀lɛkɛŋi wà si uye cyêe u na ŋɔɔge k'e, maa jwo: «Dawuda tùluge shinŋi Yusufu, ma hà raa fyáge si ma tàcwoŋi Mariyama lèŋɛ mɛ, ɲaha na yɛ yaceni li ɲyɛ u á ke, Kile Munaani sífente cye kurugo u à li ta. ");
INSERT INTO spp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U sí n‑pa si pùnambile, maa li mɛge le Yesu, ɲaha na yɛ uru u sí n‑pa u shiinbii kapegigii yàfa pi na, si pi shwɔ.» ");
INSERT INTO spp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɲcyii karigii pun'à pyi bà li si mpyi Kafooŋi Kile à u tùnntunŋi tun ná jwumpe mpemu i ke, puru si fûnŋɔ mɛ. U mpyi a jwo: ");
INSERT INTO spp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Yii lógo, pùcepyinɔcembaala sí n‑pa laa lwɔ́ si pùnambile si, uru pyàŋi mɛge sí n‑le Emanuwɛli» kuru mɛge ɲwɔhe ku ɲyɛ: «Kile ɲyɛ ná wuu e.» ");
INSERT INTO spp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ɲyɛ Yusufu à pa ɲɛ̀ ke, maa li pyi bà Kafooŋi Kile mɛ̀lɛkɛŋi mpyi a yi jwo mɛ, maa Mariyama lèŋɛ mà pyi u cwo. ");
INSERT INTO spp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ŋka u ɲyɛ a sínni ná Mariyama i mɛ, fo mà sà nɔ u tèetigeni na. U à tîge pùnambile, ka Yusufu si li mɛge le Yesu. ");
INSERT INTO spp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ɲyɛ Yesu à si Zhude kùluni i, Bɛtilɛhɛmu kànhe e. L'à pyi Saanŋi Erɔdi tèni i. Ka ɲcèfeebii pìi si yîri canŋafyinmpe e mà pa Zheruzalɛmu kànhe e, ");
INSERT INTO spp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","maa yíbe: «Yahutuubii saanŋi u à si numɛ ke, taa u ɲyɛ ke? Wuu à u woni ɲya mà wuu yaha canŋafyinmpe e. Lire e wuu à pa mpa u pêe.» ");
INSERT INTO spp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Saanŋi Erɔdi à puru jwumpe lógo ke, ka lire kani si u ná Zheruzalɛmu shiinbii puni funŋɔ wwòoŋɔ sèl'e. ");
INSERT INTO spp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ka u u Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii puni bínni maa pi yíbe na Kile Niɲcwɔnrɔŋi kyaa l'à jwo ke, taa ur'à yaa u si ke? ");
INSERT INTO spp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka pire si u pyi: «U à yaa u si Bɛtilɛhɛmu kànhe e, Zhude kùluni i. Yire Kile tùnntunŋ'à sémɛ na ");
INSERT INTO spp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Bɛtilɛhɛmu u ɲyɛ Zhude kùluni kànhe kà ke, kuru bà ku ɲyɛ Zhude kùluni kànyi puni nimbileni mà dɛ! Ɲaha kurugo yɛ ɲùŋufooŋi wà sí n‑pa fworo k'e, ŋgemu u sí n‑pyi mii sùpyire, Izirayɛli shiinbii ɲùŋɔ na ke.”» ");
INSERT INTO spp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ɲyɛ ka Erɔdi si ɲcèfeebii ŋwɔh'a yyere, maa pi yíbe na tèni ndire e won'à fworo yɛ. ");
INSERT INTO spp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɲyɛ lire kàntugo ka u u pi yaha a kàre Bɛtilɛhɛmu kànhe e, pi sà yíbe pyàŋi kyaa na sèl'e, pi aha u ɲya, pi i mpa yi jwo ur'á, uru sí n‑sà u pêe mú. ");
INSERT INTO spp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","U à puru jwo ke, ka ɲcèfeebii si ŋkàre. Pi mpyi a fyânha a woni ndemu ɲya canŋafyinmpe e ke, lire ninuun'à fworo pi yyaha na, maa pi yyaha cû. Cyage e pyàŋi mpyi ke, l'à nɔ wani ke, maa yyére kuru cyage nìɲyi na. ");
INSERT INTO spp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ɲcèfeebil'à li ɲya l'à yyére ke, ka pi funɲyi si sàa táan. ");
INSERT INTO spp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ka pi i jyè bage e, mà pyàŋi ná u nuŋi Mariyama ɲya, maa niŋkure sín maa pyàŋi pêe. Lire kàntugo maa pi yaayi ɲwɔ múgo, maa sɛɛn ná wusuna ná miri kan pyàŋ'á. ");
INSERT INTO spp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lire kàntugo ka Kile si yi jwo pi á ŋɔɔge k'e, na pi àha núru ŋkàre Erɔdi yyére mɛ. Ɲyɛ ka pi i kuni labɛrɛ lwɔ́ a kàre pi kìni i. ");
INSERT INTO spp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ɲyɛ ɲcèfeebii kareŋkwooni kàntugo, Kafooŋi Kile mɛ̀lɛkɛŋi wà à uye cyêe Yusufu na ŋɔɔge k'e, maa u pyi: «Yîri, maa pyàŋi ná u nuŋi lwɔ́, maa fî maa sì Misira kìni i, maa ntɛ̀ɛn wani fo mii aha mu pyi ma núru ma a ma tèni ndemu i ke, ɲaha na yɛ Erɔdi na pyàŋi caa raa bùu.» ");
INSERT INTO spp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ɲyɛ ka Yusufu si yîri numpilage e, maa pyàŋi ná u nuŋi lwɔ́ mà kàre Misira kìni i. ");
INSERT INTO spp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","U à kwôro wani fo saanŋi Erɔdi à pa ŋkwû. Lire pyiŋkanni na, nde Kafooŋi Kile mpyi a jwo u tùnntunŋi cye kurugo ke, lir'à fûnŋɔ. U mpyi a jwo: «Mii à na Jyaŋi yyer'a yige Misira kìni i.» ");
INSERT INTO spp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ɲyɛ saanŋi Erɔdi à pa li kàanmucya mà li ɲya na ɲcèfeebil'à uru ɲwɔhɔ yaha ke, ka u lùuni si yîri sèe sèl'e. Maa jwo na pùnampyire ti ɲyɛ Bɛtilɛhɛmu kànhe ná ku kwùumpe kànyi na, ná pi sàha ntòro yyee shuunni na mɛ, na pi pire puni bò, ɲaha na yɛ mà tàanna ná ɲcèfeebii jwumpe e, uru pyàŋi mpyi a yaa u ta cyire yyeegii shuunniŋi ɲwɔhɔntaan pùnampyire e. ");
INSERT INTO spp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nde Kile tùnntunŋi Zheremi mpyi a jwo ke, lir'à fûnŋɔ, u mpyi a jwo: ");
INSERT INTO spp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Mɛjwul'à fworo Arama kànhe e, myahigil'à sú maa yamɛɛni sú sèl'e. Arasɛli u ɲyɛ na u pyìibii yamɛɛni súu, u la ɲyɛ wà sì uru fɔ̀ɔnŋɔ mɛ, ɲaha na yɛ u pyìibil'à wíl'a fô.» ");
INSERT INTO spp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ɲyɛ saanŋi Erɔdi à pa ŋkwû ke, ka Kafooŋi Kile mɛ̀lɛkɛŋi wà si uye cyêe Yusufu na ŋɔɔge k'e, mà u yaha Misira kìni i. ");
INSERT INTO spp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","U à jwo Yusufu á: «Yîri ma a pyàŋi ná u nuŋi lwɔ́ ma a núru ma a sì Izirayɛli kìni i, ɲaha na yɛ mpii pi mpyi na pyàŋi caa raa bùu ke, pire saha ɲyɛ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ɲyɛ ka Yusufu si yîri maa pyàŋi ná u nuŋi lwɔ́ a núr'a kàre Izirayɛli kìni i. ");
INSERT INTO spp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ŋka Yusufu à pa lógo na Arikilasi à tɛ̀ɛn ɲùŋufente na Zhude kùluni i u tuŋi Erɔdi kwùŋkwooni kàntugo ke, ka lire si u pyi u u fyáge takarege e wani. Ɲyɛ ka Kile si núr'a jwo ná u e ŋɔɔge k'e. Ka u u yîri wani mà kàre Galile kùluni i, ");
INSERT INTO spp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","maa sà ntɛ̀ɛn kànhe kà na, kuru mɛge ɲyɛ Nazarɛti. Lire pyiŋkanni na, Kile tùnntunmpii jwump'à fûnŋɔ. Pi mpyi a jwo: «U sí raa yiri Nazarɛti shinŋi.» ");
INSERT INTO spp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ɲyɛ yyee niɲyahagil'à tòro ke, ka Yuhana Batizelipyiŋi si uye cyêe Zhude kùluni síwage e maa Kile jwumpe yu. ");
INSERT INTO spp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","U mpyi maha ŋko: «Kile Saanre tèn'à byanhara, yii yii toroŋkanni kɛ̂ɛnŋɛ.» ");
INSERT INTO spp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yuhana kyaa Kile tùnntunŋi Ezayi mpyi a jwo, tèni i u à jwo na: «Sùpya mɛjwuu na fwore síwage e fànha na “Yii kuni yaa Kafooŋi mɛɛ na, yii kumpyɛrɛ nintiire yaa u á.”» ");
INSERT INTO spp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ɲyɛ Yuhana vàanntinŋke mpyi a yaa ná ɲwɔhɔŋi shire e, u mpyi a uye pwɔ ná seepwɔge e. U ɲjyìŋi mpyi kampɛɛnɲyi ná tuwyiyi sɛɛre. ");
INSERT INTO spp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Zheruzalɛmu kànhe shiinbii ná Zhude kùluni kànyi sanɲyi shiinbii puni ná Zhurudɛn baŋi taan shiinbii puni mpyi maha fwore na sì u yyére. ");
INSERT INTO spp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Maa ntɛ̀n li taan na pire kapyiiŋkii ɲyɛ a tíi mɛ, Yuhana sí i pi batizeli Zhurudɛn baŋi lwɔhe e. ");
INSERT INTO spp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farizhɛɛnbii ná Sadusiibii niɲyahara mpyi na ma si mpa piye batize u yyére. Yuhana à pire ɲya pi i ma ke, maa jwo: «Yii màcwɔn fiige sùpyiibii, jofoo u à yii pyi na batizeliŋi kanni sí n‑jà yii shwɔ Kile lùyirini nimpani na yɛ? ");
INSERT INTO spp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yii a katiigii pyi, lire sí li cyêe na yii zòompil'à kɛ̂ɛnŋɛ. ");
INSERT INTO spp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yii àha ŋkwɔ̀ raa sɔ̂nŋi na li tɛgɛni li ɲyɛ yii tulyage ku ɲyɛ Ibirayima mà dɛ! Ɲaha na yɛ mii sí yi jwo yii á, Kile sí n‑jà ɲje kafaayi kɛ̂ɛnŋɛ n‑pyi Ibirayima ɲampyire. ");
INSERT INTO spp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yii li cè na kaciig'à cél'a yaha cire ndìre taan. Cige maha cige ku ɲyɛ ku ɲyɛ na yasɛrɛ niɲcɛnnɛ seni mɛ, kuru sí n‑kwɔ̀n n‑wà nage e. ");
INSERT INTO spp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mii wi ke, mii na yii batizeli lwɔhe e si li cyêe na yii toroŋkann'à kɛ̂ɛnŋɛ, ŋka wà sí n‑pa mii kàntugo, uru tayyéreg'à fànha tò mii woge na. Ali mà u tanhaɲyi mɛɛre sànha, mii ɲùŋk'à cyɛ́rɛ lire mpyiŋi i. Uru u sí n‑pa raa yii batizeli ná Kile Munaani ná nage e. ");
INSERT INTO spp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","U ntanhe ɲyɛ u cye e, u u u sùmaŋi nimbwɔnŋi fwu. U sí u sùmapyaŋi le bwùunni i, si sìmwɔhɔŋke súugo nafugombaage e.» ");
INSERT INTO spp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ɲyɛ ka Yesu si yîri Galile kùluni i, mà kàre Yuhana yyére Zhurudɛn baŋi ɲwɔge na, si sà uye kan u batize. ");
INSERT INTO spp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ŋka Yuhana la mpyi si ɲcyé maa u pyi: «Mu u à yaa mu u mii batize, ka mu u núr'a pa mii á la?» ");
INSERT INTO spp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ka Yesu si u pyi: «Bà mii à yi jwo mɛ, ɲɛɛ wuu u yi pyi amuni numɛ, ɲaha na yɛ lire cye kurugo wuu sí Kile jwumpe kuni ɲaara si nɔ li tɛgɛni na.» Ɲyɛ ka Yuhana si ɲɛɛ maa u batize. ");
INSERT INTO spp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu à batize a kwɔ̀ ke, maa ntíl'a fworo lwɔhe e. Lire tèenuuni i, ka nìɲyiŋi si múgo. Ka u u Kile Munaani ɲya li i ntîri mpánmpɔrɔgɔ fiige, mà pa ntɛ̀ɛn u na, ");
INSERT INTO spp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ka mɛjwuu si fworo nìɲyiŋi i na: «Ŋge u ɲyɛ mii Jyaŋi, u kan'à waha mii na sèl'e, u kapyiiŋkil'à táan mii á mú.» ");
INSERT INTO spp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lire kàntugo ka Kile Munaani si Yesu yyaha cû mà kàre síwage e, bà Sitaanniŋi si mpyi si u sɔ̀n ŋgíi kampyi u sí ɲɛɛ kapii pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ka u u súnŋi le a ta canmpyaa beeshuunni ná numpiliyi beeshuunni, ka katege si nta a u ta. ");
INSERT INTO spp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sitaanniŋi u maha zɔ̀nŋi pyi ke, ka uru si file u na maa jwo: «Ná Kile Jyaŋi sí u ɲyɛ mu, yi jwo ɲje kafaay'á na yi kɛ̂ɛnŋ'a pyi bwúuru.» ");
INSERT INTO spp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ka Yesu si u pyi: «Y'à sémɛ Kile Jwumpe Semɛŋi i na “Yalyire kanni bà ti ɲyɛ na sùpyaŋi ɲwɔ caa mɛ, ŋka jwumpe puni pu ɲyɛ na fwore Kile ɲwɔge e ke.”» ");
INSERT INTO spp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ɲyɛ lire kàntugo ka Sitaanniŋi si ŋkàre ná Yesu i Kile kànhe niɲcwɔnrɔge Zheruzalɛmu i, maa sà dùgo ná u e Kileɲaarebage ɲùɲcyage e, ");
INSERT INTO spp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","maa jwo: «Ná Kile Jyaŋi sí u ɲyɛ mu, kwɔ̀n a cwo ɲìŋke na, ɲaha na yɛ y'à sémɛ Kile Jwumpe Semɛŋi i na “Kile sí u mɛ̀lɛkɛɛbii pyi pi mu cwɔhɔ ná pi cyeyi i, bà li si mpyi kafaaga kà ŋkwɔ̀ mu tɔɔge kà bânni mɛ.”» ");
INSERT INTO spp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ka Yesu si u pyi: «Y'à sémɛ Kile Jwumpe Semɛŋi i mú na “Ma hà raa ma Kafooŋi Kile ɲwɔ cwôre mɛ.”» ");
INSERT INTO spp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lire kàntugo ka Sitaanniŋi si ŋkàre ná Yesu i ɲaŋke kà nintɔɔnntɔɔngɔ ɲuŋ'i, maa diɲyɛŋi kìrigii puni nàfuuŋi cyêe u na, ");
INSERT INTO spp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","maa jwo: «Mu aha ɲɛn'a niŋkure sín mii á maa mii pêe, mii sí ɲcyii kìrigii ɲùŋufente puni kan mu á.» ");
INSERT INTO spp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ɲyɛ ka Yesu si jwo «Sitaanna wà we, yîri na taan! Y'à sémɛ Kile Jwumpe Semɛŋi i na “Ta ma niŋkure sínni ma Kafooŋi Kile á, ma a uru kanni pêre.”» ");
INSERT INTO spp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɲyɛ lir'à pyi ke, ka Sitaanniŋi si láha Yesu na, ka Kile mɛ̀lɛkɛɛbii pìi si file u na, yaayi kyaa li mpyi u na ke, maa yire kan u á. ");
INSERT INTO spp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ɲyɛ Yesu à pa lógo na pi à Yuhana Batizelipyiŋi cû a le kàsuŋi i ke, ka u u núr'a kàre Galile kùluni i. ");
INSERT INTO spp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ŋka u ɲyɛ a sà ntɛ̀ɛn Nazarɛti kànhe e mɛ, maa ŋkàr'a sà ntɛ̀ɛn Kapɛrɛnamu kànhe e. Kuru kànhe na ɲyɛ baŋi ɲwɔge na, Zabulɔn ná Nɛfitali taare e. ");
INSERT INTO spp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɲyɛ lire pyiŋkanni na, ka Kile tùnntunŋi Ezayi jwumpe si fûnŋɔ. U mpyi a jwo: ");
INSERT INTO spp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zabulɔn tùluge taare ná Nɛfitali tùluge taare, ti ɲyɛ Galile kùluni i, baŋi ɲwɔge na, Zhurudɛn baŋi canŋacwumpe e ke, Yahutuubii ná supyishiŋi sanŋi shiinbii, pi à tɛ̀ɛn t'e ke, ");
INSERT INTO spp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","pire mpyi numpini i, bɛ̀ɛnmɛ nimbwom'à fworo pi á, pi mpyi a tɛ̀ɛn kùluni i, kwùŋi numpini i, bɛ̀ɛnmɛ nimbwom'à fworo pi á.» ");
INSERT INTO spp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mà lwɔ́ lire tèni na, ka Yesu si li ɲwɔ cû na Kile jwumpe yu, maa yi yu sùpyir'á na: «Kile Saanre tèn'à byanhara, yii yii toroŋkanni kɛ̂ɛnŋɛ.» ");
INSERT INTO spp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Canŋka mà Yesu yaha u u ɲaare Galile baŋi ɲwɔge na, u à sìɲɛɛ shuunni ɲya, Simɔ pi maha mpyi Pyɛri ke, ná Andire. Pi mpyi na cwòo wàa baŋi i. Fyácyaa pi mpyi pi pi. ");
INSERT INTO spp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ka Yesu si pi pyi: «Yii taha na fye e. Bà yii na fyaabii caa mɛ, mii sí yii taanna, yii raa sùpyire caa t'a ma mii á.» ");
INSERT INTO spp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ka pi i ntíl'a pi cwòobii yaha, maa ntaha Yesu fye e. ");
INSERT INTO spp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ɲyɛ pi à ta naha vili yyaha na sahaŋki ke, ka Yesu si núr'a sìɲɛɛ shuunni ɲya, pire pi mpyi Zebede jyaabii Yakuba ná Yuhana. Pi ná pi tuŋi Zebedi mpyi a tɛ̀ɛn bakwɔɔge funŋke e, na pi cwòobii takɛgɛyi yaa. Ka Yesu si pi yyere, ");
INSERT INTO spp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ka pi i ntíl'a kàntugo wà bakwɔɔge ná pi tuŋi na, maa ntaha u fye e. ");
INSERT INTO spp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu à Galile kùluni puni ɲaara, u mpyi maha sùpyire kâlali Kile Jwumpe kàlambayi i, maa Jwumpe Nintanmpe yu pi á mà yyaha tíi ná Kile Saanre e. U mpyi maha yampii puni ná cwɔ̀hɔmɔfeebii puni cùuŋi pi shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Lire e u mɛge mpyi a fworo Siri kìni puni i. Pi mpyi maha sì ná yampii shiŋi puni i u yyére: cifwure feebii ná jínacyaanbii ná kìrikirisanŋi feebii ná supyimuruɲyi. Yesu mpyi maha pire puni cùuŋi. ");
INSERT INTO spp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Supyikuruŋɔ nimbwɔhɔ mpyi maha ntaha u fye e, tire sùpyire na mpyi Galile shiin ná Dekapoli kùluni shiin ná Zheruzalɛmu kànhe ná Zhude kùluni sanni shiin ná Zhurudɛn baŋi kàmpanŋke sanŋke shiin. ");
INSERT INTO spp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ɲyɛ Yesu à kuru supyikuruŋke ɲya ke, maa dùg'a tɛ̀ɛn ɲaŋke kà na. Ka u cyelempyiibii si file u na. ");
INSERT INTO spp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ka u u jwumpe lwɔ́ maa sùpyire kâlali na: ");
INSERT INTO spp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Mpii pi à pi fànhaɲcyɛrɛre cè Kile kàmpanŋke na ke, pire wuun'à ɲwɔ, ɲaha na yɛ Kile Saanre ɲyɛ pire woro. ");
INSERT INTO spp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mpii pi ɲyɛ na myahii súu ke, pire wuun'à ɲwɔ, ɲaha na yɛ Kile sí n‑pa pi fɔ̀ɔnŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mpii pi ɲyɛ ɲùmpiŋɛfee ke, pire wuun'à ɲwɔ, ɲaha na yɛ ɲìŋke ɲwɔmɛɛni Kile à lwɔ́ ke, kuru sí n‑kan pi á kɔɔgɔ. ");
INSERT INTO spp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ntìiŋi lage ɲyɛ mpiimu na bà ɲjyìŋi ná lwɔhe lage maha mpyi wà na mɛ, pire wuun'à ɲwɔ, ɲaha na yɛ pi sí n‑pa n‑tìn. ");
INSERT INTO spp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mpii pi ɲyɛ na ɲùɲaara taa sùpyire sannte na ke, pire wuun'à ɲwɔ, ɲaha na yɛ Kile sí n‑pa ɲùɲaara ta pi na. ");
INSERT INTO spp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mpii pi ɲyɛ ná zòvyinre e ke, pire wuun'à ɲwɔ, ɲaha na yɛ pi sí n‑pa Kile ɲya. ");
INSERT INTO spp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mpii pi ɲyɛ na sìsure leni sùpyire shwɔhɔl'e ke, pire wuun'à ɲwɔ, ɲaha na yɛ Kile sí n‑pa raa pi yiri uru pyìibii. ");
INSERT INTO spp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mpii sùpyire ɲyɛ na ŋkyérege pi Kile ɲwɔmɛɛcuni kurugo ke, pire wuun'à ɲwɔ, ɲaha na yɛ Kile Saanre ɲyɛ pire woro. ");
INSERT INTO spp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Sùpyire na yii mpiimu cyere, marii yii kyérege, marii kafinare ná jwumpimpe shiŋi puni yu yii na, mii mɛge kurugo ke, yii wuun'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lire ká mpyi, yii a yógore, yii i mpyi funntange e, ɲaha na yɛ Kile à sàra nimbwo bégel'a yaha yii mɛɛ na nìɲyiŋi na. Kile tùnntunmpii pi à tòro yii yyaha na ke, amuni pi à pire kyérege. ");
INSERT INTO spp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yii pi ɲyɛ diɲyɛŋi suumpe. Ɲyɛ suumpe tìpoompe ká fworo p'e, ɲaha ku sí n‑jà pu pyi pu táan sahaŋki yɛ? Pu saha sì n‑jà yafyin ɲwɔ mɛ, pu sí n‑wà cyíinŋi na, sùpyire s'a pu tánhani. ");
INSERT INTO spp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yii pi ɲyɛ diɲyɛŋi bɛ̀ɛnmpe. Kànhe k'à tɛ̀ɛn ɲaŋa ɲuŋ'i ke, kuru sì n‑jà ŋwɔhɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wà ɲyɛ na fùkina mîni si u le ɲcyígile cere ɲwɔh'i mɛ. Ŋka u maha dùrugo yaage kà ɲuŋ'i, bà u bɛ̀ɛnmpe si mpyi s'a nɔni bage shiinbii puni na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lire pyiŋkanni na, yii bɛ̀ɛnmp'à yaa p'a ɲî sùpyire puni ɲyii na, pi raa yii kacɛnŋkii ɲaa, s'a yii Tuŋi nìɲyi wuŋi pêre. ");
INSERT INTO spp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yii àha raa sɔ̂nŋi na mii à pa mpa Kile tùnntunŋiMusaSaliyaŋi ná Kile tùnntunmpii sanmpii jwumpe fyìinnɛ mɛ. Mii ɲyɛ a pa mpa pu fyìinnɛ mɛ, ŋka mii à pa mpa pu fûnŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sèeŋi na mii sí yi jwo yii á, fo mà sà nìɲyiŋi ná ɲìŋke kwɔ̀, Saliyaŋi sémɛŋi gyanrampe pà, lire ɲyɛ mɛ u sémɛbilini là sì n‑sìi n‑pînni mɛ, fo mà sà nɔ karigii puni tɛgɛni na. ");
INSERT INTO spp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lire e ke shin maha shin ká ŋge Saliyaŋi tabilere niŋkin kɛ̀ɛgɛ, maa sùpyire sannte leni lire kumpiini i ke, urufoo u sí n‑pyi Kile Saanre shiinbii puni nimbileni. Ŋka shinŋi u ɲyɛ na uru Saliyaŋi kurigii ɲaare marii sùpyire sannte taanni u na ke, urufoo sí n‑pyi shinbwo Kile Saanre e. ");
INSERT INTO spp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mii sí yi jwo yii á, yii aha mpyi yii ɲyɛ na Kile Saliyaŋi kurigii ɲaare mà tòro Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii na mɛ, yii sì n‑jà n‑jyè Kile Saanre e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yii à yi lógo na y'à jwo yii tulyey'á na “Ma hà sùpya bò mɛ. Shin maha shin u à sùpya bò ke, urufoo sí n‑yíbe lire na.” ");
INSERT INTO spp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mii wi ke, mii sí yi jwo yii á, shin maha shin u à u lùu yîrige u shinɲɛɛ taan ke, urufoo sí n‑yíbe lire na. Ŋgemu ká u shinɲɛɛ pyi “Sìɲcoŋɔ!” ke, yukyaala kuruŋke sí urufoo yíbe. Ŋgemu ká u shinɲɛɛŋi pyi “Sìcyerefoo!” ke, urufol'à yaa u wà nafugombaage e. ");
INSERT INTO spp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lire e ke mu aha a si sáraga wwû Kile á, ka li i ntîge mu funŋ'i na mu shinɲɛɛŋi wà à mu la wwû, ");
INSERT INTO spp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tíl'a sárage yaayi yaha sárayi tawwuge taan ma a núr'a sà jwo a bɛ̂ ná urufol'e, ma a nta a pa ma sárage wwû. ");
INSERT INTO spp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wà ha mu yyere fànhe e, ka yii i wá na ŋkɛ̀ɛge wani, mu à yaa mu u jwumabeŋɛ cya fwɔfwɔ ná urufol'e kuni na, bà u si mpyi u àha ma le yukyaaŋi cye e, uru si ma le u báarapyiŋi cye e, pi i ma le kàsuŋi i mɛ. ");
INSERT INTO spp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sèeŋi na mii sí yi jwo mu á, mu aha mpyi mu ɲyɛ a lire pyi mɛ, mu sì n‑sìi n‑fworo wani ná mu ɲyɛ a urufoo fwooni tò feefee mà yɛ! ");
INSERT INTO spp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yii à yi lógo na y'à jwo “Ma hà zínni ná wabɛrɛ cwo e mɛ.” ");
INSERT INTO spp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mii wi ke, mii sí yi jwo yii á, shin maha shin u à ceewe wíi fo ká tasinnage wuuni si sà ntîge urufoo funŋ'i ke, urufol'à jacwɔrɔ pyi a kwɔ̀ ná u e u zòmbilini na. ");
INSERT INTO spp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mu kàniŋɛ ɲyibilini ká a si mu pyi mu u kapii pyi, li wwûl'a wà tatɔɔnge e. Ɲaha na yɛ mu u mpɔ̂ɔn ma cyeere cyage kà niŋkin i, lire sí n‑pwɔ́rɔ mu á pi mu cyeere puni wà nafugombaage e. ");
INSERT INTO spp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mu kàniŋɛ cyɛge ká a si mu pyi mu u kapii pyi, ku kwɔ̀n a wà tatɔɔnge e. Ɲaha na yɛ mu u mpɔ̂ɔn ma cyeere cyage kà niŋkin i, lire sí n‑pwɔ́rɔ, mu cyeere puni ti ŋkwɔ̀ a sà jyè nafugombaage e. ");
INSERT INTO spp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Y'à jwo mú na “Ŋgemu ká u cwoŋi nàmbage kwɔ̀ ke, urufol'à yaa u cíyaha sémɛ kan u á.” ");
INSERT INTO spp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ŋka mii sí yi jwo yii á, shin maha shin u à u cwoŋi nàmbage kwɔ̀, mà li ta jacwɔrɔ ɲùŋɔ taan bà u à ku kwɔ̀ mɛ, li maha mpyi mu à jwo urufol'à kuni kan u á, u a jacwɔɔre pyi. Shin maha shin u à ciyahawa lèŋɛ ke, urufoo mú à jacwɔrɔ pyi. ");
INSERT INTO spp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yii mú à yi lógo na y'à jwo yii tulyey'á na “Ma hà raa ŋkâre tawage e mɛ, ŋka mu aha ɲwɔfaaga fáa Kafooŋi Kile á, mu à yaa mu u ku wwû.” ");
INSERT INTO spp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ŋka mii sí yi jwo yii á, yii ɲyɛ a yaa yii a ŋkâre punɔ punɔ mɛ. Yii àha raa ŋkâre nìɲyiŋi na mɛ, ɲaha na yɛ uru u ɲyɛ Kile fànhe tatɛɛnge. ");
INSERT INTO spp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yii àha raa ŋkâre ɲìŋke na mú mɛ, ɲaha na yɛ kuru ku ɲyɛ u tooyi tatahage. Yii àha ŋkwɔ̀ ŋkâa Zheruzalɛmu kànhe na mɛ, ɲaha na yɛ kuru ku ɲyɛ “Saanbwɔhe kànhe.” ");
INSERT INTO spp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yii àha raa ŋkâre yii ɲùɲyi na mɛ, ɲaha na yɛ yii wà sì n‑jà u ɲùɲjuŋke kà niŋkin kɛ̂ɛnŋɛ mpyi nivyinge, lire ɲyɛ mɛ niŋgwɔhɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kani ndemu ká mpyi “Ɔɔn” kyaa ke, yii jwo “Ɔɔn” ndemu sí ká mpyi “Ɔnhɔ” wuu ke, yii jwo “Ɔnhɔ” kàaga baa. Mpemu ká ntaha puru na ke, pur'à fworo Sitaanniŋi i. ");
INSERT INTO spp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yii à yi lógo na y'à jwo “Wà ha wà ɲyii jya, urufoo wuuni mú à yaa li jya, wà ha wà ŋkyàan wwû, urufoo wuuni mú à yaa li wwû.” ");
INSERT INTO spp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ŋka mii sí yi jwo yii á, wà ha kawaa pyi yii na, yii àha li ŋkooŋi wwû u na mɛ. Wà ha kantawaa bwɔ̀n mu mùmpɛnge k'e, ku sanŋke kɛ̂ɛnŋɛ urufol'á. ");
INSERT INTO spp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Wà la ká mpyi si mu yyere fànhe yyére si mu vàanntinmbileni shwɔ mu na, ma vàanntinmbwɔhe kan u á mú. ");
INSERT INTO spp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wà ha tuguro kárama a tɛ̀gɛ mu ɲuŋ'i mà sà yaha culumɛtiri niŋkin na, ti tugo mà sà yaha culumɛtirii shuunni na, ná urufol'e. ");
INSERT INTO spp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wà ha mu ɲáare, urufoo kan. Wà ha mu cyeyaaga ɲáare si là pyi ná k'e si núru mpa ku kan mu á, ma hà ɲcyé mɛ. ");
INSERT INTO spp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yii à yi lógo na y'à jwo “Mu kyal'à táan ŋgemu á ke, na ma uru kyaa táan may'á, mu kyal'à pɛn ŋgemu á ke, maa uru kyaa pɛn may'á.” ");
INSERT INTO spp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ŋka mii sí yi jwo yii á, yii yii zàmpɛɛnbii kyaa táan yiy'á, yii raa Kile ɲáare yii kyéregefeebil'á. ");
INSERT INTO spp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Lire e yii sí n‑pyi yii Tuŋi nìɲyi wuŋi pyìi. Ɲaha na yɛ uru u maha canŋaɲyiini pyi li i fwore shinpiibii ná shincɛnmpil'á, maa zànhe kaan shintiibii ná shintiimbaabil'á. ");
INSERT INTO spp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yii kyal'à táan mpiimu á ke, yii aha pire kanni kyaa táan yiy'á, sàraŋi ŋgire yii sí n‑ta lire e Kile yyére yɛ? Múnalwɔɔre shwofeebii mú ɲyɛ na lire pyi mà? ");
INSERT INTO spp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yii aha a yii cìnmpyiibii kanni shɛ́ɛre, lire ɲyɛ kakyanhala kyaa la? Kilecembaabii mú ɲyɛ na lire pyi mà? ");
INSERT INTO spp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Lire e ke yii pyi tìgire cyaga baa, yii Tuŋi nìɲyi wuŋi fiige. ");
INSERT INTO spp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yii a yiye kàanmucaa, yii àha raa kacɛnŋkii pyi sùpyire ɲyiɲyage na mɛ. Lire baare e yii sì sàra ta yii Tuŋi nìɲyi wuŋ'á mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Lire e mu aha a si bùɲyɛ pyi fòŋɔfooŋi wà na, mpii pi à fyìnmɛ tò wwomɔ na ke, ma hà li pyi pire fiige mɛ. Pi maha tùnmpe pyi maa piye cyêre Kile Jwumpe kàlambayi ná kànhe kaŋgwɔrɔ tatɛɛnyi i, bà sùpyire si mpyi s'a pi mɛtange yiri mɛ. Ŋka sèeŋi na mii sí yi jwo yii á, pir'à pi sàraŋi ta a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ŋka mu aha si bùɲyɛ pyi wà na, mu kàmɛnɛ cyɛge ɲyɛ a yaa ku mu kàniŋɛ cyɛge kapyiini cè mɛ, ");
INSERT INTO spp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","bà mu bùɲyɛŋi si mpyi si ŋwɔhɔ mɛ. L'aha mpyi amuni, mu Tuŋi u ɲyɛ na kaŋwɔhigii ɲaa ke, uru sí mu sâra. ");
INSERT INTO spp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yii aha a si raa Kile ɲáare, mpii pi à fyìnmɛ tò wwomɔ na ke, yii àha raa li pyi pire fiige mɛ. Na yyéreli Kile Jwumpe kàlambayi ná kuŋgarigil'e maa Kile ɲáare, bà sùpyire si mpyi s'a pi ɲaa mɛ, lire l'à táan pi á. Ŋka sèeŋi na mii sí yi jwo yii á, pir'à pi sàraŋi ta a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mu wi ke, mu aha a si raa Kile ɲáare, jyè ma bage funŋke e maa ku tò, maa ma Tuŋi Kile ɲáare kuru taŋwɔhɔge e. Lire ká mpyi, mu Tuŋi u ɲyɛ taŋgwɔhɔge e, maa karigii niŋwɔhigii puni ɲaa ke, uru sí mu sâra. ");
INSERT INTO spp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mu aha a Kile ɲáare, ma hà raa núruli jwumpe kurugo, bà Kilecembaabii maha li pyi mɛ. Ɲaha na yɛ pi maha sɔ̂nŋi na pire jwuɲyahampe pu sí Kile yaha u pire ɲarege shwɔ. ");
INSERT INTO spp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lire e yii àha mpyi pi fiige mɛ. Yii li cè na yaage ŋkemu kyaa ku ɲyɛ yii na ke, mà jwo yii pi ku ɲáare ke, yii Tuŋi Kile maha ku cè. ");
INSERT INTO spp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lire e ke yii aha a Kile ɲáare, yii jwo “Wuu Tuŋi u ɲyɛ nìɲyiŋi na ke, mu mɛge ku táan. ");
INSERT INTO spp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma pyi saanwa sùpyire puni ɲùŋɔ na. Mu ɲyii wuuni li pyi ɲìŋke na, bà li ɲyɛ na mpyi nìɲyiŋi na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wuu niɲjaa ɲjyìŋi kan wuu á. ");
INSERT INTO spp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wuu kapegigii yàfa wuu na, bà wuu maha wuu shinɲɛɛbii wogigii yàfani pi na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma hà yaaga yaha ku wuu yyaha kɛ̂ɛnŋɛ kapegil'á mɛ, maa wuu shwɔ Sitaanniŋi na. Ɲaha na yɛ mu u ɲyɛ fànhe ná síŋi ná pèentefoo, fo tèekwombaa. Amiina.” ");
INSERT INTO spp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yii li cè na sùpyir'à kapegigii ɲcyiimu pyi yii na ke, yii aha cyire yàfa ti na, yii Tuŋi nìɲyi wuŋi mú sí yii wogigii yàfa yii na. ");
INSERT INTO spp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ŋka yii aha mpyi yii ɲyɛ na ɲɛɛg'a sùpyire kapegigii yàfa ti na mɛ, yii Tuŋi mú sì yii wogigii yàfa yii na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yii aha súnŋi le, mpii pi à fyìnmɛ tò wwomɔ na ke, yii àha yyahayi tanha pire fiige mɛ, pire maha li pyi sùpyire si ɲcè na pi à súnŋi le. Ŋka sèeŋi na mii sí yi jwo yii á, pir'à pi sàraŋi ta a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mu wi ke, mu aha súnŋi le, ma yyahe jyé, maa làtikolo le ma ɲùŋke e, ");
INSERT INTO spp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bà sùpyire si mpyi t'àha ŋkwɔ̀ mu súnleni cè mɛ, fo mu Tuŋi u ɲyɛ taŋwɔhɔyi i ke, uru kanni. Lire ká mpyi, mu Tuŋi u ɲyɛ na kaŋwɔhigii ɲaa ke, uru sí mu sâra. ");
INSERT INTO spp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yii àha raa nàfuuŋi caa raa bégeli yiye mɛɛ na ɲìŋke na mɛ. Ntɔɔnŋi ná zúnŋi maha u kɛ̀ɛge, nàŋkaabii maha bayi fúruge marii u lwúu. ");
INSERT INTO spp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ŋka yii nàfuu tabegege niɲcɛnŋɛ yaa yiye mɛɛ na nìɲyiŋi na. Wani ntɔɔnŋi ná zúnŋi ɲyɛ na nàfuu kɛ̀ɛge mɛ, nàŋkaabii mú ɲyɛ na u lwúu mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ɲaha na yɛ cyage e sùpyaŋi nàfuuŋi ɲyɛ ke, wani u sɔ̀nŋɔre maha mpyi. ");
INSERT INTO spp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sùpyaŋi ɲyiigii cyi ɲyɛ u bɛ̀ɛnmpe. Ŋgemu u ɲyii cyi à ɲwɔ ke, urufoo puni maha mpyi bɛ̀ɛnmpe e mú. ");
INSERT INTO spp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ŋgemu wogigii sí cyi à kɛ̀ɛge ke, urufoo puni mú maha mpyi numpini i. Mu aha jwo na mu na ɲyɛ bɛ̀ɛnmpe e, mà li ta numpini i mu ɲyɛ, tahala maha ntaha lire numpini na! ");
INSERT INTO spp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yii li cè na báarapyiŋi sì n‑sìi n‑jà raa báare ɲùŋufee shuunn'á mɛ. Lire ká mpyi, u sí ɲùŋufooŋi wà kyaa táan uy'á, si u sanŋi kyaa pɛn uy'á. U mú sí n‑kúu wà na, si kàntugo wà u sanŋi na. Ɲyɛ amuni li ɲyɛ, nàfuuŋi lag'à tatɛɛngɛ fô yii mpiimu na ke, yii sì n‑jà n‑pyi Kile báarapyii mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Lire e mii sí yi jwo yii á, yalyire yii sí raa lyî, ná vàanɲyi yii sí raa leni ke, yire taŋkanni kà yii funŋɔ pɛn mɛ. Tá sùpyaŋi múnaani tayyérege ɲyɛ a fànha tò yalyire na, ka u cyeere tayyérege mú si fànha tò vàanɲyi na mɛ? ");
INSERT INTO spp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yii saɲcyɛɛnre wíi kɛ! Ti ɲyɛ na ɲɛɛmɛ núru mɛ, ti ɲyɛ na sùma kwùun mɛ, ti ɲyɛ na sùma bégeli bwùunni i mɛ. Ŋka yii Tuŋi u ɲyɛ nìɲyiŋi na ke, uru na ti ɲwɔ caa. Tá yii ɲyɛ a pwɔ́rɔ saɲcyɛɛnre na sèl'e mɛ? ");
INSERT INTO spp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Funmpɛɛnre sí n‑jà yii jofoo pyi u jà a nimbilere bâra u shìŋi canmpyaagii na yɛ? ");
INSERT INTO spp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ɲaha na yii à vàanɲyi nindeyi kani tɛ̀g'a yiye funŋɔ pɛn yɛ? Yafwɔhɔfwɔhɔyi yi maha fyîn sige e maa yafyɛɛnre nisinante yaa ke, yii sɔ̂nŋɔ yire kyaa na kɛ! Yi ɲyɛ na báara pyi mɛ, yi mú ɲyɛ na kòonɔ pînni mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ŋka saanŋi Solomani ná u nàfuufente puni i, u vàanndeŋke kà lemɛ ɲyɛ a jà a ɲwɔ mà ŋke yafwɔhɔfwɔhɔge kà niŋkin yafyɛnrɛ kwɔ̀ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yafwɔhɔfwɔhɔyi yi ɲyɛ sige e niɲjaa, ná nùmpanŋa yi sí n‑le nage e ke, Kile ká yire lemɛ pyi p'à ɲwɔ amuni, yii ɲyɛ a li cè na nàkaana baa Kile sí vàanya kan yii á mà? Yii dániyaŋ'à cyɛ́rɛ dɛ! ");
INSERT INTO spp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ɲyɛ yii àha funɲyi pɛn s'a ŋko “Ɲaha wuu sí n‑lyî yɛ? Ɲaha wuu sí n‑bya yɛ? Taa wuu sí vàanya ta n‑le ke?” mɛ. ");
INSERT INTO spp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kilecembaabii pi maha funɲyi pɛn ná yire yaayi kani i tèrigii puni i. Yii sí pi ke, yaaga maha yaaga kyaa li ɲyɛ yii na ke, yii Tuŋi Kile à yire puni cè. ");
INSERT INTO spp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mà jwo yii a yire yaayi caa ke, yii yacyage niɲcyiig'à yaa ku pyi Kile Saanre ná ntìiŋi. Lire ká mpyi, Kile sí yire yaayi sanɲyi puni kan yii á. ");
INSERT INTO spp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yii àha karigii nimpaaŋkii tɛ̀gɛ yiye funŋɔ pɛn mɛ, ɲaha na yɛ nùmpanŋke sí raa sɔ̂nŋi kuye na. Canŋa maha canŋa ná ku kawaagii cyi ɲyɛ. ");
INSERT INTO spp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yii àha raa pi sanmpii cɛ̂ɛge mɛ, lire ká mpyi Kile mú sì yii cɛ̂ɛge mɛ. ");
INSERT INTO spp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ɲaha na yɛ bà yii na sùpyire sannte cɛ̂ɛge mɛ, amuni Kile mú sí yii cɛ̂ɛgɛ. Cùŋkanni na yii ɲyɛ na sùpyire sannte cwôre ke, amuni Kile mú sí yii cû. ");
INSERT INTO spp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ɲaha na mu ɲyɛ na ɲyɛ̀sɛnni ɲaa ma cìnmpworoŋi ɲyiini i, mà li ta bànnaŋi u ɲyɛ mu wuuni i ke, mu ɲyɛ na uru ɲaa mà yɛ? ");
INSERT INTO spp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mà tàanna ná lire e, di mu sí n‑jà n‑jwo ma cìnmpworoŋ'á na u yyére ma a ɲyɛ̀sɛnni wwû u ɲyiini i, mà li ta bànnaŋi ɲyɛ mu wuuni i yɛ? ");
INSERT INTO spp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mu u à fyìnmɛ tò wwomɔ na ke, fyânha a bànnaŋi wwû ma ɲyiini i, lire ká mpyi, mu sí raa ɲaa raa ɲcwúu ɲyɛ̀sɛnni tawwuge e ma cìnmpworoŋi ɲyiini i. ");
INSERT INTO spp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yaayi yi ɲyɛ Kile wuyo ke, yii àha raa yire kaan pwuunbil'á mɛ, lire baare e pi sí n‑jà n‑yîri yii kurugo si yii sulugo. Yii àha raa yii kɔ́ɔnŋi loŋgara wuŋi cyáan caabii taan mɛ, lire baare e pi sí raa u tánhani. ");
INSERT INTO spp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yii a Kile ɲáare, u sí yii kan, yii a ɲcaa, yii sí n‑ta, yii a bàrage kúuli, ku sí múgo yii á. ");
INSERT INTO spp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yii li cè na shin maha shin u ɲyɛ na ɲáare ke, uru maha ntaa. Shin maha shin u ɲyɛ na ɲcaa ke, uru maha ɲaa. Shin maha shin ká bàrage kúu ke, ku sí múgo urufol'á. ");
INSERT INTO spp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Jofoo u ɲyɛ yii shwɔhɔl'e, ŋgemu u sí ɲɛɛ kafaaga kan u pyàŋ'á, mà li ta bwúuru u à ɲáare u á yɛ? ");
INSERT INTO spp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Lire ɲyɛ mɛ, mà wwò kan u á mà li ta fya u à ɲáare yɛ? ");
INSERT INTO spp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɲyɛ yii sùpyiibii pi à pi ke, cyage e yii maha jà a yacɛnɲyɛ kan yii pyìibil'á ke, yii ɲyɛ a cè a jwo na yii Tuŋi u ɲyɛ nìɲyiŋi na ke, ur'à bégel'a tòro yii taan si yacɛnɲyɛ kan u ɲáarafeebil'á mà? ");
INSERT INTO spp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Lire e yaaga maha yaaga yii la ɲyɛ sùpyire sannte s'a mpyi yii á ke, yii lire pyi pi á mú. Yire Kile tùnntunŋi Musa Saliyaŋi ná Kile tùnntunmpii sanmpii sémɛbil'à jwo. ");
INSERT INTO spp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yii jyè tajyiɲwɔge nimbileni i. Ɲaha kurugo yɛ kuni li maha kakyaare nɔ sùpyaŋi na ke, lire tajyiɲwɔg'à pêe, lire kùn'à pêe, lire e shinɲyahara ɲyɛ na ɲaare. ");
INSERT INTO spp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ŋka kuni li maha shìŋi niŋkwombaaŋi kaan ke, lire tajyiɲwɔg'à cyɛ́rɛ, li ɲarama à pɛn, li ɲaarafeebii ɲyɛ a ɲyaha mɛ. ");
INSERT INTO spp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kafinivinibii pi maha piye pyi Kile tùnntunmii fiige ke, yii a yiye kàanmucaa pire na. Pi aha a ma yii á, pi maha piye pyi mpàa fiige, mà li ta pi funɲy'à pi sige yaayi fiige. ");
INSERT INTO spp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yii sí pi cè pi kapyiiŋkii cye kurugo. Wà sí n‑jà ɛrɛzɛn cige yasɛrɛ kwɔ̀n ŋguro cige na la? Lire ɲyɛ mɛ, mà fizhiye cige yasɛrɛ kwɔ̀n ŋguro cige na la? ");
INSERT INTO spp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lire pyiŋkanni na, cicɛnŋke yasɛɛr'à ɲwɔ, cipege woore s'à pi. ");
INSERT INTO spp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Cicɛnŋɛ sì n‑jà raa yasɛrɛ nimpere seni mɛ. Cipege mú sì n‑jà raa yasɛrɛ niɲcɛnnɛ seni mɛ. ");
INSERT INTO spp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Cige maha cige ku ɲyɛ ku ɲyɛ na yasɛrɛ niɲcɛnnɛ seni mɛ, ku sí n‑kwɔ̀n n‑wà nage e. ");
INSERT INTO spp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lire e ke yii sí pi cè pi kapyiiŋkil'e, bà cige maha ɲcè ku yasɛɛre e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mpii puni pi ɲyɛ na mii pyi “Kafooŋi, Kafooŋi” ke, pire puni sì n‑jyè Kile Saanre e mɛ, mii Tuŋi nìɲyi wuŋi ɲyii wuuni pyifeebii kanni pi ɲyɛ jyifeebii. ");
INSERT INTO spp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kuru canŋke ká nɔ, shinɲyahara sí n‑pa mii pyi “Kafooŋi, Kafooŋi, wuu mpyi na Kile tùnnture yu mu mɛge na, marii jínabii kɔ̀re na yige mu mɛge na, marii kabwɔhii niɲyahagii pyi mu mɛge na mà?” ");
INSERT INTO spp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Lire tèni i, mii sí yi jwo tire sùpyir'á “Mii ɲyɛ a sàa yii cè mà ɲya mɛ. Yii yîri na taan, yii kapimpyiibii!” ");
INSERT INTO spp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Shin maha shin ká mii jwumpe lógo, maa pu kurigii ɲaare ke, urufoo sí n‑jà n‑tàanna ná yákilifooŋi w'e ŋgemu u à u bage faanra kafaafoge ɲuŋ'i ke. ");
INSERT INTO spp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kuru bage faanraŋkwooni kàntugo, zànbwɔh'à cwo, ka dùyi si ɲî na fwu na fwore, ka kafɛɛge si wá na fwu sèe sèl'e na kuru bage ŋɔɔŋi, ŋka ku ɲyɛ a cwo mɛ, ɲaha na yɛ ku nintaani na ɲyɛ kafaafogo ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ŋka shin maha shin ká mii jwumpe lógo, maa mpyi u ɲyɛ na pu kurigii ɲaare mɛ, urufoo na ɲyɛ mu à jwo funŋɔ baa shin, ŋgemu u à u bage faanra nticyɛnŋi ɲuŋ'i ke. ");
INSERT INTO spp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kuru bage faanraŋkwooni kàntugo, zànbwɔh'à cwo, ka dùyi si ɲî na fwu na fwore, ka kafɛɛge si wá na fwu sèe sèl'e na kuru bage ŋɔɔŋi, ka ku puni si mpi a wu.» ");
INSERT INTO spp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu à puru jwumpe jwo a kwɔ̀ ke, ka u kàlaŋi pyiŋkanni si sùpyire kàkyanhala. ");
INSERT INTO spp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ɲaha na yɛ u mpyi na pi kâlali ná Kile sífente e. U kàlaŋi pyiŋkanni ná Kile Saliyaŋi cyelentiibii wuŋi pyiŋkanni mpyi niŋkin mɛ. ");
INSERT INTO spp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu à tîge ɲaŋke na ke, ka shinɲyahara si ntaha u fye e. ");
INSERT INTO spp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ka tògofooŋi wà si file u na maa niŋkure sín u fere e maa jwo: «Kafooŋi, mu aha ɲɛɛ, mu sí n‑jà mii tòge láha mii na si mii fíniŋɛ.» ");
INSERT INTO spp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ɲyɛ ka Yesu si u cyɛge sànha maa bwɔ̀n u na maa jwo: «Mii à ɲɛɛ, tòge ku láha ma na!» Ka tòge si ntíl'a láha u na. ");
INSERT INTO spp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ka Yesu si u pyi: «Cû ma ɲwɔge na, ma hà yaaga jwo sùpya á mɛ, ŋka ta sì, maa sà maye cyêe sáragawwuŋi na u u ma kàanmucya, sárage kyaa Kile tùnntunŋiMusa à jwo tògofeebii kyaa na ke, maa kuru wwû. Lire li sí li cyêe na mu à cùuŋɔ.» ");
INSERT INTO spp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mà Yesu yaha u u jyè Kapɛrɛnamu kànhe e, Ɔrɔmu sòrolashiibii yyaha yyére shinŋi wà à file u na maa u ɲáare na: ");
INSERT INTO spp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Kafooŋi, mii báarapyiŋi nizinniŋi na wá bage e. U à mûruŋɔ, maa ŋkyaali sèl'e.» ");
INSERT INTO spp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ka Yesu si u pyi: «Mii u sà u cùuŋɔ la?» ");
INSERT INTO spp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ka sòrolashiibii yyaha yyére shinŋi si jwo: «Kafooŋi, mii ɲùŋk'à cyɛ́rɛ mu u jyè mii pyɛnge e. Mu aha jwuŋkanŋa niŋkin jwo, kuru sí mii báarapyiŋi cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mii wi ke, sòrolashiibii pìi na ɲyɛ mii ɲùŋɔ na, mii sí ɲyɛ pìi ɲùŋɔ na. Mii aha wà pyi “Ta sì” u maha ŋkàre. Mii aha wabɛrɛ pyi “Ta ma” u maha mpa. Mii aha na biliŋi pyi “Nde pyi” u maha lire pyi.» ");
INSERT INTO spp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu à yire lógo ke, ka li i u kàkyanhala. Mpii pi mpyi u fye e ke, ka u u jwo pir'á: «Sèeŋi na mii sí yi jwo yii á, mii sàha ntêl'a sùpya ɲya ná ŋge dániyaŋi fiige e Izirayɛli shiinbii shwɔhɔl'e mɛ! ");
INSERT INTO spp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mii sí yi jwo yii á, shinɲyahara sí raa yîri canŋafworompe ná canŋajyimpe e, si mpa lyî ná Ibirayima ná Ishaka ná Yakuba e Kile Saanre e. ");
INSERT INTO spp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ŋka Izirayɛli shiinbii mɛɛ na Kile Saanre à bégele ke, pire pìi sí n‑wà cyíinŋi na numpini i. Wani pi sí raa myahigii súu s'a ŋkyànhigii kùru.» ");
INSERT INTO spp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ɲyɛ Yesu à puru jwo ke, maa sòrolashiibii yyaha yyére shinŋi pyi: «Ta sì pyɛngɛ. Ná mu à dá mii na, nde mu à cya ke, lire li pyi.» Ka u báarapyiŋi si ntíl'a cùuŋɔ lire tèenuuni i. ");
INSERT INTO spp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ɲyɛ Yesu à kàre Pyɛri pyɛngɛ mà sà Pyɛri nafeɲcwoŋi ta tasinnage e cifwuro cye e. ");
INSERT INTO spp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ka Yesu si bwɔ̀n u cyɛge na, ka cifwure si láha u na. Ka u u yîri, maa ɲjyì kan Yesu á. ");
INSERT INTO spp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yàkoŋk'à nɔ ke, ka pi i wá na ma ná jínacyaanbii niɲyahamil'e Yesu á. Ka u u jínabii kɔ̀r'a yige pi e ná u ɲwɔjwumpe e, maa yampii puni cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɲyɛ lire pyiŋkanni na, ka Kile tùnntunŋi Ezayi jwumpe si fûnŋɔ, u mpyi a jwo: «U à jyè wuu ná wuu cwɔ̀hɔmpe shwɔhɔl'e, maa wuu yampe láha wuu na.» ");
INSERT INTO spp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ɲyɛ shinɲyahara mpyi a pa Yesu kwûulo, lire kurugo ka u u u cyelempyiibii pyi pi baŋi jyiile ná ur'e. ");
INSERT INTO spp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ka Kile Saliyaŋi cyelentuŋi wà si file u na maa u pyi: «Cyelentuŋi, mii sí n‑taha mu fye e ma tasheyi puni i.» ");
INSERT INTO spp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ka Yesu si u pyi: «Wyigii na ɲyɛ sigepwuunbil'á, shèere mú sí ɲyɛ saɲcyɛɛnr'á. Ŋka tashwɔngɔ ɲyɛ Supyaŋi Jyaŋi á mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka u cyelempyaŋi wabɛrɛ si u pyi: «Kafooŋi, yyére, mii aha na tuŋi tò, mii sí n‑ta n‑pa n‑taha mu fye e.» ");
INSERT INTO spp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ka Yesu si u pyi: «Taha mii fye e, maa kwùubii yaha pi a piye tùni.» ");
INSERT INTO spp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ɲyɛ Yesu à jyè bakwɔɔge e, ka u cyelempyiibii si jyè u fye e. ");
INSERT INTO spp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka kafeebwɔhɔ si yîri na fwu baŋi ɲuŋ'i, fo lwɔhe na ŋko si bakwɔɔge tò. Lir'à Yesu ta u u ŋwúuni. ");
INSERT INTO spp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ka pi i file u na, maa u ɲɛ̀ maa jwo: «Kafooŋi, yîri maa wuu shwɔ, lire baare e wuu sí n‑kwôro lwɔhe e.» ");
INSERT INTO spp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ka u u pi pyi: «Ɲaha na yii na fyáge yɛ? Ɲaha na yii dániyaŋ'à cyɛ́rɛ yɛ?» Maa yîr'a yyére maa fànha cyán kafɛɛge ná baŋi lwɔhe na. Ka yi puni si yyére siu! ");
INSERT INTO spp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ka pi puni si wá na ŋkyáali u na, maa jwo: «Ɲaha supyifiiwe u ɲyɛ ŋge nàŋi, fo ka kafɛɛge ná lwɔhe si ntɛ̀ɛn u wuuni taan yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ɲyɛ ka Yesu si baŋi jyiil'a sà nɔ Gadara shiinbii kùluni i. Ka jínacyaan shuunni si fworo fanɲyi i mà u ɲùŋɔ bɛ̂. Pi mpyi a pi sèe sèl'e, fo wà sàha mpyi na jà a tòro kuru kuuge e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ka pi i wá na yu fànha na: «Kile Jyaŋi, ɲaha mu ɲyɛ na ɲcaa wuu á yɛ? Mu à pa mpa kawaa pyi wuu na mà ta tèni sàha nɔ mà?» ");
INSERT INTO spp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ɲyɛ lir'à caakurumbwɔhɔ ta ku u lyî pi byanhampe e. ");
INSERT INTO spp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ka jínabii si Yesu ɲáare sèl'e na: «Mu aha wuu kɔ̀r'a yige mpii sùpyiibil'e, ma a wuu yaha wuu sà jyè mpii caabil'e.» ");
INSERT INTO spp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ka u u pi pyi: «Yii a sì.» Ka pi i fworo pire nàmbaabii shuunniŋi i, maa sà jyè pire caabil'e, ka caakuruŋke puni si sùrug'a yîri ɲaŋke numpɛnge na, mà cwo cwo baŋi i mà kwû. ");
INSERT INTO spp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ka cáanahabii si fê a kàre kànhe e, ɲcyii cyi à pyi ke, maa sà cyire yyaha jwo, mà cye cyán jínacyaanbii wogigii na. ");
INSERT INTO spp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ka kànhe shiinbii puni si ntíl'a fwor'a kàre Yesu ɲùŋɔ tabeŋi i. Pi à sà u ɲya ke, maa u ɲáare sèl'e na u fworo pire kùluni i. ");
INSERT INTO spp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ɲyɛ ka Yesu si jyè bakwɔɔge e, maa baŋi jyiil'a kàre u yabiliŋi kànhe e. ");
INSERT INTO spp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ka pi i mpa u á ná yaŋi w'e u yasinniŋke e, u mpyi a mûruŋɔ. Yesu à pi ɲya pi à dá uru na ke, maa jwo supyimuruŋk'á: «Na jya, màban le maye e! Mu kapegigil'à yàfa mu na.» ");
INSERT INTO spp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ɲyɛ Kile Saliyaŋi cyelentiibii pi mpyi wani ke, ka pire pìi si wá na sɔ̂nŋi piye funŋ'i na Yesu na Kile mɛge kɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ka Yesu si ntíl'a pi sɔ̀nŋɔre cè, maa jwo pi á: «Ɲaha na yii ɲyɛ ná nte sɔ̀nŋɔpeere shiŋi i yɛ? ");
INSERT INTO spp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mà jwo “Mu kapegigil'à yàfa mu na” ná “Yîri, ma a ɲaare” yii ɲyii na, cyire kapyaagii mú shuunni i, ndire jwumɔ p'à táan yɛ? ");
INSERT INTO spp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ŋka yii pi li cè na síŋi na ɲyɛ Supyaŋi Jyaŋi á naha ɲiŋke na, u wà kapegii yàfa u na.» Lire e u à jwo supyimuruŋk'á: «Yîri, maa ma yasinniŋke lwɔ́, maa sì pyɛngɛ.» ");
INSERT INTO spp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ka u u ntíl'a yîr'a kàre pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sùpyir'à lire ɲya ke, ka pi i fyá maa Kile pêe, uru ŋgemu u à ŋge síŋi fiigiŋi kan sùpyir'á ke. ");
INSERT INTO spp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu à yîri wani ke, u à sà múnalwɔɔre shwofooŋi wà ɲya u à tɛ̀ɛn u báaraŋi tapyige e, u mɛge mpyi Macwo. Ka Yesu si u pyi: «Yîr'a taha na fye e.» Ka u u yîr'a taha u fye e. ");
INSERT INTO spp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɲyɛ lire kàntugo ka Yesu ná u cyelempyiibii si sà ntɛ̀ɛn na lyî Macwo bage e ná mɛpɛngɛ shiinbii niɲyahamil'e mu à jwo múnalwɔɔre shwofeebii ná piibɛrii. ");
INSERT INTO spp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farizhɛɛnbii pìl'à lire ɲya ke, maa Yesu cyelempyiibii pyi: «Ɲaha na yii cyelentuŋi na lyî ná múnalwɔɔre shwofeebii ná mɛpɛngɛ shiinbii piibɛril'e yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu à yire lógo ke, maa jwo: «Mpii pi à cùuŋɔ ke, wempyiŋi kyaa ɲyɛ pire na mɛ, mpii pi na yà ke, pire na u kani ɲyɛ. ");
INSERT INTO spp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kile à jwo u Jwumpe Semɛŋi i “Yii a ɲùɲaara taa yii shinɲɛɛbii na, lir'à táan mii á mà tòro sáragawwuuni na.” Ɲyɛ yii sɔ̂nŋɔ puru jwumpe ɲwɔhe na. Ɲaha na yɛ mpii pi ɲyɛ na piye sɔ̂nŋi na pir'à tíi ke, mii ɲyɛ a pa ɲìŋke na pire tayyerege e mɛ. Ŋka mpii pi à li cè na pire ɲyɛ a tíi mɛ, pire tayyerege e mii à pa.» ");
INSERT INTO spp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lire kàntugo Yuhana Batizelipyiŋi cyelempyiibil'à pa Yesu yíbe na ɲaha na pire ná Farizhɛɛnbii maha súnŋi leni, Yesu cyelempyiibii sí ɲyɛ na u leni mà yɛ? ");
INSERT INTO spp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ka Yesu si pi pyi: «Cipooŋi ceveebii sí n‑jà yyaha tanha, mà pi yaha ná cipooŋi i cikwɔɔnre na la? Ŋka tèni là na ma, cipooŋi sí n‑pa n-yige pi shwɔhɔl'e. Lire tèni i pi sí n‑ta raa súnŋi leni. ");
INSERT INTO spp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wà ɲyɛ na vàanvɔnŋɔ taha na vàanɲjyɛga tacwɔngɔ jwooli mɛ. Lire ká mpyi, vàanvɔnŋke maha vàanɲjyɛge kɛ̀ɛge, tacwɔng'a sì nâara a pêe. ");
INSERT INTO spp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wà mú sí ɲyɛ na sinmpurugo leni seeye boolyɛgil'e mɛ. Lire baare e p'aha mpa ntanha, pu maha pu yaleŋke jya, maa wu, yaleŋk'a sì ŋkɛ̀ɛge. Pi maha sinmpuruge leni seeyi boofɔnŋkil'e, yire mú shuunniŋi y'à bɛ̂.» ");
INSERT INTO spp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ɲyɛ mà Yesu yaha puru jwumpe na, Yahutuubii ɲùŋufooŋi wà à pa niŋkure sín u taan maa jwo: «Yesu! Mii pworoŋ'à kwû numɛ. Maye sanŋa yaha, maa mpa ma cyeyi taha u na, u sí ɲɛ̀.» ");
INSERT INTO spp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ka Yesu ná u cyelempyiibii si yîri na ŋkɛ̀ɛge ná u e. ");
INSERT INTO spp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mà pi niŋkaribii yaha, ceeŋi wà à file Yesu na maa bwɔ̀n u vàanntinŋke zhwɔ̀ɔre na. Lùwuliŋkwombaayi mpyi uru ceeŋi na yyee kɛ ná shuunni funŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","U mpyi na yu uye funŋ'i: «Mii aha bú jà a bwɔ̀n u vàanɲyi na, mii sí n‑cùuŋɔ.» ");
INSERT INTO spp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ka Yesu si yyaha kɛ̂ɛnŋ'a wíl'a u ɲya, maa jwo u á: «Na pworo, ma hà raa fyáge mɛ, ɲaha na yɛ mu dániyaŋ'à mu cùuŋɔ.» Ka ceeŋi si ntíl'a cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu à sà nɔ uru ɲùŋufooŋi pyɛnge e, maa kwùge tìnmpirigii wyìfeebii ná supyiɲyahare ɲya ti i ɲyàha na wùruge tiye e ke, maa jwo pi á: ");
INSERT INTO spp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Yii caala a yîri naha, pùceebilini ɲyɛ a kwû mɛ, li na ŋwúuni.» Ka pi i wá na ɲcyàhali u na. ");
INSERT INTO spp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sùpyir'à fwor'a kwɔ̀ pyɛnge e ke, ka Yesu si jyè bage e, maa pyàŋi buwuŋi cû cyɛge na, ka u u yîri. ");
INSERT INTO spp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ka lire kani si ɲcaala lire kùluni puni i. ");
INSERT INTO spp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu à fworo wani na ŋkɛ̀ɛge ke, ka fyinmii shuunni si ntaha u fye e maa wá na yu fànha na: «Dawuda Tuluge Shinŋi, ɲùɲaara ta wuu na!» ");
INSERT INTO spp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","U à sà jyè pyɛnge e ke, ka pire fyinmpii si file u na. Ka u u pi pyi: «Yii à dá na mii sí n‑jà yii cùuŋɔ la?» Ka pi i jwo: «Ɔɔn, mu sí n‑jà, kàfooŋi.» ");
INSERT INTO spp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ka u u bwɔ̀n pi ɲyiigii na maa jwo: «Li sí n‑pyi yii á mà tàanna ná yii dániyaŋi i.» ");
INSERT INTO spp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ka pi i ntíi na ɲaa. Ka u u yi jwo a waha pi á na pi a piye kàanmucaa, pi àha wà yaha u li cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ŋka pi à yîri wani ke, pi à kàr'a sà a lire kani yu lire kùluni puni i. ");
INSERT INTO spp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ɲyɛ pir'à yîri Yesu taan ke, ka pìi si mpa ná búbu e. Jínaŋi wà u mpyi u e. ");
INSERT INTO spp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu à jínaŋi kɔ̀r'a yige ke, ka búbuŋi si ntíi na yu. Supyiɲyahare ti mpyi wani ke, ka lire si tire kàkyanhala, ka ti i wá na ŋko: «Wuu sàha ŋkwɔ̀ a nde kani fiige ɲya Izirayɛli kìni i mɛ!» ");
INSERT INTO spp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ŋka Farizhɛɛnbil'à jwo na jínabii ɲùŋufooŋi fànhe cye kurugo, Yesu ɲyɛ na jínabii kɔ̀re na yige pifeebil'e. ");
INSERT INTO spp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ɲyɛ Yesu mpyi na ɲaare na mâre kànbwoyi ná kànpyɛɛre puni na. U mpyi na sùpyire kâlali Kile Jwumpe kàlambayi i, maa Jwumpe Nintanmpe yu mà yyaha tíi ná Kile Saanre e, maa yampii puni ná cwɔ̀hɔmɔfeebii puni cùuŋi. ");
INSERT INTO spp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","U à supyiɲyahare ɲya ke, ka pi ɲùɲaare si u ta sèl'e, ɲaha na yɛ ti mpyi a kànha maa ɲcwɔ̂nrɔ, mu à jwo mpàa pi ɲyɛ piye ɲùŋɔ kurugo. ");
INSERT INTO spp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ka Yesu si jwo u cyelempyiibil'á: «Sùmakɔɔg'à pêe, ŋka sùmakwɔɔnbil'à cyɛ́rɛ. ");
INSERT INTO spp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lire e ke yii kɛrɛge foo ɲáare, u u pìi bâra sùmakwɔɔnbii na.» ");
INSERT INTO spp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Lire kàntugo ka Yesu si u cyelempyiibii kɛ ná shuunniŋi yyere, maa fànhe kan pi á, pi jà pi a jínabii kɔ̀re pi a yige pifeebil'e, pi raa yampii puni ná cwɔ̀hɔmɔfeebii puni cùuŋi. ");
INSERT INTO spp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tùnntunmpii kɛ ná shuunniŋi mɛyi yi ɲyɛ ɲje: niɲcyiiŋi u ɲyɛ Simɔ pi maha mpyi Pyɛri ke, ná u sìɲɛɛŋi Andire ná Zebede jyaabii Yakuba ná u cɔɔnŋi Yuhana ");
INSERT INTO spp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ná Filipi ná Baritelemi ná Tomasi ná Macwo ŋge u mpyi na múnalwɔɔre shuu ke, ná Alife jyaŋi Yakuba ná Taadi ");
INSERT INTO spp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ná Simɔ pi maha mpyi Zelɔti ke, ná Zhudasi Isikariyoti ŋge u sí n‑pa Yesu le cye e ke. ");
INSERT INTO spp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pire shiin kɛ ná shuunniŋi Yesu à yɛrɛ maa nta a pi tun. U à jwo pi á: «Yii àha ɲjyè Samari shiinbii kànyi ná supyishiŋi sanŋi wuy'e mɛ, ");
INSERT INTO spp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ŋka yii a sì Izirayɛli shiinbii yyére, pire mpiimu pi ɲyɛ mu à jwo mpàpinniyi ke. ");
INSERT INTO spp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mà yii niŋkaribii yaha, yii a Jwumpe Nintanmpe yu sùpyir'á na Kile Saanre tèn'à byanhara. ");
INSERT INTO spp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yii raa yampii cùuŋi, yii raa kwùubii ɲɛ̀ni, yii raa tògofeebii cùuŋi, yii raa jínabii kɔ̀re yii a yige sùpyire e. Yii à ti ta mana, yii a ti kaan mana. ");
INSERT INTO spp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yii àha sɛɛn, lire ɲyɛ mɛ wyɛ́rɛ, lire ɲyɛ mɛ wyɛ́rɛpya lwɔ́ si nde yii dufaabil'e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yii àha kùshebɔrii lwɔ́ mɛ, yii àha vàanntinyɛ shɔnwuyo lwɔ́ mɛ, yii àha tanhaɲyi yabɛrɛ lwɔ́ mbâra yii tooyi wuyi na mɛ, yii àha kàbii lwɔ́ mɛ. Yii li cè na báarapyiŋ'à yaa u a ŋkaan u a lyî. ");
INSERT INTO spp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yii aha jyè kànbwɔh'e, lire ɲyɛ mɛ kànbilere e, yii sùpya cya ŋgemu u sí ɲɛɛ yii sunmbage na ke. Yii aha uru sùpya ta, yii i ŋkwôro wani fo yii sà nɔ yii tèekani na. ");
INSERT INTO spp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yii aha jyè pyɛngɛ maha pyɛng'e ke, yii pi shɛ́ɛre “Kile u yyeɲiŋke kan yii á.” ");
INSERT INTO spp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kuru pyɛnge shiin ká yii fwùŋi shwɔ, pi sí kuru yyeɲiŋke ta. Ŋka pi aha mpyi pi ɲyɛ a yii fwùŋi shwɔ mɛ, pi sì kuru yyeɲiŋke ta mɛ. ");
INSERT INTO spp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yii aha ŋkàre cyage k'e, ka pi i yii sunmbage cyé, maa mpyi pi ɲyɛ a ɲɛn'a yii jwumpe lógo mɛ, yii nivworobii kuru kànhe e, yii yii tooyi bambaŋi kwòro kwòr'a wu wani. ");
INSERT INTO spp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sèeŋi na mii sí yi jwo yii á, canŋke Kile sí sùpyire puni sâra si ntàanna ná ti kapyiiŋkil'e ke, nde li sí yire kànyi sùpyire ta ke, lire sí n‑waha mà tòro Sɔdɔmu kànhe ná Gɔmɔri kànhe shiinbii wuuni na.» ");
INSERT INTO spp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ka Yesu si núr'a jwo: «Yii lógo! Mii sí yii tun, ŋka yii sí n‑pyi sùpyire shwɔhɔl'e mu à jwo mpàa pi ɲyɛ sige yaaya shwɔhɔl'e. Yii a yiye kàanmucaa bà wwòo ɲyɛ mɛ, yii pyi tatɛɛnnugo sùpyii mpánmpɔrɔyɔ fiige. ");
INSERT INTO spp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yii a yiye kàanmucaa sùpyire na, ɲaha na yɛ pi sí n‑kwɔ̀ n‑pa raa yii yiri yukyaabii yyére, s'a yii bwùun ná kàsɔrigil'e pi Kile Jwumpe kàlambayi i. ");
INSERT INTO spp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pi mú sí n‑kwɔ̀ raa yii cwôre raa sì fànhafeebii ná saanbii yyére, mà li ɲùŋke pyi na yii na ɲyɛ mii cyelempyii. Lire cye kurugo yii sí mii kyaa jwo Yahutuubil'á, sí mii kyaa jwo supyishiŋi sanŋ'á mú. ");
INSERT INTO spp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ŋka tèni i pi sí n‑pa raa yii leni cye e ke, jwumpe yii sí n‑jwo, ná pyiŋkanni na yii sí pu jwo ke, yii àha lire tɛ̀gɛ yiye funŋɔ pɛn mɛ. Jwumpe yii à yaa yi jwo ke, lire tèni yabiliŋi i, puru sí n‑tîge yii funŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yii li cè na yii yabilimpil'e bà puru jwumpe sí n‑fworo mɛ, yii Tuŋi u ɲyɛ Kile ke, uru Munaani li sí raa yu yii cye kurugo. ");
INSERT INTO spp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Pìi sí n‑pa raa pi cìnmpyiibii kaan pi a bùu, tiibii pìi sí n‑pa raa pi pyìibii kaan pi a bùu, pyìibii pìi mú sí n‑pa n‑yîri pi sifeebii kurugo si pi kan pi bò. ");
INSERT INTO spp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yii kyaa sí n‑pɛn sùpyire pun'á mii mɛge kurugo. Ŋka ŋgemu ká jà a uye waha maa ntɛ̀ɛn Kile kuni i fo mà sà nɔ tɛgɛni na ke, urufoo sí n‑shwɔ. ");
INSERT INTO spp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pi aha yii kyérege kànhe k'e, yii fê a fworo kur'e, yii raa sì kabɛr'e. Sèeŋi na mii sí yi jwo yii á, mà jwo yii pi Izirayɛli shiinbii kànyi puni ɲaara a kwɔ̀ ke, Supyaŋi Jyaŋi sí núru n‑pa. ");
INSERT INTO spp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Cyelempyaŋi sì n‑jà n‑pêe n‑tòro u cyelentuŋi na mɛ, biliwe mú ɲyɛ a pêe u kàfooŋi na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Li tɛgɛni li ɲyɛ cyelempyaŋi u pa mpyi cyelentuŋi fiige, biliŋi mú sí mpa mpyi u kàfooŋi fiige. Ná pi à jà a pyɛngefoo tàanna ná jínabii ɲùŋufooŋi Bɛlizebuli i, mpii pi ɲyɛ pyɛngefoo shiinbii ke, pire wuuni sì n-tòro mà? ");
INSERT INTO spp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Lire kurugo yii àha raa fyáge pi na mɛ. Yii li cè, kyaa maha kyaa l'à ŋwɔhɔ ke, cyire puni sí n‑pa raa ɲaa. Kyaa maha kyaa li ɲyɛ numpini i ke, lire là mú sì n‑kwôro ɲcèmbaa mɛ. ");
INSERT INTO spp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mii aha jwumpe mpemu jwo yii á numpini i ke, yii a puru yu canŋke e. Mpe mii à jwo yii á katilwɔhɔre e ke, yii dùgo yii a puru jáare katanɲyi ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mpii pi maha jà a sùpyaŋi cyeere bò, ná pi sì n‑jà u múnaani bò mɛ, yii àha raa fyáge pire na mɛ. Kileŋi u maha jà a sùpyaŋi múnaani ná u cyeere shi bò nafugombaage e ke, uru na yii à yaa yii a fyáge. ");
INSERT INTO spp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tá zíiziinɛ shuunni maha mpɛ́rɛ daashi niŋkin kanna mɛ? Ŋka lire zíiziini là niŋkin sì n‑kwû yii Tuŋi Kile pàama mɛ. ");
INSERT INTO spp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yii pi ke, ali ɲùɲjoore ti ɲyɛ yii ɲùɲyi i ke, Kile à tire puni pɛ̀rɛgɛ cè. ");
INSERT INTO spp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lire kurugo yii àha núru kyaa tɛ̀gɛ yii yiye funŋɔ pɛn mɛ! Yii shin maha shin kan'à waha Kile na mà tòro tire zíiziinɛ niɲyahara na. ");
INSERT INTO spp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Shin maha shin ká yyére li na sùpyire ɲyii na na uru na ɲyɛ mii wu ke, mii Tuŋi u ɲyɛ nìɲyiŋi na ke, mii mú sí n‑yyére li na uru ɲyii na na urufoo na ɲyɛ mii wu. ");
INSERT INTO spp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ŋka ŋgemu ká mii cyé sùpyire ɲyii na ke, mii Tuŋi u ɲyɛ nìɲyiŋi na ke, mii mú sí urufoo cyé uru ɲyii na. ");
INSERT INTO spp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yii àha raa sɔ̂nŋi na mii à pa si mpa jwumabeŋke le sùpyire ná tiye shwɔhɔl'e ɲìŋke na mà dɛ! Mii ɲyɛ a pa ná yyeɲiŋke e mɛ, ná kàshige e mii à pa. ");
INSERT INTO spp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ɲaha kurugo yɛ mii à pa mpa “jyafooŋi ná tufooŋi láha piye na, si pworofooŋi ná nufooŋi láha piye na, si napworoŋi láha nacwoŋi na. ");
INSERT INTO spp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Pìi u zàmpɛnmii sí n‑pa n‑pyi pi pyɛngɛ shiinbii yabilimpii.” ");
INSERT INTO spp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Shinŋi u à u tuŋi, lire ɲyɛ mɛ u nuŋi kyaa táan uy'á mà tòro mii na ke, urufoo ɲyɛ a yaa ná mii cyelempyigire e mɛ. Shinŋi u à u jyaŋi, lire ɲyɛ mɛ u pworoŋi kyaa táan uy'á mà tòro mii na ke, urufoo ɲyɛ a yaa ná mii cyelempyigire e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Shinŋi la ku ɲyɛ si mpyi mii cyelempya ke, urufoo u taha mii fye e, pi mɛ́ɛ mpyi na sí urufoo bò kworokworocige na. Lire baare e urufoo ɲyɛ a yaa ná mii cyelempyigire e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ŋgemu la ká mpyi si u niɲjaaŋi yaa ɲwɔ ke, urufoo nùmpanŋke sí n‑kɛ̀ɛge, ŋka ŋgemu ká kàntugo wá u niɲjaaŋ'á mii kurugo ke, urufoo sí nùmpanŋa ta. ");
INSERT INTO spp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Shin maha shin ká yii cùmu lemɛ ɲwɔ ke, urufoo mú à mii cùmu lemɛ ɲwɔ, ŋgemu sí ká mii cùmu lemɛ ɲwɔ ke, urufoo mú à mii tunvooŋi cùmu lemɛ ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ŋgemu ká Kile tùnntunŋi wà cùmu lemɛ ɲwɔ, mà lire ɲùŋke pyi na u na Kile tùnnture yu ke, tɔ̀ɔnŋi Kile sí n‑pa n‑kan Kile tùnntumpil'á ke, uru tɔ̀ɔnŋi Kile sí n‑kan urufol'á. Sùpyire ti ɲyɛ na fyáge Kile na ke, wà ha tire tà cùmu lemɛ ɲwɔ, mà lire ɲùŋke pyi na ti na fyáge Kile na, Kile sí urufoo sâra tire fiige. ");
INSERT INTO spp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ŋgemu ká lùɲiŋɛ fùnɲcwokwuɲyaga kan ŋge nàŋkocyaaŋi wà á, mà lire ɲùŋke pyi na u na ɲyɛ mii cyelempya ke, sèeŋi na mii sí yi jwo yii á, urufoo sí n‑sìi lire tɔ̀ɔnŋi ta.» ");
INSERT INTO spp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ɲyɛ Yesu à kwɔ̀ yire yɛrɛyi ŋkanŋi na u cyelempyiibii kɛ ná shuunniŋ'á ke, maa ŋkàr'a sà a sùpyire kâlali, maa Jwumpe Nintanmpe yu pi á pi kànyi na. ");
INSERT INTO spp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ɲyɛ mà Yuhana Batizelipyiŋi yaha kàsuŋi i, u mpyi a Kile Niɲcwɔnrɔŋi kapyiiŋkii kyaa lógo. Ka u u u cyelempyiibii pìi tun Yesu á ");
INSERT INTO spp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","pi sà yíbe na: «Ŋge kyaa l'à jwo na u sí n‑pa ke, mu u ɲyɛ u wi laa, wuu a wabɛrɛ sigili?» ");
INSERT INTO spp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ka Yesu si pi pyi: «Yii à ndemu lógo maa ndemu ɲya ke, yii a sì, yii i sà lire yyaha jwo Yuhana á na ");
INSERT INTO spp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Fyinmpii naha na ɲaa, toŋkɛgɛyifeebii sí i ɲaare, tògofeebii na ɲcùuŋi, ɲùɲcunnibii sí i núru, kwùubii sí i ɲɛ̀ni, Jwumpe Nintanmpe sí i yu fòŋɔfeebil'á. ");
INSERT INTO spp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ɲyɛ mii kapyiiŋkii ká mpyi cyi ɲyɛ a ŋgemu pyi u à cye láha mii na mɛ, urufoo wuun'à ɲwɔ.”» ");
INSERT INTO spp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ɲyɛ Yuhana cyelempyiibil'à kàre ke, ka Yesu si wá na Yuhana kyaa yu sùpyir'á, u à jwo: «Canŋke yii ná ŋkàre síwage e ke, taha ɲyɛgɛ yii mpyi a kàr'a sà wíi kafɛɛge sí i ku ɲyàha la? ");
INSERT INTO spp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ɲaha yii sí mpyi a kàr'a sà wíi yɛ? Vàansinayafoo la? Yii li cè na mpii pi maha vàansinayi leni ke, pire maha mpyi saanbii bayi i. ");
INSERT INTO spp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lire sanni i ke, ɲaha yii mpyi a sà wíi yɛ? Kile tùnntunŋɔ la? Mii sí yi jwo yii á, u bá à fànha tò Kile tùnntunŋɔ na. ");
INSERT INTO spp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ɲaha kurugo yɛ Kile Jwumpe Semɛŋi à jwo ŋgemu kyaa na na “Wíi, mii sí na tùnntunŋi tun u sà mu kuni yaa mu yyaha na” ke, uru tùnntunŋi u ɲyɛ Yuhana. ");
INSERT INTO spp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sèeŋi na mii sí yi jwo yii á, sùpya sàha ŋkwɔ̀ a si ŋgemu u à fànha tò Yuhana Batizelipyiŋi na mɛ, lire ná li wuuni mú i, Kile Saanre shiinbii puni nimbilen'à fànha tò Yuhana na. ");
INSERT INTO spp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mà lwɔ́ Yuhana Batizelipyiŋi Kile jwumpe tèejwuuni na, mà pa nɔ numɛ na, mpii la ku ɲyɛ si jyè Kile Saanre e ke, shinpiibii na pire kyérege, pi s'à piye waha si jyè t'e. ");
INSERT INTO spp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kile tùnntunŋi MusaSaliyaŋi ná Kile tùnntunmpii sanmpil'à jwo Kile Saanre kyaa na, fo mà pa nɔ Yuhana tèni na. ");
INSERT INTO spp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kampyi yii sí n‑jà n‑dá pu na, Eliŋi mpaŋi shɛɛnre Kile Jwumpe Semɛŋi a jwo ke, yii li cè uru u ɲyɛ Yuhana. ");
INSERT INTO spp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ŋgemu la ká mpyi si karii yyaha cè ke, urufoo u u niŋgyigigii cyán sèl'e. ");
INSERT INTO spp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ná ɲaha shi i mii sí nte sùpyire shiŋi tàanna yɛ? Ti na ɲyɛ mu à jwo nàŋkopyire, ntemu ti ɲyɛ na bâhare kàfuge na ke, tà na bâhare maa ŋko ti shɛ̀rɛfeebil'á ");
INSERT INTO spp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Wuu à tìinmpini wyì yii á, yii ɲyɛ a ɲɛn'a kwɔ̂hɔ mɛ. Wuu à jáhampe myahigii cêe yii á, yii ɲyɛ a ɲɛn'a mɛɛ sú mɛ.” ");
INSERT INTO spp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yii li cè, Yuhana à pa ke, u mpyi na ɲjyìtɔɔn wu lyî mɛ, u mú mpyi na sinmɛ byii mɛ, ka pi i jwo na jína u ɲyɛ u e. ");
INSERT INTO spp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ɲyɛ Supyaŋi Jyaŋi à pa, maa lyî maa byii, ka pi i jwo na u sɔ̀nŋɔre ɲyɛ a taha yaage kabɛrɛ na mɛ, fo ɲjyìŋi ná sinmbyaani kanni, maa núr'a pyi mɛpɛngɛ shiinbii cevoo mu à jwo múnalwɔɔre shwofeebii. Ŋka yákilifente Kile maha ŋkaan ke, tire ká mpyi wà á, li maha ɲcè urufoo kapyiiŋkil'e.» ");
INSERT INTO spp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ɲyɛ kànyi na Yesu à tòro maa kakyanhala karii niɲyahagii pyi, ka yire kànyi shiin si mpyi pi ɲyɛ a ɲɛn'a pi toroŋkanni kɛ̂ɛnŋɛ mɛ, ka Yesu si wá na yire shiinbii fare. ");
INSERT INTO spp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","U à jwo: «Yii Korazɛn kànhe shiinbii, yii wuun'à kɛ̀ɛge! Yii Bɛtisayida kànhe shiinbii, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ kakyanhala karigii cyi à pyi wani yii yyére ke, kampyi Tiri kànhe ná Sidɔn kànhe e, cyire mpyi a pyi, numɛ mpyi na sí pi ta pi à pi toroŋkanni kɛ̂ɛnŋɛ maa láha kapegigii na fo tèemɔni i, maa cafubɔrigii le mà pyi pi vàanɲyi, maa cwɔɔnre wu piye na. ");
INSERT INTO spp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lire kurugo mii sí yi jwo yii á, canŋke Kile sí sùpyire puni sâra si ntàanna ná ti kapyiiŋkil'e ke, nde li sí n‑pyi yii na ke, lire sí n‑waha mà tòro Tiri ná Sidɔn kànyi wuuni na. ");
INSERT INTO spp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yii Kapɛrɛnamu kànhe shiinbii pi ke, yii na sɔ̂nŋi na yii sí n‑kàre Kile yyére nìɲyiŋi na bɛ? Lire mpyi ɲyɛ mɛ, yii sí n‑sìi n‑tîrige fo ɲìŋke ɲwɔhɔ shiinbii cyage e. Ɲaha kurugo yɛ kakyanhala karigii cyi à pyi wani yii yyére ke, kampyi Sɔdɔmu kànhe e cyire mpyi a pyi, ku shiinbii mpyi na sí n‑yyére pi kapegigii na. Ku mú mpyi na sí n‑pyi wani fo mà sà nɔ niɲjaa na. ");
INSERT INTO spp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lire kurugo mii sí yi jwo yii á, canŋke Kile sí sùpyire puni sâra si ntàanna ná ti kapyiiŋkil'e ke, nde li sí yii Kapɛrɛnamu kànhe shiinbii ta ke, lire sí n‑waha n‑tòro Sɔdɔmu kànhe shiinbii wuuni na.» ");
INSERT INTO spp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ɲyɛ Yesu à kwɔ̀ puru na ke, maa jwo: «Tufooŋi Kile, nìɲyiŋi ná ɲìŋke Kafooŋi, mii fwù ɲyɛ mu na, ɲaha na yɛ kani mu à ŋwɔhɔ yákilifeebii ná kaceempii na ke, mu à lire cyêe nàŋkopyire na. ");
INSERT INTO spp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sèe wi, Tufooŋi, mu à lire pyi mà tàanna ná ma ɲyii wuuni i.» ");
INSERT INTO spp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Lire kàntugo maa jwo sùpyir'á: «Mii Tuŋi à karigii puni le mii cye e. Sùpya ɲyɛ a Jyafooŋi cè Tufooŋi baare e mɛ. Sùpya mú ɲyɛ a Tufooŋi cè Jyafooŋi baare e mɛ, fo Jyafooŋi la ká mpyi si u cyêe ŋgemu na ke. ");
INSERT INTO spp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yii a ma mii yyére, yii pi à kànha maa ntugo ke, mii sí taŋɔŋɔ kan yii á. ");
INSERT INTO spp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yii a báaraŋi pyi mii á, yii i na yaha s'a yii kɛ̂ɛnŋi. Lire ká mpyi, yii sí taŋɔŋɔ ta, ɲaha na yɛ mii ɲyɛ ɲùmpiŋɛfoo, mii karigii mú sí ɲyɛ a waha mɛ. ");
INSERT INTO spp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mii báaraŋi pyim'à táan, tugure mii sí n‑tɛ̀gɛ yii ɲuŋ'i ke, tir'à faha.» ");
INSERT INTO spp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ɲyɛ canŋka, Yesu ná u cyelempyiibii mpyi na ntùuli sùma kooyi y'e, kuru canŋke na mpyi canŋɔŋɔ. Cyelempyiibii katege wuubii pi mpyi, ka pi i sùmaɲcahayi yà kwɔ̀n na mínage na ŋkùru. ");
INSERT INTO spp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farizhɛɛnbii pìl'à lire ɲya ke, maa Yesu pyi: «Wíi, mu cyelempyiibii na canŋɔŋke kafuunŋkii pyi!» ");
INSERT INTO spp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ka u u pi pyi: «Nde Saanŋi Dawuda à pyi ke, yii ɲyɛ a lire kâla mà? Canŋka mà u ná u fyèɲwɔhɔshiinbii katege wuubii yaha, ");
INSERT INTO spp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","u à jyè Kile bage e, maa sárage bwúuruŋi wà lwɔ́ a kyà, maa wà kan u fyèɲwɔhɔshiinbil'á. Mà li ta sáragawwuubii kanni pi mpyi a yaa pi jà a uru bwúuruŋi kyà. ");
INSERT INTO spp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Taha yii ɲyɛ a li kâla Kile Jwumpe Semɛŋi i na sáragawwuubii ká báara pyi Kileɲaarebage e canŋɔŋke e, lire ɲyɛ na ntɔ̀re kapegigil'e mɛ? ");
INSERT INTO spp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mii sí yi jwo yii á, wà na ɲyɛ naha ŋgemu u à pêe Kileɲaarebage na ke. ");
INSERT INTO spp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jwumpe Kile à jwo na yii aha a ɲùɲaara taa yiye na, na lir'à táan ur'á mà tòro sáragawwuuni na ke, kampyi yii mpyi a puru ɲwɔhe cè, sùpyire ti nte yii à ti cɛ̂ɛgɛ mà li ta ti ɲyɛ a yaaga pyi mɛ, yii mpyi na sì ɲɛɛ lire pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Supyaŋi Jyaŋi ká kyaa maha kyaa jwo mà yyaha tíi ná canŋɔŋke e ke, li sì n‑jà n‑tòro lire na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Lire kàntugo Yesu à yîri wani, maa ŋkàre kuru cyage shiin Kile Jwumpe kàlambage e. ");
INSERT INTO spp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lir'à nàŋi wà ta wani ná cyeŋkwuge e. Ka pi i Yesu pyi: «Mà sùpya cùuŋɔ canŋɔŋke e, tá lir'à yaa ná mpyi i?» Kaɲuŋɔ pi mpyi na ɲcaa ná kuru yibige e, si nta tìgire cyán Yesu na. ");
INSERT INTO spp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ka Yesu si pi pyi: «Jofoo u ɲyɛ yii shwɔhɔl'e, ná mpà niŋkin na ɲyɛ u á, ka uru mpàŋi si ɲcwo wyige e mà bɛ̂ ná canŋɔŋke e, urufoo sí ɲɛɛ u yaha wwùmbaa yɛ? ");
INSERT INTO spp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yii ɲyɛ a li cè na sùpyaŋi tayyéreg'à pêe mpàŋi woge na sèe sèl'e mà? Yii li cè, mà tàanna ná Kile Saliyaŋi i, kacɛnni mpyiŋ'à ɲwɔ canŋɔŋke e.» ");
INSERT INTO spp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ɲyɛ u à kwɔ̀ puru na ke, maa jwo cyeŋkwugefol'á: «Ma cyɛge sànhana.» U à ku sànhana ke, ka ku u ɲcùuŋɔ ku sanŋke fiige. ");
INSERT INTO spp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ɲyɛ Farizhɛɛnbii pi mpyi wani ke, ka pire si fwor'a kàr'a sà piye taanna Yesu boŋkanni na. ");
INSERT INTO spp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu à pa yire cè ke, maa yîri kuru cyage e, u niŋkareŋi, shinɲyahara mpyi a taha u fye e, ka u u yampii puni cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Maa yi jwo a waha pi á na pi àha sùpya yaha u yi cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Lire pyiŋkanni na, Kile tùnntunŋi Ezayi jwump'à fûnŋɔ, u mpyi a jwo: ");
INSERT INTO spp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Kile à jwo: “Mii báarapyiŋi u ɲyɛ ŋge, mii à u cwɔɔnrɔ. U kan'à waha mii na sèl'e, u kapyiiŋkil'à táan mii á mú. Mii sí na Munaani pyi li tɛ̀ɛn u e, u sí raa supyishiŋi sanŋi leni kuni nintiini i. ");
INSERT INTO spp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","U sì raa jwumɔ dìrili ná wà e mɛ, u sì raa sêre wà na mɛ. Wà sì u jwuɲyahama lógo sùpyire tabinniyi i mɛ. ");
INSERT INTO spp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ali kaŋkyaange, u sì ku kebe mɛ, fùkinaŋi u ɲyɛ na tafuguyo caa ke, u sì uru fùgo mɛ. U sí n‑kwôro pur'e, fo si ntìiŋi kuni le sùpyire puni taan. ");
INSERT INTO spp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Supyishiŋi puni sí n‑pa pi sɔ̀nŋɔre taha u na.”» ");
INSERT INTO spp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɲyɛ lire kàntugo, ka pi i mpa ná jínacyanŋi w'e Yesu á. Uru nàŋi mpyi na ɲaa mɛ, maa mpyi búbu. Ka Yesu si u cùuŋɔ u à jà na yu maa ɲaa. ");
INSERT INTO spp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ka li i sùpyire puni bilibili fo pi na piye yíbili maa ŋko: «Taha Dawuda Tuluge Shin bà u ɲyɛ ŋge nàŋi mɛ?» ");
INSERT INTO spp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ɲyɛ Farizhɛɛnbil'à yire lógo ke, ka pi i jwo: «Ŋge nàŋi ɲyɛ a sìi na jínabii kɔ̀re na yige pifeebil'e ná fànhe kabɛr'e, jínabii ɲùŋufooŋi Bɛlizebuli woge kàntugo na mɛ!» ");
INSERT INTO spp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ná Yesu sí mpyi a pi funzɔnŋɔre cè, ka u u jwo pi á: «Kìre maha kìre li ɲyɛ na liye tùnni ke, lire maha mpa jya. Kànhe ŋkemu, lire ɲyɛ mɛ pyɛnge ŋkemu shiin ká yîri piye kurugo ke, kuru maha mpa jya mú. ");
INSERT INTO spp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sitaanniŋi ká a u báarapyiibii kɔ̀re, u na uye tùnni. Lire ká mpyi, u saanre sì n‑kwɔ̀ mà? ");
INSERT INTO spp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yii aha jwo na mii na jínabii kɔ̀re na yige pifeebil'e ná jínabii ɲùŋufooŋi Bɛlizebuli fànhe e, lire sanni i ke, yii shiinbii pi ɲyɛ na pi kɔ̀re ke, ná jofoo u fànhe e pire maha pi kɔ̀re yɛ? Yii shiinbii yabilimpii pi sí jwumpe pyi pu cwo yii ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ŋka yii li cè na mii na jínabii kɔ̀re na yige pifeebil'e ná Kile Munaani fànhe e, lir'à li cyêe na Kile Saanre à nɔ yii na mà kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Wà sì n‑jà n‑jyè fànhaɲyahagafoo bage e, si u yaayi lwɔ́, ná u ɲyɛ a bage foo pwɔ a cyán maa nta a jyè mà yɛ. Urufoo ká jà a u pwɔ a cyán, lire e u maha jà a bage yaayi pyi u ɲɛɛmpe. ");
INSERT INTO spp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Shinŋi u ɲyɛ u ɲyɛ ná mii i mɛ, urufoo ɲyɛ mii zàmpɛn, ŋgemu u ɲyɛ u ɲyɛ na mii tɛ̀re na sùpyire wàa tiye na mɛ, urufoo na ti ɲùŋɔ kyánge. ");
INSERT INTO spp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Lire kurugo mii sí yi jwo yii á: kapegigii shiŋi puni ná Kile mɛkɛɛgɛ jwumpe puni sí n‑jà yàfa sùpyire na. Ŋka ŋgemu ká Kile Munaani mɛge kɛ̀ɛge ke, lire sì n‑sìi yàfa urufoo na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wà ha jwumpimɛ jwo Supyaŋi Jyaŋi na, lire sí yàfa urufoo na. Ŋka ŋgemu ká jwumpimɛ jwo Kile Munaani na ke, lire kapiini sì yàfa urufoo na ŋge tìiŋi i mɛ, li mú sì yàfa urufoo na tìiŋi nimpaŋi i mɛ. ");
INSERT INTO spp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Cige ká ɲwɔ, ku maha yasɛrɛ niɲcɛnnɛ pyi. Cige ká mpyi ku ɲyɛ a ɲwɔ mɛ, ku ɲyɛ na yasɛrɛ niɲcɛnnɛ pyi mɛ. Cige shiŋi maha ɲcè ku yasɛɛre cye kurugo. ");
INSERT INTO spp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yii màcwɔn fiige sùpyiibii! Mà pege yaha yii funŋ'i, yii sì n‑sìi n‑jà jwuɲcɛnmɛ jwo mɛ. Sùpyaŋi zòmbilin'à ɲî ndemu na ke, lire u ɲwɔge maha yu. ");
INSERT INTO spp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŋgemu u zò u à ɲwɔ ke, uru maha jwuɲcɛnmpe yu. Ŋgemu u ɲyɛ ná zòmpi i ke, uru maha jwumpimpe yu. ");
INSERT INTO spp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mii sí yi jwo yii á, canŋke Kile sí sùpyire puni sâra si ntàanna ná ti kapyiiŋkil'e ke, jwumɔ maha jwumɔ sùpyir'à jwo, ná pu ɲyɛ laaga baa ke, Kile sí ti yíbe puru puni na. ");
INSERT INTO spp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Shin maha shin ɲwɔjwumɔ kurugo, Kile sí n‑jwo na u à tíi, lire ɲyɛ mɛ u à cɛ̂ɛgɛ.» ");
INSERT INTO spp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ɲyɛ ka Kile Saliyaŋi cyelentiibii pìi ná Farizhɛɛnbii pìi si jwumpe lwɔ́ maa jwo: «Cyelentuŋi, wuu la naha maa kani là pyi a cyêe wuu na, ndemu li sí li cyêe na mu à fworo Kile e ke.» ");
INSERT INTO spp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ka Yesu si pi pyi: «Mpii pi à pi, maa kàntugo wà Kile na ke, pire maha ɲcaa si kakyanhala kani là ɲya tapyige e. Ŋka nde l'à pyi Kile tùnntunŋi Zhonasi na ke, lire baare e kakyanhala kyaa saha sì n‑pyi n‑cyêe pi na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yii li cè, bà Zhonasi a canmpyaa taanre ná numpiliyi taanre pyi fyabwɔhe funŋke e mɛ, amuni Supyaŋi Jyaŋi mú sí canmpyaa taanre ná numpiliyi taanre pyi fanŋke e. ");
INSERT INTO spp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Canŋke Kile sí sùpyire puni sâra si ntàanna ná ti kapyiiŋkil'e ke, Ninive kànhe shiinbii sí n‑pa n-yîri n‑yyére si pire kapimpyiibii cɛ̂ɛgɛ, ɲaha na yɛ Zhonasi à sà Kile jwumpe jwo Ninive shiinbil'á ke, pi à pi toroŋkanni kɛ̂ɛnŋɛ. Mà li ta wà na ɲyɛ naha, ŋgemu u tayyérege k'à fànha tò Zhonasi woge na ke, pire kapimpyiibii sí ɲyɛ a ɲɛn'a pi toroŋkanni kɛ̂ɛnŋɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kuru canŋke, saancwoŋi u mpyi Sheba kìni ɲùŋɔ na ke, uru mú sí n‑pa n-yîri n‑yyére si pire kapimpyiibii cɛ̂ɛgɛ, ɲaha na yɛ uru saancwoŋi mpyi a yîri diɲyɛŋi ɲùŋke kà na, mà sà saanŋi Solomani yákilifente jwumpe lógo. Mà li ta wà na ɲyɛ naha, ŋgemu u yákili u à pêe Solomani wuŋi na ke, pi sí ɲyɛ a ɲɛn'a lógo uru ɲwɔ na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jína ká fworo sùpya e, u maha sà ɲaara síwage yyaha kurugo maa tatɛɛngɛ cya. U aha mpyi u ɲyɛ a kà ta mɛ, ");
INSERT INTO spp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","u maha jwo “Mii sí núru raa wà na tayirige e.” Ɲyɛ u aha núr'a pa urufoo ta bawaga fiige, ŋkemu k'à pwɔ́, maa ku funŋke bégel'a ɲwɔ ke, ");
INSERT INTO spp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","u maha núr'a kàr'a sà jínahii baashuunni lwɔ́ a bâra uye na, mpii pi à pi mà tòro u yabiliŋi na ke, maha mpa jyè urufol'e. Lire ká mpyi, urufoo pyiŋkanni nivɔnn'a sì nâar'a pi mà tòro niɲjyeeni na. Amuni pire kapimpyiibii wuuni mú sí n‑pyi.» ");
INSERT INTO spp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mà Yesu yaha puru jwumpe na ná sùpyire e, u nuŋi ná u cìnmpyiibil'à pa yyére cyíinŋi na, maa ɲcaa si jwo ná u e.  ");
INSERT INTO spp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ka wà si Yesu yyere maa jwo: «Mu nuŋi ná mu cìnmpyiibii naha cyíinŋi na, pi naha na mu kyaa pyi.» ");
INSERT INTO spp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ka Yesu si urufoo pyi: «Mpire pi ɲyɛ mii nuŋi ná mii cìnmpyiibii yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","U à puru jwo ke, maa cyɛge sànha u cyelempyiibii kàmpanŋke na, maa jwo: «Mii nuŋi ná mii cìnmpyiibii pi ɲyɛ mpii. ");
INSERT INTO spp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yii li cè na mii Tuŋi u ɲyɛ nìɲyiŋi na ke, ŋge u ɲyɛ na uru ɲyii wuuni pyi ke, uru u ɲyɛ mii cìnmpworoŋi ná mii nuŋi.» ");
INSERT INTO spp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kuru canŋke yabiliŋi i, Yesu à fworo bage e maa ŋkàr'a sà ntɛ̀ɛn baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ka shinɲyahara si mpa bínni u taan, li ɲyɛ a pa ɲwɔ mɛ, ka u u jyè a tɛ̀ɛn bakwɔɔge k'e lwɔhe ɲuŋ'i, ka sùpyire si yyére kùmpoge na. ");
INSERT INTO spp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ka u u ti kâla karii niɲyahagii na ná bàtaay'i. ");
INSERT INTO spp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","U à jwo: «Ɲɛɛnuguŋi wà u ná fwor'a kàre ɲɛɛmɛ tanuguge e. Mà u yaha u u sùmashiŋi wàa fini fiige, wà à cwo kuni ɲwɔge na, ka saɲcyɛɛnre si mpa uru jò. ");
INSERT INTO spp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ka wà tacwugo si mpa bɛ̂ ná kafaafoge e, pworo niɲyahara mpyi kuru cyage e mɛ. Ka uru si fyîn wahawaha, ɲaha na yɛ u mpyi a jyè ɲìŋke e sèl'e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ɲyɛ canŋk'à pa fworo ke, ka yifyinre si fàan maa waha, ndìre kuuŋi na. ");
INSERT INTO spp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ka wà tacwugo si mpa bɛ̂ ŋgurotaha na, ka ŋgure si yîr'a uru cû. ");
INSERT INTO spp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ŋka wà tacwug'à pa bɛ̂ ná ɲìŋke niɲcɛnŋke e, maa fyîn, maa lyɛ, maa se. Sùmacire tà à sùmapyaŋi se mà nɔ ŋkuu ŋkuu (100) na, tà mpyi beetaanre taanre (60) tà mpyi beɲjaaga ná kɛ kɛ. ");
INSERT INTO spp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ŋgemu la ká mpyi si karii yyaha cè ke, urufoo u u niŋgyigigii cyán sèl'e.» ");
INSERT INTO spp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ka Yesu cyelempyiibii si file u na, maa u yíbe: «Ɲaha na mu ɲyɛ na bàtaayi yu sùpyir'á yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ka Yesu si pi pyi: «Karigii cyi à yyaha tíi ná Kile Saanre e, ná cyi à ŋwɔhɔ ke, yii á cyire ɲcèŋ'à kan, u sí ɲyɛ a kan sùpyire sannt'á mɛ. ");
INSERT INTO spp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ɲaha kurugo yɛ ŋgemu u à yaaga cè ke, là sí n‑bâra urufoo u taceŋke na sèl'e. Ŋka ŋgemu u ɲyɛ u ɲyɛ a yaaga cè mɛ, urufoo bá na sɔ̂nŋi na ur'à nimbileni ndemu cè ke, lire sí n‑shwɔ urufoo na. ");
INSERT INTO spp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lire kurugo mii na bàtaayi yu pi á, ɲaha na yɛ pi ɲyiigil'à cwôro, ŋka pi ɲyɛ na ɲaa mɛ, niŋgyigigii na ɲyɛ pi á, ŋka pi ɲyɛ na núru mɛ, pi ɲyɛ na karii yyaha cìni mɛ. ");
INSERT INTO spp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kile tùnntunŋi Ezayi mpyi a jwumpe mpemu jwo ke, pur'à fûnŋɔ pi kàmpanŋke na. U mpyi a jwo: “Yii sí raa núru, ŋka yii sì raa yafyin yyaha cìni mɛ. Yii ɲyiigii sí n‑cwôro ŋka yii sì raa yafyin ɲaa mɛ. ");
INSERT INTO spp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yii li cè, nte sùpyire niŋgyigigil'à waha, pi à pi niŋgyigigii tò, maa pi ɲyiigii tò, bà pi si mpyi pi àha raa ɲaa s'a núru mɛ, pi yákilibii mú ká raa karii yyaha cìni mɛ. Ɲaha kurugo yɛ pi la ɲyɛ sì núru mpa mii yyére, mii i pi shwɔ mɛ.” ");
INSERT INTO spp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ŋka yii pi ke, yii wuun'à ɲwɔ, ɲaha na yɛ yii na ɲaa yii ɲyiigil'e, maa núru yii niŋgyigigil'e. ");
INSERT INTO spp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sèeŋi na mii sí yi jwo yii á, nde yii à ɲya maa ndemu lógo ke, Kile tùnntunmii niɲyahamii ná Kile ɲwɔmɛɛcuvee niɲyahamii la mpyi si lire ɲya, si li lógo. Ŋka pi ɲyɛ a jà a li ɲya, maa li lógo mɛ. ");
INSERT INTO spp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ɲyɛ kuru bàtaage k'à jwo mà yyaha tíi ná ɲɛɛnuguŋi i ke, yii ku ɲwɔhe lógo. ");
INSERT INTO spp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kuni ɲwɔge na, sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo shinŋi u à Kile Saanre kani jwumpe lógo, maa mpyi u ɲyɛ a pu yyaha cè mɛ, ka Sitaanniŋi si mpa pu wwû u funŋ'i ke. ");
INSERT INTO spp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kafaafoge ɲuŋ'i sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo maa ntíl'a ɲɛɛ pu na ná funntange e ke. ");
INSERT INTO spp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ŋka pu ɲyɛ a jà a ndìre le t'e mɛ, ti ɲwɔmɛɛni kɛ̀ngɛmɛ ɲyɛ a pɛn mɛ. Kawaa, lire ɲyɛ mɛ yyefugo kyaa ká ti ta Kile jwumpe kurugo, ti maha fworo Kile kuni i. ");
INSERT INTO spp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ŋgure shwɔhɔl'e sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo, ka diɲyɛŋi karigii funmpɛɛnre ná nàfuuŋi lage si pu cwɔ̂nrɔ, pu ɲyɛ a jà a yasɛrɛ pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɲìŋke niɲcɛnŋke na sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire ti ɲyɛ na Kile jwumpe núru maa pu yyaha cìni ke. Tire sùpyire na ɲyɛ sùmaseŋɛ fiige, sùmacire tà à sùmaŋi se mà nɔ ŋkuu ŋkuu (100) na, ka tà si se mà nɔ beetaanre taanre (60) na, ka tà si se mà nɔ beɲjaaga ná kɛ kɛ na.» ");
INSERT INTO spp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ɲyɛ Yesu à núr'a bàtaage kà jwo pi á na: «Kile Saanre à fworo nde kani kurugo: faapyiŋi wà à sùmashi niɲcɛnŋɛ nûgo u kɛrɛge e. ");
INSERT INTO spp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mà sùpyire yaha ŋɔɔmpe na numpilage e, u zàmpɛnŋi wà à pa ɲyɛ̀pege kà shi wà kɛrɛge e maa núr'a kàre. ");
INSERT INTO spp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ɲyɛ ka ku ná sùmaŋi si fyîn maa lyɛ siɲcyan. ");
INSERT INTO spp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kɛrɛge foo báarapyiibil'à sà kɛrɛge ta amuni ke, ka pi i sà u pyi “Ɲùŋufooŋi, sùmashiŋi mu mpyi a nûgo ma kɛrɛge e ke, taha u bà mpyi a ɲwɔ mɛ? Ɲyɛ̀pege sí ku wá kɛrɛge e ke, taa kur'à yîri ke?” ");
INSERT INTO spp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ka kɛrɛge foo si jwo “Mii zàmpɛnŋi wà u à ŋke báarapege pyi amɛ.” Ka báarapyiibii si u pyi “Mu la ɲyɛ wuu u sà ku kɔ̀ɔng'a wwû sùmaŋi shwɔhɔl'e la?” ");
INSERT INTO spp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ka kɛrɛge foo si jwo “Yii ku yaha wani, lire baare e, ku takɔɔnge e yii sí raa sùmaŋi kɔ̀ɔnge ná k'e. ");
INSERT INTO spp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yii ku ná sùmaŋi yaha u a lyɛge siɲcyan, sùmakwɔngigii ká nɔ, mii sí yi jwo sùmakwɔɔnbil'á pi i kuru ɲyɛ̀pege kwɔ̀n a yige sùmaŋi i, pi pwɔ pwɔ pi i ku súugo fɔlɔ, pi i nta a sùmaŋi kwɔ̀n a le na bwùunni i.”» ");
INSERT INTO spp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ɲyɛ Yesu à núr'a bàtaage kà jwo pi á. U à jwo: «Kile Saanre na ɲyɛ mu à jwo mutaridi cige pyà nàŋi wà à ŋgemu nûgo u cikɔɔge e ke. ");
INSERT INTO spp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kuru cige pyàŋ'à yîlege cire sannte puni wuŋi na. Ŋka u aha nûgo, u maha fyîn maa mpyi cibwɔhɔ mà tòro kaɲyɛge yawyɛɛre puni taan, fo saɲcyɛɛnre maha ti shèere yaa ku ŋkéɲyi i.» ");
INSERT INTO spp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","U à núr'a bàtaage kà jwo pi á na: «Kile Saanre na ɲyɛ mu à jwo bwúuruŋi yîrigeyirige yaani. Ceewe ká li nimbilere le farini mbyìmɛ niɲyaham'i mà cwɔ̀nhɔ, li maha puru mbyìmpe niɲcwɔnhɔmpe puni yîrige.» ");
INSERT INTO spp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ɲyɛ Yesu à puru jwumpe puni jwo bàtaay'i sùpyir'á. Bàtaayi jwumpe baare e, u mpyi na pabɛrɛ yu ná t'e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Lire e jwumpe Kile tùnntunŋi mpyi a jwo ke, pur'à fûnŋɔ, u mpyi a jwo: «Bàtaayi mii sí raa yu pi á, karigii cyi à ŋwɔhɔ fo diɲyɛŋi tasiige e ke, cyire mii sí raa yu pi á.» ");
INSERT INTO spp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ɲyɛ Yesu à kwɔ̀ puru jwumpe na ke, maa jyè bage e, ka u cyelempyiibii si file u na, maa jwo: «Bàtaage mu à jwo mà yyaha tíi ná ɲyɛ̀pege e sùmaŋi shwɔhɔl'e ke, kuru yyaha jwo wuu á.» ");
INSERT INTO spp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ka u u pi pyi: «Sùmashiŋi niɲcɛnŋi nùgufooŋi u ɲyɛ Supyaŋi Jyaŋi. ");
INSERT INTO spp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kɛrɛge e sùmashiŋi niɲcɛnŋ'à nûgo ke, kuru ku ɲyɛ diɲyɛŋi. Sùmashiŋi niɲcɛnŋi u ɲyɛ mpii pi à ɲɛɛ Kile Saanre na ke, ɲyɛ̀pege ku ɲyɛ Sitaanniŋi fyèɲwɔhɔshiinbii. ");
INSERT INTO spp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Zàmpɛnŋi u à ɲyɛ̀pege wà sùmaŋi shwɔhɔl'e ke, uru u ɲyɛ Sitaanniŋi. Sùmakwɔɔnre ti ɲyɛ diɲyɛŋi tèekwooni, sùmakwɔɔnbii pi ɲyɛ Kile mɛ̀lɛkɛɛbii. ");
INSERT INTO spp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pyiŋkanni na ɲyɛ̀pege maha ŋkɔ̀ɔng'a wwû sùmaŋi shwɔhɔl'e maa ku súugo ke, amuni li mú sí n‑pyi diɲyɛŋi tèekwooni. ");
INSERT INTO spp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kuru canŋke Supyaŋi Jyaŋi sí u mɛ̀lɛkɛɛbii tun. Yaaga maha yaaga ku ɲyɛ na sùpyire ɲùŋɔ kyánge Kile na, ná mpii pi maha Kile Saliyaŋi kɛ̀ɛge ke, pi sí pire puni cwɔɔnrɔ n‑yige Kile Saanre e, ");
INSERT INTO spp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","si ŋgà nafugombaage e. Wani pi sí raa mɛɛ súu s'a ŋkyànhigii kùru. ");
INSERT INTO spp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ŋka mpii pi à Kile ɲwɔmɛɛni cû ke, pire sí raa bɛ̀ɛnmpe yige canŋa ɲyii fiige pi Tuŋi Saanre e. Ŋgemu la ká mpyi si karii yyaha cè ke, urufoo u u niŋgyigigii cyán sèl'e.» ");
INSERT INTO spp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kile Saanre na ɲyɛ sahaŋki mu à jwo nàfuu ŋgemu u à ŋwɔhɔ kɛrɛge k'e ke. Nàŋi wà à sà fworo uru nàfuuŋi na taŋwɔhɔge e, maa u yal'a ŋwɔhɔ sahaŋki. U funntanga wuŋi, maa ŋkàr'a sà u cyeyaayi puni pɛ́r'a tɛ̀g'a kuru kɛrɛge shwɔ. ");
INSERT INTO spp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kile Saanre à fworo nde kani kurugo: cwɔ̀hɔŋi wà u mpyi na kɔ́ɔn nisinaŋa caa. ");
INSERT INTO spp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","U à kɔ́ɔnbile loŋgara wu ɲya ke, maa ŋkàr'a sà u cyeyaayi puni pɛ́rɛ, maa li shwɔ. ");
INSERT INTO spp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kile Saanre à fworo nde kani kurugo: fyacuumpii pìi mpyi a cwò wà lwɔhe e, ka uru cwòŋi si fyaabii shiŋi puni cû. ");
INSERT INTO spp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","U à ɲî ke, ka pi i u dìr'a yige kùmpoge na, maa ntɛ̀ɛn maa fyaabii niɲcɛnmpii cwɔɔnr'a le yaleŋke e, maa tɔ̀ɔn baa wuubii wà. ");
INSERT INTO spp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɲyɛ amuni li mú sí n‑pyi diɲyɛŋi tèekwooni i. Kile mɛ̀lɛkɛɛbii sí shinpiibii cwɔɔnrɔ si ŋgwû shincɛnmpil'e, ");
INSERT INTO spp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","si pi wà nafugombaage e. Wani pi sí raa mɛɛ súu s'a ŋkyànhigii kùru. ");
INSERT INTO spp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu à puru jwo ke, maa u cyelempyiibii yíbe na pi à mpe jwumpe lógo la? Ka pi i jwo: «Ɔɔn, wuu à pu lógo.» ");
INSERT INTO spp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ka Yesu si jwo: «Kile Saliyaŋi cyelentuŋi cye k'à le mà yyaha tíi ná Kile Saanre e ke, uru maha kàla nivɔnŋɔ ta maha bâra niɲjyeŋi na maha yaha uye e, mu à jwo nàfuɲuŋɔ na yige na ŋkaan.» ");
INSERT INTO spp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu à kwɔ̀ puru jwumpe na ke, maa yîri wani, ");
INSERT INTO spp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","maa ŋkàre u tukanhe na. U à nɔ wani ke, maa jyè pi Kile Jwumpe kàlambage e, maa sùpyire kâlali. U kàlaŋi pyiŋkanni mpyi a sùpyire kàkyanhala fo pi na ŋko: «Di u à pyi maa mpyi yákilifoo yɛ? Di u à pyi maa kakyanhala karigii pyi yɛ? ");
INSERT INTO spp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Taha cíkyangaŋi tooyo wuŋi bà u ɲyɛ u wi mɛ? Taha u nuŋi bà u ɲyɛ Mariyama mɛ? U cìnmpyiibii bà pi ɲyɛ Yakuba ná Yusufu ná Simɔ ná Zhude mà? ");
INSERT INTO spp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","U ná pùcɛribii pi ɲyɛ nu na ke, pire ɲyɛ naha ná wuu e mà? Di u s'à pyi maa jà na ɲcyii karigii pyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɲyɛ tire sɔ̀nŋɔr'à pi pyi pi à ɲùŋɔ tugo Yesu na. Ka Yesu si jwumpe lwɔ́ maa jwo pi á: «Kile tùnntunŋɔ maha le ɲjire e cyeyi puni i fo u tukanhe ná u tupyɛnge yɛ!» ");
INSERT INTO spp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ɲyɛ pi dánabaare kurugo, Yesu ɲyɛ a kakyanhala karii niɲyahagii pyi wani mɛ. ");
INSERT INTO spp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ɲyɛ saanŋi Erɔdi à pa a Yesu shɛnrɛ núru ke, ");
INSERT INTO spp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","maa jwo u báarapyiibil'á: «Yuhana Batizelipyiŋi wi, u à ɲɛ̀ à fworo kwùŋi i, lire kurugo u à jà na kakyanhala karigii pyi amɛ.» ");
INSERT INTO spp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yii li cè na Erɔdi mpyi a u sìɲɛɛŋi Filipi cwoŋi kwɔ̀n a lwɔ́ mà pyi u cwo. Uru ceeŋi mɛge na mpyi Erɔdiyadi. Lire e ka Yuhana si yi jwo Erɔdi á na u ɲyɛ a yaa u u sìɲɛɛŋi cwoŋi shwɔ u na mɛ. Ka puru jwumpe si waha Erɔdi na, ka u u pi pyi pi à Yuhana cû a pwɔ a le kàsuŋi i. ");
INSERT INTO spp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erɔdi la mpyi si Yuhana bò, ŋka u mpyi na fyáge Yahutuubii yyaha na, ɲaha na yɛ pi puni mpyi a li cè na Yuhana na ɲyɛ Kile tùnntunŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ɲyɛ Erɔdi canzeg'à pa mâhana a nɔ lire yyeeni ke, ka u u pìi yyere maa kataan pyi. Ɲyɛ mà pi yaha lire kataanni na, Erɔdiyadi pworoŋ'à pa a ŋkwɔ̂hɔli shinyyerebii shwɔhɔl'e, ka lire si ntáan Erɔdi e, ");
INSERT INTO spp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","fo u à kâa pùcwoŋ'á na u aha yaaga maha yaaga ɲáare ur'á ke, kuru sí n‑kan u á. ");
INSERT INTO spp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ka pùcwoŋi nuŋi si jwo a kan pùcwoŋ'á na u sà jwo saanŋ'á na u Yuhana Batizelipyiŋi ɲùŋke kwɔ̀n a le ŋkunan'i, u pa ŋkan ur'á. ");
INSERT INTO spp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ka puru jwumpe si saanŋi yyahe pyi k'à tanha. Ŋka u mpyi na sì n‑jà n‑cyé mɛ, ɲaha na yɛ u mpyi a kâa u shinyyerebii ɲyii na. Ɲyɛ ka u u pìi pyi pi sà Yuhana ɲùŋke kwɔ̀n kàsuŋi i pi pa ŋkan pùcwoŋ'á. ");
INSERT INTO spp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ɲyɛ ka pi i Yuhana ɲùŋke kwɔ̀n ");
INSERT INTO spp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mà le ŋkunan'i, mà kan pùcwoŋ'á, ka u u ku kan u nuŋ'á. ");
INSERT INTO spp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ɲyɛ lir'à pyi ke, ka Yuhana cyelempyiibii si mpa u buwuŋi lwɔ́ mà sà ntò, maa sà u sànge wyì Yesu á. ");
INSERT INTO spp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ɲyɛ Yesu à puru jwumpe lógo ke, maa yîri kuru cyage e, maa jyè bakwɔɔge k'e, mà kàre sige funŋke e. Sùpyir'à pa u saha cè ke, maa fworo pi kànyi i, maa ŋkàre u fye e tɔɔre na. ");
INSERT INTO spp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu à fworo bakwɔɔge e mà pi ɲya pi à ɲyaha sèl'e ke, ka pi ɲùɲaare si u ta sèl'e, yampii pi mpyi tire sùpyire shwɔhɔl'e ke, ka u u pire cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɲyɛ yàkoŋk'à pa nɔ ke, ka u cyelempyiibii si file u na maa jwo: «Cyelentuŋi! Sige funŋke e wuu ɲyɛ, canŋke s'à kwɔ̀ a kwɔ̀. Sùpyire cye yaha bà ti si mpyi si sà ɲjyì shwɔ ɲwɔkurugo kànyi i mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ka Yesu si pi pyi: «Lire ɲyɛ a pi kakarala kwɔ̀ mɛ, yii yabilimpii pi pi kan pi lyî.» ");
INSERT INTO spp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka pi i u pyi: «Bwúuru ɲùnyɔ kaŋkuro ná fyapyaa shuunni kanna cyi naha wuu ɲuŋ'i.» ");
INSERT INTO spp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ka u u pi pyi: «Yii a ma ná y'e.» ");
INSERT INTO spp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ɲyɛ pi à pa ná y'e ke, ka u u sùpyire pyi t'à tɛ̀ɛn ɲyɛge ɲuŋ'i. Pi à tɛ̀nn'a kwɔ̀ ke, ka u u bwúuru ɲùɲyi kaŋkuruŋi ná cyire fyapyaagii shuunniŋi lwɔ́, maa yyahe yîrige nìɲyiŋi i, maa fwù kan Kile á yi kyaa na. Maa bwúuruŋi kwɔ̀n kwɔ̀n a kan u cyelempyiibil'á, pi à kan sùpyir'á. ");
INSERT INTO spp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sùpyire ti mpyi wani ke, tire pun'à lyî a tìn. Ka pi i ŋkwɔ̀ maa shàhii kɛ ná shuunni ɲî ɲjyìpaanyi na. ");
INSERT INTO spp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pire lyìlyibil'e, nàmbaabii kanni mpyi a shiin kampwɔhii kaŋkuro (5.000) kwɔ̀, cyeebii ná nàŋkopyire ɲyɛ a tɔ̀rɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɲyɛ lire ɲwɔhɔ na, mà Yesu yaha u u sùpyire cye yare, u à u cyelempyiibii pyi pi à jyè bakwɔɔge e, maa baŋi jyiile u yyaha na. ");
INSERT INTO spp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ɲyɛ Yesu à ti cye yaha ke, maa ŋkàr'a sà Kile ɲáare ɲaŋke kà na, u kanni. U à kwôro wani fo mà pa nɔ yàkoŋke na. ");
INSERT INTO spp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ɲyɛ bakwɔɔge e cyelempyiibii mpyi na baŋi jyiili ke, lir'à kuru ta ku u byanhare lwɔhe niŋke na. Ka kafɛɛge si wá na fwu na lwɔhe tɛ̀re na bakwɔɔge ŋɔɔŋi na wàa kàmpanɲyi puni na. ");
INSERT INTO spp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ɲyɛ numpilag'à pa lyɛ ke, ka Yesu si yîri na ɲaare na ŋkɛ̀ɛge pi fye e lwɔhe ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cyelempyiibil'à u nimpaŋi ɲya lwɔhe ɲuŋ'i ke, maa fyá sèl'e fo na ɲcyɛ̂ɛnni maa jwo: «Buŋi wà fwɔ̀ɔngɔ ku ɲyɛ ŋke!» Mà pi fyagara wuubii yaha, pi mpyi na kwuuyi wàa. ");
INSERT INTO spp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mà pi yaha pur'e, ka Yesu si ntíl'a jwumpe lwɔ́ maa pi pyi: «Yii yákilibii tìŋɛ, yii àha vyá mɛ, mii wi.» ");
INSERT INTO spp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ka Pyɛri si jwo: «Kampyi mu u ɲyɛ u wi, na yaha si ɲaara lwɔhe ɲuŋ'i, si ma ɲùŋɔ bɛ̂.» ");
INSERT INTO spp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ka Yesu si u pyi: «Ta ma.» Ka u u fworo bakwɔɔge e na ɲaare na Yesu ɲùŋɔ bêni lwɔhe ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ŋka u à pa kafɛɛge ɲya k'à pêe maa fyá ke, ka u u li ɲwɔ cû na ntîri lwɔhe ɲwɔh'i, maa ŋkwúuli: «Kafooŋi, na shwɔ!» ");
INSERT INTO spp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ka Yesu si ntíl'a cyɛge sànha, maa u cû maa jwo: «Mu dániyaŋ'à cyɛ́rɛ dɛ! Ɲaha na mu ɲyɛ a funŋke pyi niŋkin mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ka Yesu ná Pyɛri si jyè bakwɔɔge e, ka kafɛɛge si ntíl'a yyére. ");
INSERT INTO spp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ɲyɛ lir'à pyi ke, mpii pi mpyi bakwɔɔge e ke, ka pire si niŋkure sín Yesu á maa jwo: «Nàkaana baa, Kile Jyaŋi u ɲyɛ mu.» ");
INSERT INTO spp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɲyɛ Yesu ná u cyelempyiibil'à baŋi jyiile ke, maa jyè Zhenɛzarɛti kùluni i. ");
INSERT INTO spp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kuru cyage shiinbii mpyi a Yesu cè, lire e pi à Yesu mpaŋi jwo puru màhampe puni i. Ka sùpyire si wá na ma ná yampii shinŋi puni i Yesu á. ");
INSERT INTO spp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pi mpyi na Yesu ɲáare na u pire yaha pi i bwɔ̀n u vàanntinŋke zhwɔ̀ɔre na kanna. Yampii pi mpyi maha bwùun u na ke, pire puni mpyi maha ɲcùuŋi. ");
INSERT INTO spp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ɲyɛ canŋka Farizhɛɛnbii pìi ná Kile Saliyaŋi cyelentiibii pìl'à yîri Zheruzalɛmu kànhe e mà pa Yesu yyére, maa u yíbe: ");
INSERT INTO spp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ɲaha na mu cyelempyiibii ɲyɛ na wuu tulyeyi làdaabii karigii leni ɲjire e mà yɛ? Ɲaha na pi aha a si raa lyî, pi ɲyɛ na pi cyeyi jyíi mà tàanna ná pire làdaabil'e mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ka Yesu si pi pyi: «Ɲaha na yii à kàntugo wà Kile toŋ'á, maa ntaha làdaabii fye e yɛ? ");
INSERT INTO spp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yii li cè na Kile à jwo “Ma tuŋi ná ma nuŋi pêe. Ŋgemu ká jwumpimɛ jwo a wà u tuŋi, lire ɲyɛ mɛ u nuŋi na ke, urufoo sí n‑bò.” ");
INSERT INTO spp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ŋka yii pi ke, yii maha yi yu sùpyir'á na “Wà ha jà a jwo u sifeebil'á na yaayi uru mpyi a yaa u tɛ̀g'a pi tɛ̀gɛ ke, na ur'à yire kan Kile á mà kwɔ̀, ");
INSERT INTO spp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","na urufoo mɛ́ɛ ká mpyi u ɲyɛ na yaaga kaan u sifeebil'á sahaŋki mɛ, na tapege ɲyɛ yire e mɛ.” Mà tàanna ná lire e, yii à kàntugo wà Kile jwump'á, maa ntaha yii làdaabii fye e. ");
INSERT INTO spp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yii pi à fyìnmɛ tò wwomɔ na ke! Kile tùnntunŋi Ezayi mpyi a jwumpe mpemu jwo yii kyaa na ke, pur'à sàa pyi sèe. U mpyi a jwo na ");
INSERT INTO spp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Kile à jwo ‘Nte sùpyire na mii pêre ɲwɔyi i kanna, mà li ta pi zòompii laag'à tɔɔn mii na. ");
INSERT INTO spp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pi na mii pêre tawage e, ɲaha na yɛ kàlaŋi pi ɲyɛ na ŋkaan ke, ur'à lwɔ́ a pwɔ sùpyire làdaabii kanni na.’”» ");
INSERT INTO spp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Puru ɲwɔhɔ na, Yesu à sùpyire yyere maa jwo t'á: «Yii niŋgyigigii pɛrɛ, yii raa núru sèl'e. ");
INSERT INTO spp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yaaga maha yaaga ku ɲyɛ na jyè sùpyaŋi ɲwɔge e ke, kuru kà ɲyɛ na jà a u ɲwɔ́hɔ mɛ. Ŋka ɲje yi ɲyɛ na fwore sùpyaŋi ɲwɔge e ke, yire yi maha jà a u ɲwɔ́hɔ.» ");
INSERT INTO spp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ɲyɛ Yesu à puru jwo ke, ka u cyelempyiibii si file u na maa jwo: «Mu ɲyɛ a cè na mu jwump'à waha Farizhɛɛnbii na mà?» ");
INSERT INTO spp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ka Yesu si pi pyi: «Cige maha cige ku ɲyɛ ku ɲyɛ a cɛnmɛ mii Tuŋi nìɲyi wuŋi cye kurugo mɛ, yire puni sí n‑kò n‑wà. ");
INSERT INTO spp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yii Farizhɛɛnbii yaha wani, fyinmii pi à fyinmii yyaha cû. Fyin ká u fyinɲɛɛ kàbii cû, pi mú shuunniŋi sí n‑tîge wyige k'e.» ");
INSERT INTO spp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ka Pyɛri si jwo: «Puru jwumpe ɲwɔhe jwo wuu á.» ");
INSERT INTO spp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ka Yesu si pi pyi: «Yii yabilimpii, ali numɛ yákilitan ɲyɛ yii á mà? Mpe mii na yu ke, yii ɲyɛ na puru núru mà? ");
INSERT INTO spp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yii ɲyɛ a li cè na yaaga maha yaaga ku maha jyè sùpyaŋi ɲwɔge e ke, na u yaceni i kuru maha ŋkàre, u aha shà yaare e, k'a sì fworo mà? ");
INSERT INTO spp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ŋka ɲje yi ɲyɛ na fwore sùpyaŋi ɲwɔge e ke, u zòŋi i yire maha fwore, yire mú sí yi maha u ɲwɔ́hɔ Kile á. ");
INSERT INTO spp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yii li cè na sùpyaŋi zòŋi i sɔ̀nŋɔpeere maha fwore, mu à jwo: supyibuuni ná jacwɔɔre ná silege baa karigii ná nàŋkaage ná kafinare ná jwoore. ");
INSERT INTO spp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Cyire karigii cyi maha sùpyaŋi ɲwɔ́re Kile á. Lire baare e mà yalyige lyî cyeyi ɲjyìmbaa, lire ɲyɛ na jìn'a sùpya ɲwɔ́hɔ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ka Yesu si yîri wani mà kàre Tiri ná Sidɔn kànyi kàmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mà pi yaha wani, Kana shiinbii cwoŋi wà à pa Yesu á, maa jwo fànha na: «Kafooŋi! Dawuda Tuluge Shinŋi! Ɲùɲaara ta na na, maa sà na pworoŋi kàanmucya. Jínaŋi wà u wá a u tɛɛnmɛ pɛn.» ");
INSERT INTO spp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu ɲyɛ a ɲɛn'a u ɲwɔ shwɔ mɛ. Ka cyelempyiibii si jwo Yesu á: «Ŋge ceeŋi cye yaha, ɲaha na yɛ u na ŋkwúuli wuu ɲwɔh'i.» ");
INSERT INTO spp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ka Yesu si pi pyi: «Izirayɛli shiinbii kanni mɛɛ na Kile à mii tun, pire mpiimu pi ɲyɛ mpàa nimpinnimii fiige ke.» ");
INSERT INTO spp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ŋka lire ná li wuuni mú i, ceeŋ'à pa niŋkure sín Yesu taan maa jwo: «Kafooŋi! Cye le na á.» ");
INSERT INTO spp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ka Yesu si jwo: «Mà nàŋkopyire yalyire lwɔ́ a wà pwunmpyir'á, lire ɲyɛ a ɲwɔ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ka ceeŋi si jwo: «Kafooŋi, yire ɲyɛ sèe, ŋka pyɛngefoo ká a lyî, ɲjyìpaanre ti maha ɲcwo ɲìŋke na ke, pwunmpyire maha tire lyî.» ");
INSERT INTO spp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ɲyɛ ceeŋ'à yire jwo ke, ka Yesu si jwo: «Ceewe, ŋka mu naha a dá mii na dɛ! Nde mu à cya mii á ke, lire sí n‑pyi mu á.» Ɲyɛ ka u pworoŋi si ntíl'a cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ɲyɛ lire kàntugo Yesu à yîri kuru cyage e maa ŋkàre Galile baŋi ɲwɔge na, maa dùg'a tɛ̀ɛn ɲaŋke kà ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ka supyikurumbwɔhɔ si mpa u á. Kuru supyikuruŋke e, pìi mpyi a pa ná dìshiyifel'e, pìi s'à pa ná fyinmil'e, pìi sí ɲyɛ ná yatanŋkɛgɛyɛfel'e, pìi sí ɲyɛ ná búbul'e, pìi sí ɲyɛ ná yampii shi niɲyahamil'e. Pi mpyi na ma ná pire yampil'e Yesu á, ka u u pi cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Li mpyi a sùpyire bilibili mà búbuubii ɲya pi à jà na yu, yatanŋkɛgɛyifeebii sí i ɲcùuŋi, dìshiyifeebii sí i ɲaare, fyinmpii sí i ɲaa, lire kurugo pi à Izirayɛli shiinbii u Kileŋi kêe. ");
INSERT INTO spp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ɲyɛ ka Yesu si u cyelempyiibii yyere maa jwo: «Ŋke supyikuruŋke ɲùɲaare naha mii na, ɲaha na yɛ pi canŋke taanre woge ku ɲyɛ naha mii taan, yalyire ɲyɛ pi á mɛ. Mii la ɲyɛ si pi cye yaha ɲjyìmbaa mɛ, lire baare e katege sí pi fànha kwɔ̀ kuni na.» ");
INSERT INTO spp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ka cyelempyiibii si jwo: «Di wuu si n‑jà ɲjyì ta naha ŋke síwage e, si ntɛ̀gɛ ŋke supyikuruŋke fiige ɲwɔ cya yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ka Yesu si pi pyi: «Bwúuru ɲùnyɔ jùuli yi wá yii ɲuŋ'i yɛ?» Ka pi i jwo: «Bwúuru ɲùnyɔ baashuunni ná fyapyire ti naha wuu ɲuŋ'i.» ");
INSERT INTO spp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ka u u sùpyire pyi t'à tɛ̀ɛn ɲìŋke na, ");
INSERT INTO spp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","maa bwúuru ɲùɲyi baashuunniŋi ná tire fyapyire lwɔ́, maa fwù kan Kile á yi kyaa na, maa yi kwɔ̀n kwɔ̀n mà kan u cyelempyiibil'á, ka pire si yi táa ti na. ");
INSERT INTO spp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kuru supyikuruŋke pun'à lyî a tìn, ka pi i ŋkwɔ̀ maa saanya baashuunni ɲî ɲjyìpaanyi na. ");
INSERT INTO spp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pire lyìlyibil'e, nàmbaabii kanni mpyi kampwɔhii sicyɛɛre (4.000) cyeebii ná nàŋkopyire ɲyɛ a tɔ̀rɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ɲyɛ lire ɲwɔhɔ na, u à ta a sùpyire cye yaha, maa jyè bakwɔɔge k'e, mà kàre Magadan kùluni i. ");
INSERT INTO spp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɲyɛ canŋka Farizhɛɛnbii ná Sadusiibil'à file Yesu na, si u pɛrɛ ɲcû, maa u pyi na u kani là pyi ndemu l'à li cyêe na u à fworo Kile e ke.  ");
INSERT INTO spp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ka Yesu si pi pyi: «Yii aha kileŋi yyahe ɲya k'à ɲáaŋa yàkoŋke, yii maha jwo na zànhe sì n‑pa niɲjaa mɛ. ");
INSERT INTO spp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɲyɛ̀ge na, yii aha kileŋi yyahe ɲya k'à wwɔ̀, yii maha jwo na zànhe sí n‑pa niɲjaa. Ɲyɛ yii à jà a cyire karigii puni tèepyiiŋkii cè, ka ɲaha si li ta ɲcyii cyi ɲyɛ na mpyi yii shwɔhɔl'e numɛ ke, yii ɲyɛ a jà a cyire cè mà yɛ? ");
INSERT INTO spp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mpii pi à pi, maa kàntugo wà Kile na ke, pire maha ɲcaa si kacyeele ɲya tapyige e. Ŋka nde l'à pyi Kile tùnntunŋi Zhonasi na ke, lire baare e kakyanhala kyaa saha sì n‑pyi n‑cyêe pi na mɛ.» Ɲyɛ u à puru jwo ke, maa yîri pi taan mà kàre. ");
INSERT INTO spp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lire kàntugo ka Yesu cyelempyiibii si baŋi jyiil'a kàre kùmpoge sanŋke na. Pi à sà nɔ ke, ka pi i li kàanmucya mà li ta pi funŋ'à wwɔ̀, pi ɲyɛ a bwúuru lwɔ́ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ka Yesu si yi jwo pi á: «Yii a yiye kàanmucaa Farizhɛɛnbii ná Sadusiibii bwúuruŋi yîrigeyirige yaani na.» ");
INSERT INTO spp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ka u cyelempyiibii si pi funɲyi cya puru jwumpe na, maa jwo piye shwɔhɔl'e: «Bà wuu à pyi wuu ɲyɛ a pa ná bwúuru i mɛ, lire e u à mpe jwo bɛ?» ");
INSERT INTO spp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ɲyɛ Yesu à pa pi kunuŋke ɲwɔhe cè ke, maa jwo: «Yii dániyaŋ'à cyɛ́rɛ dɛ! Ɲaha kurugo bwúuruŋi wuun'à yii funŋɔ wwòoŋɔ yɛ? ");
INSERT INTO spp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ali numɛ yii yákilibii sàha ŋkwɔ̀ a múgo mà? Canŋke mii à bwúuru ɲùɲyi kaŋkuruŋi tɛ̀g'a nàmbaa kampwɔhii kaŋkuruŋi (5.000) ɲwɔ cya, ka shàhigii dáŋi ŋgemu si ɲî ɲjyìpaanyi na pi lyìŋkwooni kàntugo ke, yii funŋ'à wwɔ̀ lire na la? ");
INSERT INTO spp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Canŋke mii à bwúuru ɲùɲyi baashuunniŋi tɛ̀g'a nàmbaa kampwɔhii sicyɛɛreŋi (4.000) ɲwɔ cya, ka yii i ŋkwɔ̀ maa saanyi ɲî ɲjyìpaanyi na pi lyìŋkwooni kàntugo ke, taha yii funŋ'à wwɔ̀ lire na mú? ");
INSERT INTO spp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ná yii funŋɔ ɲyɛ a wwɔ̀ lire na mɛ, mii à yii pyi na yii a yiye kàanmucaa Farizhɛɛnbii ná Sadusiibii bwúuruŋi yîrigeyirige yaani na, ka yii i wá na sɔ̂nŋi na bwúuru kyaa mii ɲyɛ na yu ke, ɲaha na yii ɲyɛ a jà a puru jwumpe ɲwɔhɔ cè mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ɲyɛ ka cyelempyiibii si li cè na bwúuruŋi yîrigeyirige yaani na bà Yesu à jwo pi a piye kàanmucaa mɛ, ŋka Farizhɛɛnbii ná Sadusiibii kàlaŋi kyaa li. ");
INSERT INTO spp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ɲyɛ Yesu à kàr'a sà nɔ Sezare Filipi kùluni na ke, maa u cyelempyiibii yíbe: «Jofoo sùpyire ɲyɛ na Supyaŋi Jyaŋi sɔ̂nŋi yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ka pi i u pyi: «Pìi wá na ŋko na Yuhana Batizelipyiŋi u ɲyɛ mu, pìi sí i ŋko na Kile tùnntunŋi Eli u ɲyɛ mu, pìi sí i ŋko na Kile tùnntunŋi Zheremi u ɲyɛ mu, pìi mú sí i ŋko na Kile tùnntunmpii sanmpii pi à tòro ke, na uru wà u ɲyɛ mu.» ");
INSERT INTO spp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ka Yesu si pi pyi: «Yii de? Jofoo yii ɲyɛ na mii sɔ̂nŋi yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ka Simɔ Pyɛri si jwo: «Kile Niɲcwɔnrɔŋi u ɲyɛ mu, Kileŋi ɲyii wuŋi Jyaŋi.» ");
INSERT INTO spp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ka Yesu si u pyi: «Zhonasi jyaŋi Simɔ! Mu wuun'à ɲwɔ. Ɲaha na yɛ sùpya bà u à ŋge sèeŋi cyêe mu na mɛ, mii Tuŋi u ɲyɛ nìɲyiŋi na ke, uru u à u cyêe mu na. ");
INSERT INTO spp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mii sí jwo mu á, mii sí mu mɛge le Pyɛri (kuru ɲwɔhe ku ɲyɛ kafaaga.) Mii sí kuru kafaage tɛ̀gɛ na dánafeebii kuruŋke ɲwɔhɔ cyán, kwùŋi mú bà sì n‑jà yaaga pyi kuru ŋkemu na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mii sí Kile Saanre tirikyanhigii kan mu á. Mu aha ɲcyé kyaa maha kyaa na ɲìŋke na ke, lire mú sí ɲcyè ta u à pyi lire na nìɲyiŋi na. Mu aha ɲɛɛ kyaa maha kyaa na ɲìŋke na ke, lire mú sí ɲɛɛ ta u à pyi lire na nìɲyiŋi na.» ");
INSERT INTO spp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ɲyɛ ka Yesu si yi jwo a waha cyelempyiibil'á na pi àha ŋkwɔ̀ yi jwo sùpya á na uru u ɲyɛ Kile Niɲcwɔnrɔŋi mɛ. ");
INSERT INTO spp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ɲyɛ mà lwɔ́ fo lire tèni na, ka Yesu si wá na u cyelempyiibii kâlali na fànha ki uru u kàre Zheruzalɛmu kànhe e, si ŋkyaala sèl'e kacwɔnribii ná Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii cye e. Pi sí uru bò, ŋka uru kwùŋi canmpyitanrewuuni, uru sí ɲɛ̀. ");
INSERT INTO spp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ɲyɛ Yesu à puru jwo ke, ka Pyɛri si u fɛ̂ɛn ŋkere na maa u cɛ̂ɛgɛ na: «Ma hà puru jwo mɛ, Kafooŋi! Kile u ma shwɔ lire na, lire fiige kà zìi ma ta mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ka Yesu si Pyɛri wíi ná ɲyiŋkeni i maa jwo: «Yîri na taan, Sitaanna wà we! Mu na mii ɲùŋɔ kyánge. Mu ɲyɛ na sɔ̂nŋi Kile ɲyii wuuni na mɛ, fo sùpyire ɲyii wuuni!» ");
INSERT INTO spp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ɲyɛ ka Yesu si jwo u cyelempyiibil'á: «Ŋgemu la ká mpyi si ntaha mii fye e ke, urufol'à yaa u cyé u yabiliŋi ɲyii karigii na, u u ntɛ̀ɛn kyaage taan u u ntaha mii fye e, pi mɛ́ɛ ká mpyi na sí urufoo bò kworokworocige na. ");
INSERT INTO spp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ɲaha na yɛ ŋgemu la ká mpyi si u niɲjaaŋi yaa ɲwɔ ke, urufoo sì nùmpanŋa ta mɛ, ŋka ŋgemu ká kàntugo wà u niɲjaaŋ'á mii kurugo ke, urufoo sí nùmpanŋa ta. ");
INSERT INTO spp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɲaha li sí ɲwɔ sùpyaŋ'á mà ma ɲyii yaayi puni ta ŋge diɲyɛŋi i niɲjaa, mu nùmpanŋke si sà ŋkɛ̀ɛge yɛ? Sùpya sì n‑jà yafyin tɛ̀gɛ u múnaani ɲùŋɔ wwû nùmpanŋa mɛ. ");
INSERT INTO spp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yii li cè na canŋka, Supyaŋi Jyaŋi sí núru n‑pa ná u Tuŋi sìnampe ná u mɛ̀lɛkɛɛbil'e. Kuru canŋke, u sí shin maha shin sâra si ntàanna ná u kapyiiŋkil'e. ");
INSERT INTO spp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sèeŋi na mii sí yi jwo yii á, yii mpii pi ɲyɛ naha ke, pìi na ɲyɛ yii e, pire sì n‑kwû ná pi ɲyɛ a Supyaŋi Jyaŋi saanra wuŋi nimpaŋi ɲya mà yɛ.» ");
INSERT INTO spp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ɲyɛ canmpyaa baani kàntugo, ka Yesu si Pyɛri ná Yakuba ná u cɔɔnŋi Yuhana lwɔ́, maa ŋkàre ná pire kanni i ɲaŋke kà nintɔɔngɔ ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mà pi yaha wani, Yesu pyiŋkann'à pa ŋkɛ̂ɛnŋɛ pi ɲyii na. U yyahe mpyi na ɲî canŋa ɲyiini fiige, ka u vàanɲyi si fíniŋɛ bɛ̀ɛnmpe fiige. ");
INSERT INTO spp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kuru tanuge e, ka tèecyiini Kile tùnntunmpiiMusa ná Eli si mpa Yesu cyelempyiibii mú taanre ɲyii na, mà pa a yu ná u e. ");
INSERT INTO spp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ka Pyɛri si jwo Yesu á: «Kafooŋi, wuu à pa naha ke, lir'à ɲwɔ. Mu aha ɲɛɛ, mii sí vùnyɔ taanre kwòro naha, niŋkin sí n‑pyi mu wogo, niŋkin sí n‑pyi Musa wogo, niŋkin sí n‑pyi Eli wogo.» ");
INSERT INTO spp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mà Pyɛri yaha puru jwumpe na, ka ɲahaŋa si mpa pi tò, kuru ɲahaŋke mpyi na bɛ̀ɛnmpe yige. Ka mɛjwuu si fworo kuru ɲahaŋke e na: «Mii Jyaŋi u ɲyɛ ŋge, u kan'à waha mii na sèl'e, u kapyiiŋkil'à táan mii á mú, yii a núru u ɲwɔ na.» ");
INSERT INTO spp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ɲyɛ cyelempyiibil'à lire mɛjwuuni lógo ke, ka fyagare si pi ta fo pi à cwo cwo ɲìŋke na maa yyahayi cyígile. ");
INSERT INTO spp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ka Yesu si file maa bwɔ̀n pi na maa jwo: «Yii yîri, yii àha raa fyáge mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ɲyɛ pi à ta naha yyahayi yîrige ke, pi saha ɲyɛ a wà ɲya mɛ fo Yesu kanni. ");
INSERT INTO spp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mà pi yaha pi i ntîri ɲaŋke na, ka Yesu si yi jwo a waha pi á: «Nde yii à ɲya ke, yii àha ŋkwɔ̀ li jwo sùpya á mɛ, fo Supyaŋi Jyaŋi ká ɲɛ̀ a fworo kwùŋi i.» ");
INSERT INTO spp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ɲyɛ ka cyelempyiibii si u pyi: «Ko Kile Saliyaŋi cyelentiibii s'à jwo na Kile tùnntunŋi Eli u à yaa u fyânha a pa Kile Niɲcwɔnrɔŋi yyaha na.» ");
INSERT INTO spp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ka u u pi pyi: «Sèe wi, Eli à yaa u fyânha a pa si karigii puni kurigii tíi. ");
INSERT INTO spp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ŋka mii sí yi jwo yii á, Eli à pa a kwɔ̀, sùpyire ɲyɛ a u cè mɛ, maa u pyi pi ɲyii pyiŋkanni na. Lire pyiŋkanni ninuuni na, pi sí Supyaŋi Jyaŋi kyérege mú.» ");
INSERT INTO spp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ɲyɛ u à puru jwo ke, ka u cyelempyiibii si li cè na Yuhana Batizelipyiŋi kyaa u ɲyɛ na yu. ");
INSERT INTO spp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ɲyɛ pi à kàr'a sà nɔ sùpyire cyage e ke, ka nàŋi wà si mpa niŋkure sín Yesu fere e maa jwo: ");
INSERT INTO spp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Kafooŋi, mii na mu ɲáare maa ɲwɔ na jyaŋi na, kìrikirisanŋi u ɲyɛ u e na u kànre sèl'e, u maha u cyáan nage e tèrigii cyìl'e, maa u cyáan lwɔhe e tèrigii cyìl'e. ");
INSERT INTO spp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mii à pa ná u e mu cyelempyiibii yyére, ŋka pire ɲyɛ a jà a u cùuŋɔ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ka Yesu si jwo: «Ei! Yii dánabaa sùpyiibii nimpiibii, fo ɲaha tère e mii sí n‑kwôro ná yii e yɛ? Mii sí yii kapyiiŋkii kwú naye e n-sà nɔ fo ɲaha tère na yɛ? Yii a ma ná pyàŋi i na á.» ");
INSERT INTO spp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ɲyɛ pi à pa ná pyàŋi i ke, ka Yesu si fànha cyán jínaŋi na, ka u u fworo pyàŋi i, ka pyàŋi si ɲcùuŋɔ lire tèenuuni i. ");
INSERT INTO spp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ɲyɛ lire kàntugo, ka cyelempyiibii si file Yesu na pi mɛgɛ cyage e maa u yíbe na ɲaha na pire ɲyɛ a jà a ŋge jínaŋi kɔ̀r'a yige pyàŋi i mà yɛ? ");
INSERT INTO spp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ka Yesu si pi pyi: «Yii dániyaŋi ɲcyɛ̀rɛŋi u à pa ná l'e. Sèeŋi na mii sí yi jwo yii á, yii dániyaŋi mɛ́ɛ n'a mpyi a cyɛ́rɛ mutaridi bile fiige, yii mpyi na sí n‑jà ŋke ɲaŋke pyi “Kò a yîri naha ŋke cyage e” ku mú mpyi na sí lire pyi. Yaaga mpyi na sì n‑jà yii jà pyige mɛ.  ");
INSERT INTO spp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kileɲarege ná súnŋi baare e, ŋge jínaŋi shiŋi ɲyɛ na fwore sùpya e mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Canŋka mà Yesu ná u cyelempyiibii yaha siɲcyan Galile kùluni i, u à jwo pi á: «Pi sí n‑pa Supyaŋi Jyaŋi le sùpyire cye e pi bò, ");
INSERT INTO spp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ŋka u kwùŋi canmpyitanrewuuni, u sí ɲɛ̀.» Ka puru jwumpe si cyelempyiibii yyahayi tanha sèl'e. ");
INSERT INTO spp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ɲyɛ Yesu ná u cyelempyiibil'à sà nɔ Kapɛrɛnamu kànhe e ke, mpii pi maha Kileɲaarebage wyɛ́rɛŋi shuu ke, ka pire si file Pyɛri na maa u pyi: «Taha yii cyelentuŋi bà ɲyɛ na Kileɲaarebage wyɛ́rɛŋi sârali mɛ?» ");
INSERT INTO spp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ka Pyɛri si pi pyi: «U maha u sârali kɛ!» U à jyè bage e ke, ka Yesu si jwumpe lwɔ́ yyecyiige na, maa jwo: «Simɔ, ɲaha mu ɲyɛ na sɔ̂nŋi yɛ? Jofoo na ŋge diɲyɛŋi saanbii maha múnalwɔɔre shuu, lire ɲyɛ mɛ na wyɛ́rɛwwuuge cyáan yɛ? Pi pyìibii na laa, nàmpwuunbii na?» ");
INSERT INTO spp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ka Pyɛri si jwo: «Nàmpwuunbii.» Ka Yesu si jwo: «Pi pyìibii kɔni ɲyɛ a yaa pi a u sârali mɛ. ");
INSERT INTO spp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ŋka ná wuu la sí ɲyɛ sì ɲcyé u sâraga pi lùgigii cyi kwɔ̀ a yîri mɛ, lire e, ta sì baŋi ɲwɔge na, maa ma myàhani wà lwɔhe e. L'aha fyaŋi niɲcyiiŋi ŋgemu cû ke, maa uru ɲwɔge múgo, mu sí wyɛ́rɛ ta wani, uru sí n‑bɛ̂ mii ná mu wuŋi na.» ");
INSERT INTO spp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ɲyɛ lire tèni i, ka cyelempyiibii si file Yesu na, maa u pyi: «Jofoo u ɲyɛ shinbwoŋi Kile Saanre e yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ɲyɛ ka Yesu si pyàŋi wà yyere, maa u yyéeŋɛ pi shwɔhɔl'e, maa jwo: ");
INSERT INTO spp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«Sèeŋi na mii sí yi jwo yii á, ná yii ɲyɛ a kɛ̂ɛnŋɛ mà pyi nàŋkopyire fiige mɛ, yii sì n‑sìi n‑jà n‑jyè Kile Saanre e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lire e shinŋi u à uye tîrige ŋge pyàŋi fiige ke, uru u sí n‑pyi Kile Saanre shinbwoŋi. ");
INSERT INTO spp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Shin maha shin u à ɲɛn'a ŋge pyàŋi fiige cùmu lemɛ ɲwɔ mii kurugo ke, urufol'à mii cùmɔ lemɛ ɲwɔ mú. ");
INSERT INTO spp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nte nàŋkopyire t'à dá mii na mà kwɔ̀ ke, shin maha shin ká lire là niŋkin ɲùŋɔ kyán, l'à pwɔ́rɔ urufol'á pi kafaabwɔhɔ pwɔ u yacige e, pi i u wà baŋi i. ");
INSERT INTO spp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Diɲyɛŋi sùpyire wuun'à kɛ̀ɛgɛ pi ɲùŋkyan karigii kurugo. Karigii cyi ɲyɛ na sùpyire ɲùŋɔ kyánge ke, cyire mpyimbaa ɲyɛ mɛ. Ŋka ŋgemu ká mpyi kaɲuŋɔ maa sùpya ɲùŋɔ kyán Kile na ke, urufoo wuun'à kɛ̀ɛge! ");
INSERT INTO spp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mu cyɛge kà niŋkin, lire ɲyɛ mɛ mu tɔɔge kà niŋkin ká a si mu pyi mu u kapii pyi, ku kwɔ̀n a wà tatɔɔnge e, ɲaha na yɛ mu cye niŋkin wuŋi, lire ɲyɛ mɛ mu tɔɔgɔ niŋkin wuŋi u jyè shìŋi niŋkwombaaŋi i, lir'à pwɔ́rɔ pi mu wà nafugombaage e ná ma tooyi shuunniŋi ná ma cyeyi shuunniŋi i. ");
INSERT INTO spp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mu ɲyiini là ká a si mu pyi mu u kapii pyi, li wwûl'a wà tatɔɔnge e, ɲaha na yɛ mu ɲyii niŋkin wuŋi u shìŋi niŋkwombaaŋi ta, lir'à pwɔ́rɔ pi mu wà nafugombaage e ná ma ɲyiigii shuunniŋi i.» ");
INSERT INTO spp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ka Yesu si núr'a jwo u cyelempyiibil'á: «Yii a yiye kàanmucaa dɛ! Yii àha ɲcwô ŋge nàŋkocyaaŋi w'e mɛ. Ɲaha na yɛ mii sí yi jwo yii á, pi mɛ̀lɛkɛɛbii ɲyɛ nìɲyiŋi na mii Tuŋi Kile yyahe taan tèrigii puni i.  ");
INSERT INTO spp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mpii pi à pînni ke, Supyaŋi Jyaŋi à pa mpa pire shwɔ. ");
INSERT INTO spp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ɲaha yii ɲyɛ na sɔ̂nŋi yɛ? L'aha mpyi mu à jwo mpàa ŋkuu (100) na ɲyɛ wà á, ka niŋkin si mpînni pire e, tá urufoo sì pi sanmpii beecyɛɛre ná kɛ ná baacyɛɛreŋi (99) yaha wabɛr'á ɲaŋke ɲuŋ'i, si sà a nimpinniŋi caa mɛ? ");
INSERT INTO spp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sèeŋi na mii sí yi jwo yii á, u aha jà a u cya a ɲya, u ɲyaŋi funntange sí n‑pêe u á mà tòro pi sanmpii beecyɛɛre ná kɛ ná baacyɛɛreŋi (99) woge na, pire mpiimu pi ɲyɛ pi ɲyɛ a pînni mɛ. ");
INSERT INTO spp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Amuni li mú ɲyɛ, yii Tuŋi u ɲyɛ nìɲyiŋi na ke, li ɲyɛ a táan ur'á ŋge pyàŋi wà niŋkin si mpînni mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Mu cìnmpworo ká wurugo mu á, sà u yyer'a fɛ̂ɛn, mu ná uru kanni, maa u kapyiini cyêe u na. U aha ɲɛn'a lógo mu á, yii cìnmpworoge sí n‑tɛ̀ɛn ku lyempe e. ");
INSERT INTO spp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ŋka u aha mpyi u ɲyɛ a ɲɛn'a lógo mu á mɛ, shin niŋkin, lire ɲyɛ mɛ shiin shuunni yyer'a bâra maye na, maa jwo ná u e, bà y'à sémɛ na “Karigii pun'à yaa cyi cwɔɔnrɔ shiin shuunni taanre ɲyii na” mɛ. ");
INSERT INTO spp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","U aha ɲcyé lógogo pir'á, sà yi yyaha jwo dánafeebii kuruŋk'á. U aha mpyi u ɲyɛ a lógo dánafeebii kuruŋk'á mɛ, ma hà núru raa u leni Kile kuni ɲaarafeebil'e mɛ, ta u wíi mu à jwo múnalwɔɔre shwofoo. ");
INSERT INTO spp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sèeŋi na mii sí yi jwo yii á, yii aha ɲcyé kyaa maha kyaa na ɲìŋke na ke, lire mú sí ɲcyè ta u à pyi lire na nìɲyiŋi na. Yii aha ɲɛɛ kyaa maha kyaa na ɲìŋke na ke, lire sí ɲɛɛ ta u à pyi lire na nìɲyiŋi na mú. ");
INSERT INTO spp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mii sí yi jwo yii á mú, sèeŋi na, yii shiin shuunni ká bɛ̂ li na, maa yaaga maha yaaga ɲáare mii Tuŋi á, uru u ɲyɛ nìɲyiŋi na ke, u sí kuru kan yii á. ");
INSERT INTO spp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ɲaha kurugo yɛ cyaga maha cyag'e shiin shuunni taanr'à bínni mii mɛge na ke, mii ɲyɛ pi shwɔhɔl'e.» ");
INSERT INTO spp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ɲyɛ ka Pyɛri si file Yesu na, maa jwo: «Kafooŋi! Mii cìnmpworo ká ŋkwôro na wuruge mii á, tooyi jùuli i mii à yaa mii u yàfa u na yɛ? Fo tooyo baashuunni la?» ");
INSERT INTO spp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ka Yesu si u pyi: «Mii sì n‑jwo mu á tooyo baashuunni mɛ. Ŋka mii sí n‑jwo mu á tooyo beetaanre ná kɛ (70) tatɛɛnyɛ baashuunni! ");
INSERT INTO spp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lire kurugo Kile Saanre à fworo nde kani kurugo: saanŋi wà u ná mpyi a li lwɔ́ uye funŋ'i si u báarapyiibii fwɔhigii pɛ̀rɛge cè, bà pi si mpyi si cyi sâra mɛ. ");
INSERT INTO spp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mà u yaha cyire fwɔhigii kataanmpe na, pi à pa ná báarapyiŋi w'e u yyére, saanŋi miliyoo niɲyahamii fwoo mpyi uru nàŋi na. ");
INSERT INTO spp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ná lire fwooni sârasara sí mpyi uru báarapyiŋi na mɛ, ka u ɲùŋufooŋi si jwo na pi u ná u cwoŋi ná u pyìibii ná u cyeyaayi puni pɛ́rɛ, bà lire fwooni si mpyi si ntò mɛ. ");
INSERT INTO spp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ɲyɛ báarapyiŋ'à yire lógo ke, maa niŋkure sín u ɲùŋufooŋi fere e maa jwo “Mii ɲùŋufooŋi! Maye sanŋa yaha, maa na tàanna, mii sí mu fwooni puni tò mu á.” ");
INSERT INTO spp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ɲyɛ u ɲùɲaar'à jyè ɲùŋufooŋi i ke, ka u u lire fwooni puni yaha a cyán, maa u cye yaha. ");
INSERT INTO spp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ɲyɛ ka uru báarapyiŋi si fworo na ŋkɛ̀ɛge mà sà bɛ̂ ná u báarapyiɲɛɛŋi w'e. U wyɛ́rɛbilere fwoo mpyi uru na, ka u u uru cyán a cwôro yacige e, maa u pyi “Na fwooni sâra!” ");
INSERT INTO spp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ka u báarapyiɲɛɛŋi si niŋkure sín u fere e, maa u ɲáare sèl'e “Maye sanŋa yaha maa na tàanna, mii sí mu fwooni tò.” ");
INSERT INTO spp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ŋka u ɲyɛ a ɲɛɛ mɛ, maa nàŋi tò kàsuŋi i, fo u aha uru fwooni tò. ");
INSERT INTO spp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ɲyɛ u báarapyiɲɛɛbii sanmpil'à lire ɲya ke, ka li i mpɛn pi e sèl'e, ka pi i ŋkàr'a sà yire paara ɲùŋufooŋ'á. ");
INSERT INTO spp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ka ɲùŋufooŋi si pi pyi pi à u yyere. U à pa ke, ka ɲùŋufooŋi si u pyi “Shinpi wà we! Mii à mu fwooni puni yaha a cyán, ɲaha na yɛ mu à mii ɲáare. ");
INSERT INTO spp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mii à mu ɲùɲaara ta taŋkanni ndemu na ke, mu mpyi na sì n‑jà ɲùɲaara ta ma báarapyiɲɛɛŋi na amuni mà?” ");
INSERT INTO spp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɲyɛ ka ɲùŋufooŋi lùyiri wuŋi si uru báarapyiŋi pyi pi à le kàsuŋi i u a ŋkyaali fo u aha uru fwooni puni tò. ");
INSERT INTO spp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ɲyɛ lire pyiŋkanni na li mú ɲyɛ, yii shin maha shin u ɲyɛ u ɲyɛ na yàfani u cìnmpworoŋi na ná u zòmbilini puni i mɛ, amuni Kile sí urufoo cû.» ");
INSERT INTO spp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ɲyɛ Yesu à kwɔ̀ puru jwumpe na ke, maa yîri Galile kùluni i, mà kàre Zhude kùluni i, Zhurudɛn baŋi kàntugo. ");
INSERT INTO spp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Shinɲyahara mpyi a taha u fye e, mpii pi mpyi na yà ke, ka u u pire cùuŋɔ wani. ");
INSERT INTO spp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ka Farizhɛɛnbii pìi si file si u pɛrɛ ɲcû ná jwumpe e, maa u yíbe: «Mà tàanna ná wuu Saliyaŋi i, tá nɔ̀ŋ'à yaa u jà a u cwoŋi nàmbage kwɔ̀ ɲùɲyi puni na bɛ?» ");
INSERT INTO spp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ka Yesu si pi pyi: «Ɲje y'à sémɛ Kile Jwumpe Semɛŋi i ke, yii ɲyɛ a yire kâla mà? Diɲyɛŋi tasiige e, diɲyɛŋi Davooŋi à “sùpyaŋi yaa nɔ̀ ná ceewe.” ");
INSERT INTO spp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Lire kurugo nɔ̀ŋi sí u tuŋi ná u nuŋi yaha si mpwɔ u cwoŋi na, pi mú shuunni si mpyi shin niŋkin.” ");
INSERT INTO spp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lire e pi saha sì n‑pyi shiin shuunni mɛ, ŋka pi sí n‑pyi shin niŋkin. Lire kurugo Kile à mpiimu pyi niŋkin ke, sùpya ɲyɛ a yaa u pire láha piye na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɲyɛ ka Farizhɛɛnbii si núr'a jwo: «Lire sanni i ke, ɲaha na Kile tùnntunŋiMusa s'à jwo na nɔ̀ ká a ŋko raa u cwoŋi nàmbage kwùu, u nàmbage kwɔ̀kwɔ sémɛŋi kan ceeŋ'á, u u nta a ku kwɔ̀ yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ka Yesu si pi pyi: «Yii ɲjíŋgage kurugo, Musa à cyeebii nàmbakwooni kuni kan yii á. Lire baare e diɲyɛŋi tèesiini i, amuni bà li mpyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ŋka mii sí yi jwo yii á, shin maha shin u à u cwoŋi nàmbage kwɔ̀ ɲùŋke kabɛrɛ na, mà ta jacwɔrɔ bà mɛ, maa ceeŋi wabɛrɛ lèŋɛ ke, urufol'à jacwɔrɔ pyi.» ");
INSERT INTO spp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ɲyɛ ka cyelempyiibii si jwumpe lwɔ́ maa jwo: «Kampyi nɔ̀ŋi tayyérege ku ɲyɛ kure mà yyaha tíi ná u cwoŋi i, ɲùŋɔ mú bá naha cileŋɛni na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ka Yesu si pi pyi: «Sùpyire puni sì n‑jà cileŋɛmbaani na mɛ, fo Kile ká li pyimɛ táan mpiimu á ke. ");
INSERT INTO spp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Karii niɲyahagii na ɲyɛ wani ɲcyiimu cyi maha jà a nɔ̀ŋi sige cileŋɛni na ke. Pìi na ɲyɛ wani, pi sì n‑jà ceewe lèŋɛ mɛ, ɲaha na yɛ pi à si amuni. Pìi u cileŋɛmbaani ɲùŋk'à fworo sùpyire e, ɲaha na yɛ pi à pi nànte kɛ̀ɛge. Pìi mú maha ɲcyé cileŋɛni na Kile Saanre kurugo. Ŋgemu u sí n‑jà ɲɛɛ puru jwumpe na ke, urufoo u ɲɛɛ pu na.» ");
INSERT INTO spp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ɲyɛ lire kàntugo, sùpyiibii pìl'à pa ná nàŋkopyire t'e Yesu yyére, bà u si mpyi si u cyeyi taha ti na, si Kile ɲáare t'á mɛ. Ka cyelempyiibii si pi faha. ");
INSERT INTO spp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ka Yesu si jwo: «Yii nàŋkopyire yaha t'a ma mii yyére, yii àha ti sige na na mɛ. Ɲaha kurugo yɛ sùpyire t'à tiye pyi nte nàŋkopyire fiige ke, Kile Saanre ɲyɛ pire woro.» ");
INSERT INTO spp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ɲyɛ u à puru jwo ke, maa u cyeyi taha ti ɲùɲyi na maa jwó le t'á, maa nta a yîri kuru cyage e mà kàre. ");
INSERT INTO spp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ɲyɛ mà Yesu niŋkareŋi yaha, nàŋi wà à file u na maa jwo: «Cyelentuŋi! Kacɛnni ndire mii à yaa mii u pyi si shìŋi niŋkwombaaŋi ta yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ka Yesu si u pyi: «Ɲaha na mu ɲyɛ na mii yíbili kacɛnni kyaa na yɛ? Shin niŋkin kanna u à ɲwɔ. Mu la ká mpyi si shìŋi sèe wuŋi ta, ta Kile toŋi kurigii ɲaare.» ");
INSERT INTO spp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ka nàŋi si Yesu yíbe: «Kurigii ɲcyire yɛ?» Ka Yesu si jwo: «“Ma hà sùpya bò mɛ, ma hà zínni ná wabɛrɛ cwo e mɛ, ma hà nàŋkaaga pyi mɛ, ma hà vini ntaha wà na mɛ, ");
INSERT INTO spp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ma tuŋi ná ma nuŋi pêe.” “Ma supyiɲɛɛŋi kyaa táan may'á bà mu kyal'à táan may'á mɛ.”» ");
INSERT INTO spp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ka nàɲjiiŋi si Yesu pyi: «Mii na cyire karigii puni pyi. Ɲaha shi saha k'à mii fô yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ka Yesu si u pyi: «Kampyi mu la ɲyɛ si mpyi tìgirecyaga baa, ta sì maa sà ma cyeyaayi puni pɛ́rɛ, maa uru wyɛ́rɛŋi kan fòŋɔfeebil'á. Lire ká mpyi, mu sí nàfuu ta Kile yyére. Maa nta a pa ntaha na fye e.» ");
INSERT INTO spp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɲyɛ uru nàɲjiiŋ'à puru lógo ke, ka u yyetanha wuŋi si ŋkàre, ɲaha na yɛ nàfuubwɔhɔ foo u mpyi u wi. ");
INSERT INTO spp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ɲyɛ ka Yesu si yi jwo u cyelempyiibil'á: «Sèeŋi na mii sí yi jwo yii á, nàfuufooŋi jyìm'à pɛn Kile Saanre e. ");
INSERT INTO spp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mii sí yi jwo yii á sahaŋki, ɲwɔhɔŋi jyìm'à táan músennɛŋi wyiini i, mà tòro nàfuufooŋi u jyè Kile Saanre e.» ");
INSERT INTO spp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ka puru si u cyelempyiibii kàkyanhala fo mà tòro, ka pi i jwo: «Lire sanni i ke, jofoo u sí n‑jà nùmpanŋa ta bɛ?» ");
INSERT INTO spp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ka Yesu si pi wíi wíi maa jwo: «Lir'à sùpyire jà, ŋka kyaa ɲyɛ na Kile jìni mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ka Pyɛri si jwumpe lwɔ́ maa Yesu pyi: «Wuu de? Wuu à kàntugo wà wuu karigii puni na, maa ntaha mu fye e! Wuu nàzhanŋi u ɲyɛ ŋgire yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ka Yesu si pi pyi: «Sèeŋi na mii sí yi jwo yii á, yaayi puni ká mpa mpyi nivɔnyɔ tèni ndemu i ke, Supyaŋi Jyaŋi ká mpa ntɛ̀ɛn u fànhe tatɛɛnge nisinaŋke e tèni ndemu i ke, yii pi ɲyɛ mii fyèɲwɔhɔshiinbii ke, yii sí n‑pa n‑tɛ̀ɛn fànhe tatɛɛnyɛ kɛ ná shuunni i, s'a Izirayɛli tùluyi kɛ ná shuunniŋi shiinbii kɛ̂ɛnŋi. ");
INSERT INTO spp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɲyɛ shin maha shin ká ɲɛn'à kàntugo wà u bayi, lire ɲyɛ mɛ u sìɲɛɛbii, lire ɲyɛ mɛ u sifeebii, lire ɲyɛ mɛ u pyìibii, lire ɲyɛ mɛ u kɛrɛyi na mii mɛge kurugo ke, urufoo sí yire fiigii ŋkuu (100) ta, si shìŋi niŋkwombaaŋi ta. ");
INSERT INTO spp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ŋka yyahe yyére shiin niɲyahamii sí n‑pyi kàntugo yyére shiin, kàntugo yyére wuu niɲyahamii mú sí n‑pyi yyahe yyére wuu.» ");
INSERT INTO spp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Ɲyɛ Kile Saanre à fworo nde kani kurugo: kɛrɛge fooŋi wà à yîri ɲyɛ̀sɔɔge na maa ŋkàr'à sà a báarapyii caa u ɛrɛzɛn cikɔɔge báaraŋi mɛɛ na. ");
INSERT INTO spp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Báarapyiibii kɛrɛge fol'à ta ke, u ná pir'à bɛ̂ canmpuŋke sàraŋi na. Ɲyɛ ka u u pi yaha a kàre cikɔɔge e. ");
INSERT INTO spp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Canŋk'à pa nɔ cyage e ke, ka kɛrɛge foo si sà sùpyire tà ta kàfuge na pi à tɛ̀ɛn là mpyimbaa. ");
INSERT INTO spp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ka u u pi pyi “Yii yîri mú, yii a sì na ɛrɛzɛn cikɔɔge e, yii i sà a báaraŋi pyi, yii ná sàraŋi u à yaa ke, mii sí uru kan yii á.” ");
INSERT INTO spp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ka pire si ŋkàre cikɔɔge e. Ɲyɛ ka cikɔɔge foo si núr'a fworo canvwuge na, maa pìi ta. Canvyinge laage e, maa núr'a pìi ta, maa pire puni pyi pi à kàre kɛrɛge e. ");
INSERT INTO spp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yàkoŋke laage e u à pa fworo sahaŋki, mà sà pìi ta pi i yyéreli cyage k'e, ka u u jwo pir'á “Ɲaha na yii à yyérel'a canŋke kwɔ̀ là mpyimbaa yɛ?” ");
INSERT INTO spp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ka pire si u pyi “Mu aha li ɲya amuni, wà ɲyɛ a wuu lwɔ́ báaraŋi na niɲjaa mɛ.” Ka u u jwo “Yii a sì na ɛrɛzɛn cikɔɔge e.” ");
INSERT INTO spp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ɲyɛ yàkoŋk'à pa nɔ ke, ka cikɔɔge foo si jwo u pyɛnge kacwɔnrɔŋ'á “Báarapyiibii yyere ma a pi sàraŋi kan pi á, ŋka báarapyiibii pi à pa kàntugo ke, ku sìi pire na, ma a sì niɲcyiibil'á.” ");
INSERT INTO spp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mpii pi à pa yàkoŋke ke, pir'à canmpuŋke sàraŋi ta. ");
INSERT INTO spp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ɲyɛ ka báarapyiibii niɲcyiibii si file, maa sɔ̂nŋi na pire u nintaŋi si ɲyaha, ŋka yaaga ɲyɛ a bâra u na mɛ, pi shin maha shin à canmpuŋke sàraŋi ta mú. ");
INSERT INTO spp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ɲyɛ wyɛ́rɛŋi kanŋkwooni kàntugo pi á, ka pi i wá na cikɔɔge foo ɲùŋke tare maa ŋko ");
INSERT INTO spp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Mpii pi à pa yàkoŋke ke, tère nimbilere kanna báara pir'à pyi, ka mu u wuu ná pire u sàraŋi pyi niŋkin, mà li ta wuu à canmpuni pyi báaraŋi na, canŋke kafuge e.” ");
INSERT INTO spp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ka cikɔɔge foo si jwumpe lwɔ́ maa jwo pi wà niŋkin á “Na cevoo, mii ɲyɛ a cwo mu na mɛ. Taha canmpuŋke sàraŋi na bà mii ná mu mpyi a bɛ̂ mɛ? ");
INSERT INTO spp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma sàraŋi shwɔ maa yîri naha. Ŋge u à kan mu á ke, l'à táan mii á mii i uru ninuŋi kan kàntugo yyére shinpaŋ'á. ");
INSERT INTO spp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lire sanni i, taha mii wu bà u ɲyɛ na wyɛ́rɛŋi mɛ? Kacɛnni mii à pyi ke, taha lire yiɲcyɛge ku ɲyɛ mu i?” ");
INSERT INTO spp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Amuni li mú ɲyɛ, kàntugo yyére shiin niɲyahamii sí n‑pyi yyahe yyére shiin, yyahe yyére shiin niɲyahamii mú sí n‑pyi kàntugo yyére shiin.» ");
INSERT INTO spp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ɲyɛ mà Yesu niŋkareŋi yaha Zheruzalɛmu kànhe e, u à u cyelempyiibii kɛ ná shuunniŋi yyere pi mɛgɛ cyage e kuni na maa jwo: ");
INSERT INTO spp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Wuu niŋkaribii pi mpii Zheruzalɛmu i, wani pi sí Supyaŋi Jyaŋi le Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii cye e. Pire sí n‑jwo na u à yaa u bò, ");
INSERT INTO spp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","si u le Kilecembaabii cye e, pire sí u fwɔ́hɔrɔ, si u bwɔ̀n ná tiripaanni i, si u kwòro cige na si mbò. Ŋka u kwùŋi canmpyitanrewuuni, u sí ɲɛ̀.» ");
INSERT INTO spp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ɲyɛ ka Zebede cwoŋi si file Yesu na ná u jyaabil'e, maa niŋkure sín, maa u ɲáare. ");
INSERT INTO spp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ka Yesu si u yíbe: «Ɲaha shi la ku wá mu na yɛ?» Ka u u jwo: «Mii jyaabii pi mpii ke, mu aha mpa ntɛ̀ɛn ma saanre e tèni ndemu i ke, ma a wà yaha u tɛ̀ɛn ma kàniŋke na, ma a u sanŋi yaha ma kàmɛni na.» ");
INSERT INTO spp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ka Yesu si pi pyi: «Yaage yii na ɲáare mii á ke, yii ɲyɛ a ku shi cè mɛ. Kyaage lwɔhe mii sí n‑bya ke, yii sí n‑jà kuru bya la?» Ka pi i u pyi: «Ɔɔn, wuu sí n‑jà.» ");
INSERT INTO spp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka u u pi pyi: «Yii sí kyaage lwɔhe bya mii fiige. Ŋka mà tɛ̀ɛn mii kàniŋke ná mii kàmɛni na, mii bà u ɲyɛ yire kanvooŋi mɛ. Mii Tuŋi à yire tatɛɛnyi bégele sùpyire ntemu mɛɛ na ke, u sí yi kan tir'á.» ");
INSERT INTO spp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ɲyɛ Yesu cyelempyiibii kɛŋi sanŋ'à puru jwumpe lógo ke, ka pire lùgigii si yîri mpii cìnmpyiibii shuunniŋi taan. ");
INSERT INTO spp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu à pa kuru cyage wíl'a ɲya ke, maa yi jwo u cyelempyiibii pun'á: «Yii a núru, yii à cè naha ɲìŋke na, kìni ɲùŋufeebii maha ntɛ̀ɛn kìni sùpyire ɲuŋ'i fànhe e, kìni shinbwoobil'a sì wá na pi fànhe cyáan kìni sùpyire na. ");
INSERT INTO spp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Li ɲyɛ a yaa li pyi amuni yii shwɔhɔl'e mɛ. Ŋgemu la ku ɲyɛ si mpyi shinbwo yii shwɔhɔl'e ke, urufol'à yaa u uye pyi yii sanmpii báarapyi. ");
INSERT INTO spp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ŋgemu la ku ɲyɛ si mpyi yii yyaha yyére shinŋi ke, urufol'à yaa u uye pyi yii sanmpii biliwe. ");
INSERT INTO spp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ɲaha kurugo yɛ Supyaŋi Jyaŋi ɲyɛ a pa diɲyɛŋi i sùpyire si mpa mpyi u báarapyii mɛ. U à pa si mpa uye pyi sùpyire báarapyi, si uye kan pi bò, si mpyi shinɲyahara kapegigii shwɔshwɔ lwɔrɔ.» ");
INSERT INTO spp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ná u cyelempyiibii nivworobii Zheriko kànhe e, supyikurumbwɔhɔ mpyi a taha u fye e. ");
INSERT INTO spp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Fyinmii shuunni mpyi a tɛ̀ɛn kuni ɲwɔge na, pir'à pa lógo na Yesu u ɲyɛ na ntùuli ke, ka pi i wá na yu fànha na: «Kafooŋi! Dawuda Tuluge Shinŋi! Ɲùɲaara ta wuu na.» ");
INSERT INTO spp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka sùpyire si pi faha na pi fyâha. Ŋka pi ɲyɛ a ɲɛn'a fyâha mɛ, maa là bâra pi sɛ̀ɛge na: «Kafooŋi! Dawuda Tuluge Shinŋi! Ɲùɲaara ta wuu na!» ");
INSERT INTO spp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ka Yesu si yyére maa pi yyere maa pi yíbe: «Ɲaha yii la ɲyɛ mii u pyi yii á yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka pi i jwo: «Kafooŋi, wuu ɲyiigii múgo, wuu raa ɲaa.» ");
INSERT INTO spp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ɲyɛ ka pi ɲùɲaare si u ta sèl'e, ka u u bwɔ̀n pi ɲyiigii na. Lire tèni mujye e, ka pi i ntìi na ɲaa, maa ntaha u fye e. ");
INSERT INTO spp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mà pi yaha pi i byanhare Zheruzalɛmu kànhe na, pi mpyi a nɔ Bɛtifajye kànhe na, Olivye cire ɲaŋke kàmpanŋke na. Ka Yesu si u cyelempyiibii pìi shuunni tun, ");
INSERT INTO spp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","maa pi pyi: «Kànhe ku ɲyɛ yii yyaha na ke, yii a sì k'e. Yii aha sà nɔ wani, yii sí n‑tíi pi ta pi à dùfaanɲcwo ná u pyà pwɔ wani. Yii i yi sànha, yii pa ŋkan na á. ");
INSERT INTO spp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wà ha yà jwo yii na, yii i urufoo pyi “Yi kyaa li ɲyɛ Kafooŋi na, u aha ŋkwɔ̀ yi na, yi sí n‑pa.”» ");
INSERT INTO spp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesu à yire dùfaanɲyi cya, bà tèecyiini Kile tùnntunŋi jwumpe si mpyi si fûnŋɔ mɛ. U mpyi a jwo: ");
INSERT INTO spp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Yii yi jwo Siyɔn kànhe shiinbil'á na: “Yii wíi! Yii saanŋi wá na ma yii yyére, u ɲùŋk'à pi sèl'e, u à dùg'a tɛ̀ɛn dùfaanŋa ɲuŋ'i, dùfaannuŋi pyìge kà ɲuŋ'i.”» ");
INSERT INTO spp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ɲyɛ ka cyelempyiibii mú shuunni si ŋkàre, nde Yesu mpyi a jwo ke, maa sà lire pyi. ");
INSERT INTO spp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pi à pa ná dùfaannuŋi ná u pyìge e ke, maa pi vàanɲyi yà taha ku na, ka Yesu si dùg'a tɛ̀ɛn na ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sùpyire niɲyahara mpyi kuni ɲwɔge na, ka ti niɲyahara si ti vàanntinɲyi yà wwû mà pìli pìli Yesu yyaha na kuni i, ka pìi si weyi kwɔ̀n kwɔ̀n a pìli kuni i. ");
INSERT INTO spp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sùpyire ti mpyi Yesu yyaha na ná nte ti mpyi u kàntugo ke, tire puni mpyi na ŋkwúuli maa ŋko: «Yabwɔhe! Dawuda Tuluge Shinŋi wi! Ŋgemu u ɲyɛ na ma Kafooŋi Kile mɛge na ke, Kile u jwó le u á! Pèente ti taha Kile na nìɲyicyeyi puni i.» ");
INSERT INTO spp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ɲyɛ Yesu à pa jyè Zheruzalɛmu kànhe e ke, ka kànhe puni si yîr'a taha, fo pi na piye yíbili: «Taha jofoo u wà urufoo yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka sùpyire si pi pyi: «Yesu wi, Kile tùnntunŋi u à yîri Nazarɛti i, Galile kùluni i ke.» ");
INSERT INTO spp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ɲyɛ ka Yesu si ŋkàre Kileɲaarebage ntàani na. Mpii pi mpyi na pɛrɛmpe ná zhwoŋi pyi wani ke, maa pire kɔ̀re, maa wyɛ́rɛfaabii tàbalibii ná sanmpanmpɛrɛbii yatɛɛnɲyi ŋɔɔŋ'a cyán cyán. ");
INSERT INTO spp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Maa pi pyi: «“Mii bage sí n‑pa a yiri Kileɲaarebaga.” Yire y'à sémɛ Kile Jwumpe Semɛŋi i. Ŋka yii pi ke, yii à ku kɛ̂ɛnŋ'a pyi “nàŋkaalii tabinniga”.» ");
INSERT INTO spp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ka fyinmpii pìi ná dìshiyifeebii pìi si file u na Kileɲaarebage e, ka u u pire cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ɲyɛ Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibil'à cyire kakyanhala karigii ɲya tapyige e, maa nàŋkopyire ɲya ti i yu fànha na: «Yabwɔhe! Dawuda Tuluge Shinŋi wi!» ke, ka pire lùuni si yîri, ");
INSERT INTO spp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","maa Yesu pyi: «Ɲje pi ɲyɛ na yu ke, taha mu wá na yi núru mɛ?» Ka Yesu si pi pyi: «Mii naha na yi núru. Taha yii sàha ŋkwɔ̀ a mpe jwumpe kâla Kile Jwumpe Semɛŋi i na “Kile à u pèente jwumpe le nàŋkopyire ná jiriŋwɔrɔ pyìibii ɲwɔyi i” mɛ?» ");
INSERT INTO spp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ka Yesu si yîri pi taan, maa fworo kànhe e, mà kàre Bɛtani kànhe e, maa shwɔ̀n wani. ");
INSERT INTO spp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kuru canŋa nùmpanŋa, Yesu ninuruŋi na ŋkɛ̀ɛge Zheruzalɛmu i, ka katege si u ta. ");
INSERT INTO spp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ka u u fizhiye cige ɲya kuni na, maa file ku na. Wyɛɛre baare e, u ɲyɛ a yasɛrɛ ta ku na mɛ, maa jwo ku na: «Ma hà zìi núru yasɛrɛ se ɲya mɛ!» Ka cige si ntíl'a waha. ");
INSERT INTO spp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cyelempyiibil'à lire ɲya ke, ka li i pi bilibili fo pi à yíbe na: «Di ŋke fizhiye cig'à pyi maa waha tèenuuni i yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka Yesu si pi pyi: «Sèeŋi na mii sí yi jwo yii á, yii aha nta yii à dániyaŋi pyi ná funŋɔ niŋkin i, nde mii à pyi ŋke fizhiye cige na ke, yii sí lire fiige pyi, lire kanni bà mɛ, yii aha jwo ŋke ɲaŋke ku kò a yîri ku tatɛɛnge e ku sà ɲcwo baŋi i, lire sí n‑pyi. ");
INSERT INTO spp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yii aha Kile ɲáare yaaga maha yaaga kurugo ná dániyaŋi i ke, yii sí kuru ta.» ");
INSERT INTO spp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ka Yesu si jyè Kileɲaarebage e, maa sùpyire kâlali. Mà u yaha lire na, ka Kile sáragawwuubii ɲùŋufeebii ná Yahutuubii kacwɔnribii si shà u yyére, maa u yíbe: «Ná kuni ndire e mu na ɲcyii karigii pyi yɛ? Jofoo u à kuni kan mu á, mu u a cyi pyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ka Yesu si pi pyi: «Mii mú sí yii yíbe kyaa niŋkin na, yii aha mii ɲwɔ shwɔ, lire tèni i, ŋge u à kuni kan mii á, mii u a ɲcyii karigii pyi ke, mii sí n‑ta urufoo cyêe yii na. ");
INSERT INTO spp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mii à jwo yo, jofoo u mpyi a Yuhana Batizelipyiŋi tun u pa a sùpyire batizeli yɛ? Kile laa, sùpyire?» Ɲyɛ ka pi i ŋkàr'a sà piye taanna maa jwo: «Wuu aha jwo na Kile u mpyi a Yuhana tun, u sí n‑jwo na ɲaha na wuu sí ɲyɛ a ɲɛn'a dá u na mà yɛ? ");
INSERT INTO spp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wuu sí ká jwo na sùpya u mpyi a u tun, sùpyire sì li yaha wuu na mɛ, ɲaha na yɛ pi pun'à tɛ̀ɛn ná l'e na Yuhana na mpyi Kile tùnntunŋɔ.» ");
INSERT INTO spp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pi à piye taanna a kwɔ̀ ke, maa núr'a kàr'a sà Yesu pyi: «Shinŋi u mpyi a u tun ke, wuu ɲyɛ a cè mɛ.» Ka Yesu si pi pyi: «Ɲyɛ l'aha mpyi amuni, ŋge u à kuni kan mii á, mii u a ɲcyii karigii pyi ke, mii mú sì uru cyêe yii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ka Yesu si núr'a jwo: «Ɲaha shi yii ɲyɛ na sɔ̂nŋi mpe e yɛ? Nàŋi wà u ná mpyi ná jyafee shuunni i, maa jwo niɲcyiiŋ'á “Na jya, sà báara na ɛrɛzɛn cikɔɔge e niɲjaa.” ");
INSERT INTO spp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ka jyafooŋi si jwo “Mii nàha na sì mɛ.” Ŋka kàntugo yyére, u à pa ntɛ̂r'a núru, maa ŋkàre cikɔɔge e. ");
INSERT INTO spp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ka tufooŋi si puru ninumpe taha jyafooŋi shɔnwuŋ'á, ka uru si jwo “Baa, mii sí n‑kàre” ŋka u ɲyɛ a pa ŋkàre mɛ. ");
INSERT INTO spp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pire shiin shuunniŋi i, u ŋgire u à tufooŋi ɲyii wuuni pyi yɛ?» Ka pi i jwo: «Jyafooŋi niɲcyiiŋi.» Ka Yesu si pi pyi: «Sèeŋi na mii sí yi jwo yii á, múnalwɔɔre shwofeebii ná fwòrobacyeebii sí n‑jyè Kile Saanre e yii yyaha na. ");
INSERT INTO spp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ɲaha kurugo yɛ Yuhana Batizelipyiŋi à pa ntìiŋi kuni cyêe yii na, yii ɲyɛ a ɲɛn'a dá u na mɛ. Ŋka múnalwɔɔre shwofeebii ná fwòrobacyeebil'à ɲɛn'a dá u na. Yii sí pi à lire ɲya ke, yii ɲyɛ a ɲɛn'a tɛ̂r'a núru maa dá u na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ka Yesu si núr'a jwo: «Yii bàtaage kà lógo sahaŋki. Pyɛngefooŋi wà u ná ɛrɛzɛn cikɔɔgɔ yaa, maa ku kwûulo, ɛrɛzɛn lwɔhe maha wwû wyige ŋkemu i ke, maa kuru tùgo, maa ŋkubaga yaa cikɔɔge kàanmucyafooŋi mɛɛ na. Lire kàntugo maa faafee lwɔ́ a yaha k'e, u ná pire s'a ku yasɛɛre táali piye na, maa nta a kàre kùlutɔɔnl'e. ");
INSERT INTO spp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ɲyɛ ɛrɛzɛnŋi yasɛɛre tèekwɔɔnn'à pa nɔ ke, ka u u u báarapyiibii pìi tun u cikɔɔge faafeebil'á pi sà uru nàzhan yasɛɛre shwɔ pi a ma. ");
INSERT INTO spp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ka faafeebii si pire báarapyiibii cyán a cû, maa wà bwɔ̀n, maa wà bò, maa u sanŋi wà ná kafaayi i. ");
INSERT INTO spp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ka cikɔɔge foo si núr'a báarapyiibii piibɛrɛ tun pi á, pire mpyi a ɲyaha mà tòro niɲcyiibii na, ka faafeebii si pire pyi niɲcyiibii fiige. ");
INSERT INTO spp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ka cikɔɔge foo si ŋkànha a u yabiliŋi jyaŋi tun pi á, maa jwo “Pi sí n‑sílege mii jyaŋi na.” ");
INSERT INTO spp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ŋka faafeebil'à cikɔɔge foo jyaŋi ɲya ke, maa wá na yu piy'á “Cikɔɔge foo koolyiŋi u ɲyɛ ŋge. Yii a wá, wuu u bò, kɔɔge sí n‑pyi wuu wogo.” ");
INSERT INTO spp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ka pi i jyafooŋi cyán a cû mà wà cikɔɔge kàntugo, maa u bò.» ");
INSERT INTO spp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ɲyɛ Yesu à puru jwo ke, maa sùpyire yíbe: «Numɛ, cikɔɔge foo ká mpa, ɲaha u sí n‑pyi ku faafeebii na bɛ?» ");
INSERT INTO spp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ka pi i u pyi: «Cikɔɔge foo sí pire shinpiibii puni bompere bò, si cikɔɔge kan piibɛril'á, mpiimu pi sí raa ku yasɛɛre kaan u á ti tèewwuuni i ke.» ");
INSERT INTO spp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ka Yesu si jwo: «Ɲje y'à sémɛ Kile Jwumpe Semɛŋi i ke, taha yii ɲyɛ a yire kâla mɛ? Y'à sémɛ: “Bafaanribil'à cyé kafaage ŋkemu na ke, kuru k'à pa mpyi bage kafaage sèe woge bage mbìini na. Kafooŋi Kile u à lire pyi, l'à pyi kakyanhala wuu ɲyii na.” ");
INSERT INTO spp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Lire kurugo mii sí yi jwo yii á: yii sí n‑yige Kile Saanre e, si supyishiŋi wabɛrɛ lèŋɛ t'e, mpiimu pi sí raa Kile ɲyii wuuni pyi ke.  ");
INSERT INTO spp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ɲyɛ shin maha shin u à cwo kuru kafaage ɲuŋ'i ke, urufoo sí n‑kyɛɛgɛ n‑kyɛɛgɛ, kuru kafaage sí ká ɲcwo shin maha shin ɲuŋ'i ke, ku sí urufoo cwɔ̀nhɔnɔ.» ");
INSERT INTO spp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ɲyɛ Kile sáragawwuubii ɲùŋufeebii ná Farizhɛɛnbil'à Yesu bàtaayi lógo ke, ka pi i nta a cè na pire kyaa na u mpyi. ");
INSERT INTO spp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ka pi i wá na ɲcaa si u cû, ŋka pi mpyi na fyáge sùpyire yyaha na, ɲaha na yɛ sùpyire mpyi a tɛ̀ɛn ná l'e na u na ɲyɛ Kile tùnntunŋɔ. ");
INSERT INTO spp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ka Yesu si núr'a bàtaaga jwo pi á, u à jwo: ");
INSERT INTO spp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Kile Saanre à fworo nde kani kurugo: saanŋi wà à kataan nimbwoo bégele u jyaŋi cikwɔɔnre tooy'e. ");
INSERT INTO spp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","U à bégel'a kwɔ̀ ke, mpii pi mpyi a yyere ke, ka u u u báarapyiibii tun pi sà pire pyi pi a ma, ka pi i ɲcyé paŋa. ");
INSERT INTO spp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ka u u núr'a báarapyiibii pìi tun, maa pire pyi “Yii sà yi jwo shinyyerebil'á na mii naha a lyìmbwoo yaa, na mii naha a na nupyahigii cyìi ná yatɔɔre sìnmɛ woore tà bò, na mii naha a bégel'a kwɔ̀, na pi a ma cikwɔɔnre zànnɛɛg'á.” ");
INSERT INTO spp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ŋka pi wà ɲyɛ a saanŋi yini lwɔ́ a wíi mɛ. Ka wà bá si yîr'a kàre u kɛrɛge e, ka wà si ŋkàre u cwɔ̀hɔnt'á, ");
INSERT INTO spp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ka pi sanmpii si saanŋi báarapyiibii cyán a cû, maa pi kyérege, maa pi bò. ");
INSERT INTO spp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ka saanŋi lùuni si yîri, ka u u u kàshikwɔɔnbii yîrige pi à sà pire shinbompii bò, maa pi kànhe súugo. ");
INSERT INTO spp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ɲyɛ ka u u núr'a jwo u báarapyiibil'á “Cikwɔɔnre ɲjyìŋ'à bégele, ŋka shinyyerebii ná uru ɲjyìŋi mpyi a yaa mɛ. ");
INSERT INTO spp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yii a sì kuɲuɲyi na, yii aha shin maha shin ɲya ke, yii uru yyere cikwɔɔnre zànnɛɛge na.” ");
INSERT INTO spp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ka báarapyiibii si yîr'a kàre kurigii ɲwɔyi na. Shin maha shin pi à ta wani ke, maa pire puni yyer'a pa ntɛ̀g'a cikwɔɔnre bage ɲî, shinpii bâra shincɛnmii na. ");
INSERT INTO spp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ka saanŋi si jyè si shinyyerebii wíi, mà nàŋi wà ta pi shwɔhɔl'e, cikwɔnvaanɲyi baa. ");
INSERT INTO spp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ka saanŋi si u pyi “Na cevoo! Di mu à pyi maa jyè naha mà ta cikwɔnvaanɲyi ɲyɛ mu na mà yɛ?” Uru nàŋi ɲyɛ a yà ta a jwo mɛ. ");
INSERT INTO spp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ka saanŋi si u báarapyiibii pyi “Yii u tooyi ná u cyeyi pwɔ, yii i u wà cyíinŋi na numpini i, wani sùpyire maha myahigii súu marii ŋkyànhigii kùru.”» ");
INSERT INTO spp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu à bàtaage jwo a kwɔ̀ ke, maa núr'a jwo: «Yii li cè na Kile à shinɲyahara yyere, ŋka shinɲyahara ɲyɛ a cwɔɔnrɔ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɲyɛ ka Farizhɛɛnbii si ŋkàr'a sà piye taanna, si kànhaŋa cyán Yesu na, bà pi si mpyi si u ta ɲcû ná u yabiliŋi ɲwɔjwumpe e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Maa pi cyelempyiibii pìi ná Erɔdi toŋkuni shiinbii pìi tun Yesu á, ka pire si sà u pyi: «Cyelentuŋi! Wuu à li cè na mu ɲyɛ na fyáge sèeŋi tajwuge e mɛ. Jwumpe mu sí ɲyɛ na yu mà yyaha tíi ná Kile kuni i ke, puru na ɲyɛ sèe, mu ɲyɛ na fyáge sùpya na mɛ, mu ɲyɛ a sùpya pwɔ́ɔŋɔ sùpya na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lire e ke ma taɲyage jwo wuu á: wuu à yaa wuu a múnalwɔɔre kaan Ɔrɔmu saanbwɔhe Sezari á la?» ");
INSERT INTO spp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ŋka Yesu mpyi a fworo pire cwofeebii cwɔ̀ɔre ɲwɔhɔ na, ka u u pi pyi: «Yii pi à fyìnmɛ tò wwomɔ na ke, ɲaha na yii na mii pɛre si ɲcû yɛ? ");
INSERT INTO spp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wyɛ́rɛŋi yii ɲyɛ na ntɛ̀ge na múnalwɔɔre sârali ke, yii uru wà cyêe na na wee.» Ɲyɛ ka pi i uru wyɛ́rɛŋi tɔɔnŋke kà cyêe u na. ");
INSERT INTO spp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ka u u pi pyi: «Jofoo nàɲja ná u mɛgɛ ku ɲyɛ ŋge wyɛ́rɛŋi na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ka pi i u pyi: «Saanbwɔhe Sezari.» Ka Yesu si pi pyi: «Ɲyɛ yii a Sezari wuŋi kaan Sezari á, yii raa Kile wuŋi kaan Kile á.» ");
INSERT INTO spp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pi à Yesu ɲwɔshwɔɔre lógo ke, ka li i pi kàkyanhala, ka pi i yîri u taan mà kàre. ");
INSERT INTO spp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kuru cannuge e, Sadusiibii pi maha jwo na kwuɲɛnɛ ɲyɛ nùmpanŋa mɛ, pire pìl'à file Yesu na maa jwo: ");
INSERT INTO spp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Cyelentuŋi! Kile tùnntunŋiMusa à jwo “Nɔ̀ ká ceewe lèŋɛ maa ŋkwû mà ta u ɲyɛ a pyà si u na mɛ, u cɔɔnŋ'à yaa u ceeŋi lèŋɛ zànbangara na, u u pyìi si u na, u yyahafooŋi niŋkwuŋi mɛge na.” ");
INSERT INTO spp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ɲyɛ sìɲɛɛ baashuunni na mpyi naha wuu yyére. Pi puni niɲjyeŋ'à ceewe lèŋɛ maa ŋkwû, u ɲyɛ a pyà ta u na mɛ. Ŋgemu u à taha u na ke, ka uru si ceeŋi lèŋɛ. ");
INSERT INTO spp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ka uru mú si mpa ŋkwû, u ɲyɛ a pyà ta u na mɛ. Ka tanrewuŋi wuuni mú si mpyi amuni fo mà sà ŋkwɔ̀ pi baashuunniŋi na. ");
INSERT INTO spp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pire puni kàntugo, ka ceeŋi mú si mpa ŋkwû. ");
INSERT INTO spp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ɲyɛ ná pire nàmbaa baashuunniŋi puni s'à uru ceeŋi lèŋ'a círi, kwùubii ɲɛ̀ŋi ká bú nta sèe, pi aha bú ɲɛ̀ canŋke ŋkemu i ke, pi ŋgir'á ceeŋi sí n‑kan yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ka Yesu si pi pyi: «Yii à wurugo, lir'à ta yii ɲyɛ a Kile Jwumpe Semɛŋi yyahe cè, si nta ɲjyére Kile sífente na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yii li cè, Kile yyére, sùpyire ká ɲɛ̀ a fworo kwùŋi i, nɔ̀ sì ceewe lèŋɛ mɛ, ceewe mú sì n‑kan nɔ̀ á mɛ. Ti sí n‑pyi Kile mɛ̀lɛkɛɛbii fiige. ");
INSERT INTO spp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ɲje y'à sémɛ Kile Jwumpe Semɛŋi i kwuɲɛni kyaa na ke, yii ɲyɛ a yire kâla mà? Kile à jwo ");
INSERT INTO spp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Mii u ɲyɛ Ibirayima ná Ishaka ná Yakuba u Kileŋi.” Ɲyɛ puru jwump'à li cyêe na pire mpii ɲyii wuu pi ɲyɛ wani Kile yyére. Sùpyire ɲyii woore ti maha Kile pêre, kwùubii kyaa bà mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sùpyire ti mpyi na núru Yesu ɲwɔ na ke, u kàlaŋ'à pire puni kàkyanhala. ");
INSERT INTO spp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ɲyɛ Farizhɛɛnbil'à pa lógo na Yesu à jwumpe cyán Sadusiibii na ke, ka pi i ŋkàr'a sà bínni Yesu taan. ");
INSERT INTO spp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kile Saliyaŋi cyelentuŋi wà na mpyi pi e, ka uru la si mpyi si Yesu pɛrɛ ɲcû maa u yíbe: ");
INSERT INTO spp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Cyelentuŋi! Saliyaŋi kabilini ndi l'à fànha tò cyi sanŋkii na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka Yesu si u pyi: «“Ma Kafooŋi Kile kyaa táan may'á ná ma zòmbilini ná ma múnaani ná ma sɔ̀nŋɔre puni i.” ");
INSERT INTO spp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Saliyaŋi kabilini niɲcyiini li ɲyɛ lire, lire l'à fànha tò cyi sanŋkii puni na. ");
INSERT INTO spp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Shɔnwuuni l'à taha lire na ke, lire tayyéreg'à pêe niɲcyiini fiige. Lire li ɲyɛ “ma supyiɲɛɛŋi kyaa táan may'á bà mu kyal'à táan may'á mɛ.” ");
INSERT INTO spp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kile Saliyaŋi kapyaagii sanŋkii puni ná Kile tùnntunmpii jwump'à lwɔ́ a pwɔ ɲcyii kapyaagii shuunniŋi na.» ");
INSERT INTO spp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mà Farizhɛɛnbii nimbinnibii yaha, Yesu à pi yíbe. ");
INSERT INTO spp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","U à jwo: «Kile Niɲcwɔnrɔŋi kyaa l'à jwo ke, ɲaha yii ɲyɛ na sɔ̂nŋi mà yyaha tíi ná u e yɛ? Jofoo tùluge e u sí n‑fworo yɛ?» Ka pi i Yesu pyi: «Dawuda Tuluge Shin wi.» ");
INSERT INTO spp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka Yesu si pi pyi: «Mà Kile Munaani yaha l'à Dawuda yyaha cû, ɲaha kurugo u à u yyere uru Kafooŋi yɛ? ");
INSERT INTO spp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yii li cè na Dawuda à jwo “Kafooŋi Kile à jwo mii Kafooŋi á ‘Ta ma a pa ntɛ̀ɛn na kàniŋɛ cyɛge na, fo mii aha mu zàmpɛɛnbii le mu tooyi ɲwɔh'i.’” ");
INSERT INTO spp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ná Dawuda na Kile Niɲcwɔnrɔŋi yiri “Kafooŋi” lir'à li cyêe na Dawuda Tuluge Shin kanna bà mɛ, u Kafoo mú wi, sèe bàl'à?» ");
INSERT INTO spp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pi wà ɲyɛ a jà a Yesu ɲwɔ shwɔ mɛ. Mà láha kuru canŋke na, wà saha ɲyɛ a ɲɛn'a u yíbe mɛ. ");
INSERT INTO spp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ɲyɛ supyiɲyahare ti mpyi a taha Yesu fye e ke, ka u u tire ná u cyelempyiibii pyi: ");
INSERT INTO spp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii ɲyɛ ndemu laage e ke, lire li ɲyɛ: na Musa Saliyaŋi yyaha yu sùpyir'á. ");
INSERT INTO spp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Karigii pi ɲyɛ na yu yii á ke, yii cyire le barag'e yii raa cyi kurigii ɲaare, ŋka nde pi yabilimpii ɲyɛ na mpyi ke, yii àha raa lire pyi mɛ. Ɲaha kurugo yɛ nde pi maha yu ke, lire bà pi maha mpyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pi maha Kile Saliyaŋi pyi tuguro sùpyire ɲuŋ'i, ti sì n‑jà ntemu lwɔ́ mɛ, pi yabilimpii sí ɲyɛ na ɲɛɛg'a sùpyire tɛ̀gɛ ti ɲjwòŋi na, ali nimbilere mɛ. ");
INSERT INTO spp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pi kapyiiŋkii puni ɲyɛ sùpyire ɲyiɲyaga karigii. Lire kurugo yaayi i pi maha Kile Jwumpe sémɛ maha le a pwɔ pi byahigii ná pi cyeyi na ke, pi maha yire pyi nitabaaya. Mà bâra lire na, pi maha pi vàanntinmbwoyi zhwɔ̀ɔnre tɔɔn. ");
INSERT INTO spp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wà ha pi yyere kataan ɲjyì na, lire ɲyɛ mɛ pi aha shà Kile Jwumpe kàlambayi i, bwompe tatɛɛnyi pi maha ɲcaa. ");
INSERT INTO spp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sùpyire tabinniyi i, pi la maha mpyi sùpyire s'a pire pêre s'a pi shɛ́ɛre, s'a pi yiri “Cyelentuŋi”. ");
INSERT INTO spp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ŋka yii pi ke, yii àha ɲɛɛ sùpya u a yii pyi “Cyelentuŋi” mɛ, ɲaha na yɛ yii mú puni na ɲyɛ cìnmpyii, Cyelentu niŋkin u ɲyɛ yii á. ");
INSERT INTO spp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yii àha raa sùpyaŋi wà tufiige yiri “Tufooŋi” ɲìŋke na mɛ, ɲaha na yɛ Tufoo niŋkin u ɲyɛ yii á, uru u ɲyɛ nìɲyiŋi na. ");
INSERT INTO spp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yii àha sùpyire yaha t'a yii pyi “Ɲùŋufooŋi” mɛ, ɲaha na yɛ Ɲùŋufoo niŋkin u ɲyɛ yii á, uru u ɲyɛ Kile Niɲcwɔnrɔŋi. ");
INSERT INTO spp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ŋgemu u ɲyɛ yii shwɔhɔl'e shinbwoŋi ke, urufoo u pyi yii sanmpii báarapyi. ");
INSERT INTO spp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Shin maha shin u à uye dùrugo ke, urufoo sí n‑tîrige, ŋka shin maha shin u à uye tîrige ke, urufoo sí n‑dùrugo. ");
INSERT INTO spp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yii Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii, yii pi à fyìnmɛ tò wwomɔ na ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii na Kile Saanre tajyiɲwɔge tùni, yii sì n‑jyè mɛ, mpii la ku ɲyɛ si jyè ke, maa pire tɛgɛlɛ kwɔ̀n.  ");
INSERT INTO spp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yii Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii, yii pi à fyìnmɛ tò wwomɔ na ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii maha leŋkwucyeebii cyeyaayi shuu pi na ná yii ɲwɔtanyi i. Yii maha Kile ɲáare na mɔni sùpyire ɲyiɲyage na. Lire kurugo nde li sí n‑pa yii ta ke, lire sí n‑waha sèl'e. ");
INSERT INTO spp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yii Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii, yii pi à fyìnmɛ tò wwomɔ na ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii maha ɲaare ɲìŋke ná lwɔhe cyeyi puni ɲuŋ'i, maa sùpyire caa na lèŋi yii Kile kuni i. Ŋka yii aha wà ta, nde li sí urufoo pyi u yaa ná nafugombaage ɲjyìŋi i fo tooyi shuunni mà tòro yii yabilimpii taan ke, lire kuni yii maha le urufoo taan. ");
INSERT INTO spp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii fyinmii wuubii pi à sùpyire yyaha cû, maa ŋko pi á na sùpya ká ŋkâa Kileɲaarebage na, kuru ŋgwùŋi ɲyɛ fànha urufoo na mɛ, ŋka wà ha ŋkâa Kileɲaarebage funŋke sɛɛnŋi na, kuru ŋgwùŋi na ɲyɛ fànha urufoo na. ");
INSERT INTO spp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yii na ɲyɛ funŋɔ baa shiin maa mpyi fyinmii, sɛɛnŋi u à fànha tò laa, Kileɲaarebage k'à sɛɛnŋi le ɲjire e ke, kuru k'à fànha tò? ");
INSERT INTO spp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yii à jwo mú na sùpya ká ŋkâa sárayi tawwuge na, na yafyin sì urufoo ta mɛ, ŋka sárage yaage k'à wwûl'a yaha sárayi tawwuge ɲuŋ'i ke, na sùpya ká ŋkâa kuru na, na urufol'à yaa u kuru kàage wwû. ");
INSERT INTO spp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Fyinmii pi pi! Sárage yaage k'à fànha tò laa, sárayi tawwuge ku maha sárage le ɲjire e ke, kuru ki? ");
INSERT INTO spp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Shinŋi u à kâa sárayi tawwuge na ke, urufoo mú à kâa ku ɲùŋɔ yaayi puni na. ");
INSERT INTO spp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Shinŋi u à kâa Kileɲaarebage na ke, urufol'à kâa Kileɲaarebage ná ku fooŋi Kile na. ");
INSERT INTO spp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Shinŋi u à kâa nìɲyiŋi na ke, urufol'à kâa Kile saanre yatɛɛnŋke ná ku tɛɛnfooŋi Kile na. ");
INSERT INTO spp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yii Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii, yii pi à fyìnmɛ tò wwomɔ na ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii maha yii nànayeŋi ná kaɲyɛyi yafwɔhɔfwɔhɔre sannte puni yáhaŋi wwû, mà li ta karigii cyi à fànha tò Saliyaŋi kapyaagii puni na ke, yii à cyire fɛ̂nn'a yaha ŋkere na. Cyire cyi ɲyɛ: ntìiŋi ná ɲùɲaare ná ɲwɔmɛɛfente. Cyire yii sí mpyi a yaa yii a mpyi, yii i cyi sanŋkii bâra cyire na. ");
INSERT INTO spp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Fyinmii pi pi! Yii à sùpyire yyaha cû mà li ta yii yabilimpii ɲyɛ na ɲaa mɛ. Yii maha yii lùbyage fyiinnɛ si sisɔnŋi wwû k'e, mà li ta yii na ɲwɔhɔyi jwoore k'e! ");
INSERT INTO spp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yii Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii, yii pi à fyìnmɛ tò wwomɔ na ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii maha yii yajigiyi kàntuyi jyíi na fíniŋi, mà li ta yi funɲy'à ɲî nàŋkaage ná sɔ̀nŋɔpeere na. ");
INSERT INTO spp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yii Farizhɛɛnbii, yii na ɲyɛ fyinmii! Yajigiyi funɲyi yii à yaa yii fyânha a jyé, lire ká mpyi, kàntugo yyéreŋi mú maha fíniŋɛ. ");
INSERT INTO spp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yii Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii, yii pi à fyìnmɛ tò wwomɔ na ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii na ɲyɛ mu à jwo fanɲjyeye, pi à ɲjemu fíniŋɛ ke, mu aha yi kàntuge wíi, mu a sì yi lemɛ ta p'à ɲwɔ, yi funŋke s'à ɲî kaciiyi ná kàkyayi na. ");
INSERT INTO spp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Amuni yii ɲyɛ, yii maha yiye pyi mu à jwo yii à tíi sùpyire sannte ɲyii na, mà li ta yii à fyìnmɛ tò wwomɔ na, yii funɲyi s'à ɲî pege na. ");
INSERT INTO spp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yii Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii, yii pi à fyìnmɛ tò wwomɔ na ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii maha Kile tùnntunmpii kwɔ̀nhigii yaa na faanre, sùpyire t'à tíi ke, maa kacɛnŋkuure yaa tire kwɔ̀nhigii na, ");
INSERT INTO spp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","maa ŋko “Kampyi wuu mpyi wuu tulyeyi tìiŋi i, wuu mpyi na sì ɲɛɛ n‑bâra pi na si Kile tùnntunmpii bò mɛ.” ");
INSERT INTO spp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lire pyiŋkanni na, yii yabilimpil'à li cyêe na mpii pi à Kile tùnntunmpii bò ke, yii mú à pi pire fiige. ");
INSERT INTO spp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ɲyɛ sòŋke yii tulyey'à lyêele ke, yii yyaha le yii i ku fàl'a nɔ ku tɛgɛni na! ");
INSERT INTO spp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wwòpiyi yà ye! Yii màcwɔn tùlugo sùpyiibii! Di yii sí n‑jà n‑shwɔ n‑jwo nùmpanŋa nage na yɛ? ");
INSERT INTO spp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lire e ke yii lógo, mii sí raa Kile tùnntunmpii pìi ná yákilifeebii pìi ná Kile Saliyaŋi cyelentiibii pìi tunni yii á. Yii sí n‑bò pi e, si pìi kwòro cige na, si pìi bwɔ̀n Kile Jwumpe kàlambayi i, si pìi kyérege kànyi yyaha kurugo. ");
INSERT INTO spp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lire e Kile sí n‑tîge yii na pire shintiibii puni mbòŋi i: Abɛli u à tíi ke, mà lwɔ́ uru tèeboni na, fo mà sà nɔ Baraki jyaŋi Zakari mbòŋi na, Zakari pi à bò Kileɲaarebage sèecyage ná sárayi tawwuge shwɔhɔl'e ke. ");
INSERT INTO spp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sèeŋi na mii sí yi jwo yii á, Kile sí yii ná yii tulyeyi cɛ̂ɛgɛ tire boore puni kurugo.» ");
INSERT INTO spp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ka Yesu si núr'a jwo: «Ei! Zheruzalɛmu shiinbii, yii Zheruzalɛmu kànhe shiinbii, yii pi maha Kile tùnntunmpii bùu, maa Kile jwumpe jwufeebii wàa ná kafaay'i maha bùu ke, y'à tooyo niɲyahaya kwɔ̀ mii la mpyi si yii bínni yiye e s'a yii kàanmucaa, bà ŋkùnuŋi maha u pyìre bínni tiye e, maa bûru ti ɲuŋ'i mɛ. Ŋka yii ɲyɛ a ɲɛɛ lire e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ku ke numɛ! Kile sí cye wwû yii kànhe taan si yii yaha yiye kanna na. ");
INSERT INTO spp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yii li cè, mà lwɔ́ numɛ na, yii ɲyiini saha sì n‑tɛ̀gɛ mii na mɛ, fo canŋke yii sí n‑pa raa ŋko “Ŋgemu u ɲyɛ na ma Kafooŋi Kile mɛge na ke, Kile u jwó le ur'á.”» ");
INSERT INTO spp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ɲyɛ mà Yesu yaha u u si raa fwore Kileɲaarebage e, ka u cyelempyiibii si file u na maa u pyi na u Kileɲaarebage ɲwɔŋkanni wíi. ");
INSERT INTO spp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ka u u pi pyi: «Ŋke basinaŋke yii ɲyɛ na ɲan'amɛ ke, sèeŋi na mii sí yi jwo yii á, canŋa na ma, ku puni sí n‑sìi n‑pwɔ̀n n‑cyán, si ku ŋkunuɲyi puni waraga, fo si ku kafaayi láha láha yiye na.» ");
INSERT INTO spp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɲyɛ ka Yesu sí n‑kàr'a sà ntɛ̀ɛn Olivye cire ɲaŋke ɲuŋ'i. Ka u cyelempyiibii kanni si file u na, maa u pyi: «Wuu cyelentuŋi, ɲaha tère e cyire karigii sí n‑pyi yɛ? Nde li sí mu tèenuruni ná diɲyɛŋi tèekwooni cyêe wuu na ke, lire jwo wuu á.» ");
INSERT INTO spp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ka Yesu si pi pyi: «Yii a yiye kàanmucaa! Yii àha sùpya yaha u yii wurugo mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yii li cè na shinɲyahara sí mii mɛge le piye na, si mpa jwo yii á na Kile Niɲcwɔnrɔŋi kyaa l'à jwo ke, na pire pi ɲyɛ ure. Pi sí raa shinɲyahara ɲwɔ fáanŋi s'a wuruge. ");
INSERT INTO spp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yii sí raa kàshiyi shɛnrɛ núru yiye táan, s'a yi shɛnrɛ núru laatɔɔnyi i, lire kà yii funŋɔ pɛn mɛ. Yii li cè na cyire karigii mpyimbaa ɲyɛ mɛ, ŋka lire bà li ɲyɛ diɲyɛŋi tèekwooni mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Supyishiŋi wà sí n‑pa n‑yîri n‑sà n‑cwo wà na, kìni là sí n‑pa n-yîri n‑sà n‑cwo là na. Katibwɔhe ná ɲìŋke ɲcyɛ̀ɛnnɛŋi sí n‑pyi cyeye niɲyahay'e. ");
INSERT INTO spp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɲcyii karigii puni na ɲyɛ kanhare tasiige, bà laani maha yîri maa nta a yaa ná li ziŋi i mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pi sí n‑pa raa yii leni cye e, pi raa yii kyérege, s'a yii bùu, yii kyaa sí n‑pɛn supyishiŋi pun'á mii mɛge kurugo. ");
INSERT INTO spp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lire sí shinɲyahara pyi ti fworo Kile kuni i, s'a tiye leni zàmpɛɛnbii cye e, si tiye kyaa pɛn tiy'á. ");
INSERT INTO spp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kafinivinibii pìi sí n‑pa piye pyi Kile tùnntunmii, si shinɲyahara wurugo. ");
INSERT INTO spp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pege mpèeŋi kurugo, tàange sí n‑pa n‑cyɛ́rɛ shinɲyahara á. ");
INSERT INTO spp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ŋka ŋgemu ká jà a uye waha maa ntɛ̀ɛn Kile kuni i fo mà sà nɔ tɛgɛni na ke, urufoo sí n‑shwɔ. ");
INSERT INTO spp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jwumpe Nintanmpe p'à yyaha tíi ná Kile Saanre e ke, puru sí n‑jwo diɲyɛŋi supyishiŋi pun'á, bà pi si mpyi si sèeŋi lógo mɛ. Lire kàntugo diɲyɛŋi tèekwooni sí n‑ta nɔ. ");
INSERT INTO spp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ɲyɛ yapege k'à sàa pɛn Kile á, ná Kile tùnntunŋi Daniyɛli à ku kyaa jwo ke, yii aha kuru ɲya Kileɲaarebage sèecyage e tèni ndemu i ke, ŋgemu ká mpe jwumpe lógo ke, urufoo u yyaha le u u pu ɲwɔhe cya a cè! ");
INSERT INTO spp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ɲyɛ lire tèni ká nɔ mà shin maha shin ta Zhude kùluni i ke, pirefee pi a fî pi a wá ɲaɲyi kàmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","L'aha ŋgemu ta u bage kàtanŋke ɲuŋ'i ke, urufoo kà núru ntîge si yaaga lwɔ́ bage e mɛ, u u ntíl'a tîge u a fî. ");
INSERT INTO spp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","L'aha ŋgemu ta kɛrɛge e ke, urufoo kà núru raa ma pyɛngɛ si mpa u vàanntinmbwɔhe lwɔ́ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Cyire canmpyaagii sí n‑waha lahigiifee ná pyìnɛɛbii na sèl'e. ");
INSERT INTO spp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yii a Kile ɲáare, bà yii canveŋke si mpyi k'àha mbɛ̂ ná wyeere tèni i, lire ɲyɛ mɛ ná canŋɔŋke e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yire canɲyi sí n‑waha sèl'e. Mà lwɔ́ diɲyɛ tasiige e, mà pa bwɔ̀n niɲjaa na, uru ŋgahaŋi fiige saha mpyi a ɲya mɛ, fo mà sà diɲyɛ kwɔ̀, uru ŋgahaŋi fiige sàha mú sì n‑pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kàmpyi Kafooŋi Kile mpyi a uru ŋgahaŋi tèni bere mɛ, sùpya mpyi na sì n‑shwɔ mɛ. Ŋka u à u tèni bere u niɲcwɔnribii kurugo, bà pire si mpyi si shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ɲyɛ shin ká jwo yii á na Kile Niɲcwɔnrɔŋi na wá naha, lire ɲyɛ mɛ u wá mɛŋi i, yii àha ndá urufoo na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ɲaha kurugo yɛ kafinivinibii pìi sí n‑yîri na pire pi ɲyɛ Kile Niɲcwɔnrɔŋi, pìi sí raa ŋko na pire na ɲyɛ Kile tùnntunmii. Pi sí raa kacyeeŋkii cyêre, s'a kakyanhala karigii pyi, bà pi si mpyi, kampyi pi sí n‑jà, s'a Kile niɲcwɔnribii mú bá wuruge mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yii lógo! Mii à ɲcyii karigii jwo yii á, mà jwo cyi tèni li nɔ ke.» ");
INSERT INTO spp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ka Yesu si núr'a jwo: «Ɲyɛ wà ha jwo yii á na Kile Niɲcwɔnrɔŋi na wá síwage e, yii àha ŋkàre wani mɛ. Wà ha yii pyi na u na wá bage k'e, yii àha ndá yire na mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bà sùpyire puni maha kileɲini ɲya l'à yîri diɲyɛŋi ɲùŋke kà na, maha sà fworo ɲùŋke sanŋke na mɛ, amuni Supyaŋi Jyaŋi sí ɲya u cannuruge. ");
INSERT INTO spp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Cyage e yakwugo ɲyɛ ke, wani cinmpunɲyi ɲyɛ na bínnini. ");
INSERT INTO spp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Cyire canmpyaagii yyefuge ká ntòro, “Canŋa ɲyiini sí n‑tíi n‑pyi numpire, yiŋke sàha mú sì raa bɛ̀ɛnmɛ yige mɛ. Wɔrigii sí raa n‑cwu, yire kakyanhala yaayi yi ɲyɛ nìɲyiŋi na ke, yire sí n‑cúnŋɔ n‑cúnŋɔ n‑yîri yi tatɛɛnyi i.” ");
INSERT INTO spp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ɲyɛ lire tèni i, Supyaŋi Jyaŋi fyèŋi sí n‑ta ɲya nìɲyiŋi na, ɲìŋke supyishiŋi puni sí raa mɛɛ súu, pi puni sí u nimpaŋi ɲya ɲahaɲyi i ná fànhe ná sìnampe nimbwompe e. ");
INSERT INTO spp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lire kàntugo mpurubwɔhɔ mɛɛ sí n‑fworo fànha na, u sí u mɛ̀lɛkɛɛbii tun diɲyɛŋi kàmpanɲyi sicyɛɛreŋi puni na, pi i Kile niɲcwɔnribii wà piye na, mà lwɔ́ diɲyɛŋi ɲùŋke kà na mà sà nɔ ku sanŋke na.» ");
INSERT INTO spp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ka Yesu si núr'a jwo: «Yii fizhiye cige kàanmucya a wíi kɛ! K'aha ŋkéɲyɛ nivɔnyɔ yige, maa fûn tèni ndemu i ke, yii maha jwo na nùŋgwɔh'à byanhara. ");
INSERT INTO spp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lire pyiŋkanni na, yii aha mpa cyire karigii puni ɲya cyi i mpyi, yii i ntɛ̀ɛn ná l'e na tèn'à byanhara, li bá a nɔ. ");
INSERT INTO spp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sèeŋi na mii sí yi jwo yii á, mpii pi à dá mii na ke, pire sí cyire karigii ɲya tapyige e. ");
INSERT INTO spp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nìɲyiŋi ná ɲìŋke sí n‑pa n‑tòro, ŋka mii jwumpe sí n‑kwôro fo tèekwombaa.» ");
INSERT INTO spp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","37","Ka Yesu si núr'a jwo: «Nde li ɲyɛ Supyaŋi Jyaŋi nùruŋi ke, shin niŋkin ɲyɛ a sìi ŋgemu u à u tèenuruni ná u cannuruge cè mɛ. Ali Kile mɛ̀lɛkɛɛbii ná Jyafooŋi ɲyɛ a kuru canŋke cè mɛ. Tufooŋi Kile kanni u à ku cè. Karigii cyi mpyi na mpyi Nuhu tìiŋi i ke, cyire shiŋi sí raa n‑pyi. ");
INSERT INTO spp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nuhu tìiŋi i, mà jwo lùbwooni li pa ke, sùpyire mpyi na lyî marii byii, cyeebii mpyi na ŋkaan nàmbaabil'á, nàmbaabii sí i cyeebii lèŋi fo mà sà nɔ canŋke Nuhu à jyè bakwɔɔge e ke, ");
INSERT INTO spp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","pi mpyi na sɔ̂nŋi yafyin na mɛ, ka lùbwooni si mpa pi puni shi bò. Ɲyɛ amuni Supyaŋi Jyaŋi tèenuruni mú sí n‑pa n‑pyi. ");
INSERT INTO spp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɲyɛ lire tèni ká shiin shuunni ta kɛrɛge e, wà sí n‑lwɔ́ si u sanŋi yaha. ");
INSERT INTO spp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","L'aha cyee shuunni ta pi i sùmaŋi tirili tirage na, wà sí n‑lwɔ́ si u sanŋi yaha. ");
INSERT INTO spp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lire e ke yii bégele tèrigii puni i, ɲaha na yɛ yii ɲyɛ a yii Kafooŋi cannuruge cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yii lógo! Kàmpyi bage foo mpyi maha nàŋkaaŋi tèepani cè numpilage e, u mpyi maha sì ɲɛɛ zínni ŋɔ́ɔ si u yaha u kakyaare pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lire kurugo yii mú à yaa yii bégel'a kwôro, ɲaha na yɛ canŋke ku ɲyɛ yii ɲyɛ a tɛ̀ɛn ná k'e mɛ, kur'e Supyaŋi Jyaŋi sí n‑pa. ");
INSERT INTO spp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ɲyɛ báarapyiŋi na ɲùŋufooŋ'à dá pi sanmpii shwɔhɔl'e, u yákiliŋi mú s'à pêe ke, uru báarapyiŋi shiŋi ɲùŋufooŋi maha yaha u u pyɛnge karigii cwɔɔnre, maa ɲjyìŋi kaan báarapyiibii sanmpil'á u tèekanl'e. ");
INSERT INTO spp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Lire e báarapyi maha báarapyi ɲùŋufoo, u à pa u ta u u báaraŋi niɲcɛnŋi pyi amuni ke, uru wuuni sí ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sèeŋi na mii sí yi jwo yii á, uru báarapyiŋi ɲùŋufooŋi sí u pyɛnge karigii puni ɲùŋufente le u cye e. ");
INSERT INTO spp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ŋka báarapyiibii kacwɔnrɔŋi ŋgemu ká mpyi shinpi maa sɔ̂nŋi uye funŋ'i na uru ɲùŋufooŋi sí mɔ lire kùluni i, ");
INSERT INTO spp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","maa wá na u báarapyiɲɛɛbii bwùun, maa uye yaha ɲjyìŋi ná sinmbyaani laage e ná sinmbyampiyi i ke, ");
INSERT INTO spp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","canŋke ku ɲyɛ uru báarapyiŋi ɲyɛ a tɛ̀ɛn ná k'e mɛ, ná tèni li ɲyɛ u ɲyɛ a sɔ̂nŋɔ ná l'e mɛ, u ɲùŋufooŋi sí n‑pâa n‑pa. ");
INSERT INTO spp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","U sí uru báarapyiŋi kyérege sèe sèl'e, mpii pi à fyìnmɛ tò wwomɔ na ke, si u ná pire sàraŋi pyi niŋkin. Wani u sí raa mɛɛ súu s'a ŋkyànhigii kùru.» ");
INSERT INTO spp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ka Yesu si núr'a jwo: «Kile Saanre ɲjyìŋi sí n‑fworo nde kani kurugo: pùceepyire kɛ ti ná fùkinabii lwɔ́ a kàre cipooŋi ɲùŋɔ tabeŋke e. ");
INSERT INTO spp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pi shiin kaŋkuro na mpyi funŋɔ baa, pi sanmpii kaŋkuruŋi sí mpyi yákilifee. ");
INSERT INTO spp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mpii pi mpyi funŋɔ baa ke, pir'à pi fùkinabii lwɔ́ a kàre, pi ɲyɛ a sìnmɛ lwɔ́ piye cye e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ŋka yákilifeebil'à pi fùkinabii lwɔ́ maa sìnmpe pà lwɔ́ piye cye e. ");
INSERT INTO spp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɲyɛ cipooŋ'à mɔ u ɲyɛ a pa mɛ, ka ŋɔɔmpe si pi puni jà, ka pi i ŋɔ́ɔ. ");
INSERT INTO spp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ɲyɛ ɲìŋk'à pa ɲî ke, ka mɛjwuu si fworo fànha na “Cipooŋi u ŋge! Yii fworo, yii i u ɲùŋɔ bɛ̂!” ");
INSERT INTO spp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ka tire pùceepyire kɛŋi si ɲɛ̀ ŋɔɔmpe na, maa pi fùkinabii bégele. ");
INSERT INTO spp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ka funŋɔ baa wuubii si wá na yákili wuubii pyi “Yii sìnmpe pà kan wuu á, ɲaha na yɛ wuu fùkinabii naha na sí raa fùre sìnŋkuuŋi na!” ");
INSERT INTO spp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ka pire si pi pyi “Ná sìnmpe e wuu naha a pa ke, puru naha na sì n‑jà wuu ná yii ta mɛ. Yii a sì sìnmpɛrɛbii yyére, yii i sà pà shwɔ.” ");
INSERT INTO spp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ɲyɛ mà pi yaha pi i ŋkɛ̀ɛge sìnmpe tashwɔge e, ka cipooŋi si mpa. Mpii pi mpyi a bégele ke, ka pire si jyè ná u e cikwɔɔnre bage e, ka pi i ku shwɔ̂hɔ. ");
INSERT INTO spp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɲyɛ tèr'à pyi ke, ka pùceepyire kaŋkuruŋi sanŋi mú si mpa maa jwo “Ɲùŋufooŋi, ɲùŋufooŋi! Ɲwɔge múgo wuu á.” ");
INSERT INTO spp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ka u u pi pyi “Sèeŋi na mii sí yi jwo yii á, mii ɲyɛ a yii cè mɛ.”» ");
INSERT INTO spp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ɲyɛ ka Yesu si u cyelempyiibii pyi: «Yii bégele tèrigii puni i, ɲaha na yɛ yii ɲyɛ a Kafooŋi cannuruge ná u tèepani cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ka Yesu si núr'a jwo: «Li sí n‑pyi mu à jwo nàŋi wà kùshe wu u à u báarapyiibii yyere, maa u nàfuuŋi le pi cye e. ");
INSERT INTO spp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","U à wyɛ́rɛfyinŋi tɔɔnyɔ ŋkwuu kaŋkuro (500) kan wà niŋkin á, maa ŋkwuu shuunni (200) kan wà á, maa ŋkuu (100) kan tanrewuŋ'á. U à wyɛ́rɛfyinŋi kan pi á mà tàanna ná pi shin maha shin pɛ̀rɛge e, pi raa tɔ̀ɔn caa u na, maa ŋkàre. ");
INSERT INTO spp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wyɛ́rɛfyinŋi ŋkwuu kaŋkuruŋ'à kan ŋgemu á ke, ka uru si ntíl'a kàr'a sà a cwɔ̀hɔnte pyi, maa ŋkwuu kaŋkuro tɔ̀ɔn ta mà bâra u wyɛ́rɛɲuŋke na. ");
INSERT INTO spp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ŋkwuu shuunniŋ'à kan ŋgemu á ke, ka uru mú si li pyi amuni, maa ŋkwuu shuunni tɔ̀ɔn ta mà bâra u wyɛ́rɛɲuŋke na. ");
INSERT INTO spp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ŋkuuŋ'à kan ŋgemu á ke, ka uru si ŋkàr'a sà wyii kwɔ̀n ɲìŋke na, maa u ɲùŋufooŋi wyɛ́rɛŋi le a ŋwɔhɔ. ");
INSERT INTO spp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tère nimbwol'à tòro ke, ka pire báarapyiibii ɲùŋufooŋi si núr'a pa, maa pi puni yíbe pi wyɛ́rɛfyinŋi báaraŋkanni na. ");
INSERT INTO spp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wyɛ́rɛfyinŋi ŋkwuu kaŋkuruŋi mpyi a kan ŋgemu á, ka u u ŋkwuu kaŋkuro tɔ̀ɔn ta mà bâra u na ke, ka uru si file maa jwo “Ɲùŋufooŋi, wyɛ́rɛfyinŋi tɔɔnyɔ ŋkwuu kaŋkuro mu mpyi a kan mii á, mii à u báara mà ŋkwuu kaŋkuruŋi wabɛrɛ ta. U we.” ");
INSERT INTO spp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ka ɲùŋufooŋi si jwo “L'à ɲwɔ, mu na ɲyɛ báarapyi niɲcɛnŋɛ maa mpyi dánasupya. Mu à pyi dánasupya kapyɛɛre e, lire e mii sí kabwɔhii le mu cye e. Ta ma, wuu u múguro siɲcyan.” ");
INSERT INTO spp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ɲyɛ wyɛ́rɛfyinŋi ŋkwuu shuunniŋi mpyi a kan ŋgemu á ke, ka uru si file maa jwo “Ɲùŋufooŋi, wyɛ́rɛfyinŋi tɔɔnyɔ ŋkwuu shuunni mu mpyi a kan mii á, mii à u báara mà ŋkwuu shuunniŋi wabɛrɛ ta. U we.” ");
INSERT INTO spp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ka ɲùŋufooŋi si u pyi “L'à ɲwɔ, mu na ɲyɛ báarapyi niɲcɛnŋɛ maa mpyi dánasupya. Mu à pyi dánasupya kapyɛɛre e, lire e mii sí kabwɔhii le mu cye e. Ta ma, wuu u múguro siɲcyan.” ");
INSERT INTO spp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ɲyɛ wyɛ́rɛfyinŋi ŋkuuŋi mpyi a kan ŋgemu á ke, ka uru si file maa jwo “Ɲùŋufooŋi, mii mpyi a li cè na mu kataanmp'à waha, mu ɲyɛ a kɛrɛge ŋkemu nûgo mɛ, mu maha kuru sùmaŋi kwɔ̀n, mu ɲyɛ a sùmashi wà cyage ŋkemu i mɛ, mu maha kuru sùmaŋi bégele. ");
INSERT INTO spp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Lire kurugo mii à fyá, maa sà wyige tùgo, maa mu wyɛ́rɛŋi le a ŋwɔhɔ ɲìŋke e. Mu wyɛ́rɛŋi u ŋge, u shwɔ.” ");
INSERT INTO spp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ka ɲùŋufooŋi si u pyi “Mu ɲyɛ báarapyi niɲcɛnŋɛ mɛ, kayamafoo u ɲyɛ mu. Taha mu mpyi a cè na mii ɲyɛ a kɛrɛge ŋkemu nûgo mɛ, na mii maha kuru sùmaŋi kwɔ̀n, na mii ɲyɛ a sùmashi wà cyage ŋkemu i mɛ, na mii maha kuru sùmaŋi bégele la? ");
INSERT INTO spp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ɲyɛ mu à yire puni cè, ɲaha na mu sí ɲyɛ a mpyi a jà a mii wyɛ́rɛŋi yaha wyɛ́rɛŋi bwùunni na mà yɛ? Kampyi mu mpyi a lire pyi, mii à núr'a pa ke, mii mpyi na sí u ná u tɔ̀ɔnŋi ta. ");
INSERT INTO spp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yii wyɛ́rɛfyinŋi ŋkuuŋi shwɔ u na, yii kan kampwooni (1.000) fol'á. ");
INSERT INTO spp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yii li cè, shin maha shin u ɲyɛ ná yaage e ke, kà sí n‑bâra urufoo woge na, ku u ɲyaha. Ŋka shin maha shin cyeŋgayi wu u ɲyɛ ke, yaaga sì n‑kan urufol'á mɛ. Nimbileni urufoo bá na sɔ̂nŋi uye cye e ke, lire sí n‑shwɔ u na. ");
INSERT INTO spp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yii ŋge báarapyiŋi laaga baa wuŋi wà cyíinŋi na numpini i, kuru cyage e sùpyire maha mɛɛ súu maa ŋkyànhigii kùru.”» ");
INSERT INTO spp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ka Yesu si núr'a jwo: «Supyaŋi Jyaŋi ká mpa ná u sìnampe ná u mɛ̀lɛkɛɛbii puni i tèni ndemu i ke, u sí n‑tɛ̀ɛn u fànhe tatɛɛnge nisinaŋke e. ");
INSERT INTO spp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Supyishiŋi puni sí n‑pa bínni u taan, u sí pi cwɔɔnrɔ si ŋgwû piye e, bà yatonahaŋi maha mpàabii cwɔɔnr'a wwû sikyaabil'e mɛ. ");
INSERT INTO spp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","U sí mpàabii yaha u kàniŋɛ cyɛge na, si sikyaabii yaha u kàmɛnɛ woge na. ");
INSERT INTO spp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ɲyɛ mpii pi ɲyɛ kàniŋɛ cyɛge na ke, saanŋi sí n‑jwo pir'á “Yii a ma naha, mii Tuŋi à jwó le yii á. Yii pa jyè u Saanre e, u à tire ntemu bégel'a yaha yii mɛɛ na fo diɲyɛŋi tèesiini i ke. ");
INSERT INTO spp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ɲaha kurugo yɛ tèni i katege mpyi mii na ke, yii à mii kan mii à lyî, byag'à mii ta ka yii i mii kan mii à bya. Mii mpyi nàmpɔnnte e, ka yii i mii sunmbage lèŋɛ. ");
INSERT INTO spp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Vàanŋkuuŋi mpyi mii na, ka yii i vàanya kan mii á. Mii mpyi na yà, ka yii i sà mii kàanmucya. Mii mpyi kàsuŋi i, ka yii i sà fworo mii na.” ");
INSERT INTO spp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ɲyɛ pire shintiibii sí n‑jwo “Kafooŋi, ɲaha tère e wuu à mu katege wuŋi ɲya, maa mu kan mu à lyî, lire ɲyɛ mɛ mà mu byaga wuŋi ɲya, maa mu kan mu à bya yɛ? ");
INSERT INTO spp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ɲaha tère e wuu à mu nàmpɔnŋɔ wuŋi ɲya, maa mu sunmbage tîrige, lire ɲyɛ mɛ mà mu ɲya vàanŋkuuŋi i, maa vàanya kan mu á yɛ? ");
INSERT INTO spp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ɲaha tère e wuu à mu yaŋgwuŋi, lire ɲyɛ mɛ mu kàsujye wuŋi ɲya, maa sà fworo mu na yɛ?” ");
INSERT INTO spp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Saanŋi sí pi pyi “Sèeŋi na mii sí yi jwo yii á, yii aha ɲcyii kacɛnŋkii pyi mii cìnmpyiibii puni nimbileni là na, yii li cè na mii na yii à cyi pyi.” ");
INSERT INTO spp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Lire kàntugo mpii pi ɲyɛ u kàmɛnɛ cyɛge na ke, u sí pire pyi “Yii à láŋa, yii laaga tɔɔn na na, yii raa sì nafugombaage e, kuru ŋkemu k'à bégel'a yaha Sitaanniŋi ná u mɛ̀lɛkɛɛbii mɛɛ na ke. ");
INSERT INTO spp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ɲaha kurugo yɛ katege mpyi mii na, yii ɲyɛ a mii kan mii a lyî mɛ, byage mpyi mii na, yii ɲyɛ a mii kan mii a bya mɛ. ");
INSERT INTO spp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mii mpyi nàmpɔnnte e, yii ɲyɛ a ɲɛn'a mii sunmbage lèŋɛ mɛ, vàanŋkuuŋi mpyi mii na, yii ɲyɛ a ɲɛn'a vàanya kan mii á mɛ. Tèni i mii mpyi na yà, ná tèni i mii mpyi kàsuŋi i ke, yii ɲyɛ a ɲɛn'a sà fworo mii na mɛ.” ");
INSERT INTO spp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ɲyɛ pire mú sí u yíbe “Kafooŋi, ɲaha tère e wuu à mu katege wuŋi ná mu byaga wuŋi ná mu nàmpɔnŋɔ wuŋi ná mu vàanŋkuu wuŋi ná mu yaŋgwuŋi ná kàsujye wuŋi ɲya, maa mpyi wuu ɲyɛ a mu tɛ̀gɛ mà yɛ?” ");
INSERT INTO spp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","U sí pi pyi “Sèeŋi na mii sí yi jwo yii á, ná yii ɲyɛ a cyire kacɛnŋkii pyi mii cìnmpyiibii puni nimbileni là na mɛ, yii mú ɲyɛ a cyi pyi mii na mɛ.” ");
INSERT INTO spp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ɲyɛ pire sí n‑pyi yyefuge niŋkwombaage e, ŋka mpii pi à tíi ke, pire sí n‑pyi shìŋi niŋkwombaaŋi i.» ");
INSERT INTO spp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ɲyɛ Yesu à kwɔ̀ puru jwumpe puni na, maa jwo u cyelempyiibil'á: ");
INSERT INTO spp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Yii à li cè na cyi sanŋkii ɲyɛ canmpyaa shuunni bilereŋkwoŋi kataanni sí nɔ, pi sí Supyaŋi Jyaŋi le cye e, si u kwòro cige na si mbò.» ");
INSERT INTO spp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ɲyɛ ka Kile sáragawwuubii ɲùŋufeebii ná Yahutuubii kacwɔnribii si sà piye bínni Kile sáragawwuubii ɲùŋufembwɔhe Kayifu pyɛnge e, ");
INSERT INTO spp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","maa bɛ̂ li na si Yesu cya ɲcû ná cwɔ̀ɔre e, si u bò. ");
INSERT INTO spp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pi mpyi na yi yu piy'á: «Li ɲyɛ a yaa li pyi kataanni tooy'e mɛ, lire baare e sùpyire sí n‑cânra.» ");
INSERT INTO spp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu na mpyi Bɛtani kànhe e tògofooŋi Simɔ bage e. ");
INSERT INTO spp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mà pi yaha talyige e, ceeŋi wà à file u na ná loŋgaracwol'e, li mpyi a ɲî sìnmpe nùguntanga wumpe loŋgara wumpe pà na, maa puru sìnmpe wu Yesu ɲùŋke na. ");
INSERT INTO spp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ɲyɛ u cyelempyiibil'à lire ɲya ke, ka li i mpɛn pi e fo pi na ŋko: «Ŋge ŋkɛ̀ɛgɛŋi ɲùŋke ku ɲyɛ ɲaha yɛ? ");
INSERT INTO spp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mpe sìnmpe mpyi na sí n‑jà n‑pɛ́rɛ wyɛ́rɛɲyahaga na, si ntaha fòŋɔfeebii tɛ̀gɛ.» ");
INSERT INTO spp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ɲyɛ mpe pi mpyi na yu ke, ka Yesu si mpa puru cè, maa pi pyi: «Ɲaha na yii ɲyɛ na ŋge ceeŋi cɛ̂ɛge yɛ? Kacɛnnɛ u à pyi mii na. ");
INSERT INTO spp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Fòŋɔfeebii ɲyɛ naha ná yii e tèrigii puni i, ŋka mii wi ke, mii sì n‑pyi ná yii e tèrigii puni i mà dɛ! ");
INSERT INTO spp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","U à mpe sìnmpe wu mii na, si mii cyeere bégele ɲjaha fanŋke mɛɛ na. ");
INSERT INTO spp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sèeŋi na mii sí yi jwo yii á, Jwumpe Nintanmpe ká nɔ cyaga maha cyag'e ke, nde ŋge ceeŋ'à pyi niɲjaa ke, lire sí n‑jwo wani bà li si mpyi si ŋkwôro sùpyire funŋ'i mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɲyɛ wà na mpyi cyelempyiibii kɛ ná shuunniŋi i, pi mpyi maha uru pyi Zhudasi Isikariyoti, ka uru si ŋkàre Kile sáragawwuubii ɲùŋufeebii yyére, ");
INSERT INTO spp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","maa pi pyi: «Mii aha yii tɛ̀gɛ, ka yii i Yesu cû, ɲaha yii sí n‑kan mii á yɛ?» Ka pire si wyɛ́rɛfyinŋi beɲjaaga ná kɛ kan u á. ");
INSERT INTO spp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mà lwɔ́ lire tèni na, ka Zhudasi si wá na pyiŋkanna caa si Yesu le pi cye e. ");
INSERT INTO spp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ɲyɛ bwúuruŋi niɲjirigembaaŋi kataanni canɲcyiige, ka Yesu cyelempyiibii si mpa u pyi: «Taa mu la ɲyɛ wuu u sà bilereŋkwoŋi kataanni ɲjyìŋi karigii cwɔɔnrɔ ke?» ");
INSERT INTO spp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ka u u pi pyi: «Yii shà mucyinn'á kànhe funŋke e, na cyelentuŋ'à jwo na uru tèn'à byanhara, na uru la ɲyɛ si mpa kataanni ɲjyìŋi lyî ná u cyelempyiibil'e u yyére.» ");
INSERT INTO spp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ɲyɛ ka cyelempyiibii si li pyi bà Yesu mpyi a yi jwo mɛ, maa kataanni ɲjyìŋi karigii cwɔɔnrɔ wani. ");
INSERT INTO spp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɲyɛ yàkoŋk'à pa nɔ ke, ka Yesu si mpa ntɛ̀ɛn na lyî ná u cyelempyiibii kɛ ná shuunniŋi i. ");
INSERT INTO spp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mà pi yaha ɲjyìŋi na, ka u u pi pyi: «Sèeŋi na mii sí yi jwo yii á, shin niŋkin na naha yii shwɔhɔl'e, ŋge u sí n‑pa mii le cye e ke.» ");
INSERT INTO spp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ka puru jwumpe si cyelempyiibii yyahayi tanha sèl'e fo pi shin maha shin na u yíbili: «Mii la, Kafooŋi?» «Mii la, Kafooŋi?» ");
INSERT INTO spp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ka u u pi pyi: «Ŋgemu cyɛge ku naha ná mii woge e yalyire yaage e ke, urufoo kyaa li. ");
INSERT INTO spp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Supyaŋi Jyaŋi ŋkwùmbaa ɲyɛ mɛ, bà l'à sémɛ u kyaa na Kile Jwumpe Semɛŋi i mɛ. Ŋka ŋgemu u sí n‑pa u le cye e ke, urufoo wuun'à kɛ̀ɛge! Urufoo zimbaaŋi mpyi na sí n‑pwɔ́rɔ u ziŋi na.» ");
INSERT INTO spp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zhudasi u mpyi na sí n‑pa u le cye e ke, ka uru si u yíbe: «Cyelentuŋi, mii wi la?» Ka Yesu si u pyi: «Mu yabiliŋi u à yi jwo!» ");
INSERT INTO spp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mà pi yaha pi i lyî, Yesu à bwúuruŋi lwɔ́, maa fwù kan Kile á u kyaa na, maa u kwɔ̀n kwɔ̀n a kan u cyelempyiibil'á maa jwo: «Yii ŋge shwɔ a lyî, mii cyeere ti.» ");
INSERT INTO spp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Lire kàntugo maa fùnɲcwokwuuni lwɔ́, ɛrɛzɛn sinmɛ mpyi l'e, maa fwù kan Kile á pu kyaa na, maa pu kan pi á maa jwo: «Yii puni pi pà bya. ");
INSERT INTO spp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ɲaha na yɛ puru pu ɲyɛ mii sìshange, tunmbyaare nivɔnnte Kile à le ke, tire sìshange ki, k'à wu shinɲyahara kapegigii yàfaŋi kurugo. ");
INSERT INTO spp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mii sí yi jwo yii á, mii saha sì ɛrɛzɛn sinmɛ bya mɛ, fo canŋke mii sí núru pu bya ná yii e mii Tuŋi Saanre e ke.» ");
INSERT INTO spp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɲyɛ ka pi i Kile pèente myahigii cêe maa nta a fworo bage e, maa ŋkàre Olivye cire ɲaŋke ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pi à nɔ wani ke, ka Yesu si pi pyi: «Niɲjaa numpilage yabiliŋi i, yii puni sí n‑fê si mii kanni yaha, ɲaha na yɛ y'à sémɛ Kile Jwumpe Semɛŋi i: “Mii sí mpànahaŋi bò, mpàkuruŋke puni sí n‑caala.”» ");
INSERT INTO spp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka Yesu si núr'a pi pyi: «Ŋka mii aha ɲɛ̀ a fworo kwùŋi i tèni ndemu i ke, mii sí n‑sà yii sige Galile kùluni i.» ");
INSERT INTO spp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ka Pyɛri si u pyi: «Pi sanmpii puni mɛ́ɛ ká fê, maa mu yaha, mii kyaa bà mɛ!» ");
INSERT INTO spp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ka Yesu si u pyi: «Sèeŋi na mii sí yi jwo mu á, niɲjaa numpilage yabiliŋi i, ŋkùpecyiini sí mu ta mu à jwo a nɔ tooyo taanre na mu ɲyɛ a mii cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ka Pyɛri si jwo: «Pi mɛ́ɛ ká mpyi na sí mii bò ná mu i, mii sì n‑sìi n‑jwo na mii ɲyɛ a mu cè mɛ.» Ka cyelempyiibii sanmpii puni si yire ninuyi taha. ");
INSERT INTO spp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ɲyɛ ka Yesu ná u cyelempyiibii si ŋkàr'a sà nɔ cyage k'e, kuru mɛge na ɲyɛ Zhetisemani, ka u u pi pyi: «Yii tɛ̀ɛn naha mà jwo mii u sà Kile ɲáare mɛyyere ke.» ");
INSERT INTO spp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ka u niŋkareŋi si ŋkàre ná Pyɛri ná Zebede jyaabii shuunniŋi i. Ka yyetanhare ná funmpɛɛnre si sìi u á. ");
INSERT INTO spp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ka u u pi pyi: «Mii funŋke naha a pɛn fo na ŋko si mii bò. Yii tɛ̀ɛn naha, yii i ŋkwôro ɲyii na ná mii i.» ");
INSERT INTO spp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ka u u ŋkàre yyaha yyére, maa uye wà ɲìŋke na, maa yyaha cyígile, maa Kile ɲáare na: «Tufooŋi, kampyi mu sí ɲɛɛ, na shwɔ ŋke kyaage lwɔhe mbyaŋi na. Ŋka ma hà na ɲyii wuuni pyi mɛ, ma ɲyii wuuni pyi.» ");
INSERT INTO spp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Lire kàntugo maa núr'a pa u cyelempyiibii yyére, mà sà pi ta pi i ŋwúuni. Ka u u Pyɛri ɲɛ̀, maa u pyi: «Yii ɲyɛ a jà a nde tèni niŋkinŋi pyi ɲyii na ná mii i mà? ");
INSERT INTO spp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yii tɛ̀ɛn ɲyii na, yii raa Kile ɲáare, bà yii si mpyi si fànha ta Sitaanniŋi na, u àha ŋkwɔ̀ yii sɔ̀n ŋgà kapii na mɛ. Nàkaana baa, sùpyaŋ'à bégel'a yaha kacɛnŋkii mɛɛ na, ŋka u fành'à cyɛ́rɛ.» ");
INSERT INTO spp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Lire kàntugo ka u u núr'a yîri pi taan tozhɔnwogo mà sà Kile ɲáare na: «Mii Tuŋi, kampyi mii sì n‑jà n‑shwɔ ŋke kyaage na mɛ, mu ɲyii wuuni li pyi.» ");
INSERT INTO spp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ka u u núr'a pa u cyelempyiibii yyére mà pa pi ta pi à ŋɔ́ɔ, pi mpyi na sì n‑jà ɲyiigii múgo n‑yaha mɛ. ");
INSERT INTO spp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka Yesu si núr'a yîri pi taan mà kàre Kile taɲarege e tontanrewogo, maa núru jwumpe ninumpe kurugo. ");
INSERT INTO spp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","U à kwɔ̀ ke, maa núr'a pa u cyelempyiibii cyage e maa pi pyi: «Yii saha na ŋwúuni la? Yii yîri, tèn'à nɔ, Supyaŋi Jyaŋi sí n‑le kapimpyiibii cye e. ");
INSERT INTO spp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yii yîri, wuu a sì, ŋge u sí mii le cye e ke, uru naha a nɔ naha.» ");
INSERT INTO spp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ɲyɛ mà Yesu yaha puru jwumpe na, ka Zhudasi si nɔ wani, uru na ɲyɛ cyelempyiibii kɛ ná shuunniŋi wà. U mpyi a pa ná shinɲyahar'e, kàshikwɔnŋwɔɔyi ná kàbiiyi mpyi pire cye e. Kile sáragawwuubii ɲùŋufeebii ná Yahutuubii kacwɔnribii pi mpyi a pi tun. ");
INSERT INTO spp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zhudasi u mpyi na sí Yesu le cye e ke, uru mpyi a jwo a kan u cùveebil'á na: «Yii aha mii ɲya mii à sùpyaŋi ŋgemu pûr'a cû maa u shɛ́ɛre ke, uru wi. Yii i u cû.» ");
INSERT INTO spp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pi à nɔ ke, ka Zhudasi si file Yesu na, maa jwo: «Fwù pìlaga na, wuu cyelentuŋi» maa u pûr'a cû. ");
INSERT INTO spp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ka Yesu si u pyi: «Na cevoo, ndemu tapyige e mu à pa ke, lire pyi.» Ɲyɛ ka sùpyire sannte si file maa Yesu cû. ");
INSERT INTO spp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ka Yesu cyelempyaŋi wà si u kàshikwɔnŋwɔɔge dìr'a wwû mà taha a sáragawwuubii ɲùŋufembwɔhe báarapyiŋi niŋgeŋke kà kwɔ̀n a cyán. ");
INSERT INTO spp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ka Yesu si cyelempyaŋi pyi: «Ma ŋwɔɔni le li fwuuni i, ɲaha na yɛ ŋgemu u ɲyɛ na kàshige kwùun ná ŋwɔɔni i ke, ŋwɔɔni li sí n‑tɛ̀gɛ urufoo bò mú. ");
INSERT INTO spp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Taha mu na sɔ̂nŋi na mii sì n‑jà na Tuŋi pyi u mɛ̀lɛkɛɛ kàshicyeye kɛ ná shuunni tùugo naha mii á numɛ, pi i nte sùpyire tun mɛ? ");
INSERT INTO spp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ŋka lire ká mpyi, ɲje y'à jwo Kile Jwumpe Semɛŋi i ke, di yire sí n‑fûnŋɔ n‑jwo yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ka Yesu si jwo sùpyir'á: «Yii à pa mii fye e ná kàshikwɔnŋwɔɔyi ná kàbiiyi i mpa ɲcû, mu à jwo kakuumpyi u ɲyɛ mii. Mii mpyi maha sùpyire kâlali Kileɲaarebage e canŋa maha canŋa, yii sí ɲyɛ a mii cû mɛ. ");
INSERT INTO spp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ŋka nde mpyiŋi sí Kile tùnntunmpii jwumpe fûnŋɔ.» Ɲyɛ ka Yesu cyelempyiibii puni si fê, maa u yaha. ");
INSERT INTO spp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mpii pi à Yesu cû ke, ka pire si ŋkàre ná u e Kile sáragawwuubii ɲùŋufembwɔhe Kayifu yyére. Kile Saliyaŋi cyelentiibii ná Yahutuubii kacwɔnribii mpyi a bínni wani. ");
INSERT INTO spp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mà pi yaha pi i ŋkɛ̀ɛge ná Yesu i, Pyɛri à tɛ̀ɛn laage e, marii sì pi fye e fo mà sà jyè sáragawwuubii ɲùŋufembwɔhe pyɛnge e, maa sà ntɛ̀ɛn pyɛnge saɲcwɔnsigibii shwɔhɔl'e, si karigii sanŋkii toroŋkanni ɲya. ");
INSERT INTO spp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kile sáragawwuubii ɲùŋufeebii ná yukyaala kuruŋke shiinbii puni mpyi na pyiŋkanna caa si Yesu cɛ̂ɛgɛ ná kafinare e, si u ta mbò. ");
INSERT INTO spp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ali mà li ta shinɲyahara mpyi a yà jwo, ŋka pi ɲyɛ a ɲùŋɔ sèe wogo ta ŋkemu ku sí mpa ná l'e u bò mɛ. Ka shiin shuunni si ŋkwɔ̀ a pa jwo: ");
INSERT INTO spp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Ŋge nàŋ'à jwo na uru sí n‑jà Kileɲaarebage jya, si núru ku faanra canmpyaa taanre funŋ'i.» ");
INSERT INTO spp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ka sáragawwuubii ɲùŋufembwɔhe si yîri maa Yesu pyi: «Mpe jwumpe puni p'à jwo mà yyaha tíi ná mu i ke, ɲaha mu u à cè p'e yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka Yesu si fyâha. Ka sáragawwuubii ɲùŋufembwɔhe si u pyi: «Kile ɲyii wuŋi mɛge na, kâa wuu á, maa yi jwo wuu á kampyi mu u ɲyɛ Kile Niɲcwɔnrɔŋi, maa mpyi Kile Jyaŋi?» ");
INSERT INTO spp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ka Yesu si u pyi: «Ɲje mu à jwo ke, yire yi. Ŋka mii sí yi jwo yii á, mà lwɔ́ numɛ na, yii sí Supyaŋi Jyaŋi nintɛɛnŋi ɲya Kile Siŋi Punifoo kàniŋɛ cyɛge na. Yii mú sí u nimpaŋi ɲya ɲahaɲyi i mà yîri nìɲyiŋi na.» ");
INSERT INTO spp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesu à puru jwo ke, ka sáragawwuubii ɲùŋufembwɔhe lùyiri wuŋi si u yabiliŋi vàanntinŋke cwɔn, maa jwo: «U à Kile mɛge kɛ̀ɛge, wuu saha ɲyɛ a tîge wà ɲwɔjwumɔ kurugo mɛ. Yii à u Kile mɛkɛɛgɛ jwumpe lógo. ");
INSERT INTO spp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɲaha yii ɲyɛ na sɔ̂nŋi yɛ?» Ka pi i u pyi: «U à yaa u bò.» ");
INSERT INTO spp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Lire kàntugo ka pi i ntilwɔhe wà u yyahe e, maa kaŋkuruyo cyán u e, ka pìi si kantawahii bwɔ̀n u e, ");
INSERT INTO spp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","maa jwo: «Kile Niɲcwɔnrɔŋi, mu ɲyɛ a jwo na mu na ɲyɛ Kile tùnntunŋi mà? Ŋge u à mu bwɔ̀n ke, uru mɛge yyere wuu á!» ");
INSERT INTO spp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pyɛri nintɛɛnŋi mpyi pyɛnge e ntàani na, ka báarapyicwoŋi wà si file u na maa jwo: «Mu mú mpyi ná Galile kùluni shinŋi Yesu e!» ");
INSERT INTO spp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ka Pyɛri si yi kyáala sùpyire puni ɲyii na, na: «Mii nàha à mu jwumpe yyaha cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lire kàntugo ka Pyɛri si yîr'a kàre pyɛnge tajyiɲwɔge yyére. Ka báarapyicwoŋi wabɛrɛ si u ɲya, mpii pi mpyi wani ke, maa jwo pir'á: «Ŋge nàŋi mpyi ná Nazarɛti kànhe shinŋi Yesu e.» ");
INSERT INTO spp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ka Pyɛri si núr'a yi kyáala na: «Mii à kâa na mii ɲyɛ a ŋge nàŋi cè mɛ!» ");
INSERT INTO spp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tère nimbiler'à tòro ke, mpii pi mpyi wani ke, ka pire si file Pyɛri na, maa jwo: «Nàkaana baa, mu na ɲyɛ pi wà, mu ɲjini lwɔ́ŋkanni naha a li cyêe.» ");
INSERT INTO spp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ɲyɛ ka Pyɛri si jwo: «Kampyi mii à ŋge nàŋi cè, Kile kà na yaha mɛ!» Ka ŋkùpooŋi si ntíl'a mɛɛ sú. ");
INSERT INTO spp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ka Pyɛri funŋke si ɲcwo Yesu jwumpe niɲjwumpe na na: «Ŋkùpecyiini sí mu ta mu à jwo a nɔ tooyo taanre na mu ɲyɛ a mii cè mɛ.» Ɲyɛ ka Pyɛri si fworo pyɛnge e maa sà mɛɛ sú sèe sèl'e. ");
INSERT INTO spp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ɲyɛ̀sɔɔge na, Kile sáragawwuubii ɲùŋufeebii puni ná Yahutuubii kacwɔnribil'à sà piye ɲya, maa jwo a bɛ̂ Yesu mbòŋi na, ");
INSERT INTO spp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","maa u pwɔ maa ŋkàre ná u e fànhafooŋi Pilati yyére. ");
INSERT INTO spp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zhudasi u ɲyɛ Yesu lefooŋi pi cye e ke, u à pa li ɲya na pi à jwo na pi sí Yesu bò ke, ka li i mpɛn u e, ka u u wyɛ́rɛfyinŋi beɲjaaga ná kɛŋi núruŋɔ Kile sáragawwuubii ɲùŋufeebii ná Yahutuubii kacwɔnribii na, ");
INSERT INTO spp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","maa jwo: «Mii à kapii pyi, mii à sùpya kan kwùŋ'á, ŋgemu u ɲyɛ u ɲyɛ a kapii pyi mɛ.» Ka pi i u ɲwɔ shwɔ: «Wuu ɲaha ɲyɛ pur'e mɛ, mu wuyo yi ɲyɛ yire.» ");
INSERT INTO spp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ka Zhudasi si wyɛ́rɛfyinŋi wà Kileɲaarebage e, maa yîri pi taan mà sà uye pwɔ a bò. ");
INSERT INTO spp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ka Kile sáragawwuubii ɲùŋufeebii si uru wyɛ́rɛfyinŋi kuu maa jwo: «Mà tàanna ná wuu Saliyaŋi i, wuu ɲyɛ a yaa wuu u le Kileɲaarebage wyɛ́rɛŋi yaleŋke e mɛ, ɲaha na yɛ supyibowyɛrɛ wi.» ");
INSERT INTO spp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ka pi i jwo a bɛ̂ li na si sà coge faanrafooŋi wà kɛrɛge shwɔ ná uru wyɛ́rɛŋi i, si mpyi nàmpwuunbii fanɲya. ");
INSERT INTO spp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lire na, pi à kuru kɛrɛge mɛge le: «Sishange Kɛrɛge» mà pa nɔ ná niɲjal'e. ");
INSERT INTO spp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lire pyiŋkanni na, jwumpe Kile tùnntunŋi Zheremi mpyi a jwo ke, pur'à fûnŋɔ. U mpyi a jwo: «Pi à wyɛ́rɛfyinŋi tɔnmpyara beɲjaaga ná kɛ lwɔ́. Izirayɛli shiinbil'à uru tɔ̀rɔ mà yaha supyibowyɛrɛ, ");
INSERT INTO spp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","maa sà coge faanrafooŋi kɛrɛge shwɔ ná ur'e, bà Kafooŋi Kile à yi jwo mii á mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ka pi i Yesu yyéeŋɛ fànhafooŋi Pilati yyaha na, ka u u u yíbe na: «Yahutuubii saanŋi u ɲyɛ mu la?» Ka Yesu si jwo: «Mu aha jwo amuni yo.» ");
INSERT INTO spp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ka Kile sáragawwuubii ɲùŋufeebii ná Yahutuubii kacwɔnribii si ntîge Yesu na karii niɲyahagil'e, ŋka u ɲyɛ a yafyin jwo mɛ. ");
INSERT INTO spp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ka Pilati si jwo: «Ɲcyii karigii pi na yu na ntare mu na ke, mu ɲyɛ na cyi núru mà?» ");
INSERT INTO spp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesu ɲyɛ a sàa yafyin jwo u á mɛ, ka lire si fànhafooŋi kakyanhala sèl'e. ");
INSERT INTO spp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ɲyɛ li mpyi kalyee fànhafooŋ'á, bilereŋkwoŋi kataanni n'a mpyi a nɔ, sùpyire ká kàsujyiŋi ŋgemu ɲáare u á ke, u maha uru yaha u à fworo. ");
INSERT INTO spp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lire tèni i, wà mpyi kàsuŋi i, sùpyire puni mpyi a u cè. U mɛge mpyi Barabasi. ");
INSERT INTO spp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pilati mpyi a cè na yiɲcyɛge kurugo, Kile sáragawwuubii ɲùŋufeebil'à Yesu Kirisita le uru cye e. Lire e sùpyir'à bínni ke, ka Pilati si pi pyi: «Jofoo yii la ɲyɛ mii i yige yɛ? Barabasi laa, Yesu pi maha mpyi Kirisita ke?» ");
INSERT INTO spp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ɲyɛ mà Pilati yaha yukyaalabage e, ka u cwoŋi si tùnnturo yaha a shà u á, na ŋge nàŋi u ɲyɛ ɲcɛ̀ɛgɛ cyaga baa ke, na u àha ŋkwɔ̀ u ɲwɔge le u kyal'e mɛ, ɲaha na yɛ karii niɲyahagil'à uru kànha ŋɔɔge e pìlaga u kyaa na. ");
INSERT INTO spp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ɲyɛ ka Kile sáragawwuubii ɲùŋufeebii ná Yahutuubii kacwɔnribii si sùpyire fɔ̀ɔnŋ'a ta na ti Barabasi ɲáare, ti i Yesu yaha pi bò. ");
INSERT INTO spp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ka fànhafooŋi si núr'a pi yíbe: «Mpii shiinbii shuunniŋi i, jofoo yii la ɲyɛ mii i yige yɛ?» Ka pi i jwo: «Barabasi!» ");
INSERT INTO spp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ka Pilati si pi yíbe: «Yesu pi maha mpyi Kirisita ke, ɲaha mii sí n‑pyi uru na yɛ?» Ka pi puni si jwo: «U kwòro cige na!» ");
INSERT INTO spp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ka Pilati si núr'a pi yíbe: «Kapiini ndire u à pyi mà sà nɔ u bò yɛ?» Ka pi i wá na ŋkwúuli fànha na: «U kwòro kworokworocige na!» ");
INSERT INTO spp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilati à li ɲya na uru jwumpe fành'à cyɛ́rɛ, tùnmpe sí i ɲyahage na ma ke, ka u u lwɔhɔ lwɔ́ a u cyeyi jyé sùpyire ɲyii na, maa jwo: «Mii à na cyeyi jyé a yige ŋge nàŋi kani i. Yii á li ɲyɛ numɛ.» ");
INSERT INTO spp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ka sùpyire puni si u ɲwɔ shwɔ: «U kwùŋi nùmpanŋke tugure ti pyi wuu ná wuu pyìibii woro.» ");
INSERT INTO spp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Lire tèni i ka Pilati si Barabasi yige mà tàanna ná sùpyire ɲyii wuuni i, maa pi pyi pi à Yesu bwɔ̀n ná kàsɔrigil'e, maa u kan pi sà ŋkwòro kworokworocige na. ");
INSERT INTO spp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ɲyɛ ka Pilati sòrolashiibii pìi si ŋkàre ná Yesu i pi tatɛɛnge e, maa sòrolashiibii piibɛrii yyér'a pa u kwûulo, ");
INSERT INTO spp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","maa u vàanɲyi wwû u na, maa vàanntinmbwɔhɔ niɲyɛga le u na, ");
INSERT INTO spp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","maa ŋguro cîn mà pyi saanra ɲùntoŋɔ mà tò u na, maa kàbii le u kàniŋɛ cyɛge e, marii niŋkure sínni u taan, marii u fwɔ́hɔre marii ŋko: «Yahutuubii Saanŋi, wuu à mu shɛ́ɛre!» ");
INSERT INTO spp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Marii ntilwɔhe wàa u na, maa kàbiini shwɔ u na mà taha na u bwùun ɲùŋke e. ");
INSERT INTO spp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pi à u fwɔ́hɔr'a kwɔ̀ ke, maa vàanntinmbwɔhe niɲyɛge wwû u na, maa u yabiliŋi vàanɲyi le u na, maa ŋkàre ná u e si sà ŋkwòro kworokworocige na. ");
INSERT INTO spp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ɲyɛ mà sòrolashiibii yaha pi i ŋkɛ̀ɛge ná Yesu i taboŋke e, pi à círi ná Sirɛni kànhe shinŋi w'e, u mɛge mpyi Simɔ. Ɲyɛ ka pi i u kárama u à Yesu kworokworocige tugo. ");
INSERT INTO spp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɲyɛ pi à sà nɔ cyage k'e, pi maha kuru cyage mɛge pyi: «Ɲuŋkwɔɔge Cyage» ");
INSERT INTO spp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","maa yasorogo le sinm'e mà kan Yesu á, u bya bà u sɛɛge si mpyi si ɲíŋɛ mɛ. U à ku nɛ́ɛn'a wíi ke, u ɲyɛ a ɲɛn'a ku bya mɛ. ");
INSERT INTO spp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sòrolashiibil'à u kwòr'a kwɔ̀ ke, maa ŋkyaanlwooni tɛ̀g'a u vàanɲyi táa piye na, bà pi puni si mpyi si pi nàzhanŋi cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lire kàntugo maa ntɛ̀ɛn wani na u kàanmucaa. ");
INSERT INTO spp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɲyɛ ka wà si u mbòŋi ɲùŋke sém'a taha kworokworocige na u ɲùŋke nìɲyiŋi na. Y'à sémɛ: «ŊGE U ƝYƐ YESU, YAHUTUUBII SAANŊI.» ");
INSERT INTO spp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ɲyɛ pi mpyi a nàŋkaalii shuunni kwòro kworokworociye na Yesu taan. Wà mpyi u kàniŋke na, u sanŋi sí ɲyɛ u kàmɛni na. ");
INSERT INTO spp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sùpyire nintorore mpyi maha u fwɔ́hɔre, marii ɲùɲyi kwòre, ");
INSERT INTO spp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","marii ŋko: «Mu u mpyi maha jwo na mu sí Kileɲaarebage cyán si ku faanre canmpyaa taanre e ke, mu u ɲyɛ amɛ la? Mu yabiliŋi u maye shwɔ. Kampyi Kile Jyaŋi u ɲyɛ mu, tîge kworokworocige na may'á!» ");
INSERT INTO spp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ɲyɛ ka Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii ná Yahutuubii kacwɔnribii mú si wá na u fare marii ŋko: ");
INSERT INTO spp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«U à pìi shwɔ, maa mpyi u ɲyɛ a jà a uye shwɔ mɛ. Kampyi uru u ɲyɛ Izirayɛli saanŋi, u tîge cige na numɛ, lire ká mpyi, wuu sí n‑dá u na. ");
INSERT INTO spp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U à u cyɛge taha Kile na, maa jwo na uru ɲyɛ Kile Jyaŋi. Kampyi u kyal'à táan Kile á, Kile à yaa u u shwɔ numɛ.» ");
INSERT INTO spp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nàŋkaabii pi mpyi a kwòro u taan ke, ka pire mú si wá na u fare amuni. ");
INSERT INTO spp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ɲyɛ canŋke mpyi a nɔ ɲùŋɔ niŋi i, ka numpini si mpâl'a jyè kìni cyeyi puni i, mà tère pyi fo mà sà byanhara yàkoŋke na. ");
INSERT INTO spp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lire tèni i, ka Yesu si jwo fànha na: «Eli, Eli, lama sabakatani?» Lire ɲwɔhe ku ɲyɛ: «Mii Kileŋi, mii Kileŋi, ɲaha na mu à kàntugo wà mii á yɛ?» ");
INSERT INTO spp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mpii pi mpyi wani ke, ka pire pìi si yire lógo, maa jwo: «Yii lógo! U naha na Kile tùnntunŋi Eli yiri, na u pa uru tɛ̀gɛ.» ");
INSERT INTO spp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lire tèenuuni i, ka pi wà si fê a sà sìcogo fyinmɛ lùtanhage k'e, maa ku nɔ́rɔ kàbii na, mà yaha Yesu ɲwɔge taan, u u ku ta a shwɔɔnrɔ. ");
INSERT INTO spp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka pi sanmpii si jwo: «Wuu a u wíi kampyi Eli sí n‑pa u shwɔ.» ");
INSERT INTO spp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ka Yesu si núr'a jwo fànha na, maa u múnaani kan Kile á. ");
INSERT INTO spp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lire tèni i, ka Kileɲaarebage táataa vàanŋke si ntíl'a cwɔn niŋke e, mà lwɔ́ nìɲyiŋi na fo ɲwɔh'i. Ka ɲìŋke si ɲcyɛ̂ɛnnɛ, ka kafaabwoyi si jya. ");
INSERT INTO spp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ka fanɲyi si múgo. Kile wuubii pi mpyi a kwû ke, ka pire pìi niɲyahara si ɲɛ̀, ");
INSERT INTO spp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","maa fworo fanɲyi i. (Ɲyɛ Yesu à pa ɲɛ̀ ke, ka pi i jyè Zheruzalɛmu kànhe e mà piye cyêe shinɲyahara na.) ");
INSERT INTO spp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ɲyɛ Ɔrɔmu sòrolashiibii yyaha yyére shinŋi ná mpii pi mpyi na Yesu kàanmucaa ná u e ke, tèni i pir'à ɲìŋke ɲya k'à cyɛ̂ɛnnɛ, karigii cyi à pyi ke, maa cyire ɲya ke, ka pi i fyá sèe sèl'e, maa jwo: «Nàkaana baa, ŋge nàŋi mpyi Kile Jyaŋi.» ");
INSERT INTO spp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cyee niɲyahamii mpyi a yyére tatɔɔnge e marii wíi. Pire cyeebii mpyi a taha Yesu fye e mà yîri Galile kùluni i, marii u tɛ̀re. ");
INSERT INTO spp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mariyama u mpyi na yîri Magidala kànhe e ke, ná Mariyama u ɲyɛ Yakuba ná Yusufu nuŋi ke, ná Zebede jyaabii nuŋi mpyi pi e. ");
INSERT INTO spp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yàkoŋk'à nɔ ke, ka nàfuufooŋi wà si mpa, u mɛge mpyi Yusufu, Arimati kànhe shin u mpyi u wi. U mú na mpyi Yesu cyelempya. ");
INSERT INTO spp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ka u u nɔ Pilati na, maa sà Yesu buwuŋi ɲáare u á. Ka Pilati si pi pyi pi u kan u á. ");
INSERT INTO spp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ka Yusufu si Yesu buwuŋi lwɔ́ a sà mpwɔ vàanntofɔnŋi w'e, ");
INSERT INTO spp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","maa u le fanŋke e, kuru mpyi a tùgo kafaaga ɲuŋ'i, u mpyi a ku kwɔ̀n a yaha uye mɛɛ na, bu mpyi na sàha ŋkwɔ̀ a tò k'e mà ɲya mɛ. Ka u u kafaabwɔhɔ kùuŋkul'a pa ntò fanŋke ɲwɔge na, maa ŋkàre. ");
INSERT INTO spp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ɲyɛ Magidala Mariyama ná Mariyamaŋi sanŋi mpyi a tɛ̀nn'a yyaha kan fanŋk'á. ");
INSERT INTO spp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kuru canŋa nùmpanŋa mpyi canŋɔŋke, ka Kile sáragawwuubii ɲùŋufeebii ná Farizhɛɛnbii si ŋkàre siɲcyan Pilati yyére ");
INSERT INTO spp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","maa jwo: «Ɲùŋufooŋi, l'à tîge wuu funŋ'i na ŋge kafiniviniŋi, mà u yaha ɲyii na, u mpyi maha jwo uru ká ŋkwû, canmpyaa taanre uru sí ɲɛ̀. ");
INSERT INTO spp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kuru cyage e, mu à yaa mu u pìi yaha pi a fanŋke kàanmucaa fo canɲyi taanreŋi ká mpa fûnŋɔ. Lire ká mpyi li ɲyɛ a pyi mɛ, u cyelempyiibii sí n‑jà n‑pa u buŋi yû, si jwo na u à ɲɛ̀ a fworo kwùŋi i. Tire kafinare kàntuge sí n‑waha si ntòro niɲcyiire na.» ");
INSERT INTO spp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ka Pilati si pi ɲwɔ shwɔ: «Kàanmucyafeebii na ɲyɛ wani, yii a sì, yii i sà pi pyi, pi a ku kàanmucaa pyiŋkanni l'à táan yii á ke.» ");
INSERT INTO spp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ka pi i ŋkàr'a sà fanŋke yal'a tò, maa fyè bwɔ̀n kafaage na, maa kàanmucyafeebii tìŋɛ wani. ");
INSERT INTO spp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɲyɛ canŋɔŋk'à tòro ke, cibilaage canɲcyiige ɲyɛ̀sɔɔge na, Magidala Mariyama ná Mariyamaŋi sanŋ'à pa mpa fanŋke wíi. ");
INSERT INTO spp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ka ɲìŋke si mpâl'a cyɛ̂ɛnnɛ sèe sèl'e. Kafooŋi Kile mɛ̀lɛkɛŋi wà mpyi a yîri nìɲyiŋi na, maa ntîg'a pa kafaabwɔhe kùuŋkul'a láha a yaha ŋkere na, maa ntɛ̀ɛn ku na. ");
INSERT INTO spp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U mpyi na ɲî kileɲini bɛ̀ɛnmpe fiige, u vàanɲyi mú s'à fíniŋɛ weewee. ");
INSERT INTO spp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ka saɲcwɔnsigibii si fyá na ɲcyɛ̂ɛnni, fo mà sà ɲcírige. ");
INSERT INTO spp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ka mɛ̀lɛkɛŋi si jwo cyeebil'á: «Yii àha raa fyáge mɛ. Yesu pi à kwòro cige na ke, mii à li cè na uru yii na ɲcaa. ");
INSERT INTO spp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","U ɲyɛ naha mɛ, u à ɲɛ̀ bà u mpyi a yi jwo mɛ! Yii u buwuŋi tasinnage wíi! ");
INSERT INTO spp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Numɛ, yii a sì fwɔfwɔ, yii i sà yi jwo u cyelempyiibil'á na “U à ɲɛ̀ a fworo kwùŋi i. U à kàr'a sà yii sige Galile kùluni i. Yii sí sà u ɲya wani.” Yire yi mpyi mii á, mii u jwo yii á.» ");
INSERT INTO spp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ka pi fyagara wuubii ná funntanga wuubii si fê a yîri fanŋke na, na fî na ŋkɛ̀ɛge fwɔfwɔ si sà yi jwo Yesu cyelempyiibil'á. ");
INSERT INTO spp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ka Yesu si mpâl'a pi ɲùŋɔ bɛ̂ mà pi yaha kuni na, maa pi shɛ́ɛre. Ka pi i file u na, maa niŋkure sín, maa u cû tooyi na, maa u pêe. ");
INSERT INTO spp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ka Yesu si jwo: «Yii àha raa fyáge mɛ. Yii a sì, yii sà mii cìnmpyiibii pyi na pi a sì Galile kùluni i. Wani pi sí sà mii ɲya.» ");
INSERT INTO spp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mà cyeebii yaha kuni na, sòrolashiibii pi mpyi na fanŋke kàanmucaa ke, ka pire pìi si jyè kànhe e, mà sà yi puni yyaha jwo Kile sáragawwuubii ɲùŋufeebil'á. ");
INSERT INTO spp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ka sáragawwuubii ɲùŋufeebii si wwɔ̀ ná Yahutuubii kacwɔnribil'e, maa jwo a bɛ̂ li na, maa wyɛ́rɛɲyahaga kan sòrolashiibil'á, ");
INSERT INTO spp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","maa jwo: «Yii a yi yu yii a ntùuli na u cyelempyiibil'à pa numpilage e, mà pa u buwuŋi yû, mà yii yaha ŋɔɔmpe na. ");
INSERT INTO spp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Fànhafooŋi ká yire lógo, wuu sí n‑jà yi cwɔɔnrɔ ná u e, bà yii si mpyi si shwɔ kyaage na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ka pi i wyɛ́rɛŋi lwɔ́, maa li pyi bà pi à yi jwo pi á mɛ. Ka puru jwumpe si ɲcaala Yahutuubii shwɔhɔl'e fo mà pa nɔ niɲjaa na. ");
INSERT INTO spp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ka cyelempyiibii kɛ ná niŋkinŋi si ŋkàre Galile kùluni i. Yesu mpyi a ɲàŋke ŋkemu kyaa jwo pi á ke, ka pi i sà dùgo kuru na, mà u ta wani. ");
INSERT INTO spp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pi à sà u ɲya ke, maa u pêe, ŋka pi pìi funyɔ mpyi na pi kyáali. ");
INSERT INTO spp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ka Yesu si file pi na, maa pi pyi: «Nìɲyiŋi ná ɲìŋke síŋi pun'à kan mii á. ");
INSERT INTO spp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lire e yii a sì yii sà supyishiŋi puni pyi mii cyelempyii, yii s'a pi batizeli Tufooŋi ná Jyafooŋi ná Kile Munaani mɛge na, ");
INSERT INTO spp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","yii raa pi taanni karigii puni mii à jwo a waha yii á ke, cyire na. Mii na ɲyɛ ná yii e canŋa maha canŋa fo si sà nɔ diɲyɛŋi tèekwooni na.» ");
INSERT INTO spp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jwumpe Nintanmpe pu ɲyɛ na Kile Jyaŋi Yesu Kirisita kyaa yu ke, puru ɲwɔkwɔɔnre ti ɲyɛ nte. ");
INSERT INTO spp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kile à fyânha a jwo u tùnntunŋi Ezayi sémɛŋi i: «Wíi, mii sí na tùnntunŋi tun mu yyaha na, u sà kuni yaa mu mɛɛ na, ");
INSERT INTO spp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","sùpya mɛjwuu sí n‑pa raa fwore síwage e fànha na “Yii kuni yaa Kafooŋi mɛɛ na, yii kumpyɛrɛ nintiire yaa u á.”» ");
INSERT INTO spp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Lire pyiŋkanni na, Yuhana Batizelipyiŋi à kàre síwage e mà sà uye cyêe, marii sùpyire batizeli, marii yi yu pi á na: «Yii yii toroŋkanni kɛ̂ɛnŋɛ, yii i batize, bà Kile si mpyi si yii kapegigii yàfa yii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zheruzalɛmu kànhe ná Zhude kùluni shiinbii niɲyahamii mpyi na sì u yyére, maa ntɛ̀n li taan na pire kapyiiŋkii ɲyɛ a tíi mɛ, Yuhana sí i pi batizeli Zhurudɛn baŋi lwɔhe e. ");
INSERT INTO spp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ɲyɛ Yuhana vàanntinŋke mpyi a yaa ná ɲwɔhɔŋi shire e, u mpyi maha uye pwu ná seepwɔge e, maa uye ɲwɔ caa ná kampɛɛnɲyi ná tuwyiyi sɛɛre e. ");
INSERT INTO spp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U mpyi na yi yu sùpyir'á: «Ŋge u na ma mii kàntugo ke, uru tayyéreg'à fànha tò mii woge na. Ali mà naye tîrige si nta mpyi u tanhaɲyi mɛɛre sànhafoo, mii ɲùŋk'à cyɛ́rɛ lire mpyiŋi i. ");
INSERT INTO spp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mii wi ke, mii à yii batize lwɔhe e, ŋka uru wi ke, uru sí yii batize ná Kile Munaani i.» ");
INSERT INTO spp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cyire canmpyaagil'e, Yesu à yîri Nazarɛti kànhe e Galile kùluni i mà kàre Yuhana yyére. Ka Yuhana si u batize Zhurudɛn baŋi lwɔhe e. ");
INSERT INTO spp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu nivworoŋi lwɔhe e, ka u u nìɲyiŋi ɲya u u múru, ka Kile Munaani si ntîg'a tɛ̀ɛn u na mpánmpɔrɔgɔ fiige. ");
INSERT INTO spp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka mɛjwuu si fworo nìɲyiŋi i na: «Mii Jyaŋi u ɲyɛ mu, mu kan'à waha mii na sèl'e. Mu kapyiiŋkil'à táan mii á mú.» ");
INSERT INTO spp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lire kàntugo ka Kile Munaani si ŋkàre ná Yesu e síwage e. ");
INSERT INTO spp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","U à canmpyaa beeshuunni pyi wani sige yaare shwɔhɔl'e. Cyire canmpyaagii funŋke e, ka Sitaanniŋi si file u na, maa ɲcaa si u sɔ̀n ŋgà kapii na. Kile mɛ̀lɛkɛɛbii mpyi ná u e, marii u tɛ̀re. ");
INSERT INTO spp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɲyɛ Yuhana Batizelipyiŋi leŋkwooni kàntugo na kàsuŋi i, ka Yesu si ŋkàre Galile kùluni i, marii Kile Jwumpe Nintanmpe yu, na ntùuli. ");
INSERT INTO spp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","U mpyi na yi yu sùpyir'á: «Tèn'à nɔ, Kile Saanre tèn'à byanhara. Yii yii toroŋkanni kɛ̂ɛnŋɛ, yii dá Jwumpe Nintanmpe na.» ");
INSERT INTO spp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Canŋka Yesu niɲaraŋi Galile baŋi ɲwɔge na, u à fyácyaa shuunni ɲya, Simɔ ná u sìɲɛɛŋi Andire, pi mpyi na cwòo wàa baŋi i. ");
INSERT INTO spp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ka u u yi jwo pi á: «Yii taha na fye e. Bà yii na fyaabii caa mɛ, mii sí yii taanna yii raa sùpyire caa t'a ma mii á.» ");
INSERT INTO spp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ka pi i ntíl'a pi cwòobii yaha, maa ntaha Yesu fye e. ");
INSERT INTO spp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɲyɛ pi à ta naha vili yyaha na sahaŋki ke, ka Yesu si núr'a sìɲɛɛ shuunni ɲya, pire pi mpyi Zebede jyaabii, Yakuba ná Yuhana. Pi ná pi tuŋi Zebede mpyi a tɛ̀ɛn pi bakwɔɔge funŋke e, na pi cwòobii takɛgɛyi yaa. ");
INSERT INTO spp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ka Yesu si ntíl'a pi yyere, ka pi i pi tuŋi Zebede ná u báarapyiibii yaha wani bakwɔɔge e, maa ntaha u fye e. ");
INSERT INTO spp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ka Yesu ná u cyelempyiibii si ŋkàre Kapɛrɛnamu kànhe e. Canŋɔŋke, ka u u jyè Kile Jwumpe kàlambage e, na sùpyire kâlali. ");
INSERT INTO spp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mpii pi mpyi wani na núru u ɲwɔ na ke, u kàlaŋi pyiŋkanni mpyi a pire kàkyanhala, ɲaha na yɛ u ɲyɛ a mpyi na pi kâlali Kile Saliyaŋi cyelentiibii fiige mɛ, ŋka ná Kile sífente e u mpyi na pi kâlali. ");
INSERT INTO spp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lire tèni i, jínacyanŋi wà mpyi wani Kile Jwumpe kàlambage e, ka uru si jwo fànha na: ");
INSERT INTO spp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Nazarɛti kànhe shinŋi Yesu, ɲaha shi ku ɲyɛ wuu ná mu shwɔhɔl'e yɛ? Mu à pa mpa wuu shi bò la? Mii à mu cè, ŋge u à fworo Kile e ke, uru u ɲyɛ mu!» ");
INSERT INTO spp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ka Yesu si fànha cyán jínaŋi na: «Ma ɲwɔge tò! Maa fworo ŋge nàŋi i!» ");
INSERT INTO spp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ka jínaŋi si nàŋi cúnŋɔ cúnŋɔ, maa ŋkwúulo fànha na, maa fworo u e. ");
INSERT INTO spp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ka lire si sùpyire puni kàkyanhala fo ti na yu tiy'á: «Ɲaha ku ŋkire yɛ? Kàlavɔnŋɔ ŋge nàŋ'à kan ná Kile fànhe e, u maha fànhe cyáan jínabii mú na pi i núru u ɲwɔ na!» ");
INSERT INTO spp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ka Yesu mɛge si fworo Galile kùluni puni i. ");
INSERT INTO spp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lire kàntugo ka Yesu ná u cyelempyiibii si fworo Kile Jwumpe kàlambage e, maa ŋkàre ná Yakuba ná Yuhana e, Simɔ ná Andire yyére. ");
INSERT INTO spp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pi à sà Simɔ nafeɲcwoŋi ta u à sínni cifwuro cye e, ka pi i u kyaa jwo Yesu á. ");
INSERT INTO spp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ka Yesu si file u na tasinnage e, maa u cû cyɛge na a yîrige. Ka cifwure si ŋkwɔ̀, ka u u yîri na sore pi á. ");
INSERT INTO spp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yàkoŋke, canŋa ɲyiin'à cwo ke, ka pi i ŋkàre ná yampii puni ná jínacyaanbil'e Yesu yyére. ");
INSERT INTO spp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kànhe shinɲyahara mpyi a bínni bage ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ka u u yampe shiŋi niɲyahamafee cùuŋɔ, maa jínacyaanbii niɲyahamii jínahii kɔ̀r'a yige pi e, maa jwumpe kwɔ̀n jínabii na, ɲaha na yɛ pi mpyi a u cè Kile wuŋi wà. ");
INSERT INTO spp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kuru canŋa nùmpanŋa ɲyɛ̀sɔɔge na, ka Yesu si yîr'a fworo, maa ŋkàre sige funŋke e si sà Kile ɲáare. ");
INSERT INTO spp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔ ná u shɛ̀rɛfeebil'à yîr'a fô u e ke, maa ŋkàr'a sà a u caa. ");
INSERT INTO spp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pi à u ɲya ke, maa u pyi: «Sùpyire puni wá na mu caa.» ");
INSERT INTO spp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ka Yesu si pi pyi: «Wuu a sì wuu taan kànyi na. Mii à yaa mii i Jwumpe Nintanmpe jwo wani mú, ɲaha na yɛ mii kapani li.» ");
INSERT INTO spp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lire e ka u u wá na ɲaare Galile kùluni puni i, maa Jwumpe Nintanmpe yu Kile Jwumpe kàlambayi i, maa jínabii kɔ̀re na yige pifeebil'e. ");
INSERT INTO spp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ka tògofooŋi wà si file Yesu na, maa niŋkure sín u fere e, maa u ɲáare fànha na, maa jwo: «Mu aha ɲɛɛ, mu sí n‑jà mii tòge láha mii na, si mii fíniŋɛ.» ");
INSERT INTO spp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nàŋi ɲùɲaar'à Yesu ta ke, ka u u u cyɛge sànha maa bwɔ̀n u na, maa jwo: «Mii à ɲɛɛ, tòge ku láha ma na!» ");
INSERT INTO spp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ka tòge si ntíl'a láha u na, ka u u ɲcùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ka Yesu si u cye yaha, maa li jwo a waha u á: ");
INSERT INTO spp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Cû ma ɲwɔge na, ma hà yaaga jwo sùpya á mɛ, ŋka ta sì, maa sà maye cyêe sáragawwuŋi na u u ma kàanmucya, sárage kyaa Kile tùnntunŋiMusa à jwo tògofeebii ɲcùuŋɔŋi kyaa na ke, maa kuru wwû. Lire li sí li cyêe na mu à cùuŋɔ.» ");
INSERT INTO spp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ŋka nàŋi ɲyɛ a jà a cû u ɲwɔge na mɛ. U à kàr'a sà a yi yu cyeyi puni i, ka li i mpyi Yesu saha sì n‑jà n‑tíi n‑jyè kànha na mɛ. U mpyi sige funŋke e, ŋka lire ná li wuuni mú i, sùpyire mpyi na yîri cyeyi puni i, na u taa wani. ");
INSERT INTO spp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Canmpyal'à tòro ke, ka Yesu si núr'a kàre Kapɛrɛnamu kànhe e. Ka sùpyire si lógo na u ɲyɛ wani bage k'e, ");
INSERT INTO spp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","maa mpa bínni mà bage ɲî. Tatɛɛngɛ sàha mpyi mɛ, bage ɲwɔge mpyi a ɲî. Ka Yesu si wá na Kile jwumpe yu pi á. ");
INSERT INTO spp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Lire na u ɲyɛ, ka pi i mpa ná yaŋi w'e, u mpyi a mûruŋɔ. Nàmbaa sicyɛɛre mpyi a u tugo. ");
INSERT INTO spp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ŋka sùpyire ɲyahaŋi kurugo, pi ɲyɛ a jà a nɔ ná u e Yesu na mɛ. Ka pi i dùgo bage kàtanŋke na, maa kuru fûru, maa yaŋi ná u yasinniŋke le a tîrige kuru wyige e Yesu fere e sùpyire shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu à li ɲya na mpii nàmpil'à dá uru na ke, ka u u jwo supyimuruŋk'á: «Na jya, mu kapegigil'à yàfa mu na.» ");
INSERT INTO spp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kile Saliyaŋi cyelentiibii pi mpyi a tɛ̀ɛn wani kuru cyage e ke, ka pire si wá na yu piye funŋ'i: ");
INSERT INTO spp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ɲaha na ŋge nàŋi ɲyɛ na mpe jwumpe shiŋi yu yɛ? U na Kile mɛge kɛ̀ɛge. Fo Kile kanni bà mɛ, wà sì n‑jà sùpya kapegii yàfa u na mɛ!» ");
INSERT INTO spp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ka Yesu si ntíl'a pi funŋɔ sɔ̀nŋɔre cè, maa yi jwo pi á: «Ɲaha na yii ɲyɛ ná nte sɔ̀nŋɔre shiŋi i yɛ? ");
INSERT INTO spp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mà jwo “Mu kapegigil'à yàfa mu na” ná “Yîri, ma a ma yasinniŋke lwɔ́ ma a ɲaare” yii ɲyii na cyire kapyaagii mú shuunni i ndire jwumɔ p'à táan yɛ? ");
INSERT INTO spp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ŋka yii pi li cè na li síŋi na ɲyɛ Supyaŋi Jyaŋi na, naha ɲìŋke na, u wà kapegii yàfa u na.» ");
INSERT INTO spp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Lire e u à jwo supyimuruŋk'á: «Ta núru na ɲwɔ na, yîri ma a ma yasinniŋke lwɔ́, ma a sì pyɛngɛ.» ");
INSERT INTO spp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ka nàŋi si ntíl'a yîri, maa u yasinniŋke lwɔ́ mà fworo sùpyire puni ɲyii na, ka li i pi puni kàkyanhala, ka pi i Kile pêe sèl'e, maa jwo: «Wuu sàha nde fiige ɲya mɛ!» ");
INSERT INTO spp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu à núr'a kàre Galile baŋi ɲwɔge na. Ka shinɲyahara si wá na ma u yyére, ka u u wá na pi kâlali. ");
INSERT INTO spp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","U nintoroŋ'à Alife jyaŋi Levi ɲya u à tɛ̀ɛn múnalwɔɔre tashwɔge e. Ka u u yi jwo u á: «Yîr'a taha na fye e». Ka Levi si yîr'a taha u fye e. ");
INSERT INTO spp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Canŋka Levi à Yesu ná u cyelempyiibii yyere pi sà lyî. Múnalwɔɔre shwofeebii ná mɛpɛngɛ shiinbii piibɛrii mpyi a ɲyaha Yesu fyèɲwɔhɔshiinbil'e, ka Levi si pi niɲyahamii yyere pi sà lyî mú. ");
INSERT INTO spp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kile Saliyaŋi cyelentiibii pi mpyi Farizhɛɛnbii toŋkuni i ke, pire pìl'à lire ɲya ke, maa Yesu cyelempyiibii pyi: «Ɲaha na yii cyelentuŋi na lyî ná múnalwɔɔre shwofeebii ná mɛpɛngɛ shiinbii piibɛril'e yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu à yire lógo ke, maa jwo: «Mpii pi à cùuŋɔ ke, wempyiŋi kyaa ɲyɛ pire na mɛ, mpii pi na yà ke, pire na u kani ɲyɛ. Mpii pi ɲyɛ na piye sɔ̂nŋi na pir'à tíi ke, mii ɲyɛ a pa ɲìŋke na pire tayyerege e mɛ. Ŋka mpii pi à li cè na pire ɲyɛ a tíi mɛ, pire tayyerege e mii à pa.» ");
INSERT INTO spp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ɲyɛ Yuhana Batizelipyiŋi cyelempyiibii ná Farizhɛɛnbii mpyi maha súnŋi leni, ka sùpyire tà si mpa Yesu pyi: «Ɲaha na Yuhana Batizelipyiŋi cyelempyiibii ná Farizhɛɛnbii wuubii maha súnŋi leni, mu cyelempyiibii sí ɲyɛ na u leni mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ka Yesu si pi pyi: «Cipooŋi ká mpyi ná cikwɔnbil'e, pi sí n‑jà n‑pyi lyìmbaa lire tèni i la? Mà pi ná uru yaha siɲcyan pi sì n‑sìi n‑jà n‑kwôro lyìmbaa mɛ. ");
INSERT INTO spp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ŋka tèni là na ma, cipooŋi sí n‑pa n-yige pi shwɔhɔl'e. Lire tèni i pi sí n‑ta raa súnŋi leni.» ");
INSERT INTO spp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ka Yesu si núr'a jwo: «Wà ɲyɛ na vàanvɔnŋɔ tɛ̀gɛ na vàanɲjyɛga tacwɔngɔ jwooli mɛ. Lire ká mpyi, vàanvɔnŋke maha vàanɲjyɛge kɛ̀ɛge, tacwɔng'a sì nâara a pêe. ");
INSERT INTO spp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wà mú sí ɲyɛ na sinmpurugo leni seeye boolyɛgil'e mɛ. Lire baare e p'aha mpa ntanha, pu maha pu yaleŋke jya, maa wu, yaleŋk'a sì ŋkɛ̀ɛge. Sinmpurug'à yaa k'a leni seeyi boofɔnŋkil'e!» ");
INSERT INTO spp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ɲyɛ canŋka Yesu ná u cyelempyiibii mpyi na ntùuli sùma kooyi y'e. Kuru canŋke na mpyi canŋɔŋɔ. Ka u cyelempyiibii si cye le sùmaŋi i na ŋkwùun na mínage na ŋkùru. ");
INSERT INTO spp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farizhɛɛnbii pìl'à lire ɲya ke, maa Yesu pyi: «Wíi, ɲaha na mu cyelempyiibii na canŋɔŋke kafuunŋkii pyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ka u u pi pyi: «Nde saanŋi Dawuda à pyi ke, yii ɲyɛ a lire kâla mà? Canŋka mà u ná u fyèɲwɔhɔshiinbii katege wuubii yaha, ");
INSERT INTO spp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","u à jyè Kile bage e, lire tèni i Abyatari u mpyi Kile sáragawwuubii ɲùŋufembwɔhe, maa sárage bwúuruŋi wà lwɔ́ a kyà, maa wà kan u fyèɲwɔhɔshiinbil'á. Mà li ta sáragawwuubii kanni pi mpyi a yaa pi jà a uru bwúuruŋi kyà.» ");
INSERT INTO spp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Lire kàntugo ka Yesu si yi jwo pi á: «Canŋɔŋk'à yaa sùpyire mɛɛ na, ku ɲyɛ a yaa ku pyi tuguro pi á mɛ. Sùpyire ɲyɛ a yaa canŋɔŋke mɛɛ na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lire l'à li ta Supyaŋi Jyaŋi ká kyaa maha kyaa jwo ali mà yyaha tíi ná canŋɔŋke e ke, li sì n‑jà n‑tòro lire na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Canŋka Yesu à núr'a jyè Kile Jwumpe kàlambage e, mà sà nàŋi wà ta wani ná cyeŋkwuge e. ");
INSERT INTO spp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka pi i wá na u kàanmucaa, kampyi u sí uru nàŋi cùuŋɔ canŋɔŋke e, si nta tìgire cyán u na. ");
INSERT INTO spp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ka u u jwo cyeŋkwugefooŋ'á na u yîr'a yyére sùpyire shwɔhɔl'e, pi raa u ɲaa, ");
INSERT INTO spp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","maa pi yíbe: «Mà tàanna ná Kile Saliyaŋi i, kacɛnni mpyiŋi u à ɲwɔ canŋɔŋke e laa, kapiini mpyiŋi? Mà sùpya múnaa shwɔ laa, mà sùpya múnaa wwû?» Ka pi puni si fyâha. ");
INSERT INTO spp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ka Yesu si ɲyiŋkeni le pi e, maa yyahe tanha pi na, u à li ta pi ɲyɛ a cyeŋkwugefoo ɲùɲaare ta mɛ. Maa jwo cyeŋkwugefol'á: «Ma cyɛge sànhana.» U à ku sànhana ke, ka ku u ɲcùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ɲyɛ Farizhɛɛnbii pi mpyi wani ke, ka pire si fworo Kile Jwumpe kàlambage e, maa ntíl'a kàr'a sà wwɔ̀ ná Erɔdi toŋkuni shiinbil'e Yesu boŋkanni kyaa na. ");
INSERT INTO spp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ka Yesu ná u cyelempyiibii si fwor'a kàre Galile baŋi kàmpanŋke na. Supyikuruŋɔ nimbwɔhɔ mpyi a taha u fye e. Tire sùpyire mpyi a yîri Galile kùluni ná Zhude wuuni ");
INSERT INTO spp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ná Zheruzalɛmu kànhe ná Iduma kùluni ná Zhurudɛn baŋi kàntugo yyére kùluni ná Tiri ná Sidɔn kànyi na. U kapyiiŋkii kyaa sùpyire mpyi na núru, maa ntaha u fye e. ");
INSERT INTO spp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","U mpyi na shinɲyahara cùuŋi, lire e yampii puni la mpyi si bwɔ̀n u na. Ka u u li ɲáare u cyelempyiibil'á na pi bakwɔɔge kà bégel'a yaha ur'á, uru ká bú ŋkwɔ̀ a jà laaga wwû sùpyire na, t'àha bú uru fɛnrɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jínacyaan n'a mpyi a u ɲya, pi mpyi maha ɲcwo u fere e, maa ŋkwúulo, maa jwo: «Kile Jyaŋi u ɲyɛ mu!» ");
INSERT INTO spp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ŋka Yesu mpyi maha yi jwo a waha pi á na pi àha sùpya yaha u yi cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lire kàntugo ka Yesu si dùgo ɲaŋke kà na. Mpii kyaa li ɲyɛ u na ke, maa pire yyer'a yige pi sanmpii shwɔhɔl'e, ka pire si n‑kàre u fye e. ");
INSERT INTO spp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Shiin kɛ ná shuunni u à cwɔɔnr'a pyi u tùnntunmpii pi i mpyi ná u e tèrigii puni i, u s'a pi tunni pi raa Kile jwumpe yu, ");
INSERT INTO spp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","maa fànhe kan pi á, pi jà pi a jínabii kɔ̀re pi a yige pifeebil'e. ");
INSERT INTO spp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Shiin kɛ ná shuunniŋi u à cwɔɔnrɔ ke, pire mɛyi yi ɲyɛ: Simɔ ná Yesu à u mɛge le Pyɛri ke, ");
INSERT INTO spp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ná Zebede jyaabii Yakuba ná Yuhana, Yesu mpyi maha pire yiri Bwonɛrizhe, lire ɲwɔhe ku ɲyɛ pi fành'à ɲyaha kiletinni fiige, ");
INSERT INTO spp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ná Andire ná Filipi ná Baritelemi ná Macwo ná Tomasi ná Alife jyaŋi Yakuba ná Taadi ná Simɔ, pi maha mpyi Zelɔti ke, ");
INSERT INTO spp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ná Zhudasi Isikariyoti, ŋge u sí n‑pa Yesu le cye e ke. ");
INSERT INTO spp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lire kàntugo Yesu ná u cyelempyiibil'à núr'a pa pyɛngɛ, ka shinɲyahara si núr'a pa pi ɲwɔ tò sahaŋki ná pi funmpɛn karigil'e, fo mà u ná u cyelempyiibii pyi pi ɲyɛ a talyige ta mɛ. ");
INSERT INTO spp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesu cìnmpyiibil'à u kapyiiŋkii kyaa lógo ke, maa wá na sɔ̂nŋi na u ɲùmbwuun'à kɛ̀ɛgɛ, maa shà zà u cû. ");
INSERT INTO spp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kile Saliyaŋi cyelentiibii pi à yîri Zheruzalɛmu kànhe e ke, ka pire si wá na ŋko na jínabii ɲùŋufooŋi Bɛlizebuli u ɲyɛ Yesu i, na ná uru fànhe e u na jínabii kɔ̀re na yige pifeebil'e. ");
INSERT INTO spp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ɲyɛ ka Yesu si pi yyere, maa bàtaaya jwo pi á. U à jwo: «Sitaanniŋi sí n‑jà uye kɔ̀rɔ la? ");
INSERT INTO spp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kìre maha kìre li ɲyɛ na liye tùnni ke, lire kìni fànhe maha ŋkwɔ̀. ");
INSERT INTO spp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pyɛngɛ maha pyɛngɛ shiin ká yîri piye kurugo ke, kuru pyɛnge fànhe maha ɲcyɛ́rɛ. ");
INSERT INTO spp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sitaanniŋi ká a u báarapyiibii kɔ̀re, u na uye tùnni. Lire ká mpyi, u fànhe sí n‑cyɛ́rɛ si mpa ŋkwɔ̀. ");
INSERT INTO spp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wà sì n‑jà n‑jyè fànhaɲyahagafoo bage e si u yaayi lwɔ́, ná u ɲyɛ a bage foo pwɔ a cyán maa nta a jyè mà yɛ. Urufoo ká jà a u pwɔ a cyán, lire e u maha jà a bage yaayi pyi u ɲɛɛmpe. ");
INSERT INTO spp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sèeŋi na mii sí yi jwo yii á, sùpyire kapegigii ná ti Kile mɛkɛɛgɛ karigii puni sí yàfa ti na, ");
INSERT INTO spp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ŋka ŋgemu ká Kile Munaani mɛge kɛ̀ɛge ke, lire sì n‑sìi yàfa urufoo na mɛ, urufoo sí lire kapiini tugure lwɔ́ fo tèekwombaa.» ");
INSERT INTO spp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu à yire jwo amuni, ɲaha na yɛ pi mpyi na ŋko na jínaŋi wà u ɲyɛ u e. ");
INSERT INTO spp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mà Yesu yaha kuru cyage e, u nuŋi ná u cìnmpyiibil'à pa yyére cyíinŋi na, maa wà tun u u yyere. ");
INSERT INTO spp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Shinɲyahara mpyi a tɛ̀nn'a u kwûulo, ka pi i mpa yi jwo u á: «Mu nuŋi ná mu cìnmpyiibii naha cyíinŋi na, pi naha na mu kyaa pyi.» ");
INSERT INTO spp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ka u u pi pyi: «Mpire pi ɲyɛ mii nuŋi ná mii cìnmpyiibii yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ka u u ɲyiigii yîrig'a le sùpyire e, maa jwo: «Mpii nintɛɛnbii pi ɲyɛ mii nuŋi ná mii cìnmpyiibii. ");
INSERT INTO spp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yii li cè, ŋge u ɲyɛ na Kile ɲyii wuuni pyi ke, uru u ɲyɛ mii cìnmpworoŋi ná mii nuŋi.» ");
INSERT INTO spp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Puru ɲwɔhɔ na, Yesu à kàre Galile baŋi ɲwɔge na, ka shinɲyahara si mpa bínni u taan, ka u u wá na ti kâlali sahaŋki. Sùpyir'à pa ɲyaha sèl'e ke, li ɲyɛ a pa ɲwɔ mɛ, ka u u jyè a tɛ̀ɛn bakwɔɔge k'e lwɔhe ɲuŋ'i. Ka ti i yyére kùmpoge na, ");
INSERT INTO spp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ka u u ti kâla karigii niɲyahagii na ná bàtaay'i. U à jwo: ");
INSERT INTO spp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Yii a núru, ɲɛɛnuguŋi wà u ná fwor'a kàre ɲɛɛmɛ tanuguge e. ");
INSERT INTO spp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mà u yaha u u sùmapyaŋi wàa fini fiige, sùmashiŋi wà à cwo kuni ɲwɔge na, ka saɲcyɛɛnre si mpa uru jò. ");
INSERT INTO spp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka wà tacwugo si mpa bɛ̂ ná kafaafoge e, pworo niɲyahara mpyi kuru cyage e mɛ. Ka uru si fyîn wahawaha, ɲaha na yɛ u mpyi a jyè ɲìŋke e sèl'e mɛ. ");
INSERT INTO spp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ɲyɛ canŋk'à pa fworo ke, ka yifyinre si fàan maa waha, ndìre kuuŋi na. ");
INSERT INTO spp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ka wà tacwugo si mpa bɛ̂ ŋgurotaha na, ka ŋgure si uru cû, u ɲyɛ a jà a yasɛɛre pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ŋka wà tacwug'à pa bɛ̂ ɲìŋke tacɛnŋke na, maa fyîn maa yîri fwɔfwɔ. Sùmacire tà à sùmapyaŋi se mà nɔ ŋkuu ŋkuu (100) na, tà mpyi beetaanre taanre (60) tà mpyi beɲjaaga ná kɛ kɛ. ");
INSERT INTO spp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ŋgemu la ká mpyi si karii yyaha cè ke, urufoo u u niŋgyigigii cyán sèl'e.» ");
INSERT INTO spp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu à puru jwumpe jwo a kwɔ̀ ke, ka u ná u cyelempyiibii kɛ ná shuunniŋi ná shiin niŋkin niŋkin si yîri sùpyire sannte taan. Ka pire si sà a u yíbili u bàtaayi ɲwɔhe na. ");
INSERT INTO spp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ka u u pi pyi: «Kani l'à yyaha tíi ná Kile Saanre e ná l'à ŋwɔhɔ ke, yii á lire ɲcèŋ'à kan. Ŋka mpe jwumpe puni ɲwɔh'à ŋwɔhɔ sùpyire sannte na. ");
INSERT INTO spp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Lire kurugo “pi na Kile kapyiiŋkii wíi maa ɲcyé cyi ɲyaga, pi na Kile jwumpe núru maa ɲcyé pu lógogo, ɲaha na yɛ nde pi la ɲyɛ si zìi vyìinnɛ ke, lire li ɲyɛ, mà núr'a sà piye kan Kile á, bà pi kapegigii si mpyi si yàfa pi na mɛ.”» ");
INSERT INTO spp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ka Yesu si yi jwo pi á sahaŋki: «Yii aha mpyi yii ɲyɛ a ŋke bàtaage yyahe cè mɛ, di yii sí yi sanɲyi yyahe cè n‑jwo yɛ? ");
INSERT INTO spp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ɲɛɛnuguŋi u ɲyɛ Kile jwumpe jwufooŋi. ");
INSERT INTO spp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kuni ɲwɔge na sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo, kuru tanuge e, ka Sitaanniŋi si pu wwû pi funŋ'i ke. ");
INSERT INTO spp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kafaafoge ɲuŋ'i sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo, maa ntíl'a ɲɛɛ pu na ná funntange e ke. ");
INSERT INTO spp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ŋka pu ɲyɛ a jà a ndìre le t'e mɛ, tire ɲwɔmɛɛni kɛ̀ngɛmɛ ɲyɛ a pɛn mɛ. Kawaa, lire ɲyɛ mɛ yyefugo ká ti ta Kile jwumpe kurugo, ti maha fworo Kile kuni i. ");
INSERT INTO spp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ŋgure shwɔhɔl'e sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo, ");
INSERT INTO spp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ka diɲyɛŋi karigii funmpɛɛnre ná nàfuuŋi lage ná yaayi shiŋi puni lage si ti ta, ka tire sɔ̀nŋɔre si pu cwɔ̂nrɔ, pu ɲyɛ a jà a yasɛrɛ pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɲìŋke niɲcɛnŋke na sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo maa ɲɛɛ pu na ke, tire sùpyire ti maha Kile ɲyii wuuni pyi. Tire sùpyire na ɲyɛ sùmaseŋɛ fiige, sùmacire tà à sùmaŋi se mà nɔ beɲjaaga ná kɛ kɛ na, tà à yasɛɛre pyi mà nɔ beetaanre taanre (60) na, tà à yasɛɛre pyi mà nɔ ŋkuu ŋkuu (100) na.» ");
INSERT INTO spp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ka Yesu si núr'a jwo pi á: «Wà ɲyɛ na fùkina mîni si u le ɲcyígile yaaga ɲwɔh'i mɛ, ŋka u maha dùrugo yaage kà ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yii li cè, kyaa maha kyaa l'à ŋwɔhɔ ke, cyire puni sí n‑pa raa ɲaa. Kyaa maha kyaa l'à yaa numpini i ke, lire là mú sì n‑kwôro ɲcèmbaa mɛ. ");
INSERT INTO spp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ŋgemu la ká mpyi si karii yyaha cè ke, urufoo u u niŋgyigigii cyán sèl'e.» ");
INSERT INTO spp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Maa núr'à jwo pi á: «Kile jwumpe yii na núru ke, yii pu yaha yiye funŋ'i, ɲaha na yɛ Kile sí yii kan n‑tàanna ná yii lógoŋkanni i. Puru ɲwɔhɔ na, u sí n‑pa tà bâra yii niɲcente na. ");
INSERT INTO spp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lire tèni i, shin maha shin u na ɲcaa si Kile jwumpe yyahe cè ke, Kile sí là taha uru u niɲcempe na. Ŋka shin maha shin u ɲyɛ u ɲyɛ na pu núru mɛ, nimbileni u à cè ke, lire sí n‑pînni.» ");
INSERT INTO spp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ka Yesu si núr'a jwo: «Kile Saanre à fworo nde kani kurugo: nàŋi wà u maha sùmashi nûru u kɛrɛge e. ");
INSERT INTO spp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Uru nàŋ'à ŋɔ́ɔ numpilage e yo, u ɲyɛ ɲyii na canŋke e yo, sùmapyaŋi sí n‑fyîn, sùmacire sí raa lyɛge. Ŋka nàŋi sì pà cè lire pyiŋkanni i mɛ. ");
INSERT INTO spp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ɲìŋke maha sùmaŋi pyi u à fyîn, sùmacige ku maha fyânha a fworo, lire kàntugo sùmaɲcyahaŋk'a sì nta a fworo sùmacige na, kàsanrage na sùmapyaŋi maha mpa fworo sùmaɲcyahaŋke na. ");
INSERT INTO spp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sùmapyaŋi ká lyɛ a nɔ u tɛgɛni na, nàŋi maha ntíl'a kɔ̀ɔnŋaŋi lwɔ́ na u kwùun, ɲaha na yɛ sùmakwɔngigii tèn'à nɔ.» ");
INSERT INTO spp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ka Yesu si núr'a jwo: «Ná ɲaha shi i mii sí n‑jà Kile Saanre tàanna yɛ? Ti ɲyɛ mu à jwo ɲaha bɛ? ");
INSERT INTO spp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ti na ɲyɛ mu à jwo mutaridi cige yasɛrɛ, nàŋi wà à sà ntemu nûgo u cikɔɔge e ke. Kuru cige pyàŋ'à yîlege cire sannte puni wuŋi na. ");
INSERT INTO spp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ŋka u aha nûgo, u maha fyîn, maa yîri maha ntòro kaɲyɛge yawyɛɛre puni taan. Ku maha ŋkéɲyi yige, yire maha mpêe fo saɲcyɛɛnre maha ti shèere yaa yi mbyìmpe e.» ");
INSERT INTO spp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ɲyɛ yire bàtaayi shiŋi niɲyahaya Yesu mpyi maha yu sùpyir'á mà tàanna ná ti yi ceŋkanni i. ");
INSERT INTO spp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Puru jwumpe shiŋi baare e, u mpyi na pabɛrɛ yu ná t'e mɛ. Ŋka u ná u cyelempyiibii kanni ká mpyi tèni ndemu i ke, u mpyi maha pu puni ɲwɔhe yu pi á. ");
INSERT INTO spp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kuru canŋke yàkoŋke, ka Yesu si jwo u cyelempyiibil'á: «Wuu a sì baŋi kùŋke na.» ");
INSERT INTO spp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ka pi i sùpyire cye yaha, maa ŋkàre ná Yesu i baŋi ɲuŋ'i, bakwooyi yabɛrɛ mpyi pi ɲwɔh'i. ");
INSERT INTO spp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka kafeebwɔhɔ si yîri na fwu, ka lwɔhe si wá na ɲcyânre na jyè bakwɔɔge e fo na ŋko si ku ɲî. ");
INSERT INTO spp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu mpyi bakwɔɔge kàntugo yyére mà ɲùŋke taha ɲùntahaga na, na ŋwúuni. Ka pi i u ɲɛ̀ maa jwo: «Cyelentuŋi, wuu na ŋko si ŋkwôro lwɔhe e, lire ɲyɛ a mu funŋɔ pɛn mà?» ");
INSERT INTO spp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","U à ɲɛ̀ ke, maa yîr'a fànha cyán kafɛɛge na, maa lwɔhe pyi ku tɛ̀ɛn. Ka kafɛɛge si yyére, ka lwɔhe si ntɛ̀ɛn siu! ");
INSERT INTO spp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lire kàntugo ka Yesu si pi pyi: «Ɲaha na yii na fyáge amɛ yɛ? Ɲaha na yii sàha ŋkwɔ̀ a dá mii na mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ka u cyelempyiibii si fyá sèl'e, marii yi yu piy'á: «Jofoo u ɲyɛ ŋge nàŋi fo ka kafɛɛge ná lwɔhe si ntɛ̀ɛn u wuuni taan yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɲyɛ ka Yesu ná u cyelempyiibii si nɔ baŋi kùŋke na, wani Gadara shiinbii ɲyɛ. ");
INSERT INTO spp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu à tîg'a fworo bakwɔɔge e ke, ka jínacyanŋi wà si ntíl'a fworo fanɲyi i, maa mpa u ɲùŋɔ bɛ̂. ");
INSERT INTO spp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Uru nàŋi mpyi na shùun fanɲyi i. Sùpya sàha mpyi na sì n‑jà u pwɔ mɛ, u mpyi maha u yapwoyi puni kwùun, ali yɔ̀rɔyi. ");
INSERT INTO spp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tooyi niɲyahay'e, pi mpyi maha u cwôre, marii u tooyi ná u cyeyi pwu ná yɔ̀rɔy'e. Ŋka u mpyi maha yire puni kyɛɛge. Sùpyire puni fành'à pa ɲcyɛ́rɛ u e, maa u ɲya, maa u yaha wani. ");
INSERT INTO spp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pìlaga bâra canŋa na, nàŋi mpyi maha ɲaare fanɲyi i, marii dùru ɲaɲyi ɲuŋ'i, marii ŋkwúuli, marii uye kúuli na fwóroge kafaayi na. ");
INSERT INTO spp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mà u yaha puru na, u à tɛ̀ɛn tatɔɔnge e maa Yesu ɲya, maa fê a pa niŋkure sín u taan. ");
INSERT INTO spp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Maa jwo fànha na: «Yesu, Kileŋi nìɲyi wuŋi Jyaŋi, ɲaha shi ku ɲyɛ wuu ná mu shwɔhɔl'e yɛ? Mii na mu ɲáare, Kile kurugo, ma hà kawaa pyi na na mà dɛ!» ");
INSERT INTO spp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","U à puru jwo, ɲaha kurugo yɛ Yesu mpyi a jínaŋi pyi na u fworo u e. ");
INSERT INTO spp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ka Yesu si nàŋi yíbe u mɛge na, ka u u jwo: «Mii mɛge ɲyɛ Shinɲyahara, ɲaha na yɛ wuu à ɲyaha.» ");
INSERT INTO spp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɲyɛ ka jínacyanŋi si Yesu ɲáare fànha na na u àha pire kɔ̀re ɲjige lire kùluni i mɛ. ");
INSERT INTO spp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ɲyɛ lir'à caakurumbwɔhɔ ta ku u lyî ɲaŋke kà numpɛngɛ na wani. ");
INSERT INTO spp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ka jínabii si Yesu ɲáare sèl'e, na u pire yaha pire pi sà jyè kuru caakuruŋke e. ");
INSERT INTO spp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ka u u ɲɛɛ. Ka pi i fworo nàŋi i maa sà jyè caabil'e. Lir'à pyi ke, ka caabii si sùrug'a yîri ɲaŋke numpɛnge na mà cwo cwo baŋi i. Pi mpyi a caalii kampwɔhii shuunni (2.000) kwɔ̀, ka pi puni si ŋkwôro lwɔhe e. ");
INSERT INTO spp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ka caabii kàanmucyafeebii si fê a kàr'a sà a yi yu kànhe ná sishwɔnbugure puni i. Ka sùpyire si mpa lire kani wíi. ");
INSERT INTO spp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pi à nɔ Yesu na ke, ka pi i nàŋi ɲya, ŋge e jínabii mpyi ke, u à tɛ̀ɛn u taan. Vàanɲyi na mpyi u na, u mpyi a tɛ̀ɛn tanuge e, ka pi i fyá. ");
INSERT INTO spp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nde l'à jínacyanŋi ná caabii ta ke, mpiimu pi à lire ɲya ke, ka pire si sà a li yu na ntùuli sùpyir'á, fworoŋkanni na jínabil'à fworo nàŋi i maa jyè caabil'e ke. ");
INSERT INTO spp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sùpyir'à puru jwumpe lógo ke, ka pi i wá na Yesu ɲáare sèl'e na u fworo pire kùluni i. ");
INSERT INTO spp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu niɲjyiŋi bakwɔɔge e, nàŋi i jínabii mpyi ke, ka uru si u ɲáare sèl'e s'a ŋkɛ̀ɛge ná u e. ");
INSERT INTO spp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ŋka Yesu ɲyɛ a ɲɛɛ mɛ, maa jwo: «Núru, ma a sì pyɛngɛ, kabwooni Kafooŋi Kile ɲùɲaare wuŋ'à pyi mu á ke, ma a sà lire yyaha jwo ma pyɛngɛ shiinbil'á.» ");
INSERT INTO spp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ka nàŋi si ŋkàre, nde Yesu à pyi u á ke, mà sà a yire yu na mâre Dekapoli kùluni i. Lir'à sùpyire puni kàkyanhala. ");
INSERT INTO spp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu à núr'a baŋi jyiil'a kɛ̂ɛnŋɛ kùŋke sanŋke na ná bakwɔɔge e. U à fworo ke, ka shinɲyahara si mpa u kwûulo. Mà u yaha kuru cyage e, ");
INSERT INTO spp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ka Kile Jwumpe kàlambage ɲùŋufooŋi wà si nɔ wani, u mɛge mpyi Zharusi. U à Yesu ɲya ke, maa niŋkure sín u taan, ");
INSERT INTO spp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","maa u ɲáare sèl'e: «Maye sanŋi yaha, mii pworoŋi wá na kuro caa, pa ma cyeyi taha u na, bà u si mpyi si ɲcùuŋɔ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ka Yesu si yîr'a kàre ná u e, ka shinɲyahara si ntaha u fye e fo na u fwòoŋi. ");
INSERT INTO spp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tire sùpyire shwɔhɔl'e ceeŋi wà mpyi wani, yyee kɛ ná shuunni funŋ'i, lùwuliŋkwombaayi mpyi u na. ");
INSERT INTO spp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","U mpyi a kànha wempyiini taan, u cyeyaare mpyi a kwɔ̀, u à shà wempyii niɲyahamii yyére, ŋka pà ɲyɛ a sàa fworo yampe e mɛ, fo pu na nâare. ");
INSERT INTO spp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","U à Yesu kyaa lógo ke, ka u u mpa sùpyire shwɔhɔl'e Yesu kàntugo yyére, maa bwɔ̀n u vàanɲyi na. ");
INSERT INTO spp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","U mpyi na yu uye funŋ'i: «Mii aha bú jà a bwɔ̀n u vàanɲyi na, mii sí n‑cùuŋɔ.» ");
INSERT INTO spp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","U à bwɔ̀n Yesu vàanɲyi na ke, ka lùwuliŋkwombaayi si ntíl'a kwɔ̀, ka u u li cè uye e na ur'à cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ka Yesu si ntíl'a li cè uye e na fànhe kà à fworo ur'e, maa yyaha kɛ̂ɛnŋ'a le sùpyire e, maa jwo: «Jofoo u à bwɔ̀n mii vàanɲyi na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka u cyelempyiibii si u pyi: «Mu ɲyii na ɲyɛ nte sùpyire puni na, t'à mu fɛnrɛ kàmpanɲyi puni na, maa núru na yíbili na jo u à bwɔ̀n mu na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lire ná li wuuni mú i, ka Yesu si wá na wíi na mâre sùpyire shwɔhɔl'e, ŋge u à bwɔ̀n u na ke, si uru cè. ");
INSERT INTO spp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ceeŋi u mpyi a bwɔ̀n u na ke, ur'à fyá fo na ɲcyɛ̂ɛnni, nde l'à u ta ke, u à lire cè, ka u u mpa niŋkure sín Yesu yyaha na, maa sèeŋi puni jwo u á. ");
INSERT INTO spp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ka Yesu si u pyi: «Na pworo, mu dániyaŋ'à mu shwɔ mpe yampe na, ta sì yyeɲiŋke ná fɛrɛmpe e.» ");
INSERT INTO spp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mà u yaha puru jwumpe na, pìl'à yîri ɲùŋufooŋi Zharusi pyɛnge e mà pa yi jwo Zharusi á: «Kile wuuni na wá à nɔ mu pworoŋi na. Ma hà núru cyelentuŋi yaha u uye kànha u a ma mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ŋka Yesu ɲyɛ a puru jwumpe lwɔ́ a wíi mɛ, maa yi jwo nàŋ'á: «Ma hà raa fyáge mɛ, dá mii na kanna.» ");
INSERT INTO spp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ka pi i yîri na ŋkɛ̀ɛge Kile Jwumpe kàlambage ɲùŋufooŋi yyére. Yesu ɲyɛ a ɲɛɛ sùpyaŋi wabɛrɛ u kuni bínni ná ur'e mɛ, fo Pyɛri ná Yakuba ná u cìnmpworonaŋi Yuhana. ");
INSERT INTO spp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pi à nɔ ɲùŋufooŋi pyɛnge e ke, ka Yesu si shinɲyahara ɲya ti i ɲyàha na wùruge tiye e, marii myahigii súu marii kwuuyi wàa. ");
INSERT INTO spp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","U à jyè ke, ka u u pi pyi: «Ɲaha kurugo yii na tùpyaagii wàa marii myahigii súu yɛ? Pyàŋi ɲyɛ a kwû mɛ, u na ŋwúuni!» ");
INSERT INTO spp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ka pi i wá na ɲcyàhali u na. Ka u u pi yige ntàani na. Bage e pyàŋi mpyi a sínni ke, ka u u jyè wani ná pyàŋi sifeebii ná u cyelempyiibii taanreŋi i. ");
INSERT INTO spp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Maa pyàŋi buwuŋi cû u cyɛge na, maa yi jwo u á pi shɛɛnre e: «Talita kumi!» Lire ɲwɔhe ku ɲyɛ: «Mii pworoŋi, ta núru, yîri!» ");
INSERT INTO spp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kuru cyage mujye e, ka pùcwoŋi si yîri na ɲaare, u mpyi yyee kɛ ná shuunni. Ka lire si sàa pi puni kàkyanhala. ");
INSERT INTO spp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ka Yesu si yi jwo a waha pi á na pi àha ŋkwɔ̀ wà yaha u nde kani cè mɛ, maa pi pyi na pi ɲjyì kan u á. ");
INSERT INTO spp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lire kàntugo Yesu à núr'a kàre u tukanhe Nazarɛti i, u cyelempyiibii mpyi u fye e. ");
INSERT INTO spp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Canŋɔŋk'à pa nɔ ke, ka u u wá na sùpyire kâlali Kile Jwumpe kàlambage e. Lir'à u lógofeebii niɲyahamii kàkyanhala, ka pi i wá na ŋko: «Nte yákilifente ti ɲyɛ u á ke, ná ɲcyii kakyanhala karigii u na mpyi ke, taa u à jà a cyire puni ta ke? ");
INSERT INTO spp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Taha cíkyangaŋi bà u ɲyɛ u wi mɛ? Mariyama pyìibii pi ɲyɛ Yakuba ná Zhoze ná Zhude ná Simɔ ná pùcɛribii pi ɲyɛ naha kànhe e ke, pire mpii yyaha wuŋi bàl'à?» Ɲyɛ tire sɔ̀nŋɔr'à nâara a pi pyi pi a ɲùŋɔ tugo Yesu na. ");
INSERT INTO spp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ka Yesu si jwumpe lwɔ́ maa jwo pi á: «Kile tùnntunŋɔ maha le ɲjire e cyeyi puni i, fo u cìnmpyiibii ná u tukanhe ná u tupyɛnge yɛ.» ");
INSERT INTO spp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pi ɲyɛ a dá Yesu na mɛ, lir'à u sige u ɲyɛ a kakyanhala karii niɲyahagii pyi wani mɛ. U à u cyeyi taha yamii niŋkin niŋkin na, maa pire cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pi dánabaare Yesu na, lir'à u kàkyanhala. Ka u u wá na kàlaŋi pyi na ntùuli kuru kàmpanŋke kànyi na. ");
INSERT INTO spp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Lire kàntugo ka Yesu si u cyelempyiibii kɛ ná shuunniŋi yyere na ntunni shuunni shuunni pi sà a Kile jwumpe yu. Maa fànhe kan pi á mú, pi a jínabii kɔ̀re pi a yige pifeebil'e. ");
INSERT INTO spp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Maa yi jwo pi á: «Fo kàbii bà mɛ, yii àha yaage kabɛrɛ lwɔ́ raa ŋkɛ̀ɛge kuni i mɛ, yii àha yalyire lwɔ́ mɛ, yii àha boro lwɔ́ mɛ, yii àha wyɛ́rɛ lwɔ́ nde dufaabil'e mɛ. ");
INSERT INTO spp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yii tanhanya lwɔ́, ŋka yii àha vàanntinɲyi shuunni lwɔ́ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","U à kwɔ̀ maa pi pyi: «Yii aha ŋkàre kànha maha kànha na, ka wà si ɲɛɛ yii sunmbage na ke, yii à yaa yii pi tɛ̀ɛn wani fo mà sà yaa ná yii tèekani i. ");
INSERT INTO spp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ŋka yii aha ŋkàre cyage k'e, ka pi i yii sunmbage cyé, maa mpyi pi ɲyɛ a ɲɛn'a yii jwumpe lógo mɛ, yii nivworobii kuru kànhe e, yii yii tooyi bambaŋi kwòro kwòr'a wu wani, lir'à kajwuu kwɔ̀ kuru kànhe shiin na.» ");
INSERT INTO spp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ka pi i ŋkàr'a sà a Kile jwumpe yu sùpyir'á, na pi pi toroŋkanni kɛ̂ɛnŋɛ. ");
INSERT INTO spp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Marii jínacyaanbii niɲyahamii jínahii kɔ̀re na yige pi e, marii yamii niɲyahamii tìri ná sìnmpe e marii Kile ɲáare, ka pi i wá na ɲcùuŋi. ");
INSERT INTO spp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lire tèni i, Yesu mɛg'à fworo cyeyi puni i, ka saanŋi Erɔdi si u kyaa lógo. Pìi mpyi na ŋko: «Yuhana Batizelipyiŋi u à ɲɛ̀ a fworo kwùŋi i, lire kurugo u à jà na kakyanhala karigii pyi amɛ.» ");
INSERT INTO spp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pìi sí i ŋko na Kile tùnntunŋiEli u à núr'a pa, pìi mú sí i ŋko na tèecyiini Kile tùnntunŋi wà u à ɲɛ̀ a fworo kwùŋi i. ");
INSERT INTO spp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erɔdi à cyire karigii lógo ke, maa jwo: «Yuhana Batizelipyiŋi ɲùŋke mii à pyi pi à kwɔ̀n ke, uru u à ɲɛ̀ a fworo kwùŋi i.» ");
INSERT INTO spp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Yii li cè na Erɔdi mpyi a u sìɲɛɛŋi Filipi cwoŋi kwɔ̀n a lwɔ́ mà pyi u cwo. Uru ceeŋi mɛge na mpyi Erɔdiyadi. Lire e ka Yuhana si yi jwo Erɔdi á na u ɲyɛ a yaa u u sìɲɛɛŋi cwoŋi shwɔ u na mɛ. Ka puru jwumpe si waha Erɔdi na, ka u u pi pyi pi à Yuhana cû a le kàsuŋi i. ");
INSERT INTO spp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ka Erɔdiyadi lùuni mú si yîri, maa wá na boŋkanni caa Yuhana na. Ŋka u yabiliŋi mpyi na sì n‑jà mɛ. ");
INSERT INTO spp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erɔdi mpyi na fyáge Yuhana na, ɲaha na yɛ u mpyi a cè na Yuhana à tíi maa mpyi Kile sùpya. Lire kurugo u mpyi a yaha u na. Erɔdi n'a mpyi a u mɛjwuuni lógo, u funŋke mpyi maha mpɛn. Lire ná li wuuni mú i, Yuhana jwumpe mpyi maha ntáan u á. ");
INSERT INTO spp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ɲyɛ Erɔdi canzeg'à pa mâhana a nɔ lire yyeeni ke, ka u u kataan bégele u wwoɲɛɛbii ná sòrolashiibii ɲùŋufeebii ná Galile kùluni shinbwoobii mɛɛ na. Kuru canŋke Erɔdiyadi sí u nimpyiini pyi Yuhana na. ");
INSERT INTO spp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erɔdiyadi mpyi a nàmbage lèŋɛ saanŋ'á ná pùceebilini ndemu i ke, mà sùpyire yaha kataanni na, lir'à jyè na ŋkwɔ̂hɔli, ka li kyaa si ntíl'a táan Erɔdi ná u shinyyerebil'á. Ka saanŋi si jwo pùceebilin'á: «Yaage na mu na ɲcáa ke, ku cyêe, mii sí ku kan mu á.» ");
INSERT INTO spp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Maa ŋkâa pùceebilin'á, na u aha yaaga maha yaaga ɲáare ur'á ke, uru sí ku kan u á, ali u niɲarege mɛ́ɛ k'à bɛ̂ uru kìni taaga niŋkin na. ");
INSERT INTO spp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ka pùceebilini si fworo ntàani na, maa u nuŋi yíbe: «Ɲaha mii à yaa mii u ɲáare yɛ?» Ka nufooŋi si u pyi: «Yi jwo u á na u Yuhana Batizelipyiŋi ɲùŋke kan ma á.» ");
INSERT INTO spp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kuru cyage mujye e, pùceebilin'à fyâl'a jyè saanŋi yyére maa yi jwo u á: «Mii la ɲyɛ mà Yuhana Batizelipyiŋi ɲùŋke kwɔ̀n a le ŋkunan'i mà kan na á numɛ.» ");
INSERT INTO spp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Puru jwump'à saanŋi yyahe tanha sèl'e, ŋka mà u yaha u à kâa pùcwoŋ'á u shinyyerebii ɲyii na, u la sàha mpyi si ɲcyé mɛ. ");
INSERT INTO spp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kuru tanuge e, ka u u sòrolashiŋi wà tun u sà Yuhana ɲùŋke kwɔ̀n, u a ma. Ka uru si ŋkàre kasubage e mà sà Yuhana ɲùŋke kwɔ̀n, ");
INSERT INTO spp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mà le ŋkunan'i mà pa ŋkan pùceebilin'á, ka uru sà ŋkan u nuŋ'á. ");
INSERT INTO spp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","U cyelempyiibil'à u mbòŋi kyaa lógo ke, maa mpa u lwɔ́ a sà ntò. ");
INSERT INTO spp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ɲyɛ Yesu tùnntunmpil'à piye bínni u taan, maa pi kapyiiŋkii puni ná pi kàlaŋi nimpyiŋi puni jwo u á. ");
INSERT INTO spp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sùpyiibii nimpaampii ná niŋkaribii mpyi a ɲyaha a tòro, fo mà Yesu ná u cyelempyiibii sige yalyire na, ka u u yi jwo pi á: «Yii a wá wuu yîri naha, wuu raa sì wuu mɛge cyage sige e, yii i sà ŋɔ̀ wani.» ");
INSERT INTO spp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ka pi i bakwɔɔge lwɔ́ mà kàre pi mɛge cyage e sige e. ");
INSERT INTO spp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Shinɲyahara à pi niŋkaribii ɲya mà pi cè. Ka kuru cyage kàmpanɲyi kànyi shinɲyahara si fê à núr'a sà pi caanra sige e. ");
INSERT INTO spp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu à fworo bakwɔɔge e mà pi ɲya pi à ɲyaha sèl'e ke, ka pi ɲùɲaare si u ta sèl'e, ɲaha na yɛ pi mpyi mu à jwo mpàa pi ɲyɛ piye ɲùŋɔ kurugo. Ka u u wá na pi kâlali karii niɲyahagii na. ");
INSERT INTO spp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","U cyelempyiibil'à tèni ɲya li i ntùuli ke, ka pi i file u na maa jwo: «Cyelentuŋi! Sige funŋke e wuu ɲyɛ, canŋke s'à kwɔ̀ a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sùpyire cye yaha t'a sì sishwɔnbugure ná kànyi na, ti sà yalyire cya a shwɔ.» ");
INSERT INTO spp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ka Yesu si pi pyi: «Yii yabilimpii pi pi kan pi lyî.» Ka pi i u pyi: «Wuu mɛ́ɛ ká ŋkàr'a sà shin niŋkin canmpyaa ŋkwuu shuunni (200) báara sàra tɛ̀g'a bwúuru shwɔ mà pa ŋkan pi á, uru sí n‑jà pi ta la?» ");
INSERT INTO spp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ka Yesu si núr'a pi yíbe: «Yii sà wíi! Bwúuru ɲùɲyi jùuli yi wá yii á yɛ?» Ka pi i sà kàanmucyaga pyi, maa mpa Yesu pyi na bwúuru ɲùnyɔ kaŋkuro ná fyapyaa shuunni yi wá wani. ");
INSERT INTO spp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ɲyɛ ka Yesu si u cyelempyiibii pyi na pi sùpyire tìŋɛ tìŋɛ, kuruyo kuruyo ɲyɛ̀puruge ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ka pi i ntɛ̀ɛn shiin ŋkuu ŋkuu (100) ná shiin beeshuunni ná kɛ kɛ kuruɲyi i. ");
INSERT INTO spp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ka Yesu si bwúuru ɲùɲyi kaŋkuruŋi ná fyapyaagii shuunniŋi lwɔ́ u cyeyi i, maa yyahe yîrige nìɲyiŋi i maa fwù kan Kile á yi kyaa na. U à kwɔ̀ ke, maa bwúuruŋi ná fyapyaagii kwɔ̀n kwɔ̀n mà kan u cyelempyiibil'á pi à táa sùpyire na. ");
INSERT INTO spp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sùpyire ti mpyi wani ke, tire pun'à lyî a tìn. ");
INSERT INTO spp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bwúuruŋi ná fyaabii paanyi y'à kwôro ke, yire mpyi a shàhii kɛ ná shuunni ɲî. ");
INSERT INTO spp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mpii pi à lyî ke, pire nàmbaabii kanni mpyi shiin kampwɔhii kaŋkuro (5.000). ");
INSERT INTO spp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ɲyɛ lire ɲwɔhɔ na, mà Yesu yaha u u sùpyire cye yare, u à u cyelempyiibii pyi pi à jyè bakwɔɔge e, maa baŋi jyiile u yyaha na, Bɛtisayida kànhe yyére. ");
INSERT INTO spp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesu à ti cye yaha ke, maa ŋkàr'a sà Kile ɲáare ɲaŋke kà na. ");
INSERT INTO spp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Numpilag'à wwɔ̀ mà u cyelempyiibii ta bakwɔɔge e baŋi niŋke e, uru kanni u mpyi ɲìŋke na. ");
INSERT INTO spp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Numpilyage na, kafɛɛge mpyi na pi bêni, ka Yesu si li ɲya na pi à kànha bakwɔɔge mpuruŋi taan. Pi sàha mpyi na jìn'a ku pyi ku u ŋkɛ̀ɛge fwɔfwɔ mɛ. Ka Yesu si yîri na ɲaare na ŋkɛ̀ɛge pi fye e lwɔhe ɲuŋ'i. U à byanhara pi na ke, ka u la si mpyi s'a ntùuli pi ŋkere na. ");
INSERT INTO spp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ŋka pi à u nimpaŋi ɲya lwɔhe ɲuŋ'i ke, pi mpyi na sɔ̂nŋi na buŋi wà fwɔ̀ɔngɔ ki, ka pi i yîri na kwuugii wàa, ");
INSERT INTO spp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ɲaha na yɛ pi puni ɲyii mpyi u na, pi puni zòompii mpyi a kwɔ̀n. Ka Yesu si ntíl'a jwumpe lwɔ́ maa pi pyi: «Yii yákilibii tìŋɛ, yii àha vyá mɛ, mii wi.» ");
INSERT INTO spp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ka u u jyè bakwɔɔge e pi fye e, ka kafɛɛge si ntíl'a yyére. Lir'à pi puni kàkyanhala fo pi funŋɔ jwump'à kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pi ɲyɛ a mpyi a cè supyishiŋi u ɲyɛ Yesu mɛ. Kakyanhani u à pyi mà bwúuruɲyahage kan sùpyir'á ke, lir'à pyi pi ɲyii na, ŋka pi funɲyi mpyi a múgo mɛ. ");
INSERT INTO spp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɲyɛ Yesu ná u cyelempyiibil'à baŋi jyiile ke, maa nɔ Zhenɛzarɛti kùluni i, maa bakwɔɔge yyéeŋɛ baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pi à fworo bakwɔɔge e ke, ka sùpyire si Yesu ɲya a cè, ");
INSERT INTO spp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","maa ŋkàre cyeyi puni i mà sà a Yesu mpaŋi kyaa yu. Cyaga maha cyag'e pi mpyi a u kyaa lógo ke, pi mpyi maha ma ná yampil'e na yîri kàmpanɲyi puni na, pi yasinniɲyi ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu n'a mpyi a nɔ cyaga maha cyag'e ke, kànbwɔhɔ yo, kànbilere yo, sishwɔn bùguro yo, sùpyire mpyi maha mpa ná yampil'e maha mpa yaha tafage e, marii u ɲáare na u pi yaha pi a bwùun u vàanntinŋke zhwɔ̀ɔre na kanna. Yampii pi mpyi maha bwùun u na ke, pire puni mpyi maha ɲcùuŋi. ");
INSERT INTO spp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kile Saliyaŋi cyelentiibii pìi mpyi a yîri Zheruzalɛmu kànhe e, ka pi ná Farizhɛɛnbii si sà bínni Yesu taan. ");
INSERT INTO spp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Maa li kàanmucya mà li ɲya na u cyelempyiibii mpyi na lyî ná cyeyi niɲwɔhɔyi i Kile yyahe taan, ɲaha na yɛ pi ɲyɛ a yi jyè mà tàanna ná Yahutuubii làdaabil'e mɛ. ");
INSERT INTO spp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farizhɛɛnbii ná Yahutuubii sanmpii n'a mpyi na sí raa lyî, pi mpyi maha cyeyi yal'a jyè a fíniŋɛ Kile yyahe taan mà tàanna ná pi tulyeyi làdaabil'e. ");
INSERT INTO spp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Lire pyiŋkanni na, pi n'a mpyi a yîri caange na, pi mpyi maha wìli maha piye fíniŋɛ Kile yyahe taan mà tàanna ná làdaabil'e, maa nta a lyî. Làdaabii pìi saha na mpyi yaayi ɲjyìŋi kyaa na, mu à jwo: fùnɲcwoyi ná pwoore cwɔhigii ná dàɲyɛŋi yaayi ná yatɛɛnɲyi. ");
INSERT INTO spp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ka Farizhɛɛnbii ná Kile Saliyaŋi cyelentiibii si Yesu yíbe: «Ɲaha na mu cyelempyiibii ɲyɛ na wuu tulyeyi làdaabii kurigii ɲaare mà yɛ? Ɲaha na pi ɲyɛ na cyeyi jyíi mà tàanna ná làdaabil'e maa nta na lyî mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ka Yesu si pi pyi: «Yii pi à fyìnmɛ tò wwomɔ na ke! Kile tùnntunŋi Ezayi mpyi a jwumpe mpemu jwo yii kyaa na ke, pur'à sàa pyi sèe. L'à sémɛ Ezayi sémɛŋi i na Kile à jwo: “Nte sùpyire na mii pêre ɲwɔyi i kanna, mà li ta pi zòompii laag'à tɔɔn mii na. ");
INSERT INTO spp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pi na mii pêre tawage e, ɲaha na yɛ kàlaŋi pi ɲyɛ na ŋkaan ke, ur'à lwɔ́ a pwɔ sùpyire làdaabii karigii na.”» ");
INSERT INTO spp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ka Yesu si núr'a yi jwo pi á: «Yii à cyé Kile toŋi na, maa ntaha sùpyire làdaabii fye e. ");
INSERT INTO spp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yii na sɔ̂nŋi na yii tànga na ɲyɛ mà cyé Kile toŋi na, maa ntaha yii yabilimpii làdaabii fye e. ");
INSERT INTO spp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kile tùnntunŋi Musa à jwo na “Ma tuŋi ná ma nuŋi pêe, ŋgemu ká jwumpimɛ jwo a wà u tuŋi, lire ɲyɛ mɛ u nuŋi na ke, urufoo sí n‑bò.” ");
INSERT INTO spp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Ŋka yii pi ke, yii na sùpyire kâlali ŋge làdaŋi na, u mɛge ɲyɛ Kɔrɔban. Sùpya ká jwo na uru nàfuuŋi na ɲyɛ Kɔrɔban, lire ɲwɔhe ku ɲyɛ na ur'à u kan Kile á, na fànhe saha ɲyɛ uru na u u sifeebii tɛ̀gɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lire pyiŋkanni na, yii làdaabii kurugo, Kile jwump'à pyi kaɲwɔɔ baa sùpyire ɲyii na, ŋka lire kanni bà mɛ, yii na cyire ɲcyii karigii shiŋi niɲyahagii pyi.» ");
INSERT INTO spp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Puru ɲwɔhɔ na, Yesu à núr'a sùpyire yyere, maa yi jwo t'á: «Yii puni, yii niŋgyigigii múgo, yii i na jwumpe lógo, yii i pu yyaha cè sèl'e. ");
INSERT INTO spp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yaayi yi na jyìi sùpyaŋi funŋke e ke, kuru kà ɲyɛ a sìi na jìn'a u ɲwɔ́hɔ mɛ. Ŋka ɲjemu yi na fwore sùpyaŋi funŋke e ke, yire yi maha sùpyaŋi ɲwɔ́hɔ Kile yyahe taan.  ");
INSERT INTO spp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ŋgemu la ká mpyi si karii yyaha cè ke, urufoo u u niŋgyigigii cyán sèl'e.» ");
INSERT INTO spp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tèni i Yesu à yîri sùpyire taan mà jyè bage e ke, ka u cyelempyiibii si u yíbe lire tàanlini ɲwɔhe na. ");
INSERT INTO spp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ka u u pi pyi: «Yii yabilimpii, ali numɛ yákilitan ɲyɛ yii á mà? Mpe mii na yu ke, yii ɲyɛ na puru núru mà? Yaaga maha yaaga k'à yîri cyíinŋi na mà jyè sùpyaŋi funŋke e ke, kuru sì n‑jà u ɲwɔ́hɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tire nte yalyire ɲyɛ na jyè sùpyaŋi zòmbilini funŋke e mɛ, lage e ti maha jyè, lire kàntugo, urufoo ká shà yaare e, ti maha fworo.» Pure jwumpe cye kurugo, Yesu à li cyêe na yalyire pun'à fíniŋɛ. ");
INSERT INTO spp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","U a jwo: «Ɲcyii cyi ɲyɛ sùpyaŋi zòŋi na ke, cyire cyi maha u ɲwɔ́hɔ Kile yyahe taan. ");
INSERT INTO spp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ɲaha kurugo yɛ sɔ̀nŋɔpeere maha fwore sùpyaŋi zòmbilini i, mu à jwo tasinnage kɛgɛmɛ karigii ná nàŋkaage ná supyibuuni ná ");
INSERT INTO spp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jacwɔɔre ná ntiimbaaŋi ná pege ná nàɲwɔhɔre ná silegebaare ná ɲyipɛɛnni ná jwoore ná yàmpeente ná funŋɔbaare. ");
INSERT INTO spp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Cyire ɲcyii kapegigii cyi ɲyɛ na fwore zòmbilini i ke, cyire cyi maha sùpyaŋi ɲwɔ́hɔ Kile yyahe taan.» ");
INSERT INTO spp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ka Yesu si yîri wani mà kàre Tiri ná Sidɔn kànyi kàmpanŋke na. U à nɔ wani ke, maa jyè bage k'e. U la ɲyɛ a mpyi wà sì uru kyaa cè mɛ. Ŋka u ɲyɛ a jà a ŋwɔhɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ka ceeŋi wà si u kyaa lógo, maa ntíl'a pa niŋkure sín u fere e. Uru ceeŋi mpyi Yahutu mɛ, u mpyi na yîri Sirofenisi kùluni i. Jínaŋi wà mpyi u pworoŋi i, ka u u Yesu ɲáare na u u kɔ̀r'a yige u e. ");
INSERT INTO spp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ka Yesu si ceeŋi pyi: «Yyére nàŋkopyire si lyî a tìn fɔlɔ, ɲaha na yɛ mà nàŋkopyire yalyire lwɔ́ a wà pwunmpyir'á, lire ɲyɛ a ɲwɔ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ka ceeŋi si u pyi: «Kafooŋi, yire ɲyɛ sèe, ŋka pwuunbii pi maha ntɛ̀n tàbalaŋi ɲwɔh'i ke, pire maha nàŋkopyire yalyire paanre lyî.» ");
INSERT INTO spp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ka Yesu si yi jwo u á: «Mu ɲwɔshwɔɔr'à ɲwɔ, mu sí n‑jà núru pyɛngɛ, mii à jínaŋi yige mu pworoŋi i.» ");
INSERT INTO spp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ka u u núr'a kàre pyɛngɛ mà sà pyàŋi ta u à sínni yasinniŋke na, jínaŋi mpyi a fworo u e. ");
INSERT INTO spp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ka Yesu si yîri Tiri ná Sidɔn kànyi kàmpanŋke na, maa ŋkàre Galile baŋi kàmpanŋke na, maa sà jyè Dekapoli kùluni i. ");
INSERT INTO spp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ka pi i shà ná nàŋi w'e u yyére. Uru nàŋi mpyi ɲùɲcunnɔ, jwumpe s'à waha u á mú sèl'e. Ka pi i Yesu ɲáare na u u cyɛge taha u na, bà u si mpyi si ɲcùuŋɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ka Yesu si nàŋi cû mà yîri sùpyire taan mà kàre tatɔɔnge e. Kuru cyage e, u à kampeeni le u niŋgyigigil'e, maa ntilwɔhe ta u ɲjini na. ");
INSERT INTO spp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Maa ɲùŋke dùrugo kileŋi i, maa ŋɔ̀ a kùuŋɔ, maa jwo: «Efata» lire ɲwɔhe ku ɲyɛ: «Yii múgo!» ");
INSERT INTO spp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lire tèni mujye e, ka niŋgyigigii mú shuunni si múgo, ka ɲjini mú si sànha. Ka u u wá na ntíili na yu. ");
INSERT INTO spp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu à núr'a pa sùpyire cyage e ke, maa yi jwo a waha pi á, na pi àha sùpyaŋi wabɛrɛ yaha u yi cè mɛ. Ŋka u jwump'à pyi kee p'à pi nâara, ka pi i ntíl'a sà a pu yu na ntùuli. ");
INSERT INTO spp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sùpyire ti mpyi wani ke, li mpyi a pire puni kàkyanhala sèl'e, ka pi i wá na ŋko: «Karigii niɲcɛnŋkii kanni u na mpyi. U maha ɲùɲcunnibii pyi pi i núru, maa búbuubii pyi pi i yu!» ");
INSERT INTO spp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Canŋka shinɲyahara à pa bínni Yesu taan sahaŋki, yalyire sí ɲyɛ a mpyi pi á mɛ, ka Yesu si u cyelempyiibii yyere maa jwo: ");
INSERT INTO spp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ŋke supyikuruŋke ɲùɲaare naha mii na sèe sèl'e, pi canŋke taanre woge ku ɲyɛ naha mii taan, yalyire ɲyɛ pi á mɛ. ");
INSERT INTO spp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mii aha pi katege wuubii yaha a kàre pi kànyi na, pi fànhe sí n‑kwɔ̀ kuni na, ɲaha na yɛ pi pìi tayiriy'à tɔɔn.» ");
INSERT INTO spp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ka u cyelempyiibii si u yíbe: «Taa nte sùpyire puni tìntin yalyire sí n‑ta naha ŋke síwage e ke?» ");
INSERT INTO spp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ka Yesu si pi yíbe: «Bwúuru ɲùnyɔ jùuli yi wá yii á yɛ?» Ka pi i jwo: «Baashuunni.» ");
INSERT INTO spp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ka u u sùpyire pyi t'à tɛ̀ɛn ɲìŋke na. Maa bwúuru ɲùɲyi baashuunniŋi lwɔ́, maa fwù kan Kile á yi kyaa na, maa yi kwɔ̀n kwɔ̀n mà kan u cyelempyiibil'á pi táa sùpyire na, ka pire si u táa pi na. ");
INSERT INTO spp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Fyapyire mú na mpyi wani, ka Yesu si tire lwɔ́, maa fwù kan Kile á ti kyaa na, maa tire mú kan u cyelempyiibil'á pi táa sùpyire na. ");
INSERT INTO spp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kuru supyikuruŋk'à lyî a tìn, ka pi i ŋkwɔ̀ maa saanya baashuunni ɲî ɲjyìpaanyi na. ");
INSERT INTO spp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Pi mpyi a shiin kampwɔhii sicyɛɛre (4.000) kwɔ̀. Lire kàntugo ka Yesu si pi yaha a kàre. ");
INSERT INTO spp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ka Yesu ná u cyelempyiibii si ntíl'a jyè bakwɔɔge k'e mà kàre Dalimanuta kùluni i. ");
INSERT INTO spp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pi à nɔ ke, ka Farizhɛɛnbii pìi si mpa Yesu ɲwɔge waha. Pi à jwo na u kani là pyi u cyêe pire na ndemu l'à li cyêe u à fworo Kile e ke. Kànhaŋa pi mpyi a cyán Yesu na. ");
INSERT INTO spp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Lir'à pɛn u e ke, ka u u ŋɔ̀ a kùuŋɔ fànhe na, maa jwo: «Ɲaha na nte sùpyire ɲyɛ na kacyeele caa mii á yɛ? Sèeŋi na mii sí yi jwo yii á, là sì n‑cyêe ti na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ka u ná u cyelempyiibii si yîri pi taan mà jyè bakwɔɔge e, maa baŋi jyiile. ");
INSERT INTO spp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ka u cyelempyiibii funŋɔ si wwɔ̀ yalyire na, bwúuru ɲùŋɔ niŋkin kanna ku mpyi pi á bakwɔɔge e. ");
INSERT INTO spp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ka Yesu si yi jwo a waha pi á: «Yii a yiye kàanmucaa Farizhɛɛnbii ná Erɔdi bwúuruŋi yîrigeyirige yaani na.» ");
INSERT INTO spp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ka u cyelempyiibii si pi funɲyi cya puru jwumpe na, maa jwo piye shwɔhɔl'e: «Bà wuu à pyi wuu ɲyɛ a pa ná bwúuru i mɛ, lire e u à mpe jwo bɛ?» ");
INSERT INTO spp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ɲyɛ Yesu à pa pi kunuŋke ɲwɔhe cè ke, maa jwo: «Ɲaha kurugo bwúuruŋi wuun'à yii funŋɔ wwòoŋɔ yɛ? Ali numɛ yii yákilibii sàha ŋkwɔ̀ a múgo mà? Yii funɲyi saha à tò la? ");
INSERT INTO spp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ɲyiigii na ɲyɛ yii á, yii ɲyɛ na ɲaa mà? Niŋgyigigii na ɲyɛ yii á, yii ɲyɛ na núru mà? Yii funɲyi ɲyɛ na ɲcwu kyaa na mà? ");
INSERT INTO spp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Canŋke mii à bwúuru ɲùɲyi kaŋkuruŋi kwɔ̀n kwɔ̀n mà kan shiin kampwɔhii kaŋkuruŋ'á (5.000) ke, pi lyìŋkwooni kàntugo, shàhigii jùuli yii à ɲî bwúuru kwɔɔnre na yɛ?» Ka pi i jwo: «Kɛ ná shuunni.» ");
INSERT INTO spp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Lire kàntugo canŋke mii à bwúuru ɲùɲyi baashuunniŋi tɛ̀g'a shiin kampwɔhii sicyɛɛreŋi (4.000) ɲwɔ cya à de? Pi lyìŋkwooni kàntugo, saanyi jùuli yii à ɲî bwúuru kwɔɔnre na yɛ?» Ka pi i jwo: «Baashuunni.» ");
INSERT INTO spp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ka Yesu si pi pyi: «Ali numɛ, yii funɲyi sàha ŋkwɔ̀ a múgo mà?» ");
INSERT INTO spp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Puru ɲwɔhɔ na, Yesu ná u cyelempyiibil'à kàre Bɛtisayida kànhe e. Pi à nɔ wani ke, ka pi i mpa ná fyinnaŋi w'e, maa Yesu ɲáare na u bwɔ̀n u na. ");
INSERT INTO spp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ka Yesu si u cû cyɛge na, maa ŋkàre kànhe kàntugo, maa sà u ntilwɔhe tɛ̀g'a u ɲyiigii cwuugo, maa cyeyi cyígile cyi na. U à pa cyeyi láha tèni ndemu i ke, maa u yíbe: «Mu wá na yaaga ɲaa la?» ");
INSERT INTO spp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ka nàŋi si ɲyiigii múgo maa jwo: «Mii naha na sùpyire ɲaa, ŋka ti naha mu à jwo cire ti ɲaare.» ");
INSERT INTO spp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ka Yesu si núr'a cyeyi cyígile u ɲyiigii na, tèni i u à pa yi láha ke, ka nàŋi si uye ta u à cùuŋɔ, fo u na ɲaa na ɲcwúu. ");
INSERT INTO spp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ka Yesu si u pyi u núru, u a sì pyɛngɛ, u sàha bú ntòro kànhe e mɛ. ");
INSERT INTO spp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ná u cyelempyiibil'à wá na ŋkɛ̀ɛge Sezare Filipi kùluni kànyi na. Mà pi yaha kuni na, ka u u pi yíbe: «Sùpyire na mii sɔ̂nŋi jofoo yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ka pi i u pyi: «Pìi wá na ŋko Yuhana Batizelipyiŋi u ɲyɛ mu, pìi sí i ŋko na Kile tùnntunŋi Eli u ɲyɛ mu, pìi mú sí i ŋko na Kile tùnntunmpii sanmpii pi à tòro ke, na uru wà u ɲyɛ mu.» ");
INSERT INTO spp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ka Yesu si pi pyi: «Yii de? Jofoo yii ɲyɛ na mii sɔ̂nŋi yɛ?» Ka Pyɛri si u pyi: «Kile Niɲcwɔnrɔŋi u ɲyɛ mu.» ");
INSERT INTO spp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ka Yesu si yi jwo a waha pi á, na pi àha ŋkwɔ̀ yire jwo sùpya á uru kyaa na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Cyire karigii kàntugo, ka Yesu si wá na u cyelempyiibii kâlali, maa jwo: «L'à pyi fànha kyaa Supyaŋi Jyaŋi u kyaala sèl'e. Kacwɔnribii ná Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii sí n‑cyé u na, si u bò. Ŋka u kwùŋi canmpyitanrewuuni u sí ɲɛ̀.» ");
INSERT INTO spp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu à cyire karigii jwo a fíniŋɛ pi ɲyii na. Ka Pyɛri si u yyer'a fɛ̂ɛn ŋkere na, maa u cɛ̂ɛgɛ u jwumpe kurugo. ");
INSERT INTO spp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ka Yesu si yyahe kɛ̂ɛnŋ'a u cyelempyiibii wíi, maa Pyɛri faha: «Yîri na taan, Sitaanna wà we! Mu ɲyɛ na sɔ̂nŋi Kile ɲyii wuuni na mɛ, fo sùpyire ɲyii wuuni!» ");
INSERT INTO spp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Lire kàntugo ka Yesu si u cyelempyiibii ná shinɲyahara yyere, maa yi jwo pi á: «Ŋgemu la ká mpyi si ntaha mii fye e ke, urufol'à yaa u cyé u yabiliŋi ɲyii karigii na, u u ntɛ̀ɛn kyaage taan u u ntaha mii fye e, pi mɛ́ɛ ká mpyi na sí urufoo bò kworokworocige na. ");
INSERT INTO spp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ɲaha na yɛ ŋgemu la ká mpyi si u niɲjaaŋi yaa ɲwɔ ke, urufoo sì nùmpanŋa ta mɛ, ŋka ŋgemu ká kàntugo wà u niɲjaaŋ'á mii ná Jwumpe Nintanmpe kurugo ke, urufoo sí nùmpanŋa ta. ");
INSERT INTO spp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɲaha li sí ɲwɔ sùpyaŋ'á mà ma ɲyii yaayi puni ta ŋge diɲyɛŋi i niɲjaa, mu nùmpanŋke si sà ŋkɛ̀ɛge yɛ? ");
INSERT INTO spp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sùpya sì n‑jà yafyin tɛ̀gɛ u múnaani ɲùŋɔ wwû nùmpanŋa mɛ. ");
INSERT INTO spp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lire kurugo ŋgemu u na ɲcyíge Supyaŋi Jyaŋi ná u jwumpe na sùpyire ɲyii na, nte ti na kapegigii pyi maa kàntugo wà Kile á ke, Supyaŋi Jyaŋi ká bú mpa ná u Tuŋi sìnampe ná Kile mɛ̀lɛkɛɛbil'e canŋke ŋkemu i ke, u sí n‑cyé urufoo na. ");
INSERT INTO spp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sèeŋi na mii sí yi jwo yii á, yii mpii pi ɲyɛ naha ke, pìi na ɲyɛ yii e, pire sì n‑kwû ná pi ɲyɛ a Kile Saanre ɲya, ti i ma ná síŋi puni i mà yɛ.» ");
INSERT INTO spp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Canmpyaa baani kàntugo, ka Yesu si Pyɛri ná Yakuba ná Yuhana lwɔ́, maa ŋkàre ná pire kanni i ɲaŋke kà nintɔɔngɔ ɲuŋ'i. Mà pi yaha wani, Yesu pyiŋkann'à pa ŋkɛ̂ɛnŋɛ pi ɲyii na. ");
INSERT INTO spp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ka u vàanɲyi si mpâl'a fíniŋɛ fo na ɲî. Yi mpyi a fíniŋɛ fíniŋiŋkanni ndemu na ke, sùpya ɲyɛ ɲìŋke na ŋgemu u sì n‑jà yaaga pyi ku fíniŋɛ amuni mɛ. ");
INSERT INTO spp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kuru tanuge e, ka tèecyiini Kile tùnntunmpiiEli ná Musa si mpa Yesu cyelempyiibii mú taanre ɲyii na, mà pa a yu ná u e. ");
INSERT INTO spp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ka Pyɛri si Yesu pyi: «Wuu cyelentuŋi, wuu à pa naha ke, l'à ɲwɔ sèl'e. Wuu yaha wuu u vùnyɔ taanre kwòro, niŋkin sí n‑pyi mu wogo, niŋkin sí n‑pyi Musa wogo, niŋkin sí n‑pyi Eli wogo.» ");
INSERT INTO spp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pyɛri à puru jwumpe jwo uye ɲùŋɔ kurugo, ɲaha na yɛ u ná u shɛ̀rɛfeebii shuunniŋi mpyi a fyá a tòro. ");
INSERT INTO spp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mà pi yaha puru na, ɲahaŋa à tîge mà pi tò, ka mɛjwuu si fworo kuru ɲahaŋke e: «Mii Jyaŋi u ɲyɛ ŋge, u kan'à waha mii na sèl'e. Yii a núru u ɲwɔ na.» ");
INSERT INTO spp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ka Yesu cyelempyiibii si mpâl'a wíi wíl'a maha, pi saha ɲyɛ a sùpya ɲya mɛ, fo Yesu kanni. ");
INSERT INTO spp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mà pi yaha pi i ntîri ɲaŋke na, ka Yesu si yi jwo a waha pi á na nde pi à ɲya ke, na pi àha ŋkwɔ̀ li jwo sùpya á mɛ, fo Supyaŋi Jyaŋi ká ɲɛ̀ a fworo kwùŋi i. ");
INSERT INTO spp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ka u cyelempyiibii si puru jwumpe yaha piye funŋ'i, ŋka pi mpyi na piye yíbili: «Mà ɲɛ̀ a fworo kwùŋi i ɲwɔhe ku ɲyɛ ɲaha yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɲyɛ ka cyelempyiibii si u pyi: «Ko Kile Saliyaŋi cyelentiibii s'à jwo na Kile tùnntunŋi Eli u à yaa u fyânha a pa Kile Niɲcwɔnrɔŋi yyaha na.» ");
INSERT INTO spp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ka u u pi pyi: «Sèe wi, Eli à yaa u fyânha a pa si karigii puni kurigii tíi. Ŋka li mú à sémɛ Kile Jwumpe Semɛŋi i na “Supyaŋi Jyaŋi à yaa u kyaala sèl'e, sùpyire kuro mú sì mpyi u e mɛ.” Yii à sɔ̂nŋɔ lire na la? ");
INSERT INTO spp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mii sí yi jwo yii á, Eli à pa a kwɔ̀, pi à u pyi pi ɲyii pyiŋkanni na, bà l'à sémɛ u kyaa na Kile Jwumpe Semɛŋi i mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tèni i Yesu ná u cyelempyiibii taanreŋ'à nɔ pi sanmpii cyage e ke, pi à sà shinɲyahara ta t'à pi kwûulo, Kile Saliyaŋi cyelentiibii pìi mpyi a nàkaana ta ná pi e. ");
INSERT INTO spp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sùpyir'à pa Yesu ɲya ke, l'à pâa pi puni i sèl'e. Ka pi i fê a kàre u fye e maa u shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ka Yesu si u cyelempyiibii yíbe: «Ɲaha shi na yii ná pire na yiye kyáali yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ka wà si Yesu pyi tire sùpyire shwɔhɔl'e: «Cyelentuŋi, mii à pa ná na jyaŋi i mu yyére. Jínaŋi wà u ɲyɛ u e, ur'à u pyi búbu. ");
INSERT INTO spp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Uru jínaŋi ká yîri ná u e cyaga maha cyag'e ke, u maha u cyán ɲìŋke na, u maha ŋkyànhigii kùru, u ɲwɔge mú maha ŋkânŋi, fo u maha mpa shiile. Mii à mu cyelempyiibii ɲáare pi jínaŋi kɔ̀r'a yige u e, pi ɲyɛ a jà mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ka Yesu si jwo: «Ei! Yii dánabaa sùpyiibii nimpiibii, fo ɲaha tère e mii sí n‑kwôro ná yii e yɛ? Mii sí yii kapyiiŋkii kwú naye e sà nɔ fo ɲaha tère na yɛ? Yii a ma ná pyàŋi i na á.» ");
INSERT INTO spp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ka pi i mpa ná u e. Tèni i jínaŋ'à Yesu ɲya ke, ka u u pyàŋi cyán na kúu ŋkúu ɲìŋke na, maa u ɲwɔge pyi ku u ŋkânŋi. ");
INSERT INTO spp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ka Yesu si pyàŋi tuŋi yíbe: «Fo ɲaha tère e jínaŋ'à jyè u e yɛ?» Ka tufooŋi si u pyi: «Mà lwɔ́ fo u nimbilere wuŋi na. ");
INSERT INTO spp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tèni l'e, jínaŋi maha u cyán nage e, tèni l'e maa u cyán lwɔhe e si nta u bò. Kampyi mu sí n‑jà cyaga pyi, wuu ɲùɲaare ta, maa wuu tɛ̀gɛ.» ");
INSERT INTO spp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ka Yesu si u pyi: «Mu à jwo kampyi mii sí n‑jà cyaga pyi. Ŋka mu aha jà a dá mii na, karigii puni sí n‑jà n‑pyi mu á.» ");
INSERT INTO spp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ka pyàŋi tuŋi si ntíl'a jwo fànha na: «Mii à dá, ŋka na tɛ̀gɛ, ɲaha na yɛ mii dániyaŋi fành'à cyɛ́rɛ.» ");
INSERT INTO spp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu à sùpyire ɲya t'à lwɔ́ a tò u na ke, ka u u fànha cyán jínaŋi na, maa u pyi: «Jínaŋi, mu u na jyè sùpyire e marii pi pyi búbuu ná ɲùɲcunnii ke, fworo ŋge pyàŋi i, ma sàha núru ɲjyè u e mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka jínaŋi si kwuugo wà, maa pyàŋi cúnŋɔ cúnŋɔ fànha na, maa fworo u e. Pyàŋ'à pyi mu à jwo u à kwû, fo shinɲyahara à jwo u à kwû. ");
INSERT INTO spp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ka Yesu si u cû cyɛge na a yîrige, ka pyàŋi si yyére. ");
INSERT INTO spp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu à jyè bage e ke, ka u cyelempyiibii si u ŋwɔh'a yíbe: «Ɲaha na wuu ɲyɛ a jà a ŋge jínaŋi kɔ̀r'a yige pyàŋi i mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ka Yesu si pi pyi: «Kileɲarege kanni ku ɲyɛ na jìn'a ŋge jínaŋi shiŋi kɔ̀r'a yige sùpya e.» ");
INSERT INTO spp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu ná u cyelempyiibii niŋkaribil'à Galile kùluni jyiile, ŋka u la ɲyɛ a mpyi sùpya si li cè mɛ, ");
INSERT INTO spp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ɲaha na yɛ u mpyi na u cyelempyiibii kâlali, marii yu pi á: «Pi sí n‑pa Supyaŋi Jyaŋi le sùpyire cye e pi bò, ŋka u kwùŋi canmpyitanrewuuni, u sí ɲɛ̀.» ");
INSERT INTO spp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pi ɲyɛ a pyi a puru jwumpe ɲwɔhe cè mɛ, fyagare s'à pi sige pi ɲyɛ a jà a u yíbe mɛ. ");
INSERT INTO spp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ka Yesu ná u cyelempyiibii si nɔ Kapɛrɛnamu kànhe e. Tèni i pi a jyè bage e ke, ka u u pi yíbe: «Ɲaha nàkaana yii mpyi a ta kuni na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ka pi i fyâha, ɲaha na yɛ nàkaante ɲùŋke ku mpyi na pire puni i, jofoo u ɲyɛ ɲùŋufooŋi yɛ. ");
INSERT INTO spp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ka Yesu si ntɛ̀ɛn, maa pi shiin kɛ ná shuunniŋi yyere, maa yi jwo pi á: «Ŋgemu la ká mpyi si mpyi ɲùŋufoo ke, urufol'à yaa u uye pyi kàntugo yyére wuŋi, u raa báare pi sanmpil'á.» ");
INSERT INTO spp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ka Yesu si pyàŋi wà cû a pa pi shwɔhɔl'e, maa u lwɔ́, maa yi jwo pi á na: ");
INSERT INTO spp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Shin maha shin u à ɲɛn'a ŋge pyàŋi fiige cùmu lemɛ ɲwɔ mii kurugo ke, urufol'à mii cùmɔ lemɛ ɲwɔ mú. Shin maha shin sí u à mii cùmɔ lemɛ ɲwɔ ke, urufoo mú à mii tunvooŋi cùmɔ lemɛ ɲwɔ.» ");
INSERT INTO spp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ka Yuhana si yi jwo Yesu á: «Cyelentuŋi, wuu à nàŋi wà ɲya u u jínabii kɔ̀re na yige sùpyire e ná mu mɛge e, ka wuu u u sige li na, ɲaha na yɛ wuu wà bà mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ka Yesu si u pyi: «Yii àha u sige li na mɛ, sùpya sì n‑jà raa kakyanhala pyi ná mii mɛge e, si ntíi núru mii mɛge kɛ̀ɛge ntaha lire na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ŋgemu u ɲyɛ u ɲyɛ wuu zàmpɛn mɛ, urufoo na ɲyɛ ná wuu e. ");
INSERT INTO spp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amuni li mú ɲyɛ shin maha shin u à fùnɲcwokwuɲyaga lwɔhɔ kan yii á mà lire ɲùŋke pyi na yii na ɲyɛ Kile Niɲcwɔnrɔŋi wuu ke, sèeŋi na mii sí yi jwo yii á, urufoo sí n‑sìi lire tɔ̀ɔnŋi ta.» ");
INSERT INTO spp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ka Yesu si núr'a pi pyi: «Nte nàŋkopyire t'à dá mii na mà kwɔ̀ ke, shin maha shin ká lire là niŋkin ɲùŋɔ kyán, l'à pwɔ́rɔ urufol'á pi kafaabwɔhɔ pwɔ u yacige e, pi i u wà baŋi i. ");
INSERT INTO spp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mu cyɛge kà niŋkin ká a si mu pyi mu u kapii pyi, ku kwɔ̀n a wà, maa jyè ná ku sanŋke e shìŋi niŋkwombaaŋi i. Lir'à pwɔ́rɔ mu á, mu ná ma cyeyi shuunniŋi u jyè nafugombaage e.  ");
INSERT INTO spp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","“Fyɛɛnre ti maha sùpyire kyaare lyî kuru cyage e ke, tire ɲyɛ na ŋkwûu mɛ, kuru cyage nage mú ɲyɛ na fùru mɛ.” ");
INSERT INTO spp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mu tɔɔge kà niŋkin ká a si mu pyi mu u kapii pyi, ku kwɔ̀n a wà, maa jyè shìŋi niŋkwombaaŋi i ná tɔɔgɔ niŋkin i. Lir'à pwɔ́rɔ mu á, mu ná ma tooyi shuunniŋi u jyè nafugombaage e.  ");
INSERT INTO spp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","“Fyɛɛnre ti maha sùpyire kyaare lyî kuru cyage e ke, tire ɲyɛ na ŋkwûu mɛ, kuru cyage nage mú ɲyɛ na fùru mɛ.” ");
INSERT INTO spp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mu ɲyiini là ká a si mu pyi mu u kapii pyi, li wwûl'a wà, mu ɲyii niŋkin wuŋi u jyè Kile Saanre e. Lir'à pwɔ́rɔ mu á, mu ná ma ɲyiigii shuunniŋi u jyè nafugombaage e. ");
INSERT INTO spp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“Fyɛɛnre ti maha sùpyire kyaare lyî kuru cyage e ke, tire ɲyɛ na ŋkwûu mɛ, kuru cyage nage mú ɲyɛ na fùru mɛ.” ");
INSERT INTO spp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","50","Kyaage k'à ɲáaŋa nage fiige ke, kuru kyaage Kile sí n‑tɛ̀gɛ u shiinbii toroŋkanni kɛ̂ɛnŋɛ. Suump'à táan, suumpe tìpoompe ká fworo p'e, ɲaha ku sí n‑jà pu pyi pu táan sahaŋki yɛ? Yii pyi suumɔ niɲcɛnmɛ, yyeɲiŋke ku pyi yii shwɔhɔl'e.» ");
INSERT INTO spp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ná u cyelempyiibil'à kàre Zhude kùluni i, Zhurudɛn baŋi kàntugo. Wani sahaŋki, ka sùpyire si mpa bínni u taan. Ka u u núr'a cye le u kapyiɲjyeeni i, na ti kâlali. ");
INSERT INTO spp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ka Farizhɛɛnbii pìi si file u na, si u pɛrɛ ɲcû ná jwumpe e, maa u yíbe: «Mà tàanna ná Kile Jwumpe Semɛŋi i, nɔ̀ sí n‑jà u cwoŋi yaha la?» ");
INSERT INTO spp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ka Yesu si pi pyi: «Ɲaha Kile tùnntunŋiMusa à sémɛ lire nde kyaa na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ka pi i u pyi: «Musa à jwo na mu aha ceeŋi nàmbage kwɔ̀kwɔ sémɛŋi kan u á, na mu sí n‑jà u yaha.» ");
INSERT INTO spp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ka Yesu si pi pyi: «Yii ɲjíŋgage kurugo, lir'à sémɛ toŋi i mà kan yii á. ");
INSERT INTO spp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ŋka mà lwɔ́ diɲyɛ tasiige e, Kile à “sùpyaŋi yaa nɔ̀ ná ceewe.” ");
INSERT INTO spp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","“Lire kurugo nɔ̀ŋi sí u tuŋi ná u nuŋi yaha si mpwɔ u cwoŋi na, pi mú shuunni si mpyi shin niŋkin.” Lire e, pi saha sì n‑pyi shiin shuunni mɛ, ŋka pi sí n‑pyi shin niŋkin. ");
INSERT INTO spp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lire kurugo Kile à mpiimu pyi niŋkin ke, sùpya ɲyɛ a yaa u pire láha piye na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tèni i pi à núr'a jyè bage e ke, ka Yesu cyelempyiibii si núr'a u yíbe cyire karigii kyaa na. ");
INSERT INTO spp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ka Yesu si pi pyi: «Shin maha shin u à u cwoŋi yaha maa ceeŋi wabɛrɛ lèŋɛ ke, urufol'à jacwɔrɔ pyi mà yyaha tíi ná ceeŋi niɲcyiiŋi i. ");
INSERT INTO spp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ceewe mú ká nàmbaga fworo, maa nàmbaga lèŋɛ nɔ̀ŋi wabɛr'á, uru ceeŋi mú à jacwɔrɔ pyi.» ");
INSERT INTO spp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɲyɛ lire kàntugo, sùpyiibii pìl'à pa ná nàŋkopyire t'e Yesu yyére, bà u si mpyi si u cyeyi taha ti na, si jwó le t'á mɛ. Ka cyelempyiibii si pi faha. ");
INSERT INTO spp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu à lire ɲya ke, ka li i mpɛn u e, ka u u jwo u cyelempyiibil'á: «Yii nàŋkopyire yaha t'a ma mii yyére, yii àha ti sige mɛ, ɲaha na yɛ sùpyiibii pi ɲyɛ nàŋkopyire fiige ke, Kile Saanre ɲyɛ pire woro. ");
INSERT INTO spp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sèeŋi na mii sí yi jwo yii á, ŋgemu ká mpyi u ɲyɛ a ɲɛn'a uye tîrige pyà fiige mɛ, urufoo sì n‑sìi n‑jà n‑jyè Kile Saanre e mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ka u u nàŋkopyire cû a ta uye na, maa jwó le t'á. ");
INSERT INTO spp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ɲcyii karigii puni kàntugo, Yesu ná u cyelempyiibil'à kuni lwɔ́ sahaŋki. Mà pi yaha pi i ŋkɛ̀ɛge, nàŋi wà à fê a sà niŋkure sín Yesu taan, maa jwo: «Cyelentuŋi niɲcɛnŋi, ɲaha shi mii à yaa mii u pyi si shìŋi niŋkwombaaŋi ta bɛ?» ");
INSERT INTO spp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ka Yesu si u pyi: «Mu à jwo na mii à ɲwɔ wa? Kile kanni baare e, sùpya ɲyɛ a ɲwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mu à Kile toŋi kurigii cè mà kwɔ̀ “Ma hà sùpya bò mɛ, ma hà zínni ná wabɛrɛ cwo e mɛ, ma hà nàŋkaaga pyi mɛ, ma hà vini ntaha wà na mɛ, ma hà ɲcwu sùpya na mɛ, ma tuŋi ná ma nuŋi pêe.”» ");
INSERT INTO spp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ka nàŋi si Yesu pyi: «Cyelentuŋi, mii na cyire karigii puni pyi fo mà mii yaha nàŋkocyɛɛre e.» ");
INSERT INTO spp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ka Yesu si u wíi, maa u kyaa táan uy'á, maa u pyi: «Yaaga niŋkin k'à mu fô, ta sì, maa sà ma cyeyaayi puni pɛ́rɛ, maa uru wyɛ́rɛŋi kan fòŋɔfeebil'á. Lire ká mpyi, mu sí nàfuu ta Kile yyére. Maa nta a pa ntaha na fye e.» ");
INSERT INTO spp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Puru jwumpe ɲyɛ a u táan mɛ, ka u yyetanha wuŋi si ŋkàre, ɲaha na yɛ nàfuubwɔhɔ foo u mpyi u wi. ");
INSERT INTO spp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Lir'à pyi ke, ka Yesu si yyahe kɛ̂ɛnŋɛ, maa sùpyire wíi wíi, maa yi jwo u cyelempyiibil'á: «Nàfuufooŋi jyìm'à pɛn Kile Saanre e.» ");
INSERT INTO spp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lire ɲwɔmɛɛn'à Yesu cyelempyiibii funŋɔ wwòoŋɔ, ka u u núr'a pi pyi: «Mii pyìibii, li pyim'à sàa pɛn, wà u jyè Kile Saanre e. ");
INSERT INTO spp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɲwɔhɔŋi jyìm'à táan músɛnnɛŋi wyiini i mà tòro nàfuufooŋi u jyè Kile Saanre e.» ");
INSERT INTO spp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ka puru sí nâara a u cyelempyiibii kàkyanhala fo mà tòro, ka pi i wá na yu piy'á: «Lire sanni i ke, jofoo u sí n‑jà nùmpanŋa ta bɛ?» ");
INSERT INTO spp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ka Yesu si pi wíi wíi, maa jwo: «Lir'à sùpyire jà, ŋka kyaa ɲyɛ na Kile jìni mɛ, ɲaha kurugo yɛ karigii puni síŋi ɲyɛ u á.» ");
INSERT INTO spp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ka Pyɛri si jwumpe lwɔ́ maa u pyi: «Wuu de? Wuu à kàntugo wà wuu karigii puni na, maa ntaha mu fye e.» ");
INSERT INTO spp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ka Yesu si pi pyi: «Sèeŋi na mii sí yi jwo yii á, shin maha shin ká ɲɛn'a kàntugo wà u bayi, lire ɲyɛ mɛ u sìɲɛɛbii, lire ɲyɛ mɛ u sifeebii, lire ɲyɛ mɛ u pyìibii, lire ɲyɛ mɛ u kɛrɛy'á, mii ná Jwumpe Nintanmpe kurugo ke, ");
INSERT INTO spp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","urufoo sí yire yaayi fiige ŋkuu (100) ta naha ŋge diɲyɛŋi i. Urufoo sí baya ná sìɲɛɛ ná nɛɛ ná pyìi ná kɛrɛyɛ ta, ŋka sùpyire mú sí urufoo yyaha fwɔ́hɔrɔ mii mɛge ná Jwumpe Nintanmpe kurugo. Diɲyɛŋi nimpaŋi i, urufoo sí shìŋi niŋkwombaaŋi ta. ");
INSERT INTO spp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ŋka yyaha yyére shiin niɲyahamii sí n‑pyi kàntugo yyére shiin, kàntugo yyére wuu niɲyahamii mú sí n‑pyi yyaha yyére wuu.» ");
INSERT INTO spp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ná u fyèɲwɔhɔshiinbii mpyi kuni i na ŋkɛ̀ɛge Zheruzalɛmu kànhe e, uru u mpyi yyaha na. Ŋka pi fyagara wuu pi mpyi a taha u fye e. Ka u u núr'a u cyelempyiibii kɛ ná shuunniŋi yyer'a file uye na, karigii cyi sí u le ke, maa jyè cyire yyahe e na yu pi á. ");
INSERT INTO spp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Maa jwo: «Wuu niŋkaribii pi mpii Zheruzalɛmu kànhe e, Supyaŋi Jyaŋi sí n‑le Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii cye e. Pire sí n‑jwo na u à yaa u bò, si u kan Kilecembaabil'á. ");
INSERT INTO spp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pire sí u fwɔ́hɔrɔ, si ntilwɔhe wà u na, si u bwɔ̀n ná kàsɔrigil'e, si u bò. Ŋka u kwùŋi canmpyitanrewuuni u sí ɲɛ̀.» ");
INSERT INTO spp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Lire kàntugo ka Zebede jyaabii Yakuba ná Yuhana si file Yesu na, maa u pyi: «Wuu cyelentuŋi, nde wuu sí n‑pa n‑cya mu á ke, lire pyi wuu á.» ");
INSERT INTO spp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ka Yesu si pi yíbe: «Ɲaha yii la ɲyɛ mii u pyi yii á yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ka pi i u pyi: «Mu aha mpa mpyi ma Saanre pèente e tèni ndemu i ke, ma a wuu wà niŋkin yaha ma kàniŋke na, ma a u sanŋi yaha kàmɛni na.» ");
INSERT INTO spp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ka Yesu si pi pyi: «Yaage yii na ɲáare mii á ke, yii ɲyɛ a ku shi cè mɛ. Kyaage lwɔhe mii sí n‑bya ke, yii sí n‑jà kuru bya la? Kyaage e mii sí mbyîgimɛ ke, yii sí n‑jà mbyîgimɛ kur'e mii fiige la?» ");
INSERT INTO spp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ka pi i u pyi: «Ɔɔn, wuu sí n‑jà.» Ka u u pi pyi: «Yii sí kyaage lwɔhe bya, sí mbyîgimɛ kyaage e mii fiige. ");
INSERT INTO spp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ŋka mà tɛ̀ɛn mii kàniŋke ná mii kàmɛni na, mii bà u ɲyɛ yire kanvooŋi mɛ. Kile à yire tatɛɛnyi bégele sùpyire ntemu mɛɛ na ke, u sí yire kan pir'á.» ");
INSERT INTO spp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ɲyɛ Yesu cyelempyiibii kɛŋi sanŋ'à puru lógo ke, ka pire lùgigii si yîri Yakuba ná Yuhana taan. ");
INSERT INTO spp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu à pa kuru cyage wíl'a ɲya ke, maa jwo u cyelempyiibii pun'á: «Yii a núru, yii à cè naha ɲìŋke na, mpii pi à yaha kìni ɲùŋufeebii ke, pire maha ntɛ̀ɛn kìni sùpyire ɲuŋ'i fànhe e, kìni shinbwoobil'a sì wá na pi fànhe cyáan kìni sùpyire na. ");
INSERT INTO spp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ŋka li ɲyɛ a yaa li pyi amuni yii shwɔhɔl'e mɛ. Ŋgemu la ku ɲyɛ si mpyi shinbwo yii shwɔhɔl'e ke, urufol'à yaa u uye pyi yii sanmpii báarapyi. ");
INSERT INTO spp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ŋgemu la ku ɲyɛ si mpyi yii yyaha yyére shinŋi ke, urufoo u pyi pi sanmpii puni biliwe. ");
INSERT INTO spp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ɲaha kurugo yɛ Supyaŋi Jyaŋi ɲyɛ a pa diɲyɛŋi i sùpyire si mpa mpyi u báarapyii mɛ. U à pa si mpa uye pyi sùpyire puni báarapyi, si uye kan pi bò, si mpyi shinɲyahara kapegii shwɔshwɔ lwɔrɔ.» ");
INSERT INTO spp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ka Yesu ná u cyelempyiibii si nɔ Zheriko kànhe na. Pi nivworobii kànhe e, shinɲyahara na mpyi pi fye e, pi à Timɛ jyaŋi Baritimɛ fyin wuŋi ta u à tɛ̀ɛn kuni ɲwɔge na, na ɲáare. ");
INSERT INTO spp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","U à lógo na Nazarɛti kànhe shinŋi Yesu u wá na ntùuli ke, ka u u wá na yu fànha na: «Yesu, Dawuda Tuluge Shinŋi, ɲùɲaara ta na na!» ");
INSERT INTO spp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ka shinɲyahara si u faha na u fyâha. Ŋka u ɲyɛ a ɲɛn'a fyâha mɛ, maa là bâra sɛ̀ɛge na: «Dawuda Tuluge Shinŋi, ɲùɲaara ta na na!» ");
INSERT INTO spp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ka Yesu si yyére maa jwo: «Yii u yyere.» Ka pi i sà u yyere, maa u pyi: «Funŋke ɲíŋɛ, ma a yákiliŋi tìŋɛ, Yesu na mu yiri. Yîri, ma a ma.» ");
INSERT INTO spp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Fyinŋ'à puru lógo ke, maa u vàanntinŋke wwûl'a wà ɲìŋke na, maa búrug'a yîri na ŋkɛ̀ɛge Yesu yyére. ");
INSERT INTO spp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","U à nɔ u taan ke, ka Yesu si u yíbe: «Ɲaha mu la ɲyɛ mii u pyi mu á yɛ?» Ka fyinŋi si u pyi: «Cyelentuŋi, mii la ɲyɛ si núru s'a ɲaa.» ");
INSERT INTO spp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ka Yesu si u pyi: «Ta sì, mu dániyaŋ'à mu cùuŋɔ.» Ka u ɲyiigii si ntíl'a múgo, ka u u ntaha Yesu fye e. ");
INSERT INTO spp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mà pi yaha pi i byanhare Zheruzalɛmu kànhe na, pi mpyi a nɔ Olivye cire ɲaŋke ŋkere na, Bɛtifajye ná Bɛtani kànyi taan. Ka Yesu si u cyelempyiibii pìi shuunni tun, ");
INSERT INTO spp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","maa pi pyi: «Kànhe ku ɲyɛ yii yyaha na ke, yii a sì k'e. Yii aha nɔ wani, yii sí n‑tíi dùfaanɲjaaga ta k'à pwɔ, sùpya sàha ŋkwɔ̀ a dùgo ku na mà ɲya mɛ. Yii i ku sànha, yii pa ŋkan na á. ");
INSERT INTO spp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wà ha bú yii yíbe na “Ɲaha na yii ɲyɛ na ku sànre yɛ?” yii urufoo pyi na “Ku kyaa li ɲyɛ Kafooŋi na. U aha ŋkwɔ̀ ku na, ku sí n‑pa.”» ");
INSERT INTO spp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ɲyɛ ka cyelempyiibii mú shuunni si ŋkàr'a sà dùfaanɲjaage ta k'à pwɔ pyɛnge ɲwɔge na, kuni taan. Ka pi i wá na ku sànre. ");
INSERT INTO spp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Sùpyire ti mpyi wani ke, ka tire tà si cyelempyiibii pyi: «Hɛn! Ɲaha yii na mpyi amɛ yɛ? Ɲaha kurugo yii ɲyɛ na dùfaanŋke sànre yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ka cyelempyiibii si pi ɲwɔ shwɔ bà Yesu mpyi a yi jwo pi á mɛ. Ka tire sùpyire si dùfaanŋke yaha pi cye e na pi a sì ná k'e. ");
INSERT INTO spp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Cyelempyiibil'à pa ná dùfaanŋke e Yesu yyére ke, maa pi vàanɲyi yà taha ku na, ka Yesu si dùg'a tɛ̀ɛn na ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ka shinɲyahara si ti vàanntinɲyi yà wwû mà pìli pìli Yesu yyaha na kuni i, ka niɲyahara si jyè kɛrɛyi i na wyɛɛre kwùun na ɲcyáan kuni i. ");
INSERT INTO spp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sùpyire ti mpyi Yesu yyaha na, ná nte ti mpyi u kàntugo ke, tire puni mpyi na ŋkwúuli na: «Yabwɔhe! Ŋgemu u ɲyɛ na ma Kafooŋi Kile mɛge na ke, Kile u jwó le u á! ");
INSERT INTO spp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yabwɔhe! Yabwɔhe! Saanre ti ɲyɛ na ma ke, Kile u jwó le t'á. Wuu tulyage Dawuda Saanre ti. Pèente ti taha Kile na nìɲyicyeyi puni i!» ");
INSERT INTO spp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu à nɔ Zheruzalɛmu i ke, maa ŋkàre Kileɲaarebage e. U à yaayi puni wíi wíi ke, maa fwor'a kàre Bɛtani kànhe e ná u cyelempyiibii kɛ ná shuunniŋi i, ɲaha na yɛ numpilage mpyi na wwùu. ");
INSERT INTO spp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kuru canŋa nùmpanŋa, pi niɲjiribii Bɛtani i, ka katege si Yesu ta. ");
INSERT INTO spp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ka u u fizhiye cige kà ɲya tatɔɔnge e ná wyɛɛre e, maa file ku na a wíi, kampyi u sí yasɛrɛ ta ku na. Ŋka u à nɔ ku ɲwɔh'i ke, u ɲyɛ a yasɛrɛ ta k'e fo wyɛɛre bà mɛ, ɲaha na yɛ ku tèeseni mpyi sàha ŋkwɔ̀ a nɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ka Yesu si jwo cig'á: «Sùpya saha sì n‑sìi yasɛrɛ ta mu na, si ɲjyî mɛ.» Ka u cyelempyiibii si puru jwumpe lógo. ");
INSERT INTO spp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kàntugo, Yesu ná u cyelempyiibil'à nɔ Zheruzalɛmu kànhe e, ka u u ŋkàre Kileɲaarebage ntàani na. Mpii pi mpyi na pɛrɛmpe ná zhwoŋi pyi wani ke, maa pire kɔ̀re, maa wyɛ́rɛfaabii tàbalibii ná sanmpanmpɛrɛbii yatɛɛnɲyi ŋɔɔŋ'a cyán cyán. ");
INSERT INTO spp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","U ɲyɛ a ɲɛɛ sùpya u à jyè ná yapɛrɛŋi i Kileɲaarebage ntàani na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Puru ɲwɔhɔ na, ka u u wá na pi puni kâlali, marii ŋko: «“Mii bage sí n‑pa a yiri Kileɲaarebaga supyishiŋi pun'á.” Yire y'à sémɛ Kile Jwumpe Semɛŋi i. Ŋka yii pi ke, yii à ku kɛ̂ɛnŋ'a pyi “nàŋkaalii tabinniga”.» ");
INSERT INTO spp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibil'à puru lógo ke, ka pi i wá na Yesu boŋkanni caa. Pi mpyi na fyáge u na, ɲaha na yɛ u kàlaŋi mpyi a tatɛɛngɛ wwû shinɲyahar'e. ");
INSERT INTO spp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yàkoŋk'à nɔ ke, ka Yesu ná u cyelempyiibii si fworo kànhe e. ");
INSERT INTO spp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kuru canŋke nùmpanŋa ɲyɛ̀ge na, pi nintorobil'à fizhiye cige ɲya k'à waha fo ndìre e. ");
INSERT INTO spp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ka Pyɛri funŋɔ si ɲcwo Yesu jwumpe niɲjwumpe na, maa u pyi: «Wuu cyelentuŋi, wíi, fizhiye cige mu à láŋa taɲjaa ke, ku naha a waha.» ");
INSERT INTO spp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ka Yesu si u pyi: «Yii dá Kile na. ");
INSERT INTO spp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sèeŋi na mii sí yi jwo yii á, sùpya ká dá Kile na ná u zòmbilini puni i, urufoo ká jwo na ŋke ɲaŋke ku yîri ku tatɛɛnge e, ku sà ɲcwo baŋi i, urufoo ká nta u à dá li na, nde u à jwo ke, lire sí n‑pyi. ");
INSERT INTO spp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lire kurugo mii sí yi jwo yii á, yii aha Kile ɲáare yaaga maha yaaga kurugo ke, yii dá li na na yii à kuru yaage ta a kwɔ̀, lire ká mpyi, Kile sí kuru yaage kan yii á. ");
INSERT INTO spp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ŋka yii aha yîr'a yyére na Kile ɲáare, ka li i ntîge yii funŋ'i na yii à tîge shin na, yii tire tìgire kwɔ̀, bà yii Tuŋi u ɲyɛ nìɲyiŋi na ke, uru mú sí n‑pyi si yii kapegigii yàfa yii na mɛ.  ");
INSERT INTO spp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ɲaha na yɛ yii aha mpyi yii ɲyɛ na yiye shwɔ̀hɔlɔ wogigii yàfani yiye na mɛ, yii Tuŋi Kile u ɲyɛ nìɲyiŋi na ke, uru sì n‑pa yii kapegigii yàfa yii na mú mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu ná u cyelempyiibil'à núr'a kàre Zheruzalɛmu kànhe e, maa sà jyè Kileɲaarebage e. Yesu niɲaraŋi ku funŋke e, Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii ná Yahutuubii kacwɔnribil'à kàre u yyére. ");
INSERT INTO spp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Maa u yíbe: «Ná kuni ndire e mu na ɲcyii karigii pyi yɛ? Jofoo u à kuni kan mu á, mu u a cyi pyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ka Yesu si pi pyi: «Mii mú sí yii yíbe kyaa niŋkin na, yii aha mii ɲwɔ shwɔ, lire tèni i ŋge u à kuni kan mii á mii u a ɲcyii karigii pyi ke, mii sí urufoo cyêe yii na. ");
INSERT INTO spp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mii à jwo yo, jofoo u mpyi a Yuhana Batizelipyiŋi tun u pa a sùpyire batizeli yɛ? Kile wi laa, sùpyire ti? Yii na ɲwɔ shwɔ!» ");
INSERT INTO spp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ɲyɛ ka pi i ŋkàr'a sà piye taanna maa jwo: «Wuu aha jwo na Kile u mpyi a Yuhana tun, u sí n‑jwo na ɲaha na wuu sí ɲyɛ a ɲɛn'a dá u na mà yɛ? ");
INSERT INTO spp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ŋka wuu mú sì n‑jà n‑jwo na sùpya u à u tun mà dɛ!» Pi mpyi a fyá sùpyire na, ɲaha na yɛ tire sùpyire puni mpyi na sɔ̂nŋi na Yuhana na mpyi a sìi Kile tùnntunŋɔ. ");
INSERT INTO spp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pi à piye taanna a kwɔ̀ ke, maa núr'a kàr'a sà Yesu pyi: «Shinŋi u mpyi a u tun ke, wuu ɲyɛ a cè mɛ.» Ka Yesu si pi pyi: «Ɲyɛ l'aha mpyi amuni, ŋge u à kuni kan mii á, mii u a ɲcyii karigii pyi ke, mii mú sì uru cyêe yii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lire kàntugo Yesu à bàtaaga jwo sùpyir'á. U à jwo: «Nàŋi wà u ná ɛrɛzɛn cikɔɔgɔ yaa, maa ku kwûulo, ɛrɛzɛn lwɔhe maha wwû wyige ŋkemu i ke, maa kuru tùgo, maa ŋkubaga yaa cikɔɔge kàanmucyafooŋi mɛɛ na. Lire kàntugo maa faafee lwɔ́ a yaha k'e, u ná pire s'a ku yasɛɛre táali, maa nta a kàre kùlutɔɔnl'e. ");
INSERT INTO spp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ɲyɛ ɛrɛzɛnŋi yasɛɛre tèekwɔɔnn'à pa nɔ ke, ka u u u báarapyiŋi wà tun cikɔɔge faafeebil'á u sà uru nàzhan ɛrɛzɛnŋi shwɔ u a ma. ");
INSERT INTO spp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ŋka uru tùnntunŋ'à nɔ pi na ke, ka pi i u cû maa u bwɔ̀n, maa u cyeŋgayi wuŋi kɔ̀r'a tùugo. ");
INSERT INTO spp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ka cikɔɔge foo si núr'a báarapyi shɔnwu tun, ka pi i uru bwɔ̀n ɲùŋke e, maa u cyahala sèl'e. ");
INSERT INTO spp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ka u u shin tanrewu tun, ka pi i uru cû a bò. Puru ɲwɔhɔ na, u à shinɲyahara tun, ka pi i pìi bwɔ̀n maa pìi bò. ");
INSERT INTO spp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","U tùnntunmpil'e, shin niŋkin kanna u mpyi tunmbaa, u jyasege ku mpyi kure, u kyaa mpyi a táan u á sèl'e. Ka u u ŋkànha a uru tun pi á, maa jwo “Pi sí n‑sílege mii jyaŋi na.” ");
INSERT INTO spp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ŋka jyafooŋ'à nɔ wani ke, ka pi i yi jwo piy'á na: “Cikɔɔge foo koolyiŋi u ɲyɛ ŋge. Yii a wá, wuu u bò, kɔɔge sí n‑pyi wuu wogo.” ");
INSERT INTO spp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ka pi i u cû maa u bò, maa u wà cikɔɔge kàntugo yyére. ");
INSERT INTO spp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ɲyɛ ɲaha cikɔɔge foo sí n‑pyi yɛ? Nàkaana baa, u sí n‑pa mpii faafeebii bò si u cikɔɔge le piibɛrɛ cye e. ");
INSERT INTO spp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ɲje y'à sémɛ Kile Jwumpe Semɛŋi i ke, taha yii ɲyɛ a yire kâla mɛ? Y'à sémɛ “Bafaanribil'à cyé kafaage ŋkemu na ke, kuru k'à pa mpyi bage kafaage sèe woge bage mbìini na. ");
INSERT INTO spp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kafooŋi Kile u à lire pyi, l'à pyi kakyanhala wuu ɲyii na”.» ");
INSERT INTO spp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ɲyɛ Yesu à puru jwumpe jwo amuni ke, ka Yahutuubii ɲùŋufeebii si wá na u caa si u cû, ɲaha na yɛ pi mpyi a cè na u à ŋke bàtaage jwo a wà pire na. Ŋka supyiɲyahara na mpyi wani kuru cyage e, ka pi i fyá tire na, maa Yesu yaha u a kàre. ");
INSERT INTO spp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lire kàntugo Yahutuubii ɲùŋufeebil'à Farizhɛɛnbii pìi ná Erɔdi toŋkuni shiinbii pìi yaha a kàre Yesu yyére, bà pi si mpyi si u ta ɲcû u ɲwɔmɛɛni kurugo mɛ. ");
INSERT INTO spp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ka pire si sà Yesu pyi: «Wuu cyelentuŋi, wuu à li cè na mu ɲyɛ na fyáge sèeŋi tajwuge e mɛ, mu ɲyɛ na fyáge sùpya na mɛ, mu ɲyɛ a sùpya pwɔ́ɔŋɔ sùpya na mɛ, mu na sùpyire kâlali ná sèeŋi i Kile kuni ɲaaraŋkanni na. Lire na, wuu la ɲyɛ si mu yíbe, wuu à yaa wuu a múnalwɔɔre kaan Ɔrɔmu saanbwɔhe Sezari á la? ");
INSERT INTO spp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ɲaha mu na sɔ̂nŋi yɛ?» Ŋka Yesu mpyi a cè na pi à fyìnmɛ tò wwomɔ na, maa pi pyi: «Ɲaha na yii na mii pɛre si ɲcû yɛ? Yii wyɛ́rɛbile kan na á, si li wíi.» ");
INSERT INTO spp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ka pi i mpa ná l'e, ka u u pi yíbe: «Jofoo nàɲja ná u mɛgɛ ku ɲyɛ ŋge wyɛ́rɛŋi na yɛ?» Ka pi i jwo: «Saanbwɔhe Sezari». ");
INSERT INTO spp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ka u u pi pyi: «Yii a Sezari wuŋi kaan Sezari á, yii raa Kile wuŋi kaan Kile á.» Ka puru jwumpe si pi puni pâa. ");
INSERT INTO spp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɲyɛ Sadusiibii pi maha jwo na kwuɲɛnɛ ɲyɛ nùmpanŋa mɛ, pire pìl'à file Yesu na maa u yíbe: ");
INSERT INTO spp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Wuu cyelentuŋi, Kile tùnntunŋiMusa à mpe jwumpe sémɛ wuu Saliyaŋi i na “Nɔ̀ ká ceewe lèŋɛ, maa ŋkwû, mà u ta u ɲyɛ a pyà ta ceeŋi na mɛ, u cɔɔnŋ'à yaa u ceeŋi lèŋɛ zànbangara na, u u pyìi si u na, u yyahafooŋi niŋkwuŋi mɛge na.” ");
INSERT INTO spp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ɲyɛ sìɲɛɛ baashuunni na mpyi wani, pi puni niɲjyeŋi mpyi a ceewe lèŋɛ maa ŋkwû, u ɲyɛ a pyà ta u na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ka sìɲɛɛŋi shɔnwuŋi si ceeŋi lwɔ́ maa ŋkwû, u ɲyɛ a pyà ta u na mɛ. Ka tanrewuŋi wuuni si mpyi amuni. ");
INSERT INTO spp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ka pire nàmbaabii baashuunniŋi puni si ceeŋi lèŋɛ mà taha taha piye na, ŋka pi wà ɲyɛ a pyà ta u na mɛ. Pire puni kàntugo, ka ceeŋi mú si mpa ŋkwû. ");
INSERT INTO spp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ɲyɛ ná pire nàmbaa baashuunniŋi puni s'à uru ceeŋi lèŋ'a círi, kwùubii ɲɛ̀ŋi ká bú nta sèe, pi aha bú ɲɛ̀ canŋke ŋkemu i ke, pi ŋgir'á, ceeŋi sí n‑kan yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ka Yesu si pi pyi: «Yii à wurugo sùpyire ɲɛ̀ŋi kyaa na, lir'à ta yii ɲyɛ a Kile Jwumpe Semɛŋi yyaha cè, si nta ɲjyére Kile sífente na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yii li cè, Kile yyére, sùpyire ká ɲɛ̀ a fworo kwùŋi i, nɔ̀ sì ceewe lèŋɛ mɛ, ceewe mú sì n‑kan nɔ̀ á mɛ. Ti sí n‑pyi Kile mɛ̀lɛkɛɛbii fiige. ");
INSERT INTO spp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ɲje Kile tùnntunŋi Musa à sémɛ kwuɲɛni kyaa na ke, yii ɲyɛ a yire kâla mà? Kuru cyage e, l'à sémɛ na Kile à jwo ná Musa e tahe nage woge taan na “Mii u ɲyɛ Ibirayima, ná Ishaka, ná Yakuba u Kileŋi.” ");
INSERT INTO spp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɲyɛ puru jwump'à li cyêe na pire mpii ɲyii wuu pi ɲyɛ wani Kile yyére. Sùpyire ɲyii woore ti maha Kile pêre, kwùubii kyaa bà mɛ. Yii na sɔ̂nŋi na sùpyire sì ɲɛ̀ n‑fworo kwùŋi i mɛ, kuru cyage e yii à sàa wurugo.» ");
INSERT INTO spp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kile Saliyaŋi cyelentuŋi wà à Yesu ná nte sùpyire jwumpe lógo, maa li ɲya na Yesu à pi ɲwɔ shwɔ a ɲwɔ ke, ka u u file Yesu na, maa u yíbe: «Saliyaŋi kabilini ndi l'à fànha tò cyi sanŋkii na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ka Yesu si u pyi: «Kile Saliyaŋi kabilini niɲcyiini li ɲyɛ “Izirayɛli shiinbii, yii lógo, wuu Kafooŋi Kile kanni u ɲyɛ Kafooŋi. ");
INSERT INTO spp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ma Kafooŋi Kile kyaa táan may'á, ná ma zòmbilini puni ná ma múnaani puni ná ma sɔ̀nŋɔre puni ná ma fànhe puni i.” ");
INSERT INTO spp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Shɔnwuuni li ɲyɛ “Ma supyiɲɛɛŋi kyaa táan may'á bà mu kyal'à táan may'á mɛ.” Kile Saliyaŋi kapyaagii puni i, là ɲyɛ a pêl'a cyire shuunniŋi kwɔ̀ mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ka uru Kile Saliyaŋi cyelentuŋi si Yesu pyi: «Wuu cyelentuŋi, mu à sèe jwo, Kile ɲyɛ niŋkin, wà saha ɲyɛ a bâra u na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bà mu à jwo, ma Kafooŋi Kile kyaa táan may'á, ná ma zòmbilini puni ná ma yákiliŋi puni ná ma fànhe puni i, maa ma supyiɲɛɛŋi kyaa taan may'á bà mu kyal'à táan may'á mɛ, lir'à pwɔ́rɔ sárayi nizogoyi ná sárayi kuuyi sanɲyi na.» ");
INSERT INTO spp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu à li ɲya na Kile Saliyaŋi cyelentuŋ'à uru ɲwɔ shwɔ ná yákilifente e ke, ka u u u pyi: «Mu laage ɲyɛ a tɔɔn Kile Saanre na mɛ.» Lire kàntugo wà saha ɲyɛ a ɲɛn'a Yesu yíbe mɛ. ");
INSERT INTO spp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mà Yesu yaha u u sùpyire kâlali Kileɲaarebage e, u à pi yíbe: «Kile Saliyaŋi cyelentiibii maha jwo na Kile Niɲcwɔnrɔŋi na ɲyɛ Dawuda Tuluge Shin. Ɲaha yii na sɔ̂nŋi pur'e bɛ? ");
INSERT INTO spp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Jwumpe Dawuda à jwo mà Kile Munaani yaha l'à u yyaha cû ke, yii sɔ̂nŋɔ puru na. U à jwo: “Kafooŋi Kile à jwo mii Kafooŋi á, ‘Ta ma a pa ntɛ̀ɛn na kàniŋɛ cyɛge na, fo mii aha mu zàmpɛɛnbii le mu tooyi ɲwɔh'i.’” ");
INSERT INTO spp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ná Dawuda na Kile Niɲcwɔnrɔŋi yiri “Kafooŋi” lir'à li cyêe na Dawuda Tuluge Shin kanna bà mɛ, u Kafoo mú wi, sèe bàl'à?» Shinɲyahare ti mpyi wani na núru Yesu ɲwɔ na ke, puru jwumpe mpyi a táan t'á sèl'e. ");
INSERT INTO spp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mà Yesu yaha u u sùpyire kâlali, u à yi jwo t'á: «Yii a yiye kàanmucaa Kile Saliyaŋi cyelentiibii na, pi maha vàanntinmbwoyi leni na ɲaare. Sùpyire tabinniyi i, pi la maha mpyi pi raa pire pêre s'a pire shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pi aha shà Kile Jwumpe kàlambayi i, lire ɲyɛ mɛ wà ha pi yyere kataan ɲjyì na, bwompe tatɛɛnyi pi maha ɲcaa. ");
INSERT INTO spp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mà bâra lire na, pi maha leŋkwucyeebii cyeyaayi puni shuu pi na ná pi ɲwɔtanyi i. Pi maha Kile ɲáare na mɔni sùpyire ɲyiɲyage na. Lire kurugo nde li sí n‑pa pi ta ke, lire sí n‑waha sèl'e.» ");
INSERT INTO spp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kileɲaarebage e, Yesu mpyi a tɛ̀nn'a yyaha kan bùɲyɛŋi yaleŋk'á, maa shinɲyahara wyɛ́rɛŋi leŋkanni wíi. Nàfuufeebii niɲyahara mpyi na wyɛ́rɛŋi niɲyahawa leni. ");
INSERT INTO spp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Leŋkwucwoŋi kanhamafooŋi wà mú mpyi a pa bùɲyɛ pyi, ná daashipyara shuunni i. ");
INSERT INTO spp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ka Yesu si u cyelempyiibii yyere, maa yi jwo pi á: «Sèeŋi na mii sí yi jwo yii á, ŋge leŋkwucwo fòŋɔfooŋ'à bùɲyɛŋi ŋgemu pyi ke, ur'à fànha tò pi sanmpii puni wuŋi na. ");
INSERT INTO spp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ɲaha na yɛ pi sanmpii pun'à wwû pi cyeyaayi niɲyahayi i, mà kan Kile á. Ŋka ŋge leŋkwucwoŋi kanhamafooŋi wi ke, u ɲùŋɔ wyɛ́rɛŋi puni u à kan Kile á, canŋke yalyire lwɔɔre mú bá ɲyɛ u á mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ná u cyelempyiibil'à fworo Kileɲaarebage e ke, ka pi wà niŋkin si Yesu pyi: «Wuu cyelentuŋi, mu u ŋke Kileɲaarebage ɲwɔŋkanni wíi! Kafaabwoyi y'à tɛ̀g'a ku faanra, ku faanraŋkanni s'à ɲwɔ sèl'e!» ");
INSERT INTO spp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ka u u pi pyi: «Ŋke basinaŋke yii ɲyɛ na ɲan'amɛ ke, canŋa na ma, ku puni sí n‑sìi n‑pwɔ̀n n‑cyán, si ku ŋkunuɲyi puni waraga, fo si ku kafaayi láha láha yiye na.» ");
INSERT INTO spp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ɲyɛ ka Yesu sí n‑kàr'a sà ntɛ̀ɛn Olivye cire ɲaŋke ɲuŋ'i, maa yyaha kan Kileɲaarebage á. Ka u cyelempyiibii pìi sicyɛɛre: Pyɛri ná Yakuba ná Yuhana ná Andire si file u na. Mà pi kanni yaha ná Yesu i, ka pi i u yíbe: ");
INSERT INTO spp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Wuu cyelentuŋi, ɲaha tère e cyire karigii sí n‑pyi yɛ? Cyi tèepyiini ká nɔ, ɲaha ku sí li cyêe wuu na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ka Yesu si pi pyi: «Yii a yiye kàanmucaa! Yii àha sùpya yaha u yii wurugo mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yii li cè na shinɲyahara sí mii mɛge le piye na, si mpa jwo yii á na Kile Niɲcwɔnrɔŋi kyaa l'à jwo ke, na pire pi ɲyɛ ure. Pi sí raa shinɲyahara ɲwɔ fáanŋi s'a wuruge. ");
INSERT INTO spp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yii aha mpa a kàshiyi shɛnrɛ núru yiye táan, maa yi shɛnrɛ núru laatɔɔnyi i, lire kà yii funŋɔ pɛn mɛ. Yii li cè na cyire karigii mpyimbaa ɲyɛ mɛ, ŋka lire bà li ɲyɛ diɲyɛŋi tèekwooni mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Supyishiŋi wà sí n‑pa n‑yîri n‑sà n‑cwo wà na, kìni là sí n‑pa n-yîri n‑sà n‑cwo là na. Ɲìŋke ɲcyɛ̀ɛnnɛŋi ná katibwɔhe sí n‑pyi cyeye niɲyahay'e. Cyire ɲcyii na ɲyɛ kanhare tasiige, bà laani maha yîri maa nta a yaa ná li ziŋi i mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ɲyɛ mii sí yii funŋɔ cwo li na si ɲjaha na sùpyire sí raa yii yiri yukyaabii yyére, pi sí raa yii bwùun mú Kile Jwumpe kàlambayi i. Pi sí raa yii yiri fànhafeebii ná saanbii yyére. Cyire puni sí n‑pyi yii na mà li ɲùŋke pyi na yii na ɲyɛ mii cyelempyii. Cyire karigii ɲùŋɔ taan, yii sí mii kyaa jwo pi á. ");
INSERT INTO spp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jwumpe Nintanmpe à yaa pu fyânha a jwo supyishiŋi pun'á. ");
INSERT INTO spp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ɲyɛ sùpyire ká mpa a yii cwôre na ŋkɛ̀ɛge yukyaabii yyére, lire tèni i jwumpe yii sí n‑jwo wani ke, yii àha puru kani tɛ̀gɛ yiye funŋɔ pɛn mɛ. Yii aha nɔ wani yukyaabii cyage e, Kile sí n‑pa jwumpe mpemu kan yii á lire tèni i ke, yii puru jwo, ɲaha na yɛ yii sì raa yu ná yii funŋɔ sɔ̀nŋɔre e mɛ, Kile Munaani fànhe sí n‑pyi yii e. ");
INSERT INTO spp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pìi sí n‑pa raa pi cìnmpyiibii kaan pi a bùu, tiibii pìi sí n‑pa raa pi pyìibii kaan pi a bùu, pyìibii pìi mú sí n‑pa raa yîri pi sifeebii kurugo s'a pi kaan pi a bùu. ");
INSERT INTO spp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yii kyaa sí n‑pɛn sùpyire pun'á mii mɛge kurugo. Ŋka ŋgemu ká jà a uye waha maa ntɛ̀ɛn Kile kuni i fo mà sà nɔ tɛgɛni na ke, urufoo sí n‑shwɔ. ");
INSERT INTO spp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yapege k'à sàa pɛn Kile á ke, yii aha kuru ɲya k'à jyè a tɛ̀ɛn Kileɲaarebage funŋke e na ku ɲwɔ́re Kile yyahe taan tèni ndemu i ke, ŋgemu ká mpe jwumpe lógo ke, urufoo u yyaha le u u pu ɲwɔhe cya a cè! Lire tèni ká nɔ, mà sùpyire ntemu ta Zhude kùluni i ke, pi a fî, pi a wá ɲaɲyi kàmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","L'aha ŋgemu ta u bage kàtanŋke ɲuŋ'i ke, urufoo kà núru ntîge si yaaga lwɔ́ bage e mɛ, u u ntíl'a tîge u a fî. ");
INSERT INTO spp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","L'aha ŋgemu ta kɛrɛge e ke, urufoo kà núru raa ma pyɛngɛ si mpa u vàanntinmbwɔhe lwɔ́ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Cyire canmpyaagii sí n‑waha lahigiifee ná pyìnɛɛbii na sèl'e. ");
INSERT INTO spp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yii a Kile ɲáare, bà li tèni si mpyi l'àha mbɛ̂ ná wyeere tèni i mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Cyire canmpyaagii sí n‑waha sèl'e. Mà lwɔ́ diɲyɛ tasiige e, mà pa bwɔ̀n niɲjaa na, uru ŋgahaŋi fiige sàha mpyi a ɲya mɛ, fo mà sà diɲyɛ kwɔ̀, uru ŋgahaŋi fiige saha mú sì n‑pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kàmpyi Kafooŋi Kile mpyi a uru ŋgahaŋi tèni bere mɛ, sùpya mpyi na sì n‑shwɔ mɛ. Ŋka u à uru ŋgahaŋi tèni bere u niɲcwɔnribii kurugo, bà pire si mpyi si shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ɲyɛ shin ká jwo yii á na Kile Niɲcwɔnrɔŋi na wá naha, lire ɲyɛ mɛ u wá mɛŋi i, yii àha ndá urufoo na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ɲaha kurugo yɛ kafinivinibii pìi sí n‑yîri na pire pi ɲyɛ Kile Niɲcwɔnrɔŋi, pìi sí raa ŋko na pire na ɲyɛ Kile tùnntunmii. Pi sí raa kacyeeŋkii cyêre, s'a kakyanhala karigii pyi, bà pi si mpyi s'a Kile niɲcwɔnribii wuruge, kampyi pi sí n‑jà mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yii a yiye kàanmucaa cyire karigii puni na, mii à cyi puni jwo yii á mà jwo cyi tèni li nɔ ke. ");
INSERT INTO spp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ɲyɛ yyefuge kàntugo, “Canŋa ɲyiini sí n‑pyi numpire, yiŋke saha mú sì raa bɛ̀ɛnmɛ yige mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wɔrigii sí raa ɲcwu, yire kakyanhala yaayi yi ɲyɛ nìɲyiŋi na ke, yire sí n‑cúnŋɔ n‑cúnŋɔ n‑yîri yi tatɛɛnyi i.” ");
INSERT INTO spp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ɲyɛ lire tèni i, pi sí Supyaŋi Jyaŋi ɲya ɲahaɲyi i, u à yîri nìɲyiŋi na ná fànbwɔhe ná sìnampe e. ");
INSERT INTO spp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lire kàntugo u sí u mɛ̀lɛkɛɛbii tun diɲyɛŋi kàmpanɲyi sicyɛɛreŋi puni na, pi i Kile niɲcwɔnribii wà piye na, mà lwɔ́ diɲyɛŋi ɲùŋke kà na mà sà nɔ ku sanŋke na. ");
INSERT INTO spp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yii fizhiye cige kàanmucya a wíi kɛ! K'aha ŋkéɲyɛ nivɔnyɔ yige, maa fûn tèni ndemu i ke, yii maha ɲcè na nùŋgwɔh'à byanhara. ");
INSERT INTO spp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lire pyiŋkanni na, yii aha mpa cyire karigii ɲya cyi i mpyi, yii i li cè na tèn'à byanhara, li bá à nɔ. ");
INSERT INTO spp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sèeŋi na mii sí yi jwo yii á, mpii pi a dá mii na ke, pire sí cyire karigii ɲya tapyige e. ");
INSERT INTO spp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nìɲyiŋi ná ɲìŋke sí n‑pa n‑tòro, ŋka mii jwumpe sí n‑kwôro fo tèekwombaa. ");
INSERT INTO spp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nde li ɲyɛ Supyaŋi Jyaŋi nùruŋi ke, shin niŋkin ɲyɛ a sìi ŋgemu u à u tèenuruni ná u cannuruge cè mɛ. Ali Kile mɛ̀lɛkɛɛbii ná Jyafooŋi ɲyɛ a kuru canŋke cè mɛ. Tufooŋi Kile kanni u à ku cè. ");
INSERT INTO spp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yii a yiye kàanmucaa, yii i ŋkwôro ɲyii na, ɲaha na yɛ yii ɲyɛ a u tèepani cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Li sí n‑pyi mu à jwo nàŋi wà kùshe wu u à u pyɛnge karigii puni táa báarapyiibii na, maa yi jwo a waha pyɛnge ɲwɔge tɛɛnfooŋ'á, na u a ku kàanmucaa sèl'e, maa ŋkàre. ");
INSERT INTO spp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Lire pyiŋkanni na, yii bégele tèrigii puni i, yii i ŋkwôro ɲyii na, bà pyɛngefoo si mpyi u aha mpa, u àha mpa yii ta yii i ŋwúuni mɛ. Ɲaha kurugo yɛ yàkoŋɔ u sí n‑pa yo, ɲìɲiŋɛ na yo, ŋkùuŋi mɛɛni na yo, ɲyɛ̀ge na yo, yii ɲyɛ a cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mpe mii sí n‑jwo yii á ke, puru mii sí n‑jwo pi sanmpii pun'á “Yii kwôro ɲyii na.”» ");
INSERT INTO spp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Cyi sanŋkii mpyi a kwôro canmpyaa shuunni, bilereŋkwoŋi kataanni ná bwúuruŋi niɲjirigembaaŋi kataanni sí nɔ. Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii mpyi na Yesu caa ɲcû ná cwɔ̀ɔre e, si u bò. ");
INSERT INTO spp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pi mpyi na yi yu piy'á: «Li ɲyɛ a yaa li pyi kataanni tooy'e mɛ, lire baare e sùpyire sí n‑cânra.» ");
INSERT INTO spp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ná u cyelempyiibii na mpyi Bɛtani kànhe e, tògofooŋi Simɔ bage e. Mà pi yaha talyige e, ceeŋi wà à file u na ná loŋgaracwol'e, li mpyi a ɲî sìnmpe nùguntanga wumpe loŋgara wumpe pà na. Maa cwooni ɲwɔge kebe, maa sìnmpe nùguntanga wumpe wu Yesu ɲùŋke na. ");
INSERT INTO spp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ɲyɛ sùpyire ti mpyi ná Yesu i ke, ka tire tà si wá na ŋkunni tiye shwɔhɔl'e na: «Ŋge ŋkɛ̀ɛgɛŋi ɲùŋke ku ɲyɛ ŋkire yɛ? ");
INSERT INTO spp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mpe sìnmpe n'a mpyi a pɛ́rɛ, pu mpyi na sí wyɛ́rɛɲyahaga ta, si ntaha fòŋɔfeebii tɛ̀gɛ. Pu lwɔɔre mpyi na sí n‑jà shin niŋkin yyee niŋkin báara sàra kwɔ̀.» Ka pi i wá na ceeŋi fare. ");
INSERT INTO spp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ka Yesu si pi pyi: «Yii láha ceeŋi na! Ɲaha na yii ɲyɛ na u cɛ̂ɛge yɛ? Kacɛnnɛ u à pyi mii na. ");
INSERT INTO spp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Fòŋɔfeebii ɲyɛ naha ná yii e tèrigii puni i, tèni ndemu ká yii táan ke, yii sí n‑jà pi tɛ̀gɛ, ŋka mii wi ke, mii sì n‑pyi ná yii e tèrigii puni i mà dɛ! ");
INSERT INTO spp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ceeŋ'à u nimpyiini pyi. U à mii cyeere bégel'a yaha na fanŋke sigili. ");
INSERT INTO spp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sèeŋi na mii sí yi jwo yii á, Jwumpe Nintanmpe ká nɔ cyaga maha cyag'e ke, nde ŋge ceeŋ'à pyi niɲjaa ke, lire sí n‑jwo wani bà li si mpyi si ŋkwôro sùpyire funŋ'i mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zhudasi Isikariyoti na mpyi cyelempyiibii kɛ ná shuunniŋi i, ka uru si shà Kile sáragawwuubii ɲùŋufeebii yyére, maa yi jwo pi á na uru sí Yesu le pi cye e. ");
INSERT INTO spp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ka puru jwumpe si pi funɲyi táan sèl'e, ka pi i wyɛ́rɛ ɲwɔ jya u á. Mà lwɔ́ lire tèni na, ka Zhudasi si wá na pyiŋkanna caa si Yesu le pi cye e. ");
INSERT INTO spp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ɲyɛ bwúuruŋi niɲjirigembaaŋi kataanni canɲcyiige, Yahutuubii mpyi maha ntêre na mpàbili pyi sáraga pi bilereŋkwoŋi kurugo. Kuru canŋk'à nɔ ke, ka Yesu cyelempyiibii si u yíbe: «Taa mu la ɲyɛ wuu u sà bilereŋkwoŋi kataanni ɲjyìŋi shwɔhɔ ke?» ");
INSERT INTO spp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ka Yesu si pi pìi shuunni tun, maa yi jwo pi á: «Yii a sì kànhe e, yii sí n‑bɛ̂ ná nàŋi w'e, u à lwɔhɔ kucwoo tugo. Yii i ntaha u fye e fo u aha sà jyè pyɛnge ŋkemu i ke. ");
INSERT INTO spp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yii aha sà nɔ wani, yii i yi jwo pyɛngefooŋ'á, na yii cyelentuŋ'à jwo yii sà u yíbe, na bage ŋkire e uru ná u cyelempyiibii sí kataanni ɲjyìŋi lyî yɛ. ");
INSERT INTO spp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yii aha kuru yibige pyi, uru nàŋi sí batɔɔnge nìɲyibabilini là cyêe yii na, l'à bégel'a ɲwɔ sèl'e. Lire babilini i, yii sí kataanni ɲjyìŋi karigii cwɔɔnrɔ.» ");
INSERT INTO spp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ka cyelempyiibii si ŋkàre, pi à sà nɔ kànhe e ke, ka pi i sà yi ta Yesu jwuŋkanni na. Ka pi i kataanni ɲjyìŋi karigii cwɔɔnrɔ wani. ");
INSERT INTO spp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ɲyɛ yàkoŋk'à pa nɔ ke, ka Yesu si mpa ntɛ̀ɛn na lyî ná u cyelempyiibii kɛ ná shuunniŋi i. ");
INSERT INTO spp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mà pi yaha ɲjyìŋi na siɲcyan, Yesu à pi pyi: «Sèeŋi na mii sí yi jwo yii á, yii mpii pi naha na lyî ná mii i ke, yii wà niŋkin naha na sí n‑pa mii le cye e.» ");
INSERT INTO spp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ka puru jwumpe si cyelempyiibii yyahayi tanha sèl'e fo pi shin maha shin na u yíbili: «Mii wi la? Mii wi la?» ");
INSERT INTO spp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ka Yesu si pi pyi: «Yii shiin kɛ ná shuunniŋi wà wi, ŋge cyɛge ku naha na mii woge e ɲjyìŋi yaage e ke. ");
INSERT INTO spp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Supyaŋi Jyaŋi ŋkwùmbaa ɲyɛ mɛ, bà l'à sémɛ u kyaa na Kile Jwumpe Semɛŋi i mɛ. Ŋka ŋgemu u sí n‑pa u le cye e ke, urufoo wuun'à kɛ̀ɛge! Urufoo zimbaaŋi mpyi na sí n‑pwɔ́rɔ u ziŋi na.» ");
INSERT INTO spp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mà pi yaha pi i lyî, Yesu à bwúuruŋi lwɔ́, maa fwù kan Kile á u kyaa na, maa u kwɔ̀n kwɔ̀n mà kan u cyelempyiibil'á, maa jwo: «Yii ŋge shwɔ a lyî, mii cyeere ti.» ");
INSERT INTO spp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lire kàntugo maa fùnɲcwokwuuni lwɔ́, ɛrɛzɛn sinmɛ mpyi l'e, maa fwù kan Kile á pu kyaa na, maa pu kan pi á, ka pi puni si pu bya. ");
INSERT INTO spp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ka u u pi pyi: «Puru pu ɲyɛ mii sìshange, tunmbyaare nivɔnnte Kile à le ke, tire sìshange ki, ŋke k'à wu si ntaha shinɲyahara ná Kile shwɔ̀hɔŋi yaa ke. ");
INSERT INTO spp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sèeŋi na mii sí yi jwo yii á, mii saha sì ɛrɛzɛn sinmɛ bya mɛ, fo canŋke mii sí núru pu bya Kile Saanre e ke.» ");
INSERT INTO spp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɲyɛ ka pi i Kile pèente myahigii cêe maa nta a fworo bage e, maa ŋkàre Olivye cire ɲaŋke ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pi à nɔ wani ke, ka Yesu si pi pyi: «Yii puni sí n‑fê si mii kanni yaha, ɲaha na yɛ y'à sémɛ Kile Jwumpe Semɛŋi i “Mii sí mpànahaŋi bò, mpàkuruŋke puni sí n‑caala.”» ");
INSERT INTO spp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ka Yesu si núr'a pi pyi: «Ŋka mii aha ɲɛ̀ a fworo kwùŋi i tèni ndemu i ke, mii sí n‑sà yii sige Galile kùluni i.» ");
INSERT INTO spp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ka Pyɛri si u pyi: «Pi sanmpii puni mɛ́ɛ ká fê, maa mu yaha, mii kyaa bà mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ka Yesu si u pyi: «Sèeŋi na mii sí yi jwo mu á, niɲjaa numpilage yabiliŋi i, ŋkùpooŋi mɛɛni shɔnwuuni sí mu ta mu à jwo a nɔ tooyo taanre na na mu ɲyɛ a mii cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ka Pyɛri si núr'a u ɲwɔmɛɛni taha maa yi jwo a waha: «Pi mɛ́ɛ ká mpyi na sí mii bò ná mu i, mii sì n‑sìi n‑jwo na mii ɲyɛ a mu cè mɛ.» Ka cyelempyiibii sanmpii puni si yire ninuyi jwo. ");
INSERT INTO spp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ɲyɛ ka pi i nɔ cyage k'e, kuru mɛge ɲyɛ Zhetisemani. Ka Yesu si u cyelempyiibii pyi: «Yii tɛ̀ɛn naha mà jwo mii u sà Kile ɲáare mɛyyere ke.» ");
INSERT INTO spp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ka u niŋkareŋi si ŋkàre ná Pyɛri ná Yakuba ná Yuhana i. Ka yyetanhare ná funmpɛɛnre si sìi u á. ");
INSERT INTO spp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ka u u pi pyi: «Mii funŋke naha a pɛn fo na ŋko si mii bò. Yii tɛ̀ɛn naha yii i ŋkwôro ɲyii na.» ");
INSERT INTO spp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ka u u ŋkàre yyaha yyére, maa uye wà ɲìŋke na, maa Kile ɲáare, bà lire tèni kyaage si mpyi si ɲjà ntòro u taan mɛ. ");
INSERT INTO spp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","U mpyi na ŋko: «Mii Tu Baba, li fànhe ɲyɛ mu i mà jà a karigii puni pyi. Na shwɔ ŋke kyaage lwɔhe na. Ŋka ma hà na ɲyii wuuni pyi mɛ, ma ɲyii wuuni pyi.» ");
INSERT INTO spp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Lire kàntugo ka Yesu si núr'a pa u cyelempyiibii yyére, mà sà pi ta pi i ŋwúuni. Ka u u Pyɛri ɲɛ̀, maa u pyi: «Simɔ, mu na ŋwúuni bɛ? Mu ɲyɛ a jà a nde tèni niŋkinŋi pyi ɲyii na ná mii i mà? ");
INSERT INTO spp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yii tɛ̀ɛn ɲyii na, yii raa Kile ɲáare, bà yii si mpyi si fànha ta Sitaanniŋi na, u àha ŋkwɔ̀ yii sɔ̀n ŋgà kapii na mɛ. Nàkaana baa, sùpyaŋi zòmbilin'à bégel'a yaha kacɛnŋkii mɛɛ na, ŋka u fành'à cyɛ́rɛ.» ");
INSERT INTO spp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Lire kàntugo ka Yesu si núr'a file yyaha yyére, maa wá na Kile ɲáare ná puru jwunumpe e. ");
INSERT INTO spp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ka u u núr'a pa u cyelempyiibii yyére mà pa pi ta pi à ŋɔ́ɔ, pi mpyi na sì n‑jà ɲyiigii múgo n‑yaha mɛ. Ɲje pi sí n‑jwo Yesu á ke, pi saha ɲyɛ a cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ka Yesu si núr'a kàre yyaha na, maa núr'a pa nɔ u cyelempyiibii na tontanrawoge e, maa pi pyi: «Yii saha na ŋwúuni la? Ŋɔɔmp'à ta, tèn'à nɔ. Numɛ, Supyaŋi Jyaŋi sí n‑le kapimpyiibii cye e. ");
INSERT INTO spp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yii yîri, wuu raa sì, ɲaha na yɛ ŋge u sí mii le cye e ke, uru na naha naha.» ");
INSERT INTO spp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ɲyɛ mà Yesu yaha puru jwumpe na, ka Zhudasi si nɔ wani, uru na ɲyɛ cyelempyiibii kɛ ná shuunniŋi wà. U mpyi a pa ná shinɲyahar'e, kàshikwɔnŋwɔɔyi ná kàbiiyi mpyi pire cye e. Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii ná Yahutuubii kacwɔnribii pi mpyi a pire tun. ");
INSERT INTO spp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zhudasi u mpyi na sí u le pi cye e ke, uru mpyi a jwo a kan u cùveebil'á: «Yii aha mii ɲya mii à sùpyaŋi ŋgemu pûr'a cû maa u shɛ́ɛre ke, urufoo wi. Yii i u cû, yii a sì, yii raa u kàanmucaa sèl'e.» ");
INSERT INTO spp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pi à nɔ ke, ka Zhudasi si ntíl'a file Yesu na, maa jwo: «Wuu cyelentuŋi» maa u pûr'a cû. ");
INSERT INTO spp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɲyɛ ka sùpyire si cye taha Yesu na, maa u cû. ");
INSERT INTO spp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ka Yesu cyelempyaŋi wà niŋkin si u kàshikwɔnŋwɔɔge wwû mà taha a Kile sáragawwuubii ɲùŋufembwɔhe báarapyiŋi niŋgeŋke kà kwɔ̀n a cyán. ");
INSERT INTO spp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ka Yesu si yi jwo pi á: «Yii à pa mii fye e ná kàshikwɔnŋwɔɔyi ná kàbiiyi i mpa ɲcû, mu à jwo kakuumpyi u ɲyɛ mii. ");
INSERT INTO spp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mii mpyi ná yii e canŋa maha canŋa. Mii mpyi maha sùpyire kâlali Kileɲaarebage e, yii sí ɲyɛ a mii cû mɛ. Ŋka nde mpyiŋi sí Kile tùnntunmpii jwumpe fûnŋɔ.» ");
INSERT INTO spp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ka u cyelempyiibii puni si fê, maa u yaha. ");
INSERT INTO spp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nàɲjiiŋi wà u mpyi a taha u fye e, vàannto kanna u mpyi a taha a uye míginɛ. Ka pi i u cû vàanntoŋi na. ");
INSERT INTO spp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ka u u láha u na, maa wá na fî u cípyire wuŋi. ");
INSERT INTO spp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mpii pi à Yesu cû ke, ka pire si ŋkàre ná u e Kile sáragawwuubii ɲùŋufembwɔhe yyére. Kile sáragawwuubii ɲùŋufeebii puni ná Yahutuubii kacwɔnribii ná Kile Saliyaŋi cyelentiibii mpyi a piye bínni wani. ");
INSERT INTO spp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mà pi yaha pi i ŋkɛ̀ɛge ná Yesu i, Pyɛri à tɛ̀ɛn laage e, marii sì pi fye e fo sáragawwuubii ɲùŋufembwɔhe pyɛnge e. U à sà nɔ ke, maa jyè pyɛnge e, maa ntɛ̀ɛn saɲcwɔnsigibii taan na uye ware. ");
INSERT INTO spp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sáragawwuubii ɲùŋufeebii ná yukyaala kuruŋke shiinbii puni mpyi na kaɲuŋɔ caa si Yesu bò. Ŋka pi ɲyɛ a yaaga ta mɛ. ");
INSERT INTO spp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Shinɲyahara mpyi na fini Yesu na, ŋka pi jwumpe ɲyɛ a bɛ̂ niŋkin na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pìl'à pa yîri, maa fini na pir'à lógo na u à jwo: ");
INSERT INTO spp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Mii sí sùpyire Kileɲaarebage nivanrage cyán, sí núru ku faanra canmpyaa taanre funŋ'i sùpya baa.» ");
INSERT INTO spp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Puru mpe ɲùŋɔ taan sahaŋki, pi jwumpe ɲyɛ a jà a pyi niŋkin mɛ. ");
INSERT INTO spp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ka sáragawwuubii ɲùŋufembwɔhe si yîri sùpyire shwɔhɔl'e, maa Yesu yíbe: «Mpe jwumpe puni p'à jwo mà yyaha tíi ná mu i ke, ɲaha mu à cè p'e yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ka Yesu si fyâha fyii, u ɲyɛ a yaaga jwo mɛ. Ka sáragawwuubii ɲùŋufembwɔhe si núr'a u yíbe: «Kile Niɲcwɔnrɔŋi u ɲyɛ mu la? Kileŋi Niɲcɛnŋi Jyaŋi u ɲyɛ mu la?» ");
INSERT INTO spp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ka Yesu si u pyi: «Ɔɔn, mii wi! Yii sí Supyaŋi Jyaŋi ɲya u à tɛ̀ɛn Siŋi Punifoo Kile kàniŋɛ cyɛge na, lire kàntugo yii mú sí u nimpaŋi ɲya ɲahaɲyi i, mà yîri nìɲyiŋi na.» ");
INSERT INTO spp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yesu à puru jwo ke, ka sáragawwuubii ɲùŋufembwɔhe lùyiri wuŋi si u yabiliŋi vàanntinŋke cwɔn, maa jwo: «Wuu saha ɲyɛ a tîge wà ɲwɔjwumɔ kurugo mɛ. ");
INSERT INTO spp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yii à u Kile mɛkɛɛgɛ jwumpe lógo. Ɲaha yii ɲyɛ na sɔ̂nŋi yɛ?» Ka pi puni si ntɛ̀ɛn li taan na u à kapii pyi, na u mú s'à yaa u bò. ");
INSERT INTO spp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ka pìi si wá na ntilwɔhe wàa u na, maa u yyahe pwɔ, maa kaŋkuruyo cyán u e, maa u yíbe: «Mu ɲyɛ a jwo na mu na ɲyɛ Kile tùnntunŋɔ mà? Ŋge u à mu bwɔ̀n ke, uru mɛge yyere wuu á!» Ka pyɛnge saɲcwɔnsigibii si kantawahii bwɔ̀n bwɔ̀n u e. ");
INSERT INTO spp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lir'à Pyɛri ta u mpyi ɲwɔhɔntaan pyɛnge funŋke e. Ka Kile sáragawwuubii ɲùŋufembwɔhe báarapyicwoŋi wà si mpa ");
INSERT INTO spp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pyɛri ta u u na ware, maa u yal'a wíi maa u pyi: «Mu mú mpyi ná Nazarɛti Yesu e!» ");
INSERT INTO spp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ka Pyɛri si yi kyáala maa jwo: «Ceewe, mpe mu na yu ke, mii ɲyɛ a puru cè mɛ.» Lire kàntugo ka Pyɛri si fworo ntàani na mà sà yyére tajyiɲwɔge na, ka ŋkùpooŋi si mɛɛ sú. ");
INSERT INTO spp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Lire kàntugo ka uru ceeŋi ninuŋi si núr'a Pyɛri ɲya kuru cyage e. Sùpyire ti mpyi wani ke, ka u u tire pyi: «Ŋge nàŋi ɲyɛ pi wà.» ");
INSERT INTO spp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ka Pyɛri si núr'a yi kyáala. Ɲyɛ tèr'à pyi ke, mpii pi mpyi wani ke, ka pire si yi jwo Pyɛri á: «Nàkaana baa, mu na ɲyɛ Yesu fyèɲwɔhɔshinŋi wà, ɲaha na yɛ mu mú na ɲyɛ Galile kùluni shin.» ");
INSERT INTO spp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ɲyɛ ka Pyɛri si jwo: «Kampyi mii à ŋge nàŋi cè, Kile kà na yaha mɛ!» ");
INSERT INTO spp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ka ŋkùpooŋi si ntíl'a mɛɛ sú tozhɔnwogo. Ka Pyɛri funŋke si ɲcwo Yesu jwumpe niɲjwumpe na na: «Ŋkùpooŋi mɛɛni shɔnwuuni sí mu ta mu à jwo a nɔ tooyo taanre na na mu ɲyɛ a mii cè mɛ.» Ɲyɛ ka Pyɛri si wá na mɛɛ súu. ");
INSERT INTO spp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kuru canŋke ɲyɛ̀sɔɔge na, ka Kile sáragawwuubii ɲùŋufeebii ná Yahutuubii kacwɔnribii ná Kile Saliyaŋi cyelentiibii ná yukyaala kuruŋke shiinbii sanmpii puni si piye bínni, maa wwɔ̀ a jwo, maa Yesu cû a pwɔ maa ŋkàre ná u e fànhafooŋi Pilati á. ");
INSERT INTO spp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ka Pilati si u yíbe: «Yahutuubii Saanŋi u ɲyɛ mu la?» Ka Yesu si u pyi: «Mu aha jwo amuni yo.» ");
INSERT INTO spp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ka Kile sáragawwuubii ɲùŋufeebii si tìgire niɲyahara cyán Yesu na. ");
INSERT INTO spp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ka Pilati si núr'a u yíbe: «Tìgire pi à cyán mu na ke, mu ɲyɛ a pà cè a jwo tire e mà?» ");
INSERT INTO spp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu saha ɲyɛ a jwo mɛ. Ka lire si Pilati kàkyanhala sèl'e. ");
INSERT INTO spp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yyee maha yyee Yahutuubii bilereŋkwoŋi kataanni n'a mpyi a nɔ, Pilati mpyi maha kàsujyi niŋkin yaha, ŋge sùpyire mpyi maha ɲáare u á ke. ");
INSERT INTO spp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nàŋi wà, ná u mɛge na mpyi Barabasi, uru mpyi a le kàsuŋi i, ɲaha na yɛ u ná u wwoɲɛɛbii mpyi a cânra Ɔrɔmu shiinbil'á, fo mà booro pyi. ");
INSERT INTO spp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ka sùpyire si file Pilati na, maa u ɲáare na nde u maha mpyi pir'á yyee maha yyee ke, na u lire pyi. ");
INSERT INTO spp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ka Pilati si pi yíbe: «Li sí n‑bɛ̂ yii á, mii u Yahutuubii Saanŋi yige kàsuŋi i la?» ");
INSERT INTO spp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","U mpyi a cè na yiɲcyɛge na Kile sáragawwuubii ɲùŋufeebil'à Yesu le cye e. ");
INSERT INTO spp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ŋka Kile sáragawwuubii ɲùŋufeebil'à sùpyire sɔ̀n na ti Pilati ɲáare u Barabasi yige kàsuŋi i, u u Yesu yaha wani. ");
INSERT INTO spp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ka Pilati si núr'a pi yíbe: «Ŋge yii na mpyi Yahutuubii Saanŋi ke, ɲaha yii ɲyɛ na sɔ̂nŋi mii i mpyi uru na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka pi i jwo fànha na: «U kwòro cige na!» ");
INSERT INTO spp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ka Pilati si núr'a pi yíbe: «Kapiini ndire u à pyi mà sà nɔ u bò yɛ?» Ŋka pi saha na kwuugii wàa fànha na, marii ŋko: «U kwòro cige na!» ");
INSERT INTO spp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilati la mpyi si sùpyire ɲyii wuuni pyi, maa Barabasi yige kàsuŋi i, maa pi pyi pi à Yesu bwɔ̀n ná kàsɔrigil'e, maa u kan pi sà ŋkwòro kworokworocige na. ");
INSERT INTO spp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ka sòrolashiibii si ŋkàre ná Yesu i pi tatɛɛnge e, maa sòrolashiibii sanmpii yyer'a pa, ");
INSERT INTO spp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","maa vàanntinmbwɔhɔ niɲyɛga le u na, maa ŋguro cîn mà pyi saanra ɲùntoŋɔ mà tò u na. ");
INSERT INTO spp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lire kàntugo ka pi i wá na u fwɔ́hɔre, marii ŋko: «Yahutuubii Saanŋi, wuu à mu shɛ́ɛre!» ");
INSERT INTO spp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Marii u bwùun ɲùŋke e ná kàbiini i, marii ntilwɔhe wàa u na, marii niŋkure sínni u taan, maa piye pyi mu à jwo pi na u pêre. ");
INSERT INTO spp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pi à u fwɔ́hɔr'a kwɔ̀ ke, maa vàanntinmbwɔhe niɲyɛge wwû u na, maa u yabiliŋi vàanɲyi le u na, maa ŋkàre ná u e si sà ŋkwòro kworokworocige na. ");
INSERT INTO spp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ɲyɛ mà sòrolashiibii yaha pi i ŋkɛ̀ɛge ná Yesu i taboŋke e, pi à círi ná nàŋi w'e u à yîri sige e, u mɛge mpyi Simɔ, Sirɛni kànhe shin u mpyi u wi. Alɛzandiri ná Urufusi yii tuŋi u mpyi u wi. Ɲyɛ ka pi i u kárama u à Yesu kworokworocige tugo. ");
INSERT INTO spp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ka pi i ŋkàre ná u e cyage mɛge ku ɲyɛ Gɔlikota ke, lire ɲwɔhe ku ɲyɛ: «Ɲuŋkwɔɔge Cyage.» ");
INSERT INTO spp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pi à nɔ wani ke, maa wyɛɛre tà le sinmpe e mà kan Yesu á u bya, ŋka u ɲyɛ a ɲɛn'a ti bya mɛ. ");
INSERT INTO spp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sòrolashiibil'à Yesu kwòr'a kwɔ̀ ke, maa ŋkyaanlwooni tɛ̀g'a u vàanɲyi táa piye na, bà pi puni si mpyi si pi nàzhanŋi cè mɛ. ");
INSERT INTO spp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","U à kwòro cige na ɲyɛ̀ge tèni baacyɛɛre wuuni na. ");
INSERT INTO spp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","U à bò ɲùŋke ŋkemu na ke, cikwooni na pi mpyi na sí kuru sémɛ ke, pi à li sémɛ kuru cyage e: «YAHUTUUBII SAANŊI». ");
INSERT INTO spp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nàŋkaalii shuunni mpyi a kwòro ná Yesu i. Wà mpyi u kàniŋke na, u sanŋi sí ɲyɛ u kàmɛni na.  ");
INSERT INTO spp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Lire pyiŋkanni na, mpe p'à sémɛ Kile Jwumpe Semɛŋi i u kyaa na ke, pur'à fûnŋɔ: «U à tɔ̀rɔ ná kapimpyiibil'e.» ");
INSERT INTO spp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sùpyire nintorore mpyi maha u fwɔ́hɔre, marii ɲùɲyi kwòre, marii ŋko: «Mu u mpyi maha jwo na mu sí Kileɲaarebage cyán si ku faanre canmpyaa taanre e ke, mu u ɲyɛ amɛ la? ");
INSERT INTO spp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mu yabiliŋi u maye shwɔ, maa ntîge kworokworocige na.» ");
INSERT INTO spp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii mpyi na u fare, marii ŋko piy'á: «U à pìi shwɔ, maa mpyi u ɲyɛ a jà uye shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kile Niɲcwɔnrɔŋi! Izirayɛli Saanŋi! Mu aha jà a tîge ŋke cige na may'á, wuu sí n‑dá mu na!» Mpii pi mpyi a kwòro u taan ke, pire mú mpyi na u fare. ");
INSERT INTO spp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ɲyɛ canŋke mpyi a nɔ ɲùŋɔ niŋi i, ka numpini si mpâl'a jyè kìni cyeyi puni i, mà tère pyi fo mà sà byanhara yàkoŋke na. ");
INSERT INTO spp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Lire tèni i, ka Yesu si jwo fànha na: «Eloyi, Eloyi, lama sabakatani?» Lire ɲwɔhe ku ɲyɛ: «Mii Kileŋi, mii Kileŋi, ɲaha na mu à kàntugo wà mii á yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mpii pi mpyi wani ke, ka pire pìi si yire lógo, maa jwo: «Yii lógo! U naha na Kile tùnntunŋiEli yiri na u pa uru tɛ̀gɛ.» ");
INSERT INTO spp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ka pire wà niŋkin si fê a sà sìcogo fyinmɛ lùtanhage k'e, maa ku nɔ́rɔ kàbii na, mà yaha Yesu ɲwɔge taan, u u ku ta a shwɔɔnrɔ. Maa jwo: «Yii u yaha wani, wuu a wíi kampyi Eli sí n‑pa u tîrige ŋke cige na.» ");
INSERT INTO spp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ka Yesu si núr'a sêe fànha na, ka u múnaani si fworo u e. ");
INSERT INTO spp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɲyɛ ka Kileɲaarebage táataa vàanŋke si ɲcwɔn niŋke e, mà lwɔ́ nìɲyiŋi na fo ɲwɔh'i. ");
INSERT INTO spp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ɲyɛ Ɔrɔmu sòrolashiibii yyaha yyére shinŋi u mpyi a yyére Yesu yyaha na ke, u à ta naha u kwùŋkanni ɲya ke, ka u u jwo: «Nàkaana baa, ŋge nàŋi mpyi Kile Jyaŋi.» ");
INSERT INTO spp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cyee kuruŋɔ mpyi a yyére laage e, marii wíi. Mariyama u mpyi na yîri Magidala kànhe e ke, ná Mariyama, u ɲyɛ Yakuba bilere ná Zhoze nuŋi ke, ná Salomɛ mpyi pi e. ");
INSERT INTO spp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pire cyeebii pi mpyi a taha Yesu fye e mà u yaha Galile kùluni i marii u tɛ̀re. Cyee niɲyahamii mú mpyi wani, pi mpyi a taha u fye e mà kàre Zheruzalɛmu kànhe e. ");
INSERT INTO spp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɲyɛ yàkoŋke mpyi a nɔ a kwɔ̀, ka pi i wá na canŋɔŋke bégeli, lire ɲwɔhe ku ɲyɛ: kuru canŋa nùmpanŋa mpyi canŋɔŋke. ");
INSERT INTO spp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimati kànhe shinŋi Yusufu, uru na mpyi yukyaala kuruŋke sèe shinŋi wà. U cyɛge mpyi a taha Kile Saanre tèepani na. Ka uru si ɲùŋɔ waha maa ŋkàre Pilati yyére si Yesu buwuŋi ɲáare u á. ");
INSERT INTO spp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilati à Yesu kwùŋi lógo ke, l'à u pâa, ka u u sòrolashiibii yyaha yyére shinŋi yyer'a pa yíbe kampyi u tèekwuun'à mɔ. ");
INSERT INTO spp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tèni i sòrolashiibii yyaha yyére shinŋ'à Pilati pyi na Yesu à kwû ke, ka u u kuni kan Yusufu á na u sà u tîrige kworokworocige na. ");
INSERT INTO spp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ka Yusufu si vàanvyinge shwɔ, maa Yesu buwuŋi tîrige kworokworocige na, mà le k'e, mà sà ntò fanŋke e. Kuru fanŋke mpyi a tùgo kafaaga na. Ka u u kafaabwɔhɔ kùuŋkul'à pa ntò fanŋke ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magidala Mariyama ná Zhoze nuŋi Mariyama mpyi na Yesu buwuŋi tasinnage wíi. ");
INSERT INTO spp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ɲyɛ canŋɔŋk'à tòro ke, Magidala Mariyama ná Yakuba nuŋi Mariyama ná Salomɛ, ka pire mú taanre si ŋkàr'a sà sìnmɛ nùguntanga wumɔ shwɔ si ntɛ̀gɛ Yesu buwuŋi tìri. ");
INSERT INTO spp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","L'à pyi cibilaage canɲcyiige ɲyɛ̀sɔɔge na. Tèni i pi à nɔ kafaage fanŋke na ke, canŋa ɲyiini mpyi na fwore. ");
INSERT INTO spp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pi niŋkaribii mpyi na ŋko piy'á: «Jofoo u sí n‑pa kafaabwɔhe kùuŋkuu n‑láha wuu á fanŋke ɲwɔge na yɛ?» ");
INSERT INTO spp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pi à ta naha pi ɲyiigii yîrige ke, ka pi i kafaabwɔhe ta k'à kùuŋkul'a lwɔ́ fanŋke ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pi à nɔ wani ke, maa jyè fanŋke e, mà nàɲjiiwe ɲya u à vàanvyinge le, mà tɛ̀ɛn kàniŋke na, ka cyeebii si fyá sèl'e. ");
INSERT INTO spp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ka nàɲjiiŋi si pi pyi: «Yii àha vyá mɛ. Nazarɛti Yesu pi à kwòro cige na ke, uru yii na ɲcaa la? U à ɲɛ̀ a fworo kwùŋi i, u ɲyɛ naha mɛ. Yii u buwuŋi tasinnage wíi. ");
INSERT INTO spp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yii sà yi jwo Pyɛri ná cyelempyiibii sanmpil'á “U à kàr'a sà yii sige Galile kùluni i. Yii sí sà u ɲya wani, bà u à fyânha a yi jwo a yaha mɛ.”» ");
INSERT INTO spp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɲyɛ ka cyeebii si fê a fworo fanŋke e. Pi puni mpyi a fyá fo na ɲcyɛ̂ɛnni. Li funmpɛɛnr'à pi pyi pi ɲyɛ a ɲɛn'a yaaga jwo sùpya á mɛ.  ");
INSERT INTO spp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu à ɲɛ̀ a fworo kwùŋi i cibilaage canɲcyiige ɲyɛ̀sɔɔge na ke, Magidala Mariyama na u à fyânha a uye cyêe, ŋge e Yesu à jínabii baashuunniŋi kɔ̀r'a yige ke. ");
INSERT INTO spp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ka uru ceeŋi si ŋkàr'a sà yi jwo Yesu fyèɲwɔhɔshiinbil'á. Pi mpyi a tɛ̀ɛn yyetanhare e, marii myahigii súu. ");
INSERT INTO spp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ŋka tèni i pi a lógo na Yesu à ɲɛ̀ a fworo kwùŋi i, na u wá ɲyii na, na Mariyama à u ɲya ke, pi ɲyɛ a sàa dá mɛ. ");
INSERT INTO spp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lire kàntugo Yesu à uye kɛ̂ɛnŋ'a cyêe u fyèɲwɔhɔshiinbii pìi shuunni na mà pi yaha pi i ŋkɛ̀ɛge sige e. ");
INSERT INTO spp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ka pire si núr'a pa yi jwo pi sanmpil'á, ŋka pire mú saha ɲyɛ a dá mɛ. ");
INSERT INTO spp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kàsanrage na, Yesu à uye cyêe u cyelempyiibii kɛ ná niŋkinŋi na mà pi yaha pi i lyî. U à pi faha pi dánabaare na, ɲaha na yɛ mpii pi à u ɲya u à ɲɛ̀ a fworo kwùŋi i, maa mpyi ɲyii na ke, u cyelempyiibii ɲyɛ a ɲɛn'a dá pire jwumpe na mɛ. ");
INSERT INTO spp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Puru ɲwɔhɔ na, ka Yesu si pi pyi: «Yii a sì diɲyɛŋi ɲùɲyi puni na, yii s'a Jwumpe Nintanmpe yu sùpyire pun'á. ");
INSERT INTO spp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ŋgemu ká dá pu na, maa batize ke, urufoo sí nùmpanŋa ta, ŋka shin maha shin u à pu lógo, maa mpyi u ɲyɛ a dá pu na mɛ, Kile sí urufoo tùn. ");
INSERT INTO spp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mpii pi à dá mii na ke, pire sí raa kakyanhala karigii ɲcyiimu pyi ke, cyire cyi ɲyɛ: pi sí raa jínabii kɔ̀re, pi sí raa yu shɛɛnre tabɛr'e, ");
INSERT INTO spp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","pi sí raa wwòobii cwôre, ŋka pi sì raa yaage pyi pi na mɛ. Pi mɛ́ɛ ká bàha bya, ku sì n‑jà kapii pyi pi na mɛ. Pi sí raa cyeyi tare yampii na, s'a Kile ɲáare pi na pi raa ɲcùuŋi.» ");
INSERT INTO spp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kafooŋi Yesu à puru jwumpe puni jwo a kwɔ̀ ke, ka Kile si u kò a dùrugo nìɲyiŋi na, ka u u sà ntɛ̀ɛn Kile kàniŋɛ cyɛge na. ");
INSERT INTO spp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ɲyɛ ka u cyelempyiibii si ŋkàr'a sà a Jwumpe Nintanmpe yu cyeyi puni i. Kafooŋi mpyi maha pi tɛ̀re báaraŋi puni i, kakyanhala karigii pi mpyi maha mpyi Yesu mɛge na ke, cyire mpyi maha fànha kaan pi jwump'á, mà li cyêe na sèe wi. ");
INSERT INTO spp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Yyaha yyére shinŋi Tofili, karigii cyi à pyi naha wuu yyére ke, cyire cyìi mii ɲyɛ na sémɛni si ntun mu á. Shinɲyahara mú à cyìi sémɛ cyire karigil'e, mà tàanna ná sùpyire cyi jwuŋkanni i, mpiimu ɲyii na cyi pun'à pyi ke, ná pire pi à pa mpyi Jwumpe Nintanmpe jwufeebii ke. Lire e mii mú à li ta kacɛnnɛ maa cyi yyaha cya fo cyi tasiige e maa cyi yal'a sémɛ si ŋkan mu á, ");
INSERT INTO spp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","bà mu si mpyi si li cè na karigii cyi à jwo mu á ke, na cyire na ɲyɛ sèe mɛ. ");
INSERT INTO spp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tèni i Erɔdi mpyi Zhude kùluni saanŋi ke, Kile sáragawwuŋi wà na mpyi Abiya u sáragawwukuruŋke e, u mɛge mpyi Zakari. U cwoŋi mpyi Arɔn tùluge shin, u mɛge sí mpyi Elizabɛti. ");
INSERT INTO spp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pi mú shuunniŋi mpyi a tíi Kafooŋi Kile yyahe taan, pi mpyi a u ɲwɔmɛɛni cû karigii puni i, marii u toŋi kurigii puni ɲaare. ");
INSERT INTO spp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ŋka pyà mpyi pi á mɛ, ɲaha na yɛ Elizabɛti mpyi cijiriŋɛ. U ná u pooŋi mú sí mpyi a lyɛ a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Canŋka Zakari mpyi sáragawwubaaraŋi na Kile yyahe taan, ɲaha na yɛ màhani mpyi a nɔ pi sáragawwukuruŋke na. ");
INSERT INTO spp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mà tàanna ná sáragawwuubii làdaabil'e, pi mpyi maha ŋkyaanlwooni tɛ̀g'a sáragawwuŋi wà cwɔɔnrɔ, ur'a sì jyè Kileɲaarebage funŋke e maa wusunaŋi súugo. Ɲyɛ ka kuru canŋke wuŋi si mpa bɛ̂ Zakari na. ");
INSERT INTO spp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mà u yaha u u wusunaŋi súuge, sùpyire puni mpyi ntàani na na Kile ɲáare. ");
INSERT INTO spp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ka Kafooŋi Kile mɛ̀lɛkɛŋi wà si mpâl'a fworo Zakari na, maa yyére wusunaŋi tasogoge kàniŋɛ cyage na. ");
INSERT INTO spp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakari à u ɲya ke, maa fyá sèl'e. ");
INSERT INTO spp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ka mɛ̀lɛkɛŋi si u pyi: «Ma hà vyá mɛ Zakari, Kile à mu ɲarege lógo. Mu cwoŋi Elizabɛti sí mu kan pùnambile na, maa li mɛge le Yuhana. ");
INSERT INTO spp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Uru pyàŋi ziŋi kani sí n‑pyi mu á funntanga ná múguro kyaa. Li mú sí n‑pyi shinɲyahara á funntanga kyaa, ");
INSERT INTO spp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ɲaha na yɛ u sí n‑pyi shinbwo Kafooŋi Kile yyahe taan. U sì raa sinmpe pà tufiige byii mɛ. Kile Munaani sí u ɲî tèrigii puni i, ali mà u yaha zimbaa. ");
INSERT INTO spp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","U sí Izirayɛli shiinbii niɲyahamii yyaha kɛ̂ɛnŋɛ Kafooŋi pi Kileŋi á. ");
INSERT INTO spp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","U kapyiiŋkii sí n‑pyi Kile tùnntunŋiEli wogigii fiige. Bà Kile Munaani mpyi a fyânha a fànhe kan Eli á mɛ, amuni li sí fànhe kan u á, u u Kafooŋi kuni bégele, u u tiibii ná pyìibii shwɔ̀hɔŋi yaa. Mpii pi à ɲùŋɔ kyán Kile na ke, u sí pire kɛ̂ɛnŋɛ n‑pyi shintiilii, si supyishiŋi wà bégele ɲjaha Kafooŋi yyaha na.» ");
INSERT INTO spp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ka Zakari si jwo mɛ̀lɛkɛŋ'á: «Di mii sí puru sèeŋi cè n‑jwo yɛ? Ɲaha kurugo yɛ mii ná na cwoŋi shìŋ'à tòro zi taan.» ");
INSERT INTO spp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ka mɛ̀lɛkɛŋi si u pyi: «Mii u ɲyɛ Gabiriyɛli. Mii u ɲyɛ Kile taan u tùnnture laage e. U à mii tun mii u pa mpe jwumpe nintanmpe jwo mu á. ");
INSERT INTO spp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mu ɲyɛ a ɲɛn'a tɛ̀ɛn mii ɲwɔmugure taan mɛ, mà li ta nde mii à jwo mu á ke, li sí n‑pyi li tèepyil'e. Lire kurugo mu sí n‑pyi búbu, mà lwɔ́ numɛ na fo mà sà yaa ná li tèepyiini i.» ");
INSERT INTO spp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lire tèni mpyi a sùpyire puni ta ti i Zakari sigili na ŋkànre, ɲaha na yɛ u mpyi a mɔ Kileɲaarebage funŋke e. U mɔŋi mpyi a pi puni pâa. ");
INSERT INTO spp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","U à jà a pa fworo ke, ka u u mpyi búbu, u ɲyɛ a jà a jwo ná pi e mɛ, ka pi i ɲcè na Kile à kani là cyêe u na Kileɲaarebage funŋke e. Ka u u wá na yu ná cyeyi i. ");
INSERT INTO spp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ɲyɛ Zakari sáragawwubaaraŋi canmpyaagil'à fûnŋɔ ke, ka u u ŋkàre pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Canmpyal'à tòro ke, ka u cwoŋi Elizabɛti si laa ta, maa ŋwɔhɔ yiɲyɛ kaŋkuro funŋ'i. Maa jwo uye funŋ'i: ");
INSERT INTO spp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Kile à ɲwɔ mii na ná nde e dɛ! U à mii pyìtambaani silege láha mii na sùpyire ɲyii na.» ");
INSERT INTO spp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ɲyɛ Elizabɛti laani yiŋke baani woge e, ka Kile si u mɛ̀lɛkɛŋi Gabiriyɛli tun Galile kùluni kànhe kà na, ku mɛge ɲyɛ Nazarɛti. ");
INSERT INTO spp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pùcwoŋi wà u mpyi wani, u mɛge mpyi Mariyama. Saanŋi Dawuda tùluge shinŋi Yusufu tàcwo u mpyi u wi. ");
INSERT INTO spp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka mɛ̀lɛkɛŋi si jyè uru pùcwoŋi yyére, maa jwo: «Mii à mu shɛ́ɛre, Kafooŋi Kile à ɲwɔ mu na maa mpyi ná mu i.» ");
INSERT INTO spp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ka puru jwumpe si Mariyama funŋɔ wwòoŋɔ sèl'e, ka u u wá na uye yíbili uru fwùŋi ɲùŋke na. ");
INSERT INTO spp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ka mɛ̀lɛkɛŋi si yi jwo u á: «Ma hà vyá mɛ Mariyama, Kile à ɲwɔ mu na. ");
INSERT INTO spp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mu sí laa ta, li sí n‑si pùnambile, maa li mɛge le Yesu. ");
INSERT INTO spp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","U sí n‑pyi shinbwo, u mɛge sí n‑le Kileŋi nìɲyi wuŋi Jyaŋi. Kafooŋi Kile sí u tulyage Dawuda saanre fànhe kan u á. ");
INSERT INTO spp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","U sí n‑pyi Yakuba shiŋi ɲùŋɔ na fo tèekwombaa. U fànhe sì n‑kwɔ̀ mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ka Mariyama si yi jwo mɛ̀lɛkɛŋ'á: «Di lire sí n‑pyi n‑jwo yɛ? Ɲaha kurugo yɛ mii sàha ŋkwɔ̀ a nɔ̀ cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ka mɛ̀lɛkɛŋi si u pyi: «Kile Munaani sí n‑pa n‑tɛ̀ɛn mu ɲuŋ'i. Kileŋi nìɲyi wuŋi u síŋi sí n‑pyi mbyìmɛ fiige mu ɲuŋ'i. Lire kurugo pyàŋi mu sí n‑si ke, uru sí n‑pyi Kile wu, u mɛge sí n‑le Kile Jyaŋi. ");
INSERT INTO spp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mu cìnmpworocwoŋi Elizabɛti, uru niɲjyeŋkwoŋi mú à laa ta, u sí pùnambile si. Sùpyire mpyi na uru ŋgemu sɔ̂nŋi cijiriŋɛ ke, u laani yibaani woge ku ɲyɛ ŋke. ");
INSERT INTO spp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sèeŋi na, kyaa ɲyɛ na Kile jìni mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ka Mariyama si yi jwo u á: «Kafooŋi bilicwo u ɲyɛ mii, Kile u li pyi mii á bà mu à yi jwo mɛ.» Ka mɛ̀lɛkɛŋi si yîri u taan maa ŋkàre. ");
INSERT INTO spp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Cyire canmpyaagil'e, ka Mariyama si yîr'a fyâl'a kàre ɲaɲyi kùluni i, Zhude kànhe kà na. ");
INSERT INTO spp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maa jyè Zakari pyɛnge e, maa Elizabɛti shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tèni i Elizabɛti à Mariyama fwùŋi lógo ke, ka u pyàŋi si ɲyàha u funŋke e. Ka Kile Munaani si Elizabɛti ɲî, ");
INSERT INTO spp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ka u u jwo fànha na Mariyama á: «Kile à jwó le mu á mà tòro cyeebii puni taan! Pyàŋi mu sí n‑si ke, Kile sí jwó le ur'á mú! ");
INSERT INTO spp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jo u ɲyɛ mii, fo mii Kafooŋi nuŋi yabiliŋi u pa mii yyére yɛ? ");
INSERT INTO spp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ɲaha kurugo yɛ mii sí yi jwo mu á, tèni i mii à mu fwùŋi lógo ke, funntang'à mii pyàŋi pyi u à ɲyàha mii funŋke e. ");
INSERT INTO spp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mu wuun'à ɲwɔ, ɲaha na yɛ kani ɲwɔmɛɛni Kafooŋi Kile à lwɔ́ mu á ke, mu à ɲɛn'a dá lire na.» ");
INSERT INTO spp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ɲyɛ ka Mariyama si jwo: «Mii à Kafooŋi Kile kêe ná na zòmbilini puni i, ");
INSERT INTO spp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mii funŋke naha a táan sèl'e mii Shwofooŋi Kile kurugo. ");
INSERT INTO spp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ɲaha na yɛ mii u ɲyɛ u bilicwoŋi ke, u à ɲɛn'a ɲwɔ mii na, maa kacɛnnɛ pyi mii na, mii ná na cyɛrɛmpe puni i. Mà lwɔ́ numɛ na, tìiŋi nimpaŋi sùpyire puni sí n‑pa raa ŋko na mii wuun'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ɲaha kurugo yɛ Kile Siŋi Punifol'à kabwɔhii pyi mii á, u mɛg'à táan. ");
INSERT INTO spp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mpii pi maha fyáge u na ke, u maha pire ɲùɲaara taa tèrigii puni i, maa kacɛnŋkii pyi pi á. ");
INSERT INTO spp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U maha kakyanhala karigii pyi ná u cyɛge fànha ɲyahaga woge e. Mpii pi ɲyɛ ná yàmpeente funŋke e ke, u maha pire tîn a caala. ");
INSERT INTO spp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","U maha fànhafeebii tîrig'a lwɔ́ pi fànhe ɲuŋ'i, mpii pi à piye tîrige ke, u maha pire dùrugo. ");
INSERT INTO spp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","U maha yacɛnɲyi kaan kategefeebil'á fo maha pi funɲyi ɲíŋɛ. U maha nàfuufeebii cyeŋgaya wuubii yare pi i ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ɲwɔmɛɛni u mpyi a lwɔ́ wuu tulyey'á ke, u à lire fûnŋɔ. U à pa u báarapyiibii Izirayɛli shiinbii tɛ̀gɛ U maha kacɛnŋkii pyi Ibirayima ná u tùlug'á tèrigii puni i.» ");
INSERT INTO spp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ɲyɛ ka Mariyama si ŋkwôro Elizabɛti yyére fo mà nɔ yiɲyɛ taanre fiige na, lire kàntugo maa núr'a kàre u kànhe na. ");
INSERT INTO spp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ɲyɛ Elizabɛti tèetigen'à pa nɔ ke, ka u u si pùnambile. ");
INSERT INTO spp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tèni i Elizabɛti tɛɛnɲɛɛbii ná u cìnmpyiibil'à lógo na Kafooŋi Kile na wá à kacɛnnɛ nimbwoo pyi u na ke, ka li i mpyi u ná pi á funntanga nimbwɔhɔ. ");
INSERT INTO spp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pyàŋi ziŋi canmpyibaatanrewuuni na, ka pi i ŋkàre u takwɔnge e. Pi la mpyi si u tuŋi Zakari mɛge le u na, ");
INSERT INTO spp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ka pyàŋi nuŋi si jwo: «Ɔnhɔ, u mɛge sí n‑le Yuhana.» ");
INSERT INTO spp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ka pi i u pyi: «Ŋka kuru mɛge fiige ɲyɛ mu sùpya na mà dɛ!» ");
INSERT INTO spp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ka pi i Zakari búbu wuŋi kà, maa u yíbe pyàŋi mɛge na. ");
INSERT INTO spp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ka u u pi pyi pi kwɔɔgɔ lwɔ́ a kan ur'á. Pi à pa ná k'e ke, ka u u yi sémɛ ku na: «Pyàŋi mɛge sí n‑le Yuhana» ka li i pi puni pâa. ");
INSERT INTO spp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ɲyɛ lire tèenuuni i, ka Zakari ɲjini si sànha, ka u ɲwɔge si múgo, ka u u wá na yu marii Kile pêre. ");
INSERT INTO spp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ka cyire karigii si u tɛɛnɲɛɛbii ná u kwùumpe shiinbii kàkyanhala, fo mà sà nɔ Zhude ɲaɲyi cyeyi kànyi puni na. Pi puni mpyi na cyire karigii shɛɛnre yu pi bàraɲwɔyi i. ");
INSERT INTO spp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ka lire kani lógofeebii puni si li yaha piye funŋ'i, marii sɔ̂nŋi li na. Pi shin maha shin mpyi na uye yíbili: «Ŋge pyàŋi sí n‑pyi ɲaha shi bɛ?» Sèeŋi na, Kafooŋi Kile cyɛge mpyi ná u e. ");
INSERT INTO spp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ɲyɛ ka Kile Munaani si pyàŋi tuŋi Zakari ɲî, maa u pyi u à mpe jwumpe jwo: ");
INSERT INTO spp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","69","«Wuu Kafooŋi Kile kêe, Izirayɛli shiinbii u Kileŋi, ɲaha na yɛ u à Shwofoo niɲcɛnŋɛ yige u báarapyiŋi Dawuda tùluge e mà kan wuu á. U à pa si mpa u shiinbii tɛ̀gɛ si pi ɲùŋɔ wwû bilere e. ");
INSERT INTO spp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Uru shɛɛnre Kile tùnntunmpii mpyi a jwo fo tèemɔni i ");
INSERT INTO spp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","na u sí wuu yige wuu zàmpɛɛnbii cye e, wuu kyal'à pɛn mpiimu á ke, si wuu shwɔ pire na. ");
INSERT INTO spp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Lire cye kurugo, u à kacɛnnɛ pyi wuu tulyeyi na. Nde u mpyi a jwo u tunmbyaare tooy'e ke, u à lire pyi. ");
INSERT INTO spp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","U mpyi a ɲwɔmɛɛni ndemu lwɔ́ wuu tulyage Ibirayima á, na u sí wuu yige wuu zàmpɛɛnbii cye e, bà wuu si mpyi s'a uru pêre fyagara baa mɛ, u à lire pyi. ");
INSERT INTO spp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kile à lire pyi bà wuu si mpyi s'a katiigii pyi u yyahe taan, si ntaha uru kanni fye e wuu shìŋi puni i mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lire kàntugo ka Zakari si jwo u pyàŋ'á: «Mii pyàŋi, pi sí n‑pa raa mu pyi Kileŋi nìɲyi wuŋi tùnntunŋi, ɲaha na yɛ mu sí n‑pa ɲaara Kafooŋi yyaha na, si u kuni yaa. ");
INSERT INTO spp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mu sí yi yyaha jwo Kile wuubil'á na u sí pi kapegigii yàfa pi na, si pi shwɔ. ");
INSERT INTO spp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wuu Kileŋi ɲùɲaare ná u kacɛnŋkii kurugo, u à bɛ̀ɛnmpe yige wuu á mà yîri nìɲyiŋi na, mu à jwo canŋa ɲyiini nivworovɔnni. ");
INSERT INTO spp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mpii pi mpyi a tɛ̀ɛn kwùŋi numpini i ke, u à bɛ̀ɛnmpe yige pir'á. U à yyeɲiŋke kuni le wuu taan.» ");
INSERT INTO spp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ɲyɛ uru pyàŋi mpyi na lyɛge, Kile Munaani sí i fànhe kaan u á. Ka u u ŋkwôro sige funŋke e fo mà sà nɔ u tèecyeeni na Izirayɛli shiinbii na. ");
INSERT INTO spp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ɲyɛ tèni là à pa nɔ, ka saanbwɔhe Ogusiti si tùnnturo tun na sùpyire puni mɛyi yi sémɛ. ");
INSERT INTO spp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lire l'à pyi mɛsemɛni niɲcyiini, l'à pyi mà Kirinisi ta Siri kìni ɲùŋɔ na. ");
INSERT INTO spp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sùpyire puni mpyi na sì na pi mɛyi sémɛni pi tukanyi na. ");
INSERT INTO spp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ka Yusufu si yîri Nazarɛti kànhe e Galile kùluni i mà kàre saanŋi Dawuda kànhe na, Bɛtilɛhɛmu i, Zhude kùluni i, ɲaha na yɛ Yusufu mpyi Dawuda tùluge sùpya. ");
INSERT INTO spp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","U ná u tàcwoŋi Mariyama mpyi a kàre wani mɛyi zèmɛŋi kurugo. Mariyama laa wuŋi u mpyi. ");
INSERT INTO spp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mà pi yaha Bɛtilɛhɛmu i, ka Mariyama laani tèesini si nɔ. ");
INSERT INTO spp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ka u u u jyaŋi niɲcyiiŋi si, maa u le vàanɲyi i mà sínniŋɛ yatɔɔre yabyage funŋ'i, ɲaha na yɛ pi mpyi a tatirige ta nàmpwuunbii tashwɔnge e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ɲyɛ mpànahabii pìi na mpyi puru kwùumpe e. Pi mpyi maha shwùun ɲyii na sige e, marii pi mpàabii saɲcwɔnŋi sigili. ");
INSERT INTO spp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ka Kafooŋi Kile mɛ̀lɛkɛŋi wà si uye cyêe pi na, ka Kafooŋi Kile sìnampe bɛ̀ɛnmpe si mîni kuru cyage e mà pi kwûulo, ka pi i fyá sèe sèl'e. ");
INSERT INTO spp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ka mɛ̀lɛkɛŋi si yi jwo pi á: «Yii àha vyá mɛ, mii sí múguro kyaa nimbwoo jwo yii á, lire sí n‑pyi yii shiŋi puni wuu. ");
INSERT INTO spp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Niɲjaa numpilage yabiliŋi i, Shwofol'à si yii á Dawuda kànhe na. Uru u ɲyɛ Kile Niɲcwɔnrɔŋi ná Kafooŋi. ");
INSERT INTO spp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Amɛ yii sí li cè, yii sí pìnmpinɲyɛga ta pi à le a sínniŋɛ vàanɲyi i yatɔɔre yabyage k'e.» ");
INSERT INTO spp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lire tèni i, ka mɛ̀lɛkɛkuruŋɔ nimbwɔhɔ si mpâl'a pa bínni uru mɛ̀lɛkɛŋi taan, marii Kile pêre na: ");
INSERT INTO spp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Pèente ti taha Kile na nìɲyiŋi na. Mpii kyaa l'à táan Kile á ke, yyeɲiŋke ku pyi ɲìŋke na pire shwɔhɔl'e.» ");
INSERT INTO spp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tèni i mɛ̀lɛkɛɛbil'à yîri mpànahabii taan mà dùgo nìɲyiŋi na ke, ka mpànahabii si yi jwo piy'á: «Yii a wá, wuu u shà Bɛtilɛhɛmu i, Kafooŋi Kile à wuu pyi wuu à kani ndemu cè ke, wuu u sà lire wíi.» ");
INSERT INTO spp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ka pi i fyâl'a kàr'a sà Mariyama ná Yusufu ta wani, maa pìnmpinɲyɛge nizinnage ɲya yatɔɔre lùbyakwɔɔge funŋ'i. ");
INSERT INTO spp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pi à pìnmpinɲyɛge ɲya ke, jwumpe Kile mɛ̀lɛkɛŋi mpyi a jwo pi á ku kyaa na ke, ka pi i puru puni jwo, ");
INSERT INTO spp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ka li i mpyi kakyanhala pu lógofeebii pun'á. ");
INSERT INTO spp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ŋka Mariyama wi ke, ur'à cyire karigii yaha u yákiliŋi na, marii sɔ̂nŋi cyi na. ");
INSERT INTO spp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lire kàntugo ka mpànahabii si núr'a kàre pi tayirige e, pi mpyi na Kile pêre marii u kêre pi karigii nindogogii ná niɲyagii kurugo. Cyire karigil'à pyi bà Kile mɛ̀lɛkɛŋi mpyi a cyi jwo mɛ. ");
INSERT INTO spp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pyàŋi canzege canmpyibaatanrewuuni na, ka pi i u kwɔ̀n, maa u mɛge le Yesu. Kile mɛ̀lɛkɛŋi mpyi a kuru mɛge le pyàŋi na mà jwo u nuŋi u u laani ta ke. ");
INSERT INTO spp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ɲyɛ mà tàanna ná MusaSaliyaŋi i, sìiveente canmpyaagil'à kwɔ̀ ke, ka Yusufu ná Mariyama si ŋkàre Zheruzalɛmu kànhe e ná pyàŋi i mà sà ŋkan Kafooŋi Kile á, ");
INSERT INTO spp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","bà l'à sémɛ Kafooŋi Kile Saliyaŋi i na: «Pùnampyire niɲcyiire puni sí n‑pyi Kafooŋi Kile woro.» ");
INSERT INTO spp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Sárage kyaa Kafooŋi Kile mpyi a jwo Saliyaŋi i mà yyaha tíi ná sìivooŋi tufeempe kani i ke, pi à kuru wwû mú. Kuru sárage ku mpyi: «Sanmpanra shuunni, lire ɲyɛ mɛ sanmpanmpwɔrɔɲjaara shuunni.» ");
INSERT INTO spp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nàŋi wà na mpyi wani Zheruzalɛmu i, u mɛge mpyi Simiyɔn. U mpyi a tíi maa fyáge Kile na. U mpyi na Izirayɛli shiinbii Tɛgɛfooŋi mpaŋi sigili. Kile Munaani mpyi ná u e. ");
INSERT INTO spp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","L'à li cyêe u na na u sì n‑kwû ná u ɲyɛ a Kafooŋi Kile Niɲcwɔnrɔŋi ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ɲyɛ tèni i Yesu sifeebil'à sà nɔ ná u e Kileɲaarebage e Kile Saliyaŋi karigii mɛɛ na ke, ka Kile Munaani si Simiyɔn yyaha cû a lèŋɛ Kileɲaarebage e. ");
INSERT INTO spp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ka u u pìnmpinɲyɛge cû u cyeyi i, maa Kile kêe na: ");
INSERT INTO spp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Kafooŋi Kile, mii u ɲyɛ mu báarapyiŋi ke, numɛ mu sí n‑jà mii yaha mii u kwû yyeɲiŋke e, nde mu à jwo ke, mu à lire pyi a kwɔ̀, ");
INSERT INTO spp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ɲaha na yɛ Shwofooŋi mu à tun ke, mii ɲyiin'à uru ɲya niɲjaa. ");
INSERT INTO spp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ŋge mu à kan diɲyɛŋi sùpyire shiŋi puni kurugo ke, ");
INSERT INTO spp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","u sí n‑pyi bɛ̀ɛnmɛ mpemu pu sí mu cyêe supyishiŋi puni na ke, Izirayɛli shiinbii pi ɲyɛ mu wuubii ke, si pire mɛge pyi ku táan.» ");
INSERT INTO spp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Puru jwumpe Simiyɔn mpyi a jwo Yesu kyaa na ke, puru mpyi a Yesu sifeebii kàkyanhala. ");
INSERT INTO spp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ka Simiyɔn si jwó le pi á, maa yi jwo Yesu nuŋi Mariyama á: «Ŋge pyàŋi kapani li ɲyɛ Izirayɛli shiinbil'á, mà shinɲyahara cyán si shinɲyahara yîrige. U sí n‑pyi kacyeele, ŋka pìi sí n‑cyé li na. ");
INSERT INTO spp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Lire pyiŋkanni na, supyiɲyahara funzɔnŋɔre sí n‑yige cyíinŋi na. Mu wi ke Mariyama, kani là sí n‑pa mu súugo ma zòŋi na, mu à jwo kàshikwɔnŋwɔɔ l'à mu sú u na.» ");
INSERT INTO spp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ciɲjyeŋi wà na mpyi wani, u mpyi a yyee beecyɛɛre ná sicyɛɛre (84) kwɔ̀, uru na mpyi Kile tùnntunŋɔ, u mɛge mpyi Ana. U tuŋi mɛge mpyi Fanuwɛli. Ashɛri tùluge sùpya u mpyi u wi. Uru ceeŋi mpyi a yyee baashuunni pyi nàmbage e, ka u pooŋi si ŋkwû. Ka u u ŋkwôro nɔ̀ baa. Pìlaga bâra canŋa na, u mpyi maha mpyi súnleni ná Kileɲarege na Kileɲaarebage e. ");
INSERT INTO spp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Uru ciɲjyeŋi mú à sà Yesu sifeebii ta wani, maa Kile kêe, mpii pi mpyi na Zheruzalɛmu kànhe shiinbii ɲùŋgwuure sigili ke, maa Yesu kyaa jwo pir'á. ");
INSERT INTO spp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ɲyɛ Yusufu ná Mariyama à Kafooŋi Kile Saliyaŋi kurigii puni ɲaara a kwɔ̀ ke, maa núr'a kàre Nazarɛti i, pi kànhe na, Galile kùluni i. ");
INSERT INTO spp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pyàŋi mpyi na lyɛge ná fànhe e, u yákiliŋi mpyi a pêe sèl'e. Kile mpyi a ɲwɔ u na maa mpyi ná u e. ");
INSERT INTO spp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Yyee maha yyee, Yesu sifeebii mpyi maha ŋkàre ná u e Zheruzalɛmu kànhe e bilereŋkwoŋi kataann'á mà tàanna ná Yahutuubii làdaŋi i. Ɲyɛ yyeeni kataann'á pi à kàre mà Yesu shìŋi yaha yyee kɛ ná shuunni na ke, ");
INSERT INTO spp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","lire kataann'à pa ŋkwɔ̀, ka pi i núru na ŋkɛ̀ɛge ke, ka Yesu si ntɛ̀ɛn Zheruzalɛmu i u sifeebii pàama. ");
INSERT INTO spp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pi mpyi na sɔ̂nŋi na Yesu ná pire shɛ̀rɛfeebii pi sí n‑ta pi i ma siɲcyan. Pi à ɲaara a canŋke kwɔ̀, pi ɲyɛ a u ɲya mɛ, ka pi i wá na u caa pi cìnmpyiibii ná pi shincempii shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pi à u cya a kànha pire shwɔhɔl'e ke, maa núru na u caa na ŋkɛ̀ɛge Zheruzalɛmu i. ");
INSERT INTO spp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Canmpyaa taanre tatoroge e, ka pi i sà u ta u à tɛ̀ɛn Kileɲaarebage e Kile Saliyaŋi cyelentiibii shwɔhɔl'e, marii pi jwumpe núru, marii pi yíbili. ");
INSERT INTO spp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mpii pi mpyi na u jwumpe núru ke, u yákilifente ná u ɲwɔshwɔɔre mpyi a pire puni kàkyanhala. ");
INSERT INTO spp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tèni i u sifeebil'à u ɲya ke, ka li i mpâa pi e, ka u nuŋi si u pyi: «Yesu, ɲaha mu à pyi ná wuu e amɛ yɛ? Mii ná mu tuŋi funmpɛn wuubii mpyi na mu caa.» ");
INSERT INTO spp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ka u u pi pyi: «Ɲaha na yii ɲyɛ na mii caa yɛ? Yii ɲyɛ a cè na mii à yaa mii u a na Tuŋi karigii cwɔɔnre mà?» ");
INSERT INTO spp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ŋka u sifeebii mpyi a puru jwumpe ɲwɔhe cè mɛ. ");
INSERT INTO spp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ɲyɛ ka Yesu si núr'a kàre ná u sifeebil'e Nazarɛti kànhe e. U mpyi a pi ɲwɔmɛɛni cû. Ka u nuŋi si cyire karigii puni yaha uye funŋ'i, marii sɔ̂nŋi cyi na. ");
INSERT INTO spp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu mpyi na lyɛge, là sí i bârali u yákilifente na. U kyaa mpyi a táan Kile á, maa ntáan sùpyir'á mú. ");
INSERT INTO spp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mà saanbwɔhe Tibɛri yaha u saanre yyee kɛ ná kaŋkuro wuuni na, lir'à Pɔnse Pilati ta Zhude kùluni ɲùŋɔ na, Erɔdi sí ɲyɛ Galile wuuni ɲùŋɔ na, u yyahafooŋi Filipi sí ɲyɛ Iture ná Tirasoniti kùligii ɲùŋɔ na, Lizaniyasi sí ɲyɛ Abilɛni kùluni ɲùŋɔ na, ");
INSERT INTO spp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ana ná Kayifu mú sí ɲyɛ sáragawwuubii ɲùŋufente na, lire yyeeni mà Zakari jyaŋi Yuhana yaha síwage e, Kile à u tun u sà a uru jwumpe yu. ");
INSERT INTO spp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ka u u ŋkàre Zhurudɛn baŋi ɲwɔge kùluni puni i, mà sà a ɲaare na puru jwumpe yu sùpyir'á. U mpyi na yi yu pi á: «Yii yii toroŋkanni kɛ̂ɛnŋɛ, yii batize, bà Kile si mpyi si yii kapegigii yàfa yii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nde Yuhana mpyi na mpyi amuni ke, lire na mpyi a sémɛ tèecyiini Kile tùnntunŋi Ezayi sémɛŋi i na: «Sùpya mɛjwuu sí n‑pa raa fwore síwage e fànha na “Yii kuni yaa Kafooŋi mɛɛ na, yii kumpyɛrɛ nintiire yaa u á, ");
INSERT INTO spp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","yii i kacyeyi puni ɲî a tàanna, yii i ɲaɲyi ná mpògigii puni cɛɛg'a tàanna, kurigii cyi à nahana ke, yii i cyire yal'a tíi, kurigii cyi à ɲáhara ke, yii i cyire yal'a ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lire ká mpyi, sùpyire puni sí li ɲya na Kile u ɲyɛ Shwofooŋi.”» ");
INSERT INTO spp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ɲyɛ ka shinɲyahara si wá na ma Yuhana yyére si mpa batize, ka u u pi pyi: «Yii màcwɔn fiige sùpyiibii, jofoo u à yii pyi na batizeliŋi kanni sí n‑jà yii shwɔ Kile lùyirini nimpani na yɛ? ");
INSERT INTO spp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yii a katiigii pyi, lire sí li cyêe na yii zòompil'à kɛ̂ɛnŋɛ. Yii àha zìi raa sɔ̂nŋi kanna na yii tulyage ku ɲyɛ Ibirayima mà dɛ! Ɲaha na yɛ mii sí yi jwo yii á, Kile sí n‑jà ɲje kafaayi kɛ̂ɛnŋɛ n‑pyi Ibirayima ɲampyire. ");
INSERT INTO spp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yii li cè na kaciig'à cél'a yaha cire ndìre taan. Cige maha cige ku ɲyɛ, ku ɲyɛ na yasɛrɛ niɲcɛnnɛ pyi mɛ, kuru sí n‑kwɔ̀n n‑wà nage e.» ");
INSERT INTO spp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɲyɛ ka sùpyire si Yuhana yíbe: «Lire tèni i ke, ɲaha wuu à yaa wuu pyi bɛ?» ");
INSERT INTO spp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ka u u pi pyi: «Vàanntinnyɛ shuunni ɲyɛ ŋgemu á ke, urufol'à yaa u kà kan kà baafooŋ'á. Ŋgemu u ɲyɛ ná yalyire e ke, urufol'à yaa u tà kan kategefooŋ'á mú.» ");
INSERT INTO spp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɲyɛ múnalwɔɔre shwofeebii pi mpyi a pa mpa batize ke, ka pire mú si Yuhana yíbe: «Cyelentuŋi, ɲaha wuu à yaa wuu pyi bɛ?» ");
INSERT INTO spp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ka u u pi pyi: «Múnalwɔɔre ɲwɔge pi à pyi yii a shuu sùpyir'á ke, yii àha wyɛ́rɛ shwɔ wà na si ntòro kuru ɲwɔge taan mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ka sòrolashiibii pìi mú si u yíbe: «Wuu de? Ɲaha wuu à yaa wuu pyi yɛ?» Ka u u pi pyi: «Yii àha sùpyaŋi wà tufiige wyɛ́rɛ cyán zhwɔ u na mɛ, yii àha vini ntaha wà na mú mɛ. Ŋka yii sàraŋi u yii funɲyi ɲíŋɛ.» ");
INSERT INTO spp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɲyɛ sùpyire puni sɔ̀nŋɔre mpyi a taha Kile Niɲcwɔnrɔŋi nimpaŋi kani na, uru ŋgemu u sí n‑pa pi shwɔ ke. Lire e pi mpyi na ŋko piye funŋ'i: «Tá Yuhana bà u à yaa u ta u wi mɛ?» ");
INSERT INTO spp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mà pi yaha ná tire sɔ̀nŋɔre e piye funŋ'i, ka Yuhana si pi pyi: «Mii wi ke, mii na yii batizeli lwɔhe e kanna. Ŋka wà sí n‑pa mii kàntugo, uru tayyéreg'à fànha tò mii woge na. Ali mà u tanhaɲyi mɛɛre sànha, mii ɲùŋk'à cyɛ́rɛ lire mpyiŋi i. Uru u sí n‑pa raa yii batizeli ná Kile Munaani ná nage e. ");
INSERT INTO spp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","U ntanhe ɲyɛ u cye e, u u u sùmaŋi nimbwɔnŋi fwu. U sí sùmapyaŋi le u bwùunni i, si sìmwɔhɔŋke súugo nafugombaage e.» ");
INSERT INTO spp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ɲyɛ Yuhana à yɛrɛyɛ niɲyahaya kan sùpyir'á sahaŋki Yesu kyaa na. ");
INSERT INTO spp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Saanŋi Erɔdi mpyi a u sìɲɛɛŋi cwoŋi Erɔdiyadi kwɔ̀n a lwɔ́. Mà bâra lire na, u mpyi a kapyimbaagii ɲcyiimu pyi sahaŋki ke, ka Yuhana si u cɛ̂ɛgɛ cyire puni na. ");
INSERT INTO spp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lire ɲyɛ a jà a bɛ̂ Erɔdi á mɛ, ka u u kapiini là bâra là na, maa Yuhana cû a le kàsuŋi i. ");
INSERT INTO spp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ɲyɛ mà Yuhana Batizelipyiŋi yaha u sàha ŋkwɔ̀ a le kàsuŋi i mɛ, canŋka sùpyire puni mpyi na ma u yyére marii batizeli, ka Yesu mú si mpa batize, maa Kile ɲáare. Mà u yaha kuru ɲarege na, ka nìɲyiŋi si múgo. ");
INSERT INTO spp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ka Kile Munaani si liye pyi mpánmpɔrɔgɔ fiige mà tîg'a tɛ̀ɛn Yesu na, ka mɛjwuu si fworo nìɲyiŋi i na: «Mii Jyaŋi u ɲyɛ mu, mu kan'à waha mii na sèl'e. Mu kapyiiŋkil'à táan mii á mú.» ");
INSERT INTO spp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tèni i Yesu à báaraŋi sìi ke, u shìŋi mpyi a yyee beɲjaaga ná kɛ kwɔ̀. Sùpyire mpyi na sɔ̂nŋi na Yusufu jya u ɲyɛ u wi. Yusufu yabiliŋ'à fworo Aheli i. ");
INSERT INTO spp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Aheli à fworo Matati i. Matati à fworo Levi i. Levi à fworo Mɛlɛki i. Mɛlɛki à fworo Zhanayi i. Zhanayi à fworo Yusufu i. ");
INSERT INTO spp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu à fworo Maticya i. Maticya à fworo Amɔsi i. Amɔsi à fworo Nahumu i. Nahumu à fworo Ɛsili i. Ɛsili à fworo Nagayi i. ");
INSERT INTO spp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi à fworo Maati i. Maati à fworo Maticya i. Maticya à fworo Sɛmɛ i. Sɛmɛ à fworo Zhosɛki i. Zhosɛki à fworo Zhoda i. ");
INSERT INTO spp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zhoda à fworo Zhwɔnani i. Zhwɔnani à fworo Ɛrɛsa i. Ɛrɛsa à fworo Zorobabɛli i. Zorobabɛli à fworo Salatiyɛli i. Salatiyɛli à fworo Nɛri i. ");
INSERT INTO spp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛri à fworo Mɛlɛki i. Mɛlɛki à fworo Adi i. Adi à fworo Kosamu i. Kosamu à fworo Elimadan i. Elimadan à fworo Ɛri i. ");
INSERT INTO spp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛri à fworo Zhosuwe e. Zhosuwe à fworo Eliyɛzɛri i. Eliyɛzɛri à fworo Zhorimu i. Zhorimu à fworo Matati i. Matati à fworo Levi i. ");
INSERT INTO spp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi à fworo Simiyɔn i. Simiyɔn à fworo Zhuda i. Zhuda à fworo Yusufu i. Yusufu à fworo Zhonamu i. Zhonamu à fworo Eliyakimu i. ");
INSERT INTO spp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimu à fworo Mɛlɛya i. Mɛlɛya à fworo Mɛna i. Mɛna à fworo Matata i. Matata à fworo Natan i. Natan à fworo Dawuda i. ");
INSERT INTO spp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawuda à fworo Zhese e. Zhese à fworo Obɛdi i. Obɛdi à fworo Bwazi i. Bwazi à fworo Salamɔni i. Salamɔni à fworo Naasun i. ");
INSERT INTO spp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasun à fworo Aminadabu i. Aminadabu à fworo Adimi i. Adimi à fworo Arini i. Arini à fworo Esirɔmu i. Esirɔmu à fworo Pɛrɛzi i. Pɛrɛzi à fworo Zhuda i. ");
INSERT INTO spp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zhuda à fworo Yakuba i. Yakuba à fworo Ishaka i. Ishaka à fworo Ibirayima i. Ibirayima à fworo Teraka i. Teraka à fworo Nakwɔri i. ");
INSERT INTO spp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakwɔri à fworo Serugi i. Serugi à fworo Erewu i. Erewu à fworo Pɛlɛgi i. Pɛlɛgi à fworo Ebɛri i. Ebɛri à fworo Shelaki i. ");
INSERT INTO spp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelaki à fworo Kayinamu i. Kayinamu à fworo Arifasadi i. Arifasadi à fworo Shɛmu i. Shɛmu à fworo Nuhu i. Nuhu à fworo Lemɛki i. ");
INSERT INTO spp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemɛki à fworo Mɛtusala i. Mɛtusala à fworo Enɔki i. Enɔki à fworo Zherɛdi i. Zherɛdi à fworo Malalɛli i. Malalɛli à fworo Kena i. ");
INSERT INTO spp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kena à fworo Enɔsi i. Enɔsi à fworo Sɛti i. Sɛti à fworo Adama i. Adama à fworo Kile e. ");
INSERT INTO spp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ɲyɛ mà Yesu yaha u à ɲî Kile Munaani na, u à yîri Zhurudɛn baŋi ɲwɔge na mà kàre síwage e. ");
INSERT INTO spp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","U à canmpyaa beeshuunni pyi síwage e, u ɲyɛ a yafyin lyî mɛ, ka katege si u ta. Cyire canmpyaagii funŋke e, ka Sitaanniŋi si file u na maa ɲcaa si u sɔ̀n ŋgà kapii na. ");
INSERT INTO spp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɲyɛ ka u u Yesu pyi: «Ná Kile Jyaŋi sí u ɲyɛ mu, yi jwo ŋke kafaag'á ku kɛ̂ɛnŋ'a pyi bwúuru.» ");
INSERT INTO spp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ka Yesu si u pyi: «Y'à sémɛ Kile Jwumpe Semɛŋi i “Yalyire kanni bà ti ɲyɛ na sùpyaŋi ɲwɔ caa mɛ.”» ");
INSERT INTO spp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lire kàntugo ka Sitaanniŋi si dùgo ná u e nìɲyiŋi na, maa diɲyɛŋi kìrigii puni cyêe u na yyerege niŋkin, ");
INSERT INTO spp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","maa u pyi: «Mii sí ɲcyii kìrigii puni ɲùŋufente ná cyi nàfuuŋi kan mu á, ɲaha na yɛ t'à kan mii á. Shinŋi u à táan mii á ke, ur'á mii sí ti kan. ");
INSERT INTO spp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mu aha ɲɛn'a niŋkure sín maa mii pêe, yire puni sí n‑pyi mu wuyo.» ");
INSERT INTO spp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ka Yesu si u pyi: «Y'à sémɛ Kile Jwumpe Semɛŋi i: “Ta ma niŋkure sínni ma Kafooŋi Kile á, maa uru kanni pêre.”» ");
INSERT INTO spp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lire kàntugo ka Sitaanniŋi si ŋkàre ná Yesu i Zheruzalɛmu kànhe e, maa sà dùgo ná u e Kileɲaarebage ɲùɲcyage e, maa yi jwo u á: «Ná Kile Jyaŋi sí u ɲyɛ mu, kwɔ̀n a cwo ɲìŋke na, ");
INSERT INTO spp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ɲaha na yɛ y'à sémɛ Kile Jwumpe Semɛŋi i: “Kile sí u mɛ̀lɛkɛɛbii tun, pi a mu kàanmucaa. ");
INSERT INTO spp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pi sí mu cwɔhɔ ná pi cyeyi i, bà li si mpyi kafaaga kà ŋkwɔ̀ mu tɔɔge kà bânni mɛ.”» ");
INSERT INTO spp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ka Yesu si u pyi: «Y'à sémɛ Kile Jwumpe Semɛŋi i “Ma hà raa ma Kafooŋi Kile ɲwɔ cwôre mɛ.”» ");
INSERT INTO spp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ɲyɛ Sitaanniŋi à Yesu sɔ̀n a kànha shiŋi puni u kapii pyi ke, maa yîri u taan maa u yaha na tèni labɛrɛ sigili. ");
INSERT INTO spp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lire kàntugo ka Yesu si núr'a kàre Galile kùluni i. Kile Munaani fànhe mpyi u e sèl'e. Ka u mɛge si fworo lire kùluni puni i. ");
INSERT INTO spp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","U mpyi na Jwumpe Nintanmpe yu sùpyir'á Kile Jwumpe kàlambayi i, ka tire puni si wá na u mɛtanga yiri. ");
INSERT INTO spp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ka Yesu si ŋkàr'a sà nɔ Nazarɛti i. Kuru kànhe na u à lyɛ. Canŋɔŋke e, ka u u jyè Kile Jwumpe kàlambage e bà u mpyi maha ntêe na li pyi mɛ, maa yîr'a yyére si Kile Jwumpe kâla. ");
INSERT INTO spp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ka pi i Kile tùnntunŋi Ezayi sémɛŋi kan u á, ka u u u ɲwɔ múgo maa cyage kà kâla: ");
INSERT INTO spp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Kafooŋi Kile Munaani ɲyɛ mii ɲuŋ'i. U à mii cwɔɔnrɔ na mii u pa Jwumpe Nintanmpe jwo fòŋɔfeebil'á, si kàsujyiibii ɲjahaŋi kyaa jwo pi á, si fyinmpii ɲyiigii mùgoŋi kyaa jwo pi á, mpii pi ɲyɛ cwɔ̀nrɔmpe e ke, si pire yige pi kyéregefeebii cye e, ");
INSERT INTO spp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tèni i Kafooŋi Kile sí ɲwɔ sùpyire na si kacɛnnɛ pyi ti na ke, si lire kyaa jwo.» ");
INSERT INTO spp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lire kàntugo ka Yesu si Kile Jwumpe Semɛŋi ɲwɔ tò maa u kan Kile Jwumpe kàlambage kacwɔnrɔŋ'á, maa ntɛ̀ɛn. Ka sùpyire puni si ti ɲyiigii le u e. ");
INSERT INTO spp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ka Yesu si yi jwo pi á: «Kile Jwumpe yii à lógo numɛ ke, pur'à fûnŋɔ yii ɲyii na niɲjaa.» ");
INSERT INTO spp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pi puni mpyi na u mɛtange yu. Jwumpe u à jwo ke, ka puru si mpyi kakyanhala pi pun'á. Ka pi i wá na yi yu piye shwɔhɔl'e: «Taha Yusufu jyaŋi bà mɛ?» ");
INSERT INTO spp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ka Yesu si pi pyi: «Mii à li cè na yii sí nde tàanlini jwo n‑wà mii na “Wempyiŋi, maye cùuŋɔ ma yabiliŋi” si mii cɛ̂ɛge na kakyanhala karigii yii à lógo na mii à pyi Kapɛrɛnamu kànhe e ke, na ɲaha na mii ɲyɛ a cyire fiige pyi naha na tukanhe na mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Maa núr'a jwo pi á: «Sèeŋi na mii sí yi jwo yii á, Kile tùnntunŋi wà tufiige maha le ɲjire e u tukanhe e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ŋka sèeŋi na mii sí yi jwo yii á, Kile tùnntunŋi Eli tìiŋi i, leŋkwucyeebii mpyi a ɲyaha Izirayɛli kìni i. Yyee taanre ná yiɲyɛ baani funŋ'i zànhe ɲyɛ a pa mɛ, ka katibwɔhɔ si ɲcwo kìni puni na. ");
INSERT INTO spp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ŋka Kile ɲyɛ a Eli tun Izirayɛli leŋkwucwoŋi wà yyére mɛ, fo kìni labɛrɛ wu, uru mpyi Sarɛpita kànhe na, Sidɔn kùluni i. ");
INSERT INTO spp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mà bâra lire na, Kile tùnntunŋi Elize tìiŋi i, tògofee niɲyahamii na mpyi Izirayɛli i, ŋka pi wà ɲyɛ a pa Elize yyére si ticuumpe ta mɛ, fo kìni labɛrɛ wu, u mɛge mpyi Nama, Siri kìni shin u mpyi u wi.» ");
INSERT INTO spp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mpii puni pi mpyi Kile Jwumpe kàlambage e ke, tèni i pir'à puru jwumpe lógo ke, ka pi lùgigii si yîri sèl'e. ");
INSERT INTO spp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ka pi i yîri, maa Yesu kɔ̀r'a yige kànhe e. Pi kànhe mpyi a cyán ɲaŋke kà ɲuŋ'i, ka pi i ŋkàre ná u e ɲaŋke ɲùɲcyage e, si u ŋɔɔŋɔ ɲcyán ɲaŋke kacyage e. ");
INSERT INTO spp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ka Yesu si pi paha a fworo. ");
INSERT INTO spp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ka Yesu si ŋkàre Galile kùluni kànhe kà na, kuru mɛge ɲyɛ Kapɛrɛnamu, maa wá na sùpyire kâlali canŋɔŋke e. ");
INSERT INTO spp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ka u kàlaŋi si sùpyire kàkyanhala, ɲaha na yɛ u mpyi na pi kâlali ná Kile sífente e. ");
INSERT INTO spp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lire tèni i, jínacyanŋi wà mpyi wani Kile Jwumpe kàlambage e, ka uru si jwo fànha na: ");
INSERT INTO spp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ei! Nazarɛti kànhe shinŋi Yesu, ɲaha shi ku ɲyɛ wuu ná mu shwɔhɔl'e yɛ? Mu à pa mpa wuu shi bò la? Mii à mu cè, ŋge u à fworo Kile e ke, uru u ɲyɛ mu!» ");
INSERT INTO spp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ka Yesu si fànha cyán jínaŋi na: «Ma ɲwɔge tò! Maa fworo ŋge nàŋi i!» Ka jínaŋi si nàŋi cyán sùpyire shwɔhɔl'e, maa fworo u e. U ɲyɛ a kapii pyi u na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ka lire si sùpyire puni kàkyanhala fo ti na yu tiy'á: «Mpe ɲyɛ jwumɔ dɛ! U maha fànha cyáan jínabii na ná u sífente e, pi a sì wá na fwore pifeebil'e.» ");
INSERT INTO spp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ka Yesu mɛge si fworo lire kùluni puni i. ");
INSERT INTO spp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ka Yesu si fworo Kile Jwumpe kàlambage e, mà kàre Simɔ pyɛngɛ. U à sà Simɔ nafeɲcwoŋi ta u à sínni cifwuro cye e. Ka pi i li cya Yesu á, u pa ɲwɔ u na. ");
INSERT INTO spp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ka Yesu si file u na, maa fànha cyán cifwure na, ka ti i láha u na. Ka u u ntíl'a yîri na sore pi á. ");
INSERT INTO spp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Canŋaɲyiicwoore na, yama shi maha shi pu mpyi kànhe e ke, ka pi i mpa ná pire puni i Yesu yyére. Ka u u u cyeyi taha pi puni niŋkin niŋkinŋi na, maa pi cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","U mpyi na jínacyaanbii niɲyahamii jínahii kɔ̀re na yige pi e. Pire jínabii mpyi na yu fànha na: «Kile Jyaŋi u ɲyɛ mu!» Ŋka Yesu mpyi maha fànha cyáan pi na, maa jwumpe kwùun pi na, ɲaha na yɛ pi mpyi a cè na uru u ɲyɛ Kile Niɲcwɔnrɔŋi. ");
INSERT INTO spp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ɲyɛ ɲyɛ̀g'à pa múgo ke, ka u u fwor'a kàre sige funŋke e. Shinɲyahara mpyi a fworo na u caa. Pi à pa u cya a ɲya ke, ka pi la si mpyi u u ŋkwôro ná pire e. ");
INSERT INTO spp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ka u u yi jwo pi á: «Jwumpe Nintanmpe p'à yyaha tíi ná Kile Saanre e ke, mii à yaa mii u puru jwo kànyi sanɲy'á, ɲaha na yɛ lire mɛɛ na mii à tun.» ");
INSERT INTO spp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Lire e ka Yesu si wá na ɲaare na mâre na Jwumpe Nintanmpe yu Zhude kùluni Kile Jwumpe kàlambayi i. ");
INSERT INTO spp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɲyɛ canŋka mà Yesu niɲjyereŋi yaha Zhenɛzarɛti baŋi ɲwɔge na, sùpyire mpyi a yyér'a u kwûulo Kile jwumpe ndògoŋi kurugo, fo na piye ŋɔɔŋi kàmpanɲyi puni na, na u fɛnre. ");
INSERT INTO spp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ka u u mpa wíl'a bakwooyo shuunni ɲya baŋi ɲwɔge na. Fyácyaabii mpyi a fworo yire bakwooyi i na pi cwòobii jyìi. ");
INSERT INTO spp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ka Yesu si sà jyè kuru bakwɔɔge k'e, Simɔ woge ku mpyi ku ki, maa yi jwo Simɔ á: «Bakwɔɔge lwɔ́ baŋi ɲwɔge na mà file yyaha yyére dooni.» Simɔ à lire pyi ke, ka Yesu si ntɛ̀ɛn bakwɔɔge funŋke e, maa Kile jwumpe yu sùpyir'á. ");
INSERT INTO spp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ɲyɛ tèni i u à pa ŋkwɔ̀ Kile jwumpe ɲjwuŋi na ke, maa jwo Simɔ á: «Bakwɔɔge file lwɔhe tacuguŋke e, yii i yii cwòobii wà, yii i fyaabii pìi cya.» ");
INSERT INTO spp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ka Simɔ si u pyi: «Cyelentuŋi, wuu à numpilage puni pyi fyácyaani na, wuu ɲyɛ a yafyin ta mɛ, ŋka ná mu s'à jwo amuni, mii sí cwòŋi wà sahaŋki.» ");
INSERT INTO spp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ɲyɛ pi à cwòobii wà ke, ka pi i fyaa niɲyahamii cû fo cwòobii na ŋkwùun. ");
INSERT INTO spp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɲyɛ pi shɛ̀rɛfeebii pi mpyi bakwɔɔge sanŋke e ke, ka pi i pire yyere na pi pa pire tɛ̀gɛ. Ka pi i bakwooyi shuunniŋi ɲî fyaabii na, fo bakwooyi mpyi na ŋko raa ntîri lwɔhe ɲwɔh'i. ");
INSERT INTO spp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔ Pyɛri à lire ɲya ke, maa niŋkure sín Yesu fere e, maa jwo: «Kafooŋi, laaga tɔɔn na na, ɲaha na yɛ mii ɲyɛ kapimpyiŋɛ.» ");
INSERT INTO spp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Fyaabii pi mpyi a cû ke, Simɔ ná u shɛ̀rɛfeebii mpyi a fyá pi ɲyahaŋkanni na. ");
INSERT INTO spp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebede jyaabii pi mpyi ná Pyɛri e, ná pire pi ɲyɛ Yakuba ná Yuhana ke, pire mpyi a fyá mú. Ka Yesu si Simɔ pyi: «Ma hà vyá mɛ. Mà lwɔ́ numɛ na, bà mu mpyi na fyaabii caa na ɲcwôre mɛ, amuni mu sí raa sùpyire caa t'a bârali mii na.» ");
INSERT INTO spp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ɲyɛ ka pi i núr'a pa baŋi ɲwɔge na, maa kàntugo wà bakwooyi ná yi funŋɔ yaayi puni na, maa ntaha Yesu fye e. ");
INSERT INTO spp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mà Yesu yaha lire kùluni kànhe kà na, tògofooŋi wà na mpyi wani, tòge mpyi a u tɛgɛlɛ ta sèl'e. Tèni i u à Yesu ɲya ke, ka u u niŋkure sín u fere e, maa yyahe cyígile, maa u ɲáare: «Kafooŋi, mu aha ɲɛɛ, mu sí n‑jà mii tòge láha mii na si mii fíniŋɛ.» ");
INSERT INTO spp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ɲyɛ Yesu à yire lógo ke, maa cyɛge sànha maa bwɔ̀n u na, maa jwo: «Mii à ɲɛɛ, tòge ku láha ma na!» Ka tòge si ntíl'a láha u na. ");
INSERT INTO spp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ka Yesu si u pyi: «Cû ma ɲwɔge na, ma hà yaaga jwo sùpya á mɛ. Ŋka ta sì, maa sà maye cyêe sáragawwuŋi na u u ma kàanmucya, sárage kyaa Kile tùnntunŋiMusa à jwo tògofeebii ɲcùuŋɔŋi kyaa na ke, maa kuru wwû. Lire li sí li cyêe pi na na mu à cùuŋɔ.» ");
INSERT INTO spp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ɲyɛ ka Yesu mɛge si li ɲwɔ cû na fwore sèl'e. Shinɲyahara mpyi maha mpa a bínnini u taan, maa u jwumpe núru, u a sì wá na pi cùuŋi. ");
INSERT INTO spp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ŋka Yesu mpyi maha ŋkwɔ̀ a yîri pi taan, maa sà Kile ɲáare síwage funŋke e. ");
INSERT INTO spp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Canŋka mà Yesu yaha Kile jwumpe ɲjwuŋi na, Farizhɛɛnbii pìi ná Kile Saliyaŋi cyelentiibii pìi mpyi wani. Pire mpyi a yîri Galile kùluni ná Zhude kùluni kànyi puni ná Zheruzalɛmu kànhe na. Ka Yesu si wá na yampii cùuŋi ná Kafooŋi Kile sífente e. ");
INSERT INTO spp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ka sùpyire tà si yaŋi wà tug'a pa u yasinniŋke e, uru nàŋi mpyi a mûruŋɔ. Pi la mpyi si jyè bage e si u file Yesu na. ");
INSERT INTO spp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ŋka sùpyire ɲyahaŋi kurugo, pi ɲyɛ a jà a tajyige ta ná u e mɛ; ka pi i dùgo bage kàtanŋke na, maa kuru fûru, maa supyimuruŋke ná ku yasinniŋke le a tîrige kuru wyige e Yesu fere e sùpyire shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu à li ɲya na mpii nàmpil'à dá uru na ke, ka u u jwo supyimuruŋk'á: «Nà wà we, mu kapegigil'à yàfa mu na.» ");
INSERT INTO spp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii pi mpyi wani ke, ka pire si wá na ŋkunni maa jwo: «Ɲaha na ŋge nàŋi ɲyɛ na Kile mɛge kɛ̀ɛge yɛ? Fo Kile kanni bà mɛ, wà sì n‑jà sùpya kapegigii yàfa u na mɛ!» ");
INSERT INTO spp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ɲyɛ Yesu à pa pi kunuŋke ɲùŋke cè ke, maa pi pyi: «Ɲaha na tire nte sɔ̀nŋɔre shiŋi ɲyɛ yii funɲyi i yɛ? ");
INSERT INTO spp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mà jwo “Mu kapegigil'à yàfa mu na” ná “Yîri, maa ɲaare” yii ɲyii na, cyire kapyaagii mú shuunni i ndire jwumɔ p'à táan yɛ? ");
INSERT INTO spp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ŋka yii pi li cè na síŋi na ɲyɛ Supyaŋi Jyaŋi á naha ɲìŋke na, u wà kapegii yàfa u na.» Lire e u à jwo supyimuruŋk'á: «Ta núru na ɲwɔ na. Yîri maa ma yasinniŋke lwɔ́ maa sì pyɛngɛ.» ");
INSERT INTO spp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lire tèenuuni i, ka nàŋi si yîri maa u yasinniŋke lwɔ́ a fworo sùpyire ɲyii na, na Kile kêre, na ŋkɛ̀ɛge pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ka li i pi puni bilibili. Pi mpyi na Kile kêre, maa ŋko: «Ei! Wuu à kakyanhala karii ɲya niɲjaa dɛ!» ");
INSERT INTO spp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lire kàntugo ka Yesu si fworo ntàani na, maa wíl'a múnalwɔɔre shwofooŋi wà ɲya u à tɛ̀ɛn u báaraŋi tapyige e. U mɛge mpyi Levi. Ka Yesu si yi jwo u á: «Yîr'a taha na fye e.» ");
INSERT INTO spp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ka Levi si báaraŋi puni ɲwɔ yaha maa ntaha Yesu fye e. ");
INSERT INTO spp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lire kàntugo Levi à kataan nimbwoo pyi Yesu mɛɛ na u pyɛnge e. Shinɲyahara mpyi na lyî ná pi e siɲcyan. Pire shwɔhɔl'e, múnalwɔɔre shwofeebii mpyi a ɲyaha. ");
INSERT INTO spp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farizhɛɛnbii ná Kile Saliyaŋi cyelentiibii pìl'à lire ɲya ke, maa Yesu cyelempyiibii yíbe: «Ɲaha na yii ɲyɛ na lyî marii byii ná múnalwɔɔre shwofeebii ná mɛpɛngɛ shiinbii piibɛril'e yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ka Yesu si pi pyi: «Mpii pi à cùuŋɔ ke, wempyiŋi kyaa ɲyɛ pire na mɛ, mpii pi na yà ke, pire na u kani ɲyɛ. ");
INSERT INTO spp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mpii pi ɲyɛ na piye sɔ̂nŋi na pir'à tíi ke, mii ɲyɛ a pa ɲìŋke na pire tayyerege e mɛ. Ŋka mpii pi à li cè na pire ɲyɛ a tíi mɛ, pire tayyerege e mii à pa, bà pi si mpyi si pi toroŋkanni kɛ̂ɛnŋɛ mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ka pi i u pyi: «Tèrii niɲyahagil'e Yuhana Batizelipyiŋi cyelempyiibii ná Farizhɛɛnbii wuubii maha súnŋi leni marii Kile ɲáare, mu wuubii sí maha lyî marii byii canŋa maha canŋa.» ");
INSERT INTO spp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ka Yesu si pi pyi: «Yii na sɔ̂nŋi na yii sí n‑jà fànha cyán cifɔnŋi pooŋi ceveebii na, pi i súnŋi le mà cipooŋi yaha ná pi e la? ");
INSERT INTO spp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ŋka tèni là na ma, cipooŋi sí n‑pa n-yige pi shwɔhɔl'e. Lire tèni i pi sí n‑ta raa súnŋi leni.» ");
INSERT INTO spp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ka Yesu si tàanlini là jwo pi á na: «Wà ɲyɛ na vàanvɔnŋɔ kwùnn'a tɛ̀g'a vàanɲjyɛga tacwɔngɔ jwooli mɛ. Lire ká mpyi, mu maha vàanvɔnŋke kɛ̀ɛge, vàanvɔnŋke kwɔnge ná vàanɲjyɛge sí ɲyɛ na jìn'a yiye lwɔ́ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wà mú sí ɲyɛ na sinmpurugo leni seeye boolyɛgil'e mɛ. Lire baare e p'aha mpa ntanha, pu maha pu yaleŋke jya, maa wu, yaleŋk'a sì ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sinmpurug'à yaa k'a leni seeyi boofɔnŋkil'e. ");
INSERT INTO spp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lire ná li wuuni mú i, sùpya ɲyɛ a sìi na sinntanhaga byii maa núr'a yyaha yige sinmpurugo kurugo mɛ. Ɲaha kurugo yɛ u maha jwo na nintanhage k'à táan.» ");
INSERT INTO spp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ɲyɛ canŋka, Yesu ná u cyelempyiibii mpyi na ntùuli sùma kooyi y'e. Kuru canŋke na mpyi canŋɔŋɔ. Ka u cyelempyiibii si sùmaɲcahayi yà kwɔ̀n a cwuugo pi cyeyi i mà kùn. ");
INSERT INTO spp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farizhɛɛnbii pìl'à lire ɲya ke, maa Yesu pyi: «Ɲaha na yii ɲyɛ na canŋɔŋke kafuunŋkii pyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ka u u pi pyi: «Nde saanŋi Dawuda à pyi ke, yii ɲyɛ a lire kâla mà? Canŋka mà u ná u fyèɲwɔhɔshiinbii katege wuubii yaha, ");
INSERT INTO spp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","u à jyè Kile bage e, maa sárage bwúuruŋi wà lwɔ́ a kyà, maa wà kan u fyèɲwɔhɔshiinbil'á. Mà li ta sáragawwuubii kanni pi mpyi a yaa pi jà a uru bwúuruŋi kyà.» ");
INSERT INTO spp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ka Yesu si núr'a jwo pi á: «Supyaŋi Jyaŋi ká kyaa maha kyaa jwo mà yyaha tíi ná canŋɔŋke e ke, li sì n‑jà n‑tòro lire na mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ɲyɛ Yahutuubiicanŋɔŋke kabɛr'e, Yesu à jyè Kile Jwumpe kàlambage k'e, maa li ɲwɔ cû na Kile jwumpe yu. Nàŋi wà na mpyi sùpyire shwɔhɔl'e, uru kàniŋɛ cyɛge mpyi a kwû. ");
INSERT INTO spp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ka Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii si wá na Yesu kàanmucaa kampyi u sí ɲɛɛ sùpya cùuŋɔ canŋɔŋke e, si nta tìgire cyán u na. ");
INSERT INTO spp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ka Yesu si pi funzɔnŋɔre cè, maa yi jwo cyeŋkwugefooŋ'á na u yîr'a yyére sùpyire shwɔhɔl'e, pi raa u ɲaa, ka nàŋi si yîr'a yyére. ");
INSERT INTO spp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mà u yaha tayyérege e, ka Yesu si jwo: «Mii sí yii yíbe, mà tàanna ná Kile Saliyaŋi i, kacɛnni mpyiŋi l'à ɲwɔ canŋɔŋke e laa, kapiini mpyiŋi? Mà sùpya múnaa shwɔ laa, mà sùpya múnaa wwû?» ");
INSERT INTO spp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu à puru jwo ke, maa sùpyire puni wíi wíl'a mâha, maa jwo cyeŋkwugefol'á: «Ma cyɛge sànhana.» U à ku sànhana ke, ka ku u ɲcùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɲyɛ Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbil'à lire ɲya ke, ka pi lùgigii si yîri. Ka pi i ŋkàr'a sà piye taanna, nde pi sí n‑jà n‑pyi Yesu na ke, si lire cè. ");
INSERT INTO spp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Canŋka Yesu à dùg'a kàr'a sà Kile ɲáare ɲaŋke kà na. U à numpilage puni pyi Kileɲarege na wani. ");
INSERT INTO spp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ɲyɛ̀g'à pa múgo ke, ka u u u cyelempyiibii yyere, maa shiin kɛ ná shuunni cwɔɔnrɔ pi shwɔhɔl'e, mà pyi u tùnntunmii. ");
INSERT INTO spp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pire tùnntunmpii kɛ ná shuunniŋi mɛyi yi ɲje: Simɔ, ná Yesu à u mɛge le Pyɛri ke, ná Pyɛri sìɲɛɛŋi Andire ná Yakuba ná Yuhana ná Filipi ná Baritelemi ");
INSERT INTO spp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ná Macwo ná Tomasi ná Alife jyaŋi Yakuba ná Simɔ pi maha mpyi Zelɔti ke, ");
INSERT INTO spp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ná Yakuba jyaŋi Zhudasi ná Zhudasi Isikariyoti ŋge u sí n‑pa Yesu le cye e ke. ");
INSERT INTO spp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ɲyɛ ka Yesu si ntîge ná u tùnntunmpil'e ɲaŋke ɲuŋ'i, maa mpa yyére tafage k'e. U cyelempyiibii niɲyahamii ná supyiɲyahara mpyi wani. Tire sùpyire mpyi a yîri Zhude kùluni i, Zheruzalɛmu kànhe ná kùluni cyeyi sanɲyi puni i, mà bâra Tiri ná Sidɔn kànyi na, yire kànyi ɲyɛ suumpe lwɔhe ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tire sùpyire mpyi a pa si mpa a Yesu jwumpe núru, si ticuumpe ta. Jínabii mpyi mpiimu i ke, pire mpyi na ɲcùuŋi mú. ");
INSERT INTO spp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sùpyire puni mpyi na ɲcaa si bwɔ̀n Yesu na, ɲaha na yɛ shin maha shin n'a mpyi a jà a bwɔ̀n u na ke, fànha mpyi maha fworo u e, maa urufoo cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ɲyɛ ka Yesu si yyahe yîrig'a le u cyelempyiibil'e, maa jwo «Yii pi ɲyɛ fòŋke e ke, yii wuun'à ɲwɔ, ɲaha na yɛ Kile Saanre ɲyɛ yii woro. ");
INSERT INTO spp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Katege ɲyɛ yii mpiimu na numɛ ke, yii wuun'à ɲwɔ, ɲaha na yɛ yii sí n‑pa n‑tìn. Yii pi ɲyɛ na myahigii súu numɛ ke, yii wuun'à ɲwɔ, ɲaha na yɛ yii sí n‑pa raa ɲcyàhali. ");
INSERT INTO spp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Sùpyir'à yii mpiimu kyaa pɛn piy'á, marii yii kɔ̀re na láre piye na, marii yii cyere, marii yii mɛpɛngɛ yu na yii à taha Supyaŋi Jyaŋi fye e ke, yii wuun'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lire ká mpyi yii na tèni ndemu i ke, yii pyi funntange e, yii raa yini, ɲaha na yɛ Kile à sàra nimbwo bégel'a yaha yii mɛɛ na nìɲyiŋi na. Cyire karigii shiŋi pi tulyey'à pyi Kile tùnntunmpii na mú. ");
INSERT INTO spp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ŋka yii pi ɲyɛ ná nàfuuŋi i numɛ ke, yii wuun'à kɛ̀ɛge, ɲaha na yɛ yyeɲiŋke e yii ɲyɛ ke, kuru sí n‑pa n‑kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yii pi à tìn numɛ ke, yii wuun'à kɛ̀ɛge, ɲaha na yɛ katege sí n‑pa n‑cwo yii na. Yii pi ɲyɛ na ɲcyàhali numɛ ke, yii wuun'à kɛ̀ɛge, ɲaha na yɛ yii yyahayi sí n‑pa n‑tanha, fo yii sí raa myahigii súu. ");
INSERT INTO spp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Sùpyire puni na yii mpiimu kêre kafinare ɲùŋɔ taan ke, yii wuun'à kɛ̀ɛge, ɲaha na yɛ lire pyiŋkanni na, pi tulyey'à kafinivinibii kêe, pire mpiimu pi mpyi a piye pyi Kile tùnntunmii ke. ");
INSERT INTO spp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ɲyɛ mii lógofeebii, mii sí yi jwo yii á: yii yii zàmpɛɛnbii kyaa táan yiy'á. Mpii pi ɲyɛ ná pege e mà yyaha tíi ná yii e ke, yii a kacɛnŋii pyi pire na. ");
INSERT INTO spp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mpii pi ɲyɛ na jwumpimpe yu mà yyaha tíi ná yii e ke, yii a jwó leni pir'á. Mpii pi à yii cùmu lemɛ pi ke, yii a Kile ɲáare pir'á. ");
INSERT INTO spp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wà ha kantawaa bwɔ̀n mu mùmpɛnge k'e, ku sanŋke kɛ̂ɛnŋɛ urufol'á. Sùpya ká mu vàanntinmbwɔhe cyán a shwɔ mu na, ma vàanntinmbileni yaha u cye e mú. ");
INSERT INTO spp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wà ha mu ɲáare, urufoo kan. Sùpya ká mu yaaga cyán a shwɔ, ma hà ku fwoo jáara u na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nde yii la ɲyɛ sùpyire sannte s'a mpyi yii á ke, yii a lire pyi pi á mú. ");
INSERT INTO spp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yii kyal'à táan mpiimu á ke, yii aha pire kanni kyaa táan yiy'á, tɔ̀ɔnŋi ŋgi yii sí n‑ta lire e yɛ? Mɛpɛngɛ shiinbii mú ɲyɛ na lire pyi mà? ");
INSERT INTO spp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mpii pi ɲyɛ na kacɛnŋkii pyi yii na ke, yii aha a cyi pyi pire kann'á, tɔ̀ɔnŋi ŋgi yii sí n‑ta lire e yɛ? Mɛpɛngɛ shiinbii mú ɲyɛ na lire pyi mà? ");
INSERT INTO spp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yii à cè a jwo na yii sí n‑jà yaaga ɲáare n‑ta mpiimu á ke, yii aha a pire kanni kaan, tɔ̀ɔnŋi ŋgi yii sí n‑ta lire e yɛ? Mɛpɛngɛ shiinbii mú na lire pyi. Pi à cè a jwo na mpii pi sí n‑jà pire yaayi cyage núruŋɔ pire na ke, pire na pi maha yi fwɔhigii leni mú. ");
INSERT INTO spp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ŋka yii pi ke, yii yii zàmpɛɛnbii kyaa táan yiy'á, yii raa kacɛnŋkii pyi pi na. Yii aha fwoo le pi na, yii i yii sɔ̀nŋɔre láha li zàraŋi na. Lire ká mpyi, Kile sí sàra nimbwo kan yii á, lire mú li sí li cyêe na yii na ɲyɛ Kileŋi nìɲyi wuŋi pyìi, ɲaha na yɛ u à ɲwɔ kacɛnnɛcembaabii ná shinpiibii na. ");
INSERT INTO spp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yii pyi ɲùɲaarafee, bà yii Tuŋi Kile ɲyɛ ɲùɲaarafoo mɛ. ");
INSERT INTO spp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yii àha raa pi sanmpii cɛ̂ɛge mɛ, lire ká mpyi Kile mú sì yii cɛ̂ɛge mɛ. Yii àha raa sùpyire sannte la wwû mɛ, lire e Kile mú sì yii la wwû mɛ. Wà ha kyaa pyi yii wà na, urufoo u lire yàfa. Lire ká mpyi, Kile mú sí yii kapegigii yàfa yii na. ");
INSERT INTO spp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yii a sùpyire sannte kaan, lire e Kile mú sí yii kan, yaage e yii à sumare pyi maa pi sanmpii kan ke, Kile sí kuru yaage ɲî si ku cúnŋɔ cúnŋɔ si ku fíi si kà bâra ku na fo yaage si ɲî raa wuni.» ");
INSERT INTO spp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Lire kàntugo ka Yesu si tàanlini là jwo pi á na: «Fyinŋi wà sí n‑jà u fyinɲɛɛ kàbii cû la? Lire ká mpyi, pi mú shuunniŋi puni sì n‑tîge wyige k'e mà? ");
INSERT INTO spp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Cyelempyaŋi taceŋke sì n‑jà n‑pêe n‑tòro u cyelentuŋi woge taan mɛ, ŋka cyelempyaŋi cyɛge k'à le a ɲwɔ ke, uru u taceŋke maha mpyi u cyelentuŋi woge fiige. ");
INSERT INTO spp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ɲaha na mu ɲyɛ na ɲyɛ̀sɛnni ɲaa ma cìnmpworoŋi ɲyiini i, mà li ta bànnaŋi u ɲyɛ mu wuuni i ke, mu ɲyɛ na uru ɲaa mà yɛ? ");
INSERT INTO spp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mà tàanna ná lire e, di mu sí n‑jà n‑jwo ma cìnmpworoŋ'á na u yyére maa ɲyɛ̀sɛnni wwû u ɲyiini i, mà li ta bànnaŋi u ɲyɛ mu wuuni i ke, mu ɲyii ɲyɛ uru na mà yɛ? Mu u à fyìnmɛ tò wwomɔ na ke, bànnaŋi wwû ma ɲyiini i fɔlɔ, lire ká mpyi, mu sí raa ɲaa raa ɲcwúu ɲyɛ̀sɛnni tawwuge e ma cìnmpworoŋi ɲyiini i. ");
INSERT INTO spp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Cige niɲcɛnŋke ɲyɛ na yasɛrɛ nimpere yaa mɛ, cipege mú ɲyɛ na jìn'a yasɛrɛ niɲcɛnnɛ yaa mɛ. ");
INSERT INTO spp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cire puni maha ɲcìni ti yasɛɛre cye kurugo, lire ɲwɔhɔ ku ɲyɛ: wà sì n‑jà fizhiye cige yasɛrɛ kwɔ̀n ŋguro cige na mɛ, wà mú sì n‑jà ɛrɛzɛn cige yasɛrɛ kwɔ̀n kìlege taha na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ŋgemu u zò u à ɲwɔ ke, uru maha jwuɲcɛnmpe yu. Ŋgemu u ɲyɛ ná zòmpi i ke, uru maha jwumpimpe yu. Yii li cè, sùpyaŋi zòmbilin'à ɲî ndemu na ke, lire u ɲwɔge maha yu.» ");
INSERT INTO spp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ka Yesu si núr'a jwo: «Ɲaha kurugo yii maha mii pyi “Kafooŋi, Kafooŋi” mà li ta yii sí ɲyɛ na mii jwumpe kurigii ɲaare mà yɛ? ");
INSERT INTO spp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Shin maha shin u à pa mii á, maa mii jwumpe lógo, maa pu kurigii ɲaare ke, urufol'à fworo yaage ŋkemu na ke, mii sí kuru cyêe yii na. ");
INSERT INTO spp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Urufoo na ɲyɛ mu à jwo bafaanraŋi u à ɲìŋke tùgo fo mà sà nɔ kafaage na, maa u bage nintaani cyán ku na ke. Bag'à faanra a kwɔ̀ ke, ka zànbwɔhɔ si mpa, ka lwɔhe si wá na fwu na ma na ku kúuli, ŋka bage ɲyɛ a cwo mɛ, ɲaha na yɛ ku nintaan'à cyán a ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ŋka shinŋi u ɲyɛ na mii jwumpe núru, maa mpyi u ɲyɛ na pu kurigii ɲaare mɛ, urufoo na ɲyɛ mu à jwo bafaanraŋi u à u bage nintaani cyán ɲìntiige na ke. Zành'à pa, ka lwɔhe si wá na fwu na ma na ku kúuli ke, ka bage si ntíl'a pi a wu.» ");
INSERT INTO spp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu à puru jwumpe puni jwo a kwɔ̀ sùpyir'á ke, maa ŋkàre Kapɛrɛnamu kànhe e. ");
INSERT INTO spp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ɔrɔmu sòrolashiibii yyaha yyére shinŋi wà na mpyi wani kuru kànhe e ná biliwe e. Uru bilinaŋi kani mpyi a waha u na. Ka yampimɛ si mpa uru bilinaŋi cû, fo u na ŋko s'a kuro caa. ");
INSERT INTO spp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ɲyɛ uru ɲùŋufooŋ'à Yesu kyaa lógo ke, maa Yahutuubii kacwɔnribii pìi tun pi sà Yesu ɲáare u u mpa uru bilinaŋi cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pi à nɔ Yesu yyére ke, maa u ɲáare fànha na, maa jwo: «Ŋge ɲùŋufooŋ'à yaa ná mpwɔh'e, mu à yaa mu u u pwɔhɔ. ");
INSERT INTO spp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ɲaha kurugo yɛ wuu Yahutuubii kyal'à táan u á sèl'e. Uru mú sí u à wuu Kile Jwumpe kàlambage faanra.» ");
INSERT INTO spp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ɲyɛ ka Yesu si ɲɛɛ maa ŋkàre ná pi e. Tèni i pi à sà byanhara sòrolashiibii yyaha yyére shinŋi pyɛnge na ke, lir'à sòrolashiibii yyaha yyére shinŋi ta u à u ceveebii pìi tun pi sà yi jwo Yesu á: «Kafooŋi, ma hà maye kànha mpa mii pyɛnge e mɛ, ɲaha na yɛ mii ɲùŋk'à cyɛ́rɛ mu u jyè mii pyɛnge e. ");
INSERT INTO spp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Lire kurugo mii à li kàanmucya mà li ta na mii yabiliŋi ɲyɛ a yaa mii u shà mu fye e mɛ. Ŋka jwuŋkanŋa niŋkin jwo, kuru sí mii bilinaŋi cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mii wi ke, sòrolashiibii pìi na ɲyɛ mii ɲùŋɔ na, mii sí ɲyɛ pìi ɲùŋɔ na. Mii aha wà pyi “Ta sì” u maha ŋkàre. Mii aha wabɛrɛ pyi “Ta ma” u maha mpa. Mii aha na biliŋi pyi “Nde pyi” u maha lire pyi.» ");
INSERT INTO spp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ɲyɛ Yesu à puru jwumpe lógo sòrolashiibii ɲùŋufooŋi ceveebii ɲwɔ na ke, ka uru nàŋi kani si u kàkyanhala. Supyikuruŋke ku mpyi a taha Yesu fye e ke, ka u u yyaha kɛ̂ɛnŋ'a pi wíi wíi, maa jwo: «Mii sí yi jwo yii á, mii sàha ntêl'a sùpya ɲya ná ŋge dániyaŋi fiige e mɛ, ali Izirayɛli shiinbii shwɔhɔl'e mii ɲyɛ a u fiige ɲya mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mà jwo tùnntunmpii pi núr'a nɔ sòrolashiibii yyaha yyére shinŋi pyɛnge e ke, pi à sà uru bilinaŋi ta u à cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lire kàntugo ka Yesu ná u cyelempyiibii si yîri na ŋkɛ̀ɛge Nayimu kànhe e, shinɲyahara mpyi a taha pi fye e. ");
INSERT INTO spp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pi à sà byanhara kànhe tajyiɲwɔge na ke, ka pi i ɲcíri ná kànhe shiinbii pìl'e, pi i ŋkɛ̀ɛge ná nàɲjiibilini là niŋkwul'e fanɲyi i. Leŋkwucwoŋi wà u pyìniŋkinge ku mpyi ku ki. Kànha shiinbii niɲyahamii mpyi a taha leŋkwucwoŋi na, pi i ŋkɛ̀ɛge uru buŋi tatoŋke e. ");
INSERT INTO spp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kafooŋi Yesu à uru ceeŋi mɛɛsuwuŋi ɲya ke, ka u ɲùɲaare si jyè u e, ka u u u pyi: «Fyâha, ma hà raa mɛɛ súu mɛ!» ");
INSERT INTO spp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","U à yire jwo ke, maa file buŋi lwɔ́feebii na, maa bwɔ̀n kariyi na, ka pi i yyére. Ka u u jwo buŋ'á: «Nàɲjiiwe, yîri!» ");
INSERT INTO spp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ka nàɲjiiŋi si yîr'a tɛ̀ɛn, maa li ɲwɔ cû na yu, ka Yesu si u kan u nuŋ'á. ");
INSERT INTO spp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Shin maha shin u mpyi wani ke, ka li i pi puni bilibili, fo pi na Kile pêre marii ŋko: «Kile tùnntunŋi nimbwoŋi wà u à uye cyêe wuu na! Kile à pa u shiinbii tɛ̀gɛ!» ");
INSERT INTO spp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nde Yesu à pyi ke, ka sùpyire si sà a lire yu Zhude kùluni ná li kwùumpe kùligii puni i. ");
INSERT INTO spp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ɲyɛ karigii Yesu à pyi ke, ka Yuhana cyelempyiibii si ŋkàr'a sà cyire puni yyaha jwo u á. Yuhana à yire lógo ke, maa u cyelempyiibii pìi shuunni yyér'a ");
INSERT INTO spp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","tun pi sà Kafooŋi Yesu yíbe na: «Y'à jwo na ŋge u sí n‑pa ke, uru u ɲyɛ mu laa, wabɛrɛ wuu à yaa wuu a sigili?» ");
INSERT INTO spp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pire cyelempyiibil'à kàr'a sà nɔ Yesu na ke, maa u pyi: «Yuhana Batizelipyiŋi à wuu tun na wuu pa mu yíbe na “Ŋgemu kyaa l'à jwo na u sí n‑pa ke, mu u ɲyɛ u wi laa, wuu a wabɛrɛ sigili?”» ");
INSERT INTO spp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lire tèni mpyi a Yesu ta u u yamii niɲyahamii ná cwɔ̀hɔmɔfee niɲyahamii cùuŋi, maa jínabii kɔ̀re na yige pifeebil'e, maa fyinmii niɲyahamii ɲyii múru. ");
INSERT INTO spp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɲyɛ ka Yesu si tùnntunmpii pyi: «Yii à ndemu lógo maa ndemu ɲya ke, yii a sì, yii i sà lire yyaha jwo Yuhana á na: fyinmpii naha na ɲaa, toŋkɛgɛyifeebii sí i ɲaare, tògofeebii sí i ɲcùuŋi, ɲùɲcunnibii sí i núru, kwùubii sí i ɲɛ̀ni, Jwumpe Nintanmpe sí i yu fòŋɔfeebil'á. ");
INSERT INTO spp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ɲyɛ mii kapyiiŋkii ká mpyi cyi ɲyɛ a ŋgemu pyi u à cye láha mii na mɛ, urufoo wuun'à ɲwɔ.» ");
INSERT INTO spp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yuhana tùnntunmpil'à núr'a kàre ke, ka Yesu si wá na Yuhana kyaa yu sùpyir'á, u à pi pyi: «Canŋke yii ná ŋkàre síwage e ke, taha ɲyɛgɛ yii mpyi a kàr'a sà wíi kafɛɛge sí i ku ɲyàha la? ");
INSERT INTO spp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ɲaha yii sí mpyi a kàr'a sà wíi yɛ? Vàansinayafoo la? Yii li cè na mpii pi maha vàansinayi leni, maa pi ɲyii karigii pyi, maa pi ɲyii ɲjyìŋi lyî ke, pire maha mpyi saanbii bayi i. ");
INSERT INTO spp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ɲyɛ lire sanni i ke, ɲaha tawiige e yii mpyi a kàre yɛ? Kile tùnntunŋɔ la? Mii sí yi jwo yii á, u bá à fànha tò Kile tùnntunŋɔ na. ");
INSERT INTO spp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ɲaha kurugo yɛ Kile Jwumpe Semɛŋi à jwo ŋgemu kyaa na na “Wíi, mii sí na tùnntunŋi tun u sà mu kuni yaa mu yyaha na” ke, uru tùnntunŋi u ɲyɛ Yuhana. ");
INSERT INTO spp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mii sí yi jwo yii á, sùpya sàha ŋkwɔ̀ a si ŋgemu u à fànha tò Yuhana na mɛ, lire ná li wuuni mú i, Kile Saanre shiinbii puni nimbilen'à fànha tò Yuhana na. ");
INSERT INTO spp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sùpyire ti mpyi na núru Yuhana ɲwɔ na, mà bâra múnalwɔɔre shwofeebii na ke, pire puni mpyi a tɛ̀ɛn ná l'e na Kile à tíi, maa ɲɛɛ ka Yuhana si pi batize. ");
INSERT INTO spp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ŋka Kile mpyi a ndemu yaa mà yyaha tíi ná sùpyire e ke, Farizhɛɛnbii ná Kile Saliyaŋi cyelentiibii ɲyɛ a ɲɛɛ lire na mɛ, maa ɲcyé pi ɲyɛ a ɲɛn'a batize mɛ. ");
INSERT INTO spp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ná ɲaha shi i, mii sí nte sùpyire shiŋi tàanna yɛ? Ti ná ɲaha shi k'à fworo bɛ? ");
INSERT INTO spp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ti na ɲyɛ mu à jwo nàŋkopyire, ntemu ti ɲyɛ na bâhare kàfuge na ke, tà na bâhare maa ŋko ti shɛ̀rɛfeebil'á: “Wuu à tìinmpini wyì yii á, yii ɲyɛ a ɲɛn'a kwɔ̂hɔ mɛ. Wuu à jáhampe myahigii cêe yii á, yii ɲyɛ a ɲɛn'a mɛɛ sú mɛ.” ");
INSERT INTO spp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yii li cè, Yuhana Batizelipyiŋi à pa ke, u mpyi na ɲjyì tɔɔn wu lyî mɛ, u mú mpyi na sinmɛ byii mɛ, ka yii i jwo na jína u ɲyɛ u e. ");
INSERT INTO spp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Supyaŋi Jyaŋi à pa, maa lyî maa byii, ka yii i jwo na u sɔ̀nŋɔre ɲyɛ a taha yaage kabɛrɛ na mɛ, fo ɲjyìŋi ná sinmbyaani kanni, maa núr'a pyi mɛpɛngɛ shiinbii cevoo mu à jwo múnalwɔɔre shwofeebii. ");
INSERT INTO spp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ŋka yákilifente Kile maha ŋkaan ke, tire ká mpyi wà á, li maha ɲcè urufoo kapyiiŋkil'e.» ");
INSERT INTO spp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ɲyɛ Farizhɛnŋi wà na mpyi wani, uru mɛge na mpyi Simɔ. Canŋka uru nàŋ'à Yesu yyere na u sà lyî ná ur'e, ka u u ɲɛɛ maa ŋkàre, ka pi i sà ŋkwûulo na lyî. ");
INSERT INTO spp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mà pi yaha wani, ceeŋi wà na mpyi kuru kànhe e, kànhe sùpyire puni mpyi na uru ceeŋi cyêre kampyahii na, u kapegigii kurugo. Uru ceeŋ'à pa ɲcè na Yesu na ɲyɛ uru Farizhɛnŋi bage e ke, ka u u mpa ná loŋgaracwol'e, l'à ɲî sìnmɛ nùguntanga wumɔ na. ");
INSERT INTO spp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Maa ntòro Yesu kàntugo yyére mà sà yyére u tooyi taan, maa mɛɛ sú sèe sèl'e, fo ɲyii lwɔh'à wu mà Yesu tooyi ɲíŋɛ, maa u ɲùɲjoore tɛ̀g'a yi cwuugo, maa yi pûr'a cû, maa puru sìnmpe nùguntanga wumpe tɛ̀g'a yi tìri. ");
INSERT INTO spp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ɲyɛ Farizhɛnŋi u mpyi a Yesu yyere ke, ur'à lire ɲya ke, maa jwo uye funŋ'i: «Kampyi sèeŋi na ŋge nàŋi na ɲyɛ Kile tùnntunŋɔ, u mpyi na sí li cè na ceeŋi shiŋi u ɲyɛ na bwùun uru na ke, na u ɲyɛ kapimpyiŋɛ.» ");
INSERT INTO spp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ka Yesu si Farizhɛnŋi funzɔnŋɔre cè, maa u pyi: «Simɔ, jwumɔ na naha mii u jwo mu á.» Ka Simɔ si u pyi: «Ta yu, cyelentuŋi.» ");
INSERT INTO spp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ka Yesu si jwo: «Nàŋi wà fwɔhii na mpyi shiin shuunni na, u kampwɔhii ŋkwuu kaŋkuro (500.000) na mpyi wà na, u sanŋi wuŋi sí ɲyɛ kampwɔhii beeshuunni ná kɛ (50.000). ");
INSERT INTO spp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ná li síŋi sí ɲyɛ a pyi pi wà na mà jà a u fwooni tò mɛ, ka uru nàŋi si cyire fwɔhigii yàfa pi na. Ɲyɛ pire shiin shuunniŋi i, uru nàŋi kyaa sí n‑táan pi jofol'á mà tòro u sanŋi na yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ka Simɔ si u pyi: «Mii na sɔ̂nŋi ŋgemu u fwoo li mpyi a pêe sèl'e ke, nàŋi kyaa sí n‑táan ur'á mà tòro u sanŋi na.» Ka Yesu si u pyi: «Mu à sèe jwo.» ");
INSERT INTO spp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Maa yyaha kɛ̂ɛnŋɛ ceeŋi yyére maa jwo Simɔ á: «Mu à ŋge ceeŋi ɲya la? Mii à pa mu yyére, mu bá ɲyɛ a lwɔhɔ kan mii i na tooyi jyé mɛ. Ŋka ŋge ceeŋi wi ke, u à mii tooyi jyé ná u ɲyilwɔhe e, maa yi cwuugo ná u ɲùɲjoore e. ");
INSERT INTO spp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mu ɲyɛ a mii pûr'a cû maa mii shɛ́ɛre mɛ, ŋka ŋge ceeŋi wi ke, mà lwɔ́ u à jyè bage e ke, u à kwôro na mii tooyi shwɔɔnre ná u ɲwɔge e. ");
INSERT INTO spp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mu ɲyɛ a mii ɲùŋke tìri ná sìnm'e mɛ, ŋka ŋge ceeŋi wi ke, u à mii tooyi tìri ná sìnmɛ nùguntanga wum'i. ");
INSERT INTO spp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Lire kurugo mii sí yi jwo mu á, kapegigii u à pyi ke, cyi ná cyi ɲyahaŋi mú i, cyi pun'à yàfa u na. Lire e u à mii kyaa táan uy'á sèe sèl'e. Kapegii nimpyigir'à yàfa ŋgemu na ke, urufoo tàange ɲyɛ a pêe mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Lire kàntugo ka Yesu si ceeŋi pyi: «Mu kapegigil'à yàfa mu na.» ");
INSERT INTO spp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mpii pi mpyi na lyî siɲcyan ná Yesu i ke, ka pire si wá na ŋko piye funŋ'i: «Ɲaha supyifiiwe u ɲyɛ ŋge nàŋi mà sà nɔ, fo u u sùpyire kapegigii yàfani ti na yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ŋka Yesu ɲyɛ a puru jwumpe lwɔ́ a wíi mɛ, maa jwo ceeŋ'á: «Mu dániyaŋ'à mu shwɔ, ta sì yyeɲiŋke e.» ");
INSERT INTO spp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lire kàntugo ka Yesu si wá na ɲaare na ntùuli kànbwoyi ná kànpyɛɛre na, maa Jwumpe Nintanmpe yu mà yyaha tíi ná Kile Saanre e. U cyelempyiibii kɛ ná shuunniŋi mpyi ná u e. ");
INSERT INTO spp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cyeebii u à cùuŋɔ, mà bâra mpiimu jínahii u à kɔ̀r'a yige pi e ke, pire pìi mú na mpyi ná u e. Wà mɛge na mpyi Mariyama, pi mpyi maha uru pyi Magidala Mariyama mú (uru ŋge ceeŋi i Yesu mpyi a jínabii baashuunniŋi kɔ̀r'a yige) ");
INSERT INTO spp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ná Cwuza cwoŋi Zhanɛ (Cwuza u mpyi na saanŋi Erɔdi karigii cwɔɔnre) ná Suzani ná cyeebii piibɛrii niɲyahamii. Pire cyeebii mpyi maha pi cyeyaayi yà kaan Yesu ná u cyelempyiibil'á, pi i piye tɛ̀re. ");
INSERT INTO spp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɲyɛ canŋka shinɲyahara à pa bínni Yesu taan, tire sùpyire mpyi a yîri kànya niɲyahaya na, ka u u bàtaaga jwo pi á. U à jwo: ");
INSERT INTO spp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ɲɛɛnuguŋi wà u ná fwor'a kàre ɲɛɛmɛ tanuguge e. Mà u yaha u u sùmapyaŋi wàa fini fiige, wà à cwo kuni ɲwɔge na, ka kuntorobii si uru tánhana, ka saɲcyɛɛnre si mpa u jò. ");
INSERT INTO spp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ka wà tacwugo si mpa bɛ̂ ná kafaafoge e, maa fyîn. U ɲyɛ a mɔ mɛ, maa waha, ɲaha na yɛ mbyimɛ ɲyɛ a pyi kuru cyage e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka wà tacwugo si mpa bɛ̂ ŋgurotaha na, maa fyîn, maa wá na lyɛge, ka ŋgure si u cû. ");
INSERT INTO spp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ŋka wà tacwug'à pa bɛ̂ ná ɲìŋke tacɛnŋke e, maa fyîn, maa lyɛ, maa se. Sùmacige maha sùmacig'à sùmapyaŋi se mà nɔ ŋkuu (100) na.» Yesu à kuru bàtaage jwo ke, maa jwo fànha na: «Ŋgemu la ká mpyi si karii yyaha cè ke, urufoo u u niŋgyigigii cyán sèl'e.» ");
INSERT INTO spp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ka u cyelempyiibii si u yíbe: «Kuru bàtaage ɲwɔhe ku ɲyɛ ɲaha shi yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ka Yesu si pi pyi: «Karigii cyi à yyaha tíi ná Kile Saanre e ná cyi à ŋwɔhɔ ke, yii á cyire ɲcèŋ'à kan, ŋka sùpyire sannt'á bàtaay'i cyi à jwo: “bà pi si mpyi s'a pu wíi, pi àha raa pu ɲaa raa ɲcwúu mɛ, s'a pu núru, pi àha raa pu yyaha cìni mɛ.” ");
INSERT INTO spp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kuru bàtaage ɲwɔhɔ ku ɲyɛ: sùmashiŋi u ɲyɛ Kile jwumpe. ");
INSERT INTO spp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kuni ɲwɔge na sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo, ka Sitaanniŋi si pu wwû pi funŋ'i, bà pi si mpyi pi àha ndá pu na, si shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kafaafoge ɲuŋ'i sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo maa ɲɛɛ pu na ná funntange e, ŋka pu ɲyɛ a jà a ndìre le t'e mɛ. Pi maha mpyi Kile kuni i tère nimbilere e kanna, kawaa ká pi ta, pi maha fworo l'e. ");
INSERT INTO spp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ŋgure shwɔhɔl'e sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo, ŋka mà jwo tère nimbilere li nɔ ke, funmpɛɛnre karigii ná nàfuuŋi lage ná ŋge diɲyɛŋi múguroŋi karigii maha pu cwɔ̂nrɔ, fo pu yasɛɛre sì n‑jà nɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ɲìŋke niɲcɛnŋke na sùmashiŋi tacwug'à pa bɛ̂ ke, kuru ku ɲyɛ mu à jwo sùpyire t'à Kile jwumpe lógo maa ɲɛɛ pu na ná funŋɔ niŋkin i, maa ŋkwôro pu ɲuŋ'i ná ɲwɔmɛɛ niŋkin i ke, tire sùpyire ti maha tiye waha tèrigii puni i, marii Kile ɲyii wuuni pyi. ");
INSERT INTO spp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wà ɲyɛ na fùkina mîni si u le ɲcyígile yaaga ɲwɔh'i mɛ. Ŋka u maha mîni maa u dùrugo yaage kà ɲuŋ'i, bà u si mpyi s'a bɛ̀ɛnmpe yige bage jyifeebil'á mɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ɲyɛ kyaa maha kyaa li ɲyɛ numpini i ke, cyire puni sí n‑pa n‑yige bɛ̀ɛnmpe na, kyaa maha kyaa l'à ŋwɔhɔ ke, lire là sì n‑kwôro ɲcèmbaa mɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lire kurugo jwumpe yii ɲyɛ na núru mii ɲwɔ na ke, yii yákili yaha pu na sèl'e, ɲaha na yɛ ŋgemu u à yaaga cè ke, kà sí n‑bâra urufoo u taceŋke na. Ŋka ŋgemu u ɲyɛ u ɲyɛ a yafyin cè mɛ, ali u na sɔ̂nŋi na ur'à nimbileni ndemu cè ke, lire sí n‑shwɔ u na.» ");
INSERT INTO spp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ɲyɛ ka Yesu nuŋi ná u cìnmpyiibii si mpa u yyére. Ŋka sùpyire ɲyahaŋi kurugo, pi ɲyɛ a jà a tabaraga ta u na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ka wà si Yesu pyi: «Mu nuŋi ná mu cìnmpyiibii naha cyíinŋi na, pi naha na mu kyaa pyi.» ");
INSERT INTO spp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ka Yesu si jwo: «Mpii pi ɲyɛ na Kile jwumpe núru, marii pu kurigii ɲaare ke, pire pi ɲyɛ mii nuŋi ná mii cìnmpyiibii.» ");
INSERT INTO spp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Canŋka Yesu à u cyelempyiibii pyi: «Yii a wá, wuu u baŋi jyiil'a kɛ̂ɛnŋɛ kùmpoge sanŋke na.» Ka pi i jyé bakwɔɔge e na baŋi jyiili. ");
INSERT INTO spp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mà pi yaha pi i ŋkɛ̀ɛge lwɔhe ɲuŋ'i, ka Yesu si mpa ŋɔ́ɔ, ka kafeebwɔhɔ si wá na fwu na lwɔhe lwúu na wàa bakwɔɔge funŋke e. Ku mpyi na ŋko si ɲî lwɔhe na, fo na ŋko s'a ntîri lwɔhe ɲwɔh'i. ");
INSERT INTO spp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ka cyelempyiibii si Yesu ɲɛ̀, maa jwo: «Cyelentuŋi, cyelentuŋi, wuu sí n‑kwû dɛ!» Ka Yesu si yîri maa fànha cyán kafɛɛge na, maa lwɔhe pyi: «Tɛ̀ɛn tanuge e!» Ka kafɛɛge si yyére, ka lwɔhe si ntɛ̀ɛn. ");
INSERT INTO spp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ka u u u cyelempyiibii yíbe maa jwo: «Taha yii bá ɲyɛ a dá mii na mɛ?» Ŋka cyelempyiibii fyagara wuubii ná pi kakyanhala wuubii pi mpyi, ka pi i wá na piye yíbili: «Jofoo u ɲyɛ ŋge nàŋi fo ka kafɛɛge ná lwɔhe si ntɛ̀ɛn u wuuni taan yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ɲyɛ ka Yesu ná u cyelempyiibii si baŋi jyiil'a sà nɔ Gadara shiinbii kùluni i, lire kùluni na ɲyɛ Galile wuuni yyetiimpe na baŋi kàntugo. ");
INSERT INTO spp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pi nivworobii bakwɔɔge e, ka kuru kànhe nàŋi wà si Yesu ɲùŋɔ bɛ̂, jínabii mpyi uru nàŋi i. Li mpyi a mɔ, u sàha mpyi na vàanɲyi leni mɛ, u sàha mpyi na shùun kànhe e mɛ, fo fanɲyi i. ");
INSERT INTO spp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tèni i uru nàŋ'à Yesu ɲya ke, ka u u ŋkwúulo, maa ɲcwo Yesu fere e, maa jwo fànha na: «Yesu, Kileŋi nìɲyi wuŋi Jyaŋi, ɲaha mu ɲyɛ na ɲcaa mii á yɛ? Mii na mu ɲáare, ma hà kawaa pyi na na mà dɛ!» ");
INSERT INTO spp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nàŋ'à yire jwo, ɲaha na yɛ Yesu mpyi a jínaŋi pyi na u fworo u e. Uru jínaŋi mpyi maha u cyáan tèrii niɲyahagil'e. Sùpyire mpyi maha uru nàŋi cwôre maa u cyeyi ná u tooyi pwu ná yɔ̀rɔy'e, bà u si mpyi si ntɛ̀ɛn tanuge e mɛ, ŋka u mpyi maha yire yapwoyi puni kwùun. Lire kàntugo jínaŋi mpyi maha sì ná u e síwage e. ");
INSERT INTO spp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ɲyɛ ka Yesu si nàŋi yíbe u mɛge na, ka u u jwo: «Mii mɛge ɲyɛ Shinɲyahara.» U à yire jwo ɲaha na yɛ jínabii pi mpyi u e ke, pire mpyi a ɲyaha. ");
INSERT INTO spp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ka pire jínabii si Yesu ɲáare na u àha pire kɔ̀rɔ ŋkàre kacyewyicuguŋke e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ɲyɛ lir'à caakurumbwɔhɔ ta ku u lyî ɲaŋke kà numpɛngɛ na wani, ka jínabii si Yesu ɲáare sèl'e na u pire yaha pire pi sà jyè kuru caakuruŋke e, ka u u ɲɛɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɲyɛ ka jínabii si fworo nàŋi i maa sà jyè caabil'e. Ka kuru caakuruŋke puni si sùrug'a yîri ɲaŋke numpɛnge na mà cwo cwo baŋi i mà kwû. ");
INSERT INTO spp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cáanahabil'à lire ɲya ke, maa fê a kàr'a sà a yi yu kànhe ná sishwɔnbugure puni i. ");
INSERT INTO spp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ka sùpyire si fwor'a kàre si sà cyire karigii ɲya. Nàŋi i jínabii mpyi ke, ka pi i sà u ta u à tɛ̀ɛn Yesu fere e ná vàanɲyi i tanuge e, ka pi i fyá. ");
INSERT INTO spp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","L'à pyi mpiimu ɲyii na ke, ka pire si nàŋi cuuŋɔŋkanni jwo pi sanmpil'á. ");
INSERT INTO spp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ɲyɛ ka Gadara kùluni shiinbii puni si Yesu ɲáare na u fworo pire kùluni i, ɲaha na yɛ pi mpyi a fyá u yyaha na sèl'e. Ka Yesu si jyè bakwɔɔge e s'a ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nàŋi i jínabil'à fworo ke, ka uru si Yesu ɲáare sèl'e, na uru na ŋkɛ̀ɛge ná u e. Ka Yesu si u núruŋɔ maa jwo: ");
INSERT INTO spp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Núru, ma a sì pyɛngɛ, kabwooni Kile à pyi mu á ke, ma a sà lire yyaha jwo ma pyɛngɛ shiinbil'á.» Ka nàŋi si ŋkàre kànhe funŋke e, nde Yesu à pyi u á ke, maa sà a lire yu na ntùuli cyeyi puni i. ");
INSERT INTO spp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ɲyɛ tèni i Yesu à núr'a baŋi jyiil'a kɛ̂ɛnŋɛ kùŋke sanŋke na ke, ka shinɲyahara si u ɲùŋɔ bɛ̂, ɲaha na yɛ pi puni mpyi na u sigili. ");
INSERT INTO spp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kile Jwumpe kàlambage kà ɲùŋufoo na mpyi wani, uru mɛge mpyi Zharusi, ka uru nàŋi si mpa niŋkure sín Yesu fere e maa u ɲáare fànha na na u shà uru pyɛnge e, ");
INSERT INTO spp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ɲaha na yɛ pworoŋi niŋkinŋi u mpyi u á, ná u mpyi a yyee kɛ ná shuunni kwɔ̀ ke, uru mpyi na yà, fo u mpyi na ŋko raa ŋkwûu. Ɲyɛ Yesu niŋkareŋi Zharusi pyɛnge e, sùpyire mpyi a u kwûulo kàmpanɲyi puni na, fo na u fɛnre piye shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ceeŋi wà na mpyi tire sùpyire shwɔhɔl'e, lùwuliŋkwombaayi mpyi u na yyee kɛ ná shuunni funŋ'i. Wempyiibii mpyi a kwɔ̀ u cyeyaare puni na, ŋka wà ɲyɛ a jà a u cùuŋɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɲyɛ ka u u mpa Yesu kàntugo yyére maa bwɔ̀n u vàanɲyi zhwɔ̀ɔre na, ka yampe si ntíl'a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ka Yesu si sùpyire yíbe: «Jofoo u à bwɔ̀n mii na yɛ?» Ka sùpyire puni si wá na ŋko: «Mii bà mɛ.» Ka Pyɛri si jwo: «Cyelentuŋi, mu ɲyii ɲyɛ sùpyire na t'à mu fɛnrɛ kàmpanɲyi puni na mà?» ");
INSERT INTO spp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ka Yesu si jwo: «Wà kɔn'à bwɔ̀n mii na, ɲaha na yɛ mii à li kàanmucya mà li ɲya na fànhe kà a fworo mii i.» ");
INSERT INTO spp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ɲyɛ ceeŋ'à li ɲya na nde ur'à pyi ke, na Yesu à li cè ke, ka u u fyá fo na ɲcyɛ̂ɛnni, maa mpa niŋkure sín Yesu fere e, nde l'à u pyi u à bwɔ̀n Yesu na ke, ná pyiŋkanni na u à uye ɲya u à cùuŋɔ tèenuuni mujye e ke, u à yire yyaha jwo Yesu á sùpyire puni ɲyii na. ");
INSERT INTO spp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ka Yesu si u pyi: «Na pworo, mu dániyaŋ'à mu cùuŋɔ. Kile u yyeɲiŋke kan ma á.» ");
INSERT INTO spp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mà Yesu yaha puru jwumpe na, tùnntunŋ'à yîri ɲùŋufooŋi Zharusi pyɛnge e mà pa yi jwo Zharusi á: «Kile wuuni na wá à nɔ mu pworoŋi na. Ma hà núru cyelentuŋi yaha u uye kànha u a ma mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu à yire lógo ke, maa jwo Zharusi á: «Ma hà raa fyáge mɛ, dá mii na kanna, mu pworoŋi sí n‑yîri.» ");
INSERT INTO spp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ɲyɛ pi à sà nɔ Zharusi pyɛnge ɲwɔge na ke, Yesu ɲyɛ a ɲɛɛ sùpyaŋi wabɛrɛ u jyè ná ur'e mɛ, fo Pyɛri ná Yuhana ná Yakuba ná pyàŋi tuŋi ná pyàŋi nuŋi. ");
INSERT INTO spp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sùpyire puni ti mpyi pyɛnge e ke, pire puni mpyi na myahigii súu marii ŋkwúuli pyàŋi ŋkwùŋi na. Ka Yesu si pi pyi: «Yii àha raa mɛɛ súu mɛ, pyàŋi ɲyɛ a kwû mɛ, u na ŋwúuni!» ");
INSERT INTO spp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ka pi i wá na ɲcyàhali u na, ɲaha na yɛ pi à li cè na pyàŋ'à kwû. ");
INSERT INTO spp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ɲyɛ ka Yesu si pyàŋi buwuŋi cû u cyɛge na, maa jwo fànha na: «Pyà, yîri!» ");
INSERT INTO spp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","U à yire jwo ke, ka pyàŋi múnaani si núr'a jyè u e, lire tèenuuni mujye e, ka u u yîri, ka Yesu si pi pyi pi ɲjyì kan u á. ");
INSERT INTO spp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ka lire kani si pyàŋi sifeebii bilibili. Ka Yesu si yi jwo pi á na pi àha nde kani jwo sùpyaŋi wà tufiig'á mɛ. ");
INSERT INTO spp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Lire kàntugo ka Yesu si u cyelempyiibii kɛ ná shuunniŋi pyi pi à bínni u taan, maa síŋi ná fànhe kan pi á, bà pi si mpyi s'a jínabii puni kɔ̀re s'a yige pifeebil'e, s'a yampii cùuŋi mɛ. ");
INSERT INTO spp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Lire ɲwɔhɔ na, u à pi tun pi sà a Kile Saanre kyaa yu sùpyir'á, pi raa yampii cùuŋi. ");
INSERT INTO spp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","U à pi pyi: «Yii àha ŋkwɔ̀ yaaga lwɔ́ yiye cye e lire kùsheeni na mɛ, mu à jwo kàbii, lire ɲyɛ mɛ boro ná bwúuru ná wyɛ́rɛ. Yii wà hà ŋkwɔ̀ vàanntinŋke kabɛrɛ lwɔ́ mbâra u yacige woge na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yii aha ŋkàre kànha maha kànha na, ka wà si ɲɛɛ yii sunmbage na, yii tɛ̀ɛn wani fo mà sà yaa ná yii tèekani i. ");
INSERT INTO spp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ŋka kànhe ŋkemu shiin kampyi pi ɲyɛ a ɲɛɛ yii i yii sunmbage tîrige pire yyére mɛ, yii nivworobii kuru kànhe e, yii yii tooyi bambaŋi kwòro kwòr'a wu wani, lir'à kajwuu kwɔ̀ kuru kànhe shiin na.» ");
INSERT INTO spp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ɲyɛ ka pi i yîr'a kàr'a sà a Jwumpe Nintanmpe yu na mâre kànyi puni i, maa yampii cùuŋi. ");
INSERT INTO spp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ɲyɛ Yuhana boŋkwooni kàntugo, saanŋi Erɔdi à pa Yesu kapyiiŋkii lógo, ka li i u yákiliŋi wùrugo sèl'e, ɲaha na yɛ pìi mpyi na ŋko na Yuhana Batizelipyiŋi u à ɲɛ̀ a fworo kwùŋi i. ");
INSERT INTO spp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pìi sí i ŋko na Kile tùnntunŋi Eli u à núr'a pa, pìi mú sí i ŋko na tèecyiini Kile tùnntunŋi wà u à ɲɛ̀ a fworo kwùŋi i. ");
INSERT INTO spp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ka Erɔdi si jwo: «Mii à pi pyi pi à Yuhana ɲùŋke kwɔ̀n, jofoo shɛnrɛ mii saha sí ɲyɛ na núru amɛ yɛ?» Ka u u wá na Yesu caa si u ɲya. ");
INSERT INTO spp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ɲyɛ Yesu tùnntunmpil'à núr'a pa ke, maa pi kapyiiŋkii puni jwo u á, ka u u yîri ná pi e sùpyire sannte taan mà kàre pi mɛge cyage e Bɛtisayida kànhe kàmpanŋke na. ");
INSERT INTO spp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sùpyir'à pa pi saha cè ke, maa ŋkàre wani pi fye e. Ka u u pi cùmu lemɛ ɲwɔ, maa Kile Saanre kyaa jwo pi á. Mpii pi mpyi na yà pi e ke, maa pire cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tèni i canŋk'à pa a ntîri ke, ka Yesu cyelempyiibii kɛ ná shuunniŋi si file u na maa yi jwo u á na u sùpyire cye yaha, bà pi si mpyi si sà ɲjyì ná tashwɔnyɔ cya kànyi ná sishwɔnbugure e mɛ, ɲaha na yɛ sige funŋke e pire ɲyɛ. ");
INSERT INTO spp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ka Yesu si pi pyi: «Yii yabilimpii pi pi kan pi lyî.» Ka pi i u pyi: «Bwúuru ɲùnyɔ kaŋkuro ná fyapyaa shuunni cyi naha wuu á kanna, fo l'aha nta wuu yabilimpii sí n‑sà ɲjyì cya mpa ŋkan nte supyiɲyahare pun'á.» ");
INSERT INTO spp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tire sùpyire e, nàmbaabii kanni mpyi a shiin kampwɔhii kaŋkuro (5.000) kwɔ̀, ka Yesu si u cyelempyiibii pyi pi à sùpyire tìŋɛ tìŋɛ kuruyo kuruyo, yire kuruɲyi niŋkin niŋkinŋi puni mpyi a shiin beeshuunni ná kɛ kɛ kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɲyɛ ka pi i sùpyire puni tìŋɛ tìŋɛ, bà Yesu mpyi a yi jwo mɛ. ");
INSERT INTO spp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ka Yesu si yire bwúuru ɲùɲyi kaŋkuruŋi ná cyire fyapyaagii shuunniŋi lwɔ́, maa yyahe yîrige nìɲyiŋi i, maa fwù kan Kile á yi kyaa na, maa yi kwɔ̀n kwɔ̀n a kan u cyelempyiibil'á, pi kan sùpyir'á. ");
INSERT INTO spp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sùpyire puni ti mpyi wani ke, tire pun'à lyî a tìn. Ka pi i shàhii kɛ ná shuunni ɲî ɲjyìpaanyi na. ");
INSERT INTO spp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɲyɛ lire kàntugo, mà Yesu ná u cyelempyiibii yaha, u à yîri pi taan, maa sà Kile ɲáare. U à kwɔ̀ ke, maa núr'a pa, maa pi yíbe: «Sùpyire na mii sɔ̂nŋi jofoo yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ka pi i u pyi: «Pìi wá na ŋko na Yuhana Batizelipyiŋi u ɲyɛ mu, pìi sí i ŋko na Kile tùnntunŋiEli u ɲyɛ mu, pìi mú sí i ŋko na Kile tùnntunmpii pi à tòro ke, na uru wà u à ɲɛ̀ a fworo kwùŋi i.» ");
INSERT INTO spp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ka Yesu si pi pyi: «Yii de? Jofoo yii ɲyɛ na mii sɔ̂nŋi yɛ?» Ka Pyɛri si u pyi: «Kile Niɲcwɔnrɔŋi u ɲyɛ mu.» ");
INSERT INTO spp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ka Yesu si yi jwo a waha pi á na pi àha ŋkwɔ̀ yire jwo sùpya á mɛ. ");
INSERT INTO spp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Maa núr'a jwo: «L'à pyi fànha kyaa Supyaŋi Jyaŋi u kyaala sèl'e. Yahutuubii kacwɔnribii ná Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii sí n‑cyé u na, si u bò. Ŋka u kwùŋi canmpyitanrewuuni, u sí ɲɛ̀.» ");
INSERT INTO spp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Lire kàntugo ka Yesu si yi jwo u lógofeebii pun'á: «Ŋgemu la ká mpyi si ntaha mii fye e ke, urufol'à yaa u cyé u yabiliŋi ɲyii karigii na, u u ntɛ̀ɛn kyaage taan u u ntaha mii fye e canŋa maha canŋa, pi mɛ́ɛ ká mpyi na sí urufoo bò kworokworocige na. ");
INSERT INTO spp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ɲaha na yɛ ŋgemu la ká mpyi si u niɲjaaŋi yaa ɲwɔ ke, urufoo sì nùmpanŋa ta mɛ, ŋka ŋgemu ká kàntugo wà u niɲjaaŋ'á mii kurugo ke, urufoo sí nùmpanŋa ta. ");
INSERT INTO spp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɲaha li sí ɲwɔ sùpyaŋ'á mà ma ɲyii yaayi puni ta ŋge diɲyɛŋi i niɲjaa, mu nùmpanŋke si sà ŋkɛ̀ɛge yɛ? ");
INSERT INTO spp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Lire kurugo ŋgemu u na ɲcyíge Supyaŋi Jyaŋi ná u jwumpe na ke, u aha bú mpa ná u sìnampe ná u Tuŋi wumpe ná Kile mɛ̀lɛkɛɛbii wumpe e canŋke ŋkemu i ke, u sí n‑cyé urufoo na. ");
INSERT INTO spp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sèeŋi na mii sí yi jwo yii á, pìi na ɲyɛ yii e, pi sì n‑kwû ná pi ɲyɛ a Kile Saanre ɲya mà yɛ!» ");
INSERT INTO spp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ɲyɛ canmpyaa baataanre fiig'à tòro puru jwumpe jwuŋkwooni kàntugo ke, ka Yesu si ŋkàre ná Pyɛri ná Yuhana ná Yakuba e ɲaŋke kà na, si sà Kile ɲáare. ");
INSERT INTO spp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mà Yesu yaha Kileɲarege na, u yyahe pyiŋkann'à kɛ̂ɛnŋɛ, ka u vàanɲyi si fíniŋɛ weewee fo na ɲî. ");
INSERT INTO spp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lire tèenuuni i, ka nàmbaa shuunni si mpa jwo ná u e. Pire pi mpyi tèecyiini Kile tùnntunmpiiMusa ná Eli. ");
INSERT INTO spp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pi mpyi a pa ná sìnampe e. Pyiŋkanni na Yesu mpyi na sí n‑kàre n‑sà u báaraŋi fûnŋɔ si ŋkwû Zheruzalɛmu kànhe e ke, maa lire jwo u á. ");
INSERT INTO spp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lire tèni mpyi a ŋɔɔmpe ta Pyɛri ná u shɛ̀rɛfeebii na sèl'e. Ŋɔɔmp'à pa láha pi na ke, ka pi i pire nàmbaabii shuunniŋi niɲjyerebii ɲya ná Yesu i u sìnampe e. ");
INSERT INTO spp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tèni i pire nàmbaabii mpyi na yîri Yesu taan ke, ka Pyɛri si jwo u á: «Wuu cyelentuŋi, wuu à pa naha ke, lir'à ɲwɔ sèl'e. Wuu vùnyɔ taanre kwòro, niŋkin sí n‑pyi mu wogo, niŋkin sí n‑pyi Musa wogo, niŋkin sí n‑pyi Eli wogo.» Pyɛri mpyi a puru jwumpe jwo uye ɲùŋɔ kurugo. ");
INSERT INTO spp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mà Pyɛri yaha puru jwumpe na, ka ɲahaŋa si mpa pi tò. Mà ɲahaŋke yaha ku u pi tùni, ka pi i fyá. ");
INSERT INTO spp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ka mɛjwuu si fworo kuru ɲahaŋke e na: «Mii Jyaŋi u ɲyɛ ŋge, mii à u cwɔɔnrɔ. Yii a núru u ɲwɔ na.» ");
INSERT INTO spp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lire mɛjwuuni fworoŋkwooni kàntugo, Yesu baare e, cyelempyiibii saha ɲyɛ a wà ɲya mɛ. Nde pi à ɲya ke, ka pi i lire yaha piye funŋ'i, pi ɲyɛ a yaaga jwo wà á lire tèni i mɛ. ");
INSERT INTO spp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kuru canŋa nùmpanŋa, Yesu ná u cyelempyiibii nintigibii ɲaŋke na, ka supyikurumbwɔhɔ sí sà u ɲùŋɔ bɛ̂. ");
INSERT INTO spp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tire sùpyire shwɔhɔl'e, ka nàŋi wà si jwo fànha na: «Cyelentuŋi, mii na mu ɲáare, maa na jyaŋi kàanmucya. Uru niŋkinŋi u ɲyɛ mii á. ");
INSERT INTO spp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jínaŋi wà u ɲyɛ u e, u aha yîri u kurugo, u maha ŋkwúuli, jínaŋi maha u cúnŋɔ cúnŋɔ fànha na, u ɲwɔge maha bàafwɔhe yige, u maha u kànha sèl'e, maa nta a fworo u e. ");
INSERT INTO spp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mii à mu cyelempyiibii ɲáare pi jínaŋi kɔ̀r'a yige u e, ŋka pi ɲyɛ a jà mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ka Yesu si jwumpe lwɔ́ maa jwo: «Ei! Yii dánabaa sùpyiibii nimpiibii, fo ɲaha tère e mii sí n‑kwôro ná yii e yɛ? Mii sí yii kapyiiŋkii kwú naye e sà nɔ fo ɲaha tère na yɛ? Ta ma ná ma jyaŋi i naha.» ");
INSERT INTO spp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ɲyɛ mà pi yaha pi i filili ná pyàŋi i Yesu na, ka jínaŋi si pyàŋi cúnŋɔ cúnŋɔ fànha na maa u cyán ɲìŋke na. Ɲyɛ ka Yesu si fànha cyán jínaŋi na, maa u pyi u à fworo pyàŋi i, maa u kan u tuŋ'á. ");
INSERT INTO spp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sùpyire ti mpyi wani ke, Kile sífente mpyi a pire puni kàkyanhala. Karigii Yesu mpyi a pyi ke, cyire mpyi a sùpyire puni kàkyanhala. Mà pi yaha pur'e, ka u u yi jwo u cyelempyiibil'á: ");
INSERT INTO spp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Yii mpe jwumpe lóg'a tàra, li saha sì mɔ mɛ, pi sí Supyaŋi Jyaŋi le cye e, pi i pi ɲyii wuuni pyi u na.» ");
INSERT INTO spp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ŋka cyelempyiibii ɲyɛ a mpyi a puru jwumpe yyaha cè mɛ, ɲaha na yɛ pu ɲwɔhe mpyi a ŋwɔhɔ pi na, pi mú sí mpyi na fyáge si u yíbe pu ɲwɔhe na. ");
INSERT INTO spp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ɲyɛ ka nàkaana si mpa yîri cyelempyiibii ná piye shwɔhɔl'e, tire ɲùŋke ku mpyi na pire puni i jofoo u ɲyɛ ɲùŋufooŋi yɛ. ");
INSERT INTO spp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu à pa tire nàkaante ɲùŋke cè ke, maa pyàŋi wà lwɔ́ a yaha uye taan, ");
INSERT INTO spp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","maa jwo cyelempyiibil'á: «Shin maha shin u à ŋge pyàŋi cùmu lemɛ ɲwɔ mii kurugo ke, urufoo mú à mii cùmu lemɛ ɲwɔ. Ŋgemu ká mii cùmu lemɛ ɲwɔ ke, urufoo mú à mii tunvooŋi cùmu lemɛ ɲwɔ. Ɲyɛ ŋgemu u à uye pyi yii puni kàntugo yyére wuŋi ke, uru u ɲyɛ yii puni ɲùŋufooŋi.» ");
INSERT INTO spp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ɲyɛ ka Yuhana si jwo Yesu á: «Cyelentuŋi, wuu à nàŋi wà ɲya u u jínabii kɔ̀re na yige sùpyire e ná mu mɛge e, ka wuu u u sige li na, ɲaha na yɛ wuu wà bà mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ka Yesu si u pyi: «Yii àha u sige li na mɛ, ɲaha na yɛ ŋgemu u ɲyɛ u ɲyɛ wuu zàmpɛn mɛ, urufoo na ɲyɛ ná wuu e.» ");
INSERT INTO spp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ɲyɛ tèni i Yesu tèefworon'à pa byanhara ŋge diɲyɛŋi i, s'a ŋkɛ̀ɛge nìɲyiŋi na ke, ka u u sàa li lwɔ́ uye funŋ'i si ŋkàre Zheruzalɛmu kànhe e, ");
INSERT INTO spp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","maa tùnntunmii tùugo uye yyaha na, ka pire si ŋkàr'a sà nɔ Samari kànhe kà na, maa sunmbage tatirige cya Yesu mɛɛ na kuru kànhe shiinbil'á. ");
INSERT INTO spp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ŋka kuru kànhe shiinbii ɲyɛ a ɲɛɛ mɛ, ɲaha na yɛ Zheruzalɛmu i u mpyi na ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tèni i u cyelempyiibii pìi shuunni Yakuba ná Yuhana à pa yire lógo ke, maa jwo: «Kafooŋi, mu sí wuu yaha wuu nage yige nìɲyiŋi na wuu tîrige pi ɲuŋ'i wuu u pi shi bò mà?» ");
INSERT INTO spp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ka Yesu si yyaha kɛ̂ɛnŋ'a le pi e maa pi faha sèl'e. ");
INSERT INTO spp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lire kàntugo ka pi i ntòr'a kàre kànhe kabɛrɛ na. ");
INSERT INTO spp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mà pi niŋkaribii yaha, ka nàŋi wà si Yesu pyi: «Kafooŋi, mii sí n‑taha mu fye e ma tasheyi puni i.» ");
INSERT INTO spp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ka u u u pyi: «Wyigii na ɲyɛ sigepwuunbil'á, shèere mú sí ɲyɛ saɲcyɛɛnr'á. Ŋka tashwɔngɔ ɲyɛ Supyaŋi Jyaŋi á mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Maa wabɛrɛ pyi: «Taha na fye e.» Ka uru si jwo: «Kafooŋi, yyére, mii aha na tuŋi tò, mii sí n‑ta n‑pa n‑taha mu fye e.» ");
INSERT INTO spp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ka Yesu si u pyi: «Kwùubii yaha pi a piye tùni, ŋka mu wi ke, ta sì maa sà a Kile Saanre kyaa yu.» ");
INSERT INTO spp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ka wabɛrɛ si jwo: «Kafooŋi, mii la ɲyɛ si ntaha mu fye e, ŋka na yaha si sà yi jwo na pyɛngɛ shiinbil'á fɔlɔ.» ");
INSERT INTO spp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ka Yesu si u pyi: «Shin maha shin u à nùtuuge cû nùfaaŋi na, maa wíi kàntugo ke, urufoo ɲyɛ a yaa ná Kile Saanre e mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lire kàntugo Kafooŋi Yesu à núr'a shiin beetaanre ná kɛ ná shuunni cwɔɔnrɔ u fyèɲwɔhɔshiinbil'e, mà tun shiin shuunni shuunni uye yyaha na, kànyi puni ná cyeyi puni i u mpyi a yaa u tòro ke. ");
INSERT INTO spp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Maa yi jwo pi á: «Sùmakɔɔg'à pêe, ŋka sùmakwɔɔnbil'à cyɛ́rɛ. Lire e ke yii kɛrɛge foo ɲáare, u u pìi bâra sùmakwɔɔnbii na. ");
INSERT INTO spp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mii à yii tun, yii a sì. Yii sí n‑pyi sùpyire shwɔhɔl'e, mu à jwo mpàa pi ɲyɛ sige yaaya shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yii àha wyɛ́rɛ lwɔ́ nde yiye ɲuŋ'i mɛ, yii àha boro lwɔ́ mɛ, yii àha tanhaɲyi yabɛrɛ lwɔ́ mbâra yii tooyi wuyi na mɛ. Mà yii niŋkaribii yaha, yii àha raa yyéreli kuni na s'a fwù pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yii aha jyè pyɛngɛ maha pyɛng'e ke, yii jwumpe niɲcyiimpe pu pyi “Kile u yyeɲiŋke kan yii á.” ");
INSERT INTO spp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɲyɛ sùpya ká nta kuru pyɛnge e, ŋgemu u ɲyɛ na ɲcáa yyeɲiŋke na ke, urufoo sí kuru yyeɲiŋke dùbabii ta. Ŋka l'aha nta uru sùpya ɲyɛ kuru pyɛnge e mɛ, pire dùbabii sí n‑kwôro yii á. ");
INSERT INTO spp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pyɛnge ŋkemu ká ɲɛɛ yii sunmbage na ke, yii tɛ̀ɛn wani. Pi aha yalyire ná yabyɛɛre ntemu kan yii á ke, yii raa tire lyî, ɲaha na yɛ báarapyiŋi sàraŋ'à yaa u kan u á. Yii àha raa sunmbage kɛ̂ɛnŋi raa mâre mɛ. ");
INSERT INTO spp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yii aha ŋkàre kànha maha kànha na, ka pi i ɲɛɛ yii na, maa yalyire ntemu kan yii á ke, yii i tire lyî. ");
INSERT INTO spp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yii i kuru kànhe yampii cùuŋɔ, yii i yi jwo kànhe shiinbil'á na Kile Saanre à byanhara pi na. ");
INSERT INTO spp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ŋka yii aha ŋkàre kànha maha kànha na, ka pi i yii sunmbage cyé ke, yii jyè kuru kànhe pyɛnkuuŋi i, yii i yi jwo pi á ");
INSERT INTO spp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ali yii kànhe bambaŋi u à ta wuu tooyi na ke, wuu sí uru kwòro kwòro n‑yaha yii na. Ŋka lire ná li wuuni mú i, yii li cè na Kile Saanre à byanhara yii na.” ");
INSERT INTO spp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mii sí yi jwo yii á, diɲyɛŋi canŋkwɔge, nde li sí kuru kànhe shiinbii ta ke, lire sí n‑waha mà tòro nde li sí n‑pyi Sɔdɔmu kànhe shiinbii na ke.» ");
INSERT INTO spp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ka Yesu si núr'a jwo: «Yii Korazɛn kànhe shiinbii, yii wuun'à kɛ̀ɛge! Yii Bɛtisayida kànhe shiinbii, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ kakyanhala karigii cyi à pyi wani yii yyére ke, kampyi Tiri kànhe ná Sidɔn kànhe e cyire mpyi a pyi, numɛ mpyi na sí pi ta pi à pi toroŋkanni kɛ̂ɛnŋɛ maa láha kapegigii na fo tèemɔni i, maa cafubɔrigii le mà pyi pi vàanɲyi, maa cwɔɔnre wu piye na. ");
INSERT INTO spp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lire l'à li ta, canŋke Kile sí sùpyire puni sâra si ntàanna ná ti kapyiiŋkil'e ke, nde li sí yii ta ke, lire sí n‑waha mà tòro Tiri ná Sidɔn kànyi wuuni na. ");
INSERT INTO spp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yii Kapɛrɛnamu kànhe shiinbii pi ke, yii na sɔ̂nŋi na yii sí n‑kàre Kile yyére nìɲyiŋi na bɛ? Lire mpyi ɲyɛ mɛ, yii sí n‑sìi n‑tîrige fo ɲìŋke ɲwɔhɔ shiinbii cyage e.» ");
INSERT INTO spp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Lire kàntugo ka Yesu si núr'a jwo u tùnntunmpil'á: «Ŋgemu ká ɲɛn'a lógo yii ɲwɔ na ke, l'à pyi mu à jwo mii ɲwɔ na urufol'à lógo. Ŋgemu ká yii cyé ke, l'à pyi mu à jwo mii urufol'à cyé mú. Ŋgemu sí u à mii cyé ke, l'à pyi mu à jwo mii tunvooŋi urufol'à cyé mú.» ");
INSERT INTO spp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɲyɛ ka pire tùnntunmpii beetaanre ná kɛ ná shuunniŋi si ŋkàre mà sà tère pyi, ka pi funntanga wuubii si núr'a pa, maa jwo: «Kafooŋi, mu mɛge cye kurugo, ali jínabil'à kúu wuu á.» ");
INSERT INTO spp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ka Yesu si pi pyi: «Mii à Sitaanniŋi ɲya, u à yîri nìɲyiŋi na ɲyaa niŋkin, kileɲini fiige, mà pa ɲcwo ɲìŋke na. ");
INSERT INTO spp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ɲyɛ mii à li síŋi kan yii á, yii a ɲaare wwòobii ná nɔ́ŋgyahigii ɲuŋ'i, yii i wuu zàmpɛnŋi fànhe fwòoŋɔ yiye tooy'e, yafyin sì n‑jà kapii pyi yii na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lire ná li wuuni mú i, yii àha funɲyi táan na jínabil'à kúu yii á mɛ, ŋka yii pyi funntange e, ɲaha kurugo yɛ yii mɛy'à sémɛ Arijinaŋi i.» ");
INSERT INTO spp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lire tèenuuni i, ka Kile Munaani si Yesu funŋke pyi k'à táan sèl'e, ka u u Kile kêe maa jwo: «Tufooŋi Kile, nìɲyiŋi ná ɲìŋke Kafooŋi, mii fwù ɲyɛ mu na, ɲaha na yɛ kani mu à ŋwɔhɔ yákilifeebii ná kaceempii na ke, mu à lire cyêe nàŋkopyire na. Sèe wi, Tufooŋi, mu à lire pyi mà tàanna ná ma ɲyii wuuni i.» ");
INSERT INTO spp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Lire kàntugo ka u u jwo sùpyir'á: «Mii Tuŋi à karigii puni le mii cye e. Sùpya ɲyɛ a Jyafooŋi cè Tufooŋi baare e mɛ. Sùpya mú ɲyɛ a Tufooŋi cè Jyafooŋi baare e mɛ, fo Jyafooŋi la ká mpyi si u cyêe ŋgemu na ke.» ");
INSERT INTO spp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lire kàntugo ka Yesu si yyaha kɛ̂ɛnŋɛ u cyelempyiibii kann'á maa yi jwo pi á: «Karigii yii na ɲaa ke, mpii pi na cyire ɲaa ke, pire wuun'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mii sí yi jwo yii á, nde yii à ɲya maa ndemu lógo ke, Kile tùnntunmii niɲyahamii ná saanlii niɲyahamii la mpyi si lire ɲya, si li lógo. Ŋka pi ɲyɛ a jà a li ɲya maa li lógo mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Canŋka Kile Saliyaŋi cyelentuŋi wà à yîr'a yyére si Yesu pɛrɛ ɲcû maa jwo: «Wuu cyelentuŋi, ɲaha mii à yaa mii u pyi si shìŋi niŋkwombaaŋi ta yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ka Yesu si u pyi: «Nde l'à sémɛ Kile Saliyaŋi Semɛŋi i ke, ɲaha mu à cè lire e yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ka u u Yesu pyi: «Y'à sémɛ Saliyaŋi Semɛŋi i na “Ma Kafooŋi Kile kyaa táan may'á ná ma zòmbilini puni ná ma múnaani puni ná ma fànhe puni ná ma sɔ̀nŋɔre puni i. Mà bâra lire na, ma supyiɲɛɛŋi kyaa táan may'á bà mu kyal'à táan may'á mɛ.”» ");
INSERT INTO spp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ka Yesu si u pyi: «Mu ɲwɔshwɔɔr'à ɲwɔ. Mu aha jà na lire pyi, mu sí shìŋi niŋkwombaaŋi ta.» ");
INSERT INTO spp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ŋka nàŋi la mpyi si tànga kan uy'á maa jwo: «Jofoo u ɲyɛ mii supyiɲɛɛŋi yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ka Yesu si u ɲwɔ shwɔ ná bàtaag'e na: «Nàŋi wà u ná yîri Zheruzalɛmu kànhe e na ŋkɛ̀ɛge Zheriko kànhe e. Mà u yaha kuni na, ka kakuumpyiibii pìi si ɲcwo u na, maa u cyeyaayi puni cyán a shwɔ u na, maa u bwɔ̀n fo mà u bânnaga a yaha kwùubii ná ɲyii wuubii shwɔhɔl'e, maa yîri u taan. ");
INSERT INTO spp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Lir'à bɛ̂ ná Kile sáragawwuŋi w'e u u ma lire kuni i, ur'à pa nɔ nàŋi niɲcwuŋi na ke, maa fɛ̂nn'a tòro u taan. ");
INSERT INTO spp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ɲyɛ ka Kileɲaarebage báarapyiŋi wà si mpa a ntùuli lire kuni ninuuni i, uru na mpyi Levi tùluge shin, uru mú à pa nɔ nàŋi niɲcwuŋi na ke, maa fɛ̂nn'a tòro u taan. ");
INSERT INTO spp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lire kàntugo ka Samari shinŋi wà kùshe wu si wá na ma lire kuni i mú. Ur'à pa nɔ nàŋi niɲcwuŋi na ke, ka u ɲùɲaare si u ta. ");
INSERT INTO spp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ka u u file u na, maa u nɔɔyi wyɛrɛ yal'a pyi, maa u lwɔ́ a dùrugo u dùfaanŋke ɲuŋ'i, maa ŋkàre ná u e nàmpwuunbii tatirige bage k'e, maa yaha u na. ");
INSERT INTO spp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kuru canŋa nùmpanŋa, maa bage sàraŋi wwû uye ɲuŋ'i mà kan bage fooŋ'á, maa yi jwo u á “Yaha ŋge nàŋi na, mu aha wyɛ́rɛ maha wyɛ́rɛ wwû u ɲùŋɔ taan ke, mii aha núr'a pa, mii sí uru puni núruŋɔ mu na.”» ");
INSERT INTO spp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ɲyɛ Yesu à puru jwo ke, maa uru Saliyaŋi cyelentuŋi pyi: «Mpii shiin taanreŋi i, mu á, ŋgi u à ŋge nàŋi nimbannaŋi pyi u supyiɲɛɛŋi yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ka u u Yesu pyi: «Nàŋi u à u ɲùɲaara ta ke, uru u ɲyɛ u supyiɲɛɛŋi.» Ka Yesu si u pyi: «Ta sì, maa sà lire fiige pyi.» ");
INSERT INTO spp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mà Yesu ná u cyelempyiibii yaha ɲani na na ŋkɛ̀ɛge Zheruzalɛmu kànhe e, pi à sà nɔ kànhe kà na, maa sunmbage lèŋɛ ceeŋi wà yyére. Uru ceeŋi mɛge na mpyi Marita. ");
INSERT INTO spp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marita kàntugo wuŋi wà na mpyi wani, uru mɛge mpyi Mariyama, ka uru si ntɛ̀ɛn Kafooŋi Yesu taan marii u jwumpe núru. ");
INSERT INTO spp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lir'à Marita cyɛge ta k'à cwɔ̂nrɔ sushwɔhɔbaaraŋi na, ka u u file Yesu na maa jwo: «Kafooŋi, taha mu bá u à mii cɔɔnŋi ɲya u à tɛ̀ɛn, maa mii kanni yaha mii i báaraŋi pyi mɛ? U pyi u yîr'a na tɛ̀gɛ kɛ!» ");
INSERT INTO spp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ka Kafooŋi si u pyi: «Marita, Marita, mu yyah'à wyɛ̀rɛ ná karii niɲyahagil'e maa cyi tɛ̀g'a maye funŋɔ pɛn. ");
INSERT INTO spp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ŋka kyaa niŋkin kanna li ɲyɛ tɔ̀ɔn wuuni mà tòro cyi sanŋkii puni taan, lire Mariyama à pyi. Sùpya sì n‑jà u láha lire mpyiŋi na mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Canŋka Yesu mpyi na Kile ɲáare cyage k'e. U à kwɔ̀ Kileɲarege na ke, ka u cyelempyaŋi wà si u pyi: «Kafooŋi, wuu taanna Kileɲarege pyiŋkanni na, bà Yuhana a u cyelempyiibii taanna ku na mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ka Yesu si u pyi: «Yii aha a si raa Kile ɲáare, yii jwo: “Tufooŋi, mu mɛge ku táan. Ma pyi saanwa sùpyire puni ɲùŋɔ na. ");
INSERT INTO spp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wuu canŋa maha canŋa ɲjyìŋi kan wuu á. ");
INSERT INTO spp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wuu kapegigii yàfa wuu na, ɲaha na yɛ wuu maha wuu shinɲɛɛbii wogigii puni yàfani pi na. Ma hà yaaga yaha ku wuu yyaha kɛ̂ɛnŋɛ kapegigil'á mɛ.”» ");
INSERT INTO spp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ɲyɛ maa núr'a pi pyi: «L'aha mpyi mu à jwo cevoo na ɲyɛ yii wà á, ka urufoo si yîr'a kàre ɲìɲiŋke na uru cevooŋi yyére, maa sà u bage kúu mà jwo “Na cevoo, bwúuru ɲùɲyi taanre kan na á, ");
INSERT INTO spp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ɲaha na yɛ mii à nàmpɔnŋɔ ta, yalyire sí naha mii u kan u á mɛ.” ");
INSERT INTO spp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yii na sɔ̂nŋi na uru cevooŋi sí n‑tɛ̀ɛn bage funŋke e si jwo “Ma hà zìi mpa na yyaha fwɔ́hɔrɔ mɛ. Mii à bage tò a kwɔ̀, mii ná na pyìibii naha a sínn'a kwɔ̀, mii saha naha na sì n-jà n-yîri bwúuru kan mu á mɛ” la? ");
INSERT INTO spp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mii sí yi jwo yii á, u mɛ́ɛ ká mpyi u ɲyɛ a yîr'a bwúuruŋi kan mu á yii cempe kurugo mɛ, u mɛkɛgere yyaha na, yaaga maha yaaga mu ɲyɛ na ɲcaa ke, u sí n‑yîri kuru kan mu á. ");
INSERT INTO spp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mii sí yi jwo yii á, yii a Kile ɲáare, u sí yii kan, yii a ɲcaa, yii sí n‑ta, yii a bàrage kúuli, ku sí múgo yii á. ");
INSERT INTO spp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ɲaha kurugo yɛ shin maha shin u ɲyɛ na Kile ɲáare ke, Kile sí urufoo kan. Ŋgemu u ɲyɛ na ɲcaa ke, urufoo sí n-ta. Ŋgemu ká a bàrage kúuli ke, ku sí múgo urufol'á. ");
INSERT INTO spp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Jofoo u ɲyɛ yii shwɔhɔl'e, ŋgemu u sí ɲɛɛ wwò kan u pyàŋ'á mà li ta fya u à ɲáare u á yɛ? ");
INSERT INTO spp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Lire ɲyɛ mɛ, mà nɔ́ŋgyaa lwɔ́ a kan u á, mà li ta ŋkùcere u à ɲáare yɛ? ");
INSERT INTO spp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɲyɛ yii sùpyiibii pi à pi ke, cyage e yii maha jà a yacɛnɲyɛ kan yii pyìibil'á ke, yii ɲyɛ a cè a jwo na yii Tuŋi u ɲyɛ nìɲyiŋi na ke, na ur'à bégel'a tòro yii taan si u Munaani le u ɲáarafeebil'e mà?» ");
INSERT INTO spp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Canŋka Yesu mpyi na jínaŋi wà kɔ̀re na yige nàŋi w'e, uru jínaŋi mpyi a nàŋi pyi búbu. Tèni i jínaŋ'à pa fworo u e ke, ka uru nàŋi si li ɲwɔ cû na yu. Sùpyire ti mpyi wani ke, ka li i pi puni kàkyanhala. ");
INSERT INTO spp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ŋka pìl'à jwo sùpyire shwɔhɔl'e, na jínabii ɲùŋufooŋi Bɛlizebuli u à síŋi kan Yesu á, u u jínabii kɔ̀re na yige pifeebil'e. ");
INSERT INTO spp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pìi la na mpyi si Yesu pɛrɛ ɲcû, maa jwo na u kani là pyi ndemu li sí li cyêe pire na na u à fworo Kile e ke. ");
INSERT INTO spp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ŋka Yesu mpyi a pi funzɔnŋɔre cè maa yi jwo pi á: «Kìre maha kìre li ɲyɛ na liye tùnni ke, lire maha mpa jya. Pyɛngɛ maha pyɛngɛ shiin ká yîri piye kurugo ke, kuru maha mpa jya mú. ");
INSERT INTO spp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ná yii na sɔ̂nŋi na jínabii ɲùŋufooŋi Bɛlizebuli fànhe cye kurugo mii ɲyɛ na jínabii kɔ̀re na yige sùpyire e, ɲyɛ Sitaanniŋi báarapyiibii ká ntáa maa piye tùnni, pi saanre sì n‑kwɔ̀ mà? ");
INSERT INTO spp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yii aha jwo na mii na jínabii kɔ̀re na yige pifeebil'e ná Bɛlizebuli fànhe e, lire sanni i ke, yii shiinbii pi ɲyɛ na pi kɔ̀re ke, ná jofoo u fànhe e pire maha pi kɔ̀re yɛ? Yii shiinbii yabilimpii pi sí jwumpe pyi pu cwo yii ɲuŋ'i. ");
INSERT INTO spp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ŋka mii aha a jínabii kɔ̀re na yige pifeebil'e ná Kile fànhe e, lir'à li cyêe na Kile Saanre à nɔ yii na mà kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yii li cè na fànhaɲyahagafoo ká kàshikwɔnyaaya lwɔ́ a tɛ̀ɛn u pyɛnge ɲwɔge na marii ku saɲcwɔnŋi sigili, sùpya sì n‑jà u yaage kà lwɔ́ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ŋka wabɛrɛ ká mpa ɲcwo pyɛngefoo na, ŋgemu u à fànha tò u na, maa jà u na ke, pyɛngefoo cyɛge mpyi a taha kàshikwɔnyaayi ɲjemu na ke, urufoo sí yire shwɔ u na, si u cyeyaayi cyán zhwɔ u na, si ntáa. ");
INSERT INTO spp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Shinŋi u ɲyɛ u ɲyɛ ná mii i mɛ, urufoo ɲyɛ mii zàmpɛn, ŋgemu u ɲyɛ u ɲyɛ na mii tɛ̀re na sùpyire wàa tiye na mɛ, urufoo na ti ɲùŋɔ kyánge. ");
INSERT INTO spp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jína ká fworo sùpya e, u maha sà ɲaara síwage yyaha kurugo, maa tatɛɛngɛ cya. U aha mpyi u ɲyɛ a kà ta mɛ, u maha jwo “Mii sí núru raa wà na tayirige e.” ");
INSERT INTO spp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ɲyɛ u aha núr'a pa urufoo ta baga fiige ŋkemu k'à pwɔ́ maa ku funŋke bégel'a ɲwɔ ke, ");
INSERT INTO spp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","u maha núr'a kàr'a sà jínahii baashuunni lwɔ́ a bâra uye na, mpii pi à pi mà tòro u yabiliŋi na ke, maha mpa jyè urufol'e. Lire ká mpyi, urufoo pyiŋkanni nivɔnn'a sì nâara a pi mà tòro niɲjyeeni na.» ");
INSERT INTO spp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ɲyɛ mà Yesu yaha puru jwumpe na, ka ceeŋi wà si jwumpe lwɔ́ sùpyire shwɔhɔl'e maa jwo u á: «Ceeŋi u à mu si maa mu byé ke, uru wuun'à ɲwɔ dɛ!» ");
INSERT INTO spp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ka Yesu si ceeŋi pyi: «Ŋgemu u ɲyɛ na Kile jwumpe núru, marii pu kurigii ɲaare ke, urufoo wuun'à sàa ɲwɔ.» ");
INSERT INTO spp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sùpyir'à pa bínni mà Yesu kwûulo ke, ka u u jwo: «Nte sùpyir'à pi. Ti la na ɲyɛ mii u kakyanhala kani là pyi si ɲcyêe ti na ndemu l'à li cyêe na mii à fworo Kile e ke. Ŋka nde l'à pyi Kile tùnntunŋi Zhonasi na ke, lire baare e kakyanhala kyaa saha sì n‑pyi n‑cyêe ti na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nde l'à pyi Zhonasi na ke, lir'à li cyêe Ninive kànhe shiinbii na na Kile u mpyi a u tun. Lire pyiŋkanni na, nde li sí n‑pa Supyaŋi Jyaŋi ta ke, lire li sí li cyêe nte sùpyire na na Kile u à u tun. ");
INSERT INTO spp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Canŋke Kile sí sùpyire puni sâra si ntàanna ná ti kapyiiŋkil'e ke, saancwoŋi u mpyi Sheba kìni ɲùŋɔ na ke, uru sí n‑pa n‑yîri n‑yyére, si nte sùpyire cɛ̂ɛgɛ, ɲaha na yɛ uru saancwoŋi mpyi a yîri diɲyɛŋi ɲùŋke kà na, mà sà saanŋi Solomani yákilifente jwumpe lógo. Mà li ta wà na ɲyɛ naha, ŋgemu u yákili u à pêe Solomani wuŋi na ke, ti sí ɲyɛ a ɲɛn'a lógo uru ɲwɔ na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kuru canŋke, Ninive shiinbii mú sí n‑pa n‑yîri n‑yyére, si nte sùpyire cɛ̂ɛgɛ, ɲaha na yɛ Zhonasi mpyi a sà Kile jwumpe jwo Ninive shiinbil'á ke, pi à pi toroŋkanni kɛ̂ɛnŋɛ. Mà li ta wà na ɲyɛ naha, ŋgemu u tayyérege k'à fànha tò Zhonasi woge na ke, nte sùpyire sí ɲyɛ a ɲɛn'a ti toroŋkanni kɛ̂ɛnŋɛ mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ka Yesu si núr'a jwo: «Wà ɲyɛ na fùkina mîni si u le ɲcyígile cere ɲwɔh'i mɛ. Ŋka u maha dùrugo yaage kà ɲuŋ'i, bà u si mpyi s'a bɛ̀ɛnmpe yige bage jyifeebil'á mɛ. ");
INSERT INTO spp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sùpyaŋi ɲyiigii cyi ɲyɛ u bɛ̀ɛnmpe. Ŋgemu u ɲyii cyi à ɲwɔ ke, urufoo puni maha mpyi bɛ̀ɛnmpe e mú. Ŋgemu wogigii sí cyi à kɛ̀ɛge ke, urufoo puni mú maha mpyi numpini i. ");
INSERT INTO spp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Lire e ke yii yiye kàanmucya a wíi, yii bɛ̀ɛnmpe kà bú ŋkwɔ̀ nta numpire mɛ. ");
INSERT INTO spp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yii ɲyiigii ká ɲwɔ sèe sèl'e, làmpaŋi bɛ̀ɛnmpe sí yii pyi yii a ɲaa yii a ɲcwúu kuni i.» ");
INSERT INTO spp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mà Yesu yaha puru jwumpe na, ka Farizhɛnŋi wà si sà u yyere na u pa lyî uru yyére, ka u u ɲɛɛ. Tèni i pi à ɲjyìŋi kwûulo si raa lyî ke, ");
INSERT INTO spp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ka li i Farizhɛnŋi kàkyanhala, ɲaha na yɛ u à li kàanmucya mà li ɲya na Yesu ɲyɛ a u cyeyi jyè mà tàanna ná Yahutuubii làdaabil'e, maa nta na lyî mɛ. ");
INSERT INTO spp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kafooŋi Yesu à li ɲya l'à Farizhɛnŋi kàkyanhala ke, maa pi pyi: «Yii Farizhɛɛnbii pi ke, yii maha yii yajigiyi kàntuyi jyíi na fíniŋi, mà li ta yii funɲy'à ɲî nàŋkaage ná pege karigii na. ");
INSERT INTO spp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yii na ɲyɛ sìɲconyɔ! Kileŋi u à yaage kàntuge yaa ke, uru mú bà u à ku funŋke yaa mà? ");
INSERT INTO spp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yii nàŋkaage ná pege yaha, yii raa yii cyeyaayi kaan fòŋɔfeebil'á. Lire ká mpyi, yii sí n‑pyi fyìnmɛ sùpyii. ");
INSERT INTO spp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yii Farizhɛɛnbii pi ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii maha yii nànayeŋi ná kaɲyɛyi yafwɔhɔfwɔhɔre sannte puni yáhaŋi wwû, yii sí ɲyɛ na katiigii pyi, maa Kile kyaa táan yiy'á mɛ. Mà li ta lire l'à yaa li pyi yii kapyiini niɲcyiini, yii i nta a cyi sanŋkii bâra lire na. ");
INSERT INTO spp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yii Farizhɛɛnbii pi ke, yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii aha ŋkàre Kile Jwumpe kàlambayi i, bwompe tatɛɛnyi yii maha ɲcaa. Sùpyire tabinniyi i yii la maha mpyi sùpyire s'a yii pêre s'a yii shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yii wuun'à kɛ̀ɛge! Yii na ɲyɛ mu à jwo fanɲjyeye, sùpyire maha ɲaare na ntùuli ɲjemu ɲuŋ'i piye pàama ke.» ");
INSERT INTO spp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mà Yesu yaha puru jwumpe na, ka Kile Saliyaŋi cyelentuŋi wà si jwo: «Cyelentuŋi, mpe jwumpe saha ɲyɛ Farizhɛɛnbii kanni wumɔ mà dɛ! Mu na wuu cyere mú dɛ!» ");
INSERT INTO spp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ka Yesu si u pyi: «Yii Kile Saliyaŋi cyelentiibii wuun'à kɛ̀ɛge mú, ɲaha na yɛ yii à Kile Saliyaŋi pyi tuguro sùpyire ɲuŋ'i, pi sì n‑jà ntemu lwɔ́ mɛ. Yii yabilimpii mú sí ɲyɛ na ɲɛɛg'a pi tɛ̀gɛ ti ɲjwòŋi na, ali nimbilere mɛ. ");
INSERT INTO spp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yii wuun'à kɛ̀ɛge! Ɲaha na yɛ yii tulyey'à Kile tùnntunmpii mpiimu bò tèecyiini i ke, yii à pire kwɔ̀nhigii yaa na faanre. ");
INSERT INTO spp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lire l'à li cyêe na kapegigii yii tulyey'à pyi ke, na cyir'à bɛ̂ yii á, ɲaha na yɛ pir'à Kile tùnntunmpii bò. Ŋka yii pi ke, yii na pi kwɔ̀nhigii faanre. ");
INSERT INTO spp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kile à tɛ̀ɛn u yákilifente e maa jwo “Mii sí raa na tùnntunmpii pìi tunni pi á, pi sí pìi bò si pi sanmpii kyérege.” ");
INSERT INTO spp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Lire kurugo Kile tùnntunmpii pi à bò mà lwɔ́ fo tèecyiini i ke, Kile sí n‑pa yii ná yii tulyeyi cɛ̂ɛgɛ pire kyaa na, ");
INSERT INTO spp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mà lwɔ́ Abɛli mbòŋi na, fo mà sà nɔ Kile tùnntunŋi Zakari mbòŋi na, Zakari pi à bò Kileɲaarebage sèecyage ná sárayi tawwuge shwɔhɔl'e ke. Sèeŋi na mii sí yi jwo yii á, Kile sí yii ná yii tulyeyi cɛ̂ɛgɛ tire boore puni kurugo. ");
INSERT INTO spp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yii Kile Saliyaŋi cyelentiibii, yii wuun'à kɛ̀ɛge! Ɲaha kurugo yɛ kuni li maha sùpyire pyi t'à Kile jwumpe cè ke, yii à para pi yaha lire kuni i. Yii yabilimpii ɲyɛ na lire kuni ɲaare mɛ, mpii la ku ɲyɛ s'a li ɲaare ke, maa pire tɛgɛlɛ kwɔ̀n.» ");
INSERT INTO spp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ɲyɛ puru jwumpe puni kàntugo, ka Yesu si fworo uru Farizhɛnŋi bage e na ŋkɛ̀ɛge. Ka Saliyaŋi cyelentiibii ná Farizhɛɛnbii lùyiri wuubii si yibiyi shiŋi puni taha u na. ");
INSERT INTO spp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pi mpyi na lire pyi si nta u pɛrɛ ɲcû u ɲwɔshwɔɔre cye kurugo. ");
INSERT INTO spp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lire tèni i, ka supyikuruŋɔ nimbwɔhɔ si mpa bínni Yesu taan fo na piye fwòoŋi. Pi mpyi a shiin kampwɔhii lada kwɔ̀. Ka Yesu si jwumpe sìi u cyelempyiibii na maa jwo: «Yii a yiye kàanmucaa, yii àha fyìnmɛ tò wwomɔ na Farizhɛɛnbii fiige mɛ. Pi na ɲyɛ bwúuruŋi yîrigeyirige yaani fiige lire ndemu li maha mbyìmpe niɲcwɔnhɔmpe yîrige sùpyaŋi pàama ke. ");
INSERT INTO spp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yii li cè, kyaa maha kyaa l'à ŋwɔhɔ ke, cyire puni sí n‑pa raa ɲaa. Kyaa maha kyaa li ɲyɛ numpini i ke, lire là mú sì n‑kwôro ɲcèmbaa mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lire l'à li ta, yii aha jwumɔ maha jwumɔ ŋwɔh'a jwo numpini i ke, puru sí n‑lógo canŋke e, yii aha jwumɔ maha jwumɔ jwo katilwɔhɔre e yii bayi kùruɲcwɔngil'e ke, puru sí n‑pa raa jáare katanɲyi ɲuŋ'i.» ");
INSERT INTO spp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ka Yesu si núr'a jwo: «Yii pi ɲyɛ mii ceveebii ke, mii sí yi jwo yii á, ŋgemu u ɲyɛ u sì n‑jà yaage kabɛrɛ pyi sùpyaŋi na u mbòŋi kàntugo mɛ, yii àha raa fyáge uru yyaha na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yii à yaa yii a fyáge ŋgemu yyaha na ke, uru u ɲyɛ Kile, ɲaha na yɛ uru u maha jà a sùpyaŋi wà nafugombaage e u boŋkwooni kàntugo. Sèeŋi na mii sí yi jwo yii á, yii a fyáge Kile na. ");
INSERT INTO spp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tá zíiziinɛ kaŋkuro maha mpɛ́rɛ daashii shuunni kanna mɛ? Ŋka Kile à yaha ti puni niŋkin niŋkinŋi na, marii ti saɲcwɔnŋi sigili. ");
INSERT INTO spp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yii pi ke, yii li cè na yii kan'à waha Kile na mà tòro tire zíiziinɛ niɲyahara na. Ali ɲùɲjoore ti ɲyɛ yii ɲùɲyi i ke, Kile à tire puni pɛ̀rɛgɛ cè. Lire kurugo yii àha núru kyaa tɛ̀gɛ yiye funŋɔ pɛn mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ka Yesu si núr'a jwo: «Mii sí yi jwo yii á, shin maha shin ká yyére li na sùpyire ɲyii na na uru na ɲyɛ Supyaŋi Jyaŋi wu ke, Supyaŋi Jyaŋi mú sí n‑yyére li na Kile mɛ̀lɛkɛɛbii ɲyii na na urufoo na ɲyɛ uru wu. ");
INSERT INTO spp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ŋka ŋgemu ká mii cyé sùpyire ɲyii na ke, mii mú sí urufoo cyé Kile mɛ̀lɛkɛɛbii ɲyii na. ");
INSERT INTO spp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sùpya ká ɲcyé Supyaŋi Jyaŋi jwumpe na, lire kapiini sí n‑jà yàfa urufoo na. Ŋka ŋgemu ká Kile Munaani mɛge kɛ̀ɛge ke, lire kapiini sì yàfa urufoo na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pi aha mpa a yii cyáan na ɲcwôre na ŋkɛ̀ɛge Kile Jwumpe kàlambayi ɲùŋufeebii, lire ɲyɛ mɛ kìni yyaha yyére shiinbii ná yukyaabii yyére tèni ndemu i ke, jwumpe yii sí n‑jwo pi i ɲcè na yii na ɲyɛ sèeŋi ɲuŋ'i ke, yii àha puru kani tɛ̀gɛ yiye funŋɔ pɛn mɛ, ");
INSERT INTO spp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ɲaha na yɛ lire tèni yabiliŋi i, jwumpe yii à yaa yii jwo ke, Kile Munaani sí puru tîrige yii funŋ'i.» ");
INSERT INTO spp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mà Yesu yaha puru jwumpe na, ka nàŋi wà si jwo u á sùpyire shwɔhɔl'e: «Wuu cyelentuŋi, mii la ɲyɛ maa yi jwo mii yyahafooŋ'á na u wuu tuŋi kɔɔge táa, u u na nàzhan woge kan na á.» ");
INSERT INTO spp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ka Yesu si u pyi: «Ei! Nà wà we! Jofoo u à mii tìŋɛ mà pyi yii kacwɔnrɔŋi, lire ɲyɛ mɛ yii tuŋi kɔɔge táafooŋi yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɲyɛ Yesu à uru nàŋi ɲwɔ shwɔ amuni ke, maa yi jwo u lógofeebii pun'á: «Yii a yiye kàanmucaa, yii àha nàfuuŋi lage yaha ku tatɛɛngɛ fô yii na mɛ. Ɲaha kurugo yɛ sùpyaŋi nàfuuŋi mɛ́ɛ ká ɲyaha fo mà sà mpyi u tayahaga na ɲcaa na ŋkànre, yii li cè na uru nàfuuŋi sì n‑jà urufoo sige kwùŋi na mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mà tàanna ná puru jwumpe e, ka Yesu sí bàtaaga jwo pi á na: «Nàfuufooŋi wà u ná mpyi ná kɛrɛge e, kuru kɛrɛge yafaayi mpyi na ɲwɔge u á sèl'e. ");
INSERT INTO spp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Canŋka ka u u ntɛ̀ɛn maa funŋke cya maa jwo uye funŋ'i “Mii sàha naha na kapyii cè mɛ, ɲaha na yɛ tayahaga ɲyɛ mii niɲjyee sùmaŋi na mɛ.” ");
INSERT INTO spp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","U à funŋke kyáala a kwɔ̀ ke, maa jwo “Nde mii sí n‑pyi ke, lire li ɲyɛ, mii sí na bwɔ̀nhigii jya, si núru nimbwɔhii faanra, si na sùmaŋi ná na yaayi sanɲyi puni le cyire e. ");
INSERT INTO spp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lire ká mpyi, mii sí n‑jwo naye funŋ'i, na mii à yyee niɲyahagii ɲjyì bégel'a yaha naye mɛɛ na. Mii saha sì raa naye kànre mɛ, s'a lyî s'a byii si mpyi funntange e kanna.” ");
INSERT INTO spp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ɲyɛ uru nàfuufooŋ'à puru jwo uye funŋ'i mà kwɔ̀ ke, ka Kile si jwo u á “Mu funŋɔ baa shinŋi! Ŋke numpilage yabiliŋi i, mu sí n‑kwû. Yaayi mu à bégel'a yaha maye mɛɛ na ke, jofoo u sí n‑pyi ná yire e yɛ?” ");
INSERT INTO spp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ɲyɛ amuni li mú ɲyɛ, shin maha shin u ɲyɛ na nàfuuŋi caa na bínnini ŋge diɲyɛŋi i uye mɛɛ na, mà li ta nàfuu ɲyɛ urufol'á Kile yyére mɛ, urufoo sí n‑pa n‑kwû n‑yîri u taan ŋge nàfuufooŋi fiige.» ");
INSERT INTO spp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ɲyɛ ka Yesu si jwo u cyelempyiibil'á: «Lire e mii sí yi jwo yii á, yalyire yii sí raa lyî ná vàanɲyi yii sí raa leni ke, yire taŋkanni kà yii funŋɔ pɛn mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ɲaha kurugo yɛ sùpyaŋi múnaani tayyéreg'à fànha tò yalyire na, ka u cyeere tayyérege mú si fànha tò vàanɲyi na. ");
INSERT INTO spp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yii saɲcyɛɛnre kàanmucya kɛ! Ti ɲyɛ na faa pyi mɛ, ti ɲyɛ na sùma kwùun mɛ, sùma tabegege mú ɲyɛ t'á mɛ. Ŋka Kile maha ti ɲwɔ caa. Tá yii ɲyɛ a pwɔ́rɔ saɲcyɛɛnre na sèl'e mɛ? ");
INSERT INTO spp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Funmpɛɛnre sí n‑jà yii jofoo pyi u jà a nimbilere bâra u shìŋi canmpyaagii na yɛ? ");
INSERT INTO spp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ɲyɛ kampyi funmpɛɛnre sì n‑jà yafyin bâra yii shìŋi canmpyaagii na mɛ, ɲaha na yii à yaayi sanɲyi kani tɛ̀g'a yiye funŋɔ pɛn yɛ? ");
INSERT INTO spp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yafwɔhɔfwɔhɔyi yi maha fyîn sige e maa yafyɛɛnre nisinante yaa ke, yii sɔ̂nŋɔ yire kyaa na kɛ! Yi ɲyɛ na báara pyi mɛ, yi mú ɲyɛ na kòonɔ pînni mɛ. Ŋka saanŋi Solomani ná u nàfuufente puni i, u vàanndeŋke kà lemɛ ɲyɛ a jà a ɲwɔ mà ŋke yafwɔhɔfwɔhɔge kà niŋkin yafyɛnrɛ kwɔ̀ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yafwɔhɔfwɔhɔyi yi ɲyɛ sige e niɲjaa, ná nùmpanŋa yi sí n‑le nage e ke, Kile ká yire lemɛ pyi p'à ɲwɔ amuni, yii ɲyɛ a li cè na nàkaana baa Kile sí vàanɲyi kan yii á mà? Yii dániyaŋ'à cyɛ́rɛ dɛ! ");
INSERT INTO spp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yii yalyire ná yii yabyɛɛre taŋkanni ɲyɛ a yaa li tatɛɛnge fô yii na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mpii pi ɲyɛ pi ɲyɛ a dá Kile na mɛ, pire pi maha funɲyi pɛn ná yire yaayi kani i tèrigii puni i. Yii sí pi ke, yaaga maha yaaga kyaa li ɲyɛ yii na ke, yii Tuŋi Kile à yire puni cè. ");
INSERT INTO spp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mà jwo yii kwôro yii a yire yaayi caa ke, yii yacyage niɲcyiig'à yaa ku pyi Kile Saanre. Lire ká mpyi, u sí yire yaayi sanɲyi kan yii á.» ");
INSERT INTO spp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ka Yesu si núr'a jwo u cyelempyiibil'á: «Yii na ɲyɛ mu à jwo mpàkuruŋɔ nimbilere, ŋka yii àha raa fyáge mɛ, ɲaha na yɛ l'à táan yii Tuŋi Kile e mà yii le u Saanre e. ");
INSERT INTO spp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yii yii cyeyaayi pɛ́rɛ, yii i uru wyɛ́rɛŋi tɛ̀g'a fòŋɔfeebii tɛ̀gɛ. Yii nàfuu tabegege niɲcɛnŋɛ yaa yiye mɛɛ na nìɲyiŋi na, ŋkemu ku ɲyɛ ku nàfuuŋi sì n‑kwɔ̀ mɛ. Nàŋkaalii ná ntɔɔn ɲyɛ kuru cyage e si ŋkwɔ̀ u kɛ̀ɛge mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yii li cè, cyage e sùpyaŋi nàfuuŋi ɲyɛ ke, wani u sɔ̀nŋɔre maha mpyi.» ");
INSERT INTO spp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ka Yesu sí núr'a jwo u lógofeebil'á: «Yii yii báarapyi vàanɲyi le yii i bégele tèrigii puni i. Yii i yii làmpaabii mîn'a yaha tèrigii puni i. ");
INSERT INTO spp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yii pyi mu à jwo báarapyii mpiimu pi à bégel'a tɛ̀ɛn pyɛnge e, na pi ɲùŋufooŋi tèepani sigili, u aha yîri cikwɔɔnre cyage e, mà pa tère o tère e, maa mpa pyɛnge ɲwɔge kúu ke, pi i yîr'a ku múgo u á. ");
INSERT INTO spp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ɲyɛ ɲùŋufooŋi ká mpa báarapyiibii mpiimu ta ŋɔ́ɔmbaa ke, pire wuuni sí ɲwɔ. Sèeŋi na mii sí yi jwo yii á, lire ká mpyi, ɲùŋufooŋi sí uye pwɔ si ɲjyì yaa ŋkan báarapyiibii puni niŋkin niŋkinŋ'á, pi lyî. ");
INSERT INTO spp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Lire e ke ɲùŋufooŋ'à pa ɲìɲiŋke na yo, u à pa ŋkùpecyiini na yo, u aha mpa báarapyiibii mpiimu ta ŋɔ́ɔmbaa ke, pire wuuni kɔni sí ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yii li cè na kàmpyi bage fooŋi mpyi maha nàŋkaaŋi tèepani cè, u mpyi maha sí ɲɛɛ u yaha u kakyaare pyi mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Lire e ke yii mú à yaa yii bégel'a kwôro, ɲaha na yɛ tèni i Supyaŋi Jyaŋi sí núru n‑pa ke, yii ɲyɛ a lire cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesu à puru jwo ke, ka Pyɛri si u pyi: «Kafooŋi, mu à ŋke bàtaage jwo mà yyaha tíi ná wuu kanni i laa, sùpyire puni kyaa li?» ");
INSERT INTO spp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ka Yesu si u pyi: «Báarapyiŋi na, ɲùŋufooŋ'à dá pi sanmpii shwɔhɔl'e, u yákiliŋi mú s'à pêe ke, uru báarapyiŋi shiŋi ɲùŋufooŋi maha yaha u u pyɛnge karigii cwɔɔnre, maa ɲjyìŋi kaan báarapyiibii sanmpil'á u tèekanl'e. ");
INSERT INTO spp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ɲyɛ báarapyi maha báarapyi ɲùŋufoo, u à pa u ta u u báaraŋi niɲcɛnŋi pyi amuni ke, uru wuuni sí ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sèeŋi na mii sí yi jwo yii á, uru báarapyiŋi ɲùŋufooŋi sí u pyɛnge karigii puni ɲùŋufente le u cye e. ");
INSERT INTO spp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ŋka báarapyiibii kacwɔnrɔŋi ŋgemu ká a sɔ̂nŋi uye funŋ'i na uru ɲùŋufooŋi sí mɔ lire kùluni i, maa wá na u báarapyiɲɛɛbii bwùun, maa uye yaha ɲjyìŋi ná mbyaŋi laage e, maa sinmpe byii na ɲcwo ke, ");
INSERT INTO spp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","canŋke ku ɲyɛ uru báarapyiŋi ɲyɛ a tɛ̀ɛn ná k'e ná tèni li ɲyɛ u ɲyɛ a sɔ̂nŋɔ ná l'e mɛ, u ɲùŋufooŋi sí n‑pâa n‑pa. Kapii maha kapii u à pyi ke, ɲùŋufooŋi sí u kyérege cyire puni na, mpii pi ɲyɛ pi ɲyɛ Kile kuni i mɛ, si u ná pire sàraŋi pyi niŋkin. ");
INSERT INTO spp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Báarapyiŋi u à ɲùŋufooŋi ɲyii wuuni cè maa mpyi u ɲyɛ na li pyi mɛ, uru báarapyiŋi bwɔɔnre nizhwɔɔre sí ɲyaha dɛ! ");
INSERT INTO spp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ŋka báarapyiŋi u ɲyɛ u ɲyɛ a u ɲùŋufooŋi ɲyii karigii cè mɛ, maa ntòr'a wurug'a kapyimbaala pyi ndemu l'à yaa ná bwɔnr'e ke, urufoo sì bwɔnrɔ niɲyahara shwɔ mɛ. Amuni li mú ɲyɛ, Kile à yaaya niɲyahaya kan ŋgemu á ke, u maha yaaya niɲyahaya cya urufol'á. U aha karii niɲyahaɲyahagii le ŋgemu cye e ke, u sí urufoo yíbe karii niɲyahaɲyahagii kyaa na mú.» ");
INSERT INTO spp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ka Yesu sí núr'a jwo: «Mii à pa mpa nage le ɲìŋke na. Mii la mpyi numɛ si ku ta k'à mîn'a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ŋka mii à yaa mii u mbyîgimɛ yyefuge e fɔlɔ, mu à jwo bà sùpyaŋi ká a ŋko si batize pi maha u mbyîgimɛ lwɔhe e pyiŋkanni ndemu na mɛ. Mii funvwugo wuŋi u ɲyɛ na cyire karigii canmpyige sigili. ");
INSERT INTO spp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yii àha raa sɔ̂nŋi na mii à pa si mpa jwumabeŋke le sùpyire ná tiye shwɔhɔl'e ɲìŋke na mà dɛ! Mii sí yi jwo yii á, mii à pa mpa mbèmbaaŋi le sùpyire ná tiye shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Lire kurugo mà lwɔ́ numɛ na, shiin kaŋkuro sí n‑pyi pyɛnyi y'e, pi sì n‑bɛ̂ mɛ. Shiin taanre sí n‑wwɔ̀ s'a shiin shuunni tùnni, shiin shuunni sí n‑wwɔ̀ s'a shiin taanre tùnni. ");
INSERT INTO spp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pyɛnyi y'e, tufooŋi sí n‑yîri jyafooŋi kurugo, jyafooŋi mú sí n‑yîri tufooŋi kurugo. Nufooŋi sí n‑yîri pworofooŋi kurugo, pworofooŋi mú sí n‑yîri nufooŋi kurugo. Nacwoŋi sí n‑yîri napworoŋi kurugo, napworoŋi mú sí n‑yîri nacwoŋi kurugo.» ");
INSERT INTO spp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Supyikuruŋke ku mpyi wani ke, ka Yesu si núr'a jwo kur'á: «Yii aha kileŋi ɲya u à wwɔ̀ canŋacwumpe e, yii maha jwo na zànha sí n‑pa, nàkaana baa ku mú maha mpa. ");
INSERT INTO spp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kafɛɛge ká a fwu na yîri wòro kùl'e, yii maha jwo na kafuge sí n‑pêe niɲjaa dɛ! Amuni li mú maha mpyi. ");
INSERT INTO spp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yii pi à fyìnmɛ tò wwomɔ na ke, yii à jà a cyire karigii puni tèepyiiŋkii cè, ka ɲaha si li ta ɲcyii cyi ɲyɛ na mpyi yii shwɔhɔl'e numɛ ke, yii ɲyɛ a jà a cyire cè mà yɛ? ");
INSERT INTO spp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ɲaha na kani yii à yaa yii pyi ke, yii ɲyɛ a jà a lire cè yiy'á si li pyi pyiŋkanna niɲcɛnnɛ na mà yɛ? ");
INSERT INTO spp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wà ha mu yyere fànhe e, ka yii i wá na ŋkɛ̀ɛge wani, mu à yaa mu u jwumabeŋɛ cya fwɔfwɔ ná urufol'e kuni na, bà u si mpyi u àha ma le yukyaaŋi cye e, uru si ma le u báarapyiŋi cye e, pi i ma le kàsuŋi i mɛ. ");
INSERT INTO spp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mii sí yi jwo mu á, mu aha mpyi mu ɲyɛ a lire pyi mɛ, mu sì n‑sìi n‑fworo wani ná mu ɲyɛ a urufoo fwooni tò feefee mà yɛ!» ");
INSERT INTO spp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ɲyɛ mà Yesu yaha puru jwumpe na, ka sùpyire tà si mpa Galile kùluni shiinbii pìi mbò jwo u á. Fànhafooŋi Pilati u mpyi a pìi tun pi à sà pire bò Kileɲaarebage e mà pi yaha pi i sárayi wwû. ");
INSERT INTO spp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ka Yesu si pi pyi: «Nte sùpyire ti nte pi à bò amɛ ke, yii na sɔ̂nŋi na pire kapegigii nimpyiiŋkii cyi mpyi a ɲyaha mà tòro Galile kùluni shiinbii sanmpii wogigii na bɛ? ");
INSERT INTO spp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lire bà mɛ, ŋka mii sí yi jwo yii á, ná yii ɲyɛ a yii toroŋkanni kɛ̂ɛnŋɛ mɛ, yii puni mú sí n‑kwû. ");
INSERT INTO spp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Silowe batɔɔnge k'à keb'a cwo Zheruzalɛmu kànhe shiinbii kɛ ná baataanreŋi mpiimu ɲuŋ'i mà bò ke, yii na sɔ̂nŋi na pire kapegigii nimpyiiŋkii cyi à ɲyaha mà tòro Zheruzalɛmu kànhe shiinbii sanmpii wogigii na bɛ? ");
INSERT INTO spp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lire bà mɛ, ŋka mii sí yi jwo yii á, ná yii ɲyɛ a yii toroŋkanni kɛ̂ɛnŋɛ mɛ, yii puni mú sí n-kwû.» ");
INSERT INTO spp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ɲyɛ ka Yesu si bàtaaga jwo pi á na: «Nàŋi wà na mpyi ná ɛrɛzɛn cikɔɔge e. Ɛrɛzɛn cire shwɔhɔl'e fizhiye cige na mpyi wani. Cikɔɔge foo mpyi maha sì na kuru cige kàanmucaa u aha ŋkwɔ̀ a yasɛrɛ ta ku na. Ŋka u shèe maha shèe, u mpyi maha sà yafyin ta ku na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ka u u yi jwo u báarapyiŋ'á “Wíi, cyi yyee taanre cyi ɲyɛ ɲcyii, mii na ma na ŋke cige kàanmucaa kampyi k'à yasɛrɛ yaa, mii sí sì tà ta ku na mɛ. Ku kwɔ̀n à wà, ɲaha na yɛ ku ɲyɛ cikɔɔge cire sannte shwɔhɔl'e kaɲwɔɔ baa.” ");
INSERT INTO spp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ka báarapyiŋi si u pyi “Mii ɲùŋufooŋi, mii na li caa mu á, maa ku yaha ku niɲjyee pyi, mii sí ku ɲùŋke tùgo n‑kwûulo si ŋkyàra le ku taan. ");
INSERT INTO spp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lire ká mpyi, ka ku u yasɛrɛ pyi yyeela, ku sí n‑yaha wani. Ŋka k'aha mpyi ku ɲyɛ a yasɛrɛ pyi mɛ, maa nta a ku kwɔ̀n.”» ");
INSERT INTO spp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ɲyɛ Yahutuubiicanŋɔŋke k'e, Yesu mpyi na sùpyire kâlali Kile Jwumpe kàlambage k'e. ");
INSERT INTO spp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sùpyire shwɔhɔl'e ceeŋi wà na mpyi wani, jínaŋi wà mpyi u e, uru jínaŋi mpyi a yyee kɛ ná baataanre pyi u e, maa dàŋi yampe yaha u na, fo mà u pyi u saha ɲyɛ na jà a tíl'a yyére mɛ. ");
INSERT INTO spp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ɲyɛ Yesu à u ɲya ke, maa u yyere maa jwo u á: «Ceewe, mu yamp'à láha mu na niɲjaa.» ");
INSERT INTO spp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","U à puru jwo ke, maa u cyeyi taha u na, lire tèenuuni i, ka ceeŋi tùbuŋi si ntíl'a sànhana, ka u u Kile kêe. ");
INSERT INTO spp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ɲyɛ tèni i Kile Jwumpe kàlambage ɲùŋufooŋ'à Yesu ɲya u à ceeŋi cùuŋɔ canŋɔŋke e ke, ka li i u lùuni yîrige sèl'e, ka u u jwumpe lwɔ́ maa jwo sùpyir'á: «Cibilaage e, yii à yaa yii a báaraŋi pyi canmpyaa baani funŋ'i, lire e ke yii a ma, yii a cicuumpe caa cyire canmpyaagil'e, ŋka canŋɔŋke e bà mɛ!» ");
INSERT INTO spp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ka Kafooŋi Yesu si u pyi: «Yii pi à fyìnmɛ tò wwomɔ na ke, jofoo u ɲyɛ yii shwɔhɔl'e ŋgemu u ɲyɛ u ɲyɛ na u nìiyi, lire ɲyɛ mɛ u dùfaanɲyi sànre canŋɔŋke e maa yi kan y'à bya mà yɛ? ");
INSERT INTO spp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ná yii maha jà a lire pyi, ŋge ceeŋi sí u ɲyɛ Ibirayima tùluge shin ke, ka Sitaanniŋi si u cû a pwɔ, fo yyee kɛ ná baataanre e, ka ɲaha si li ta tire pwɔɔre kà ɲjà zànha ndáha uru ceeŋi na canŋɔŋke e mà yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ɲyɛ Yesu à puru jwo ke, ka u zàmpɛɛnbii puni si silege. Ŋka sùpyire sannte puni mpyi funntange e Yesu kabwɔhigii nimpyiiŋkii puni kurugo. ");
INSERT INTO spp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ɲyɛ ka Yesu si núr'a kàlaŋi sogo maa jwo: «Kile Saanre ɲyɛ mu à jwo ɲaha bɛ? Ná ɲaha shi i mii sí ti tàanna bɛ? ");
INSERT INTO spp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ti na ɲyɛ mu à jwo mutaridi cige yasɛrɛ, nàŋi wà a sà ntemu nûgo u cikɔɔge e ke. Kuru cige pyàŋi maha yîlege, ŋka u aha fyîn, cige maha lyɛge fo maha mpa mpyi cibwɔhɔ, saɲcyɛɛnr'a sì wá na ti shèere yaa ku ŋkéɲyi i.» ");
INSERT INTO spp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","«Ná ɲaha shi i mii sí Kile Saanre tàanna sahaŋki yɛ? ");
INSERT INTO spp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ti na ɲyɛ bwúuruŋi yîrigeyirige yaani fiige. Ceewe ká li nimbilere le farini mbyìmɛ niɲyaham'i mà cwɔ̀nhɔ, li maha puru mbyìmpe niɲcwɔnhɔmpe puni yîrige.» ");
INSERT INTO spp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ɲyɛ lire kàntugo ka Yesu si ntòro ná ɲani i, na ŋkɛ̀ɛge Zheruzalɛmu kànhe kàmpanŋke na. U niŋkareŋi mpyi na Kile jwumpe yu sùpyir'á kànbwoyi ná kànpyɛɛre na. ");
INSERT INTO spp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ka nàŋi wà si u pyi: «Kafooŋi, tá nùmpanŋa tafeebii sí ɲyaha bɛ?» Ka Yesu si pi pyi: ");
INSERT INTO spp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Yii fànha le yii i jyè tajyiɲwɔge nimbileni i, ɲaha na yɛ mii sí yi jwo yii á, tèni là na ma shinɲyahara la sí n‑pa n‑pyi si jyè kuru tajyiɲwɔge e, ŋka pi sì n‑pa jà mɛ. ");
INSERT INTO spp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tèni i bage foo sí n‑pa n-yîri si bage tò si ku shwɔ̂hɔ ke, lire ká yii ta cyíinŋi na, yii sí raa bage kúuli s'a ŋko “Kafooŋi! Ɲwɔge múgo wuu á.” Lire ká mpyi, Kafooŋi sí n‑jwo yii á na uru ɲyɛ a yii cè mɛ. ");
INSERT INTO spp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Lire tèni i, yii sí raa ŋko “Ko wuu ná mu à têl'a lyî maa bya siɲcyan kɛ! Mu mú s'à Kile jwumpe jwo wuu á wuu kànhe pyɛnkuuŋi i, ka mu u núr'a jwo na mu ɲyɛ a wuu cè mà?” ");
INSERT INTO spp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yii aha puru jwo, u sí núru yi taha yii á na uru ɲyɛ a yii cè mɛ, na yii yîri uru taan, yii kapimpyiibii. ");
INSERT INTO spp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ɲyɛ mà yii yaha cyíinŋi na, yii aha mpa yii tulyeyi Ibirayima ná Ishaka ná Yakuba ná Kile tùnntunmpii puni ɲya Kile Saanre e tèni ndemu i ke, yii nàvunŋɔ wuubii sí raa myahigii súu s'a ŋkyànhigii kùru. ");
INSERT INTO spp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sùpyire tà mú sí raa yîri diɲyɛŋi ɲùɲyi sicyɛɛreŋi na, si mpa jyè Kile Saanre e, si lyî. ");
INSERT INTO spp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Lire tèni i, sùpyire ti ɲyɛ numɛ kàntugo yyére ke, tire tà sí n‑pa n‑pyi yyaha yyére. Mpii pi ɲyɛ numɛ yyaha yyére ke, pire pìi mú sí n‑pa n‑pyi kàntugo yyére.» ");
INSERT INTO spp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ɲyɛ lire tèni yabiliŋi i, ka Farizhɛɛnbii pìi si file Yesu na, maa yi jwo u á: «Mu à yaa mu u fworo nde kùluni i feefee, ma a sì cyage kabɛr'e, ɲaha na yɛ saanŋi Erɔdi wá na mu caa raa bùu.» ");
INSERT INTO spp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ka Yesu si pi pyi: «Yii a sì, yii i sà yi jwo Erɔdi cwofooŋ'á, na mii naha na jínabii kɔ̀re na yige pifeebil'e marii yampii cùuŋi ɲcyii canmpyaagii shuunniŋi i, cyire ká ntòro, canntanrewoge e mii báaraŋi sí n‑kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mii à yaa mii u cyire canmpyaagii taanreŋi pyi si sà na báaraŋi fûnŋɔ Zheruzalɛmu kànhe e. Ɲaha kurugo yɛ Kile tùnntunŋi wà tufiige ɲyɛ a yaa u bò cyage kabɛr'e Zheruzalɛmu kàntugo mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ka Yesu sí núr'a jwo: «Ei! Zheruzalɛmu shiinbii, yii Zheruzalɛmu kànhe shiinbii, yii pi maha Kile tùnntunmpii wà ná kafaayi i maha bùu ke, y'à tooyo niɲyahaya kwɔ̀, mii la mpyi si yii bínni yiye e, s'a yii kàanmucaa, bà ŋkùnuŋi maha u pyìre bínni tiye e maa bûru ti ɲuŋ'i mɛ. Ŋka yii ɲyɛ a ɲɛɛ lire e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ku ke numɛ! Kile sí cye wwû yii kànhe taan si yii yaha yiye kanna na. Mii sí yi jwo yii á, yii ɲyiini saha sì n‑tɛ̀gɛ mii na mɛ, fo canŋke yii sí n‑pa raa ŋko “Ŋgemu u ɲyɛ na ma Kafooŋi Kile mɛgɛ na ke, Kile u jwó le ur'á.”» ");
INSERT INTO spp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Ɲyɛ Yahutuubiicanŋɔŋke k'e, Farizhɛɛnbii ɲùŋufooŋi wà mpyi a Yesu yyere na u sà lyî uru yyére, ka Yesu si ɲɛɛ. Sùpyire ti mpyi wani uru shinbwoŋi pyɛnge e ke, nàŋi wà yaŋgwu na mpyi tire shwɔhɔl'e, puru yampe mpyi a u cyeere cyeyi yà pyi y'à fwɔ fwɔ. Ka pi i wá na Yesu kàanmucaa kampyi u sí ɲɛɛ uru yaŋi cùuŋɔ canŋɔŋke e. ");
INSERT INTO spp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ka Yesu si jwumpe lwɔ́ maa Kile Saliyaŋi cyelentiibii ná Farizhɛɛnbii yíbe: «Mà tàanna ná wuu Saliyaŋi i, wà à yaa u jà a yaŋa cùuŋɔ canŋɔŋke e la?» ");
INSERT INTO spp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ka pi i fyâha, pi wà ɲyɛ a ɲɛn'a u ɲwɔ shwɔ mɛ. Ka Yesu si u cyeyi taha yaŋi na maa u cùuŋɔ, maa u pyi u a sì pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lire kàntugo ka Yesu si núr'a pi yíbe: «Jofoo u ɲyɛ yii shwɔhɔl'e, ná urufoo jyaŋi, lire ɲyɛ mɛ u nùŋi wà ká ɲcwo bɛ̀ɛnŋ'i mà bɛ̂ ná canŋɔŋke e, urufoo sí ɲɛɛ u yaha wwùmbaa yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pi ɲyɛ a ɲɛn'a u ɲwɔ shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ɲyɛ Yesu à pa li kàanmucya mà li ɲya na Farizhɛnŋ'à sùpyire ntemu yyere ke, na bwompe tatɛɛnyi kurugo pi puni ɲyɛ na fî ke, ka u u ŋke bàtaage jwo pi á: ");
INSERT INTO spp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Sùpya ká mu yyere cikwɔnrɔ na, ka mu u shà, ma hà zà ntɛ̀ɛn yatɛɛnɲyi puni yyaha yyére woge e mɛ. Ɲaha kurugo yɛ u aha nta u à shinbwoŋi wà yyere ŋgemu u à fànha tò mu na ke, ");
INSERT INTO spp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","uru ká mpa, ka yii yyerefooŋi si mu pyi, na ma yîri maa kuru yatɛɛnŋke kan uru shinbwoŋ'á, mu silege wuŋi u sí n‑yîri n‑sà n‑tɛ̀ɛn fo kàntugo yyére yatɛɛnŋke e. ");
INSERT INTO spp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lire e mii sí yi jwo yii á, pi aha yii wà yyere lire kataanni fiige na, mu aha shà, sà ntɛ̀ɛn yatɛɛnɲyi puni kàntugo yyére woge e. Lire ká mpyi, mu yyerefooŋi ká li ɲya na mu à yaa ná yatɛɛnŋke yyaha yyére woge e, maa sà mu pyi “Na cevoo, yîri ma a ma naha, yatɛɛnŋke yyaha yyére woge e.” Lire tèni i, mu ɲùŋke sí n‑yîrige ma lyìɲɛɛbii shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lire e yii li cè, shin maha shin u à uye dùrugo ke, Kile sí urufoo tîrige, ŋka shin maha shin u à uye tîrige ke, Kile sí urufoo dùrugo.» ");
INSERT INTO spp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ɲyɛ nàŋi u mpyi a Yesu yyere na u sà lyî uru yyére ke, ka Yesu si yi jwo ur'á: «Mu aha a ŋko si sùpyii yyere pi pa lyî mu yyére canŋke e, lire ɲyɛ mɛ numpilage e, mu sùpyire niɲjyerere ɲyɛ a yaa ti pyi mu ceveebii ná mu sìɲɛɛbii ná mu cìnmpyiibii ná mu tɛɛnɲɛɛbii nàfuufeebii mɛ. Ɲaha kurugo yɛ pire mú sí n‑jà mu yyere canŋka, nde mu à pyi pi á ke, si lire fwooni tò mu á. ");
INSERT INTO spp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ŋka mu aha sí raa kataan pyi, mu à yaa mu u fòŋɔfeebii ná cwɔ̀hɔmɔfeebii ná dìshiyifeebii ná fyinmpii yyere. ");
INSERT INTO spp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lire ká mpyi, mu wuuni sí ɲwɔ, mpii pi à tíi ke, Kile ká pire ɲɛ̀ a yige kwùŋi i canŋke ŋkemu i ke, kacɛnni mu à pyi tire sùpyire na ke, u sí lire fwooni tò mu á, ɲaha na yɛ pi ɲyɛ a mpyi a jà a mu kacɛnni fwooni tò mu á mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ɲyɛ Yesu lyìɲɛɛbil'à puru jwumpe lógo ke, ka pi wà niŋkin si jwumpe lwɔ́ maa jwo u á: «Mpii pi sí n‑jyè Kile Saanre e si lyî ke, pire wuun'à ɲwɔ!» ");
INSERT INTO spp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ka Yesu si uru nàŋi ɲwɔ shwɔ ná bàtaag'e na: «Canŋka nàŋi wà u ná ɲjyì niɲyahawa shwɔhɔ, maa shinɲyahara yyere pi sà lyî uru yyére. ");
INSERT INTO spp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tèelyiin'à pa nɔ ke, ka u u u báarapyiŋi tun u sà sùpyire yyere pi pa lyî. ");
INSERT INTO spp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ŋka pi pun'à karii mɛgɛ le maa ɲcyé karaga uru ɲjyìŋi talyige e. Shincyiiŋi báarapyiŋ'à yyere ke, ka uru si yi jwo u á “Sà yi jwo ma ɲùŋufooŋ'á na u uye sanŋa yaha na á, mii à kɛrɛgɛ shwɔ, mii à yaa mii u sà ku kàanmucya.” ");
INSERT INTO spp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ka báarapyiŋi si ŋkàr'a sà wabɛrɛ yyere, ka uru si u pyi “Sà yi jwo ma ɲùŋufooŋ'á na u uye sanŋa yaha na á, mii à nupyahii kɛ shwɔ, mii s'à yaa mii u sà cyi taanna faaŋi na.” ");
INSERT INTO spp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ka u u núr'a kàr'a sà wabɛrɛ yyere, ka uru mú si u pyi “Sà yi jwo ma ɲùŋufooŋ'á na mii à ceewe fúru numɛ. Lire kurugo mii sì n‑jà n‑shà mɛ.” ");
INSERT INTO spp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ɲyɛ ka báarapyiŋi si núr'a pa puru jwumpe yyaha jwo u ɲùŋufooŋ'á. Ka u lùuni si yîri, maa jwo báarapyiŋ'á na u fyâl'a sà fòŋɔfeebii ná cwɔ̀hɔmɔfeebii ná dìshiyifeebii ná fyinmpii yyere, sùpyire tabinniyi ná pyɛnkuuŋi i, u a ma. ");
INSERT INTO spp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ɲyɛ báarapyiŋ'à sà pire yyere ke, maa jwo u ɲùŋufooŋ'á “Mii ɲùŋufooŋi, mii à mu tùnnture pyi ŋka tatɛɛnyɛ niŋgaya saha na naha dɛ!” ");
INSERT INTO spp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ka ɲùŋufooŋi si u pyi “Sà ma a ɲaare ma a mâre kumbwoyi ná kɛrɛkuubil'e, ma a fànha le ma a sùpyire kárama t'a ma, bà tatɛɛnyi sanɲyi si mpyi si ɲî mɛ. ");
INSERT INTO spp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mii sí yi jwo yii á, sùpyire t'à yyere yyecyiige na, ka ti i ɲcyé paŋa ke, pire wà cye sì n‑jyè mii ɲjyìŋi i mɛ.”» ");
INSERT INTO spp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Canŋka mà Yesu yaha ɲani na, supyikuruŋɔ nimbwɔhɔ mpyi a taha u fye e. Ka u u yyaha kɛ̂ɛnŋɛ pi á, maa jwo: ");
INSERT INTO spp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Shin maha shin la ku ɲyɛ si mpyi mii cyelempya ke, ná urufoo ɲyɛ a mii kyaa táan uy'á mà tòro u tuŋi ná u nuŋi ná u cwoŋi ná u pyìibii ná u sìɲɛɛbii na, maa mii kyaa táan uy'á, ali mà tòro u yabiliŋi na mɛ, urufoo ɲyɛ a yaa ná mii cyelempyigire e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Shinŋi la ku ɲyɛ si mpyi mii cyelempya ke, urufoo u taha mii fye e, pi mɛ́ɛ mpyi na sí urufoo bò kworokworocige na. Lire baare e urufoo ɲyɛ a yaa ná mii cyelempyigire e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jofoo u ɲyɛ yii shwɔhɔl'e, ná urufoo la ɲyɛ si batɔɔngɔ faanra, u sì n‑tɛ̀ɛn si funŋke kyaala fɔlɔ, si li kàanmucya kampyi u sí n‑pa n‑jà ku faanra n‑kwɔ̀ mà yɛ? ");
INSERT INTO spp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ná urufoo ɲyɛ a lire pyi mɛ, maa ku ɲwɔ cû na faanre, kàntugo ka bage sanŋke si u jà faanraga, mpii pi na ntùuli marii ku ɲaa ke, pire sí raa urufoo cyàhali, ");
INSERT INTO spp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","s'a ŋko: “Aa! Ŋge nàŋ'à u bage ɲwɔ cû na faanre, ka ku u mpa u jà faanraga.” ");
INSERT INTO spp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Amuni li mú ɲyɛ, l'aha mpyi mu à jwo saanŋi wà na ŋko raa kàshi kwùun u saanɲɛɛŋi wà na ná u kàshikwɔɔnbii kampwɔhii kɛŋi i (10.000). Tá u sí n‑tɛ̀ɛn si funŋke kyaala si ɲcè kampyi u kàshikwɔɔnbii sí n‑jà u zàmpɛnŋi kàshikwɔɔnbii kampwɔhii beɲjaagaŋi (20.000) tùn mɛ? ");
INSERT INTO spp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ŋka u aha li kàanmucya mà li ɲya na u sì n‑jà uru saanŋi na mɛ, u sí n‑wyɛ̀rɛ sìsurufoo tùugo u sà jwumabeŋɛ cya u á. ");
INSERT INTO spp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ɲyɛ amuni li mú ɲyɛ, yii ŋgemu ká mpyi u ɲyɛ a kàntugo wà u cyeyaayi puni na mɛ, urufoo sì n‑jà n‑pyi mii cyelempya mɛ. ");
INSERT INTO spp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Suumpe na ɲyɛ yacɛnŋɛ. Ŋka pu tìpoompe ká fworo p'e, ɲaha ku sí n‑jà pu pyi pu táan sahaŋki yɛ? ");
INSERT INTO spp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pu saha sì n‑jà là ɲwɔ ɲìŋke na mɛ, pu mú sì n‑jà n‑pyi ŋkyàra mɛ. Pu sí n‑wà cyíinŋi na. Ɲyɛ shin maha shin la ku ɲyɛ si karii yyaha cè ke, urufoo u niŋgyigigii pɛrɛ, u raa núru.» ");
INSERT INTO spp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ɲyɛ canŋka, mɛpɛngɛ shiinbii pìi niɲyahamii mu à jwo múnalwɔɔre shwofeebii mpyi a pa bínni Yesu taan s'a u jwumpe núru. ");
INSERT INTO spp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ɲyɛ Farizhɛɛnbii ná Kile Saliyaŋi cyelentiibil'à lire ɲya ke, ka pi i wá na ŋkunni piye shwɔhɔl'e na: «Ɲaha na ŋge nàŋ'à ɲɛn'a mɛpɛngɛ shiinbii yaha pi i bârali u na, fo maha bínnini na lyî ná pi e yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ɲyɛ Yesu à pi kunuŋke lógo ke, maa ŋke bàtaage jwo pi á na: ");
INSERT INTO spp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Jofoo u ɲyɛ yii shwɔhɔl'e, kampyi mpàa ŋkuu (100) pi ɲyɛ urufol'á, ka wà niŋkin si mpînni, tá urufoo maha pi sanmpii beecyɛɛre ná kɛ ná baacyɛɛreŋi (99) yaha wabɛr'á sige e, maa sà a nimpinniŋi caa fo u aha ɲya mɛ? ");
INSERT INTO spp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","U aha u cya a ɲya tèni ndemu i ke, u funntanga wuŋi sí u lwɔ́ nde yacige e, ");
INSERT INTO spp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","si mpa pyɛngɛ. U aha mpa ná u e, u sí u ceveebii ná u tɛɛnɲɛɛbii yyere si jwo “Yii a ma, wuu u mpa múguro siɲcyan. Mii mpàŋi u mpyi a pînni ke, mii à u ɲya.” ");
INSERT INTO spp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mii sí yi jwo yii á, amuni li mú ɲyɛ, kapimpyiŋɛ niŋkin ká u toroŋkanni kɛ̂ɛnŋɛ, funntange ku maha mpyi nìɲyiŋi na uru kanni kurugo ke, kur'à pêe sèl'e. Kuru funntange fiige ɲyɛ na mpyi nìɲyiŋi na, shiin beecyɛɛre ná kɛ ná baacyɛɛre (99) kurugo mɛ, pire mpiimu pi ɲyɛ na sɔ̂nŋi na pir'à tíi na pire saha ɲyɛ a yaa pi pi toroŋkanni kɛ̂ɛnŋɛ mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ka Yesu si núr'a bàtaage kabɛrɛ jwo na: «Ceeŋi ŋgire u ɲyɛ, kampyi wyɛ́rɛfyinŋi daashii kɛ u ɲyɛ u á, ka niŋkin si ɲcwo mà pînni bage e, na u sì lùuni táan si làmpa mîni si bage kùruɲcwɔngii puni yaa mpwɔ́, si u cya fo si u ɲya mà yɛ? ");
INSERT INTO spp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","U aha u ɲya tèni ndemu i ke, u sí u pucyaabii ná u ciɲɛɛbii yyere si yi jwo pi á “Yii a ma, wuu u mpa múguro siɲcyan. Mii wyɛ́rɛŋi u mpyi a pînni ke, mii à u ɲya.” ");
INSERT INTO spp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Lire pyiŋkanni na, mii sí yi jwo yii á, kapimpyiŋɛ niŋkin ká u toroŋkanni kɛ̂ɛnŋɛ, kuru maha mpyi funntanga nimbwɔhɔ Kile mɛ̀lɛkɛɛbil'á nìɲyiŋi na.» ");
INSERT INTO spp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ɲyɛ ka Yesu sí núr'a bàtaage kabɛrɛ jwo pi á na: «Nàŋi wà u ná mpyi ná jyaa shuunni i. ");
INSERT INTO spp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Canŋka ka jyafooŋi nimbileni si jwo tufooŋ'á “Baba, mii nàzhanŋ'à yaa u pyi ŋgemu yii kɔɔge ke, yii ku táa yii i uru kan na á!” Ɲyɛ ka tufooŋi si ɲɛɛ, maa u nàfuuŋi táa u jyaabii shuunniŋi shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Canmpyal'à tòro ke, ka jyafooŋi nimbileni si u cyeyaayi puni pɛ́rɛ, maa fwor'a kàr'a sà ntɛ̀ɛn kìritɔɔnni l'e ná u wyɛ́rɛŋi i. Mà u yaha wani, ka u u cye le ɲùŋɔ baa karigil'e na mpyi, fo mà pa ŋkwɔ̀ u nàfuuŋi na. ");
INSERT INTO spp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tèni i u à u nàfuuŋi kɛ̀ɛg'a kwɔ̀ feefee ke, ka lire mú si bɛ̂ ná katibwɔh'e k'à cwo lire kìni na. Ka ŋgahaŋi si li ɲwɔ cû na u taa. ");
INSERT INTO spp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Y'à pa u yyaha jà ke, ka u u ŋkàr'a sà jyè báaraŋi i lire kìni shinŋi wà á, ka uru si ŋkàr'a sà u yaha sige e, u u caabii nâhe. ");
INSERT INTO spp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Katege kurugo, u la mpyi maha mpyi s'a caabii yalyire lyî. Ŋka wà mpyi maha tà kaan u á mɛ. ");
INSERT INTO spp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ɲyɛ mà u yaha pur'e, ka u u mpa sɔ̂nŋɔ uye funŋ'i canŋka maa jwo “Báarapyii niɲyahamii na ɲyɛ mii tuŋ'á wuu kìni i, pi puni na lyî na ntìnni fo na cyeyi wwû ɲjyìŋi i. Ŋka mii wi ke, katege ku ŋke ku u ŋko raa mii bùu naha. ");
INSERT INTO spp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nde mii sí n‑pyi numɛ ke, lire li ɲyɛ nde: mii sí núru raa wá na tuŋi yyére, sí sà yi jwo u á na mii à kapii pyi Kile na, maa kapii pyi u na. ");
INSERT INTO spp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","U saha ɲyɛ a yaa u mii cû u pyà fiige mɛ, ŋka u à yaa u mii cû mu à jwo u báarapyi.” ");
INSERT INTO spp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ɲyɛ u à funŋke kyaala a kwɔ̀ ke, maa kuni lwɔ́ na ŋkɛ̀ɛge u tuŋi yyére. Mà u yaha u sàha ŋkwɔ̀ a nɔ pyɛnge na mɛ, ka tufooŋi si u nimpaŋi ɲya tatɔɔnge e, ka u ɲùɲaare si u ta, ka u u fê a jyafooŋi ɲùŋɔ bɛ̂, maa sà u pûr'a cû mà ta uye na. ");
INSERT INTO spp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ka jyafooŋi si jwo u á “Baba, mii à kapii pyi Kile na, maa kapii pyi mu na dɛ! Mu saha ɲyɛ a sàa yaa mu u mii cû ma pyà fiige mɛ.” ");
INSERT INTO spp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ka tufooŋi si u báarapyiibii yyere maa jwo “Yii fyâl'a sà vàanntinmbwoyi puni nisinaŋke lwɔ́ yii pa le u na, yii i kampefegeŋi wà le u na, yii i tanhaɲyi yà le u na, ");
INSERT INTO spp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","yii i sà kàcwɔge nùŋi niɲcɛnŋi cû, yii pa bò, wuu u lyî wuu u múguro sèl'e. ");
INSERT INTO spp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ɲaha kurugo yɛ mii jyaŋi u ŋge ke, mii mpyi a li yaha na u à kwû, ŋka u ɲyii wuŋ'à pa, u mpyi a pînni, ŋka mii à u ɲya sahaŋki.” Ka múguroŋi si ɲwɔ cû pi á. ");
INSERT INTO spp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Lir'à pyi mà uru nàŋi jyaŋi niɲjyeŋi ta sige e. Ɲyɛ tèni i u à yîri sige e na ma mà pa byanhara pyɛnge na, na yatire tùnmpe núru, maa kwɔ̀hɔkwɔhɔbii ɲaa ke, ");
INSERT INTO spp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ka u u báarapyiŋi wà yyere mà yíbe, nde li ɲyɛ pyɛnge e ke, si lire cè. ");
INSERT INTO spp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ka báarapyiŋi si u pyi “Mu kàntugo wuŋi u à pa, lire e yii tuŋ'à wuu pyi wuu à sà kàcwɔge nùŋi niɲcɛnŋi cû mà pa bò, ɲaha na yɛ uru jyaŋi niɲcɛnŋɛ wu à núr'a pa.” ");
INSERT INTO spp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yyaha wuŋ'à puru lógo ke, ka u lùuni si yîri, u ɲyɛ a ɲɛn'a jyè pyɛnge e mɛ. Ka tufooŋi si fwor'a pa si mpa u fɔ̀ɔnŋɔ si ndèŋɛ pyɛnge e. ");
INSERT INTO spp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ka jyafooŋi si jwumpe lwɔ́ maa jwo tufooŋ'á “Cyi yyee jùuli cyi ɲyɛ ɲcyii mii na báaraŋi pyi yii á biliwe fiige yɛ? Canŋa niŋkin, yii sàha mii tun, ka mii i ɲcyé mɛ. Ŋka ali sikabilini nintiini yii ɲyɛ a li kan mà ɲya mii ná na ceveebil'á wuu u múguro siɲcyan mɛ. ");
INSERT INTO spp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ŋka mu jyaŋi u à mu nàfuuŋi lwɔ́ a sà ŋkɛ̀ɛge cibahani i ke, ur'à pa ke, ka mu u kàcwɔge nùŋi niɲcɛnŋi cû mà bò u na.” ");
INSERT INTO spp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ka tufooŋi si jwumpe lwɔ́ maa jwo jyafooŋi niɲjyeŋ'á “Mii jyaŋi, ma hà lire waha maye na mɛ, mii ná mu u ɲyɛ naha tèrigii puni i ke, ko mii cyeyaayi puni ɲyɛ mu wuyo kɛ! ");
INSERT INTO spp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wuu mpyi a li yaha na mu kàntugo wuŋ'à kwû, ŋka u ɲyii wuŋ'à núr'a pa. U mpyi a pînni ŋka wuu à núr'a u ɲya. Lire e ke wuu à yaa wuu pyi funntange ná múguroŋi i.”» ");
INSERT INTO spp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ɲyɛ Yesu à núr'a bàtaage kà jwo u cyelempyiibil'á na: «Nàfuufooŋi wà u ná mpyi a báarapyi lwɔ́ a yaha u u u karigii cwɔɔnre. Kàntugo, ka nàfuufooŋi si mpa a núru sùpyire ɲwɔ na, na u báarapyiŋi wá na u cyeyaayi kɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ka u u báarapyiŋi pyi “Mii à lógo na mu na mii cyeyaayi kɛ̀ɛge, ɲaha k'à pa ná lire e bɛ? Ɲyɛ bégele ma a ma báaraŋi pyiŋkanni yyaha jwo na á, ɲaha na yɛ mu báaraŋi sí n‑kwɔ̀ niɲjaa.” ");
INSERT INTO spp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ka báarapyiŋi si jwo uye funŋ'i “Mii ɲùŋufooŋ'à jwo na mii báaraŋi sí n‑yyére niɲjaa. Ɲyɛ ɲaha mii sí raa n‑pyi bɛ? Faapyi fànha ɲyɛ mii i mɛ. Na ɲáare na lyî, kuru silege mú sí ɲyɛ mii na. ");
INSERT INTO spp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɲyɛ nde mii sí n‑pyi ke, mii naha a li cè numɛ. Mii aha lire pyi, mii ɲùŋufooŋi ká mii yaha tèni ndemu i ke, sùpyire sannte sí mii mâra pi pyɛnyi i.” ");
INSERT INTO spp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","U ɲùŋufooŋi fwɔhigii mpyi mpiimu na ke, ka u u pire yyer'a yíbe niŋkin niŋkin maa shincyiiŋi pyi “Mii ɲùŋufooŋi jùuli u ɲyɛ mu na yɛ?” ");
INSERT INTO spp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ka u u jwo “U sìnɲcɛrii ŋkuu (100) fwoo li ɲyɛ mii na.” Ka báarapyiŋi si u pyi “Tɛ̀ɛn fwɔfwɔ, maa ma fwɔhigii sémɛŋi lwɔ́, maa yi kɛ̂ɛnŋ'a sémɛ na u sìnɲcɛrii beeshuunni ná kɛ fwoo li ɲyɛ mu na.” ");
INSERT INTO spp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Maa núr'a wabɛrɛ yíbe “Mu de? Mu fwooni ɲyɛ jùuli yɛ?” Ka uru si jwo “Sùmapyaŋi bɔrii ŋkuu (100).” Ka báarapyiŋi si u pyi “Tɛ̀ɛn, maa ma fwɔhigii sémɛŋi lwɔ́, maa yi kɛ̂ɛnŋ'a sémɛ na u sùmapyaŋi bɔrii beecyɛɛre (80) fwoo li ɲyɛ mu na.” ");
INSERT INTO spp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Uru báarapyiŋi mɛ́ɛ ɲyɛ u à u ɲùŋufooŋi nàfuuŋi kɛ̀ɛge ke, ɲùŋufooŋ'à u kêe, ɲaha na yɛ u à yákili ta maa u nùmpanŋke yaa. Ɲyɛ mpii pi ɲyɛ numpini i ke, pire maha pi ná piye shwɔ̀hɔŋi karigii cwɔɔnre ná yákilifente e pyiŋkanni ndemu na ke, mii à ŋke bàtaage jwo pire kyaa na si ntɛ̀gɛ yii yɛrɛ, yii mpiimu pi ɲyɛ bɛ̀ɛnmpe e ke, bà yii si mpyi si yii nùmpanŋke bégele mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ɲyɛ ka Yesu si núr'a jwo: «Yii àha nàfuuŋi yaha yii karigii puni yyaha yyére mɛ, lire ɲyɛ a tíi mɛ. Yii a cevee caa yiye na ná u e, lire ká mpyi, yii canmpyaagii ká ŋkwɔ̀ ŋge diɲyɛŋi i tèni ndemu i ke, Kile sí yii lèŋɛ u pyɛnge e, yii sí n‑pyi wani fo tèekwombaa. ");
INSERT INTO spp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Shinŋi u maha kapyɛɛre pyi ná fyìnm'i ke, urufoo mú maha kabwɔhigii pyi ná fyìnmpe e. Ŋka shinŋi u ɲyɛ u ɲyɛ na kapyɛɛre pyi ná fyìnm'i mɛ, kabwɔhii mɛ́ɛ ká le urufoo cye e, u ɲyɛ na cyi pyi ná fyìnmpe e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yii aha mpyi yii ɲyɛ a jà a ŋge diɲyɛŋi nàfuuŋi báara ná fyìnmpe e mɛ, nàkaana baa Kile mú sì ɲɛɛ sèe nàfuu le yii cye e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yaage ku ɲyɛ sùpyaŋi wabɛrɛ wogo ke, yii aha mpyi yii ɲyɛ a kuru báara ná fyìnmpe e mɛ, ŋke Kile à bégel'a yaha yii yabilimpii mɛɛ na ke, nàkaana baa, u mú sì ɲɛɛ kuru kan yii á mɛ. ");
INSERT INTO spp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yii li cè na báarapyiŋi sì n‑sìi n‑jà raa báare ɲùŋufee shuunn'á mɛ. Lire ká mpyi, u sí ɲùŋufooŋi wà kyaa táan uy'á, si u sanŋi kyaa pɛn uy'á. U mú sí n‑kúu wà na, si kàntugo wà u sanŋi na. Ɲyɛ amuni li ɲyɛ, nàfuuŋi lag'à tatɛɛngɛ fô yii mpiimu na ke, yii sì n‑jà n‑pyi Kile báarapyii mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ɲyɛ Farizhɛɛnbil'à puru jwumpe puni lógo ke, ka pi i wá na Yesu fwɔ́hɔre, ɲaha na yɛ nàfuuŋi kani mpyi a pêe pi á. ");
INSERT INTO spp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ka Yesu si pi pyi: «Yii pi ke, yii maha yiye pyi mu à jwo yii à tíi sùpyire ɲyii na, mà li ta Kile à yii zòompii cè. Yii li cè, yaage k'à pêe sùpyire ɲyii na ke, kur'à pɛn Kile á. ");
INSERT INTO spp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ɲyɛ MusaSaliyaŋi ná Kile tùnntunmpii sanmpii jwump'à kwôro tooy'e fo mà pa nɔ Yuhana Batizelipyiŋi tèni na. Mà lwɔ́ Yuhana Batizelipyiŋi na, Jwumpe Nintanmpe p'à yyaha tíi ná Kile Saanre e ke, puru na yu sùpyir'á. Sùpyire puni la mú si ɲyɛ si fànha le si jyè tire saanre e. ");
INSERT INTO spp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yii li cè na ɲìŋk'à mpìnni tàaŋa a tòro Kile Saliyaŋi jwumbilini là niŋkin mpìnni na. ");
INSERT INTO spp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Shin maha shin ká u cwoŋi yaha maa ceeŋi wabɛrɛ lèŋɛ ke, urufol'à jacwɔrɔ pyi. Shin maha shin u à ciyahawa lèŋɛ ke, urufoo mú à jacwɔrɔ pyi.» ");
INSERT INTO spp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ka Yesu si núr'a bàtaage kà jwo sùpyir'á na: «Nàfuufooŋi wà na mpyi wani, u mpyi maha vàanɲyi nisinaɲyi loŋgara wuyi leni, maa u ɲyii karigii pyi, maa u ɲyii ɲjyìŋi lyî canŋa maha canŋa. ");
INSERT INTO spp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kanhamafooŋi wà nizinniwe mpyi maha mpyi uru nàfuufooŋi pyɛnge ɲwɔge na. Uru nàŋi cyeere puni mpyi nɔɔyɔ, u mɛge mpyi Lazari. ");
INSERT INTO spp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","U la mpyi maha mpyi s'a uru nàfuufooŋi ɲjyìpaanyi caa raa lyî, ŋka u mpyi maha yi taa mɛ. Mà bâra lire na, pwuunbii mpyi maha mpa a u nɔɔyi laali. ");
INSERT INTO spp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ka kanhamafooŋi si mpa ŋkwû, ka Kile mɛ̀lɛkɛɛbii si mpa u lwɔ́ a kàr'a sà yaha Ibirayima taan Arijinaŋi i. Lire kàntugo ka nàfuufooŋi mú si mpa ŋkwû, ka pi i sà u tò. ");
INSERT INTO spp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mà nàfuufooŋi yaha kyaage e ɲìŋke ɲwɔhɔ shiinbii cyage e, u à wíl'a Lazari ɲya Ibirayima taan tatɔɔnge e Arijinaŋi i. ");
INSERT INTO spp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɲyɛ ka nàfuufooŋi si Ibirayima yyere fànha na “Mii tuŋi Ibirayima, ɲùɲaara ta na na, maa Lazari pyi u sà u kampeeni fyinmɛ lwɔhe e, u pa ntɛ̀g'a na ŋkɔ̀ɔnge ɲíŋɛ. Ɲaha kurugo yɛ kyaage e mii naha naha ŋke nage e ke, kur'à pêe sèl'e!” ");
INSERT INTO spp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ka Ibirayima si u pyi “Na pyà, mu à yaa mu u li cè na mu à ma tìiŋi puni pyi ntàanŋi kanni na. Ŋka Lazari sí wi ke, ur'à u tìiŋi puni pyi kanhare e. Numɛ, Lazari ɲyɛ naha yyeɲiŋke e, mu sí ɲyɛ yyefuge e. ");
INSERT INTO spp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mà bâra lire na, kacyewyicuguŋɔ na ɲyɛ wuu ná yii shwɔhɔl'e. Lire kurugo wà sì n‑jà n‑yîri naha wuu yyére, si ŋkàre yii yyére mɛ. Wà mú sì n‑jà n‑yîri wani yii yyére, si mpa naha wuu yyére mɛ.” ");
INSERT INTO spp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ɲyɛ ka nàfuufooŋi si jwo “Mii tuŋi Ibirayima, l'aha mpyi amuni, mii na mu ɲáare, ma a Lazari tun diɲyɛŋi i, mii tuŋi pyɛnge e. ");
INSERT INTO spp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sìɲɛɛ kaŋkuro na ɲyɛ wani mii kàntugo. Lazari yaha u sà pi yɛrɛ, bà pi si mpyi pi àha ŋkwɔ̀ mpa ŋke yyefuge e naha mɛ.” ");
INSERT INTO spp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ka Ibirayima si nàfuufooŋi pyi “Kile tùnntunŋi Musa ná Kile tùnntunmpii sanmpii jwumpe na ɲyɛ pi á, pi à yaa pi ɲɛɛ pire jwumpe na.” ");
INSERT INTO spp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ka nàfuufooŋi si jwo “Mii tuŋi Ibirayima, lire kanni sì n‑jà pi pyi pi lógo mɛ, ŋka wà ha ɲɛ̀ a fworo kwùŋi i maa ŋkàr'a sà jwo ná pi e, lire e pi sí pi toroŋkanni kɛ̂ɛnŋɛ.” ");
INSERT INTO spp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ka Ibirayima sí núr'a u pyi “Pi aha mpyi pi ɲyɛ a ɲɛɛ Kile tùnntunŋi Musa ná Kile tùnntunmpii sanmpii jwumpe na mɛ, ali wà mɛ́ɛ ká ɲɛ̀, maa ŋkàr'a sà jwo ná pi e, pi sì ɲɛɛ urufoo jwumpe na mɛ.”» ");
INSERT INTO spp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Canŋka Yesu à jwo u cyelempyiibil'á: «Karigii cyi maha sùpyaŋi ɲùŋɔ kyán Kile na ke, cyire mpyimbaa ɲyɛ a sìi mɛ. Ŋka ŋgemu ká mpyi kaɲuŋɔ maa sùpya ɲùŋɔ kyán Kile na ke, urufoo wuun'à kɛ̀ɛge! ");
INSERT INTO spp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Li bá sí n‑pwɔ́rɔ urufol'á pi kafaabwɔhɔ pwɔ u yacige e, pi i u wà baŋi i, mà tòro u nde nàŋkobilini là niŋkin ɲùŋɔ kyán. ");
INSERT INTO spp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Lire e ke yii a yiye kàanmucaa. Mu cìnmpworoŋi ká mu mùmpɛnmɛ pyi, u yyere maa u yɛrɛ. U aha mu yɛrɛge lógo, maa toroŋkanni kɛ̂ɛnŋɛ, mu à yaa mu u yàfa u na lire kani i. ");
INSERT INTO spp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Canŋke niŋkinŋi i, mu cìnmpworoŋi ká mu mùmpɛnmɛ pyi mà sà nta fo tooyo baashuunni, tɔɔgɔ maha tɔɔgɔ u a sì mpa uye mpìnni kan mu á, mu à yaa mu u yàfa u na cyire karigii puni i.» ");
INSERT INTO spp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ka Yesu tùnntunmpii si u pyi: «Kafooŋi, ɲyɛ lire sanni i ke, là bâra wuu dániyaŋi na.» ");
INSERT INTO spp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ka Kafooŋi si pi pyi: «Sèeŋi na mii sí yi jwo yii á, yii dániyaŋi mɛ́ɛ n'a mpyi a cyɛ́rɛ mutaridi bile fiige, yii mpyi na sí n‑jà ŋke cibwɔhe pyi ku kò kuy'á, ku u sà ɲcûru baŋi i, ku mú mpyi na sí lire pyi.» ");
INSERT INTO spp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ka Yesu si núr'a jwo: «L'aha mpyi mu à jwo báarapyi na ɲyɛ yii wà á, ka u u yîri faa sige e, lire ɲyɛ mɛ yatɔɔre tanahage e mà pa, tá urufoo sí ɲɛɛ báarapyiŋi pyi u tíl'a tɛ̀ɛn u u lyî la? ");
INSERT INTO spp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tá urufoo sì báarapyiŋi pyi u vàanɲwɔhɔyi wwû, u u shwɔhɔ a kan uru u lyî si bya, lire kàntugo báarapyiŋi si nta a lyî si bya mɛ? ");
INSERT INTO spp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Báarapyiŋi mɛ́ɛ ká u tayyerege ɲî, u ɲyɛ a yaa ná ŋkèeŋi wabɛr'e mɛ! ");
INSERT INTO spp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Amuni li mú ɲyɛ, báaraŋi Kile à kan yii á ke, yii aha uru pyi a kwɔ̀, yii li cè na yii ɲyɛ a yaa ná ŋkèeŋi wabɛr'e mɛ. Ɲaha kurugo yɛ nde yii mpyi a yaa yii pyi ke, lire yii à pyi.» ");
INSERT INTO spp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ɲyɛ mà Yesu niŋkareŋi yaha Zheruzalɛmu kànhe e, u mpyi na ŋkɛ̀ɛge Samari kùluni ná Galile wuuni tɛgɛŋkuuŋi i. ");
INSERT INTO spp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","U à sà byanhara kànhe kà na, ka tògofee kɛ si wá na u ɲùŋɔ bêni, maa ntɛ̀ɛn laage e, ");
INSERT INTO spp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","maa jwo ná u e fànha na: «Yesu! Cyelentuŋi! Ɲùɲaara ta wuu na!» ");
INSERT INTO spp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu à pi ɲya ke, maa pi pyi: «Yii a sì, yii sà yiye cyêe Kile sáragawwuubii na.» Mà pi niŋkaribii yaha, ka pi i ɲcùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ɲyɛ pi wà niŋkin a uye ɲya u à cùuŋɔ ke, maa núru na Kile kêre fànha na, na ma. ");
INSERT INTO spp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","U à pa nɔ Yesu na ke, maa niŋkure sín u taan maa yyahe cyígile ɲìŋke na maa fwù kan u á sèl'e. Uru nàŋi na mpyi Samari shin. ");
INSERT INTO spp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ka Yesu si jwumpe lwɔ́ maa jwo: «Tá shiin kɛ bà mii à cùuŋɔ mɛ? Taa pi sanmpii baacyɛɛreŋi ɲyɛ ke? ");
INSERT INTO spp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ŋge nàŋi u ɲyɛ u ɲyɛ Yahutu mɛ, uru kanni baare e, sùpya ɲyɛ a ta mpii shiin kɛŋi i, si núru n‑pa fwù kan Kile á mà?» ");
INSERT INTO spp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Maa yi jwo nàŋ'á: «Yîri ma a sì, mu dániyaŋ'à mu cùuŋɔ.» ");
INSERT INTO spp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɲyɛ lire kàntugo, ka Farizhɛɛnbii si Yesu yíbe Kile Saanre tèesiini kyaa na, ka u u pi pyi: «Kile Saanre sí n-pyi, ŋka ti sì n‑pyi yawiige, ");
INSERT INTO spp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","sùpyire sí raa ŋkemu cyêre piye na s'a ŋko “Yii wíi, ti te naha!” lire ɲyɛ mɛ “Ti te mɛŋi i!” mɛ. Yii li cè na Kile Saanre ɲyɛ yii shwɔhɔl'e.» ");
INSERT INTO spp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Maa jwo u cyelempyiibil'á: «Tèni là na ma, canŋke Supyaŋi Jyaŋi à yaa u pa ke, yii la sí n-sìi n-pyi kuru canŋke ku wyɛ̀r'a nɔ, ŋka ku sì nɔ lire tèni i mɛ. ");
INSERT INTO spp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sùpyire sí n‑pa raa ŋko “U naha naha!” lire ɲyɛ mɛ “U wá mɛ yyére!” Ŋka yii àha ntaha pi ɲwɔh'i, si ŋkàre wani mɛ. ");
INSERT INTO spp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bà sùpyire puni maha kileɲini ɲya l'à yîri diɲyɛŋi ɲùŋke kà na, maha sà fworo ɲùŋke sanŋke na mɛ, amuni Supyaŋi Jyaŋi sí ɲya u cannuruge. ");
INSERT INTO spp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ŋka mà jwo kuru canŋke ku nɔ ke, u à yaa u kyaala sèl'e, sùpyire niɲyahara sí u cyé. ");
INSERT INTO spp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ɲyɛ Supyaŋi Jyaŋi tèenuruni ká byanhara, karigii cyi mpyi na mpyi Nuhu tìiŋi i ke, cyire shiŋi sí raa n‑pyi. ");
INSERT INTO spp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nuhu tìiŋi i, sùpyire mpyi na lyî, marii byii, maa cyeebii lèŋi, marii pi pyìibii kaan nàmbaya na, fo mà sà nɔ canŋke Nuhu a jyè bakwɔɔge e, ka lùbwooni si sùpyire sannte puni shi bò ke. ");
INSERT INTO spp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ɲyɛ amuni Loti tèni i sùpyire mú mpyi. Pi mpyi na lyî, maa byii, marii zhwoŋi ná pɛrɛmpe pyi, maa cire cɛnmi, maa bayi faanre. ");
INSERT INTO spp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ŋka canŋke Loti à fworo Sɔdɔmu kànhe e ke, ka nage ná ŋkìrigiŋi si fworo nìɲyiŋi na zànpya fiige, mà wu kànhe sùpyire na, maa pi shi bò, ");
INSERT INTO spp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ɲyɛ canŋke Supyaŋi Jyaŋi sí núru uye cyêe sùpyire na ke, amuni kuru canŋke sí n‑pâa pi e. ");
INSERT INTO spp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kuru canŋke ká nɔ, mà ŋgemu ta u bage kàtanŋke ɲuŋ'i ke, urufoo kà núru ntîge si yaaga lwɔ́ bage e mɛ, u tíl'a tîge u a fî. L'aha mpyi mà ŋgemu ta kɛrɛge e ke, urufoo kà núru raa ma pyɛngɛ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nde l'à Loti cwoŋi ta ke, yii sɔ̂nŋɔ lire na kɛ! ");
INSERT INTO spp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Shinŋi u ɲyɛ na li caa u niɲjaaŋi si ɲwɔ ke, urufoo nùmpanŋke sí n‑kɛ̀ɛge. Ŋka shinŋi u à u niɲjaaŋi kɛ̀ɛge mii kurugo ke, urufoo sí nùmpanŋa ta. ");
INSERT INTO spp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mii sí yi jwo yii á, lire tèni ká bɛ̂ ná numpilage e, mà shiin shuunni ta pi à sínni yasinniŋɛ niŋkin na, wà sí n‑lwɔ́ si u sanŋi yaha. ");
INSERT INTO spp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","L'aha cyee shuunni ta pi i sùma súu siɲcyan, wà sí n‑lwɔ́ si u sanŋi yaha.  ");
INSERT INTO spp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","L'aha mpyi mà nàmbaa shuunni ta kɛrɛge e, wà niŋkin sí n‑lwɔ́ si u sanŋi yaha.» ");
INSERT INTO spp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ɲyɛ ka cyelempyiibii si Yesu yíbe: «Kafooŋi, taa lire sí n‑pyi ke?» Ka u u pi pyi: «Cyage e yakwugo ɲyɛ ke, wani cinmpunɲyi ɲyɛ na bínnini.» ");
INSERT INTO spp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ka Yesu si bàtaaga jwo u cyelempyiibil'á maa li cyêe pi na na pi à yaa pi kwôro Kileɲarege na tèrigii puni i, pi àha sàa le mɛ. ");
INSERT INTO spp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","U à jwo pi á: «Yukyaaŋi wà u mpyi kànhe kà na, u mpyi na fyáge Kile na mɛ, u kuro mú sí mpyi sùpya e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Leŋkwucwoŋi wà mú na mpyi kuru kànhe e, sùpyaŋi wà mpyi a u mùmpɛnmɛ pyi. Uru leŋkwucwoŋi mpyi maha sì uru yukyaaŋi yyére tèrigii puni i, bà u si mpyi si u ná uru nàŋi láha piye na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ceeŋ'à mɔ uru zhà maa nùruŋi i, ɲaha na yɛ yukyaaŋi la mpyi sì lire pyi mɛ. Ka ceeŋi si li wyɛ̀ɛŋɛ u ɲwɔh'i, fo u à pa jwo uye funŋ'i “Mii mɛ́ɛ ɲyɛ mii ɲyɛ na fyáge Kile na mɛ, maa mpyi mii kuro ɲyɛ sùpya e mɛ, ");
INSERT INTO spp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ná ŋge leŋkwucwoŋi s'à mii yyaha fwɔ́hɔrɔ mà nɔ ŋke cyage e, mii sí u ná uru nàŋi láha piye na. Ná lire ɲyɛ a pyi mɛ, mii sì yyeɲiŋɛ ta u ɲyii na mɛ.”» ");
INSERT INTO spp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Puru jwuŋkwooni kàntugo, ka Kafooŋi Yesu si u cyelempyiibii yíbe: «Yii à uru yukyaaŋi nintiimbaaŋi jwumpe lógo kɛ! ");
INSERT INTO spp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ɲyɛ ná u s'à uru ceeŋi tànga kan, Kile niɲcwɔnribii pi ɲyɛ Kile ɲwɔh'i marii u ɲáare pìlaga bâra canŋa na ke, Kile sí n‑sìi pire tànga kan. Yii li cè u à lùuni bò ná pi e. ");
INSERT INTO spp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mii sí yi jwo yii á, Kile sí tànga kan pir'á wahawaha. Ŋka lire ná li wuuni mú i, Supyaŋi Jyaŋi cannuruge ká nɔ ɲìŋke na, tá u ɲyɛ a yaa u pa dánafee ta ku na mɛ?» ");
INSERT INTO spp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Lire kàntugo ka Yesu si núr'a bàtaage kabɛrɛ jwo mà yyaha tíi ná sùpyiibii pìl'e, mpiimu pi ɲyɛ na piye sɔ̂nŋi na pir'à tíi maa piye pwɔ́ɔŋɔ sùpyire sannte na ke. U à jwo: ");
INSERT INTO spp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Shiin shuunni pi ná ŋkàre Kileɲaarebage e zà Kile ɲáare. Wà na mpyi Farizhɛn, u sanŋi sí ɲyɛ múnalwɔɔre shwofoo. ");
INSERT INTO spp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mà pi yaha Kileɲaarebage e, ka Farizhɛnŋi sí yîr'a yyére u mɛge cyage e, maa Kile ɲáare na “Kile, mii à fwù kan mu á, ɲaha na yɛ mii à pwɔ́rɔ sùpyire sannte na, mpiimu pi ɲyɛ na nàŋkaage pyi, marii jacwɔɔre pyi, mà bâra kapegigii sanŋkii shiŋi puni na ke. Mii à pwɔ́rɔ ŋge múnalwɔɔre shwofooŋi na mú. ");
INSERT INTO spp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cibilaaga maha cibilaaga, mii maha canmpyaa shuunni sún le. Yaaga maha yaaga mii à ta ke, mii maha yire puni yáhaŋi wwû.” ");
INSERT INTO spp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Múnalwɔɔre shwofooŋi wi ke, ka uru si yîr'a yyére tatɔɔnge e Kileɲaarebage funŋke e, maa ɲùŋke sôgo, maa mɛjwuuni tîrige maa jwo “Kile, mii na mu ɲáare, maa lùɲiŋɛ wà ma lùuni na, ɲaha na yɛ mii ɲyɛ kapimpyiŋɛ.” ");
INSERT INTO spp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ɲyɛ mii sí yi jwo yii á, Kile à múnalwɔɔre shwofooŋi kapegigii yàfa u na, ka u u núr'a kàre pyɛngɛ. Ŋka Farizhɛnŋi wi ke, uru u kapegigii ɲyɛ a yàfa u na mɛ. Yii li cè na shin maha shin u à uye pêe ke, Kile sí urufoo tîrige. Ŋgemu u à uye tîrige ke, Kile sí urufoo dùrugo.» ");
INSERT INTO spp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lire kàntugo ka pi i mpa ná pyìibii pìl'e Yesu yyére, bà u si mpyi si cyeyi taha pi na, si jwó le pi á mɛ. Cyelempyiibil'à lire ɲya ke, mpii pi à pa ná pyìibil'e ke, ka pi i pire faha. ");
INSERT INTO spp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ka Yesu si pyìibii file uye na, maa jwo: «Yii àha pi sige na na mɛ. Yii li cè na sùpyiibii pi ɲyɛ mpii pyìibii fiige ke, Kile Saanre ɲyɛ pire woro. ");
INSERT INTO spp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sèeŋi na mii sí yi jwo yii á, ŋgemu ká mpyi u ɲyɛ a ɲɛn'a uye tîrige pyà fiige mɛ, urufoo sì n‑sìi n‑jà n‑jyè Kile Saanre e mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ɲyɛ canŋka, Yahutuubii yyaha yyére shinŋi wà à Yesu yíbe: «Cyelentuŋi niɲcɛnŋi, ɲaha shi mii à yaa mii u pyi si shìŋi niŋkwombaaŋi ta bɛ?» ");
INSERT INTO spp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ka Yesu si u pyi: «Ɲaha na mu ɲyɛ na mii yiri niɲcɛnŋi yɛ? Kile kanni baare e, sùpya ɲyɛ a ɲwɔ mɛ. Mu à sɔ̂nŋɔ lire na la? ");
INSERT INTO spp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mu à Kile Saliyaŋi kurigii cè mà kwɔ̀ “Ma hà zínni ná wabɛrɛ cwo e mɛ, ma hà sùpya bò mɛ, ma hà nàŋkaaga pyi mɛ, ma hà vini ntaha wà na mɛ, ma tuŋi ná ma nuŋi pêe.”» ");
INSERT INTO spp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ka nàŋi si Yesu pyi: «Cyelentuŋi, mii na cyire karigii puni pyi fo mà mii yaha nàŋkocyɛɛre e.» ");
INSERT INTO spp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ɲyɛ uru nàŋ'à puru jwo ke, ka Yesu si u pyi: «Yaaga niŋkin saha à mu fô, ta sì ma a sà ma cyeyaayi puni pɛ́rɛ, ma a yi wyɛ́rɛŋi táa táa fòŋɔfeebii na. Lire ká mpyi, mu sí nàfuu ta Kile yyére. Ma a nta a pa ntaha na fye e.» ");
INSERT INTO spp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tèni i uru nàŋ'à puru jwumpe lógo ke, ka li i mpɛn u e, ɲaha na yɛ nàfuubwɔhɔ foo u mpyi u wi. ");
INSERT INTO spp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu à u ɲya u à yyahe tanha ke, maa jwo u á: «Nàfuufeebii jyìm'à sàa pɛn Kile Saanre e. ");
INSERT INTO spp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɲwɔhɔŋi jyìm'à táan músɛnnɛŋi wyiini i mà tòro nàfuufooŋi u jyè Kile Saanre e.» ");
INSERT INTO spp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɲyɛ mpii pi à puru jwumpe lógo ke, ka pire si jwo: «Lire sanni i ke, jofoo u sí n‑jà nùmpanŋa ta bɛ?» ");
INSERT INTO spp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ka Yesu si pi pyi: «Kani l'à sùpyire jà ke, lire ɲyɛ na Kile jìni mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ka Pyɛri si jwumpe lwɔ́ maa Yesu pyi: «Wuu de? Wuu à kàntugo wà wuu karigii puni na, maa ntaha mu fye e.» ");
INSERT INTO spp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ka Yesu si pi pyi: «Sèeŋi na mii sí yi jwo yii á, shin maha shin u à ɲɛn'a kàntugo wà u pyɛnge, lire ɲyɛ mɛ u cwoŋi, lire ɲyɛ mɛ u cìnmpyiibii, lire ɲyɛ mɛ u sifeebii, lire ɲyɛ mɛ u pyìibii na Kile Saanre kurugo ke, ");
INSERT INTO spp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","urufoo sí pire fiigii niɲyahamii ta mà u yaha naha diɲyɛŋi i, sí shìŋi niŋkwombaaŋi ta diɲyɛŋi nimpaŋi i.» ");
INSERT INTO spp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Lire kàntugo ka Yesu si u cyelempyiibii kɛ ná shuunniŋi yyére maa yi jwo pi á: «Wuu niŋkaribii pi mpii Zheruzalɛmu kànhe e. Kyaa maha kyaa Kile tùnntunmpil'à sémɛ Supyaŋi Jyaŋi kyaa na ke, cyire puni sí n‑tòro cyi jwuŋkanni na. ");
INSERT INTO spp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","U sí n‑le Kilecembaabii cye e, pire sí raa u fwɔ́hɔre, s'a u cyere, s'a ntilwɔhe wàa u na, ");
INSERT INTO spp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","si u bwɔ̀n ná kàsɔrigil'e, si u bò. Ŋka u kwùŋi canmpyitanrewuuni, u sí ɲɛ̀.» ");
INSERT INTO spp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cyelempyiibil'à puru jwumpe lógo, ŋka pi mpyi a jà a pu ɲwɔhe cè mɛ, ɲaha na yɛ pu ɲwɔhe mpyi a ŋwɔhɔ pi na. ");
INSERT INTO spp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ɲyɛ Yesu ná u cyelempyiibii niŋkaribii Zheruzalɛmu kànhe e, pi à sà byanhara Zheriko kànhe na ke, ka pi i fyinnaŋi wà ta u à tɛ̀ɛn kuni ɲwɔge na na sùpyire ɲáare. ");
INSERT INTO spp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sùpyire màhaŋ'à jyè u niŋgyigigil'e ke, ka u u yíbe: «Ɲaha na sùpyire ɲyɛ na ŋge màhaŋi pyi amɛ yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ka pi i yi jwo u á na Nazarɛti kànhe shinŋi Yesu u ɲyɛ na ntùuli. ");
INSERT INTO spp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Fyinnaŋ'à puru lógo ke, maa jwo fànha na: «Dawuda Tuluge Shinŋi Yesu, ɲùɲaara ta na na!» ");
INSERT INTO spp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mpii pi mpyi yyaha yyére ke, ka pire si u faha na u fyâha. Ŋka u ɲyɛ a ɲɛn'a fyâha mɛ, maa là bâra u jwuŋkanni na: «Dawuda Tuluge Shinŋi, ɲùɲaara ta na na!» ");
INSERT INTO spp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ka Yesu si yyére, maa pi pyi pi u cû a pa. Pi à pa ná u e ke, ka Yesu si u yíbe: ");
INSERT INTO spp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ɲaha mu la ɲyɛ mii u pyi mu á yɛ?» Ka fyinŋi si u pyi: «Kafooŋi, mii la ɲyɛ si núru s'a ɲaa.» ");
INSERT INTO spp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ka Yesu si u pyi: «Ta ɲaa, mu dániyaŋ'à mu cùuŋɔ.» ");
INSERT INTO spp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lire tèenuuni i, ka fyinŋi si ntíi na ɲaa, maa ntaha u fye e, maa Kile kêe. Sùpyir'à lire ɲya ke, maa Kile kêe mú. ");
INSERT INTO spp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ɲyɛ mà Yesu yaha u u ntùuli Zheriko kànhe e, ");
INSERT INTO spp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","nàŋi wà na mpyi wani kuru kànhe e, u mɛge mpyi Zaŋkɛ. Múnalwɔɔre shwofeebii ɲùŋufooŋi wà u mpyi u wi. Nàfuufoo u mpyi u wi. ");
INSERT INTO spp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","U la mpyi si Yesu ɲya, si ɲcè sùpyaŋi u ɲyɛ u wi ke. Ŋka u mbereŋi ná sùpyire ɲyahaŋi kurugo, u ɲyɛ a jà a Yesu ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ka u u fê a kàre yyaha yyére, maa sà dùgo sikomɔri cige e, kuni ɲwɔge na, bà li si mpyi Yesu ká mpa a ntùuli ku ɲwɔh'i, si u ta ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu à pa nɔ kuru cyage e ke, maa ɲùŋke yîrig'a wíi cige e, maa jwo: «Zaŋkɛ, fyâl'a tîge naha, ɲaha na yɛ mii à yaa mii u sunmbage lèŋɛ mu pyɛnge e niɲjaa.» ");
INSERT INTO spp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ka Zaŋkɛ si fyâl'a tîge maa Yesu ɲùŋɔ bɛ̂ ná funntange e maa ŋkàre ná u e pyɛnge e. ");
INSERT INTO spp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sùpyire puni ti mpyi wani maa lire ɲya ke, ka li i mpɛn pi e, fo pi na ŋkunni piye shwɔhɔl'e, marii ŋko: «Ŋge nàŋ'à kàr'a sà sunmbage lèŋɛ ŋge kapimpyiŋi pyɛnge e.» ");
INSERT INTO spp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ŋka mà pi yaha tire jwoore na, Zaŋkɛ niɲjyereŋ'à kwôro Kafooŋi Yesu taan, maa yi jwo u á: «Kafooŋi, mii sí na cyeyaayi puni taaga niŋkin kan fòŋɔfeebil'á. Yaaga maha yaaga mii à cyán a shwɔ sùpyire na ke, mii sí yire yaayi puni fiigii sicyɛɛre kan kan pi á.» ");
INSERT INTO spp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ka Yesu si jwo: «Zhwoŋ'à nɔ ŋke pyɛnge na niɲjaa, ɲaha na yɛ ŋge nàŋi mú na ɲyɛ Ibirayima tùluge shin. ");
INSERT INTO spp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mii sí yi jwo yii á, mpii pi à pînni ke, Supyaŋi Jyaŋi à pa mpa pire cya si pi shwɔ.» ");
INSERT INTO spp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mà sùpyire yaha ti i núru Yesu ɲwɔ na, pi à pa byanhara Zheruzalɛmu kànhe na ke, ka Yesu si li kàanmucya mà li ɲya na sùpyire sɔ̀nŋɔr'à taha li na na Kile Saanre sí n‑sìi lire tèni yabiliŋi i. Lire kurugo u à ŋke bàtaage jwo pi á ");
INSERT INTO spp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","na: «Fànhafooŋi wà jya u ná mpyi na ŋkɛ̀ɛge kìritɔɔnl'e, bà lire kìni saanbwɔhe si mpyi si u tìŋɛ mpyi saanwa, u u núr'a pa ntɛ̀ɛn u yabiliŋi kìni shiinbii ɲùŋɔ na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mà jwo u lire kùluni tɔɔge lwɔ́ ke, u à u báarapyii kɛ yyere, maa wyɛ́rɛfyinŋi tɔɔnyɔ kɛ kan pi puni niŋkin niŋkin á, maa pi pyi na pi à cwɔ̀hɔnte pyi ná u e, pi i tɔ̀ɔn ta u na, mà jwo uru u núr'a pa ke. ");
INSERT INTO spp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ŋka uru ŋge nàŋi kyaa mpyi a táan u kìni shiinbil'á mɛ. U kareŋkwooni kàntugo, ka pi i tùnntunmii tun saanbwɔh'á, maa yi jwo u á na pire la ɲyɛ u u ŋge nàŋi tìŋɛ pire ɲùŋɔ na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ŋka lire ná li wuuni mú i, saanbwɔh'à u pyi saanwa, ka u u núr'a pa u kìni i. U à pa ke, maa u báarapyiibii yyere, mpiimu á u niŋkareŋi mpyi a wyɛ́rɛŋi kan ke, si ɲcè kampyi pi à tɔ̀ɔn ta u na. ");
INSERT INTO spp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ka báarapyiŋi niɲcyiiŋi si mpa maa jwo “Kafooŋi, wyɛ́rɛŋi mu mpyi a kan mii á ke, mii à cwɔ̀hɔnte pyi ná u e, mà u fiigii kɛ tɔ̀ɔn ta.” ");
INSERT INTO spp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ka saanŋi si yi jwo uru báarapyiŋ'á “Fwù faa na. Mu na ɲyɛ báarapyi niɲcɛnŋɛ. Ná mu s'à pyi dánasupya kapyɛɛre e, mii sí mu tìŋɛ n‑pyi ɲùŋufoo kànyi kɛ ɲùŋɔ na.” ");
INSERT INTO spp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɲyɛ ka báarapyiŋi shɔnwuŋi si mpa maa jwo “Ɲùŋufooŋi, wyɛ́rɛŋi mu mpyi a kan mii á ke, mii à cwɔ̀hɔnte pyi ná u e mà u fiigii kaŋkuro ta.” ");
INSERT INTO spp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ka saanŋi si yi jwo ur'á mú “Mii sí mu tìŋɛ kànyi kaŋkuro ɲùŋɔ na.” ");
INSERT INTO spp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Ka báarapyiŋi wabɛrɛ si mpa maa jwo “Ɲùŋufooŋi, wyɛ́rɛŋi mu mpyi a kan mii á ke, u we, mu yyahafyagar'à mii ta, ka mii i u le a pwɔ vàanŋke k'e, mà bégele, ɲaha na yɛ mu à kyán, mu cyɛge ɲyɛ a yaage ŋkemu yaha mɛ, mu maha kuru lwɔ́, mu ɲyɛ a kɛrɛge ŋkemu nûgo mɛ, mu maha kuru sùmaŋi kwɔ̀n.” ");
INSERT INTO spp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ka saanŋi si yi jwo u á “Mu ɲyɛ báarapyi niɲcɛnŋɛ mɛ. Jwumpe mu à jwo mii na ke, mà tàanna ná pur'e, mu ná ndemu l'à yaa ke, mii sí lire pyi mu na. Mu à cè na mii na ɲyɛ supyikyanga, na mii ɲyɛ a yaage ŋkemu yaha mɛ, mii maha kuru lwɔ́, mii ɲyɛ a kɛrɛge ŋkemu nûgo mɛ, mii maha kuru sùmaŋi kwɔ̀n. ");
INSERT INTO spp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ɲyɛ mu à yire puni cè, ɲaha na mu sí ɲyɛ a mpyi a jà a mii wyɛ́rɛŋi yaha wyɛ́rɛŋi bwùunni na mà yɛ? Kampyi mu mpyi a lire pyi, mii à núr'a pa ke, mii mpyi na sí u ná u tɔ̀ɔnŋi ta.” ");
INSERT INTO spp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mpii pi mpyi ná saanŋi i wani ke, ka saanŋi si yi jwo pir'á “Yii na wyɛ́rɛŋi shwɔ ŋge báarapyiŋi na, yii kan báarapyiŋi niɲcyiiŋ'á, ŋgemu u à cwɔ̀hɔnte pyi mà u wyɛ́rɛɲuŋke fiigii kɛ ta ke.” ");
INSERT INTO spp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ka pi i saanŋi pyi “Kafooŋi, wyɛ́rɛŋi u ɲyɛ uru báarapyiŋ'á ke, ur'à ɲyaha mà kwɔ̀.” ");
INSERT INTO spp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ka saanŋi si pi pyi “Yii lógo! Shin maha shin u ɲyɛ ná yaage e ke, kà sí n‑bâra urufoo woge na. Ŋka shin maha shin cyeŋgaya wu u ɲyɛ ke, yaaga sì n‑kan urufol'á mɛ. Nimbileni urufoo bá na sɔ̂nŋi uye cye e ke, lire sí n‑shwɔ u na. ");
INSERT INTO spp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ɲyɛ numɛ, mii zàmpɛɛnbii pi mpyi na li kɔ̀re bà mii si mpyi mii àha bú mpyi saanwa pire ɲùŋɔ na mɛ, yii pi cû a yige naha, yii i pi bò na ɲyii na.”» ");
INSERT INTO spp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ɲyɛ Yesu à puru jwumpe puni jwo ke, maa ntòro sùpyire yyaha na na ŋkɛ̀ɛge Zheruzalɛmu kànhe e. ");
INSERT INTO spp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tèni i pi à sà byanhara Bɛtifajye ná Bɛtani kànyi na, Olivye cire ɲaŋke taan ke, ka Yesu si u cyelempyiibii pìi shuunni tun, ");
INSERT INTO spp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","maa pi pyi: «Kànhe ku ɲyɛ yii yyaha na ke, yii a sì k'e. Yii sí sà pi ta pi à dùfaanɲjaaga pwɔ wani, sùpya sàha ŋkwɔ̀ a dùgo ku na mà ɲya mɛ. Yii i ku sànha, yii a ma yii pa ŋkan na á. ");
INSERT INTO spp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wà ha yii yíbe na “Ɲaha na yii ɲyɛ na ku sànre yɛ?” yii i urufoo pyi “Ku kyaa li ɲyɛ Kafooŋi na.”» ");
INSERT INTO spp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ka cyelempyiibii mú shuunni si ŋkàre. Jwuŋkanni na Yesu mpyi a yi jwo pi á ke, ka pi i sà yi ta amu. ");
INSERT INTO spp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tèni i pi à wá na dùfaanŋke sànre ke, ka ku feebii si jwo: «Hɛn! Ɲaha na yii ɲyɛ na ku sànre yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ka pi i pi pyi: «Ku kyaa li ɲyɛ Kafooŋi na.» Ɲyɛ pi à yire jwo ke, ka dùfaanŋke feebii si pi yaha pi à ku sànha a kàre. ");
INSERT INTO spp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ka pi i mpa ná kuru dùfaanŋke e Yesu yyére, maa pi vàanɲyi yà taha ku na, maa Yesu pyi u à dùgo ku na. ");
INSERT INTO spp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ka pi i wá na ŋkɛ̀ɛge. Mà pi niŋkaribii yaha, ka sùpyire si wá na ti vàanntinɲyi yà wwû na mpìli Yesu yyaha na kuni i. ");
INSERT INTO spp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pi mpyi a byanhara Zheruzalɛmu kànhe na mà kwɔ̀. Pi à nɔ Olivye cire ɲaŋke tatigige e ke, ka u fyèɲwɔhɔshiinbii puni funntanga wuubii si li ɲwɔ cû na Kile kêre fànha na Yesu kakyanhala karigii kurugo, pi à cyire ɲcyiimu ɲya ke. ");
INSERT INTO spp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Pi mpyi na yu fànha na: «Saanŋi nimpaŋi u ŋge Kafooŋi Kile mɛge na ke, Kile u jwó le u á! Kileŋi u ɲyɛ nìɲyiŋi na ke, uru u ɲyɛ yyeɲiŋkefoo! Kile mɛge ku kêe nìɲyicyeyi puni i!.» ");
INSERT INTO spp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ɲyɛ Farizhɛɛnbii pi mpyi sùpyire shwɔhɔl'e ke, ka pire pìi si Yesu pyi: «Cyelentuŋi, ma cyelempyiibii faha, bà pi si mpyi si fyâha mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ka Yesu si pi pyi: «Mii cyelempyiibii mɛ́ɛ ká fyâha, ɲje kafaayi sí raa ŋkwúuli pi cyaga.» ");
INSERT INTO spp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ɲyɛ pi à sà byanhara Zheruzalɛmu kànhe ɲwɔge na, ka Yesu si kànhe ɲya ke, maa mɛɛ sú ku shiinbii kurugo maa jwo: ");
INSERT INTO spp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«Kuni i yyeɲiŋke ɲyɛ na ntaa ke, kàmpyi yii mpyi a lire lwɔ́ a wíi, li mpyi na sí n‑táan mii i niɲjaa dɛ! Ŋka lir'à ŋwɔhɔ yii na numɛ. ");
INSERT INTO spp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ɲyɛ canŋa na ma, yii zàmpɛɛnbii sí n‑pa n‑cwo yii na, si yii kwûulo kaɲcinnɛ fiige, si kàsɔɔgɔ le ntaha yii kwûulo, si yii fɛnrɛ kàmpanɲyi puni na. ");
INSERT INTO spp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pi sí yii kànhe jya si ku ŋkunuɲyi puni waraga feefee, si yii puni bò, ɲaha na yɛ Kile à pa yii ntɛ̀gɛŋi mɛɛ na, ŋka yii ɲyɛ a li cè ná u e mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lire kàntugo ka Yesu si ŋkàre Kileɲaarebage ntàani na. Mpii pi mpyi pɛrɛmpe na wani ke, maa pire kɔ̀rɔ. ");
INSERT INTO spp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Maa yi jwo pi á: «“Mii bage sí n‑pyi Kileɲaarebaga.” Yire y'à sémɛ Kile Jwumpe Semɛŋi i. Ŋka yii pi ke, yii à ku kɛ̂ɛnŋ'a pyi “nàŋkaalii tabinniga.”» ");
INSERT INTO spp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu mpyi maha Kile jwumpe yu Kileɲaarebage ntàani na canŋa maha canŋa. Ka Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii ná yyaha yyére shiinbii si wá na pyiŋkanna caa si u bò. ");
INSERT INTO spp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ŋka u cùŋkanni mpyi a pi funŋɔ wwòoŋɔ, ɲaha na yɛ u jwumpe mpyi a sùpyire puni ɲùmbogigii shwɔ a ta. ");
INSERT INTO spp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Canŋka mà Yesu yaha u u sùpyire kâlali maa Jwumpe Nintanmpe yu t'á Kileɲaarebage ntàani na, ka Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii ná Yahutuubii kacwɔnribii si shà u yyére, ");
INSERT INTO spp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","maa u yíbe: «Ná kuni ndire e mu na ɲcyii karigii pyi yɛ? Jofoo u à kuni kan mu á, mu u a cyi pyi yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ka Yesu si pi pyi: «Mii mú sí yii yíbe, ");
INSERT INTO spp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","jofoo u mpyi a Yuhana tun u pa a sùpyire batizeli yɛ? Kile laa sùpyire?» ");
INSERT INTO spp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ka pi i ŋkàr'a sà piye taanna maa jwo: «Wuu aha jwo na Kile u mpyi a Yuhana tun, u sí n‑jwo na ɲaha na wuu sí ɲyɛ a ɲɛn'a dá u na mà yɛ? ");
INSERT INTO spp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wuu sí ká jwo na sùpya u mpyi a u tun, sùpyire sí wuu wà n‑bò ná kafaayi i, ɲaha na yɛ pi pun'à dá na Yuhana na mpyi Kile tùnntunŋɔ.» ");
INSERT INTO spp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pi à piye taanna a kwɔ̀ ke, maa núr'a kàr'a sà Yesu pyi: «Shinŋi u mpyi a u tun ke, wuu ɲyɛ a cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ka Yesu si pi pyi: «Ɲyɛ l'aha mpyi amuni, ŋge u à kuni kan mii á, mii u a ɲcyii karigii pyi ke, mii mú sì uru cyêe yii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Lire kàntugo ka Yesu si bàtaaga jwo sùpyir'á. U à jwo: «Nàŋi wà u ná ɛrɛzɛn cikɔɔgɔ yaa, maa faafee lwɔ́ a yaha k'e, u ná pire s'a ku yasɛɛre táali piye na, maa nta a kàre kùlutɔɔnl'e mà sà mɔ wani. ");
INSERT INTO spp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ɲyɛ ɛrɛzɛnŋi yasɛɛre tèekwɔɔnn'à pa nɔ ke, ka u u u báarapyiŋi wà tun faafeebil'á u sà uru nàzhan ɛrɛzɛnŋi shwɔ, u a ma. Ŋka uru tùnntunŋ'à nɔ pi na ke, ka pi i u cû maa u bwɔ̀n, maa u cyeŋgaya wuŋi kɔ̀r'a tùugo. ");
INSERT INTO spp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ka cikɔɔge foo si núr'a báarapyi shɔnwu tun pi á, ka pi i uru bwɔ̀n maa u cyahala, maa uru cyeŋgaya wuŋi kɔ̀r'a núruŋɔ mú. ");
INSERT INTO spp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ka u u núr'a shin tanrewu tun pi á. Ka pi i sà uru cû, maa u bwɔ̀n mà bânnaga, maa u yige cikɔɔge kàntugo. ");
INSERT INTO spp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ɲyɛ ka cikɔɔge foo si ŋkànha a jwo “Ɲaha mii sí n‑pyi numɛ bɛ? Jyaŋi niŋkinŋi u ɲyɛ mii á, ná u kyal'à táan mii á ke, mii sí uru tun pi á. Shwɔhɔl'e, pi aha uru ɲya, pi sí n‑sílege uru na.” ");
INSERT INTO spp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ŋka faafeebil'à cikɔɔge foo jyaŋi ɲya ke, maa wá na yu piy'á “Cikɔɔge foo koolyiŋi u ɲyɛ ŋge. Yii a wá, wuu u bò, kɔɔge sí n‑ta n‑pyi wuu wogo.” ");
INSERT INTO spp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɲyɛ u à pa nɔ pi na ke, ka pi i u cû a wà cikɔɔge kàntugo maa u bò.» Yesu à puru jwo ke, maa sùpyire yíbe: «Ɲaha cikɔɔge foo sí n‑pyi yɛ? ");
INSERT INTO spp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nàkaana baa, u aha mpa, u sí pi puni bò si cikɔɔge kan piibɛril'á.» Ɲyɛ sùpyir'à puru lógo ke, maa jwo: «Ei! Kile u wuu shwɔ lire shiŋi na dɛ!» ");
INSERT INTO spp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ka Yesu si pi wíi wíi maa jwo: «Y'à sémɛ Kile Jwumpe Semɛŋi i na: “Bafaanribil'à cyé kafaage ŋkemu na ke, kuru k'à pa mpyi bage kafaage sèe woge bage mbìini na.” Di puru jwumpe ɲwɔhe ɲyɛ yɛ? ");
INSERT INTO spp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɲyɛ shin maha shin u à cwo kuru kafaage ɲuŋ'i ke, urufoo sí n‑kyɛɛgɛ n‑kyɛɛgɛ, kuru kafaage sí ká ɲcwo shin maha shin ɲuŋ'i ke, ku sí urufoo cwɔ̀nhɔnɔ.» ");
INSERT INTO spp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ɲyɛ Yesu à puru jwumpe jwo amuni ke, ka Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii si wá na ɲcaa si cye taha u na, si u cû lire tèenuuni i, ɲaha na yɛ pi mpyi a cè a jwo na u à ŋke bàtaage jwo a wà pire na. Ŋka pi mpyi na fyáge sùpyire na. ");
INSERT INTO spp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ɲyɛ ka pi i wá na Yesu kàanmucaa, maa cwòfeebii pìi yaha pi à kàr'a sà piye pyi sèeshiin si kànhaŋa cyán u na, si nta u cû u ɲwɔjwumpe kurugo, si u le Ɔrɔmu shiinbii fànhafooŋi u ɲyɛ kuru cyage e ke, uru cye e. ");
INSERT INTO spp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɲyɛ pire cwòfeebil'à sà nɔ Yesu yyére ke, maa jwo: «Wuu cyelentuŋi, wuu à li cè na mu jwumpe ná mu kàlaŋ'à tíi, mu ɲyɛ na fyáge sùpya na ma kàlaŋi tapyige e mɛ. Jwumpe mu sí ɲyɛ na yu mà yyaha tíi ná Kile kuni i ke, puru na ɲyɛ sèe. ");
INSERT INTO spp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wuu sí mu yíbe, wuu à yaa wuu a múnalwɔɔre kaan Ɔrɔmu Saanbwɔhe Sezari á la?» ");
INSERT INTO spp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ka Yesu si ntíl'a li cè pi e, na cwòfee pi ɲyɛ pi pi, maa pi pyi: ");
INSERT INTO spp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Yii wyɛ́rɛbile cyêe na na wee.» Pi à là cyêe u na ke, ka u u pi pyi: «Jofoo nàɲja ná u mɛgɛ ku ɲyɛ ŋge wyɛ́rɛŋi na yɛ?» Ka pi i jwo: «Saanbwɔhe Sezari.» ");
INSERT INTO spp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ka Yesu si pi pyi: «Ɲyɛ yii a Sezari wuŋi kaan Sezari á, yii raa Kile wuŋi kaan Kile á.» ");
INSERT INTO spp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɲyɛ pire cwòfeebii ɲyɛ a jà a jwumɔ niŋkin ta Yesu ɲwɔ na sùpyire ɲyii na, mpe pu sí n‑pa ná l'e pi jà a u cû mɛ. Yesu ɲwɔshwɔɔre mpyi a pi tɛgɛlɛ ta fo pi à fyâha fyi. ");
INSERT INTO spp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɲyɛ Sadusiibii pi maha jwo na kwuɲɛnɛ ɲyɛ nùmpanŋa mɛ, pire pìl'à file Yesu na maa jwo: ");
INSERT INTO spp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Wuu cyelentuŋi, Kile tùnntunŋiMusa à mpe jwumpe sémɛ wuu Saliyaŋi i na “Nɔ̀ ká ceewe lèŋɛ, maa ŋkwû, mà u ta u ɲyɛ a pyà ta u na mɛ, u cɔɔnŋ'à yaa u ceeŋi lèŋɛ zànbangara na, u u pyìi si u na, u yyahafooŋi niŋkwuŋi mɛge na.” ");
INSERT INTO spp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ɲyɛ sìɲɛɛ baashuunni na mpyi wani, pi puni niɲjyeŋi mpyi a ceewe lèŋɛ maa ŋkwû, u ɲyɛ a pyà ta u na mɛ, ");
INSERT INTO spp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ka sìɲɛɛŋi shɔnwuŋi si ceeŋi lwɔ́ maa ŋkwû mà u yaha pyàtambaa. ");
INSERT INTO spp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ka tanrewuŋi wuuni mú si mpyi amuni fo mà sà ŋkwɔ̀ pi baashuunniŋi na. Pire sìɲɛɛbii pun'à uru ceeŋi niŋkinŋi lèŋ'a círi, maa ŋkwû, pi wà ɲyɛ a pyà ta u na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pire puni kàntugo, ka ceeŋi mú si mpa ŋkwû. ");
INSERT INTO spp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ɲyɛ ná pire nàmbaa baashuunniŋi puni s'à uru ceeŋi lèŋ'a círi, kwùubii ɲɛ̀ŋi ká bú nta sèe, pi aha bú ɲɛ̀ canŋke ŋkemu i ke, pi ŋgir'á ceeŋi sí n‑kan yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ka Yesu si pi pyi: «Ŋge diɲyɛŋi i, nàmbaabii na cyeebii lèŋi, cyeebii sí i nàmbayi jyè, ");
INSERT INTO spp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ŋka sùpyire t'à yaa ná diɲyɛŋi nimpaŋi i, ná Kile sí ti ɲɛ̀ n‑yige kwùŋi i ke, tire e, nàmbaabii sì cyee lèŋɛ mɛ, cyeebii mú sì nàmbaya jyè mɛ. ");
INSERT INTO spp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pi sí n‑kwôro shì na fo tèekwombaa, si mpyi Kile mɛ̀lɛkɛɛbii fiige. Ná Kile s'à pi ɲɛ̀ a yige kwùŋi i lir'à li cyêe na pi à pyi Kile pyìi. ");
INSERT INTO spp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kile tùnntunŋi Musa sémɛŋi mú à yi fíniŋ'a jwo wuu á na kwùubii maha ɲɛ̀ni. Tèni i Kafooŋi Kile à jwo ná Musa e tahe nage woge taan ke, u à jwo “Mii u ɲyɛ Ibirayima ná Ishaka ná Yakuba u Kileŋi.” ");
INSERT INTO spp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ɲyɛ puru jwump'à li cyêe na pire mpii ɲyii wuu pi ɲyɛ wani Kile yyére. Sùpyire ɲyii woore ti maha Kile pêre, kwùubii kyaa bà mɛ. Kile yyére, sùpyire puni ɲyii wuu pi ɲyɛ.» ");
INSERT INTO spp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","U à puru jwo ke, ka Kile Saliyaŋi cyelentiibii pìi si file u na, maa jwo: «Cyelentuŋi, mu naha a jwumpe cè dɛ!» ");
INSERT INTO spp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lire kàntugo wà saha ɲyɛ a ɲɛn'a Yesu yíbe mɛ. ");
INSERT INTO spp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ɲyɛ ka Yesu si jwumpe lwɔ́, maa jwo: «Mpii pi maha jwo na Kile Niɲcwɔnrɔŋi na ɲyɛ Dawuda Tuluge Shin ke, ɲaha yii na sɔ̂nŋi pur'e bɛ? ");
INSERT INTO spp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Jwumpe Dawuda à jwo Zaburu sémɛŋi i ke, yii sɔ̂nŋɔ puru na mú. U à jwo: “Kafooŋi Kile à jwo mii Kafooŋi á, ‘Ta ma a pa ntɛ̀ɛn na kàniŋɛ cyɛge na, ");
INSERT INTO spp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","fo mii aha mu zàmpɛɛnbii le mu tooyi ɲwɔh'i.’” ");
INSERT INTO spp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ná Dawuda na Kile Niɲcwɔnrɔŋi yiri “Kafooŋi” lir'à li cyêe na Dawuda Tuluge Shin kanna bà mɛ, u Kafoo mú wi, sèe bàl'à?» ");
INSERT INTO spp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mà sùpyire yaha ti i núru Yesu ɲwɔ na, u à yi jwo u cyelempyiibil'á: ");
INSERT INTO spp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Yii a yiye kàanmucaa, yii àha ŋkwɔ̀ mpyi Kile Saliyaŋi cyelentiibii fiige mɛ. Mà vàanntinmbwoyi le na ɲaare, lire l'à táan pi á. Sùpyire tabinniyi i, pi la maha mpyi pi a pire pêre pi raa pire shɛ́ɛre. Pi aha shà Kile Jwumpe kàlambayi i, lire ɲyɛ mɛ wà ha pi yyere kataan ɲjyì na, bwompe tatɛɛnyi pi maha ɲcaa. ");
INSERT INTO spp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mà bâra lire na, pi maha leŋkwucyeebii cyeyaayi puni shuu pi na ná pi ɲwɔtanyi i. Pi maha Kile ɲáare na mɔni, sùpyire ɲyiɲyage na. Lire kurugo nde li sí n‑pa pi ta ke, lire sí n‑waha sèl'e.» ");
INSERT INTO spp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ɲyɛ Yesu à pa wíl'a nàfuufeebii pìi ɲya pi i ma na pi bùɲyɛŋi leni u yaleŋke e. ");
INSERT INTO spp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Leŋkwucwoŋi kanhamafooŋi wà mú mpyi a pa bùɲyɛ pyi ná daashipyara shuunni i. ");
INSERT INTO spp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ka Yesu si u lógofeebii pyi: «Sèeŋi na mii sí yi jwo yii á, ŋge leŋkwucwo fòŋɔfooŋ'à bùɲyɛŋi ŋgemu pyi ke, ur'à fànha tò pi sanmpii puni wuŋi na. ");
INSERT INTO spp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ɲaha na yɛ pi sanmpii pun'à wwû pi cyeyaayi niɲyahayi i, mà kan Kile á. Ŋka ŋge leŋkwucwoŋi kanhamafooŋi wi ke, u ɲùŋɔ wyɛ́rɛŋi puni u à kan Kile á, canŋke yalyire lwɔɔre mú bá ɲyɛ u á mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lire kàntugo ka pìi si jwo ná Yesu i Kileɲaarebage kyaa na na k'à faanra ná kafaayi nisinaɲyi i, maa sùpyire bùɲyɛ yaayi niŋkanyi tɛ̀g'a ku wiimɛ táan. Ka Yesu si pi pyi: ");
INSERT INTO spp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ŋke basinaŋke yii ɲyɛ na ɲan'amɛ ke, canŋa na ma, ku puni sí n‑sìi n‑pwɔ̀n n‑cyán, si ku ŋkunuɲyi puni waraga, fo si ku kafaayi láha láha yiye na.» ");
INSERT INTO spp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ka pi i Yesu pyi: «Wuu cyelentuŋi, ɲaha tère e cyire karigii sí n‑pyi yɛ? Cyi tèepyiini ká nɔ, ɲaha ku sí li cyêe wuu na yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ka Yesu si pi pyi: «Yii a yiye kàanmucaa! Yii àha sùpya yaha u yii wurugo mɛ. Yii li cè na shinɲyahara sí mii mɛge le piye na, si mpa jwo na Kile Niɲcwɔnrɔŋi kyaa l'à jwo ke, na pire pi ɲyɛ ure. Pi sí n‑pa raa ŋko sùpyir'á na diɲyɛŋi tèekwoon'à byanhara. Ŋka yii àha ntaha pi fye e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yii sí n‑pa raa kàshiyi ná ɲyàhaŋguruguŋi kyaa núru, lire kà yii funŋɔ pɛn mɛ. Yii li cè na cyire karigii mpyimbaa ɲyɛ mɛ, ŋka lire bà li ɲyɛ diɲyɛŋi tèekwooni mɛ. ");
INSERT INTO spp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Supyishiŋi wà sí n‑pa n‑yîri n‑sà n‑cwo wà na, kìni là sí n‑pa n-yîri n‑sà n‑cwo là na. ");
INSERT INTO spp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ɲìŋke sí n‑pa raa ɲcyɛ̂ɛnni cyeyi y'e s'a kakyaare pyi sèl'e, yampimpe ná katege sí n‑pyi cyeyi y'e, fyagara yaayi ná kakyanhala kacyeeŋkii yaayi mú sí n‑pa raa ɲaa nìɲyiŋi i. ");
INSERT INTO spp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ŋka mà jwo cyire karigii cyi sìi cyi a mpyi ke, pi sí raa yii kyérege, s'a yii cwôre s'a ŋkɛ̀ɛge Kile Jwumpe kàlambayi i, si nta raa yii cɛ̂ɛge s'a yii tùni kàsuŋi i. Pi sí raa yii yiri saanbii ná fànhafeebii yyére. Pi sí raa cyire puni pyi yii na mii mɛge kurugo. ");
INSERT INTO spp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lire sí n‑pyi tère niɲcɛnnɛ yii á yii jà yii a mii kyaa yu pi á. ");
INSERT INTO spp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lire e ke jwumpe yii sí n‑jwo si ntɛ̀gɛ pi ɲùŋɔ bɛ̂ ke, yii àha puru kani tɛ̀gɛ yiye funŋɔ pɛn mɛ. ");
INSERT INTO spp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ɲaha kurugo yɛ mii yabiliŋi u sí puru tîrige yii funŋ'i, si yákili niɲcɛnŋɛ kan yii á, bà yii si mpyi si jwumpe ɲwɔge yaha yii zàmpɛɛnbii na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yii sifeebii ná yii sìɲɛɛbii ná yii cìnmpyiibii ná yii ceveebii sí raa yii leni cye e, pi i yii pìi bò. ");
INSERT INTO spp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yii kyaa sí n‑pɛn sùpyire pun'á mii mɛge kurugo. ");
INSERT INTO spp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ŋka lire ná li wuuni mú i, ali yii wà ɲùɲjuŋɔ niŋkin sì n‑sìi n‑pînni mɛ. ");
INSERT INTO spp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lire kurugo yii yiye waha yii i ntɛ̀ɛn Kile kuni i. Lire ká mpyi, yii sí n‑shwɔ. ");
INSERT INTO spp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ɲyɛ yii aha mpa zàmpɛɛnbii ɲya pi à Zheruzalɛmu kànhe kwûulo ná pi kàshicyeyi i tèni ndemu i ke, yii i ntɛ̀ɛn ná l'e ku tèejyaan'à byanhara. ");
INSERT INTO spp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lire tèni ká nɔ, mà shin maha shin ta Zhude kùluni i ke, pirefee pi a fî, pi a wá ɲaɲyi kàmpanŋke na. L'aha mpiimu ta Zheruzalɛmu yabiliŋi i ke, pirefee pi fê a fworo kànhe e. L'aha mpiimu ta sige e ke, pire kà núru piye ta raa ma kànhe e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ɲaha kurugo yɛ cyire canmpyaagil'e, Kile sí Zheruzalɛmu shiinbii sâra si ntàanna ná pi kapyiiŋkil'e. Lire mpyiŋi cye kurugo jwumpe Kile tùnntunmpil'à sémɛ ke, puru sí n‑fûnŋɔ. ");
INSERT INTO spp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Cyire canmpyaagii sí n‑waha lahigiifee ná pyìnɛɛbii na sèl'e. Yii li cè, Kile lùuni sí n‑yîri kìni sùpyire taan sèl'e, yyefugo nimbwɔhɔ ku sí n‑pyi kìni i. ");
INSERT INTO spp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pi zàmpɛɛnbii sí n‑pa niɲyahara bò pi e ná kàshikwɔnŋwɔɔyi i, si pi niɲyahamii cû ŋkàre bilere na diɲyɛ yyaha kurugo. Supyishiŋi sanŋi sí n‑pa Zheruzalɛmu jya, si fànha cyán ku na, fo sí n‑pa nɔ Kile ɲyii tèni na. ");
INSERT INTO spp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Lire kàntugo kakyanhala kacyeeŋkii sí n‑pa raa n‑pyi canŋa ɲyiini ná yiŋke ná wɔrigil'e. Suumpe lùbwɔhe sí n‑pa raa fuuli raa yîri s'a tùnmpe pyi sèl'e. Puru tùnmpe sí supyishiŋi puni pyi u a fyáge sèl'e. ");
INSERT INTO spp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kawaani li sí n‑pa diɲyɛŋi ná u funŋɔyaayi ta ke, lire funmpɛɛnre sí pìi bò. Yii li cè nìɲyiŋi yaayi sí n‑pa n‑cúnŋɔ n‑cúnŋɔ n‑yîri yi tatɛɛnyi i. ");
INSERT INTO spp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ɲyɛ lire tèni i, pi sí Supyaŋi Jyaŋi nimpaŋi ɲya ɲahaɲyi i, ná sífente ná sìnampe tɛgɛlɛ baa wumpe e. ");
INSERT INTO spp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yii aha cyire karigii ɲya cyi à sìi na mpyi tèni ndemu i ke, yii i yii ɲùɲyi yîrige, yii i yyahayi le nìɲyiŋi i, ɲaha na yɛ tèni i Kile sí yii shwɔ ke, lire tèn'à byanhara.» ");
INSERT INTO spp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ɲyɛ ka Yesu si yyecyeenɛ pyi na: «Yii fizhiye cige ná cire sannte puni kàanmucya a wíi kɛ! ");
INSERT INTO spp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yii aha mpa ti ɲya ti i fûnni, yii maha ntɛ̀ɛn ná l'e na nùŋgwɔh'à byanhara. ");
INSERT INTO spp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lire pyiŋkanni na, yii aha mpa cyire karigii ɲya cyi i mpyi, yii i ntɛ̀ɛn ná l'e na Kile Saanre tèn'à byanhara. ");
INSERT INTO spp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sèeŋi na mii sí yi jwo yii á, mpii pi à dá mii na ke, pire sí cyire karigii ɲya tapyige e. ");
INSERT INTO spp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nìɲyiŋi ná ɲìŋke sí n‑pa n‑tòro, ŋka mii jwumpe sí n‑kwôro fo tèekwombaa. ");
INSERT INTO spp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yii a yiye kàanmucaa! Yii àha yii sɔ̀nŋɔre taha lyìmbwooni ná sinmbyaani ná ŋge diɲyɛŋi yaayi ɲcyaŋi na fo mii cannuruge ku pa n‑pâa yii e mɛ. Bà fyaŋi maha mpâl'a uye ɲya cwoŋi i mɛ, ");
INSERT INTO spp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","amuni mii cannuruge sí n‑pâa diɲyɛŋi sùpyire puni i. ");
INSERT INTO spp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lire e yii àha sàa le mɛ, yii kwôro Kileɲarege na tèrigii puni i, bà yii si mpyi si fànha ta, si shwɔ kawaagii nimpaaŋkii na, si jà ɲjyére Supyaŋi Jyaŋi yyahe taan mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Canŋke e Yesu mpyi maha Kile jwumpe yu sùpyir'á Kileɲaarebage e, ŋka numpilage e, ɲaŋke pi maha mpyi Olivye cire ɲaŋke ke, u mpyi maha ŋkàr'a sà shwɔ̀n wani. ");
INSERT INTO spp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ɲyɛ̀sɔɔge na, sùpyire puni mpyi maha ŋkàre Kileɲaarebage e, maha sà a núru u ɲwɔ na. ");
INSERT INTO spp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ɲyɛ Yahutuubii mpyi maha kataanni là pyi, pi mpyi maha lire mɛge pyi bilereŋkwoŋi kataanni, lire ɲyɛ mɛ bwúuruŋi niɲjirigembaaŋi kataanni. Lire kataann'à pa byanhara ke, ");
INSERT INTO spp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ka Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii si wá na pyiŋkanna caa si Yesu ŋwɔhɔ mbò, ɲaha na yɛ pi mpyi na fyáge sùpyire na. ");
INSERT INTO spp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ɲyɛ Zhudasi pi maha mpyi: «Isikariyoti» ke, Sitaanniŋi mpyi a sɔ̀nŋɔpeere tà tîrige uru funŋ'i. Yesu tùnntunmpii kɛ ná shuunniŋi wà u mpyi u wi. ");
INSERT INTO spp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ɲyɛ ka u u yîr'a kàr'a sà jwo a ɲwɔ ná Kile sáragawwuubii ɲùŋufeebii ná Kileɲaarebage saɲcwɔnsigibii ɲùŋufeebil'e, bà u si mpyi si pyiŋkanna ta si Yesu le cye e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ka lire si ntáan pi e sèl'e, ka pi i wyɛ́rɛ ɲwɔ jya u á. ");
INSERT INTO spp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ɲyɛ ka u u ɲɛɛ, maa li ɲwɔ cû na pyiŋkanna caa si Yesu le pi cye e, sùpyire pàama. ");
INSERT INTO spp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ɲyɛ bwúuruŋi niɲjirigembaaŋi kataanni tooy'e, canŋke Yahutuubii mpyi a yaa pi yatɔɔre tà pyi sáraga pi bilereŋkwoŋi kurugo ke, ");
INSERT INTO spp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ka Yesu si Pyɛri ná Yuhana tun maa yi jwo pi á: «Yii a sì, yii sà kataanni ɲjyìŋi karigii cwɔɔnrɔ.» ");
INSERT INTO spp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ka pi i Yesu yíbe: «Taa mu la ɲyɛ wuu u sà li karigii cwɔɔnrɔ ke?» ");
INSERT INTO spp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ka u u pi pyi: «Yii aha sà nɔ kànhe tajyiɲwɔge na, yii sí n‑bɛ̂ ná nàŋi w'e, u à lwɔhɔ kucwoo tugo. Yii i ntaha u fye e fo u aha sà jyè pyɛnge ŋkemu i ke. ");
INSERT INTO spp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yii aha sà nɔ wani, yii i yi jwo pyɛngefooŋ'á, na yii cyelentuŋ'à jwo yii sà u yíbe, na bage ŋkire e uru ná u cyelempyiibii sí kataanni ɲjyìŋi lyî yɛ. ");
INSERT INTO spp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yii aha kuru yibige pyi, uru nàŋi sí batɔɔnge nìɲyibabilini là cyêe yii na, l'à bégel'a ɲwɔ sèl'e. Kuru bage e, yii sí kataanni ɲjyìŋi karigii cwɔɔnrɔ.» ");
INSERT INTO spp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ɲyɛ ka Pyɛri ná Yuhana si ŋkàr'a sà yi ta Yesu jwuŋkanni na. Ka pi i kataanni ɲjyìŋi karigii cwɔɔnrɔ wani. ");
INSERT INTO spp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ɲyɛ tèelyiin'à nɔ ke, ka Yesu ná u tùnntunmpii kɛ ná shuunniŋi si ɲjyìŋi kwûulo na lyî. ");
INSERT INTO spp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ka u u yi jwo pi á: «Mii à sàa li lwɔ́ naye funŋ'i fo tèemɔni i si zìi nde kataanni ɲjyìŋi lyî ná yii e, si nta ŋkyaala. ");
INSERT INTO spp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mii sí yi jwo yii á, mii saha sì n‑sìi ŋge ɲjyìŋi fiige lyî mɛ, fo canŋke Kile sí u kalyiini ɲùŋke pyi ku fûnŋɔ u Saanre e ke.» ");
INSERT INTO spp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lire kàntugo ka u u fùnɲcwokwuu lwɔ́ ná ɛrɛzɛn sinm'e, maa fwù kan Kile á pu kyaa na, maa jwo cyelempyiibil'á: «Yii ɛrɛzɛn sinmɛ shwɔ a táa yiye na, yii bya. ");
INSERT INTO spp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mii sí yi jwo yii á, mà láha niɲjaa na, mii saha sì ɛrɛzɛn sinmɛ bya mɛ, fo Kile Saanre tèni ká nɔ.» ");
INSERT INTO spp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lire kàntugo ka Yesu si bwúuruŋi lwɔ́, maa fwù kan Kile á u kyaa na, maa u kwɔ̀n kwɔ̀n a kan u cyelempyiibil'á, maa jwo: «Ŋge bwúuruŋi u ɲyɛ mii cyeere, t'à kan yii kurugo ke. Yii a nde pyi, yii raa yiye funŋɔ cwo na na.» ");
INSERT INTO spp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ɲyɛ pi à kwɔ̀ ɲjyìŋi na ke, ka Yesu si fùnɲcwokwuuni lwɔ́, ɛrɛzɛn sinmɛ mpyi l'e, maa jwo cyelempyiibil'á: «Nde fùnɲcwokwuuni li ɲyɛ Kile tunmbyaare nivɔnnte, t'à le ná yii e mii sìshange niŋguŋke cye kurugo ke. ");
INSERT INTO spp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ŋka lire ná li wuuni mú i, yii li cè, ŋgemu u sí n‑pa mii le cye e ke, urufoo cyɛge na naha ná mii woge e ɲjyìŋi yaage e. ");
INSERT INTO spp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sèeŋi na, Kile à li lwɔ́ Supyaŋi Jyaŋi u bò. Ŋka ŋgemu u sí n‑pa u le cye e ke, urufoo wuun'à kɛ̀ɛge!» ");
INSERT INTO spp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ɲyɛ Yesu cyelempyiibil'à yire lógo ke, ka pi i wá na piye yíbili na jofoo u ɲyɛ pire shwɔhɔl'e, ŋgemu u sí ɲɛɛ n‑pa lire kapiini shiŋi pyi yɛ. ");
INSERT INTO spp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lire kàntugo ka jwuɲyahama si mpa yîri cyelempyiibii shwɔhɔl'e. Puru jwuɲyahampe ɲùŋke ku mpyi na jofoo u ɲyɛ pire shwɔhɔl'e ɲùŋufooŋi yɛ. ");
INSERT INTO spp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ka Yesu si pi pyi: «Yii li cè, naha ɲìŋke na, saanbii maha fànhe pyi kìni sùpyire ɲuŋ'i. Mpii ɲuŋ'i pi sí ɲyɛ na kuru fànhe pyi ke, pi la maha mpyi pire s'a pi kêre s'a ŋko na pi na ɲyɛ sèeshiin. ");
INSERT INTO spp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ŋka yii wuuni ɲyɛ a yaa li pyi amuni mɛ, yii puni yyaha yyére shinŋ'à yaa u pyi yii puni kàntugo yyére shinŋi. Ŋgemu la ku ɲyɛ si mpyi yii puni ɲùŋufooŋi ke, urufol'à yaa u uye pyi yii puni báarapyi. ");
INSERT INTO spp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Báarapyiŋi u maha ɲjyìŋi sore u ɲùŋufooŋ'a sì ntɛ̀ɛn maa lyî kanna ke, pire shiin shuunniŋi i, ŋgire u ɲyɛ yyaha yyére shinŋi yɛ? Tá ŋge u à tɛ̀ɛn marii lyî kanna ke, uru bà mɛ? Ŋka mii wi ke, mii ɲyɛ báarapyi yii shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yii pi ke, yii à kwôro ná mii i na yyefuge tèrigil'e. ");
INSERT INTO spp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lire kurugo bà mii Tuŋi à mii tìŋ'a pyi saanwa mɛ, amuni mii mú sí yii tìŋɛ n‑pyi saanlii. ");
INSERT INTO spp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Lire e yii sí n‑pa lyî si bya ná mii i, mii Saanre e. Yii sí n‑pa n‑tɛ̀ɛn saanre tatɛɛnyi y'e, s'a Izirayɛli tùluyi kɛ ná shuunniŋi shiinbii kɛ̂ɛnŋi.» ");
INSERT INTO spp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Lire kàntugo ka Yesu si jwo Simɔ Pyɛri á: «Simɔ! Simɔ! Sitaanniŋi à li cya si yii ɲyàha ŋgùrugo, bà sùmapyaŋi maha ɲyàha a wùrugo tafwɔge e ntanh'e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ŋka mii à Kile ɲáare mu kurugo, bà mu si mpyi si ŋkwôro Kile kuni i mɛ. Mu aha maye cɛ̂ɛge ma kapyiini na, si núru raa ma mii yyére tèni ndemu i ke, ma a màban le ma cìnmpyiibii dánafeebil'e.» ");
INSERT INTO spp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ka Simɔ Pyɛri si Yesu pyi: «Kafooŋi, l'à pyi kàsujyire yo, l'à pyi kwù yo, mii à bégele cyire puni mɛɛ na ná mu i.» ");
INSERT INTO spp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ka Yesu si u pyi: «Pyɛri, mii sí yi jwo mu á, niɲjaa ŋkùpecyiini sí mu ta mu à jwo a nɔ tooyo taanre na na mu ɲyɛ a mii cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Lire kàntugo ka Yesu si u cyelempyiibii pyi: «Tèni i mii à yii tun, maa yii pyi na yii àha wyɛ́rɛ ná boro ná tanhaɲyi yabɛrɛ lwɔ́ mbâra yii tooyi wuyi na mɛ, tá yaaga kul'à yii ta bɛ?» Ka pi i u pyi: «Yaaga kuu ɲyɛ a wuu ta mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ka Yesu si jwo: «Numɛ, wyɛ́rɛ na ɲyɛ yii ŋgemu á ke, urufoo u u lwɔ́, yii ŋgemu u ɲyɛ ná bor'e ke, urufoo u li lwɔ́, ŋgemu u ɲyɛ kàshikwɔnŋwɔɔ baa ke, urufoo u u vàanntinŋke pɛ́r'a tɛ̀g'a là shwɔ. ");
INSERT INTO spp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ɲaha kurugo yɛ mii sí yi jwo yii á, Kile tùnntunmpil'à jwumpe mpemu sémɛ mii kyaa na ke, puru tèefunŋɔn'à byanhara. Y'à sémɛ na “Pi à u cû kapimpyiŋɛ fiige.” Nde l'à sémɛ mii kyaa na ke, lire tèepyiin'à byanhara.» ");
INSERT INTO spp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ka cyelempyiibii si jwo: «Kafooŋi, kàshikwɔnŋwɔhii shuunni cyi ɲcyii.» Ka Yesu si pi pyi: «Yi à ta.» ");
INSERT INTO spp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ɲyɛ lire kàntugo, ka Yesu si yîri wani mà kàre Olivye cire ɲaŋke na, bà u mpyi maha ntêe na li pyi mɛ. Ka u cyelempyiibii si ŋkàre u fye e. ");
INSERT INTO spp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pi à sà nɔ kuru cyage e ke, ka Yesu si pi pyi: «Yii a Kile ɲáare bà yii si mpyi si fànha ta Sitaanniŋi na, u àha ŋkwɔ̀ yii sɔ̀n ŋgà kapii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yesu à puru jwo ke, maa yîri cyelempyiibii taan, maa laaga nimbilere le u ná pi shwɔhɔl'e, maa niŋkure sín, maa Kile ɲáare. ");
INSERT INTO spp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","U Kileɲarege e, u à jwo: «Tufooŋi, kampyi mu sí ɲɛɛ, na shwɔ ŋke kyaage lwɔhe mbyaŋi na. Ŋka ma hà na ɲyii wuuni pyi mɛ, ma ɲyii wuuni pyi.»  ");
INSERT INTO spp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ɲyɛ lire tèni i, ka Kile mɛ̀lɛkɛŋi wà si yîri nìɲyiŋi na, maa màban le u e. ");
INSERT INTO spp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu yákiliŋi mpyi a wùrugo sèl'e, ka u u núr'a là bâra Kileɲarege na, fo u fùnmp'à kɛ̂ɛnŋ'a pyi sìshan na ɲcwo ɲìŋke na. ");
INSERT INTO spp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","U à kwɔ̀ Kileɲarege na ke, maa yîr'a kàre u cyelempyiibii cyage e, mà sà pi nàvunŋɔ wuubii ta pi à ŋɔ́ɔ. ");
INSERT INTO spp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Maa pi ɲɛ̀, maa jwo: «Di k'à ta a jwo, ka yii i ŋɔ́ɔ yɛ? Yii yîri, yii i Kile ɲáare, bà li si mpyi Sitaanniŋi kà ŋkwɔ̀ yii sɔ̀n ŋgà kapii na mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ɲyɛ mà Yesu yaha puru jwumpe na, ka pi i wíl'a supyikuruŋɔ ɲya ku u ma. Zhudasi u mpyi Yesu cyelempyiibii kɛ ná shuunniŋi wà ke, uru u mpyi a ku yyaha cû. Pi à pa nɔ Yesu na ke, ka Zhudasi si file u na, maa u pûr'a cû, maa u shɛ́ɛre. ");
INSERT INTO spp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ka Yesu si jwo: «Zhudasi, uru fwùŋi mu à pyi si Supyaŋi Jyaŋi le cye e kɛ!» ");
INSERT INTO spp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ɲyɛ Yesu cyelempyiibil'à pa li ɲya ná Yesu tacuŋke e pi à pa ke, ka pi i Yesu yíbe: «Kafooŋi, wuu kàshikwɔnŋwɔhigii lwɔ́ pi mɛɛ na la?» ");
INSERT INTO spp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ka pi wà niŋkin si ntíl'a u kàshikwɔnŋwɔɔge tɛ̀g'a Kile sáragawwuubii ɲùŋufembwɔhe báarapyiŋi kàniŋɛ niŋgeŋke kwɔ̀n a cyán. ");
INSERT INTO spp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ka Yesu si jwo: «Yii kakyaare ɲwɔ yaha!» U à yire jwo ke, maa nàŋi niŋgeŋke lwɔ́ a sogo. ");
INSERT INTO spp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Lire kàntugo Kile sáragawwuubii ɲùŋufeebii ná Kileɲaarebage saɲcwɔnsigibii ɲùŋufeebii ná Yahutuubii kacwɔnribii pi mpyi a pa Yesu tacuŋke e ke, ka u u yi jwo pi á: «Yii à pa mii fye e ná kàshikwɔnŋwɔɔyi ná kàbiiyi i, si mpa ɲcû mu à jwo kakuumpyi u ɲyɛ mii, ");
INSERT INTO spp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","mà li ta, tèni i mii mpyi maha mpyi ná yii e canŋa maha canŋa Kileɲaarebage e ke, yii ɲyɛ a yaaga pyi mii na mɛ. Ŋka nde tèni na ɲyɛ yii ná numpinifoo wuu.» ");
INSERT INTO spp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɲyɛ ka pi i Yesu cû a kàre Kile sáragawwuubii ɲùŋufembwɔhe pyɛnge e. Mà pi niŋkaribii yaha, ka Pyɛri si ntɛ̀ɛn laage e, marii sì pi fye e, fo mà sà jyè pyɛnge e. ");
INSERT INTO spp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pi mpyi a na le, na ware ntàani niŋke e, ka Pyɛri si mpa ntɛ̀ɛn pi shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ɲyɛ báarapyicwoŋi wà à pa Pyɛri nintɛɛnŋi ɲya nage taan ke, maa u yal'a wíi, maa jwo: «Ŋge nàŋi na ɲyɛ Yesu fyèɲwɔhɔshiinbil'e.» ");
INSERT INTO spp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ka Pyɛri si yi kyáala: «Ceewe, mii ɲyɛ a u cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lire kàntugo ka nàŋi wà si Pyɛri wíi maa jwo: «Mu mú na ɲyɛ Yesu fyèɲwɔhɔshinŋi wà.» Ka Pyɛri si jwo: «Sèe bà mɛ!» ");
INSERT INTO spp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ɲyɛ tèr'à pyi ke, ka wabɛrɛ si núr'a yi jwo a waha na: «Nàkaana baa, ŋge nàŋi na mpyi ná Yesu i, ɲaha na yɛ Galile kùluni shin u ɲyɛ u wi.» ");
INSERT INTO spp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ka Pyɛri si u pyi: «Mii nàha a mu jwumpe yyeshage cè mà dɛ!» Ɲyɛ mà Pyɛri yaha puru na, ka ŋkùpooŋi si ntíl'a mɛɛ sú. ");
INSERT INTO spp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ka Kafooŋi Yesu si yyaha kɛ̂ɛnŋɛ maa Pyɛri wíi. Ka u funŋke si ɲcwo Kafooŋi jwumpe niɲjwumpe na na: «Mà jwo ŋkùpecyiini li mɛɛ sú niɲjaa ke, lire sí mu ta mu à jwo a nɔ tooyo taanre na na mu ɲyɛ a mii cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ɲyɛ ka Pyɛri si fworo pyɛnge e, maa sà mɛɛ sú sèe sèl'e. ");
INSERT INTO spp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ɲyɛ mpii pi mpyi na Yesu kàanmucaa ke, ka pire si wá na u fwɔ́hɔre, maa u bwùun. ");
INSERT INTO spp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Maa u yyahe pwɔ, maa u yíbe: «Mu ɲyɛ a jwo na mu na ɲyɛ Kile tùnntunŋɔ mà? Ŋge u à mu bwɔ̀n ke, uru mɛge yyere wuu á!» ");
INSERT INTO spp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Maa jwuɲjwumbaampe pabɛrɛ niɲyahama jwo u na. ");
INSERT INTO spp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ɲyɛ ɲyɛ̀g'à pa múgo ke, ka Yahutuubii kacwɔnribii ná Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii si piye bínni, maa ŋkàre ná Yesu i pi yukyaala kuruŋke yyére. ");
INSERT INTO spp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Maa u yíbe: «Kile Niɲcwɔnrɔŋi u ɲyɛ mu la? Yi yyaha jwo wuu á.» Ka u u pi pyi: «Mii mɛ́ɛ ká yi jwo yii á, yii sì n‑dá yi na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mii sí ká yii yíbe, yii sì ɲɛɛ mii ɲwɔ shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ŋka mà lwɔ́ numɛ na Supyaŋi Jyaŋi sí n‑sà n‑tɛ̀ɛn Kile Siŋifoo kàniŋɛ cyɛge na.» ");
INSERT INTO spp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɲyɛ Yesu à yire jwo ke, ka pi puni si u pyi: «Lire sanni i ke, Kile Jyaŋi u ɲyɛ mu la?» Ka u u pi pyi: «Ɲje yii à jwo ke, yire yi ɲyɛ yi yi.» ");
INSERT INTO spp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ka pi i jwo: «Wuu saha ɲyɛ a tîge wà ɲwɔjwumɔ kurugo mɛ, ɲaha na yɛ wuu yabilimpil'à lógo u ɲwɔ na mà kwɔ̀.» ");
INSERT INTO spp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ɲyɛ ka pi puni si yîri siɲcyan, maa ŋkàre ná Yesu i fànhafooŋi Pilati yyére. ");
INSERT INTO spp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pi à sà nɔ wani ke, maa fin'a taha Yesu na Pilati á na: «Wuu à sà ŋge nàŋi ta u u sùpyire ɲùŋɔ kyánge, na pi ɲyɛ a yaa pi a múnalwɔɔre kaan saanbwɔhe Sezari á mɛ. U à jwo na uru u ɲyɛ Kile Niɲcwɔnrɔŋi, na uru na ɲyɛ saanwa.» ");
INSERT INTO spp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ka Pilati si Yesu yíbe: «Yahutuubii saanŋi u ɲyɛ mu la?» Ka Yesu si u pyi: «Mu aha jwo amuni yo.» ");
INSERT INTO spp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ka Pilati si jwo Kile sáragawwuubii ɲùŋufeebii ná sùpyire sannt'á: «Mii nàha tìgire cyaga ta ŋge nàŋi na, ŋkemu ku sí n‑pa ná l'e u bò mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ka pi i núr'a yi jwo a waha Pilati á: «U wá na sùpyire ɲùŋɔ kyánge ná u jwumpe e Yahutuubii kùluni puni i, mà lwɔ́ Galile kùluni na, fo mà pa nɔ naha wuu na.» ");
INSERT INTO spp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tèni i Pilati à yire lógo ke, maa pi yíbe na Galile kùluni shin u ɲyɛ ŋge nàŋi la. ");
INSERT INTO spp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ka pi i u pyi: «Ɔɔn.» Ka Pilati si pi pyi: «Yii a sì ná u e, saanŋi Erɔdi yyére, ɲaha na yɛ uru u ɲyɛ Galile kùluni ɲùŋɔ na, ŋka u ɲyɛ Zheruzalɛmu kànhe e ɲcyii canmpyaagil'e.» ");
INSERT INTO spp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ɲyɛ pi à sà nɔ ná Yesu i saanŋi Erɔdi yyére ke, ka li i ntáan Erɔdi i sèl'e, ɲaha na yɛ u mpyi a Yesu kyaa lógo tèemɔni i, u la mpyi Yesu si kakyanhala kani là pyi uru ɲyii na. ");
INSERT INTO spp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Lire kurugo Erɔdi à yibiyi niɲyahaya pyi u na. Ŋka u ɲyɛ a yafyin jwo mɛ. ");
INSERT INTO spp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɲyɛ lir'à Kile sáragawwuubii ɲùŋufeebii ná Kile Saliyaŋi cyelentiibii mú ta pi à kàre wani Erɔdi yyére. Ka pire si wá na sêre Yesu na, maa kafinare shiŋi puni fini u na. ");
INSERT INTO spp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ka Erɔdi ná u sòrolashiibii si Yesu fwɔ́hɔrɔ maa u faha sèl'e. Maa vàanntinŋɛ nisinaŋa le u na, maa pi pyi pi à núr'a kàre ná u e Pilati yyére. ");
INSERT INTO spp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilati ná Erɔdi mpyi a bêni mɛ. Ŋka mà lwɔ́ kuru canŋke na, pi à pyi cevee. ");
INSERT INTO spp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pi à núr'a sà nɔ ná Yesu i Pilati yyére ke, ka Pilati si bínn'a tɛ̀ɛn ná Kile sáragawwuubii ɲùŋufeebii ná Yahutuubii yyaha yyére shiinbii ná Yahutuubii sanmpil'e, ");
INSERT INTO spp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","maa jwo: «Yii à pa ná ŋge nàŋi i naha mii yyére, maa jwo na u wá na sùpyire ɲùŋɔ kyánge. Ŋka mii à u yíbe yii puni ɲyii na, yaaga maha yaaga yii à jwo a taha u na ke, mii ɲyɛ a kuru kà zò ta u na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erɔdi mú sí ɲyɛ a tìgire cyaga ta u na mɛ, lire kurugo u à u núruŋ'a tùugo naha wuu á. Mii á, ŋge nàŋi kɔni ɲyɛ a kyaa pyi ndemu li sí n‑pa ná l'e u bò mɛ. ");
INSERT INTO spp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Lire kurugo mii sí na sòrolashiibii pyi, pi u bwɔ̀n si u cye yaha.»  ");
INSERT INTO spp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ɲyɛ yyee maha yyee, Yahutuubii bilereŋkwoŋi kataanni i, Pilati mpyi maha kàsujyiŋi wà cye yaha, lire na mpyi kalyee. ");
INSERT INTO spp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ka sùpyire puni si bínn'a jwo fànha na: «Ŋge nàŋi bò, maa Barabasi cye yaha!» ");
INSERT INTO spp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mà li ta, Barabasi mpyi a ɲyàhaŋguruguŋi wà pyi kànhe e, maa booro pyi, lire kurugo pi mpyi a u cû a tò kàsuŋi i. ");
INSERT INTO spp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilati la mpyi si Yesu cye yaha, lire e u à núr'a pi yíbe. ");
INSERT INTO spp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ka pi i sêe maa jwo: «U kwòro cige na! U kwòro cige na!» ");
INSERT INTO spp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ka Pilati si núr'a jwumpe lwɔ́ tontanrewogo maa jwo: «Kapiini ndire ŋge nàŋ'à sàa pyi bɛ? Mii nàha à ɲùŋɔ ta ŋkemu ku sí u pyi u bò mɛ. Lire e ke mii sí sòrolashiibii pyi pi u bwɔ̀n si u cye yaha.» ");
INSERT INTO spp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ka pi i núr'a sêe fànha na: «U kwòro cige na!» Ɲyɛ pi màhaŋ'à pa Pilati yyaha jà ke, ");
INSERT INTO spp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ka u u ɲɛɛ maa pi ɲyii wuuni pyi. ");
INSERT INTO spp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pi mpyi a Pilati ɲáare na u nàŋi ŋgemu cye yaha, mà li ta uru nàŋi mpyi a ɲyàhaŋguruguŋi ná boore pyi ke, ka Pilati sí uru cye yaha. Nde pi à cya u á Yesu kyaa na ke, maa lire pyi pi á. ");
INSERT INTO spp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mà sòrolashiibii yaha pi i ŋkɛ̀ɛge ná Yesu i taboŋke e, pi à círi ná nàŋi w'e u à yîri sige e, u mɛge mpyi Simɔ, Sirɛni kànhe shin u mpyi u wi. Ka pi i Yesu kworokworocige kárama a tɛ̀gɛ u ɲuŋ'i, maa u pyi u à taha Yesu fye e. ");
INSERT INTO spp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Supyikuruŋɔ nimbwɔhɔ mpyi a taha pi fye e na ŋkɛ̀ɛge mú. Cyeebii pìi na mpyi pi e, nàvunŋke mpyi a pire pyi pi i myahii súu Yesu kurugo. ");
INSERT INTO spp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ka Yesu si yyaha kɛ̂ɛnŋɛ maa pire cyeebii wíi maa jwo: «Zheruzalɛmu kànhe cyeebii, yii àha raa mɛɛ súu mii kurugo mɛ. Yii a mɛɛ súu yii ná yii pyìibii kurugo. ");
INSERT INTO spp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ɲaha kurugo yɛ cijiriɲyi yi ɲyɛ yi sàha pyìi si mà ɲya nta raa ŋko mà pyìi kan pi à ŋwɔr'a ɲya mɛ, tèni là na ma, sùpyire sí n‑pa raa ŋko, pire wuun'à ɲwɔ. ");
INSERT INTO spp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lire tèni i, sùpyire sí raa ŋko ɲaɲy'á “Yii cwo wuu ɲuŋ'i!” s'a ŋko mpògogil'á “Yii cɛɛg'à wuu ɲwɔ tò!” ");
INSERT INTO spp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ɲaha kurugo yɛ pi aha ɲcyii karigii shiŋi pyi cipuruge na, ɲaha pi sí n‑pyi cíwage na yɛ?» ");
INSERT INTO spp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pi mpyi na ŋkɛ̀ɛge ná kapimpyimii shuunni i si zà bò ná Yesu i mú. ");
INSERT INTO spp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɲyɛ pi à sà nɔ cyage k'e, pi maha kuru cyage mɛge pyi: «Ɲuŋkwɔɔge Cyage» maa Yesu ná pire kapimpyiibii shuunniŋi kwòro ciyi na wani. Wà mpyi u kàniŋke na, u sanŋi sí ɲyɛ u kàmɛni na. ");
INSERT INTO spp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ka Yesu si jwo: «Tufooŋi, yàfa pi na, ɲaha na yɛ nde pi à pyi ke, pi ɲyɛ a li kapii cè mɛ.» Lire kàntugo ka sòrolashiibii si ŋkyaanlwooni tɛ̀g'a u vàanɲyi táa piye na. ");
INSERT INTO spp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Shinɲyahara mpyi a yyére wani marii wíi. Ka Yahutuubii yyaha yyére shiinbii si wá na Yesu fwɔ́hɔre na: «U à sùpyire tà shwɔ, u uye shwɔ numɛ kɛ! Lire e wuu sí n‑sìi n‑cè na uru u ɲyɛ Kile Niɲcwɔnrɔŋi.» ");
INSERT INTO spp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ka sòrolashiibii mú si file u na ná lùtanhage e maa u fwɔ́hɔrɔ ");
INSERT INTO spp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","maa jwo: «Kampyi mu u ɲyɛ Yahutuubii saanŋi, maye shwɔ.» ");
INSERT INTO spp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pi mpyi a yi sém'a tàra Yesu kworokworocige nìɲyiŋi na na «YAHUTUUBII SAANŊI U ƝYƐ ŊGE.» ");
INSERT INTO spp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ɲyɛ kapimpyiibii pi mpyi a kwòro ná Yesu i ke, ka uru wà si u faha maa jwo: «Mu ɲyɛ a jwo na mu u ɲyɛ Kile Niɲcwɔnrɔŋi mà? Maye shwɔ, maa wuu shwɔ mú!» ");
INSERT INTO spp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ka kapimpyiŋi sanŋi si u shɛ̀rɛfooŋi cɛ̂ɛge maa jwo: «Mu ɲyɛ na fyáge Kile na mà? Ko kuru yyefuge ninuge e mu ná uru ɲyɛ! ");
INSERT INTO spp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wuu pi ke, ŋke yyefuge ɲyɛ wuu niɲcyaga, ɲaha na yɛ kapiini wuu à pyi ke, lire l'à ku nɔ wuu na. Ŋka ŋge nàŋi wi ke, u ɲyɛ a kapii pyi mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","U à puru jwo ke, maa Yesu ɲáare na: «Yesu, mu aha mpa ntɛ̀ɛn ma saanre tatɛɛnge e tèni ndemu i ke, ma a yákili yaha na na.» ");
INSERT INTO spp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ka Yesu si u pyi: «Sèeŋi na mii sí yi jwo mu á, niɲjaa mu sí n‑pyi ná mii i Arijinaŋi i.» ");
INSERT INTO spp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Canŋke mpyi a nɔ ɲùŋɔ niŋi i, ka numpini si mpâl'a jyè kìni cyeyi puni i, mà tère pyi fo mà nɔ canvyinge na. ");
INSERT INTO spp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Vàanŋke k'à tɛ̀g'a Kileɲaarebage táa mà pyi shuunni ke, ka kuru si ɲcwɔn niŋke e. ");
INSERT INTO spp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ka Yesu si jwo fànha na: «Tufooŋi, mii sí na múnaani yaha mu cye e!» U à yire jwo ke, ka u múnaani si fworo u e. ");
INSERT INTO spp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ɔrɔmu sòrolashiibii yyaha yyére shinŋi u mpyi wani tayyérege e ke, ur'à lire ɲya ke, ka u u Kile pêe maa jwo: «Sèeŋi na, ŋge nàŋi mpyi a tíi!» ");
INSERT INTO spp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sùpyire ti mpyi a pa cyire karigii tawiige e ke, ka pire puni nàvunŋɔ wuubii si núru na ŋkɛ̀ɛge pi pyɛnyi i maa myahigii súu. ");
INSERT INTO spp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu ceveebii ná cyeebii pi mpyi a taha Yesu fye e mà yîri Galile kùluni i ke, pire puni mpyi a yyére tatɔɔnge e, maa ɲcyii karigii wíi tapyige e. ");
INSERT INTO spp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yahutuubii kànhe mɛgɛ pi maha mpyi Arimati ke, nàŋi wà na mpyi na yîri kuru kànhe na, u mɛge na mpyi Yusufu. U mpyi Yahutuubii yukyaala kuruŋke e. Uru nàŋi na mpyi sùpya niɲcɛnŋɛ, maa ntíi. U sɔ̀nŋɔre mpyi a taha Kile Saanre tèepani na. Yukyaala kuruŋke shiinbii sanmpii mpyi a jwo a bɛ̂ kani ndemu na Yesu kyaa na maa li pyi ke, u ɲyɛ a ɲɛn'a jyè lire e mɛ. ");
INSERT INTO spp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Maa ŋkàr'a sà Yesu buwuŋi ɲáare Pilati á, si sà ntò. ");
INSERT INTO spp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilati à ɲɛɛ ke, ka Yusufu si ŋkàr'a sà Yesu buwuŋi tîrige kworokworocige na, maa u pwɔ vàanntoŋi w'e, mà sà ntò. Fanŋke e u à sà Yesu tò ke, kuru mpyi a tùgo kafaaga ɲuŋ'i, bu mpyi na sàha ŋkwɔ̀ a tò kur'e mà ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kuru canŋa nùmpanŋa mpyi na sí n‑pyi canŋɔŋke. ");
INSERT INTO spp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Cyeebii pi mpyi a Yesu tùug'a yîri fo Galile kùluni i mà pa ke, ka pire si ŋkàre ná Yusufu e fanŋke na si sà Yesu buwuŋi sínniŋkanni ɲya fanŋke funŋke e. ");
INSERT INTO spp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lire kàntugo ka pi i núr'a kàre pyɛngɛ, maa sà sìnmɛ nùguntanga wumɔ ná wusuna yaa mà yaha. Canŋɔŋk'à nɔ ke, mà tàanna ná Yahutuubii Saliyaŋi i, ka pi i ŋɔ̀. ");
INSERT INTO spp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cibilaage canɲcyiige ɲyɛ̀kwɔnge na, sìnmpe nùguntanga wumpe ná wusunaŋi pire cyeebii mpyi a yal'a yaha ke, ka pi i yire lwɔ́ na ŋkɛ̀ɛge fanŋke na. ");
INSERT INTO spp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kafaage ku mpyi a tɛ̀g'a fanŋke ɲwɔ tò ke, pi à sà nɔ wani ke, ka pi i sà kuru ta k'à kùuŋkul'a láha fanŋke ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ka pi i jyè fanŋke e maa wíi, ŋka pi ɲyɛ a Kafooŋi Yesu buwuŋi ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ka li i pi bilibili. Mà pi yaha pur'e, ka pi i mpâl'a nàmii shuunni ɲya pi à vàanvyinweeweere le mà yyére. ");
INSERT INTO spp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ka pire cyeebii fyagara wuubii si niŋkure sín maa yyahayi cyígile ɲìŋke na. Ka pire nàmpii shuunniŋi si jwo pi á: «Ɲaha na yii ɲyɛ na ɲyii shinŋi caa kwùubii shwɔhɔl'e yɛ? ");
INSERT INTO spp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","U ɲyɛ naha mɛ. U à ɲɛ̀ a fworo kwùŋi i. Jwumpe u mpyi a jwo yii á mà u yaha ná yii e Galile kùluni i ke, yii funŋɔ cwo puru na. ");
INSERT INTO spp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","U mpyi a jwo na “Fànha ki, Supyaŋi Jyaŋi u le kapimpyiibii cye e, pi i u kwòro cige na. U kwùŋi canmpyitanrewuuni, u sí ɲɛ̀ n‑fworo kwùŋi i.”» ");
INSERT INTO spp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pi à puru jwo a kwɔ̀ ke, ka cyeebii funɲyi si ɲcwo Yesu jwumpe niɲjwumpe na. ");
INSERT INTO spp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ka pi i yîri fanŋke na maa ŋkàr'a sà yi puni yyaha jwo cyelempyiibii kɛ ná niŋkinŋi ná pi shɛ̀rɛfeebii sanmpii pun'á. ");
INSERT INTO spp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Cyeebii pi mpyi a kàre fanŋke na ke, pire pi mpyi: Mariyama u mpyi na yîri Magidala kànhe e ke, uru ná Zhanɛ ná Yakuba nuŋi Mariyama mà bâra cyeebii piibɛrii na. Pire cyeebii pun'à yîri fanŋke na, maa mpa jwumpe ninumpe jwo Yesu tùnntunmpil'á. ");
INSERT INTO spp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ŋka pi mpyi na sɔ̂nŋi na ɲùŋɔ baa jwumɔ cyeebil'à jwo. Pi ɲyɛ a dá pu na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lire ná li wuuni mú i, ka Pyɛri si yîri maa fê a kàre fanŋke na, maa sà jâara a wíi ku funŋke e. Lempe kanni baare e, u ɲyɛ a yafyin ɲya mɛ. Ka li i u bilibili, ka u u núr'a kàre pyɛngɛ. ");
INSERT INTO spp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kuru canŋke ninuge e, Yesu fyèɲwɔhɔshiinbii pìi shuunni mpyi na ŋkɛ̀ɛge kànhe kà na, kuru kànhe mɛge na mpyi Emayusi. Ku ná Zheruzalɛmu kànhe laage mpyi a tòro culumɛtirii kɛ ná shuunni na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Karigii cyi mpyi a pyi lire tèni i ke, pi mpyi na cyire puni yu piy'á, na ŋkɛ̀ɛge. ");
INSERT INTO spp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mà pi yaha jwumpe na piye shwɔhɔl'e, ka Yesu yabiliŋi si file pi na, maa kuni bínni ná pi e. ");
INSERT INTO spp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pi mpyi na Yesu ɲaa, ŋka l'à pyi mu à jwo yaage kà k'à para pi yyaha na, mà pi pyi pi ɲyɛ a jà a u cè mɛ. ");
INSERT INTO spp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ka Yesu si pi yíbe: «Ɲaha shi yii na yu, na ŋkɛ̀ɛge amɛ yɛ?» Ka pi yyetanha wuubii si yyére. ");
INSERT INTO spp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ŋge mɛge ku mpyi pi e Kilopasi ke, ka uru si jwo: «Karigii cyi à pyi numɛ Zheruzalɛmu i ke, mu kanni baare e, sùpya ɲyɛ a sìi Zheruzalɛmu i cyi cèmbaa mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ka Yesu si pi yíbe: «Ɲaha shi k'à pyi yɛ?» Ka pi i u pyi: «Kile tùnntunŋi Yesu u mpyi a yîri Nazarɛti kànhe e, ná Kile mpyi a fànha le u jwumpe ná u kapyiiŋkil'e sùpyire ɲyii na ke, nde l'à u ta ke, lire kɛ! ");
INSERT INTO spp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wuu Kile sáragawwuubii ɲùŋufeebii ná wuu yyaha yyére shiinbil'à u le cye e, pi à u kwòro cige na a bò. ");
INSERT INTO spp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wuu mpyi na sɔ̂nŋi na uru u sí n‑pa Izirayɛli shiinbii ɲùŋɔ wwû bilere e. Ŋka u à kwû ke, cyi canmpyaa taanre u ɲyɛ ŋge. ");
INSERT INTO spp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Wuu kuruŋke e, cyeebii pìl'à pa jwumpe pà jwo wuu á, mpemu p'à sàa wuu bilibili sèe sèl'e ke. Ɲyɛ̀ge na, pi à sôl'a kàre u fanŋke na, ");
INSERT INTO spp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","maa mpa wuu pyi na pire ɲyɛ a sà u buwuŋi ta wani mɛ, na pir'à Kile mɛ̀lɛkɛɛbii pìi ɲya, ka pire mɛ̀lɛkɛɛbii si yi jwo pir'á na Yesu à ɲɛ̀ a fworo kwùŋi i. ");
INSERT INTO spp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bà cyeebil'à yi jwo wuu á mɛ, wuu shɛ̀rɛfeebii pìi mú à shà fanŋke na, mà sà yi ta amuni, ŋka pire mú ɲyɛ a u ɲya mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ka Yesu si pi pyi: «Yii yákili baafeebii, yii dama ɲyɛ a táan Kile tùnntunmpii jwumpe na mà dɛ! ");
INSERT INTO spp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Lire kyaalaŋkanni na, bà Kile Niɲcwɔnrɔŋi mpyi a yaa u kyaala u u nta a jyè Kile sìnampe e mà?» ");
INSERT INTO spp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lire kàntugo mà lwɔ́ Kile tùnntunŋi Musa sémɛbii na, mà sà nɔ fo Kile tùnntunmpii sanmpii puni sémɛbii na, jwumpe p'à sémɛ u kyaa na pire sémɛbil'e ke, ka u u puru yyaha jwo pi á. ");
INSERT INTO spp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kànhe na pi mpyi na ŋkɛ̀ɛge ke, pi à sà nɔ kuru na ke, ka Yesu si uye pyi mu à jwo u ko raa ntùuli s'a ŋkɛ̀ɛge yyaha yyére. ");
INSERT INTO spp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ka pi i u ɲáare na u àha ŋkàre mɛ, na numpilage na ŋko raa wwùu. Ka u u jyè pyɛnge e maa ntɛ̀ɛn wani ná pi e. ");
INSERT INTO spp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tèni i pi à pa ŋkwûulo s'a lyî ke, ka u u bwúuruŋi lwɔ́, maa fwù kan Kile á, maa u kwɔ̀n kwɔ̀n a kan pi á. ");
INSERT INTO spp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lir'à pyi ke, ka pi yákilibii si múgo, ka pi i ɲcè na Yesu wi. Lire kàntugo ka u u mpâl'a pînni pi na. ");
INSERT INTO spp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ka pi i wá na yi yu piy'á na: «Tèni i u mpyi na Kile Jwumpe Semɛŋi yyaha yu wuu á kuni na ke, wuu funɲyi mpyi a táan sèe sèl'e dɛ!» ");
INSERT INTO spp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ka pi i ntíl'a yîri, maa núr'a kàre Zheruzalɛmu kànhe e, mà sà cyelempyiibii sanmpii kɛ ná niŋkinŋi ná pi shɛ̀rɛfeebii ta pi à bínni. ");
INSERT INTO spp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ka pire cyelempyiibii si jwo pi á na Kafooŋi Yesu à ɲɛ̀ nàkaana baa, na Simɔ yabiliŋ'à u ɲya! ");
INSERT INTO spp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɲyɛ nde l'à mpii shiin shuunniŋi ta mà pi niŋkaribii yaha ke, ná pyiŋkanni na pi à Yesu cè, tèni i u à bwúuruŋi kwɔ̀n kwɔ̀n mà kan pi á ke, ka pi i yire puni yyaha jwo. ");
INSERT INTO spp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mà cyelempyiibii yaha puru jwumpe na, ka pi i mpâl'a Yesu niɲjyereŋi ɲya piye shwɔhɔl'e. Ka u u jwo: «Kile u yyeɲiŋke kan yii á.» ");
INSERT INTO spp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ka pi i fyá fo mà tatɛɛngɛ fô piye na, ɲaha na yɛ pi mpyi na sɔ̂nŋi na buŋi wà fwɔ̀ɔngɔ pir'à ɲya. ");
INSERT INTO spp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka Yesu si pi pyi: «Ɲaha na yii ɲyɛ na fyáge bɛ? Ɲaha k'à nte sɔ̀nŋɔre shiŋi tîrige yii funŋ'i yɛ? ");
INSERT INTO spp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yii na kantahigii ná na tooyi wíi, yii i ɲcè na mii wi. Yii bwɔ̀n na na a wíi, bufwɔɔngɔ ɲyɛ na mpyi ná cyere ná kaciiy'i mii fiige mɛ.» ");
INSERT INTO spp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mà u yaha puru jwumpe na, u à u kantahigii ná u tooyi cyêe pi na. ");
INSERT INTO spp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pi mpyi a dá Yesu ɲɛ̀ŋi na mɛ, ɲaha na yɛ u ɲɛ̀ŋi mpyi a pi funɲyi táan fo mà pi bilibili. Ka Yesu si pi yíbe: «Yalyige na wá naha yii á la?» ");
INSERT INTO spp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ka pi i fyafwɔgɔ kan u á. ");
INSERT INTO spp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ka u u ku shwɔ a kyà pi ɲyii na. ");
INSERT INTO spp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Maa jwo: «Tèni i mii mpyi ná yii e ke, mii à yi jwo yii á na yaaga maha yaaga k'à sémɛ mii kyaa na MusaSaliyaŋi ná Kile tùnntunmpii sanmpii sémɛbii ná Zaburu sémɛŋi i ke, cyire pun'à yaa cyi tòro cyi jwuŋkanni na.» ");
INSERT INTO spp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ɲyɛ u à yire jwo ke, maa pi yákilibii múgo, bà pi si mpyi si Kile Jwumpe Semɛŋi ɲwɔhe cè mɛ. ");
INSERT INTO spp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Maa núr'à jwo pi á: «L'à sémɛ amuni na Kile Niɲcwɔnrɔŋi sí n‑kyérege n‑bò, ŋka u kwùŋi canntanrawoge u sí ɲɛ̀. ");
INSERT INTO spp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na mà lwɔ́ Zheruzalɛmu kànhe na, Jwumpe Nintanmpe sí n‑jwo u mɛge na supyishiŋi pun'á, na pi pi toroŋkanni kɛ̂ɛnŋɛ pi i láha kapegigii na, bà Kile si mpyi si cyi yàfa pi na mɛ. ");
INSERT INTO spp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɲyɛ kyaa maha kyaa mii à pyi ke, yii à cyire puni ɲya tapyige e, yii a cyi yu yii a mâre. ");
INSERT INTO spp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yii tɛ̀ɛn Zheruzalɛmu i, mii Tuŋi Kile à sífente ntemu ɲwɔmɛɛ lwɔ́ ke, fo mii aha tire tîrige yii ɲuŋ'i tèni ndemu i ke.» ");
INSERT INTO spp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lire kàntugo ka Yesu si ŋkàre ná u cyelempyiibil'e Bɛtani kànhe taan. Pi à sà nɔ wani ke, ka u u u cyeyi yîrige, maa jwó le pi á. ");
INSERT INTO spp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mà u yaha u u dùbabii leni pi á, u à kò a yîri pi shwɔhɔl'e mà kàre nìɲyiŋi na. ");
INSERT INTO spp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ka cyelempyiibii si wá na u kêre. Pi à kwɔ̀ ke, ka pi funntanga wuubii si núr'a kàre Zheruzalɛmu kànhe e. ");
INSERT INTO spp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Canŋa maha canŋa pi mpyi maha piye bínnini Kileɲaarebage e, marii Kile kêre. ");
INSERT INTO spp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mà jwo diɲyɛŋi u sìi ke, Jwumpe mpyi wani mà mɔ. Pu mpyi ná Kile e. Puru Jwumpe pu mpyi Kile yabiliŋi. ");
INSERT INTO spp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ŋge u ɲyɛ puru Jwumpe ke, u mpyi wani ná Kile e, mà jwo diɲyɛŋi u sìi ke. ");
INSERT INTO spp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Uru cye kurugo Kile à yaayi puni dá. Yaaga maha yaaga k'à dá ke, kuru kà ɲyɛ a dá u baa mɛ. ");
INSERT INTO spp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ur'e shìŋi niŋkwombaaŋ'à fworo, uru u maha bɛ̀ɛnmpe kaan sùpyir'á. ");
INSERT INTO spp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Puru bɛ̀ɛnmpe na ɲî numpini i, ŋka numpini ɲyɛ a jà pu na mɛ. ");
INSERT INTO spp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tèni là à pa nɔ, ka Kile si nàŋi wà pyi u tùnntunŋɔ, u mɛge na mpyi Yuhana. ");
INSERT INTO spp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","U à pa mpa a bɛ̀ɛnmpe kyaa yu, bà sùpyire puni si mpyi si dá pu na u jwumpe cye kurugo mɛ. ");
INSERT INTO spp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Uru yabiliŋi bà u mpyi puru bɛ̀ɛnmpe mɛ, u mpyi a pa si mpa pu kyaa jwo kanna. ");
INSERT INTO spp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ŋge u mpyi bɛ̀ɛnmpe sèesee wumpe ke, ur'à pa diɲyɛŋi i mpa bɛ̀ɛnmpe kan sùpyir'á. ");
INSERT INTO spp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","U mpyi diɲyɛŋi i, diɲyɛŋ'à dá u cye kurugo, lire ná li wuuni mú i, diɲyɛŋi sùpyir'à u cyé. ");
INSERT INTO spp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","U à pa u yabiliŋi shiinbii yyére, pi ɲyɛ a ɲɛɛ u na mɛ. ");
INSERT INTO spp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ŋka mpii pi à ɲɛɛ u na maa dá u mɛge na ke, u à kuni kan pire pun'á pi pyi Kile pyìi. ");
INSERT INTO spp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pi ɲyɛ a Kile pyìfente ta sùpyire woore taŋkanni na mɛ. Pi ɲyɛ a ta nɔ ná u cwo pyìi taŋkanni na mɛ. Sùpya ɲyii kyaa bà l'à pi pyi amuni mɛ. Ŋka Kile yabiliŋi u à ɲɛɛ maa pi pyi u pyìi. ");
INSERT INTO spp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ɲyɛ puru Jwumpe à pa mpyi sùpya, maa ntɛ̀ɛn wuu shwɔhɔl'e mà tère pyi. Wuu à u pèente ɲya. Uru u ɲyɛ Jyafooŋi niŋkinŋi mà fworo Tufooŋi Kile e ke, ur'e tire pèente ɲyɛ. Uru u à ɲwɔ wuu na sèl'e, maa sèeŋi cyêe wuu na. ");
INSERT INTO spp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ɲyɛ Yuhana à Yesu kyaa jwo. U à jwo fànha na: «Ŋge kyaa mii mpyi a jwo na u sí n‑kwɔ̀ n‑pa mii kàntugo ke, ur'à fànha tò mii na, ɲaha na yɛ mà jwo mii u si ke, u mpyi wani mà kwɔ̀.» ");
INSERT INTO spp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","U à ɲwɔ wuu na sèl'e maa kacɛnni là tɛ̀g'a kacɛnni là fûnŋɔ wuu á. ");
INSERT INTO spp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yii li cè, Kile mpyi a u Saliyaŋi kan Musa cye kurugo, numɛ u à ɲwɔ wuu na maa sèeŋi cyêe wuu na Yesu Kirisita cye kurugo. ");
INSERT INTO spp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sùpya sàha ŋkwɔ̀ a Kile ɲya a ɲya mɛ. Ŋka Jyafooŋi niŋkinŋi u ɲyɛ Kile yabiliŋi, maa mpyi Tufooŋi Kile taan ke, uru u à Kile pyiŋkanni cyêe wuu na. ");
INSERT INTO spp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ɲyɛ Yahutuubii ɲùŋufeebil'à sáragawwuubii pìi ná Levi tùluge shiinbii pìi yîrige Zheruzalɛmu kànhe e mà tun Yuhana á, pi sà u yíbe na jofoo u ɲyɛ u wi yɛ? ");
INSERT INTO spp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pi à u yíbe ke, u ɲyɛ a yaaga ŋwɔhɔ pi na mɛ, u à tíl'a jwo pi á: «Mii bà u ɲyɛ Kile Niɲcwɔnrɔŋi mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ka pi i u yíbe: «Jofoo sí u ɲyɛ mu yɛ? Mu u ɲyɛ Kile tùnntunŋiEli la?» Ka Yuhana si pi pyi: «Ɔnhɔ, uru bà u ɲyɛ mii mɛ.» Ka pi i núr'a u pyi: «Kile tùnntunŋi wuu na sigili ke, uru u ɲyɛ mu la?» Ka u u núr'a jwo: «Ɔnhɔ.» ");
INSERT INTO spp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ka pi i ŋkànha a jwo: «Jofoo sí u ɲyɛ mu yɛ? Yà jwo wuu á, wuu sà jwo wuu tunveebil'á. Jofoo mu yabiliŋi na maye sɔ̂nŋi yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ka Yuhana si pi ɲwɔ shwɔ ná Kile tùnntunŋi Ezayi ɲwɔjwumpe e na: «Mɛjwul'à fworo síwage e fànha na “Yii kuro nintiile yal'a yaha Kafooŋi mɛɛ na.” Ɲyɛ mii Yuhana u ɲyɛ ná lire mɛjwuuni i.» ");
INSERT INTO spp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sùpyire ti mpyi a tun Yuhana yyére ke, Farizhɛɛnbii pìi na mpyi ná pi e. ");
INSERT INTO spp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ka pire si núr'a u yíbe: «Mu bà u ɲyɛ Kile Niɲcwɔnrɔŋi mɛ, mu ɲyɛ Eli mɛ, mu sí ɲyɛ Kile tùnntunŋi nizigiŋi mɛ, ka ɲaha si mu ta mu u sùpyire batizeli yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ka Yuhana si pi pyi: «Mii na sùpyire batizeli lwɔhe e kanna. Yii shwɔhɔl'e, nàŋi wà na ɲyɛ wani, yii ɲyɛ a u cè mɛ, ");
INSERT INTO spp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","uru sí n‑pa mii kàntugo, ŋka mii ɲùŋk'à cyɛ́rɛ u tanhaɲyi mɛɛre zànhaŋi i u tooyi na.» ");
INSERT INTO spp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Cyire karigil'à pyi Bɛtani kànhe e, Zhurudɛn baŋi kàntugo. Kuru cyage e, Yuhana mpyi na sùpyire batizeli. ");
INSERT INTO spp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kuru canŋa nùmpanŋa, Yuhana à Yesu ɲya u u sì u yyére ke, maa jwo sùpyir'á: «Yii wíi, Kile Mpabilini li ɲyɛ nde, lire li sí n‑pa diɲyɛ sùpyire kapegigii yàfa ti na. ");
INSERT INTO spp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uru kyaa mii mpyi a fyânha a jwo yii á, tèni i mii à jwo “Nàŋi wà na ma mii kàntugo, ŋka u à pêe mii na, maa mpyi mii yyaha na, ɲaha na yɛ mii à si mà u ta.” ");
INSERT INTO spp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mii yabiliŋi mpyi a cè na uru wi mɛ. Ŋka mii à pa mpa a sùpyire batizeli lwɔhe e, bà Izirayɛli shiinbii si mpyi si u cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Puru kàntugo, mpe Yuhana à jwo: «Mii à Kile Munaani ɲya l'à yîri nìɲyiŋi na mpánmpɔrɔgɔ fiige, mà pa ntɛ̀ɛn Yesu na. ");
INSERT INTO spp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mii yabiliŋi mpyi a u cè mɛ. Ŋka ŋge u à mii tun mii u pa a sùpyire batizeli lwɔhe e ke, uru u à yi jwo mii á na mii aha bú Kile Munaani ɲya l'à tîg'a pa ntɛ̀ɛn ŋgemu na ke, uru u sí raa sùpyire batizeli ná Kile Munaani i. ");
INSERT INTO spp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mii à li ɲya li jwuŋkanni na. Lire e mii à jwo sùpyir'á na “Ŋge nàŋi u ɲyɛ Kile Jyaŋi.”» ");
INSERT INTO spp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kuru canŋa nùmpanŋa, Yuhana mpyi a yyére wani ná u cyelempyiibii pìi shuunni i. ");
INSERT INTO spp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ka u u Yesu nintoroŋi wíi, maa jwo: «Yii wíi, Kile Mpabilini li ɲyɛ nde!» ");
INSERT INTO spp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yuhana cyelempyiibii mpii shuunniŋ'à puru jwumpe lógo ke, maa ntaha Yesu fye e. ");
INSERT INTO spp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu à yyahe kɛ̂ɛnŋ'a wíl'a pi ɲya pi à taha uru fye e ke, maa pi yíbe: «Ɲaha yii na ɲcaa yɛ?» Ka pi i u pyi: «Arabi (lire ɲwɔhe ku ɲyɛ cyelentuŋi) taa mu à tîrige ke?» ");
INSERT INTO spp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ka u u pi pyi: «Yii a ma, yii sí ku ɲya.» Ka pi i ŋkàre ná u e, maa sà pyɛnge ɲya, maa ntɛ̀ɛn wani. Canvyinge tèni li mpyi li li, ka pi i canmpaange pyi ná u e. ");
INSERT INTO spp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mpii nàmbaabii shuunniŋi pi mpyi a Yuhana jwumpe lógo, maa ntaha Yesu fye e ke, pire wà mɛge na mpyi Andire, Simɔ Pyɛri sìɲɛɛŋi. ");
INSERT INTO spp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ka Andire si ntíl'a kàr'a sà u sìɲɛɛŋi Simɔ cya a ɲya, maa yi jwo u á: «Wuu à Masiyaŋi ɲya.» (Lire ɲwɔhe ku ɲyɛ Kile Niɲcwɔnrɔŋi.) ");
INSERT INTO spp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Maa ntíl'a tòro Simɔ yyaha na mà kàre Yesu yyére. Pi à sà nɔ u na ke, ka Yesu si wá na Simɔ wíi maa ŋkwɔ̀ a jwo: «Mu u ɲyɛ Simɔ, Yuhana jyaŋi, pi sí n‑pa a mu yiri Sefasi.» (Girɛkiibii shɛɛnre e, pi maha jwo: «Pyɛri».) ");
INSERT INTO spp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kuru canŋa nùmpanŋa, ka Yesu si yîri na ŋkɛ̀ɛge Galile kùluni i, mà bɛ̂ ná Filipi i, maa u pyi: «Taha na fye e!» ");
INSERT INTO spp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi na mpyi Bɛtisayida kànhe shin. Andire ná Pyɛri kànhe ku ɲyɛ kuru mú. ");
INSERT INTO spp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi à sà Natanayɛli ɲya ke, maa u pyi: «Nàŋi kyaa Kile tùnntunŋi Musa à jwo u Saliyaŋi sémɛŋi i, ná Kile tùnntunmpii sanmpii mú à u kyaa jwo ke, wuu à u ɲya. U à yîri Nazarɛti kànhe e, u mɛge ɲyɛ Yesu, Yusufu jyaŋi.» ");
INSERT INTO spp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ka Natanayɛli si jwo: «Yacɛnŋɛ sí n‑sìi n‑jà n‑fworo Nazarɛti i la?» Ka Filipi si u pyi: «Ta ma wuu u shà, mu yabiliŋi sí n‑sà ɲya.» ");
INSERT INTO spp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu à Natanayɛli ɲya u u sì u á ke, maa jwo: «Ŋge à sìi Izirayɛli shinŋi yabiliŋi, ɲaha na yɛ u funŋk'à sàa fíniŋɛ.» ");
INSERT INTO spp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ka Natanayɛli si jwo: «Taa mu à mii cè ke?» Ka Yesu si u pyi: «Mii mpyi a mu ɲya fizhiye cige ɲwɔh'i, maa mu cè, ka Filipi si nta a mu yyere.» ");
INSERT INTO spp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ka Natanayɛli si jwo: «Cyelentuŋi, Kile Jyaŋi u ɲyɛ mu, Izirayɛli Saanŋi.» ");
INSERT INTO spp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ka Yesu si u pyi: «Bà mii à mu pyi na mii à mu ɲya fizhiye cige ɲwɔh'i mɛ, lire kanni kurugo mu à dá mii na la? Mu sí n‑pa karigii cyiibɛrɛ ɲya ɲcyiimu cyi à pêe nintoroni na ke!» ");
INSERT INTO spp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Maa núr'a jwo: «Sèeŋi na mii sí n‑sìi yi jwo yii á, canŋka yii sí n‑kwɔ̀ nìɲyiŋi ɲya u à múgo, si Kile mɛ̀lɛkɛɛbii ɲya pi i dùru na ntîri Supyaŋi Jyaŋi ɲuŋ'i.» ");
INSERT INTO spp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ɲyɛ canmpyaa shuunn'à tòro, ka pi i wá na cikwɔnrɔ pyi Kana kànhe e, Galile kùluni i. Yesu nuŋi na mpyi wani tire cikwɔɔnre cyage e. ");
INSERT INTO spp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu ná u cyelempyiibii mpyi a yyere wani. ");
INSERT INTO spp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ɲyɛ mà pi yaha cikwɔɔnre múguroŋi na, ka ɛrɛzɛn sinmpe si mpa ŋkùuŋɔ. Ka Yesu nuŋi si yi jwo u á: «Pi sinmp'à kwɔ̀.» ");
INSERT INTO spp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ka Yesu si u pyi: «Nufooŋi, mii à mu ɲáare, ma hà ma ɲwɔge le na karigil'e mɛ. Tèni sàha ŋkwɔ̀ a nɔ mii á mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ɲyɛ ka u nuŋi si yi jwo báarapyiibil'á: «U aha mpa kyaa maha kyaa jwo yii á ke, yii i lire pyi.» ");
INSERT INTO spp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lir'à cwoyo baani ta wani. Yahutuubii mpyi maha piye jyíi na fíniŋɛ ná yire cwoyi lwɔhe e, mà tàanna ná pi Kile kuni i. Lwɔhe litirii ŋkuu (100) fiige mpyi maha jyè yire cwoyi niŋkin niŋkinŋi i. ");
INSERT INTO spp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ka Yesu si báarapyiibii pyi: «Yii ɲje cwoyi ɲî ɲî lwɔhe na.» Ka pi i yi ɲî fo mà nɔ yi ɲwɔyi na. ");
INSERT INTO spp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lire kàntugo ka Yesu si pi pyi: «Yii kà kwó numɛ, yii sà ŋkan cikwɔɔnre ɲjyìŋi táafooŋ'á.» Ka pi i sà kà kan u á. ");
INSERT INTO spp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ka ɲjyìŋi táafooŋi si lwɔhe bya a wíi, mà ku ta ɛrɛzɛn sinmɛ, u sí ɲyɛ a pu tayirige cè mɛ. Ŋka báarapyiibii pi mpyi a lwɔhe kwó ke, pire mpyi a pu tayirige cè. Ka u u ntíl'a cifɔnŋi pooŋi yyere, ");
INSERT INTO spp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","maa yi jwo u á: «Sùpyire puni maha fyânha a ɛrɛzɛn sinmpe nintanmpe kan pu byafeebil'á, pi aha niɲyahama bya, mpe pu ɲyɛ pu ɲyɛ a táan amuni mɛ, puru maha nta a kan pi á. Ŋka mu wi ke, ɛrɛzɛn sinmpe nintanmpe mu à yaha kàntugo!» ");
INSERT INTO spp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ɲyɛ lire l'à pyi kyaa niɲcyiile, mà li cyêe na Yesu na ɲyɛ kakyanhala sùpya. Lir'à pyi Kana kànhe e, Galile kùluni i. Lire pyiŋkanni na, Yesu à u sífente cyêe sùpyire na, ka u cyelempyiibii si dá u na. ");
INSERT INTO spp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lire kàntugo Yesu ná u nuŋi ná u cìnmpyiibii ná u cyelempyiibil'à kàre Kapɛrɛnamu kànhe e. Pi ɲyɛ a mɔ wani mɛ. ");
INSERT INTO spp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ɲyɛ Yahutuubii bilereŋkwoŋi kataanni mpyi a byanhara. Ka Yesu si ŋkàre Zheruzalɛmu kànhe e, ");
INSERT INTO spp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","mà sà sùpyire ta ti i nìiyɛ ná mpàa ná kùmpanhii pɛ́rɛli Kileɲaarebage ntàani na, wyɛ́rɛfaabii nintɛɛnbii na mpyi wani mú. ");
INSERT INTO spp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ka u u mɛɛrɛ pyi kàsoro mà tɛ̀g'a pi puni kɔ̀r'a yige Kileɲaarebage ntàani na, maa pi mpàabii ná pi nìiyi kɔ̀rɔ, maa wyɛ́rɛfaabii wyɛ́rɛŋi lwɔ́ a wu, maa pi tàbalibii ŋɔɔŋ'a cyán cyán. ");
INSERT INTO spp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Maa jwo sanmpanmpɛrɛbil'á: «Yii ɲje yaayi lwɔ́ a yige naha, yii àha na Tuŋi bage kɛ̂ɛnŋɛ mpyi yapɛrɛmbaga mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesu à lire pyi ke, ka u cyelempyiibii funŋɔ si ɲcwo li na na l'à sémɛ Kile Jwumpe Semɛŋi i na: «Mu bage kani na mii súuge naŋkyaan fiige.» ");
INSERT INTO spp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ka Yahutuubii ɲùŋufeebii si Yesu yíbe: «Kakyanhala kani ndi mu sí n‑pyi n‑cyêe wuu na, wuu u ɲcè na ɲcyii karigii puni mpyiŋi kun'à kan mu á yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ka Yesu si pi pyi: «Yii ŋke Kileɲaarebage jya, mii sí ku núruŋɔ n‑faanra canmpyaa taanre funŋ'i!» ");
INSERT INTO spp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ka pi i jwo: «Ei! Pi à yyee beeshuunni ná baani pyi ŋke Kileɲaarebage vaanraŋi na. Jofoo niŋkin u ɲyɛ mu, si ŋkwɔ̀ mpa ku faanra ŋkwɔ̀ canmpyaa taanre funŋ'i yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ŋka Kileɲaarebage kani Yesu à jwo ke, u yabiliŋi cyeere kyaa u mpyi na yu. ");
INSERT INTO spp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ɲyɛ Yesu à pa ɲɛ̀ a fworo kwùŋi i ke, ka li i ntîge u cyelempyiibii funŋ'i na Yesu mpyi a ŋke cyage jwo. Ka pi i dá Kile Jwumpe Semɛŋi ná Yesu ɲwɔjwumpe na. ");
INSERT INTO spp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tèni i Yesu mpyi Zheruzalɛmu i Yahutuubii bilereŋkwoŋi kataanni na ke, shinɲyahara à u kakyanhala karigii ɲya, ka cyire si pi pyi pi à dá u na. ");
INSERT INTO spp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu mpyi a pi puni zòompii cè, lire kurugo u mpyi a dá pi na mɛ. ");
INSERT INTO spp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","U à shin maha shin funŋɔ kani cè, lire kurugo ɲùŋɔ sàha mpyi sùpya u à u supyiɲɛɛŋi yu u á mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farizhɛnŋi wà na mpyi wani, u mɛge na mpyi Nikodɛmu, maa mpyi Yahutuubii ɲùŋufoo. ");
INSERT INTO spp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Canŋka numpilage e, u à kàre Yesu á maa sà yi jwo u á: «Cyelentuŋi, wuu à li cè na Kile à mu yaha a pa, mu u mpa a wuu kâlali, ɲaha na yɛ kakyanhala karigii mu na mpyi ke, wà sì n‑jà cyire pyi ná Kile ɲyɛ a sìi ná urufol'e mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ka Yesu si u pyi: «Sèeŋi na mii sí n‑sìi yi jwo mu á, sùpya sì n‑jà n‑jyè Kile Saanre e, ná u ɲyɛ a núr'a si nìɲyiŋi na mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ka Nikodɛmu si jwo: «Sùpya ká lyɛ a kwɔ̀, di u sí núru n‑si sahaŋki yɛ? Wà sí n‑jà núru u nuŋi funŋke e si si la?» ");
INSERT INTO spp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ka Yesu si u pyi: «Sèeŋi na mii sí n‑sìi yi jwo mu á, shin maha shin ká mpyi u ɲyɛ a si lwɔhe ná Kile Munaani fànhe e mɛ, uru sì n‑sìi n‑jà n‑jyè Kile Saanre e mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ŋgemu ká si sùpyii siŋkanna na ke, urufoo na ɲyɛ shintiiwe, ŋka ŋgemu ká si Kile Munaani síŋi i ke, Kile Munaani na ɲyɛ urufol'e. ");
INSERT INTO spp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mii à jwo na yii núr'a si nìɲyiŋi na ke, lire kà ma kàkyanhala mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Cyage k'à táan kafɛɛg'á ke, wani ku maha fwu na ŋkɛ̀ɛge, mu maha ku fwɔfwɔ tùnmpe núru. Ŋka mu sì ku tayirige cè mɛ, mu mú sì ku takarege cè mɛ. Amuni Kile Munaani maha mpyi sùpyaŋi i.» ");
INSERT INTO spp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ka Nikodɛmu si jwo: «Di cyire karigii sí n‑jà n‑pyi n‑jwo yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ka Yesu si u pyi: «Mu u ɲyɛ Izirayɛli shiinbii cyelentu ke, mu yabiliŋi saha ɲyɛ cyire karigii ɲcèmbaa la? ");
INSERT INTO spp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sèeŋi na mii sí n‑sìi yi jwo mu á, ɲje wuu à cè ke, yire wuu na yu. Ɲje wuu à ɲya ke, yire wuu na yu mú. Ŋka yii la ɲyɛ sì ɲɛɛ wuu niɲjwumpe na mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mii na ɲìŋke karigii kyaa yu yii á, yii sí ɲyɛ a dá mɛ, mii aha bú mpa a nìɲyiŋi wogigii kyaa yu yii á, di yii sí n‑jà n‑dá n‑jwo yɛ? ");
INSERT INTO spp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mà li ta wà ɲyɛ a dùgo nìɲyiŋi na mɛ, fo ŋge u à yîri wani mà tîge naha ɲìŋke na ke, uru u ɲyɛ Supyaŋi Jyaŋi. ");
INSERT INTO spp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bà Kile tùnntunŋiMusa à dàɲyɛŋi yal'a pyi wwò fiige, maa cyiin cûru, maa u dùrugo sùpyire shwɔhɔl'e mɛ, amuni Supyaŋi Jyaŋi sí n‑sìi n‑dùrugo, ");
INSERT INTO spp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bà li si mpyi ŋgemu ká dá u na ke, uru si shìŋi niŋkwombaaŋi ta mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kile à sàa diɲyɛ sùpyire kyaa táan uy'á fo u à u Jyaŋi niŋkinŋi kan sáraga, ŋgemu ká dá u na ke, urufoo nùmpanŋke kà ŋkɛ̀ɛge mɛ, ŋka u shìŋi niŋkwombaaŋi ta. ");
INSERT INTO spp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kile ɲyɛ a u Jyaŋi tun diɲyɛŋi i u pa yoge kwɔ̀n sùpyire na mɛ. Ŋka u à u tun, bà sùpyire si mpyi si shwɔ u cye kurugo mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ŋgemu ká dá u na ke, uru nàzhan ɲyɛ Kile yoge e mɛ. Ŋgemu sí u ɲyɛ u ɲyɛ a dá u na mɛ, yog'à kwɔ̀n urufoo na mà kwɔ̀, ɲaha na yɛ u ɲyɛ a dá Kile Jyaŋi niŋkinŋi mɛge na mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kile yoge ɲùŋke ku ɲyɛ: bɛ̀ɛnmp'à pa diɲyɛŋi i, ka sùpyire si ɲcyé pu na, maa ntaha numpini fye e, ɲaha na yɛ pi kapyiiŋkii ɲyɛ a ɲwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Shin maha shin u na kapegigii pyi ke, bɛ̀ɛnmpe ɲyɛ a táan urufol'á mɛ. U ɲyɛ na ɲɛɛg'a fworo bɛ̀ɛnmpe na, sùpyire s'a u kapyiiŋkii ɲaa mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ŋka ŋgemu ká mpyi sèeŋi ɲuŋ'i ke, uru maha fworo bɛ̀ɛnmpe na, bà sùpyire si mpyi s'a u kapyiiŋkii ɲaa, si ɲcè na u na ɲyɛ Kile kuni i mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lire kàntugo ka Yesu ná u cyelempyiibii si ŋkàre Zhude kùluni i. U à tɛ̀ɛn wani ná pi e mà canmpyaa pyi, marii sùpyire batizeli. ");
INSERT INTO spp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yuhana mú mpyi na sùpyire batizeli cyage k'e, ɲaha na yɛ lwɔhe mpyi a ɲyaha wani. Kuru cyage mɛge mpyi Enɔni, maa mpyi Salɛmi taan. Ka sùpyire si wá na sì u yyére, u sí i ti batizeli. ");
INSERT INTO spp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Lir'à pyi a Yuhana ta u sàha jyè kàsuŋi i mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Canŋka Yuhana cyelempyiibii pìi ná Yahutuŋi wà à nàkaana ta. Tire mpyi a lwɔ́ a pwɔ Yahutuubii Kile kuni ɲjyìviniŋi kyaa na. ");
INSERT INTO spp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tire nàkaante ɲùŋɔ taan, Yuhana cyelempyiibil'à kàr'a sà yi jwo u á: «Wuu cyelentuŋi, mu ná nàŋi u mpyi siɲcyan Zhurudɛn baŋi kùŋke na ke, mu à ŋgemu kyaa jwo ke, u we, u u sùpyire batizeli numɛ. Sùpyire puni mú si wá na ŋkɛ̀ɛge u yyére.» ");
INSERT INTO spp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ka Yuhana si pi pyi: «Kile ká mpyi u ɲyɛ a ndemu le sùpyaŋi i mɛ, u ɲyɛ na lire taa mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yii yabilimpii na ɲyɛ mii shérii, mii à yi jwo yii á na mii bà u ɲyɛ Kile Niɲcwɔnrɔŋi mɛ, ŋka Kile à mii yaha a pa u yyaha na. ");
INSERT INTO spp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cikwɔɔnre tèepyiini i, cipooŋi ká jwo na uru ná u cifɔnŋ'à bɛ̂, u cevooŋi funŋke maha ntáan sèl'e. Amuni, mii funŋke puni mú maha ntáan, tère o tère e mii à lógo na sùpyire niɲyahara wá a taha Yesu fye e ke. ");
INSERT INTO spp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Numɛ, là à yaa l'a bârali Yesu tayyérege na, là s'a fwore mii woge e, ");
INSERT INTO spp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ɲaha na yɛ ŋge u à yîri nìɲyiŋi na mà pa ke, uru u ɲyɛ sùpyire puni ɲùŋɔ na. Ŋge u à ta naha ɲìŋke na ke, uru na ɲyɛ ɲìŋke wu, ɲìŋke karigii uru mú sí raa yu. Ŋka ŋge u à yîri nìɲyiŋi na ke, uru u ɲyɛ diɲyɛŋi puni ɲùŋɔ na. ");
INSERT INTO spp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nde u à ɲya, ná nde u à lógo ke, lire u na yu, shinɲyahara sí ɲyɛ a ɲɛɛ u jwumpe na mɛ. ");
INSERT INTO spp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ŋka ŋgemu ká ɲɛɛ u jwumpe na ke, urufol'à li fíniŋ'a cyêe na ur'à dá li na na Kile na sèeŋi yu. ");
INSERT INTO spp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ŋge Kile à tun ke, Kile Munaani à kan ur'á tɛgɛlɛ baa, lire e u à jà na Kile jwumpe yu sùpyir'á. ");
INSERT INTO spp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jyafooŋi kyal'à táan Tufooŋi á, fo ka u u yaayi puni le u cye e. ");
INSERT INTO spp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ŋgemu ká dá Jyafooŋi na ke, urufol'à shìŋi niŋkwombaaŋi ta. Ŋgemu ká ɲcyé u na ke, urufoo sì uru shìŋi niŋkwombaaŋi ta mɛ, ŋka Kile lùuni sí n‑yîri n‑yaha urufoo taan.» ");
INSERT INTO spp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu à pa ɲcè na Farizhɛɛnbil'à pa lógo na uru na cyelempyiibii pìi taa na batizeli, pi mú s'à ɲyaha Yuhana wuubii na. ");
INSERT INTO spp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mà sèeŋi jwo, Yesu yabiliŋi bà u mpyi na sùpyire batizeli mɛ, u cyelempyiibii pi mpyi na li pyi. ");
INSERT INTO spp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu à pa pi jwumpe niɲjwumpe lógo ke, maa fworo Zhude kùluni i maa núru na ŋkɛ̀ɛge Galile wuuni i. ");
INSERT INTO spp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","U niŋkareŋi mpyi a yaa u Samari kùluni jyiile, u u nta a nɔ Galile wuuni na. ");
INSERT INTO spp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ka u u sà nɔ Samari kànhe kà na, kuru mɛge mpyi Sikari. Tèecyiini i, Yahutuubii tulyage Yakuba mpyi a kɛrɛge ŋkemu kan u jyaŋi Yusufu á ke, Sikari na ɲyɛ kuru taan. ");
INSERT INTO spp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakuba bɛ̀ɛnŋke na mpyi wani. Yesu à ɲaara a kànha ke, maa sà ntɛ̀ɛn kuru bɛ̀ɛnŋke taan. Canŋke mpyi a nɔ ɲùŋɔ niŋi i. ");
INSERT INTO spp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ka Samari shiinbii cwoŋi wà si mpa mpa lwɔhɔ kwó. Ka Yesu si jwo u á: «Lwɔhe kà kan na á, si bya.» ");
INSERT INTO spp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Lir'à u cyelempyiibii ta pi à jyè kànhe e si ɲjyì cya zhwɔ. ");
INSERT INTO spp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ka ceeŋi si u pyi: «Na ɲaha? Mu na ɲyɛ Yahutu, mii sí ɲyɛ Samari shin, ɲaha na mu na ma lùbyage ɲáare mii á yɛ?» (Lire kajwuuni ɲùŋke ku ɲyɛ Yahutuubii ná Samari shiinbii ɲyɛ a mpyi na wwùu kyaa na mɛ.) ");
INSERT INTO spp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ka Yesu si ceeŋi pyi: «Yaage Kile maha ŋkaan mana ke, kàmpyi mu mpyi a kuru cè, sùpyaŋi u na mu ɲáare lùbyage na ke, kàmpyi mu mpyi a uru cè, mu u mpyi na sí u ɲáare, u mpyi na sí lwɔhɔ kan mu á, ŋkemu ku maha shìŋi sèe wuŋi kan sùpyaŋ'á ke.» ");
INSERT INTO spp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ka ceeŋi si jwo Yesu á: «Ɲùŋufooŋi, bɛ̀ɛnɲcere ɲyɛ mu á mɛ, ŋke bɛ̀ɛnŋke s'à cûgo sèl'e, taa mu sí kuru lwɔhe ta si ŋkan mii á ke? ");
INSERT INTO spp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wuu tulyage Yakuba u à ŋke bɛ̀ɛnŋke kan wuu á ke, mu à pêe uru na la? U ná u pyìibii ná u yatɔɔre mpyi na ŋke bɛ̀ɛnŋke lwɔhe byii.» ");
INSERT INTO spp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ka Yesu si u pyi: «Shin maha shin u ɲyɛ na ŋke bɛ̀ɛnŋke lwɔhe byii ke, byage saha sí urufoo ta. ");
INSERT INTO spp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ŋka ŋgemu ká mii lùkange bya ke, byage saha sì n‑sìi urufoo ta mɛ. Ɲaha na yɛ lwɔhe mii sí n‑kan u á ke, kuru sí n‑pyi u funŋke e lùbili. Uru lùbiliŋi sí u pyi u shìŋi niŋkwombaaŋi ta.» ");
INSERT INTO spp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ka ceeŋi si jwo: «Ɲùŋufooŋi, kuru lwɔhe kà kan na á, byage kà n‑sìi núru na ta mɛ, mii sàha kà núru mpa lwɔhɔ kwó naha mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ka Yesu si jwo: «Sà ma pooŋi yyere, ma a ma.» ");
INSERT INTO spp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ka ceeŋi si u pyi: «Nɔ̀ ɲyɛ mii á mɛ.» Ka Yesu si u pyi: «Mu u jwo na nɔ̀ ɲyɛ mu á mɛ, mu à sèe jwo. ");
INSERT INTO spp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mu à nàmbaya kaŋkuro jyé mà kwɔ̀, ŋge á mu ɲyɛ numɛ ke, uru mú bá ɲyɛ mu poo mɛ. Sèe mu à jwo.» ");
INSERT INTO spp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ka ceeŋi si u pyi: «Ɲùŋufooŋi, mii naha li ɲya, Kile tùnntunŋɔ u ɲyɛ mu. ");
INSERT INTO spp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wuu tulyey'à Kile pêe ŋke ɲaŋke na, ŋka yii Yahutuubii, yii maha jwo na Zheruzalɛmu kanni i Kile tapeeŋke ɲyɛ.» ");
INSERT INTO spp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ka Yesu si u pyi: «Ceewe, ɲje mii sí n‑jwo mu á ke, mu à yaa mu u dá yire na, tèni là sí n‑kwɔ̀ nɔ, yii saha sì raa sì ŋke ɲaŋke na, lire ɲyɛ mɛ Zheruzalɛmu kànhe e si nta raa Tufooŋi pêre mɛ. ");
INSERT INTO spp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yii Samari shiinbii na ŋgemu pêre ke, yii ɲyɛ a uru cè mɛ, wuu Yahutuubii, wuu sí na ŋgemu pêre ke, wuu à uru cè, ɲaha na yɛ Shwofooŋi à fworo Yahutuubil'e. ");
INSERT INTO spp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tèni sí n‑pa nɔ, li bá à nɔ a kwɔ̀, mpii pi ɲyɛ Tufooŋi pèeveebii sèe wuubii ke, Kile Munaani li sí raa sèeŋi cyêre Kile karigii kyaa na pir'á. Tire sùpyire shiŋi Tufooŋi Kile na ɲcaa t'a uru pêre. ");
INSERT INTO spp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kile na ɲyɛ Munaa, wà ɲyɛ na u ɲaa mɛ. Sùpyire sí n‑jà raa u pêre kanna tèni i Kile Munaani sí sèeŋi cyêe ti na ke.» ");
INSERT INTO spp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ka ceeŋi si u pyi: «Mii à cè na Masiyaŋi sí bá n‑pa (ŋge pi na yiri Kile Niɲcwɔnrɔŋi ke). U aha mpa, u sí yaayi puni yyaha jwo wuu á.» ");
INSERT INTO spp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ka Yesu si ceeŋi pyi: «Mii u na yu ná mu i ke, mii u ɲyɛ ure.» ");
INSERT INTO spp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mà Yesu ná ceeŋi yaha puru jwumpe na, ka cyelempyiibii si ntíl'a nɔ wani. Ka li i pi kàkyanhala. Li mpyi pi funŋ'i mà u yíbe ɲaha kurugo u na yu ná ŋge ceeŋi i yɛ, lire ɲyɛ mɛ ɲaha u na ɲcaa u á yɛ, ŋka pi wà ɲyɛ a jà a u yíbe mɛ. ");
INSERT INTO spp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ka ceeŋi si u kucwooni yaha bɛ̀ɛnŋke taan, maa jyè kànhe e, maa yi jwo sùpyir'á: ");
INSERT INTO spp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Yii a ma yii pa wíi. Nàŋi wà u ŋge u à mii kapyiiŋkii puni cè a jwo mii á. Kile Niɲcwɔnrɔŋi kyaa li na yu ke, u sí n‑jà n‑pyi ure.» ");
INSERT INTO spp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ka sùpyire si fworo kànhe e, na ŋkɛ̀ɛge Yesu yyére. ");
INSERT INTO spp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mà ceeŋi yaha kànhe e, ka Yesu cyelempyiibii si yi jwo u á: «Wuu cyelentuŋi, mu à yaa mu u mpa lyî amuni.» ");
INSERT INTO spp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ka u u pi pyi: «Yalyige na ɲyɛ mii á, mii u lyî, yii ɲyɛ a ŋkemu cè mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ka u cyelempyiibii si wá na yi yu piye shwɔhɔl'e na wà u à pa yalyire kan u á bɛ? ");
INSERT INTO spp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ka Yesu si jwo: «Ŋge u à mii tun ke, mii u uru ɲyii wuuni pyi, tùnnture u à kan mii á ke, mii u tire pyi fo ti tɛgɛni, mii yalyire ti ɲyɛ tire. ");
INSERT INTO spp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yii maha jwo yiɲyɛ sicyɛɛre yi ɲyɛ nùgunte ná sùmakwɔɔnni shwɔhɔl'e. Ŋka mii sí yi jwo yii á, yii yyahayi yîrige, yii i sùpyire nimpante wíi. Ti na ɲyɛ bà sùma maha nɔ a tɛ̀ɛn kɛrɛge e, na ŋkwɔ̀nŋi sigili mɛ. ");
INSERT INTO spp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ŋge u na sùmaŋi kwùun ke, uru na u sàraŋi tal'a kwɔ̀. Uru sàraŋi u ɲyɛ: sùpyire u na ntaa ke, tir'à shìŋi niŋkwombaaŋi ta. Lire pyiŋkanni na, ɲɛɛnuguŋi ná sùmakwɔnŋi na múgure siɲcyan. ");
INSERT INTO spp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tàanlini l'à jwo na “Wà na núru, wabɛrɛ sí i ŋkwùun” ke, l'à sèe jwo. ");
INSERT INTO spp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mii à yii tùugo yii sà kɛrɛge ŋkemu sùma kwɔ̀n ke, yii ɲyɛ a ku fàa mɛ. Mpii pi à báaraŋi pyi ke, ka yii i pire kanhare tɔ̀ɔnŋi ta.» ");
INSERT INTO spp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ka Samari kànhe sùpyire niɲyahara si dá Yesu na, ceeŋi jwumpe cye kurugo, u mpyi a yi jwo pi á na Yesu à uru kapyiiŋkii puni cè a jwo ur'á. ");
INSERT INTO spp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tire sùpyir'à nɔ Yesu taan ke, maa u ɲáare na u tɛ̀ɛn wani pire yyére, ka u u ntɛ̀ɛn wani mà canmpyaa shuunni pyi, ");
INSERT INTO spp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","maa jwo ná pi e, ka Samari shiinbii niɲyahamii si dá Yesu na sahaŋki, ɲaha na yɛ u yabiliŋi u à jwo ná pi e. ");
INSERT INTO spp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ka pi i yi jwo ceeŋ'á: «Numɛ wuu saha ɲyɛ a dá Yesu na mu ɲwɔjwumpe kanni kurugo mɛ, wuu à lógo u yabiliŋi ɲwɔ na, wuu à li cè na uru u ɲyɛ diɲyɛŋi Shwofooŋi, sèeŋi na.» ");
INSERT INTO spp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cyire canmpyaagii shuunniŋ'à tòro ke, ka Yesu si yîri wani mà kàre Galile kùluni i ná u cyelempyiibil'e. ");
INSERT INTO spp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","U à nɔ wani ke, sùpyire ti mpyi a kàre Zheruzalɛmu kànhe e Yahutuubii kataanni cyage e, maa núr'a pa ke, pir'à u bɛ̂ ná funntange e, ŋka lir'à ta pi à Yesu kapyiiŋkii puni ɲya a kwɔ̀ wani. Yesu yabiliŋi mpyi a jwo: «Kile tùnntunŋɔ maha le ɲjire e u tukanhe e mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu à núr'a pa Kana kànhe e, Galile kùluni i. Wani u mpyi a lwɔhe kɛ̂ɛnŋ'a pyi ɛrɛzɛn sinmɛ. Fànhafembwɔhe kà na mpyi Kapɛrɛnamu kànhe e, u jyaŋi mpyi na yà sèl'e. ");
INSERT INTO spp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kuru fànhafembwɔh'à lógo na Yesu à fworo Zhude kùluni i, mà kàre Galile wuuni i ke, maa ŋkàr'a sà u ɲáare na u shà ná ur'e Kapɛrɛnamu kànhe e u sà uru jyaŋi cùuŋɔ, ɲaha na yɛ u à yà fo sí raa ŋkwûu. ");
INSERT INTO spp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ka Yesu si u pyi: «Yii aha mpyi yii ɲyɛ a kacyeeŋii ná kabwɔhii ɲya mɛ, yii sì n‑sìi n‑dá mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ka shinbwoŋi si Yesu pyi: «Ɲùŋufooŋi, ta ma, wuu a sì fwɔfwɔ, fo lire bà mɛ, mii pyàŋi sí n‑kwû.» ");
INSERT INTO spp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ka Yesu si yi jwo u á: «Ta sì, mu jyaŋi na ɲyɛ ɲyii na.» Ka u u dá Yesu jwumpe na, maa ntíl'a yîr'a kàre. ");
INSERT INTO spp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mà u yaha u u ŋkɛ̀ɛge pyɛngɛ, u bilibil'à u ɲùŋɔ bɛ̂, maa yi jwo u á: «Mu pyàŋi na wá ɲyii na!» ");
INSERT INTO spp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ka u u pi yíbe: «Tèni ndire e u à pwɔ́rɔ yɛ?» Ka pi i u pyi: «Cifwur'à u yaha, taɲjaa mà canŋke yaha ɲùŋɔ niŋi i.» ");
INSERT INTO spp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ka tufooŋi funŋɔ si ɲcwo na tèni i Yesu mpyi a u pyi: «Mu jyaŋi na ɲyɛ ɲyii na» ke, lire tèenuuni i pyàŋ'à cùuŋɔ. Ka u ná u pyɛngɛ shiinbii puni si dá Yesu na. ");
INSERT INTO spp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Lire l'à pyi kacyeeni kakyanhala wuuni shɔnwuuni nde Yesu à pyi ke, u à li pyi mà u ta u à yîri Zhude kùluni i na ŋkɛ̀ɛge Galile wuuni i. ");
INSERT INTO spp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Puru ɲwɔhɔ na, Yahutuubii kataanni là mpyi na mpyi Zheruzalɛmu kànhe e, ka Yesu si núr'a kàre wani. ");
INSERT INTO spp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ɲcwɔ̀gɔ na mpyi wani, mpàabii tajyige taan, pi mpyi maha kuru ɲcwɔ̀ge mɛge yiri Eburubii shɛɛnre e: «Bɛtizata». Ŋkubaya kaŋkuro na mpyi wani kuru cyage e. ");
INSERT INTO spp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yamii niɲyahamii mpyi maha sínnini yire ŋkubayi ɲwɔh'i. Pìi na mpyi fyinmii, pìi sí ɲyɛ dìshiyifee, pìi sí ɲyɛ faanlii. Pi puni mpyi maha sínnini wani na ɲcwɔ̀ge lwɔhe tèeɲyahani sigili, ");
INSERT INTO spp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ɲaha na yɛ Kile mɛ̀lɛkɛŋi wà mpyi maha yîri nìɲyiŋi i maha mpa kuru lwɔhe ɲyàha tèrigii cyìl'e. Lwɔhe ká ɲyàha tèni ndemu i ke, yamafoo maha yamafoo ká fyânha a jyè k'e ke, uru wumpe mpyi maha láha u na. ");
INSERT INTO spp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nàŋi wà na mpyi pi shwɔhɔl'e, u yamp'à u ta fo mà nɔ yyee beɲjaaga ná kɛ ná baataanre na. ");
INSERT INTO spp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu à nàŋi nizinniŋi ɲya, maa ɲcè na u à mɔ yampe na mà tòro ke, maa u yíbe: «Mu la ɲyɛ si ɲcùuŋɔ la?» ");
INSERT INTO spp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ka nàŋi si u pyi: «Na cevoo, sùpya ɲyɛ mii á ŋge u sí n‑jà mii lèŋɛ ɲcwɔ̀ge e mɛ. Ku lwɔhe ká ɲyàha tèni ndemu i ke, mii la ká mpyi si jyè, wà maha mii caanra.» ");
INSERT INTO spp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ka Yesu si u pyi: «Yîri, ma a ma yasinniŋke lwɔ́, ma a ɲaare.» ");
INSERT INTO spp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ka nàŋi si ntíl'a cùuŋɔ maa ku lwɔ́ na ɲaare. Ɲyɛ kuru canŋke sí mpyi Yahutuubii canŋɔŋɔ, ");
INSERT INTO spp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ka Yahutuubii ɲùŋufeebii pìi si jwo nàŋi niɲcuuŋ'á: «Niɲjaa ɲyɛ canŋɔŋke, mu ɲyɛ a yaa mu u ma yasinniŋke tùgo ma a ɲaare mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ka nàŋi si pi pyi: «Ŋge u à mii cùuŋɔ ke, ur'à jwo “Ma yasinniŋke lwɔ́, ma a ɲaare!”» ");
INSERT INTO spp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ka pi i núr'a u yíbe: «Jofoo u à mu pyi “Ma yasinniŋke lwɔ́ ma a ɲaare” yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ŋka ŋge u à u cùuŋɔ ke, u sàha mpyi a uru cè mɛ, sùpyire mpyi a ɲyaha kuru cyage e, ka Yesu si mpînni ti shwɔhɔl'e. ");
INSERT INTO spp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lire kàntugo Yesu à sà u ɲya Kileɲaarebage ntàani na, maa u pyi: «Lógo, mu à cùuŋ'a kwɔ̀. Ma hà núru cye le kapiini labɛr'e nde li sí mu pyi mu u kyaa ta nde l'à waha niɲcyiini na mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ka nàŋi si ŋkàr'a sà yi jwo Yahutuubii ɲùŋufeebil'á na Yesu u à uru cùuŋɔ. ");
INSERT INTO spp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ka pi i wá na pyiŋkanna caa si kapii pyi Yesu na, ɲaha na yɛ u à wà cùuŋɔ canŋɔŋke e. ");
INSERT INTO spp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ka Yesu si pi pyi: «Mii Tuŋi na báaraŋi pyi tèrigii puni i, lire kurugo mii mú à yaa mii a báare.» ");
INSERT INTO spp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu à puru jwo ke, ka Yahutuubii ɲùŋufeebii si nâara na u caa raa bùu, ɲaha na yɛ u kuro ɲyɛ canŋɔŋke e mɛ, maa núr'a jwo na uru Tuŋi u ɲyɛ Kile, maa uye tàanna ná Kile e. ");
INSERT INTO spp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ka Yesu si núr'a jwumpe lwɔ́ maa jwo: «Sèeŋi na mii sí n‑sìi yi jwo yii á, Jyafooŋi sì n‑jà yaaga pyi uy'á mɛ, u aha ndemu ɲya u Tuŋi u u mpyi ke, lire u maha mpyi. Karigii puni Tufooŋi maha mpyi ke, cyire Jyafooŋi maha mpyi mú, ");
INSERT INTO spp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ɲaha na yɛ Jyafooŋi kyal'à táan Tufooŋi á. Lire e u maha u karigii nimpyiiŋkii puni cyêre u na. Karigii cyi à pêe yii niɲyaŋkwɔgigii na ke, u sí cyire cyêe u na u pyi, bà li si mpyi si yii kàkyanhala mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bà Tufooŋi na sùpyire ɲɛ̀ni na yige kwùŋi i, marii shìŋi kaan t'á mɛ, amuni Jyafooŋi maha shìŋi kaan u ɲyii wuubil'á. ");
INSERT INTO spp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tufooŋi bà u sí sùpyire sâra si ntàanna ná pi kapyiiŋkil'e mɛ, u à kuni kan Jyafooŋi á u a lire pyi, ");
INSERT INTO spp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","bà sùpyire puni si mpyi s'a Jyafooŋi pêre, Tufooŋi pèeŋkanni na mɛ. Ŋgemu ká mpyi u ɲyɛ na Jyafooŋi pêre mɛ, Tufooŋi u à u tun ke, u mú ɲyɛ na uru pêre mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sèeŋi na mii sí n‑sìi yi jwo yii á, ŋgemu ká mii jwumpe lógo maa dá mii tunvooŋi na ke, urufol'à shìŋi niŋkwombaaŋi ta. U nàzhan saha ɲyɛ Kile yoge e mɛ, u à fworo kwùŋi i mà jyè shìŋi niŋkwombaaŋi i mà kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sèeŋi na mii sí n‑sìi yi jwo yii á sahaŋki, tèni là na ma, li bá à nɔ a kwɔ̀, kwùubii sí raa Kile Jyaŋi mɛjwuuni núru, mpiimu ká u jwumpe lógo maa ɲɛɛ pu na ke, pire sí shìŋi niŋkwombaaŋi ta. ");
INSERT INTO spp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bà Tufooŋi ɲyɛ shìŋi niŋkwombaaŋifoo mɛ, amuni u à Jyafooŋi pyi uru shìŋi kanfoo mú, ");
INSERT INTO spp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","maa kuni kan u á u sùpyire sâra u tàanna ná pi kapyiiŋkil'e, ɲaha na yɛ uru u ɲyɛ Supyaŋi Jyaŋi. ");
INSERT INTO spp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jwumpe puni mii à jwo a kwɔ̀ ke, puru kà yii kàkyanhala mɛ, tèni là na ma, kwùubii puni sí raa Supyaŋi Jyaŋi mɛjwuuni núru. ");
INSERT INTO spp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kwùubii puni sí ɲɛ̀ n‑fworo pi fanɲyi i. Mpii pi à kacɛnŋii pyi ke, pire sí shìŋi niŋkwombaaŋi ta, kapimpyiibii nàntanŋi u ɲyɛ kwùŋi. ");
INSERT INTO spp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mii sì n‑jà kyaa pyi naye e mɛ, nde mii Tuŋi à jwo ke, ná lire e mii sí sùpyire sâra si ntàanna ná pi kapyiiŋkil'e. Mii sùpyire sàraŋkann'à tíi, ɲaha na yɛ mii ɲyɛ na li pyi na ɲyii wuuni mɛ, fo na tunvooŋi ɲyii wuuni. ");
INSERT INTO spp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kàmpyi mii yabiliŋi u mpyi na yu naye kyaa na, mii jwumpe mpyi na sì n‑jà n‑pyi sèe mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wabɛrɛ u à mii kyaa jwo, mii à cè u jwumpe ɲyɛ sèe. ");
INSERT INTO spp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɲyɛ yii à pìi tun Yuhana á, ka u u sèeŋi kanni jwo pi á mii kyaa na. ");
INSERT INTO spp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mii wi ke, mii ɲyɛ a naye tíiŋɛ sùpya ɲwɔmuguro na mɛ, ŋka mii na ɲcyii karigii yu yii á, bà yii si mpyi si shwɔ mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuhana à pyi bà fùkina ɲyɛ na ɲî yii shwɔhɔl'e mɛ. Puru bɛ̀ɛnmpe kurugo yii à tère nimbilere pyi funntange e. ");
INSERT INTO spp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kani là à mii kyaa jwo, lire fành'à ɲyaha mà tòro Yuhana jwumpe na. Karigii Tufooŋi à kan mii á maa jwo na mii u cyi pyi a fûnŋɔ ke, cyire kyaa na mii ɲyɛ. Sèeŋi na, ɲcyii karigil'à li cyêe na Tufooŋi u à mii tun. ");
INSERT INTO spp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tufooŋi u à mii tun ke, uru u maha mii kyaa yu. Ŋka yii sàha u mɛjwuuni lógo mà ɲya mɛ, yii sàha u ɲya mà ɲya mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","U jwumpe ɲyɛ a tatɛɛnge ta yii e mɛ, ɲaha na yɛ yii ɲyɛ a dá u tùnntunŋi na mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yii na Kile Jwumpe Semɛŋi kâlali ná funɲiŋke e, ɲaha na yɛ yii na sɔ̂nŋi na yii sí shìŋi niŋkwombaaŋi ta u e, uru sí u ɲyɛ na mii kyaa yu. ");
INSERT INTO spp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Lire ná li wuuni mú i, yii ɲyɛ a ɲɛn'a pa mii á bà yii si mpyi si uru shìŋi ta mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Sùpyire t'a mii pêre, lire bà mii ɲyɛ na ɲcaa mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mii à li cè mú na tàange ɲyɛ yii zòompii na mà yyaha tíi ná Kile e mɛ. ");
INSERT INTO spp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mii à pa na Tuŋi mɛge na, ka yii i mii cyé, ŋka kàmpyi sùpyaŋi wabɛrɛ u mpyi a pa uye mɛge na, yii mpyi na sí ɲɛɛ uru na. ");
INSERT INTO spp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yii shinɲɛɛbii pi a yii pêre, lire l'à táan yii á. Mà li ta ŋge u à sìi Kile ke, pèente uru maha ŋkaan ke, yii ɲyɛ na tire caa mɛ. Ɲyɛ di yii sí n‑jà n‑dá mii na n‑jwo yɛ? ");
INSERT INTO spp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yii àha raa sɔ̂nŋi na mii u sí na Tuŋi sɔ̀n yii na mɛ. Kile tùnntunŋiMusa na yii sɔ̀nŋɔr'à taha ke, uru u sí u sɔ̀n yii na. ");
INSERT INTO spp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kàmpyi sèeŋi na yii mpyi a dá Musa na, yii mpyi na sí n‑dá mii na mú, ɲaha na yɛ u à mii kyaa jwo u sémɛŋi i. ");
INSERT INTO spp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ɲyɛ yii aha mpyi yii ɲyɛ a dá uru sémɛŋi jwumpe na mɛ, di yii sí n‑jà n‑dá n‑jwo mii ɲwɔjwumpe na yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lire kàntugo Yesu à kàre Galile baŋi kùŋke na, uru baŋi mɛge mú na ɲyɛ Tibɛriyadi. ");
INSERT INTO spp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Shinɲyahara mpyi a taha u ɲwɔh'i, ɲaha na yɛ u mpyi na kakyanhala karigii ɲcyiimu pyi na yampii cùuŋi ke, pi ɲyii mpyi cyire na. ");
INSERT INTO spp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pi à nɔ baŋi kùŋke na ke, ka Yesu ná u cyelempyiibii si sà dùgo ɲaŋke kà na, maa ntɛ̀ɛn wani. ");
INSERT INTO spp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yahutuubiibilereŋkwoŋi kataanni sí mpyi a nɔ a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mà pi yaha wani, Yesu à wíl'a sùpyire niɲyahara ɲya ti i sì u yyére, ka u u jwo Filipi á: «Taa wuu sí bwúuru ta n‑shwɔ n‑kan nte sùpyire puni ti lyî ke?» ");
INSERT INTO spp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu à puru jwo si Filipi zò shwɔ. Sèeŋi na, u mpyi a u nimpyiini cè a kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ka Filipi si u pyi: «Wuu mɛ́ɛ ká sà shin niŋkin canmpyaa ŋkwuu shuunni (200) báara sàra tɛ̀g'a bwúuru shwɔ mà pa ntáa nte sùpyire na, ti puni sì bwúuru kwɔnrɔ ta mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mà pi yaha puru jwumpe na, Yesu cyelempyaŋi pi maha mpyi Andire, Simɔ Pyɛri sìɲɛɛŋi ke, ka uru si jwo Yesu á: ");
INSERT INTO spp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Mii à bwúuru ɲùnyɔ kaŋkuro ná fyapyaa shuunni ɲya nàɲjiibilini là á naha. Ŋka ɲaha yire sí n‑jà ɲwɔ nte sùpyire puni na yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ka Yesu si pi pyi: «Yii sùpyire pyi ti tɛ̀ɛn.» Ka ti i ntɛ̀ɛn ɲyɛge na, ɲaha na yɛ kuru cyage ɲyɛge mpyi a ɲyaha. Nàmbaabii mpyi a kampwɔhii kaŋkuro (5.000) kwɔ̀. ");
INSERT INTO spp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ka Yesu si bwúuru ɲùɲyi lwɔ́ maa fwù kan Kile á, maa yi kan pi à táa sùpyire nintɛɛnre na, maa fyaabii kan pi à táa ti na mú. Ka ti puni si lyî a tìn. ");
INSERT INTO spp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ti pun'à lyî a tìn ke, ka u u jwo u cyelempyiibil'á: «Paanyi y'à kwôro ke, yii yire kuu, bà yi si mpyi y'àha ŋkɛ̀ɛge mɛ.» ");
INSERT INTO spp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ka pi i yire kul'a tɛ̀g'a shàhii kɛ ná shuunni ɲî. ");
INSERT INTO spp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lire kakyanhala kani Yesu à pyi ke, sùpyir'à lire ɲya, maa jwo: «Sèeŋi na, ŋge u ɲyɛ Kile tùnntunŋi, ŋge kyaa l'à jwo na u sí n‑pa diɲyɛŋi i ke.» ");
INSERT INTO spp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu à li ɲya na sùpyire la ɲyɛ si uru cû fànhe e si mpyi saanŋi ke, ka u u yîri ti taan, maa núr'a dùgo ɲaŋke ɲuŋ'i uye niŋkin. ");
INSERT INTO spp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yàkoɲwɔɔr'à nɔ ke, ka Yesu cyelempyiibii si ŋkàre baŋi ɲwɔge na. ");
INSERT INTO spp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Numpilag'à wwɔ̀ a Yesu yaha u sàha ŋkwɔ̀ a nɔ pi yyére mɛ. Ka pi i bakwɔɔge kà lwɔ́ si jyiile s'a ŋkɛ̀ɛge Kapɛrɛnamu kànhe e. ");
INSERT INTO spp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mà pi yaha bakwɔɔge e ka kafeebwɔhɔ si yîri na lwɔhe ɲyàha sèl'e. ");
INSERT INTO spp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pi à culumɛtirii kaŋkuro pyi na sì baan'á lwɔhe ɲuŋ'i ke, ka pi i Yesu ɲya u u ɲaare lwɔhe ɲuŋ'i, na sì pi á, ka fyagare si pi cû sèl'e. ");
INSERT INTO spp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ka Yesu si pi pyi: «Yii àha vyá mɛ, mii wi.» ");
INSERT INTO spp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Lire tèni i, l'à táan pi á Yesu u jyè ná pire e bakwɔɔge e, ka pi i ntíl'a nɔ pi tashage e. ");
INSERT INTO spp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kuru canŋa nùmpanŋa, sùpyire ti mpyi a kwôro wani baŋi kùŋke na ke, ka tire si ɲcè na bakwɔɔgɔ niŋkin ku mpyi wani, maa ɲcè na Yesu ɲyɛ a jyè kur'e ná u cyelempyiibil'e mɛ, ɲaha na yɛ pire kanni pi à jyè a kàre. ");
INSERT INTO spp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ŋka bakwooyi yabɛrɛ mpyi a yîri Tibɛriyadi kànhe e. Kafooŋi Yesu à fwù kan Kile á, maa bwúuruŋi táa táa sùpyire na cyage ŋkemu i ke, yi mpyi a yyére kuru cyage taan. ");
INSERT INTO spp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ɲyɛ sùpyir'à pa li ɲya na Yesu ɲyɛ wani mɛ, u cyelempyiibii mú sí ɲyɛ wani mɛ, maa jyè yire bakwooyi i mà kàre Kapɛrɛnamu kànhe e Yesu tacyage e. ");
INSERT INTO spp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pi à sà Yesu ɲya baŋi kùŋke sanŋke na ke, maa jwo: «Cyelentuŋi, tèni ndire e mu à pa naha yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ka Yesu si pi pyi: «Sèeŋi na mii sí n‑sìi yi jwo yii á, kakyanhala karigii yii à ɲya mii u mpyi ke, cyire kurugo bà yii na mii caa mɛ, ŋka yalyire yii à lyî fo mà tìn ke, tire kurugo yii na mii caa. ");
INSERT INTO spp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yalyire ti na fwɔ́nre ke, yii àha raa báare tire kurugo mɛ, nte ti ɲyɛ ti ɲyɛ na fwɔ́nre mɛ, ná ti maha shìŋi niŋkwombaaŋi kaan ke, yii a báare tire kurugo. Supyaŋi Jyaŋi u ɲyɛ tire yalyire kanvooŋi, ɲaha na yɛ Tufooŋi à uru cwɔɔnr'a yaha lire mɛɛ na.» ");
INSERT INTO spp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ka pi i Yesu yíbe: «Ɲaha wuu à yaa wuu a mpyi Kile ɲyii kani yɛ?» ");
INSERT INTO spp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ka Yesu si pi pyi: «Kile ɲyii kani li ɲyɛ yii dá u tùnntunŋi na.» ");
INSERT INTO spp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ka pi i núr'a u pyi: «Kakyanhala kani ndire mu sí n‑pyi n‑cyêe wuu na, wuu u jà a dá mu na yɛ? Ɲaha mu sí n‑pyi yɛ? ");
INSERT INTO spp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mà wuu tulyeyi yaha síwage e, pi à maniŋi lyî bà l'à sémɛ Kile Jwumpe Semɛŋi i “U mpyi maha yalyire kaan pi i lyî ntemu t'à yîri nìɲyiŋi i ke.”» ");
INSERT INTO spp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ka Yesu si núr'a pi pyi: «Sèeŋi na mii sí n‑sìi yi jwo yii á, yalyire t'à yîri nìɲyiŋi i ke, Kile tùnntunŋiMusa bà u à tire kan mɛ. Ŋka mii Tuŋi kanni u maha sèe yalyire kaan, ntemu t'à yîri nìɲyiŋi i ke. ");
INSERT INTO spp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ɲaha na yɛ yalyire Kile maha ŋkaan ke, tire ti ɲyɛ nte t'à yîri nìɲyiŋi i ke, tire ti maha shìŋi niŋkwombaaŋi kaan diɲyɛ sùpyir'á.» ");
INSERT INTO spp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ka pi i u pyi: «Kafooŋi, mu à yaa mu a tire yalyire kaan wuu á tèrigii puni i.» ");
INSERT INTO spp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ka Yesu si pi pyi: «Mii u ɲyɛ yalyire nte ti maha shìŋi niŋkwombaaŋi kaan sùpyir'á ke. Ŋgemu ká mpa mii á ke, katege saha sì n‑sìi urufoo ta mɛ; ŋgemu ká dá mii na ke, byaga saha sì n‑sìi urufoo ta mɛ. ");
INSERT INTO spp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bà mii à yi jwo yii á mà kwɔ̀ mɛ, yii à mii ɲya, yii sí sàha ɲɛn'a dá mii na mɛ. ");
INSERT INTO spp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mpii mii Tuŋi na ŋkaan mii á ke, pire puni sí raa ma mii á. Ŋgemu ká mpa