﻿USE sofia;
DROP TABLE IF EXISTS sofia.spm_vpl;
CREATE TABLE spm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES spm_vpl WRITE;
INSERT INTO spm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kha mbɨghar Iesus Krais Gotɨn Otar rɨkɨnarɨ kharaghava amuisiri iŋaarir aghuuir gunɨm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aisaia Gotɨna akam nigha zesi gumagh, Got fhomɨra nona akaman aŋga anɨɨŋi. Anana osɨrisima, an aŋm mbɨŋgharani iti. Ma akamara khara. “Nɨɨ oragh! Kɨ nona ambuuŋn gumagha amandaghtima, a ufhuaragh maŋɨva nɨɨmɨusua utuaviri iŋarami. ");
INSERT INTO spm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Gumaghani itɨɨŋn mav gumasi iti phatɨsira aŋanan dɨɨ mbɨŋgeeghi, ‘Gee Ikhɨvaghava utuavi azenɨva, anda rɨkɨr.’ ” ");
INSERT INTO spm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kamagha amuisima Jon zava gumasi iti phatɨsira aŋaniri ikhava akamɨ ukurava gumasi urua mem mbɨŋgeeghi, “Gee navighɨ raghtima kɨ gee urueghtima Got geno othevir maghatɨsi gɨna amaaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ana akaar kharsi vɨŋgeema Judian distrighɨni itirɨ uŋuimba ko Jerusalemɨni iti gumasi rako amisi mee bar zava nono othevir maghatɨsir gunɨm mbɨŋgeema a Jordanɨ rɨmɨn mee urue. ");
INSERT INTO spm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Gumasi uruer gumagh Jon, a kamelɨn asɨghana arɨghɨnana amuisi shaara sharagha ana asɨghan nerɨn mɨghasɨgha noni iva dii. A nerɨn khava sharagha ondaesi rako apharira aroroe apha iti. ");
INSERT INTO spm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aŋna akam kamaghɨm mbɨŋgeeghi, “Nan gɨn zaami gumagh aŋn gamgaaŋ guisimbaaŋra nan gamgaaŋga afhira. Kɨ aŋn mɨna amuisi phatɨ. Kɨ ivɨra aviraghɨva aŋna aŋgarir shaarirɨ umbuea afhɨrami thughatɨs phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kɨ rɨmɨn gee urue, a gɨn zɨva Gotɨnɨ Utuman gamgaaŋn gee uruami.” ");
INSERT INTO spm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kha uthughun Iesus Galilin distrighɨni itirɨ uŋuu Nasareta thaeghava Jonɨmɨusua zesima, a Jordanɨ rɨmɨn ana urue. ");
INSERT INTO spm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesus rɨmɨna aveni ikegha akɨran otuivi utughura a garima ovhee ukusima Gotɨnɨ Utum fhaman mɨnɨm mbɨghegha aŋmɨusua zeghiri. ");
INSERT INTO spm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gumughun a zeghirima itɨɨŋn mav Gotɨnɨ uŋuuni ikha dɨɨ kamaghɨusue, “Nɨɨ nano Otar. Kɨ bar nɨŋgi iphui. Nan nav bar nɨɨn vhusvhusi.” ");
INSERT INTO spm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gumughun Gotɨnɨ Utum ana amandasima a gumasi iti phatɨsira aŋanan gu. ");
INSERT INTO spm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A gugha, 40 pɨlan aroe rako rɨmaŋgarir kha aŋanani itima, Satan aŋn khori ramuamɨusua aŋga aghori. A uruaŋni itira asɨsir thooŋni itima, Gotɨn enseli mee aŋn garava ana akuruvasi. ");
INSERT INTO spm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Gumughun gumasi uruer gumagh Jon, mee ana nigha rɨvɨnan khɨrthɨgha athɨsima, Iesus gɨn Galilin distrighɨn gugha Gotɨna akamana aghuuŋ ukuri. ");
INSERT INTO spm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A kamaghɨm mbɨŋgeeghi, “Got kha bisigha ativamirɨ uthugho otuivousua bara aghangera zee. Gee navighɨ raghɨva nɨghnɨghana aghavagharan Gotɨna akamana aghuuŋni ikhɨɨ.” ");
INSERT INTO spm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Uthughun mavɨn Iesus Galilin rɨmɨm mbɨroghɨn gua Saimon nonɨ undooghan Andru ko aniiŋn garima, aniiŋ osɨrivɨusua noniiŋ noni ivhaeri ikii ukuri. Aniiŋ osɨri nia andaghɨ uvhuesi gumaghaniiŋ. ");
INSERT INTO spm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mauthughura Iesus kamagha aniiŋm mbɨŋgeeghi, “Aŋgo nan gɨn zɨtima kɨ aŋgon khɨvaghtima, aŋgo osɨri nii mogh gumasi niaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aniiŋ aŋna akamam mbaraghavɨre ikha, noniiŋ noni ivhea thaegha aŋn gɨn zui. ");
INSERT INTO spm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gumughun a mange sɨvagha gua, Sebedin otar Jems nonɨ undooghan Jon ko aniiŋn garima aniiŋ noniiŋ nona akemani ikhava noni ivhaeri ikia rɨkɨri. ");
INSERT INTO spm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ana aniiŋn garavɨre ikha, aniiŋn deema, aniiŋ phura noniiŋ noni inaghaves Sebedi ko aŋni iŋaarir gumasia thaesima, mee norira akemani itima, aniiŋ Iesusɨn gɨn zui. ");
INSERT INTO spm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesus non suren gumasir phorugha Kaperneamɨn gusima avhughususanɨ uthugho otosima a gua Gotɨn phorugham mbɨŋger rɨphenana aven gugha, rɨphenan khavɨna aveni iti gumasi rako amisi men surea amui. ");
INSERT INTO spm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A men surea amuima gumasi rako amisi bar aŋna akamamba oraegha rɨŋgavan maghatɨgha amui. Aŋm mbɨŋgɨmɨŋgɨr kharsi, anda izɨɨ iti gumagham mbɨŋgɨmɨŋgɨr mɨn gu. Aŋm mbɨŋgɨmɨŋgɨ Judariro othevi ikeeŋsi gumasi mem mbɨŋgɨmɨŋgɨr mɨn zui phatɨ. Kamagha amuisima gumasi rako amisi rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A kamagh mem mbɨŋgɨvɨre itima utuman maghatɨgha aphasagha zii gumagh a zava Gotɨn phorugham mbɨŋger rɨphenana aven zegha deeghi. ");
INSERT INTO spm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","A dɨɨ kamaghɨm mbɨŋgeeghi, “Nɨɨ manmagh ee ramuamɨusua, Iesus Nasaretiiŋn gumagh? Nɨɨti eŋga asɨghasɨghaousua zesire? Kɨ nɨɨ ikaaŋi, nɨɨ Got amandasi gumagh, nɨɨ Gotɨn arɨmaghaniiŋn bar inderasi gumaghara.” ");
INSERT INTO spm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A deema, Iesusa akamana aghavagharan kamagh aŋm mbɨŋgeeghi, “Nɨɨ inɨmɨre ikhɨɨ. Nɨɨ kha gumagha thaegha akɨran zɨɨ.” ");
INSERT INTO spm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mauthughura utuman maghatɨgh Iesusɨ oraegha gumaghan khavi ikuskusa dɨɨva arava akɨran zee. ");
INSERT INTO spm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ana akɨran zesima, kha gumasi rako amisi bar bighan khavɨn ganigha guisimbaaŋra rɨŋgavan maghatɨgha amuigha norira norir azaaghi, “Khara manmagha amuisi bighaaŋ? A sureno otheviri iŋgaar izɨɨ iti gumaghan mɨna andar eŋga amui. A izɨɨ itir gumaghan mɨnɨm mbɨŋgeeghi. A ivɨra akamana aghavaghar ikha unduur maghatɨsi vɨŋgeema mee aŋn mɨn zui.” ");
INSERT INTO spm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ana amuisi bisir niaghasi uzuamɨra Galilin distrigh bar aŋga arui. ");
INSERT INTO spm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesus gumasir marsi ko Gotɨn phorugham mbɨŋger rɨphena thaeghava, Saimon ri Andru rɨphenan gue. Jems ri Jon ivɨra men phorugha gu. ");
INSERT INTO spm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mee gua garima Saimonɨna asamuiiŋ arɨva mbɨkarɨgh siava akoghi irɨghavi itima, gumasir marsi aŋn gun Iesusɨm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mee aŋm mbɨkemisima, an aŋmɨusua gua aŋna afharimuunɨ usuiragha ana ufhee. Ana ufheesima aŋna arɨmarɨm ana thaesima a rɨkhavigha maghɨra aghaer meŋga anɨndi. ");
INSERT INTO spm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kha uŋguar thughura, amɨn phɨrisima mee gumasi rako amisi, arɨmarɨr maghatɨsi iti tharsi rako unduur maghatɨsi aphasasi tharsi bar mee nigha Iesusɨusua zii. ");
INSERT INTO spm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Uŋuun khavɨni iti gumasi rako amisi bar zava rɨphenan khavɨni itɨmana akamaniiŋn nori akuvagha iti. ");
INSERT INTO spm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mee itima, Iesusa arɨmarɨr guara avɨrare iti gumasi rako amisi mena arɨmarɨgha amuima mee indera. A unduur maghatɨsira avɨrara avarasima mee gumasi rako amisia thaegha akɨran zee. Unduur maghatɨsi ana ikaaŋi, a Gotɨn Otar. Kamagha amuisima a kamagh mem mbɨusue, “Gee kamaghɨm mbɨkɨman thaghri, ‘Kɨ Gotɨn Otar.’ ” A maghɨra mee rɨghorigharui. ");
INSERT INTO spm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Amɨrɨtusi rɨmaaŋra aro thighar anandima Iesusɨ rɨkhavigha rɨphena thaegha gua gumasi iti phatɨsira aŋanan gugha Gotɨn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A gusima Saimon no rɨkurku nigha aŋmɨusua garagharui. ");
INSERT INTO spm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mee gua aŋn ganighava kamagh aŋm mbɨŋgeeghi, “Gumasi rako amisi bar nɨɨmɨusua garagharui.” ");
INSERT INTO spm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesus mena akamani iŋgarɨgha amua kamagh mem mbɨŋgeeghi, “Ee aghani itirɨ uŋuimbari igharis thasir maŋŋaŋga. Kɨ ivɨra munagh Gotɨna akamɨ ukunaŋga. Kɨ bighan khavɨusua Kaperneama thaegha zee.” ");
INSERT INTO spm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A kamaghɨm mbɨkemigha Galilin distrighɨna aŋani bar andagha arui. Ana arua gua Gotɨn phorugham mbɨŋger rɨphenira aven guava akamɨ ukuri. Ana akamɨ ukura gumasi rako amisigha aphasasirɨ unduur maghatɨsi vathosi. ");
INSERT INTO spm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mamburan arɨmarɨm itir gumaghan mav Iesusɨusua zava, aŋm mbɨnɨman aviragha itɨvɨnia rɨphɨrigha phuvɨra aŋga aghori, “Nɨɨ vhusvhusighɨv, nɨɨ nara amuighti, kɨ Gotɨn arɨmaghaniiŋn inderaghɨvɨre ikaami.” ");
INSERT INTO spm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesus kamagh oraegha, guisimbaaŋra bar aŋnɨ ukuarukuvi. Kamagha amuigha a nona afharimuu nigha kha gumaghani iphɨa athɨgha kamaghɨusue, “Nan vhusvhus. Nɨɨm mbɨkarɨgh nomi inderaghami.” ");
INSERT INTO spm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Iesus kamaghɨm mbɨŋgɨvɨre itima, mamburan arɨmarɨmɨ uzuamɨra kha gumagha thaesima aŋm mbɨkarɨgh indera. ");
INSERT INTO spm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","A inderasima, Iesus kha gumagha amaŋga akamana aghavagharan kamagh aŋm mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nɨɨ oragh. Nɨɨ maaŋɨ bighan khavɨn gun igharisi gumagha thavɨm mbɨkɨma thaghɨri. Moses fhomɨra kamaghɨusue, ‘Nɨɨ nom mbɨkarɨghan Gotɨna aphuraphurava am mbɨŋger gumaghan khɨvaghtima a Gotɨna aphuraphurami.’ ” Iesus kamaghɨusue, “Nɨɨ Mosesɨna akaman gɨn maŋɨva nom mbɨkarɨghan Gotɨna aphuraphura am mbɨŋger gumaghan khɨvaghtima gumasi rako amisi ganighi ikeeŋgemi. Nɨɨna arɨmarɨm guisimbaaŋra gɨva.” ");
INSERT INTO spm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kha gumagh Iesus aŋm mbɨkemisi moghɨn amuisi phatɨ. A kha bighaaŋn gun bar mem mbɨkemi. Mamagha amuigha phoghɨni ikhɨv aŋna akuva. Kamagha amuigha a uŋuuni ikhɨva thavɨna aven mena arɨmasi rɨfhaaŋn arui phatɨ. A nombɨra gumasi iti phatɨsira aŋanan khɨnani itima gumasi rako amisi aŋmɨusua zavɨre iti. ");
INSERT INTO spm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Uthusir marsi gɨvasima, Iesus nomthegha Kaperneamɨn zee. A za rɨphenani itima gumasi rako amisira avɨrara a nomthegha zesira akamam mbaraghi. ");
INSERT INTO spm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mee akaman khavɨ oraegha zesima rɨphen bari izɨvasima aŋni itɨmam mburoghɨn ivɨre izɨva. Uthughun khavɨn Iesus Gotɨna akaman mem mbɨkɨri. ");
INSERT INTO spm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ana akamɨ ukurima, gumasir marsi gumaghanɨ usue rako afhari arɨghiresir mav nigha aŋmɨusua zii. Gumaghan phunini ko phunini akuuna aŋgi isaghuphɨgha zii. ");
INSERT INTO spm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mee za garima rɨphenani itɨmam mburoghɨn bar izɨvasima, mee Iesusɨusua azaaŋni iŋgura. Mee gumaghan khav nigha rɨphenani isɨɨŋn guavanambogha rɨphenani isɨɨŋn thooŋga amuigha umbuera akuu rafhagha ana amandasima a Iesusɨusua zeghiri. ");
INSERT INTO spm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Uthughun khavɨn Iesus gumasir kharsir nɨghnɨghana aghavagharan ganigha kamaghɨ usue rako afhari amɨrasi gumagham mbɨŋgeeghi, “Nano otar, kɨ nɨɨno othevir maghatɨsi gɨna amanda.” ");
INSERT INTO spm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iesus kamagh aŋm mbɨŋgeema, Judariro othevi ikeeŋsi gumasi apiighav ikhava norira non navira averir kamaghɨm mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Gumaghan khav thoghousua kamaghɨm mbɨŋgeeghi? A Gotɨna aŋan niamɨusua amui! Gumaghan khɨna thav gumaghan igharisi thavɨno othevir maghatɨsi gɨna amandagham phatɨghami. Got nombɨra.” ");
INSERT INTO spm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mee kamaghɨ nɨghɨnɨsima, Iesusɨ uzuamɨra non navana aven men nɨghɨnɨsi ikeeŋga kamagh mem mbɨŋgeeghi, “Gee manmaghɨusua kamagh nɨghɨnɨsi? ");
INSERT INTO spm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kɨ manmaghatɨsira akamanɨ usue rako afhari amɨrasi gumagham mbɨkɨmti? Mana akamambaaŋ indera. Kɨ nɨɨno othevir maghatɨsi gɨna amanda, o? Kɨ kamaghɨm mbɨkɨmaŋga nɨɨ nomthegh inderaghɨri. Nɨɨ rɨkavigh nona akuu nigh maŋɨ. Kɨ manmagha amuisi akamam mbɨkɨmti, gee aŋm mbaraghɨv kamaghɨm mbɨkɨmaŋga a indera. ");
INSERT INTO spm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kɨ othɨvhan khav ramuightima, gee ganighi ikeeŋgemi, Gumasir Otar a unuaghɨnan khavɨno othevir maghatɨsi gɨna amaaŋgamiri izɨɨ iti.” A kamagh gumaghanɨ usue rako afhari amɨrasi thavɨm mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kɨ nɨɨm mbɨŋgeeghi, nɨɨ rɨkavigh nona akuu nigh rɨphenan maaŋɨri.” ");
INSERT INTO spm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Am mbɨŋgɨvɨre itima mee garima gumaghan khav rɨkavighava nona akuu nigha akɨran zui. Gumasi rako amisi bar aŋn ganigha rɨŋgavan maghatɨgha amuigha Gotɨni izɨɨ ufhava kamaghɨm mbɨŋgeeghi, “Ee ufhuaragha kamagha amuisi bigha thavɨn ganis phatɨ!” ");
INSERT INTO spm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesus nomthegha Galilin rɨmɨm mbɨroghɨn gueghiri. A gueghirima, gumasi rako amisira avɨrara zava nori akuvasima, a men surea amui. ");
INSERT INTO spm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A men surea amuava rɨmɨm mbɨroghɨn gua Alfiusɨn otar Livain garima, a gavmanɨ ranɨɨŋgamira aŋgɨro ovɨsi nir rɨphenan apheraghav iti. Iesus aŋn garava, kamagh aŋm mbɨŋgeeghi, “Nɨɨ nan gɨn zɨri.” Maghɨra Livai aŋm mbaraegha, rɨkhavigha aŋn gɨn zui. ");
INSERT INTO spm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Gɨn Iesus Livain rɨphenani ikhava non suren gumasir phorughava aphi. Aŋgɨro ovɨsi nii gumasira avɨrara ko othevir maghatɨsigha amuir gumasira avɨrara, mee ivɨra men phorugha aphi. Kamagha amuir gumasira avɨrara, mee ivɨra Iesusɨn gɨna arui. ");
INSERT INTO spm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mee apha itima, Judariro othevi ikeeŋsi Farisiiŋn gumasi mee aŋn ganigha, aŋn suren gumasira azaaghi, “A manmaghɨusua aŋgɨro ovɨsi nii gumasi rako othevir maghatɨsigha amuir gumasir phorughava aphi?” ");
INSERT INTO spm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesus mena azaaŋsɨgha oraegha kamagh mem mbɨŋgeeghi, “Arɨmarɨ phatɨsir gumasi, arɨmarɨa rɨkɨrir gumaghaousua zui phatɨ. Arɨmarɨ iti gumasi, mee arɨmarɨa rɨkɨrir gumaghaousua zui. Kɨ othevira aghuigha amuir gumasi rako amisivɨusua zesi phatɨ. Kɨ othevir maghatɨsigha amuir gumasi rako amisir dɨmamɨusua zee!” ");
INSERT INTO spm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Uthughun mavɨn Jonɨn suren gumasi rako Farisiiŋn suren gumasi mee Gotɨn phorughum mbɨkɨmamɨusua aghae thamɨrasi. Iesusɨn suren gumasi uthughun khavɨn aphima gumasir marsi Iesusɨusua zava kamagh aŋna azaaghi, “Khara manmaghɨra amuisiro othɨv? Jonɨn suren gumasi rako Farisiiŋn suren gumasi mee thighira Gotɨn phorughum mbɨkɨmamɨusua aghae thamɨrasima, nɨɨn suren gumasi Gotɨn phorughum mbɨkɨmamɨusua aghae thamɨrasi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mem mbɨŋgeema Iesus kamagh mena azaaghi, “Gumaghan mava amuuŋni ikhaousua ishamani ikhɨva amuava gumasir marsir dɨɨsima mee zee. A men phorugh ikhɨtima, mee manmaghɨra ramuti, mee aghaa thamɨraghami, o phatɨghami. A men phorugh ikhɨtima mee aghaa thaeghem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mee aghae thamɨrasirɨ uthugh iti. Kha uthugh zɨtima, gumasir marsi amuuŋni ikhaamir gumaghanɨ usuiragh maŋɨti, mee kha uthughun aghaa thamɨraghami. ");
INSERT INTO spm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Gumagha thavɨm mbɨsasin ofhɨghan ikama thav nigha shaaran gura thavɨn phorugha ana isamisi phatɨ. A mamagh ramuighɨva ana urutima mbɨsasin ofhɨghan ikam ikonigh shaaran gure ikuighɨva, anebiightima aŋn thooŋ guisimbaaŋra bar ikhevighemi. ");
INSERT INTO spm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Gumagha thav uainiro ovɨsiri imbooriri iŋgaa nighɨva, asɨghan nerɨm mbɨsɨvan guro uruighem phatɨghami. A kamagh ramuightima uainiro ovɨsiri imboori bughɨva asɨghan nerɨm mbɨsɨvan gura biighɨva, uainiro ovɨsiri imboori ko asɨghan ner, aniiŋ ivɨra maghatiighemi. A kamagh ramuighem phatɨghami. A uainiro ovɨsiri imbooriri iŋgaa nigh asɨghan nerɨm mbɨsɨvan ikamaro uruighemi.” ");
INSERT INTO spm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iesus avhughususanɨ uthughun mavɨn, raisɨn mɨn garira aghan mav, uit, mee aŋn mɨghɨni ikhɨvan thooŋn zui. Aŋn suren gumasi aŋn phorugha gua uitiro ovɨsi ukuara zui. ");
INSERT INTO spm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mee zuima Farisiiŋn marsi men ganigha kamagh Iesusɨm mbɨŋgeeghi, “Nɨɨ ganɨri. Mee manmaghɨusua othɨvhan khav aŋga amuava avhughususanɨ uthughuno othɨvhan gɨn zui phatɨ?” ");
INSERT INTO spm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesus mee ikaragha kamaghɨm mbɨŋgeeghi, “Gee, Devit amuisir bighaaŋ mee ana osɨrisima a iti, gee aŋn ganisi o, phatɨ? A non gumasir phorugha mem mbɨtii mena azima a bighan khuaŋga amui. ");
INSERT INTO spm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A gua Gotɨn rɨphenana aven gugha Gotɨ aniiŋsi uvisirɨ uthuu ame. Ana anda aphava, ivɨra marsi nigha non gumasigha aniiŋsima, mee ivɨrama anda ame. Kha uthughun Abiatar, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira aphanani itima, Devit anda ame. Judariro othɨvhan khav iti. Uvisirɨ uthuur kharsir Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira anda aphi, gumasir khɨni phatɨ. Uthughun khavɨn Devit, gumaghan khɨn, uvisirɨ uthuur kharsi ame.” ");
INSERT INTO spm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesusɨm mbɨŋgɨ guava kamagh mem mbɨŋgeeghi, “Got gumasira akuruvaghaousua avhughususanɨ uthugha athɨ. Ana avhughususanɨ uthughuna akuruvaghaousua gumasi athɨsi phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Gumasir Otar ana avhughususanɨ uthughuni Ikhɨv.” ");
INSERT INTO spm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","2","Igharisirɨ uthughun mavɨn Iesus Gotɨn phorugham mbɨŋger rɨphenan gua, garima afhari konisi gumaghan mav rɨphenan khavɨna aven gumasi rako amisira avɨrar arɨghani iti. A itima gumasir marsi ivɨre iti. Iesus bigha thavɨ ramuightima, mee akaman aŋga asaousua bar inderaghavɨra aŋn gari. Mee kamaghɨusua aŋn gari. Ana avhughususanɨ uthughun gumaghan khavɨna akuraghami, o? ");
INSERT INTO spm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mee bighan khavɨusua aŋn garavɨre itima, Iesus kamaghɨna afhari konisi gumagham mbɨŋgeeghi, “Nɨɨ rɨkavigh zɨɨ bar eem mbɨnɨmanɨ utughɨri.” ");
INSERT INTO spm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gumagh rɨkhavigha utusima, Iesus kamagh mena azaaghi, “Othɨvhan manav ana avhughususanɨ uthughuni indera? Ee othɨvhana aghuuŋ ramuaŋga, o othɨvhan maghatɨgha ramuaŋga, o gumaghana akuruvaghami, o gumagha asɨghasɨghami?” A kamagh mena azarasima, mee bar inɨmɨre iti. ");
INSERT INTO spm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ana arɨmaghaniiŋ bar gumasi rako amisigha aruava, navana avera meŋga avhesi. A men garima, men navia aghavagharigha ukuarukuvan nɨghɨnɨsi men phatɨ. Kamagha amuisi a bar osemigha kha gumagh kamagh aŋm mbɨŋgeeghi, “Nɨɨ nona afharimuu oneeghɨri.” Gumaghan khav nona afhari onesima, aŋna afhari nomthegha indera. ");
INSERT INTO spm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisiiŋ ikha ganigha rɨphena thaegha azenan zegha Herotɨn gɨna aruir gumasir phorugha ikha Iesusɨm mbɨsoghousua akaar rɨkɨri. ");
INSERT INTO spm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesus non suren gumasir phorugha Galilin rɨmɨn gueghiri. A gueghirima gumasi rako amisira avɨrara Galilin distrighɨni ikegha aŋn gɨn gueghiri. ");
INSERT INTO spm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judian distrigh ko Jerusalemɨnɨ uŋuu phorugha Idumean distrighɨn gumasi rako amisira avɨrara Iesusɨusua gueghiri. Tairɨnɨ uŋuu ko Saidonɨnɨ uŋuum mbɨroghɨni iti marsi koma Jordanɨ rɨmɨn muaaŋmogh itir gumasi rako amisi ivɨra Iesusɨusua gueghiri. Gumasi rako amisir avɨrir kharsi, mee ana amuisir bisira akamam mbaraegha aŋmɨusua gueghiri. ");
INSERT INTO spm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Mee gueghiresima, Iesus gumasi rako amisira avɨrara mena akurasima, mena arɨmarɨ gɨva. Arɨmarɨ itir gumasi rako amisira avɨrara nona arɨmarɨa gɨvaousua Iesusɨna aghan nori akuvagha, Iesusɨnɨ usuighaousua nori munamandi. Kamagha amuisima, Iesus non suren gumasi vɨŋgɨ kamaghɨusue, “Gee akema thav nigh zɨɨ phura anaratɨghti a ikhɨri. Gumasi rako amisi bar zɨɨ na akuvaghtima kɨ akeman anamboghomi.” ");
INSERT INTO spm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iesus mem mbɨŋgeema, unduur maghatɨsi aphasasi gumasir marsi zava, Iesusɨn garava unduur maghatɨsi uzuamɨra meŋga amuima mee Iesusɨm mbɨnɨman daaghira kamagh araaghi, “Nɨɨ Gotɨn Otar.” ");
INSERT INTO spm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mee kamagha amuima, ana akamana aghavagharan mem mbɨŋgɨ kamaghɨusue, “Gee kamaghɨm mbɨkɨman bar thaghri, ‘Kɨ Gotɨn Otar.’ ” ");
INSERT INTO spm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesus rɨmɨm mbɨroghɨni ikegha rɨkavighava oraghɨn guavanambogha non vhusvhusan gumasir deema, mee aŋmɨusua zii. ");
INSERT INTO spm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mee ziima a gumasir 12 pɨlam mbɨsevigha izɨɨn khavɨn meŋga athɨ, mbɨsevisir gumasi. Mee aŋn phorugh ikhɨtima, a gɨn mee amandaghti mee maaŋɨ Gotɨna akamana aghuuŋ ukunaŋga. ");
INSERT INTO spm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","A non gamgaaŋn mee raniiŋtima mee ivɨra unduur maghatɨsi vatoghomi izɨɨri ikhami. ");
INSERT INTO spm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Am mbɨsevisir gumasir 12 pɨlani izɨɨri khara. Saimon (Iesus gɨni izɨɨn khavɨn aŋga athɨ Pita), ");
INSERT INTO spm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedin otaraniiŋ Jems ri Jon (A izɨɨn khavɨna aniiŋga athɨ, Boanerges. Izɨɨn khavɨm mbɨnɨɨŋ kamagh gu, avhesa mbɨghɨravɨram mbɨŋger gumaghaniiŋ), ");
INSERT INTO spm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru ri Filiv, Bartolomiu, Metiu, Tomas, Alfiusɨn otar Jems, Tadius, Saimon (A Selotiiŋna akoghɨn gumaghan mav), ");
INSERT INTO spm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ko Judas Iskariot, Iesus nigha, aphanigha aniiŋsi gumagh. ");
INSERT INTO spm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesus nomthegha rɨphenana aven gugha itima gumasi rako amisira avɨrara zava ana akuva. Mee bar ana akuvasima, a non suren gumasir phorugh mee aghae ramaŋgami mbaaŋn iŋgura. Mee ramaŋgamirɨ uthusi phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Gumasi rako amisir marsi kamaghɨm mbɨŋgeeghi, “Ana oŋani.” Iesusɨna andarsi akaman khavɨ oraegha, ana nigh maŋamɨusua zii. ");
INSERT INTO spm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Judariro othevi ikeeŋsi gumasir marsi Jerusalemɨni ikegha zeghirava kamaghɨm mbɨŋgeeghi, “Belsebul aŋga aphasa. A unduur maghatɨsir gumaghana aphanan gamgaaŋnɨ unduur maghatɨsi andavathosi.” ");
INSERT INTO spm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iesus mem mbɨŋgera akamam mbaraegha, kamagha amuigha a gumasi rako amisir dɨɨva aghunambagha asira akaar marsir mem mbɨŋgeeghi, “Satan manmaghɨra nombɨra nombɨ athueghti? ");
INSERT INTO spm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kantri thav thooŋra nomba biighɨva norira nori vɨsoghɨva kantrin khav ikeghem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kamaghɨn ivɨra, rɨphenanɨ uvavɨra iti tharsi mee thooŋra noria biighɨva norira nori vɨsoghɨva rɨphenan khavɨni iti tharsi ikeghem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kamaghɨra Satana andarsi norira noria biighɨva nori vɨsoghtima aŋn gamgaaŋ bar gɨvagh ikeghem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Gumaghan manav phura aven maaŋɨ gumaghana aghavaghara thavɨ rɨphena akarighɨva aŋn bisi nitii? Phatɨghami. A ufhuaraghɨvɨra umbuer gumaghana aghavagharan khav ikeghemi. A kamagh aŋ ramuighɨva gumaghan khavɨn rɨphenana aven maaŋɨ, aŋn bisi niaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Mee ufhuaragha kamagh aŋm mbɨŋgɨ kamaghɨusue, “Utuman maghatɨghan mav aŋga aphasa.” A bighan khuaŋmɨusua, akaar kharsir mem mbɨŋgeeghi, “Kɨ guisimbaaŋra gem mbɨŋgeeghi, gumasi rako amisi mee othevir maghatɨsigha amua Gotɨni izɨɨra afharavaeghtima Got anda gɨna amaaŋgamirɨ utuav iti. Gumagha thav Gotɨnɨ Utumani izɨɨra afharavaeghtima Got aŋno othɨvhan maghatɨghan khav, ana gɨna amandagham phatɨghami. Osɨmndɨghan khav aŋni ikhɨvɨre ikaami.” ");
INSERT INTO spm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Uthughun khavɨn Iesusɨni inaghamuuŋ ko aŋnɨ undoosi zava, a itir rɨphenani itɨmana akamaniiŋnɨ utughava gumaghan mava amandasima a Iesusɨm mbɨkɨmamɨusua aven zui. ");
INSERT INTO spm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gumasi rako amisira avɨrara aŋn phorugha apiighav ikhava kamagh aŋm mbɨŋgeeghi, “No oraesire! Nɨɨni inaghamuuŋ ko undoosi mee nɨɨmɨusua zeghava akɨrani iti.” ");
INSERT INTO spm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mee aŋm mbɨkemisima a kamagh mena azaaghi, “Thɨɨŋra nani inaghamuuŋ? Thaeŋ nanɨ undoosi?” ");
INSERT INTO spm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A kamagh mena azaraghava, ana ighuighav apiighav itir gumasi rako amisir garava, kamagh mem mbɨŋgeeghi, “Gee gan! Nani inaghamuuŋ ko undoosira khara. ");
INSERT INTO spm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Got vhusvhuisiro othevir gɨn zui gumasi rako amisira, mee nanɨ undoosi rako umbuaramisi koma nani inaghamuuigha.” ");
INSERT INTO spm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Igharisirɨ uthughun mavɨn Iesus nomthegha rɨmɨm mbɨroghɨni ikhava, gumasi rako amisir marsir surea amui. Gumasi rako amisir avɨrani ikhɨv ana akaava oraghaousua zava ana akuavasima, aŋani izɨvasi a bɨragha akemana anambogha rɨmɨni iphɨna apheraghav itima gumasi rako amisir kharsi aŋna aghan ataaŋn apiighav iti. ");
INSERT INTO spm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ana akaar avɨrar aghunambagha asava men surea amua kamagh mem mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Gee oragh. Gumaghan mav raisɨn mɨn garir aghaan mav, uit, ana nigha gua non mɨghɨn anda ukuragha arui. ");
INSERT INTO spm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ana anda ukurima uitiro ovɨsir marsi utuavɨni iresima, ukuarasi zava anda ame. ");
INSERT INTO spm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Marsi aŋgɨri iphɨni itirɨ unuaghɨnani ivamndɨghaaŋgi ire. Unuaghɨnan khav phum mbɨthemis phatɨsima uitiro ovɨsi uzuamɨra afhuaaŋi. ");
INSERT INTO spm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Andar bii barɨ unuaghɨnana aven gueghiresi phatɨsi aro anaŋgava andaghi isirasima anda sia mbɨsɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Uitiro ovɨsir marsi rɨkhonirɨ umbue itirɨ unuaghɨnaŋgi iregha, umbuer thooŋna afhueŋsima, rɨkhonirɨ umbue aghuuva umbue anda ikhaa davi. Andaro ovɨsi vɨsevisi phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Uitiro ovɨsir marsi unuaghɨnana aghuuŋgi iregha aghuuva ovɨsi vɨsevi. Marsi 30 pɨlam mbɨsevi, marsi 60 pɨlam mbɨsevi, marsi gua 100ɨnɨ utu.” ");
INSERT INTO spm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesus mem mbɨŋgɨ gua kamagh mem mbɨŋgeeghi, “Thɨɨŋra ukuaraniiŋ iti, ana oraghɨri.” ");
INSERT INTO spm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Gumasi rako amisira avɨrara bar guesima, Iesus nombɨre itima, an 12 pɨlam mbɨsevisir gumasi rako ana aghani itir gumasi, mee aŋna aghunamana akamam mbɨnɨɨŋm mbɨumɨusua aŋna azaaghi. ");
INSERT INTO spm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mee aŋna azarasima a kamagh mem mbɨŋgeeghi, “Got ikaaŋmaran geŋga aniiŋsima, gee ma mondusir akaa anda ikaaŋi. Ma mondusir akam khara Got kha bisigha ativamirɨ uthugh. Kɨ azenani itir gumasi rako amisi phura aghunambara akaar mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kamagha amuisima, ‘Mee mɨghasɨgh ganɨva, mee bigha thav ikeeŋgem phatɨghami. Mee ivɨra mɨghasɨgh oraghɨva, mee inderaghɨvɨra akamam mbɨnɨɨŋ thav ikeeŋgem phatɨghami. Mee amuava akaa vɨnɨɨŋgari ikeeŋsi phatɨgha men navia aghavagharisi, Got meno othevir maghatɨsi gɨna amandasi phatɨ.’ ” ");
INSERT INTO spm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ana akaman khavɨn mem mbɨŋgɨ gua kamaghɨm mbɨŋgeeghi, “Gee uitir aghunamana akaman khavɨm mbɨnɨɨŋ ikeeŋsi phatɨsire? Gee manmaghɨra igharisi aghunambar akaa tharsi ikeeŋgɨti? ");
INSERT INTO spm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Gotɨna akamɨ ukuragha arui gumagh a uitiro ovɨsi ukurir gumaghan mɨna amui. ");
INSERT INTO spm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gumasir marsi utuavɨ iresirɨ uitiro ovɨsir mɨna amui. Mee Gotɨna akaava oraesima Satanɨ uzuamɨra zava mee oraesir Gotɨn akaa, mena aghan anda vatoghi. ");
INSERT INTO spm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Gumasir marsi aŋgɨ itirɨ unuaghɨnaŋgi iresirɨ uitiro ovɨsir mɨna amui. Mee Gotɨna akaava oraegha andavhagha bar inighinisi. ");
INSERT INTO spm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Men bii gueghiresi phatɨgha mamagha amuigha uthughunɨ uruarani iti phatɨ. Mee Gotɨna akaar gɨn zuima, gumasir marsi mera afharavaghava osɨmndɨsir meŋga nɨndima mee phura Gota thaghi. ");
INSERT INTO spm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gumasir marsi umbuera atari itirɨ unuaghɨnaŋgi iresirɨ uitiro ovɨsir mɨna amui. Mee Gotɨna akaava arasi. ");
INSERT INTO spm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mee andava oraegha mee ivɨra unuaghɨnan khavɨno osɨmndɨsivɨusua nɨghɨnɨghava, aŋgɨro ovɨsira avɨrara niamɨusua khorigha amuir nɨghɨnɨsigha amuava, unuaghɨnan khavɨn bisir avɨrar garava andavhagha inɨsi. Bisir kharsir nɨghɨnɨsi zava Gotɨn akaa disima anda aghaa oti phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Gumasir marsi unuaghɨnana aghuuŋgi iresirɨ uitiro ovɨsir mɨna amui. Mee Gotɨna akaava oraegha andarɨ usuiragha, andar gɨn zui tharsi mee aghaa oti. Marsi 30 pɨlan aghaeva atima, marsi 60 pɨlan aghaeva atima marsi gua 100ɨnɨ utu.” ");
INSERT INTO spm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesus kamagh mem mbɨŋgeeghi, “Gena thɨɨŋra lamaŋga amborugha ana nigha ithaaŋni ikhɨvan ana avhara? O ana nigha akoghɨn apheeŋn ana ananda? Bar phatɨ! Gee aŋra amborughuva ana nighɨva azenan aŋna aŋanara ana ranandaghɨri. ");
INSERT INTO spm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kamaghɨra mooŋgamir bisi anda gɨna azenan otuivami. Bisigha amuigha anda ave tharsi anda ivɨra gɨna azenan otuivami. ");
INSERT INTO spm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Thɨɨŋra ukuaraniiŋ iti, ana oraghɨri.” ");
INSERT INTO spm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Am mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Gee orasir akaa gee inderaghɨvɨra andava oraghɨva inderaghɨvɨra andaghɨ nɨghɨnɨghɨri. Gee gumasigha amui moghɨra Got andar gee ikaraghɨva a nomthegh thove phorugh gera anɨɨŋga. ");
INSERT INTO spm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Gotɨna akami ikeeŋsi gumagha thav Got nomthegh ikhaaŋmari tharsi phorugh aŋra anɨŋga. Gumagh ikhaaŋmaran sovange Gotɨni iti thav Got nomthegh aŋna aghan noni ikhaaŋmar nighemi.” ");
INSERT INTO spm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesusɨm mbɨŋgɨ guava kamagh mem mbɨŋgeeghi, “Got kha bisigha ativamirɨ uthughuno othɨv kamaghɨn. Gumaghan mav aghaero ovɨsi nigha unuaghɨnan anda ukuri. ");
INSERT INTO spm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Gumaghan khav anda ukunighava, rɨmaŋgarir akuava, aroer rɨkavighava arui. Ana aruima aghaero ovɨsir kharsi anda afhueŋga aghuughi. Aghaero ovɨsir kharsi manmaghɨra afhueŋga aghuughi? Gumaghan khav ikeeŋsi phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Unuaghɨnara aghaero ovɨsir kharsigha amuisima anda aghuuva mbɨsevi. Anda ufhuaragha afhueŋga aghuu gua aŋguu isɨgha ava gua akɨmari otuivigha mbɨsevi. ");
INSERT INTO spm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Anda vɨsevigha aghae itima, gumaghan khav akos nighava andara akori. A ikaaŋi, aghae itima andara akoromirɨ uthugho oto.” ");
INSERT INTO spm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A nomthegha kamaghɨm mbɨŋgeeghi, “Ee manmaghɨra Got kha bisigha ativamirɨ uthughuno othɨvham mbɨkɨmti? O, ee aghunamana akaman manavɨn aŋm mbɨnɨɨŋgarir gunɨm mbɨkɨmti? ");
INSERT INTO spm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A mastetɨno ovɨghan mɨn gari. Mastetɨnɨ uzuirafariro ovɨsi bar sovi. Igharisi thero ovɨsi bar aŋga afhiragha ikhevi. ");
INSERT INTO spm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Gumaghan mav ana ukunisima a gɨna aghuuva bar ikhevighava mɨghɨni itirɨ uzuirafari bar andagha afhiragha bare ikhevi. Ani ikhevigha aŋna aŋguuri ikii nori amaeŋsima ukuarasi zava ana aŋguur rɨghughana aveni ikha vɨkoniri iŋaari.” ");
INSERT INTO spm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesus men nɨghɨnɨsi uthusi utuirɨvan mɨna amuira akaar avɨrar aghunambagha asava Gotɨna akaar mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ana akaar gumasi rako amisi vɨŋgɨva mɨghasɨgha aghunambara akaar mem mbɨŋgeeghi. A non suren gumasir phorugha mee norira ikhava a bisi vɨnɨɨŋgaria bɨgha mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aron khavɨn amɨn phɨraousuava amuima Iesus kamagh non suren gumasi vɨŋgeeghi, “Ee rɨmɨn khava rɨtugh aŋn muaaŋmogh maŋŋaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A kamagh mem mbɨŋgeema gumasi rako amisi mbɨroghɨni ikhavɨre itima mee Iesus apheraghav itira akeman guavanaeŋga muaaŋmogh zui. Aŋgaeri igharis tharsi ivɨra men phorugha muaaŋmogh zui. ");
INSERT INTO spm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Iesus non suren gumasir phorugha zuima, gamiiŋni ikhɨv rɨkavi. Uthughun khavɨn rɨpɨraghiri rɨmɨ zava akemaŋga afhimsɨsima rɨmɨ akemana aven gueghira, akemaŋgi izɨvasima, ana atam rɨmɨna aven meghiraousuava amui. ");
INSERT INTO spm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Akem meghiraousuava amuima, Iesusa akeman khavɨn gɨraŋgɨran aghoran mav nona aphanan aghorugha akui. Aŋn suren gumasi aŋga aghuragha kamagh aŋm mbɨŋgeeghi, “Fhɨghɨn gumagh, ee gɨvaousuava amui! Nɨɨ emɨusua nɨghɨnɨsi, o phatɨ?” ");
INSERT INTO spm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesus rɨkhavigha utugha gamiiŋ mbatogha, rɨpɨraghiri rɨmɨ kamagh aŋm mbɨŋgeeghi, “Aŋgo amɨragh, inɨmɨre ikhɨɨ!” Am mbɨŋgeema, gamiiŋ amɨrasima, rɨmɨ phurama amɨnatɨ. ");
INSERT INTO spm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesus kamagh non suren gumasi vɨŋgeeghi, “Gee thoghousua phuvɨra atitiiŋi? Gee nɨghnɨghana aghavagharo othevigha kamaghɨre iti?” ");
INSERT INTO spm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mee bar ana atitiiŋga kamagh norira nori vɨŋgeeghi, “Gumaghan khav thɨɨŋra? Gamiiŋ ko rɨpɨraghiri rɨmɨ ivɨram aŋna akamam mbarasi!” ");
INSERT INTO spm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesus non suren gumasir phorugha rɨmɨa rɨthugha muaaŋmogh Gerasana aŋanan oto. ");
INSERT INTO spm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mee otuiva, Iesusa akema thaegha ataaŋn anandima utuman maghatɨgh aphasasi gumaghan mav, a khuurɨ uŋuuni ikegha Iesusɨ otuivousua zii. ");
INSERT INTO spm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","A khuurɨ uŋuuni ikhava aŋga akui. Mee uthusira avɨrara ukuaghaviir aŋna agharaniiŋ ikhava, phivɨsir aŋnɨ usuaniiŋ iti. Mee aniiŋ itima, a mɨghasɨgha ukuaghaviir kharsirɨ usuighava anda rɨghoraghɨusuava aŋnɨ usuaniiŋ ikesir phivɨghaniiŋm mbɨsogha aniia rɨghoraghɨusui. Kamagha amuisima gumagha thav gumaghan khavɨnɨ usuiragh ana ikhɨva aveeŋgemi. Mee ivɨra ukuaghaviir ana ikeghtima anda aŋnɨ usuiragham thughathɨgham phatɨghami. Gumagha thav kha gumagh ana ikeghem thughatɨs phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A rɨmaŋgari rako aroer khuurɨ uŋuimba rako orasir phurama aruava mbɨghɨravɨra dɨɨva aŋgɨr nom mbɨkarɨgha rɨghoraghɨusui. ");
INSERT INTO spm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","A isaghuni ikha Iesusɨn ganigha akhɨghavtɨgha aŋmɨusua zava aŋm mbɨnɨman noni itɨvɨnia rɨpɨri. ");
INSERT INTO spm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mauthughura Iesus kamaghɨ utuman maghatɨgham mbɨŋgeeghi, “Nɨɨ utuman maghatɨgh, nɨɨ gumaghan khava thaegha akɨran zɨɨ.” Iesus kamagh aŋm mbɨŋgeema, gumaghan khavɨm mbɨghɨravɨra arava kamaghɨm mbɨŋgeeghi, “Kha bisi bar andari iphɨni iti Gotɨn Otar Iesus, nɨɨ manmagh na ramuamɨusua. Kɨ Gotɨn arɨmaghaniiŋnɨm mbɨghɨravɨra nɨɨna azaaghi, nɨɨ naŋga asɨghasɨgha thaghri.” ");
INSERT INTO spm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A kamaghɨm mbɨŋgeema Iesus kamagh aŋm mbɨŋgeeghi, “Nɨɨ noni izɨɨ rɨmboru.” Utuman maghatɨghan khav ana ikaragha kamagh aŋm mbɨŋgeeghi, “Ee bar avɨrekevi, kamagha amuisi nani izɨɨ Avɨrira.” ");
INSERT INTO spm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A Iesus igharisi aŋana thavɨn mee amaaŋn agharkuvigha Iesusɨna avɨgha aŋga aghori. ");
INSERT INTO spm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kha uthughun, mem mburoghɨre itiro oraghɨn mav daar avɨrire ikhava aphi. ");
INSERT INTO spm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Anda aphima, unduur maghatɨsir kharsi kamagh Iesusɨm mbɨŋgɨva aŋga aghori, “Nɨɨ eem mbɨkɨmɨva ee amandaghtima ee maŋɨva daar bɨsir muna andarsigha aphasaghami.” ");
INSERT INTO spm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mauthughura a mee amandasima unduur maghatɨsir kharsi gumaghan khava thaegha akɨran zegha guava daar bɨsigha aphasa. Daar avɨrir kharsi, andar rɨmbomboni 2,000ɨna aghan gu. Mauthughura daa phuvɨra akhɨrɨsɨigha gueghira avaranɨ ukondɨghan gueghirava rɨmɨna aven guegha rɨma aphava arɨɨghire. ");
INSERT INTO spm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mauthughura daar garir gumasi daava otuivisi bisir ganigha guava uŋuimbari ikiir gua kha aŋanani itirɨ uŋuimbar sovsegher guava kha otuivisi bisir gunɨm mbɨŋgeeghi. Gumasi rako amisi bighan khavɨn ganamɨusua rɨkhavigha zii. ");
INSERT INTO spm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mee zava Iesusɨna aghanɨ unduur maghatɨsi aphasasir gumaghan garima, aŋn nɨghnɨgh nom inderasima, a non shaaria sharigha apheraghav iti. Mee aŋn ganighava atitiiŋi. ");
INSERT INTO spm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kha otuivisi bisir ganisi gumasi rako amisi, mee unduur maghatɨsi aphasasir gumagha otosir bisir kharsir gun igharisi gumasi vɨŋgeeghi. Mee andar gunɨm mbɨŋgɨ gua ivɨra daava otosi bisir gunɨm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gumasi rako amisir kharsi bighan khavɨ oraegha mee ma aŋanambaaŋ thaegh maŋamɨusua Iesusɨ aghori. ");
INSERT INTO spm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mem mbɨŋgeema, Iesus aŋanan khava thaegh maŋamɨusua akeman bɨrima unduur maghatɨsi fhom aphasagha ikesi gumagh, Iesusɨn phorugh maŋamɨusua mbɨghɨravɨra aŋga aghori. ");
INSERT INTO spm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","An aŋga aghorima, Iesus aŋn thɨva kamagh aŋm mbɨŋgeeghi, “Nɨɨ nomthegh nona andarsivɨusua rɨphenan maŋɨva Ikhɨv nɨɨna akuragha nɨɨŋga amuisir bisi andar gun mem mbɨkɨmɨva a ivɨra bar nɨɨnɨ ukuarukuvisi bisir gun mem mbɨkɨm.” ");
INSERT INTO spm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gumaghan khav ana oraegha guava Iesus aŋna akurasir bisir gun Dekapolisɨn distrighɨni itirɨ uŋuimbar guava bar mem mbɨŋgeeghi. Gumasi rako amisir kharsi aŋmba oraegha rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesus akem nigha nomthegha rɨmɨn khuaŋmogh zee. A zegha rɨmɨna ataaŋni itima gumasi rako amisira avɨrara zava ana akuva. ");
INSERT INTO spm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Gotɨn phorugham mbɨŋger rɨphenan bisir gari gumaghan mav, aŋni izɨɨ Jairus, a zava, Iesusɨn garav aŋn khoman nombɨ ukunigha kamagh phuvɨra aŋga aghori, “Nan guiva aremighaousua aŋn rɨghorɨn kɨnare iti. Nɨɨ zɨva nona afharɨn aŋra athɨghtima aŋna arɨmarɨm gɨvagh nom ikaami.” ");
INSERT INTO spm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kamagha amuisima Iesus aŋn phorugha zui. A zuima gumasi rako amisira avɨrara bar ana akuvaghava aŋn gɨn zui. ");
INSERT INTO spm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mee zuima men thooŋn ŋaanambatir arɨmarɨm itira amighan mav ivɨra men phorugha zui. Amighan khav ŋaanambatir arɨmarɨm aŋni itima 12 pɨlan ombari gɨva. ");
INSERT INTO spm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A fhomɨra nona arɨmarɨma gɨvaousuava arɨmarɨa rɨkɨrir gumasivɨusua zuima, mee aŋna arɨmarɨma gɨvasi phatɨ. Thighira am mbɨzaghɨn maghatɨgh nii. A nona arɨmarɨm ana gɨvaousua phura nona aŋgɨro ovɨsir meŋgɨ uvhuesima aŋna aŋgɨro ovɨsi bar gɨva. Bisir kharsi aŋna arɨmarɨmana akuruvasi phatɨ. Ana arɨmarɨmi ikhɨva guavɨre iti. ");
INSERT INTO spm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","A Iesusa amuisi bisira akamam mbaraegha, a kamaghi nɨghɨnɨsi, “Kɨ phura aŋna akɨrani iti shaaran khɨghtima nana arɨmarɨm gɨvaghami.” A kamaghi nɨghɨnɨghava anaaŋ ramuamɨusua. A gumasi rako amisir avɨrar gɨn zava mee munamaŋga zava Iesusɨn shaaranɨ usuira. ");
INSERT INTO spm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Amigh aŋn shaaranɨ usuiraghavɨra, aŋnɨ ŋaanambatir arɨmarɨm phura rɨthugha gu. A nombɨra nombɨ oraegha ikaaŋi, aŋm mbɨkarɨgh nom indera. ");
INSERT INTO spm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","A kamagha amuimɨra, Iesus uzuamɨra nombɨra nombɨ orasi a Got gumasir arɨmarɨa gɨvaousua aŋga aniiŋsi gamgaaŋ, aŋm mbɨkarɨgha thaesi a ikaaŋi, nan gamgaaŋ iŋaari. Mauthughura a ragha gumasi rako amisir garava mena azaaghi, “Thɨɨŋra nan shaaran khɨɨ?” ");
INSERT INTO spm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Am mbɨŋgeema, aŋn suren gumasi ana ikaragha kamagh aŋm mbɨŋgeeghi, “Nɨɨ garima, gumasi rako amisira avɨrara nɨɨ akuvagha iti. Kamagha amuisima nɨɨ thoghousua kamagha azaaghi, ‘Thɨɨŋra nan shaaran khɨɨ?’ ” ");
INSERT INTO spm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mee kamagh Iesusɨm mbɨŋgɨvɨre itima Iesus non shaaran khɨsi gumagh ikaaŋmɨusua ighaghira garagharui. ");
INSERT INTO spm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A uruiavɨre itima, amighan khav aŋm mbatosi bighan khav ikeeŋga zava Iesusɨn khomani irɨghava, atitiiŋga inɨgha guisimbaaŋra aŋm mbatosi bighaaŋn gun aŋm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Am mbɨŋgeema, Iesus kamagh aŋm mbɨŋgeeghi, “Nan guiv, nɨɨ nɨghnɨghana aghavaghar nani iti. Kamagha amuisima nɨɨna arɨmarɨm gɨva. Nɨɨ navana amɨŋndɨghan maŋɨri, nɨɨna arɨmarɨman khav nomthegh nɨɨ ramuighem phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesus amighan khavɨm mbɨŋgɨvɨre itima gumasir marsi Gotɨn phorugham mbɨŋger rɨphenan bisir garir gumagh, Jairusɨn rɨphenani ikegha zee. Mee zegha kamagh Jairusɨm mbɨŋgeeghi, “Nɨɨ osɨmndɨghan fhɨghɨn gumagha ranɨɨŋva aŋga aghora thaghri. Nɨɨn guiva aremigha gɨva.” ");
INSERT INTO spm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mee kamaghɨm mbɨŋgeema Iesus mem mbaraegha kamagh Jairusɨm mbɨŋgeeghi, “Nɨɨ atitiiŋn thaghri. Nɨɨ phura nɨghnɨghana aghavaghar nani ikhɨɨ.” ");
INSERT INTO spm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aŋn gɨna arui gumasi aŋn phorugh maŋamɨusuava amuima a men thɨva, Pita ri Jon koma aŋnɨ undooghan Jems, mera nigha mee zui. ");
INSERT INTO spm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mee guava Jairusɨ rɨphenan otuivigha Iesus gumasi rako amisiva arasima, mee bar azia nɨŋnɨɨŋni ikhɨva amui. ");
INSERT INTO spm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A memɨusua aven guava kamagh mem mbɨŋgeeghi, “Gee thoghousua azia nɨŋnɨɨŋni ikhɨva amui? Guivan khava aremisi phatɨ. Ana akui.” ");
INSERT INTO spm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A kamagh mem mbɨŋgeema, mee aŋ rɨphovava akavarɨ nori vɨŋgeeghi, “Ee ikaaŋi, a guisimbaaŋra aremi.” Gumasi rako amisi kamaghɨm mbɨŋgeema a bar mem mbatuegha guivani inaghaves ko inaghamuuŋ nigha aŋn suren gumaghan phunini ko mbɨkethav, mera aŋn phorugha zui. A mee nigha mee guivan khum itira aŋanana aven zui. ");
INSERT INTO spm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mee guegha a guivana afharimuunɨ usuragha kamagh aŋm mbɨŋgeeghi, “Talita kum!” Akaman khavɨm mbɨnɨɨŋ kamagh iti, “Guivan sovange, kɨ nɨɨm mbɨŋgeeghi, nɨɨ rɨkavi!” ");
INSERT INTO spm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","An aŋm mbɨŋgɨvɨre itima, guiv rɨkhavigha utughava arui. Aŋno ombarir 12 pɨla. A rɨkhavigha utughava aruima, mee kamagh guisimbaaŋra rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mauthughura ana akamana aghavagharan guisimbaaŋra mem mbɨŋgɨ kamaghɨusue, “Gee bighan khavɨn gun igharisi gumagha thavɨm mbɨkɨma thaghri.” A kamagh mem mbɨŋgɨva aghaa thav aŋ ranɨɨŋmɨusua mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesus khagh thaegha nonɨ uŋuun guavanandima aŋn suren gumasi aŋn phorugha zui. ");
INSERT INTO spm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Thighira, avhughususanɨ uthugho otosima a Gotɨn phorugham mbɨŋger rɨphenana aven guava, gumasi rako amisir surea amui. Gumasi rako amisira avɨrara aŋna akaava oraegha rɨŋgavan maghatɨgha amui. Mee rɨŋgavan maghatɨgha amuigha azaaghi, “Kha gumagh a managha akaar kharsi nii? A managh nɨghɨnɨsira aghuui nii? A ivɨra managh kha bisigha amuir gamgaaŋ nii? ");
INSERT INTO spm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ee ikaaŋi, khara phura rɨpheniri iŋaarir gumagh. A Marian otar, a Jems ri Josev koma Judas ri Saimon, a mena aveeŋnafhesra. Aŋnɨ umbuaramisi en phorugha iti.” Kamagha amuisima mee rɨmbovira akaar aŋm mbɨŋgɨva navira averir aŋga avhesi. ");
INSERT INTO spm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mee avhesima, Iesus kamagh mem mbɨŋgeeghi, “Gotɨna akam nigha zii gumagh, a uŋuimbari igharisi tharsir zuima, mee aŋni izɨɨ ufhi. Aŋnɨ uŋuun ana andarsi, mee aŋni izɨɨ ufhi phatɨ. Aŋn phorugha rɨphenanɨ uvavɨre iti tharsi ivɨra aŋni izɨɨ ufhi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kamagha amuisima a uŋuun khavɨn non gamgaaŋ khɨvasi phatɨ. A phura afharɨn arɨmarɨ iti gumasirɨ uvhovhera meŋga arɨsima, mena arɨmarɨ gɨva. ");
INSERT INTO spm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mee nɨghnɨghana aghavaghar aŋni iti phatɨsima, kamagha amuigha a rɨŋgavan maghatɨgha amui. Iesus non gamgaaŋ khevima aŋn suren gumasi inderagha ana ikeeŋsi phatɨ (Sapta 6.6--8.21) Iesusɨ uŋuimbagha aruava gumasi rako amisir surea amui. ");
INSERT INTO spm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesus men surea amuava, mbɨsevisi gumasir 12 pɨlan dɨɨsima, mee aŋmɨusua zesima, a mee akuvagha, mem mbɨŋgɨva mee amandi. Gumaghan phunini noniiŋ nigh maŋɨri, mamagha amuigha gumaghan phunini noniiŋ nigha zui. A non gamgaaŋn mee raniiŋtima mee ivɨra unduur maghatɨsi vatoghomi izɨɨri ikhaami. ");
INSERT INTO spm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Am mbɨŋgɨŋgɨman khavɨn meŋga amuighava mee amandi, “Gee maaŋɨ, bisi tharsi norivɨusua anda nia thaghri. Gee uvighanɨ utuma thav ko mbɨthar thav koma aŋgɨro ovɨsi nia thaghri. Gee nona aŋgarir shaaria sharighɨva, nomthegh shaara thav nia thaghri. Gee nona ashathevi ifhisira usuiragh maaŋɨ. ");
INSERT INTO spm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gee kamagh ramuigh, maaŋɨva uŋuu thavɨn maŋɨti mee rɨphena thavɨn gee raniiŋtima, gee rɨphenan khavɨre ikhɨɨ maaŋɨva, maŋaŋgamirɨ uthughun gee uŋuun khava thamɨraghɨri. ");
INSERT INTO spm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Gee kamaghɨra ramu maaŋɨ uŋuu thavɨn maŋɨtima, mee gena agharkuvigh gee nigh no rɨphenir maŋan agharkuvighɨva, mee ivɨra gem mbɨŋgera akaava oraghan agharkuvightima, gee kamaghɨra ramu. Gee uŋuun khava thaegh maŋamɨusua nona aŋgarirɨm mbɨnisi aphoeghɨva uŋuun khava thaegh maaŋɨ. Gee kamagh ramuighti, mee ganighi ikeeŋgemi, mee othɨvhana aghuuŋn geŋga amuisi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A kamagh mem mbɨkemigha mee amandasima mee uŋuimbar guava Gotɨna akamɨ ukura kamaghɨusue, “Gee non navi ighɨghireghɨri.” ");
INSERT INTO spm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mee kamagh mem mbɨŋgɨva, ivɨra gumasir avɨrarɨ unduur maghatɨsi vathogha arɨmarɨr gumasira avɨrara mbɨruer mena aphanighi ŋava meŋga amuima, mee nom indera. ");
INSERT INTO spm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iesus bisira avɨrara amuisima aŋni izɨɨ otogha ikhevisima, gumasira avɨrara ana ikaaŋi. Thighira kha aŋanaŋga ativasir gumagh, Herot aŋm mbaraghi. Gumasir marsi kamaghɨm mbɨŋgeeghi, “Jon gumasi uruer gumagha aremigha nomthegha rɨkavi. Kamagha amuigha a kha bisigha amuir gamgaaŋ iti.” ");
INSERT INTO spm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Igharis tharsi kamaghɨm mbɨŋgeeghi, “A Elaija.” Marsi kamaghɨm mbɨŋgeeghi, “Khara Gotɨna akam nigha zesi gumaghan mav, a fhomɨra ikesir Gotɨna akam nigha zesi gumasir mɨna amui.” ");
INSERT INTO spm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mee akaar kharsi vɨŋgeema, Herot andava araegha a ikaaŋi, a fhomɨram mbɨkemisi mee ufhuaragha Jonɨ ufhɨra rɨtu. Kamagha amuisima a kamaghɨm mbɨŋgeeghi, “Kɨ fhomɨram mbɨkemisima, mee gumaghan mav Jon, gumasi uruer gumaghanɨ ufhɨra rɨtusima, a nomthegha rɨkavi.” ");
INSERT INTO spm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Herot kamagha amuigha a ikaaŋi, a fhomɨra nonɨ undooghan Filivɨ otɨghɨn aŋna amuuŋ Herodias ana nigha aŋga athɨ. Jon mɨghasɨgha kamagh aŋm mbɨŋgeeghi, “Herot, nɨɨ othɨvhan maghatɨgha amuava nonɨ undoogha otɨghɨn aŋna amuuŋ nigha aŋga athɨɨ.” Jon kamaghɨm mbɨŋgeema, Herodias guisimbaaŋra nav aŋn siima, kamagha amuigha a Jonɨm mbɨsueghti ana aremighaousua phuvɨra Herotɨm mbɨŋgeeghi. Am mbɨŋgeema, Herot Herodias vhusvhuisi moghɨn ramuan agharkuvighava, a non gumasir marsi vɨkemisima mee Jonɨnɨ usuiragha ana nigha rɨvɨnan khɨrthɨgha athɨ. Herot ikaaŋi, Jon Gotɨn arɨmaghaniiŋn inderasi gumaghara ano othevira aghuuira amui. Kamagha amuisima Herot aŋna avhighavhiighava, ana nigha inderaghavɨra aŋn gari. Herot ivɨra Jonɨm mbɨŋgera akaava oraegha nɨghɨnɨsira avɨrara amuava, aŋna akaava oraghaousua vhusvhusi. ");
INSERT INTO spm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias thighira Jonɨm mbɨsueghti ana aremighaousua utuavɨ oto. Herot aŋni inaghamuuŋ aŋm mbatesirɨ uthugho otosima, a kha uthughi nɨghnɨgha ishamani ikhɨva amui. Herodias Jonɨm mbɨsoghomirɨ uthugh thighira oto. Herot ishaman khavɨ amuava, noni iŋaariri ikiir garir gumasiri ikii, rako nom mbɨzorsir gumasir garir gumasiri ikii, rako Galilin distrighɨni iti gumasiri ikii, a men dɨɨsima mee aŋn phorugh ramamɨusua zee. ");
INSERT INTO spm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mee zegha isham aphima Herodiasɨn guiv zava mee aphira aŋanan gugha mem mbɨnɨmani izi. A izima, Herotɨn phorugha zeghava aphir gumasi, mee aŋni ighɨɨn ganigha guisimbaaŋra aŋni ighɨɨn vhusvhusigha bar aŋgi iphui. Mee bar aŋgi iphuigha, mamagha amuigha Herot kamagh guivani ikamam mbɨŋgeeghi, “Nɨɨ mana bighan vhusvhusighɨv, nana azaaŋ. Kɨ ma bighan nɨɨ ranɨɨŋga.” ");
INSERT INTO spm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A kamagh aŋm mbɨkemigha, akama rɨŋgɨrana aghavagharan kamagh aŋm mbɨŋgeeghi, “Kɨ guisimbaaŋra nɨɨm mbɨŋgeeghi, nɨɨ bigha thavɨn vhusvhusighɨva, nam mbɨkɨm. Kɨ garir bisi nɨɨ andar vhusvhusighɨva, nɨɨ nam mbɨkɨmtima kɨ arɨghara anda biighɨva, tharsir nɨɨ ranɨɨŋga.” ");
INSERT INTO spm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Guivani ikaman khava akaman khavɨ oraegha, akɨrasegha gua kamagh noni inaghamuum mbɨŋgeeghi, “Inaghamuuŋ, kɨ theghan bighousua azaaŋti?” Mauthughura aŋni inaghamuuŋ kamagh aŋm mbɨŋgeeghi, “Jon, gumasi uruer gumaghana aphanamɨusua ana azaaŋtima, an aŋna aphan nigh nɨra aniiŋgɨri.” ");
INSERT INTO spm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Guivan khava akaman khavɨ oraegha, uzuamɨra nomthegha aven gugha kamagh Herotɨm mbɨŋgeeghi, “Nɨɨ thighira Jon, gumasi uruer gumaghana aphan nigh ithaaŋ thav ratɨgh nara aniiŋgɨri.” ");
INSERT INTO spm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Am mbɨŋgeema, Herot aŋm mbaraeghava aŋn nav bar aŋno osemi. A ufhuaragha akama rɨŋgɨrana aghavagharam mbɨŋgeema aŋn phorugha aphir gumasi aŋm mbaraghi. Kamagha amuisima an aŋna azaaŋsɨgha athoeghem thughatɨs phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herot aŋm mbaraghavɨre ikha, akamana aghavagharan nom mbɨzorughan gumagham mbɨkemigha ana amandasima a gua rɨvɨnan kɨrthɨghana aven gueghirɨgha Jonɨ ufhɨrar rɨtu. ");
INSERT INTO spm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A Jonɨ ufhɨrar rɨthugha aŋna aphan nigha ithaaŋn mavɨ athɨgha ana nigha zava guivan khavɨ aniiŋsima ana na nigha guava noni inaghamuuŋga anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gumughun Jonɨn suren gumasi aŋno ovhevheeŋna akamam mbaraegha zava aŋn khum nigha gua ana umoghɨ athɨ. ");
INSERT INTO spm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Gumughun Iesusɨm mbɨsevisir gumasi nomthegha zegha aŋna aghan nori akuvaghav iti. Mee aruava amuisi bisi rako, gumasir surea amuisira akaar gun Iesusɨm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kha uthughun gumasi rako amisira avɨrara memɨusua za zuima, mee ramaŋgamirɨ uthugh phatɨ. Kamagha amuisima Iesus kamagh mem mbɨŋgeeghi, “Gee norira nan phorugh maŋɨva gumasi iti phatɨsira aŋanan maŋɨva ee thange avughusuami.” ");
INSERT INTO spm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A kamagh mem mbɨŋgɨva mee norira akem nigha gumasi iti phatɨsira aŋanan mavɨn zui. ");
INSERT INTO spm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mee zuima, gumasi rako amisira avɨrara men ganigha mee ikaaŋi. Uŋuimbari iti gumasi rako amisi bar menɨ ufhuaraghavɨra akhɨrɨsiigha gua mee zuira aŋanan otuivi. ");
INSERT INTO spm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mee gua mbɨkeeŋn guegha Iesus gumasi rako amisir avɨran garima, mee guisimbaaŋra bar avɨrekevi. A men garima, mee sivsiviir mɨna amui, mee gueeŋ khekhaeŋsi phatɨ, mee phura asasir mɨna arui. A kamagh bar menɨ ukuarukuvi. Kamagha amuigha a bisira avɨrara men surea amui. ");
INSERT INTO spm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Am mbɨŋgɨvɨre itima, aro gevima aŋn suren gumasi aŋmɨusua za kamagh aŋm mbɨŋgeeghi, “Khara gumasi iti phatɨsira aŋan, aro gevi. ");
INSERT INTO spm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nɨɨ gumasi rako amisi amandaghti, mee maaŋɨ kha aŋanani itirɨ uŋuimba rako aghangera itirɨ uŋuimbar sovsegher maŋɨva mee ramamɨusua nori vagha aghaeghu uvhuesami.” ");
INSERT INTO spm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mem mbɨkemisima a mee ikaragha kamaghɨm mbɨŋgeeghi, “Gee nori aghae tharsir mee ranɨɨŋ.” A mem mbɨkemisima mee kamagh aŋm mbɨŋgeeghi, “Ee memɨusua uvisirɨ uthughu uvhuesamira aŋgɨro ovɨsi anda 200tɨ utu. Ee anda nigh, maaŋɨ, memɨusua uvisirɨ uthughu uvhuesigh mee ranɨɨŋmɨusua, nɨɨ vhusvhuisi o?” ");
INSERT INTO spm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesus mena azaaghi, “Gee manmaghɨra uvisirɨ uthuu iti? Gee maaŋɨ gan.” Am mbɨkemisi, mee gua ganigha kamagh aŋm mbɨŋgeeghi, “Ee uvisirɨ uthuur 5 pɨla koma osɨran phuninira khari iti.” ");
INSERT INTO spm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Mauthughura Iesus mem mbɨkemisi mee gumasi rako amisi vɨŋgeema, mee norira nori isɨgha izɨghɨnani iphɨna apiigha. Mee nori isiragha phosigha amuigha apiigha marsi 50 pɨlan amemeeŋn apiighi, marsi 100 pɨlan amemeeŋn apiigha gue. ");
INSERT INTO spm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mee apiighav itima, Iesus uvisirɨ uthuur 5 pɨla koma osɨran phunini nighava, iphɨn ovheen garav Gotɨm mbɨnambagha uvisirɨ uthuua bɨɨghɨusue. Iesus non suren gumasi vɨŋgeema, mee anda nia, gumasi rako amisi meŋga anɨndi. A ivɨra osɨrani phorugha bɨɨghɨusuesima, mee anda nigha, meŋga anɨndi. ");
INSERT INTO spm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gumasi rako amisir kharsi bar amegha, navi bar izɨva. ");
INSERT INTO spm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Men navi bar izɨvasima Iesusɨn suren gumasi, mee thaesira aghaero othevi nigha 12 pɨla akɨragha aghuisima, anda bar izɨva. ");
INSERT INTO spm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aghae amesi gumasir rɨmbomboni gua 5,000ɨnɨ utu. ");
INSERT INTO spm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gumasi rako amisi aghae amesima, Iesus kamagh non suren gumasira afhɨrɨgha kamaghɨusue, “Gee akeman bɨnighɨva ufhuaragh Betsaidanɨ uŋuun muaaŋmogh maaŋɨ. Kɨ nombɨre ikhɨva gumasi rako amisi amandaghtima mee nomthegh nonɨ uŋuimbar maŋŋaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A mee amandasi, mee guesima, a Gotɨn phorughum mbɨkɨmamɨusua oraghɨn guavanambo. ");
INSERT INTO spm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kha uthughun amɨn phɨrima, mena akem rɨmɨn thooŋni itima, Iesus nombɨra ataaŋni iti. ");
INSERT INTO spm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A ikhava non suren gumasir garima, gamiiŋna aghavaghar zava mena akemaŋgɨ uvhaaghi. Mee aghosava amua iŋaarani ikhɨva amuava gamiiŋn phorugha mee nori vathosi. Amɨni itiisuava amuima, Iesus rɨmɨni iphɨnɨ utuiva memɨusua zui. A gua meŋgi indɨragh maŋamɨusuava amuima, ");
INSERT INTO spm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","mauthughura mee aŋn garima, a rɨmɨni iphɨnɨ utuiva zuima, mee kamaghɨ nɨghɨnɨsi, “Khara ti asaaŋ thavti.” Mee nɨghnɨghan khavɨ amuava, bar aŋn ganigha phuvɨra atitiiŋga araaghi. Mee araema, a uzuamɨra kamagh mem mbɨŋgeeghi, “Gee gamgaeŋgiri, kɨra khara. Gee atitiiŋn thaghri!” ");
INSERT INTO spm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","A kamagh mem mbɨŋgɨva, mem mbathɨghɨn akemana aven gusima, gamiiŋ phura rɨthugha gu. Iesus 5,000ɨn gumasi uvisirɨ uthuur meŋga aniiŋsi, mee anda amesima, mee bighan khavɨn ganigha, thange ikeeŋsi bar phatɨ. Men navia aghavagharigha nɨghɨnɨsi othevigha bar isaghure iti. Kamagha amuigha mee bisir kharsighi nɨghɨnɨghava guisimbaaŋra rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gumughun Iesus non suren gumasir phorugha rɨmɨn muaaŋmogh guegha, guava Genesaretɨnɨ uŋuun otuivigha, akemi ike. ");
INSERT INTO spm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mee akemi ikegha ataaŋn anandima, gumasi rako amisi Iesusɨn garavɨre ikha ana ikaaŋi. ");
INSERT INTO spm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mee ana ikeeŋga, gumasi rako amisi Iesus itira aŋanam mbaraegha, akhɨrɨsɨgha aŋanan khavɨ aruava nona arɨmarɨr gumasi nia mee akhuriigha ariigha mee nia Iesusɨusua zii. ");
INSERT INTO spm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesusɨ uŋuimbari ikii rako uŋuimbarɨ undoosi rako uruarirɨ uŋuimba andar zui. A zuirɨ uŋuimbar kharsi mee othɨvhan khavɨra amui, mee arɨmarɨr gumasi nigha zava uŋuun thooŋn anda arɨghava, aŋga aghora kamaghɨusue, a men mɨratɨghtima, arɨmarɨ iti tharsi aŋn shaarana avaraniiŋn khɨskhɨsami. Gumasi rako amisi aŋn shaaran khɨsi tharsi, mena arɨmarɨ gevi. ");
INSERT INTO spm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisiiŋn gumasir marsi rako Judariro othevi ikeeŋsi gumasir marsi, mee Jerusalemɨni ikegha, zeghirava, Iesusɨusua zava ana akuva. ");
INSERT INTO spm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mee za ikha garima, Iesusɨn suren gumasir marsi mena avaviro othevirɨ usuiraghavɨre ikha afhari uruegha aghae aphi phatɨ. Mee phura aghae aphi. ");
INSERT INTO spm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisiiŋn kharsi koma igharisi Judarir gumasi rako amisi bar, mee nona avaviro othevirɨ usuiraghavɨre ikhava, mee afhari uruava aphi. Mee phura aghae raman thughatɨs phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mee ivɨra phoghɨn nigha ziir aghae, mee anda raman thughatɨs phatɨ. Mee ufhuaragh anda urueghɨva anda ramaŋga. Mee ivɨra nona avaviro othevir avɨrar marsi phorugha usuiragha khɨghavɨre iti. Mee phura aghae ishamigh rameghem thughatɨs phatɨghami. Mee ufhuaragh nom mbɨne rako ithaarigha, baghaa rako apiisira akosi, urueghɨva mee aghae ishamaŋga. ");
INSERT INTO spm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kamagha amuisi, Farisiiŋ rako Judariro othevi ikeeŋsi gumasi, mee Iesusɨna azaaghi, “Manmagha amuigha nɨɨn suren gumasi ena avaviro othevir gɨn maaŋɨ afhari uruani iphɨrphɨrigha, phura aghae aphi?” ");
INSERT INTO spm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mem mbɨkemisima Iesus mee ikaragha kamaghɨm mbɨŋgeeghi, “Gee norira norir khorigha amuir gumasira. Gotɨna akam nigha zesi gumagh Aisaia, a guisimbaaŋra gee amuiro othevir gunɨm mbɨŋgɨva kamagh osɨri, ‘Gumasi rako amisir kharsi, mee nona akaa thoorir nani izɨɨ ufhi, men navi rako nɨghɨnɨsi bar isaghuni iti. ");
INSERT INTO spm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mee gumasira akaar norir surea amua norir khorigha amua kamaghɨusue, khara Gotɨna akam. Kamagha amuigha, mee nani izɨɨ guisimbaaŋra ana ufhi phatɨ.’ ");
INSERT INTO spm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gee kamagha amua, Gotɨna akaa, gee anda thaegha, nona avaviro othevi, andarɨ usuragha aghavaghari.” ");
INSERT INTO spm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Am mbɨŋgɨ guava kamagh mem mbɨŋgeeghi, “Gee kamaghɨusue, gee othɨvhana aghuuŋga amua Gotɨn akaa thaegha nono othevir gɨn zui. Geno othevir kharsi bar maghatɨghi. ");
INSERT INTO spm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses fhomɨra kamaghɨm mbɨkemi, ‘Gee noni inasi rako inaghamuuira akaava oraegh mena apheeŋni ikhɨva, gumagha thava akaman maghatɨgha thav noni inaghaves ko inaghamuum mbɨkemighti, gee gumaghan khavɨm mbɨsueghtima ana aremighɨri.’ ");
INSERT INTO spm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Gee kamaghɨm mbɨŋgeeghi, ‘Gumagha thav noni inaghamuuŋ ko inaghavesɨna akuruvaghaousua aŋgɨro ovɨsi rarɨghan nɨghɨnɨighava gɨn a nomthegha kamagha aniiŋm mbɨŋgeeghi, “Aŋgona akuruvaghaousua athɨsi aŋgɨro ovɨsi, aŋgo marikɨɨ. Kha anda nigh Got ranɨɨŋgami.” ’ ");
INSERT INTO spm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Gee kamaghɨm mbɨŋgeema, gumaghan khav bigha thav noni inaghamuuŋ ko inaghavesɨna akurasi phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gee kamagha amuava, nona avavi nisiro othevir gɨn gua, anda igharisi gumasigha anɨndi. Gee othevir kharsigha amua, Gotɨn othevia thaegha, nona avaviro othevi ufhuaraghavɨra anda arɨsi. Gee Gotɨna akamaŋga amuima a phura bighɨn maghɨ. Gee amuir bisir avɨrar marsi ivɨre iti.” ");
INSERT INTO spm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesus nomthegha nombɨna aghani iti gumasi rako amisir dɨɨsima, mee aŋmɨusua zima, a kamagh mem mbɨŋgeeghi, “Gee bar nam mbaraeghɨva nana akaar kharsi, inderaghɨvɨra anda ikeeŋgɨri. ");
INSERT INTO spm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Bigha thava akɨrani ikeghɨva gumaghan navana aven meghirɨgh aŋn ramuighti, a Gotɨn arɨmaghaniiŋn maghatiighem phatɨ. Phatɨ, gumaghan navana aveni ikegha akɨran zesi bisi, aŋn ramuightima, a Gotɨn arɨmaghaniiŋn maghatiighemi.” ");
INSERT INTO spm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesus akaar kharsir gumasi rako amisira avɨrara mbɨkemigha, mee thaegha guava rɨphenana aven gusima, aŋn suren gumasi aghunamana akamam mbɨnɨɨŋ mbaaŋmɨusua aŋna azaaghi. ");
INSERT INTO spm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Mem mbɨkemisima Iesus kamagh mem mbɨŋgeeghi, “Eei! Gee oŋanisire? Gee ivɨra akaman khav inderaghavɨra ana ikeeŋsi phatɨsire? Gee bighan khav ikeeŋsire? Aghaa thav guisimbaaŋra gumaghan navana aven meghirɨgh ikeghem thughatɨs phatɨ. Anda aŋn navana aven meghirɨghɨv, aŋnɨ umuun meghirɨghtima a gɨna andar avighemi. Kamagha amuisi gumagha aphir bigha thav akɨrani ikegh aŋna akamndooŋniiŋ ko umuun meghirɨghɨv, aŋnɨ umu ramuightima a Gotɨn arɨmaghaniiŋn maghatiighem thughatɨs phatɨ.” Iesusa akamana aghavagharan kamaghɨm mbɨŋgɨ kamaghɨusue, aghae bar Gotɨn arɨmaghaniiŋn bar indera. Orɨrɨvi phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Am mbɨŋgɨ guava kamagh mem mbɨŋgeeghi, “Gumaghan navana aveni ikegha akɨran zesi bisi, anda othevir maghatɨsi, anda aŋga amuima, aŋn navana avee Gotɨn arɨmaghaniiŋn maghatɨ. ");
INSERT INTO spm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gumaghan navana aveni ikegha akɨran zesira othevi khara, nɨghɨnɨsir maghatɨsi, gumasi rako amisi atamatam norir phorughava akui, bisi okeeghi, gumasi vɨsosi anda arɨghiri, ");
INSERT INTO spm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pharaghamuui norir okeeghi, mbɨghɨravɨra bisir vhusvhusi, igharisi gumasi meŋga asɨghasɨghaousua nɨghɨnɨsi, khoriro othevi, ameri phatɨsiro othevir maghatɨsi, bisivagha nav oseeghi, igharisi gumaghani izɨɨra afharavasi, nombɨra nombɨ ufhi, oŋanisiro othevi, ");
INSERT INTO spm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","othevir maghatɨsir kharsi bar navana aveni ikegha akɨran za, gumagha amuima a Gotɨn arɨmaghaniiŋn maghatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesus Genesareta thaegha Tairɨnɨ uŋuuni ikhɨvan aŋanan gu. A gumasi rako amisi ana ikhaaŋgamim mbaaŋn aŋna agharkuvigha, mondugha guava rɨphenan mavɨna aven gugha mondusi phatɨ. Mee bar ikaaŋi, a rɨphenana aveni iti. ");
INSERT INTO spm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A rɨphenan khavɨni itima, utuman maghatɨgh aphasasir guivani inaghamuuŋ, a Iesus zesir arorɨ oraegha, uzuamɨra aŋmɨusua zava aŋn aŋgariri irɨ. ");
INSERT INTO spm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Amighan khav, aŋni inaghamuuŋ Fonisiana aŋanan aŋm mbate. A Sirian distrighɨni ikhɨvana aveni iti. A Grighiiŋna akamam mbɨŋgeeghi. A non guiva aphasasirɨ utuman maghatɨghan khavɨ avharaghaousua Iesusɨm mbɨŋgɨva aŋga aghori. ");
INSERT INTO spm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Am mbɨŋgeema, Iesus kamagh aŋm mbɨŋgeeghi, “Ee ufhuaragh boorir aghae mee raniiŋti, mee ramaŋga. Othɨvhan maghatɨgh, kɨ boorir aghae nigh afhee vɨkɨnaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Am mbɨŋgeema amigh kamagh Iesusɨm mbɨŋgeeghi, “Ikhɨv, Kɨ ikaaŋi, afhee ivɨra boorir akoghɨn apheeŋni iresir aghae vɨzuii aphi.” ");
INSERT INTO spm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Am mbɨŋgeema Iesus kamagh aŋm mbɨŋgeeghi, “Nɨɨm mbɨŋgɨŋgɨm indera. Kamagha amuisi nɨɨ nomthegh no rɨphenan maaŋɨ. Utuman maghatɨghan khav nɨɨn guiva thaegha akɨran zee.” ");
INSERT INTO spm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ana aŋm mbɨkemisima, a nomthegha no rɨphenan gua garima, aŋn guiv nona akoghi irɨghav iti. Mauthughura an aŋn ganigha ikaaŋi, utuman maghatɨghan khav ana thaegha akɨran gu. ");
INSERT INTO spm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesus rɨkhavigha Tairɨnɨ uŋuum mbɨrogha thaegha, guava Saidonɨnɨ uŋuun otogha guava, Dekapolisɨn distrighɨn otogha gua, Galilin rɨmɨm mbɨroghɨn gueghirɨ. ");
INSERT INTO spm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A gusima, gumasir marsi gumaghanɨ ukuaraniiŋ oŋanisi mav nigha Iesusɨusua zii. A ivɨram mbɨzɨ osemigha inderaghavɨram mbɨŋge phatɨ. Mee zegha afharɨn aŋra rɨghaousua Iesusɨ aghori. ");
INSERT INTO spm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Am mbɨŋgeema Iesus gumaghan khav nigha gumasira avɨrara thaegha aniiŋ noniiŋra mbɨŋɨniiŋn gugha, a nona afharɨn gumaghanɨ ukuaraniiŋga athɨgha aniiŋ asigharafha, a maghɨra nona afharɨnɨ ufheeniiŋgi ipharigha aŋm mbɨzaan khɨɨ. ");
INSERT INTO spm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mauthughura Iesus iphɨno ovheen garav, gumaghan khavɨusua nav biigha arava kamaghɨm mbɨŋgeeghi, “Efata!” Akaman khavɨm mbɨnɨɨŋ kamagh gu, “Ukuighirɨghɨri!” ");
INSERT INTO spm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iesus kamaghɨm mbɨŋgɨvɨre itima, aŋnɨ ukuarani ukuighirɨ. Mauthughura aŋm mbɨzɨ mbɨghɨvɨghɨghi. A inderaghavɨra bisi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesusa akamana aghavagharan bighan khavɨn gunɨm mbɨkɨman mee rɨghorigharui. A mee rɨghorigharuisima mee nomthegha phuvɨra bighan khavɨn gunɨm mbɨŋgɨvɨre iti. ");
INSERT INTO spm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mee akaman khavɨm mbɨŋgeema, gumasi rako amisir kharsi aŋm mbaraegha guisimbaaŋra rɨŋgavan maghatɨgha amuigha kamaghɨm mbɨŋgeeghi, “Gumaghan khav ana amuir bisi anda bar indera. A ukuari oŋanisi tharsigha amuima, mee nomthegha orasi. Am, mbɨzeri osemisi tharsigha amuima, mee nomthegha inderaghavɨra bisi vɨŋgeeghi.” ");
INSERT INTO spm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kha uthughun gumasi rako amisir avɨrari igharis tharsi nori akuvaghav iti. Mee ramaŋgamir aghae phatɨ. Kamagha amuisima Iesus non suren gumasir dɨɨsima mee aŋmɨusua zima a kamagh mem mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gumasi rako amisir kharsi, mee nan phorugh aron phunini ko mbɨkethavɨni itima, aghae mange othevisima mbɨtii mena azi, kamagha amuisima kɨ menɨ ukuarukuvi. ");
INSERT INTO spm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Gumasir marsi isaghuni ikegha zee. Kamagha amuisi kɨ mee amandaghtima mem mbɨtiir navira nori nonɨ uŋuimbar maŋɨva arɨmasi meŋgi ighutima mee iraami.” ");
INSERT INTO spm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Am mbɨkemisima aŋn suren gumasi aŋna akam ikara, “Ee gumasi iti phatɨsira aŋanan khavɨni iti. Ee managh membagha uvisirɨ uthuu nigh mee ranɨɨŋti?” ");
INSERT INTO spm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mee kamaghɨm mbɨŋgeema Iesus kamagh mena azaaghi, “Gee manmaghɨra uvisirɨ uthuu iti?” Mee ana ikaragha kamaghɨm mbɨŋgeeghi, “7 pɨla.” ");
INSERT INTO spm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mem mbɨkemisima Iesus unuaghɨnara apiighousua gumasi rako amisi vɨkemisi mee apiigha. Mauthughura a 7 pɨla uvisirɨ uthuu nigha Gotɨm mbɨnambagha anda bɨɨghɨusuegha, gumasi rako amisir anɨɨŋmɨusua non suren gumasigha aniiŋsima mee andar meŋga anɨndi. ");
INSERT INTO spm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mee ivɨra osɨrir sovsegher move iti. A ivɨra andavhagha Gotɨm mbɨnambagha andar mee ranɨɨŋmɨusua non suren gumasi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gumasi rako amisira avɨrara mee amegha bar izɨva. Gɨn aŋn suren gumasi aghaero othevi mee thamɨraesi tharsi, mee anda nigha 7 pɨla akɨrari ikhiigha aghuisima, anda izɨva. ");
INSERT INTO spm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Uthughun khavɨni itir gumasi rako amisir rɨmbomboni 4,000ɨna aghan gu. Mee amesima, a mee amandasi, mee nonɨ uŋuimbar gue. ");
INSERT INTO spm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mee zuima, a non suren gumasir phorugha akeman bɨnigha, Dalmanutana aŋanan gue. ");
INSERT INTO spm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mee guesima Farisiiŋ zegha khoruo amuir azaaŋsɨsir Iesusɨa amui. Gota aghavagharan aŋra raniiŋti, a non gamgaaŋn bigha thavɨ ramuightima mee ganighi ikeeŋgɨm mbɨkɨmaŋga, “Got guisimbaaŋra ana amanda.” ");
INSERT INTO spm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mem mbɨkemisima a men khoruo amuir azaaŋsɨsir kharsighi iphɨrphɨrigha ughurii usuegha, mem mbɨŋgeeghi, “Gee thighira khari iti gumasi rako amisi, thoghousua bisigha amuir gamgaaŋ khɨvaousua nana azaaghi? Kɨ guisimbaaŋra gem mbɨŋgeeghi, Got kha bisigha amuir gamgaaŋno othɨvha thavɨn gen khɨvagham thughathɨs phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A mem mbɨkemigha a mee thaegha nomthegha akemana anambogha, rɨmɨn muaaŋmogh gu. ");
INSERT INTO spm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mee gua Iesusɨn suren gumasi uvisirɨ uthuur nɨghnɨgh oŋanigha gue. Mee uvighanɨ utumanɨ uvavɨra nisima a men phorugha akemani iti. ");
INSERT INTO spm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Thighira Iesusa akamana aghavagharan kamagh mem mbɨŋgeeghi, “Gee inderaghɨvɨra norivɨusua gan! Gee inderaghɨvɨra Farisiiŋn iis ko Herotɨn iisɨusua phorugh inderaghavɨra ganɨri.” ");
INSERT INTO spm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iesus mem mbɨkemisima, mee kamagh norira nori vɨŋgeeghi, “Ee uvighanɨ utuma thav nigha zesi phatɨsima, kamagha amuisima an eem mbɨŋgeeghi.” ");
INSERT INTO spm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mee norira nori vɨŋgeema, Iesus mem mbɨŋgɨŋgɨ ikeeŋga kamagh mena azaaghi, “Gee thoghousua kamaghɨusue, ee uvighanɨ utuma thav nigha zesi phatɨ? Eei, gee kha amui bisir garava anda iŋgaere? Gee thighari inderaghɨvɨra anda ikaaŋtire? Gen navia aghavagharigha nɨghɨnɨsi othevigha bar isaghure iti. ");
INSERT INTO spm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Gee arɨmasi ikha, garir phatɨsire? Gee ukuari ikha, orasi phatɨsire? Gee bisir kharsighi nɨghɨnɨsi phatɨsire? ");
INSERT INTO spm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Gee, kɨ uvisirɨ uthuur 5 pɨla bɨɨghɨusuegha geŋga aniiŋsima, gee 5,000ɨn gumasigha aniiŋsima, mee anda apha izɨvagha, thaesiro othevi gee andar manmaghɨra akɨragha aghui?” Mee kamagh ane ikara, “Ee 12 pɨla akɨragh aghui.” ");
INSERT INTO spm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A nomthegha kamagh mem mbɨŋgeeghi, “Kɨ uvisirɨ uthuur 7 pɨla bɨɨghɨusuegha geŋga aniiŋsima, gee 4,000ɨn gumasi rako amisigha aniiŋsima, mee anda apha izɨvasi gee andaro othevir akɨrar manmaghɨra aghui?” Mee kamagha ana ikara, “Ee 7 pɨla akɨrari ikhiigha aghui.” ");
INSERT INTO spm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mee kamagh aŋm mbɨŋgeema, a kamagh mem mbɨŋgeeghi, “Gii, gee thighar bisi ikaaŋtire.” ");
INSERT INTO spm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mee Betsaidan guesima, gumasir marsi gumaghan arɨmaghan thughaniiŋm mbɨzesi mav nigha, Iesusɨusua zii. Mee zegha afharɨn aŋra rɨghaousuava Iesusɨ aghori. ");
INSERT INTO spm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mem mbɨkemisima Iesus gumaghan arɨmaghan thughaniiŋm mbɨzesi thavɨna afharimuunɨ usuragha, ana nigha uŋuua thaegha akɨran gu. Aniiŋ akɨran gugha, Iesus gumaghan arɨmaghaniiŋgi ipharigha nona afharimuun aŋni iphɨa athɨgha kamagh aŋna azaaghi, “Nɨɨ bigha thavɨn gari?” ");
INSERT INTO spm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ana aŋm mbɨkemisima gumaghan khav khogha garava kamaghɨm mbɨŋgeeghi, “Aŋre, kɨ garima, gumasi ther mɨn garava arui.” ");
INSERT INTO spm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mauthughura Iesus nomthegha nona afharimuun aŋn arɨmaghaniiŋnɨ usuirasima, gumaghan arɨmaghaniiŋ ukuighirɨsima, a nom inderaghɨvɨra bisir gari. ");
INSERT INTO spm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","A garima, Iesus ana amandagha kamaghɨm mbɨŋgeeghi, “Nɨɨ nomtheghɨva uŋuun khavɨna aven maŋan thaghri. Nɨɨ nor rɨphenan maaŋɨri.” ");
INSERT INTO spm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesus non suren gumasir phorugha rɨkhavigha Sisariafilipainɨ uŋuuna aghani itirɨ uŋuimbar sovsegher zui. Mee gua a utuavɨn mena azaaghi, “Gumasi rako amisi thɨɨŋra naŋga arɨsi?” ");
INSERT INTO spm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mee ana ikaragha, “Marsi kamaghɨusue, nɨɨ Jon, gumasi uruer gumagh. Igharisi gumasi kamaghɨusue, nɨɨ Gotɨna akam nigha zesi gumagh Elaija. Marsi kamaghɨusue, nɨɨ fhomɨra ikesir Gotɨna akam nigha zesi gumaghan mav.” ");
INSERT INTO spm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mem mbɨkemisima Iesus kamagh mena azaaghi, “Geegha? Gee thɨɨŋra naŋga arɨsi?” A mem mbɨkemisima Pita kamagh ana ikara, “Nɨɨ Krais, Got nom ee niamɨusua mbɨsevisir gumagh.” ");
INSERT INTO spm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","An aŋm mbɨkemisima, Iesusa akamana aghavagharan kamagh mem mbɨŋgeeghi, “Gee nan gun gumagha thavɨm mbɨkɨma thaghri, kɨ thɨɨŋra.” ");
INSERT INTO spm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iesus men surea amuava kamaghɨm mbɨŋgeeghi, “Gumasir Otar barɨm mbɨzasiri ikii rako osɨmndɨsi niaŋga. Gumasira aphani, koma Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii, koma Judariro othevi ikeeŋsi gumasi, mee aŋna agharkuvighɨva ana nigh igharisi mbuzorsir gumasir raniiŋtima mee aŋm mbɨsueghtima ana aremighemi. Gumughun, uthughun phunini ko mbɨkethav gɨvaghtima a nomtheghɨ rɨkavighemi.” ");
INSERT INTO spm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesus kamagh nono ovhevheeŋna akama aghurigha mem mbɨŋgeema, Pita ana nigha mbɨkeeŋn gugha, aŋga atarava kamagh aŋm mbɨŋgeeghi, “Nɨɨ kamaghɨm mbɨkɨman bar thaeghri.” ");
INSERT INTO spm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A kamaghɨm mbɨŋgeema, Iesus oragha non suren gumasir garava, Pita avesa kamagh aŋm mbɨŋgeeghi, “Satan, nɨɨ namɨusua isagh muna maaŋɨ! Nɨɨ gumasir bisighi nɨghnɨgha, Gotɨn bisighi nɨghɨnɨsi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Gumughun Iesus, gumasi rako amisir dɨɨva ivɨra non suren gumasir dɨɨsima, mee aŋmɨusua zima, a kamagh mem mbɨŋgeeghi, “Gumagha thav nan gɨn zaasa, a vhusvhuisi bisi gɨna amandagh non khani ighuuve isaghuphughuva nan gɨn zɨɨ. ");
INSERT INTO spm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gumagha aŋamɨre ikaaousua nɨghɨnɨsi, aŋnɨ utum a mɨghasɨgh ikhaamiri ikɨrana aghuuŋ nighem phatɨ. Gumagh naŋgi nɨghnɨgha nana akamana aghuuŋ ukurava arui thav ana aremightima aŋnɨ utum a mɨghasɨgh ikhaamiri ikɨrana aghuuŋ niaŋga. ");
INSERT INTO spm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gumagha thav unuaghɨnani iti bisi bar anda nighɨva, a gɨna aremighti, bisir kharsi manmaghɨra aŋna akuraghti? Bar phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A uvhuesan manavɨn nonɨ utum aŋmɨusua aŋ raniiŋti? Bar phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Thighire itir gumasi rako amisi mee Gotɨn akɨrasegha othevir maghatɨsigha amui. Mena thɨɨŋra nani izɨɨ ko nana akaman gunɨm mbɨkɨman aŋemsiightima, gɨn Gumasir Otar noni inaghavesɨnɨ uŋuuni ikegh zɨva ivɨra mena aŋemsiighemi. A enselir aghuuir phorugh Gotɨn aŋarana aven zighiraami.” ");
INSERT INTO spm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesusɨm mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Kɨ guisimbaaŋra gem mbɨŋgeeghi, gee khaghɨ utuivighav iti tharsi, gena tharsi aremighem phatɨghami. Gee ikhɨvɨre ikhɨɨ gantima, Got kha bisigha ativamirɨ uthugh, aghavagharan phorugh zighiraami.” ");
INSERT INTO spm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Uthusir 6 pɨla gɨvasima, Iesus Pita ri Jems koma Jon mee nigha oraghɨni ikhɨvan guavanambogha, mee norira anamoghi iti. Ana anamogh aŋm mbɨkarɨgh mena arɨmasi rɨfhaaŋni igharaghavo oto. ");
INSERT INTO spm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aŋn shaarana aŋarana aghavagharan khav guisimbaaŋra ughurighava afho. Ughuran khav unuaghɨnan gumagha thavɨ uruesir bighanɨ ughura thavɨn mɨn gari phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mauthughura mee garima Elaija ri Moses otogha Iesusɨn phorugha mee nori vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Mee nori vɨŋgɨvɨre itima, Pita ri Jems koma Jon mee bar atitiiŋga, Pita mbɨkɨmaŋgamirɨm mbɨŋgɨgɨgha asagha phura kamagh Iesusɨm mbɨŋgeeghi, “Fhɨghɨn gumagh, ee bar inderaghɨvɨra amuigha khagh iti! Ee ambɨkhavan phunini ko mbɨkethav ramuaŋga. Nɨɨmɨusua thav, Mosesɨusua thav, Elaijagha thav.” ");
INSERT INTO spm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mauthughura, gu usuiragha mee avarasima itɨɨŋn mav guan thooŋn otogha kamaghɨm mbɨŋgeeghi, “Khara nano Otar, kɨ bar aŋn vhusvhusi. Gee anara oraaghɨri!” ");
INSERT INTO spm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mauthughura uzuamɨra mee gara nomthegha gumagha thavɨn ganisi phatɨ. Iesus nombɨra men phorugha iti. ");
INSERT INTO spm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mee nomthegha oraghɨn zighirava Iesus mee ganisir bisir gun gumagha thavɨm mbɨkɨman bar men thɨva. Kamaghɨre ikhɨɨ maaŋɨ Gumasir Otar aremigh nomtheghɨ rɨkavighemi. ");
INSERT INTO spm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mee ganisi bighan khav mere itima, mee ana aremigh nomtheghɨ rɨkavamira akamam mbɨnɨɨŋ mbaaŋmɨusua norira nori vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gumughun mee aŋna azaaghi, “Manmaghɨusua Judariro othevi ikeeŋsi gumasi kamaghɨusue, Elaija ufhuaragh zeghtima, Got nom ee niamɨusua mbɨsevisir gumagh gɨn zaami?” ");
INSERT INTO spm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mem mbɨkemisima Iesus mena azaaŋsɨgh ikara, “Guisimbaaŋra Elaija ufhuaragha zeghava bisia rɨkɨri. Thoghousua fhomɨra Gotɨm mbɨgharani itiro osɨr kamagh iti, ‘Gumasir Otarɨm mbɨzasi nitima mee akɨran aŋga aseghemi?’ ");
INSERT INTO spm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kɨ gem mbɨŋgeeghi, Elaija zegha gɨva. Mee fhomɨra Gotɨna akama osɨra nori bisir kharsi aŋ ramuamɨusua mbɨkemisi moghɨn, gumasi rako amisi mee non vhusvhusan mɨn gua nono othevir aŋga amuigha gɨva.” ");
INSERT INTO spm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mee za suren gumasir marsi mem mbatuivigha garima gumasi rako amisira avɨrara mee akuvasima Judariro othevi ikeeŋsi gumasi men phorugha nori vɨŋgɨ nori vathosi. ");
INSERT INTO spm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mee nori vatosima gumasi rako amisi Iesusɨn garavɨre ikha rɨŋgavan maghatɨgha amuigha uthughun aŋ ranɨɨŋmɨusua akhɨrɨsɨigha zui. ");
INSERT INTO spm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesus kamagh mena azaaghi, “Gee thoghousua men phorugha gee nori vathosi?” ");
INSERT INTO spm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Gumaghan mav gumasi rako amisira avɨran thooŋni ikhava kamaghɨm mbɨŋgeeghi, “Fhɨghɨn gumagh, kɨ nono otar nigha nɨɨmɨusua zee, utuman maghatɨgh aŋga aphasasima, am mbɨŋge phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","An aŋga amuirɨ uthughun, ana na ukurima a daaghira, phuvii aŋna akamndooŋnim mbɨsevi, aŋna atari nori vɨtivima aŋm mbɨkɨrɨvasi. Kɨ utuman maghatɨgha avharaghavharaghaousua nɨɨn suren gumasira azarasi mee aŋga avharasi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ana aŋm mbɨkemisima Iesus kamaghɨm mbɨŋgeeghi, “Oio! Kɨ bara amɨra, thighira itir gumasi rako amisi nɨghɨnɨsia aghavagharisi phatɨ. Kɨ fhomɨra gen phorugha itima, gee daasughun bigha thav ikeeŋgɨti? Kɨ mɨghasɨgh geno osɨmndɨsira nitire? Otar nigh namɨusua zɨɨ.” ");
INSERT INTO spm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A mem mbɨkemisima mee otar Iesusɨusua ana nigha zee. Mauthughura utuman maghatɨgh Iesusɨn garavɨra, maghɨra otara amuima a inɨsi. A unuaghɨnaŋgi irɨgha uphoghuphogha phuvii aŋna akamndooŋninɨm mbɨsevi. ");
INSERT INTO spm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Am mbɨsevima Iesus otarani inaghavesɨna azara, “A mana uthughunɨ utuman maghatɨgh aŋga aphasa?” An aŋm mbɨkemisima, inaghaves kamaghɨm mbɨŋgeeghi, “A irɨrɨvare itima an aŋga aphasa. ");
INSERT INTO spm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","An aŋ ramuightima ana aremighaousua uthusira avɨrara ana ukurima ana arivi rako rɨphar gueghiri. Nɨɨ ena akuruvaghamir gamgaaŋ ikhɨtima, nɨɨ enɨ ukuarukuvighɨva ena akuraghɨri.” ");
INSERT INTO spm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","An aŋm mbɨkemisima Iesus kamaghɨm mbɨŋgeeghi, “Nɨɨ thoghousua kamaghɨusue nɨɨ gamgaaŋ ikhɨva nana akura? Nɨɨ nɨghnɨghana aghavaghar ikhɨtima bisir kharsi bar othuivhami.” ");
INSERT INTO spm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","An aŋm mbɨkemisima otarani inaghaves uzuamɨra kamagh dɨɨgham mbɨŋgeeghi, “Kɨ nɨghnɨghana aghavaghar ikhava, ano othevi. Kamagha amuisima, nɨɨ nana akura!” ");
INSERT INTO spm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesus garima gumasi rako amisi akɨrsiigha mena aghan zesima a utuman maghatɨgha athogha kamagh aŋm mbɨŋgeeghi, “Nɨɨ kha utuman maghatɨgh gumasigha amuima mee ukuari oŋandava mbɨŋger phatɨsi thav. Kɨ nɨɨm mbɨŋgeeghi, nɨɨ akɨran zɨɨ, nɨɨ nomthegh aven maaŋa thaghri!” ");
INSERT INTO spm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mauthughura utuman khavɨ oraegha mbɨghɨravɨra ana ikuskusava akɨran zesima otar gumaghan khuman mɨn gari. Kamagha amuisima gumasi rako amisira avɨrara kamaghɨm mbɨŋgeeghi, “Ana aremi.” ");
INSERT INTO spm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mem mbɨkemisima Iesus ana afharɨnɨ usuiragha ana ufhesi a rɨkhavigha utu. ");
INSERT INTO spm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Gumughun Iesus rɨphenana aven gugha non suren gumasir phorugha mee norire ikhav ikha, mee kamagh aŋna azaaghi, “Manmagha amuigha, ee utuman maghatɨghan khavɨ avharava avheeŋi?” ");
INSERT INTO spm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mem mbɨkemisima a kamagh mee ikara, “Kamagha amuirɨ unduur maghatɨsi gee Gotɨn phorughum mbɨkɨmɨva andagha avaraghti anda akɨran zaami. Nomthegha igharisi utuav thavi iti phatɨ, utuavɨnɨ uvavɨra.” ");
INSERT INTO spm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Mee aŋanan khava thaegha Galilin distrighɨn otogha zui. Mee gua Iesus non suren gumasir surea amui. Bighan khuaŋmɨusua Iesus mee itira aŋan gumagha thav ikhaaŋn a iphɨrphɨri. Mee guava, a kamagh men phorugham mbɨŋgeeghi, “Mee Gumasir Otar nighɨva gumasira afhari ratɨghɨva, gumughun mee aŋm mbɨsueghti ana aremighɨva, gumughunɨ uthughun phunini ko mbɨkethav gɨvaghtima a nomtheghɨ rɨkavighemi.” ");
INSERT INTO spm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A mem mbɨkemisima mee am mbɨŋgɨŋgɨ ikeeŋsi phatɨgha, kamagha amuigha mee aŋna azaaŋsɨghana atitiiŋi. ");
INSERT INTO spm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mee Kaperneamɨn zegha rɨphenana aveni ikha Iesus mena azaaghi, “Gee utuavɨn thaegham mbɨŋgɨ nori vathosi?” ");
INSERT INTO spm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mee utuavɨn nori vathogha nori vɨŋgɨ kamaghɨusue, “Thɨɨŋre ikhɨv?” Kamagha amuisi mee inɨmɨre iti. ");
INSERT INTO spm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gumughun Iesus apheraghav ikhava mbɨsevisir gumasir 12 pɨlan dɨɨgha kamaghɨm mbɨŋgeeghi, “Thɨɨŋ ufhuaragh ikaaousua, a gɨni ikhɨva gumasi bar meni iŋaaran gumagh ikhɨri.” ");
INSERT INTO spm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mauthughura Iesus otaran sovange nigha men thooŋn ana rafhasi a utughavi itima, a nona agharaniiŋn ana umuigha kamagh mem mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Gumagha thav naŋgi nɨghɨnɨsi moghɨn kha otaran sovangen mɨn garir thav nigh ana akuraghami, a kamagh na nigha nana akuruvasi. Nɨɨ thɨɨŋra nana akuruvasi, nɨɨ nara amui phatɨ. Nɨɨ na amandasi gumagh ivɨra aŋga amui.” ");
INSERT INTO spm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon kamagh aŋm mbɨŋgeeghi, “Fhɨghɨn gumagh, ee garima gumaghan mav unduur maghatɨsi nɨɨni izɨɨn anda vathosi. Ee ikaaŋi, a ena mav phatɨ, ee aŋn thevi.” ");
INSERT INTO spm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Gumughun Iesus kamaghɨm mbɨŋgeeghi, “Aŋn thɨvan thaghri. Gumagha thav nani izɨɨn gamgaaŋ bisi ramuva, kha uthusir ana akaar maghatɨsir na ramuighem thughatɨs phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Thɨɨŋ ena aphanaŋga amui phatɨ a enav. ");
INSERT INTO spm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kɨ guisimbaaŋra gem mbɨŋgeeghi, gee Kraisɨna andarsi. Krais a Got nom ee niamɨusua mbɨsevisir gumagh. Kamagha amuisima thɨɨŋra nani izɨɨn rɨmɨn gee raniiŋgemi, a guisimbaaŋra nonɨ uvhues niaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iesusɨm mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Otaran kha thav nɨghnɨghana aghavaghar nani ikɨthi, nɨɨ thɨɨŋra aŋra amuightima ano othɨvhan maghatɨgha thavɨ ramuighemi. Nɨɨm mbɨŋŋue phatɨsir arivan maŋɨva barɨ uvhuesan maghatɨgh nighemi. Mee akɨmani ikhɨv nɨɨnɨ ufhɨrara afhaghɨva oŋaram mbɨkɨnightima nɨɨ aremighemi. Kamagh indera. ");
INSERT INTO spm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kamagha amuisi nɨɨna afharimuu nɨɨ ramuightima nɨɨ othɨvhan maghatɨgha thav ramuightima, ana rɨtu. Kamagh indera, nɨɨ afharimuunɨ uvavɨre ikhɨv, a mɨghasɨgha itiri ikɨrana aghuuŋ niaŋgami. Nɨɨna afharimuuni ivɨre ikhɨva nɨɨ ramuightima nɨɨm mbuŋŋue phatɨsir arivanɨ uŋuun maŋŋaŋga. ");
INSERT INTO spm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nɨɨnɨ usua thav nɨɨ ramuightima nɨɨ othɨvhan maghatɨgha thav ramuightima, ana rɨtu. Kamagh indera, nɨɨ usuanɨ uvavɨre ikhɨva, mɨghasɨgha itiri ikɨrana aghuuŋ niaŋgami. Nɨɨnɨ usuani ivɨre ikɨthi Got nɨɨ nighɨva mbuŋŋue phatɨsir arivan nɨɨ ukunighemi. ");
INSERT INTO spm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nɨɨna arɨmagha thav nɨɨ ramuightima nɨɨ othɨvhan maghatɨgha thav ramuightima ana sii. Kamagh indera, nɨɨ arɨmaghanɨ uvavɨre ikhɨva Got kha bisigha ativamirɨ uthughuna aven maŋŋaŋga. Nɨɨna arɨmaghaniiŋ ivɨre ikɨthi Got nɨɨ nighɨva mbuŋŋue phatɨsir arivan nɨɨ ukunighemi. ");
INSERT INTO spm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aŋanan khav aphisirɨ uŋusi mem mbɨkarɨsi aphi tharsi gevi phatɨ. Mem mbɨkarɨsir sir ariv ivɨra mbuŋŋue phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gumasi Gotɨna aphuraphurir aghaera anɨɨŋmɨusua amaaghasɨghan aghaegha arɨgha arivan anda utuava anda nigha, Gotɨ anɨndi. Amaaghasɨgh arivanɨ utuir aghaegha amuima anda Gotɨn arɨmaghaniiŋn indera. Osɨmndɨsi amaaghasɨghan mɨna amui. Amaaghasɨgh mee utueghtima mee utuivigha aghavagharighɨv osɨmndɨsi otuivtima mee Gotɨn arɨmaghaniiŋn inderaghami. ");
INSERT INTO spm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Amaaghasɨgh a indera, a nono ovheera thaeghti, nɨɨ manmagh aŋ ramuightima a nomthegh ovheerighti? Osɨmndɨsi amaaghasɨghan mɨna amui. Amaaghasɨgh gen navana aveni ikhɨtima gee nava amɨŋndɨghani ikhɨɨ.” ");
INSERT INTO spm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesusɨ uŋuun khava thaegha guava, Judian distrighɨn guava Jordanɨ rɨmɨn muaaŋmogh oto. Ana otosima, gumasi rako amisira avɨrara nomthegha zava, ana akuvasima, a mɨghasɨgha amui moghɨra men surea amui. ");
INSERT INTO spm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A men surea amuima, Farisiiŋn marsi zava aŋn koruamua kamagh aŋna azaaghi, “Nɨɨ eem mbɨkɨm, eno othɨv manmaghɨm mbɨŋgeeghi? Gumagh nona amuuŋ athamɨraghamiro othɨvhan khav inderasi, o phatɨ?” ");
INSERT INTO spm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A mena azaaŋsɨgh ikaragha kamagh mena azaaghi, “Moses othɨvhan manav ramuamɨusua gem mbɨkemi?” ");
INSERT INTO spm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A mem mbɨkemisima mee kamagh aŋm mbɨŋgeeghi, “Moses, gumagha thav amuuŋ athamɨraghaousua managhamuuŋniiŋ noniiŋ thamɨraghamirɨm mbɨgharan ofhɨghaaŋ osɨrigha amigha amandaghaousua, an eem mbɨkemi.” ");
INSERT INTO spm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mem mbɨkemisima Iesus kamagh mee ikara, “Gen navia aghavaghari, kamagh amuisima Moses gemɨusua othɨvhan khav osɨri. ");
INSERT INTO spm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bar fhomɨra Got unuaghɨnan khav ko bisi bar andagha amuavɨra gumasi rako amisigha amui. ");
INSERT INTO spm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kamagha amuisima, gumagh noni inaghaves ko inaghamuuŋ thaeghɨva, a nona amuuŋn phorugh aniiŋ noniiŋn phorughami. ");
INSERT INTO spm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aniiŋ nerɨn ofhɨghanɨ uvavɨre ikaami. Aniiŋ nom gumaghan phunini phatɨ. Aniiŋ nerɨn ofhɨghanɨ uvavɨre ikaami. ");
INSERT INTO spm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kamagh amuisima Got bighan phuniniiŋgu ufhuraghtima, gumagha thav aniia biighem thughatɨs phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gumughun mee nomthegha rɨphenana aven guava, Iesusɨn suren gumasi bighan khavɨusua aŋna azaaghi. ");
INSERT INTO spm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A mee ikaragha kamaghɨm mbɨŋgeeghi, “Gumagha thav nona amuuŋ thaegh igharisira amighani ikhɨva, a ivɨra nona amuuŋga asɨghasɨgha pharaghamuui norir okɨɨva nori nigha akuiro othɨvha amui. ");
INSERT INTO spm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Amigha thav non mana thaegh igharisi gumaghani ikhɨva, a ivɨra pharaghamuui norir okɨɨva nori nigha akuiro othɨvha amui.” ");
INSERT INTO spm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gumasi rako amisi boorir sovseghe nigha Iesusɨusua zii. A nona afharimuun meni iphɨ rarɨghaousua mee zima, aŋn suren gumasi meŋga avhesava men thevi. ");
INSERT INTO spm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mee meŋga avhesima, Iesus men ganigha nava osemigha, a kamagh mem mbɨŋgeeghi, “Nɨɨ thɨɨŋra Got kha bisigha ativamirɨ uthughuna aveni ikaaousua, boorir sovsegher kharsir mɨni ikhɨɨ. Kamagha amuisima boorir sovseghe thaeghtima, mee namɨusua zɨɨ. Men thɨva thaghri. ");
INSERT INTO spm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kɨ guisimbaaŋra gem mbɨŋgeeghi, boorir sovseghe mee Got kha bisigha ativamirɨ uthughun ganan vhusvhusi. Gumagh a boorir sovsegher mɨn nomba amevi thav a inighinighemi. A Got kha bisigha ativamirɨ uthughuna aven maŋŋaŋga. Gumagh nomba amevagham phatɨghami a kha uthughuna aven maaŋɨgham phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A kamagh mem mbɨkemigha, boori uvhaghuvhagha mee nia mee umusi. Ana afharɨnɨ uvhaghuvhagha meni iphɨa arɨghava, inderaghɨvɨra mee ramuamɨusua Gotɨm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesus rɨkhavigha zuima, gumaghan mav akhɨghavtɨgha zava, Iesusɨm mbɨnɨman noni itɨvɨnia rɨphɨrigha kamagh aŋm mbɨŋgeeghi, “Fhɨghɨn gumaghana aghuuŋ, kɨ manmagh ramuighɨva mɨghasɨgha itiri ikɨrana aghuuŋ niiti?” ");
INSERT INTO spm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","An aŋm mbɨkemisima Iesus ana ikaragha kamagh aŋm mbɨŋgeeghi, “Nɨɨ manmaghɨusua gumaghana aghuuŋn naŋga arɨsi? Gumaghana aghuuŋ thav iti phatɨ. Got nombɨra aghuuŋ maghɨ. ");
INSERT INTO spm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nɨɨ Got Mosesɨ aniiŋsiro othɨv ikaaŋi, ‘Nɨɨ gumagham mbɨsueghti ana arɨma thaghri, nɨɨ pharaghamuui norir okeero othɨvha ramua thaghri, nɨɨ igharisi gumaghan bisi okɨma thaghri, nɨɨ bisir khorira amuan thaghri, nɨɨ nombɨɨgha bisi niamɨusua gumasir khorira amuan thaghri, nɨɨ noni inaghaves ko inaghamuuŋna apheeŋni ikhɨva aniiŋm mbɨzeva aragh.’ ” ");
INSERT INTO spm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Am mbɨkemisima ana na ikaragha kamaghɨm mbɨŋgeeghi, “Fhɨghɨn gumagh, kɨ fhomɨra irɨrɨvare ikhava othevir kharsigha amua za thighira ikha khari iti.” ");
INSERT INTO spm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mauthughura Iesus gumaghan khavɨn garava, aŋn vhusvhusigha kamagh aŋm mbɨŋgeeghi, “Nɨɨ bighanɨ uvavɨra nɨɨ thighira aŋ ramuaŋgami. Nɨɨ itir bisi tharsi bar anda amandaghɨva aŋgɨro ovɨsi nighɨva, bisi phatɨsi gumasi raniiŋgɨva nan gɨn zɨɨ. Gumughun nɨɨ Gotɨnɨ uŋuun bisir aghuuira niaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","An aŋm mbɨkemisima gumaghan khava akaman khavɨ oraegha, aŋn khom mbɨsɨɨŋi. A ikaaŋi, a guisimbaaŋra bisira avɨrare itir gumagh. A kamaghɨn oraegha aŋn nava osemisi a gu. ");
INSERT INTO spm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Gumughun Iesusɨn arɨmaghaniiŋ non suren gumasigha aruava, kamagh mem mbɨŋgeeghi, “Gumasi bisir avɨrire iti tharsi, mee Got kha bisigha ativamirɨ uthughun maŋamɨusua iŋaaram mbɨthemara ramuighɨva aven maŋŋaŋga!” ");
INSERT INTO spm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aŋn suren gumasi aŋna akaar kharsiva oraegha, rɨŋgavan maghatɨgha amuisima, Iesus nomthegha kamagh mem mbɨŋgeeghi, “Nan boori, gumagh Got kha bisigha ativamirɨ uthughuna aven maŋamɨusua iŋaaram mbɨthemara ramuighɨva aven maŋŋaŋga. ");
INSERT INTO spm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel thav, shaari isaerɨ usuuŋn thooŋna aven maŋamɨusua iŋaarani ikhɨva ramuighɨva aven maŋŋaŋga. Gumasi bisir avɨrire iti tharsi, mee Got kha bisigha ativamirɨ uthughuna aven maŋamɨusua iŋaaram mbɨthemara ramuighɨva aven maŋŋaŋga!” ");
INSERT INTO spm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A mem mbɨŋgeema, mee guisimbaaŋra rɨŋgavan maghatɨgha amuava nɨghɨnɨsir avɨragha amuava norira nori vɨŋgeeghi, “Kamagh ramuightima, thɨɨŋra mɨghasɨgha itiri ikɨrana aghuuŋn khav niiti?” ");
INSERT INTO spm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mauthughura Iesus men gara kamagh mem mbɨŋgeeghi, “Gumagh nona aghavagharan a mɨghasɨgha itiri ikɨrana aghuuŋ nighem phatɨ. Gumagh Gotɨna aghavagharanɨ uthughɨva a mɨghasɨgha itiri ikɨrana aghuuŋ niaŋga. Got kha bisi bar andagha amuira aghavaghar iti.” ");
INSERT INTO spm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A mem mbɨkemisima Pita kamagh aŋm mbɨŋgeeghi, “Nɨɨ gan, ee non bisi bar anda thaegha, nɨɨn gɨn zee.” ");
INSERT INTO spm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","An aŋm mbɨkemisima Iesus kamagh mem mbɨŋgeeghi, “Kɨ guisimbaaŋra gem mbɨŋgeeghi, gumagh naŋgɨ nɨghnɨgha nana akamana aghuuŋ ukunamɨusua, a no rɨphen, o nona aveeŋnafhesi, o nonɨ umbuaramisi, o noni inaghaves ko inaghamuuŋ, o non boori, o nono ombaria thaeghɨva nan gɨn zɨɨ. ");
INSERT INTO spm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Gumaghan khav thighira unuaghɨnan khavɨn Got guisimbaaŋra bisi a ufhuaragha iti tharsi bar andagha afhiragh aŋ ranɨɨŋgami. A rɨphenira avɨrira ko aveeŋnafhesi rako umbuaramisi ko inaghamuui koma boorira avɨrara, ivɨra ombarira avɨrara aŋ ranɨɨŋgami. Mee Gotɨna akamana aghuuŋn gɨn zuima gumasir marsi zava mera afharavasi. Gumughun zaamirɨ uthugh, Got a mɨghasɨgha itiri ikɨrana aghuuŋn an aŋ ranɨɨŋgami. ");
INSERT INTO spm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Thighira kha uthughunɨ ufhuaraghɨvɨra iti gumasi, mee gɨni ikhɨtima, gɨni iti gumasi, mee ufhuaragh ikaami.” ");
INSERT INTO spm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mee Jerusalemɨn guavanaŋgava Iesusɨ ufhuarasima, aŋn suren gumasi aŋn gɨn guava nɨghɨnɨsira avɨrara amui, men phorugha zuir gumasi rako amisi atitiiŋi. Iesus nomthegha nom mbɨsevisir gumasir 12 pɨla nigha mem mbɨŋɨniiŋn gughava, aŋm mbatuivamir bisir gun mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A kamagh mem mbɨŋgeeghi, “Gee oraa. Ee Jerusalemɨnɨ uŋuuni ikhɨvan guavanandi. Gumughun gumagha thav Gumasir Otar nighɨva, Judariro othevi ikeeŋsi gumasi rako Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii ranɨɨŋva, mee osɨmndɨsir aŋra anɨɨŋva ana arɨmaaŋgamira akaar rɨkɨrami. Gumughun mee ana nighɨv igharisir kantrin gumasira afhari ratɨghami. ");
INSERT INTO spm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mee rɨmbovira akaar aŋm mbɨkɨmɨva, aŋgi ipharɨva, ana fhasaroghɨv, aŋm mbɨsueghtima ana aremighemi. Ana aremighti, uthughun phunini ko mbɨkethav gɨvaghtima a nomtheghɨ rɨkavighemi.” ");
INSERT INTO spm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedin otaraniiŋ, Jems ri Jon, Iesusɨusua zava kamagh aŋm mbɨŋgeeghi, “Fhɨghɨn gumagh, aŋga bighan mavɨn vhusvhusi. Nɨɨ aŋgagha aŋ ramuamɨusua aŋga nɨɨna azaaghi.” ");
INSERT INTO spm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aniiŋ aŋm mbɨkemisima, Iesus kamagh aniiŋna azaaghi, “Kɨ manmagh aŋgona akuruvaghti?” ");
INSERT INTO spm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aniiŋ ana ikaragha kamagh aŋm mbɨŋgeeghi, “Nɨɨ bisigha ativasir gumaghani ikhɨva otoghɨva, aŋga ramuighti, aŋgana thav nɨɨn guvɨn aghara raperaghtima thav nɨɨni ikɨna aghara raperaghɨri.” ");
INSERT INTO spm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aniiŋ aŋm mbɨkemisima Iesus kamaghɨm mbɨŋgeeghi, “Aŋgo azaaŋsɨsir bighan khav, aŋgo aŋm mbɨnɨɨŋ ikeeŋsi phatɨgha, aŋgo aŋmɨusua nana azaaghi. Aŋgo ti kɨ niaŋgaminɨm mbɨzasi ivɨra aŋgo anda niaŋgamira aghavaghar iti? O aŋgo ti kɨ thooŋn maaŋgamiro osɨmndɨsi ivɨra andar thooŋn maaŋgamira aghavaghar iti?” ");
INSERT INTO spm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ana aniiŋm mbɨkemisima, aniiŋ ana ikara, “Aŋre, aŋga aghavaghar iti.” Mauthughura Iesus kamagh aniiŋm mbɨŋgeeghi, “Guisimbaaŋra, aŋgo kɨ niaŋgamim mbɨzasi ivɨra aŋgo anda niaŋgami. Kɨ thooŋn maaŋgamiro osɨmndɨsi tharsi aŋgo ivɨrama andar thooŋn maŋŋaŋga. ");
INSERT INTO spm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aŋgo nan guvɨn aghar ko ikɨna aghara raphighaousuava azaere, khara nan bighɨn phatɨ. Aŋanir kharsi Gotɨn bisira. A kha aŋanir raphighemir gumasi, a mee ikeeŋga, memɨusua aŋanir kharsigha amui.” ");
INSERT INTO spm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jems ri Jon bighan khavɨn Iesusɨm mbɨŋgeema, 10 pɨlan suren gumasiri igharis tharsi aŋm mbaraegha, bighan khavɨusua Jems ri Jonɨŋga avhesi. ");
INSERT INTO spm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mee avhesima, Iesus men dɨɨgha, mee akuvagha kamagh mem mbɨŋgeeghi, “Gee ikaaŋi, igharisir kantrin ativasir tharsi gamgaaŋ ikhevigha phum meŋga aghora meŋga amuima, mee bar mena apheeŋni iti. Men gumasira aphani nona akaava oraghaousua phuvɨra mena afhɨraghɨvɨrasi. ");
INSERT INTO spm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Othevir kharsi gen thooŋni ikaan thughatɨs phatɨ. Gumaghan manav gen thooŋni ikhɨvani ikaaousua, a iŋaaran gumaghan mɨni ikhɨɨ. ");
INSERT INTO spm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Gumaghan manav genɨ ufhuaragh maŋamɨusua, a bar geni iŋaaran gumaghan khɨnan mɨni ikhɨɨ. ");
INSERT INTO spm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gumasir Otar gumasi rako amisi aŋmɨusua iŋaraousua a zesi phatɨ. Phatɨ, a gumasi rako amisivɨusua iŋaraousua zee. A gumasi rako amisira avɨraraousua aremigh nom meŋgu uvhuesigh mee niamɨusua zee.” ");
INSERT INTO spm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesus non suren gumasir phorugha Jerikon guegha, gumasi rako amisira avɨrara men phorugha uŋuun khava thaegha zui. Mauthughura arɨmaghaniiŋ mbɨzesi gumaghan mav, aŋni izɨɨ Bartimeus Timeusɨn otar, a utuavɨm mbɨkeeŋn apheraghav ikhava bisivɨusua azaaghi. ");
INSERT INTO spm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ano orasima Nasaretɨn gumagh Iesus ivɨra za zuima a dɨɨ kamaghɨusue, “Iesus Devitɨn avav, nanɨ ukuarukuvi!” ");
INSERT INTO spm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Am mbɨŋgeema gumasi rako amisira avɨrara dɨman aŋn thɨvagha inɨmɨre ikhaaousuava aŋm mbɨŋgeeghi. Mem mbɨŋgeema am mbɨghɨravɨra dɨɨvɨre iti, “Devitɨn avav nanɨ ukuarukuvi!” ");
INSERT INTO spm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mauthughura Iesusɨ utugha kamaghɨm mbɨŋgeeghi, “Aŋn dɨɨgha.” A mem mbɨkemisima mee arɨmaghaniiŋ mbɨzesi gumaghan dɨɨgha kamaghɨusue, “Nɨɨ gamgaeŋgɨri. Iesus nɨɨn deeghi. Nɨɨ rɨkavigh maaŋɨ.” ");
INSERT INTO spm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","An aŋm mbɨkemisima a nona akɨrani iti shaarɨ usuegha ana ukunigha uzuamɨra rɨkhavigha Iesusɨusua zee. ");
INSERT INTO spm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mauthughura Iesus aŋna azaaghi, “Kɨ nɨɨmɨusua theeghɨna ramuamɨusua nɨɨ vhusvhusi?” An aŋna azarasima arɨmaghaniiŋ mbɨzesi gumagh kamaghɨm mbɨŋgeeghi, “Fhɨghɨn gumagh, kɨ ganamɨusua vhusvhusi.” ");
INSERT INTO spm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","An aŋm mbɨkemisima Iesus kamagh aŋm mbɨŋgeeghi, “Nɨɨ maaŋɨ. Nɨɨ nɨghnɨghana aghavaghar Gotɨni itima, a nɨɨŋga amuisi nɨɨ nom indera.” A maghɨra nomthegha gari. Mauthughura a Iesusɨn gɨnɨ utuavɨn zui. ");
INSERT INTO spm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesus non suren gumasir phorugha Jerusalemɨna aghan gua Betfage ko Betanina aghan Olivɨno oraghɨn oto. Mauthughura Iesus non suren gumaghan phunini amaŋga, ");
INSERT INTO spm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kamagh aniiŋm mbɨŋgeeghi, “Aŋgo munagh itirɨ uŋuun maaŋɨ, gantima donkini ikaman mav, mee ana ikhesima, a iti. Gumagha thavɨ uthugh thavɨn aŋga apheraghava aruisi phatɨ. Aŋgo anɨ umbueeŋ afhɨrighɨva aŋnɨ usuiragh khagh zɨɨ. ");
INSERT INTO spm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Thav aŋgona azaaŋm mbɨkɨmaŋga, ‘Aŋgo thoghousua donkia fhɨri?’ Aŋgo kamagh aŋm mbɨkɨm, ‘Ikhɨv iŋaar aŋni iti. Aŋni iŋaar gɨvaghti a nomthegha ana amandaghti a zaami.’ ” ");
INSERT INTO spm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ana aniiŋm mbɨkemisima aniiŋ gua garima, donki mee rɨphenani itɨmana akamaniiŋna akɨranɨ utuavɨn ana ike. Mauthughura aniiŋ ana fhɨrima, ");
INSERT INTO spm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","gumasir marsi utuivighav ikha aniiŋna azaaghi, “Aŋgo thoghousua donkinɨ umbueeŋ afhɨri?” ");
INSERT INTO spm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mem mbɨkemisima Iesus aniiŋm mbɨkemisi moghɨn aniiŋm mena akam ikara. Mauthughura gumasi aniiŋm mbɨnamɨnaaŋ athɨsima aniiŋ zui. ");
INSERT INTO spm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Aniiŋ donki nigha Iesusɨusua zeghava nona akɨrani itir shaaraniiŋ usuegha donkini iphɨa athɨ. Aniiŋ shaaraniiŋ athɨsima Iesus aŋni iphɨ aphera. ");
INSERT INTO spm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mauthughura gumasi rako amisira avɨrara nona akɨrani itir shaari usuava utuavɨna anda ughuari. Marsi uruaŋn therɨsosia rɨghorigha anda arɨsi. ");
INSERT INTO spm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ufhuaragha zui tharsi rako gɨn zui tharsi mee dɨɨva arava kamaghɨm mbɨŋgeeghi, “Inighinighɨri! Got inderaghavɨra Iesusɨa amuigha gɨva. Ee Gotɨni izɨɨ ufhɨri! Gumaghan khav Ikhɨvani izɨɨ koma aghavagharan zii. ");
INSERT INTO spm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ena avav Devit fhomɨra eŋga ativasi moghɨn gumaghan khav thighira mamaghɨra eŋga ativami. Kamagha amuisi Got inderaghɨvɨra Iesusɨ ramutima a eŋga ativami. Inighinighɨri! Gotɨnɨ uŋuuni iti bisi bar aŋni izɨɨ ufhɨri!” ");
INSERT INTO spm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Gumughun Iesus Jerusalemɨna aven gugha guava Gotɨ rɨphenam mbɨroghɨn gu. A gugha bisir garava andara asavɨusuisi. Amɨn phɨraousuava amuima a non suren gumasir phorugha mee Betanin zee. ");
INSERT INTO spm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Amɨrɨtusi Iesus non suren gumasir phorugha nomthegha Betania thaegha zuima, Iesusɨm mbɨti aŋna azi. ");
INSERT INTO spm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A isaghun garima fhighɨn khan mavɨna afharire iti. Mauthughura ana aghangera maaŋɨ ikhaaŋmɨusua ana aghae iti, o phatɨ. Khara fhisir thee beerɨ uthugh phatɨ. Kamagha amuisima a guava ovɨgha thavɨn ganisi phatɨ, afharir kɨnira aŋni iti. ");
INSERT INTO spm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mauthughura a kamagh khan khavɨm mbɨŋgeeghi, “Thav gɨn nɨɨno ovɨgha thava rameghem thughathɨgham phatɨghami.” An aŋm mbɨkemisi, aŋn suren gumasi oraghi. ");
INSERT INTO spm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iesus non suren gumasir phorugha Jerusalemɨn otuivigha, Iesus Gotɨ rɨphenam mbɨroghɨn gua gumasi asɨsi amaŋga andaghɨ uvhuesi tharsi mem mbatosi. Ana aŋgɨro ovɨsi nori ikarvasi gumasir akosi rako ukurasir buniiŋmba amandi tharsir ambirembii, anda ufhava anda asiaghɨusue. ");
INSERT INTO spm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A bisi amaŋga anda niagha arui tharsi vɨŋgɨva Gotɨ rɨphenam mbɨroghɨna aven zɨɨ maŋan men thɨva. ");
INSERT INTO spm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A men surea amuava kamagh mem mbɨŋgeeghi, “Mbɨŋgɨmɨŋgɨr kharsi Gotɨm mbɨgharano osɨrani iti, o phatɨ? ‘Na rɨphenani iŋaaram mbɨnɨɨŋ kamaghɨn, kha unuaghɨnan gumasi rako amisi bar mee Gotɨn phorugham mbɨŋger rɨphen.’ Gee okeer gumasi mondira aŋanan mɨn aŋga amui.” ");
INSERT INTO spm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Gumasi rako amisira avɨrara bar aŋn surem mbɨŋgɨmɨŋgɨva oraegha rɨŋgavan maghatɨgha amui. Kamagha amuisima Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii rako Judariro othevi ikeeŋsi gumasi Iesusɨn atitiiŋga, mee aŋm mbɨsueghtima ana aremighaousua maghɨra utuavivɨusua urui. ");
INSERT INTO spm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aro gevima Iesus non suren gumasir phorugha mee Jerusalemɨnɨ uŋuuni ikhɨva thaegha akɨran zii. ");
INSERT INTO spm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Amɨrɨtusi rɨmaaŋra Iesus non suren gumasir phorugha gua garima fhighɨn khan bii ivɨram mbɨsɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita nɨndɨgha Iesusɨm mbɨŋgeeghi, “Fhɨghɨn gumagh, nɨɨ gan, nɨɨ booghuma asɨghasɨghaousuam mbɨkemisi fhighɨn kɨ, am mbɨsɨɨŋi!” ");
INSERT INTO spm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesus aŋm mbɨŋgɨŋgɨm ikaragha kamagh mem mbɨŋgeeghi, “Nɨghnɨghana aghavaghar Gotɨni ikhɨɨ. ");
INSERT INTO spm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kɨ guisimbaaŋra gem mbɨŋgeeghi. Thɨɨŋra nɨghɨnɨghana aghavaghar Gotɨni ikhɨva oragh thavɨm mbɨkɨm, ‘Got nɨɨ kha oraghɨnɨ usuiragh ana ufhegh oŋarao ukuni.’ Nɨɨ khamaghɨm mbɨkemightima, a nombɨ ufhegh oŋarao ukunighemi. A non navana aven nɨghɨnɨghan phunini phatɨghɨva, nɨghɨnɨghana aghavaghar ikɨɨm mbɨkɨmtima kha bighaaŋ otoghomi. ");
INSERT INTO spm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kamagha amuisima kɨ gem mbɨŋgeeghi, gee bigha thav niamɨusua nɨghɨnɨghana aghavaghar ikɨɨm mbɨkɨmaŋga, ‘Got anan eera aniiŋgemi.’ Kamaghɨn Got anan geera aniiŋgemi. ");
INSERT INTO spm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Nɨɨ uthughɨva Gotɨn phorughum mbɨkɨmɨva osɨmndɨgh thɨɨŋni iti, nɨɨ aŋno othɨvhan maghatɨgh gɨna amandaghti, kamaghɨn nɨɨni Inaghavesɨni Ikhɨv, nonɨ uŋuuni iti thav, a ivɨra nɨɨno othevir maghatɨsi gɨna amaaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iesus non suren gumasir phorugha nomthegha gua Jerusalemɨn otogha Iesus Gotɨn rɨphenam mbɨroghɨna avena aruima, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii rako Judariro othevi ikeeŋsi gumasi rako Judarir gumasira aphani aŋmɨusua zee. ");
INSERT INTO spm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mee zegha Iesusɨna azaaghi, “Nɨɨ manmaghɨra kha izɨɨ nigha kha bisigha amui? Thɨɨŋra kha izɨɨni ikhɨvan nɨɨŋga anɨɨŋi?” ");
INSERT INTO spm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mem mbɨkemisima Iesus mee ikara, “Kɨ ivɨra azaaŋsɨghan mavɨn gee ramuamɨusua gee inderaghɨvɨra nani iŋgarɨgha ramuightima, kɨ gem mbɨkɨmaŋga, thɨɨŋra kha bisi ramuaŋgamiri izɨɨni ikhɨvan naŋga anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonɨnɨ uruur khara Gotɨn bighɨn, o gumaghan bighɨn? Nam mbɨkɨm!” ");
INSERT INTO spm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mauthughura mee norira nori vɨkemigha kamaghɨusue, “Ee kamaghɨm mbɨkɨmaŋga, ‘Aŋnɨ uruur Gotɨn zee.’ A nomthegh kamagh eem mbɨkɨmaŋga, ‘Gee manmagha amuigha nɨghnɨghana aghavaghar Jon ramuani iphɨrphɨri?’ ");
INSERT INTO spm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Eem mbɨkɨmaŋga, ‘Aŋnɨ uruur gumaghan zee.’ ” Kha akam ivɨra thughatɨs phatɨ. Gumasi rako amisira avɨrara mee ikaaŋi, Jon a guisimbaaŋra Gotɨna akam nigha zesi gumagh, kamagha amuisi mee kha gumasi rako amisir atitiiŋi. ");
INSERT INTO spm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mauthughura mee Iesusɨna azaaŋsɨgh ikaragha kamaghɨm mbɨŋgeeghi, “Ee ikeeŋs phatɨ.” Mem mbɨkemisima Iesus kamagh mem mbɨŋgeeghi, “Kamaghɨra, kɨ noni izɨɨ nisirɨ utuavɨn, gun gem mbɨkemighem phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesus aghunambara akaar Judarir gumasira aphanim mbɨŋgeeghi, “Gumaghan mav uainir mɨghɨ opharigha aŋn rɨvɨna aghui. Uainiro ovɨsi mɨghɨmɨghamiri ithaaŋgɨ ukuighava maghɨra a rɨphenaŋga amui. Mee kha rɨphenani iphɨni ikhɨva uainir mɨghɨn ganaŋgami. Gumughun a uainir mɨgh nigha uainir mɨghɨn ganaŋgamir gumasir marsi meŋga anɨɨŋi. Mee gɨnɨ uainiro ovɨsiri imboori tharsi nomthegha ana ikaraghami. Gumughun a igharagha isaghun gu. ");
INSERT INTO spm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gumughunɨ uainiro ovɨsi ukuaramirɨ uthugho otosi, uainir mɨghɨn guav iŋaaran gumaghan mava amandasi a uainiro ovɨsi tharsi niamɨusua uainir mɨghɨn garir gumasivɨusua gu. ");
INSERT INTO spm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ana otosima, mee aŋnɨ usuiragha, aŋm mbɨsuegha ana amandasi ana afharɨra nomthee. ");
INSERT INTO spm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Gumughun guav iŋaaran gumaghan igharisi thav amandasima, mee aŋm mbɨsogha aŋna aphana biigha amemerano othevir aŋga amui. ");
INSERT INTO spm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Gumughun guav nomthegham mbɨkethava amandasima, mee aŋm mbɨsuesi ana aremi. Gumughun a ivɨra igharis marsi samɨra amaaŋi. Marsi mee phura mem mbɨsoghi, marsi mee mem mbɨsuesi mee arɨɨghire. ");
INSERT INTO spm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Gumughun bar ambuunav iti ana ana amaaŋmɨusua, aŋno otaran khavɨra, a bar aŋn vhusvhusi. A bar men gɨn ana amaŋgava kamaghɨm mbɨŋgɨ kamaghɨusue, ‘Mee nano otaran khavɨna akamam mbaraeghɨva inderagh aŋ ramuaŋgami.’ Mauthughura ana na amandasi a gu. ");
INSERT INTO spm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Thighira uainir mɨghɨn garir gumasi kamagh nori vɨŋgeeghi, ‘Kha otar kha uainir mɨghɨn guava amendaghti. Aria, ee nori nigh aŋm mbɨsueghtima ana aremighemi. Gumughunɨ uainir mɨghɨn khav, ee norira aŋn gueeŋ ameeŋgemi.’ ");
INSERT INTO spm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mauthughura mee aŋnɨ usuiragha aŋm mbɨsuesima ana aremisi, mee ana nigha uainir mɨghɨn akɨran ana ukuni. ");
INSERT INTO spm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Thighira uainir mɨghɨn guav manmagh ramuti? A zɨva uainir mɨghɨn garir gumasir kharsi vɨsueghtima mee arɨmɨghireghemi. Gumughun a uainir mɨgh nighɨva igharis tharsi ranɨɨŋga. ");
INSERT INTO spm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Gee Gotɨm mbɨgharano osɨran khavɨn ganis, o phatɨ? ‘Akɨman khav rɨphenaŋga amuir gumasi aŋgi iphɨrphɨrigha aŋm mbatuesima, Ikhɨv thighira aŋga amuisi a rephenaŋgi isaghuphusir akɨmaŋgi ighesima gumasi rako amisi aŋn ganigha rɨŋgavan maghatɨgha amui.’ ” ");
INSERT INTO spm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Thighira mee ikaaŋi aŋna aghunamana akaman meŋga asi, kamagha amuisima mee aŋnɨ usuiragh ana niamɨusua utuavivɨusua urui. Mee aŋnɨ usuighaousua gumasi rako amisir atitiiŋga, ana thaegha gue. ");
INSERT INTO spm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gumughun Judarir gumasira aphani ko Farisiiŋn marsi koma Herotɨn gɨna arui tharsi mee, mee amandasi, mee Iesusɨusua zee. Mee Iesusɨm mbɨŋgɨŋgɨro othɨvha thavɨn ganigh aŋnɨ usuiraghousua. ");
INSERT INTO spm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mee zegha kamaghɨm mbɨŋgeeghi, “Fhɨghɨn gumagh, ee ikaaŋi, nɨɨ mɨghasɨgha guisimbaaŋram mbɨŋgɨva, mbɨŋgɨŋgɨrɨ uvarsira gumasi rako amisi bar meŋga anɨndi. Gumasi izɨɨri iti tharsi o gumasir khɨni, nɨɨ akamanɨ uvavɨra mem mbɨŋgɨva guisimbaaŋra Gotɨn othevir men surea amui. Ee Gotɨn othɨvhan gɨn maŋɨva, gavmanɨna aŋgɨro ovɨsi Sisar ranɨɨŋgami o phatɨghami? Ee uvhuesami, o uvhuesam phatɨghami?” ");
INSERT INTO spm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mem mbɨkemisima Iesus men khori ikeeŋga kamagh mena azaaghi, “Gee thoghousua nan khorigha amui? Akɨmano ovɨgha thav namɨusua ana nigh zɨɨti kɨ aŋn ganaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Am mbɨŋgeema mee akɨmano ovɨgh aŋmɨusua ana nigha zesi a mena azaaghi, “Thɨɨŋni iŋeendaghani izɨɨ khara?” A mem mbɨkemisima mee kamagh Iesus ikara, “Sisarɨni iŋeendagh.” ");
INSERT INTO spm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mem mbɨkemisima Iesus kamagh mem mbɨŋgeeghi, “Kamaghɨra, gee Sisarɨn bisi Sisar ranɨɨŋva, Gotɨn bisi nigh, Got ranɨɨŋ.” Mauthughura mee aŋni iŋgarɨghan rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Sadiusiiŋn, mee kamagh nɨghɨnɨsi, gumagha aremigh nomtheghɨ rɨkavighem thughatɨs phatɨ. Kamagha amuigha mee Iesusɨna azaaŋsɨghaousua zee. Mee zegha kamaghɨm mbɨŋgeeghi, “Fhɨghɨn gumagh, Moses fhomɨra kamagh emɨusua osɨri, gumagha aremigh nona amuuŋ thaeghɨva boori phatɨghtima ana afhoghumasir mavɨn amuuŋno osɨɨŋni ikhɨva aŋmɨusua boorir niaŋga. ");
INSERT INTO spm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","21","Uthughun mavɨn 7 pɨla afhoghumasi iti. Avenafhes amuuŋni ikha boorir phatɨgha aremisima, nom undooghan aŋgi inesi thav aŋni ikha boori phatɨghava ivɨra aremi. Gumughum mbɨkethav kamaghɨrama amui. ");
INSERT INTO spm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Gumughun 7 pɨla afhoghumasir kharsi bar mee aŋni ikha, boori tharsi nisi phatɨgha arɨɨghire. Gumughun ambuuŋn, amigh ivɨra aremi. ");
INSERT INTO spm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Afhoghumasir 7 pɨla aŋni ike. Kamagha amuisi a nomtheghɨ rɨkavamirɨ uthugh, a thɨɨŋna amuuŋra?” ");
INSERT INTO spm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mem mbɨkemisima Iesus kamagh mee ikara, “Gee Gotɨm mbɨgharano osɨr ko Gotɨn gamgaaŋ ikeeŋsi phatɨ, kamagh gee iphasa nɨghnɨgham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Arɨghireghemi tharsi rɨkavamirɨ uthughun, gumasi amuiri ikaami thughatɨs phatɨ, ivɨra mee amisi nigh gumasi rariighem phatɨghami. Mee enselir mɨn Gotɨnɨ uŋuuni ikaami. ");
INSERT INTO spm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Arɨghires tharsi nomtheghɨ rɨkavamir bisivɨusua, gee Mosesɨm mbɨgharana aven sisi khan niaghagh gee aŋn ganisi, o phatɨ? Niaghaghan khavɨn, Got kamagh Mosesɨm mbɨkemi, ‘Kɨ Abraham, ri Aisak koma Jekovɨn Got.’ ");
INSERT INTO spm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Got gumasir niro ofhɨsir arɨghiri tharsi, men Got phatɨ, a gumasirɨ unduura aŋamɨre iti tharsir Got. Gee bari iphasa nɨghnɨgham mbɨŋgeeghi.” ");
INSERT INTO spm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iesus Sadiusiiŋn phorugha mee nori vatosima Judariro othevi ikeeŋsi gumaghan mav za mem mbarasi. Ano orasima Iesus ikarvaghana aghuuŋn meŋga aniiŋsima, a Iesusɨna azaaghi, “Gotɨn othɨvhan manavɨra marsi bar andagha afhiragha, ufhuaragha zui?” ");
INSERT INTO spm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Am mbɨŋgeema Iesus ana ikara, “Othɨvhan bari ikhɨɨvara khara, ‘Israeliiŋa, gee oragh. Eni Ikhɨv a en Got. A nombɨra eni Ikhɨv. ");
INSERT INTO spm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gen non navira averi rako nonɨ unduu rako non nɨghɨnɨsi rako gamgaaŋn ivɨra aŋn vhusvhusighiri.’ ");
INSERT INTO spm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aŋgi inesiro othɨv khara, ‘Nɨɨ nombɨn vhusvhuisi moghɨra gumasi rako amisi bar men vhusvhusighiri.’ Nom othɨvha thav kaniiŋn mɨni ikhevigha aniiŋga afhirasi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mauthughura kha gumagh kamagh Iesus ikara, “Nɨɨ guisimbaaŋram mbɨŋgɨ kamaghɨusue, Got nombɨra, thav nom iti phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ee non navira averi rako, non nɨghɨnɨsi rako non gamgaaŋni Ikhɨvan vhusvhusighiri. Mamaghɨra nɨɨ nombɨn vhusvhuisi moghɨra gumasi rako amisi bar men vhusvhusighiri. Ee kha othɨvhaniiŋ gɨn maaŋɨtima, mee phurama aphuraphurir aghaer bisi rako arivan bar sisira aghaer bisira aphuraphuri tharsi andagha afhiraghami.” ");
INSERT INTO spm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesus orasima a inderaghavɨram mbɨkemisi, Iesus aŋm mbɨŋgeeghi, “Got kha bisigha ativamirɨ uthugh nɨɨ aŋni isaghuni iti phatɨ.” Mauthughura thighira mee nomthegha azaaŋsɨgha thavɨn nomthegh Iesus ramuan atitiiŋi. ");
INSERT INTO spm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesus Gotɨ rɨphenam mbɨroghɨn gumasi rako amisir surea amuava, mena azaaghi, “Manmagha amuisi Judariro othevi ikeeŋsi gumasi kamaghɨm mbɨŋgɨ kamaghɨusue, Krais, Got nom ee niamɨusua mbɨsevisir gumagh, a Devitɨn avav? ");
INSERT INTO spm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devit nombɨ, Gotɨnɨ Utum nɨghnɨghan khavɨn aŋga aniiŋsi, a kamaghɨm mbɨkemi, ‘Got kamagh nani Ikhɨvam mbɨŋgɨ kamaghɨusue, “Nɨɨ khagh nana agharan guvɨn rapheragh, mamaghɨra ikhɨtima kɨ nɨɨna aphanir gumasi rɨkambuuŋtima mee nɨɨna apheeŋni ikaami.” ’ ");
INSERT INTO spm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit nombɨ ‘Ikhɨvan’ gumaghan khavɨ athɨ. Manmagh amuigha gumaghan khav nomthegha Devitɨn avav?” Am mbɨŋgeema gumasi rako amisira avɨrara aŋm mbɨŋgɨmɨŋgɨv oraegha bari iphui. ");
INSERT INTO spm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesus gumasi rako amisir surea amua kamaghɨm mbɨŋgeeghi, “Gee Judariro othevi ikeeŋsi gumasivɨusua ganighɨri. Mee shaarirɨ uruaria sharigh rarutima gumasi rako amisi mee bisi amaŋga andaghɨ uvhuesira aŋanani izɨriri ikiir mee ranɨɨŋmɨusua, mee bar vhusvhusi. ");
INSERT INTO spm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mee Gotɨn phorugham mbɨŋger rɨphenir ambirambir aghuuira niva, ishari ikiirɨ uthugh mee aŋaniri izɨɨri iti tharsi niamɨusua bar vhusvhusi. ");
INSERT INTO spm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mee pha arɨghiresi amisir ozɨrir khoru amua men rɨphenir bisi nia, kamaghɨusue ee indera. Mee, gumasi meni izɨɨri ufhaaousua, kamagha amuigha mee Gotɨn phorugham mbɨŋgerɨm mbɨŋgɨmɨŋgɨrɨ uruarigha amui. Kamagha amuir gumasi, menɨ uvhuesan maghatɨgh gumasi othevir maghatɨsigha amui tharsirɨ uvhues bar aŋga afhiraghami.” ");
INSERT INTO spm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesus guava aŋgɨro ovɨsi arɨsi ithaaŋna aghan apheraghav ikhava gumasi rako amisir avɨrar garima mee nona aŋgɨro ovɨsi nigha Gotɨn rɨphenana aŋgɨro ovɨsi arɨsi ithaaŋn anda arɨsi. Gumasi rako amisi aŋgɨro ovɨsira avɨrare iti tharsi aŋgɨro ovɨsira avɨrara arɨsi. ");
INSERT INTO spm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mauthughura mana aremisira amighano osɨɨŋ bisi phatɨgha zava akɨmano ovɨghan phunaŋgɨniiŋ athɨ, aniiŋ akɨmano ovɨghanɨ urughanɨ uvavɨra aŋn mɨn gu. ");
INSERT INTO spm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mauthughura Iesus non suren gumasir dɨɨgha kamaghɨm mbɨŋgeeghi, “Kɨ guisimbaaŋra gem mbɨŋgeeghi mana aremisiro osɨɨŋna amighan khav bisi phatɨgha akɨmano ovɨghan sovan phunaŋgɨni aŋgɨro ovɨsi arɨsiri ithaaŋga athɨsi aŋna akɨmano ovɨghan phunaŋgɨni gumasiri igharis tharsi arɨsira aŋgɨgha afhira. ");
INSERT INTO spm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mee nona aŋgɨro ovɨsir avɨraghi ithɨrɨpiiŋga aŋgɨro ovɨsirɨ uvhovhera anɨɨŋi. Amighan khav nona ambirambiin maghatɨghan mɨra akɨmano ovɨghan ambuunani athɨgha a nomthegha aghaeghɨ uvhuesamira aŋgɨro ovɨsi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesus Gotɨ rɨphenam mbɨrogha thaegha akɨran zima, aŋn suren gumaghan mav am mbɨŋgeeghi, “Fhɨghɨn gumagh! Nɨɨ gan, khara aŋgɨr bar ikiira, mee andar Gotɨ rɨphenani iŋarisima, aŋn gangan bar indera! Gotɨ rɨphen ko rɨphenir sovseghe aŋm mbɨroghɨni iti tharsi, anda bar rɨphenir rɨŋgɨrir aghuuira!” ");
INSERT INTO spm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mem mbɨkemisima Iesus kamagha ana ikara, “Nɨɨ rɨpheniri ikiir kharsir gari? Anda bar maghatiighemi. Gumughuna aŋgɨr kharsi, gumasi bar anda uphueghtima anda barbar daaŋgi ireghemi. Thav thavɨni iphɨni ikeghem phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesus Olivɨno oraghɨni iphɨn, Gotɨ rɨphen khoman aŋna aghuagha apheraghav itima, Pita ri Jems koma Jon ri Andru mee norire ikhava aŋna azaaghi, ");
INSERT INTO spm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Eem mbɨkɨmɨva, rɨpheni maghatiighemir bighaaŋ, a mana uthughun otuivti? Othɨvhan manavɨ ufhuaragh otuivtima, ee ikeeŋgɨm mbɨkɨmaŋga bisir kharsi otuivamirɨ uthugha aghangera zee?” ");
INSERT INTO spm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mem mbɨkemisima Iesus kamagh mem mbɨŋgeeghi, “Gee norivɨusua inderaghɨvɨra gan, gumagha thav zɨɨ gen khorir amuan thaghri. ");
INSERT INTO spm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gumasira avɨrara nani izɨɨn zɨɨ, mbɨkɨmaŋga, ‘Kɨ Krais, Got nom ee niamɨusua mbɨsevisir gumagh.’ Kha gumagh gumasi rako amisir avɨrar khori ramuaŋga. ");
INSERT INTO spm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Uthughun khavɨn gee aghangera itir asaghuuri ikiir nɨnɨiva oraghɨva, isaghuni iti mbɨzorsiri ikiira akaava oraghami. Kha uthughun gee rɨŋgavan maghatɨgha ramuan thaghɨri. Othevir kharsi otuivightima, unuaghɨnan khav gɨvamirɨ uthugh thighar zaami. ");
INSERT INTO spm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kantrin mavɨni iti tharsi rɨkavigh igharisir kantriri iti tharsir phorughum mbɨsoghomi. Kha uthughun ativasir gumaghan mavɨna andarsi rɨkavigh igharisir ativasi gumaghana andarsir phorughum mbɨsoghomi. Aŋanir tharsi aghae bar phatɨghtima, gumasi rako amisi vɨtiire ikaami. Mbɨkɨmɨkɨsi ivɨra igharisi uŋuimbar otuivami. Kha bisi, amighɨ ufhuaraghɨvɨra otaasa mbɨzagh nighɨva gumughun ano otara otaami, osɨmndɨsir kharsi ivɨra kamaghɨra otuivami osɨmndɨsir kharsi ufhuaraghɨvɨra otuivtima unuaghɨnan khav gɨvamirɨ uthugh thigharɨ. ");
INSERT INTO spm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Gee inderaghɨvɨra norira norivɨusua gan. Gen gumasi tharsi gee nighɨ uŋuimbar garir gumasir ranɨɨŋga. Mee Gotɨn phorugham mbɨŋger rɨphenir gem mbɨsoghomi. Gee nani izɨɨnɨ utuivisi tharsi, gee gavmanɨn gumasiri ikiir arɨmasi rɨfhaaŋnɨ uthughɨva, kɨ amuisi bisi, gee andar gun mem mbɨkemighemi. ");
INSERT INTO spm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gumasi tharsi ufhuaragh maŋɨ Gotɨna akamana aghuuŋn gun gumasi rako amisi kha uŋuimbari itir akaa uvhaghuvhagha andav vɨkɨmɨri. Gumughun kha unuaghɨn gɨvami. ");
INSERT INTO spm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gumasi tharsi mana uthughun genɨ usuiragh gee nigh osɨmndɨsiva oragha anda rɨkɨrir rɨphenan maŋɨtima, gee ufhuaraghɨm mbɨkɨmɨusua nɨghɨnɨsir avɨri nia thaghri. Nɨɨ mbɨkɨmɨusua, Got nɨghɨnɨsir nɨra anɨɨŋti nɨɨ mbɨze vɨkɨmaŋga. Khara nɨɨ nombɨram mbɨŋge phatɨ, Gotɨnɨ Utum mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Afhoghumasi norira nori nigh aphanir gumasir anɨɨŋtima mee mem mbɨsoghti mee arɨmɨghireghemi. Inasi non boori ivɨra kamaghɨra andara amuaŋga. Boori noni inasi rako inaghamuuira akaava athoghɨva arɨmaŋgamiro othevir mee ramuighti, mee arɨmɨghireghemi. ");
INSERT INTO spm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Uthughun khavɨn gumasi rako amisi bar nani izɨɨusua navan maghatɨghan geni ikaami. Thɨɨŋra uthugha aghavagharigh maaŋɨ ana aremighemirɨ uthugho otoghtima Got ikɨrana aghuuŋ gɨn aŋra anɨɨŋgami.” ");
INSERT INTO spm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Iesusɨm mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Gee gantima Got bari iphɨrphɨrisi bigh aŋ rɨphenani ikaami. Khara a ikhaam phatɨghamira aŋan. A ikɨthi, Got no rɨphena thaeghemi. Nɨɨ thɨɨŋra osɨɨran khavɨn ganigh, inderaghavɨra nɨghɨnɨghɨva ana ikeeŋgɨri. Got bari iphɨrphɨrisi bighan khav, uthughun khavɨn otoghtima Judian distrighɨna aveni iti tharsi mee uzuamɨra arɨ orasira anaeŋgɨri. ");
INSERT INTO spm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Thav rɨphenan akɨrani ikeghɨva nomthegha aven maaŋɨ non bigha thav nia thaghɨri. ");
INSERT INTO spm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Thav mɨghɨni ikhɨvani ikeghɨva nomthegh rɨphenan maaŋɨ nona akɨran sarir shaar nia thaghɨri. ");
INSERT INTO spm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Naviri itira amisi rako boori otee aphiri inaghamuui mevɨsi. Uthusir kharsi zaami, mee bar maghatiighemi! ");
INSERT INTO spm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Uthusir kharsi zaami, anda osɨmndɨsiri ikiirɨ uthusi. Got unuaghɨn ko ovheea amuisi uthughun za thighira, kamagha amuisiro osɨmndɨgha thav kamagha otosi phatɨ. Uthugh thav nomthegh kamagh otoghom phatɨghami. Kamagha amuisi gee Gotɨn phorughum mbɨkɨmtima osɨmndɨsiri ikiir kharsi amoghɨnɨ uthughun otuiva thaghɨri. ");
INSERT INTO spm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ikhɨv nombɨusua mbɨsevisi gumasi rako amisi norighi nɨghnɨgha, uthughun maghatɨghan khavɨnɨ uthusir marsia rɨghorisi anda muaŋ othevi. A ti andar rɨghoris phatɨsi gumasi rako amisi bar arɨghireghaghi. ");
INSERT INTO spm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Zaamirɨ uthugh, thav gem mbɨkɨmaŋga, ‘Gee gan, Kraisɨra khara! A Got nom ee niamɨusua mbɨsevisir gumaghara,’ o, ‘Gee gan, Kraisɨra muna!’ Ana akamam mbaraghan thaghri! ");
INSERT INTO spm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gumasi tharsi zɨva gen khori ramu kamaghɨusuami, ‘Kɨra, Got gumasi rako amisi nom mee niamɨusua mbɨsevisi gumagh,’ o ‘Kɨ Gotɨna akam nigha ziir gumaghan mav.’ Maghɨra mee non gamgaaŋ khɨvamir bisiri ikii rako rɨŋgavan maghatɨgha amuiro othevi ramuti anda otuivami. Mee kamagh vhusvhusi, mee gumasi rako amisir khorira amutima mee oŋanighemi. Mee aghavaghar ikhɨva, ivɨra Got nombɨusua mbɨsevisi gumasi rako amisi, mee ivɨra men khori ramuamɨusua. ");
INSERT INTO spm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kɨ gɨno otuivamir bisi bar andar gun gem mbɨkemi. Kamagha amuisi gee inderaghavɨra norivɨusua ganɨri.” ");
INSERT INTO spm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Iesusɨm mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Osɨmndɨsiri ikiir kharsirɨ uthugh gɨvaghtima, gɨn zaamirɨ uthughun bisir kharsi otuivami. Aro gɨngɨnighemi. Ikɨni isiragham phatɨghami. ");
INSERT INTO spm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mbɨkovi ovheen asighireghemi. Ovheeni itir bisira aghavaghari, usuaghusuaghava, nona aŋania thamɨraeghemi. ");
INSERT INTO spm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Uthughun khavɨn gumasi ganti Gumasir Otar aghavagharani ikhɨv ko aŋarani ikhɨva samɨra guan thooŋn zaami. ");
INSERT INTO spm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A non enseli amandaghti mee maaŋɨ ovhee ko unuaghɨnano othevi bar andar maŋɨva Gotɨm mbɨsevisi gumasi rako amisi mee akuvigh aŋmɨusua zaami.” ");
INSERT INTO spm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iesusɨm mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Fhighɨn khan aŋguu nomtheghɨm mbɨkovtima gee ikeeŋgɨm mbɨkɨmaŋga, amoghɨnɨ uthugha aghangera zee. Gee fhighɨn khan gan nɨghɨnɨsi niaŋga. ");
INSERT INTO spm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kamaghɨra gee bisir kharsir ganti anda otuivtima gee ikeeŋgɨm mbɨkɨmaŋga, Gumasir Otar a nom zaamirɨ uthugha aghangera zee. A itɨmana akamaniiŋnɨ uthughav iti. ");
INSERT INTO spm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kɨ guisimbaaŋra gem mbɨŋgeeghi. Uthughun khavɨni iti gumasi rako amisir kharsi ikhɨvɨre ikɨthima bisir kharsi bar otuivami. ");
INSERT INTO spm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ovheen ko unuaghɨn gɨvaghami, nam mbɨŋgɨmɨŋgɨ gɨvagham phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iesusɨm mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Thav ikeeŋsi phatɨ, uthughun manavɨra kɨ gem mbɨŋger bisir kharsi otuivti. Gotɨnɨ uŋuuni itir enseli ko Gotɨn Otari ivɨra ikeeŋsi phatɨ. Afhesɨni Ikhɨv nombɨre ikaaŋi. ");
INSERT INTO spm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gee uthughun khavɨn zaamirɨ uthughi ikeeŋsi phatɨ. Gee inderaghɨvɨra norivɨusua gani ikhɨɨ. ");
INSERT INTO spm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kha uthughun gumaghan mav igharagha zui moghɨn. A no rɨphena thaegha guava no rɨphen nigha noni iŋaarir gumasir afharɨ arɨghava rɨphenani iŋaaria rɨghorava meŋga anɨndi. A itɨmana akamaniiŋni itir gumagham mbɨŋgɨ kamaghɨusue, nɨɨ inderaghɨvɨra gan. ");
INSERT INTO spm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Rɨphenan guav zaamirɨ uthugh gee ana ikeeŋsi phatɨ, a boŋgaara zaami, o rɨmaaŋnarɨghan zaami, o utuari afhuti a zaami, o amɨni itiraghti a zaami, o? Kamagha amuisima gee inderaghɨvɨra ganɨri. ");
INSERT INTO spm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Phatɨghtima, a uzuamɨra otogh gen ganti, gee rakuvɨre ikaami. ");
INSERT INTO spm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kɨ gem mbɨŋger bisir kharsi, kɨ gumasi rako amisi bar mem mbɨŋgeeghi, ‘Gee inderaghɨvɨra ganɨri!’ ” ");
INSERT INTO spm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iis phatɨsirɨ uvisirɨ uthuuri ishamaŋga amuirɨ uthugh koma Israeli Got nomthegha mee nisirɨ uthughuni ikhɨvanɨ uthughun phuninira ikhavɨre iti. Kha uthughun Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii, koma Judariro othevi ikeeŋsi gumasi, momooŋno othɨvha thavɨn Iesusɨnɨ usuiragh aŋm mbɨsueghti ana aremighaousua utuavivɨusua urui. ");
INSERT INTO spm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mee kamagh nori vɨŋgeeghi, “Ee ishamanɨ uthughun aŋnɨ usuighem thughatɨs phatɨ. Ee ramuightima ishamani iti gumasi rako amisi mbɨzorughani ikhɨva thavɨn ee ramuighemi.” ");
INSERT INTO spm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesus Betaninɨ uŋuuni ikhava mamburan arɨmarɨm itir gumagh Saimon rɨphenana aven aghaana akoghɨna aphava apheraghav iti. Ana aphava apheraghav itima, amighan mavɨm mbughuna aghuuŋ zuirɨm mburueŋn mav nigha zii. Ana akɨmana aghuuŋna amuisi mbɨsɨvani iti. Aŋnɨ uvhues bari iphɨni iti. Amighan khavɨm mburueŋn khav nigha Iesusɨusua zegha mburueŋm mbɨsɨva bigha mburueŋn Iesusɨna aphanaŋ giŋe. ");
INSERT INTO spm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma uthughuni iti tharsi mee navi siava kamagh nori vɨŋgɨvɨre iti, “Theghousua kha mburueŋn mbughuna aghuuŋ zui thav amighan khavi iphasava aŋga amui? ");
INSERT INTO spm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","An ana amandaghɨva aŋgɨro ovɨsira avɨrara nighaghi. Aŋnɨ uvhues ombaranɨ uvavɨranɨ uvhues aŋga afhira. Gumughun ana aŋgɨro ovɨsi phatɨsi tharsira akuruvaghami.” Mauthughura mee phuvɨra aŋga avhesi. ");
INSERT INTO spm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mem mbɨkemisima Iesus kamaghɨm mbɨŋgeeghi, “Ana thaghi. Gee thoghousua osɨmndɨghan aŋga anɨndi? Ana thaghi! Ano othɨvhana aghuuŋn naŋga amui. ");
INSERT INTO spm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bisi phatɨsi tharsi mɨghasɨgh gen phorugh ikaami. Gee mana uthughun mena akuruvaghan nɨghnɨgh zɨɨti gee mena akuruvaghami. Kɨ mɨghasɨgh gen phorugh ikhan thughatɨs phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kɨ aremightima ana ramuaŋgamir bighaaŋ, ana anaaŋga amui. A ufhuaraghɨm mbughuna aghuuŋ zuirɨm mburueŋ nam mbɨkarɨgh aghevightima mee gɨn na umoghɨ rarɨghami. ");
INSERT INTO spm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kɨ guisimbaaŋra gem mbɨŋgeeghi, mee unuaghɨnan khavɨna aŋanan manavɨn Gotɨna akamana aghuuŋ ukunɨva amighan khava amuisiro othɨv ivɨra aŋm mbɨkɨmɨva anaaŋgi nɨghɨnɨghɨvɨre ikaami.” ");
INSERT INTO spm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskariot a Iesusɨm mbɨsevisir gumasir 12 pɨlan gumaghan mav. A Iesus nighɨva Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikiira afharimuura arɨghaousua memɨusua gu. ");
INSERT INTO spm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mauthughura mee aŋna akaman khavɨ oraegha bar phuvure inighinighava, aŋgɨro ovɨsi aŋra nɨɨmɨusua akamana aghavaghara rɨkɨri. Thighira aŋnɨ usuiragh mera anɨɨŋmɨusua utuavivɨusua urui. ");
INSERT INTO spm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Iis phatɨsirɨ uvisirɨ uthuuri ishamaŋga amuirɨ uthusirɨ ufhuaragha zuirɨ uthugho otosima Judarir gumasi mee othɨvhan khav iti. Mee ufhuaragha Israelir Got nomthegha mee nisirɨ uthugh aŋgi nɨghɨnɨghɨva sivsivɨni ikamam mbɨsuegh ana nighɨv Got ranɨɨŋva aŋm mbɨnambaghɨv ana nigh maaŋɨva anara amaŋga. Thighira Iesusɨn suren gumasi aŋna azaaghi, “Ee aŋanan manavɨn maaŋɨ, nɨɨ Israeli Got nomthegha mee nisirɨ uthughuni ishama ramuamɨusua, ee bisia rɨkɨr ti?” ");
INSERT INTO spm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mem mbɨkemisima a non suren gumaghan phunini amaŋga kamagha aniiŋm mbɨŋgeeghi, “Aŋgo uŋuuni ikhɨvan maŋɨtima gumagha thavɨ rɨmɨm mbɨnaŋgɨ uphugh zɨɨ aŋgom mbatoghti, aŋgo aŋn gɨn maaŋɨ. ");
INSERT INTO spm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ana aven zui rɨphen aŋgo aŋn maŋɨva aŋn guavɨm mbɨkɨmɨri, ‘Fhɨghɨn gumagh kamagha azaaghi, “Kɨ non suren gumasir phorugh Israeli Got nomthegha mee nisirɨ uthughi nɨghnɨgh ishamaŋga amuira aŋan mana?” ’ ");
INSERT INTO spm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aŋgo aŋm mbɨkɨmti a iphɨn rɨphenana aveni itira aŋanani ikhɨvana aŋgon khɨvaghami. Aŋanan khav bisi bar ikha emɨusuavɨra gari. Uthughun khavɨn gee aŋanan khav ee norivɨusua bisi bar andar rɨkɨrighiri.” ");
INSERT INTO spm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mauthughura aŋn suren gumaghaniiŋ mee thaegha uŋuuni ikhɨvana aven guava garima bisi am mbɨkemisi moghɨra gusi, aniiŋ maghɨra Israeli Got nomthegha mee nisirɨ uthughusua aghae rako bisia rɨkɨri. ");
INSERT INTO spm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma uŋguarthughura Iesus nom mbɨsevisir gumasir 12 pɨlar phorugha guava otuivi. ");
INSERT INTO spm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mee aŋna aghan akoghɨn apiighav ikha aphava, Iesus kamaghɨm mbɨŋgeeghi, “Kɨ guisimbaaŋra gem mbɨŋgeeghi, gena thav na nighɨva nana aphanaŋga amuir gumasi tharsira afharimuu ratɨghami, a ivɨra nan phorugha ikhava aphi.” ");
INSERT INTO spm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mee aŋna akamam mbaraegha, navi bar osemi. Mee barɨ uvhaghuvhagha aŋna azaaŋsɨgha kamagh aŋm mbɨŋgeeghi, “Kɨghee, kɨra ti?” ");
INSERT INTO spm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mem mbɨkemisima a mee ikaragha kamagh mem mbɨŋgeeghi, “Gee 12 pɨla gena thavɨra. Ma gumagh nan phorugh uvighanɨ utumani ithaaŋnɨ uvavɨra raghumi thav. ");
INSERT INTO spm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gumasir Otar, Gotɨm mbɨgharɨm mbɨkemisir moghɨra, ana aremighemi. Gumagh, Gumasir Otar nigha aphanir gumasira afharɨ athɨsi khav! A bar maghatiighemi! Inaghamuuŋ aŋm mbatesi phatɨghav khasi, a inderaghaghi!” ");
INSERT INTO spm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Iesus non suren gumasir phorugha apha ikhava, a uvighanɨ utuman mav nigha Gotɨm mbɨnambagha ana biigha, ana nigha non suren gumasigha anɨɨŋga, kamagh mem mbɨŋgeeghi, “Khara nan neerɨnofhɨgh. Gee ana nigh ana ramɨ.” ");
INSERT INTO spm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mauthughura a uainiro ovɨsiri imboori aphiri ithaaŋ nigha Gotɨm mbɨnambagha meŋga aniiŋsi, mee uvhaghuvhagha norir guri. ");
INSERT INTO spm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mee uainiro ovɨsiri imboori aphima a kamagh mem mbɨŋgeeghi, “Khara nan ŋaan. Kɨ gumasi rako amisi bar mena akuruvaghaousua ana asighɨusuami. Kɨ kamagh ramuighti Got kha akama rɨŋgɨrana aghavaghar ikeghemi. ");
INSERT INTO spm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kɨ guisimbaaŋra gem mbɨŋgeeghi, Kɨ nomthegh uainiro ovɨsiri imboori tharsi rameghem phatɨghami, kamaghɨre ikhɨɨ maaŋɨ Got kha bisigha ativamirɨ uthugho otoghomi. Kha uthughun, kɨ uainiro ovɨsiri imbooriri iŋgaa ramaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mauthughura mee Gotɨni izɨɨ ufhirɨm mbɨtighan mavɨa amuigha rɨkhavigha Olivɨno oraghɨn zee. ");
INSERT INTO spm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesus kamagh non suren gumasi vɨŋgeeghi, “Gotɨm mbɨgharano osɨr kamagh iti, ‘Kɨ sivsiviir garir gumagh aŋm mbɨsueghtima sivsivii atamatamɨra areghemi.’ Kamagha amuisi gee bar, nani itir nɨghnɨghana aghavaghar gɨvaghtima, gee na thaeghɨva areghemi. ");
INSERT INTO spm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kɨ gem mbɨŋgeeghi, kɨ aremigh nomtheghɨ rɨkavigh genɨ ufhuaragh Galilin distrighɨn maŋŋaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A mem mbɨkemisima Pita kamaghɨm mbɨŋgeeghi, “Mee bar nɨɨ thaeghtima kɨra phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","An aŋm mbɨkemisima Iesus kamagh aŋm mbɨŋgeeghi, “Kɨ guisimbaaŋra nɨɨm mbɨŋgeeghi, thighira rɨmaaŋn khavɨn nɨɨ nombɨ uthughun phunini ko mbɨkethavɨn nɨɨm mbɨkɨmaŋga, ‘Kɨ ana ikeeŋsi phatɨ.’ Maghɨra utuar gɨna afhuvan buaaŋniiŋ ramuaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","An aŋm mbɨkemisima Pita akamana aghavaghara amua kamaghɨusue, “Kɨ nɨɨn phorugha aremighaousuava arɨmaŋga, kɨ kamaghɨm mbɨkemighem phatɨghami. Bar phatɨghami!” Mauthughura suren gumasi bar kamaghɨra aŋm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iesus non suren gumasir phorugha olivir ther mɨghɨn zee. Ma mɨghɨni izɨɨ Getsemani. Mee aŋn zegha, Iesus kamagh mem mbɨŋgeeghi, “Gee khagh raphighɨv ikɨthi kɨ Gotɨn phorughum mbɨkɨmaŋga.” ");
INSERT INTO spm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mauthughura a Pita, ri Jems koma Jon mee nigha gu. Thighira atitiiŋ phuvɨra aŋna anandima, a bar osemigha, ");
INSERT INTO spm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","kamagh mem mbɨŋgeeghi, “Nan navana avee, osɨmndɨgh ana itheragha gueghiri. Kɨ aremighaousuava amui. Gee khaghi ikhɨva, inderaghɨvɨra gan.” ");
INSERT INTO spm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mauthughura a muaŋ sɨvagha gugha, non khoma moghɨra unuaghɨnaŋgi irɨgha kamagh Gotɨn phorugham mbɨŋgɨ kamaghɨusue, utuavɨni igharis thav ikhɨtima nɨɨ uthughun maghatɨghan khav nam mbathɨghɨn ana nii. ");
INSERT INTO spm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A kamagh Gotɨn phorugham mbɨŋgeeghi, “Giifheve, nani inaghaves, bigha thav bar nɨɨno osemisi phatɨ. Kamagh amuisi mbɨzaghɨn khav, nɨɨ nam mbathɨghɨn ana nii. Nɨɨ nan vhusvhusan gɨn maŋa thaghɨri. Nɨɨ non vhusvhusan mɨn, nɨɨ ramu.” ");
INSERT INTO spm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mauthughura a nomthegha non suren gumaghan phunini ko mbɨkethavɨna aghan zegha garima mee akui. Mee akuima a kamagh Pita mbɨŋgeeghi, “Saimon, nɨɨ akuire? Nɨɨ thange nan phorugh ikegh ganɨva uthughuno othɨvhaaŋni ikeghem phatɨghtire? ");
INSERT INTO spm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gee inderaghɨvɨra ganɨva, Gotɨn phorughum mbɨkɨmti osɨmndɨgha thav gee ramuightima gee ireghem phatɨghami. Kɨ ikaaŋi, gen navira averi vhusvhusi, mbɨkarɨsia aghavagharisi phatɨ. Kamagha amuisi pharphari geŋga amui.” ");
INSERT INTO spm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mauthughura a nomthegha gugha ufhuaragha Gotɨn phorugham mbɨkemisi moghɨra nomthegha aŋn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gumughun a nomthegha non suren gumasivɨusua za gari, mee akuavɨre iti. Pharphari phuvɨra meŋga amui. Mauthughura a meŋga aghurasi, mee aŋm mbɨkɨmaŋgamira akaagha asa. ");
INSERT INTO spm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mauthughura a uthughum mbɨkethavɨn gugha Gotɨn phorugham mbɨkemigha nomthegha za mem mbɨŋgeeghi, “Gee avughusuava akuavɨre itire? Othɨvhan khava thaghi! Uthugho oto. Gee gan, Gumasir Otar mee ana nighɨva othevir maghatɨsigha amuir gumasira afharira arɨghaousua zii. ");
INSERT INTO spm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gee rɨkavighɨva! Ee maŋŋaŋga! Gee gan. Na nigh aphanir gumasir ranɨɨŋgamir thavɨra, a muna zii!” ");
INSERT INTO spm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesus Pita, ri Jems ko Jonɨm mbɨŋgɨvɨre itima, Judas, aŋm mbɨsevisir gumasir 12 pɨlan mav oto. Avɨrani ikhɨv aŋn phorughum mbɨsoghomirɨm mbɨzorsir akosi rako ifhani nigha Iesusɨusua zii. Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii rako Judariro othevi ikeeŋsi gumasi rako Judarir gumasira aphani, mee mee amaeŋsi, mee zii. ");
INSERT INTO spm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iesus nigh mena fharira rɨghaousua amuir gumaghɨ ufhuaragha kamaghɨusue, “Kɨ othɨvhan khavɨn gen khɨvaghami. Kɨ iŋŋɨsamir gumagh, a Iesusɨra. Gee anɨ usuiragh, inderaghɨvɨra aŋn ganɨva, ana nigh maaŋɨ.” ");
INSERT INTO spm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mauthughura Judas Iesusɨusua zavɨre ikha kamaghɨm mbɨŋgeeghi, “Fhɨghɨn gumagh!” Judas aŋni iŋŋɨsi. ");
INSERT INTO spm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Maghɨra gumasi zava Iesus agharir aŋga ariigha, mbɨghɨravɨra aŋnɨ usuira. ");
INSERT INTO spm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mauthughura Iesusɨna aghani iti gumaghan mav nom mbɨzorughana akos asigha, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira aphananiri iŋaaran gumaghanɨ ukuara rɨtusi aŋnɨ ukuar rɨtughirɨ. ");
INSERT INTO spm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Maghɨra Iesus kamaghɨm mbɨŋgeeghi, “Kɨ okeer gumagh phatɨ. Gee thoghousua nanɨ usuighaousua mbɨzorsira akosi rako ifhani niia zii? ");
INSERT INTO spm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kɨ mɨghasɨgha gen phorugha ikha, Gotɨn rɨphenam mbɨroghɨna aven surea amui. Gee nanɨ usuighani iphɨrphɨri. Gotɨm mbɨgharano osɨrɨm mbɨkemisi moghɨra gee kamagh naŋga amui.” ");
INSERT INTO spm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mauthughura Iesusɨn suren gumasi bar ana thaeghava are. ");
INSERT INTO spm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Gumaghani ikaman mav bigha thav arusi phatɨ, am mbɨsasinɨ ughura akɨrani iti thav ikegha Iesusɨn gɨn zui. Mauthughura Iesusɨna aphani aŋnɨ usuirasima, ");
INSERT INTO spm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a nona akɨrani itirɨm mbɨsasinɨ ughuran khava thaegha imuŋgamara ara gu. ");
INSERT INTO spm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iesusɨna aphani ana nigha Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira aphanivɨusua gu. Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii, rako Judarir gumasira aphani, rako Judariro othevi ikeeŋsi gumasi, mee bar za nori akuvaghav iti. ");
INSERT INTO spm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mauthughura Pita thighiiŋn muaŋn aŋga athɨgha Iesusɨn gɨn guava bar gua Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira aphanan rɨphenan rɨvɨnana aven gughava a ganganir gumasir phorugha apheraghav ikha arivan fheeghi. ");
INSERT INTO spm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii rako Judariro osɨmndɨsiva oragha anda rɨkɨrir gumasi bar Iesusɨm mbɨsueghti ana aremighaousua akaman mena akuruvaghaousua uruiava, avheeŋi. ");
INSERT INTO spm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gumasira avɨrara khorigha amuirɨm mbɨŋgɨmɨŋgɨr Iesusɨa amuisi, mem mbɨŋgɨmɨŋgɨ uvhorsira zui phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Marsi rɨkhavigha khorigha amuira akaman khavɨn aŋm mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ee orasima, a kamaghɨusue, ‘Gumasi iŋarisi Gotɨ rɨphenan khav kɨ ana rɨphɨrighɨva, uthughun phunini ko mbɨkethavɨra igharis thavɨni iŋarighemi. Kɨ iŋarighemi thav gumasi aŋni iŋarighem phatɨghami.’ ” ");
INSERT INTO spm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mbɨŋgɨŋgɨr kharsi ivɨra guisimbaaŋra uvhorsira zui phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mauthughura Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira aphan rɨkhavigha men thooŋnɨ utugha Iesusɨna azaaghi, “Nɨɨ akama thav ikarvaghani iphɨrphɨrisire? Mee nɨɨŋga asira akaman khav, a guisimbaaŋra, o?” ");
INSERT INTO spm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mauthughura Iesus inɨmɨre ikha mem mbɨŋgɨŋgɨma thav ikarasi phatɨ. Mauthughura Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira aphan nomthegha aŋna azaaghi, “Nɨɨ Krais, Got nom ee niamɨusua mbɨsevisir gumagh? Gumasi rako amisi kha Gotɨni izɨɨ ufhi, nɨɨ ano Otarara me?” ");
INSERT INTO spm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","An aŋm mbɨkemisima Iesus kamagh aŋm mbɨŋgeeghi, “Kɨ aŋno Otarara. Gumughun nɨɨ ganti, Gumasir Otar kha gamgaaŋ iti Gotɨn guvɨn aghara apheraghɨva ovheenɨ ughura sam zaami.” ");
INSERT INTO spm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mauthughura Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira aphan non shaara biighava azaaghi, “Ee theghousua nomthegh gumasi tharsir phorugh dɨɨgh ti mee zɨva akaar aŋga asɨ ti? Marikɨɨ! ");
INSERT INTO spm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gee nori aŋm mbarasi, am mbɨŋgɨŋgɨr maghatɨsir Gotɨni izɨɨra afharavasi. Gee manmagh nɨghɨnɨsi?” Mauthughura mee barbar akaman aŋga asa, kamaghɨusue ana aremighemi. ");
INSERT INTO spm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mauthughura marsi aŋgi iphari. Mee aŋna arɨmaghaniiŋ avaragha, mee nona afharir aŋm mbɨsogha kamagh aŋm mbɨŋgeeghi, “Nɨɨm mbɨkɨm. Thɨɨŋra nɨɨm mbɨsosi?” Mauthughura ganganir gumasi ana nighava aŋm mbɨsoghavɨre iti. ");
INSERT INTO spm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Uthughun khavɨra Pita rɨphena rɨvɨnam mbɨŋɨniiŋni itima, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasira aphanani iŋaarana amighan mav zii. ");
INSERT INTO spm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","A zava Pitan garima ana arivan fheema, a rɨkɨrav aŋn gara, kamaghɨm mbɨŋgeeghi, “Nɨɨ gumaghan khav nɨɨ ivɨra Iesusɨn phorugha ike. A Nasaretiiŋn gumagh mav.” ");
INSERT INTO spm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","An aŋm mbɨkemisima a nombɨn guaragha kamaghɨusue, “Kɨ nɨɨm mbɨŋger bighan mav ikeeŋsi phatɨ.” Mauthughura rɨvɨnani itɨmani ikhɨvana akamaniiŋno otoghɨva akɨran maŋamɨusuava amuima maghɨra utuar afhui. ");
INSERT INTO spm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gumughuni iŋaarana amighan khav khagh aŋn garavɨra utuivighav itir gumasi rako amisi nomthegha mem mbɨŋgeeghi, “Muna mena mavɨra.” ");
INSERT INTO spm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A mem mbɨkemisima a nomthegha nombɨn guaragha muaŋ gɨn, aŋna aghanɨ utuivighav itir gumasi Pita mbɨŋgeeghi, “Nɨɨ Galilin distrighɨn gumagh, kamagha amuisima guisimbaaŋra nɨɨ mena mavɨra.” ");
INSERT INTO spm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Maghɨra Pita mbɨghɨravɨram mbɨŋgɨ kamaghɨusue, “Kɨ guisimbaaŋram mbɨŋgeeghi. Kɨ khorira amuightima Got naŋga asɨghasiighemi.” A kamagh mem mbɨŋgeeghi, “Kɨ gem mbɨŋger gumaghan khav ikeeŋsi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A kamaghɨm mbɨŋgɨvɨre itima utuar nomthegha afhui. Maghɨra Pita Iesus aŋm mbɨkemisi mbɨŋgɨŋgɨmaŋgi nɨndɨɨ, “Nɨɨ ufhuaraghɨ uthughun phunini ko mbɨkethavɨm mbɨkɨmaŋga, ‘Kɨ Iesusi ikeeŋsi phatɨ.’ Maghɨra utuar gɨnɨ uthughun phuninin afhuighemi.” Pita anaaŋgi nɨghɨnɨghava ara gua bar phuvɨra azii. ");
INSERT INTO spm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Amɨrɨtusi rɨmaaŋra, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii rako Judarir gumasira aphani, ko Judariro othevi ikeeŋsi gumasi, rako Judariro osɨmndɨsiva oragha anda rɨkɨrir gumasiri igharis tharsi ivɨra, mee nɨghnɨghan mavɨ oto. Mee Iesusɨna afhari ikegha ana akua guava Pailatɨ anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mee Pailatɨ aniiŋsima, Pailat aŋna azaaghi, “Nɨɨ Judarigha ativasir gumagh, o?” An aŋna azarasima Iesus ana ikaragha kamaghɨm mbɨŋgeeghi, “Aŋre, nɨɨ inderaghɨvɨram mbɨŋgeeghi.” ");
INSERT INTO spm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","An aŋm mbɨkemisima Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii bisira avɨrara aŋm mbɨŋgɨva akaar aŋga asi. ");
INSERT INTO spm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mauthughura Pailat nomthegha aŋna azaaghi, “Nɨɨm mbɨŋgɨŋgɨr kharsi ikaravaghami, o phatɨ? Nɨɨ orasi, mee bisira avɨrara nɨɨm mbɨŋgɨva andar nɨɨŋga asi.” ");
INSERT INTO spm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","An aŋna azarasima Iesus bar aŋm mbɨŋger phatɨsi, Pailat rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pailata amuiro othɨv kamaghɨn, ombari bar ishamani ikhɨvan khavɨnɨ uthugh, mee Pailatɨm mbɨkɨmtima a rɨvɨnan kɨrthɨghani itir gumagha thav, men vhusvhusan ana thaeghti, a maŋŋaŋga. ");
INSERT INTO spm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Gumaghan mav, aŋni izɨɨ Barabas, a gavmanɨn gumasir phorugham mbɨsosi tharsi men phorugha rɨvɨnan kɨrthɨghani iti. Mee bighan khavɨusua rɨvɨnan kɨrthɨghani iti. Mee gavmanɨn phorugha nori vɨsogha gumaghan mava aremi. ");
INSERT INTO spm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Thighira gumasi rako amisi Pailat itira aŋanan guavanambogha rɨvɨnan kɨrthɨghani itir gumagha thav mee vhusvhuisi thava thamɨraghaousua Pailatɨna azaaghi. Khara Pailat mɨghasɨgha othɨvhan khavɨa amui. ");
INSERT INTO spm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mee aŋna azarasima, Pailat mena azaaghi, “Kɨ Judarigha ativasir gumagha thaeghɨva gemɨusua ana amaaŋmɨusua, gee vhusvhuisi o?” ");
INSERT INTO spm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat ikaaŋi, “Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii Iesusa amuir bisivagha navi osemigha, ana nigha nana afharɨ athɨ.” ");
INSERT INTO spm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mauthughura Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii vɨkemisi gumasi rako amisir navi rɨkavisima mee Pailatɨm mbɨkemightima a Iesusɨn thɨvaghɨva, Barabasa thaeghtima a memɨusua zaami. ");
INSERT INTO spm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mem mbɨkemisima Pailat azaaghi, “Gee Judarigha ativasir gumagh arɨsi thav, kɨ manmaghɨra aŋ ramuti?” ");
INSERT INTO spm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A mem mbɨkemisima gumasi rako amisi mbɨghɨravɨra dɨɨ kamaghɨm mbɨŋgeeghi, “Ana nigh khani ighuuvan ana gura!” ");
INSERT INTO spm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mauthughura Pailat mena azaaghi, “Manmaghɨusua? Ano othɨvhan maghatɨghan manavɨa amui?” A mem mbɨkemisima mee barɨm mbɨghɨravɨra dɨɨ mbɨŋgeeghi, “Khani ighuuvan ana gura!” ");
INSERT INTO spm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A mee ramuightima men navi inderaghaousua, Pailat Barabasa thaghi. Am mbɨzorsir gumasi mbɨkemisi mee umbuer Iesusa afhasoroegha, Pailat khani ighuuvan ana guusua meŋga anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mbɨzorsir gumasi Iesus nigha gavmanɨn rɨphenani ikhɨvam mbɨroghɨna aven gueghira mbɨzorsir gumasi bar men dɨɨsima mee za nori akuvaghav iti. ");
INSERT INTO spm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mee uphɨghɨ rutusir shaaran aghɨvanɨ uruaran mavɨn aŋn sharagha rɨkhonɨnɨ amaeŋna rɨkɨrigha aŋna aphanan shara. ");
INSERT INTO spm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mee maghɨra aŋn dɨɨva aŋm mbɨŋgeeghi, “Judarigha ativasir gumagh, nɨra ativasir thav!” ");
INSERT INTO spm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mauthughura mee aghorɨn aŋna aphanam mbɨsogha, ivɨra aŋgi ipharavɨre iti. Mee khoru amua noni itevira akuriri iphɨni ira, mee guisimbaaŋra aŋni izɨɨ ufhi moghɨra amui. ");
INSERT INTO spm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mee othevir kharsir aŋga amua aŋ rɨphovigha gɨvagha, a ma sarisir shaari usuegha, aŋn shaaran aŋn shara. Mauthughura mee ana nigha khani ighuuvan aŋga afhughafhughaousua aŋna akua zui. ");
INSERT INTO spm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sairinin gumaghan mav Saimon, a Aleksander ko Rufusɨn inaghaves, a uŋuuni igharisi thavɨni ikegha Jerusalemɨna aven zui. Maghɨra mbɨzorsir gumasi Iesusa guumir khani ighuuve isaghuphughaousua aŋnɨ usuirasi, an aŋgi isaghuphɨ. ");
INSERT INTO spm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mee guava aŋanan mavɨni izɨɨ Golgota, mee aŋno otuivi. Aŋanan khavɨni izɨɨm mbɨnɨɨŋ kamaghɨn, Aphanir Agharir Aŋan. ");
INSERT INTO spm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mauthughura mee uainiro ovɨsiri imboori ko mbɨzasia gevi rɨmɨn phorugha ighavɨsuegha Iesusɨ anɨndima ana na thaghi. ");
INSERT INTO spm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Aro anaŋga 9_oklogh nisima mee Iesus nigha khani ighuuvan ana guragha aŋga afhu. Mauthughura mbɨzorsir gumasi aŋn shaari isiragha norigha aniiŋga satu ikararaaghi. Thavɨ ufhuaragho otoghɨva, shaara thav niaŋga. ");
INSERT INTO spm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mauthughura mee aŋn gunɨm mbɨŋgera akaman khavo osɨri, “A Judarigha ativasir gumagh.” Mee akaman kuaŋmɨusua aŋm mbɨsueghtima ana aremighemi. ");
INSERT INTO spm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Mee, okɨɨva mbɨzorsigha amuisi gumaghan phunini, mee aniiŋ nigha Iesusɨna aghani ivɨra aniia agura. Mee mav nigha Iesusɨna agharan guvɨn itir khani ighuuvan aŋga afhugha, mav nigha agharani ikɨn itir khani ighuuvan aŋga afhu. ");
INSERT INTO spm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mauthughura za zui tharsi mee rɨmbovirɨm mbɨzeer aŋm mbɨŋgɨva nona aphani ukuaukuaghava kamaghɨusue, “Ore! Nɨɨ, Gotɨn rɨphena rɨphɨrigh aron phunini ko mbɨkethavɨn nomthegh aŋni iŋaraousua mbɨkemisi gumagh. ");
INSERT INTO spm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nɨɨ thighira nɨɨ nombɨra nombɨna akuragh, khani ighuuva thaeghɨva zighirɨ!” ");
INSERT INTO spm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Gotɨna aphuraphurava aghae rako bisir aŋga anɨndir gumasiri ikii rako Judariro othevi ikeeŋsi gumasi ivɨra kamaghɨra aŋ rɨphova nori vɨŋgeeghi. Mee kamaghɨm mbɨŋgɨ kamaghɨusue, “A igharis tharsira akuruvasi a nombɨra nombɨna akuruvaghani iŋgura! ");
INSERT INTO spm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kha gumagh, a kamaghɨusue, ‘Kɨ Got nom gumasi rako amisi niamɨusua mbɨsevisi gumagh. Kɨ Israeligha ativasir gumagh.’ Khara guisimbaaŋrana akam nɨɨ khani ighuuva thaeghɨva zighirɨtima, ee nɨɨn ganigh nɨghnɨghana aghavaghar nɨɨni ikaami.” Okeer gumaghan phunini aŋna aghan guraghav ikha, ivɨram mbɨŋgɨŋgɨr maghatɨsira avɨrara phuvɨra aŋm mbɨŋgɨvɨre iti. ");
INSERT INTO spm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aro za phesakhaman thooŋni itima gɨngɨnɨ unuaghɨnani itirɨ uŋuimba bar anda avaragha, guava 3_okloghɨnɨ uŋguarthughura utu. ");
INSERT INTO spm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aro gua 3_oklogh nisima Iesus itɨɨŋni ikhɨvanɨm mbɨghɨravɨra kamagh deeghi, “Eloi, Eloi, lama sabaktani?” Akaman khavɨm mbɨnɨɨŋ kamaghɨn, “Nan Got, nan Got nɨɨ thoghousua na thaghi?” ");
INSERT INTO spm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Maghɨra aghangera utuivighav itir tharsi oraegha kamaghɨusue, “Gee oragh, a Elaijan deeghi.” ");
INSERT INTO spm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Maghɨra gumaghan mav akhɨghavtɨgha gua rɨmɨnɨ usuisi bigh nigha uainiro ovɨsiri imboorira afhaaŋndɨgha rugha ana nigha aghorɨn mavɨ athɨgha, Iesus ramamɨusua ana amandi. A kamaghɨusue, “Gee thaegh, ee ganaŋga, Elaija ti zɨva aŋna akuraghami, o phatɨ.” ");
INSERT INTO spm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mauthughura Iesusɨm mbɨghɨravɨra dɨɨgha utumu usue. ");
INSERT INTO spm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Maghɨra Gotɨn rɨphenan guraghavi iti mbɨsasini ikhɨv iphɨni ikegha thooŋra bigha gueghira uvɨno otogha araran phunini irɨ. ");
INSERT INTO spm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","100 pɨlam mbɨzorsir gumasir garir gumaghana aphanan mav, a Iesusɨna aghanɨ uthughav ikha orasi, am mbɨghɨravɨra dɨɨgha, manmaghɨra aremisiro othɨvhan ganigha kamaghɨusue, “Bar guisimbaaŋra, kha gumagh a Gotɨn Otarara!” ");
INSERT INTO spm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Uthughun khavɨna amisir marsi muaŋ isaghunɨ utuivighav ikha gari. Men thooŋn Makdalanɨnɨ uŋuuna amigh Maria, ko Salome, ko Josev ri Jemsɨni inaghamuuŋ Maria. Kha Jems a Josevɨnɨ undoogh. ");
INSERT INTO spm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Amisir kharsi Galilin distrighɨni ikegha Iesusɨna akuruvagha aŋn phorughava arui. Amisir avɨrar marsi ivɨra Iesusɨn phorugha Jerusalemɨna anambogha ivɨre iti. ");
INSERT INTO spm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Thighira aron avhughususanɨ uthughusua bisiar rɨkɨrirɨ uthugh. Amɨn phɨrtima avhughususanɨ uthugho otuivami. Kamagha amuisima aro gevima, Arimatean gumagh Josev, Judariro osɨmndɨsiva oragha anda rɨkɨrir gumaghana aghuuŋ mee bar ikeeŋsi mav. A nombɨ ivɨra Got kha bisigha ativamirɨ uthughusua gari. Ana atitii phatɨgha Iesusɨn khum niamɨusua gua Pailatɨna azaaghi. ");
INSERT INTO spm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","An aŋna azarasima Pailat oraghi, Iesusa aremigha gɨvasima, a rɨŋgavan maghatɨgha amui. A 100 pɨlam mbɨzorsir gumasir garir gumaghana aphanan mavɨusua akama amandasima a zesima an aŋna azaaghi, “Iesus guisimbaaŋra aremisire?” ");
INSERT INTO spm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","An aŋm mbɨŋgɨŋgɨmam mbaraegha a ikaaŋi, Iesus guisimbaaŋra aremi. Mauthughura a Iesusɨn khum niamɨusua Josevɨm mbɨnamba. ");
INSERT INTO spm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","47","Mauthughura Josevɨm mbɨsasinɨ ughurana aghuuŋn mav aŋgu uvhuesigha zava Iesusɨn khuma daeŋga zeghirɨ. Ana na uphomigha gɨvagha ana nigha guava akɨman thooŋ mee rɨtusi thavɨn gugha ana athɨ. Ma uthughun Makdalanɨnɨ uŋuuna amigh Maria, ko Josevɨni inaghamuuŋ Maria, aniiŋ garima, Josev Iesusɨn khum nigha akɨman thooŋna avena ana athɨgha, akɨmani ikhɨvan mavɨ uphoghuphuegha zava aŋna akamania rɨkuugha. ");
INSERT INTO spm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Avhughususanɨ uthugh gɨvasima, Makdalanɨnɨ uŋuuna amigh Maria, ko Jemsɨn inaghamuuŋ Maria, ko Salome mee maaŋɨ Iesusɨn khum aghɨvousua mbɨghuriir aghui zuirɨm mbɨruer marsighɨ uvhuesi. ");
INSERT INTO spm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","7 pɨlarɨ uthusirɨ ufhuaragha zuirɨ uthughun aro anandima, rɨmaaŋra mee gua Iesusɨn khum athɨsi akɨman thooŋna aghan norira nori vɨŋgeeghi, “Thɨɨŋra ena akuragh akɨman thooŋna akamania rɨkuusi akɨmɨ uphuegh ti?” ");
INSERT INTO spm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mee gua garima akɨmani ikhɨvan khav, mee ana uphoghuphuegha gu. ");
INSERT INTO spm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mee akɨman thooŋna akamaniiŋna aven gua garima gumaghani ikaman mav shaaranɨ ughuranɨ uruaran mava arugha agharan guvɨn amandaghava apheraghav iti. Mee aŋn ganigha bar rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Gumaghan khav kamaghɨm mbɨŋgeeghi, “Gee atitiiŋn thaghɨri. Kɨ ikaaŋi. Gee Nasaretiiŋn gumagh, Iesusɨusua gari. A khani ighuuvana aremigha nomthegha rɨkavi! A khagh iti phatɨ. Gee khagh a irɨghavi ikesira aŋanan gan. ");
INSERT INTO spm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Thighira gee maaŋɨ, Pita ko aŋn suren gumasiri igharis tharsi vɨkɨm, ‘A genɨ ufhuaragh Galilin distrighɨn maŋŋaŋga. Am mbɨkemisi moghɨn gee munagh aŋmba othuivhami.’ ” ");
INSERT INTO spm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mauthughura mee rɨŋgavan maghatɨgha amuigha guava akɨran guegha phuvɨra are. Mee atitiiŋi, kamagha amuigha mee tharsi vɨkemisi phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesus 7 pɨla uthusirɨ ufhuaragha zuirɨ uthughun rɨmaaŋra nomthegha rɨkhavigha Makdalanɨnɨ uŋuuna amigh Maria, ufhuaragha nombɨn aŋn khɨva. Amighan khav, Iesusɨ ufhuaragha unduur maghatɨsir 7 pɨla iti tharsi vatoghi. ");
INSERT INTO spm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Gumughun gumasi rako amisi Iesusɨn phorugha aruava ikesi tharsi, mee aŋmɨusua bar osemigha phuvɨra azia itima, Maria gugha Iesusɨn gun mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A mem mbɨkemisima, mee oraghi, Iesus nomthegha rɨkhavigha nombɨ nigha Makdalanɨnɨ uŋuuna amigh Marian khɨvasi an aŋn gani. Mee kamagh oraegha nɨghnɨghana aghavagharana amighan khavɨna akaar iti phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Uthughun khavɨn gɨn Iesusɨn suren gumaghan phunini uŋuuni ikhɨvan akɨran zuima Iesus igharaghava otogha aniiŋm mbato. ");
INSERT INTO spm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mauthughura aniiŋ nomthegha za bighan khavɨn gun marsi vɨkemisi, mee ivɨra nɨghnɨghana aghavagharan aniiŋna akaar iti phatɨ. ");
INSERT INTO spm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Gɨnɨ 11 pɨlan suren gumasi aphima Iesus nombɨ nigha men khɨva. A ikaaŋi, mee nɨghnɨghana aghavaghar phatɨgha, mee navana aghavaghar iti. A nomthegha rɨkavisir bighaaŋ, marsi aŋn ganigha mem mbɨŋgeema, mee nɨghnɨghana aghavagharam mbɨŋgɨŋgɨman khavɨni iti phatɨ. Bisir kharsivɨusua Iesus mem mbɨŋgɨ meŋga avhesi. ");
INSERT INTO spm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A kamagh mem mbɨŋgeeghi, “Gee maaŋɨ unuaghɨnan khav bar aŋ raruva unuaghɨnan khavɨni iti gumasi rako amisi bar kha akamana aghuuŋn mem mbɨkɨm. ");
INSERT INTO spm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Gee mem mbɨkɨmti thɨɨŋra nɨghnɨghana aghavaghar nani ikhɨva, urueghtima, Got aŋna akuraghti, a mɨghasɨgh Gotɨn phorugh ikaami. Thɨɨŋra nɨghnɨghana aghavaghar nani iti phatɨ, a Got osɨmndɨsiva oragh anda rɨkɨramirɨ uthughuna aveni ikhɨva uvhuesan maghatɨgh niaŋga. ");
INSERT INTO spm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Nɨghnɨghana aghavaghar nani iti tharsi, gamgaaŋn bisir kharsi ivɨra men khɨvami. Mee nani izɨɨnɨ unduur maghatɨsi vatoghɨva, mee uŋuimbar akaa ikeeŋsi phatɨsi tharsi vɨkɨmɨva, ukurusi nona afharir andarɨ usuighemi. Mee arɨghirira aŋguar rɨmɨ thava rameghti a thange men navigha asɨghasiighem phatɨghami. Mee nona afhari nigh arɨmarɨr gumasir arɨghtima mena arɨmarɨ gɨvaghami.” ");
INSERT INTO spm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Uthughun khavɨni Ikhɨv Iesus, bisir kharsir mem mbɨkemigha gɨvasima Got ana nigha nonɨ uŋuun guavanambo. Ana nambogha, a Gotɨna agharan guvɨn amandagha apheraghav iti. ");
INSERT INTO spm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Gumughun suren gumasi unuaghɨnan khavɨna aŋani bar andar guava akamɨ ukuri. Ikhɨv men phorugha iŋaarava non gamgaaŋn meŋga aniiŋsi mee aŋn gamgaaŋn bisigha amui. Kamagha amuisima gumasi rako amisi ikaaŋi, akaman khav bar guisimbaaŋra.");
INSERT INTO spm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2"," Tiofilas, khɨɨ nɨɨmɨusua mbɨgharan khav ana osɨri. Nanɨ ufhuarasirɨ mbɨgharan avhen, khɨɨ Iesus bar amuisi bisi, koma a gumasi rako amisir surea amuisi tharsi ivhɨrama anda osɨri. Uthughun khavɨn Iesusɨ rɨkavhigha non iŋaarigha amua mamaghɨre ikha, gua a Gotɨnɨ uŋuun guavanambosirɨ uthughun uthusi bisi, khɨɨ anda osɨri. Iesus a thighar Gotɨnɨ uŋuun maŋŋamɨusua, aŋm mbɨsevisi gumasi a Gotɨnɨ Utuman gamgaaŋn iŋaarir akaar mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A ufhuaragha mbɨzasi nigha aremigha nomthegha rɨkavisirɨ uthusir a thighar Gotɨnɨ uŋuun maŋŋamɨusua, a nombɨ nigha, a nombɨusua mbɨsevisi gumasir khɨva. A bisira avhɨrara men khɨvasima, mee bar anda ikaaŋi, a nomthegha rɨkavhigha iti. 40 pɨlan uthusi, uthughun khavɨn avhenɨ uthusira avhɨrara a nombɨn men khɨvagha Got kha bisigha ativamirɨ uthughun gun mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Uthughun mavɨn a men phorugha ikha, aphava mbɨŋgɨŋgɨman aghavagharan khavɨn meŋga anɨɨŋi, “Gee Jerusalemɨnɨ uŋuuni ikhɨva thaegh maŋŋa thaghɨri. Bighana aghuuŋ nan Inaghaves geera anɨɨŋmɨusua akama rɨkɨrisi thav, a zaami. Gee anaŋmba oraghi, kha aŋn gun gem mbɨkemi. Gee aŋmɨusua gan ikhɨɨ. ");
INSERT INTO spm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon gumasi rako amisi rɨmɨn mee uruesima, khɨɨ gɨn Gotɨnɨ Utuman gamgaaŋn gee uruami.” ");
INSERT INTO spm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Uthughun mavɨn, mee nori akuvasirɨ uthughun, mee aŋna azaaghi, “Ikhɨv, nɨɨ uthughun khavɨ ativamir gumagh Israeli raniiŋtima, a nomthegh Israelirɨ unuaghɨnan ganaŋgami, o?” ");
INSERT INTO spm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesus kamagh mem mbɨŋgeeghi, “Bisi otuvamirɨ uthugh, nani Inaghaves nombɨra nonɨ uthugh athɨ. Gee theeghɨnamɨusua ana athɨsirɨ uthughun khav ikaaŋmɨusua. Khara gen bighaaŋ phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gumughun Gotɨnɨ Utum geni iphɨn zighirɨghtima, gee aŋn gamgaaŋ nighɨva, gee Jerusalemɨn nana akamɨ ukunɨva Judian distrigh ko, Samarian distrighɨn maŋɨ unuaghɨnan khavɨn asɨsive bar, men niaghaami.” ");
INSERT INTO spm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iesus kamaghɨm mbɨkemigha gɨvagha, aŋm mbɨsevisi gumasi garavɨre itima Got ana sigharafasima a Gotɨnɨ uŋuun guavanandi. Mauthughura mee garavɨre itima guan mav ana mondu. ");
INSERT INTO spm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","A guavanandima mee khogho ovheen garavɨre itima, gumaghaniiŋ shaaranɨ ughuraniiŋ arughava uzuamɨra men phorugha utu. ");
INSERT INTO spm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aniiŋ kamagh mem mbɨŋgeeghi, “Galilin distrighɨn gumasi, gee thoghousua khaghɨ utuivighav ikha iphɨno ovheen gari? Gumaghan khav Iesus, Got ana nisima a gee thaegha nonɨ uŋuun gu. Gee aŋn ganisima a Gotɨnɨ uŋuun gusi moghɨn, a kamaghɨra nomthegh zaami.” ");
INSERT INTO spm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iesusɨm mbɨsevisi gumasi Olivɨn oragha thaegha nomthegha Jerusalemɨn zui. Olivɨn oraghɨn khav Jerusalemɨn aghangera ikava aŋnɨ uruar kilomitan uvhuavɨran mɨn gu. ");
INSERT INTO spm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mee gua Jerusalemɨn avhen gugha gua mee ma iti rɨphenan avhen iphɨn guavanaaŋi. Meni izɨɨri khara, Pita, Jon, Jems ri Andru, Filip ri Tomas, Bartolomiu, Metiu ri Jems, a Alfiusɨn otar, Saimon, a Selotiiŋn phoghɨn gumaghan mav, koma Judas, a Jemsɨn otar. ");
INSERT INTO spm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mee mɨghasɨgha navan uvhuavɨra ikha nori nigha Gotɨn phorugham mbɨŋgeeghi, amisir marsi rako Maria, Iesusɨni inaghamuuŋ, koma aŋnɨ undoosi ivhɨra. ");
INSERT INTO spm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Uthusir kharsir avhen gumasi rako amisi Kraisɨn phorus tharsi Pita mena arɨghanɨ utugha akamɨ ukuri, men avhɨra rɨmbombon 120. ");
INSERT INTO spm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","A kamaghɨm mbɨŋgeeghi, “Nana avheeŋmbuagha, Gotɨnɨ Utum fhomɨra Devitɨ amuisi, aŋna akaman mavɨm mbɨkemi. Akaman khav Gotɨm mbɨgharan avheni iti. Akaman khav a Judasɨm mbɨŋgeeghi. Kha gumagh Judas, a utuavɨn aphanir gumasir kɨrasima mee Iesus aŋnɨ usuirasi tharsi. Akaman khav thighira otogha gɨva, Devit mbɨkemisi moghɨra. ");
INSERT INTO spm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas fhomɨra en gumaghan mav, a ivhɨra ee kha amuir iŋaara amui.” ");
INSERT INTO spm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","A non othɨvhan maghatɨghan uvhues nighava unuaghɨnan mavɨ uvhuesi. A unuaghɨnan khavɨn nombɨ ukunigha irima aŋm mbɨkarɨgh rɨghoraghirima, aŋnɨ umuu baro oŋeeghirɨ. ");
INSERT INTO spm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kamagh amuisima, Jerusalemɨni iti tharsi barbar bighan khavɨ oraghi, mee unuaghɨnan khav non akaman izɨɨn khavɨn aŋga athɨ, Akeldama. Aŋm mbɨnɨɨŋ kamaghɨn, ŋaananɨ unuaghɨn. ");
INSERT INTO spm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita mbɨŋgɨ gua kamaghɨusue, “Gotɨm mbɨgharan avheni iti mbɨtisir osɨɨran khav iti, ‘Aŋn aŋan phure ikhɨɨri, thav ana aŋanan khav nia thaghɨri.’ A ivhɨra kamaghɨusue, ‘A gumaghan aphanan mɨn iŋaari, gumughun igharisi thav ana amuisir iŋaar niaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kamagha amuisima, a mɨghasɨgha en phorugha ikava eni Ikhɨv Iesusɨn gɨn aruisi gumasi ee thavam mbɨsevighemi. ");
INSERT INTO spm_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jon gumasi uruesirɨ uthugh, ko Iesusɨ ufhuaragha rɨkɨnarɨkaraghava amusiri iŋarirɨ uthughun ikhegha, zaavɨkava Got Iesus nisi a ee thaegha guavanambosirɨ uthughunɨ utu. Uthusir kharsir bar en phorugha ikesir gumagha thav ana mbɨsevighemi. Iesus rɨkavhigha gɨvasima kha gumagh aŋn gani, a en phorugh mbɨŋgɨŋgɨman khavɨn akamɨ ukunaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mauthughura men gumaghan phuninin izɨɨni rɨmboru, Josev, aŋni izɨɨn mav Barsabas (aŋni igharisir izɨɨn mav Jastus) koma Matias. ");
INSERT INTO spm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Mauthughura mee Gotɨn phorugham mbɨŋgeeghi, “Ikhɨv, nɨɨ gumasir navir averi bar anda ikaaŋi. Nɨɨ en khɨva, nɨɨ aniiŋna thavam mbɨsevightima, a Iesusɨm mbɨsevisi gumagh Judasɨn aŋan nighɨva kha iŋaara ramuaŋga. Iŋaaran khav Judas ana athaegha aremigha khuurɨ uŋuun gu.” ");
INSERT INTO spm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mauthughura mee akɨman aniiŋni izɨɨni osɨrigha thooŋga athɨgha aniiŋ ivhasvhasima Matiasɨni izɨɨ itir akɨm iphɨn ikhegha ufhuaraghavɨra akɨrei irɨ. Kamagha amuisima mee Matias nigha, Iesusɨm mbɨsevisi gumasir 11 pɨlan phorugha ana athɨ. ");
INSERT INTO spm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikosɨnɨ uthughun ikhɨvo otosima, Iesusɨm mbɨsevisi gumasi mee noria akuvagha rɨphenan mavɨn iti. ");
INSERT INTO spm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mauthughura uzuamɨra mee orasima nɨnɨɨŋn ikhɨvan mav Gotɨnɨ uŋuun ikhegha zeghira, gamiiŋn gamgaaŋ mɨn zii. A mee apiighav iti rɨphen bar ana izɨvagha ana noghi. ");
INSERT INTO spm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mee garima bighan mav arivam mbɨzan mɨn otogha bɨghira uvhuaghuvhuagha men aphanir isɨrigha aphighi. ");
INSERT INTO spm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mauthughura Gotɨnɨ Utum barbar mee izɨvaghava, gamgaaŋn meŋga aniiŋga meŋga amuima, mee uŋuimbar igharisi tharsir akaa vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Uthughun khavɨn Judarir akoghɨn gumasi rako amisi fhomɨra gua igharisi uŋuimbarɨ unuasir iti tharsi mena marsi nomthegha zaava Jerusalemɨni iti, mee ivhɨra Gotɨn apheeŋn iti. ");
INSERT INTO spm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ara mee nɨŋnɨɨŋn khavɨ oraegha zaa bar nori akuvaghav ikava, mee uvhuaghuvhagha orasima gumasi rako amisi menɨ uŋuimbar akaa vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kamagha amuisi mee osemigha atam nɨghɨnɨsi. Ara mee rɨŋgavan maghatɨgha amuighava azaaghi, “Kha mbɨŋgeer gumasi mee bar Galilin distrighɨn gumasira! ");
INSERT INTO spm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Manmagh amuigha ee barɨ uvhuaghuvhagha memba orasima mee enɨ uŋuimbar akaara vɨŋgeeghi? ");
INSERT INTO spm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ena marsi, Partianɨ unuaghɨn ko Midianɨ unuaghɨn ko Elamɨnɨ unuaghɨnan ze. Marsi Mesopotemianɨ unuaghɨnan zesi gumasi. Marsi Judian distrigh ko Kapadosian distrigh ko Pontusɨn distrigh koma Esian distrighɨn ze. ");
INSERT INTO spm_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Marsi Frigian distrigh ko Pamfilian distrighɨn ze. Marsi Isivɨnɨ unuaghɨn, ko Libian distrighɨna avheni itira aŋan, a uŋuun ikɨvan mav Sairinin aghangere iti tharsi mee ze. Marsi Judarir akoghɨn gumasi Romiiŋnɨ uŋuuni ikhegha zesi tharsi. ");
INSERT INTO spm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ee barbar, Judarir akoghɨn gumasi rako igharisirɨ unuaghɨnan gumasi, mee Judariro othevir gɨn zui tharsi, mee ivhɨra, ena marsi. Ena marsi Kritɨn mɨghsɨm koma Arebian distrighɨn gumasi, ee uvhuaghuvhuagha memba orasima mee enɨ uŋuimbar akaar Gota amuisi bisir ikiir gunɨm mbɨŋgeeghi!” ");
INSERT INTO spm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Judarir akoghɨn gumasi rɨŋgavan maghatɨgha amuighava phurama atamatam nɨghɨnɨghava norir azaaghi, “Khara theghanan bighaaŋ?” ");
INSERT INTO spm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Judarir akoghɨn gumasir marsi rɨmbovira akaa vɨŋgɨ kamaghɨusue, “Mee uainir rɨphar avhɨrara amegha oŋani.” ");
INSERT INTO spm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita, Iesusɨm mbɨsevisir 11 pɨlan gumasir phorugha utughav ikha, a gumasi rako amisi mbɨghɨravɨra kamagh mem mbɨŋgeeghi, “Gee Judarir akoghɨn gumasi rako Jerusalemɨni itir gumasi rako amisi, gee bar inderaghɨvɨra nambaragh. Khɨɨ kha othuivisi bisir gun gem mbɨkemightima, gee anda ikeeŋgemi. ");
INSERT INTO spm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gumasir kharsi uainiro ovɨsiri imboori rɨpha aphava oŋanisi phatɨ. Gee ikaaŋi, khara 9 okloghɨ rɨmaaŋra. ");
INSERT INTO spm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bighan khav oto, khara Gotɨna ambuuŋn gumagh, Joel fhomɨra mbɨkemisi moghɨn, ");
INSERT INTO spm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Got kamaghɨm mbɨŋgɨ kamaghɨusue, “Gɨn zaamirɨ uthusi tharsir khɨɨ nonɨ Utuman gumasi rako amisi bar mee ranɨɨŋgami. Uthughun khavɨn gen otari rako guivi Gotɨna ambuuŋn gumasir mɨn mbɨkɨmtima, gen gumasir iŋgaa irimbar mɨn bisir gantima, gen gumasir guri iriiŋmbara akuuva bisir ganaŋgami. ");
INSERT INTO spm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Uthughun khavɨn nan iŋaarir gumasi rako amisi, khɨɨ nonɨ utuman ivhɨra mee raniiŋtima, mee Gotɨna ambuuŋn gumasir mɨn akaa vɨkɨmaŋga. ");
INSERT INTO spm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gumughun khɨɨ iphɨno ovheen rɨŋgavan maghatɨgha amuir othevia khɨvɨva, unuaghɨnan gamgaaŋn bisira amuaŋga. Uthughun khavɨn ŋaan ko ariv koma mbɨturan ikhɨv otuivami. ");
INSERT INTO spm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Uthughun khavɨn aro gɨngɨnightima, ikɨni ŋaanan mɨn otuivami. Bisir kharsi ufhuaraghɨvɨra othuivightima, gɨn Ikhɨv zaamirɨ uthugh otuivami. Kha uthughun Ikhɨv non gamgaaŋ ko aŋaran phorugh zaami. ");
INSERT INTO spm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Uthughun khavɨn Ikhɨvani izɨɨn dee tharsi, a men akuruvaghtima mee mbɨghɨvɨghɨighemi.” ’ ");
INSERT INTO spm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israeliiŋn akhoghɨn gumasi rako amisi, gee mbɨŋgɨŋgɨman khavɨ oragh. Nasaretiiŋn gumagh Iesus, Got gemɨusua ana amandagha gamgaaŋn aŋga anɨɨŋi. Aŋga aniiŋsima, a iŋaarir aghavagharir ikii rako rɨŋgavan maghatɨgha amuir othevi koma gamgaaŋn bisi gen thooŋn andagha amui. Ana andagha amuisima, anda othuivisima gee andar ganigha nori ikaaŋi. ");
INSERT INTO spm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Got non vhusvhusan gɨn gua gemɨusua fhomɨra nɨghɨnɨghan mavɨ amuigha, nono otar nigha gen afharigha athɨ. Mauthughura gee ana nigha gumasir maghatɨsir afharɨa athɨsima, mee ana nigha khani ighuuvan ana athɨghava aŋga afhusi, ana aremi. ");
INSERT INTO spm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ovhevheeŋn othɨv Iesusɨnɨ usuiragham thughatɨs phatɨ. Kamagha amuisi, Got aŋga amuisi a rɨkavhigha ovhevheeŋn osɨmndɨgha thaghi. ");
INSERT INTO spm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devitɨn mbɨtisirɨ mbɨghar kamaghɨm mbɨkemi, ‘Khɨɨ Ikhɨvan garima a mɨghasɨgha nana aghan ikhavɨre iti. A gamgaaŋ naŋga anɨndi. Bigha thav na ramuighti, khɨɨ irɨraŋgɨvaghɨva avhighevhighem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Nɨɨ na thaeghtima nanɨ utum khuurɨ uŋuun ikeghem phatɨghami. Nɨɨ nombɨra nombɨusua mbɨsevisi gumagh ana thaeghtima a kurighem phatɨghami. Kamagha amuisi nan nav inderasima khɨɨ mbɨŋgɨŋgɨr aghuuira amui. Got na ramuaŋgamir bisir aghuuira, kha andavagha gari. ");
INSERT INTO spm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nɨɨ, ikɨrana aghuuŋ niaŋgamirɨ utuavɨn, nan khɨvagha gɨva. Khɨɨ nɨɨn phorugh ikaami, nɨɨ na ramuighti, khɨɨ bar phuvɨra inighinighemi.’ ");
INSERT INTO spm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nana avheeŋmbuagha, khɨɨ guisimbaaŋra gem mbɨŋgeeghi, en avhav Devit aremisima mee ana rafha. Aŋna akɨman umogh thighira en phorugha ikha khari iti. ");
INSERT INTO spm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Devit a Gotɨna ambuuŋn gumaghan mav, a ikaaŋi, Got akaman rɨŋgɨran aghavagharan aŋga aniiŋga kamaghɨusue, ‘Nɨɨ ativasir gumagh, khɨɨ nɨɨn aŋan niamɨusua nɨɨna avava thavam mbɨsevighemi.’ ");
INSERT INTO spm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Got gɨn ramuaŋgamir bigh, Devit ana ikaaŋi, a Got nom ee niamɨusua mbɨsevisi gumagh ana aremigh nom rɨkavamir bighaaŋm mbɨŋgeeghi. A kamaghɨusue, Got ana thaeghtima aŋna arɨghiresi tharsir arɨghanɨ umoghɨn avhen ikeghem phatɨ. Aŋm mbɨkarɨgh kurighem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Gumaghan khav Iesus, Got aŋga aghurasima a nomthegha rɨkavhi. Ee nori nona arɨmasir aŋn ganigha, mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A guavanaŋga non Inaghavesɨn guvɨn aghara apheraghav ikha aŋn iphɨn gamgaaŋ nii. Aŋni Inaghavhes aŋm mbɨkemisi moghɨn a nonɨ Utuman aŋga anɨɨŋi. Gee thighira oraghava garir bisir kharsi, Iesus nombɨ Gotɨnɨ Utum emɨusuava ana amandasima ee aŋn gamaaŋn iphɨn bisigha amui. ");
INSERT INTO spm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit Iesusɨn mɨn Gotɨnɨ uŋuun gus phatɨ. A kamaghɨm mbɨŋgeeghi, ‘Ikhɨv kamagh nan Ikhɨvam mbɨŋgɨ kamaghɨusue, “Nɨɨ khagh nana agharan guvɨra apheraghɨva, ");
INSERT INTO spm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mamaghɨra ikhɨtima khɨɨ nɨɨn aphani rɨkambuuŋtima mee nɨɨn apheeŋn ikaami.” ’ ");
INSERT INTO spm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kamagha amuisima, gee Israeli gee bar bighan khav ikaaŋi. Geem mbɨsuegha khani ighuuvan gurasi Iesusɨn khav, thighira Got aŋga amuisima a Ikhɨvan oto. A Got nom ee niamɨusua mbɨsevisi gumagh.” ");
INSERT INTO spm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ara gumasi rako amisi Pitan akama mbarasi, aŋm mbɨŋgɨngɨ men navigh inivima, mee kamagh Pita koma Iesusɨm mbɨsevisi gumasir igharisi tharsi vɨŋgeeghi, “Ena avheeŋmbuagha, ee manmaghɨra ramuti?” ");
INSERT INTO spm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mauthughura Pita kamagh mem mbɨŋgeeghi, “Gee bar nɨghɨnɨsigh ɨraghɨva Krais Iesusɨn izɨɨn urueghtima Got geno othevir maghatɨsi gɨn amandaghɨva maghɨra, a nonɨ Utum gemɨusua ana amaaŋga. ");
INSERT INTO spm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Got fhomɨra akama rɨkɨrigha kamaghɨusue, a nonɨ Utum gemɨusua ana amaaŋga, gegha, gen boori rako, gen isaghuni iti tharsi, mee bar. Got, en Ikhɨv, gumasi rako amisi a dɨɨsi tharsi, a nonɨ Utum memɨusua ana amaaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mauthughura Pita mbɨŋgɨŋgɨr avhɨrara meŋga amuava akaar aghavagharir marsi ivhɨra mem mbɨkemi, “Gee norira norir akuraghti, Gotɨ uthughun khavɨn gumasi rako amisir maghatɨsir kharsigh asɨghasɨghɨva ivhɨra geŋga asɨghasiighem phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mauthughura gumasi rako amisira avhɨrara aŋna akama mbaraegha aŋn vhusvhusigha urue. Uthughun khavɨn Got nom 3,000ɨn gumasi rako amisir marsi nom mee nisima mee Kraisɨna andarsira avhen ze. ");
INSERT INTO spm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kraisɨna andarsi mee Iesusɨm mbɨsevisi gumasi vɨŋgɨmɨŋgɨv oraegha, bisir norira akuruvagha, nori nigha aphava, Gotɨn phorughum mbɨkɨmamɨusua bar vhusvhusi. ");
INSERT INTO spm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uthughun khavɨn Iesusɨm mbɨsevisi gumasi, mee rɨŋgavan maghatɨgha amuir othevir avhɨrara ko gamgaaŋn bisira avhɨrara amui. Kamagha amuisima gumasi rako amisira avhɨrara rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Uthughun khavɨn nɨghɨnɨghana aghavaghar Iesusɨn iti tharsi navanɨ uvhuavɨra iti. Mee bisi iti tharsi, mee norira akuruvasi. ");
INSERT INTO spm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ara mee nonɨ unuasi rako bisi amaŋga andar aŋgɨro ovɨsi nigha aghae othevisi tharsir akuruvasi. ");
INSERT INTO spm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mee uthusir mɨghasɨgh mɨghasɨgha Gotɨ rɨphena mbɨroghɨn nori akuvi. Mee uvhuaghuvhuagha rɨphenigha aruava nori nigha aphava bar inighinighava, mee navanɨ uvhuavɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mee Gotɨni izɨɨ ufhima, gumasir igharis tharsi bar meŋgi iphui. Mauthughura uthusi uvhuaghuvhuagha Ikhɨv mɨghasɨgha gumasi rako amisir akurasima mee mbɨghɨvɨghɨghi. Kamagha amuisi mee bar avhɨrekevi. ");
INSERT INTO spm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Uthughun mavɨn aro 3 okloghɨ utu, khara Judarir akoghɨn gumasi Gotɨn phorugham mbɨŋger uthugh. Uthughun khavɨra Pita ri Jon Gotɨ rɨphenan zui. ");
INSERT INTO spm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Uthughun khavɨn navan avhera usu maghatɨsi gumaghan mav iti. Gumasi mɨghasɨgha ana azɨgha gua Gotɨ rɨphen ighuisi rɨvɨnan itɨman akamanin ana arɨsi. Itɨman akamanin khavɨn izɨɨ, Itɨman Aghuuŋ Kɨnara. A khagh ikava aŋgɨro ovhɨsivɨusua gumasi rako amisi Gotɨn rɨphen ighuisi rɨvɨnana avhen zui tharsi mena azaaghi. ");
INSERT INTO spm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Uthughun khavɨn a gari Pita ri Jon avhen maŋŋamɨusua zima ana aŋgɨro ovɨsivɨusua aniiŋna azaaghi. ");
INSERT INTO spm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ana aniiŋna azarasima Pita ri Jon ivhɨra aŋn gari. Mauthughura Pita kamaghɨusue, “Nɨɨ rɨkɨr aŋgara ganri!” ");
INSERT INTO spm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Am mbɨŋgeema gumaghan khav bigha thav niamɨusua nɨghɨnɨgha, mbɨghɨravɨra aniiŋra gari. ");
INSERT INTO spm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mauthughura Pita kamaghɨm mbɨŋgeeghi, “Khɨɨ aŋgɨro ovɨsi phatɨ. Khɨɨ iti bighɨn, khɨɨ anan nɨɨ ranɨɨŋmɨusua. Nasaretiiŋn gumagh Krais Iesus, aŋni izɨɨn, nɨɨ rɨkavigh raru!” ");
INSERT INTO spm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mauthughura Pita aŋna agharan guvɨnɨ usuiraghava, ana ufheesima. Aŋn guamtɨvani ko aŋgari uzuamɨra gamngaa nisima, ");
INSERT INTO spm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","a rɨkavigha utuiva zui. Mauthughura a Pita ri Jon phorugha Gotɨn rɨphenan mbɨkeeŋn avhen gugha, ifhaa iphɨna amaaŋga, Gotɨn izɨɨ ufhii. ");
INSERT INTO spm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Gumasi rako amisi bar aŋn garima ana aruava Gotɨn izɨɨ ufhima ");
INSERT INTO spm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mee aŋn ganigha ana ikeeŋga kamaghɨusue, gumaghan khavɨra Gotɨ rɨphen ighuisi rɨvɨnan itɨman akamanin apheraghav iti. Kha itɨman izɨɨ khara, Itɨman Aghuuŋ Kɨnara. A mɨghasɨghava anamogha apheraghav ikava, aŋgɨro ovhɨsivɨusua gumasi rako amisir azaaghi. Ara mee rɨŋgavan maghatɨgha amuigha phura nɨghɨnɨsi, manmaghɨra amuisi bighaaŋ khavɨ oto. ");
INSERT INTO spm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Gumasi rako amisi akaman khavɨ oraegha, rɨŋgavan maghatɨgha amuigha, akhɨrsɨgha gua gumaghan khavɨn gari. Mee aŋn garima a Pita ri Jonɨnɨ usuiragha, Gotɨ rɨphenan azuaŋnɨ utughav iti. Rɨphenan azuaŋn khavɨnɨ izɨɨ, Solomonɨn Azuaŋ. ");
INSERT INTO spm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Uthughun khavɨn Pita kamagh ganigha, mem mbɨŋgeeghi, “Israeliiŋn akhoghɨn gumasi rako amisi, thoghousua bighan khav geŋga amuisima gee rɨŋgavan maghatɨgha amui? Gee thoghousua mbɨghɨravɨra aŋn gara kamaghɨusue, aŋga ti nonira aghavaghari ikama ti, o aŋga Gotɨna arɨmasi rɨfhaaŋn inderaghavɨre ikava, aŋga kha gumagha amuisima ana arui? Bar phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ena avhavi Abraham ri Aisak koma Jekovɨn Got, a non iŋaaran gumagh Iesus bar ana iphɨufhui. Gee ana aremighaousua ana nigha aphanir gumasir afharɨ athɨ. Pailat ana thamɨraghaousua mbɨgerɨ uthughun, gee kamaghɨm mbɨŋgeeghi, ‘Ee thange aŋn vhusvhusi phatɨ!’ Ara gee akɨran aŋga ase. ");
INSERT INTO spm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gotɨna arɨmasi rɨfhaaŋn othevira aghuira amui gumagh, gee aŋgi iphɨrphɨrighava, gumaghan maghatɨgh norivɨusua ana thamɨraghaousua Pailatɨ mbɨŋgeeghi. A gumasi vɨsuaghɨusuesi anda arɨghiresir gumagh. ");
INSERT INTO spm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Geŋga amui gee aŋamɨra iti gumagh, gee aŋm mbɨsuesi ana aremisi Got aŋga amuisima a nomthegha rɨkavhi. Aŋga noni bighan khavɨn ganigha ana ikeeŋgava aŋn gunɨm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aŋga Iesusɨn izɨɨn nɨghɨnɨghana aghavaghar iti. Iesusɨn izɨɨra, gee ganigha ikeeŋsi gumaghan khav, a gamgaaŋ nii. Aŋgan nɨghɨnɨghan aghavaghar Iesusɨn ikava bighan khuaŋga amuisima, nɨghɨnɨghan aghavagharan khavɨra kha gumagh amuisima, a bar indera, gee thighira nori aŋn gari. ");
INSERT INTO spm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nana andarsi, khɨɨ kamagh ikaaŋi, gee amuisiro othɨv gee ana ikeeŋsi phatɨ, gen gumasiri ikii ivhɨra. ");
INSERT INTO spm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Got fhomɨra aŋna akam nigha zesi gumasi bar mem mbɨkemisima, mem mbɨŋgɨ kamaghɨusue, a Got nom ee niamɨusua mbɨsevisi gumagh, mbɨzagh niaŋga. Got nom mbɨŋgɨŋgɨgha amuisi moghɨn andar aghae othuivi. ");
INSERT INTO spm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Gee non nɨghɨnɨsir maghatɨsi thaeghɨva, nɨghɨnɨsigh ɨragh Gotɨusua zɨɨtima, a geno othevir maghatɨsi gɨna amaaŋga. ");
INSERT INTO spm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Gee kamagh ramuightima, Ikhɨv avughususan genɨ unduur rako navan amɨɨŋndɨghan gera anɨɨŋtima, gee phurei ikhɨva Got nom ee niamɨusua mbɨsevisi gumaghagha gan ikɨɨ. ");
INSERT INTO spm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Got bar fhomɨra fhomɨra nona ambuuŋn gumasi vɨkemisima, mee kamaghɨusue, ‘Thighira Iesus Gotɨnɨ uŋuuni ikhɨɨ, maaŋɨ Got kha bisi ramutima anda nomthegh bisiri iŋgaar mɨno othuivighemi.’ Got mbɨkemisi moghɨn, bisi bar othuivhami. ");
INSERT INTO spm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses fhomɨra kamaghɨm mbɨŋgeeghi, ‘Got gen Ikhɨv, nan mɨn akam nigha zesi gumaghan mav, a gena arɨghan gena thavam mbɨsevighemi. Gee, aŋm mbɨŋgeer bisi, gee bar andavaraghɨva anda ramu. ");
INSERT INTO spm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aŋm mbarasi phatɨsi tharsi, Got meŋga asɨghasiighemi. Mee nomthegh Gotɨn gumasi rako amisir phorugh ikaami thughatɨs phatɨ.’ ");
INSERT INTO spm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Gotɨna ambuuŋn gumasi bar, Samuelɨnɨ utugha ze, mee baro othuivamirɨ uthusir kharsir gunɨ mbɨkemi. ");
INSERT INTO spm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Got fhomɨra nona akam nigha zesi gumasi akamana aghavagharan meŋga aniiŋsima, gee men boorir mɨn ikhɨva, akaar aghavagharir kharsi ivhɨra gena andarsi. Got fhomɨra akama rɨŋgɨrana aghavagharan gena avhavir phorugha aŋga amuisima, gee men boorir mɨn ikhɨɨ, akama rɨŋgɨran aghavagharan khav, a ivhɨra genav. Got kamagh Abrahamɨm mbɨkemisi moghɨn, ‘Nɨɨna avhavir otara thav otoghtima, khɨɨ aŋmɨusua inderaghɨvɨra kha unuaghɨnan iti gumasi rako amisi bar mee ramuaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Got kamagh vhusvhusi, gee uvhuaghuvhuagh nono othevir maghatɨsia thaeghtima, kamaghɨ ramutima a inderaghɨvɨra gee ramuaŋga. Bighan khavɨusua a noni iŋaaran gumagham mbɨsevigha gemɨusua ufhuaragha ana amanda.” ");
INSERT INTO spm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ri Jon gumasi rako amisi vɨŋgɨvɨre itima, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasi rako, Gotɨ rɨphenan garir gumasir aphan koma, Sadiusiiŋn phoghɨn gumasi marsi, mee zaava aniiŋm mbato. ");
INSERT INTO spm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ara mee ikaaŋi, Pita ri Jon, Iesusa aremigha nom rɨkavisi bighan khavɨn gun gumasi rako amisi vɨŋgeeghi. Kamagha amuisima gumasir aphani, men navi aniiŋmɨusua bar maghatɨghi. ");
INSERT INTO spm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mee Pita ri Jonɨn agharaniiŋ usuiraghava aniiŋ nigha osɨmndɨsiva oraghava anda rɨkɨrir rɨphena rarɨghaousuava amuima, amɨn phɨri. Kamagha amuisi, mee aniiŋ rɨphena avhen khɨrtɨgh athɨsi aniiŋ ikha gua amɨrɨtusi rɨmaaŋra. ");
INSERT INTO spm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Gumasi rako amisira avhɨrara akaman khavɨ oraegha nɨghɨnɨghana aghavaghar aŋni iti. Uthughun khavɨn Kraisɨna andarsir rɨmbomboni bar ikhevigha gua 5,000ɨn aghanɨ utu. ");
INSERT INTO spm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Amɨrɨtusi rɨmaaŋra mara Judarir akoghɨn gumasiri ikii rako gumasira aphani koma Judariro othevi ikeeŋsi gumasi, mee Jerusalemɨn nori akuvaghav iti. ");
INSERT INTO spm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨv,, a ivhɨre itima, Kaiafas ri Jon ko Aleksander koma Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨvan andarsir marsi, mee ivhɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mee mbɨkemisima, gumasi Pita ri Jon nighava mena arɨmasi rɨfhaaŋn zesi, mee maghɨra aniiŋna azaaghi, “Aŋgo aghavagharan manav nigha, thɨɨŋn izɨɨn aŋgo kha bisigha amui?” ");
INSERT INTO spm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mee aniiŋn azarasima, Gotɨnɨ Utum Pita izɨvasima, a kamagh mem mbɨŋgeeghi, “Judarir akoghɨn gumasiri ikii rako gumasira aphani! ");
INSERT INTO spm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Gee ti aŋga akurasir gumaghanɨ usuan maghatɨghan khavɨusua aŋgana azaaŋsɨghaousua, gee ti ivhɨra ikaaŋmɨusua, gumaghan khav a manmaghɨre indera. ");
INSERT INTO spm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mamaghɨn gee bar ivhɨre ikaaŋtima Israelɨn iti tharsi mee ivhɨra bar ikeeŋgɨri. Khara Nasaretiiŋn gumagh Krais Iesusɨn izɨɨn gen arɨmasi rɨfhaaŋnɨ utughavi iti gumagh, a nomthegha indera. Gumaghan khav Iesus, gee ana nigha khani ighuuvan aŋga afhusi, ana aremisi Got aŋga amuisima a nomthegha rɨkavhi. ");
INSERT INTO spm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesus, ‘Akɨman khav rɨphenaŋga amuir gumasi aŋgi iphɨrphɨrigha aŋm mbatuesima, Ikhɨv thighira aŋga amuisi a rɨphenaŋgi isaghuphusir akɨmaŋgi ighe.’ ");
INSERT INTO spm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Unuaghɨnan khavɨn gumagha thav ena akuragham phatɨghami, bar phatɨ. Iesusɨni izɨɨra, ee mbɨghɨvɨghɨghemi. A nombɨra, ena akurɨvasi gumagh.” ");
INSERT INTO spm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mee Pita ri Jonɨn garima aniiŋ bar aghavagharighava avhighavisi phatɨghava mem mbɨŋgeema, mee aniiŋn ganighava ikaaŋi, aniiŋ surea amuisi phatɨ. Aniiŋ phura gumaghan khɨnani. Mee aniiŋn gara rɨŋgavan maghatɨgha amuigha kamaghɨusue, gumaghan khaniiŋ Iesusɨn phorughava arui. ");
INSERT INTO spm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mee gumaghan khavɨn gari, a ufhuaragha usu maghatɨghi, thighira, a Jon ri Pitan phorugha utughav itima, mee bigha thavɨm mbɨkɨman iŋgura. ");
INSERT INTO spm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kamagha amuisi mee akamana aghavagharan aniiŋga aniiŋsima aniiŋ Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphena thaegha akɨran zuima, mee aniiŋmɨusua akaa vɨsosi. ");
INSERT INTO spm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Mee norir azaaghi, “Ee manmaghɨra gumaghan khaniiŋ ramuti? Jerusalemɨni itir gumasi rako amisi, mee ikaaŋi, aniiŋ gamgaaŋn bighan bar ikhɨva amui. Ee bighan khuaŋn guaŋsiighem thughatɨs phatɨ. Anaaŋ guisimbaaŋra oto. ");
INSERT INTO spm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ee kamagh iphɨrphɨri, gumasi rako amisiri igharis tharsi bighan khavɨ oraghan thughatɨs phatɨ. Ee akaman bar aghavagharan aniiŋ ranɨɨŋtima aniiŋ nomthegh Iesusɨn izɨɨn gun thavɨm mbɨkɨman bar thaghɨri.” ");
INSERT INTO spm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mee guava aniiŋn dɨɨsima aniiŋ avhen gusima mee akamana aghavagharan aniiŋm mbɨŋgɨ kamaghɨusue, “Aŋgo nomthegh Iesusɨn izɨɨn gunɨ mbɨkɨmɨva gumasi rako amisi tharsir sure ramuan thaghɨri.” ");
INSERT INTO spm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Mee aniiŋm mbɨŋgema Pita ri Jon men akamɨ ikaragha kamaghɨm mbɨŋgeeghi, “Aŋga noniiŋ ganighava oraesi bisi aŋga andar guaŋsighem thughatɨs phatɨ, aŋga andar gunɨm mbɨkɨmɨvɨre ikaami. Gee nori nɨghɨnɨgh, othɨvhan manav Gotɨna arɨmasi rɨfhaaŋn indera, aŋga Gotɨn akamam mbaraghami, o aŋga gen akamam mbaraghami?” ");
INSERT INTO spm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Pita ri Jon Gotɨn gamgaaŋn amuisi gumagh inderaghava, a 40 pɨlan ombarigha afhira. Kamagha amuisi gumasi rako amisi nori bisir kharsir gari anda othuivisima, mee Gotɨni izɨɨ ufhii. Kamagha amuisima, gumasira aphani uvhuesan maghatɨghan aniiŋ ranɨɨŋmɨusua phura nɨghɨnɨsi, mee manmaghɨra aniiŋ ramuti. Mee aniiŋm mbɨsoghousua amuava mee gumasi rako amisir avhighavhisi mbɨŋgɨŋgɨr aghavagharir marsi aniiŋga amuighava aniiŋ amandasima aniiŋ zui. ");
INSERT INTO spm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan avhen itir gumasi Pita ri Jona thaesima aniiŋ azenaŋgi irɨgha nomthegha nona andarsivɨusua gu. Aniiŋ Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii rako igharisi gumasira aphani aniiŋn mbɨkemisir akaar gun nona andarsi bar mem mbɨkemi. ");
INSERT INTO spm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mee kamagh oraeghava nori akuvaghava Gotɨn phorugham mbɨŋgeeghi. Mee kamaghɨm mbɨŋgeeghi, “En Ikhɨv en gari thav, nɨɨ ovhee ko unuaghɨnaŋga amuighava, oŋar ivhɨra amuighava andar iti bisi ivhɨra bar andagha amui. ");
INSERT INTO spm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fhomɨra nɨɨnɨ Utum akaman mav en avhav Devit, a nɨɨn iŋaaran gumagh, nɨɨ akaman khavɨn aŋga anɨɨŋi. Devit kamaghɨm mbɨkemi, ‘Igharisirɨ unuaghɨnan gumasi theeghɨnamɨusua phum avesi? Israeli mee thoghousua othevir maghatɨsi ramuamɨusuava akaar kɨni vɨsosi? ");
INSERT INTO spm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Uŋuimbar ativasi tharsi, mee Gotɨ mbɨsoghousuava amui. Gumasiri ikii nori nigha Ikhɨvam mbɨsoghousua. Mee ivhɨra Got nom ee niamɨusua mbɨsevisi gumagham mbɨsoghousua.’ ");
INSERT INTO spm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bar guisimbaaŋra, Herot ri Pontius Pailat koma Israelir gumasi, rako igharisirɨ unuaghɨnan gumasi ivhɨra, mee Jerusalemɨnɨ uŋuun nori akuvaghava othevir maghatɨsir Gotɨn iŋaaran gumaghan aghuuŋ, Iesus ramuamɨusuava akaa vɨsosi. A nɨɨ fhomɨra non iŋarivɨusua mbɨsevisi gumagh. ");
INSERT INTO spm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mee nɨɨn gamgaaŋ ko nɨɨn nɨghɨnɨghan gɨn zui, nɨɨ fhomɨra otogha mbɨkemisir bisi. ");
INSERT INTO spm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ikhɨv, mee avhighevisir akaar eŋga aniiŋsi, nɨɨ akaar kharsighi nɨghɨnɨgh. Ena akuraghtima ee uthugh aghavagharighɨva avhighevhighem phatɨghɨva nɨɨna akamɨ ukunaŋgami. ");
INSERT INTO spm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nɨɨ nona afharimuun arɨmarɨr gumasir arɨghtima mee inderaghami. Nɨɨ gamgaaŋn bisira avhɨrara ko rɨŋgavan maghatɨgha amuir othevi ramutima anda Iesusɨn izɨɨno othuivhami, a nɨɨn iŋaaran gumaghan aghuuŋ.” ");
INSERT INTO spm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mee Gotɨn phorugham mbɨkemigha gɨvasima, mee itir aŋan anughava amandaghava, aŋnɨ Utum meŋgi izɨvasima, mee avhighavisi phatɨgha Gotɨna akamɨ ukuri. ");
INSERT INTO spm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Uthughun khavɨn nɨghɨnɨghana aghavaghar Iesusɨn iti tharsi, mee bar navanɨ uvhuavɨra ko nɨghɨnɨghanɨ uvhuavɨre iti. Men thav nombɨra bigha thavɨ nombɨna amendasi phatɨ, mee nori nighavɨra bisi barbar andar gari. ");
INSERT INTO spm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Iesusɨm mbɨsevisi gumasi, mee Gotɨn gamgaaŋn utugha Ikhiv, Iesusa aremigha nomthegha rɨkavisi bighan khavɨn gun gumasi rako amisi vɨŋgeeghi. Uthughun khavɨn Gotɨn ukuarkuvan ikhɨɨvara men phorugha iti. ");
INSERT INTO spm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Kamagha amuisi mena thav bigha thavɨn othevisi phatɨ. Gumasi unuasi rako rɨpheni iti tharsi, mee anda amaŋga andar aŋgɨro ovɨsi nigha zaava, Iesusɨm mbɨsevisi gumasigha anɨndima, mee anda nigha bisi phatɨsi gumasir akuruvasi. ");
INSERT INTO spm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Gumaghan mav Josev, a Livaina akhoghɨn gumagh. Iesusɨm mbɨsevisi gumasi mee Barnabasɨna aŋga arɨsi. Aŋm mbɨnɨɨŋ kamagh gu, gumasira akuruvagha gamgaaŋ meŋga anɨndir gumagh. Barnabas Saiprusɨn mɨghsɨmanɨ uŋuun ze. ");
INSERT INTO spm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","A nonɨ unuaghɨnan mav amandagha, aŋna aŋgɨro ovɨsi nighava Iesusɨm mbɨsevisi gumasigha anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gumaghan mav Ananaias, aŋna amuuŋ Safaira, aniiŋ ivhɨra non unuaghɨnan mav amandagha aŋnɨ uvhues nii. ");
INSERT INTO spm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mauthughura aniiŋ ivhɨre ikaaŋi, Ananaias aŋgɨr ovɨsir marsi nombɨusua andarɨ usuira. Ano ofhɨghan muaŋ nigha Iesusɨm mbɨsevisi gumasir khorigha amua meŋga anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","A meŋga aniiŋsima, Pita kamagh Ananaiasɨm mbɨŋgeeghi, “Nɨɨ theghousuava, satana thaesima a nɨɨn navan avhee izɨvasima, nɨɨ Gotɨnɨ Utuman khorigha amui? Nɨɨ theghousua unuaghɨnanɨ uvhuesana aŋgɨr ovhɨsir marsi nɨɨ nombɨusua andarɨ usuira? ");
INSERT INTO spm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Khara nɨɨnɨ unuaghɨna, nɨɨ nombɨ vhusvhusigha ana amanda. Aŋnɨ uvhuesan aŋgɨro ovhɨsi ivhɨra nɨɨn aŋgɨr ovhɨsirɨ. Nɨɨ manmaghɨra nɨghɨnɨgha nona aŋgɨro ovɨsir kharsir en khorigha amui? Nɨɨ gumasir khoru amuir phatɨ, nɨɨ Gotɨn khoru amui.” ");
INSERT INTO spm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias kamagh oraegha irɨghava aremi. Maghɨra gumasi rako amisi bighan khavɨ oraegha avhighevisima ikhɨv mee nii. ");
INSERT INTO spm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Maghɨra gumasir iŋgaa zaava aŋn khuma anuegha ana nigha akɨran gua ana umoghɨ athɨ. ");
INSERT INTO spm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Gumughun, aron iŋeendagh uthughun phunini ko mbɨkethav nigha gɨvasima, aŋna amuuŋ ikeeŋsi phatɨgha avhen zii. ");
INSERT INTO spm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A zima, Pita aŋna azaaghi, “Nɨɨ nam mbɨkɨm, khara guisim baaŋranɨ unuaghɨnɨ uvhues, nɨɨ man ko aŋgo ana nisi o?” Am mbɨŋgeema a kamaghɨm mbɨŋgɨ kamaghɨusue, “Aŋre, bar aŋnɨ uvhuesara.” ");
INSERT INTO spm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","An aŋm mbɨkemisima Pita kamagh aŋm mbɨŋgeeghi, “Aŋgo manmaghɨusua ivhɨra vhusvhusigha Gotɨnɨ Utuman khoru amui? Nɨɨ gan! Nɨɨn manan khum nigha gua umoghɨ athɨsi gumasi itɨman akamaniiŋn iti. Thighira mee ivhɨra nɨɨn khum nigh akɨran maŋŋanga.” ");
INSERT INTO spm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pita mbɨŋgɨvɨre itima, Safaira aŋnɨ usuaniiŋn irɨghava aremi. Gumasir iŋgaa avhen zaa garima aŋna aremisi mee ana nigha akɨran gugha aŋn mananɨ umoghɨ mbɨroghɨrama ana athɨ. ");
INSERT INTO spm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mauthughura avhighevhigheni ikhɨv Kraisɨna andarsi bar mem mbato. Gumasi, bisir kharsiva oraesi tharsi, mee bar ivhɨra avhighavighi. ");
INSERT INTO spm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iesusɨm mbɨsevisi gumasi gamgaaŋn bisira avhɨrara ko rɨŋgavan maghatɨgha amuir othevi avhɨrara, gumasi rako amisir thooŋn andagha amui. Nɨghɨnɨghana aghavaghar Iesusɨn iti gumasi rako amisi, mee Solomonɨn Azuaŋn mɨghasɨgha nori akuvi. ");
INSERT INTO spm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gumasir igharis tharsi, men phoghaousua thange nɨghɨnɨsi phatɨ. Mee meni izɨɨri ufha ikaaŋi, mee othɨvhana aghuuŋga amui. ");
INSERT INTO spm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Marsi nɨghɨnɨghana aghavagharan Ikhɨvan ikha mena avhen zuima, men rɨmbomboni bar guavanambo. ");
INSERT INTO spm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kamagha amuisi gumasi arɨmarɨr gumasi nigha mee athuui rako akurigha ariigha mee niia zaava utuavɨm mbɨroghɨn mee arɨsi. Mee kamagh nɨghɨnɨghana aghavaghar iti, aro Pita aŋgisiraghtima aŋn iŋeendagh arɨmarɨr gumasir iphɨn ikhɨti, mee nom inderaghami. ");
INSERT INTO spm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Uthughun khavɨn ivhɨra Jerusalem mbɨroghɨn itirɨ uŋuimbar sovsegher gumasira avhɨrara, mee nona arɨmarɨr gumasi rako amisi nigha ze. Mauthughura mee ivhɨra non gumasi rako amisirɨ unduur maghatɨsi aphasasi tharsi nigha zesima, mee barbar nomthegha indera. ");
INSERT INTO spm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii rako an akurasi tharsi, khara Sadiusiiŋn phoghɨna avhen itir gumasi. Mee Iesusɨm mbɨsevisi gumasi amuir bisivɨusua navi maghatɨghi. ");
INSERT INTO spm_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Sadiusiiŋn phoghɨn gumasir marsi menɨ usuiragha rɨvɨnan kɨrthɨghan ikhɨva athɨ. ");
INSERT INTO spm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mee rɨvɨnan kɨrthɨghan itima, rɨmaaŋn Ikhɨvan ensel ithɨɨ ukuigha mee nigha akɨran ze. ");
INSERT INTO spm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ensel kamaghɨm mbɨŋgeeghi, “Gee maaŋɨ, Gotɨ rɨphena mbɨroghɨnɨ utughɨva mɨghasɨgh ikaamiri ikɨran ikaman gun gumasi rako amisi vɨkɨm.” ");
INSERT INTO spm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iesusɨm mbɨsevisi gumasi amɨrɨtusi rɨmaaŋra, ensel mem mbɨkemisi moghɨn Gotɨ rɨphenam mbɨroghɨn gua, gumasi rako amisir surea amui. Mauthughura Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨv nona akuruvasi tharsir phorugha zaa, Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenana garir gumasir dɨɨsima, mee gua nori akuvagha iti. Israelɨn izɨɨri iti gumasira aruura nori akuvagha iti. Mee Iesusɨm mbɨsevisi gumasi nigh zaaousua rɨvɨnan kɨrthɨghan rɨphenan garir gumaghousua akama amanda. ");
INSERT INTO spm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mauthughura ganganir gumasi marsi gua rɨvɨnan khɨrthɨgha rɨphenan otogha garima mee khagh iti phatɨsima, mee nomthegha zaava bighan khavɨn gunɨm mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ee rɨvɨnan khɨrthɨgha rɨphenan garima mee inderaghavɨra an ithɨɨraakaa rɨkuusima, rɨvɨnan kɨrthɨghan rɨphenan garir gumasi aŋn ithɨɨra akaar utuivighav iti. Maghɨra ee ithɨɨ ukuigha garima, thav avheni iti phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mee gua bighan khavɨn gun mbɨkemisi, Gotɨ rɨphenan garir gumasir aphan koma Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii phura nɨghɨnɨsi, “Manmagha amisi bigh nomthegh othuivti?” ");
INSERT INTO spm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mauthughura gumaghan mav zaa kamaghɨusue, “Gee oraisire! Gee rɨvɨnan khɨrthɨgha ariisi gumasi Gotɨ rɨphena mbɨroghɨn utuivighava gumasi rako amisir surea amui.” ");
INSERT INTO spm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kamagha amuisima Gotɨ rɨphenan garir gumasir aphan, a nombɨn phorugha iŋaari tharsi, men phorugha gua Iesusɨm mbɨsevisi gumasi nigha zii. Mee kamagh avhighavighava, gumasi rako amisi aŋgɨr meŋgi nivighemi, kamagha amuigha mee phura inɨmɨra mee nigha zii. ");
INSERT INTO spm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Mauthughura Gotɨ rɨphenan garir gumasi, mee Iesusɨm mbɨsevisi gumasi nigha zaava Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenana avhen iti gumasir arɨmasi rɨfhaaŋ mera afhe. Mauthughura Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨv, kamaghɨm mbɨŋgeeghi, “Ee akamana aghavagharan geŋga anɨŋga mbɨŋgeeghi, gee Iesusɨn izɨɨn gumasi rako amisir sure ramua thaghɨri! Gee orasi phatɨgha men surea amuima gen suren mbɨŋgɨmɨŋgɨ Jerusalem bar aŋga arui. Gee kamaghɨusue, ee Iesusɨ mbɨsuesi ana aremi.” ");
INSERT INTO spm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mem mbɨkemisima Pita Iesusɨm mbɨsevisi gumasir igharis tharsir phorugha, mee kamaghɨm mbɨŋgeeghi, “Ee Gotɨ oraghami, ee gumasi varaghan thughatɨs phuu.” ");
INSERT INTO spm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gera Iesusɨ mbɨsuegha khani ighuuvan ana gurasima aŋna aremi, ena avhav Got, Iesusɨ ufhuesi a nomthegha rɨkavhi. ");
INSERT INTO spm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Got ana nigha nona agharan guvɨn aŋna athɨsima, ana mɨghasɨgha itir ikɨran aghuuŋ enɨ ufhuaragha zui gumagh ko gumasir akuruvaghamir gumagh ikaami. A Israeli ramuightima mee nɨghɨnɨsigh ɨraghti Got meno othevir maghatɨsi gɨna amaaŋga. ");
INSERT INTO spm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ee Got amuisi bisir kharsir gunɨm mbɨŋgeeghi. Gotɨnɨ Utum ivhɨra Got amuisi bisir kharsir gunɨm mbɨŋgeeghi. Aŋm mbaragha aŋn gɨn zui tharsi, Got nonɨ Utum meŋga anɨndi. ");
INSERT INTO spm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenana avhen itir gumasi kamagh Iesusɨm mbɨsevisi gumasir akamam mbaraegha men navi memɨusua bar maghatɨghi. Mamagh amuigha mee mem mbɨsueghti mee aremighaousua nɨghɨnɨsi. ");
INSERT INTO spm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Uthughun khavɨn Farisiiŋn akoghɨn gumaghan mav Gamaliel, Judariro othevi surea amuir gumagh. Gumasi rako amisi aŋni izɨɨ ufhii. A Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan avhen rɨkavhigha utugha, mbɨŋgeeghi, Iesusɨm mbɨsevisi gumasi thange akɨran ikhɨɨ. ");
INSERT INTO spm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","A mbɨŋgɨŋgɨr kharsigha amui, “Israeliiŋn akhoghɨn gumasi, gee othɨva thav gumasir kharsi ramuamɨusua inderaghavɨra nɨghɨnɨghri. ");
INSERT INTO spm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Boghumɨra Teudas otogha kamagh nombɨ mbɨŋgɨ kamaghɨusue, ‘Khɨɨ gumaghan aphanan mav.’ A mbɨkemisima 400ɨn mɨn gusi gumasi aŋn gɨn gue. Uthughun khavɨn gavman aŋm mbɨsuesima, aŋna aremi. Kha uthughun aŋn gɨn zuir tharsi mee bar atamatamɨra are. Mee amuisi bighan khav aghaa otosi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Teudas aremigha gɨvasima aŋn gɨn gavman gumasi rɨmborir uthughun oto. Galilin distrighɨn gumaghan mav Judas a gumasir bɨsan mavɨnɨ ufhuaragha gua mee gavmanɨn phorugham mbɨsosi. A ivhɨra aremisi aŋn gɨn zui tharsi, mee atamatamɨra are. ");
INSERT INTO spm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kamagha amuisima thighira, bighan khav khɨɨ kamagh gee mbɨkɨmamɨusua. Bigha thavɨn gumasir kharsir amua thaghɨri! Mee thaeghtima mee mara maaŋɨ! Gee phura gan, men iŋaar gumagha thavɨn iphɨnɨ uthughɨva, deeŋgirɨghami. ");
INSERT INTO spm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mee Gotɨn izɨɨnɨ uthughɨva bigha thavɨ ramuighti, gee men thɨvan thughatɨs phatɨ. Gee inderaghɨva ganri! Gee Gotɨn phorugh nori vɨsueghemi.” Mee Gamalielɨn nɨghɨnɨghan gɨn gue. ");
INSERT INTO spm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mauthughura Iesusɨm mbɨsevisi gumasir dɨɨsima, mee avhen guesima mee phura mee fhasoroghi. Mee Iesusɨn izɨɨn bisi vɨkɨman men thɨvagha mee thaesima mee gue. ");
INSERT INTO spm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mee gua mbɨŋgeeghi, “Got emɨusua bar iphuigha ee mbɨnamɨnaaŋ athɨsi, ee Iesusɨni izɨɨn osɨmndɨsi nii.” Mee kamagh Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan avhen itir gumasi thaegha gua bari iphui. ");
INSERT INTO spm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mee mɨghasɨgha gua Gotɨ rɨphenan mbɨroghɨn guava igharisi gumasir rɨphenir gua akaar aghuuir gumasi rako amisi vɨŋgɨva men surea amuavɨre iti. Mee akamɨ ukura kamaghɨm mbɨŋgeeghi, “Iesus a Got nom ee niamɨusua mbɨsevisi gumagh.” ");
INSERT INTO spm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Uthusir kharsi Iesusɨn suren gumasi rako amisir rɨmbomboni bar guavanandi. Kha uthughun suren gumasir marsi Grighiiŋna akama mbɨŋgema, marsi Aramiiŋna akama mbɨŋgeeghi. Grighiiŋna akamaŋga aghui gumasi rako amisi mee kamaghɨusue, “Uthusira avhɨrara gee mɨghasɨgha amuuir ozɨrir aghae phatɨsi tharsira akuruvasi, Grighiiŋna amuuir ozɨrira akuruvasi phatɨ.” Bighan khavɨusua mee Aramiiŋga atari. ");
INSERT INTO spm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kamagha amuisima Iesusɨm mbɨsevisi gumasir 12 pɨla, mee suren gumasi bar men dɨɨsima mee zaa nori akuvasima, mee kamagh mem mbɨŋgeeghi, “Ee Gotɨna akamɨ ukurir iŋaara thaeghɨva aghan iŋaara ramuaŋga, kamagh a inderasi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kamagha amuisima, ena avheeŋmbuagha, gee norir thooŋn 7 pɨlan gumasia mbɨsevi. Men othevi, gumasi rako amisir arɨmasi rɨfhaaŋn bar inderagha, Gotɨnɨ Utum meŋgi izɨvasima, mee ivhɨra nɨghɨnɨghan aghuuŋ iti. Ee mee nighɨva iŋaaran khavɨra athɨghtima mee aŋn ganaŋgami. ");
INSERT INTO spm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ara ee nori iŋaaran khaniiŋ ramuaŋga. Ee Gotɨn phorughum mbɨkɨmɨva, Gotɨna akamana aghuuŋn gumasi rako amisir sure ramuaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mem mbɨkemisima gumasi rako amisi akaman khavɨ oraegha bar aŋn vhusvhusi. Mee Stivena mbɨsevi, a bar nɨghɨnɨghana aghavaghar iti gumaghan mav, Gotɨnɨ Utum bar aŋgi izɨva. Mee Filip ri Prokorus, Nikanor, Timon, Parmenas koma Nikolas mea mbɨsevi. Nikolas a Antioghiiŋnɨ uŋuun gumagh, a Judarir akoghɨn gumagh phatɨ, a ufhuaragha Judariro othevigha amuava andar gɨn zui. A thighira Kraisɨn gɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mee gumasir kharsi nigha Iesusɨm mbɨsevisi gumasir arɨmasi rɨfhaaŋn gusima mee afharir men aphanir iphɨn athɨgha memɨusua Gotɨn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Uthughun khavɨn Gotɨna akam bar ikhevigha barɨ uŋuimbar gue. Akaman khav Jerusalemɨni itir suren gumasigha amuima mee rɨmbombonɨ uzuamɨra guavanambo. Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasira avhɨrara Gotɨn akamam mbaraegha nɨghɨnɨghana aghavaghar aŋni ikha ivhɨra aŋn gɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Got guisimbaaŋra Stivena akuruvagha, ukuarkuvan othɨv ko gamgaaŋn aŋga aniiŋsima, a gumasi rako amisir thooŋn rɨŋgavan maghatɨgha amuir othevi rako gamgaaŋn bisigha amuima anda othuivi. ");
INSERT INTO spm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Marsi rɨkavhigha Stivenɨn phorugha mee akaar nori vatosi. Mee Gotɨn phorugha mbɨŋgeer rɨphen aŋn izɨɨ Osɨmndɨsi Phatɨsi Gumasi Rɨphen. Mee Sairininɨ uŋuun gumasi, rako Aleksandrianɨ uŋuun gumasi, ko Silisian distrighɨn ko Esian distrighɨn gumasi. Mee Stivenɨn phorugha nori vatosi. ");
INSERT INTO spm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Uthughun khavɨn Gotɨnɨ Utum nɨghɨnɨghan aghuuŋ Stiven aŋga anɨɨŋi. Kamagha amuisi, Judarir akoghɨn gumasi ana akaar iŋgarɨgha ramuan iŋgura. ");
INSERT INTO spm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mee moŋgava, gumasir marsi khorir amuamɨusua mee bɨra mbɨŋgeeghi, “Gee kamagh mbɨkɨm, ‘Ee orasima Stivenɨm mbɨŋgɨŋgɨr maghatɨsira Moses ri Gotɨ amui.’ ” ");
INSERT INTO spm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Othɨvhan khavɨn mee gumasi rako amisi, gumasira aphani rako Judariro othevi ikeeŋsi gumasi navigh amuima anda rɨkavhi. Mee Stivenɨmɨusua gughava aŋnɨ usuiragha ana nigha Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenana avhen iti gumasir arɨmasi rɨfhaaŋ gue. ");
INSERT INTO spm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mee khorirɨ mbɨŋgɨŋgɨ tharsir aŋ ramuamɨusua gumasir marsi nii. Gumasir kharsi kamaghɨm mbɨŋgeeghi, “Gumaghan khav mɨghasɨgha akaar maghatɨsi Gotɨ rɨphenam mbɨŋgɨva ivhɨra Moses osɨrisiro othevi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ee orasima a kamaghɨm mbɨŋgeeghi, ‘Gumaghan khav Nasaretiiŋn gumagh, Iesus, a Gotɨ rɨphenan khava rɨphɨrighɨva aŋra afharaveghɨva, Moses fhomɨra eŋga aniiŋsir othevi oteghɨvɨkɨnighemi.’ ” ");
INSERT INTO spm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kha uthughun Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenana avhen iti gumasi barbar apiighav ikava arɨmaghaniiŋ barɨm mbɨghɨravɨra Stivenɨn gari. Mee garima an khom enselɨn mɨn afhogha sii. ");
INSERT INTO spm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨv, Stivena azaaghi, “Mee niiŋga asir akaar kharsi, anda guisimbaaŋra, o?” ");
INSERT INTO spm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mee mbɨkemisima Stiven men akam ikara, “Nana aveeŋmbua rako nan inasi gee nambaragh! Ena avhav Abraham, a thighar Haranɨnɨ uŋuun maŋŋanga, a Mesopotemianɨ unuaghɨnan ikhavɨre itima, aŋaran iti Got aŋm mbato. ");
INSERT INTO spm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aŋm mbɨŋgɨ kamaghɨusue, ‘Nɨɨ nona andarsir ko nonɨ unuaghɨna thaeghɨva khɨɨ nɨɨn khɨvamirɨ unuaghɨnan maaŋɨ.’ ");
INSERT INTO spm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham Kaldianɨ unuaghɨna thaegha guava Haranɨnɨ uŋuun iti. Uthughun khavɨn aŋni inaghavesɨn ovhevheeŋn gɨn, Got ana amandasi unuaghɨnan khavɨ ee thighira aŋn iti. ");
INSERT INTO spm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gotɨ unuaghɨnan asɨgha thuaaŋ rɨthugha a nona avavigha aniiŋsi phatɨ. Got aŋn phorugha akama rɨkɨra kamaghɨusue, aŋn phorugh aŋna avhav tharsi ivhɨra unuaghɨnan khavɨn ikaami. Uthughun khavɨn Abraham nombɨ boori phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Got kamagh Abrahamɨm mbɨŋgeeghi, ‘Nɨɨn avhavi, igharisirɨ unuaghɨnan ikaami. Mee gua igharisi unuaghɨnan iŋaari gumasir kɨnir mɨn itima 400 pɨlan ombarira avhen mee phuv meŋga amui. ");
INSERT INTO spm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Khɨɨ mee meŋga amuisiro othevir maghatɨsi khɨɨ gɨna anda ikaravaghami. Gɨn mee unuaghɨnan khava thaegh akɨran zɨva aŋanan khavɨn ikhɨva nan izɨɨ ufhaami.’ ");
INSERT INTO spm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Got fhomɨra unuaghɨnana asɨgha thuaaŋn Abraham ranɨɨŋmɨusua akama rɨŋgɨrana aghavaghara mbɨkemi. Gumughun Got akaman aghavagharan khavɨn aŋga anɨɨŋga kamaghɨusue, ‘Nɨɨ othɨvhan khavɨn gɨn maaŋɨva nona andarsi bar men momooŋn niro ofhɨsia rɨghorighɨri. Gɨn gee bighan khavɨn gan nɨghɨnɨghami, “Got fhomɨra ena avhav Abrahamɨn phorugha rɨkɨrisira akam.” ’ Kamagha amuisima Abrahamɨna amuuŋ Aisaghɨ otesima, 8 pɨlanɨ uthusir gɨn Abraham Aisaghɨn momooŋn nerɨn ofhɨgha rɨtu. Aisagh Jekovɨn inaghavesɨn otogha Jekovɨn nerɨn ofhɨgha rɨtu. Bar gɨn Jekov ena avhavir 12 pɨlan inaghavesi otogha ivhɨra men momooŋn niro ofhɨsi rɨghori. ");
INSERT INTO spm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Ena avhavir, navira avherir Josevɨn maghatɨgha Isivɨnɨ unuaghɨnan iŋaaran gumaghan ikhaaousuava ana amanda. Uthughun khavɨn Got aŋn phorugha ikha aŋn osɨmndɨsia gɨvagha aŋna akura. Got nɨghɨnɨsir aghuira Josev aniiŋsima ana othevira aghuui Isivɨ ativasi gumagh khɨvasima, a bar aŋn vhusvhusigha aŋga amuisi a Isivɨn gumaghana aphanan mɨn oto. A ivhɨra aŋn rɨphenan bisi gari. ");
INSERT INTO spm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Uthughun khavɨn aghae othevisima Isivɨnɨ unuaghɨnana avheni itirɨ uŋuimba rako Kenanɨnɨ unuaghɨni itirɨ uŋuimba osɨmndighani ikhɨv memba oto. Uthughun khavɨn gumasi rako amisi osɨmndɨghan ikhɨv mee nii. Ena avhavi ivhɨrama aghae phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kha uthughun Jekov orasima aghae Isivɨnɨ unuaghɨni itima, mamagha amuigha, a ena avhavi amandasima mee ufhuarasir arorɨa amua zui. ");
INSERT INTO spm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mee nomthegha zuir arorɨn gua, Josevɨn garima a nombɨn gun nona avheeŋmbua vɨkeemigha, maghɨra men gun ativasi gumagha mbɨkemisima a mee ikaaŋi. ");
INSERT INTO spm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kha bighaaŋn gɨnɨ, Josev noni inaghavhesɨusuava akama amaŋga dɨɨsima, Jekov nona andarsi rakua mee aŋna aghan gue. Mee rɨmbombon 75 ɨnɨ utu. ");
INSERT INTO spm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Gumughun Jekov Isivɨnɨ unuaghɨnan gughava aremi. Ena avhavi mee ivhɨra arɨɨghire. ");
INSERT INTO spm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mee men khuu nigha nomthegha Sekemɨnɨ uŋuun zegha mee akɨman umoghɨn thooŋga arɨsi, Abraham fhomɨra Sekemɨnɨ uŋuun ikha Hamorɨn otarir aghaanɨ uvhuesirɨ umogh. ");
INSERT INTO spm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Gumughun Got Abrahamɨn phorugha rɨkɨrisir akamana aghavagharan guisimbaaŋra othuivousuava aghangera zima, ee Israeliiŋ gumasi rako amisi Isivɨnɨ unuaghɨnan iti tharsi ee bar avhɨrekevi. ");
INSERT INTO spm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Gɨn ativasir gumaghan igharisi thav, a Josev thange ana ikeeŋsi phatɨgha, a Isivɨn ativasi gumagh iti. ");
INSERT INTO spm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A en gumasi rako amisir khoru amua othevir maghatɨsi ena avavigha amui. Gumughun mee non boorir irɨrɨvi phura akɨran usueghava, arɨmamɨusua meŋga aghorima mee arɨghɨre. ");
INSERT INTO spm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Uthughun khavɨn Mosesɨni inaghamuuŋ aŋm mbate, a Gotɨna arɨmasi rɨfhaaŋn bar inderasir otar. A ikɨniiŋn phunini ko mbɨkethavɨn noni inaghavesɨ rɨphenan itima, aŋni inaghamuuŋ nombɨra aŋn gari. ");
INSERT INTO spm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Gɨn mee ana nigha akɨran an athɨsima, ativasi gumaghan guiv ana nigha gua non otaran mɨn aŋn gari. ");
INSERT INTO spm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Gumughun Moses Isivir nɨghɨnɨghan aghuuŋ nigha mbɨŋgɨmɨŋgɨr aghavaghari rako iŋaarira aghavagharigha amui. ");
INSERT INTO spm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Gumughun Moses 40 pɨlan ombaarir ana rɨtusima, a nona andarsi Israelir ganamɨusua nɨghɨnɨsi. ");
INSERT INTO spm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A Israelɨn mavɨn garima Isivɨnɨ unuaghɨnan gumaghan mav aŋm mbɨsogha iphasavɨra aŋga amui. Mauthughura Moses gua aŋn akuruvagha, Isivɨn gumaghan othɨvhan maghatɨgh ikarvagha, aŋm mbɨsuesi ana aremi. ");
INSERT INTO spm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Uthughun khavɨn Moses kamagh nɨghɨnɨsi, ana andarsi kamagh ikeeŋgɨm mbɨkɨmaŋga, Got men akuruvaghaousuava na amanda. Mee bar ikeeŋsi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Amɨrɨtusi rɨmaaŋra Moses garima Israelɨn gumaghaniiŋ noniiŋm mbɨsosi. Mauthughura aniiŋ noniiŋm mbɨsosima a gua navana amɨɨŋndɨghan aniiŋga anɨɨŋga aniiŋm mbɨŋgeeghi, ‘Mani, aŋgo oragh, aŋgo aveeŋndɨniiŋ, aŋgo thoghousua kaghɨra noni mbɨsosi?’ ");
INSERT INTO spm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Thighira osɨmdɨsigha mbɨnɨŋmbaaŋga amuisi gumagh, a Mosesɨ arughavɨkɨnigha kamaghɨusue, ‘Thɨɨŋra nɨɨ ambɨsevisi nɨɨ en gumaghan aphan ko osɨmndɨsiva oraghava anda rɨkɨrir gumagh? ");
INSERT INTO spm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nɨɨ boghumɨn Isivɨnɨ unuaghɨnan gumagham mbɨsuesi ana aremisi moghɨn, nɨɨ thighira nam mbɨsoghusua nam mbɨsueghti khɨɨ arɨmaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","An aŋm mbɨkemisima Moses kamagh oraegha Isivɨnɨ unuaghɨnan thaegha ara gua Midianɨnɨ unuaghɨnan ikha amuuŋn ikhava otaran phuninim mbate. ");
INSERT INTO spm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Gumughun 40 pɨlan ombaarir gɨvasima, Moses gumasi iti phatɨsira aŋanan khavɨn itima Got non enselɨn mav aŋmɨusua ana amanda. Mauthughura a gua Sainain oraghɨn aghan gua garima arivam mbɨzɨɨ khaa nosima enselɨn mav ivhɨra iti. ");
INSERT INTO spm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Uthughun khavɨn a bighan khavɨn ganigha rɨŋgavan maghatɨgha amui. A bar aghangera maaŋɨ inderaghɨvɨra ganamɨusuava amuava, Ikhɨvan ithɨɨŋ mbarasi, ");
INSERT INTO spm_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Khɨɨ nɨɨn avhav Got, Abraham ri Aisak koma Jekov.’ Am mbɨŋgeema, Moses inɨgha ganan avhighavighi. ");
INSERT INTO spm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mauthughura Ikhɨv aŋm mbɨŋgeeghi, ‘Nɨɨ utughav itir aŋan, khara nanɨ unuaghɨn khɨɨ aŋn thɨva. Kamagha amuisi, nɨɨ nona aŋgarir shari usue. ");
INSERT INTO spm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nan gumasi rako amisi Isivɨnɨ unuaghɨnani itima mee othevir bar maghatɨsira meŋga amuima khɨɨ gani. Khɨɨ mena arareeva oraegha, men osɨmndɨsia gɨvaousua zighiri. Nɨɨ zɨɨ. Khɨɨ nomthegh Isivɨn nɨɨ amaaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mosesɨn khavɨra, Israeli aŋna agharkuvigha kamaghɨusue, ‘Thɨɨŋra nɨɨ ambɨsevisi nɨɨ en gumaghan aphan ko osɨmndɨsiva oraghava anda rɨkɨrir gumagh?’ Khara anara, Got nombɨ men gumaghana aphan amandasi a nomthegha mee niamɨusua zii. Got enselɨn mav amandasima ensel ariv sii khana avhen otosi Moses aŋn gara Got amandasir akaa nii. ");
INSERT INTO spm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","A mee nigha Isiva thaeghaousuava rɨŋgavan maghatɨgha amuir othevi rako gamgaaŋn bisira avhɨrara amui. A Isivɨnɨ unuaghɨn ko Retsin amaaghasɨgha rɨmɨni ikhɨvan othevir kharsigha amui. A gumasi iti phatɨsira aŋanan a 40 pɨlan ombaarir andagha amui. ");
INSERT INTO spm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Khara Mosesɨn khavɨra, a Israeli mbɨŋgɨ kamaghɨusue, ‘Got gen thooŋn akam nigha zii gumagha thav nan mɨn ana mbɨsevighemi.’ ");
INSERT INTO spm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Gumughun Israeli gumasi iti phatɨsira aŋanan nori akuvagha itima a mena arɨghan iti, a Sainaian oraghɨn guavanambosi ensel aŋm mbɨkemi. Aŋna akaman aŋamɨre iti thav ee ranɨɨŋmɨusua, aŋga nɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ena avhavi Mosesɨna akaava oraghan iphɨrphɨri. Mee aŋm mbɨze vatosi. Men navira avherir avhen mee nomthegh Isivɨnɨ unuaghɨnam maŋŋamɨusua. ");
INSERT INTO spm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mee Aronɨ mbɨŋgeeghi, ‘Ee ikeeŋsi phatɨ, ee nigha Isivɨnɨ unuaghɨnana akɨran zesi gumaghan khav, Moses, theghɨnan bighaaŋ aŋmbato. Nɨɨ emɨusua marɨvir gua ramuightima anda enɨ ufhuaraghɨ utuavɨn maŋŋaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Uthughun khavɨn marɨvan khom mee burmagharɨnɨ uŋuughan mɨna aŋga amui. Mee ana azenara afhaghava ana aphuraphurava aghae rako bisir aŋga anɨɨŋgava aŋni izɨɨ ufhii. Mee aghughuiigha amua inighinighava isaman ikhɨva amui. ");
INSERT INTO spm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kamagha amuisima Got akɨrɨ ragha meŋga asegha mee thaesi mee ovheen itir mbɨkovir izɨɨri ufhii. Gotɨn akam nigha zesi gumasi mee ana osɨrisi a mem mbɨghar iti. A kamaghɨusue, ‘Gee Israeliiŋn akhoghɨn gumasi, mara gee 40 pɨlan ombaarir gumasi iti phatɨsira aŋanan ikha Gotɨn aphuraphura aghae rako bisir aŋga anɨndi? Bar phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gee asaaŋ Moleghɨn marɨvan khoman ambɨkav gee aŋgi isaghuphugha, ivhɨra asaaŋ Refanɨm mbɨkovan iŋeendaghe isaghuphughava arui. Kha asaaŋni, gee aniiŋn othevir gɨn maŋŋamɨusua aniiŋga amui. Kamagha amuisima, Got genɨ unuaghɨnan gem mbatueghɨva, gee amandaghtima gee maaŋɨ Babilonɨnɨ unuaghɨna thaeghɨva maaŋɨ uvhuaaŋn ikaami.’ ");
INSERT INTO spm_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ena avhav gumasi iti phatɨsira aŋanan itima Gotɨn ambɨkav men phorugha iti. Rɨphenan khavɨn avhen mee ikaaŋi, Got men phorugha iti. Got Mosesɨ mbɨkemigha aŋn khɨvasi moghɨra, Israeli mbɨkemisi mee aŋga amui. ");
INSERT INTO spm_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ena avhavi ambɨkav nigha, aŋgɨ uphugha Josuan gɨn zii. Mee gua igharisi uŋuun guesima, Got mena akuragha aŋni itir gumasi rako amisigha avharasima, mee ma unuaghɨn nii. Ambɨkhavan khav men phorugha ikhavɨre itima Devitɨnɨ uthugh oto. ");
INSERT INTO spm_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devit Gotɨna arɨmasi rɨfhaaŋn inderasi Got inderaghavɨra aŋga amui. A kamagh Gotɨn azaaghi, ‘Khɨɨ Jekovɨn Gotɨusua rɨphena ramuaŋga, o?’ An aŋna azarasima Got mbɨŋgeeghi, ‘Phatɨ.’ ");
INSERT INTO spm_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Got mbɨkemigha gɨvasima, gɨn Solomonra aŋmɨusua rɨphenan iŋaari. ");
INSERT INTO spm_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Bar iphɨn iti Gotɨn gumasi amuisi rɨphenir iti phatɨ. Gotɨna ambuuŋn gumagh kamaghɨm mbɨkemi, ");
INSERT INTO spm_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Got kamaghɨusue, “Ovhee nana ambirembiiŋna aŋan. Unuaghɨn khɨɨ nonɨ usuaniiŋ asira aŋan. Manmagh garir rɨphena thav, nɨɨ namɨusua aŋ ramuamɨusua? Khɨɨ avughusuamira aŋan managh iti? ");
INSERT INTO spm_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bisir kharsi, khɨɨ bar andagha amui.” ’ ” ");
INSERT INTO spm_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Mauthughura Stiven maghɨra Judariro osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan gumasi vɨŋgeeghi, “Gee bar orasi phatɨsi tharsi! Gen navi rako nɨghɨnɨsi, Got ikeeŋsi phatɨsi gumasir navir mɨna amui! Gee nona avhav mɨra amui! Gee ivhɨra Gotɨnɨ Utum mɨghasɨgha aŋm mbatosi! ");
INSERT INTO spm_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Geni inasi osɨmndɨsir Gotɨna ambuuŋn gumasi barbar meŋga anɨndi. Mee fhomɨra Gotɨna arɨmasi rɨfhaaŋn inderasi gumagh zaamir bighaaŋn gunɨm mbɨŋgema, gen inasi mee mbɨsosi mee arɨɨghire. Thighira gee ana nigha gumasir maghatɨsir afharɨ athɨgha aŋm mbɨsuesi an aremi. ");
INSERT INTO spm_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Enseli Mosesɨm mbɨkemigha aŋga aniiŋsi othevi ana andar geŋga aniiŋsima gee andar gɨn zui phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mee kamagh oraegha, mee navir avheri aŋmɨusua bar maghatɨgha aŋmɨusua nona atharigh ivi. ");
INSERT INTO spm_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mauthughura Gotɨnɨ Utum Stivengi izɨvasima, a khogha Gotɨnɨ uŋuun Gotɨn aŋaran aghavagharan garima Iesus Gotɨna agharan guvɨnɨ utughav iti. ");
INSERT INTO spm_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","A kamaghɨm mbɨŋgeeghi, “Gee Gan! Khɨɨ Gotɨnɨ uŋuun garima, a ukuighirɨsima Gumasir Otar Gotɨna agharan guvɨn utughavi iti.” ");
INSERT INTO spm_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mee kamagh oraegha mbɨghɨravɨra dɨɨva arava afharir nonɨ ukuaria phɨrigha, akhɨrɨsiigha aŋmɨusua zui. ");
INSERT INTO spm_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mee ana ukurugha uŋuuni ikhɨvan akɨran gugha, maghɨrama aŋgɨr aŋgi inivi. Akamana aŋga asi tharsi nona akɨran sharasi shaarɨ usuegha gumaghan ikaman mavɨna aŋgarira aghan anda usue. Aŋni izɨɨ Solɨn. ");
INSERT INTO spm_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mee aŋgɨr aŋgi inivavɨre itima, Stiven Gotɨn phorugham mbɨŋgeeghi, “Ikhɨv Iesus, nan utum nii.” ");
INSERT INTO spm_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","A noni itɨvɨnia rɨphɨrigha irɨgha mbɨghɨravɨra deeghi, “Ikhɨv, men othɨvhan maghatɨghan khav aŋgɨ nɨghɨnɨgha thaghɨri, ana gɨna amanda.” A kamaghɨm mbɨkemigha maghɨrama aremi. ");
INSERT INTO spm_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Uthughun khavɨn Sol ivhɨre ikha bighan khavɨn ganigha kamaghɨusue, a indera. Kha uthughun mee Stivenɨm mbɨsuesima ana aremi. Ana aremisima mee Jerusalemɨni iti Kraisɨn phorus tharsi phuvɨra mee mbɨsogha, othevir maghatɨsir meŋga amui. Kamagha amuisima, Kraisɨn phorus tharsi bar ara Judian distrigh ko Samarian distrighɨn gue. Uthughun khavɨn Iesusɨm mbɨsevisi gumasi Jerusalemɨni iti. ");
INSERT INTO spm_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mauthughura gumasi Gotɨn apheeŋn iti tharsi, mee Stivenɨn khum nigha umoghɨ athɨgha phuvɨra aŋmɨusuava azii. ");
INSERT INTO spm_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kha uthughun Sol Kraisɨn phorus tharsi mee ikava, mee rafharavaghavhɨrei rɨpheni uvhuaghuvhuagha andar gua gumasi rako amisi ivhɨra mee nigha mee akuvagha rɨvɨnan khɨrthɨgha arɨsi. ");
INSERT INTO spm_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Aresir gumasi rako amisi mee ma itirɨ uŋuimbar akaman aghuuŋ ana ukuri. ");
INSERT INTO spm_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Uthughun khavɨn Filip Samarian distrighɨn avhen itirɨ uŋuun mavɨn gua, Got nom ee niamɨusua mbɨsevisi gumaghan akamɨ ukuri. ");
INSERT INTO spm_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A gamgaaŋ iti bisigha amuima, nori akuvasi gumasi rako amisi nori aŋm mbɨzeva orasima, a rɨŋgavan maghatɨgha amuir othevigha amuima anda othuivima, mee andar garava ukuari ariigha bar inderaghavɨra aŋm mbarasi. ");
INSERT INTO spm_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mee Filivɨn garima a unduur maghatɨsir gumasi rako amisigha aphasasi tharsi vatosima, mee fhigha dɨɨva arava mee thamɨraghava akɨran zui. Gumasira avhɨrara usue rako afhari amɨrasi tharsi rako usue maghatɨsi tharsi ivhɨra nomthegha indera. ");
INSERT INTO spm_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kamagha amuisima, uŋuun khavɨn amisi rako gumasi bari aŋgi iphui. ");
INSERT INTO spm_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gumaghan mavɨn izɨɨ Saimon, a fhomɨra Samarianɨ uŋuun ikha atomtorir maghatɨsigha amuima, Samarian gumasi rako amisi aŋn ganigha rɨŋgavan maghatɨgha amui. Ana mɨghasɨgha kamaghɨm mbɨŋgeeghi, “Khɨɨ gumaghan ikhɨv.” ");
INSERT INTO spm_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Gumasir ikii koma gumasi rako amisir kɨni, mee Saimonɨn akamamba oraghaousua vhusvhusi. Mee kamaghɨm mbɨŋgeeghi, “Kha asaaŋn gamgaaŋ, aŋni izɨɨ Gamgaaŋn Bar Ikɨv, Saimon a ma gamgaaŋ.” ");
INSERT INTO spm_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A uthusira avhɨrara atomtorir maghatɨsigha amuima mee andar garava, rɨŋgavan maghatɨgha amui. Bighan khavɨusua, mee aŋna akamamba oraghaousua vhusvhusigha aŋn gɨa arui. ");
INSERT INTO spm_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Thighira Filip, a Got kha bisigha ativamirɨ uthughun akamana aghuuŋ ko Krais Iesusɨn izɨɨn akamɨ ukuri. Kamagha amuisima, gumasi rako amisi nɨghɨnɨghana aghavaghar Filivɨn akaman ikava, mee urue. ");
INSERT INTO spm_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mauthughura Saimon ivhɨra nɨghɨnɨghana aghavaghar ikava a ivhɨrou urue. Uthughun khavɨn Saimon Filivɨn gɨa arua garima, Filip rɨŋgavan maghatɨgha amuir othevi rako gamgaaŋn bisir ikiigha amuima anda othuivima, a rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Uthughun khavɨn Iesusɨ mbɨsevisi gumasi Jerusalemɨni iti tharsi orasima, Samarian gumasi rako amisi Gotɨna akam nigha gɨvasima, kamagha amuisima mee Pita ri Jon amandasima aniiŋ memɨusua gu. ");
INSERT INTO spm_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Samarian gumasi rako amisi, mee Ikhɨv Iesusɨni izɨɨn uruegha, mee Gotɨnɨ Utum nisi phatɨ. Kamagha amuisima Pita ri Jon gua otogha mee Gotɨnɨ Utum niamɨusua, aniiŋ memɨusua Gotɨn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mauthughura aniiŋ Gotɨn phorugham mbɨkemigha, nona aghari ufhueghava men iphɨna athɨsima mee Gotɨnɨ Utum nii. ");
INSERT INTO spm_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mauthughura Saimon garima, Iesusɨm mbɨsevisi gumasi non aghari ufhueghava men iphɨna athɨsima mee Gotɨnɨ Utum nii. Mauthughura ana aŋgɨro ovɨsi nigha aniiŋga anɨŋga, kamaghɨm mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Aŋgo gamgaaŋn khav ivhɨra na raniiŋtima, khɨɨ nona afharimuu ufhegh thavɨn iphɨra thɨghtima, a Gotɨnɨ Utum niaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita kamagh aŋm mbeŋgeeghi, “Nɨɨna aŋgɨr ovɨsi nɨɨn phorughɨvɨra maghatiighemi. Got a bighan aghuuŋn mɨn anɨɨndir bigha thav aŋgɨr ovɨsir uvhuesi a? Bar phatɨ! Bighan khavɨusua nɨɨ nona aŋgɨro ovɨsi phorughɨvɨra mbuŋŋue phatɨsir arivan maŋŋaŋga. ");
INSERT INTO spm_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nɨɨn navana avhee Gotɨna arɨmasi rɨfhaaŋn inderasi phatɨ. Kamagha amuisima, nɨɨ Gotɨn iŋaaran avhen ikaami thughatɨs phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Khɨɨ nɨɨn garima, nɨɨn nav maghatɨghi, kamagha amuigha othevir maghatɨsi ivhɨra nɨɨ, ike. Kamagha amuisima nɨɨ nɨghɨnɨsigh ɨraghiva othevir maghatɨsi anda thaegh, Ikhɨvan phorughum mbɨkɨm. A ti nɨɨn navana avhen iti nɨghɨnɨsir maghatɨsi tharsi gɨna amaaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","An aŋm mbɨŋgeema, Saimon aŋna akam ikara, “Aŋgo namɨusua Ikhɨvan phorughum mbɨkɨmtima, aŋgo mbɨkemisi bisi tharsi namba othuivam thughathɨgham phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita ri Jon Ikhɨv aniiŋn akuruvasi bisir gunɨm mbɨŋgɨva, aŋna akamɨ ukuri. Gumughun aniiŋ nomthegha Jerusalemɨn gua, akamana aghuuŋ Samarian distrighɨnɨ uŋuimbar avhɨrara ana ukura zui. ");
INSERT INTO spm_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ikhɨvan ensel Filivɨm mbɨŋgeeghi, “Nɨɨ sautɨn utuavɨn maaŋɨ, a Jerusalema thaegha gueghira Gasanɨ uŋuun oto. Utuavɨn khav gumasi iti phatɨsira aŋanan iti.” ");
INSERT INTO spm_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Kamaghɨn amuisima, a maghɨra zui. A utuavɨna arɨghan Itiopianɨ unuaghɨnan gumaghan mavɨa oto. A gumaghan aphan, a Itiopianɨ unuaghɨnan ativasira amighan aŋgɨr ovɨsir garir gumagh. Amighan izɨɨ Kandasi. Gumaghan khav Jerusalemɨn gugha Gotɨni izɨɨ ufhuegha nomthegha zii. A karisɨa apheragha, Gotɨna ambuuŋn gumagh Aisaian mbɨgharan gari. ");
INSERT INTO spm_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mauthughura Gotɨnɨ Utum Filivɨm mbɨŋgeeghi, “Nɨɨ maŋɨva karisɨn munavɨn aghan ikhɨɨ.” ");
INSERT INTO spm_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mauthughura Filip akhɨghavtɨgha gua karisɨn aghan gugha Itiopianɨ unuaghɨnan gumagha orasima, a Aisaia, Gotɨna ambuuŋn gumagham mbɨgharan gari. Kamagha amuisima Filip aŋna azaaghi, “Nɨɨ gari bighan khav nɨɨ ana ikeeŋsi o phatɨ?” ");
INSERT INTO spm_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Itiopianɨ unuaghɨnan gumagh ana ikara, “Khɨɨ manmaghɨra ikaaŋ ti? Thav nan niaghɨtima, khɨɨ ikeeŋgemi. Nɨɨ zɨvanaŋ nan phorugh raphera.” ");
INSERT INTO spm_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Itiopianɨ unuaghɨnan gumagh Gotɨm mbɨgharan itir akaar kharsir gari, “A sivsivɨn mɨn mee aŋm mbɨsoghousuava, ana nigha gu. Mee sivsiviirɨ uŋusira arɨsia rɨphɨrousuava amuima anda inɨmɨre iti. Kamaghɨra gumaghan khav, mee aŋm mbɨsoghousuava amuima, a phura inɨmɨre ikha bigha thavɨm mbɨŋge phatɨ. Mee bar aŋn amevagha, inderaghavɨra an osɨmndɨsiva oragha anda rɨkɨrisi phatɨ. Kamagha amuisima, a boorir phatɨ, manmagh aŋn niaghɨ ti? Mee an ikɨrana aghuuŋ gɨvasima, a nomthegha unuaghɨnan iti phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mauthughura ɨnan gumagh Filivɨn azaaghi, “Nɨɨ na mbɨkɨm. Gotɨna ambuuŋn gumagh, a thɨɨŋn gunɨm mbɨŋgeeghi? A nombɨ mbɨŋgeeghi, o igharis tharsi vɨŋgeeghi?” ");
INSERT INTO spm_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filivɨ ufhuaragha Gotɨm mbɨgharana avhen itir akaa kharsi vɨnɨŋgari vɨŋgɨ gua, Iesusɨn akaman aghuuŋn gun aŋm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Mee utuavɨn gua, rɨmɨn mavɨ oto. Itopianɨ unuaghɨnan gumagh kamaghɨm mbɨŋgeeghi, “Nɨɨ gan, rɨmɨ khara. Khɨɨ thighira uruasa, bighan theghɨna thav nom nanɨ usuiraghti?” ");
INSERT INTO spm_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mauthughura ɨnan gumagh karisɨnɨ usuisi gumagham mbɨŋgema, a karisɨ amuisima a utu. Mauthughura Filiv ri ɨnan gumagh rɨmɨna avhen gueghirɨsi, Filiv ana urue. ");
INSERT INTO spm_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mee rɨmɨn ikeghava azenan zesima, Ikhɨvanɨ Utum uzuamɨra Filip nigha gu. Gumughun ɨnan gumagh nom Filivɨusua garava avheeŋi, a utuavɨn gua bari iphui. ");
INSERT INTO spm_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mauthughura Gotɨnɨ Utum Filiv nigha gua ana athɨsima a gara nɨghɨnɨsi, “Khɨɨ thighira Asdotɨnɨ uŋuun oto.” A gua, uŋuimba bar andar akamana aghuuŋ ukura gua Sisarianɨ uŋuuno oto. ");
INSERT INTO spm_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Kha uthughun Sol Iesusɨn suren gumasigha asɨghasɨghɨva, mee mbɨsoghtima mee arɨghiraousua, mbɨŋgɨŋgɨr gamgaegha amuavɨre iti. Kamagha amuisi, a Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨvɨousua gua kamagha aŋn azaaghi, “Nɨɨ Damaskusɨnɨ uŋuun itir gumasira aphanivɨusua mbɨgharia osɨri. Gumasi aphani kharsi Gotɨn phorugha mbɨŋgeer rɨphenir gari. Nɨɨ osira kamaghɨusue, ‘Gumagha thav o amigha thav, Iesusɨnɨ utuavɨn gɨn maŋɨtima, Sol aŋn ganighɨva, aŋnɨ usuiragh maŋŋɨ rɨvɨnan kɨrthɨghan iti gumaghan mɨn ana ikheghɨva, Jerusalemɨn ana amandaghami.’ ” ");
INSERT INTO spm_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mauthughura a Damaskusɨnɨ uŋuuna aghan zima ovheen aŋaran gamgaaŋ aŋgi isira. ");
INSERT INTO spm_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Maghɨra a iraa unuaghɨnaŋgi irɨgha orasi, ithɨɨŋ mav kamagh aŋm mbɨŋgeeghi, “Sol, Sol, nɨɨ thoghousua nar afharavasi?” ");
INSERT INTO spm_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ana aŋm mbɨkemisima Sol azaaghi, “Ikhɨv, nɨɨ thɨɨŋra?” Mauthughura a kamagh aŋm mbɨŋgeeghi, “Khɨɨ Iesus, nɨɨ nar afharavasi. ");
INSERT INTO spm_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nɨɨ rɨkavighɨva, uŋuun maaŋɨ. Gumughun gumagha thav nɨɨra amuaŋgami bisir gun nɨɨm mbɨkɨmaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Uthughun khavɨn gumasi Solɨn phorugha zui tharsi, mee phura gumaghan mbɨŋgɨŋgɨr kɨniva oraegha gumagha thavɨn ganis phatɨ. Kamagha amuisi mee mbɨŋgɨmɨŋgɨ phatɨgha phure iti. ");
INSERT INTO spm_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Maghɨra Sol nomthegha rɨkavhigha, non arɨmaghaniiŋ ukuigha, a bigha thavɨn ganis phatɨ. Aŋn phorugha arui gumasi ana agharaniiŋn usuiragha ana nigha mee Damaskusɨnɨ uŋuun zui. ");
INSERT INTO spm_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A Damaskusɨni itima aŋna arɨmaghaniiŋ uthughun phunini ko mbɨkethavɨn maghatɨghavɨre itima, ana aghaa thav ko rɨmɨ thav amesi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kha uthughun Damaskusɨnɨ uŋuuna avhen Iesusɨn suren gumaghan mav iti, aŋni izɨɨ Ananaias. Mauthughura Ananaias a irɨmɨn mɨn bighaaŋ garima Ikhɨv aŋn dɨɨva aŋm mbɨŋgeeghi, “Ananaias!” An aŋn dema ana ikara, “Ikhɨv, khɨɨ khari iti.” ");
INSERT INTO spm_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mauthughura Ikhɨv aŋm mbɨŋgɨ kamaghɨusue, “Gumaghan mavɨn izɨɨ Sol, a Tarsusɨn gumagh. A nan phorugha mbɨŋgɨ iti. Kamagha amuisi, nɨɨ rɨkavigh, utuavɨn khavɨn maaŋɨ. Aŋni izɨɨ mbɨnesirɨ utuavɨn zui. Nɨɨ Judasɨ rɨphenan maaŋɨ Solɨusua azaaŋ. ");
INSERT INTO spm_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sol irɨmɨn mɨn bighan garima, gumaghan izɨɨ Ananaias, a zaa afharir aŋni iphɨa athɨgha aŋna arɨmagha thughani ramutima, aniiŋ nom inderaghousua.” ");
INSERT INTO spm_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mauthughura Ananaias ana ikara, “Ikhɨv, khɨɨ orasima, gumasira avhɨrara gumaghan khavɨn gunɨm mbɨŋgeeghi, mee kamaghɨusue, a nɨɨn gumasi rako amisi Jerusalemɨna avheni iti tharsi iphasa meŋga amui. ");
INSERT INTO spm_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii, akamana aghavagharan aŋm mbɨnamɨnaaŋ athɨsi a ze. Gumasi rako amisi nɨɨn izɨɨn deer tharsi, a menɨ usuighava rɨvɨnan khɨrthɨgha rathɨghami.” ");
INSERT INTO spm_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","An aŋm mbɨŋgeema Ikhɨv kamagh Ananaiasɨm mbɨŋgeeghi, “Nɨɨ maaŋɨ! Gumaghan khav, mara khɨɨ mbɨsevisir iŋaaran gumagh. A nan izɨɨn gun igharisirɨ unuaghɨnan gumasi rako meŋga ativasi tharsi ko Israelir gumasivɨusua maŋaŋga. ");
INSERT INTO spm_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Gumughun a nani izɨɨn osɨmndɨsi rako mbɨzasi niaŋgamir tharsi, khɨɨ andar aŋn khɨvaghami.” ");
INSERT INTO spm_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mauthughura Ananaias rɨphenan gua ana avhen gu. A nona afharimuun Solɨni iphɨn athɨgha, kamaghɨusue, “Nana avheeŋphom, Sol, nɨɨ khagh zima Ikhɨv Iesusɨ utuavɨn nɨɨ mbato. Nɨɨ nomthegh ganti, Gotɨnɨ Utum nɨɨ izɨvaghaousua, kamagha amuisima a na amandasi khɨɨ ze.” ");
INSERT INTO spm_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Maghɨra bar uzuamɨra, osiran inaghɨnan mɨn garir bighɨn Solɨna arɨmaghaniiŋn ikeghava ukuighirɨ. Kamaghɨn amuisi a thighira nomthegha gari. A maghɨra rɨkavhisima mee Iesusɨni izɨɨn ana urue. ");
INSERT INTO spm_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mauthughura ana aghaer marsi amegha gɨn nomthegha non gamgaaŋ nii. Kamagha amuigha Sol Iesusɨn suren gumasir phorugha uthusi marsir Damaskusɨnɨ uŋuuni ikhee. ");
INSERT INTO spm_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sol Iesusɨn suren gumasir phorugha Damaskusɨnɨ uŋuuni ikha maghɨra Gotɨn phorugha mbɨŋgeer rɨphenir akamɨ ukura kamaghɨusue, “Iesus a Gotɨn Otar.” ");
INSERT INTO spm_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Solɨm mbɨŋgeema, mee aŋm mbɨŋgɨŋgɨv oraegha rɨŋgavan maghatɨgha amuighava norira azaaghi, “Khara ti gumaghan khavɨra, a Jerusalemɨni ikha Iesusɨn izɨɨn deer gumasi rako amisi, a menɨ usuigha mee rafharavasi? A ti mee nigh maaŋɨ rɨvɨnan kɨrthɨghan iti gumasir mɨn mee ikheghɨva Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikiir afharir rarɨghaousua, mamagh amuigha a khagh ze?” ");
INSERT INTO spm_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mauthughura Solɨna akam bar gamgaeŋga guavanambosi a inderaghavɨra mbɨŋgɨŋgɨ vɨnɨŋgaria bɨgha Iesus a Got nom ee niamɨusua mbɨsevisi gumagh ana akamɨ ukuri. Damaskusɨni iti Judarir akoghɨn gumasi rɨŋgavan maghatɨgha amuighava mbɨkɨman iŋgura. ");
INSERT INTO spm_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Uthusira avhɨrara guesima, Judarii Sol mbɨsueghti ana aremighaousuava utuavivɨusua urui. ");
INSERT INTO spm_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mee aŋm mbɨsoghousuava arue rako rɨmaŋgarir mɨghasɨgha aŋmɨusua uŋuun rɨvɨnan ithɨɨr akaar garima, mee aŋm mbɨkemisima Sol men nɨghɨnɨghan maghatɨghan khav ikaaŋi. ");
INSERT INTO spm_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mauthughura aŋn gɨna aruir gumasi, mee rɨmaaŋn aŋm mbɨkemisi ana akhɨraman ikhɨv aŋga apherasima, mee gamiiŋ nii rɨvɨnan thooŋn mavɨn ana thaesima a gueghira uŋuun rɨvɨnan akɨran irɨ. ");
INSERT INTO spm_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalemɨn zegha, Iesusɨn suren gumasi phorugh ikhaousua amuima mee nɨghɨnɨghana aghavaghar kamagh aŋni iti phatɨ, a Iesusɨn suren gumagh. Kamagha amuigha mee bar Solɨna avhighavighi. ");
INSERT INTO spm_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ara Barnabasa ana nigha aŋn gun Iesusɨm mbɨsevisi gumasi vɨkɨmamɨusua zui. A mem mbɨŋgeeghi, “Solɨ utuavɨn gua Ikhɨvan gani. Mauthughura Ikhɨv aŋm mbɨkemisima a Damaskusiiŋn thavɨna avhighaviisi phatɨgha, Iesusɨni izɨɨn akamɨ ukuri.” ");
INSERT INTO spm_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sol Jerusalemɨn inderaghavɨra men phorugha aruava men phorugha ikava avhighavisi phatɨgha Iesusɨni izɨɨn akamɨ ukura guavɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A Judari Grighiiŋna akama mbɨŋger gumasir phorugha mee nori vɨŋgɨ nori vatosi, kamagha amuisima mee aŋm mbɨsueghti ana aremighaousuava amui. ");
INSERT INTO spm_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mauthughura Kraisɨn phorusi tharsi kamagh oraegha ikeeŋga, ana nigha Sisarianɨ uŋuun gueghirɨgha ana nigha Tarsusɨnɨ uŋuun ana amanda. ");
INSERT INTO spm_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Judian distrigh ko Galilin distrigh ko Samarian distrighɨn avhen iti Kraisɨnɨ andarsi, uthughun khavɨn navana amɨɨŋndɨghan ikha inderaghavɨra itima, Gotɨnɨ Utum gamgaaŋ meŋga anɨndi. Kamagha amuisima Kraisɨna andarsi rɨmbomboni guavanandi. Gumasi rako amisi Gotɨn avhighavighava aŋna apheeŋn iti. ");
INSERT INTO spm_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Uthughun khavɨn Pita uŋuimba bar andagha aruigha, Lidanɨ uŋuun itir Gotɨn gumasi rako amisir ganamɨusua zui. ");
INSERT INTO spm_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A gua uŋuun khavɨn gumaghan mavɨ oto, aŋni izɨɨ Ainias. Aŋnɨ usue rako afhari amɨrasima, a 8 pɨlan ombaarir akhoghɨre ikhee. ");
INSERT INTO spm_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Uthughun khavɨn Pita kamagh aŋm mbɨŋgeeghi, “Ainias, Krais Iesus nɨɨŋga amuisi, nɨɨ indera. Nɨɨ rɨkavighɨva nona akogha rɨkɨr.” Maghɨra Ainiasɨ uzuamɨra rɨkavi. ");
INSERT INTO spm_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","A rɨkavima Lidanɨ uŋuu ko Saronɨn mbɨnaaŋn iti gumasi rako amisi, mee aŋn ganigha non nɨghɨnɨsigh ɨragha nɨghɨnɨghana aghavaghar Ikhɨvan iti. ");
INSERT INTO spm_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopanɨ uŋuun suren amigha mav iti, aŋni izɨɨ Tabita. Grighiiŋna akaman aŋni izɨɨ mav Dorkas. A mɨghasɨgha othevir aghuuira amuava bisi phatɨsi gumasi rako amisi mena akuruvasi. ");
INSERT INTO spm_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Uthughun mavɨn arɨmarɨm ana nisima ana aremi. Mee aŋn khumɨ uruegha ana nigha gua rɨphenan iphɨn iti aŋanan ana athɨ. ");
INSERT INTO spm_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidanɨ uŋuun Jopanɨ uŋuum mbɨroghɨre iti. Kamagha amuisima suren gumasi kamagh oraghi, Pita Lidan itima, mee gumaghan phunini amandasima aniiŋ aŋm mbɨkɨmamɨusua zui. Aniiŋ gua aŋm mbɨŋgɨ kamaghɨusue, “Ee nori, nɨɨ thighira uzuamɨra aŋgan gɨn zɨɨ!” ");
INSERT INTO spm_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aniiŋ aŋm mbɨkemisima Pita aniiŋ phorugha gua otogha maghɨra rɨphenani iphɨni itira aŋanan guavanambo. Uthughun khavɨn amisiro ozɨɨri aŋna ataaŋnɨ utuivighav ikava, aziava non shaari rako akɨran sharir saarira aghuigha Dorkas men phorugha aŋgamɨre ikha memɨusuava amuisi bisir Pitan khevi. ");
INSERT INTO spm_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mauthughura Pita gumasi rako amisi bar mee amaeŋsi mee akɨran gue. Mauthughura a noni itɨvɨnia rɨphɨrigha Gotɨn phorugham mbɨŋgeeghi. A ɨraghava aremisir amighan garava kamaghɨusue, “Tabita, nɨɨ rɨkavhi.” Maghɨra a nona arɨmaghaniiŋ ukuigha Pitan garavɨra, rɨkhavighava aphera. ");
INSERT INTO spm_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Maghɨra Pita aŋna akuruvagha ana ufhuesi a rɨkavhigha utu. Uthughun khavɨn amuuir ozɨrir rako Gotɨn gumasi rako amisi igharisi tharsi dɨɨgha men khɨvasi mee aŋn gari, a rɨkavhighava aŋamɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kamagha amuisima Jopan iti gumasi rako amisi niaghaghan khavɨ oraegha men avhɨrara nɨghɨnɨghana aghavaghar Ikhɨvan iti. ");
INSERT INTO spm_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita uthusir marsir Jopan itir gumaghan phorugha ikhe. Kha gumagh asɨsir niir bisigha amui. Aŋni izɨɨ Saimon. ");
INSERT INTO spm_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gumaghan mav Sisarianɨ uŋuun iti, aŋni izɨɨ Kornilius. A 100 pɨlanɨm mbɨzorsir gumasir garir gumaghan mav. A ivhɨra Italinɨ unuaghɨnan mbɨzorusir gumasi gari. ");
INSERT INTO spm_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilius a Got vhusvhuiisir othevigha amuir gumagh. A nona andarsir phorugha mee Gotɨn apheeŋn iti. A ivhɨra Judarir akoghɨn gumasi rako amisi bisi phatɨsi tharsi men akuruvagha, mɨghasɨgha Gotɨn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Uthughun mavɨn 3 okloghɨnɨ uŋguartughun Kornilius bar inderaghavɨra garima Gotɨn ensel irɨmɨn mɨn zaa kamagh aŋm mbɨŋgeeghi, “Kornilius!” ");
INSERT INTO spm_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mauthughura Korniliusa avhighaviighava rɨkɨrava aŋn gara, kamagh aŋna azaaghi, “Ikhɨv, theghan bighɨn?” An aŋna azarasima, ensel aŋna azaaŋsɨgh ikara, “Got nɨɨm mbɨŋgɨmɨŋgɨv oraghi, nɨɨ gumasi rako amisi bisi phatɨsi tharsira akuruvasir iŋaarir garava andar vhusvhusighava andaghɨ nɨghɨnɨsi. ");
INSERT INTO spm_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nɨɨ thighira gumasi tharsi Jopan mee amandaghtima, mee maaŋɨ kha gumagh aŋni izɨɨ Saimon, mee ivhɨra Pitan aŋga arɨsi, aŋm mbatoghɨva ana nigh zɨɨ. ");
INSERT INTO spm_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A igharisi Saimonɨn phorugha iti, ana asɨsir niir bisigha amuir gumagh. Aŋ rɨphen oŋaram mbɨkeeŋn iti.” ");
INSERT INTO spm_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ensel Korniliusɨm mbɨkemigha ana athaegha gusima, a non iŋaaran gumaghaniiŋ ko mbɨzorughan gumagh, a men dɨɨsima mee aŋmɨusua zii. Aŋm mbɨzorughan gumaghan mav ivhɨra Gotɨn vhusvhusigha Korniliusɨn phorugha iti. ");
INSERT INTO spm_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ana othuivisi bisir kharsi gun mem mbɨkemigha, mee amandasima mee Jopan gue. ");
INSERT INTO spm_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Korniliusa amandasi gumasi gua utuavɨna arɨghan akui. Amɨrɨtusima mee gua Jopanɨ uŋuuna aghano othuivima aro rɨphɨɨŋ nii. Uthughun khavɨra Pita gua rɨphenan isɨɨŋn guavanambogha Gotɨn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Uthughun khavɨn Pita mbɨtii aŋn azima, ana aghaa thava ramamɨusua, kamagha amuisima mee aghaegha amuavɨre itima, a irɨmɨn mɨn bighan mavɨn gari. ");
INSERT INTO spm_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A iphɨn garima ovhee ukuisima, bighan mav mbɨsasini ikhɨvan mɨn gari. Bighan khav, mee aŋ 4 pɨla mbɨŋɨriirɨ usuirasima, a unuaghɨnan zeghiri. ");
INSERT INTO spm_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Aŋna avhen, asɨsirɨ usue rako afhari ikhava arui tharsi, rako unuaghɨnana avaragha aruir asɨsi rakoma iphɨn phavagha arui ukuarasi iti. ");
INSERT INTO spm_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mauthughura ithɨɨŋ mav kamagh aŋm mbɨŋgeeghi, “Pita, nɨɨ rɨkavigh tharsi vɨsoeghɨva anda ramɨ.” ");
INSERT INTO spm_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","An aŋm mbɨkemisima Pita kamagh ana ikara, “Ikhɨv bar phatɨghami! Khɨɨ fhomɨra Gotɨna arɨmasi rɨfhaaŋnɨ mbɨzesi bigha thava amesi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","An aŋm mbɨkemisima ithɨɨŋ nomthegha aŋm mbɨŋgeeghi, “Got amuisi bisi anda indera. Nɨɨ nomthegh mbɨzesi bisi andara arɨgha thaghɨri.” ");
INSERT INTO spm_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A ma akamara ufhuaragha aŋm mbɨkemigha nomthegha uthughum buaaŋniiŋn nom aŋm mbɨŋgeeghi. Uthughun khavɨn mbɨsasini ikhɨvan khav uzuamɨra nomthegha ovheen guavanambo. ");
INSERT INTO spm_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita irɨmɨn mɨn ganis bighan khavɨm mbɨnɨɨŋgi nɨghɨnɨghavɨre itima, Korniliusa amandasi gumasi guava othuivi. Mee Saimonɨ rɨphenamɨusuava azaaghi, aŋ rɨphen managh iti. Mee thighira zaava aŋn rɨphenan itɨman akamaniiŋn othuivi. ");
INSERT INTO spm_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mee dɨɨva azaaghi, “Saimon, aŋni izɨɨn mav Pita, a khagh iti o phatɨ?” ");
INSERT INTO spm_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita irɨmɨn mɨn ganisi bighe nɨghɨnɨghavɨre itima, Gotɨnɨ Utum aŋm mbɨŋgeeghi, “Saimon, gumaghan phunini ko mbɨkethav nɨɨmɨusua uruiagha arui. ");
INSERT INTO spm_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Khɨɨ mee amandasima mee nɨɨmɨusua zii. Kamagha amuisima, nɨɨ men phorugh maŋŋamɨusua nɨghɨnɨsira avhɨrara amua thaghɨri. Nɨɨ rɨkavigh meghirɨ.” ");
INSERT INTO spm_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Mauthughura Pita gueghirɨgha mem mbɨŋgeeghi, “Kɨra khara, gee namɨusua urui. Gee thoghousua zii?” ");
INSERT INTO spm_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A mem mbɨkemisima gumasi aŋna akam ikara, “Kornilius 100 pɨlan mbɨzorsir gumasir garir gumagh nɨɨmɨusua ee amandasima ee ze. A Gotɨna arɨmasi rɨfhaaŋn inderagha ana apheeŋn itir gumagh. Judarir akoghɨn gumasi rako amisi bar aŋn vhusvhusigha aŋni izɨɨ ufhii. Gotɨn enselɨn mav aŋm mbɨŋgɨ kamaghɨusue, ‘Nɨɨ Pitaousua akama amandaghtima a nɨɨn rɨphenan zɨɨ mbɨŋgɨŋgɨ tharsi ramutima nɨɨ andava oraa.’ ” ");
INSERT INTO spm_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mauthughura Pita mem mbɨŋgeema, mee rɨphenana avhen gue. Mee akuigha amɨrɨtusi rɨmaaŋra Kraisɨn phorusi gumasi Jopanɨ uŋuun iti tharsi mee ivhɨra Sisarianɨ uŋuun zui. ");
INSERT INTO spm_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mee gua utuavɨna arɨghan akuigha nomthegha rɨkavhigha gua Sisarianɨ uŋuun oto. Uthughun khavɨn Kornilius memɨusua gara iti. A no rɨkuruku rako nona andarsir dɨɨgha, mee akuvagha men phorugha iti. ");
INSERT INTO spm_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita rɨphenana avhen zuima, Korniliusa aŋna aghegha, aŋn khoman noni itɨvɨnia rɨphɨrighava irɨgha aŋni izɨɨ ufhii. ");
INSERT INTO spm_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mauthughura Pita aŋnɨ usuiraghav ana ufhegha aŋm mbɨŋgeeghi, “Nɨɨ rɨkavighɨ uthughɨri! Khɨɨ phura gumaghan khɨn maghɨ.” ");
INSERT INTO spm_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita aŋm mbɨŋgɨvɨra rɨphenana avhen gua garima, gumasi rako amisira avhɨrara nori akuvaghav iti. ");
INSERT INTO spm_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mauthughura a mem mbɨŋgeeghi, “Gee bar ikaaŋi, ee Judarii, en othɨv maghɨ. Ee igharisirɨ unuaghɨnan gumasir aghan maŋŋɨgham phatɨghɨva ivhɨra men phorugh ikeghem thughatɨs phatɨ. Got kamagh nam mbɨŋgɨ kamaghɨusue, khɨɨ Gotɨna arɨmasi rɨfhaaŋn gumagha thavɨ mbɨkɨmɨva mbɨzesir gumaghan aŋra atɨghɨva aŋn phorugh ikeghemi thughatɨsi bar phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Uthughun khavɨn gee namɨusua akama amandasima khɨɨ iphɨrphɨrsi phatɨgha, khagh ze. Khɨɨ gen azaaghi, gee thoghousua namɨusua akam amandasima?” ");
INSERT INTO spm_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Aŋm mbɨŋgeema Korniliusa aŋna akam ikara, “Ma amɨnboghɨn 3 okloghɨn uŋguartughun khɨɨ nor rɨphenana avhen ikha Gotɨn phorugham mbɨŋgeeghi. Uthughun khavɨn gumaghan mav shaaranɨ ughuran mava saragha uzuamɨra nam mbɨnɨmanɨ utughavi iti. ");
INSERT INTO spm_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","A kamaghɨusue, ‘Kornilius, Got nɨɨn mbɨŋgɨmɨŋgɨv oraghi, nɨɨ gumasi rako amisi bisi phatɨsi tharsi akuruvasi iŋaarir gara ana andar vhusvhusigha andaghɨ nɨghɨnɨsi. ");
INSERT INTO spm_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kamagh amuisima Saimon, aŋni izɨɨn mav Pita, aŋmɨusua gumagha thav amandaghtima, a Jopanɨn maŋɨva ana nigh zɨɨ. A Saimon asɨsir niir bisigh amuir gumagha rɨphenaŋga akuima, an aŋn gara iti. Rɨphenan khav oŋaram mbɨkeeŋn iti.’ ");
INSERT INTO spm_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kamaghɨn amuisima khɨɨ nɨɨmɨusua uzuamɨra akam amanda. Mamagha amuisima nɨɨ inderagha zii. Ee thighira bar zaa Gotɨna arɨmasi rɨfhaaŋn iti. Got nɨɨ mbɨkemisir akaa, nɨɨ anda vɨkɨmtima ee bar andava oraghami.” ");
INSERT INTO spm_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita Korneliusɨn rɨphenana avhen iti tharsi vɨŋgeeghi, “Bar guisimbaaŋra, khɨɨ thighira ikaaŋi. Got uvhuaghuvhagha gumasi vhusvhusigha mera gari phatɨ, a bar gumasir vhusvhusi. ");
INSERT INTO spm_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Uŋuimba bar andar iti gumasi rako amisi aŋna apheeŋn ikha othevira aghuuira amui tharsi, a men vhusvhusi. ");
INSERT INTO spm_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Khara Got Israelir gumasi rako amisivɨusua amandasir akam. A kamaghɨm mbɨŋgeeghi, Krais Iesus a bar en Ikhɨv. A eŋga amuima, ee Gotɨn phorugha navana amɨɨŋndɨghan iti. ");
INSERT INTO spm_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gee nori ikaaŋi, bisir mana andarsi Israelɨnɨ unuaghɨnani iti uŋuimba bar andar othuivi. Bisir kharsi Galilin distrighɨnɨ ufhuaraghavɨra rɨkavi. Jon gumasi uruasa akamɨ ukurava aruigha gɨvasima, bisi gɨn othuivi. ");
INSERT INTO spm_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gee ikaaŋi, Got Nasaretiiŋn gumagh Iesus, nonɨ Utum ko gamgaaŋn aŋga anɨɨŋi. Got aŋn phorugh itima, kamagha amuisima a uŋuimbagha arua gumasi rako amisir akuruvasi. Ara Satanɨn aphasasi gumasi rako amisi, Iesus meŋga amuima mee nomthegha indera. ");
INSERT INTO spm_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ee nori non arɨmasi aŋn garima, a Judarirɨ unuaghɨnan iti uŋuimbar rako Jerusalemɨnɨ uŋuun bisira avhɨrara amui. Mee aŋm mbɨsuegha khani ighuuvan ana gurasima an aremi. ");
INSERT INTO spm_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Uthughun phunini gɨvasima mbɨkethavɨn Got aŋga amuima a nomthegha rɨkavhi. Gumughun Got ana nigha gumasi rako amisir khɨva. ");
INSERT INTO spm_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A Judarii bar mee mbativisi phatɨ. En gumasi Gotɨ mbɨsevesi tharsi, era aŋn gani. Ana aremigha nomthegha rɨkavisirɨ uthughun gɨn, a en phorugha ikava aghae rako rɨmɨ ame. ");
INSERT INTO spm_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iesus nona akaman gun gumasi rako amisi vɨkɨmamɨusua eem mbɨkemi. A kamaghɨusue, ee kamagh mem mbɨkɨm mbɨkɨmaŋga, Got gumaghan khav Iesus ana mbɨsevisima, anara ovheeŋga guesi tharsi rako aŋgamɨre iti tharsi osɨmndɨsiva oraghava anda rɨkɨrami. ");
INSERT INTO spm_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Gotɨna ambuuŋn gumasi, mee bar guisimbaaŋra Iesusɨn akaman khav ukuri. Mee kamaghɨusue, gumagha thav nɨghɨnɨghana aghavaghar Iesusɨni izɨɨn ikhɨti, Got Iesusɨni izɨɨn ana othevir maghatɨsi gɨna amaaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita akamɨ ukuravɨra itima, gumasi rako amisi aŋm mbaraghavɨre itima, Gotɨnɨ Utum bar memɨusua zeghirɨ. ");
INSERT INTO spm_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Judarir akoghɨn gumasi nɨghɨnɨghana aghavaghar Iesusɨn iti tharsi, Pitan phorugha ze. Mee orasima mee uŋuimbar igharis tharsir akaa aghua Gotɨni izɨɨ ufhii. Kamagha amuisi mee rɨŋgavan maghatɨgha amuigha kamaghɨm mbɨŋgɨ kamaghɨusue, “Muna gan! Got nonɨ Utum bighana aghuuŋn mɨn igharisirɨ unuaghɨnan gumasi ivhɨra meŋga anɨɨŋi.” Mem mbɨkemisima Pita kamaghɨm mbɨŋgɨ kamaghɨusue, ");
INSERT INTO spm_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Gumasi rako amisir kharsi, mee en mɨn Gotɨnɨ Utum nigha gɨva. Kamagha amuisima thɨɨŋra, ee rɨmɨn mee ururan en thɨv ti?” ");
INSERT INTO spm_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mauthughura Pita kamagh gumasir kharsi vɨŋgeeghi, “Gee Krais Iesusɨni izɨɨnɨ uruami.” Mee uruegha gɨvagha, norir phorughɨ uthusi tharsir ikhaaousuava Pita mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iesusɨm mbɨsevisi gumasir rako Judianɨ uŋuimbara avheni iti Kraisɨn phorus tharsi mee kamagh oraghi, igharisirɨ unuaghɨnan gumasi ivhɨra Gotɨna akam nii. ");
INSERT INTO spm_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Uthughun kavɨn Pita nomthegha Jerusalemɨn guavanambosima, Judarira akhoghɨn gumasi nɨghɨnɨghana aghavaghar Iesusɨn iti tharsi, mee momooŋn niro ofhɨsir rɨghorir otɨvaghava, Pita athara kamaghɨusue, “Nɨɨ gua non momooŋn niro ofhɨsia rɨghorisi phatɨsi gumasir rɨphenir gugha mem phorugha aphi.” ");
INSERT INTO spm_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mee aŋna azarasima Pita maghɨra aŋm mbatosi bisi bar inderaghavɨra andar gun mem mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Khɨɨ Jopanɨ uŋuuni ikhɨvan ikha Gotɨn phorugham mbɨŋgeeghi. Uthughun khavɨn khɨɨ irɨmɨn mɨn bighan mavɨn garima, mbɨsasini ikhɨvan mɨn, mee aŋ 4 pɨla mbɨŋɨriirɨ usuirasima, ana ovhee thaegha zeghira khɨɨ itira aŋanan asara. ");
INSERT INTO spm_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mauthughura khɨɨ aŋna avhen garima, asɨsirɨ usue rako afhari ikha unuaghɨnana arui tharsi, ko asɨsir athɨɨr marsi, rako unuaghɨnana avaragha aruir asɨsir marsi, rakoma iphɨn phavagha arui ukuarasi iti. ");
INSERT INTO spm_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Khɨɨ orasi, itɨɨŋn mav nam mbɨŋgeeghi, ‘Pita, nɨɨ rɨkavigh tharsi vɨsoeghɨva anda ramɨ.’ ");
INSERT INTO spm_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mauthughura khɨɨ ana ikara, ‘Ikhɨv bar phatɨghami! Nan akamndooŋni Gotɨna arɨmasi rɨfhaaŋnɨ mbɨzesi bighan thav amesi bar phatɨ.’ ");
INSERT INTO spm_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mauthughura ithɨɨŋ mav nomthegha Gotɨnɨ uŋuun mbɨŋgeeghi, ‘Got amuisi bisi anda indera. Nɨɨ nomthegh mbɨzesi bisi andara arɨgha thaghɨri.’ ");
INSERT INTO spm_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A ma akamara ufhuaragha aŋm mbɨkemigha nomthegha uthughum buaaŋniiŋn nom aŋm mbɨŋgeeghi. Uthughun khavɨn mbɨsasini ikhɨvan khavɨ uzuamɨra nomthegha ovheen guavanambo. ");
INSERT INTO spm_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Uthughun khavɨra gumaghan phunini ko mbɨkethav, mee namɨusua Sisarianɨ uŋuun mee amandasima mee zaa khɨɨ iti rɨphena oto. ");
INSERT INTO spm_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mauthughura Gotɨnɨ Utum na mbɨŋgɨ kamaghɨusue, ‘Nɨɨ men phorugh maŋŋamɨusua nɨghɨnɨsira avhɨrira amua thaghɨri.’ Uthughun khavɨn 6 pɨlan Kraisɨn phorus gumasi mee ivhɨra nan phorugha zui. Ee gua namɨusuava akama amandasi gumaghan rɨphenana avhen gue. ");
INSERT INTO spm_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mauthughura Kornilius eem mbɨŋgɨ kamaghɨusue, ‘Enselɨn mav nan rɨphenana avhen nambatogha kamaghɨusue, “Nɨɨ gumasi tharsi amandaghti, mee Jopanɨ uŋuun maaŋɨva, Saimon, aŋni izɨɨn mav Pita, aŋm mbatoghɨva ana nigh zɨɨ. ");
INSERT INTO spm_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aŋm mbɨze tharsir nɨɨ ranɨɨŋga, ma akamara Got nɨɨna akuruvaghtima nɨɨ rɨphenan iti gumasi rako amisi ivhɨra mbɨghɨvɨghɨghi.” ’ ");
INSERT INTO spm_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Khɨɨ maghɨra mbɨŋgema Gotɨnɨ Utum men iphɨn zeghiri, barɨ ufhuaraghavɨra a een iphɨn zeghirɨsi moghɨra. ");
INSERT INTO spm_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Maghɨra khɨɨ Ikhɨvɨ mbɨkemisi mbɨŋgɨŋgɨmaŋgi nɨndɨɨ, ‘Jon gumasi rako amisi rɨmɨn mee urue, khɨɨ gɨn Gotɨnɨ Utuman gamgaaŋn gee uruami.’ ");
INSERT INTO spm_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ee ikaaŋi, ee ufhuaragha nɨghɨnɨghana aghavagharan Ikhɨv Krais Iesusɨn itima, Got nonɨ Utum bighana aghuuŋn mɨn eŋga anɨɨŋi. Kamaghɨra thighira Got igharisirɨ unuaghɨnan gumasi ivhɨra nonɨ Utum, bighana aghuuŋ mɨn meŋga anɨɨŋi. Kamagha amuisima khɨɨ thɨɨŋra, khɨɨ Gotɨn iŋaaran thɨvaghti?” ");
INSERT INTO spm_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mauthughura nɨghɨnɨghana aghavaghar Iesusɨn iti gumasi kamagh oraegha, nomthegha andaran nɨghɨnɨsi phatɨgha Gotɨn izɨɨ ufha, kamaghɨusue, “A indera, Got ivhɨra igharisirɨ unuaghɨnan gumasi rako amisi vɨnamɨnaaŋ ratɨghtima mee ivhɨra nɨghɨnɨsigh ɨraghɨva mɨghasɨgha itir ikɨrɨran aghuuŋ niaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mee Stivenɨm mbɨsuesi aŋna aremisirɨ uthughun, mee ivhɨra nɨghɨnɨghana aghavaghar Iesusɨn iti tharsi othevir maghatɨsir meŋga amuisima, mee ivhɨra atamatam ara gua Fonisian distrigh ko Saiprusɨn mɨghsɨm ko Antioghɨnɨ uŋuun gua Iesusɨna akaman Judarir akoghɨn gumasi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mauthughura mena marsi ivhɨra Saiprusɨn mɨghsɨm ko Sairininɨ uŋuuni ikhegha zegha, Antioghɨn guegha Ikhɨv Iesusɨn akaman aghuuŋn gun Grighiiŋna akamaŋga aghui gumasi rako amisi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mem mbɨkemisima Ikhɨvan gamgaaŋ men phorugha iti. Mauthughura gumasi rako amisir avhɨrara nɨghɨnɨghana aghavaghar Ikhɨvan ikava non nɨghɨnɨsigh ɨragha Ikhɨvousua ze. ");
INSERT INTO spm_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Uthughun khavɨn Jerusalemɨni iti Kraisɨna andarsi bighan khavɨn niaghagha oraegha, mee Barnabasa amandasima a Antioghɨn gu. ");
INSERT INTO spm_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mauthughura an otogha garima, Got menɨ ukuarukuvigha, men akuruvaghava othevir aghuuira meŋga amuima Barnabas bari inighinisi. Mee non navira avherira avhen guisimbaaŋra Ikhɨvan phorugh ikaamirɨ mbɨŋgɨmɨŋgɨr mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","A bar gumaghan aghuuŋ, Gotɨnɨ Utum aŋgi izɨvasima Gotɨn nɨghɨnɨghana aghavaghar aŋni iti. Mauthughura gumasi rako amisir avhɨrara bar Ikhɨvousua ze. ");
INSERT INTO spm_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Uthughun khavɨn Barnabas Solɨusua uruiisua Tarsusɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","An aŋn ganigha, ana nigha Antioghɨn ze. Ombaranɨ uvhuavɨrana avhen Barnabas ri Sol noni nigha Kraisɨna andarsi phorugha noria akuvaghav iti. Aniiŋ bar gumasi rako amisira avhɨrara men surea amui. Uthughun khavɨn Antioghɨn gumasi rako amisi ufhuaraghavɨra izɨɨn khavɨn meŋga athɨ, Kraisɨn gɨn zui tharsi. ");
INSERT INTO spm_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Uthughun khavɨn, Gotɨna ambuuŋn gumasir marsi Jerusalemɨni ikhegha Antioghɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mena mav, aŋni izɨɨ Agabus, a rɨkavhigha utugha Gotɨnɨ Utuman gamgaaŋn kamaghɨusue, Romiiŋ garirɨ unuasira asɨsive bara aghae othevighemi. Kha bighaaŋ Sisar Klodius ativasir gumaghan itirɨ uthughun oto. ");
INSERT INTO spm_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Uthughun khavɨn suren gumasi akamam mbɨsuegha mee uvhuaghuvaghava nona ambirambin mɨn aŋgɨro ovɨsi anɨɨŋgava, Judian distrighɨn iti Kraisɨn phorus tharsira akuruvaghaousua anda amaaŋmɨusua. ");
INSERT INTO spm_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mee kamagh amuigha mee nona aŋgɨro ovɨsi nigha, Barnabas ri Solɨa aniiŋsi, aniiŋ anda nigha gua Kraisɨna andarsir gumasira aphanigha anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Uthughun khavɨn ativasir gumagh Herot Kraisɨna andarsir, marsirɨ usuigha meŋga asɨghasɨghaousua. ");
INSERT INTO spm_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Aŋm mbɨŋgeema, mee Jonɨna afhoghumaghan mav Jemsɨ mbɨzorsir akosɨna aŋm mbɨsoesima, aŋna aremi. ");
INSERT INTO spm_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Uthughun khavɨn Herot garima, ana amuisir othɨvhan khav, Judarii aŋn vhusvhusi, kamagha amuisima, a ivhɨra Pita nigha rɨvɨnan khɨrthɨgha athɨ. Herot iis phatɨsirɨ uvhuisirɨ uthuur ishamanɨ uthughun bighan khavɨ amui. ");
INSERT INTO spm_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A Pitanɨ usuiraghava ana nigha rɨvɨnan khɨrthɨgha athɨ. Ana nigha mbɨzorusir gumasir 4 pɨla ikhɨsir phosir afharɨ athɨ. Mee uthusi uvhuaghuvhuagha aŋn gari. 4 pɨlan gumasir phosir kharsi, mee anda uvhuaghuvhuagha 4 pɨla gumasi nisima mee aŋn gari. Herot, Israeli Got nomthegha mee nisirɨ uthughun ishaman ikhɨvan khav gɨvaghtima, a Pita nigh gumasi rako amisira avhɨrira arɨmasi rɨfhaaŋn osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan rarɨghaousua. ");
INSERT INTO spm_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita rɨvɨnan khɨrthɨgha rɨphenana avhen itima Kraisɨna andarsi aŋmɨusua phuvɨra Gotɨn phorugha mbɨŋgɨvɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Uthughun khavɨn Herot Pita nighɨva osɨmndɨsiva oraghava anda rɨkɨrir rɨphenamɨusua maŋŋamɨusua uthughun mavɨ athɨ. Rɨmaaŋn khavɨn, amɨn thighar itima, mee ukuaghavan phuninin ana ikhesima am mbɨzorughan gumaghan phuniiŋnina arɨghana akui. Mauthughura igharisi mbɨzorsir gumasir marsi rɨvɨnan khɨrthɨgha rɨphenan aŋmɨusua gara itɨmana akamaniiŋn iti. ");
INSERT INTO spm_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Uzuamɨra Ikhɨvan enselo otosima, aŋn aŋaar rɨvɨnan khɨrthɨgha rɨphenana avhen isɨra. Ensel Pitani ivherɨm mbɨsuegha aŋga aghuragha kamaghɨm mbɨŋgeeghi, “Nɨɨ uzuamɨra rɨkavi!” Maghɨra aŋna agharaniiŋ ikesi ukuakuaghavaniiŋ fhɨrighirɨgha unuaghɨnaŋgi irɨ. ");
INSERT INTO spm_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mauthughura ensel aŋm mbɨŋgeeghi, “Shaara sharaghɨva aŋgarir shaaria shara.” An aŋm mbɨkemisima Pita kamagha amuigha gɨvasima ensel aŋm mbɨŋgeeghi, “Nɨɨ non shaaranɨ uruara thava sharagh nan gɨn zɨɨ.” ");
INSERT INTO spm_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Mauthughura Pita rɨvɨnan khɨrthɨgha rɨphena thaegha, enselɨn gɨna akɨran zui. Aŋn nɨghɨnɨgh kamaghɨusue, “Khɨɨ irɨmɨn mɨn bisi gari.” A kamagh ikeeŋsi phatɨ. Ensel guisimbaaŋra bisir kharsi amuisi o phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Aniiŋ gua, rɨvɨnan khɨrthɨgha rɨphenan garir mbɨzorsi gumasir marsighi indɨragha nom marsighi indɨragha gua rɨvɨnan kɨrthɨghan zuir ainɨn ithɨmana akamaniiŋno oto. Kha itɨm a uŋuuni ikhɨvan zui thav. Aniiŋ aŋn otosi, ithɨm nombɨra ukuighirɨsima, aniiŋ akɨran gua utuavɨn mavɨn zui. Aniiŋ mange sɨvagha gua, enselɨ uzuamɨra Pita thaegha gu. ");
INSERT INTO spm_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mauthughura Pitan nɨghɨnɨgh nom zima, a kamaghɨm mbɨŋgeeghi, “Khɨɨ thighira guisimbaaŋra ikaaŋi, Ikhɨv non ensel amandasima a ze. A Herotɨna afharir nomthegha nan nii, Judarii bisir maghatɨsi nara amuamɨusua, mee andar nara amuighem phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita bisir kharsi ikeeŋgava, Jonɨn inaghamuuŋ Maria rɨphenan gu. Jonɨn izɨɨn mav Mak. Uthughun khavɨn gumasi rako amisir avhɨrara nori akuvagha rɨphenan khavɨn ikava Gotɨn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mem mbɨŋgeema, Pita akɨran ikava rɨvɨnan itɨman akamaniiŋn akɨrani iti thavɨ afhughavhusima, iŋaaran amighan izɨɨ Roda, aŋmɨusua itɨma akharaousua zii. ");
INSERT INTO spm_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","A Pitan ithɨɨŋ mbaraegha, bar iphuigha, itɨma akharis phatɨgha nomthegha akhɨghavtɨgha avhen gugha, kamagh gumasi rako amisi vɨŋgɨ kamaghɨusue, “Pita muna, a zaa itɨman akamaniiŋn iti!” ");
INSERT INTO spm_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mee kamagh aŋm mbɨŋgeeghi, “Nɨɨ oŋanighama ti.” Mauthughura a bar aghavagharigha kamaghɨm mbɨŋgeeghi, “Phatɨ. Guisimbaaŋra a iti.” Mee am mbɨŋgɨ kamaghɨusue, “Nɨɨti aŋn gari enselɨn ithɨɨŋ mbaraegha mati.” ");
INSERT INTO spm_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Uthughun khavɨn Pita itɨmaŋga afhughavhusima, mee zaava itɨma akharigha aŋn garavɨra, rɨŋgavan maghatɨgha amui. ");
INSERT INTO spm_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mauthughura Pita nona afharaniiŋn mee rɨkhagharɨsima, mee nɨmɨre iti. Mauthughura aŋn Ikhɨv Judarii rɨphenan kɨrtɨghana avhen ana nigha akɨra athɨsir othevir gun men niazi. A kamaghɨm mbɨŋgeeghi, “Gee bisir kharsir gun Jems nona afhoghumasir phorugha ivhɨra mem mbɨkɨmɨri.” Gumughun Pita mee thaegha igharisira aŋanan gu. ");
INSERT INTO spm_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Amɨn itirasima, mbɨzorsir gumasi Pitaousua garava avheeŋi. Mee bar rɨŋgavan maghatɨgha amuigha norira, norira azaaŋsɨgha kamaghɨusue, “Pita manavɨn gu?” ");
INSERT INTO spm_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pita iti phatɨsima, Herot a gumasi vɨkemisima mee Pitaousua uruiisua gue. Mee thange aŋn ganisi bar phatɨ. Kamagha amuisima aŋm mbɨzorsir gumasi Pitan garav ikesi tharsi, Herot mee nigha osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan athɨgha kamaghɨusue, “Mee aremighemi.” Herot gɨn Judian distrigha thaegha, Sisarianɨ uŋuuni ikhaousua gueghiri. ");
INSERT INTO spm_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mee norivɨusua nira aghae bisi anda Herot ativagha garirɨ uŋuun iti. Herota avhesan ikɨvan Tair ri Saidonɨn gumasi rako amisir itima, mee kha bighaaŋmɨusua thighira nori akuvagha aŋn ganamɨusua zui. Mee ufhuaraghavɨra Blastusɨm mbɨkemisi a men phorugha navan amɨɨŋndɨgh nigha gɨva. Blastus, ana ativasir gumagh Herot akuira aŋanan garir gumagh. Gɨn Herot menɨ ukuarukuvighava andaran khava gɨvaousua mbɨkemisima, mee aŋn ganamɨusua zui. ");
INSERT INTO spm_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herotɨ uthughun mav atɨghava, ma uthughun a nona ativasir shaaria sharighava, nombɨ ativasir gumaghan ambirembii aŋga apheraghava, gumasi rako amisi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mee mbɨghɨravɨra dɨɨva kamaghɨusue, “Khara gumagha thavɨ mbɨŋge phatɨ. Khara asaaŋn mavɨ mbɨŋgeeghi.” ");
INSERT INTO spm_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herot Gotɨni izɨɨ ufhii phatɨ, kamagha amuisima Ikhɨvan enselɨ uzuamɨra aŋm mbɨsoesima ana areeghi. Maghɨra aŋnɨ umuun itira aphisi aŋamɨra ana apha zuima, aŋna aremi. ");
INSERT INTO spm_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Uthughun khavɨn Gotɨna akam bar ikhevigha barɨ uŋuimbar gue. ");
INSERT INTO spm_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mauthughura Barnabas ri Sol aniiŋ non iŋaar Jerusalemɨn ana gɨvagha, nomthegha Antioghɨn ze. Jon, aŋni izɨɨn mav Mak, aniiŋ ana nighava aŋn phorughavɨra ze. ");
INSERT INTO spm_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioghɨni iti Kraisɨnɨ andarsi mena marsi iti, Gotɨna ambuuŋn gumasi rako fhɨghɨn gumasi. Meni izɨɨri Barnabas, ri Simeon (aŋni izɨɨn mav Niger), Sairininɨ uŋuun gumagh Lusius, ri Manain (ana ativasir gumagh Herotɨn rɨkurukum, a Herotɨn phorugha aghuuŋi) koma Sol. ");
INSERT INTO spm_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Uthughun mavɨn Kraisɨna andarsi, mee Gotɨn apheeŋn ikava nori nigha Gotɨ aniiŋgava, Gotɨn phorughɨ mbɨkɨmamɨusuava aghae thaghi. Uthughun khavɨn Gotɨnɨ Utum kamagh mem mbɨŋgeeghi, “Khɨɨ Barnabas ri Sol noni iŋarivɨusua aniiŋn dɨɨgha. Gee iŋaaran khavɨusua aniiŋ ambɨsevightima, aniiŋ nan iŋaaraousua maaŋɨ.” ");
INSERT INTO spm_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kamagha amuisi mee Gotɨn phorughɨ mbɨkɨmamɨusuava aghae thaegha, Gotɨn phorugham mbɨŋgeeghi. Mauthughura mee nona aghari nigha Barnabas ri Solɨni iphɨa athɨghava, aniiŋ amandasima aniiŋ zui. ");
INSERT INTO spm_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Gotɨnɨ Utum Barnabas ri Sol amandasima, aniiŋ Selusianɨ uŋuun gugha, nomthegha ukur nigha Saiprusɨn mɨghsɨman gu. ");
INSERT INTO spm_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mee Salamisɨn othuivigha Judarii Gotɨn phorugha mbɨŋgeer rɨphenira avhen gua Gotɨna akamɨ ukuri. Jon Mak aniiŋ phorugha gugha aniiŋna akura. ");
INSERT INTO spm_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Mee Saiprusɨn mɨghsɨmanɨ itirɨ uŋuimbagha arua gua Pafosɨnɨ uŋuun oto. Mee Judarira atomtorir gumaghan mavɨ oto. A khorua amua kamaghɨusue, “Khɨɨ, Gotɨn ambuuŋn gumagh.” Aŋni izɨɨ Bar Iesus. ");
INSERT INTO spm_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A Sergius Paulus, gavmanɨn gumaghan aphanan phorugha iti. Sergius Paulus, a nɨghɨnɨsir aghuire iti gumagh. Uthughun khavɨn a Gotɨna akamam mbaraghaousuava, kamagha amuigha a Pol ri Barnabasɨn dɨɨsima aniiŋ ze. ");
INSERT INTO spm_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mee atomtorir gumaghan khav Grighiiŋna akam mee izɨɨn khavɨn aŋga athɨ Elimasɨn, aŋm mbɨnɨɨŋ atomtorir gumagh. Mauthughura Elimas, a gavmanɨn gumagh Sergiusɨn Paulus, a Iesus nɨghɨnɨghana aghavaghar aŋn ikhan a iphɨrphɨri. Kamagha amuisi, a Barnabas ri Solɨni iŋaar iphasava aŋ ramuamɨusua. ");
INSERT INTO spm_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Sol, aŋni izɨɨn mav Pol, Gotɨnɨ Utum aŋgi izɨvasima, a rɨkɨrava Elimasɨn garava kamaghɨm mbɨŋgeeghi, “Nɨɨ Satanɨn otar. Nɨɨ othevir aghuuira aphanaŋga amui thav. Kamagha amuigha khoru amuir othevi rako othevir maghatɨsi bar nɨɨn izɨva. Ara nɨɨ theeghɨnamɨusua Ikhɨvan othevir aghuuira afharavasi? Nɨɨti othevir maghatɨsi thamɨraghan nɨghɨnɨsi? ");
INSERT INTO spm_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Thighira Ikhɨv nɨɨn aphana ramuva non gamgaaŋn nɨɨn arɨmaghaniiŋ mbɨzeghemi. Uthughun khavɨn, nɨɨ aron aŋaran ganighem phatɨghɨva, nɨɨ uthusi tharsir ikeghemi.” Maghɨra uzuamɨra mbɨturan ikhɨv aŋna arɨmaghaniia nuesima amɨn aŋn phɨri. A thavɨn afharimuunɨ usuiraghaousua phura kɨskɨsava asaghinivi. ");
INSERT INTO spm_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Uthughun khavɨn gavmanɨn gumaghan aphanan akamamba oraegha rɨŋgavan maghatɨgha amui. Ana othuivisi bisir kharsir ganighava kamagha amuigha nɨghɨnɨghana aghavaghar Ikhɨvan iti. ");
INSERT INTO spm_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polɨn phorughava aruir gumasi ivhɨra, mee Pafosɨnɨ uŋuuni ikheghava ukur nigha gua Perganɨ uŋuun othuivi. Kha uŋuu a Pamfilian distrighɨna avheni iti. Uthughun khavɨn Jon Mak khagh mee thaegha nomthegha Jerusalemɨn ze. ");
INSERT INTO spm_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mee Perganɨ uŋuun rɨkavhigha gua Antioghɨnɨ uŋuun othuivi. Kha uŋuu a Pisidian distrighɨna avheni iti. Judarira avhugususanɨ uthughun, mee Gotɨn phorugha mbɨŋgee rɨphenana avhen ghueghava apiighav iti. ");
INSERT INTO spm_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Uthughun khavɨn Gotɨn phorugha mbɨŋgee rɨphenan bisir garir gumasi, mee Moses osɨrisir othevi rako Gotɨna ambuuŋn gumasir akaa rɨmbora mem mbɨŋgeeghi. Mee andar rɨphonigha gɨvaghava, mee Pol ri Barnabasɨm mbɨŋgɨ kamaghɨusue, “Afhoghumani, aŋgo akuruvasi mbɨŋgɨgɨma thavɨn gumasir kharsi vɨkɨmɨusuava, aŋgo mem mbɨkɨm.” ");
INSERT INTO spm_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mauthughura Pol rɨkavighava, nona afharaniiŋn mee rɨkhagharigha, kamaghɨm mbɨŋgɨ kamaghɨusue, “Gee Israeliiŋn akhoghɨn gumasi rako Gotɨn vhusvhusigha aŋna apheeŋn itir igharisirɨ unuaghɨnan gumasi, gee nam mbaragh! ");
INSERT INTO spm_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Fhomɨra Israelir gumasi rako amisi Got a en avhavhia mbɨsevisima, kamagh mee aŋn gumasi rako amisira. Gɨn mee non uŋuua thaegha gua Isivɨnɨ unuaghɨnan gue. Uthughun khavɨn Got meŋga amuima mee rɨmbomboni bar iphɨn guavanaŋga bar avhɨrekevi. Gɨn Got non gamgaaŋn Isivɨn mee nighava akɨra athɨ. ");
INSERT INTO spm_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","A 40 pɨlan ombaarir gumasi phatɨsir aŋan men phorugha ikha, meno osɨmndɨsi niia mena akuruvasi. ");
INSERT INTO spm_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Uthughun khavɨn Kenanɨnɨ unuaghɨnan, Got 7 pɨlana akhosir gumasi rako amisi meŋga asɨghasɨghava, men unuaghɨnan nigha non gumasi rako amisigha anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mee gua Isivɨnɨ unuaghɨnani ikhegha nomthegha zegha Kenanɨnɨ unuaghɨn nisima 450 ombari gɨva. Bisir kharsir gɨn, Got Israelir ganamɨusua gumasira aphania mbɨsevi. Mamaghɨra ikha gua Gotɨna ambuuŋn gumagh Samuelɨnɨ uthughunɨ utu. ");
INSERT INTO spm_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mauthughura mee ativasir gumaghaousua Gotɨna azaaghi. Kamaghɨn amuisima a Solɨn meŋga anɨɨŋi. Kisɨn otar, a Benjaminɨna akhoghɨn gumaghan mav, a 40 pɨlan ombaarir men gari. ");
INSERT INTO spm_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mauthughura Got Solɨ avharaghava, Devita mbɨsevisima an aŋna aŋan nii. Uthughun khavɨn a Devitɨn gun mem mbɨŋgeeghi, ‘Khɨɨ Devitɨn gani, a Jesin otar. Khɨɨ bar vhusvhuiisi gumagh, a khɨɨ vhusvhuiisi bisi bar andara ramuaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Got fhomɨra akama rɨŋgɨran mɨn, gumaghan mav amandasi a Israelivɨusua ze. A Iesus, Devitɨn avhavɨn mav, ena akuruvasir gumagh. ");
INSERT INTO spm_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iesus thighar zaamirɨ uthughun, Jonɨ ufhuaragha zaava nɨghɨnɨsigh ɨraghava uruamir akaman Israelir gumasi rako amisi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jonɨn iŋaaranɨ uthugh gɨvaousuava amuima, a kamagh mem mbɨŋgeeghi, ‘Gee kamaghɨusue, khɨɨ thɨɨŋra? Khɨɨ gee gara iti gumagh phatɨ. A nan gɨn zaami. Khɨɨ aŋna aŋgarir shaarirɨ umbuea afhɨrami thughatɨs phatɨ. Khɨɨ gumaghan khɨn.’ ");
INSERT INTO spm_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nana andarsi, gee Abrahamɨna avhavi rako gee Gotɨn vhusvhusigha aŋna apheeŋn iti igharisirɨ unuaghɨnan gumasi, Got ena akuruvaghaousuava mbɨŋgɨŋgɨman khava amandasima a emɨusua ze. ");
INSERT INTO spm_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalemɨn gumasi rako amisi koma men gumasiri ikii mee kamagh ikeeŋsi phatɨ, Iesus ena akuruvasir gumagh. Mee mɨghasɨgh avhugususanɨ uthughun Gotɨna ambuuŋn gumaghan akaar rɨmborava inderaghɨvɨra anda ikeeŋsi phatɨ. Mee kamaghɨusue gumaghan khav aremighemi. Kamagha amuisima, Gotɨna ambuuŋn gumaghan akaa guisimbaaŋra otogha gɨva. ");
INSERT INTO spm_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mee aŋm mbɨsueghtima aŋna aremighemɨrɨ mbɨŋgɨŋgɨr othɨvhan aghuuŋ thavɨ otosi phatɨ. Mee kamagh Pailat mbɨŋgɨva am mbɨŋgɨ kamaghɨusue, nɨɨ mbɨzorsir gumasi vɨkemightima mee aŋm mbɨsoeghtima ana aremighemi. ");
INSERT INTO spm_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mee fhomɨra Gotɨna ambuuŋn gumasi vɨkemisi moghɨra amui. Mee khani ighuuvan ana daeŋgava ana nigha akɨman thooŋga athɨ. ");
INSERT INTO spm_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Gumughun Got aŋga amuisima a nomthegha rɨkavhi. ");
INSERT INTO spm_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","A ivhɨra Galilin distrighɨn ikava Jerusalemɨn zui gumasi rako amisi, uthusira avhɨrara aŋn gani. Thighira aŋn ganisi gumasir kharsi, mee nori aŋn gun Judarir akoghɨn gumasi rako amisi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ee akamana aghuuŋn kamagh gem mbɨŋgeeghi. Got fhomɨra ena avhavivɨusuava akama rɨkɨra kamaghɨusue, ‘Khɨɨ gena akuruvaghamir gumagha amaaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Thighira a Iesus aŋga amuisima a khuurɨ uŋuun nomthegha rɨkavhi. Ee mena avhavi, kamagha amuisima a emɨusua nona akama rɨŋgɨran khavɨ amuisima a guisimbaaŋra oto. Oŋɨɨna akamanɨ mbɨgharan rɨmbombonan 2ɨn, ma akam kamagh mbɨŋgeeghi, ‘Nɨɨ nano otar. Kamagha amuisima khɨɨ thighira nɨɨn inaghavesɨn otogha gɨva.’ ");
INSERT INTO spm_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ee ikaaŋi, Got aŋga amuisima a nomthegha khuurɨ uŋuun rɨkavhi. Gumughun a nomthegh khuur uŋuun maaŋɨ kurighem thughatɨs phatɨ. Got bighan khavɨn kamaghɨm mbɨkemi, ‘Khɨɨ fhomɨra ativasir gumagh Devit akaar rɨŋgɨrir aŋm mbɨkemisi moghɨn khɨɨ guisimbaaŋra inderaghɨvɨra gee ramuva, bisir aghuuira gee ranɨɨŋgami. Bighan khav khɨɨ mbɨkemisi moghɨn guisimbaaŋra otoghomi.’ ");
INSERT INTO spm_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Igharisir akaman mav ivhɨra Gotɨm mbɨgharan iti. A kamaghɨm mbɨŋgeeghi, ‘Nɨɨ nombɨusua mbɨsevisi gumagh ana thaeghtima aŋm mbɨkarɨgh kurighem phatɨghami.’ ");
INSERT INTO spm_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ee ikaaŋi, uthughun khavɨn Devitɨ unuaghɨnan ikava, a Gotɨn nɨghɨnɨghan gɨn zui. A gɨn aremisima, mee aŋn khum nigha gua aŋna avhavi rafhir aŋanan ana rafha. Gumughun aŋn khum ukuri. ");
INSERT INTO spm_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Got amuisi gumaghan khav a khuurɨ uŋuuni ikhegha rɨkavisi thav, aŋn khum kurisi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Nana andarsi, kamagha amuisima, ee nomthegha mbɨŋgeeghi. Gee akaman khav ikeeŋgɨri. Gumaghan khav Iesus geno othevir maghatɨsi gɨna amaaŋmɨusua ze. Moses osɨrisiro othevi, gena akuragh geno othevir maghatɨsi gɨna amandagham thughatɨs phatɨ. Gee Gotɨna arɨmasi rɨfhaaŋn inderagham thughatɨs phatɨ. Iesusɨn amuisi iŋaaran khav, Got gumasi nɨghɨnɨsira aghavaghari iti tharsi bar men akuruvagha meno othevir maghatɨsi anda gɨna amaaŋgava, meŋga amuima mee aŋna arɨmaghaniiŋn indera. ");
INSERT INTO spm_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gee inderaghɨvɨra norivɨusua ganri! Gee aŋm mbɨzevaraghan iphɨrphɨrightima bigha thav gemba mbatoghomi Gotɨna ambuuŋn gumasi fhomɨra mbɨkemisi moghɨn. ");
INSERT INTO spm_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Khɨɨ genɨ uthughun bighan igharis thavɨ ramuightima a gee mbatoghomi. Gumaghan thav gem mbɨkɨmtima gee nɨghɨnɨghana aghavaghar aŋn ikaami thughatɨs phatɨ. Kamagha amuisi, gee gumasi rɨmbovira akaar maghatɨsigh amui tharsi, gee ganri! Gee rɨŋgavan maghatɨgha ramuighɨva maghatiighemi.’ ” ");
INSERT INTO spm_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Gumughun Pol ri Barnabas Judarii Gotɨn phorugha mbɨŋgeer rɨphena thamɨrasima, gumasi rako amisi kamagh aniiŋm mbɨŋgeeghi, “Aŋgo avhughususanɨ uthugh thavɨn nomthegh zɨva bisir kharsirɨ mbɨŋgɨŋgɨ tharsir nomthegh ee mbɨkɨmaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mee bar Gotɨn phorugha mbɨŋgeer rɨphena theghava akɨran gue. Uthughun khavɨn Judarira avhɨri rako igharisirɨ unuaghɨnan iti gumasi, mee Judariro othevir gɨn zui tharsi, Pol ri Barnabasɨn gɨn zui. Igharisirɨ unuaghɨnan gumasi Gotɨn apheeŋn ikava aŋni izɨɨ ufhii. Aniiŋ mem mbɨŋgɨva, men nɨghɨnɨsi ufha kamaghɨusue, “Gee Gotɨn nɨghɨnɨghan gɨn maŋɨva aŋnɨ ukuarkuvan apheeŋn ikhɨɨri.” ");
INSERT INTO spm_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Gumughun avhughususanɨ uthugh otosi, uŋuun khavɨni iti gumasi rako amisira avhɨrara bar zaa nori akuvaghava Ikhɨvan akamam mbarasi. ");
INSERT INTO spm_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Uthughun khavɨn Judarir akoghɨn gumasi rako amisir phoghɨn khavɨn ganigha, men navi bar maghatɨghi. Mee Polɨn akaa ireghreghava mbɨzer maghatɨsir aŋm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kamagha amuisima Pol ri Barnabas avhighavisi phatɨgha, akaman bara aghavagharan mem mbɨŋgeeghi, “Gee Judarii, aŋga ufhuaragha Gotɨna akaman gem mbɨkemi. Gee akɨrɨ ɨraghava akaman khavɨ ase. Gee kamaghɨusue, ‘Ee mɨghasɨgha itiri ikɨran aghuuŋ thav nian thughatɨs phatɨ.’ Kamagha amuisima, gee oragh, aŋga nomthegha akaman khavɨn gee mbɨkɨman thughatɨs phatɨ. Aŋga igharisirɨ unuaghɨnan gumasi vɨkɨmaŋgami. ");
INSERT INTO spm_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ikhɨv fhomɨra bighan khavɨn gun eem mbɨkemi. ‘Igharisirɨ unuaghɨnan gumasi rako amisi bar mena akuruvaghaousuava, khɨɨ nɨɨa mbɨsevisima, nɨɨ aŋaran igharisirɨ unuaghɨnan gumasir khevi.’ ” ");
INSERT INTO spm_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ara igharisirɨ unuaghɨnan gumasi, mee akaman khavɨ oraegha, bar phuvɨre inighinigha kamaghɨusue, “Ikhɨvana akam bar indera.” Got mɨghasɨgh ikamir ikɨrana aghuuŋmɨusua mbɨsevesi gumasi rako amisi, mee bar inighinighan ikiv aŋni iti. ");
INSERT INTO spm_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gumughun mee Ikhɨvan akam nigha uŋuimba bar andar gue. ");
INSERT INTO spm_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Izɨɨri ikii itira amisir marsi Gotɨn apheeŋn ikava aŋni izɨɨ ufhi. Judarii men navighi inivi. Izɨɨri iti gumasi marsi, mee uŋuuni ikhɨvan khavɨni iti. Judarii men navighi inivima, mee ivhɨra osɨmndɨsir Pol ri Barnabasɨa anɨndi. Kamagha amuigha mee distrighɨna aniiŋm mbatoghi. ");
INSERT INTO spm_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kamagha amuisima, Pol ri Barnabas, nona aŋgarir itirɨ unuaghɨna aphɨsi. Kamagh ramuti gumasi rako amisi ikeeŋgɨm mbɨkɨmaŋga, men othɨvhan khav osɨmndɨgh meŋga anɨɨŋi. Mauthughura, Pol ri Barnabas Antiogha thaegha Aikoniamɨnɨ uŋuun gu. ");
INSERT INTO spm_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kamagha amuisi Antioghɨni iti Kraisɨn suren gumasi, Gotɨnɨ Utum meŋgi izɨvasima mee bar inighinisi. ");
INSERT INTO spm_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol ri Barnabas Antioghɨni ikava amuisir othevira, aniiŋ guava Aikoniamɨn Judarii Gotɨn phorugha mbɨŋgeer rɨphenir avhen andagha amui. Uthughun khavɨn aniiŋ khagh bar inderaghɨvɨra akamɨ ukurima, Judarira avhɨrara ko igharisirɨ unuaghɨnan gumasira avhɨrara nɨghɨnɨghana aghavaghar Iesusɨn iti. ");
INSERT INTO spm_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Judarir marsi nɨghɨnɨghana aghavaghar aniiŋn akaar iti phatɨ. Mee igharisirɨ unuaghɨnan gumasir nɨghɨnɨsigh asɨghasɨghava men navigh inivima, mee nɨghɨnɨsir maghatɨsir Kraisɨn phorus tharsi meŋga amui. ");
INSERT INTO spm_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol ri Barnabasɨ uthughunɨ uruaran Aikoniamɨn ikava, Ikhɨvanɨ ukuarkuvana akamam mbɨkɨmamɨusuava avhighavisi phatɨ. Ikhɨv gamgaaŋ aniiŋga aniiŋsima, aniiŋ gamgaaŋ iti bisi rako rɨŋgavan maghatɨgha amuir othevigha amuima, anda othuivi. Kamagha amuisi Ikhɨv gumasi rako amisir khɨvagha kamaghɨusue, “Aniiŋ mee mbɨŋger akaar kharsi, anda guisimbaaŋran akaa.” ");
INSERT INTO spm_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Uthughun khavɨnɨ uŋuun khavɨni itir gumasi rako amisi noria biigha, marsi Judarir gɨn zuima, marsi Iesusɨm mbɨsevisi gumasivɨusua zui. ");
INSERT INTO spm_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Gɨn Judarii rako igharisirɨ unuaghɨnan gumasi, mee non gumasiri ikiir phorugha nɨghɨnɨghanɨ uvhuavɨre ikha kamaghɨusue, “Ee othevir maghatɨsi Pol ri Barnabas ramuva, aŋgɨr aniiŋgi inivightima aniiŋ arɨmaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pol ri Barnabas kamagh oraeghava arava Likonian distrighɨnɨ guava Listra ko Derbenɨn gu. Uŋuun khanina aghan itirɨ uŋuimbar sovsegher ivhɨra andar gu. ");
INSERT INTO spm_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aniiŋ khagh akamana aghuuŋ ukuravɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Uthughun khavɨn Listranɨ uŋuuna avhen gumaghan mavɨn aŋgari maghatɨgha amɨrasima aŋna arui phatɨghava apheraghavɨre iti. Aŋni inaghamuuŋ aŋm mbatesima a kamaghɨra gari. ");
INSERT INTO spm_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A Polɨ orasima aŋna akamɨ ukuri. Mauthughura Pol rɨkɨrav aŋn gara kamagha ikaaŋi. Kha gumagh nɨghɨnɨghana aghavaghar iti. A inderaghami. ");
INSERT INTO spm_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Mauthughura Pol kamagh mbɨghɨravɨra deeghi, “Nɨɨ rɨkavighɨ utu!” Gumaghan khav nombɨ ukunigha utugha maghɨra arui. ");
INSERT INTO spm_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mauthughura gumasi rako amisira avhɨrar kharsi Pol amuisi bighan khavɨn ganigha, mbɨghɨravɨra Likoniana akaman dɨɨgha mbɨŋgeeghi, “Asae, gumasir mɨn othuivigha emɨusua zaaghire!” ");
INSERT INTO spm_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mauthughura Barnabas, mee asaaŋ Susɨn aŋga athɨ. Pol a mbɨŋgɨmɨŋgɨrɨ ufhuaragha zui gumagh, kamagh amuisima mee asaaŋ Hermesɨn aŋga athɨ. ");
INSERT INTO spm_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Asaaŋ Susɨn rɨphen, a Listranɨ uŋuun rɨvɨnana akɨrani iti. Uthughun khavɨn Susɨn aphuraphurava aghae rako bisir aŋga anɨndir gumagh, aŋn phorugha gumasira avhɨrara, mee Pol ri Barnabasɨusua asɨsi vɨsueghɨva aniiŋn aphuraphuraousua. Kamagha amuisi, ana akɨmaria bɨsighava, burmaghari marsi nigha Listranɨ uŋuun rɨvɨnan itɨmana akamaniiŋn ze. ");
INSERT INTO spm_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mee zesima, Iesusɨm mbɨsevisi gumasi Pol ri Barnabas, aniiŋ bisir kharsi varaegha, aniiŋ non shaaria bɨghɨsuegha, akhɨghavtɨgha gumasi iti phoghɨna avhen gua mbɨghɨravɨra dɨɨ mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Maia! Gumasi, gee thoghousua othɨvhan khavɨ amui? Aŋga ivhɨra gen mɨn gari, phura gumaghan khɨnani. Aŋga kamaghɨusua akamana aghuuŋn gem mbɨŋgeeghi. Gee phura bisir kɨnir kharsir izɨɨri ufha thaghri. Gee nori nighɨva aŋgamɨre iti Gotɨ ranɨɨŋ. A kha ovhee ko unuaghɨn koma oŋara amuisi Got, andar iti bisi ivhɨrama amuisi God. ");
INSERT INTO spm_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Fhomɨra, Gotɨnɨ uŋuimba bar mee thaesima, mee phura non nɨghɨnɨsira aruava bisigha amui. ");
INSERT INTO spm_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","A gen mondusi phatɨ. A mɨghasɨghɨva othevira aghuuira geŋga amui. Amoghɨn geŋga anɨŋgava, aghaera aghuuira avhɨrara geŋga anɨŋgava andagha amuima anda othuivi. A geŋga amuima gen navi inderaghɨvɨra bari inighinisi.” ");
INSERT INTO spm_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Aniiŋ bisir kharsir mem mbɨŋgɨ, akaara aghavagharir mem mbɨŋgɨva men thɨva kamaghɨusue, “Gee aŋgagha aphuraphuruva aghae rako bisir aŋgara anɨɨŋ thaghɨri.” Mee mamagha amuigha aniiŋga amuisi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Gɨn Judarir akoghɨn gumasir marsi Antiogh ko Aikoniamɨn ikhegha Listran zegha, mee gumasir nɨghɨnɨsigh ikuigha meŋga amuisi, mee Polɨn aphanaŋga amui. Mee aŋgɨr Polɨ inivigha aŋn ganigha kamaghɨusue, an aremigha gɨva. Mee ana ukurugha Listranɨ uŋuun rɨvɨnan akɨran gu. ");
INSERT INTO spm_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Gɨn suren gumasi zaava ana ighuisima, a rɨkavhigha nomthegha Listranɨ uŋuun gu. Amɨrɨtusi a Barnabasɨn phorugha aniiŋ Derbenɨnɨ uŋuun zui. ");
INSERT INTO spm_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol ri Barnabas Derbenɨnɨ uŋuun ikava akamana aghuuŋ ukurava gumasi rako amisira avhɨrara amuima, mee suren gumasir othuivi. Aniiŋ nomthegha Listra ko Aikoniam koma Antioghɨn ze. ");
INSERT INTO spm_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Aniiŋ gamgaaŋn suren gumasigha aniiŋgava akuruvasirɨ mbɨŋgɨŋgɨr meŋga amua kamaghɨusue, “Gen non nɨghɨnɨsir aghavagharirɨ utuivigh aghavagharighɨri.” Aniiŋ kamagh mem mbɨŋgɨ kamaghɨusue, “Gumasi rako amisi Gota ativasi tharsi, ee ivhɨra mena avhɨran khavɨna avhen maŋŋamɨusua, ee ufhuaragh osɨmndɨsira avhɨrara niaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pol ri Barnabas Kraisɨna andarsi itirɨ uŋuimbavɨusua uvhuaghuvhagha Kraisɨna andarsir gumasira aphania vɨsevi. Gumasir aruur kharsi non nɨghɨnɨsira aghavagharir Ikhɨva athɨgha gɨva. Mauthughura aniiŋ memɨusua aghae thamɨragha Ikhɨvan phorugha mbɨkemigha bar mee nigha Ikhɨvana afharɨ athɨ. ");
INSERT INTO spm_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pol ri Barnabas Pisidian distrighɨn ikha gua gɨn zaa Pamfilian distrighɨn ze. ");
INSERT INTO spm_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Aniiŋ Perganɨ uŋuuna akamana aghuuŋ ukunigha gɨvagha Atalianɨ uŋuun zeghirɨ. ");
INSERT INTO spm_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Aniiŋ Ataliani ikhegha ukur nigha nomthegha Antioghɨnɨ uŋuun ze. Uŋuun khavɨra, aniiŋ ufhuaragha khagh aŋn ikhee, Antioghɨni itir Kraisɨnɨ andarsi aniiŋ nigha Gotɨn afharɨ arɨgha kamaghɨusue, “Gotɨnɨ ukuarukuvir othɨv aniiŋ phorugh ikhɨti aniiŋ iŋaaran khav ramuaŋga.” Aniiŋ iŋaaran khavɨa amua zaa thighira aniiŋ ana gɨva. ");
INSERT INTO spm_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Aniiŋ Antioghɨno otogha, Kraisɨna andarsir dɨɨsima mee nori akhuvasima. Aniiŋ kamagh mem mbɨŋgeghi, “Got aŋgana agharaniiŋn bisi kharsigha amui. Got ivhɨra igharisirɨ unuaghɨnan gumasivɨusua utuava rɨkɨrisima, thighira mena marsi nɨghɨnɨghana aghavaghar Kraisɨn akaman iti.” ");
INSERT INTO spm_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kamagha amuigha aniiŋ khaghɨ, uthughunɨ uruaraaŋra suren gumasir phorugha ikhee. ");
INSERT INTO spm_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Judian distrighɨn gumasir marsi Antioghɨn zegha Kraisɨn phorus tharsir surea amua kamaghɨusue, “Gee Mosesɨno othevir gɨn maŋɨva non momooŋn niro ofhɨsia rɨghorightima Got nomthegh gee niaŋga. Gee non momooŋn niro ofhɨsia rɨghghorighem phatɨghtima Got nomthegh gee nighem phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kamagha amuisima, Pol ri Barnabas andaran ikɨvan men phorughava aŋga amui. Kamagha amuisima Kraisɨn phorusi tharsi Pol ri Barnabasɨ mbɨŋgɨ kamaghɨusue, “Ena marsi aŋgon phorugh Jerusalemɨn maaŋɨva, Iesusɨm mbɨsevisi gumasir rako Kraisɨn phorusi gumasira aphanir phorughɨva akaman khava rɨkɨrami.” ");
INSERT INTO spm_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mauthughura Kraisɨna andarsi mee amandasima Pol ri Barnabas koma Kraisɨn phorusi marsi ivhɨra men phorughava Fonisian distrigh ko Samarian distrigh mogh gu. Mee gua igharisirɨ unuaghɨnan gumasi non nɨghɨnɨsigh ɨrasi bisir gun mem mbɨŋgeeghi. Mem mbɨkemisima Kraisɨn phorusi tharsi mee bar mbɨŋgɨŋgɨman khavɨ oraegha bari inighinisi. ");
INSERT INTO spm_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mauthughura Pol ri Barnabas koma Kraisɨn phorus tharsi mee gua Jerusalemɨn othuivi. Mee othuivisima Iesusɨm mbɨsevisi gumasir rako Kraisɨna andarsi rakoma men gumasira aphani bar vhusvhusigha mee nii. Uthughun khavɨn Pol ri Barnabas Got aniiŋn afharimuuna amuisi bisi, aniiŋ andar gun mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mauthughura Farisiiŋna akoghɨn gumasir marsi nɨghɨnɨghana aghavaghar Iesusɨn iti tharsi, mee rɨkavhigha kamaghɨm mbɨŋgeeghi, “Igharisirɨ unuaghɨnan iti gumasi ivhɨra Moses osɨrisiro othevir gɨn maŋɨva non momooŋn niro ofhɨsia rɨghoromi.” ");
INSERT INTO spm_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Iesusɨm mbɨsevisi gumasi rako Kraisɨna andarsir gumasira aphanira akaman khava rɨkɨrousua nori akuvagha iti. ");
INSERT INTO spm_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Uthughun uruaran mee bighan khavɨn mbɨŋgɨ gugha Pita rɨkavhigha mem mbɨŋgeeghi, “Nana avheeŋmbuagha gee ikaaŋi. Got fhomɨra gen thooŋn nam mbɨsevigha kamaghɨusue, ‘Nɨɨ igharisirɨ unuaghɨnan gumasi nana akaman aghuuŋn mbɨŋgɨŋgɨman gun mem mbɨkɨmtima mee oraegh nɨghɨnɨghana aghavaghar Iesusɨn ikaami.’ ");
INSERT INTO spm_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ee ikaaŋi. Got gumasi rako amisir navir averi ikaaŋi. A nonɨ Utuman igharisirɨ unuaghɨnan gumasigha anɨɨŋi. A eŋga amuisi moghɨra, a meŋga amui. A bighan khavɨn en khɨvagha, a men vhusvhusigha nom mee nii. ");
INSERT INTO spm_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gotɨna arɨmasi rɨfhaaŋn Judarii rako igharisirɨ unuaghɨnan gumasi, ee bar mamaghɨra gue. Igharsirɨ unuaghɨnan gumasi nɨghɨnɨghana aghavaghar Iesusɨn itima, Got men navigha amuisima mee aŋna arɨmasi rɨfhaaŋnɨ uzue. ");
INSERT INTO spm_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Moses fhomɨra osɨrisir othevi ena avhavi andar gɨn maŋŋan iŋgurasi tharsi rako othevi ee thighira ivhɨra andar gɨn maŋŋan iŋguraŋguraesi tharsi, gee anda nigha nɨghɨnɨghana aghavaghar Iesusɨn iti tharsir ranɨɨŋga. Gee theghousua kamagha amua Gotɨ ondaaghi? ");
INSERT INTO spm_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","En nɨghɨnɨghana aghavaghar kamaghɨusue, ‘En Ikhɨv Iesus enɨ ukuarkuvisi, Got ena akurasi moghɨra mena akuruvaghami.’ ” ");
INSERT INTO spm_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Uthughun khavɨn gumasi nori akuvasi tharsi bar inɨmɨre ikha Barnabas ri Polrɨ orasi. Mee orasima, aniiŋ gamgaaŋn bisi rako rɨŋgavan maghatɨgha amuir othevir gun mem mbɨŋgeeghi. Aniiŋ kamaghɨusue, “Got aniiŋn afharir othevir kharsi igharisirɨ unuaghɨnan gumasira arɨghana, andagha amui.” ");
INSERT INTO spm_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Aniiŋm mbɨkemigha gɨvasima Jems kamaghɨm mbɨŋgeeghi, “Nana avheeŋmbuagha, gee nam mbaragh. ");
INSERT INTO spm_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon en niaghagha kamaghɨusue, ‘Got fhomɨra igharisirɨ unuaghɨnan gumasi nonɨ ukuarkuvano othɨvhan men khɨvasi phatɨ. Thighira Got rɨkɨnarɨkara igharisirɨ unuaghɨnan gumasi nonɨ ukuarkuvano othɨvhan men khɨvagha, men arɨghan gumasir marsi nombɨusua mee nigha meŋga amuisi, mee aŋn gumasi rako amisiva othuivi.’ ");
INSERT INTO spm_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Gotɨna ambuuŋn gumasi em mbɨkemesi moghɨn a mamaghɨra gu. Mee fhomɨra kamagh osɨri, men osɨrisi mbɨŋgɨmɨŋgɨra khara, ");
INSERT INTO spm_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Got kamaghɨm mbɨŋgeeghi, “Devitna andarsi mee ambɨkavan mɨn ighaghire. Gumughun khɨɨ nomthegh zɨɨva, aŋ ramuighti a utughami. An bisir tharsi maghatɨghti khɨɨ nomthegh andara amuighemi. Khɨɨ nomthegh aŋ ramuighti a inderaghami. ");
INSERT INTO spm_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Gumughun gumasi rako amisi ikhavɨre itir tharsi namɨusua uruimi. Khɨɨ meni Ikhɨv. Igharisirɨ unuaghɨnan gumasi rako amisi khɨɨ nombɨusua mbɨsevisi tharsi ivhɨra namɨusua uruimi.” Ikhɨv kamaghɨm mbɨkemi. Ana amui bisir kharsi a fhomɨra fhomɨra gumasi rako amisir khɨvasi mee anda ikaaŋi.’ ” ");
INSERT INTO spm_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Mauthughura Jems gua kamaghɨm mbɨŋgeeghi, “Nan nɨghɨnɨghara khara. Igharisirɨ unuaghɨnan gumasi, mee navighɨ ragha Gotɨusua zuima ee osɨmndɨsir mera anɨɨŋgam phatɨghami. ");
INSERT INTO spm_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ee memɨusua osɨrɨva kamagh mem mbɨkɨmaŋga, ‘Gee mee marvir guagha anɨndir aghaer rama thaghɨri. Gee anda rameghemi, gee Gotɨna arɨmasi rɨfhaaŋn maghatiighemi. Gee nori nigha akuir othevir maghatɨsi ramua thaghɨri. Mee umbuerɨ ufhɨri vɨkɨrima arɨghiresi asɨsi, andar ŋae andare iti gee anda rama thaghɨri. Gee ŋaana thava rama thaghɨri.’ ");
INSERT INTO spm_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gee ikaaŋi. Moses osɨrisi othɨvhan khav, fhomɨra zaa thighira, mee aŋna akam uŋuimbar avhen ana ukuri. Mee avhughususanɨ uthughun uthusir mɨghasɨgha Gotɨn phorugha mbɨŋgeer rɨphenir avhen aŋ rɨmbori.” ");
INSERT INTO spm_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Iesusɨm mbɨsevisi gumasir rako Kraisɨna andarsir gumasira aphani koma Jerusalemɨni iti Kraisɨna andarsi mee Jemsɨn akaman mbɨnambagha norira arɨghan gumaghan mania mbɨsevi, Sailas ri Judas. Judas aŋn izɨɨn mav Barsabas. Gumaghan khaniiŋ Kraisɨn phorus tharsir ufhuaragha zui. Mee aniiŋ amandasima aniiŋ Pol ri Barnabasɨn phorugha Antioghɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Aniiŋ mbɨgharan khav nigha zui. Mbɨgharan khav kamaghɨusue. “Ee, Iesusɨm mbɨsevisi gumasir rako Kraisɨna andarsir gumasira aphani, ee gena andarsi. Ee gemɨusua mbɨgharan khava amandi. Gee igharisirɨ unuaghɨnan iti tharsi nɨghɨnɨghana aghavaghar Iesusɨn iti. Gee Antioghɨnɨ uŋuun ko Sirian distrigh koma Silisian distrighɨn iti. Uthughun aghuuŋ. ");
INSERT INTO spm_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ee kamagh oraghi, ena marsi, ena azarasi phatɨgha gua gem mbɨŋgɨ gen nɨghɨnɨsira afaravaghi. Mee gen khorigha amuisi gee atamatami nɨghɨnɨsi. ");
INSERT INTO spm_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kamagha amuisi ee bar navan uvhuavɨra nigha aniiŋ mbɨsevigha aniiŋ amandasi aniiŋ Barnabas ri Pol phorugha zui. Barnabas ri Pol aniiŋ en aveeŋphomana aghuuŋni. ");
INSERT INTO spm_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Gumaghan khaniiŋ, aniiŋ noniiŋgɨ nɨndɨsi phatɨgha utughava aghavagharigha en Ikhɨv Krais Iesusɨn izɨɨn akamɨ ukuri. ");
INSERT INTO spm_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kamagha amuisi, Judas ri Sailas mbɨgharan khavɨn itira akaar gun gem mbɨkɨmamɨusua, ee aniiŋ amanda. ");
INSERT INTO spm_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ee Gotɨnɨ Utuman phorugha navan uvhuavɨra ikha nɨghɨnɨgha kamaghɨusue. Ee osɨmndɨgha thav nomthegh gee ranɨɨŋgam thughatɨs phatɨghami. Bisir ee gem mbɨkɨmamɨusua amui tharsi gee andar gɨn maaŋɨ. ");
INSERT INTO spm_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Gee mee marvir guagha anɨndir aghaer rama thaghɨri. Gee anda rameghemi, gee Gotɨna arɨmasi rɨfhaaŋn maghatiighemi. Asɨsi mee umbuerɨ ufhɨri vɨkɨrima arɨghiresi tharsi, andar ŋae andare iti gee anda rama thaghɨri. Gee ŋaana thava rama thaghɨri. Gee nori nigha akuir othevir maghatɨsi ramua thaghɨri. Gee bisir kharsi a thaegh inderaghami. En akam kamaghɨrou utu.” ");
INSERT INTO spm_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mauthughura Jerusalem iti Kraisɨna andarsi, gumasi kharsi amandasima, mee Jerusalema thaegha Antioghɨn guegha Kraisɨna andarsi akuvagha mbɨgharan meŋga anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mauthughura Antioghɨn iti Kraisɨna andarsi mbɨgharan khavɨ orasima, ana aghavaghar meŋga anɨŋga men navigha amui anda indera. Mee bighan khavɨusua bari inighinisi. ");
INSERT INTO spm_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ri Sailas aniiŋ ivhɨra Gotɨna ambuuŋn gumaghaniiŋ. Aniiŋm mbɨŋgɨŋgɨr avhɨrara meŋga amui. Kamagha amuisi aniiŋ aghavagharan Kraisɨna andarsigha anɨɨŋga akuruvasir mbɨŋgɨŋgɨra avhɨrara amui. ");
INSERT INTO spm_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Mee uthusi marsi men phorugha Antioghɨni ikhee. Gɨn Kraisɨna andarsi navan amɨɨŋndɨgh nigha mee amandasi, mee nomthegha Jerusalemɨn gumasi mee ameeŋsi tharsivɨusua zui. ");
INSERT INTO spm_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol ri Barnabas Antioghɨni ikava gumasi rako amisir surea amua Ikhɨvan akamɨ ukuri. Gumasi marsi ivhɨra aniiŋ phorugha men surea amua Ikhɨvan akamɨ ukuri. ");
INSERT INTO spm_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Gumughunɨ uthusir marsi gɨvasima Pol gɨn kamagh Barnabasɨm mbɨŋgeeghi, “Aŋga nomthegh uŋuimbar aŋga Ikhɨvana akamɨ ukunisi tharsi maŋŋɨva, aŋga Kraisɨn phorus tharsi ganaŋgami, mee manmaghɨre iti.” ");
INSERT INTO spm_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Mauthughura Barnabas kamagh nɨghɨnɨsi, Jon, aŋni izɨɨn mav Mak, ana nightima, ana aniiŋn gɨn maŋaŋga. ");
INSERT INTO spm_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Jon Mak, Pamfilian distrighɨn phurama aniiŋ athaegha aniiŋn phorugha iŋaara gɨvasi phatɨ. Kamagha amuigha, ana aniiŋn phorugh maŋŋamɨusuava amuima Pol aŋgi iphɨrphɨri. ");
INSERT INTO spm_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Aniiŋ akamndooŋni mbɨzorighan ikhɨva amuigha aniiŋ nonia bɨghi. Mauthughura Barnabas ri Mak ukur nigha Saiprusɨn mɨghsɨman gu. ");
INSERT INTO spm_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol Sailasam mbɨsevi. Mauthughura Kraisɨn phorus tharsi mee nori akuvagha aniiŋ nigha Ikhɨvana aghara athɨgha kamaghɨm mbɨŋgeeghi, “Ikhɨvanɨ ukuarkuv aŋgon phorugh ikaami.” Mauthughura aniiŋn gu. ");
INSERT INTO spm_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Aniiŋ Sirian distrigh koma Silisian distrigh mogh gua, Pol aghavagharan Kraisɨna andarsigha anɨndi. ");
INSERT INTO spm_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol gua Derbenɨn otogha gua Listrano oto. Khagh suren gumaghan mavɨn izɨɨ Timoti, a iti. Aŋni inaghamuuŋ Judarir akoghɨn amighan mav nɨghɨnɨghana aghavagharan Kraisɨn iti. Aŋni inaghaves Grighiiŋna akamaŋga aghuuir gumagh. ");
INSERT INTO spm_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra ko Aikoniamɨn itir Kraisɨna andarsi kamagh aŋm mbɨŋgɨ kamaghɨusue, “Timoti bar gumaghan aghuuŋ.” ");
INSERT INTO spm_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Mauthughura Pol a Timoti nigh maŋŋamɨusua vhusvhusi. Mamagha amuigha Pol a Timoti nigha Judariir marsi itirɨ uŋuimbar maŋŋamɨusua, Timotin momooŋn nerɨn ofhɨghar rɨtu. Judarir akoghɨn gumasi mee non niro ofhɨsiar rɨghori, Grighiiŋna akamaŋga aghuuir gumasira phatɨ. Judarii mee ikaaŋi, Timotini inaghaves a Grighiiŋna akamaŋga aghuuir gumagh. ");
INSERT INTO spm_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Fhomɨra Iesusɨm mbɨsevisi gumasir rako Kraisɨna andarsir gumasira aphani Jerusalemɨn mbɨkemisira akam, ma akam a iti. Pol, Sailas ri Timoti mee uŋuimbari ikiir guava kha akaman gɨn maŋŋamɨusua gumasir vɨŋgɨgha arui. ");
INSERT INTO spm_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kamagha amuisima Kraisɨna andarsi, men nɨghɨnɨsi bar aghavaghari. Mauthughura men rɨmbomboni uthusirɨ utuiriv a bar iphɨn guavanandi. ");
INSERT INTO spm_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Gumughun Gotɨnɨ Utum Pol rɨŋn gɨna arui tharsi, mee Esian distrighɨn akamana aghuuŋ ukunan men thɨva. Kamagha amuisi, Pol ri Sailas, koma Timoti, mee Frigian distrigh ko Galesian distrigh mogh gue. ");
INSERT INTO spm_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mee Misian distrigh koma Bitinian distrighɨnɨ usuisɨghanɨn otoghava Bitinian distrighɨn avhen maŋŋamɨusuava amuima, Iesusɨnɨ utum men thɨva. ");
INSERT INTO spm_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mee kamagh Misian distrighɨn mbɨkeeŋga athɨgha, Troasɨnɨ uŋuu mogh gueghire. ");
INSERT INTO spm_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pol rɨmaaŋn irɨmɨn mɨn bighan mavɨn garima, Masedonian distrighɨn gumagh utughav ikava aŋga aghora, kamaghɨusue, “Gee Masedonian distrighɨn zɨva ena akura.” ");
INSERT INTO spm_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol irɨmɨn mɨn bighan khavɨn ganigha, ee uzuamɨra bisighi ighuvighɨva Masedonian maŋŋamɨusuava utuaviusua ganaŋga. Ee ikaaŋŋi, Got nona akamana aghuuŋn mem mbɨkɨmamɨusua en deeghi. ");
INSERT INTO spm_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ee Troasɨnɨ uŋuuna ukur nigha Samotresnɨ uŋuumɨusua zui. Amɨrɨtusi rɨmaaŋra Neapolisɨnɨ uŋuumɨusua zui. ");
INSERT INTO spm_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ee khagh rɨkavighava gua Filipainɨ uŋuuno othuivi. Romiiŋ bar fhomɨra zaava aphiisirɨ uŋuuni ikhɨvan mav Filipai, a uŋuuimbarɨ ufhaaraghɨvɨra zuirɨ uŋuuni ikɨvan mav Masedonian distrighɨna avhen iti. Uthughun khavɨn ee khaghɨ uthusir marsi ikhee. ");
INSERT INTO spm_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Avhugususanɨ uthughun, ee uŋuuni ikhɨvan itɨman akamaniiŋn akɨran gua rɨmɨn gueghiri. Ee kamaghɨusue, Gotɨn phorugha mbɨkɨmaŋgamir aŋana thavti khagh ikhaama ti. Ee khagh amisir marsir garima mee nori akuvagha itima, ee apiigha mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Amighan mav a ikava orasi, aŋn izɨɨ Lidia, a Taiatairanɨ uŋuun ikhɨvan amighan mav, a zegha non shaariira aghevir mɨna amuisi tharsi amandi. A Gotɨn apheeŋn ikava aŋni izɨɨ ufhira amigh. Ikhɨv aŋn nɨghɨnɨgh igheghavɨkɨnisima a Polɨn mbɨŋgɨmɨŋgɨv orasi. ");
INSERT INTO spm_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Aŋn phorugha rɨphenanɨ uvhuavɨre iti tharsi, ee mee uruegha gɨvasima, a no rɨphenan maŋŋamɨusua en gɨamui. A kamaghɨm mbɨŋgɨ kamaghɨusue, “Gem mbɨkɨm, khɨɨ guisimbaaŋra nɨghɨnɨghana aghavaghar Ikhɨv Iesusɨn ikhɨtima, gee zɨɨ na rɨphenan ikhɨɨ.” A kamagh ee mbɨŋgɨ bar eŋga aghorima ee aŋn gɨn gue. ");
INSERT INTO spm_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Uthughun mavɨn ee Gotɨn phorugham mbɨŋger aŋanan zuima, iŋaarana amighan mav, utuman maghatɨgh aŋga aphasasi, a em mbato. Utuman maghatɨgh aŋga aphasasima a gemba othuivhami bisi ikeeŋga andar gunɨm mbɨŋgeeghi. Kamagha amuisima aŋn garir gumasi ana amuir iŋaaran khavɨn aŋgɨro ovhɨsirɨ avhɨrara nii. ");
INSERT INTO spm_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mauthughura amighan khav, Polɨn phorugha en gɨn zaa dɨɨ kamaghɨ mbɨŋgeeghi, “Gumasir kharsi bar iphɨn itir Gotɨn iŋaarir gumasi. Mee Got gen akuruvaghamirɨ utuavɨn gun gem mbɨŋgeeghi.” ");
INSERT INTO spm_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A uthusira avhɨrara kamagha amui. Uthughun khavɨn Pol aŋgi iphɨrphɨrigha ighaeghirɨgha kamaghɨ utuman maghatɨgham mbɨŋgeeghi, “Khɨɨ Krais Iesusɨni izɨɨn nɨɨm mbɨŋgeeghi, nɨɨ akɨran zɨɨ!” Maghɨra utuman maghatɨgh ana thaghi. ");
INSERT INTO spm_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mauthughura aŋn garir gumasi ikaaŋi, men aŋgɨro ovɨsi nirɨ utuav phɨri. Kamagha amuisima mee Pol ri Sailasɨnɨ usuiragha aniiŋ ukurugha gumasiri ikiivɨusuava aŋanan aroghɨn gu. ");
INSERT INTO spm_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mee aniiŋn akua osɨmndɨsiva oraghava anda rɨkɨrir gumasivɨusua gugha kamaghɨm mbɨŋgeeghi, “Khara Judian gumaghaniiŋ. Aniiŋ enɨ uŋuuni ikhɨvan itir gumasi rako amisir navighi inivima osɨmndɨsir avhɨrara othuivi. ");
INSERT INTO spm_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Aniiŋ ee Romiiŋn gumasi rako amisighi ikuightima, ee amui phatɨsir othevir gɨn maŋŋamɨusua aniiŋ ee mbɨŋgeeghi.” ");
INSERT INTO spm_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mauthughura gumasi rako amisi mee zaa nori akuvagha ivhɨra mee akaar Pol ri Sailasɨ aniiŋga asi. Mauthughura osɨmndɨsiva oraghava anda rɨkɨrir gumasi mbɨŋghɨɨr othevi vɨŋgɨ kamaghɨusue, “Gee aniiŋn shaari usueghɨva umbueŋmba athɨvan aniiŋm mbɨsogh.” ");
INSERT INTO spm_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mee Pol ri Sailas bar phuvɨra aniiŋm mbɨsuegha gɨvaghava, aniiŋ nigha rɨvɨnan khɨrthɨgha athɨ. Mee inderaghɨvɨra aniiŋn ganaŋgamir akamana aghavaghar nigha, rɨvɨnan kɨrthɨghan garir gumagha anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kha uthughun rɨvɨnan kɨrthɨgha rɨphenan garir gumagh osɨmndɨsiva oraghava anda rɨkɨrir gumasira akamam mbaraegha, aniiŋ nigha rɨphenana avhena aŋanan kɨrtɨgha athɨgha, aniiŋnɨ usuaniiŋ ambuura khan khavɨn phorugha aniiŋ ikhee. ");
INSERT INTO spm_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Gumughunɨ rɨmaaŋna arɨghan Pol ri Sailas Gotɨn phorugham mbɨŋgɨva mbɨtisigha amui. Aniiŋ kamagha amuima, rɨvɨnan kɨrthɨghani iti gumasir marsi aniiŋm mbarasima ");
INSERT INTO spm_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","mbɨkɨmkɨghan ikhɨvan mav otosima, rɨvɨnan kɨthɨgha rɨphen anɨɨŋkui. Maghɨra rɨvɨnan khɨrthɨghan ithɨɨra akaa uzuamɨra akaraghire. Mee rɨvɨnan kɨrthɨghan itir gumasi ikesi ukuaghavii bar fhɨraghire. ");
INSERT INTO spm_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mauthughura rɨvɨnan khɨrtɨgha rɨphenan garir gumagh osegha rɨkavhigha rɨvɨnan khɨrthɨghan rɨphenan ithɨɨr akaar garima anda bar ukuaghire. Aŋn nɨghɨnɨgh kamaghɨusue rɨvɨnan kɨrthɨghani iti gumasi bar areghamati. Kamagha amuisima a nom mbɨzoghana akosa asigha nombɨra nombɨ uruagh aremighaousuava amui. ");
INSERT INTO spm_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Maghɨra Pol mbɨghɨravɨra deeghi, “Nɨɨ nombɨra nombɨ rafharavagha thaghɨri! Ee bar khar iti.” ");
INSERT INTO spm_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mauthughura rɨvɨnan kɨrthɨghan garir gumagh aŋarivɨusua deeghi, a maghɨra avhighaviigha inɨghava akɨghavɨtɨgha gua Pol ri Sailas itira aŋanambaaŋn gugha aniiŋna aghan irɨ. ");
INSERT INTO spm_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ana aniiŋ nigha akɨran otogha aniiŋna azaaghi, “Arumani, khɨɨ theeghɨna ramuighɨ mbɨghɨvɨghɨighti?” ");
INSERT INTO spm_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ana aniiŋm mbɨkemisima aniiŋ ana ikara, “Nɨɨ nɨghɨnɨghana aghavagharan Ikhɨv Iesusɨn ikhɨtima, a nɨɨna akuruvaghtima, nɨɨn phorugha iti tharsi ivhɨra mbɨghɨvɨghɨighemi.” ");
INSERT INTO spm_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mauthughura aniiŋn Ikhɨvan akaman aŋm mbɨŋgɨva aŋn phorugha itir tharsi bar mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ma Rɨmaaŋnɨ, rɨvɨnan khɨthɨgha rɨphenan garir gumaghan khav aniiŋ nigha aniiŋ uzuu urue. Aniiŋ uzuamɨra rɨvɨnan khɨthɨghan garir gumagh koma ana andarsi Iesusɨni izɨɨn bar mee urue. ");
INSERT INTO spm_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mauthughura rɨvɨnan khɨrthɨghan gari gumagh Pol ri Sailas nigha no rɨphenan avhen gugha aghaer aniiŋga anɨndi. A nona andarsir phorugha nɨghɨnɨghana aghavaghar Gotɨn ikava, mamagha amuigha, mee bar phuvɨre inighinisi. ");
INSERT INTO spm_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Amɨn itirasima, osɨmndɨsiva oraghava anda rɨkɨrir gumasi mbɨŋghɨɨr othevi amandasima mee zaa kamagh rɨvɨnan kɨrthɨghan gari gumagham mbɨŋgeeghi, “Osɨmndɨsiva oraghava anda rɨkɨrir gumasi kamaghɨm mbɨŋgeeghi, ‘Nɨɨ Pol ri Sailasa thaeghtima aniiŋ maaŋɨ.’ ” ");
INSERT INTO spm_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Rɨvɨnan khɨrthɨghan gari gumagh kamagh Polɨm mbɨŋgeeghi, “Osɨmndɨsiva oraghava anda rɨkɨrir gumasi kamaghɨusue, ‘Aŋgo Sailasɨri maaŋɨ.’ Mamagh aŋgo thighira maaŋɨ. Aŋgo navana amɨɨŋndɨghan maaŋɨ.” ");
INSERT INTO spm_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Aŋm mbɨŋgeema Pol mbɨŋghɨɨr othevi vɨŋgeeghi, “Aŋga Romiiŋn gumaghaniiŋ maghɨ. Osɨmndɨsiva oragha anda rɨkɨrir gumasi mbɨŋghɨɨr othevi vɨkemisima, mee phura gumasira arɨmasirɨfhaaŋn aŋgam mbɨsoegha aŋga nigha rɨvɨnan kɨthɨgha athɨ. Mee aŋgam mbɨzeva oraesi phatɨ. Mee thighira mondugha aŋga amaŋamɨusua? Bar phatɨghami! Mee nori zɨva aŋgana aku akɨran maŋŋanga.” ");
INSERT INTO spm_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mbɨŋghɨɨr othevi akaar kharsir gun osɨmndɨsiva oraghava anda rɨkɨrir gumasi vɨkemi. Pol ri Sailas Romiiŋ gumaghaniiŋ mamagh amuisima mee oraegha avhighavighi. ");
INSERT INTO spm_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kamagha amuisima, osɨmndɨsiva oraghava anda rɨkɨrir gumasi, rɨvɨnan khɨrthɨgha rɨphenan gugha aniiŋ amɨɨva aniiŋna akua akɨran gua, aniiŋm mbɨŋgɨ kamaghɨusue, “Aŋgo uŋuuni ikhɨvan khava thaegh maaŋɨ.” ");
INSERT INTO spm_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mauthughura aniiŋ rɨvɨnan khɨrthɨgha rɨphena thaegha Lidia rɨphenan gugha, Kraisɨna andarsir ganigha, akaar marsir mem mbɨŋgɨva, gamgaaŋn meŋga aniiŋga, gumughuna aniiŋ gu. ");
INSERT INTO spm_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Aniiŋ gua, Amfipolis koma Apolonianɨ uŋuunia avhevigha guavɨreikha Tesalonaikanɨ uŋuuno othuivigha, Tesalonaikanɨ uŋuuna avhen gua garima, Judarii Gotɨn phorugha mbɨŋgee rɨphenan mav iti. ");
INSERT INTO spm_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Mauthughura Pol Gotɨn phorugha mbɨŋgee rɨphenana avhen gu. Khara a mɨghasɨghava amuiro othɨv. Ana avhughususanɨ uthughun phunini mbɨkethavɨn Gotɨm mbɨgharan itira osɨriri marsir meŋgi ighara mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ano osɨrir marsir men khɨvagha anda vɨnɨŋgari vɨŋgɨ kamaghɨusue, “Kraisɨ mbɨzagh nighɨva aremigh nomtheghɨ rɨkavamir mbɨŋgɨŋgɨm, a guisimbaaŋra.” A kamaghɨm mbɨŋgeeghi, “Khɨɨ Iesusɨna akamɨ ukuri. A Got nomthegh gumasi rako amisi niamɨusua mbɨsevisi gumagh.” ");
INSERT INTO spm_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mauthughura Judan gumasir marsi oraegha nɨghɨnɨghana aghavaghar akaar kharsir ikava Pol ri Sailasɨn nɨghɨnɨghan gɨn zui. Grighiiŋna akamaŋga aghuuir gumasi, Gotɨn apheeŋn ikava aŋni izɨɨ ufhii tharsi koma izɨɨri itira amisir avhɨrara ivhɨra Pol ri Sailasɨn nɨghɨnɨghan gɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Gumasira avhɨrara Pol ri Sailasɨn nɨghɨnɨghan gɨn zuima, kamagha amuisima Judarir navi bar men maghatɨghi. Mee phurama aruava phoghɨn iti gumasir maghatɨsir marsi akumakumigha gumasir bɨsan ikhɨva amui. Mee gua uŋuuni ikhɨvana avhen arua mbɨghɨravɨra avesava aŋgaravasi. Mee Pol ri Sailas nighɨva avhɨrar thooŋn maŋŋamɨusua, ithɨmakharigha aniiŋn usuighousuava akhɨrɨsiigha Jesonɨ rɨphenana avhen gue. ");
INSERT INTO spm_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mee aniiŋn ganisi phatɨgha, Jeson koma Kraisɨn marsi ukuruvaegha uŋuuni ikhɨvan garir gumasir aphanivɨusua mee nigha gu. Mee kamagh deeghi, “Gumaghan khaniiŋ osɨmndɨsirɨ unuaghɨnan khavɨn uŋuimba bar andagha arɨgha zaa thighira khagho othuivi. ");
INSERT INTO spm_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Mauthughura Jesona aniiŋ nigha no rɨphenaŋga athɨ. Gumaghan khaniiŋ Sisar osɨrisir othevir gɨn maŋŋan bar iphɨrphɨri. Aniiŋ kamaghɨm mbɨŋgeeghi, ‘Ativasir ikhɨvan igharisi mav ivhɨre iti, aŋni izɨɨ Iesus.’ ” ");
INSERT INTO spm_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Gumasi rako amisira avhɨrara nori akuvasi tharsi koma uŋuuni ikhɨvan garir gumasira aphani, mee men akaman khavɨ oraegha rɨŋgavan maghatɨgha amuigha dɨɨ uthuaghii. ");
INSERT INTO spm_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mauthughura uŋuuni ikhɨvan garir gumasir aphani kamagh Jesonɨm mbɨkemi, “Nɨɨ nona andarsira akhuvaghɨva kha osɨmɨndɨgho ovhesightima, ee gea thaeghtima, gee maŋŋaŋga.” Mee mamagha amuigha norivagha uvhuesighava nori gue. ");
INSERT INTO spm_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Amɨn phɨrima, Kraisɨna andarsi uzuamɨra aniiŋ amandasi aniiŋ Berianɨ uŋuun gu. Aniiŋ gua otogha Judarii Gotɨn phorugha mbɨŋgee rɨphenana avhen gu. ");
INSERT INTO spm_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berianɨ uŋuuni itir Judarii, men othevi rako men nɨghɨnɨsi bar indera. Mee Polɨm mbɨŋgɨmɨŋgɨva oraghaousua bar vhusvhusi. Mee Polɨm mbɨŋgɨmɨŋgɨ vɨnɨŋgaria bɨghɨva bar anda ikaaŋmɨusua mɨghasɨgh Gotɨm Mbɨgharan ganri. Mee kamagh ikaaŋmɨusua, Polɨm mbɨŋgɨmɨŋgɨ, anda guisimbaaŋra mbɨŋgɨmɨŋgɨ, o? Kamagha amuisima, mee Tesalonaikanɨ uŋuuni iti Judariro othevigha afhira. ");
INSERT INTO spm_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Judarii avhɨrara nɨghɨnɨghana aghavaghar Iesusɨni ikava, ivhɨra izɨɨri iti Grighiiŋna akamaŋga aghuuir amisi marsi rako Grighiiŋna akamaŋga aghuuir gumasira avhɨrara nɨghɨnɨghana aghavaghar Iesusɨni iti. ");
INSERT INTO spm_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tesalonaikanɨ uŋuuni iti Judarir akoghɨn gumasir marsi orasi, Pol Berianɨ uŋuuni ikha Gotɨna akamɨ ukuri. Tesalonaikanɨ uŋua thaegha gua Berianɨ uŋuuni iti Judarii, mee Berianɨ uŋuun gumasi rako amisir kharsi nɨghɨnɨsira afharavaghava men navighi inivi. ");
INSERT INTO spm_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kraisɨna andarsi uzuamɨra Pol amandasi ano oŋara mbɨkeeŋn gu. Sailas ri Timoti Berianɨ uŋuuni ikhavɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Uthughun khavɨn Polɨn akua zuir gumasi gua Atensɨnɨ uŋuun ana athɨsima, Pol nombɨn gɨn zaaosua Sailas ri Timotiusua akaman meŋga anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol Atensɨnɨ uŋuuni ikha Sailas ri Timoti usua gari. A garima, Atensɨnɨ uŋuuni ikhɨvana avhen marvir gua bar izɨva. Kamagha amuisi Polɨnɨ umuu bar maghatɨghi. ");
INSERT INTO spm_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","A bighan khavɨusua Gotɨn phorugha mbɨŋgee rɨphenana avhen gugha, Gotɨn apheeŋni ikava aŋni izɨɨ ufhuir Grighiiŋna marsi rako Judarir akoghɨn gumasi ivhɨra mem mbɨŋgeeghi. A ivhɨra bisighɨ uvhuesir aŋanan mɨghasɨgha gumasi phura zaava othuivi tharsi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Uthughun khavɨn Epikurian phoghɨn gumasi rako Stoikɨn phoghɨn ikaaŋmaran gumasir marsi mee Polɨn phorugha nori vatosi. Marsi kamaghɨm mbɨŋgeeghi, “Oŋanan mav tisi vɨŋgeeghi?” Marsi kamaghɨm mbɨŋgeeghi, “A ti igharisirɨ uŋuun itir asaaniiŋn akamɨ ukuramati.” Pol Iesusɨn gunɨm mbɨŋgɨɨva, gumasi rako amisi gumughuna arɨghireghɨva nomthegh rɨkhavamir bighaaŋn gunɨm mbɨkemisima Atensɨnɨ uŋuuni itir marsi mee kamaghɨusue, “A ti kha asaaniiŋm mbɨŋgɨmati.” ");
INSERT INTO spm_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Mee ana nigha Atensɨnɨ uŋuun garir gumasira aphanir ikiir arɨghan guava mee Areopagusɨn oraghɨn nori akuvagha iti. Mee kamagh Polɨm mbɨŋgeeghi, “Ee fhomɨra thange oraesi phatɨsi nɨghɨnɨsi nɨɨ anda vɨŋgeeghi. Ee anda vɨnɨɨŋgari ikaaŋn vhusvhusi. Kamagha amuisi ee ikaaŋmɨusua, khara nɨghɨnɨghan ikaman mav, nɨɨ aŋn gumasir surea amui. Nɨɨ khara em mbɨŋgeeghi.” ");
INSERT INTO spm_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atensɨnɨ uŋuun gumasi rakoma Atensɨnɨ uŋuuna akɨran zaa iti tharsi, mee mɨghasɨgha phure ikava nɨghɨnɨsir iŋgaava oraghava anda vɨŋgeeghi.) ");
INSERT INTO spm_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol gumasira arɨghanɨ uthugha Areopagusɨno oraghɨn kamaghɨm mbɨŋgeeghi, “Gee Atensɨnɨ uŋuun gumasi! Khɨɨ gen garima, gee asaer gɨn maŋŋamɨusua bar aghavaghari. ");
INSERT INTO spm_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Khɨɨ arua bar inderaghavɨra gen marvir guaar garava, gee asaeghi inighinisi bisi bara andar gani. Khɨɨ ivhɨra aphuraphurava aghae rako bisir aŋga anɨndira akhoghɨn mavɨn garima, osɨɨran mav aŋni iti. Ma osɨɨr kamaghɨusue, ‘Ee ikeeŋsi phatɨsir asaaŋna aphuraphurava aghae rako bisir aŋga anɨndir akogh.’ Thighira gee gɨn zuira asaaŋn khav gee ikeeŋsi phatɨsi thav, kha aŋna akaman gun gem mbɨkɨmamɨusua. ");
INSERT INTO spm_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Asaaŋ mav iti. Aŋn izɨɨ Got, a nombɨra unuaghɨnan khav koma aŋn iti bisigha amui. Anara ovhee ko unuaghɨnan Ikhɨv. Gumasi nona afharir amuisi rɨpheni Got andar iti phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Gotɨn khav a nombɨ ambirambina aghuuŋ ko bisi bar gumasi rako amisigha anɨɨŋi. A bigha thavɨn othevisi phatɨ. Kamagha amuisima, ee nona afharir an akuruvaghamir bigha thavɨ ramuighem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Got gumaghanɨ uvhuavɨra amuisima, gumasi rako amisi bar aŋno othuivigha gua unuaghɨna khav bar aŋga aphighi. Got nombɨ mee ikhaamir ambirambinɨ uthusi arɨghi. Mee itir aŋanir a memɨusua unuaghɨn mbɨthee arɨghi. ");
INSERT INTO spm_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Gotɨn vhusvhus a kamagh iti, gumasi rako amisi aŋmɨusua uruiva, aŋna aghare ikɨva ana ikeeŋgemi, kamagha amuisima a kha bisigha amui. Guisimbaaŋra Gotɨ uvhuaghuvhagha eni isaghuni iti phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","29","Anara eŋga amuima, ee ikava, aruava aŋamɨre iti. Geni ikaaŋmarir gumasir marsi kamaghɨm mbɨkemi, ‘Got guisimbaaŋra enga amuisima ee othuivi.’ Kamagha amuisima gee kamagh nɨghɨnɨgha thaghɨri, Got a gol o silva o akɨm ti. Ee kamagh nɨghɨnɨgha thaghɨri, Got a gumasi nona nɨghɨnɨsir amuisir marvir guaar mɨn iti bar phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Fhomɨra gumasi rako amisi Got ikeeŋsi phatɨ. Mee ikeeŋsi phatɨghava amuisi bisi Got andaghɨ nɨghɨnɨgha andavagha mem mbɨŋgee phatɨ. Thighira Gotɨ mbɨŋgɨŋgɨman aghavaghara anɨɨŋga kamaghɨusue, ‘Unuaghɨna khavɨn iti gumasi rako amisi mee bar non nɨghɨnɨsigh ɨraghɨri.’ ");
INSERT INTO spm_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Got othevir maghatɨsigha amuir gumasi rako amisighi ighaaŋgamirɨ utugha rɨkɨrigha gɨva. Got nono othɨvhan aghuuŋn gɨn gua gumaghan mavam mbɨsevi. Ma gumagh a unuaghɨnan khavɨn iti gumasi rako amisighi ighaaŋgami. Gumaghan khav aremisi Got aŋga amuisima a nomthegha rɨkavi. Kamagha amuisima, gumasi rako amisi ganighava ikaaŋi. Kha bighaaŋ anaaŋ guisimbaaŋra, a gumasi rako amisighi ighaaŋgamir gumagh Got anam mbɨsevi.” ");
INSERT INTO spm_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Am mbɨŋgeema, mee nomɨ rɨkavamirɨ mbɨŋgɨŋgɨv oraegha, marsi aŋ rɨphovi. Marsi kamaghɨm mbɨŋgeeghi, “Nɨɨ uthugh thavɨn nomtheghɨva bighan khavɨm mbɨkɨmti, ee nɨɨm mbaraghaousua.” ");
INSERT INTO spm_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mauthughura Pol mea thaegha gu. ");
INSERT INTO spm_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Gumasir marsi Polɨn nɨghɨnɨghan gɨn gua nɨghɨnɨghana aghavaghar aŋm mbɨŋgɨmɨŋgɨr iti. Men thooŋn Dionisius a gumaghana aphanan mav mɨghasɨgha men phorugha Areopagusɨn oraghɨn phosirɨ usuisir gumagh. Amighan mav ivhɨra, aŋni izɨɨ Damaris, koma gumasi rako amisir marsi ivhɨra mee nɨghɨnɨghana aghavaghar Polɨn mbɨŋgɨmɨŋgɨr iti. ");
INSERT INTO spm_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bisi kharsir gɨn, Pol Atensɨnɨ uŋua thaegha Korinɨnɨ uŋuun gu. ");
INSERT INTO spm_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A khagh Judarir akoghɨn gumaghan mavɨ oto, aŋni izɨɨ Akwila. Aŋnɨ uŋuu Pontusɨn distrighɨna avheni iti. A nona amuuŋ Prisilana akua Italinɨ unuaghɨnan ikɨran uruaraaŋra mange itima, uthughun khavɨn Sisar, aŋni izɨɨn mav Klodius a Judarii vɨŋgɨ kamaghɨusue, “Gee Romɨnɨ uŋuuni ikɨva thaegh igharagh maaŋɨri.” Kamagha amuigha, aniiŋ Italinɨ unuaghɨna thaegha Korinɨ uŋuun ze. Uthughun khavɨn Pol aniiŋn ganamɨusua zui. ");
INSERT INTO spm_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pol ivhɨra aniiŋn mɨra, seli rɨphenigha amui. Kamagha amuisima, ana aniiŋn ganamɨusua gua, aniiŋn aghan ikava men phorugha iŋaari. ");
INSERT INTO spm_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Avhughususanɨ uthusir, Pol mɨghasɨgha Judarii Gotɨn phorugha mbɨŋgeer rɨphenir gua men phorugha mee nori vɨŋgeeghi. A Judarii rako Grighiiŋna akamaŋga aghuuir gumasi rako amisi, men nɨghɨnɨsir ramutima, mee nɨghɨnɨghana aghavaghar Iesusɨn ikhaousua meŋga aghori. ");
INSERT INTO spm_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mauthughura Sailas ri Timoti Masedonian distrigha thaegha zesima, Pol bar nonɨ uthusir mɨghasɨgha Gotɨna akamana aghuuŋ ukuri. Aŋna akaman aghavagharan Judarii inderaghavɨra kamagh meŋgi ighari, Iesus, a Got nom gumasi rakoma amisi niamɨusua mbɨsevisi gumagh. ");
INSERT INTO spm_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Uthughun khavɨn Judarii Polɨn akamam mbaraghan agharkuvighava, mbɨŋgɨŋgɨr maghatɨsir aŋga amui. Mee kamagh amuisima, a non shaaran mbɨnisi aphɨsigha, kamagh mem mbɨŋgeeghi, “Gee kamagh Gotɨn isaghun ikɨɨva nori arɨmɨghi iraami, mara gen osɨmndɨghara. Khɨɨ nombɨ osɨmndɨsi phatɨ. Thighira khɨɨ Gotɨna akamana aghuuŋn igharisirɨ unuaghɨnan gumasi vɨkɨmaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mauthughura Pol Gotɨn phorugha mbɨŋgeer rɨphena thaegha Titiusɨ rɨphenan gu. Aŋn izɨɨn mav Jastus, gumaghan khav mɨghasɨgha Gotɨn apheeŋn ikava aŋni izɨɨ ufhii. Aŋ rɨphen a Judarii Gotɨn phorugha mbɨŋgee rɨphenan aghan iti. ");
INSERT INTO spm_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, Judarir Gotɨn phorugha mbɨŋgee rɨphenan bisir garir gumagh. A nona andarsir phorugha mee nɨghɨnɨghana aghavaghar Ikhɨvan iti. Uthughun khavɨn Korinɨ uŋuun gumasi rako amisira avhɨrara Polɨn akamam mbaraegha nɨghɨnɨghana aghavaghar Iesusɨn itima mee mee urue. ");
INSERT INTO spm_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Rɨmaaŋn mavɨn, Ikhɨv irɨmɨn mɨn bighan Polɨ mbɨkemi, “Nɨɨ avhighavigha thaghɨri. Nɨɨ mbɨkɨmvɨre ikhɨɨ. Inɨmɨre ikaa thaghɨri. ");
INSERT INTO spm_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Khɨɨ nɨɨ phorugha iti, nan gumasi rako amisira avhɨrara uŋuuni ikhɨvan khavɨni iti. Kamagha amuisi thav iphas nɨɨ ramuva, nɨɨ mbɨsueghem phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Gumughun Pol ombaranɨ uvhuavɨra koma mavɨno ofhɨghaaŋn ikava, Gotɨna akamana aghuuŋn men surea amui. ");
INSERT INTO spm_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio, Akaian distrighɨn gavmanɨn gumaghana aphanan itima, Judarir akoghɨn gumasi bar rɨkavhigha Polɨn aphanaŋga amuava ana nigha osɨmndɨsiva oraghava anda rɨkɨrir aŋanana aroghɨa athɨ. ");
INSERT INTO spm_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Mee kamaghɨusue, “Gumaghan khav, a gumasi rako amisi vɨŋgɨ kamaghɨusue, ‘Gee Moses osɨrisir othevi rɨkaphoghɨva, othɨvhan igharis thavɨn Gotɨn apheeŋn ikava aŋni izɨɨ ufhii.’ ” ");
INSERT INTO spm_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol bar mena akam ikaravaghaousuava amuima, Galio Judarii vɨŋgeeghi, “Gumaghan khav Romiiŋ osɨrisir othevia biighemi, o aŋno othɨvhan maghatɨgha thavɨ ramuightima, khɨɨ Judarii gena akaav oraghami. ");
INSERT INTO spm_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Geem mbɨŋgɨŋgɨr othevi rako atamatam izɨɨri rakoma gen othevi, andaghɨ nɨghɨnɨgha namɨusua zaa thaghɨri. Gee nori andar rɨkɨrighɨri. Khɨɨ bisir kharsiro osɨmndɨsi varaeghem phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kamagha amuisima a mee amandasima mee ana thaegha ze. ");
INSERT INTO spm_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Uthughun khavɨn Korinɨ uŋuun gumasi, Sostenesɨnɨ usuiragha, osɨmndɨsiva oraghava anda rɨkɨrir aŋanana aroghɨm mbɨkeeŋn aŋm mbɨsosi. A Judarii Gotɨn phorugha mbɨŋgee rɨphenan bisir garir gumagh. Mauthughura Galion nɨghɨnɨgh a kamaghɨusue, “Me mara aŋra amu.” ");
INSERT INTO spm_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Polɨ uthusir marsir Korinɨ uŋuuni ikhegha, Prisila ri Akwila nigha, mee Kraisɨna andarsia thaegha zaava Senkrianɨ uŋuuno othuivighava, a nona akama rɨngɨra gɨvagha nona aphanana arɨghɨna rɨphɨri. Kamagha amuigha gɨvagha mee Sirian distrighɨn zaaousuava ukuran guava anambogha nori zii. ");
INSERT INTO spm_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mee Efesusɨnɨ uŋuuno othuivigha, Pol a Prisila ri Akwila anamogha aniiŋ thaghi. A nombɨ Judarir Gotɨn phorugha mbɨŋgee rɨphena mavɨn gua men phorugha nori vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mee uthusi tharsir norir gan ikhaaousuava aŋm mbɨŋgeema, a kamaghɨusue, phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","A mauthughura a mea thamɨragha kamaghɨusue, “Got vhusvhusightima, khɨɨ nomthegh gemɨusua zaami.” A kamaghɨm mbɨkemigha ukur nigha Efesusɨnɨ uŋua thaegha ze. ");
INSERT INTO spm_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","A Sirian distrighɨn zaava Sisarianɨ uŋuuno otogha, Jerusalemɨnɨ uŋuun iti Kraisɨna andarsighi itiisua zaavanambogha gɨn Antioghɨnɨ uŋuun zeghirɨ. ");
INSERT INTO spm_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Gumughun Pol uthusir marsi Antioghɨnɨ uŋuuni ikhegha, a Galesian distrigh koma Frigian distrighɨni itirɨ uŋuimba bar andagha aruava, nɨghɨnɨghan aghavaghar Iesusɨn iti tharsi a gamgaaŋ meŋga anɨndi. ");
INSERT INTO spm_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Judarir akoghɨn gumaghan mav, aŋni izɨɨ Apolos, aŋni inaghamuuŋ Aleksandrianɨ uŋuun aŋmba athee. A zaava Efesusɨnɨ uŋuun iti. A Gotɨm mbɨgharan osɨrir marsi ikeeŋga bar inderaghɨvɨra nɨghɨnɨgh andavɨ mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mee Ikhɨvan nɨghɨnɨsi rako othevir aghuuir aŋn niaghesima a gumasi rakoma amisir sure ramuamɨusuava aŋn nav bar rɨkavhisima mamagha amuisima, a bar inderaghavɨra Iesusa amuisi bisir mem mbɨŋgeeghi. A Jonɨnɨ ururare ikaaŋi. ");
INSERT INTO spm_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mauthughura Apolos Judarii Gotɨn phorugha mbɨŋgeer rɨphen gugha, avhighavisi phatɨgha Gotɨna akamɨ ukuri. Mauthughura Prisila ri Akwila aŋm mbaraegha ana nigha rɨphenan gugha Gotɨn nɨghɨnɨsi rako othevir aghuuir aŋn niaghesima a inderaghɨvɨre ikaaŋi. ");
INSERT INTO spm_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Gumughun Apolos Akaian distrighɨn maŋŋamɨusuava amuima, Efesusɨnɨ uŋuuni itir Kraisɨna andarsi, gamgaaŋn aŋga aniiŋga, ana niamɨusua Akaian distrighɨn itir suren gumasivɨusua mbɨghar osɨri. Kha uthughun Apolos Akaian distrighɨno otogha garima, nɨghɨnɨghana aghavaghar Gotɨn iti marsi, a menɨ ukuarukuvisima mee nɨghɨnɨghana aghavaghar aŋn itima Apolos men ganighava mena akura. ");
INSERT INTO spm_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos bar aghavagharigha gumasi rako amisir arɨmasi rɨfhaaŋn akaa ukurava men akaa ikarvagha, Judarir mem mbɨŋger akaar maghatiisir tharsi a mee rɨkaphosi. A Gotɨm mbɨgharan itir akamɨ ukuri. Kamagh ramuightima mee ikeeŋgɨm mbɨkɨmaŋga, Iesus a Got nom ee niamɨusua mbɨsevisi gumagh. ");
INSERT INTO spm_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kha uthughun Apolos Korinɨnɨ uŋuuni ikhavɨre itima, Pol orasir itirɨ uŋuimbagha arua gua zaa Efesusɨnɨ uŋuuno oto. Ana anamoghɨn suren gumasir marsi vatogha. ");
INSERT INTO spm_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","A mena azaaghi, “Gee ufhuaraghavɨra nɨghɨnɨghana aghavaghar Iesusɨn itima, Gotɨnɨ Utum geeŋgi izɨvasi, o phatɨ?” Mee kamaghɨusue, “Phatɨ, ee ivhɨra thange kamagh oraesi phatɨ, Gotɨnɨ Utum iti.” ");
INSERT INTO spm_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol mena azaaghi, “Gee ururan manavɨra nii?” Mee ana ikaragha kamaghɨusue, “Jonɨnɨ uruur.” ");
INSERT INTO spm_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Mem mbɨkemisima Pol kamaghɨusue, “Jonɨnɨ uruur a nɨghɨnɨsigh ɨraghamirɨ uruur. Jon gumasi rako amisi mbɨŋgɨ kamaghɨusue, ‘Gee nɨghɨnɨghana aghavaghar nan gɨn zaamir gumaghan ikhɨɨ, a Iesus.’ ” ");
INSERT INTO spm_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mee kamagh oraegha gɨvasima Pol a Ikhɨv Iesusɨni izɨɨn mee urue. ");
INSERT INTO spm_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Mauthughura Pol nona afharimuuniiŋn meni iphɨa athɨsima, Gotɨnɨ Utum memɨusua zeghira meŋgi izɨvasima, mee igharisirɨ uŋuimbar akaa vɨŋgɨva Gotɨna ambuuŋn gumasir mɨnɨ mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mee barbar men rɨmbomboni kamaghɨ oto, “12 pɨla.” ");
INSERT INTO spm_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Gumughun Pol ikɨniiŋn phunini ko mbɨkethavɨn, a Gotɨn phorugha mbɨŋgee rɨphenana avhen, gumasi rako amisir akaar aghavagharir mem mbɨŋgɨ avhighavisi phatɨgha a Got kha bisigha ativamirɨ uthughun gun mem mbɨŋgɨva men nɨghɨnɨsigh ɨraghousa mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Uthughun khavɨn marsi men navi aghavagharisima, mee Polɨna akaav oraghan agharkuvigha, gumasir arɨmasi rɨfhaaŋn azenara kha mbɨzer maghatɨsir Gotɨnɨ nɨghɨnɨsi rako othevir aghuigha amui. Mauthughura Pol mea thaegha nɨghɨnɨghana aghavaghar Iesusɨn itir tharsi nigha gu. A uthusir kharsir mɨghasɨgha Tiranusɨn surea rɨphenan bisir mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol ombaran phuninin avhen othɨvhan khavɨra amui. Kamagha amuisima Esian distrighɨn iti Judarii rako Grighiiŋa, mee bar Ikhɨvana akamam mbarasi. ");
INSERT INTO spm_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mauthughura Pol Gotɨn gamgaaŋn nona afharir bisiri iŋgagha amui. ");
INSERT INTO spm_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ivhɨrama dooria morirɨ mbɨsasiro ofhɨsir marsi, mee anda Polɨ mbɨkarɨghan phoeghava, anda nia gua arɨmarɨr gumasigha arɨsima anda nomthegh inderasima, unduur maghatɨsi mea thamɨrasi. ");
INSERT INTO spm_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mauthughura Judarir akoghɨn gumasir marsi uŋuimbagha aruava unduur maghatɨsi vatosi. Mee Ikhɨv Iesusɨni izɨɨnɨ unduur maghatɨsi gumasir avheni iti tharsi vatoghousua. Mee kamaghɨm mbɨŋgeeghi, “Kha Polɨm mbɨŋgeer Iesusɨn izɨɨn, khɨɨ mbɨghɨravɨra nɨɨm mbɨŋgeeghi, nɨɨ ana thaegh maŋɨ!” ");
INSERT INTO spm_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Uthughun khavɨn Skeva, a Judarir Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumaghani ikhɨvan mav. Ano otarir 7 pɨla, unduur maghatɨsi vatosi. ");
INSERT INTO spm_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Uthughun mavɨnɨ, utuman maghatɨghan mav kamagh mem mbɨŋgeeghi, “Khɨɨ Iesus ikeeŋgava Pol ivhɨrama ana ikaaŋi, gee thaeŋa?” ");
INSERT INTO spm_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mauthughura utuman maghatɨgh aphasasir gumaghan khav, nombɨ ufhuegha mem mbɨkɨnighava phuvɨra mem mbɨsogha mea arɨghi. Am mbɨzaghɨn maghatɨghan meŋga asima mee ŋeeghɨ uruava imuŋgaara rɨphena thaegha ara akɨran gue. ");
INSERT INTO spm_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mauthughura Judarii rako Grighiiŋna akamaŋga aghuuir gumasir Efesusɨnɨ uŋuuni iti tharsi bighan khavɨ oraegha bar avhighavighava Gumasi Ikhɨv Iesusɨn izɨɨ iphɨufhi. ");
INSERT INTO spm_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ufhuaraghavɨra nɨghɨnɨghana aghavaghar Iesusɨn iti tharsi thighira zaa gumasir arɨmasi rɨfhaaŋn nono othevir maghatɨsi gunɨm mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Gumasi rako amisir avhɨrara akusi rako atomtorir bisir maghatɨsigha amui tharsi, mee ma osɨrisirɨ mbɨŋghari anda nigha zaa, gumasi rako amisir arɨmasi rɨfhaaŋn anda utue. Mee mbɨgharir kharsirɨ uvhuesi rɨmbomboni, 50,000ɨn silvan aŋgɨro ovhɨsirɨ utu. ");
INSERT INTO spm_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kamagha amuisi, Ikhɨvam mbɨŋgɨŋgɨmɨ uŋuimba bara andar zui. Gumasi rako amisira avhɨrara nɨghɨnɨghana aghavaghar Ikhɨvan mbɨŋgɨrɨgɨr itima a mbɨghɨravɨra men navira avherir iŋaari. ");
INSERT INTO spm_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bisi kharsi othuivigha gɨvasima, Pol Jerusalemɨnɨ uŋuun maŋŋamɨusua non nɨghɨnɨgha amui, a kamaghɨ nɨghɨnɨsi a maŋɨ Masedonian distrighɨno otogh maŋɨ Akaian distrighɨni ikheeghɨva Jerusalemɨno otoghomi. A kamaghɨusue, “Khɨɨ Jerusalemɨni ikeghɨva, gɨn khɨɨ Romiiŋn uŋuuni ikhɨvan maŋŋaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ana akuruvaghan gumaghaniiŋ, Timoti ri Erastus, ana aniiŋ nigha Masedonian distrighɨna aniiŋ amanda. A nombɨ muaŋ Esian distrighɨn ikhee. ");
INSERT INTO spm_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Uthughun khavɨra gumasir marsi Ikhɨvan nɨghɨnɨsi rako othevir aghuivɨusua andaram mbɨŋgɨŋgɨman ikhɨva amui. ");
INSERT INTO spm_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Gumaghan mav, aŋni izɨɨ Demitrius. A silvan bisigha amuir gumagh. Ana aŋgɨro ovɨsi niamɨusuava, silva rɨphenir sovseghegha amuisima, anda kha asaaŋna amigh Artemisɨ rɨphenan mɨn gari. Gumasira avhɨrara Demitriusɨn phorugha iŋaarava aŋgɨro ovhɨsirɨ avhɨrara nii. ");
INSERT INTO spm_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetriusɨn phorugha iŋaari gumasi rakoma igharisa gumasir mee bar kha iŋaara amuava aŋn phorugha ivhɨn ikee. A kamaghɨm mbɨŋgeeghi, “Maia, gee ikaaŋi. Ee aŋgɨro ovɨsir iŋaaran khavɨ amuava aŋgɨro ovɨsir ikii nii. ");
INSERT INTO spm_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Gee Pol amuisi bisir garava aŋm mbɨŋgheer akaav oraesire. A Efesusɨnɨ uŋuu koma Esian distrigh gumasi rako amisi bar men nɨghɨnɨsi ighaghɨusue. A kamaghɨm mbɨŋgɨ kamaghɨusue, ‘Gumasi amuir marvir gua, anda guisimbaaŋra goti phatɨ.’ ");
INSERT INTO spm_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Polɨn akaman khav ena aŋgɨro ovɨsir iŋaaran izɨɨna aghuuŋra afaravaeghemi. Bighan khavɨra phatɨ, gumasi rako amisir kamaghɨ nɨghɨnɨsi, Artemisɨn rɨphen a phura bighan khɨn. Am mbɨŋghɨmɨŋgɨ Esian distrigh koma unuaghɨnan khav bar aŋga aruisima mee kha asaaŋna amighan izɨɨ ufheghem phatɨghami!” ");
INSERT INTO spm_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mee oraegha athara maghɨra mbɨghɨravɨram mbɨŋgɨ kamaghɨusue, “Artemis izɨɨni ikhɨv iti. A Efesusɨnɨ uŋuuna asaaŋn amigh!” ");
INSERT INTO spm_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Uthughun khavɨn uŋuun khavɨni itir gumasi rako amisi bar nɨŋnɨɨŋni ikhɨva amui. Mee bar, Gaius ri Aristarkusɨn usuiragha aniiŋ ukuruvagha, nori akuvir aŋanan ikhɨvan uzuamɨra akhɨrɨsiigha gue. Aniiŋ Masedonian distrighɨn gumaghaniiŋ Polɨn phorugha arui thani. ");
INSERT INTO spm_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol nombɨ gumasi rako amisir phoghɨn thooŋn maŋŋamɨusuava amuima, nɨghɨnɨghana aghavaghar Iesusɨn iti tharsi aŋn thevi. ");
INSERT INTO spm_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ivhɨra Efesusɨn gavmanɨn gumasir marsi, mee Polɨn aveeŋmbua, mee aŋmɨusua akam amaŋga mbɨghɨravɨra aŋn rɨghorigharua kamaghɨusue, “Nɨɨ aŋanan ikhɨvan gumasi rako amisi nori akuvir thavɨn maŋŋan thaghɨri.” ");
INSERT INTO spm_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Gumasi rakoma amisi uthughun khavɨn nori akuvisi tharsi mee atamatami nɨghɨnɨsi. Marsi bighan mavɨm mbɨŋgɨ deeghi. Marsi bighan igharisi thavɨm mbɨŋgɨ deeghi. Gumasira avhɨrara kamagh ikeeŋsi phatɨ, mee theoghousuavɨra zaa nori akuvagha iti. ");
INSERT INTO spm_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mauthughura Judarii, men gumaghan mav Aleksandera tɨvamandasi, a gua ufhuaraghavɨrou utu. Mauthughura marsi kamaghɨusue, “Aleksander ti osɨmndɨgha mbɨnɨɨŋ.” Mauthughura a nona afharimuni inɨmɨre ikhaousua mem mbɨŋgeeghi. A men akaa ikaravaghousua. ");
INSERT INTO spm_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mee ikaaŋi, a Judarir akoghɨn gumaghan mav, mee barbar nori nigha dɨɨ kamaghɨusue, “Artemis izɨɨni ikhɨv iti. A Efesusɨnɨ uŋuuna asaaŋn amigh!” Men dɨndɨɨ aron iŋeendagh uthughun phuninin gu. ");
INSERT INTO spm_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mauthughura Efesusɨnɨ uŋuuni ikhɨvan osɨɨran gumagh gumasir phoghɨn khava amɨɨva kamagh mem mbɨŋgeeghi, “Efesesiiŋn gumasi rako amisi gee oragh. Unuaghɨnan khavɨn gumasi rako amisi bar ikaaŋi. Akɨman mavɨn izɨɨ Artemis ana ovheeni ikhegha zeghirɨ. Kamagha amuisima Efesusɨnɨ uŋuun ikɨva, Artemisɨn rɨphen ko an akɨman garir uŋuun. ");
INSERT INTO spm_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ee ikaaŋi, gumagha thav akaar kharsir guaragham thughatɨs phatɨghami. Kamagha amuisima gee inɨmɨre ikhɨɨ, gee uzuamɨra bigha thavɨ ramuan thaghɨri. ");
INSERT INTO spm_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gee gumaghan khaniiŋ nigha khagh ze. Aniiŋ Artemisɨn rɨphenan bigha thavo okemisi phatɨ. Aniiŋ Artemisɨn izɨɨra afharavaesi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demitriusɨn phorugha iŋaarir gumasi, mee osɨmndɨghan kha gumaghani ikhɨtima, osɨmndɨsiva oraghava anda rɨkɨrir rɨphenir rako osɨmndɨsiva oraghava andar rɨkɨrir gumasi iti. Mee men osɨmndɨsiva oraghava andar rɨkɨrir rɨphenan andar rɨkɨrami. ");
INSERT INTO spm_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Khara osɨmndɨsiva oraghava anda rɨkɨrirɨ uthugh phatɨ. Kamagha amuisi gee osɨmndɨsi ikhɨva, gee maŋɨ nomthegh osɨmndɨsiva oraghava anda rɨkɨrir uthughun zɨva anda rɨkɨrami. ");
INSERT INTO spm_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Romiiŋn gumasi ee kha amuisi bighaaŋmba oraegh zɨva, kamagh em mbɨkɨmaŋga, ‘Gee osɨmdɨghi iti.’ Ee amuisi bighan khavɨm mbɨnɨŋ phatɨ. Mee bighan khavɨusua azaraghtima, ee mbɨkɨmaŋgamirɨ mbɨŋgɨmɨŋgɨ phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","A kamaghɨm mbɨkemigha gɨvagha gumasi rako amisi amandasi mee gue. ");
INSERT INTO spm_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Osɨmndɨgh gɨvasima, Pol a Iesusɨn gɨn zui tharsi nombɨn aghan zaaousua men gɨa amuisi, mee zesima a mem mbɨŋgɨva aghavagharan men nɨghɨnɨsigha niiŋga gɨvagha a mena agharirɨ usuigha mea thaegha Masedonian distrighɨn gu. ");
INSERT INTO spm_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A Masedonian distrighɨn gugha Iesusɨn gɨna arui tharsi, mem mbɨŋgɨva aghavagharan men nɨghɨnɨsigha niiŋga gɨvagha, gumughun a Grighɨn unuaghɨnan gu. ");
INSERT INTO spm_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","A ikɨniiŋn phunini ko mbɨkethavɨn Grighɨn distrighɨni ikhegha ukur nigha Sirian distrighɨn maŋŋamɨusuava amuima, Judarii a mbɨsoghousuava mbɨŋgɨŋgɨman mava rɨkɨri. Kamagha amuisima, aŋnɨ ukuarigh aŋgi ivisima a nomthegha Masedonian distrighɨn zii. ");
INSERT INTO spm_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","A zima, Berianɨ uŋuun gumaghan mav, Sopater, a Pirusɨn otar, an aŋn phorugha zii. Aristarkus ri Sekundus, aniiŋ Tesalonaikanɨ uŋuun gumaghaniiŋ ivhɨra aŋn phorugha zii. Gaius, Derbenɨnɨ uŋuun gumagh ivhɨra aŋn phorugha zii. Timoti gumaghan khaniiŋ, Tikikus ri Trofimus, aniiŋ Esian distrighɨn gumaghaniiŋ, mee bar ivhɨra Polɨn phorugha zii. ");
INSERT INTO spm_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Gumasi kharsi ufhuaragha gua Troasɨnɨ uŋuun emɨusua gara iti. ");
INSERT INTO spm_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ee Filipainɨ uŋuun ikhavɨre itima, iis phatɨsirɨ uvhuisirɨ uthuurɨ uthusi gɨvasima, ee ukur nigha Filipainɨ uŋuua thaghi. Gumughun 5 pɨlanɨ uthusi nomthegha gɨvasima ee gua Troasɨnɨ uŋuun emɨusua gara iti gumasi vatuivi. Ee 7 pɨlanɨ uthusi Troasɨnɨ uŋuuni ikhee. ");
INSERT INTO spm_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Avhughususanɨ uthughun gɨnɨ, Kraisɨna andarsi en phorugha ee uvhuɨsirɨ uthuur bɨɨghɨusuegha ramamɨusuava zaa nori akuvagha iti. Uthughun khavɨn Pol amɨrɨtusi rɨmaaŋra maŋŋamɨusua, kamagh aŋna akam ukura guavɨra ikha rɨmaaŋnarɨghan utu. ");
INSERT INTO spm_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ee bar nori nigha gunavan phunininim mbɨkethavɨn amuisi rɨphenani iphɨni iti. Kha gunav aŋaarira avhɨrara iti. ");
INSERT INTO spm_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Uthughun khavɨn gumaghani ikaman mav aŋni izɨɨ Yutikus. A gunavan punini mbɨkethavɨn bar iphɨre iti thavɨnɨ, aŋguu bar phuvɨra aŋna arɨmaghaniiŋga amuisima, a mee gamiiŋ niamɨusua rɨthusiri ithɨmaŋga apheragharava akuava oŋani. Polɨm mbɨŋgɨvɨre itima a iphɨna ikegha daeŋga unuaghɨnaŋgi irɨɨ. Mee gua ana nigha aŋn garima, a bar aremi. ");
INSERT INTO spm_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol maghɨra gueghira, aŋni iphɨn guaghava ana umuigha. A kamaghɨusue, “Gee avhighavigha thaghɨri. Ana aŋgamɨre iti.” ");
INSERT INTO spm_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mauthughura Pol guŋna avhen guavanambogha, uvhuɨsirɨ uthuua bɨɨghɨusuegha gumasi rako amisi phorughava mee anda aphi mee anda amegha. Pol mee mbɨŋgɨvɨre itima amɨn itira. Ma uthugh a zui. ");
INSERT INTO spm_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A zuima, mee aŋamɨre iti gumaghani ikaman khav nigha aŋrɨ rɨphenan gua bari phuvɨre inighinisi. ");
INSERT INTO spm_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ee kamaghɨusue, “Ee ukuran maŋŋanɨva Asosɨnɨ uŋuun Polɨna agheghɨva ana nighɨ ukuran maŋŋanga.” Pol nombɨ kamaghɨusue, “Khɨɨ utuavɨn maŋŋanga.” Ee mamagha amuigha Pola thaegha ufhuaragha ukur nigha Asosɨnɨ uŋuun zii. ");
INSERT INTO spm_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Gumughun Pol Asosɨnɨ uŋuun ena aghegha, en phorugha ukuran khav nighava Mitilinɨnɨ uŋuun ze. ");
INSERT INTO spm_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Amɨrɨtusi rɨmaaŋra ee ukuran gua Kiosɨnɨ mɨghɨsɨman mbɨroghɨa athɨgha zii. Uthughun khavɨn gɨn ee zaa Samosɨn mɨghɨsɨm otoghava, amurɨtusi rɨmaaŋra ee zaa Miletusɨnɨ uŋuuno othuivigha gɨva. ");
INSERT INTO spm_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol uthusira avhɨrara Esian distrighɨni ikhani iphɨrɨphɨrigha, a uzuamɨra maŋɨ, Jerusalemɨnɨ uŋuuno otoghɨva, Pentikosɨnɨ uthughun ikhɨvan ganamɨusua vhusvhusi. Mamagha amuigha a Efesusɨnɨ uŋuuŋgi indɨragha zaa Miletusɨnɨ uŋuuno oto. ");
INSERT INTO spm_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ee Miletusɨnɨ uŋuuno otivighava Pol nombɨna aghan zaaousuava, Efesusɨnɨ uŋuun Kraisɨna andarsir gumasira aphani memɨusua akaman amanda. ");
INSERT INTO spm_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Mauthughura mee zaava othuivisima, a mem mbɨŋgeeghi, “Gee khɨɨ amuir othevi marsi ikaaŋi, khɨɨ ufhuaraghavɨra zaava Esian distrighɨn zegha othevir kharsigha amua, zaa thighiraou utu. ");
INSERT INTO spm_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Judarii nam mbɨsoghousua mbɨŋgeeghi. Kamagha amuisi khɨɨ bar nombɨ rɨkaphoghava osɨmndɨsi rako thaerpha ivhɨra Ikhɨvan iŋaarigha amui. ");
INSERT INTO spm_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Khɨɨ gena akuruvaghamira akama thavɨn gem mbɨkɨmɨusua khɨɨ gee mbɨkɨmaŋga, kha avhighaviisi phatɨgha, uvhuaghuvhuagha gee rɨphenira azenara gen surea amui. ");
INSERT INTO spm_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Khɨɨ akamana aghavaghara Judarir akhoghɨn gumasi rako amisi koma igharisirɨ unuaghɨnan gumasi rako amisi vɨŋgɨ kamaghɨusue, ‘Gen non nɨghɨnɨsigh ɨraghɨva gen non othevir maghatɨsi thaeghɨva Gotɨn gɨn maaŋɨva, nɨghɨnɨghana aghavaghar ee non Ikhɨv Iesusɨn ikhɨɨ.’ ");
INSERT INTO spm_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Gee oragh, Gotɨnɨ Utum nan avheni ikava, thighira Jerusalemɨn maŋŋamɨusua phuvɨra nam mbɨŋgeeghi. Khɨɨ kamagh ikeeŋsi phatɨ kha bighaaŋn manmaghɨra namba othuivti. ");
INSERT INTO spm_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Khɨɨ kamagh bisir kharsigh ikaaŋi, khɨɨ uŋuimbar ikii bar andar zuima Gotɨnɨ Utum nam mbɨŋgɨ kamaghɨusue, ‘Rɨvɨnan kɨrthɨgh koma osɨmndɨsi namɨusua gara iti.’ ");
INSERT INTO spm_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Khɨɨ nombɨ kharɨghei nɨghɨnɨsi phatɨ. Nani Ikhɨv Iesus iŋaaran mavɨn naŋga anɨɨŋi. Iŋaaran khav a khara, khɨɨ bigha thav niamɨusuava akɨrɨsɨsi. Gumagh non akhɨrɨsɨgh ana gɨvaousua amui, kamaghɨra khɨɨ ivhɨra non iŋaara gɨvaousua bar vhusvhusi. Iŋaaran khav a khara, Got non ukuarukuvan othɨv gumasi rako amisi bar men khɨva. Kamagha amuisima khɨɨ bisir kharsira akamana aghuuŋ ukuri. ");
INSERT INTO spm_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Gee oragh. Khɨɨ gen thooŋn ikha Got kha bisigha ativamirɨ uthughuna akamɨ ukuragha arui. Khɨɨ ikaaŋi, thighira gee nomthegh nan khoman ganighem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Khɨɨ bighan khuaŋmɨusua avhighavhisi phatɨgha Gotɨn nɨghɨnɨsi bar gem mbɨŋgeeghi. Kamagha amuisima, thighira khɨɨ bar inderaghɨvɨra gem mbɨkɨmamɨusua, gee kamagh Gotɨn isaghun ikɨɨ nori arɨmɨghi ireghemi, mara gen osɨmndɨghara. Khɨɨ nombɨ osɨmndɨsi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Gee nori norivɨusua ganɨva, ivhɨra Gotɨn gumasiri rako amisir gan. Gotɨnɨ Utum geam mbɨsevisima gee Kraisɨna andarsir gan. A bar andar ganamɨusua geam mbɨsevi. Gee sivsiviir garir gumasir mɨni ikɨva, Kraisɨna andarsir ganɨri. Got nombɨ nono Otaran ŋaanan meŋgɨ uvhuesi. ");
INSERT INTO spm_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Khɨɨ kamagh ikaaŋi, khɨɨ gɨn gea thaegh maŋŋɨtima, gumasir marsi afheera athɨɨr mɨn gen thooŋn zaami. Afheera athɨɨ sivsiviigha asɨghasɨsi moghɨra, Kraisɨna andarsigha asɨghasiighemi. ");
INSERT INTO spm_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Gena tharsira Kraisɨna andarsigha ikuusua khorira akaa vɨŋgeeghi. Mee kamaghɨra amuightima Kraisɨna andarsi men gɨn maŋŋaŋga. ");
INSERT INTO spm_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kamagha amuisima, gee norivɨusua inderaghɨvɨra ganighɨri. Khɨɨ ombaarir phunini ko mbɨkethavɨn gena aghan ikava amuisir othevi, gee andaghɨ nɨghɨnɨghɨri. Khɨɨ arue rako rɨmaŋgarir, thaerphar samɨra, mɨghasɨgha nɨghɨnɨsira aghuuira uvhuaghuvhagha gem mbɨŋgɨva, thange mbɨtɨa thava athɨsi phatɨ. Kamagha amuisima, gee norivɨusua inderaghɨvɨra ganighɨri. ");
INSERT INTO spm_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Khɨɨ thighira gee nigha Gotɨn afharɨa athɨsima, aŋnɨ ukuarkuvan akam gee ramuti gee gamgaeŋtima Got bisir aghuuira non gumasi rako amisir ranɨɨŋga. ");
INSERT INTO spm_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Khɨɨ igharisi gumasir silvari rakoma golri rako mbɨsasir vhusvhuisi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gee norira ikeeŋga gɨva, khɨɨ nona afharimuuŋra amuisiri iŋaarir nombɨna akuruvaghava nombɨna aghan iti gumasi ivhɨra mena akuruvasi. ");
INSERT INTO spm_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Khɨɨ amuisiri iŋaari bar, kamagha andar gen khɨva. Gee gamgaeŋgi iŋarɨva bisi phatɨsi gumasira akuruvaghami. Kamaghɨra eni Ikhɨv Iesus nombɨ amuisira akamaŋgi nɨghɨnɨghami. A kamaghɨm mbɨkemi, ‘Bigha aniiŋsi gumaghan inighinigh a bari ikhevisima, ma bigh nisir gumaghani inighinigh a sovi.’ ” ");
INSERT INTO spm_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Uthughun khavɨn Pol akaman khavɨm mbɨkemigha, a men phorugha mee barbar ithevia rɨphɨrighava, mee Gotɨn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mee bar aziava ana umuighava aŋn thori. ");
INSERT INTO spm_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pol mem mbɨŋgɨ kamaghɨusue, “Gee nomthegh nan khoman ganighem thughatɨs phatɨ.” Bighan khavɨusua, mee bar osemigha bar nɨghɨnɨghava avheeŋi. Mauthughura mee Polɨn akuava, ukuran maŋŋamɨusua zui. ");
INSERT INTO spm_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ee mee thaegha ukur nigha Kosɨn mɨghsɨmamɨ usuavɨra zii. Amɨrɨtusi rɨmaaŋra ee Rodesɨn mɨghɨsɨman ze. Ee Rodesɨn mɨghsɨma thaegha Pataranɨ uŋuun ze. ");
INSERT INTO spm_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ee Pataranɨnɨ uŋuunɨ ukuran mavo otosima, a Fonisian distrighɨn zima, ee aŋn bɨnigha zii. ");
INSERT INTO spm_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ee Saiprusɨn mɨghsɨman gara, agharan guvɨna amandaghava aŋgi indɨragha, Sirian distrighɨn zii. Ee Tairɨnɨ uŋuuna aghegha ukuran iti bisi anamogha anda rarɨghousua. ");
INSERT INTO spm_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ee anamogh Kraisɨna andarsivɨusua gara gua men ganighava 7 pɨlanɨ uthusir mena aghani ikhee. Uthughun khavɨn Gotɨnɨ Utum mem mbɨkemisima mee Polɨ mbɨŋgɨ kamaghɨusue, “Nɨɨ Jerusalemɨnɨ uŋuun maŋŋa thaghɨri.” ");
INSERT INTO spm_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mauthughura ukur Tairɨnɨ uŋuua thamraghaousava amuima, Kraisɨna andarsi nona amuuir rako boorir akua en gɨnɨ uŋuuni ikhɨvana akɨran guava oŋarana ataaŋn ee bar ithevia rɨphɨrigha Gotɨn phorugham mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ee men phorugha ivhɨra nona agharirɨ usuigha gɨvagha, ee ukur nigha zuima mee nomthegha nor rɨphenir zii. ");
INSERT INTO spm_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Uthughun khavɨn ee Tairɨnɨ uŋuua thaegha Tolemesɨnɨ uŋuuno othuivigha, uthughun aghuuŋ Kraisɨna andarsigha aniiŋgava ee men phorugha uthughunɨ uvhuavɨre men phougha ikhee. ");
INSERT INTO spm_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Amɨrɨtusi rɨmaaŋra ee mea thaegha Sisarianɨ uŋuuno othuivigha Filivɨ rɨphenan iti. A Ikhɨvana akamana aghuuŋ ukurir gumaghan mav. Filiv a 7 pɨlan gumasir thooŋn gumaghan mav Iesusɨm mbɨsevisi gumasir akuruvasir gumagh. ");
INSERT INTO spm_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A guivani ikaman phunini ko phunini iti, mee Gotɨna ambuuŋna amisir marsir mɨna akamɨ ukuri. ");
INSERT INTO spm_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ee nom uthusir marsi Sisarianɨ uŋuuni itima, Gotɨna ambuuŋn gumaghan mav, Agabus, a Judian distrighɨni ikhegha Sisarianɨ uŋuun zeghirɨ. ");
INSERT INTO spm_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","A ena aghan zaava Pol noni ivha dira arɨkhavan nona afharimuuni koma suani ikhegha kamaghɨm mbɨŋgeeghi, “Gotɨnɨ Utum kamaghɨm mbɨŋgeeghi, ‘Kamaghɨra Judarir akhoghɨn gumasir marsi Jerusalemɨnɨ uŋuuni ikava, arɨkhavan khavɨn guav ikeghɨva ana nigh muu igharisirɨ unuaghɨnan gumasira anɨɨŋga.’ ” ");
INSERT INTO spm_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Pol kamaghɨm mbɨkemisima, ee koma Sisarianɨ uŋuun gumasi rako amisi Jerusalemɨn maŋŋan Polɨn thɨvava aŋga aghori. ");
INSERT INTO spm_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mem mbɨkemisima Pol mee ikaragha kamaghɨm mbɨŋgeeghi, “Gee thoghousua aziava nan nava amuima a magharɨsi? Mee na ikeghemi, anaaŋ indera. Khɨɨ Iesusɨn izɨɨn Jerusalemɨna avhen aremighemi, anaaŋ ivhɨra indera.” ");
INSERT INTO spm_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pol bar athuesima ee ana athaegha kamaghɨm mbɨŋgeeghi, “Got bigha thavɨn nɨra amuamɨusua ramutima anaaŋ mara nɨmba othuiv.” ");
INSERT INTO spm_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","16","Uthusir marsir gɨn ee bisiar rɨkɨrigha gɨvagha Jerusalemɨn uŋuun guavanambosima Sisarianɨ uŋuuni itir Kraisɨn suren gumasi rako amisi, mena marsi ena akua gua Nasonɨ rɨphenan ee athɨsima ee anamoghi iti. A Saiprusɨn mɨghsɨman gumagh. A barɨ ufhuaraghavɨran Kraisɨn suren gumaghan mav. ");
INSERT INTO spm_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ee gua Jerusalemɨno othuivisima Kraisɨna andarsi emɨusua bari inighinisi. ");
INSERT INTO spm_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Amɨrɨtusi rɨmaaŋra, Pol ena marsir phorugha Jemsɨn ganamɨusua zui. Kha uthughun Kraisɨna andarsir gumasira aphani bar ivhɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Polɨ uthughun aghuuŋ meŋga aniiŋga, kamaghɨusue, “Ikhɨv bisira avhɨrara igharisirɨ unuaghɨnan gumasi rako amisira arɨghan naŋga amuisima, khɨɨ andar gun gem mbɨngeeghi.” ");
INSERT INTO spm_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kraisɨn phoesi tharsi, men gumasira aphani kamagh oraegha Gotɨn izɨɨ ufhii. Mee Polɨm mbɨŋgɨ kamaghɨusue, “Ena avheeŋmphom, nɨɨ ikaaŋi Judarir akhoghɨn gumasi rako amisir avhɨrara nɨghɨnɨghana aghavaghar Iesusɨn iti. Mee Moses osɨrisir othevivɨusuava bar aghavaghari. ");
INSERT INTO spm_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Gumasir marsi akaman nɨɨŋga asava nɨɨn gɨna amaaŋga nɨɨm mbɨŋgɨ kamaghɨusue, nɨɨ igharisirɨ unuaghɨnan gumasir thooŋn itir Judarir akhoghɨn gumasi marsi vɨŋgɨva Moses osɨrisir othevir gɨn maŋŋan men thevi. Nɨɨ kamaghɨusue, ‘Gen non boorir momooŋn niro ofhɨsia rɨghora thaghɨri, Judarii ee nono othevi ramua thaghɨri.’ ");
INSERT INTO spm_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ee ikaaŋi, mee nɨɨ zesira akamam mba oraegha gɨva. Ee nomthegh manmaghɨra ramuti? ");
INSERT INTO spm_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","24","Ee nɨɨ ramuaŋgamiro othɨva thavɨn gun nɨm mbɨkemightima nɨɨ anaaŋ ramuri. Nɨɨ kamagh ramuightima, gumasi rako amisi ganigh ikeeŋgɨm mbɨkɨmaaŋga. Mee aŋga asira akaar kharsi anda guisimbaaŋran akaa phatɨ. En phorugha khagh iti gumaghan phunini ko phunini Gotɨn phorugha akama rɨŋgɨrana aghavagharan mavɨ amui. Nɨɨ mee nigh maŋŋɨva gee Gotɨna arɨmasi rɨfhaaŋnɨ uzueghousua othɨvhan khavɨ ramuri. Nɨɨ aphurapuramir aghee rako bisighɨ uvhuesightima, mee nona aphaniraarɨsighi isaami. Judarir akoghɨn gumasi kamagh ikaaŋi nɨɨ ivhɨra Moses osɨrisiro othevir gɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Uthughun khavɨn igharisirɨ unuaghɨnan gumasi marsi ivhɨra Iesusɨn gɨn zui, ee non nɨghɨnɨghanɨ mbɨgharan mav osɨrigha memɨusua fhomɨrama ane amanda. Ee mbɨŋgɨ kamaghɨusue, ‘Gee mee marvir guagha anɨndir aghaer rama thaghɨri. Gee ivhɨra ŋae itira asɨsi rako asɨsi mee ufhuri rafhava mbɨsosi tharsi rama thaghɨri, nori niava akuira othevir maghatɨsir ramua thaghɨri.’ ” ");
INSERT INTO spm_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kamagha amuisima Pol thaegha gua gumasir kharsi nighava, amɨrɨtusi rɨmaaŋra a men phorugha gua mee norira Gotɨna arɨmasi rɨfhaaŋnɨ uzueghousua othevir khasigha amui. A gɨn gua Gotɨ rɨphenam mbɨroghɨn gugha Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasi vɨŋgɨ kamaghɨusue, “Ee Gotɨna arɨmasi rɨfhaaŋnɨ uzueghemirɨ orɨrɨvhanɨ uthugha gɨvousua ramutima, mee emɨusua uvhuaghɨuvhuaghɨva aphuraphurir othevira ramuaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Uthusir 7 pɨla gɨvousuava amuima Judarir akhoghɨn gumasi Esian distrighɨn iti tharsi Gotɨn rɨphenam mbɨroghɨn Polɨn gani. Mee gumasi rako amisir navighi inivima mee Polɨnɨ usuiragha kamagh dɨɨ mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Israeliiŋn akhoghɨn gumasi, gee ena akura! Gumaghan khav, en gumasi rako amisira rafaravaghava, igharis gumasir rako uŋuimbar igharis tharsi bar men surea amui. A Moses osɨrisir othevi ko Gotɨ rɨphenaŋga asɨghasɨghousua mbɨŋgeeghi. A ivhɨra Grighiiŋna akamaŋga aghuuir gumasir marsi nigha, Gotɨ rɨphenam mbɨroghɨ athɨgha zui. Ma gumagh Got nombɨusua mbɨsevir rɨphenam mbɨroghɨn zɨɨva aŋra amuightima a Gotɨna arɨmasi rɨfhaaŋn maghatiighemi.” ");
INSERT INTO spm_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Mee ufhuaragha Efesusɨnɨ uŋuun gumaghan mav, Trofimusɨn garima, a Polɨn phoruhga Jerusalemɨnɨ uŋuuni ikhɨvana avhena arui. Mee kamagh nɨghɨnɨsi, Pol ana nigha Gotɨn rɨphenam mbɨroghɨn gu.) ");
INSERT INTO spm_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mee Jerusalemɨnɨ uŋuuni ikhɨvan iti gumasi rako amisi bar men navighi ninivima, mee atamatamɨra akhɨrɨsiigha zii. Mee Gotɨ rɨphena mbɨroghɨn Polɨnɨ usuiragha ana ukurugha zui. Mee uvhuarira Gotɨ rɨphena mbɨroghɨn iti rɨvɨnan ithɨman ikhɨva aphui. ");
INSERT INTO spm_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Mauthughura Judarir akhoghɨn gumasi rako amisi arɨmamɨusuavɨra amuirɨm mbɨzorughan Polɨa amuima Romiiŋ mbɨzorsir gumasi bar men gumaghan aphan oraghi. Uthughun khavɨnɨ mbɨŋgɨŋgɨm gua kamagh aŋm mbato, Jerusalemɨn gumasi rako amisi nori vɨsosi. ");
INSERT INTO spm_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mauthughura a uzuamɨra mbɨzorsir gumasir garir gumasi rako mbɨzorsir gumasir marsi nigha, mee akhɨrɨsiigha gua gumasi rako amisira avhɨrara itira aŋanan zui. Mauthughura Polɨ mbɨsuesi gumasi, mee mbɨzorughan gumaghan ikhɨv koma aŋm mbɨzorsir gumasir ganigha Pola thaghi. ");
INSERT INTO spm_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mauthughura mbɨzorsir gumasi bar men gumaghan aphan zaa Polɨnɨ usuiragha mem mbɨŋgeema, mee ukuaghavan phuninina ana ikhee. A Judarir akoghɨn gumasir azaaghi, “Khara thɨɨŋra, a theeghɨnaŋga amui?” ");
INSERT INTO spm_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Maghɨra avhɨran ikhɨvan khavɨn avhen iti tharsi mee phura atamatamɨra bisi vɨŋgeeghi. Mee nɨŋnɨɨŋn maghatɨgha amuima, mbɨzorsir gumasi bar men gumaghan aphan inderaghɨvɨra bigha thav ikeeŋsi phatɨ. Kamagha amuigha a nom mbɨzorsir gumasi vɨkemisima, mee ana nigha nori no rɨphenan zui. ");
INSERT INTO spm_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pol rɨphenan khavɨna andɨrɨghana othuivousuava amuima mee aŋm mbɨsoghousua bar khaghɨra ana rɨsi. Uthughun khavɨn mbɨzorsir gumasi aŋgi isaghuphɨgha zui. ");
INSERT INTO spm_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Gumasi rako amisira avhɨra men gɨn zui tharsir men dɨɨ kamaghɨm mbɨŋgeeghi, “Aŋm mbɨsueghti, ana aremighɨri!” ");
INSERT INTO spm_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mee Pol nigha mbɨzorsir gumasir iti rɨphenana avhen maŋŋamɨusuava amuima, a men gumaghan ikhɨv Grighiiŋna akaman aŋna azaaghi, “Khɨɨ bigha thavɨn nɨɨm mbɨkɨmaŋgami, o?” Mauthughura mbɨzorusi gumasi bar men gumaghana aphan aŋna azaaghi, “Nɨɨ Grighiiŋna akamam mbɨŋgeeghi? ");
INSERT INTO spm_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Khɨɨ kamaghɨusue, nɨɨ Isiviiŋnɨ unuaghɨnan gumagh. Isiviiŋn gumaghan mav, a fhomɨra gavmanɨn phorugha mbɨsogha, 4,000ɨn gumasi maghatɨsi nigha gua gumasi iti phatɨsira aŋanan gu. Nɨɨ ma gumaghara ti?” ");
INSERT INTO spm_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ana aŋm mbɨkemisima, Pol kamaghɨm mbɨŋgeeghi, “Phatɨ. Khɨɨ Judarir akhoghɨn gumagh, khɨɨ Silisian distrighɨna avhen itirɨ uŋuun Tarsusɨn gumagh. Khɨɨ izɨɨ itirɨ uŋuun ikhɨvan gumagh. Khɨɨ nɨɨm mbɨŋgeeghi, nɨɨ nam mbɨnamɨnaaŋ ratɨghtima, khɨɨ akama thavɨn gumasi rako amisi vɨkɨmamɨusua.” ");
INSERT INTO spm_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Aŋm mbɨŋgeema mbɨzorusir gumasi bar men gumaghana aphan aŋm mbɨkemisi, Pol andɨrɨghanɨ utugha non afharara gumasi rako amisi rɨkagharɨsi. Mee barbar inɨmɨre iti. Mauthughura a Hibruiiŋna akaman mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol kamaghɨusue, “Nana andarsi rako nani inasi, gee oragh. Khɨɨ thighira inderaghavɨra gen niaghaami. Khɨɨ osɨmndɨgha thavɨ amuisi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Mee aŋm mbarasima, a Hibruna akaman mem mbɨŋgeema, mee bar inɨmɨre iti. Pol kamaghɨm mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Khɨɨ Judarir akhoghɨn gumaghan mav, nani inaghamuuŋ Tarsusɨnɨ uŋuun nam mbate, a Silisian distrighɨn iti uŋuu. Gumughun khɨɨ Jerusalemɨn uŋuun ikhava aghuuŋi. Khɨɨ Gamalielɨn afharimuunɨ itima a Judarir othevir nan surea amuisima, khɨɨ bar inderaghɨvɨrama anda ikaaŋi. Gee thighira Gotɨn gɨn maŋŋamɨusua bar aghavagharisi moghɨra, khɨɨ ivhɨra mamaghɨra. ");
INSERT INTO spm_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Khɨɨ fhomɨra Kraisɨna andarsira fharavagha mem mbɨsosima mee arɨghiri. Gumasi rako amisi barbar menɨ usuighava ukuaghaviir mee ikava mee niava rɨvɨnan kɨrthɨghana avhen mee arɨsi. ");
INSERT INTO spm_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii rako Judariro osɨmndɨsiva oraghava anda rɨkɨri rɨphenira avherir iti gumasi bar nano othevi ikaaŋi, gee mena azaaŋtima, mee andar gun gem mbɨkɨmaŋga. Mee Damaskusɨni iti Judarira akhoghɨn marsivɨusuava osɨrisirɨ mbɨgharir marsir naŋga anɨɨŋisima khɨɨ utuavɨn gua non nɨghɨnɨghan kamaghɨusue, ‘Khɨɨ thighira maŋɨva Kraisɨna andarsi nighɨva rɨvɨnan kɨrthɨghan garir gumaghan mɨn mee nighɨva Jerusalemɨn zɨva, mbɨzasir mee ranɨɨŋgami.’ Kamagha amuigha khɨɨ bighan khavɨusua Damaskusɨnɨ uŋuun zui.” ");
INSERT INTO spm_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Mauthughura Pol mbɨŋgɨ guava kamagh mem mbɨŋgeeghi, “Khɨɨ arona ararɨghan Damaskusɨnɨ uŋuum mbɨroghɨn zuima, aŋaran gamgaaŋ mav Gotɨnɨ uŋuuni ikhegha bar naŋgi isira. ");
INSERT INTO spm_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Khɨɨ unuaghɨnaŋgi irɨghava orasima, itɨɨŋn mav nam mbɨŋgeeghi, ‘Sol! Sol! Nɨɨ manmaghɨusuavɨra nara afharavasi?’ ");
INSERT INTO spm_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mauthughura khɨɨ aŋna azara, ‘Ikhɨv, nɨɨ thɨɨŋra?’ Mauthughura ma ithɨɨŋ kamaghɨusue, ‘Khɨɨ Nasaretiiŋn gumagh Iesus, nɨɨ nara afharavasi.’ ");
INSERT INTO spm_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Uthughun khavɨn nan phorugha zui tharsi, mee aŋaran khavɨn ganigha, mbɨŋgɨŋgɨɨva oraghava, inderagha kamagh ikeeŋsi phatɨ, thɨɨŋra em mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mauthughura kha aŋna azaaghi, ‘Ikhɨv, khɨɨ manmaghɨra ramuti?’ Ikhɨv nam mbɨŋgeeghi, ‘Nɨɨ rɨkavighɨva Damaskusɨnɨ uŋuum maaŋɨ. Gumagha thav gumughun munagh, khɨɨ nɨɨmɨusua mbɨsevisiri iŋaari bara, andar gun nɨɨm mbɨkɨmaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Maghɨra aŋaran khav nana arɨmaghaniiŋ mbɨghɨravɨrama aniiŋgi isirasima, khɨɨ gari phatɨ. Kamagha amuisima nan phorugha iti tharsi mee nona afharir nan usuiragha na nigha Damaskusɨn gu. ");
INSERT INTO spm_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Gumughun gumaghan mav, aŋni izɨɨ Ananaias, a Gotɨn apheeŋn ikava, Moses osɨrisir othevi bar inderaghavɨra andar gɨn zui. Damaskusɨn iti Judariiŋna akhoghɨn guamasi rako amisi kamaghɨusue, ‘A gumaghan aghuuŋ.’ ");
INSERT INTO spm_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","A zaa nan gani. A nana aghanɨ utugha, nam mbɨŋgeeghi, ‘Nana avheeŋphom, Sol, nɨɨna arɨmaghaniiŋ nomthegha inderaghɨri.’ Mauthughura, khɨɨ maghɨra Ananasɨn garima, ");
INSERT INTO spm_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","a nam mbɨŋgeeghi, ‘Ena avhavir Got non vhusvhus ikaaŋmɨusua nɨa mbɨsevi. Nɨɨ othevira Aghuigha Amui Gumagh, aŋni izɨɨn mav Iesus nɨɨ aŋn ganɨva, ana akamdooŋnin othuivi vɨŋgɨmɨŋgɨvo oraghaousua Got nɨɨa mbɨsevi. ");
INSERT INTO spm_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mamagha amuigha nɨɨ aŋna akamɨ ukunɨva, nɨɨ ganighava oraesi bisir gun gumasi rako amisi bar andar gun mem mbɨkɨmri. ");
INSERT INTO spm_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Thighira nɨɨ theeghɨnamɨusua gara iti? Nɨɨ rɨkavighɨva Iesusɨn izɨɨ rɨmboruaghtima khɨɨ nɨɨ urueghtima Got nɨɨno othevir maghatɨsi amosighemi.’ ” ");
INSERT INTO spm_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Mauthughura Pol mbɨŋgɨ guava kamaghɨusue, “Khɨɨ gumughun nomthegha Jerusalemɨn zeghava, khɨɨ Gotɨ rɨphenam mbɨroghɨn gugha Gotɨn phorugha mbɨŋgɨvi khava irɨmɨn mɨn bighan mavɨn gani. ");
INSERT INTO spm_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Khɨɨ Ikhɨvan garima a nam mbɨŋgeeghi, ‘Nɨɨ uzuamɨra rɨkavighɨva Jerusalema thaegh maaŋɨ. Nɨɨ khagh nana akamɨ ukuntɨma, mee aŋm mbaraeghem phatɨghami.’ ");
INSERT INTO spm_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Kha ana ikara, ‘Ikhɨv, gumasi kharsi ikaaŋi, khɨɨ Gotɨn phorugha mbɨŋgeer rɨphenigha arua gumasi rako amisi nɨghɨnɨsira aghavaghari nɨɨn iti tharsirɨ usuigha mee rɨvɨnan khɨrthɨgha arɨgha, mee mbɨsosi. ");
INSERT INTO spm_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Uthughun mavɨn nɨɨn akamɨ ukurir gumaghan khav Stiven, mee aŋm mbɨsuesima aŋna aremi. Khɨɨ aŋna aghanɨ utughav ikava, nan arɨmaghaniiŋ othɨvhan khavɨn garima a indera. Mee Stivenɨ mbɨsuesima ana aremisi tharsir, khɨɨ men shaarirɨghi ighuvaghavi iti.’ ");
INSERT INTO spm_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mauthughura Ikhɨv nam mbɨŋgeeghi, ‘Nɨɨ maaŋɨ. Khɨɨ igharisirɨ unuaghɨnan iti gumasi rako amisivɨusua, nɨɨa amandi.’ ” ");
INSERT INTO spm_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ma uthughun Judarii orasima Polɨ mbɨŋgeema, mee aŋm mbɨzeva oraghan iphɨrphɨri. Maghamuigha mee ithɨɨria akarava aŋgaravasi, “Aŋm mbɨsueghtima ana aremi. Kamagha amuisi gumagha thavɨ unuaghɨnan ikeghem thughastɨs phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Mee atamatamɨra ithɨria akarava non sharirɨ uruari atamatamɨra mara anda usuava unuaghɨnɨ uroghova iphɨɨsuava, nori Polɨna akaman khavɨ oraghan bar iphɨrɨphɨgha kamagha amui. ");
INSERT INTO spm_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Maghɨra Romiiŋ mbɨzorusir gumasi bar men gumaghana aphan, nom mbɨzorsir gumasi vɨŋgeema, mee Polɨm mbɨsoghɨva ana azasɨghousuava, ana nigha mee nori itirɨ rɨphenan gu. A kamagh inderagh ikaaŋmɨusua, manmaghɨra amuisima mee Pol kamagh ana aŋgaravasi. Kamagha amuisi a bighan khav ikaaŋmɨusua, nom mbɨzorsir gumasi vɨkemi, “Gee aŋne fhasoroghɨva aŋna azaaŋsɨgh.” ");
INSERT INTO spm_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mee Pola fhasoroghousuava aŋna agharaniiŋ koma usuaniiŋ ikhee. Pol garima mbɨzorsir gumaghana aphan aŋna aghan utughavɨtima Pol kamagh aŋna azara, “Romiiŋn gavmano osɨrisir othɨva thav Romiiŋn unuaghɨnan gumagha thav ramuamɨusua gee mbɨnambasi, o phatɨ? Khɨɨ Romiiŋn gumagh. Gee nana osɨmndɨsiva oraghava anda rɨkɨrir rɨphenaŋga athɨsi phatɨgha na fhasoroghousuava amui.” ");
INSERT INTO spm_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Uthughun khavɨn mbɨzorsir gumasir garir gumaghan aphan kamagh oraeghava, Romiiŋ mbɨzorusir gumasi bar men gumaghana aphanamɨusua gua aŋm mbɨŋgeeghi, “Nɨɨ manmagh ramuti? Khara Romiiŋn gumaghra.” ");
INSERT INTO spm_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Maghɨra mbɨzorusir gumasi bar men gumaghana aphan Polɨusua gua aŋna azaaghi, “Nɨɨ nam mbɨkɨm, nɨɨ Romiiŋn gumaghara?” Ana aŋm mbɨkemisima Pol ana ikaragha kamaghɨusue, “Aŋre, kɨra.” ");
INSERT INTO spm_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mauthughura mbɨzorusir gumasi bar men gumaghana aphan kamaghɨm mbɨŋgeeghi, “Khɨɨ nona aŋgɨro ovhɨsirɨ uvhuesan ikhɨv amuigha, thighira khɨɨ Romiiŋn gumaghara.” Mauthughura Pol kamaghɨm mbɨŋgeeghi, “Nani inaghaves, a Romiiŋn gumagh, kamagha amuisima khɨɨ Romiiŋn gumagh.” ");
INSERT INTO spm_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Mauthughura aŋna azaaŋsɨghousuava amui gumasi mee kamagh oraeghava, uzuamɨra norighe ekuigha isaghunɨ utuivighav iti. Mauthughura ukuaghaviir Pol ikesi mbɨzorsir gumaghan ikhɨv a ikaaŋi, Pol Romiiŋn gumaghara. Kamagha amuisima a ivhɨrama avhighevighi. ");
INSERT INTO spm_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Amɨrɨtusi rɨmaaŋra mbɨzorusir gumasi bar men gumaghana aphan bar inderaghɨvɨre ikaaŋmɨusua, Pol manmaghɨrama amuisiro othɨvha amuisima, Judarii aŋm mbɨŋgeeghi. A Pola fhɨrigha, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii rako, Judariro osɨmndɨsiva oraghava anda rɨkɨrir gumasi bar men dɨɨsima, mee zaa nori akuvagha itima, a Pol nigha gua mena arɨmasi rɨfhaaŋn anara fhasima a utughav iti. ");
INSERT INTO spm_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol rɨkɨrava Judariro osɨmndɨsiva oraghava anda rɨkɨrir gumasir garava kamagh mem mbɨŋgeeghi, “Nana andarsi, nana avhen iti gumagh kamaghɨusue, ‘Khɨɨ Gotɨna arɨmasi rɨfhaaŋn inderaghavɨrama aruava, ivhɨra othevira aghuigha amua zaa thighiraou utu.’ ” ");
INSERT INTO spm_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pol kamaghɨm mbɨkemisima, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨv, Ananaias, Polɨn aghan iti gumasi vɨŋgɨva ana akamndooŋnim mbɨsoghousua mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mauthughura Pol kamagh aŋm mbɨŋgeeghi, “Got ivhɨra nɨɨ mbɨsueghemi! Nɨɨ, uphughuphurisi rɨvɨnan mɨna amuisima mee akɨran rɨmɨnɨ ughuran nɨɨa aghevi. Mee avhen aŋn maghatɨgha thavɨn ganighem thughatɨs phatɨ. Nɨɨ maghɨra rapheraghav ikɨva Moses osɨrisir othevir iphɨnɨ uthugha nano osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan nam mbɨsoghousuava mem mbɨŋgeeghi. Nɨɨ Moses osɨrir othevigha afhimɨsɨsi.” ");
INSERT INTO spm_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mauthughura Polɨn aghanɨ utuivighav iti gumasi kamaghɨm mbɨŋgeeghi, “Nɨɨ Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨv akaman maghatɨgha thavɨn aŋm mbɨkɨma thaghɨri.” ");
INSERT INTO spm_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Mauthughura Pol kamaghɨm mbɨŋgeeghi, “Nana andarsi, khɨɨ kamagh ikeeŋsi phatɨ, a Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨv. Gotɨm mbɨgharano osɨɨr kamagh iti, ‘Akaar maghatɨsir gee norir garir gumasir ikii vɨkɨma thaghɨri.’ ” ");
INSERT INTO spm_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","8","Pol ikaaŋi igharis Sadiusiiŋn akoghɨn gumasir marsi rako Farisiiŋn akoghɨn gumasir marsi ivhɨriirɨ usuisira aŋanan iti. Sadiusiiŋn gumasi kamaghɨusue, “Aremisi gumasi rako amisi mee nomthegh rɨkavhighem phatɨghami.” Mee ivhɨra kamaghɨusue, “Enseli rako unduu iti phatɨ.” Farisiiŋn akoghɨn gumasi kamaghɨusue, “Phatɨ, ovheeŋga guesi tharsi nomthegh rɨkavhami.” Mee ivhɨra kamaghɨusue, “Enseli rako unduu iti.” Kamagha amuisima a Judariro osɨmndɨsiva oragha anda rɨkɨrir rɨphenana avhen iti gumasir dɨɨgha kamaghɨm mee mbɨŋgeeghi, “Nana andarsi, khɨɨ Farisiiŋna akoghɨn gumaghan mav, nani inaghaves a Farisiiŋn akoghɨn gumagh maghɨ. Nani nɨghɨnɨghana aghavaghar kamagh iti, ovheeŋsi tharsi nomthegh rɨkavami. Mee bighan khavɨusua na nigha osɨmndɨsiva oragha anda rɨkɨrir rɨphenaŋga athɨ.” Uthughun khavɨn Polɨm mbɨŋgɨŋgɨm meŋga amuisima Farisiiŋn gumasi rako Sadiusiiŋn gumasi mee noria biighava, nori vatosi. ");
INSERT INTO spm_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kamagha amuisima athoroghan ikhɨvo otosi, Farisiiŋna marsi Judariro othevi ikeeŋsi gumasi uthuivighava ambuura, mbɨŋgɨ kamaghɨusue, “Gumaghan khav osɨmndɨsi aŋn phatɨ. A ti guisimbaaŋram mbɨŋgɨmati, ensel thav o utuma thav aŋm mbɨkemighamati.” ");
INSERT INTO spm_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Meno othorugh bara aghavagharigha mbɨzorugho otosima mbɨzorusir gumasi bar men gumaghana aphan avhighevhiigha, Judarii Polɨm mbɨsoghɨva aŋgi ikutima, a bɨɨghireghemi. Kamagha amuisima a nom mbɨzorsir gumasi vɨkemisima mee gueghira anɨ usuiraghava ana nigha mbɨzorsir gumasi rɨphenan gu. ");
INSERT INTO spm_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ikhɨv rɨmaaŋn aŋmba athogha kamaghɨusue, “Nɨɨ avhighavhigha thaghɨri! Nɨɨ Jerusalemɨn nan gunɨm mbɨkemisi moghɨra nɨɨ thighira maaŋɨ nan gun Romɨnɨ uŋuun iti gumasi vɨkɨm.” ");
INSERT INTO spm_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Arama amɨrɨtusir rɨmaaŋra Judarir akoghɨn gumasir marsi nori akuvagha Polɨm mbɨsueghtima ana aremighaousuava Gotɨn phorughava akama rɨŋgɨran mavɨ amui. Mee kamagh akama rɨkɨri, “Ee aghaa thav o rɨmɨ rameghem phatɨgh, ikɨɨ maaŋɨ mee Polɨ mbɨsueghtima aŋna aremighemi.” ");
INSERT INTO spm_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Akama rɨkɨrisi gumasir kharsi rɨmbomboni gua 40 afhira. ");
INSERT INTO spm_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mee Judarir akoghɨn gumasira aphani rako Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasir ikiivɨusua gua kamagh mem mbɨŋgeeghi, “Ena akama rɨŋgɨran khav kamaghɨusue, ‘Ee Polɨm mbɨsueghti ana aremightima, ee gɨn aghaa thava ramaŋga.’ ");
INSERT INTO spm_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kamaghɨnɨ geegha osɨmndɨsiva orasi gumasigha, gee akaman mu mbɨzorsir gumaghan ikhɨvaaghava amandaghtima, a Polɨna akuva gena aghan zɨɨri. Gee aŋn khorira amuighɨva ana aku zɨɨ. Ee bisia rɨkɨrighɨva aŋmɨusua gan ikaami. A zɨɨ emba othuivamirɨ uthughura ee aŋm mbɨsueghtima ana aremighemi.” ");
INSERT INTO spm_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mem mbɨŋgeema Polɨn amighan otar oraegha gua mbɨzorsir gumasir rɨphenan Pol mbɨkemi. ");
INSERT INTO spm_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Mauthughura Pol Romiiŋn mbɨzorsir gumaghan aphanan dɨɨgha kamaghɨusue, “Otaran ikaman khav nigh mbɨzorusir gumasi bar men gumaghana aphananamɨusua maaŋɨ. A bigha thavɨm mbɨkɨmamɨusua.” ");
INSERT INTO spm_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mauthughura 100 pɨlanɨ mbɨzorsir gumasir gari gumagh a Polɨn amighan otar nigha mbɨzorusi gumasi bar men gumaghana aphanamɨusua zui. 100 pɨlanɨ mbɨzorsir gumasir gari gumagh kamaghɨusue, “Pol rɨvɨnan kɨrthɨghan ikava nan dɨɨgha ma otarana aku nɨɨna aghan zaaousua nam mbɨkemi. A nɨɨm mbɨkɨmaŋgamira akaman mav iti.” ");
INSERT INTO spm_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mauthughura mbɨzorusir gumasi bar men gumaghana aphan otaran afharɨnɨ usuiragha aniiŋ mbɨŋɨniiŋn gugha maghɨrama aŋna azaaghi, “Nɨɨ theeghɨnan nam mbɨkɨmamɨusua?” ");
INSERT INTO spm_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Otaran ikaam kamaghɨusue, “Judarii Polɨm mbɨsueghtima ana aremighaousuava akama rɨkɨrigha gurum rɨmaaŋra Polɨna aku zaaousua nɨɨmɨusua gɨɨa amui. Mee khoru amua kamaghɨusue, a maŋŋɨtima Judariro osɨmndɨsiva oragha anda rɨkɨrir rɨphenan inderaghavɨra aŋm mbɨŋgɨmɨŋgɨ niaŋga. ");
INSERT INTO spm_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Gumasir rɨmbomboni 40 afira, mee an aravava aŋmɨusua mooŋi. Kamagha amuisi nɨɨ mem mbaraghan thaghɨri. Mee aghaa thav ko rɨmɨ rameghem phatɨgh maaŋɨ Polɨ mbɨsueghti ana aremigh gɨvaghtima mee aghaa ramamɨusuava akama rɨŋgɨran mavɨ amui. Mee thighira nɨɨna akaman iŋgarɨghaousua gara iti.” ");
INSERT INTO spm_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mbɨzorusi gumasi bar men gumaghana aphan ana amandagha akamana aghavagharan kamagh aŋm mbɨŋgeeghi, “Nɨɨ nam mbɨkemisi bighan khavɨn gun thavɨm mbɨkɨman bar thaeghri.” ");
INSERT INTO spm_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mmbɨzorusi gumasi bar men gumaghana aphan, non mbɨzorsi gumasi 100 pɨlan gari gumaghan phuninin dɨɨgha kamagh aniiŋm mbɨŋgeeghi. “Aŋgo 200 pɨla mbɨzorusir gumasi rako 70 pɨlan hosir gumasi rako 200 pɨlan afhusir gumasi akumakumighiri Gee 9 okloghɨn thighira rɨmaaŋn Sisarianɨ uŋuum maaŋɨri. ");
INSERT INTO spm_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Nɨɨ Pol iphɨra aphighemir hosi tharsi ivhɨrama anda nighɨri. A inderaghɨvɨra maaŋɨ gavmanɨn gumaghan ikhɨv Feliksɨa othuivhami.” ");
INSERT INTO spm_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Mbɨzorusi gumasi bar men gumaghana aphan kamaghɨ mbɨghar osɨri. ");
INSERT INTO spm_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Khɨɨ Klodius Lisias. Khɨɨ bar iphɨn iti gavmanɨn gumaghan ikhɨv Feliksɨusua mbɨghar osɨri. Uthughun aghuuŋ, nɨɨ inderaghavɨra ikhɨɨ. ");
INSERT INTO spm_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Judarii gumaghan khavɨ mbɨsueghtima ana aremighaousua aŋnɨ usuira. Khɨɨ kamagh ikaaŋi, a Romiiŋn gumagh, kamagha amuigha khɨɨ nom mbɨzorsir gumasir phorugha guava ana nii. ");
INSERT INTO spm_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Khɨɨ kamagh inderaghɨvɨre khaaŋmɨusua, mee theghɨnan bighaaŋmɨusuava akaman aŋgasi. Kha ana nigha men osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan gu. ");
INSERT INTO spm_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Khɨɨ mena azarisima mee nono othevir marsi vɨŋgɨŋgɨr aŋga amuava phura mbɨzeer marsir aŋgi inivhii. Mee phura bighan khɨna thavɨusua ana nigh rɨvɨran khɨrthɨghara athɨghami o aŋm mbɨusueghtima aŋna aremighem thughatɨsi bar phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Khɨɨ oraeghava ikaaŋi, mee aŋm mbɨsueghtima ana aremighaousuava, moŋgava akaa vɨsosima khɨɨ uzuamɨra kha gumagh nɨɨmɨusuava ana amandi. Akaman aŋga asir gumasi ivhɨra, mee nɨɨna arɨmasi rɨfhaaŋn nom mbɨŋgɨmɨŋgɨra amuamɨusua, khɨɨ mem mbɨkemi. ");
INSERT INTO spm_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mauthughura mbɨzorsir gumasi akamam mbaraegha rɨmaaŋn Polɨn akua gua Antipatrisɨnɨ uŋuuno oto. ");
INSERT INTO spm_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Amɨrɨtusi rɨmaaŋra hosir gumasi aŋn phorugha zuima, igharis mbɨzorsir gumasir marsi nomthegha Jerusalemɨn no rɨphenan gue. ");
INSERT INTO spm_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pol hosir zui gumasir phorugha gua Sisarianɨ uŋuuno otoghava mbɨghar nigha gavmanɨn gumaghan ikhɨva aniiŋgava Pol ivhɨrama aŋga anɨɨŋi. ");
INSERT INTO spm_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gavmanɨn gumaghan ikhɨv mbɨgharan khavɨn ganigha Polɨna azaaghi, “Nɨɨ mana distrighɨn gumagh?” Ana aŋm mbɨkemisima Pol kamaghɨm mbɨŋgeeghi, “Khɨɨ Silisian distrighɨn gumagh.” Gavmanɨn gumaghan ikhɨv kamagh oraegha, ");
INSERT INTO spm_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kamaghɨusue, “Akaman nɨɨŋga asir gumasi mee khagho othuivightima khɨɨ nɨɨno osɨmndɨsiva oraghɨva anda rɨkɨrami.” A Herotɨn rɨphenan ikhɨvan Pola athɨgha inderavɨra aŋn ganamɨusua, mem mbɨkemi. ");
INSERT INTO spm_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Uthusir 5 pɨla gɨvasima, Judarir akhoghɨn gumasi aphanir marsi rako, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikhɨv, Ananaias, koma Romiiŋn gavman osɨrisir othevi ikeeŋsi gumaghan mav, aŋni izɨɨ Tertulus, mee bar Sisarianɨ uŋuun gueghiri. Mee Polɨ asira akaman gun gavmanɨn gumaghan ikhɨvam mbɨkemighava, mee akaman khavɨusua Pol nigh osɨmndɨsiva oraghava anda rɨkɨrir rɨphenara arɨghaousua. ");
INSERT INTO spm_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Gavmanɨn gumaghan ikhɨv Polɨn dɨɨsima ana avhen gusima, Tertulus a Romiiŋn gavmano osɨrisir othevi ikeeŋsi gumahan mav Judarir akoghɨn gumasivɨusua utughava, Feliksɨn arɨmasi rɨfhaaŋn maghɨra akaar Feliksɨ mbɨŋgɨ kamaghɨusue, “Gumaghan ikhɨv Feliks, nɨɨ ena akurasima ee uthughun uruaraaŋra bar inderaghɨvɨre iti. Nɨɨ nɨghɨnɨsira aghuuira ena akuruvaghava en unuaghɨnana avhen iti bisira avhɨrara rɨkɨri. ");
INSERT INTO spm_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ee bisir kharsir garava mɨghasɨgha nɨɨm mbɨnambi. Feliks, nɨɨ bar gumaghan aghuuŋn kɨnara. ");
INSERT INTO spm_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Khɨɨ nɨɨnɨ usuiraghtima nɨɨ uthughunɨ uruaran ikeghem thughatɨs phatɨ, nɨɨ inderaghɨvɨra ena akaman othɨvhanɨ uvhuaaŋra oraghaousuava, khɨɨ nɨɨna azaaghi. ");
INSERT INTO spm_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ee kha gumaghan garima aŋno osɨmndɨsira avhɨrira amui. A Judari itira aŋanir guava mbɨzorsir ikiigha amuima anda othuivi, a Nasaretiiŋn akoghɨn gumasir marsi aphan mav. ");
INSERT INTO spm_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","A ivhɨra Gotɨ rɨphena ramuightima a Gotɨna arɨmasi rifhaaŋnɨ mbɨzegh maghatɨghousuava amui. Ee bighan khuaŋmɨusua, ee aŋnɨ usuira. Kamagha amuisi nɨɨ nombɨ gumaghan khavɨn azaraghɨva, nɨɨ inderaghɨvɨra ee aŋga asira akaa tharsi ikeeŋgemi.” ");
INSERT INTO spm_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Mauthughura Judarii ivhɨra Tertulusɨn akuruvagha akaar Polɨ asava, kamagh aŋm mbɨŋgeeghi, “Bisir kharsi bar guisimbaaŋra.” ");
INSERT INTO spm_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mauthughura gavmanɨn gumaghan ikhɨv mbɨkɨmamɨusua afharvhen aŋga asarasima, Pol kamaghɨ mbɨŋgeeghi, “Khɨɨ ikaaŋi, ombarira avhɨrara nɨɨ gumasi rako amisir kharsiro osɨmndɨsiva oraghava anda rɨkɨrir gumagh. Kamagha amuisima nɨɨ oragh, nan nav nɨɨna akam ikaravaghan bar indera. ");
INSERT INTO spm_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nɨɨ atamatamɨra azaaŋsɨghɨva nɨɨ kamagh ikeeŋgemi khɨɨ Jerusalemɨn gugha Gotɨn izɨɨ ufhua zaa 12 pɨlan uthusir gɨn khɨɨ nɨɨna arɨmasir rɨfhaaŋnɨ utu. ");
INSERT INTO spm_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Judarii Gotɨ rɨphena mbɨroghɨn nan garima khɨɨ akaman gumagha thavɨ mbɨsuesi phatɨ. Mee nan garima, khɨɨ Gotɨn phorugha mbɨŋgeer rɨphenir guva gumasi rako amisir phorugha ivhɨri tharsir usuirasi phatɨ. Khɨɨ ivhɨra Jerusalemɨni itir gumasi rako amisir phorugha bisi tharsigha amuisi bar phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Mee thighira naŋga asira akaa, anda guisimbaaŋrana akaa phatɨ. Mee nɨɨ mbɨkɨmaŋgamira akaa anda vɨnɨɨŋ thav iti phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Khɨɨ guisimbaaŋram mbɨŋgeeghi, khɨɨ ee nona avhavir gɨn gua Gotɨni izɨɨ ufhii. Izɨɨn khav ‘Kraisɨna andarsi’ Judarii mee kamaghɨusue, ‘Khorigha amui tharsi.’ Khɨɨ bar nɨghɨnɨghana aghavaghar Moseso osɨrisir othevir ikava, Gotɨna ambuuŋn gumasi osɨrisir akaar iti. ");
INSERT INTO spm_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Khɨɨ nɨghɨnɨghana aghavaghar Gotɨn ikava kamagh ikaaŋi, arɨɨghiresi gumasi tharsi a nomthegh mee ramutima mee rɨkavhami. Gumasira aghui rako maghatɨsi ivhɨra rɨkavhami. A ramuaŋgamir bighaaŋ, khɨɨ aŋmɨusua gari. Akaman naŋga asir gumasi ivhɨra bighan khavɨusua gara iti. ");
INSERT INTO spm_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kamagha amuisima nana avhen iti gumagh kamaghɨusue, ‘Khɨɨ mɨghasɨgha, Gotɨna arɨmasi rɨfhaaŋ koma gumasira arɨmsi rɨfhaaŋn ivhɨra, othɨvhana aghuuŋn gɨn maŋŋamɨusua, mamagha amuigha khɨɨ inderaghavɨri iŋaari.’ ");
INSERT INTO spm_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Khɨɨ ombaarir marsirɨ uŋuimbar igharis tharsi ikhegha, nomthegha Jerusalemɨn ze. Khɨɨ Gotɨ anɨndi bisi rako Judarir gumasir rako amisira asasira akuruvaghamira aŋgɨro ovhɨsi, anda nigha ze. ");
INSERT INTO spm_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Khɨɨ Gotɨ rɨphenan maŋŋamɨusua, mamagha amuigha khɨɨ Gotɨna arɨmasi rɨfhaaŋnɨ uzueghemiro othɨva amuigha gɨvagha khɨɨ gu. Mee nan garima khɨɨ Gotɨ rɨphenam mbɨroghɨn ikava uzuegha gɨva. Gumasira avhɨrara nan phorugha iti phatɨghava, nɨnɨiira avhɨrara ivhɨra phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Mauthughura Judarir akhoghɨn gumasi marsi Esian distrighɨni iti tharsi, mee Jerusalemɨn zegha nanɨ usuirasi tharsi, mee osɨmndɨgha thav nani ikhɨvɨre ikhɨva, mee norira khagh zɨva, nɨɨna arɨmasi rɨfhaaŋn nana osɨmndɨsiva oraeghɨva anda rɨkɨrami. ");
INSERT INTO spm_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Uthughun kavɨn Judarii nano osɨmndɨsiva oraegha gɨva. Nɨɨ mena zaaraghtima mee kha amuisiro othɨvhan maghatɨgha thavɨn ganighɨva nori nɨɨm mbɨkɨmaŋga. ");
INSERT INTO spm_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Khɨɨ ti men thooŋn utughav ikha dɨɨgha mbɨkemisi mee anaaŋn vhusvhuiisi phatɨ. Akaman khav, ‘Aremisi gumasi tharsi nomthegh rɨkavighemi, bighan khuaŋmɨusuavɨra mee ti na nigha geno osɨmndɨsiva oraghava anda rɨkɨrir rɨphenan ze.’ ” ");
INSERT INTO spm_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks Kraisɨna andarsir nɨghɨnɨsir aghavagharir rako othevir marsi ikeeŋga gɨva. Pol mbɨkemigha gɨvasima, Feliks Judarii vɨŋgɨ kamaghɨusue, “Gee ararɨghɨvɨkeghɨva, mbɨzorusir gumasi bar men gumaghana aphan Lisias zɨghirɨtima, khɨɨ gen mbɨŋgɨmɨŋgɨar rɨkɨrami.” ");
INSERT INTO spm_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","A Pol rɨvɨnan khɨrthɨgha rarɨghaousua a 100 pɨlan mbɨzorsir gumasir garir gumagham mbɨŋgɨ kamaghɨusue, “Nɨɨ rɨvɨnan kɨrthɨghan Pol rathɨghɨva phum aŋnɨ usuighɨ mbɨghɨna thaghɨri, Polɨn aveeŋmbua bisir aŋna akuruvaghaousua ramutima nɨɨ men thɨva thaghri.” ");
INSERT INTO spm_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Uthusir marsi gɨvasima, Feliks nona amuuŋ Drusilana akua ze. A Judarira akoghɨna amigh. Mauthughura Feliks Polɨn dɨɨghava aŋm mbɨŋgɨmɨŋgɨva orasima a nɨghɨnɨghana aghavaghar Krais Iesusɨn itiro othevi vɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pol inderaghɨvɨre ikhaamiro othɨvam mbɨŋgɨva inderaghɨvɨra norighi ighuvamiro othevi vɨŋgɨva, Got gumughun osɨmndɨsiva oraghava anda rɨkɨramirɨ uthughun gunɨm mbɨŋgeeghi. Feliks akaman khavɨ oraeghava avhighaviigha kamaghɨusue, “Nɨɨ thughɨratɨ. Nɨɨ maŋŋɨ. Khɨɨ gɨn nomtheghɨ uthugh thav ikhɨva nom nɨɨn dɨɨmaŋga.” ");
INSERT INTO spm_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Feliks igharisi bighaaŋmɨusua garav ikha kamaghi nɨghɨnɨsi, Pol uthusi tharsir aŋgɨro ovhɨsira avhɨrara uvhuesan mɨn tharsir aŋra aniiŋtima, a Pola thaeghtima a maŋŋanga. Bighan khuaŋmɨusua uthusira avhɨrara a Polɨn dɨɨva ana zaava aŋn phorugha mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Gumughun ombaran phunini gɨvasima, Porsius Festus, Porsiusɨn izɨɨn mav Festus, a Feliksɨna aŋan nii. Feliks Judarir ramuightima mee navana aghuuŋn aŋni ikɨva bar aŋgi iphuighaousuava, a Pola thaeisima a rɨvɨnan kɨrthɨghan ikhavɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus Judian distrighɨn zeghava Feliksɨna aŋan nighava, uthughun phunini ko mbɨkethav gɨvasima a Sisarianɨ uŋuua thaegha Jerusalemɨn guavanambo. ");
INSERT INTO spm_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Festus Jerusalemɨn guavanambosima, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii rako Judarir gumasira aphani mee gua aŋna agheghava osɨmndɨsir Polɨa asi. ");
INSERT INTO spm_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Mee Polɨm mbɨsueghtima ana aremighausuava kama rɨkɨrigha Festusɨ mbɨŋgɨ kamaghɨusue, “Nɨɨ en akuraghɨva gumaghan khav amandaghtima, a Jerusalemɨn zeghirɨri.” Mee Polɨm mbɨsueghtima ana aremighaosuava gumasir marsi vɨŋgɨ kamaghɨusue, “Gee maŋɨ aŋna aravagh utuavɨn mooeŋri.” ");
INSERT INTO spm_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Mee kamagh nɨghɨnɨigha gɨvaghava Festusɨm mbɨŋgɨ kamaghɨusue, “Nɨɨ Pola amandaghtima a Jerusalemɨn zeghirɨri.” Mem mbɨkemisima Festus mee ikara, “Pol a Sisarianɨ uŋuun rɨvɨnan kɨrthɨghani iti. Khɨɨ gurumɨra Sisarian maghiraami. ");
INSERT INTO spm_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Pol guisimbaaŋra osɨmndɨgha thavɨ ramuightima, gee akaman aŋga asaousua, gen gumasir aphani tharsi nan gɨn Sisarianɨ uŋuun maghirɨtima khɨɨ geno osɨmndɨsiva oraghɨva anda rɨkɨrami.” ");
INSERT INTO spm_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus men phorugha 8 pɨla o 10 pɨlan uthusir ikhegha Sisarianɨ uŋuun gueghirɨ. Amɨrɨtusi rɨmaaŋra ana osɨmndɨsiva oraghava anda rɨkɨrira aŋaanambaaŋna apheragha mem mbɨkemisima mee Pol nigha aŋmɨusua zii. ");
INSERT INTO spm_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pol zaava otosima, Judarii Jerusalemɨni ikhegha zeghiresi tharsi aŋne ighuigha utuivighava mee osɨmndɨsira avhɨrir aŋga asi. Mee aŋna osɨmndɨgha mbɨnɨɨŋ thavɨn Festusɨn mbɨkemisi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mem mbɨkemisima Pol nombɨusua kamaghɨm mbɨŋgeeghi, “Khɨɨ Judarir othɨva thava biisi phatɨ. Khɨɨ Gotɨ rɨphenaŋga asɨghasɨisi phatɨ, osɨmndɨgha thav Sisarɨa amuisi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mauthughura Festus Judarir akuruvaghaousua nɨghɨnɨghava Polɨn azaaghi, “Nɨɨ osɨmndɨsia rɨkɨriraousua Jerusalemɨn mava anaaŋtima, khɨɨ munagh mee nɨɨŋga asira akaa tharsiva oraghami? Nɨɨ kamagh vhusvhuiisi, o?” ");
INSERT INTO spm_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","A Polɨna azarasima, Pol ana ikara, “Khɨɨ khara utughav itira aŋan, a Sisar osɨmndɨsia rɨkɨraosua mbɨsevisira aŋanambaaŋ maghɨ. Osɨmndɨsia rɨkɨrir aŋanan khavɨra, kha aŋanambaaŋra a nano osɨmndɨsiva oraghɨva anda rɨkɨrami. Nɨɨ ikeeŋga gɨva. Khɨɨ osɨmndɨgha thavɨn Judarigha amuisi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Khɨɨ guisimbaaŋra ovhevheeŋn othɨva thavɨ ramuighɨva kha arɨmaŋaga. Khɨɨ ovhevheeŋna arɨmaŋɨgham phatɨghami. Mauthughura Judarii naŋga asirɨm mbɨŋgɨmɨŋgɨ, anda vɨnɨŋgari phatɨ, thav na nigh Judarir afharira athɨgham thughatɨs phatɨ. Sisar nano osɨmndɨsiva oraghɨva andar rɨkɨrirousua khɨɨ vhusvhusi!” ");
INSERT INTO spm_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus non ikaaŋmaran gumasir phorugha mbɨkemigha, maghɨra uruivaghava Polɨm mbɨŋgɨ kamaghɨusue, “Nɨɨ Sisar nɨɨno osɨmndɨsiva oraghɨva andar rɨkɨraousua mara nɨɨn vhusvhusara, aria, nɨɨ Sisarɨusua maaŋɨ!” ");
INSERT INTO spm_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Uthusir marsi gɨvasima, ativasir gumagh Agripa nona avheeŋnameeŋ Bernaisɨn phorugha aniiŋ uthughuna aghuuŋ Festusɨ ranɨɨŋmɨusua noni Sisarianɨ uŋuun zui. ");
INSERT INTO spm_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Aniiŋ uthusira avhɨrara Sisarianɨ uŋuuni itima Festus Polɨn gun ativasir gumagh Agripa aŋm mbɨŋgeeghi. Festus kamaghɨusue, “Gumaghan mav khaghi iti. Feliks ana nigha rɨvɨnan khɨrthɨgha athɨsima a khari ikhavɨrei iti. ");
INSERT INTO spm_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Khɨɨ Jerusalemɨni itima Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii rako Judarira akhoghɨn gumasira aphani akaar aŋga asava nana azaaŋsɨgha kamaghɨusue, ano osɨmndɨsivɨusua nɨɨ mbɨkemighti, mbɨzorsir gumasi aŋm mbɨsueghti ana aremighemi. ");
INSERT INTO spm_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Khɨɨ kamagh mem mbɨŋgeeghi, ‘Romiiŋn othɨvara khara, mee gumagha thav phura aŋm mbɨsueghem thughatɨs phatɨ. A ufhuaraghɨvɨra akaman aŋga asi gumasi rako osɨmndɨsiva oraghava anda rɨkɨrir gumasira arɨmasir rɨfhaaŋn utughɨva, a men phorughɨva mee nori vathoghomi. Kha uthughun a nombɨusua mbɨkɨmaŋga khara guisimbaaŋran bighɨn o phatɨ.’ ");
INSERT INTO spm_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Mauthughura mee nan phorugha khagh zesi, khɨɨ thange avhughusuesi phatɨ. Amɨrɨtusi rɨmaaŋra khɨɨ osɨmndɨsiva oraghava andar rɨkɨrir gumaghana ambirambiina apheraghav ikava mee nighɨva avhen zaaousua mbɨkemisi gumagh, khɨɨ mem mbɨkemisima mee ana nigha zii. ");
INSERT INTO spm_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Akaar aŋga asi gumasi mee akaar Polɨ asirɨ uthughun, khɨɨ orasima mee othɨvhan maghatɨgha thavɨusua akaman aŋga asi phatɨ. Khɨɨ kamagh nɨghɨnɨsi, a ti othɨvhan maghatɨgha thavɨa amuisima, mee akaman aŋga asamati, phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Judarii non suren nɨghɨnɨsira aghavagharivɨusua Polɨn phorugha mee nori vatosi. Aremisi gumaghan mav Iesus, Pol kamaghɨusue, ana aŋamɨre itima mee bighan khavɨusua nori vatosi. ");
INSERT INTO spm_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Khɨɨ akaman khavɨm mbɨnɨɨŋmɨusua uruiava avheeŋi. Khɨɨ inderagha ikeeŋsi phatɨ. Mauthughura khɨɨ kamagh aŋna azaaghi, ‘Nɨɨ ti Jerusalemɨn maŋŋɨtima, khɨɨ, mee munagh nɨɨŋga asira akaa rɨkɨrami?’ ");
INSERT INTO spm_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ana aŋm mbɨkemisima Pol kamaghɨusue, ‘Khɨɨ rɨvɨnan kɨrthɨgharei ikhɨtima Sisar gɨn nana osɨmndɨsiva oraghɨva andar rɨkɨrami.’ Kamagha amuisi khɨɨ mem mbɨkemisima, mee aŋnɨ usuirasima a rɨvɨnan kɨrthɨghani ikhavɨrei iti. Khɨɨ gɨn utuav thavɨ otoghɨva Sisarɨusua ana amaŋŋgami.” ");
INSERT INTO spm_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Uthughun khavɨn Agripa oraegha kamaghɨm mbɨŋgeeghi, “Khɨɨ nombɨ gumaghan khavɨ oraghaousua.” Ana aŋm mbɨkemisima Festus kamaghɨm mbɨŋgeeghi, “Gurum rɨmaaŋra, nɨɨ nombɨra aŋm mbɨzeva oraa.” ");
INSERT INTO spm_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Amɨrɨtusi rɨmaaŋra Agripa ri Bernaisi ativasir gumasir azhɨɨrira aghui aghuighava, noniiŋ mbɨzorsir gumasir aphanir phorughava uŋuuni khavɨn iti gumasira aphanir phorugha, mee gumasi itira aŋanana avhen zui. Mauthughura Festus mbɨkemisima mee Polɨn akuava avhen ze. ");
INSERT INTO spm_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus kamagh mem mbɨŋgeeghi, “Gee bar en phorugha khagh iti tharsi rako ativasi gumagh Agripa gee gumaghan khavɨn gan! Jerusalemɨnɨ uŋuun iti Judarir akhoghɨn gumasi rakoma Sisarianɨ uŋuun khagh iti Judarir akhoghɨn gumasi, mee bar akaar aŋga asava barɨ mbɨghɨravɨra dɨɨ kamaghɨusue, ‘Nɨɨ aŋm mbɨsueghtima ana aremighiri, ana aŋamɨre ikaa thaghɨri!’ ");
INSERT INTO spm_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Khɨɨ ana aremighemir othɨvhan maghatɨgha thavɨ otosi phatɨ. Pol Sisar aŋno osɨmndɨsiva oraghɨva anda rɨkɨran vhusvhusi. Kamagha amuisima kha ana nighɨva Romiiŋnɨ uŋuuna ana amaaŋga. ");
INSERT INTO spm_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Khɨɨ theghɨnan bigha thavɨra non ikhɨv Sisarɨusuava ana osɨrighɨva ana amandaghati? Gumughun a ikeeŋgɨva, mbɨkɨmaŋga, mee bighan khavɨusuavɨra akaman aŋga asi. Kamagha amuisima nɨɨ ativasi gumagh Agripa koma gee khagh iti gumasi bar, kha ana nigha gena arɨmasi rɨfhaaŋna anara afhaghɨva, aŋnɨ ukhuimbaramuti aŋm mbɨkɨmtima, khɨɨ inderaghavɨrama oraeghɨva aŋn gun osɨrami. ");
INSERT INTO spm_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nan nɨghɨnɨgh kamaghɨusue, ‘Khɨɨ rɨvɨnan kɨrthɨghan iti gumagha thav phurama ana amaaŋva, aŋno othevir gun osɨrana agharkuvighemi, anaaŋ, othɨvhana aghuuŋ phatɨ.’ ” ");
INSERT INTO spm_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mauthughura Agripa kamagh Polɨm mbɨŋgeeghi, “Nɨɨ nombɨra nombɨn niaghɨ.” Mauthughura Pol nona afharimuu ufhuegha nona akaa vɨŋgɨ kamaghɨusue, ");
INSERT INTO spm_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ativasi gumagh Agripa, khɨɨ Judarir akhoghɨn gumasi naŋga asira akaman khav ikaravaghousua bar vhusvhusi. Kha anaaŋn gun nɨɨ mbɨkɨmaŋŋga. ");
INSERT INTO spm_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ee Judarii kamagha amuava, nori vɨŋgɨ norira norigha atharava amui bisir kharsi nɨɨ bara anda ikaaŋi. Kamagha amuisi khɨɨ nɨɨna azaaghi, ‘Nɨɨ inɨmɨrara apheraghɨv ikhɨva nana akava oraa.’ ");
INSERT INTO spm_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Judarii mee bar na ikaaŋi, nani ikhɨrano othɨv, khɨɨ irɨrɨvare ikava nonɨ uŋuuna andarasir phorughavɨre ikha gua khɨɨ gumughun zaa Jerusalemɨni iti. ");
INSERT INTO spm_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Mee fhomɨra na ikaaŋi, mee vhusvhusighɨv, nana othevir gun nɨɨm mbɨkemighemi. Khɨɨ ikhamarei ikava, Farisiiŋn akoghɨn gumaghan mavɨn mɨn otogha meno othevir gɨn zui. Gumasi avhɨrara Farisiiŋn othevir gɨn maŋŋamɨusuava amuava bar iŋguraŋguraisima kha andar gɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Khɨɨ thighira osɨmndɨsia rɨkɨrir gumasir arɨmasi rɨfhaaŋnɨ uthusir bigham mbɨnɨɨŋ a kamagh gu. Got fhomɨra ena avhavir phorughava akama rɨŋgɨran mavɨ amuisima khɨɨ nɨghɨnɨghana aghavagharara akaman khavɨn ikava, aŋn gɨn zaaousua mbɨkemisi bisivɨusuavɨra gara itima mee anaaŋmɨusuavɨra osɨmndɨghan naaŋga anɨndi. ");
INSERT INTO spm_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","En 12 pɨlan akhosir gumasi rako amisi, mee aroe rako rɨmaŋgarir Gotɨni izɨɨ ufhava nɨghɨnɨghana aghavagharara aŋn ikava bighan khavɨusuavɨra gari. O ativasir gumagh, ee bighan khavɨusua garima, bighan khavɨusuavɨra, Judarii aŋmɨusua akaman naŋga asi. ");
INSERT INTO spm_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Manmaghɨusua gee gumasir marsi kamagh nɨghɨnɨsi, Gotɨn arɨghira guesi tharsi ramuightima mee nomthegh rɨkhavighem thughatɨs phatɨ? ");
INSERT INTO spm_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Khɨɨ fhomɨra nombɨ kamaghɨusue, ‘Khɨɨ bisira avhɨrara ramuightima anda Nasaretiiŋn gumagh, Iesusɨni izɨɨra afharavaghami.’ ");
INSERT INTO spm_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Khɨɨ bisir kharsi Jerusalemɨn andagha amui. Khɨɨ Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikii andar gamgaaŋ nigha, khɨɨ Gotɨn gumasi rako amisi mena avhɨrara nigha rɨvɨnan khɨrthɨghan mee arɨghi. Uthughun khavɨn gumasira aphani mem mbɨsoghtima mee aremighaousuava mem mbɨŋgeema, khɨɨ ivhɨra kamaghɨusue, mee arɨmɨghireghɨri. ");
INSERT INTO spm_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Uthusira avhɨrara khɨɨ Gotɨn phorugha mbɨŋgeer rɨphenigha aruava andara avhen gua, menɨ usuigha mem mbɨsosi. Khɨɨ ambaragh mee ramutima mee akaar maghatɨsir Ikhɨvam mbɨkɨmɨva aŋni izɨɨra afharavaghami. Nan nav memɨusua phuvɨra nan sima khɨɨ isaghuni iti uŋuimbar gua mera afaravaghasoua mamemɨusua uri.” ");
INSERT INTO spm_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Pol mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Uthughun mavɨn, Gotɨna aphuraphurava aghae rako bisir aŋga anɨndi gumasiri ikiira, mee akamana aghavagharan naŋga anɨɨŋgava, mee na amandasima khɨɨ Damaskusɨnɨ uŋuuni ikhɨvan zui. ");
INSERT INTO spm_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","O ativasir gumagh, uthugh kamagh 12 okloghɨn zuima, khɨɨ utuavɨn gua, garima, aŋaran mav Gotɨn uŋuuni ikhegha zaa naŋgi isira, aŋaran khav bara aghavagharigha arona aŋara afhira. Nan phorughava arui tharsi aŋaran khav bar eŋgi isira. ");
INSERT INTO spm_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kamagha amuisima ee barɨ unuaghɨn aŋgi iree, khɨɨ orasima ithɨɨŋn mav Hibruiiŋna akaman kamagh nam mbɨŋgeeghi, ‘Sol, Sol, nɨɨ manmaghɨusuavɨra nara afharavaghavɨre iti? Nɨɨ nara afharavasi phatɨ, nɨɨ mbɨzaghɨn nombɨra nombɨa anɨndi.’ ");
INSERT INTO spm_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mauthughura kha aŋna azaaghi, ‘Ikhɨv, nɨɨ thɨɨŋra?’ Khɨɨ mbɨŋgeema Ikhɨv na ikara, ‘Khɨɨ Iesus, nɨɨ nara afaravasi. ");
INSERT INTO spm_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nɨɨ rɨkavigh uthuu. Khɨɨ thighira noni iŋaarivɨusua niam mbɨsɨvaousuava nɨmba oto. Nɨɨ thighira ganisi bisi rako, khɨɨ gɨn nɨɨn khɨvamir bisi na andara akamɨ ukunaŋga. ");
INSERT INTO spm_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Khɨɨ nɨɨa amandaghtima igharisirɨ unuaghɨnan gumasi rakoma, Judarir akhoghɨn gumasi rako amisi mee iphas nɨɨ ramutima, khɨɨ nɨɨn ganɨva nɨɨna akuruvaghtima, mee nɨra afharavaeghem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nɨɨ kamaghɨrara ramuighɨva nɨɨ mena arɨmasi osemseghtima, mee akɨrɨ ɨraghɨva gɨngɨnan itira othevir maghatɨsigha aseghɨva, aŋaran zaami. Mee Satanɨn gamgaaŋ athaeghɨva, Gotɨusua zaami. Mee kamaghɨ ramuightima khɨɨ meno othevir maghatɨsi gɨna amaaŋga, mee ivhɨra nɨghɨnɨghana aghavaghar nani iti gumasi rako amisir arɨghan aŋan niaŋga. Nan gumasi rako amisir kharsi, mee nɨghɨnɨghana aghavaghar nan itima, khɨɨ meŋga amuisima mee uzue. Nɨɨ iŋaaran khavɨ ramuamɨusua, khɨɨ memɨusua nɨɨa amandi.’ ” ");
INSERT INTO spm_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Arama Pol mbɨŋgɨ guava kamaghɨm mbɨŋgeeghi, “Ativasi gumagh Agripa, khɨɨ Gotɨnɨ uŋuuni ikhegha zesi bighan mavɨn ganigha aŋgɨ phɨrphɨrsi phatɨ, kha aŋna akaman gɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Khɨɨ ufhuaragha Damaskusɨnɨ uŋuuna akamɨ ukunigha, Jerusalemɨna akamɨ ukunigha, Judian distrighɨn itira aŋaani bara andara akamɨ ukurava, ivhɨra khɨɨ igharisirɨ unuaghɨnan gumasi rako amisivɨusua guava akamɨ ukurava, kamaghɨusue, ‘Gen non nɨghɨnɨsigh ɨraghɨva nomthegh Gotɨusua zɨɨ. Gee amuiro othevi, gumasi andar ganɨva ikeeŋgɨm mbɨkɨmaŋŋga gee non nɨghɨnɨsigh ɨragha gɨva.’ ");
INSERT INTO spm_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Khɨɨ bisir kharsira akamɨ ukurima, mee Gotɨ rɨphenam mbɨroghɨn nanɨ usuira. Uthughun khavɨn Judarii na mbɨsuesima khɨɨ arɨmamɨusuavɨrama amui. ");
INSERT INTO spm_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Got nana akurasima khɨɨ inderaghavɨre ikha zaa thighira, khɨɨ khaghɨ utughava akaman gumasir kɨni rako gumasir ikii bar mem mbɨŋgeeghi. Akaman khavɨra, Moses ri Gotɨna ambuuŋn gumasi fhomɨra aŋn gunɨ mbɨkemi. Khɨɨ nomthegha akaman igharisi thavɨ ukuri phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Mee kamaghɨusue, ‘Got nom ee niamɨusua mbɨsevisi gumagh, Krais aŋm mbɨzagh nighɨva aremighɨva, a ufhuaraghɨvɨra rɨkhavighemi gumagh maghɨ. A Gotɨn aŋaran Judarir akoghɨn gumasi rako igharisirɨ unuaghɨnan gumasir khɨvami.’ ” ");
INSERT INTO spm_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol akamɨ ukuravɨre itima, Festus akaman ikhɨvan kamagh aŋm mbɨŋgeeghi, “Pol, nɨɨ oŋani! Nɨɨ surera avhɨrara amuisima nɨɨni ikaaŋmaran ikhɨv, nɨɨŋga amuisima nɨɨ oŋani!” ");
INSERT INTO spm_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pol kamaghɨm mbɨŋgeeghi, “Gumaghan ikhɨv Festus, khɨɨ oŋanisi phatɨ, khɨɨ guisimbaaŋram mbɨŋgeeghi, khɨɨ nɨghɨnɨgh ikava khɨɨ mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ativasi gumagh Agripa bisir kharsi bar anda ikaaŋi, anda mondughava otuivisi phatɨ, khɨɨ ikaaŋi, a ti bisir kharsiv oraghava, andar garava arama anda ikheeŋgamati. Kamagh amuisima khɨɨ atiti phatɨgha, bar andar gun ativasi gumagh Agripa mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ativasi gumagh Agripa, nɨɨ nɨghɨnɨghana aghavaghar Gotɨna ambuuŋn gumasir iti, o phatɨ? Khɨɨ ikaaŋi, nɨɨ nɨghɨnɨghana aghavaghar iti.” ");
INSERT INTO spm_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","An aŋm mbɨkemisima Agripa kamagh Polɨn azara, “Manmagha amui, nɨɨ kha uthughun othɨvanŋra nam mbɨkɨmɨtima khɨɨ manmaghɨra Kraisɨn gɨn maŋɨ ti?” ");
INSERT INTO spm_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ana aŋm mbɨkemisima Pol ana ikara, “Uthughun othɨva thav o uthughunɨ uruara thav, khɨɨ kamagh Gotɨn phorughum mbɨkɨmaŋga, nɨɨ koma kheeŋa, gee thighira nana akamam mbaraghi, gee bar nan mɨno othuivhami. Bighanɨ uvhuavɨra, mee ukuaghaviir gee ikeghɨva gee nigh rɨvɨnan khɨrthɨghan gee rarɨghan, khɨɨ iphɨrphɨri.” ");
INSERT INTO spm_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mauthughura ativasi gumasi rako gavmanɨn gumasir aphan koma Bernaisin phorugha ikesi tharsi, mee bar rɨkavighava ");
INSERT INTO spm_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","rɨphena thaegha gugha norira nori vɨŋgɨ kamaghɨusue, “Gumaghan khav othɨvhan maghatɨgha thavɨ ramuighɨva, ana aremighemi, o a rɨvɨnan kɨrthɨghan ikaami. Aŋno othɨvhan maghatɨgha thavɨ amuisi phatɨ.” ");
INSERT INTO spm_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Mauthughura Agripa kamagh Festusɨm mbɨŋgeeghi, “A nombɨra kamaghɨusue, Sisar nana osɨmndɨsiva oraghɨva anda rɨkɨrami. A ti kamaghɨ mbɨkemis phatɨghav khasima, ee thighira ana thesima ana akɨran guaghi.” ");
INSERT INTO spm_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Mee, ee nigh Italinɨ unuaghɨnan maŋŋamɨusuava ukuran phorugha akama rɨkɨrigha gɨvaghava, Polɨn phorugha rɨvɨnan kɨrthɨghan iti tharsi ivhɨra mee nigha 100 plam mbɨzorsir gumasira aphanan afharɨ athɨ, aŋni izɨɨ Julius, ana ativasi gumaghan garava ana araavi gumasiri ikɨv. ");
INSERT INTO spm_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Mee ee nigha guava Adramitiumɨnɨ uŋuunɨ ukura athɨɨ. Ukuran khav Esian distrighɨn itirɨ uŋuimba vɨkeeŋ maŋŋamɨusuava amuima, ee maghɨra aŋn zui. Mauthughura Aristarkus, a Masedonian distrighɨn itirɨ uŋuu Tesalonaikan gumagh, a ivhɨra en phorugha iti. ");
INSERT INTO spm_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Amɨrɨtusi rɨmaaŋra ee Saidonɨnɨ uŋuuno othuivi. Julius othɨvhana aghuuŋn Polɨ amuava ana thaesima a nona andarsivɨusua zuima, mee aghae rako bisir aŋna akuruvasi. ");
INSERT INTO spm_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ee Saidonɨnɨ uŋuuni ikhegha nomthegha zuima gamiiŋ bar aghavagharisima, kamagha amuisima ee Saiprusɨn mɨghsɨman gamiiŋ amɨrasira aŋanan zui. ");
INSERT INTO spm_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ee guava Silisian distrigh koma Pamfilian distrighɨn itira oŋarani ikhɨva biigha guava Lisian distrighɨna avhen itirɨ uŋuun ikɨv Mairana oto. ");
INSERT INTO spm_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mbɨzorsir gumasir garir gumaghan khav ana Aleksandrian uŋuun itirɨ ukuran garima a Italinɨ unuaghɨnan maŋŋamɨusuava amuima, an aŋn ganigha ee nigha guava en aŋga athɨ. ");
INSERT INTO spm_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ee rɨkhavighava bar amɨraghɨvɨra zuima uthusir marsi gɨva, ukurɨ uvhuarira akɨrɨsɨsi phatɨ, gamiiŋni ikhɨvɨ rɨkavhisima, ukuram mbɨsɨmanɨ usuisi gumasi mee iŋaaran ikhɨvara amua gua ee Nidusɨna aghan zui. Ee zuima gamiiŋ aghavagharigha enɨ utuava phɨrisima ee maaŋan iŋgura, kamagh amuisima ukur nonɨ utuava thaegha gua Kritɨn mɨghsɨmano otogha guava, Salmonɨnɨ unuaghɨnano othɨvhan iti. Uthughun khavɨn ee Kritɨn gamiiŋ uvhuee phatɨsira aŋanan gueghiri. ");
INSERT INTO spm_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Gamiiŋ bar amɨrasima, mee fhighavɨre iŋaara gua oŋarana ataaŋna anaŋga zaava aŋanan mavɨo oto, aŋanan khavɨn izɨɨ Ifhanaaŋna Aghuuŋ ee aŋmba othuvi. Aŋanan khav a Laseanɨ uŋuuna aghani iti. ");
INSERT INTO spm_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Uthusira avhɨrara phura gɨva. Kamagha amuisi Judarir akoghɨn gumasi mee aghae thamɨrasirɨ uthugh otogha gɨva. Kha uthughun oŋar bar maghatisima, kamagh amuisima Pol kamagh mem mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Gumasi, khɨɨ kamagh nɨghɨnɨsi, ee thighira maŋɨva uthughun maghatɨgha thavɨo otoghtima ukuran iti bisira avhɨrara mareireghtima, ukur mareireghtima, ee ivhɨra marereghemi.” ");
INSERT INTO spm_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mbɨzorsir gumasir garir gumagh Polɨna akamamba oraesi phatɨghava ukuran guav koma anɨ usuisir gumagh aniiŋn nɨghɨnɨghan gɨn zui. ");
INSERT INTO spm_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ifhanaaŋn khav a ikhɨva geeŋmbar ikiir mondugh ikhamiri ifhanaaŋna aghuuŋ phatɨ. Mamagha amuigha ukurani iti gumasira avhɨrara maŋŋamɨusuava akama rɨkɨri. Mee thugharatɨghɨva mee maŋŋɨva Finiksɨnɨ uŋuuno otuivighɨva kha gamiiŋn ikhɨvan gan kha uŋuun ikaami. Finiks a ifhanaaŋ mav a Kritɨn mɨghsɨman sautɨ rɨfhaaŋn itima ukur aro gueghiri rɨfhaaŋ mogh zui. ");
INSERT INTO spm_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Sautɨn gamiiŋna amɨɨŋndɨghɨ rɨkavhi. Mee kamaghɨusue, mee ti inderaghavɨra maaŋɨ Finiksɨn ifhanaaŋno otuivighemi. Mee kamagh mbɨkemigha ukura asigharafhaghava Kritɨno oŋara mbɨkeeŋn zui. ");
INSERT INTO spm_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","15","Mee muaŋ ikesima gamiiŋn bar aghavaghar rɨkavhigha oŋara amuima a phuvɨra iŋaari. Mee kamagh gamiiŋn khavɨ rɨmbori, “Not ko Istɨn thighiiŋn rɨkavir gamiiŋ.” A Kritɨn mɨghsɨman muaaŋmogh zaava fighavɨra ukuro uvhuava ana munamandi. Gamiiŋ bar aghavagharisi ukuran iŋaarir gumasi ukuranɨ usuisi phatɨgha ukura thaesi gamiiŋ aŋgu uvhueema a phura zui. ");
INSERT INTO spm_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ee gua Kaudan mɨghsɨma mbɨkeeŋn gue. Mɨghsɨman gamiiŋ mange ana aphɨrisima ee akeman sovange ikuigha ukuran aghan zaaousua bar iŋaaran ikhɨva amui. ");
INSERT INTO spm_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Uthughun khavɨnɨ ukuran iŋaarir gumasi akeman sovange ufhuegha iphɨa athɨgha, mee umbue ukurima anda guava ukurana apheeŋ guesima, mee ukuran phorugha ane ikesima a bar aghavaghari. Mee maaŋɨ Afrikan oŋarana ataaŋn iti gɨrɨrɨŋn mavanaŋna avhighaviigha, ukuran selɨ ukunisi gamiiŋ ukura sɨvaghsɨvasima a zui. ");
INSERT INTO spm_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Gamiiŋ koma oŋar ivhɨra bar aghavagharigha phuvɨra em mbɨsosi. Amɨrɨtusi rɨmaaŋra ukuran iŋaarir gumasi ukurana avhen iti bisi nigha oŋarana anda ukuri. ");
INSERT INTO spm_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Uthughunɨ mbɨketavɨnɨ mee ukuaruvan ikɨv nigha maghɨra ukuran pulɨa amui phuri rako bisir marsi ivhɨrama anda ukuri. Mee nona afharir anda niava anda ukuri. ");
INSERT INTO spm_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Mauthughura uthusira avhɨrara ee aro koma mbɨkovir ganis phatɨ. Uthughun khavɨn gamiiŋ mbɨghɨravɨra eŋgɨ uvhuavɨre iti. Kamagha amuisi ee bar ambuun norira akuragh mbɨghɨvɨghɨghan nɨghɨnɨgha thav eni iti phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Uthughunɨ uruaraaŋn gumasi aghaa thava amesi phatɨsima, Pol rɨkavhigha men mbɨnɨmanɨ utugha kamaghɨm mbɨŋgeeghi, “Gumasi, gee nana akamamba oraegha, ee Kritɨn mɨghsɨmare ikheghavikhasi uthughun maghatɨghan khav emba otoghom phatɨghtima, bisi tharsi mareregham phatɨghami. ");
INSERT INTO spm_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Khɨɨ thighira gem mbɨkɨmamɨusua, ena thav aremighem phatɨghami. Kamagha amuisi gee avhighavigha thaghɨri, gee phura inɨmɨre ikhɨɨ. Kamagha amuisima, ena thav marerɨgham phatɨghtima ukur nombɨra marerɨghami. ");
INSERT INTO spm_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Khɨɨ Gotɨn gumagh, khɨɨ aŋni izɨɨ ufhii. Rɨmaaŋn Gotɨn ensel zaa nana aghanɨ utugha kamaghɨm mbɨŋgeeghi, ");
INSERT INTO spm_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Pol, nɨɨ avhighavigha thaghɨri. Nɨɨ maŋŋɨva, Sisarɨna arɨmasi rɨfhaaŋnɨ utuivami. Nɨɨ oragh, Got nɨɨna azaaŋsɨgha oraegha gɨvagha nɨɨnɨ ukuarukuvi. Nɨɨn phorugha ukuran iti gumasi, mee aremighem phatɨghami.’ ");
INSERT INTO spm_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Gumasi, gee oragh! Khɨɨ nɨghɨnɨghana aghavaghar Gotɨn ikha kamagh ikaaŋi, Got nam mbɨkemisi moghɨra bisi othuivhami. Kamaghɨnɨ, gee gamgaeŋgiri avhighavigha thaghɨri. ");
INSERT INTO spm_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ee ukura thaeghtima a mara maaŋɨtima, gamiiŋ aŋgu uvhuɨrahɨva ana nigh maaŋɨ mɨghsɨma thavɨn ana phorughami.” ");
INSERT INTO spm_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","14 pɨla rɨmaŋgarir gamiiŋ eŋgu uvhurasima ee Mediterenian oŋarani ikhɨvan iphɨn zui. Rɨmaaŋna arɨgha aghangera zesima ukuran iŋaarir gumasi nɨghɨnɨsi, “Ee unuaghɨnan aghan zaamati.” ");
INSERT INTO spm_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kamagha amuisi mee oŋaranɨ ukhondɨghi ikaaŋmɨusua umbueeŋ ukunisi a gueghirɨ. Kha uthughun oŋaranɨ ukhondɨgh 40 mitan utu. Ukur muaŋ sɨvagha gusima, mee oŋarana ambarima a 30 mitanɨ utu. ");
INSERT INTO spm_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Mee kamagh avhighavighi, ukur maaŋɨ aŋgɨɨ tharsi itira aŋanan phorugh barɨm mbɨsarighireghemi. Mee aŋkarir 4 pɨla ukuran gɨraŋgɨrana anda ukunigha, aro anaaŋmɨusuava nori Gotɨn phorugha mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ukuran iŋaarir gumasi, mee ukura thaegh arɨmaŋamiusua utuavivɨusua uri. Mee ondava akeman sovange ikhesirɨ umbue afhɨrighava ane ukunisima ano oŋaran gueghirɨ. Mee khorigha amua kamaghɨusue, “Ee ukuran aŋkarii ukuri.” ");
INSERT INTO spm_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mauthughura Pol kamagh 100 pɨla mbɨzorsir gumasir garir gumagh koma aŋm mbɨzorsir gumasi vɨŋgeeghi, “Gumasir kharsi ukuran ikhaam phatɨghtima, gee bar marereghemi.” ");
INSERT INTO spm_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Kamaghɨnɨ mbɨzorsir gumasi akeman sovangenɨ umbuea rɨghorisima ana oŋaran gueghirɨ. ");
INSERT INTO spm_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Mauthughura amɨni itiisuava amuima Pol aghaa thava ramamɨusuava meŋga aghori, “14 pɨlanɨ uthusi gea rɨtusima gee mbɨtiire iti, gee norivɨusua navkuvava aghaa thav amesi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Khɨɨ thighira gem mbɨŋgeeghi gee aghaa thava ramɨri. Aghaa gen akuruvaghtima gee gamgaeŋgemi. Gen thooŋn thav maghatiighen phatɨ. Mamaghɨra gena aphanan arɨghɨna thav marerɨgham phatɨghami.” ");
INSERT INTO spm_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","A kamaghɨm mbɨkemigha gɨvagha, uvhuighanɨ utuman mav nigha men arɨmasi rɨfhaaŋnɨ utugha Gotɨ mbɨnambaghava, ane biigha maghɨrama ana aphi. ");
INSERT INTO spm_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kamaghɨna amuisima mee bar navan aghuuŋ nighava nori aghaa aphi. ");
INSERT INTO spm_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ee ukuran iti gumasi, ee rɨmbombon 276ɨnɨ utu. ");
INSERT INTO spm_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Mee amegha navi izɨvagha, kamaghɨusue, ukuru mbɨghɨvɨghɨigh iphɨre ikaami. Mee ukaran iti uitir othevi nia anda oŋaraou ukuri. ");
INSERT INTO spm_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Aro anandima, ukuran iŋaarir gumasi oŋarana iti mɨghsɨman ataaŋn mavɨn garava inderagha aŋni izɨɨ ikeeŋsi phatɨ. Mee ifhanaaŋn mavɨn gari, a bara avhen gugha gɨrɨrɨŋna aghuuŋre iti. Mee kamagh nɨghɨnɨsi, mee inderaghavɨra ukurou uruivaghɨva aŋra ramuightima a ti maŋŋɨ gɨrɨrɨŋ khavɨn akɨran maŋŋamɨusua, mee anaaŋn vhusvhusi. ");
INSERT INTO spm_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mee aŋkariirɨ usuisirɨ umbue rɨghorisima anda oŋaran gueghire. Ukuran phurɨ amuir phurir ikii ikesirɨ umbue afhɨri. Mee gamiiŋmɨusua ukuran mbɨnɨman itir sela gurasima gamiiŋ ukur nighava ataaŋn zui. ");
INSERT INTO spm_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mauthughura ukur gua oŋaran thooŋn ifhivir gɨrɨrɨŋni iphɨn guavanambogha, maghɨrama apheraghav iti. Ukura mbɨnɨm gua gɨrɨrɨŋna avhen gughava bar aghavaghari. Uthughun khavɨn oŋar zaava aŋn gɨragɨraaŋ mbɨsosima a bar bɨɨghire. ");
INSERT INTO spm_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mbɨzorusir gumasi kamagh nɨghɨnɨghava avhighevighi, rɨvɨnan kɨrthɨghan iti gumasi tharsi ifhɨɨ oŋaran ameeŋ dɨɨva ataaŋn maŋɨva nori arɨmaŋeghemi. Mee, mem mbɨsueghti mee aremighaousua nɨghɨnɨsi. ");
INSERT INTO spm_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mauthughura 100 pɨla mbɨzorsir gumasir garir gumagh, a Pol ivhɨrama arɨman iphɨrphɨri. Aŋm mbɨzorsir gumasir thɨvagha, kamaghɨusue, “Dɨɨ ikeeŋsi tharsi, gee ufhuaragh ifhɨva oŋarana ameeŋgɨva nori dɨɨva ataaŋn maŋɨ. ");
INSERT INTO spm_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Gumughun igharisi tharsi mee ther arari rako ukuran arari andari iphɨn maaŋaŋgami.” Kamagha amuisima, mee bar inderaghavɨra gua mbɨkeeŋ othuivi. ");
INSERT INTO spm_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ee inderaghavɨra gua oŋaram mbɨkeeŋn othuivisima mɨghsɨman kavɨn iti gumasi en niazima ee ikaaŋi, mɨghsɨman khavɨn izɨɨ Malta. ");
INSERT INTO spm_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mee othevira aghuuir eŋga amui. Uthughun khavɨna amogha azima, em mbɨkarɨsi baro oraaŋi. Kamagha amuisima ee arivan fheeŋmɨusua, mee emɨusuava ariva athɨghava ena akua arivam mbɨroghɨn gu. ");
INSERT INTO spm_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol azir marsi nighava anda arivan iphɨa arɨsima, uthughun khavɨn ukurugha rɨvhivhatɨghan mav azira avhen itima, arivan fheveeŋ ana nima ana akɨran oto. Ukurugh maghɨra Polɨna afhare ivhigha guragha mamaghɨre iti. ");
INSERT INTO spm_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Uthughun khavɨn mɨghsɨman khavɨni iti gumasi rakoma amisi kamagh aŋn garima, ukurugh aŋna afhari ithorughavɨre itima, mee kamagh nori vɨŋgeeghi, “Gumaghan khav ti gumasi vɨsosima anda arɨghirir gumagh, ano oŋarana aremisi phatɨ. Kamagha amuisima, othevir maghatɨsi ikarvasir asaaŋ thighira ano othevi ikarvagha kamaghɨusue, ‘Aŋna aŋgamɨre ikaan thughatɨs phatɨ.’ ” ");
INSERT INTO spm_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pol ukurugha keghavkɨnisima a irava arivan gu. Uthughun khavɨn bigha thav Polɨa otosi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Mauthughura gumasi phura Polɨn gari, mee kamaghɨusue, “Aŋm mbɨkarɨgh ti beeghemi, o a ti irɨghɨva aremighemi.” Mee uthughun uruaraaŋra phura aŋn gara gua aŋn garima, bigha thav aŋmbatosi phatɨ. Mee mamagha amuigha kamaghɨusue, “Kha gumagh ana asaaŋ mav maghɨ.” ");
INSERT INTO spm_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gumaghan mav aŋni izɨɨ Publius, a mɨghsɨman kavɨn gari. Aŋnɨ unaghɨn, mɨghsɨman kavɨn iti ifhanana aghangere iti. A ena akua nor rɨphenan gusima, ee uthughun phunini ko mbɨkethavɨn aŋn phorugha itima a inderaghavɨra en garima ee iti. ");
INSERT INTO spm_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aŋn inaghaves areeghi, aŋm mbɨkarɨgh aŋn fheema, a buuna rɨmɨnmɨnaŋga avhii. Mauthughura Pol aŋn ganamɨusuava avhen gugha aŋmɨusua Gotɨn phorugham mbɨkemigha, gɨn nona afharɨn aŋni iphɨa athɨsima, a nomthegha indera. ");
INSERT INTO spm_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","A kamagha amuisima, mɨghsɨman khavɨni itira arɨmarɨr gumasi bar zima a meŋga amuima mee nomthegha indera. ");
INSERT INTO spm_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Mee othevir aghuuira eŋga amui, mamagha amuigha ee mee thamɨraousuava amuima, mee ee phatɨsi bisi andar eŋga anɨɨŋgava anda nia gua ukura arɨsi. ");
INSERT INTO spm_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ee ikɨniiŋn phunini ko mbɨkethavɨn, mara ee Maltanɨn mɨghsɨmani iti. Gumughɨn ee ifhava ukuran amandi, ukuran khav gamiiŋn ikhɨvan ararɨgha Maltanɨn mɨghsɨmani ikhegha zui. Ukuran khav a Aleksandriiŋnɨ uŋuunɨ ukur maghɨ. Ukura mbɨnɨman asaaŋ Susɨno otaran akhɨnakhɨnaniiŋn iŋedaghaniiŋ aŋni iti. Aniiŋni izɨɨniiŋ Kastor ri Poluks. ");
INSERT INTO spm_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Mauthughura ee gua Sirakyusɨnɨ uŋuuno othuivigha, uthughun phunini ko mbɨkethavɨna anamogh iti. ");
INSERT INTO spm_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ee khagh rɨkavhigha gua Regiumɨnɨ uŋuuno othuivi. Amɨrɨtusi rɨmaaŋra, Sautɨna amandasi gamiiŋ rɨkavhisima, ee uthughunɨ mbɨkethavɨn Puteolinɨ uŋuuno othuivi. ");
INSERT INTO spm_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ee anamoghɨnɨ Kraisɨna andarsir, marsira aghee. Mee 7 pɨlanɨ uthusir norir phorugh ikhaousua em mbɨkemisima, ee men phorugha Puteolɨnɨ uŋuuni ikhee. Kamagha amuisi ee gua Romiiŋnɨ uŋuuni ikhɨvan zui. ");
INSERT INTO spm_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Uthughun khavɨn Kraisɨn avheeŋmbua Romɨn ikava em mbarasima ee zima, mee ena aghauosua zii. Ee Apiusɨn bisi amandira aŋŋanan goghirava avheeŋmbuara aghegha nom sɨvagha gua bisi amandira aŋanani izɨɨ Gumasi Ikha Garava Itir Rɨphenan Phunniiŋ Koma Mbɨkethavɨna aŋgan marsira aghee. Mauthughura Pol men ganigha, Gotɨm mbɨnambagha aŋn nav aghavaghar nii. ");
INSERT INTO spm_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ee Romɨno othuivisima, gavmanɨn gumaghan aphan Polɨn mbɨnamɨnaaŋ athɨgha kamaghɨusue, a nombɨra rɨphena thavɨn ikhɨtima mbɨzorsir gumagha thav aŋn ganaŋgami. ");
INSERT INTO spm_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Gumughun uthughun phunini ko mbɨkethav gɨvasima, Pol Judarir akhoghɨn gumasira aphanir dɨɨsima mee zaa nori akuvasima, a kamagh mem mbɨŋgeeghi, “Nana andarsi, khɨɨ bigha thav ee nona andarsi iphasa meŋga amuisi phatɨ, o en avhavir othɨva thav irighavɨkɨnisi phatɨ, Judarir akhoghɨn gumasi phura Jerusalemɨn nanɨ usuiraghava Romiiŋna afharɨ athɨ. ");
INSERT INTO spm_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romiiŋ nana osɨmndɨsiva oraeghava, mee kamagh nan gari, khɨɨ arɨmaŋgamiro thav iti phatɨsima mee amuima, ");
INSERT INTO spm_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Judarir akhoghɨn gumasi kamagh iphɨrphɨri. Kamagha amuisi khɨɨ nom utuavi phatɨ. Khɨɨ kamaghɨusue, Romiiŋga ativasir gumaghan aphan Sisar nano osɨmndɨsiva oraghɨva anda rɨkɨrami. Khɨɨ nona andarsi akaman meŋga asaami bigha mbɨnɨɨŋ thav iti phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Khɨɨ bighan khavɨusua gen dɨɨsima gee ze. Kamaghɨnɨ khɨɨ gen ganɨɨva gen phorughum mbɨkɨmamɨusua. Khɨɨ nɨghɨnɨghana aghavaghar ikha garir bighan khav, Israeliiŋna akhosi koma ee bar ivhɨra aŋmɨusuavɨra gari. Mee bighan khavɨusua thighira ukuaghavan khavɨn ana ikee.” ");
INSERT INTO spm_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Mee kamagha Polɨm mbɨŋgeghi, “Judian distrighɨn iti tharsi emɨusua mbɨghara thav osɨrava nɨɨn gum em mbɨkemisi phatɨ. Judarir akhoghɨn gumasi ee khagh iti tharsi, ena thav zaava mbɨŋgɨŋgɨman maghatɨgha thavɨn nɨɨŋga amuisi phatɨ. ");
INSERT INTO spm_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ee norira nɨɨmba oraghtima nɨɨ non nɨghɨnɨghan gunɨ mbɨkɨmaŋga. Ee ikaaŋi igharisira aŋanir iti gumasi rako amisi bar gɨna amandirɨ mbɨŋgɨmgɨr kha akhoghɨn ikamaŋga amui. Kamagha amuisi, ee nɨɨn nɨghɨnɨgha oraghaousua.” ");
INSERT INTO spm_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Mee uthughun mav asaragha, gumasira avhɨrara zaa Polɨusua a itir rɨphenan khavɨn zui. Rɨmaaŋra gua uŋguarɨ uthughun oto, a Got kha bisigha ativamirɨ uthughun akaman niaghaghaaŋn gun mem mbɨŋgeeghi. Pol men nɨghɨnɨsi ufhava, Moses osɨrisirɨ mbɨŋgɨŋgɨr othevir kharsi rako Gotɨna ambuuŋn gumasi osɨrisir osɨɨri vɨŋgeeghi. Akaar kharsir mee nɨghɨnɨsir aghavaghar Iesusɨn ikhaousua, aŋn vhusvhus a men nɨghɨnɨsi ighɨghɨusuasa mem mbɨŋgeeghi. ");
INSERT INTO spm_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Marsi kamaghɨusue, Polɨ mbɨkemisir akaa anda guisimbaaŋra, marsi nɨghɨnɨghana aghavaghar andar ikaan iphɨrphɨri. ");
INSERT INTO spm_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Mee norira norir thooŋn akaar nori vɨsogha mee maŋŋamɨusuava amuima, Pol akamana ambunavɨn mem mbɨŋgeeghi, “Gotɨnɨ Utum guisimbaaŋra gena avhavi vɨkemi. Gotɨna ambuuŋn gumagh Aisaiana akamdooŋniin kamaghɨusue, ");
INSERT INTO spm_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Nɨɨ kha gumasi rako amisir kharsi kamagh mem mbɨkɨm gee uthusir avhɨrar akamamba oraghɨva, gee inderaghɨvɨra rɨthughuvɨkhɨnighɨva aŋm mbɨnɨɨŋ ikeeŋgem phatɨghami. Gee uthusir avhɨrara ganɨva, gee bigha thavɨn ganighi ikeeŋgem phatɨghami. ");
INSERT INTO spm_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kha gumasi rakoma amisir nɨghɨnɨsi aphuisima menɨ ukuarthoori mbɨzeva oraghan iphɨrɨphɨrighava mee nona arɨmasir thusi aphui. Kamaghɨra amuighava mee akaav oraghɨva anda vɨnɨŋgari ikeeŋgem phatɨghɨva nɨghɨnɨsigh ɨraghɨva namɨusua zeghɨtima khɨɨ nom me ramuightima, mee nomthegh inderaghami.’ ” ");
INSERT INTO spm_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Mauthughura Polɨ mbɨŋgɨ guava, kamaghɨm mbɨŋgeeghi, “Kamagh amuigha, khɨɨ kamaghɨusue, gee kamagh ikeeŋgemi, Got nom ee niamɨusua mbɨkemisir akaar aghuui, Got anda nigha igharisirɨ unuaghɨnan gumasivɨusuava anda amandagha gɨva. Mee oraghami!” ");
INSERT INTO spm_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol ombaran phuniniiŋn rɨphenan mavɨn ikava rɨphenan khavɨ uvhuesi. Uthughun khavɨn gumasi rako amisi an ganamɨusua aŋ rɨphenan zima a men gara bar phuvɨre inighinisi. ");
INSERT INTO spm_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Uthughun khavɨn Pol, Got kha bisigha ativamirɨ uthughuna akamɨ ukurava Ikhɨv Krais Iesusɨn akaar men surea amui. A ivhɨra avhighavisi phatɨ, bigha thav aŋnɨ utuava phɨrighem bar phatɨ.");
ALTER TABLE spm_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
