﻿USE sofia;
DROP TABLE IF EXISTS sofia.spl_vpl;
CREATE TABLE spl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES spl_vpl WRITE;
INSERT INTO spl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yura lohimbi nengât tâmbânenŋe, yamâ kutŋe Awaraham sâm, yâkât senâmbâ gâtŋe Dawiti. Otmu yâk yetgât sen âlâ yâkâlembâ Yesu teteop yamâ Anitâŋe hâŋgângumu giop. Otmu Awarahamgât senâmbâ tetem gawi ya yeŋgât kutyeŋe yuwu. ");
INSERT INTO spl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Topŋe katmâ Awarahamgât nanŋe, kutŋe Isaka sâm ya teteop. Isakahât nanŋe Yakop sâm ya teteop. Yakopgât nanŋe Yura sâm, ya teteop. Otmu imilipŋe dondâ meyehop. ");
INSERT INTO spl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuraŋe imbi âlâ, kutŋe Tama sâm, ya miop. Yaŋeâmâ naom yâhâp meyelehop, yâk yetgât kutyetŋe, Peresi yet Sera. Otmu Peresihât nanŋe Hesoron teteop. Hesorongât nanŋe Lam teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamgât nanŋe Aminarap teteop. Aminarapgât nanŋe Nason teteop. Nasongât nanŋe Salamon teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamonŋe imbi miop yamâ kutŋe Lahap, yaŋeâmâ nanyetŋe Boasi miop. Boasiŋe imbi, kutŋe Lut sâm, ya memu yâkŋe nanyetŋe Owet sâm ya miop. Owetgât nanŋe Yese teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesehât nanŋe Dawiti teteop. Dawitiŋeâmâ lok kutdâ otmâ manmâ bukuŋe, kutŋe Uria sâm, yâkât imbi hârem mewaŋgiop. Imbi yaŋe nanyetŋe Solomon ya miop. ");
INSERT INTO spl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomongât nanŋe Lehowoam teteop. Lehowoamgât nanŋe Awia teteop. Awiahât nanŋe Asa teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asahât nanŋe Yosapata teteop. Yosapatahât nanŋe Yoram teteop. Yoramgât nanŋe Usia teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiahât nanŋe Yotam teteop. Yotamgât nanŋe Ahasi teteop. Ahasihât nanŋe Hisikia teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hisikiahât nanŋe Manase teteop. Manasehât nanŋe Amon teteop. Amongât nanŋe Yosia teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiahât nanŋe Yekonia teteop. Otmu imilipŋe nombotŋe meyehop. Otmu sâp yanâmâ kapi pato âlâ, kutŋe Bawilonia sâm, yan tâmbâlipnenŋe yeŋgât kasalipyeŋaŋe taka yongom kiom tuhuyiŋgiwi. Kiom tuhuyiŋgim meyekmâ ari Bawilonia yan katyekŋetâ yâk yeŋgât hoŋ bawa otmâ manbi. ");
INSERT INTO spl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bawilonia kapi manbi yakât kakŋan Yekoniahât nanŋe, kutŋe Salatie sâm ya teteop. Salatiehât nanŋe Seruwawe teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Seruwawehât nanŋe Awiuru teteop. Awiuruhât nanŋe Eliakim teteop. Eliakimgât nanŋe Asoro teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asorohât nanŋe Sarok teteop. Sarokgât nanŋe Akim teteop. Akimgât nanŋe Eliut teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutgât nanŋe Eliasa teteop. Eliasahât nanŋe Matan teteop. Matangât nanŋe Yakop teteop. ");
INSERT INTO spl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakopgât nanŋe Yosep teteop. Yosepgât imbi sâŋetâ manop yamâ Maria. Yâhâ Mariaŋeâmâ Yesu miop yamâ Anitâŋe hâŋgângumu yâkâlen gemu miop ya nâŋgâmain. ");
INSERT INTO spl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Otmu Awarahamgât senâmbâ tetem gaŋetâ gaŋetâ tânâmyeŋambâ Dawiti ya teteop. Yâhâ Awaraham yâkâlembâ lok komotŋe komotŋe tetem gaŋetâ ya yeŋgât sen yaŋe menduhuakmâ 14 olop. Otmu Dawitihât sen yapâ tetem gaŋetâ gaŋetâ Bawilonia hânân ari manbi sen yaŋe menduhuakmâ yawuâk 14 olop. Otmu Bawilonia hânân manbi yaŋak manmâ gaŋetâ gaŋetâ Anitâŋe nanŋe tihitnenŋe olâk sâm hâŋgângumu yuân giop sen yaŋe menduhuakmâ yawuâk 14 olop. Otmu Yesuŋe giop sâp yanâmâ sen ya pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Anitâŋe Yesu hâŋgângumu gemu Mariaŋe miop yakât topŋe yuwu tap. Mâmâŋe Maria yamâ Yosepgât pat kuwaŋgiwi. Yâhâmâ sihan ikŋiâk ikŋiâk manmâ gamutâ Anitâhât Wâtgât mâmâŋahât Heakŋe Maria mâmâŋe otbaŋgimu, lokŋe orop, konohân ki manowot yan, imbiâk ya tepŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sâp yan Yosepŋe Anitâhât den tâŋ tâŋâk lâum manop. Yakât otmâmâ biwiŋaŋe yuwu nâŋgâop. “Âo, yuâmâ nâhât pat kunihiwi. Yamâ benŋe lok nombotŋe orop mon manmai. Yawu gârâmâ nâŋe lok sen senân watmune aŋulakmap,” yawu sâm biwiŋanâk nâŋgâm manop. ");
INSERT INTO spl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yawu nâŋgâm manmâ yâhâm yâhâm yan awun ehop. Awun ekmu Anitâhât aŋelo âlâŋe yuwu sâm ekuop. “Yosep gâ Dawitihât sen, yakât yuwu sâm ekgohomune nâŋgâ. Anitâhât Wâtgât mâmâŋahât Heakŋe Maria mâmâŋe otbaŋgimu tepŋe oap. Yawu gârâmâ gâŋe ki nâŋgârâ bâlewuap. ");
INSERT INTO spl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yâkŋe nanŋe membuap. Nanŋe memu kutŋe Yesu kunbuat. Yâhâ kutŋe yakât topŋe yuwu. Yen yâkât komot manmâ otmâ hilipgum gai yen kerehâk meyekbuap. Meyekmu Anitâŋe yekmu ârândâŋ otbuap.” Aŋeloŋe yawu sâm Yosep ekum ariop. ");
INSERT INTO spl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Yawu sâm Yosep ekuop ya nâŋgâmu ârândâŋ otmu imbiŋe memu orowâk manowot. Yawu manmâ yâhâm naom ya miop. Otmu Yosepŋe naom ya kutŋe Yesu sâm kunop. Yakât topŋe teteâkgât Anitâŋe emet inânŋan yuwu sâmu poropete âlâŋe kulemguop. “Imbi sihan âlâŋe naom membuap. Yâhâ kutŋe âlâmâ Imanue sâm kunbuap.” Yawu sâmu kulemguop. Kut kunop yakât topŋeâmâ yuwu tap. Anitâŋe nen orop sâp ârândâŋâk tatmap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yuraia hânân lok kutdâ pato âlâ, kutŋe Herot sâm, ya manop. Sâp yanâmâ Maria yet Yosep yâhâmâ Yuraia hânân kapi âlâ Betelem sâm yan manowot. Kapi yan Mariaŋe Yesu miop. Memu yakât kakŋan lok nombotŋe nâŋgân nâŋgânyeŋe papato yaŋe pitu âlâ tetemu ekmâ yakât topŋe nâŋgâne sâm emetsenŋe ga takamawângembâ takawi. Taka Yerusalem kapiân yâhâm kapi ambolipŋe yuwu sâm âiyongowi. ");
INSERT INTO spl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Yuân naom âlâ teteop yaŋeâmâ hâmbâi yeŋgât lok kutdâ otmâ manbuap yakât towat pitu tetemu ekbin. Naom ya mepaene sâm kapi kâlepŋehembâ takain.” Yâhâmâ wosapâ tap?” Yawu sâm âiyongowi. ");
INSERT INTO spl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yakât den pat ya nâŋgâm lok kutdâ Herotŋe nâŋgâm yâkŋe pato otmâ watnekmâ kawenan kinmap nâŋgâm gorâwaŋgiop. Otmu bukulipŋaŋe gurâ yawuâk nâŋgâm gorâyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herotŋe den pat ya nâŋgâm hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum ningiminiwi ya kerek menduhuyekmâ yuwu sâm âiyongop. “Anitâŋe hâmbâi hâŋgângumu gewuap sâmai yamâ kapi wosan tetewuap yakât topŋe eknohoŋetâ nâŋgâwe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Sâmu sâwi. “Anitâŋe poropete âlâ den ekumu kulemguop ya yawu tap. “Lok kutdâ âlâ tetem galem otbuap yâkât topŋe yuwu. Yâhâmâ Betelem kapi Yuraia hânân yan tetewuap. Yan tetem manmâ Isirae yeŋgât kunyeŋe otmâ galemyongowuap. Yakât otmâmâ kapi yakât nâŋgâŋetâ yahatbuap.” Yawu kulemguop tap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yawu sâŋetâ Herotŋe naom ya tetemu sâp kâlep me tâlâwâk oap, yakât topŋe nâŋgâwe sâm pitu watmâ takawi ya yohâk mem dâiyekmâ yuwu sâm âiyongop. “Pitu ekmâ takawi ya sâp girawuân tetemu ekbi?” Sâmu yakât topŋe ekuwi. ");
INSERT INTO spl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ya sâŋetâ yuwu sâm ekyongop. “Bâiŋ, âlepŋe yen Betelem kapiân ariŋet. Ari naom ya ekmâ taka eknohoŋetâ nâku yawuâk ari ekmâ heroŋe otbaŋgim mepaewom.” Yawu sâm kâityongop. ");
INSERT INTO spl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yawu sâm kâityongomu ba ariwi. Mâtâwân ari endakembâ pitu yaŋe kulet sâm dâiyekmu ari emet mâpuŋan laŋinŋe hâumu siliŋ siliŋ sâmu ekbi. Yaŋe yâhâpŋe torokatmâ yawu hâumu siliŋ siliŋ sâmu ari naom tipiŋe emelan talowân yâhâwi. ");
INSERT INTO spl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Emet kâlehen yâhâ naom ya Mariahât tamboŋan tatmu yelekmâ heroŋe nâŋgâm mepaewi. ");
INSERT INTO spl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Otmu goli, iri sikum, to kukŋe suksuk âlepŋe nanŋe âlâ memâk takawi ya aksihâk gotyetŋan kutakum hâwuruwi. Hâwurum âwurem ariwi. ");
INSERT INTO spl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yawu otmâ im yan awun yuwu ekbi. Herotgâlen purik sâm ari den pat yu ki ekumai sâm Anitâŋe ekyongop. Yawu ekmâ yok pilâm mâtâp âlâengembâ ba kapiyeŋehen ariwi. ");
INSERT INTO spl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Purik sâm âwurem ariŋetâ Yosepŋe aman im, awun ehop. Awun ekmu Anitâhât aŋelo âlâŋe yuwu sâm ekuop. “Sâmune nâŋgâ. Herotŋe Maria nanŋahât hâkâŋ otmâ hilipguwom sâm nâŋgâm mansap. Yawu gârâmâ gâ yahatmâ imbihe naomge meyelekdâ Aihita hânân ari mannomai. Yan ari manŋetâ nâŋe den girawu sâwom yakât mambotmâ mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","15","Otmu emet inânŋan Anitâŋe poropete âlâ den ekumu kulemguop ya yuwu tap. “Nannaŋe Aihita hânân manbuap ya kunmune âwurem takawuap.” Yawu tap. Aŋeloŋe Yosep ekuop yanâk imbiŋe naomŋe meyelekmu Aihita hânân ariwi. Yakât otmâ den, ya bonŋe teteop. ");
INSERT INTO spl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Otmu pitu ekmâ takawi yaŋe Herot kâimboŋmâ ariwi yakât nâŋgâmu bâleop. Nâŋgâmu bâlemu yaŋak Yesu ki manâkgât nâŋgâop. Yawu gârâmâ mâmâŋaŋe memu manmu yambu yâhâp pesuk sâop. Yambu yâhâp yakât kâlehen naom titipâ nombotŋe tetewi. Yakât otmâ Herotŋe tembe lâulipŋe hâŋgânyongomu Betelem kapi otmu kapi tipi tapi ya hâlâŋmâ tai yan nimnaom titipâ teteŋetâ yambu yâhâp ki olop ya gurâ kerehâk yongoŋetâ muwi. ");
INSERT INTO spl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Otmu emet inânŋan umatŋe ya tetewuap ya ekmâ poropete âlâ, kutŋe Yeremia sâm, yâkŋe yuwu sâm kulemguop yakât bonŋe teteop. ");
INSERT INTO spl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Imbi âlâ, kutŋe Lahe sâm, yâkât komot yamâ Lama kapiân tetem mannomai ya yeŋgât nanlipyeŋe yongoŋetâ munomai yakât isem tep bâle otnomai. Otmu sâp yanâmâ lohimbi nombotŋaŋe ya ekmâ biwi nâŋgân nâŋgânyeŋe ki sânduk sâwuap, yawu.” Yâhâ Herotŋe sâmu nanlipyeŋe kerehâk yongoŋetâ muwi yan bonŋe teteop. ");
INSERT INTO spl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Otmu Herotŋe mumu yanâmâ Yosepŋe Aihita hânân manmâ awun ehop. Ekmu yan Anitâhât aŋelo âlâŋe yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mariahât nanŋe hilipguwe sâm kasa otminiop ya emelâk muop. Yakât otmâ imbihe naomge meyelekdâ âwurem Yuraia hânân ariŋet,” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yawu sâm ekumu hân ya pilâm Yosepŋe imbiŋe naomŋe dâiyelekmâ Yuraia hânân âwurewi. Yakât otmâ Anitâŋe poropete âlâ ekumu kulemguop ya bonŋe teteop. ");
INSERT INTO spl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yâhâ Yosepŋe âwurem ari den pat yuwu nâŋgâop. “Herotŋe mumu yaŋak nanŋe kutŋe Akelao sâm, yâkŋe âwâŋahât welâmŋan kinmâ Yuraia yeŋgât lok kutdâ mansap.” Yawu sâŋetâ nâŋgâop. Den ya nâŋgâm nanne hilipgumap sâm gorâwaŋgimu Yuraia hân pilâm ariwe sâm biwi yâhâp olop. Yawu otmâ im awun ekmu Anitâŋe yuwu sâm ekuop. “Gâ Yuraia hân pilâm âlâengen meyelekdâ arinomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yawu sâmu yapâ pilâm Galilaia hânân ari, kapi âlâ, kutŋe Nasaret sâm, yan manbi. Otmu emelâk emet inânŋan poropete âlâŋe den yuwu kulemguop ya bonŋe yan teteop. “Yâhâmâ Nasaret kapi amboŋe.” Yawu kulemguop. Yosepŋe imbiŋe naomŋe meyelekmu Nasaret kapiân ari manbi yakât den ya bonŋe teteop. Otmu yan manŋetâ naom ya lok olop. ");
INSERT INTO spl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yesu lok otmu yanâmâ bukuŋe Yoane Baptis yâkŋe âi topŋe katbe sâm Yuraia hân lok ki manmaiângen ari manop. Ari manmu lohimbi dondâŋe ari ekne sâm ariŋetâ yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Anitâŋe tihityeŋe otbe sâm oap yakât orotmemeyeŋe kiŋgoŋ ya kerek betbaŋgim yâkâlen torokatmâ manŋet.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Otmu den ya ekyongom gaop yakât emet inânŋan poropete âlâ, kutŋe Yesaia sâm, yâkŋe Yoanehât nâŋgâm lohimbi biwiyeŋe pâroŋ sâm kuwihaknomai yakât kulemguop. Den yakât bulâŋe ya yâkâlen teteop. Den ya yuwu. “Lok ki manmaiângen, lok âlâ yan ari manbuap. Lohimbi yâkâlen arinomai ya yuwu sâm ekyongowuap. “Lok kutdâŋe tohowuap yakât kaweŋe mem pitim mâtâp mewaŋgiŋet. Otmu pumŋe lauŋe uk sâm huruŋ sâm, otbuap yamâ kum kilikmâ mem ârândâŋ merândâŋ tuhuŋetâ talâk.” Yawu sâm ekyongop. Den yawu kulemguop yakât bulâŋe ya Yoane yâkâlen teteop. ");
INSERT INTO spl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Otmu Yoaneŋe poropete âi ya topŋe katmâ tuhuwe sâm lok ki manmaiângen ari manop. Otmu senŋe âlâlâ, hâk katipŋe, me petŋe, yamâ soŋgo âlâ, kutŋe kamele sâm, yakât somotŋaŋe mendeŋmâ mem kepeiakmâ manminiop. Otmu pet âlâ topŋe yaŋe mem sâhâm kuratguakminiop. Yâhâ sot yamâ neŋgopdâ, goŋgaraŋ, otmu dopon yawuya neminiop. ");
INSERT INTO spl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Otmu lok ki manmaiângen ari manmu nengât kapi kunŋe Yerusalem ya ambolipŋe otmu kapi tipi tapi Yerusalem hâlâŋmâ manbi, otmu Yoran to nombot nombot manbi ya ambolipŋe nombotŋaŋe yâkâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yâkâlen ari orotmemeyeŋe bâleŋe otmâ gawi ya kerehâk sâm teteakŋetâ Yoran toen mem katyehop. ");
INSERT INTO spl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","8","Yawu otŋetâ Parisaio otmu Sarukaio lok nombotŋaŋe yâkŋe toen mem katnenehâk sâm yâkâlen ariwi. Ariŋetâ yekmâ yuwu sâm ekyongop. “Yenâmâ lok perâkŋe. Otŋetâ bâlem gamap yakât matŋe Anitâŋe meŋet sâmu yakât yeŋeâmâ kiŋgityeŋahât otmâ bâleŋe ya pilai mâne âlepŋe otbâp. Yawu gârâmâ den yan yu nâŋgâŋetâ ki ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yawu otmâmâ yuwu mon nâŋgânomai, “Nenâmâ Awarahamgât komot bulâŋe mansain. Yakât otmâ Anitâŋe nengât ki nâŋgâm bâleningimap.” Yawu ki nâŋgânomai. Yakât yuwu sâmune nâŋgâŋet. Anitâŋe sâmu kât yuŋe Awarahamgât komot tetenomaihât dop tap. Yawu gârâmâ yenâmâ ya imbiâk sâmai. Yakât matŋe hâmbâi menomai. ");
INSERT INTO spl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yakât den âlâen hâum sâmune nâŋgâŋet. Emelâk unam sâtŋe katmu tap. Yâhâ nak âlâhât bonŋe ki kinbuap yamâ kârâm panmu ge mum hâlâlâŋ sâmu kâlâpŋe sewuap. Yenâmâ nak yakât dop otmâ mansai. ");
INSERT INTO spl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yakât otmâ yeŋe orotmemeyeŋe bâleŋe ya sâm tetem Anitâhâlen biwiyeŋaŋe kepeiŋetâ toen mem katyekbom. Lok âlâ irak betnehembâ âi topŋe katbuap yâhâmâ wâtŋe pato tatbaŋgiap. Yakât otmâ nâŋe yâkât itâkat ya gurâ mem kâpekmâ golewaŋgiwomgât dop ki tap. Otmu tânguwomgât dop gurâ ki tap. Nâŋeâmâ yâkât amutgen manmâ yâhâwom. Yâkŋeâmâ Wâtgât mâmâŋahât Heak hâŋgângumu ge mem ketetyekbuap. Nombotŋe manman âiloŋgoân mem katyekbuap. Yâhâ nombotŋeâmâ hâhiwin kakŋan katyekmu mannomai. ");
INSERT INTO spl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Otmu den âlâen hâum sâwe. Yeŋeâmâ sot ekmâ mem kiwilim komot ikŋiâk ikŋiâk katmai. Neneŋahât pat otmap ya konohân mem hâwuruŋetâ tatmap. Yâhâ ki neneŋahât pat otmap yamâ mem pilâmai. Yakât dopŋeâk yâkŋe taka biwinenŋahât topŋe ekmâ mem kâsipnongowuap yakât topŋe yuwu. Yâkât tem lâum manmâ yâhânom yamâ ikŋan mem torokatnenekbuap. Yâhâ nombotŋaŋe yâkât hâkâŋ otmâ betbaŋgim manmai yamâ watyekmu kâlâwân kioŋmâ hâhiwin nâŋgâmbisâi.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sâp yanâmâ Yesuŋe Galilaia hân pilâm Yoaneŋe toen mem katnehâk sâm yâkâlen ariop. ");
INSERT INTO spl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Arimu Yoaneŋe ekmu umatŋe otmu yuwu sâm ekuop. “Gâŋe nâ toen mem katnekdâ ârândâŋ otbâp. Yamâ gâŋe nâhâlen takarâ nâŋgâmune umatŋe oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sâmu sâop. “Anitâŋe sâm kalop ya otmutŋe nâŋgâmu ârândâŋ otbuap. Yakât gâ biwi yâhâp ki ot.” Yawu sâop. Yawu sâmu Yoaneŋe nâŋgâmu ârândâŋ olop. ");
INSERT INTO spl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nâŋgâmu ârândâŋ otmu toen mem katmu ginŋan yâhâ kinmutâ yanâk himbim pâroŋ sâmu Anitâhât Wâtgât mâmâŋahât Heakŋe kembâ hâtgum ge Yesu mâmâŋe otbaŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Gemu yanâk himbimâmbâ Anitâŋe yuwu sâm ekyongop. “Ya ekŋet. Yamâ nine nanne ombe bisine. Nâ biwinaŋe yâkâlâk nâŋgâman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Otmu weke bâleŋe ya yeŋgât kunyeŋe, kutŋe Satan sâm, yâkŋe Yesuhât wâtŋe tatbaŋgiap me bia ya ekmâ biwiŋahât topŋe nâŋgâwe sâm olop. Yakât otmâmâ Anitâhât Wâtgât mâmâŋahât Heakŋe Yesu dâim lok ki manmaiângen ariop. ");
INSERT INTO spl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","3","Yan ari manmâ gamu, hilâm 40 pesuk sâop. Sotgât po waŋgimu wâtŋe houŋ sâop. Yawu otmu yanâk lohotŋe olâk sâm Satanŋe yâkâlen ari yuwu sâm ekuop. “Gâ bonŋanâk Anitâhât nanŋe mansat otmuâmâ kât yu sârâ sot otmu nendâ gekbe. Yawu otdâ yanâmâ gâ bonŋanâk Anitâhât nanŋe bulâŋe mansat sâwom.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ekumu sâop. “Âlepŋe yarâke yamâ benŋe Anitâhât den âlâ yuwu tap. “Anitâŋe haoŋmâ ârândâŋ tihitnenŋe otmap. Yawu gârâmâ sotŋak konok wâtnenŋe miaŋgim manmâ yâhânomgât dop ki tap. Yamâ wongât? Anitâŋe den sâm ningimap ya gurâ lâum yâhânom. Yawu otmunŋe ârândâŋ otbuap yakâ.” Den yawu tap yakât otmâ gâŋe den eknohoat ya ki nâŋgâwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yawu sâmu yanâk Satanŋe dâimu Yerusalem kapi pato yakât opon kâmbukŋahât gimbâŋan yâhâowot. ");
INSERT INTO spl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yâhâm Satanŋe yuwu sâm ekuop. “Anitâŋe sâmu den âlâ kulemguwi ya yuwu tap. “Kâlân kâihan teŋ sâmapgât Anitâŋeâmâ aŋelolipŋe hâŋgânyongomu ge tihitge otŋetâ ki hiliwahowuat.” Den yawu tap. Yawu gârâmâ gâmâ bulâŋanâk Anitâhât nanŋe mansat otmuâmâ yupâ soŋ pilâm kioŋ. Kioŋdâ ki gohowuap. Yâhâ gekmâ yuwu nâŋgâwom. “O, bulâŋanâk lok yuâmâ Anitâhât nanŋe mansap.” Yawu sâwom. ");
INSERT INTO spl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sâmu sâop. “Bâiŋ, den âlâ yuwu tap. “Anitâŋe tihitnenŋe otmap. Yakât otmâ “Ihilâk otbe,” ki sânom.” Den yawu tap yakât otmâ gâŋe den eknohoat ya nâŋgâmune tâŋât oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yawu sâmu pumŋe gip gipŋan dâim yâhâop. Yâhâm yanâmâ hânŋe hânŋe lok kutyeŋe pato ya yeŋgât senŋe âlâlâ dondâ tatyiŋgiop ya tiripgum yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Senŋe âlâlâ tatmâ arap enda eksat? Nâŋe yukât kunyeŋe manman. Gâŋe mepaenekbuat yanâmâ senŋe âlâlâ yu gâhâlâk hârok otbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sâmu sâop. “Main, Anitâŋe den âlâ sâop ya yuwu tap. “Anitâ pato konohâk tap. Yâk konok mepaenom. Otmu yâkât den konohâk tem lâum hoŋ bawaŋgim mannom.” Den yawu tap. Yakât otmâ gâŋe den eknohoat ya lâuwomgât dop âlâ ki tap. Gâ pilânekmâ ari.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yawu sâmu pilâm ariop. Pilâm arimu yanâk himbimâmbâ aŋelo nombotŋaŋe ge tihitŋe otmâ tânguwi. ");
INSERT INTO spl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ya pesuk sâmu yakât kakŋan lok kutdâ âlâ, kutŋe Herot Antipa sâm, yâkŋe Galilaia yeŋgât galem manop. Yâkŋe sâmu Yoane mem pâi emetŋan katŋetâ talop. Pat ya nâŋgâm Yesuŋe yahatmâ Galilaia hânân ariop. ");
INSERT INTO spl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yan ari Nasaret kapi ya wangim kapi âlâ, kutŋe Kapanaum sâm, kapi yan hân âlâ kutŋe, Sewulun yet Naptali sâm, yan ari manop. Otmu Kapanaum kapi yamâ deŋgân âlâ, kutŋe Galilaia sâm, yakât ginŋan tap. ");
INSERT INTO spl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesuŋe kapi yan ariop yakât emet inânŋan Anitâŋe poropete âlâ, kutŋe Yesaia sâm, den ekumu kulemguop yakât bonŋe teteop.Den yamâ yuwu tap. ");
INSERT INTO spl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sewulun otmu Naptali ambolipŋe yamâ Galilaia deŋgân otmu Yoran to nombotgen tai. ");
INSERT INTO spl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yan taiŋe biwiyeŋe maŋguakmâ kopa olop. Otmu omoŋ bâleŋan manmâ mumuhât pat otmâ manmâ gawi. Yawuhât otmâ laŋinŋaŋe siliŋ siliŋ sâm biwiyeŋan hâumu haŋ sâm keterakyiŋgiwuap. Yawu otmu topŋe ekmâ nâŋgâŋetâ biwiyeŋan hâuwuap.” ");
INSERT INTO spl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Den yawu tap. Yesuŋe kapi yan ari manop yan den yakât bulâŋe teteop. Otmu yan ari manmâ yuwu sâm ekyongop. “Anitâŋe tihityeŋe otbe sâm oap. Yakât otmâ otŋetâ bâlemap ya kerek pilâm biwiyeŋe yâkâlen katŋetâ kinbuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sâp yan lok yâhâp imi ata manowot kutyetŋe Simon yet Anderea. Ataŋahât kutŋeâmâ Simon otmu yâkâlâk kutŋe âlâ Petoro sâmai. Yâhâ imiŋeâmâ kutŋe Anderea sâm, yâhâmâ deŋgân tânâmŋan ba iŋan itâŋe toen pilâm kinowot. ");
INSERT INTO spl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yawu otmutâ Yesuŋe yelekmâ yuwu sâm ekyotgop. “Yerâmâ nâhâlen torokatmutâ orowâk manmâ yâhânom. Sâp yiwereŋe yuâmâ iŋan dâim mansawot. Yâhâ nâŋe meyeleksan yanâmâ nâhât wâtnan kinmâ lok meyekmutâ nâhât komolân torokatnomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yawu sâmu yanâk iŋangât senŋe âlâlâ mem manowot ya aksihâk pilâm Yesu walowot. Watmutâ orowâk manbi. ");
INSERT INTO spl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yapâ arain mâne imi ata âlâ mem teteyelekbi, kutyetŋe Yakowo yet Yoane sâm, Yeweri nanyâhâtŋe. Yâhâmâ âwâyetŋe orowâk iŋan itâŋe gârem kinbi. ");
INSERT INTO spl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yawu otmutâ Yesuŋe yotgonmu in yawu âwâyetŋe pilâm yâkâlen torokatmutâ ariwi. ");
INSERT INTO spl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuŋe Galilaia hânân miti emetŋe tatmâ arap yan yâhâm gem Anitâŋe tihitnenŋe oap yakât den pat âlepŋe ekyongop. Otmu lohimbi mesek otmâ umatŋe topŋe topŋe yaŋe mem bâleyekmu manbi ya heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yawu otmâ manop yakât den pat ya hân âlâ, kutŋe Siria sâm, yan pen pen sâm ariop. Pen pen sâm arimu nâŋgâŋetâ yaŋak kapi ambolipŋaŋe yawuâk kundat mesek topŋe topŋe otbi ya meyekmâ yâkâlen takawi. Weke bâleŋaŋe mâŋgâeyehop. Me kopa otbi. Me sen birik yongom manop. Lok yawuya ya ŋerehâk meyekmâ yâkâlen tohoŋetâ heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Heŋgemyongop yakât den pat sâm haŋ tuhuŋetâ Galilaia ambolipŋe, otmu ya hâlâŋmâ kapi bâlâk ŋerek tatmâ arap, ya yeŋgât kutyeŋe pato âlâmâ Dekopoli sâm, ya ambolipŋaŋe yâkâlen tohowi. Otmu âlâmâ Yuraia, ya ambolipŋe. Otmu kapi pato Yerusalem ya ambolipŋe. Otmu kapi tipi tapi Yoran to nombot nombot tatbi ya ambolipŋaŋe menduhuakmâ Yesuhâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Otmu lohimbi dondâŋe menduhuakmâ tatŋetâ Yesu ikŋiâk pumŋan yâhâop. Yâhâ tatmu hoŋ bawalipŋe yâhâŋetâ yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","“Den bonŋe sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Biwi nâŋgân nâŋgânyeŋaŋe yeŋahât nâŋgâŋetâ gemap. Yeŋeâmâ yuwu nâŋgânomai. “Nenâmâ emelâk Anitâŋe himbimgât pat kuningiop. Yakât otmâ yâk orowâk mannom.” Yawu nâŋgâm we âlep nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yâhâ we bâle nâŋgâm isem manmai yenâmâ hâmbâi Anitâŋe mem biwi sânduhân katyekbuap. Yakât otmâ tepyeŋe heroŋe otmu mannomai. ");
INSERT INTO spl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Meŋetâ huruŋ huruŋ otmap ya yen hâmbâi Anitâŋe meyekmu yâk orop manmâ yâhâmbisâi yakât we âlep nâŋgâm manŋet. ");
INSERT INTO spl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Otmu Anitâhât den ya girawu otmâ lâune sâm yakât nâŋgâm manmai. Yâhâmâ hâmbâi Anitâŋe mâmâŋe otyiŋgimu manmâ yâhânomai. Yakât otmâ biwiyeŋe heroŋe olâk. ");
INSERT INTO spl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Buku nombotŋaŋe kasa otyiŋgiŋetâ umam sâyiŋgimai ya gurâ hâmbâi yawuâk Anitâŋe meyekmâ umam sâyiŋgiwuapgât biwiyeŋe heroŋe olâk. ");
INSERT INTO spl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Otmu Anitâhâlen biwi nâŋgân nâŋgânyeŋaŋe kepeim denŋe tiŋâk lâum manmâ gamai yamâ hâmbâi Anitâŋe meyekmu orowâk mannomai yakât biwiyeŋe heroŋe olâk. ");
INSERT INTO spl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Otmu bukulipyeŋe orop biwi nâŋgân nâŋgânyeŋaŋe kepeiakmâ konohâk otmu manmai. Yawu manŋetâ buku nombotŋaŋe hioŋakmâ ahone sâm otŋetâ yan mem lohotŋe tuhuyekmai yamâ hâmbâi Anitâŋe meyekmâ “Nine nanne baratne bulâŋe,” yawu sâwuap. Yakât biwiyeŋe heroŋe olâk. ");
INSERT INTO spl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Otmu Anitâhât den lâum manŋetâ torehenlipyeŋaŋe nâŋgâm bâleyiŋgim mem ge katyekne sâm mem âlâlâ tuhuyekmai. Yawu otyiŋgiŋetâ ki lohotŋe otmai. Yamâ Anitâŋe himbimgât pat kuyiŋgiop. Yakât biwiyeŋe heroŋe olâk. ");
INSERT INTO spl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Otmu nâhâlen biwiyeŋaŋe kepeim manŋetâ lohimbi nombotŋaŋe hakyeŋan sâm mem bâleyeknomai yanâmâ yuwu nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","“Âo, bonŋanâk. Aŋgoân emelâk Anitâhât poropete yawuâk otyiŋgiŋetâ bâleop. Yawuâk sâp yiwereŋe gurâ otningimai. Yawu gârâmâ yakât hâmeŋe hâmbâi himbimân manman kârikŋe menom.” Yawu nâŋgânomai. Yakât otmâmâ biwiyeŋaŋe heroŋe olâk. ");
INSERT INTO spl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yeŋgât topyeŋe teteâkgât den âlâen hâum sâmune nâŋgâŋet. Kâtembe ihim solân hoŋmunŋe yanâmâ sot ya nemunŋe launenŋan memap. Dop yawuâk yenâmâ lohimbi hohetyeŋan manŋetâ yan yekmâ Anitâ heroŋe nâŋgâwaŋginomai. Yâhâ kâtembe heleŋân ki hikum ikainom yanâmâ pâlâmŋe otbuap. Yawu otmu girawu tuhumunŋeâmâ âlâkuâk ukenŋe otbuap? Yamâ ki orotŋe. Pâlâmŋe oap yaŋe âlâ yu me ya tuhumunŋe ukenŋe âlâ tetewuapgât dop bia. Yawu otmâ pâlâmŋe oap sâm pilâmunŋe arimap. ");
INSERT INTO spl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Otmu yakât topŋe tetem heŋgeŋguâkgât den âlâen hâum sâmune nâŋgâŋet. Lohimbi hânŋan kulemŋan mansai ya yeŋgât laŋinŋe otmâ mannomai. Otmu kapi pato âlâ pumŋe sok sohân tatbuap. Yâhâ ambolipŋaŋe kasa yeŋgât senyeŋan âlâ ari misiŋguraknomaihât dop ki tap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Otmu âlâen hâum sâwe. Lambe âlâ saum emet kâlehen katmunŋe kâtâpŋan tatbuapgât dop ya gurâ ki orotŋe. Lambe saum heleŋân gâitmunŋe kinmâ sem laŋinŋe yanâmâ ekmâ gem yâhâmain. ");
INSERT INTO spl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yakât otmuâmâ lambe ya laŋinŋe pilâmap, me kapi pato tetekŋan tatmap yakât dopŋeâk yeŋe Anitâhât den lâum manŋetâ manmanyeŋe ekŋetâ ârândâŋ otmu awoŋnenŋe himbimân tatmap ya mepaenomai. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Otmu âlâ sâmune nâŋgâŋet. Yeŋeâmâ nâhât yuwu mon nâŋgâm mansai. “Anitâŋe girem den âlâlâ Mose ekumu kulemguop. Otmu poropetelipŋe den ekyongomu kulemguwi yamâ mem ge katbe sâm oap.” Nâhât yawu mon nâŋgâm mansai. Nâ ya otbehât bia. Nâŋe ya mem ge katbomgât dop ki tap. Nâŋe sâwi ya lâum manmune bonŋe teteâkgât otman. ");
INSERT INTO spl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yakât yuwu sâwe. Hân himbim tatmâ yâhâwuap. Yâhâ girem den yamâ yawuâk tat tat kârikŋe tatmâ yâhâwuap. Tatmâ yâhâwuap yakât bulâŋe tetewuap yanâmâ, hân himbim otmu senŋe âlâlâ kerek biatmâ metewuap. ");
INSERT INTO spl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yakât otmâ lok âlâ me âlâŋe girem den konohâk loŋgâenomai yakât bulâŋe ki menomai. Otmâmâ buku nombotŋaŋe yawuâk otmâ manŋet sâm meme sâsâ tuhuyekmâ mannomai yaŋe hâmbâi yakât matŋe himbimân yâhâ lok geheŋe otnomai. Yawu gârâmâ lok âlâ me âlâŋe girem den ya biwiyeŋaŋe tiŋâk lâum manŋetgât tânyongom mannomai yaŋe himbimân yâhâ lok yâhâ yâhâŋe otnomai. ");
INSERT INTO spl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yakât topŋe yuwu sâmune nâŋgâm heŋgeŋguŋet. Yeŋe Anitâhât den lâune sâm Mosehât girem den kâsikum ningimai otmu Parisaioŋe otmai yan ki torokatnomai. Yâkŋe den perâkŋe sâmai. Yenâmâ Anitâhât den bulâŋe ya lâum manmâ yaŋak himbim manman yakât bulâŋe menomai. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Otmu Moseŋe girem den kulemguop yakât topŋe ekyongomune nâŋgâŋet. Girem den âlâ kulemguop ya yuwu tap. “Lohimbi âlâ me âlâŋe buku âlâ kuŋetâ mumbuap. Yamâ papatolipyeŋaŋe meyekmâ den âiân katyekŋetâ tosa pato menomai. Yawu.” ");
INSERT INTO spl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yawu gârâmâ yuwu sâmune nâŋgâŋet. Lok âlâ me âlâŋe buku âlâhât nâŋgâm bâlenomai yamâ Anitâŋe yawuâk nâŋgâm bâleyiŋgiwuap. Otmu lok âlâ me âlâŋe buku âlâhât nâŋgâŋetâ gemu mem ge katmai yamâ papatolipyeŋaŋe mem den âiân katyekmâ den yiŋginomai. Otmu lok âlâ me âlâŋe buku âlâhât kuk otmâ mem ge katnomai yamâ kâlâpgât pat otnomai. ");
INSERT INTO spl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Yakât topŋe yuwu sâmune nâŋgâŋet. Yeŋgâlen gâtŋe âlâ me âlâŋe Anitâ hoŋ bawaŋgine sâm otnomai yan buku âlâŋe lok âlâhât nâŋgâm bâlem manbuap ya nâŋgâmu tetemu aŋgoân buku ya orop biwi konohâk otmâ yakât kakŋan hoŋ bawaŋginomai. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yakât âlâ yuwu sâwe. Yeŋgât buku âlâ me âlâŋe kuk otyiŋgim den âiân katyekne sâm kiapgâlen arinomai. Yamâ in yawu ari mâtâwân yekmâ sâm teteŋetâ kaok naŋgaŋginomai. Yâhâ yawu ki otnomai yamâ kiapgâlen den sâm tetemu mem pâi emetŋan katyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pâi emetŋan tatmâ yeŋe ombeân kiâk kârik kârikŋe genomai. Kiapŋe pâi emetŋan tatnomai sâm sâp katyiŋgiwuap ya pesuk sâmu yanâmâ genomai. ");
INSERT INTO spl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Otmu den âlâ sâwe. Moseŋe girem den âlâ kulemguowân yuwu tap. “Lok âlâ me âlâŋe bukulipyeŋe yeŋgât imbilipyeŋe ki yekmâ otnomai.” Yawu tap. ");
INSERT INTO spl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yakât otmâ nâŋe yuwu sâmune nâŋgâŋet. Yeŋgâlen gâtŋe âlâ me âlâŋe biwiyeŋan imbi âlâhât naŋgai yamâ emelâk biwiyeŋaŋe otmâ tâpikguai lok yaŋe tosa miai. ");
INSERT INTO spl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yakât otmâ nâŋe den mâmâŋe âlâ yuwu sâwe. Bulâŋe hâum gusuhutmâ pilânomai ki sâwe. Lok âlâ me âlâŋe hemgât pat otmaihât senŋe nombolâk bâlewuap. Yakât otmâ senŋe bâlewuap yaok hâum gusuhutmâ pilânomai. Wongât? Matŋe umatŋe memaihât. Yawu otmâmâ senŋe âlâ âlepŋe oap yaŋahâk mâtâp tâŋ tâŋâk watmâ manman kârikŋan arinomai. ");
INSERT INTO spl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Otmu hiliwahom hemgât pat otmaihât yawuâk bâtŋe nombot yaŋe otmâ bâlewuap yamâ hârem pilânomai. Wongât? Bâleŋan yan kioŋmaihât. Yawu otmâmâ bâtyeŋe nombotŋe âlepŋeâk tatbuap yaŋe âi tâŋ tâŋâk tuhum manman âiloŋgoân arinomai. Yawu.” Yesuŋe den yan hâum sâop. ");
INSERT INTO spl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Otmu den yuwu torokalop. “Nombotŋaŋe yuwu sâmai. “Lok âlâŋe imbiŋâit manmâ yâhâromawot yamâ nâŋgâmu umatŋe otmu imbiŋe ya imbiâk pilâwuap. Pilâwuap yakât topŋe kulemgum bâtŋan katmu ariwuap.” Yeŋeâmâ yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yakât otmâ nâŋe yuwu ekyongomune nâŋgâŋet. Lok âlâ me âlâhât imbiŋaŋe âlepŋe nanŋe manmap. Ki otmâ tâpikgumap ya imbiâk watmu arimu lok âlâŋe imbi ya hârem membuap yamâ lohimbi ya orowâk tosa mendomawot.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Otmu den âlâ torokatmâ yuwu sâop. “Emelâk tâmbâlipnenŋaŋe yuwu sâm alahuminiwi. “Nen Anitâhât senŋan wuân me wuân otne sâm, sâm kârikŋe tuhunom yakât otmâ yawuâhâk otnom.” Yawu sâminiwi. ");
INSERT INTO spl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yakât nâŋgâmune bâleap. Yawu gârâmâ yiwereŋe yeŋe Anitâhât senŋan wuân me wuân otne sâm, den sâm kârikŋe tuhunomai yan wahap âlâ me âlâhâlen ki gâitmâ sâm kârikŋe tuhunomai. Yâhâ yakât topŋe yuwu tap. Himbimân Anitâhât manman tap. Yawu gârâmâ yeŋe yan ki gâitmâ sâm kârikŋe tuhunomai. ");
INSERT INTO spl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Otmu Anitâŋe hânân tatmap. Yakât otmâ hânân ki gâitmâ sâm kârikŋe tuhunomai. Yerusalem kapi ya gurâ Anitâŋe tatmawâk. Yakât otmâ Yerusalem kapi pato ewan gurâ ki gâitmâ sâm kârikŋe tuhunomai. ");
INSERT INTO spl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yakât yuwu sâmune nâŋgâŋet. Yenâmâ Anitâ bia, yenâmâ lok. Yakât otmâ somotyeŋe iwit kaok ya sâŋetâ heleŋ gâwu gâwu otbuapgât dop ki tap. Me somotyeŋe heleŋ gâwu gâwu ya sâŋetâ iwit kaok tetewuapgât dop gurâ ki tap. ");
INSERT INTO spl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yawu gârâmâ yeŋe wonân me wonân gâitmâ sâm kârikŋe tuhunomaihât dop ki tap. Anitâ konok manmanyeŋahât amboŋe tatmap. Yawu gârâmâ denyeŋe bonŋanâk sânomai. Yawu sâŋetâ nâŋgâŋetâ ârândâŋ otmu pesuk sâwuap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Otmu den âlâ kulemguwi ya yuwu tap. “Lok âlâ me âlâhât kasaŋaŋe senŋe nombot ya hâum gusuhutmâ pilâmu yâku yawuâk matŋe senŋe nombolâk hâum gusuhutbaŋgiwuap. Me lok âlâŋe buku âlâhât sâtŋe ya kum parandaŋ pilâmu yâku yawuâk matŋe kum parandaŋ pilâwuap.” ");
INSERT INTO spl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yawu tap. Yakârâmâ nâŋe yuwu sâmune nâŋgâŋet. Lok âlâ me âlâŋe buku âlâ mem yawu mâŋgâeŋetâ yakât matŋe ki kâpekbuap. ");
INSERT INTO spl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Otmu âlâ sâwe. Lok âlâ me âlâŋe amboŋahât bâleŋe hân meyiŋgim yaŋak kiapgâlen meyekmâ arinomai. Meyekmâ ariŋetâ mâtâwânâk yeŋe hân âlâkuâk yiŋgiŋetâ pesuk sâwuap. ");
INSERT INTO spl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Otmu den âlâen hâum sâmune nâŋgâŋet. Lok âlâ me âlâŋe yeŋe itâ pare miakmâ umat karat otnomai yan yuwu mon sânomai. “Tânnongom itâ pare mem ari ningiŋet.” Yawu sâm ekyongoŋetâ ihilâk denyeŋe nâŋgâm heweweŋâk mem ari katyeknomai. ");
INSERT INTO spl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Otmu lok âlâ me âlâŋe yu me ya ningiŋet sâm ulityongonomai yamâ in yawu yiŋginomai. Me lok âlâ me âlâŋe senŋe âlâlâ ekmâ kandi mene sâm âiyongonomai yamâ ihilâk yiŋginomai. Yawu otmâ manŋetâ ârândâŋ otbuap. ");
INSERT INTO spl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Otmu den âlâ yuwu sâŋetâ nâŋgâmain. “Lok âlâ me âlâŋe buku otyiŋginomai yamâ yengu tep heroŋe nâŋgâm buku otyiŋginomai. Yâhâ lok âlâ me âlâŋe kasa otyiŋgiŋetâ yengu yawuâk kasa otyiŋginomai.” Yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","Yakât nâŋgâmune ki ârândâŋ oap. Yakât otmâ yuwu sâwe. Anitâŋe lohimbi âlepŋe otmâ manmai ya tânyongomap. Otmu lohimbi bâleŋe ya gurâ yawuâk tânyongomap. Yakât otmâmâ yeŋe kasalipyeŋe ihilâk buku otyiŋginomai. Otmu lok âlâ me âlâŋe Anitâŋe mem bâleyehâkgât sait kakyeŋan pilânomai yamâ Anitâŋe lukuleyehâkgât ulitgunomai. Otmu lok âlâ me âlâŋe Anitâŋe mem bâleyehâkgât sait lohimbi kakyeŋan Anitâŋe pilânomai yamâ lukuleyehâkgât ulitgunomai. Otmu lok âlâ me âlâŋe mem âlâlâ tuhuyeknomai yamâ yeŋe ya yeŋgât umam sâyiŋginomai. Umam sâyiŋgim himbim awoŋnenŋe ulitguŋetâ heroŋe nâŋgâyiŋgim nine nanne baratne bulâŋe mansai sâm meyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Otmu yakât âlâ sâwe. Takesi meme lok nombotŋaŋe perâk sâm lohimbi kâityongom tewetsenŋe kombo meyiŋgimai ya yekŋetâ lok bâleŋe otmai. Yâkŋe bukulipyeŋe tânyongom mansai. Otmu lok nombotŋaŋe yen orop buku konok manne sâm tânyongoŋetâ yengu yakât matŋe yâk konok tânyongomai. Yawu otmai yakât nâŋgâmune ki ârândâŋ otmap. Otmu torokatmâ sâwe. Lok nombotŋaŋe nâŋgâm bâleyiŋgimai yamâ yeŋe buku ki otyiŋgimai. Yawu otmai yakât nâŋgâmune yawuâk ki ârândâŋ otmap. ");
INSERT INTO spl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Otmu torokatmâ sâwe. Yeŋe lok nombotŋe orop buku ki oraŋgimai. Yawu otmai yan bukulipyeŋe ya orowâk buku oraŋgimai yamâ nâŋgâmune ki ârândâŋ oap. Lok nombotŋe Anitâhât ki nâŋgâmai yaŋe gurâ yawuâk otmai. ");
INSERT INTO spl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yawuhât yuwu sâmune nâŋgâŋet. Himbim awoŋnenŋaŋe manman uwawapŋe bia otmap. Yengu manman yan torokatmâ manŋetâ ârândâŋ otbuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesuŋe den âlâ yuwu sâm ekyongop. “Bukulipyeŋaŋe yeŋgât nâŋgâyiŋgiŋetâ yahalâkgât yâk yeŋgât senyeŋanâk kinmâ lohimbi umburuk manmai ya tânyongonomai. Lohimbiŋe yeŋahât nâŋgâŋetâ yahatmu yawu otmâ manmai yamâ Himbim Âwâyeŋaŋe yekmu dondâ bâlemap. ");
INSERT INTO spl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yawu gârâmâ lok nombotŋaŋe senŋe âlâlâhât pâin guin otmâ manmai. Yawu manmai yamâ lohimbiŋe nenekŋetâ yahalâk sâm lohimbi nombotŋe biwiyeŋe kurihiakmaiŋe lok senyeŋan kinmâ nembe kalem otyiŋgimai. Yakât otmâ Anitâŋe yakât hâmeŋe ki yiŋgimu menomai. Yuwu sâwuap. “Emelâk yekŋetâ yahalopgât pesuk yap. Âlâmâ ki tap.” Yawu sâwuap. ");
INSERT INTO spl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yakât otmâ yeŋe lok nombotŋe senŋe âlâlâhât pâinmai ya nembe kalem otyiŋgine sâm tihângen kinmâ tânyongoŋetâ yan bukulipyeŋaŋe yakât topŋe ki yekmâ nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yawu otŋetâ Anitâŋe tihângen ekmapŋe yekmâ yakât matŋe âlepŋe yiŋgiwuap.” Yesuŋe yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Den âlâ yuwu sâop. “Yeŋe yok pilâm kinmâ Anitâ ulitgunomai. Yâhâ lok nombotŋaŋe yeŋe topyeŋe kurihim lok senyeŋan kinmâ bukulipnenŋaŋe nengât nâŋgâŋetâ yahalâk sâm sâtŋak Anitâ ulitgumai. Yeŋe yawu otnomai otmuâmâ Anitâŋe hâmbâi yuwu sâm ekyongowuap. “Emelâk lohimbi senyeŋan otŋetâ yan yekŋetâ yahalop. Yakât otmâ pesuk yap. Âlâmâ ki tap.” Yawu sâwuap. ");
INSERT INTO spl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Anitâ ki ekmain yâkŋeâmâ biwinenŋe ekmap. Yakât otmâ yeŋe yâk orop den huhune sâm yan yok pilâm tatmâ ekuŋetâ nâŋgâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yakât nâŋe yuwu sâmune nâŋgâŋet. Yeŋe ulitgune sâm biwi yâhâp otmâ ki ulitgunomai. Lohimbi Anitâhât topŋe ki nâŋgâm eŋgat yâhâp manmaiŋe yuwu nâŋgâmai. “Nenŋe den pâŋe konok gurâ sâmunŋe Anitâŋe ki nâŋgâningimap.” Yawu nâŋgâm den dâiak dâiahâk otmai. ");
INSERT INTO spl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yeŋe yâkŋe otmai yawu ki otnomai. Yeŋe âwâyeŋe ki ulitguŋetâek biwiyeŋahât topŋe emelâk naŋgap. ");
INSERT INTO spl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yakât yeŋe yuwu mon sâm ulitgum mannomai. “Himbim awoŋnenŋe, topge âlâ kândâkdâek tap. Yakât nâŋgâm mepaehekmâ mannom. ");
INSERT INTO spl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gike sâtgât otmâ aŋelolipgaŋe haoŋmâ ârândâŋ hoŋ bahihimai yawuâk nenŋe gurâ tem lâuhihim mannom. ");
INSERT INTO spl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Otmu gâŋe hilâm ârândâŋ tihitnenŋe otmâ dopnenŋanâk ningimat. ");
INSERT INTO spl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Otmu lohimbi nombotŋaŋe mem bâlenenekmâ tai ya yeŋgât nâŋgâm umam sâyiŋgim tosayeŋe pilâyiŋgimain yakât dopŋeâk gâŋe umam sâningim tosanenŋe pilâningiwuat. ");
INSERT INTO spl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Otmu Satanŋe kendâningimu otmunŋe bâlemap sâm ulitgohoaingât mâtâp meningi.” Yeŋe yawu sâm Anitâ ulitgum mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Otmu torokatmâ yuwu sâop. “Lohimbi nombotŋaŋe sâm bâleyiŋgim mem ge katyeknomai ya yeŋgât yeŋe tosayeŋe pilâŋetâ yakât otmâ himbim âwâyeŋaŋe yen gurâ tosayeŋe yawuâk pilâwuap. ");
INSERT INTO spl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yawu gârâmâ lohimbi nombotŋaŋe mem âlâlâ tuhuyeknomai yakât nâŋgâm yeŋe matŋe yiŋgine sâm otmâ mannomai yamâ himbim âwâyeŋaŋe yen gurâ otŋetâ bâlewuap yakât matŋe kâpekyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Den âlâ yuwu sâop. Lok nombotŋaŋe yeŋahâlâk nâŋgâŋetâ yahatmu topyeŋe kurihiakmâ yuwu nâŋgâmai. “Nenŋe Anitâ ulitgunom yanâmâ lohimbiŋe nenekmâ nâŋgâningiŋetâ yahalâkgât sot barahâk tatmâ ulitgunom.” Yawu nâŋgâmai. Yamâ Anitâŋe nâŋgâmu ki ârândâŋ otmu yuwu sâwuap. “Emelâk bukulipyeŋaŋe yekmâ nâŋgâyiŋgiŋetâ yahalop yaŋak pesuk yap. Âlâ ki tap. Yakât otmâ matŋe ki yiŋgiwom.” Yawu sâwuap. ");
INSERT INTO spl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yawu gârâmâ yen yawu ki otnomai. Yenâmâ sot barahâk tatmâ Anitâ ulitgum yan toŋe kun kundenyeŋe piriakmâ somotyeŋe hâluhuakmâ âiloŋgo tatmâ ulitgunomai. ");
INSERT INTO spl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yawu otmâ mannomai yanâmâ yeŋe sot barahâk tatnomai yakât topŋe bukulipyeŋaŋe ki yekmâ nâŋgânomai. Yawu otnomai yamâ awoŋnenŋe Anitâ biwinenŋahât topŋe nâŋgâmapŋe yakât matŋe yiŋgiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesuŋe den âlâ yuwu sâm ekyongop. “Hângât senŋe âlâlâ iri sikum me hop sambe tatyiŋgiap yaŋe biwi nâŋgân nâŋgânyeŋe mem dâimu yanâk arimu manmai. Yamâ talaŋe kumap, me seloŋe hâremap, me bumbumgumap me kombo otmai. Yakât otmâ yeŋe tatningiâk sâm ki aliraŋginomai. Otmu biwiyeŋe yan ki ariwuapgât naŋgan. ");
INSERT INTO spl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","21","Yeŋe biwi konohâk otmâ nembe kalem oraŋginomai. Orotmeme ya otŋetâ Anitâŋe yekmu ârândâŋ otbuap. Otmu himbimgât pat kuyiŋgiop ya bonŋe menomai. Yawuhât Anitâhâlen biwi nâŋgân nâŋgânyeŋaŋe kepeim manŋetâ ârândâŋ otbuap. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Den âlâen yuwu hâum sâop. “Senyeŋe yamâ lambe laŋinŋe yakât dop oap. Senyeŋe ya âlepŋe tatmu yan bam gamai. ");
INSERT INTO spl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yâhâ senyeŋe gara garaŋe pik sâwuap me senyeŋe bok sâwuap, yanâmâ mâtâp tâpikgum hewukŋan kioŋnomai. Yakât yuwu sâmune nâŋgâŋet. Biwiyeŋan Anitâhât laŋinŋe panmap ya bok sâmapgât biwi nâŋgân nâŋgânyeŋe galemahom manman âlepŋeâk torokatmâ manmâ yâhânomai. Biwi nâŋgân nâŋgânyeŋaŋe pâlâmŋe otmâ omoŋe kurihiwuap yamâ manman bâleŋan yâhâ hiliwahonomai. Yakât yeŋe ya otmaihât biwi golâek mannomai. Yawu.” ");
INSERT INTO spl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Den âlâen yuwu hâum sâop. “Lok konokŋe lok kutdâ yâhâp yetgât âi menduhum ki tuhuyitgiwuap. Âlâhât biwiŋaŋe kepeim heroŋe kakŋan tuhuwaŋgiwuap. Yâhâ âlâhârâmâ hâkâŋ kakŋan nep ya ki tuhum heŋgeŋguwuap. Yakât topŋe yuwu sâwe. Hângât manman me iri sikum yan biwiyeŋe arimu manmaiŋe girawu otmâ Anitâ tem lâuwaŋgim mannomai? Yamâ ki orotŋe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yakât topŋe yuwu sâmune nâŋgâŋet. Yeŋgât manman yamâ Anitâŋe emelâk senŋe âlâlâ lâtâkuyiŋgimu manmai. Yakât otmâ yuwu ki nâŋgânomai. “Nenŋe sot wosapâ ba mem tetenom? Me iri sikum me âlâlâ ya girawu mem tetem manmâ yâhânom.” Yawu ki sâm biwi yâhâp otmâ gorâ kakŋan mannomai. ");
INSERT INTO spl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yawu gârâmâ den âlâen hâum yuwu sâmune nâŋgâŋet. Kembâ yekmain. Yâhâmâ âi kalam ki tuhum hâhiwin nâŋgâmai. Yamâ himbim amboŋaŋe haoŋmâ ârândâŋ sot yiŋgimap. Yenâmâ nâihât dop ki mansai. Yenâmâ lok. Otmu yen gurâ yawuâk Anitâŋe haoŋmâ ârândâŋ tânyongom gamap. ");
INSERT INTO spl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yawu gârâmâ yeŋahât girawu mannom sâm yakât ki nâŋgâm kiwiliŋ otnomai. ");
INSERT INTO spl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yeŋe iri sikum me sâŋgum lawa lawa yan biwi nâŋgân nâŋgânyeŋe hikuŋetâ dondâ bâlewuap. Yakât topŋe yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hahop ekmain. Hahop yamâ titi pan pan pilâmu ekmunŋe âiloŋgo loŋgo otmap. Yâhâ emelâk lok kutdâ âlâ, kutŋe Solomon sâm, yâkŋe hâk katipŋe kulem melem mânuŋakmâ manop. Yaŋe hahop suriŋe sekŋe âlepŋe tetemap yakât dopŋe gurâ ki miop. ");
INSERT INTO spl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yâhâ hahop suriŋe ekmunŋe âiloŋgo otmap. Yawu gârâmâ ikŋahâk ki yahatmâ titi pan pan otmâ kuririŋ sâm kinmap. Anitâŋe nâŋgâopgât yawu kinmap. Yiwereŋeâmâ tetem âiloŋgo kinbuap. Yâhâ pek sâwuap yanâmâ hânân ge tâtuk sâwuap. Yenâmâ hahopgât dop ki mansai. Yenâmâ lok. Yakât otmâ biwiyeŋaŋe yuwu ki nâŋgânomai. “Anitâŋe pâlâmŋe otmâ ki tihitnenŋe otmap.” Yawu ki nâŋgâm mannomai. ");
INSERT INTO spl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yakât yuwu sâmune nâŋgâŋet. Bulâŋanâk Anitâŋe haoŋmâ ârândâŋ tihitnenŋe otmâ yâhâwuap. Yakât biwi yâhâp ki otnomai. ");
INSERT INTO spl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yawu gârâmâ lok nombotŋe Anitâhât topŋe ki nâŋgâmaiŋe sâŋgum me iri sikum me senŋe âlâlâ yakât nâŋgâŋetâ yahatmap. Yawu otŋetâ ki ârândâŋ otmap. Yakât otmâ otmaiân yeŋe ki torokatnomai. ");
INSERT INTO spl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yeŋe yuwu nâŋgânomai. “Bulâŋanâk Anitâŋe haoŋmâ ârândâŋ tihitnenŋe otmap.” Yawu nâŋgânomai. Otmu lohimbi nombotŋaŋe Anitâhâlen biwiyeŋaŋe kepeiŋet sâm yâkât den ekyongoŋetâ nâŋgânomai. Yawu otmâ manŋetâ himbim awoŋnenŋe topyeŋe nâŋgâmapŋe dopyeŋan yiŋgimu ki umburuk mannomai. ");
INSERT INTO spl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yeŋe umatŋe topŋe topŋe teteyiŋgiwuawân “Girawu otnom me wuân teteningiwe sâm oap?” Yawu nâŋgâm ki biwi yâhâp otmâ nâŋgâm kiwilinomai. Senŋe âlâlâ hândâhân tetewuap yamâ hândâhângât pat. Otmu âun teteap yuâmâ âungât pat. Yawu gârâmâ torokatmâ manmâ yâhânomân hâmenenŋe kinbuap me bia yamâ himbim awoŋnenŋaŋe ikŋak nâŋgâmap. Yakât ki gorâningimu nenŋe biwi yâhâp otmâ nâŋgâm ketet manmâ yâhânom.” Yesuŋe yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesuŋe den âlâ torokatmâ yuwu sâm ekyongop. “Anitâŋe yeŋgât den sâm hâreyiŋgiwuap. Yakât otmâ yeŋe lohimbi yeŋgât den ki sâm hâreyiŋginomai. Yâhâ yeŋe buku nombotŋe sâm hâreyiŋginomai yamâ yeŋe otnomai yakât dopŋeâk Anitâŋe yen sâm hâreyiŋgimu matŋe menomai. ");
INSERT INTO spl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yâhâ yeŋe senŋe âlâlâ yu me ya otyiŋginomai. Dop ya tâŋ tâŋâk Anitâŋe yen gurâ mem purik katyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yakât topŋe nâŋgâŋetgât den âlâen hâum sâmune nâŋgâŋet. Gâŋe bukuhahât senŋan wahap tipiŋe tap ya ekbuat. Otmu gike sengan gurâ wahap tipiŋe pato tap ya ki eŋakmâ naŋgaŋgimâk bukuhahât yuwu mon sâwuat. ");
INSERT INTO spl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","“Buku. Sengan wahap ya hâluhum pangihiwe.” Gâ yawu mon sâwuat otmuâmâ lok perâkŋe. ");
INSERT INTO spl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gike sengan wahap pato tap ya hâluhum pilakmâ yanâmâ bukuhahât senŋan wahap tatbuap ya hâluhum pilâwaŋgiwuat. Wongât? Yuwuhât. Gâŋe gike orotmemehe bâleŋe yakât nâŋgârâ tâŋât otmap. Yawu gârâmâ bukuhaŋe otmu kiŋgoŋ otmap ya ekdâ dondâ bâlemap. Yawu otbuat yamâ ekmune ki ârândâŋ otbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yâhâ den âlâen hâum yuwu sâm ekyongop. “Nenŋe sotnenŋe sâsâŋe ya um yan buku ondop yeŋgât soso ya waŋmunŋe nembuapgât dop ki tap. Yamâ wongât? Nenŋe um waŋmunŋe nembuap yaŋak purik pilâm nen ningiwuap. Yâhâ âlâen hâum sâwe. Bau hulin hâkŋe ki kilikmain. Hâkŋe ki kilikmaingât otmâ hâknenŋe kukŋe ki nâŋgâmap. Gârâmâ mem lohotŋe tuhune sâm sot um waŋnom yamâ purik sâm ningiwuap. Yakât topŋeâmâ yuwu. Nenŋe Anitâhât pat kukuŋe ya lok ihilâk ki katyiŋginom.” Yesuŋe yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesuŋe yuwu sâm ekyongop. “Yeŋe wuân me wuângât nâŋgâm Anitâhâlen biwiyeŋaŋe kepeim ulitguŋetâ âlepŋe nâŋgâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Otmu âlâen hâum sâwe. Yeŋe buku âlâhât emelan yâhâne sâm, “Wâe tat me?” sâŋetâ nâŋgâyiŋgimu emet kâlehen yâhânomai. Yakât dopŋeâk Anitâ ulitguŋetâ nâŋgâyiŋgiwuap. Anitâhâlen biwiyeŋaŋe kepeim ulitgumai yamâ âlepŋe nâŋgâyiŋgiwuap. Otmu pâin guin otmai yamâ âlepŋe ikŋak mâmâŋe otyiŋgimu biwiyeŋe sânduk sâwuap. Otmu yâkâlen torokatne sâm otnomai ya gurâ âlepŋe meyekbuawâk. ");
INSERT INTO spl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","10","Otmu den âlâen hâum sâmune nâŋgâŋet. Yeŋgâlen gâtŋe âlâ me âlâhât nanŋaŋe po waŋgimu âwâŋe ulitgumu yan âwâŋaŋe ki neneŋe ya waŋbuapgât dop ki tap. ");
INSERT INTO spl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Otmu yen nombotŋaŋe Anitâhât topŋe ki nâŋgâm heŋgeŋgumaiŋe nan baralipyeŋe yawu otyiŋgimai. Anitâ awoŋnenŋe himbimân tatmapŋe nen ikŋiâk ikŋiâk topnenŋe ekmâ nâŋgâmap. Yakât otmâ yeŋe otyiŋgimai ya wangim lok âlâ me âlâŋe yu me yakât ulitguŋetâ ya gurâ tâŋ tâŋâk yiŋgimap. ");
INSERT INTO spl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Den ekyongoan yukât emelâk Mose otmu poropete yaŋe Anitâhât den kâsikum yiŋgiminiwi. Yakât topŋe yuwu tap. Bukulipyeŋaŋe tânyongoŋetgât nâŋgâmai yeŋe gurâ nâŋgâmai dop yawuâk tânyongonomai.” Yesuŋe den yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Den âlâen hâum yuwu sâm ekyongop. Hiliwaho hiliwaho kapi yakât mâtâp yamâ pen penâk kinmap. Lok dondâŋe yan arimai. ");
INSERT INTO spl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yâhâ manman kârikŋahât kapi yakât mâtâp yamâ gâwik gâwikŋe otmu bârâŋ bârâŋ, yanâmâ lok sambeŋe ki arimai. Lok konok konokŋe arimai. Yenâmâ manman kârikŋahât mâtâp ya ekmâ nâŋgâm watmâ arinomai. ");
INSERT INTO spl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Otmu âlâ sâmune nâŋgâŋet. Poropete lok nombotŋaŋe eŋgatyeŋaŋak otmâ den imbiâk sâm ekyongomai. Yaŋeâmâ lohimbiŋe nenekmâ topnenŋe nâŋgâmai sâm moroakmâ orotmemeyeŋe bâleŋe kurihim mansai. Topyeŋe teteâkgât den âlâen hâum sâwe. Lok yamâ orotmeme yawuya otmâ lok hilipyongone sâm otmai. Yakât lok yawuya yeŋgât topyeŋe ekmâ nâŋgâm galemyeŋe tiŋâk otmâ heŋgeŋgunomai. ");
INSERT INTO spl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","18","Yâhâ yeŋe topyeŋe nâŋgâŋetgât den âlâen hâum sâmune nâŋgâŋet. Nak esenŋe omoŋ omoŋ pilâmap yanâmâ bonŋe bâleŋe ki kinmap. Yâhâ nak esenŋe gimbaŋgumap yanâmâ bulâŋe âlepŋe âlâ ki kinmap. Bia yakâ. Yâhâ kiatŋe manam ki otmap. Otmu manamŋe kiat ki otmap. Otmu giŋ gârârâŋ yaŋe ham ki otmap. Otmu hamŋe giŋ gârârâŋ ki otmap. Yamâ topyeŋe ikŋiâk ikŋiâk. ");
INSERT INTO spl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yawuhât nak âlâ bonŋe bâleŋe yamâ kârâm pilâmunŋe mum haraŋ haraŋ otmu kâlâwân umunŋe semap. ");
INSERT INTO spl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yeŋe den yu nâŋgâm heŋgeŋgum poropete lok perâkŋe eŋgatyeŋaŋak otmâ imbiâk sâmai ya yekmâ topyeŋe nâŋgâm heŋgeŋgunomai. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yakât torokatmâ sâwe. Lohimbi dondâŋe mepaenekmâ nohonmâ manmai ya kerekŋe himbimgât pat ya ki otnomai. Himbim awoŋnahât tem lâum manmaiŋeâmâ himbimân yâhânomai. ");
INSERT INTO spl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yâhâ lok dondâŋe sâp pato tâlâhuwuawân yan yuwu mon sâm buiakmâ eknohonomai. “Kutdâ, gâ nâŋgâ. Nenŋe denge sâm haŋ pilâmunŋe ariop. Otmu gâhât âi tuhum weke bâleŋaŋe lok mâŋgâeyehop ya watyiŋgimunŋe gaiakmâ ariwi. Gâŋeâmâ mâmâŋe otningirâ kulem topŋe topŋe mewin.” Yawu sâm buiaknomai. ");
INSERT INTO spl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yawu sâŋetâ nâŋe matŋe yuwu sâm purik pilâyiŋgiwom. “Nâ yeŋe den yai ya nâŋgâmune ki teteap, pâpguan. Yeŋe nâhâlen biwiyeŋaŋe ki kepeim manbi gârâmâ nâhât komot bulâŋe ki otmâ mansai. Yeŋe orotmeme kiŋgoŋ maŋgoŋ manminiwi yakât keterakŋetgât naŋgan,” sâwom. ");
INSERT INTO spl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yakât otmâ den âlâen hâum sâmune nâŋgâŋet. Lok âlâ me âlâŋe nâhâlen gaŋetâ den ekyongomune nâŋgâm heŋgeŋgum lâumaiŋe dop yuwu mansai. Lok nâŋgân nâŋgânyeŋe orop yaŋeâmâ emet tuhune sâm hân kendâm saran kâkâlep yaŋe kânâŋgâm emet tuhuŋetâ tiŋ tiŋ kinbuap. ");
INSERT INTO spl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yawu gârâmâ to mososoŋ mem gâsuk gâsuk tuhumu emet ya ŋiwiŋ ŋiwiŋ sâm ki putuk sâwuap. Yenâmâ dop yawuya. ");
INSERT INTO spl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Âlâmâ purik pilâm sâwe. Lok âlâ me âlâŋe nâhât den nâŋgâŋetâ nahat otmu betbaŋgim manmai, lok ya yeŋgât topyeŋeâmâ yuwu. Lok kopa nombotŋaŋe emetyeŋe tuhune sâm hân kendâm saran kakŋeâk kânâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yawu tuhuŋetâ emet ya saranŋe kandi kinbuap. Yakât otmâ mososoŋ mem gâsuk gâsuk tuhumu emet ya putuk sâm ge imbuap. Yawu.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesuŋe Anitâhât sâtgât den ya topŋambâek sâm tetem ekyongop. Ekyongomu nâŋgâŋetâ sâtŋe otmu yuwu sâwi. “Anitâhât sâtgât topŋambâek yap yuŋe Mosehât girem kâsikum ningimai ya kerek yeŋgât dop ki oap. Yuâmâ âlâ kândâkdâ oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuŋe den ya sâm pesuk pilâm pumŋehembâ gemu lohimbi dondâŋe watmâ ariwi. ");
INSERT INTO spl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Otmu sâp yan lok âlâ hâk bâle tetewaŋgimu manopŋe Yesu ekmâ yan gotŋan bam yuwu sâm ekuop. “Lok pato, gâŋe sârâ kundat topŋe topŋe biatningiwuapgât dop tap. Yawu sâŋetâ naŋgan. Yawuhât nâŋgânihirâ hâk bâle yuŋe pesuk sânihiâkgât naŋgan.” Yawu sâm âikuop. ");
INSERT INTO spl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yawu sâmu walipgum yuwu sâm ekuop. “Nâŋgâhihian. Âlepŋe, walipgohomune hâk bâle biatgihiâk.” Yawu sâm walipgumu yanâk biatbaŋgimu âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yawu otmu Yesuŋe yuwu sâm ekum hâŋgânguop. “Gâmâ otgihian yukât den pat bukulipge nombotŋe ki sâm tetem ekyongowuat. Hotom umai yeŋgâlenâk arirâ hâkge eknomai. Yawu otmâ yan Moseŋe hotom u uhât girem den kulemguop ya lâum Anitâhât hotom umbuat. Hotom undâ gekmâ yuwu sânomai. “O, lok hâk bâle tetewaŋgiop ya emelâk biatbaŋgiap. Girawu otmâ yawu oap?” Yawu sâmâmâ yakât topŋe nâŋgânomai.” Yawu sâm hâŋgângumu ariop. ");
INSERT INTO spl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesuŋe yapâ pilâyekmâ gem ari ikŋe kapi tipiŋe Kapanaum yan yâhâmu Roma tembe lâu yeŋgât kunyeŋe âlâŋe yâkâlen ari yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Lok pato, nâhât hoŋ bawa âlâ mesek sâtŋan kinsap. ");
INSERT INTO spl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sâmu sâop. “Âlepŋe ari heŋgeŋguwom.” ");
INSERT INTO spl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sâmu sâop. “Lok pato, nâ lok âlepŋe bia. Yakât gâŋe nâhât emelan ariwuatgât ki naŋgan. Yuânâk tatmâ denâk sârâ hoŋ bawane ya âlepŋe otbuapgât naŋgan. ");
INSERT INTO spl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yâhâ nâ nineâmâ lok patonahât tem lâuwaŋgim yâkât amutgen manman. Gârâmâ patonaŋe nâ gurâ buku nombotŋe yeŋgât kunyeŋe sâm nihimu manman. Yakât otmâ nâŋe tembe lâulipne âlâ me âlâ yuken me yaken ariŋet sâmune âlepŋe nâhât tem lâunihim arimai. Me âi wuân me wuân tuhuŋet sâm âi yiŋgiman ya gurâ âiloŋgo tuhumai. Gâmâ lok pato. Yakât otmâ denâk sârâ âlepŋe otbuapgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Den yawu sâmu Yesuŋe nâŋgâmu ewe membe olop. Nâŋgâmu ewe membe otmu Isirae lohimbi betŋan sâwi ya yuwu sâm ekyongop. “Wâtne pato tatnihiap yakât nâŋgâm Roma lok yuŋe biwi yâhâp ki oap. Yakât yuwu naŋgan. Isirae yeŋgâlen gâtŋe âlâ me âlâŋe lok yuŋe oap yuwu âlâ ki otŋetâ yekman. Lok yuŋe nâhâlen biwiŋaŋe kepeim den yap yu ekmune âiloŋgo oap. ");
INSERT INTO spl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yakât otmâ yuwu sâmune nâŋgâŋet. Hâmbâi lok topŋe topŋe, emetsenŋe ga takamap yakembâ otmu purik sâmap yakembâ taka himbimân yâhâ tâmbâlipyeŋe Awaraham, Isaka otmu Yakop yâk orop hâk sânduhân tatmâ heroŋ maroŋ manŋetâ Anitâŋe tihityeŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yawu gârâmâ emelâk Anitâŋe yeŋgât sâm pat kuyiŋgiop ya lok ondop mem yiŋgimu yeŋeâmâ hâmbâi belângen ari hem nâpumŋan kioŋmâ hâhiwin bâleŋe nâŋgâm hu halak tuhunomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Benŋe tembe lâu ya yuwu sâm ekuop. “Gâŋe biwihe nâhâlen katsat yakât bulâŋe emetgan ari tetemu ekbuat.” Yawu sâmu ba ariop. Sâp yanâk yâkât hoŋ bawa mesek kuop ya hâkŋe sânduk sâmu âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ya pesuk sâmu yapâ ari Petoro hewunŋe mesek pato kumu hâkŋe kâlâp otmu talop. Yakât Yesu ekuŋetâ emelan yâhâop. ");
INSERT INTO spl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yâhâ wâimu kundatŋe biatmu hâkŋe sânduk sâop. Yawu otmâ sot um yiŋgimu newi. Um yiŋgimu nem tatŋetâ yan emetsâpŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Emetsâpŋe otmu sombemân yâhâ kinop. Kinmu kapi ambolipŋe weke bâleŋaŋe mâŋgâeyehop ya lâuyekmâ yâkâlen ariwi. Yawu otŋetâ Yesuŋe sâmu weke bâleŋaŋe ya yeŋgâlembâ gaiakmâ ariwi. Yâhâ kundat otbi ya gurâ yawuâk yâkâlen dâiyekmâ ariŋetâ heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yawu olop yamâ emet inânŋan poropete âlâ, kutŋe Yesaia sâm, yâkŋe den kulemguop ya yan bonŋe Yesuhâlen teteop. Yamâ yuwu. “Mesek otmu hâhiwin topŋe topŋe teteningiop yamâ yâkŋe mâmâŋe otningimu tisi mesek biatningiop.” Den yakât bulâŋe teteâkgât Yesuŋe lohimbi kiŋgitŋe orowâk mem heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mem heŋgemyongomu lohimbi dondâŋe mem hawam mewam tuhuwi. Yawu otŋetâ kapi ya pilâm âlâengen arine sâm yakât hoŋ bawalipŋe ekyongomu waŋga mem deŋgân hâtikgum ariwi. ");
INSERT INTO spl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yawu otŋetâ Mosehât girem den kâsikum ningiminiwi âlâŋe yuwu sâm ekuop. “Gâ yuken yaken otbuat yamâ nâ orowâk.” ");
INSERT INTO spl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sâmu sâop. “Nine topne hâum pâpguatgât yuwu sâmune nâŋgârâ keterahâk. Soŋgoâmâ nak duwiŋan imai. Yâhâ nâiâmâ nak kakŋan kerem tatmai. Yâhâ nâmâ Anitâŋe hâŋgânnohomu ge mansan yamâ emet âlâ ki tatnihiap. Yakât otmâ gâ orowâk arinom otmâmâ girawu otnom?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yawu sâmu yanâk lok âlâ yâkâlen ba yuwu sâm ekuop. “Lok pato, nâ awoŋne bâleap yakât gâ nâŋgânihirâ ari kurihiwe. Kurihim âwurem takamune orowâk arinom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sâmu sâop. “Yawu ki tap. Lohimbi nombotŋe pâlâmŋe biwi manmâ Anitâhât den ki lâum manmai yaŋe kurihiŋet. Yâhâ gâmâ yiwereŋe nâ orowâk arirehât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Den yawu sâm tiŋ pilâm yahatmâ hoŋ bawalipŋe meyekmu orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Arim tatŋetâ deŋgân tânâmŋan siru pato pilâmu to dondâ bâleop. ");
INSERT INTO spl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yawu otmu waŋga kâlehen to gemu guhulakbe sâm olop. Guhulakbe sâm olop yan Yesu waŋga hâmeŋan aman pâlâmŋe iop. Aman im tatmu hoŋ bawalipŋaŋe mândem yuwu sâm ekuwi. “Pato, toŋe harannongomap. Yakât yahatmâ tânnongo,” sâm mândewi. ");
INSERT INTO spl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mândeŋetâ sâop. “Wongât yen kiŋgityeŋahât oai? Anitâŋe haoŋmâ ârândâŋ tihitnenŋe otmap yakât topŋe yen ki naŋgai me? Wongât biwi yâhâp oai? Nâŋe yeŋgât galem tatman yakât yu ya otŋetâ tânyongowomgât dop ki tap” yawu mon naŋgai?” Yawu sâm yahatmâ siru ya kuwaŋgimu to yaŋe nâŋ nâŋ sâop. ");
INSERT INTO spl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nâŋ nâŋ sâmu ekŋetâ sâtŋe otmu yuwu sâwi. “Bâe, lok yukât topŋe girawu? Siru kuwaŋgimu denŋe lâum sânduk sâmu to yaŋe nâŋ nâŋ yap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","To nâŋ nâŋ sâmu deŋgân ya hâtikgum ba nombot endaken kapi âlâ, kutŋe Gerasene sâm, yan ariwi. Yan ari waŋgaembâ lâum kioŋmâ ariŋetâ lok yâhâp sumângembâ takamutâ eŋakbi. Yâhâ ya yetgât topyetŋeâmâ yuwu. Yâhâmâ weke bâleŋaŋe mâŋgâeyelekmu sâp kâlep manmâ gaminiowot. Lohimbi dondâŋe mâtâp tete yelekmâ kiŋgityeŋahât otmâ ge tiok taok otmâ mâtâp âlâengembâ ba ariminiwi. Topyetŋe yawu. ");
INSERT INTO spl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yesu orop eŋakbiân weke bâleŋe mâŋgâeyelekbiŋe yuwu sâm ekuwi. “Gâ Anitâhât nanŋe mansat. Gârâmâ gâŋe hâhiwin umatŋe ningiwuat yakât sâp ki tâlâhuap. Yakât gâŋe girawu otningiwe sâm takat?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yâhâ ya hâlâŋmâ bau kiŋgitŋe orowâkŋe tomot tuhum kinbi. ");
INSERT INTO spl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tomot tuhum kinŋetâ yekmâ yuwu sâm Yesu ekuwi. “Gâŋe watnenekbe sâm oat otmâmâ âlepŋe watnenekdâ bau enda yeŋgâlen ari karaknom.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sâŋetâ sâop. “Âlepŋe naŋgai yawuâk otŋet.” Yawu sâmu yâk yetgâlembâ gaiakmâ bau ya yeŋgâlen ge karakbi. Yawu otŋetâ bau yaŋe sururuk sâm ba hem patoembâ tâwoŋ sâm deŋgânân kioŋetâ haranyongop. ");
INSERT INTO spl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Haranyongomu yan bau galemyongom manbiŋe ekmâ sururuk sâm ari kapi ya ambolipŋe ekyongowi. ");
INSERT INTO spl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ekyongoŋetâ nâŋgâm kuk otmâ Yesuŋe pilâyekmâ âlâengen ariâkgât nâŋgâm kapiyeŋambâ toho yakât ekuwi. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yawu nâŋgâm ekuŋetâ Yesuŋe hoŋ bawalipŋe meyekmu kapi ya pilâm waŋgaen yâhâm âwurem ikŋe kapi, kutŋe Kapanaum, yan ariwi. ");
INSERT INTO spl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ari kinŋetâ yapâ lok pareŋe âlâ mem gerelân katmâ lâum yâkâlen ariwi. Lâum ariŋetâ Yesuŋe biwiŋahât topŋe ekmâ nâŋgâm lok pareŋe ya yuwu sâm ekuop. “Anitâŋe tosahe yiwereŋe pilâhihiap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yawu sâmu Mosehât girem den kâsikum ningiminiwi nombotŋaŋe den sâop ya nâŋgâŋetâ bâlemu yuwu sâwi. “Anitâ ikŋak konok tosanenŋe âlepŋe pilâningimap. Lok yuŋeâmâ Anitâ mem ge katmâ wangiwe sâm oap. Yawu otmu ki ârândâŋ oap.” Yawu sâm Yesuhât nâŋgâŋetâ bâleop. ");
INSERT INTO spl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nâŋgâŋetâ bâlemu biwiyeŋahât topŋe ekmâ yan yuwu sâm ekyongop. “Yeŋe nâ nekŋetâ lok bâleŋe otmu yan biwiyeŋaŋe yawu naŋgai. Ya nâŋgâmune ki ârândâŋ oap. Yakât yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wuân âi tuhumune ekŋetâ dopŋan otbuap? Yuwu mon sâm ekuwom. “Nâŋe tosahe pilâhihian.” Yawu sâwom me? Me “Gâ getek yahatmâ geretge lâuakmâ ari,” sâwom. ");
INSERT INTO spl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yakât nine topne yuwu sâmune nâŋgâŋet. Nâ Anitâŋe hâŋgânnohomu gewangât tosayeŋe pilâyiŋgim mansan. Anitâŋe âi sâm nihiop yukât topŋe ekmâ nâŋgâŋetgât oan.” Yawu sâm ekyongop. Yawu sâm ekyongom topŋe ekmâ keterakŋetgât lok pareŋe ya yuwu sâm ekuop. “Gâ yahatmâ geretge lâuakmâ emetgan ari.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yawu sâmu senyeŋanâk yahatmâ geretŋe lâuakmâ ariop. ");
INSERT INTO spl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Arimu lohimbi nombotŋaŋe Yesuŋe Anitâhât wâtŋan kinmâ âi miop ya ekŋetâ âlâ kândâkdâ olop. Yawu otmuâmâ “Lok yu ki orotŋe oap.” Yawu sâwi. Yawu sâm yan Anitâ mepaewi. ");
INSERT INTO spl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuŋe yapâ arimâmâ lohimbi yeŋgâlen takesihât tewetsenŋe meyiŋgiminiwan nâhâlen tohop. Nâmâ Mataio. Yan tatmune yâkŋe nekmâ yuwu sâm eknohop. “Nâhâlen torokatdâ orowâk mandehât naŋgan.” Yawu sâm eknohomu nâŋe yanâk yahatmune orowâk ariwit. ");
INSERT INTO spl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ari nâhât emelan yâhâ sot nende sâm otmâ sâmune kâlehen yâhâwit. Yawu otmutŋe hoŋ bawalipŋe kerehâkŋe net watnelekmâ gaŋetâ orowâk kâlehen yâhâwin. Tatmunŋe sâp yanâk bukulipne otmu lok nombotŋe ândâp kârik otmâ Mosehât girem den ki lâum manminiwi yâkŋe nengâlen gaŋetâ orowâk menduhuakmâ sot newin. ");
INSERT INTO spl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nem tatmunŋe Parisaio lok nombotŋaŋe nen aposolo nenekŋetâ ki ârândâŋ otmu âinongowi. “Wongât Yesuŋe lok bâleŋe yen orop menduhuakmâ lau konok niai?” Yawu sâm âinongowi. ");
INSERT INTO spl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Yawu sâm âinongoŋetâ Yesuŋe den ya nâŋgâm yuwu sâm matŋe ekyongop. “Aŋgoân topŋe katmâ Anitâŋe sâmu lok âlâŋe kulemguop yamâ topŋe yuwu. “Yeŋe orotmemeyeŋe bâleŋe me tosayeŋahât otmâ hotom ya uŋetâ nâŋgâwan. Yamâ âlepŋe oap. Yaŋe yu ya âlâ ki oap. Otmu yamâ wahap tâŋât. Gârâmâ yeŋe biwiyeŋaŋe konohâk otnomai yamâ ârândâŋ otbuap.” Yawu sâop. Den topŋe yawu tap. Yakât otmâ den âlâen hâum sâmune nâŋgâŋet. Lok mesekyeŋe biaŋe dokta yeŋgâlen ki arimai. Lok kundatyeŋe orop me hâhiwin teteyiŋgimapŋeâmâ dokta yeŋgâlen arimai. Yakât topŋe yuwu sâmune nâŋgâŋetâ keterahâk. Yeŋgâlen gâtŋe nombotŋaŋe yuwu sâmai. “Nen lok âlepŋe, orotmeme âiloŋgo loŋgo otmâ mansain.” Yawu sâmai. Yawu gârâmâ lok yawuya yeŋgât sâm ki gewan. Gârâmâ nâmâ yeŋe lok bâleŋe sâm betyongoŋetâ manmai yawuyaŋe Anitâhâlen biwiyeŋe katŋetgât gewan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yawu sâmu Yoane Baptis orop manbiŋe ga yuwu sâm Yesu âikuwi. “Nen Anitâŋe nâŋgâningimu âlepŋe olâkgât sâp sâsâŋan sot barak manmain. Otmu Parisaio lok yawuâk otmai. Yâhâ gâhât hoŋ bawalipgaŋeâmâ sot kutakamai?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sâŋetâ sâop. “Yakât den âlâen hâum sâmune nâŋgâŋet. Lok patoŋe imbi miakbe sâm bukulipŋe meyekmu orowâk menduhuakmâ sot um nem heroŋe otnomai. Sot um nem heroŋe otnomaiân sot barak ki tatnomai. Yâhâ hâmbâi mâne kasalipyeŋaŋe taka bukuyeŋe kuŋetâ mumbuap yanâmâ eŋgat hako nâŋgâm sot barak mannomai. Yakât yuwu sâmune nâŋgâŋet. Yiwereŋeâmâ nâ orowâk mansain yakât otmâ tep âlep nâŋgâmai. Yâhâ hâmbâi mâne nâ nohoŋetâ mumbom. Sâp yan eŋgat hako nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yawu sâm kinmâ orotmeme embâŋân aŋgoân otmâ manmâ gawi ya otmu ikŋe orotmeme âiŋe kâsikum yiŋgiop yaŋe ki lâuahowot. Yakât yâhâp yâhâp ya menduhum lâunomaihât dop ki olop. Yakât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâm ekyongop. “Nenŋe sot me salup me âlâlâ hâpu golâenâk mânuŋmâ titâkgum umunŋe sem heŋgeŋgumap. Yâhâ nenŋe hâpu tekaŋan mânuŋmâ kâlâwân katmain yamâ hâpu tekaŋe ya sem huhumu sot yamâ golâ kinmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Otmu âlâen yuwu hâum sâop. “Otmu imbi âlâŋe lepa dorokum tâk masipguwuap. Masipgum katmu sâp kâlep tatmâ hâŋgiŋe otbuap. Otmu yakât kakŋan tâk âiŋe orop menduhum lowaim iri osowuap. Iri osomâmâ senŋe âlâlâ mem mânuŋbuawân yan dâimu tiririk sâmu tok sâwuap. Yakât otmuâmâ tâk âiŋaŋak menduhum lowaimain. Lowaim iri osom senŋe âlâlâ umatŋe mânuŋnomân yamâ dâimu ŋirik ŋirik sâm ki tok sâwuap. Yâhâ hâŋgiŋe otmu âiŋe menduhunom yamâ dâimu titâk sâwuap. Yamâ ki orotŋe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuŋe den yawu sâm ekyongom kinmu yanâk Yura nengât patonenŋe âlâŋe ga yuwu sâm ekuop. “Baratne yiwereŋeâk pârâk sân sânâk bâleap. Yakât gâŋe mem yahatbuatgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yawu sâmu Yesuŋe yahatmâ nen hoŋ bawalipŋe menenekmu ariwin. Arimunŋe imbi âlâ watnenehop yâkât topŋeâmâ yuwu. ");
INSERT INTO spl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Imbilipnenŋe emetsenŋe ekmai dop yawu ki olop. Yâhâ imbi yuâmâ emetsenŋe ekmâ yâhâmu yambu kâiân yâhâp pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yâhâ imbi yaŋe Yesuhât betŋan watmâ ari biwiŋaŋe yuwu nâŋgâop. “O nâ Yesu tetekŋan mem wâiwom yamâ ki orotŋe. Aŋulakmangât ki wâiwom. In sâŋgumŋeâk walipgum âlepŋe otbe.” Yawu nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yawu nâŋgâm watmâ arimu Yesuŋe sâŋgum bârârâhâk kâlep mânuŋahop. Yan ari sâŋgum potonŋan in walipgumu eŋgatŋe kakŋambâ olelem ekmâ yuwu sâop. “Wa, toune, gâŋe yiwereŋe biwihaŋe nâhâlen kepeiat. Yakât otmâ Anitâŋe nâŋgâhihimu hepge saŋ yap.” Yawu sâm ekuop. Yawu sâmu yanâk âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nenŋe yapâ gem ari lok galemŋahât baratŋe bâleop yâkât emet ya hâumâk otmâ ariwin. Arimunŋe emet yakât kâlehen lohimbi dondâŋe kahân tatmâ isem we bâle pato nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yawu otmâ isem tatŋetâ yuwu sâm ekyongop. “O, baratyetŋe yuâmâ ki bâleap. In aman pâlâmŋe iap. Yakât yen yahatmâ yaehen kioŋet.” Yawu sâm ekyongop. Yawu sâm ekyongomu nâŋgâŋetâ nahat otmu giriŋbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Giriŋbaŋgiŋetâ senŋan geŋetâ hâŋgânyongomu yaehen gewi. Geŋetâ mumuŋambâ mem yahalop. ");
INSERT INTO spl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Otmu kulem miop yakât den pat ya sâm haok tuhuŋetâ kapi gotŋe tete ya ambolipŋaŋe den pat ya nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuŋe kapi ya pilâm arimu lok yâhâp senyetŋe bok sâsâŋe yaŋe kulem miop yakât den pat nâŋgâm betŋan ari yuwu sâm ekuowot. “Wâe, Dawitihât sen. Netgât tepge nâŋgâ. Gâŋe âlepŋe tânnotgowuatgât dop tap me bia? “Yawu sâowot. ");
INSERT INTO spl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yawu sâm âikum yaŋak Yesuhât kâiŋe munŋeâk nâŋgâm watmâ emelan gam yâhâowot. Yâhâmutâ yuwu sâop. “Nâŋe sâmune senyetŋe suk sâmu emet galemŋe ekde sâm naŋgawot, me bia?” Sâmu sâowot. “Oŋ, yawu naŋgait.” ");
INSERT INTO spl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yawu sâmutâ senyetŋan wâim yuwu sâop. “Nâhâlen biwiyetŋaŋe nâŋgâm kepeiawot yakât bulâŋe teteyitgiâk.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yawu sâmu senyetŋe suk sâmu emet galemŋe ehowot. Ekmutâ yuwu sâm ekyotgop. “Kulem yetgâlen tetemu eksawot yu ki sâmutâ pen pen sâmu nâŋgânomai.” ");
INSERT INTO spl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yawu sâm ekyotgop yamâ iliwetmâ den pat ya sâm tetemutâ pen pen sâm arimu lohimbi dondâŋe nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yâhâ Yesu pilâm arimutâ yanâk lok âlâ Yesuhâlen mem takawi. Mem taka yuwu sâwi. “Lok yuâmâ weke bâleŋaŋe mâŋgâemu den pâpgum kopa otmâ manmap,” sâwi. ");
INSERT INTO spl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yawu sâŋetâ weke bâleŋe watmu gaiakmâ arimu lauŋe hâreakmu den huhuop. Den huhumu ekmâ kinbiŋe alahu gulahu otmâ yuwu sâwi. “Nen embâŋâmbâek kulem yuwuya âlâ ki tetemu ekmâ gamain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yawu otmuâmâ Parisaio nombotŋaŋe Yesuŋe kulem miop ya ekmâ nâŋgâŋetâ bâlemu yuwu sâwi. “O, yuâmâ weke bâleŋe ya yeŋgât amboyeŋaŋe mâmâŋe otbaŋgiap. Yakât otmâmâ weke bâleŋaŋe den tem lâuwaŋgim gaiakmâ arim kinsai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuŋe kapi ya pilâm kapi tipi tapi tatmâ arap ya biwiŋan miti emetŋe tap dopŋan yâhâm gem Anitâŋe tihityeŋe otbe sâm oap yakât den pat âlepŋe ekyongom manop. Yâhâ lohimbi nombotŋe mesek me hâhiwin topŋe topŋe teteyiŋgiop ya gurâ heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Heŋgemyongom yekmâ biwiŋaŋe yuwu nâŋgâop. Lama galemyeŋe biaŋe ihilâk mahilâk manmai yakât dopŋeâk lohimbi gurâ amboyeŋe bia otmu ihilâk mahilâk manmâ gai. Yawu manŋetâ yekmâ tepŋe nâŋgâyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tepŋe nâŋgâyiŋgim nen hoŋ bawalipŋe den âlâen hâum yuwu sâm eknongop. “Kalamân sot pato tap. Yâhâ bonŋe mem menduhunomaihât lok getek âlâ. ");
INSERT INTO spl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yakât otmâmâ yeŋe kalam amboŋe, Anitâ, ulitguŋetâ âlâkuâk lok katyekbuap. Katyekmu yen orowâk tânahom nep ya tuhunomai.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuŋe nen hoŋ bawalipŋe kâiân yâhâp menenekmu bamunŋe yuwu sâm eknongop. “Weke bâleŋaŋe lohimbi mem mâŋgâeyekbuap yamâ yeŋe watyiŋginomai. Me mesek me hâhiwin topŋe topŋe teteyiŋgimu heŋgemyongonomai.” Yawu sâop. Yawu sâm ningim yan mâmâŋe otningiop. ");
INSERT INTO spl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Otmu nen aposolo menenehop nengât kutnenŋe yamâ yuwu. Simon yâkât kutŋe âlâ Petoro sâm, imiŋe Anderea, otmu Yeweri nanyâhâtŋe, kutyetŋe Yakowo yet Yoane. ");
INSERT INTO spl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Otmu âlâmâ Pilip, otmu Batolomaio, Toma, otmu âlâmâ nâ Mataio. Nâmâ aŋgoân lok yeŋgâlen takesihât tewetsenŋe meminiwan. Otmu âlâ Alipaio nanŋe Yakowo, âlâmâ Taraio. ");
INSERT INTO spl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Âlâmâ Simon, yâhâmâ komot âlâen gâtŋe topyeŋe yuwu. Roma lok ya yeŋgât hâkâŋ otmâ watyekne sâm otminiwi yan gâtŋe. Otmu bâiŋeâmâ Yurasi yamâ Karioto kapiân gâtŋe. Yâkŋeâmâ Yesuhât betŋehen kioŋop ya. ");
INSERT INTO spl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Otmu Yesuŋe nen hoŋ bawalipŋe den âlâen hâum yuwu sâm eknongom hâŋgânnongop. “Lama ya yeŋgât galem ki otŋetâ yanâmâ hiliwahomai. Dop yawuâk Isirae lohimbi nombotŋe yu hiliwahone sâm oai yakât yâk yeŋgâlen tâŋ tâŋâk ari tânyongonomai. ");
INSERT INTO spl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tânyongom Anitâŋe tihityeŋe otbe sâm oap yakât den pat ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yawu gârâmâ yeŋe aŋgoân Samaria otmu pâku lohimbi yeŋgâlen ari nep ki tuhunomai. Isirae ambolipŋe nenŋanâk yâhâm gem nep tuhunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yawu sâm yan nep denŋe yuwu sâm ningiop. “Lohimbi munomai yawuya sâŋetâ mumuŋambâ yahatnomai. Me nombotŋe kundat otmâ mansai ya mem heŋgemyongonomai. Me hâk bâle otmâ mansai ya gurâ mem heŋgemyongonomai. Me weke bâleŋaŋe mâŋgâeyekmâ mansai. Yawuya watyiŋginomai. Yawu otyiŋginomai yakât hâmeŋe mene sâm ki nâŋgânomai. Ninak mâmâŋe otyiŋgim yakât hâmeŋe ki meman yakât yengu yawuâk hâmeŋe ki menomai. ");
INSERT INTO spl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Yâhâ âi topŋe katne sâm bât barak arinomai. Howan ki mem tinaŋgunomai. Me hâk katipŋe me pet ya hourâ hourâ gurâ ki miakmâ arinomai. Me kâi katipŋe katmâ yakât kakŋan âlâ ki menomai. Hâkyeŋan tatbuap yawuâhâk. Me itâkat ki golenomai. Me natik ki miakmâ arinomai me tewetsenŋe hakyeŋan ki tatbuap. Lok âlâ me âlâŋe nep tuhunomai yakât hâmeŋe sâm yiŋgiŋetâ meŋetâ ârândâŋ otbuap. Yakât otmâ inâk arinomai. ");
INSERT INTO spl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Otmu aŋgoân hâŋgânyongomune arinomai yan kapi ambolipŋaŋe yuwu mon sânomai. “Wongât takai yakât topŋe sâŋetâ nâŋgâne.” Yawu sâm âiyongoŋetâmâ yeŋe âlepŋe topŋe ekyongonomai. Topŋe ekyongoŋetâ lok âlâ me âlâŋe emelan dâim yâhâ katyekŋetâ yanâk tatnomai. ");
INSERT INTO spl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dâim yâhâ katyekŋetâ yanâmâ yuwu sânomai. “Anitâŋe tihityeŋe otmu yâkât wâtŋan kinmâ yâhâm heroŋe kakŋan mannomai.” Yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Otmâ yâkŋe yekmâ heroŋe nâŋgâyiŋgim denyeŋe nâŋgâne sânomai yamâ âlepŋe yâk yeŋgâlen bulâŋe tetewuap. Yâhâ nombotŋaŋeâmâ denyeŋe nâŋgâŋetâ gemu betyiŋginomai. Yawu otyiŋgiŋetâ yengu yawuâk betyiŋgim arinomai. ");
INSERT INTO spl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yâhâ kapi âlâen ari den ekyongoŋetâ nâŋgâŋetâ gemu bet pilânomai. Nâŋgâŋetâ gemu bet pilânomai yamâ hâmbâi Anitâŋe matŋe umatŋeâk yiŋgiwuap. Yakât otmuâmâ yeŋe kâiyeŋan wahap me bokosok me yu ya horatbuap yamâ tâlim gik beretek meŋetâ gewuap. Ya gemu betyiŋgim pilâyekmâ arinomai. Ariŋetâ towat ya ekmâ kâi katsap yawu nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yakât yuwu sâmune nâŋgâŋet. Sâp patoen Anitâŋe Sotom otmu Gomora kapi ambolipŋaŋe orotmemeyeŋe bâleŋe otminiwi yakât matŋe yiŋgimu menomai. Gârâmâ yeŋe kapi âlâen ariŋetâ betyiŋginomai. Yamâ ya yeŋgât tosa ya tatyiŋgiwuap. Yakât matŋe Anitâŋe hâmbâi umatŋe dondâ yiŋgiwuap.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Otmu Yesuŋe nen topnenŋe naŋgaŋginehât den âlâen hâum yuwu sâm eknongop. “Lama yamâ pâlâmŋe kinmai. Yâhâ sosoŋeâmâ sâtŋe bâleŋe tatmai. Yawu gârâmâ lama yaŋe dâiakmâ arinomai yamâ sosoŋe yiŋgim neyekbuap. Dop yawuâk nâŋe hâŋgânyongomune sâtŋe metŋe kâlehen arinomai. Arinomai yan kiŋgityeŋahât otmâ biwi yâhâp ki otnomai. Yakât âlâ torokatmâ sâwe. Soŋgo âlâ kutŋe hewam yamâ nâŋgân nâŋgânŋe tapgât ekmâ nâŋgâm galemahomap. Yakât dopŋeâk yengu yawuâk biwiyeŋaŋe golâek manmâ sâtŋe metŋe ekmâ kewewetmâ galemahom mannomai. Yâhâ nâi kopa yamâ kopa kum den biaek tatmu ekmain. Yenâmâ yakât dop manmâ nep lohotŋan tuhum mannomai. ");
INSERT INTO spl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nep tuhum miti emetŋe tap dopŋan hawamgum nep tuhum mannomai. Nep tuhum manŋetâ kapi ambolipŋaŋe kasa otyiŋgim den âiân katyekmâ yongonomai. Yawu otyiŋgiŋetâmâ biwiyeŋe ki orotok sâwuap. ");
INSERT INTO spl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Otmu yakât âlâ torokatmâ sâwe. Yeŋe nâhât den yu lâum manŋetâ yakât meyekmâ kiapgâlen ari den âiân katyekmâ mem âi pâi tuhuyeknomai. ");
INSERT INTO spl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mem âi pâi tuhuyeknomai yan “Den mâtâpŋe girawu watmâ sâm ekyongomunŋe nâŋgâŋetâ keterakyiŋgiwuap,” yawu nâŋgâm ki gorâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sâp yanâmâ Awoŋnenŋaŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge den âlâlâ nâŋgân nâŋgânyeŋan katmu nâhât den pat âlepŋe ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Otmu sâp yan umatŋe topŋe topŋe teteyiŋgiwuap yakât yuwu sâmune nâŋgâŋet. Imi ata yeŋahâk ahom hioŋaknomai. Yakât otmâ dâiakmâ kiap yeŋgâlen ari den âiân karaknomai. Otmu âwâ nan yeŋahâk ahom hioŋaknomai. Hioŋakmâ lok kunŋe yeŋgâlen ari den âiân karaknomai. Den âiân karakŋetâmâ nombotŋe mem âlâlâ tuhuyekmâ yongoŋetâ munomai. ");
INSERT INTO spl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yakât torokatmâ âlâ sâwe. Yen orop biwinenŋaŋe kepeiakmâ konohâk otmu mannomai. Yakât otmâ nâ mem âlâlâ tuhunekŋetâ hâhiwin nâŋgâman yakât dopŋeâk yen gurâ hâhiwin yiŋginomai. Hâhiwin yiŋgiŋetâ yanâmâ hâkyeŋe ki ihiwe ihiwe otmu lohotŋe otmâ betnihinomai. Yeŋe kârihem kinnomai yanâmâ Anitâŋe meyekmâ manman kârikŋan katyekmu mannomai. ");
INSERT INTO spl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","25","Yâhâ mitihât kasaŋe yen meyekmâ den âiân katyekmâ yongom watyekŋetâmâ kapi ya pilâm âlâen arinomai. Yâhâ mem âlâlâ tuhuyekŋetâ hâhiwin kakŋan mannomai. Hâhiwin kakŋan mannomai yakât den âlâ yuwu sâmune nâŋgâŋet. Kasalipyeŋaŋe taka nimnaomlipyeŋe me âwâ mâmâlipyeŋe yamâ kapam dop konohâk yongonomai. Yakât nimnaomlipyeŋe kapam heweweŋ yongonomaihât dop ki tap. Yâhâ papatolipyeŋe me lok inŋe ya gurâ yawuâk dop konohâk tuhuyeknomai. Lok kunŋe me hoŋ bawalipyeŋe ya gurâ yawuâk. Otmu ninahât sâwe. Nâmâ kunyeŋe otmune yeŋe nâhât den tem lâum hoŋ banihim mansai. Gârâmâ lohimbi nombotŋaŋe nâhât imbiâk yuwu nâŋgâm hilipgumai. Nâhâitŋe weke bâleŋe yeŋgât kunyeŋe kutŋe Satan, otmâ kutŋe âlâ Besewulu yaŋe mâmâŋe otbaŋgimu âi yu mem manmap yawu nâŋgâmai yamâ imbiâk nâŋgâmai. Yeŋgât gurâ dop yawuâk nâŋgâm kasa otyiŋgim mem âlâlâ tuhuyekmâ mem ge katyeknomai. Yakât otmâ den âlâ yuwu sâmune nâŋgâŋet. Yeŋeâmâ Isirae kapi ambolipŋe yeŋgâlen âi ki tuhum pesuk pilâŋetâek Awoŋnaŋe yâhâpŋe hâŋgânnohomu gewom. Yâhâ nâhât komolân gâtŋe âlâ me âlâŋe ki lohotŋe otmâ pilânekmâ âlâhâlen ariwuapŋe yakât matŋe âlepŋe menomai. ");
INSERT INTO spl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yawuhât den yu torokatmâ sâwe. Tihângen wahap yu me ya otmâ gai. Ya ki tik tatbuap. Hâmbâi tetekŋan tetemu eknom. Yâhâ yu me ya otmâ kurihiakmai. Ya gurâ tetekŋan tetemu eknom. ");
INSERT INTO spl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yakârâmâ yuwu sâmune nâŋgâŋet. Yenâmâ nâ orowâk manmain. Yawu gârâmâ den nombotŋe nenŋiâk tatmâ ekyongoman ya hâmbâi ekyongoŋetâ nâŋgânomai. Yâhâ nâŋe den halowân sâm ekyongom mansan. Yamâ hâmbâi yeŋe lok senyeŋan kinmâ ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ekyongonomai yakât topŋe yuwu sâmune nâŋgâŋet. Lok senyeŋan kinmâ den ekyongoŋetâ nâŋgâŋetâ nahat otmu yen nombotŋe yongoŋetâ munomai. Yongonomai yamâ umut biwiyeŋe ki hilipgunomai. Lok topnenŋe yawu tap. Yakât otmâ yeŋe ya yeŋgât ki kiŋgityeŋahât otnomai. Yâhâ Anitâhât topŋeâmâ âlâ tap. Hâmbâi mâne yâkŋe konok umut biwiyeŋe hilipguwuapgât dop tap. Yakât otmâ yeŋe yâkât den konok lâum mannomai. ");
INSERT INTO spl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Otmu yakât âlâ sâwe. Anitâhât den lâum manmain nen haoŋmâ ârândâŋ Anitâŋe tihitnenŋe otmap yakât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Giroŋ giroŋ ekmain yamâ nâi tâŋât. Yamâ ki galemgumain. Yawu gârâmâ giroŋ giroŋ âlâ mumbuap yakât topŋe himbim amboŋaŋe emet inânŋan nâŋgâmu tap. ");
INSERT INTO spl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Yawu gârâmâ nenâmâ giroŋ giroŋ yakât dop bia. Nenâmâ Anitâ ikŋe kundenŋe towat manmain. Yawu otmâ Anitâŋe topnenŋe kerehâk naŋgap. Somotnenŋe tipi tapi yakât topŋe gurâ nâŋgâmu tawâk. Yâkŋe tihitnenŋe otmap. Yakât nâŋgâm biwi yâhâp ki otmâ manmâ yâhânom. ");
INSERT INTO spl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Lohimbi âlâ me âlâŋe “Yesuhâlen biwinaŋe kepeim tem lâuwaŋgim mansan,” yawu sâm lohimbi ekyongonomai yâhâmâ hâmbâi nâŋe himbim awoŋnahât senŋan kinmâ topyeŋe sâm tetemune Anitâŋe manman kârikŋan katyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yâhâ lohimbi âlâ me âlâŋe topyeŋe kurihiakmâ “Nâ Yesu ki nâŋgâwaŋgian,” yawu sânomai otmuâmâ nâku himbim awoŋnahât senŋan kinmâ “Nâ ki nâŋgâyiŋgian,” yawu sâwom. Lohimbi yawu otmai yaŋe matŋe umatŋe menomai. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Otmu âlâ yuwu sâmune nâŋgâŋet. Yeŋeâmâ nâhât yuwu ki sânomai, “Nâhâit yamâ buku konok otnehât himbimâmbâ giop.” Yawu ki sânomai. Yakât sâmune nâŋgâŋet. Nâŋe hânân gewan yakât yen hioŋaknomai. ");
INSERT INTO spl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nanlipyeŋaŋe âwâlipyeŋe betyiŋginomai. Me baralipyeŋaŋe mâmâlipyeŋe betyiŋginomai. Me imbilipyeŋaŋe iranlipyeŋe betyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yawu otmâ hep torehenlipyeŋe hioŋakmâ kasa oraŋginomai. ");
INSERT INTO spl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Otmu yakât topŋe yuwu sâmune nâŋgâŋet. Lohimbi âlâ me âlâŋe biwi nâŋgân nâŋgânŋaŋe âwâŋe mâmâŋe yeŋgâlenâk katmâ kepeiyekmâ nâhât âi yakât nâŋgâmu giap. Me nanŋe baratŋe yeŋgât biwiŋaŋe kepeiyekmâ nâhât âi yakât nâŋgâmu giap. Lok yawu otmai yeŋgât nâŋgâmune ki ârândâŋ otmap. Yakât otmâmâ nâhât pat ki otŋetâ yanâmâ Anitâŋe umatŋe yiŋgimu menomai. ");
INSERT INTO spl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Otmu lok âlâ me âlâŋe nâhât den lâum âi tuhuŋetâ bukulipyeŋaŋe nâŋgâm bâleyiŋgim hilipyongone sâm otŋetâ yanâmâ, “Bukulipnaŋe hâhiwin nihimai” sâm hâkyeŋe alitmâ mannomai. Lok yawuya nâhât pat ki otŋetâ yanâmâ Anitâŋe umatŋe yiŋgimu menomai. ");
INSERT INTO spl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Otmu lok âlâ me âlâŋe ikŋe manmanŋe âlepŋe yawuâk mem mete tuhum manbuap lok yawuya hâmbâi hiliwahowuap. Otmu lok âlâ me âlâŋe nâhât nâŋgâmu bulâŋe otmu ikŋe manmanŋe ki alitmâ manbuap. Lok yawuya yamâ nâŋe manman kârikŋe waŋmune manmâ yâhâwuap. ");
INSERT INTO spl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Otmu yakât âlâ torokatmâ sâwe. Lohimbi âlâ me âlâŋe nâ buku otnihimai. Lohimbi yaŋe nâ otnihiain sâm yan awoŋne hâŋgânnohomu gewan ya otbaŋgimai. Gârâmâ benŋe nâŋe yawuâk hâŋgânyongomune ariŋetâ buku otyiŋginomai. Lohimbi yaŋe yen gurâ otyiŋgiain sâm yan nâ otnihinomai. ");
INSERT INTO spl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Otmu yakât âlâ sâwe. Lok âlâ me âlâŋe Anitâhât hoŋ bawa âlâ ekmâ buku otbaŋginomai. Yawu otnomai yakât matŋe hâmbâi Anitâŋe ikŋe hoŋ bawa hâmeŋe waŋbuap dop yawuâk lohimbi ya yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yâhâ lohimbi biwi nâŋgân nâŋgânyeŋaŋe nâ hikunekmâ nâhât den lâum manmai. Yâk yeŋgâlen gâtŋe âlâ me âlâŋe senŋe âlâlâ pâinmâ manŋetâ lok nombotŋaŋe towat yekmâ nâhât hoŋ banihim mansai sâm tânyongonomai, me to osom yiŋgiŋetâ nenomai yakât hâmeŋe gurâ hâmbâi menomai. Yawu.” Yesuŋe den yawu sâm hoŋ bawalipŋe nen eknongop. ");
INSERT INTO spl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuŋe nen hoŋ bawalipŋe kâiân yâhâp eknongom pesuk pilâm, yapâ yahatmâ kapi hâlâŋmâ tatmâ arap ya yeŋgâlen ari den kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sâp yanâmâ Yoane pâi emetŋan katŋetâ talop. Katŋetâ talowân Yesuŋe kulem topŋe topŋe miop yakât pat ya nâŋgâm biwi yâhâp otmâ yuwu nâŋgâop. “Lok pato kulet sâwaŋgi sâm Anitâŋe âi nihiop ya tuhum mansan. Lok pato yuâmâ Yesu me âlâhât mambotbom.” Biwiŋaŋe yawu nâŋgâm hoŋ bawalipŋe nombotŋe hâŋgânyongomu, ari yuwu sâm Yesu âikuwi. ");
INSERT INTO spl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Anitâŋe lok âlâ hâŋgângumu ge tihitnenŋe otbuap sâmain ya gâ? Me âlâhât mambotnom?” ");
INSERT INTO spl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yawu sâm âikuŋetâ yuwu sâm ekyongop. “Yenâmâ ari kulem topŋe topŋe mian yukât Yoane ekunomai. ");
INSERT INTO spl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nâŋe senyeŋe bok sâsâŋe ya walipyongomune senyeŋe suk sâmu eksai. Otmu lok pareŋe manmai ya heŋgemyongomune târârâhâk bam gai. Otmu hâk bâle manmai ya gurâ heŋgemyongomune âlepŋe otmâ mansai. Otmu ândâpyeŋe bok sâsâŋe ya gurâ heŋgemyongomune ândâpyeŋe pâroŋ sâmu den naŋgai. Otmu nombotŋe bâlewi ya mumuŋambâ mem yahatyekmune mansai. Otmu kewilâyekŋetâ mansai ya nine den pat âlepŋe ekyongomune nâŋgâm biwiyeŋe heroŋe otmâ mansai.” Yawu sâm Yoane ekunomai. ");
INSERT INTO spl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yakât âlâ sâwe. Yawu otyiŋgim mansan yakât otmâ lok âlâ me âlâŋe nâhât nâŋgâm biwi yâhâp ki otmai ya yeŋgât nâŋgâmune tepne heroŋe oap.” Yawu sâm ekyongom hâŋgânyongomu âwurewi. ");
INSERT INTO spl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hâŋgânyongomu âwurem ariŋetâ Yesuŋe Yoanehât topŋe lohimbi kinbi ya yuwu sâm ekyongop. “Yoane lok ki manmaiângen ari manop ya lohimbiŋe ekne sâm yâkâlen ariwi. Otmu yakât den âlâen hâum sâwe. Siru pato pilâm âliwahap mem gâsuk gâsuk tuhumu ekmâ âlemai. ");
INSERT INTO spl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yawu olop ya ekne sâm yakât ariwi me bia? Me lok âlâŋe hâk katipŋe sekŋe âlepŋe mânuŋakmâ manop ya ekne sâm ariwi me? Lok hâk katipŋe sekŋe âlepŋe mânuŋakmaiŋeâmâ lok kutdâ yeŋgât emelanâk tatmai. Yâhâ lok ki manmaiângen ki manmai. Yakât otmâ wuân bân ekne sâm yaken ariwi? ");
INSERT INTO spl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yakât yuwu sâmune nâŋgâŋet. Yoaneŋe Anitâhât den pat sâm tetem gaop ya nâŋgâne sâm ariwi. Yâhâ emelâk Anitâhât poropetelipŋaŋe yâkât den tâmbâlipyeŋe ekyongom manbi ya yeŋgât kunyeŋe pato oap. ");
INSERT INTO spl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yâkât nâŋgâm emelâk Anitâŋe den sâop ya yuwu tap. “Gâŋe nine topne sâm tetem ekyongorâ nâŋgâŋetgât nine hoŋ bawane hâŋgângumune kulet sâhihim mâtâp meŋgihiwuap.” Den yawu tap. Kulet sâop yamâ Yoane. ");
INSERT INTO spl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","15","Yawu gârâmâ Yoanehât topŋe nâŋgâŋetâ keterahâkgât yuwu sâmune nâŋgâŋet. Poropete lok, Mose otmu lok nombotŋaŋe Anitâŋe tihitnenŋe otmap yakât den pat ekyongom gawi. Yâhâ den ekyongowi ya yawuâk Yoaneŋe potonŋe sâm teteop. Yawu otmâ yeŋe biwiyeŋaŋe yuwu mon nâŋgâmai. “Emelâk poropete âlâ, kutŋe Elia sâm yâkŋe yâhâpŋe hohetnenŋan tetem manmâ kutdâhât mâtâp mewaŋgiwuap.” Biwiyeŋaŋe yawu nâŋgâmai yakât bonŋe yamâ Yoanehâlen teteap. Yoanehât yawu nâŋgâŋetâ keterahâkgât biwiyeŋan katmâ nâŋgâm mannomai. Otmu torokatmâ sâwe. Yoaneŋe ya topŋe katmâ mem gaop. Topŋe katmâ, Anitâŋe bulâŋanâk tihitnenŋe otmap ya ekyongomu nâŋgâm biwiyeŋe heroŋe otmu yakât bonŋe mene sâm manmâ gai. Otmu yakât den yuwu sâmune nâŋgâŋet. Anitâŋe Yoane nep waŋmu miop yakât nâŋgâmu yahatmap. Yakât otmâ lok âlâ me âlâŋe Yoane wanginomaihât dop ki tap. Yoaneŋe kulet sânihim âi mem gaop yamâ nine topne ki nâŋgâm heŋgeŋgum mansap. Yakât otmâmâ lok âlâ me âlâŋe nâhât den pat âlepŋe yu nâŋgâm Anitâhâlen biwi nâŋgân nâŋgânyeŋe katnomai yaŋeâmâ Yoane wanginomai. ");
INSERT INTO spl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yen biwi yâhâp otmâ mansai yakât keterakyiŋgiâkgât den girawu yaen hâum sâmune nâŋgâŋetâ keterakbuap. Yuwu mon? Nimnaom titipâŋe sombem patoen hârum konok otmâ tatnomai. Tatmâmâ komot âlâ tatnomaiŋe komot âlâ yuwu mon ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","19","“Nenŋe yahatmâ kep tuhum âlâlâ otbin. Gârâmâ yen orowâk tuhune sâmunŋe ki tânnongowi.” Yawu otnomai yakât topŋe teteâkgât yuwu sâmune nâŋgâŋet. Yakât dopŋeâk Yoaneŋe heroŋe olâkgât nâŋgâwi. Yamâ nâŋgâwi yawu Yoaneŋe ki olop. Yakât otmâ yâkât hâkâŋ otmâ sâm ge katbi. Otmu âlâku torokatmâ hâum sâwe. Sâp âlâen nimnaom titipâ komot âlâ tatnomaiŋe komot âlâ yuwu sâm ekyongonomai. “Âo, nen we bâle nâŋgâm otmâ ombe hakoâk isewin. Yawu otbin yan yeŋe ki nenekbi. Yakât otmâ nâŋgâmunŋe bâleap.” Yawu sânomai. Yakât dopŋeâk yeŋe otmâ mansai. Gârâmâ yeŋe oai yan ki torokatmâ mansan. Yakât otmâ yen nâhât hâkâŋ oai. Yakât yuwu sâmune nâŋgâŋet. Emelâk Yoaneŋe to kârikŋe me âlâlâ ya nembâpgât dop yamâ yâkŋe ki neminiop. Yakât yeŋe yuwu sâwi. “O, lok yuâmâ weke bâleŋaŋe mâmâŋe otbaŋgimu yawu otmap.” Yawu sâwi. Yâhâ nâmâ Anitâŋe hâŋgânnohomu ge sot kâle neman. Yakât otmâ yeŋe nâhât yuwu mon nâŋgâmai. “O, lok yuâmâ sot pato kutakumap. Otmu takesi meme lok otmu lok komborâ yâk orop buku oraŋgim gamai.” Nâhât yawu sâmai. Yawu gârâmâ yakât sâwe. Anitâŋe den sâop ya tiŋâk lâum manmai ya yeŋgât orotmemeyeŋe ekmâ nâŋgâŋetâ bonŋe otbuap. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Emelâk Yesuŋe kapi hawamgum kerehâk manmâ kulem topŋe topŋe memu ekbi. Yakât otmâ orotmemeyeŋe bâleŋe me kiŋgoŋ ya ki pilâm metem biwiyeŋaŋe Anitâhâlen kepeim manbi. Yakât nâŋgâm hemgât pat otbi yakât sârekyongom yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Main, Korasin otmu Besaita kapi ambolipŋe yen, Yeŋgâlen kulem topŋe topŋe mem gamune ekŋetâ tâŋât otmâ gamap. Yamâ Tiro Siron kapi ambolipŋaŋe kulem yawu ya ekbi mâne orotmemeyeŋe bâleŋe betbaŋgim biwiyeŋe Anitâhâlen katbâi. ");
INSERT INTO spl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yawu gârâmâ yeŋe manman bâleŋe mansai ya ki pilâm Anitâhâlen biwiyeŋe katsai. Yakât otmâ hâmbâi Tiro Siron kapi ambolipŋaŋe umatŋe menomai ya wangim yeŋe umatŋe amokŋan menomai. ");
INSERT INTO spl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Otmu Kapanaum kapi ambolipŋe yeŋgât sâwe. Yen gurâ yeŋahât nâŋgâŋetâ yahatmu hâk mepae otmâ yuwu sâmai. “Nenâmâ emelâk himbimgât pat otmâ mansain.” Yawu sâmai. Ya ki tap. Yeŋgâlen kulem topŋe topŋe mem gamune ekŋetâ tâŋât otmâ gamap. Yakât yuwu sâwe. Sotom kapi ambolipŋe kulem yawuya ekbi mâne orotmemeyeŋe bâleŋe ya pilâm biwiyeŋe Anitâhâlen katŋetâ matŋe kâlâpŋe ki seyekbâp. ");
INSERT INTO spl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yawu gârâmâ yeŋe orotmemeyeŋe bâleŋe ya ki betbaŋgim Anitâhâlen biwiyeŋe katsai. Yakât topŋe yuwu sâmune nâŋgâŋet. Sâp patoen Sotom kapi ambolipŋaŋe orotmeme bâleŋe otmâ gawi yakât matŋe menomai. Otmu yen gurâ yawuâk orotmemeyeŋe bâleŋe torokatmâ mansai yakât yeŋeâmâ Sotom ambolipŋaŋe menomai ya wangim umatŋe pato hâliliŋe menomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yawu sâm Yesuŋe yuwu sâm âwâŋe ekuop. “Awoŋ, hân himbim kândikyotgon amboŋe, gâhât tep âlep pato nâŋgâhihian. Otmu lok nombotŋaŋe gâhât topge nâŋgâne sâm nâŋgân nâŋgân emetŋan yâhâwi. Parisaio otmu Sarukaio lok yawuya. Yawu gârâmâ nâŋe gâhât den lâum manmâ gan yakât dopŋeâk yâkŋe lâum manmâ gai mâne ârândâŋ otbâp. Yakât topŋe nâŋgâmaihât nâŋgân nâŋgânyeŋe ki mem heweweŋ tuhuyiŋgimat. Yawu gârâmâ lok nombotŋe, kutyeŋe bia, belângen manmai yaŋeâmâ topne nâŋgâŋetgât gâŋe nâŋgân nâŋgânyeŋe mem heweweŋ tuhuyiŋgimat. ");
INSERT INTO spl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Âo, gâŋe nâŋgâmat, yawuâk tetemap. Yakât mepaeheksan.” Yawu sâm âwâŋe ekuop. ");
INSERT INTO spl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Âwâŋe yawu sâm ekum yaŋak purik sâm yuwu eknongop. “Himbim amboŋe tatmap yâhâmâ awoŋne. Yâkŋe mâmâŋe otnihimu wuân me wuân otbomgât dop tap. Otmu nâŋe awoŋnahât topŋe nâŋgâwaŋgim heŋgeŋguan. Yawu gârâmâ lohimbi nombotŋaŋe awoŋnahât topŋe nâŋgâŋetgât sâwom yamâ yâkŋak nâŋgâŋetâ keterakbuap. ");
INSERT INTO spl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Otmu ninahât topne sâwe. Nâ lohotŋan manmâ biwi yâhâp ki otman. Yakât otmâ wuân me wuân otbehât nâŋgâman yamâ ki gorânihimap. Bia. ");
INSERT INTO spl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Otmu nâŋe yen tihityeŋe otbe sâm oan. Yakât yen umatŋe topŋe topŋe teteyiŋgimu hâhiwin me gorâ kakŋan manŋetâ biwiyeŋe orotok sâmapgât nâhâlen gaŋetâ biwi sânduk yiŋgimune lohotŋan mannomai. ");
INSERT INTO spl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Otmu nâhâlen biwiyeŋaŋe kepeim mannomai yanâmâ mâmâŋe otyiŋgimune nâhât wâtnan kinmâ biwiyeŋe ki orotok sâwuap. Otmu umatŋe teteyiŋgimu yan ki pârâk pilânomai.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tatmâ nâŋgâ nâŋgâ sâp âlâen Yesuŋe hoŋ bawalipŋe nen kerek menenekmu âi kalam biwiŋambâ gem ariwin. Gem ari mâtâp tânâmŋan po irik irik ningiop. Yawu otmâmâ buku nombotŋe yeŋgât kalamân sot talop ya mem newin. ");
INSERT INTO spl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mem nemunŋe Parisaioŋe nenekmâ Yesu yuwu sâm âikuwi. “Gâ wongât ândâp bok oat? Moseŋe girem den kulemguop ya lâum âun yu tatmâ naŋgain. Girawu otmâ hoŋ bawalipge orop ari buku nombotŋe yâk yeŋgât sot golâ mem niai? Ya otŋetâ yekmunŋe ki ârândâŋ oap.” Yawu sâm ekuwi. ");
INSERT INTO spl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yawu sâŋetâ purik pilâyiŋgim sâop. “Emelâk embâŋân Dawitiŋe olop yakât den pat sâlikum ki nâŋgâm heŋgeŋgumai. ");
INSERT INTO spl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yakât topŋe nâŋgâŋetâ keterahâkgât yuwu sâmune nâŋgâŋet. Sâp yan Anitâhât hotom um manbiŋe baŋga tuhum Anitâhât pat sâm katminiwi ya yâkŋe konok neminiwi. Lok inŋeâmâ bia. Hilâm âlâen Dawiti otmu ikŋe tembe lâulipŋe po ondop yiŋgiop. Yawu otmâ yâkŋe Anitâhât miti selepŋan yâhâm ya ihilâk mem newi. ");
INSERT INTO spl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yakât den yuwu sâmune nâŋgâŋet. Moseŋe sâmu kulemguwi ya topŋe sâlikum ki nâŋgâm heŋgeŋgumai. Tatmâ nâŋgâ nâŋgâ sâp ârândâŋâk hotom um manbiŋe yapâ mem neminiwi. Neŋetâ ki bâleop. Yakât denŋe ki teteop. ");
INSERT INTO spl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yakât topŋe yuwu sâmune nâŋgâŋet. Anitâŋe hâŋgânnohomu gem tem lâuwaŋgim manman. Yakât otmâ hotom uminiwi ya yeŋgât denyeŋe ya wangimune ârândâŋ oap. Yakât denŋe bia. ");
INSERT INTO spl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yâhâ hotom uminiwi yakât topŋe teteâkgât Anitâŋe yuwu sâmu kulemguwi. “Nâŋe tosanenŋe bialâk sâm hotom umai yakât nâŋgâmune tâŋât otmap. Yawu gârâmâ nâŋe orotmeme âlepŋeâk, buku konok oraŋgiŋetgât ukenŋe nâŋgâman.” Den tap yakât topŋe ekmâ nâŋgâm heŋgeŋguai mâne lohimbiŋe otŋetâ bâlemap ya yekmâ ki mem ge katyekbâi. ");
INSERT INTO spl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Anitâŋe hâŋgânnohomu ge mansan yamâ tatmâ nâŋgâ nâŋgâ sâp yakât amboŋe. Otmu yakât bonŋeâmâ nâŋe konok mem teteman.” Yawu sâm ekyongop. Yawu sâm ekyongomu yahatmâ ba ariwin. ");
INSERT INTO spl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Otmu Yesuŋe yapâ arimâmâ miti emetŋe âlâen yâhâop. Yâhâmu lok âlâ bâtŋe mum pâlâmŋe olop yaŋe yan tatmu ehop. ");
INSERT INTO spl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ekmâ yan Parisaio nombotŋaŋe Yesu mem den âiân katne sâm gotyetŋan ba yuwu sâm âikuwi. “Tatmâ nâŋgâ nâŋgâ sâpŋan âi tuhumaingât Moseŋe sâm kuningiop. Yawu gârâmâ lok pareŋe yu heŋgeŋgunomgât dop me bia.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sâŋetâ sâop. “Yakât topŋe teteâkgât âlâen hâum sâwe. Yeŋan gâtŋe âlâ me âlâhât lamaŋe tatmâ nâŋgâ nâŋgâ sâpŋan lâmân kioŋmu amboŋaŋe girawu otbuap? Âlepŋe lâm kâlehembâ mem katbuap me bia? Amboŋaŋe âlepŋe mem dâiwuapgât dop. ");
INSERT INTO spl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Otmuâmâ lama yamâ wahap tâŋât. Lok nenŋeâmâ wahap bulâŋe. Nenŋe Anitâhât senŋan lama ya kerek wangiyeksain. Yakât otmâ lohâmâ heŋgemyongonom me tânyongonomgât dop tap. Yakât otmuâmâ lok pareŋe yu heŋgeŋguwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yawu sâm yahatmâ lok pareŋe ya yuwu sâm ekuop. “Bâtge kuwihak.” Yawu sâmu bâtŋe kuwihahop. ");
INSERT INTO spl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kuwihakmu ekmâ Parisaioŋe nâŋgâm bâlewaŋgim pilâyekmâ ari menduhuakbi. Menduhuakmâ Yesu kuŋetâ muâkgât alahu gulahu otmâ den hikuwi. ");
INSERT INTO spl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yawu otŋetâ Yesuŋe alahuwi yakât halop nâŋgâm yapâ pilâyekmâ âlâengen ariop. Arimu lohimbi nombotŋe watmâ ariwiŋe yâkât den pat nâŋgâm bukulipyeŋe mesek otbi ya meyekmâ yâkâlen ariŋetâ heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yawu olop yakât den pat ya buku nombotŋe ki ekyongonomai sâm kuyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Otmu yawu olop yakât emelâk Anitâŋe sâmu poropete lok âlâ, kutŋe Yesaia sâm, yâkŋe kulemguop ya yuwu tap. ");
INSERT INTO spl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Lok yuâmâ nine hoŋ bawane bulâŋe manmap. Nâŋe emelâk âi sâm waŋban. Yakât nine Wâtgât mâmâŋahât Heak hâŋgângumune mâmâŋe otbaŋgimu manman kârikŋe yakât den pat ya lohimbi kerek sâm tetem ekyongowuap. ");
INSERT INTO spl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yâhâ lohimbi den kâwâ kârik ki tuhuyekbuap. Yawu otmâ mem lohotŋan katyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Otmu lohimbi biwiyeŋe orotok sâmu mansai, me tep bâle nâŋgâm mansai ya mem heweweŋ tuhuyekmu biwiyeŋe sânduk sâwuap. Yawu otmâmâ torokatmâ mem dâiyekmâ manman âlepŋan katyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Otmu lohimbi yaehen mansaiŋe biwiyeŋaŋe yâkâlen kepeim mannomai.” Den ya yawu tap. Otmuâmâ Yesuŋe lohimbi nombotŋe kundat me umatŋe topŋe topŋe teteyiŋgiop yamâ mem heŋgemyongop. Yesaiaŋe den kulemguop yakât bulâŋe heŋgemyongop yan teteop. ");
INSERT INTO spl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Otmu sâp yanâmâ lok senŋe bok sâŋe âlâ dâim yâkâlen ariwi. Lok yamâ weke bâleŋaŋe mâŋgâemu kopa otmâ manop. Yesuŋe lok ya ekmâ sâmu lauŋe hâreakmu den sâop. Otmu senŋe suk sâmu emet galem ehop. ");
INSERT INTO spl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yawu otmu yan lohimbi kiŋgitŋe orowâk kinbiŋe ekmâ pârâk pilâm eŋgat yâhâp otmâ yuwu sâwi. “Yesu yuâmâ Dawitihât senân gâtŋe mon?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yawu sâŋetâ Parisaioŋe ekŋetâ bâlemu lauyeŋe butelim yuwu sâm alahu gulahu otbi. “Yâkât topŋeâmâ yuwu. Yâhâmâ weke bâleŋaŋe mâmâŋe otbaŋgiap. Yakât otmâ ya yeŋgât patoyeŋe, kutŋe Besewulu sâm, kutŋe âlâ Satan yâkât wâtŋan kinmâ watyekmap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yawu sâŋetâ Yesuŋe biwiyeŋahât topŋe ekmâ nâŋgâm yuwu sâm ekyongop. “Yeŋe nâŋgâm tâpikguai yakât den âlâen hâum yuwu sâmune nâŋgâŋet. Lok komot konohâk mansaiŋe yahatmâ ahom hioŋakmâ tiok taok otnomai yamâ kutyeŋe biatbuap. Yâhâ kapi âlâ konohâk tatmaiŋe, yeŋahâk yahatmâ ahom hioŋaknomai yamâ kâwurumyeŋeâk kinbuap. Yakât torokatmâ sâwe. ");
INSERT INTO spl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satangât komotŋak ahom hioŋaknomai yamâ den yan yuwuâk otmâ hiliwahom kuriŋ sânomai. Yâhâ nâŋe Satangât wâtŋan kinmâ âi yu mian mâne bulâŋe ki tetembâp. ");
INSERT INTO spl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","28","Nâmâ Anitâhât wâtŋan kinmâ weke bâleŋe watyekmâ yan amboyeŋe Satan ya mem ge katsan. Yakât otmâ âlâku yu torokatmâ sâwe. Yeŋe imbiâk nâhâitŋe Satangât wâtŋan kinmâ weke bâleŋe watyeksap yawu nâŋgâmai. Yakât nâŋe yuwu sâm purik pilâmune nâŋgâŋet. Yeŋe âlâhât wâtŋan kinmâ weke bâleŋe watyeksai? Yeŋe “Anitâhât wâtŋan kinsain” yawu sâmai. Girawu otmuâmâ nâhât yawuâk ki nâŋgâmai? Yeŋe nâhât nâŋgâm tâpikgumai, yawu naŋgan. Yawu gârâmâ Anitâŋe tihityeŋe otmâ wawaeyekmâ nâ hâŋgânnohomu ge âi yu mem mansan.” ");
INSERT INTO spl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nine topne teteâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Lok sâtŋe âlâŋe hâmbâŋe mem haŋgalakmâ tembe talam lâuakmâ teŋgâen irik irihâk kinbuap. Kinmu yanâmâ kasaŋaŋe taka kombo mewaŋgiwe sâm otmu ahoromawot. Ahom yan kasaŋaŋe kum itit kiom bâleŋe tuhuwaŋgiwuap. Yakât dopŋeâk nâŋe Satan mem ge katbom. Yakât otmâ yâkât weke bâleŋe watyekmune gaiakmâ arai. ");
INSERT INTO spl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yakât torokatmâ yuwu sâmune nâŋgâŋet. Lohimbi nombotŋaŋe nâhât nâŋgâŋetâ tâŋât otmap yâkŋeâmâ nâhât kasa manmai, yawu naŋgan. Yâhâ nombotŋe biwiyeŋe pâlâmŋe manmâ ki tânnohomaiŋeâmâ mâtâp maŋgunihimai dop yawu otmap. Yawu naŋgan. ");
INSERT INTO spl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Yakât otmâ âlâ torokatmâ yuwu sâwe. Lok âlâ me âlâŋe otŋetâ bâlewuap. Me Anitâŋe âi sâm nihim hâŋgânnohomu gewan nâhât nâŋgâŋetâ tâŋât otbuap. Me nâhât nâŋgâŋetâ giâkgât lohimbi biwiyeŋan kioŋnomai. Orotmeme yawuya ki witgum mannomai ya yeŋgât tosa yamâ Anitâŋe pilâyiŋgiwuapgât dop tap. Otmu torokatmâ sâwe. Lok âlâ me âlâŋe Anitâhât Wâtgât mâmâŋahât Heakŋe yu me ya otbuap ya ekmâmâ yuwu mon sâwuap. “Bâe, âi yukât amboŋe yamâ Satan.” Yawu sâm yan âi ya ekmâ Satangâlen gâitbuap. Yawu otmâ yâhânomai ya yeŋgât tosa Anitâŋe pilâwaŋgiwuapgât dop âlâ ki tap. Lohimbi yawuyaŋe tosa pato menomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","35","Otmu Yesuŋe ikŋe biwiŋahât topŋe nâŋgâŋetâ teteâkgât den âlâen hâum Parisaio yuwu sâm ekyongop. “Nenâmâ be yakât topŋe naŋgain. Be esenŋe ya ekmâmâ bonŋe yamâ ketŋe niap me galaŋ siap me bia, yakât ki nâŋgâmain. Galaŋ semu yanâmâ be yu bâleŋe sâm hindâm kârâm tâtuk memain. Yâhâ bonŋe âlepŋe otmuâmâ hindâm mem ari um nemain. Yawu. Otmu âlâ torokatmâ sâwe. Kâpi yakât topŋe naŋgain. Esenŋe gimbaŋgum kinmuâmâ bonŋe âlepŋe ki kinbuap sâmain. Yâhâ esenŋe aiakmâ kinbuap otmuâmâ hâmbâi bonŋe âiloŋgo kinbuap yawu sâmain. Yawu gârâmâ nenŋe kâpi esenŋaŋe towatŋe girawu tetemap ya ekmâ yanâmâ gâmâlâk kâpi bonŋe girawu kinbuap yakât be nâŋgâmain. Yawu gârâmâ lok nenŋe topnenŋe dop yawuâk ekmâ nâŋgâmain. Lok âlâ me âlâŋe otŋetâ âlepŋe otmap ya yekmâ lok mulunŋe sâmain. Yâhâ lok âlâ me âlâŋe otŋetâ bâlemu kiŋgoŋ manmai ya yeŋgât lok bâleŋe sâmain. Yakât otmâmâ nine topne sâmune nâŋgâŋetâ keterahâk. Nâŋe lok heŋgemyongom mansan ya yeŋe ekmâ imbiâk nâhâitŋe Satanŋe mâmâŋe otbaŋgimu heŋgemyongoap nâŋgâmai. Yakât nâŋgâmune bâleap. Yenâmâ lok perâkŋe, biwi nâŋgân nâŋgânyeŋe bâleŋe. Yakât otmâmâ lauyeŋambâ den perâk yawuâk ga takamap. Yawu yekmâ naŋgan. ");
INSERT INTO spl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Yawu gârâmâ sâp patoen yanâmâ yeŋe den perâkŋe, me den guruk, den yawuya sâmai. Anitâŋe manmanyeŋe ekmâ yakât matŋe ikŋiâk ikŋiâk kâpekyiŋgiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yesuŋe den ya sâm tetemu Mosehât girem den kâsikum ningiminiwi otmu Parisaio lok nombotŋaŋe yuwu sâm ekuwi. “Lok pato. Gâŋe kulem topŋe topŋe mem gat yakât âlâ mendâ ekmâ topŋe nâŋgânehât naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yawu sâŋetâ yuwu sâm purik pilâyiŋgiop. “Lohimbi hârok yeŋgât topyeŋe girawu tap yakât nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Imbi kondarâŋe lok ihilâk orop manmai dop yawu. Yeŋe biwi yâhâp otmâ kulem witgumâk eknehât nâŋgâmai. Yâhâ nâmâ kulem konohâk memune eknomai. Yuwu sâmune nâŋgâŋet. Aŋgoân poropete âlâ, kutŋe Yona sâm, yâhâmâ iŋan patoŋe kereŋgetmu tepŋe kâlehen ge hilâm kalimbu talop. ");
INSERT INTO spl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yakât ninan hâum yuwu sâmune nâŋgâŋet. Nâmâ Anitâŋe hâŋgânnohomu gewan. Otmu hân kâlehen ge imbom. Tatmune hilâm kalimbu pesuk sâmu yapâ yahatbom. ");
INSERT INTO spl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Otmu torokatmâ sâwe. Yawu gârâmâ Yonaŋeâmâ kapi âlâ, kutŋe Niniwe sâm, ya ambolipŋe ari girem den ekyongomu orotmemeyeŋe bâleŋe pilâm yâkât den nâŋgâwi. Yâhâ otbi yamâ yeŋe oai yakât dop bia. Yeŋeâmâ kunyeŋe kârikŋe otmâ nâhât den nâŋgâŋetâ gemu bet pilâm orotmemeyeŋe kiŋgoŋ torokatmâ mansai. Yakât otmâmâ sâp patoen Niniwe kapi ambolipŋaŋeâmâ lok senyeŋan yahatmâ kinmâ yeŋe orotmemeyeŋe bâleŋe witgum oai yeŋgât topyeŋe mem tetem aŋun yiŋgiŋetâ ekbom. Nâ Yonahât kunŋe mansan. Yakât otmâmâ nâhât den kuŋetâ nâŋgâmune bâleap. ");
INSERT INTO spl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yakât den âlâ sâwe. Aŋgoânâmâ lok âlâ, kutŋe Solomon sâm, Dawiti nanŋe ya nâŋgân nâŋgânŋe pato tatbaŋgiop. Otmu yâkât kut patŋe ya emelâk sâm haŋ tuhuŋetâ arimu imbi pato âlâ kapi kâlepŋehen manopŋe nâŋgâop. Nâŋgâm yanâmâ ekbe sâm tohop. Yakât sâmune nâŋgâŋet. Solomongât nâŋgân nâŋgân pato tatbaŋgiop. Yawu gârâmâ nâmâ Solomongât kunŋe mansan. Otmu nâŋe kapi kâlepŋehen ki mansan. Hohetyeŋan manmâ den kâsikum yiŋgim mansan. Yamâ yeŋeâmâ nâhât den nâŋgâŋetâ nahat otmap. Yakât otmâ mem ge katnekne sâm oai. Yakât otmâ hâmbâi sâp patoen imbi pato yaŋeâmâ lok senyeŋan yahatmâ kinmâ yeŋe nâhât den kum mansai yeŋgât topyeŋe sâm tetemu aŋulaknomai. Yawu otŋetâ Anitâŋe yakât matŋe âlâku ikŋeâk ikŋeâk yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nâŋe yeŋgât topyeŋe yu sâm pitiŋgum heŋgeŋgumune nâŋgâŋet. Yeŋe yuwu nâŋgâm tâpikgumai. “Nenŋahâk kuwihakmâ manman âiloŋgo manmâ yâhânom.” Yen yawu nâŋgâm tâpikguai yakât otmâ den âlâen hâum yuwu sâwe. Weke bâleŋaŋe lok âlâ mâŋgâemap ya gaiakmâ emet sondaŋângen ariwuap. Otmu lok ondopgâlen karakmâ mem bâlewe sâm yakât pâinmâ manbuap. ");
INSERT INTO spl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pâinmu biatmu yuwu nâŋgâwuap. “O, emelâk lok âlâ mem mâŋgâeminiwan. Gârâmâ lok yamâ ninahâk gaiakmâ tohowan. Yawu gârâmâ âlâkuâk âwurem ari lok yâkâlen karakbom.” Yawu sâm âwurem ari ekmâ yuwu sâwuap. “Bâe, lok yuâmâ heŋgemahom mansap. Nâhât wâtne tipiŋe. Yakât otmâ weke bâleŋe nombotŋe wâtyeŋe pato tap ya ari meyekbom. Ari meyekmune taka orowâk menduhuakmâ lok yu mâŋgâenom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yawu sâm ari weke bâleŋe bât nombotgen yâhâp ya meyekmu taka lok aŋgoân hâhiwin kakŋan manop yamâ witgum mâŋgâeŋetâ umatŋe dondâ tetewaŋgimu manbuap. Yakât otmâ yuwu sâmune nâŋgâŋet. Yeŋe yeŋahâk heŋgemahom mannomaihât dop âlâ ki tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Den yawu sâm ekyongom tatmu yanâk ikŋe hepŋe torehenlipŋaŋe taka tirek topŋan kinmâ yuwu sâwi. “Atanenŋe gâ tat me?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yawu sâŋetâ lok âlâ yan talopŋe yahatmâ yuwu sâm ekuop. “Wâe, emba nâŋgâ. Torehenlipgaŋe taka tirek topŋan kinmâ gâhât yai.” ");
INSERT INTO spl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yawu sâmu Yesuŋe nenekmâ yuwu sâm eknongop. “Hepne torehenlipne taka kinsai. ");
INSERT INTO spl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Yawu gârâmâ yuwu sâwe. Awoŋne himbim amboŋahât tem lâum manmaiŋeâmâ nâhât hepne torehenlipne bulâŋe oai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","3","Otmâ sâp yanâk Yesu emelambâ yapâ lâum kioŋmâ giop. Yawu otmâ gem yan deŋgân ginŋan ari tatbin. Yan tatmunŋe lohimbi dondâŋe taka mem hawam mewam tuhunenekbi. Mem hawamnongoŋetâ yapâ pilâyekmâ waŋgaen yâhâop. Waŋgaen yâhâmu lohimbi takawi yaŋe ginŋan ge tatbi. Ge tatŋetâmâ waŋgaen kinmâ ikŋe den pat yakât topŋe den âlâen hâum yuwu sâm eknongomu nâŋgâwin. “Lok âlâŋe hote alikŋe mem hâiloŋbe sâm newângen ariop. ");
INSERT INTO spl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","8","Ari hote alikŋe ya nombot nombot hâiloŋmu giop. Nombotŋe mem hâiloŋmu mâtâwân ge talop. Yâhâ nombotŋeâmâ mem hâiloŋmu hân toŋe biaen ge talop. Yâhâ nombotŋeâmâ hele bâleŋe iowân giop. Yâhâ nombotŋeâmâ tep tep kum hân mem âiloŋgo loŋgo tuhuwi yan ge talop. Yawu gârâmâ hote mem hâiloŋmu âlâen âlâen giop yakât topŋeâmâ yuwu. Nombotŋe mâtâwân ge talop yamâ nâiŋe taka kârâm nem metewi. Yâhâ nombotŋeâmâ hân toŋe biaen giop yamâ gihitŋe kakŋeâk pilâop. Yakât otmâ sikop kârikŋe kumu yan in yawu mum hâlâlâŋ sâop. Yâhâ nombotŋeâmâ hewukŋan me hele pato biwiŋan giop yamâ âlepŋe pururuk sâm teteop. Pururuk sâm tetemu hewukŋaŋe langumu derepgum gimbaŋgumu orok sâop. Yâhâ nombotŋe hân âiloŋgoân giop yaŋeâmâ pururuk sâm âiloŋgo yahalop. ");
INSERT INTO spl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nâŋe den yan yu biwiyeŋan katmâ nâŋgâm heŋgeŋgunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Otmu lohimbi ya kerehâk ariŋetâ nenŋiâk kinmâ Yesu yuwu sâm âikuwin. “Lohimbi yeŋgât senyeŋan kinmâ yan girawuhât gâŋe den âlâen hâum sâm teteat? Yawu sârâ yâkŋe nâŋgâŋetâ ki keteraksap. ");
INSERT INTO spl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yawu sâm âikumunŋe yuwu sâop. “Yenâmâ Anitâŋe tihityeŋe otmâ gamap. Yakât topŋe ya yeŋe tipiŋe naŋgai. Ya nâŋgâŋetâ keterahâkgât topŋambâek sâm tetem ekyongoman. Yâhâ lok nombotŋe Anitâ ki nâŋgâwaŋgim pâlâmŋe otmâ mansai yaŋeâmâ Anitâŋe tihityeŋe otbe sâm oap ya ki ekmâ nâŋgâŋetâ keteraksap. Yawuhât yâkŋeâmâ Anitâhât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum sâman. ");
INSERT INTO spl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yeŋe emelâk Anitâhât topŋe nâŋgâne sâm biwiyeŋe nâhâlen katbi. Yawuhât otmâ den âlâen hâum sâmune âlepŋe nâŋgâŋetâ topŋe tetemap. Yâhâ nombotŋe nâhât hâkâŋ oai yaŋeâmâ Anitâhât topŋe nâŋgâm tâpikguai. Yakât otmâ den âlâen hâum ekyongomune topŋe ki nâŋgâŋetâ keterakmap. ");
INSERT INTO spl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yawuhât poropete lok âlâ, kutŋe Yesaia sâm, yâkŋe emet inânŋan den yuwu kulemguop yakât bonŋe yu teteap. ");
INSERT INTO spl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Lohimbi yu yeŋgât topyeŋe yuwu. Yâkŋe biwi pâlâmŋe otmâ nâhât den pat âiloŋgo ya nâŋgâŋetâ tâŋât oap. ");
INSERT INTO spl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yâhâ nâhât hâkâŋ otmâ nâŋgâm kâkâsuk otmâ kâhâeneksai. Yakât benŋe biwiyeŋe alitmâ nâhât topne ki nâŋgâŋetâ keterakyiŋgiwuap. Yawu otmâ hiliwahonomai. Topyeŋe yawu.” ");
INSERT INTO spl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Yawuhât topne yuwu sâmune nâŋgâŋet. Emelâk embâŋân Anitâhât poropete lok otmu lohimbi nombotŋe yâkât tem lâum manbi yaŋe kulem nâŋe mem mansan yu ekne sâm yakât mambotmâ gam inâk muwi. Otmu yakât dopŋeâk yâkŋe himbimgât den pat nâŋe ekyongom mansan yu nâŋgâne sâm mambotmâ gam inâk muwi. Yakât otmâ den yuwu sâmune nâŋgâŋet. Yeŋeâmâ sâp yiwereŋe yu nâ orowâk manmâ gam kulem topŋe topŋe ekmâ nâhât den nâŋgâm heroŋe kakŋan mansai. ");
INSERT INTO spl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","19","Otmu hote mem hâiloŋmu giop yakât topŋe yuwu sâm ekyongomune nâŋgâŋet. Lok âlâŋe hote mem hâiloŋmu mâtâwân ge talop yakât topŋe yuwu. Yamâ lohimbi nombotŋaŋe nâhât den nâŋgâŋetâ ki keterakyiŋgimu manmai. Yawu manŋetâ Satanŋe den ya kum mem gulip tuhumap. ");
INSERT INTO spl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Otmu hote mem hâiloŋmu nombotŋe hân toŋe biaen giop yakât topŋe yuwu. Lok yawuya nâhât den pat âlepŋe ekyongomune nâŋgâm heroŋe otmâ manmai. Nâŋgâŋetâ kakŋeâk gem biwiyeŋan gihitŋe kârikŋe ki memap. Yawu gârâmâ Anitâhât kasa takamai ya yekmâ kiŋgityeŋahât otmâ in yawu pilâmai. Me bukulipyeŋe nombotŋaŋe senyeŋan geŋetâ yan lohotŋe otmâ pilâmai. ");
INSERT INTO spl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Otmu hote mem hâiloŋmu nombotŋe hele biwiŋan giop yakât topŋe yuwu. Lohimbi nombotŋe den ekyongomune nâŋgâŋetâ bonŋe otmap. Nâŋgâŋetâ bonŋe otmu sâp kâlep ki otmâek hângât iri sikum me senŋe âlâlâ ekmâ biwi nâŋgân nâŋgânyeŋaŋe yan hikum nâŋgâm manmai. Yawu manmai yakât otmâ biwi yâhâp otmâ manŋetâ manman âlepŋe ki teteyiŋgimap. ");
INSERT INTO spl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yâhâ hote mem hâiloŋmu nombotŋe hân toŋe orowân giop yakât topŋe yuwu. Lok yawuyaŋeâmâ den pat âlepŋe nâŋgâm heŋgeŋgumai. Nâŋgâm heŋgeŋgum tiŋâk lâum manŋetâ manman âiloŋgo loŋgo teteyiŋgimap. Yâk yeŋgât topyeŋe yawu. Nâŋe hoteân hâum yan yamâ topnenŋeâmâ yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Otmu den âlâ torokatmâ sâop. Anitâŋe kasalipŋe in yawu ki yongom itit kiom tuhuyekbuap. Kasalipŋe orowâk oset guset otmâ manmâ yâhânom yakât topŋe nâŋgânehât den âlâen hâum yuwu sâm eknongop. “Lok âlâŋe kalamângen ari hote mem hâiloŋmu giop. Hâiloŋmu gemu emetsâpŋe otmu âwurem kapiŋan ariop. ");
INSERT INTO spl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Âwurem kapiŋan arimu omoŋdâŋe kasaŋaŋe yok pilâm taka sait mewaŋgiop. Sait mewaŋgimu yaŋak kainde yaŋe hote orop oset guset teteop. ");
INSERT INTO spl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yawu otmâ hote ya pururuk sâm tetemu kainde ya yawuâk pururuk sâowot. ");
INSERT INTO spl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yawu tetemutâ nep amboŋe yakât âi lok manbiŋe ekmâ yuwu sâm patoyeŋe ekuwi. “Lok pato, hote hâiloŋdâ pururuk sâop ya kainde yaŋe osetŋe tete pururuk sâmu ekmunŋe ki ârândâŋ oap.” ");
INSERT INTO spl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sâŋetâ sâop. “Yakât topŋe naŋgan. Kasanenŋaŋe toho âinenŋe mem bâleningiop.” Sâmu sâwi. “Yakât girawu naŋgat? Yakât yiwereŋe ari kainde harutmâ pilânom me bia?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Sâŋetâ sâop. “Yawu otmâ kaindeâk sâm hote nombotŋe harutmaihât pilâŋetâ talâk. ");
INSERT INTO spl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hâmbâi hâŋgânyongomune kainde otmu hote ya towatyetŋe ekmâ yan hindâm kâsikunomai. Kainde yamâ kâsikum panŋetâ hâlâlâŋ sâmu uŋetâ sewuap. Yâhâ hote yamâ hindâm komot ikŋiâk katŋetâ tatbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuŋe nen biwinenŋe Anitâhâlen katmunŋe tihitnenŋe oap yakât topŋe teteâkgât den âlâen hâum yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","“Nak âlâ kutŋe bândup yamâ lok âlâŋe kehetŋe tipiŋe âlâ mem ari kalamŋan katbuap. Katmu yapâ kâmŋe ga taka yaŋak yâhâm kâlep pato otmâ nak nombotŋe wangiyekmap. Yawu otmâ nâi wosapâ wosapâ yaŋe menduhuakmâ ya awatŋe kun kunŋan kerem tatmai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Otmu torokatmâ yuwu sâm eknongop. “Lok komotŋe komotŋe wosapâ wosapâ mansaiŋe biwiyeŋe nâhâlen katmâ tem lâunihiŋetgât yeŋe ari nâhât den pat âlepŋe ekyongonomai. Yakât topŋe teteâkgât den âlâen hâum sâmune nâŋgâŋet. “Imbi âlâŋe dâmbia golaŋguwuap. Golaŋgumâmâ matuk mendâremu keluŋe gemu dâmbia orop menduhumu ukenŋe bâleŋe otbuap. Dop yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuŋe lohimbi yawu sâm den âlâen hâum ekyongom gaop yamâ aŋgoân embâŋânâk poropete âlâŋe den kulemguop yakât bonŋe yan teteop. ");
INSERT INTO spl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Otmu den yuwu kulemguop tap. “Den topŋe topŋe Anitâŋe aŋgoân ki sâm tetemu nâŋgâm gawiŋak manmâ gawi. Ya yiwereŋe yuâmâ nâŋgâŋetâ keterahâkgât den âlâen hâum yakât topŋe ekyongowom.” Yawu kulemguop. Den sâop yan bonŋe teteop. ");
INSERT INTO spl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuŋe lohimbi tatbi ya pilâyekmâ emelan yâhâop. Yâhâmu watmâ yâhâ yuwu sâm âikuwin. “Hote otmu kainde oset guset teteowot yakât topŋe sârâ nâŋgâne.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sâmunŋe sâop. “Lok âlâŋe hote mem hâiloŋmâ ariop yakât dop yamâ Anitâŋe nâ yu hâŋgânnohomu gewan. ");
INSERT INTO spl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aiop, kalamgât sâop yamâ yen hânŋan kulemŋan mansai. Yâhâ hotehât sâop yamâ lohimbi Anitâhât amutgen manŋetâ tihityeŋe otmap ya. Yâhâ kaindehât sâop yamâ nâhât den loŋgâem betnihim manmai ya. Lohimbi kaindehât dop manmaiŋeâmâ Satan orowâk bâlenomai. ");
INSERT INTO spl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aiop, kasaŋe taka sait mewaŋgiop yamâ Satan. Yâhâ kalamân sot bonŋe tetewuapgât sâm ekyongoan yamâ hâmbâi mâne sâp pato tetewuawân yakât bonŋe tetewuap. Yâhâ âi loklipŋaŋe kainde hindâm menduhum kâlâwân unomaihât sâm ekyongoan yamâ hâmbâi Anitâŋe aŋelolipŋe hâŋgânyongomu ge lohimbi betnohomai ya aksihâk mem matŋe bâleŋe kâpekyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yâhâ kainde hindâm kâlâwân pilâŋetâ sewuapgât yan, ya bonŋanâk tetewuap. Hâmbâi mâne Anitâŋe yâhâpŋe hâŋgânnohomu gewom. ");
INSERT INTO spl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gem aŋelolipne hâŋgânyongowom. Hâŋgânyongomune ari lohimbi orotmemeyeŋe kiŋgoŋ otmâ manmai me bukulipyeŋe otŋetâ bâleâk sâm kendâyiŋgimai komot yâhâp yâhâp ya mem matŋe bâleŋe kâpekyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Matŋe kâpekyiŋgim pilâyekŋetâ hem nâpumân ge hâhiwin pato nâŋgâmbisâi. ");
INSERT INTO spl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yâhâ lohimbi nombotŋaŋe Anitâhât den tem lâum manmai yâhâmâ awoŋnaŋe dâiyekmâ ikŋe laŋinŋan katyekmu manman kârikŋan mannomai. Den yuâmâ biwiyeŋanâk katmâ manmâ yâhânomai. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Otmu torokatmâ den âlâen hâum yuwu sâop. “Anitâŋe tihityeŋe otmâ manman kârikŋan katyekmu bonŋe menomai yan hâum yuwu sâwe. Lok âlâŋe tewetsenŋe mem ari misiŋgulop. Misiŋgutmâmâ ikŋe muop. Gâmâlâk mâneâmâ lok âlâŋe taka tewetsenŋe ya mem teteop. Mem tetem imbiâk nâhâitŋe kombo miap sâm nâŋgâmaihât yuwu nâŋgâop. “Yu kurihimune tatmu ari lok âlâhâlen senŋe âlâlâ tatnihiap ya kerek puluhum yakât hâmeŋambâ membomŋeâmâ âwurem taka hân yu puluhuwom. Puluhum yanâmâ hân otmu tewetsenŋe yâhâp yâhâp ambokuwom.” Yawu nâŋgâop. Nâŋgâop ya yawuâk olop. Hân otmu tewetsenŋe ya puluhum yâhâp yâhâp ambokuop. Yâhâ dop yawuâk yeŋe manman kârikŋe yakât bonŋe mene sâm senŋe âlâlâ tatyiŋgiap yakât ki nâŋgâŋetâ yahatbuap. Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Otmu yakât topŋe nâŋgâmunŋe keterahâkgât torokatmâ âlâ yuwu sâop. “Anitâŋe tihityeŋe otmâ manman kârikŋe yiŋgimu yakât bonŋe menomai yakât âlâen hâum sâwe. Bisinisi lok âlâŋe pânu hâkŋe âiloŋgo nandoroŋe ya membe sâm pâinmâ ariwuap dop yawu ya. ");
INSERT INTO spl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lok yaŋe pânu hâkŋe ekmâmâ miakbe sâm ari iri sikum senŋe âlâlâ tatbaŋgiap ya mem ari puluhuwuap. Otmu yakât hâmeŋambâ membuap yaŋeâmâ âwurem ari pânu hâkŋe ya puluhuwuap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Âlâku yawuâk torokatmâ sâwe. Anitâŋe tihitnenŋe otmâ menenekmâ manman kârikŋan katnenekbuap yakât topŋe âlâ yuwu sâwe. Otmu âi lok nombotŋaŋe iŋan itâŋe pilâŋetâ gemu iŋan topŋe topŋe yakât kâlehen ge kutakulakmai. ");
INSERT INTO spl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ge kutakulakŋetâmâ mem dâiŋetâ gamap. Mem dâiŋetâ gamu yan âlepŋe yamâ mem ketetmâ waŋgaen katmai. Yâhâ iŋan ki neneŋe yamâ pilâŋetâ arimap. Dop yawu. ");
INSERT INTO spl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Yawu gârâmâ hâmbâi sâp patoen yu yan yukât bonŋe tetewuap. Aŋelolipne hâŋgânyongomune ge lohimbi yeŋgât biwiyeŋe ekmâ mem kiwiliyekmâ bâleŋahât pat mansai yamâ meyekmâ matŋe umatŋe yiŋginomai. Yiŋgim kâlâp kâlehen panyekŋetâ ge hâhiwin hilâm ârândâŋ nâŋgâm yâhâmbisâi. Yâhâ âlepŋe mansai yamâ hâmeŋe âiloŋgo yiŋginomai.” Yesuŋe den yawu sâm teteop. ");
INSERT INTO spl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Den ya sâm tiŋ pilâm yuwu sâm âinongop. “Yen den yan yukât topŋe nâŋgâŋetâ keteraksap me bia? Sâmu yuwu sâwin, “Oŋ. yat ya naŋgain.” Yawu sâmunŋe sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Otmu yakât yuwu sâmune nâŋgâŋet. Mosehât girem den kâsikum ningimai ya yeŋgâlen gâtŋe âlâ me âlâŋe nâhât den yu nâŋgâmâmâ biwiyeŋe nâhâlen katmâ mannomai. Yakât topŋe nâŋgâŋetgât den âlâen hâum yuwu sâwe. Emet amboŋaŋe senŋe âlâlâ emelâk gâtŋe otmu âiŋe yâhâp yâhâp mem mansap yapâ mem bukulipŋe tânyongomap dop yawu. Ya nâŋgâŋetâ keterahâkgât yuwu sâmune nâŋgâŋet. Emelâk Moseŋe girem den ekyongop ya sâm tetemune topŋe naŋgai. Otmâ den yiwereŋe yan yukât topŋe naŋgai. Yeŋe den yâhâp yâhâp ya nâŋgâm Anitâhât topŋe kâsikum yiŋgim mansai yawu. ");
INSERT INTO spl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuŋe den âlâen hâum sâm tiŋ pilâm menenekmu orowâk yahatmâ ariwin. ");
INSERT INTO spl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yahatmâ ikŋe kapiân ariwin. Yan ari miti emetŋan yâhâ den kâsikum yiŋgiop. Den kâsikum yiŋgimu kapilipŋaŋe den ya nâŋgâŋetâ âlâ kândâkdâ otmu pârâk pilâm yahatmâ yuwu sâwi. “Bâe, lok yuâmâ nengâlen gâtŋe. Wosapâ ari kândiwahom nâŋgân nâŋgân topŋe topŋe yu mem taka kâsikum ningim kulem âlâlâ tuhum mansap? Yu ekmunŋe sâtŋe oap. ");
INSERT INTO spl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ikŋe topŋe naŋgain. Âwâŋe Yosepŋeâmâ emet tuhum manmap. Yâhâ mâmâŋeâmâ nenŋan gâtŋe, kutŋe Maria. Otmu imilipŋe ya gurâ nâŋgâyiŋgiainâk, kutyeŋe. Yakowo, Yosep, Simon, Yurasi. ");
INSERT INTO spl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Otmu garilipŋe yawuâk.” Yawu sâwi. Topŋe kerek nâŋgâwi yakât otmâ den kâsikum yiŋgim manop ya nâŋgâŋetâ tâŋât otmu betguwi. ");
INSERT INTO spl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yawuhât Yesuŋe yuwu sâm ekyongop. “Anitâhât poropetelipŋaŋe kapi hawamgum ari yâkât den kâsikum yiŋgiŋetâ nâŋgâŋetâ bulâŋe otmap. Yâhâ yâkŋe hep torehenlipyeŋe den kâsikum yiŋgiŋetâ nâŋgâŋetâ tâŋât otmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesuŋe den kâsikum yiŋgimu nâŋgâŋetâ tâŋât olop yakât otmâ ikŋe kapi ambolipŋaŋe yâkâlen biwiyeŋe ki katbi. Yakât otmâmâ yâk yeŋgât hohetyeŋan kulem amon âlâek tuhuop. ");
INSERT INTO spl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Otmu sâp yanâmâ Galilaia yeŋgât lok kunŋe âlâ manop, kutŋe Herot Antipa sâm, yâkŋeâmâ Yesuŋe âi âlâlâ mem manop yakât den pat nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Pat ya nâŋgâmâmâ hoŋ bawalipŋe yuwu sâm ekyongop. “Lok âlâ, kutŋe Yoane sâm, yâkŋe embâŋâmbâek topŋe katmâ lohimbi toen mem katyekmâ gaop. Yâhâmâ tembe lâulipne hâŋgânyongomune ari kuŋetâ muop. Muop yamâ yahatmâ kulem topŋe topŋe yu mem gap mon?” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yâhâ Herotŋe sâmu Yoane kuŋetâ muop yakât topŋe yuwu. Herot yet Pilip yamâ imi ata. Aŋgoân Pilipŋeâmâ imbi, kutŋe Herotia sâm, ya miop. Memu manmâ manmâ imbi yaŋe lokŋe hâkâŋ otmâ pilâmuâmâ kahaŋe Herot ya orop miahowot. ");
INSERT INTO spl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yawu otmâ manmutâ Yoaneŋe yelekmu bâlemu yuwu sâop. “Nengât girem den kuawot ya ekmune dondâek bâleap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yawu sâm kuyitgimu yanâmâ Herotŋe kumune muâkgât nâŋgâop. Yawu gârâmâ lohimbi inŋaŋe “Yoane yamâ Anitâhât poropete,” sâm nâŋgâwaŋgiŋetâ yahalop. Yakât otmâ Herotŋe biwiŋaŋe yuwu nâŋgâop. “Lok yu kumune muâkgât naŋgan. Yâhâ kumune mumbuap yanâmâ lohimbi seseŋgâlâkŋe nâhât nâŋgâŋetâ dondâ gemu sâm bâlenihinomai. Yakât otmâ ki kumbom.” Yawu nâŋgâm tembe lâulipŋe hâŋgânyongomu Yoane sâhâm mem ari pâi emetŋan katŋetâ sâp kâlep yan tatmâ gaop. ");
INSERT INTO spl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Otmu sâp âlâen Herotŋe teteop yakât heroŋe otne sâm bukulipŋe nombotŋe taka menduhuakmâ sot um newi. Sot nem heroŋe otŋetâ yanâmâ baratyetŋaŋe yahatmâ kep ândeop. ");
INSERT INTO spl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kep ândemu Herotŋe ekmâ biwiŋe heroŋe otmâ yuwu sâm ekuop. “Anitâhât senŋan kinmâ sâmune nâŋgâ. Gâŋe wuân me wuângât nâŋgâm sârâ âlepŋe gihiwom.” Yawu sâop. Yawu sâmu sururuk sâm ari mâmâŋe yuwu sâm ekuop. “Awoŋnaŋe iri sikum ikŋambâ gâtŋe ya kâsikum nihiwomgât sâm naŋgap. Yakât otmâ wuân membomgât naŋgat?” ");
INSERT INTO spl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sâmu sâop. “Yoane yamâ kuŋetâ muâkgât naŋgan. Yakât otmâ eŋgatŋe hâreŋetâ kunŋe mem ga tiripnohorâ ekbom.” Yawu sâm baratŋe hâŋgângumu âwurem ari âwâŋe yuwu sâm ekuop. “Gâŋe tembe lâulipge ekyongorâ Yoane eŋgatŋe hârem kunŋe kondoân katmâ mem ga nihiŋet.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yawu sâmu Herotŋe den ya nâŋgâm biwiŋaŋe ki ârândâŋ olop. Yamâ benŋe emelâk Anitâhât senŋan sâm kârikŋe tuhuop. Yakât otmâ bukulipŋaŋe nâŋgâwaŋgiŋetâ gemapgât den ya lauŋan miop. ");
INSERT INTO spl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Yawu otmâ tembe lâu âlâ hâŋgângumu pâi emetŋan yâhâ Yoane eŋgatŋe hâreop. Eŋgatŋe hârem kunŋe mem kondoân katmâ mem ge baratyetŋe waŋop. Waŋmu lâum mâmâŋahâlen ari tiripgumu ekmâ biwiŋe heroŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yakât den pat ya Yoane hoŋ bawalipŋaŋe nâŋgâm lâum ari hanguwi. Lâum ari hangumâmâ den pat ya Yesu ari ekuwi. ");
INSERT INTO spl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuŋe den pat ya nâŋgâm ikŋe kapi pilâm nen orowâk waŋga mem deŋgân ya hâtikgum lok biaengen ariwin. Arimunŋe lohimbi nombotŋaŋe kapi ya pilâm nen watnenekmâ deŋgân ginŋe watmâ ariwi. ");
INSERT INTO spl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Watmâ ariŋetâ waŋgaembâ kioŋmunŋe yanâk peneningiwi. Otmu lohimbi dondâŋe bukulipyeŋe mesek topŋe topŋe otbi ya meyekmâ takaŋetâ Yesuŋe yekmâ weŋe nâŋgâm heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yawu otmâmâ emetsâpŋe otmu yan yuwu sâm ekuwin. “Emetsenŋe emelâk purik yap. Gârâmâ yu tain yu hâlâŋmâ kapi tipi tapi âlâ ki tap. Yakât po yiŋgimapgât gâ âlepŋe hâŋgânyongorâ yahatmâ kapiyeŋehen ari sot um nenomai.” ");
INSERT INTO spl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sâmunŋe sâop. “O yawu ki tap. Yeŋe sot kâsikum yiŋgiŋetâ nen orowâk tatmâ neŋetgât naŋgan. ");
INSERT INTO spl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sâmu sâwin. “Bâe, nenâmâ sot pato ki tatningiap. Baŋga kândâkdâmâ mome otmu iŋan yâhâp âlâ kârikŋe yawuâk tap.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sâmunŋe sâop. “Sot ya mem ga nihiŋet.” Yawu sâmu mem yâhâ waŋbin. ");
INSERT INTO spl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Waŋmunŋe lohimbi ekyongomu ge tatbi. Ge tatŋetâ sot ya mem himbimân pak sâm ekmâ Anitâ mepaem ekuop. Anitâ ekum mem ningimu ârândâŋâk kâsikum yiŋgim ariwin. ");
INSERT INTO spl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yiŋgimunŋe neŋetâ dopyeŋan olop. Dopyeŋan otmu, nombotŋe talop ya hâwurum mânuŋmunŋe saka saka kâiân yâhâp pik sâop. ");
INSERT INTO spl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Otmu lok sot newi ya sâlikyoŋgomunŋe 5000 yakât dop olop. Yâhâ imbi naomlipyeŋe yamâ ki sâlikyongowin. ");
INSERT INTO spl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sot nem pesuk pilâŋetâ Yesuŋe hâŋgânnongom yuwu sâop. “Yeŋe waŋga mem kulet sâm ba ariŋet. Nâŋeâmâ lohimbi yu hâŋgânyongomune ariŋetâ yeŋgât betyeŋan watyekbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yawu sâm hâŋgânnongomu arimunŋe lohimbi ya gurâ yawuâk hâŋgânyongomu yahatmâ itoŋ galaŋ otmâ ariwi. Ariŋetâ ikŋiâk tatmâ Anitâ ulitguwe sâm pumŋan yâhâop. Pumŋan yâhâ âwâŋe orop den otmutâ emet ŋiŋ sâop. ");
INSERT INTO spl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Emet ŋiŋ sâmu nenâmâ waŋga mem ari emelâk deŋgân tânâmgum tatbin. Tânâmgum tatmunŋe ariwinângembâ siru pato pilâm waŋga mem kopa kopa tuhuop. ");
INSERT INTO spl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yâhâ emet eŋgatŋe nâŋgâmu yan Yesuŋe to kakŋambâ takaop. ");
INSERT INTO spl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Takamu ekmâ tepnenŋe hindakmu hu halak tuhum yuwu sâm alahuwin. “O, yuâmâ weke mon takap.” Yawu sâm kiŋgitnenŋahât otmâ kâi bâtnenŋe sân sân sâop. ");
INSERT INTO spl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yawu otmunŋe yuwu sâm eknongop. “Yen wongât otmâ kiŋgityeŋahât otmâ kâi bâtyeŋe sân sân yap? Nâ ninak takan yukâ.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yawu sâmu tepnenŋe welâmŋan gemu Petoroŋe yuwu sâm ekuop. “Gâ wuân lok mansat yakât topge nâŋgâwe. Sârâ nâku kioŋmâ to kakŋambâ gâhâlen gawe.” Yawu sâm âikuop. ");
INSERT INTO spl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Âikumu sâop. “Âlepŋe, kioŋmâ ga.” Sâmu kioŋmâ baop. ");
INSERT INTO spl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bam to yaŋe dondâ bâleop ya ekmâ pârâk pilâm eŋgat yâhâp otmâ yaŋak to kâlehen ge gulip otbe sâm olop. ");
INSERT INTO spl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yawu otmâ yuwu sâop. “Getek bâtnan me.” Sâmu bâtŋan mem yuwu sâm ekuop. “Gâ wongât eŋgat yâhâp oat?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yawu sâm mem yahatmu yanâk siru ya sânduk sâm nâŋ nâŋ sâop. ");
INSERT INTO spl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yawu otmu ekmâ biwinenŋaŋe yuwu nâŋgâwin. “Bulâŋanâk lok yuâmâ Anitâhât nenŋe mansap.” Yawu sâwin. Yawu sâm yapâ orowâk ariwin. ");
INSERT INTO spl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Deŋgân ya hâtikgum hân âlâ, kutŋe Genesaret sâm, yan ari kioŋmâ waŋga hikumunŋe kinop. ");
INSERT INTO spl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hikumunŋe kinmu kapi ya ambolipŋe Yesu ekmâ nâŋgâwi. Ekmâ nâŋgâm den katŋetâ kapi tipi tapi hân ya hawamgum tatmâ arap ya ambolipŋaŋe nâŋgâwi. Nâŋgâm kundat, me mesek, me umatŋe topŋe topŋe teteyiŋgiop ya meyekmâ yâkâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Meyekmâ ari Yesuŋe mem heŋgemyongoâkgât yuwu sâm ulitguwi. “Lok pato. Nengâlen gâtŋe kundat me umatŋe topŋe topŋe teteyiŋgimu tatmai yu meyekmâ tohoain. Yawu gârâmâ sombemân menduhum katyekmunŋe gotyeŋanâk arirâ gâhât sâŋgum ya konok wâim yan âlepŋe otŋetgât naŋgain.” Sâŋetâ sâop. “Den yai ya âlepŋe otŋet.” Yawu sâmu nombotŋaŋe sâŋgumŋe wâim yaŋak âlepŋe otbi. ");
INSERT INTO spl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisaio otmu Mosehât girem den kâsikum ningiminiwi hârokŋe tâmbâlipnenŋe yeŋgât den lâum kinmâ sot nene sâm bâtyeŋe piriakmâ sot mem neminiwi. Inâk ki newi. Lok yaŋe Yerusalem kapi pilâm Yesuhâlen ari yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Hoŋ bawalipgaŋe tâmbâlipnenŋe yeŋgât den kum bâtyeŋe ki pirim sot niai. Yawu otmâ sot inâk neŋetâ yekmunŋe dondâ bâleap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sâŋetâ purik pilâyiŋgim yuwu sâop. “Yenâmâ nimbilamyeŋe yâhâp. Anitâŋe den sâm kalop ya kum yeŋe nâŋgân nâŋgânân tetemap ya mem mete tuhumai. Yawu otŋetâ yekmune dondâ bâleap. ");
INSERT INTO spl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yakât topŋe yuwu sâwe. Anitâŋe Mose ekumu kulemguop yan girem den âlâ yuwu tap. “Yen âwâ mâmâlipyeŋe yeŋgât nâŋgâyiŋgim denyeŋe lâum manŋet.” Otmu âlâmâ yuwu tap. “Yen âwâ mâmâlipyeŋe den bâleŋe ki hâiyeknomai. Me ki sâm bâleyiŋginomai. Yâhâ yeŋgâlen gâtŋe âlâ me âlâŋe den yu kunomai yanâmâ mumuhât yongonomai.” Den yawu tap. ");
INSERT INTO spl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yeŋe den ya kum mansai yakât sâwe. Yeŋe yuwu sâmai. “Lohimbi âlâ me âlâŋe âwâŋe mâmâŋe yuwu mon sâm ekyotgonomai. ");
INSERT INTO spl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Awoŋ, meŋ, sombo otdomawot yanâmâ sot me senŋe âlâlâ âlepŋe tânyotgowom.” Yawu sâm ekyotgonomai. Yawu gârâmâ sombo otdomawolân yuwu mon sâm ekyongonomai. “Senŋe âlâlâ yuâmâ Anitâhât pat kuwan yakât otmuâmâ mem miti emetŋan ari katmunŋe tatbuap yakât yaŋe ki mem tânyotgowom. Inâk tatset.” Yawu sâm betyotgoŋetâ umatŋe kakŋan mandomawot. Nanlipyeŋaŋe tewetsenŋe mem miti emetŋan katmai yakât nâŋgâŋetâ yahatmap. Gârâmâ Anitâŋeâmâ yawu yakât nâŋgâmu dondâ gemap. Yeŋe yawu otmâ yan Anitâhât den nâŋgâŋetâ nahat otmap. ");
INSERT INTO spl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yen lok perâkŋe. Anitâŋe yeŋgât topyeŋe tap yakât nâŋgâm poropete Yesaia ekumu kulemguop ya yuwu tap. ");
INSERT INTO spl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Lohimbi yuŋe lauyeŋaŋak nâ mepaenekmai. Yâhâ biwiyeŋaŋeâmâ ki hikunekmai. ");
INSERT INTO spl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yâkŋe lok senyeŋan kinmâ yeŋe eŋgatyeŋeâk otmâ den sâm nâhâlen gâitmai. Yâhâ lauyeŋaŋak perâk perâk sâm orotmemeyeŋe yakâlâk nâŋgâŋetâ yahatmu nâhâlen gâitmai. Yawu.” Den kulemguop yakât bulâŋe yeŋgâlen teteap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuŋe yawu sâmu lohimbiŋe yâkât gotŋan baŋetâ yuwu sâm ekyongop. “Yuwu sâmune nâŋgâm biwiyeŋan katŋet. ");
INSERT INTO spl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yu me ya lauyeŋambâ neŋetâ tepyeŋan gemap yaŋeâmâ ki mem bâleyekmap. Yâhâ yu me ya nâŋgân nâŋgânyeŋambâ tetemu sâŋetâ lauyeŋambâ ga takamap. Yaŋeâmâ dondâ mem bâleyekmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yawu sâmu yuwu sâm ekuwin. “Den yat ya Parisaio lok yaŋe nâŋgâŋetâ biwiyeŋan hâumu nâŋgâm bâlehihiai.” ");
INSERT INTO spl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sâmunŋe sâop. “Awoŋne himbim amboŋaŋe âi lok ki katyekmap yamâ hâmbâi watyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yawu awoŋnaŋe Parisaio âi ki sâm yiŋgiop. Yawuhât yeŋe yâk yeŋgât nâŋgâm ki gorâyiŋgiâk. Parisaio yeŋgât topyeŋe teteâkgât den âlâen hâum sâwe. Lok senyeŋe bok sâsâŋaŋak dâiakmâ mâtâp tâpikgum ari hemân kioŋnomai. Kioŋmâ hiliwahonomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yawu sâmu Petoroŋe yuwu sâm ekuop. “Kutdâ, den âlâen hâum yat yakât topŋe sârâ nâŋgâne.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sâmu sâop. “Bâe, haoŋmâ ârândâŋ den topŋe topŋe sâman yamâ girawu otmâmâ kiâk nâŋgâŋetâ keterakmap? ");
INSERT INTO spl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yeŋe sot lauyeŋambâ neŋetâ tepyeŋan gemap. Otmu yaŋak tetmâ pilâŋetâ wahap tâŋât otmap. ");
INSERT INTO spl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yâhâ wahap bulâŋe yamâ biwi nâŋgân nâŋgânyeŋan tatmap ya sâŋetâ lauyeŋambâ ga takamap. ");
INSERT INTO spl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Orotmemeyeŋe yuwu yaŋe umut biwiyeŋe otmu nâŋgân nâŋgânyeŋe mem bâlemap. Nâŋgâm bâleaŋgimai. Me den hakoa oraŋgimai. Me den belângen sahaŋgimai. Me kombo miaŋgimai. Me buku âlâhât imbi ekmâ otmai. Me lohimbi sihan eŋakŋâlemai. Me manman ihilâk mahilâk otmai. Karasuŋa me sait bâleŋe topŋe topŋe yawu otmai. Me den imbiâk biwiyeŋambâ tetemu den golâ gahaemai. ");
INSERT INTO spl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yu sâm aran yuŋeâmâ biwiyeŋe mem bâlemap. Yâhâ bâtyeŋe pirim me ki pirim sot nemai yaŋeâmâ tâŋât oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesuŋe menenekmu kapi ya pilâm kapi yâhâp, kutyetŋe Tiro otmu Siron yan ariwin. ");
INSERT INTO spl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yan arimunŋe kapi âlâ, kutŋe Kanan sâm, yan gâtŋe pâku imbi âlâ yaŋe Yesuhâlen taka yuwu sâm ulitguop. “Gâ Dawitihât sen, yuwu sâmune nâŋgâ. Weke bâleŋaŋe baratne mem mâŋgâemu mansap. Yakât gâŋe watdâ ariâkgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yawu gârâmâ aŋgoân Yesuŋe Yura nengâlen gem tânnongoâkgât âi ya Anitâŋe sâm waŋop. Yakât otmâmâ den ya nâŋgâm ekmâ ki ekmâ yawu olop. Yawu otmu imbi yaŋe witgum âi pâi tuhum watnenekmu yanâmâ Yesu yuwu sâm ekuwin. “Kutdâ, imbi yu âi pâiâk tuhunenekmâ gamu ekmâ hâkâŋ oain. Yakât otmâ gâku tânnongom ekurâ yapâek ariâk.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yawu sâmunŋe Yesuŋe imbi ya yuwu sâm ekuop. “Isirae lohimbi gulip malap mansai yaŋe Anitâhâlen biwiyeŋaŋe kepeim manŋetgât ikŋak hâŋgânnohomu gewan. Pâku lohimbi yeŋgâlen nep tuhuwomgât ki hâŋgânnohomu gewan.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yawu sâmu yâku ulitgum yuwu sâop. “Gâŋe nâ yiwereŋeâk tânnohohât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sâmu sâop. “Nengât orotmeme yuwu tap. Nan baralipnenŋe sot nem tatŋetâ yan sot lauyeŋambâ hindâm soso gotŋan ki pilâmain.” ");
INSERT INTO spl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sâmu sâop. “Lok pato, den yu nâŋgâmune bulâŋe oap. Gârâmâ nâŋe yuwu sâwe. Nan baralipyeŋe sot neŋetâ wahapŋe lauyeŋambâ gemap yamâ sosoŋe nemai.” ");
INSERT INTO spl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sâmu sâop. “Imbi, biwihaŋe yawu nâŋgâm den yat ya nâŋgâmune ârândâŋ oap. Gikak naŋgat ya yawuâk tetehihiâk.” Yawu sâm ekuop. Yawu sâm ekumu yanâk weke bâleŋe gaiakbaŋgim ba ariop. Yâhâ imbi yaŋe emetŋan âwurem ari baratŋe ekmâ biwiŋe heroŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuŋe menenekmu Galilaia deŋgân ya ginŋan ge pâku lohimbi yeŋgât hân horatŋambâ ariwin. Ari pumŋe âlâen yâhâ tatbin. ");
INSERT INTO spl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yâhâ tatmunŋe kapi ambolipŋaŋe bukulipyeŋe umatŋe teteyiŋgiop ya dâiyekmâ nengâlen takawi yamâ yuwu. Nombotŋe senyeŋe bok sâsâŋe. Otmu ândâpyeŋe bok sâsâŋe. Otmu kâiyeŋe goŋ goŋe. Me bâtyeŋe pareŋe. Me kopa. Me kundat topŋe topŋe teteyiŋgiop ya. ");
INSERT INTO spl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dâiyekmâ takaŋetâ Yesuŋe kerehâk heŋgemyongomu ekŋetâ âlâ kândâkdâ olop. Yawu otmâ Isirae nengât Anitâ mepaewi. ");
INSERT INTO spl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Anitâ mepaeŋetâ yanâmâ Yesuŋe sâmu yâkâlen bamunŋe yuwu sâm eknongop. “Lohimbi yu orowâk tatmâ gamunŋe hilâm kalimbu pesuk yap. Yawu gârâmâ sot miakmâ takawi ya nem pesuk pilai. Yakât otmâ tepne nâŋgâyiŋgian. Sot barahâk âwurem mâtâwân po yiŋgimu sen biri yiŋgimapgât inâk ki arinomai naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sâmu sâwin. “Yuâmâ lok ki manmaiângen mansain. Yawuhât nen sot wosapâ mem yiŋgimunŋe neŋetâ dopyeŋan otbuap?” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sâmunŋe sâop. “Yeŋgâlen wuân sot tap?” Sâmu sâwin. “Baŋga kândâkdâmâ nombolân yâhâp, otmu iŋan getek âlâ.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yawu sâmunŋe Yesuŋe lohimbi ekyongomu ge tatbi.” ");
INSERT INTO spl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ekyongomu ge tatŋetâ Anitâ mepaem baŋga otmu iŋan ya mem ningiop. Ningimu kâsikum yiŋgimunŋe mem newi. ");
INSERT INTO spl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Neŋetâ dopyeŋan otmu hâŋgânyongomu ariwi. Sot neŋetâ torehenŋe talop ya menduhum mânuŋmunŋe saka saka nombolân yâhâp pik sâop. ");
INSERT INTO spl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yâhâ lok papato sâlikyongomunŋe 4000 ya wangiop. Yâhâ imbi naom yamâ ki sâlikyongowin. ");
INSERT INTO spl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuŋe hâŋgânyongomu ariwi. Ariŋetâ nenâmâ waŋga âlâ mem kapi âlâ, kutŋe Maharan sâm, yaken ariwin. ");
INSERT INTO spl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Otmu sâp âlâen Parisaio otmu Sarukaio nombotŋaŋe Yesuhâlen ari yuwu sâm âikuwi. “Anitâŋe hâŋgângohomu ge mansat sâmai. Ya perâk me bulâŋanâk. Yakât otmâ gâŋe sârâ himbimâmbâ kulem âlâ tetemu ekmâ topge nâŋgâne.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sâŋetâ sâop. “Bâe, yen kulemgât yai. Yawu gârâmâ kulem âlâlâ otmune topŋe ekmâ hâum pâpguai. Yakât otmâmâ âlâ otmune yawuâk hâum pâpgunomai. Yakât âlâen hâum sâwe. Emetsâpŋe otmu yan himbim topŋe palalaŋ sâm kuririŋgumap. Yawu otmuâmâ yuwu sâmai. “O, yuâmâ emet heŋgeŋguwe sâm oap. Me sikop otbe sâm oap.” Yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yâhâ himbim topŋe ya heleŋgumap. Yanâmâ yeŋe yuwu nâŋgâmai. “O, yuâmâ toŋgelâk otbe sâm oap.” Yawu sâmai. Yeŋeâmâ to yambu otmu sikop yakât topŋe ekmâ nâŋgâm heŋgeŋguai. Yâhâ nâŋe kulem âlâlâ memune eksai yakât topŋeâmâ girawuhât ki ekmâ nâŋgâm heŋgeŋguai? ");
INSERT INTO spl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yakât yâhâpŋe torokatmâ sâwe. Lohimbi yu yeŋgât topyeŋe teteâkgât yuwuyaen hâum sâwe. Imbi nombotŋaŋe loklipyeŋe betyeŋehen kioŋmai yakât dopŋeâk yeŋeâmâ Anitâhât betŋehen kioŋetâ dondâ bâlemap. Yawuhât kulem âlâ memune ekne sâm yakât âinohoai. Yakât yuwu sâmune nâŋgâŋet. Embâŋân poropete âlâ, kutŋe Yona sâm, yâkâlen kulem âlâ tetemu Niniwe kapi ambolipŋaŋe ekbi. Yakât dopŋeâk nâhâlen kulem âlâ tetemu eknomai.” Yawu sâop. Yawu sâmu waŋgaen yâhâm âlâengen ariwin. ");
INSERT INTO spl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Waŋga mem deŋgân nombot hâtikgum ariwin yan nelâmâk otmâ sot barak ariwin. ");
INSERT INTO spl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sot barak arimunŋe yakât otmâ Yesuŋe yuwu sâm eknongop. “Parisaio otmu Sarukaio yeŋgât matuk keluŋaŋe mem bâleyekmapgât galem oraŋginomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yawu sâmu nenŋe yakât topŋe nâŋgâm pâpgum yuwu sâm alahuwin. “Sot ki mem takain. Yakât mon yap.” ");
INSERT INTO spl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yawu sâm alahumunŋe biwinenŋahât topŋe ekmâ yuwu sâm eknongop. Yen sotgâlâk biwiyeŋe katmâ den yan yukât topŋe ki nâŋgâŋetâ keteraksap. Yakât otmâ nâhâlen biwiyeŋaŋe ki tiŋâk kepeiai. ");
INSERT INTO spl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yakât nâŋgâmune ki ârândâŋ oap. Yenâmâ sotgâlâk naŋgai. Yakât sâwe. Sot momeâk mem motokmâ lok 5000 ya yiŋgimunŋe neŋetâ dopyeŋan olop. Neŋetâ torehenŋe talop ya saka saka amon mem mânuŋetâ pik sâop? ");
INSERT INTO spl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Otmu sâp âlâen lok 4000 ya gurâ baŋga nombolân yâhâp yaŋahâk yiŋgimunŋe newi. Neŋetâ torehenŋe talop ya saka saka amon mem mânuŋetâ pik sâop? ");
INSERT INTO spl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Den ekyongoan yu nâŋgâŋetâ keterakyiŋgimbâp. Yâhâ yeŋe imbiâk nâhâitŋe “sotgât yap” sâm nâŋgânihiai. Yakât yâhâpŋe sâmune nâŋgâm heŋgeŋguŋet. Parisaio otmu Sarukaio yeŋgât matuk keluŋe yaŋe mem bâleyekmapgât galem oraŋginomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yawu sâm eknongomu nâŋgâmunŋe keterakmu yuwu sâwin. “O, yâhâmâ sotgât ki yap. Yâhâmâ Parisaio otmu Sarukaio yeŋgât den nâŋgâm lohotŋe otmaingât yap.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yapâ yahatmâ, kapi âlâ kutŋe Kaisaria sâm, kutŋe âlâmâ Pilip sâm, yan ariwin. Yan arimunŋe Yesuŋe yuwu sâm âinongop. “Nâmâ Anitâŋe hâŋgânnohomu gewan. Yakât otmâmâ lohimbiŋe nâhât âlâ sâmai?” ");
INSERT INTO spl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sâmu sâwin. “Nombotŋaŋe gâhât yuwu sâmai. “Yoane Baptis emelâk kuŋetâ muop ya mumuŋambâ yahatmâ mansap,” yawu sâmai. Yâhâ nombotŋaŋeâmâ poropete âlâ, kutŋe Elea, emelâk himbimân yâhâop yaŋe purik sâm ge mansap,” yawu sâmai. Yâhâ nombotŋaŋeâmâ “Poropete âlâ, kutŋe Yeremia, me poropete âlâ mumuŋambâ yahatmâ mansap,” sâmai.” Yawu sâm ekuwin. ");
INSERT INTO spl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sâmunŋe sâop. “Yâhâ yeŋeâmâ nâhât âlâ sâmai?” Yawu sâmu Petoro, kutŋe âlâmâ Simon sâm, yâkŋe yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","“Anitâŋe hâŋgângohomu ge mansat ya nâŋgâmunŋe bulâŋe otmap. Yakât otmâ gâmâ yâkât nanŋe tâŋ tâŋ ya naŋgain.” ");
INSERT INTO spl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sâmu sâop. “Simon, Yoane nanŋe, bukulipgaŋe ekgohoŋetâ ki yat. Awoŋne himbimân tatmapŋe den yu biwihan katmu yat yakât Anitâŋe nâŋgâhihimu âlepŋe oap. Yakât biwihe heroŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yâhâ gike kutgeâmâ Petoro, kut yukât topŋeâmâ “Kât” yawu tap. Gârâmâ nenŋe kât mem emet tuhumunŋe ŋiwiŋ ŋiwiŋ sâmap ya ki putuk sâm liwarakbuap. Yakât dopŋeâk lohimbi nâhâlen ga torokatmai ya ki hiliwahonomai. ");
INSERT INTO spl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yakât sâwe. Nâŋe mâmâŋe otgihimune lohimbi yeŋgât kunyeŋe manbuat. Yanâmâ yâkŋe otŋetâ bâlemapgât gâŋe sâm kuyiŋgiwuat nâku yawuâk kuyiŋgiwom. Yamâ yâkŋe âlepŋe otŋetgât sâm yiŋgiwuat nâku yawuâk nâŋgâwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Otmu yuwu sâm kuningiop. “Nâ bulâŋanâk Anitâŋe hâŋgânnohomu gewan. Yakât otmâ lohimbi ihilâk ki ekyongonomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Otmu sâp yan Yesu sâm bâlewaŋgim mem âlâlâ tuhunomai yakât tetekŋan eknongop. “Topŋe katmâ Yerusalem kapiân yâhâmune yan Isirae nengât kunlipnenŋe, otmu Mosehât girem den kâsikum ningimai ya, otmu hotom umai yeŋgât kunlipyeŋe kerekŋe sâm bâlenihim mem âlâlâ tuhum nohoŋetâ mumbom. Mum yan hân kâlehen hilâm kalimbu tatbom. Yawu otmâ yaŋak mumuŋambâ yahatbom.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yawu sâm eknongomu Petoroŋe dâimu pereŋ pilâm ba yetŋiâk kinmâ yuwu sâm ekuop. “Kutdâ, umatŋe topŋe topŋe otnihinomai sâm tat ya ki tetewuapgât naŋgan. Bia kârikŋe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sâmu purik pilâm yuwu sâm ekuop. “Gâŋe mâtâp ki maŋgunihi. Mâtâp maŋgunihirâmâ Satanŋe tepŋe heroŋe otbuap. Gâŋe den yat yu Anitâŋe sâm nihiop ya ki lâuap. Yuâmâ lokgât nâŋgân nâŋgân yat. Ya nâŋgâmune ki ârândâŋ oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yawu sâm ekum yaŋak purik pilâm yuwu sâm eknongop. “Lohimbi âlâ me âlâŋe biwiyeŋe nâhâlen katmaiŋe nâhâlen torokatne sâm yan yeŋahât ki nâŋgâŋetâ yahatbuap. Me senŋe âlâlâ tatyiŋgiap ya biatningimap sâm yakât ki nâŋgâm ketet otmâ eŋgat yâhâp otnomai. Nâhât den haoŋmâ ârândâŋ nâŋgâm tem lâunihim mannomai. ");
INSERT INTO spl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yâhâ lok âlâ me âlâŋe manmanyeŋe alilaknomai yamâ hiliwahonomai. Yâhâ lok âlâ me âlâŋe biwi nâŋgân nâŋgânyeŋe nâhâlâk katmâ mannomai. Yawu otmâ manŋetâ yongoŋetâ munomai yamâ Anitâŋe mumuŋambâ mem yahatyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yawu gârâmâ lok âlâ me âlâŋe senŋe âlâlâ, iri sikum me manman topŋe topŋe yan torokatmâ biwi nâŋgân nâŋgânyeŋe yan hikum munomai yaŋe mumuŋambâ yahatnomaihât dop ki tap. Yâhâ manman yawu yakât matŋe âlepŋe Anitâŋe yiŋgiwuapgât dop âlâ ki tap. Yakât yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hâmbâi sâp patoen Himbim Awoŋnaŋe yâhâpŋe hâŋgânnohomu aŋelolipne meyekmune hânân genom. Gem yan manmanyeŋahât matŋe âlâku ikŋiâk ikŋiâk kâpekmâ yiŋgiwom. ");
INSERT INTO spl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yen ki mum meteŋetâek nâ lok bulâŋe mansanŋe galemyeŋe otmâ yâhâwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yâhâ yakât kakŋan hilâm nombolân konok pesuk sâmu Yesuŋe Petoro, Yakowo otmu imiŋe Yoane ya yeŋeâk meyekmu nen katnenekmâ pumŋe âlâen yâhâwi. ");
INSERT INTO spl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yan yâhâŋetâ Yesuhât kun kundenŋaŋe âlâ otmu ekbi. Otmu senŋeâmâ dewutâ senŋe gam irik irik sâmap yawuya teteop. Yâhâ sâŋgumŋaŋeâmâ kaok bolaŋ bolaŋ otmâ kâlâp kokotŋe laŋ laŋ sâmap yawuya olop. ");
INSERT INTO spl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sâp yanâmâ Mose yet Elea emelâk Anitâŋe meyelehop yaŋe yanâk pârâk sânsânâk tetemutâ orowâk den alahu gulahu otbi. ");
INSERT INTO spl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Den alahu gulahu otŋetâ Petoroŋe ekmâ Yesu yuwu sâm ekuop. “Kutdâ, kulem aŋgo teteap yukât yuwuya âlâ ki ekmain. Yu ekmunŋe âiloŋgo oap. Yawu gârâmâ gâŋe sârâ nâŋe selep kalimbu kumbomgât naŋgan. Âlâmâ gâhât, âlâmâ Mosehât, âlâmâ Eleahât.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yawu sâmu yanâk kulewoŋboŋ ge lâum kurihiyehop. Lâum kurihiyekmu yakât biwiŋambâ Anitâŋe yuwu sâop. “Bulâŋanâk yuâmâ nine nanne ombe bisine. Nâŋe biwinaŋe yâhâk hikum tatman. Yakât otmâ den sâwuap ya yeŋe mem biwiyeŋan katmâ tem lâuwaŋgim mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yawu sâmu hoŋ bawalipŋaŋe nâŋgâm kiŋgityeŋahât otmâ kun kundenyeŋe mem kurihiakmâ hânân ge pare pare iwi. ");
INSERT INTO spl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yawu otŋetâ Yesuŋe gotyeŋan ba yuwu sâm ekyongop. “Ki kiŋgityeŋahât otŋet. Yahatŋetâ arine.” ");
INSERT INTO spl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yawu sâmu yahatmâ lok yâhâp ya yelekŋetâ bialop. Yawu otmâ Yesu ikŋiâk kinmu ekbi. ");
INSERT INTO spl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yaŋak pumŋambâ âwurem mâtâwânâk ge Yesuŋe yuwu sâm ekyongop. “Ewan pumŋan Mose yet Elea tetemutâ den oain yakât in yawu ki ekyongonomai. Hâmbâi nohoŋetâ mum yahatbom yakât kakŋanâmâ yu eksai yukât sâm tetem ekyongoŋetâ nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yawu sâmu hoŋ bawalipŋaŋe Elea tetemu ekbi yakât nâŋgâm yuwu sâm âikuwi. “Mosehât girem den kâsikum ningimaiŋeâmâ yuwu sâmai. “Aŋgoân Eleaŋe yâhâpŋe tetemuâmâ Anitâŋe hâŋgângumu gewuap yâkât mâtâp mewaŋgiwuap.” Yawu sâmai. Yamâ girawuhât sâmai?” ");
INSERT INTO spl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sâŋetâ sâop. “Yamâ bulâŋanâk yai. Elea yâhâpŋe tetem mâtâp yai ya heŋgeŋguwuap. ");
INSERT INTO spl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yawu gârâmâ yai yakât nâŋe yuwu sâmune nâŋgâŋet. Elea yamâ emelâk takaop. Takamu yeŋgât kunlipyeŋaŋe ekmâ yâkât topŋe ki nâŋgâm kuŋetâ muop. Yâhâ Anitâŋe nâ hâŋgânnohomu gewan yawuâk nohoŋetâ mumbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yawu sâmu nâŋgâŋetâ keterakmu yuwu sâwi. “O, yuâmâ Eleahâlen hâum kinmâ yap yamâ Yoaneŋe tetem toen mem katyehop yâkât yap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mâtâwân gem tatŋetâ yan lohimbi dondâŋe lok âlâhât nanŋe ya nengâlen dâim takaŋetâ tângune sâm hâum pâpgum pilâwin. Yawu otmâ yakât den alahum kin tatmunŋe bukulipnenŋe pumŋehembâ ge peneningiwi. Peneningiŋetâ yan naom yakât âwâŋaŋe Yesu ekmâ gotŋan ga yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Lok pato, gâ ihilâk nannahât nâŋgâwaŋgi. Weke bâleŋaŋe nanne mem mâŋgâemuâmâ toen kioŋmap. Otmu senŋe gâwâŋ gâwâŋ sâm kâlâwân kioŋmu semap. ");
INSERT INTO spl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yawuhât nâŋe dâim hoŋ bawalipgaŋe sâŋetâ weke bâleŋaŋe yâkâlembâ gaiakmâ ariâkgât sâmune hâum pâpgum pilai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sâmu Yesuŋe nenekmâ yuwu sâm eknongop. “Yen wongât nâhâitŋe ki tânnongowuap yawu naŋgai? Yakât nâŋgâmune ki ârândâŋ oap. Nâ yen orop sâp kâlep manmâ yâhâwomgât dop ki tap. Yawuhât pilâyekmâ yâhâwom yan yeŋe girawu mannomai?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yawu sâm lok sihan yakât sâop. “Yen nâhâlen mem gaŋet.” Yawu sâop. Mem yâhâŋetâ weke bâleŋaŋe mâŋgâeop ya watmu gaiakmâ ba arimu yanâk âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Âlepŋe olop yakât topŋe nâŋgâne sâm Yesu yuwu sâm âikuwin. “Yu topŋe girawuhât nenŋe weke bâleŋe ya watne sâm hâum pâpguain?” ");
INSERT INTO spl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sâmunŋe sâop. “Yen nâhâlen biwi nâŋgân nâŋgânyeŋaŋe kepeim manmai mâne âlepŋe yuwu mon sâmbâi. “O, pumŋe enda huhuakmâ orotok sâm giâk.” Sâŋetâ âlepŋe huhuakmâ orotok sâm gembâp. Otmu âi nombotŋe tap ya âlepŋe torokatmâ membâi. ");
INSERT INTO spl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yamâ weke bâleŋe watmune ariap yaŋe kârikŋe bâleŋe. Yakât otmâ yeŋeâmâ den in sâŋetâ ki gaiakmâ ariap. Yâhâ weke bâleŋe yawuya ekmâmâ topŋe katmâ sot barak manmâ Anitâhâlen biwiyeŋaŋe kepeim ulitguŋetâ denyeŋe nâŋgâm gaiakmâ ariwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yawu sâmu nen kerehâk yapâ pilâm yahatmâ Galilaia hânângen ariwin. Ari Yesuŋe yuwu sâm eknongop. “Anitâŋe hâŋgânnohomu gewan nâhât kasalipnaŋe nohoŋetâ mumbom. ");
INSERT INTO spl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nohoŋetâ mum yan hilâm kalimbu hân kâlehen tatmâ mumuŋambâ yahatbom yakât sâp tâlâhuap.” Yawu sâm eknongomu biwinenŋaŋe nâŋgâmunŋe umatŋe bâleŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mâtâp ari Kapanaum kapi mewin. Kapanaum kapi mem Petorohât emet hawiŋan ari kinmâ den alahuwin. Alahum kinmunŋe lok nombotŋe opon kâmbukŋahât takesi meminiwi yaŋe taka Petoro yuwu sâm âikuwi. “Yeŋgât patoyeŋaŋe opon kâmbukŋahât takesi katmap me ki katmap?” Yawu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yawu sâŋetâ Petoroŋe sâop. “Oŋ, yawu otmapgâ.” Yawu sâmu emet kâlehen yâhâmunŋe Yesuŋe Petoro yuwu sâm âikuop. “Petoro, den yai yakât nâŋgârâ girawu oap? Yuwu sâm âihohowe. Lok komot girawuyaŋe tewetsenŋe mem hângât lok kutdâ yiŋgim mansai? Hângât lok kutdâ ya yeŋgât bukulipyeŋaŋe me kasalipyeŋaŋe?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sâmu sâop. “Bukulipyeŋe kapi ambolipŋaŋe tewetsenŋe ki katmai. Yâhâ kasalipyeŋe mem ge katyekŋetâ yâk yeŋgât amutyeŋan mansai yâkŋak tewetsenŋe katmai.” Sâmu sâop. “Bonŋanâk yat. ");
INSERT INTO spl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yawu gârâmâ nen Anitâhât komolân torokatmâ mansainŋe opon kâmbukŋan yâhâ takesi ki katnom yamâ âlepŋe. Yakât denŋe bia. Gârâmâ nâŋgâŋetâ bâlemapgât gâŋe netgât takesi yamâ yuwu tuhum katbuat. Gâŋe iŋan itâŋe mem ari deŋgânân pilârâ giâk. Gemu yan aŋgoân iŋan kioŋbuap ya mem tepŋe gâim duhatbuat. Tepŋe gâim duhatmâ tewetsenŋe yapâ mem tetewuat. Ya mem ari gike umut otmu nâhât umut katbuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yawu sâm ekumu Yesu yuwu sâm âikuwin. “Sâp patoen Anitâŋe tihitnenŋe otmuâmâ orowâk manmâ yâhânom yanâmâ nengâlen gâtŋe âlâ me âlâhât nâŋgârâ kunnenŋe manbuap?” Yawu sâm âikuwin. ");
INSERT INTO spl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yawu sâmunŋe naom tipiŋe âlâ gotnenŋan kinop ya hâum tiripnongom yuwu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Âinohoai yakât topŋe yuwu sâmune nâŋgâŋet. Nimnaom titipâŋe Anitâhât den nâŋgâm in yawu biwiyeŋaŋe lâum yâkât komot otmai. Yakât dopŋeâk otnomai yanâmâ Anitâŋe âlepŋe yen meyekbuap. Yâhâ yawu ki otnomai yamâ Anitâhât komolân torokatnomaihât dop âlâ ki tap. ");
INSERT INTO spl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yâhâ nimnaom titipâŋe yeŋahât nâŋgâŋetâ gemu huruŋ huruŋ manmai. Yakât dopŋeâk yeŋgâlen gâtŋe âlâ me âlâŋe yeŋahât nâŋgâŋetâ gemu huruŋ huruŋ mannomai. Lok yawuya yeŋgât nâŋgâmune yahatbuap. ");
INSERT INTO spl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yâhâ lok âlâ me âlâŋe naom tipiŋe yuwuya yakât nâŋgâŋetâ yahatmu buku otbaŋginomaiŋe nâ hoŋ banihimai yakât dop oap. ");
INSERT INTO spl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yâhâ lok âlâ me âlâŋe nimnaom titipâ nâhât pat manmai ya yeŋgât mâtâp maŋguyiŋgimai. Yamâ hâmbâi matŋe umatŋe menomai. ");
INSERT INTO spl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Den yan yakât torokatmâ âlâen hâum yuwu sâwe. Satanŋe yen kerek mem ge katyekbe sâm otmu yakât lohotŋe otne sâm oai. Yakât tepne naŋgan. Lohimbi âlâ me âlâŋe Satangât tem lâum yan, bukulipyeŋe otŋetâ bâleâkgât kendâyiŋgimai yakât matŋe Anitâŋe umatŋe yiŋgiwuap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yakât torokatmâ sâwe. Bulâŋe hârenomaihât ki sâwom. Topŋe nâŋgâŋetgât den âlâen hâum sâwe. Lok âlâ me âlâ bâtyeŋaŋe me kâiyeŋaŋe otmâ hilipgunomai. Yawu otmâ hilipgum bâtyeŋahât me kâiyeŋahât tosa yakât otmâ umut biwiyeŋe hem kâlâwân kioŋmapgât ya hârem pilânomai. Topŋe yuwuhât yan. Lok âlâ me âlâŋe dâiyekmu yu me ya otŋetâ bâlemu hemgât pat otmaihât ya pilâm biwiyeŋe Anitâhâlen katnomai. Yawu otŋetâ manman kârikŋe yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Otmu yawuâk lok âlâ me âlâŋe senŋe nombot me nombot yaŋe orotmeme bâleŋe ekmâ biwiyeŋe yan ariwuap. Biwiyeŋe yan arimu yakât otmâ tâpikgum senyeŋahât tosa yakât otmâ umut biwiyeŋe hem kâlâpgât pat otmap sâm yakât âlâ gusuhutmâ pilânomai. Gusuhutmâ pilâm biwiyeŋe Anitâhâlen katmâ yâkât tem lâum yâhâŋetâ manman kârikŋe yiŋgiwuap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yâhâ nimnaom ya yeŋgât âlâku sâmune nâŋgâŋet. Anitâŋe aŋelolipŋe nombotŋe naom titipâ yu galemyongoŋet sâm âi yiŋgiop yaŋeâmâ yâkât senŋan âiloŋgo mansai. Yakât yeŋe naom titipâ yu yeŋgât nâŋgâŋetâ ki gewuap. ");
INSERT INTO spl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yakât âlâ torokatmâ sâwe. Lohimbi yeŋe hem nâpumân ge hiliwahomaihât Anitâŋe yeŋgât sâm hâŋgânnohomu gewan. Yakât nâŋe mem kuwikyekmune manman âiloŋgoân mannomai. ");
INSERT INTO spl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","13","Yakât den âlâen hâum yuwu sâmune nâŋgâŋet. Lok âlâhât lama 100 yawu kinbaŋgiai. Gârâmâ ya yeŋgât hohetyeŋambâ konok âlâŋe misiŋgurakbuap. Yawu otmu amboŋaŋe nombotŋe ya katyekmu kinŋetâ konok misiŋgurakbuap ya pâinmâ yâhâm gewuap. Yawu otmâ nombotŋe katyekmu kinnomai ya yeŋgât ki nâŋgâm ketet otbuap. Yâhâ misiŋgurakbuap ya mem tetem yanâmâ tepŋe welâmŋan giâk sâm yakât otbuap. ");
INSERT INTO spl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yakât dopŋeâk awoŋnaŋe nan baralipŋe âlâ me âlâŋe hiliwahomaihât haoŋmâ ârândâŋ tihityeŋe otmap. ");
INSERT INTO spl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Otmu den âlâ yuwu sâmune nâŋgâŋet. Bukuhe âlâŋe topŋe âlâlâ mâŋgâehekmu mem dâirâ yok pilâm yetŋiâk alahuromawot. Alahumutâ ârândâŋ otmu buku konok mandowawot. ");
INSERT INTO spl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yâhâ bukuhaŋe gâhât den ki nâŋgâwuap otmuâmâ emelâk Moseŋe den yuwu kulemguop ya watbuat. “Lok konokŋe ikŋiâk bukulipŋe âlâ me âlâhât topyeŋe teteâkgât sâm hâreyiŋgiwuapgât dop ki tap. Lok yâhâp me amon yaŋe denyeŋe sânomai ya lâuakmâ konok otbuap yamâ nâŋgâŋetâ bonŋe (otmap/otbuap).” Den ya watmâ buku nombotŋe konok me yâhâp meyelekdâ gam yâkŋe heŋgeŋguromawot. ");
INSERT INTO spl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yâhâ bukuhaŋe iliwetbuawâmâ Anitâhât komot yeŋgât senyeŋan heŋgeŋgunomai. Yâhâ yâk yeŋgât senyeŋan iliwetmâ denyeŋe ki nâŋgâwuawâmâ yuwu sâm ekunomai. “Gâmâ kunge kârikŋe otmâ iliwet tat yakât otmâ nen orop torokatdâ mannomgât dop bia.” Yawu sâm ekum watŋetâ ari manbuap. ");
INSERT INTO spl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yuwu sâmune nâŋgâŋet. Bukulipyeŋaŋe yu me ya âlepŋe otmai ya yeŋe ekŋetâ ârândâŋ otmap yawuâk Anitâŋe ekmu ârândâŋ otbuap. Yâhâ bukulipyeŋaŋe otŋetâ bâlemapgât yeŋe kuyiŋginomai ya yawuâk Anitâŋe mâtâp maŋguyiŋgiwuap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Otmu torokatmâ sâwe. Yeŋe menduhuakmâ lok âlâhât den sâm hârewaŋginomai yan biwiyeŋe konok otmu Anitâ âikuŋetâ topŋe mem tetekŋan tuhumu nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Otmu nâŋe yeŋgât hohetyeŋan kinmâ howeyekbom. Howeyekmune yakât topŋe nâŋgâm heŋgeŋgum den sâm hârewaŋginomai. Otmu Anitâŋe gurâ yawuâk hârewaŋgiwuap. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sâmu Petoroŋe yuwu sâm âikuop. “Kutdâ, bukune âlâŋe orotmeme kiŋgoŋ mâŋgâenekmu tosa pilâwaŋgimune amon otmu yan pesuk sâwuap? Nombolân yâhâp otmu yan pesuk sâwuap me? Me ya wangim torokatmâ yâhâwuap?” Yawu sâm topŋe nâŋgâwehât âikum nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sâmu sâop. “Yawu bia. Ihilâk, gâŋe tosaŋe pilâwaŋgim yâhâwuat. ");
INSERT INTO spl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yakât yuwu sâmune nâŋgâ. Anitâŋe tihityeŋe otmâ den sâm hâreyiŋgiwuap. Yakât topŋe teteâkgât lok kutdâ orotmemeyeŋan hâum sâwe. Yâkŋe ikŋe âi loklipŋe yeŋgât tosa tatyiŋgiop ya mem âwureŋet sâm ekyongop. Ekyongomu tatyiŋgiop ya amboŋan amboŋan yâkâlen ba sâm tetewi. ");
INSERT INTO spl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Otmu aŋgoân gaop yâkât tosa pato, yakât dowâmâ 13 milion kina yakât dop. ");
INSERT INTO spl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yâhâ lok yaŋe tewetsenŋe ki tatbaŋgiopgât otmâ ya kâpekbâpgât dop bia. Yawu gârâmâ lok kutdâŋe yuwu sâm ekuop. “Gâ, imbihe naomge âi tuhum tewetsenŋe mem dâinomai yamâ nâhâlâk sâp ârândâŋ katmâ yâhânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yawu sâmu lok yaŋe yuwu nâŋgâop. “Nenŋe âi yu girawu torokatmâ hâhiwin kakŋan tuhum manmâ yâhânom. Yawu gârâmâ kâpekbomgât dop âlâ ki tap, bia kârikŋe.” Yawu nâŋgâm lok kutdâ ya yuwu sâm ulitguop. “Yawu gârâmâ gâ nengât tepge nâŋgâningi. Hâmbâi mâtâp teteningimu âlepŋe kâpeknom. Yakât ki hâwât hâwâlâk kendâningiwuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yawu sâm ulitgumu ekmâ tepŋe nâŋgâm tosaŋe ya pilâwaŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yawu gârâmâ âi lok yaŋe bukuŋe âlâ mem teteop. Otmu bukuŋahât tosa yamâ 10 kina yawuya tatbaŋgiop. Mem tetem tosaŋe kâpehâkgât ekuop. ");
INSERT INTO spl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ekumu yuwu sâm ulitguop. “Gâ tepge nâŋgânihim tipiŋe mambotdâ yan kâpekbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yawu sâop ya ki nâŋgâm pâi emetŋan mem katmu talop. Yan tatmu yuwu sâm ekuop. “Gâ yuânâk tatdâ hep torehenlipgaŋe tewetsenŋe gihiŋetâ pâi emetŋe puluhum gewuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yawu otmu âi lok yakât bukulipŋaŋe nâŋgâm bâlewaŋgim patoyeŋe ekuwi. ");
INSERT INTO spl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ekuŋetâ den ya nâŋgâm olop amboŋe ya kunmu gamu yuwu sâm ekuop. “Gâ lok bâleŋe. Aŋgoân tosahe ya kâpekbâtgât dop. Yamâ nâŋe tosahe pilâhihiwan. ");
INSERT INTO spl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gâku yawuâk bukuhahât tosa ki pilâwaŋgiat yakât nâŋgâmune umatŋe oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Otmu biwiŋaŋe nâŋgâmu umatŋe otmu mem pâi emetŋan katmâ hâhiwin pato ya torokatmâ waŋetgât tembe lâulipŋe ekyongop. “Lok yu wawi oap yakât hâhiwin waŋetâ ârândâŋ otbuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yakât topŋe yuwu tap. Bukulipyeŋaŋe mem âlâlâ tuhuyekŋetâ tosa ki pilâyiŋginomai. Yamâ Himbim Awoŋnenŋaŋe yen gurâ yawuâk tosa ki pilâyiŋgiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuŋe den ya sâm pesuk pilâm menenekmu yapâ yahatmâ Galilaia hân ya pilâm yaŋak Yoran to hâtikgum Yuraia hânângen ariwin. ");
INSERT INTO spl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Arimunŋe lohimbi dondâŋe denŋe nâŋgâne sâm betnenŋan watnenekmâ ariwi. Yan watnenekmâ ariŋetâ yâkŋe lohimbi dondâ heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Otmu Parisaio lok nombotŋaŋe taka “Den girawuyaen hâum sâmunŋe yan matŋe sâm tâpikgumu den âiân katne,” nâŋgâm yuwu sâm Yesu âikuwi. “Mâtâp girawu tap? Lok âlâ me âlâŋe yeŋe eŋgatyeŋeâk otmâ imbilipyeŋe pilâyeknomaihât mâtâp tap me bia?” ");
INSERT INTO spl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sâŋetâ sâop. “Yen Anitâhât den nâŋgâmai me bia? Den yamâ yuwu tap. “Anitâŋe topŋe katmâ hân himbim kândikyotgom yan lohimbi yâhâp katyelehop. ");
INSERT INTO spl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Katyelekmâ yan den yuwu sâm ekyotgop. “Lok âlâ me âlâŋe âwâŋe mâmâŋe pilâyelekmâ imbiŋâit mandomawot.” Den yawu tap. ");
INSERT INTO spl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yakât otmâ ki hioŋakmâ ikŋiâk ikŋiâk otdomawot. Anitâŋe menduhuyelekmu konohâk olowot. Yakât otmâ lok âlâ me âlâŋe ki hioŋyeleknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sâmu sâwi. “Ya âlepŋe yat. Gârâmâ Moseŋe girem den âlâ yuwu kulemguop tap. “Lok âlâ me âlâŋe imbiŋe pilâwe sâm âlepŋe pilakdomawot yakât topŋe kulemgum waŋmu miakmu watmu ariwuap.” Yawu tap. Otmu Moseŋe ya otnomgât âlepŋe sâop. Gâŋe den yat yuŋeâmâ Mosehât den ya orop ki lâuaksawot. Yakât otmâ nâŋgâmunŋe ki ârândâŋ oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yawu sâŋetâ Yesuŋe Moseŋe den sâop yakât yuwu sâm ekyongop. Moseŋe girem den yawu kulemguop yamâ kuyiŋgiwehât nâŋgâm ki kulemguop. Yeŋgât tâmbâlipyeŋaŋe biwiyeŋe kârikŋe otmu yeŋahâlâk nâŋgâm manminiwi yakât kulemguop. Yâhâ kândikum yawu ki otbi. ");
INSERT INTO spl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yakât otmâmâ nâŋe yuwu sâmune nâŋgâŋet. Lok âlâhât imbiŋaŋe mâtâp ki tâpikgum manmu lokŋaŋe imbiâk pilâm ba imbi ondop membuap. Yamâ lok yaŋe tosa umatŋe membuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesuŋe yawu sâmu nenŋe yuwu sâm ekuwin. “Nengât orotmeme yuwu tap. Lohimbi imbiâk hioŋakmâ mansai. Yawu oraŋgimaihât nâŋgâm lok yawuyaŋe imbi barak mannomai.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Sâmunŋe sâop. “Lok kerekŋe imbi barak mannomaihât dop ki tap. Nombotŋaŋe mâmâlipyeŋe yeŋgât tepyeŋambâ pâlâmŋe mannomaihât yawu tetemai. Nombotŋaŋeâmâ imbi memai sâm mâtâp maŋguyiŋgimai. Yâhâ nombotŋaŋeâmâ Anitâhât nep yakâlâk nâŋgâm tiŋ tiŋâk mem mannom nâŋgâm imbi barak manmai. Yakât Anitâŋe nâŋgâmu ârândâŋ otmap. Otmu lok nombotŋaŋe den yu biwiyeŋaŋe ekmâ topŋe nâŋgâm yâhâŋetâ ârândâŋ otbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Otmu sâp yanâmâ lohimbi nombotŋaŋe nan baralipyeŋe meyekmâ Yesuhâlen ariwi. Ari Yesuŋe kunyeŋan mem Anitâ ulitgumu lukuleyehâkgât ekuwi. Yawu otŋetâ nenŋe yekmunŋe ki ârândâŋ otmu kuyiŋgiwin. ");
INSERT INTO spl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kuyiŋgimunŋe Yesuŋe nenekmu ki ârândâŋ otmu yuwu sâm eknongop. “Kâmbukŋe, ki kuyiŋgiŋet. Anitâŋe nimnaom titipâ yu yeŋgât tihityeŋe otmap. Yakât otmâ dâiyekmâ nâhâlen gaŋet. Yeŋe kuyiŋgiŋetâ ekmune ki ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yawu sâm Anitâ ulitgum kunyeŋan memu yaŋak kapi ya pilâm âlâengen ariwin. ");
INSERT INTO spl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sâp âlâen lok âlâŋe Yesuhâlen taka yuwu sâm âikuop. “Kutdâ, nâŋe âlâ girawu otmune ârândâŋ otmu yanâmâ Anitâŋe manman kârikŋahât pat kunihiwuap?” ");
INSERT INTO spl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sâmu sâop. “Gâ wongât yakât âinohoat? Yakât amboŋe yamâ Anitâ konok. Gâ yu me ya âlepŋeâk otbehât naŋgat otmuâmâ girem den hârohâk nâŋgâm lâuwuat. ");
INSERT INTO spl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Sâmu sâop. “Girem den girawuya?” Sâmu sâop. “Mosehât girem den yukât yan. “Gâ lok nombotŋe ki yongorâ munomai. Me buku âlâhât imbi ki ekmâ otbuat. Me kombo ki otbuat. Me hâkyeŋan ki sâwuat. Me den perâk ki sâm kâityongowuat. ");
INSERT INTO spl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gâ âwâhe mâmâhe yetgât lauyetŋe lâum amutyetŋan manbuat. Otmu nenŋahât naŋgaŋgimunŋe yahatmap yakât dopŋeâk buku nombotŋe yeŋgât nâŋgâmunŋe yahatbuap.” Yawu tap. nâŋgâmat yawuâk buku nombotŋe tânyongowehât nâŋgâwuat. Yawu.” ");
INSERT INTO spl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sâmu sâop. “Girem den yu sâm arat yamâ otmanâk hârok. Orotmeme girawuya ki otman ya otbom yanâmâ Anitâŋe manman kârikŋahât pat kunihiwuap?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sâmu sâop. “Senŋe âlâlâ pato tatgihiap yamâ mem buku nombotŋe umburuk mansai ya yiŋgiwuat. Yawu otdâmâ Anitâŋe manman kârikŋahât pat kuhihiwuap. Yawu otmâ nâhâlen torokatdâ orowâk arinom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yawu sâmu iri sikum me senŋe âlâlâ pato tatbaŋgiop yakât nâŋgâmu biwiŋe umatŋe otmu, Yesuŋe sâop ya ekmu hâi hâiŋe otmu pilâm âlâengen ba ariop. ");
INSERT INTO spl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ba arimu Yesuŋe yuwu sâm eknongop. “Yuwu sâmune nâŋgâŋet. Lok iri sikum pato tatyiŋgiap yaŋeâmâ Anitâhâlen torokatne sâm otŋetâ hâi hâiŋe otmap. ");
INSERT INTO spl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yakât otmâ den âlâen hâum sâmune nâŋgâŋet. Pusiŋe seloŋ watmu pin pinŋan arimu yan watmâ bawe sâm hâum pâpgumap. Yakât dopŋeâk lok iri sikumyeŋe pato tatyiŋgiapŋe Anitâŋe tihityeŋe olâkgât mâtâp ya watmâ arine sâm otŋetâ hâi hâiŋe otbuap. Lok nombotŋe iri sikum pato tatyiŋgiapŋe yeŋahâlâk nâŋgâmai. Lok yawuyaŋe himbimân Anitâhât gotŋan ki yâhânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yawu sâmu nâŋgâmunŋe sâtŋe otmu yuwu sâwin. “Âo, yu yat yuâmâ lok girawu yaŋeâmâ himbimgât pat otbuap?” ");
INSERT INTO spl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yawu sâmunŋe Yesuŋe sennenŋe topŋan dâŋâk nenekmâ yuwu sâop. “Anitâhât manman kapiân arine sâm lokgât nâŋgân nâŋgânân arinomaihât dop ki tap. Yamâ Anitâ konokŋe nâŋgâningimap. Yakât otmâ yeŋe yu me ya otne sâm Anitâhât nâŋgân nâŋgânân watmâ otnomaihât dop tap. Yâkŋe konok manman kârikŋe ya yiŋgimu mem manmâ yâhânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yawu sâmu Petoroŋe yuwu sâm âikuop. “Bâe, nenâmâ senŋe âlâlâ kerek betbaŋgim gâhâlen torokatmâ hâhiwin kakŋan manmain. Yakât nenŋe girawu menomgât naŋgat?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sâmu sâop. “Hâmbâi sâp pato tetewuawân Anitâŋe yâhâpŋe nâ hâŋgânnohomu âwurem gewom. Yanâmâ âi sâm nihiop yakât bulâŋe tetenihiwuap. Yawu gârâmâ yeŋe nâhâlen torokatmâ manmai yamâ nâ orowâk tatnomai. Tatmâmâ Isirae lok komot kâiân yâhâp mansai yeŋgât topyeŋe ya sâm tetenom. Otmu yeŋeâmâ kunlipyeŋe otmâ galemyongom mannomai. ");
INSERT INTO spl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yakât otmâ yuwu sâmune nâŋgâŋet. Lohimbi âlâ me âlâŋe âwâ mâmâlipyeŋe, me imi garilipyeŋe, me senŋe âlâlâ siminŋe tatyiŋgimap ya aksihâk pilâyekmâ lohimbi kerekŋe nâhât den nâŋgâŋetgât nâhât komolân torokatmâ tânyongonomai yâhâmâ nâ orowâk konohân tatnom. Tatmunŋe yakât matŋe âiloŋgo yiŋgimune menomai. ");
INSERT INTO spl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yâhâ lohimbi nombotŋaŋe yeŋahât nâŋgâŋetâ yahatmap ya Anitâ orop ki tatnomai. Yâhâ nombotnaŋe yeŋahât nâŋgâŋetâ gemu huruŋ huruŋ manmai ya Anitâŋe meyekmu ikŋan torokatnomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesuŋe den âlâ yuwu sâm eknongop. “Anitâhât hoŋ bawaŋgiŋetâ yakât hâmeŋe yiŋgiwuap yakât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Lok kutdâ âlâhât hân pato tatbaŋgiopŋe omoŋânâk nep tuhuŋet sâm kapiân yâhâ nep lok meyehop. ");
INSERT INTO spl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Lok meyekmâ, “Âi tuhunomai yakât hâmeŋe kina konok konok yiŋgiwom,” sâmu nâŋgâŋetâ âlepŋe otmu yahatmâ ari nep tuhuwi. ");
INSERT INTO spl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yawu otmâ omoŋânâk 9 kilok otmu yan lok nombotŋe âlâ meyekbe sâm kapiân yâhâop. Yâhâ hilâm im tatbi ya yehop. ");
INSERT INTO spl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yekmâ yuwu sâm ekyongop. “Yen ari nâhât nep kâmetŋetâmâ yakât hâmeŋe kina konok konok yiŋgiwom.” Yawu sâm ekyongomu ari nep tuhuwi. ");
INSERT INTO spl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nep tuhum tatŋetâ 12 kilok olop yan nep lok nombotŋe âlâ meyekmu nep tuhuwi. Yâhâ 3 kilok otmu nep nombotŋe âlâ ya gurâ meyekmu nep tuhuwi. ");
INSERT INTO spl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nep tuhum tatŋetâ emelâk emetsâpŋe olop. Emetsâpŋe otmu nep lok nombotŋe âlâ meyekbe sâm kapiân yâhâop. Yâhâ yekmâ yuwu sâm âiyongop. “Wongât otmâ konam im tai?” ");
INSERT INTO spl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sâmu sâwi. “Lok âlâŋe âi tuhuŋet sâm ki sâm ningiap. Yakât otmâ hilâm im tain.” Sâŋetâ sâop. “Yen yahatmâ ari nâhât âi tuhuŋet,” sâop. Yawu sâmu ari nep tuhuwaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nep tipiŋe tuhuŋetâ emetsenŋe potok sâmu nep amboŋaŋe yahatmâ nep loklipŋe yeŋgât galem ya yuwu sâm ekuop. “Lok âi miai ya ekyongorâ ga hâmeŋe meŋet.” Yawu sâm ekuop. Aiop, galem yaŋe nep loklipŋe ya ekyongomu gaŋetâ bâiŋe meyehop yâk yeŋgâlembâ topŋe katmâ tewetsenŋe yiŋgiop. Yiŋgim arim arim aŋgoân meyehop ya bâiŋe yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yawu otmâ lok emetsâpŋe taka âi mewi ya kina konok konok yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yawu otmu aŋgoân takawi yaŋe yekŋetâ bâlemu yuwu nâŋgâwi. “Nenŋe sâm omoŋânâk taka âi topŋe katsain. Yakât otmâ tewetsenŋe pato membâmgât dop.” Yawu nâŋgâwi. Yawu nâŋgâwi yamâ aŋgoân takawi me betŋan takawi ya hârohâk dop konohâk yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dop konohâk yiŋgimu yakât tepyeŋan tâlimu nep amboŋahât dondâ nâŋgâm bâlewaŋgim yuwu sâm ekuwi. ");
INSERT INTO spl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Lok nombotŋe emetsâpŋan meyekdâ takai. Yâhâ nenâmâ omoŋânâk menenekdâ nep tuhumunŋe sikopŋe irik irik sâm dondâ nongoap. Yakât otmâ bâleain. Yawuhât girawu otmâ gâŋe mem ge katnenekmâ emetsâpŋe takai ya orop dop konohâk ningiat? Yakât nâŋgâmunŋe dondâ bâleap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yawu sâŋetâ nep amboŋaŋe lok hohetyeŋan kinmâ sâop ya yuwu sâm ekuop. “Buku, nâŋe ki otmâ tâpikguan. Meyeksan yan kina konok konok yiŋgiwom sâmune nâŋgâŋetâ ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yakât otmâ yiŋgian yu miakmâ ariŋet. Nâŋe yen yiŋgian otmu bâiŋe takai ya yiŋgian yuâmâ nine eŋgatneâk watmâ yiŋgian. ");
INSERT INTO spl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nâŋe tewetsenŋe yu kâsikum yiŋgian yamâ nâhât wahap. Yeŋe ki galemnohoai. Yakât otmâ yeŋe nâŋgâm bâlenihiai yakât nâŋgâmune ki ârândâŋ oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yakât otmâ yuwu sâmune nâŋgâŋet. Sâp yiwereŋe nâhâlen biwiyeŋaŋe kepeim hoŋ banihiai. Otmu sâp âlâen komot topŋe topŋe yaŋe nâhâlen biwiyeŋaŋe kepeim hoŋ banihinomai. Yen me yâk hârohâk hâmeŋe dop konohâk menomai. Gewe yâhâwe bia. Yen kerekŋe manman kârikŋan arinomai. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuŋe Yerusalem kapiân yâhâwe sâm nen hoŋ bawalipŋe menenekmu orowâk yâhâwin. Mâtâwân yâhâm tatmâ Yesuŋe yuwu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yuwu sâmune nâŋgâŋet. Yiwereŋe Yerusalem kapiân yâhânom. Yan yâhâmunŋe lok âlâŋe nâŋgâm bâlenihim hotom umai otmu Mosehât girem den kâsikum ningimai ya yeŋgât bâtyeŋan katnekbuap. Bâtyeŋan katnekmu den âiân katnekmâ mumbomgât den sâm hârenihinomai. ");
INSERT INTO spl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Den sâm hârenihim Roma lok yeŋgâlen katnekŋetâ yâkŋe yuwu otnihinomai. Sennan gem, tâpnohom, mem âlâlâ tuhunekŋetâ hâhiwin pato nâŋgâwom. Otmu benŋe howanân nohoŋetâ mumbom. Mumune hannohoŋetâ hilâm kalimbu pesuk sâmu yakât kakŋan mumuŋambâ yahatbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sâp yanâmâ Yewerihât imbiŋaŋe nanyâhâtyetŋe dâiyelekmâ ba Yesu yuwu sâm ekuop. “Kutdâ, nanyâhâtne yu nâŋgâyitgihât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sâmu sâop. “Gâ biwihaŋe girawu nâŋgâm dâiyelekmâ takat?” Sâmu sâop. “Sâp patoen gâŋe lohimbi kerek galemnenŋe manbuat yanâmâ nâhât nanyâhâtne yu orowâk tatmâ tângohomutâ galem mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yawu sâmu Yakowo yet Yoane yuwu sâm âiyotgop. “Yakât topŋe ki nâŋgâm denâk sâm yawot. Umatŋe âlâlâ tetenihimu hâhiwin nâŋgâwom yawuâk nâŋgâromawot me?” Sâmu sâowot. “Ya âlepŋe yat. Umatŋe nâŋgâwualân net gurâ yawuâk nâŋgâromgât naŋgait.” Yawu sâowot. ");
INSERT INTO spl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sâmutâ sâop. “Bonŋanâk yawot. Umatŋe âlâlâ tetenihimu hâhiwin nâŋgâwom ya yet gurâ yawuâk nâŋgâromawot. Yakât sâwe. Lok âlâ me âlâŋe tânnohoŋetâ kunlipyeŋe mannom yakât Anitâ ikŋahâk nâŋgâmu tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yawu sâm ekyotgomu yakât den pat nâŋgâmunŋe bâlemu Yakowo yet Yoane yetgât nâŋgâm bâleyitgiwin. ");
INSERT INTO spl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nâŋgâm bâleyitgimunŋe Yesuŋe nâŋgâmu bâlemu den âlâen hâum yuwu sâm eknongop. “Lok papatolipyeŋaŋe nâŋgâmai dopŋan lohimbi galemyongoŋetâ yâk yeŋgât amutyeŋan manmâ hâhiwin kakŋan manmai. ");
INSERT INTO spl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","28","Yeŋeâmâ papatolipyeŋaŋe otyiŋgimai yawu ki otnomai. Nâhât den lâum mansaiŋe nâhât hoŋ bam gam nâ tânnohoŋetgât ki gewan. Nâŋeâmâ lohimbi hoŋ bayiŋgim sârereyekmâ kinmune nohoŋetâ mumbom. Mum yan tosayeŋe pilâyiŋgiwom. Yawu otbomgât awoŋnaŋe âi sâm nihim hâŋgânnohomu ge mansan. Yawu gârâmâ yeŋgâlen gâtŋe âlâ me âlâŋe bukulipyeŋaŋe nâŋgâyiŋgiŋetâ yahalâkgât meŋetâ huruŋ huruŋ otmu yâk yeŋgât amutyeŋan mannomai. Otmu yeŋgâlen gâtŋe âlâ me âlâŋe Anitâŋe nenekmu ârândâŋ olâkgât nâŋgâm yawuâk bukulipyeŋe yeŋgât hoŋ bayiŋginomai. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesuŋe menenekmu Yeriko kapi pilâm yâhâwin. Yâhâmunŋe lohimbi dondâŋe betnenŋan watnenekmâ ariwi. ");
INSERT INTO spl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Arimunŋe lok yâhâp senyetŋe bok sâsâŋe mâtâp ginŋan talowot. Tatmutâ lohimbi yaŋe “Yesu takap” sâŋetâ nâŋgâm yahatmâ halahum yuwu sâowot. “Lok pato, Dawitihât sen, gâ netgât wehe nâŋgânitgi.” Yawu sâowot. ");
INSERT INTO spl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yawu sâmutâ lohimbi gotyetŋan kinbiŋe kuyitgim yuwu sâwi. “Bâe, girawu otmâ den kârikŋe sâm halahum tawot? Den nâŋgânâk tatset.” Yawu sâwi. Yawu sâŋetâ iliwetmâ witgumâk sâowot. ");
INSERT INTO spl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sâmutâ yuwu sâm âiyotgop. “Girawu otyitgiwehât naŋgawot?” ");
INSERT INTO spl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Sâmu sâowot. “Lok pato, sârâ sennetŋe hâreakmu ekdehât naŋgait.” Yawu sâowot. ");
INSERT INTO spl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yawu sâmutâ senyetŋan mem walipgumu hâreakmu ekmâ, Yesu betŋan sâmutâ orowâk ariwin. ");
INSERT INTO spl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yapâ ari Yerusalem kapi pato yakât gotŋan kapi âlâ, kutŋe Betepahe sâm, ya Oliwa pumŋan tap yan yâhâwin. ");
INSERT INTO spl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Yan yâhâ Yesuŋe hoŋ bawayâhâtŋe yâhâp yuwu sâm hâŋgânyotgop. “Kapi tipiŋe ewapâ tap yan doŋgi nanŋe otmu mâmâŋe hikum katyelekŋetâ kinsawot ya holaŋmâ meyelekmâ geromawot. ");
INSERT INTO spl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Holaŋyelekmutâ lok âlâ me âlâŋe yelekmâ âiyotgoŋetâmâ yuwu sâm ekyongoromawot. “Yiwereŋe âi teteap. Yakât otmâ kutdânetŋaŋe yu meyelekdehât hâŋgânnotgomu takait. Meyelekmâ arimutŋeâmâ âi ya tuhum pesuk pilâmuâmâ mem âwurem takarom.” Yawu sâm ekyongoromawot.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","7","Yawu sâm hâŋgânyotgomu yâhâowot. Yâhâ doŋgi ya holaŋmâ meyelekmâ takamutâ hâk katipŋe kâlep katbin ya holaŋmâ lotohom kakŋan katbin. Katmunŋe kakŋan yâhâ talop. Yâhâ tatmu Yerusalem kapiân yâhâwin. Otmu Yesu kapiân yâhâop yakât emet inânŋan poropete âlâŋe den kulemguop ya yuwu tap. “Yen Yerusalem kapi ambolipŋe nâŋgâŋet. Papatolipyeŋaŋe orotmeme yuwu otmâ mansai. Yaŋeâmâ bam gane sâm yan hâk meme otmâ beâsi kakŋanâk bam gamai. Otmâmâ yeŋgât lok kutdâ yuŋeâmâ yeŋe otmai yawu ki oap. Yâhâmâ ikŋahât nâŋgâmu gemap. Yakât otmâ doŋgi kakŋanâk lohotŋan ariop.” Den yawu tap yakât bonŋe Yesuŋe doŋgi kakŋan tatmâ Yerusalem kapiân yâhâop yan teteop. ");
INSERT INTO spl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kapiân yâhâmu yan lohimbi kiŋgitŋe orowâk hâruhuakbiŋe Yesuhât nâŋgâŋetâ yahatmu yeŋe sâŋgum kâkâlep ya holaŋmâ mâtâp tete liŋgatmâ ariwi. Yâhâ nombotŋaŋeâmâ âliwahap esenŋe hârem yaŋe liŋgatmâ ariwi. Liŋgatŋetâ doŋgi yaŋe yakât kakŋambâ ariop. ");
INSERT INTO spl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yâhâ nombotŋe hâruhuakbi yaŋe yuwu sâm mepaewi. “Gâmâ tâmbânenŋe Dawitihât sen. Gike ombeheâk ki takat. Anitâŋe âi sâm gihiop ya lâum kinmâ nengâlen mat takat. Yakât otmâ heroŋe otgihim mepaeheksain.” Yawu sâm mepaewi. ");
INSERT INTO spl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesuŋe Yerusalem kapiân yâhâmu kapi ya ambolipŋaŋe ekmâ pârâk pilâm yuwu sâwi. “Main. Lok yuâmâ wonân gâtŋe? Me âlâhât nanŋe?” ");
INSERT INTO spl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yawu sâŋetâ lohimbi betŋan sâwiŋe yuwu sâm ekyongowi. “Yuâmâ Anitâhât poropete âlâ, kutŋe Yesu, kapi tipiŋe, kutŋe Nasaret sâm, Galilaia hânân tap yapâ gâtŋe.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","13","Yawu sâŋetâ Yerusalem kapi patoen yâhâwin. Yâhâmunŋe Yesuŋe doŋgi kakŋambâ kioŋmu yaŋak yapâ opon kâmbukŋan yâhâwin. Yâhâ opon kâmbukŋe kâlehen lohimbiŋe senŋe âlâlâ aŋgi guŋgi otmâ hâmeŋe hâukum kinbi ya yekbin. Yekmâ Yesuŋe nâŋgâm bâleyiŋgim yuwu sâm ekyongop. “Yu oai yukât emet inânŋan Anitâŋe poropete âlâ ekumu kulemguop ya yuwu tap. “Lohimbi hânŋan kulemŋan manmâ araiŋe nâhât opon yukât kâlehen yâhâ mepaeneknomai.” Den sâop yakât yuwu sâmune nâŋgâŋet. Yeŋe yukât kâlehen tatmâ lohimbi kâityongom hâmeŋe mem yahatmâ aŋgi guŋgi otmâ gai. Yawu otmâ gai yu ekmune aŋgim bero emetŋe yawuya oap. Opon kâmbukŋe yu kâlehen ki orotŋe otŋetâ ekmune bâleap.” Yawu sâm kakŋan tat tat, tewo, kembâ mem emetŋe tuhum ya kâlehen katŋetâ talop, senŋe âlâlâyeŋe mem purik pilâyiŋgim watyekmu yahatmâ tiok taok otmâ arim kinbi. ");
INSERT INTO spl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Gem tiok taok otmâ arim kinŋetâ lok nombotŋe senyeŋe bok sâsâŋe otmu lok pareŋe ya yâkâlen ariŋetâ heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Heŋgemyongomu naom titipâŋe Yesu ekŋetâ sâtŋe otmu yuwu sâm mepaewi. “Dawitihât sen, kâwiâk watyekdâ kioŋsai yakât heroŋe oain.” Yawu sâŋetâ yan hotom uminiwi ya yeŋgât lok kunŋe otmu Mosehât girem den kâsikum ningiminiwi yaŋe nâŋgâm bâlewaŋgim yuwu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Naom titipâ kutyeŋe biaŋe mepaeheksai ya ekmunŋe ki ârândâŋ oap. Yakât kuyiŋgirâ hutuk sâŋet,” yawu sâm Yesu ekuwi. Sâŋetâ sâop. “Mepaenekŋetâ nâŋgâmune ârândâŋ oap. Yu oai yukât emet inânŋan Anitâŋe poropete âlâ ekumu kulemguop ya yuwu tap. “Anitâŋe nimnaom titipâ yeŋgât biwiyeŋan kioŋmu heroŋe otbaŋgiai.” Den yawu kulemguwi tap yakât bulâŋe yu tetemu eksai.” ");
INSERT INTO spl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yawu sâm ekyongom yapâ pilâyekmâ Betani kapiân ari omoŋ sâmu iwin. ");
INSERT INTO spl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yan imunŋe emet haŋ sâmu yahatmâ Yerusalem kapiân âwurem yâhâwin. Mâtâp arim tatmunŋe Yesu po waŋgiop. ");
INSERT INTO spl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Po waŋgimu senŋe pilâm lakop âlâ mâtâp ginŋan kinop ya ehop. Ya ekmâ kehetŋe mem nembom sâm gotŋan ari ekmâ kehetŋe âlâ ki kinop. Esenŋaŋak âi omoŋ omoŋ otmâ kinmu ekmâ yuwu sâop. “Âo, yu kehetŋe ki kinsap. Esenŋeâk tap. Yakât otmâ lakop yukât kehetŋe âlâ ki menomai.” Yawu sâop. Sâmu yaŋak esenŋe gimbaŋguop. ");
INSERT INTO spl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yawu otmu nenŋe ekmunŋe sâtŋe otmu yuwu sâm âikuwin. “Bâe, yuâmâ topŋe girawuhât esenŋe in yawu gimbaŋguap.” ");
INSERT INTO spl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sâmunŋe sâop. “Sâmune nâŋgâŋet. Biwiyeŋe Anitâhâlen katmâ manmâ yâhânomai yamâ lakop yu sâm waŋsan yawuâk otnomaihât dop tap. Yakât den âlâen hâum sâmune nâŋgâŋet. Yeŋe yuwu mon otnomai. Pumŋe âlâ ekmâ “Huhuakmâ orotok sâm giâk” yawu sâm biwi yâhâp ki otmâek ulitguŋetâ âlepŋe huhuakmâ orotok sâm gewuap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yeŋe yu me ya otne sâmâmâ aŋgoân biwi nâŋgân nâŋgânyeŋaŋe Anitâhâlen kepeim ulitguŋetâ nâŋgâyiŋgimu yanâmâ yakât bulâŋe âlepŋe tetemu eknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yawu sâm eknongomu Yerusalem kapiân yâhâwin. Yâhâ opon kâmbukŋan tatmunŋe lohimbi nombotŋe yan tatbi ya den pat âlepŋe ya ekyongop. Hotom uminiwi otmu Yura nengât papatolipnenŋaŋe yuwu sâm âikuwi. “Gâŋe oran âlâhât sâtgât Anitâhât opon kâmbukŋan yâhâ lohimbi watyehon?” Yawu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sâŋetâ sâop. “Âinohoai gârâmâ nâku yawuâk âiyongomune yeŋe den matŋe kâpeknihiŋetâ yanâmâ nâŋe âlâhât sâtgât âi yu mem gaman yakât topŋe ekyongowom. ");
INSERT INTO spl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yakât yuwu sâmune nâŋgâŋet. Yoaneŋe toen mem katyehop yamâ âlâhât sâtgât otmâ âi ya miop? Anitâhât me ondop yeŋgât sâtgât âi ya tuhuop yakât sâŋetâ nâŋgâwe.” Yawu sâm âiyongop. Yawu sâmu matŋe kâpekbaŋgine sâm pâpgum alahu gulahu otmâ yuwu sâwi. “Nenŋe yuwu mon sânom. “Yoane yamâ Anitâŋe âi sâm waŋmu tuhuop.” Yawu sânom yamâ matŋe yuwu mon sâwuap. “O, yenâmâ girawu otmâ Yoanehâlen biwiyeŋe ki katbi?” Yawu sâmu den matŋe girawu sâm kâpekbaŋginom? Aŋulaknom yakâ. ");
INSERT INTO spl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yâhâ âlâ yuwu mon sânom. “Yâhâmâ lok yeŋgât sâtgât otmâ nep ya tuhuop.” Yawu sânom yamâ lohimbi dondâŋe yuwu sânomai. “O Yoane yamâ poropete pato, wongât den yawu yai?” Yawu sâm yan nengât nâŋgâŋetâ bâlewuap. Nâŋgâŋetâ bâlemu nongomaihât ki ekunom?” Yakât otmâ hâum pâpgum pilâwi. ");
INSERT INTO spl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yakât otmâ yuwu sâm ekuwi. “Yoaneŋe âlâhât sâtgât âi ya meminiop ya nen ki naŋgain.” Sâŋetâ sâop. “Nâku yawuâk. Âlâhât sâtgât âi yu tuhum gaman yakât ki ekyongowom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Lok âlâhât nanyâhâtŋe yâhâp. Otmu âwâyetŋaŋe ataŋe yuwu sâm ekuop. “Nan, gâ âinenŋehen ari nep kâmet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Sâmu sâop, “O, awoŋ, nâmâ hâkâŋ oan.” Yawu sâop. Yâhâ tipiŋe tatmâ yaŋak ihilâk yahatmâ ari âi ya miop. ");
INSERT INTO spl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yawu otmu âwâyetŋaŋe imiŋahâlen ari yawuâk sâm ekuop. Yawu sâmu imiŋaŋe yuwu sâop. “Awoŋ, âlepŋe ariwom,” sâop. Yamâ benŋe pilâm ki ariop. ");
INSERT INTO spl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Yawu olowot gârâmâ nanyâhâtŋe âlâŋe âwâyetŋahât den ya tem lâuowot?” Yawu sâm âiyongomu yuwu sâwi. “O, yamâ ataŋaŋe âwâyetŋahât tem lâuop,” yuwu sâwi. Sâŋetâ sâop. “Yawu gârâmâ yuwu sâmune nâŋgâŋet. Yoaneŋe manman âlepŋe yakât mâtâp ekyongom gaop. Yamâ yeŋe denŋe nâŋgâŋetâ nahat otmu bet pilâwi. Otmu yeŋe lok nombotŋe yekŋetâ bâlemu sâm ge katyeksai. Yakât otmâ yuwu sâmune nâŋgâŋet. Lok âlâ me âlâŋe takesihât tewetsenŋe meminiwi yapâ kombo mem manminiwi, me imbi nombotŋe lok ihilâk orop manminiwi yaŋe orotmemeyeŋe bâleŋe ya sâm tetem bet pilâŋetâ yan Yoaneŋe toen mem katyehop. Yeŋeâmâ biwi yâhâp otmâ manmai. Biwiyeŋe pâlâmŋe otmâ yâkât den nâŋgâŋetâ ki bulâŋe otmap. Yakât otmâ tewetsenŋe kombo meminiwi, otmu imbi lok ihilâk orop manminiwi yawuyaŋe heweweŋ otmâ kulet sâyiŋgim Anitâhât komolân torokatmâ mansai. Yeŋeâmâ Yoanehât den nâŋgâŋetâ nahat otmu biwiyeŋe alitmâ Anitâhât komot bulâŋe yan ki torokatsai. ");
INSERT INTO spl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Otmu yeŋgât topyeŋe teteâkgât den âlâen hâum sâmune nâŋgâŋet. Lok pato âlâŋe wain kâmetŋet sâm nep lok meyehop. Meyekmu ari dâmân sâhâm hawamgum wain kâmetbi. Otmu wain toŋe ya mem mendâreŋetâ gewuapgât waŋga hâwiwi. Otmu emetyeŋe tuhuwi. Ya tuhum tiŋ pilâŋetâ galem katyekmâ âlâengen ari sâp kâlep manop. ");
INSERT INTO spl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sâp kâlep manmu wain kehetŋe puru pato kinop ya amboŋaŋe hâruhunihiŋet sâm hoŋ bawalipŋe yakembâek hâŋgânyongomu takawi. ");
INSERT INTO spl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hâŋgânyongomu takaŋetâ nep galemŋe katyehop yaŋe nombotŋe yongom watyekbi, yâhâ nombotŋeâmâ kâtŋe yongoŋetâ muwi. ");
INSERT INTO spl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Benŋe sâp âlâen hâŋgânyongomu takaŋetâ nombotŋe yongoŋetâ muwi. Yâhâ nombotŋeâmâ watyekŋetâ purik sâm amboŋahâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ariŋetâ amboŋaŋe den pat ya nâŋgâm yuwu nâŋgâop. “Bâe, yu oai. Gârâmâ nine nanne ombe bisine hâŋgângumune arimu ekmâ yanâmâ ewe katnomai.” Yawu nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Biwiŋaŋe yawu nâŋgâm ikŋe nanŋe hâŋgângumu takamu ekmâ yuwu sâwi. “Bâe, yuâmâ patonenŋe ikŋe nanŋaŋe takap. Âwâŋe mumu yan kalam yuâmâ yâkŋe ambokumapgât kumunŋe muâk. Kumunŋe mumu yan kalam yuâmâ nengât otbuap.” ");
INSERT INTO spl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yawu sâm kum kekae topŋehen pilâŋetâ iop. Yawu. Yakât âiyongomune matŋe sâŋetâ nâŋgâwe. ");
INSERT INTO spl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yawu otŋetâ âi amboŋe ya girawu otbuap?” Yawu sâm âiyongop. ");
INSERT INTO spl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Âiyongomu sâwi. “Yawu otŋetâmâ âi amboŋe yaŋe taka yongomu muŋetâ nep lok ondop meyekmâ kaweyeŋan katyekbuap. Katyekmu yan tem lâuwaŋgim hoŋ bawaŋginomai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sâŋetâ sâop. “Anitâŋe hâŋgânnohomu gewan. Yakât poropete âlâŋe yuwu kulemguop ya yeŋe ki mon sâlikum nâŋgâmai. “Nep lokŋe nak âlâ ekmâ bâleŋe sâm mem ketetbi. Bâleŋe sâm mem ketetbi ya Anitâŋe lâum kânâŋgâmu kuhupin kârikŋe otmâ kinsap. Yâhâ emet tuhuwiŋe ekmâ yuwu nâŋgânomai. “Bâe, yuâmâ patoŋe nâŋgâmu teteap. Ekmunŋe sâtŋe oap.” Yawu nâŋgânomai.” Yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Den sâop yakât bulâŋe yiwereŋe nâhâlen tetemu eksai. Yakât otmâ yuwu sâmune nâŋgâŋet. Yeŋe nâhât nâŋgâŋetâ gemu hâkâŋ otmâ betnihim mansai. Yakât otmâ yen pilâyekmâ pâku lohimbi meyekmune nâhâlen biwi nâŋgân nâŋgânyeŋaŋe kepeim manŋetâ kunyeŋe pato otmâ yâhâwom. Otmu den âlâen hâum sâwe. ");
INSERT INTO spl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lok âlâ me âlâŋe kuhupin yu ekmâ betbaŋginomai yamâ hâhiwin nâŋgânomai. Yawu gârâmâ kuhupin yuŋe putuk sâm kioŋmâ yongowuap yamâ dâk dâk hutuk yongomu munomai. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yawu sâmu yuwu sâm alahuwi. “Bâe, nenŋe haoŋmâ ârândâŋ Yesu betbaŋgimain. Yakât otmâ Anitâŋe nen pilânenekbuapgât den yu yap.” Yawu sâm alahum nâŋgâŋetâ bâleop. ");
INSERT INTO spl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nâŋgâŋetâ bâlemu Yesu mem pâi emetŋan katne sâm otbi yamâ yuwu nâŋgâwi. “Lohimbi, seseŋgâlâk Yesuhâlen torokatmâ mansaiŋe yuwu naŋgai. “Yesu yu poropete âlâ mansap,” Yawu nâŋgâm mepaemai.” Yakât otmâ pâi emetŋan katne sâm otbi ya gorâyiŋgimu pilâwi. ");
INSERT INTO spl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuŋe den âlâen hâum hotom uminiwi otmu Yura nengât kunlipnenŋe ya yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anitâŋe tihitnenŋe otmâ yâhâwuap. Yakât topŋe yuwu tap. Lok kutdâ mansai yeŋgâlen hâum sâmune nâŋgâŋet. Lok kutdâ âlâhât nanŋaŋe imbi membe sâm soŋgo bau otmu sot kâle topŋe topŋe um hâwurumu kinop. ");
INSERT INTO spl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Otmu nanŋaŋe imbi membe sâmu yan âwâŋaŋe hoŋ bawalipŋe nombotŋe yuwu sâm hâŋgânyongomu ariwi. “Yen yâhâm gem bukulipnenŋe meyekŋetâ takaŋet.” Yawu sâop. Yawu sâm hâŋgânyongomu ari ekyongoŋetâ ki takawi. ");
INSERT INTO spl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yawu otŋetâ âlâkuâk hoŋ bawalipŋe nombotŋe yuwu sâm hâŋgânyongomu ariwi. “Aŋgoân bukulipyeŋe hâŋgânyongomune ari ekyongoŋetâ ki takai ya yeŋe âlâkuâk ari yuwu sâm ekyongoŋet. “Yen nâŋgâŋet. Soŋgo bau otmu sot kâle yamâ emelâk mem dinŋan tuhumunŋe tap. Yakât takaŋetâ nanŋaŋe imbi membuap yakât heroŋe otmâ nenom.” Yawu sâm ekyongoŋet,” sâm hâŋgânyongomu ariwi. ");
INSERT INTO spl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Hâŋgânyongomu hoŋ bawalipŋaŋe yâhâm gem âlâkuâk ekyongowi. Den ya ekyongoŋetâ nâŋgâm nâŋgâm âlâku nâŋgâop dopŋan dopŋan ariwi. Nombotŋe kalamângen nep tuhuakne sâm ariwi. Yâhâ nombotŋaŋeâmâ bisinisi tuhuakne sâm ariwi. Nombotŋe ihilâk mahilâk arim kinbi. ");
INSERT INTO spl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yâhâ nombotŋaŋeâmâ lok kutdâŋe hoŋ bawalipŋe hâŋgânyongomu den mem ariwi ya yongoŋetâ muwi. ");
INSERT INTO spl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yawu otŋetâ lok kutdâ yaŋe den pat nâŋgâm kuk otmâ tembe lâulipŋe hâŋgânyongomu ariwi. Ari kapiyeŋanâk yongom itit kiom bâleŋe tuhuyiŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Otmu lok kutdâ yaŋe hoŋ bawalipŋe yuwu sâm ekyongop. “Bukulipnenŋaŋe hâkâŋ otmâ ki takai. Yakât otmâ sot kâle emelâk um katŋetâ tap ya bâlemapgât yuwu otnom. ");
INSERT INTO spl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hâŋgânyongomune mâtâp kunŋan ari kinmâ lohimbi yuken yaken arine sâm oai ya ekyongoŋetâ taka sot yu neŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yawu sâm ekyongom hâŋgânyongomu hoŋ bawalipŋaŋe den sâop yawuâk mâtâp kunŋan yâhâm gem lohimbi âlepŋe bâleŋe ya ekyongowi. Ekyongoŋetâ taka lok imbi miop ya âwâŋahât emelan yâhâ pik ŋâtâk ŋâtâk sâwi. ");
INSERT INTO spl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Yâhâ lok kutdâ yaŋe lohimbi takawi ya yekbe sâm emet kâlehen yâhâop. Yâhâ tatbi yapâ gâtŋe lok âlâŋe sâŋgum tok sâsâŋe latmâ taka talop ya ekmâ nâŋgâm bâlewaŋgim yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“Bâe, gâmâ girawuhât nannaŋe imbi membe sâm otmu sâŋgum tok sâsâŋe latmâ taka tat? Ya ki ârândâŋ oap.” Yawu sâop. Yawu sâmu den matŋe sâwehât nâŋgâmu umatŋe otmu aŋulakmâ inâk talop. ");
INSERT INTO spl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yan tatmu lok kutdâ yaŋe hoŋ bawalipŋe yuwu sâm ekyongop. “Yeŋe lok yu kâiŋe bâtŋe nombot nombot sâhâm lâum yaehen pilâŋetâ giâk. Pilâŋetâ ge yaehen hâhiwin pato nâŋgâmbisâp. Yawu.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yawu gârâmâ den yuân hâum yakât topŋe yuwu sâmune nâŋgâŋet. Anitâŋeâmâ lohimbi kerehâk dâiyekbe sâm oap. Yawu gârâmâ lohimbi getek âlâŋe yâkâlen biwiyeŋaŋe kepeim manŋetâ manman kârikŋahât pat kuyiŋgimu mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Den ya sâm tiŋ pilâmu Parisaio yeŋeâk pereŋ pilâm ba kinmâ yuwu sâwi. “Den âlâen hâum yap yuŋeâmâ nengât topnenŋe miap. Yakât nâŋgâmunŋe bâleap. Yakât benŋe girawu otmâ sâmunŋe Roma tembe lâuŋe Yesu mem ari pâi emetŋan katŋet.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yawu sâm hoŋ bawalipyeŋe otmu Herotgât âi lok nombotŋaŋe Yesu âikuŋetâ sâm tâpikgumu topŋe mem tetenehât hâŋgânyongowi. Hâŋgânyongoŋetâ Yesuhâlen taka yuwu sâwi. “Bawapi, gâhât topge naŋgain. Gâŋe den imbiâk ki sâmat. Den sâmat ya nâŋgâmunŋe bonŋeâk otmap. Otmu lohimbiŋe nâŋgâhihiŋetâ yahalâkgât nâŋgâm âi ki tuhumat. Gâŋe lok âlâhât nâŋgârâ yahatmu âlâhât nâŋgârâ gemu yawu ki otmat. Gâŋe uwawapŋe bia otmâ manmâ garâ gekmain. Yakât wuân me wuân otnom yakât sârâ nâŋgâne. ");
INSERT INTO spl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Roma lok âlâ kunnenŋe mansap, kutŋe sisa sâm, yâhâmâ haoŋmâ ârândâŋ takesi waŋmain. Yawu gârâmâ ya waŋmâ yâhânom me bia? Yakât sârâ nâŋgâne.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yawu sâŋetâ biwiyeŋe ekmâ yuwu sâm ekyongop. “Yeŋe nâhâitŋe sâm tâpikguwuap sâm âinohoai me? Yenâmâ nimbilamyeŋe boho boho. ");
INSERT INTO spl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yakât otmâ kât nanŋe mem nihiŋetâ ekbe.” Yawu sâop. Yawu sâmu mem waŋetâ mem tiripyongom yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Kât nanŋe yu ekŋet. Yuân âlâhât towat? Me âlâhât kutŋe kinsap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sâmu sâwi. “Roma lok patonenŋe, kutŋe Sisa sâm, yâkât umutŋe yakâ.” Sâŋetâ sâop. “Sisahât pat sâm katŋetâ tap otmuâmâ yâk waŋnomai. Yâhâ Anitâhât pat sâm katŋetâ tatmap yâk waŋnomai.” ");
INSERT INTO spl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yawu sâm ekyongomu nâŋgâŋetâ sâtŋe otmu pilâm yahatmâ ariwi. ");
INSERT INTO spl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sarukaio lok yuwu nâŋgâmai. “Anitâŋe mumuŋambâ mem yahatnenekbuapgât dop âlâ ki tap. Yakât otmâ mumunŋe pesuk sâmap.” Yawu nâŋgâmai. Yâkŋe yakât topŋe nâŋgânehât Yesuhâlen ari yuwu sâm ekuwi. ");
INSERT INTO spl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Bawapi, aŋgoân Moseŋe den kulemguop ya yuwu tap. “Lok âlâŋe imbi âlâ memu naom ki mewaŋgimu lok ya mumbuap. Mumu imiŋaŋe yâkât kambut ya galemgum yâkât welâmân nimnaom mem ga katyekbuap.” Moseŋe yawu kulemguop tap. Yakât topŋe sâm eknongohât yuwu sâmunŋe nâŋgâ. ");
INSERT INTO spl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","27","Imi ata nombolân yâhâp manbi. Manmâ aŋgoân atayeŋe kunŋaŋe imbi âlâ memu imbiŋaŋe naom ki mewaŋgimu inâk manmâ muop. Mumu imiŋaŋe ataŋahât kambut ya mem manmâ yâku in muop. Otmu imiyetŋaŋe kambutyetŋe ya mem manmâ yâku yawuâk naom barahâk muop. Otmu imi ata ya hârokŋe kambutyeŋe yawuâk mem manmâ inâk muwi. Aiop, kambutyeŋe yâku yawuâk muop. ");
INSERT INTO spl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Imi ata nombolân yâhâp ya kerekŋe imbi ya mewi. Gârâmâ sâp pato tetemu Anitâŋe mumuŋambâ mem yahatnenekbuap yanâmâ imbi yamâ âlâŋe membuap?” Yawu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sâŋetâ sâop. “Anitâŋe poropetelipŋe otmu lok nombotŋe den ekyongomu kulemguwi yakât topŋe yeŋe ki naŋgai. Otmu Anitâ ikŋe wâtŋe pato tatbaŋgiap yakât topŋe gurâ ki naŋgai. Yawu gârâmâ yeŋe nâŋgâm hilipgum den yawu yai. ");
INSERT INTO spl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yakât otmâ yuwu sâmune nâŋgâŋet. Anitâŋe lohimbi mumuŋambâ mem yahatyekbuap yanâmâ himbimân Anitâhât aŋelolipŋaŋe ki miakmai ya yeŋgât dop otmâ ikŋiâk ikŋiâk mannomai. ");
INSERT INTO spl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yâhâ Anitâŋe mumuŋambâ mem yahatyekbuap yakât topŋe yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Emelâk Anitâŋe yuwu sâm Mose ekuop. “Nâŋe Awaraham, otmu nanŋe Isaka, otmu seseŋe Yakop yâk yeŋgât kunyeŋe tatmâ gaman.” Yawu kulemguop. Anitâŋe Mose den ekumu kulemguop yakât topŋeâmâ yuwu. Emelâk nengât tâmbâlipnenŋe manmâ gawi. Otmu yapâ torokatmâ manmâ gaŋetâ gaŋetâ benŋe nen yu mansain yu. Otmu gâmâlâk nengât sâm sen tetem mannomai. Nen kerek nengât kunnenŋe yamâ Anitâ. Topŋe yawu tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yawu sâmu lohimbi yan kinbiŋe den ya nâŋgâŋetâ âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Otmu Sarukaioŋe Yesuhât den matŋe sâne sâm hâum pâpgum pilâwi yakât den pat Parisaioŋe nâŋgâŋetâ bâlemu Yesuhâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ari yâk yeŋgâlen gâtŋe âlâ Mosehât girem den kâsikum ningiminiopŋe yahalop. Yahatmâ Yesuŋe den sâm hilipgumu pâi emetŋan katŋetâ talâkgât yuwu sâm âikuop. ");
INSERT INTO spl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Bawapi, yuwu âihohomune nâŋgâ. Anitâŋe girem den Mose ekumu kulemguop yapâ gâtŋe girawu ya yakât nâŋgârâ yahatsap?” ");
INSERT INTO spl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sâmu sâop. “Anitâŋe den âlâ Mose ekumu kulemguop ya yuwu tap. “Isirae ambolipŋe yen ekyongomune nâŋgâŋet. Nengât Kutdânenŋe yamâ Anitâ ikŋe konok tatmap. Nenŋe yâkâlen biwi nâŋgân nâŋgânnenŋaŋe kepeim yâk konok mepaenom. Otmu yâkât lau konok nâŋgâm lâum watmâ mannom.” Yawu tap. ");
INSERT INTO spl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Den yan yuŋe kunŋe oap. ");
INSERT INTO spl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yâhâ den âlâmâ yuwu tap. “Nenŋahât nâŋgâmunŋe yahatmap yawuâk buku nombotŋe yeŋgât nâŋgâmunŋe yahatbuap.” Yawu tap. ");
INSERT INTO spl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Anitâhât den yâhâp yan yuŋeâmâ kunŋe pato oap. Yâhâ Mose otmu Anitâhât poropete bulâŋe manbiŋe den yâhâp yukât nâŋgâm den topŋe topŋe kulemguwi.” ");
INSERT INTO spl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yawu sâm benŋe purik pilâm yuwu sâm âiyongop. ");
INSERT INTO spl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Anitâŋe hâŋgângumu gewuap. Yakât topŋe girawu naŋgai?” Sâmu sâwi. “Gewuap yamâ Dawitihât sen.” ");
INSERT INTO spl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sâŋetâ sâop. “Yawu gârâmâ Anitâhât Wâtgât Mâmâŋahât Heakŋe Dawiti mâmâŋe otbaŋgimu den kulemguop ya yuwu tap. ");
INSERT INTO spl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Anitâŋe nâhât patone yuwu sâm ekuop. “Gâŋe nâhât gotnan ga kinmâ nâhât hahit mem kasalipge yongom mem ge katyekbuat.” Yawu sâop.” ");
INSERT INTO spl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dawitiŋe den yawu sâop yakât yuwu sâmune nâŋgâŋet. Anitâŋe hâŋgângumu gewuap yakât Dawitiŋe yuwu sâop. “Yamâ patone,” sâop. Yawu gârâmâ yeŋeâmâ “Yâkŋe hâmbâi ge galemnongowuap,” sâmai. Den sâmai yamâ Dawitiŋe den sâop ya orop ki lâuaksawot.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yawu sâm âiyongomu matŋe kâpekbaŋgine sâm hâum pâpgum pilâm gem itoŋ galaŋ otmâ âlâkuâk ki âikuwi. ");
INSERT INTO spl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesuŋe lohimbi nombotŋe otmu hoŋ bawalipŋe nen yuwu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","3","“Mosehât girem den kâsikum ningimai otmu Parisaio yeŋgât den ya biwinenŋaŋe kepeim lâum manmâ yâhânom. ");
INSERT INTO spl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yamâ nenŋe yâk yeŋgât amutgen manmunŋe yu ya otŋetgât den undipŋe topŋe topŋe sâm ningimai yamâ yeŋe gurâ denyeŋe ya ki lâum watmai. Yakât otmâmâ yâkŋe otmai memai yawu ki otnom. Yâkŋe den sâm ningimai yan umatŋe kakŋan manmain. Yawu manmunŋe biwinenŋe mem huruŋ pilânehât ki tânnongomai. ");
INSERT INTO spl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nenŋe nâŋgâyiŋgimunŋe yahalâkgât nengât sennenŋan kinmâ orotmeme topŋe topŋe yuwu otmai. Mitihât pepa ya mem lotohom kunyeŋan sâhâm manmai. Otmu mitihât hâk katipŋe kâkâlep, senŋe âlâlâ hâmeŋe pato, mânuŋakŋetâ holuŋ holuŋ sâmu miti emetŋan yâhâm gemai. ");
INSERT INTO spl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Miti emetŋan yâhâ lohimbi senyeŋan ewanâk tatnehât nâŋgâmai. ");
INSERT INTO spl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Otmu lohimbi hawamyongom tatmaiŋe nenekŋetâ yahatmu mepaenenekŋetgât nâŋgâmai. Yawu otmâ manŋetâ ya ekmune bâleap. ");
INSERT INTO spl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Otmu yakât torehenŋe yuwu sâmune nâŋgâŋet. Yenâmâ dop konohâk oai. Yakât otmâ yeŋgâlen gâtŋe âlâ me âlâŋe bukulipnaŋe nekŋetâ yahatmu mepaenekŋetgât nâŋgânomai otmuâmâ yakât nâŋgâmune dondâ bâlewuap. Nâ konok Kutdâyeŋe mansan. ");
INSERT INTO spl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","10","Otmuâmâ nâ konok kunyeŋe mansan. Yakât otmâ lok âlâ me âlâ ekmâ kunnenŋe mansap sânomaihât dop âlâ ki tap. Yawu gârâmâ nengât kunnenŋe, me awoŋnenŋe Anitâ konok, himbimân tap. Yakât otmâmâ lok âlâ me âlâ ekmâmâ awoŋnenŋe ki sânomai. ");
INSERT INTO spl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yâhâ den yan yukât topŋeâmâ yuwu tap. Yeŋgâlen gâtŋe lok âlâ me âlâŋe yeŋahât nâŋgâŋetâ gemu lohimbi hoŋ bayiŋgiwuap ya yeŋgât Anitâŋe nâŋgâmu yahatbuap. ");
INSERT INTO spl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yâhâ yeŋgâlen gâtŋe âlâ me âlâŋe yeŋahât nâŋgâŋetâ yahatbuap ya yeŋgât Anitâŋe nâŋgâmu gewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yawu sâmâmâ benŋe Mosehât girem den kâsikum ningiminiwi otmu Parisaio yuwu sâm ekyongop. “Mosehât girem den kâsikum ningimai otmu Parisaio yeŋeâmâ topyeŋe kurihiakmâ Anitâhât amutgen mannehât ki nâŋgâmai. Yeŋeâmâ lohimbi nombotŋaŋe bulâŋanâk Anitâŋe tihitnenŋe olâkgât nâŋgâm mansai yâk mem ge katyekmâ mâtâp maŋguyiŋgimai. Yawu otmai yakât nâŋgâmune bâleapgât yeŋgâlen umatŋe topŋe topŋe teteyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Otmu imbi kambut emetyeŋambâ watyekmâ senŋe âlâlâyeŋe kombo meyiŋgimai. Yawu otmâ lohimbi senyeŋan topyeŋe kurihiakmâ oain sâm oain sâm otmâ Anitâ mepaem den kâlep huhumai. Yenâmâ lok perâkŋe. Yakât otmâ hâmbâi Anitâŋe matŋe umatŋe kâpekyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Otmu yeŋeâmâ lohimbi âlâ me âlâ meyekŋetâ yeŋgâlen torokatmâ denyeŋe lâum manmai. Yâhâ yeŋeâmâ hemgât pat otmâ mansai. Yawu gârâmâ lohimbi yeŋgât den lâum mansai yaŋe gurâ yawuâk hemgât pat mansai. ");
INSERT INTO spl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Otmu yuwu sâmai. “Lohimbi nombotŋaŋeâmâ opon kâmbukŋahât gahatŋan kinmâ den hikumai yamâ bonŋe bia yakât otmâ den ya ki lâunomai. Yâhâ kondo goliŋak tuhuwi yakât gotŋan kinmâ den hikumai yamâ bulâŋanâk. Yakât otmâ den ya lâunomaihât dop tap.” Yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yawu sâmai yamâ topŋe nâŋgâm tâpikgum sâmai yakât yuwu sâmune nâŋgâŋet. Girawuyakât nâŋgâŋetâ yahatmap? Kondo me senŋe âlâlâ yakât me opon kâmbukŋe kâlehen kondo me senŋe âlâlâ katŋetâ tatmap yakât? Yeŋe gurâ yakât topŋe ki naŋgai. ");
INSERT INTO spl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Otmu torokatmâ sâwe. Yeŋe yuwu sâmai. “Lohimbi nombotŋaŋe opon kâmbukŋahât alata gotŋan yâhâ kinmâ den hikunomai ya gurâ bonŋe bia, yakât otmâ ya ki lâunomai. Yakât denŋe bia. Yâhâ yâkŋe hotom une sâm alata gotŋan yâhâ kinmâ lama kum yan den hikunomai yaŋeâmâ bulâŋe otbuap yamâ lâunomaihât dop tap.” Yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yawu sâm nâŋgâm tâpikgumai. Yakât âiyongomune sâŋet. Girawu yakât nâŋgâŋetâ yahatmap? Senŋe âlâlâ Anitâhât pat kumai ya me alata yakât? Yeŋe yakât topŋe nâŋgâm hâum pâpguai yakât sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Lohimbi nombotŋaŋe hotom une sâm alata gotŋan yâhâ kinmâ lama kum yan den hikumai yaŋeâmâ alata yakâlâk den ki hikumai. Alata otmu lama yâhâp yâhâp yakât den hikumai. Topŋe yawu. ");
INSERT INTO spl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yâhâ lohimbi opon kâmbukŋan yâhâ yan den hikumai yanâmâ opon kâmbukŋahât ki hikumai. Opon kâmbukŋahât amboŋe yamâ Anitâ. Yakât otmâ yâkât senŋan kinmâ den hikumai. ");
INSERT INTO spl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Otmu himbimân Anitâ Kutdânenŋe tap yakât otmâ himbimân ekmâ den hikumai yanâmâ himbim amboŋe Anitâ yâkât senŋan kinmâ den hikumai. ");
INSERT INTO spl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yakât otmâ yen Parisaio otmu Mosehât girem den kâsikum ningimai yeŋeâmâ topŋe ya nâŋgâm tâpikgumai. Yenâmâ lok perâk. Yeŋeâmâ wahap tâŋât, hote, gitâk, kimi, ya mem ketetmâ bâlâk ŋerek osetyeŋan konok ya mem Anitâhât pat kuwaŋgimai. Yâhâ Anitâhât den nombotŋe umatŋe pato ekyongomu kulemguwi yamâ loŋgâemai. Loŋgâem yan yuwu otmâ mansai. Lohimbi yeŋgât den sâm hâreyiŋgimai yan Anitâŋe nâŋgâmu ârândâŋ olâkgât ki nâŋgâmai. Yawu otmâ den tâŋ tâŋâk ki sâm hâreyiŋgimai. Otmu buku nombotŋe yeŋgât weyeŋe ki nâŋgâm tânyongomai. Otmu biwiyeŋe Anitâhâlenâk ki katŋetâ tatmap. Yakât otmâ hâmbâi Anitâŋe matŋe umatŋe yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yu ya otmai yakât den âlâen hâum sâwe. Lok nombotŋe senyeŋe bok sâsâŋaŋe ki ekmâ mâtâp tâpikgumai. Yakât dopŋeâk yeŋe Anitâhât den bulâŋe ya betbaŋgim den tâŋât tâŋât ya lâum mansai. Yakât otmâ hâmbâi yakât matŋe umatŋe menomai.” ");
INSERT INTO spl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Otmu torokatmâ yuwu sâop. “Bâe, Mosehât girem den kâsikum ningimai otmu Parisaio yenâmâ lok perâk, nimbilamyeŋe yâhâp. Yakât otmâ den âlâen hâum yuwu sâwe. Imbi âlâŋe amaŋ mem hâkŋeâk pirimu biwiŋan sot wahapŋe yawuâk tatbuap. Yakât dopŋeâk yeŋe bukulipyeŋaŋe yekŋetâ yahalâkgât hâkyeŋeâk piriakmai. Yawu gârâmâ manman bâleŋe, me nâŋgâm bâle, me orotmemeyeŋe kiŋgoŋ ya biwiyeŋaŋe nâŋgâmai. Yawu nâŋgâŋetâ yaŋe mem bâleŋe tuhuyekmap. Yeŋgât topyeŋe yawu tap yamâ ki eŋakmâ naŋgaŋgimai. ");
INSERT INTO spl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Biwiyeŋan yawu tap gârâmâ aŋgoân yeŋe biwi nâŋgân nâŋgânyeŋe ya sâm pitiaknomai. Yawu otnomai yanâmâ hâkgât wahap wuân me wuângât nâŋgâŋetâ tâŋât otbuap. Yâhâ ki otnomai yamâ yiwereŋe umatŋe teteyiŋgimap yu wangim umatŋe pato witgumâk teteyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Parisaio otmu Mosehât girem den kâsikum ningim mansai yeŋgât topyeŋe teteâkgât den âlâen hâum yuwu sâwe. Lok kurihiyekmain ya yeŋgât sum kakŋanâmâ awu tawu kâmetmunŋe baŋbaŋ sâm sekŋe âlepŋe otmâ imap. Yâhâ lâm kâlehenâmâ tâtuk sâm nane gorewaŋ yaŋe ololoŋ sâm kinmap. Yeŋgât biwi nâŋgân nâŋgânyeŋe yamâ yakât dop. Yawu gârâmâ yeŋeâmâ hâkyeŋe piriakŋetâ salek olâkgâlâk nâŋgâmai. Yamâ biwiyeŋanâmâ nane gorewaŋ yawu yaŋe tap. Yakât otmâ yuwu sâwe. Yeŋgât biwi nâŋgân nâŋgânyeŋan Anitâhât den bulâŋe ki tatmap. Yakât otmâ hâmbâi Anitâŋe mem purik pilâyiŋgimu matŋe umatŋe menomai. ");
INSERT INTO spl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Otmu yeŋeâmâ yuwu sâmai. “Poropete lok, otmu lohimbi nombotŋaŋe âiloŋgo loŋgo manmâ gam muwi ya yeŋgât sumân awu tawu kâmetmunŋe baŋbaŋ sâm sekŋe âlepŋe otmâ imap.” ");
INSERT INTO spl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yawu sâm yaŋak âlâmâ yuwu sâmai. “Bâe, aŋgoânâk tâmbâlipnenŋe manbiân yan nenŋe manbin mâne poropete lok yu ki yongombâin.” Yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yakât yuwu sâmune nâŋgâŋet. Emelâk tâmbâlipyeŋaŋe poropete yongoŋetâ muwi ya yeŋgât yuwu sâmai. “Nenŋe tâmbâlipnenŋe yeŋgât sen mansain.” Yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","33","Yakât otmâ tâmbâlipyeŋaŋe otminiwi yakât Anitâŋe matŋe umatŋe yiŋgiwuap. Yawu gârâmâ tâmbâlipyeŋaŋe orotmeme bâleŋe otminiwi ya yeŋe yawuâk torokatmâ mansai yakât matŋe umatŋe dondâ yiŋgiwuap. Yamâ yeŋe wangiyekmâ sânduhân mannomaihât dop âlâ ki tap. Yamâ bulâŋanâk teteyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Otmu topyeŋe teteâkgât âlâ torokatmâ yuwu sâwe. Hoŋ bawalipne nombotŋe âi sâm yiŋgimune yeŋgâlen taka Anitâhât topŋe kâsikum yiŋgim mannomai. Yamâ yeŋe nâhât den pat bialâkgât yongom mem ge katyeknomai. Nombotŋeâmâ howanân yongom kânâŋgâyeknomai. Nombotŋeâmâ den âiân katyekmâ yongom mem âlâlâ tuhuyekŋetâ tiok taok otmâ arim kinnomai. ");
INSERT INTO spl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yakât yuwu sâwe. Emelâk Anitâŋe ikŋe hoŋ bawalipŋe hâŋgânyongomu denŋe lâum manmâ gawi ya gurâ yawuâk tâmbâlipyeŋaŋe nâŋgâm bâleyiŋgim yongom mem ge katyekbi. Yakât huhopŋe ya yeŋe menomaiâk. Yakât topŋe nâŋgâŋetâ keterahâkgât yuwu sâwe. Embâŋân topŋe katmâ tâmbâlipyeŋaŋe lok âlâ, kutŋe Awe sâm, ya kuŋetâ muop. Otmu miti lok âlâ, kutŋe Sekaraia, yamâ opon kâmbukŋan hotom um bam gam kinmu yanâk kuŋetâ muop. ");
INSERT INTO spl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yawu gârâmâ poropete lok kerek yongoŋetâ muwi yakât huhopŋe yen gurâ umatŋe menomaiâk. ");
INSERT INTO spl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Bâe, Yerusalem kapi ambolipŋe yeŋgât topyeŋe yuwu tap. Yeŋgâlen âi meŋetgât Anitâŋe ikŋe hoŋ bawalipŋe hâŋgânyongomu takaŋetâ yongom mem ge katyekmai. Yakât otmâ den âlâen hâum yuwu sâwe. Pâi mâmâŋaŋe kurâk sâm nanlipŋe dâiyekmâ kuratyongomu tatmai. Yakât dopŋeâk menduhuyekmune nâhât hikinnan manŋetgât sâman. Yamâ yeŋe nâhât hâkâŋ otmâ mansai. ");
INSERT INTO spl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yawuhât Anitâŋe betyongomu kasalipyeŋaŋe taka yongom watyekŋetâ kapi yu kâwurumŋaŋak kinbuap. ");
INSERT INTO spl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yakât otmâ nâŋe pilâyekmâ ariwom. Benŋe sâp âlâen âwurem takamune nekmâ yuwu sâm eknohonomai. “Anitâ Kutdânenŋaŋe tihitnenŋe otbe sâm mat hâŋgângohomu taka. Yakât otmâ biwinenŋaŋe heroŋe pato naŋgain.” Yawu sâm eknohonomai.” Yesuŋe yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuŋe menenekmu opon kâmbukŋe pilâm ge kambenenŋe kakŋambâ olelem ekmunŋe âlâ kândâkdâ olop. Yawu otmâ yuwu sâm âikuwin. “Pato, yu nâŋgâ. Opon kâmbukŋe pato nandoroŋe yu ekmunŋe âiloŋgo oap. Yakât gâŋe ekdâ girawu oap? Ya sârâ nâŋgâne.” ");
INSERT INTO spl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sâmunŋe yuwu sâm eknongop. “Opon kâmbukŋe yu ekŋetâ âiloŋgo loŋgo oap yuâmâ hâmbâi kasalipyeŋaŋe taka huhum gahaem senŋe âlâlâ kâlehen tap yu mem itoŋ galaŋ tuhunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yawu sâm eknongomu nenŋe pumŋe âlâ, kutŋe Oliwa sâm, yan yâhâwin. Yan yâhâ yok pilâm Yesu yuwu sâm âikuwin. “Gâ opon kâmbukŋahât den eknongoat yakât bulâŋe sâp girawuân tetewuap? Yâhâ sâp pato tâlâhumu gâŋe âwurem gewuat. Sâp yan wuân kulem tetemu ekmâ nâŋgâmunŋe keterakningiwuap?” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Sâmunŋe sâop. “Lok nombotŋaŋe taka den perâkŋe yuwu sâm kâityongonomai. “Nâmâ Anitâŋe hâŋgânnohomu ge mansan.” Yawu sâm kâityongoŋetâ lohimbi dondâŋe denyeŋe nâŋgâm lohotŋe otmâ yâk yeŋgâlen torokatnomai. Yawu otmâ yeŋgât biwiyeŋan kioŋetâ denyeŋe nâŋgâm yâk yeŋgâlen torokatmaihât galemyeŋe oraŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","8","Otmu kuk kapam topŋe topŋe tetewuap yakât nâŋgâm ki gorâyiŋgiwuap. Yawu otmâ yuwu nâŋgânomai. “Bâe, emet inânŋan Yesuŋe eknongop yakât bulâŋe teteap. Yamâ yu tetewuapgât Anitâŋe embâŋân sâm kalop.” Yawu nâŋgâm imbiâk nâhâitŋe “In yawu âwurem gewuap” yawu ki nâŋgânomai. Aŋgoân lohimbi hânŋan kulemŋan hânŋe mansai dondâhâlâkŋe kasa oraŋgim ahonomai. Otmu sâp yan po pato tetewuap. Otmu mososoŋ membuap. Yawu otmu umatŋe topŋe topŋe tetewuap yakât den âlâen hâum yuwu sâmune nâŋgâŋet. Imbilipyeŋaŋe naom mene sâm hâliliakmâ tatmâ memai. Hâliliakmâ tatmâ naom gemu yanâmâ hâkyeŋe sânduk sâmap. Yakât dopŋeâk umatŋe topŋe topŋe teteyiŋgiwuap yakât kakŋan âwurem gewom. Gemune yanâmâ pesuk sâwuap. ");
INSERT INTO spl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yâhâ mitihât kasaŋaŋe nâhât den pat âlepŋe nâŋgâŋetâ nahat otmâ hakyeŋan sâm den âiân katyekmâ yongom mem âlâlâ tuhuyeknomai. Yanâmâ yen nombotŋe yongoŋetâ munomai. ");
INSERT INTO spl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Otmu hilipnongomai sâm yen nombotŋaŋe kiŋgityeŋahât otmâ topyeŋe kurihiakmâ nâhât komolâmbâ hioŋakmâ betyeŋehen kioŋmâ kasa oraŋginomai. ");
INSERT INTO spl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Otmu sâp yanâmâ lok perâkŋe nombotŋaŋe yahatmâ yeŋahâlâk nâŋgâm yuwu sâm kâityongonomai. “Nenâmâ Anitâhât poropete bulâŋe mansain.” Yawu sâm kâityongoŋetâ lohimbi dondâŋe yâk yeŋgâlen torokatmâ hiliwahonomai. ");
INSERT INTO spl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Otmu lohimbi nombotŋaŋe bukulipyeŋe otŋetâ bâleâkgât bukulipyeŋe kendâyiŋgiŋetâ yâk yeŋgâlen torokatmâ sambe otnomai. Yawu otnomai yakât huhopŋe yamâ Anitâhât komolân gâtŋe nombotŋe hioŋakmâ biwiyeŋe pâlâmŋe otmu buku ki oraŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yawu gârâmâ umatŋe âlâlâ teteyiŋgiwuap yan lohimbi nombotŋaŋe Anitâhâlen biwiyeŋaŋe kepeim sâtgum mannomai. Yamâ Anitâŋe bulâŋanâk mem manman âlepŋan katyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yâhâ Anitâŋe lohimbi kerek yeŋgât tihityeŋe otbuap yakât den pat âlepŋe ya lohimbiŋe nâŋgâŋetâ bulâŋe otmu yâkâlen biwiyeŋaŋe kepeiŋetgât yeŋe hânŋan kulemŋan ari ekyongonomai. Ekyongoŋetâ ârândâŋ otmu Anitâŋe hâŋgânnohomu âwurem gewom”. Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Yesuŋe kapam me âlâlâ umatŋe tetewuap yakât yuwu sâm eknongop. “Poropete âlâ, kutŋe Danie sâm, yâkŋe umatŋe topŋe topŋe tetewuap yakât emet inânŋan yuwu kulemguop tap. “Kasalipyeŋaŋe yeŋe lok kutdâ yeŋahât umutŋe lâum opon kâmbukŋan yâhâ kânâŋgâŋetâ kinbuap.” Yawu kulemguop. Danieŋe den kulemguop ya nâŋgâm biwiyeŋan katmâ mannomai. Otmu kasalipyeŋaŋe taka yawu otŋetâ bâlewuap ya ekmâ yawuya otmâ yan hilipyongomaihât Yuraia hânân kapi tatmâ arap ya ambolipŋaŋe kapi yeŋe pilâm itoŋ galaŋ otmâ hewukŋehen ari misiŋguraknomai. ");
INSERT INTO spl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Otmu Yerusalem kapi ambolipŋaŋe gurâ yawuâk sururuk sâm ari misiŋguraknomai. Yawu otmâ emetyeŋan yâhâ itâ pareŋe miakne sâm yakât ki nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Otmu lohimbi nep tuhuakmâ mannomaiŋe gurâ âwurem taka emetyeŋan iri sikumyeŋe me senŋe âlâlâyeŋe ya miaknehât ki nâŋgânomai. Yawu otmâ in yawu sururuk sâm hewukŋehen ari misiŋguraknomai. ");
INSERT INTO spl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","21","Sâp yanâmâ imbi tepdâek umat karat mannomai. Otmu ŋaŋa hewâk hewâhâk mem hikakmâ manŋetâ wâtyeŋe ki tiŋ tiŋ sâwuap yaŋe hiliwahomaihât yeŋe Anitâ ulitgunomai. Otmu kasalipyeŋaŋe to yambu sâpŋan me tatmâ nâŋgâ nâŋgâ sâpŋan takamai sâm Anitâ yawuâk ulitgunomai. Kasalipyeŋaŋe takanomai yanâmâ umatŋe pato nandoroŋe kakyeŋan yâhâwuap. Kândikum Anitâ lohimbi katyelehop yapâek umatŋe yan yuwuya âlâ ki teteop. Yawu gârâmâ umatŋe kakyeŋan yâhâwuap yukât kakŋan yuwuya âlâ ki tetewuap. ");
INSERT INTO spl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yakât otmâ Anitâŋe ikŋe lohimbilipŋe kerek hiliwahom metemaihât sâp ya mem tâlâwâk tuhuwuapgât sâm kalop.” ");
INSERT INTO spl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Otmu sâp yan lok nombotŋaŋe nâhât yuwu sâm yen kâityongonomai. “Anitâŋe Yesu hâŋgângumu âwurem ge tihitnenŋe otbuap sâop yamâ emelâk hâŋgângumu endaken ge mansap.” Yawu sâŋetâ ki nâŋgâyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sâp yanâmâ lok perâkŋe nombotŋaŋe kurihiakmâ oain sâm oain sâm yuwu sâm ekyongonomai. “Nâ galemyeŋe manbehât Anitâŋe âi sâm nihim hâŋgânnohomu ge mansan.” Yawu sâm nâhât lohimbi bulâŋe yaŋe yâk yeŋgâlen torokatŋetgât kulem topŋe topŋe menomai. Yawu otŋetâ yekmâ betyiŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yâhâ emet inânŋan den ekyongoan yu biwiyeŋan katmâ galem oraŋginomai. ");
INSERT INTO spl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yâhâ sâp yan lok nombotŋaŋe den mem yuwu sâm ekyongonomai. “Anitâŋe hâŋgângumu âwurem ge lok ki manmaiângen mansap.” Yawu sâŋetâ yâk ekne sâm yaken ki arinomai. Me lok nombotŋaŋe den mem yuwu sânomai. “Anitâŋe hâŋgângumu âwurem ge wosaken me wosaken ge mansap,” sâm ekyongoŋetâ yâk yeŋgât den ya ki nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yakât torokatmâ sâwe. Nâ gewom yan yok pilâm ki gewom. Himbim belek sâmu laŋinŋaŋe siliŋ siliŋ sâm nombotgembâ nombot otmâ haŋ sâmap yakât dopŋeâk Anitâŋe nâ lok bulâŋe hâŋgânnohomu âwurem gewom. Âwurem gemune lohimbi hânŋan kulemŋan mansai kerekŋe nâhât laŋinŋe ekmâ topŋe nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yâhâ umatŋe âlâlâ tetewuap yakât emet inânŋan ekyongom gaman. Yukât bulâŋe hâmbâi tetewuawân ekmâ topŋe nâŋgâm heŋgeŋgunomai. ");
INSERT INTO spl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Umatŋe topŋe topŋe tetewuap yanâmâ hilâmgât emetsenŋe otmu omoŋgât emetsenŋe yamâ bok sâmu omoŋ sahakbuap. Omoŋ sahakmu pitu yaŋe himbimâmbâ pek sâm genomai. ");
INSERT INTO spl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sâp yanâmâ Anitâŋe yâhâpŋe nâ hâŋgânnohomu âwurem gewom yan wâtne tetemu lohimbiŋe ekmâ kâi bât sân sân otmâ hu halak tuhunomai. Sâp yanâmâ Anitâŋe yâhâpŋe hâŋgânnohomu elem kulewoŋboŋ kakŋambâ gemune nekŋetâ sâtŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Âwurem gewom yan aŋelone âlâŋe lâmunŋe kunmu aŋelolipne hâŋgânyongomune emetsenŋe gahaŋehen geheŋehen hân ewun embun arinomai. Ari nâhât lohimbi manman kârikŋahât pat Anitâŋe kuyiŋgimu mannomai ya kerek menduhuyeknomai. ");
INSERT INTO spl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sâp yan âwurem gewom yakât nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâwe. Nenâmâ bândup baiako huhuakmu ekmâ yanâmâ “Emet kinbe sâm oap,” sâmain. ");
INSERT INTO spl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yakât dopŋeâk hâmbâi den yan yukât bulâŋe tetemu ekmâ yuwu sânomai. “Âo, yu Yesuŋe emet inânŋan den eknongop yakât bulâŋe tetemu eksain. Âwurem gewuapgât sâp tâlâhuap.” Yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Otmu den yan yuâmâ lohimbi âun yu mansai ki muŋetâek bulâŋe tetewuap. Yakât yuwu sâwe. Den yan yukât bulâŋe bulâŋanâk tetewuap. ");
INSERT INTO spl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yâhâ hân himbim pitu âlâlâ emelâk Anitâŋe kalop ya biatmâ metewuap. Yawu gârâmâ nâhât den yamâ ki biatbuap. Yamâ tat tat kârikŋe tatmâ yâhâmbisâp. ");
INSERT INTO spl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Sâp pato tetewuap yakât yuwu sâmune nâŋgâŋet. Sâp gewom lohimbi kerekŋe yakât ki naŋgai. Otmu aŋelo himbimân tatmai yâkŋe gurâ yawuâk ki naŋgai. Otmu ninak gurâ ki naŋgan. Awoŋne himbim amboŋe ikŋahâk naŋgap. ");
INSERT INTO spl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Âwurem gewom yanâmâ pârâk sân sânâk gewom. Yâhâ âwurem gewom yakât sâpŋe tâlâhuwuap yanâmâ orotmeme girawuya otmâ mannomai yakât yuwu sâmune nâŋgâŋet. Emelâk embâŋân Noaŋe manmu towat teteop dop yawuâk ya tetewuap. Emelâk Noaŋe manop yanâmâ lohimbi gulip malap manmâ yeŋe âi yeŋahâlâk nâŋgâm manbi. Yawu manŋetâ Noaŋeâmâ waŋga kâlehen yâhâop. Yawu otmâ nen âlepŋe mansainâk sâm gulip malap manmâ gaŋetâ yan Anitâŋe nâŋgâmu toŋgelâk pato gemu to niŋ niŋ sâm lohimbi kerek haranyongomu mum metewi. Yakât dopŋeâk lohimbi nombotŋaŋe âlepŋe mansainâk sâm otŋetâ yan Anitâŋe yâhâpŋe nâ hâŋgânnohomu âwurem gewom. ");
INSERT INTO spl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Gewom yan lohimbi âi kalamyeŋe tuhum gulip malap mannomai yamâ Anitâŋe nombotŋe ya meyekbuap. Nombotŋe yamâ pilâyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yâhâ mâtâp mannomai gurâ nombotŋe meyekmâ nombotŋe pilâyekbuap. ");
INSERT INTO spl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yawu gârâmâ nâ Kutdâyeŋe gewom yakât sâp yeŋe ki naŋgai. Yakât otmâ biwi golâ tatmâ sen galem otmâ mannomai. ");
INSERT INTO spl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yakât den âlâen hâum yuwu sâwe. Kapi âlâ me âlâhât kasalipyeŋaŋe sâp girawuân taka yongom itit kiom tuhuyiŋginomai yakât ki ekyongomai. Inâk pârâk sân sânâk takamaihât kapi ambolipŋaŋe sen galem manmâ emet kapiyeŋe galemgunomai. ");
INSERT INTO spl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yakât dopŋeâk Anitâŋe hâŋgânnohomu âwurem gewom yakât sâp yeŋe ki naŋgai. Yakât otmâ biwi golâ manmâ mambotnihim yâhânomai. Yawu otnomai otmuâmâ âwurem gemune nekmâ heroŋe nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yakât yâhâpŋe den âlâen hâum yuwu sâwe. Lok kutdâ âlâŋe kapiŋe pilâm kapi kâlepŋehen ari kandi manmâ âwurem tohowuap. Yaken ariwe sâm yan hoŋ bawaŋe âlâ galem sâm katmâ yuwu sâm ekuwuap. “Arimuneâmâ gâŋe nep lok nombotŋe galemyongowuat.” Yawu sâm ekum pilâyekmâ arimu galem yaŋe âi ya biwiŋaŋe mem galemyongomu âiloŋgo mannomai. ");
INSERT INTO spl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yawu otmâ galemyongowuap otmuâmâ patoŋaŋe âwurem taka heroŋe otbaŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yawu otbaŋgim galem pato katmu ikŋe senŋe âlâlâŋe yakât galem otbuap. ");
INSERT INTO spl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yâhâ purik pilâm sâmune nâŋgâŋet. Hoŋ bawa yaŋe biwiŋaŋe yuwu nâŋgâm âi ya hilipguwuap. “O, lok kutdâne arap yuâmâ in yawu ki takawuap. Yamâ sâp kâlep manbuap yakâ. Yakât otmâ wongât nâŋe âi yu membom?” ");
INSERT INTO spl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yawu sâm biwiŋaŋe pâlâmŋe otmu ki galemyongom heŋgeŋguwuap. Yawu manmâ to kârikŋe nem biwi hâlim otmu umatŋe topŋe topŋe teteyiŋgiwuap. Yawu otmâ lok bâleŋe yeŋgâlen torokatmâ ki orotŋe otmâ manbuap. ");
INSERT INTO spl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Yawu otmâ biwiŋaŋe pâlâmŋe otmu patoŋaŋe pârâk sân sânâk taka kuk otmâ kum yaehen pilâmu ge hâhiwin nâŋgâm yâhâmbisâp.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesuŋe sâp patoen âwurem gewuawân Anitâŋe menenekmâ ikŋan katnenekbuap yakât den âlâen hâum yuwu sâop. “Lok sihan âlâŋe imbi membuap yâkât pat kuwaŋgiwi. Otmu ya taka membom sâm den katmu takaop. Yamâ imbi membuap yakât bukulipŋe bâtnombot nombot hârok menduhuakmâ ari mâtâwân kinmâ mambotbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Otmu yâk yeŋgâlen gâtŋe imbi mome yamâ biwiyeŋe golâek manmâ lambe otmu lambe toŋe yâhâp yâhâp miakmâ ariwi. Yâhâ imbi mome âlâmâ biwi pâlâmŋe manbi yakât otmâ lambeyeŋe ya toŋe saŋ sâop. Otmu lambe toŋe gurâ ki kâsikum miakmâ ariwi. ");
INSERT INTO spl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yawu manŋetâ sâp kâlewâk otmu amangât yekmu iwi. ");
INSERT INTO spl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Im tatŋetâ omoŋ derepŋan lok yaŋe takaop. Takamu kapi yakât mâtâpgât galemŋe kinop yaŋe ekmâ ekyongop. “Wa, aman aman. Imbi pat kuwaŋgiwi lok ya takawo. Yakât otmâ yahatmâ ari penewaŋgiŋet.” ");
INSERT INTO spl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yawu sâm mândiyekmu yahatmâ ariwi. Yawu otmâ lambeyeŋe toŋe orowâk mem manbiŋe tipiŋe âlâ sem talop ya meŋetâ laŋinŋe pato olop. ");
INSERT INTO spl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yawu otŋetâmâ bukulipyeŋaŋe yuwu sâwi. “O, nenâmâ lambe toŋe bia. Yakât otmâ nombotŋe gâim ningiŋet.” sâm ulityongowi. ");
INSERT INTO spl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sâŋetâ sâwi. “Bia, to yu dopnenŋanâk miain. Yawu gârâmâ yeŋak aŋgim bero emetŋehen ari puluhum miakmâ takaŋet.” ");
INSERT INTO spl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yawu sâŋetâ aŋgim bero emetŋehen ba ariwi. Ari yaken manŋetâ bukulipyeŋaŋe ge lok ya penawaŋgiŋetâ orowâk emet kâlehen yâhâ gahatŋe maŋgum sot newi. ");
INSERT INTO spl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nem tatŋetâ imbi nombotŋe ya belângen taka yuwu sâwi. “O, lok pato, gahatŋe meningirâ kâlehen gane.” ");
INSERT INTO spl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sâŋetâ sâop. “Bia, ba ariŋet. Nâ ki nâŋgâyiŋgian. Yen wonân gâtŋe?” Yawu sâm watyehop. ");
INSERT INTO spl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yakât topŋe yuwu sâmune nâŋgâŋet. Nâ sâp girawuân takawom ya yen ki naŋgai. Yakât otmâ galemahom heŋgeŋgum nâhât sen dâi dâi otmâ mannomai. ");
INSERT INTO spl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Otmu den âlâen hâum sâmune nâŋgâŋet. Lok âlâŋe kapi kâlepŋehen ariwe sâm âi loklipŋe yongonmu gaŋetâ yuwu sâm ekyongop. “Senŋe âlâlâ tatnihiap yu galemgum mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yawu sâm âi loklipŋe tewetsenŋe mem dopyeŋan âlâku ikŋiâk ikŋiâk yiŋgiop yamâ yuwu. Âlâmâ 5000 kina yakât dop waŋmu miop. Âlâmâ 2000 kina yakât dop waŋmu miop. Bâiŋeâmâ 1000 kina yakât dop waŋmu miop. Yawu yiŋgim yaŋak pilâyekmâ ariop. ");
INSERT INTO spl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yâhâ 5000 kina yakât dop miopŋeâmâ âi topŋe topŋe tuhum yan 5000 kina âlâkuâk tâtâem miop. Ya mem menduhumu 10,000 kina yakât dop olop. ");
INSERT INTO spl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Otmu 2000 kina yakât dop miopŋe âi topŋe topŋe tuhumu 2000 kina dop âlâ tetemu 4000 kina yakât dop olop. ");
INSERT INTO spl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yâhâ 1000 kina yakât dop miopŋe âi ki tuhuop. Yâkŋeâmâ tewetsenŋe ya mem itâ hambuŋan mânuŋmâ tuŋgu topŋan katmu in tatmâ gaop. ");
INSERT INTO spl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Otmu patoyeŋaŋe sâp kâlep manmâ âwurem takaop. Taka âi loklipŋe tewetsenŋe yiŋgiop ya yongonmu gaŋetâ âlâku ikŋiâk ikŋiâk yuwu sâm âiyongop. “Tewetsenŋe yiŋgiwan yaŋe mem âi tuhuŋetâ amon teteap?” Yawu sâm âi yongop. ");
INSERT INTO spl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yâhâ lok 5000 kina miopŋeâmâ 5000 kina yâhâpŋe teteop ya mem ga yuwu sâm ekuop. “Lok pato, gâŋe 5000 kina nihion yaŋe mem âi tuhumune âlâku 5000 kina teteop.” Yawu sâm bâtŋan kalop. ");
INSERT INTO spl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bâtŋan katmu patoŋaŋe yuwu sâm ekuop. “Âi mendâ âiloŋgo oap. Yakât otmâ tepne heroŋe nâŋgâm âi âlâ torokatmâ gihimune galemguwuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yawu sâmu arimu lok 2000 kina miopŋe ga ekuop. “Lok pato, gâŋe 2000 kina nihion yaŋe mem âi tuhumune âlâku 2000 kina teteop.” ");
INSERT INTO spl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yawu sâm waŋmu sâop. “Âi mendâ âiloŋgo oap. Yakât otmâ tepne heroŋe nâŋgâm âi âlâ torokatmâ gihimune galemguwuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Yawu sâmu arimu lok 1000 miopŋe ga ekuop. “Lok pato, gâhât topge nâŋgâm heŋgeŋguan. Gâ lok sâtŋe. Lok âlâ me âlâŋe gâhât nep kâmetŋetâ âlemap yamâ gikahâk nemat. Yawu otmat yakât sâŋetâ nâŋgâman. ");
INSERT INTO spl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yakât otmâmâ gâhât kiŋgitnahât otmâ tewetsenŋe nihion ya biatgihimap sâm itâ hambuŋan mânuŋmâ katmune tatmâ gamap.” Yu mem yawu sâm waŋop. ");
INSERT INTO spl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Sâmu sâop. “Gâ lok konam. Nâhât topne emelâk naŋgat. Lok âlâ me âlâŋe nâhât nep kâmetŋetâ âlemap yamâ ninahâk neman. Yakât otmâ gâŋe tewetsenŋe gihiwan yu mem kât emetŋan katdâ tatmu tewetsenŋe âlâkuâk teteop mâne gâŋe mem bâtnan katdâ ârândâŋ otbâp. ");
INSERT INTO spl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yawu ki olon yakât yuwu naŋgan. Bukuhaŋe 5000 kina mem kinsapŋe nâhât tem lâum âi torokatmâ tuhum gap. Yakât otmâ gâhât bâtgambâ 1000 kina yu mem bukuhe waŋbom. ");
INSERT INTO spl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yakât yuwu sâmune nâŋgâŋet. Anitâŋe lok âlâ me âlâ âi sâm yiŋgimu biwiyeŋaŋe kepeim tuhumai yâhâmâ tâtâem mâmâŋe otyiŋgimu âiloŋgoâk tuhumai. Yawu gârâmâ lok âlâ me âlâ âi sâm yiŋgimu ki tuhumai yâhâmâ betyongomap. ");
INSERT INTO spl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yakât otmâ lok konam imap yu watŋetâ yaehen ge hemgât pat manmâ hâhiwin nâŋgâm hu halak tuhumbisâp.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesuŋe den âlâ torokatmâ yuwu sâop. “Âwurem ge mem kâsipyongomune komot yâhâp otŋetâ matŋe yiŋgiwom yakât sâwe. Anitâŋe yâhâpŋe hâŋgânnohomu purik sâm gewom yanâmâ aŋelolipne kerek meyekmune yeŋgât den sâm hâreyiŋginomgât genom. ");
INSERT INTO spl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yakât otmâ den âlâen hâum yuwu sâwe. Lama otmu noniŋ konohân kinŋetâ galemŋe hohetyeŋan ba kinmâ mem ketetyekbuap. Ketetyekmu yan lama komot ikŋiâk otmu noniŋ komot ikŋiâk kinnomai. ");
INSERT INTO spl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nâŋe dop yawuâk lohimbi kerek mem ketetyekbom. Nombotŋe nine pat mannomai yamâ bonângen katyekbom, otmu nombotŋe hemgât pat mannomai yamâ kanehen katyekbom. ");
INSERT INTO spl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Otmu nine lohimbi Anitâŋe hân himbim ki kalowân yan manman kârikŋahât pat kuyiŋgiop yâhâmâ yuwu sâm ekyongowom. “Nâ sotgât muwan yanâmâ um nihiŋetâ newan. Me tohât hâŋ hâŋâk nehop yanâmâ osom nihiŋetâ newan. Me yeŋgâlen pup takawan yanâmâ buku otnihiwi. Me kundat tetenihiop yanâmâ tihitne otbi. Me senŋe âlâlâhât umburuk otban yanâmâ tânnohowi. Me papatolipnaŋe pâi emetŋan mem katnekŋetâ tatban yan nâhât tepyeŋe nâŋgâm buku otnihiwi. Yawu otnihiminiwi yakât awoŋne tihit amboŋaŋe manman kârikŋan katyekmu manmâ yâhânomai.” Yawu sâm ekyongowom. ");
INSERT INTO spl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ekyongomune sânomai. “Lok pato, gâŋe den eknongoat yu nâŋgâmunŋe ki keterakningiap. Sâp girawuân sotgât, me tohât, me âlâlâhât sârâ buku otgihiwin? ");
INSERT INTO spl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Me sâp girawuân nengâlen takarâ pupŋe gekmâ yan buku otgihiwin? ");
INSERT INTO spl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Me pâi emetŋan talon yan, me kundat umatŋe topŋe topŋe tetehihiowân nen yawu tângohowin? Nenâmâ yawu ki otgihiwin naŋgain.” Yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sâŋetâ sâwom. “Yeŋe nâhât komolân gâtŋe âlâ me âlâ geheŋe manbi ya tânyongowi. Yawu otbi yamâ yâk otyiŋgiain sâm nâ otnihiwi.” Yawu sâwom. ");
INSERT INTO spl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","Yawu sâm ekyongom benŋe kanehen kinnomai ya yuwu sâm ekyongowom. “Nâŋe sotgât po nihimu manban yan ki um nihiŋetâ newan. Me tohât hâŋ hâŋâk nehop yan ki osom nihiŋetâ newan. Me yeŋgâlen pup takawan yan dâinekmâ emetyeŋan yâhâ ki katnekbi. Me senŋe âlâlâhât umburuk otbanân ki tânohowi. Me kundat umatŋe tetenihiop, me pâi emetŋan mem katnekŋetâ tatban yan gurâ ki taka buku otnihiwi. Yawu otnihiminiwi yakât Anitâŋe emelâk kâlâpgât pat kuyiŋgimu tap. Yeŋe pilânekmâ Satan otmu hoŋ bawalipŋe yeŋgâlen torokatmâ orowâk tatŋetâ kâlâpŋe seyekmu hâhiwin nâŋgâm yâhâmbisâi.” ");
INSERT INTO spl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yawu sâm ekyongomune yâkŋe yuwu sâm buiaknomai. “Sâp girawuân gâŋe sotgât, me tohât, me senŋe âlâlâhât sârâ ki tângohowin? Me sâp girawuân nengâlen pup takarâ emelan ki dâihekmâ yâhâ katgekbin. Me kundat tetehihiowân, me pâi emetŋan katgekŋetâ talonân yan ki tângohowin? Yakât sârâ nâŋgâneâyâ.” ");
INSERT INTO spl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yawu sâm buiakŋetâmâ yuwu sâwom. “Yeŋe nâhât komolân gâtŋe âlâ me âlâ geheŋe manbi ya ki tânyongowi. Yawu otbi yamâ yâk otyiŋgiain sâm nâ otnihiwi.” Yawu sâwom. ");
INSERT INTO spl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yawu sâm hâpunmâ pilâyekmune kâlâp pato sem kilik kilik sâm kinmawân kioŋnomai. Yâhâ lohimbi nombotŋe nâhât pat mansai yamâ meyekmune nine manmanân torokatmâ ya ambokum heroŋ maroŋ manmâ yâhâmbisâi.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuŋe den yawu sâm tiŋ pilâm benŋe girawu tetewaŋgiwuap yakât nen hoŋ bawalipŋe eknongop. ");
INSERT INTO spl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Halihu Tihit tihit hombaŋ tetemu yanâmâ Anitâŋe nanŋe bulâŋe nâ hâŋgânnohomu gewan yakât topŋe teteâkgât howanân nohom kânâŋgâneknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","Sâp yanâmâ hotom uminiwi yeŋgât kunlipyeŋe otmu Yura nengât papatolipnenŋaŋe Kaipasihât emelan yâhâ menduhuakmâ Yesu kumunŋe mumbuap sâm yakât den hikuwi. ");
INSERT INTO spl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yawu gârâmâ Yesu mem kuŋetâ mumu lohimbiŋe ekŋetâ kuk pato tetemapgât yok pilâm in yawu kumunŋe mumbuap yakât den hikuwi. ");
INSERT INTO spl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sâp yanâmâ Yesuŋe menenekmu Betani kapiân yâhâwin. Yan yâhâ lok âlâ, kutŋe Simon sâm, hâk bâle tetewaŋgimu manminiop ya heŋgeŋguop yâkât emelan yâhâ orowâk tatmâ sot newin. ");
INSERT INTO spl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sot nem tatmunŋe imbi âlâŋe to kukŋe suk sukŋe âlâ, hâmeŋe yahat yahatŋe, ya mem emelan tatbinân gaop. Yâhâ to ya mem Yesuhât kunŋan motelemu giop. ");
INSERT INTO spl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Motelemu gemu nen Yesuhât hoŋ bawalipŋaŋe ekmunŋe ki ârândâŋ otmu yuwu sâwin. “Wongât to kukŋe suk sukŋe yu imbiâk mem motelemu kunŋan giap. Ya ekmunŋe ki ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nenŋe to yu âlepŋe mem arimunŋe lok nombotŋaŋe puluhuŋetâ yakât hâmeŋe mem lok umburuk mansai yawu ya tânyongombâingât dop.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yawu sâmunŋe Yesuŋe nâŋgâmu ki ârândâŋ otmu yuwu sâop. “Imbi yuŋeâmâ kulem oap yukât wongât nâŋgâŋetâ bâleap? Nâŋe nâŋgâmune âiloŋgo oap. Yakât yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Lok umburuk mansai yamâ sâp kâlep manŋetâ tânyongonomaihât dop tap. Yâhâ nâmâ sâp kâlep ki otmuâk pilâyekbom. ");
INSERT INTO spl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nâmâ mumune hannohonomai yakât mâtâp menihim imbi yuŋe to kukŋe suk sukŋe ya motelemu kunnan giap. ");
INSERT INTO spl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yakât yuwu sâmune nâŋgâŋet. Nâhât den pat âlepŋe yu hânŋan kulemŋan ari ekyongonomai. Otmu imbi yuŋe kulem otnihiap yukât den pat ya gurâ yawuâk ekyongoŋetâ nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Otmu sâp yan Yesuhât hoŋ bawalipŋe kâiân yâhâp manbin. Gârâmâ bukunenŋe âlâ, kutŋe Yurasi sâm, yâkŋe hotom uminiwi yeŋgât kunlipyeŋe yeŋgâlen ariop. ");
INSERT INTO spl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ari yuwu sâm âiyongop. “Yesu wosan tap yan dâiyekmâ arimune menomai yakât matŋe wuân nihinomai?” Sâmu sâwi. “Yakât hâmeŋeâmâ nenŋe kât nanŋe 30 gihinom.” Yawu sâm kât nanŋe ya waŋbi. ");
INSERT INTO spl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Waŋetâ miakmâ yakât kakŋan girawu otmâ lohotŋan menomaihât nâŋgâm manop. ");
INSERT INTO spl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Otmu Tihit tihit Hombaŋ ya kutŋe âlâmâ Natik Hombaŋ ya tâlâhumu nenŋe yuwu sâm Yesu âikuwin. “Natik Hombaŋ tâlâhuap yakât hândâhân lohimbi dondâŋe menduhuakmâ sot um nenomai. Yakât otmâ emet wosan ari sot umunŋe orowâk nenom?” ");
INSERT INTO spl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sâmunŋe sâop. “Yerusalem kapiân yâhâ lok âlâ mem tetem yuwu sâm ekunomai. “Nengât bawapinenŋaŋe yuwu yap. “Emelâk nâhât sâp tâlâhuap. Yakât otmâ nâŋe hoŋ bawalipne meyekmune gâhât emelan yâhâ menduhuakmâ sot um nenom.” Yawu yap.” Yawu sâm ekunomai.” Yesuŋe den yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Otmu nenŋe Yesuŋe sâop yawuâk menduhuakmâ sot newin. ");
INSERT INTO spl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Emet omoŋ otmu menduhuakmâ sot nem tatmunŋe yuwu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","“Yuwu sâmune nâŋgâŋet. Yeŋgâlen gâtŋe lok âlâŋe betnehen kioŋmâ kasalipne yeŋgât bâtyeŋan mem katnekbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yawu sâmu nâŋgâm biwinenŋaŋe umatŋe otmu yakât topŋe nâŋgâne sâm nenŋe ikŋiâk ikŋiâk yuwu sâm âikuwin. “Kutdâ, gâ nâhât me âlâhât yat?” ");
INSERT INTO spl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","24","Yawu sâm âikumunŋe yuwu sâm eknongop. “Anitâŋe sâmu kulemguwi yakât bonŋe nâhâlen tetemu nohoŋetâ mumbom yakât sâp tâlâhuap. Yakât otmuâmâ yeŋgâlen gâtŋe âlâŋe oto konohân nâ orop sot nendomait yâkŋe betnehen kioŋmâ kasalipne meyekmâ takawuap. Yawu otnihiwuap yakât matŋe hâmbâi umatŋe dondâ membuap. Yakât otmâ mâmâŋaŋe ki mem ga katbâp yamâ mem ga kalop yawu naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yawu sâmu yanâk Yurasiŋe âikuop. “Lok pato, den yat yu nâhât mon yat?” Sâmu sâop. “Nâ gâhât yan.” ");
INSERT INTO spl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Otmu sot nem tatbin yan Yesuŋe baŋga mem Anitâ mepaem motokmâ ningim yuwu sâm eknongop. “Yu mem neŋet. Yuâmâ nâhât sunumne yawu oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ningimu nemunŋe yaŋak wain to mem Anitâ yâhâpŋe mepaem gâim ningim yuwu sâm eknongop. “Yen to yu mem neŋet. ");
INSERT INTO spl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","To yuâmâ nâhât hep yawu oap. Gârâmâ nohoŋetâ hepne gamu mumbom Anitâŋe nâhât nâŋgâm den sâm kalop yakât bulâŋe tâŋ tâŋâk tetewuap. Yawu otmu lohimbi kerek yeŋgât tosayeŋe Anitâŋe pilâyiŋgiwuapgât mâtâp tetem heŋgeŋguwuap. ");
INSERT INTO spl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nâ sâp yiwereŋe wain to yu yen orowâk ki nem yâhâwom. Yawu gârâmâ yu nemunŋe ki pesuk yap. Hâmbâi Anitâŋe âlâkuâk hâŋgânnohomu âwurem gewom yanâmâ yen orowâk nem yâhânom.” ");
INSERT INTO spl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yawu sâm tiŋ pilâmu yapâ yahatmâ Anitâ mepaem kiki mewaŋgim ya pilâm Oliwa pumŋan yâhâwin. ");
INSERT INTO spl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mâtâwân yâhâm tatmunŋe yuwu sâm eknongop. “Anitâŋe emet inânŋan poropete âlâ den ekumu kulemguop ya yuwu tap. “Nâŋe sâmune lama yeŋgât amboyeŋe ya kuŋetâ mumbuap. Otmu yâk watmâ manmai ya hârok gem tiok taok otmâ arim kinnomai.” Yawu kulemguop tap. Den yakât bonŋe yu tetewe sâm oap. Yakât otmâ kasalipnaŋe taka menekŋetâ yen kerekŋe kiŋgityeŋahât otmâ gem tiok taok otmâ arinomai. ");
INSERT INTO spl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Menekmâ ari nohoŋetâ mumbom yamâ benŋe mumuŋambâ yahatbom. Mumuŋambâ yahatmâ Galilaia hânân ari mambotyiŋgim tatmune yen aksihâk ariŋetâ menduhuaknom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yawu sâmu Petoroŋe yuwu sâm ekuop. “Gâhât kasa takanomai yan yâkŋeâmâ kiŋgityeŋahât otmâ arinomai. Yâhâ nâmâ bia, nâ ki pilâhekmâ ariwomgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sâmu sâop. “Naŋgat. Gâŋe omoŋ yukâlâk nâhât “Ki nâŋgâwaŋgian,” sâwuat. Yawu sârâ kalimbuŋe otbuap yanâmâ gokorok isewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sâmu sâop. Nâmâ gâ orowâk tatdom. Yawu tetehihimu nâŋe gâ ki pilâhekmâ ariwom. Me kiŋgitnahât gurâ ki otbom. Nâŋe gâhât topgahât âinohoŋetâ ki kurihiwom. Me gohone sâm otnomai yan gurâ nâ orowâk tatmutŋe notgonomai.” Yawu sâop. Yawu sâmu nenŋe gurâ yâkŋe sâop yawuâk sâwin. ");
INSERT INTO spl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ari kapi âlâ, kutŋe Gesemane sâm, yan ariwin. Yan ari Yesuŋe yuwu sâm eknongop. “Yen yuân tatŋetâ nâŋe pereŋ pilâm ba awoŋ orop den tipiŋe alahure.” Yawu sâmu yan ge tatbin. ");
INSERT INTO spl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yan ge tatmunŋe Petoro, otmu Yeweri nanyâhâtŋe meyekmu yeŋiâk bawi. Ba kinmâ umatŋe tetewaŋgiwe sâm olop yakât nâŋgâmu biwiŋaŋe umatŋe otmu yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Yen yuân galem tatŋet. Hâkne biuk sâmu biwine umatŋe dondâ oap.” ");
INSERT INTO spl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yawu sâm ekyongom pereŋ pilâm ge pare im Anitâ ulitgum yuwu sâop. “O awoŋ, umatŋe tetenihiwe sâm oap yu nâŋgârâ ki teteâkgât naŋgan. Yawu gârâmâ nâhât ombe watmâ ki otbuat. Gike ombeheâk watmâ otbuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yawu sâm yahatmâ âwurem ba yekmu aman pâlâmŋe iŋetâ mândiyekmâ Petoro yuwu sâm ekuop. “Yen wongât aman pâlâmŋe iai? Nâ yiwereŋe pilâyekboman. Yakât pâlâmŋe ki otŋet. ");
INSERT INTO spl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Biwiyeŋeâmâ heweweŋ oap. Yâhâ wâtyeŋeâmâ houŋ sâmu aman iai. Yen lohotŋe otmâ pilânekmaihât golâek tatmâ Anitâ ulitguŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yawu sâm yâhâpŋe purik sâm ba Anitâ ulitgum sâop. “Awoŋ, sâp yiwereŋe umatŋe yu tetenihiwomap. Yakât mâtâp âlâ menihiwuatgât dop ki otbuap otmuâmâ naŋgat yawuâk teteâk. Gike ombeheâk watmâ otbuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yawu sâm yahatmâ âwurem ba hoŋ bawalipŋe yeksan mâne aman pâlâmŋe iwi. ");
INSERT INTO spl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yawu otŋetâ kalimbuŋe âwurem ba den sâop yawuâk sâm ulitguop. ");
INSERT INTO spl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Âwâŋe orop den otmutâ pesuk sâmu âwurem ba hoŋ bawalipŋe mândiyekmâ sâop. “Bâe, yen naŋgai me? Wongât aman pâlâmŋe im tai? Emelâk Anitâŋe yu otbomgât hâŋgânnohomu gewan. Yakât topŋe teteâkgât kasalipnaŋe menekmâ ari hilipnohonomai yakât sâp tâlâhuap. ");
INSERT INTO spl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bâiŋ, yen yahatmâ enda yekŋet. Nâhât den halop alahum mansai. Gârâmâ yeŋgâlen gâtŋe betnehen kioŋsapŋe taka kinsap. Yakât yahatŋetâ ba yekne.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yawu sâm eknongomu yanâk hotom uminiwi ya yeŋgât kunlipyeŋe otmu Yura nengât papatolipnenŋaŋe lok seseŋgâlâk hâŋgânyongoŋetâ bukunenŋe Yurasiŋe dâiyekmu Yesu mene sâm takawi. Takaŋetâ nen orop ahomaingâtbân nâŋgâm kapamgât wahap miakmâek takawi. ");
INSERT INTO spl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lok takawi ya Yurasiŋe kulem girawu otmu menomai yakât yuwu sâm ekyongop. “Yesu ya parahumune ekmâ yanâk ga menomai.” Yawu sâm ekyongom dâiyekmu takawi. ");
INSERT INTO spl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gotnenŋan takamâmâ kasa ya kinŋetâ Yurasiŋe Yesu gotŋan tâŋ tâŋâk ga parahum yuwu sâop. “O, patone, mandâ manman.” Yawu sâm parahuop. ");
INSERT INTO spl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yawu otmu Yesuŋe yuwu sâm ekuop. “O bukune, girawu nâŋgâm takat ya âlepŋe ot.” Yawu sâmu kasalipŋaŋe in yawu ga mewi. ");
INSERT INTO spl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Meŋetâ kinmu yanâk nengâlen gâtŋe âlâŋe yahatmâ tewetŋe mem hotom uminiwi ya yeŋgât kunyeŋahât hoŋ bawa ya ândâpŋe nombot topŋambâek kârâm hâreop. ");
INSERT INTO spl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kârâm hâremu Yesuŋe ekmu bâlemu yuwu sâm ekuop. “Ya otdâ bâleap. Yu oat yukât matŋe hâmbâi tewet yuŋahâk purik sâhihimapgât ya pilâ.” ");
INSERT INTO spl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gâ nâhât topne ki naŋgatgât yawu oat. Nâŋe âlepŋe awoŋne ekumune aŋelolipŋe kiŋgitŋe orowâkŋe tânohoŋetgât hâŋgânyongomu ge kasalipne yu yongom watyekŋetâ arinomaihât dop tap. ");
INSERT INTO spl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yawu gârâmâ awoŋ ekumune aŋelolipŋe hâŋgânyongomu yawu otbâiâke yamâ ikŋak âi sâm nihiop yakât mâtâp maŋguŋetâ bonŋe ki tetewuap. Yakât otmâ sâm nihiop ya ârândâŋ olâkgât naŋgan. Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yawu sâm kasalipŋe yuwu sâm ekyongop. “Yen unam tewet otmu kapamgât sâtŋe metŋe âlâlâ mem takai. Yeŋe nâhât lok bâleŋe sâm menekne sâm takai me? Me lok bâleŋe âlâ kune sâm takai? Ya ekmune bâleap. Hilâm ârândâŋ nâmâ Anitâhât opon kâmbukŋan yâhâ den kâsikum yiŋgim gaman. ");
INSERT INTO spl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yan bân menekbâi yamâ emet inânŋan Anitâŋe poropetelipŋe den ekyongomu kulemguwi yakât bulâŋe âun teteap.” Yawu sâmu ekmunŋe hâknenŋe biuk sâmu yahatmâ tiok taok otmâ arim kinbin. ");
INSERT INTO spl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","58","Nenâmâ kerehâk kiŋgitnenŋahât otmâ gem tiok taok otmâ arim kinmunŋe Petoroŋe ikŋiâk betyeŋehen tihâk watyekmâ ariop. Otmu hotom uminiwi ya yeŋgât kunyeŋe, kutŋe Kaipa sâm, yâkâlen Yesu mem ariwi. Mem ariwi sâp yanâmâ Mosehât girem den kâsikum ningiminiwi otmu Yura nengât kunlipnenŋaŋe menduhuakmâ kinbi. Menduhuakmâ kinŋetâ Petoro yâhâmâ emet ginŋan tembe lâuŋe emet yakât galem kinbi ya yeŋgât hohetyeŋan ari kinmâ den girawu hikunomai sâm yakât ândâp katmâ nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ândâp katmâ nâŋgâmu âi pâi tuhuwi. Otmu girawu tuhumunŋe muâkgât den golâ topŋe topŋe gahaem hakŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yawu otmâ lok dondâŋe den girawuân hâum sâŋetâ kunlipyeŋaŋe nâŋgâŋetâ ârândâŋ otbuap yakât pâpguwi. ");
INSERT INTO spl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Yawu gârâmâ hohetyeŋan gâtŋe lok yâhâp yaŋe yahatmâ emelâk Yesuŋe den sâop ya nâŋgâm hilipgum den imbiâk hakŋan sâowot. “Lok yuŋeâmâ yuwu sâmu nâŋgâwit. “Anitâhât opon kâmbukŋe emelâk tuhuwi yuâmâ nâ niniâk liakum yâhâpŋe hilâm kalimbu kâlehen tuhum maŋguwom. Lok âlâ me âlâŋe ki tânnohonomai.” Yawu sâop.” Yawu hakŋan sâmutâ Yesuŋe olotoŋâk kinop. ");
INSERT INTO spl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Olotoŋâk kinop yakât Kaipaŋe yahatmâ kinmâ Yesu yuwu sâm ekuop. “Gâ wongât otmâ den âlâlâ âihohomunŋe yakât matŋe ki kâpeksat? Yawu otdâ ekmunŋe ki ârândâŋ oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yawu sâmu benŋe Yesuŋe yâhâpŋe olotoŋâk kinop. Olotoŋâk kinmu witgum sâop. “Bâiŋ witgumâk âihohowe. Anitâ manman amboŋahât senŋan âihohowoman yukât matŋe sârâ nâŋgâne. Gâ Anitâŋe ikŋe nanŋe bulâŋe ya hâŋgângohomu ge yu mansat me bia? Sârâ nâŋgâne.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sâmu sâop. “Yu yat yakâ. Nâmâ Anitâŋe hâŋgânnohomu gewan. Yawu gârâmâ hâmbâi Anitâŋe wâtŋe nihim âlâkuâk hâŋgânnohomu elem kulewoŋboŋ kakŋambâ âwurem ge yeŋgât kunyeŋe tatmâ yâhâmbisâm. Sâp yan Anitâhât wâtŋe ya nâhâlen tetemu eknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","66","Yawu sâmu Kaipaŋe nâŋgâmu bâlemu yahatmâ ikŋe sâŋgum mem duhatmâ bukulipŋe yuwu sâm ekyongop. “Bâe, ikŋahât nâŋgâmu yahatmu Anitâhât kaweŋan kinbe sâm oap. Yuâmâ den kâmbukŋe hâliliŋe yap. Yakât girawu tuhunomgât naŋgai?” Yawu sâm âiyongop. Sâmu sâwi. “Kuŋetâ muâk,” yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yawu sâm kundenŋan tâpguwi. Tâpgum gâtŋaŋe sâŋgum âlâ mem senŋe sâhâm kâtâpguŋetâ kinop. Senŋe sâhâm kâtâpgum ândâpŋe huhuwi. Ândâpŋe huhum nombotŋaŋe yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Bâiŋ, ândâpge âlâŋe huhuap? Anitâŋe hâŋgânnohomu gewan sâmat. Ya bulâŋe sâmat otmuâmâ yiwereŋe âlâŋe ândâpge huhumu eksat yakât sârâ nâŋgâne.” Yawu sâm kum senŋan gem mem âlâlâ mâŋgâewi. ");
INSERT INTO spl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Otmu Petoroŋe emet ya hawiŋanâk kinmu hotom uminiwi ya yeŋgât lok kunyeŋahât hoŋ bawa imbi âlâŋe ekmâ yuwu sâm âikuop. “Gâmâ Yesu Galilaia amboŋe orop manŋetâ yekman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yawu sâmu lok dondâhâlâk kinbiŋe nekmâ nâŋgâmaihât Petoroŋe kurihiakmâ yuwu sâop. “Gâŋe den yat yakât ki naŋgan.” ");
INSERT INTO spl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yawu sâm pilâyekmâ endunâken ba kinmu imbi âlâŋe ekmâ lok yan kinbi ya yuwu sâm ekyongop. “Lok emet, lok yuâmâ Nasaret kapiân gâtŋe yâk orowâk manŋetâ yekman.” ");
INSERT INTO spl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yawu sâm ekyongomu sârereakmâ yuwu sâop. “Anitâhât senŋan kinmâ yuwu sâmune nâŋgâŋet. Nâ lok yakât ki nâŋgâwaŋgiman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sâmu sâwi. “Yesuâmâ Galilaia hânân gâtŋe naŋgain. Yâhâ gâ gurâ yawuâk Galilaia yeŋgât eŋgat ya sârâ naŋgain yukâ. Yakât otmâ gâmâ yâkât komolân gâtŋe geksain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sâŋetâ sârereakmâ sâop. “Bâiŋ, âlepŋe Anitâhât senŋan den membom otbuawâmâ yâkŋe matŋe nihiwuap. Lok sâm tai yuâmâ bulâŋanâk ki nâŋgâwaŋgian.” Yawu sâop. Yawu sâm oan mâne yanâk gokorok isiop. ");
INSERT INTO spl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gokorok isian mâne Yesuŋe emet inânŋan den ekuop ya nâŋgâmu teteop. “Gâŋe nâhât “ki nâŋgâwaŋgian” sârâ kalimbuŋe otmu yan gokorok isewuap.” Den ya nâŋgâmu tetemu biwiŋe ŋasinâk pato otmu pilâyekmâ ikŋiâk ba kinmâ hik ŋâik ŋâihâk isiop. ");
INSERT INTO spl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","2","Otmu emet haŋ sâmu yanâk hotom uminiwi ya yeŋgât kunlipyeŋe otmu Yura nengât kunlipnenŋaŋe Yesu muâkgât sâm den hikuwi. Yawu otmâ Yesu bâtŋan kum sâhâm dâim Roma yeŋgât kiap âlâ, kutŋe Pilato sâm, yâkât den sâsâ emetŋan ariwi. ");
INSERT INTO spl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Otmu bukunenŋe Yurasiŋe Yesu mumbuapgât den sâm hârewaŋgiwi yakât den pat nâŋgâmu bâleop. Nâŋgâmu bâlemu yâkŋe kât nanŋe 30 waŋbi ya mem sururuk sâm ari yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Otmune dondâ bâleap. Yesu yamâ tosaŋe bia yamâ nâŋe otmâ tâpikguwan. Yawu otmâ tosa umatŋe mian.” Sâmu sâwi. “Tosa amboŋe. Gikak heŋgeŋguwuat.” ");
INSERT INTO spl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yawu sâŋetâ nâŋgâmu bâlemu pilâyekmâ tewetsenŋe waŋbi ya mem ari opon kâmbukŋan yâhâ sorokenâk pilâmu giop. Pilâm gem sururuk sâm ari hiwawahop. ");
INSERT INTO spl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yâhâ hotom uminiwi yeŋgât kunlipyeŋaŋe tewetsenŋe pilâop ya mem yuwu sâwi. “Tewetsenŋe yuâmâ Yurasiŋe Yesu betŋehen kioŋop yakât hâmeŋe. Yawu gârâmâ yuŋe opon kâmbukŋahât pat sâm katmunŋe ki ârândâŋ otbuap. Yawu gârâmâ yuwu mon otnom? ");
INSERT INTO spl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yu mem lok âlâŋe amaŋ tuhumap yâkâlen hân puluhunom. Puluhum lok kâlepŋehembâ taka manmai ya yan hanyongombisâi.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yawu otmâ hân ya puluhuwi yakât kutŋe yuwu, “Hepŋak puluhuwi,” yawu kunbi. Sum yakât kutŋe yawuâk tap. ");
INSERT INTO spl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Otbi yakât bonŋe teteop yamâ emet inânŋan Anitâŋe sâmu poropete âlâ, kutŋe Yeremia sâm, yâkŋe kulemguop ya yuwu. “Isirae nengât kunlipnenŋaŋe lok âlâ muâkgât sâm hârewaŋgim yakât kât nanŋe 30 kasaŋe waŋbi. Tewetsenŋe waŋbi ya mem ari lok âlâ amaŋ tuhuminiop yâkâlen hân puluhunomai sâm Anitâŋe den eknohop.” Yawu sâm kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yâhâ hotom uminiwi otmu Yura nengât kunlipnenŋaŋe Yesu mem Pilatoŋe sâm hâreâkgât yâkâlen ari den âiân katbi. Katŋetâ tatmu Pilatoŋe yuwu sâm âikuop. “Yura yeŋgât lok kutdâ sâmai ya gâ me?” Yawu sâop. Sâmu sâop. “Oŋ, den bulâŋe yat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Otmu Yesu mem ariwi nombotŋaŋe yâkât hakŋan sâwi. Hakŋan sâŋetâ den matŋe ki sâop. ");
INSERT INTO spl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ki sâm olotoŋâk kinmu Pilatoŋe topŋe nâŋgâwe sâm Yesu yuwu sâm âikuop. “Girawu otmâ den sâm tai yakât matŋe ki kâpekyiŋgiat?” ");
INSERT INTO spl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yawu sâm âikumu den biaek kinop. Yawu kinop yakât ekmu sâtŋe olop. ");
INSERT INTO spl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","19","Otmu Pilatoŋe yuwu nâŋgâop. “Lohimbi dondâŋe Yesuhât nâŋgâŋetâ yahatmap. Yakât otmâ hotom umai ya yeŋgât kunlipyeŋaŋe nâŋgâŋetâ bâlemu yaŋak muâkgât sâm hârewaŋgim nâhâlen mem takai.” Yawu nâŋgâm eŋgat yâhâp otmâ kinmu yanâk imbiŋaŋe yuwu sâm den katmu takaop. “Nâ amanân awun eksan yakât topŋe yuwu. Yesu yamâ tosaŋe bia. Gârâmâ gâŋe ihilâk ki otbaŋgiwuat.” Den yawu sâm katmu takaop. Yâhâ Tihit tihit hombaŋ ârândâŋâk Pilatoŋe yuwu otminiop. Lok tosa otŋetâ pâi emetŋan katyekŋetâ tatminiwi yapâ gâtŋe âlâ me âlâhât lohimbiŋe nâŋgâŋetâ dopŋan otmu lok âlâ holaŋbuat sâminiwi ya holaŋyekmu geminiwi. Yakât otmâ Yesu me lok bâleŋe, kutŋe Yesu Barawa sâm, âlâ me âlâ holaŋmu gewuapgât nâŋgâm Pilatoŋe lohimbi ya yuwu sâm âiyongop. “Âlâ holaŋmune gewuap? Barawa me Yesu holaŋmune yeŋgâlen giâkgât naŋgai?” ");
INSERT INTO spl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yawu sâm âiyongomu hotom uminiwi ya yeŋgât kunlipyeŋe otmu Yura nengât kunlipnenŋaŋe lohimbi biwiyeŋan kioŋmâ yuwu sâwi. “Barawa holaŋdâ gemu Yesu kuŋetâ muâk,” sâŋet sâm eŋgatyeŋan gewi. ");
INSERT INTO spl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yâhâ Pilatoŋe yahatmâ kinmâ yuwu sâm âiyongop. “Yenâmâ âlâ holaŋmune giâkgât naŋgai.” Sâmu sâwi. “Barawa holaŋdâ giâkgât naŋgain.” Sâŋetâ sâop. ");
INSERT INTO spl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Yesu yuâmâ Anitâŋe hâŋgângumu giop sâmai yâkât girawu otbaŋgiwomgât naŋgai?” Sâmu ŋerekŋe berendeŋâk sâwi. “Yâk howanân kum kânâŋgâŋetâ muâk.” ");
INSERT INTO spl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sâŋetâ âiyongop. “Bâe, yuâmâ ki orotŋe. Wuân otmu bâleopgât yawu yai?” Yawu sâmu âlâkuâk yahatmâ sâwi. “Howanân kum kânâŋgâŋetâ muâkgât naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yawu sâm kunyeŋe kârikŋe otŋetâ kuk pato tetemap sâm Pilatoŋe yahatmâ kinmâ topyeŋe teteâkgât to osom katmâ senyeŋanâk bâtŋe piriakmâ ekyongop. “Yu otne sâm oai yamâ yeŋgât tosa. Yuŋe nâhât wahap ki oap. Yawu gârâmâ senyeŋanâk kinmâ to yu piriakmune neksai.” ");
INSERT INTO spl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sâmu sâwi. “Sâmunŋe kuŋetâ mumbuap yukât tosa yamâ nen otmu nengât sen tetem sambe otnomai ârândâŋ menenekbuap.” Yawu sâm hârewi. ");
INSERT INTO spl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yawu sâm hâreŋetâ Pilatoŋe sâmu Barawa ya holaŋetâ giop. Yawu otmâmâ tembe lâulipŋe ekyongomu Yesu mem kândâtŋe lawitŋetâ hepŋak kiŋ pisiliŋ sâop. Yawu otŋetâ Pilatoŋe hâŋgânyongomu howanân kuŋetâ muâkgât mem ariwi. ");
INSERT INTO spl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tembe lâulipŋaŋe Yesu mem ya pilâm emet âlâen katŋetâ talop. Yawu otmâ tembe lâu bukulipyeŋe nombotŋe meyekŋetâ gawi. ");
INSERT INTO spl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gam Yesuhât hâk katipŋe tuhum pilâwaŋgim hâk katipŋe kâkâlep, kuriŋ takop takop yamâ lok kutdâŋe mânuŋakmâ manminiwi yawuya ya mem mânuŋbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yawu otmâ tâk âlâ sâtŋe metŋe, hatman yawuyaŋe mem goŋgoŋgum lok papato yeŋgât ŋerendeŋ ya dop kum kunŋan kepeim âlihitbaŋgiwi. Âlihitbaŋgim kapam âlâ bâtŋe bonângen waŋetâ memu gotŋan ba senŋan gem giriŋbaŋgim yuwu sâm ekuwi. “Bâe, Yura yeŋgât lok kutdâ pato. Yakât otmâ torokatmâ mangât naŋgain.” Yawu sâm senŋan gewi. ");
INSERT INTO spl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Senŋan gem kundenŋan tâpguwi. Otmu kapam waŋbi yaŋak bâtŋan hindâm kunŋan lawitbi. ");
INSERT INTO spl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yawu otmâmâ hâk katipŋe kuriŋ ya mem tuhum pilâm ikŋe hâk katipŋe mânuŋbaŋgim yaŋak mem howanân kum kânâŋgâne sâm dâim ariwi. ");
INSERT INTO spl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ariwi yamâ ikŋahâk howanŋe lâuakmu ariwi yakât otmâ wâtŋe houŋ sâmu lok âlâ, kutŋe Simon sâm, yamâ Kirene gâtŋe ya mem tetem sâwaŋgiŋetâ Yesuhât howan ya tângum mem lâumu orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ari hân âlâengen, kutŋe Golihata sâm, yan ariwi. Kut yakât topŋeâmâ “Lok Kunŋe Hahitŋe,” yawu. ");
INSERT INTO spl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yan ari Yesuŋe hâhiwin dondâ nâŋgâmapgât wain to otmu to ŋasin bâleŋe ya orowâk menduhum gâim waŋetâ nemu ŋasinbaŋgimu ukum pilâop. ");
INSERT INTO spl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Otmu hâk katipŋe tuhum pilâmâmâ ikŋe howanân kum kânâŋgâŋetâ kinmu hâk katipŋe ya mem “Âlâŋe miakbuap?” sâm mem ketetmâ katbi. Mem ketetmâ katŋetâ tatmu pepa duhatmâ tipi tapi tuhum kutyeŋe ikŋiâk ikŋiâk kulemgum amaŋân mânuŋetâ giop. Mânuŋetâ gemu mem gulip malap tuhum yapâ pepa âlâ meŋetâ kut teteop yaŋe miahop. ");
INSERT INTO spl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yawu otmâ yakât kakŋan in ge tatmâ ekbi. ");
INSERT INTO spl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yawu otmâ howan yakât kunŋan yuwu kulemgum katbi. “Lok yu kutŋe Yesu. Yâhâmâ Yura yeŋgât lok kutdâ.” Yawu sâm kulemguwi. ");
INSERT INTO spl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Otmu sâp yanâk lok komborâ yâhâp yotgom lâum kânâŋgâyelekŋetâ nombot nombot kinowot. ");
INSERT INTO spl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Otmu lohimbi nombotŋe mâtâp ya watmâ howan hâlâŋmâ arim takawiŋe Yesu ekmâ lauyeŋe butelim yuwu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Gâŋe emelâk yuwu sârâ nâŋgâwin. “Opon kâmbukŋe yamâ nâŋe liakum hilâm kalimbu biwiŋan tuhum maŋguwom,” yawu sârâ nâŋgâwin. Yawu gârâmâ howanâmbâ pek sâm kâpehakmâ ge. Gerâ yanâmâ nenŋe “O, Anitâhât nanŋe bulâŋe” sânom.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yawu sâŋetâ benŋe hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum ningiminiwiŋe senŋan gem lohimbi kinbi ya yuwu sâm ekyongowi. ");
INSERT INTO spl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Lok yuâmâ Yura nengât lok kutdâ sâmai. Yuŋe lok nombotŋe tânyongomu ekmain. Yâhâ girawu otmuâmâ ikŋeâmâ ki tânahom howanâmbâ kâpehakmâ giap? Kâpehakmâ gemu eknom otmuâmâ biwinenŋe yâkâlen katmâ tem lâuwaŋginom. Yâhâ ki kâpehakmâ gewuawâmâ yuwu sânom. “Âo, lok yuâmâ imbiâk otmap.” Yawu sânom. ");
INSERT INTO spl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yawu otmâmâ ikŋak yuwu sâop. “Nâmâ Anitâhât nanŋe bulâŋe. Biwine yâkâlenâk kinsap.” Ikŋahât yawu sâop. Gârâmâ bâiŋ Anitâŋe tângumu howanâmbâ kâpehakmâ gemu ekne.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yawu sâm senŋan gem kinŋetâ yanâk lok bâleŋe yotgom kânâŋgâyelekŋetâ nombot nombot kinowot yâku yawuâk senŋan giowot. ");
INSERT INTO spl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Otmu hilâm kârikŋan, 12 kilok olop yan Anitâŋe nâŋgâmu emetsenŋe bok sâmu omoŋ sahahop. ");
INSERT INTO spl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Omoŋ sahakmâ yapâ ari emetsâpŋe 3 kilok otmu emet laŋinŋe âlâkuâk pilâop. Yawu otmu Yesuŋe kândâtŋe kuwihakmâ Yura nengât denân yuwu sâm halahuop. “Eli, Eli lama sapaktani.” Yawu sâop. Sâop yamâ topŋe yuwu. “O, Awoŋ, wongât nâŋgâm kâkâsuk otmâ betnihiat?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Otmu lok nombotŋaŋe nâŋgâm tâpikgum yuwu sâwi. “Eliahât mon sâm ahom kuakmâ tap.” ");
INSERT INTO spl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yawu sâŋetâ hohetyeŋan gâtŋe âlâŋe sururuk sâm ari sâŋgum âlâ mem nak bâtbâtŋe potonŋan pâŋ pâŋ kepeim wain to bâleŋe yan katmâ mem yâhâ Yesuŋe niâkgât lauŋan kalop. ");
INSERT INTO spl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yawu otmu bukulipŋaŋe yuwu sâm ekuwi. “Pilâ. Eliaŋe himbimâmbâ ge tânguâkgât nâŋgâm kutŋe kunsap mon? Pilârâ in ekne.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yawu sâm kinŋetâ Yesuŋe kârikŋeâk halahum yaŋak bâiŋe kambiamŋe tok sâmu muop. ");
INSERT INTO spl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Otmu emelâk lohimbi inŋaŋe opon kâmbukŋe yakât biwiŋe ekmai sâm sâŋgum kâlep pato hikuŋetâ ya kâtâpguminiop. Sâŋgum yaŋe pâŋambâek tok sâm hâreakmâ nombot nombot otmu tetekŋan olop. Yawu otmu mososoŋ pato miop. ");
INSERT INTO spl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mososoŋ pato memu yan hân orotok sâmu lohimbi nombotŋaŋe emelâk Anitâhât tem lâum manminiwi ya yeŋgât sum aŋ sâm kinmu pindilakmâ yahatbi. ");
INSERT INTO spl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sumâmbâ pindilakmâ yahatmâ manbi yaŋe ari Yesuŋe mumuŋambâ yahalop yanâmâ Yerusalem kapiân yâhâŋetâ yan kapi ambolipŋe orowâk eŋakbi. ");
INSERT INTO spl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yesu muop sâp yanâmâ tembe lâu hâlâŋmâ kinbiŋe mososoŋ pato miowân kulem âlâlâ tetemu ekŋetâ âlâ kândâkdâ otmu yuwu sâwi. “Lok yuâmâ bulâŋanâk Anitâhât nanŋe.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Otmu imbi nombotŋe yan kinbi yâhâmâ Galilaia ambolipŋe. Yâkŋeâmâ Yesuhât hoŋ baminiwi yamâ kutyeŋe yuwu. ");
INSERT INTO spl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Âlâmâ Maria Matala kapiân gâtŋe, âlâmâ Mariahât nambeŋe Yakowo yet Yose mâmâyetŋe, yâhâ âlâmâ Yoane yet Yakowo yâk yetgât mâmâyetŋe. ");
INSERT INTO spl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Emet ŋiŋ sâmu yan lok âlâ, kutŋe Yosep sâm, yâhâmâ Arimata kapi amboŋe. Yâkât iri sikumŋe pato tatbaŋgiop. Otmu yâkŋe Yesuhâlen biwiŋaŋe kepeim manop. ");
INSERT INTO spl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Lok yaŋe Yesu lâum ari hanguwe sâm Pilatohâlen ari tetewaŋgiop. Tetewaŋgimu lauŋan mem tembe lâulipŋe hâŋgânyongomu ari howanâmbâ Yesu mem waŋbi. ");
INSERT INTO spl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Mem waŋetâ bukulipŋe orop Yesu lâum ari kât mâtâpŋe âlâ dikin yawuya emelâk Yosepŋe yan hannohonomai sâmu nanlipŋaŋe kât mâtâpŋe kusânmâ mem tiŋgâloŋetâ kinop ya lâum ariwi. Otmu sâŋgum kaok âiŋe yaŋe katipgum kâlehen lâum ba katŋetâ talop. Katŋetâ tatmu kât âlâ lâum hâpunŋetâ ba mâtâpŋe ya maŋguop. ");
INSERT INTO spl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Otmu imbi yâhâp, Maria Matala kapi amboŋe otmu nambeŋe Yakowo yet Yose mâmâyetŋaŋe yan ge tatmâ we bâle nâŋgâm talowot. ");
INSERT INTO spl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Otmu emet haŋ sâmu, tatmâ nâŋgâminiwin sâp yakât omoŋânâk hotom uminiwi yeŋgât kunlipyeŋe otmu Parisaio yaŋe Pilatohâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ari yuwu sâm ekuwi. “Patonenŋe, den tipiŋe sâmunŋe nâŋgâ. Yesu lok perâk yaŋe emelâk den âlâ yuwu sâop ya naŋgat. “Nâ nohoŋetâ mum hilâm kalimbu hân kâlehen im yapâ mumuŋambâ yahatbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ya ki yahatbuap yawu naŋgain. Yawu gârâmâ hoŋ bawalipŋaŋe lâum ari âlâengen misiŋgutŋetâ tatmu den imbiâk yuwu sâm lohimbi kâityongonomai. “Yâhâmâ emelâk mumuŋambâ yahatsap.” Yawu sâm kâityongom aŋgoân yakât nâŋgâŋetâ yahalop ya witgum torokatŋetâ umatŋe topŋe topŋe teteningiwuap. Yâhâ yawu otmaihât gâŋe tembe lâu nombotŋe katyekdâ ari sum yakât galemŋe kinŋetâ hilâm kalimbu pesuk sâekgât naŋgain.” Yawu sâm ekuwi. ");
INSERT INTO spl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Sâŋetâ sâop. “Bâiŋ nâhât tembe lâu meyekŋetâ ari sum galemgum kinnomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yawu sâmu tembe lâulipŋe meyekmâ sumângen ariwi. Ari kât hâpunmu mâtâpŋe maŋguop ya ekmâ deŋgop kutakum mem ginŋan katŋetâ merakiop. Yawu otmâ Yesuhât bukulipŋaŋe tuhum gik beretek pilâm kâlehen yâhâmaihât Sisahât towat deŋgowân katbi. Deŋgowân katmâ tembe lâu galem katyekŋetâ kinŋetâ âwurewi. ");
INSERT INTO spl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Emet haŋ sâmu yanâk Maria, Matala kapiân gâtŋe otmu nambeŋe orowâk sumângen ariowot. ");
INSERT INTO spl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Arimutâ yanâk mososoŋ pato memu aŋelo âlâ hâk katipŋe kaok bolaŋ bolaŋ yaŋe himbimâmbâ pârâk sânsânâk giop. Ge kât pato âlâ Yosep bukulipŋaŋe lâum hâpunŋetâ ba sum mâtâpŋe maŋguop ya yâkŋe lâum hâpunmâ pilâm kakŋan yâhâ talop. ");
INSERT INTO spl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Otmu aŋelo yakât kundenŋaŋe laŋinŋe dondâek pilâop. ");
INSERT INTO spl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kât pat kakŋan ge tatmu ekmâ tembe lâu yaŋe umutyeŋe arimu kâi bâtyeŋe sân sân sâm derepyongop. ");
INSERT INTO spl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yawu otmâ aŋeloŋe imbi yâhâp yuwu sâm ekyotgop. “Yet kiŋgityetŋahât ki otset. Yetŋe Yesu howanân kuwi ya ekde sâm takawot ya naŋgan. ");
INSERT INTO spl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yâhâmâ yuân ki tap. Emelâk mumuŋambâ yahatbom sâop yawuâk otmâ yahatmâ arap. ");
INSERT INTO spl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yakât otmâ kâlehen yâhâ Yesuhât welâm ekmâ nâŋgâm in yawu âwurem ari hoŋ bawalipŋe yuwu sâm ekyongoromawot. “Kutdânenŋaŋe emelâk mumuŋambâ yahatmâ Galilaia hânângen ari tap. Yawu gârâmâ yen yawuâk ariŋetâ penaŋginomai.” Yawu sâm ekyongoromawot.” ");
INSERT INTO spl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yawu sâmu nâŋgâm koahowot yamâ biwiyetŋe heroŋe pato nâŋgâowot. Yawu otmâ ya pilâm sururuk sâm hoŋ bawalipŋe yeŋgâlen ariowot. ");
INSERT INTO spl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Arimutâ Yesuŋe mâtâwân teteyitgim yuwu sâop. “Wa, imbi yâhâp.” Yawu sâmu koahowot yamâ ekmâ nâŋgâm mepa saŋgan otbaŋgiowot. ");
INSERT INTO spl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yawu otbaŋgimutâ yuwu sâop. “Yet ki nâŋgâm koakset. Yerâmâ sururuk sâm hoŋ bawalipne ari ekyongomutâmâ Galilaia hânân ari mambotnihinomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Yawu sâm ekyotgomu mâtâwân arim tatmutâ tembe lâu sum galemŋe kinbiŋe sururuk sâm ari kapi patoen yâhâ hotom uminiwi yeŋgât kunlipyeŋe kulem teteop yakât ekyongowi. ");
INSERT INTO spl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yakât ekyongoŋetâ opon kâmbukŋahât galemlipyeŋe orowâk menduhuakbi. Menduhuakmâ den hikum tembe lâu yaŋe Yesuhât sum galem kinbi ya tewetsenŋe hâmeŋe pato yiŋgim “den golâ yuwu sânomai,” sâm eŋgatyeŋan gewi. ");
INSERT INTO spl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Nen omoŋ derep kâmbukŋan aman pâlâmŋe imunŋe Yesu hoŋ bawalipŋaŋe tihâk taka lâum âlâengen ari hanguai.” Yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yawu gârâmâ Pilatoŋe den yu nâŋgâm hilipyongomapgât nenŋe sârereyekmâ topŋe yu kurihinom. Yakât ki nâŋgâm ketet otnomai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yawu sâm hâmeŋe yiŋgiŋetâ miakmâ sâwi yawu otbi. Yâhâ den golâ yamâ sâm haok tuhum alahum ariwi. Yakât otmâ sâp yiwereŋe yu Yura kapi ambolipŋaŋe den yukât yawuâk alahum manmai. ");
INSERT INTO spl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Otmu yakât kakŋan nen hoŋ bawalipŋe kâiân konok Galilaia hânân ariwin. Ari Yesuŋe pumŋe âlâ yan menduhuaknom sâop yan yâhâ menduhuakbin. ");
INSERT INTO spl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Menduhuakmâ kinmunŋe Yesu teteningimu ekmâ biwi hero pato nâŋgâm mepaewin. Yawu gârâmâ lohimbi nombotŋaŋe ekmâ eŋgat yâhâp otbi. ");
INSERT INTO spl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yâhâ Yesuŋe gotnenŋan ga kinmâ yuwu sâm eknongop. “Anitâ Awoŋnaŋe mâmâŋe otnihimu yâkât wâtŋan kinmâ himbimân gâtŋe me hânân gâtŋe, ehekŋe ki ehekŋe kerek yeŋgât kunyeŋe tatmâ yâhâmbisâm. ");
INSERT INTO spl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yawu gârâmâ den kâsikum yiŋgim gan yu mem hânŋan kulemŋan ari lohimbi kâsikum yiŋgiŋetâ nâhâlen biwiyeŋaŋe kepeim mannomai. Yawu gârâmâ Awoŋne otmu nâ otmu Wâtgât mâmâŋahât Heak nenâmâ konohâk oain. Yawu tatmain yakât yeŋe nengât kulân lohimbi toen mem katyekŋetâ nenŋe tihityeŋe otmâ yâhânom. ");
INSERT INTO spl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Otmu nâŋe yen orowâk manmâ den kâsikum yiŋgim gan ya kerehâk kâsikum yiŋgiŋetâ biwiyeŋaŋe tiŋâk lâum mannomai. Otmu sâp ârândâŋ mâmâŋe otyiŋgimune nâ orop biwiyeŋaŋe kepeiakmâ konohâk otmâ mannomai. Otmu sâp pesuk sâwuap yanâmâ âwurem gemune penaŋgiaknom.” Yawu sâm den bâiŋe eknongop. Bâiŋ, den pesuk yap. ");
INSERT INTO spl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Anitâhât nanŋe Yesu Kiristo yâkât den pat âlepŋe yakât topŋe ya yuwu. ");
INSERT INTO spl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Poropete âlâ, kutŋe Yesaia sâm, Anitâŋe yuwu sâm ekumu kulemguop. “Anitâŋe nanŋe yuwu sâm ekuop. “Nine hoŋ bawa âlâ ekum hâŋgângumune kulet sâm ari mâtâp meŋgihiwuap.” Yawu sâm nanŋe ekuop.” ");
INSERT INTO spl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yawu sâmâmâ torokatmâ mâtâp mewaŋgiwuap yâkât yuwu sâop. “Lok ki manmaiângen, lok âlâ yan ari manbuap. Lohimbi yâkâlen takanomai ya yuwu sâm ekyongowuap. “Lok kutdâhât mâtâp ya mem pitiŋet. Otmu mâtâp mewaŋgiŋet. Otmu uk sâm huruŋ sâm, pumŋe lauŋe yamâ kum kilikmâ mem ârândâŋ merândâŋ tuhuŋetâ ya talâk.” Yawu sâm ekyongop.” Yesaiaŋe den yawu kulemguop tap yakât bulâŋe yamâ Yoanehâlen teteop. ");
INSERT INTO spl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yoaneŋe lohimbi toen katyekbe sâm yakât topŋe katmâ yahatmâ lok ki manmaiângen ari manop. Yaken ari manmâ lohimbi dondâŋe yâk ekne sâm ariŋetâ yuwu sâm ekyongop. “Orotmemeyeŋe kiŋgoŋ âlâlâ otmâ mansai ya kerek betbaŋgiŋetâmâ toen katyekbom. Toen katyekmune Anitâŋe tosayeŋe pilâyiŋgiwuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yawu sâmu ya nâŋgâm hân pato âlâ, kutŋe Yuraia sâm, ya ambolipŋe otmu kapi âlâ, kutŋe Yerusalem sâm, ya ambolipŋe kiŋgitŋe orowâkŋe yâkâlen ari orotmemeyeŋe bâleŋe ya kerehâk sâm teteŋetâ Yoran toen katyehop. ");
INSERT INTO spl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yâhâ Yoaneŋe hâk katipŋe yamâ soŋgo âlâ, kutŋe kamele sâm, yakât somotŋaŋe mendeŋmâ ya kepeiakmâ manminiop. Otmu kamele hâkŋaŋe let yawu pâŋan sâhâm kuratguahop. Otmu dopon, neŋgopdâ, me goŋgaraŋ yawuya nem manminiop. ");
INSERT INTO spl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yawu manmâ lohimbi yuwu sâm ekyongop. “Lok âlâ nâhât betnehen taka mansap. Yâhâmâ lok kutdâ otmu wâtŋe pato tatbaŋgiap. Nâmâ lok tâŋât, lok in yawuya. Yawu gârâmâ nâŋe yâkât itâkat kâpekmâ golewaŋgiwomgât dop ki tap. Otmu tânguwomgât dop gurâ ki tap. Nâŋeâmâ yâkât amutgen manmâ yâhâwom. ");
INSERT INTO spl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Otmu yeŋe orotmemeyeŋe bâleŋe betbaŋgiŋetâmâ toen katyekbom. Yâhâ biwiyeŋe yâkâlen katmâ mannomai yanâmâ Anitâŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otyiŋgiwuap. Mâmâŋe otyiŋgimu manman bulâŋe mannomai.” Yoaneŋe Kutdâhât nâŋgâm yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Otmu sâp yan Yesuŋe kapi âlâ, kutŋe Nasaret sâm, Galilaia hânân tap yan manop. Hilâm âlâen kapi ya pilâm Yoane ekbe sâm Yoran to ginŋehen ariop. Yan arimu Yoaneŋe mem toen kalop. ");
INSERT INTO spl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Toen mem kalop sâp yanâk himbim pâroŋ sâmu Anitâhât Wâtgât mâmâŋahât Heakŋe kembâ hâtgum ge Yesu mâmâŋe otbaŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Giop yanâk himbimâmbâ Anitâŋe yuwu sâop. “Gâ nine nanne kambiamne. Nâ biwinaŋe gâhâlâk nâŋgâm kepeihekman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Otmu yakât kakŋan Anitâhât Wâtgât mâmâŋahât Heakŋe Yesu hâŋgângumu hewukŋe kârikŋe lok ki manmaiângen ariop. ");
INSERT INTO spl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yan ari manmu hilâm 40 pesuk sâop. Sâp yan weke bâleŋe yeŋgât kunyeŋe, kutŋe Satan sâm, yâkŋe Yesuhât biwiŋahât topŋe ekmâ nâŋgâwe sâm olop. Yawu otmu yakât kakŋan Anitâŋe aŋelolipŋe hâŋgânyongomu ge Yesuhât tihitŋe otmâ tânguwi. ");
INSERT INTO spl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yawu otmâ yakât kakŋan Yoane mem pâi emetŋan katŋetâ talop yakât den pat Yesuŋe nâŋgâop. Ya nâŋgâmâmâ nep topŋe katbe sâm âwurem Galilaia hânângen ariop. Ari Anitâŋe tihitnenŋe otmap yakât den pat yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Anitâŋe tihitnenŋe otbe sâm oap. Yakât otmâmâ yeŋe orotmemeyeŋe bâleŋe betbaŋgim den pat âlepŋe ekyongoan yukâlâk nâŋgâm mem mete tuhum manŋet.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Den pat ya ekyongom yâhâm gem Galilaia deŋgân pato yakât ginŋan ari imi ata yâhâp yelehop. Kutyetŋe Anderea yet Simon. Yâhâmâ iŋan mem dâire sâm deŋgân tânâmŋan ba iŋan itâŋe pilâm kinowot. Pilâm kinmutâ yelekmâ yuwu sâm ekyotgop. ");
INSERT INTO spl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","“Yerâmâ nâhâlen ga torokatset. Yiwereŋe iŋan dâim mansawot. Gârâmâ nâŋe meyelekmune nâhât wâtnan kinmâ lok dâiyekmutâ nine komolân torokatnomai.” Yawu sâm ekyotgop. ");
INSERT INTO spl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yawu sâmu yanâk senŋe âlâlâ yetŋe pilâm yâkâlen torokatmutâ orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yapâ ari lok âlâ, kutŋe Yeweraio sâm, yâkât nanyâhâtŋe, kutyetŋe Yakowo yet Yoane orowâk kinŋetâ yehop. Otmu Yeweraioŋe âi lok meyekmu orowâk waŋgaen tatmâ iŋan itâŋe hâreahop ya gârem tatbi. Gârem tatŋetâ yekmâ yan nanyâhâtŋe yotgonop. ");
INSERT INTO spl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yotgonmu nâŋgâm âwâyetŋe otmu âi loklipŋe pilâyekmâ Yesuhâlen torokatmutâ orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Otmâ ya pilâm Kapanaum kapi yan ari manbi. Ari manŋetâ Yura nengât tatmâ nâŋgâ nâŋgâ sâp yan Yesuŋe miti emetŋan kapi ambolipŋe orowâk menduhuakŋetâ Anitâhât topŋe sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ekyongomu nâŋgâŋetâ bonŋe otmu biwiyeŋaŋe heroŋe otmâ yuwu sâwi. “Mosehât girem den kâsikum ningimaiŋe den sâmai ya nâŋgâmunŋe porap otmap. Yâhâ lok yuŋeâmâ den eknongoap yu nâŋgâmunŋe âlâ kândâkdâ oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yawu sâm kinŋetâ lok âlâ weke bâleŋaŋe mem mâŋgâemu manminiop yaŋe miti emetŋan yâhâop. Yâhâmu weke bâleŋaŋe biwi nâŋgân nâŋgânŋe mem purik pilâmu kârikŋan halahum yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Bâe, Yesu Nasaret amboŋe. Gâ wongât nâhâlen takat? Hilipnohowe sâm takat me? Gâhât topge naŋgan. Gâmâ, Anitâhât nanŋe bulâŋe mansat. Otmu Anitâŋe hâŋgângohomu bukulipne orowâk hilipnongowe sâm gion.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yawu sâmu yuwu sâm sâwaŋgiop. “Kâmbukŋe. Gâ gaiakmâ ba ari.” ");
INSERT INTO spl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sâmu weke bâleŋe yaŋe gaiakmâ ba arimu lok ya senŋe gâwâŋ gâwâŋ sâmu lauŋe barakŋaŋak pato otmâ ge iop. ");
INSERT INTO spl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yawu otmâ ge imu lohimbi miti emetŋan tatbiŋe ekŋetâ sâtŋe otmu yuwu sâm alahuwi. “Bâe, girawu? Ki orotŋe oap. Wâtŋe pato tatbaŋgiap yakât otmâ weke bâleŋe sâwaŋgimu denŋe lâum gaiakmâ ba arap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yâkât den pat ya sâŋetâ Galilaia hân nombot nombot huhum liŋgarakmâ ariop. ");
INSERT INTO spl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesuŋe miti emetŋambâ gem Yakowo yet Yoane meyelekmu Simon yet Anderea yetgât emelan yâhâwi. Otmu Simon hewunŋe hâkŋe kâlâp otmu im talop. ");
INSERT INTO spl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yesuŋe kâlehen yâhâmu emelan tatbiŋe mesek kuop yakât topŋe ekuwi. ");
INSERT INTO spl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ekuŋetâ mândemu yahatmu yanâk hâkŋe sânduk sâop. Hâkŋe sânduk sâmu emetsenŋe purik sâowân sot um yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Sot um yiŋgimu nem tatŋetâ omoŋ olop. Omoŋ otmu yan kapi ya ambolipŋaŋe lohimbi kundat yongop otmu weke bâleŋaŋe mâŋgâeyekmu manminiwi ya meyekmâ ari emet yakât gotŋanâk menduhuakmâ kinbi. ");
INSERT INTO spl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Menduhuakmâ kinŋetâ Yesuŋe kundat topŋe topŋe teteyiŋgiop ya sâmu âlepŋe otbi. Otmu weke bâleŋaŋe mâŋgâeyehop ya gurâ watyekmu gaiakmâ ariwi. Watyehop yanâmâ Yesuhât topŋe ekmâ nâŋgâwi. Ya lohimbi sâm tetem ekyongoŋetâ nâŋgâmai sâm kuyiŋgiop. Otmu omoŋ sâmu kapi yan iwi. ");
INSERT INTO spl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Otmu emet eŋgatŋe nâŋgâm Yesuŋe yahatmâ kapi ya pilâm lok biaengen ari Anitâ orop den alahuowot. ");
INSERT INTO spl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Alahum tatmutâ Simon bukulipŋe orop yahatmâ pâinŋetâ biatmu yuwu sâwi. “Yu wosaken arap?” Yawu sâm pâinmâ kapi ya pilâm ari mem tetewi. ");
INSERT INTO spl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ari ekmâ yuwu sâm ekuwi. “Kapi ambolipŋaŋe taka pâingeksai. Yakât âwurem bane.” ");
INSERT INTO spl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yawu sâŋetâ yuwu sâm ekyongop. “Yu hâlâŋmâ kapi tatmâ arai yâkŋe yawuâk Anitâhât topŋe nâŋgâŋetâ keterahâkgât gewan. Yakât otmuâmâ pilâyekmâ kapi nombotŋe yeŋgâlen arinehât naŋgan.” Yawu ekyongom meyekmu ariwi. ");
INSERT INTO spl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Meyekmâ ari Galilaia hânân kapi tipi tapi tatmâ arap yakât ambolipŋaŋe den pat âlepŋe nâŋgâŋetgât miti emetŋe ârândâŋ yâhâm gem ekyongop. Otmu weke bâleŋaŋe lohimbi mâŋgâeyekbi ya gurâ kerek watyehop. ");
INSERT INTO spl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Otmu sâp yan lok âlâ hâk bâle tetewaŋgimu manopŋe Yesu ekmâ gotŋan ba yuwu sâm ekuop. “Gâŋe sârâ kundat topŋe topŋe biatningiwuapgât dop tap. Yawu sâŋetâ naŋgan. Yakât otmâ âlepŋe otbomgât nâŋgâwuat yamâ âlepŋe otbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yawu sâmu Yesuŋe weŋe nâŋgâm ekuop. “Nâŋgâhihian. Âlepŋe walipgohomune hâk bâle ya biatgihiâk.” ");
INSERT INTO spl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yawu sâm walipgumu biatbaŋgimu âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yawu otmu yuwu sâm ekum hâŋgânguop. ");
INSERT INTO spl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Gâ otgihian yukât den pat bukulipge ki ekyongowuat. Hotom umai yeŋgâlen konok arirâ hâkge eknomai. Yawu otmâ yan Moseŋe hotom u uhât girem den kulemguop ya lâum Anitâhât hotom umbuat. Hotom umbuat ya ekmâmâ lohimbiŋe hâk bâle biatgihiap yukât topŋe nâŋgânomai.” ");
INSERT INTO spl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yawu ekum hâŋgângumu ari iliwetmâ den pat ya sâm haok tuhuop. Sâm haok tuhumu lohimbi dondâŋe nâŋgâwi. Yakât otmuâmâ lohimbi kiŋgitŋe orowâkŋe Yesuŋe tânyongoâkgât pawarak guwarak otmaihât yaŋak Yesuŋe kapi tete ki yâhâm giop. Otmu yaŋak kapi ya pilâm lok ki manmaiângen ari manop. Lok ki manmaiângen manop yakât patŋe nâŋgâm lohimbi dondâŋe ari mem tetewi. Ari mem teteŋetâmâ mem heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesuŋe tipiŋe tatmâ âwurem Kapanaum kapiân ariop. Ari emetŋan yâhâop. Emetŋan yâhâop yakât den pat ya kapi ambolipŋaŋe nâŋgâm yâkât emelan ari titâkuwi. ");
INSERT INTO spl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ari titâkuŋetâmâ kawe biatmu nombotŋe emet umbiŋan kinmâ ândâp katbi. Yawu otŋetâ den pat âlepŋe ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ekyongom tatmu yanâk lok pareŋe âlâ talop yâkât bukulipŋe imbât yaŋe Yesuŋe mem kuwihâk sâm mem gerelân katmâ yâkâlen lâum tohowi. ");
INSERT INTO spl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lâum tohowi yamâ lohimbi dondâŋe emet umbiŋan kinmâ mâtâp maŋguyiŋgiwi. Mâtâp maŋguyiŋgiŋetâ yakât otmâ yâk yeŋgâlen hâum pâpgum “Girawu tuhune tuhune?” otmâ mâtâpgât pâinbi. Mâtâpgât pâinmâ emet gimbâŋan getek getek lâum yâhâwi. Yâhâ emet gimbâŋe mem kusatmâ mem katŋetâ Yesuhât gotŋan giop. ");
INSERT INTO spl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Otmu Yesuhâlen biwiyeŋaŋe kepeiwi yakât topŋe ekmâ lok pareŋe ya yuwu sâm ekuop. Anitâŋe tosahe yiwereŋe pilâhihiap.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yawu sâm ekumu Mosehât girem den kâsikum ningiminiwi yaŋe den sâop ya nâŋgâŋetâ bâlemu biwiyeŋaŋe yuwu nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Anitâ ikŋak otmapgât dop. Yâkŋe konok tosanenŋe pilâningimap. Gârâmâ lok yuŋeâmâ Anitâ mem ge katmâ wangiwe sâm oap. Yamâ ekmunŋe bâleap. Yawu sâm Yesuhât nâŋgâŋetâ bâleop. ");
INSERT INTO spl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nâŋgâŋetâ bâlemu biwiyeŋe ekmâ yuwu sâm ekyongop. “Yeŋe nâ nekŋetâ lok bâleŋe otmune biwiyeŋaŋe yawu naŋgai. Yakât nâŋgâmune ki ârândâŋ oap. Yakât otmâ yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wuân âi tuhumune ekŋetâ dopŋan otbuap? Yuwu mon sâm ekuwom. “Nâŋe tosahe pilâhihian.” Yawu sâwom me? Me “Gâ getek yahatmâ geretge lâuakmâ ari,” sâwom? ");
INSERT INTO spl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yakât nine topne yuwu sâmune nâŋgâŋet. Nâ Anitâŋe hâŋgânnohomu gewangât tosayeŋe haoŋmâ pilâyiŋgim mansan. Anitâŋe nep sâm nihiop yukât topŋe ekmâ nâŋgâm heŋgeŋguŋetgât yu otbe.” ");
INSERT INTO spl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Yawu sâm ekyongom yaŋak lok pareŋe ya yuwu sâm ekuop. “Gâ yahatmâ geretge lâuakmâ emetgan ari.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yawu sâmu senyeŋanâk yahatmâ geretŋe lâuakmâ emetŋehen ariop. Arimu lohimbi hâlâŋmâ kinbiŋe Yesuŋe Anitâhât wâtŋan kinmâ nep miop ya ekŋetâ âlâ kândâkdâ otmu yuwu sâwi. “Lok yuwuyaek âlâ ki ekmain.Yâhâ yiwereŋe puwâk otmu eksain.” Yawu sâm Anitâ mepaewi. ");
INSERT INTO spl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Otmu hilâm âlâen Yesuŋe Kapanaum kapi ya pilâm Galilaia deŋgân ginŋehen ariop. Arimu lohimbi dondâŋe denŋe nâŋgâne sâm kapiyeŋe pilâm watmâ ariwi. Watmâ ari penewaŋgiŋetâ Anitâhât topŋe ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ekyongom pesuk pilâmu itoŋ galoŋ otŋetâ kapiân âwurem ariop. Ari mâtâwânâk Alipaio nanŋe, kutŋe Lewi sâm, yâkŋeâmâ takesi membe sâm tewetsenŋe emetŋan tatmu ehop. Tatmu ekmâ yuwu sâm ekuop. “Nâhâlen torokatdâ orowâk mandehât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yawu sâmu Lewiŋe tewetsenŋe meminiop nep ya pilâm yahatmâ Yesuhâlen torokatmu orowâk ariowot. Orowâk ari Lewihât emelan yâhâmutâ Yesu hoŋ bawalipŋaŋe peneyitgiŋetâ orowâk tatmâ den alahuwi. Den alahum tatŋetâ Lewihât bukulipŋe otmu lok nombotŋe Mosehât girem den ki lâum manminiwiŋe Yesuhât den nâŋgâne sâm emelan yâhâŋetâ orowâk tatmâ sot um newi. ");
INSERT INTO spl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nem tatŋetâ Parisaio nombotŋe Mosehât girem den sâm kâsikum ningiminiwiŋe belângembâ kinmâ yekŋetâ ki ârândâŋ otmu hoŋ bawalipŋe yuwu sâm âiyongowi. “Wongât Yesuŋe lok bâleŋe yu orop menduhuakmâ lau konok niai?” Yawu sâm âiyongowi. ");
INSERT INTO spl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yawu sâm âiyongoŋetâ Yesuŋe den ya nâŋgâm Parisaio yuwu sâm ekyongop. “Den âlâen hâum sâmune nâŋgâŋet. Lok mesekyeŋe biaŋe dokta yeŋgâlen ki arimai. Lok kundatyeŋe orop me hâhiwin teteyiŋgimap yaŋe konok dokta yeŋgâlen arimai. Yakât topŋe yuwu sâmune nâŋgâŋetâ keterahâk. Yeŋgâlen gâtŋe nombotŋaŋe yuwu sâmai. “Nen lok âlepŋe, nen orotmemenenŋe âiloŋgo dondâ otmâ mansain.” Yawu sâm pâlâmŋe manmai. Lok yawuya yeŋgât sâm ki gewan. Yeŋe lok bâleŋe sâm kewilâyekŋetâ belângen manmai yawuyaŋe orotmemeyeŋe bâleŋe pilâm Anitâhâlen biwiyeŋe kepeim denŋe lâum bulâŋe mem teteŋetgât gewan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yoane bukulipŋe otmu Parisaio lok nombotŋaŋe Anitâhât âi menehât nâŋgâm yâkâlen biwiyeŋaŋe hikum sâp sâsâŋanâk sot barak manminiwi. Yawu manminiwi yakât otmuâmâ yâk yeŋgâlen gâtŋe nombotŋaŋe Yesuhâlen ari yuwu sâm ekuwi. “Nen Anitâŋe nâŋgâningimu ârândâŋ olâkgât sot barak mansain. Sot barak manmâ sâp kâlep Anitâ mepaem ulitgum gamain. Yâhâ gâhât hoŋ bawalipgaŋeâmâ otmain yawu ki otmai. Wongât hilâm ârândâŋ sot kutakamai?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sâŋetâ sâop. “Yakât den âlâen hâum sâmune nâŋgâŋet. Lok patoŋe imbi miakbe sâm bukulipŋe meyekmu orowâk tatmâ sot um nem heroŋe otnomai. Heroŋe otnomaiân sot barak ki tatmai. Yâhâ hâmbâi mâne kasalipyeŋaŋe taka bukuyeŋe kuŋetâ mumbuap yanâmâ eŋgat hako nâŋgâm sot barak mannomai. ");
INSERT INTO spl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yakât yuwu sâmune nâŋgâŋet. Yiwereŋeâmâ nâ orowâk mansain yakât otmâ sot barak ki mansai. Hâmbâi mâne nâ nohoŋetâ mumbom sâp yan eŋgat hako nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Otmu orotmeme embâŋân otminiwi ya otmu ikŋe orotmeme âiŋe kâsikum yiŋgiop yaŋe ki lâuahop. Yakât otmâ yâhâp yâhâp menduhum lâunomaihât dop ya ki olop. Yakât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâm ekyongop. “Nen sot me salup me âlâlâ une sâm yan hâpu golâenâk mânuŋmâ titâkum umain. Gârâmâ hâpu tekaŋan mânuŋmâ kâlâwân katmain yamâ hâpu tekaŋe ya sem huhumu sot yaŋe golâ kinmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Otmu den âlâen yuwu hâum sâop. “Imbi âlâŋe lepa dorokum tâk masipguwuap. Masipgum katmu tatmâ hâŋgiŋe otbuap. Yâhâ yakât kakŋan tâk âiŋe orop menduhum lowaim iri osowuap. Iri osomâmâ senŋe âlâlâŋe mânuŋbuap yan dâimu tiririk sâmu tok sâwuap. Yakât otmuâmâ nenŋe tâk âiŋaŋak menduhum lowaimain. Yawu otmain yanâmâ senŋe âlâlâ umatŋe mânuŋnomân yamâ dâimu ŋirik ŋirik sâm ki tok sâwuap. Yâhâ hâŋgiŋe otmu âiŋe menduhunom yamâ dâimu titâk sâwuap. Yamâ ki orotŋe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tatmâ nâŋgâ nâŋgâ sâp âlâen Yesuŋe hoŋ bawalipŋe nen kerek menenekmu âi kalam biwiŋambâ ariwin. Ari mâtâp tânâmŋan po ningiop. Yawu otmuâmâ buku nombotŋe yeŋgât kalamân sot talop ya mem newin. Yawu otmunŋe Parisaioŋe nenekmâ Yesu yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","“Gâ wongât ândâp bok oat? Moseŋe girem den kulemguop ya lâumâun ya tatmâ naŋgain. Yakât girawu otmuâmâ hoŋ bawalipgaŋe bukulipyeŋe yeŋgât kalamâmbâ sot mem golâ niai? Ya otŋetâ yekmunŋe bâleap. Yakât otmâ gâŋe kuyiŋgirâ âlâku ki otnomaihât naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Yawu sâŋetâ purik pilâyiŋgim sâop. “Emelâk embâŋân Dawitiŋe olop yakât den pat sâlikum ki nâŋgâm heŋgeŋgumai. Yakât topŋe nâŋgâŋetâ keterahâkgât yuwu sâmune nâŋgâŋet. Dawitiŋe olop sâp yan hotom uwi ya yeŋgât lok kunŋe âlâ manop, kutŋe Awiata sâm. Sâp yan Anitâhât hotom um manbiŋe baŋga tuhum Anitâhât pat sâm katminiwi ya yâkŋe konok neminiwi. Lok inŋeâmâ bia. Hilâm âlâen Dawiti otmu ikŋe tembe lâulipŋe sotgât bâleŋetâ yan ikŋak Anitâhât miti selepŋan yâhâop. Yâhâmâmâ Awiataŋe sot kâmbukŋe sâm kalop ya ihilâk mem niop. Mem nem nombotŋe talop ya mem tembe lâulipŋe ge kâsikum yiŋgimu newi. ");
INSERT INTO spl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yawu otbi yakât otmâ tatmâ nâŋgâ nâŋgâ sâp yukât topŋe sâmune nâŋgâŋetâ keterahâk. Emelâk embâŋân Anitâŋe tatmâ nâŋgâ nâŋgâ sâp ya katningiop yamâ âlâlâ otmaingât ki sâm kuningim kalop. Yamâ nenŋe Anitâ heroŋe nâŋgâwaŋgim mepaem biwi sânduk mannehât sâm kalop. ");
INSERT INTO spl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yâhâ Anitâŋe hâŋgânnohomu ge mansan nâmâ tatmâ nâŋgâ nâŋgâ yakât amboŋe. Otmu yakât bonŋeâmâ nâŋe konok mem teteman.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tatmâ nâŋgâ nâŋgâ sâp âlâen Yesuŋe miti emetŋan yâhâop. Yâhâ lok âlâ bâtŋe mum pâlâmŋe olop yanâk tatmu ehop. ");
INSERT INTO spl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yawu gârâmâ “Tatmâ nâŋgâ nâŋgâ sâpŋan Yesuŋe lok pareŋe ya mem heŋgeŋguwuap me bia?” sâm Parisaio nombotŋaŋe Yesu mem den âiân katne sâm bamu bam watbiŋe gotyetŋan ba kinbi. ");
INSERT INTO spl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Gotyetŋan ba kinŋetâ Yesuŋe lok pareŋe ya yuwu sâm ekuop. “Yahatmâ kin.” ");
INSERT INTO spl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sâmu yahatmâ kinmu benŋe Parisaio ya yuwu sâm ekyongop. “Moseŋe den kulemguop ya topŋe girawu tap? Tatmâ nâŋgâ nâŋgâ sâpŋan lok heŋgemyongonom me hilipyongonom?” Yawu sâop. Yawu sâm âiyongomu biwiyeŋe umatŋe otmu olotoŋâk kinbi. ");
INSERT INTO spl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Olotoŋâk kinŋetâ yekmu bâleop. Yekmu bâlemu kunyeŋe kârikŋe otmâ hiliwahonomai yakât nâŋgâm tepŋe nâŋgâyiŋgiop. Tepŋe nâŋgâyiŋgim lok pareŋe ya yuwu sâm ekuop. “Bâtge kuwihak.” Yawu sâmu bâtŋe pilâmu kuwihahop. ");
INSERT INTO spl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Panmu kuwihakmu Parisaioŋe ya ekmâ yakât nâŋgâm bâlewaŋgim pilâyekmâ gem ariwi. Gem ari bukulipyeŋe nombotŋaŋe lok pato âlâ, kutŋe Herot Antipa sâm, yâkâlen torokatmâ manbi ya yeŋgâlen ari orowâk menduhuakbi. Menduhuakmâ Yesu kuŋetâ muâkgât alahu gulahu otmâ den hikuwi. ");
INSERT INTO spl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Otmu Yesuŋe hoŋ bawalipŋe nen menenekmu miti emetŋambâ gem Galilaia deŋgân ginŋehen ariwin. Arimunŋe kapi gotŋe tete ya ambolipŋe dondâŋe Yesuŋe mem heŋgemnongoâkgât nengâlen takaŋetâ heŋgemyongop. Heŋgemyongop yakât den pat alahum sâm haok tuhuŋetâ lohimbi kiŋgitŋe orowâkŋe kapi âlâembâ âlâembâ taka menduhuakbi yamâ yu ambolipŋe. ");
INSERT INTO spl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nombotŋeâmâ Yuraia hân yakât kapi kunŋe, kutŋe Yerusalem sâm, ya ambolipŋe. Otmu kapi pato ya hawamgum kapi tipi tapi tatmâ arap ya ambolipŋe. Yâhâ nombotŋeâmâ Irumaia ambolipŋe. Yâhâ nombotŋeâmâ kapi tipi tapi Yoran to nombotgen tap ya ambolipŋe. Yâhâ nombotŋeâmâ kapi kutyetŋe Tiro otmu Siron ya ambolipŋe. ");
INSERT INTO spl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Lohimbi yawuyaŋe heŋgemnongoâk sâm taka hawamnongowi. Hawamnongoŋetâ lohimbi dondâ heŋgemyongop. Heŋgemyongom tatmu mem hâmbiŋ gumbiŋ tuhunenekbi. Mem hâmbiŋ gumbiŋ tuhunenekbi yakât otmâ in yawu pilâyekmâ arinehât nâŋgâm Yesuŋe eknongomu waŋga âlâ deŋgân ginŋan talop ya mem dâimunŋe gotnenŋanâk gaop. ");
INSERT INTO spl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Otmu lohimbi nombotŋe weke bâleŋaŋe mâŋgâeyehop ya Yesuŋe watyekmu gaiakmâ den kârikŋan halahum yuwu sâwi. “Nenŋe topge naŋgain. Gâmâ Anitâhât nanŋe bulâŋe.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yawu nâŋgâwi yakât otmâ lohimbi ekyongoŋetâ nâŋgâmaihât sâm kuyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Otmu yakât kakŋan Yesuŋe hoŋ bawalipŋe kâiân yâhâp nengât âi sâm ningiwe sâm otmâ nongonmu lohimbi ya pilâyekmâ ari ekbin. ");
INSERT INTO spl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Arim ekmâ orowâk pumŋan yâhâmunŋe yuwu sâm eknongop. “Yen orowâk manmâ Anitâhât topŋe kâsikum yiŋgiwomgât meyeksan. Den kâsikum yiŋgim hâŋgânyongomune ari nâhât den pat âlepŋe sâm ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ekyongom yan weke bâleŋaŋe lohimbi nombotŋe mâŋgâeyekmap ya watyekŋetâ gaiakmâ arinomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nen menenehop yamâ kutnenŋe yuwu. Simon, yamâ kutŋe âlâmâ Petoro sâm kunop. ");
INSERT INTO spl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Âlâmâ imi ata Yakowo yet Yoane, Yeweri nanyâhâtŋe. Yâkŋe nep kârikŋe tuhuowot ya ekmâ yan Yesuŋe kutyetŋe âlâ yuwu sâm yotgonop. “Boanesi” sâm yotgonop. Yakât topŋeâmâ yuwu. “Denyetŋe kou kâlâp.” ");
INSERT INTO spl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Âlâmâ Anderea yamâ Simon imiŋe. Otmu nombotŋeâmâ Pilip, Batolomaio, Mataio, Toma, Alipaio nanŋe Yakowo, Taraio, Simon yâhâmâ komot âlâen gâtŋe ya yeŋgât topyeŋe yuwu. Kasalipnenŋe Roma lok ya yeŋgât hâkâŋ otmâ watyekne sâm otminiwi yan gâtŋe. ");
INSERT INTO spl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Otmu bâiŋeâmâ Yurasi yamâ Karioto yan gâtŋe. Yâkŋeâmâ Yesuhât betŋehen kioŋop ya. Yesuŋe âi ningim yawu sâm eknongomu orowâk pumŋambâ gewin. ");
INSERT INTO spl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pumŋambâ gem ari emet âlâen yâhâ tatbin. Yâhâ tatmâ po ningimu sot um nene sâm ot tatmunŋe lohimbi dondâŋe Yesuŋe mem heŋgemnongoâk sâm nengâlen toho emet ya titâkuwi. Titâkum hawam mewam tuhunenekŋetâ sot ki newin. Inâk tatmunŋe Yesuŋe sot ki niop yakât otmâ lohotŋe olop. Lohotŋe olop yamâ lohimbi dondâŋe gâŋak bamat nâŋak baman otmâ hâmbiŋ gumbiŋ tuhuŋetâ hâpunakmâ heŋgemyongop. Nep tuhum tatmu wâtŋe houŋ sâop. Wâtŋe houŋ sâmu yan lok nombotŋaŋe ekmâ nâŋgâm tâpikgum yuwu sâwi. “Yesuŋe kunŋe itoŋ galaŋ otmu ki galemahom mansap.” ");
INSERT INTO spl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yawu sâŋetâ ikŋe hepŋe torehenlipŋaŋe den pat ya nâŋgâm tângune sâm emetyeŋe pilâm tohowi. ");
INSERT INTO spl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mâtâwân tohoŋetâ Mosehât girem den kâsikum ningiminiwi nombotŋe Yerusalem kapiângembâ toho tatbiŋe ekmâ yuwu sâwi. “Weke bâleŋe ya yeŋgât amboyeŋe, kutŋeâmâ Besewulu sâm, kutŋe âlâmâ Satan, yâkŋe Yesu mâmâŋe otbaŋgimu yâkât wâtŋan kinmâ weke bâleŋe watyeksap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yawu sâŋetâ nâŋgâm yuwu sâm purik pilâyiŋgiop. “Satangât weke bâleŋaŋe ki ahom hioŋakmai. ");
INSERT INTO spl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yakât topŋe teteâkgât den âlâen hâum sâwe. Lok komot konohâk menduhuakmâ mansaiŋe yahatmâ ahom hioŋakmâ tiok taok otnomai yamâ kapiyeŋe kâwurumŋaŋak kinbuap. ");
INSERT INTO spl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yâhâ hep torehenŋe komot konohâk otmâ mansaiŋe yahatmâ ahom hioŋakmâ ihilâk mahilâk otmâ ariai mâne kutyeŋe biatbâp. ");
INSERT INTO spl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yakât torokatmâ sâwe. Yiwereŋe Satangât komotŋak ahom hioŋakmâ mansai otmuâmâ den yan yuwuâk hiliwahom kuriŋ sânomai.” ");
INSERT INTO spl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nine topne teteâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Lok sâtŋe kârikŋe âlâ me âlâŋe ikŋe manmanŋe torokatmâ teteâkgât hâmbâŋe mem haŋgalakmâ tembe talam lâuakmâ teŋgâen irik irihâk kinbuap. Kinmu yanâmâ kasaŋaŋe taka kombo mewaŋgiwe sâm otmu ahoromawot. Ahom yan kasaŋaŋe kum itit kiom bâleŋe tuhuwaŋgiwuap. Dop yawuâk nâŋe Satan mem ge katbom. Yamâ aŋgoân yâkât weke bâleŋe watyekmune gaiakmâ arai.” ");
INSERT INTO spl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","“Yakât otmâ âlâ torokatmâ yuwu sâwe. Yeŋe imbiâk nâhâitŋe senduk banearâ bâleŋaŋe mâmâŋe otbaŋgimu âi memap nâŋgâmai. Yawu nâŋgâm tâpikguai yakât topŋe nâŋgâŋetâ keterahâkgât yuwu sâwe. Lok âlâ me âlâŋe otŋetâ bâleap. Me Anitâŋe âi sâm nihim hâŋgânnohomu gewan nâhât nâŋgâŋetâ tâŋât oap. Me lohimbiŋe nâhât nâŋgâŋetâ giâkgât sâm biwiyeŋan kioŋnomai. Lok yawuyaŋe orotmemeyeŋe bâleŋe bet pilânomai ya yeŋgât tosa yamâ Anitâŋe pilâyiŋgiwuapgât dop tap. Torokatmâ sâwe. Lok âlâ me âlâŋe Anitâhât Wâtgât mâmâŋahât Heakŋe âi tuhuap ya ekmâmâ yuwu sâwuap. “Bâe, âi yukât amboŋe yamâ Satan.” Yawu sâm yan âi ya ekmâ Satangâlen gâitmâ yâhâmbisâp. Lok yawuyaŋe tosa pato dâiwuap yamâ Anitâŋe tosa ya pilâwaŋgiwuapgât dop âlâ ki tap.” ");
INSERT INTO spl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yawu sâm ekyongom tatmu yanâk ikŋe hepŋe torehenlipŋe takawi. Taka tirek topŋan kinmâ yuwu sâwi. “Atanenŋe gâ ge.” ");
INSERT INTO spl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yawu sâŋetâ lok âlâ yan talopŋe yahatmâ Yesu yuwu sâm ekuop. “Wae, emba nâŋgâ. Torehenlipgaŋe taka tirek topŋan kinmâ gâhât yai.” ");
INSERT INTO spl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Yawu sâmu Yesuŋe nenekmâ yuwu sâm eknongop. “Hepne torehenlipne taka kinsai. Yawu gârâmâ yuwu sâwe. ");
INSERT INTO spl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anitâhât tem lâum mansai yeŋeâmâ nâhât hepne torehenlipne bulâŋe oai.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Hilâm âlâen Yesuŋe Galilaia deŋgân ginŋan ari talop. Yan tatmâ den pat âlepŋe ekyongop. Ekyongom tatmâ lohimbi dondâŋe taka mem hawam mewam tuhuwi. Mem hawam mewam tuhuŋetâ yapâ pilâyekmâ waŋgaen yâhâop. Waŋgaen yâhâmu lohimbi takawi ya deŋgân ginŋan ge tatŋetâ waŋga orotok sâm endâŋân baop. ");
INSERT INTO spl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Endâŋân bam waŋgaen kinmâ ikŋe den pat yakât topŋe nâŋgâŋetgât den âlâen hâum yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","8","“Den âlâen hâum sâmune nâŋgâŋet. Lok âlâŋe hote alikŋe mem hâiloŋbe sâm newângen ariop. Ari hote alikŋe ya nombot nombot mem hâiloŋmu giop. Nombotŋeâmâ mem hâiloŋmu mâtâwân ge talop. Yâhâ nombotŋeâmâ mem hâiloŋmu hân toŋe biaen ge talop. Yâhâ nombotŋeâmâ hele bâleŋe iowân giop. Yâhâ nombotŋeâmâ tep tep kum hân âiloŋgo loŋgo tuhuwi yan mem hâiloŋmu ge talop. Yawu gârâmâ hote alikŋe mem hâiloŋmu âlâen âlâen giop yakât topŋeâmâ yuwu. Nombotŋe mâtâwân ge talop yamâ nâiŋe in yawu taka kerek kârâm newi. Yâhâ nombotŋeâmâ hân toŋe biaen giop yamâ gihitŋe kakŋeâk pilâop. Yakât otmâ sikop kârikŋe kumu yan in yawu mum hâlâlâŋ sâop. Yâhâ nombotŋeâmâ hewukŋan me hele pato biwiŋan giop yamâ âiloŋgo tetem pururuk sâop. Pururuk sâmu hewukŋaŋe langumu derepgum gimbaŋgumu orok sâop. Yâhâ nombotŋe hân âlepŋan giop yaŋeâmâ tetem pururuk sâm âiloŋgo yahalop. Yâhâ nombotŋeâmâ tetem papato kewereop. Kândikum teteop ya wangiop. Yâhâ nombotŋeâmâ hote pawut purik papato sâmain dop yawuya teteop. ");
INSERT INTO spl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nâŋe den yan yu biwiyeŋan katmâ nâŋgâm heŋgeŋgunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Otmu lohimbi kerekŋe yahatmâ itoŋ galaŋ otmâ gem ariwi. Ariŋetâ nombotŋe yamâ konok konok âwurem gawi. Âwurem gaŋetâ nen hoŋ bawalipŋe kâiân yâhâp orowâk Yesuhâlen ari yuwu sâm âikuwin. “Den âlâen hâum kinmâ yat ya nâŋgâmunŋe ki keteraksap. Yamâ topŋe sârâ nâŋgâmunŋe keterahâk.” Yawu sâwin. Yawu sâm âikumunŋe yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Anitâŋe tihitnenŋe otmâ gamap yakât topŋe yeŋe tipiŋe naŋgai. Yâhâ lok nombotŋe nâhâlen ki torokatmâ mansaiŋeâmâ biwiyeŋe pâlâmŋe otmâ mansai. Biwiyeŋe pâlâmŋe otmâ manŋetâ yakât den âlâen âlâen hâum ekyongoman. ");
INSERT INTO spl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yakât otmâ “yâkŋe nâhât hâkâŋ otmâ nekmâ kâkâsuk otmai. Yawu otmâ biwiyeŋe alitmai. Yakât otmâ nâhât topne ki nâŋgâŋetâ keterakmap. Yâhâ biwiyeŋe pâlâmŋe otmâ nâhât den pat yu nâŋgâŋetâ tâŋât oapgât hiliwahonomai. Yamâ nâŋgâm heŋgeŋguai mâne biwiyeŋe Anitâhâlen katmâ denŋe lâuŋetâ tosayeŋe emelâk pilâyiŋgimbâp.” ” ");
INSERT INTO spl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yawu sâm benŋe yuwu sâm eknongop. “Nâŋe den yan yu ki nâŋgâm heŋgeŋguai. Yakât otmuâmâ wuân denân hâum sâmune yeŋe nâŋgâŋetâ keterakbuap? Aiop yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Lok hote alikŋe mem hâiloŋmu giop yamâ nenŋe Anitâhât den lohimbi sâm ekyongomunŋe nâŋgâmai yakât dop. ");
INSERT INTO spl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yâhâ alikŋe nombotŋe mem hâiloŋmu mâtâwân giop yakât topŋe yuwu. Yamâ lohimbi nombotŋaŋe Anitâhât den nâŋgâmai yanâmâ Satanŋe den ya kum mem gulip tuhumap. ");
INSERT INTO spl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yâhâ hote mem hâiloŋmu nombotŋe hân toŋe biaen giop yakât topŋe yuwu. Lok yawuya nâhât den pat âlepŋe ekyongomune nâŋgâm heroŋe otmâ manmai. Nâŋgâŋetâ den ya kakŋeâk gem biwiyeŋan gihitŋe kârikŋe ki memap. ");
INSERT INTO spl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yawu gârâmâ Anitâhât kasalipŋe takaŋetâ yekmâ kiŋgityeŋahât otmâ in yawu bet pilâmai. Me bukulipyeŋe nombotŋaŋe senyeŋan gemai yan lohotŋe otmâ pilâmai. ");
INSERT INTO spl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yâhâ hote nombotŋe mem hâiloŋmu hele biwiŋan giop yakât topŋe yuwu. Lohimbi nombotŋe den ekyongomune nâŋgâŋetâ bonŋe otmap. ");
INSERT INTO spl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nâŋgâŋetâ bonŋe otmu sâp kâlep ki otmuâk hângât iri sikum, me tewetsenŋe, me âlâlâ ekmâ biwi nâŋgân nâŋgânyeŋaŋe yan hikum nâŋgâm manmai. Yawu manmai yakât otmâ biwi yâhâp otmâ manŋetâ manman âlepŋe ki teteyiŋgimap. ");
INSERT INTO spl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yâhâ hote mem hâiloŋmu nombotŋe hân toŋe orowân giop yakât topŋe yuwu. Lok yawuyaŋeâmâ den pat âlepŋe nâŋgâm heŋgeŋgumai. Nâŋgâm heŋgeŋgum tiŋâk lâum manŋetâ manman âiloŋgo loŋgo teteyiŋgimap. Yâk yeŋgât topyeŋe yawu. Nâŋe hoteân hâum yan yamâ topnenŋeâmâ yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuŋe den âlâen hâum yuwu sâm eknongop. “Nenŋe emet kâlehen tatmâ lambe saum tuŋguŋan ki katmain. Gârâmâ heleŋân gâitmunŋe kinmâ sem laŋinŋe pilâmu ekmâ gem yâhâmain. ");
INSERT INTO spl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yakât topŋe yuwu. Lok âlâ me âlâŋe otŋetâ bâlemu kurihimai yamâ hâmbâi mâne tetekŋan otmu eknom. Yâhâ omoŋ kâtâpŋan otŋetâ ki ekmain yamâ hâmbâi mâne haŋ sâmâ tetekŋan eknom. ");
INSERT INTO spl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nâŋe den yan yu biwiyeŋanâk katmâ topŋe nâŋgâm heŋgeŋgunomai.” ");
INSERT INTO spl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Otmu den âlâ yuwu torokalop. “Den yan yukât topŋe teteâkgât sâmune nâŋgâŋet. Yen oap amboŋe ikŋiâk ikŋiâk mansai. Yakât otmuâmâ nâhât den nâŋgâm lâunomai me kum pilânomai yakât matŋe Anitâŋe yiŋgimu âlâku amboŋan amboŋan menomai. ");
INSERT INTO spl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lok âlâ me âlâŋe nâhât den nâŋgâm biwiyeŋan katmâ mannomaiŋe ya nâŋgâŋetâ keterakbuap. Yâhâ lok âlâ me âlâŋe nâhât den nâŋgâŋetâ nahat otmu bet pilânomaiŋe biwiyeŋe pâlâmŋe manmâ ki nâŋgâŋetâ keterakmâ heŋgeŋguwuap.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yawu sâm Anitâŋe tihitnenŋe otmâ menenekbuap yakât topŋe teteâkgât den âlâen hâum yuwu sâm eknongop. “Lok âlâŋe newân ari yu me ya kehetŋe katmap. ");
INSERT INTO spl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Katmu tatmâ mâne mâne pururuk sâm ga takamap. Pururuk sâm ga takamap yakât topŋe ki nâŋgâmain. ");
INSERT INTO spl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yamâ hân kâlehen tatmâ yapâ pururuk sâm ga takam yaŋak esenŋe huhumap. Esenŋe huhum yaŋak pato otmâ yan bonŋe otmap. Yamâ kehetŋe hânâmbâ pururuk sâmap yapâ gâtŋaŋe bonŋe otmawân osetŋe ya tatmain yakât ki nâŋgâm ketetmâ gulip malap otmain. ");
INSERT INTO spl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bonŋe otmâ nenehât dop otmuâmâ mem ari um nemain. Yakât topŋe yuwu sâmune nâŋgâŋet. Anitâhât den lok biwiyeŋan katmunŋe tatmu yâk yeŋgâlen bonŋe tetewuap yakât ki gorâningimap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yawu sâm den âlâ yuwu torokatmâ eknongop. “Yeŋe biwiyeŋe Anitâhâlen kepeiŋetâ tihityeŋe oap yakât topŋe teteâkgât wuân denân hâum sâmune nâŋgâŋetâ keterakbuap? Yuân hâum sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nak âlâ kutŋe bândup yamâ lok âlâŋe kehetŋe tipiŋe âlâ mem ari kalamŋan kalop. ");
INSERT INTO spl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Katmu tatmu kâmŋe ga takam yaŋak yâhâm kâlep pato otmâ nak nombotŋe wangiyekmap. Yawu otmu nâi wosapâ wosapâ taka awatŋe kun kunŋan kerem tatmai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuŋe ikŋe den pat âlepŋe ekyongom yanâmâ den âlâen âlâen hâum sâm ekyongominiop. ");
INSERT INTO spl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sâm ekyongomu nâŋgâŋetâ ârândâŋ otmu yanâmâ pilâyekmâ âlâengen ariminiop. Pilâyekmâ nenŋeâk tatbin yan topŋe nâŋgâmunŋe keterahâkgât den kâsikum ningiminiop. ");
INSERT INTO spl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yesuŋe den yawu sâm tiŋ pilâm emetsâpŋe otmu yuwu sâm eknongop. “Waŋgaen yâhâ deŋgân yu hâtikgum nombotgen arine,” sâmu nenŋe lohimbi ya pilâyekmâ waŋgaen yâhâ hâtikgum nombotgen ariwin. ");
INSERT INTO spl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Arimunŋe nombotŋe gurâ betnenŋan watnenekmâ tohowi. ");
INSERT INTO spl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Deŋgân ya tânâmgumunŋe yanâk siru puŋ puŋ sâm pilâop. Siru puŋ puŋ sâm pilâmu toŋe waŋga kâlehen gemu guhutbe sâm olop. ");
INSERT INTO spl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Guhutbe sâm olop yan Yesuŋeâmâ kum ihi ya katmâ ya kakŋambâ aman pâlâmŋe iop. Aman im tatmu nen hoŋ bawalipŋaŋe yahatmâ waŋga hâmeŋehen yâhâ mândem ekuwin. “Wa, waŋga yu deŋgân kâlehen guhulakbe sâm oap. Yakât otmâ gâ wongât aman pare pare ot tat?” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yawu sâmunŋe yahatmâ siru ya kuwaŋgiop. Kuwaŋgimu to yaŋe nâŋ nâŋ sâop. ");
INSERT INTO spl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nâŋ nâŋ sâmu yuwu sâm âinongop. “Yen wongât kiŋgityeŋahât oai? Anitâŋe haoŋmâ ârândâŋ tihitnenŋe otmap yakât topŋe ki naŋgai hâ? Wongât biwi yâhâp oai? Nâŋe tânyongowomgât dop ki tap. Yawu mon sâm oai?” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yawu sâm eknongomu yuwu sâm alahuwin. “Bâe, lok yukât topŋe girawu? Siru kuwaŋgimu yaŋak to yaŋe nâŋ nâŋ yap.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","To nâŋ nâŋ sâmu deŋgân ya hâtikgum ba nombot endaken kapi âlâ, kutŋe Gerasene sâm, yan ariwin. ");
INSERT INTO spl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yan ari waŋgaembâ lâum kioŋmâ arimunŋe lok âlâ weke bâleŋaŋe mâŋgâeminiop yamâ sumângembâ takamu ekbin. ");
INSERT INTO spl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","Yâhâ yâkât topŋe yuwu. Lok yamâ sumân bam gam otmâ ihilâk mahilâk manminiop. Ihilâk mahilâk manmu yan weke bâleŋaŋe mâŋgâemu omoŋe hilâmŋe sumângen ari im yahatmâ isem hu halak tuhuminiop. Hu halak tuhum kâlân, me nak duwiŋan, me hân teŋ sâŋan me âlâen âlâen yan ikŋe kun kândâtŋe ahom kuakminiop. Yawu otmâ sâtŋe kârikŋe otmu kapi ya ambolipŋaŋe ari kâiŋe bâtŋe mem sâhâm kuratguminiwi yamâ tâmbiriŋ sâmu hâreakminiop. Yâkât otmuâmâ tâk kârikŋe, kutŋe sein sâm, yaŋe kâiŋe bâtŋe mem menduhum sâhâminiwi. Yâhâ ya gurâ yawuâk tâmbiriŋ sâmu hâreakminiop. Yawu otmu ekŋetâ tepyeŋe hindâm pilâm kapiyeŋan ariwi. Lok yakât topŋe yawu. ");
INSERT INTO spl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Lok yaŋe ewâŋân kinmâ Yesu ekmâmâ mem bâlenekmap sâm yakât ulitguwe sâm in yawu yâkâlen giop. ");
INSERT INTO spl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yâkâlen ge kinmu Yesuŋe weke bâleŋe ya watbe sâm otmâ yuwu sâm ekuop. “Lok yukâlembâ gaiakmâ ari.” Yawu sâmu hu halak tuhum yuwu sâm ulitguop. “Yesu, topge naŋgan. Gâ Anitâhât nanŋe. Yamâ wongât nâhâlen takat? Nâ hâhiwin ki nihi. Inâk âwurem arihât naŋgan.” Yawu sâm ulitguop. ");
INSERT INTO spl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ulitgumu sâop. “Ahonakdâ nâŋgâwe.” Sâmu sâop. “Nâŋe weke bâleŋe nombotŋe meyekmune orowâk tatmâ lok yu mem mâŋgâem mansain. Yakât nengât kutnenŋe “Komot Pato,” yawu. ");
INSERT INTO spl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aiop, gâŋe nâŋgâningirâ sumânâk manmâ yan kâlepŋehen ki arinehât naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yâhâ talapŋan bau seseŋgâlâkŋe tomot tuhum kinŋetâ yekbi. ");
INSERT INTO spl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yekmâ yuwu sâm Yesu ekuwi. “Gâŋe watnenekbuat otmuâmâ, âlepŋe watnenekdâ bau enda yeŋgâlen arinom.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yawu sâŋetâ watyekmu yâkâlembâ gaiakmâ bau ya yeŋgâlen ge mânuŋakbi. Bau yeŋgâlen ge mânuŋakmâ mâŋgâyekŋetâ sururuk sâm ba hem patoembâ tâwoŋ sâm deŋgânân kioŋetâ haranyongop. Otmu bau yamâ amon kitâ kinbi? Bau yamâ kiŋgitŋe orowâk. Yakât dop yamâ 2000 ya wangiop. ");
INSERT INTO spl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bau kiŋgitŋe orowâkŋe deŋgânân kioŋetâ haranyongop. Yakât otmâ galemyongom manbiŋe ekmâ sururuk sâm kapi ambolipŋe ya ekyongowi. Ekyongoŋetâ yakât topŋe nâŋgâne sâm Yesuhâlen takawi. ");
INSERT INTO spl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Otmu emelâk weke bâleŋaŋe lok mâŋgâeŋetâ ihilâk mahilâk manminiop yamâ nâŋgân nâŋgânŋe keterakbaŋgimu hâk katipŋe mânuŋakmâ tatmu ekbi. Ekŋetâ sâtŋe otmu lohimbi Yesu orop kinbi ya âiyongowi. ");
INSERT INTO spl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Âiyongoŋetâ Yesuŋe weke bâleŋe watyekmu gaiakmâ bau mem hilipyongowi yakât den pat ekyongowi. ");
INSERT INTO spl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ekyongoŋetâ nâŋgâm kuk otmâ Yesuŋe pilâyekmâ âlâengen ariâkgât ekuwi. ");
INSERT INTO spl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yakât otmâ Yesuŋe menenekmu waŋgaen yâhâmunŋe yan lok weke bâleŋe watbaŋgiop yaŋe yuwu sâop. “Nâ girawu otbom? Yen orop arinehât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sâmu sâop. “Bia, gâ nen orop ki arinom. Yiwereŋe Anitâŋe nâŋgâhihimu nâŋgân nâŋgânge keterakgihiap. Yakât otmâ kapihehen ari gike hepge torehenlipge yakât den pat ya ekyongowuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yawu sâmu kapi bâlâk ŋerek tatmâ arap ya yeŋgâlen ari yakât den pat ekyongomu nâŋgâŋetâ sâtŋe olop. ");
INSERT INTO spl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yawu otmâ Yesuŋe menenekmu kapi ya pilâm waŋga mem âwurem ariwin. Âwurem ari waŋgaembâ ge deŋgân ginŋan kinmunŋe lohimbi dondâŋe Yesu ekne sâm taka hawamnongom kinbi. ");
INSERT INTO spl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yawu otmâ kinŋetâ miti selepŋahât galem ya yeŋgât lok kunŋe, kutŋe Yairo sâm, yâkŋe gotŋan ga mepaem ekuop. ");
INSERT INTO spl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Baratne, ombe bisine konohâk ya sihanâk katnenekbe sâm oap. Yawu gârâmâ gâŋe ari wâirâ âlepŋe olâkgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yâhâ nenŋe takawin yakât den pat ya lohimbi dondâŋe nâŋgâm Yesu ekne sâm taka mem hawam mewam tuhunenekŋetâ orowâk ariwin. ");
INSERT INTO spl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yâhâ imbi âlâ orowâk ariwin yâkât topŋeâmâ yuwu. Imbilipnenŋaŋe emetsenŋe ekmai dop yawu ki olop. Yâhâ imbi yuâmâ emetsenŋe ekmâ yâhâmu yambu kâiân yâhâp olop. ");
INSERT INTO spl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yambu kâiân yâhâp yu biwiŋan dokta yeŋgâlen arimu hep ya saŋ sâekgât âi pato meŋetâ tewetsenŋe pato imbiâk pilâminiop. ");
INSERT INTO spl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yawu otminiop yakât otmâ Yesu takaop pat ya nâŋgâm peneningimu orowâk ariwin. ");
INSERT INTO spl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Orowâk arim yan biwiŋaŋe yuwu nâŋgâop. “O, nâmâ Yesu wâiwomgât dop ki oap. Yawu gârâmâ sâŋgum potonŋan in walipguwom.” Biwiŋaŋe yawu nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yawu otmâ walipgumu yanâk hepŋe saŋ sâmu hâkŋe nâŋgâmu âiloŋgo olop. ");
INSERT INTO spl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yâhâ walipguop yanâk Yesuŋe hâkŋe katmâ nâŋgâop. Hâkŋe katmâ nâŋgâm yaŋak eŋgatŋe kakŋambâ olelem yekmâ “Âlâŋe walipnohoap?” sâm âiyongop. ");
INSERT INTO spl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yawu sâm âiyongomu yan kurihiakŋetâ nenŋan gâtŋe âlâŋe yuwu sâop. “Lohimbi dondâŋe hawam mewam tuhunenekŋetâ wâiakmâ kinsain. Yakât otmâ gâ girawu nâŋgâm yat? Yan gâtŋaŋe mon walipgohoai.” ");
INSERT INTO spl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yawu sâm ekumu senŋe senŋe olop. ");
INSERT INTO spl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Senŋe senŋe otmu imbi yaŋe kâi bâtŋe kârâŋ kârâŋ sâmu kinop. Yawu otmâ Yesuhât gotŋan ba walipgum yan âlepŋe olop yakât topŋe kerek ekuop. ");
INSERT INTO spl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sâmu sâop. “Toune, biwihe nâhâlen katdâ yakât Anitâŋe nâŋgâhihimu hepge saŋ yap. Lohotŋan ba ari.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yawu sâm ekum kinmu yanâk Yairohât hoŋ bawalipŋe nombotŋaŋe emelambâ taka yuwu sâm ekuwi. “Baratge emelâk bâleap. Yakât otmâ lok pato yu imbiâk sârâ gamap.” ");
INSERT INTO spl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yawu sâŋetâ Yesuŋe nâŋgâm ki nâŋgâm yawu otmâ Yairo yuwu sâm ekuop. “Yakât ki gorâhihiâk. Biwihe nâhâlen katmâ eŋgat yâhâp ki ot.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yawu sâm lohimbi nombotŋe katyekmu kinŋetâ Petoro, Yakowo otmu imiŋe Yoane meyekmu ariwi. ");
INSERT INTO spl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ari Yairohât emet gotŋan ba kinmâ gilâp nâŋgâwi. Yâhâ emet kâlehen lohimbi dondâŋe kahân tatmâ isem we bâle pato nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yawu otmâ isem tatŋetâ yuwu sâm ekyongop. “Baratyetŋe ki bâleap, in aman pâlâmŋe iap. Yakât wongât otmâ olo gilâp bâleŋe oai?” ");
INSERT INTO spl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yawu sâm ekyongomu nâŋgâŋetâ ki bonŋe otmu giriŋbaŋgiwi. Giriŋbaŋgiŋetâ Yesuŋe hâŋgânyongomu yaihen kioŋbi. Yaihen kioŋetâ âwâŋe mâmâŋe otmu hoŋ bawalipŋe kalimbu ya meyekmu imbi sihan talowân yâhâwi. ");
INSERT INTO spl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yâhâŋetâ Yesuŋe imbi sihan ya bâtŋan mem denyeŋan yuwu sâm ekuop. “Talita, koum.” Yakât topŋeâmâ yuwu. “Barat tipiŋe, yahatmâ kin.” ");
INSERT INTO spl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sâmu yanâk yahatmâ bam gaop. Yawu otmu âwâŋe mâmâŋaŋe ekmutâ âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yawu otmuâmâ Yesuŋe sâmu sot um waŋetâ niop. Yawu otmâ bukulipyetŋe ki ekyongoromawot sâm kuyitgiop. ");
INSERT INTO spl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yawu otmâ Yesuŋe ikŋe kapiân âwurem ariwe sâm otmâ menenekmu orowâk yahatmâ ariwin. ");
INSERT INTO spl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ari manmunŋe tatmâ nâŋgâ nâŋgâ sâp âlâen Yesuŋe miti emetŋan yâhâ den kâsikum yiŋgiop. Den kâsikum yiŋgimu lohimbi dondâŋe nâŋgâŋetâ âlâ kândâkdâ otmu âiahom yuwu sâwi. “Bâe, lok yuâmâ nengâlen gâtŋe. Âlâŋe nâŋgân nâŋgân topŋe topŋe yu ekumu taka kâsikum ningiap? Me wosapâ ari kândiwahom taka kulem âlâlâ miap? Yu ekmunŋe sâtŋe oap. ");
INSERT INTO spl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yamâ hep torehenlipŋe nâŋgâyiŋgiain. Imilipŋe, kutyeŋe Yakop, Yose, Yurasi otmu Simon. Yâhâ garilipŋe ya gurâ nâŋgâyiŋgiain. Yâhâ mâmâyeŋe Maria yâhâmâ nenŋan gâtŋe. Yakât otmâ oap miap yukât girawu nâŋgânom?” Yawu sâwi. Yâhâ hep torehenlipŋe nâŋgâyiŋgiwi yakât otmâ den kâsikum yiŋgim manop yamâ nâŋgâŋetâ nahat otmu betguwi. ");
INSERT INTO spl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yawuhât Yesuŋe biwiyeŋahât topŋe ekmâ yuwu sâm ekyongop. “Anitâhât poropetelipŋaŋe kapi âlâen ari yâkât den kâsikum yiŋgiŋetâ nâŋgâŋetâ bulâŋe otmap. Yâhâ yâkŋe hep torehenlipyeŋe den kâsikum yiŋgiŋetâ nâŋgâŋetâ nahat otmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Yesuŋe den kâsikum yiŋgimu nâŋgâŋetâ nahat olop yakât otmâ lohimbi dondâŋe biwiyeŋe yâkâlen ki katbi. Lohimbi nombotŋaŋe biwiyeŋe yâkâlen katŋetâ heŋgemyongop yamâ getek âlâ. Yawu otŋetâ yekmâ nâŋgâmu sâtŋe otmu hohetyeŋan kulem amon âlâek miop. Yawuhât ikŋe kapi pilâm kapi âlâlâ yeŋgâlen ari Anitâhât topŋe nâŋgâŋetâ keterahâkgât den kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Otmu Yesuŋe hoŋ bawalipŋe kâiân yâhâp nen menduhunenekmâ yuwu sâm eknongop. “Sâmune nâŋgâŋet. Yen kapi âlâen âlâen ari Anitâhât topŋe sâm ekyongonomai yamâ nâŋe mâmâŋe otyiŋgimune weke bâleŋe watyekŋetâ gaiakmâ arinomai. ");
INSERT INTO spl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hâŋgânyongomune arinomai yanâmâ lok yâhâp yâhâwâk menduhuakmâ yuwu otmâ arinomai. Âi topŋe katne sâm sot me senŋe âlâlâ umatdâek ki miakmâ arinomai. Me natik ki miaknomai. Me itâkat ki golenomai. Me tewetsenŋe hakyeŋan ki tatbuap. ");
INSERT INTO spl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Me pet me hâk katipŋe ya hourâ hourâ ki miaknomai. Yâhâ kâiyeŋahât katipŋe katmâ howan konok tinaŋgunomai. ");
INSERT INTO spl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Otmu kapi âlâen arinomai yanâmâ emelan dâim yâhâ katyekŋetâ yanâk tatnomai. Kapi tatnomai ya ambolipŋaŋe orotmemeyeŋe bâleŋe betbaŋgim biwiyeŋe Anitâhâlen katŋet sâm nâhât den pat âlepŋe ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yâhâ kapi âlâen ari den ekyongoŋetâ nâŋgâŋetâ gemu bet pilânomai yamâ hâmbâi Anitâŋe matŋe umatŋe yiŋgiwuap. Yakât otmuâmâ yeŋe yuwu otmâ kâi katnomai. Kâiyeŋan wahap me bokosok me yu ya horatbuap yamâ tâlim gik beretek meŋetâ gemu betyiŋgim pilâyekmâ ba âlâengen arinomai. Ariŋetâ towat ya ekmâ kâi katsap yawu nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yawu sâm eknongomu ariwin. Yâhâp yâhâwâk ari lohimbiŋe orotmemeyeŋe bâleŋe betbaŋgim biwiyeŋe Anitâhâlenâk katnomaihât Yesuhât den pat âlepŋe ekyongowin. ");
INSERT INTO spl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Den pat âlepŋe ekyongom yan weke bâleŋaŋe mâŋgâeyekbi ya gurâ watyekmunŋe gaiakmâ ariwi. Yâhâ lohimbi nombotŋe mesek otbi me kundat topŋe topŋe teteyiŋgiop yamâ meyekmâ nak âlâ, kutŋe oliwa sâm, yakât kehetŋahât toŋaŋe mem kunyeŋan lâwâleyekmâ Anitâ ulitgumunŋe âlepŋe otbi. ");
INSERT INTO spl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nenŋe yawu otyiŋgiwin yakât den patŋe perereŋ sâm arimu lohimbi dondâŋe nâŋgâwi. Nâŋgâmâmâ nombotŋaŋe Yesuhât yuwu sâwi. “Lok âlâ, kutŋe Yoane sâm, yâkŋe embâŋâmbâek topŋe katmâ toen katyekmâ gaop. Yamâ emelâk nengât lok kutdâ, kutŋe Herot sâm, yâkŋe tembe lâulipŋe hâŋgânyongomu ari kuŋetâ muop. Muop yamâ mumuŋambâ yahatmâ kulem topŋe topŋe yu mem gap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yâhâ nombotŋaŋeâmâ yuwu sâwi. “Poropete lok âlâ, kutŋe Elea sâm, emelâk himbimân yâhâop yaŋe mon purik sâm ge kulem âlâlâ yu me mansap.” Yawu sâwi. Yâhâ nombotŋaŋeâmâ yuwu sâwi. “Emelâk embâŋân poropete lok nombotŋaŋe Anitâhât tem lâum kulem topŋe topŋe mem âiyeŋe tuhuwi. Yakât dopŋeâk lok yuŋe Anitâhât den eknongom kulem topŋe topŋe memap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yawu sâm alahuŋetâ Herotŋeâmâ denyeŋe nâŋgâm yuwu sâop. “Yoane yamâ sâmune eŋgatŋe hârewi. Yâkŋe mumuŋambâ yahatmâ kulem topŋe topŋe yu miap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Otmu Herotŋe sâmu Yoane kuŋetâ muop yakât topŋe yuwu. Herot yet Pilip yamâ imi ata. Aŋgoân Pilipŋeâmâ imbi, kutŋe Herotia sâm, ya miop. Memu manmâ manmâ imbi yaŋe lokŋe hâkâŋ otmâ pilâmuâmâ kahaŋe Herot ya orop miahowot. Yakât otmâ Yoaneŋe nâŋgâmu bâlemu yuwu sâop. “Nengât girem den kuawot ya ekmune dondâ bâleap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Yawu sâm kuyitgimu imbi yaŋe Yoanehât dondâ nâŋgâm bâlewaŋgiop. Nâŋgâm bâlewaŋgim yan Yoane girawu otmâ kuŋetâ muâk nâŋgâm manminiop. Yâhâ Yoaneŋe Anitâhât lauŋe lâum uwawapŋe bia manmâ gaop yakât Herotŋe ekmâ nâŋgâmu âlâ kândâkdâ otmu gorâwaŋgiop. Gorâwaŋgimu yan imbiŋahât mâtâp maŋguwe sâm otmâ tembe lâulipŋe hâŋgânyongomu ari Yoane mem sâhâm pâi emetŋan katŋetâ tatminiop. Yan tatmâ Herotgât sâtgât otmâ yâkâlen ari Anitâhât den kâsikum waŋmu nâŋgâm heroŋe otminiop. Yawu gârâmâ den sâop ya nâŋgâmu biwiŋan hâumu biwi yâhâp otminiop. ");
INSERT INTO spl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yawu otminiop yamâ imbiŋaŋeâmâ Yoane kuŋetâ muâkgât nâŋgâminiop. Mâne mâne mâne yakât bonŋe teteop yamâ yuwu. Sâp âlâen Herotŋe teteop yakât nâŋgâm heroŋe otne sâm bukulipŋe nombotŋe taka sot um nene sâm menduhuakbi. Menduhuakbi yamâ Roma lok nombotŋe, otmu tembe lâulipŋe ya yeŋgât kunlipyeŋe, otmu kapi tipi tapi Galilaia hânân tatmâ arap ya yeŋgât papatolipyeŋe kerehâk menduhuakmâ sot nem heroŋe nâŋgâwaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Sot nem heroŋe otŋetâ yanâmâ baratyetŋaŋe yahatmâ kep ândeop. Kep ândemu ekmâ biwiyeŋe âlepŋe otmu heroŋe nâŋgâwi. Heroŋe nâŋgâŋetâ Herotŋe yuwu sâm ekuop. “Barat. Anitâhât senŋan kinmâ sâmune nâŋgâ. Iri sikum senŋe âlâlâ tatnihiap yu me ya ekŋâlemat ya âlepŋe eknohorâ nombotŋe kâsikum gihiwom.” ");
INSERT INTO spl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yawu sâm ekumu imbi yaŋe ari mâmâŋe yuwu sâm ekuop. “Awoŋnaŋe ikŋe iri sikumŋe me senŋe âlâlâ tatbaŋgiap ya “nombotŋe gihiwom,” yap. Yakât otmâ wuân membomgât naŋgat?” Sâmu sâop. “Yoane yamâ kuŋetâ muâkgât naŋgan. Yakât otmâmâ “Yoane eŋgatŋe hârem kunŋe mem ga nihiŋet,” yawu sâm ekuwuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yawu sâmu baratŋaŋe tepŋe yahatmu sururuk sâm âwurem ari yuwu sâm ekuop. “Gâŋe tembe lâulipge ekyongorâ in yawu ari Yoane eŋgatŋe hârem kunŋe kondoân katmâ mem ga nihiŋetgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yawu sâmu âwâŋaŋe Anitâhât senŋan sâm kârikŋe tuhuop yakât nâŋgâm biwiŋaŋe umatŋe dondâ olop. Yawu otmu bukulipŋe yeŋgât senyeŋan kinmâ den ya ekuop yakât aŋulakman sâm den ya lauŋan miop. ");
INSERT INTO spl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yawu otmâ tembe lâu âlâ hâŋgângumu sururtuk sâm pâi emetŋan yâhâ Yoane eŋgatŋe hâreop. ");
INSERT INTO spl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Eŋgatŋe hârem kunŋe mem kondoân katmâ mem ge waŋop. Waŋmu lâum mâmâŋahâlen ari tiripgumu ekmâ biwiŋe heroŋe olop. ");
INSERT INTO spl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yakât den pat ya Yoane hoŋ bawalipŋaŋe nâŋgâm lâum ari kât giopŋe âlâ, dikin yawuya yan katbi. ");
INSERT INTO spl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yâhâ emelâk Yesuŋe nen hoŋ bawalipŋe hâŋgânnongomu kapi âlâen âlâen ari yâkât den pat âlepŋe kâsikum yiŋgiwin. Kâsikum yiŋgim pesuk pilâm âwurem Yesuhâlen tohowin. Yâkâlen toho den kâsikum yiŋgiwin me otbin mewin yakât ekuwin. ");
INSERT INTO spl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Orowâk den alahum tatmunŋe yan lohimbi dondâŋe bam gam hâmbiŋ gumbiŋ tuhunenekŋetâ sot ki um newin. Inâk tatbin yakât otmâ Yesuŋe yuwu sâm eknongop. “Lohimbi dondâŋe nengâlen taka mem awawi guwawi tuhunenekŋetâ girawu otmâ sot nenom? Me girawu otmâ tatmâ nâŋgâm den alahunom? Yakât otmâ pilâyekmâ ari nenŋiâk tatmâ nâŋgâm hâknenŋe menom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yawu sâmu kapi ya pilâm ge waŋga âlâ mem deŋgân ya hâtikgum lok ki manmaiângen ariwin. ");
INSERT INTO spl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kapi ya pilâmunŋe lohimbi nombotŋaŋe nenekmâ ya pilâm deŋgân ginŋeâk watnenekmâ ariwi. Ariŋetâ kapi âlâlâ deŋgân ginŋan tatmâ arap ya ambolipŋaŋe kapiyeŋe pilâm peneyiŋgiŋetâ ari ari deŋgân ginŋan kinmâ mambotningiwi. ");
INSERT INTO spl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yawu otmâ kinŋetâ waŋgaembâ gemunŋe Yesuŋe yekmâ yuwu nâŋgâop. “Lama amboyeŋe biaŋe manmai yakât dopŋeâk lohimbi yuŋe ihilâk mahilâk mansai.” Yekmâ weŋe nâŋgâm Anitâhât den topŋambâek kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Kâsikum yiŋgimu emetsâpŋe otmu yan yuwu sâm ekuwin. “Emetsenŋe emelâk purik yap. Gârâmâ yu tain yu hâlâŋmâ kapi tipi tapi âlâ ki tap. Yakât po yiŋgimu wâtyeŋe houŋ sâmapgât gâŋe hâŋgânyongorâ ariŋet. Hâŋgânyongorâ ari yeŋahâk sot puluhum um nenomai.” ");
INSERT INTO spl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yawu ekumunŋe yuwu sâm eknongop. “Âlepŋe yeŋahâk sot kâsikum yiŋgiŋet.” Sâmu sâwin. “Lohimbi dondâ taka tai. Yakât otmuâmâ nen girawu otmuâmâ lohimbi dondâ yuâmâ sot um yiŋgimunŋe neŋetâ dopyeŋan otbuap? Nenŋe sot puluhum um yiŋginom yuâmâ lok âlâŋe emetsenŋe nombolân yâhâp yakât biwiŋan âi tuhum pesuk pilâm hâmeŋe memap yakât dop otbuap. Yawu gârâmâ girawu otmuâmâ yat yu watnom? Yu ki orotŋe.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sâmunŋe sâop. “Yeŋgâlen sot amon tap? Ba ekmâmâ ga sâŋetâ nâŋgâwe.” Sâmu ba sâlikum ekmâ ga yuwu sâm ekuwin. “Nengâlen baŋga kândâkdâ mome otmu iŋan yâhâp yawuâk tap.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sâmunŋe sâop. “Yeŋe lohimbi yu ekyongoŋetâ kâsiwahom komot tipi tapi tatmâ ariŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yawu sâmu komot tipi tapi tatŋetâ komot 50 olop. ");
INSERT INTO spl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ge tatŋetâ sot ya mem himbimân pak sâm ekmâ Anitâ mepaeop. Anitâ mepaem baŋga ya motokmâ tipi tapi tuhum ningimu lohimbi ya kerehâk yiŋgimunŋe newi. ");
INSERT INTO spl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yâhâ iŋan gurâ yawuâk yiŋgimunŋe neŋetâ dopyeŋan olop. ");
INSERT INTO spl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Neŋetâ dopyeŋan otmu sot nombotŋe talop ya hâwurum mânuŋmunŋe saka saka kâiân yâhâp pik sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Otmu lok sot newi yamâ sâlipyongomunŋe 5000 yakât dop olop. ");
INSERT INTO spl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sot nem pesuk pilâŋetâ Yesuŋe hâŋgânnongom yuwu sâop. “Yeŋe waŋga yu mem kulet sâm Besaita kapiân ariŋet Ariŋetâ nâmâ lohimbi yu hâŋgânyongomune ariŋetâ yeŋgât betyeŋan watyekbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","“Yawu sâm hâŋgânnongomu arimunŋe lohimbi ya gurâ hâŋgânyongomu yahatmâ itoŋ galaŋ otmâ ariwi. Ariŋetâ ikŋiâk tatmâ Anitâ ekuwe sâm pumŋan yâhâop. ");
INSERT INTO spl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pumŋan yâhâ âwâŋe orop den otmutâ emet omoŋ olop. Âwâŋe orop den otmutâ pesuk sâmu gem deŋgân ginŋehen kinmâ nenehop. Nenâmâ ari deŋgân tânâmgum nip nip otbin. ");
INSERT INTO spl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yawu arim tatmunŋe ariwinângembâ siru pato awawi guwawi pilâop. Awawi guwawi pilâmu arine sâm ba hâum pâpgum tatmunŋe emet emelâk orotok sâop. Yawu otmu tânâmŋan hâum pâpgu gupgu ot tatmunŋe Yesu ikŋak to kakŋambâ tâlim takamu ekbin. ");
INSERT INTO spl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","To kakŋambâ takamu ekmâ tepnenŋe hindakmâ hu halak tuhum yuwu sâwin. O, yuâmâ weke mon takap.” Yawu sâm kiŋgitnenŋahât otmâ kâi bâtnenŋe sân sân sâop. Yawu otmunŋe yuwu sâm eknongop. “Yen wongât otmâ kiŋgityeŋahât otmâ kâi bâtyeŋe sân sân yap? Nâ ninak takan yukâ.” ");
INSERT INTO spl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yawu sâm waŋgaen mem pitik pilâmu siru ya sânduk sâm ŋiniŋ ŋiniŋ sâop. Sânduk sâm ŋiniŋ ŋiniŋ sâop ya ekmunŋe âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yawu gârâmâ emelâk baŋga mome motokmâ kâsikum yiŋgimu lok 5000 yaŋe neŋetâ dopyeŋan olop ya ekmâ Yesuhât topŋe nâŋgâwin mâne saru kakŋan takamu siru ŋiniŋ ŋiniŋ sâop ya ekmunŋe ki âlâ kândâkdâ otbâp. Yawu gârâmâ biwi nâŋgân nâŋgânnenŋe pâlâmŋe olopgât Yesuŋe yu ya olop yakât topŋe ki ekmâ nâŋgâmunŋe keterahop. ");
INSERT INTO spl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Deŋgân ya hâtikgum hân âlâ, kutŋe Genesaret sâm, yan ari kioŋmâ waŋga hikumunŋe kinop. ");
INSERT INTO spl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hikumunŋe kinmu kapi ya ambolipŋe taka Yesu ekmâ nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ekmâ nâŋgâm kapi tipi tapi hân ya hawamgum tatmâ arap yan ari lohimbi kundat, me mesek, me umatŋe topŋe topŋe teteyiŋgiop ya meyekbi. Ya mem gerelân katyekmâ Yesuŋe wosaken ariop yan lâuyekmâ ari heŋgemyongoâkgât yuwu sâm ulitguwi. ");
INSERT INTO spl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","“Lok pato, Nengâlen gâtŋe kundat me umatŋe topŋe topŋe teteyiŋgimu tatmai yu meyekmâ tohoain. Yawu gârâmâ sombemân menduhum katyekmunŋe gotyeŋanâk arirâ gâhât sâŋgum ya konok wâim yan âlepŋe otŋetgât naŋgain.” Sâŋetâ sâop. “Den yai ya âlepŋe otŋet.” Yawu sâmu nombotŋaŋe sâŋgumŋe wâim yaŋak âlepŋe otbi. ");
INSERT INTO spl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Parisaio kerekŋe tâmbâlipnenŋe yeŋgât den lâum kinmâ sot mem nene sâm bâtyeŋe piriakmâ sot mem neminiwi. Me wosapâ wosapâ ari sot puluhuminiwi ya yawuâk aŋgoân pirim heŋgeŋgumâmâ um neminiwi. Inâk ki newi. Yâhâ tâmbâlipnenŋe yeŋgât orotmeme otminiwi ya gurâ yawuâk mem manbi yamâ yuwu. Katmâ bero, kondo, hâhâp, osom bero, me âlâlâ ya tuhuwi ya gurâ yawuâk pirim salek salehâk tuhum yan neminiwi. Otmu buku nombotŋaŋe yawuâk otŋet sâm kendâyiŋgiŋetâ yaŋak lok kiŋgitŋe orowâkŋe denyeŋe lâum yawuâk otminiwi. Parisaio ya yeŋgât topyeŋe yawu. Yâhâ Parisaio otmu Mosehât girem den kâsikum ningiminiwi nombotŋaŋe Yerusalem kapi pilâm Yesuhâlen taka âi pâi tuhuwi. Âi pâi tuhuŋetâ yan nenŋe tâmbâlipnenŋe yeŋgât den kum bâtnenŋe ki pirim newin. ");
INSERT INTO spl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yawu otmunŋe nenekmâ nâŋgâŋetâ bâlemu Yesu yuwu sâm âikuwi. “Hoŋ bawalipgaŋe tâmbâlipnenŋe yeŋgât den kum bâtyeŋe ki pirim niai. Yawu otmâ sot inâk neŋetâ nâŋgâmunŋe dondâ bâleap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sâŋetâ purik pilâyiŋgim yuwu sâm ekyongop. “Yenâmâ nimbilamyeŋe yâhâp. Yakât otmuâmâ embâŋân emet inânŋan poropete lok âlâ, kutŋe Yesaia sâm, yâkŋe yeŋgât topyeŋe teteâkgât den kulemguop ya yuwu. “Lohimbi yuŋe lauyeŋaŋak nâ mepaenekmai. Yâhâ biwiyeŋaŋeâmâ ki hikunekmai. ");
INSERT INTO spl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yâkŋe lok senyeŋan kinmâ yeŋe eŋgâtyeŋeâk otmâ den sâm nâhâlen gâitmai. Yâhâ lauyeŋaŋak perâk perâk sâm orotmemeyeŋe yakâlâk nâŋgâŋetâ yahatmu nâhâlen gâitmai. Yawu.” ");
INSERT INTO spl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Den kulemguop yakât bulâŋe yeŋgâlen teteap. Yeŋe Anitâhât den bulâŋe yamâ betbaŋgim tâmbâlipyeŋe yeŋgât nâŋgân nâŋgânyeŋan teteop ya nâŋgâŋetâ yahatmu ya konok lâum manmai. ");
INSERT INTO spl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yakât otmâ yuwu sâmune nâŋgâŋet. Yeŋe Anitâhât den bulâŋe ya katipgum yeŋe nâŋgân nâŋgânyeŋan tetemap ya sâm lohimbi biwiyeŋan kioŋetâ nâŋgâŋetâ bulâŋe otmap. ");
INSERT INTO spl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yakât topŋe yuwu sâwe. Anitâŋe Mose ekumu girem den âlâ kulemguop ya yuwu tap. “Yen âwâ mâmâlipyeŋe yeŋgât nâŋgâyiŋgim denyeŋe lâum manŋet.” Otmu âlâmâ yuwu tap. “Yen âwâ mâmâlipyeŋe den bâleŋe ki hâiyeknomai. Yâhâ yeŋgâlen gâtŋe âlâ me âlâŋe den yu kunomai yanâmâ mumuhât yongonomai.” Den yawu tap. ");
INSERT INTO spl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yawu gârâmâ yeŋe girem den ya kum mansai yakât sâwe. Yeŋe yuwu sâmai. “Lohimbi âlâ me âlâŋe âwâŋe mâmâŋe yuwu mon sâm ekyotgonomai. “Awoŋ, meŋ, sombo otdomawot yanâmâ nâŋe sot me senŋe âlâlâ âlepŋe tânyotgowom.” Yawu sâm ekyotgonomai.” Yawu gârâmâ sombo otdomawolân Yura nengât denân yuwu mon sâm ekyotgonomai. “Koropan” Yawu ekyotgonomai yakât topŋe yuwu, “Anitâhât pat kuwan.” Topŋe yawu. Yâhâ torokatmâ yuwu mon sâm ekyotgonomai. “Senŋe âlâlâ yuâmâ Anitâhât pat kuwan yakât otmuâmâ mem miti emetŋan ari katmune tatbuap yakât yaŋe ki mem tânyotgowom. Inâk tatset.” ");
INSERT INTO spl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yawu sâm betyotgoŋetâ hâhiwin kakŋan mandomawot. Yawu yâhâ sâp yiwereŋe nanlipyeŋaŋe âwâ mâmâlipyeŋe betyiŋgim tewetsenŋe mem miti emetŋanâk katŋetgât yeŋe kendâyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yamâ Anitâŋeâmâ yakât nâŋgâmu dondâ gemap. Yeŋe Anitâhât den nâŋgâŋetâ nahat otmu yawu otmai. Yâhâ yeŋe orotmemeyeŋe âlâlâ otmai yan Anitâhât den bulâŋe betbaŋgim yeŋahâlâk nâŋgâŋetâ yahatmap.” ");
INSERT INTO spl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuŋe Parisaio lok yawu sâm ekyongomu ariŋetâ lohimbi inŋe manbi ya yâhâpŋe sâmu yâkâlen gaŋetâ yuwu sâm ekyongop. “Yuwu sâmune nâŋgâm biwiyeŋan katŋet. ");
INSERT INTO spl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wuân me wuân neŋetâ tepyeŋan gemap yaŋeâmâ ki mem bâleyekmap. Yâhâ nâŋgân nâŋgânyeŋan tetemap ya sâŋetâ lauyeŋambâ ga takamap yaŋeâmâ bulâŋanâk mem bâleyekmap. ");
INSERT INTO spl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Den yan yu biwiyeŋan katnomai yanâmâ topŋe nâŋgâm heŋgeŋgunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yawu sâm ekyongomu pilâyekmâ emet kâlehen yâhâwin. Emet kâlehen yâhâ den ekyongop yakât topŋe eknongomu nâŋgâne sâm âikuwin. ");
INSERT INTO spl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Âikumunŋe sâop. “Bâe, hilâm ârândâŋ den ekyongom gaman yamâ girawu otmuâmâ ki nâŋgâŋetâ keterakmap? Lohimbi inŋe nâŋgâm pâpgumai yakât dopŋeâk yeŋe nâŋgâm pâpgumai. Yakât âlâkuâk sâmune nâŋgâŋet. Sot neŋetâ tepyeŋan gemap yaŋak tetmâ pilâmai. Yawu gârâmâ sot nemai yaŋe biwi nâŋgân nâŋgânyeŋe ki mem bâleyekmap.” Yawu sâm eknongop. Yakât yuwu nâŋgâmain. Sot, me hân tete topŋe topŋe, me nâi soŋgo topŋe topŋe kalop yamâ âlepŋeâk hârok. Yaŋe ki mem bâlenenekmap. Yawu nâŋgâmain. ");
INSERT INTO spl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Otmu Yesuŋe torokatmâ yuwu sâop. “Yu me ya nâŋgân nâŋgânyeŋambâ tetemap yamâ lauyeŋambâ ga takamap. Yaŋeâmâ dondâ mem bâleyekmap. ");
INSERT INTO spl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Orotmemeyeŋe yuwu otmai yaŋe umut biwiyeŋe otmu nâŋgân nâŋgânyeŋe mem bâlemap. Manman ihilâk mahilâk manmai. Me kombo miaŋgimai. Me ahomai. ");
INSERT INTO spl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Me buku âlâhât imbi ekmâ otmai. Me loklipyeŋe yeŋgât betyeŋehen kioŋmai. Me tepyeŋe umatŋe otmap, me nem ŋatak, me wawi. Me kâirahomai, me nâŋgâm bâleaŋgimai, me den hakoa oraŋgimai, me den guruk sahaŋgimai, me den belângen sahaŋgimai, me den imbiâk sâmai, me den golâ sâmai. Me karasuŋa, me sait topŋe topŋe karaŋgimai. Me kâut pilaŋgimai. ");
INSERT INTO spl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yu sâm aran yuŋeâmâ lok nâŋgân nâŋgânyeŋambâ tetemap. Yakât otmâ yuŋe mem bâleyekmap.” ");
INSERT INTO spl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yawu sâm menenekmu kapi ya pilâm Tiro kapi pato ya hâlâŋmâ kapi tipi tapi tatmâ arap yan ariwin. Yan arimunŋe lohimbi dondâŋe taka mem hâmbiŋ gumbiŋ tuhunenekmaihât Yesuŋe sâmu emet âlâen yâhâwin. Yâhâmunŋe lohimbi nombotŋaŋe Yesu ekmâ den katŋetâ arimu lohimbi dondâŋe nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yâhâ imbi âlâ, Poinikia kapi Siria hânân tap yapâ gâtŋe âlâŋe Yesu taka talop yakât den pat ya nâŋgâm takaop. Yâhâ weke bâleŋaŋe baratŋe mâŋgâeminiop ya Yesuŋe watmu gaiakmâ ariâkgât ulitguop. ");
INSERT INTO spl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ulitgumu yuwu sâm ekuop. “Gâmâ pâku imbi. Yawu gârâmâ Awarahamgât sen ya yeŋgâlen sâm ge âi membomgât hâŋgânnohomu gewan. Yakât otmâ den âlâen hâum sâmune nâŋgârâ keterahâk. Nan baralipnenŋe sot um yiŋgimunŋe nemai. Nem tatŋetâ lauyeŋambâ hindâm soso gotŋan ki pilâmain.” ");
INSERT INTO spl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sâmu sâop. “Lok pato, den yat yu nâŋgâmune bulâŋe oap. Gârâmâ gâku yuwu sâmune nâŋgâ. Nan baralipyeŋe sot neŋetâ lauyeŋambâ wahapŋe gemap ya gurâ sosoŋe ihilâk nemai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sâmu sâop. “Imbi, biwihaŋe yawu nâŋgâm den yat yu nâŋgâmune ârândâŋ oap. Yakât otmâ weke bâleŋe yiwereŋeâk gaiakmâ arap. Yakât otmâ lohotŋan ari.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yawu sâmu yanâk emetŋan âwurem ari baratŋe ya ehop. Emelâk weke bâleŋe gaiakmâ arimu hâkŋe sânduk sâmu talop. ");
INSERT INTO spl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuŋe Galilaia deŋgân yan âwurem ariwe sâm otmâ menenekmu Tiro kapi pilâm ba Siron kapi wangim ari kapi bâlâk ŋerek tap, yapâ ari Galilaia deŋgân ginŋan ga takawin. ");
INSERT INTO spl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ga takamunŋe lok âlâ ândâpŋe bok sâsâŋe kopa kum den awawi guwawi sâminiop ya bukulipŋaŋe mem Yesuhâlen takawi. Mem taka Yesuŋe wâimu ândâpŋe pâroŋ sâmu nimbilamŋe keterakmâ heweweŋ olâk sâm ulitguwi. ");
INSERT INTO spl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ulitguŋetâ lohimbi ya pilâyekmâ memu ba pereŋ pilâm baowot. Ba ikŋe bâtŋan tâp tuhum lok yakât ândâpŋan wâim yaŋak nimbilamŋan wâiop. ");
INSERT INTO spl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yawu otmâ himbimân pak sâm ekmâ “Epapata” sâop. Den sâop yakât topŋe yuwu. “Pâroŋ sâek.” ");
INSERT INTO spl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yawu sâmu ândâpŋe pâroŋ sâop. Yawu otmu lauŋe heweweŋ otmu den sâop. ");
INSERT INTO spl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yawu otmâ âwurem gamutâ Yesuŋe kulem miop yakât buku nombotŋe ki ekyongonomai sâm lohimbi ya kuyiŋgiop. Kuyiŋgiap yamâ denŋe ki nâŋgâwi. Yawu otmâ den ya sâm haok tuhuŋetâ lohimbi dondâŋe nâŋgâwi. Yakât otmâ kuyiŋgim yâhâmu nâŋgâwi yamâ iliwetmâ sâm haok tuhuwi. ");
INSERT INTO spl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sâm haok tuhuŋetâ nâŋgâm yuwu sâwi. “Lok yuŋe lohimbi umatŋe topŋe topŋe teteyiŋgimu mansai ya heŋgemyongom mansap yakât nâŋgâmunŋe âiloŋgo dondâ oap. Lohimbi ândâpyeŋe bok sâmu mansai ya sâmu pâroŋ sâmu den nâŋgâmai. Otmu kopa otmâ mansai ya sâmu lauyeŋe heweweŋ otmu den sâmai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yesuŋe lok kopa ya mem heŋgeŋguop yakât den pat ya lohimbi kiŋgitŋe orowâkŋe nâŋgâm Yesuhât denŋe nâŋgâne sâm taka menduhuakbi. Menduhuakmâ tatŋetâ den kâsikum yiŋgimu hilâm kalimbu pesuk sâmu sotyeŋe nem tiŋ pilâwi. Yakât otmuâmâ Yesuŋe sâmu yâkâlen bamunŋe yuwu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Lohimbi yu orowâk tatmâ gamunŋe hilâm kalimbu oap. Yawu gârâmâ sot miakmâ takawi ya nem tiŋ pilai. Yakât tepne nâŋgâyiŋgian. ");
INSERT INTO spl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yâhâ nombotŋe tai yuâmâ kâlepŋehembâ tohowi. Sot barak âwurem ari mâtâwân sen biri yiŋgimapgât inâk ki arinomai.” ");
INSERT INTO spl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yawu sâmu yuwu sâm ekuwin. “Yuâmâ lok ki manmaiângen mansain. Yawuhât nen sot wosapâ mem yiŋgimunŋe neŋetâ dopyeŋan otbuap?” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sâmunŋe sâop. “Yeŋgâlen wuân sot tap?” Sâmu sâwin. “Baŋga kândâkdâmâ nombolân yâhâp.” ");
INSERT INTO spl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yawu sâmunŋe Yesuŋe lohimbi ekyongomu ge tatbi. Ekyongomu ge tatŋetâ Anitâ mepaem baŋga ya mem motokmâ ningiop. Ningimu kâsikum yiŋgimunŋe newi. ");
INSERT INTO spl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Otmu iŋan titipâ amon âlâek nengâlen talop ya mem Anitâ mepaem hioŋmâ ningimu kâsikum yiŋgimunŋe newi. ");
INSERT INTO spl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Neŋetâ dopyeŋan otmu hâŋgânyongomu ariwi. Sot neŋetâ torehenŋe talop ya menduhum mânuŋmunŋe saka saka nombolân yâhâp pik sâop. ");
INSERT INTO spl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yâhâ lohimbi ya sâlipyongomunŋe 4000 yakât dop wangiop. ");
INSERT INTO spl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lohimbi yaŋe ariŋetâmâ menenekmu waŋgaen yâhâ kapi âlâ, kutŋe Dalimanuta, yaken ariwin. ");
INSERT INTO spl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dalimanuta kapi mem waŋgaembâ gemunŋe Parisaio nombotŋaŋe Yesu ekmâ yuwu sâwi. “Gâ Anitâŋe hâŋgângohomu gion ya perâk me bulâŋanâk sâmai? Yakât sârâ Anitâŋe nâŋgâhihimu himbimâmbâ kulem âlâ tetemu ekmâ topge nâŋgâne.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yawu sâŋetâ biwiyeŋe ekmâ nâŋgâm biwiŋe umatŋe otmu yuwu sâm ekyongop. “Bâe, yeŋeâmâ wongât kulem tetemu ekne sâm naŋgai? Ya nâŋgâmune ki ârândâŋ oap yakât ya ki otbom.” ");
INSERT INTO spl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yawu sâm pilâyekmu waŋgaen yâhâm deŋgân nombot hâtikgum ariwin. ");
INSERT INTO spl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Waŋgaen ariwin yamâ sot getek âlâ miakmâ ariwin. ");
INSERT INTO spl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yakât otmâ Yesuŋe yuwu sâm eknongop. “Parisaio otmu Herot yâk yeŋgât matuk keluŋaŋe mem bâleyekmapgât galem oraŋginomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yawu sâmu nenŋe yakât topŋe nâŋgâm pâpgum yuwu sâm alahuwin. “Sot getek âlâ miain. Yakât mon yap.” ");
INSERT INTO spl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","18","Yawu sâm alahumunŋe biwinenŋahât topŋe ekmâ yuwu sâm eknongop. “Yen wongât sotgâlâk biwiyeŋe katmâ den yan yukât topŋe ki nâŋgâŋetâ keteraksap? Me kulem topŋe topŋe mem gaman ya ekmâ topŋe ki nâŋgâmai? Wongât in yawu nelâm yongomap? Yakât sâwe. ");
INSERT INTO spl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sot momeâk mem motokmâ lok 5000 ya yiŋgimunŋe neŋetâ dopyeŋan olop. Sot neŋetâ torehenŋe talop ya saka saka amon mânuŋetâ pik sâop?” Sâmu sâwin. “Kâiân yâhâp pik sâop,” sâwin. ");
INSERT INTO spl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sâmunŋe sâop. “Sâp âlâen lohimbi 4000 ya gurâ baŋga nombolân yâhâp yaŋahâk yiŋgimunŋe newi. Neŋetâ torehenŋe talop ya saka saka amon mem mânuŋetâ pik sâop?” Sâmu sâwin. “Nombolân yâhâp pik sâop yakâ,” sâwin. ");
INSERT INTO spl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sâmunŋe sâop. “Yakât otmâ den yan yukât topŋe emelâk nâŋgâmbâiâyâ.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yawu sâm eknongomu ari Besaita kapi mewin. Waŋgaembâ gemunŋe yan kapi ambolipŋaŋe Yesu ekmâ nâŋgâm lok âlâ senŋe bok sâsâŋe ya dâim toho Yesuŋe wâimu âlepŋe olâkgât ulitguwi. ");
INSERT INTO spl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ulitguŋetâ lok ya dâim ari kapi betŋehen kinmâ bâtŋan tâp tuhum senŋan wâim yuwu sâm âikuop. “Senge hâreakmu âlâlâ ekdâ keteraksap me bia?” ");
INSERT INTO spl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yawu âikumu senŋe tipiŋe hâreakmu ekmâ sâop. “Âe, nâ lok yu yekmuneâmâ âwâlele otmâ nak yawuya uwawap guwawap otmâ tai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yawu sâmu yâhâpŋe bâtŋan tâp tuhum senŋan wâiop. Wâimu senŋe hâreakmu pak sâm ekmu keterahop yakât otmâ yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","“Gâ kapiân ki yâhâwuat. Kapi betŋehembâ hawamgum ari emetgan yâhâwuat.” Yawu sâm ekum hâŋgângumu ariop. ");
INSERT INTO spl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Arimuâmâ nengu yapâ yahatmâ kapi pato âlâ, kutŋe Kaisaria sâm, kutŋe âlâmâ Pilipo, yakât kapi tipi tapi hâlâŋmâ tatmâ arap yan ariwin. Mâtâwân arim tatmunŋe yuwu sâm âinongop. “Lohimbiŋe nâhât girawu nâŋgâmai?” ");
INSERT INTO spl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sâmu sâwin. “Nombotŋaŋe gâhât yuwu sâmai. “Yoaneŋe lohimbi toen katyekminiop ya emelâk kuŋetâ muop ya mumuŋambâ yahatmâ mansap,” yawu sâmai. Yâhâ nombotŋaŋeâmâ, “Poropete âlâ, kutŋe Elea sâm, emelâk himbimân yâhâop yaŋe purik sâm ge mansap,” sâmai. Yâhâ nombotŋaŋeâmâ, “Poropete âlâ muop ya mumuŋambâ yahatmâ mansap,” sâmai.” ");
INSERT INTO spl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sâmunŋe sâop. “Yawu gârâmâ yeŋeâmâ nâhât girawu nâŋgâmai?” Sâmu Petoroŋe yuwu sâop. “Anitâŋe hâŋgângohomu ge mansat ya nâŋgâmunŋe bulâŋe oap.” Yawu tetekŋan sâop. ");
INSERT INTO spl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sâmu yuwu sâm kuningiop. “Yeŋe nâhât topne ki sâm tetem lohimbi ekyongonomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Otmu sâp yapâek âlâlâ otbaŋginomai yakât tetekŋan eknongop. Yamâ yuwu sâm eknongop. “Nâ lok bulâŋe mansan. Yawu gârâmâ hotom umai yeŋgât kunlipyeŋe otmu Isirae nengât papatolipnenŋe otmu Mosehât girem den kâsikum ningimai ya kerekŋe biwi konohâk otmâ yan nâhât sâm bâlenihim mem âlâlâ tuhum nohoŋetâ mumbom. Mum yan hân kâlehen hilâm kalimbu tatmâ benŋe yapâ mumuŋambâ yahatbom.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yawu sâm eknongomu Petoroŋe sâmu pereŋ pilâm yetŋiâk ba kinmâ kuwaŋgiwe sâm olop. ");
INSERT INTO spl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kuwaŋgiwe sâm otmu yanâk Yesuŋe nengât orowâk nâŋgâŋet sâm purik pilâm nenekmâ yuwu sâm den matŋe kâpekbaŋgiop. “Yawu yatgât Satanŋe tepŋe heroŋe otbuap. Yâhâ Anitâŋe den sâm nihiop ya den yat yuŋe ki miap. Gâmâ lokgât nâŋgân nâŋgân yat. Ya nâŋgâmune ki ârândâŋ oap. Yakât otmâ pilânekmâ ari.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yawu sâm ekumu peneningimutâ Yesuŋe lohimbi dondâ mambotbaŋgim kinbi ya ekyongomu gotnenŋan gaŋetâ yuwu sâm eknongop. “Lohimbi âlâ me âlâŋe biwiyeŋe nâhâlen katmâ orowâk manne sâm yeŋahât ki nâŋgâŋetâ yahatbuap. Me iri sikum me âlâlâ tatyiŋgiap yakât ki nâŋgâm ketet otmâ eŋgat yâhâp otnomai. Nâhât den haoŋmâ ârândâŋ nâŋgâm tem lâunihim mannomai. ");
INSERT INTO spl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yawu gârâmâ benŋe lok âlâ me âlâŋe manmanyeŋe alilaknomai yamâ hiliwahonomai. Yâhâ lok âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim manmâ nâhât den pat âlepŋe yu lohimbi ekyongonomai. Ekyongonomai yakât otmâ yongoŋetâ munomai yamâ Anitâŋe mumuŋambâ mem yahatyekbuap. ");
INSERT INTO spl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yâhâ lok âlâ me âlâŋe iri sikum me manman topŋe topŋe yan biwi nâŋgân nâŋgânyeŋe hikum manmâ munomai yaŋe girawu otnomai. Yeŋahâk mumuŋambâ yahatnomaihât dop âlâ ki tap. ");
INSERT INTO spl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yawu gârâmâ manman yawuyakât matŋe umatŋe Anitâŋe yiŋgiwuapgât. ");
INSERT INTO spl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lohimbi yu yeŋgât topyeŋe teteâkgât yuwuyaen hâum sâwe. Imbi nombotŋaŋe loklipyeŋe betyeŋehen kioŋmai yakât dopŋeâk yeŋeâmâ Anitâhât betŋehen kioŋmâ orotmemeyeŋe otmai ya ekmune dondâ bâleap. Yawu gârâmâ nâ lok bulâŋe den kâsikum yiŋgim mansan. Yeŋgâlen gâtŋe âlâ me âlâŋe nâhât den nâŋgâŋetâ nahat otmu betnihinomai yamâ matŋe yuwu kâpekyiŋgiwom. Hâmbâi sâp patoen Himbim Awoŋnaŋe yâhâpŋe hâŋgânnohomu aŋelolipne meyekmune hânân genom. Sâp yan yeŋgâlen gâtŋe âlâ me âlâŋe nâhât den nâŋgâŋetâ nahat otmu betnihimai yamâ nâku yawuâk betyongomune matŋe umatŋe menomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuŋe yawu sâm eknongomu lohimbi yaŋe itoŋ galaŋ otmâ ariwi. Ariŋetâmâ yuwu sâm eknongop. “Yakât topŋe sâmune nâŋgâŋet. Yen ki mum meteŋetâek Anitâŋe tihityeŋe otbe sâm lok bulâŋe nâ hâŋgânnohomu âwurem ge tihityeŋe otbisâm.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yâhâ hilâm nombolân konok pesuk sâmu yakât kakŋan Yesuŋe Petoro, Yakowo otmu imiŋe Yoane meyekmu nen pilânenekmâ pumŋe âlâen yâhâwi. ");
INSERT INTO spl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yâhâ kinŋetâ Yesuhât kun kundenŋe âlâ otmu sâŋgumŋaŋe laŋinŋe pilâm kaok bolaŋ bolaŋ otmu sikopŋe elemân hâumu kaok siliŋ siliŋ otmap yakât dopŋe ki olop, ya wangiop. ");
INSERT INTO spl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yawu otmu Elea otmu Mose emelâk Anitâŋe meyelehop yaŋe tetem kinmutâ yâk orop den alahu gulahu otbi. ");
INSERT INTO spl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Mose yet Elea tetemutâ hoŋ bawalipŋaŋe yelekmâ umutyeŋe ariop. Umutyeŋe arimu hâmbiŋ gumbiŋ otbi. Yakât otmâ Petorohât hanŋe tâlâhumu yuwu sâm Yesu ekuop. “Lok pato, kulem teteap yuwuya âlâ ki ekmain. Yu ekmunŋe âlâ kândâkdâ oap. Yawu gârâmâ gâŋe sârâ selep kalimbu tuhunehât naŋgan. Gâhât âlâ, Mosehât âlâ, Eleahât âlâ.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yawu sâmu yanâk elem patoŋe ge pumŋe ya kâtâpgumu yakât biwiŋambâ Anitâŋe den âlâ yuwu sâop. “Bulâŋanâk yuâmâ nine nanne ombe bisine. Yakât otmuâmâ den sâwuap ya yeŋe mem biwiyeŋan katmâ tem lâuwaŋgim mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yawu sâmu elem ya hâreakmu Yesu ikŋeâk kinmu ekbi. ");
INSERT INTO spl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yaŋak pumŋambâ âwurem ge mâtâwân tatŋetâ Yesuŋe yuwu sâm ekyongop. “Pumŋan kulem âlâ tetemu eksai yakât lok ihilâk ki ekyongonomai. Hâmbâi nohoŋetâ mum yahatbom yakât kakŋanâmâ kulem eksai yukât topŋe ekyongoŋetâ nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yawu sâmu ki ekyongowi. Yâhâ ikŋak “mum yahatbom” sâop yakât nâŋgâm kiwilim yeŋiâk alahuwi. ");
INSERT INTO spl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yawu gârâmâ Elea tetemu ekbi yakât nâŋgâm Yesu yuwu sâm âikuwi. “Mosehât girem den kâsikum ningimaiŋeâmâ yuwu sâmai. “Anitâŋe tihitnenŋe otbe sâm hoŋ bawa âlâ hâŋgângumu gewuap yamâ Eleaŋe yâhâpŋe tetewuap yan kulet sâm mâtâp mewaŋgiwuap.” Yawu sâmai. Yamâ girawuhât sâmai?” ");
INSERT INTO spl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Sâŋetâ sâop. “Yamâ bulâŋanâk yai. Elea yâhâpŋe tetewuawân yai yakât mâtâp mewaŋgiwuap. Yawu gârâmâ yuwu sâmune nâŋgâŋet. Emelâk Anitâŋe poropete den ekyongomu kulemguwi yakât topŋe yuwu tap. Anitâŋe tihitnenŋe otbe sâm hoŋ bawa âlâ hâŋgângumu gewuap yamâ Yura ambolipŋaŋe mem âlâlâ tuhum betguŋetâ sâtgum mumbuap. Den yawu tap yakât topŋe girawu tap? Yakât yuwu sâmune nâŋgâŋet. Elea yamâ emelâk manop. Yâhâ Elea manop yakât dopŋeâk lok âlâŋe tetem manmu ekbi yamâ yeŋgât papatolipyeŋaŋe nâŋgâm hilipgum eŋgatyeŋeâk otmâ mem âlâlâ tuhuwi. Mem âlâlâ tuhuwi yan emelâk den kulemguwi yakât bonŋe teteop.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mâtâwân gem tatŋetâ yan lohimbi dondâŋe lok âlâhât nanŋe nengâlen dâim takaŋetâ tângune sâm hâum pâpgum pilâwin. Hâum pâpgum pilâmunŋe yanâk Mosehât girem den kâsikum ningiminiwi nombotŋaŋe sennenŋan geŋetâ sahaŋgim kinmunŋe bukulipnenŋe pumŋehembâ gem peneningiwi. ");
INSERT INTO spl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Peneningiŋetâmâ lohimbi yaŋe Yesu ekŋetâ tepyeŋe yahatmu yâkâlen ba heroŋe otbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Heroŋe otbaŋgiŋetâ Yesuŋe yuwu sâm âinongop. “Yeŋe Mosehât girem den kâsikum ningimai ya orop girawuhât den sahaŋgiai?” ");
INSERT INTO spl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yawu sâm âinongomu yanâk naom yakât âwâŋaŋe yuwu sâop. “Lok pato, hoŋ bawalipgaŋe tânnotgoŋet sâm nanne yu dâim takan yakât topŋe yuwu. ");
INSERT INTO spl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Weke bâleŋaŋe nanne mâŋgâemu kopa manmâ gamap. Yâhâ mâŋgâemap yan senŋe gâwâŋ gâwâŋ sâm hânân ge imu nekamŋe kâtiŋ sâm lauŋe barak barak otmap. Yawuhât hoŋ bawalipge yuŋe weke bâleŋe yu watŋet sâm dâim taka ekyongomune hâum pâpgum pilai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yawu sâmu Yesuŋe ya nâŋgâmu ki ârândâŋ otmu olelem nenekmâ yuwu eknongop. “Yen orop sâp kâlep manmâ gam. Yamâ wongât biwi nâŋgân nâŋgânyeŋaŋe ki tânnongowuap naŋgai? Yawu nâŋgâm biwiyeŋaŋe nâhâlen tiŋâk ki kepeiai yakât nâŋgâm biwine giap. Yawu gârâmâ pilâyekmâ yâhâwom yan girawu mannomai?” Yawu sâm eknongom âwâŋe ekumu nanŋe dâim gaop. ");
INSERT INTO spl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naom ya dâim gamu weke bâleŋaŋe Yesu ekmâ mâŋgâemu senŋe gâwâŋ gâwâŋ sâm hânân ge kârâŋ kârâŋ sâm lauŋe barak barak otmu iop. ");
INSERT INTO spl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yawu otmu Yesuŋe âwâŋe yuwu sâm âikuop. “Umatŋe yu amâti tetewaŋgiop?” Sâmu sâop. Lepatŋambâek tetewaŋgimu yuwu otmâ gamap. ");
INSERT INTO spl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Weke bâleŋaŋe sâpŋanâk mem mâŋgâemu toen ge hanahomap. Me senŋe gâwâŋ gâwâŋ sâm kâlâwân kioŋmap. Yawu otmap yan bâsok hiliwahomap. Yawu gârâmâ tepge nâŋgânitgim tânnotgowuatgât dop tap me bia?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sâmu sâop. “Gâŋe wongât biwi yâhâp otmâ den yu âinohoat? Yakât yuwu sâmune nâŋgâ. Lok âlâ me âlâŋe nâhâlen biwi nâŋgân nâŋgânyeŋaŋe kepeimaiŋe yu me ya otnehât nâŋgâmai yamâ tânyongomune ârândâŋ otmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sâmu sâop. “Den yat yu nâŋgâmune bulâŋe otmâ biwinaŋe gâhâlen kepeiwe sâm oan. Yamâ gikak nâŋgânihirâ den yat yukât bulâŋe tetenihiâkgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yawu sâmu lohimbi dondâŋe taka hawam mewam tuhuwihât Yesuŋe weke bâleŋe yuwu sâm ekuop. “Weke bâleŋe, yuwu sâmune nâŋgâ. Gâŋe naom yu mâŋgâerâ kopa manmâ gap yâkâlembâ gaiakmâ ba âlâengen ari man. Yâhâpŋe ki âwurem taka mâŋgâewuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yawu sâmu weke bâleŋaŋe mâŋgâem hu halak tuhum kâroŋbaŋgim yâkâlembâ gaiakmâ arimu derep kum iop. Derep kum imu lohimbi gotŋan kinbiŋe yuwu sâwi. “Bâe, yu hiliwahoap yukâ.” ");
INSERT INTO spl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yawu sâŋetâ Yesuŋe bâtŋan memu yahatmâ kinop. ");
INSERT INTO spl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yahatmâ kinmu lohimbi ya pilâyekmâ emelan yâhâ tatbin yan yuwu sâm Yesu âikuwin. “Yu topŋe girawuhât nenŋe weke bâleŋe watne sâm hâum pâpguain?” ");
INSERT INTO spl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sâmunŋe sâop. “Yamâ weke bâleŋe watmune ariap yuâmâ kârikŋe bâleŋe. Yâhâ yeŋe watne sâm hâum pâpguai. Yawu gârâmâ weke bâleŋe yuwuya âlâ ekmâmâ aŋgoân biwiyeŋaŋe Anitâhâlen kepeim ulitgunomai yanâmâ watŋetâ denyeŋe nâŋgâm gaiakmâ ariwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yesuŋe den kâsikum ningiwe sâm otmâ menenekmu yok pilâm kapi ya pilâm Kapanaum kapiân arine sâm Galilaia hân yapâ ariwin. Mâtâwân ari tatmunŋe Yesu Anitâŋe hâŋgângumu giop kasalipŋaŋe sâp ki kâlep otmuâk kuŋetâ mum hilâm kalimbu hân kâlehen tatmâ mumuŋambâ yahatbuap yakât eknongop. ");
INSERT INTO spl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eknongomu nâŋgâmunŋe ki keterahop. Yakât otmâ yâhâpŋe âikune sâm otmunŋe umatŋe otmu pilâwin. ");
INSERT INTO spl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Mâtâwân ari nengâlen gâtŋe âlâ me âlâŋe sâp patoen kunnenŋe pato otbuap yakât sâm pawarak guwarak otbin. Yakât sahaŋgim ari Kapanaum kapi mewin. Yâhâ Petorohât emelan yâhâ tatmunŋe Yesuŋe yuwu sâm âinongop. “Mâtâwân ya wongât sahaŋgiai?” Yawu sâmu in den nâŋgânâk tatbin. ");
INSERT INTO spl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yawu tatmunŋe yuwu sâm eknongop. “Yeŋambâ gâtŋe âlâ me âlâŋe kunyeŋe pato otne sâm otnomai yaŋe yeŋahât nâŋgâŋetâ gemu huruŋ huruŋ manmâ hoŋ bayiŋginomai. Hoŋ bayiŋgim manbuap lok yawuyakât nâŋgâmune ârândâŋ oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yawu sâm naom tipiŋe âlâ gotnenŋan kinop ya mem yâkâlen hâum yuwu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Lohimbi âlâ me âlâŋe tem lâunihim naom tipiŋe yuwuya buku otbaŋginomai. Lohimbi yaŋe otbaŋgiain sâm yan nâ buku otnihinomai. Otmu nâ otnihiain sâm awoŋne hâŋgânnohomu gewan yâk buku otbaŋginomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yawu sâmu Yoaneŋe yuwu sâm ekuop. “Lok pato, lok ondowân gâtŋe âlâŋe kutgan gohonmâ weke bâleŋe watyekmu gaiakmâ ariwi ya ekmâ nenŋe nâŋgâm bâlewaŋgim kuwaŋgiwin.” ");
INSERT INTO spl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sâmu sâop. “Lok âlâ me âlâŋe kutnan nohonmâ kulân kulem âlâ menomai yaŋe yakât kakŋan ki sâm bâlenihinomai? Yakât otmâ lok yawuya ki kuyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yakât yuwu sâmune nâŋgâŋet. Lohimbi nombotŋaŋe nengât ki nâŋgâŋetâ gemap yaŋe nengât buku manmai. Biwinaŋe yawu naŋgan. ");
INSERT INTO spl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yeŋe biwi nâŋgân nâŋgânyeŋaŋe nâ hikunekmâ nâhât den lâum mannomai. Yanâmâ manŋetâ lohimbi âlâ me âlâŋe manmanyeŋe ekmâ nâhât hoŋ banihim mansai sâm, buku otyiŋgim tânyongonomai yakât hâmeŋe hâmbâi menomai. Yawu.” ");
INSERT INTO spl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yawu gârâmâ nimnaom titipâ yeŋgâlen hâum sâmune nâŋgâŋet. Lok âlâ me âlâŋe nimnaom titipâ nâhât pat manmai yu yeŋgât mâtâp maŋguyiŋginomai. Yamâ hâmbâi matŋe umatŋe menomai. ");
INSERT INTO spl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Yakât torokatmâ sâwe. Bulâŋe hârenomaihât ki sâwe. Topŋe nâŋgâŋetgât yakât den âlâen hâum sâwe. Lok âlâ me âlâ bâtyeŋaŋe otmâ hilipgunomai. Yawu otmâ hilipguŋetâ bâtyeŋahât tosa yakât otmâ umut biwiyeŋe hem kâlâwân arimapgât ya hârem pilânomai. Hemgât kâlâp yaŋe ki bok sâwuap. Yâhâ lok mum tâtuk sâmu nane gorewaŋe nembuap yakât dopŋeâk hâhiwin pato nâŋgâm yâhâmbisâi. Topŋe yuwuhât yan. Wuân me wuânŋe lok âlâ me âlâ dâiyekmu otŋetâ bâlemu hem kâlâpgât pat otmaihât ya pilâm biwiyeŋe Anitâhâlen katnomai. Yawu otmâ manman kârikŋe menomai. ");
INSERT INTO spl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Torokatmâ âlâen hâum sâwe. Lok âlâ me âlâŋe yu me ya ekŋâlem kâiyeŋaŋe sururuk sâm ari otmâ tâpikgunomai. Otmâ tâpikgunomai yan kâiyeŋahât tosa yakât otmâ umut biwiyeŋe hem kâlâwân arimapgât ya hârem pilânomai. Hemgât kâlâp yaŋe ki bok sâwuap. Yâhâ lok mum tâtuk sâmu nane gorewaŋe nembuap yakât dopŋeâk hâhiwin pato nâŋgâm yâhâmbisâi. ");
INSERT INTO spl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Otmu âlâen hâum sâwe. Yâhâ lok âlâ me âlâŋe senyeŋe nombot me nombot yaŋe yu me ya ekŋâlem otmâ tâpikgunomai. Otmâ tâpikgunomai yan senyeŋahât tosa yakât otmâ umut biwiyeŋe hem kâlâpgât pat otmap sâm yakât âlâ gusuhutmâ pilânomai. Gusuhutmâ pilâm biwiyeŋe Anitâhâlen katmâ tem lâuwaŋgim mannomai yamâ manman kârikŋe yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yawu gârâmâ hemgât kâlâp yaŋe ki bok sâwuap. Yâhâ lok âlâ mum tâtuk sâmu nane gorewaŋe nembuap yakât dopŋeâk hâhiwin pato nâŋgâm yâhâmbisâi. ");
INSERT INTO spl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yâhâ hâhiwin ya ki pesuk sâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yâhâ yeŋgât topyeŋe teteâkgât den âlâen hâum sâmune nâŋgâŋet. Nenâmâ kâtembe mem solân hoŋmain yanâmâ sot ya nemunŋe launenŋan memap. Dop yawuâk yenâmâ lohimbi yeŋgât hohetyeŋan mannomai yanâmâ manmanyeŋe ekŋetâ heroŋe otbuap. Kâtembe yamâ ukenŋe. Yawu gârâmâ nenŋe heleŋân ki hikum ikaimunŋe yamâ pâlâmŋe otmap. Pâlâmŋe otbuap yamâ girawu otmunŋe yâhâpŋe ukenŋe otbuap. Yakât otmuâmâ yeŋe tem lâunihim buku oraŋgim mannomai yanâmâ Anitâŋe yekmu ârândâŋ otbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuŋe yawu sâm eknongomu yapâ yahatmâ ari Yoran to hâtikgum Yuraia hânângen ariwin. Arimunŋe lohimbi dondâŋe denŋe nâŋgâne sâm takaŋetâ emelâk den kâsikum yiŋgiminiop yawuâk kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Den kâsikum yiŋgim tatmu Parisaio nombotŋaŋe taka “Den girawuyaen hâum sâmunŋe yan matŋe sâm tâpikgumu yaŋak den âiân katnom,” yawu nâŋgâm yaŋak yuwu sâm âikuwi. “Mâtâp girawuya tap? Lok âlâ me âlâŋe imbilipyeŋe pilâyeknomaihât mâtâp âlâ tap me bia?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sâŋetâ sâop. “Âinohoai yakât matŋe nâku âiyongomune sâŋet. Den yai yakât emelâk Moseŋe girem den kulemguop ya sâŋetâ nâŋgâwe.” ");
INSERT INTO spl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sâmu sâwi. “Moseŋe girem den âlâ yuwu kulemguop. “Lok âlâ me âlâŋe imbiŋe pilâwe sâm âlepŋe pilakdomawot yakât topŋe kulemgum waŋmu miakmu watmu ariwuap.” Moseŋe ya otnomgât âlepŋe sâop.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yawu sâŋetâ Moseŋe den kulemguop yakât Yesuŋe yuwu ekyongop. “Tâmbâlipyeŋaŋe biwiyeŋe kârikŋe otmu yeŋahâlâk nâŋgâm manminiwi. Yakât otmâmâ Moseŋe kuyiŋgiwehât otmâ ki kulemguop. ");
INSERT INTO spl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gârâmâ kândikum emelâk Anitâŋe hân himbim kândikyotgop yan lohimbi yâhâp ya katyelehop. ");
INSERT INTO spl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Katyelekmâ den yuwu sâm ekyotgop. “Lok âlâ me âlâŋe âwâŋe mâmâŋe pilâyelekmâ imbiŋâit mandomawot.” Den yawu tap. Yawu gârâmâ orowâk manmâ biwi nâŋgân nâŋgânyetŋe konohâk otbuap. Yakât otmâ ki hioŋakmâ ikŋiâk ikŋiâk otdomawot. ");
INSERT INTO spl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anitâŋe menduhuyelekmu konohâk olowot. Yakât otmâ lok âlâ me âlâŋe ki hioŋyeleknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yawu sâm ekyongomu ariŋetâ emelan yâhâ den sâop yakât sâm âikuwin. ");
INSERT INTO spl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Âikumunŋe yuwu sâop. Lok âlâ me âlâŋe imbiŋe yakât hâkâŋ otmâ pilâm imbi ondop membuap. Yamâ lok yaŋe tosa umatŋe membuap. ");
INSERT INTO spl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Otmu imbi âlâ me âlâŋe lokŋe pilâm lok ondop membuap ya gurâ yawuâk tosa umatŋe membuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","14","Hilâm âlâen lohimbi nombotŋaŋe nan baralipyeŋe meyekmâ Yesuhâlen ariwi. Ari Yesuŋe kunyeŋan mem Anitâ ulitgumu lukuleyehâkgât ekuwi. Yawu otŋetâ nenŋe yekmunŋe ki ârândâŋ otmu kuyiŋgiwin. Kuyiŋgimunŋe Yesuŋe nenekmu ki ârândâŋ otmu yuwu sâm eknongop. “Kâmbukŋe, ki kuyiŋgiŋet. Anitâŋe nimnaom titipâ me gin mandu yeŋgât tihityeŋe otmap. Yakât otmâ dâiyekmâ nâhâlen gaŋet. ");
INSERT INTO spl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yakât sâmune nâŋgâŋet. Nimnaom titipâŋe Anitâhât den nâŋgâm in yawu yâkâlen biwiyeŋaŋe kepeimai. Yâhâ oai yakât dopŋeâk âwâ mâmâlipyeŋaŋe otnomai yamâ Anitâŋe meyekbuap.” ");
INSERT INTO spl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yawu eknongom nimnaom titipâ ya âlâku ikŋeâk ikŋeâk lâuyekmâ kunyeŋan mem Anitâŋe lukuleyehâkgât ulitguop. ");
INSERT INTO spl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Otmu kâlâwahom arine sâm otmunŋe lok âlâ sururuk sâm taka yuwu sâm âikuop. “Bawapi, manman koko salek amboŋe mansat. Yakât otmâ sârâ nâŋgâwe. Nâŋe girawu otmune ârândâŋ otmu Anitâŋe manman kârikŋahât pat kunihiwuap?” ");
INSERT INTO spl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sâmu sâop. “Wongât nâhât “Manman koko salek amboŋe” yat? Anitâ konohâk manman koko salek amboŋe tatmap. ");
INSERT INTO spl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yakât otmâ gâŋe âinohoat yakât matŋe yuwu sâmune nâŋgâ. Anitâŋe girem den Mose ekumu kulemguop ya sâlikum nâŋgâmat me bia? Ya yuwu tap. Gâ lok nombotŋe ki yongorâ munomai. Otmu buku âlâhât imbi ki ekmâ otbuat. Kombo ki meyiŋgiwuat. Hakyeŋan ki sâwuat. Den perâk ki sâm kâityongowuat. Âwâ mâmâhe yetgât lauyetŋe lâum amutyetŋan manbuat.” ");
INSERT INTO spl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sâmu sâop. “Bawapi. Girem den sâm arat yuâmâ ŋaŋanambâek lâum manmâ gaman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sâmu sâop. “Yuwu otbuat. Senŋe âlâlâ pato tatgihiap ya kâsikum buku nombotŋe umburuk mansai ya yiŋgiwuat. Yawu otmâ nâhâlen torokatdâmâ Anitâŋe manman kârikŋahât pat kuhihiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yawu sâmu iri sikum me senŋe âlâlâ dondâ tatbaŋgiop yakât nâŋgâmu biwiŋe umatŋe otmu hâmeŋe bâleop. Yawu otmâ yaŋak pilâm âlâengen ba ariop. ");
INSERT INTO spl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ba arimu nengu kapi ya pilâm mâtâwân ari tatmâ Yesuŋe eŋgatŋe kakŋambâ olelem nenekmâ yuwu sâm eknongop. “Lok iri sikum pato tatyiŋgiapŋeâmâ Anitâhâlen biwiyeŋaŋe kepeim tem lâuwaŋgine sâm otŋetâ hâi hâiŋe otmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","Yawu sâmu nâŋgâmunŋe ki keterakmu yakât den âlâen torokatmâ yuwu sâm eknongop. “Bukulipne, yuwu sâmune nâŋgâŋet. Pusiŋe seloŋ watmu pin pinŋan arimu yan watmâ ba membe sâm hâum pâpgumap. Yakât dopŋeâk lohimbi iri sikumyeŋe pato tatyiŋgiapŋe Anitâŋe tihityeŋe olâkgât mâtâp ya watmâ arine sâm otŋetâ hâi hâiŋe otbuap. Lohimbi nombotŋe iri sikum pato tatyiŋgimap yaŋe yeŋahâlâk nâŋgâmai. Lohimbi yawuyaŋe Anitâhâlen biwiyeŋe katnomaihât nâŋgâŋetâ umatŋe otmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yawu sâmu nâŋgâmunŋe sâtŋe otmu yuwu sâm âikuwin. “Lohimbi girawu yaŋe otŋetâ ârândâŋ otmu Anitâŋe manman kârikŋahât pat kuyiŋgiwuap?” ");
INSERT INTO spl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yawu sâmunŋe Yesuŋe sennenŋe topŋanâk ekmâ yuwu sâop. “Anitâhât manman kapiân arine sâm lokgât nâŋgân nâŋgân watmâ arinomaihât dop âlâ ki tap. Yamâ Anitâhât topŋe âlâ tap. Yakât otmâ yeŋe yu me ya otne sâm yâkât nâŋgân nâŋgân watmâ otnomaihât dop tap. Yâkŋe konok manman kârikŋe ya yiŋgimu mem manmâ yâhânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yawu sâmu Petoroŋe yuwu sâop. “Bâe, nenâmâ senŋe âlâlâ kerek betbaŋgim gâhâlen torokatmâ hâhiwin kakŋan manmâ gain.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sâmu sâop. “Lohimbiŋe nâhâlen biwiyeŋe katŋetgât lok âlâ me âlâŋe nâhât den lohimbi ekyongomaiŋe âwâ mâmâlipyeŋe, me imi garilipyeŋe, me nan baralipyeŋe, me hep torehenlipyeŋe, me senŋe âlâlâ siminŋe tatyiŋgiap ya kerek pilâm nâhât komolân torokatnomai. ");
INSERT INTO spl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Yawu otmâ nâhât komolân torokatmâ mannomai yan lohimbi bâleŋaŋe yekŋetâ bâlemu mem âlâlâ tuhuyekŋetâ hâhiwin nâŋgânomai. Yawu otmâ nâhât lohimbi orop biwi konohâk hikuakmâ mannomai yanâmâ emelâk hep torehenlipyeŋe orop heroŋe otminiwi ya wangim heroŋe pato kakŋan mannomai. Otmu hâmbâi Anitâŋe meyekmâ manman kârikŋan katyekmu mannomai. ");
INSERT INTO spl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Otmu lohimbi nombotŋaŋe yeŋahâlâk nâŋgâŋetâ yahatmap yamâ Anitâŋe ki meyekbuap. Yâhâ nombotŋaŋe yeŋahât nâŋgâŋetâ gemu huruŋ huruŋ manmai ya Anitâŋe meyekmâ ikŋan torokatyekbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesuŋe yawu sâm eknongomu yapâ yahatmâ Yerusalem kapiângen yâhâwin. Mâtâwân yâhâm tatmâ umatŋe âlâlâ yâkâlen tetewuap yakât topŋe yuwu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Yuwu sâmune nâŋgâŋet. Yiwereŋe Yerusalem kapiân yâhânom. Yan yâhâmunŋe lok âlâŋe nâŋgâm bâlenihim hotom umai otmu Mosehât girem den kâsikum ningimai ya yeŋgât bâtyeŋan katnekbuap. Bâtyeŋan katnekmu den âiân katnekmâ mumbomgât den sâm hârenihinomai. ");
INSERT INTO spl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Den sâm hârenihim Roma lok yeŋgâlen katnekŋetâ yâkŋe yuwu otnihinomai. Sennan gem tâpnohom, mem âlâlâ tuhunekŋetâ hâhiwin pato nâŋgâwom. Otmu benŋe howanân nohoŋetâ mumbom. Mumune hannohoŋetâ yan hilâm kalimbu pesuk sâmu yakât kakŋan mumuŋambâ yahatbom.” Yawu sâm eknongop. Yawu sâm eknongomu Yerusalem yâhânom yakât nâŋgâmunŋe biwinenŋe umatŋe otmu nâŋgâm ketet otbin. ");
INSERT INTO spl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Otmu sâp yan Yewerihât nanyâhâtŋe, Yakowo yet Yoaneŋe, Yesuhâlen ba yuwu sâm âikuowot. “Bawapi, netŋe yu me yakât naŋgait ya sâmutŋe âlepŋe otnitgiwuatgât dop me bia?” ");
INSERT INTO spl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ekumutâ sâop. “Yetŋe biwiyetŋaŋe girawu naŋgawot ya sâmutâ nâŋgâwe.” ");
INSERT INTO spl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sâmu sâowot. “Sâp patoen gâŋe lohimbi kerek tihitnenŋe otdâ heroŋe nâŋgâhihim mepaeheknom. Yanâmâ nâŋgânitgirâ orowâk tatmâ tângohomutŋe lohimbi kunlipyeŋe mannomgât naŋgait.” ");
INSERT INTO spl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sâmutâ sâop. “Yakât topŋe ki nâŋgâm denâk sâm yawot. Umatŋe âlâlâ tetenihimu hâhiwin nâŋgâwom yawuâk nâŋgâromawot me? Otmu hâhiwin kakŋan katnekŋetâ sâtgum mumbom yakât dopŋeâk sâtgum mundomawot me?” ");
INSERT INTO spl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sâmu sâowot. “Ya âlepŋe yat. Umatŋe nâŋgâwualân net gurâ yawuâk nâŋgâromgât naŋgait.” Sâmutâ sâop. “Bonŋanâk yawot. Umatŋe âlâlâ tetenihiwuawân hâhiwin nâŋgâm sâtgum mumbom ya yet gurâ yawuâk nâŋgâm mundomawot. ");
INSERT INTO spl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yakât sâwe. Lok âlâ me âlâŋe tânnohoŋetâ kunlipyeŋe mannom yakât Anitâ ikŋahâk nâŋgâmu tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yawu sâm ekyotgomu yakât den pat nâŋgâmunŋe bâlemu Yakowo yet Yoane yetgât nâŋgâm bâleyitgiwin. ");
INSERT INTO spl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nâŋgâm bâleyitgiwin yakât Yesuŋe nâŋgâmu bâlemu den âlâen hâum yuwu sâm eknongop. “Lok papatolipyeŋaŋe nâŋgâmai dopŋan lohimbi galemyongoŋetâ yâk yeŋgât amutyeŋan manmâ hâhiwin kakŋan manmai. ");
INSERT INTO spl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","45","Yeŋeâmâ papatolipyeŋaŋe otyiŋgimai yawu ki otnomai. Nâhât den lâum mansaiŋe nâhât hoŋ bam gam nâ tânohoŋetgât ki gewan. Nâŋeâmâ lohimbi hoŋ bayiŋgim sârereyekmâ kinmune nohoŋetâ mumbom. Mum yan tosayeŋe pilâyiŋgiwom. Yawu otbomgât awoŋnaŋe âi sâm nihim hâŋgânnohomu gewan. Yawu gârâmâ yeŋgâlen gâtŋe âlâ me âlâŋe bukulipyeŋaŋe nâŋgâyiŋgiŋetâ yahalâkgât meŋetâ huruŋ huruŋ otmu yâk yeŋgât amutyeŋan mannomai. Otmu yeŋgâlen gâtŋe âlâ me âlâŋe Anitâŋe nenekmu ârândâŋ olâkgât nâŋgâm yawuâk bukulipyeŋe yeŋgât hoŋ bayiŋginomai. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yawu sâm eknongomu Yeriko kapi mewin. Otmu kapi ya pilâm yâhâmunŋe lohimbi dondâŋe betnenŋan watnenekbi. Arimunŋe lok âlâ senŋe bok sâsâŋe, kutŋe Batimaio sâm, yamâ Timaio nanŋe, mâtâp ginŋan talop. Tatmâ senŋe âlâlâhât umburuk otmâ yaŋak lohimbi mâtâwân bam gaŋetâ ulityongom tatminiop. ");
INSERT INTO spl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ulityongom tatmu lohimbi yaŋe “Yesu takap,” sâŋetâ nâŋgâm yahatmâ halahuop. “Yesu, Dawitihât sen, gâŋe nâhât wehe nâŋgânihi.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yawu sâmu lohimbi gotŋan kinbi yaŋe kuwaŋgiwi. Kuwaŋgiŋetâ witgum halahuop. ");
INSERT INTO spl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesuŋe ya nâŋgâm mâtâwân kinmâ “Ekuŋetâ gaek,” sâm lohimbi ya ekyongop. Ekyongomu senŋe bok sâsâŋe ya yuwu sâm ekuwi. “Gâhât yap. Yakât otmâ yahatmâ yâkâlen yâhâ.” ");
INSERT INTO spl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yawu sâŋetâ nâŋgâm in yawu yahatmu dâim yâkâlen bawi. ");
INSERT INTO spl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dâim yâkâlen baŋetâ yuwu sâm âikuop. “Girawu otgihiwehât naŋgat?” Sâmu sâop. “Bawapi, sârâ senne hâreakmu ekbehât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sâmu sâop. “Gâŋe nâhâlen biwihe hikuat. Yakât otmâ den yat ya bulâŋe tetehihiâk.” Yawu sâmu yan senŋe hâreakmu ekmâ Yesu betŋan sâop. ");
INSERT INTO spl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Otmu yapâ ari Yerusalem kapi pato yakât gotŋan kapi yâhâp kutyetŋe Betepahe otmu Betani sâm, ya Oliwa pumŋan tap yan yâhâwin. Yan yâhâ Yesuŋe hoŋ bawayâhâtŋe yâhâp yuwu sâm hâŋgânyotgop. ");
INSERT INTO spl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Kapi tipiŋe ewapâ tap yan doŋgi nanŋe âlâ hikum katŋetâ kinsap ya lok ki kakŋan tatmai ya holaŋmâ mem geromawot. ");
INSERT INTO spl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Holaŋmutâ lok âlâŋe yuwu mon sâm âiyotgowuap. “Yet wongât taka yu holaŋsawot?” Yawu sâmuâmâ yuwu sâm ekuromawot. “Yiwereŋe âi teteap. Yakât otmâ patonetŋaŋe yu mendehât hâŋgânnotgomu takait. Mem arimutŋeâmâ âi ya tuhum pesuk pilâmuâmâ mem âwurem takarom.” Yawu sâm ekuromawot.” ");
INSERT INTO spl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesuŋe yawu sâm hâŋgânyotgomu yâhâ doŋgi nanŋe ya emet âlâ hawiŋan hikum katbi ya holaŋowot. ");
INSERT INTO spl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Holaŋmâ kinmutâ lok yan kinbiŋe yelekmâ yuwu sâm âiyotgowi. “Bâe. Yet âlâŋe sâmu yu holaŋde sâm oawot?” ");
INSERT INTO spl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yawu sâm âiyotgoŋetâ yâku Yesuŋe den ekyotgop yawuâk yawuâk sâm ekyongowot. ");
INSERT INTO spl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ekyongomutâ nâŋgâyitgiŋetâ holaŋmâ mem giowot. Mem gemutâ nenŋe hâk katipŋe kâlep katbin ya holaŋmâ lotohom kakŋan katbin. Katmunŋe kakŋan yâhâ talop. Yâhâ tatmu Yerusalem kapiân yâhâwin. ");
INSERT INTO spl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yâhâmunŋe lohimbi dondâ hâruhuakbiŋe Yesuhât nâŋgâŋetâ yahatmu yeŋe sâŋgum kâkâlep ya holaŋmâ mâtâp tete liŋgatmâ ariwi. Yâhâ nombotŋaŋeâmâ âliwahap esenŋe hârem yaŋe liŋgatmâ ariwi. Liŋgatmâ ariŋetâ doŋgi yaŋe ya kakŋan tâlim tâlim ariop. ");
INSERT INTO spl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Otmu lohimbi kiŋgitŋe orowâk hâruhuakbiŋe yuwu sâm mepaewi. “Gâmâ tâmbânenŋe Dawiti sen. Gike ombeheâk ki takat. ");
INSERT INTO spl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Anitâŋe âi sâm gihiop ya lâum kinmâ nengâlen mat takat. Tâmbânenŋe Dawitiŋe olop yakât dopŋeâk galemnongowe sâm otmâ takat. Yakât nâŋgâm heroŋe otgihim mepaeheksain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yawu sâŋetâ yapâ Yerusalem kapiân yâhâwin. Yâhâmunŋe Yesuŋe opon kâmbukŋan yâhâop. Opon kâmbukŋan yâhâ senŋe âlâlâ mem aŋgi guŋgi otbi ya in yekmâ purik sâm giop. Otmu emetsenŋe potok sâwe sâm otmu yakât otmâ menenekmu ya pilâm Betani kapiân âwurem ge iwin. ");
INSERT INTO spl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yan im yahatmâ Yerusalem kapiân âwurem yâhâwin. Mâtâp arim tatmunŋe Yesu po waŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Po waŋgimu senŋe pilâm lakop âlâ mâtâp ginŋan kinop ya ehop. Ya ekmâ kehetŋe mem nembom sâm gotŋan ariop. Ari eksan mâne esen yambuŋaŋak pato otmu kehetŋe ki kinop. ");
INSERT INTO spl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yawu kinop yakât yuwu sâop. “Âo, yu kehetŋe ki kinsap. Yakât otmâ lakop yukât kehetŋe âlâ ki menomai.” Yawu sâop. Yawu sâmu nâŋgâwin. ");
INSERT INTO spl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yapâ ari Yerusalem kapiân yâhâwin. Yâhâmunŋe Yesuŋe doŋgi kakŋambâ kioŋmu yaŋak opon kâmbukŋan yâhâwin. Yâhâm yan opon kâmbukŋe kâlehen lohimbi senŋe âlâlâ aŋgi guŋgi otmâ hâmeŋe hâukum kinbi ya yekbin. Yekmâ Yesuŋe nâŋgâm bâleyiŋgim watyehop. Watyekmâ kakŋan tat tat, tewo, kembâ emetŋe tuhum ya kâlehen katŋetâ talop, senŋe âlâlâyeŋe mem purik pilâyiŋgimu tiok taok otmâ kinbi. ");
INSERT INTO spl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Watyekmu tiok taok otmâ kinŋetâ yan lohimbiŋe senŋe âlâlâyeŋe ya lâuakmâ ba nombot ga nombot otmâ yaehen kioŋmai sâm mâtâp maŋguyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mâtâp maŋguyiŋgim kinmâ yuwu sâm ekyongop. “Yu oai yukât emet inânŋan Anitâŋe poropete âlâ ekumu kulemguop ya yuwu tap. “Lohimbi hânŋan kulemŋan manmâ araiŋe nâhât opon yukât kâlehen yâhâ mepaeneknomai.” Den sâop yakât yuwu sâmune nâŋgâŋet. Yeŋe yukât kâlehen tatmâ lohimbi kâityongom hâmeŋe mem yahatmâ aŋgi guŋgi otmâ gai. Yawu otmâ gai yu ekmune aŋgim bero emetŋe yawuya oap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yakât otmuâmâ hotom uminiwi yeŋgât lok kunlipyeŋe otmu Mosehât girem den kâsikum ningiminiwiŋe den sâop yakât nâŋgâŋetâ bâlemu Yesu mem pâi emetŋan katne sâm otbi. Yamâ benŋe yuwu nâŋgâwi. “Lohimbi seseŋgâlâkŋe Yesuhâlen torokatmâ mansai. Otmu yâkŋe den sâmap ya nâŋgâŋetâ âlâ kândâkdâ otmu nâŋgâwaŋgiŋetâ yahatmap.” Yawu nâŋgâm mem pâi emetŋan katne sâm nâŋgâŋetâ umatŋe otmu pilâwi. ");
INSERT INTO spl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yâhâ Yesuŋe yawu sâm ekyongomu nenŋe yahatmâ pilâyekmâ gem Betani kapiân ari iwin. ");
INSERT INTO spl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yan im yahatmâ Yerusalem kapiân âwurem yâhâwin. Mâtâwân yâhâmunŋe Yesuŋe lakop yakât sâop yaŋe esenŋe mum hâlâlâŋ sâm kinop. ");
INSERT INTO spl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yawu otmâ kinmu Petoroŋe ekmâ Yesuŋe lakop yakât sâop ya nâŋgâmu tetemu yuwu sâm ekuop. “Bawapi, enda ek. Gâŋe oran lakop endakât sâon ya esenŋe mum hâlâlâŋ sâm kinsap.” ");
INSERT INTO spl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Yawu sâmu eŋgatŋe kakŋambâ olelem nenekmâ yuwu sâm eknongop. “Yeŋe yu me ya otne sâmâmâ aŋgoân biwi nâŋgân nâŋgânyeŋaŋe Anitâhâlen kepeim ulitguŋetâ nâŋgâyiŋgimu yanâmâ yakât bulâŋe tetemu eknomai. Yakât den âlâen hâum sâmune nâŋgâŋet. Yeŋe pumŋe yukât Anitâ yuwu mon sâm ulitgunomai. “Pumŋe yuŋe huhuakmâ orotok sâm giâk,” yawu sâm biwi yâhâp ki otmâek ulitgunomai otmuâmâ nâŋgânomai yawuâk tetewuap. ");
INSERT INTO spl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yakât otmâ yuwu sâmune nâŋgâŋet. Yeŋe yu me ya Anitâŋe sâmu teteâkgât nâŋgâm ulitgunomai. Yanâmâ biwiyeŋaŋe kepeim yuwu nâŋgânomai. “Nenŋe Anitâhâlen biwinenŋaŋe kepeim ulitgumunŋe nâŋgâningimap yakât dopŋan teteningiwuap. Yawu. ");
INSERT INTO spl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yakât torokatmâ sâmune nâŋgâŋet. Anitâ ulitgunomai yanâmâ lohimbi nombotŋaŋe yen mem bâleyekbi ya yeŋgât tosayeŋe pilâyiŋginomai. Yawu otnomai otmuâmâ Himbim Âwâyeŋaŋe yeŋgât tosa ya gurâ yawuâk pilâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yâhâ lohimbi nombotŋaŋe yen mem bâleyekbi yakât nâŋgâm matŋe kâpekyiŋginomai. Yawu otnomai yanâmâ Himbim Âwâyeŋaŋe yen gurâ otŋetâ bâlem gap yakât matŋe kâpekyiŋgiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yawu sâm yapâ ari Yerusalem kapiân yâhâ opon kâmbukŋan yâhâwin. Yan yâhâmunŋe hotom uminiwi ya yeŋgât lok kunŋe, otmu Mosehât girem den kâsikum ningiminiwi, otmu Yura nengât papatolipnenŋaŋe Yesuhâlen bam yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Gâŋe oran âlâhât sâtgât otmâ Anitâhât opon kâmbukŋan yâhâ lohimbi watyehon?” ");
INSERT INTO spl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sâŋetâ sâop. “Yeŋe âinohoai gârâmâ nâku âiyongowe. Âiyongomune den matŋe kâpeknihiŋetâmâ nâŋe âlâhât sâtgât âi yu mem gaman yakât topŋe ekyongowom. ");
INSERT INTO spl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yakât yuwu sâmune nâŋgâŋet. Yoaneŋe âlâhât sâtgât otmâ lohimbi toen katyehop? Anitâhât me ondop yeŋgât sâtgât otmâ âi ya tuhuop? Ya sâŋetâ nâŋgâwe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yawu sâmu matŋe kâpekbaŋgine sâm pâpgum alahu gulahu otmâ yuwu sâwi. “Nenŋe yuwu mon sânom. “Yoaneŋe âi miop yamâ Anitâŋe âi sâm waŋmu tuhuop.” Yawu sânom yamâ matŋe yuwu mon sâwuap. “O, yenâmâ girawu otmâ Yoanehât den nâŋgâŋetâ ki bulâŋe olop?” Yawu sâmu nenŋe matŋe girawu sâm kâpekbaŋginom? Aŋulaknom yakâ. ");
INSERT INTO spl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Otmu âlâ yuwu mon sânom. “Yâhâmâ lok yeŋgât sâtgât otmâ âi ya miop.” Yawu sânom yamâ lohimbi dondâŋe “Yoaneŋe Anitâhât poropete manmâ yâkât sâtgât âi mem manop,” yawu nâŋgâmai yakâ. Yakât otmuâmâ nenŋe yawu sânom yanâmâ lohimbi kinsai yuŋe nâŋgâm nongonomai yakâ.” Yawu nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yawu nâŋgâm yuwu sâm ekuwi. “Yoaneŋe âlâhât sâtgât âi meminiop ya nen ki naŋgain.” Sâŋetâ sâop. “Nâku yawuâk. Nâŋe âlâhât sâtgât âi yu mem gaman yakât ki ekyongowom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Lok pato âlâŋe wain kâmetŋet sâm nep lok meyehop. Meyekmu ari dâmân sâhâm hawamgum wain kâmetbi. Otmu wain toŋe ya mem mendâreŋetâ gewuapgât waŋga hâwiwi. Otmu emetyeŋe tuhuwi. Âi ya tuhum tiŋ pilâŋetâ nep ya galemgunomai sâm katyekmâ ikŋe âlâengen ari sâp kâlep manop. ");
INSERT INTO spl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Arim sâp kâlep manmu wain kehetŋe ya puru pato kinmâ hululuŋ sâop. Yawu otmu amboŋaŋe ikŋahât hâruhunihiŋet sâm hoŋ bawa âlâ yakembâek hâŋgângumu takaop. ");
INSERT INTO spl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Takamu wain galemŋe manbiŋe kum watŋetâ âwurem ariop. ");
INSERT INTO spl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Âwurem arimu yawuâk kalam amboŋaŋe hoŋ bawa âlâ hâŋgângumu takaop. Hâŋgângumu takamu yâk gurâ yawuâk kum mem âlâlâ tuhuŋetâ âwurem ariop. ");
INSERT INTO spl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yakât otmâ yawuâk kalam amboŋaŋe hoŋ bawaŋe kalimbuŋe hâŋgângumu takamu kuŋetâ muop. Kuŋetâ mumu kalam amboŋaŋe hoŋ bawalipŋe dondâhâlâk hâŋgânyongomu ariwi ya gurâ kerehâk yongoŋetâ muwi. ");
INSERT INTO spl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aiop, kalam amboŋaŋe biwiŋaŋe yuwu nâŋgâop. “Nine nanne ombe bisine hâŋgângumune arimu ekmâ yanâmâ ewe katnomai.” Biwiŋaŋe yawu nâŋgâm ikŋe nanŋe hâŋgângumu ariop. ");
INSERT INTO spl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hâŋgângumu arimu ekmâ yuwu sâwi. “Bâe, yuâmâ patonenŋe ikŋe nanŋaŋe takap. Âwâŋe mumu yan kalam yuâmâ yâkŋe ambokuwuap. Yakât otmâ kumunŋe muâk. Kumunŋe mumu yanâmâ kalam yuâmâ nengât otbuap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yawu sâm kum kekae topŋehen pilâŋetâ iop. Yawu. ");
INSERT INTO spl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yawu otŋetâ kalam amboŋaŋe taka girawu otbuap? Yâkŋe taka yongomu muŋetâ lok ondop meyekmâ kaweyeŋan katyekmu kinnomai. ");
INSERT INTO spl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yakât topŋe yuwu sâmune nâŋgâŋet. Anitâŋe hâŋgânnohomu gewan. Yakât poropete âlâŋe den yuwu kulemguop ya yeŋe ki mon sâlikum nâŋgâmai? “Nep lokŋe emet tuhum nak âlâ ekŋetâ bâlemu mem ketetbi. Mem ketetbi ya Anitâŋe lâum kânâŋgâmu kuhupin kârikŋe otmâ kinsap. ");
INSERT INTO spl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yâhâ emet tuhuwiŋe ekmâ yuwu nâŋgânomai. “Bâe, yuâmâ patoŋe nâŋgâmu teteap. Ekmunŋe sâtŋe oap.” Yawu nâŋgânomai.” Yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuŋe den âlâen hâum sâop yuŋe hotom uminiwi ya yeŋgât lok kunŋe otmu bukulipyeŋe yeŋgât topyeŋe miop. Yakât nâŋgâŋetâ biwiyeŋan tâlimu Yesu mem pâi emetŋan katne sâm otbi. Yawu otbi yamâ lohimbi dondâ yan kinbiŋe Yesuhât nâŋgâŋetâ yahalop. Yakât otmâ yâk yeŋgât nâŋgâm gorâyiŋgimu pilâm gem ariwi. ");
INSERT INTO spl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Otmu sâp yanâmâ Parisaioŋe Yesuhât nâŋgâŋetâ gemu menduhuakmâ den yuwu sâm hikuwi. “Nenŋe den girawu yaen hâum Yesu âikumunŋe matŋe sâm tâpikguwuap? Matŋe sâm tâpikguwuap otmuâmâ Roma tembe lâu ekyongomunŋe mem pâi emetŋan katŋetâ tatbuap.” Yawu sâm den hikuwi. Yawu otmâ bukulipyeŋe nombotŋe otmu Herotgât âi lok nombotŋe Yesuhât topŋe ekŋetgât hâŋgânyongowi. ");
INSERT INTO spl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hâŋgânyongoŋetâ Yesuhâlen taka yuwu sâm âikuwi. “Bawapi, gâhât topge naŋgain. Gâŋe den imbiâk ki sâmat. Den sâmat yamâ nâŋgâmunŋe bonŋeâk otmap. Otmu lohimbiŋe girawu nâŋgâhihiai yakât nâŋgâm ki gorâhihimap. Gâŋe lok âlâhât nâŋgârâ yahatmu âlâhât nâŋgârâ gemu yawu ki otmat. Otmu manman girawu manmunŋe Anitâŋe nenekmu ârândâŋ otbuap yakât den tâŋ tâŋâk eknongomat. Yakât otmâ wuân me wuân otnom yakât sârâ nâŋgâne. Roma lok âlâŋe kunnenŋe mansap, kutŋe Sisa sâm, yâhâmâ haoŋmâ ârândâŋ takesi waŋmain. Yawu gârâmâ yawuâk waŋmâ yâhânom me bia? Yakât gâŋe girawu naŋgat? Sârâ nâŋgâne.” ");
INSERT INTO spl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yawu sâm âikuŋetâ biwiyeŋe ekmâ yuwu sâm ekyongop. “Yeŋe nâhâitŋe sâm tâpikguwuap sâm âinohoai me? Yawu gârâmâ kât nanŋe âlâ mem nihiŋetâ ekbe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yawu sâmu waŋetâ mem tiripyongom yuwu sâop. “Kât nanŋe yu ekŋet. Âlâhât towat kât nanŋe yuân tap? Me âlâhât kutŋe tap?” Sâmu sâwi. “Roma lok patonenŋe, kutŋe Sisa sâm, yakâ.” ");
INSERT INTO spl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sâŋetâ sâop. “Sisahât pat sâm yu ya katŋetâ tap otmuâmâ yâk waŋnomai. Yâhâ Anitâhât pat sâm katŋetâ tatmâ yâk waŋnomai.” Yawu sâm ekyongomu nâŋgâŋetâ sâtŋe otmu yahatmâ ariwi. ");
INSERT INTO spl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ariŋetâ bukulipyeŋe, kutyeŋe Sarukaio sâm, yaŋe tohowi. Yâkŋe yuwu nâŋgâmai. “Anitâŋe mumuŋambâ mem yahatnenekbuapgât dop âlâ ki tap. Yakât otmâ mumunŋe pesuk sâmap.” Yawu nâŋgâmai. Yâkŋe yakât topŋe nâŋgânehât Yesuhâlen ari yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bawapi, aŋgoân Moseŋe den kulemguop ya yuwu tap. “Lok âlâŋe imbi âlâ memu naom ki mewaŋgimu lok ya mumbuap. Mumu imiŋaŋe yâkât kambut ya galemgum yâkât welâmân nimnaom mem ga katyekbuap.” Moseŋe yawu kulemguop tap. Yakât topŋe sâm eknongohât yuwu sâmunŋe nâŋgâ. ");
INSERT INTO spl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Imi ata nombolân yâhâp manbi. Manmâ aŋgoân atayeŋe kunŋaŋe imbi memu imbiŋaŋe naom ki mewaŋgimu inâk manmâ muop. ");
INSERT INTO spl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mumu imiŋaŋe ataŋahât kambut ya mem manmâ yâku in muop. Otmu imiyetŋaŋe kambutyetŋe ya mem manmâ yâku yawuâk naom barahâk muop. ");
INSERT INTO spl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Otmu imi ata ya hârokŋe kambutyeŋe yawuâk mem manmâ inâk muwi. Aiop, kambutyeŋe yâku yawuâk muop. ");
INSERT INTO spl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Imi ata nombolân yâhâp ya kerekŋe imbi ya mewi. Gârâmâ sâp pato tetemu Anitâŋe mumuŋambâ mem yahatnenekbuap yanâmâ imbi yamâ âlâŋe membuap. Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sâŋetâ sâop. “Anitâŋe poropetelipŋe otmu lok nombotŋe den ekyongomu kulemguwi yakât topŋe ki naŋgai. Otmu Anitâ ikŋe wâtŋe pato tatbaŋgiap yakât topŋe gurâ ki naŋgai. Yawu gârâmâ yeŋe nâŋgâm hilipgum den yawu yai. ");
INSERT INTO spl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Anitâŋe lohimbi mem yahatyekbuap yanâmâ himbimân Anitâhât aŋelolipŋaŋe ki miakmai ya yeŋgât dop otmâ ikŋiâk ikŋiâk mannomai. ");
INSERT INTO spl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yâhâ Anitâŋe mumuŋambâ mem yahatyekbuap yakât topŋe yuwu sâmune nâŋgâŋet. Nak topŋan kâlâp semu laŋ laŋ sâop ya Moseŋe ekbe sâm gotŋan baop. Gotŋan bamu Anitâŋe yuwu sâm ekuop. “Nâŋe Awaraham, otmu nanŋe Isaka, otmu seseŋe Yakop yâk yeŋgât kunyeŋe tatmâ gaman.” Yawu sâm ekumu kulemguop. ");
INSERT INTO spl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anitâŋe Mose den ekumu kulemguop yakât topŋeâmâ yuwu. Emelâk nengât tâmbâlipnenŋe manmâ gawi. Otmu yapâ torokatmâ manmâ gaŋetâ gaŋetâ benŋe nen yu mansain yu. Otmu gâmâlâk nengât sen tetem mannomai. Nen kerek nengât kunnenŋe yamâ Anitâ. Topŋe yawu tap. Yamâ yeŋe den ya nâŋgâŋetâ keterakyiŋgimbâp.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesuŋe Sarukaio yeŋgât den yawu sâm purik pilâyiŋgimu nâŋgâŋetâ sâtŋe dop. Otmu Mosehât girem den kâsikum ningiopŋe den ya nâŋgâmâmâ yahatmâ yuwu sâm âikuop. “Anitâŋe girem den Mose ekumu kulemguop yapâ gâtŋe girawu ya yakât nâŋgârâ yahatsap.” ");
INSERT INTO spl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sâmu sâop. “Anitâŋe girem den Mose ekumu kulemguop ya yuwu tap. “Isirae yen ekyongomune nâŋgâŋet. Anitâ ambonenŋe pato yâk ikŋe konok tap. ");
INSERT INTO spl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yakât otmâ nenŋe yâkâlen biwi nâŋgân nâŋgânnenŋaŋe kepeim yâk konok mepaenom. Otmu yâkât lau konok lâum hoŋ bawaŋgim yâhânom.” ");
INSERT INTO spl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Otmu den âlâmâ yuwu tap. “Nenŋahât naŋgaŋgimunŋe yahatmap yakât dopŋeâk bukulipnenŋe yeŋgât nâŋgâmunŋe yahatbuap.” Den yâhâp yan yuŋeâmâ Anitâŋe den âlâlâ sâop ya hârohâk mem menduhuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sâmu sâop. “Bawapi, den bulâŋe sârâ nâŋgâmune ârândâŋ oap. Anitâ ikŋe konok kunnenŋe pato tatmap. Âlâ ki tap. ");
INSERT INTO spl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yakât otmâ nen biwi nâŋgân nâŋgânnenŋe yâkâlen kepeim tem lâuwaŋgim manmâ yâhânom. Yâhâ nenŋahât naŋgaŋgimunŋe yahatmap yakât dopŋeâk buku nombotŋe yeŋgât nâŋgâmunŋe yahatbuap. Yawu gârâmâ Anitâŋe nâŋgâningiâkgât noniŋ bulimakao me âlâlâ ya gâim hotom umain. Yawu otmâ den yâhâp yat yu loŋgâem hotom umunŋe yakât Anitâŋe nâŋgâmu dondâ bâlemap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yawu sâmu Yesuŋe nâŋgâmu ârândâŋ otmu yuwu sâm ekuop. “Gâŋe Anitâhât topŋe tipiŋe naŋgat. Yakât otmâ biwihaŋe yâkâlen kepeim manbuat otmuâmâ tihitge otmâ manman kârikŋahât pat kuhihiwuap.” Yawu sâop. Yawu sâmu nâŋgâŋetâ âlâ kândâkdâ dop. Otmu sâp yapâek Parisaio, Sarukaio otmu bukulipyeŋaŋe Yesuŋe den sâm tâpikguâkgât ki âikuwi. ");
INSERT INTO spl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuŋe den matŋe yawu purik pilâwaŋgim yuwu sâm Parisaio âiyongop. “Yeŋgâlen gâtŋaŋe Mosehât girem den kâsikum yiŋgim yuwu sâmai. “Anitâŋe hâŋgângumu ge tihitnenŋe otbuap yamâ Dawitihât senâmbâ tetewuap.” yawu sâmai. Den yawu tap yamâ nâŋgâmune bulâŋe oap. Yamâ yeŋe yakât topŋe pâpgum mansai. Yakât otmâ yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Emelâk Wâtgât mâmâŋahât Heakŋe tâmbânenŋe Dawiti biwiŋan kioŋmu yuwu sâop. “Anitâŋe nâhât patone yuwu sâm ekuop. “Gâŋe nâhât gotnan ga kinmâ nâhât hahit mem kasalipge yongom mem ge katyekbuat.” Yawu sâop.” ");
INSERT INTO spl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Den yakât yuwu sâwe. Anitâŋe hâŋgângumu gewuap yakât Dawitiŋe yuwu sâop. “Yamâ patone,” sâop. Yawu gârâmâ yeŋeâmâ “Yâkŋe hâmbâi ge galemnongowuap,” sâmai. Den sâmai yamâ Dawitiŋe den sâop ya orop ki lâuaksawot. Yakât nâŋgâmune keterahâkgât yeŋe eknohoŋetâ nâŋgâwe.” Yawu sâop. Yawu sâm âiyongomu matŋe sâne sâm hâum pâpgum pilâwi. (Mataio 23:1-36 Luka 11:37-54 Luka 20:45-47) Hâum pâpgum pilâm ariŋetâ lohimbi nombotŋaŋe yâkât den nâŋgâŋetâ âiloŋgo olop. ");
INSERT INTO spl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yawu otmâ den kâsikum yiŋgim yuwu sâop. “Lohimbi nombotŋaŋe nenekŋetâ yahalâkgât Mosehât girem den kâsikum yiŋgimaiŋe sâŋgumyeŋe kâkâlep mânuŋakmai yaŋe holuŋ holuŋ sâmu yâhâm gemai. ");
INSERT INTO spl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Otmu yeŋahât nâŋgâŋetâ yahatmu miti emetŋan me lohimbi senyeŋan ewanâk tatnehât nâŋgâmai. ");
INSERT INTO spl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yawu otmâ imbi kambut emetyeŋambâ watyekmâ senŋe âlâlâyeŋe kombo meyiŋgimai. Yawu otmâ topyeŋe kurihiakmâ lohimbi senyeŋan kinmâ oain sâm oain sâm Anitâ mepaem den kâlep huhumai. Yawu otmai yakât hâmbâi Anitâŋe matŋe amokŋan yiŋgimu menomai. Yâk yeŋgât topyeŋe yawu tap yakât otmâ yâkŋe biwiyeŋan kioŋmaihât biwiyeŋe galemahom mannomai.” ");
INSERT INTO spl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yawu sâm ekyongomu nenŋe pereŋ pilâm ba tewetsenŋe kondoân katmai yakât gotŋan kinbin. Kinmunŋe lok iri sikum pato tatyiŋgiop dondâhâlâkŋe yâhâ tewetsenŋe mem kondoân katbi. ");
INSERT INTO spl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yawu katŋetâmâ imbi kambut âlâ senŋe âlâlâhât umburuk otmâ manopŋe nanŋe kuriŋ kuriŋ yâhâp mem yâhâ kalop. ");
INSERT INTO spl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Yesuŋe ya yekmâ eknongomu nenŋe gotŋan bamunŋe yuwu sâm eknongop. “Lok iri sikumyeŋe pato tatyiŋgiapŋe tewetsenŋe nombotŋeâk katsai. Yâhâ imbi kambut yuŋeâmâ nanŋe kuriŋ kuriŋ yâhâp kârikŋe tatbaŋgimap ya bâiŋe katsap. Yakât otmâ Anitâŋe imbi kambut yu ekmu âiloŋgo oap. Yâhâ lok iri sikumyeŋe oropŋe tewetsenŋe nombotŋeâk katsai ya yekmu ki dopŋan oap. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yawu sâm tiŋ pilâmu opon kâmbukŋambâ kioŋmâ yaehen gewin. Yaehen ge kambenenŋe kakŋambâ olelem opon kâmbukŋe ekmunŋe âiloŋgo olop. Yawu otmu bukunenŋe âlâŋe yuwu sâm Yesu ekuop. “Pato, yu nâŋgâ. Opon kâmbukŋe pato nandoroŋe yu ekmunŋe senŋe âlâlâ kârikŋaŋak tuhuwi yaŋe âiloŋgo loŋgo oap. Yakât gâŋe ekdâ girawu oap?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sâmu sâop. “Opon kâmbukŋe yu ekŋetâ âiloŋgo loŋgo oap yuâmâ hâmbâi kasalipyeŋaŋe taka huhum itoŋ galaŋ mem senŋe âlâlâ kâlehen tap yu mem ihilâk mahilâk tuhunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yawu sâm eknongomu ya pilâm pumŋe âlâ, kutŋe Oliwa sâm, yan gem yâhâwin. Yan yâhâ tatmâ opon kâmbukŋe yamâ turembe nombotgen kinsap gârâmâ ya ekmâ yakât den alahuwin. ");
INSERT INTO spl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Den alahum pilâm Petoro, Yakowo, Yoane otmu Anderea yâkŋe Yesu orop pereŋ pilâm ba kinmâ yuwu sâm âikuwi. “Gâŋe opon kâmbukŋahât den eknongoat yakât bonŋe sâp girawuân tetewuap? Otmu tetewe sâm otbuap yan wuân kulem tetemu ekmâ nâŋgâmunŋe keterakningiwuap?” Yawu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Sâŋetâ sâop. “Lok nombotŋaŋe taka den perâkŋe yuwu sâm kâityongonomai. “Nâmâ Anitâŋe hâŋgânnohomu ge mansan.” Yawu sâŋetâ lohimbi dondâŋe denyeŋe nâŋgâŋetâ bulâŋe otmu yâk yeŋgâlen torokatnomai. Yakât otmâ eŋgatyeŋan geŋetâ loholemaihât biwiyeŋe galemgum mannomai. ");
INSERT INTO spl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Otmu sâp yan kapam gotyeŋan me kâlepŋehen, me wosapâ wosapâ tetewuap yakât nâŋgâm ki gorâyiŋgiwuap. Yawu tetemu yanâmâ “Anitâŋe emelâk sâm kalop yakât bulâŋe teteap,” yawu nâŋgânomai. Otmu kapam topŋe topŋe tetemu yan yeŋe nâhâitŋe “Getek âwurem gewomap,” yawu ki nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aŋgoân lohimbi hânŋan kulemŋan mansai dondâhâlâkŋe kasa oraŋgim ahonomai. Otmu mososoŋ hânŋan kulemŋan mososoŋ awawi guwawi membuap. Otmu po pato tetewuap. Yawu tetemu umatŋe topŋe topŋe teteyiŋgiwuap yakât den âlâen hâum sâmune nâŋgâŋet. Imbilipyeŋaŋe naom mene sâm otmai yan naomŋe hâliliakmâ tatmu hâhiwin kakŋan kinmai. Yawu otmâ naom ya kioŋmu yanâmâ hâkyeŋe sânduk sâmap. Yakât dopŋeâk umatŋe topŋe topŋe teteyiŋgiwuap yakât kakŋanâmâ âwurem gewom. ");
INSERT INTO spl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yeŋe galem tiŋ tiŋ oraŋgim mannomai. Mitihât kasaŋaŋe nâhât den pat âlepŋe nâŋgâŋetâ gemu bet pilâm yen hakyeŋan sâm den âiân katyeknomai. Otmu yeŋe miti emetŋan yâhâ nâhât den pat sâm ekyongoŋetâ nâŋgâŋetâ ki bulâŋe otmu yongom mem âlâlâ tuhuyeknomai. Mem âlâlâ tuhuyekmâ yan meyekmâ lok kunlipyeŋaŋe den sâm hâreyiŋgiŋetgât yâk yeŋgât senyeŋan katyekŋetâ kinnomai. Yâk yeŋgât senyeŋan kinmâ nâhât den pat âlepŋe sâm tetem ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nâhât den pat yu lohimbi hânŋan kulemŋan manmaiŋe nâŋgâŋetgât yeŋe mem sâliwahom ari ekyongonomai ya Anitâŋe sâm kalop. ");
INSERT INTO spl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Otmu ekyongoŋetâ lok nombotŋaŋe den ya nâŋgâŋetâ ki bulâŋe otmu yen meyekmâ den âiân katyekmâ âi pâi tuhuyeknomai. Yawu otyiŋgiŋetâ “Den mâtâpŋe girawu watmâ sâm ekyongomunŋe nâŋgâŋetâ keterakyiŋgiwuap,” yawu nâŋgâm ki gorâyiŋgiwuap. Sâp yanâmâ Awoŋnenŋaŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge den âlâlâ nâŋgân nâŋgânyeŋan katmu nâhât den pat âlepŋe sâm kusânmâ ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Otmu sâp yan umatŋe topŋe topŋe teteyiŋgiwuap yakât yuwu sâmune nâŋgâŋet. Imi ata yeŋahâk ahom hioŋaknomai. Yawu otmâ dâiakmâ lok kunlipyeŋe yeŋgâlen ari den âiân karaknomai. Yawu oraŋgiŋetâ kunlipyeŋaŋe mem âlâlâ tuhuyekmâ yongoŋetâ munomai. Otmu âwâ nan yâkŋe gurâ yawuâk oraŋgiŋetâ yongoŋetâ munomai. ");
INSERT INTO spl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yakât torokatmâ yuwu sâwe. Yeŋe nâ orop biwinenŋaŋe kepeiakmâ konohâk otmu mannomai. Yakât otmâ nâ mem âlâlâ tuhunekŋetâ hâhiwin nâŋgâman yakât dopŋeâk yen gurâ hâhiwin yiŋginomai. Hâhiwin yiŋgiŋetâ yanâmâ hâkyeŋe ki biuk sâwuap. Yeŋe kârihem kinmâ ki betnohonomai yanâmâ Anitâŋe meyekmâ manman kârikŋan katyekmu mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Otmu torokatmâ yuwu sâop. “Emelâk emet inânŋan poropete âlâŋe den yuwu kulemguop. “Kasalipyeŋaŋe opon kâmbukŋan yâhâm orotmeme bâleŋe topŋe topŋe otnomai. Yawu otŋetâ yekmâ Yuraia hânân kapi tatmâ arap ya ambolipŋaŋe pilâm itoŋ galaŋ otmâ hewukŋehen ari misiŋguraknomai.” Yawu kulemguop. Den kulemguop yu biwiyeŋan katmâ nâŋgâm mannomai. Yawu mannomai gârâmâ kasalipyeŋaŋe otŋetâ bâlewuap ya ekmâ yawuya otmâ yan hilipyongomaihât yahatmâ itoŋ galaŋ otmâ hewukŋehen ari misiŋguraknomai. ");
INSERT INTO spl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Otmu Yerusalem kapi ambolipŋaŋe gurâ yawuâk sururuk sâm ari misiŋguraknomai. Yawu otmâ emetyeŋan âwurem ari itâ pareŋe miakne sâm yakât ki nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Otmu lohimbi nep tuhuakmâ mannomaiŋe âwurem taka emetyeŋan iri sikumyeŋe miaknehât ki nâŋgânomai. Yekmâ yapâek hewukŋehen ari misiŋguraknomai. ");
INSERT INTO spl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sâp yanâmâ imbi tepdâ umat karat mannomai otmu ŋaŋa hewâk hewâhâk mem hikakmâ manŋetâ wâtyeŋe ki tiŋ tiŋ sâwuap yaŋe hiliwahomaihât yeŋe Anitâ ulitgunomai. ");
INSERT INTO spl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Otmu kasalipyeŋe to yambu sâpŋan takamai sâm Anitâ yawuâk ulitgunomai. ");
INSERT INTO spl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kasalipyeŋaŋe takanomai yanâmâ umatŋe pato nandoroŋe kakyeŋan yâhâwuap. Kândikum Anitâŋe lohimbi katyelehop yapâek umatŋe yan yuwuya âlâ ki teteop. Yawu gârâmâ umatŋe kakyeŋan yâhâwuap yukât kakŋan yuwuya âlâ ki tetewuap. ");
INSERT INTO spl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Anitâŋe ikŋe lohimbilipŋe kerek hiliwahom metemaihât sâp ya mem tâlâwâk tuhuwuapgât sâm kalop. Yâhâ ki sâm kalop mâne lohimbi hârok muŋetâ hâmeyeŋe ki kinbuapgât dop tetembâp. ");
INSERT INTO spl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Otmu lok nombotŋaŋe nâhât yuwu sâm yen kâityongonomai. “Anitâŋe Yesu hâŋgângumu âwurem ge tihitnenŋe otbuap sâop yamâ emelâk hâŋgângumu endaken ge mansap, me wosaken me wosaken ge mansap,” sâm ekyongoŋetâ yâk yeŋgât den ya ki nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sâp yanâmâ lok perâkŋe nombotŋaŋe topyeŋe kurihiakmâ oain sâm oain sâm otmâ yuwu sâm ekyongonomai. “Nâ galemyeŋe manbehât Anitâŋe âi sâm nihim hâŋgânnohomu ge mansan.” Yawu sâm nâhât lohimbi bulâŋe yaŋe yâk yeŋgâlen torokatŋetgât kulem topŋe topŋe menomai. Yawu otŋetâ yekmâ betyiŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yawu gârâmâ yâkŋe eŋgatyeŋan geŋetâ lohotŋe otmaihât emet inânŋan den ekyongoan yu biwiyeŋan katmâ galem oraŋginomai. ");
INSERT INTO spl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Umatŋe topŋe topŋe tetewuap yanâmâ hilâmgât emetsenŋe otmu omoŋgât emetsenŋe yamâ bok sâmu omoŋ sahakbuap. ");
INSERT INTO spl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Omoŋ sahakmu pitu yaŋe himbimâmbâ pek sâm genomai. ");
INSERT INTO spl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yawu otmu yanâmâ Anitâŋe yâhâpŋe hâŋgânnohomu elem kulewoŋboŋ kakŋambâ gemune kulem âlâlâ tetewuap yan wâtne pato tetemu ekŋetâ ae seŋ seŋ otbuap. ");
INSERT INTO spl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sâp yanâmâ aŋelolipne hâŋgânyongomune emetsenŋe gahaŋehen geheŋehen hân ewun embun nâhât pat manmâ arai ya kerehâk mem menduhuyeknomai. ");
INSERT INTO spl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sâp yan âwurem gewom yakât nâŋgâŋetâ keterahâkgât den âlâen hâum sâwe. Nenâmâ bândup baiako ya huhuakmu ekmâ yanâmâ “Emet kinbe sâm oap,” sâmain. ");
INSERT INTO spl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yakât dopŋeâk hâmbâi den yan yukât bulâŋe tetemu ekmâ yuwu sânomai. “Âo, yu Yesuŋe emet inânŋan den eknongop yakât bulâŋe tetemu eksain.” Yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Otmu den yan yuâmâ lohimbi âun yu mansai ki muŋetâek bulâŋe tetewuap. Yakât yuwu sâwe. Den yan yukât bulâŋe bulâŋanâk tetewuap. ");
INSERT INTO spl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yâhâ hân himbim pitu âlâlâ emelâk Anitâŋe kalop ya biatmâ metewuap. Yawu gârâmâ nâhât den yamâ ki biatbuap. Yamâ tat tat kârikŋe tatmâ yâhâmbisâp. ");
INSERT INTO spl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sâp pato tetewuap yakât yuwu sâmune nâŋgâŋet. Sâp gewom lohimbi kerekŋe yakât ki naŋgai. Otmu aŋelo himbimân tatmai yâkŋe gurâ yawuâk ki naŋgai. Otmu ninak gurâ ki naŋgan. Awoŋne himbim amboŋe ikŋahâk naŋgap. ");
INSERT INTO spl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sâp girawuân me girawuân âwurem gewom yakât ki naŋgai. Yakât otmâ biwi pâlâmŋe manmaihât den âlâen hâum yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lok kutdâ âlâŋe emetŋe pilâm kapi kâlepŋehen ari tipiŋe manmâ âwurem tohowuap. Yawu gârâmâ ariwe sâm otmâ âi loklipŋe âi sâm yiŋgim yuwu sâm ekyongowuap. “Âi sâm yiŋgian yu tiŋâk mem menomai.” Yawu sâm lok âlâ mem “Hâŋgi yukât galem kin,” sâm katmâ ariwuap. ");
INSERT INTO spl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Katmâ arimu yâkŋe galem kinbuap gârâmâ lok kutdâŋe sâp girawuân âwurem takawuap ya ki naŋgap. Omoŋ derep kâmbukŋan, me emet eŋgatŋe nâŋgâmu yan, me emetsâpŋe, me sâp girawuân me girawuân takawuap ya ki naŋgap. Yakât otmâ yâkŋe sen galemâk otmâ manbuap. Yâhâ yakât dopŋeâk nâŋe sâp girawuân taka yen meyekbom ya ki naŋgai. Yakât otmâ biwi golâek manmâ âi sâm yiŋgiwan ya tiŋâk mem mannomai. ");
INSERT INTO spl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yâhâ den yan yuâmâ yeŋgâlâk ki yan. Yen otmu hâmbâi lohimbi tetem mannomaiŋe biwi nâŋgân nâŋgânyeŋe nâhâlen kepeim mannomai kerek yeŋgât yan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Otmu Tihit tihit hombaŋ ya tâlâhuop. Otmu hombaŋ yakât kutŋe âlâmâ “Natik Hombaŋ” yawu sâmain. Hombaŋ ya tâlâhumu yanâmâ hotom uwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum ningiminiwiŋe menduhuakmâ Yesu kumunŋe mumbuap sâm yakât den hikuwi. ");
INSERT INTO spl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yawu otmâ benŋe yuwu sâm alahuwi. “Yuâmâ Tihit tihit Hombaŋ otbuap. Yakât otmâ halihu lohimbi dondâŋe taka menduhuaknomai. Yawu gârâmâ sâp yan nenŋe Yesu mem pâi emetŋan katmunŋe tatmu lohimbiŋe eknomai yanâmâ kuk pato tetewuap. Yawu otmunŋe kuk pato tetemapgât yok pilâm in yawu mem kumunŋe mumbuap. Yawu sâm den hikuwi. ");
INSERT INTO spl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Otmu Yesuŋe menenekmu Betani kapiân yan yâhâwin. Yan yâhâ lok âlâ, kutŋe Simon sâm, hâk bâle tetewaŋgimu manminiop ya heŋgeŋguop yâkât emelan yâhâ orowâk tatmâ sot newin. Sot nem tatmunŋe imbi âlâŋe to kukŋe suk sukŋe âlâ, hâmeŋe yahat yahatŋe ya mem emelan tatbinân gaop. Ga maŋguŋe mem hindâm Yesuhât kunŋan motelemu giop. ");
INSERT INTO spl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Motelemu gemu lok nombotŋaŋe ekŋetâ bâlemu yuwu sâwi. “Wongât to kukŋe suk sukŋe yu imbiâk mem motelemu kunŋan giap. Ya ekmunŋe ki ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nenŋe to yu âlepŋe mem arimunŋe lok nombotŋaŋe l000 kina yawuyaŋe puluhuŋetâ yakât hâmeŋe mem ari lohimbi umburuk mansai yawu ya tânyongombâingât dop.” Yawu sâwi. Yawu sâm imbi ya ekmâ sâwi. ");
INSERT INTO spl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ekmâ sâŋetâ Yesuŋe nâŋgâmu ki ârândâŋ otmu yuwu sâm ekyongop. “Kâmbukŋe. Pilâŋet. Imbi yuŋeâmâ kulem oap yukât nâŋe nâŋgâmune âiloŋgo oap. Yakât yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Lok umburuk mansai yamâ sâp kâlep manŋetâ tânyongonomaihât dop tap. Yâhâ nâmâ sâp kâlep ki otmuâk pilâyekbom. ");
INSERT INTO spl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nâmâ mumune lâmân hannohonomai yakât mâtâp menihim imbi yuŋe to kukŋe suk sukŋe ya motelemu kunnan giap. ");
INSERT INTO spl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yakât yuwu sâmune nâŋgâŋet. Nâhât den pat âlepŋe yu hânŋan kulemŋan ari ekyongonomai. Otmu imbi yuŋe kulem otnihiap yukât den pat ya gurâ yawuâk ekyongoŋetâ nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Otmu sâp yan Yesuhât hoŋ bawalipŋe kâiân yâhâp manbin. Gârâmâ bukunenŋe âlâ kutŋe Yurasi sâm, yâkŋe hotom uminiwi yeŋgât kunlipyeŋe yeŋgâlen ariop. Ari Yesu menomai yakât hâmeŋe membuap yakât ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ekyongomu nâŋgâm heroŋe otmâ hâmeŋe waŋnomai yakât ekuwi. Otmu girawu tuhum yok pilâm meŋetâ lohimbiŋe ki eknomai yakât nâŋgâm manop. ");
INSERT INTO spl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Otmu emet haŋ sâmu nenŋe yuwu sâm Yesu âikuwin. “Natik Hombaŋ tâlâhuap. Yakât otmâ hândâhân lama nanŋe âlâ gâim katmunŋe mem Anitâhât hotom unomai. Yawu gârâmâ emet wosan ari sot umunŋe orowâk nenom?” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yawu sâm âikumunŋe Yesuŋe bukuyâhâtnenŋe yâhâp yuwu sâm hâŋgânyotgop. “Yerusalem kapiân yâhâmutâ hoŋ bawa lok âlâ âsâpŋe lâuakmu ekdomawot. ");
INSERT INTO spl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Lok ya ekmâ betŋan watmâ ari emet âlâen yâhâmu ekmâ yan yâhâromawot. Yâhâmâmâ emet yakât amboŋe yuwu sâm ekuromawot. “Nengât bawapinenŋaŋe yuwu yap. “Nâŋe hoŋ bawalipne meyekmune emet yukât biwiŋe âlâen tatmâ sot um nenom yakât otmâ emet biwiŋe ya tiripnotgorâ ekde.” Yawu sâm ekuromawot. ");
INSERT INTO spl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yawu sâm ekumutâ lok yaŋe dâiyelekmâ emet biwiŋe âlâ mem heŋgeŋguŋetâ tap ya tiripyotgowuap. Tiripyotgomu yanâmâ senŋe âlâlâ mem dinŋan tuhuromawot.” Yawu sâm hâŋgânyotgomu yâhâowot. ");
INSERT INTO spl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yâhâ Yesuŋe den ekyotgop ya watmâ senŋe âlâlâ mem dinŋan tuhuowot. ");
INSERT INTO spl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mem dinŋan tuhumutâ emetsâpŋe otmu yan Yesuŋe menenekmu emelan yâhâ sot newin. ");
INSERT INTO spl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nem tatmunŋe Yesuŋe yuwu sâop. “Sâmune nâŋgâŋet. Yeŋe nâ orop manmâ lau konok nem buku oraŋgim manmain. Yamâ yeŋgâlembâ lok âlâŋe betnehen kioŋmâ kasalipne yeŋgât bâtyeŋan mem katnekbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yawu sâmu nâŋgâmunŋe biwinenŋe umatŋe otmu yakât topŋe nâŋgâne sâm nenŋe ikŋiâk ikŋiâk yuwu sâm âikuwin. “Gâŋe nâhât yat me âlâhât yat?” ");
INSERT INTO spl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","21","Yawu sâm âikumunŋe yuwu sâm eknongop. “Anitâŋe sâmu kulemguwi yakât bonŋe nâhâlen tetemu nohoŋetâ mumbom yakât sâp tâlâhuap. Yakât otmuâmâ yeŋgâlen gâtŋe âlâŋe oto konohân nâ orop sot nendomait yâkŋe yawu otnihiwuap. Yawu otnihiwuap yakât matŋe hâmbâi umatŋe dondâ membuap. Yakât otmuâmâ mâmâŋaŋe ki mem ga katbâp yamâ mem ga kalop yawu naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Otmu sot nem tatbin yan Yesuŋe baŋga mem Anitâ mepaem motokmâ ningim yuwu sâm eknongop. “Yu mem neŋet. Yuâmâ nâhât sunumne yawu oap.” Yawu sâm mem ningimu newin. ");
INSERT INTO spl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ningimu nemunŋe yaŋak wain to mem Anitâ yâhâpŋe mepaem gâim ningimu newin. ");
INSERT INTO spl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ya mem nemunŋe yuwu sâm eknongop. “Wain to yuâmâ nâhât hepne yawu oap. Gârâmâ nohoŋetâ hepne gemu mumbom Anitâŋe nâhât den sâm kalop yakât bulâŋe tâŋ tâŋâk tetewuap. Yawu otmu lohimbi kerek yeŋgât tosayeŋe Anitâŋe pilâyiŋgiwuapgât mâtâp tetem heŋgeŋguwuap. ");
INSERT INTO spl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nâ sâp yiwereŋe wain to yu yen orowâk ki nem yâhâwom. Yawu gârâmâ yu nemunŋe ki pesuk yap. Hâmbâi Anitâŋe âlâkuâk hâŋgânnohomu âwurem gewom yanâmâ yen orowâk nem yâhânom.” ");
INSERT INTO spl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yawu sâm tiŋ pilâmu yapâ yahatmâ Anitâ mepaem kiki mewaŋgim ya pilâm Oliwa pumŋan yâhâwin. ");
INSERT INTO spl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mâtâwân yâhâm tatmunŋe yuwu sâm eknongop. “Anitâŋe emet inânŋan poropete âlâ den ekumu kulemguop ya yuwu tap. “Nâŋe sâmune lama yeŋgât amboyeŋe ya kuŋetâ mumbuap. Otmu yâk watmâ manmai ya hârok gem tiok taok otmâ arim kinnomai.” Yawu kulemguop tap. Den yakât bonŋe yu tetewe sâm oap. Yakât otmâ kasalipnaŋe taka menekŋetâ yen kerekŋe kiŋgityeŋahât otmâ gem tiok taok otmâ arinomai. ");
INSERT INTO spl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Menekmâ ari nohoŋetâ mumbom yamâ benŋe mumuŋambâ yahatbom. Mumuŋambâ yahatmâ Galilaia hânân ari mambotyiŋgim tatmune yen aksihâk ariŋetâ menduhuaknom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yawu sâmu Petoroŋe matŋe yuwu purik pilâwaŋgiop. “Gâhât kasa takanomai yan yâkŋeâmâ kiŋgityeŋahât otmâ arinomai. Yâhâ nâmâ bia, nâ ki pilâhekmâ ariwomgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sâmu sâop. “Naŋgat. Gâŋe omoŋ yukâlâk nâhât “Ki nâŋgâwaŋgian,” sâwuat. Yawu sârâ kalimbuŋe otbuap yan gokorok yâhâpŋe isewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yawu sâmu kârikŋe otmâ yuwu sâop. “Nâmâ gâ orowâk tatdom. Yawu tetehihimu nâŋe gâ ki pilâhekmâ ariwom. Me kiŋgitnahât gurâ ki otbom. Nâŋe gâhât topgahât âinohoŋetâ ki kurihiwom. Me gohone sâm otnomai yanâmâ nâ orowâk tatmutŋe notgonomai.” Yawu sâop. Yawu sâmu nenŋe gurâ yâkŋe sâop yawuâk sâwin. ");
INSERT INTO spl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ari kapi âlâ, kutŋe Gesemane sâm, yan ariwin. Yan ari Yesuŋe yuwu sâm eknongop. “Yen yuân tatŋetâ nâŋe awoŋ orop ba den tipiŋe alahure.” Yawu sâmu yan ge tatbin. ");
INSERT INTO spl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yan ge tatmunŋe Petoro, Yakowo, Yoane meyekmu yeŋiâk bawi. Ba kinmâ umatŋe tetewaŋgiwe sâm olop yakât nâŋgâmu biwiŋaŋe umatŋe otmu yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Yen yuân galem tatŋet. Hâkne biuk sâmu biwine umatŋe dondâ oap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yawu sâm katyekmâ pereŋ pilâm ge pare im Anitâŋe nâŋgâmu umatŋe ya pesuk sâwaŋgiâkgât yuwu sâm ulitguop. ");
INSERT INTO spl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“O Awoŋ, gâmâ yu me ya otbe sâm ki hâum pâpgumat. Umatŋe yu tetenihiwe sâm oap ya nâŋgârâ ki teteâkgât naŋgan. Yawu gârâmâ nâhât ombe watmâ ki otbuat. Gike ombeheâk watmâ otbuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yawu sâm yahatmâ âwurem ba yekmu aman pâlâmŋe iŋetâ mândeyekmâ Petoro yuwu sâm ekuop. “Simon, aman pâlâmŋe im tat yukâ. Nâ yiwereŋe pilâyekboman. Yakât pâlâmŋe ki ot.” ");
INSERT INTO spl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yawu sâm ekum benŋe yuwu sâop. “Biwiyeŋeâmâ heweweŋ oap. Yâhâ wâtyeŋeâmâ houŋ sâmu aman iai. Yen lohotŋe otmâ pilânekmaihât golâek tatmâ Anitâ ulitguŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yawu sâm ekyongom benŋe pereŋ pilâm ba kinmâ aŋgoân sâop yawuâk sâm Anitâ ulitguop. ");
INSERT INTO spl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ulitgum pesuk pilâm âwurem ba hoŋ bawalipŋe yeksan mâne aman pâlâmŋe iwi. Yawu iŋetâ mândeyehop. Mândeyekmu yahatmâ aŋulakmâ den biaek otbi. ");
INSERT INTO spl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yawu otŋetâ benŋe kalimbuŋe pereŋ pilâm ba Anitâ ulitguop. Ulitgum pesuk pilâm âwurem ba mândeyekmâ yawu sâm ekyongop. “Bâe, yen naŋgai me? Wongât aman pâlâmŋe im tai. Emelâk Anitâŋe yu otbomgât hâŋgânnohomu gewan. Yakât topŋe teteâkgât kasalipnaŋe menekmâ ari hilipnohonomai yakât sâp tâlâhuap. ");
INSERT INTO spl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bâiŋ, yen yahatmâ enda yekŋet. Nâhât den halop alahum kinsai. Gârâmâ yeŋgâlen gâtŋe betnehen kioŋsapŋe taka kinsap. Yakât yahatŋetâ ba yekne.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yawu sâm eknongomu yanâk hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum ningiminiwi otmu Yura nengât papatolipnenŋaŋe lok seseŋgâlâk hâŋgânyongoŋetâ bukunenŋe Yurasiŋe dâiyekmu Yesu mene sâm takawi. Takaŋetâ nen orop ahomaingât nâŋgâm kapamgât wahap miakmâek takawi. ");
INSERT INTO spl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lok takawi ya Yurasiŋe kulem girawu otmu menomai yakât yuwu sâm ekyongop. “Yesu parahumune ekmâ yanâk ga mem arinomai.” Yawu sâm ekyongom dâiyekmu takawi. ");
INSERT INTO spl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gotnenŋan takamâmâ kasa ya kinŋetâ Yurasiŋe Yesu gotŋan ga parahum yuwu sâop. “O, patone, mandâ manman.” ");
INSERT INTO spl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yawu sâm parahumu yanâk ga Yesu mewi. ");
INSERT INTO spl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Meŋetâ kinmu yanâk nengâlen gâtŋe âlâŋe yahatmâ tewetŋe mem hotom uminiwi ya yeŋgât kunyeŋahât hoŋ bawaŋe ya ândâpŋe nombot ya topŋambâek kârâm hâreop. ");
INSERT INTO spl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kârâm hâremu Yesuŋe yuwu sâm âiyongop. “Yen unam tewet otmu kapamgât sâtŋe metŋe âlâlâ mem takai. Yeŋe nâhât lok bâleŋe sâm menekne sâm takai me? Me lok bâleŋe âlâ kune sâm takai? Ya ekmune bâleap. ");
INSERT INTO spl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hilâm ârândâŋ nâmâ Anitâhât opon kâmbukŋan yâhâ den kâsikum yiŋgim gaman. Yan bân menekbâi yamâ emet inânŋan Anitâŋe poropetelipŋe den ekyongomu kulemguwi yakât bulâŋe yu teteap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yawu sâmu ekmunŋe hâknenŋe biuk sâmu yahatmâ tiok taok otmâ arim kinbin. ");
INSERT INTO spl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tiok taok otmâ arim kinmunŋe yanâmâ lok sihan âlâ sâŋgum kaok latmâ kinopŋe betyeŋehen ariop. ");
INSERT INTO spl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Betyeŋehen arimu ekmâ mem hilipgum sâŋgumŋeâk mem kon pilâŋetâ hâk barak yahatmâ sururuk sâm ariop. ");
INSERT INTO spl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","54","Nenâmâ kerehâk kiŋgitnenŋahât otmâ gem tiok taok otmâ arim kinmunŋe Petoroŋe ikŋiâk betyeŋehen tihâk ariop. Otmu hotom uminiwi ya yeŋgât kunyeŋe yâkât emelan Yesu mem ariwi. Mem ariwi sâp yan hotom uminiwi ya yeŋgât lok kunlipyeŋe otmu Yura lok nengât kunlipnenŋe otmu Mosehât girem den kâsikum ningiminiwi ya kerekŋe emet yan yâhâ menduhuakmâ kinbi. Yan yâhâ menduhuakŋetâ tembe lâu emet yakât galem kinbiŋe kâlâp uŋetâ semu nâŋgâm ikaiakmâ tatbi. Yawu otmâ tatŋetâ Petoroŋe yâk yeŋgât hohetyeŋan ba kâlâp nâŋgâm ikaiakmâ talop. ");
INSERT INTO spl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Otmu emet yan yâhâ menduhuakbiŋe girawu tuhumunŋe muâkgât nâŋgâm den golâ topŋe topŋe gahaem hakŋan sâwi. Yawu otmâ lok dondâŋe den girawuân hâum sâŋetâ kunlipyeŋaŋe nâŋgâŋetâ ârândâŋ otbuap yakât pâpguwi. Den sâm ariwi yaŋe ki lâuahop. ");
INSERT INTO spl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yâhâ lok nombotŋaŋe yahatmâ yuwu sâm hakŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Lok yuŋeâmâ den âlâ yuwu sâmu nâŋgâwin. “Opon kâmbukŋe emelâk tuhuwi yuâmâ nâ niniâk liakum yâhâpŋe hilâm kalimbu kâlehen tuhum maŋguwom. Lok âlâ me âlâŋe ki tânnohowuap.” Yawu sâop.” Yawu nâŋgâm tâpikgum hakŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Otmu den sâwi yaŋe gurâ ki lâuahop. ");
INSERT INTO spl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Otmu hotom uminiwi ya yeŋgât kunyeŋaŋe yahatmâ kinmâ Yesu yuwu sâm ekuop. “Gâ wongât otmâ den âlâlâ âihohomunŋe yakât matŋe ki kâpeksat? Yawu otdâ ekmunŋe ki ârândâŋ oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yawu sâmu benŋe Yesuŋe olotoŋâk kinop. Olotoŋâk kinmu witgum âikuop. “Bâiŋ, witgumâk âihohowe. Gâ Anitâŋe ikŋe nanŋe bulâŋe ya hâŋgângohomu ge yu mansat me bia? Sârâ nâŋgâne.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sâmu sâop. “Yu yat yakâ. Nâmâ Anitâŋe hâŋgânnohomu gewan. Yawu gârâmâ hâmbâi Anitâŋe wâtŋe nihim âlâkuâk hâŋgânnohomu elem kulewoŋboŋ kakŋambâ âwurem ge yeŋgât kunyeŋe tatmâ yâhâmbisâm. Sâp yan Anitâhât wâtŋe ya nâhâlen tetemu eknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yawu sâmu den ya nâŋgâmu bâlemu yahatmâ ikŋe sâŋgum mem duhatmâ bukulipŋe yuwu sâm ekyongop. “Bâiŋ, den kâmbukŋe hâliliŋe sâmu nâŋgâmunŋe pesuk yap. ");
INSERT INTO spl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ikŋahât nâŋgâmu yahatmu Anitâhât kaweŋan kinbe sâm oap. Yakât otmâ girawu tuhunomgât naŋgai?” Yawu sâm âiyongop. Âiyongomu den yakât alahu gulahu otŋetâ biwiyeŋe konohâk otmu yuwu sâwi. “Bâiŋ, yu otmu bâleapgât muâkgât naŋgain.” Yawu sâm hârewaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sâm hârewaŋgim nombotŋaŋe yahatmâ tâpguwi. Tâpgum gâtŋaŋe sâŋgum âlâ mem senŋe sâhâm kâtâpguŋetâ kinop. Senŋe sâhâm kâtâpgum ândâpŋe huhuwi. Ândâpŋe huhum nombotŋaŋe yuwu sâm âikuwi. “Bâiŋ, ândâpge âlâŋe huhuap? Yakât sârâ nâŋgâne.” Yawu otŋetâ pesuk sâmu tembe lâu emet yakât galem kinbiŋe kum me âlâlâ tuhuwi. ");
INSERT INTO spl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yawu otbaŋgiŋetâ Petoro yâhâmâ yawuâk kâlâp nâŋgâm ikaiakmâ talop. ");
INSERT INTO spl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tatmâ yanâk hotom uminiwi ya yeŋgât lok kunyeŋahât hoŋ bawa imbi âlâŋe towatŋe ekmâ yuwu sâm ekuop. “Âe, gâmâ Yesu Nasaret amboŋe orop manŋetâ yekman.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yawu sâmu nâŋgâm kurihiakmâ yuwu sâop. “Âe, gâŋe den yakât ki naŋgan. Gâŋe den yat yakât topŋe ki nâŋgâm heŋgeŋguan.” Yawu sâm yahatmâ pilâyekmâ endunâken ba kinmu yanâk gokorok isiop. ");
INSERT INTO spl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gokorok isemu imbi yaŋe yâhâpŋe ekmâ lok yan kinbi ya yuwu sâm ekyongop. “Wâe, lok yuâmâ Yesu bukulipŋe orop manŋetâ yekman.” ");
INSERT INTO spl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yawu sâmu Petoroŋe yâhâpŋe kurihiahop. Kurihiakmu sâp kâlep ki otmuâk yan kinbiŋe Petoro towatŋe ekmâ yuwu sâwi. “Wongât kurihiaksat? Gâhât towatge gekmâ naŋgain. Bulâŋanâk gâmâ Galilaia amboŋe.” Yawu sâm ekuwi. ");
INSERT INTO spl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yawu sâm ekuŋetâ kurihiakmâ yuwu sâop. “Bâiŋ, yuwu sâmune nâŋgâŋet. Nâ Anitâhât senŋan kinmâ den membom otmuâmâ yâkŋe matŋe nihiwuap. Lok yai yakât nâŋe bulâŋanâk ki nâŋgâwaŋgian.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yawu yan mâne yanâk gokorok yâhâpŋe isiop. Gokorok isian mâne Yesuŋe emet inânŋan den ekuop ya nâŋgâmu teteop. “Gâŋe nâhât “ki nâŋgâwaŋgian” sârâ kalimbuŋe otbuap yan gokorok yâhâpŋe isewuap.” Yawu sâop ya nâŋgâmu tetemu isiop. ");
INSERT INTO spl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Otmu emet haŋ sâmu yan hotom uminiwi ya yeŋgât kunlipyeŋe, Mosehât girem den kâsikum ningiminiwi otmu Yura nengât kunlipnenŋe hârokŋe in yawu menduhuakmâ Yesu muâk sâm den hikuwi. Yawu otmâ Yesu bâtŋan sâhâm dâim Roma yeŋgât kiap âlâ, kutŋe Pilato sâm, yâkât den sâsâ emetŋan ariwi. ");
INSERT INTO spl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dâim Pilatohâlen ariŋetâ yâkŋe yuwu sâm âikuop. “Yura yeŋgât lok kutdâ sâmai ya gâ me?” Yawu sâop. Sâmu sâop. “Oŋ, den bulâŋe yat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yawu otmâ hotom uminiwi ya yeŋgât kunlipyeŋaŋe den golâ topŋe topŋe sâm Yesu hakŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yakât otmâ Pilatoŋe Yesu yuwu sâm âikuop. “Den topŋe topŋe gâhâlen kârâm pilai. Yakât otmâ girawuhât otmâ matŋe ki kâpekyiŋgiat?” ");
INSERT INTO spl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yawu sâmu den biaek kinop. Yawu kinop yakât Pilatoŋe ekmu sâtŋe olop. ");
INSERT INTO spl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Otmu Tihit tihit hombaŋ ârândâŋâk Pilatoŋe yuwu otminiop. Lok tosa otŋetâ pâi emetŋan katyekŋetâ tatminiwi yapâ gâtŋe âlâ me âlâhât lohimbiŋe nâŋgâŋetâ dopŋan otmu lok âlâ holaŋbuat sâminiwi ya holaŋyekmu geminiwi. ");
INSERT INTO spl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yâhâ sâp yan lok bâleŋe âlâ, kutŋe Barawa sâm, yâkŋe kapam ahowiân lok âlâ kumu muop. Yakât otmâ pâi emetŋan mem katŋetâ tatmâ gaop. ");
INSERT INTO spl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","10","Yawu gârâmâ Pilatoŋe yuwu nâŋgâop. “Lohimbi dondâŋe Yesuhât nâŋgâŋetâ yahatmap. Yakât otmâ hotom umai ya yeŋgât kunlipyeŋaŋe nâŋgâŋetâ bâlemu yaŋak muâkgât sâm hârewaŋgim nâhâlen mem takai.” Yawu nâŋgâop. Yâhâ lohimbi kiŋgitŋe orowâkŋe yâkâlen ari menduhuakmâ pâi emetŋan tatbi yapâ gâtŋe âlâ holaŋmu giâkgât ekuwi. Ekuŋetâ yuwu sâm âiyongop. “Nâŋe Yura yeŋgât lok kutdâ yu holaŋmune giâkgât naŋgai me bia?” Yawu sâm âiyongop. ");
INSERT INTO spl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yawu sâm âiyongomu hotom uminiwi ya yeŋgât kunlipyeŋaŋe lohimbiŋe Pilato ekuŋetâ Barawa holaŋmu giâkgât eŋgatyeŋan gewi. Yakât otmâ lohimbi yaŋe Barawa holaŋmu giâkgât ekuwi. ");
INSERT INTO spl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yawu ekuŋetâ Pilatoŋe yuwu sâm âiyongop. “Yawu gârâmâ yeŋgât lok kutdâ yakât girawu otbaŋgiwomgât naŋgai?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yawu sâmu yahatmâ den yuwu halahum sâwi. “Yâk howanân kum kânâŋgâŋetâ muâk.” ");
INSERT INTO spl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sâŋetâ sâop. “Wuân otmu bâleopgât yawu yai?” Yawu sâmu âlâkuâk yahatmâ sâwi. “Howanân kum kânâŋgâŋetâ muâkgât naŋgain.” Yawu sâm sâm hârewi. ");
INSERT INTO spl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Otmu Pilatoŋe lohimbi yaŋe ikŋahât nâŋgâŋetâ yahalâkgât lauyeŋan mem tembe lâulipŋe ekyongomu Barawa holaŋetâ gem ariop. Otmu Yesu mem kândâtŋe lawitŋetâ hepŋak kiŋ pisiliŋ sâop. Yawu otŋetâ Pilatoŋe hâŋgânyongomu howanân kuŋetâ muâkgât mem ariwi. ");
INSERT INTO spl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tembe lâulipŋaŋe yahatmâ Yesu mem ya pilâm emet âlâen katŋetâ talop. Yawu otmâ tembe lâu bukulipyeŋe meyekŋetâ ga menduhuakbi. ");
INSERT INTO spl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Menduhuakmâ hâk katipŋe kâkâlep, kuriŋ takop takop yamâ lok kutdâŋe mânuŋakmâ manminiwi yawuya mem mânuŋbaŋgiwi. Yawu otmâ tâk âlâ sâtŋe metŋe, hatman yawuyaŋe mem goŋgoŋgum lok papato yeŋgât ŋerendeŋ ya dop kum kunŋan kepeim âlihitbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yawu otbaŋgim gotŋan ba senŋan gem giriŋbaŋgim yuwu sâm ekuwi. “Bâe, Yura yeŋgât lok kutdâ pato. Yakât otmâ torokatmâ mangât naŋgain.” Yawu sâm senŋan gewi. ");
INSERT INTO spl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Senŋan gem kundenŋan tâpguwi. Tâpgum kapam âlâ mem kunŋan lawitbi. ");
INSERT INTO spl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Senŋan geŋetâ dopŋan otmu hâk katipŋe kuriŋ ya mem tuhum pilâm ikŋe hâk katipŋe mem mânuŋbaŋgim yaŋak mem howanân kum kânâŋgâne sâm dâim ariwi. ");
INSERT INTO spl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dâim mâtâwân arim tatŋetâ lok âlâ takamu ekbi, yamâ kutŋe Simon sâm, Alesande yet Lupu yetgât âwâyetŋe. Yâhâmâ Kirene hânân gâtŋe. Mem tetem Yesu wâtŋe houŋ sâopgât sâwaŋgiŋetâ Yesuhât howan ya tângum mem lâumu orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ari hân âlâ, kutŋe Golihata sâm, yan ariwi. Kut yakât topŋeâmâ “Lok Kunŋe Hahitŋe,” yawu. ");
INSERT INTO spl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yan ari Yesuŋe hâhiwin dondâ nâŋgâmapgât wain to otmu to ŋasin bâleŋe, kutŋe Miri sâm, ya orop menduhum gâim waŋetâ nemu ŋasinbaŋgimu ukum pilâop. ");
INSERT INTO spl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ukum pilâmu yâkât hâk katipŋe tuhum pilâmâmâ ikŋe howanân kum kânâŋgâŋetâ kinmu hâk katipŋe ya mem “Âlâŋe miakbuap?” sâm mem ketetmâ katbi. Mem ketetmâ katŋetâ tatmu pepa duhatmâ tipi tapi tuhum kutyeŋe ikŋiâk ikŋiâk yan kulemgum amaŋân mânuŋetâ giop. Mânuŋetâ gemu mem gulip malap tuhum yapâ pepa âlâ meŋetâ kut teteop yaŋe miahop. Yawu otbi. ");
INSERT INTO spl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yâhâ omoŋânâk 9 kilok otmu yan howanân kum lâum kânâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yawu otmâ howan yakât kunŋan yuwu kulemgum katbi. “Lok yuâmâ Yura yeŋgât lok kutdâ.” Yawu sâm kulemguwi. ");
INSERT INTO spl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Otmu sâp yanâk lok komborâ yâhâp yotgom lâum kânâŋgâyelekŋetâ nombot nombot kinowot. ");
INSERT INTO spl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yawu otbi yan Anitâŋe emet inânŋan den sâop yakât bonŋe teteop. Den yamâ yuwu. “Nâŋe nine hoŋ bawa hâŋgângumune gemu lohimbiŋe ekŋetâ lok bâleŋe yawu olop.” Yakât bonŋeâmâ lok bâleŋe yâhâp orop yongom lâum kânâŋgâyekŋetâ kinbi. ");
INSERT INTO spl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Otmu lohimbi nombotŋaŋe mâtâp ya watmâ howan hâlâŋmâ arim takawiŋe Yesu ekmâ lauyeŋe butelim yuwu sâwi. “Bâe, gâŋe emelâk yuwu sârâ nâŋgâwin. “Opon kâmbukŋe yamâ nâŋe liakum hilâm kalimbu biwiŋan tuhum maŋguwom,” yawu sârâ nâŋgâwin. ");
INSERT INTO spl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yawu gârâmâ howanâmbâ kâpehakmâ ge.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Yawu sâŋetâ benŋe hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum ningiminiwiŋe senŋan gem yuwu sâm alahuwi. “Lok yuâmâ Anitâŋe hâŋgângumu ge Yura nengât tihitnenŋe otmâ kutdânenŋe mansap sâmai. Lok yuŋe lohimbi nombotŋe tânyongmu ekmain. Yâhâ girawu otmâmâ ikŋeâmâ ki tânahom howanâmbâ kâpehakmâ giap? Kâpehakmâ gemu eknom otmuâmâ biwinenŋe yâkâlen katmâ tem lâuwaŋginom. Yâhâ ki kâpehakmâ gewuawâmâ yuwu sânom. “Âo, lok yuâmâ imbiâk otmap.” Yawu sânom.” Yawu sâm senŋan gewi. Senŋan geŋetâ lok bâleŋe yotgom kânâŋgâyelekŋetâ nombot nombot kinowot yâkŋe gurâ yawuâk senŋan giowot. ");
INSERT INTO spl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Otmu hilâm kârikŋan, 12 kilok olop yan, Anitâŋe nâŋgâmu emetsenŋe ya omoŋ sahahop. Omoŋ sahakmâ yapâ ari emetsâpŋe 3 kilok otmu emet laŋinŋe âlâkuâk pilâop. ");
INSERT INTO spl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yawu otmu Yesuŋe kândâtŋe kuwihakmâ Yura nengât denân yuwu sâm halahuop. “Eli, Eli lama sapaktani,” yawu sâop. Sâop yamâ topŋe yuwu. “O, Awoŋ, wongât nâŋgâm kâkâsuk otmâ betnihiat?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yawu sâmu lohimbi nombotŋaŋe nâŋgâm tâpikgum yuwu sâwi. “Eliahât mon sâm ahom kuakmâ tap.” ");
INSERT INTO spl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yawu sâŋetâ hohetyeŋan gâtŋe âlâŋe sururuk sâm ari sâŋgum âlâ mem nak bâtbâtŋe potonŋan pâŋ pâŋ kepeim yaŋe wain to bâleŋe yan katmâ mem yâhâ lauŋan kalop. Yawu otmâ bukulipŋe yuwu sâm ekyongop. “Eliaŋe himbimâmbâ ge tânguâkgât nâŋgâm kutŋe kunsap mon?. In ekne.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yawu sâmu Yesuŋe den kârikŋe halahum yaŋak muop. ");
INSERT INTO spl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Otmu emelâk lohimbi inŋaŋe opon kâmbukŋe yakât biwiŋe ekmai sâm sâŋgum kâlep pato hikuŋetâ ya kâtâpguminiop. Sâŋgum yaŋe pâŋambâek tok sâm hâreakmâ nombot nombot otmu tetekŋan olop. ");
INSERT INTO spl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yesu muop sâp yan tembe lâu ya yeŋgât kunyeŋe âlâ hâlâŋmâ kinopŋe ekmu âlâ kândâkdâ otmu yuwu sâop. “Lok yuâmâ Anitâhât nanŋe bulâŋe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Otmu imbi nombotŋe pereŋ pilâm endâŋân ba kinbi ya yeŋgât hohetyeŋan kinbi ya yeŋgât kutyeŋe Salome, otmu âlâmâ Maria, Matala kapiân gâtŋe, otmu âlâmâ Mariahât kut nambeŋe otmu yâkât nanyâhâtŋe yâhâp, kutyetŋe Yose otmu imiŋe Yakowo yâhâmâ lok sihan. ");
INSERT INTO spl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Imbi yongonsan yamâ Yesu orop Galilaia hânân manmâ hoŋ bawaŋgim gawi. Yâhâ imbi nombotŋeâmâ Tihit tihit hombaŋ ya ekne sâm Yerusalem kapiân Yesu orowâk yâhâwi yaŋe kinbi. ");
INSERT INTO spl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Otmu lok âlâ, kutŋe Yosep sâm, yâkât topŋeâmâ yuwu. Lok yamâ Arimata kapi yapâ gâtŋe. Emelâk Parisaio, Sarukaio otmu Yura nengât papatolipnenŋaŋe yâk orop menduhuakmâ den otminiwi. Yakât otmâ lohimbi seseŋgâlâkŋe nâŋgâwaŋgiŋetâ yahalop. Otmu Anitâŋe ikŋe hoŋ bawa hâŋgângumu ge Yura nengât lok kutdâ otmâ tihitnenŋe otmâ yâhâwuap yakât biwiŋaŋe mem mambotmâ manmâ gaop. Topŋe yawu. Yâhâ Yesuŋe muop yan lohimbi kerekŋe Tihit tihit Hombaŋ emet haŋ sâmu tetewuap yakât nâŋgâm sot kâle otmu senŋe âlâlâ mem dinŋan tuhuwi. Yakât nâŋgâm Yosepŋe ikŋe hâkŋahât tihitŋe ki nâŋgâm Yesu lâum ari hanguwe sâm Pilatohâlen ari tetewaŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","“Yesu muap,” sâm ekumu nâŋgâm Pilatoŋe eŋgat yâhâp olop. Yakât otmâ tembe lâu âlâŋe ari ekmâ taka sâmu nâŋgâwe sâm hoŋ hâŋgângumu ariop. ");
INSERT INTO spl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","46","Ari ekmâ âwurem taka “Emelâk muap,” sâm Pilato ekuop. Ekumu Pilatoŋe Yosep nâŋgâwaŋgiop. Nâŋgâwaŋgimu yâkŋe sâŋgum kaok âlâ puluhuop. Yawu otmâ bukulipŋe meyekmu ari howanâmbâ Yesu mem sâŋgum yaŋe katipguwi. Katipgum lâum ari kât mâtâpŋe âlâ, dikin yawuya, yamâ emelâk kusânmâ mem tiŋgâloŋetâ kinop yan lâum ari katbi. Lâum ari katmâ kât âlâ lâum hâpunŋetâ ba mâtâpŋe ya maŋguop. ");
INSERT INTO spl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maŋgumu ariŋetâ Maria Matala kapiân gâtŋe otmu nambeŋe, Yose mâmâŋe, orop yan tatmâ ehowot. ");
INSERT INTO spl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tatmâ nâŋgâ nâŋgâ sâp ya pesuk sâmu Maria Matala kapiân gâtŋe, nambeŋe ya Yakowo mâmâŋe, otmu Salome yâkŋe Yesu pirinom sâm kendiŋân ari to kukŋe suk suk âlâ puluhuwi. ");
INSERT INTO spl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Puluhum emet âlâen yâhâ iwi. Otmu haŋ sâmu yahatmâ sumângen ariwi. Mâtâwân arim yeŋiâk alahu gulahu otmâ yuwu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","“Yâhâlen kât pato nandoroŋe hâpunŋetâ mâtâpŋe ya maŋguop. Yakât otmâ âlâŋe tânnongom kât ya hâpunŋetâ kâlehen banom?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yawu sâm alahum ariwi. Ari senyeŋe pilâm eksain mâne kât pato ya emelâk hâpunŋetâ mâtâpŋe ya tetekŋan kinmu ekbi. ");
INSERT INTO spl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ekmâ kâlehen yâhâwi. Kâlehen yâhâm lok sihan âlâ hâk katipŋe kaok kâlep mânuŋahop yaŋe tatmu ekbi. Ekmâ umutyeŋe ariop. ");
INSERT INTO spl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lok yaŋe yuwu sâm ekyongop. “Yen kiŋgityeŋahât ki otŋet. Yesu Nasaret amboŋe howanân kuwi ya ekne sâm takai ya naŋgan. Yâhâmâ yuân ki tap. Emelâk mumuŋambâ yahatmâ arap. Ga gewâkŋeâk ekŋet. ");
INSERT INTO spl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ekmâ arimâmâ Petoro otmu hoŋ bawalipŋe nombotŋe ya yuwu sâm ekyongonomai. “Yâhâmâ emelâk mumuŋambâ yahatmâ Galilaia hânângen ari tap. Yawu gârâmâ yen yawuâk ari yâk penewaŋginomai.” Yawu sâm ekyongonomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yawu sâm ekyongomu kiŋgityeŋahât otmâ kâi bâtyeŋe sân sân sâm yapâ pilâm sururuk sâm ba ariwi. Ari lohimbi nombotŋe yakât ki ekyongowi. ");
INSERT INTO spl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tatmâ nâŋgâ nâŋgâ sâp ya pesuk sâop. Gârâmâ emet haŋ sâmu yanâmâ Yesuŋe mumuŋambâ yahalop. Otmu Maria Matala kapiân gâtŋe, ikŋak emelâk weke bâleŋe nombolân yâhâp watyekmu yâkâlembâ gahaeakmâ ariwi. Aŋgoân yâkâlen tetewaŋgiop. ");
INSERT INTO spl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tetewaŋgimu yanâmâ yâkŋe ari Yesuhât hoŋ bawalipŋaŋe menduhuakmâ yâkât we bâle nâŋgâm tatbi ya yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Yesuŋe mumuŋambâ yahatmâ tetenihiap,” sâm ekyongomu nâŋgâŋetâ porap olop. ");
INSERT INTO spl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Otmu yakât kakŋan Yesuŋe hoŋ bawayâhâtŋe yâhâp mâtâwân teteyitgiop. Teteyitgimu ekmutâ kun kundenŋaŋe âlâ olop. ");
INSERT INTO spl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lok yaŋe ekmâ âwurem sururuk sâm ari bukulipyetŋe yakât ekyongomutâ nâŋgâŋetâ yawuâk porap olop. ");
INSERT INTO spl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Otmu sâp âlâenâmâ Yesu hoŋ bawalipŋe kâiân konok hârohâk menduhuakmâ sot nem tatbin. Nem tatmunŋe Yesuŋe teteningiop. Otmu mumuŋambâ yahatmu ekmâ taka bukulipnenŋaŋe eknongoŋetâ nâŋgâmunŋe porap olop yakât Yesuŋe den sâningiop. ");
INSERT INTO spl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Otmu yuwu sâm eknongop. “Den kâsikum yiŋgim gan yu mem hânŋan kulemŋan ari lohimbi kâsikum yiŋginomai. ");
INSERT INTO spl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kâsikum yiŋgiŋetâ nâŋgâŋetâ bonŋe otmu biwiyeŋaŋe nâhâlen kepeiŋetâ toen katyeknomai. Lohimbi yamâ sâp pato tetemu âwurem ge meyekmune orowâk tatmâ yâhâmbisâin. Yawu gârâmâ lohimbi nombotŋaŋeâmâ nâhât den pat ya nâŋgâŋetâ ki bonŋe otmu biwiyeŋe alitmâ mannomai yamâ sâp patoen Anitâŋe matŋe umatŋe yiŋgimu menomai. ");
INSERT INTO spl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lohimbi nâhâlen biwiyeŋaŋe kepeim mannomaiŋeâmâ nâhât wâtnan kinmâ kulem topŋe topŋe yuwu menomai. Nâhât wâtnan kinmâ weke bâleŋe watyekŋetâ gahaeakmâ arinomai. Otmu nimbilamyeŋe purik sâmu den aŋgo sânomai. ");
INSERT INTO spl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Otmu sâtŋe metŋe topŋe topŋe otmu hambe gumbamŋe ki hilipyongoŋetâ munomai. Otmu lohimbi kundat umatŋe teteyiŋgiwuap ya gurâ tânyongoŋetâ âlepŋe otnomai.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yawu sâm eknongomu pesuk sâmu Anitâhâlen âwurem yâhâop. Yâhâmu Anitâ âwâŋe orop dop konohâk tawot. ");
INSERT INTO spl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Otmu yakât kakŋan kutdânenŋaŋe mâmâŋe otningimu kapi tipi tapi tatmâ arap ya hawamgum yâkât den pat âlepŋe lohimbi ekyongom manbin. Yawu otmâ kulem topŋe topŋe memunŋe ekmâ den pat ya nâŋgâŋetâ bonŋe olop. ");
INSERT INTO spl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yesuŋe hohetnenŋan manmâ kulem topŋe topŋe memu lohimbi yâk orop manmâ ya ekbiŋe den pat âlepŋe ya kâsikum ningiwi. ");
INSERT INTO spl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Den pat ya lok seseŋgâlâkŋe kulemguwi. ");
INSERT INTO spl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Otmu nâŋe gurâ den pat ya topŋambâek nâŋgâm heŋgeŋgum kulemgum katgihian. Yakât otmâ pepa yu sâlikumâmâ aŋgoân Yesuhât den pat kâsikum gihiwi ya nâŋgâm heŋgeŋguwuat. Den pat ya yuwu tap. ");
INSERT INTO spl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Emelâk lok kutdâ âlâ, kutŋe Herot sâm, yâkŋe Yuraia ambolipŋe yeŋgât kunyeŋe otmâ galemyongom manop. Sâp yan Anitâhât hotom uminiwi ya yeŋgâlen gâtŋe lok âlâ, kutŋe Sakaria sâm. Yâhâmâ Awiahât senâmbâ gâtŋe. Yâkŋe imbi âlâ, kutŋe Elisapet sâm, ya miop. Yâhâmâ Aron yâkât senâmbâ gâtŋe. ");
INSERT INTO spl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","7","Otmu lohimbi yuŋe inâk kâsi manmâ gam sombo olowot. Yawu manmâ tem lâuwaŋgim gamutâ Anitâŋe yelekmu ârândâŋ olop. ");
INSERT INTO spl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yâhâ Anitâhât hotom uminiwiŋe amboŋan amboŋan hotom um gaminiwi. ");
INSERT INTO spl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Otmu hotom u uhât sâp ya tâlâhumu Sakaria mem katŋetâ opon kâmbukŋahât biwiŋe âlâen yâhâ hotom uop. ");
INSERT INTO spl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hotom uop sâp yan lohimbi nombotŋaŋe opon kâmbukŋe yakât dâmân kâlehen yâhâ kinmâ Anitâ ulitguwi. ");
INSERT INTO spl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ulitgum kinŋetâ Anitâhât aŋelo âlâ, kutŋe Gawirie sâm, hotom uminiwi yakât alata bonângen tetem kinop. ");
INSERT INTO spl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tetem kinmu Sakariaŋe ekmâ pârâk pilâop. ");
INSERT INTO spl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yawu otmu aŋelo yaŋe yuwu sâm ekuop. “Sakaria, ki kiŋgitgahât ot. Imbihaŋe naom miâk nâŋgâm Anitâ ulitgum gamat. Yakât otmâ Anitâŋe nâŋgâhihimu imbihaŋe naom membuap. Naom yakât kutŋe Yoane sâm kunbuat. ");
INSERT INTO spl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tetewuap yan lohimbi kiŋgitŋe orowâkŋe yet orop heroŋe nâŋgâwaŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nanyetŋe yaŋe tem lâuwaŋgim manmu Anitâŋe nâŋgâwaŋgimu ârândâŋ otbuap. Târârâhâk manmâ to kârikŋe ki nembuap. ");
INSERT INTO spl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yawu manmu Anitâhât Wâtgât mâmâŋahât Heakŋe mâmâŋe otbaŋgimu Isirae lohimbi kuwikyekmu Kutdâ Anitâhâlen biwiyeŋaŋe kepeim mannomai. ");
INSERT INTO spl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Emelâk embâŋân Anitâhât poropete âlâ, kutŋe Elia sâm, yaŋe yâkât wâtŋan kinmâ yu ya otminiop ya Anitâŋe ekmu ârândâŋ otminiop. Yakât dopŋeâk nanyetŋaŋe manmâ Kutdâhât mâtâp mewaŋgiwuap. Yâhâ âwâlipyeŋaŋe nan baralipyeŋe kuk otyiŋgimai ya biwiyeŋe mem huruŋ tuhuyiŋgimu kaok oraŋginomai. Otmu lohimbi kunyeŋe kârikŋe otmâ Anitâhât den kumai ya ekyongomu orotmemeyeŋe bâleŋe pilâm tem lâuwaŋgim mannomai. Nanyetŋaŋe yawu otmâ Kutdâhât mâtâp mewaŋgiwuap. Yawu.” ");
INSERT INTO spl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yawu sâmu, Sakariaŋe yuwu sâm âikuop. “Net emelâk sombo oait. Yakât otmâ gâhât den ya nâŋgâm biwi yâhâp oan. Girawu otmâ yakât nâŋgâmune bulâŋe otbuap?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sâmu sâop. “Ahonakmune nâŋgâ. Nâ Gawirie, Anitâhât hoŋ bawaŋgiman. Yâkŋe hâŋgânnohomu ge den yu ekgohoan. ");
INSERT INTO spl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yawu gârâmâ den ekgohomune nâŋgâm biwi yâhâp oat yakât matŋe den biaek manbuat. Yâhâ den ekgohoan yukât bulâŋe tetewuawânâk lauhe hâreakmu den otbuat.” Yawu sâm yanâk biatmu, lok sombo ya ikŋiâk kinop. ");
INSERT INTO spl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lok sombo ya opon kâmbukŋan yâhâ sâp kâlep talop. Yakât otmâ lohimbi yaehen kinbiŋe “Girawu otmâ kâihumboŋ ot tap?” sâm mambotbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yawu otŋetâ yâk yeŋgâlen ge den ekyongowe sâm otmu eŋgatŋe maŋguakmu kopa olop. Kopa otmâ kinmu ekmâ yuwu sâwi. “Opon kâmbukŋan yâhâmu Anitâŋe biwiŋe mem purik pilâwaŋgimu kulem âlâ tetemu eksap mon?” Yawu sâŋetâ den sâwe sâm bâtŋaŋak kai toka olop. ");
INSERT INTO spl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Otmu nep sâpŋe pesuk sâmu kapiân âwurem gem ariop. ");
INSERT INTO spl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Otmu yakât kakŋan imbiŋe ya tepŋe olop. Tepŋe otmâ yuwu sâop. “Anitâ Kutdâŋe nâŋgânihimu tepne oan yakât otmâ ki aŋulakbom.” Yawu sâm emetŋanâk tatmu emetsenŋe mome pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Emetsenŋe mome pesuk sâmu yan, Anitâŋe aŋelo, kutŋe Gawirie, ya yâhâpŋe hâŋgângumu giop. Hâŋgângumu ge Nasaret kapi Galilaia hânân tap yan imbi sihan âlâ, kutŋe Maria sâm, ya tetewaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yâhâ imbi sihan ya Dawitihât senâmbâ gâtŋe yakât otmâ lok âlâ, kutŋe Yosep sâm, yâkât pat kuwaŋgiŋetâ manop. ");
INSERT INTO spl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aŋelo yaŋe tetewaŋgim yuwu sâop. “Anitâŋe nâŋgâhihim mâmâŋe otgihiap yakât otmâ biwihaŋe heroŋe otbuat.” ");
INSERT INTO spl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yawu sâm ekumu nâŋgâm kiwilim biwiŋaŋe yuwu nâŋgâop. “Den eknohoap yakât topŋe girawu?” ");
INSERT INTO spl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Biwiŋaŋe yawu nâŋgâmu yuwu sâm ekuop. “Anitâŋe nâŋgâhihiap. Yakât otmâ biwihe sânduk sâek. ");
INSERT INTO spl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gâŋe tepge otmâ naom membuat yâkât kutŋe Yesu sâm kunbuat. ");
INSERT INTO spl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Lohimbiŋe yâkât nâŋgâwaŋgiŋetâ yahatmu “Anitâ pato nandoroŋe yâkât nanŋe” sânomai. Otmu emelâk embâŋân Kutdânenŋe Anitâŋe tâmbânenŋe Dawiti lok kutdâ sâm katmu bukulipŋe galemyongom manop. Yakât dopŋeâk Anitâŋe nange âi sâm waŋmu ");
INSERT INTO spl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yakop sen nengât kunnenŋe kinmâ tihitnenŋe otbisâp.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Sâmu sâop. “Nâ lok orop ki mansan. Yakât otmâ den yat yakât bulâŋe girawu tetewuap?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sâmu sâop. “Anitâhât Wâtgât mâmâŋahât Heakŋe biwihan gemu Anitâŋe mâmâŋe otgihimu tepge otmâ naom membuat. Yakât otmâ naom ya koko salehâk manbuap. Yawuhât lohimbiŋe ekmâ kutŋe “Anitâhât nanŋe” sâm kunomai. ");
INSERT INTO spl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Den âlâ torokatmâ sâmune nâŋgâ. Anitâŋe yu ya otbe sâm yakât ki hâum pâpgumap. Yawu otmâ bukuhe Elisapet kâsi manmâ gamap ya nâŋgâwaŋgimu tepŋe otmâ manmâ gamu emetsenŋe nombolân konok pesuk yap. Imbi kâsi sâmai ya yawu tetewaŋgiap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Sâmu sâop. “Nâ Kutdâhât hoŋ bawa imbi. Yakât otmâ den yat ya bulâŋe teteâkgât naŋgan.” Yawu sâmu aŋeloŋe pilâm ariop. ");
INSERT INTO spl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sâp kâlep ki otmuâk Mariaŋe Sakaria imbiŋeit yetgâlen ariwe sâm kapiŋe pilâm kapi âlâ Yuraia hân yakât halângen tap yan ariop. ");
INSERT INTO spl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yan arim yâk yetgât emelan yâhâm Elisapet ekmâ heroŋe otbaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Heroŋe otbaŋgimu yanâk tepŋe kâlehen naom talop yaŋe kâlâwahomu nâŋgâop. Yawu otmu Anitâhât Wâtgât mâmâŋahât Heakŋe Elisapet mâmâŋe otbaŋgimu bukuŋe yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","43","“O bukune, Anitâŋe gâ nâŋgâhihim mâmâŋe otgihiap. Yakât otmâ imbi kerekŋe gâhât nâŋgâhihiŋetâ yahatbuap. Otmu naom membuat ya Anitâŋe mâmâŋe otbaŋgimu tihitnenŋe otmu Kutdânenŋe sâm tem lâuwaŋgim mannom. Nâmâ imbi inŋe mansan. Yamâ gâŋe nâhâlen takarâ nâŋgâmune âlâ kândâkdâ oap. ");
INSERT INTO spl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Taka nohondâ yanâk naom tepnan tap yuŋe kâlâwahomu naŋgan. ");
INSERT INTO spl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Otmu den âlâ torokatmâ sâmune nâŋgâ. Anitâŋe aŋelo âlâ hâŋgângumu ge den ekgohop yakât bulâŋe tetewuap yakât nâŋgâm biwi yâhâp ki oat. Yawu otmâ biwi heroŋe naŋgat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yawu sâmu Mariaŋe yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","“Nâ Anitâhât hoŋ bawa mansan. Yawu gârâmâ Kutdâne Anitâ tihitnenŋe otmapŋe nâŋgânihim mâmâŋe otnihiap. Yakât otmâ lohimbi komotŋe komotŋe tetem mannomaiŋe nâhât nâŋgâŋetâ yahatmu “Anitâŋe nâŋgâwaŋgiap,” sânomai. ");
INSERT INTO spl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anitâ Manman koko salek Amboŋaŋe mâmâŋe otnihim kulem miap yukât nâŋgâmune ewe membe otmu mepaem mansan. ");
INSERT INTO spl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Otmu lohimbi âlâ me âlâŋe Anitâhât nâŋgâm tem lâuwaŋgimai ya wawaeyekmap. ");
INSERT INTO spl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wâtŋe pato nandoroŋe tatbaŋgiap. Yakât otmâ yu yakât ki pâpgumap. ");
INSERT INTO spl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Lohimbi yeŋe eŋgatyeŋeâk watmâ manmâ hâkyeŋe mepaeakmai ya mem ge katyekmap. Otmu lok kutdâlipyeŋaŋe lohimbi mem bâleyekmai ya mem ge katyekmap. Mem ge katyekmâ lok geheŋe ya mem yâhâ katyekmap. ");
INSERT INTO spl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Otmu lok iri sikumyeŋe orowâk ya misihem manmai ya mem ge katyekmu umburuk otmâ manmai. Yâhâ lohimbi po manmai ya tihityeŋe otmâ sot kâle yiŋgimap. ");
INSERT INTO spl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Emelâk embâŋân tâmbâlipnenŋe yeŋgât pat kuyiŋgiop ya mem mete tuhum Isirae lohimbi nengât tihitnenŋe otmâ gamap. ");
INSERT INTO spl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yawu otmâ tâmbânenŋe Awaraham yâkât pat kuwaŋgiop. Pat yakât bulâŋe nen yâkât sen nengâlen teteap. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariaŋe yawu sâm Elisapet ekuop. Otmu yâk orop manmu emetsenŋe kalimbu pesuk sâmu kapiŋehen âwurem ariop. ");
INSERT INTO spl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","58","Maria âwurem ariop yakât kakŋan Elisapetŋe nanŋe miop. Yâhâ Kutdâŋe nâŋgâwaŋgimu nanŋe miop yakât nâŋgâm hep torehenlipŋe otmu kapi ambolipŋaŋe heroŋe nâŋgâwaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Otmu hilâm nombolân kalimbu pesuk sâmu yan hep torehenlipŋaŋe menduhuakmâ naom yakât hâkŋahât undip tuhuwaŋgine sâm, âwâŋe Sakaria, yâkât kutŋe membuap sâwi. ");
INSERT INTO spl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yawu sâŋetâ mâmâŋaŋe kuyiŋgim yuwu sâop. “Bia, kutŋe Yoane sâm kunom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yawu sâmu yuwu sâm ekuwi. “Âlepŋe yat yamâ bukulipge me hep torehenlipge yeŋgât kut âlâ yawuya ki tap.” ");
INSERT INTO spl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yawu sâm kuaŋgiwi. Otmu “Âwâŋaŋe girawu naŋgap?” sâm bâtyeŋaŋe kai toka otmâ tape kiripi mem waŋbi. ");
INSERT INTO spl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tape kiripi mem waŋetâ yuwu kulemguop. “Kutŋe Yoane sâm kunom,” yawu kulemguop. Kulemgumu ekmâ nâŋgâŋetâ âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yawu otmâ Sakariahât lauŋe hâreakmu Anitâ mepaeop. ");
INSERT INTO spl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","66","Yawu otmâ Anitâŋe naom ya mâmâŋe otbaŋgim ikŋe den biwiŋan katmu lohimbi ekyongowuap yakât sâm mepaeop. Kulem yawu teteop yakât nâŋgâŋetâ sâtŋe otmu kapi ambolipŋaŋe yakât den pat sâm haok tuhuŋetâ lohimbi Yuraia halângen manmâ ariwiŋe nâŋgâm yuwu sâm alahuwi. “Naom yu lok otbuawân girawu otbuap?” Yawu sâm nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakariaŋe Anitâ mepaeop yan Wâtgât mâmâŋahât Heakŋe biwiŋe mem heweweŋ tuhumu yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","69","“Ambonenŋe Anitâŋe nen lohimbilipŋe manman bâleŋambâ menenekmâ tihitnenŋe otbe sâm tâmbânenŋe Dawiti yâkât senâmbâ gâtŋe âlâ kânâŋgâwuap. Yawu otmâ mâmâŋe otbaŋgimu yâkŋe manman âlepŋan katnenekbuap. Yakât otmâ mepaene. ");
INSERT INTO spl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Yâhâ kasalipnenŋaŋe nongom itit kiom tuhuningimaihât sârerenenekmâ tihitnenŋe otmu mannom. ");
INSERT INTO spl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yakât nâŋgâm emelâk embâŋân tâmbâlipnenŋe yeŋgât pat kuyiŋgiop yakât ki nelâmguop. Ya mem mete tuhum poropetelipŋe ekyongomu kulemguwi. ");
INSERT INTO spl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Yâhâ yâkŋe kasalipnenŋe yeŋgât bâtyeŋambâ menenekmu biwinenŋe sânduk sâm tem lâuwaŋgim manmâ yâhânomgât pat Awarahamgât kuwaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yakât otmâ nen Isirae lohimbiŋe tem lâuwaŋgim ki kiŋgitnenŋahât otmâ manmâ yâhânom. Yawu otmâ uwawapŋe bia manmunŋe nenekmu ârândâŋ otbuap.” Yawu sâm mepaeop. ");
INSERT INTO spl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Otmu den âlâ torokatmâ nanŋahât yuwu sâm ekyongop. “Nanne yuŋe Kutdânenŋe kulet sâwaŋgim ari mâtâp mewaŋgiwuap. Otmu nenŋe orotmemenenŋe bâleŋe bet pilâm Anitâhâlen biwinenŋaŋe kepeimunŋe tosanenŋe pilâningiwuap yakât den eknongomu nâŋgânom. Yakât otmâ lohimbi biwihâlâkŋe yâkât nâŋgâŋetâ yahatmu “Anitâ yahat yahatŋe yâkât poropete” sânomai. ");
INSERT INTO spl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yakât den âlâen hâum sâmune nâŋgâŋet. Nen omoŋ bâleŋan dop yawu manmain. Yâhâ emet haŋ sâwe sâm otmap yanâmâ pitu kâmŋe papato yaŋe tetemu tatmâ yaŋak emet haŋ sâmap. Emet haŋ sâmu emetsenŋe ga takamap. ");
INSERT INTO spl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yakât dopŋeâk Anitâŋe kaok nâŋgâningim ikŋe hoŋ bawa himbimâmbâ hâŋgângumu ge ikŋe laŋinŋe biwinenŋan pilâmu haŋ sâningimu yâkât mâtâp watmâ yâhâmunŋe manman kârikŋan katnenekbuap. Yawu.” Sakariaŋe yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Otmu naom ya kâiŋe hâwimu lok otmâ nâŋgân nâŋgânŋe keterakbaŋgiop. Yawu otmâ âwâŋe mâmâŋe pilâyelekmâ ari lok ki manmaiângen manop. Yan ari manmâ Isirae lohimbi hohetyeŋan âwurem taka âi tuhuwuap yakât mambotmâ manop. ");
INSERT INTO spl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Yâhâ Elisapetŋe nanŋe Yoane miop sâp yan kiap pato âlâ, kutŋe Kurinio sâm, yâhâmâ Siria lohimbi yeŋgât kunyeŋe pato manop. Otmu Roma lok yeŋgât lok kutdâ âlâ manop, kutŋe Ahusto sâm. Yâkŋe puwâk lohimbi amon mansai ya yeŋgât dop nâŋgâwe sâm olop. Yakât otmâ Roma yeŋgât amutgen lohimbi hân âlâen âlâen tatmâ ariwi yeŋgât kutyeŋe kulemgunomaihât den katyiŋgim ariop. ");
INSERT INTO spl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yakât otmâ lok kerekŋe kutyeŋe katne sâm kapiyeŋe tâmbâŋan ariwi. ");
INSERT INTO spl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Otmu emelâk embâŋân Isirae yeŋgât lok kutdâ âlâ manop, kutŋe Dawiti sâm, yâkŋe Yuraia hânân kapi âlâ, kutŋe Betelem, yan teteop. Yawu gârâmâ Ahustoŋe den katyiŋgiop yan Dawitihât senâmbâ gâtŋe, lok âlâ, kutŋe Yosep sâm, yâku yawuâk kapiŋe tâmbâŋan ariop yamâ yuwu. Yosepgât imbi sâm pat kuwaŋgiwi, yamâ kutŋe Maria sâm, yâhâmâ tepdâek manop. Yawu gârâmâ orowâk kapiyetŋe, kutŋe Nasaret, Galilaia hânân tap, ya pilâm Betelem hân tâmbâŋan ariowot. ");
INSERT INTO spl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Arimutâ omoŋ otmu kapi yan lombaŋe ari emet iminiwi ya kândikum ariwiŋe gewâk meŋetâ pik sâop. Yakât otmâ emetgât ekmutâ biatmu bulimakaohât emetŋan yâhâ talowot. ");
INSERT INTO spl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tatmutâ yanâk naom kâlâpgumu nanŋe miop. Mem bulimakaoŋe sot kondoân neminiwi yan sâŋgumân katipgum katmu iop. ");
INSERT INTO spl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Otmu kapi ya gotŋan lok nombotŋaŋe bau âlâ, kutŋe lama sâm, ya galemyongom tatbi. ");
INSERT INTO spl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tatŋetâ yan Anitâhât aŋelo âlâŋe yâk yeŋgâlen tetemu, yâkât laŋinŋaŋe siliŋ siliŋ sâmu ekmâ umutyeŋe ariop. ");
INSERT INTO spl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Umutyeŋe arimu yuwu sâm ekyongop. “Kiŋgityeŋahât ki otŋet. Nâŋe den âiloŋgo ekyongowe sâm teteyiŋgian. Yakât yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Anitâŋe ikŋe hoŋ bawa hâŋgângumu ge sârereyekmâ tihityeŋe otbuap sâmai ya yiwereŋe Dawitihât kapiân teteap. Yâkât kutŋe Kiristo. Yâkŋe kutdâyeŋe otmâ tihityeŋe otbuap yakât nâŋgâm lohimbi kiŋgitŋe orowâkŋe heroŋe otnomai. ");
INSERT INTO spl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Otmu mâmâŋaŋe ŋaŋa ya sâŋgumân katipgum bulimakaoŋe sot kondoân nemai yan katmu iap ya ari mem tetenomai. Ya mem tetenomai yan den ekyongoan yukât nâŋgâŋetâ bulâŋe otbuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yawu sâm ekyongomu yanâk aŋelo kiŋgitŋe orowâkŋe tetem bukuyeŋe penewaŋgim yuwu sâm Anitâ kiki mewaŋgim mepaewi. ");
INSERT INTO spl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anitâŋe lohimbi yekmu ârândâŋ otmap yâhâmâ biwi sânduhân katyekmu buku oraŋginomai. Yakât otmâ yeŋe heroŋe otmâ Anitâ Himbim Amboŋe mepaeŋet.” ");
INSERT INTO spl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yawu sâm kiki mewaŋgim mepaem himbimân âwurem yâhâŋetâ lama galemguwiŋe yuwu sâwi. “Kutdâŋe aŋelo hâŋgângumu ge den eknongoap. Yakât otmâ kapiân yâhâm ekne.” ");
INSERT INTO spl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yawu sâm lama ya katyekmâ kapiân sururuk sâm yâhâ Maria, Yosep, nanyetŋe mem teteyekbi. Mem tetem yan Mariaŋe nanŋe ya sâŋgumân katipgum katmu iop ya ekbi. ");
INSERT INTO spl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ekmâ yan aŋeloŋe teteyiŋgim ŋaŋa yakât den pat ekyongomu nâŋgâwi ya ekyotgowi. ");
INSERT INTO spl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ekyotgoŋetâ nâŋgâmutâ âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yawu gârâmâ Mariaŋeâmâ den ya nâŋgâm biwiŋan katmâ manop. ");
INSERT INTO spl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yâhâ Anitâhât aŋeloŋe lama galemŋe den ekyongop ya ekŋetâ bulâŋe otmu yâkŋe âwurem ari Anitâ mepaem heroŋe otbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yesu teteop yakât kakŋan hilâm nombolân kalimbu pesuk sâmu hâkŋahât undip tuhuwaŋgim kutŋe Yesu sâm kunbi. Yâhâ Mariaŋe tepŋe ki olop sâp yan aŋeloŋe tetewaŋgim kutŋe Yesu sâm kunbuat sâop ya watmâ kunbi. ");
INSERT INTO spl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Isirae imbiŋe naom meŋetâ hepyeŋe saŋ sâwuap yan salek otmâ mannomaihât Anitâŋe Mose den âlâ ekumu kulemgum katyiŋgiop yamâ yuwu tap. “Âwâŋe mâmâŋaŋe kembâ me upu kutulup yâhâp mem hotom unihiromawot.” Yawu tap. Den ya lâum Maria yet Yosepŋe Yesu lâum Yerusalem kapiân yâhâowot. Yâhâ emelâk Anitâŋe Mose den âlâ ekumu kulemguop yamâ yuwu. “Nanlipyeŋe kunŋe tetenomai yamâ Kutdâhât hoŋ bawaŋginomaihât pat kuwaŋginomai.” Den yâhâp ya lâum Yesu lâum opon kâmbukŋan yâhâowot. ");
INSERT INTO spl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sâp yan Yerusalem kapiân lok âlâ manop, kutŋe Simion. Yâhâmâ Anitâhât Wâtgât mâmâŋahât Heakŋe mâmâŋe otbaŋgimu Anitâhât tem lâuwaŋgim uwawapŋe bia manmâ gaop. Yawu manmâ Anitâŋe ikŋe hoŋ bawa hâŋgângumu ge Isirae lohimbi tihityeŋe otmâ kasalipyeŋe watyekmu arinomai yakât mambotmâ manop. ");
INSERT INTO spl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yâhâ emelâk Wâtgât mâmâŋahât Heakŋe biwiŋan kioŋmu Anitâhât hoŋ bawaŋe tetem Isirae lohimbi yeŋgât tihityeŋe otbuap ya ekbuap yakât nâŋgâm biwi yâhâp ki olop. ");
INSERT INTO spl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aiop, Yosep yet Mariaŋe Yesu lâum opon kâmbukŋan yâhâowot sâp yan Wâtgât mâmâŋahât Heakŋe Simion mem heweweŋ tuhumu yawuâk opon kâmbukŋan yâhâop. Yâhâ kinmu Maria yet Yosepŋe Anitâhât den lâum Yesu lâum yâhâowot. ");
INSERT INTO spl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yâhâmutâ ekyotgomu nanyetŋe waŋmutâ lâum yuwu sâm Anitâ mepaeop. ");
INSERT INTO spl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Kutdâ pato, gâŋe nâŋgânihirâ yiwereŋe Isirae nengât tihitnenŋe otbuap yâk eksangât biwine huruŋ yap. Yakât otmâ inâk ki mumbom. ");
INSERT INTO spl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Yâhâ naom yu pato otmu lohimbi âlâ me âlâŋe yâkâlen biwinenŋaŋe kepeim mannom yan gâŋe nengât tihitnenŋe otmâ manman âlepŋan mem katnenekdâ manmâ yâhânom. ");
INSERT INTO spl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yâhâ pâku lohimbiŋe manman âlepŋahât mâtâp ekmâ watnomaihât gâhât laŋingaŋe biwiyeŋan pilâmu haŋ sâyiŋgiwuap. Yawu otmâ yâkâlen biwiyeŋaŋe kepeim Isirae nengât heroŋe nâŋgâninginomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesu lâum yawu sâm Anitâ mepaemu, âwâŋe mâmâŋaŋe nâŋgâmutâ âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yawu otmâ Anitâŋe yâk yetgât nâŋgâyitgiâkgât Simionŋe ulitguop. Yawu otmâ mâmâŋe yuwu sâm ekuop. “Sâmune nâŋgâ. Nen Isirae lohimbiŋe nangahât nâŋgâmâmâ hioŋaknomgât Anitâŋe sâm kalop. Nombotŋe yâkâlen biwinenŋaŋe kepeim manmâ manman kârikŋahât pat yakât bulâŋe menom. Yâhâ nombotŋeâmâ yâk betbaŋgim hiliwahonomaihât pat mannomai. ");
INSERT INTO spl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yawu manŋetâ Anitâŋe ikŋe kai toka sâm senyeŋan katmu kinbuap. Katmâ kinmu sâm ge katnomai ya yeŋgât topyeŋe mem tetewuap. Yawu gârâmâ kuŋetâ mumbuap yan we bâle pato nâŋgâwuat. Yawu.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Otmu Simionŋe den yawu sâm ekuop sâp yanâk imbi sombo âlâ Anitâhât den sâm tetem lohimbi ekyongom manopŋe mem teteyehop. Imbi sombo yakât topŋe yuwu. Imbi yakât kutŋe Ana sâm, yâhâmâ Panue baratŋe, Asehât senâmbâ gâtŋe. Yâkŋe lokŋeit miakmâ manmutâ yambu 7 pesuk sâmu lokŋe muop. ");
INSERT INTO spl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Lokŋe mumu ikŋe kambut manmâ gamu yambu 84 pesuk sâop. Yâhâ imbi sombo yaŋe omoŋe hilâmŋe opon kâmbukŋan tatmâ Anitâ mepaeminiop. Otmu sâp sâsâŋan sot barak manmâ ulitguminiop. ");
INSERT INTO spl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Otmu yâkŋe naom ya mem tetem yâku yawuâk Anitâ mepaeop. Otmu Anitâŋe ikŋe hoŋ bawa hâŋgângumu ge Isirae tihityeŋe otmâ kasalipyeŋe watyekbuapgât nâŋgâm biwiyeŋaŋe mem manbi ya Yesuhât ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yâhâ Maria yet Yosepŋe Anitâhât den tiŋâk lâum hotom uwaŋgimutâ pesuk sâmu opon kâmbukŋambâ ge Nasaret kapi Galilaia hânân tawân âwurem ariowot. ");
INSERT INTO spl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yan ari manmutâ naom ya Anitâŋe mâmâŋe otbaŋgimu kâiŋe hâwimu nâŋgân nâŋgânŋe keterahop. ");
INSERT INTO spl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yura yeŋgât Tihit tihit Hombaŋ ya tâlâhumu Yosep yet Mariaŋe nanyetŋe orowâk Yerusalem kapiân yâhâwi. ");
INSERT INTO spl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sâp yan Yesuâmâ yambuŋe kâiân yâhâp otbaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Hombaŋ ya ekŋetâ pesuk sâmu lohimbi itoŋ galaŋ kapiyeŋehen arim kinbi. Sâp yan Maria yet Yosepŋe nanyetŋe ki ekmâ lohimbi nombotŋe orop arap nâŋgâowot. Yawu nâŋgâm yetŋiâk Yerusalem kapi pilâm âwurem ariowot. Mâtâwân arim tatŋetâ ŋiŋ sâop. Emet ŋiŋ sâmu bukulipyetŋe yeŋgâlen ba pâinmutâ bialop. ");
INSERT INTO spl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Emet haŋ sâmu yahatmâ Yerusalem kapiân âwurem ari iowot. ");
INSERT INTO spl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Imutâ haŋ sâmu pâinmâ opon kâmbukŋan yâhâowot. Yâhâ lok Mosehât girem den lohimbi kâsikum yiŋgiminiwi ya yeŋgât denyeŋe nâŋgâm Yesuŋe topŋahât âiyongom talop yan mem teteowot. ");
INSERT INTO spl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Otmu Yesuŋe yâk orop den huhuwi ya lohimbi yan tatbiŋe nâŋgâŋetâ âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yâhâ âwâŋe mâmâŋaŋe mem tetem pârâk pilâowot. Yawu otmâ mâmâŋaŋe yuwu sâm ekuop. “Net âwâheit pâingekmutŋe biatmu gorâ kakŋan takait. Gâŋe wongât otmâ mâŋgâeneleksat?” ");
INSERT INTO spl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sâmu sâop. “Nâŋe awoŋnahât nep tuhuan ya emelâk nâŋgâmbâwât. Yamâ wongât pâinnekmâ takawot?” ");
INSERT INTO spl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yawu sâmu nâŋgâmutâ ki keterakyitgiop. ");
INSERT INTO spl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yamâ mâmâŋaŋeâmâ nanŋahât den ya biwiŋan katmâ nâŋgâm gaop. Yawu otmâ âwâŋe mâmâŋe orop Nasaret kapiân âwurem ari manmâ tem lâuyitgim manmâ gam kundenŋe sânduk sâop. ");
INSERT INTO spl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Otmu Anitâŋe mâmâŋe otbaŋgimu nâŋgân nâŋgânŋe keterakmâ heŋgeŋguop. Yawu gamu lohimbŋe ekŋetâ âiloŋgo olop. ");
INSERT INTO spl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roma yeŋgât lok kutdâ âlâ, kutŋe Tiwerio Sisa sâm, yâk kânâŋgâŋetâ lohimbi kerek nengât kunnenŋe pato otmâ galemyongomu yambu 15 pesuk sâop. Otmu sâp yan kiap âlâ, kutŋe Pontio Pilato sâm, yâhâmâ Yuraia ambolipŋe galemyongom manop. Yâhâ lok kutdâ âlâ, kutŋe Herot, yâhâmâ Galilaia ambolipŋe galemyongom manop. Yâhâ imiŋe Pilip, yâhâmâ Ituria otmu Tarakoniti ambolipŋe galemyongom manop. Yâhâ lok kutdâ âlâ, kutŋe Lisania sâm, yâkŋeâmâ Awilene kapi ambolipŋe galemyongom manop. ");
INSERT INTO spl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yâhâ Anitâhât opon kâmbukŋan hotom uminiwi ya yeŋgât kunyeŋe lok yâhâp manowot, kutyetŋe Anasi yet Kaipa. Aiop, sâp yan Sakaria nanŋe, kutŋe Yoane sâm, yâkŋe lok ki manmaiângen ari manmâ âi topŋe kalop. ");
INSERT INTO spl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yan manmu Anitâŋe ikŋe den biwiŋan katmu Yoran to nombot nombot bam gam lohimbi yuwu sâm ekyongop. “Orotmemeyeŋe bâleŋe ya kerek betguŋetâmâ toen katyekbom. Toen katyekmune Anitâŋe tosayeŋe pilâyiŋgiwuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yâhâ emelâk emet inânŋan poropete âlâ, kutŋe Yesaia sâm, Anitâŋe yuwu sâm ekumu kulemguop tap. “Lok ki manmaiângen, lok âlâ yan ari manbuap. Lohimbi yâkâlen takanomai ya yuwu sâm ekyongowuap. “Lok kutdâhât mâtâp ya mem pitiŋet. Otmu mâtâp mewaŋgiŋet. ");
INSERT INTO spl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Otmu uk sâm huruŋ sâm, pumŋe lauŋe ya kum kilikmâ mem ârândâŋ merândâŋ tuhuŋetâ ya talâk. Otmu mâtâp goŋgoŋ maŋgoŋ ya heŋgeŋgunomai. Otmu mâtâp gâwikŋe ya mem perereŋ tuhunomai. ");
INSERT INTO spl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yawu otmâ Anitâŋe lohimbi kerek yeŋgât tihityeŋe otbe sâm oap yakât topŋe nâŋgânomai.” Yawu sâm ekyongowuap.” Yesaiaŋe den yawu kulemguop tap yakât bulâŋe yamâ Yoanehâlen teteop. ");
INSERT INTO spl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","8","Yoaneŋe den yawu ekyongop sâp yan lohimbi kiŋgitŋe orowâkŋe yâkŋe toen mem katnenehâk sâm yâkâlen ariwi. Ariŋetâ yekmâ yuwu sâm ekyongop. “Yenâmâ lok perâkŋe. Otŋetâ bâlem gamap yakât matŋe Anitâŋe meŋet sâmu yakât yeŋeâmâ kiŋgityeŋahât otmâ bâleŋe ya pilai mâne âlepŋe otbâp. Yawu gârâmâ den yan yu nâŋgâŋetâ ki ârândâŋ oap. Yawu otmâmâ yuwu mon nâŋgânomai, “Nenâmâ Awarahamgât komot bulâŋe mansain. Yakât otmâ Anitâŋe nengât ki nâŋgâm bâleningimap.” Yawu ki nâŋgânomai. Yakât yuwu sâmune nâŋgâŋet. Anitâŋe sâmu kât yuŋe Awarahamgât komot tetenomaihât dop tap. Yawu gârâmâ yenâmâ ya imbiâk sâmai. Yakât matŋe hâmbâi menomai. ");
INSERT INTO spl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yakât den âlâen hâum sâmune nâŋgâŋet. Emelâk unam sâtŋe katmu tap. Yâhâ nak âlâhât bonŋe ki kinbuap yamâ kârâm panmu ge mum hâlâlâŋ sâmu kâlâpŋe sewuap. Yenâmâ nak yakât dop otmâ mansai.” ");
INSERT INTO spl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yawu sâm ekyongomu yuwu sâm âikuwi. “Nenŋe wuân otmunŋe ârândâŋ otbuap?” ");
INSERT INTO spl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sâŋetâ sâop. “Lok âlâ me âlâ hâk katipŋe yâhâp tatyiŋgiwuapŋe bukulipyeŋe âlâ me âlâ umburuk mannomai ya yekmâmâ âlepŋe âlâ ya yiŋginomai. Otmu sotgât po manmai ya gurâ yawuâk nembe kalem otyiŋginomai.” ” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yawu sâm ekyongomu takesi meme lok nombotŋaŋe yawuâk toen mem katnenehâk sâm yâkâlen taka yuwu sâm âikuwi. “Lok pato, nenŋe wuân otmunŋe ârândâŋ otbuap ya eknongorâ nâŋgâne.” ");
INSERT INTO spl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sâŋetâ sâop. Kunlipyeŋaŋe “Takesihât dop yuwu meŋet” sânomai yawuâk menomai. Yeŋe andemŋe ya waŋgim âlâ torokatmâ ki menomai.” ");
INSERT INTO spl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yawu sâm ekyongomu Roma yeŋgât tembe lâu yawuâk yâkâlen taka yuwu sâm âikuwi. “Girawu naŋgat? Nenŋeâmâ wuân otmunŋe ârândâŋ otbuap?” Yawu sâwi. Sâŋetâ sâop. “Yeŋe lok ki mem âlâlâ tuhuyekmâ kombo meyiŋginomai. Otmu tewetsenŋe yiŋgiŋetgât ki hakyeŋan sânomai. Otmu âi memai yakât hâmeŋahât kunlipyeŋaŋe puluhuyeknomai yakât nâŋgâŋetâ ârândâŋ otbuap. Yawu.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yawu sâm ekyongomu nâŋgâŋetâ âlâ kândâkdâ otmu nâŋgâm yuwu sâwi. “Anitâŋe ikŋe hoŋ bawaŋe hâŋgângumu ge tihitnenŋe otbuap ya Yoane mon?” ");
INSERT INTO spl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yawu sâŋetâ nâŋgâm yuwu sâm ekyongop. “Yeŋe orotmemeyeŋe bâleŋe betbaŋgiŋetâmâ toen katyekbom. Lok âlâ irak betnehembâ âi topŋe katbuap yâhâmâ wâtŋe pato tatbaŋgiap. Yakât otmâ nâŋe yâkât itâkat ya mem kâpekmâ golewaŋgiwomgât dop ki tap. Otmu tânguwomgât dop gurâ ki tap. Nâŋeâmâ yâkât amutgen manmâ yâhâwom. Yâkŋeâmâ Wâtgât mâmâŋahât Heak hâŋgângumu ge mem ketetyekbuap. Nombotŋe manman âiloŋgoân mem katyekbuap. Yâhâ nombotŋeâmâ hâhiwin kakŋan katyekmu mannomai. ");
INSERT INTO spl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Otmu den âlâen hâum sâwe. Yeŋeâmâ sot ekmâ mem kiwilim komot ikŋiâk ikŋiâk katmai. Neneŋahât pat otmap ya konohân mem hâwuruŋetâ tatmap. Yâhâ ki neneŋahât pat otmap yamâ mem pilâmai. Yakât dopŋeâk yâkŋe taka biwinenŋahât topŋe ekmâ mem kâsipnongowuap yakât topŋe yuwu. Yâkât tem lâum manmâ yâhânom yamâ ikŋan mem torokatnenekbuap. Yâhâ nombotŋaŋe yâkât hâkâŋ otmâ betbaŋgim manmai yamâ watyekmu kâlâwân kioŋmâ hâhiwin nâŋgâmbisâi.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yâhâ Anitâŋe tihityeŋe otbe sâm oap yakât den pat âlepŋe ekyongop. Yawu otmâ orotmemeyeŋe bâleŋe betbaŋgiŋet sâm den âlâlâ ekyongom eŋgatyeŋan giop. ");
INSERT INTO spl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sâp yan lok kutdâ, kutŋe Herot sâm, yâkŋe imiŋahât betŋehen kioŋmâ kahaŋe, kutŋe Herotia sâm, ya miop. Otmu orotmeme bâleŋe topŋe topŋe otmâ gaop. Yakât otmâ Yoaneŋe ekmu bâlemu yakât girem den ekuop. ");
INSERT INTO spl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Girem den ekuop ya nâŋgâmu bâlemu imbiâk mem pâi emetŋan katmu talop. Yawu otmâ tosa âlâ miop. ");
INSERT INTO spl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yoaneŋe toen mem katnenehâk sâm lohimbi kiŋgitŋe orowâkŋe yâkâlen ariwi. Yâkâlen ariŋetâ toen mem katyehop. Sâp yan Yesu gurâ yawuâk yâkâlen ariop. ");
INSERT INTO spl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Arimu toen mem katmu Anitâ mepaeop. Yawu otmu himbim pâroŋ sâmu Anitâhât Wâtgât mâmâŋahât Heakŋe kembâ hâtgum Yesu kakŋan ge mâmâŋe otbaŋgiop. Yawu otmu himbimâmbâ Anitâŋe yuwu sâop. “Gâ nine nanne kambiamne. Nâ biwinaŋe gâhâlâk nâŋgâm kepeihekman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Topŋe katmâ Anitâŋe Atam Ewa katyelehop. Atamgât nanŋe, Set sâm, ya teteop. Setgât nanŋe, Enosi sâm, ya teteop. Enosihât nanŋe, Kenan sâm, ya teteop. Kenangât nanŋe, Mahalali sâm, ya teteop. Mahalalihât nanŋe, Yaret sâm, ya teteop. Yaretgât nanŋe, Enok sâm, ya teteop. Enokgât nanŋe, Metusela sâm, ya teteop. Metuselahât nanŋe, Lamek sâm, ya teteop. Lamekgât nanŋe, Noa sâm, ya teteop. Noahât nanŋe, Sem sâm, ya teteop. Semgât nanŋe, Arapasat sâm, ya teteop. Arapasatgât nanŋe, Kenan sâm, ya teteop. Kenangât nanŋe, Sela sâm, ya teteop. Selahât nanŋe, Ewe sâm, ya teteop. Ewehât nanŋe, Pelek sâm, ya teteop. Pelekgât nanŋe, Lahau sâm, ya teteop. Lahauhât nanŋe, Seruk sâm, ya teteop. Serukgât nanŋe, Neho sâm, ya teteop. Nehohât nanŋe, Tara sâm, ya teteop. Tarahât nanŋe, Awaraham sâm, ya teteop. Awarahamgât nanŋe, Isaka sâm, ya teteop. Isakahât nanŋe, Yakop sâm, ya teteop. Yakopgât nanŋe, Yura sâm, ya teteop. Yurahât nanŋe, Peresi sâm, ya teteop. Peresihât nanŋe, Hesoron sâm, ya teteop. Hesorongât nanŋe, Arani sâm, ya teteop. Aranihât nanŋe, Aramin sâm, ya teteop. Aramingât nanŋe, Aminarap sâm, ya teteop. Aminarapgât nanŋe, Nason sâm, ya teteop. Nasongât nanŋe, Salamon sâm, ya teteop. Salamongât nanŋe, Boasi sâm, ya teteop. Boasihât nanŋe, Owet sâm, ya teteop. Owetgât nanŋe, Yese sâm, ya teteop. Yesehât nanŋe, Dawiti sâm, ya teteop. Dawitihât nanŋe, Natan sâm, ya teteop. Natangât nanŋe, Matat sâm, ya teteop. Matatgât nanŋe, Mena sâm, ya teteop. Menahât nanŋe, Melia sâm, ya teteop. Meliahât nanŋe, Eliakim sâm, ya teteop. Eliakimgât nanŋe, Yonam sâm, ya teteop. Yonamgât nanŋe, Yosep sâm, ya teteop. Yosepgât nanŋe, Yura sâm, ya teteop. Yurahât nanŋe, Simion sâm, ya teteop. Simiongât nanŋe, Lewi sâm, ya teteop. Lewihât nanŋe, Matat sâm ya teteop. Matatgât nanŋe, Yorim sâm, ya teteop. Yorimgât nanŋe, Eliese sâm, ya teteop. Eliesehât nanŋe, Yosua sâm, ya teteop. Yosuahât nanŋe, Ere sâm, ya teteop. Erehât nanŋe, Elimatam sâm, ya teteop. Elimatamgât nanŋe, Ati sâm, ya teteop. Atihât nanŋe, Meliki sâm, ya teteop. Melikihât nanŋe, Neri sâm, ya teteop. Nerihât nanŋe, Salatie sâm, ya teteop. Salatiehât nanŋe, Seruwawe sâm, ya teteop. Seruwawehât nanŋe, Lesa sâm, ya teteop. Lesahât nanŋe, Yoanan sâm, ya teteop. Yoanangât nanŋe, Yota sâm, ya teteop. Yotahât nanŋe, Yosek sâm, ya teteop. Yosekgât nanŋe Semen sâm, ya teteop. Semengât nanŋe, Matatia sâm, ya teteop. Matatiahât nanŋe, Mata sâm, ya teteop. Matahât nanŋe, Nahai sâm, ya teteop. Nahaihât nanŋe, Esili sâm, ya teteop. Esilihât nanŋe, Nahum sâm, ya teteop. Nahumgât nanŋe, Amosi sâm, ya teteop. Amosihât nanŋe, Matatia sâm, ya teteop. Matatiahât nanŋe, Yosep sâm, ya teteop. Yosepgât nanŋe, Yanai sâm, ya teteop. Yanaihât nanŋe, Meliki sâm, ya teteop. Melikihât nanŋe, Lewi sâm, ya teteop. Lewihât nanŋe, Matat sâm, ya teteop. Matatgât nanŋe, Eli sâm, ya teteop. Elihât nanŋe, Yosep sâm, ya teteop. Otmu Yosepgât yuwu nâŋgâm hilipguwi. “Yosepgât nanŋe, Yesu sâm, ya teteop.” Yawu gârâmâ Yesu ya Anitâŋe himbimâmbâ hâŋgângumu ge manop. Otmu Yesuŋe manmu yambu 30 otbaŋgimu nep topŋe kalop. ");
INSERT INTO spl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Anitâhât Wâtgât mâmâŋahât Heakŋe Yesu mâmâŋe otbaŋgimu Yoran to ya pilâm lok ki manmaiângen ariop. ");
INSERT INTO spl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yan ari sot barak manmâ gamu hilâm 40 pesuk sâop. Sotgât po waŋgimu wâtŋe houŋ sâop. ");
INSERT INTO spl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yawu otmu Satanŋe biwiŋahât topŋe nâŋgâwe sâm yuwu sâm ekuop. “Gâ bonŋanâk Anitâhât nanŋe mansat otmuâmâ kât yu sârâ sot otmu nendâ gekbe. Yawu otdâ yanâmâ gâ bonŋanâk Anitâhât nanŋe bulâŋe mansat sâwom.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sâmu sâop. “Âlepŋe yarâke yamâ benŋe Anitâhât den âlâ yuwu tap. “Anitâŋe haoŋmâ ârândâŋ tihitnenŋe otmap. Yawu gârâmâ sotŋak konok wâtnenŋe miaŋgim manmâ yâhânomgât dop ki tap. Yamâ wongât? Anitâŋe den sâm ningimap ya gurâ lâum yâhânom. Yawu otmunŋe ârândâŋ otbuap yakâ.” Den yawu tap yakât otmâ gâŋe den eknohoat ya ki nâŋgâwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yawu sâmu pumŋe gip gipŋan dâim yâhâop. Dâim yâhâm yanâmâ hânŋe hânŋe lok kutyeŋe pato ya yeŋgât senŋe âlâlâ dondâ tatyiŋgiop ya tiripgum yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Senŋe âlâlâ tatmâ arap enda eksat? Nâŋe yukât kunyeŋe manman. Otmu yu kerek nâhât pat oap. Yakât otmâ lok âlâ me âlâŋe galemyeŋe katnek sâm eknohonomai yamâ âlepŋe galemyeŋe katbom. Yamâ nâhât wahap. ");
INSERT INTO spl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yakât otmâ gâŋe nâ mepaenekbuat yanâmâ galemyeŋe katgekmune senŋe âlâlâ yu gâhâlâk hârok otbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sâmu sâop. “Maiŋ, Anitâŋe den âlâ sâop ya yuwu tap. “Anitâ pato konohâk tap. Yâk konok mepaenom. Otmu yâkât den konohâk tem lâum hoŋ bawaŋgim mannom.” Den yawu tap. Yakât otmâ gâŋe den eknohoat ya lâuwomgât dop âlâ ki tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Yawu sâmu yanâk Satanŋe dâimu Yerusalem kapi pato yakât opon kâmbukŋahât gimbâŋan yâhâowot. Yâhâm Satanŋe yuwu sâm ekuop. “Anitâŋe sâmu den âlâ kulemguwi ya yuwu tap. “Kâlân kâihan teŋ sâmapgât Anitâŋeâmâ aŋelolipŋe hâŋgânyongomu ge tihitge otŋetâ ki hiliwahowuat.” Den yawu tap. Yawu gârâmâ gâmâ bulâŋanâk Anitâhât nanŋe mansat otmuâmâ yupâ soŋ pilâm kioŋ. Kioŋdâ ki gohowuap. Yâhâ gekmâ yuwu nâŋgâwom. “O, bulâŋanâk lok yuâmâ Anitâhât nanŋe mansap.” Yawu sâwom.” ");
INSERT INTO spl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sâmu purik pilâwaŋgim sâop. “Bâiŋ, den âlâ yuwu tap. “Anitâŋe tihitnenŋe otmap. Yakât otmâ “Ihilâk otbe,” ki sânom.” Den yawu tap yakât otmâ gâŋe den eknohoat ya nâŋgâmune tâŋât oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Yawu sâmu Satanŋe pilâm sâp girawuân topŋe mem tetewom nâŋgâm manop. ");
INSERT INTO spl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Anitâhât Wâtgât mâmâŋahât Heakŋe Yesu mâmâŋe otbaŋgimu lok ki manmaiângembâ Galilaia hânân âwurem ariop. Âwurem ariop yakât den pat kapi ambolipŋaŋe sâm haok tuhuŋetâ kapi tipi tapi tatmâ arap ya ambolipŋe kerekŋe nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yawu otmâ miti emetŋe ârândâŋ ari den kâsikum yiŋgimu heroŋe otbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yawu otmâ ikŋe kapi Nasaret yan ariop. Otmu tatmâ nâŋgâ nâŋgâ sâp ârândâŋâk miti emetŋan yâhâ Anitâ mepaeminiop yawuâk olop. Emelâk Anitâŋe poropetelipŋe ekyongomu Miti pepaen kulemguwi ya sâlikuwe sâm yahatmâ kinop. ");
INSERT INTO spl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yahatmâ kinmâ poropete Yesaiaŋe pepa kulemguop ya waŋetâ miop. Mem gahaem ekmâ den yuwu kulemguop ya mem teteop. ");
INSERT INTO spl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Kutdâhât Wâtgât mâmâŋahât Heakŋe mâmâŋe otnihim âi yuwu sâm nihiop. Lohimbi biwiyeŋe orotok sâmu mansai ya yeŋgâlen ari den pat âlepŋe ekyongowom. Yâhâ lohimbi umatŋe kakŋan mansai yâk holaŋyekbom. Yâhâ lohimbi senyeŋe bok sâsâŋe ya heŋgemyongomune senyeŋe hâreakmu eknomai. Yâhâ lohimbi mem âlâlâ tuhuyekŋetâ hâhiwin nâŋgâmai ya mem heweweŋ tuhuyekmune biwi heroŋe nâŋgânomai. Yâhâ Kutdâŋe lohimbi nâŋgâyiŋgim tihityeŋe otmâ manman âlepŋan katyekmu manmâ heroŋe nâŋgâwaŋginomai yakât sâp tâlâhuap yakât den pat ekyongowom. Yawu.” ");
INSERT INTO spl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Den ya sâlikum pepa ya mem goŋgoŋgum hoŋ bawa âlâ waŋmâ ge talop. Ge tatmu miti emetŋan tatbi kerekŋe denŋe nâŋgâne sâm ândâp katbi. ");
INSERT INTO spl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ândâp katŋetâ yuwu sâm ekyongop. “Den sâlikum ekyongomune naŋgai yukât bulâŋe yiwereŋe teteap.” ");
INSERT INTO spl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yawu sâm ekyongomu yâkât nâŋgâŋetâ yahatmu den âiloŋgo eknongoap sâm nâŋgâŋetâ âlâ kândâkdâ olop. Yawu olowâke yamâ nombotŋaŋe yâkât nâŋgâŋetâ gemu yuwu sâwi. “O yu Yosep nanŋe yukâ.” ");
INSERT INTO spl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yawu sâŋetâ yuwu sâm ekyongop. “Hâmbâi yeŋe yuwu sâm eknohonomai. “Lohimbi heŋgemyongomat gârâmâ gike tânaho.” Otmu den âlâmâ yuwu sâm eknohonomai. “Kapanaum kapiân kulem mem gat yakât den pat sâŋetâ nâŋgâmain. Yukât otmâ yuân yawuâk mendâ ekne.” Yawu sâm eknohonomai. ");
INSERT INTO spl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yakât otmâ yuwu sâmune nâŋgâŋet. Anitâhât poropetelipŋaŋe kapi âlâen ari yâkât den kâsikum yiŋgiŋetâ nâŋgâŋetâ bulâŋe otmap. Yâhâ yâk hep torehenlipyeŋe den kâsikum yiŋgiŋetâ nâŋgâŋetâ tâŋât otmap. ");
INSERT INTO spl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yakât den âlâ torokatmâ sâmune nâŋgâŋet. Emelâk Anitâhât poropete, Isirae lok âlâ, kutŋe Elia sâm, ya manop. Sâp yan emet pato kinmu yambu kalimbu otmu emetsenŋe nombolân konok ya pesuk sâop. Yawu otmâ sot biatmu lohimbi kerekŋe poyeŋahât otmâ manbi. ");
INSERT INTO spl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Otmu sâp yan Isirae lohimbi yeŋgâlen imbi kambut seseŋgâlâk manbiâke yamâ Anitâŋe Elia ekumu ikŋe kapi pilâm Sarepat kapi Siron hânân tap yan imbi kambut âlâ manop yâkâlen ariop. Yâkâlen arimu Anitâŋe kambut ya tângumu yâkŋe Elia sot um waŋminiop. ");
INSERT INTO spl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Den âlâ torokatmâ sâmune nâŋgâŋet. Anitâhât poropete âlâ, kutŋe Elisa sâm, manop, sâp yan Isirae kapi ambolipŋe seseŋgâlâkŋe hâk bâle otbi. Otmu yâk yeŋgâlen gâtŋe ki âlepŋe otbi. Yâhâ lok âlâ, kutŋe Naman sâm, yâhâmâ Siria hânân gâtŋe, yâk konok âlepŋe olop.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yawu sâm ekyongomu miti emetŋan tatbiŋe nâŋgâŋetâ bâlemu kuk bâleŋe otbi. ");
INSERT INTO spl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yawu otmâ yahatmâ kapi betŋehen hem bâleŋe tap yapâ hâpuŋetâ giâkgât Yesu mem gewi. ");
INSERT INTO spl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mem gewi yamâ Anitâŋe mâmâŋe otbaŋgimu pilâyekmâ âlâengen ariop. ");
INSERT INTO spl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yapâ pilâyekmâ kapi âlâ Galilaia hânân tap, kutŋe Kapanaum sâm, yan ariop. Otmu tatmâ nâŋgâ nâŋgâ sâp âlâen miti emetŋan yâhâ den kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Den kâsikum yiŋgimu nâŋgâŋetâ âlâ kândâkdâ otmu yuwu sâwi. “Lok yuŋe Anitâhât sâtgât otmâ den kâsikum ningiap. Nâŋgâmunŋe yawu oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Yâhâ lok âlâ weke bâleŋaŋe mem mâŋgâemu manminiop yaŋe miti emetŋan tatmâ Yesuhât denŋe nâŋgâop. Yawu otmâ weke bâleŋaŋe biwi nâŋgân nâŋgânŋe mem purik pilâmu kârikŋan halahum yuwu sâop. “Bâe, Yesu Nasaret amboŋe. Gâ wongât nâhâlen takat? Hilipnohowe sâm takat me? Gâhât topge naŋgan. Gâmâ Anitâhât nanŋe bulâŋe mansat. Otmu Anitâŋe hâŋgângohomu nâ bukulipne orowâk hilipnongowe sâm gion.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yawu sâmu yuwu sâm sâwaŋgiop. “Kâmbukŋe. Gâ gaiakmâ ba ari.” Yawu sâmu weke bâleŋe yaŋe gaiakmâ ba arimu lok ya senŋe gâwâŋ gâwâŋ sâmu lauŋe barakŋaŋak pato otmâ ge iop. ");
INSERT INTO spl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yawu otmâ ge imu ekŋetâ sâtŋe otmu yuwu sâm alahuwi. “Bâe, wâtŋe pato tatbaŋgiap yakât otmâ weke bâleŋe sâwaŋgimu tem lâuwaŋgim gaiakmâ ba arap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yakât den pat ya sâm haok tuhuŋetâ kapi nombot nombot huhum liŋgarakmâ arimu lohimbi kiŋgitŋe orowâkŋe nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesuŋe yahatmâ miti emetŋambâ gem ariop. Ari lok âlâ, kutŋe Simon Petoro, yâkât hewunŋe mesek pato kumu hâkŋe kâlâp otmu im talop. Yakât ekuŋetâ emelan yâhâop. ");
INSERT INTO spl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Emelan yâhâm ekmâ yan mesek ya sâwaŋgimu hâkŋe sânduk sâop. Yawu otmu imbi yaŋe yahatmâ sot um yiŋgimu newi. ");
INSERT INTO spl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Um yiŋgimu nem tatŋetâ emetsenŋe purik sâop yan sombemân yâhâ kinop. Kinmu kapi ambolipŋe kundat âlâlâ otbi ya lâuyekmâ yâkâlen ariwi. Yawu otŋetâ kunyeŋan mem heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Otmu weke bâleŋe watyekmu gaiakmâ ari kârikŋan halahum yuwu sâwi. “Gâ Anitâhât nanŋe.” Yawu sâwi yakât otmâ Yesuhât topŋe sâm tetem lohimbi ekyongomaihât kuyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Emet haŋ sâmu emelambâ gem lok biaengen ariop. Arimu kapi ambolipŋaŋe pâinŋetâ biatmu kapi ya pilâm betŋan watmâ ariwi. Ari mem tetem pilânenekmâ âlâengen arimap sâm mem alitbi. ");
INSERT INTO spl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mem alitŋetâ yuwu sâm ekyongop. “Nâ kapi ârândâŋ ari Anitâhât den kâsikum yiŋgimune lâum mannomai yakât hâŋgânnohomu gewan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yawu sâm Yuraia hânân kapi tipi tapi tatmâ arap yan ari miti emetŋe ârândâŋ yâhâm gem den kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hilâm âlâen Yesuŋe Genesaret deŋgân ginŋan ari kinop. Ari kinmu lohimbi dondâŋe Anitâhât den nâŋgâne sâm yâkâlen ari mem hawam mewam tuhuwi. ");
INSERT INTO spl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yawu otŋetâ waŋga yâhâp talop yakât ambolipŋaŋe waŋgaembâ gem iŋan itâŋe pirim kinbi. ");
INSERT INTO spl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pirim kinŋetâ Yesuŋe lok âlâ, kutŋe Simon sâm, yâkât waŋgaen yâhâm yuwu sâm ekuop. “Ga puli kuŋetâ endun bane.” Yawu sâmu puli kum endun baŋetâ lohimbi yaŋe deŋgân ginŋan ge tatbi. Ge tatŋetâ Yesuŋe yahatmâ waŋga hâmeŋan yâhâ kinmâ den kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Den kâsikum yiŋgimu pesuk sâmu Simon yuwu sâm ekuop. “Deŋgân tânâmŋan ba iŋan itâŋe pilâŋetâ gemu iŋan dondâŋe yakât kâlehen kutakulakŋetâmâ mem dâiŋetâ gawuap.” ");
INSERT INTO spl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sâmu sâop. “Lok pato, nenŋe omoŋe iŋan itâŋe pilâmunŋe giap yamâ iŋan âlâ ki miain. Yawu gârâmâ gâhât den ya lâum yâhâpŋe ba iŋan itâŋe ihilâk pilâmunŋe gewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yawu sâmu iŋan itâŋe pilâŋetâ gemu iŋan dondâhâlâk yakât kâlehen kutakulakŋetâ mem dâiŋetâ tiririk sâm tok sâwe sâm olop. ");
INSERT INTO spl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tok sâwe sâm otmu yaŋak benŋe bukulipyeŋe waŋga âlâen kinbi ya sâŋetâ ga tânyongowi. Tânyongoŋetâ iŋan itâŋe ya mem dâiŋetâ waŋga yâhâp pik sâmu guhulakde sâm olowot. ");
INSERT INTO spl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Yawu otmu Petoro otmu bukuyâhâtŋe, imi ata, kutyetŋe Yakowo yet Yoane, Yeweri nanyâhâtŋe, yâkŋe iŋan dondâ ya ekŋetâ âlâ kândâkdâ olop. Ekŋetâ âlâ kândâkdâ otmu yakât otmâ Simon Petoroŋe Yesu mepaem yuwu sâop. “Maiŋ, Kutdâ, mat oarâke. Gâmâ lok âlepŋe. Yawu gârâmâ nâmâ lok bâleŋe. Yakât otmâ nâŋe hâmehan kinbomgât dop bia.” Sâmu sâop. “Biwi yâhâp ki ot. Yiwereŋe iŋan dâiat. Yâhâ hâmbâi lok meyekdâ nâhâlen biwiyeŋaŋe kepeim mannomai.” ");
INSERT INTO spl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yawu sâm ekumu puli kuŋetâ waŋga ya deŋgân ginŋan yâhâmu yan âiyeŋe pilâm Yesuhâlen torokatŋetâ orowâk manbi. ");
INSERT INTO spl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuŋe kapi ya pilâm âlâen arimu lok âlâ hâk bâle kârikŋe tetewaŋgimu manopŋe Yesu ekmâ yan gotŋan bam yuwu sâm âikuop. “Lok pato, gâŋe sârâ kundat topŋe topŋe biatningiwuapgât dop tap. Yawu sâŋetâ naŋgan. Yakât otmâ nâŋgânihirâ hâk bâle yuŋe pesuk sânihiâkgât naŋgan.” Yawu sâm âikuop. ");
INSERT INTO spl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sâmu sâop. “Nâŋgâhihian. Âlepŋe, walipgohomune hâk bâle biatgihiâk.” Yawu sâm walipgumu yanâk biatbaŋgimu âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yawu otmu Yesuŋe yuwu sâm ekuop. “Gâ otgihian yukât den pat bukulipge ki ekyongowuat. Hotom umai yeŋgâlen konok ari ekyongowuat. Ekyongom yan Moseŋe hotom u uhât girem den kulemguop ya watmâ kinmâ Anitâhât hotom umbuat. Hotom umbuat ya ekmâmâ lohimbiŋe hâk bâle biatgihiap yukât topŋe nâŋgânomai.” Yawu sâm ekumu ariop. ");
INSERT INTO spl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yapâ ari iliwetmâ den pat ya sâm haok tuhuop. Sâm haok tuhumu den pat ya liŋgarakmâ kapi ârândâŋ arimu lohimbi kiŋgitŋe orowâkŋe Yesuhât den nâŋgâne sâm yâkâlen ariwi. Yâhâ lohimbi kundat otbi gurâ Yesuŋe mem heŋgemnongoâk sâm yâkâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yâkâlen ari mem hawam mewan tuhuŋetâ yakât pilâyekmâ lok biaengen ari Anitâ orop den olowot. ");
INSERT INTO spl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Hilâm âlâen Yesuŋe lohimbi den kâsikum yiŋgiop. Yawu otmu Parisaio lok otmu Mosehât girem den kâsikum yiŋgiminiwi ya nombotŋe kapi âlâlâ Galilaia otmu Yuraia hânân tatmâ arap ya pilâm yâkâlen ariwi. Yâhâ nombotŋe âlâmâ Yerusalem kapi pato yapâ ariwi. Kapi âlâlâ ya pilâm lohimbi yâk yeŋgâlen ari tatmâ yâk orop oset guset otmâ kinbi. Yawu otŋetâ Anitâŋe Yesu mâmâŋe otbaŋgimu lohimbi heŋgemyongowuapgât dop teteop. ");
INSERT INTO spl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sâp yan lok pareŋe âlâ mem gerelân katmâ lâum yâkâlen ariwi. Lâum ariŋetâ lohimbi dondâŋe emet umbiŋan kinmâ mâtâp maŋguyiŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mâtâp maŋguyiŋgiŋetâ yakât otmâ yâk yeŋgâlen hâum pâpguwi. Hâum pâpgum mâtâpgât pâinmâ emet gimbâŋan getek getek lâum yâhâwi. Yâhâ emet gimbâŋe mem kusatmâ mem katŋetâ lohimbi hohetyeŋan Yesuhât gotŋan giop. ");
INSERT INTO spl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Otmu Yesuhâlen biwiyeŋaŋe kepeiwi yakât topŋe ekmâ lok pareŋe ya yuwu sâm ekuop. “Anitâŋe tosahe yiwereŋe pilâhihiap.” ");
INSERT INTO spl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yawu sâmu Mosehât girem den kâsikum yiŋgiminiwi otmu Parisaio yâkŋe nâŋgâŋetâ bâlemu biwiyeŋe ekmâ yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","“Yeŋe nâ nekŋetâ lok bâleŋe otmune biwiyeŋaŋe yawu naŋgai. Yakât nâŋgâmune ki ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wuân âi tuhumune ekŋetâ dopŋan otbuap? Yuwu mon sâm ekuwom. “Nâŋe tosahe pilâhihian.” Yawu sâwom me? Me “Gâ getek yahatmâ geretge lâuakmâ ari,” sâwom. ");
INSERT INTO spl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yakât nine topne yuwu sâmune nâŋgâŋet. Nâ Anitâŋe hâŋgânnohomu gewangât tosayeŋe pilâyiŋgim mansan. Anitâŋe âi sâm nihiop yukât topŋe ekmâ nâŋgâŋetgât oan.” Yawu sâm ekyongop. Yawu sâm ekyongom topŋe ekmâ keterakŋetgât lok pareŋe ya yuwu sâm ekuop. “Gâ yahatmâ geretge lâuakmâ emetgan ari.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yawu sâmu in yawu yahatmâ Anitâ mepaem geretŋe lâuakmâ emetŋehen ariop. ");
INSERT INTO spl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Arimu lohimbi hâlâŋmâ kinbiŋe Yesuŋe Anitâhât wâtŋan kinmâ nep miop ya ekŋetâ âlâ kândâkdâ otmu Anitâ mepaem yuwu sâwi. “Âun yukârâmâ wahap ki orotŋe tetemu eksain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Otmu Yesuŋe emelambâ gem ariop. Ari takesi meme lok âlâ, kutŋe Lewi sâm, yâkŋe tewetsenŋe emetŋan tatmu ehop. Tatmu ekmâ yuwu sâm ekuop. “Ga. Nâhâlen torokatdâ orowâk mandehât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yawu sâm ekumu Lewiŋe tewetsenŋe meminiop ya pilâm yahatmâ Yesuhâlen torokatmu orowâk ariowot. ");
INSERT INTO spl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yawu otmâ Lewiŋe Yesuhât heroŋe nâŋgâwaŋgim dâimu emetŋan yâhâowot. Emetŋan yâhâmutâ takesi meme lok otmu lok nombotŋe meyekmu gaŋetâ sot pato uyiŋgimu newi. ");
INSERT INTO spl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nem tatŋetâ Parisaio lok otmu Mosehât girem den kâsikum yiŋgiminiwiŋe belângen kinmâ yekmâ nâŋgâŋetâ bâlemu hoŋ bawalipŋe yuwu sâm âiyongowi. “Wongât Yesuŋe takesi meme lok otmu lok bâleŋe yu orop menduhuakmâ lau konok niai?” ");
INSERT INTO spl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yawu sâm âiyongoŋetâ Yesuŋe den ya nâŋgâm Parisaio yuwu sâm ekyongop. “Den âlâen hâum sâmune nâŋgâŋet. Lok mesekyeŋe biaŋe dokta yeŋgâlen ki arimai. ");
INSERT INTO spl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yâhâ lok kundatyeŋe orop me hâhiwin teteyiŋgimap yaŋe konok dokta yeŋgâlen arimai. Yakât topŋe yuwu sâmune nâŋgâŋetâ keterahâk. Yeŋgâlen gâtŋe nombotŋaŋe yuwu sâmai. “Nen lok âlepŋe, nen orotmemenenŋe âiloŋgo dondâ otmâ mansain.” Yawu sâm pâlâmŋe manmai. Lok yawuya yeŋgât sâm ki gewan. Yeŋe lok bâleŋe sâm kewilâyekŋetâ belângen manmai yawuyaŋe orotmemeyeŋe bâleŋe pilâm Anitâhâlen biwiyeŋaŋe kepeim denŋe lâum bulâŋe mem teteŋetgât gewan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yesuŋe den yawu sâm ekyongomu lok nombotŋaŋe yuwu sâm ekuwi. “Yoane bukulipŋe otmu Parisaio lok nombotŋaŋe Anitâhât âi menehât nâŋgâm yâkâlen biwiyeŋaŋe hikum sot barak manmâ Anitâ mepaem manmai. Yamâ gâhât hoŋ bawalipgaŋeâmâ sot kutakamai.” ");
INSERT INTO spl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sâŋetâ sâop. “Yakât den âlâen hâum sâmune nâŋgâŋet. Lok patoŋe imbi miakbe sâm bukulipŋe meyekmu orowâk tatmâ sot um nem heroŋe otnomai. Heroŋe otnomaiân sot barak ki tatnomai. Yâhâ hâmbâi mâne kasalipyeŋaŋe taka bukuyeŋe kuŋetâ mumbuap yanâmâ eŋgat hako nâŋgâm sot barak mannomai. ");
INSERT INTO spl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yakât yuwu sâmune nâŋgâŋet. Yiwereŋeâmâ nâ orowâk mansain yakât otmâ sot barak ki mansai. Hâmbâi mâne nâ nohoŋetâ mumbom sâp yan eŋgat hako nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Otmu orotmeme embâŋân otminiwi ya otmu ikŋe orotmeme âiŋe kâsikum yiŋgiop yaŋe ki lâuahop. Yakât otmâ yâhâp yâhâp menduhum lâunomaihât dop ki olop. Yakât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâm ekyongop. “Nen sot me salup me âlâlâ une sâm hâpu golâenâk mânuŋmâ titâkum umain. Gârâmâ hâpu tekaŋan mânuŋmâ kâlâwân katmain yamâ hâpu tekaŋe ya sem huhumu sot ya golâ kinmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Otmu den âlâen hâum yuwu sâop. “Imbi âlâŋe lepa dorokum tâk masipguwuap. Masipgum katmu tatmâ hâŋgiŋe otbuap. Yâhâ yakât kakŋan tâk âiŋe orop menduhum lowaim iri osowuap. Iri osom senŋe âlâlâ mânuŋbuap yan dâimu tiririk sâmu tok sâwuap. ");
INSERT INTO spl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yakât otmuâmâ nenŋe tâk âiŋaŋak menduhum lowaimain. Yawu otmain yanâmâ senŋe âlâlâ umatŋe mânuŋnomân yamâ dâimu ŋirik ŋirik sâm ki tok sâwuap. Yâhâ hâŋgiŋe otmu âiŋe menduhunom yamâ dâimu titâk sâwuap. Yamâ ki orotŋe. ");
INSERT INTO spl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Otmu yuwu sâmune nâŋgâŋet. Imbilipnenŋaŋe senŋe âlâlâ mem iri âiŋan mânuŋmâ hikâm arimai ya lândem iri hâŋgiŋe bâleŋan ki mânuŋmâ hikâm arimai. Iri âiŋahâlâk nâŋgâmai. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tatmâ nâŋgâ nâŋgâ sâp âlâen Yesu otmu hoŋ bawalipŋe âi kalam biwiŋambâ gem ariwi. Gem ari mâtâp tânâmŋan po irik irik yiŋgiop. Yawu otmuâmâ buku nombotŋe yeŋgât kalamân sot talop ya mem newi. ");
INSERT INTO spl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mem neŋetâ Parisaioŋe yekmâ Yesu yuwu sâm âikuwi. “Moseŋe girem den kulemguop ya lâum âun yu tatmâ naŋgain. Yakât girawu otmuâmâ hoŋ bawalipgaŋe bukulipyeŋe yeŋgât kalamâmbâ sot mem niai? Ya otŋetâ yekmunŋe bâleap. Yakât otmâ gâŋe kuyiŋgirâ âlâku ki otnomaihât naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Yawu sâŋetâ purik pilâyiŋgim sâop. “Emelâk embâŋân Dawitiŋe olop yakât den pat sâlikum ki nâŋgâm heŋgeŋgumai. Yakât topŋe nâŋgâŋetâ keterahâkgât yuwu sâmune nâŋgâŋet. Dawitiŋe olop sâp yan hotom uwi ya yeŋgât lok kunŋe âlâ manop, kutŋe Awiata sâm. Sâp yan Anitâhât hotom um manbiŋe baŋga tuhum Anitâhât pat sâm katminiwi ya yâkŋe konok neminiwi. Lok inŋeâmâ bia. Hilâm âlâen Dawiti otmu ikŋe tembe lâulipŋe sotgât bâleŋetâ yan ikŋak Anitâhât miti emetŋan yâhâop. Yâhâmâmâ Awiataŋe sot kâmbukŋe sâm kalop ya ihilâk mem niop. Mem nem nombotŋe talop ya mem tembe lâulipŋe ge kâsikum yiŋgimu newi. ");
INSERT INTO spl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yâhâ Anitâŋe hâŋgânnohomu ge mansan nâmâ tatmâ nâŋgâ nâŋgâ yakât amboŋe. Otmu yakât bonŋeâmâ nâŋe konok mem teteman.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tatmâ nâŋgâ nâŋgâ sâp âlâen Yesuŋe miti emetŋan yâhâm den kâsikum yiŋgiop. Yâhâ lok âlâ bâtŋe bonângen mum pâlâmŋe olop yan tatmu ehop. ");
INSERT INTO spl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yawu gârâmâ “Tatmâ nâŋgâ nâŋgâ sâpŋan Yesuŋe lok pareŋe ya mem heŋgeŋguwuap me bia?” sâm Parisaio lok otmu Mosehât girem den kâsikum yiŋgiminiwi ya nombotŋaŋe Yesu mem den âiân katne sâm bamu bam watbiŋe gotyetŋan ba kinbi. ");
INSERT INTO spl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Gotyetŋan ba kinŋetâ Yesuŋe biwiyeŋahât topŋe nâŋgâm lok pareŋe ya yuwu sâm ekuop. “Yahatmâ kin.” ");
INSERT INTO spl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sâmu yahatmâ kinmu benŋe Parisaio ya yuwu sâm ekyongop. “Sâŋetâ nâŋgâwe. Moseŋe den kulemguop ya topŋe girawu tap? Tatmâ nâŋgâ nâŋgâ sâpŋan lok heŋgemyongonom me hilipyongonom? Yakât sâŋetâ nâŋgâwe.” ");
INSERT INTO spl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yawu sâm âiyongomu biwiyeŋe umatŋe otmu olotoŋâk kinbi. Olotoŋâk kinŋetâ yekmu bâleop. Yekmu bâlemu kunyeŋe kârikŋe otmâ hiliwahonomai yakât nâŋgâm tepŋe nâŋgâyiŋgiop. Tepŋe nâŋgâyiŋgim lok pareŋe ya yuwu sâm ekuop. “Bâtge kuwihak.” Yawu sâmu bâtŋe pilâmu kuwihahop. ");
INSERT INTO spl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Panmu kuwihakmu Parisaio lok otmu Mosehât girem den kâsikum yiŋgiminiwiŋe ya ekmâ biwiyeŋe kâlâp otmu gem ariwi. Gem ari Yesu girawu otbaŋgine sâm den alahu gulahu otbi. ");
INSERT INTO spl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Emet ŋiŋ sâmu Anitâ orop den otbe sâm Yesuŋe pumŋan yâhâop. Yâhâmu Anitâ orop den otmutâ emet haŋ sâop. ");
INSERT INTO spl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Emet haŋ sâmu yan lok orowâk manbi ya sâlipyongom yâk yeŋgâlen gâtŋe lok kâiân yâhâp meyekmâ âi sâm yiŋgiop. Yawu otmâ kutyeŋe pato Aposolo sâm yiŋgiop. Lok yamâ kutyeŋe yuwu. ");
INSERT INTO spl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon yâkât kutŋe âlâ Petoro sâm imiŋe Anderea, imi ata Yakowo yet Yoane, lok âlâmâ Pilip, Batolomaio, ");
INSERT INTO spl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio, Toma, Alipaio nanŋe Yakowo. Âlâmâ Simon yâhâmâ komot âlâen gâtŋe ya yeŋgât topyeŋe yuwu. Kasalipyeŋe Roma lok ya yeŋgât hâkâŋ otmâ watyekne sâm otminiwi yan gâtŋe. Âlâmâ Yakowo nanŋe Yurasi. ");
INSERT INTO spl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Otmu bâiŋeâmâ Yurasi yamâ Karioto kapiân gâtŋe. Yâkŋeâmâ Yesuhât betŋehen kioŋop ya. ");
INSERT INTO spl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Meyekmâ pumŋehembâ gâlikŋan gemu lok nombotŋe denŋe nâŋgâm watbiŋe peneyiŋgiwi. Peneyiŋgiŋetâmâ lohimbi kiŋgitŋe orowâkŋe denŋe nâŋgâne sâm yâkâlen ariwi. Lohimbi yâkâlen ariwi yamâ yuwu. Nombotŋe Yerusalem kapi pato otmu kapi tipi tapi Yuraia hânân tatmâ arap ya ambolipŋe. Yâhâ nombotŋe âlâmâ Tiro Siron kapi yâhâp saru ginŋan tap ya ambolipŋe. Lohimbi yaŋe yâkâlen ariŋetâ den kâsikum yiŋgiop. Yâhâ lohimbi nombotŋe weke bâleŋaŋe mâŋgâeyehop ya ekyongomu gaiakmâ ariŋetâ âlepŋe otbi. Otmu kundat otbi ya heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yâhâ wâtŋe pato tatbaŋgiop yakât otmâ lohimbi in wâiwiŋe âlepŋe otbi. Yakât otmâ lohimbi sambeŋe wâim âlepŋe otnehât mem hawam mewam tuhuwi. ");
INSERT INTO spl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yawu otŋetâ Yesuŋe yuwu sâm ekyongop. “Den bonŋe sâmune nâŋgâŋet. Yen senŋe âlâlâhât umburuk otmâ manmai yamâ Anitâhâlen biwiyeŋaŋe kepeiŋetâ tihityeŋe otmâ yâhâwuap. Yakât otmâ tepyeŋe heroŋe otmu mannomai. ");
INSERT INTO spl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yâhâ po manmai yen gurâ Anitâŋe sot kâle yiŋgimu neŋetâ ârândâŋ otyiŋgiwuap. Yakât otmâ tepyeŋe heroŋe otmu mannomai. Yâhâ we bâle nâŋgâm manmai yenâmâ hâmbâi Anitâŋe mem biwi sânduhân katyekbuap. Yakât otmâ tepyeŋe heroŋe otmu mannomai. ");
INSERT INTO spl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Otmu lok bulâŋe nâhâlen biwiyeŋaŋe kepeim manŋetâ lohimbi nombotŋaŋe hakyeŋan sâm mem bâleyeknomai yanâmâ yuwu nâŋgânomai. “Âo, bonŋanâk. Aŋgoân emelâk tâmbâlipnenŋaŋe Anitâhât poropete yawuâk otyiŋgiŋetâ bâleop. Otmu âun yu gurâ yawuâk otningimai. Yawu gârâmâ yakât hâmeŋe hâmbâi himbimân manman kârikŋe mem heroŋe kakŋan mannom.” Yawu nâŋgâm tepyeŋe heroŋe otmu mannomai. ");
INSERT INTO spl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yawu sâm ekyongom lohimbi manman sânduhân manŋetâ tepyeŋe umatŋe otmap ya yeŋgât yuwu sâm ekyongop. “Lohimbi senŋe âlâlâ tatyiŋgiapŋe hop sambe kakŋan manmai. Yae, hâmbâi manman bâleŋan ari olo gilâp otnomai. ");
INSERT INTO spl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yâhâ lohimbi sot pato kakŋan kinmai yaŋe hâmbâi sotgât umburuk otmâ olo gilâp otnomai. Yâhâ lohimbi heroŋe kakŋan manmai yamâ hâmbâi gilâp amokŋan isem mannomai. ");
INSERT INTO spl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Otmu den âlâ torokatmâ sâmune nâŋgâŋet. Emelâk embâŋân poropete perâkŋaŋe Anitâhât den kelaŋgatmâ papatolipyeŋe kâityongominiwi. Kâityongoŋetâ ki nâŋgâmâk papatolipyeŋaŋe heroŋe otyiŋgiwi. Heroŋe otyiŋgiwiâke yamâ den perâkŋe sâwi yakât matŋe Anitâŋe yiŋgimu mewi. Yawu gârâmâ lohimbiŋe yeŋgât nâŋgâm heroŋe otyiŋginomai yan biwi golâ mannomai. Yâhâ heroŋe otyiŋginomai yan lohimbiŋe heroŋe otningiai yakât otmâ Anitâŋe gurâ yawuâk nenekmu ârândâŋ oap yawu ki nâŋgânomai.” ");
INSERT INTO spl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yâhâ den âlâ torokatmâ yuwu sâm ekyongop. “Sâmune nâŋgâŋet. Yeŋe kasalipyeŋe buku otyiŋginomai. Otmu lohimbiŋe yeŋgât hâkâŋ otmai yâk gurâ yawuâk buku otyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Otmu lok âlâ me âlâŋe Anitâŋe mem bâleyehâkgât lohimbi sait kakyeŋan pilânomai yamâ Anitâŋe lukuleyehâkgât ulitgunomai. Otmu lok âlâ me âlâŋe mem âlâlâ tuhuyeknomai yamâ yeŋe ya yeŋgât umam sâyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Lok âlâ me âlâŋe mâŋgâeyeknomai yan yakât matŋe ki kâpekyiŋginomai. Lok âlâ me âlâŋe amboŋahât bâleŋe hân meyiŋgim yaŋak kiapgâlen yen meyekmâ arinomai. Meyekmâ ariŋetâ mâtâwânâk yeŋe hân âlâkuâk yiŋgiŋetâ pesuk sâwuap. ");
INSERT INTO spl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Lok âlâ me âlâŋe yu me ya ningiŋet sâm ulityongonomai yamâ in yawu yiŋginomai. Me lok âlâ me âlâŋe senŋe âlâlâ ekmâ kandi meyiŋginomai yakât purik sâm ningiŋet ki sânomai. ");
INSERT INTO spl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bukulipyeŋaŋe tânyongoŋetgât nâŋgâmai yeŋe gurâ nâŋgâmai dop yawuâk tânyongonomai. ");
INSERT INTO spl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yâhâ lok nombotŋaŋe yen buku otyiŋgiŋetâ yengu yâk konok buku otyiŋginomai yakât Anitâŋe nâŋgâmu ki ârândâŋ otbuap. Yâhâ lok nombotŋaŋe ki buku otyiŋgiŋetâ yengu yawuâk yâk ki buku otyiŋginomai yakât Anitâŋe yen ki lukuleyekbuap. ");
INSERT INTO spl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","34","Yâhâ lok nombotŋaŋe yen orop buku konok manne sâm tânyongoŋetâ yengu yakât matŋe yâk konok tânyongomai. Yawu otmai yaŋe lok bâleŋe bukulipyeŋe orop tânahomai orotmeme ya ki wangiwuap. Yakât otmâ Anitâŋe yen ki lukuleyekbuap. ");
INSERT INTO spl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yeŋe kasalipyeŋe buku otyiŋginomai. Otmu yu me yakât umburuk manmai ya bât belaiâk yiŋgim yakât matŋe ningiŋetgât ki nâŋgânomai. Yawu otyiŋginomai yanâmâ Anitâ yahat yahatŋaŋe meyekmâ nine nanne baratne sâm tihityeŋe otmu mannomai. ");
INSERT INTO spl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Anitâŋe yen lok bâleŋe umam sâyiŋgimu yakât matŋe ki miai. Yakât otmâ lohimbi nombotŋaŋe mem âlâlâ tuhuyekŋetâ yengu yakât matŋe ki kâpekyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Otmu yeŋe lohimbi yeŋgât den ki sâm hâreyiŋginomai otmuâmâ Anitâŋe gurâ yawuâk yeŋgât ki sâm hâreyiŋgiwuap. Otmu yeŋe lohimbi yekmâ ki sâm ge katyeknomai otmuâmâ Anitâŋe gurâ yawuâk yen yekmâ ki sâm ge katyekbuap. Yâhâ yeŋe lohimbi yeŋgât tosayeŋe pilâyiŋginomai otmuâmâ Anitâŋe gurâ yawuâk yeŋgât tosayeŋe pilâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yeŋe lohimbi tânyongom senŋe âlâlâ yiŋginomai otmuâmâ Anitâŋe ya wangim hop sambe yiŋgiwuap. Iri mânuŋmâ tâtâkumunŋe pik pato otmap yakât dopŋeâk Anitâŋe yiŋgiwuap. Yakât otmâ Anitâŋe yiŋgimap yakât dopŋeâk yengu yiŋginomai.” ");
INSERT INTO spl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Lok senyeŋe bok sâsâŋaŋak dâiakmâ arinomai yamâ mâtâp tâpikgum ari hemân kioŋnomai. Kioŋmâ hiliwahonomai. ");
INSERT INTO spl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Otmu naom âlâ me âlâŋe bawapilipyeŋe ki wangiyeknomai. Naom âlâ me âlâŋe yu me yakât topŋe nâŋgâm heŋgeŋgunomai yanâmâ bawapilipyeŋaŋe nâŋgâmai yakât dopŋeâk nâŋgânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Den âlâen hâum yuwu sâm ekyongop. “Gâŋe bukuhahât senŋan wahap tipiŋe tap ya ekbuat. Otmu gike sengan gurâ wahap pato tap ya ki eŋakmâ naŋgaŋgimâk bukuhahât yuwu mon sâwuat. ");
INSERT INTO spl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“Buku. Sengan wahap ya hâluhum pangihiwe.” Gâ yawu sâwuat otmuâmâ lok perâkŋe. Gike sengan wahap pato tap ya hâluhum pilakmâ yanâmâ bukuhahât senŋan wahap tatbuap ya hâluhum pilâwaŋgiwuat. Wongât? Yuwuhât. Gâŋe gike orotmemehe bâleŋe yakât nâŋgârâ tâŋât otmap. Yawu gârâmâ bukuhaŋe otmu kiŋgoŋ otmap ya ekdâ dondâ bâlemap. Yawu otbuat yamâ ekmune ki ârândâŋ otbuap.” Yawu sâop.” ");
INSERT INTO spl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","Otmu Lohimbiŋe yeŋe topyeŋe naŋgaŋgiŋetgât Yesuŋe den âlâen hâum yuwu sâm ekyongop. Nak esenŋe omoŋ omoŋ pilâmap yanâmâ bonŋe bâleŋe ki kinmap. Yâhâ nak esenŋe gimbaŋgumap yanâmâ bulâŋe âlepŋe âlâ ki kinmap. Bia yakâ. Yâhâ kiatŋe manam ki otmap. Otmu manamŋe kiat ki otmap. Otmu giŋ gârârâŋ yaŋe ham ki otmap. Otmu hamŋe giŋ gârârâŋ ki otmap. Yamâ topyeŋe ikŋiâk ikŋiâk. ");
INSERT INTO spl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lok âlâhât biwiŋan nâŋgân nâŋgân âlepŋe me bâleŋe tatmap ya yawuâk lauŋambâ ga takamap. Yakât otmâ lohimbi âlâ me âlâhât biwiyeŋan nâŋgân nâŋgân âlepŋeâk tatmapŋe orotmemeyeŋe âlepŋe otmâ uwawapŋe bia manmai. Yâhâ lohimbi âlâ me âlâhât biwiyeŋan nâŋgân nâŋgân bâleŋeâk tatmapŋe orotmemeyeŋe bâleŋe otmâ bukulipyeŋe mâŋgâeyekmai. Yawu.” ");
INSERT INTO spl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesuŋe lohimbi kinbi ya yuwu sâm ekyongop. “Yeŋe “Kutdânenŋe Kutdânenŋe,” sâm nohonmaiâke yamâ den ekyongoman yamâ ki lâumai. ");
INSERT INTO spl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yakât otmâ den âlâen hâum sâmune nâŋgâŋet. Lok âlâ me âlâŋe nâhâlen gaŋetâ den ekyongomune nâŋgâm heŋgeŋgum lâumai yaŋe dop yuwu manmai. ");
INSERT INTO spl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lok nâŋgân nâŋgânyeŋe orop yaŋeâmâ emet tuhune sâm hân kendâm saran kâkâlep yaŋe kânâŋgâm emet tuhuŋetâ tiŋ tiŋâk kinbuap. Yawu gârâmâ mososoŋ mem gâsuk gâsuk tuhumu emet ya ŋiwiŋ ŋiwiŋ sâm ki putuk sâwuap. Yenâmâ dop yawuya. ");
INSERT INTO spl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Âlâmâ purik pilâm sâwe. Lok âlâ me âlâŋe nâhât den nâŋgâŋetâ nahat otmu betbaŋgim manmai, lok ya yeŋgât topyeŋeâmâ yuwu. Lok kopa nombotŋaŋe emetyeŋe tuhune sâm hân kendâm saran kakŋeâk kânâŋgânomai. Yawu tuhuŋetâ emet ya saranŋe kandi kinbuap. Yakât otmâ mososoŋ mem gâsuk gâsuk tuhumu emet ya putuk sâm ge imbuap. Yawu.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuŋe den yawu ekyongom yapâ pilâyekmâ Kapanaum kapiân ariop. ");
INSERT INTO spl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kapanaum kapiân ariop sâp yan Roma tembe lâu yeŋgât kunyeŋe âlâhât hoŋ bawaŋe mesek sâtŋan kinop. Yâhâ tembe lâu yaŋe ikŋe nanŋahât nâŋgâwaŋgimap yakât dopŋeâk hoŋ bawaŋe yakât nâŋgâwaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yakât otmâ “Yesu taka tap,” yawu sâŋetâ nâŋgâm tembe lâu yaŋe Yesuŋe ga hoŋ bawaŋe heŋgeŋguâkgât Yura yeŋgât papatolipyeŋe nombotŋe hâŋgânyongomu yâkâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ari yuwu sâm ekuwi. “Roma tembe lâu yeŋgât kunyeŋe âlâ nengâlen biwiŋaŋe kepeimu nen orop mansain. Lok yuŋe ikŋe tewetsenŋaŋe lok puluhuyekmu nengât miti emetŋe ya tuhuningiwi. Yakât otmâ denŋe nâŋgâm ari tânguwuatgât naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yawu sâm ekuŋetâ nâŋgâyiŋgimu orowâk ariwi. Ariŋetâ emet ya tâlâhumuâk otmu bukulipŋe hâŋgânyongomu Yesuhâlen ba yuwu sâm ekuwi. “O lok pato, bukunenŋe yuwu yap. ");
INSERT INTO spl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","“Nâ lok âlepŋe bia. Yakât gâŋe nâhât emelan gawuatgât ki naŋgan. mâtâwânâk kinmâ denâk sârâ hoŋ bawane yu âlepŋe otbuapgât naŋgan. ");
INSERT INTO spl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yâhâ nâ nineâmâ lok patonahât tem lâuwaŋgim yâkât amutgen manman. Gârâmâ patonaŋe nâ gurâ buku nombotŋe yeŋgât kunyeŋe sâm nihimu manman. Yakât otmâ nâŋe tembe lâulipne âlâ me âlâ yuken me yaken ariŋet sâmune âlepŋe nâhât tem lâunihim arimai. Me âi wuân me wuân tuhuŋet sâm âi yiŋgiman ya gurâ âiloŋgo tuhumai. Gâmâ lok pato. Yakât otmâ denâk sârâ âlepŋe otbuapgât naŋgan.” Yawu sâm den kalop ya bukulipŋaŋe Yesu ekuwi. ");
INSERT INTO spl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Den yawu ekuŋetâ Yesuŋe nâŋgâmu ewe membe olop. Nâŋgâmu ewe membe otmu Isirae lohimbi betŋan sâwi ya yuwu sâm ekyongop. “Wâtne pato tatnihiap yakât nâŋgâm Roma lok yuŋe biwi yâhâp ki oap. Yakât yuwu naŋgan. Isirae yeŋgâlen gâtŋe âlâ me âlâŋe lok yuŋe oap yuwu âlâ ki otŋetâ yekman. Lok yuŋe nâhâlen biwiŋaŋe kepeim den katnihiap yu ekmune âiloŋgo oap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yawu sâm ekyongomu tembe lâu bukulipŋaŋe purik sâm yapâ pilâyekmâ âwurem ari emelan yâhâm hoŋ bawa âlepŋe olop ya ekbi. ");
INSERT INTO spl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesuŋe hoŋ bawalipŋe meyekmâ kapi âlâ, kutŋe Nain sâm yan ariŋetâ lohimbi dondâhâlâkŋe betyeŋan sâŋetâ ariwi. ");
INSERT INTO spl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kapi ya hâumâk otŋetâ imbi kambut âlâhât nanŋe sihanâk muop ya hangune sâm bukulipŋaŋe gerelân katmâ lâum gewi. Yawu otmâ lohimbi tem pato betyeŋan sâŋetâ gewi. ");
INSERT INTO spl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Otmu Kutdâŋe kambut ya ekmâ tepŋe nâŋgâm “Ki ise,” sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yawu sâm ekum geret lâum gewi yan memu inâk kinbi. Inâk kinŋetâ lok sihan ya ekmâ yuwu sâm ekuop. “Yahatmâ kin.” ");
INSERT INTO spl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yawu sâm ekumu mumuŋambâ yahatmâ dendât otmu ekŋetâ sâtŋe bâleŋe olop. Otmu imbi kambut ya nanŋeit yetgât Yesuŋe “lohotŋan manset” sâm ekyotgop. ");
INSERT INTO spl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Otmu lohimbi yan kinbiŋe ya ekŋetâ sâtŋe otmu Anitâ mepaem yuwu sâwi. “Anitâŋe ikŋe poropete âlâ hâŋgângumu taka hohetnenŋan mansap.” Yâhâ nombotŋaŋe yuwu sâwi. “Lok yuŋe tihitnenŋe otmâ manman âlepŋan katnenekmu mannomgât Anitâŋe hâŋgângumu taka mansap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesuŋe lok sihan ya mumuŋambâ mem yahalop yakât den pat ya lohimbiŋe sâm haok tuhuŋetâ kapi tipi tapi Yuraia hânân tatmâ arap ya ambolipŋe kerekŋe nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoane pâi emetŋan katŋetâ talop yâkâlen ari hoŋ bawalipŋaŋe Yesuŋe lohimbi heŋgemyongop yakât den pat ekuwi. ");
INSERT INTO spl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ekuŋetâ nâŋgâm hoŋ bawayâhâtŋe yâhâp den yuwu sâm ekyotgom Kutdâhâlen hâŋgânyotgomu ariowot. “Ari yuwu sâm âikuromawot. “Anitâŋe ikŋe hoŋ bawa hâŋgângumu ge tihitnenŋe otbuap sâmain ya gâ me? Me âlâhât mambotmâ mannom?” ");
INSERT INTO spl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yawu sâm ekyotgom hâŋgânyotgomu Yesuhâlen ari yuwu sâm ekuowot. “Yoaneŋe lohimbi toen mem katyekmapŋe yuwu sâm hâŋgânnotgomu takait. “Anitâŋe ikŋe hoŋ bawa hâŋgângumu ge tihitnenŋe otbuap sâmain ya gâ me? Me âlâhât mambotmâ mannom?” yawu yap.” Yawu sâowot. ");
INSERT INTO spl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Otmu sâp yan Yesuŋe lohimbi kundat otbi ya dondâhâlâk heŋgemyongop. Otmu weke bâleŋaŋe lohimbi mâŋgâeyekbi ya watyekmu gaiakmâ ariwi. Otmu lohimbi senyeŋe bok sâsâŋe ya senyeŋan walipyongomu senyeŋe suk sâmu ekbi. ");
INSERT INTO spl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yawuhât Yesuŋe Yoanehât hoŋ bawayâhâtŋe ya yuwu sâm ekyotgop. “Yerâmâ ari kulem topŋe topŋe memune eksai yukât Yoane ekuromawot. Nâŋe senyeŋe bok sâsâŋe ya walipyongomune senyeŋe suk sâmu eksai. Otmu lok pareŋe manmai ya heŋgemyongomune târârâhâk bam gai. Otmu hâk bâle manmai ya gurâ heŋgemyongomune âlepŋe otmâ mansai. Otmu ândâpyeŋe bok sâsâŋe ya gurâ heŋgemyongomune ândâpyeŋe pâroŋ sâmu den naŋgai. Otmu nombotŋe bâlewi ya mumuŋambâ mem yahatyekmune mansai. Otmu kewilâyekŋetâ mansai ya nine den pat âlepŋe ekyongomune nâŋgâm biwiyeŋe heroŋe otmâ mansai.” Yawu sâm Yoane ekuromawot. ");
INSERT INTO spl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yakât âlâ sâwe. Yawu otyiŋgim mansan yakât otmâ lok âlâ me âlâŋe nâhât biwi nâŋgâm yâhâp ki otmai ya yeŋgât nâŋgâmune tepne heroŋe oap.” Yawu sâm ekyotgom hâŋgânyotgomu âwureowot. ");
INSERT INTO spl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hâŋgânyotgomu âwurem arimutâ Yesuŋe Yoanehât topŋe lohimbi yan kinbi ya yuwu sâm ekyongop. “Yoane lok ki manmaiângen ari manop ya lohimbiŋe ekne sâm yâkâlen ariwi. Otmu yakât den âlâen hâum sâwe. Siru pato pilâm âliwahap mem gâsuk gâsuk tuhumu ekmâ âlemai. ");
INSERT INTO spl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yawu olop ya ekne sâm ariwi me bia? Me lok âlâŋe hâk katipŋe sekŋe âlepŋe mânuŋakmâ manop ya ekne sâm ariwi me? Lok hâk katipŋe sekŋe âlepŋe mânuŋakmaiŋeâmâ lok kutdâ yeŋgât emelanâk tatmai. ");
INSERT INTO spl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yâhâ lok ki manmaiângen ki manmai. Yakât otmâ wuân bân ekne sâm yaken ariwi? Yakât yuwu sâmune nâŋgâŋet. Yoaneŋe Anitâhât den pat sâm tetem gaop ya nâŋgâne sâm ariwi. Yâhâ emelâk Anitâhât poropetelipŋaŋe yâkât den tâmbâlipyeŋe ekyongom manbi ya yeŋgât kunyeŋe pato oap. ");
INSERT INTO spl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yâkât nâŋgâm emelâk Anitâŋe den sâop ya yuwu tap. “Gâŋe nine topne sâm tetem ekyongorâ nâŋgâŋetgât nine hoŋ bawane hâŋgângumune kulet sâhihim mâtâp meŋgihiwuap.” Den yawu tap. Kulet sâop yamâ Yoane. ");
INSERT INTO spl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Otmu yakât den yuwu sâmune nâŋgâŋet. Anitâŋe Yoane nep waŋmu miop yakât nâŋgâmu yahatmap. Yakât otmâ lok âlâ me âlâŋe Yoane wanginomaihât dop ki tap. Yoaneŋe kulet sânihim âi mem gaop yamâ nine topne ki nâŋgâm heŋgeŋgum mansap. Yakât otmâmâ lok âlâ me âlâŋe nâhât den pat âlepŋe yu nâŋgâm Anitâhâlen biwi nâŋgân nâŋgânyeŋe katnomai yaŋeâmâ Yoane wanginomai. ");
INSERT INTO spl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yawu sâm ekyongomu lohimbi seseŋgâlâk, lohimbi inŋe, takesi meme lok, yawuyaŋe nâŋgâŋetâ bulâŋe olop. Yâhâmâ emelâk Yoaneŋe Anitâhât den ekyongomu nâŋgâŋetâ bulâŋe otmu toen mem katyehop. ");
INSERT INTO spl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yamâ Parisaio lok otmu Mosehât girem den lohimbi kâsikum yiŋgiminiwi yâkŋeâmâ Anitâhât mâtâp Yoaneŋe ekyongop yakât hâkâŋ otmâ denŋe nâŋgâŋetâ tâŋât olop. Yakât otmâ toen ki katyehop. ");
INSERT INTO spl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Otmu Yesuŋe den âlâ yuwu sâm ekyongop. Yen biwi yâhâp otmâ mansai yakât nâŋgâŋetâ keterakyiŋgiâkgât den girawu yaen hâum sâmune nâŋgâŋetâ keterakbuap. Yuwu mon? ");
INSERT INTO spl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","34","Nimnaom titipâŋe sombem patoen hârum konok otmâ tatnomai. Tatmâmâ komot âlâ tatnomaiŋe komot âlâ yuwu mon ekyongonomai. “Nenŋe yahatmâ kep tuhum âlâlâ oain. Gârâmâ yen orowâk tuhune sâmunŋe ki tânnongoai. Yakât otmâ nâŋgâmunŋe bâleap.” Yawu otnomai yakât topŋe teteâkgât yuwu sâmune nâŋgâŋet. Yakât dopŋeâk Yoaneŋe heroŋe olâkgât nâŋgâwi. Yamâ nâŋgâwi yawu Yoaneŋe ki olop. Yakât otmâ yâkât hâkâŋ otmâ sâm ge katbi. Otmu âlâku torokatmâ hâum sâwe. Sâp âlâen nimnaom titipâ komot âlâ tatnomaiŋe komot âlâ yuwu sâm ekyongonomai. “Âo, nen we bâle nâŋgâm ombe hakoâk isewin. Yawu otbin yan yeŋe ki nenekbi. Yakât otmâ nâŋgâmunŋe bâleap.” Yawu sânomai. Yakât dopŋeâk yeŋe otmâ mansai. Gârâmâ yeŋe oai yan ki torokatmâ mansan. Yakât otmâ yen nâhât hâkâŋ oai. Yakât yuwu sâmune nâŋgâŋet. Emelâk Yoaneŋe to kârikŋe me âlâlâ ya nembâpgât dop yamâ yâkŋe ki neminiop. Yakât yeŋe yuwu sâwi. “O, lok yuâmâ yawu otmap.” Yawu sâwi. Yâhâ nâmâ Anitâŋe hâŋgânnohomu ge sot kâle neman. Yakât otmâ yeŋe nâhât yuwu mon nâŋgâmai. “O, lok yuâmâ sot pato kutakamap. Otmu takesi meme lok otmu lok komborâ yâk orop buku oraŋgim gamai.” Nâhât yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yawu gârâmâ yakât sâwe. Anitâŋe den sâop ya tiŋâk lâum manmai ya yeŋgât orotmemeyeŋe ekmâ nâŋgâŋetâ bonŋe otbuap. Yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisaio lok âlâ, kutŋe Simon sâm, yâkŋe Yesu memu emetŋan yâhâ bukulipŋe orowâk menduhuakmâ sot newi. ");
INSERT INTO spl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yâhâ Yesu orowâk sot newi yakât den pat imbi kondarâ âlâŋe nâŋgâmâmâ to kukŋe suk sukŋe âlâ mem emet tatbiân yan yâhâop. ");
INSERT INTO spl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mem yâhâ Yesu betŋehen kinmâ isemu gilâpŋe târâŋ sâm kâiŋan giop. Kâiŋan gemu somotŋe kâlep pato yaŋe mem gowasiŋmâ kereŋ mewaŋgiop. Yawu otmâ to kukŋe ya moselemu kâiŋan gemu pirim mepaeop. ");
INSERT INTO spl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yawu otmu Simonŋe ekmâ biwiŋaŋe yuwu nâŋgâop. “Imbi kondarâ yuŋe ki orotŋe oap. Yawuhât Yesu Anitâhât poropete mansap mâne imbi yukât topŋe nâŋgâm heŋgeŋgum kuwaŋgimu ki otbâp. ");
INSERT INTO spl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yawu nâŋgâmu Yesuŋe biwiŋahât topŋe nâŋgâm yuwu sâm ekuop. “Simon, den sâmune nâŋgâ.” Sâmu sâop. “Lok pato, sârâ nâŋgâwe.” ");
INSERT INTO spl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sâmu sâop. “Den âlâen hâum sâmune nâŋgâ. Lok âlâŋe bukuyâhâtŋe tewetsenŋe yitgiop, âlâmâ 50 kina, âlâmâ 5 kina. ");
INSERT INTO spl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tewetsenŋe yitgimu mem ari yaŋe senŋe âlâlâ puluhuahowot. Otmu yakât kakŋan “matŋe nihiromawot” sâm ekyotgop. Yawu gârâmâ tewetsenŋe ki tatyitgiop. Yakât otmâ yâkâlen ari yuwu sâm ekuowot. “Tewetsenŋe ki tatnitgiap. Yakât otmâ girawu otmâ tosa matŋe kâpekmutŋe pesuk sâwuap?” Yawu sâm ekumutâ yuwu sâop. “Bât belaiâk yitgiwan. Pesuk yap, âlepŋe ariyet.” Yawu sâop. Yakât otmâ yuwu âihohomune nâŋgâ. Bukuyetŋaŋe tosayetŋe pilâyitgimu pesuk sâop. Yakât otmâ bukuyâhâtŋe lok girawu yaŋe heroŋe pato nâŋgâwaŋgiop, 50 kina waŋop yaŋe me 5 kina waŋop yaŋe? ");
INSERT INTO spl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sâmu sâop. 50 kina waŋop yaŋe heroŋe pato nâŋgâwaŋgiop.” Sâmu sâop. “Âlepŋe yat.” ");
INSERT INTO spl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yawu sâm imbi ya ekmâmâ Simon yuwu sâm ekuop. Nâŋe emetgan gamune to ki gâim katdâ piriaksan. Yamâ imbi yuŋeâmâ isemu gilâpŋaŋe kâinan gemu pirim somotŋaŋe gowasiŋmâ kereŋ menihiap. ");
INSERT INTO spl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gâŋe ki parahuneksat. Yamâ imbi yuŋeâmâ mepaenekmâ tap. ");
INSERT INTO spl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gâŋe nak toŋe ki katnihiat. Yamâ imbi yuŋeâmâ to kukŋe suk sukŋe, hâmeŋe yahat yahatŋe ya moselemu kâinan gemu pirineksap. ");
INSERT INTO spl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Imbi yuŋeâmâ nâŋgânihiap. Yakât topŋe nâŋgâm heŋgeŋguwuatgât yuwu sâmune nâŋgâ. Lok âlâŋe bukuŋahât tosa umatŋe pilâwaŋgimu yakât heroŋe pato nâŋgâwaŋgiwuap. Yâhâ lok âlâŋeâmâ bukuŋahât tosa heweweŋ pilâwaŋgimu yakât heroŋe kakŋeâk nâŋgâwaŋgiwuap. Yakât yuwu sâmune nâŋgâ. Anitâŋe imbi yukât tosa umatŋe emelâk pilâwaŋgiap. Yakât otmâ mepaenekmâ tap. ");
INSERT INTO spl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yawu sâm imbi ya yuwu sâm ekuop. “Tosahe pilâhihian.” ");
INSERT INTO spl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yawu sâmu, Parisaio orowâk tatmâ sot newiŋe den ya nâŋgâm biwiyeŋaŋe yuwu nâŋgâwi. “Lok yukât topŋe girawu? Girawu otmâ “Tosahe pilâhihian” yawu yap.” Biwiyeŋaŋe yawu nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuŋe imbi ya yuwu sâm ekuop. “Nâhâlen biwihaŋe kepeiat. Yakât otmâ Anitâŋe manman kârikŋahât pat kuhihiap. Yakât nâŋgâm lohotŋan ari.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sâp yakât kakŋan Yesuŋe hoŋ bawalipŋe meyekmu kapi ya pilâm kapi tipi tapi tatmâ arap ya ârândâŋ yâhâm gewi. Otmu lohimbiŋe Anitâhâlen biwiyeŋaŋe kepeiŋetâ tihityeŋe otyiŋgiwuap yakât den pat âlepŋe Yesuŋe ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Otmu imbi nombotŋe orowâk ariwi ya yeŋgât topyeŋe yuwu. Imbi nombotŋe emelâk kundat otbi ya heŋgemyongop. Yâhâ nombotŋe âlâmâ weke bâleŋaŋe mâŋgâeyekbi ya watyekmu gaiakmâ ariwi. Yâhâ yâk yeŋgâlen gâtŋe âlâ, kutŋe Maria, Matala kapiân gâtŋe, ya weke bâleŋe nombolân yâhâpŋe mâŋgâeŋetâ watbaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yâhâ âlâmâ, kutŋe Yoana sâm. Yâhâmâ Herotgât hoŋ bawa âlâ, kutŋe Kusa sâm, yâkât imbiŋe. Yâhâ âlâmâ, kutŋe Susana sâm. Otmu imbi nombotŋe iri sikumyeŋe orop yâkŋe Yesu otmu hoŋ bawalipŋe tânyongowi. Imbi topyeŋe sâm aran yu orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lohimbi dondâŋe kapiyeŋe pilâm Yesuhâlen ari menduhuakŋetâ den âlâen hâum yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","8","“Lok âlâŋe hote alikŋe mem hâiloŋbe sâm newângen ariop. Ari hote alikŋe ya nombot nombot mem hâiloŋmu giop. Nombotŋeâmâ mem hâiloŋmu mâtâwân ge talop. Yâhâ nombotŋeâmâ mem hâiloŋmu hân toŋe biaen ge talop. Yâhâ nombotŋeâmâ hele bâleŋe iowân giop. Yâhâ nombotŋeâmâ tep tep kum hân âiloŋgo loŋgo tuhuwi yan ge talop. Yawu gârâmâ hote alikŋe mem hâiloŋmu âlâen âlâen giop yakât topŋeâmâ yuwu. Nombotŋe mâtâwân ge talop yamâ lohimbiŋe bam gam tâlim laŋ tuhuŋetâ nâiŋe kârâm newi. Yâhâ nombotŋeâmâ hân toŋe biaen giop yamâ gihitŋe kakŋeâk pilâop. Yakât otmâ in yawu mum hâlâlâŋ sâop. Yâhâ nombotŋeâmâ hewukŋan me hele pato biwiŋan giop yamâ âiloŋgo tetem pururuk sâop. Pururuk sâmu hewukŋaŋe langumu derepgum gimbaŋgumu orok sâop. Yâhâ nombotŋe hân âlepŋan giop yaŋeâmâ tetem pururuk sâm âiloŋgo yahalop. Nâŋe den yan yu biwiyeŋan katmâ nâŋgâm heŋgeŋgunomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yawu sâm ekyongomu hoŋ bawalipŋaŋe den ya topŋahât nâŋgâne sâm âikuwi. Âikuŋetâ sâop. ");
INSERT INTO spl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Anitâŋe tihitnenŋe otmâ gamap yakât topŋe yeŋe tipiŋe naŋgai. Yâhâ lok nombotŋe nâhâlen ki torokatmâ mansaiŋeâmâ biwiyeŋe pâlâmŋe otmâ mansai. Biwiyeŋe pâlâmŋe otmâ manŋetâ yakât den âlâen âlâen hâum ekyongoman. Yakât otmâ yâkŋe nâhât nâŋgâm hâkâŋ otmâ nekmâ kâkâsuk otmai. Yawu otmâ biwiyeŋe alitmai. Yakât otmâ nâhât den pat yu nâŋgâŋetâ tâŋât oapgât hiliwahonomai. Yamâ nâŋgâm heŋgeŋguai mâne biwiyeŋe Anitâhâlen katmâ denŋe lâuŋetâ tosayeŋe emelâk pilâyiŋgimbâp.” ");
INSERT INTO spl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hote alikŋan hâum ekyongoan yakât topŋe sâmune nâŋgâŋet. Anitâhât den yamâ hote alikŋahât dop oap. ");
INSERT INTO spl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yâhâ lok hote alikŋe mem hâiloŋmu giop yamâ nenŋe Anitâhât den lohimbi ekyongomunŋe nâŋgâmai yakât dop. Hote alikŋe nombotŋe mem hâiloŋmu mâtâwân giop yakât topŋe yuwu. Yamâ lohimbi nombotŋaŋe Anitâhât den nâŋgâŋetâ bulâŋe otmu yâkâlen biwiyeŋaŋe kepeimaihât Satanŋe den ya kum mem gulip tuhumap. ");
INSERT INTO spl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yâhâ hote mem hâiloŋmu nombotŋe hân toŋe biaen giop yakât topŋe yuwu. Lok yawuya nâhât den pat âlepŋe ekyongomune nâŋgâm heroŋe otmâ manmai. Nâŋgâŋetâ den ya kakŋeâk gem biwiyeŋan gihitŋe kârikŋe ki memap. Yawu gârâmâ umatŋe âlâ kakyeŋan yâhâmap yan lohotŋe otmâ pilâmai. ");
INSERT INTO spl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yâhâ hote mem hâiloŋmu nombotŋe hele biwiŋan giop yakât topŋe yuwu. Lohimbi nombotŋe den ekyongomune nâŋgâŋetâ bonŋe otmap. Nâŋgâŋetâ bonŋe otmu sâp kâlep ki otmuâk hângât iri sikum, me tewetsenŋe, me âlâlâ ekmâ biwi nâŋgân nâŋgânyeŋaŋe yan hikum nâŋgâm manmai. Yawu manmai yakât otmâ biwi yâhâp otmâ manŋetâ manman âlepŋe ki teteyiŋgimap. ");
INSERT INTO spl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yâhâ hote mem hâiloŋmu nombotŋe hân toŋe orowân giop yakât topŋe yuwu. Lok yawuyaŋeâmâ den pat âlepŋe nâŋgâm heŋgeŋgumai. Nâŋgâm heŋgeŋgum tiŋâk lâum manmâ yâhâŋetâ manman âiloŋgo loŋgo teteyiŋgimap. Yâk yeŋgât topyeŋe yawu. Nâŋe hoteân hâum yan yamâ topnenŋeâmâ yawu.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Nenŋe emet kâlehen tatmâ lambe saum tuŋguŋan ki katmain. Gârâmâ heleŋân gâitmunŋe kinmâ sem laŋinŋe pilâmu ekmâ gem yâhâmain. ");
INSERT INTO spl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yakât topŋe yuwu. Lok âlâ me âlâŋe otŋetâ bâlemu kurihimai yamâ hâmbâi mâne tetekŋan otmu eknom. ");
INSERT INTO spl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yakât otmâ den ekyongoan yu biwiyeŋan katmâ nâŋgâm heŋgeŋgunomai. Lok âlâ me âlâŋe nâhât den nâŋgâm biwiyeŋan katmâ mannomaiŋe ya nâŋgâŋetâ keterakbuap. Yâhâ lok âlâ me âlâŋe nâhât den nâŋgâŋetâ nahat otmu bet pilânomaiŋe biwiyeŋe pâlâmŋe manmâ ki nâŋgâŋetâ keterakmâ heŋgeŋguwuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yawu sâm ekyongom tatmu lohimbi kiŋgitŋe orowâkŋe denŋe nâŋgâne sâm mem hawam mewam tuhum kinbi. Yawu kinŋetâ ikŋe hepŋe torehenlipŋaŋe taka gotŋan bane sâm otŋetâ lohimbiŋe mâtâp maŋguyiŋgiŋetâ betyeŋehen kinbi. ");
INSERT INTO spl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Betyeŋehen kinŋetâ lok âlâ Yesu gotŋan talopŋe yuwu sâm ekuop. “Torehenlipgaŋe taka betnenŋehen kinmâ gâhât yai.” ");
INSERT INTO spl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yawu sâmu Yesuŋe yuwu sâm ekyongop. “Anitâhât tem lâum mansai yaŋeâmâ nâhât hepne torehenlipne bulâŋe oai.” ");
INSERT INTO spl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hilâm âlâen Galilaia deŋgân pato ya hâtikgum nombotgen arine sâm waŋgaen yâhâwi. Waŋgaen yâhâm hâtikgum nombotgen ariwi. ");
INSERT INTO spl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Arim tatŋetâ Yesu amangât katmu aman pâlâmŋe iop. Aman im tatmu deŋgân ya tânâmguŋetâ yanâk siru puŋ puŋ sâm pilâop. Siru puŋ puŋ sâm pilâmu toŋe waŋga kâlehen gemu guhulakbe sâm olop. ");
INSERT INTO spl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Guhulakbe sâm olop yan ekŋetâ sâtŋe otmu hoŋ bawalipŋaŋe mândem yuwu sâwi. “Wâe, lok pato, waŋga yu deŋgân kâlehen guhulakbe sâm oap. Harannongomap.” Yawu sâm ekuŋetâ yahatmâ siru kuwaŋgiop. Kuwaŋgimu to yaŋe nâŋ nâŋ sâop. Nâŋ nâŋ sâmu yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Wongât biwi yâhâp oai? “Nâŋe tihityeŋe otbomgât dop ki tap,” yawu mon naŋgai?” Yawu sâm ekyongop. Yawu sâm ekyongomu yuwu sâm alahuwi. “Bâe, lok yukât topŋe girawu? Siru kuwaŋgimu yaŋak to yaŋe nâŋ nâŋ yap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","To nâŋ nâŋ sâmu deŋgân ya hâtikgum ba nombot endaken kapi âlâ, kutŋe Gerasene sâm, yan ariwi. ");
INSERT INTO spl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Yan ari waŋgaembâ lâum kioŋmâ ariŋetâ kapi amboŋe, lok âlâ weke bâleŋaŋe mâŋgâeminiop, ya takamu ekbi. Yâhâ yâkât topŋe yuwu. Lok yamâ sumân bam gam otmu weke bâleŋaŋe mâŋgâemu hâk katipŋe tuhum pilâm hâk barahâk manmâ gaop. Otmu ikŋe kapi ambolipŋaŋe ari tâk kârikŋe, kutŋe sein sâm, yaŋe kâiŋe bâtŋe mem menduhum sâhâminiwiâke yamâ tâmbiriŋ sâmu hâreakminiop. Yawu otma weke bâleŋaŋe mâŋgâemu lok ki manmaiângen ari ihilâk mahilâk manminiop. Lok yakât topŋe yawu. Lok yaŋe ewan kinmâ Yesu ekmâ yâkât gotŋan ge kinop. Gotŋan ge kinmu Yesuŋe weke bâleŋe ya watbe sâm yuwu sâm ekuop. “Lok yukâlembâ gaiakmâ ari.” Yawu sâmu hu halak tuhum yuwu sâm ulitguop. “Yesu, topge naŋgan. Gâ Anitâhât nanŋe. Yamâ wongât nâhâlen takat? Nâ hâhiwin ki nihi. Inâk âwurem arihât naŋgan.” Yawu sâm ulitguop. ");
INSERT INTO spl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ulitgumu sâop. “Ahonakdâ nâŋgâwe.” Sâmu sâop. “Nâŋe weke bâleŋe nombotŋe orowâk tatmâ lok yu mem mâŋgâem mansain. Yakât otmâ nengât kutnenŋe “Komot Pato,” yawu. ");
INSERT INTO spl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aiop, gâŋe nâŋgâningirâ sumânâk mannom. Hem topŋan ki hâŋgânnongorâ arinom.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yâhâ talapŋan bau seseŋgâlâkŋe tomot tuhum kinŋetâ yekbi. Yekmâ yuwu sâm Yesu ekuwi. “Gâŋe watnenekbuat otmuâmâ, âlepŋe watnenekdâ gaiakmâ bau enda yeŋgâlen arinom.” Yawu sâwi. Yawu sâŋetâ watyekmu gaiakmâ bau ya yeŋgâlen ge mânuŋakbi. ");
INSERT INTO spl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bau yeŋgâlen ge mânuŋakmâ mâŋgâeyekŋetâ sururuk sâm ba hem patoembâ tâwoŋ sâm deŋgânân kioŋetâ haranyongop. ");
INSERT INTO spl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Deŋgânân kioŋetâ haranyongomu galemyongom manbiŋe ekmâ sururuk sâm kapi ambolipŋe ya ekyongowi. ");
INSERT INTO spl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ekyongoŋetâ yakât topŋe nâŋgâne sâm Yesuhâlen takawi. Otmu emelâk weke bâleŋaŋe lok mâŋgâeŋetâ ihilâk mahilâk manminiop yamâ nâŋgân nâŋgânŋe keterakbaŋgimu hâk katipŋe mânuŋahop ya ekbi. Ekŋetâ sâtŋe otmu lohimbi Yesu orop kinbi ya âiyongowi. ");
INSERT INTO spl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Âiyongoŋetâ Yesuŋe weke bâleŋe watyekmu gaiakmâ ariŋetâ nâŋgân nâŋgânŋe keterakbaŋgiop yakât den pat ekyongowi. ");
INSERT INTO spl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ekyongoŋetâ nâŋgâŋetâ sâtŋe otmu Yesuŋe pilâyekmâ âlâengen ariâkgât ekuwi. Yakât otmâ Yesuŋe hoŋ bawalipŋe meyekmu waŋgaen yâhâwi. ");
INSERT INTO spl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Waŋgaen yâhâŋetâ yan lok weke bâleŋe watbaŋgiop yaŋe yuwu sâop. “Nâ girawu otbom? Yen orop arinehât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Sâmu sâop. “Bia, gâ nen orop ki arinom. Yakât otmâ kapihehen ari gike hep torehenlipge yakât den pat ya ekyongowuat.” Yawu sâop. Yawu sâmu kapiân yâhâ Yesuŋe heŋgeŋguop yakât den pat kapilipŋe ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yawu otmâ Yesuŋe hoŋ bawalipŋe meyekmu kapi ya pilâm waŋga mem âwurem ariwi. Âwurem ari waŋgaembâ geŋetâ deŋgân ginŋan lohimbi dondâŋe Yesu ekne sâm taka kinbi. ");
INSERT INTO spl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yawu otmâ kinŋetâ miti emetŋahât galemlipyeŋe yeŋgât lok kunŋe, kutŋe Yairo sâm, yâkŋe gotŋan ba mepaem yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","“Baratne, ombe bisine konohâk ya sihanâk katnenekbe sâm oap. Yawu gârâmâ gâŋe ari heŋgeŋguhât naŋgan.” Yawu sâop. Yawu sâm ekumu Yesuŋe hoŋ bawalipŋe meyekmu ya pilâm Yairohât emelan ariwi. Mâtâwân arim tatŋetâ Yesu takaop yakât den pat ya lohimbi dondâŋe nâŋgâm ekne sâm yâkâlen ariŋetâ orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yâhâ imbi âlâ orowâk ariwi yâkât topŋeâmâ yuwu. Imbilipnenŋaŋe emetsenŋe ekmai dop yawu ki olop. Yâhâ imbi yuâmâ emetsenŋe ekmâ yâhâmu yambu kâiân yâhâp olop. Yambu kâiân yâhâp yu biwiŋan dokta yeŋgâlen arimu hep ya saŋ sâekgât âi pato mewiâke yamâ yawuâk otmâ gaop. ");
INSERT INTO spl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yâhâ imbi yaŋe Yesuhât betŋan bam yâkât sâŋgum potonŋan in walipgumu yanâk hepŋe saŋ sâop. ");
INSERT INTO spl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yâhâ walipguop yanâk Yesuŋe eŋgatŋe kakŋambâ olelem yekmâ “Âlâŋe walipnohoap?” sâm âiyongop. Yawu sâm âiyongomu yan kurihiakŋetâ Petoroŋe yuwu sâop. “Lohimbi dondâŋe mem hawam mewam tuhunenekŋetâ pâŋ sâm kinsain. Yakât otmâ gâ girawu nâŋgâm yat? Yan gâtŋaŋe mon walipgohoai.” ");
INSERT INTO spl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sâmu sâop. “Walipnohoap yan hâkne katmâ naŋgan.” ");
INSERT INTO spl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yawu sâmu imbi yaŋe kâi bâtŋe kârâŋ kârâŋ sâmu kinop. Yawu otmâ Yesuhât sâŋgum potonŋan walipgumu hepŋe sâŋ sâop yakât topŋe kerek ekuop. ");
INSERT INTO spl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sâmu sâop. “Toune, biwihe nâhâlen katsat. Yakât otmâ Anitâŋe nâŋgâhihimu hepge saŋ yap. Lohotŋan ba ari.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yawu sâm ekum kinmu yanâk Yairohât hoŋ bawalipŋe nombotŋaŋe emelambâ taka yuwu sâm ekuwi. “Baratge emelâk bâleap. Yakât otmâ lok pato yu imbiâk sârâ gamap.” ");
INSERT INTO spl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yawu sâŋetâ Yesuŋe nâŋgâm Yairo yuwu sâm ekuop. “Yakât ki gorâhihiâk. Nâhâlen biwihaŋe kepeim eŋgat yâhâp ki ot.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yawu sâm Yairohât emet gotŋan ba kinmâ lohimbi nombotŋe katyekmu yaehen kinbi. Yaehen kinŋetâ Petoro, Yakowo, otmu imiŋe Yoane, Yairo, imbiŋeit meyekmu emet kâlehen yâhâwi. ");
INSERT INTO spl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yâhâ lohimbi dondâŋe kahân tatmâ isem we bâle pato nâŋgâm tatbi. Yawu ot tatŋetâ yuwu sâm ekyongop. “Baratyetŋe ki bâleap, in aman pâlâmŋe iap. Yakât otmâ ki iseŋet.” ");
INSERT INTO spl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yawu sâm ekyongomu nâŋgâŋetâ nahat otmu giriŋbaŋgiwi. Emelâk katnenekmâ arap nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yâhâ Yesuŋe imbi sihan ya bâtŋan mem yuwu sâm ekuop. “Barat tipiŋe, yahatmâ kin.” ");
INSERT INTO spl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yawu sâmu yanâk yahatmâ bam gaop. Yawu otmu Yesuŋe sâmu sot um waŋetâ niop. ");
INSERT INTO spl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Otmu âwâŋe mâmâŋaŋe ya ekmutâ âlâ kândâkdâ olop. Yawu otmâ bukulipyetŋe ki ekyongoromawot sâm kuyitgiop. ");
INSERT INTO spl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuŋe hoŋ bawalipŋe kâiân yâhâp menduhuyekmâ âi sâm yiŋgim yuwu sâm ekyongop. “Yen nâhât sâtgât otmâ ari weke bâleŋaŋe lohimbi mâŋgâeyekŋetâ mansai ya watyiŋgiŋetâ gaiakmâ arinomai. Otmu lohimbi kundat otmâ mansai ya heŋgemyongonomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Otmu lohimbiŋe Anitâhâlen biwiyeŋaŋe kepeiŋetâ tihityeŋe otbuap yakât den pat ekyongom kapi âlâen âlâen ari kundat otbi ya heŋgemyongonomaihât mâmâŋe otyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mâmâŋe otyiŋgim yuwu sâm ekyongom hâŋgânyongop. “Âi topŋe katne sâm sot me senŋe âlâlâ umatdâek ki miakmâ arinomai. Natik ki miaknomai. Me itâkat ki goleaknomai. Me tewetsenŋe hâkyeŋan ki tatbuap. Me pet me hâk katipŋe ya hourâ hourâ ki miaknomai. Me howan ki tinaŋgum arinomai. ");
INSERT INTO spl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Otmu kapi âlâen arinomai yanâmâ emelan dâim yâhâ katyekŋetâ yanâk tatnomai. Kapi ya ambolipŋaŋe orotmemeyeŋe bâleŋe betbaŋgim biwiyeŋe Anitâhâlen katŋet sâm nâhât den pat âlepŋe ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yâhâ kapi âlâen ari den ekyongoŋetâ nâŋgâŋetâ nahat otmu bet pilânomai yamâ hâmbâi Anitâŋe matŋe umatŋe yiŋgiwuap. Yakât otmâ kâiyeŋan wahap me bokosok me yu ya horatbuap yamâ tâlim gik beretek meŋetâ gewuap. Ya gemu betyiŋgim pilâyekmâ ba âlâengen arinomai. Ariŋetâ towat ya ekmâ kâi katsap yawu nâŋgânomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yawu sâm ekyongom hâŋgânyongomu kapi âlâen âlâen ari yâkât den pat âlepŋe ekyongowi. Den pat âlepŋe ekyongom yan lohimbi mesek otbi ya mem heŋgemyongowi. ");
INSERT INTO spl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Otmu sâp yanâmâ Galilaia yeŋgât lok kutdâ âlâ manop, kutŋe Herot Antipa sâm, yâkŋeâmâ Yesuŋe olop miop yakât den pat nâŋgâop. Lohimbi nombotŋaŋe yuwu sâŋetâ nâŋgâop. “Herotŋe tembe lâulipŋe ekyongomu Yoane kuŋetâ muop yamâ mumuŋambâ yahatmâ mansap,” yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yâhâ nombotŋaŋeâmâ yuwu sâŋetâ nâŋgâop. “Poropete lok âlâ, kutŋe Elea sâm, emelâk himbimân yâhâop yaŋe mon purik sâm ge mansap,” yawu sâwi. Yâhâ nombotŋaŋeâmâ yuwu sâŋetâ nâŋgâop. “Anitâhât poropetelipŋe emelâk muwi yâk yeŋgâlen gâtŋe âlâ yaŋe mumuŋambâ yahatmâ mansap,” yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yawu sâŋetâ Herotŋe nâŋgâm eŋgat yâhâp otmâ yuwu sâop. “Emelâk tembe lâulipne ekyongomune Yoane eŋgatŋe hârewi. Yakât otmâ lok girawu yaŋe yu ya otmâ mansap yakât den pat sâŋetâ naŋgan?” Yawu sâm Yesu ekbehât nâŋgâm manop. ");
INSERT INTO spl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Emelâk Yesuŋe hoŋ bawalipŋe hâŋgânyongomu kapi âlâen âlâen ari yâkât den pat âlepŋe ekyongowi. Ekyongom pesuk pilâm yâkâlen âwurem ari otbi mewi yakât ekuwi. Ekuŋetâ meyekmu yeŋiâk tatmâ nâŋgâne sâm Besaita kapiân ariwi. ");
INSERT INTO spl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kapi yan ariwi yakât den pat lohimbi kiŋgitŋe orowâkŋe nâŋgâm betyeŋehen watyekmâ ariwi. Ariŋetâ yan Yesuŋe tepŋe nâŋgâyiŋgim Anitâhâlen biwiyeŋaŋe kepeiŋetâ tihityeŋe otbuap yakât den pat âlepŋe ekyongop. Otmu bukulipyeŋe mesek topŋe topŋe otbi ya meyekmâ takaŋetâ mem heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yawu otmâ Anitâhât den topŋambâek kâsikum yiŋgimu emetsâpŋe otmu yan hoŋ bawalipŋaŋe yuwu sâm ekuwi. “Yu tain yu hâlâŋmâ kapi tipi tapi âlâ ki tap. Yakât po yiŋgimu wâtyeŋe houŋ sâmapgât gâŋe hâŋgânyongorâ ariŋet. Hâŋgânyongorâ ari yeŋahâk sot puluhum um nenomai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sâŋetâ sâop. “Âlepŋe yeŋe sot kâsikum yiŋgiŋet.” Sâmu sâwi. “Nengâlen baŋga kândâkdâ mome otmu iŋan yâhâp yawuâk tap. Lohimbi dondâ taka tai. Yawu gârâmâ nenŋe katgekmâ ari sot puluhuyiŋgim lâum takanomgât naŋgat me?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yâhâ lohimbi taka tatbi ya yeŋgât dowâmâ 5000 yawuya. Yesuŋe yuwu sâm ekyongop. “Yeŋe lohimbi yu ekyongoŋetâ kâsiwahom komot tipi tapi, komot 50 dop yawuya tatmâ ariŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yâhâ lohimbi ekyongoŋetâ den sâop yawuâk otbi. ");
INSERT INTO spl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Otmu Yesuŋe sot ya mem himbimân pak sâm ekmâ Anitâ mepaeop. Anitâ mepaem baŋga ya motokmâ tipi tapi tuhum hoŋ bawalipŋe yiŋgimu lohimbi ya kerehâk yiŋgiŋetâ newi. Yâhâ iŋan gurâ yawuâk yiŋgiŋetâ neŋetâ dopyeŋan olop. ");
INSERT INTO spl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Neŋetâ dopyeŋan otmu sot nombotŋe talop ya hoŋ bawalipŋaŋe hâwurum mânuŋetâ saka saka kâiân yâhâp pik sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Otmu hilâm âlâen Yesuŋe hoŋ bawalipŋe katyekmu tatŋetâ ikŋiâk ba kinmâ Anitâ ulitguop. Ulitgum pesuk pilâmu hoŋ bawalipŋe yâkâlen ariŋetâ yuwu sâm âiyongop. “Lohimbiŋe nâhât girawu nâŋgâmai?” ");
INSERT INTO spl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sâmu sâwi. “Nombotŋaŋe gâhât yuwu sâmai. “Yoaneŋe lohimbi toen katyekminiop ya emelâk kuŋetâ muop ya mumuŋambâ yahatmâ mansap,” yawu sâmai. Yâhâ nombotŋaŋeâmâ, “Poropete âlâ, kutŋe Elea sâm, emelâk himbimân yâhâop yaŋe purik sâm ge mansap,” sâmai. Yâhâ nombotŋaŋeâmâ, “Anitâhât poropetelipŋe emelâk muwi ya yeŋgâlen gâtŋe âlâŋe mumuŋambâ yahatmâ mansap,” gâhât yawu sâmai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sâŋetâ sâop. “Yawu gârâmâ yeŋeâmâ nâhât girawu nâŋgâmai?” Sâmu Petoroŋe yuwu sâop. “Anitâŋe hâŋgângohomu ge mansat ya nâŋgâmunŋe bulâŋe oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yâhâ yakât topŋe sâm tetem lohimbi ekyongomaihât sâm kuyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Den âlâ torokatmâ yuwu sâm ekyongop. “Nâ lok bulâŋe mansan. Yawu gârâmâ hotom umai yeŋgât kunlipyeŋe otmu Isirae nengât papatolipnenŋe otmu Mosehât girem den kâsikum ningimai ya kerekŋe biwi konohâk otmâ yan nâhât sâm bâlenihim mem âlâlâ tuhunekmâ nohoŋetâ mumbom. Mum yan hân kâlehen hilâm kalimbu tatmâ benŋe yapâ mumuŋambâ yahatbom.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Otmu Yesuŋe lohimbi kerehâk yuwu sâm ekyongop. “Lohimbi âlâ me âlâŋe biwiyeŋe nâhâlen katmaiŋe nâhâlen torokatne sâm yan yeŋahât ki nâŋgâŋetâ yahatbuap. Me senŋe âlâlâ tatyiŋgiap ya biatningimap sâm yakât ki nâŋgâm ketet otmâ eŋgat yâhâp otnomai. Nâhât den haoŋmâ ârândâŋ nâŋgâm tem lâunihim mannomai. ");
INSERT INTO spl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yawu gârâmâ benŋe lok âlâ me âlâŋe manmanyeŋe alilaknomai yamâ hiliwahonomai. Yâhâ lok âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim manmâ nâhât den pat âlepŋe yu lohimbi ekyongonomai. Ekyongonomai yakât otmâ yongoŋetâ munomai yamâ Anitâŋe mumuŋambâ mem yahatyekbuap. ");
INSERT INTO spl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yâhâ lok âlâ me âlâŋe iri sikum me manman topŋe topŋe yan biwi nâŋgân nâŋgânyeŋe hikum manmâ munomai yaŋe girawu otnomai. Yeŋahâk mumuŋambâ yahatnomaihât dop âlâ ki tap. Nâ lok bulâŋe den kâsikum yiŋgim mansan. Yeŋgâlen gâtŋe âlâ me âlâŋe nâhât den nâŋgâŋetâ nahat otmu betnihinomai yamâ matŋe yuwu kâpekyiŋgiwom. Hâmbâi sâp patoen Himbim Awoŋnaŋe yâhâpŋe hâŋgânnohomu aŋelolipne meyekmune hânân genom. Sâp yan yeŋgâlen gâtŋe âlâ me âlâŋe nâhât den nâŋgâŋetâ nahat otmu betnihimai yamâ nâku yawuâk betyongomune matŋe umatŋe menomai. ");
INSERT INTO spl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hâmbâi sâp patoen Himbim Awoŋnaŋe yâhâpŋe hâŋgânnohomu aŋelolipne meyekmune hânân genom. Gem yan manmanyeŋahât matŋe âlâku ikŋiâk ikŋiâk kâpekmâ yiŋgiwom. ");
INSERT INTO spl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yuwu sâm ekyongomune nâŋgâm biwiyeŋan katmâ mannomai. Yen ki mum meteŋetâek Anitâŋe tihityeŋe otbe sâm lok bulâŋe nâ hâŋgânnohomu âwurem ge tihityeŋe otbisâm.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Den yawu ekyongop yakât kakŋan hilâm nombolân yâhâp mon pesuk sâmu Yesuŋe Anitâ ulitguwe sâm olop. Yakât otmâ Petoro, Yakowo, otmu imiŋe Yoane, meyekmu hoŋ bawalipŋe nombotŋe âlâmâ katyekŋetâ tatŋetâ yeŋiâk pumŋe âlâen yâhâwi. ");
INSERT INTO spl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yâhâ kinŋetâ Yesuŋe Anitâ ulitgum kun kundenŋe âlâ otmu sâŋgumŋaŋe laŋinŋe pilâm kaok bolaŋ bolaŋ olop. ");
INSERT INTO spl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yawu otmu Mose Elea emelâk Anitâŋe meyelehop yaŋe in yawu tetem kinmutâ ");
INSERT INTO spl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","himbimâmbâ laŋinŋaŋe siliŋ siliŋ sâm hâuyelekmu yâk orop den alahuwi. Yawu otmâ Yesuŋe Yerusalem kapiân ari Anitâŋe yâkât mâtâp sâm kalop ya lâumu Yura papatolipyeŋaŋe kuŋetâ mumbuap yakât ekyotgop. ");
INSERT INTO spl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mose yet Elea tetemutâ den otbi yan hoŋ bawalipŋaŋe aman pâlâmŋe iwi. Yâhâ Mose yet Eleaŋe Yesu pilâm arire sâm otmutâ kâlâwahom yahatmâ yekbi. Yekŋetâ Petorohât hanŋe tâlâhumu yuwu sâm Yesu ekuop. “Lok pato, kulem teteap yuwuya âlâ ki ekmain. Yu ekmunŋe âlâ kândâkdâ oap. Yawu gârâmâ gâŋe sârâ selep kalimbu tuhunehât naŋgan. Gâhât âlâ, Mosehât âlâ, Eleahât âlâ.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Otmu Mose yet Elia Yesu pilâm arire sâm otmutâ Petoroŋe kulem yakât topŋe ki nâŋgâmâk Yesu yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yawu sâmu yanâk elem patoŋe ge pumŋe ya mem kâtâpgumu kiŋgityeŋahât otbi. ");
INSERT INTO spl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kiŋgityeŋahât otŋetâ elem yakât biwiŋambâ Anitâŋe den âlâ yuwu sâop. “Bulâŋanâk yuâmâ nine nanne ombe bisine. Nâŋe âi sâm waŋmâ hâŋgângumune giop. Yakât otmâ den sâwuap ya yeŋe mem biwiyeŋan katmâ tem lâuwaŋgim mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Den ya sâm tiŋ pilâmu Yesu ikŋeâk kinmu ekbi. Yâhâ hoŋ bawalipŋaŋe kulem ya ekbi yakât ki sâm tetem bukulipyeŋe ekyongowi. ");
INSERT INTO spl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Emet haŋ sâmu pumŋehembâ geŋetâ lohimbi kiŋgitŋe orowâkŋe ari mem teteyekbi. ");
INSERT INTO spl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mem teteyekŋetâ hohetyeŋambâ lok âlâŋe halahum yuwu sâm Yesu ekuop. “Lok pato, gawot. Nine nanne ombe bisine yu gam ek. ");
INSERT INTO spl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yakât topŋe yuwu. Weke bâleŋaŋe pârâk sânsânâk mâŋgâemu senŋe gâwâŋ gâwâŋ sâm hânân ge imu nekamŋe kâtiŋ sâm lauŋe barak barak otmu halahumap. Weke bâleŋe yaŋe haoŋmâ ârândâŋ yawu mâŋgâemap. ");
INSERT INTO spl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yawuhât hoŋ bawalipgaŋe watŋet sâm dâim taka ekyongomune pâpgum pilai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yawu sâmu Yesuŋe olelem hoŋ bawalipŋe yekmâ yuwu sâm ekyongop. “Yen orop sâp kâlep manmâ gain. Yamâ wongât nâhâitŋe ki tânnongowuap yawu naŋgai? Yawu nâŋgâm biwiyeŋaŋe nâhâlen tiŋâk ki kepeiai yakât nâŋgâmune ki ârândâŋ oap. Yawu gârâmâ hâmbâi nâŋe pilâyekmâ yâhâwom yan yeŋe girawu mannomai?” Yawu sâm ekyongom âwâŋe ekumu nanŋe ya dâim Yesuhâlen baop. ");
INSERT INTO spl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dâim bamu weke bâleŋaŋe mâŋgâemu senŋe gâwâŋ gâwâŋ sâm hânân ge kârâŋ kârâŋ sâm lauŋe barak barak otmâ iop. Yawu otmuâmâ Yesuŋe weke bâleŋe ya watmu gaiakmâ arimu âlepŋe otmâ âwâŋahâlen ba kinop. ");
INSERT INTO spl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yâhâ Yesuŋe kulem miop yan Anitâhât wâtŋe tetemu ekŋetâ ewe membe olop. (Mataio 17:22-23 Mareko 9:30-32) Yesu kulem miop ya ekŋetâ ewe membe olop sâp yan hoŋ bawalipŋe yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Den yuwu sâm ekyongomune nâŋgâm biwiyeŋan katmâ mannomai. Anitâŋe nâ lok bulâŋe hâŋgânnohomu ge mansan. Nâhât kasalipnaŋe sâp ki kâlep otmuâk meneknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yawu sâm ekyongowâke yamâ Anitâŋe nâŋgân nâŋgânyeŋe mem kopa tuhuyekmu nâŋgâŋetâ ki keterahop. Yakât otmâ âikune sâm otŋetâ umatŋe otmu pilâwi. ");
INSERT INTO spl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sâp âlâen Yesuhât hoŋ bawalipŋaŋe osetyeŋan gâtŋe âlâ me âlâŋe kunyeŋe pato otbuap yakât sâm pawarak guwarak otbi. ");
INSERT INTO spl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yawu otmâ sahaŋgiŋetâ Yesuŋe biwiyeŋahât topŋe nâŋgâm yan naom tipiŋe âlâ lâum gotyeŋan katmu kinmu ");
INSERT INTO spl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yuwu sâm ekyongop. “Lok âlâ me âlâŋe tem lâunihim naom tipiŋe yuwuya buku otbaŋginomai. Lohimbi yaŋe naom tipiŋe otbaŋgiain sâm yan nâ buku otnihinomai. Otmu nâ otnihiain sâm Anitâŋe hâŋgânnohomu ge mansan yâk buku otbaŋginomai. Yeŋgâlen gâtŋe âlâ me âlâŋe yeŋahât nâŋgâŋetâ gemu huruŋ huruŋ manmai ya yeŋgât Anitâŋe nâŋgâyiŋgimu yahatmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yawu sâm ekyongomu Yoaneŋe yuwu sâm ekuop. “Lok pato, lok ondowân gâtŋe âlâŋe kutgan gohonmâ weke bâleŋe watyekmu gaiakmâ ariwi ya nenŋe ekmâ nâŋgâm bâlewaŋgim kuwaŋgiwin.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yawu sâmu yuwu sâm ekyongop. “Lohimbi nombotŋaŋe yeŋgât ki nâŋgâŋetâ gemap yaŋe yeŋgât buku manmai. Yakât otmâ lok yawuya ki kuyiŋginomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuŋe himbimân âwurem yâhâwuap yakât sâp tâlâhuop. Yakât otmâ Samaria hân tânâmŋambâ Yerusalem kapiân ariwe sâm biwiŋaŋe nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yawu otmâ Samaria ya yeŋgât kapi âlâen ari inomaihât hoŋ bawalipŋe nombotŋaŋe kulet sâm ari emet âlâ mem heŋgeŋguŋet sâm hâŋgânyongomu ariwi. ");
INSERT INTO spl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ari kapi ambolipŋe ya ekyongoŋetâ Yesu Yerusalem kapiân ariwuap yawu nâŋgâmâmâ emetyeŋe alitbi. ");
INSERT INTO spl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Emetyeŋe alitŋetâ hoŋ bawayâhâtŋe yâhâp, Yakowo yet Yoane, yakât nâŋgâmutâ bâlemu yetŋe eŋgatyetŋeâk otmâ Yesu yuwu sâm âikuowot. “Lok pato, nâŋgânitgirâ sâmutŋe himbimâmbâ kâlâp punduŋ sâm ge seyehâk.” ");
INSERT INTO spl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Yawu sâmutâ kuyitgimu kapi ya pilâm âlâengen ariwi. ");
INSERT INTO spl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mâtâwân arim tatŋetâ lok âlâŋe mem teteyekmâ Yesu yuwu sâm ekuop. “Gâ yuken yaken otbuat yamâ nâ orowâk.” ");
INSERT INTO spl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sâmu sâop. “Nine topne hâum pâpguatgât yuwu sâmune nâŋgârâ keterahâk. Soŋgoâmâ nak duwiŋan imai. Yâhâ nâiâmâ nak kakŋan kerem tatmai. Yâhâ nâmâ Anitâŋe hâŋgânnohomu ge mansan yamâ emet âlâ ki tatnihiap. Yakât otmâ gâ orowâk arinom otmuâmâ girawu otnom?” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesuŋe lok âlâ mem tetem yuwu sâm ekuop. “Nâhâlen torokatdâ orowâk mandehât naŋgan.” Sâmu sâop. “Lok pato, awoŋ âun bâleap. Yakât otmâ nâŋgânihirâ ari awoŋne kurihiwe. Kurihim âwurem gamune orowâk arirom.” ");
INSERT INTO spl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sâmu sâop. “Lohimbi biwi pâlâmŋe manmâ Anitâhât den ki lâum manmaiŋe hanguŋet. Gâŋeâmâ katyekmâ taka Anitâhât den pat âlepŋe lohimbi ekyongowuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yâhâ lok âlâŋe Yesu yuwu sâm ekuop. “Lok pato, gâ orowâk arirehât naŋgan. Yawu gârâmâ nâŋgânihirâ hep torehenlipne yeŋgâlen âwurem arimune iseaŋgim katyekmâ âwurem gamune arirom.” ");
INSERT INTO spl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sâmu sâop. “Den yat yakât matŋe den âlâen hâum yuwu sâmune nâŋgâ. Lok âlâ me âlâŋe nâhâlen torokatne sâm hep torehenlipyeŋe katyekŋetâ kinŋetâ waŋgaen yâhânomai. Yawu otmâ tepyeŋe nâŋgâyiŋgim purik sâm âwurem ari yekne sâm otnomaiŋe nâhâlen torokatŋetâ âi sâm yiŋgiwomgât dop ki tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sâp yakât kakŋan Yesu Kutdânenŋaŋe lok 72 mem sâlipyongop. Yawu otmâ lok yâhâp yâhâwâk menduhuakmâ kulet sâwaŋgim mâtâp mewaŋginomaihât âi sâm yiŋgim hâŋgânyongop. ");
INSERT INTO spl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Den âlâen hâum yuwu sâm ekyongom hâŋgânyongop. “Kâlâmân sot pato tap. Yâhâ Anitâŋe nep lok katyekmu mem hâwurum kinsaiâkâ yamâ ki dopŋan oap. Yakât otmâ Anitâŋe lok âlâkuâk katyehâkgât ulitgum mannomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Otmu hoŋ bawalipŋaŋe topyeŋe naŋgaŋgiŋetgât den âlâen hâum yuwu sâm ekyongop. “Lama yamâ pâlâmŋe kinmai. Yâhâ sosoŋeâmâ sâtŋe bâleŋe tatmai. Yawu gârâmâ lama yaŋe dâiakmâ arinomai yamâ sosoŋe yiŋgim neyekbuap. Dop yawuâk nâŋe hâŋgânyongomune sâtŋe metŋe kâlehen arinomai. ");
INSERT INTO spl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hâŋgânyongomune arinomai yan bât barahâk arinomai. Itâkat ki goleaknomai. Me kâi katipŋe katnomai yakât houŋe âlâ ki menomai. Me tewetsenŋe hâkyeŋan ki tatbuap. ");
INSERT INTO spl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Otmu kapi wosapâ arine sâm otnomai yan mâtâwân lok orop den kâlep ki huhunomai. Inâk tâŋ tâŋâk kapiân arinomai. Otmu kapi ambolipŋe âlâ me âlâŋe emelan dâim yâhâ katyekŋetâ yan yuwu sânomai. “Anitâŋe tihityeŋe otmu yâkât wâtŋan kinmâ yâhâm heroŋe kakŋan mannomai.” ");
INSERT INTO spl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","7","Yawu sâm ekyongoŋetâ heroŋe otyiŋginomai otmuâmâ yan tatmâ nâhât den pat âlepŋe kâsikum yiŋgiŋetâ nâŋgâm yanâmâ bulâŋe yâk yeŋgâlen tetewuap. Yâhâ kapi ambolipŋaŋe buku otyiŋginomai yakât nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Lok âlâ me âlâ nep sâm yiŋgiŋetâ tuhumai yakât hâmeŋe meŋetâ ârândâŋ otmap. Yakât otmâ kapi ambolipŋaŋe yen buku otyiŋgim sot um yiŋginomai otmuâmâ kapi yan tatnomai. Yâhâ nombotŋaŋe denyeŋe nâŋgâŋetâ nahat otmu betyiŋginomai otmuâmâ yengu yawuâk betyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yâhâ kapi âlâen ari den ekyongoŋetâ nâŋgâŋetâ bulâŋe otmu buku otyiŋginomai otmuâmâ ");
INSERT INTO spl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","yan tatmâ lohimbi kundat otnomai ya mem heŋgemyongonomai. Yawu otmâ Anitâhâlen biwiyeŋaŋe kepeiŋetâ tihityeŋe otbuapgât den pat âlepŋe ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yâhâ kapi âlâen ari den ekyongoŋetâ nâŋgâŋetâ nahat otmu betyiŋginomai otmuâmâ hâmbâi Anitâŋe matŋe umatŋeâk yiŋgiwuap. Yakât otmâ kapiân ari lohimbi senyeŋan kinmâ yuwu sâm ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Anitâŋe tihityeŋe otbe sâm oap. Yamâ yeŋe yâkât hâkâŋ otmâ betbaŋgiai. Yakât otmâ kâinenŋan wahap me bokosok me yu ya horatsap yamâ tâlim gik beretek memunŋe gemu betyiŋgim arinom.” Yawu sâm ekyongom pilâyekmâ ariŋetâ towat ya ekmâ kâi katsap yawu nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kapi ambolipŋaŋe orotmemeyeŋe bâleŋe ya ki betbaŋgim Anitâhâlen biwiyeŋe katsai ya yeŋgât yuwu sâmune nâŋgâŋet. Sâp patoen Sotom kapi ambolipŋaŋe orotmemeyeŋe bâleŋe otminiwi yakât matŋe menomai. Otmu yen gurâ yawuâk orotmeme bâleŋe torokatmâ otmâ mansai. Yakât otmâ yeŋeâmâ Sotom ambolipŋaŋe matŋe menomai ya wangim matŋe umatŋe pato hâliliŋe menomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Lohimbiŋe orotmemeyeŋe bâleŋe ki pilâm Anitâhâlen biwiyeŋaŋe kepeim manbi. Yakât otmâ Yesuŋe sârekyongom yuwu sâm ekyongop. “Maiŋ, Korasin otmu Besaita kapi ambolipŋe yeŋgât sâwe. Yeŋgâlen kulem topŋe topŋe mem gamune ekŋetâ tâŋât otmap. Yamâ emelâk embâŋân Tiro Siron kapi ambolipŋaŋe kulem yawu ya ekbi mâne orotmeme bâleŋe otmâ gawi ya betbaŋgim Anitâhâlen biwiyeŋaŋe kepeimbâi. ");
INSERT INTO spl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yawu gârâmâ yeŋe orotmeme bâleŋe otmâ mansai ya ki pilâm Anitâhâlen biwiyeŋe katsai. Yakât otmâ hâmbâi Tiro Siron kapi ambolipŋaŋe matŋe umatŋe menomai ya wangim yeŋe umatŋe amokŋan menomai. ");
INSERT INTO spl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Otmu Kapanaum kapi ambolipŋe yeŋgât sâwe. Yen gurâ yeŋahâlâk nâŋgâŋetâ yahatmu hâkyeŋe mepaeakmâ yuwu sâmai. “Nenâmâ emelâk Anitâŋe himbimgât pat kuningimu mansain’” Yawu sâmaiâke yamâ yuwu sâmune nâŋgâŋet. Yeŋe orotmemeyeŋe bâleŋe ya ki betbaŋgim Anitâhâlen biwiyeŋe katsai. Yakât otmâ yenâmâ hemgât pat mansai. Hâmbâi mâne Anitâŋe yakât matŋe umatŋe pato hâliliŋe yiŋgimu menomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ya yeŋgât yawu sâm hoŋ bawalipŋe yuwu sâm ekyongop. “Den ekyongoan yu nine den bia. Yu Anitâŋe sâm nihiop ya ekyongoan. Yakât otmâ lohimbiŋe denyeŋe nâŋgânomai yan yeŋgât den naŋgain sâm nâhât den nâŋgânomai. Yâhâ lohimbiŋe denyeŋe nâŋgâŋetâ nahat otbuap yan yeŋgât den nâŋgâmunŋe nahat oap sâm nâhât den nâŋgâŋetâ nahat otbuap. Otmu lohimbiŋe nâhât den nâŋgâŋetâ nahat otbuap yamâ Anitâŋe hâŋgânnohomu gewan yâkât den nâŋgâŋetâ nahat otbuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Lok 72 âi sâm yiŋgim hâŋgânyongomu ariwi yaŋe âwurem taka otbi mewi yakât heroŋe nâŋgâwaŋgim Yesu yuwu sâm ekuwi. “Kutdâ, kutgan gohonmâ weke bâleŋe watyekmunŋe gaiakmâ ariwi yakât nâŋgâmunŋe âlâ kândâkdâ oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sâŋetâ sâop. “Yeŋe ari weke bâleŋe watyekbi yan hâkne katmâ nâŋgâwan. Yawu otmâ belek sâmu ekmain yakât dopŋeâk Satanŋe himbimâmbâ ge kumu ekban. ");
INSERT INTO spl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yakât otmâ yuwu sâmune nâŋgâŋet. Soroŋ hambeŋe me sâtŋe metŋe kakŋan tâliŋetâ yan hilipyongomap sâm mâmâŋe otyiŋgim yâhâwom. Otmu nâhât sâtgât otmâ weke bâleŋe me yu ya lohimbi mâŋgâeyekmai ya sâyiŋgiŋetâ yeŋgât tem lâuyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yawu gârâmâ weke bâleŋaŋe yeŋgât tem lâuyiŋginomai yakât nâŋgâm Anitâ mepaenomai. Yâhâ Anitâŋe himbimân tatmâ kutyeŋe nâŋgâm manman kârikŋahât pat kuyiŋgimu tap yakât otmâ Anitâhât nâŋgâm heroŋe pato otbaŋginomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yawu sâm ekyongop sâp yanâk Anitâhât Wâtgât mâmâŋahât Heakŋe biwiŋan gemu biwi hero pato nâŋgâm Anitâ yuwu sâm mepaeop. “Awoŋ, hân himbim kândikyotgon amboŋe, gâhât tep âlep pato nâŋgâhihian. Otmu lok nombotŋaŋe gâhât topge nâŋgâne sâm nâŋgân nâŋgân emetŋan yâhâwi. Parisaio otmu Sarukaio lok yawuya. Yawu gârâmâ nâŋe gâhât den lâum manmâ gan yakât dopŋeâk yâkŋe lâum manmâ gai mâne ârândâŋ otbâp. Yakât topŋe nâŋgâmaihât gâŋe nâŋgân nâŋgânyeŋe ki mem heweweŋ tuhuyiŋgimat. Yawu gârâmâ lok nombotŋe, kutyeŋe bia, belângen manmai yaŋeâmâ topne nâŋgâŋetgât gâŋe nâŋgân nâŋgânyeŋe mem heweweŋ tuhuyiŋgimat. Gâŋe nâŋgâmat, yawuâk tetemap. Yakât mepaeheksan.” Yawu sâm âwâŋe ekuop. ");
INSERT INTO spl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Âwâŋe yawu sâm ekum tiŋ pilâm benŋe lok 72 âwurem takawi ya yuwu sâm ekyongop. “Himbim amboŋe tatmap yâhâmâ awoŋne. Yâkŋe mâmâŋe otnihimu wuân me wuân otbomgât dop tap. Otmu nâŋe awoŋnahât topŋe nâŋgâwaŋgim heŋgeŋguan. Yawu gârâmâ lohimbi nombotŋaŋe awoŋnahât topŋe nâŋgâŋet sâm ekyongowom yaŋe nâŋgâwaŋgim heŋgeŋgunomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Yawu sâm ekyongom katyekmu ariŋetâ hoŋ bawalipŋe kâiân yâhâp yuwu sâm ekyongop. “Emelâk embâŋân Anitâhât poropete lok otmu lohimbi nombotŋe yâkât tem lâum manbi yaŋe kulem nâŋe mem mansan yu ekne sâm yakât mambotmâ gam inâk muwi. Otmu yakât dopŋeâk yâkŋe himbimgât den pat nâŋe ekyongom mansan yu nâŋgâne sâm mambotmâ gam inâk muwi. Yakât otmâ den yuwu sâmune nâŋgâŋet. Yeŋeâmâ sâp yiwereŋe yu nâ orowâk manmâ gam kulem topŋe topŋe memune ekmâ nâhât den nâŋgâm heroŋe kakŋan mansai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mosehât girem den kâsikum yiŋgiminiopŋe Yesuhâlen ariop. Ari Yesuŋe den sâm hilipgumu pâi emetŋan katŋetâ talâkgât yuwu sâm âikuop. “Lok pato, sârâ nâŋgâwe. Nâŋe girawu otmune ârândâŋ otmu yanâmâ Anitâŋe manman kârikŋahât pat kunihiwuap?” ");
INSERT INTO spl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sâmu sâop. “Moseŋe girem den kulemguop ya sârâ nâŋgâwe.” ");
INSERT INTO spl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sâmu sâop. “Anitâŋe girem den âlâ Mose ekumu kulemguop ya yuwu tap. “Isirae ambolipŋe yen ekyongomune nâŋgâŋet. Nengât Kutdânenŋe yamâ Anitâ ikŋe konok tatmap. Nenŋe yâkâlen biwi nâŋgân nâŋgânnenŋaŋe kepeim yâk konok mepaenom. Otmu yâkât lau konok nâŋgâm tem lâuwaŋgim mannom. Otmu mâtâp sâm ningiop ya tâŋ tâŋâk watmâ yâhânom.” Yawu tap. Yâhâ den âlâmâ yuwu tap. “Nenŋahât naŋgaŋgimunŋe yahatmap yakât dopŋeâk buku nombotŋe yeŋgât nâŋgâmunŋe yahatbuap.” Yawu tap.” ");
INSERT INTO spl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sâmu sâop. “Âlepŋe yat. Yawu otmâ manmâ yâhâwuat otmuâmâ Anitâŋe manman kârikŋahât pat kuhihiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yawu sâmu lok yaŋe irelakmâ yuwu sâm ekuop. “Nâ bukune âlâ?” ");
INSERT INTO spl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yawu sâmu Yesuŋe den âlâen hâum yuwu sâm ekuop. “Yura lok âlâ Yerusalem kapi pilâm Yeriko kapiângen ariop. Mâtâwân arim tatmu kasalipŋaŋe mem tetem kum panŋetâ ge iop. Ge imu senŋe âlâlâŋe ya kombo mewaŋgim pilâm ariwi. Pilâm ariŋetâmâ mumbe sâm olop. ");
INSERT INTO spl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mumbe sâm otmu Anitâhât hotom umai ya yeŋgâlen gâtŋe âlâŋe mâtâp yawuâk ari ekmâ lauŋe butelim inâk wangim ariop. ");
INSERT INTO spl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Otmu opon kâmbukŋahât hoŋ bawa âlâ, Lewi senâmbâ gâtŋaŋe mâtâp yawuâk ari mem tetem gotŋan bam ekmâ biwi pâlâmŋe otmâ ariop. ");
INSERT INTO spl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yâhâ Yura lohimbiŋe Samaria lohimbi ya yeŋgât nâŋgâŋetâ gemu betyiŋgimai. Yawu otyiŋgimaiâkâ yamâ Samaria gâtŋe lok âlâ mâtâp yawuâk ari Yura lok ya mem teteop. ");
INSERT INTO spl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ekmâ tepŋe nâŋgâm gotŋan bam hepŋe piriwaŋgim, marasin mem lâwâlem sâhâwaŋgiop. Otmu lok ya lâum ikŋe doŋgi kakŋan katmâ mem kapiân ari lombaŋe emet iminiwi yan katmu tatmu omoŋ konok galemguop. ");
INSERT INTO spl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yâhâ emet haŋ sâmu ariwe sâm otmâ emet yakât amboŋe tewetsenŋe waŋmâ yuwu sâm ekuop. “Tihitŋe otmâ mandâ tewetsenŋe gihian yu ekdâ ki ârândâŋ otbuap otmuâmâ hâmbâi âwurem takawom yan eknohorâ âlâ gihiwom.” Yawu sâm ariop. ");
INSERT INTO spl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Otmu yakât âihohowe. Lok kalimbu ya yeŋgâlen gâtŋe girawu yaŋe buku otbaŋgiop naŋgat?” ");
INSERT INTO spl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sâmu sâop. “Samaria gâtŋe lok yaŋe tepŋe nâŋgâwaŋgim tihitŋe olop ya.” Sâmu sâop. “Bukulipge tânyongomat dop yawuâk kasalipge tânyongowuat. Yawu.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yawu sâm ekum Yesuŋe hoŋ bawalipŋe meyekmu lohimbi katyekmâ kapi âlâen ariwi. Kapi ariwi yan imbi âlâ, kutŋe Mata sâm, gariŋeit manowot. Yâkŋe Yesu otmu hoŋ bawalipŋe dâiyekmu emetyetŋan yâhâwi. ");
INSERT INTO spl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yâhâ tatŋetâ gariŋe, kutŋe Maria sâm, yâkŋe Kutdâhât gotŋan ba tatmu den kâsikum waŋop. ");
INSERT INTO spl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yâhâ Mataŋe ikŋiâk sot uyiŋgimu gariŋaŋe ki tânguop. Yakât nâŋgâm bâlewaŋgim sâop. “Kutdâ, garineâmâ konam. Nâ niniâk sot uan. Yakât nâŋgâmune bâleap. Ekurâ tânnohoâkgât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sâmu sâop. “Mata, gâ wahap tâŋât yakât nâŋgârâ yahatsap. ");
INSERT INTO spl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Garihaŋeâmâ nâhât den nâŋgâwe sâm otmu yakât nâŋgâmune âlepŋe oap. Yakât otmâ den âlâ ki sâwe. Pesuk yap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sâp âlâen Yesuŋe Anitâ ulitgum talop. Ulitgum tiŋ pilâmu hoŋ bawaŋe âlâŋe gotŋan ba yuwu sâm ekuop. “Kutdâ den âlâ ekgohowe. Yoanehât hoŋ bawalipŋaŋe wuân me wuângât sâm Anitâ ulitgunomai yakât topŋe ekyongop yawuâk eknongorâ nâŋgâne.” ");
INSERT INTO spl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yawu sâmu yuwu sâm ekyongop. “Anitâ yuwu sâm ulitgunomai. “Himbim awoŋnenŋe, topge âlâ kândâkdâek tap. Yakât nâŋgâm mepaehekmâ mannom. Gike sâtgât otmâ aŋelolipgaŋe haoŋmâ ârândâŋ hoŋ bahihimai yawuâk nenŋe gurâ tem lâuhihim mannom. ");
INSERT INTO spl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Otmu gâŋe hilâm ârândâŋ tihitnenŋe otmâ dopnenŋanâk ningimat. ");
INSERT INTO spl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Otmu lohimbi nombotŋaŋe mem bâlenenekmâ tai ya yeŋgât nâŋgâm umam sâyiŋgim tosayeŋe pilâyiŋgimain yakât dopŋeâk gâŋe umam sâningim tosanenŋe pilâningiwuat. Otmu Satanŋe kendâningimu otmunŋe bâlemap sâm ulitgohoaingât mâtâp meningi.” Yeŋe yawu sâm Anitâ ulitgum mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Otmu den âlâen hâum yuwu sâm ekyongop. “Omoŋ derep kâmbukŋan yeŋgâlen gâtŋe âlâ me âlâŋe bukuyeŋahât emet hawiŋan ari kinmâ kotok kunmâ yuwu sâm ekunomai. “O bukune, sâmune nâŋgâ. Lomba âlâ nâhât emelan taka tap. Nâ emetnan sot ki tap. Yakât otmâ sot kâsikum nihirâ mem ari um waŋmune niâk.” ");
INSERT INTO spl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yawu sâmu emetŋanâk tatmâ yuwu sâwuap. “Girawu otmâ omoŋ derep kâmbukŋan mândeneneksat? Emet gahatŋe emelâk maŋguain. Gârâmâ yahatmâ ki mem gihiwom.” Yawu sâm ekuwuap. ");
INSERT INTO spl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yâhâ bukuŋaŋe emelanâk tatmâ sot ki waŋbuap otmuâmâ den otmâ dewaemu yahatmâ sot ya ihilâk waŋbuap. ");
INSERT INTO spl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yakât yuwu sâmune nâŋgâŋet. “Yeŋe wuân me wuângât nâŋgâm Anitâhâlen biwiyeŋaŋe kepeim ulitguŋetâ âlepŋe nâŋgâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Otmu âlâen hâum sâwe. Yeŋe buku âlâhât emelan yâhâne sâm, “Wâe tat me?” sâŋetâ nâŋgâyiŋgimu yanâmâ emet kâlehen yâhânomai. Yakât dopŋeâk Anitâ ulitguŋetâ nâŋgâyiŋgiwuap. Anitâhâlen biwiyeŋaŋe kepeim ulitgumai yamâ âlepŋe nâŋgâyiŋgiwuap. Otmu pâin guin otmai yamâ âlepŋe ikŋak mâmâŋe otyiŋgimu biwiyeŋe sânduk sâwuap. ");
INSERT INTO spl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","Otmu den âlâen hâum sâmune nâŋgâŋet. Yeŋgâlen gâtŋe âlâ me âlâhât nanŋaŋe po waŋgimu âwâŋe ulitgumu yan âwâŋaŋe ki neneŋe ya waŋbuapgât dop ki tap. ");
INSERT INTO spl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Otmu yen nombotŋe Anitâhât topŋe ki nâŋgâm heŋgeŋgumaiŋe nan baralipyeŋe yawu otyiŋgimai. Anitâ awoŋnenŋe himbimân tatmapŋe nen ikŋiâk ikŋiâk topnenŋe ekmâ nâŋgâmap. Yakât otmâ lok âlâ me âlâŋe Wâtgât mâmâŋahât Heakŋe mâmâŋe otyiŋgiâkgât Anitâ ulitgunomai yan yeŋe nan baralipyeŋe otyiŋgimai ya wangim tâŋ tâŋâk yiŋgiwuap. Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Weke bâleŋaŋe lok âlâ mâŋgâemu lauŋe maŋguakmu den biaek manmâ gaop. Otmu Yesuŋe weke bâleŋe ya watmu gaiakmâ arimu lauŋe hâreakmu den olop. Yawu otmu lohimbi yan kinbiŋe ekŋetâ sâtŋe olop. ");
INSERT INTO spl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yawu gârâmâ Parisaio lok nombotŋaŋe ekmâ Yesu nâŋgâm bâlewaŋgim yuwu sâwi. “Yâkât topŋeâmâ yuwu. Yâhâmâ weke bâleŋaŋe mâmâŋe otbaŋgiap. Yakât otmâ ya yeŋgât patoyeŋe, kutŋe Besewulu sâm, kutŋe âlâmâ Satan yâkât wâtŋan kinmâ watyekmap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yâhâ Yesuŋe otmâ hilipgumu mem pâi emetŋan katŋetâ talâkgât nombotŋaŋeâmâ topyeŋe kurihiakmâ yuwu sâwi. “Anitâŋe nâŋgâhihimap otmuâmâ sârâ kulem âlâ himbimâmbâ tetemu ekmâ topge nâŋgânom.” ");
INSERT INTO spl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yawu sâŋetâ Yesuŋe biwiyeŋahât topŋe ekmâ nâŋgâm yuwu sâm ekyongop. “Yeŋe nâŋgâm tâpikguai. Yakât otmâ den âlâen hâum yuwu sâmune nâŋgâŋet. Lok komot konohâk mansaiŋe yahatmâ ahom hioŋakmâ tiok taok otnomai yamâ kutyeŋe biatbuap. Yâhâ kapi âlâ konohâk tatmaiŋe yeŋahâk yahatmâ ahom hioŋaknomai yamâ kâwurumyeŋeâk kinbuap. ");
INSERT INTO spl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yakât den âlâ torokatmâ sâwe. “Besewuluŋe mâmâŋe otnihimu weke bâleŋe watyekmune gaiakmâ arimai,” yawu sâmai. Yawu gârâmâ Satangât komotyeŋahâk ahom hioŋaknomai yamâ den ekyongoan yuwuâk tetemu Satangât kutŋe biatbâp. ");
INSERT INTO spl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","20","Nâmâ Anitâhât wâtŋan kinmâ weke bâleŋe watyekmâ yan amboyeŋe Satan ya mem ge katsan. Yakât otmâ âlâku yu torokatmâ sâwe. Yeŋe imbiâk nâhâitŋe Satangât wâtŋan kinmâ weke bâleŋe watyeksap yawu nâŋgâmai. Yakât nâŋe yuwu sâm purik pilâmune nâŋgâŋet. Yeŋe âlâhât wâtŋan kinmâ weke bâleŋe watyeksai? Yeŋe “Anitâhât wâtŋan kinsain” yawu sâmai. Girawu otmuâmâ nâhât yawuâk ki nâŋgâmai? Yeŋe nâhât nâŋgâm tâpikgumai, yawu naŋgan. Yawu gârâmâ Anitâŋe tihityeŋe otmâ wawaeyekmâ nâ hâŋgânnohomu ge âi yu mem mansan.” ");
INSERT INTO spl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Otmu torokatmâ yuwu sâmune nâŋgâŋet. Nine topne teteâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Lok âlâŋe hâmbâŋe mem haŋgalakmâ tembe talam lâuakmâ yâhâm gem senŋe âlâlâŋe galemgumu âiloŋgo tatbaŋgimap. ");
INSERT INTO spl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yawu gârâmâ kasaŋe lok sâtŋe kârikŋaŋe taka kum itit kiom bâleŋe tuhuwaŋgiwuap otmuâmâ yâkât tembe talam, kapamgât senŋe âlâlâ, iri sikum, ya kerek mewaŋgim ariwuap. Yakât dopŋeâk nâŋe weke bâleŋe amboyeŋe, Satan, mem ge katbom. ");
INSERT INTO spl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yakât otmâ yuwu sâmune nâŋgâŋet. Lok buku ki otnihimaiŋeâmâ kasa otnihimai. Yâhâ lok âlâ me âlâŋe ki tânnohomaiŋeâmâ mâtâp maŋgunihimai dop yawu otmap. Yawu.” ");
INSERT INTO spl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesuŋe den âlâ yuwu sâm ekyongop. “Nâŋe yeŋgât topyeŋe yu sâm pitiŋgum heŋgeŋgumune nâŋgâŋet. Yeŋe yuwu nâŋgâm tâpikgumai. “Nenŋahâk kuwihakmâ manman âiloŋgo manmâ yâhânom.” Yen yawu nâŋgâm tâpikguai yakât otmâ den âlâen hâum yuwu sâwe. Weke bâleŋaŋe lok âlâ mâŋgâemap ya gaiakmâ emet sondaŋângen ariwuap. Otmu lok ondopgâlen karakmâ mem bâlewe sâm yakât pâinmâ manbuap. Pâinmu biatmu yuwu nâŋgâwuap. “O, emelâk lok âlâ mem mâŋgâeminiwan. Gârâmâ lok yamâ ninahâk gaiakmâ tohowan. Yawu gârâmâ âlâkuâk âwurem ari lok yâkâlenâk karakbom.” ");
INSERT INTO spl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yawu sâm âwurem ari ekmâ yuwu sâwuap. “Bâe, lok yuâmâ heŋgemahom mansap. Nâhât wâtne tipiŋe. Yakât otmâ weke bâleŋe nombotŋe wâtyeŋe pato tap ya ari meyekbom. Ari meyekmune taka orowâk lok yu mâŋgâenom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yawu sâm ari weke bâleŋe bât nombotgen yâhâp ya meyekmu taka lok aŋgoân hâhiwin kakŋan manop yamâ witgum mâŋgâeŋetâ umatŋe dondâ tetewaŋgimu manbuap. Yakât otmâ yuwu sâmune nâŋgâŋet. Yeŋe yeŋahâk heŋgemahom mannomaihât dop âlâ ki tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuŋe den yawu sâm ekyongomu nâŋgâŋetâ lohimbi hohetyeŋan imbi âlâ kinop yaŋe yuwu sâm ekuop. “Den eknongoat ya nâŋgâmune ewe membe oap. Yakât otmâ âi mem mansat ya mâmâhaŋe ekmâ gâhât tepŋe heroŋe nâŋgâhihim mepaehekmâ mansap yawu naŋgan.” ");
INSERT INTO spl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sâmu sâop. “Âlepŋe yat yamâ Anitâhât den nâŋgâŋetâ bulâŋe otmu lâum manmai yaŋeâmâ heroŋe kakŋan mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesuŋe kulem âlâ tuhumu eknehât nâŋgâm lohimbi kiŋgitŋe orowâkŋe Yesuhâlen ari mem hawam mewam tuhuwi. Yawu otŋetâ yuwu sâm ekyongop. “Yeŋe yuwu otŋetâ ekmune bâlemap. Yeŋe biwi yâhâp otmâ kulem witgumâk memune eknehât nâŋgâmai. Yâhâ nâmâ kulem konohâk memune eknomai. Yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","32","Aŋgoân poropete âlâ, kutŋe Yona sâm, yâkâlen kulem âlâ tetemu Niniwe kapi ambolipŋaŋe ekbi. Yakât dopŋeâk nâhâlen kulem âlâ tetemu eknomai. Yakât den âlâ sâwe. Aŋgoânâmâ lok âlâ, kutŋe Solomon sâm, Dawiti nanŋe, ya nâŋgân nâŋgânŋe pato tatbaŋgiop. Otmu yâkât kut patŋe ya emelâk sâm haŋ tuhuŋetâ arimu imbi pato âlâ kapi kâlepŋehen manopŋe nâŋgâop. Nâŋgâm yanâmâ ekbe sâm tohop. Yakât sâmune nâŋgâŋet. Solomongât nâŋgân nâŋgân pato tatbaŋgiop. Yawu gârâmâ nâmâ Solomongât kunŋe mansan. Otmu nâŋe kapi kâlepŋehen ki mansan. Hohetyeŋan manmâ den kâsikum yiŋgim mansan. Yamâ yeŋeâmâ nâhât den nâŋgâŋetâ nahat otmap. Yakât otmâ mem ge katnekne sâm oai. Yakât otmâ hâmbâi sâp patoen imbi pato yaŋeâmâ lok senyeŋan yahatmâ kinmâ yeŋe nâhât den kum mansai yeŋgât topyeŋe sâm tetemu aŋulaknomai. Yawu otŋetâ Anitâŋe yakât matŋe âlâku ikŋeâk ikŋeâk yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Nenŋe emet kâlehen tatmâ lambe saum tuŋguŋan ki katmain. Gârâmâ heleŋân gâitmunŋe kinmâ sem laŋinŋe pilâmu ekmâ gem yâhâmain. ");
INSERT INTO spl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Senyeŋe yamâ lambe laŋinŋe yakât dop oap. Senyeŋe âlepŋe tatmu yanâmâ ekmâ gem yâhâmai. Yâhâ senyeŋe bok sâwuap yanâmâ mâtâp tâpikgum hewukŋan kioŋnomai. ");
INSERT INTO spl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yakât otmâ yuwu sâmune nâŋgâŋet. Biwiyeŋan Anitâhât laŋinŋaŋe pilâmap ya bok sâmapgât biwi nâŋgân nâŋgânyeŋe galemahom manman âlepŋeâk manmâ yâhânomai. ");
INSERT INTO spl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yawu manmâ yâhânomai yanâmâ lambeŋe sem laŋinŋe pilâmu emet biwiŋe haŋ sâmu ekmâ tatmai yakât dop otbuap. ");
INSERT INTO spl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Den yawu sâm tiŋ pilâmu Parisaio âlâŋe Yesu dâim emetŋan yâhâop. Yan yâhâ Parisaio otmu Mosehât girem den kâsikum yiŋgiminiwi yâk orop sot newi. ");
INSERT INTO spl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yawu gârâmâ aŋgoân Yesuŋe bâtŋe ki piriahop. Sot ya inâk mem nemu ekŋetâ sâtŋe otmu pârâk pilâwi. ");
INSERT INTO spl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pârâk pilâŋetâ Yesuŋe yuwu sâm ekyongop. “Parisaio yeŋgât topyeŋe teteâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Imbi âlâŋe amaŋ mem hâkŋeâk pirimu biwiŋan sot wahapŋe yawuâk tatbuap. Yakât dopŋeâk yeŋe bukulipyeŋaŋe yekŋetâ yahalâkgât hâkyeŋeâk piriakmai. Yawu gârâmâ manman bâleŋe, me orotmemeyeŋe kiŋgoŋ ya biwiyeŋaŋe nâŋgâmai. Yawu nâŋgâŋetâ yaŋe mem bâleŋe tuhuyekmap. ");
INSERT INTO spl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yeŋgât topyeŋe yawu tap yamâ ki eŋakmâ naŋgaŋgimai. Anitâŋe lohimbi kândikyotgop yan hâkyetŋe biwiyetŋe yâhâp yâhâp ya katyitgiop. ");
INSERT INTO spl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yakât otmâ aŋgoân yeŋe biwi nâŋgân nâŋgânyeŋe ya sâm pitiaknomai. Yawu otnomai yanâmâ hâkgât wahap wuân me wuângât nâŋgâŋetâ tâŋât otbuap. Yâhâ yawu ki otnomai yamâ yiwereŋe umatŋe teteyiŋgim gap yu wangim umatŋe pato teteyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Parisaio yeŋeâmâ nâŋgâm tâpikgumai. Yeŋeâmâ wahap tâŋât, hote, gitâk, wahap yawuya mem ketetmâ bâlâk ŋerek osetyeŋan konok ya mem Anitâhât pat kuwaŋgimai. Yâhâ Anitâhât den ekyongomu kulemguwi yamâ loŋgâemai. Loŋgâem yan yuwu otmâ mansai. Lohimbi yeŋgât den sâm hâreyiŋgimai yan Anitâŋe nâŋgâmu ârândâŋ olâkgât ki nâŋgâmai. Yawu otmâ den tâŋ tâŋâk ki sâm hâreyiŋgimai. Otmu buku nombotŋe yeŋgât weyeŋe ki nâŋgâm tânyongomai. Yakât otmâ hâmbâi Anitâŋe matŋe umatŋe yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yeŋe miti emetŋan yâhâ lohimbi senyeŋan ewanâk tatnehât nâŋgâmai. Otmu lohimbi hawamyongom tatmaiŋe nenekŋetâ yahatmu mepaenenekŋetgât nâŋgâmai. Yawu otmâ manŋetâ ya ekmune bâleap. ");
INSERT INTO spl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Parisaio yeŋgât topyeŋe teteâkgât den âlâen hâum yuwu sâwe. Emelâk lok muŋetâ hanyongowi ya yeŋgât sum kakŋambâ ki nâŋgâmâk bam gamai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yawu sâm ekyongomu Mosehât girem den kâsikum yiŋgiminiwi hohetyeŋan gâtŋe lok âlâŋe yuwu sâm ekuop. “Bawapi, gâŋe Parisaio lok den sâyiŋgiat yaŋe nen gurâ yawuâk meneneksap.” ");
INSERT INTO spl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sâmu sâop. “Nenŋe yeŋgât amutgen manmâ yu ya otnehât den undipŋe topŋe topŋe sâm ningimai. Yamâ yeŋeâmâ denyeŋe ya ki lâum watmai. Den sâm ningiŋetâ umatŋe kakŋan manmain. Yawu manmunŋe biwinenŋe mem huruŋ pilâninginehât ki tânnongomai. Yakât otmâ Anitâŋe matŋe umatŋe yiŋgimu menomai. ");
INSERT INTO spl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yeŋeâmâ yuwu sâmai. “Poropete lok mum gawi ya yeŋgât sumân awu tawu kâmetmunŋe baŋbaŋ sâm sekŋe âlepŋe otmâ imap.” Yawu sâmai. Yamâ yeŋgât tâmbâlipyeŋaŋe poropete lok ya yongoŋetâ muwi. ");
INSERT INTO spl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yakât yuwu sâmune nâŋgâŋet. Tâmbâlipyeŋaŋe poropete yongoŋetâ muwi ya yeŋgât sumân yeŋe awu tawu kâmetmâ galemgumai. Yawu otmâ yongowi yakât nâŋgâŋetâ ârândâŋ oap yawu yeksan. ");
INSERT INTO spl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Otmu pepa âlâ, kutŋe “Anitâhât nâŋgân nâŋgânŋe” sâm, yan den âlâ yuwu kulemguwi tap. “Hoŋ bawalipne nombotŋe âi sâm yiŋgimune yeŋgâlen taka Anitâhât topŋe kâsikum yiŋgim mannomai. Yamâ yeŋe nâhât den pat bialâkgât nombotŋe mem âlâlâ tuhuyeknomai. Yâhâ nombotŋe âlâmâ yongoŋetâ munomai.” Den yawu tap. ");
INSERT INTO spl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yakât yuwu sâwe. Emelâk Anitâŋe ikŋe poropete hâŋgânyongomu denŋe lâum manmâ gawi ya gurâ yawuâk tâmbâlipyeŋaŋe nâŋgâm bâleyiŋgim yongom mem ge katyekbi. Yakât huhopŋe ya yeŋe menomai. Yakât topŋe nâŋgâŋetâ keterahâkgât yuwu sâwe. ");
INSERT INTO spl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Embâŋân topŋe katmâ tâmbâyeŋe lok âlâ, kutŋe Awe sâm, ya ataŋaŋe kumu muop. Otmu poropete âlâ, kutŋe Sekaraia, yamâ opon kâmbukŋan yâhâ hotom um bam gam kinmu yanâk kuŋetâ muop. Yawu gârâmâ Awe kumu muop yapâek manmâ gam poropete kerek yongoŋetâ muwi yakât huhopŋe ya yeŋe menomaiâk. ");
INSERT INTO spl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mosehât girem den kâsikum ningimai yeŋeâmâ Anitâhât den kurihiŋetâ tap. Yeŋeâmâ Anitâhât hâkâŋ otmâ yâkât den nâŋgâm hâum pâpgumai. Yawu otmâ lohimbi nombotŋaŋe yâkât den nâŋgâm tem lâuwaŋgine sâm otmai ya yeŋgât mâtâp maŋguyiŋgimai. Yawu otmai yakât nâŋgâmune bâleap. Yakât otmâ umatŋe topŋe topŋe teteyiŋgiwuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yawu sâm ekyongom emelambâ gem ariop. Sâp yakât kakŋan Parisaio otmu Mosehât girem den kâsikum yiŋgiminiwiŋe Yesuhât nâŋgâm bâlewaŋgim sâm ge katbi. ");
INSERT INTO spl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Otmu den sâm hilipgumu nâŋgâm den âiân katne sâm yu yakât âi pâi tuhum gawi. ");
INSERT INTO spl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Otmu lohimbi kiŋgitŋe orowâkŋe Yesuhât den nâŋgâne sâm taka pâŋ sâwi. Taka pâŋ sâm Yesu hoŋ bawalipŋe mem awawi guwawi tuhuyekbi. Yawu otmâ kinŋetâ Yesuŋe hoŋ bawalipŋe yuwu sâm ekyongop. “Parisaio yâk yeŋgât matuk keluŋaŋe mem bâleyekmapgât galem oraŋgim mannomai. Parisaio yamâ nimbilamyeŋe yâhâp otmâ topyeŋe kurihiakmâ manmai. ");
INSERT INTO spl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yakât otmâ ya yeŋgât den âlâ yuwu sâmune nâŋgâŋet. Tihângen wahap yu me ya otmâ gai. Ya ki tik tatbuap. Hâmbâi tetekŋan tetemu eknom. Yâhâ yu me ya otmâ kurihiakmai. Ya gurâ tetekŋan tetemu eknom. ");
INSERT INTO spl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yakât otmâ yuwu sâmune nâŋgâŋet. Yenâmâ nâ orowâk manmain. Yawu gârâmâ den nombotŋe nenŋiâk tatmâ ekyongoman ya hâmbâi yeŋe lohimbi ekyongoŋetâ nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesuŋe torokatmâ yuwu sâm ekyongop. “Lok senyeŋan kinmâ den ekyongoŋetâ nâŋgâŋetâ nahat otmu yen nombotŋe yongoŋetâ munomai. Yongonomai yamâ umut biwiyeŋe ki hilipgunomai. Lok topnenŋe yawu tap. Yakât otmâ ya yeŋgât ki kiŋgityeŋahât otnomai. ");
INSERT INTO spl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yâhâ Anitâhât topŋeâmâ âlâ tap. Hâmbâi mâne yâkŋe konok umut biwiyeŋe hilipguwuapgât dop tap. Yakât otmâ yeŋe yâkât den konok lâum mannomai. ");
INSERT INTO spl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Otmu yakât âlâ sâwe. Anitâhât den lâum manmain nen haoŋmâ ârândâŋ yâkŋe tihitnenŋe otmap yakât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Giroŋ giroŋ ekmain yamâ nâi tâŋât. Yamâ ki galemgumain. Yawu gârâmâ giroŋ giroŋ âlâ mumbuap yakât topŋe himbim amboŋaŋe emet inânŋan nâŋgâmu tap. ");
INSERT INTO spl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yawu gârâmâ nenâmâ giroŋ giroŋ yakât dop bia. Nenâmâ Anitâ ikŋe kundenŋe towat manmain. Yawu otmâ Anitâŋe topnenŋe kerehâk naŋgap. Somotnenŋe tipi tapi yakât topŋe gurâ nâŋgâmu tawâk. Yâkŋe tihitnenŋe otmap. Yakât nâŋgâm biwi yâhâp ki otmâ manmâ yâhânom. ");
INSERT INTO spl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Lohimbi âlâ me âlâŋe “Yesuhâlen biwinaŋe kepeim tem lâuwaŋgim mansan,” yawu sâm lohimbi ekyongonomai yâhâmâ hâmbâi nâ lok bulâŋaŋe himbim awoŋnahât aŋelolipŋe yeŋgât senyeŋan kinmâ topyeŋe sâm tetemune Anitâŋe manman kârikŋan katyekbuap. ");
INSERT INTO spl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yâhâ lohimbi âlâ me âlâŋe “Nâ Yesu ki nâŋgâwaŋgian,” yawu sânomai otmuâmâ nâku lok bulâŋe himbim awoŋnahât aŋelolipŋe yeŋgât senyeŋan kinmâ “Nâ ki nâŋgâyiŋgian,” yawu sâwom. Lohimbi yawu otmai yaŋe matŋe umatŋe menomai. Yawu. ");
INSERT INTO spl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yakât otmâ den âlâ torokatmâ yuwu sâwe. Anitâŋe âi sâm nihim hâŋgânnohomu gewan. Yawu gârâmâ lok âlâ me âlâŋe nâhât nâŋgâŋetâ tâŋât otbuap. Me nâhât nâŋgâŋetâ giâkgât lohimbi kendâyiŋginomai. Orotmeme yawuya ki witgum mannomai otmuâmâ ya yeŋgât tosa yamâ Anitâŋe pilâyiŋgiwuapgât dop tap. Otmu torokatmâ sâwe. Lok âlâ me âlâŋe Anitâhât Wâtgât mâmâŋahât Heakŋe yu me ya otbuap ya ekmâmâ yuwu mon sâwuap. “Bâe, âi yukât amboŋe yamâ Satan.” Yawu sâm yan âi ya ekmâ Satangâlen gâitbuap. Yawu otmâ yâhânomai ya yeŋgât Anitâŋe pilâyiŋgiwuapgât dop âlâ ki tap. Lok yawuyaŋe tosa pato menomai. ");
INSERT INTO spl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Otmu den âlâ sâmune nâŋgâŋet. Yeŋe galem tiŋâk oraŋgim mannomai. Kasalipyeŋaŋe nâhât den pat âlepŋe nâŋgâŋetâ nahat otmu yen meyekmâ miti emetŋan me kiap yeŋgâlen ari den âiân katyekmâ âi pâi tuhuyeknomai. Yawu otyiŋgiŋetâ “Den mâtâpŋe girawu watmâ sâm ekyongomunŋe nâŋgâŋetâ keterakyiŋgiwuap,” yawu nâŋgâm ki gorâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sâp yanâmâ Awoŋnenŋaŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge den âlâlâ nâŋgân nâŋgânyeŋan katmu nâhât den pat âlepŋe sâm kusânmâ ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Lohimbi kinbi ya yeŋgât hohetyeŋambâ lok âlâŋe Yesu yuwu sâm ekuop. “Lok pato, sâmune nâŋgâ. Awoŋnetŋahât bâtŋe bâiŋe ya atanaŋe ikŋiâk mem alitmâ mansap. Yawu gârâmâ gâŋe ekurâ nombotŋe hioŋmâ nihiâkgât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sâmu sâop. “Nâŋe yet galemyotgom manbehât lok kunnenŋaŋe ki sâm nihiop. Yakât otmâ imbiâk nâhâlen ga den ya eknohoat. ");
INSERT INTO spl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yakât otmâ yuwu sâmune nâŋgâŋet. Senŋe âlâlâ me iri sikum ya Anitâŋe biwinenŋahât ki sâm katningiop. Yamâ hâknenŋahât sâm kalop. Yawuhât bukulipnenŋe iri sikumyeŋe orop manmai ya yekmâ tep bâle ki nâŋgâyiŋginom.” ");
INSERT INTO spl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yawu sâm den âlâen hâum yuwu sâop. “Lok kutdâ âlâhât kalamân siwit kehetŋe pato teteop. ");
INSERT INTO spl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yawu otmu biwiŋaŋe yuwu nâŋgâop. “Siwit kehetŋe pato tap yu mem emet girawuân katmune tatbuap? ");
INSERT INTO spl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yuwu otbom mon? Emet tipiŋe siwit kehetŋe katman ya kândoŋmâ pato tuhum yan siwit kehetŋe katmune tatbuap. ");
INSERT INTO spl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Katmune tatmu yanâmâ hop sambe kakŋan manmâ heroŋe maroŋe nâŋgâm manmâ yâhâwom.” ");
INSERT INTO spl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yawu sâmu Anitâŋe yuwu sâm ekuop. “Gâ kopa. Omoŋdâŋe mumbuat. Yakât otmâ iri sikumge wawaerâ tatgihimap ya lok âlâŋe membuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yâhâ den ekyongoan yukât topŋe yuwu tap. Lohimbiŋe iri sikumyeŋahât tepyeŋe umatŋe otmâ mansai ya yeŋgât Anitâŋe nâŋgâmu bâlemap. Yakât otmâ muŋetâ pesuk sâmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Yawu sâm lohimbi ekyongom benŋe hoŋ bawalipŋe yuwu sâm ekyongop. Senŋe âlâlâ me iri sikumyeŋe yakât ki nâŋgâŋetâ yahatbuap. Manmanyeŋahât bulâŋe yamâ umut biwiyeŋe. Yâhâ yeŋgât manman yamâ Anitâŋe emelâk senŋe âlâlâ lâtâkuyiŋgimu manmai. Yakât otmâ yuwu ki nâŋgânomai. “Nenŋe sot wosapâ ba mem tetenom? Me iri sikum me âlâlâ ya girawu mem tetem manmâ yâhânom.” Yawu ki sâm biwi yâhâp otmâ gorâ kakŋan mannomai. ");
INSERT INTO spl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yawu gârâmâ den âlâen hâum yuwu sâmune nâŋgâŋet. Kembâ ekmain. Yâhâmâ âi kalam ki tuhum hâhiwin nâŋgâmai. Yamâ himbim amboŋaŋe haoŋmâ ârândâŋ sot yiŋgimap. Yenâmâ nâihât dop ki mansai. Yenâmâ lok. Otmu yen gurâ yawuâk Anitâŋe haoŋmâ ârândâŋ tânyongom gamap. ");
INSERT INTO spl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Yawu gârâmâ yeŋahât girawu mannom sâm yakât ki nâŋgâm kiwiliŋ otnomai. Yeŋe wâtyeŋan torokatmâ manmâ yâhânomaihât dop âlâ ki tap. Yawu otnomai yan hâum pâpgunomai. Yakât topŋe yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Hahop ekmain. Hahop yamâ titi pan pan pilâmu ekmunŋe âiloŋgo loŋgo otmap. Yâhâ emelâk lok kutdâ âlâ, kutŋe Solomon sâm, yâkŋe hâk katipŋe kulem melem mânuŋakmâ manop. Yaŋe hahop suriŋe sekŋe âlepŋe tetemap yakât dopŋe ki miop. ");
INSERT INTO spl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yâhâ hahop suriŋe ekmunŋe âiloŋgo otmap. Yawu gârâmâ ikŋahâk ki yahatmâ titi pan pan otmâ kuririŋ sâm kinmap. Anitâŋe nâŋgâopgât yawu kinmap. Yiwereŋeâmâ tetem âiloŋgo kinbuap. Yâhâ pek sâwuap yanâmâ hânân ge tâtuk sâwuap. Yenâmâ hahopgât dop ki mansai. Yenâmâ lok. Yakât otmâ biwiyeŋaŋe yuwu ki nâŋgânomai. “Anitâŋe pâlâmŋe otmâ ki tihitnenŋe otmap.” Yawu ki nâŋgâm mannomai. ");
INSERT INTO spl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yakât yuwu sâmune nâŋgâŋet. Bulâŋanâk Anitâŋe haoŋmâ ârândâŋ tihitnenŋe otmâ yâhâwuap. Yakât biwi yâhâp ki otnomai. ");
INSERT INTO spl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yawu gârâmâ lok nombotŋe Anitâhât topŋe ki nâŋgâmaiŋe sâŋgum me iri sikum me senŋe âlâlâ yakât nâŋgâŋetâ yahatmap. Yawu otŋetâ ki ârândâŋ otmap. Yakât otmâ otmaiân yeŋe ki torokatnomai. ");
INSERT INTO spl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yeŋeâmâ lohimbi nombotŋaŋe Anitâhâlen biwiyeŋaŋe kepeiŋet sâm yâkât den ekyongoŋetâ nâŋgânomai. Yawu otmâ manŋetâ himbim awoŋnenŋe topyeŋe nâŋgâmapŋe dopyeŋan yiŋgimu ki umburuk mannomai. ");
INSERT INTO spl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yakât otmâ yâkâlen biwiyeŋaŋe kepeim ki gorâyiŋgimu mannomai. Awoŋnenŋe Anitâŋe heroŋe nâŋgâyiŋgim tihityeŋe otmâ yâhâmbisâp. Yawu otmâ hâmbâi mâne manman kârikŋan mem katyekmu manmâ yâhâmbisâi. ");
INSERT INTO spl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yakât otmâ senŋe âlâlâ tatyiŋgiap yamâ mem buku nombotŋe ki tatyiŋgiap ya kâsikum tânyongonomai. Yawu otŋetâmâ Anitâŋe yekmu ârândâŋ otbuap. Otmu himbimân mannomaihât pat kuyiŋgiop yakât bulâŋe yiŋgimu menomai. Otmu himbimân manman sânduhân mannomai yan talaŋe ki kumbuap, me seloŋe ki hârewuap, me ki bumbumguwuap, me kombo ki otnomai. ");
INSERT INTO spl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yawuhât Anitâhâlen biwi nâŋgân nâŋgânyeŋaŋe kepeim manŋetâ ârândâŋ otbuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesuŋe den âlâ yuwu sâm ekyongop. “Yen biwi golâ otmâ mannomaihât den âlâen hâum sâmune nâŋgâŋet. Hoŋ bawalipŋe yeŋgât lok kutdâyeŋaŋe kapi kâlepŋehembâ âwurem taka emet hawiŋan kinmâ kotok kunmu nâŋgâm in yawu gahatŋe mewaŋginomai. Yakât otmâ lambeyeŋe saum katŋetâ sem tatmu mambotbaŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yawu otmâ mambotbaŋgim tatnomai yanâmâ âwurem taka mem teteyekmâ heroŋe nâŋgâyiŋgiwuap. Heroŋe nâŋgâyiŋgim itâŋe kâpekmâ katmu tatmu sot um yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yâhâ omoŋ derepŋan kapi ambolipŋe kerekŋe aman pâlâmŋe inomai yanâmâ âwurem takawuap. Taka hoŋ bawalipŋe sen golâ otmâ mambotbaŋgim tatŋetâ mem teteyekbuap otmuâmâ buku otyiŋgiwuap. Buku otyiŋgimu yâkŋe heroŋe nâŋgâwaŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yen biwi golâ otmâ mannomaihât den âlâen hâum sâmune nâŋgâŋet. Kapi âlâ me âlâhât kasalipyeŋaŋe sâp girawuân taka yongom itit kiom tuhuyiŋginomai yakât ki ekyongomai. Inâk pârâk sân sânâk takamaihât kapi ambolipŋaŋe sen galem manmâ emet kapiyeŋe galemgunomai. ");
INSERT INTO spl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yakât dopŋeâk Anitâŋe hâŋgânnohomu âwurem gewom yakât sâp yeŋe ki naŋgai. Yakât otmâ biwi golâ manmâ mambotnihim yâhânomai. Yawu otnomai otmuâmâ âwurem gemune nekmâ heroŋe nâŋgânomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesuŋe yawu sâm ekyongomu Petoroŋe yuwu sâm âikuop. “Kutdâ den âlâen hâum eknongoat yu nengâlâk yat me lok kerek nengât yat?” ");
INSERT INTO spl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yawu sâm âikumu Yesuŋe purik pilâwaŋgim den âlâen hâum yuwu sâm ekuop. “Lok kutdâ âlâŋe kapiŋe pilâm kapi kâlepŋehen ari kandi manmâ âwurem takawuap. Yaken ariwe sâm yan hoŋ bawaŋe âlâ galem sâm katmâ yuwu sâm ekuwuap. “Arimuneâmâ gâŋe nep lok nombotŋe galemyongowuat.” Yawu sâm ekum pilâyekmâ arimu galem yaŋe âi ya biwiŋaŋe mem galemyongomu âiloŋgo mannomai. ");
INSERT INTO spl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yawu otmâ galemyongowuap otmuâmâ patoŋaŋe âwurem taka heroŋe otbaŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yawu otbaŋgim galem pato katmu ikŋe senŋe âlâlâŋe yakât galem otbuap. ");
INSERT INTO spl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yâhâ purik pilâm sâmune nâŋgâŋet. Hoŋ bawa yaŋe biwiŋaŋe yuwu nâŋgâm âi ya hilipguwuap. “O, lok kutdâne arap yuâmâ in yawu ki takawuap. Yamâ sâp kâlep manbuap yakâ. Yakât otmâ wongât nâŋe âi yu membom?” Yawu sâm biwiŋaŋe pâlâmŋe otmu ki galemyongom heŋgeŋguwuap. Yawu manmâ to kârikŋe nem biwi hâlim otmu umatŋe topŋe topŋe teteyiŋgiwuap. Yawu otmâ lok bâleŋe yeŋgâlen torokatmâ ki orotŋe otmâ manbuap. ");
INSERT INTO spl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yawu otmâ biwiŋaŋe pâlâmŋe otmu manbuap yan patoŋaŋe pârâk sân sânâk taka kuk otmâ kum yaehen pilâmu ge hâhiwin nâŋgâm yâhâmbisâp. ");
INSERT INTO spl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yakât topŋe yuwu sâmune nâŋgâŋet. Lohimbi nombotŋaŋe nâhât den nâŋgâm heŋgeŋgunomai yanâmâ yakât nâŋgâŋetâ gemu betbaŋginomai. Yawu otnomai yakât matŋe Anitâŋe matŋe amokŋan yiŋgimu menomai. ");
INSERT INTO spl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yâhâ lohimbi nombotŋe âlâŋeâmâ nâhât den nâŋgâm pâpgumai yaŋe otŋetâ bâlemap yâhâmâ Anitâŋe matŋe kakŋeâk yiŋgimu menomai. Yakât otmu yuwu sâmune nâŋgâ. Lok âlâ me âlâ âi sâm yiŋgimune ya tuhum heŋgeŋgunomai ya yeŋgât nâŋgâmune ârândâŋ otbuap. Yâhâ lok âlâ me âlâ âi pato sâm yiŋgimune ya biwiyeŋaŋe tiŋâk lâum tuhunomai ya yeŋgât gurâ yawuâk nâŋgâmune ârândâŋ otbuap.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesuŋe den âlâ yuwu sâm ekyongop. “Anitâŋe lohimbi yeŋgât biwiyeŋahât topŋe nâŋgâm kâsipyongom matŋe âlâku ikŋiâk ikŋiâk yiŋgimu menomai yakât hâŋgânnohomu gewan. Yâhâ matŋe yiŋgimu meŋetâ pesuk sâmbâp. ");
INSERT INTO spl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Otmu umatŋe âlâ tetenihimu hâhiwin nâŋgâwom ya tetenihim pesuk sâekgât naŋgan. ");
INSERT INTO spl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Otmu den âlâ yuwu sâmune nâŋgâŋet. Nâhât yuwu ki sânomai. “Nâhâit yamâ buku konok otnehât himbimâmbâ giop.” Yawu ki sânomai. Nâŋe hânân gewan yakât yen hioŋaknomai. Hioŋakmâ yuwu oraŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Lohimbi nanŋe baratŋe mome manmaiŋe hioŋakmâ komot yâhâp otnomai. Komot âlâhât yâhâp, âlâhârâmâ kalimbu yawu otnomai. ");
INSERT INTO spl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Âwâ nan me mâmâ barat kuk oraŋgim hioŋaknomai. Otmu iranŋe iranŋe ya gurâ yawuâk kuk oraŋgim hioŋaknomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuŋe hoŋ bawalipŋe yawu sâm ekyongomâmâ benŋe lohimbi kinbi ya yuwu sâm ekyongop. “Op surumbup memuâmâ yuwu sâmai. “Gelâk gewe sâm oap”. Sâŋetâ yawu otmap. ");
INSERT INTO spl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Otmu elem tok sâwe sâm otmuâmâ yuwu sâmai “Sikop kumbe sâm oap.” Sâŋetâ yawu otmap. ");
INSERT INTO spl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yen lok perâkŋe. Yeŋe elem kulewoŋboŋ yakât topŋe ekmâ nâŋgâm heŋgeŋguai. Yâhâ nâŋe kulem âlâlâ memune eksai yakât topŋeâmâ girawuhât ki ekmâ nâŋgâm heŋgeŋguai? ");
INSERT INTO spl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Wongât eŋgatyeŋeâk otmâ orotmeme âlepŋe me bâleŋe ya ki ekmâ kiwilim mansai? Yen lok perâkŋe yakâ.” ");
INSERT INTO spl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bukulipyeŋe âlâ me âlâŋe kuk otyiŋgim den âiân katyekne sâm dâiyekmâ kiapgâlen arinomai. Yamâ mâtâwânâk ari sâm tetem kaok naŋgaŋginomai. Yâhâ yawu ki otnomai yamâ kiapgâlen ari den sâm teteŋetâ yâkŋe mem pâi emetŋan katyekbuap. Pâi emetŋan katyekmu tatmâ yeŋe ombeyeŋeâk yaihen ki genomai. ");
INSERT INTO spl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kiapŋe pâi emetŋan tatnomai sâm sâp katyiŋgiwuap ya pesuk sâmu yanâmâ genomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yawu sâm ekyongop sâp yanâk lok nombotŋaŋe Yesuhâlen ari den pat yuwu sâm ekuwi. “Galilaia ambolipŋaŋe noniŋ bulimakao gâim Anitâhât hotom uwi sâp yan kiap âlâ, kutŋe Pilato sâm, yâkŋe tembe lâulipŋe hâŋgânyongomu Galilaia ambolipŋe yongoŋetâ hepyeŋe gemu noniŋ bulimakao hepŋe orop oset guset olop.” ");
INSERT INTO spl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yawu sâm ekuŋetâ yuwu sâm ekyongop. “Pilatoŋe tembe lâulipŋe hâŋgânyongomu yawu yongowi yakât yuwu mon sâmai. “Muwi yeŋgât tosa bâleŋe yaŋeâmâ Galilaia lok ondop yeŋgât tosa ya wangim amokŋan miap.” ");
INSERT INTO spl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yawu ki tap. Yawu gârâmâ yeŋe orotmemeyeŋe bâleŋe ki pilâm Anitâhât den lâunomai otmuâmâ yawuâk matŋe yiŋgimu menomai. Otmu yakât den âlâ torokatmâ sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yerusalem kapi ambolipŋe kâi nombotgen kalimbu Siloam hem topŋan kinŋetâ kândun kum ge kurihiyehop ya yeŋgât yuwu ki sânomai. “Tosayeŋe bâleŋe yaŋeâmâ Yerusalem kapi ambolipŋe nombotŋe yeŋgât tosayeŋe wangiop. Yakât otmâ hân ya kândun kum ge kurihiyekmu muwi.” Yawu ki tap. ");
INSERT INTO spl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yakât otmâ âlâku sâmune nâŋgâŋet. Yeŋe orotmemeyeŋe bâleŋe ki pilâm Anitâhâlen biwiyeŋaŋe kepeinomai otmuâmâ yengu yawuâk hiliwahonomai.” ");
INSERT INTO spl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Den ya sâm tiŋ pilâm den âlâen hâum yuwu sâm ekyongop. “Lok âlâŋe koset âlâ kalop. Koset ya pato otmâ bulâŋe kinbuapgât sâpŋe tetemu taka amboŋaŋe bulâŋe hâuwe sâm ekmu bia olop. ");
INSERT INTO spl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yakât otmâ kalam galemŋe yuwu sâm ekuop. “Bulâŋe hâuwe sâm ekmune biatmu yu yambu kalimbu oap. Yakât otmâ koset ya kârâm pilârâ ge iâk.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sâmu sâop. “Lok pato, pilârâmâ yambu yu inâk kinâk. Hâmbâi topŋe lawitmâ pitimunŋe yanâmâ bulâŋe kinbuap. ");
INSERT INTO spl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yâhâ ki kinbuap otmuâmâ kârâm pilâmune ge imbuap.” Yawu.” ");
INSERT INTO spl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tatmâ nâŋgâ nâŋgâ sâp âlâen Yesuŋe opon kâmbukŋan yâhâm den kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Den kâsikum yiŋgiop sâp yan imbi âlâ talop yamâ weke bâleŋaŋe mâŋgâemu kun kândâtŋe konok otmâ pareŋe manmâ gamu yambuŋe kâi nombotgen kalimbu pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuŋe imbi ya ekmâ kunŋan mem yuwu sâm ekuop. “Imbi, yiwereŋeâk âlepŋe otbuat.” ");
INSERT INTO spl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yawu sâm kunŋan memu kuwihakmâ tâŋ tâŋâk kinmâ Anitâ mepaeop. ");
INSERT INTO spl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yâhâ Yesuŋe tatmâ nâŋgâ nâŋgâ sâpŋan imbi ya heŋgeŋguop gârâmâ miti emetŋahât galemŋaŋe galemŋaŋe nâŋgâmu bâlemu lohimbi yuwu sâm ekyongop. “Nep tuhu tuhuhât sâpŋe yamâ hilâm nombolân konok tap yan takaŋetâ heŋgemyongombâpgât dop. Yawu gârâmâ tatmâ nâŋgâ nâŋgâ sâpŋan imbi heŋgeŋguap yu ekmune dondâ bâleap. Ya ki orotŋe.” ");
INSERT INTO spl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yawu sâmu Yesuŋe purik pilâwaŋgim yuwu sâop. “Bâe, yen lok perâkŋe. Tatmâ nâŋgâ nâŋgâ sâpŋe ârândâŋ yeŋe doŋgi bulimakaoyeŋe pekeâmbâ holaŋyekmâ dâim ari to yiŋginomaihât dop tap. Yawu gârâmâ doŋgi me bulimakao umutyeŋe bia yakât nâŋgâmune tâŋât otmap. ");
INSERT INTO spl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yâhâ imbi yuâmâ Awarahamgât senâmbâ gâtŋe. Yawu gârâmâ Satangât weke bâleŋaŋe mâŋgâemu pareŋe otmâ manmâ gap. Nâŋe tatmâ nâŋgâ nâŋgâ sâpŋan heŋgeŋgumune ki bâleap.” ");
INSERT INTO spl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yawu sâm ekyongomu sâm ge katbiŋe nâŋgâm aŋulakbi. Yâhâ lohimbi inŋaŋe Yesuŋe olop miop ya ekmâ heroŋe otbaŋgiminiwi. ");
INSERT INTO spl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuŋe yuwu sâm ekyongop. “Anitâhâlen biwiyeŋaŋe kepeim manŋetâ tihityeŋe otmap yakât topŋe teteâkgât wuân denân hâum sâmune nâŋgâŋetâ keterakbuap? ");
INSERT INTO spl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yuân hâum sâmune nâŋgâŋet. “Nak âlâ kutŋe bândup yamâ lok âlâŋe kehetŋe âlâ mem ari kalamŋan kalop. Katmu tatmu kâmŋe ga takam yaŋak yâhâm kâlep pato otmu nâi wosapâ wosapâ taka awatŋe kun kunŋan kerem tatmai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Otmu torokatmâ yuwu sâm ekyongop. “Lok komotŋe komotŋe wosapâ wosapâ mansaiŋe biwiyeŋe nâhâlen katmâ tem lâunihiŋetgât yeŋe ari nâhât den pat âlepŋe ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yakât topŋe teteâkgât den âlâen hâum sâmune nâŋgâŋet. Imbi âlâŋe dâmbia golaŋguwuap. Golaŋgumâmâ matuk mendâremu keluŋe gemu dâmbia orop menduhumu ukenŋe bâleŋe otbuap. Dop yawu.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yerusalem kapi pato yakât mâtâp arap ya hâlâŋmâ kapi tipi tapi tap. Kapi yan ari Yesuŋe Anitâhât den lohimbi kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yawu otmu lok âlâŋe yuwu sâm Yesu âikuop. “Lok pato, yuwu sâm âihohowe. Lok getek âlâ himbimân yâhânomai me girawu?” ");
INSERT INTO spl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Sâmu sâop. “Himbimgât mâtâp yamâ gâwik gâwikŋe. Yakât otmâ yapâ lohimbi sambeŋe arine sâmâmâ hâmbiŋ gumbiŋ otmâ hâum pâpgunomai. Yakât otmâ yeŋe mâtâp ya tâŋ tâŋâk watmâ arinomai. Yakât yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nâ mâtâp amboŋe. Yakât otmâ mâtâp maŋguyiŋgimune lok dondâhâlâkŋe arine sâm hâum pâpgum amutgen kinmâ yuwu sânomai. “Lok pato, nâŋgâningirâ gane.” Sâŋetâ sâwom. “Nâ ki nâŋgâyiŋgian. Yen wonân?” ");
INSERT INTO spl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yawu sâm âiyongomune yuwu sâm eknohonomai. “Gâŋe kapinenŋan taka tatmâ den kâsikum ningirâ orowâk tatmâ sot newin.” ");
INSERT INTO spl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sâŋetâ sâwom. “Yen wonân? Nâ ki nâŋgâyiŋgian. Yeŋe orotmeme bâleŋe otmai. Yakât otmâ ariŋet.” Yawu sâwom. ");
INSERT INTO spl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yâhâ hâmbâi mâne Anitâŋe yen mem ketetyekbuap. Yawu otmâ Awaraham, Isaka, Yakop, otmu Anitâhât poropetelipŋaŋe tatmâ sot nem heroŋe otbaŋginomai ya yekmâ yeŋe tep bâle nâŋgânomai. Yawu otmâ hâhiwin nâŋgâm hu halak tuhumbisâi. ");
INSERT INTO spl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yakât otmâ yuwu sâmune nâŋgâŋet. Sâp yanâmâ lok topŋe topŋe, emetsenŋe ga takamap yakembâ otmu purik sâmap yakembâ, otmu torehen torehen kiŋgitŋe orowâkŋe taka menduhuakmâ nem heroŋe otŋetâ Anitâŋe tihityeŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yâhâ lohimbi nombotŋaŋe yeŋahâlâk nâŋgâŋetâ yahatmap yaŋe Anitâ orop ki tatnomai. Yâhâ nombotŋaŋe yeŋahât nâŋgâŋetâ gemu huruŋ huruŋ manmai yamâ Anitâŋe meyekmu ikŋan torokatnomai. ");
INSERT INTO spl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sâp yanâk Parisaio lok nombotŋaŋe ari yuwu sâm Yesu ekuwi. “Herotŋe gohowe sâm oap. Yakât otmâ kapi yu pilâm âlâengen ari.” ");
INSERT INTO spl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sâŋetâ sâop. “Sâp yuâmâ weke bâleŋe watyekmâ mansan. Otmu kundat otmâ mansai ya heŋgemyongom mansan. Yâhâ hândâhân yuwuâk otbom. Yâhâ halihu nep sâm nihiop ya tuhum pesuk pilâwom.” Den ekyongoan yu Herot, lok perâkŋe ya, ekunomai. ");
INSERT INTO spl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nâŋe yuwu sâmune nâŋgâŋet. Anitâhât poropetelipŋaŋe ikŋahât den sâminiwi ya kerek Yerusalem kapi ambolipŋaŋe yongoŋetâ muwi. Yakât otmâ âun hândâhân âi tuhuwom. Gârâmâ halihuâmâ Yerusalem kapiân ari âi tuhum pesuk pilâwom.” ");
INSERT INTO spl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yawu sâm ekyongom Yerusalem kapi ambolipŋe yeŋgât tepŋe nâŋgâm yuwu sâop. “Bâe, Yerusalem kapi ambolipŋe yeŋgât topyeŋe yuwu tap. Yeŋgâlen âi meŋetgât Anitâŋe ikŋe hoŋ bawalipŋe hâŋgânyongomu takaŋetâ yongom mem ge katyekmai. Yakât otmâ den âlâen hâum yuwu sâwe. Pâi mâmâŋaŋe kurâk sâm nanlipŋe dâiyekmâ kuratyongomu tatmai. Yakât dopŋeâk menduhuyekmune nâhât hikinan manŋetgât sâman. Yamâ yeŋe nâhât hâkâŋ otmâ mansai. ");
INSERT INTO spl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yawuhât Anitâŋe betyongomu kasalipyeŋaŋe taka yongom watyekŋetâ kapi yu kâwurumŋaŋak kinbuap. Yakât otmâ nâŋe pilâyekmâ ariwom. Benŋe sâp âlâen âwurem takamune nekmâ yuwu sâm eknohonomai. “Anitâ Kutdânenŋaŋe tihitnenŋe otbe sâm mat hâŋgângohomu takat. Yakât otmâ biwinenŋaŋe heroŋe pato naŋgain.” Yawu sâm eknohonomai.” Yesuŋe yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tatmâ nâŋgâ nâŋgâ sâp âlâen Parisaio yeŋgât kunyeŋaŋe bukulipŋe nombotŋe Yesu orop dâiyekmu emetŋan yâhâ tatmâ sot newi. Nem tatbi yan Yesuŋe otmâ hilipguwuap me bia yakât Parisaioŋe ekmâ tatbi. ");
INSERT INTO spl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ekmâ tatŋetâ lok âlâ bitâp pato tetewaŋgiopŋe Yesu ekbe sâm yâhâop. ");
INSERT INTO spl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yâhâmu Yesuŋe ekmâmâ Mosehât girem den kâsikum yiŋgiminiwi otmu Parisaio ya yuwu sâm âiyongop. “Tatmâ nâŋgâ nâŋgâ sâpŋan âi ki tuhunomgât Moseŋe girem den âlâ kulemguop. Yawu gârâmâ tatmâ nâŋgâ nâŋgâ sâpŋan lohimbi heŋgemyongowomgât dop tap me bia? Sâŋetâ nâŋgâwe.” ");
INSERT INTO spl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yawu sâm âiyongomu biwiyeŋe umatŋe otmu olotoŋâk tatbi. Olotoŋâk tatŋetâ Yesuŋe lok ya bitâpŋan walipgumu orok sâmu emelambâ kioŋmâ ariop. ");
INSERT INTO spl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Arimuâmâ emelan tatbi ya Yesuŋe yuwu sâm ekyongop. “Tatmâ nâŋgâ nâŋgâ sâpŋan naom âlâ me bulimakao âlâ lâmân kioŋmu ya pilâŋetâmâ lâmânâk tatbuap me mem dâiŋetâ gawuap?” ");
INSERT INTO spl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yawu sâm âiyongomu yawuâk olotoŋâk tatbi. ");
INSERT INTO spl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yâhâ emet yakât biwiŋan Parisaio nombotŋaŋe yeŋahât nâŋgâŋetâ yahatmu kou senŋan yâhâ tatbi ya yekmâ den âlâen hâum yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bukuyeŋe âlâŋe yen orowâk tatmâ sot um nenom sâm dâiyekmu emetŋan yâhâ kou senŋanâk tatne yawu ki nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yâhâ lok papato nombotŋe yen orowâk dâiyekbuap yâkŋe kou senŋanâk tatnomaihât nâŋgâwuap. Yawu gârâmâ yeŋe kulet sâyiŋgim kou senŋan tatnomai yan lok papato takaŋetâmâ emet amboŋaŋe yen yuwu mon sâm ekyongowuap. “Wa, bukulipne, yuâmâ yeŋgât kawe bia, keterakŋet.” Yawu sâm ekyongomu aŋulakmaihât aŋgoân yâhâmâmâ kou topŋan tatnomai. ");
INSERT INTO spl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yawu tatŋetâ emet amboŋaŋe kundup mem kou senŋan liŋgatbuap. Liŋgatmâ “gam yâhâ tatŋet” sâm ekyongomu yanâmâ yâhâ tatnomai. Yawu otŋetâ yanâmâ bukulipyeŋaŋe nâŋgâyiŋgiŋetâ âiloŋgo otbuap. ");
INSERT INTO spl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yakât topŋe yuwu sâmune nâŋgâŋet. Lok âlâ me âlâŋe yeŋahât nâŋgâŋetâ gewuap ya yeŋgât Anitâŋe nâŋgâmu yahatbuap.” ");
INSERT INTO spl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yawu sâm ekyongom emet amboŋe ya yuwu sâm ekuop. “Kapi ambolipŋe orop heroŋe otmâ sot um nenom sâm imi atalipge, me wârâ toulipge, me hep torehenlipge, me bukulipge, me lok iri sikumyeŋe orop mansai ya ki dâiyekmâ garâ sot nenomai. Yâhâ lok yawuya dâiyekmâ garâ sot nenomai otmuâmâ hâmbâi yakât matŋe sâm dâihekŋetâ yâk orop sot neŋetâ pesuk sâwuap. ");
INSERT INTO spl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yakât otmâ yuwu sâmune nâŋgâ. Gâŋe heroŋe otmâ sot um lok dâiyekbuat otmuâmâ lok tâŋât, kopa, pareŋe, senyeŋe bok sâsâŋe yawuya dâiyekbuat. ");
INSERT INTO spl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lok yawuya dâiyekmâ bât belaiâk sot um yiŋgirâ nem heroŋe otnomai. Yawu gârâmâ hâmbâi Anitâŋe lohimbi mumuŋambâ mem yahatnenekbuap yan ikŋak yakât matŋe gihiwuap. Yakât otmâ biwihaŋe heroŋe nâŋgâwuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yawu sâm ekumu nem tatbi ya yeŋgâlen gâtŋe âlâŋe den ya nâŋgâmâmâ yuwu sâm ekuop. “Anitâŋe himbimân mannomgât pat kuningimu mansain. Yakât otmâ sâp patoen Anitâhât kapiân tatmâ sot nem heroŋe otnom yakât nâŋgâmune tepne heroŋe oap.” ");
INSERT INTO spl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yawu sâm ekumu den âlâen hâum yuwu sâm ekuop. “Lok kutdâ âlâŋe bukulipŋe orowâk heroŋe otmâ sot um nenomai yakât sâp kalop. ");
INSERT INTO spl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yâhâ sâpŋe otmu yan soŋgo bau me sot kâle topŋe topŋe um hâwurumu eŋ âtâmun kinop. Ya ekmu ârândâŋ otmu hoŋ bawa âlâ hâŋgângumu ari yâkât bukulipŋe yuwu sâm ekyongop. “Soŋgo bau sot kâle yamâ emelâk umunŋe siap. Yakât otmâ gaŋetâ heroŋe otmâ nenom,” yawu yap” sâm ekyongop. Ekyongomu hâkâŋ otbi. ");
INSERT INTO spl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lok aŋgoân ekuop yaŋe yuwu sâop. “Nâmâ hân puluhuan ya ekbe sâm ariwom. Yakât otmâ lok kutdâ ya ekurâ ki nâŋgânihimu bâlewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yâhâ âlâŋeâmâ yuwu sâop. “Bulimakao bâlâk ŋerek puluhumune kapi kâlepŋehen tap ya ari meyekmâ takawom. Yakât otmâ lok kutdâ ya ekurâ ki nâŋgânihimu bâlewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yâhâ âlâŋeâmâ yuwu sâop. “Yiwereŋeâk imbi mian. Yakât otmâ ki gawom?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yawu sâŋetâ hoŋ bawa yaŋe âwurem ari lok kutdâŋe den sâwi ya ekumu nâŋgâmu bâleop. Nâŋgâmu bâlemu hoŋ bawaŋe ya yuwu sâm ekuop. “In yawu ari mâtâp kunŋan kinmâ lok umburuk, me lok pareŋe, me ândâpyeŋe bok sâsâŋe, me senyeŋe bok sâsâŋe, lok yawuya yuken yaken arine sâm oai ya ekyongorâ taka sot yu neŋet.” Yawu sâm ekum hâŋgângumu ari mem teteyekmâ ekyongomu taka emetŋan yâhâ tatbi. Yâhâ tatŋetâ hoŋ bawaŋe yaŋe yâkâlen yâhâ yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Lok kutdâne, den yat ya oan. Otmu emelan yâhâ tai yamâ ki pik yai. Yakât otmâ girawu naŋgat?” ");
INSERT INTO spl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Sâmu sâop. “Yakât otmâ âlâku ari lohimbi kewilâyekŋetâ mansai ya mem teteyekmâ ekyongorâ takanomai. Takaŋetâ yanâmâ emetne pik sâwuap. ");
INSERT INTO spl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yâhâ bukulipne aŋgoân ekyongoat yamâ nâhâlen ki takanomai.” Yawu sâop.” Yesuŋe yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lohimbi kiŋgitŋe orowâkŋe Yesu betŋan ariŋetâ purik sâm yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Lok âlâ me âlâŋe nâhâlen torokatmâ orowâk mannom yawu nâŋgânomai otmuâmâ âwâ mâmâlipyeŋe, me imbi naomlipyeŋe, me imi atalipyeŋe, me wârâ toulipyeŋe betyiŋginomai. Otmu yeŋe manmanyeŋe ki alitnomai. ");
INSERT INTO spl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Otmu lok âlâ me âlâŋe nâhât den lâum âi tuhuŋetâ bukulipyeŋaŋe nâŋgâm bâleyiŋgim hilipyongone sâm otnomai yanâmâ hâkyeŋe alitmâ betnihinomai. Lok yawuya nâhât pat ki otnomai. ");
INSERT INTO spl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yakât nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Lok âlâ me âlâŋe emet tuhune sâm aŋgoân tewetsenŋe amon yaŋe senŋe âlâlâ puluhum emet ya tuhunomai yakât nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Gârâmâ yawu ki otnomai otmuâmâ emet ya mem kânâŋgâŋetâ tewetsenŋe biatmu pâŋan pilânomai. Yawu otnomai yanâmâ lohimbiŋe emet ya torehenŋeâk kinmu ekmâ yakât den pat alahu gulahu otmâ senyeŋan gem giriŋyiŋgim yuwu sânomai. ");
INSERT INTO spl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Lok yuŋeâmâ saran kânâŋgâŋetâ giop yamâ tewetsenŋe biatmu pâŋan pilâŋetâ inâk tap.” Yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yâhâ den âlâen hâum yuwu sâmune nâŋgâŋet. Lok kutdâ âlâ me âlâŋe kasalipyeŋe orop ahonomai yanâmâ in yawu yâk yeŋgâlen ki surutuk sâm arinomai. Yamâ aŋgoân biwiyeŋaŋe yuwu nâŋgânomai. “Nen yu getek âlâ, lok 10,000 yawu mansain. Yâhâ kasalipnenŋe endaken lok kiŋgitŋe orowâk, 20,000 yawu mansai. Yakât otmâ nenŋe yongonomgât dop ki otbuap.” ");
INSERT INTO spl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yeŋahât yawu nâŋgânomai otmuâmâ ki kundutmâ arinomai. Aŋgoân kasalipyeŋe orop buku konok manne sâm hoŋ bawalipyeŋe hâŋgânyongoŋetâ ari mem lohotŋe tuhuyeknomai. ");
INSERT INTO spl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yakât otmâ yuwu sâmune nâŋgâŋet. Yeŋgâlen gâtŋe âlâ me âlâŋe senŋe âlâlâyeŋe me iri sikumyeŋe kerehâk pilâm nâhâlen torokatnomai otmuâmâ nâŋgâyiŋgimune orowâk mannom. ");
INSERT INTO spl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yeŋgât topyeŋe teteâkgât den âlâen hâum sâmune nâŋgâŋet. Kâtembe ihim solân hoŋmâ sot ya nemunŋe launenŋan memap. Yakât dopŋeâk yenâmâ lohimbi hohetyeŋan manmâ manman âiloŋgo manŋetâ yekmâ Anitâ heroŋe nâŋgâwaŋgim mepaenomai. ");
INSERT INTO spl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yâhâ kâtembe heleŋân ki hikum ikainom yanâmâ pâlâmŋe otbuap. Yawu otmu girawu tuhumunŋe âlâkuâk ukenŋe otbuap? Yamâ ki orotŋe. Pâlâmŋe sâm lâum pilâmain. Den yuâmâ biwiyeŋanâk katmâ manmâ yâhânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sâp âlâen takesi meme lokŋe yeŋahât nâŋgâŋetâ yahatmu lohimbi kâityongom takesi mem yahatmâ kombo meyiŋgiminiwi yâk otmu lok nombotŋe ândâp kârik otmâ Mosehât girem den ki lâum manminiwi ya dondâhâlâkŋe Yesuhât den nâŋgâne sâm yâkâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ariŋetâ yan Mosehât girem den kâsikum yiŋgiminiwi otmu Parisaio lok yâkŋe nâŋgâŋetâ bâlemu Yesuhât yuwu sâwi. “Yesuŋe takesi meme lok otmu lok nombotŋe Mosehât girem den ki lâumai ya meyekmu orowâk sot niai. Yawu otmu dondâ bâleap.” ");
INSERT INTO spl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yawu sâŋetâ nâŋgâm Yesuŋe den âlâen hâum yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Lok âlâhât lama 100 yawu kinbaŋgiwuap. Gârâmâ ya yeŋgât hohetyeŋambâ konok âlâŋe misiŋgurakbuap. Yawu otmu amboŋaŋe nombotŋe ya katyekmu kinŋetâ konok misiŋgurakbuap ya pâinmâ yâhâm gewuap. Yawu otmâ nombotŋe katyekmu kinnomai ya yeŋgât ki nâŋgâm ketet otbuap. ");
INSERT INTO spl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Yâhâ misiŋgurakbuap ya mem tetem yanâmâ tepŋe welâmŋan gemu lâum kapiân âwurem ariwuap. Kapiân âwurem ari bukulipŋe yongonmâ yuwu sâm ekyongowuap. “Lama misiŋgurahop ya mem tetean. Yakât otmâ sot um nem heroŋe otne.” Yawu sâwuap. ");
INSERT INTO spl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yakât dop kum yuwu sâmune nâŋgâŋet. Lok 99, yâkŋe yuwu nâŋgâmai. “Nen lok âlepŋe, orotmemenenŋe âiloŋgo otmâ mansain.” Yawu nâŋgâm biwi pâlâmŋe mansai. Lok yawuya yeŋgât Anitâŋe heroŋe pato ki nâŋgâyiŋgimap. Gârâmâ, lok konohâkŋe orotmemeŋe bâleŋe bet pilâm Anitâhâlen biwiŋaŋe kepeim tem lâuwaŋgiwuap yanâmâ Anitâŋe heroŋe pato nâŋgâwaŋgiwuap. Yawu.” ");
INSERT INTO spl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yâhâ Anitâŋe lohimbi meyekmâ tihityeŋe otmap yakât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum sâmune nâŋgâŋet. Imbi âlâ kina yâhâp yakât dop tatbaŋgiwuap. Yâhâ 20 toea kioŋbaŋgimuâmâ ki pilâwuap. ");
INSERT INTO spl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yakât pâinmâ arim mem tetem yanâmâ bukulipŋe yongonmâ yuwu sâm ekyongowuap. “Wâe, tewetsenŋe kioŋnihiop ya mem tetean. Yakât otmâ heroŋe otne.” Yawu sâwuap. ");
INSERT INTO spl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yakât yuwu sâmune nâŋgâŋet. Lok konohâkŋe orotmemeŋe bâleŋe bet pilâm Anitâhâlen biwiŋaŋe kepeim tem lâuwaŋgiwuap yanâmâ himbimân Anitâhât aŋelolipŋaŋe lok yakât heroŋe nâŋgâwaŋginomai.” ");
INSERT INTO spl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Lok âlâ nanyâhâtŋe yâhâp manbi. ");
INSERT INTO spl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Manŋetâ nanŋe betŋan gâtŋaŋe âwâŋe yuwu sâm ekuop. “Awoŋ, senŋe âlâlâ nâhât sâsâŋe ya nihirâ miakbe.” Yawu sâmu senŋe âlâlâ yâkât sâsâŋe ya kâsikum waŋmu miop. ");
INSERT INTO spl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yawu otmu nanŋe ya nep tuhum getek manmâ, senŋe âlâlâ ya puluhum yakât hâmeŋe tewetsenŋe miakmâ mâtâp kâlewângen ariop. Ari heŋ otmâ ihilâk mahilâk manmâ tewetsenŋe miakmâ ariop ya kerek pilâm metem umburuk manop. ");
INSERT INTO spl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","16","Umburuk manop yan po pato teteop. Po pato tetemu naom yaŋe sotgât pâinmâ kapi amboŋe âlâhâlen arimu bau galemguwuap sâm âi waŋop. Bau galemgum kinop yan po dondâ waŋgimu bau yakât sot wahapŋe mem nembe sâm otmu kuwaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yawu otbaŋgiŋetâ nâŋgân nâŋgânŋe tetemu yuwu nâŋgâop. “Awoŋnahât nep loklipŋaŋe sot pato nem mansai. Nâ nanŋe tâŋ tâŋ yamâ yuân manmâ sotgât otmâ hiliwahowoman. ");
INSERT INTO spl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yakât otmâ yahatmâ awoŋnahâlen âwurem ari yuwu sâm ekuwom. “Awoŋ, otmune bâleop yakât tosa Anitâhâlen otmu gâhâlen umatŋe oap. ");
INSERT INTO spl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yakât otmâ aŋulaksan. Yawu gârâmâ nâŋgânihim nep lok sâm menekdâmâ hoŋ bahihim manbom.” Yawu sâm ekuwom.” Yawu nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yawu nâŋgâm yahatmâ kapi ya pilâm akŋangen takamu âwâŋaŋe senŋe pilâm ehop. Ekmâ tepŋe nâŋgâm sururuk sâm ari nanŋe lâum hâmeŋe hârem niop. ");
INSERT INTO spl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yawu otmu nanŋaŋe yuwu sâm ekuop. “Awoŋ, otmune bâleop yakât tosa gâhâlen otmu Anitâhâlen umatŋe oap. Yawu otmâ aŋun pato gihiwan. Otmu nâhurâ aŋulaksan.” ");
INSERT INTO spl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Yawu sâm ekumu âwâŋaŋe hoŋ bawalipŋe yuwu sâm ekyongop. “Nanne emelâk betnohom ariop ya âwurem takap. Yâhâ “emelâk muop mon,” yawu nâŋgâm manmâ gaman. Yamâ âwurem takamu ekmâ tepne hâlâlâk welâmŋan giap. Yakât otmâ in yawu ba hâk katipŋe âiŋe mem ga mânuŋbaŋgiŋet. Yawu otmâ handop âlâ mem barahanŋan katŋet. Otmu kâi katipŋe katbaŋgiŋet. Nenŋe heroŋe otbaŋginomgât bulimakao nanŋe gâim uŋetâ siâk.” Yawu sâm ekyongomu bulimakao nanŋe gâim uŋetâ semu nem heroŋe otbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","26","Heroŋe otbaŋgiŋetâ yan nanŋe kunŋe yaŋe newângembâ taka kapi ginŋan kinmâ heroŋe maroŋe giriŋ get get otmâ kinbi ya nâŋgâm hoŋ bawa âlâ kunmu gamu yuwu sâm âikuop. “Wongât heroŋe otmâ tai?” ");
INSERT INTO spl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sâmu sâop. “Imihe ari gulip olop ya âwurem takap. Yakât otmâ âwâyetŋaŋe eknongomu bulimakao nanŋe ya kum gâim umunŋe siap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yawu sâm ekumu nâŋgâm âwâŋahât nâŋgâm bâlewaŋgim kapi betŋehen kinop. Yâhâ hoŋ bawa yaŋe âwâŋe ekumu âwâŋaŋe ba kinmâ “Nan, ga,” sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ekumu hâkâŋ otmâ yuwu sâop. “Naŋgat. Nâŋe tem lâuhihim âi mem manmâ gamune yambu dondâ pesuk yap. Yawu otgihiman yamâ gâŋe ki heroŋe otnihimat. Otmu noniŋ nanŋe âlâ ki nihirâ bukulipne orop um nem heroŋe otmain. ");
INSERT INTO spl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yawu gârâmâ nangaŋe senŋe âlâlâ hârok gâwârehihim ari imbi kondarâ orop manmâ tewetsenŋe pilâm meteop. Yâkŋe âun âwurem takamu hoŋ bawalipge ekyongorâ bulimakao nanŋe kum gâim uŋetâ semu nem heroŋe otbaŋgiai. Yakât nâŋgâmune dondâ bâleap.” ");
INSERT INTO spl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yawu sâmu âwâŋaŋe yuwu sâm ekuop. “Nanne, gâŋe nâ orop sâp kâlep manmâ gamat. Otmu senŋe âlâlâ tatnihiap ya gâhât pat sâm kuhihimune tap. ");
INSERT INTO spl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yawu gârâmâ imihe “emelâk muop mon,” yawu nâŋgâm manmâ gan ya âwurem takap. Yakât otmâ heroŋe otbaŋgimunŋe ârândâŋ oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuŋe hoŋ bawalipŋe den âlâen hâum yuwu sâm ekyongop. “Lok kutdâ iri sikumŋe tewetsenŋe otmu âlâlâ ya pato dondâ tatbaŋgiop. Yakât otmâ lok âlâ mem galemgunihiâkgât sâm âi waŋop. Yawu gârâmâ lok yaŋe lok kutdâŋahât tewetsenŋe mem gulip tuhuop. Yawu otmu lok kutdâ yakât hoŋ bawalipŋe nombotŋaŋe yakât den pat yuwu sâm ekuwi. “Lok âlâ galem sâm âi waŋon yâkŋe senŋe âlâlâ mem ihilâk tuhuhihiap.” ");
INSERT INTO spl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yawu sâm ekuŋetâ lok kutdâyeŋe yaŋe lok ya yuwu sâm ekuop. “Gâŋe nâhât tewetsenŋe mem gulip tuhunihiat” yawu sâŋetâ naŋgan. Yakât otmâ galem âlâku ki katgekbom. Yakât otmâ puluhu puluhu pepa ya mem garâ senŋe âlâlâ tatnihiap yakât topŋe mem tetewom.” ");
INSERT INTO spl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Yawu sâm hâŋgângumu ari biwiŋaŋe yuwu nâŋgâop. “Lok kutdâne watnekbomap. Yakât otmâ giratbe? Wâtne pato ki tatnihiap. Yakât otmâ âi umatŋe tuhuwomgât dop âlâ ki tap. Otmu senŋe âlâlâ gewe yâhâwe yakât lok bât kandi bero manbom sâm yakât aŋulaksan. ");
INSERT INTO spl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yiwereŋe nâŋgâmune teteap. Bukulipne yeŋgât tosa pato lok kutdânahâlen tap ya mem gemune heroŋe nâŋgânihinomai. Yawu nâŋgânihim lok kutdânaŋe watnekbuap yanâmâ menekŋetâ orowâk mannom.” Biwiŋaŋe yawu nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yawu nâŋgâm bukulipŋe yeŋgât tosa pato lok kutdâŋahâlen talop yâk âlâku ikŋiâk ikŋiâk mem dâiyehop. Yâhâ aŋgoân gaop ya yuwu sâm âikuop. “Gâhât tosa lok kutdânahâlen amon tap?” ");
INSERT INTO spl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sâmu sâop. “Nak bulâŋahât toŋe ya âsâp 100.” Sâmu sâop. “Âlepŋe tosahahât pepa yu mem 50 ya kulemgu.” ");
INSERT INTO spl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yawu sâm ekumu arimu lok âlâ gamu yuwu sâm âikuop. “Lok kutdânahâlen tosa amon tap?” Sâmu sâop. “Siwit kehetŋe ya itâ 1000.” Sâmu sâop. “Tosahahât pepa yu mem 800 ya kulemgu.” ");
INSERT INTO spl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yawu ekyongop yakât den pat nâŋgâm lok kutdâŋaŋe galemŋe yakât nâŋgân nâŋgânŋe pato tatbaŋgiap nâŋgâm heroŋe pato nâŋgâwaŋgiop. Wongât? Yuwuhât. Anitâhât den ki lâumai nombotŋaŋe iri sikumyeŋe galemgum manman sânduhân manmai yakât nâŋgân nâŋgânyeŋe pato tap. Yuwu otmâ Anitâhât den lâumai ya yeŋgât nâŋgân nâŋgânyeŋe ya wangiap. ");
INSERT INTO spl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yakât otmâ yuwu sâmune nâŋgâŋet. Yeŋe Anitâhât tem lâuwaŋgim iri sikum, me tewetsenŋe, senŋe âlâlâ ya galemgum heŋgeŋgum lohimbi yu me yakât umburuk oai ya kâsikum yiŋgim tânyongonomai. Buku otyiŋgim manmâ yâhâŋetâ hâmbâi sâp pesuk sâwuawân Anitâŋe manman kârikŋan katyekmâ yakât hâmeŋe yiŋgimu menomai. Yawu.” ");
INSERT INTO spl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yesuŋe den yuwu sâm ekyongop. “Lok âlâ me âlâŋe âi tâŋât biwiyeŋaŋe tiŋâk lâum tuhum manmaiŋeâmâ âi pato yawuâk biwiyeŋaŋe lâum tuhum heŋgeŋgunomai. Yâhâ lok âlâ me âlâŋe âi tâŋât tuhum hilipgumaiŋeâmâ yakât dopŋeâk âi pato tuhum hilipgunomai. ");
INSERT INTO spl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yakât otmâ yeŋe tewetsenŋe me hângât wahap topŋe topŋe yawuya ki galemgum heŋgeŋgunomai otmuâmâ hâmbâi Anitâŋe manman bulâŋe ki yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yâhâ bukulipyeŋe yeŋgât senŋe âlâlâ hilipgunomai otmuâmâ Anitâŋe yeŋgât pat kuyiŋgiop ya hâmbâi ki yiŋgimu menomai. ");
INSERT INTO spl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yakât nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. “Lok konokŋe lok kutdâ yâhâp yetgât âi menduhum ki tuhuyitgiwuap. Âlâhât biwiŋaŋe kepeim heroŋe kakŋan tuhuwaŋgiwuap. Yâhâ âlâhârâmâ hâkâŋ kakŋan nep ya ki tuhum heŋgeŋguwuap. Yakât topŋe yuwu sâwe. Hângât manman me iri sikum yan biwiyeŋe arimu manmaiŋe girawu otmâ Anitâ tem lâuwaŋgim mannomai? Yamâ ki orotŋe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesuŋe yawu sâm ekyongomu Parisaio nombotŋe iri sikumyeŋe alilakmâ manbiŋe nâŋgâŋetâ gemu senŋan gewi. ");
INSERT INTO spl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Senŋan geŋetâ yuwu sâm ekyongop. “Lohimbiŋe yekŋetâ yahatmu koko salehâk mansai yawu sâŋetgât yeŋe lohimbi senyeŋan kinmâ Anitâhât den lâuain sâm otmai. Yamâ Anitâŋeâmâ yeŋgât biwiyeŋahât topŋe naŋgap. Yu ya otmâ manmai ya lohimbiŋe ekŋetâ âlepŋe otmap yamâ Anitâŋe ekmu bâlemap.” ");
INSERT INTO spl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Den âlâ sâmune nâŋgâŋet. Moseŋe girem den âlâlâ kulemguop otmu Anitâhât poropetelipŋaŋe den kulemguwi ya tatmâ gam Yoane teteop yan andemŋe oap. Otmu Yoane teteop sâp yapâek lohimbiŋe Anitâhâlen biwiyeŋaŋe kepeiŋetâ tihityeŋe otbuap yakât den pat âlepŋe ekyongom gan. Yawu otmâ lohimbi kiŋgitŋe orowâkŋe nâŋgâŋetâ bulâŋe otmu yakât bulâŋe mene sâm oai. ");
INSERT INTO spl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Hân himbim gulip otbuapgât Anitâŋe sâm kalop. Yamâ Mosehât girem den ya kum gulip tuhunomgât dop âlâ ki tap.” ");
INSERT INTO spl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Den âlâ sâmune nâŋgâŋet. Lok âlâ me âlâŋe imbiŋahât hâkâŋ otmâ pilâm imbi ondop membuap. Yamâ lok yaŋe tosa umatŋe membuap. Yâhâ lok âlâ me âlâŋe imbi pilâ pilâŋe ya membuap ya yawuâk tosa umatŋe membuap. Otmu imbi âlâŋe lok pilâ pilâŋe ya membuap ya yawuâk tosa umatŋe membuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Lok kutdâ âlâ iri sikum tewetsenŋe pato tatbaŋgiopŋe yuwu otmâ manminiop. Hâk katipŋe âiloŋgo loŋgo haŋgalakmâ hilâmŋe hilâmŋe sot topŋe topŋe nem hop sambe kakŋan manminiop. ");
INSERT INTO spl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yâhâ lok âlâ umburuk manop, yâkât kutŋe Lasaro sâm. Yâhâmâ use kârikŋe tetewaŋgimu hâhiwin kakŋan manminiop. ");
INSERT INTO spl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yawu otmâ lok kutdâ yaŋe emetŋan tatmâ sot nemu wahapŋe gowelan kioŋop ya mem nembe sâm Lasaro emet gowetŋan iminiop. Emet gowetŋan im tatmu sosoŋe taka useŋe ya nimbilakuminiwi. ");
INSERT INTO spl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sâp âlâen lok umburuk ya mumu Anitâhât aŋelolipŋaŋe lâum yâhâ Awaraham gotŋan katŋetâ talop. Yâhâ sâp ki kâlep otmuâk lok kutdâ ya yawuâk mumu hanguwi. ");
INSERT INTO spl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yâhâ mumu umutŋaŋe hem topŋan kâlâp sem talowân ge tatmâ hâhiwin pato nâŋgâop. Yawu otmâ senŋe pilâm Awaraham yet Lasaro yelehop. ");
INSERT INTO spl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yelekmâ den kârikŋan halahum yuwu sâm Awaraham ekuop. “Awoŋ, yuwu sâmune nâŋgâ. Kâlâp kâlehen tatmâ hâhiwin bâleŋe naŋgan. Yakât otmâ Lasaro ekurâ hâlipŋaŋe to wâimâmâ nimbilamnan katmu sânduk sâek.” ");
INSERT INTO spl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yawu sâmu Awarahamŋe yuwu sâop. “Nanne, yuwu sâmune nâŋgâ. Emelâk heroŋe otmâ hop sambe kakŋan manon ya pesuk yap. Lasaro yâhâmâ hâhiwin kakŋan manop ya gurâ yawuâk pesuk yap. Yakât otmâ tep hero kakŋan tap. Gâmâ hâhiwin pato nâŋgâm tat. ");
INSERT INTO spl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yâhâ hohetnenŋan hem pato kinsap. Yakât otmâ yupâ gâtŋe âlâ me âlâŋe gâhâlen gene sâm hâum pâpgunomai. Otmu yeŋgâlen gâtŋe âlâ me âlâŋe yuân gane sâm yawuâk hâum pâpgunomai.” ");
INSERT INTO spl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Sâmu sâop. “Awoŋ, den âlâ sâmune nâŋgâ. Kapinan imilipne mome mansai. Yâkŋe yuân ge hâhiwin nâŋgâmaihât Lasaro hâŋgângurâ ari girem den ekyongomu nâŋgân nâŋgânyeŋe pâroŋ sâekgât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Sâmu sâop. “Yawu bia. Moseŋe girem den âlâlâ kulemguop otmu Anitâhât poropetelipŋaŋe den kulemguwi ya sâlikum nâŋgânomai. Nâŋe ki hâŋgângumune âwurem gewuap.” ");
INSERT INTO spl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sâmu sâop. “Awoŋ, yuwu sâmune nâŋgâ. Moseŋe den kulemguop otmu Anitâhât poropetelipŋaŋe den kulemguwi ya sâlikumai yamâ ki tem lâumai. Yakât otmâ muwi yâk yeŋgâlen gâtŋe âlâ me âlâŋe mumuŋambâ yahatmâ ari ekyongonomai otmuâmâ orotmemeyeŋe bâleŋe bet pilâm Anitâ tem lâuwaŋginomai.” ");
INSERT INTO spl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Sâmu sâop. “Nanne, yuwu sâmune nâŋgâ. Moseŋe girem den âlâlâ kulemguop otmu Anitâhât poropetelipŋaŋe den kulemguwi ya sâlikum nâŋgâŋetâ nahat otmu ki lâumai. Yakât otmâ muwi yâk yeŋgâlen gâtŋaŋe mumuŋambâ yahatmâ ari ekyongonomai otmuâmâ yakât dopŋeâk yâkât den nâŋgâŋetâ nahat otmu ki lâunomai. Yakât otmâ ki hâŋgângumune âwurem gewuap.” Yawu sâm ekuop.” Yesuŋe den âlâen hâum yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuŋe hoŋ bawalipŋe yuwu sâm ekyongop. “Lohimbi kerekŋe lohotŋe otmâ yuwu yawu otŋetâ bâlemu tosa meŋetgât Satanŋe kendâyiŋgimap. Otmu lohimbi âlâ me âlâŋe bukulipyeŋaŋe otŋetâ bâleâkgât kendâyiŋgimai yamâ Anitâŋe matŋe umatŋe yiŋgimu menomai. ");
INSERT INTO spl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yakât otmâ lohimbi âlâ me âlâŋe bukulipyeŋe kendâyiŋgiŋetâ otŋetâ bâlemap yâhâmâ mâmâlipyeŋaŋe ki mem ga katyekbâi yamâ mem ga katyekbi. ");
INSERT INTO spl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yakât otmâ biwiyeŋe galemahom manmâ yâhânomai. Bukuhe âlâŋe bâleŋe topŋe topŋe mâŋgâehekmu ekurâ yetŋiâk tatmâ den heŋgeŋguromawot. Yawu otmutâ ârândâŋ otmu buku konok mandomawot. ");
INSERT INTO spl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yâhâ hilâm konok yakât biwiŋan bukuhaŋe orotmeme kiŋgoŋ mâŋgâehekmâ yahatmu nombolân yâhâpŋe otbuap. Yawu gârâmâ mâŋgâehekbuap ya sâm tetem tosaŋe pilâwaŋgiwuatgât ekgohowuap otmuâmâ âlepŋe tosaŋe pilâwaŋgiwuat.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yawu sâmu hoŋ bawalipŋaŋe yuwu sâm ekuwi. “Kutdâ, den eknongomat ya kerek nâŋgâmunŋe yakât bulâŋe tetewuapgât naŋgain. Yakât otmâ mem heweweŋ tuhunenekdâ gâhâlen biwinenŋaŋe tiŋâk kepeim mannom.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sâŋetâ yuwu sâm ekyongop. “Den âlâen hâum yuwu sâmune nâŋgâŋet. Nak âlâ, kutŋe bândup, yamâ lok âlâŋe kehetŋe tipiŋe âlâ mem ari kalamŋan kalop. Katmu tatmu kâmŋe ga takamu yaŋak yâhâm kâlep pato otmâ nak nombotŋe wangim kinmap. Yakât dopŋeâk nâhâlen biwiyeŋaŋe kepeim manmâ yâhâ lakop endo kinsap enda ekuŋetâ denyeŋe nâŋgâm hindakmâ saruân kioŋbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Den âlâen hâum yuwu sâm ekyongop. “Yeŋgâlen gâtŋe âlâ me âlâhât hoŋ bawalipyeŋaŋe noniŋ bulimakao galemgum nep tuhum emetsâpŋan kapiân âwurem gaŋetâ yuwu ki sâm ekyongonomai. “Emetyeŋan yâhâ tatŋetâ sot um yiŋgiwe.” ");
INSERT INTO spl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yawu bia. Yuwu mon sâm ekyongonomai. “Sot um nihiŋetâ nemune ârândâŋ otmu yeŋe sot um nenomai.” Yawu sâm ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yakât yuwu sâmune nâŋgâŋet. Lok kutdâlipyeŋaŋe hoŋ bawalipyeŋe nep sâm yiŋgimai ya tuhuŋetâ ki mepaeyekmai. In nâŋgâyiŋgiŋetâ ârândâŋ otmap. ");
INSERT INTO spl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yeŋgât topyeŋe yawu tap. Nep sâm yiŋgimune ya tuhum pesuk pilânomai yan yuwu sânomai. “Nen hoŋ bawa mansain. Nep sâm ningiop ya konok tuhumain.” Yawu sânomai. Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuŋe Yerusalem kapiân ariwe sâm Galilaia hân tânâmŋambâ arim yaŋak Samaria hân hâlâŋmâ kapi bâiŋehen tap yan ariop. ");
INSERT INTO spl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yâhâ kapi ya ambolipŋe lok nombolân imbât hâk bâle teteyiŋgimu manminiwi. Otmu Samaria gâtŋe lok âlâ hâk bâle tetewaŋgimu manminiopŋe yâk yeŋgâlen torokatmu lok bât nombot nombot hârok yawu otbi. Yâkŋe Yesu ekmâ kâlepŋehembâ kinmâ ");
INSERT INTO spl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","den kârikŋan yuwu sâm ekuwi. “Wâe lok pato, Yesu, gâŋe nâŋgâningihât naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sâŋetâ sâop. “Hotom umai yeŋgâlen ariŋetâ hâkyeŋe eknomai.” Yawu sâm ekyongomu ariwi. Yâhâ mâtâwân arim tatŋetâ hâkyeŋe âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Hâkyeŋe âlepŋe otmu eŋakmâ Samaria gâtŋe ya ikŋiâk âwurem ari Yesuhât gotŋan ba kinmâ heroŋe otbaŋgim mepaeop. ");
INSERT INTO spl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yawu otmu Yesuŋe lohimbi yan kinbi ya yuwu sâm ekyongop. “Lok bât nombot nombot hârok heŋgemyongoan. Yamâ lok nombolân imbât yamâ wonâmbâ? ");
INSERT INTO spl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wongât Samaria gâtŋe yuŋak Anitâ mepaewe sâm âwurem takap?” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yâhâ lok ya yuwu sâm ekuop. “Nâhâlen biwihaŋe kepeiat. Yakât otmâ Anitâŋe nâŋgâhihimu âlepŋe oat. Yakât otmâ lohotŋan bam ari.” ");
INSERT INTO spl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sâp âlâen Parisaio lok nombotŋaŋe Yesu yuwu sâm âikuwi. “Sâp girawuân Anitâŋe tihitnenŋe otmu manman sânduhân mannom?” Sâŋetâ sâop. “Anitâŋe topŋe katmâ tihityeŋe otbuap sâp yan kulem topŋe topŋe ki tetemu ekmâ kiwilinomai. ");
INSERT INTO spl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yakât otmâ yuwu ki sânomai. “Yuân topŋe katmâ tihitnenŋe otbuap. Me endaken topŋe katmâ tihitnenŋe otbuap.” Yawu ki sânomai. Yuwu sâmune nâŋgâŋet. Anitâŋe emelâk tihityeŋe otbe sâm hâŋgânnohomu ge mansan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yawu sâm ekyongomu ariŋetâ hoŋ bawalipŋe yuwu sâm ekyongop. “Hâmbâi sâp âlâen nâ lok bulâŋe âwurem ge tihityeŋe otmune biwiyeŋe sânduk sâekgât biwiyeŋaŋe ya mem mannomai. Gârâmâ sâp yan ki âwurem gemune neknomai. ");
INSERT INTO spl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yawu gârâmâ sâp yan lok nombotŋaŋe yuwu sâm ekyongonomai. “Anitâŋe Yesu hâŋgângumu âwurem ge tihitnenŋe otbuap sâop yamâ emelâk hâŋgângumu ge endaken mansap, me wosaken me wosaken ge mansap.” Yawu sâm ekyongoŋetâ yâk yeŋgât den ya ki nâŋgânomai. Yawu otmâ ki pâinnekmâ âlâen âlâen arinomai. Nâ gewom yan yok pilâm ki gewom. ");
INSERT INTO spl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Himbim belek sâmu laŋinŋaŋe siliŋ siliŋ sâm nombotgembâ nombot otmâ haŋ sâmap yakât dopŋeâk Anitâŋe nâ lok bulâŋe hâŋgânnohomu âwurem gewom. Âwurem gemune lohimbi hânŋan kulemŋan mansai kerekŋe nâhât laŋinŋe ekmâ topŋe nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yâhâ aŋgoânâmâ Yura nengât papatolipnenŋaŋe nâhât hâkâŋ otmâ hâhiwin nihiŋetâ sâtgum mumbom. ");
INSERT INTO spl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yâhâ âwurem gewom yanâmâ pârâk sân sânâk gewom. Yâhâ âwurem gewom yakât sâpŋe tâlâhuwuap yanâmâ orotmeme girawuya otmâ mannomai yakât yuwu sâmune nâŋgâŋet. Emelâk embâŋân lok âlâ, kutŋe Noa sâm, manmu towat teteop dop yawuâk ya tetewuap. ");
INSERT INTO spl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Emelâk Noaŋe manop yanâmâ lohimbi gulip malap manmâ yeŋe âi yeŋahâlâk nâŋgâm manbi. Yawu manŋetâ Noaŋeâmâ waŋga kâlehen yâhâop. Yawu otmâ nen âlepŋe mansainâk sâm gulip malap manmâ gaŋetâ yan Anitâŋe nâŋgâmu toŋgelâk pato gemu to niŋ niŋ sâm lohimbi kerek haranyongomu mum metewi. ");
INSERT INTO spl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yâhâ yakât dopŋeâk lok âlâ, kutŋe Lot sâm, yâkŋe manmu towat teteop dop yawuâk ya tetewuap. Emelâk Lotŋe manop yanâmâ lohimbi gulip malap otmâ soŋgo bau sot kâle nem yeŋahâlâk nâŋgâŋetâ yahalop. Imbi aŋgi guŋgi otbi. Emet opon tuhuwi. Nep topŋe topŋe tuhuŋetâ Lotŋe Sotom kapi ya pilâm ariop. ");
INSERT INTO spl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yawu otmâ nen âlepŋe mansainâk sâm gulip malap manŋetâ Anitâŋe nâŋgâmu himbimâmbâ kâlâpŋe punduŋ sâm ge kapi ambolipŋe kerek sem gulip tuhuyehop. ");
INSERT INTO spl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yakât dopŋeâk lohimbi nombotŋaŋe âlepŋe mansainâk sâm otŋetâ yan Anitâŋe yâhâpŋe nâ hâŋgânnohomu gewom. ");
INSERT INTO spl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sâp yan yuwu otnomai. Lok âlâ me âlâ kapi hâlâŋmâ mannomaiŋe kasalipyeŋe takaŋetâ yekmâ emetyeŋan ki âwurem ari itâ pareŋe menomai. Otmu lohimbi newân kinnomaiŋe kasalipyeŋe takaŋetâ yekmâ âwurem ari emetyeŋan iri sikumyeŋe miaknehât ki nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Emelâk embâŋân himbimâmbâ kâlâpŋe punduŋ sâm ge Sotom kapi ambolipŋe sem gulip tuhuyehop sâp yan Lot imbiŋaŋe kambeŋe kakŋambâ olelem ekmâ kâtembe olop. Yakât den pat yeŋe nâŋgâm hâkyeŋe miaŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yakât otmâ yuwu sâmune nâŋgâŋet. Lok âlâ me âlâŋe manmanyeŋe alitnomai yamâ hiliwahonomai. Yâhâ lok âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim tem lâunihiŋetâ yan lohimbi belângen mansaiŋe yekŋetâ bâlemu yongoŋetâ munomai yamâ Anitâŋe mumuŋambâ mem yahatyekbuap. ");
INSERT INTO spl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sâp gewom yan lok oponân inomai yamâ Anitâŋe nombotŋe ya meyekmâ nombotŋe pilâyekbuap. ");
INSERT INTO spl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yâhâ lohimbi âi kalam tuhum gulip malap mannomai gurâ nombotŋe meyekmâ nombotŋe pilâyekbuap. ");
INSERT INTO spl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yâhâ hat mannomai gurâ nombotŋe meyekmâ nombotŋe pilâyekbuap.” ");
INSERT INTO spl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yawu sâm ekyongomu yuwu sâm âikuwi. “Kutdâ, kapi wonân mem kâsipnongowuat?” Sâŋetâ sâop. “Yâhâ umatŋe âlâlâ tetewuap yakât emet inânŋan ekyongom gaman. Yukât bulâŋe hâmbâi tetewuawân ekmâ topŋe nâŋgâm heŋgeŋgunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuhât hoŋ bawalipŋaŋe hilâm ârândâŋ Anitâ orowâk den otmâ ki lohotŋe otnomaihât den âlâen hâum yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Kiap âlâ lohimbi yeŋgât den sâm hâreyiŋgim yan Anitâhât nâŋgâmu gemu ki ewe katyehop. ");
INSERT INTO spl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Yâhâ kapi amboŋe, imbi kambut âlâ, yakâlen ari sâm guhuŋmâ yuwu sâm ekuminiop. “Âlepŋe den sâm hârerâ imbi âlâŋe mâŋgâenehop yakât matŋe kâpekbaŋgiwom.” ");
INSERT INTO spl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yawu sâm ekuminiop yamâ denŋe ki nâŋgâm gaop. Yawu otmâ gamu sâp kâlep otmu biwiŋaŋe yuwu nâŋgâop. “Anitâhât nâŋgâmune gemap. Otmu lohimbi ki ewe katyekman. ");
INSERT INTO spl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yawu gârâmâ imbi kambut yuŋe haoŋmâ ârândâŋ kâi kâi liŋnihim tatmâ mem kopa tuhunekmapgât ihilâk nâŋgâwaŋgiwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Yâhâ imbi yaŋe kiap ya ekumu tânguop yamâ yuwu. ");
INSERT INTO spl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nen Anitâhât tem lâuwaŋgim manmainŋe haoŋmâ ârândâŋ ulitgum yâhânom otmuâmâ nâŋgâningiwuap. Yâkŋe biwi pâlâmŋe otmâ dennenŋe ki nâŋgâwuapgât dop âlâ ki tap. ");
INSERT INTO spl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ulitgumunŋe in yawu nâŋgâningiwuap. Yawu nâŋgânomai. Yawu gârâmâ Anitâŋe nâ lok bulâŋe hâŋgânnohomu himbimâmbâ âwurem gewom sâp yan lohimbi kiŋgitŋe orowâkŋe nâhâlen biwiyeŋaŋe tiŋâk kepeim mambotnihim mannomai me bia?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Lok nombotŋaŋe yeŋahât nâŋgâŋetâ yahatmu “nen lok âlepŋe, uwawapŋe bia mansain” sâm bukulipyeŋe yeŋgât nâŋgâŋetâ gemap. Lok yawuya yeŋgât nâŋgâm Yesuŋe den âlâen hâum yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Lok yâhâp opon kâmbukŋan yâhâm Anitâ ulitguowot. Âlâmâ Parisaio. Otmu âlâmâ takesi meme lok. ");
INSERT INTO spl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisaio yaŋeâmâ ikŋahât nâŋgâmu yahatmu senŋe ewan pilâm ekmâ yuwu sâop. “O Anitâ, yuwu sâmune nâŋgâ. Lok nombotŋaŋe kapam kumai, kombo otmai, otŋetâ bâlem gap. Nâ yawuya bia. Otmu takesi meme lok endo kinsap nâ endawuya bia. ");
INSERT INTO spl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Hilâm nombolân yâhâp yakât biwiŋan hilâm yâhâp sot barak manmâ nâŋgâhihim mepaehekman. Otmu tewetsenŋe senŋe âlâlâ tatnihiap yakât sâsâŋambâ konok hârem gâhât pat kuhihiman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Otmu takesi meme lok yaŋeâmâ guluŋan kinmâ kâmgum den tâlâwâk yuwu sâop. “O Anitâ, tepge nâŋgânihi. Nâ lok bâleŋe mansanâke yamâ ki pilânekbuat,” yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yakât yuwu sâmune nâŋgâŋet. Anitâŋe takesi meme lok yâkât nâŋgâwaŋgim tosaŋe pilâop. Yâhâ Parisaio yâhâmâ tosaŋe yawuâk tatbaŋgiop. Yâhâ lok âlâ me âlâŋe hâkyeŋe mepaeakmâ manmai yamâ Anitâŋe mem ge katyekbuap. Yâhâ lok âlâ me âlâŋe yeŋahât nâŋgâŋetâ gemu huruŋ huruŋ manmai ya yeŋgât Anitâŋe nâŋgâmu yahatbuap.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sâp yanâmâ lohimbi nombotŋaŋe nan baralipyeŋe meyekmâ Yesuhâlen ariwi. Ari Yesuŋe kunyeŋan mem Anitâ ulitgumu lukuleyehâkgât ekuwi. Yawu otŋetâ hoŋ bawalipŋaŋe yekŋetâ ki ârândâŋ otmu kuyiŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kuyiŋgiŋetâ Yesuŋe nimnaom ekyongomu gaŋetâ hoŋ bawalipŋe yuwu sâm ekyongop. “Kâmbukŋe, ki kuyiŋgiŋet. Anitâŋe nimnaom titipâ yu yeŋgât tihityeŋe otmap. Yakât otmâ dâiyekmâ nâhâlen gaŋet. Yeŋe kuyiŋgiŋetâ ekmune ki ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yakât yuwu sâmune nâŋgâŋet. Nimnaom titipâŋe Anitâhât den nâŋgâm in yawu lâuwaŋgim manŋetâ tihityeŋe otmap. Yakât dopŋeâk yeŋe tem lâuwaŋginomai yanâmâ Anitâŋe tihityeŋe otbuap. Yawu otmâ sâp pato tetewuawân meyekbuap. Yâhâ yawu ki otnomai otmuâmâ Anitâŋe betyongomu belângen tatnomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yawu sâm ekyongomu Yura yeŋgât papatolipyeŋe âlâŋe Yesu yuwu sâm âikuop. “Bawapi, manman koko salek amboŋe mansat. Yakât otmâ sârâ nâŋgâwe. Nâŋe girawu otmune ârândâŋ otmu Anitâŋe manman kârikŋahât pat kunihiwuap?” ");
INSERT INTO spl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sâmu sâop. “Wongât nâhât “Manman koko salek amboŋe” yat? Anitâ konohâk manman koko salek amboŋe tatmap. ");
INSERT INTO spl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yakât otmâ gâŋe âinohoat yakât matŋe yuwu sâmune nâŋgâ. Anitâŋe girem den Mose ekumu kulemguop ya sâlikum nâŋgâmat me bia? Ya yuwu tap. Buku âlâhât imbi ki ekmâ otbuat. Lok nombotŋe ki yongorâ munomai. Kombo ki meyiŋgiwuat. Hakyeŋan ki sâwuat. Den perâk ki sâm kâityongowuat. Âwâ mâmâhe yetgât lauyetŋe lâum amutyetŋan manbuat.” ");
INSERT INTO spl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sâmu sâop. “Bawapi. Girem den sâm arat yuâmâ ŋaŋanambâek lâum manmâ gaman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sâmu sâop. “Yuwu otbuat. Senŋe âlâlâ pato tatgihiap ya kâsikum buku nombotŋe umburuk mansai ya yiŋgiwuat. Yawu otmâ nâhâlen torokatdâmâ Anitâŋe manman kârikŋahât pat kuhihiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yawu sâmu iri sikum me senŋe âlâlâ dondâ tatbaŋgiop yakât nâŋgâmu biwiŋe umatŋe otmu hâmeŋe bâleop. ");
INSERT INTO spl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hâmeŋe bâlemu ekmâ Yesuŋe yuwu sâm hoŋ bawalipŋe ekyongop. “Lok iri sikum pato tatyiŋgiapŋeâmâ Anitâhâlen biwiyeŋaŋe kepeim tem lâuwaŋgine sâm otŋetâ hâi hâiŋe otmap. ");
INSERT INTO spl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yakât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum yuwu sâmune nâŋgâŋet. Pusiŋe seloŋ watmu pin pinŋan arimu yan watmâ ba membe sâm hâum pâpgumap. Yakât dopŋeâk lohimbi iri sikumyeŋe pato tatyiŋgiapŋe Anitâŋe tihityeŋe olâkgât mâtâp ya watmâ arine sâm otŋetâ hâi hâiŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yawu sâmu nâŋgâŋetâ sâtŋe otmu yuwu sâm âikuwi. “Lohimbi girawuyaŋe otŋetâ ârândâŋ otmu Anitâŋe manman kârikŋahât pat kuyiŋgiwuap?” ");
INSERT INTO spl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sâŋetâ sâop. “Anitâhât manman kapiân arine sâm lokgât nâŋgân nâŋgân watmâ arinomaihât dop âlâ ki tap. Yamâ Anitâhât topŋe âlâ tap. Yakât otmâ yeŋe yu me ya otne sâm yâkât nâŋgân nâŋgân watmâ otnomaihât dop tap. Yâkŋe konok manman kârikŋe ya yiŋgimu mem manmâ yâhânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yawu sâmu Petoroŋe yuwu sâop. “Bâe, nenâmâ senŋe âlâlâ kerek betbaŋgim gâhâlen torokatmâ hâhiwin kakŋan manmâ gain.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Sâmu sâop. “Lohimbiŋe nâhâlen biwiyeŋe katŋetgât lok âlâ me âlâŋe nâhât den ekyongonomaiŋe âwâ mâmâlipyeŋe, me imi garilipyeŋe, me imbi naomlipyeŋe, me hep torehenlipyeŋe, me senŋe âlâlâ siminŋe tatyiŋgiap ya kerek pilâm nâhât komolân torokatnomai. ");
INSERT INTO spl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Yawu otmâ nâhât komolân torokatmâ mannomai yanâmâ emelâk hep torehenlipyeŋe orop heroŋe otminiwi ya wangim heroŋe pato kakŋan mannomai. Otmu hâmbâi Anitâŋe meyekmâ manman kârikŋan katyekmu mannomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuŋe hoŋ bawalipŋe kâiân yâhâp meyekmâ yuwu sâm ekyongop. “Yuwu sâmune nâŋgâŋet. Yiwereŋe Yerusalem kapiân yâhânom. Yan yâhâmunŋe emelâk emet inânŋan Anitâhât poropetelipŋaŋe lok bulâŋe nâhât den kulemgum gawi yakât bulâŋe tetewuap. ");
INSERT INTO spl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yâhâ lok âlâŋe nâŋgâm bâlenihim hotom umai otmu Mosehât girem den kâsikum ningimai ya yeŋgât bâtyeŋan katnekbuap. Bâtyeŋan katnekmu den âiân katnekmâ mumbomgât den sâm hârenihinomai. Den sâm hârenihim Roma lok yeŋgâlen katnekŋetâ yâkŋe yuwu otnihinomai. Sennan gem tâpnohom, mem âlâlâ tuhunekŋetâ hâhiwin pato nâŋgâwom. ");
INSERT INTO spl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Otmu benŋe howanân nohoŋetâ mumbom. Mumunŋe hannohoŋetâ hilâm kalimbu pesuk sâmu yakât kakŋan mumuŋambâ yahatbom.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yawu sâm ekyongomu Yerusalem yâhânomai yakât nâŋgâŋetâ biwiyeŋe umatŋe otmu nâŋgâm ketet otbi. ");
INSERT INTO spl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mâtâwân arim tatŋetâ lohimbi kiŋgitŋe orowâkŋe betyeŋan watyekbi. Yawu otmâ ariŋetâ Yeriko kapi tâlâhumu mâtâp ginŋan lok âlâ, senŋe bok sâsâŋe talop. Tatmâ senŋe âlâhât umburuk otmâ yaŋak lohimbi mâtâwân bam gaŋetâ ulityongom tatminiop. ");
INSERT INTO spl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yawu otmâ lohimbi kiŋgitŋe orowâkŋe mâtâp yawuâk ariŋetâ kâiyeŋe munŋe nâŋgâmâmâ yakât âiyongomu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Yesu Nasaret kapiân gâtŋe takap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yawu sâŋetâ nâŋgâm den kârikŋan halahum yuwu sâop. “Yesu Dawitihât sen, gâŋe nâhât wehe nâŋgânihi.” ");
INSERT INTO spl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yawu sâmu lohimbi gotŋan kinbiŋe kuwaŋgiwi. Kuwaŋgiŋetâ witgum halahuop. ");
INSERT INTO spl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Witgum halahumu Yesuŋe nâŋgâm mâtâwân kinmâ “Ekuŋetâ gaek,” sâm lohimbi ekyongop. Ekyongomu senŋe bok sâsâŋe ya lok nombotŋaŋe dâim yâkâlen baŋetâ yuwu sâm âikuop. “Girawu otgihiwehât naŋgat?” Sâmu sâop. “Lok pato, sârâ senne hâreakmu ekbehât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sâmu sâop. “Gâŋe nâhâlen biwihe hikuat. Yakât otmâ den yat ya bulâŋe tetehihiâk.” ");
INSERT INTO spl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yawu sâmu yan senŋe hâreakmu ekmâ Yesu betŋan sâm Anitâ mepaeop. Yawu otmu lohimbiŋe ya ekŋetâ âlâ kândâkdâ otmu yâku yawuâk Anitâ mepaewi. ");
INSERT INTO spl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Yesuŋe Yeriko kapiân yâhâmu lok âlâ, iri sikumŋe pato tatbaŋgiop, kutŋe Sakaio sâm, yâhâmâ takesi meme lok yeŋgât kunyeŋe manminiop. ");
INSERT INTO spl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yâhâmâ lok tâlâwâk yakât otmâ lohimbi hohetyeŋan kinmâ tik sâm Yesu ekbe sâm otmu ki ihiop. ");
INSERT INTO spl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yakât otmâ yahatmâ wangiyekmâ sururuk sâm ari nak âlâ mâtâp ginŋan kinop ya lâum pitik pitik yâhâ kakŋan tatmâ biwiŋaŋe yuwu nâŋgâop. “Yesu yupâ gam bamu ekbom.” ");
INSERT INTO spl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yawu nâŋgâm tatmu Yesuŋe nak amutgen ga kinmâ senŋe pilâm ewun Sakaio ekmâ yuwu sâm ekuop. “Sakaio, âun gâhât emelan yâhâ tatmâ nâŋgâwom. Yakât otmâ in yawu pilâm gerâ arine.” ");
INSERT INTO spl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yawu sâm ekumu pilâm ge heroŋe otmâ dâimu emetŋan ariowot. ");
INSERT INTO spl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Emetŋan ari yâhâmutâ lok kerekŋe ekŋetâ bâlemu sâm guhuŋmâ yuwu sâwi. “Wongât otmâ Yesuŋe lok bâleŋahât emelan yahap? Ya ki orotŋe.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yâhâ Sakaioŋe Yesu yuwu sâm ekuop. “Kutdâ, sâmune nâŋgâ. Tewetsenŋe me senŋe âlâlâ tatnihiap ya mem hioŋmâ lohimbi umburuk mansai ya kâsikum yiŋgiwom. Otmu lohimbi kâityongom yeŋgât tewetsenŋe konok meyiŋgiwan gârâmâ yakât matŋeâmâ nâŋe imbât yiŋgiwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Sâmu sâop. “Lohimbi bâleŋe hem nâpumân ge hiliwahomaihât nâŋgâm Anitâŋe nâ lok bulâŋe hâŋgânnohomu gewan. Yawu gârâmâ lohimbiŋe nâhâlen biwiyeŋaŋe kepeiŋetâ yanâmâ manman kârikŋahât pat kuyiŋgiwuap. “Yâhâ gâ Awaraham sen. Gâŋe nâhâlen biwihaŋe kepeiat. Yakât otmâ Anitâŋe manman kârikŋahât pat kuhihiap. ");
INSERT INTO spl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yeriko kapi ya pilâm Yerusalem kapi gotŋan ariwi. Yesuhât den nâŋgâm lohimbi orowâk ariwi yaŋe biwiyeŋaŋe yuwu nâŋgâwi. “Anitâŋe Yesu mâmâŋe otbaŋgimu kasalipnenŋe watyekmu arinomai. Yâkŋe yawu otmâ manman sânduhân katnenekbuap yakât sâpŋe tâlâhuap.” ");
INSERT INTO spl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Biwiyeŋaŋe yawu nâŋgâwi yakât otmâ Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Lok kutdâ âlâŋe lok âlâ mem kânâŋgâmu yâkŋe lohimbi galemyongowuapgât sâpŋe tâlâhuop. ");
INSERT INTO spl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yawu otmâ lok yaŋe lok kutdâŋahâlen ariwe sâm âi loklipŋe bâlâk ŋerek yongonmu gaŋetâ tewetsenŋe kina bâlâk ŋerek ya ârândâŋâk yiŋgim yuwu sâm ekyongop. “Pilâyekmâ kâlepŋehen ariwom. Yawu gârâmâ tewetsenŋe yiŋgian yuŋe mem âi tuhuŋetâ tewetsenŋe tetewuap yakât dopŋe âwurem takamune tiripnohoŋetâ ekbom.” ");
INSERT INTO spl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yawu sâm pilâyekmâ ariop. Yâhâ lohimbi nombotŋaŋe lok yakât hâkâŋ otmâ galemyeŋe ki olâkgât nâŋgâm lok hoŋ hâŋgânyongoŋetâ lok kutdâyeŋahâlen ari yakât denŋe sâwi. ");
INSERT INTO spl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Denŋe sâŋetâ lok kutdâyeŋaŋe ki nâŋgâyiŋgiop. Yawu otmâ lok yawuâk galem sâm kânâŋgâop. Yawu gârâmâ lok kapi kâlepŋehen ariop yaŋe âwurem taka âi loklipŋe tewetsenŋe yiŋgiop ya yongonmu gaŋetâ âlâku ikŋiâk ikŋiâk yuwu sâm âiyongop. “Tewetsenŋe yiŋgiwan yaŋe mem âi tuhuŋet amon teteap?” Yawu sâm âiyongop. ");
INSERT INTO spl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yâhâ âi lok aŋgoân gaopŋe yuwu sâop. “Lok pato. Gâŋe kina bâlâk ŋerek nihion yaŋe mem âi tuhumune âlâku kina bâlâk ŋerek teteop.” ");
INSERT INTO spl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Sâmu sâop. “Âlepŋe, tewetsenŋe tipiŋe gihiwan yaŋe mem âi tuhurâ âiloŋgo teteap. Yakât otmâ nâŋe galem katgekmune kapi bâlâk ŋerek ya ambolipŋe galemyongowuat.” ");
INSERT INTO spl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yawu sâmu hoŋ bawa âlâŋe gam sâop. “Lok pato. Gâŋe kina bâlâk ŋerek nihion yaŋe mem âi tuhumune âlâku kina bâtnombot teteop.” ");
INSERT INTO spl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Sâmu sâop. “Âlepŋe, nâŋe galem sâm katgekmune kapi bâtnombot ya galemyongowuat.” ");
INSERT INTO spl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Yawu sâm ekumu arimu hoŋ bawa âlâŋeâmâ ga sâop. “Lok kutdâ, pato, gâhât topge nâŋgâm heŋgeŋguan. Gâ lok sâtŋe. Lok âlâ me âlâŋe gâhât nep kâmetŋetâ âlemap yamâ gikahâk nemat. Yawu otmat yakât sâŋetâ nâŋgâman. Yakât otmâmâ gâhât kiŋgitnahât otmâ tewetsenŋe nihion ya biatgihimap sâm sâŋgumnaŋe kurihim katmune tatmap.” Yawu sâm kina bâlâk ŋerek ya amboŋahât bâtŋan kalop. ");
INSERT INTO spl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sâmu sâop. “Gâ lok konam. Gikak den yat yawuâk mem purik pilâhihiwe. Sâmune nâŋgâ. Lok âlâ me âlâŋe nâhât nep kâmetŋetâ âlemap yamâ ninahâk neman yawu sâŋetâ naŋgat. ");
INSERT INTO spl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yakât otmâ tewetsenŋe gihiwan yu mem kât emetŋan katdâ tatmu tewetsenŋe âlâkuâk teteop mâne nâŋgâmune ârândâŋ otbâp.” ");
INSERT INTO spl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yawu sâm ekum lohimbi yan kinbi yuwu sâm ekyongop. “Bukuŋaŋe kina bâlâk ŋerek mem kinsapŋe nâhât tem lâum âi tuhum gap. Yakât otmâ lok yukât bâtŋambâ kina bâlâk ŋerek ya mem bukuŋe waŋet.” ");
INSERT INTO spl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sâmu sâwi. “Yawu gârâmâ emelâk kina bâlâk ŋerek miap.” ");
INSERT INTO spl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Sâŋetâ sâop. “Yuwu sâmune nâŋgâŋet. Anitâŋe lok âlâ me âlâ âi sâm yiŋgimu biwiyeŋaŋe kepeim tuhumai yâhâmâ tâtâem mâmâŋe otyiŋgimu âiloŋgoâk tuhumai. Yawu gârâmâ lok âlâ me âlâ âi sâm yiŋgimu ki tuhumai yâhâmâ betyongomap. ");
INSERT INTO spl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yâhâ nâŋe galemyeŋe ki manbehât yeŋe lok kutdânenŋahâlen ari denne sâwi. Yawu gârâmâ lok ya ekyongoŋetâ yuân ga sennenŋanâk yongoŋetâ muŋet.” Yawu sâm ekyongop.” Yesuŋe den yan hâum ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuŋe hoŋ bawalipŋe meyekmâ yapâ ariŋetâ lohimbi kiŋgitŋe orowâkŋe betyeŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yawu otmâ ari Yerusalem kapi pato yakât gotŋan kapi yâhâp, kutyetŋe Betepahe otmu Betani sâm, ya Oliwa pumŋan tap yan yâhâwi. ");
INSERT INTO spl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yan yâhâ Yesuŋe hoŋ bawayâhâtŋe yâhâp yuwu sâm hâŋgânyotgop. “Kapi tipiŋe ewapâ tap yan doŋgi nanŋe âlâ hikum katŋetâ kinsap ya lok ki kakŋan tatmai. Ya holaŋmâ mem geromawot. ");
INSERT INTO spl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Holaŋmutâ lok âlâŋe yuwu mon sâm âiyotgowuap. “Yet wongât taka yu holaŋsawot?” Yawu sâmuâmâ yuwu sâm ekuromawot. “Yiwereŋe âi teteap. Yakât otmâ patonetŋaŋe yu mendehât hâŋgânnotgomu takait.” Yawu sâm ekuromawot. Yesuŋe yawu sâm hâŋgânyotgomu yâhâ ekyotgop yawuâk mem teteowot. ");
INSERT INTO spl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Doŋgi nanŋe emet âlâ hawiŋan hikum katbi ya holaŋowot. Holaŋmutâ amboŋaŋe yelekmâ sâop. ");
INSERT INTO spl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","“Bâe. Yet âlâŋe sâmu yu holaŋde sâm oawot?” ");
INSERT INTO spl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","35","Sâmu sâowot. “Yiwereŋe âi teteap. Yakât otmâ patonetŋaŋe yu mendehât hâŋgânnotgomu takait.” Yawu sâm ekumutâ nâŋgâyitgimu holaŋmâ mem giowot. Mem ge yetŋe hâk katipŋe kâlep kalowot ya holaŋmâ lotohom kakŋan kalowot. Katmutâ kakŋan yâhâ talop. ");
INSERT INTO spl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yâhâ tatmu Yerusalem kapiân yâhâwi. Yâhâŋetâ lohimbi kiŋgitŋe orowâk hâruhuakbiŋe Yesuhât nâŋgâŋetâ yahatmu yeŋe hâk katipŋe kâkâlep ya holaŋmâ mâtâp tete liŋgatmâ ariwi. Liŋgatmâ ariŋetâ doŋgi yaŋe ya kakŋan tâlim tâlim ariop. ");
INSERT INTO spl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yâhâ Yerusalem kapi pato ya tâlâhumu Oliwa pumŋe yakât talapŋan gewi. Geŋetâ kulem âlâlâ tuhumu ekmâ gawiŋe yakât nâŋgâm heroŋe otbaŋgim Anitâ mepaem den kârikŋan halahum yuwu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Gâmâ tâmbânenŋe Dawiti sen. Gike ombeheâk ki takat. Anitâŋe âi sâm gihiop ya lâum kinmâ nengâlen mat takat. Yakât otmâ heroŋe otgihim mepaeheksain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yawu sâm mepaeŋetâ Parisaioŋe yuwu sâm Yesu ekuwi. “Lok pato, mepaehekmâ mansai ya kuyiŋgirâ hutuk sâŋet.” ");
INSERT INTO spl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sâŋetâ sâop. “Nâŋe kuyiŋgimune hutuk sânomaiâmâ kât yuŋe âlepŋe heroŋe otnihim den sâm mepaeneknomai.” ");
INSERT INTO spl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yerusalem kapi ginŋan ari tatmâ ekmâ tepŋe nâŋgâm isem yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“O, kapi ambolipŋe. Biwi sânduhân manne sâm yakât mâtâpŋe yiwereŋe teteap yamâ ekŋetâ ki keterakyiŋgiap. ");
INSERT INTO spl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Yiwereŋe Anitâŋe wawaeyekmâ tihityeŋe otbe sâm hâŋgânnohomu takanâke yamâ nâhât nâŋgânihiŋetâ tâŋât oap. Yakât matŋe sâp âlâen kasalipyeŋaŋe taka hawamyongom mâtâp maŋguyiŋginomai. Mâtâp maŋguyiŋgim paŋ kârikŋe tap enda limbâroŋgum ge emetyeŋe huhum gahaem itit kiom tuhuyiŋgim yongoŋetâ munomai. Yawu otyiŋgiŋetâ kapi yuŋe kâwurumŋaŋak kinbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yawu sâmu Yerusalem kapi patoen yâhâwi. Yâhâŋetâ Yesuŋe doŋgi kakŋambâ kioŋmu yaŋak yapâ opon kâmbukŋan yâhâwi. Yâhâ opon kâmbukŋe kâlehen lohimbiŋe senŋe âlâlâ aŋgi guŋgi otmâ kinbi ya yekmâ Yesuŋe nâŋgâm bâleyiŋgim yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Yu oai yukât emet inânŋan Anitâŋe poropete âlâ ekumu kulemguop ya yuwu tap. “Lohimbi hânŋan kulemŋan manmâ araiŋe nâhât opon yukât kâlehen yâhâ mepaeneknomai.” Den sâop yakât yuwu sâmune nâŋgâŋet. Yeŋe yukât kâlehen tatmâ lohimbi kâityongom hâmeŋe mem yahatmâ aŋgi guŋgi otmâ gai. Yawu otmâ gai yu ekmune aŋgim bero emetŋe yawuya oap. Opon kâmbukŋe yu kâlehen ki orotŋe otŋetâ ekmune bâleap.” Yawu sâm watyekmu yahatmâ tiok taok otmâ arim kinbi. ");
INSERT INTO spl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Otmu hilâm ârândâŋ Yesuŋe opon kâmbukŋan yâhâ lohimbi den kâsikum yiŋgiop. Yawu otmu hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum yiŋgiminiwi otmu Yura yeŋgât papatolipyeŋaŋe Yesu kune sâm otbi. ");
INSERT INTO spl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yawu gârâmâ lohimbi kiŋgitŋe orowâkŋe Yesuhât denŋe nâŋgâŋetâ âlâ kândâkdâ otmu mem hawam mewam tuhum kinbi. Yakât otmâ kune sâm hâum pâpgum pilâwi. ");
INSERT INTO spl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sâp âlâen Yesuŋe opon kâmbukŋan yâhâ kinmâ ikŋe den pat âlepŋe lohimbi kâsikum yiŋgiop. Sâp yan hotom uminiwi ya yeŋgât kunlipyeŋe, otmu Mosehât girem den kâsikum yiŋgiminiwi, otmu Yura yeŋgât papatolipyeŋaŋe yâkâlen ba yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Gâŋe oran âlâhât sâtgât otmâ Anitâhât opon kâmbukŋan yâhâ lohimbi watyehon?” Yawu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sâŋetâ sâop. “Yeŋe âinohoai gârâmâ nâku âiyongowe. Âiyongomune den matŋe kâpeknihiŋetâmâ nâŋe âlâhât sâtgât âi yu mem gaman yakât topŋe ekyongowom. ");
INSERT INTO spl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yakât yuwu sâmune nâŋgâŋet. Yoaneŋe âlâhât sâtgât otmâ lohimbi toen katyehop? Anitâhât me ondop yeŋgât sâtgât otmâ âi ya tuhuop? Ya sâŋetâ nâŋgâwe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yawu sâmu matŋe kâpekbaŋgine sâm pâpgum alahu gulahu otmâ yuwu sâwi. “Nenŋe yuwu mon sânom. “Yoaneŋe âi miop yamâ Anitâŋe âi sâm waŋmu tuhuop.” Yawu sânom yamâ matŋe yuwu mon sâwuap. “O, yenâmâ girawu otmâ Yoanehât den nâŋgâŋetâ ki bulâŋe olop?” Yawu sâmu nenŋe matŋe girawu sâm kâpekbaŋginom? Aŋulaknom yakâ. ");
INSERT INTO spl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Otmu âlâ yuwu mon sânom. “Yâhâmâ lok yeŋgât sâtgât otmâ âi ya miop.” Yawu sânom yamâ lohimbi dondâŋe “Yoaneŋe Anitâhât poropete manmâ yâkât sâtgât âi mem manop,” yawu nâŋgâmai yakâ. Yakât otmâ nenŋe yawu sânom yanâmâ lohimbi kinsai yuŋe nâŋgâm nongonomai yakâ.” Yawu nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yawu nâŋgâm yuwu sâm ekuwi. “Yoaneŋe âlâhât sâtgât âi meminiop ya nen ki naŋgain.” ");
INSERT INTO spl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sâŋetâ sâop. “Nâku yawuâk. Nâŋe âlâhât sâtgât âi yu mem gaman yakât ki ekyongowom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Lok pato âlâŋe wain kâmetŋet sâm nep lok meyehop. Meyekmu ari dâmân sâhâm hawamgum wain kâmetbi. Otmu wain toŋe ya mem mendâreŋetâ gewuapgât waŋga hâwiwi. Âi ya tuhum tiŋ pilâŋetâ nep ya galemgunomai sâm katyekmâ ikŋe âlâengen ari sâp kâlep manop. ");
INSERT INTO spl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ari sâp kâlep manmu wain kehetŋe ya puru pato kinmâ hululuŋ sâop. Yawu otmu amboŋaŋe ikŋahât hâruhunihiŋet sâm hoŋ bawa âlâ yakembâek hâŋgângumu takaop. Takamu wain galemŋe manbiŋe kum watŋetâ âwurem ariop. ");
INSERT INTO spl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Âwurem arimu yawuâk kalam amboŋaŋe hoŋ bawa âlâ hâŋgângumu takaop. Hâŋgângumu takamu arimu yâk gurâ yawuâk kum mem âlâlâ tuhuŋetâ âwurem ariop. ");
INSERT INTO spl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Âwurem arimu yawuâk kalam amboŋaŋe hoŋ bawaŋe kalimbuŋe hâŋgângumu takamu yawuâk mâŋgâeŋetâ âwurem ariop. ");
INSERT INTO spl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Âwurem arimu kalam amboŋaŋe “Giratbe” sâm nâŋgâop. Nâŋgâmu tetemu biwiŋaŋe yuwu nâŋgâop. “Nine nanne ombe bisine hâŋgângumune arimu ekmâ yanâmâ ewe katnomai.” Biwiŋaŋe yawu nâŋgâm ikŋe nanŋe hâŋgângumu takaop. ");
INSERT INTO spl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hâŋgângumu takamu ekmâ yuwu sâwi. “Bâe, yuâmâ patonenŋe ikŋe nanŋaŋe takap. Âwâŋe mumu yan kalam yuâmâ yâkŋe ambokuwuap. Yakât otmâ kumunŋe muâk. Kumunŋe mumu yanâmâ kalam yuâmâ nengât otbuap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yawu sâm kum kekae topŋehen pilâŋetâ iop. “Yawu otŋetâ kalam amboŋaŋe taka girawu otbuap? ");
INSERT INTO spl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yâkŋe taka yongomu muŋetâ lok ondop meyekmâ kaweyeŋan katyekmu kinnomai.” Yawu sâop. Yawu sâm ekyongomu nâŋgâŋetâ porap otmu “Yawu ki otyiŋgiwuap yakâ” sâwi. ");
INSERT INTO spl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yawu sâŋetâ yuwu sâm âiyongop. “Anitâhât poropete âlâŋe den kulemguop yukât topŋe eknohoŋetâ nâŋgâwe. “Nep lokŋe emet tuhum nak âlâ ekŋetâ bâlemu mem ketetbi. Mem ketetbi ya Anitâŋe lâum kânâŋgâmu kuhupin kârikŋe otmâ kinsap.” Yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yâhâ lok âlâ me âlâŋe kuhupin yu ekmâ betbaŋginomai yamâ hâhiwin nâŋgânomai. Yawu gârâmâ kuhupin yuŋe putuk sâm kioŋmâ yongowuap yamâ dâk dâk hutuk yongomu munomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesuŋe den âlâen hâum sâop yuŋe hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum yiŋgiminiwi ya yeŋgât topyeŋe miop. Yakât nâŋgâŋetâ biwiyeŋan tâlimu Yesu mem pâi emetŋan katne sâm otbi. Yawu otbi yamâ lohimbi dondâ yan kinbiŋe Yesuhât nâŋgâŋetâ yahalop. Yakât otmâ yâk yeŋgât nâŋgâm gorâyiŋgimu pilâm Yesuŋe den sâm tâpikguwuap nâŋgâm yakât ekmâ kinbi. ");
INSERT INTO spl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yâhâ Yesuŋe sâm tâpikguwuap yanâmâ mem Roma lok yeŋgât bâtyeŋan katŋetâ yâkŋeâmâ mem pâi emetŋan katŋetâ talâkgât nâŋgâm lok perâkŋe nombotŋe meyekmâ tewetsenŋe yiŋgim eŋgatyeŋan gewi. Eŋgatyeŋan geŋetâ yâkŋe Yesuŋe den sâm tâpikguâkgât yâkâlen ari topyeŋe kurihiakmâ yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","“Bawapi, gâhât topge naŋgain. Gâŋe den imbiâk ki sâmat. Den sâmat yamâ nâŋgâmunŋe bonŋeâk otmap. Otmu lohimbiŋe gâhât girawu nâŋgâhihiai yakât nâŋgâm ki gorâhihimap. Gâŋe lok âlâhât nâŋgârâ yahatmu âlâhât nâŋgârâ gemu yawu ki otmat. Otmu manman girawu manmunŋe Anitâŋe nenekmu ârândâŋ otbuap yakât den tâŋ tâŋâk eknongomat. ");
INSERT INTO spl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yakât otmâ wuân me wuân otnom yakât sârâ nâŋgâne. Roma lok âlâŋe kunnenŋe mansap, kutŋe Sisa sâm, yâhâmâ haoŋmâ ârândâŋ takesi waŋmain. Yawu gârâmâ yawuâk waŋmâ yâhânom me bia? Yakât sârâ nâŋgâne.” ");
INSERT INTO spl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yawu sâm âikuŋetâ biwiyeŋahât topŋe nâŋgâm yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kât nanŋe âlâ mem nihiŋetâ ekbe.” Yawu sâop. Yawu sâmu waŋetâ mem tiripyongom yuwu sâop. “Kât nanŋe yu ekŋet. Âlâhât towat kât nanŋe yuân tap? Me âlâhât kutŋe tap?” Sâmu sâwi. “Roma lok patonenŋe, kutŋe Sisa, yakâ.” ");
INSERT INTO spl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sâŋetâ sâop. “Sisahât pat sâm sâsâŋe sâm yu ya katŋetâ tap otmuâmâ yâk waŋnomai. Yâhâ Anitâhât pat sâm katŋetâ tatmap yâk waŋnomai.” ");
INSERT INTO spl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yawu sâm ekyongomu nâŋgâŋetâ sâtŋe otmu den biaek kinbi. Yawu otmâ Yesuŋe lohimbi senyeŋan kinmâ sâm tâpikgumu mem Roma lok yeŋgât bâtyeŋan katne sâm otbi yamâ pâpgum pilâm ariwi. ");
INSERT INTO spl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sarukaio lok yuwu nâŋgâmai. “Anitâŋe mumuŋambâ mem yahatnenekbuapgât dop âlâ ki tap. Yakât otmâ mumunŋe pesuk sâmap.” Yawu nâŋgâmai. Yâkŋe yakât topŋe nâŋgânehât Yesuhâlen ari yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Bawapi, aŋgoân Moseŋe den kulemguop ya yuwu tap. “Lok âlâŋe imbi âlâ memu naom ki mewaŋgimu lok ya mumbuap. Mumu imiŋaŋe yâkât kambut ya galemgum yâkât welâmân nimnaom mem ga katyekbuap.” Moseŋe yawu kulemguop tap. Yakât topŋe sâm eknongohât yuwu sâmunŋe nâŋgâ. ");
INSERT INTO spl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Imi ata nombolân yâhâp manbi. Manmâ aŋgoân atayeŋe kunŋaŋe imbi memu imbiŋaŋe naom ki mewaŋgimu inâk manmâ muop. ");
INSERT INTO spl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mumu imiŋaŋe ataŋahât kambut ya mem manmâ yâku inâk muop. ");
INSERT INTO spl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Otmu imiyetŋaŋe kambutyetŋe ya mem manmâ yâku yawuâk naom barahâk muop. Otmu imi ata ya hârokŋe kambutyeŋe yawuâk mem manmâ inâk muwi. ");
INSERT INTO spl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aiop, kambutyeŋe yâku yawuâk muop. ");
INSERT INTO spl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Imi ata nombolân yâhâp ya kerekŋe imbi ya mewi. Gârâmâ sâp pato tetemu Anitâŋe mumuŋambâ mem yahatnenekbuap yanâmâ imbi yamâ âlâŋe membuap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sâŋetâ sâop. “Hânân yuân imbi aŋgi guŋgi otmâ miakmâ manmai. ");
INSERT INTO spl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yâhâ Anitâŋe lohimbi mumuŋambâ mem yahatyekmu manman kârikŋan mannomai. Sâp yanâmâ himbimân Anitâhât aŋelolipŋaŋe ki miakmai ya yeŋgât dop otmâ yeŋe ikŋiâk ikŋiâk mannomai. ");
INSERT INTO spl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anitâŋe nine nanne baratne sâm lohimbi meyekmu aŋelolipŋe yeŋgât dop otmâ manman kârikŋan mannomai. ");
INSERT INTO spl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yâhâ Anitâŋe mumuŋambâ mem yahatyekbuap yakât topŋe yuwu sâmune nâŋgâŋet. Nak topŋan kâlâp semu laŋ laŋ sâop yakât den pat Moseŋe kulemguop. Den kulemguop yan Kutdâhât yuwu kulemguop. “Yâhâmâ Awaraham, otmu nanŋe Isaka, otmu seseŋe Yakop yâk yeŋgât kunyeŋe tatmâ gamap.” Yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Den kulemguop yakât topŋeâmâ yuwu. Emelâk nengât tâmbâlipnenŋe manmâ gawi. Otmu yapâ torokatmâ manmâ gaŋetâ gaŋetâ benŋe nen yu mansain yu. Otmu gâmâlâk nengât sen tetem mannomai. Nen kerek nengât kunnenŋe yamâ Anitâ. Topŋe yawu tap. Yamâ yeŋe den ya nâŋgâŋetâ keterakyiŋgimbâp.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Yawu sâmu den âlâhât ekune sâm otŋetâ umatŋe otmu pilâm Mosehât den kâsikum yiŋgiminiwi nombotŋaŋe yuwu sâm ekuwi. “Bawapi, den purik pilâningim eknongoat yakât nâŋgâmunŋe ârândâŋ oap.” Yawu sâm ekuwi. ");
INSERT INTO spl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yawu gârâmâ Yesuŋe yuwu sâm âiyongop. “Anitâŋe hâŋgângumu ge tihitnenŋe otbuap yamâ Dawitihât senâmbâ tetewuap.” yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yawu gârâmâ Dawiti ikŋak yuwu sâop. “Anitâŋe nâhât patone yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Gâŋe nâhât gotnan ga kinmâ nâhât hahit mem kasalipge yongom mem ge katyekbuat.” Yawu sâop.” ");
INSERT INTO spl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawitiŋe den yawu sâop yakât yuwu sâmune nâŋgâŋet. Anitâŋe hâŋgângumu gewuap yakât Dawitiŋe yuwu sâop. “Yamâ patone,” sâop. Yawu gârâmâ yeŋeâmâ “Yâkŋe hâmbâi ge galemnongowuap,” sâmai. Den sâmai yamâ Dawitiŋe den sâop ya orop ki lâuaksawot. Yakât nâŋgâmune keterahâkgât yeŋe eknohoŋetâ nâŋgâwe.” Yawu sâop. Yawu sâm âiyongomu matŋe sâne sâm hâum pâpgum pilâwi. ");
INSERT INTO spl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yâhâ lohimbi yan kinbiŋe denŋe nâŋgâm biwi golâek manŋetgât den kârikŋan yuwu sâm hoŋ bawalipŋe ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Lohimbi nombotŋaŋe nenekŋetâ yahalâkgât Mosehât girem den kâsikum ningimaiŋe sâŋgumyeŋe kâkâlep mânuŋakmâ yaŋe holuŋ holuŋ sâmu yâhâm gemai. Otmu yeŋahât nâŋgâŋetâ yahatmu miti emetŋan yâhâ senŋanâk tatnehât nâŋgâmai. ");
INSERT INTO spl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yawu otmai yamâ imbi kambut emetyeŋambâ watyekmâ senŋe âlâlâyeŋe kombo meyiŋgimai. Yawu otmâ topyeŋe kurihiakmâ lohimbi senyeŋan kinmâ Anitâ hâkyeŋaŋak mepaemai. Yawu otmai yakât otmâ Anitâŋe matŋe amokŋan yiŋgimu menomai. Yâk yeŋgât topyeŋe yawu tap yakât otmâ yâkŋe biwiyeŋan kioŋmaihât biwiyeŋe galemahom mannomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yawu sâm ekyongomâmâ Yesuŋe senŋe pilâm lohimbi iri sikumyeŋe pato tatyiŋgiopŋe tewetsenŋe mem kondoân katmâ ariŋetâ yehop. ");
INSERT INTO spl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Katmâ ariŋetâmâ imbi kambut âlâ senŋe âlâlâhât umburuk otmâ manopŋe tewetsenŋe nanŋe kuriŋ kuriŋ yâhâp mem yâhâ kalop. ");
INSERT INTO spl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Katmu Yesuŋe ekmâ hoŋ bawalipŋe yuwu sâm ekyongop. “Lok iri sikumyeŋe pato tatyiŋgiapŋe tewetsenŋe nombotŋeâk katsai. Yâhâ imbi kambut yuŋeâmâ nanŋe kuriŋ kuriŋ yâhâp kârikŋe tatbaŋgimap ya bâiŋe katsap. Yakât otmâ Anitâŋe imbi kambut yu ekmu âiloŋgo oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yawu sâmu lohimbi kinbi nombotŋaŋe opon kâmbukŋe ekŋetâ âiloŋgo otmu yuwu sâwi. “Anitâhât opon kâmbukŋe yu senŋe âlâlâ kârikŋaŋak tuhuwi yu ekmunŋe âiloŋgo loŋgo otmâ sem sereakmâ iap.” ");
INSERT INTO spl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yawu sâŋetâ Yesuŋe yuwu sâm ekyongop. “Opon kâmbukŋe yu ekŋetâ âiloŋgo loŋgo oap yuâmâ hâmbâi kasalipyeŋaŋe taka huhum itoŋ galaŋ mem senŋe âlâlâ kâlehen tap yu mem ihilâk mahilâk tuhunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sâmu sâwi. “Bawapi, gâŋe opon kâmbukŋahât den eknongoat yakât bonŋe sâp girawuân tetewuap? Otmu tetewe sâm otbuap yan wuân kulem tetemu ekmâ nâŋgâmunŋe keterakningiwuap?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sâŋetâ sâop. “Lok nombotŋaŋe taka den perâkŋe yuwu sâm kâityongonomai. “Nâmâ Anitâŋe hâŋgânnohomu ge mansan,” yawu sânomai. Me yuwu mon sânomai. “Sâp pesuk sâwomap. Yakât otmâ nâhâlen torokatmâ tem lâunihiŋetâ nep menom,” yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Otmu sâp yan kapam gotyeŋan me kâlepŋehen, me wosapâ wosapâ tetewuap yakât nâŋgâm ki gorâyiŋgiwuap. Yawu tetemu yanâmâ “Anitâŋe emelâk sâm kalop yakât bulâŋe teteap,” yawu nâŋgânomai. Otmu kapam topŋe topŋe tetemu yan yeŋe nâhâitŋe “Getek âwurem gewomap,” yawu ki nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aŋgoân lohimbi hânŋan kulemŋan mansai dondâhâlâkŋe kasa oraŋgim ahonomai. ");
INSERT INTO spl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Otmu himbimâmbâ kulem topŋe topŋe tetemu yan umatŋe âlâlâ yuwu teteyiŋgiwuap. Hânŋan kulemŋan mososoŋ awawi guwawi membuap. Po pato teteyiŋgiwuap. Mesek topŋe topŋe teteyiŋgimu lohimbi dondâhâlâkŋe munomai. ");
INSERT INTO spl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yawu gârâmâ umatŋe âlâlâ sâm aran yu ki tetewuap yan mitihât kasaŋe nâhât den pat âlepŋe nâŋgâŋetâ gemu hakyeŋan sâm den âiân katyeknomai. Den âiân katyekmâ mem âlâlâ tuhuyekmâ hâhiwin yiŋginomai. Otmu yeŋe miti emetŋan yâhâ nâhât den pat âlepŋe ya ekyongoŋetâ yâkŋe nâŋgâŋetâ ki bulâŋe otbuap. Yawu otmâ meyekmâ lok kunlipyeŋaŋe den sâm hâreyiŋgiŋetgât yâk yeŋgât senyeŋan katyekŋetâ kinnomai. ");
INSERT INTO spl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yâk yeŋgât senyeŋan kinmâ yeŋe nâhât den pat âlepŋe sâm tetem ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sâp yan “Den mâtâpŋe girawu watmâ ekyongomunŋe nâŋgâŋetâ keterakyiŋgiwuap” yakât ki nâŋgâm gorâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sâp yanâmâ nâŋe den âlâlâ nâŋgân nâŋgânyeŋan katmune lauyeŋe heweweŋ otmu den pat âlepŋe sâm kusânmâ ekyongonomai. Sâm kusânmâ ekyongoŋetâ kasalipyeŋaŋe denyeŋe ya kuyiŋgine sâm hâum pâpgunomai. Yakât ki nâŋgâm kiwiliŋ otnomai. ");
INSERT INTO spl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Sâp yan yeŋe nâ orop biwinenŋaŋe kepeakmâ konohâk otmu mannomai yakât nâŋgâm âwâ mâmâlipyeŋe, imi atalipyeŋe, wârâ toulipyeŋe, hep torehenlipyeŋe, bukulipyeŋe, otmu lohimbi kerekŋe nâŋgâyiŋgiŋetâ gemu hakyeŋan sâm den âiân katyeknomai. Den âiân katyekmâ nombotŋe yongoŋetâ munomai. ");
INSERT INTO spl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Yawu otyiŋgiŋetâ yanâmâ hâkyeŋe ki biuk sâwuap. Yeŋe kârihem kinmâ ki betnohonomai yanâmâ Anitâŋe meyekmâ manman kârikŋan katyekmu mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesuŋe torokatmâ yuwu sâm ekyongop. “Kasalipyeŋe yeŋgât hep bero kiŋgitŋe orowâkŋe taka Yerusalem kapi hawamgum kinŋetâ kapi ambolipŋaŋe yekmâ yuwu nâŋgânomai. “Nongom itit kiom tuhunenekne sâm takai mon?” Yawu nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yerusalem kapi hawamgum kinŋetâ yekmâ Yuraia hânân kapi tatmâ arap ya ambolipŋaŋe pilâm itoŋ galaŋ otmâ hewukŋehen ari misiŋguraknomai. Otmu Yerusalem kapi ambolipŋaŋe gurâ yawuâk sururuk sâm ari misiŋguraknomai. Yâhâ nep tuhuakmâ mannomaiŋe âwurem taka kapiân iri sikumyeŋe miaknehât ki nâŋgânomai. Yekmâ yapâek hewukŋehen ari misiŋguraknomai. ");
INSERT INTO spl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sâp yan Yura lohimbiŋe otŋetâ bâlemap yakât matŋe menomai yakât nâŋgâm emelâk emet inânŋan miti pepaen kulemguwi. ");
INSERT INTO spl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Imbi tepdâ umat karat mannomai, otmu ŋaŋa hewâk hewâhâk mem hikakmâ manŋetâ wâtyeŋe ki tiŋ tiŋ sâwuap yaŋe hewukŋehen arine sâm otŋetâ ki ihiwuap. Sâp yan umatŋe pato nandoroŋe kakyeŋan yâhâwuap. ");
INSERT INTO spl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nombotŋe yongoŋetâ munomai. Yâhâ nombotŋe âlâmâ hikum meyekmâ kapi âlâengen ariŋetâ hoŋ bayiŋgim mannomai. Yawu otyiŋgim Yerusalem kapi itit kiom tuhuŋetâ kâwurumŋaŋak kinbisâp yakât Anitâŋe sâm kalop. Yâhâ Anitâŋe nâŋgâyiŋgimu âlâkuâk âwurem taka kasalipyeŋe watyekŋetâ ariŋetâ kapiyeŋe ya mem miwirikunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","“Umatŋe topŋe topŋe tetewuap yanâmâ hilâmgât emetsenŋe, omoŋgât emetsenŋe, pitu âlâlâ himbimâmbâ pek sâm geŋetâ kulem topŋe topŋe tetemu ekmâ kiŋgityeŋahât otmâ “Wosapâ ari misiŋguraknom,” sâm tepyeŋe hârok hindânomai. ");
INSERT INTO spl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","28","Kulem yawuya tetewuap yan nâŋe âwurem ge meyekmâ manman kârikŋan katyekmune mannomaihât sâpŋe tâlâhuap sâm senyeŋe ewaken pilâm nâ neknomai. Sâp yanâmâ Anitâŋe yâhâpŋe hâŋgânnohomu elem kulewoŋboŋ kakŋambâ gemune kulem âlâlâ tetewuap yan wâtne pato tetemu ekŋetâ ae seŋ seŋ otbuap. ");
INSERT INTO spl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Sâp yan âwurem gewom yakât nâŋgâŋetâ keterahâkgât den âlâen hâum sâwe. Nenâmâ bândup baiako ya huhuakmu ekmâ yanâmâ “Emet kinbe sâm oap,” sâmain. ");
INSERT INTO spl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yakât dopŋeâk hâmbâi den yan yukât bulâŋe tetemu ekmâ yuwu sânomai. “Âo, yu Yesuŋe emet inânŋan den eknongop yakât bulâŋe tetemu eksain.” Yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Otmu den yan yuâmâ lohimbi âun yu mansai ki muŋetâek bulâŋe tetewuap. Yakât yuwu sâwe. Den yan yukât bulâŋe bulâŋanâk tetewuap. ");
INSERT INTO spl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yâhâ hân himbim pitu âlâlâ emelâk Anitâŋe kalop ya biatmâ metewuap. Yawu gârâmâ nâhât den yamâ ki biatbuap. Yamâ tat tat kârikŋe tatmâ yâhâmbisâp.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Otmu Yesuŋe torokatmâ yuwu sâm ekyongop. “Gakom katŋetâ seloŋe ga goka nem gakom ya kum pesuk pilâmu dâk dâk hutuk kumap yakât dopŋeâk nâŋe pârâk sânsânâk tetem gemune yanâmâ lohimbi kerekŋe otmai memai yakât matŋe Anitâŋe yiŋgimu menomai. Yakât otmâ yeŋe to kârikŋe ki nem biwi hâlim otnomai. Me sot kâle, soŋgo bau, me senŋe âlâlâ topŋe topŋe miakmâ manman sânduhân manne sâm yakâlâk biwiyeŋe ki hikum mannomai. ");
INSERT INTO spl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yawu otmâ manmâ umatŋe topŋe topŋe teteyiŋgimu biwiyeŋe orotok sâmu loholemaihât biwi golâek manmâ Anitâhâlen biwiyeŋaŋe kepeim ulitgum mannomai. Yawu manŋetâ nâŋe âwurem ge lohimbi biwiyeŋahât topŋe ekmâ nâŋgâm den sâm hâreyiŋgiwom yanâmâ yeŋe ki aŋulaknomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Yâhâ omoŋânâk ârândâŋ lohimbi kiŋgitŋe orowâkŋe Yesuhât denŋe nâŋgâne sâm opon kâmbukŋan yâhâ tatŋetâ den kâsikum yiŋgim gaop. Yawu otmâ emet ŋiŋ sâowân kapi ya pilâm Oliwa pumŋan kapi âlâ tap yan yâhâ iminiop. ");
INSERT INTO spl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Otmu Natik Hombaŋ ya tâlâhuop. Otmu hombaŋ yakât kutŋe âlâmâ “Tihit tihit Hombaŋ” yawu sâmai. ");
INSERT INTO spl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hombaŋ ya tâlâhumu yanâmâ hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum yiŋgiminiwiŋe menduhuakmâ Yesu kumunŋe mumbuap sâm yakât den hikuwi. Yawu gârâmâ Yesu mem kuŋetâ mumu lohimbiŋe ekmâ kuk otmaihât yok pilâm lohotŋan mem kuŋetâ mumbuap yakât den hikuwi. ");
INSERT INTO spl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","Otmu sâp yan Yesuhât hoŋ bawalipŋe kâiân yâhâp yâk yeŋgâlen gâtŋe âlâ, kutŋe Yurasi sâm, yâkât biwiŋan Satanŋe kioŋop. Satanŋe biwiŋan kioŋmu hotom uminiwi yeŋgât kunlipyeŋe otmu opon kâmbukŋahât tembe lâu yeŋgât kunlipyeŋe yeŋgâlen ariop. Ari Yesu menomai yakât ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ekyongomu nâŋgâm heroŋe otmâ hâmeŋe waŋnomai yakât ekuwi. ");
INSERT INTO spl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Otmu girawu tuhum yok pilâm meŋetâ lohimbiŋe ki eknomai yakât nâŋgâm manop. ");
INSERT INTO spl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Natik Hombaŋ ârândâŋ lama nanŋe gâim katmâ Anitâhât hotom uminiwi. ");
INSERT INTO spl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sâp ya tetemu Yesuŋe Petoro yet Yoane yuwu sâm ekyotgom hâŋgânyotgop. “Yetŋe kulet sâm Yerusalem kapiân yâhâ sot umutâ gamunŋe orowâk nenom.” ");
INSERT INTO spl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Sâmu sâowot. “Emet wosan ari sot umutŋe semu gaŋetâ orowâk nenom?” ");
INSERT INTO spl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sâmutâ sâop. “Kapiân yâhâmutâ hoŋ bawa lok âlâ âsâpŋe lâuakmâ arimu ekdomawot. Lok ya ekmâ betŋan watmâ ari emet âlâen yâhâmu ekmâ yan yâhâromawot. ");
INSERT INTO spl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yâhâmâmâ emet yakât amboŋe yuwu sâm ekuromawot. “Nengât bawapinenŋaŋe yuwu yap. “Nâŋe hoŋ bawalipne meyekmune emet yukât biwiŋe âlâen tatmâ sot um nenom.” Yawu yap yakât otmâ emet biwiŋe ya tiripnotgorâ ekde,” yawu sâm ekuromawot. ");
INSERT INTO spl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yawu sâm ekumutâ lok yaŋe dâiyelekmâ emet biwiŋe âlâ mem heŋgeŋguŋetâ tap ya tiripyotgowuap. Tiripyotgomu yanâmâ senŋe âlâlâ mem dinŋan tuhuromawot.” ");
INSERT INTO spl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yawu sâm hâŋgânyotgomu yâhâowot. Yâhâ Yesuŋe den ekyotgop watmâ senŋe âlâlâ mem dinŋan tuhuowot. ");
INSERT INTO spl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mem dinŋan tuhumutâ emetsâpŋe otmu yan Yesuŋe hoŋ bawalipŋe nombotŋe meyekmu yâhâ sot newi. ");
INSERT INTO spl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nem tatŋetâ Yesuŋe yuwu sâm ekyongop. “Sâmune nâŋgâŋet. Anitâhât den ki lâum manmaiŋe menekmâ Roma yeŋgât bâtyeŋan katnekŋetâ yâkŋe mem âlâlâ tuhunekŋetâ sâtgum mumbom. Yakât otmâ aŋgoân yen orop tatmâ lau konok sot nem buku oraŋgim mannomgât nâŋgâm biwinaŋe mem manmâ gan. ");
INSERT INTO spl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yâhâ hâmbâi Anitâŋe hâŋgânnohomu âwurem gewom yanâmâ nâhât âine yakât bulâŋe bâiŋe tetewuap. Sâp yanâmâ nenŋe menduhuakmâ orowâk tatmâ sot nem yâhânom.” ");
INSERT INTO spl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yawu sâm wain to mem Anitâ mepaem yiŋgim yuwu sâm ekyongop. “Wain to yu mem gâim aŋgim neŋet. ");
INSERT INTO spl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nâŋe sâp yupâek wain to yu yen orowâk tatmâ ki nem yâhâwom. Yamâ benŋe nenomain yuŋak ki pesuk sâwuap. Hâmbâi Anitâŋe hâŋgânnohomu âwurem gewom yanâmâ yen orowâk tatmâ nem yâhâmbisâin. ");
INSERT INTO spl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Otmu baŋga mem Anitâ mepaem motokmâ yiŋgim yuwu sâm ekyongop. “Yu mem aŋgim neŋet. Yuâmâ nâhât sunumne yawu oap. Nâŋe yeŋgât matyeŋe membom. Yakât otmâ sâp sâsâŋan baŋga nem yâhânomai yan nâ nâŋgânihim mannomai. Yawu sâm mem yiŋgimu newi. ");
INSERT INTO spl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sot nem tiŋ pilâŋetâ Yesuŋe wain to ya yâhâpŋe mem yiŋgim yuwu sâm eknongop. “Wain to yuâmâ nâhât hepne yawu oap. Gârâmâ nohoŋetâ hepne gemu mumbom yan Anitâŋe nâhât den sâm kalop yakât bulâŋe tâŋ tâŋâk tetewuap. Yawu otmâ Anitâŋe lohimbi kerek yeŋgât tosayeŋe pilâyiŋgiwuapgât mâtâp tetem heŋgeŋguwuap. ");
INSERT INTO spl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yawu gârâmâ yeŋgâlembâ lok âlâŋe betnehen kioŋmâ kasalipne yeŋgât bâtyeŋan mem katnekbuap. ");
INSERT INTO spl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nâ lok bulâŋe nohoŋetâ mumbom ya Anitâŋe sâm kalowâke yamâ lok yaŋe yawu otnihiwuap yakât matŋe Anitâŋe matŋe umatŋe waŋmu membuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yawu sâm ekyongomu topŋe nâŋgâne sâm “âlâhât yap” sâm âiahowi. ");
INSERT INTO spl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesu hoŋ bawalipŋe yeŋgâlen gâtŋe âlâ me âlâŋe sâp patoen kunyeŋe pato otbuap yakât sâm kuaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sâm kuaŋgiŋetâ Yesuŋe den âlâen hâum yuwu sâm ekyongop. “Lok papatolipyeŋaŋe nâŋgâmai dopŋan lohimbi galemyongomai. Galemyongoŋetâ lohimbiŋe yâk yeŋgât amutyeŋan manmâ “Kutdâlipnenŋe” sâm heroŋe nâŋgâyiŋgimai. ");
INSERT INTO spl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Papatolipyeŋaŋe otyiŋgimai yawu yeŋeâmâ ki otnomai. Yeŋgâlen gâtŋe âlâ me âlâ bukulipyeŋaŋe yeŋgât nâŋgâyiŋgiŋetâ yahalâkgât yeŋe meŋetâ huruŋ huruŋ otmu yâk yeŋgât amutyeŋan mannomai. Otmu yeŋgâlen gâtŋe âlâ me âlâŋe bukulipyeŋe yeŋgât kunyeŋe pato tatne nâŋgâmaiŋe bukulipyeŋe yeŋgât hoŋ bayiŋginomai. ");
INSERT INTO spl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sâŋetâ nâŋgâwe. Lok girawuya yeŋgât lohimbiŋe nâŋgâyiŋgiŋetâ yahatmap? In tatmâ sot nemai ya yeŋgât nâŋgâyiŋgiŋetâ yahatmap me sot, sot um hoŋ kakoloŋ otyiŋgimai ya yeŋgât nâŋgâŋetâ yahatmap? Bulâŋanâk in tatmâ sot nemai ya yeŋgât nâŋgâyiŋgiŋetâ yahatmap yakâ. Yawu gârâmâ nâŋeâmâ hoŋ bayiŋgiman. ");
INSERT INTO spl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nâ hâhiwin kakŋan manmâ gamune yeŋe ki pilânekmâ âlâengen arai. ");
INSERT INTO spl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yakât otmâ sâp patoen nâŋe tihityeŋe otmâ galemyongowomgât pat awoŋnaŋe kunihiop. Yakât dopŋeâk yeŋe Isirae lohimbi komot kâiân yâhâp ya galemyongonomaihât nâŋe nep sâm yiŋgian. ");
INSERT INTO spl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Sâp patoen orowâk tatmâ nenom. Yanâmâ yeŋe Isirae lohimbi komot kâiân yâhâp ya yeŋgât den sâm hâreyiŋginomai ya sâm yiŋgian.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yawu sâm ekyongom benŋe Simon Petoro yuwu sâm ekuop. “Simon, den âlâen hâum yuwu sâmune nâŋgâ. Matuk mendâremunŋe toŋe gemu helekŋe mem pilâmunŋe arimap yakât dopŋeâk Satanŋe topyeŋe mem tetewe sâm hâhiwin yiŋgiwuapgât Anitâ ekuop. ");
INSERT INTO spl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ekumu Anitâŋe nâŋgâwaŋgim ya sâm kalop. Yawu gârâmâ biwiyeŋe houŋ sâmapgât Anitâ ulitguwan. Ulitgumune yakât otmâ gâ gikiâk betnohowuat. Yawu otmâ sâp ki kâlep otmuâk nâhâlen biwihaŋe tiŋâk kepeim bukulipge mem heweweŋ tuhuyekbuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yawu sâmu Petoroŋe yuwu sâm ekuop. “Kutdâ, gâ pâi emetŋan katgekŋetâ tatbuat yamâ nâ orowâk yan tatdomgât naŋgan. Me gâ gohoŋetâ mumbuat yanâmâ nâ orowâk notgonomaihât naŋgan. Nâŋe gâ ki pilâhekmâ ariwom.” ");
INSERT INTO spl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Sâmu sâop. “Petoro, yuwu sâmune nâŋgâ. Gâ betnohom ki nâŋgâwaŋgian sâm kurihiakbuat. Kurihiakdâ kalimbuŋe otmu gokorok isewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yawu sâm ekum benŋe hoŋ bawalipŋe kerek yuwu sâm ekyongop. “Emelâk hâŋgânyongomune tewetsenŋe, itâkat, kâi katipŋe, senŋe âlâlâ barahâk ari den kâsikum yiŋgiwi sâp yan umburuk otmâ manbi me bia?” Sâmu sâwi. “Bia.” ");
INSERT INTO spl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Sâŋetâ sâop. “Emelâk yawu otbiâke yamâ yiwereŋe yuâmâ tewetsenŋe, itâkat senŋe âlâlâ ya miakmâ arinomai. Yâhâ emelâk emet inânŋan nâhât nâŋgâm den âlâ yuwu kulemguwi yakât bulâŋe nâhâlen tetewuap. “Yâkât nâŋgâŋetâ lok bâleŋe yawu oap.” Den yakât bulâŋe nâhâlen tetewuap yakât otmâ yeŋgâlen gâtŋe âlâ me âlâ kapam ki tatyiŋgiap yâkŋeâmâ yeŋgât hâk katipŋe tuhum pilâm yaŋe mem kapam puluhunomai. ");
INSERT INTO spl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sâmu sâwi. “Kutdâ, yu ek, kapam yâhâp tap.” Sâŋetâ sâop. “Pesuk yap, yakât denŋe âlâ ki sâwe.” ");
INSERT INTO spl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yâhâ Yesuŋe omoŋ ârândâŋâk Yerusalem kapi ya pilâm kapi âlâ Oliwa pumŋan tap yan yâhâ iminiop. Yakât otmâ hoŋ bawalipŋe meyekmu Yerusalem pilâm Oliwa pumŋan yâhâwi. ");
INSERT INTO spl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mâtâwân yâhâm tatŋetâ hoŋ bawalipŋe katyekbe sâm yuwu sâm ekyongop. “Biwiyeŋe houŋ sâmu lohotŋe otmâ pilânekmaihât Anitâ ulitguŋet.” ");
INSERT INTO spl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yawu sâm ekyongom pereŋ pilâm bam gâtŋaŋe ge tatmâ Anitâ ulitgum yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O awoŋ, umatŋe tetenihiwe sâm oap yu nâŋgârâ ki teteâkgât naŋgan. Yawu gârâmâ nâhât ombe watmâ ki otbuat. Gike ombeheâk watmâ otbuat.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yawu sâm ekumu biwiŋe houŋ sâmapgât aŋelo âlâŋe himbimâmbâ ge mâmâŋe otbaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yawu otmu hâkŋe biuk sâmu nâŋgâm Anitâhâlen biwiŋaŋe tiŋâk kepeim ulitguop. Ulitgumu ohowak birik birik kumu hep kâtŋe papato tiriŋ târâŋ sâm gemu ekmain yakât dopŋe tiriŋ târâŋ sâm hânân giop. ");
INSERT INTO spl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yawu otmâ ulitgum tiŋ pilâm yahatmâ hoŋ bawalipŋe yeŋgâlen ba yekmu biwiyeŋe umatŋe otmu yaŋak aman pâlâmŋe iwi. ");
INSERT INTO spl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Aman pâlâmŋe iŋetâ mândeyekmâ yuwu sâm ekyongop. “Yen wongât aman pâlâmŋe iai? Lohotŋe otmâ pilânekmaihât yahatmâ golâek tatmâ Anitâ ulitguŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yawu sâm ekyongomu bukuyeŋe âlâ, kutŋe Yurasi, yâkŋe lok seseŋgâlâk dâiyekmu takawi. Takaŋetâ Yurasi kulet sâyiŋgim Yesuhâlen ba parahuop. ");
INSERT INTO spl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Parahumu Yesuŋe yuwu sâm ekuop. “Menekŋetgât dop kum parahunekdâ ekmune bâleap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yawu sâm ekumu Yesu mem âlâlâ tuhumai sâm hoŋ bawalipŋaŋe yuwu sâm âikuwi. “O kutdâ, nâŋgâningirâ tewet mem lawityekne.” ");
INSERT INTO spl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yawu sâŋetâ yâk yeŋgâlen gâtŋe âlâŋe yahatmâ tewetŋe mem hotom uminiwi ya yeŋgât kunyeŋahât hoŋ bawaŋe ya ândâpŋe bonângen ya topŋambâek kârâm hâreop. ");
INSERT INTO spl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kârâm hâremu Yesuŋe “Pilâŋet,” sâm kuyiŋgiop. Yawu sâm kuyiŋgim hoŋ bawa yakât ândâpŋe ya mem katmu katarahop. ");
INSERT INTO spl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yawu otmâ hotom uminiwi ya yeŋgât kunlipyeŋe, otmu opon kâmbukŋahât tembe lâu yeŋgât kunlipyeŋe otmu Yura yeŋgât papatolipyeŋe yekmâ Yesuŋe yuwu sâm ekyongop. “Yen unam tewet otmu kapamgât sâtŋe metŋe âlâlâ lâum takai. Yeŋe nâhât lok bâleŋe sâm menekne sâm takai me? Me lok bâleŋe âlâ kune sâm takai? Yu ekmune bâleap. ");
INSERT INTO spl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nâŋe hilâm ârândâŋ Anitâhât opon kâmbukŋan yâhâ lohimbi den kâsikum yiŋgim gaman. Yan bân menekbâi. Yamâ sâp yiwereŋe yu Omoŋgât Amboŋaŋe biwiyeŋe mem hâlimgumu meneknomaihât Anitâŋe sâm kalop.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesuŋe yawu sâm ekyongomu hotom uminiwi ya yeŋgât kunyeŋe pato yâkât emelan dâim ariwi. Dâi ariŋetâ Petoroŋe yok pilâm betyeŋan watyekmâ ariop. ");
INSERT INTO spl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yesu mem emelan yâhâŋetâ tembe lâu yaŋeâmâ emet hawiŋan ba kâlâp uŋetâ semu nâŋgâm ikaiakmâ tatbi. Yâhâ Petoro yâku yawuâk kâlâp nâŋgâm ikaiakmâ talop. ");
INSERT INTO spl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yawu tatŋetâ hoŋ bawa imbi âlâŋe Petoro ekmâ yuwu sâm tembe lâu tatbi ya ekyongop. “Lok yuâmâ yâk orop manŋetâ yekman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yawu sâmu Petoroŋe kurihiakmâ yuwu sâop. “Lok enda ki nâŋgâwaŋgian.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yawu sâmu tatŋetâ benŋe lok âlâŋe ekmâ yuwu sâop. “Gâ yâk orop manmat.” Sâmu sâop. “Nâ bia.” ");
INSERT INTO spl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yawu sâmu sâp ki kâlep otmuâk benŋe lok âlâŋe ekmâ yuwu sâop. Yesuâmâ Galilaia amboŋe. Otmu gâ gurâ yawuâk Galilaia gâtŋe. Yakât otmâ gâmâ yâkât komolân gâtŋe geksan. Nâŋgâmune yawu oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sâmu sâop. “Lok sâm tai endamâ bulâŋanâk ki nâŋgâwaŋgian.” Yawu sâm oan mâne gokorok isiop. ");
INSERT INTO spl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gokorok isian mâne Yesu Kutdâŋe purik sâm Petoro ehop. Ekmu yan Yesuŋe emet inânŋan den yuwu sâm ekuop ya nâŋgâmu teteop. “Gâŋe nâhât “ki nâŋgâwaŋgian” sârâ kalimbuŋe otmu yan gokorok isewuap.” ");
INSERT INTO spl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Den ya nâŋgâmu tetemu biwiŋe ŋasinâk pato otmu pilâyekmâ ikŋiâk ba kinmâ hik ŋâik ŋâihâk isiop. ");
INSERT INTO spl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Otmu tembe lâu nombotŋe Yesu galemgum kinbiŋe senŋe sâhâm kâtâpgum ândâpŋe huhuwi. ");
INSERT INTO spl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ândâpŋe huhum nombotŋaŋe yuwu sâwi. “Bâiŋ, ândâpge âlâŋe huhuap?” ");
INSERT INTO spl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yawu sâm senŋan gem hâim hilitbi. ");
INSERT INTO spl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yawu otŋetâmâ emet haŋ sâmu yanâk Yura yeŋgât papatolipyeŋe, otmâ hotom uminiwi ya yeŋgât kunlipyeŋe, otmu Mosehât girem den kâsikum yiŋgiminiwiŋe menduhuakŋetâ tembe lâulipyeŋaŋe Yesu mem yâhâ katŋetâ kinmu yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Anitâŋe tihitnenŋe otbe sâm hâŋgângohomu ge mansat me bia?” Sâŋetâ sâop. “Nine topne sâm tetem ekyongomuneâmâ nâŋgâŋetâ ki bulâŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yâhâ den âlâ âiyongomuneâmâ yeŋe matŋe ki sânomai. ");
INSERT INTO spl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yawu gârâmâ nâ lok bulâŋaŋe pilâyekmâ himbimân yâhâwom. Himbimân yâhâ Anitâ yahat yahatŋe, Wâtgât Amboŋe, yâk orowâk tatdom.” ");
INSERT INTO spl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yawu sâmu nâŋgâm pârâk pilâm yuwu sâm ekuwi. “Kutne “Lok Bulâŋe” sâm gikak ahonakmat. Yakât nâŋgâmunŋe “Anitâhât Nanŋe” yawu oap. Yakât sârâ nâŋgâne. “Nâ Anitâhât nanŋe mansan,” yawu sâmat me.” Sâŋetâ sâop. “Den yu yai yakâ. Nâmâ Anitâŋe hâŋgânnohomu gewan.” ");
INSERT INTO spl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sâmu sâwi. “Bâiŋ, den kâmbukŋe hâliliŋe sâmu nâŋgâmunŋe pesuk yap. Ikŋahât nâŋgâmu yahatsap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yawu sâm yahatmâ Yesu dâim Pilatohâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yâkâlen dâim ari katŋetâ kinmu yuwu sâm hakŋan sâwi. “Roma lok yeŋgât kunyeŋe pato yâk takesi ki waŋet” sâm lohimbi eŋgatyeŋan gemap. Otmu ikŋahât nâŋgâmu yahatmu yuwu sâm ekyongomap. “Nâ Kiristo, lok kutdâ. Ninak galemyongom manmâ yâhâwom.” Yawu sâm hakŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yawu sâm Pilato ekuŋetâ yâkŋe purik sâm Yesu yuwu sâm âikuop. “Yura lohimbi yeŋgât lok kutdâ sâmai ya gâ me?” Sâmu sâop. “Oŋ, den bulâŋe yat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yawu sâmu hotom uminiwi otmu lohimbiŋe denŋe nâŋgâne sâm ga kinbi ya Pilatoŋe yuwu sâm ekyongop. “Lok yukât tosa ki mem tetean.” ");
INSERT INTO spl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yawu sâmu iliwetmâ yuwu sâwi. “Yawu gârâmâ Galilaia Yuraia hânân kapi tatmâ arap yan lok yuŋe yâhâm gem kapi ambolipŋe den kâsikum yiŋgim eŋgatyeŋan gemu kuk kapam otmâ emet mem yâhâ katmai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Yawu sâm Pilato ekuŋetâ yuwu sâm âiyongop. “Lok yuâmâ Galilaia gâtŋe me?” ");
INSERT INTO spl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sâmu sâwi. “Oŋ, yan gâtŋe.” Sâŋetâ sâop. “Ya Herotgât wahap, nâhât bia.” Yawu sâop. Sâp yan Herotŋe Galilaia hân pilâm Yerusalem kapiân ari tatmâ nâŋgâop. Yakât otmâ Pilatoŋe ekyongomu Yesu dâim Herotgâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yâhâ Yesuŋe olop miop yakât den pat ya Herotŋe emelâk nâŋgâop. Yakât otmâ Yesuŋe kulem âlâlâ tuhumu ekbeâk nâŋgâm manmâ gaop. Yakât otmâ Yesu dâim yâkâlen ariŋetâ ekmâ tep âlep nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Otmu den hakŋan sâwi yakât âikumu den biaek kinop. ");
INSERT INTO spl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Den biaek kinmu hotom uminiwi otmu Mosehât girem den kâsikum yiŋgiminiwiŋe yahatmâ kinmâ den topŋe topŋe hakŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yawu otŋetâ Herotŋe otmu tembe lâulipŋe orowâk senŋan gem hâim hilitbi. Yawu otŋetâ Herotŋe tembe lâulipŋe ekyongomu hâk katipŋe kâkâlep, kuriŋ takop takop lok kutdâŋe mânuŋakminiwi yawuya mem katbaŋgiwi. Yawu otbaŋgim Pilatohâlen dâim âwurem ariwi. ");
INSERT INTO spl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dâim âwurem ariŋetâ ekmâ “Herotŋe nâŋgânihiap,” sâm Pilatoŋe Herotgât nâŋgâmu yahatmu buku olowot. Yawu gârâmâ emelâk emet inânŋan kasa oraŋgim gaowot ya sâp yan pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yâhâ Pilatohâlen dâim âwureŋetâ hotom uminiwi ya yeŋgât kunlipyeŋe otmu Yura papatolipyeŋe ya yeŋgât den Pilatoŋe katmu ikŋe den sâsâ emetŋan ari menduhuakbi. Menduhuakŋetâ yan lohimbi inŋe dondâhâlâkŋe yekmâ denyeŋe nâŋgâne sâm ba hawamgum kinbi. ");
INSERT INTO spl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilatoŋe yuwu sâm ekyongop. “Lok yuŋe lohimbi yeŋgât eŋgatyeŋan gemu kuk kapam otmai,” yawu sâm yeŋe nâhâlen dâim takai. Nâhâlen dâim takaŋetâ senyeŋanâk âi pâi tuhum sâm hârewaŋgim ekmune tosaŋe bia oap. ");
INSERT INTO spl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Yakât otmâ Herotŋe sâm hârewaŋgiâkgât yâkâlen hâŋgânyongomune dâim arai. Otmu yâkŋe gurâ âi pâi tuhumu biatmu benŋe nâhâlen yâhâpŋe mem takai. Bulâŋanâk yuwu sâmune nâŋgâŋet. Lok yukâlen tosa âlâ ki mem tetean.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Tihit tihit Hombaŋ ârândâŋâk Pilatoŋe yuwu otminiop. Lok tosa otŋetâ pâi emetŋan katyekŋetâ tatminiwi yapâ gâtŋe âlâ me âlâhât lohimbiŋe nâŋgâŋetâ dopŋan otmu lok âlâ holaŋbuat sâminiwi ya holaŋyekmu geminiwi. Yakât otmâ yuwu sâm ekyongop. “Lok yu kumunŋe mumbuap yamâ tosa âlâ yâkâlen ki mem tetean. Yakât otmâ nâŋgânihiŋetâ tembe lâulipne ekyongomune hâhiwin waŋetâ holaŋmune gewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Yâhâ sâp yan lok bâleŋe âlâ, kutŋe Barawa sâm, yâkŋe kapam ahowiân lok âlâ kumu muop. Yakât otmâ pâi emetŋan mem katŋetâ tatmâ gaop yakât lohimbi kerekŋe den kârikŋan halahum yuwu sâwi. “Barawa holaŋdâ giâk. Yâhâ Yesu yamâ kuŋetâ muâk.” ");
INSERT INTO spl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yawu sâwiâke yamâ Pilatoŋe Yesu holaŋmu giâkgât nâŋgâm âlâkuâk sâop. “Nâmâ Yesu holaŋbom.” ");
INSERT INTO spl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yawu sâmu lohimbi yaŋe iliwetmâ den kârikŋan halahum yuwu sâwi. “Yesu howanân kum kânâŋgâŋetâ muâk, Howanân kum kânâŋgâŋetâ muâk.” ");
INSERT INTO spl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yawu sâŋetâ Pilatoŋe âlâkuâk yuwu sâm ekyongop. “Wuân otmu bâleap? Nâŋe âi pâi tuhum tosa âlâ yâkâlen ki mem tetean. Yakât otmâ tembe lâulipne ekyongomune hâhiwin waŋetâ yanâmâ holaŋmune gewuap.” ");
INSERT INTO spl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yawu sâmu kunyeŋe kârikŋe otmâ sâwi. “Howanân kum kânâŋgâŋetâ muâk.” Yawu sâŋetâ Pilatoŋe loholem lauyeŋan miop. ");
INSERT INTO spl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Lauyeŋan mem Yesu kuŋetâ muâk sâm sâm hârewaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yâhâ Barawahât nâŋgâŋetâ yahalop gârâmâ yâk holaŋmu giop. ");
INSERT INTO spl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pilatoŋe tembe lâulipŋe ekyongomu Yesu dâim ariwi. Dâim mâtâwân arim tatŋetâ lok âlâ, kutŋe Simon sâm, yâhâmâ Kirene hânân gâtŋe, newângembâ takamu mewi. Mem Yesuhât howan ya kambeŋan katŋetâ lâum Yesu betŋan sâop. Otmu lohibi dondâhâlâkŋe betyeŋan watyekmâ ariwi. ");
INSERT INTO spl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yâhâ imbi nombotŋe Yesuhât we bâle nâŋgâm dondâ isem orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iseŋetâ Yesuŋe purik sâm yekmâ yuwu sâm ekyongop. “Nâhât ki iseŋet, yeŋe otmu nimnaomlipyeŋe yeŋahât iseaŋgiŋet. ");
INSERT INTO spl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hâmbâi umatŋe topŋe topŋe teteyiŋgimu yuwu sânomai. “Bâe, imbi kâsi, imbi sihan, yâhâmâ naom barak mansai. Yakât otmâ yâk yeŋgât nâŋgâmunŋe âlepŋe oap. Nenŋeâmâ girawu otmâ arinom.” Yawu sânomai. ");
INSERT INTO spl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yâhâ lohimbi nombotŋaŋe pumŋe yukât yuwu sânomai. “Bâok sâm kurihinenehâk. Otmu kât kândun kum kurihinenehâk.” Yawu sânomai. Yakât den âlâen hâum yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nâ nak golâ yakât dop oan, yenâmâ nak mumuŋe yakât dop oai. Nak golâ uŋetâ semu kâliŋgumap yamâ nak mumuŋe uŋetâ sem laŋ laŋ sâmap. Nâ nohoŋetâ mumbom yamâ yenâmâ yongom meteyeknomai. Yakât otmâ yeŋahât iseaŋgiŋet.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yâhâ tembe lâulipyeŋaŋe pet kulem lok yâhâp orowâk yongone sâm meyekmâ ariwi. ");
INSERT INTO spl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Arim hân âlâ, kutŋe, Lok Kunŋe Hahitŋe sâm, yan ari Yesuhât hâk katipŋe tuhum pilâm ikŋe howanân kum kânâŋgâŋetâ kinop. Yawu otmâ pet kulem lok yâhâp ya yotgom lâum kânâŋgâyelekŋetâ nombot nombot kinowot. ");
INSERT INTO spl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yawu otyiŋgiŋetâ Yesuŋe yuwu sâm Anitâ ulitguop. “Awoŋ, otnihiai yukât topŋe ki naŋgai. Yakât otmâ tosayeŋe pilâyiŋgihât naŋgan.” Yawu sâmu tembe lâulipyeŋaŋe yâkât hâk katipŋe mem “Âlâŋe miakbuap?” sâm mem ketetmâ katbi. Mem ketetmâ katŋetâ tatmu pepa duhatmâ tipi tapi tuhum kutyeŋe ikŋiâk ikŋiâk yan kulemgum amaŋân mânuŋetâ giop. Mânuŋetâ gemu mem gulip malap tuhum yapâ pepa âlâ meŋetâ kut teteop yaŋe miahop. Yawu otbi. ");
INSERT INTO spl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Otmu Yura yeŋgât papatolipyeŋaŋe Yesu giriŋbaŋgim lohimbi ekmâ kinbi ya yuwu sâm ekyongowi. “Lok yuŋe lohimbi nombotŋe tânyongomu ekmain. Yâhâ Anitâŋe hâŋgângumu ge Yura nengât tihitnenŋe otmâ kutdânenŋe mansap otmuâmâ ikŋe tânahom howanâmbâ kâpehakmâ giâk.” Yawu sâm senŋan gewi. ");
INSERT INTO spl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Otmu tembe lâulipyeŋaŋe gurâ yawuâk senŋan gem giriŋbaŋgiwi. Yawu otmâ yâk yeŋgâlen gâtŋe âlâŋe ari sâŋgum âlâ mem nak bâtbâtŋe potonŋan pâŋ pâŋ kepeim yaŋe wain to bâleŋe yan walipgum mem yâhâ lauŋan kalop. ");
INSERT INTO spl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Lauŋan katmâ yuwu sâm senŋan giop. “Gâmâ Yura yeŋgât lok kutdâ mansat otmuâmâ kâpehakmâ ge.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yâhâ howan yakât kunŋan den yuwu kulemgum katbi. “Lok yuâmâ Yura yeŋgât lok kutdâ.” Yawu sâm kulemguwi. ");
INSERT INTO spl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yâhâ pet kulem lok yâhâp yotgom kânâŋgâyelekŋetâ kinowot ya âlâŋe yawuâk senŋan gem yuwu sâm sâwaŋgiop. “Bâe, lok kopa. Anitâŋe tihitnenŋe otbe sâm hâŋgângohomu ge mansat. Yakât otmâ kâpehakmâ gem net orowâk tânnotgorâ gene.” ");
INSERT INTO spl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yawu sâmu bukuŋaŋe nekamŋan yuwu sâop. “Girawu otmâ Anitâ ki ewe katsat? Papatolipnenŋaŋe dop konohâk sâm hâreningiai. ");
INSERT INTO spl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yâhâ netŋeâmâ otmutŋe bâleop. Yakât otmâ sâm hârenitgim notgoŋetâ mundom yaŋe ârândâŋ oap. Yâhâ lok yuâmâ tosa ki olop yamâ imbiâk kuai. ");
INSERT INTO spl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yawu sâm bukuŋe ekuop. Denŋe purik sâm Yesu yuwu sâm ekuop. “Yesu, yuwu sâmune nâŋgâ. Anitâŋe hâŋgângohomu âwurem ge galemnongowuat yan nâ nâŋgânihiwuat.” ");
INSERT INTO spl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sâmu sâop. “Emet ki ŋiŋ sâmuâk mum yâhâ manman sânduhân tatdom.” ");
INSERT INTO spl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yawu sâm ekumu hilâm kârikŋan, 12 kilok olop yan Anitâŋe nâŋgâmu emetsenŋe bok sâmu omoŋ sahahop. Omoŋ sahakmâ yapâ ari emetsâpŋe 3 kilok otmu emet laŋinŋe âlâkuâk pilâop. ");
INSERT INTO spl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Otmu emelâk lohimbi inŋe opon kâmbukŋe yakât biwiŋe ekmai sâm sâŋgum kâlep pato hikuŋetâ ya kâtâpguminiop. Sâŋgum yaŋe pâŋambâek tok sâm hâreakmâ nombot nombot otmu tetekŋan olop. ");
INSERT INTO spl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sâp yanâk Yesuŋe den kârikŋan halahum yuwu sâm Anitâ ekuop. “Awoŋ, mumbe sâm oan. Yakât otmâ umutne me. ");
INSERT INTO spl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yesu muop sâp yan tembe lâu ya yeŋgât kunyeŋe âlâ hâlâŋmâ kinopŋe ekmu âlâ kândâkdâ otmu Anitâ mepaem yuwu sâop. “Yuâmâ lok âlepŋe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Otmu lohimbi kinbiŋe kulem âlâlâ tetemu ekŋetâ âlâ kândâkdâ otmu muop yakât nâŋgâm biwiyeŋe umatŋe otmu emetyeŋehen âwurem ariwi. ");
INSERT INTO spl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Otmu imbi nombotŋaŋe Galilaia hân pilâm Yesu betŋan takawi yâkŋe bukulipyeŋe orowâk kâlepŋan kinmâ kulem teteop ya ekbi. ");
INSERT INTO spl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Otmu lok âlâ, kutŋe Yosep sâm, yâkât topŋeâmâ yuwu. Lok yamâ Arimata kapi ya Yuraia hânân tap yapâ gâtŋe. Otmu Anitâŋe Isirae lohimbi yeŋgât tihityeŋe otmâ ikŋe hoŋ bawaŋe hâŋgângumu gewuap sâminiwi yâkât mambotmâ lohotŋan manmâ gaop. Yâhâ emelâk hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum yiŋgiminiwi otmu Yura yeŋgât papatolipyeŋaŋe Yesu muâkgât den sâm hârewaŋgiwiâke yamâ yâkŋe nâŋgâmu ki ârândâŋ otmu sâyiŋgiop. Lok yaŋe Yesu lâum ari hanguwe sâm Pilatohâlen ari tetewaŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","53","Tetewaŋgimu lauŋan memu bukulipŋe meyekmu ari howanâmbâ Yesu mem sâŋgum kaokŋe katipguwi. Katipgum lâum ari kât mâtâpŋe âlâ, dikin yawuya, yamâ emelâk kusânmâ mem tiŋgâloŋetâ kinop yan lâum ari katbi. ");
INSERT INTO spl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yâhâ momeŋe emetsâpŋe sâp yan lâum ari katbi. ");
INSERT INTO spl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Emet ŋiŋ sâwe sâm otmu yan imbi nombotŋaŋe Galilaia hân pilâm Yesu betŋan takawiŋe Yosep orowâk ari sâŋgum kaokŋe Yesu katipgum kât mâtâpŋan katŋetâ talop ya ekbi. ");
INSERT INTO spl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ekmâ to kukŋe suk suk âiloŋgo mem ga Yesu pirine sâm otmâ kapiân âwurem ariwi. Yâhâ emelâk embâŋân Moseŋe girem den âlâ kulemguop ya yuwu tap. “Tatmâ nâŋgâ nâŋgâ sâpŋan âi ki tuhunomai.” Den ya lâum kapiân in tatmâ nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Emet haŋ sâmu imbi yaŋe yahatmâ to kukŋe suk suk mem sumângen ariwi. ");
INSERT INTO spl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ari senyeŋe pilâm eksain mâne kât pato lâum hâpunŋetâ ba mâtâpŋe ya maŋguop ya âlâengen ba talop. Yawu otmu mâtâpŋe ya tetekŋan kinmu ekbi. ");
INSERT INTO spl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ekmâ kâlehen yâhâm Yesuhât pâinbi. ");
INSERT INTO spl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yesuhât pâinŋetâ biatmu kinŋetâ yanâk aŋelo yâhâp yâk yetgât hâk katipŋe kaok bolaŋ bolaŋ yaŋe pârâk sânsânâk teteyiŋgim kinowot. ");
INSERT INTO spl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Teteyiŋgim kinmutâ yelekmâ pârâk pilâm umutyeŋe ariop. Umutyeŋe arimu yuwu sâm imbi ya ekyongowot. “Yenâmâ wongât lok senŋe golâ ya pâinmâ sumân takai? ");
INSERT INTO spl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Emelâk yahatmâ arap. Emelâk yeŋe Galilaia hânân yâk orop manŋetâ den ekyongop yakât nelâm yongoap me? ");
INSERT INTO spl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Emelâk yuwu sâm ekyongop. “Lok âlâŋe nâ lok bulâŋe nâŋgâm bâlenihim Roma yeŋgât bâtyeŋan mem katnekmu nohoŋetâ mumbom. Mumune hannohoŋetâ hilâm kalimbu pesuk sâmu yan yahatbom.” Yesuŋe yawu sâm ekyongop.” Yawu sâowot.” ");
INSERT INTO spl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yawu sâm ekyongomutâ nâŋgân nâŋgânyeŋe pâroŋ sâmu nâŋgâŋetâ teteop. ");
INSERT INTO spl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nâŋgâŋetâ tetemu pilâyelekmâ âwurem ari yakât den pat Yesu hoŋ bawalipŋe kâiân konok otmu bukulipyeŋe nombotŋe 10 ekyongowi. ");
INSERT INTO spl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Imbi sumân ariwi ya yeŋgât kutyeŋeâmâ yuwu. Maria, Matala kapiân gâtŋe, âlâmâ Yoana, âlâmâ Maria Yakop mâmâŋe. Yâkŋeâmâ bukulipyeŋe orowâk ari den pat ya Yesu hoŋ bawalipŋe ekyongowi. ");
INSERT INTO spl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ekyongoŋetâ nâŋgâŋetâ porap olop. ");
INSERT INTO spl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yawu gârâmâ Petoroŋe yahatmâ sumângen sururuk sâm ari lâm sâtŋanâk kinmâ ehop. Eksan mâne sâŋgum kâlep mem Yesu katipgum katbi yaŋahâk tatmu ehop. Ekmâ “wuân kulem eksan” sâm nâŋgâm kiwilim emetŋan âwurem ariop. ");
INSERT INTO spl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sâp yanâk Yesuhât komolân gâtŋe lok yâhâp Emausi kapi Yerusalem kapi gotŋanâk tap yan ariowot. ");
INSERT INTO spl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mâtâwân arim tatmâ papatolipyeŋaŋe Yesu kuŋetâ muop yakât alahum weyetŋe nâŋgâowot. ");
INSERT INTO spl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yawu otmâ arim tatmutâ Yesuŋe teteyitgimu orowâk ariwi. ");
INSERT INTO spl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Orowâk ari kundenŋe ehoworâke yamâ lok ondop orop arain yawu nâŋgâowot. ");
INSERT INTO spl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yawu nâŋgâmutâ Yesuŋe yuwu sâm âiyotgop. “Wuân denŋe alahuawot?” Sâmu hâmeyetŋe bâlemu kinowot. ");
INSERT INTO spl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yawu otmâ bukuŋe âlâ, kutŋe Keleopa sâm, yâkŋe yuwu sâop. “Yâhâlen papatolipnenŋaŋe otbi yakât den pat Yerusalem kapi ambolipŋe kerekŋe naŋgain. Yakât otmâ girawu otmâ yakât pâpguat?” ");
INSERT INTO spl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sâmu sâop. “Wuân otbihât yat?” Sâmu sâop. “Wâe, wonângen? Yesu, Nasaret amboŋe otbaŋgiwi yakât alahum gait. Anitâŋe Yesu mâmâŋe otbaŋgimu yâkât den kâsikum ningim kulem topŋe topŋe tuhum manmâ gaop. ");
INSERT INTO spl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yakât otmâ lohimbi kerekŋe nâŋgâwaŋgiŋetâ yahatminiop. Yamâ hotom umai otmu papatolipnenŋaŋe yâkât den nâŋgâŋetâ nahat otmu “Kuŋetâ muâk” sâm sâm hârewaŋgiwi. Yawu sâm hârewaŋgim Roma lok galemlipnenŋe ekyongoŋetâ yâkŋe lauyeŋan mem howanân kuŋetâ muop. Yakât den pat alahum gait. ");
INSERT INTO spl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yâkŋe Isirae nengât kasalipnenŋe yongom watyekmu arinomai yawu nâŋgâm biwinenŋaŋe mem manmâ gawin. Yamâ yâhâlen kuŋetâ muop. ");
INSERT INTO spl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Âun emet haŋ sâmu imbi nombotŋaŋe sumângen ari kulem âlâ tetemu eksai. Kulem tetemu ekmâ âwurem taka yakât yuwu sâm eknongoai. “Aŋelo yâhâp teteningim “Yesu mumuŋambâ yahatsap” yawu sâm eknongoawot.” ");
INSERT INTO spl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Imbi yaŋe yawu sâm eknongoŋetâ bukulipnetŋe nombotŋaŋe sumângen ari imbi yaŋe den yai ya yeŋe senyeŋan Yesu ekŋetâ ki tap.” ");
INSERT INTO spl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yawu sâm ekumutâ Yesuŋe yuwu sâop. “Nâŋgân nâŋgânyetŋe umatŋe. Emelâk Anitâŋe poropetelipŋe den ekyongomu kulemguwi ya nâŋgâmutâ ki keterakyitgimap. Yakât otmâ yuwu sâmune nâŋgâyet. ");
INSERT INTO spl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Anitâŋe tihitnenŋe otbe sâm ikŋe hoŋ bawaŋe hâŋgângumu ge manmu kuŋetâ hâhiwin nâŋgâm muop. Muop yamâ mumuŋambâ yahatmâ tatmâ yâhâmbisâp ya Anitâŋe sâm kalop.” ");
INSERT INTO spl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yawu sâm topŋe katmâ Mose otmu Anitâhât poropetelipŋaŋe miti pepaen den kulemguwi ya sâm kusânmâ ekyotgop. ");
INSERT INTO spl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yawu otmâ Emausi kapi ginŋan ariwi. Yan arimâmâ Yesuŋe katyelekmâ kapi âlâengen ariwe sâm olop. ");
INSERT INTO spl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yawu otmu alitmâ yuwu sâowot. “Emet ŋiŋ yap yakât otmâ orowâk yuân tatne.” Yawu sâm emetyetŋan orowâk yâhâwi. ");
INSERT INTO spl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yâhâ tatmâ sot um newi. Sot um nem tatŋetâ Yesuŋe baŋga mem Anitâ mepaem motokmâ torehenŋe yitgiop. ");
INSERT INTO spl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yitgimu yanâk nâŋgân nâŋgânyetŋe pâroŋ sâmu kundenŋe ekmutâ keterakyitgiop. Ekmutâ keterakyitgimu yanâk gulip olop. ");
INSERT INTO spl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gulip otmu bukuŋe âlâ yaŋe bukuŋe yuwu sâm ekuop. “Mâtâwân takain yan Anitâhât poropetelipŋe nombotŋe otmu Moseŋe miti pepaen den kulemguwi yakât topŋe sâm kusânmâ eknotgomu nâŋgâm biwine yahatsap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yawu otmu in yawu yahatmâ Emausi kapi ya pilâm âwurem Yerusalem kapiân ariowot. Âwurem ari Yesu ikŋe hoŋ bawalipŋe kâiân konok otmu bukulipyeŋe nombotŋe orowâk menduhuakmâ tatbi yâk yeŋgâlen yâhâowot. Yâhâmutâ yuwu sâm ekyotgowi. ");
INSERT INTO spl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Kutdâ mumuŋambâ yahatmâ Simon Petoro tetewaŋgimu eksap.” ");
INSERT INTO spl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yawu sâm ekyotgoŋetâ benŋe kutdâŋe mâtâwân yâk teteyitgim emetyetŋan ari baŋga mem motokmâ yitgimu yan kundenŋe ekmutâ keterakyitgiop yakât ekyongowot. ");
INSERT INTO spl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Den ya ekyongomutâ yanâk Yesuŋe pârâk sânsânâk teteyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Teteyiŋgimu ekmâ “weke takap,” sâm pârâk pilâm kiŋgityeŋahât otbi. ");
INSERT INTO spl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","39","Yawu otŋetâ yuwu sâm ekyongop. “Wongât biwiyeŋe ahom niaksap? Nâŋe teteyiŋgian yuwu weke ki teteyiŋgimap. Yakât otmâ kâine bâtne yu walipnohom nâŋgâm heŋgeŋguŋet. Weke bia. Nâ ninak gamune eŋaksain. Yakât otmâ biwiyeŋe sânduk sâek.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","41","Yawu sâm ekyongomu nâŋgâŋetâ porap olop yamâ kâiŋe bâtŋe kuwi ya tiripyongomu ekmâ olowâke yamâ heroŋe nâŋgâwaŋgiwi. Yawu otŋetâ yuwu sâm ekyongop. “Sot âlâ tap otmuâmâ mem nihiŋetâ nembe.” ");
INSERT INTO spl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Yawu sâm ekyongomu iŋan âlâ hot um katbi ya waŋetâ mem niop. Mem nemu ekmâ “weke bia” sâm tepyeŋe hâlâlâk nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesuŋe iŋan ya nem tiŋ pilâm yuwu sâm ekyongop. “Emelâk yen orowâk manmâ den topŋe topŋe kâsikum yiŋgim gawan yan den âlâ yuwu sâm ekyongowan. “Emelâk emet inânŋan Mose, Dawiti, otmu Anitâhât poropetelipŋe nombotŋaŋe nâhât nâŋgâm miti pepaen den kulemgumini yakât bulâŋe tetem heŋgeŋguwuapgât Anitâŋe sâm kalop.” Yawu sâm ekyongowan.” ");
INSERT INTO spl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yawu sâm ekyongom den kulemguwi ya kâsikum yiŋgimu nâŋgâŋetâ. ");
INSERT INTO spl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Den ya nâŋgâŋetâ keterakyiŋgimu den bâiŋe yuwu sâm ekyongop. Emelâk emet inânŋan miti pepaen den âlâlâ kulemguwi yakât topŋeâmâ yuwu tap. Anitâŋe lohimbi kerek yeŋgât tihityeŋe otbe sâm ikŋe hoŋ bawa hâŋgângumu ge manbuap. Manmu lok bâleŋaŋe mem âlâlâ tuhuŋetâ hâhiwin nâŋgâm mumbuap. Mumu hanguŋetâ hilâm kalimbu pesuk sâmu Anitâŋe mumuŋambâ mem yahatbuap. ");
INSERT INTO spl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Yakât otmâ lohimbiŋe orotmemeyeŋe bâleŋe bet pilâm nâhâlen biwiyeŋaŋe kepeinomai otmuâmâ Anitâŋe tosayeŋe pilâyiŋgim meyekbuap. Otmu yeŋe ari nahat den pat âlepŋe sâm haok tuhuŋetâ lohimbi hânŋan kulemŋan manmâ araiŋe nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Otmu nâŋe Wâtgât mâmâŋahât Heak hâŋgângumune ge âi sâm yiŋgian yukât mâmâŋe otyiŋgimu menomai ya awoŋnaŋe sâm kalop. Yakât otmâ Yerusalem kapiân tatmâ mambotnomai.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yerusalem kapi pato yakât gotŋan kapi âlâ, kutŋe Betani sâm, ya tap. Yan meyekmâ ari Anitâŋe mâmâŋe otyiŋgiâkgât ulitguop. ");
INSERT INTO spl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yawu otmâ pilâyekmâ himbimân yâhâop. ");
INSERT INTO spl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Himbimân yâhâmu mepaem tepyeŋe heroŋe otmu Yerusalem kapiân âwurem ariwi. Âwurem ari opon kâmbukŋan yâhâ Anitâ mepaewi. Yawu. ");
INSERT INTO spl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Anitâhât Kai Toka yaŋeâmâ embâŋâmbâek Anitâŋe hân himbim ki kândikyotgop yapâek Anitâ orop dopyetŋe konohâk tatmâ gaowotŋak tatmâ gawot. ");
INSERT INTO spl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","3","Kândik mindikum topŋambâek Kai Toka yaŋe Anitâ orop tatmâ gaowot yan Anitâhâlen kândiwahom himbimân dewutâ, emetsenŋe, pitu topŋe topŋe ekmain ya otmu hânân âliwahap topŋe topŋe ehekŋe, ki ehekŋe kerehâk kândikyongop. Yamâ ya yeŋgâlen gâtŋe âlâŋe ikŋahâk ki teteop, bia kârikŋe. ");
INSERT INTO spl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kai Toka yaŋe manman kârikŋahât amboŋe oap. Yakât otmâmâ laŋinŋe ikŋambâ gâtŋe yaŋe lohimbi biwinenŋan pilâmu haŋ sâningim gamap. ");
INSERT INTO spl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yawu otmâ omoŋ bâleŋan pilâmu omoŋ kâlehen manmaiŋe kâtâpgune sâm hâum pâpgum gamai. ");
INSERT INTO spl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Otmu Kai Toka yakât laŋinŋaŋe lohimbi biwinenŋan pilâmu ya ekmâ nâŋgâmunŋe bulâŋe otmu yâkâlen biwinenŋaŋe katnehât Anitâŋe lok âlâ, kutŋe Yoane, ya âi sâm waŋmu takaop. ");
INSERT INTO spl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Taka laŋinŋe amboŋahât amutgen manmâ kulet sâm mâtâp mewaŋgim yâkât den pat âlepŋe sâm tetem eknongom manminiop. ");
INSERT INTO spl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yâhâ laŋinŋahât amboŋe yakât topŋe yuwu tap. Yâkŋe lohimbi kerek nengât biwinenŋan laŋinŋe pilâmu ekmâ nâŋgâmunŋe keterakningiâkgât ge hohetnenŋan manop. ");
INSERT INTO spl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kai Toka yaŋe ge hohetnenŋan manop yan lohimbi kiŋgitŋe orowâkŋe topŋe nâŋgâm hâum pâpgum ki ekŋetâ keterahop. Ikŋak Anitâhâlen kândiwahom lohimbi katyelekmu yapâ tetem gawiŋe amboyeŋe ekmâ topŋe hâum pâpguwi. ");
INSERT INTO spl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yâhâ dop yawuâk ikŋe torehenlipŋe yeŋgât hohetyeŋan takamu ekŋetâ ki keterakyiŋgiopgât betbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yawu gârâmâ nen lok nombotŋaŋe yâkâlen biwinenŋe katbin yamâ mâmâŋe otningimu Anitâhât nan baralipŋe otmâ mansain. ");
INSERT INTO spl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Anitâhât nan baralipŋe otmâ mansain yakât topŋe yuwu tap. Lohimbi katyelekmu yapâ tetem gamunŋe gamunŋe sambe sambe oain yakât otmâ Anitâhât nan baralipŋe ki otbin. Me lok nombotŋaŋe nengât sen yaŋe tetem sambe otŋet sâm imbi miakmâ manbi yaŋe gurâ bia. Anitâ ikŋak mâmâŋe otningimu yakât nan baralipŋe otmâ gain. ");
INSERT INTO spl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bâiŋ, Kai Toka yaŋe ge imbi tepŋambâ tetem lok otmâ hohetnenŋan manmâ tep âlep nâŋgâningiop. Nâŋgâningimu manmanŋe ekmunŋe bulâŋe otmu Anitâhât nanŋe ombe bisiŋe dopyetŋe konohâk yawu otmutâ yelekbin. ");
INSERT INTO spl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yâhâ lok otmâ manmu Yoaneŋe ekmâ lohimbi yuwu sâm ekyongop. “Emelâk lok yukât nâŋgâm yuwu sâm ekyongowan. “Nâŋe embâŋâmbâek meŋnahât tepŋambâ ki tetewan yapâek tatmâ gaop. Yakât otmâmâ nâŋe kulet sâm mâtâp mewaŋgim yâkât amutgen mansan.” Yawu sâm ekyongowan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yawu gârâmâ manman kârikŋe yakât amboŋaŋe tep âlep nâŋgâningimap ya pesuk sâwuapgât dop âlâ ki tap. Yamâ witgum nâŋgâningim yâhâwuap. ");
INSERT INTO spl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Emelâk Anitâŋe Mose ekumu girem den topŋe topŋe kulemguop ya ekmunŋe manman tawi tawiŋe oap. Yâhâ sâp yiwereŋeâmâ Anitâŋe Yesu Kiristo hâŋgângumu ge wawaeneneksap ya ekmunŋe bulâŋe dondâ oap. ");
INSERT INTO spl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nenŋe Anitâ ki ekmain. Yawu gârâmâ yâkŋe ikŋe nanŋe ombe bisiŋe hâŋgângumu ge manop. Yâkŋe yawu olop yan nenŋe Anitâhât topŋe nâŋgâm heŋgeŋgunehât yâkŋe sâm tetekŋan tuhumu nâŋgâm heŋgeŋguwin. ");
INSERT INTO spl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kândikum lohimbiŋe orotmemeyeŋe bâleŋe ya betbaŋgiŋetâ Yoaneŋe âi topŋe katmâ toen katyehop. Toen katyekmu yakât topŋe nâŋgâne sâm hotom uminiwi yeŋgât kunlipyeŋaŋe bukulipyeŋe nombotŋe hâŋgânyongowi. Hâŋgânyongoŋetâ hoŋ bawalipyeŋe meyekŋetâ orowâk Yerusalem kapi pato pilâm ge Yoanehâlen ari âikuwi. “Gâ topgahât sârâ nâŋgâne.” ");
INSERT INTO spl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Âikuŋetâ sâop. “Anitâŋe hoŋ bawa âlâ hâŋgângumu ge tihitnenŋe otmâ galemnongowuap sâmai ya nâ bia.” ");
INSERT INTO spl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sâmu sâwi. “Yawu yatgât âlâkuâk sârâ nâŋgâne. Emelâk embâŋân poropete âlâ, kutŋe Elia sâm, manop. Yâkŋe yâhâpŋe tetem hohetnenŋan manmâ Anitâŋe hoŋ bawa âlâ hâŋgângumu ge tihitnenŋe otmâ galemnongowuap yakât mâtâp mewaŋgiwuap yamâ gâ me âlâhât mambotmain.” Sâŋetâ sâop. “Bia, yai yamâ nâ bia.” Sâmu sâwi. “Anitâŋe poropete âlâ hâŋgângumu ge mâtâp meningiwuap nâŋgâmain ya gâ me âlâhât mambotmain. Sâŋetâ sâop. “Lok ya nâ bia.” ");
INSERT INTO spl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Sâmu sâwi. “Topge ki eknongoat. Yakât otmâ yiwereŋe âwurem ari papatolipnenŋe girawu sâm ekyongomunŋe nâŋgâŋetâ ârândâŋ otbuap? Bâiŋ, gike topge tâŋ tâŋâk sârâ nâŋgâneâyâ.” ");
INSERT INTO spl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sâŋetâ sâop. “Nâŋe lok ki manmaiângen manmune lohimbiŋe nâhâlen takaŋetâ yuwu sâm ekyongom mansan. “Pumŋe lauŋe uk sâm huruŋ sâm ya kum kilikmâ mem ârândâŋ merândâŋ tuhuŋetâ tatbuap. Yawu otmâ lok kutdâhât mâtâp mewaŋgiŋet.” Den yu poropete âlâ, kutŋe Yesaia sâm, yâkŋe kulemguop.” ");
INSERT INTO spl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yawu sâmu Parisaio lok orowâk takawiŋe yuwu sâm âikuwi. ");
INSERT INTO spl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Anitâŋe hoŋ bawa âlâ hâŋgângumu ge tihitnenŋe otmâ galemnongowuap sâmain ya “nâ bia” yawu yat. Me Eliaŋe yâhâpŋe tetewuap ya gurâ bia. Me poropete lok âlâ me âlâ gurâ bia. Yawu yat gârâmâ topŋe girawuhât otmâ lohimbi toen katyekmâ mansat?” ");
INSERT INTO spl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sâŋetâ sâop “Nâmâ toen mem katyekman. Yâhâ lok kutdâ âlâ hohetyeŋan mansap yâkât wâtŋe âlâ tatbaŋgiap ya ekŋetâ ki keteraksap. ");
INSERT INTO spl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hâmbâi lok yaŋe âi topŋe katmâ tuhumu eknomai. Nâmâ lok inŋe mansan. Yakât otmâ nep tuhuwuap yawuya tuhuwomgât dop bia. Me yâkât itâkat gurâ kâpekmâ golewaŋgiwomgât dop âlâ ki tap.” Yawu sâm ikŋahât nâŋgâmu giop. ");
INSERT INTO spl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yâhâ Yoaneŋe kapi âlâ, kutŋe Betani sâm, ya Yoran to nombotgen tap yan manmâ toen katyekminiop. Den matŋe yawu ekyongomu purik sâm Yerusalem kapiân âwurem ariwi. ");
INSERT INTO spl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Otmu emet haŋ sâmu Yesuŋe Yoanehâlen ariop. Arimu akŋangembâek ekmâ yuwu sâm lohimbi mem toen katyehop ya ekyongop. “Lok enda ekŋet. Endamâ Anitâŋe hâŋgângumu ge lamahât dop otbuap. Yakât otmâ dop kum sâmune nâŋgâŋet. Nengât tosa pesuk sâningiâkgât opon kâmbukŋahât galem mansaiŋe hotom une sâm yan lama nanŋe kum gâim uŋetâ semu hotomŋaŋe yâhâmu Anitâŋe nâŋgâningimap. Yakât dopŋeâk lok endaŋe tosanenŋahât otmâ kawenenŋan kinmu kuŋetâ mumbuap yakât otmâ Anitâŋe hâŋgângumu ge mansap. ");
INSERT INTO spl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Otmu emelâk lok yukât topŋe yuwu sâm ekyongowan. “Hâmbâi yâkŋeâmâ âi topŋe katmâ tuhumu eknomai. Nâŋe embâŋâmbâek meŋnahât tepŋambâ ki tetewan yapâek tatmâ gaop. Yakât otmâ nâŋe kulet sâm mâtâp mewaŋgim yâkât amutgen mansan.” ");
INSERT INTO spl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Emelâk ki nâŋgâwaŋgiwan. Yâhâlen puwâk takamu ekban. Otmu yen Isirae lohimbiŋe yâkât topŋe nâŋgâŋetâ keterahâkgât nâŋe mâtâp mewaŋgim toen mem katyeksan. ");
INSERT INTO spl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Nâhâlen takamu toen katban yakât topŋe yuwu sâmune nâŋgâŋet. Emelâk nâŋe yâkât topŋe ki nâŋgâm manban yan Anitâŋe nâŋe toen katyekbom yakât yuwu âi sâm nihim hâŋgânnohop. “Gâŋe lohimbi toen katyekbuat yanâmâ nine Wâtgât mâmâŋahât Heak hâŋgângumune ge lok âlâhât kunŋan tatbuap lok yaŋe lohimbi manman âiloŋgoân katyekmu Wâtgât mâmâŋahât Heakŋe mâmâŋe otyiŋgiwuap.” Yawu sâm eknohop. Yawu sâm eknohomu lauŋe lâum lohimbi toen katyekmâ yaŋak lok eksai yu toen katban. Toen katmune yanâk himbim pâroŋ sâmu Anitâhât Wâtgât mâmâŋahât Heakŋe kembâ hâtgum ge mâmâŋe otbaŋgiop. ");
INSERT INTO spl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mâmâŋe otbaŋgimu yakât topŋe nâŋgâm heŋgeŋguan. Yâhâmâ Anitâhât nanŋe mansap.” Yoaneŋe Yesu takamu ekmâ yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Emet haŋ sâmu Yoaneŋe ikŋe hoŋ bawayâhâtŋe, nâ otmu lok âlâ, kutŋe Anderea, Simon Petorohât imiŋe, menelekmu deŋgân âlâ, kutŋe Galilaia sâm, yakât ginŋehen ariwin. ");
INSERT INTO spl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Arimunŋe Yesuŋe gam wanginenekmâ bamu Yoaneŋe ekmâ yuwu sâm eknotgop. “Lok yu wanginenekmâ bap enda ekset. Yâhâmâ Anitâŋe hâŋgângumu ge lamahât dop otmâ nengât tosahât otmâ kawenenŋan kinmu kuŋetâ mumbuap yakât otmâ Anitâŋe hâŋgângumu giop.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yawu sâmu, nâŋgâmutŋe bonŋe otmu Yoane pilâm Yesu betŋan sâmutŋe orowâk ariwin. ");
INSERT INTO spl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesuŋe purik sâm yuwu sâm eknotgop. “Yet wongât betnan watneksawot?” Sâmu sâwit. “Kutdâ, gâ emet girawuân imat?” ");
INSERT INTO spl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Sâmutŋe sâop. “Orowâk ari emet ya tiripyotgowom.” Yawu sâmu orowâk ari emetŋan yâhâ tatmâ den huhuwin. Den huhum tatmunŋe emetsenŋe emelâk purik sâm giop. ");
INSERT INTO spl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Otmu bukune Andereaŋe, pilânelekmâ yahatmâ, ari ataŋe, kutŋe Simon, mem tetem yuwu sâm ekuop. “Anitâŋe lok âlâ hâŋgângumu Yura nengât tihitnenŋe otmâ galemnongowe sâm ge mansap ya eksait.” Yawu sâop. Lok yakât kutŋeâmâ Kiristo. ");
INSERT INTO spl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yawu sâm netgâlen dâim takamu Yesuŋe Simon ekmâ yuwu sâm ekuop. “Simon, Yoane nanŋe, gâmâ yiwereŋe kutge âiŋe, Kepa sâm gohonsan.” Yawu sâop. Kut yamâ Girik yeŋgât denân Petoro. Yakât topŋeâmâ benben me kon yawu. ");
INSERT INTO spl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Otmu emet haŋ sâmu Yesuŋe Galilaia hânângen ariwe sâm olop. Yawu otmâ yanâk lok âlâ, kutŋe Pilip sâm, ya ekmâ yuwu sâm ekuop. “Garâ, orowâk arire.” ");
INSERT INTO spl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Otmu Pilip yamâ Anderea yet Petoro, orop kapiyeŋe kutŋe Besaita, ya ambolipŋe. ");
INSERT INTO spl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Yesuŋe Pilip memu yâkŋe in yawu ari bukuŋe âlâ, kutŋe Natanae sâm, ya yuwu sâm ekuop. “Emelâk Anitâŋe hoŋ bawa âlâ hâŋgângumu ge tihitnenŋe otmâ galemnongom manbuap yakât Mose otmu Anitâhât poropetelipŋaŋe kulemguwi ya eksain. Yâhâmâ Yosep nanŋe, Nasaret kapi amboŋe,” yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yawu sâmu sâop. “Yakât nâŋgâmune gemap. Nasaret kapi ambolipŋe âlâ me âlâŋe tânnongonomaihât dop âlâ ki tap.” Sâmu sâop. “Bâiŋ. Gam ek.” ");
INSERT INTO spl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yawu sâmu Natanaeŋe Yesuhâlen takamu yan, yuwu sâm eknongop. “Yu ekŋet. Lok yuâmâ Isirae amboŋe otmu tâŋ tâŋâk mansap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yawu sâmu Natanaeŋe âikum sâop. “Gâ wonângen manmune nehongât yawu yat? Sâmu sâop. “Gâ Pilipŋe ki gohonsap yan lakop kuriŋ amutgen Anitâ mepaem tatdâ geksan.” ");
INSERT INTO spl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Sâmu sâop. “Kutdâ gâ Anitâhât nanŋe. Isirae nengât kunnenŋe mansat.” ");
INSERT INTO spl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Sâmu sâop. “Lakop kuriŋ amutgen geksan yakât otmâ topge naŋgan. Yu sâm tetem ekgohoan yakât otmâ yat. Yawu gârâmâ hâmbâi kulem topŋe topŋe memune ekdâ âlâ kândâkdâ otbuap.” ");
INSERT INTO spl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yawu sâm ekum benŋe yuwu sâm eknongop. “Bulâŋanâk yuwu sâmune nâŋgâŋet. Anitâŋe bulâŋanâk hâŋgânnohomu gewan yakât topŋe teteâkgât ewapâ himbim pâroŋ sâmu yâkât aŋelolipŋaŋe mâmâŋe otnihim yâhâm gem otŋetâ yekmâ nâhât topne ekmâ nâŋgânomai.” Yawu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yawu sâm eknongomu hilâm yâhâp pesuk sâmu yan kapi âlâ, kutŋe Kana sâm ya Galilaia hânân tap yan gâtŋe âlâŋe imbi membe sâm otmu bukulipŋaŋe heroŋe nâŋgâyitgim menduhuakbi. ");
INSERT INTO spl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Menduhuyehop ya amboŋaŋe Yesu ikŋe otmu mâmâŋe otmu nen hoŋ bawalipŋe dâinenekmu orowâk emetyetŋan yâhâwin. ");
INSERT INTO spl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yâhâ menduhuakmâ nem tatmunŋe wain to ya biatmu Yesu mâmâŋaŋe yakât sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ekumu sâop. “Meŋ, yakât ki nâŋgârâ gorâhihiâk. Anitâ ikŋak nâŋgâmu âi topŋe katbehât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sâmu mâmâŋaŋe emet amboŋe yakât hoŋ bawa âlâ yuwu sâm ekuop. “Nannaŋe yu me ya otŋet sâwuap yawuâk otnomai.” ");
INSERT INTO spl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Otmu emet ya kâlehen amaŋ papato bât nombolân konok ya tatyiŋgiop yakât topŋe yuwu. Yura lohimbi Anitâŋe nâŋgâningimu ârândâŋ olâkgât to yaŋe mem sot nenehât senŋe âlâlâ ya piriminiwin. Otmu yapâ gâtŋaŋe to osom neminiwin. Otmu kâi bâtnenŋe piriakminiwin. ");
INSERT INTO spl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yakât otmâ Yesuŋe emet amboŋahât hoŋ bawalipŋe yuwu sâm ekyongop. “Ba to osom mem ga amaŋân gâiŋetâ pik sâek.” Yawu sâmu to osom ga gâiŋetâ pik sâop. ");
INSERT INTO spl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yawu otŋetâ yuwu sâm ekyongop. “Aiop, yupâ to osom ba galemyeŋe ya waŋetâ niâk.” Yawu sâmu osom mem ba waŋetâ niop. ");
INSERT INTO spl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yawu gârâmâ to yaŋe emelâk purik sâm wain olop. Yawu otmu galemyeŋaŋe nemu ukenŋe otmu biwiŋaŋe yuwu nâŋgâop. “Wain toŋe emelâk biatningiap. Yu nemune ukenŋe oap yu wosapâ mem gai?” Yawu nâŋgâm yakât topŋe hâum pâpguop. Yawu gârâmâ to osom mem waŋbiŋe yakât topŋe nâŋgâwi. Yâhâ wain to ya nemu ukenŋe otmu yaŋak lok imbi miop ya yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Aŋgoânâmâ wain ukenŋe sâm bukulipyeŋe gâim yiŋgiŋetâ nem biwiyeŋe hâlim otŋetâ yakât kakŋanâmâ wain pâlâmŋe gâim yiŋgimai. Yâhâ gâŋeâmâ wain to yu kuratgum tatgât bet mem ga ningirâ nem nâŋgâmune âlâ oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuŋe Kana kapi yan âi topŋe katmâ kulem memu ekmunŋe âlâ kândâkdâ otmu yâkâlen biwinenŋaŋe kepeiwin. ");
INSERT INTO spl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Otmu ya pesuk sâmu Yesuŋe imilipŋe otmu mâmâŋe meyekmu Kana kapi ya pilâm Kapanaum kapi yan orowâk gem ariwin. Gem ari yan tatmunŋe hilâm mome pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Otmu sâp yanâmâ Yura nengât Tihit tihit Hombaŋ ya tâlâhumu Yesuŋe menenekmu Yerusalem kapiân yâhâwin. ");
INSERT INTO spl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","16","Otmu opon kâmbukŋan yâhâmunŋe yan lok nombotŋaŋe kembâ puluhum tatbi otmu lama bulimakao me senŋe âlâlâ aŋgi guŋgi otmâ hâmeŋe hâukum kinbi ya Yesuŋe yahatmâ yuwu sâm sâyiŋgiop. “Awoŋnahât opon yu kâlehen ki orotŋe otŋetâ aŋgim bero emetŋahât dop oap.” Den yawu sâm tewetsenŋe hâukum kinbi ya yeŋgât kakŋan tat tat, tewo, me senŋe âlâlâyeŋe mem purik pilâyiŋgiop. Yawu otmâ lama bulimakao ya yongom watyekmu tiok taok otmâ arim kinbi. Yawu olop. ");
INSERT INTO spl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Otmu tâmbânenŋe, kutŋe Dawiti sâm, yâkŋe den kulemguop ya nâŋgâmunŋe teteop ya yuwu tap. “O Anitâ, lohimbi nombotŋaŋe gâhât opon kâlehen yâhâ tatmâ ki orotŋe otmai sâm biwinaŋe kou kâlâp siap.” Den yawu tatmap ya nâŋgâmunŋe teteop. ");
INSERT INTO spl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yawu otmâ watyekmu ariŋetâ Yura papatolipnenŋaŋe ekŋetâ bâlemu yuwu sâm ekuwi. “Gâŋe oat yu nâŋgâmunŋe dondâ bâleap. Âlâŋe mâmâŋe otgihimu yu oat? Gâŋe wuân kulem mendâ nenŋe gekmâ Anitâŋe nâŋgâhihimu oat yawu nâŋgâmunŋe ârândâŋ otbuap?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sâŋetâ sâop. “Yeŋe Anitâhât opon yu liakunomai. Otmuâmâ nâŋeâmâ sâp kâlep bia, hilâm kalimbu yakât biwiŋan tuhum maŋguwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yawu sâm ekyongomu sâwi. “Maiŋ, papatolipnenŋaŋe opon kâmbukŋe yu yambu 46 biwiŋan tuhuwi. Gârâmâ gâŋeâmâ girawu otmâmâ “hilâm kalimbu biwiŋan tuhum maŋguwom” yat. Den yat yakât nâŋgâmunŋe ki ârândâŋ oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","22","Yesuŋe den sâop yakât topŋe yamâ âlâ miop. Yuwuhât sâop. Yâhâmâ kuŋetâ mumu hilâm kalimbu pesuk sâmu yan yahatbuap yakât topŋe sâop. Yakât otmâ mumuŋambâ yahalop sâp yanâmâ den sâop ya nâŋgâmunŋe bulâŋe olop. ");
INSERT INTO spl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuŋeâmâ Tihit tihit Hombaŋ yan Yerusalem kapiân tatmâ kulem topŋe topŋe memu lohimbi kiŋgitŋe orowâkŋe ekŋetâ bonŋe otmu yâkâlen biwiyeŋe katbi. ");
INSERT INTO spl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Yawu otŋetâ lohimbi nengât biwinenŋe ekmapŋe topyeŋe ekmâ nâŋgâop. Topyeŋe nâŋgâm yaŋak yâk yeŋgâlen ki torokalop. ");
INSERT INTO spl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Otmu Parisaio yeŋgâlen gâtŋe âlâ, kutŋe Nikotemo sâm, yâkŋe Yura nengât lok kunŋe manop. ");
INSERT INTO spl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Omoŋ âlâen lok yaŋe Yesuhâlen ari yuwu sâm ekuop. “Kutdâ, gâhât topge naŋgain. Gâŋe kulem topŋe topŋe memat yu lok nombotŋe Anitâ orop ki mansaiŋe kulem yuwuya menomaihât dop âlâ ki tap.” ");
INSERT INTO spl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sâmu sâop. “Âinohowe sâm oat ya emelâk naŋgan. Yakât yuwu sâmune nâŋgâ. Lok âlâ me âlâ Anitâŋe tihityeŋe olâk sâm mâmâlipyeŋe yeŋgât tepyeŋambâ tetewi yakât dopŋeâk yâhâpŋe teteŋetgât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Sâmu sâop. “Bâe, nâ emelâk lok oan. Yakât girawu otmâmâ âlâkuâk meŋnahât tepŋe kâlehen yâhâ tatmune yâhâpŋe menekbuap. Ya ki orotŋe.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sâmu sâop. “Yuwu sâmune nâŋgâ. Lok âlâ me âlâŋe orotmemeŋe bâleŋe bet pilâm Anitâhâlen biwiyeŋe katnomai yamâ toen katyeknomai. Toen katyekŋetâ Wâtgât mâmâŋahât Heakŋe mâmâŋe otyiŋgimu Anitâŋe tihityeŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yakât torokatmâ yuwu sâwe. Nen kerekŋe mâmâlipnenŋe yeŋgât tepyeŋambâ tetem towat konohâk oain. Yâhâ umut biwinenŋe yamâ Wâtgât mâmâŋahât Heakŋe mâmâŋe otningim mem heweweŋ tuhunenekmu manman kârikŋahât mâtâp teteningimap. ");
INSERT INTO spl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yawu gârâmâ “mâmâhahât tepŋambâ teteon yakât dopŋeâk yâhâpŋe tetewuat,” sâm ekgohoan yakât ki nâŋgârâ sâtŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yakât den âlâen hâum sâmune den ya nâŋgârâ keterakgihiâk. Siru ya wosapâ topŋe katmâ takamap? Otmu wosaken bâiŋe arimap? Yakât topŋe ki nâŋgâmain. Siru pilâmap ya munŋeâk nâŋgâmain. Yakât dopŋeâk Wâtgât mâmâŋahât Heakŋe mâmâŋe otyiŋgimu biwiyeŋe heweweŋ otmâ Anitâhâlen katmai. Biwiyeŋe âlâhâlen kinmap yakât ki eŋakmâ naŋgaŋgimai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sâmu sâop. “Bâe, den yat ya nâŋgâm pâpguan. Âlâkuâk sârâ nâŋgâwe.” ");
INSERT INTO spl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sâmu sâop. “Gâŋeâmâ Anitâhât den Isirae lohimbi kâsikum yiŋgirâ yakât nâŋgâhihiŋetâ yahatmap. Yakât girawuhât otmâ den yan yukât topŋe ki naŋgat? ");
INSERT INTO spl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yakât yuwu sâmune nâŋgâ. Nenŋe sennenŋaŋe ekmain otmu biwinenŋan tetemu nâŋgâmain ya sâm tetem Parisaio yen ekyongom mansain. Yawu gârâmâ yeŋeâmâ dennenŋe nâŋgâŋetâ gemu bet pilâmai. ");
INSERT INTO spl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yâhâ nâŋe manman topŋe topŋe yakât ekyongomuneâmâ nâŋgâŋetâ ki bulâŋe otmap. Yakât otmâmâ girawu otmâ himbimgât topŋe ekyongomune nâŋgâŋetâ bulâŋe otbuap? ");
INSERT INTO spl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Lok âlâŋe himbimân ki yâhâm purik sâm ge yakât topŋe lohimbi ekyongomap. Nâ konok Anitâŋe himbimâmbâ hâŋgânnohomu ge yakât topŋe ekyongom mansan. ");
INSERT INTO spl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Emelâk Moseŋe yuwu otbomgât dop olop. Isirae lohimbiŋe lok ki manmaiângen manmâ otŋetâ bâleop yakât matŋe hambe sâtŋe metŋe yaŋe yiŋgimu muwi. Yakât otmâ Moseŋe hambe umutŋe hâwim nahân kepeim kânâŋgâmu ekmâ yan âlepŋe otbi. Yakât dopŋeâk lohimbi kerekŋe otŋetâ bâlemap ya yeŋgât tosayeŋe biatyiŋgiâkgât Anitâŋe sâmu nâ howanân nohom kânâŋgânekŋetâ kinbom. ");
INSERT INTO spl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Howanân kinmune yapâ gâtŋaŋe lok âlâ me âlâŋe biwi nâŋgân nâŋgânyeŋaŋe nâhâlen kepeim mannomai yamâ tosayeŋe biatyiŋgimu manman kârikŋan mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anitâŋe ikŋe eŋgatŋeâk otmâ lohimbi kerek wawaenenekmâ ikŋe nanŋe ombe bisiŋe hâŋgângumu ge nengât kawenenŋan kinmu howanân kuŋetâ muop. Yawu gârâmâ yâkâlen biwinenŋe kepeim manmâ yâhânom yanâmâ manman kârikŋe ya menom. ");
INSERT INTO spl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anitâŋe nanŋe hâŋgângumu ge manman kârikŋan torokatnenehop. Yakât otmâ nenŋe yâkâlen biwinenŋaŋe kepeim manmâ yâhânom yanâmâ sâp patoen den âiân ki katnenekbuap. ");
INSERT INTO spl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Otmu nen Yesuhâlen biwinenŋaŋe hikum manmain nenâmâ emelâk manman kârikŋahât pat kuningimu tap. Yakât den âiân katnenekbuapgât dop ki tap. Yâhâ lohimbi nombotŋaŋe Anitâ nanŋahât biwiyeŋaŋe pâlâmŋe otmu betbaŋgim mansai yamâ emelâk kâlâwân seyekbuapgât pat kuyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","21","Yâhâ Anitâŋe nen lohimbi kerek mem kiwilinenekmâ matŋe ningimu menom yakât topŋe yuwu tap. Nen lohimbi kerekŋe orotmeme bâleŋe otne sâm yan bukulipnenŋaŋe nenekmâ nâŋgâm bâleningimai sâm kurihiakmâ tihân otmâ gamain. Yâhâ nenâmâ Yesuhâlen biwinenŋaŋe kepeim tem lâuwaŋgim mansainŋe topnenŋe ki kurihiakmain. Nenŋe lok senyeŋan kinmunŋe manmannenŋe tetekŋan ekmai. Yâhâ lohimbi nombotŋaŋe orotmemeyeŋe bâleŋe ya witgumâk otmâ mansaiŋe topyeŋe kurihiakmâ Yesu, laŋinŋe amboŋahât hâkâŋ otmâ betbaŋgimai. ");
INSERT INTO spl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Otmu Nikotemoŋe pilâm arimu yakât kakŋan Yesuŋe nen hoŋ bawalipŋe menenekmu Yerusalem kapi pilâm Yuraia hânân ari manbin. Yan manmunŋe Yesuhât sâtgât otmâ lohimbi nombotŋe toen mem katyekbin. ");
INSERT INTO spl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Otmu sâp yan Herotŋe ki sâmu Yoane mem pâi emetŋan katŋetâ talop. Sâp yan Yoaneŋe kapi âlâ, kutŋe Ainon sâm, ya Salim kapi gotŋan tap yan ariop. Yan arimu to senŋe sambe yan tap yakât ambolipŋe kiŋgitŋe orowâkŋe yâkâlen ariŋetâ toen katyehop. ");
INSERT INTO spl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Toen mem katyehop yan Yura lok âlâŋe Yoanehât hoŋ bawalipŋe yeŋgâlen arimu Yura ambolipŋe Anitâŋe yekmu ârândâŋ olâk sâm to piriakbi orotmeme yakât den sahaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Den sahaŋgiŋetâ Yoanehât hoŋ bawalipŋaŋe ari yuwu sâm ekuwi. “Lok pato. Emelâk gâ orowâk Yoran to nombotgen manmunŋe lok âlâŋe gâhâlen takamu yâkât nâŋgârâ yahalop. Lohimbi seseŋgâlâkŋe nâŋgâningiŋetâ gemu lok yakâlenâk ariŋetâ toen mem katyeksap. Yakât nâŋgâmunŋe dondâ bâleap,” yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yawu sâŋetâ yuwu sâm ekyongop. “Anitâŋe lohimbi biwiyeŋe mem heweweŋ tuhumu yâkât nâŋgâwaŋgiŋetâ yahatmu yâkâlen ariai. Lohimbiŋe nengâlen torokatŋetgât eŋgatyeŋan ki kioŋnom. Yamâ wongât? Anitâ ikŋak yakât amboŋe oap. ");
INSERT INTO spl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yawu gârâmâ lok yakât yai ya emelâk yâkât topŋe yuwu sâm ekyongowan. “Anitâŋe hoŋ bawa âlâ hâŋgângumu ge tihitnenŋe otmâ galemnongowuap ya nâ bia. Nâmâ kulet sâm mâtâp mewaŋgian.” Yawu sâwan. ");
INSERT INTO spl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yakât otmâmâ den âlâen hâum sâmune topŋe nâŋgâŋetâ keterahâk. Lok âlâ yayalipŋaŋe imbi yâkât pat kuwaŋginomai. Pat kuwaŋgiŋetâ manbuap. Manmâ yâhâm miakdomawot yan heroŋe otnomai. Yakât dopŋeâk lohimbi seseŋgâlâkŋe Yesuhâlen torokatŋetâ heroŋe oan. ");
INSERT INTO spl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sâp yiwereŋe yupâek lohimbi kiŋgitŋe orowâkŋe nâŋgâwaŋgiŋetâ yahatmu yâkâlen torokatnomai. Yâhâ nâmâ nâŋgânihiŋetâ gemu âi tuhum tiŋ pilâm gulip otbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","32","Yoane den yawu sâm ekyongop yakât topŋeâmâ yuwu. Nenŋe meŋlipnenŋe yeŋgât tepyeŋambâ tetewin. Gârâmâ manmannenŋahâlâk nâŋgâm alahu gulahu otmain. Yâhâ Anitâŋe Yesu hâŋgângumu giop. Yakât otmâ kunnenŋe pato otmâ âwâŋahât topŋe eknongom mansap. Yawu gârâmâ lohimbi getek âlâŋe denŋe nâŋgâŋetâ bulâŋe otmu yâkâlen biwiyeŋaŋe tiŋâk kepeim mansai. ");
INSERT INTO spl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","35","Anitâŋe nanŋe wawaemu biwiyetŋe kepeiakmâ konohâk otmu tatmawot. Yawu tatmawot yamâ âwâŋaŋe âi sâm waŋmâ hâŋgângumu giop. Gem yan kunnenŋe manmâ Wâtgât Mâmâŋahât Heakŋe mâmâŋe otbaŋgimu âwâŋahât den ya tâŋ tâŋâk eknongom mansap. Yâkŋe den eknongop ya nâŋgâmunŋe bulâŋe otmu yâkâlen biwinenŋaŋe kepeimain. ");
INSERT INTO spl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yawu gârâmâ lok âlâ me âlâŋe Anitâ nanŋahâlen biwiyeŋaŋe kepeim mannomai yamâ manman kârikŋahât pat kuyiŋgiop ya menomai. Yâhâ lok âlâ me âlâŋe yâkât den betbaŋgim mannomai yamâ Anitâŋe kuk otmâ hâhiwin yiŋgimu nâŋgâm tatbisâi. ");
INSERT INTO spl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Lohimbi dondâŋe Yoanehâlen ariŋetâ toen katyehop. Yawu gârâmâ lohimbi kiŋgitŋe orowâkŋe Yesuhât nâŋgâŋetâ yahatmu yâkâlen takaŋetâ yâkât sâtgât nen hoŋ bawalipŋaŋe toen katyekbin. Toen katyekbin yakât Parisaioŋe nâŋgâŋetâ bâleop. ");
INSERT INTO spl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nâŋgâŋetâ bâlemu yaŋak Yesuŋe Yuraia hân pilâm Galilaia hânângen âwurem ariwe sâm otmu orowâk ariwin. ");
INSERT INTO spl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ari Samaria yeŋgât hân tânâmŋambâ hârem ariwin. ");
INSERT INTO spl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ari kapi âlâ, kutŋe Sika sâm, ya mewin. Otmu emelâk embâŋânâk kapi yakât gotŋan tâmbânenŋe âlâ, kutŋe Yakop sâm, yâkŋe tohât lâm kâlep pato kendâop. Kendâmu yapâek to hindakmâ tumuŋan tatmu osom nemai. Otmu lâm kendâop ya nanŋe Yosep pilâwaŋgiop. ");
INSERT INTO spl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nen mâtâwân arim tatmunŋe sikopŋe dondâ nongop. Yakât otmâ to ya ginŋan ge tatmâ hâknenŋe mewin. ");
INSERT INTO spl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yesuâmâ yan tatmu nenâmâ pilâm sot puluhune sâm kapiân yâhâwin. Katmâ yâhâmunŋe yan ikŋiâk tatmu imbi âlâŋe to osowe sâm kapiângembâ giop. Gemu Yesuŋe yuwu sâm ekuop. “To osom niŋdâ nembehât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yawu sâmu yan biwiŋaŋe nâŋgâop. “Yen Yura lohimbiŋe nenekmâ nâŋgâm bâleningim nengât tera me osom bero yaŋe ki katmâ nemai.” Biwiŋaŋe yawu nâŋgâm yakât otmâ pârâk pilâm yuwu sâop. “Gâmâ Yura lok. Yawu gârâmâ girawuhât otmâ tohât ulitnohoat? Ya kâmbukŋe yakâ.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sâmu sâop. “Anitâŋe heweweŋâk otmâ lâtâpnongomap yakât topŋe gâŋe ki naŋgat. Otmu nine topne gurâ ki naŋgat. Naŋgat mâne emelâk manman kârikŋahât to yakât ulitnohombât.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sâmu sâop. “Lok pato, to yuâmâ lâm kâlep pato. Yawu gârâmâ to osowuatgât wahap barahâk tat yukâ. Wuânŋe mem manman kârikŋahât to yat ya osowuat? ");
INSERT INTO spl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yâhâ tâmbânenŋe Yakopŋeâmâ lâm yu kendâm yupâ to osom neminiop. Otmu nanlipŋe otmu lama bulimakao osom yiŋgimu neminiwi. Yâhâmâ to yupâek nem manminiwi. Yakopŋe otmâ manminiop ya wangim otbuatgât nâŋgâm yu yat me?” ");
INSERT INTO spl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sâmu sâop. “To yuâmâ lok âlâ me âlâŋe neŋetâ yâhâpŋe tohât kân kânâk katyekbuap. ");
INSERT INTO spl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yawu gârâmâ nine manman kârikŋahât to osom yiŋgimune nenomai. Ya nenomai yakât otmâ yeŋgâlembâ to yaŋe punduŋ punduŋ sâm ga takamu ya nem manman kârikŋe manmâ yâhânomai. Yakât otmâ tohât kân kânâk katyekbuapgât dop âlâ ki tap.” ");
INSERT INTO spl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sâmu sâop. “Maiŋ, lok pato. Nâŋe hilâm ârândâŋ to yupâ osowe sâm kapi pilâm gem yâhâm tatman. Yawuâk otmâ manmangât gike to osom niŋdâ nemune yâhâpŋe tohât ki katnekbuapgât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sâmu sâop. “Yawu gârâmâ gâ ari lokge dâirâ orowâk takayet.” ");
INSERT INTO spl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Sâmu sâop. “Nâmâ lokne bia.” Yawu sâmu yuwu sâm purik pilâwaŋgiop. ");
INSERT INTO spl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Gâ lok imbât yaŋe mem pilâhekbi. Yamâ yiwereŋe meŋgekmu mansawot yamâ lokge bulâŋe bia. Yamâ kombo mansawot. Yakât den yat yuâmâ bonŋe.” ");
INSERT INTO spl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Sâmu sâop. “Maiŋ, lok pato. Gâmâ Anitâhât poropete geksan. ");
INSERT INTO spl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yawu gârâmâ ekgohomune nâŋgâ. Emelâk tâmbâlipnenŋaŋe pumŋe yuân yâhâ kinmâ Anitâ mepaeminiwi. Yâhâ Yura lok yeŋeâmâ Yerusalem kapiân yâhâ Anitâ mepaemai. Yamâ lohimbi wosanŋe bonŋe otmai?” Yawu sâm âikuop. ");
INSERT INTO spl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","Sâmu sâop. “Wâe. Imbi, sâmune nâŋgâ. Hâmbâi mâne yen Samaria lohimbi pumŋe yuân Anitâ ki mepaenomai. Otmu nengu yawuâk Yerusalem kapiân Anitâ ki mepaenom. Anitâmâ nen yuwuya bia. Yâkât topŋeâmâ ikŋiâk tap. Yâhâmâ pumŋe me kapi âlâen ki tatmap. Yakât otmâmâ sâp yupâek kapi me pumŋe âlâen me âlâen yâhâ kinmâ Anitâ mepaenom yamâ hâliŋe bia. Yakât otmâ Anitâ awoŋnenŋaŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otningimu awoŋnenŋahâlen biwinenŋaŋe kepeim mepaemunŋe nâŋgâmu ârândâŋ otbuap. Yen Samaria ambolipŋeâmâ Anitâhât topŋe ki nâŋgâmâk imbiâk mepaemai. Yawu gârâmâ Anitâŋe hoŋ bawaŋe âlâ hâŋgângumu ge Yura hohetnenŋan tetem yen me nen kerek tihitnenŋe otbuap yakât sâop. Yakât otmâ nenŋeâmâ Anitâhât topŋe nâŋgâm heŋgeŋguain.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sâmu sâop. “Yawu gârâmâ Anitâŋe hoŋ bawaŋe âlâ hâŋgângumu ge tihitnenŋe otbuap ya emelâk sâŋetâ nâŋgâwan. Gem yan wuân me wuân teteningiwuap ya bunewâk eknongowuap.” Yawu sâop. Hoŋ bawa yakât kutŋeâmâ Kiristo. ");
INSERT INTO spl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sâmu sâop. “Hoŋ bawa yakât yat yamâ nâ. Anitâŋe hâŋgânnohomu ge mansan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sâm tan mâne nenŋe sot puluhum takam Yesuŋe imbi ya orop den alahuowot ya ekmâ pârâk pilâm imbi yaŋe wuân den âikuop yakât ki âikum topŋe nâŋgâwin. Me Yesuŋe wongât imbi ya orop den alahuowot yakât gurâ yawuâk. ");
INSERT INTO spl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yawu otmu imbi yaŋe âsâpŋe pilâm kapiângen sururuk sâm ariop. Sururuk sâm ari kapi ambolipŋe yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Wâe. Lok âlâŋe to lâmŋe ginŋan taka tatmâ biwine ekmâ otman meman ya hârohâk sâm tetem eknohoap. Anitâŋe hoŋ bawa âlâ hâŋgângumu gewuap sâmai yaŋe takap mon.” ");
INSERT INTO spl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yawu sâmu nâŋgâm ekne sâm kapi pilâm takawi. ");
INSERT INTO spl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mâtâwân gem tatŋetâ nenŋe sot ne sâm Yesu ekuwin. ");
INSERT INTO spl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ekumunŋe sâop. “Tatnihiap ya nem mansan. Yeŋe yakât topŋe ki naŋgai.” ");
INSERT INTO spl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yawu sâmu alahu gulahu otmâ yuwu sâwin. “Nenŋe yu pilâm kapiân yahain yan lok âlâŋe sot waŋmu niap mon?” Yawu sâm âlâhuwin. ");
INSERT INTO spl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yawu sâmunŋe sâop. “Nâmâ Awoŋnaŋe hâŋgânnohomu ge tem lâuwaŋgim nepŋe tuhum mansan yaŋe nâhât sot kâle oap. ");
INSERT INTO spl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Otmu nengât nep topŋahât nâŋgâŋetâ keterahâkgât âlâen hâum sâmune nâŋgâŋet. Emetsenŋe imbât pesuk sâmu yan kalamân gâtŋe âlemu mem nemain. Yawu gârâmâ lohimbiŋeâmâ kalamân sot âlem tap yakât dopŋeâk biwiyeŋe heweweŋ otmâ manman kârikŋan arine sâm otmâ tai. Yeŋeâmâ lohimbi dondâŋe mansai ya yeŋgât nâŋgâm âi meŋet. ");
INSERT INTO spl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","Yakât torokatmâ sâmune nâŋgâŋet. Lok nombotŋaŋe nep tuhumai. Yâhâ nombotŋaŋeâmâ âlemu mem konok tuhumai. Yâhâ lok âlâ me âlâŋe nâhât nep tuhumai me yakât bonŋe menomai ya yâhâp yâhâp heroŋe kakŋan mannomai. Yâhâ bonŋe âlemu mem katŋetâ tatbuap yaŋeâmâ lohimbiŋe heweweŋ otmâ Anitâhâlen biwiyeŋe kepeim manmâ manman kârikŋe menomai yakât dopŋeâk oap. ");
INSERT INTO spl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Otmu emelâk lok nombotŋaŋe nâhât nep tuhuwi ya bonŋe âlem kinsaiŋe manman kârikŋe meŋetgât yen hâŋgânyongomune ari meyekŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Otmu Yesuŋe Samaria gâtŋe imbi yakât biwiŋe ekmâ olop miop ya tâŋ tâŋâk sâm tetem ekuop yakât kapi ambolipŋe ekyongomu nâŋgâŋetâ bulâŋe otmu Yesuhâlen takawi. ");
INSERT INTO spl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Taka “Nen orowâk torokatmâ manbuat,” yawu sâm ekuŋetâ nâŋgâyiŋgiop. Nâŋgâyiŋgimu kapiyeŋan yâhâ hilâm yâhâp tatbin. ");
INSERT INTO spl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tatmunŋe den pat âlepŋe ekyongomu lohimbi dondâŋe nâŋgâŋetâ bulâŋe otmu yâkâlen biwiyeŋaŋe kepeiwi. ");
INSERT INTO spl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Biwiyeŋaŋe kepeim imbi ya yuwu sâm ekuwi. “Aŋgoân gâŋe den sârâ nâŋgâmunŋe bulâŋe olop. Yâhâ sâp yiwereŋe yuâmâ yâkŋe sârerenenekmâ manman kârikŋe ningiwe sâm ge mansap ya ikŋe lauŋambâ eknongomu nâŋgâmunŋe bulâŋanâk oap. Yakât otmâ yâkâlen biwinenŋaŋe kepeiain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesuŋe hilâm yâhâp tatmâ den ekyongomu pesuk sâmu orowâk Galilaia hânângen ariwin. ");
INSERT INTO spl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mâtâwân arim tatmunŋe Yesuŋe Yerusalem kapi ambolipŋe den ekyongomu nâŋgâŋetâ gemu bet pilâwi yakât yuwu sâm eknongop. “Anitâhât poropetelipŋaŋe yeŋe kapi me hep torehenlipyeŋe orowâk tatmâ den kâsikum yiŋgiŋetâ nâŋgâŋetâ nahat otmap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilaia hânân arimunŋe kapi tatmâ arap ya ambolipŋe emelâk tihit tihit hombaŋ ekne sâm Yerusalem kapiân yâhâ Yesuŋe kulem topŋe topŋe mem ikŋe den pat âlepŋe ekyongomu nâŋgâŋetâ bonŋe olop yaŋe nenekmâ buku otningiwi. ");
INSERT INTO spl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yawu otningiŋetâ ya pilâm âwurem Yesuŋe aŋgoân Kana kapiân kulem âlâ memu to ya purik sâm wain olop yan ariwin. Arimunŋe Kapanaum amboŋe, kiap âlâhât nanŋe ya mesek sâtŋan kinop. ");
INSERT INTO spl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mesek sâtŋan kinmu yan âwâŋaŋe Yesuŋe Kana kapiân âwurem taka tap nâŋgâm kapiŋe pilâm Yesuhâlen taka ekuop. “Nanne mesek sâtŋan tatmâ pilânenekbe sâm oap. Yakât otmâ ari heŋgeŋguhât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sâmu sâop. “Bâe, Galilaia ambolipŋaŋe kulem topŋe topŋe memune ekneâk naŋgai. Ekŋetâ sâtŋe otmu yanâk nâhâlen biwiyeŋe katmai.” ");
INSERT INTO spl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sâmu sâop. “O, lok pato, nanne pilânenekmapgât in yawu ari heŋgeŋguhât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sâmu sâop. “Nâŋgâwaŋgiangât âlepŋe hâmeŋe kinbuap. Yakât otmâ gikiâk emetgan âwurem ari.” Yawu sâop ya nâŋgâmu bulâŋe otmu âwurem ariop. ");
INSERT INTO spl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mâtâwân arim tatmu hoŋ bawalipŋaŋe nanŋe talop yakembâ taka yuwu sâm ekuwi. “Nange yamâ emelâk âlepŋe oap.” ");
INSERT INTO spl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yawu sâŋetâ yuwu sâm âiyongop. “Sâp girawuân âlepŋe oap?” Sâmu sâwi. “Oran hilâm tânâmŋan kundatŋe sânduk sâop,” sâwi. ");
INSERT INTO spl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yawu sâŋetâ kiapŋe yuwu nâŋgâop. “O, bulâŋanâk. Yesuŋe eknohop sâp yanâk nanne âlepŋe olop.” Yawu nâŋgâm Yesuhâlen biwiŋe kalop. Yawu otmâ ari hep torehenlipŋe yakât ekyongomu kerekŋe Yesuhâlen biwiyeŋe katbi. ");
INSERT INTO spl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kândikum Yesuŋe Yuraia hân pilâm Kana kapiân ari kulem memu to ya purik sâm wain olop. Yâhâ kulem yâhâpŋe miop yamâ naom tipiŋe ya âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yakât kakŋan Yura nengât hombaŋ âlâ tetemu Anitâ mepaene sâm lohimbi kiŋgitŋe orowâkŋe Yerusalem kapi patoen menduhuakbi. Otmu sâp yan Yesuŋe menenekmu Yerusalem kapiân yâhâwin. ");
INSERT INTO spl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem kapi ya hawamgum paŋ sâhâwi yakât hâŋgi âlâ, kutŋe Lama sâm, yakât ginŋan bomba âlâ tap, kutŋe Betesira sâm. Otmu bomba yakât ginŋan selep bâtnombot tuhuwi. ");
INSERT INTO spl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Otmu selep yan lohimbi tatbi yamâ topyeŋe yuwu. Nombotŋe pareŋe otbi, nombotŋeâmâ kâiyeŋe goŋgoŋe, nombotŋe âlâmâ senyeŋe bok sâ sâŋe. ");
INSERT INTO spl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tatbi yaŋe yuwu otminiwi. Sâp âlâen âlâen Anitâhât aŋelo âlâŋe himbimângembâ ge bomba kâlehen gemu luk luk sâminiop. Luk luk sâmu yanâmâ tatbi ya yeŋgâlen gâtŋaŋe aŋgoân toen geminiop yamâ wuân me wuân hâhiwin ya in yawu biatbaŋgiminiop. Yawu otminiwi. ");
INSERT INTO spl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Otmu tatbi ya yeŋgâlen gâtŋe âlâŋe pareŋe otmâ tatmâ gamu yambu 38 pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yâhâmâ selep âlâen tatmâ aŋelo bomba kâlehen gemu luk luk sâmu gewe sâm yakât mambotminiop. Yâhâ Yesuŋe lok ya sâp kâlep yawu otmâ gamap ya ekmâ nâŋgâm âikuop. “Gâ âlepŋe otbehât naŋgat me bia?” ");
INSERT INTO spl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sâmu sâop. “Oŋ, yawu naŋgan yukâ. Yawu gârâmâ to yu luk luk sâmu gewe sâm ok bititik ki otmuneâk lok dondâŋe in yawu gemai. Yakât âlâŋe tânnohomu nâŋe sâm gembâm.” ");
INSERT INTO spl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sâmu sâop. “Bâiŋ gâ yahatmâ geretge lâuakmâ lohotŋan ari.” ");
INSERT INTO spl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yawu sâmu yanâk yahatmâ geretŋe lâuakmâ ariop. ");
INSERT INTO spl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Geretŋe lâuakmâ arimu lohimbi yan kinbiŋe ekmâ nâŋgâm bâlewaŋgim yuwu sâwi. “In tatmâ naŋgain. Yawu gârâmâ gâŋe geretge lâuakdâ gekmunŋe ki ârândâŋ oap. Papatolipnenŋaŋe tatmâ nâŋgâmain sâwân âi tuhunomgât samut katbi yakât otmâmâ pilâ.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sâŋetâ sâop. “Yiwereŋe lok âlâ heŋgemnohoapŋe yuwu yap. “Yahatmâ geretge lâuakmâ ari.” Yawu sâmu âlepŋe otmâ yaŋahâmâ yu oan.” ");
INSERT INTO spl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sâmu sâwi. “Lok heŋgeŋgohoap ya kutŋe kundâ nâŋgâne.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yâhâ Yesuŋe emelâk yok pilâm lohimbi dondâ kinbi ya hohetyeŋambâ gem ba ariop. Yakât otmâmâ lok yaŋe Yesu ekmâ tiripyongowe sâm senŋe senŋe otmâ yâhâm giop yamâ ki ehop. ");
INSERT INTO spl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Otmu yapâ pilâm ge opon kâmbukŋan yâhâ Yesu mem teteop. Mem tetemu Yesuŋe yuwu sâm ekuop. “Naŋgat. Nâŋe heŋgeŋgohoan. Yakât otmâ yâhâpŋe otmâ hilipguwuat yamâ hiliwahowuat.” ");
INSERT INTO spl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yawu sâmu lok yaŋe Yura papatolipnenŋe yeŋgâlen ari “Yesuŋe heŋgemnohoap” sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yâhâ Yesuŋe tatmâ nâŋgâminiwin sâpŋan lok ya heŋgeŋguop. Yakât otmâmâ Yura papatolipnenŋaŋe Yesu mem ge katne sâm den hikuwi. ");
INSERT INTO spl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Den hikuŋetâ benŋe Yesuŋe yuwu sâm ekyongop. “Awoŋnaŋe hilâm ârândâŋ âi memap. Yakât otmâ nâku yawuâk âi membomgât sâm nihiop.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yâhâ tatmâ nâŋgâ nâŋgâ sâpŋan lok ya heŋgeŋguop yakât nâŋgâŋetâ bâleop. Yawu otmâ Yesuŋe Anitâhât “Awoŋne” sâmu yakât otmâ Yura papatolipnenŋaŋe yuwu nâŋgâwi. “Yâhâmâ Anitâ orop dopnetŋe konohâk oap sâm ikŋahât nâŋgâmu yahatsap,” yawu sâm yakât kune sâm otbi. ");
INSERT INTO spl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","20","Yawu otŋetâ Yesuŋe yuwu sâm ekyongop. “Nine topne ekyongomune nâŋgâŋet. Nâŋe nine eŋgatneâk âi ki meman. Âi meman yamâ awoŋnaŋe wawaenekmâ tiripnohomu ikŋahâk âi memap yawuâk nâ gurâ meman. Yakât otmâ hâmbâi âi âlâ tiripnohom mâmâŋe otnihimu memune ekŋetâ âlâ kândâkdâ otbuap. ");
INSERT INTO spl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Awoŋnaŋe lok âlâ me âlâhât manmanyeŋe torokatbuapgât dop tap. Otmu nâku yawuâk manman kârikŋe yiŋgiwomgât dop tap. ");
INSERT INTO spl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Otmu lohimbiŋe otŋetâ bâlem gamap ya awoŋnaŋe bâiŋe ki sâm hâreyiŋgiwuap. Âi ya nâŋak bâiŋe sâm hâreyiŋgiwomgât sâm nihiop. ");
INSERT INTO spl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Yâhâ lohimbiŋe Awoŋne ewe katmai yakât dopŋeâk nâ gurâ ewe katnekŋet sâm âi ya nihiop. Yawu gârâmâ lok âlâ me âlâŋe betnihimai yaŋe nâ betnihiain sâm Awoŋne hâŋgânnohomu gewan ya betbaŋgimai. ");
INSERT INTO spl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Lok âlâ me âlâŋe nâhât den pat âlepŋe nâŋgâŋetâ bulâŋe otmu biwiyeŋe awoŋnahâlen katmâ denŋe lâum mannomai ya awoŋnaŋe emelâk manman kârikŋahât pat kuyiŋgiop. Yakât otmâ manman kârikŋahât mâtâwân manŋetâ den âiân ki katyekbuap. ");
INSERT INTO spl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Den âlâ yuwu ekyongomune nâŋgâŋet. Awoŋne Anitâŋe hâŋgânnohomu ge nine den pat âlepŋe ekyongom mansan. Ekyongomune lohimbi biwi pâlâmŋe mansai ya yeŋgâlen gâtŋe nombotŋaŋe nâŋgâŋetâ bulâŋe otmu nâhâlen biwiyeŋaŋe kepeim mannomai yaŋeâmâ manman kârikŋahât bulâŋe menomai. ");
INSERT INTO spl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yakât topŋeâmâ yuwu. Awoŋne yamâ manman amboŋe. Yawu gârâmâ manman yakât galemŋe sâm nihimu yan dopnetŋe konok oap. ");
INSERT INTO spl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Otmu hâŋgânnohomu ge lohimbiŋe otbi mewi yakât bâiŋe sâm hâreyiŋgiwomgât sâm nihiop. ");
INSERT INTO spl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yakât otmâ sâp patoen lohimbi muwi yamâ kerek mândeyekmune mumuŋambâ yahatmâ otbi mewi yakât matŋe menomai. ");
INSERT INTO spl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Yâhâ lohimbi nombotŋaŋe Anitâ betbaŋgim otŋetâ bâlem gaop yamâ den âiân katyekmune yakât matŋe umatŋe menomai. Yâhâ nombotŋaŋe Anitâhât tem lâuwaŋgim âlepŋe manbi yaŋeâmâ manman kârikŋe mannomai. ");
INSERT INTO spl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nine eŋgatneâk âi ki tuhuman. Anitâŋe biwinan katmu tem lâuwaŋgim den sâm hâreyiŋgiman yamâ nâŋgâmu ârândâŋ otmap. ");
INSERT INTO spl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Topne teteâkgât ninak sâman mâne nâŋgâŋetâ nahat otbâp. ");
INSERT INTO spl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Awoŋne manman amboŋaŋe nâhât topne ekmâ nâŋgâŋetgât kulem mem gamap yamâ nâŋgâwaŋgimune bulâŋanâk otmap. ");
INSERT INTO spl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Aŋgoân hoŋ bawalipyeŋe hâŋgânyongoŋetâ Yoanehâlen ariŋetâ nâhât topne bulâŋanâk ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yâhâ Yoane me lok âlâŋe nâhât topne ki sâm tetewi mâne mâtâp âlâ tetenihimbâpgât dop otbâp. Yawu gârâmâ yâkŋe nâhât topne ekyongop ya yiwereŋe nâŋgâŋetâ bulâŋe otmu manman kârikŋan manŋetgât yan. ");
INSERT INTO spl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoanehât nâŋgâŋetâ keterahâkgât âlâen hâum sâmune nâŋgâŋet. Yâkŋeâmâ balamgât dop olop. Balam sem laŋinŋe pilâmu ekmain yakât dopŋeâk yâkŋe den ekyongomu biwiyeŋan hâumu haŋ sâyiŋgiop. Haŋ sâyiŋgimu aŋgoân heweweŋâk nâŋgâwi. Yawu gârâmâ sâp kâlep ki otmuâk betbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nâhât topne yamâ yâkŋe bulâŋanâk ekyongop. Yawu gârâmâ awoŋnaŋe âi sâm nihim hâŋgânnohomu kulem topŋe topŋe memune yan nâhât topne tâŋ tâŋâk tetemu ekmai. ");
INSERT INTO spl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yawu gârâmâ awoŋne ki ekmâ denŋeâk nâŋgâm gamai. ");
INSERT INTO spl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Otmu yâkâlen biwiyeŋaŋe gurâ ki kepeim manmai. Yakât otmâ awoŋnaŋe poropetelipŋe ekyongomu kulemguwi ya nâŋgâŋetâ ki keterakyiŋgimap. Otmu nâhât gurâ nâŋgâŋetâ nahat otmu yawuâk nâhâlen biwiyeŋaŋe ki kepeimai. ");
INSERT INTO spl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yeŋeâmâ manman kârikŋe mene sâm poropetelipŋe den kulemguwi ya haoŋmâ ârândâŋ sâlikum ekmâ tatmai. Yawu gârâmâ yeŋe nâhât topne ekŋetâ keterahâkgât den yu poropetelipŋaŋe kulemguwi. Yu sâlikum heŋgeŋgumai mâne âlepŋe nâhât topne nâŋgâm heŋgeŋgumbâi. ");
INSERT INTO spl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yamâ yeŋe manman kârikŋe mene sâm yan nâhât hâkâŋ otmâ biwiyeŋe nâhâlen ki katmai. ");
INSERT INTO spl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yawu gârâmâ lok âlâ me âlâŋe nâhât nâŋgâŋetâ yahalâkgât ki gewan. ");
INSERT INTO spl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yawu gârâmâ biwiyeŋe Anitâhâlen ki ari kinmap ya emelâk naŋgan. ");
INSERT INTO spl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yakât otmâ awoŋnaŋe âi sâm nihim hâŋgânnohomu gewan yakât nâŋgâŋetâ ki bulâŋe otmu betnihim mansai. Yawu gârâmâ lok âlâ me âlâŋe eŋgatyeŋeâk otmâ yeŋgâlen taka den ekyongomai lok yawuya yeŋgât nâŋgâŋetâ yahatmu buku otyiŋgimai. ");
INSERT INTO spl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yeŋe yeŋahâlâk naŋgaŋgiŋetâ yahatmap. Yawu gârâmâ Anitâ ikŋak yekmu ârândâŋ olâkgât ki nâŋgâmai. Ya otmai yakât nâŋgâŋetâ porap otmap. Gârâmâ nâhât den pat yamâ girawu nâŋgâŋetâ bulâŋe otbuap? ");
INSERT INTO spl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","47","Yeŋeâmâ nâhât den nâŋgâŋetâ gemu bet pilâm nâhâlen biwiyeŋe ki katmai. Yamâ nâŋe awoŋnahât senŋan kinmâ den âiân ki katyekbom. Yakât yuwu sâmune nâŋgâŋet. Moseŋe Anitâhât girem den kulemguop yamâ “lâum manmunŋe Anitâŋe tihitnenŋe otbuap.” yawu sâmai. Yawu gârâmâ nâhât topne nâŋgâŋetâ keterahâkgât Moseŋe den ya kulemguop. Yakât otmâmâ Moseŋe den kulemguop ya yeŋe nâŋgâŋetâ bulâŋe otmap mâne emelâk biwiyeŋe nâhâlen katbâi. Yawu gârâmâ den ya nâŋgâŋetâ porap otmap. Gârâmâ nâhât den pat yamâ girawu nâŋgâŋetâ bulâŋe otbuap?” Yawu sâm ekyongomu pilâyekmâ opon kâmbukŋambâ gem ariwin. ");
INSERT INTO spl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Otmu yakât kakŋan Galilaia deŋgân, kutŋe âlâmâ Tiweria deŋgân, Yesuŋe yakât nombotgen ariwe sâm hoŋ bawalipŋe menenekmu orowâk ariwin. ");
INSERT INTO spl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yâhâ emelâk Yesuŋe mesek topŋe topŋe heŋgemyongop ya ekbi yakât otmâ arimunŋe lohimbi kiŋgitŋe orowâkŋe betnenŋan watnenekbi. ");
INSERT INTO spl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Watnenekŋetâ ari lohimbi ya pilâyekmâ Yesu orop pumŋe âlâen yâhâ tatbin. ");
INSERT INTO spl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tatmâ Tihit tihit hombaŋ ya tâlâhuop yakât alahuwin. ");
INSERT INTO spl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Alahum tatmunŋe lohimbi dondâŋe watnenekmâ takawi ya Yesuŋe yekmâ yuwu sâm Pilip âikuop. “Lohimbi dondâ takai yu wosapâ sot puluhum yiŋgimunŋe neŋetâ dopyeŋan otbuap?” sâm âikuop. ");
INSERT INTO spl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yâhâ sot kâsikum yiŋgimu neŋetâ dopyeŋan otbuap ya nâŋgâop. Yawu gârâmâ Pilipgât biwiŋe girawu talop ya sâm tetemu nâŋgânehât Pilip âikumu yuwu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","“Âo, lohimbi dondâŋe taka tai. Yakât otmâ sot tipiŋe ikŋak ikŋiâk nenomai yamâ tewetsenŋe pato pilâm sot puluhunom. Lok âlâŋe emetsenŋe nombolân yâhâp biwiŋan âi tuhum hâmeŋe membuap yakât dop otbuap. Yakât otmâ gâŋe den yat yu lauhan menomgât dop bia.” ");
INSERT INTO spl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yawu sâmu nengâlen gâtŋe âlâ, Simon Petoro imiŋe, kutŋe Anderea sâm, yâkŋe yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Naom tipiŋe âlâ taka tapŋe baŋga mome otmu iŋan yâhâp mem tap. Yawu gârâmâ girawu otne? Sot yuŋe dopyeŋan ki otbuap yukâ.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yawu sâmu Yesuŋe yuwu sâm eknongop. “Yeŋe lohimbi yu ekyongoŋetâ ge tatŋet.” Yawu sâmu lauŋan mem lok yeŋgât dowâmâ 5000 yawuya ekyongomunŋe ge tatbi. ");
INSERT INTO spl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ge tatŋetâ Yesuŋe baŋga ya mem Anitâ mepaem motokmâ tipi tapi tuhum mem ningimu ârândâŋâk kâsikum yiŋgimunŋe newi. Yâhâ iŋan gurâ yawuâk mem ningimu kâsikum yiŋgimunŋe neŋetâ dopyeŋan olop. ");
INSERT INTO spl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Neŋetâ dopyeŋan otmu yuwu sâm eknongop. “Sot nombotŋe tap ya bâlemapgât hâwurum saka sakaen mânuŋetâ giâk.” ");
INSERT INTO spl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yawu sâmu hâwurum mânuŋmunŋe saka saka kâiân yâhâp pik sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yesuŋe kulem ya memu ekŋetâ sâtŋe otmu yuwu sâm alahu gulahu otbi. “Poropete âlâ hohetnenŋan tetewuap sâŋetâ nâŋgâm mambotmain ya yu mon?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yawu sâŋetâ Yesuŋe biwiyeŋe ekmâ yâkŋe kutdâyeŋe mem kânâŋgânekmaihât nâŋgâm pilâyekmâ gem ba pumŋe âlâen yâhâop. ");
INSERT INTO spl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Emet omoŋ otmu Yesuŋe in yawu ki âwurem takaopgât nenŋe yapâ pilâm Kapanaum kapiân arine sâm deŋgân ginŋan gewin. ");
INSERT INTO spl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ge waŋga mem arim tatmunŋe siru pato pilâmu to dondâ bâleop. ");
INSERT INTO spl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yawu otmu puli kum tânâmgum arim tatmunŋe kilomita bâtnombot me nombolân konok dop yawu olop. Yawu otmu arimunŋe Yesuŋe to kakŋambâ takaop. Takamu ekmâ “wuânŋe takap?” sâm ekmâ umutnenŋe ariop. ");
INSERT INTO spl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Umutnenŋe arimu Yesuŋe nenekmâ yuwu sâop. “Nâ ninak takan. Yawu gârâmâ kiŋgityeŋahât ki otŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yawu sâmu tepnenŋe welâmŋan gemu in yawu memunŋe waŋgaen yâhâop. Waŋgaen yâhâmu nenŋe in yawu ari kapi ya mewin. ");
INSERT INTO spl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kapi pilâm tohowin yakât ambolipŋaŋe emet haŋ sâmu Yesuhât pâinmâ yuwu sâwi. “Oran waŋga konohâk ekbin yamâ Yesu hoŋ bawalipŋaŋe yeŋiâk mem ariwi.” ");
INSERT INTO spl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yawu sâm pâinbi. Otmu Tiweria kapi ambolipŋaŋe Yesuhât pat nâŋgâm waŋga âlâlâ mem kapiyeŋehembâ taka emelâk Kutdânenŋaŋe sot mem yan Anitâ mepaem yiŋgimu newi yanâk taka tatbi. ");
INSERT INTO spl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Taka Yesuhât pâinŋetâ biatmu yaŋak waŋga ya yâhâpŋe mem Kapanaum kapiân ari pâinbi. ");
INSERT INTO spl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Waŋgayeŋe Kapanaum kapiân karakmâ ge Yesu mem tetem yuwu sâm âikuwi. “Wa, lok pato gâ amâti takaon.” ");
INSERT INTO spl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yawu sâm âikuŋetâ yuwu sâm ekyongop. “Yaihât sâmune nâŋgâŋet. Nâŋe kulem topŋe topŋe memune ekmâ topŋe ki nâŋgâm heŋgeŋgumai. Yâhâ sot yiŋgimune neŋetâ tepyeŋe pik sâop yakât nâŋgâm pâinnekmâ takai. ");
INSERT INTO spl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yakât yuwu sâmune nâŋgâŋet. Sot nemain yaŋe kâlep ki tatmâ yâhâwuap. Yamâ tatmâ getek ŋâsukŋe pilâmap. Yakât otmâ sot nemain yakâlâk ki nâŋgânomai. Yawu gârâmâ sot topŋe âlâ ikŋiâk tap ya nem manman kârikŋe manmâ yâhânomai yakâlâk nâŋgânomai. Yawu gârâmâ Awoŋne Anitâŋe nâŋgânihimu ârândâŋ otmu âi sâm nihim hâŋgânnohomu ge yâkât sâtgât manman kârikŋahât sot yiŋgiwom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yawu sâmu yuwu sâm âikuwi. “Anitâhât den lâune sâm girawu tuhunomgât naŋgat?” ");
INSERT INTO spl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Sâŋetâ sâop. “Anitâŋe nâ hâŋgânnohomu gewan. Yakât otmâ nâhâlen biwiyeŋe katmâ mannomaihât naŋgap.” ");
INSERT INTO spl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Sâmu sâwi. “Emelâk tâmbâlipnenŋe lok ki manmaiângen manŋetâ Anitâŋe himbimâmbâ sot âlâ, kutŋe mana sâm, yiŋgimu nem manbi yakât topŋe miti pepaen yuwu tap. “Himbimâmbâ sot yiŋgimu nem manbi.” Yawu tap. Yawu gârâmâ gâŋe kulem âlâ mendâ ekmunŋe âlâ kândâkdâ otmu den yat yu nâŋgâmunŋe bulâŋe otbuap. Wuân mendâ topge tetemu ekmunŋe bulâŋe otbuap?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sâŋetâ sâop. “Anitâŋe himbimâmbâ sot bulâŋe yiŋgimap yakât topŋe nâŋgâŋetâ keterahâkgât yuwu sâmune nâŋgâŋet. Moseŋe himbimâmbâ sot bulâŋe ya ki mem tetem yiŋgiop. Bia. Himbimâmbâ sot bulâŋe yamâ yiwereŋe Awoŋnaŋe yiŋgimu mansai. ");
INSERT INTO spl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sot bulâŋe yamâ Anitâŋe nâ hâŋgânnohomu himbimâmbâ ge manman kârikŋe yiŋgim mansan.” ");
INSERT INTO spl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sâmu sâwi. “Bâe. Lok pato, gâ den yat, yuâmâ sot ya haoŋmâ ârândâŋ ningirâ nem yâhânom.” ");
INSERT INTO spl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sâŋetâ sâop. “Manman kârikŋahât sot yan yuâmâ ninahât yan. Yakât otmâ lok âlâ me âlâŋe biwi nâŋgân nâŋgânyeŋaŋe nâ kepeinekmâ mannomai. Yâhâmâ nâŋe mâmâŋe otyiŋgimune manman kârikŋahât sot yakât yâhâpŋe ki po yiŋgiwuap. Me manman kârikŋahât to yakât yâhâpŋe ki yekbuap. ");
INSERT INTO spl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Yawu gârâmâ kulem topŋe topŋe memune yeŋe ekmâ topŋahât hâum pâpgum nâhâlen biwiyeŋaŋe ki kepeim mansai. ");
INSERT INTO spl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yawu gârâmâ lohimbi âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim manŋetgât Awoŋnaŋe meyekmu mansai. Meyekmu nâhâlen torokatmâ biwiyeŋaŋe kepeiŋetâ ki betyongowom. ");
INSERT INTO spl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","40","Awoŋnaŋe âi sâm nihim himbimâmbâ hâŋgânnohomu gewan. Gem yâkât tem lâum manmune lohimbi âlâ me âlâŋe nekmâ topne nâŋgâm heŋgeŋgum nâhâlen biwiyeŋaŋe kepeimai. Lohimbi yawu otmai yamâ nâŋe sâp patoen mumuŋambâ mem yahatyekmune manman kârikŋahât pat emelâk Anitâŋe kuyiŋgimu tap yakât bulâŋe yiŋgimu menomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yawu gârâmâ “sot bulâŋe yamâ Anitâŋe nâ hâŋgânnohomu himbimâmbâ ge manman kârikŋe yiŋgim mansan,” ya sâop yakât papatolipnenŋaŋe nâŋgâŋetâ bâlemu yuwu sâm alahu gulahu otbi. ");
INSERT INTO spl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Nenâmâ yâkât topŋe naŋgain. Yâhâmâ Yosep nanŋe yakâ. Âwâŋe mâmâŋe yetgât topyetŋe naŋgain. Gârâmâ wongât “Nâ himbimâmbâ gem mansan,” yap? Yakât nâŋgâmunŋe bâleap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sâŋetâ sâop. “Kâmbukŋe. Nâŋgâm bâlenihiŋetâ ki ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Awoŋnaŋe hâŋgânnohomu gewan. Yakât otmâ lohimbi âlâ me âlâ meyekbuap yâkŋak nâhâlen torokatnomai. Nâhâlen torokatmâ mannomai yamâ sâp patoen nâŋe mumuŋambâ mem yahatyekmune nâ orowâk tatmâ yâhânom. ");
INSERT INTO spl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Emelâk emet inânŋan poropete âlâŋe den kulemguop ya yuwu tap. “Anitâ ikŋak denŋe lohimbi biwiyeŋan katmu nâŋgâŋetâ keterakbuap.” Yawu kulemguop. Den yakât bonŋe teteâkgât awoŋnaŋe denŋe lohimbi biwiyeŋan katmu nâŋgâŋetâ hâumu nâhâlen torokatmai. ");
INSERT INTO spl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yawu gârâmâ lohimbi âlâ me âlâŋe Awoŋnahâlen ki yâhâŋetâ den kâsikum yiŋgimap. Yawu ki tap. Nâŋe konok Anitâ Awoŋne orop tatmâ yâkât sâtgât otmâ gewan. ");
INSERT INTO spl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yakât otmâ yuwu sâmune nâŋgâŋet. Lohimbi âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim manmai yamâ manman kârikŋan mannomaihât pat kuyiŋgimune tap. ");
INSERT INTO spl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yâhâmâ manman kârikŋahât sot yiŋgimune nem manmâ yâhânomai. ");
INSERT INTO spl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Manman kârikŋahât sot yakât yâhâpŋe torokatmâ sâwe. Tâmbâlipnenŋaŋe lok ki manmaiângen manminiwi yan Anitâŋe himbimâmbâ sot âlâ, kutŋe mana sâm, ya yiŋgimu nem gawi. Otmu ya gurâ emelâk mum metewi. ");
INSERT INTO spl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gârâmâ himbimâmbâ manman kârikŋahât sot yamâ nâ. Yakât otmâ lohimbi âlâ me âlâŋe nine hepne sunumne nemaiŋeâmâ ki hiliwahonomai. ");
INSERT INTO spl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yâhâ manman kârikŋahât bulâŋe teteyiŋgiâkgât nâŋe konok himbimâmbâ ge nine hepne sunumne yu yeŋgât pat kuyiŋgiwan yu yiŋgimune nem manman kârikŋan mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yawu sâmu Yura nengât papatolipnenŋaŋe nâŋgâm alahu gulahu otmâ yuwu sâwi. “Lok yuŋeâmâ ki orotŋe yap. Girawu otmâmâ ikŋe sunumŋe ya gahaeakmâ ningimu nenomgât yap? Ki orotŋe yukâ.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yawu sâm alahuŋetâ Yesuŋe yuwu sâm ekyongop. “Ninahât sâmune nâŋgâŋetâ ki keterakyiŋgiap yakât âlâku sâmune nâŋgâŋet. Nâmâ lok bulâŋe mansan. Yakât otmâ nine hepne sunumne yu ki nenomai yamâ manman kârikŋan ki mannomai. ");
INSERT INTO spl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","56","Yawu gârâmâ nine hepne sunumne yuŋeâmâ manman kârikŋe yakât bulâŋe oap. Yakât otmâmâ lohimbi âlâ me âlâŋe nine hepne sunumne nem mannomai yamâ sâp patoen mumuŋambâ mem yahatyekmune biwinenŋe kepeiakmâ konohâk otmâ orowâk manmâ yâhânom. ");
INSERT INTO spl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Awoŋne manman amboŋaŋe hâŋgânnohomu gewan. Yakât otmâ yâkât wâtŋanâk kinmâ yâkŋe tatmap yakât dopŋeâk nâ gurâ mansan. Yâhâ yeŋgâlen gâtŋe âlâ me âlâŋe nine hepne sunumne yu nemai yen gurâ nâŋe manmâ yâhâwom yakât dopŋeâk manmâ yâhânomai. ");
INSERT INTO spl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yawu gârâmâ emelâk tâmbâlipnenŋaŋe sot âlâ, kutŋe mana sâm, newi yan manman kârikŋe ki ekbi. Yawu otmâ mum gawi. Yâhâ sâp yiwereŋe yuâmâ nine hepne sunumne nenomai yamâ manman kârikŋan manmâ yâhânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuŋe Kapanaum yeŋgât miti emetŋan yâhâ den yu ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesuŋe nengât papatolipnenŋe yawu sâm ekyongomu yan lohimbiŋe denŋe nâŋgâne sâm yâkâlen torokatmâ manbi nombotŋaŋe alahu gulahu otmâ yuwu sâwi. “Den yap yuâmâ nâŋgâmunŋe umatŋe oap yakât otmâ yâkât den yu âlâŋe nâŋgâwuap?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yawu sâm hâkâŋ otŋetâ Yesuŋe biwiyeŋe ekmâ yuwu sâop. “Den yan yukât âlâŋe ki ekyongop? Girawuhât otmâ nâŋgâŋetâ umatŋe oap? ");
INSERT INTO spl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Gârâmâ nâŋe hâmbâi himbimân âwurem yâhâmune nekmâ yanâmâ girawu nâŋgânomai? Nâŋgâŋetâ bulâŋe otmu nâhâlen biwiyeŋe katnomai me bia? ");
INSERT INTO spl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yakât otmâ yuwu sâmune nâŋgâŋet. Lohimbi âlâ me âlâŋe yeŋe eŋgatyeŋaŋak otmâ manman kârikŋan mannomaihât dop âlâ ki tap. Yakât otmâ Anitâhât Wâtgât mâmâŋahât Heak yâkŋak mâmâŋe otyiŋgimu manman kârikŋan mannomaihât dop tap. Yakât otmâmâ den yan yu nâŋgâŋetâ bulâŋe otmu Wâtgât mâmâŋahât Heakŋe mâmâŋe otyiŋgimu biwiyeŋe nâhâlen katmâ manman kârikŋe mannomai. ");
INSERT INTO spl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yawu gârâmâ yeŋgâlen gâtŋe nombotŋane ki nâŋgâŋetâ bulâŋe otmap.” Yawu sâop. Yâhâ lohimbi nombotŋaŋe biwiyeŋe Yesuhâlen ki katbi yâhâmâ emelâk topyeŋe nâŋgâop. Yâhâ lok âlâŋe Yesuhât betŋehen kioŋbuap ya gurâ yawuâk emelâk topŋe nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yakât nâŋgâm yuwu torokatmâ ekyongop. “Emelâk ekyongoan ya âlâkuâk sâmune nâŋgâŋet. Awoŋnaŋe lohimbi âlâ me âlâ mem heweweŋ tuhuyekbuap yâkŋak nâhâlen torokatnomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yawu sâopgât lohimbi nombotŋaŋe nâŋgâŋetâ umatŋe otmu pilâm âlâengen ariwi. ");
INSERT INTO spl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ariŋetâ Yesuŋe hoŋ bawalipŋe kâiân yâhâp yuwu sâm eknongop. “Yen gurâ yawuâk pilânekmâ arine sâm oai me bia?” ");
INSERT INTO spl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Sâmu Petoroŋe sâop. “Kutdâ, gâŋe konok Anitâhât nanŋe bulâŋe manmâ manman kârikŋahât topŋe eknongorâ nâŋgâmunŋe bulâŋe otmap. Gâhât topge emelâk nâŋgâwin yakât otmâ pilâhekmâ lok âlâhâlen ari denŋe lâum manman kârikŋan mannomgât dop âlâ ki tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yawu sâmu yuwu sâm eknongop. “Bulâŋanâk nâŋe konok meyekban. Yawu gârâmâ weke bâleŋe ya yeŋgât amboyeŋe kutŋe Satan sâm yâkŋe yeŋgâlen gâtŋe âlâhât biwiŋan kioŋmu yâkât tem lâum mansap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yâhâ Yesuŋe den sâop yaŋe bukunenŋe Yurasi, Simon nanŋe, yamâ Karioto kapi amboŋe ya miop. Yâkŋe gâmâlâk Yesuhât betŋehen kioŋbuap yakât. ");
INSERT INTO spl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Otmu yakât kakŋan Yura nengât papatolipnenŋaŋe Yesu kune sâm otbi. Yawu otŋetâ yaŋak Yuraia hân panmâ kapi tipi tapi Galilaia hânân tatmâ arap ya yeŋgâlen ari den kâsikum yiŋgim manop. ");
INSERT INTO spl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yan ari manmu tâmbâlipnenŋaŋe selep tuhuminiwi yakât hombaŋ ya tâlâhuop. ");
INSERT INTO spl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Otmu Yesu imilipŋaŋe denŋe nâŋgâŋetâ nahat otmu yuwu sâm ekuwi. “Selep tuhuminiwi yakât hombaŋ tâlâhuap. Yakât otmâ lohimbi kiŋgitŋe orowâkŋe Yerusalem kapi patoen menduhuakmâ heroŋe otnomai. Gâŋe yan kulem mendâ lohimbiŋe eknomaihât kapi yu pilâm Yuraia hânân ari. Yan ari lohimbi nombotŋaŋe gâhât den nâŋgâne sâm otmâ mansai ya senyeŋan kulem âlâlâ mendâ ekmâ gâhât den pat sâm haok tuhunomai. Lohimbi kerekŋe gâhât nâŋgâŋetâ yahalâkgât gâ tetekŋan kinmâ kulem mendâ eknomaihât naŋgain. Gârâmâ kapi tipi tapi yuânâk manbuat yamâ girawu otmâ kutge pato otbuap?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","8","Sâŋetâ yuwu sâm ekyongop. “Yeŋe eŋgatyeŋaŋak otmâ yu me ya âlepŋe otmai. Yakât otmâ Yerusalem kapi patoen yâhâ hombaŋ ekne sâm âlepŋe ekmâ heroŋe otnomai. Heroŋe otŋetâ yanâmâ nengât papatolipnenŋaŋe yekmâ ki kuk otyiŋginomai. Yâhâ nâmâ eŋgatneâk ki otman. Awoŋnaŋe sâm nihiop ya watmâ otman. Yakât otmâ lohimbiŋe orotmemeyeŋe bâleŋe otmai yakât kuk otnihimai. Yawu gârâmâ nine topne tetemu eknomaihât sâp ki tâlâhuap. Yakât otmâmâ ki yâhâwom. Gârâmâ yeŋeâmâ âlepŋe hombaŋ ari ekŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yawu sâmu imilipŋaŋe pilâm yeŋiâk ba ariwi. ");
INSERT INTO spl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pilâm ariŋetâ Yesuŋe hoŋ bawalipŋe menenekmu belângen watyekmâ yâhâwin. ");
INSERT INTO spl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yâhâmunŋe lohimbiŋe menduhuakmâ sot um nem heroŋe otbi yan Yura nengât papatolipnenŋaŋe Yesuhât pâinbi. Pâinmâ “Yesu wosapâ tap?” sâm âiyongom yâhâm gewi. ");
INSERT INTO spl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Âiyongom yâhâm geŋetâ lohimbi dondâŋe kiŋgityeŋahât otmâ Yesuhât den lohotŋan alahu gulahu otbi. Alahum hioŋakmâ nombotŋaŋe yuwu sâwi. “Yesuŋe âiloŋgo tânnongom mansap,” sâwi. Yâhâ nombotŋaŋeâmâ sâwi. “Bia. Yâkŋeâmâ lohimbi kâityongomu mâtâp tâpikgum otmâ hilipgumai,” sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Otmu hombaŋ ya tânâmgumu Yesuŋe opon kâmbukŋan yâhâ lohimbi kinbi ya den kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Den kâsikum yiŋgimu papatolipnenŋaŋe ekmâ pârâk pilâm yuwu sâwi. “Yâhâmâ ekap emetŋan ki yâhâop. Yawu gârâmâ miti yap yuâmâ girawu nâŋgâmapgât yap?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yawu sâŋetâ Yesuŋe yuwu sâm ekyongop. “Den yan yuâmâ nine den bia. Anitâŋe hâŋgânnohomu ge yâkât sâtgât otmâ denŋe ekyongoan. ");
INSERT INTO spl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yakât otmâ nine eŋgatnaŋak ki otman ya lohimbi âlâ me âlâŋe Anitâhât tem lâumaiŋeâmâ nâŋgâm heŋgeŋgumai. ");
INSERT INTO spl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lok âlâ me âlâŋe yeŋahâk den ekyongomai yaŋeâmâ lohimbiŋe nâŋgâyiŋgiŋetâ yahalâkgât den ekyongomai. Yâhâ nâmâ Anitâ orop biwinetŋe konohâk otmu âi sâm nihim hâŋgânnohop. Hâŋgânnohomu gewan yâkâlâk nâŋgâŋetâ yahalâk nâŋgâm uwawapŋe bia tuhum manmâ den imbiâk ki sâman. ");
INSERT INTO spl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yawu gârâmâ yeŋe gurâ Moseŋe girem den kulemguop ya kerek ki lâumai. Yakât otmâ topŋe girawuhât otmâmâ nâ nohone sâm oai?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yawu sâm ekyongomu lohimbi kinbiŋe yuwu sâwi. “Maiŋ, wonânŋe gohone sâm oai? Gâmâ weke bâleŋaŋe mâŋgâehekmu biwihe hâlim milim otmu yat.” ");
INSERT INTO spl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sâŋetâ sâop. “Nâmâ tatmâ nâŋgâ nâŋgâ sâpŋan lok pareŋe âlâ heŋgeŋguwan. Heŋgeŋgumune kulem ya ekŋetâ sâtŋe olop yakât nâŋgâŋetâ bâleap. ");
INSERT INTO spl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Nâŋe otmune ki bâleop. Yakât yuwu sâmune nâŋgâm heŋgeŋguŋet. Tâmbâlipnenŋaŋe hâkyeŋahât torehenŋan undip tuhuaŋgiminiwi ya yeŋe torokatmâ otmâ yâhânomaihât Moseŋe girem den kulemguop. Yakât otmâmâ girem den lâuain sâmai yamâ tatmâ nâŋgâ nâŋgâ sâpŋan nanlipyeŋe ihilâk hâkyeŋahât torehenŋan undip tuhuyiŋgimai. Yawu gârâmâ nâŋe gurâ tatmâ nâŋgâ nâŋgâ sâpŋan lok pareŋe heŋgeŋguwan yakât topŋe girawuhât nâŋgâŋetâ bâleap. ");
INSERT INTO spl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Lok âlâ me âlâŋe otmai memai ya yeŋeâmâ kakŋeâk kakŋeâk ekmâ yakât sâmai. Wongât otmai memai ya ki ekmâ nâŋgâm heŋgeŋgum sâmai. Yakât nâŋgâmune ki ârândâŋ oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yawu sâmu Yerusalem kapi ambolipŋe nombotŋaŋe yuwu sâwi. “Lok yuâmâ papatolipnenŋaŋe kune sâm oai. ");
INSERT INTO spl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lok yuâmâ tetekŋanâk kinmâ den kâsikum yiŋgim mansap. Yakât otmâmâ wongât papatolipnenŋaŋe ki kuwaŋgim mansai? Anitâŋe hâŋgângumu giop yawu nâŋgâm yakât ki kuwaŋgimai mon? ");
INSERT INTO spl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yâhâ Anitâŋe hâŋgângumu gewuap yâkât hep torehenlipŋe ki nâŋgânom. Otmu topŋe yamâ hâum pâpgunom. Yâhâ Yesuhât hep torehenlipŋe yeŋgât hârok nâŋgâyiŋgiain. Yakât otmâ Anitâŋe ki hâŋgângumu giop yawu oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yawu sâŋetâ Yesuŋe opon kâmbukŋan yâhâ den kâsikum yiŋgim yuwu sâm ekyongop. “Bulâŋanâk yeŋe hep torehenlipne yeŋgât naŋgai. Yamâ benŋe nâhât topne nâŋgâm hâum pâpguai. Nâmâ nine eŋgatneâk otmâ ki gewan. Manman bulâŋahât amboŋaŋe hâŋgânnohomu gewan. Yamâ benŋe yâkât topŋeâmâ yeŋe ki naŋgai. ");
INSERT INTO spl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nâmâ yâkŋe hâŋgânnohomu gewan yakât otmâ yâkât topŋe nâŋgâm heŋgeŋguan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yawu sâmu papatolipnenŋaŋe nâŋgâŋetâ bâlemu mem pâi emetŋan katne sâm otbi. Yawu gârâmâ mumbuapgât sâp kalop ya ki tâlâhuop yakât membâihât dop ki olop. Yakât otmâ pilâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yawu gârâmâ lohimbi nombotŋaŋe denŋe nâŋgâŋetâ bulâŋe otmu alahu gulahu otmâ yuwu sâwi. “Yesuŋe kulem topŋe topŋe mem gap ya Anitâhât hoŋ bawaŋe âlâ hâŋgângumu ge tihitnenŋe otbuap sâmai yaŋe wangim âlâlâ ki membuap.” Yawu gârâmâ lok sâmai ya bulâŋanâk Yesu sâm yâkâlen biwiyeŋe katbi. ");
INSERT INTO spl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Otmu lohimbi nombotŋaŋe yawu sâm alahu gulahu otŋetâ Parisaioŋe nâŋgâŋetâ bâlemu yakât hotom uminiwi yeŋgâlen ariŋetâ den hikum Yesu mem pâi emetŋan katne sâm tembe lâulipyeŋe hâŋgânyongowi. ");
INSERT INTO spl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hâŋgânyongoŋetâ Yesuhâlen ariŋetâ yuwu sâm ekyongop. “Nâ yen orop sâp tâlâwâk manmâmâ hâŋgânnohomu takan yâkâlen âwurem ariwom. ");
INSERT INTO spl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Âwurem arimune pâinneknomai. Yawu gârâmâ ariwom yan gurâ yeŋe arinomaihât mâtâp âlâ ki tap. Yakât otmâ yâhâpŋe ki neknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","Yawu sâmu yâkŋe yuwu sâm alahu gulahu otbi. “ “Pâinneknomai yan ki neknomai. Otmu ariwom yan gurâ arinomaihât mâtâp ki tap,” yap. Yakât otmâ wosaken arimu yan pâinmâ ki mem tetenom? Anitâhât dengât pâpgumai yeŋgâlen emelâk bukulipnenŋaŋe den kâsikum yiŋgim mansai. Ya orop ari mannomaihât yap me wosaken ariwuapgât yap?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Otmu selep tuhuminiwi yakât hombaŋ ya bia otbe sâm otmu yan lohimbi kerekŋe menduhuakmâ kai toka pato otminiwi. Yâhâ menduhuakbiân Yesuŋe yahatmâ kinmâ yuwu sâm ekyongop. “Lohimbi âlâ me âlâ manman kârikŋahât to yakât yeksap yamâ nâhâlen ga neŋet. ");
INSERT INTO spl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Emet inânŋan poropete nombotŋaŋe den âlâen hâum kulemguwi yakât topŋe yuwu tap. “Lohimbi âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim mannomai yamâ biwiyeŋambâ manman kârikŋahât to ya hindakmâ hirik hirik sâm imbuap.” Kulemguwi yakât topŋe yawu tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesuŋe den yu sâop yamâ tohât ki sâop. Yâhâ Yesu himbimân ki âwurem yâhâopgât otmâ Anitâŋe Wâtgât mâmâŋahât Heak ki hâŋgângumu giop. Yâhâ sâp yiwereŋe yuâmâ nenŋe biwi nâŋgân nâŋgânnenŋe Yesuhâlen katmunŋe yanâmâ Wâtgât mâmâŋahât Heakŋe nengâlen ge mâmâŋe otningimap yakât sâop. ");
INSERT INTO spl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yawu sâmu nâŋgâm lohimbi nombotŋaŋe yuwu sâwi. “Yamâ poropete pato takawuap sâmain ya mat takamu eksain” ");
INSERT INTO spl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yâhâ nombotŋaŋeâmâ yuwu sâwi. “Bulâŋanâk Anitâŋe lok yuŋe tihitnenŋe olâkgât hâŋgângumu ge mansap.” Yawu sâwi. Yawu gârâmâ nombotŋaŋeâmâ nâŋgâm hilipgum yuwu sâwi. “Bâe, Yesu yuâmâ Galilaia amboŋe. ");
INSERT INTO spl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yamâ Anitâŋe lok âlâŋe tihitnenŋe otbuapgât hâŋgângumu gewuap yamâ Dawitihât senân gâtŋe. Otmu Betelem kapiân tetewuap. Yâkât topŋe yawu miti pepaen kulemguwi tap. Yakât otmâ Yesu yuâmâ Anitâŋe ki hâŋgângumu giop, yawu eksain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yesuhât topŋahât yawu sâm alahum hioŋakbi. ");
INSERT INTO spl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yâhâ nombotŋaŋeâmâ pâi emetŋan mem katne sâm otŋetâ umatŋe otmu pilâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yawu otŋetâ Parisaio otmu hotom uminiwi yeŋgât tembe lâulipyeŋaŋe purik sâm kunlipyeŋe yeŋgâlen ariŋetâ yuwu sâm âiyongowi. “Yen wongât Yesu ki mem takai?” ");
INSERT INTO spl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sâŋetâ sâwi. “Yâkŋe den sâmu nâŋgâmunŋe âlâ kândâkdâek otmu yaŋak inâk takain. Yâhâmâ topŋe ikŋiâk.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yawu sâŋetâ Parisaioŋeâmâ yuwu sâwi. “Bâe, Yenâmâ denŋe nâŋgâŋetâ biwiyeŋe gulip oap. ");
INSERT INTO spl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nenŋeâmâ denŋe nâŋgâmunŋe porap otmap. Otmu kunlipnenŋaŋe nâŋgâŋetâ nahat otmap. Yakât otmâ nenâmâ biwinenŋe alitmâ mansain. ");
INSERT INTO spl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yamâ lohimbi inŋe mansai yaŋe Mosehât girem den ki nâŋgâm heŋgeŋgumai. Yakât otmâ Anitâŋe hem nâpumân pilâyekmu ge matŋe umatŋe menomai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yawu sâŋetâ yâk yeŋgâlen gâtŋe âlâ, kutŋe Nikotemo sâm, yâhâmâ emelâk Yesuhâlen arimu den huhuowot. Yâkŋe yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mosehât girem den âlâ yuwu tap. “Lok âlâŋe ikŋe topŋe ki sâm tetem sârereakmuâk yâkât tosa yakât sâm hârewaŋginomgât dop âlâ ki tap.” Den yawu tap yakât nenŋe Yesuhât in yawu sâm hârewaŋgimunŋe ki ârândâŋ otbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yawu sâmu bukulipŋaŋe nâŋgâm bâlewaŋgim yuwu sâwi. “Bâe, gâmâ Galilaia ambolipŋe yeŋgât nâŋgârâ yahatmap yukâ. Emelâk miti pepaen kulemguwi ya sâlikum yuwu ekbuat. Anitâŋe Galilaia amboŋe âlâ poropete âi ki sâm waŋmap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yawu sâm gem itoŋ galoŋ otmâ emetyeŋehen ariwi. ");
INSERT INTO spl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Otmu Yesuŋe Yerusalem kapi pilâm gem Oliwa pumŋan yâhâop. ");
INSERT INTO spl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Emet haŋ sâmu kapiân âwurem ari opon kâmbukŋan yâhâmu lohimbi kiŋgitŋe orowâkŋe denŋe nâŋgâne sâm menduhuakbi. Menduhuakŋetâ den kâsikum yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Den kâsikum yiŋgimu yanâmâ Parisaio otmu Mosehât girem den kâsikum ningiminiwi yaŋe imbi âlâŋe lokŋe betŋehen kioŋmu mem tetewi. Imbi ya dâim Yesuhâlen den âiân katne sâm ariwi. Otmu Yesuŋe den sâm hilipgumu topŋe mem tetenom nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ari yuwu sâm âikuwi. “Lok pato, imbi yuâmâ lokŋe betŋehen kioŋmu mem teteain. ");
INSERT INTO spl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Yawu gârâmâ imbi âlâ me âlâŋe loklipyeŋe betyeŋehen kioŋnomai yamâ kâtŋak yongomunŋe munomaihât Moseŋe girem den âlâ kulemguop. Bâiŋ, gâŋeâmâ girawu naŋgat?” ");
INSERT INTO spl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yawu sâŋetâ Yesuŋe den nâŋgânâk tatmâ bâtŋaŋe hânân kulemguop. ");
INSERT INTO spl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kulemgum tatmu witgum âikuŋetâ kuwihakmâ yuwu sâm ekyongop. “Yeŋgâlen gâtŋe âlâ tosaŋe bia yaŋe topŋe katmâ imbi yu kumu yan yen hârokŋe kunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yawu sâm yâhâpŋe yawuâk den nâŋgânâk tatmâ hânân kulemguop. ");
INSERT INTO spl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yawu sâmu nâŋgâŋetâ umatŋe otmu aŋgoân kunlipyeŋaŋe sâm yahatmâ kulet sâm ariŋetâ ariŋetâ lok ya hârok arim tiŋ pilâwi. Arim tiŋ pilâŋetâ imbi yamâ Yesu orop yetŋiâk kinowot. ");
INSERT INTO spl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kinmutâ Yesuŋe kuwihakmâ yuwu sâm ekuop. “Wa tou. Den âiân katgekne sâm oai ya wosapâ arai?” ");
INSERT INTO spl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sâmu sâop. “Lok pato, lok ya hârok arai.” Sâmu sâop. “Yawu gârâmâ nâŋe gurâ otdâ bâleap yakât den âiân ki katgekbomgât naŋgan. Yawu gârâmâ gâŋe otdâ bâleap yamâ yâhâpŋe ki otbuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesuŋe ekumu arimu lohimbi kinbi ya ikŋan hâum yuwu sâm ekyongop. “Nâ hânŋan kulemŋan lohimbi mansai yeŋgât laŋinŋe otmâ mansan. Yakât otmâ lohimbi âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeinomai yamâ sâmune laŋinŋe biwiyeŋan pilâmu omoŋ bâleŋambâ ga manman kârikŋahât pat otmai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yawu sâmu Parisaioŋe yuwu sâm ekuwi. “Gâ gikgahâlâk mepaeakmâ sâm tat. Yamâ nâŋgâmunŋe bonŋe ki oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sâŋetâ sâop. “Nâmâ wosakembâ gewan yakât topŋe naŋgan. Me wosaken âwurem ariwom yakât topŋe gurâ nâŋgâm heŋgeŋguan. Yawu otmâ nâ ninahât topne sâm tetemune bonŋe otmap. Yawu gârâmâ yeŋeâmâ nâhât topne ki nâŋgâm heŋgeŋguai. Yakât otmâ den yai yu nâŋgâmune ki dopŋan oap. ");
INSERT INTO spl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yen gurâ lokgât nâŋgân nâŋgân watmai. Yakât otmâ lok âlâ me âlâhât den sâm hâreyiŋgine sâm otmaiân topyeŋe kakŋeâk kakŋeâk nâŋgâm sâm hâreyiŋgimai. Yâhâ nâmâ lok âlâ me âlâhât ki sâm hâreyiŋgiman. ");
INSERT INTO spl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yawu gârâmâ sâm hâreyiŋgim mansan mâne Awoŋnaŋe âi sâm nihim hâŋgânnohomu gewan yâkât sâtgât sâm hâreyiŋgimune bonŋe otbâp. ");
INSERT INTO spl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yakât topŋe nâŋgâŋetâ keterahâkgât yuwu sâmune nâŋgâŋet. Moseŋe girem den âlâ kulemguop ya yuwu tap. “Lok âlâ me âlâŋe ikŋiâk bukulipŋe yeŋgât topyeŋe teteâkgât sâm hâreyiŋgiwuapgât dop ki tap. Lok yâhâp me amon yaŋe denyeŋe hikunomai ya lâuakmâ konok otmap yamâ nâŋgâŋetâ bonŋe otbuap.” Yawu tap. ");
INSERT INTO spl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yakât ninahât topne yuwu sâmune nâŋgâŋet. Awoŋnaŋe hâŋgânnohomu gewan yâku yawuâk nâhât topne teteâkgât mâmâŋe otnihimu kulem topŋe topŋe memune ekmâ gamai ya.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sâmu sâwi. “Âwâhe wosaken mansap? Ya sârâ nâŋgâne.” Sâŋetâ sâop. “Yeŋe nâhât topne ki naŋgai. Gârâmâ Awoŋnahât topŋe gurâ ki naŋgai. Yawu gârâmâ nâhât topne naŋgai mâne Awoŋnahât topŋe nâŋgâwaŋgimbâi.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Otmu opon kâmbukŋe kâlehen tewetsenŋe katŋetâ geminiop yan lohimbi menduhuakŋetâ Yesuŋe den kâsikum yiŋgiop. Sâp yan Parisaio yawu sâm ekyongop. Yawu gârâmâ Yesu pâi emetŋan mem katnehât nâŋgâwi yamâ mumbuapgât sâp ki tâlâhuop yaŋak ki mewi. ");
INSERT INTO spl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesuŋe yâhâpŋe yuwu sâm ekyongop. “Nâ pilâyekmâ ariwom. Arimune yen munomaiân yanâmâ nâ ki neknomai. Ki nekmâ yan orotmemeyeŋe bâleŋe tâtâem otŋetâ yakât matŋe umatŋe kâpekyiŋgimu hiliwahonomai. Yâhâ nâ ari manbom yan yen gurâ watnekmâ ari mannomaihât dop âlâ ki tap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yawu sâmu yuwu sâm alahu gulahu otbi. “ “Nâ ari manbom yan yen gurâ watnekmâ ari mannomaihât dop âlâ ki tap,” yawu yap. Yamâ girawuhât yap? “Hiwawakbom” sâm nâŋgâm yap mon?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sâŋetâ sâop. “Nâmâ himbimâmbâ gewan. Yenâmâ hân yuân tetem manmâ gai. Yawu gârâmâ nine topne âlâ, ikŋiâk tap. Yenâmâ hân lok bâleŋe. ");
INSERT INTO spl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yeŋe orotmemeyeŋe bâleŋe tâtâem otŋetâ yakât otmâ matŋe umatŋe kâpekyiŋgimu hiliwahonomai. Yawu gârâmâ awoŋnaŋe hâŋgânnohomu ge manman amboŋe mansan. Yakât nâhâlen biwiyeŋe katmâ orotmemeyeŋe kiŋgoŋ bet pilânomai yamâ ki hiliwahonomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sâmu lauyeŋe butelim yuwu sâwi. “Gâ wuân lok kinmâ yu yat?” Sâŋetâ sâop. “Emelâk ekyongoan ya. ");
INSERT INTO spl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yakât otmâ nâ yeŋgât topyeŋe sâm tetem den âiân katyekbomgât dop tap. Yawu gârâmâ hâŋgânnohopŋe yu me ya otmap yamâ bulâŋanâk. Yakât otmâ yâkât den yawuâk ekyongoman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yawu gârâmâ Yesuŋe Himbim Âwâŋahât ekyongop yamâ ki nâŋgâŋetâ keterahop. ");
INSERT INTO spl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yakât den âlâ yuwu sâm ekyongop. “Yeŋeâmâ nâ lok bulâŋe howanân nohom kânâŋgâneknomai ya ekmâ nâ manman amboŋe mansan yakât topŋe nâŋgâŋetâ bulâŋe otmu keterakyiŋgiwuap. Otmu Awoŋnaŋe den sâm nihiop yawuâk ekyongom gan ya nine eŋgatneâk ki otman ya gurâ nâŋgâm heŋgeŋgunomai. ");
INSERT INTO spl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Hâŋgânnohomu gewan yâk orop biwinetŋe kepeiakmâ konohâk otmu tem lâuwaŋgimune nekmu ârânâdâŋ otmap. Yakât otmâ ki betnohomap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yawu sâmu lohimbi dondâŋe den sâop ya nâŋgâŋetâ bonŋe olop. ");
INSERT INTO spl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","Nâŋgâŋetâ bonŋe otmu benŋe yuwu sâm ekyongop. “Yiwereŋe biwiyeŋe heweweŋ otmu nâhât den nâŋgâŋetâ bulâŋe oap. Yawu nâŋgâm yâhânomai yanâmâ meyekmune nâhât hoŋ bawalipne bulâŋe otnomai. Yawu otmâ Anitâhât topŋe nâŋgâŋetâ bulâŋe otmu holaŋyekbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Sâmu sâwi. “Bâe, nenâmâ Awarahamgât sen mansain. Gârâmâ lok âlâ me âlâŋe ki menenekŋetâ hoŋ bayiŋgim mansain. Yakât otmâ topŋe girawuhât otmâ “holaŋyekbom,” yat? Den yat yakât nâŋgâm hâum pâpguain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sâŋetâ sâop. “Nâŋe den bulâŋe ekyongomune nâŋgâŋet. Lok âlâ me âlâŋe orotmemeyeŋe bâleŋe otmaiŋe yeŋe wâtyeŋanâk kinmâ ya bet pilâm manman âiloŋgoân torokatmâ mannomaihât dop âlâ ki tap. Orotmeme bâleŋe ya tâtâemâk otmâ manmâ manman bâleŋahât amboŋe ya hoŋ bawaŋginomai. ");
INSERT INTO spl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yakât topŋe teteâkgât den âlâen hâum sâmune nâŋgâŋet. Lok âlâhât nanŋaŋe âwâŋe orop haoŋmâ ârândâŋ manmâ yâhâromawot. Yawu gârâmâ âwâŋahât hoŋ bawalipŋaŋe gurâ hâmbâi pilâyelekmâ ondop yeŋgâlen ari hoŋ bayiŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yawu gârâmâ nâŋeâmâ Anitâhât nanŋe mansan. Gârâmâ nâŋe holaŋyekbom yamâ manman bâleŋahât amboŋe hoŋ ki bawaŋginomai. ");
INSERT INTO spl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yen nombotŋaŋe Awarahamgât sen mansain sâŋetâ ya naŋgan. Yawu gârâmâ nâhât den nâŋgâŋetâ gemu bet pilâm nâhâitŋe kumunŋe muâk sâmai. ");
INSERT INTO spl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nâmâ Awoŋne orop biwinetŋan den tatmap yamâ tâŋ tâŋâk ekyongom gaman. Yâhâ yeŋeâmâ amboyeŋahât sât lâum yu ya otmâ mansai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yawu sâmu yuwu sâm ekuwi. “Nenâmâ Awarahamgât sen.” Sâŋetâ sâop. “Yenâmâ Awarahamgât sen bulâŋe mansai mâne yâkŋe olop miop yawuâk watmâ manbâi. ");
INSERT INTO spl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Anitâŋe den bulâŋe eknohomu nâŋgâm gewan yawuâk ekyongoman. Yâhâ yeŋeâmâ ya nâŋgâmâk tatmâ tatmâ nâ nohoneâk nâŋgâm manmai. Yeŋe oai yu Awarahamŋe olop ya lâuap. ");
INSERT INTO spl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yamâ yeŋeâmâ amboyeŋaŋe olop yawuâk otmâ manmai.” Yawu sâop. Sâmu sâwi. “Imbi kondarâŋe ki menenekŋetâ san mansain. Awoŋnenŋeâmâ Anitâ ikŋe konok tap.” ");
INSERT INTO spl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sâŋetâ sâop. “Nine eŋgatneâk otmâ ki gewan. Anitâŋe hâŋgânnohomu ge mansan. Yakât otmâmâ âwâyeŋe Anitâ mâneâmâ nâhât den nâŋgâm buku otnihimbâi. ");
INSERT INTO spl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yawu gârâmâ nâŋe den ekyongomune nâŋgâŋetâ umatŋe otmu pilâmai. Yakât otmâ den sâmune nâŋgâŋetâ biwiyeŋan ki hâuyekmap. ");
INSERT INTO spl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Âwâyeŋe Satan manman bâleŋahât amboŋe, yâkât tem lâunehât nâŋgâmai. Otmu kândikum emelâk orotmeme kiŋgoŋ otmâ gawiŋeâmâ yâkâlen kândiwahom otŋetâ bâlem gamap. Yâhâmâ manman âlepŋan ki manmâ gaopŋak manmâ gamap. Yâhâmâ perâk yakât mâmâŋe pato oapgât ikŋe eŋgatŋeâk watmâ kâityongomap. Yawu gârâmâ orotmeme âlepŋe otbuapgât dop âlâ ki tap. ");
INSERT INTO spl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yawu gârâmâ yenâmâ yâkât tem lâum mansaihât nâŋe den bulâŋe yan yuâmâ nâŋgâŋetâ nahat otmap. ");
INSERT INTO spl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yâhâ yeŋgâlen gâtŋe âlâŋe den âiân katnekmâ tosa orop mansap sâm nâhâlen gâitbuapgât dop âlâ ki tap. Yawu gârâmâ nâŋe den bulâŋe ekyongoman yamâ topŋe girawuhât otmâ nâŋgâŋetâ paha den otmap? ");
INSERT INTO spl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Lok âlâ me âlâŋe Anitâhât pat manmai yaŋe yâkât denŋe haoŋmâ ârândâŋ lâumai. Yâhâ yenâmâ Anitâhât pat ki manmai. Yakât otmâ nâhât den hâkâŋ otmâ pilâmai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yawu sâmu yuwu sâm bâlewaŋgiwi. “Bâe, Gâmâ Samaria kapi amboŋe. Yakât otmâ weke bâleŋaŋe nâŋgân nâŋgânge mem hâlim tuhumu den yu yat.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sâŋetâ sâop. “Nâ weke bâleŋaŋe ki mâŋgâenekmu den sâman. Nâmâ Awoŋne ewe katmâ tem lâuwaŋgiman. Yâhâ yeŋeâmâ nâ ki ewe katnekmâ tem lâunihim mansai. ");
INSERT INTO spl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yawu gârâmâ lohimbiŋe ewe katnekŋetgât ki naŋgan. Awoŋne Anitâ ikŋiâk nâŋgânihim lohimbiŋe ewe katnekmâ tem lâunihiŋetgât nâŋgâmap. ");
INSERT INTO spl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yakât otmâ den bulâŋe ekyongomune nâŋgâŋet. Lok âlâ me âlâŋe nâhât tem lâunihim manmai yaŋeâmâ manman kârikŋan mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Sâmu sâwi. “Bâe, Awarahamâmâ emelâk muop. Otmu poropete ya gurâ emelâk muwi. Yâhâ gâŋeâmâ “nâhât tem lâum mannomaiŋeâmâ manman kârikŋan mannomai,” yawu yat. Yawu sâm muwi ya yeŋgât kunyeŋe mansan yawu nâŋgâmat. Ya ki orotŋe. Yakât otmâ bulâŋanâk weke bâleŋaŋe mâŋgâehekmu biwi hâlim oat yawu naŋgain. Gâ yawu sâm mepaeaksat yakât nâŋgâmunŋe dondâ bâleap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sâŋetâ sâop. Nâŋe nine mepaeaksan mâne nâŋgâŋetâ porap otbâp. Yawu gârâmâ Awoŋne hâŋgânnohomu gewan yâkŋeâmâ mâmâŋe otnihimu kulem topŋe topŋe memune ekŋetâ yahatmap. Yâhâ yeŋeâmâ Awoŋnahât topŋe ki nâŋgâm “Anitâ Ambonenŋe” sâm imbiâk kunmai. ");
INSERT INTO spl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nâŋeâmâ yâkât topŋe nâŋgâm heŋgeŋguan. Yawu gârâmâ “ki nâŋgâwaŋgian,” sâman mâne lok perâkŋe otmâ den membâm. Yeŋe den mem lohimbi kâityongomai yakât dopŋeâk otbâm. Yawu gârâmâ nâmâ yâkât topŋe nâŋgâm heŋgeŋgum tem lâuwaŋgimune ârândâŋ otmap. ");
INSERT INTO spl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tâmbâyeŋe Awarahamŋe nâ tetem âi tuhumune bulâŋe tetemu ekbehâlâk nâŋgâm nâhâlen biwiŋaŋe kepeim heroŋe otmâ manop.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sâmu sâwi. “Bâe, Awaraham ya emelâhâk manop. Yâhâ gâmâ sihan mansat. Yawu gârâmâ girawu otmâ Awarahamgât topŋe nâŋgâm yu yat?” yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sâŋetâ sâop. “Nâ ninahât topne sâm tetemune nâŋgâŋet. Embâŋân Awaraham ki manop yapâek tatbanŋak tatmâ gawanŋak tatmâ gaman.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yawu sâmu nâŋgâŋetâ bâlemu “O, Anitâ konok embâŋân talopŋak tatmâ gamap.” Yawu nâŋgâm kât lâum kune sâm otŋetâ misiŋgurakmâ opon kâmbukŋambâ yok pilâm gem ariop. ");
INSERT INTO spl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","2","Otmu hilâm âlâen tatmâ nâŋgâ nâŋgâ sâp yan nen Yesuhât hoŋ bawalipŋe mâtâwân ariwin. Ari lok âlâ senŋe bok sâsâŋe ekbin. Lok yamâ mâmâŋahât tepŋambâ yawuâk teteop. Ekmâ yuwu sâm Yesu âikuwin. “Kutdâ, lok yuâmâ âlâhât tosahât otmâ mâmâŋahât tepŋambâ senŋe bok sâsâŋe yuwuâk teteop. Ikŋe orotmeme bâleŋe yakât me âwâŋe mâmâŋe yetgât tosa yakât yu olop?” ");
INSERT INTO spl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yawu sâm âikumunŋe yuwu sâop. “Ya bia. Ikŋe orotmemeŋe bâleŋe me âwâŋe mâmâŋe yetgât tosahât bia. Yawu gârâmâ Anitâhât wâtŋan kinmâ heŋgeŋgumune ekŋetâ âlâ kândâkdâ olâkgât mâmâŋahât tepŋambâ yuwuâk teteop. ");
INSERT INTO spl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Yakât nâŋgâŋetâ teteâkgât den âlâen hâum sâmune nâŋgâŋet. Nâŋe kulem topŋe topŋe mem den ekyongomune yan laŋinŋaŋe biwiyeŋan pilâmu haŋ sâyiŋgimap. Yakât otmâmâ nâ hâŋgânnohomu gewan yâkŋe mâmâŋe otningimu tem lâuwaŋgim manmunŋe yan lohimbiŋe yâkât wâtŋahât bulâŋe ya eknomai. Yawu gârâmâ hâmbâi katyekmâ arimune yan omoŋ sahakmu âi tuhunomaihât dop ki otbuap.” ");
INSERT INTO spl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yawu sâm hân mem tâpgum golaŋgumu toâk toâk otmu lok yakât senŋan lâwâlem yuwu sâm hâŋgânguop. ");
INSERT INTO spl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Gâ arimâmâ Siloam deŋgânân senge hâmehe piriakbuat.” Yawu sâop. Otmu kut Siloam yakât topŋeâmâ yuwu, “hâŋgânnohop” yawu. Yawu sâm hâŋgângumu ari to piriakmu senŋe suk sâmu ehop. ");
INSERT INTO spl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yawu otmâ âwurem arimu bukulipŋe otmu lohimbi emelâk topŋe nâŋgâminiwiŋe ekmâ yuwu sâwi. “O, lok senŋe bok sâsâŋe mâtâp ginŋan tatmâ ulitnongomap ya yu mon?” Yawu sâm alahuwi. ");
INSERT INTO spl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nombotŋaŋe sâwi. “Lok ya yukâ,” sâwi. Yâhâ nombotŋaŋeâmâ sâwi. “Bia, lok yuâmâ lok yai yawuya,” sâwi. Yawu sâŋetâ lok ya ikŋahâk yahatmâ sâop. “Yai, yamâ nâ yukâ.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yawu ekyongomu yuwu sâm âikuwi. “Gâ girawu otmâ senge hâreakmu eksat?” ");
INSERT INTO spl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sâŋetâ sâop. “Lok âlâ, kutŋe Yesu sâm, yâkŋe hân mem tâpgum golaŋgum sennan lâwâlem yuwu sâm eknohoap. “Gâ Siloam deŋgânân ari senge hâmehe piriak.” Yap yawuâk watmâ ari piriakmune senne hâreakmu eksan.” ");
INSERT INTO spl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yawu sâmu âikum sâwi. “Lok ya wosapâ tap?” sâwi. Sâŋetâ “Nâ ki naŋgan,” sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Yawu gârâmâ Yesuŋe tatmâ nâŋgâ nâŋgâ sâpŋan lok ya heŋgeŋguop. Yakât otmâ lok nombotŋe ekmâ kinbiŋe lok ya mem den âiân katne sâm Parisaio yeŋgâlen dâim ariwi. ");
INSERT INTO spl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Dâim ariŋetâ Parisaioŋe girawu otmâ senŋe hâreakmu ehop yakât âikuwi. Âikuŋetâ yuwu sâm ekyongop. “Yesuŋe hân mem tâpgum golaŋgum sennan lâwâlemu yaŋak ari Siloam deŋgânân piriakmune senne hâreakmu eksan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yawu sâmu Parisaio nombotŋaŋe yuwu sâwi. “Yesuŋe tatmâ nâŋgâ nâŋgâ sâpŋan hân mem tâpgum golaŋguop yamâ âi miop yawuhât dop oap. Yakât otmâ ekmunŋe Anitâŋe ki hâŋgângumu giop oap.” Yawu sâwi. Yâhâ nombotŋaŋeâmâ yuwu sâwi. “Orotmeme bâleŋe otmâ manmap mâne kulem yuwuya ki membâp.” Yawu sâm hioŋakbi. ");
INSERT INTO spl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hioŋakmâ yaŋak witgum lok ya yuwu sâm âikuwi. “ “Mem sennan lâwâlemu hâreakmu eksan,” yat. Yakât otmâ topŋe tipiŋe nâŋgâwaŋgiat ya sârâ nâŋgâne.” Yawu sâwi. Sâŋetâ sâop. “Yâhâmâ Anitâhât sâtgât heŋgemnohop yakât ekmune poropete oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yâhâ Parisaio nombotŋaŋe senŋe hâreakmu ehop yakât den pat nâŋgâŋetâ ki bulâŋe olop. Yakât otmâ topŋe yâhâpŋe sâŋetâ nâŋgâne sâm âwâŋe mâmâŋe yuwu sâm âiyotgowi. ");
INSERT INTO spl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Nanyetŋe senŋe bok sâsâŋe yawuâk teteop sâmawot. Yamâ yiwereŋeâmâ girawu otmâ eksap? Yakât sâmutâ nâŋgâne,” sâm âiyotgowi. ");
INSERT INTO spl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Yâhâ emelâk Yesuŋe lok ya ki heŋgeŋguop yan Parisaioŋe den yuwu hikuwi. Anitâŋe tihitnenŋe otbe sâm Yesu hâŋgângumu giop yakât “lohimbi âlâ me âlâŋe yawu sânomai yamâ kewilâyekmunŋe miti emetŋan ki yâhâm yaehen mannomai.” Yawu sâwi. Yawuhât âwâŋe mâmâŋaŋe kewilânelekŋetâ yaehen manmait sâm kiŋgityetŋahât otmâ yuwu sâowot. “Netgât nannetŋe yu bulâŋanâk senŋe bok sâsâŋe yawuâk mem ga katbit ya naŋgait. Yawu gârâmâ topŋe girawuhât otmâ senŋe hâreakmu eksap ya ki naŋgait. Yamâ yâkŋe ŋaŋa tap mâne yâkât topŋe ekyongombâit. Gârâmâ ikŋe âikuŋetâ topŋe ekyongoâk.” Yawu sâowot. ");
INSERT INTO spl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yawu sâmutâ nanyetŋe yâhâpŋe yuwu sâm âikuwi. “Anitâhât senŋan kinsat yakât otmâ den bulâŋanâk sârâ nâŋgâne. Nenâmâ Yesuhât topŋe naŋgain. Yâhâmâ lok bâleŋe. Gâŋe yâkât girawu naŋgat?” ");
INSERT INTO spl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yawu sâm âikuŋetâ sâop. “Bâe, yeŋe lok bâleŋe yai yamâ ki naŋgan. Nâmâ senne bok sâmu manminiwan yamâ sâp yiwereŋe lok yaŋe senne lâwâlemu hâreakmu eksan yamâ naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yawu sâmu kunyeŋe kârikŋe otmâ sâwi. “Sârâ nâŋgâne. Gâ girawu otgihimu yan senge yu hâreahop?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Sâŋetâ sâop. “Âo, nâmâ emelâk ekyongoan. Wongât yeŋe usut usulâk âi pâi tuhuneksai? Yeŋe yâkât hoŋ bawaŋgine sâm âinohom tai me?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yawu sâmu sârekguwi. “Wae, gâŋeâmâ yâkât den lâuon. Yâhâ nenŋeâmâ Mosehât girem den lâumain. ");
INSERT INTO spl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aŋgoân Anitâŋe girem den Mose ekuop yamâ naŋgain. Yâhâ lok yuâmâ âlâhât sâtgât otmâ âi memap? Topŋe ki naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sâŋetâ sâop. “Bâe, yai ya nâŋgâmune nahat oap. Lok yaŋe sennan lâwâlemu hâreakmu ekban yamâ yeŋe girawuhât otmâ âlâhât sâtgât otnihiop yakât nâŋgâm pâpguai? ");
INSERT INTO spl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yawu gârâmâ nenâmâ yuwu naŋgain. Orotmeme bâleŋe otmâ manmaiŋe âi tuhune sâm Anitâ ulitguŋetâ ki nâŋgâyiŋgimap. Yâhâ lohimbi âlâ me âlâŋe ewe katmâ tem lâuwaŋgimaiŋe ulitguŋetâ âlepŋe nâŋgâyiŋgimap. ");
INSERT INTO spl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yawu gârâmâ kândikum emelâk Anitâŋe lohimbi katyelekmu yapâek tetem gawiân kulem yuwu yakât pat âlâ ki nâŋgâman. Yakât otmâmâ yuwu naŋgan. ");
INSERT INTO spl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Lok yuâmâ Anitâŋe ki hâŋgângumu giop mâne ki heŋgemnohombâp.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Sâmu sâwi. “Bâe, Gâmâ mâmâhaŋe meŋgehop yapâek manman bâleŋe manmâ gamat. Yakât gâŋe girawu otmâ den kâsikum ningiwe sâm oat? Pilâm ânmâ ari,” sâm watŋetâ ba ariop. ");
INSERT INTO spl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Watŋetâ ariop yakât den pat Yesuŋe nâŋgâop. Lok ya mem tetem yuwu sâm ekuop. “Gâŋe lok bulâŋahâlen biwihaŋe kepeim mansat me bia?” ");
INSERT INTO spl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sâmu sâop. “Lok pato, gâ âlâhât yat? Yiwereŋe tiripnohorâ ekmâ biwinaŋe yâkâlen kepeim manbehât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Sâmu sâop. “Nâ ninahât yan.” ");
INSERT INTO spl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sâmu sâop. “Kutdâ, biwine gâhâlen katsan,” sâm mepaeop. ");
INSERT INTO spl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yawu sâm mepaemu yuwu sâop. “Nâ lohimbi topyeŋe ekmâ kâsipyongowehât gewan. Lok nombotŋeâmâ “emelâk nâŋgâmain” sâm mepaeakmai yamâ hâum pâpgunomai. Yâhâ nombotŋaŋeâmâ “ki nâŋgâmain” sâmai yamâ sâmune nâŋgâŋetâ haŋ sâyiŋgiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yawu sâmu Parisaio yan kinbiŋe nâŋgâm yuwu sâm âikuwi. “Maiŋ, nenŋe mepaeakmaingât hâum pâpgum ki naŋgaingât yat me?” ");
INSERT INTO spl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sâŋetâ sâop. “Nâhât topne nâŋgâm biwiyeŋe nâhâlen kepeimai mâne emelâk tosayeŋe biatyiŋgimbâp. Yâhâ yeŋeâmâ “emelâk nâŋgâm pesuk pilain” sâm biwiyeŋe nâhâlen ki kepeimai yakât otmâ tosayeŋe ya yawuâk tatmâ yâhâwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuŋe ikŋan hâum yuwu sâm ekyongop. “Yuwu sâmune nâŋgâŋet. Lama amboyeŋaŋe peke tuhum lama ya kâlehen katyekmu kinmai. Yâhâ lok âlâ me âlâŋe lama kombo mene sâm lama galemŋe tirek topŋan kinmap yakât otmâ peke betŋehembâ mem pitik pilâm yâhâm kâlehen kioŋmâ kombo membuap. ");
INSERT INTO spl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yâhâ lama amboyeŋaŋe dâiyekmâ nak sândukŋehen katyekmu kinŋet sâm peke betŋehembâ ki kioŋmap. ");
INSERT INTO spl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yâkŋeâmâ tirek tâŋ tâŋâk yakât galemŋe ekumu nâŋgâwaŋgimu kâlehen ba lama kutyeŋe ikŋiâk ikŋiâk yongomap. ");
INSERT INTO spl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yongonmu ga peke hindâmu denŋe nâŋgâm amboyeŋe watmâ arimai. ");
INSERT INTO spl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yâhâ lok ondopŋe pup taka dâiyekmâ ariwe sâm yongonbuap yamâ eŋgat towatŋe aŋgo nâŋgâm ki betŋan watnomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuŋe den yu ikŋan hâum sâmu nâŋgâŋetâ ki keterahop. ");
INSERT INTO spl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nâŋgâŋetâ ki keterahopgât yuwu sâop. “Nâmâ lama yeŋgât amboyeŋe bonŋe. ");
INSERT INTO spl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Aŋgoân nâ hânân ki gewan yanâmâ lok komborâ nombotŋaŋe Anitâhât lama taka dâiyekmâ âlâengen arine sâm yongonŋetâ denyeŋe ki nâŋgâyiŋgiwi. ");
INSERT INTO spl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nâmâ tirek galemŋe kinman. Lohimbi âlâ me âlâŋe manman sânduhân manne sâm otmai yamâ nâhâlembâ gam ba peke kâlehen kinŋetâ tihityeŋe otmune kilik milik mannomai. ");
INSERT INTO spl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Otmu lok komborâ yâhâmâ lohimbi mem bâleyekmâ itit kiom tuhuyiŋgimai. Yâhâ nâmâ manman kârikŋe yiŋgimune yan manmâ yâhâŋetgât gewan. Yawu. ");
INSERT INTO spl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Otmu âlâkuâk ninahât sâwe. Nâmâ lama galemyeŋe âlepŋe mansan. Yakât otmâmâ lok bâleŋe âlâ me âlâŋe nâhât lama hilipyongone sâm takanomai yamâ in yawu sârereyekmune nohonomai. ");
INSERT INTO spl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Yâhâ lama amboyeŋaŋe nep lok meyekmu yâkât lama galemyongom yan hâmeŋahâlâk nâŋgâmai. Yawu gârâmâ soso hulin âlâŋe lama neyekbe sâm takawuap yamâ kiŋgityeŋahât otmâ pilâyekmâ arinomai. Ariŋetâ soso yaŋe nombotŋe neyekmu nombotŋe tiok taok otmâ arim kinnomai. Yawu. ");
INSERT INTO spl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Otmu torokatmâ yuwu sâwe. Anitâ orop biwinetŋe hikuakmâ konohâk otmu naŋgaŋgiait. Yakât dopŋeâk nine lama orop biwinenŋaŋe kepeiakmâ konohâk otmu naŋgaŋgiain. Yakât otmâmâ nâŋe tihityeŋe otmâ sârereyekmune nohoŋetâ mumune yâkŋe manman sânduhân mannomai. ");
INSERT INTO spl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nohoŋetâ mumbom yakât kakŋan nine lama nombotŋe emelâk Anitâŋe manman kârikŋahât pat kuyiŋgimu wosapâ me wosapâ mansai, ya gurâ yongonmune denne nâŋgâm yeŋgâlen torokatmâ komot konohâk otŋetâ nâ ninak amboyeŋe otmâ yâhâwom. ");
INSERT INTO spl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","18","Yâhâ tihityeŋe otmâ sârereyekmâ mumbomgât awoŋnaŋe hâŋgânnohomu gewan. Gem biwinetŋe konok oap yakât otmâ lauŋe lâum heweweŋâk otmâ kaweyeŋan kinmune nohoŋetâ mumbom. Yakât otmâmâ awoŋne orop biwinetŋe kepeiakmâ konohâk otmait. Otmu nine manmannahât topne naŋgaŋgian yakât otmâ lok âlâ me âlâŋe yeŋahât otmâ hilipnohonomaihât dop bia. Yawu gârâmâ hâmene ki kinbuap sâwangât nohoŋetâ mumbom. Yaŋak benŋe mumuŋambâ yahatbom yangât yawuâk otbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesuŋe den yawu sâmu Parisaioŋe nâŋgâm hioŋakmâ nombotŋaŋe yuwu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","“Weke bâleŋaŋe mâŋgâemu biwi hâlim otmâ den yu yap. Yakât otmâ wongât ki kuwaŋgiai? “ ");
INSERT INTO spl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yâhâ nombotŋaŋeâmâ yuwu sâwi. “Weke bâleŋaŋe lok senyeŋe bok sâsâŋe heŋgemyongonomaihât dop ki tap. Yâkŋe den sâmu nâŋgâmunŋe sâtŋe otmap. Gârâmâ weke bâleŋaŋe lok mâŋgâeyekmu den ihilâk mahilâk sâmai yakât dop ki oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Otmu emelâk hâkulipnenŋaŋe yâhâpŋe opon kâmbukŋe mem miwirikum yaŋak hotom um Anitâ mepaewi yakât hombaŋ tâlâhuop. Otmu hombaŋ ya gelâk sâpŋan teteop. ");
INSERT INTO spl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Gârâmâ emelâk opon ya tuhuwi yan gelâk ningimap sâm selep bârârâhâk kâlep tuhuwi yakât kutŋeâmâ Solomongât selep yan Yesuŋe yâhâop. ");
INSERT INTO spl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yan yâhâmu Parisaioŋe mem hawam mewam tuhum âi pâi tuhum yuwu sâm âikuwi. “Wongât topge kurihiakdâ nenŋe eŋgat yâhâp oain? Anitâŋe hâŋgângumu gewuap sâminiwi ya gâ me? Me âlâhât mambotnom? Topge tâŋ tâŋâk eknongorâ nâŋgâne.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sâŋetâ sâop. “Nâ yakât emelâk ekyongom gaman. Yamâ yeŋe nâŋgâŋetâ ki bulâŋe otmap. Yâhâ Awoŋnaŋe mâmâŋe otnihimu kulem topŋe topŋe memune ekŋetâ yan topne tetemap. ");
INSERT INTO spl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yawu gârâmâ yenâmâ nâhât lama bulâŋe ki manmai. Nâhât lama bulâŋe manmai mâne kulem memune ekŋetâ bulâŋe otmu biwiyeŋe nâhâlen katbâi. ");
INSERT INTO spl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yawu gârâmâ nâhât lama bulâŋe ya yeŋgât topyeŋe nâŋgâm yongonmune betnan watnekmai. ");
INSERT INTO spl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yawu otmai yamâ nâhât wâtnan kinmâ manman kârikŋan mannomai. Yamâ lok âlâ me âlâ, me wahap yu me yaŋe nâhâlembâ mem dâiyekŋetâ hiliwahonomaihât dop âlâ ki tap. ");
INSERT INTO spl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","30","Yâhâ Awoŋne kunnenŋe pato tatmapŋe nâhât lama yaŋe nâ orowâk mannomgât pat kuyiŋgim wawaeyekmap. Yakât otmâmâ lok âlâ me âlâ, me wahap yu me yaŋe yâkâlembâ mem dâiyekŋetâ hiliwahonomaihât dop gurâ ki tap. Yâhâ Awoŋ orop dopnetŋe konohâk oap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesuŋe yawu sâmu nâŋgâŋetâ bâlemu kâtŋe mem kune sâm otbi. ");
INSERT INTO spl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kune sâm otŋetâ sâop. “Awoŋnaŋe âi sâm nihiop ya âiloŋgo mem gamune ekmai. Yakât otmâmâ wuân otmune bâleapgât kâtŋe mem nohone sâm oai?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sâmu sâwi. “Âi âiloŋgo mem gaman yat yakât bia. Gâŋe “Anitâ orop dopnetŋe konok oap,” sâmat yakât nâŋgâmunŋe bâlemu gohone sâm oain. Gâmâ lok bâleŋe.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sâŋetâ sâop. “Bâe, Anitâŋe den sâop ya yeŋgât miti pepaen lok âlâŋe kulemguop ya yuwu tap. “Yenâmâ nâhât dowâk mansai.” Anitâŋe den yawu sâop ya kulemguop. ");
INSERT INTO spl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yâhâ miti pepaen den hârok kulemguwi tap ya bulâŋe. Yawu gârâmâ Anitâŋe tâmbâlipyeŋe yeŋgât galemlipyeŋe âi sâm yiŋgim yan “Yenâmâ nâhât dowâk mansai,” sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Otmu yâk yeŋgât sâop yawuâk nâhât sâm âi nihim hâŋgânnohomu gewan. Yakât otmâ “Nâ Anitâhât nanŋe mansan,” yawu sâm ekyongomune ya nâŋgâmâk tatmâ nâhâitŋe Anitâhât kaweŋan kinbe sâm oap sâmai ya nâŋgâmune ki ârândâŋ oap. Anitâŋe emelâk yâk yeŋgât sâop yawuâk nâhât sâop. ");
INSERT INTO spl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yâhâ nâŋe kulem topŋe topŋe mem gaman ya ekŋetâ Awoŋnahât dop ki otmap otmuâmâ âlepŋe denne nâŋgâŋetâ tâŋât otbuap. Yawu gârâmâ kunyeŋe kârikŋe otmâ denne nâŋgâŋetâ gemu betnihim mansai. ");
INSERT INTO spl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yakât otmâ kulem meman ya ekmâ nâŋgâm Awoŋ orop dopnetŋe konohâk oap yakât nâŋgâŋetâ keterakyiŋgiâk.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yawu sâmu nâŋgâŋetâ bâlemu mem pâi emetŋan katne sâm otŋetâ hohetyeŋambâ gem ba ariop. ");
INSERT INTO spl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ari Yoran to nombotgen emelâk Yoaneŋe lohimbi mem toen katyekmu manbi yan ari manop. ");
INSERT INTO spl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","42","Yan manmu lohimbi kiŋgitŋe orowâkŋe arim ekmâ yâkâlen biwiyeŋaŋe kepeim yuwu sâm alahu gulahu otbi. “Yoaneŋe kulem âlâ ki miop. Yawu gârâmâ yâkŋe Yesuhât topŋe eknongop yamâ bulâŋanâk sâop.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Otmu sâp yakât kakŋan lok âlâ, Betani kapi amboŋe mesek sâtŋan kinop, kutŋe Lasaro sâm, touyâhâtŋe Maria yet Mata. Yâhâ mesek ki kuop yan Mariaŋeâmâ to kukŋe suk suk âlâ mem Yesuhât kâiŋan moselemu gemu pirim somotŋaŋe kereŋ mewaŋgiop. ");
INSERT INTO spl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yâhâ mesek sâtŋan kinmâ pilâyelekbe sâm otmu touyâhâtŋaŋe Yesuhât yuwu sâm den katmutâ ariop. “Lok pato, gâ nâŋgâ. Bukuhe yamâ mesek sâtŋan kinsap.” Yawu sâowot. ");
INSERT INTO spl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Den yawu katmutâ Yesuŋe nâŋgâm matŋe yuwu sâm katmu âwureop. “Imiyetŋaŋe ki pilânenekbuap. Mesek sâtŋan kinsap yakât huhopŋe yamâ lohimbi dondâŋe Awoŋne netgât nâŋgâŋetâ yahatbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yâhâ Yesuŋe Mata Maria, Lasaro yâk yeŋgât tepŋe dondâ nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yawu gârâmâ den pat ya nâŋgâm hilâm kalimbu pesuk sâmu yaŋak nen hoŋ bawalipŋe yuwu sâm eknongop. ");
INSERT INTO spl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","“Yahatŋetâ Yuraia hânân âwurem arine.” ");
INSERT INTO spl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yawu sâmu nenŋe yuwu sâm ekuwin. “Lok pato, nengât papatolipnenŋaŋe yâhâlenâk gâ gohone sâm otbi. Yakât yiwereŋe âwurem arinom yamâ gohonomai yakâ.” ");
INSERT INTO spl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yawu sâmunŋe Yesuŋe den âlâen hâum yuwu sâm eknongop. “Anitâŋe emet haŋgât me omoŋgât dop yawu katmu tetemap. Yawu gârâmâ hilâmân nenŋe mâtâp ekmâ kilik milik arim gamain. Yawu otmâ kâinenŋan ki teŋ sâmap. ");
INSERT INTO spl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yâhâ omoŋdâŋe ki ekmâ heŋgeŋgum arim gamain. Yawu otmâ kâinenŋan teŋ sâmap. ");
INSERT INTO spl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yiwereŋeâmâ hilâmgât dop otmu mansain. Yakât otmâ bukunenŋe Lasaro in aman pâlâmŋe iap gârâmâ ari mândemune yahatbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Otmu Lasaro yamâ emelâk bâleop. Yâkŋe den kelaŋgatmâ eknongomu nâŋgâmunŋe ki keterakmu yuwu sâm ekuwin. “Kutdâ, yamâ aman in iapgât yahatbuap. Yakât otmâ ki arinehât naŋgain.” ");
INSERT INTO spl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yawu sâmunŋe Yesuŋe den tâŋ tâŋâk yuwu sâm eknongop. “Lasaroŋe emelâk bâleop. Gârâmâ orowâk tatbit mâne ki bâlembâp. ");
INSERT INTO spl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Emelâk bâleop. Gârâmâ kulem memune ekmâ topne nâŋgâm heŋgeŋgum biwiyeŋaŋe nâhâlenâk kepeinomai. Yakât otmâ tepne heroŋe oap. Bâiŋ, yahatŋetâ arine,” yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yawu sâmu bukunenŋe âlâ, kutŋe Toma sâm, kutŋe âlâmâ Boho boho, yuwu sâm eknongop. “Kutdânenŋaŋe arinom naŋgap. Yakât âlepŋe nen hârok arimunŋe nongoŋetâ muneâyâ.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yawu sâmu yahatmâ Betani kapiân ariwin. Yâhâ “Lasaro ya emelâk bâlemu kurihiŋetâ hilâm imbât oap” yawu sâm eknongowi. ");
INSERT INTO spl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Yâhâ Betani kapi yamâ Yerusalem kapi pato ya hâlâŋmâek tap yakât otmâ bukulipyeŋe dondâŋe kapi pilâm kahân takawi. ");
INSERT INTO spl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yâhâ Mataŋe “Yesu mâtâwân takam tap,” sâŋetâ nâŋgâm gariŋe pilâm penewaŋgiwe sâm giop. ");
INSERT INTO spl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Gem ekmâ yuwu sâm ekuop. “Kutdâ gâ nen orowâk tatbin mâne iminetŋaŋe ki pilânenekbâp. ");
INSERT INTO spl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yawu gârâmâ gâŋe wuân me wongât Anitâ ulitguwuat ya âlepŋe nâŋgâhihiwuap.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sâmu sâop. “Imihe âlepŋe mumuŋambâ yahatbuap.” ");
INSERT INTO spl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Sâmu sâop. “Hâmbâi sâp patoen yahatbuap yamâ naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sâmu sâop. “Manman amboŋe yamâ nâ. Otmu mumuŋambâ yahatmâ mannomai ya gurâ amboŋe nâek. ");
INSERT INTO spl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yakât otmâmâ lohimbi âlâ me âlâŋe biwiyeŋe nâhâlen katmâ manmaiŋe munomai yakât kakŋan mumuŋambâ yahatmâ mannomai. Manmâ yâhâpŋe munomaihât dop âlâ ki tap. Den yan yu nâŋgârâ bonŋe oap me bia?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Sâmu sâop. “Kutdâ, yat yamâ nâŋgâmune bonŋe oap. Otmu Anitâŋe tihitnenŋe olâk sâm nanŋe hâŋgângumu gewuap sâmain yamâ gâ ya naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Yawu sâm âwurem ari gariŋe den halowâk ekuop. “Kutdânenŋe mâtâwân taka kinmâ gâhât yap.” ");
INSERT INTO spl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","Yawu sâmu Mariaŋe Yesu penewaŋgiwe sâm yahatmâ sururuk sâm ariop. ");
INSERT INTO spl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahatmâ arimu bukulipŋe kak takawi yaŋe “Mariaŋe weŋe nâŋgâm sumângen ari isewe sâm oap,” sâm yahatmâ betŋan watbi. ");
INSERT INTO spl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariaŋe sururuk sâm ari Yesu penewaŋgim isem kinmâ yuwu sâm ekuop. “Kutdâ, gâ nen orowâk tatbin mâne iminetŋaŋe ki pilânenekbâp,” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yawu sâm isemu bukulipŋe watbiŋe orowâk isewi. Iseŋetâ yekmâ Yesuŋe tepŋe nâŋgâyiŋgim yuwu sâm âiyongop. ");
INSERT INTO spl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Yâk wosapâ kurihiwi?” Sâmu sâwi. “Pato, yuân ga ek,” sâwi. ");
INSERT INTO spl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yawu sâŋetâ Yesuŋe yekmâ tepŋe nâŋgâyiŋgim isem kinop. ");
INSERT INTO spl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yakât otmâ lohimbi kinbiŋe ekmâ yuwu sâwi. “Ekŋet. Nâŋgân nâŋgânŋe yâkâlen kepeim manmapgât yawu oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yâhâ nombotŋaŋeâmâ yuwu sâwi. “Lok senŋe bok sâsâŋe ya emelâk senŋe lâwâlemu hâreakmu ehop. Yawu gârâmâ Lasaro heŋgeŋguop mâne ki mumbâp. Ki heŋgeŋguop yakât nâŋgâmunŋe bâleap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yawu sâŋetâ Yesuŋe nâŋgâmu ki ârândâŋ otmu sumângen ariop. Lasaro yamâ kârikin kâlehen katŋetâ tatmu kât pato âlâŋe mâtâpŋe maŋguwi. ");
INSERT INTO spl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ya ekmâ “Kât ya hâpunŋetâ ariâk,” sâm ekyongop. Ekyongomu Mataŋe sâop. “Kutdâ, kurihimunŋe hilâm imbât pesuk yap. Yakât emelâk tâtuk sâm korokŋe pilap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Sâmu sâop. “Yamâ nâhâlen biwihaŋe kepeim manbuat yanâmâ nâŋe Anitâhât wâtŋan kinmâ kulem membom ya ekdâ âlâ kândâkdâ otbuap yakât emelâk ekgohowan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yesuhât sâtgât otmâ kât pato ya hâpunŋetâ arimu yâkŋe himbimân pak sâm ekmâ yuwu sâm ulitguop. “Awoŋ, gâ ulitgohomune nâŋgânihimat ya naŋgan. ");
INSERT INTO spl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yawu gârâmâ lohimbi kinsai yuŋe gurâ gâŋe hâŋgânnohorâ gewan ya ekmâ nâŋgâŋetâ bulâŋe olâkgât senyeŋan kinmâ ulitgohoan.” ");
INSERT INTO spl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yawu sâm purik pilâm Lasaro kunop. “Lasaro, yahatmâ ge.” ");
INSERT INTO spl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sâmu uk sâm yahalop. Yâhâ kâiŋe bâtŋe yamâ mem sâŋgum kaok yaŋe sâhâm kuratguwi. Otmu kun kundenŋe ya gurâ sâŋgumŋak sâhâm kurihiwi. Yakât otmâ Yesuŋe yuwu sâm ekyongop. “Sâŋgum ya holaŋmâ pilâŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yesuŋe kulem miop yan lohimbi dondâŋe kak taka kinbiŋe ekmâ biwiyeŋe yâkâlen katbi. ");
INSERT INTO spl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yâhâ nombotŋaŋeâmâ kulem miop yakât den pat Parisaio ekyongowi. ");
INSERT INTO spl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ekyongoŋetâ yaŋak Parisaioŋe hotom uminiwi ya yeŋgât kunlipyeŋe ari yuwu sâm ekyongowi. “Lok yuŋe kulem topŋe topŋe memap yakât girawu otne? ");
INSERT INTO spl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mâtâp ki maŋguwaŋginom yamâ lohimbi kerekŋe yâkâlen torokatnomai. Yâkâlen torokatŋetâ Roma kunlipnenŋaŋe nâŋgâŋetâ bâlemu tembe lâulipyeŋe hâŋgânyongoŋetâ taka nengât opon kâmbukŋe kândoŋmâ itit kiom tuhuneneknomai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yawu sâŋetâ hotom uminiwi ya yeŋgâlen gâtŋe lok âlâ, kutŋe Kaipa sâm, yamâ yambu yan hotom uwi ya yeŋgât kunyeŋe pato manop. Yâkŋeâmâ yahatmâ yuwu sâm ekyongop. “Yenâmâ nâŋgâm hâum pâpgumai. ");
INSERT INTO spl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yakât otmâmâ yuwu sâm ekyongomune nâŋgâŋet. Nen Yura lohimbi kerekŋe hiliwahomaingât lok yuŋahâk muâk sânom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yawu gârâmâ den sâop ya ikŋahâk ki sâm teteop. Yâhâmâ yambu yakât hotom uwi ya yeŋgât kunyeŋe manop. Yawuhât den ya sâop yakât bulâŋe yamâ Yesuŋe kawenenŋan kinmu kuŋetâ muop. ");
INSERT INTO spl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yâhâ Yura nengâlâk ki muop. Lohimbi wosapâ me wosapâ mansaiŋe Anitâhâlen biwiyeŋe katnomai kerek menduhunenekmu komot konohâk otnom. Otmâ emelâk manman kârikŋahât pat kuningiop ya menomgât kawenenŋan kinmu kuŋetâ muop. ");
INSERT INTO spl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Otmu Kaipaŋe sâop yapâek topŋe katmâ Yesu muâkgât den hikum mâtâpgât pâinmâ gawi. ");
INSERT INTO spl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yakât otmâ Yesuŋe hoŋ bawalipŋe menenekmu Yuraia hân pilâm, kapi âlâ, kutŋe Eparaim sâm ya lok ki manmai yakât horatŋehen ariwin. ");
INSERT INTO spl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yakât kakŋanâmâ nengât Tihit tihit hombaŋ tâlâhumu yan lohimbi dondâŋe Anitâŋe nâŋgâyiŋgimu ârândâŋ olâkgât toen piriakne sâm Yerusalem kapi patoen yâhâwi. ");
INSERT INTO spl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Sâp yanâmâ hotom uminiwi yeŋgât kunlipyeŋe otmu Parisaioŋe lohimbi yuwu sâm ekyongowi. “Yesu takawuap otmâmâ lok âlâ me âlâŋe ekmâ ga eknongomu nenŋe pâi emetŋan mem katnom,” sâwi. Yakât otmâmâ Yesu ekŋetâ biatmu opon kâmbukŋan yâhâm yuwu sâm alahu gulahu otbi. “Yen girawu naŋgai. Yesu hombaŋ yu kakŋe ki mon ekbuap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yâhâ Yura lohimbiŋe menduhuakmâ Yesuhât mambotŋetâ bialop. Otmu yakât kakŋan hilâm nombolân konok pesuk sâmu Tihit tihit hombaŋ tetewuap ya utâpgumu Yesuŋe menenekmu Eparaim kapi pilâm Betani kapiân ariwin. Yâhâ Betani kapi yamâ Yesuŋe Lasaro mumuŋambâ mem yahalop. ");
INSERT INTO spl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yan arimunŋe kapi ambolipŋe nombotŋaŋe Yesuhât heroŋe otmâ orowâk menduhuakmâ sot uŋetâ newin. Nem tatmunŋe Lasaroŋe Yesu hâlâŋmâ talop. Otmâ Mataŋe sot um hâum ningimu newin. ");
INSERT INTO spl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nem tatmunŋe gariŋaŋe nak âlâ toŋe kukŋe suk suk, hâmeŋe yahat yahatŋe, moselemu Yesuhât kâiŋan gemu somotŋe kâlep pato yaŋe mem gowasiŋmâ kereŋ mewaŋgiop. Otmu kukŋe yaŋe pindindiŋ sâm hâmenenŋan yâhâop. ");
INSERT INTO spl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kukŋe nâŋgâm nengâlen gâtŋe âlâ, kutŋe Yurasi, Karioto kapi amboŋe yamâ gâmâlâk Yesuhât betŋehen kioŋbuap yaŋe sâop. ");
INSERT INTO spl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bâe. To kukŋe suk suk yu mem ari lok nombotŋe yiŋgimunŋe yakât hâmeŋe, wan tausen kina yawuya ningiŋetâ lohimbi umburuk mansai kâsikum tânyongombâingât dop.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Otmu yâhâmâ den yu sâop yuâmâ lok umburuk manbi ya tânyongonehât ki sâop. Yâhâmâ nengât tewetsenŋe katipŋe galemgum kinmâ yapâ kombo meningiminiop. Yakât otmâ ikŋahât nâŋgâm sâop. ");
INSERT INTO spl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","8","Yawu sâmu Yesuŋe yuwu sâm ekuop. “Kâmbukŋe, ki sâm guhuŋmâ tatŋet. Kulem miap yu ekmune ârândâŋ oap. Yawu gârâmâ nâ getek nohoŋetâ mumbom yan to torehenŋe tap yuŋe mem yâhâpŋe pirinekbuap. Yawu gârâmâ yu ki mem hâŋgângum tewetsenŋe mem lohimbi umburuk tânyongomai. Yamâ wongât? Yâhâmâ yen orop sâp kâlep manŋetâ tânyongonomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Otmu Yesuŋe Betani kapiân yâhâ talop yan lohimbi dondâŋe nâŋgâm ekne sâm takawi. Otmu yakâlâk bia. Emelâk Yesuŋe Lasaro mumuŋambâ mem yahalop ya nâŋgâwihât ekne sâm takawi. ");
INSERT INTO spl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Taka Lasaroŋe mumuŋambâ yahalop yakât ekŋetâ âlâ kândâkdâ otmu biwiyeŋe Yesuhâlen katbi. Yakât otmâmâ hotom uminiwi yeŋgât kunlipyeŋaŋe nâŋgâŋetâ bâlemu den yuwu sâm hikuwi. “Lohimbi kiŋgitŋe orowâkŋe Yesuŋe Lasaro mumuŋambâ mem yahalop ya nâŋgâm yâkâlen torokatmaihât yâhâp yâhâp yotgomunŋe mundomawot,” sâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Emet haŋ sâmu nenŋe yahatmâ Betani kapi pilâm Yerusalem kapiân yâhâwin. Betani kapi pilâmunŋe lohimbi dondâŋe Tihit tihit hombaŋ ekne sâm Yerusalem kapiân taka tatbiŋe Yesu kapiân takawuap ya nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ya nâŋgâm kapi pilâm gem matuk yawuyaek yakât esenŋe hârem mâtâwân kinŋetâ gamunŋe heroŋe otbaŋgim sâwi. “Anitâŋe Isirae nengât tihitnenŋe otbuat sâm kunnenŋe katgekmâ âi sâm gihim hâŋgângohomu mat takat. Yakât otmâ Anitâ mepaeain,” sâm heroŋe otbi. ");
INSERT INTO spl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Heroŋe otŋetâ Yesuŋe doŋgi nanŋe âlâ mem kakŋan yâhâ tatmâ kapiân yâhâop. Otmu yâhâop yakât emet inânŋan poropete âlâŋe den kulemguop ya yuwu tap. ");
INSERT INTO spl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yen Yerusalem kapi ambolipŋe nâŋgâŋet. Yeŋgât kutdâyeŋe doŋgi nanŋe kakŋan tatmâ yeŋgâlen takamu ekmâ heroŋe nâŋgâwaŋginomai. Yakât otmâ âlâkuâk ki gorâyiŋgiwuap.” Den kulemguop ya yawu tap. ");
INSERT INTO spl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Otmu sâp yanâmâ hoŋ bawalipŋe nenŋe doŋgi ya dâim ge waŋmunŋe kakŋan tatmâ kapiân yâhâop. Kapiân yâhâop yan den yakât bulâŋe teteop yakât hâum pâpguwin. Yâhâ Yesuŋe himbimân âwurem yâhâop yakât kakŋan yukât nâŋgâmunŋe keterahop. ");
INSERT INTO spl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Otmu emelâk Yesuŋe Lasaro mumuŋambâ mem yahalop yakât lohimbi dondâŋe ekbi. Otmu yâkŋe bukulipyeŋe ki ekbi ya ekyongoŋetâ nâŋgâwihât Yesu ekne sâm mâtâwân ge penewaŋgim heroŋe otmâ orowâk kapiân yâhâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Heroŋe otbaŋgiŋetâ Parisaio nombotŋaŋe ekmâ nâŋgâm bâlewaŋgim yuwu sâm alahu gulahu otbi. “Bâe, nenŋe lohotŋe ot tatmunŋe lohimbi kiŋgitŋe orowâkŋe Yesuhâlen torokatnomosai yukâ. Yakât otmâ girawu otmunŋe yan Yesu watmâ tai yu pilâŋet?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Otmu sâp yanâmâ Girik kapi ambolipŋe nombotŋaŋe Anitâ mepaene sâm Yerusalem kapiân yâhâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kapiân yâhâ Yesu ekne sâm bukunenŋe âlâ, Pilip sâm, yamâ Besaita kapi yamâ Galilaia hânân tap yan gâtŋe, yâkâlen toho Yesuhât âikuwi. ");
INSERT INTO spl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Yesuhât âikuŋetâ Pilipŋe bukuŋe Anderea ekumu orowâk Yesuhâlen ari den ya ekuowot. ");
INSERT INTO spl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ekumutâ nâŋgâm matŋe yuwu sâm ekyotgop. “Bâiŋ, Anitâŋe nâ lok bulâŋe hâŋgânnohomu gewan. Nâhât topne tetemu nâŋgâŋetâ âlâ kândâkdâ otmu mepaeneknomaihât sâpŋe tâlâhuap. ");
INSERT INTO spl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yakât den âlâen hâum sâmune nâŋgâmutâ keterahâk. Seŋgo alikŋe ki mondotmâ hân kâlehen katmain yamâ kâmŋe ki gamu bonŋe ki otmap. Yâhâ seŋgo alikŋe hân kâlehen katmunŋe tatmâ kâmŋe pururuk sâm yahatmâ esenŋe huhumap. Yawu otmâ suriŋe pilâm yaŋak bonŋe otmap. Yawu gârâmâ seŋgo alikŋe konok yapâek bonŋe pato tetemap. Yakât dopŋeâk nohoŋetâ mumune hânân katnekŋetâ gemune yapâ gâtŋaŋe lohimbi dondâŋe manman bulâŋe mem tetenomai. ");
INSERT INTO spl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yakât yuwu sâmune nâŋgâyet. Lohimbi âlâ me âlâŋe yeŋe manmanyeŋahâlâk mem mete tuhum mannomai yamâ hâmbâi hiliwahonomai. Yâhâ lok âlâ me âlâŋe manmanyeŋahât ki mem mete tuhum nâhâlâk biwiyeŋe katmâ mannomai yaŋeâmâ manman kârikŋan mannomai. ");
INSERT INTO spl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yâhâ lok âlâ me âlâŋe nâhâlen torokatmâ hoŋ banihinomai yaŋeâmâ tem lâunihim mannomai. Yawu manŋetâ Awoŋnaŋe meyekmâ nâhâlen torokatyekmu biwinenŋaŋe hikuakmâ konohâk otmâ orowâk manbisâin. ");
INSERT INTO spl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yawu gârâmâ sâp yiwereŋe yu biwine umatŋe oap. Biwine umatŋe otmu yakât girawu sâwom. Yuwu mon sâwom? Awoŋ, umatŋe bâleŋe yu kaknan yâhâmapgât nâŋgânihirâ pilâm ariwehât naŋgan. Yamâ benŋe yawu bia. Umatŋe yu kaknan yâhâmu sâtgum mumbehât hâŋgânnohorâ gewan. ");
INSERT INTO spl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yakât otmâ sârâ umatŋe yu me ya kaknan yâhâwuap yu ekmâ lohimbi dondâŋe mepaehekŋetgât naŋgan.” Yawu sâop. Yawu sâmu himbimâmbâ âwâŋaŋe yuwu sâop. “Emelâk kulem topŋe topŋe mem garâ ekŋetâ âlâ kândâkdâ otmu mepaenekmâ gamai. Yawu gârâmâ âlâkuâk kulem mendâ ya ekmâ mepaeneknomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Yawu sâmu lohimbi yan kinbiŋe denŋe nâŋgâm sâwi. “Âo, himbim guŋguruŋ sâmu naŋgain.” Yâhâ nombotŋaŋe sâwi. “Bia, aŋelo âlâŋe den ekumu ombeŋe munŋaŋe ŋawaŋ ŋawaŋ sâm arimu naŋgain,” yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yawu sâŋetâ Yesuŋe yuwu sâm ekyongop. Anitâŋe den yiwereŋe eknohomu naŋgai yuâmâ biwine houŋ sâmapgât ki yap. Yeŋe nâhât nâŋgânihiŋetâ keterahâkgât yap. ");
INSERT INTO spl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sâp yiwereŋe yupâek Anitâŋe lohimbi yeŋgât biwiyeŋe ekmâ mem kiwiliyekmâ sâm hâreyiŋgiwuap. Yâhâ lohimbi bâleŋe yeŋgât amboyeŋe, kutŋe Satan sâm, ya mem ge katmune yâkât wâtŋe pesuk sâwuap. ");
INSERT INTO spl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yakât topŋeâmâ yuwu. Nâ howanân nohom kânâŋgânekŋetâ kinbom. Yawu otbom yan lohimbi kerek dâiyekmune nâhâlen torokatnomaihât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mem âlâlâ tuhuŋetâ mumbuap yakât topŋe nâŋgâŋetâ keterakyiŋgiâkgât Yesuŋe yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yawu sâm ekyongomu lohimbi yan kinbiŋe nâŋgâŋetâ ki ârândâŋ otmu yuwu sâm âikuwi. “Bâiŋ, yat yawu bia. Moseŋe den âlâ kulemguop ya yuwu tap. Anitâŋe hâŋgângumu gewuap yamâ manman kârikŋan manmâ yâhâwuap. Yawu gârâmâ gâŋeâmâ yuwu sâmat. “Anitâŋe lok bulâŋe hâŋgânnohomu gewan,” ya sâmat. Yamâ girawuhât otmâ “Howanân nohom kânâŋgâneknomai” yat. Yakât otmâ Anitâŋe lok bulâŋe hâŋgângumu gewuap yakât topŋe yamâ nâŋgâm hilipgumat. Yakât otmâ lok âlâhât yat?” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","36","Sâŋetâ sâop. “Sâp yiwereŋe yuâmâ sâmune laŋinŋaŋe biwiyeŋan pilâmu haŋ sâyiŋgimap. Yawu gârâmâ laŋinŋe bok sâmu omoŋ bâleŋe sahakmapgât yeŋe laŋinŋahât amboŋahâlen biwiyeŋe kepeim laŋinŋanâk mannomai. Yâhâ sâp ki kâlep otmâek laŋinŋe bok sâmu yan omoŋ sahakbuap. Yawu otmu omoŋân mannomaiŋe bam gane sâm mâtâp ki ekmâ awawi guwawi otmâ ari hiliwahonomai.” Yawu sâop. Yesuŋe den sâm tiŋ pilâm pilâyekmâ ge misiŋgurahop. ");
INSERT INTO spl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuŋe hânân manop yan kulem topŋe topŋe memu Yura lohimbiŋe yakât topŋe ekŋetâ ki keterakmu yaŋak yâkâlen biwiyeŋe ki katbi. ");
INSERT INTO spl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yâkâlen biwiyeŋe ki katbi yakât emet inânŋan poropete âlâ, kutŋe Yesaia sâm, kulemguop yakât bulâŋe teteop. “Kutdâ, gâhât den pat âlepŋe ekyongomunŋe kapi ambolipŋaŋe nâŋgâŋetâ ki bonŋe otmap. Otmu gâŋe mâmâŋe otningirâ kulem topŋe topŋe memunŋe ekŋetâ ki keterakmap. Yakât otmâ gâhâlen biwiyeŋaŋeâmâ ki kepeimai.” Yawu kulemguop. ");
INSERT INTO spl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Anitâhâlen biwiyeŋaŋe ki kepeiwi yakât topŋe teteâkgât Yesaiaŋe den âlâ kulemguop ya yuwu tap. ");
INSERT INTO spl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Lohimbi nombotŋaŋe Anitâhât hâkâŋ otmâ nâŋgâm kâkâsuk mansai. Yakât otmâ biwiyeŋe alitmâ hiliwahoŋetgât yâkŋe nâŋgân nâŋgânyeŋe mem gulip tuhuyiŋgimu ki nâŋgâŋetâ hâumap. Otmu senyeŋe mem kâtâpgumu ki ekŋetâ keterakmap.” Yawu kulemguop. ");
INSERT INTO spl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yâhâ Yesu âwâŋaŋe âi sâm waŋop ya tuhum tiŋ pilâm mumuŋambâ yahatmu ekŋetâ âlâ kândâkdâ otbuap ya Yesaiaŋe emet inânŋan ekmâ nâŋgâm kulemguop. ");
INSERT INTO spl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","43","Yawu gârâmâ Yura nengât miti emetŋahât galem nombotŋaŋeâmâ biwiyeŋe Yesuhâlen katbi. Yawu gârâmâ bukulipyeŋaŋe nâŋgâyiŋgiŋetâ yahalâkgât lohotŋanâk manbi. Yawu manbi yakât Anitâŋe nâŋgâmu ârândâŋ oap me bia yakât ki nâŋgâwi. Yawu nâŋgâm Parisaioŋe nâŋgâm bâleyiŋgim miti emetŋambâ kewilâyekŋetâ yaehen manmaihât Yesuhâlen biwiyeŋaŋe kepeiwi yakât ki sâwi. ");
INSERT INTO spl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","45","Yesuŋe torokatmâ yuwu sâop. “Lohimbi âlâ me âlâŋe nâhâlen biwiyeŋe kepeimai yamâ biwiyeŋe nâhâlen kepeiain sâm awoŋne hâŋgânnohomu gewan yâkâlen kepeimai. Yâhâ lohimbi âlâ me âlâŋe nâhâlâk nâŋgâmai yamâ nâŋgânihiain sâm awoŋne hâŋgânnohomu gewan yâk nâŋgâwaŋgimai. ");
INSERT INTO spl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yâhâ balam sem laŋinŋe pilâmu lohimbiŋe ekmâ heŋgeŋgumai yakât dopŋeâk nâŋe hohetyeŋan ge manmune nâhât manmannahât laŋinŋaŋe biwiyeŋan pilâmu haŋ sâyiŋgimap. Yawu otmâ lohimbi âlâ me âlâŋe omoŋân torokatmâ manmaihât biwiyeŋe nâhâlen kepeim manŋetâ haŋ sâyiŋgiâkgât gewan. ");
INSERT INTO spl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nâŋe lohimbi den âiân katyekmâ matŋe yiŋgiwehât ki gewan. Nâmâ sârereyekmâ manman kârikŋan mem torokatyekbe sâm gewan. Yakât otmâ lohimbi nombotŋaŋe nâhât den nâŋgâŋetâ gemu bet pilâm manmai yamâ den âiân ki katyekmâ matŋe yiŋgiwom yakât topŋe yuwu. ");
INSERT INTO spl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Den ekyongomune nâŋgâŋetâ gemu bet pilâmai den yuŋahâk sâp patoen topyeŋe mem tetemu Anitâŋe matŋe yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nâŋe den ekyongom gaman yuâmâ nine eŋgatneâk ki ekyongoman. Awoŋnaŋe den yu ekyongowuat sâm hâŋgânnohomu gewan. ");
INSERT INTO spl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yakât topŋe yuwu tap. Awoŋnahât den ekyongom gaman yu lâum mannomai yanâmâ manman kârikŋan manmâ yâhânomai ya nâŋgâmune bulâŋe otmap. Yakât otmâmâ awoŋnaŋe den yu ekyongowuat sâm nihiop. Yawuâk ekyongoman.” Yesuŋe yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Emet omoŋ otmu haŋ sâwuap yan Tihit tihit hombaŋ tetemu Yesuŋe pilânenekmâ âwâŋahâlen âwurem yâhâwuap yakât nâŋgâop. Yakât otmâ nen wawaenenekmâ manmâ gaop yawuâk torokatmâ manbuap yakât nâŋgâmunŋe keterahâkgât menenekmu emet âlâen menduhuakmâ sot um newin. ");
INSERT INTO spl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Otmu bukunenŋe âlâ orowâk um nem tatbin yamâ Simon nanŋe, kutŋe Yurasi sâm, Karioto yan gâtŋe. Yamâ Satanŋe emelâk yâkât biwiŋan kioŋmu Yesu betŋehen kioŋbuap yakât biwiŋe kalop. ");
INSERT INTO spl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yawu gârâmâ Yesu âwâŋaŋe wâtŋe waŋmâ hâŋgângumu ge wuân me wuân otbuapgât dop tatbaŋgiop yakât nâŋgâop. Yawu gârâmâ umatŋe tetewaŋgimu yakât kakŋan âwâŋahâlen âwurem yâhâwuap yakât gurâ nâŋgâm manmanŋe ki alilop. ");
INSERT INTO spl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yawu otmâ nenŋe bukulipnenŋe yeŋgât nâŋgâm hoŋ bayiŋginehât Yesuŋe nem tatbin yapâ uk sâm yahatmâ sâŋgum kâlep mânuŋahop ya tuhum pilâm kereŋ âlâ mem pâŋan kepeiop. ");
INSERT INTO spl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yawu otmâ yahatmâ to mem kondoân gâiop. To gâim katmâ nen hoŋ bawalipŋe konok konok kâinenŋe piriningiop. Pirimâmâ kereŋ meningiop. ");
INSERT INTO spl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yawu otmâ, Simon Petoro yâkât kâiŋe piriwaŋgiwe sâm otmu yakât Petoroŋe nâŋgâmu umatŋe otmu yuwu sâm ekuop. “Kutdâ, girawuhât otmâ kâine piriwe sâm oat? Pilâhât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Sâmu sâop. “Wongât kâihe pirihihian yakât ki naŋgat. Hâmbâi mâne gâmâ topŋe nâŋgârâ keterakbuap.” ");
INSERT INTO spl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Sâmu sâop. “Gâmâ kâine ki piri. Kâmbukŋe, pilâ.” Sâmu sâop. “Nâŋe kâihe ki piriwom yamâ gâ nâ pilânekmâ gikiâk manbuatgât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Sâmu sâop. “Bâiŋ, âlepŋe gâŋe pirinekbe sâm oat gârâmâ kâine konohâk ki piriwuat. Gâŋe bâtne otmu senne hâmene ya orowâk pirinekbuatgât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sâmu sâop. “Yen kerekŋe omoŋânâk piriaksaihât salehâk tai. Yawu gârâmâ mâtâp tâlim takai yakât otmâmâ kâiyeŋe konok pirian. Yawu gârâmâ yen tai yu osetyeŋan gâtŋe âlâmâ salehâk ki mansap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yurasiŋe ikŋe betŋehen kioŋbuap yakât nâŋgâm sâop. ");
INSERT INTO spl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Otmu kâiyeŋe ya kerehâk pirim pesuk pilâm sâŋgumŋe holaŋmâ kalop ya yâhâpŋe mem mânuŋahop. Mânuŋakmâ gewâkŋan ge tatmâ yuwu sâm eknongop. “Yiwereŋe kâiyeŋe piriyeksan yukât topŋe nâŋgâŋetâ keterahâkgât yuwu sâmune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yeŋeâmâ “Patonenŋe” me “Kutdânenŋe” sâm nohonmai. Nâŋe yeŋgât kunyeŋe manman yakât nohonmai ya nâŋgâmune ârândâŋ oap. ");
INSERT INTO spl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","15","Yawu gârâmâ nâŋe kunyeŋe oan yakât otmâmâ yeŋe hoŋ bawaŋgiakmâ mannomaihât dop kum kâiyeŋe pirian. Yakât otmâ yengu towat tiripyongoan yuwuâk otmâ mannomai. ");
INSERT INTO spl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yakât yuwu sâmune nâŋgâŋet. Yeŋe hoŋ banihim mansai. Yakât otmâ kutdâlipne mannomaihât dop ki tap. Yawu gârâmâ nâŋe hoŋ hâŋgânyongomune nâhât tem lâum mannomai. Yawu otŋetâ amutyeŋan manbomgât dop bia. ");
INSERT INTO spl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yakât nâŋgâm sâp yiwereŋe yu hoŋ bayiŋgian yakât dopŋeâk hoŋ bawaŋgiaknomai. Yawu otnomai yanâmâ Anitâŋe nâŋgâmu ârândâŋ otmu biwi heroŋe mannomai. ");
INSERT INTO spl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nâmâ biwiyeŋahât topŋe nâŋgâm tem lâunihim manŋetgât meyekmune mansain. Yawu gârâmâ kerek yeŋgât ki yan. Miti pepaen den âlâ yuwu tap. “Bukune lau konok niait yaŋeâmâ mem purik pilânehop.” Den yawu tap yakât bonŋe teteâkgât yen tai yu osetyeŋan gâtŋe âlâŋe mem bâlenekbuap. ");
INSERT INTO spl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nâŋe sâp yiwereŋe yu den ekyongoan yukât bonŋe tetewe sâm oap. Tetemu ekmâ yan Anitâ orop dopnetŋe konohâk oap yakât topŋe ekmâ nâŋgâm heŋgeŋgunomai. ");
INSERT INTO spl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yakât yuwu sâmune nâŋgâŋet. Lohimbi âlâ me âlâŋe buku otnihimai yaŋe nâ otnihiain sâm yan awoŋne hâŋgânnohomu gewan yâk otbaŋgimai. Yawu gârâmâ nâŋe yawuâk hâŋgânyongomune ariŋetâ buku otyiŋginomai. Yawu otyiŋginomai yaŋe yen otyiŋgiain sâm yan nâ otnihinomai” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuŋe yawu sâm biwiŋe umatŋe otmu yuwu sâop. “Bulâŋanâk ekyongomune nâŋgâŋet. Yen tai yu osetyeŋan gâtŋe âlâŋe betnehen kioŋbuap.” ");
INSERT INTO spl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Den sâop yamâ âlâhât sâop ya ki nâŋgâmunŋe teteop. ");
INSERT INTO spl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","Yâhâ nâ otmu Yesu biwinetŋe hikuakmâ konohâk olopgât nâmâ yâk hâlâŋmâ tatban. Yakât otmâmâ Petoroŋe senŋaŋak otmu ândâp katmune halowângen eknohom sâop. “Ya ekum ehâ. Yu âlâhât yap?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yawu sâm eknohomu nâŋgâm nâŋe Yesu yuwu sâm âikuwan. “Bâe, gâ yat yamâ âlâhât yat? Ya sârâ nâŋgâwe.” ");
INSERT INTO spl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Âikumune sâop. “Sot mem motokmâ waŋmune nembuap yakât yan.” Yawu sâm sot mem motokmâ Yurasi waŋmu miop. ");
INSERT INTO spl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Miop yanâk Satanŋe biwiŋan kioŋop. Biwiŋan kioŋmu yaŋak Yesuŋe nâŋgâm yuwu sâm ekuop. “Gâ yiwereŋe yu me ya otbehât naŋgat. Ya âlepŋe otbuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesuŋe Yurasi yawu sâm ekuop yakât topŋe bukulipŋaŋe ki nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yâhâ Yurasiŋe nengât tewetsenŋe galemgum manminiop. Yakât otmâ bukulipŋe nombotŋaŋe yuwu nâŋgâwi. “Yurasiŋe tewetsenŋe mem ari sot puluhuâkgât Yesuŋe ekuap,” yawu nâŋgâwi. Yâhâ nombotŋaŋeâmâ “Yurasiŋe tewetsenŋe sâlikum nombotŋe hârem lok umburuk mansai ya yiŋgiâkgât ekuap,” yawu nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yesuŋe sot mem motokmâ waŋmu miop yanâk Yurasiŋe yahatmâ pilânenekmâ ariop. ");
INSERT INTO spl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Yurasi gem arimu Yesuŋe yuwu sâm eknongop. “Anitâŋe nâ lok bulâŋe hâŋgânnohomu gewan yakât topŋe lohimbi kerekŋe nâŋgâm heŋgeŋguŋetgât kulem âlâ nâhâlen tetewuap. Tetemu lohimbi dondâŋe ekmâ nâŋgâŋetâ âlâ kândâkdâ otmu mepaeneknomai. Yâhâ nâŋe Anitâhât tem lâumune kulem tetemu ekŋetâ ewe membe otmu yaŋak Anitâ mepaenomai. ");
INSERT INTO spl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bukulipne, emelâk Parisaio ekyongowan ya yawuâk ekyongomune nâŋgâŋet. Sâp kâlep ki otmuâk pilâyekmâ ariwom. Yawu gârâmâ ariwom yan gurâ yeŋe arinomaihât dop âlâ ki tap. Yakât otmâ pâinneknomai yamâ ki neknomai. ");
INSERT INTO spl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yawuhât den âlâ yuwu ekyongomune lâum mannomai. Nâŋe biwinaŋe kepeiyekmâ mansan yakât dopŋeâk yengu biwiyeŋaŋe kepeiakmâ buku oraŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yawu oraŋgim mannomai yanâmâ yeŋe nâhât hoŋ banihim mansai yakât yen yekmâ nâŋgâyiŋgim heŋgeŋgunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesuŋe yawu sâmu Petoroŋe yuwu sâm âikuop. “Kutdâ, gâ wosaken ariwuat?” Sâmu sâop. “Yen pilâyekmâ arimune watneknomaihât dop ki tap. Yawu gârâmâ hâmbâi sâp âlâenâmâ nâhâlen torokatnomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Sâmu sâop. “Kutdâ, wongât gâ orop ki arinom yat? Yâhâ kasalipgaŋe gohoŋetâ mumbuat yamâ nâ orowâk notgonomaihât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Sâmu sâop. “Bukune, yuwu sâmune nâŋgâ. Gâŋe nâ betnohom topne kurihiwuat. Betnohorâ kalimbuŋe otmu gokorok isewuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuŋe torokatmâ yuwu sâm eknongop. “Nâŋe pilâyekmâ ariwom yakât ki nâŋgâm ketet otnomai. Yeŋe Anitâ tihit tihit amboŋahâlen biwiyeŋaŋe kepeim manmai yakât dopŋeâk nâhâlen gurâ biwiyeŋaŋe kepeim mannomai. ");
INSERT INTO spl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Awoŋe tatmap yan emet biwiŋe dondâ tap. Yawu ki tap mâne, nâŋe emelâk yakât sâm tetem ekyongombâm. Nâ in ki ariwom. Yeŋgât kawe memune yan ari tatnomaihât ariwom. ");
INSERT INTO spl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ari kaweyeŋe heŋgeŋgum yanâmâ âwurem taka meyekmune nâ orowâk ari mannom. ");
INSERT INTO spl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yâhâ nâŋe Anitâhât tem lâum âi sâm nihiop ya tuhum metem âwurem yâhâwomgât mâtâp ya emelâk ekyongowan.” ");
INSERT INTO spl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yawu sâmu bukunenŋe âlâ, kutŋe Toma sâm, yâkŋe yuwu sâm âikuop. “Kutdâ, gâ wosaken ariwuat ya ki naŋgain. Yakât otmâmâ nengu mâtâp girawu ya watmâ gâhâlen takanom?” ");
INSERT INTO spl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Sâmu sâop. “Nâ ninak Anitâhâlen arinomai yakât mâtâp oan. Otmu Bulâŋe Amboŋeâmâ nâ mansan. Yakât otmâ lohimbi âlâ me âlâ Anitâhât den ekyongomune nâŋgâŋetâ bulâŋe otmu nâhâlen torokatmâ mannomai yaŋe manman kârikŋan mannomai. ");
INSERT INTO spl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yeŋe nâhât topne nâŋgâm metewi mâne Awoŋnahât topŋe emelâk nâŋgâmbâi. Yawu gârâmâ sâp yupâek nâ nekmâ nâŋgânomai yamâ Awoŋnahât topŋe nâŋgâm heŋgeŋgunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yawu sâmu Pilipŋe sâop. “Kutdâ, awoŋnenŋe tiripnongorâ eknehât naŋgain. Ekmunŋe biwinenŋe huruŋ sâwuap.” ");
INSERT INTO spl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Sâmu sâop. “Pilip, yenâmâ nâ orop sâp kâlep manmâ gain. Yakât otmâ girawuhât otmâ nâhât topne ki naŋgat? Anitâ orop dopnetŋe konohâk oap. Yakât otmâ lok âlâ me âlâŋe nâhât topne naŋgap yamâ Awoŋnahât topŋe gurâ naŋgap. Topnetŋe yawu tapgât wongât “awoŋnenŋe tiripnongorâ ekne” sâm eknohoat? ");
INSERT INTO spl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nâmâ Awoŋ orop biwi nâŋgân nâŋgânnetŋe hikuakmâ dop konohâk otmu tatmait yakât topŋe naŋgat.” Yawu sâm ekum yuwu sâm eknongop. “Nâŋe den ekyongoman yuâmâ nine eŋgatneâk me ninahâlâk otmâ ki sâman. Awoŋ orop biwi nâŋgân nâŋgânnetŋe konohâk otmâ tatmait. Yakât otmâ yâkŋe mâmâŋe otnihimu yâkât wâtŋan kinmâ kulem topŋe topŋe mem gaman. ");
INSERT INTO spl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yawu gârâmâ Awoŋ orop biwi nâŋgân nâŋgânnetŋe hikuakmâ konohâk tatmait ya nâŋgâŋetâ bulâŋe olâkgât naŋgan. Ya nâŋgâŋetâ ki bulâŋe otbuap otmuâmâ kulem topŋe topŋe mem gamune ekmai yakât nâŋgânomai yanâmâ netgât nâŋgâŋetâ bulâŋe otbuapgât naŋgan. ");
INSERT INTO spl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Bulâŋanâk ekyongomune nâŋgâŋet. Awoŋnaŋe mâmâŋe otnihimu yâkât wâtŋan kinmâ âi memune bulâŋe tetemap. Yakât otmâ Awoŋnahâlen âwurem yâhâwom yanâmâ âi bulâŋe pato tetemu eknomai. Dop yawuâk lohimbi âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim manŋetâ mâmâŋe otyiŋgiwom. Yawu otyiŋgimune nâhât wâtnan kinmâ âi meŋetâ bulâŋe tetewuap. ");
INSERT INTO spl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Awoŋnahâlen arimune yan yeŋe biwiyeŋaŋe nâhâlen kepeim yu me yakât ulitnohomai yamâ âlepŋe nâŋgâyiŋgiwom. Nâŋgâyiŋgimune bulâŋe tetemu lohimbiŋe ekmâ Awoŋne mepaenomai. ");
INSERT INTO spl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yakât yâhâpŋe sâmune nâŋgâm heŋgeŋguŋet. Yeŋe nâhâlen biwiyeŋaŋe kepeim yu me yakât ulitnohonomai yamâ âlepŋe nâŋgâyiŋgiwom. ");
INSERT INTO spl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yeŋe nâhâlen biwiyeŋaŋe kepeim mannomai yakât bonŋe yamâ nâhât tem lâum mannomai. ");
INSERT INTO spl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yawu manŋetâ nâŋe Awoŋne ulitgumune yâkŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otyiŋgimu yâkât wâtŋan mannomai. ");
INSERT INTO spl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yâhâ yeŋe yâkât wâtŋan mansai. Yakât otmâ yeŋe yâkât topŋe naŋgai. Yâhâ hâmbâi yâkŋe biwiyeŋan ge mâmâŋe otyiŋgiwuap. Lohimbi biwiyeŋe pâlâmŋe otmâ belângen mansaiŋe yâkât topŋe ki naŋgai. Yakât otmâmâ ya yeŋgâlen ki ge mâmâŋe otyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nâ yiwereŋe pilâyekmâ ariwoman. Yâhâ yen mandu yawu otmâ manmaihât nâŋe âwurem gewom. ");
INSERT INTO spl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yâhâ pilâyekmâ yâhâwom yakât kakŋan lohimbi biwiyeŋe pâlâmŋe otmâ belângen manmaiŋe âlâkuâk ki neknomai. Yawu gârâmâ yenâmâ âlâkuâk neknomai. Otmu nâŋe mumuŋambâ yahatmâ manman kârikŋan manmâ yâhâwom. Yakât otmâ yeŋe gurâ mumuŋambâ yahatmâ nâhâlen torokatŋetâ orowâk manmâ yâhânom. ");
INSERT INTO spl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yâhâ mumuŋambâ yahatbom yanâmâ nâ Awoŋ orop biwi nâŋgân nâŋgânnetŋe hikuakmâ konohâk tatmait yakât topŋe yeŋe nâŋgâm heŋgeŋgunomai. Otmu yen orop biwi nâŋgân nâŋgânnenŋe hikuakmâ konohâk mansain ya gurâ nâŋgâŋetâ keterakbuap. ");
INSERT INTO spl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Lohimbi âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim manmai yamâ nâhât den nâŋgâm tem lâunihimai. Otmu nâhâlen biwiyeŋaŋe kepeim mannomai yamâ Awoŋnaŋe wawaeyekmâ tihityeŋe otbuap. Otmu yeŋe nâ orop konohâk otŋetâ yanâmâ nâŋe biwiyeŋan gemune topne nâŋgâm heŋgeŋgunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yawu sâmu Yurasi Simon nanŋe yâkât nambeŋaŋe yuwu sâm ekuop. “Kutdâ, sârâ nâŋgâwe. Biwinenŋe gâ orop kepeiakmâ konohâk otmu yan biwinenŋan gerâ topge nâŋgâm heŋgeŋgunom. Yâhâ wongât otmâ lohimbi belângen mansai ya yeŋgât biwiyeŋan ki gerâ topge nâŋgânomai?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Sâmu sâop. “Lohimbi âlâ me âlâŋe nâhâlen biwi nâŋgân nâŋgânyeŋaŋe kepeim manmaiŋe nâhât denne nâŋgâm lâumai. Lohimbi yawuya Awoŋnaŋe wawaeyekmâ tihityeŋe otmu net orowâk manmâ yâhânomai. ");
INSERT INTO spl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yâhâ lohimbi âlâ me âlâŋe biwi nâŋgân nâŋgânyeŋaŋe nâhâlen ki kepeim manmaiŋe nâhât den ki lâumai. Yâhâ nâŋe den kâsikum yiŋgim gaman yuâmâ nine eŋgatneâk otmâ ki kâsikum yiŋgiman. Awoŋnaŋe sâm nihiop ya kâsikum yiŋgiman. ");
INSERT INTO spl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yâhâ sâp yiwereŋe yu pilâyekmâ yâhâwom yakât topŋambâek ekyongoan. ");
INSERT INTO spl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yawu gârâmâ pilâyekmâ yâhâmune yakât kakŋan Awoŋnaŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge nâhât âi torokatmâ tâtâem mâmâŋe otyiŋgimu nâŋe den kâsikum yiŋgiminiwan ya bunewâk nâŋgâŋetâ keterak yiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nâ pilâyekmâ yâhâwoman. Biwiyeŋe itoŋ galaŋ otmapgât biwi sânduhân katyeksan. Otmu lohimbi belângen manmaiŋe yen biwi sânduhân katyekne sâm otnomai yamâ imbiâk otnomai. Yâkŋe otnomai yawu ki otbom. Nâŋeâmâ yen orowâk manmâ biwi sânduhân katyekmune yanâk manmâ yâhânomai. Yakât nâŋgâm ki gorâyiŋgiâk. ");
INSERT INTO spl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Emelâk yuwu sâm ekyongoan. “Nâ pilâyekmâ yâhâwom. Hâmbâi mâne âwurem gewom.” Ya naŋgai. Yâhâ yeŋe nâhâlen biwiyeŋaŋe kepeim mansai mâne nâŋe Awoŋnahât sâtgât âi tuhum pesuk pilâm yâkâlen âwurem yâhâwom yakât nâŋgâm heroŋe nâŋgâmbâi. ");
INSERT INTO spl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nâŋe yiwereŋe den ekyongoan yukât bulâŋe tetemu eknomai. Tetemu ekmâ yan topŋe nâŋgâm heŋgeŋgunomai. ");
INSERT INTO spl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yiwereŋe manman bâleŋahât amboŋaŋe hoŋ bawalipŋe hâŋgânyongomu taka meneknomai. Yakât otmâ nâŋe yen orop den kâlep huhunomgât sâp bia. Yamâ benŋe manman bâleŋahât amboŋe yakât amutgen ki mansan. ");
INSERT INTO spl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yawu gârâmâ nâŋe Awoŋnahâlen biwinaŋe kepeim yâkât amutgen manman ya lohimbi kerekŋe nâŋgâŋetgât Awoŋnahât tem lâuwaŋgiman. Lâuwaŋgim umatŋe tetenihiwuap yu ki tetenihiâk sâm ki ulitguwom. Yakât otmâmâ yahatŋetâ arine.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu ikŋan hâum yuwu sâm eknongop. “Nâ wain tâkŋe yan hâum ninahât topne sâm ekyongomune nâŋgâŋet. Nâmâ wain topŋe yawuya. Yâhâ yenâmâ wain kele awatŋe yawuya. Yâhâ Awoŋneâmâ wain kalam yakât amboŋe yawuya. Ikŋahâk wain bulâŋe kiŋgitŋe orowâk kinâkgât hârâtŋe kum heŋgeŋgumap. ");
INSERT INTO spl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yâhâ awatŋe âlâhât bonŋe ki kinmap yamâ Awoŋnaŋe hârem panmu hâlâlâŋ sâmap. Yâhâ awatŋahât bonŋe kinmap yamâ bonŋe kiŋgitŋe orowâk kinâkgât hârâtŋe kum heŋgeŋgumap. ");
INSERT INTO spl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yakât dopŋeâk nâŋe den kâsikum yiŋgim gaman ya nâŋgâŋetâ bulâŋe otmu biwiyeŋaŋe nâhâlen torokatmai. ");
INSERT INTO spl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nâhâlen torokatŋetâ biwinenŋe hikuakmâ konohâk otmu nâhât wâtnan manmâ yâhânomai. Yakât torokatmâ hâum sâwe. Wain awatŋe pak sâm gewuap otmuâmâ yan bonŋe âlâ ki kinbuap. Yakât dopŋeâk yeŋe nâhâlembâ dâiakmâ mannomai yanâmâ bonŋe yeŋgâlen ki tetewuap. ");
INSERT INTO spl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nâŋeâmâ wain topŋe yakât dop oan. Yâhâ yeŋeâmâ wain kele awatŋe yakât dop oai. Gârâmâ yeŋe nâhâlen torokatŋetâ orowâk mannom yamâ yeŋgâlen bonŋe âiloŋgo tetewuap. Yâhâ yeŋe nâ pilâneknomai yamâ yeŋgâlen bonŋe âlâ ki tetewuap. ");
INSERT INTO spl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yâhâ wain awatŋe âlâŋe bonŋe ki tetewuap yamâ hârem panmu hâlâlâŋ sâwuap. Hâlâlâŋ sâmu kâlâwân uŋetâ sewuap. Yakât dopŋeâk lohimbi âlâ me âlâŋe pilâneknomai yamâ Awoŋnaŋe panyekmu hem nâpumân ge kioŋetâ kâlâpŋe seyekbuap. ");
INSERT INTO spl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yâhâ yeŋe nâhât den lâum manŋetâ biwinenŋaŋe hikuakmâ konohâk otbuap yan yeŋe yu me yakât ulitnohonomai yamâ âlepŋe nâŋgâyiŋgiwom. ");
INSERT INTO spl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yeŋe nâ orop manmâ tem lâunihinomai yanâmâ yakât bonŋe manman âiloŋgo yeŋgâlen tetewuap. Yeŋgât manman tetemu lohimbiŋe yekmâ nâhât hoŋ bawalipne sâm Awoŋne mepaenomai. ");
INSERT INTO spl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yâhâ Awoŋnaŋe wawaenekmâ tihitne otmâ gap yakât dopŋeâk nâku yawuâk wawaeyekmâ tihityeŋe otmâ gan. Yakât otmâmâ ki betnohonomaihât naŋgan. ");
INSERT INTO spl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nâŋe Awoŋnahât tem lâum manmune yaŋak yâkŋe biwiŋaŋe kepeinekmâ gamap. Yakât dopŋeâk yeŋe nâhât tem lâum mannomai yanâmâ nâku yawuâk biwinaŋe kepeiyekmâ yâhâwom. ");
INSERT INTO spl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yeŋe nâhât den nâŋgâm biwiyeŋan katmâ heroŋe kakŋan manŋetgât nâŋe ninan hâum ekyongoan. Yakât otmâ tem lâunihim mannomai. Yanâmâ yeŋgât nâŋgâm nâku yawuâk biwi hero nâŋgâyiŋgiwom. ");
INSERT INTO spl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yâhâ den âlâ yuwu sâm ekyongomune lâum manŋetgât naŋgan. Nâ orop biwinenŋaŋe kepeiakmâ konohâk otmu buku oraŋgiain yakât dopŋeâk yengu yawuâk biwiyeŋaŋe kepeiakmâ konohâk otmu buku oraŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yâhâ lok âlâ me âlâŋe buku âlâhât tep âlep nâŋgâwaŋgim sârereŋetâ yakât yongoŋetâ munomai yuŋe buku orotgât mâtâp âlâlâ kerek wangiap. ");
INSERT INTO spl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Otmu yeŋe nâhât tem lâum mannomai yamâ nâhât bukulipne yawu mannomai. ");
INSERT INTO spl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yâhâ lok kunŋe âlâŋe ikŋe biwiŋan den tatmap ya hoŋ bawalipŋe ki ekyongomap. Yawu gârâmâ Awoŋnaŋe den eknohomap yamâ nâŋe kerehâk ekyongom gan. Yawu otman yakât nâŋgâm hoŋ bawalipne ki sâyiŋgiwom. Yamâ bukulipneâk sâmune ârândâŋ otbuap. ");
INSERT INTO spl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yawu gârâmâ yeŋe ki menekbi. Nâŋe yen meyekmâ âi sâm yiŋgim hâŋgânyongomune arinomai. Ari lohimbi nâhât den pat âlepŋe ekyongoŋetâ nâŋgâŋetâ bulâŋe otmu manman kârikŋan mannomai. Yakât otmâ yeŋe wuân me wongât nâŋgâm nâhât wâtnan kinmâ Awoŋne ulitgunomai yamâ âlepŋe nâŋgâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yakât den emelâk yan ya yâhâpŋe sâmune nâŋgâŋet. Yeŋe biwiyeŋaŋe kepeiakmâ konohâk otmâ buku oraŋgim mannomai. ");
INSERT INTO spl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Lohimbi belângen manmaiŋe kasa otyiŋginomai yanâmâ ki pârâk pilânomai. Kândikum emelâk nâ kasa otnihiwi yawuâk yeŋgât kasa otyiŋginomai. ");
INSERT INTO spl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yâhâ orotmeme bâleŋe otmâ mansai ya yeŋgâlen torokatmâ yawuâk otmai mâne buku otyiŋgimbâi. Yawu gârâmâ yenâmâ emelâk nâŋe nine pat kuyiŋgim meyekmune nâhâlen torokatbi. Yawu torokatbi yakât otmâ lohimbi yaŋe yeŋgât hâkâŋ otmâ mem ge katyekne sâm otmai. ");
INSERT INTO spl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nâŋe emelâk den yuwu ekyongowan ya biwiyeŋan katmâ nâŋgânomai. Lohimbiŋe lok kunŋe otmu yakât hoŋ bawalipŋe yamâ kapam dop konohâk yongom hâhiwin yiŋginomai. Yawu gârâmâ nâ mem âlâlâ tuhunekmâ hâhiwin nihim mansai yakât dopŋeâk yen yawuâk mem âlâlâ tuhuyeknomai. Yâhâ lohimbi nombotŋaŋe nâ buku otnihim denne nâŋgâmai mâne yen gurâ yawuâk lohimbi nombotŋaŋe buku otyiŋgim denyeŋe nâŋgâmbâi. ");
INSERT INTO spl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lohimbi belângen mansaiŋe Awoŋnaŋe hâŋgânnohomu gewan yâkât topŋe ki naŋgai. Topŋe ki naŋgai yakât otmâ yen gurâ kasa otyiŋgim mem âlâlâ tuhuyeknomai. ");
INSERT INTO spl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yawu gârâmâ nâŋe hânân yu ki ge Awoŋnahât topŋe ekyongowan mâne yâkŋe betnihimbâi yakât tosa ki membâi. Yamâ tosa miai yakât âlâ me âlâhâlen gâitmâ tâwâeyeknomaihât dop âlâ ki otbuap. ");
INSERT INTO spl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yawu gârâmâ lohimbi âlâ me âlâŋe nâhât hâkâŋ otmâ betnihim manmai yaŋe nâ otnihiain sâm Awoŋne otbaŋgimai. ");
INSERT INTO spl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yakât torokatmâ sâwe. Nâŋe hohetyeŋan manmâ kulem topŋe topŋe ki orotŋe ya mewan mâne ki ekŋetâ tâŋât otmu tosa membâi. Yawu gârâmâ kulem meman ya ekmai yamâ Awoŋnâit betnitgim mansai. ");
INSERT INTO spl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yawu gârâmâ yeŋgât miti pepaen den âlâ tap yakât bonŋe teteâkgât yawu oai. Den ya yuwu tap. “Lokŋe imbiâk kasa otnihiai.” Den yawu tap. ");
INSERT INTO spl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nâmâ hâmbâi Awoŋne ekumune ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu gewuap. Ge lohimbi biwiyeŋan kioŋmu nâhât den pat âlepŋe nâŋgâŋetâ bulâŋe otbuap. ");
INSERT INTO spl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Otmu yenâmâ nâ orowâk manmâ âi topŋe katmâ gain yakât mem heweweŋ tuhuyekmu nâhât den pat âlepŋe sâm haŋ tuhunomai.” ");
INSERT INTO spl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesuŋe den âlâ yuwu sâm eknongop. “Lohimbi belângen manmaiŋe mem âlâlâ tuhuyekmâ hâhiwin yiŋginomai yanâmâ ekmâ ki pârâk pilâm betnihim biwiyeŋe âlâhâlen katmaihât den yu ekyongoan. ");
INSERT INTO spl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yakât torokatmâ sâwe. Lohimbiŋe yeŋgât hâkâŋ otmâ miti emetŋambâ kewilâyekŋetâ ge yaehen mannomai. Yâhâ hâmbâi mâne belângen mannomai yaŋe Anitâhât sâtgât oain sâm yongoŋetâ munomai. ");
INSERT INTO spl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yamâ Awoŋ orop netgât topnetŋe ki nâŋgâm heŋgeŋgum mem âlâlâ tuhuyeknomai. ");
INSERT INTO spl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yâhâ emelâk yakât ki ekyongowan. Yawu gârâmâ pilâyekmâ ariwoman yakât emet inânŋan den yu ekyongoan. Arimune yeŋiâk tatŋetâ mem âlâlâ tuhuyeknomai yanâmâ den ekyongoan yu nâŋgâm mannomai. ");
INSERT INTO spl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nâmâ hâŋgânnohomu gewan yâkâlen purik sâm âwurem yâhâwom. Yawu gârâmâ yeŋgâlen gâtŋe âlâ me âlâŋe nâhât topŋe girawuhât yâhâwuat sâm ki âinohomai. ");
INSERT INTO spl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nâŋe katyekmâ yâhâwom sâmune nâŋgâŋetâ biwiyeŋe umatŋe oap. ");
INSERT INTO spl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bukulipne, bulâŋanâk sâmune nâŋgâŋet. Nâŋe ki pilâyekmâ âwurem yâhâwom mâneâmâ Anitâhât Wâtgât mâmâŋahât Heakŋe ki ge mâmâŋe otyiŋgiwuap. Yawu gârâmâ pilâyekmâ âwurem yâhâwom yanâmâ hâŋgângumune ge mâmâŋe otyiŋgim biwi sânduhân katyekbuap. ");
INSERT INTO spl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","9","Gem yan lohimbiŋe nâhâlen biwiyeŋaŋe ki kepeim tosa otmai ya eŋgatyeŋan gemu nâŋgâŋetâ keterakyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Otmu Anitâŋe lohimbi yekmu ârândâŋ olâkgât âi sâm nihiop ya tuhum tiŋ pilâm katyekmâ âwurem yâhâwom yakât topŋe gurâ nâŋgâm heŋgeŋgunomai. ");
INSERT INTO spl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Otmu Anitâŋe manman bâleŋahât amboŋe sâm hârewaŋgim mem ge kalop yakât nâŋgâŋetâ keterakbuap. Yawu nâŋgâm heŋgeŋgum nâhâlen biwiyeŋaŋe kepeim mannomai. ");
INSERT INTO spl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nâŋe sâp yiwereŋe den umatŋe topŋe topŋe tap ya kâsikum yiŋgimbâm. Yamâ yiwereŋe yakât topŋe nâŋgânomaihât dop bia. ");
INSERT INTO spl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Hâmbâi mâne Anitâŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge den bulâŋe ekyongomu nâŋgânomai. Yawu otmu yâkât topŋe nâŋgâm heŋgeŋgunomai. Yâkŋeâmâ ikŋe eŋgatŋeâk ki watmâ ekyongowuap. Anitâhât den ya konohâk ekyongom mâmâŋe otyiŋgimu yu me ya tetewuap ya ekmâ topŋe nâŋgâm heŋgeŋgunomai. ");
INSERT INTO spl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yâhâ lohimbi nine pat mannomai ya yeŋgât biwi nâŋgân nâŋgânyeŋe mem kusânyiŋgimu nâhât topne nâŋgâŋetâ keterakyiŋgiwuap. Nâŋgâŋetâ keterakyiŋgimu nâhât nâŋgâŋetâ yahatmu mepaeneknomai. ");
INSERT INTO spl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Otmu den bulâŋe Awoŋnahât nâŋgân nâŋgânŋan tap ya eknohomap. Yawu eknohomu yaŋak nâku yawuâk Wâtgât mâmâŋahât Heak ekumune topŋe sâm tetem ekyongowuap. ");
INSERT INTO spl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nâ yen orop sâp kâlep ki mannom. Pilâyekmâ yâhâwom. Manmâ sâp kâlep ki otmuâk âwurem gewom.” ");
INSERT INTO spl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesuŋe yawu sâm eknongomu nâŋgâm pâpguwin. Nâŋgâm pâpgum nenŋahâk yuwu sâm alahu gulahu otbin. “Yamâ girawuhât yawu yap. “Nâ pilâyekmâ Awoŋnahâlen yâhâmune ki neknomai.” Otmu “pilâyekbom ya kâlep ki otmuâk âwurem gemune neknomai.” yawu yap. ");
INSERT INTO spl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yawu yap yamâ topŋe girawuhât otmâ yap?” sâm yakât topŋe pâpgum alahu gulahu otbin. ");
INSERT INTO spl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yawu sâm alahu gulahu otmâ yakât Yesu âikune sâm otbin. Yawu nâŋgâmunŋe biwinenŋe ekmâmâ yuwu sâm eknongop. “ “Nâŋe pilâyekmâ yâhâwom gârâmâ sâp kâlep ki otmuâk âwurem gewom,” yawu ekyongomune nâŋgâm biwi yâhâp otmâ topŋahât âinohone sâm oai. ");
INSERT INTO spl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yakât yuwu sâm ekyongomune nâŋgâŋet. Nâŋe pilâyekmâ ariwom yan nâhât isem eŋgat hako nâŋgânomai. Eŋgat hako nâŋgânomai yanâmâ lohimbi belângen mansaiŋe kândâtyeŋe kuwiknomai. Otmu yeŋgât biwi nâŋgân nâŋgânyeŋe umatŋe otbuap yamâ sâp kâlep ki otbuap. Yakât kakŋanâmâ âlâkuâk heroŋe pato nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Den yukât topŋe nâŋgâŋetâ keterahâkgât den âlâen hâum sâmune nâŋgâŋet. Imbilipnenŋaŋe naom mene sâm hâliliakmâ tatmâ memai. Otmu naom ya kioŋmu yan hâkyeŋe sânduk sâmu heroŋe pato nâŋgâm yakât kakŋan hâhiwin nâŋgâmai ya nelâmyongomap. ");
INSERT INTO spl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Yakât dopŋeâk nâŋe pilâyekmâ arimune eŋgat hako nâŋgânihinomai. Otmu sâp kâlep ki otmuâk âwurem gemune nekmâ tepyeŋe sânduk sâmu heroŋe pato nâŋgânomai. Heroŋe nâŋgâŋetâ lok âlâ me âlâŋe yâhâpŋe eŋgat hakoân ki katyeknomai. ");
INSERT INTO spl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Yâhâ sâp yan nine topne ki nâŋgâm pâpgunomai. Yakât otmâ âi pâi ki tuhuneknomai. Den bulâŋanâk sâmune nâŋgâŋet. Yeŋe biwiyeŋaŋe nâhâlen kepeim wuân me wongât nâŋgâm awoŋne ulitgunomai yamâ âlepŋe nâŋgâyiŋgiwuap. ");
INSERT INTO spl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yamâ emelâk âi topŋe katbin yapâek yeŋe wuân me wuângât awoŋne ki ulitgum gaŋetâ yu oap. Yâhâ sâp yiwereŋe yupâek âlepŋe nâhâlen biwiyeŋaŋe kepeim awoŋne ulitgum manŋetâ nâŋgâyiŋgimu heroŋe kakŋan manmâ yâhânomai. ");
INSERT INTO spl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nâŋe yu me yakât den âlâen hâum ekyongoman. Gâmâlâhâmâ awoŋnahât topŋe ya nâŋgâŋetâ keterakbuapgât tâŋ tâŋâk ekyongowom. ");
INSERT INTO spl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sâp yanâmâ nâhâlen biwiyeŋaŋe kepeim awoŋne tâŋ tâŋâk ulitgunomai. Yakât otmâmâ nâŋe yeŋgât kaweyeŋan kinmâ hilâm ârândâŋ ki ulitguwom. ");
INSERT INTO spl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nâmâ âi topŋe ki katmâek awoŋne orop embâŋâmbâek tatmâ gam yaŋak pilâm hânân yuân gewan ya nâŋgâŋetâ bulâŋe otmu biwiyeŋaŋe nâhâlen kepeim mansai. Yawu mansai yakât Awoŋnaŋe wawaeyekmâ tihityeŋe otmap. ");
INSERT INTO spl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bulâŋanâk nâ Awoŋnahâlembâ gewan. Yakât otmâ âi tuhum pesuk pilâm âwurem yâhâwe sâm oan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesuŋe yawu sâmu yuwu sâm ekuwin. “Yiwereŋeâk eksain. Gâŋe den tâŋ tâŋâk eknongorâ yakât topŋe tetemu nâŋgâmunŋe âlepŋe oap. ");
INSERT INTO spl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gâŋe biwinenŋe kerek ekmâ nâŋgâmat. Yawu gârâmâ biwinenŋan tap yakât ki hâum pâpgumat. Yakât otmâ Anitâŋe hâŋgângohomu ge mansat yakât nâŋgâmunŋe bulâŋe oap.” Yawu sâwin. ");
INSERT INTO spl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Sâmunŋe sâop. “Âlepŋe nâhât topne yiwereŋe nâŋgâm biwiyeŋaŋe nâhâlen tiŋâk kepeim mansai. ");
INSERT INTO spl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yawu gârâmâ sâp kâlep ki otmuâk kiŋgityeŋahât otmâ pilânekmâ tiok taok otmâ âlâhu kapiŋan kapiŋan arinomai. Ariŋetâ nâmâ niniâk ki tatbom. Awoŋne orowâk tatdom. ");
INSERT INTO spl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yawu gârâmâ yuwu sâmune nâŋgâŋet. Yeŋe nâhâlen torokatŋetâ biwi nâŋgân nâŋgânnenŋaŋe kepeiakmâ konohâk otmu biwi sânduhân mannomaihât den yu ekyongoan. Yeŋe yawu manŋetâ lohimbi belângen manmaiŋe mem âlâlâ tuhuyeknomai yanâmâ ki lohotŋe otnomai. Yamâ nâŋe emelâk manman bâleŋahât amboŋe mem ge katmâ kunyeŋe pato mansan ya nâŋgâm mannomai.” ");
INSERT INTO spl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuŋe den yawu sâm eknongom senŋe pak sâm himbimân ekmâ âwâŋe yuwu sâm ekuop. “Awoŋ, lohimbiŋe nekŋetâ yahatmu mepaeneknomaihât sâp tâlâhuap. Yawu gârâmâ gâŋe mâmâŋe otnihirâ tem lâuhihim mansan. Yakât otmâ lohimbi kerek wawaeyekmâ tihityeŋe otbe sâm oat yakât bulâŋe ekmâ mepaehekmâ mannomai. ");
INSERT INTO spl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Emelâk “Lohimbi kerek yeŋgât kunyeŋe otmâ manbuat” sâm âi nihion. Yakât otmâ emelâk lohimbi yeŋgât manman kârikŋahât pat kuyiŋgion yamâ biwiyeŋe mem heweweŋ tuhurâ nâhâlen torokatnomai yamâ yakât bulâŋe yiŋgiwom. ");
INSERT INTO spl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yâhâ manman kârikŋahât topŋe yuwu. Gâ konok Anitâ bulâŋe tatmâ gamat. Otmu gâŋe tihityeŋe otbe sâm nâ hâŋgânnohorâ gewan. Ya lohimbiŋe nâŋgâŋetâ bulâŋe otmu netgâlen biwiyeŋaŋe kepeim mannomai yamâ manman kârikŋe yiŋgimune menomai. ");
INSERT INTO spl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gâŋe âi sâm nihim hâŋgânnohorâ gewan ya tuhum pesuk pilâwom yanâmâ lohimbi kiŋgitŋe orowâkŋe ekmâ mepaeheknomai. ");
INSERT INTO spl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Awoŋ, embâŋân hân himbim ki kândikyotgon yan biwinetŋe konohâk otmâ orowâk tatmâ gawit. Yawu gârâmâ himbim pilâm hân yuân ge mansan. Yakât otmâ sâp yiwereŋe yuâmâ gâhâlen âwurem gamune emelâk orowâk tatmâ gawit yawuâk orowâk tatmâ yâhârom. ");
INSERT INTO spl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Awoŋ, aŋgoân lok kâiân konok yu lok bâleŋe yeŋgâlembâ meyehon. Meyekdâ nâhâlen torokatŋetâ gâhât topge sâm tetem ekyongoman. Ekyongom gamune yan nâhât tem lâum manmai. ");
INSERT INTO spl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Gâŋe den eknohon yamâ kerehâk sâm tetem ekyongomune nâŋgâŋetâ bulâŋe otmap. Otmu gâŋe hâŋgânnohorâ gewan ya gurâ yawuâk nâŋgâŋetâ bulâŋe otmap. ");
INSERT INTO spl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","10","Yawu nâŋgâm nâhât âi torokatmâ tuhum tiŋ pilâm net orop mannomgât mâmâŋe otyiŋgihât naŋgan. Mâmâŋe otyiŋgirâ nâhât wâtnan kinmâ den pat âlepŋe ekyongoŋetâ lohimbi kiŋgitŋe orowâkŋe nâŋgâm mepaenekmâ mannomai. Yawu otmâ ya yeŋgât nâŋgâm ekgohoan. Yâhâ lohimbi belângen manmai ya yeŋgât ki ekgohoan. ");
INSERT INTO spl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","O, Anitâ Awoŋne. Topge ikŋiâk tap. Tat tatge âlâ kândâkdâ tatmâ gaonŋak tatmâ gamat. Otmu tatmâ yâhâwuat. Yiwereŋeâmâ hoŋ bawalipne pilâyekmâ gâhâlen âwurem gawom. Yawu gârâmâ nâhât hoŋ bawalipne yuŋe yuân torokatmâ lok bâleŋe yeŋgât hohetyeŋan mannomai yamâ gâŋe mâmâŋe otyiŋgim tihityeŋe otbuat. Mâmâŋe otyiŋgirâ netŋe biwinetŋaŋe konohâk otmap yakât dopŋeâk lok yuŋe biwi konok otmâ mannomai. ");
INSERT INTO spl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yawu gârâmâ hoŋ bawalipne yu orowâk manmâ gain yuŋe pilânekmâ ari hiliwahomaihât mâmâŋe otyiŋgim gaman. Yâhâ gâŋe mâmâŋe otnihimat yawuâk mâmâŋe otyiŋgiman. Otmu miti pepaen den âlâ tap yakât bulâŋe teteâkgât bukuyeŋe âlâ osetyeŋan gâtŋe âlâŋe pilânenekmâ arap. Yâhâmâ hem nâpumân ge hiliwahowuapgât pat mansap. ");
INSERT INTO spl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yâhâ nâ gâhâlen gawoman. Yakât otmâ âi sâm nihion ya memune heroŋe nâŋgânihimat yakât dopŋeâk hoŋ bawalipnaŋe nâhât âi torokatmâ tuhunomai yan heroŋe nâŋgâyiŋgiwom. Yakât topŋe nâŋgâm heroŋe kakŋan mannomaihât nâŋe senyeŋan kinmâ den ekgohoan yu naŋgai. ");
INSERT INTO spl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yâhâ emelâk nâmâ himbimâmbâ ge gâhât den kâsikum yiŋgimune nâŋgâŋetâ bulâŋe otmu orotmemeyeŋe bâleŋe bet pilâm nâhâlen torokatmâ himbimgât pat oai. Yakât otmâ lok bâleŋaŋe ya yeŋgât nâŋgâm hâkâŋ otmai. ");
INSERT INTO spl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","16","Yâhâ nâhâlen torokatmâ himbimgât pat mansai. Yakât otmâ gâŋe mem dâiyekdâ pilâm gâhâlen yâhâŋetgât ki naŋgan. Yawu gârâmâ Bâleŋahât Amboŋaŋe mem hilipyongomapgât mâmâŋe otyiŋgihât naŋgan. ");
INSERT INTO spl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mâmâŋe otyiŋgirâ orotmeme bâleŋambâ keterakmâ gâhât den bulâŋe lâum manmâ yâhânomai. ");
INSERT INTO spl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","19","Gâŋe aŋgoânâk âi sâm nihim hâŋgânnohorâ ge tem lâuhihim gâhât den pat âlepŋe ekyongom gan. Yakât dopŋeâk nâku âi sâm yiŋgim hâŋgânyongomune ari lohimbi den pat âlepŋe yakât ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Awoŋ, sâp yiwereŋe yuâmâ nâhâlen torokatmâ mansai ya yeŋgâlâk ki sâm ulitgohoan. Hâmbâi lohimbi dondâŋe nâhât den pat âlepŋe nâŋgâŋetâ bulâŋe otmu biwiyeŋe nâhâlen katnomai ya yeŋgât ulitgohomune nâŋgâ. ");
INSERT INTO spl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Awoŋ, gâ orop biwi nâŋgân nâŋgânnetŋaŋe kepeiakmâ konohâk oait. Yakât dopŋeâk lohimbi yaŋe netgâlen biwiyeŋaŋe kepeim konohâk otmâ mannomaihât naŋgan. Yâhâ biwi konohâk otmâ mannomai yanâmâ lohimbi belângen mansaiŋe manmanyeŋe ekmâ yuwu nâŋgânomai. “Anitâŋe Yesu hâŋgângumu ge mâmâŋe otyiŋgimu yaŋak biwi konok otmâ buku oraŋgimai.” ");
INSERT INTO spl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","Otmu gâŋe hâŋgânnohom mâmâŋe otnihirâ ge hohetyeŋan manmune biwinetŋe konohâk otmait yakât topŋe nâŋgâm heŋgeŋguai. Yakât dopŋeâk nâŋe hâŋgânyongom mâmâŋe otyiŋgimune nâ orop biwiyeŋe konohâk otmâ mannomai. Yawu mannomai yanâmâ lohimbi hânŋan kulemŋan mansaiŋe gâŋe wawaenekmat yawuâk wawaeyekmâ tihityeŋe otbe sâm nâ hâŋgânnohorâ gewan yakât topŋe nâŋgâm heŋgeŋgunomaihât ulitgohoan. ");
INSERT INTO spl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Awoŋ, lohimbiŋe biwiyeŋe nâhâlen katmai yamâ nâ orowâk himbimân tatnom yakât emelâk pat kuyiŋgion. Otmu gâŋe embâŋân hân himbim ki kândikyotgon yan biwihaŋe kepeinekmâ gâ orowâk himbimân tatbisâit yakât sâm nihion. Yakât otmâ pat kuyiŋgion yakât bulâŋe tetemu himbimân net orowâk tatmâ mepaeneleknomaihât ulitgohoan. ");
INSERT INTO spl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","26","Awoŋ, lohimbi belângen mansaiŋe gâhât topge ki naŋgai. Yawu gârâmâ nâŋeâmâ gâhât topge nâŋgâm lok yuŋe nâhâlen biwiyeŋe katmâ mansai ya ekyongomune tipiŋe nâŋgâŋetâ keteraksap. Yakât otmâ gâŋe wawaenekmâ hâŋgânnohorâ gewan ya nâŋgâm heŋgeŋguai. Yâhâ nâŋe kulem membom yan gâŋe wawaeyekmat yakât topŋe nâŋgâm heŋgeŋgunomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuŋe yawu sâm âwâŋe ekumu pesuk sâmu hoŋ bawalipŋe nen menenekmu ba to tipiŋe âlâ, kutŋe Kitoron sâm, ya hâtikguwin. Ya hâtikum nak âlâ, kutŋe Oliwa, ya kambatŋe kâmetbi yan yâhâwin. ");
INSERT INTO spl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yâhâ emelâk manmâ gawin yan Yesuŋe menenekmu yan yâhâ tatmâ nâŋgâminiwin. Yakât otmâ Yurasi kapi ya nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yakât otmâ Yurasiŋe betŋehen kioŋmâ Parisaio otmu hotom uminiwi ya yeŋgât sâtgât otmâ tembe lâulipyeŋe dâiyekmu unam, tewet, kapamgât senŋe âlâlâ miakmâ balam saum nengâlen tohowi. ");
INSERT INTO spl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Toho mem tetenenekŋetâ umatŋe yu Yesu kakŋan yâhâwuap ya emelâk nâŋgâop yakât otmâ katnenekmâ gotyeŋan ba yuwu sâm âiyongop. “Yen âlâhât pâinsai?” sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","Sâmu sâwi. “Nenâmâ lok âlâ, kutŋe Yesu, yamâ Nasaret kapi amboŋe yâkât pâinsain,” sâwi. Sâŋetâ sâop. “Lok yamâ nâ yu.” Sâmu Yurasi otmu orowâk takawiŋe denŋe nâŋgâm pârâk pilâm umutyeŋe arimu hânân ge pare iwi. ");
INSERT INTO spl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yawu otmâ yâhâpŋe âiyongom sâop. “Yen âlâhât pâinsai?” Sâmu yahatmâ kinmâ sâwi. “Lok âlâ, kutŋe Yesu, yamâ Nasaret kapi amboŋe,” sâwi. ");
INSERT INTO spl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Sâŋetâ sâop. “Nâ emelâk ekyongoan. Lok yamâ nâ yu. Nâ pâinneksai yakât otmâ hoŋ bawalipne yu pilâyekŋetâ yahatmâ ariŋetgât naŋgan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yawu sâm yan den emelâk yuwu sâop yakât bulâŋe teteop. “Awoŋ, gâŋe lok yu mâmâŋe otyiŋgirâ nâhâlen biwiyeŋaŋe kepeim mansai yu yeŋgât tihityeŋe otmune âlâ ki hiliwahoap.” ");
INSERT INTO spl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yawu sâmu Petoroŋe tewetŋe mem yahatmâ hotom um manbi ya yeŋgât kunyeŋe manop yâkât hoŋ bawaŋe, kutŋe Maiko sâm, yamâ ândâpŋe nombot ya topŋambâek kârâm hâreop. ");
INSERT INTO spl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kârâm hâremu Yesuŋe ekmu bâlemu yuwu sâm ekuop. “Yawu otdâ bâleap. Umatŋe yu tetenihimu sâtgum mumbomgât Awoŋnaŋe mâtâp sâm nihiop ya ki watbomgât naŋgat hâ? Âlâŋe yakât ki ekgohop?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","Yesuŋe yawu sâm ekumu Roma tembe lâu ya yeŋgât kunyeŋaŋe sâmu tembe lâulipŋe otmu Parisaio yeŋgât tembe lâulipyeŋaŋe Yesu mem bâtŋe sâhâm menduhuwi. Yawu tuhum mem lok sombo âlâ, kutŋe Anasi sâm, yâkât emelan yâhâwi. Anasi yamâ lok âlâ, kutŋe Kaipa sâm, yâkât lamatŋe. Yâhâ Kaipa yamâ hombaŋ yakât hotom uminiwi ya yeŋgât kunyeŋe pato manop. ");
INSERT INTO spl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yawu gârâmâ Kaipaŋeâmâ nen Yura lohimbi kerekŋe hiliwahomaingât Yesu konok mumbuapgât nâŋgâm papatolipnenŋe ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yâhâ Yesu mem Anasihât emelan yâhâŋetâ Petoro otmu bukunenŋe âlâŋeâmâ Yesu watmâ ariowot. Yâhâ Anasiŋeâmâ bukunenŋe ya nâŋgâwaŋgimap. Yakât otmâmâ Yesu mem emelan yâhâŋetâ yawuâk watyekmâ betyeŋan yâhâop. ");
INSERT INTO spl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yawu otmâmâ Petoroŋeâmâ emet hawiŋan peke yakât hâŋgi hâlâŋmâ kinop. Yawu gârâmâ bukuŋe Anasihât emelambâ ge hoŋ bawa imbi âlâŋe hâŋgi galemgum kinop ya ekumu hâŋgi hindâmu yanâk Petoro gurâ kâlehen yâhâop. ");
INSERT INTO spl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kâlehen yâhâmu imbi yaŋe ekmâ sâop. “Âo gâmâ Yesu hoŋ bawaŋgim manmat. Yawu geksan.” Sâmu sâop. “Yu yat yamâ imbiâk yat,” sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Otmu sâp yanâmâ bâlâpŋe bâleŋe olop. Yakât otmâ tembe lâu nombotŋaŋe kâlâp uŋetâ semu hoŋ bawa nombotŋe orowâk menduhuakmâ kâlâp nâŋgâm kinbi. Kâlâp nâŋgâm kinŋetâ Petoroŋe hohetyeŋan ga kinmâ kâlâp nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yesuŋe nen hoŋ bawalipŋe menenekmâ den kâsikum ningiminiop. Otmu otbin mewin yakât topŋe hotom uminiwi ya yeŋgât kunyeŋaŋe nâŋgâwe sâm âikuop. ");
INSERT INTO spl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","21","Âikumu sâop. “Wongât âinohoat? Kapi ambolipŋe orop miti emetŋan me opon kâmbukŋan yâhâ menduhuakŋetâ den kâsikum yiŋgim gaman. Otmu kapi tipi tapi tatmâ arap, me wosapâ me wosapâ kapi ambolipŋaŋe menduhuakmai yan lok senyeŋanâk kinmâ den ekyongom gaman. Nâmâ tik tik ki ekyongoman. Yakât otmâ nâ ekyongomune nâŋgâmai ya âiyongorâ yâkŋe sânomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yawu sâmu tembe lâu âlâŋe yahatmâ Yesu ândâpŋe huhum yuwu sâm ekuop. “Gâmâ girawu otmâ hotom umai yeŋgât kunyeŋe ya nekamŋan yat?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Sâmu sâop. “Nâ den bâleŋe yan otmuâmâ yakât topŋe sârâ nâŋgâwe. Nâmâ den âlepŋe yan. Yamâ girawuhât ândâpne huhuat?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Benŋe, Anasiŋe sâmu Yesu bâtŋe sâhâm menduhuwi ya ki holaŋmâek mem lamatŋe, kutŋe Kaipa sâm, yâkâlen dâim ariwi. ");
INSERT INTO spl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Yâhâ Petoro yamâ yawuâk kâlâp nâŋgâm kinop. Nâŋgâm kinmu lohimbi orowâk kinbiŋe towatŋe ekmâ nâŋgâmâmâ yuwu sâm ekuwi. “Gâ gurâ Yesu orowâk manmat, yawu geksain.” Yawu sâŋetâ topŋe kurihiakmâ “Nâ bia,” sâm irelahop. ");
INSERT INTO spl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sâmu hotom umai ya yeŋgât kunyeŋahât hoŋ bawa âlâhât ândâpŋe Petoroŋe kârâm hâreop yakât hep torehenŋe âlâ orowâk kinbiŋe Petoro ekmâ yuwu sâop. “Bulâŋanâk Yesu miai yan gâ orowâk kinŋetâ yeksan.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yawu sâmu “nâ bia” sâm irelahop. Irelakmu yanâk gokorok isiop. ");
INSERT INTO spl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Otmu Yesu mem Kaipahât emelan ariŋetâ yan mumbuapgât den sâm hârewaŋgiwi. Otmu emet haŋ sâmu emelambâ mem ge Roma lok yeŋgât kiap âlâ, kutŋe Pilato sâm, yâkât emelan ariwi. Yawu gârâmâ Tihit tihit hombaŋ yan lama gâim um neminiwi sâp yan lohimbiŋe aŋgoân pâku lohimbi yeŋgât emetyeŋan yâhâmai sâm samut katbi. Yakât otmâ Yesu mem ari Pilatohât emet umbiŋan kinbi. ");
INSERT INTO spl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Emet umbiŋan kinŋetâ Pilatoŋe emelambâ ge yuwu sâm âiyongop. “Lok yuâmâ wongât nâhâlen mem takai?” ");
INSERT INTO spl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Âiyongomu sâwi. “Lok yuŋe otmu bâleap. Yâhâ ki otmu bâleap mâne wongât yuwu mem takambâin.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sâŋetâ sâop. “Yeŋe girawu otbaŋginom naŋgai ya âlepŋe yeŋe girem den watmâ otbaŋgiŋet.” Yawu sâop. Sâmu sâwi. “Emelâk mumbuapgât den sâm hârewaŋgiain. Yawu gârâmâ nenŋe lok âlâ kumunŋe mumbuapgât mâtâp maŋguningiwi. Yawuhât otmâ gâŋe konok sâm hârewaŋgirâ mumbuapgât gâhâlen mem takain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yâhâ aŋgoânâmâ Yesuŋe “Nohom howanân kânâŋgâneknomai,” sâop yakât bonŋe teteâkgât Yura nengât kunlipnenŋaŋe Yesu mem Pilatohâlen ariwi. ");
INSERT INTO spl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bâiŋ, yawu sâŋetâ Pilatoŋe purik sâm emetŋan yâhâ Yesuhât sâmu mem gaŋetâ yuwu sâm âikuop. “Yura yeŋgât lok kutdâ sâmai ya gâ me?” ");
INSERT INTO spl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sâmu sâop. “Gike eŋgatgeâk otmâ yat me lok âlâŋe ekgohomu nâŋgâm yat?” ");
INSERT INTO spl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Sâmu sâop. “Nâmâ Roma gâtŋe. Nâŋe Yura yeŋgât topyeŋe ki nâŋgâman. Gâŋe girawu olongât papatolipgaŋe meŋgekmâ nâhâlen takai?” ");
INSERT INTO spl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Sâmu sâop. “Nâmâ lohimbi yu yeŋgât lok kutdâ ki manbe sâm oan. Yâhâ nâŋe yâk yeŋgât lok kutdâ manbe sâm oan mâne papatolipnenŋaŋe menekmai sâm nine hoŋ bawalipnaŋe yahatmâ tânnohom kapam kumbâi. Nâmâ yuân mansai yeŋgât kutdâyeŋe mansan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sâmu sâop. “Gâ bulâŋanâk lok kutdâ mansat?” Sâmu sâop. “Yu yat yakâ. Nâmâ den bulâŋe yakât topŋe ekyongowehât hân yuân gewan. Yakât otmâ lohimbiŋe den bulâŋe nâŋgâne sâm otmai yaŋe nâhâlen torokatmâ mansai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Sâmu sâop. “Wuân den bonŋe ondop âlâ tap yakât yat? Yamâ ki tap.” (Mataio 27:15-31 Mareko 15:6-20 Luka 23:13-25) Yawu sâm benŋe emet umbiŋan gem Yura nengât papatolipnenŋe yuwu sâm ekyongop. “Lok yukât tosa ki eksan. ");
INSERT INTO spl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yawu gârâmâ Tihit tihit hombaŋ ârândâŋ pâi emetŋan lok tatminiwi yapâ gâtŋe âlâ kapi ambolipŋaŋe sâŋetâ holaŋyekmune geminiwi. Yakât otmâ Tihit tihit hombaŋ yuân lok kutdâ yu sâmune holaŋetâ ge manâkgât naŋgai me bia? Me lok âlâ sâmune holaŋetâ gewuap?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yawu sâmu yahatmâ halahum yuwu sâwi. “Yawu bia. Barawa ya pâi emetŋambâ holaŋdâ giâk.” Yawu sâwi. Yawu gârâmâ Barawahât topŋeâmâ yuwu. Yâhâmâ lok yongomu yakât otmâmâ pâi emetŋan katŋetâ talop. ");
INSERT INTO spl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yawu sâŋetâ Pilatoŋe ikŋe tembe lâulipŋe ekyongomu Yesu mem tâk âlâ sâtŋe metŋe yaŋe kândâtŋan lawitmâ hâkŋe orowâk mem gahaewi. ");
INSERT INTO spl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lawitmâ tâk âlâ, sâtŋe metŋe, kon pan pan me hatman yawuya yaŋe mem kunŋan pâŋ pâŋ kepeiwaŋgiwi. Yawu otmâ sâŋgum kuriŋ pâwâwâŋ yamâ lok kutdâŋe katmâ manminiwi yawuya ya mem latbaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Yawu otmâ senŋan gem yuwu sâm ekuwi. “Bâe. Yura yeŋgât lok kutdâ pato. Gâŋe torokatmâ kinmâ yâhâwuatgât naŋgain.” Yawu sâm ândâpŋe huhuwi. ");
INSERT INTO spl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yawu otbaŋgiŋetâ sâtgum kinmu benŋe Pilatoŋe emet umbiŋan ge yuwu sâm lohimbi ya ekyongop. “Yeŋgât lok kutdâ yukâlen tosa âlâ ki eksan. Yakât otmâ sâmune mem geŋetâ yeŋe senyeŋaŋe ekŋet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yawu sâmu Yesu tâk sâtŋe metŋe ya kunŋan kepeiwaŋgiwi otmu sâŋgum kuriŋ latbaŋgiwi ya yawuâk tatmu mem geŋetâ yuwu sâm ekyongop. “Yeŋgât lok kutdâ yu holaŋmune giâkgât naŋgan.” Yawu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yawu sâm ekyongomu hotom uminiwi ya yeŋgât kunlipyeŋe otmu tembe lâulipyeŋaŋe Yesu ekmâ kârikŋan halahuwi. “Howanân kuŋetâ muâk,” sâm yawuâk yawuâk sâwi. Sâŋetâ sâop. “Ki otmu bâleap yakât tosa âlâ yâkâlen ki eksan. Yawu gârâmâ naŋgai ya yeŋahâk mem ari howanân kunomai.” ");
INSERT INTO spl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sâmu sâwi. “Lok yuŋe “Nâ Anitâhât nanŋe mansan,” sâop. Yawu sâop yaŋe nengât girem den loŋgâeop. Yakât matŋe muâkgât sâm hârewaŋgiain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Yawu sâŋetâ nâŋgâm kiŋgitŋahât dondâ otmâ purik sâm Yesu mem emet kâlehen yâhâop. ");
INSERT INTO spl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yâhâ yuwu sâm âikuop. “Gâ wonân gâtŋe?” Sâmu den olotoŋâk kinop. ");
INSERT INTO spl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yawu kinmu sâop. “Wongât olotoŋâk kinsat? Holaŋgekŋetâ ge manbuat me howanân gohoŋetâ mumbuat yamâ nâhât sâlâk watnomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sâmu sâop. “Anitâŋe papatolipge ya biwiyeŋan kioŋmu galem sâm katgekbi. Yakât otmâ lok kasa otnihim gâhâlen hâŋgânnohomu takan yaŋeâmâ tosa miat ya wangim tosa amokŋan miap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yawu sâmu Pilatoŋe holaŋmune ariâk sâm nâŋgâm ketet olop. Nâŋgâm ketet otmu hotom uminiwi yeŋgât kunlipyeŋaŋe tâtâemâk yuwu sâm ekuwi. Lok âlâ me âlâŋe “Nâ lok kutdâ pato mansan,” sâmapŋe gâhât patohe, kutŋe Sisa sâm, ya mem ge katbe sâm oap. Yesuŋe yawu oap ya eksain. Yakât otmâ gâŋe Yesu yu holaŋdâ ariwuap yanâmâ Sisa ki buku otbaŋgiwuat. Yakât otmâ umatŋe teteap yukât Sisa ekumunŋe sâm hârehihiwuap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Yawu sâŋetâ Yesu mem yaehen katmu kinmu ikŋeâmâ sâm hâre hâre kaweŋan yan ge talop. Yâhâ kawe yakât kutŋe yamâ Yura nengât denân “Gawata” yawu. Yâhâ yakât topŋeâmâ yuwu tap. “kawe konŋak tuhuwi” yawu. ");
INSERT INTO spl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yâhâ emetsenŋe purik sâwe sâm otmu yan Pilatoŋe kawe yan ge talop. Yâhâ emet omoŋ otmu yan Tihit tihit hombaŋ ya tetemu âi ki menomaihât sâwi. Yakât otmâ Pilatoŋe yuwu sâm ekyongop. “Ekŋet. Lok yuâmâ yeŋgât lok kutdâ.” ");
INSERT INTO spl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sâmu sâwi. “Lok yuŋe muâkgât naŋgain. Yakât otmâ howanân kuŋetâ muâk,” yawu sâwi. Sâŋetâ sâop. “Lok kutdâyeŋe yu howanân kuŋetâ muâkgât naŋgai hâ?” Sâmu hotom uminiwi ya yeŋgât kunlipyeŋaŋe yuwu sâwi. “Nengât lok kutdâ âlâ ki tap. Sisa konohâk mansap,” yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yawu sâŋetâ Pilatoŋe Yesu ya howanân kuŋetâ muâkgât sâm hâreop. Sâm hâremu dâim ariwi. ");
INSERT INTO spl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu ikŋahâk howanŋe ya lâuakmu ariwi. Otmu kapi pato ya pilâm gem hân âlâ, kutŋe yamâ Yura nengât denân Golihata sâm, yan gewi. Yâhâ kut yakât topŋeâmâ yuwu tap. “Lok Kunŋe Hahitŋe,” yawu. ");
INSERT INTO spl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","19","Yan mem ge howanân kuwi. Kuŋetâ Pilatoŋe den âlâ yuwu sâm howan kunŋan kulemguop. “Yesu, Nasaret kapi amboŋe, Yura yeŋgât lok kutdâ.” Yawu kulemguop. Yâhâ den kulemguop yamâ Yura nengât denân, Roma yeŋgât denân, Girik yeŋgât denân kulemguop. Yawu kulemgumu lâum kânâŋgâwi. Otmu sâp yanâk lok yâhâp yotgom lâum kânâŋgâyelekŋetâ nombot nombot kinowot. ");
INSERT INTO spl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yâhâ Yesu yamâ Yerusalem kapi pato yakât nombotgen kuwi. Yakât otmâ Yura lohimbi dondâ bam gawiŋe ekmâ sâlikuwi. ");
INSERT INTO spl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yâhâ hotom umai ya yeŋgât kunlipyeŋaŋe ya nâŋgâm Pilatohâlen ari yuwu sâm ekuwi. “ “Yura yeŋgât lok kutdâ,” yawu kulemgum katsat ya ekmunŋe ki ârândâŋ oap. Yawu gârâmâ ya gulipgum yuwu kulemgu. “Lok yuŋeâmâ “Nâmâ Yura yeŋgât lok kutdâ,” yawu sâmap.” Yawu kulemgu.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Sâŋetâ sâop. “Kulemguan ya pilâŋetâ yawuâk talâk.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Otmu tembe lâu Yesu mem howanân kuwiŋe yâkât senŋe âlâlâ mem kâsikuŋetâ komot imbât olop. Otmu âlâku konok konok aŋgim miakbi. Yâhâ sâŋgumŋe âlâ yamâ kâlep pato ya ewakembâ giop yamâ ki gâre gâreŋe. ");
INSERT INTO spl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yakât otmâmâ ekmâ yuwu sâwi. “Yu nenŋan gâtŋe konokŋe hâlulâek miakbuap yamâ âlepŋe,” sâwi. Yawu sâm pepa tipi tapi mem duhatmâ kutyeŋe ikŋiâk ikŋiâk kulemgum amaŋân mânuŋetâ ge talop. Mânuŋetâ tatmu mem gulip malap tuhuwi. Gulip malap tuhum pepa âlâ mewi yan lok kutŋe teteop yaŋe sâŋgum ya hâlulâek miop. Yawu otbi. Otbi yakât emelâk lok âlâŋe miti pepaen kulemguop yakât bulâŋe teteop yamâ yuwu. “Nâhât senŋe âlâlâ yamâ mem kâsikum aŋgim miaksai. Otmu sâŋgumne kâlep pato ya âlâhât kutŋe teteap yaŋe hâlulâek miaksap.” Yawu kulemguop yakât bulâŋe teteâkgât orotmeme yu otbi. ");
INSERT INTO spl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","26","Yesu howanân kuŋetâ kinop yakât gotŋan imbi imbât kinbi yamâ yuwu. Âlâmâ ikŋe mâmâŋe, âlâmâ mâmâŋahât gariŋe, âlâmâ Maria ya Kelopa apetŋe, otmu bâiŋeâmâ Maria, Matala kapiân gâtŋe yâk orowâk kinbi. Yâhâ nâmâ Yesu mâmâŋahât gotŋan kinban. Yawu kinmunŋe Yesuŋe mâmâŋe ekmâ tepŋe nâŋgâm yuwu sâm ekuop. “Meŋ, pilâyekboman. Gâmâ Yoane orop mandâ galemge otbuap.” ");
INSERT INTO spl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yawu sâm ekum yuwu sâm eknohop. “Buku, meŋnetŋe yuâmâ gâŋe galemguwuat,” sâm eknohop. Yawu sâmu yapâek nâhâlen torokatmu orowâk manmâ galemguwan. ");
INSERT INTO spl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Otmu sâp yan âwâŋaŋe Yesu âi sâm waŋop ya tuhum pesuk pilâop ya nâŋgâop. Nâŋgâm yan miti pepaen den âlâlâ kulemguwi yakât bulâŋe bunewâk teteâkgât kândâtŋe kuwihakmâ den kârikŋe halahum yuwu sâop. “Nâ tohât neksap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yawu sâmu kondo âlâ talop yan wain to yakât ukenŋe biatmu pâlâmŋe olop ya gâiŋetâ yan giop. Otmu yan kinbiŋe kereŋ wahapŋe mem keleân sâhâm menduhum wain kâlehen katŋetâ ge bârâtguop. Bârâtgumu mem yâhâ Yesu lauŋan katŋetâ niop. ");
INSERT INTO spl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nem yan “Âi sâm nihiop ya dopŋan oap.” sâop. Yawu sâm goselek sâm bâleop. ");
INSERT INTO spl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yâhâ emetsâpŋan bâlemu omoŋ otmu yan Tihit tihit hombaŋ pato ya tetewuawân howanân yawuâk kinmaihât hotom uminiwi yeŋgât kunlipyeŋaŋe ari Pilato yuwu sâm ekuwi. “Yura nengât Tihit tihit hombaŋ tetemu yan lok bâleŋe ya howanân kinŋetâ yekmunŋe bâlewuap. Yawu gârâmâ gâŋe tembe lâulipge ekyongorâ ari in yawu kâiyeŋe kum lotohoyekŋetâ munomai. Muŋetâ yanâmâ howanâmbâ mem kâpekyeknomai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yawu sâŋetâ tembe lâulipŋe hâŋgânyongomu ari lok yâhâp yawuâk kâiyetŋe kum lotohoyelekŋetâ muowot. ");
INSERT INTO spl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kâiyetŋe kum lotohoyelekmâ Yesuhâlen ba eksain mâne emelâk muop yakât otmâ kâiŋe ki kum lotohowi. ");
INSERT INTO spl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yawu gârâmâ tembe lâu âlâŋe iŋgepŋe mem Yesuhât gasumŋan hâumu yapâ hep otmu toto gam giop. ");
INSERT INTO spl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yâhâ nâmâ gotyeŋanâk kinmâ yekban. Yakât otmâ den kulemguan yu sâlikum nâŋgâŋetâ bulâŋe otmu Yesuhâlen biwiyeŋaŋe kepeim manŋetgât yu tâŋ tâŋâk kulemguan. ");
INSERT INTO spl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yâhâ miti pepaen den âlâ tap yamâ otbaŋgiwi yan yakât bulâŋe teteop ya yuwu. “Yakât hahitŋe konok âlâ ki kum lotohonomai.” ");
INSERT INTO spl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yâhâ den bulâŋe âlâ yawuâk teteop ya yuwu. “Lok âlâ hâuŋetâ kinmâ mumbuap ya eknomai.” Yawu tap. ");
INSERT INTO spl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yawu otmâ lok âlâ, kutŋe Yosep, yâhâmâ Arimata kapi amboŋe. Yâkŋe biwiŋe Yesuhâlen katmâ manmap. Yawu gârâmâ emelâk Yura nengât papatolipnenŋe yeŋgât kiŋgitŋahât otmâ topŋe kurihiakmâ manop. Yakât otmâ Yesu howanâmbâ membe sâm yok pilâm ari Pilato ekuop. Ekumu nâŋgâwaŋgimu ari bukulipŋe meyekmu ari Yesu mewi. ");
INSERT INTO spl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yâhâ Nikotemo yamâ aŋgoân omoŋ âlâen Yesuhâlen arimu den huhuowot yâkŋeâmâ Yesu piriwe sâm otmâ to kukŋe suk suk âlâ miop. Yawu gârâmâ to yamâ umatŋe pato yakât lok âlâ memu Yosepgâlen lâum ariowot. ");
INSERT INTO spl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yâhâ Yosep yet Nikotemoŋe hangure sâm Yura nengât orotmeme watmâ yuwu olowot. Yesu mem to kukŋe yaŋe piriowot. Pirim sâŋgum kâkâlep yaŋak katipguowot. ");
INSERT INTO spl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yâhâ Yesu howanân kuwi yaken ya kalam âlâ talop. Kalam yan kât giopŋe âlâ emelâk kusânmâ mem tiŋgâloŋetâ in kamen kinminiop. ");
INSERT INTO spl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yawu gârâmâ Yura nengât Tihit tihit hombaŋân yu me ya tuhumain sâm samut katbi. Yawu gârâmâ Tihit tihit hombaŋ ya tâlâhuop. Yakât otmâ lâum kâlepŋehen arinomaihât sâp biatmu lâm ya kâlehen lâum ba katbi. ");
INSERT INTO spl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Emet eŋgatŋe nâŋgâm Maria, Matala kapi amboŋe, sumângen ariop. Ari kât pato âlâ hâpunŋetâ ge lâm mâtâpŋe kum bâp maŋguop ya hindakmu mâtâpŋe kinop ya ehop. ");
INSERT INTO spl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ekmâ pârâk pilâm purik sâm Petoro orop netgâlen taka yuwu sâm eknotgop. “Papatolipnenŋaŋe Kutdâ sumâmbâ lâum ari wosaken âlâ misiŋgutsai?” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Yawu sâmu net gurâ sumângen ariwit. Nâŋe sururuk sâm Petoro wangim kulet sâwan. ");
INSERT INTO spl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kulet sâm ariwan yamâ lâm kâlehen ki bawan. Yâhâmâmâ lâm sâtŋanâk kinmâ olelem eksan mâne sâŋgum kâkâlep mem Yesu katipgum katbi yaŋahâk tatmu ekban. ");
INSERT INTO spl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","In ekmâ kinmune Petoroŋe belângen takaop yaŋak burunduŋâk gam kâlehen baop. Kâlehen ba sâŋgum kâkâlep yawuâk ehop. ");
INSERT INTO spl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Otmu sâŋgum tipiŋe mem Yesu kunŋe katipguwi ya âlâŋe kitâ mem ketetmâ heŋgeŋgum katmu talop ya ehop. ");
INSERT INTO spl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yawu otmuâmâ nâku yawuâk kâlehen bawan. Yâhâ kunŋe katipguwi yawuâk ekmâmâ Yesu mumuŋambâ yahalop nâŋgâwan. ");
INSERT INTO spl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yawu gârâmâ sum kamen kinmu ekbit yakât poropete nombotŋaŋe emet inânŋan Yesu mumuŋambâ yahatbuap yakât topŋe kulemguwi ya ki nâŋgâmutŋe keterahop. ");
INSERT INTO spl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yawu otmâ benŋe purik sâm âwurem ariwit. ");
INSERT INTO spl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Otmu Mariaŋe betnetŋan taka lâm sâtŋan isem kinop. Isem kinmâ kâlehen ehop. ");
INSERT INTO spl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ekmu aŋelo yâhâp yaŋe Yesu katŋetâ iop ya hâlâŋmâ nombot nombot talowot. Konokŋeâmâ kunŋehen talop. Yâhâ âlâ yaŋeâmâ kâiŋehen ge talop. ");
INSERT INTO spl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yawu tatmâ yuwu sâm âikuowot. “Wongât isem kinsat?” Sâmutâ sâop. “Kutdâne yupâ lâum ari wosaken âlâ misiŋgutsai?” yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","15","Yawu sâm kambeŋe kakŋambâ olelem Yesu ehop. Ekmâ yan “Yuâmâ kalam yukât amboŋe mon?” nâŋgâop. Yawu nâŋgâmu Yesuŋe âikuop. “Imbi, gâmâ âlâhât pâinmâ isem tat.” Yawu sâop. Sâmu sâop. “Lok pato, gâŋe sârâ Yesu lâum ari âlâengen misiŋgutsai otmuâmâ âlepŋe eknohorâ bukulipŋe ari ekyongomune taka menehât naŋgan.” ");
INSERT INTO spl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yawu sâmu kunop. Kunmu purik sâm Yesu towatŋe ekmâ nâŋgâm Yura nengât denân “Kutdâ” sâop. Den yukât topŋe yamâ “Kutdâne.” ");
INSERT INTO spl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sâmu sâop. “Nâ Awoŋnahâlen irak yâhâwoman yakât otmâ ki wâinek. Gâŋe âwurem ari bukulipne ekyongowuat. Ekyongom nâhâitŋe yamâ “Anitâ awoŋnenŋahâlen ewun âwurem yahap” sâm ekyongowuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yawu sâmu Mariaŋe taka den ya nen hoŋ bawalipŋe eknongop. ");
INSERT INTO spl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Otmu emet omoŋ otmu yanâmâ nen hoŋ bawalipŋe papatolipnenŋe yeŋgât kiŋgitnenŋahât otmâ emet âlâen yâhâ menduhuakmâ gahatŋe kârikŋe maŋgum tatbin. Menduhuakmâ tatmunŋe Yesuŋe hohetnenŋan pârâk sânsânâk teteningiop. Teteningim eknongop. “Biwiyeŋe huruŋ sâek.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yawu sâmâmâ biriŋe bâtŋe kuwi otmu iŋgepŋe gasumŋan hâuop yakât gut tiripnongomu ekbin. Tiripnongomu ekmâ biwinenŋe heroŋe olop. ");
INSERT INTO spl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yawu otmâ kinmunŋe yâhâpŋe sâop. “Yen biwiyeŋe huruŋ sâek. Awoŋnaŋe nâ hâŋgânnohomu gewan yakât dopŋeâk nâku yen hâŋgânyongomune arinomai,” sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yawu sâm kahapumŋaŋe hâŋgutnenekmâ yuwu sâm eknongop. “Yenâmâ Anitâhât Wâtgât mâmâŋahât Heakŋe mâmâŋe otyiŋgimu yâkât wâtŋan kinnomai. ");
INSERT INTO spl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wâtŋan kinmâ yâkât sâtgât lok âlâ me âlâhât tosa pilâyiŋginomai yamâ Anitâŋe buku otyiŋgiwuap. Yâhâ lok âlâ me âlâhât tosa ki pilâyiŋginomai yamâ matŋe umatŋe yiŋgiwuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yâhâ Yesuŋe teteningimu gutŋe ekbin sâp yan bukunenŋe âlâ, kutŋe Toma sâm, kutŋe âlâmâ Boho boho, yâhâmâ nen orowâk ki tatbin. ");
INSERT INTO spl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yakât otmâ belângen Toma ekmâ yuwu sâm ekuwin. “Kutdânenŋe nengâlen tetemu den huhuwin.” Sâmunŋe sâop. “Âo, yenâmâ den miai. Yawu gârâmâ biriŋe bâtŋe kuwi otmu iŋgepŋe gasumŋan hâuop yakât gutŋe nine sennan ekmâ mem walipguwom yanâmâ nâŋgâmune bulâŋe otbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yâhâ Sande âlâ otmu yan emelan âlâkuâk yâhâ menduhuakmâ gahatŋe kârikŋe maŋgum tatbin. Sâp yanâmâ Toma orowâk tatbin. Menduhuakmâ tatmunŋe Yesuŋe teteningim sâop. “Yen biwiyeŋe huruŋ sâek,” sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yawu sâm purik pilâm Toma yuwu sâm ekuop. “Bâtnan gut yu wâim ekmâ yaŋak gasumnan ya yawuâk mem nâŋgâ. Nâ bulâŋanâk Anitâŋe hâŋgânnohomu ge mansan yakât otmâ biwihaŋe nâhâlen kepeim biwi yâhâp ki otbuat.” ");
INSERT INTO spl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Sâmu sâop. “O, Kutdâne, bulâŋanâk gâ Anitâ orop dopyetŋe konohâk mansat.” ");
INSERT INTO spl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Sâmu sâop. “Gâŋe yiwereŋe gut yu mem eksat yakât otmâ biwihaŋe nâhâlen kepeiat. Yâhâ lohimbi nombotŋaŋe ki nekmâ biwiyeŋaŋak nâhâlen kepeim mannomai yamâ biwi nâŋgân nâŋgânyeŋe huruŋ sâmu heroŋe otmâ mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuŋe kulem topŋe topŋe miop yamâ kerehâk ki kulemguan. ");
INSERT INTO spl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yâhâ olop miop ya ekbin yakât den pat kulemguan yu sâlikum eknomai. Yu sâlikum ekmâ Anitâŋe tihitnenŋe otmâ nanŋe Yesu hâŋgângumu giop yakât nâŋgâŋetâ bulâŋe otmu yâkâlen biwiyeŋaŋe kepeinomai. Yâhâ yâkâlen biwiyeŋaŋe kepeim denŋe lâum mannomai yanâmâ manman kârikŋahât pat kuyiŋgiop ya menomai. ");
INSERT INTO spl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Sâp yakât kakŋan nen hoŋ bawalipŋe nombotŋe Tiweria deŋgân yakât ginŋan menduhuakmâ tatmunŋe Yesuŋe teteningiop yamâ yuwu. ");
INSERT INTO spl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nâ otmu atane, kutŋe Yakowo, otmu âlâmâ Simon Petoro, âlâmâ Toma, yâkâlâk kutŋe âlâ Boho boho, âlâmâ Natanae Galilaia hânân kapi âlâ Kana sâm yan gâtŋe, otmu lok yâhâp biwiyetŋe Yesuhâlen kepeim manowot ya orowâk menduhuakbin. ");
INSERT INTO spl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Menduhuakmâ tatmunŋe emet ŋiŋ sâwe sâm otmu Petoroŋe yuwu sâm eknongop. “Nâmâ ge iŋan dâiwehât naŋgan.” Sâmu sâwin. “Nen orowâk arinom,” sâm gemunŋe waŋgaen orowâk yâhâwin. Ari omoŋe pâlâmŋe manbin. ");
INSERT INTO spl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Emet haŋ sâmu yan Yesuŋe deŋgân ginŋan kinop. Yâhâ nenâmâ kâlewângen ki tatbin. 100 mita, dop yawuyaen tatbin yamâ towatŋe ekmunŋe ki keterahop. ");
INSERT INTO spl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yâhâ Yesuŋe yuwu sâm âinongop. “Bukulipne, yen iŋan miai, me bia?” Sâmu “Bia,” sâwin. ");
INSERT INTO spl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yakât otmâ yuwu sâm eknongop. “Iŋan itâŋe ya waŋga nombotgembâ panŋetâ gewuap yanâmâ iŋan mem dâinomai.” Yawu sâmu yaŋak benŋe waŋga nombotgembâ pilâmunŋe gemu iŋan dondâhâlâk ge kutakulakbi. Ge kutakulakŋetâ mem dâim waŋgaen katne sâm otmunŋe umatŋe dondâ olop. ");
INSERT INTO spl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yawu otmu nâŋe Petoro ekuwan. “Lok endamâ Kutdânenŋe yakâ.” Ekumune uk sâm petŋe tuhum katmâ âi tuhuop yakât otmâ tiŋginŋe yawuâk mem kepeiakmâ saruân kioŋmâ Kutdâhâlen yoloŋ otmâ ariop. ");
INSERT INTO spl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yawu otmuâmâ nenâmâ waŋgaenâk tatmâ puli kum iŋan itâŋe dâim deŋgân ginŋan yâhâ kioŋbin. ");
INSERT INTO spl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yesuŋe baŋga âlâ mem katmu talop. Katmu tatmu iŋan mem hot umu siop. ");
INSERT INTO spl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yawu otmâ Yesuŋe yuwu sâm eknongop. “Yiwereŋe iŋan miai ya nombotŋe mem katŋetâ siâk.” ");
INSERT INTO spl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Yawu sâmu Petoroŋe waŋga hâmeŋan yâhâ iŋan itârâek mem dâim ginŋan gaop. Yâhâ iŋan 153 ya itâ kâlehen kutakulakbi. Yawu gârâmâ iŋan yamâ papatoek yamâ benŋe iŋan itâŋe ya ki berendeŋ sâop. ");
INSERT INTO spl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","13","Iŋan nombotŋe katmunŋe semu orowâk newin. Orowâk nem tatbin yamâ âi pâi tuhunomgât nâŋgâmunŋe umatŋe otmu pilâwin. ");
INSERT INTO spl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yâhâ Yesuŋe mumuŋambâ yahalop yakât kakŋan deŋgân ginŋan menduhuakmâ tatbin yan teteningiop yaŋe kalimbuŋe olop. ");
INSERT INTO spl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nem pesuk pilâmunŋe Yesuŋe Simon Petoro yuwu sâm âikuop. “Simon, Yoane nanŋe, gâŋeâmâ bukulipgaŋe biwiyeŋaŋe hikunekmâ mansai ya wangiyekmâ biwihaŋe tiŋâk hikunekmâ mansat me girawu?” Sâmu sâop. “Kutdâ, yat ya bulâŋe. Nâmâ buku otgihiman ya naŋgat.” Sâmu sâop. “Yakât otmâ lohimbi nâhâlen yiwereŋeâk torokatmâ mansai ya yeŋgât tihityeŋe otbuat.” ");
INSERT INTO spl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yawu sâm yaŋak yâhâpŋe yuwu sâm âikuop. “Simon, Yoane nanŋe, gâŋe biwihaŋe tiŋâk hikunekmâ mansat me bia?” Sâmu sâop. “Kutdâ, yat ya bulâŋe. Nâŋe buku otgihiman ya naŋgat.” Sâmu sâop. “Yakât otmâ lohimbi nâhâlen emelâk torokatmâ mansai ya galemyongowuat.” ");
INSERT INTO spl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yawu sâm kalimbuŋe yuwu sâm âikuop. “Simon, Yoane nanŋe, gâŋe buku otnihimat me bia?” Yawu sâop. Yâhâ Yesuŋe kalimbuŋe âikuop. “Gâŋe buku otnihimat me bia?” yawu sâop yakât Petoroŋe nâŋgâmu biwiŋan hâumu yuwu sâop. “Kutdâ, gâhât sengan senŋe âlâlâ ki tik tatmap. Yakât otmâ nâŋe buku otgihiman ya naŋgat.” Sâmu sâop. “Yakât otmâ lohimbi nâhâlen torokatmâ mansai ya galemyongom wawaeyekmâ manbuat. ");
INSERT INTO spl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yâhâ hâmbâi yu me ya tetehihiwuap yakât topŋe sâwe. Gâŋe aŋgoân sihan manon yanâmâ petge mem lalakmâ kapi wosapâ wosapâ ariwehât nâŋgâminion yanâmâ âlepŋe arim tohominion. Yâhâ gâŋe sombo otbuat yanâmâ bâtge pilârâ lok bâleŋaŋe sâhâm menduhum ki ariwe nâŋgâwualângen dâihekmâ arinomai.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yâhâ Yesuŋe topŋe yuwuhât ekuop. Hâmbâi Petoroŋe Yesuhât tem lâuwaŋgim manmu umatŋe yawu tetewaŋgiwuap. Umatŋe tetewaŋgiwuap yan ki lohotŋe otmu kuŋetâ mumbuap. Yâhâ ki lohotŋe otbuap ya lohimbiŋe ekŋetâ sâtŋe otmu Anitâ mepaenomai. Yakât otmâ yuwu sâm ekuop. “Gâmâ biwihaŋe nâhâlen tiŋâk kepeim tem lâunihim manbuat.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Yawu sâmu Petoroŋe kambeŋe kakŋambâ olelem nâ nehop. Yâhâ nâ Yesu orop biwinetŋe hikuakmâ konohâk olopgât menduhuakmâ sot bâiŋe newin yan yâk orop hâlâŋakmâ tatbit. Yawu tatbit yakât otmâ âlâŋe betŋehen kioŋbuap yakât âikuwan. ");
INSERT INTO spl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yâhâ Petoroŋe nekmâmâ yuwu sâm Yesu âikuop. “Kutdâ, lok yuâmâ girawu?” ");
INSERT INTO spl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sâmu sâop. “Yâk tatmuâk âwurem takawom me girawu yamâ nâhât wahap. Yawu gârâmâ yâkât manman yakât ki nâŋgâm ketet otbuat.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Den yawu sâop yamâ bukulipnaŋe nâŋgâm hilipgum kelaŋgatbi. Kelaŋgatmâ nâhâitŋe “ki bâlewuap” sâwi. Yawu gârâmâ Yesuŋe ya ki sâop. Yâhâ yuwu sâop. “Gârâmâ yâk tatmuâk nâ âwurem takawom me girawu yamâ nâhât wahap. Yawu gârâmâ yâkât manman yakât ki nâŋgâm ketet otbuat,” yawu sâm Petoro ekuop. ");
INSERT INTO spl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Den sâop yuâmâ nine orowâk tatmâ nâŋgâminiwan. Yakât otmâ den kulemguan yu bulâŋe dondâ. ");
INSERT INTO spl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Otmu Yesuŋe olop miop yakât pâŋe konok kulemguan. Yawu gârâmâ âlâlâ olop ya kerek kulemgum metewomgât dop ki oap. ");
INSERT INTO spl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Emelâk Anitâŋe Yesu hâŋgângumu ge lok nombotŋe meyekmâ Anitâhât den kâsikum yiŋgim âi sâm yiŋgiop. Âi yawu tuhum manmâ gam benŋe âwurem himbimân yâhâwe sâm olop yan Anitâhât Wâtgât mâmâŋahât Heakŋe biwiŋan kioŋmu hoŋ bawalipŋe den bâiŋe ekyongom himbimân âwurem yâhâop. Yakât den pat ya emelâk kulemgum katgihiwan. ");
INSERT INTO spl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Roma yeŋgât tembe lâuŋe Yesu kuŋetâ muop yamâ Anitâŋe mumuŋambâ mem yahalop. Mem yahatmu hoŋ bawalipŋe teteyiŋgim Anitâŋe tihityeŋe otbuap yakât topŋe ekyongom manmâ gamu hilâm lok yâhâp ŋerek pesuk sâop. Yawu otmu Anitâŋe mumuŋambâ mem yahatmu manmu ekbi yakât nâŋgâŋetâ bulâŋe olop. ");
INSERT INTO spl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Otmu sâp âlâen yâk orowâk tatmâ sot newi yan Yesuŋe yuwu sâm ekyongop, “Yerusalem kapi in yawu ki pilâm arinomai. Awoŋnaŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otyiŋgiwuap yakât emelâk ekyongomune nâŋgâwi ya. Yakât otmâ tipiŋe tatmâ mambotnomai. ");
INSERT INTO spl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoaneŋe lohimbi mem toen katyehop. Yawu gârâmâ sâp ki kâlep otmuâk Anitâŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otyiŋgimu manmâ yâhânomai.” ");
INSERT INTO spl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesuŋe den bâiŋe aposololipŋe ekyongop yan yuwu sâm âikuwi. “Kutdâ, gâŋe sâp yiwereŋe yu Isirae lok menenekdâ Roma lok watyekmunŋe ariŋetâ nenŋahâk galemahom mannom me?” ");
INSERT INTO spl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Sâŋetâ sâop. “Sâp girawuân me girawuân yakât bulâŋe tetewuap ya Awoŋne Anitâŋe ikŋahâk nâŋgâmu tap. Otmu sâp ya tâlâhumu kulem girawuya tetemu ekmâ nâŋgânomai ya gurâ ikŋahâk nâŋgâmu tap. Yeŋe yakât topŋe nâŋgânomaihât dop âlâ ki tap. ");
INSERT INTO spl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Konohâk tap yamâ yuwu. Anitâŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otyiŋgimu nâhât den pat âlepŋe lohimbi ekyongonomai. Aŋgoân topŋe katmâ Yerusalem kapi ambolipŋe ekyongonomai. Yawu otmâ benŋe lohimbi Yuraia, Samaria otmu kâlepŋehen manmâ arai ya yeŋgâlen ari den pat ya ekyongonomai.” ");
INSERT INTO spl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yawu sâm ekyongom yan katyekmu kinŋetâ elem kakŋambâ yâhâop. Yawu otmu elem yaŋe kâtâpgumu ki ekbi. ");
INSERT INTO spl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yawu otmâ himbimângenâk ekmâ kinŋetâ aŋelo yâhâp, yâk yetgât hâk katipŋe kaok bolaŋ bolaŋ, yaŋe pârâk sânsânâk teteyiŋgiowot. ");
INSERT INTO spl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Teteyiŋgim yuwu sâm ekyongowot. “Galilaia ambolipŋe yeŋe wongât himbimângenâk senyeŋe pilâm ekmâ kinsai? Yesu ekmâ kinŋetâek pilâyekmâ himbimân yahap yawuâk himbimângembâ âwurem gemu eknomai. ");
INSERT INTO spl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yawu sâm ekyongom arimutâ benŋe aposolo yaŋe Oliwa pumŋambâ ge Yerusalem kapiân bawi. ");
INSERT INTO spl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yerusalem kapiân ba emelâk Yesu ki kuwi yan emet biwiŋe âlâen yâk orowâk tatmâ sot newi yan yâhâwi. Otmu aposololipŋe yeŋgât kutyeŋe yuwu. Petoro, imiŋe Anderea, Yakowo, imiŋe Yoane, Pilip, Toma, Batolomaio, Mataio, Alipaio nanŋe Yakowo, otmu Yakowo nanŋe Yurasi. Âlâmâ Simon, yâhâmâ komot âlâen gâtŋe topyeŋe yuwu. Roma lok ya yeŋgât hâkâŋ otmâ watyekne sâm otminiwi yan gâtŋe. ");
INSERT INTO spl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yesuhât aposololipŋaŋe ikŋe mâmâŋe imilipŋe otmu imbi nombotŋe menduhuyekŋetâ orowâk tatmâ biwi konohâk otmâ Anitâ ulitguwi. ");
INSERT INTO spl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sâp yan lohimbi nombotŋaŋe Yesuhâlen biwiyeŋaŋe kepeim manbi, lohimbi 120, yawuyaŋe menduhuakmâ tatŋetâ Petoroŋe yahatmâ kinmâ yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","“Bukulipne, yuwu sâmune nâŋgâŋet. Yesuŋe lok âlâ, kutŋe Yurasi sâm, yâk orowâk menenekmâ nep sâm ningimu hoŋ bawaŋgim gamain. Yâhâ Yurasiŋe betŋehen kioŋmâ lok bâleŋe dâiyekmu taka Yesu mewi.” Yawu sâop. Otmu Yurasiŋe Yesu mem bâtyeŋan kalop yakât hâmeŋe sâm hotom uminiwi yeŋgât kunlipyeŋaŋe tewetsenŋe waŋbi. Tewetsenŋe waŋetâ yaŋe mem ari hân âlâ puluhuop. Yawu gârâmâ Yesu betŋehen kioŋop yakât Yurasiŋe nâŋgâm otmâ hilipguan sâm aŋulahop. Yawu nâŋgâm yaŋak ari hiwawahop. Hiwawakmu tok sâmu ge kum tepŋe bâok pilâop. Tepŋe bâok pilâmu tepŋe komŋe kerek hindakmâ giop. Yawu olop yakât den pat nâŋgâm Yerusalem kapi ambolipŋaŋe hân yakât kutŋe “Akerama” sâm kunbi. Yâhâ kut yakât topŋeâmâ yuwu tap. “Hepŋak puluhuwi” yawu. Otmu Yurasi hiwawahop yakât nâŋgâm Petoroŋe yuwu sâop. “Emelâk emet inânŋan Anitâhât Wâtgât mâmâŋahât Heakŋe tâmbânenŋe Dawiti yâkât biwiŋan den âlâ katmu Yura nengât kep âlâ yuwu kulemguop yakât bulâŋe teteap. “Lok âlâ emetŋan ki tatmu emetŋe kamen kinbuap.” Otmu kep âlâ yuwu kulemguop. “Nepŋe pilâop ya lok âlâŋe mem galemguwuap.” Yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yakât otmâ nenŋe bukunenŋe âlâ mem Yurasihât gewâkŋan katmunŋe kinbuap. ");
INSERT INTO spl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Kândikum emelâk Yoaneŋe âi topŋe katmâ lohimbi mem toen katyehop sâp yapâek nenŋe Yesuhâlen torokatmâ biwinenŋe hikuakmâ konohâk otmâ manmâ gain. Nengâlen gâtŋe âlâ mem tetem orowâk tânahom Kutdânenŋe Yesu mumuŋambâ yahalop yakât den pat âlepŋe lohimbi ekyongonom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Petoroŋe yawu sâm ekyongomu lok yâhâp mem teteyelekbi. Lok âlâ kutŋe Yosep Yusito, kutŋe âlâmâ Basawa sâm, otmu âlâmâ Matia. ");
INSERT INTO spl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mem teteyelekmâ yuwu sâm Anitâ ulitguwi. “O Kutdâ, gâŋe biwinenŋahât topŋe kerehâk nâŋgâmat. Yakât otmâ lok âlâ me âlâhât nâŋgârâ ârândâŋ oap yâkât kutŋe biwinenŋan katdâ ekmâ nâŋgânom. ");
INSERT INTO spl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yâhâ Yurasiŋe nepŋe pilâm ikŋe mâtâwân ariop yakât gewâkŋan lok ya katmunŋe kinmâ yâhâwuap.” Yawu sâm ulitguwi. ");
INSERT INTO spl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yawu sâm ulitgum pepa duwatmâ yan kutyetŋe ikŋiâk ikŋiâk kulemgum amaŋ kâlehen katbi. Yawu otmâ bukuyeŋe âlâŋe yapâ kutŋe Matia kulemguop ya mem teteop. Mem tetemu benŋe aposolo kâiân konok yâk yeŋgâlen torokalop. ");
INSERT INTO spl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yesu mumuŋambâ yahalop yakât kakŋan Sande nombolân yâhâp pesuk sâop. Ya pesuk sâmu Sande tatbi yakât kutŋe “Pentikosi hombaŋ” yawu kunbi. Pentikosi hombaŋ otmu yan lohimbi Yesuhâlen biwiyeŋaŋe kepeim manbiŋe Anitâ mepa saŋgan otbaŋgine sâm emet âlâen menduhuakmâ tatbi. ");
INSERT INTO spl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Menduhuakmâ tatŋetâ mun pato âlâ, siru pato memap, mun yawuya himbimâmbâ pilâmu nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Yawu otmâ wahap âlâ, balam nimbilamŋe yawuyaŋe kunyeŋe kakŋan teteop. ");
INSERT INTO spl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yawu otmu Wâtgât mâmâŋahât Heakŋe ge mâmâŋe otyiŋgim lauyeŋe mem heweweŋ tuhumu denŋe denŋe sâm ariwi. ");
INSERT INTO spl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","6","Sâp yan Yura lohimbi Anitâhât den lâum manminiwiŋe Pentikosi hombaŋ ya ekne sâm kapiyeŋe pilâm âlâengembâ âlâengembâ takawi. Taka Yerusalem kapiân yâhâ tatbi. Yawu otmâ mun pato ya himbimâmbâ pilâmu nâŋgâm lohimbi seseŋgâlâkŋe emet yanâk menduhuakmâ Yesuhât lohimbi yeŋgât denyeŋe nâŋgâwi. Yawu otmâ lohimbi Yesuhâlen biwiyeŋaŋe kepeim manbiŋe Yura yeŋgât denânâk sâwiâke yamâ benŋe lohimbi takawi yaŋe den ya nâŋgâŋetâ denyeŋe âlâku ikŋiâk ikŋiâk olop. ");
INSERT INTO spl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yawu olop yaŋak benŋe nâŋgâŋetâ âlâ kândâkdâ otmu yuwu sâm alahuwi. “Yesuhât lohimbi den oai yu Galilaia ambolipŋe kerek. Nenŋan gâtŋe bia. ");
INSERT INTO spl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yakât otmu girawu otmâ nenŋe den sâŋetâ naŋgain? ");
INSERT INTO spl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nengât topnenŋeâmâ yuwu. Nen kapi kâlepŋehembâ takain. Nen nombotŋe Pata ambolipŋe, nombotŋe âlâmâ Meria ambolipŋe, nombotŋe âlâmâ Elam ambolipŋe, nombotŋe Mesopotamia ambolipŋe, nombotŋe Yuraia hânân kapi tipi tapi tatmâ arap ya ambolipŋe, nombotŋe Kaparokia ambolipŋe, nombotŋe Ponto ambolipŋe, nombotŋe Asia ambolipŋe, ");
INSERT INTO spl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","nombotŋe Pirihia ambolipŋe, nombotŋe Pampilia ambolipŋe, nombotŋe Aihita ambolipŋe, nombotŋe Apirika ambolipŋe, nombotŋe Kirene kapi nombotŋe Liwia hân nombot nombot tatmâ arap ya ambolipŋe. ");
INSERT INTO spl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nombotŋe Kereta ambolipŋe, nombotŋe Arawia ambolipŋe, otmu nombotŋe Roma ambolipŋe. Nen yawuŋe tain. Nen nombotŋe Yura lohimbi bulâŋe. Yâhâ nombotŋe âlâŋeâmâ Yura nengâlen torokatŋetâ orowâk mansain. Nen lok topŋe topŋe. Yawu gârâmâ Anitâŋe kulem yu ya otmâ gaop yakât den pat Galilaia kapi ambolipŋaŋe nenŋe denânâk sâŋetâ naŋgain.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yâhâ den ya nâŋgâŋetâ âlâ kândâkdâ otmu yakât topŋe nâŋgâne sâm pâpguwi. Yawu otmâ “Kulem yukât topŋe girawu?” sâm alahuwi. ");
INSERT INTO spl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yawu gârâmâ lohimbi nombotŋaŋe Yesuhât lohimbi yekmâ senyeŋan gem yuwu sâwi. “Yeŋe wain to dondâ neŋetâ biwiyeŋe hâlim oap.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yawu sâŋetâ Yesuhât aposololipŋaŋe yahatmâ kinmâ Petoroŋe lohimbi takawi ya yuwu ekyongop. “Bukulipne otmu lomba taka tai yen kulem tetemu eksai yukât topŋe ekyongomune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Omoŋânâk wain to ki nemain. Yakât otmâ lok yeksai yuŋe wain to ki niai. ");
INSERT INTO spl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Emelâk emet inânŋan poropete âlâ, kutŋe Yoele sâm, yâkŋe den kulemguop yakât bulâŋe yiwereŋe tetemu eksai yu. Emelâk den kulemguop ya yuwu. ");
INSERT INTO spl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Anitâŋe yuwu sâm eknohop. Hâmbâi sâp pato tâlâhuwuap yan nâŋe nine Wâtgât mâmâŋahât Heak hâŋgângumune ge lohimbi mâmâŋe otyiŋgiwuap. Mâmâŋe otyiŋgimu lohimbiŋe nâhâlen biwiyeŋaŋe kepeim mannomai yaŋe nâhât den sâm tetem lohimbi ekyongonomai. Otmu biwiyeŋe mem purik pilâmu kulem âlâlâ tetemu eknomai. Otmu amanân awun eknomai. ");
INSERT INTO spl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bulâŋanâk sâp yan Wâtgât mâmâŋahât Heakŋe hoŋ bawalipne mâmâŋe otyiŋgimu nâhât den sâm tetem ekyongonomai. ");
INSERT INTO spl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Otmu lohimbi kerek matŋe yiŋgimune menomai yakât sâp tâlâhumu yan nâŋgâmune himbimân kulem âlâlâ yuwu tetemu eknomai. Hilâmgât emetsenŋe bok sâmu omoŋ bâleŋe sahakbuap. Yâhâ omoŋgât emetsenŋe yaŋeâmâ kuriŋ hep barak barak yawuya otbuap. Otmu umatŋe topŋe topŋe yuwu tetewuap. Kapam tetewuap. Otmu emet kapi kâlâp sewuap. Yawu tetemu ekŋetâ sâtŋe otmu hu halak tuhunomai. ");
INSERT INTO spl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sâp yan lohimbi âlâ me âlâŋe nâhâlen biwiyeŋaŋe kepeim mannomai yamâ meyekmune ki hiliwahonomai.” Anitâŋe yawu sâm eknohop.” Den yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petoroŋe torokatmâ yuwu sâm ekyongop. “Bukulipne, den âlâ torokatmâ yuwu sâmune nâŋgâŋet. Anitâŋe Yesu Nasaret amboŋe ya mâmâŋe otbaŋgimu hohetnenŋan manmâ kulem topŋe topŋe memu ekmunŋe âlâ kândâkdâ otmu Anitâŋe hâŋgângumu giop yawu nâŋgâmain. ");
INSERT INTO spl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yawu gârâmâ yeŋe Yesuhât hâkâŋ otmâ lok bâleŋe yeŋgât bâtyeŋan katŋetâ yâkŋe mem howanân kuŋetâ muop. Yawu otbaŋgiwi yakât Anitâŋe emelâk emet inânŋan nâŋgâmu ârândâŋ otmu mâtâp ya sâm waŋop. Mâtâp ya sâm waŋmu yaŋak benŋe howanân kuŋetâ sâtgum muop. ");
INSERT INTO spl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kuŋetâ muop yamâ sumânâk tatbuapgât dop âlâ ki olop. Yakât otmâ Anitâŋe mumuŋambâ mem yahalop. ");
INSERT INTO spl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Emelâk emet inânŋan tâmbânenŋe Dawitiŋe Yesuŋe mumuŋambâ yahatbuap yakât nâŋgâm yuwu kulemguop tap. “Kutdâ gâ orowâk manmâ gan. Yakât otmâ ki pilânekbuat yawu naŋgan. Biwi yâhâp otmangât mâmâŋe otnihim gamat. ");
INSERT INTO spl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Yakât otmâ biwine âlepŋe otmu tem lâuhihim heroŋe nâŋgâhihian. Otmu mumbom yan umutne membuat. Otmu mumuŋambâ mem yahatnekbuat. Yawu otnihiwuat nâŋgâm biwine ki houŋ sâwuap. ");
INSERT INTO spl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gâŋe nâŋgân nâŋgânne mem pâroŋ pilânihirâ manmangât mâtâp yakât topŋe nâŋgâm ba takaman. Otmu gâ orop manmâ yâhâwom yakât nâŋgâm biwine heroŋe otmâ manmâ yâhâwom.” Yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tâmbânenŋe Dawiti yâkât yuwu ekyongomune nâŋgâŋet. Yâkât sumŋe ekmain. ");
INSERT INTO spl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Anitâŋe poropete âi sâm waŋmu yâkât den lohimbi ekyongom manmâ gaop. Yawu otmâ Anitâŋe pat kuwaŋgim yuwu sâop. “Gâhât tepgan gâtŋe âlâ tetewuap ya mem kânâŋgâmune kawehan kinmâ nine lohimbi galemyongowuap.” ");
INSERT INTO spl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Anitâŋe yawu sâm pat kuwaŋgiop. Otmu Anitâŋe Yesu Kiristo mumuŋambâ mem yahatbuap yakât nâŋgâm Dawitiŋe emet inânŋan den yuwu kulemguop. “Mumu yan Anitâŋe umutŋe miop. Otmu hâkŋe tâtuk sâmapgât mumuŋambâ mem yahalop.” Yawu kulemguop. ");
INSERT INTO spl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Anitâŋe Yesu mumuŋambâ mem yahatmu nen kerekŋe ekbin. ");
INSERT INTO spl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Anitâŋe Yesu mumuŋambâ mem yahatmu ikŋe orop tawot. Otmu emet inânŋan âwâŋe Anitâŋe Wâtgât mâmâŋahât Heak hâŋgângumu gewuap yakât pat kuop. Yakât otmâ Wâtgât mâmâŋahât Heak ya hâŋgângumu ge mâmâŋe otningimu denŋe denŋe sâmunŋe naŋgai. ");
INSERT INTO spl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Otmu Dawiti ikŋak himbimân ki yâhâop. Yuwu gârâmâ emelâk emet inânŋan den yuwu kulemguop. “Anitâŋe nâhât Kutdâne yuwu sâm ekuop. “Gâ gotnan ga kindâ mâmâŋe otgihimune ");
INSERT INTO spl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kasalipge yongom mem ge katyekbuat.” Yawu sâop.” Yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yakât otmâ yuwu sâm ekyongomune nâŋgâm biwi yâhâp ki otnomai. Yesu mem howanân kuŋetâ muop ya yeŋe amboŋe oai. Yawu gârâmâ Anitâŋe mumuŋambâ mem yahatmu kunnenŋe tap. Yakât otmâ Kutdânenŋe sâmain. Yawu.” ");
INSERT INTO spl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Petoroŋe yawu sâm lohimbi ekyongomu nâŋgâŋetâ biwiyeŋan hâumu aposolo nombotŋe ya orop yuwu sâm âiyongowi. “Wâe, nenŋe girawu otmunŋe Anitâŋe nenekmu ârândâŋ otbuap yakât sâŋetâ nâŋgâne.” ");
INSERT INTO spl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","39","Sâŋetâ sâop. “Anitâ Kutdânenŋaŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge yen otmu lohimbi kâlepŋehen mansai mâmâŋe otyiŋgimu Yesuhâlen biwiyeŋaŋe kepeim mannomai yakât pat emelâk kuyiŋgiop. Yakât otmâ orotmemeyeŋe bâleŋe bet pilâm Yesuhâlen biwiyeŋe katŋetâ Anitâŋe tosayeŋe pilâyiŋgiwuap. Yawu otŋetâ benŋe nenŋe Yesu Kiristohât kulân toen mem katyekmunŋe Wâtgât mâmâŋahât Heakŋe ge mâmâŋe otyiŋgimu mannomai.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petoroŋe biwiyeŋan kioŋmâ den kâlep torokatmâ girem den yuwu sâm ekyongop. “Lohimbi perâkŋe ihilâk mahilâk manmai ya Anitâŋe matŋe umatŋe yiŋgimu menomai. Yawu gârâmâ yeŋe orotmemeyeŋe bâleŋe bet pilâm Yesu Kiristohâlen biwiyeŋaŋe kepeiŋetâ yâkŋe tihityeŋe otbuap.” ");
INSERT INTO spl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yawu sâm ekyongomu lohimbi kiŋgitŋe orowâk, dopyeŋe 3,000 yawuyaŋe Petorohât denŋe nâŋgâŋetâ bulâŋe otmu Yesuhâlen biwiyeŋe katbi. Yawu otŋetâ aposololipŋaŋe toen mem katyekŋetâ Yesuhât komolân torokatbi. ");
INSERT INTO spl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yesuhât komolân torokatŋetâ aposololipŋaŋe yâkât den kâsikum yiŋgiwi. Kâsikum yiŋgiŋetâ nâŋgâm biwiyeŋe hikuakmâ konohâk otmâ Anitâ mepa saŋgan otbaŋgim manbi. Otmu sâp sâsâŋan menduhuakmâ buku oraŋgim sot newi. ");
INSERT INTO spl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Otmu aposololipŋaŋe kulem topŋe topŋe meŋetâ lohimbi belângen manbiŋe kulem ya ekŋetâ sâtŋe olop. ");
INSERT INTO spl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yâhâ lohimbi Yesuhâlen biwiyeŋe kepeiwiŋe biwi konok otmâ sot kâle senŋe âlâlâ mem menduhum konohân katŋetâ tatmu yaŋe mem tânahom manbi. ");
INSERT INTO spl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Otmu lohimbi nombotŋaŋe iri sikumyeŋe puluhum yakât hâmeŋe mewi ya mem bukulipyeŋe nombotŋaŋe yu me yakât umburuk manbi ya kâsikum yiŋgiwi. ");
INSERT INTO spl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yawu otmâ hilâm ârândâŋ Anitâhât opon kâmbukŋan yâhâ menduhuakmâ biwi konohâk otmâ Kiristohât den alahuminiwi. Yawu otmâ emetsâpŋe ârândâŋ emetyeŋan yâhâ menduhuakmâ sot um neminiwi. Yawu otmâ tep heroŋe nâŋgâm Anitâ mepaem manbi. ");
INSERT INTO spl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yawu otŋetâ lohimbi belângen manbi nombotŋaŋe orotmemeyeŋe ya ekŋetâ yahalop. Yawu otmâ Yesuhâlen biwiyeŋe katmâ yâkât komolân torokatmâ sambe otbi. ");
INSERT INTO spl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Isirae lohimbi orotmeme âlâ yuwu otmai. Emetsâpŋe ârândâŋâk opon kâmbukŋan yâhâ Anitâ ulitgumai. Emetsâpŋe âlâen Petoro yet Yoaneŋe Anitâ ulitgure sâm opon kâmbukŋan yâhâowot. ");
INSERT INTO spl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Otmu lok âlâ mâmâŋahât tepŋambâek pareŋe teteopŋe bukulipŋe ekyongomu hilâm ârândâŋ opon kâmbukŋahât gahatŋe âlâ, kutŋe “Mâtâp âiloŋgo loŋgo” sâm yan lâum ari katŋetâ tatminiop. Yan tatmâ lok opon kâmbukŋan yâhâm geminiwi yaŋe tewetsenŋe nihiŋet sâm ulityongominiop. ");
INSERT INTO spl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Otmu sâp yan Petoro yet Yoane opon kâmbukŋan yâhâmutâ yelekmâ ulityotgop. ");
INSERT INTO spl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ulityotgomu Petoroŋe nâŋgâm “Wa, buku” sâm in ekmâ sâop. ");
INSERT INTO spl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","In ekmâ sâmu lok pareŋe yaŋe tewetsenŋe nihiwomap sâm tepŋe kilik kilik sâmu talop. ");
INSERT INTO spl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yawu otmu Petoroŋe yuwu sâm ekuop. “Senŋe âlâlâ ki tatnihiap yakât yuwu sâmune nâŋgâ. Yesu Kiristo Nasaret amboŋaŋe gâ heŋgeŋgohowuapgât dop tap. Yakât otmâ yahatmâ bam ga.” ");
INSERT INTO spl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yawu sâm ekum bâtŋe bonângen memu yahalop. Memu yanâk kâiŋe sâsilipŋe tâŋ tâŋ otmu heweweŋâk yahatmâ kinop. ");
INSERT INTO spl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yahatmâ kinmâ yâk orowâk opon kâmbukŋan yâhâwi. Yâhâ lok yaŋe heroŋe otmâ soŋ pilâm bam gam Anitâ mepaeop. ");
INSERT INTO spl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Yawu otmâ mepaemu lohimbi kâlehen tatbiŋe ekmâ yuwu sâwi. “Lok pareŋe yuŋe opon kâmbukŋahât mâtâp âiloŋgo loŋgo yan tatmâ senŋe âlâlâhât ulitnongomap. Âlepŋe oap yakât nâŋgâmunŋe ki orotŋe oap,” yawu sâm nâŋgâŋetâ âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Otmu emelâk opon kâmbukŋe ya tuhuwi yan gelâk ningimap sâm selep bârârâhâk kâlep tuhuwi yakât kutŋe “Solomongât selep” sâwi. Lok yaŋe Petoro yet Yoane yetgâlen torokatmu selep yan yâhâŋetâ lohimbi dondâhâlâkŋe betyeŋan yâhâm mem hawam mewam tuhuyekmâ kulem yakât alahu gulahu otbi. ");
INSERT INTO spl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Yawu otŋetâ Petoroŋe yekmâ yuwu sâm âiyongop. “Wongât mem hawam mewam tuhuneneksai? Kulem yu netgât wahap bia. Netŋe wâtnetŋambâek lohimbi heŋgemyongoromgât dop âlâ ki tap. Net uwawapŋe bia ki mansait. Yakât otmâ ki nâŋgânitgiŋetâ yahalâk. ");
INSERT INTO spl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Topŋe yuwu tap. Awaraham, otmu nanŋe Isaka, otmu seseŋe Yakop yâk yeŋgât Anitâ, tâmbâlipnenŋe yeŋgât Anitâ, yâkŋe ikŋe nanŋe Yesu hâŋgângumu ge hohetnenŋan manop. Yâkât kulân lok yu memutŋe Anitâŋe heŋgeŋgumu bam gamu eksai. Yâhâ yeŋeâmâ Yesuhât nâŋgâŋetâ gemu pâku lohimbi yeŋgât bâtyeŋan katbi. Yawu otŋetâ Pilatoŋe holaŋbe sâmu yan yeŋeâmâ kunyeŋe kârikŋe otmâ Yesu ya sâm ge katbi. ");
INSERT INTO spl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yâkŋe uwawapŋe bia manmâ gaop. Yawu gârâmâ yeŋe hâkâŋ otmâ betbaŋgim lok bâleŋe, kutŋe Barawa sâm, yâkât nâŋgâŋetâ yahatmu Pilato ekuŋetâ lauyeŋan mem Barawa holaŋmu arimu Yesu kuŋetâ muop. ");
INSERT INTO spl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kuŋetâ muop yamâ lok inŋe ki kuŋetâ muop. Manman kârikŋahât amboŋe ya kuŋetâ muop. Kuŋetâ muop yamâ Anitâŋe mumuŋambâ mem yahatmu manmâ teteningimu ekbin. ");
INSERT INTO spl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Lok pareŋe yuŋe âlepŋe oap yukât topŋe sâmune nâŋgâŋet. Yesuhât kulân lok pareŋe yu memutŋe Yesuhâlen biwiŋe katsapgât Anitâŋe heŋgeŋgumu bam gamu eksai. ");
INSERT INTO spl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Bukulipne, yuwu sâmune nâŋgâŋet. Yeŋe papatolipyeŋaŋe orop Yesuhât topŋe pâpgum gamai. Yakât otmâ kuŋetâ muop. ");
INSERT INTO spl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Emelâk emet inânŋan Anitâŋe Yesuhât nâŋgâm poropetelipŋe yeŋgât biwiyeŋan den katmu yuwu kulemguwi. “Tihitnenŋe otbuap yâkŋe aŋgoân hâhiwin nâŋgâm mumbuap.” Yawu kulemguwi tap. ");
INSERT INTO spl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Anitâŋe tosayeŋe pilâyiŋgiâkgât yeŋe orotmemeyeŋe bâleŋe bet pilâm Yesuhâlen biwiyeŋaŋe kepeim manŋet. ");
INSERT INTO spl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Yawu otmâ manŋetâ Anitâŋe mâmâŋe otyiŋgimu biwiyeŋe sânduk sâmu mannomai. Sâp yuâmâ Yesu Kutdânenŋaŋe himbimân tap. Yawu gârâmâ hâmbâi sâp pato tetewuawân Yesuŋe tihitnenŋe olâk sâm Anitâŋe hâŋgângumu âwurem gewuap yakât pat kuningimu tap. ");
INSERT INTO spl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Anitâŋe embâŋâmbâek emet inânŋan poropetelipŋe yeŋgât biwiyeŋan den katmu kulemguwi yakât topŋe yuwu tap. Manmannenŋe kuwikningiwuap yakât Anitâŋe nâŋgâmu ârândâŋ otmu Yesu hâŋgângumu âwurem gewuap. ");
INSERT INTO spl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yakât torehenŋe Moseŋe yuwu kulemguop. “Kutdânenŋe Anitâŋe nâ menekmâ âi sâm nihimu taka ikŋe den kâsikum yiŋgim mansan yakât dopŋeâk Anitâŋe nengât komolân gâtŋe lok âlâ mem poropete âi sâm waŋmu ikŋe den kâsikum yiŋgimu lohimbiŋe tem lâuwaŋginomai. ");
INSERT INTO spl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yâhâ lohimbi nombotŋaŋeâmâ denŋe nâŋgâm hâkâŋ otmâ kunomai ya mem ketetyekmâ hilipyongowuap.” Den yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Otmu emelâk emet inânŋan lok âlâ, kutŋe Samue, yâk otmu Anitâhât poropetelipŋaŋe Yesu Kiristoŋe tetem manmâ kulem topŋe topŋe membuap yakât den yawuâk kulemguwi. ");
INSERT INTO spl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Emelâk embâŋân Anitâŋe Awarahamgât pat kuwaŋgim yuwu sâm ekuop. “Hâmbâi gâhât tepgan gâtŋe lok âlâŋe tetem lohimbi hânŋan kulemŋan mannomai ya menduhuyekmâ manman âiloŋgoân katyekmu heroŋe nâŋgâwaŋgim mannomai.” Yawu sâm ekuop. Yâhâ Anitâhât poropetelipŋaŋe den ya torokatmâ lohimbi sâm tetem ekyongom manmâ gawi. Otmu Anitâŋe tâmbâlipyeŋe yeŋgât pat kuyiŋgiop ya yen gurâ pat yaŋe meyeksap. Gârâmâ yakât bulâŋe yen gurâ yawuâk menomai. ");
INSERT INTO spl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yâhâ nen Isirae lohimbiŋe orotmemenenŋe bâleŋe bet pilâm Anitâ nanŋahâlen biwinenŋaŋe kepeim manman âiloŋgoân manmâ heroŋe nâŋgânomgât aŋgoân Anitâŋe yâk hâŋgângumu nengâlen giop. ");
INSERT INTO spl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","3","Anitâŋe Yesu mumuŋambâ mem yahalop yakât den pat âlepŋe ya Petoro yet Yoaneŋe lohimbi ekyongowot. Ekyongom tatmutâ opon kâmbukŋahât tembe lâu yeŋgât kunyeŋe otmu Sarukaio otmu Anitâhât hotom uminiwiŋe den pat ya nâŋgâŋetâ ki bulâŋe olop. “Yesu mumuŋambâ ki yahalop. Ya ki orotŋe,” yawu nâŋgâm den hâreyitgim meyelekmâ ari pâi emetŋan katyelekŋetâ talowot. Pâi emetŋan tatmutâ emet haŋ sâop. ");
INSERT INTO spl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yâhâ Petoroŋe lohimbi kiŋgitŋe orowâk Yesuhât den pat âlepŋe ekyongomu nâŋgâŋetâ bulâŋe otmu Yesuhât komolân torokatbi ya yeŋgât dowâmâ 5000 yawu. ");
INSERT INTO spl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Emet haŋ sâmu Yura yeŋgât papatolipyeŋe otmu hotom uminiwi ya yeŋgât kunlipyeŋe otmu Mosehât girem den kâsikum yiŋgiminiwi yâkŋe Yerusalem kapiân menduhuakbi. ");
INSERT INTO spl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Sâp yan opon kâmbukŋahât lok kunŋe âlâ, kutŋe Anasi, otmu lamatŋe, kutŋe Kaipa, otmu bukuyâhâtŋe Yoane yet Alesanda otmu hep torehenlipyeŋe orowâk menduhuakbi. ");
INSERT INTO spl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Otmu Anasiŋe tembe lâu ekyongomu Petoro yet Yoane otmu lok pareŋe âlâ mem heŋgeŋguowot ya meyekmâ ari den âiân katyekbi. Otmu Anasiŋe yuwu sâm âiyotgop. “Âlâhât sâtgât otmâ lok pareŋe yu heŋgeŋguowot?” ");
INSERT INTO spl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yawu sâm âiyotgomu Anitâhât Wâtgât mâmâŋahât Heakŋe Petoro mâmâŋe otbaŋgimu yahatmâ kinmâ yuwu sâop. “Yura papatolipnenŋe otmu Anitâhât hotom umai yeŋgât kunlipyeŋe yen yuwu sâm ekyongomune nâŋgâŋet. ");
INSERT INTO spl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Netŋe lok pareŋe yu ekmâ tepnetŋe nâŋgâwaŋgim memutŋe âlepŋe olop yakât otmâ yeŋe menenekmâ den âiân katnenekŋetâ kinsain. ");
INSERT INTO spl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yakât otmâ lok âlepŋe olop yukât topŋe ekyongomune nâŋgâŋet. Topŋe yuwu. Yesu Kiristo, Nasaret amboŋe, yâhâmâ howanân kuŋetâ muop. Kuŋetâ muop yamâ Anitâŋe mumuŋambâ mem yahalop. Yakât otmâ yâkât wâtŋan kinmâ lok yu memutŋe âlepŋe otmâ mansap. Yawu gârâmâ yeŋe lok yukâlen kulem teteop yakât den pat Yura lohimbi kerek ekyongoŋetâ nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Emelâk embâŋân Miti pepaen den âlâ yuwu kulemguwi yakât bulâŋe Yesuhâlen teteap. “Emet tuhum nep lokŋe nak âlâ ekŋetâ bâlemu mem ketetbi. Nak mem ketetbi ya Anitâŋe lâum kânâŋgâmu kuhupin kârikŋe oap.” Den yawu kulemguwi tap. Yeŋeâmâ emet tuhuwi ya yeŋgât dop otmâ Yesu betbaŋgim kuŋetâ muop. ");
INSERT INTO spl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yuwu sâmune nâŋgâŋet. Anitâŋe Yesu hâŋgângumu ge manman kârikŋe yakât mâtâp meningiop. Yakât otmâ yâkât wâtŋanâk kinmâ manman kârikŋan mannomgât dop tap. Lok ondopŋe mâmâŋe otningimu manman kârikŋan mannomgât dop âlâ ki tap.” ");
INSERT INTO spl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Petoro yet Yoane, yâhâmâ nâŋgân nâŋgân emetŋan ki yâhâowot. Yawu gârâmâ Yura papatolipyeŋe yeŋgât senyeŋan kinmâ den ya kâlâpŋe orowâk ekyongowot. Yawu ekyongomutâ yâkŋe denyetŋe ya nâŋgâŋetâ ewe membe olop. Yawu otmu nâŋgân nâŋgânyeŋe pâroŋ sâmu yuwu sâwi. “O, lok yuâmâ kândikum Yesu orop manmâ gawi. Yakât otmâ den kâlâpŋe orowâk eknongomutâ naŋgain.” yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Otmu Petoro yet Yoaneŋe lok heŋgeŋguowot yâk orowâk kinbi yakât otmâ den purik pilâyitgine sâm hâum pâpgum pilâwi. ");
INSERT INTO spl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yakât otmâ hâŋgânyongoŋetâ emet betŋehen ge kinŋetâ Petoro yet Yoane yetgât alahum yuwu sâwi. ");
INSERT INTO spl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nenŋe lok yâhâp yu girawu otyitgine? Yâkŋe Yesuhât wâtŋan kinmâ lok pareŋe emba memutâ âlepŋe olop yakât den pat Yerusalem kapi ambolipŋaŋe emelâk nâŋgâm meteai. ");
INSERT INTO spl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yawu gârâmâ den yuŋe kapi ârândâŋ perereŋ sâm arimu nâŋgâmaihât nenŋe kuyitgimunŋe yâkŋe ki âlâkuâk Yesuhât wâtŋan kinmâ lohimbi yâkât den kâsikum yiŋginomai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Otmu tembe lâu ekyongoŋetâ meyekmâ âwurem gaŋetâ yuwu sâm Petoro yet Yoane ekyotgowi. “Yetŋe ki âlâkuâk Yesuhât den ya lohimbi kâsikum yiŋgiromawot.” ");
INSERT INTO spl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yawu sâŋetâ Petoro yet Yoaneŋe yuwu sâowot. “Yeŋak nâŋgâm ekŋet. Yeŋgât den lâum Anitâhât den pilâmutŋe yâkŋe nâŋgâmu ki ârândâŋ otbuap. ");
INSERT INTO spl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yesu Kiristoŋe den âlâlâ eknongom kulem topŋe topŋe mem gaop yakât den pat ya netŋe mem kurihiromgât dop ki tap. Ya sâm haok tuhurom yakâ.” ");
INSERT INTO spl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yawu sâmutâ yâhâpŋe kuyitgim holaŋyelekŋetâ gem ariowot. Lohimbi inŋe kiŋgitŋe orowâkŋe kulem ya ekmâ Anitâ mepaem aposololipŋe yeŋgât nâŋgâŋetâ yahalop. Yakât otmâ Yura papatolipyeŋaŋe wahap âlâ ki otyitgiwi. ");
INSERT INTO spl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lok âlepŋe olop yâkŋe pareŋe otmâ manmu yambu lok yâhâp ŋerek olop. ");
INSERT INTO spl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Yura papatolipyeŋaŋe Petoro yet Yoane holaŋyelekŋetâ gem bukulipyetŋe yeŋgâlen âwurem ariowot. Ari papatolipyeŋaŋe kuyitgiwi yakât den ya ekyongowot. ");
INSERT INTO spl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ekyongomutâ nâŋgâm biwiyeŋaŋe kepeiakmâ konohâk otmâ Anitâ mepaem yuwu sâwi. “Ambonenŋe Anitâ. Gâŋe hân himbim kândikyotgom wahap topŋe topŋe kalon. ");
INSERT INTO spl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Otmu emelâk emet inânŋan gâhât Wâtgât mâmâŋahât Heakŋe tâmbânenŋe Dawiti yâkât biwiŋan den âlâ katmu yuwu kulemguop. “Wongât Anitâhât ki nâŋgâmaiŋe yeŋahât naŋgaŋgiŋetâ yahatmu biwiyeŋe kâlâp siap? Wongât biwi nâŋgân nâŋgânyeŋe hâlim milim otmu Anitâ yet hoŋ bawaŋe mem ge katyelekne sâm oai? Anitâŋe tihityeŋe otbe sâm ikŋe hoŋ bawa hâŋgângumu gewuap. Yawu gârâmâ Anitâhât ki nâŋgâmai ya yeŋgât papatolipyeŋaŋe biwi konok otmâ mem ge katyeleknomaihât dop âlâ ki tap.” Dawitiŋe den yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Otmu torokatmâ yuwu sâm ulitguwi. “Ambonenŋe Anitâ, den âlâ sâmunŋe nâŋgâ. Dawitiŋe den kulemguop yakât bulâŋe teteop yakât topŋe yuwu. Gâŋe tihitnenŋe otbe sâm Yesu hâŋgângurâ ge tem lâuhihim uwawapŋe bia manmâ gaop. Yawu gârâmâ Herot yet Pilatoŋe Roma lok otmu Yura nengât papatolipnenŋe menduhuyekmutâ orowâk tatmâ Yesu mem ge katne sâm den hikuwi. ");
INSERT INTO spl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yawu otbi yan yeŋe eŋgatyeŋeâk ki watbi. Emelâk emet inânŋan gâŋe gike eŋgatgeâk otmâ yu ya tetewuap ya sâm kalon. ");
INSERT INTO spl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yakât otmâ yâkŋe kuniŋgiŋetâ lohotŋe otmaingât gâŋe mâtâp maŋguyiŋgim nen hoŋ bawalipge mâmâŋe otningirâ Yesu Kiristohât den pat âlepŋe sâm haok tuhunom. ");
INSERT INTO spl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yawu otmâ Yesuhât wâtŋan kinmâ lohimbi mesekyeŋe orop ya heŋgemyongonom. Otmu kulem topŋe topŋe memunŋe ekŋetâ âlâ kândâkdâ otbuap. Yakât otmâ mâmâŋe otningihât nâŋgâm ulitgohoain.” Yawu sâm ulitguwi. ");
INSERT INTO spl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yawu sâm ulitguŋetâ emet menduhuakmâ tatbi ya gâsuk gâsuk sâop. Otmu yanâk Anitâhât Wâtgât mâmâŋahât Heakŋe mâmâŋe otyiŋgimu yapâ ari Yesuhât den pat âlepŋe ya sâm haok tuhum lohimbi ekyongowi. ");
INSERT INTO spl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesuhât lohimbiŋe biwiyeŋe hikuakmâ konohâk otmu senŋe âlâlâ tatyiŋgiop ya menduhum konohân katŋetâ tatmu yaŋe mem tânahom manbi. ");
INSERT INTO spl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yawu manmâ Yesuŋe mumuŋambâ yahalop yakât den pat ya aposololipŋaŋe lohimbi belângen manbi ya ekyongoŋetâ nâŋgâŋetâ bulâŋe olop. Otmu Anitâŋe mâmâŋe otyiŋgimu kulem topŋe topŋe meŋetâ lohimbi kerekŋe yekmâ heroŋe nâŋgâyiŋgiwi. ");
INSERT INTO spl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Otmu senŋe âlâlâyeŋe kâsikum aŋgim tânahom manbi. Yakât otmâ lok âlâ me âlâŋe ki umburuk manbi. Lohimbi nombotŋaŋe senŋe âlâlâyeŋe puluhuŋetâ yapâ tewetsenŋe mem aposolo yiŋgiŋetâ galemguwi. ");
INSERT INTO spl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Otmu tewetsenŋe menduhuminiwi yapâ aposoloŋe mem lohimbi umburuk manbi ya tânyongoŋetâ manbi. ");
INSERT INTO spl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Otmu sâp yan Kipiro kapi amboŋe, lok âlâ, kutŋe Yosep sâm, yâkât yuwu sâmune nâŋgâ. Lok yakât kutŋe âlâmâ Banawa yawu sâm aposoloŋe kunminiwi. Kut yakât topŋeâmâ yuwu, “Biwi sânduk”. Yosep yâhâmâ Lewi senâmbâ gâtŋe yakât otmâ opon kâmbukŋahât âi mem manop. ");
INSERT INTO spl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yâkŋe ikŋe hân puluhuŋetâ yapâ tewetsenŋe mem aposolo yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lok âlâ, kutŋe Anania sâm, yâkât imbiŋe, kutŋe Sapira, biwi konohâk otmâ yuwu olowot. Hânyetŋe puluhuŋetâ yapâ tewetsenŋe miowot. ");
INSERT INTO spl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yawu gârâmâ tewetsenŋe nombotŋe ya mem mesambutmutâ tatyitgiop. Yâhâ nombotŋe âlâmâ Ananiaŋe mem ari aposolo yiŋgiop. ");
INSERT INTO spl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Otmu Petoroŋe yuwu sâm ekuop. “Anania, yuwu sâmune nâŋgâ. Girawu otmâ Bâleŋahât Amboŋe Satanŋe biwihan kioŋbe sâm otmu ki kârikŋe otmâ kinsat. Yetŋe Anitâhât Wâtgât mâmâŋahât Heak kâitgum hânyetŋe puluhuwi yakât tewetsenŋe nombotŋe mem mesambutmutâ tap. ");
INSERT INTO spl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hân ya ki puluhuwi yan yetŋe Anitâhât pat ki otbuap yawu nâŋgâm den hikuowot mâne tewetsenŋe alitsawot yuŋe âlepŋe otbâp. Yâhâ tewetsenŋe yuŋe Anitâhât pat otbuap yawu sâm kâitnongom nombotŋeâk katsawot. Yawu otmâ nen ki kâitnongoawot. Anitâ kâitguawot.” ");
INSERT INTO spl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Yawu sâmu Ananiaŋe den ya nâŋgâm yanâk mum iop. Mum imu lok nombotŋaŋe emet kâlehen yâhâm sâŋgum âlâ mem kurihim lâum ge hanguwi. Yâhâ Anitâ kâitguop yakât matŋe mum imu lohimbi yan kinbiŋe ekŋetâ sâtŋe olop. ");
INSERT INTO spl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Otmu ki kâlep otmuâk imbiŋaŋe lokŋahât den pat ki nâŋgâmâk Petorohâlen takaop. ");
INSERT INTO spl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Takamu Petoroŋe yuwu sâm âikuop. “Hânyetŋe puluhuŋetâ yapâ tewetsenŋe miowot ya lokgaŋe kerehâk ningiap me?” Sâmu sâop. “Wae, wonângen, kerehâk yiŋgiap yakâ.” ");
INSERT INTO spl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Sâmu Petoroŋe yuwu sâm âikuop. “Wongât yetŋe biwi konohâk otmâ Kutdâhât Wâtgât mâmâŋahât Heak kâitguawot? Yakât otmâ yuwu sâmune nâŋgâ. Lokge emelâk mumu lâum ari hangum pilâm ga gâhât mambotgihiai. Yiwereŋe gâhurâ mundâ lâuhekmâ ari hangohonomai.” ");
INSERT INTO spl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yawu sâm ekumu yâku yanâk kâiŋe topŋan purik sâm ge muop. Mumu lok ya emet kâlehen yâhâ Sapira lâum ge lokŋe lâum ge hanguwi yanâk lâum ge hanguwi. ");
INSERT INTO spl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Otmu muowot yakât den pat Yesuhât komotŋe nâŋgâŋetâ sâtŋe olop. Yawu. ");
INSERT INTO spl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo yâkŋe kulem topŋe topŋe meŋetâ lohimbiŋe ekŋetâ âlâ kândâkdâ olop. Otmu Yesuhât komotŋe biwiyeŋe kepeiakmâ konohâk otmu hilâm ârândâŋ Solomongât selep yan yâhâ menduhuakmâ Anitâ mepaeminiwi. ");
INSERT INTO spl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yawu otminiwi yan lohimbi dondâhâlâkŋe nâŋgâyiŋgiŋetâ yahalop yamâ Yura papatolipyeŋaŋe hilipnongomai sâm yâk yeŋgâlen ki torokatbi. ");
INSERT INTO spl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yawu gârâmâ lohimbi nombotŋaŋe Yesu Kutdânenŋahâlen biwiyeŋaŋe kepeim yâkât komolân torokatmâ manbi. ");
INSERT INTO spl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Otmu kapi ambolipŋaŋe bukulipyeŋe pareŋe otmâ manminiwi otmu tisi mesek otbi ya Yesuhât aposololipŋaŋe heŋgemyongoŋet sâm gerelân katyekmâ lâuyekmâ ari mâtâwân katyekŋetâ tatbi. Otmu yuwu nâŋgâwi. “Petoroŋe mâtâp watmâ gam ariwuap yan umutŋaŋe loŋgâeyekmu âlepŋe otnomai.” ");
INSERT INTO spl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Otmu Yerusalem hâlâŋmâ kapi tipi tapi tatmâ arap ya ambolipŋaŋe bukulipyeŋe tisi mesek otbi otmu weke bâleŋaŋe mâŋgâeyekmu manminiwi ya meyekmâ aposolo yeŋgâlen takaŋetâ heŋgemyongowi. ");
INSERT INTO spl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aposoloŋe yawu otbi yakât den pat ya hotom uminiwi ya yeŋgât kunyeŋe otmu ikŋe bukulipŋe Sarukaio komolân gâtŋaŋe nâŋgâŋetâ bâleop. ");
INSERT INTO spl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nâŋgâŋetâ bâlemu aposolo meyekmâ pâi emetŋan katyekŋetâ tatbi. ");
INSERT INTO spl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Katyekŋetâ tatŋetâ emet ŋiŋ sâmu iwi. Otmu omoŋ tânâmŋan Kutdâhât aŋelo âlâŋe mândeyekmu yahatŋetâ meyekmâ ge yaehen yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Yeŋe opon kâmbukŋan yâhâ manman kârikŋahât den pat âlepŋe ya topŋambâek lohimbi kâsikum yiŋginomai.” ");
INSERT INTO spl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yawu sâmu emet haŋ sâmu den ya lâum opon kâmbukŋan yâhâ Yesuhât den lohimbi kâsikum yiŋgiwi. Otmu hotom uminiwi yeŋgât kunyeŋaŋe bukulipŋe meyekmu Yura yeŋgât papatolipyeŋe yeŋgâlen ariŋetâ orowâk menduhuakmâ den emetŋan yâhâwi. Yâhâ tatmâ aposolo meyekmâ takaŋet sâm opon kâmbukŋahât tembe lâu nombotŋe hâŋgânyongoŋetâ pâi emetŋan yâhâwi. ");
INSERT INTO spl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Yâhâm pâinyekŋetâ biatmu âwurem taka yuwu sâm ekyongowi. ");
INSERT INTO spl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nen pâi emetŋan arim takain. Yâhâ pâi emetŋahât galem yaŋe gahatŋe kârikŋe maŋgum galem kinŋetâ yeksain. Yawu gârâmâ aposolo meyekne sâm takain,” sâm ekyongomunŋe gahatŋe mem pilâŋetâ kâlehen yâhâ pâinyekmunŋe biatsap.” ");
INSERT INTO spl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yawu sâŋetâ hotom uminiwi ya yeŋgât kunlipyeŋe otmu tembe lâu yeŋgât kunyeŋaŋe den ya nâŋgâm “Girawu otmâ gulip oai,” sâwi. ");
INSERT INTO spl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Yawu otmâ tatŋetâ yanâk lok âlâŋe taka yuwu sâm ekyongop. “Wâe, lok pâi emetŋan mem katyekbi ya opon kâmbukŋan yâhâ lohimbi den kâsikum yiŋgim kinŋetâ yeksain.” ");
INSERT INTO spl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yawu sâm ekyongomu yâkŋe opon kâmbukŋahât tembe lâu hâŋgânyongoŋetâ ari lohimbi kiŋgitŋe orowâkŋe denyeŋe nâŋgâm kinbi ya yekmâ “Yâkŋe kât mem nongomai” sâm aposolo ya lohotŋan meyekmâ den emetŋan ariwi. ");
INSERT INTO spl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Aposolo meyekmâ yâhâ Yura yeŋgât papatolipyeŋe yeŋgât senyeŋan katyekŋetâ kinŋetâ hotom uminiwi ya yeŋgât kunyeŋaŋe yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Oran Yesuhât den lohimbi ki kâsikum yiŋgiŋet sâm kuyiŋgiwin. Yamâ yeŋe nengât den ya kum Yesuhât den lohimbi kâsikum yiŋgiŋetâ yâkŋe sâm haok tuhuŋetâ lohimbi kapiân tai ya kerekŋe naŋgai. Otmu Roma tembe lâuŋe Yesu kuŋetâ muop yakât tosa ya nengâlen gâitsai.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Yawu sâŋetâ Petoroŋe purik pilâyiŋgim yuwu sâm ekyongop. “Yeŋgât den ya lâum Anitâhât den kunomgât dop âlâ ki tap. ");
INSERT INTO spl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yeŋgât sâtgât otmâ Roma lokŋe Yesu mem howanân kuŋetâ muop. Mumu hanguwi yamâ topŋe yuwuhât otmâ tâmbâlipnenŋe yeŋgât Anitâŋe mumuŋambâ mem yahalop. ");
INSERT INTO spl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Isirae lok nenŋe Yesuhâlen biwinenŋaŋe kepeimunŋe Anitâŋe tosanenŋe pilâningiwuapgât yâkŋe Kutdânenŋe Yesu mumuŋambâ mem yahatmu himbimân orowâk tawot. ");
INSERT INTO spl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yâhâ lohimbi âlâ me âlâŋe Yesuhâlen biwiyeŋaŋe kepeim Anitâhât denŋe lâum manmai ya yeŋgât nâŋgâm Anitâŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otyiŋgimap. Nenŋe yawu otmâ mansain yakât otmâ Wâtgât mâmâŋahât Heakŋe biwinenŋe mem sânduk tuhuningimap. Yawu otmâ mâmâŋe otningimu kulem topŋe topŋe mem mansain.” ");
INSERT INTO spl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yawu sâm ekyongomu nâŋgâŋetâ bâlemu aposolo yongone sâm otbi. ");
INSERT INTO spl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aposolo yongone sâm otŋetâ yan Parisaio lok kutdâ âlâŋe Mosehât girem den kâsikum yiŋgim manop, ya kutŋe Gamalie, yâkŋe yahatmâ kinmâ tembe lâulipyeŋe ekyongomu aposolo meyekmâ emet betŋehen ge kinŋetâ bukulipŋe yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","“Bukulipne, yeŋe lok yu in yawu mem bâleyekmaihât yuwu sâmune nâŋgâŋet. Yeŋe nâŋgâm heŋgeŋgumâmâ girawu otyiŋginomai yakât topŋe tetemu ekmâ nâŋgânomai. ");
INSERT INTO spl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Emelâk lok âlâ, kutŋe Teuta, ikŋahât nâŋgâmu yahatmu, “Roma lok kasalipnenŋe watyekmunŋe ariŋet” sâm lok 400 ekyongomu yâkâlen torokatbi. Yawu otŋetâ ikŋe kuŋetâ mumu loklipŋe itoŋ galaŋ otmâ kinbi. Yawu otmâ otŋetâ ki ihiop. ");
INSERT INTO spl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yakât betŋan Roma lok kunyeŋaŋe Yura nengât dopnenŋe nâŋgâwe sâm otmu sâlipnongowi sâp yan lok âlâ, Galilaia gâtŋe, kutŋe Yurasi, yâkŋe lohimbi meyekmu Roma lok watyekne sâm otbi. Yawu otmu yâkurâ yawuâk kuŋetâ mumu loklipŋe kerek yongom watyekŋetâ tiok taok otmâ ariŋetâ kutyeŋe bialop. ");
INSERT INTO spl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yakât otmâ yuwu sâmune nâŋgâŋet. Yeŋe aposolo yu ki yekmâ sâŋet. Yâkŋe yeŋe eŋgatyeŋeâk watmâ den ya lohimbi kâsikum yiŋgim gai otmuâmâ nep yu gulip otbuap. ");
INSERT INTO spl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yâhâ lok yuŋe Anitâhât sâtgât otmâ den yu lohimbi kâsikum yiŋgim gai otmuâmâ nep yu mem ge katyekne sâm otmunŋe hâi hâiŋe otmu pilânom. Otmu nep yukât amboŋe Anitâ mem ge katne sâm otnom. Biwinaŋe yawu naŋgan. Yawu.” ");
INSERT INTO spl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yawu sâm ekyongomu nâŋgâŋetâ ârândâŋ otmu tembe lâulipyeŋe ekyongoŋetâ aposolo yongowi. Yongom Yesuhât den pat âlepŋe ya lohimbi ki kâsikum yiŋginomai sâm kuyiŋgim pilâyekŋetâ ariwi. ");
INSERT INTO spl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Otmu aposoloŋe Yesuhât den pat âlepŋe lohimbi kâsikum yiŋgiwi yakât matŋe papatolipyeŋaŋe yongowi yakât nâŋgâŋetâ biwiyeŋe âlepŋe olop. ");
INSERT INTO spl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yawu otmâ hilâm ârândâŋ opon kâmbukŋan otmu emet tete yâhâm gem Yesu Kiristohât den pat âlepŋe ya kâsikum yiŋgim manbi. ");
INSERT INTO spl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sâp yan lohimbi kiŋgitŋe orowâkŋe Yesuhâlen biwiyeŋe katmâ yâkât komolân torokatmâ manbi. Manmâ senŋe âlâlâyeŋe konohân menduhuŋetâ tatmu yapâ mem tânahom manbi. Yawu gârâmâ Girik kapi ambolipŋe Yerusalem kapiân kandi taka tatbiŋe Yerusalem kapi ambolipŋe orop senŋe âlâlâ menduhum katminiwi yakât nekamân otbi. Nekamân otmâ Girik kapi ambolipŋaŋe yuwu sâwi. “Senŋe âlâlâ menduhum katmunŋe tap yapâ nep lokŋe mem nengât kambut ki dopŋan tânyongoai. Ya ekmunŋe dondâ bâleap.” ");
INSERT INTO spl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yawu sâŋetâ Yesuhât aposololipŋaŋe lohimbi ya menduhuyekmâ yuwu sâm ekyongowi. “Nenŋe senŋe âlâlâ menduhum katŋetâ tap yuâk galemgum mannom otmuâmâ Anitâhât den yu lohimbi kâsikum yiŋginomgât mâtâp ki tetewuap. ");
INSERT INTO spl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yakât otmâ Anitâhât Wâtgât mâmâŋahât Heakŋe mâmâŋe otyiŋgimu mansai komot yapâ gâtŋe lok nombolân yâhâp mem teteyekŋetâ nep yiŋgimunŋe senŋe âlâlâ yu galemgum kambulipyeŋe kâsikum yiŋginomai. ");
INSERT INTO spl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yawu otŋetâ benŋe nenŋeâmâ Yesuhât den lohimbi kâsikum yiŋgim Anitâ ulitgum mannom.” Yawu sâwi. ");
INSERT INTO spl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Den yawu sâŋetâ nâŋgâŋetâ ârândâŋ olop. Yakât otmâ lok mem katyekbi ya yeŋgât kutyeŋe yamâ yuwu. Setepano yâkŋe Yesuhâlen biwiŋaŋe tiŋâk kepeim Anitâhât den lâum manop. Yawu manmu Anitâhât Wâtgât mâmâŋahât Heakŋe mâmâŋe otbaŋgim gaop. Otmu nombotŋe âlâmâ kutyeŋe yuwu. Pilip, Porokoro, Nikano, Timon, Pamena, otmu bâiŋeâmâ Nikolao. Nikolao yamâ Antiok kapi pilâm Yura yeŋgâlen torokatmâ Anitâ mepaem manmâ gaop. ");
INSERT INTO spl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Lok yu meyekmâ aposolo yeŋgâlen gaŋetâ yâkŋe kunyeŋan mem Anitâ ulitguwi. ");
INSERT INTO spl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Otmu Yesuhât komotŋe yâkât den pat âlepŋe sâm haok tuhuŋetâ lohimbi kiŋgitŋe orowâkŋe Yesuhâlen biwiyeŋe katmâ yâk yeŋgâlen torokatŋetâ sambe sambe otbi. Yawu otmâ hotom uminiwi yeŋgâlen gâtŋe dondâŋe denyeŋe ya nâŋgâŋetâ bulâŋe otmu Yesuhâlen biwiyeŋe katbi. ");
INSERT INTO spl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Anitâŋe Setepano nâŋgâwaŋgim mâmâŋe otbaŋgimu kulem topŋe topŋe memu lohimbiŋe ekŋetâ âlâ kândâkdâ olop. ");
INSERT INTO spl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yawu gârâmâ lok nombotŋe Kirene, Alesandiria, Liwia, Kilikia, Asia, kapi yu ambolipŋaŋe opon kâmbukŋan yâhâ Setepanohât den kakŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Den kakŋan sâŋetâ Wâtgât mâmâŋahât Heakŋe Setepano mâmâŋe otbaŋgimu den sâmu denyeŋe ya kum ge kalop. ");
INSERT INTO spl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yawu otyiŋgimu ari lok yaŋe lok nombotŋe mem teteyekmâ eŋgatyeŋan geŋetâ yâkŋe yuwu sâm Setepano hakŋan sâm lohimbi ekyongowi. “Setepanoŋe Mosehât girem den kelaŋgatmâ den aŋgo lohimbi kâsikum yiŋgimap. Otmu Anitâhât opon kâmbukŋahât nâŋgâmu gemu Anitâ sâm bâlewaŋgimu naŋgain.” ");
INSERT INTO spl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yawu sâŋetâ Yura yeŋgât papatolipyeŋe otmu Mosehât girem den kâsikum yiŋgiminiwi otmu lohimbi nombotŋaŋe nâŋgâŋetâ biwiyeŋe kou kâlâp semu Setepano mem den emetŋan yâhâ den âiân katbi. ");
INSERT INTO spl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Den âiân katmâ aŋgoân lok eŋgatyeŋan gewi ya ekyongoŋetâ ga Setepano hakŋan yuwu sâwi. “Lok yuŋe haoŋmâ ârândâŋ Anitâhât opon kâmbukŋahât nâŋgâmu gemu Mosehât girem den sâm ge katmap. ");
INSERT INTO spl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yuwu sâmu naŋgain. “Yesu Nasaret kapi amboŋaŋe opon kâmbukŋe huhum itoŋ galaŋ tuhuwuap. Otmu Moseŋe girem den otmu opon kâmbukŋahât orotmeme sâm ningiop ya kum orotmeme aŋgo ningiwuap.” Yawu sâmu naŋgain.” Yawu sâm Setepano hakŋan sâwi. ");
INSERT INTO spl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Hakŋan sâŋetâ menduhuakbiŋe Setepano ekŋetâ yâkât kundenŋaŋe aŋelo kundenŋe yawuya teteop. ");
INSERT INTO spl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Hotom uminiwi ya yeŋgât kunyeŋaŋe Setepano yuwu sâm âikuop. “Den yai yu bulâŋe yai me?” ");
INSERT INTO spl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sâmu Setepanoŋe yahatmâ yuwu sâop. “Papatolipne otmu bukulipne den sâmune nâŋgâŋet. Tâmbânenŋe Awaraham yâkŋe Mesopotamia kapi ki pilâm Haran kapiân ariop sâp yan Anitâ yahat yahatŋe, Laŋinŋe Amboŋaŋe tetewaŋgim yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Gâŋe kapihe tâmbâŋe, hep torehenlipge, bukulipge pilâyekmâ nâŋe kapi âlâ tiripgohowom yan ari manbuat.” ");
INSERT INTO spl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yawu sâmu tem lâuwaŋgim Kairia hân pilâm Haran kapiân ari manop. Yan manmâ âwâŋe bâleop. Âwâŋe bâleop yakât kakŋan Anitâŋe yâhâpŋe tetewaŋgim yuwu sâm ekuop. “Hân âlâen ari in kandi manbuat.” Yawu sâm ekumu yahatmâ Haran kapi pilâm nenŋe mansainân yuân emelâk takaop. ");
INSERT INTO spl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yuân taka kandi manop. Yâhâ Awarahamŋe imbiŋâit kâsi manoworâke yamâ benŋe yâkât tepŋan gâtŋaŋe hân yu ambokunomaihât Anitâŋe pat kuwaŋgiop. ");
INSERT INTO spl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yawu otmâ den âlâ yuwu sâm ekuop. “Gâhât senŋe hân yu pilâm kapi âlâen ari manmâ kapi ambolipŋe hoŋ bayiŋgim manmâ yâhâŋetâ yambu 400 pesuk sâwuap. ");
INSERT INTO spl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Hoŋ bayiŋgim manŋetâ hâhiwin yiŋginomai. Yakât otmâ nâŋe lohimbi ya matŋe umatŋe yiŋgimune pilâyekŋetâ âwurem hân yuân taka manmâ nâhât tem lâunihim mepaenekmâ mannomai.” ");
INSERT INTO spl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yawu sâm ekum pat kuwaŋgiop. Pat kuwaŋgiop ya nâŋgâm mannomaihât hâkyeŋahât torehenŋan undip tuhuaŋgim manmâ yâhânomai ya sâm kalop. Otmu yakât kakŋan Awaraham nanŋe Isaka tetemu hilâm nombolân kalimbu pesuk sâmu hâkŋahât torehenŋan undip tuhuwaŋgiop. Otmu Isaka nanŋe Yakop tetemu yâk gurâ yawuâk hâkŋahât torehenŋan undip tuhuwaŋgiop. Otmu Yakop nanlipŋe kâiân yâhâp teteŋetâ yâk gurâ yawuâk hâkyeŋahât torehenŋan undip tuhuyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Otmu Yosep atalipŋaŋe yâkât hâkâŋ otmâ mem âlâlâ tuhuwi. Yawu tuhum lok nombotŋaŋe taka Yosep puluhum dâim Aihita hânân ariwi. Atalipŋaŋe yawu otbaŋgiwiâke yamâ Anitâŋe tihitŋe olop. ");
INSERT INTO spl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Otmu nâŋgân nâŋgânŋe pato tetewaŋgimu Aihita lok nombotŋaŋe ekŋetâ âlâ kândâkdâ otmu kunyeŋe, kutŋe Parao sâm, yâkâlen dâim ariwi. Dâim ariŋetâ Anitâŋe mâmâŋe otbaŋgimu Paraoŋe yâkât orotmemeŋe ekmu ikŋan gâtŋe otmu ikŋe emet otmu Aihita kapi ambolipŋe ya galemyongom manâkgât âi sâm waŋop. ");
INSERT INTO spl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Otmu sâp yan Aihita otmu Kanan hân yuân po pato teteop. Yawu tetemu tâmbâlipnenŋaŋe sotgât umburuk otbi. ");
INSERT INTO spl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yawu manmâ Aihita hânân sot tap yawu sâŋetâ nâŋgâm Yakopŋe nanlipŋe yan hâŋgânyongomu ariwi. ");
INSERT INTO spl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aihita arim âwurem taka yakât den pat âwâyeŋe ekuŋetâ manmâ manmâ benŋe âlâkuâk hâŋgânyongomu ariwi. Ariŋetâ Yosepŋe atalipŋe teteyiŋgim ikŋahâk topŋe sâm tetem ekyongop. Teteyiŋgim atalipŋe dâiyekmâ Paraohâlen ariŋetâ topyeŋe sâm tetemu nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yakât kakŋan Yosepŋe âwâŋahât den katmu âwâŋaŋe ikŋe senŋe âlâlâŋe otmu hep torehenlipŋe lohimbi 75 meyekmu Aihita hânân ariwi. ");
INSERT INTO spl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yan ari manmâ Yakop ya muop. Otmu nanlipŋe gurâ yawuâk muwi. ");
INSERT INTO spl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Otmu emet inânŋan Awarahamŋe Sikem kapiân Hemohât nanlipŋe yeŋgâlen hân âlâ puluhuop yan hahityeŋe lâum ari kurihiyekbi. ");
INSERT INTO spl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","Tâmbâlipnenŋaŋe Aihita hânân tetem sambe sambe otbi. Yawu otmâ manŋetâ Anitâŋe Awarahamgât pat kuwaŋgiop yakât bulâŋe menomaihât sâp ya tâlâhuop. Sâp yan Aihita yeŋgât kunyeŋe âlâ belângen tetem manopŋe Yosepgât topŋe ki nâŋgâop. ");
INSERT INTO spl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Lok yaŋe tâmbâlipnenŋe mem ge katyekmâ hâhiwin yiŋgiop. Otmu nimnaomlipyeŋaŋe tetem sambe sambe otmai sâm nanlipyeŋe tetewi ya lâum kapi betŋehen pilâyekŋetâ muwi. ");
INSERT INTO spl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Yawu gârâmâ tâmbânenŋe Mose tetemu âwâŋe mâmâŋaŋe emetyetŋan tihâk mesambutmutâ tatmu emetsenŋe kalimbu pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Emetsenŋe kalimbu pesuk sâmu hahitŋe tiŋ tiŋ sâmu ekmutâ iwit nanŋe olop. Yawu otmu saka saka kum kâlehen katmâ toen kalowot. Toen katmutâ to kakŋan yoloŋ yoloŋ otmâ bam gam tatmu Parao baratŋaŋe ekmâ mem taka ikŋahâk galemguop. ");
INSERT INTO spl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Lok otmâ Parao loklipŋe yeŋgât nâŋgân nâŋgân emetŋan yâhâmu den kâsikum waŋetâ nâŋgân nâŋgân pato miop. Nâŋgân nâŋgân pato memu Aihita ambolipŋaŋe ekŋetâ sâtŋe otmu ewe katminiwi. ");
INSERT INTO spl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Manmu yambu lok yâhâp ŋerek pesuk sâmu Isirae bukulipŋe girawu mansai sâm yâk yeŋgâlen ari yehop. ");
INSERT INTO spl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Arim yekmu Aihita lok âlâŋe Isirae lok âlâ kumu ekmâ Isirae lok ya tângum Aihita lok ya kumu muop. ");
INSERT INTO spl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kumu mumu biwiŋaŋe yuwu nâŋgâop. “Anitâŋe mâmâŋe otnihimu bukulipne tânyongom Paraohât bâtŋambâ dâiyekmune hân âlâengen ari nenŋahâk galemahom mannom ya nâŋgâm heŋgeŋguai,” biwiŋaŋe yawu nâŋgâop. Yawu gârâmâ Isirae lohimbiŋe ya ki nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Aiop, emet haŋ sâmu Moseŋe âlâkuâk ari Isirae lok yâhâp ahom tatmutâ mem teteyelehop. Yawu otmutâ mem hâreyelekmâ yuwu sâm ekyotgop, “Wongât yetŋe ahoawot?” ");
INSERT INTO spl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yawu sâmu kapam kândikuopŋe yuwu sâm denŋe kakŋan sâop. “Gâ ki nâŋgâhihiain. Âlâŋe galem sâm katgekmu takat? ");
INSERT INTO spl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Oran Aihita lok âlâ kundâ muop yawuâk nohowe sâm oat hâ?” ");
INSERT INTO spl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yawu sâmu nâŋgâm Moseŋe Aihita hân pilâm Mirian hânângen ari manop. Yan manmâ imbi âlâ yaken gâtŋe memu yâkŋe nanyâhâtŋe yâhâp meyelehop. ");
INSERT INTO spl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Manmâ gamu yambu lok yâhâp ŋerek pesuk sâmu hân ya pilâm lok ki manmaiângen ariop. Yan ari Sinai pumŋe topŋan kinmu aŋelo âlâŋe nak topŋan kâlâp semu yan tetem kinmu ehop. ");
INSERT INTO spl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ekmu sâtŋe otmu “Enda wonŋe oap?” sâm ya ekmâ heŋgeŋguwe sâm gotŋan bamu Kutdâŋe yuwu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nâmâ Awaraham, otmu nanŋe Isaka, otmu seseŋe Yakop yâk yeŋgât kunyeŋe tatmâ gaman.” Yawu sâmu Moseŋe kâiŋe bâtŋe sân sân sâmu senŋe kâtâpgum kâmgum kinop. ");
INSERT INTO spl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yawu otmâ kinmu Anitâŋe yuwu sâm ekuop. “Hân kinsat yu kâmbukŋe. Yakât otmâ kâihe katipŋe tuhum pilâ. ");
INSERT INTO spl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yuwu sâmune nâŋgâ. Komolipne Aihita hânân manŋetâ kapi ambolipŋaŋe yongom mem âlâlâ tuhuyekŋetâ manmâ gai. Yawu manmâ gaŋetâ yekmâ umatŋe yapâ holaŋyekbe sâm gâ tetehihian. Yakât otmâ mâmâŋe otgihim hâŋgângohomune Aihita hânân âwurem ari tânyongowuat.” Anitâŋe yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yâhâ Moseŋe Aihita hânân talop yan Isirae lok âlâŋe yâkât nâŋgâmu gemu yuwu sâm ekuop. “Âlâŋe galem sâm katgekmu takat?” yawu sâop. Yawu gârâmâ Moseŋe bukulipŋe tânyongom kasalipyeŋe yeŋgât bâtyeŋambâ dâiyekmu hân âlâengen ari mannomai sâm nak topŋan kâlâp siop yan aŋelo âlâŋe tetewaŋgim kinmâ mâmâŋe otbaŋgiop. ");
INSERT INTO spl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Anitâŋe Mose hâŋgângumu Aihita hânân âwurem ari kulem âlâlâ memu ekŋetâ sâtŋe kârikŋe olop. Yawu otmâ bukulipŋe dâiyekmu Aihita hân pilâm taka saru âlâ, kutŋe saru kuriŋ sâm, yan kulem âlâ memu ekbi yamâ yuwu. Anitâŋe nâŋgâmu to ya keterakmâ torehen torehen otmu mâtâp teteop. Yawu otmu kâiyeŋe hân liŋmâ nombotgen takawi. Taka lok ki manmaiângen manŋetâ Moseŋe kulem topŋe topŋe mem gamu yambu lok yâhâp ŋerek pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Otmu Moseŋe tâmbâlipnenŋe yuwu sâm ekyongop. “Anitâŋe hâŋgânnohomu taka tânyongomune âlepŋe mansai yuwuâk nengât komolân gâtŋe âlâ hâŋgângumu yâkât den kâsikum yiŋgim tihityeŋe otbuap.” ");
INSERT INTO spl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yawu sâm ekyongop. Otmu Moseŋe tâmbâlipnenŋe orop lok ki manmaiângen manmâ Anitâhât den kâsikum yiŋgim gaop. Otmu ikŋe Sinai pumŋan yâhâmu aŋelo âlâŋe Anitâhât girem den kârikŋe sâm ekumu âwurem ge ekyongop. ");
INSERT INTO spl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Anitâhât den ya ekyongop yamâ benŋe papatolipnenŋaŋe biwiyeŋe kârikŋe otmâ den ya hâkâŋ otmâ Mose betbaŋgim Aihita hânângen âwurem arine sâm otbi. ");
INSERT INTO spl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yawu otŋetâ Moseŋe âlâkuâk katyekmâ Sinai pumŋan yâhâop. Pumŋan yâhâ Anitâ orop den alahumutâ lohimbi yaŋe Mose imiŋe, kutŋe Aron sâm, yuwu sâm ekuwi. “Moseŋe Aihita hânângembâ dâim taka katnenekmâ nengât ki nâŋgâm gulip oap. Yakât otmâ gâŋe nak âlâ mem hâwim kânâŋgârâ kinmu mepaene. Yawu otmâ lâum âwurem Aihita hânân arinom.” ");
INSERT INTO spl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yawu sâm ekuŋetâ bulimakao umutŋe hâwim kânâŋgâmu kinmu sot um gotŋan katmâ heroŋe otbaŋgim mepaewi. ");
INSERT INTO spl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yawu otŋetâ Anitâŋe yekmu bâlemu betyiŋgimu biwiyeŋe gulip otmu pitu mepaewi. Yawu otbi yakât poropete âlâŋe den yuwu kulemguop. “Anitâŋe yuwu yap. Isirae ambolipŋe yuwu sâmune nâŋgâŋet. Yen lok ki manmaiângen manmâ bulimakao ki gâim nâhât hotom um gawi. Yawu otmâ kasalipyeŋe yeŋgât Porom Lâpiohât hotom um manmâ gaŋetâ yambu lok yâhâp ŋerek pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Otmu pitu mepaem yan kasalipyeŋe yeŋgât Porom Lâpioyeŋe, kutyetŋe Molok yet Lepan, ya yetgât umutyetŋe hâwim selep tuhum yakât kâlehen lâum kânâŋgâyelekŋetâ kinmutâ mepaeyelekbi. Mepaeyelekbi yakât matŋe sâmune Bawilon kapi ambolipŋaŋe taka meyekmâ kapiyeŋan ariŋetâ yeŋe yâk hoŋ bayiŋgim mannomai.” Anitâŋe yawu yap.” Den yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Emelâk embâŋân tâmbâlipnenŋaŋe Aihita hân pilâm lok ki manmaiângen taka manŋetâ Anitâŋe ikŋe selep tuhuŋet sâm yakât topŋe Mose ekuop. Topŋe ekuop yawuâk watmâ tuhuwi. ");
INSERT INTO spl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tâmbâlipnenŋaŋe yakât kâlehen yâhâ mepaeminiwi. Yawu otmâ manmâ gaŋetâ benŋe Yosuaŋe galemyeŋe olop sâp yan Anitâŋe mâmâŋe otyiŋgimu kasalipyeŋe yongom watyekŋetâ ariŋetâ selep ya yan lâum taka katmâ mepaem manbi. Yawu otmâ manmâ gaŋetâ lok kutdâ âlâ, kutŋe Dawiti sâm, yâkŋe galemyongop. ");
INSERT INTO spl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawitiŋe galem yongom manmu Anitâŋe ekmu ârândâŋ olop. Yakât otmâ opon kâmbukŋe pato tuhuwaŋgiwe sâm Anitâ ekuop. ");
INSERT INTO spl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ekumu ki nâŋgâwaŋgiop. Yakât otmâ Dawiti nanŋe, kutŋe Solomon sâm, yâkŋe opon ya tuhuwaŋgiop. ");
INSERT INTO spl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yakât otmâ yuwu sâmune nâŋgâŋet. Anitâ ambonenŋe yahat yahatŋe nenŋe emet me opon mem kânâŋgâmain yan ki tatmap. Yakât otmâ Anitâŋe poropete âlâ yuwu ekumu kulemguop. ");
INSERT INTO spl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","“Nâ ninahâk hân himbim kândikyotgowan. Otmu senŋe âlâlâ saruân hikiân tatmap ya ninahâk katyekban. Nâ himbimân otmu hânân ârândâŋ otmâ tan. Yawuhât opon kâmbukŋan yâhâ tat sâm tuhunihiŋetâ ârândâŋ otbuapgât dop âlâ ki tap. Nâŋe oponân ki tatman.” Den yawu kulemguop tap. ");
INSERT INTO spl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Yen biwiyeŋe kârikŋe. Biwi nâŋgân nâŋgânyeŋe ki pâroŋ yap. Tâmbâlipyeŋaŋe Anitâhât Wâtgât mâmâŋahât Heak betgum manbi yen gurâ yawuâk otmâ manmâ gai. ");
INSERT INTO spl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Emelâk emet inânŋan Anitâhât poropetelipŋaŋe ikŋe hoŋ bawa âlâ tetem koko salek manbuap yakât den pat kulemguwi ya kerehâk tâmbâlipyeŋaŋe hilipyongowi. Otmu yakât bulâŋeâmâ Yesu teteop ya yeŋe betbaŋgim howanân kuŋetâ muop. ");
INSERT INTO spl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Otmu Anitâŋe ikŋe aŋelolipŋe hâŋgânyongomu ge girem den poropete ekyongoŋetâ yâkŋe kulemguwi ya yeŋe ki lâum mansai. Yawu.” ");
INSERT INTO spl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Setepanoŋe den yawu sâm ekyongomu biwiyeŋan hâumu kuk nâŋgâwaŋgiwi. ");
INSERT INTO spl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yawu otŋetâ Anitâhât Wâtgât mâmâŋahât Heakŋe mâmâŋe otbaŋgimu himbimân senŋe pilâm eksan mâne Yesu Anitâ orop tatmutâ yelekmu âlâ kândâkdâ otmu yuwu sâm ekyongop. ");
INSERT INTO spl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Himbim pâroŋ sâmu Yesu, lok bulâŋe, Anitâ orop tatmutâ yeleksan.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Yawu sâmu “Den kâmbukŋe hâliliŋe yap” sâm lâum dâim kapi betŋehen gewi. Kapi betŋehen gem kunlipyeŋaŋe yeŋe hâk katipŋe kâkâlep katbi ya tuhum pilâm lok pato âlâ, kutŋe Saulo sâm, yâkât kâiŋe topŋan katŋetâ tatmu kât mem kuwi. ");
INSERT INTO spl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Setepano ya kâtŋe kuŋetâ Yesu ulitgum yuwu sâop. “O Kutdâ Yesu, umutne me.” ");
INSERT INTO spl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yawu sâm pilakbe sâm otmâ yuwu sâop. “Kutdâ, tosa pilâyiŋgihât naŋgan.” Yawu sâm pilahop. Kuŋetâ mumu Sauloŋe nâŋgâmu ârândâŋ olop. ");
INSERT INTO spl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Setepano kuŋetâ muop yan lok nombotŋe Anitâhât tem lâum manbiŋe isem lâum sumyeŋan ari hanguwi. Otmu Sauloŋeâmâ Yesuhât komot hilipyongowe sâm emet ârândâŋ yâhâm gem pâinyehop. Otmu nombotŋe mem teteyekmâ tembe lâulipŋe ekyongomu meyekmâ ari pâi emetŋan katyekbi. Yawu otyiŋgiŋetâ lohimbi nombotŋaŋe Yerusalem kapi pilâm itoŋ galaŋ otmâ kapi tipi tapi Yuraia Samaria hânân tatmâ arap yan arim kinbi. Yâhâ Yesuhât aposololipŋeâmâ Yerusalem kapiânâk tatbi. ");
INSERT INTO spl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesuhât komot Yerusalem kapi pilâm itoŋ galaŋ otmâ ariwi yaŋe Yesuhât den pat âlepŋe kapi ambolipŋe ekyongowi. ");
INSERT INTO spl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","6","Yawu otbi yan yâk yeŋgâlen gâtŋe lok âlâ, kutŋe Pilip sâm, yâkŋe Samaria yeŋgâlen ari Yesuŋe tihitnenŋe olâkgât Anitâŋe hâŋgângumu giop yakât den pat ekyongop. Den pat ya ekyongom kulem topŋe topŋe memu lohimbiŋe ekŋetâ âlâ kândâkdâ otmu denŋe nâŋgâŋetâ bulâŋe olop. ");
INSERT INTO spl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Otmu lohimbi nombotŋe weke bâleŋaŋe mâŋgâeyekmu manminiwi ya watyiŋgimu gaiakmâ ariwi. Yâhâ lohimbi nombotŋe âlâmâ senyeŋe bok sâsâŋe otmu pareŋe otmâ tatminiwi ya mem heŋgemyongop. ");
INSERT INTO spl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yawu otyiŋgimu kapi ambolipŋaŋe biwiyeŋe heroŋe olop. ");
INSERT INTO spl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Yâhâ kapi yan lok kâmbukŋe âlâ manop, kutŋe Simon sâm, yâkŋe ikŋe mepaeakmâ hawat topŋe topŋe tuhuyiŋgimu ekŋetâ sâtŋe otminiop. ");
INSERT INTO spl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Yakât otmâ kapi ambolipŋe, lok geheŋe yahat yahatŋe, lok kutyeŋe orop, kutyeŋe bia, kerehâkŋe yâkât nâŋgâŋetâ yahatmu yuwu sâm mepaeminiwi. “Wâtge kârikŋe tatgihiap. Yakât otmâ gekmunŋe Anitâhât dop oap.” Yawu sâm yâkât kutŋe “Wâtgât Amboŋe,” sâm yâkât nâŋgâŋetâ yahatmu manminiwi. ");
INSERT INTO spl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aiop, Anitâŋe tihitnenŋe otbe sâm Yesu hâŋgângumu giop yakât den pat âlepŋe Pilipŋe ekyongomu nâŋgâŋetâ bulâŋe otmu Yesu Kiristohâlen biwiyeŋaŋe kepeiŋetâ toen katyehop. ");
INSERT INTO spl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Yâhâ Simon lok kâmbukŋe ya gurâ yawuâk Yesuhâlen biwiŋe katmu toen kalop. Toen katmu yâkŋe Pilip orop manmâ kulem topŋe topŋe memu ekmu âlâ kândâkdâ otmu yakâlâk nâŋgâm manop. ");
INSERT INTO spl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria kapi ambolipŋaŋe Anitâhât den nâŋgâŋetâ bulâŋe otmu biwiyeŋe Yesuhâlen katbi yakât den pat sâm haok tuhuŋetâ Yerusalem kapiân arimu aposoloŋe nâŋgâwi. Pat ya nâŋgâm lohimbi yaŋe Yesu Kiristohâlen biwiyeŋaŋe tiŋâk kepeim manŋetgât Petoro yet Yoane hâŋgânyotgoŋetâ ariowot. ");
INSERT INTO spl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Arimutâ topyeŋe yuwu sâm ekyotgowi. “Emelâk biwinenŋe Kutdânenŋe Yesuhâlen katmunŋe yâkât kulân toen katnenekbi. Toen katnenekbi yan Anitâhât Wâtgât mâmâŋahât Heakŋe ki ge mâmâŋe otningiop.” Yawu sâm ekyotgoŋetâ nâŋgâm Wâtgât mâmâŋahât Heakŋe ge mâmâŋe otyiŋgiâkgât kunyeŋan meyekmâ Anitâ ulitguowot. Kunyeŋan meyekmâ Anitâ ulitgumutâ ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otyiŋgiop. ");
INSERT INTO spl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Mâmâŋe otyiŋgimu Simonŋe ya ekmu âlâ kândâkdâ otmu yawuâk otbehât nâŋgâm tewetsenŋe mem ari yuwu sâm âiyotgop. “Nâŋe lohimbi kunyeŋan meyekmune yawuâk Anitâhât Wâtgât mâmâŋahât Heakŋe ge mâmâŋe otyiŋgiâkgât tewetsenŋe yu yitgimune nâŋgânihimutâ nâku yawuâk otbom.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","21","Yawu sâmu Petoroŋe yuwu sâm ekuop. “Anitâŋe ikŋe Wâtgât mâmâŋahât Heak hâŋgângumu ge mâmâŋe otyiŋgimap ya gâŋe tewetsenŋaŋe puluhuwuatgât dop âlâ ki tap. Anitâŋe biwihe ekmu ki ârândâŋ otmu kâlâpgât pat mansat. Yakât otmâ netgâlen ki torokatbuat. Tewetsenŋe ya miakmâ ari. ");
INSERT INTO spl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Biwihahât topŋe yuwu naŋgan. Netŋe kunyeŋan meyekmutŋe kulem tetemu ekdâ biwihe bâleap. Yâhâ yawuâk biwi bâle otmâ mandâ Anitâŋe yakât matŋe gihimu mem hiliwahomatgât nâŋgân nâŋgânge bâleŋe ya pilâm biwihe Yesuhâlen kepeim ulitgu. Yawu.” ");
INSERT INTO spl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sâmu sâop. “Den yat yu tetenihimapgât yetŋak nâŋgânihim Anitâ ulitguyet.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aiop, Petoro yet Yoaneŋe Yesuhât den pat âlepŋe kâsikum yiŋgim Yerusalem kapiân âwurem ariowot. Otmu mâtâwân ariowot yan kapi tipi tapi mâtâp hâlâŋmâ tatmâ arap ya ambolipŋe Yesuhât den pat âlepŋe ekyongomutâ nâŋgâwi. ");
INSERT INTO spl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Otmu yakât kakŋan kulem âlâ Pilipgâlen teteop yakât sâmune nâŋgâ. Aiop, Yerusalem kapi pilâm Gasa kapiân geminiwi mâtâp ya ki arim takam tatŋetâ aŋgom kâtiŋ sâop. Yâhâ ki kâtiŋ sâop sâp yan Anitâhât aŋelo âlâŋe Pilip tetewaŋgim yuwu sâm ekuop. “Gâŋe yahatmâ emet kakŋe ari Yerusalem kapi pilâm Gasa kapiân gemai mâtâp yawuâk watmâ ariwuat.” Yawu sâm ekuop. ");
INSERT INTO spl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Yawu sâm ekum hâŋgângumu ariop. Aiop, Itiopia kapi ambolipŋe yeŋgât imbi kutdâ âlâ manop, kutŋe Kandake. Otmu Kandakeŋe ikŋe tewetsenŋahât galem pato âlâ hâŋgângumu Yerusalem kapiân ari opon kâmbukŋan yâhâ Anitâ mepaem hotom uwaŋgiop. Hotom uwaŋgim pesuk pilâm ikŋe hân waŋgaŋe beâsi betŋehen hikum pilâŋetâ dâiop yan yâhâ tatmu dâimu kapiŋan âwurem ariwe sâm olop. Mâtâwân arim tatmâ emet inânŋan Anitâŋe poropete âlâ, kutŋe Yesaia, den ekumu kulemguop ya mem mewalakum sâlikuop. Tatmâ sâlikum gemu Pilipŋe ehop. ");
INSERT INTO spl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ekmu yan Anitâhât Wâtgât mâmâŋahât Heakŋe yuwu sâm Pilip ekuop. “We, beâsiŋe hân waŋgaŋe dâim arap endan bam ek.” ");
INSERT INTO spl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Yawu sâm ekumu Pilipŋe sururuk sâm ari lok yaŋe den sâlikuop ya ekmâ yuwu sâm âikuop. “Den sâlikuat yakât topŋe naŋgat me?” ");
INSERT INTO spl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Sâmu sâop. “Wâe, lok âlâŋe yukât topŋe sâm kusânmâ eknohomu nâŋgâmbâm. Yakât otmâ gâŋe hân waŋgaŋan garâ orowâk tatmâ topŋe eknohoâyâ.” Yawu sâmu Pilipŋe yâhâ hâlâŋbaŋgim tatmu orowâk ariowot. ");
INSERT INTO spl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Otmu emelâk embâŋân Anitâŋe Yesaia den yuwu sâm ekumu kulemguop. “Lama kum gâine sâm yan lohotŋan tatmu lâum arimai yakât dopŋeâk lok âlâ kune sâm otŋetâ lohotŋan kinop. Yawu otmu ki den nepŋe pato otmâ in yawu lâum ari kuwi. Otmu lama kune sâm otmâ aŋgoân somotŋe hâreŋetâ pâlâmŋe tatmap. Yakât dopŋeâk yâkŋe pâlâmŋe otmâ denyeŋe kakŋan ki sâop. Yâhâ kuŋetâ muowâke yamâ benŋe lohimbi kiŋgitŋe orowâkŋe yâkâlen biwiyeŋaŋe kepeim mannomai ya sâlipyongonomaihât dop âlâ ki tap.” Den yawu kulemguop. ");
INSERT INTO spl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Den ya sâlikum lok kutdâ yaŋe yuwu sâm Pilip âikuop. “Anitâŋe âlâhât nâŋgâm poropete ekumu den yu kulemguop? Poropete ikŋahât me lok âlâhât sâop?” ");
INSERT INTO spl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yawu sâm âikumu den ya sâm kusânmâ Yesuhât den pat âlepŋe ya ekumu nâŋgâm ariowot. ");
INSERT INTO spl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ari to âlâ mâtâp ginŋan giop yan arimutâ lok kutdâ yaŋe ekmâ yuwu sâm ekuop. “E, nâ toen katnekgât naŋgan. Ya nâŋgârâ girawu oap?” ");
INSERT INTO spl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Sâmu sâop. “Biwihe Yesuhâlen katsat otmuâmâ, âlepŋe kioŋmâ toen katgekbom.” Sâmu sâop. “Yesu yamâ Anitâ nanŋe. Yakât otmâ emelâk biwine yâkâlen katsan.” ");
INSERT INTO spl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yawu sâm beâsi mem sânduk pilâmu kinmu hân waŋgaŋambâ kioŋmâ toen giowot. Ge Pilipŋe mem toen kalop. ");
INSERT INTO spl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Otmu toembâ gamutâ yan Anitâhât Wâtgât mâmâŋahât Heakŋe Pilip lâum âlâengen arimu lok yaŋe ekmu bialop. Ekmu biatmu biwi heroŋe pato nâŋgâm ariop. ");
INSERT INTO spl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Otmu Anitâhât Wâtgât mâmâŋahât Heakŋe Pilip lâum Asito kapiân ari katmu kinop. Otmu Pilipŋe kapi ya ambolipŋe otmu kapi tipi tapi ya hâlâŋmâ tatmâ arap ya ambolipŋe Yesuhât den pat âlepŋe ekyongop. Yawu otmâ benŋe Kaisaria kapiân ariop. ");
INSERT INTO spl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sâp yan Sauloŋe biwiŋe kâlâp semu Kutdâhât komot hilipyongowe sâm otmâ manop. ");
INSERT INTO spl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Yawu gârâmâ Damasiko kapiân ari Yesuhât komot pâinyekbe sâm otmâ hotom uminiwi ya yeŋgât kunyeŋe yâkâlen ari yakât ekuop. Ekumu lauŋan mem pepa âlâ kulemgum Saulo waŋop yakât topŋe yuwu. Sauloŋe pepa ya mem ari Yura yeŋgât papatolipyeŋe Damasiko kapiân manbi ya yiŋgimu yâkŋe nâŋgâwaŋgiŋetâ yanâmâ Yesuhât komot Damasiko kapiân manbi ya meyekmâ Yerusalem kapiân âwurem taka pâi emetŋan katyekmu tatnomai. Topŋe yawu. ");
INSERT INTO spl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pepa ya mem Yerusalem kapi pilâm ariop. Mâtâwân ari Damasiko kapi ya tâlâhumuâk otmu yanâk himbimâmbâ laŋinŋe âlâ kândâkdâ yaŋe siliŋ siliŋ sâm hâuop. ");
INSERT INTO spl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Siliŋ siliŋ sâm hâumu hâmbiŋ gumbiŋ otmâ hânân ge pare iop. Hânân ge pare imu yan Yesu Kutdâŋe yuwu sâm ekuop. “Saulo, Saulo, gâŋe wongât iliwetsat?” ");
INSERT INTO spl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sâmu sâop. “Gâ âlâ?” Kâpekbaŋgim sâop. “Nâ hilipnohom gat. Nâ Yesu. ");
INSERT INTO spl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gâŋe yahatmâ kapiân yâhâwuat yan lok âlâŋe yu ya otbuat yakât sâm tetem ekgohowuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yawu sâmu orowâk ariwiŋe den sâop yawuâk nâŋgâwi yamâ Yesu ikŋe ki ekbi. Yakât otmâ den biaek kinbi. ");
INSERT INTO spl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Yawu otmâ kinŋetâ Sauloŋe yahatmâ senŋe omoŋgumu ki ehop. ");
INSERT INTO spl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yakât otmâ bukulipŋaŋe dâim Damasiko kapiân yâhâwi. Kapiân yâhâ tatmâ sot me to barahâk tatmu hilâm kalimbu pesuk sâop. ");
INSERT INTO spl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Aiop, Damasiko kapi amboŋe âlâŋe Yesuhâlen biwiŋaŋe kepeim manop, kutŋe Anania. Otmu Anitâhât Wâtgât mâmâŋahât Heakŋe biwiŋe mem purik pilâmu Yesuŋe tetewaŋgim kutŋan kunmu ehop. Ekmâ sâop. “Kutdâ, nâ yu tan.” ");
INSERT INTO spl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yawu sâmu Kutdâŋe yuwu sâm ekuop. “Yahatmâ mâtâp âlâ, kutŋe “mâtâp tâŋ tâŋâk” sâm, yan lok âlâ kutŋe Yurasi, yâkât emelan yâhâwuat. Yan yâhâ lok âlâ, kutŋe Saulo, Taso kapi amboŋe emelan yan tap ya mem tetewuat. ");
INSERT INTO spl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Oran ulitnohomu nâŋe biwiŋe mem purik pilâmune yuwu ehop. Gâŋe yâkâlen ari kunŋan mendâ senŋe suk sâmu ekbuap.” Yawu sâop. ");
INSERT INTO spl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yawu sâm ekumu sâop. “Kutdâ. Saulohât topŋe emelâk sâŋetâ nâŋgâman. Yerusalem kapi ambolipŋe nombotŋe gâhâlen biwiyeŋaŋe kepeim mansai ya hilipyongom hâhiwin yiŋgim mansap. ");
INSERT INTO spl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Otmu Damasiko kapi ambolipŋe nenŋe gâhâlen biwinenŋaŋe kepeim mansain nen menenekmâ Yerusalem kapiân âwurem ari pâi emetŋan katnenekbe sâm hotom umai ya yeŋgât kunyeŋaŋe hâŋgânguŋetâ takaop.” ");
INSERT INTO spl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Sâmu sâop. “Yuwu ekgohomune nâŋgâ. Isirae lohimbi, pâku lohimbi otmu papatolipyeŋaŋe nâhât topne nâŋgâŋetgât Saulo âi sâm waŋmâ hâŋgângumune yâk yeŋgâlen ari nine den pat âlepŋe ekyongowu