﻿USE sofia;
DROP TABLE IF EXISTS sofia.spavbl_vpl;
CREATE TABLE spavbl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES spavbl_vpl WRITE;
INSERT INTO spavbl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","En el principio, Dios creó los cielos y la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","La tierra carecía de forma y estaba vacía; la oscuridad cubría la superficie del abismo y el Espíritu de Dios se movía sobre la superficie de las aguas. ");
INSERT INTO spavbl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Y Dios dijo: “¡Que haya luz!” y hubo luz. ");
INSERT INTO spavbl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dios vio que la luz era buena, y separó a la luz de la oscuridad. ");
INSERT INTO spavbl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Entonces Dios llamó a la luz “día” y a la oscuridad le llamó “noche”. Así que hubo noche y mañana, lo cual fue el primer día. ");
INSERT INTO spavbl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Entonces Dios dijo: “Que haya expansión en medio de las aguas para dividirlas”. ");
INSERT INTO spavbl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Así que Dios hizo una expansión para separar las aguas que estaban arriba de las aguas, de las aguas que estaban debajo. Y así sucedió. ");
INSERT INTO spavbl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dios llamó a la expansión “cielo”.Entonces hubo noche y mañana, lo cual fue el segundo día. ");
INSERT INTO spavbl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dios dijo: “Que las aguas que están debajo del cielo se junten en un solo lugar para que aparezca la tierra”.Y así sucedió. ");
INSERT INTO spavbl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Entonces Dios llamó al suelo “tierra” y a las aguas les llamó “mares”.Y Dios vio que era bueno. ");
INSERT INTO spavbl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Dios dijo: “Que la tierra produzca vegetación: plantas que produzcan semillas y árboles que produzcan frutos con semillas, cada uno de su propia clase”.Y así sucedió. ");
INSERT INTO spavbl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","La tierra produjo vegetación: plantas que producen semillas y árboles que producen frutos con semillas, cada uno de su propia clase. Entonces Dios vio que era bueno. ");
INSERT INTO spavbl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Así que hubo noche y mañana, lo cual fue el tercer día. ");
INSERT INTO spavbl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dios dijo: “Que haya luces en el cielo para separar el día de la noche, y para que exista una forma de marcar las estaciones, los días y los años. ");
INSERT INTO spavbl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Habrá luces en el cielo que brillen sobre la tierra”.Y así sucedió. ");
INSERT INTO spavbl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dios creó dos grandes luces: la más grande a cargo del día, y la más pequeña a cargo de la noche. También creó las estrellas. ");
INSERT INTO spavbl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dios puso estas luces en el cielo para que brillaran sobre la tierra, ");
INSERT INTO spavbl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","para que estuvieran a cargo del día y de la noche, y para separar la luz de la oscuridad. Y Dios vio que era bueno. ");
INSERT INTO spavbl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Así que hubo noche y mañana, lo cual fue el cuarto día. ");
INSERT INTO spavbl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Y Dios dijo: “Que las aguas se llenen de criaturas vivientes, y que las aves vuelen por encima de la tierra, en el cielo”. ");
INSERT INTO spavbl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Así que Dios creó enormes animales marinos y todos los seres vivos que nadan y que habitan en las aguas, cada uno de su propia clase; así como cada ave que vuela, cada una según su especie. Y Dios vio que era bueno. ");
INSERT INTO spavbl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Dios los bendijo y dijo: “Reprodúzcanse y multiplíquense, y llenen las aguas del mar, y que se multipliquen las aves en toda la tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Y así hubo noche y después mañana, lo cual fue el quinto día. ");
INSERT INTO spavbl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Entonces Dios dijo: “Que la tierra produzca criaturas vivientes, cada una según su especie: rebaños, ganado, las criaturas reptiles, los animales salvajes, cada uno de su propia clase”.Y sucedió así. ");
INSERT INTO spavbl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dios hizo a los animales salvajes, al ganado, y a los reptiles, a todos según su propia especie. Y Dios vio que esto era bueno. ");
INSERT INTO spavbl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Entonces Dios dijo: “Hagamos seres humanos según nuestra imagen, y que sean como nosotros. Ellos tendrán autoridad sobre los peces del mar y sobre las aves que vuelan por los aires, sobre los animales y sobre toda la tierra y las criaturas que se muevensobre ella”. ");
INSERT INTO spavbl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Así que Dios creó a los seres humanos según su propia imagen. Los creó a la imagen de Dios, como varón y hembra. ");
INSERT INTO spavbl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Dios los bendijo y les dijo: “Reprodúzcanse y multiplíquense; vayan por toda la tierray gobiérnenla. Tengan autoridad sobre los peces que están en el mar y sobre las aves que vuelan por los aires, y sobre cada criatura que se mueve sobre la tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Y Dios dijo: “Miren, les he dado como alimento cada planta que produce semilla de toda la tierra, y cada árbol que produce fruto con semilla. ");
INSERT INTO spavbl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Todas las plantas verdes las he dado a todos los animales de la tierra, a las aves, y a cada criatura que se mueve sobre la tierra, es decir, a todo ser vivo”. Y así sucedió. ");
INSERT INTO spavbl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Entonces Dios vio todo lo que había creado, y una vez más vio que era muy bueno. Así hubo tarde y luego mañana, lo cual fue el sexto día. ");
INSERT INTO spavbl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","La creación de los cielos, la tierra y todo lo que hay en ellos quedó terminada. ");
INSERT INTO spavbl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Cuando llegó el séptimo día, Dios había terminado el trabajo que había hecho, y descansó en el séptimo día de todo el trabajo que había estado haciendo. ");
INSERT INTO spavbl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Entonces Dios bendijo el séptimo día y lo apartó como día santo, porque en él descansó de todo el trabajo que había hecho en la creación. ");
INSERT INTO spavbl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Este es el relato de la creación del Señor Dios cuando hizo los cielos y la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Hasta este momento no había plantas silvestres ni cultivos creciendo sobre la tierra, porque el Señor Dios no había enviado la lluvia, y porque no había quien cultivara el suelo. ");
INSERT INTO spavbl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","El rocío brotaba de la tierra y hacía que la superficie del suelo estuviera húmeda. ");
INSERT INTO spavbl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Entonces el Señor formó al hombre Adán con polvo de la tierra. Y sopló en sus fosas nasales el aliento de vida, y Adán se convirtió en un ser vivo. ");
INSERT INTO spavbl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Entonces el Señor sembró un jardín en Edén, al oriente. Allí puso al hombre Adán, a quien había creado. ");
INSERT INTO spavbl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","El Señor creó toda clase de árboles para que crecieran en el jardín, árboles hermosos y árboles que producían frutas agradables al paladar. El árbol de la vida se encontraba en medio del jardín, así como el árbol del conocimiento del bien y del mal. ");
INSERT INTO spavbl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","De Edén salía un río que regaba el jardín, y desde allí se dividía en cuatro brazos. ");
INSERT INTO spavbl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","El primero fue llamado Pisón, y pasaba por toda la tierra de Havila, donde había oro. ");
INSERT INTO spavbl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(El oro de esta tierra es puro. Allí también hay bedelio y ónice). ");
INSERT INTO spavbl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","El segundo brazo fue llamado Gijón y rodea toda la tierra de Cus. ");
INSERT INTO spavbl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","El tercer brazo fue llamado Tigris y rodeaba el oriente de la ciudad de Asur. El cuarto brazo fue llamado Éufrates. ");
INSERT INTO spavbl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","El Señor Dios puso al hombre en el Jardín de Edén para que lo cultivara y cuidara de él. ");
INSERT INTO spavbl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","El Señor Dios le dio orden a Adán: “Eres libre de comer el fruto de todos los árboles del jardín, ");
INSERT INTO spavbl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","pero no debes comer del árbol del conocimiento del bien y del mal, porque el día que comas de él, será seguro que morirás”. ");
INSERT INTO spavbl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Entonces el Señor Dios dijo: “No es bueno que Adán esté solo. Haré a alguien que lo ayude, alguien que sea como él”. ");
INSERT INTO spavbl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","El Señor Dios usó la tierra para hacer a los animales salvajes y a todas las aves. A todos los animales los trajo hasta donde estaba Adán para que les pusiera nombre, y Adán puso nombre a cada criatura viviente. ");
INSERT INTO spavbl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adán le puso nombre a todo el ganado, a todas las aves, y a los animales salvajes. Pero Adán no encontraba a nadie que pudiera ayudarlo. ");
INSERT INTO spavbl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Así que el Señor hizo que Adán durmiera profundamente, y mientras dormía Dios quitó una de las costillas de Adán y después volvió a cerrar el lugar del cual tomó el tejido. ");
INSERT INTO spavbl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Y el Señor hizo a una mujer, usando la costilla que había tomado de Adán, y entonces se la presentó a Adán. ");
INSERT INTO spavbl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","“¡Por fin!” dijo Adán. “Esta es hueso de mis huesos y carne de mi carne. Ella será llamada mujer, porque fue sacada del hombre”. ");
INSERT INTO spavbl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Esta es la razón por la cual el hombre deja a su padre y a su madre y se une a su esposa, y los dos se vuelven un solo ser. ");
INSERT INTO spavbl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adán y su esposa Eva estaban desnudos, pero no sentían vergüenza por ello. ");
INSERT INTO spavbl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","La serpiente era más astuta que cualquiera de los otros animales salvajes que el Señor Dios había hecho. Y le preguntó a Eva: “¿En serio Dios dijo que no pueden comer del fruto de todos los árboles del jardín?” ");
INSERT INTO spavbl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Entonces Eva le respondió a la serpiente: “Podemos comer de los árboles del jardín, pero no del fruto del árbol que está en medio del jardín. ");
INSERT INTO spavbl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Dios nos dijo: ‘No deben comer de ese árbol, y ni siquiera tocarlo, pues de lo contrario morirán’”. ");
INSERT INTO spavbl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“Por supuesto que no morirán”, le dijo la serpiente a Eva. ");
INSERT INTO spavbl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“Lo que sucede es que Dios sabe que tan pronto coman de él verán las cosas de una manera distinta, y serán como Dios, conociendo el bien y el mal”. ");
INSERT INTO spavbl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Eva vio que el fruto del árbol lucía bueno para comer. El fruto se veía muy atractivo. Y Eva lo deseaba para obtener sabiduría. Así que tomó del fruto y lo comió, y lo compartió con su esposo, que estaba con ella, y él también comió. ");
INSERT INTO spavbl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tan pronto como comieron del fruto, vieron todo diferente y se dieron cuenta de que estaban desnudos. Así que cosieron hojas de higuera para cubrirse. ");
INSERT INTO spavbl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Al caer la noche, y cuando soplaba la brisa del atardecer, escucharon al Señor caminando en el jardín. Entonces Adán y Eva se escondieron de la presencia del Señor entre los árboles del jardín. ");
INSERT INTO spavbl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Entonces el Señor llamó a Adán: “¿Dónde estás?” ");
INSERT INTO spavbl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","“Te escuché caminando por el jardín y me asusté porque estaba desnudo, y por eso me escondí”, respondió Adán. ");
INSERT INTO spavbl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“¿Quién te dijo que estabas desnudo?” le preguntó el Señor Dios. “¿Acaso comiste del árbol que te dije que no comieras?” ");
INSERT INTO spavbl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","“Fue la mujer que me diste quien me brindó del fruto del árbol, y yo lo comí”, respondió Adán. ");
INSERT INTO spavbl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Entonces el Señor le preguntó a Eva: “¿Por qué has hecho esto?” “La serpiente me engañó, y yo lo comí”, respondió ella. ");
INSERT INTO spavbl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Entonces el Señor le dijo a la serpiente: “Por lo que has hecho, serás maldita entre todos los animales. Te arrastrarás sobre tu vientre y comerás polvo mientras vivas. ");
INSERT INTO spavbl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Me aseguraré de que tú y tus hijos, así como la mujer y sus hijos, sean enemigos. Uno de sus hijos aplastará tu cabeza, y tú herirás su talón”. ");
INSERT INTO spavbl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Dios le dijo a Eva: “Haré que el embarazo sea más penoso y que dar a luz sea más doloroso. Sin embargo, tendrás deseo por tu esposo y él te gobernará”. ");
INSERT INTO spavbl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Y Dios le dijo a Adán: “Por haber hecho lo que te dijo tu esposa, y comiste del fruto del árbol sobre el cual te dije ‘No comas del fruto de este árbol,’ el suelo ahora estará maldito por tu culpa. Tendrás que trabajar arduamente para cultivar los alimentos durante toda tu vida. ");
INSERT INTO spavbl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Los cultivos tendrán cardos y espinas, y tendrás que comer plantas silvestres. ");
INSERT INTO spavbl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tendrás que sudar para cultivar suficiente comida hasta que mueras y regreses a la tierra. Porque fuiste hecho del polvo de la tierra, y al mismo polvo regresarás”. ");
INSERT INTO spavbl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adán le puso por nombre Eva a su esposa, porque ella sería la madre de todos los seres humanos. ");
INSERT INTO spavbl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","El Señor hizo vestiduras con piel de animales para Adán y Eva y lo vistió. ");
INSERT INTO spavbl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Entonces el Señor miró una vez más: “Veo que los seres humanos se han convertido en uno más como nosotros, y conocen ahora tanto el bien como el mal. Ahora bien, si llegasen a tomar el fruto del árbol de la vida y lo comen, vivirían para siempre.” ");
INSERT INTO spavbl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Así que el Señor los expulsó del jardín de Edén. Envió a Adán a cultivar el suelo a partir del cual él mismo fue creado. ");
INSERT INTO spavbl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Después de sacarlos del jardín, el Señor puso al oriente del jardín ángeles y una espada que daba su resplandor en todas las direcciones. Esto con el fin de que no pudieran acceder al árbol de la vida. ");
INSERT INTO spavbl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adán durmió con su esposa Eva y ella quedó embarazada. Y dio a luz a Caín, y dijo: “Con la ayuda de Dios he hecho a un hombre”. ");
INSERT INTO spavbl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Después dio a luz a su hermano Abel. Él se convirtió en un pastor de ovejas, mientras que Caín era un agricultor. ");
INSERT INTO spavbl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Algún tiempo después, Caín trajo el fruto de su cosecha como ofrenda al Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel también trajo una ofrenda: el primogénito de su rebaño, eligiendo las mejores partes como ofrenda. El Señor se sintió agradado de Abel y su ofrenda, ");
INSERT INTO spavbl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","pero no se agradó de Caín ni de su ofrenda, lo cual enojó a Caín en gran manera y frunció el ceño con enfado. ");
INSERT INTO spavbl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Entonces el Señor le preguntó a Caín: “¿Por qué estás enojado? ¿Por qué te ves tan enfadado? ");
INSERT INTO spavbl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si hicieras lo correcto, lucirías contento. Pero si no haces lo correcto, el pecado será como animales agazapados en la puerta de tu casa, listos para atacarte. El pecado desea apoderarse de ti, pero tú debes mantener el control”. ");
INSERT INTO spavbl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Más tarde, mientras Caín hablaba con su hermano Abel, e iban por los campos, Caín atacó a su hermano y lo mató. ");
INSERT INTO spavbl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","“¿Dónde está tu hermano Abel?” le preguntó el Señor a Caín. “¿Cómo podría saberlo?” respondió Caín. “¿Acaso se supone que debo ser el cuidador de mi hermano?” ");
INSERT INTO spavbl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","“¿Qué has hecho?” le preguntó el Señor. “La sangre de tu hermano clama a mi desde la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Por esto ahora estarás más maldito que la tierra, porque la has impregnado con la sangre de tu hermano. ");
INSERT INTO spavbl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Y cuando cultives la tierra, no producirá cosechas para ti. Siempre serás un prófugo, errando por toda la tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","“Mi castigo es más de lo que puedo soportar”, respondió Caín. ");
INSERT INTO spavbl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","“¡Mira! Me expulsas en este instante, maldiciendo la tierra y echándome de tu presencia. Ahora tendré que esconderme y seré siempre un prófugo, errante por toda la tierra. ¡Y cualquiera que me encuentre me matará!” ");
INSERT INTO spavbl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Pero el Señor respondió: “No, Caín. Cualquiera que te mate será castigado siete veces más”. El Señor puso una marca sobre Caín para que ninguno lo matase. ");
INSERT INTO spavbl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Así que Caín se fue de la presencia del Señor y se fue a vivir al país llamado Nod, al oriente de Edén. ");
INSERT INTO spavbl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caín se acostó con su esposa y ella quedó embarazada. Y tuvo un hijo llamado Enoc. En ese tiempo Caín estaba construyendo una ciudad, y le puso el mismo nombre que su hijo Enoc. ");
INSERT INTO spavbl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoc tuvo un hijo llamado Irad. E Irad fue el padre de Mejuyael, y luego Mejuyael fue el padre de Metusael, y Metusael fue el padre de Lamec. ");
INSERT INTO spavbl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamec se casó con dos mujeres. La primera se llamaba Ada, y la segunda se llamaba Selá. ");
INSERT INTO spavbl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada tuvo un hijo llamado Jabal. Él fue el padre de los que viven en tiendas y tienen rebaños. ");
INSERT INTO spavbl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Él tuvo un hermano llamado Jubal. Y Jubal era el padre de todos los que tocan instrumentos de cuerda y de viento. ");
INSERT INTO spavbl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Selá también tuvo un hijo que se llamaba Tubal-Caín y era un herrero que forjaba toda clase de herramientas de hierro y bronce. La hermana de Tubal-Caín se llamaba Naamá. ");
INSERT INTO spavbl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","En cierta ocasión, Lamec le dijo a sus esposas: “Ada y Selá, escúchenme. Ustedes, esposas de Lamec, presten atención a lo que les voy a decir. Yo maté a un hombre y él me hirió. Maté a un hombre joven porque atentó contra mi. ");
INSERT INTO spavbl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Si la sentencia por matar a Caín era de ser castigado siete veces más, entonces si alguien me mata a mí, el castigo debería ser setenta y siete veces más”. ");
INSERT INTO spavbl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adán volvió a acostarse con su esposa otra vez, y tuvieron un hijo llamado Set, con la explicación: “Dios me ha dado otro hijo para tomar el lugar de Abel, el que mató Caín”. ");
INSERT INTO spavbl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Después Set tuvo un hijo llamado Enós, porque en ese tiempo las personas habían comenzado a adorar al Señor por su nombre. ");
INSERT INTO spavbl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Este es el registro de los descendientes de Adán. Cuando Dios creó a los seres humanos, los hizo semejantes a él. ");
INSERT INTO spavbl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Los creó varón y hembra, y los bendijo. El día que los creó, los llamó “humanos”. ");
INSERT INTO spavbl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Cuando Adán cumplió la edad de 130 años, tuvo un hijo semejante a él, hecho a su imagen, y le puso el nombre de Set. ");
INSERT INTO spavbl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Después del nacimiento de Set, Adán vivió 800 años más, y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Y Adán vivió en total 930 años, y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Cuando Set cumplió la edad de 105 años, tuvo a Enoc. ");
INSERT INTO spavbl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Después del nacimiento de Enoc, Set vivió 807 años más, y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Enós vivió en total 912 años, y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Cuando Enóc cumplió la edad de 90 años, tuvo a Cainán. ");
INSERT INTO spavbl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Después del Nacimiento de Cainán, Enoc vivió 815 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoc vivió en total 905 años y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cuando Cainán cumplió la edad de 70 años, tuvo a Malalel. ");
INSERT INTO spavbl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Después del Nacimiento de Malalel, Cainán vivió 840 años más, y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Y Cainán vivió en total 910 años, y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Cuando Malalel cumplió la edad de 65 años, tuvo a Jared. ");
INSERT INTO spavbl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Y después del Nacimiento de Jared, Malalel vivió 830 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Y Malalel vivió en total 895 años, y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Cuando Jared cumplió la edad de 162 años, tuvo a Enoc. ");
INSERT INTO spavbl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Después del Nacimiento de Enoc, Jared vivió 800 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Y Jared vivió en total 962 años, y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Cuando Enoc cumplió 65 años, tuvo a Matusalén. ");
INSERT INTO spavbl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Y Enoc tuvo una relación muy estrecha con Dios. Después del nacimiento de Matusalén, Enoc vivió 300 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Y Enoc vivió en total 365 años. ");
INSERT INTO spavbl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Pero Enoc tenía una relación tan estrecha con Dios que no murió, sino que desapareció porque Dios se lo llevó. ");
INSERT INTO spavbl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Cuando Matusalén cumplió la edad de 187 años, tuvo a Lamec. ");
INSERT INTO spavbl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Después del Nacimiento de Lamec, Matusalén vivió 782 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Y Maturalén vivió en total 969 años, y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Cuando Lamec cumplió 182 años, tuvo un hijo. ");
INSERT INTO spavbl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Y le puso por nombre Noé, con la explicación “Él nos dará alivio del arduo trabajo que debemos hacer para cultivar la tierra que el Señor maldijo”. ");
INSERT INTO spavbl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Después del Nacimiento de Noé, Lamec vivió 595 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Y Lamec vivió en total 777 años, y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé vivió 500 años antes de tener a Sem, Cam y Jafet. ");
INSERT INTO spavbl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Y los seres humanos comenzaron a multiplicarse y a esparcirse por toda la tierra. Y tenían hijas, ");
INSERT INTO spavbl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","y los hijos de Dios se dieron cuenta de que estas mujeres eran hermosas, y tomaban para sí las que querían. ");
INSERT INTO spavbl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Entonces el Señor dijo: “Mi espíritu de vida no permanecerá con este pueblo para siempre, porque son mortales. Ahora el tiempo de vida será de 120 años”. ");
INSERT INTO spavbl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","En esos días había gigantes en la tierra y, aún después, los hubo también. Estos nacieron después de que los hijos de Dios se acostaran con las hijas de este pueblo. Sus hijos se volvieron grandes guerreros y hombres de renombre en la antigüedad. ");
INSERT INTO spavbl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Y el Señor se dio cuenta de cuán malvados se habían vuelto los habitantes de la tierra, pues cada uno de los pensamientos en sus mentes estaban llenos de maldad. ");
INSERT INTO spavbl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","El Señor se lamentó de haber creado a los seres humanos para habitar la tierra, y le entristeció este pensamiento. ");
INSERT INTO spavbl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Así que el Señor dijo: “Voy a eliminar de la tierra a estas personas que he creado; y no solo a ellos, sino también a los animales, a los reptiles y a las aves, porque me lamento de haberlos creado”. ");
INSERT INTO spavbl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero el Señor se agradó de Noé. ");
INSERT INTO spavbl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Esta es la historia de Noé y su familia. Noé era un hombre íntegro, que vivía una vida con principios morales entre las personas de su época. Él tenía una relación estrecha con Dios. ");
INSERT INTO spavbl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Y Noé tenía tres hijos: Sem, Cam, y Jafet. ");
INSERT INTO spavbl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dios vio cuán inmoral se había vuelto el mundo entero, lleno de violencia y de personas que actuaban sin ley. ");
INSERT INTO spavbl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dios se dio cuenta de que la perversión del mundo se debía a que todos vivían vidas inmorales. ");
INSERT INTO spavbl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Entonces Dios le dijo a Noé: “He decidido poner fin a todos los habitantes de la tierra porque todos son violentos y viven sin ley. Yo mismo los voy a destruir a todos, y a la tierra misma junto con ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Construye un arca de madera de ciprés. Haz habitaciones dentro del arca, y cúbrela con alquitrán, por dentro y por fuera. ");
INSERT INTO spavbl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Y así es como deberás construirla: El arca debe medir 300 codos de largo, 50 codos de ancho, y 30 codos de alto. ");
INSERT INTO spavbl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Hazle un techo al arca, dejando una ventana del tamaño de un codo entre el techo y la parte superior de los lados. Coloca una puerta lateral en el arca, y haz el arca de tres cubiertas. ");
INSERT INTO spavbl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Yo mismo voy a enviar un diluvio a la tierra que destruirá todo lo que respire. Todo ser vivo sobre la tierra morirá. ");
INSERT INTO spavbl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pero yo guardaré mi pacto contigo. Tu entrarás al arca, tomarás contigo a tu esposa, a tus hijos y a sus esposas. ");
INSERT INTO spavbl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Tomarás un par - macho y hembra - de cada especie de animal, y te asegurarás de preservarlos con vida. ");
INSERT INTO spavbl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Harás lo mismo con cada especie de ave, ganado, y con los reptiles: un par de cada uno vendrá a ti para que puedas mantenerlos con vida. ");
INSERT INTO spavbl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Lleva contigo toda clase de alimentos y almacénala para que tú y los animales tengan suficiente para comer”. ");
INSERT INTO spavbl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Y Noé hizo exactamente lo que Dios le ordenó que hiciera. ");
INSERT INTO spavbl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","El Señor le dijo a Noé: “Entra al arca con toda tu familia. Porque he visto que eres un hombre íntegro, que vive una vida moral en medio de la gente de esta generación. ");
INSERT INTO spavbl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Toma contigo siete parejas - macho y hembra - de cada especie de animal limpio; y un par - macho y hembra - de cada especie de animal impuro. ");
INSERT INTO spavbl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Además, toma siete parejas - macho y hembra - de todas las aves, para que todas las especies de toda la tierra puedan sobrevivir. ");
INSERT INTO spavbl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","En siete días hare llover por cuarenta días y cuarenta noches. Voy a erradicar de la superficie de la tierra a todos los seres que he creado”. ");
INSERT INTO spavbl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Y Noé hizo exactamente lo que el Señor le ordenó que hiciera. ");
INSERT INTO spavbl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noé tenía 600 años cuando las aguas inundaron la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noé entró al arca, junto con su esposa y sus hijos, y las esposas de sus hijos, por causa del diluvio. ");
INSERT INTO spavbl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Animales puros e impuros, aves y reptiles, ");
INSERT INTO spavbl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","entraron en el arca que construyó Noé. ");
INSERT INTO spavbl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Después de siete días, las aguas cayeron sobre la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noé había cumplido 600 años, cuando en el día número diecisiete del segundo mes, todas las aguas que estaban debajo de la tierra estallaron y atravesaron el suelo, y una fuerte lluvia cayó del cielo. ");
INSERT INTO spavbl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","La lluvia siguió cayendo sobre la tierra durante cuarenta días y cuarenta noches. ");
INSERT INTO spavbl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ese fue el día en que el Noé, su esposa, sus hijos Sem, Cam y Jafet, junto a sus esposas, entraron en el arca. ");
INSERT INTO spavbl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Con ellos entró toda especie de animales salvajes, ganado, reptiles y aves, así como todo animal alado. ");
INSERT INTO spavbl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Todos entraron con Noé al arca; todos los seres vivos, y en pares. ");
INSERT INTO spavbl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","De cada criatura entró el macho con su hembra, tal como Dios le dijo a Noé. Entonces el Señor cerró la puerta. ");
INSERT INTO spavbl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Y la lluvia cayó sobre la tierra por cuarenta días, haciendo flotar el arca por encima del suelo. ");
INSERT INTO spavbl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Las aguas subieron cada vez más y se hacían profundas, pero el arca flotaba en la superficie. ");
INSERT INTO spavbl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Finalmente, el agua aumentó tanto de nivel que hasta las montañas más altas quedaron cubiertas, y solo se podía ver el cielo. ");
INSERT INTO spavbl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","El agua subió tanto, que sobrepasó la altura de las montañas hasta quince codos más. ");
INSERT INTO spavbl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Y todo lo que habitaba sobre la tierra pereció: las aves, el ganado, los animales salvajes, todos los reptiles, y todas las personas también. ");
INSERT INTO spavbl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Murió todo ser vivo que estaba sobre la tierra y que podía respirar. ");
INSERT INTO spavbl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","El Señor exterminó a todo ser viviente: desde los seres humanos, hasta el ganado, los reptiles y las aves. Todos murieron y solo sobrevivieron los que estaban con Noé en el arca. ");
INSERT INTO spavbl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Y la tierra permaneció inundada por 150 días. ");
INSERT INTO spavbl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Pero Dios no se había olvidado de Noé ni de todos los animales salvajes y el ganado que estaba en el carca con él. Dios envió un viento fuerte sobre la tierra, y las aguas comenzaron a bajar. ");
INSERT INTO spavbl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Las aguas subterráneas se cerraron, y la lluvia se detuvo. ");
INSERT INTO spavbl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Poco a poco, las aguas comenzaron a retirarse de la tierra. Bajaron tanto que 150 días después del diluvio ");
INSERT INTO spavbl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","el arca se posó sobre el monte Ararat. Esto sucedió en el día diecisiete del séptimo mes. ");
INSERT INTO spavbl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Las aguas siguieron bajando hasta que el primer día del décimo mes, ya se podía ver la cumbre de las montañas. ");
INSERT INTO spavbl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Cuarenta días después, Noé abrió la ventana que había hecho en el arca, ");
INSERT INTO spavbl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","y envió a un cuervo fuera del arca. El cuervo iba y venía hasta que el agua sobre la tierra se hubo secado. ");
INSERT INTO spavbl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Entonces Noé envió una paloma para comprobar si las aguas habían bajado lo suficiente como para que hubiera tierra seca. ");
INSERT INTO spavbl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pero la paloma no pudo encontrar ningún lugar donde posarse. Así que regresó a Noé porque el agua aún cubría toda la tierra. Noé sacó su mano y tomó a la paloma, y la trajo consigo de nuevo dentro del arca. ");
INSERT INTO spavbl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Entonces Noé esperó siete días más y volvió a enviar a la paloma fuera del arca. ");
INSERT INTO spavbl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Cuando la paloma regresó en la noche, trajo en su pico una hoja fresca de olivo, de modo que Noé supo así que las aguas se habían ido en gran parte de la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Una vez más, Noé esperó otros siete días más, y entonces volvió a enviar a la paloma, pero esta vez la paloma no regresó. ");
INSERT INTO spavbl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noé había cumplido ahora 601 años, y era el primer día del primer mes, cuando las aguas se habían secado por completo. Noé retiró la cubierta del arca y pudo ver que el suelo se estaba secando. ");
INSERT INTO spavbl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","En el vigésimo séptimo día del segundo mes, la tierra estaba seca. ");
INSERT INTO spavbl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Entonces Dios le dijo a Noé: ");
INSERT INTO spavbl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Salgan del arca tú, tu esposa, tus hijos, y sus esposas. ");
INSERT INTO spavbl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Dejen ir a todos los animales; a las aves, a los animales salvajes, a los reptiles, para que se multipliquen y llenen en la tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Así que Noé y su esposa, así como sus hijos y sus esposas salieron del arca. ");
INSERT INTO spavbl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","También todos los animales, los reptiles y las aves, todo ser vivo que estaba en el arca salió, todosagrupados por especie. ");
INSERT INTO spavbl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Entonces Noé construyó un altar y sacrificó a algunos de los animales limpios, así como a algunas aves, a manera de ofrenda. ");
INSERT INTO spavbl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","El Señor aceptó tal sacrificio, y dijo para sí mismo: “No volveré a maldecir a la tierra por culpa de los seres humanos, aunque cada uno de sus pensamientos sea perverso desde su niñez. Y no volveré a destruir a los seres vivos como lo acabo de hacer. ");
INSERT INTO spavbl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","En tanto exista la tierra, no faltará la temporada de siembra y de cosecha, el frío y el calor, el verano y el invierno, así como el día y la noche”. ");
INSERT INTO spavbl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Y Dios bendijo a Noé y a sus hijos, y les dijo: “¡Reprodúzcanse, multiplíquense y llenen toda la tierra! ");
INSERT INTO spavbl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Todos los animales te temerán, incluso las aves, las criaturas que se arrastran por el suelo, y los peces del mar. Ahora estás a cargo de ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Todo ser vivo que se mueve será alimento para ti, así como las plantas verdes. ");
INSERT INTO spavbl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pero no comerás carne que aún tenga sangre de vida en ella. ");
INSERT INTO spavbl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Si tu sangre es derramada por causa de un animal, yo pediré cuentas por ello; y si tu sangre es derramada por otra personas, yo se lo reclamaré. ");
INSERT INTO spavbl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Si alguno derrama sangre de otro ser humano, otro ser humano derramará su sangre también. Porque Dios creó a los seres humanos según su propia imagen. ");
INSERT INTO spavbl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","¡Así que reprodúzcanse, multiplíquense y llenen la tierra de muchos descendientes!” ");
INSERT INTO spavbl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Entonces Dios le dijo a Noé y a sus hijos que estaban con él: ");
INSERT INTO spavbl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Escuchen, yo hoy hago mi pacto con ustedes y con sus descendientes, ");
INSERT INTO spavbl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","y también con todos los animales, las aves, el ganado y todos los animales salvajes de la tierra, así como todo animal que estuvo en el arca. ");
INSERT INTO spavbl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","En este pacto yo les prometo que no volveré a destruir a los seres vivos por medio de un diluvio, y que no habrá nuevamente un diluvio destructor como este”. ");
INSERT INTO spavbl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Entonces Dios dijo: “Les daré una señal para confirmar el acuerdo que hago hoy entre mi y ustedes, y todos los seres vivos. Un acuerdo que durará por todas las generaciones. ");
INSERT INTO spavbl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","He puesto mi arcoíris en las nubes, y esta será la señal de mi acuerdo contigo y con toda la vida que hay sobre la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Cada vez que haya nubes sobre la tierra y aparezca el arcoíris, ");
INSERT INTO spavbl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","me recordará de mi pactoentre mi y ustedes, así como cada criatura viviente, de que las aguas no volverán a destruir todo ser viviente sobre la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Y veré el arcoíris en las nubes, y me acordaré de este acuerdo eterno entre Dios y cada ser vivo que habita sobre la tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Entonces Dios le dijo a Noé: “Esta es la señal del acuerdo que hago hoy con cada criatura sobre la tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Los hijos de Noé que salieron del arca eran Sem, Cam y Jafet. (Cam fue el padre de los cananeos). ");
INSERT INTO spavbl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Y todos los seres humanos que están esparcidos por el mundo son descendientes de estos tres hijos de Noé. ");
INSERT INTO spavbl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé comenzó a cultivar la tierra como un granjero, y plantó un viñedo. ");
INSERT INTO spavbl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Entonces bebió del vino que produjo su viñedo, se emborrachó y se quedó dormido desnudo en su tienda. ");
INSERT INTO spavbl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cam, el padre de Canaán vio las partes íntimas de su padre y fue y se lo dijo a sus hermanos que estaban afuera. ");
INSERT INTO spavbl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Entonces Sem y Jafet tomaron un manto, y poniéndolo sobre sus hombros, caminaron de espaldas y cubrieron las partes privadas de su padre. Y se aseguraron de mirar hacia otro lado, a fin de no ver las partes privadas de su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Cuando Noé se levantó de su sueño por la embriaguez, se dio cuenta de los que su hijo menor había hecho, ");
INSERT INTO spavbl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","y dijo: “¡Maldito seas, Canaán! ¡Serás el esclavo de menor clase, y servirás a tus hermanos!” ");
INSERT INTO spavbl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Entonces Noé continuó: “Bendito sea el Señor, Dios de Sem, y que Canaán sea su esclavo. ");
INSERT INTO spavbl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Que Dios le de a Jafet mucho espacio para sus descendientes, y que vivan en paz con el pueblo de Sem, y que Canaán sea su esclavo también”. ");
INSERT INTO spavbl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Y después del diluvio, Noé vivió 350 años más. ");
INSERT INTO spavbl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noé vivió en total 950 años, y entonces murió. ");
INSERT INTO spavbl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Las siguientes son las genealogías de los hijos de Noé: Sem, Cam, y Jafet. Ellos tuvieron hijos después del diluvio. ");
INSERT INTO spavbl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Los hijos de Jafet: Gomer, Magog, Madai, Jabán, Tubal, Mésec y Tirás. ");
INSERT INTO spavbl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Los hijos de Gomer: Asquenaz, Rifat, y Togarmá. ");
INSERT INTO spavbl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Los hijos de Jabán: Elisá, Tarsis, Quitín, y Rodanín. ");
INSERT INTO spavbl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Los descendientes de estos ancestros se esparcieron por las áreas costeras, cada grupo con su propio idioma, con sus familias que se convirtieron en diferentes naciones. ");
INSERT INTO spavbl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Los hijos de Cam: Cus, Misrayin, Fut, y Canaán. ");
INSERT INTO spavbl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Los hijos de Cus: Seba, Javilá, Sabtá, Ragama y Sabteca. Los hijos de Ragama: Sabá y Dedán. ");
INSERT INTO spavbl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus también fue el padre de Nimrod, quien se destacó como el primer tirano en la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Fue un guerrero que desafió al Señor, y es la razón por la que existe el dicho: “Como Nimrod, un poderoso guerrero que desafió al Señor”. ");
INSERT INTO spavbl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Su reino comenzó en las ciudades de Babel, Erec, Acad, y Calné, todas ellas ubicadas en la tierra de Sinar. ");
INSERT INTO spavbl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De allí se mudó a Asiria y construyó las ciudades de Nínive, Rejobot Ir, Cala, ");
INSERT INTO spavbl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","y Resén, la cual queda entre Nínive y la gran ciudad de Cala. ");
INSERT INTO spavbl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrayin fue el padre de los ludeos, los anameos, los leabitas, los naftuitas ");
INSERT INTO spavbl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","los patruseos, los caslujitas y los caftoritas (ancestros de los filisteos). ");
INSERT INTO spavbl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaán fue el padre de Sidòn, su primogénito, y de los hititas, ");
INSERT INTO spavbl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","de los jebuseos, de los amorreos, de los gergeseos, ");
INSERT INTO spavbl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","de los heveos, los araceos, los sineos, ");
INSERT INTO spavbl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","los arvadeos, los zemareos y los jamatitas. Luego las tribus de Canaán se esparcieron ");
INSERT INTO spavbl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","y el territorio de los caananitas se extendió desde Sidón hasta Guerar y hasta Gaza, luego hacia Sodoma, Gomorra Admá, y Zeboyín, hasta Lasa. ");
INSERT INTO spavbl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Estos fueron los hijos de Cam según sus tribus, idiomas, territorios y nación. ");
INSERT INTO spavbl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, cuyo hermano mayor era Jafet, también tuvo hijos. Sem fue el padre de todos los hijos de Eber. ");
INSERT INTO spavbl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Los hijos de Sem: Elam, Asur, Arfaxad, Lud, y Harán. ");
INSERT INTO spavbl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Los hijos de Harán: Uz, Hul, Guéter, y Mas. ");
INSERT INTO spavbl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad fue el padre de Selaj. Y Selaj fue el padre de Éber. ");
INSERT INTO spavbl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Éber tuvo dos hijos. Uno se llamó Peleg, porque en su tiempo se dividió la tierra; y el nombre de su hermano era Joctán. ");
INSERT INTO spavbl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctán fue el padre de Almodad, Sélef, Jazar Mávet, Yerah, ");
INSERT INTO spavbl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadorán, Uzal, Diclá, ");
INSERT INTO spavbl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sabá, ");
INSERT INTO spavbl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Javilá y Jobab. Todos estos fueron hijos de Joctán. ");
INSERT INTO spavbl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ellos vivieron en la región entre Mesá hasta Sefar, en la región montañosa oriental. ");
INSERT INTO spavbl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Estos fueron los hijos de Sem, sus tribus, idiomas, territorios y naciones. ");
INSERT INTO spavbl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Todas estas fueron las tribus descendientes de los hijos de Noé, según su descendencia y naciones. A partir de estos ancestros se formaron las distintas naciones de la tierra que se expandieron en todo el mundo después del diluvio. ");
INSERT INTO spavbl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","En ese tiempo se hablaba en todo el mundo un solo idioma y todos usaban palabras con el mismo significado. ");
INSERT INTO spavbl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Al trasladarse hacia el oriente, descubrieron una llanura en la región del Sinar y se asentaron allí. ");
INSERT INTO spavbl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Y se dijeron unos a otros: “Vengan, juntemos ladrillos y cocinémoslos con fuego”. (Usaron ladrillo en lugar de piedra, y alquitrán en lugar de cemento). ");
INSERT INTO spavbl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Y entonces dijeron: “Construyamos ahora una ciudad para nosotros mismos con una torre cuya cúspide llegue hasta el cielo. Así lograremos tener una gran reputación y no andaremos dispersos por todo el mundo”. ");
INSERT INTO spavbl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pero el Señor descendió para mirar la ciudad y la torre que estas personas estaban construyendo. ");
INSERT INTO spavbl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Y el Señor dijo: “Miren cómo estas personas están unidas y hablando el mismo idioma. ¡Si pueden lograr todo esto tan solo comenzando, nada les será imposible si se fijan un propósito! ");
INSERT INTO spavbl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Necesitamos bajar allí y confundir su idioma para que no puedan entender lo que se dicen unos a otros”. ");
INSERT INTO spavbl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Y entonces el Señor los expulsó de allí e hizo que se dispersaran por todo el mundo, y dejaron de construir la ciudad. ");
INSERT INTO spavbl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Por eso la ciudad fue llamada Babel, porque el Señor confundió el idioma que se hablaba en el mundo. ");
INSERT INTO spavbl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","La siguiente es la genealogía de Sem. Cuando Sem tuvo 100 años, nació su hijo Arfaxad. Esto sucedió dos años después del diluvio. ");
INSERT INTO spavbl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Después del nacimiento de Arfaxad, Sem vivió 500 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Cuando Arfaxad tuvo 35 años, nació su hijo Selaj. ");
INSERT INTO spavbl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Después del nacimiento de Selaj, Arfaxad vivió 403 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Cuando Selaj tuvo 30 años, nació su hijo Éber. ");
INSERT INTO spavbl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Después del nacimiento de Éber, Selaj vivió 403 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Cuando Éber tuvo 34 años, nació su hijo Peleg. ");
INSERT INTO spavbl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Después del nacimiento de Peleg, Éber vivió 430 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Cuando Peleg tuvo 30 años, nació su hijo Reú. ");
INSERT INTO spavbl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Después del nacimiento de Reú, Peleg vivió 209 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Cuando Reú tuvo 32 años, nació su hijo Serug. ");
INSERT INTO spavbl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Después del nacimiento de Serug, Reú vivió 207 años más, y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Cuando Serug tuvo 30 años, nació su hijo Nacor. ");
INSERT INTO spavbl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Después del nacimiento de Nacor, Serug vivió 200 años más y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Cuando Nacor tuvo 29 años, nació su hijo Téraj. ");
INSERT INTO spavbl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Después del nacimiento de Téraj, Nacor vivió 119 años más, y tuvo más hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Cuando Téraj tuvi 70 años, nacieron sus hijos Abram, Nacor y Harán. ");
INSERT INTO spavbl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Esta es la genealogía de Téraj. Téraj fue el padre de Abram, Nacor y Harán. Harán fue el padre de Lot. ");
INSERT INTO spavbl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Sin embargo, Harán murió cuando su padre Téraj aún vivía en Ur de los caldeos, la tierra donde nació. ");
INSERT INTO spavbl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Tanto Abram como Nacor se casaron. La esposa de Abram se llamaba Sarai, y la esposa de Nacor se llamaba Milca. (Milca era hija de Harán, quien era padre tanto de Milca como de Jiscá). ");
INSERT INTO spavbl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai no podia quedar embarazada, por lo tanto no tenía hijos. ");
INSERT INTO spavbl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Téraj tomó a su hijo Abram, a su nieto Lot, (quien era el hijo de Arám), a su nuera Sarai, (que era la esposa de su hijo Abram), y se fue de Ur de los caldeos para mudarse a Canaán. Llegaron hasta Harán y se quedaron a vivir allí. ");
INSERT INTO spavbl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Téraj vivió 205 años y murió en Harán. ");
INSERT INTO spavbl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Y el Señor le dijo a Abram: “Deja tu país, tu familia y el hogar de tu familia, y vete al país que yo te mostraré. ");
INSERT INTO spavbl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Te convertiré en el predecesor de una gran nación y te bendeciré. Te daré una gran reputación y haré que seas una bendición para otros. ");
INSERT INTO spavbl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bendeciré a los que te bendigan, y maldeciré a los que te maldigan. Todos en la tierra serán benditos a través de ti”. ");
INSERT INTO spavbl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Así que Abram siguió las instrucciones del Señor, y Lot también se fue con él. Abram tenía 75 años cuando se fue de Harán. ");
INSERT INTO spavbl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Junto a él iba su esposa Sarai, su sobrino Lot, y llevaron consigo todas las posesiones que habían acumulado, así como a las personas que se les unieron en Harán. Salieron y se fueron hacia la tierra de Canaán. Cuando llegaron allí, ");
INSERT INTO spavbl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram viajó por todo el país hasta que llegó a un lugar llamado Siquén, haciendo una pausa en el roble que estaba en Moré. En ese tiempo, el país estaba ocupado por los caananitas. ");
INSERT INTO spavbl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Entonces el Señor se le apareció a Abram y le dijo: “Esta tierra te la daré a ti y a tus descendientes”. Así que Abram construyó un altar allí porque allí se le apareció el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Y entonces se mudó hacia la región montañosa, al oriente de Betel y armó su campamento allí. Betel estaba en el occidente Ay quedaba en el oriente. Abram construyó allí un altar al Señor y lo adoró. ");
INSERT INTO spavbl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Después se fue de allí, camino al Neguev. ");
INSERT INTO spavbl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Pero sucedió que una gran hambruna había azotado esta tierra. De modo que Abram siguió hacia Egipto, con planes de vivir allí, pues la hambruna era muy severa. ");
INSERT INTO spavbl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Al acercarse a Egipto, cuando estaba a punto de cruzar la frontera, Abram le dijo a su esposa Sarai: “Yo sé que eres una mujer muy hermosa. ");
INSERT INTO spavbl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Y cuando los egipcios te vean, dirán, ‘ella es su esposa,’ y me matarán, pero no a ti. ");
INSERT INTO spavbl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Así que mejor diles que eres mi hermana, para que me traten bien por ti, y así mi vida estará a salvo gracias a ti”. ");
INSERT INTO spavbl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Cuando Abram llegó a Egipto, la gente allí notó lo hermosa que era Sarai. ");
INSERT INTO spavbl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Los oficiales del faraón se dieron cuenta también y le hablaron al faraón bien de Sarai. Así que Sarai fue llevada a su palacio para convertirse en una de sus esposas. ");
INSERT INTO spavbl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Y el faraón trataba bien a Abram por causa de ella, y le dio ovejas y ganado, así como asnos y asnas, y además sirvientes tanto hombres como mujeres, y camellos. ");
INSERT INTO spavbl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pero el Señor hizo que el faraón y los que habitaban en su palacio sufrieran una terrible enfermedad por causa de Sarai, la esposa de Abram. ");
INSERT INTO spavbl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Así que el faraón ordernó que trajeran a Abram delante de él, y le dijo: “¿Qué me has hecho? ¿Por qué no me dijiste que ella era tu esposa? ");
INSERT INTO spavbl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","¿Por qué dijiste ‘ella es mi hermana,’ y me dejaste traerla para convertirse en una de mis esposas? ¡Aquí tienes a tu esposa! ¡Llévatela y vete!” ");
INSERT INTO spavbl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Y el faraón dio orden a sus guardas para que lo expulsaran a él y a su esposa del país, junto a todos los que iban con él y todas sus posesiones. ");
INSERT INTO spavbl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Así que Abram se fue de Egipto y regresó al Neguev con Sarai, Lot, y todos los que iban con él, así como sus posesiones. ");
INSERT INTO spavbl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram era muy rico, y tenía muchas manadas de ganado y mucha plata y oro. ");
INSERT INTO spavbl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Se fue el Neguevy comenzó su viaje por partes hasta Betel, de regreso al lugar donde había acampado antes, entre Betel y Ay. ");
INSERT INTO spavbl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Fue aquí donde había construido un altar por primera vez. Entonces adoró al Señor allí, como lo había hecho antes. ");
INSERT INTO spavbl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, quien viajaba con Abram, también tenía muchos rebaños, manadas y tiendas, ");
INSERT INTO spavbl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","tantas que la tierra disponible no alcanzaba para que ambos vivieran allí, pues tenían tanto ganado, que ya no podrían habitar juntos en el mismo lugar. ");
INSERT INTO spavbl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Los granjeros de Abram discutían con los de Lot; además los cananeos y los fereceos también habitaban la tierra en ese momento. ");
INSERT INTO spavbl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Así que Abram le dijo a Lot: “Por favor, evitemos las discordias entre nosotros y entre nuestros granjeros, pues somos familia. ");
INSERT INTO spavbl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","¿Ves toda esta tierra disponible delante de ti? Debemos dividirnos. Así que si decides ir por la izquierda, yo iré por la derecha; y si decides ir por la derecha, yo iré por la izquierda”. ");
INSERT INTO spavbl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot miró todo el valle del Jordán, en dirección a Zoar, y vio que estaba bien abastecido de agua, y que lucía como el jardín de Edén, como la tierra de Egipto. (Esto era antes de que el Señor destruyera a Sodoma y Gomorra). ");
INSERT INTO spavbl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Así que Lot eligió todo el valle del Jordán y se fue hacia el oriente, y así los dos se separaron. ");
INSERT INTO spavbl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram se fue a vivir a la tierra de Canán mientras que Lot se asentó entre las ciudades del valle, estableciendo su campamento en Sodoma. ");
INSERT INTO spavbl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","(El pueblo de Sodoma era muy perverso, y cometían pecados terribles que ofendían al Señor). ");
INSERT INTO spavbl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Después de separarse de Lot, el Señor le dijo a Abram: “Desde donde estás, mira a tu alrededor, hacia el norte, el sur, el oriente y el occidente. ");
INSERT INTO spavbl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Toda esta tierra que ves, te la daré a ti y a tus descendientes para siempre. ");
INSERT INTO spavbl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Y tendrás tantos descendientes que serán como el polvo de la tierra. ¡Quien quiera contar tus descendientes será quien pueda contar el polvo de la tierra! ");
INSERT INTO spavbl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ve y camina por toda la tierra, en todas las direcciones, porque yo te la he dado”. ");
INSERT INTO spavbl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Así que Abram se fue a vivir a Hebrón, y estableció su campamento entre los robles de Mamré, donde construyó un altar al Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","En aquél tiempo Amrafel era el rey de Sumeria, y se había aliado con Arioc, rey de Elasar, Quedorlaómer, rey de Elam, y con Tidal, rey de Goyim. ");
INSERT INTO spavbl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Juntos atacaron a Bera, el rey de Sodoma, a Birsá, rey de Gomorra, a Sinab, rey de Admá, a Semeber, rey de Zeboyín, y al rey de Bela (que también se le conocía como Zoar). ");
INSERT INTO spavbl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Todos estos en el segundo grupo se aliaron en el Valle de Sidín (el valle del Mar Muerto). ");
INSERT INTO spavbl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Habían estado bajo el gobierno de Quedorlaómer durante doce años, pero en el decimotercer año se rebelaron contra él. ");
INSERT INTO spavbl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","En el decimocuarto año, Querdolaómer los invadió junto con sus reyes aliados. Vencieron a los refaítas en Astarot Carnayin, a los zuzitas en Jam, a los emitas en Save Quiriatayin, ");
INSERT INTO spavbl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","y a los horeos en su propia región montañosa de Seir, llegando hasta El Parán, junto al desierto. ");
INSERT INTO spavbl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Entonces regresaron y atacaron a Enmispat (conocida también como Cades) y conquistaron todo el país que le pertenecía a los amalecitas, así como a los amorreos que vivían en Jazezón Tamar. ");
INSERT INTO spavbl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Entonces los reyes de Sodoma, Gomorra, Admá, Zeboyín y Bela (es decir, Zoar), marcharon y se prepararon para la batalla en el Valle de Sidín. ");
INSERT INTO spavbl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Pelearon contra Quedorlaómer, rey de Elam; Tidal, rey de Goyim; Amrafel, rey de Sumeria; y Aric, rey de Elasar. Eran cuatro reyes uno al lado del otro contra cinco. ");
INSERT INTO spavbl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","En ese tiempo, había muchos pozos de alquitrán en el Valle de Sidín, y cuando los reyes de Sodoma y Gomorra huían tras ser vencidos, algunos de sus hombres cayeron en ellos, mientras los demás corrieron hacia las montañas. ");
INSERT INTO spavbl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Los invasores saquearon todas las posesiones y alimento de Sodoma y Gomorra, y se fueron. ");
INSERT INTO spavbl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","También capturaron a Lot, el sobrino de Abram, y tomaron sus posesiones, porque también vivía en Sodoma. ");
INSERT INTO spavbl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Pero uno de los capturados escapó y fue a decirle a Abram el hebreo lo que había sucedido. Abram vivía entre los robles de Mamré el amorreo, quien era hermano de Escol y Aner. Todos ellos eran aliados de Abram. ");
INSERT INTO spavbl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Cuando Abram se enteró de que su sobrino había sido capturado, convocó a 318 hombres guerreros que habían nacido en su hogar para que los persiguieran hasta llegar a Dan. ");
INSERT INTO spavbl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Allí dividió a sus hombres en grupos y atacaron por la noche, venciendo al enemigo y persiguiéndolos hasta llegar a Hobá, al norte de Damasco. ");
INSERT INTO spavbl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram recuperó todo lo que ellos habían tomado, incluyendo a Lot y sus posesiones, y además trajo consigo a las mujeres y a otras personas que habían sido capturadas. ");
INSERT INTO spavbl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Cuando Abram regresó después de conquistar a Quedorlaómer y a sus aliados, el rey de Sodoma salió a su encuentro en el Valle de Save (o Valle del Rey). ");
INSERT INTO spavbl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melquisedec, rey de Salem, trajo pan y vino. Él era sacerdote del Dios Altísimo. ");
INSERT INTO spavbl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Y bendijo a Abram, diciéndole: “Que tú, Abram, seas bendito por el Altísimo, Creador del cielo y de la tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Que el Altísimo sea alabado, por entregar en tu mano a tus enemigos”. Entonces Abram le dio a Melquisedec una décima parte de todo. ");
INSERT INTO spavbl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","El rey de Sodoma le dijo a Abram: “Devuélveme a mi gente, y quédate con todo lo demás”. ");
INSERT INTO spavbl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Pero Abram le respondió al rey de Sodoma: “Levanto mi mano, haciendo una promesa solemne al Señor, al Dios Altísimo, Creador del cielo y de la tierra, ");
INSERT INTO spavbl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","que me niego a guardar cualquiera de tus pertenencias, ni siquiera un hilo ni la correa de una sandalia. De lo contrario podrías decir: ‘¡Yo fui quien hizo rico a Abram!’ ");
INSERT INTO spavbl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Por lo tanto no me quedaré con nada, excepto lo que mis hombres han comido, y la parte de los que me han acompañado, es decir, permite que Aner, Escol, y Mamré conserven su parte”. ");
INSERT INTO spavbl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Después de todo esto, Dios habló con Abram en una visión, y le dijo: “¡No tengas miedo, Abram! ¡Yo soy tu protector y tu gran recompensa!” ");
INSERT INTO spavbl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Pero Abram respondió: “Señor Dios, ¿de qué me beneficiará cualquier cosa que me des? No tengo hijos, y el único heredero de todo lo que tengo es Eliezer de Damasco”. ");
INSERT INTO spavbl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Y Abram continuó, expresando tu queja: “¡Mira, no me has dado hijos, y me toca darle toda mi herencia a un sirviente de mi casa!” ");
INSERT INTO spavbl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Pero entonces el Señor le dijo: “Este hombre no será tu heredero. Tu heredero será tu propio hijo”. ");
INSERT INTO spavbl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Entonces el Señor llevó a Abram afuera y le dijo: “Mira al cielo, y dime si puedes contar las estrellas. ¡Así será la cantidad de descendientes que tendrás!” ");
INSERT INTO spavbl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Y Abram creyó en lo que el Señor le dijo, y el Señor concluyó que Abram y él tenían una relación buena. ");
INSERT INTO spavbl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","El Señor también le dijo: “Yo soy el Señor, que te saqué de Ur de los caldeos para darte esta tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","“Pero Señor, ¿cómo podré estar seguro de que es mía?” preguntó Abram. ");
INSERT INTO spavbl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Entonces el Señor me dijo: “Tráeme una vaca, una cabra y un carnero, todos de tres años de edad, y además una paloma adulta y una paloma joven”. ");
INSERT INTO spavbl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Así que Abram mató a los tres animales, luego los cortó por la mitad, y puso cada mitad frente a la otra. Sin embargo, no cortó a las aves por la mitad. ");
INSERT INTO spavbl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Cuando los buitres descendían para comerse los cadáveres, Abram los espantaba. ");
INSERT INTO spavbl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Cuando se puso el sol, Abram sintió mucho sueño, y a la vez una oscuridad espesa y terrible se posó sobre él. ");
INSERT INTO spavbl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Entonces el Señor le explicó a Abram: “Puedes estar seguro de que tus descendientes serán extranjeros en otras naciones, donde sufrirán esclavitud y maltratados por 400 años. ");
INSERT INTO spavbl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Sin embargo, yo castigaré a la nación que los tendrá como esclavos, y después tus descendientes saldrán, llevándose muchas posesiones de gran valor. ");
INSERT INTO spavbl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pero en lo que a ti concierne, morirás en paz y serás sepultado después de haber vivido una buena vida. ");
INSERT INTO spavbl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Cuatro generaciones más tarde, tus descendientes volverán para vivir aquí, porque ahora mismo los pecados de los amonitas no han logrado su máximo alcance”. ");
INSERT INTO spavbl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Después de que el sol se puso y se hizo de noche, de repente apareció un horno echando humo y una antorcha encendida que pasaba entre las mitades de los cadáveres de los animales. ");
INSERT INTO spavbl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Así fue como el Señor hizo un acuerdo con Abram ese día, y le prometió: “Yo le daré esta tierra a tus descendientes. Se extiende desde el Wadi de Egypto hasta el gran río Éufrates, ");
INSERT INTO spavbl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","e incluye el territorio de los quenitas, los quenizitas, los cadmoneos, ");
INSERT INTO spavbl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","los heteos, los ferezeos, los refaítas, ");
INSERT INTO spavbl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","los amorreos, los cananeos, los gergeseos, y los jebuseos”. ");
INSERT INTO spavbl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, la esposa de Abram, no había podido darle hijos. Sin embargo, ella poseía una esclava egipcia cuyo nombre era Agar, ");
INSERT INTO spavbl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","así que Sarai le dijo a Abram: “Por favor, escúchame. El Señor no me permite tener hijos. Así que por favor ve y acuéstate con mi esclava. Depronto así podré tener una familia por medio de ella”. Abram aceptó la sugerencia de Sarai. ");
INSERT INTO spavbl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Así que Sarai, la esposa de Abram, tomó a su esclava egipcia Agar, y se la entregó a su esposo como su esposa. Abram había estado viviendo en la tierra de Canaán por diez años cuando esto sucedió. ");
INSERT INTO spavbl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram se acostó con Agar y ella quedó embarazada. Cuando ella se dio cuenta de que estaba embarazada, comenzó a tratar a Sarai con desdén. ");
INSERT INTO spavbl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Entonces Sarai se quejó con Abram: “¡Esto que estoy sufriendo es por tu culpa! Te entregué a mi esclava para que te acostaras con ella, y ahora que sabe que está embarazada me trata con menosprecio. ¡Que el Señor decida entre los dos quién es el culpable, si tú o yo!” ");
INSERT INTO spavbl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","“¡Es tu esclava!” respondió Abram. “Puedes hacer con ella lo que quieras”. Y Sarai trataba a Agar con tanta crueldad, que Agar huyó. ");
INSERT INTO spavbl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Entonces el ángel del Señor vino al encuentro de Agar junto un manantial en el desierto que está de camino al sur. ");
INSERT INTO spavbl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Y le preguntó: “¿De dónde vienes, Agar, esclava de Sarai, y hacia dónde vas?” “Estoy huyendo de mi señora Sarai”, respondió Agar. ");
INSERT INTO spavbl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","“Vuelve a donde tu señora y obedécele”, le dijo el ángel del Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Y continuó diciendo: “Yo te daré muchos descendientes, y serán tantos que no podrán contarse”. ");
INSERT INTO spavbl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Y siguió diciéndole: “Escucha, ahora estás embarazada y tendrás un hijo. Le pondrás por nombre Ismael, porque el Señor ha escuchado cuánto has sufrido. ");
INSERT INTO spavbl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Él será como un asno salvaje, que peleará con todos, y todos pelearán con él. Siempre estará en discordia con sus familiares”. ");
INSERT INTO spavbl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Desde ese momento, Agar clamó al Señor que habló con ella: “Eres el Dios que me ve”, porque ella dijo: “Aquí vi al que me ve”. ");
INSERT INTO spavbl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Es por ese que ese pozo se llama “el pozo del Ser Viviente que me ve”. Aún existe entre Cades y Béred. ");
INSERT INTO spavbl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar dio a luz un hijo para Abram, y Abram le puso por nombre Ismael. ");
INSERT INTO spavbl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Cuando Agar tuvo a Ismael, Abram tenían 86 años. ");
INSERT INTO spavbl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Cuando Abram tenía 99 años, el Señor se le apreció y le dijo: “Yo soy el Dios Altísimo. Vive en mi presencia y haz el bien. ");
INSERT INTO spavbl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Yo haré mi pacto contigo, y te daré muchos descendientes”. ");
INSERT INTO spavbl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram se inclinó y puso su rostro en el suelo. Y Dios le dijo: ");
INSERT INTO spavbl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“¡Escucha, Abram! Este es el acuerdo que hago contigo. Serás el padre de muchas naciones, ");
INSERT INTO spavbl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","así que tu nombre ya no será más Abram. En su lugar, tunombre será Abraham porque yo te haré padre de muchas naciones. ");
INSERT INTO spavbl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yo me aseguraré de que tengas un gran número de descendientes. Ellos se transformarán en muchas naciones y algunos de sus reyes también vendrán de tu linaje. ");
INSERT INTO spavbl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Yo te prometo guardar mi pacto contigo, y con tus descendientes, por todas las generaciones futuras. Este es un pacto eterno. Yo siempre seré tu Dios y el Dios de tus descendientes. ");
INSERT INTO spavbl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Yo te daré a ti y a tus descendientes todo el país de Canaán—donde has vivido como extranjero—como tu tierra para siempre, y yo seré su Dios”. ");
INSERT INTO spavbl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Entonces Dios le dijo a Abraham: “Tu parte consiste en guardar mi pacto, tanto tú como tus descendientes, por todas las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Este es mi acuerdo contigo y con tus descendientes, el acuerdo que debes guardar: Todo hombre entre ustedes será circuncidado. ");
INSERT INTO spavbl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Vas a circuncidar la carne de tu prepucio, y esta será la señal del pacto entre mi y ustedes. ");
INSERT INTO spavbl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Desde ahora y por todas las generaciones, todo hombre entre ustedes será circuncidado a los 8 días después de nacer. Esto no solo se aplicará a tus hijos sino a todo varón que nazca en tu casa, o que sea comprado de los extranjeros. ");
INSERT INTO spavbl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Debes circuncidar a los varones nacidos en tu casa o comprado de los extranjeros, como señal externa de mi pacto. ");
INSERT INTO spavbl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Cualquier varón incircunciso que se niegue a circuncidarse será expulsado del pueblo, porque habrá quebrantado mi pacto”. ");
INSERT INTO spavbl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Entonces Dios le dijo a Abraham: “Ahora, en lo que concierne a Sarai, tu esposa, nunca más la llamarán Sarai. Ahora su nombre será Sara. ");
INSERT INTO spavbl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yo la bendeciré y prometo darte un hijo por medio de ella. Yo la bendeciré para que se convierta en la madre de todas las naciones, y habrá reyes entre sus descendientes”. ");
INSERT INTO spavbl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham se inclinó y puso su rostro en el suelo. Pero por dentro se reía, y se preguntaba: “¿Cómo podré tener un hijo a la edad de cien años? ¿Cómo podría Sara tener un hijo a sus noventa años?” ");
INSERT INTO spavbl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham le dijo a Dios: “¡Que Ismael viva siempre con tu bendición!” ");
INSERT INTO spavbl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","“¡No, será tu esposa Sara quien te dará un hijo!” respondió Dios. “Lo llamarás Isaac. Yo guardaré mi pacto con él y con sus descendientes como un pacto eterno. ");
INSERT INTO spavbl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ahora bien, en lo que a Ismael se refiere, escuché lo que dijiste y también lo bendeciré. Me aseguraré de que tenga muchos descendientes. Será el padre de doce príncipes, y yo lo convertiré en una gran nación. ");
INSERT INTO spavbl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pero guardaré mi pacto con Isaac, el hijo que tendrá Sara para estos días el próximo año”. ");
INSERT INTO spavbl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Cuando Dios terminó de hablar con Abraham, se retiró de su presencia. ");
INSERT INTO spavbl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ese día Abraham circuncidó a su hijo Ismael y a todos los que habían nacido en su casa, así como a los que había comprado, y todos los varones que habitaban en su casa, tal como Dios se lo dijo. ");
INSERT INTO spavbl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham tenían 99 años cuando fue circuncidado, ");
INSERT INTO spavbl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","y su hijo Ismael tenía 13 años. ");
INSERT INTO spavbl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tanto Abraham como su hijo Ismael fueron circuncidados en el miso día. ");
INSERT INTO spavbl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Todos los hombres en la casa de Abraham, incluyendo los nacidos o comprados como esclavos extranjeros, fueron circuncidados con él. ");
INSERT INTO spavbl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","El Señor se le apareció a Abraham en medio de los robles de Mamré. Abraham estaba sentado a la entrada de su tienda, pues hacía mucho calor ese día. ");
INSERT INTO spavbl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham levantó la vista y de repente vio a tres hombres en pie. Al verlos, corrió a su encuentro y se inclinó hasta el suelo. ");
INSERT INTO spavbl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Entonces les dijo: “Señor, si le parece bien, no siga su camino sin antes hospedarse conmigo, en la casa de su siervo. ");
INSERT INTO spavbl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Permítanme traerles agua para lavarse sus pies, y para que descansen junto al árbol. ");
INSERT INTO spavbl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","También permítanme traerles algo de comer para que puedan recobrar sus fuerzas cuando sigan el camino, ahora que ha venido a visitarme”. “Nos parece bien”, respondieron ellos. “Haz lo que has dicho”. ");
INSERT INTO spavbl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham se apresuró a la tienda y le dijo a Sara: “¡Apresúrate! Prepara pan con tres medidas grandes de la mejor harina. Amasa la masa y prepara el pan”. ");
INSERT INTO spavbl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Entonces Abraham corrió hasta donde estaba el ganado y eligió un becerro bueno y joven, y se lo dio a su siervo, quien lo mató y lo cocinó rápidamente. ");
INSERT INTO spavbl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Entonces Abraham tomó un poco de yogurt yleche, y cocinó la carne. Luego trajo la comida delante de los tres hombres y se quedó cerca junto a un árbol mientras ellos comían. ");
INSERT INTO spavbl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“¿Dónde está tu esposa Sara?” le preguntaron. “Está allá adentro, en la tienda”, les contestó. ");
INSERT INTO spavbl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Entonces uno de ellos le dijo: “Te prometo que el próximo año volveré a visitarte por estos días, y tu esposa Sara tendrá un hijo”.Y Sara estaba escuchando mientras se ocultaba a la entrada de la tienda, detrás de él. ");
INSERT INTO spavbl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham y Sara ya estaban viejos y eran de edad avanzada. Y Sara ya había pasado su edad fértil. ");
INSERT INTO spavbl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara se estaba riendo dentro de la tienda, y decía para sí: “¿Cómo podría experimentar placer alguno ahora que estoy vieja y cansada? ¡Mi esposo también está viejo!” ");
INSERT INTO spavbl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Entonces el Señor le preguntó a Abraham: “¿Por qué Sara se rió, y preguntó ‘¿cómo podré tener un hijo ahora que estoy tan vieja?’ ");
INSERT INTO spavbl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Acaso hay algo difícil para el Señor? Volveré el próximo año durante la primavera, tal como te lo dije, y para entonces Sara tendrá un hijo”. ");
INSERT INTO spavbl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Entonces Sara tuvo temor y negó el hecho, diciendo: “Yo no me reí”. “Sí, te reíste”, respondió el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Entonces los hombres se fueron. Miraron en dirección a Sodoma y se dirigieron hacia allá. Y Abraham los acompañó parte del camino. ");
INSERT INTO spavbl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Entonces el Señor dijo: “¿Debería ocultarle a Abraham lo que voy a hacer? ");
INSERT INTO spavbl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham sin duda será una nación grande y ponderosa, y todas las naciones de la tierra serán benditas a través de él. ");
INSERT INTO spavbl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Yo lo he elegido para que le enseñe a sus hijos y a su familia a seguir el camino del Señor haciendo lo que es bueno, a fin de que yo, el Señor, pueda cumplir lo que le he prometido a Abraham”. ");
INSERT INTO spavbl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Entonces el Señor continuó diciendo: “Hay muchas quejas expresadas contra Sodoma y Gomorra a causa de su pecado descarado. ");
INSERT INTO spavbl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Voy a ver si estas quejas son ciertas. Si no lo son, de seguro lo sabré”. ");
INSERT INTO spavbl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Los dos hombres se dieron la vuelta y se dirigieron a Sodoma, pero el Señor se quedó con Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Entonces Abraham se le acercó y le preguntó: “¿En serio vas a destruir a las personas buenas junto con las malvadas? ");
INSERT INTO spavbl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","¿Qué pasa si hay cincuenta buenas personas en la ciudad? ¿Vas a destruir la ciudad a pesar de que haya cincuenta personas buenas allí? ");
INSERT INTO spavbl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","¡No puedes hacer algo así! No puedes matar a las personas buenas junto con las malvadas, pues estarías tratando a buenos y malos del mismo modo. ¡No puedes actuar así! ¿No actuará con justicia el Juez de toda la tierra?” ");
INSERT INTO spavbl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","“Si encuentro a cincuenta personas buenas en Sodoma, perdonaré a toda la ciudad por causa de ellos”, respondió el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","“Como ya comencé, permíteme seguir hablando con mi Señor, aunque no soy nadie sino apenas polvo y cenizas”, continuó Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","“¿Qué si hay cuarenta y cinco personas buenas – solo cinco menos – ¿Aun así vas a destruir toda la ciudad solo porque son menos personas buenas?” “No la destruiré si encuentro cuarenta y cinco personas buenas”, respondió el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Entonces Abraham habló nuevamente y le preguntó al Señor: “¿Qué pasaría y solo hay cuarenta?” “No lo hare por causa de las cuarenta personas”, respondió el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","“Mi Señor, no te enojes conmigo”, continuó Abraham. “Pero permíteme preguntarte esto: ¿Qué pasaría si hay treinta?” “No lo hare por causa de las treinta personas”, respondió el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","“Debo admitir que he sido osado en hablar de esta manera con mi Señor”, dijo Abraham. “¿Qué sucedería si solo hubiera veinte personas buenas?” “No lo haré por causa de las 20 personas”, respondió el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","“Por favor, no te enojes conmigo, mi Señor”, dijo Abraham. “Solo permíteme preguntar una cosa más. ¿Qué pasaría si hay solamente diez personas buenas?” “No la destruiré por causa de las diez personas”, respondió el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Entonces el Señor se fue cuando terminó de hablar con Abraham, y Abraham se fue a casa. ");
INSERT INTO spavbl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Los dos ángeles llegaron esa noche a Sodoma. Lot estaba sentado en la puerta de la ciudad. Y cuando vio a los hombres se levantó para recibirlos, y se inclinó con su rostro en tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Señores, por favor, entren y quédense en mi casa esta noche”, les dijo. “Pueden lavar sus pies y seguir su camino temprano por la mañana”. Pero ellos le respondieron: “No te preocupes. Pasaremos la noche aquí en la plaza”. ");
INSERT INTO spavbl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pero Lot insistió y los dos hombres fueron con él a su casa. Les preparó alimentos y coció pan para que comieran. ");
INSERT INTO spavbl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Pero ellos ni siquiera se habían ido aún a la cama cuando unos hombres de Sodoma, jóvenes y adultos, de cada parte de la ciudad, vinieron y rodearon la casa. ");
INSERT INTO spavbl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Entonces le gritaron a Lot: “¿Dónde están los hombres que se hospedaron en tu casa esta noche? Tráelos, pues queremos tener sexo con ellos”. ");
INSERT INTO spavbl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Entonces Lot salió a hablar con ellos en la entrada de su casa, cerrando la puerta al salir. ");
INSERT INTO spavbl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“¡Amigos, por favor, no cometan tal perversidad! ");
INSERT INTO spavbl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Como verán, tengo dos hijas vírgenes. Puedo traerlas para que hagan con ellas lo que quieran, pero por favor no le hagan nada a estos hombres. Yo soy responsable de cuidarlos”. ");
INSERT INTO spavbl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“¡Apártate de nuestro camino!” gritaron. “¿Quién crees que eres, que vienes a vivir aquí, y ahora tratas de juzgarnos? ¡A ti te haremos peores cosas que las que íbamos a hacerles a ellos!” Entonces empujaron a Lot y trataban de derribar la puerta. ");
INSERT INTO spavbl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pero los hombres que estaban dentro de la casa salieron y tomaron a Lot, lo trajeron dentro y cerraron la puerta de golpe. ");
INSERT INTO spavbl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Entonces hicieron que todos los hombres que estaban en la entrada de la casa, jóvenes y adultos, quedasen ciegos, así que no podían encontrar la puerta. ");
INSERT INTO spavbl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Entonces los dos hombres le preguntaron a Lot: “¿Hay alguien más en tu familia, como yernos, hijos e hijas, o alguna otra persona en la ciudad? Si es así, asegúrate de que se vayan, ");
INSERT INTO spavbl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","porque estamos a punto de destruir este lugar. Las quejas que han subido hasta el Señor son tan graves que él nos ha enviado a destruirla”. ");
INSERT INTO spavbl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","De inmediato Lot fue a hablar con los hombres que estaban comprometidos con sus hijas. “¡Levántense y salgan de aquí!” les dijo, “porque el Señor está a punto de destruir la ciudad!” Pero ellos pensaron que se trataba de una broma. ");
INSERT INTO spavbl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Al atardecer, los ángeles le rogaron a Lot que se apresurara, diciéndole: “¡Apúrate! Sal ahora mismo con tu esposa y con tus dos hijas de aquí, de lo contrario serán destruidas cuando caiga el castigo sobre la ciudad”. ");
INSERT INTO spavbl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Pero Lot dudó. Entonces los hombres tomaron a Lot, a su esposa y a sus hijas por la mano, y los arrastraron hasta llevarlos fuera de la ciudad. El Señor fue misericordioso en hacer esto con ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tan pronto salieron de la ciudad, uno de los hombres dijo: “¡Corran y salven sus vidas! ¡No miren hacia atrás y no se detengan en ninguna parte para ir por el valle! ¡Corran hacia las montañas, o serán destruidos!” ");
INSERT INTO spavbl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","“¡Señor, por favor, no me hagas esto!” respondió Lot. ");
INSERT INTO spavbl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","“Si bien te parece, ya que has sido tan misericordioso en salvar mi vida, no me hagas correr hacia las montañas, pues no podré lograrlo. ¡La destrucción me alcanzará y moriré! ");
INSERT INTO spavbl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Hay una ciudad cerca, a la cual puedo correr y es muy pequeña. Por favor, déjame correr hasta allí, pues es muy pequeña y así podré salvar mi vida”. ");
INSERT INTO spavbl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","“Está bien. Haré lo que me pides”, respondió el Señor. “No destruiré la ciudad que me has mencionado. ");
INSERT INTO spavbl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pero apresúrate y vete allí rápidamente, porque no podré continuar hasta que estés allí”. (Por esto esta ciudad se llamó Zoar). ");
INSERT INTO spavbl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Cuando Lot llegó a Zoar ya había salido el sol. ");
INSERT INTO spavbl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Entonces el Señor hizo llover fuego y azufre desde el cielo sobre Sodoma y Gomorra. ");
INSERT INTO spavbl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Y destruyó las ciudades por completo con todos sus habitantes, así como el valle y todos los cultivos que estaban creciendo allí. ");
INSERT INTO spavbl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pero la esposa de Lot, que se había quedado atrás, miró hacia atrás y de inmediato se convirtió en una estatua de sal. ");
INSERT INTO spavbl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","A la mañana siguiente, Abraham se levantó temprano y regresó al lugar donde había hablado con el Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Y miró en dirección de Sodoma y Gomorra, así como todo el valle, y vio la tierra ardiendo en llamas, expulsando humo como si fuera un horno. ");
INSERT INTO spavbl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Cuando Dios destruyó las ciudades del valle, no se olvidó de la promesa que le había hecho a Abraham, y salvó a Lot de la destrucción de las ciudades donde él vivía. ");
INSERT INTO spavbl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot tuvo miedo de quedarse en Zoar, así que salió de la ciudad y se fue a vivir con sus dos hijas en una cueva, en las montañas. ");
INSERT INTO spavbl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Algún tiempo después, la hija mayor de Lot le dijo a su hermana menor: “Nuestro padre está envejeciendo, y no queda ningún hombre que nos pueda dar hijos como a las demás. ");
INSERT INTO spavbl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Emborrachemos a nuestro padre con vino, y acostémonos con él para que podamos hacer crecer esta familia”. ");
INSERT INTO spavbl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Así que esa noche emborracharon a su padre con vino. La hija mayor se acostó con él, y él no se dio cuenta cuando ella se acostó, ni cuando se levantó. ");
INSERT INTO spavbl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Al día siguiente, la hija mayor le dijo a la hija menor : “Anoche yo me acosté con nuestro padre. Emborrachémoslo esta noche otra vez para que tú puedas acostarte con él y podamos hacer crecer esta familia”. ");
INSERT INTO spavbl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Así que una vez más, esa noche emborracharon a su padre con vino, y la hija menor fue y se acostó con él. Y Lot no se dio cuenta cuando ella se acostó ni cuando se levantó. ");
INSERT INTO spavbl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Fue así como ambas hijas de Lot quedaron embarazadas de su propio padre. ");
INSERT INTO spavbl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","La hija mayor tuvo un hijo, al que llamó Moab. Él es el ancestro de los moabitas hasta hoy. ");
INSERT INTO spavbl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","La hija menor también tuvo un hijo, al que llamó Ben-ammi. Él es el ancestro de los amonitas hasta hoy. ");
INSERT INTO spavbl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham emprendió viaje hacia el Neguev, y se quedó entre Cades y Sur. Después se mudó y se fue a vivir a Gerar. ");
INSERT INTO spavbl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Mientras vivía allí, cada vez que hablaba de Sara decía “Es mi hermana”. De modo que Abimelec, el rey de Gerar, mandó a llamar a Sara y la tomó para que fuera una de sus esposas. ");
INSERT INTO spavbl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pero Dios se le apareció a Abimelec en un sueño, y le dijo: “¡Presta atención! Morirás, porque la mujer que has tomado ya está casada. Ella tiene un esposo”. ");
INSERT INTO spavbl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelec no había tocado a Sara, y preguntó: “Señor, ¿acaso tú matas a las personas buenas? ");
INSERT INTO spavbl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","¿Acaso no me dijo el mismo Abraham ‘ella es mi hermana,’ y acaso no dijo ella misma ‘él es mi hermano’? ¡Hice esto siendo inocente y mi conciencia está limpia!” ");
INSERT INTO spavbl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dios le dijo en el sueño: “Sí, sé que hiciste esto con toda inocencia, y evité que pecaras contra mi. Por eso no permití que la tocaras. ");
INSERT INTO spavbl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Envía a esta mujer con su esposo. Él es un profeta, y orará por ti, y tú vivirás. Pero si no la envías de regreso, debes saber que tú y toda tu familia morirán”. ");
INSERT INTO spavbl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelec se levantó temprano a la mañana siguiente y reunió a todos sus sirvientes. Les explicó lo ocurrido, y todos estaban aterrorizados. ");
INSERT INTO spavbl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Entonces Abimelec mandó a llamar a Abraham y le preguntó: “¿Qué has venido a hacernos? ¿Qué mal te he hecho para que me trates de esta manera, trayendo este pecado terrible sobre mi y mi reino? ¡Has hecho cosas que nadie debería hacer!” ");
INSERT INTO spavbl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Y Abimelec le preguntó a Abraham: “¿En qué estabas pensando cuando hiciste esto?” ");
INSERT INTO spavbl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","“Pues yo dije para mí: ‘Nadie respeta a Dios en este lugar. Me matarán para quedarse con mi esposa,’” respondió Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","“De cualquier modo, ella es mi hermana, porque es la hija de mi padre, pero no de mi madre, y yo me casé con ella. ");
INSERT INTO spavbl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ya que Dios me hizo dejar a mi familia, le dije: ‘Si de verdad me amas, dondequiera que vayas conmigo dirás: Él es mi hermano’”. ");
INSERT INTO spavbl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Entonces Abimelec le dio a Abraham regalos de ovejas, rebaños, esclavos y esclavas, y le devolvió a Sara. ");
INSERT INTO spavbl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Y le dijo: “Contempla mi tierra, y elige dónde quieres vivir”. ");
INSERT INTO spavbl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Y a Sara le dijo: “Ten en cuenta que le he dado a tu esposo mil piezas de plata. Esto es para compensar el mal que te hemos hecho ante los ojos de los que estaban contigo, y para que tu nombre quede limpio ante todos los demás”. ");
INSERT INTO spavbl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Entonces Abraham oró a Dios, y Dios sanó a Abimelec ya su esposa; y también sanó a sus esclavas, a fin de que nuevamente pudieran engendrar hijos. ");
INSERT INTO spavbl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Porque el Señor había hecho que las mujeres fueran infértiles porque se habían llevado a Sara, la esposa de Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Y el Señor vino a ayudar a Sara, tal como se lo había prometido. El Señor cumplió la promesa que le había hecho a Sara. ");
INSERT INTO spavbl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara quedó embarazada y tuvo un hijo de Abraham cuando ya era viejo, en el tiempo exacto, como Dios lo había dicho. ");
INSERT INTO spavbl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham llamó a su hijo Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Y lo circuncidó a los ocho días de nacido, según el mandato de Dios. ");
INSERT INTO spavbl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Y Abraham tenía 100 años cuando nació Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara entonces declaró: “Dios me ha hecho reír, y todos los que escuchen acerca de esto se reirán conmigo”. ");
INSERT INTO spavbl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Además dijo: “¿Habría podido alguien decirle a Abraham que Sara tendría que dar de mamar a un hijo suyo? ¡Y ahora he tenido un hijo de Abraham aún su vejez!” ");
INSERT INTO spavbl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Y el bebé creció, y el día que fue destetado Abraham hizo una gran fiesta. ");
INSERT INTO spavbl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Pero Sara se dio cuenta de que Ismael, el hijo que la esclava egipcia Agar había tenido para Abraham, se burlaba de Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Entonces Sara fue donde Abraham y le dijo: “Tienes que deshacerte de esa mujer esclava y de su hijo! ¡Un hijo de esa esclava no será coheredero con mi hijo Isaac!” ");
INSERT INTO spavbl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham se sintió muy triste porque Ismael era su hijo también. ");
INSERT INTO spavbl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pero Dios le dijo a Abraham: “No te sientas mal en cuanto al hijo de la mujer esclava. Haz lo que Sara te pide, porque tu descendencia será contada a través de Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Así que no te preocupes, porque yo también convertiré al hijo de la esclava en una gran nación, porque él también es tu hijo”. ");
INSERT INTO spavbl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","A la mañana siguiente, Abraham se levantó temprano. Empacó alimentos y un odre con agua para Agar, y puso todo esto en sus hombros. Entonces los despidió. Ella se fue y anduvo errante por el desierto de Beerseba. ");
INSERT INTO spavbl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Cuando se le acabó el agua, dejó al niño en medio de unos arbustos. ");
INSERT INTO spavbl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Entonces se fue y se sentó a cierta distancia, a unos cientos de yardas de distancia, pues pensaba: “¡No podré soportar ver a mi hijo morir!” Y al sentarse, reventó en llanto. ");
INSERT INTO spavbl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dios escuchó el llanto del niño, y el ángel de Dios llamó a Agar desde el cielo y le preguntó: “¿Qué ocurre, Agar? ¡No tengas miedo! Dios ha escuchado el llanto del niño desde donde está. ");
INSERT INTO spavbl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Levántate, ve a ayudar a tu hijo y consuélalo, porque yo lo convertiré en una gran nación”. ");
INSERT INTO spavbl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Entonces Dios abrió sus ojos y ella pudo ver un pozo que estaba cerca. Así que fue y llenó su odre de agua y le dio de beber al niño. ");
INSERT INTO spavbl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Dios bendijo a Ismael y él creció, viviendo en el desierto. Se convirtió en un arquero con una gran habilidad. ");
INSERT INTO spavbl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Vivió en el desierto de Parán. Su madre le eligió una esposa de la tierra de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","En aquél mismo tiempo, Abimelec y Ficol, jefe de su ejército, vinieron a ver a Abraham. Y Abimelec le dijo: “Dios te bendice en todo lo que haces”. ");
INSERT INTO spavbl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Y continuó: “Así que júrame aquí y hora que no me traicionarás, ni a mis hijos, ni a mis descendientes. Del mismo modo que te he demostrado mi lealtad, haz lo mismo conmigo y con mi nación, en la cual vives”. ");
INSERT INTO spavbl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","“Así lo juro”, respondió Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Entonces Abraham planteó ante Abimelec un problema relacionado con un pozo del que los siervos de Abimelec se habían apoderado a la fuerza. ");
INSERT INTO spavbl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","“No sé quién hizo esto, y no lo habías mencionado antes. Nunca había oído acerca de esto hasta hoy”, respondió Abimelec. ");
INSERT INTO spavbl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Entonces Abraham le dio a Abimelec algunas de sus ovejas y ganado, y los dos hicieron un pacto. ");
INSERT INTO spavbl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham también apartó siete corderas del rebaño. ");
INSERT INTO spavbl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","“¿Qué significan esas siete corderas que has apartado del rebaño?” le preguntó Abimelec. ");
INSERT INTO spavbl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","“Te doy estas siete corderas como compensación por tu reconocimiento de que yo cavé este pozo”, respondió Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Por eso llamaron ese lugar Beerseba, porque ahí los dos juraron e hicieron un pacto. ");
INSERT INTO spavbl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Después de haber hecho el pacto en Beerseba, Abimelec y Ficol – el comandante de su ejército –, se fueron y llegaron a la tierra de los filisteos. ");
INSERT INTO spavbl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham plantó un árbol de tamarisco en Beerseba y allí adoró al Señor, al Dios eterno. ");
INSERT INTO spavbl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Y Abraham vivió en el país de los filisteos por muchos años. ");
INSERT INTO spavbl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Algún tiempo después, Dios puso a prueba a Abraham. Y lo llamó: “¡Abraham!” “Aquí estoy”, respondió Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Entonces Dios le dijo: “Ve con tu hijo, el hijo al que amas, tu único hijo, a la tierra de Moriah y sacrifícalo como una ofrenda quemada sobre el altar en una de las montañas que yo te mostraré”. ");
INSERT INTO spavbl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","A la mañana siguiente, Abraham se levantó temprano y ensilló su asno. Tomó consigo a dos siervos y a Isaac, y se fue a cortar leña para quemar la ofrenda. Y se fue con ellos al lugar que Dios le había dicho. ");
INSERT INTO spavbl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Después de viajar por tres días, Abraham pudo finalmente ver el lugar a la distancia. ");
INSERT INTO spavbl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Y le dijo a sus siervos: “Esperen aquí con el asno mientras yo voy con mi hijo y adoro a Dios. Después regresaremos”. ");
INSERT INTO spavbl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Entonces Abraham hizo que Isaac cargara la leña para la ofrenda que debía quemar, mientras que él llevaba el fuego y el cuchillo, y caminaron juntos. ");
INSERT INTO spavbl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac le dijo a Abraham, “Padre…” “Dime, hijo…” respondió Abraham. “Puedo ver que tenemos el fuego y la madera, pero ¿dónde está el cordero para la ofrenda que vamos a quemar?” preguntó Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","“Dios proveerá el cordero para la ofrenda que vamos a quemar, hijo mío”, respondió Abraham, y siguieron caminando juntos. ");
INSERT INTO spavbl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Cuando llegaron al lugar que Dios les había mostrado, Abraham construyó un altar y puso sobre él la leña. Entonces amarró a su hijo Isaac y lo puso sobe el altar sobre la madera. ");
INSERT INTO spavbl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Y Abraham tomó el cuchillo, listo para sacrificar a su hijo. ");
INSERT INTO spavbl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Pero el ángel del Señor le gritó fuerte desde el cielo, diciendo “¡Abraham! ¡Abraham!” “Sí, aquí estoy”, respondió. ");
INSERT INTO spavbl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Entonces el ángel le dijo: “¡No toques al niño! No le hagas nada, porque ahora sé que realmente obedeces a Dios, pues no te negaste a darme a tu hijo, a tu único hijo”. ");
INSERT INTO spavbl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham entonces elevó su mirada y vio a un carnero que estaba enredado con sus cuernos en medio de los arbustos. Trajo al carnero y lo sacrificó como ofrenda en lugar de su hijo. ");
INSERT INTO spavbl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Y Abraham llamó a aquél lugar “El Señor proveerá”.Esa es una frase que la gente usa aun hoy: “El Señor proveerá en esta montaña”. ");
INSERT INTO spavbl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Entonces el ángel del Señor gritó otra vez a Abraham desde el cielo: ");
INSERT INTO spavbl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Te juro por mí mismo, dice el Señor, que por lo que has hecho y por no haberte negado a darme a tu hijo, a tu único hijo, ");
INSERT INTO spavbl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","puedes estar seguro de que te bendeciré y te daré muchos descendientes. Serán tan numerosos como las estrellas del cielo y la arena del mar, y conquistarán a sus enemigos. ");
INSERT INTO spavbl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Y todas las naciones de la tierra serán benditas por tus descendientes porque tú me obedeciste”. ");
INSERT INTO spavbl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Entonces Abraham regresó donde estaban sus siervos, y se fueron juntos a Beerseba, donde vivía Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Algún tiempo después, a Abraham le informaron: “Milca ha tenido hijos con tu hermano Nacor”. ");
INSERT INTO spavbl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz fue el primogénito, luego nació su hermano Buz, después Quemuel (quien vino a ser el ancestro de los arameos), ");
INSERT INTO spavbl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Quesed, Hazo, Pildas, Jidlaf, y Betuel. ");
INSERT INTO spavbl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Betuel fue el padre de Rebeca). Milca tuvo estos ocho hijos con Nacor, el hermano de Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Además, su concubina Reúma tuvo a Tebahj, a Gajam, a Tajas, y a Maaca. ");
INSERT INTO spavbl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara vivió hasta los 127 años, ");
INSERT INTO spavbl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","y entonces murió en Quiriat-Arba (o Hebrón) en la tierra de Canaán. Abraham fue adentro para lamentar su muerte y llorar por ella. ");
INSERT INTO spavbl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Entonces Abraham se levantó y fue a hablar con los líderes de los hititas. ");
INSERT INTO spavbl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Yo soy un extranjero, un extraño que vive entre ustedes”, les dijo. “Por favor, permítanme comprar un lugar de sepultura para que pueda sepultar a mi difunta esposa”. ");
INSERT INTO spavbl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Entonces los hititas le respondieron a Abraham, diciéndole: ");
INSERT INTO spavbl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Escucha, mi señor, tú eres un príncipe muy respetado entre nosotros. Elige el mejor lugar para sepultar a tu difunta. Ninguno de nosotros se opondrá”. ");
INSERT INTO spavbl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham se levantó y después se inclinó ante estos hititas, ");
INSERT INTO spavbl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","y les dijo: “Si les parece bien ayudarme a sepultar a mi difunta, escuchen mi propuesta. ¿Podrían, por favor, pedirle a Efrón, hijo de Zojar, ");
INSERT INTO spavbl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","que me venda la cueva de Macpela que está ubicada en el extremo del campo que es de su propiedad? Estoy dispuesto a pagarle el precio total aquí en presencia de ustedes, para así yo tener un lugar de sepultura”. ");
INSERT INTO spavbl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efrónel hitita estaba allí sentado en medio de su pueblo. Y le respondió a Abraham en presencia de los hititas que estaban en las puertas de la ciudad. ");
INSERT INTO spavbl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, mi señor”, le dijo. “Por favor, escúchame. Yo te regalaré el campo y la cueva que está allí. Te lo regalo y mi pueblo es testigo. Por favor, ve y sepulta a tu difunta”. ");
INSERT INTO spavbl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham se inclinó ante los habitantes locales, ");
INSERT INTO spavbl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","y para que todos lo escucharan, le dijo a Efrón: “Por favor, escúchame. Yo pagaré el precio del campo. Toma el dinero y déjame ir a sepultar a mi difunta allí”. ");
INSERT INTO spavbl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efrón le respondió a Abraham, diciéndole: ");
INSERT INTO spavbl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mi señor, escúchame, por favor. La tierra vale cuatrocientas piezas de plata. ¿Pero qué valor tiene eso para nosotros? Ve y sepulta a tu difunta”. ");
INSERT INTO spavbl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham aceptó la oferta de Efrón y Abraham calculó el peso y le dio a Efrón las cuatrocientas piezas de plata que había dicho, usando el peso estándar que usaban los mercaderes, y delante de los hititas como testigos. ");
INSERT INTO spavbl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","De esta manera, la propiedad se traspasó legalmente. Incluía el campo de Efrón en Macpela, cerca de Mamré, tanto el campo como la cueva estaban incluidos en el precio, así como los árboles plantados dentro del campo, y toda el área hasta los límites. ");
INSERT INTO spavbl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Todo esto vino a ser entonces propiedad de Abraham, y los hititas que se encontraban a las puertas de la ciudad fueron testigos de esta transacción. ");
INSERT INTO spavbl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Entonces Abraham fue y sepultó a su esposa Sara en la cueva que estaba en el campo de Macpela, cerca de Mamré (o Hebrón) en la tierra de Canaán. ");
INSERT INTO spavbl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","La propiedad del campo y de la cueva fue transferida de los hititas a Abraham para que fuera su lugar de sepultura. ");
INSERT INTO spavbl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham ya estaba muy avanzado en años, y el Señor lo había bendecido de todas las formas posibles. ");
INSERT INTO spavbl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Y Abraham le dijo a su siervo más viejo que estaba a cargo de toda su casa: “Pon tu mano bajo mi muslo, ");
INSERT INTO spavbl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","y júrame por el Señor, el Dios del cielo y de la tierra, que no dejarás que mi hijo se case con una de las hijas de los caananitas entre los cuales vivo. ");
INSERT INTO spavbl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","En lugar de ello, irás a mi tierra donde viven mis familiares, y encontrarás allí una esposa para mi hijo Isaac”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","“¿Y qué pasará si la mujer se niega a venir conmigo a este país?” preguntó el siervo. “¿Debería entonces traerme a tu hijo al país de donde vienes?” ");
INSERT INTO spavbl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“No, no debes llevarte a mi hijo para allá”, respondió Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“El Señor, el Dios del cielo, me tomó del seno de mi familia y de mi propio país. Habló conmigo y me juró, haciendo un voto con la promesa: ‘Yo le daré esta tierra a tus descendientes’. Él es quien enviará a su ángel delante de ti para que puedas encontrar a una esposa para mi hijo. ");
INSERT INTO spavbl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Sin embargo, si la mujer se rehúsa a venir aquí contigo, entonces quedarás libre de este juramento. Pero asegúrate de no llevarte a mi hijo para allá”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","El siervo puso su mano bajo el muslo de su señor Abraham y juró un voto de hacer conforme él se lo había dicho. ");
INSERT INTO spavbl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Entonces el siervo preparó diez camellos de su señor para llevar todo tipo de regalos de parte de Abraham y se fue hacia la ciudad de Nacor, en Harán-Najaraim. ");
INSERT INTO spavbl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Al llegar en la noche, hizo que los camellos se arrodillaran junto a un fuente que estaba a las afueras de la ciudad. Esta era la hora en que las mujeres salían a buscar agua. ");
INSERT INTO spavbl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Y el siervo oró: “Señor, Dios de mi señor Abraham, por favor, haz que este sea un día exitoso, y muestra tu fidelidad hacia mi señor Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ahora pues, me encuentro junto a esta fuente, y las mujeres jóvenes de la ciudad vendrán a buscar agua. ");
INSERT INTO spavbl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Haz que suceda de la siguiente manera: Que la joven a quien yo le diga ‘por favor, sostén tu cántaro para que yo pueda beber,’ y me responda ‘por favor bebe tú y tus camellos también,’ que sea ella la mujer que has elegido como esposa de tu siervo Isaac. De esta forma sabré que has mostrado fidelidad a mi señor”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Y aún no había terminado de orar cuando vio a Rebeca que venía a buscar agua, llevando el agua en un cántaro sobre su hombro. Ella era la hija de Betuel, hijo de Milcá. Milcá era la esposa de Nacor, el hermano de Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ella era una mujer muy hermosa, y era virgen porque nadie se había acostado con ella. Ella descendió hasta la fuente, llenó su cántaro, y regresó. ");
INSERT INTO spavbl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Entonces el siervo se apresuró para alcanzarla y le preguntó: “Por favor, déjame beber unos cuantos sorbos de agua de tu cántaro”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Por favor, bebe, mi señor”, respondió. Y rápidamente tomó su cántaro de sus hombres y lo sostuvo para que él pudiera beber. ");
INSERT INTO spavbl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Cuando terminó de ayudarle a beber, le dijo: “Permíteme darle de beber a tus camellos también, hasta que se sacien”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ella vació rápidamente su cántaro en el bebedero de los camellos, y corrió hasta la fuente para buscar más agua. Y trajo suficiente agua para sus camellos. ");
INSERT INTO spavbl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","El hombre la observaba en silencio para ver si el Señor había hecho de este un día exitoso. ");
INSERT INTO spavbl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Cuando los camellos terminaron de beber, él le dio un zarcillo de oro y puso dos brazaletes pesados en sus muñecas. ");
INSERT INTO spavbl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Entonces le preguntó: “¿Quién es tu padre? ¿Sabes si puedo encontrar posada en la casa de tu padre para pasar la noche?” ");
INSERT INTO spavbl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Y ella respondió: “Soy la hija de Betuel, el hijo de Milcá y Nacor”.Y continuó: “Tenemos suficiente lugar paja y comida para los camellos, ");
INSERT INTO spavbl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","y desde luego tenemos posada para ti esta noche”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","El hombre se arrodilló y se inclinó en actitud de adoración al Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Y oró: “Gracias Señor, Dios de mi señor Abraham”. “No has olvidado tu promesa y tu fidelidad con mi señor. ¡Y Señor, tú me has guiado directamente al hogar de los familiares de mi señor Abraham!” ");
INSERT INTO spavbl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ella corrió a la casa de su madre y le contó a su familia lo que había sucedido. ");
INSERT INTO spavbl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeca tenía un hermano llamado Labán, y él corrió al encuentro del hombre que se había quedado junto a la fuente. ");
INSERT INTO spavbl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labán había notado el zarcillo y los brazaletes que ella estaba usando, y había escuchado a su hermana Rebeca decir: “Esto es lo que me dijo aquél hombre”. Cuando llegó, todavía el hombre estaba de pie con sus camellos junto a la fuente. ");
INSERT INTO spavbl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Por favor, ven conmigo, bendito del Señor”, le dijo Labán. “¿Qué esperas aquí? Tengo la casa preparada para ti, y un lugar donde los camellos pueden estar”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Así que el hombre se fue con él a su casa. Labán descargó los camellos y les dio paja y comida. También trajo agua para que el hombre lavara sus pies, y también para los hombres que venían con él. ");
INSERT INTO spavbl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Entonces Labán mandó a traer alimentos. Pero el hombre le dijo: “No voy a comer hasta que les haya dicho por qué estoy aquí”. “Por favor, explícanos”, le respondió Labán. ");
INSERT INTO spavbl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“Soy el siervo de Abraham”, comenzó el hombre. ");
INSERT INTO spavbl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“El Señor a bendecido abundantemente a mi señor y ahora es un hombre rico y poderoso. El Señor le ha dado ovejas, rebaños, plata y oro, siervos y siervas, así como camellos y asnos. ");
INSERT INTO spavbl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Su esposa Sara tuvo un hijo de mi señor incluso siendo avanzada de edad, y mi señor le ha dado todo lo que posee. ");
INSERT INTO spavbl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mi señor Abraham me ha hecho jurarle un voto, diciendo: ‘No debes buscar esposa para mi hijo entre las hijas caananitas entre quienes vivo. ");
INSERT INTO spavbl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Sino ve a la tierra done vive mi familia, y busca allí una esposa para mi hijo Isaac’. ");
INSERT INTO spavbl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Y yo le dije a mi señor Abraham: ‘¿Qué pasa si esta mujer no desea venir aquí conmigo?’ ");
INSERT INTO spavbl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Y él me dijo: ‘El Señor, en cuya presencia he vivido mi vida, enviará a su ángel contigo, y hará que tu viaje sea exitoso. Encontrarás una esposa entre mi familia, de la familia de mi padre. ");
INSERT INTO spavbl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Serás liberado de tu juramento si al ir a mi familia, ellos se niegan a dejarla regresar contigo’. ");
INSERT INTO spavbl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Hoy cuando llegué a la fuente, oré al Señor: Dios de mi señor Abraham, por favor haz que sea un día exitoso. ");
INSERT INTO spavbl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ahora que me encuentro aquí junto a la fuente, haz que si una joven viene a buscar agua, y yo le pida diciendo ‘Por favor, dame de beber un poco de agua,’ ");
INSERT INTO spavbl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","y ella me diga: ‘Por favor, bebe y yo traeré agua para los camellos también’, que esa sea la que has elegido como esposa para tu siervo Isaac”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Yo aún no había terminado de orar en silencio cuando vi a Rebeca que iba a buscar agua, cargando su cántaro sobre su hombro. Descendió hasta la fuente para buscar agua, y le dije: ‘Por favor, dame de beber’. ");
INSERT INTO spavbl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Y ella de inmediato tomó el cántaro de su hombre y me dijo: ‘Por favor, bebe, y yo traeré para tus camellos también’. Así que bebí y ella trajo agua para los camellos. ");
INSERT INTO spavbl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Yo le pregunté: ‘¿Quién es tu padre?’ Y ella respondió: ‘Soy la hija de Betuel, el hijo de Milcá y Nacor’. Así que puse un zarcillo en su nariz, y los brazaletes en su muñeca. ");
INSERT INTO spavbl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","“Entonces me arrodilé y me incliné para adorar al Señor. Le agradecí al Señor, al Dios de mi señor Abraham, porque me condujo directamente hasta la sobrina de mi señor Abraham para su hijo. ");
INSERT INTO spavbl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Así que díganme ahora su ustedes mostrarán compromiso y fidelidad a mi señor Abraham? Dígan me si aceptarán o no para que yo pueda decidir qué hacer”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Entonces Labán y Betuel respondieron: “Sin duda todo esto viene del Señor, así que no podemos oponernos de ninguna manera. ");
INSERT INTO spavbl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeca está aquí, puedes tomarla y llevártela. Ella puede ser la esposa del hijo de tu señor Abraham, tal como lo ha decidido el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tan pronto como el siervo de Abraham escuchó esta decisión, se inclinó y adoró al Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Entonces desempacó las joyas de plata y oro, así como ropas finas, y se las dio a Rebeca. También le dio regalos de valor a su hermano y a su madre. ");
INSERT INTO spavbl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Entonces el siervo y sus hombres comieron y bebieron, y pasaron la noche allí. Cuando se levantaron por la mañana, dijo “Es mejor que me vaya ahora a cada de mi señor Abraham”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pero su hermano y su madre dijeron: “Déjala permanecer con nosotros diez días más, y después podrá irse”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","“Por favor no me hagan demorar”, les dijo él. “El Señor me ha dado éxito en este viaje, así que déjenme ir donde está mi señor”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“Llamemos a Rebeca y preguntémosle lo que ella desea hacer”, sugirieron ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Entonces llamaron a Rebeca y le preguntaron: “¿Quieres irte ahora mismo con este hombre?” “Sí, me iré”, respondió ella. ");
INSERT INTO spavbl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Entonces dejaron que Rebeca, la hermana de Labán se fuera con el siervo de Abraham, junto a la criada que la había cuidado desde pequeña. ");
INSERT INTO spavbl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Pidieron una bendición sobre ella diciendo: “Nuestra querida hermana, que seas la madre de miles de descendientes, y que tus hijos conquisten a sus enemigos”. ");
INSERT INTO spavbl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Entonces Receba y su sierva se subieron en sus camellos. Siguieron al siervo de Abraham, y se fueron. ");
INSERT INTO spavbl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Mientras tanto, Isaac, que vivía en el Neguev, acababa de regresar de Beer-lahai-roi. ");
INSERT INTO spavbl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Salió a los campos una tarde para pensar las cosas. Entonces miró a la distancia y vio venir los camellos. ");
INSERT INTO spavbl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca también miraba desde la distancia. Y cuando vio a Isaac, descendió del camello. ");
INSERT INTO spavbl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Y le preguntó al siervo: “¿Quién es ese que viene en camino a nuestro encuentro?” “Él es mi señor, Isaac”, respondió. Entonces ella se puso el velo para cubrirse. ");
INSERT INTO spavbl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Y el siervo le dijo a Isaac todo lo que había hecho. ");
INSERT INTO spavbl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Entonces Isaac tomó a Rebeca y la llevó a la tienda de su madre Sara y se casó con ella. La amó, y ella le dio consuelo por la muerte de su madre. ");
INSERT INTO spavbl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham se casó con otra mujer. Su nombre era Quetura. ");
INSERT INTO spavbl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Con ella tuvo los siguientes hijos: Zimrán, Jocsán, Medán, Madián, Isbac y Súaj. ");
INSERT INTO spavbl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsán fue el padre de Seba y Dedán. Los descendientes de Dedán fueron lo asureos, los letusitas y los leumitas. ");
INSERT INTO spavbl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Los hijos de Madián fueron Efa, Efer, Hanoc, Abida y Eldaa. Todos estos fueron los hijos de Quetura. ");
INSERT INTO spavbl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham le dejó todas sus posesiones a Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Pero mientras aún estaba con vida, le dio regalos a los hijos de sus concubinas y las envió al oriente, para que vivieran lejos de Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham vivió hasta la edad de 175 años ");
INSERT INTO spavbl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","cuando dio su último suspiro y murió en buena vejez, habiendo vivido suficientes años. Había vivido una vida plena y ahora se había unido a sus antepasados en la muerte. ");
INSERT INTO spavbl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Sus hijos Isaac e Ismael lo sepultaron en la cueva de Macpela, cerca de Mamré, en el campo que antes había pertenecido a Efrón, hijo de Zojar, el hitita. ");
INSERT INTO spavbl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Esre fue el terreno que Abraham le había comprador a los hititas. Y Abraham fue sepultado allí, junto a su esposa Sara. ");
INSERT INTO spavbl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Después de la muerte de Abraham, Dios bendijo a su hijo Isaac, quien vivía cerca de Beer-lahai-roi. ");
INSERT INTO spavbl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Esta es la genealogía de Ismael, hijo de Abraham: Su madre Agar fue la esclava egipcia de Sara. ");
INSERT INTO spavbl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Y estos fueron los nombres de los hijos de Ismael, según su familia genealógica: Nebayot, (primogénito), Quedar, Adbeel, Mibsam, ");
INSERT INTO spavbl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masá, ");
INSERT INTO spavbl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafis, y Quedema. ");
INSERT INTO spavbl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Estos fueron los hijos de Ismael, y también fueron los nombres de los lugares donde vivieron y acamparon: Las doce familias líderes de sus tribus. ");
INSERT INTO spavbl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael vivió hasta la edad de 137 años. Entonces dio un último suspiro, y se unió a sus antepasados en la muerte. ");
INSERT INTO spavbl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Los descendientes de Ismael habitaron la región de Havila hasta Sur, cerca de la frontera de Egipto, en dirección de Asur. Y siempre estaban peleando unos con otros. ");
INSERT INTO spavbl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","La siguiente es la genealogía Isaac, hijo de Abraham: Abraham fue el padre de Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Cuando Isaac cumplió los 40 años, se casó con Rebeca, la hija de Betuel el arameo de Padán-Harán y hermana de Labán el arameo. ");
INSERT INTO spavbl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac oró al Señor pidiendo su ayuda en favor de su esposa porque no podía tener hijos. El Señor respondió su oración y ella quedó embarazada. ");
INSERT INTO spavbl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Los dos hijos que tuvo eran gemelos y peleaban dentro de su vientre. Entonces ella le preguntó al Señor: “¿Por qué me pasa esto a mí?” ");
INSERT INTO spavbl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","“Tienes dentro de ti dos naciones”, respondió el Señor. “Darás a luz a dos hijos que competiránel uno contra el otro. Uno será más fuerte que el otro, y el mayor será siervo del menor”. ");
INSERT INTO spavbl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Cuando llegó el momento, Rebeca tuvo dos gemelos. ");
INSERT INTO spavbl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","El primero en salir estaba rojo al nacer, y estaba cubierto de mucho cabello, como si fuera un cabrito. Por eso lo llamaron Esaú. ");
INSERT INTO spavbl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Luego salió su hermano gemelo, quien salió de la matriz agarrando el talón de Esaú. Por eso lo llamaron Jacob. Isaac tenía 60 años cuando sus dos hijos nacieron. ");
INSERT INTO spavbl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Estos dos hijos de Isaac crecieron, y Esaú se convirtió en un cazador de gran talento en el campo. Jacob era tranquilo y se quedaba en casa, en las tiendas. ");
INSERT INTO spavbl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac amaba a Esaú porque le preparaba comida con los animales que cazaba, mientras que Rebeca amaba a Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Cierto día, Jacob estaba preparando un guisado cuando Esaú regresó del campo, cansado y muy hambriento. ");
INSERT INTO spavbl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","“Dame un poco de ese guisado rojo”, le dijo Esaú a Jacob. “¡Muero de hambre!” (Fue así como Esaú obtuvo su otro nombre: “Edom”, que significa “rojo”). ");
INSERT INTO spavbl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","“Primero véndeme tus derechos de primogénito”, le respondió Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“¡Mira! ¡Me estoy muriendo! ¿De qué me sirven esos derechos de primogénito?” dijo Esaú. ");
INSERT INTO spavbl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","“Primero tienes que jurármelo”, exigió Jacob. Así que Esaú hizo juramento vendiéndole a Jacob sus derechos de primogénito. ");
INSERT INTO spavbl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Entonces Jacob le dio a Esaú un poco de pan, y un guisado de lentejas. Esaú comió y bebió hasta que se sació y se fue. Al hacer esto, Esaú demostró cuán poco le importaban sus derechos como hijo primogénito. ");
INSERT INTO spavbl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Y hubo un gran hambruna en el país, no la misma que la que ocurrió en el tiempo de Abraham, sino más tarde. Así que Isaac se mudó a Gerar, en el territorio de Abimelec, rey de los filisteos. ");
INSERT INTO spavbl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","El Señor se le apareció a Isaac y le dijo: “No vayas a Egipto, sino al país que yo te mostraré. ");
INSERT INTO spavbl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Quédate aquí en este país. Yo estaré contigo y te bendeciré, porque voy a darte a ti y a tus descendientes todas estas tierras. Yo guardaré la promesa solemne que yo le juré a tu padre Abraham. ");
INSERT INTO spavbl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Yo haré que tu descendencia sea tan numerosa como las estrellas del cielo, y les daré todas estas tierras. Todas las naciones de la tierra serán benditas por tus descendientes, ");
INSERT INTO spavbl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","porque Abraham hizo lo que yo le dije, y siguió mis órdenes, mis mandamientos, mis preceptos y mis leyes”. ");
INSERT INTO spavbl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Así que Isaac se quedó en Gerar. ");
INSERT INTO spavbl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Cuando los hombres de esa tierra le preguntaron por su esposa, él respondió diciendo: “Ella es mi hermana”, porque tuvo miedo. Pues pensó para sí mismo: “Si digo que ella es mi esposa, me matarán para quedarse con Rebeca, pues es muy hermosa”. ");
INSERT INTO spavbl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Pero más tarde, después de haber vivido allí por un tiempo, Abimelec, rey de los filisteos, miró por la ventana y vio a Isaac acariciando a su esposa Rebeca. ");
INSERT INTO spavbl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelec entonces mandó a buscar a Isaac y le planteó su queja. “¿Según lo que vi, ella es claramente tu esposa!” le dijo. “¿Por qué decidiste decir ‘es mi hermana’?” “Porque pensé que me matarían por causa de ella”, respondió Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","“¿Por qué nos hiciste esto?” le preguntó Abimelec. “¡Uno de los hombres aquí pudo haberse acostado con tu esposa, y tú nos habrías hecho culpables a todos!” ");
INSERT INTO spavbl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelec emitió una orden a todo el pueblo, advirtiéndoles: “Cualquiera que toque a este hombre o a su esposa, será ejecutado”. ");
INSERT INTO spavbl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac volvió a sembrar ese año, y el Señor lo bendijo con una cosecha que fue cien veces más grande que lo que había sembrado. ");
INSERT INTO spavbl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Se volvió un hombre rico, y su riqueza creciócontinuamente hasta que se volvió muy rico. ");
INSERT INTO spavbl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Y poseía muchos rebaños de ovejas, manadas de bueyes, y muchos esclavos. Tanía tantas riquezas que los filisteos comenzaron a sentir celos de él. ");
INSERT INTO spavbl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Así que los filisteos usaron basura para tapar todos los pozos que su Padre Abraham había cavado. ");
INSERT INTO spavbl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Entonces Abimelec le dijo a Isaac: “Tienes que abandonar nuestro país, porque te has vuelto demasiado poderoso para nosotros”. ");
INSERT INTO spavbl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Así que Isaac se fue y estableció su campamentoen el valle de Gerar, donde se quedó a vivir. ");
INSERT INTO spavbl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Allí destapó los pozos que había cavado su padre Abraham en su tiempo, los que los filisteos habían tapado después de la muerte de Abraham. Y les puso los mismos nombres que su padre les había puesto. ");
INSERT INTO spavbl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Los siervos de Isaac también cavaron un pozo en el valle y encontraron una fuente de agua. ");
INSERT INTO spavbl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Pero los pastores de Gerar comenzaron a tener discordias con los pastores de Isaac, diciendo: “¡Esa agua es nuestra!” Así que Isaac llamó a aquel pozo “Discordia”, porque allí tuvieron discordia con él. ");
INSERT INTO spavbl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isaac tenía otro pozo cavado, y allí también hubo discordias. A ese pozo le llamó “Oposición”. ");
INSERT INTO spavbl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Así que se fueron de allí y cavaron otro pozo. Esta vez no hubo ninguna discordia respecto a este pozo, y lo llamó “Libertad”, diciendo: “Ahora el Señor nos ha dado libertad para crecer y ser exitosos en esta tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","De allí Isaac se fue hacia Beerseba. ");
INSERT INTO spavbl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Y esa noche el Señor se le apareció y le dijo: “Yo soy el Dios de tu padre Abraham. No tengas miedo, porque yo estoy contigo. Te bendeciré y te daré muchos descendientes por causa de mi siervo Abraham”. ");
INSERT INTO spavbl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaac entonces construyó un altar y adoró al Señor. También estableció sus tiendas, y sus siervos cavaron un pozo en ese lugar. ");
INSERT INTO spavbl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Algún tiempo después, Abimelec vino desde Gerar con su consejero Ahuzat y con Ficol, jefe de su ejército, para ver a Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","“¿Por qué han venido a verme?” les preguntó Isaac. “¡Antes me odiaban y me pidieron que me fuera!” ");
INSERT INTO spavbl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","“Ahora nos hemos dado cuenta de que el Señor está contigo”, le respondieron. “Así que hemos decidido hacer un pacto contigo con juramento. ");
INSERT INTO spavbl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Tu nos prometerás que no nos harás daño, así como nosotros nunca te hemos hecho daño. Reconocerás que siempre te hemos tratado bien, y cuando te pedimos que te marcharas lo hicimos con bondad. ¡Y mira cómo el Señor te bendice ahora!” ");
INSERT INTO spavbl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Así que Isaac mandó a preparar una comida especial para celebrar este pacto. Comieron y bebieron, ");
INSERT INTO spavbl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","y se levantaron temprano en la mañana y cada uno hizo juramento al otro. Entonces Isaac los dejó ir, y ellos se fueron en paz. ");
INSERT INTO spavbl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ese fue el día en que los siervos de Isaac que habían estado cavando un pozo vinieron a decirle: “¡Hemos hallado agua!” ");
INSERT INTO spavbl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Así que Isaac llamó a ese pozo “juramento”, y por eso hasta el día de hoy, el nombre de esa ciudad es “Pozo del juramento” (Beerseba). ");
INSERT INTO spavbl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Cuando Esaú cumplió 40 años, se casó con Judit, hija de Beri, el hitita, y también con Basemat, hija de Elón, el hitita. ");
INSERT INTO spavbl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Y ellas le causaron muchas amarguras a Isaac y Rebeca. ");
INSERT INTO spavbl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac estaba viejo y se estaba quedando ciego. Así que llamó a su hijo mayor Esaú, diciendo: “Hijo mío”. Y Esaú contestó: “Aquí estoy”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","“Ya estoy viejo”, dijo Isaac, “Es posible que muera pronto. ");
INSERT INTO spavbl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Así que toma tu arco y tus flechas, ve a cazar y tráeme algo de carne. ");
INSERT INTO spavbl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Prepárame una comida de buen sabor para que yo coma, y para bendecirte antes de morir”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeca escuchó lo que Isaac le dijo a Esaú. Así que cuando Esaú se fue al campo a buscar carne de caza, ");
INSERT INTO spavbl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca le dijo a su hijo Jacob: “¡Escucha! Acabo de oír a tu padre decirle a tu hermano, ");
INSERT INTO spavbl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Tráeme carne de caza y prepárame una buena comida de buen sabor para comer y bendecirte en presencia del Señor antes de morir’. ");
INSERT INTO spavbl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ahora, hijo, escúchame y haz exactamente lo que yo te diré. ");
INSERT INTO spavbl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ve al rebaño y tráeme dos cabras jóvenes. Yo las cocinaré y prepararé la comida de buen sabor que a tu padre más le gusta. ");
INSERT INTO spavbl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Entonces se la llevarás a tu padre para comer, para que te bendiga en la presencia del Señor antes de morir”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","“Pero escucha”, le respondió Jacob a su madre Rebeca, “mi hermano Esaú es un hombre velludo, y yo soy lampiño. ");
INSERT INTO spavbl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","De pronto mi padre se dará cuenta cuando me toque. Entonces parecerá como que lo estoy engañando y en lugar de bendición, recibiré una maldición”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","“Que la maldición caiga sobre mí, hijo mío”, respondió su madre. “Solo haz lo que te digo. Ve y tráeme las cabras jóvenes”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Así que Jacob fue a buscarlas y las trajo para su madre, y ella preparó una comida de buen sabor, tal como le gustaba a su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Entonces Rebeca fue y tomó la mejor ropa de su hijo mayor Esaú que ella tenía en su casa, y se la puso a Jacob, su hijo menor. ");
INSERT INTO spavbl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Y puso la piel de los corderos en sus manos, y en su cuello. ");
INSERT INTO spavbl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Entonces le entregó a su hijo Jacob la comida y el pan que había preparado. ");
INSERT INTO spavbl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob entró a ver a su padre, y lo llamó diciendo: “Padre mío, aquí estoy”. “¿Cuál de mis hijos eres?” preguntó Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","“Soy Esaú, tu hijo mayor”, le dijo Jacob a su padre. “Hice lo que me pediste. Por favor, siéntate y come la carne de caza que hice para ti, para que puedas bendecirme”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","“¿Cómo pudiste encontrar tan rápido a un animal, hijo mío?” le preguntó Isaac. “Es porque el Señor lo envió para mí”, respondió Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","“Ven aquí para que pueda tocarte, hijo mío”, le dijo Isaac a Jacob, “así sabré si eres en verdad Esaú”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Así que Jacob se acercó a su padre Isaac, quien al tocarlo dijo: “Es la voz de Jacob, pero son las manos de Esaú”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaac no se dio cuenta de que era Jacob porque tenía las manos con vellos como Esaú, así que se preparó para bendecirlo. ");
INSERT INTO spavbl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“En realidad eres tú mi hijo Esaú?” preguntó de nuevo. “Si, soy yo”, respondió Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Entonces dijo: “Hijo mío, tráeme de la comida de caza que me has preparado para comer, y así podré darte mi bendición”.Así que Jacob trajo para su padre Isaac comida para comer y vino para beber. ");
INSERT INTO spavbl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Después Isaac le dijo a Jacob: “Ven y bésame, hijo mío”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Entonces Jacob se inclinó y lo besó, e Isaac pudo oler la ropa que Jacob estaba usando. Así que procedió a darle su bendición, pensado para sí: “El olor de mi hijo es como el olor de un campo que el Señor ha bendecido”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","“¡Que Dios use el rocío del cielo y la tierra fértil para darte ricas cosechas de grano y vino nuevo! ");
INSERT INTO spavbl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Que los pueblos de distintas naciones te sirvan y se inclinen ante ti. Que todos los que te maldigan sean malditos, y que sean benditos todos los que te bendigan”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Después de que Isaac terminó de bendecir a Jacob—de hecho, Jacob ya se había ido de la presencia de su padre—Esaú regresó de su viaje de caza. ");
INSERT INTO spavbl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","También había preparado una comida de buen sabor, y se la trajo a su padre. Entonces Esaúle dijo a Isaac, “Siéntate padre, y come de mi carne de caza para que puedas bendecirme”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“¿Quién eres?” le preguntó Isaac. “Soy tu hijo Esaú, tu primogénito”, respondió. ");
INSERT INTO spavbl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac entonces comenzó a temblar y preguntó: “¿Quién fue el que se fue de cacería y me trajo la comida? Ya la comí toda antes de que llegaras y lo bendije. No puedo retirar su bendición ya”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Cuando Esaú escuchó las palabras de su padre, gritó de rabia y amargura, y le rogó a su padre: “Por favor, bendíceme a mí también, padre!” ");
INSERT INTO spavbl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Pero Isaac respondió: “Tu hermano vino y me engañó. ¡Él se ha robado tu bendición!” ");
INSERT INTO spavbl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","“¡Con toda razón su nombre es Jacob, el impostor!” dijo Esaú. “Me ha engañado dos veces. ¡Primero se apropió de mi primogenitura y ahora se ha robado mi bendición! ¿No has guardado una bendición para mi?” ");
INSERT INTO spavbl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Entonces Isaac le contestó a Esaú: “Lo he hecho tu señor, y he dicho que todos sus parientes serán sus siervos. He declarado que no le faltará el grano ni el nuevo vino. ¿Qué puedo dejar para ti, hijo mío?” ");
INSERT INTO spavbl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","“¿Acaso solo tienes una bendición, padre mío?” preguntó Esaú. “¡Por favor bendíceme a mi también!” Entonces Esaú comenzó a llorar a gritos. ");
INSERT INTO spavbl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Entonces su padre Isaac declaró: “¡Escucha, hijo! Vivirás lejos de la tierra fértil, lejos del rocío que cae del cielo. ");
INSERT INTO spavbl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Te ganarás el sustento con espada, y serás el siervo de tu hermano. Pero cuando te rebeles, quitarás su yugo de tu cuello”. ");
INSERT INTO spavbl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Desde entonces Esaú sintió odio hacia Jacob, por causa de la bendición de su padre. Esaú se dijo a sí mismo: “Pronto llegará el tiempo en que lamentaré la muerte de mi padre. ¡Y entonces mataré a mi hermano Jacob!” ");
INSERT INTO spavbl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Sin embargo, Rebeca escuchó lo que había dicho Esaú, y mandó a llamar a Jacob. “Mira”, le dijo, “tu hermano Esaú siente consuelo en hacer planes de matarte. ");
INSERT INTO spavbl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Así que, escúchame atentamente, hijo mío, lo que te voy a decir. Vete inmediatamente a donde mi hermano Labán en Arám. ");
INSERT INTO spavbl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Quédate con él hasta que la rabia de tu hermano se calme. ");
INSERT INTO spavbl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Cuando esté en calma y se le olvide, yo te mandaré a buscar de nuevo. Porque no quisiera perderlos a los dos en un solo día” ");
INSERT INTO spavbl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Entonces Rebeca fue y le dijo a Isaac: “Estoy cansada de estas mujeres hititas . ¡Están arruinando mi vida! ¡Prefiero morir antes de que Jacob llegue a casarse con una mujer hitita como ellas, una de esas habitantes locales!” ");
INSERT INTO spavbl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac llamó a Jacob y lo bendijo. “No te cases con una mujer cananea”, le ordenó. ");
INSERT INTO spavbl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","“Vete ahora mismo a Padán Harán, a la casa de Betuel, el padre de tu madre. Busca allí una esposa, una hija de Labán, el hermano de tu madre. ");
INSERT INTO spavbl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","El Dios Altísimo te bendiga y que tus descendientes sean tan numerosos que llegues a ser el ancestro de muchas naciones. ");
INSERT INTO spavbl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Que Dios te concede a ti y a tus descendientes la misma bendición que le dio a Abraham, para que poseas la tierra en la que eres extranjero, la tierra que Dios le dio a Abraham”. ");
INSERT INTO spavbl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Así que Isaac envió a Jacob, y Jacob se fue de viaje a Paddan-aram, a la casa de Labán, hijo de Betuel, el arameo. Labán era el hermano de Rebeca, la madre de Jacob y Esaú. ");
INSERT INTO spavbl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú descubrió que Isaac había bendecido a Jacob y que lo había enviado a Paddan-aram para encontrar allí una esposa, y que cuando lo bendijo, le dijo: “No te cases con una mujer cananea”. ");
INSERT INTO spavbl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","También se enteró de que Jacob había obedecido a su padre y ahora se dirigía hacia Paddan-aram. ");
INSERT INTO spavbl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esto hizo que Esaú descubriera cuánto su padre aborrecía a las mujeres cananeas. ");
INSERT INTO spavbl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Así que Esaú fue a donde la familia de Ismael, y se casó con otra mujer llamada Majalat, la hija de Ismael, hijo de Abraham, y hermana de Nebaiot. ");
INSERT INTO spavbl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Mientras tanto, Jacob había salido de Beerseba e iba de camino hacia Arán. ");
INSERT INTO spavbl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Llegó allí después de la puesta de sol, y se quedó esa noche en un lugar. Tomó una piedra, la puso bajo su cabeza, y se acostó a dormir. ");
INSERT INTO spavbl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Y Jacob tuvo un sueño en el que veía una escalera que comenzaba en la tierra, y llegaba hasta el cielo. Vio a los ángeles de Dios que subían y bajaban en ella. ");
INSERT INTO spavbl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Entonces vio al Señor que estaba en pie sobre él, y que dijo: “Yo soy el Señor, el Dios de tu padre Abraham, y el Dios de Isaac. Yo te doy a ti y a tus descendientes la tierra en la que estás acostado ahora. ");
INSERT INTO spavbl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tus descendientes serán tantos como el polvo de la tierra, y se esparcirán de oriente a occidente, y de norte a sur. Todos sobre la tierra serán benditos por tus descendientes. ");
INSERT INTO spavbl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","¡Escucha! Yo estoy contigo y te cuidaré dondequiera que vayas. Yo te traeré de regreso a esta tierra. No te abandonaré, porque voy a hacer lo que te prometí”. ");
INSERT INTO spavbl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Cuando Jacob se despertó, se dijo a sí mismo: “¡El Señor está aquí, en este lugar, y no me había dado cuenta!” ");
INSERT INTO spavbl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Entonces se asustó y dijo: “¡Este es un lugar terrible! Debe ser la casa de Dios y la entrada al cielo”. ");
INSERT INTO spavbl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Cuando Jacob se levantó en la mañana, tomó la Piedra que había puesto bajo su cabeza, y la colocó en forma vertical, como un pilar de piedra, y roció aceite de oliva sobre ella. ");
INSERT INTO spavbl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Y le puso por nombre a ese lugar “Betel”, (anteriormente su nombre era Luz). ");
INSERT INTO spavbl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob también hizo una promesa solemne, diciendo: “Dios, si vas conmigo y me cuidas durante mi viaje, y me das alimento y bebida, así como ropa para vestir ");
INSERT INTO spavbl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","para que pueda regresar a salvo a la casa de mi padre, entonces tú, Señor, serás mi Dios. ");
INSERT INTO spavbl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Y este pilar que he levantado aquí, será la casa de Dios, y yo te daré la décima parte de lo que me des”. ");
INSERT INTO spavbl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob se apresuró y se puso en marcha, y llegó a la tierra de los orientales. ");
INSERT INTO spavbl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Al contemplar a su alrededor, vio un pozo en un campo y a tres rebaños de ovejas acostadas junto a él, esperando recibir agua. Una gran piedra cubría la boca del pozo. ");
INSERT INTO spavbl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","La práctica común era que cuando todos los rebaños llegaban, los pastores rodaban la piedra de la boca del pozo y le daban agua a las ovejas, y luego colocaban la piedra en su lugar nuevamente. ");
INSERT INTO spavbl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Y Jacob les preguntó: “Hermanos míos, ¿de dónde son ustedes?” “Somos de Harán”, respondieron. ");
INSERT INTO spavbl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“¿Conocen a Labán, el nieto de Nacor?” les preguntó. “Si, lo conocemos”, respondieron. ");
INSERT INTO spavbl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“¿Cómo está él?” preguntó. “Está bien”, respondieron. “¡Mira! De hecho, la que viene allí con las ovejas es su hija Raquel”. ");
INSERT INTO spavbl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","“Todavía es temprano”, dijo Jacob. “Es muy pronto para guardar las ovejas. ¿Por qué no les dan agua de beber y las dejan pastar un poco más?” ");
INSERT INTO spavbl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“No podemos hasta que hayan llegado todos los rebaños”, le dijeron los pastores. “Entonces rodamos la piedra del pozo y las dejamos beber agua”. ");
INSERT INTO spavbl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mientras aún hablaban, llegó Raquel con el rebaño que pastoreaba para su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Cuando Jacob vio a Raquel, la hija de Labán, que era el hermano de su madre, subió y rodó la piedra del pozo para que las ovejas de Labán pudieran beber agua. ");
INSERT INTO spavbl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Entonces Jacob besó a Raquel y lloró de alegría. ");
INSERT INTO spavbl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","(Le había dicho ya que él era el hijo del hermano de Labán y de Rebeca). Y ella corrió y le contó a su padre lo que había sucedido. ");
INSERT INTO spavbl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tan pronto como Labán escuchó la noticia acerca de Jacob, salió corriendo a su encuentro. Lo abrazó y lo besó, y se lo llevó a casa. Después de que Jacob le explicó todo a Labán, ");
INSERT INTO spavbl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labán le dijo: “¡No hay duda alguna, eres carne de mi carne y sangre de mi sangre!” Y Jacob se quedó con Labán durante un mes. ");
INSERT INTO spavbl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Un día, Labán le dijo: “¡Eres mi pariente, así que no es justo que trabajes sin una compensación por ello! Dime entonces, ¿cuánto debo pagarte?” ");
INSERT INTO spavbl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labán tenía dos hijas. La mayor se llamaba Lea, y la más joven se llamaba Raquel. ");
INSERT INTO spavbl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea tenía ojos que expresaban amabilidad, pero Raquel tenía un cuerpo armonioso y una apariencia hermosa. ");
INSERT INTO spavbl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob se enamoró de Raquel, así que le prometió a Labán: “Trabajaré siete años para ti por Raquel, tu hija menor”. ");
INSERT INTO spavbl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","“Pues para mi es mejor dártela a ti que a cualquier otro”, respondió Labán. “Así que quédate y trabaja para mi”. ");
INSERT INTO spavbl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Y Jacob trabajó para Labán por siete años, pero para él fueron como días, porque realmente la amaba. ");
INSERT INTO spavbl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Entonces Jacob le dijo a Labán: “Ha llegado el tiempo que acordamos. Ahora dame a tu hija para que sea mi esposa”. ");
INSERT INTO spavbl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Y Labán organizó un banquete de bodas y invitó a todos para que vinieran al banquete. ");
INSERT INTO spavbl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pero al caer la noche, Labán trajo donde Jacob a su hija Lea, y Jacob se acostó con ella. ");
INSERT INTO spavbl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Labán se había encargado de que su sierva Zilpá fuera la criada personal de Lea). ");
INSERT INTO spavbl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","¡Al amanecer, Jacob se dio cuenta de que era Lea! Así que fue donde Labán y con enojo le preguntó: “¿Qué me has hecho? ¡Trabajé para ti por Raquel! ¿Por qué me has engañado?” ");
INSERT INTO spavbl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","“Aquí no entregamos a la hija menor en matrimonio antes que a la hija mayor”, respondió Labán. ");
INSERT INTO spavbl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","“Deja que la semana de celebración por la boda termine, y entonces te daré a mi otra hija también, pero con la condición de que trabajes siete años más para mi”. ");
INSERT INTO spavbl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob estuvo de acuerdo. Terminó la semana de celebración por la boda con Lea, y entonces Labán le dio a su hija Raquel como esposa también. ");
INSERT INTO spavbl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Labán también se encargó de que su sierva Bila fuera la criada personal de Raquel). ");
INSERT INTO spavbl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Así que Jacob se acostó con Raquel, y amó a Raquel más que a Lea. Y trabajó para Labán siete años más por Raquel. ");
INSERT INTO spavbl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Y el Señor vio que Lea no era amada, y la ayudó a tener hijos. Pero no hizo lo mismo con Raquel. ");
INSERT INTO spavbl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Así que Lea quedó embarazada, y tuvo un hijo a quien llamó Rubén, pues dijo: “¡El Señor vio lo mucho que he sufrido y ahora mi esposo me amará!” ");
INSERT INTO spavbl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Entonces Lea volvió a quedar embarazada, y tuvo un hijo. Y dijo: “El Señor ha esuchado que no soy amada, y me ha dado otro hijo”. Así que le puso por nombre Simeón. ");
INSERT INTO spavbl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea volvió a quedar embarazada por tercera vez, y tuvo otro hijo. Y dijo: “Finalmente mi esposo se sentirá unido a mi, porque ahora le he dado tres hijos”. Por eso le puso por nombre Leví. ");
INSERT INTO spavbl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Una vez más, Lea quedó embarazada y tuvo otro hijo. Lo llamó Judá, pues dijo: “¡Ahora realmente puedo alabar al Señor!” Y no tuvo más hijos después de esto. ");
INSERT INTO spavbl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Cuando Raquel se dio cuenta de que no podía tener hijos con Jacob, sintió celos de su hermana. Entonces Raquel puso su queja con Jacob: “¡Moriré si no me das hijos!” ");
INSERT INTO spavbl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob se enojó con Raquel y le dijo: “¿Acaso soy Dios? ¿Crees que soy el que impide que puedas tener hijos?” ");
INSERT INTO spavbl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","“Aquí está mi criada personal, Bila” respondió Raquel. “Acuéstate con ella para que ella tenga hijos por mi, y así yo también tenga una familia”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Y Raquel le dio a Jacob a su criada personal Bila como esposa, y Jacob se acostó con ella. ");
INSERT INTO spavbl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Entonces Bila quedó embarazada y tuvo un hijo de Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Y Raquel dijo: “¡Dios ha juzgado a mi favor! Me escuchó y me ha dado un hijo”. Y a este hijo lo llamó Dan. ");
INSERT INTO spavbl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bila, la criada personal de Raquel volvió a quedar embarazada y tuvo un segundo hijo de Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Y Raquel dijo: “He tenido una contienda con mi hermana, pero ahora he ganado”. Y a este hijo lo llamó Neftalí. ");
INSERT INTO spavbl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea se dio cuenta de que no estaba teniendo más hijos, así que le dio a Jacob a su criada personal Zilpá como esposa para Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Y Zilpá tuvo un hijo de Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Entonces Lea dijo: “¡Cuán afortunada soy!” Y a este hijo lo llamó Gad. ");
INSERT INTO spavbl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Entonces Zilpá, la criada personal de Lea volvió a quedar embarazada y tuvo otro hijo de Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Entonces Lea dijo: “Soy muy feliz, y las otras mujeres también lo dirán!” Y a este hijo lo llamó Aser. ");
INSERT INTO spavbl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Durante el tiempo de la cosecha de trigo, Rubén encontró algunas plantas de mandrágoras mientras andaba por los campos de cultivos. Y los llevó a su madre Lea. Entonces Raquel le dijo a Lea: “Por favor, dame algunas de las mandrágoras que tu hijo encontró”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","“¿Acaso no te basta con haberme robado a mi esposo?” respondió Lea. “¿Vas a tomar también las mandrágoras de mi hijo?” “Bueno, podrás acostarte con él esta noche si me das algunas mandrágoras a cambio”, respondió Raquel. ");
INSERT INTO spavbl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Cuando Jacob regresó de los campos esa noche, Lea fue a su encuentro. “Debes acostarte conmigo esta noche porque he pagado por ti con las mandrágoras de mi hijo”, ella le dijo. Así que Jacob durmió con ella aquella noche. ");
INSERT INTO spavbl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dios escuchó la petición de Lea, y quedó embarazada y tuvo un quinto hijo con Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Entonces Lea dijo: “El Señor me ha premiado por haberle dado a mi esposo mi criada personal”. Y a este hijo lo llamó Isacar. ");
INSERT INTO spavbl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Entonces Lea volvió a quedar embarazada y tuvo un sexto hijo con Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Y Lea dijo: “Dios me ha dado un buen regalo. Ahora mi esposo me honrará porque le he dado seis hijos”.Y a este hijo lo llamó Zabulón. ");
INSERT INTO spavbl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Tiempo después, Lea tuvo una hija a la cual llamó Dina. ");
INSERT INTO spavbl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Entonces Dios prestó atención a Raquel, y escuchó sus plegarias, y la ayudó a tener hijos. ");
INSERT INTO spavbl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Entonces Raquel quedó embarazada y tuvo un hijo. Y dijo: “Dios ha quitado mi desgracia”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Y a este hijo lo llamó José, diciendo: “Que el Señor me de un hijo más”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Cuando José nació, Jacob le dijo a Labán: “Déjame ir para volver a casa y a mi propio país. ");
INSERT INTO spavbl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dame a mis esposas y a mis hijos porque he trabajado por tenerlos. Déjame ir ahora porque conoces todo el trabajo que he hecho para ti”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","“Por favor, quédate”, respondió Labán, “porque he descubierto que el Señor me ha bendecido por tu causa”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Entonces Labán continuó: “Dime cuánto debo pagarte”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","“Tú sabes bien cuánto trabajo he hecho para ti, y el buen cuidado que he provisto a tus rebaños. ");
INSERT INTO spavbl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","¡Cuando yo llegué no tenías mucho, pero ahora tienes muchas cosas! El Señor te ha bendecido por lo que yo he hecho. ¿Cuándo podré proveer para mi propia familia?” ");
INSERT INTO spavbl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“¿Qué me propones como pago hacia ti?” preguntó Labán nuevamente. “No tienes que darme nada”, respondió Jacob. “Si quieres hacer algo por mí, qué te parece esto: Seguiré cuidando y alimentando tus rebaños. ");
INSERT INTO spavbl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Permíteme visitar tus rebaños hoy, y yo tomaré todas las ovejas que tienen pecas o manchas, y todas las de lana oscura, y de igual manera con los cabritos. Eso será mi pago. ");
INSERT INTO spavbl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","En el futuro, podrás probar que he sido honesto. Cuando miren mis rebaños, cualquier cabrito y oveja que no tenga manchas, o que no sea de lana oscura, podrá considerarse que fue robada de tus rebaños”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Muy bien”, aceptó Labán. “Lo haremos como has dicho”. ");
INSERT INTO spavbl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Sin embargo, ese mismo día, Labán salió y apartó a todos los cabritos machos con manchas y con rayas, así como todas las cabras con manchas y de pelaje oscuro. Pidió a sus hijos que los cuidaran y los ma ndó lejos ");
INSERT INTO spavbl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","para que estuvieran a tres días de camino separados de Jacob, mientras que Jacob cuidaba del resto de los rebaños de Labán. ");
INSERT INTO spavbl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Entonces Jacob cortó unas varas de álamo, de almendro, y de plátano cuya madera era blanca bajo la corteza. Peló la corteza, e hizo varas que lucían con rayas blancas. ");
INSERT INTO spavbl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Y puso las varas que había pelado en los bebederos de los rebaños, pues ahí era donde se apareaban. ");
INSERT INTO spavbl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Los rebaños se apareaban frente a las varas y producían crías con rayas, con pintas y con manchas. ");
INSERT INTO spavbl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Entonces Jacob separó a todos estos. Entonces hizo que su rebaño se pusiera de frente al rebaño de Labán que tenía rayas y era de pelaje oscuro. Así fue como pudo mantener a su rebaño separado del rebaño de Labán. ");
INSERT INTO spavbl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Cuando las hembras estaban a punto de dar a luz, Jacob ponía las varas en los bebederos donde los rebaños pudieran verlas mientras se apareaban. ");
INSERT INTO spavbl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pero Jacob no hizo esto con las hembras más débiles. Las más débiles se fueron del lado de Labán, y las más fuertes se fueron del lado de Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Así Jacob se volvió muy rico, con un gran rebaño, y con muchos esclavos y esclavas, así como camellos y asnos. ");
INSERT INTO spavbl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob descubrió que los hijos Labán decían: “Jacob se ha quedado con todo lo que le pertenecía a nuestro padre. Toda su riqueza la obtuvo de nuestro padre”. ");
INSERT INTO spavbl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob también se dio cuenta de que Labán lo había comenzado a tratar de manera diferente. ");
INSERT INTO spavbl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Entonces el Señor le dijo a Jacob: “Regresa al país de tus antepasados, al hogar de tus padres. Y yo estaré contigo”. ");
INSERT INTO spavbl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob mandó a buscar a Raquel y a Lea, pidiéndoles que vinieran a su encuentroen los campos donde estaba apacentando los rebaños. ");
INSERT INTO spavbl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“He notado que su padre me está tratando diferente a la manera como me trataba antes”, les dijo. “Pero el Dios de mi padre estará conmigo. ");
INSERT INTO spavbl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ustedes saben cuán duro he trabajado para su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","¡Pero me ha estado engañando, y ha reducido mi salario diez veces! Sin embargo, Dios no ha dejado que me haga mal. ");
INSERT INTO spavbl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Cuando dijo: ‘Te pagaré con cabras pintadas,’ entonces en todo el rebaño solo había cabritas jóvenes pintadas. Cuando dijo: ‘Te pagaré con cabras con rayas,’ entonces en todo el rebaño solo había cabras jóvenes con rayas. ");
INSERT INTO spavbl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Por eso Dios tomó todo el rebaño de su padre y me lo dio a mi. ");
INSERT INTO spavbl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Cuando el rebaño se estaba apareando, tuve un sueño en el que vi a las cabras macho apareándose con el rebaño donde todas las cabras eran de rayas, con pintas o manchas. ");
INSERT INTO spavbl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Entonces en el sueño, el ángel del Señor me habló y me dijo: ‘Jacob!’ y yo respondí: ‘Aquí estoy’. ");
INSERT INTO spavbl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“Y me dijo: ‘Mira y te darás cuenta de que las cabras macho que se aparean con el resto del rebaño, tienen rayas, o tienen pintas o manchas, porque he visto lo que Labán te hizo. ");
INSERT INTO spavbl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yo soy el Dios de Betel, donde echaste el aceite de oliva sobre el pilar de piedra y me hiciste una promesa solemne. Ahora prepárate para salir de esta tierra, y devuélvete a la tierra de tus padres’”. ");
INSERT INTO spavbl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","“No tenemos heredad de nuestro padre de todas formas”, respondieron Raquel y Lea. ");
INSERT INTO spavbl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","“Él nos trata como extranjeras porque nos vendió a ti, y ahora ha gastado todo ese dinero. ");
INSERT INTO spavbl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Toda la riqueza que Dios le ha arrebatado ahora nos pertenece a nosotras y a nuestros hijos, ¡así que haz lo que Dios te ha dicho!” ");
INSERT INTO spavbl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Así que Jacob se alistó. Ayudó a sus hijos ya sus esposas a subir a los camellos, ");
INSERT INTO spavbl_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","y condujo a su rebaño frente a él. Llevó consigo todas las posesiones que había ganado mientras vivió en Padan-Harán, y partió de allí para volver a la tierra de su padre en Canaán. ");
INSERT INTO spavbl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mientras Labán estaba lejos de casa esquilando sus ovejas, Raquel robó los ídolos de la casa que le pertenecían a su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob también engañó a Labán el arameo al no decirle que se escaparía. ");
INSERT INTO spavbl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Así que Jacob se apresuró para irse con todo lo que tenía, cruzó el río Éufrates, y se encaminó hacia la región montañosa de Galaad. ");
INSERT INTO spavbl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tres días después, Labán descubrió que Jacob había huido. ");
INSERT INTO spavbl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tomando consigo a algunos de sus familiares, salió a perseguir a Jacob y se encontró con él siete días más tarde en el país montañoso de Galaad. ");
INSERT INTO spavbl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Pero por la noche Dios visitó a Labán en un sueño y le dijo: “Ten cuidado con lo que le dices a Jacob. No trates de persuadirlo para que regrese, ni lo amenaces”. ");
INSERT INTO spavbl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob había establecido su campamento con tiendas en Galaad cuando Labán se encontró con él. Así que Labán y sus familiares hicieron lo mismo. ");
INSERT INTO spavbl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","“¿Por qué me engañaste de esta manera?” le preguntó Labán a Jacob. “¡Tomaste a mis hijas como si fueran prisioneras llevadas al cautiverio con espadas! ");
INSERT INTO spavbl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Por qué te fuiste huyendo en secreto, tratando de ponerme una trampa? ¿Por qué no viniste a decírmelo? Si lo hubieras hecho, te habría preparado una Buena despedida, con música con panderetas y liras. ");
INSERT INTO spavbl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","¡Ni siquiera me dejaste despedirme de mis nietos y nietas! ¡Has actuado de forma muy insensata! ");
INSERT INTO spavbl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Podría castigarte, pero el Dios de tu padre me habló anoche y me dijo: ‘Cuidado con lo que le dices a Jacob. No intentes persuadirlo para que vuelva, ni tampoco lo amenaces’. ");
INSERT INTO spavbl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Es evidente que querías irte y volver a la casa de tu familia, pero ¿por qué tenías que robar mis ídolos?” ");
INSERT INTO spavbl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","“Huí porque tenía miedo”, le explicó Jacob a Labán. “Tenía miedo de que me quitaras a tus hijas a la fuerza. ");
INSERT INTO spavbl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","En cuanto a tus ídolos, cualquiera que los tenga morirá. Puedes buscar delante de nuestra familia, y si encuentras cualquier cosa que te pertenezca, puedes tomarla”. (Jacob no sabía que Raquel había robado los ídolos de la casa). ");
INSERT INTO spavbl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Entonces Labán comenzó a buscar en las tiendas de Jacob, Lea y las dos criadas personales, pero no encontró nada, y entonces entró a la tienda de Raquel. ");
INSERT INTO spavbl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raquel había puesto los ídolos de la casa en una alforja de camello y estaba sentada en ella. Labán buscó cuidadosamente en toda la tienda pero no los encontró. ");
INSERT INTO spavbl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Entonces le dijo a su padre: “Señor, por favor, no se enfade conmigo por no estar en pie en su presencia, pero tengo mi período menstrual”.Labán buscó en todas partes, pero no encontró los ídolos. ");
INSERT INTO spavbl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob se enojó con Labán y lo confrontó, diciendo: “¿De qué crimen soy culpable? ¿Qué mal te he hecho para que vengas a buscarme? ");
INSERT INTO spavbl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Has buscado entre todas mis posesiones. ¿Has encontrado algo que te pertenezca? ¡Si es así, tráelo aquí delante de nuestras familias y que sean ellos los que decidan quién tiene razón! ");
INSERT INTO spavbl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“He trabajado para ti durante estos últimos veinte años, y durante ese tiempo ninguna de tus ovejas y cabras ha abortado, ni yo he comido ni un solo carnero de tu rebaño. ");
INSERT INTO spavbl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Si alguno de ellos fue asesinado por los animales salvajes, ni siquiera te traje el cadáver para demostrarte la pérdida, sino que yo mismo la soporté. Pero tú, por el contrario, siempre me has hecho compensar por los animales robados, ya fuera de noche o a plena luz del día. ");
INSERT INTO spavbl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","“Ya fuera sudando en el calor del día o congelándome en el frío de la noche cuando no podía dormir, seguí trabajando para tu casa durante veinte años. ");
INSERT INTO spavbl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Trabajé catorce años por tus dos hijas, y seis años más con tus rebaños. ¡Y me redujiste el sueldo diez veces! ");
INSERT INTO spavbl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si no fuera por el Dios de mi padre, el Dios de Abraham, el increíble Dios de Isaac, quien me cuidó, me habrías despedido sin nada. Pero Dios vio mi sufrimiento, lo duro que trabajé y te condenó anoche”. ");
INSERT INTO spavbl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labán respondió: “¡Estas son mis hijas, estos son mis hijos, y estos son mis rebaños! De hecho, ¡Todo lo que ven aquí es mío! Sin embargo, ¿qué puedo hacer ahora con mis hijas y sus hijos? ");
INSERT INTO spavbl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Así que hagamos un acuerdo solemne entre tu y yo, y será testimonio de nuestro compromiso mutuo”. ");
INSERT INTO spavbl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Entonces Jacob tomó una piedra y la puso en pie como un pilar. ");
INSERT INTO spavbl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Luego le dijo a sus parientes: “Vayan y recojan algunas piedras”. Y todos construyeron un pilar de piedras y se sentaron junto a él para comer. ");
INSERT INTO spavbl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labán lo llamó Yegar-Saduta, pero Jacob lo llamó Galaad. ");
INSERT INTO spavbl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Entonces Labán anunció: “Este montón de piedras sirve de testigo entre nosotros dos”. Por eso se le llamó Galeed. ");
INSERT INTO spavbl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","También se le llamó Mizpa, porque como dijo Labán: “Que el Señor nos vigile de cerca a los dos cuando no estemos juntos. ");
INSERT INTO spavbl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Si tratas mal a mis hijas, o te casas con otras esposas además de ellas, ¡Dios verá lo que haces aunque nadie más se entere!” ");
INSERT INTO spavbl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Entonces Labán le dijo a Jacob: “Mira este altar de piedras que he construido en memoria del acuerdo entre los dos. ");
INSERT INTO spavbl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","También son testimonio de nuestras solemnes promesas mutuas: No las pasaré por alto para atacarte, nitú las pasarás por alto para atacarme. ");
INSERT INTO spavbl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Que el Dios de Abraham y el Dios de Nacor, el Dios de nuestros antepasados, sea el que juzgue entre nosotros cualquier disputa”. Jacob, a su vez, hizo la solemne promesa en nombre de maravilloso Dios de su padre Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Luego ofreció un sacrificio en la montaña e invitó a todos sus parientes a comer allí. Pasaron la noche en la montaña. ");
INSERT INTO spavbl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Labán se levantó temprano por la mañana y dio un beso de despedida a sus nietos e hijas. Los bendijo y luego se fue para volver a casa. ");
INSERT INTO spavbl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob siguió su camino y unos ángeles de Dios vinieron a su encuentro. ");
INSERT INTO spavbl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Cuando los vio dijo: “¡Este debe ser el campamento de Dios!” Y llamó al lugar “Dos campamentos”. ");
INSERT INTO spavbl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Entonces envió mensajeros a su hermano Esaú, que vivía en la región de Seír, en el país de Edom. ");
INSERT INTO spavbl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Y les dijo: “Esto es lo que deben decirle a mi señor Esaú: Tu siervo Jacob te envía este mensaje. He estado con Labán hasta ahora, ");
INSERT INTO spavbl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","y tengo ganado, asnos, ovejas y cabras, así como esclavos y esclavas. He enviado a estos mensajeros para explicarte esto, mi señor, esperando que te alegresde verme”. ");
INSERT INTO spavbl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Los mensajeros volvieron a Jacob y le dijeron: “¡Su hermano Esaú viene a recibirle con 400 hombres armados!” ");
INSERT INTO spavbl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Cuando Jacob escuchó esto, estaba absolutamente aterrorizado. Dividió a toda la gente con él, junto con las ovejas, las cabras, el ganado y los camellos, en dos grupos, ");
INSERT INTO spavbl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","diciéndose a sí mismo: “Si Esaú viene y destruye un grupo, el otro puede escapar”. ");
INSERT INTO spavbl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Entonces Jacob oró: “¡Dios de mi abuelo Abraham, Dios de mi padre Isaac! Señor, tú fuiste quien me dijo: ‘Vuelve a tu país y a la casa de tu familia, y te trataré bien’ ");
INSERT INTO spavbl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","No merezco todo el amor y la fidelidad que has mostrado a tu siervo. Crucé el Jordán hace años con sólo mi bastón, y ahora tengo dos grandes campamentos. ");
INSERT INTO spavbl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Por favor, sálvame de mi hermano; ¡defiéndeme de Esaú! Me aterra que venga a atacarme a mí, a mis mujeres y a mis hijos. ");
INSERT INTO spavbl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tú mismo me dijiste: ‘Sin duda alguna te trataré bien. Haré que tus descendientes sean tan numerosos como la arena de la playa, demasiados para contarlos’”. ");
INSERT INTO spavbl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob pasó la noche allí. Luego escogió animales como regalo para su hermano Esaú: ");
INSERT INTO spavbl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 cabras hembras, 20 cabras machos; 200 ovejas, 20 carneros; ");
INSERT INTO spavbl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 camellos hembras con sus crías, 40 vacas, 10 toros; 20 burros hembras, 10 burros machos. ");
INSERT INTO spavbl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Puso a sus sirvientes a cargo de cada uno de los rebaños y les dijo: “Adelántense y mantengan una buena distancia entre los rebaños”. ");
INSERT INTO spavbl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A los que tenían el primer rebaño les dio estas instrucciones: “Cuando mi hermano Esaú se encuentre con ustedes y les pregunte: ‘¿Quién es su amo, a dónde van, y de quién son estos animales que vienen con ustedes’ ");
INSERT INTO spavbl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","deberán decirle: ‘Tu siervo Jacob envía estos como regalo a mi señor Esaú, y viene detrás de nosotros’”. ");
INSERT INTO spavbl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","A los que tenían el segundo, el tercero, y todos los rebaños subsiguientes lesdio las mismas instrucciones, diciéndoles: “Esto es lo que deben decirle a Esaú cuando se encuentre con ustedes. ");
INSERT INTO spavbl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Y también deben decirle: ‘Tu siervo Jacob viene justo detrás de nosotros’”. ");
INSERT INTO spavbl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Así que los regalos iban adelante mientras Jacob pasaba la noche en el campamento. ");
INSERT INTO spavbl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Se levantó durante la noche y tomó a sus dos esposas y a las dos criadas personales y a sus once hijos, y cruzó el río Jaboc. ");
INSERT INTO spavbl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Después de ayudarles a cruzar, también les envió todo lo que les pertenecía. ");
INSERT INTO spavbl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Pero Jacob se quedó allí solo. Un hombre vino y luchó con él hasta el amanecer. ");
INSERT INTO spavbl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Cuando el hombre se dio cuenta de que no podía vencer a Jacob, golpeó la cavidad de la cadera de Jacob y la desarticuló mientras luchaba con él. ");
INSERT INTO spavbl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Entonces el hombre dijo: “Déjame ir porque ya casi ha amanecido”. “No te dejaré ir a menos que me bendigas”, respondió Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“¿Cómo te llamas?” le preguntó el hombre. “Jacob”, respondió él. ");
INSERT INTO spavbl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","“Tu nombre no será más Jacob”, dijo el hombre. “En su lugar te llamarás Israel, porque luchaste con Dios y con los hombres, y ganaste”. ");
INSERT INTO spavbl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","“Por favor, dime tu nombre”, preguntó Jacob. “¿Por qué me preguntas mi nombre?” respondió el hombre. Entonces bendijo a Jacob allí. ");
INSERT INTO spavbl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob nombró el lugar Peniel, diciendo: “¡Vi a Dios cara a cara y todavía estoy vivo!” ");
INSERT INTO spavbl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Y cuando Jacob se fue de Peniel, ya salía el sol, e iba cojeando por su cadera fracturada. ");
INSERT INTO spavbl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","(Por eso, aún hoy, los israelitas no se comen el tendón del muslo que está unido a la cuenca de la cadera, porque ahí es donde el hombre golpeó la cuenca de la cadera de Jacob). ");
INSERT INTO spavbl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob vio a Esaú a lo lejos, viniendo hacia él con cuatrocientos hombres. Así que dividió a los niños entre Lea, Raquel y las dos sirvientas personales. ");
INSERT INTO spavbl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Colocó a las dos sirvientas personales con sus hijos primero, luego a Lea y sus hijos, y al final a Raquel y José. ");
INSERT INTO spavbl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Luego Jacob se adelantó a ellas y se inclinó hasta el suelo siete veces antes de acercarse a su hermano. ");
INSERT INTO spavbl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaú corrió hacia él y lo abrazó. Puso sus brazos alrededor de su cuello y lo besó. Los dos lloraron. ");
INSERT INTO spavbl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Entonces Esaú miró a su alrededor, a las mujeres y los niños. “¿Quiénes son estas personas que están contigo?” preguntó. “Son los hijos que Dios le dio a tu siervo”, respondió Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Las sirvientas personales y sus hijos se acercaron y se inclinaron. ");
INSERT INTO spavbl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Entonces Lea y sus hijos se acercaron y se inclinaron. Por último, José y Raquel se acercaron y se inclinaron. ");
INSERT INTO spavbl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","“¿Para qué eran todos los animales que encontré en el camino?” Preguntó Esaú. “Son un regalo para ti, mi señor, para que me trates bien”, respondió Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","“¡Tengo más que suficiente, hermano mío! Guarda lo que tienes”, dijo Esaú. ");
INSERT INTO spavbl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","“¡No, por favor!” Jacob insistió. “Si eres feliz conmigo, entonces por favor acepta el regalo que te estoy dando. Ahora que he vuelto a ver tu rostro es como ver el rostro de Dios, ¡y me has acogido tan amablemente! ");
INSERT INTO spavbl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Por favor, acepta el regalo que te he traído porque Dios me ha tratado muy bien y tengo mucho”. Así que Esaú lo aceptó. ");
INSERT INTO spavbl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“Sigamos nuestro camino”, dijo Esaú. “Yo iré delante de ti”. ");
INSERT INTO spavbl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","“Mi señor puede ver que los niños son débiles”, respondió Jacob. “También las cabras, las ovejas y el ganado están amamantando a sus crías, y si los presiono demasiado, todos morirán. ");
INSERT INTO spavbl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Sigue adelante, mi señor, y tu siervo vendrá lentamente, caminando con los niños, y me reuniré contigo en Seir”. ");
INSERT INTO spavbl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","“Bien, pero déjame dejar algunos de mis hombres contigo”, dijo Esaú. “Eres muy amable, pero no hay necesidad de hacer eso”, respondió Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Así que Esaú comenzó su camino de regreso a Seír ese día. ");
INSERT INTO spavbl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Pero Jacob se dirigió a Sucot, donde se construyó una casa y refugios para el ganado. Por eso el lugar se llama Sucot. ");
INSERT INTO spavbl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Más tarde Jacob continuó su viaje desde Paddan-aram. Llegó a salvo a Siquem en el país de Canaán donde acampó en las afueras del pueblo. ");
INSERT INTO spavbl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Compró el terreno donde acampaba a los hijos de Hamor, el fundador de Siquem, por 100 monedas. ");
INSERT INTO spavbl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Construyó un altar allí y lo llamó El-Elohe-Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, la hija de Jacob y Lea, fue a visitar a algunas de las mujeres locales. ");
INSERT INTO spavbl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Siquem, hijo de Hamor el heveo, el gobernante de esa zona, la vio. La agarró y la violó. ");
INSERT INTO spavbl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sin embargo, luego se enamoró profundamente de Dina y trató de que ella también lo amara. ");
INSERT INTO spavbl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Fue y le pidió a su padre, “Trae a esta joven para que me case con ella”. ");
INSERT INTO spavbl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob descubrió que Siquem había violado a su hija Dina, pero como sus hijos estaban lejos cuidando los rebaños en los campos no dijo nada hasta que volvieron a casa. ");
INSERT INTO spavbl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Mientras tanto, Hamor, el padre de Siquem, llegó para hablar con Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Cuando los hijos de Jacob regresaron de los campos se molestaron mucho al oír la noticia y se enojaron mucho porque Siquem había hecho algo indignante en Israel al tener relaciones sexuales con la hija de Jacob, algo que nunca debería hacerse. ");
INSERT INTO spavbl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor les dijo: “Mi hijo Siquem está muy enamorado de su hija y de su hermana Dina. Por favor, permítale que se case con ella. ");
INSERT INTO spavbl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","De hecho, podemos tener más matrimonios. Pueden darnos a sus hijas y pueden tener a nuestras hijas. ");
INSERT INTO spavbl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Puedes vivir entre nosotros y establecerte donde quieras. Podéis ir donde queráis y comprar tierras para vosotros mismos”. ");
INSERT INTO spavbl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Entonces el propio Shechem habló y le dijo al padre y a los hermanos de Dina: “Por favor, acéptenme a mi y a mi propuesta, y haré lo que me pidan. ");
INSERT INTO spavbl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Puedes poner el precio de la novia tan alto como quieras, y yo lo pagaré junto con todos los regalos que daré. Sólo déjame tener a la chica para poder casarme con ella”. ");
INSERT INTO spavbl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Los hijos de Jacob no fueron honestos cuando le contestaron a él y a su padre Hamor porque Siquem había violado a su hermana Dina. ");
INSERT INTO spavbl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Les dijeron: “¡No podemos hacer esto! No podemos permitir que nuestra hermana se case con un hombre que no está circuncidado. Eso nos traería la desgracia. ");
INSERT INTO spavbl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sólo lo aceptaremos con esta condición: todos ustedes deben ser circuncidados como nosotros. ");
INSERT INTO spavbl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Entonces os daremos nuestras hijas y tomaremos vuestras hijas, y viviremos entre vosotros y nos convertiremos en una familia. ");
INSERT INTO spavbl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pero si no estáis de acuerdo con nosotros en que debéis circuncidaros, entonces tomaremos a nuestra hermana y nos iremos”. ");
INSERT INTO spavbl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor y su hijo Siquem estuvieron de acuerdo con lo que se propuso. ");
INSERT INTO spavbl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","El joven Siquem no perdió tiempo en arreglar esto porque estaba encaprichado con la hija de Jacob, y se le consideraba la persona más importante de la familia de su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor y Siquem fueron a la puerta del pueblo y hablaron con los otros líderes allí. ");
INSERT INTO spavbl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Estos hombres son nuestros amigos”, les dijeron. “Hagamos que vivan aquí en nuestro país y permitámosles ir a donde quieran, es lo suficientemente grande para todos ellos también. Podemos tomar a sus hijas como esposas, y podemos darles nuestras hijas para que se casen. ");
INSERT INTO spavbl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Pero sólo aceptarán esto con una condición: sólo se unirán a nosotros y se convertirán en una familia si cada hombre de entre nosotros es circuncidado como ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Si eso ocurre, ¿no acabarán perteneciéndonos todo su ganado y sus propiedades, todos sus animales? Sólo tenemos que estar de acuerdo con esto y ellos vendrán a vivir entre nosotros”. ");
INSERT INTO spavbl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Todos los que estaban en la puerta del pueblo estaban de acuerdo con Hamor y Siquem, así que todos los hombres del pueblo fueron circuncidados. ");
INSERT INTO spavbl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tres días después, mientras aún sufrían dolor, Simeón y Levi, dos de los hijos de Jacob y los hermanos de Dina, llegaron con sus espadas a la ciudad. Sin oponerse, mataron a todos los hombres. ");
INSERT INTO spavbl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Mataron a Hamor y a Siquem con sus espadas, tomaron a Dina de la casa de Siquem y se fueron. ");
INSERT INTO spavbl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Los otros hijos de Jacob llegaron, robaron los cadáveres y saquearon la ciudad donde su hermana había sido violada. ");
INSERT INTO spavbl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Se llevaron sus ovejas, cabras, ganado y burros. Tomaron todo lo que había en el pueblo y en los campos, ");
INSERT INTO spavbl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","es decir, todas sus posesiones. Capturaron a todas sus mujeres y niños, y saquearon todo lo que había en sus casas. ");
INSERT INTO spavbl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Pero Jacob criticó a Simeón y a Leví, diciéndoles: “¡Ustedes me han causado muchos problemas! Han hecho que sea como un mal olor entre los habitantes de este país, entre los cananeos y los ferezeos. Sólo tengo unos pocos hombres, y si esta gente se reúne para atacarme, yo y toda mi familia seremos aniquilados”. ");
INSERT INTO spavbl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pero ellos respondieron: “¿Deberíamos haber dejado que tratara a nuestra hermana como una prostituta?” ");
INSERT INTO spavbl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Entonces Dios le dijo a Jacob: “Prepárate para ir a Betel y vivir allí. Construye allí un altar a Dios, que se te apareció cuando estabas huyendo de tu hermano Esaú”. ");
INSERT INTO spavbl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Entonces Jacob le dijo a su familia y a todos los que estaban con él: “Deshazte de los ídolos paganos que tienes contigo. Purifíquense y cambien su ropa. ");
INSERT INTO spavbl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Debemos prepararnos e ir a Betel para construir un altar a Dios que me respondió en mi tiempo de angustia. Él ha estado conmigo donde quiera que haya ido”. ");
INSERT INTO spavbl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Entregaron a Jacob todos los ídolos paganos que tenían, así como sus pendientes, y los enterró bajo el roble de Siquem. ");
INSERT INTO spavbl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Al partir en su viaje, el terror de Dios se extendió por todos los pueblos de alrededor, así que nadie intentó tomar represalias contra los hijos de Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob y todos los que lo acompañaban llegaron a Luz (también conocida como Bethel) en el país de Canaán. ");
INSERT INTO spavbl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Construyó un altar allí y llamó al lugar El-Bethel, porque allí se le había aparecido Dios cuando huía de su hermano Esaú. ");
INSERT INTO spavbl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deborah, la enfermera de Rebeca, murió y fue enterrada bajo el roble cerca de Bethel. Así que se le llamó “el roble del llanto”. ");
INSERT INTO spavbl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Dios se le apareció de nuevo a Jacob y lo bendijo después de su regreso de Paddan-aram. ");
INSERT INTO spavbl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Dios le dijo: “Jacob no será más tu nombre. En lugar de Jacob tu nombre será Israel”. Así que Dios le llamó Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Entonces Dios dijo: “¡Yo soy el Dios Todopoderoso! Reproduce, aumenta, y te convertirás en una nación - de hecho un grupo de naciones - y los reyes estarán entre tus descendientes. ");
INSERT INTO spavbl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Te daré a ti y a tus descendientes la tierra que también di a Abraham e Isaac”. ");
INSERT INTO spavbl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Entonces Dios dejó el lugar donde había estado hablando con Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Después Jacob puso un pilar de piedra en el lugar donde Dios había hablado con él. Derramó una ofrenda de bebida sobre ella, y también aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob llamó al lugar Betel, porque allí había hablado con Dios. ");
INSERT INTO spavbl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Luego se fueron de Betel. Cuando aún estaban a cierta distancia de Efrat, Raquel se puso de parto y tuvo grandes dificultades para dar a luz. ");
INSERT INTO spavbl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Cuando tuvo los peores dolores de parto, la comadrona le dijo: “No te rindas, tienes otro hijo” ");
INSERT INTO spavbl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Pero ella se estaba muriendo, y con su último aliento le puso el nombre de Benoni. Pero su padre le puso el nombre de Benjamín. ");
INSERT INTO spavbl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raquel murió y fue enterrada camino de Efrat (también conocida como Belén). ");
INSERT INTO spavbl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob colocó una piedra conmemorativa sobre la tumba de Raquel, y sigue ahí hasta hoy. ");
INSERT INTO spavbl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel siguió adelante y acampó más allá de la torre de vigilancia en Eder. ");
INSERT INTO spavbl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Durante el tiempo que vivió allí, Rubén fue y se acostó con Bilhá, la concubina de su padre, e Israel se enteró de ello. Estos fueron los doce hijos de Jacob: ");
INSERT INTO spavbl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Los hijos de Lea: Rubén (el primogénito de Jacob), Simeón, Leví, Judá, Isacar, y Zabulón. ");
INSERT INTO spavbl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Los hijos de Raquel: Joséy Benjamín. ");
INSERT INTO spavbl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Los hijos de Bila, la criada personal de Raquel: Dan y Neftalí. ");
INSERT INTO spavbl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Los hijos de Zilpá, la criada personal de Lea: Gad y Aser. Estos fueron los hijos de Jacob, que nacieron cuando vivía en Padán-Arán. ");
INSERT INTO spavbl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob regresó a casa de su padre Isaac en Mamre, cerca de Quiriat-arba (también conocida como Hebrón), donde habían vivido Abraham e Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac vivió hasta la edad de 180 años, ");
INSERT INTO spavbl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","cuando respiró por última vez y murió a una edad avanzada. Había vivido una vida plena y ahora se unió a sus antepasados en la muerte. Sus hijos Esaú y Jacob lo enterraron. ");
INSERT INTO spavbl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","La siguiente es la genealogía de Esaú (también llamado Edom). ");
INSERT INTO spavbl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú se casó con dos mujeres cananeas: Ada, hija de Elón el hitita, y Aholibama, hija de Aná, y nieta de Zibeón el heveo. ");
INSERT INTO spavbl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Además se casó también con Basemat, hija de Ismael, y hermana de Nebayot. ");
INSERT INTO spavbl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah tuvo un hijo para Esaú llamado Elifaz. Basemath tuvo a Reuel. ");
INSERT INTO spavbl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aholibama tuvo a Jeús, Jalán y Coré. Estos fueron los hijos de Esaú, que le nacieron en Canaán. ");
INSERT INTO spavbl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaú tomó a sus esposas, hijos e hijas, y a todos los de su casa, junto con su ganado, todos sus otros animales y todas las posesiones que había ganado mientras estaba en Canaán, y se fue a vivir a un país lejano de su hermano Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Lo hizo porque la tierra en la que vivían no podía mantenerlos a ambos con todo su ganado. ");
INSERT INTO spavbl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esaú se estableció en la región montañosa de Seír. ");
INSERT INTO spavbl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","La siguiente es la genealogía de Esaú, padre de los edomitas, que vivía en las colinas de Seír: ");
INSERT INTO spavbl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Estos eran los nombres de los hijos de Esaú: Elifaz, hijo de la esposa de Esaú, Ada, y Reuel, hijo de la esposa de Esaú, Basemath. ");
INSERT INTO spavbl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Los hijos de Elifaz eran: Teman, Omar, Zefo, Gatam y Cenaz. ");
INSERT INTO spavbl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, la concubina del hijo de Esaú, Elifaz, tenía a Amalec como hijo de Elifaz. Estos eran los descendientes de la esposa de Esaú, Ada. ");
INSERT INTO spavbl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Estos fueron los hijos de Reuel: Najat, Zera, Sama y Mizá. Eran los descendientes de Basemat, la esposa de Esaú. ");
INSERT INTO spavbl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Estos fueron los hijos de la esposa de Esaú, Aholibama, hija de Aná y nieta de Zibeón, a quien tuvo con Esaú: Jeús, Jalam y Coré. ");
INSERT INTO spavbl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Estos fueron los jefes de las tribus de los hijos de Esaú. Los jefes de las tribus de los hijos de Elifaz (el primogénito de Esaú) eran Temán, Omar, Zefo, Quenaz, ");
INSERT INTO spavbl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatán y Amalec. Fueron los jefes de las tribus de Elifaz en el país de Edom, y eran los descendientes de Ada. ");
INSERT INTO spavbl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Estos fueron los hijos del hijo de Esaú, Reuel: los líderes de las tribus Najat, Zera, Sama y Mizá. Fueron los jefes de las tribus descendientes de Reuel en el país de Edom, y eran los descendientes de la esposa de Esaú, Basemath. ");
INSERT INTO spavbl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Estos fueron los hijos de la esposa de Esaú Aholibama: los jefes de las tribus Jeús, Jalán y Coré; fueron los jefes de las tribus descendientes de la esposa de Esaú Aholibama, hija de Aná. ");
INSERT INTO spavbl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Todos ellos eran hijos de Esaú (también llamado Edom), y fueronlos jefes de sus tribus. ");
INSERT INTO spavbl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Estos fueron los hijos de Seír el horeo, que vivían en el país: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO spavbl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer y Disán; eran los jefes de la tribu de los horeos, los descendientes de Seír en la tierra de Edom. ");
INSERT INTO spavbl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Los hijos de Lotán fueron Hori y Hemam. Timna era la hermana de Lotan. ");
INSERT INTO spavbl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Estos fueron los hijos de Sobal: Alvánn, Manajat, Ebal, Sefó y Onam. ");
INSERT INTO spavbl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Estos fueron los hijos de Zibeón: Ayá y Aná. (Este fue el mismo Aná que descubrió las fuentes termales en el desierto mientras cuidaba los asnos de su padre Zibeón). ");
INSERT INTO spavbl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Estos fueron los hijos de Aná: Disón y Aholibamah, hija de Aná. ");
INSERT INTO spavbl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Estos fueron los hijos de Disón: Hemdán, Esbán, Itrán y Querán. ");
INSERT INTO spavbl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Estos fueron los hijos de Ezer: Bilán, Zaván y Acán. ");
INSERT INTO spavbl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Estos fueron los hijos de Disán: Uz y Arán. ");
INSERT INTO spavbl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Estos fueron los jefes de las tribus de los horeos: Lotán, Sobal, Zibeón, Anaá ");
INSERT INTO spavbl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer y Disán. Eran los jefes de las tribus de los horeos, listados según sus tribus en el país de Seír. ");
INSERT INTO spavbl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Estos fueron los reyes que gobernaban en la tierra de Edom antes de que hubiera un rey que gobernara sobre los israelitas: ");
INSERT INTO spavbl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, hijo de Beor, gobernaba en Edom y el nombre de su ciudad era Dinaba. ");
INSERT INTO spavbl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Cuando murió Bela, Jobab, hijo de Zera de Bosra, asumió el cargo de rey. ");
INSERT INTO spavbl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Cuando murió Jobab, Jusán, de la tierra de los temanitas, asumió el cargo de rey. ");
INSERT INTO spavbl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Cuando murió Husam, Hadad, hijo de Bedad, asumió el cargo de rey. Fue él quien derrotó a los madianitas en el país de Moab, y el nombre de su ciudad era Avit. ");
INSERT INTO spavbl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Cuando murió Hadad, Samla de Masreca se hizo cargo de la corona. ");
INSERT INTO spavbl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Cuando Samla murió, Saúl de Rejobot en el Éufrates se hizo cargo como rey. ");
INSERT INTO spavbl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Cuando Saúl murió, Baal Janán, hijo de Acbor, se hizo cargo como rey. ");
INSERT INTO spavbl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Cuando Baal Janán, hijo de Acbor, murió, Hadad se hizo cargo como rey. El nombre de su pueblo era Pau, y el nombre de su esposa era Mehitabel. Yera hija de Matred, hija de Mezab. ");
INSERT INTO spavbl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Estos fueron los nombres de los jefes de las tribus descendientes de Esaú, según sus familias y el lugar donde vivían, enumerados por nombre: los jefes de las tribus Timná, Alvá, Jetet, ");
INSERT INTO spavbl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibamah, Elá, Pinón, ");
INSERT INTO spavbl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Quenaz, Temán, Mibzar, ");
INSERT INTO spavbl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel e Iram. Estos fueron los jefes de las tribus de Edom, listados según los lugares donde vivían en el país. Esaú fue el antepasado de los edomitas. ");
INSERT INTO spavbl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob se estableció y vivió en Canaán como lo había hecho su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Esta es la historia de Jacob y su familia: José tenía diecisiete años y ayudaba a cuidar el rebaño junto con sus hermanos, los hijos de Bila y Zilpá, las esposas de su padre. José le contó a su padre algunas de las cosas malas que sus hermanos estaban haciendo. ");
INSERT INTO spavbl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel amaba a José más que a cualquiera de sus otros hijos, porque José le había nacido cuando ya era viejo. E hizo una túnica de colores y de mangas largas para José. ");
INSERT INTO spavbl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Cuando sus hermanos se dieron cuenta de que su padre lo amaba más que a cualquiera de ellos, lo odiaron y no tenían nada bueno que decir de él. ");
INSERT INTO spavbl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","José tuvo un sueño, y cuando se lo contó a sus hermanos, lo odiaron aún más. ");
INSERT INTO spavbl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","“Escuchen este sueño que tuve”, les dijo. ");
INSERT INTO spavbl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Estábamos atando fardos de grano en los campos cuando de repente mi fardo se levantó, y sus fardos se acercaron y se inclinaron ante el mío”. ");
INSERT INTO spavbl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","“¿De verdad crees que vas a ser nuestro rey?” le preguntaron ellos. “¿De verdad crees que vas a gobernar sobre nosotros?” Y lo odiaron aún más por su sueño y por cómo lo describía. ");
INSERT INTO spavbl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Luego José tuvo otro sueño y se lo contó a sus hermanos. “Escuchen, tuve otro sueño”, explicó. “El sol y la luna y once estrellas se inclinaban ante mí”. ");
INSERT INTO spavbl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","También se lo contó a su padre y a sus hermanos, y su padre se lo recriminó, diciendo: “¿Qué es este sueño que has tenido? ¿Vamos a venir nosotros, tu madre y tus hermanos a inclinarnos hasta el suelo ante ti?” ");
INSERT INTO spavbl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Los hermanos de José se pusieron celosos de él, pero su padre no entendía el significado del sueño. ");
INSERT INTO spavbl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Un día los hermanos de José llevaban los rebaños de su padre a pastar cerca de Siquem. ");
INSERT INTO spavbl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel le dijo a José: “Tus hermanos cuidan las ovejas cerca de Siquem. Prepárate porque quiero que vayas a verlos”. “Así lo haré”, respondió José. ");
INSERT INTO spavbl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Así que Jacob le dijo: “Ve a ver cómo están tus hermanos y los rebaños, y vuelve y házmelo saber”. Así que lo despidió, y José partió del Valle de Hebrón, ");
INSERT INTO spavbl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","y llegó a Siquem. Un hombre lo encontró vagando por el campo, y le preguntó: “¿Qué buscas?” ");
INSERT INTO spavbl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Estoy buscando a mis hermanos”, respondió José. “¿Puedes decirme por favor dónde están cuidando el rebaño?” ");
INSERT INTO spavbl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“Ya se han ido”, respondió el hombre. “Les oí decir: ‘Vamos a Dotán’”. Así que José siguió a sus hermanos y los alcanzó en Dotán. ");
INSERT INTO spavbl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Pero lo vieron venir a lo lejos, y antes de que llegara a ellos, hicieron planes para matarlo. ");
INSERT INTO spavbl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“¡Mira, aquí viene el Señor de los Sueños!” se dijeron entre ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Vamos, matémoslo y arrojémoslo a una de las fosas. Diremos que algún animal salvaje se lo ha comido. ¡Entonces veremos qué pasa con sus sueños!” ");
INSERT INTO spavbl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Cuando Rubén escuchó todo esto, trató de salvar a José de ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","“No lo ataquemos ni lo matemos”, sugirió. “No lo asesinen, sólo arrójenlo a esta fosa aquí en el desierto. No necesitamos ser culpables de violencia”. Rubén dijo esto para poder regresar más tarde y rescatar a José de ellos y llevarlo a casa con su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Así que cuando llegó José, sus hermanos le arrancaron la túnica – la colorida túnica de manga larga que llevaba puesta – ");
INSERT INTO spavbl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","lo agarraron y lo arrojaron a una fosa. (La fosa estaba vacía y no tenía agua). ");
INSERT INTO spavbl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Estaban sentados para comer cuando vieron una caravana de ismaelitas que venía de Galaad. Sus camellos llevaban especias aromáticas, bálsamo y mirra para llevarlos a Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","“¿Qué sentido tiene matar a nuestro hermano?” preguntó Judá a sus hermanos. “¡Entonces tendríamos que encubrir su muerte! ");
INSERT INTO spavbl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","En vez de eso, ¿por qué no lo vendemos a estos ismaelitas? No tenemos que matarlo. Después de todo, es nuestro hermano, nuestra propia carne y sangre”. Sus hermanos estuvieron de acuerdo. ");
INSERT INTO spavbl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Así que cuando los ismaelitas (que eran comerciantes de Madián) llegaron, sacaron a José de la fosa y se lo vendieron por veinte piezas de plata. Los ismaelitas lo llevaron a Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Cuando Rubén regresó más tarde y miró en la fosa, José se había ido. Rasgó sus ropas en señal de dolor. ");
INSERT INTO spavbl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Regresó con sus hermanos. “¡El muchacho se ha ido!”, gimió. “¿Qué voy a hacer ahora?” ");
INSERT INTO spavbl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mataron una cabra y mojaron la túnica de José en la sangre. ");
INSERT INTO spavbl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Luego enviaron la colorida túnica a su padre con el mensaje: “Encontramos esto. Por favor, examínalo y ve si es la túnica de tu hijo o no”. ");
INSERT INTO spavbl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","El padre la reconoció de inmediato y dijo: “¡Esta es la túnica de mi hijo! Algún animal salvaje debe habérselo comido. El pobre José ha sido despedazado, ¡no hay duda de ello!” ");
INSERT INTO spavbl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Entonces Jacob rasgó sus ropas en señal de lamento y se vistió con un saco. Lloró la muerte de su hijo durante mucho tiempo. ");
INSERT INTO spavbl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Todos sus hijos e hijas trataron de consolarlo, pero él rechazaba sus intentos. “No”, dijo, “bajaré a mi tumba llorando por mi hijo”. Así que el padre de José siguió llorando por él. ");
INSERT INTO spavbl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mientras tanto, los ismaelitas habían llegado a Egipto y le habían vendido a José a Potifar. Potifar era uno de los oficiales del faraón, era el capitán de la guardia. ");
INSERT INTO spavbl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Por esta época, Judá dejó a sus hermanos y montó su campamentoen Adulán, cerca de un hombre local llamado Hirá. ");
INSERT INTO spavbl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Allí Judá vio por casualidad a la hija de un cananeo llamado Súa y se casó con ella. Se acostó con ella, ");
INSERT INTO spavbl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","y ella quedó embarazada y tuvo un hijo, al que llamó Er. ");
INSERT INTO spavbl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Luego ella quedó embarazada de nuevo y tuvo un hijo que llamó Onán. ");
INSERT INTO spavbl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Luego tuvo otro hijo llamado Selá que nació en Quezib. ");
INSERT INTO spavbl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mucho más tarde, Judá hizo que Er, su primogénito, se casara con una mujer llamada Tamar. ");
INSERT INTO spavbl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pero Er hizo lo que era malo a los ojos del Señor, así que el Señor le dio muerte. ");
INSERT INTO spavbl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Judá le dijo a Onán, “Ve y acuéstate con la mujer de tu hermano para cumplir los requisitos de un cuñado para tener hijos en nombre de tu hermano”. ");
INSERT INTO spavbl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onán se dio cuenta de que los hijos que tuviera no serían suyos, así que siempre que se acostaba con la mujer de su hermano se aseguraba de que no se quedara embarazada retirando y derramando su semen en el suelo. De esta manera evitaba que nacieran niños en nombre de su hermano. ");
INSERT INTO spavbl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Pero lo que hizo fue malo a los ojos del Señor, así que también mató a Onán. ");
INSERT INTO spavbl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Entonces Judá le dijo a su nuera Tamar, “Ve a la casa de tu padre y vive allí como una viuda hasta que mi hijo Selá crezca”. Porque pensó: “Quizá él también muera, como sus hermanos”. Así que Tamar se fue y se quedó en la casa de su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mucho tiempo después murió la esposa de Judá, la hija de Súa. Cuando Judá terminó el tiempo de luto, fue a visitar a sus esquiladores en Timná con su amigo Hirá de Adulán. ");
INSERT INTO spavbl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","A Tamar le dijeron: “Tu suegro va a Timná a esquilar sus ovejas” ");
INSERT INTO spavbl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Así que se quitó la ropa de viuda y se cubrió con un velo, disfrazándose. Se sentó junto a la entrada de Enayin, que está en el camino a Timná. Se había dado cuenta de que aunque Selá había crecido, no se había hecho nada para que se casara con él. ");
INSERT INTO spavbl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judá la vio y pensó que debía ser una prostituta porque se había cubierto la cara. ");
INSERT INTO spavbl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Se acercó a ella a un lado de la carretera y le dijo: “Quiero acostarme contigo”. Pero no sabía que era su nuera. “¿Qué me darás si te dejo dormir conmigo?” preguntó ella. ");
INSERT INTO spavbl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“Te enviaré una cabra joven de mi rebaño”, respondió él. “¿Qué garantía me darás para asegurarme de que la enviarás?” preguntó ella. ");
INSERT INTO spavbl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“¿Qué garantía tengo que darte?” preguntó él. “Tu sello de sello y su cordón, y tu bastón que sostienes”, respondió ella. Él se los entregó. Se acostó con ella y quedó embarazada. ");
INSERT INTO spavbl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Se fuea casa, se quitó el velo y se puso la ropa de viuda. ");
INSERT INTO spavbl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judá envió a su amigo Hirá de Adulán con una cabra joven para que le devolviera sus pertenencias que había dejado como garantía de la mujer, pero no pudo encontrarla. ");
INSERT INTO spavbl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hirále preguntó a los hombres de allí, “¿Dónde está la prostituta de culto que se sienta en el camino de entrada a Enayin?” “Aquí no hay ninguna prostituta de culto”, respondieron. ");
INSERT INTO spavbl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hirá regresó a Judá y le dijo: “No pude encontrarla, y los hombres de allí dijeron: ‘Aquí no hay ninguna prostituta de culto’”. ");
INSERT INTO spavbl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","“Que se quede con lo que le di”, respondió Judá. “Quedaremos en ridículo si seguimos buscando. En cualquier caso, intenté enviarle la cabra joven como prometí, pero no la encontraron”. ");
INSERT INTO spavbl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Unos tres meses después le dijeron a Judá: “Tamar, tu nuera ha tenido relaciones sexuales como una prostituta y ahora está embarazada”. “¡Sáquenla y quémenla hasta la muerte!” ordenó Judá. ");
INSERT INTO spavbl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Cuando la sacaron, envió un mensaje a su suegro, diciendo: “Estoy embarazada del hombre que posee estas cosas”. Luego añadió: “Por favor, miren con atención este sello, el cordón del sello, y este bastón. ¿A quién le pertenecen?” ");
INSERT INTO spavbl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judá los reconoció de inmediato y dijo: “Ella ha honrado la ley más que yo, porque no la entregué en matrimonio a mi hijo Selá”. Y no volvió a acostarse con Tamar. ");
INSERT INTO spavbl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Cuando llegó el momento en que Tamar debía dara luz, se descubrió que llevaba gemelos. ");
INSERT INTO spavbl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Un bebé extendió su mano, y la comadrona le ató un hilo escarlata en su muñeca y dijo: “Este salió primero” ");
INSERT INTO spavbl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pero entonces él retiró su mano y su hermano nació primero, y ella dijo, “¿cómo saliste tú?” Así que lo llamaron Fares. ");
INSERT INTO spavbl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Después nació su hermano con el hilo escarlata en la muñeca, y lo llamaron Zera. ");
INSERT INTO spavbl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","José había sido llevado a Egipto por los ismaelitas, quienes lo habían vendido a Potifar, un egipcio que era uno de los oficiales del faraón, el comandante de la guardia real. ");
INSERT INTO spavbl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","El Señor estaba con José y lo hacía triunfar. Vivía en la casa de su amo egipcio. ");
INSERT INTO spavbl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Su maestro se dio cuenta de que el Señor estaba con él y le otorgaba éxito en todo lo que hacía. ");
INSERT INTO spavbl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifar apreció a José y su servicio, y lo puso a cargo de su casa y lo hizo responsable de todo lo que poseía. ");
INSERT INTO spavbl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Desde que puso a José a cargo y le confió todo lo que tenía, el Señor bendijo la casa de Potifar por causa de José. El Señor bendecía todo lo que tenía, tanto en su casa como en sus campos. ");
INSERT INTO spavbl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Así que Potifar dejó que José cuidara de todo lo que tenía. No se preocupaba de nada, excepto de decidir qué comida iba a comer. Ahora José era guapo, tenía un buen físico, ");
INSERT INTO spavbl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","y algún tiempo después llamó la atención de la esposa de su amo. Ella le propuso matrimonio, diciendo: “¡Ven aquí! ¡Acuéstate conmigo!” ");
INSERT INTO spavbl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pero él la rechazó, diciéndole a la esposa de su amo: “Mira, mi amo confía tanto en mí, que ni siquiera se molesta en averiguar cómo funciona su casa. Me ha puesto a cargo de todo lo que posee. ");
INSERT INTO spavbl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","¡Nadie en esta casa tiene más autoridad que yo! No me ha ocultado nada excepto a ti, porque eres su esposa. Entonces, ¿cómo podría hacer algo tan malo como esto, y pecar contra Dios?” ");
INSERT INTO spavbl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Día tras día ella insistía en preguntarle, pero él se negaba a dormir con ella y trataba de evitarla. ");
INSERT INTO spavbl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pero un día entró en la casa para hacer su trabajo y ninguno de los otros sirvientes estaba allí. ");
INSERT INTO spavbl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ella lo agarró por la ropa, y le exigió: “¡Acuéstate conmigo!” Pero dejando su ropa en su mano, salió corriendo de la casa. ");
INSERT INTO spavbl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Viendo que había dejado su ropa en su mano y había salido corriendo de la casa, ");
INSERT INTO spavbl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ella gritó a sus sirvientes: “¡Miren! ¡Él trajo a este esclavo hebreo aquí para deshonrarnos! Este hombre vino a tratar de violarme, pero yo grité con todas mis fuerzas. ");
INSERT INTO spavbl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Cuando me oyó gritar pidiendo ayuda, dejó su ropa a mi lado y salió corriendo” ");
INSERT INTO spavbl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Y guardó la ropa de José hasta que su marido volvió a casa. ");
INSERT INTO spavbl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Luego le contó su historia. Y esto fue lo que le dijo: “Ese esclavo hebreo que trajiste aquí trató de venir a deshonrarme. ");
INSERT INTO spavbl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Pero tan pronto como grité y pedí ayuda, dejó su ropa a mi lado y salió corriendo”. ");
INSERT INTO spavbl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Cuando Potifar oyó la historia que le contó su mujer, diciendo: “Esto es lo que tu siervo me hizo”, se enfadó. ");
INSERT INTO spavbl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tomó a José y lo metió en la prisión donde estaban los prisioneros del rey, y allí se quedó. ");
INSERT INTO spavbl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Pero el Señor estaba con José, mostrándole un amor digno de confianza, e hizo que el carcelero principal sintiera agrado de él. ");
INSERT INTO spavbl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","El carcelero principal puso a José a cargo de todos los prisioneros y le dio la responsabilidad de dirigir la prisión. ");
INSERT INTO spavbl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","El carcelero principal no se preocupaba de nada porque José se ocupaba de todo, pues el Señor estaba con él y le daba éxito. ");
INSERT INTO spavbl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Más tarde, el copero y el panadero cometieron alguna ofensa contra su amo, el rey de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","El Faraón se enojó con estos dos oficiales reales – el copero y el panadero principal— ");
INSERT INTO spavbl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","y los encarceló en la casa del comandante de la guardia, la misma prisión donde estaba José. ");
INSERT INTO spavbl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","El comandante de la guardia les asignó a José como su asistente personal. Fueron mantenidos en prisión por algún tiempo. ");
INSERT INTO spavbl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Una noche, mientras estaban en la cárcel, el copero y el panadero del rey de Egipto tuvieron un sueño. Eran sueños diferentes, cada uno con su propio significado. ");
INSERT INTO spavbl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Cuando José llegó a la mañana siguiente notó que ambos parecían deprimidos. ");
INSERT INTO spavbl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Así que le preguntó a los oficiales del faraón que estaban presos con él en la casa de su amo, “¿Por qué te ves tan deprimido?” ");
INSERT INTO spavbl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“Los dos hemos tenido sueños, pero no encontramos a nadie que nos explique lo que significan”, dijeron. Así que José les dijo, “¿No es Dios el que puede interpretar el significado de los sueños? Cuéntame tus sueños” ");
INSERT INTO spavbl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","El copero principal le contó a José su sueño. “En mi sueño había una vid justo delante de mí”, explicó. ");
INSERT INTO spavbl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","“La vid tenía tres ramas. Tan pronto como brotaba, florecía y producía racimos de uvas maduras. ");
INSERT INTO spavbl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Yo sostenía la copa de vino del Faraón, así que recogí las uvas y las metí en la copa y se la di al Faraón”. ");
INSERT INTO spavbl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","“Este es el significado”, le dijo José. “Las tres ramas representan tres días. ");
INSERT INTO spavbl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dentro de tres días el Faraón te sacará de la cárcel y te devolverá tu trabajo, y tú le entregarás al Faraón su copa como solías hacerlo. ");
INSERT INTO spavbl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Pero cuando las cosas te vayan bien, por favor, acuérdate de mi y habla con el Faraón en mi nombre, y por favor sácame de esta prisión. ");
INSERT INTO spavbl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Fui cruelmente secuestrado en la tierra de los hebreos, y ahora estoy aquí en esta fosa a pesar de que no he hecho nada malo”. ");
INSERT INTO spavbl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Cuando el jefe de los panaderos vio que la interpretación era positiva, le dijo a José: “Yo también tuve un sueño. Tenía tres cestas de pasteles en mi cabeza. ");
INSERT INTO spavbl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","En la cesta de arriba estaban todos los pasteles y pastas para que los comiera el Faraón, y los pájaros se los comían de la cesta de mi cabeza”. ");
INSERT INTO spavbl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","“Este es el significado”, le dijo José. “Las tres cestas representan tres días. ");
INSERT INTO spavbl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dentro de tres días el Faraón te sacará de la cárcel y te colgará en un palo, y los pájaros se comerán tu carne”. ");
INSERT INTO spavbl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tres días más tarde era el cumpleaños del Faraón, y organizó un banquete para todos sus oficiales. Hizo que el copero y el panadero jefe fueran liberados de la prisión y llevados allí ante sus oficiales. ");
INSERT INTO spavbl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Le devolvió el trabajo al copero jefe y volvió a sus deberes de entregar al Faraón su copa. ");
INSERT INTO spavbl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pero colgó al jefe de los panaderos tal como José había dicho cuando interpretó sus sueños. ");
INSERT INTO spavbl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Pero el copero jefe no se acordó de decir nada sobre José; de hecho, se olvidó de él. ");
INSERT INTO spavbl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Dos años más tarde, el Faraón soñó que estaba de pie junto al río Nilo. ");
INSERT INTO spavbl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Vio siete vacas que subían del río. Parecían bien alimentadas y sanas mientras pastaban entre los juncos. ");
INSERT INTO spavbl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Luego vio otras siete vacas que subían por detrás de ellas. Se veían feas y flacas mientras estaban junto a las otras vacas en la orilla del Nilo. ");
INSERT INTO spavbl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Luego las vacas feas y flacas se comieron a las vacas bien alimentadas y sanas. Entonces el Faraón se despertó. ");
INSERT INTO spavbl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","El Faraón se durmió de nuevo y tuvo un segundo sueño. En un tallo crecían siete cabezas de grano, maduras y sanas. ");
INSERT INTO spavbl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Entonces siete cabezas de grano crecieron después de ellas, delgadas y secas por el viento del este. ");
INSERT INTO spavbl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Las siete cabezas de grano delgadas y secas se tragaron las maduras y sanas. Entonces el Faraón se despertó y se dio cuenta de que había estado soñando. ");
INSERT INTO spavbl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","A la mañana siguiente el Faraón estaba preocupado por sus sueños, así que mandó llamar a todos los magos y sabios de Egipto. El Faraón les habló de sus sueños, pero nadie pudo interpretar su significado para él. ");
INSERT INTO spavbl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Pero entonces el copero principal habló. “Hoy acabo de recordar un grave error que he cometido”, explicó. ");
INSERT INTO spavbl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","“Su Majestad se enfadó con algunos de sus oficiales y me encarceló en la casa del comandante de la guardia, junto con el panadero jefe. ");
INSERT INTO spavbl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Cada uno de nosotros tuvo un sueño. Eran sueños diferentes, cada uno con su propio significado. ");
INSERT INTO spavbl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Un joven hebreo estaba allí con nosotros, un esclavo del comandante de la guardia. Cuando le contamos nuestros sueños, nos interpretó el significado de nuestros diferentes sueños. ");
INSERT INTO spavbl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Todo sucedió tal y como él dijo que sucedería, me devolvieron mi trabajo y colgaron al panadero”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","El Faraón convocó a José, y rápidamente lo trajeron de la prisión. Después de que se afeitara y se cambiara de ropa, fue presentado al Faraón. ");
INSERT INTO spavbl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","El Faraón le dijo a José: “Tuve un sueño, pero nadie puede interpretar su significado. Pero he oído que cuando alguien te cuenta un sueño sabes cómo interpretarlo”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","“No soy yo quien puede hacer esto”, respondió José. “Pero Dios explicará su significado para tranquilizar la mente de Su Majestad” ");
INSERT INTO spavbl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","El Faraón le explicó a José, “En mi sueño estaba parado a la orilla del Nilo. ");
INSERT INTO spavbl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Vi siete vacas que subían del río. Parecían bien alimentadas y sanas mientras pastaban entre los juncos. ");
INSERT INTO spavbl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Luego vi otras siete vacas que subían por detrás de ellas. Se veían enfermas, feas y flacas. ¡Nunca había visto vacas tan feas en todo Egipto! ");
INSERT INTO spavbl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Estas vacas flacas y feas se comieron las primeras siete vacas de aspecto saludable. ");
INSERT INTO spavbl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pero después no se podía saber que se las habían comido porque se veían tan flacas y feas como antes. Entonces me desperté. ");
INSERT INTO spavbl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Luego me volví a dormir. En mi segundo sueño vi siete cabezas de grano creciendo en un tallo, maduras y sanas. ");
INSERT INTO spavbl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Después de ellos crecieron siete cabezas de grano, marchitas y delgadas y secas por el viento del este. ");
INSERT INTO spavbl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Las siete delgadas cabezas de grano se tragaron las sanas. Les dije todo esto a los magos, pero ninguno de ellos pudo explicarme su significado”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","“Los sueños del faraón significan lo mismo”, respondió José. “Dios le está diciendo a Faraón lo que va a hacer. ");
INSERT INTO spavbl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Las siete buenas vacas y las siete buenas cabezas de grano representan siete buenos años de cosecha. Los sueños significan lo mismo. ");
INSERT INTO spavbl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Las siete vacas flacas y feas que vinieron después de ellas y las siete finas cabezas de grano secadas por el viento del este representan siete años de hambruna. ");
INSERT INTO spavbl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Es tal como le dije a Su Majestad: Dios ha mostrado al Faraón lo que va a hacer. ");
INSERT INTO spavbl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Van a ser siete años con mucha comida producida en todo el país de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Pero después de ellos vendrán siete años de hambruna. La gente olvidará la época en que había mucha comida en todo Egipto. La hambruna arruinará el país. ");
INSERT INTO spavbl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","El tiempo de abundancia se olvidará por completo porque la hambruna que le sigue será terrible. ");
INSERT INTO spavbl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","El hecho de que el sueño se repitiera dos veces significa que definitivamente ha sido decidido por Dios, y que Dios lo hará pronto. ");
INSERT INTO spavbl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Así que Su Majestad debería elegir un hombre con perspicacia y sabiduría, y ponerlo a cargo de todo el país de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Su Majestad también debe nombrar funcionarios para que estén a cargo de la tierra, y hacer que recojan una quinta parte del producto del país durante los siete años de abundancia. ");
INSERT INTO spavbl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Deben recoger todos los alimentos durante los años buenos que se avecinan, y almacenar el grano bajo la autoridad del Faraón, manteniéndolo bajo vigilancia para proporcionar alimentos a los pueblos. ");
INSERT INTO spavbl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Esto será una reserva de alimentos para el país durante los siete años de hambruna para que la gente no muera de hambre”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","El Faraón y todos sus oficiales pensaron que la propuesta de José era una buena idea. ");
INSERT INTO spavbl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Así que el Faraón les preguntó: “¿Dónde podemos encontrar a un hombre como este que tiene el espíritu de Dios en él?” ");
INSERT INTO spavbl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Entonces el Faraón habló con José, diciéndole: “Puesto que Dios te ha revelado todo esto, y no hay nadie como tú con tanta perspicacia y sabiduría, ");
INSERT INTO spavbl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","tú estarás a cargo de todos mis asuntos, y todo mi pueblo obedecerá tus órdenes. Sólo yo, con mi condición de rey seré más grande que tú”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Entonces el Faraón le dijo a José: “Mira, te pongo a cargo de todo el país de Egipto”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","El Faraón se quitó el anillo del sello del dedo y lo puso en el dedo de José. Lo vistió con ropas de lino fino y le puso una cadena de oro alrededor del cuello. ");
INSERT INTO spavbl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Hizo que José viajara en el carro designado para su segundo al mando mientras sus asistentes se adelantaron gritando, “¡Inclínate!” Así es como el Faraón le dio a José autoridad sobre todo Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Entonces el Faraón le dijo a José, “Yo soy el Faraón, pero sin tu permiso nadie levantará una mano o un pie en todo el país”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","El Faraón le dio a José el nombre de Zafnat Paneajab, y arregló que se casara con Asenat, la hija de Potifera, sacerdote de On. Así es como José se elevó al poder en todo Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","José tenía treinta años cuando empezó a trabajar para el Faraón, rey de Egipto. Después de dejar al Faraón, José viajó en una gira de inspección por todo Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Durante los siete años de buenas cosechas, la tierra produjo muchos alimentos. ");
INSERT INTO spavbl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Recolectó todos los alimentos durante los siete años buenos, y almacenó el grano producido en los campos locales de cada ciudad. ");
INSERT INTO spavbl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","José apiló tanto grano que era como la arena de la orilla del mar. Eventualmente dejó de llevar registros porque había mucho. ");
INSERT INTO spavbl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Fue durante este tiempo, antes de que llegaran los años de hambruna, que José tuvo dos hijos con Asenat, la hija de Potifera, sacerdote de On. ");
INSERT INTO spavbl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","José nombró a su primogénito Manasés, porque dijo: “El Señor me ha hecho olvidar todos mis problemas y toda la familia de mi padre”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A su segundo hijo le puso el nombre de Efraín, porque dijo: “Dios me ha hecho fructífero en el país de mi miseria”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Los siete años de abundancia en Egipto llegaron a su fin, ");
INSERT INTO spavbl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","y los siete años de hambruna comenzaron, tal como José había dicho. Había hambruna en todos los demás países, pero todo Egipto tenía comida. ");
INSERT INTO spavbl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Cuando todo Egipto tuvo hambre, la gente clamó al Faraón por comida, y él les dijo a todos: “Vayan a ver a José y hagan lo que él les diga”. ");
INSERT INTO spavbl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","La hambruna se había extendido por todo el país, así que José abrió todos los almacenes y vendió el grano al pueblo de Egipto. La hambruna era muy mala en Egipto, ");
INSERT INTO spavbl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","de hecho, la hambruna era muy mala en todas partes, así que la gente de otros países de todo el mundo vino a Egipto para comprar grano a José. ");
INSERT INTO spavbl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Cuando Jacob se enteró de que había grano disponible en Egipto, preguntó a sus hijos: “¿Por qué siguen mirándose para hacer algo? ");
INSERT INTO spavbl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","He oído que hay grano en Egipto. ¡Ve allí y compra un poco para nosotros para que podamos seguir vivos, si no, vamos a morir!” ");
INSERT INTO spavbl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Así que diez de los hermanos de José fueron a Egipto a comprar grano. ");
INSERT INTO spavbl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pero Jacob no envió al hermano de José, Benjamín, con sus otros hermanos, porque dijo: “Tengo miedo de que le pase algo malo”. ");
INSERT INTO spavbl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Así que los hijos de Israel fueron a comprar grano junto con todos los demás, porque también había hambre en Canaán. ");
INSERT INTO spavbl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","José era el gobernador del país y vendía grano a todo el pueblo de allí. Los hermanos de José fueron a él y se inclinaron ante él con el rostro en tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","José los reconoció en cuanto los vio, pero se comportó como un extraño con ellos y les habló con severidad, diciendo: “¿De dónde vienen?” “Del país de Canaán”, le respondieron. “Hemos venido a comprar comida”. ");
INSERT INTO spavbl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Aunque José reconoció a sus hermanos, ellos no lo reconocieron a él. ");
INSERT INTO spavbl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","José pensó en los sueños que había tenido con ellos y les dijo: “¡No! ¡Son espías! ¡Habéis venido a descubrir las debilidades de nuestro país!” ");
INSERT INTO spavbl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“¡Eso no es cierto, mi señor!” respondieron. “Nosotros, sus siervos, hemos venido a comprar” ");
INSERT INTO spavbl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","“Todos somos hijos de un hombre y somos honestos. ¡No somos espías!” ");
INSERT INTO spavbl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“¡Claro que no! ¡Ustedes han venido a descubrir la debilidad de nuestra nación!” insistió. ");
INSERT INTO spavbl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","“Tus siervos son doce hermanos, hijos de un hombre que vive en el país de Canaán”, explicaron. “El más joven está ahora mismo con nuestro padre, y uno ha fallecido”. ");
INSERT INTO spavbl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","“Como dije antes, ¡son espías!” declaró José. ");
INSERT INTO spavbl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","“Así es como se comprobará su historia: Juro por la vida del Faraón que nunca dejarán este país a menos que su hermano menor venga aquí. ");
INSERT INTO spavbl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Uno de ustedes tendrá que regresar y traer a su otro hermano aquí. Los demás se quedarán aquí en la cárcel hasta que esté claro que dicen la verdad. Si no, entonces juro por la vida del Faraón que esa será la prueba de que son espías” ");
INSERT INTO spavbl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Así que José los puso a todos en prisión por tres días. ");
INSERT INTO spavbl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Al tercer día les dijo: “Como respeto a Dios, hagan lo que les digo y vivirán. ");
INSERT INTO spavbl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si son verdaderamente honestos, elijan a uno de sus hermanos para que se quede aquí en la cárcel. El resto de podrá volver a casa con grano para sus familias hambrientas. ");
INSERT INTO spavbl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pero deben traer a su hermano menor aquí para demostrar que lo que dicen es verdad. Si no, todos ustedes morirán”.Ellos estuvieron de acuerdo en hacer esto. ");
INSERT INTO spavbl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","“Claramente estamos siendo castigados por lo que le hicimos a nuestro hermano”, se decían unos a otros. “Lo vimos en agonía suplicándonos misericordia, pero nos negamos a escucharlo. Es por eso que tenemos todos estos problemas”. ");
INSERT INTO spavbl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubén les dijo: “¿No les dije: ‘No le hagan daño al muchacho’? Pero no me escucharon. Ahora estamos pagando el precio por lo que le hicimos”. ");
INSERT INTO spavbl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","No se daban cuenta de que José entendía lo que decían porque le hablaban a través de un intérprete. ");
INSERT INTO spavbl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","José se alejó de ellos porque empezó a llorar. Volvió cuando pudo hablarles de nuevo. Eligió a Simeón y lo tuvo atado mientras ellos miraban. ");
INSERT INTO spavbl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","José dio la orden de llenar sus sacos con grano, y también de devolver el dinero que habían pagado poniéndolo también en los sacos. También ordenó que se les proveyera de comida para el viaje de vuelta a casa. Todo esto se hizo. ");
INSERT INTO spavbl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Los hermanos cargaron el grano en sus asnos y luego se pusieron en marcha. ");
INSERT INTO spavbl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","En el camino, se detuvieron para pasar la noche y uno de ellos abrió su saco para darle algo de comer a su asno y vio su dinero allí en la parte superior del saco. ");
INSERT INTO spavbl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Entonces les dijo a sus hermanos: “Me han devuelto mi dinero. ¡Está aquí mismo en la parte superior de mi saco!” ¡Estaban horrorizados! Temblando de miedo se preguntaron: “¿Qué es esto que Dios nos ha hecho?” ");
INSERT INTO spavbl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Cuando llegaron a casa en Canaán, le contaron a su padre Jacob todo lo que había pasado. ");
INSERT INTO spavbl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“El hombre que es el gobernador del país nos habló de manera severa y nos acusó de espiar la tierra”, explicaron. ");
INSERT INTO spavbl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","“Le dijimos: ‘Somos hombres honestos. ¡No somos espías! ");
INSERT INTO spavbl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Somos doce hermanos, hijos de un solo padre. Uno ha fallecido y el más joven está ahora mismo con nuestro padre en el país de Canaán’. ");
INSERT INTO spavbl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Entonces el gobernador del país nos dijo: ‘Así es como sabré si dicen la verdad: dejen a uno de sus hermanos aquí conmigo mientras los demás llevan grano a casa para sus familias hambrientas. ");
INSERT INTO spavbl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Entonces tráiganme a su hermano menor. Así sabré que no son espías, sino que dicen la verdad. Les entregaré a su hermano y podrán quedarse en el país y hacer negocios’”. ");
INSERT INTO spavbl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mientras vaciaban sus sacos, la bolsa de dinero de cada uno estaba allí en su saco. Cuando ellos y su padre vieron las bolsas de dinero, se horrorizaron. ");
INSERT INTO spavbl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob, su padre, los acusó: “Me han quitado a José, ¡se ha ido! ¡Simeón también se ha ido! ¡Ahora quieren llevarse a Benjamín! ¡Soy yo el que está sufriendo por todo esto!” ");
INSERT INTO spavbl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","“Puedes matar a mis dos hijos si no te lo devuelvo”, le aseguró Rubén. “Confíameloa mí, y yo mismo te lo traeré a casa”. ");
INSERT INTO spavbl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","“¡Mi hijo no irá allí con ustedes!” declaró Jacob. “Su hermano está muerto, y es el único que me queda. Si le pasa algo malo en el viaje, la tristeza llevará a este viejo a la tumba”. ");
INSERT INTO spavbl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","La hambruna continuó siendo muy grave en Canaán, ");
INSERT INTO spavbl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","así que una vez que se acabó el grano que habían traído de Egipto, su padre les dijo: “Tienen que volver y comprar más grano”. ");
INSERT INTO spavbl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pero Judá respondió: “El hombre fue firme cuando nos advirtió: ‘No los veré a menos que su hermano venga con ustedes’. ");
INSERT INTO spavbl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si envías a nuestro hermano Benjamín con nosotros, entonces iremos a comprar comida para ti. ");
INSERT INTO spavbl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pero si no lo envías, entonces no iremos, porque el hombre fue muy claro, ‘No los veré a menos que su hermano venga con ustedes’”. ");
INSERT INTO spavbl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","“¿Por qué me hancomplicado las cosas al decirle al hombre que tenían otro hermano?” preguntó Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","“El hombre seguía haciendo preguntas directas sobre nosotros y nuestra familia, como: ‘¿Su padre sigue vivo?’ y ‘¿Tienen otro hermano?’” respondieron ellos. “Sólo respondimos a sus preguntas. ¿Cómo íbamos a saber que él diría, ‘¡Traigan a su hermano aquí!’” ");
INSERT INTO spavbl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judá le dijo a su padre Israel: “Envía al muchacho bajo mi cuidado, y nos iremos inmediatamente, para que podamos seguir vivos y no morir, ¡y eso te incluye a ti, a nosotros y a nuestros hijos! ");
INSERT INTO spavbl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Prometo cuidarlo y seré personalmente responsable de traerlo de vuelta a ti. ¡Si no lo hago, entonces cargaré siempre con la culpa! ");
INSERT INTO spavbl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ahora vamos, porque si no hubiéramos dudado, ya podríamos haber ido y vuelto dos veces”. ");
INSERT INTO spavbl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","“Si tiene que ser así, entonces esto es lo que harán”, respondió Israel. “Llévense lo mejor que produce nuestro país. Empaquen sus bolsas con regalos para este hombre: bálsamo, un poco de miel, especias, mirra, pistachos y almendras. ");
INSERT INTO spavbl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Lleven el doble del dinero que les han devuelto en tus sacos, tal vez fue un error. ");
INSERT INTO spavbl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tomen a su hermano y regresen de inmediato donde este hombre. ");
INSERT INTO spavbl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Que Dios Todopoderoso haga que este hombre los trate bien para que cuando se presenten ante él libere a su otro hermano y envíe a Benjamín de regreso. En cuanto a mí, si voy a perder a todos mis hijos, que así sea”. ");
INSERT INTO spavbl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Así que empacaron los regalos, tomaron el doble de dinero y se fueron, acompañados por Benjamín. Llegaron a Egipto y fueron a tener una audiencia con José. ");
INSERT INTO spavbl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Cuando José vio que Benjamín estaba con ellos, le dijo al encargado de su casa: “Lleva a estos hombres a mi casa. Maten un animal y preparen una comida, porque van a comer conmigo al mediodía”. ");
INSERT INTO spavbl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","El hombre hizo lo que le ordenó José y los llevó a la casa de José. ");
INSERT INTO spavbl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ellos estaban muy asustados de que los llevaran a la casa de José. “Es por el dinero que se estaba en nuestros sacos la primera vez que vinimos”, se dijeron entre ellos. “¡Por eso nos traen para acusarnos y atacarnos! ¡Nos convertirá en sus esclavos y se llevará nuestros asnos!” ");
INSERT INTO spavbl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Así que fueron y hablaron con el supervisor de la casa de José en la entrada de la casa. ");
INSERT INTO spavbl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Por favor, discúlpenos, mi señor”, dijeron. “Bajamos la primera vez para comprar comida, ");
INSERT INTO spavbl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","y cuando nos detuvimos para pasar la noche, abrimos nuestros sacos y cada uno de nosotros encontró su dinero, la cantidad exacta, en la parte superior de nuestros sacos. Así que lo trajimos de vuelta con nosotros. ");
INSERT INTO spavbl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","También hemos traído más dinero para comprar comida. ¡No tenemos ni idea de quién puso nuestro dinero en nuestros sacos!” ");
INSERT INTO spavbl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“¡Todo está bien!” les dijo. “¡No se preocupen! Su Dios, el Dios de su padre, debe haberles dado el tesoro escondido en sus sacos. Yo tengo su dinero”. Luego trajo a Simeón para que se encontrara con ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","El mayordomo los llevó dentro de la casa de José, les dio agua para que se lavaran los pies, y les dio comida para sus asnos. ");
INSERT INTO spavbl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Prepararon sus regalos para cuando José viniera al mediodía, porque se habían enterado de que iban a comer allí. ");
INSERT INTO spavbl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Cuando José llegó a la casa le dieron los regalos que le habían traído y se inclinaron hasta el suelo ante él. ");
INSERT INTO spavbl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","José preguntó cómo estaban, y luego les preguntó: “¿Cómo está su anciano padre del cual me hablaron? ¿Sigue vivo?” ");
INSERT INTO spavbl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Sí, tu siervo, nuestro padre, sigue vivo y está bien”, respondieron, y se inclinaron en señal de respeto. ");
INSERT INTO spavbl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Entonces José miró a su hermano Benjamín, el hijo de su propia madre. “¿Es este su hermano más joven del que me hablaron?” preguntó. “Dios sea misericordioso contigo, hijo mío”, dijo. ");
INSERT INTO spavbl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","José tuvo que salir corriendo rápidamente porque se estaba poniendo muy emotivo al ver a su hermano.Buscó un lugar para llorar, y se fue a su habitación para llorar allí. ");
INSERT INTO spavbl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Luego se lavó la cara, controló sus emociones y volvió a salir. “Sirvan la comida”, ordenó. ");
INSERT INTO spavbl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","José fue servido en una mesa para él solo, y sus hermanos fueron servidos en una mesa separada. A los egipcios también se les sirvió en otra mesa, porque los egipcios no podrían comer con los hebreos, porque les resultaba repulsivo. ");
INSERT INTO spavbl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Los hermanos se habían sentado frente a él en orden de edad, desde el primogénito, el mayor, hasta el más joven, y se miraron con absoluta sorpresa. ");
INSERT INTO spavbl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","La comida se les sirvió de la mesa de José, y Benjamín recibió cinco veces más que cualquier otro. Así que comieron y bebieron mucho con él. ");
INSERT INTO spavbl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","José le ordenó al mayordomo de la casa: “Llena los sacos de los hombres con todo el grano que puedan contener y pon el dinero de cada hombre en la parte superior de su saco. ");
INSERT INTO spavbl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Luego pon mi taza de plata especial en la parte superior del saco del más joven, junto con el dinero para su grano”.El mayordomo hizo lo que le dijo José. ");
INSERT INTO spavbl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Al amanecer, fueron enviados de camino con sus asnos. ");
INSERT INTO spavbl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Apenas habían salido de la ciudad cuando José le dijo al mayordomo de su casa: “Ve tras esos hombres, y cuando los alcances, pregúntales: ‘¿Por qué han devuelto el bien con el mal, robando la copa de plata de mi amo? ");
INSERT INTO spavbl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Esta es la copa de la que él personalmente bebe, y que usa para adivinar. Lo que han hecho es realmente malo!’” ");
INSERT INTO spavbl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Cuando los alcanzó, les dijo lo que José había dicho. ");
INSERT INTO spavbl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","“Señor mío, ¿qué estás diciendo?” le contestaron. “¡Nosotros, tus siervos, no haríamos algo así! ");
INSERT INTO spavbl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Recuerda que trajimos el dinero que encontramos en la parte superior de nuestros sacos cuando volvimos de Canaán. ¿Por qué robaríamos plata u oro de la casa de tu señor? ");
INSERT INTO spavbl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Si alguno de nosotros es encontrado con él, morirá, y todos nosotros nos convertiremos en tus esclavos”. ");
INSERT INTO spavbl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“Lo que ustedes digan”, respondió el hombre, “pero sólo el que sea encontrado con él se convertirá en mi esclavo, ya que el resto de ustedes estarán libres de toda culpa”. ");
INSERT INTO spavbl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Todos descargaron sus sacos y los pusieron en el suelo. Cada uno abrió su propio saco. ");
INSERT INTO spavbl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","El supervisor de la casa registró los sacos, empezando por el más viejo y bajando hasta el más joven. La taza fue encontrada en el saco de Benjamín. ");
INSERT INTO spavbl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Los hermanos rasgaron sus ropas en señal de lamento. Luego cargaron los sacos en sus burros y se dirigieron a la ciudad. ");
INSERT INTO spavbl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","José todavía estaba en casa cuando Judá y sus hermanos llegaron, y cayeron al suelo delante de él. ");
INSERT INTO spavbl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","“¿Por qué hicieron esto?” preguntó José. “¿No saben que un hombre como yo puede darse cuenta de estas cosas por medio de la adivinación?” ");
INSERT INTO spavbl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","“Mi señor, ¿qué podemos decir?” respondió Judá. “¿Cómo podemos explicarte esto? ¿De qué manera podemos probar nuestra inocencia? Dios ha expuesto la culpa de tus siervos. Mi señor, somos tus esclavos, todos nosotros, incluyendo el que fue encontrado con la copa” ");
INSERT INTO spavbl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","“¡Yo no haría nada de eso!” respondió José. “Sólo el hombre que fue encontrado con la copa se convertirá en mi esclavo. El resto de ustedes puede regresar con su padre”. ");
INSERT INTO spavbl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Judá se acercó y le dijo: “Si te complace, mi señor, deja que tu siervo diga una palabra. Por favor, no te enfades con tu siervo, aunque seas tan poderoso como el propio Faraón. ");
INSERT INTO spavbl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mi señor, antes nos preguntaste: ‘¿Tienen un padre o un hermano?’ ");
INSERT INTO spavbl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Y respondimos, mi señor: ‘Tenemos un padre anciano y un hermano menor, que nació cuando nuestro padre ya era anciano. El hermano del muchacho está muerto. Es el único de los hijos de su madre que queda, y su padre lo quiere mucho’. ");
INSERT INTO spavbl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Entonces tú nos ordenaste: ‘Tráiganlo aquí para que pueda verlo’. ");
INSERT INTO spavbl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Y te dijimos: ‘El muchacho no puede dejar a su padre; porque si lo hiciera, su padre moriría’. ");
INSERT INTO spavbl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Pero tú nos dijiste: ‘Si su hermano menor no viene con ustedes, no me volverán a ver’. ");
INSERT INTO spavbl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Así que cuando volvimos con tu siervo, nuestro padre, le explicamos todo lo que nos habías dicho. ");
INSERT INTO spavbl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Sin embargo, más tarde, nuestro padre nos dijo: ‘Vuelvan y compren más comida’. ");
INSERT INTO spavbl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Pero nosotros le dijimos: ‘No podemos volver a menos que Benjamín, nuestro hermano menor, vaya con nosotros, porque no podremos ver a este hombre si Benjamín no va con nosotros’. ");
INSERT INTO spavbl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Entonces mi padre nos dijo: ‘Se dan cuenta de que mi mujer tuvo dos hijos para mí. ");
INSERT INTO spavbl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Uno ya no está, sin duda quedó hecho pedazos, porque no lo he visto desde entonces. ");
INSERT INTO spavbl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si me quitan a éste también, y le pasa algo malo, la tristeza llevará a este viejo a la tumba’. ");
INSERT INTO spavbl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Así que si el muchacho no está con nosotros cuando regrese a mi padre, cuya vida depende de la vida del muchacho, ");
INSERT INTO spavbl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","tan pronto como vea que el muchacho no está allí morirá, y realmente enviaremos a este anciano, nuestro padre, a su tumba con tristeza. ");
INSERT INTO spavbl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","De hecho me di a mí mismo como garantía del muchacho a mi padre. Le dije: ‘¡Si no lo traigo de vuelta a ti, siempre cargaré con la culpa!’ ");
INSERT INTO spavbl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Así que, por favor, déjame quedarme aquí como esclavo de mi señor en lugar del niño. Deja que vuelva a casa con sus hermanos. ");
INSERT INTO spavbl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Porque, ¿cómo podría volver a mi padre si el niño no estuviera conmigo? No podría soportar ver la angustia que causaría a mi padre”. ");
INSERT INTO spavbl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","José no pudo controlar sus emociones por más tiempo mientras todos sus asistentes estaban allí, así que gritó: “¡Todos déjenme solo!” Así que no había nadie más cuando José reveló quién era a sus hermanos. ");
INSERT INTO spavbl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Pero gritó tan fuerte que los egipcios pudieron oírlo, y se lo contaron a la casa del Faraón. ");
INSERT INTO spavbl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","“¡Yo soy José!” les anunció a sus hermanos. “¿Mi padre sigue vivo?” No pudieron responderle porque se sorprendieron mucho al verle cara a cara. ");
INSERT INTO spavbl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","“Por favor, acérquense a mí”, les dijo a sus hermanos. Se acercaron a él. “Soy su hermano José, a quien vendieron como esclavo en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Pero no se preocupen ni se enojen con ustedes mismos por haberme vendido como esclavo aquí, porque fue Dios quien me envió antes que ustedes para salvar vidas. ");
INSERT INTO spavbl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","El país ha sufrido de hambruna durante dos años ya, pero habrá cinco años más sin arar ni cosechar. ");
INSERT INTO spavbl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dios me envió delante de ustedes para asegurarse de que todavía tuvieran descendencia, para salvar sus vidas de esta forma milagrosa. ");
INSERT INTO spavbl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Así que no fueron ustedes quienes me enviaron aquí, sino Dios. Él fue quien me convirtió en el consejero principal del Faraón a cargo de todos sus asuntos, y gobernante de todo el país de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“¡Ahora apúrense! Vuelvan donde está mi padre y díganle: ‘Este mensaje es de tu hijo José: Dios me ha hecho gobernante de todo Egipto. Ven a mí ahora, sin tardar. ");
INSERT INTO spavbl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Vivirás en la tierra de Gosén para estar cerca de mí con tus hijos y nietos, y con tus rebaños y manadas y todo lo que te pertenece. ");
INSERT INTO spavbl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Me aseguraré de que tengan comida, porque aún quedan cinco años de hambruna por venir. De lo contrario, tú y tu familia y tus animales van a morir de hambre’”. ");
INSERT INTO spavbl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Entonces José dijo a sus hermanos, “¡Todos pueden ver por ustedes mismos, incluyendo a mi hermano Benjamín, que realmente soy yo quien les habla! ");
INSERT INTO spavbl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Díganle a mi padre cuánto me respetan en Egipto. Cuéntenle todo lo que han visto. ¡Deprisa! ¡Traigan a mi padre aquí rápidamente!” ");
INSERT INTO spavbl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Abrazó a Benjamín, y Benjamín le devolvió el abrazo. Ambos lloraron de alegría. ");
INSERT INTO spavbl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Besó a todos sus hermanos y lloró por ellos, y después de eso, sus hermanos pudieron empezar a hablar con él. ");
INSERT INTO spavbl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Pronto llegó al palacio del faraón la noticia de que los hermanos de José habían llegado. El Faraón y sus oficiales se alegraron de escuchar la noticia. ");
INSERT INTO spavbl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","El faraón le dijo a José: “Dile a tus hermanos: ‘Esto es lo que deben hacer: Carguen sus asnos con grano y vuelvan a la tierra de Canaán. ");
INSERT INTO spavbl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Entonces traigan a su padre y a sus familias y vuelvan aquí conmigo. Les daré la mejor tierra de Egipto y comerán la mejor comida que el país pueda ofrecerles’. ");
INSERT INTO spavbl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Diles que hagan esto también: ‘Tomen algunos carros de Egipto para sus hijos y sus esposas. Tráiganlos a ellos y a su padre aquí. ");
INSERT INTO spavbl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","No se preocupen por traer sus posesiones, porque lo mejor de todo Egipto ya les pertenece’”. ");
INSERT INTO spavbl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Así que los hijos de Israel hicieron justamente eso. José les proporcionó carros, como el faraón lo había ordenado. También les dio provisiones para su viaje. ");
INSERT INTO spavbl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Les dio a cada uno de ellos ropa nueva. Pero a Benjamín le dio cinco juegos de ropa y 300 piezas de plata. ");
INSERT INTO spavbl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","José también envió a su padre lo siguiente: diez asnos que llevaban las mejores cosas de Egipto, y diez asnas que llevaban el grano y el pan y los suministros necesarios para el viaje de su padre. ");
INSERT INTO spavbl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Luego vio a sus hermanos irse, y cuando se fueron les dijo: “¡No discutan en el camino!” ");
INSERT INTO spavbl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Así que salieron de Egipto y volvieron a la casa de su padre Jacob, en el país de Canaán. ");
INSERT INTO spavbl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“¡José sigue vivo!” le dijeron. “¡Es verdad, y él es el gobernante de todo el país de Egipto!” Jacob se quedó atónito con la noticia, ¡no podía creerlo! ");
INSERT INTO spavbl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pero cuando le contaron todo lo que José les había dicho, y cuando vio los carros que José había enviado para llevarlo a Egipto, Jacob volvió en sí. ");
INSERT INTO spavbl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel dijo, “¡Está bien, les creo! ¡Mi hijo José sigue vivo! Voy a ir a verlo antes de morir”. ");
INSERT INTO spavbl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Así que Israel se fue a Egipto con todo lo que tenía. Cuando llegó a Beerseba ofreció sacrificios al Dios de su padre Isaac. ");
INSERT INTO spavbl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Durante la noche Dios habló a Israel en una visión. “¡Jacob! ¡Jacob!” llamó. “Estoy aquí”, respondió. ");
INSERT INTO spavbl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“¡Yo soy Dios, el Dios de tu padre! No temas ir a Egipto, porque te convertiré a ti y a tus descendientes en una gran nación. ");
INSERT INTO spavbl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Iré a Egipto contigo, y prometo traerte de vuelta. Y José personalmente cerrará tus ojos cuando mueras”. ");
INSERT INTO spavbl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Entonces Jacob dejó Beerseba. Sus hijos lo llevaron a él, a sus hijos y a sus esposas a Egipto usando los carros que el Faraón había enviado. ");
INSERT INTO spavbl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","También se llevaron todo su ganado y todas las pertenencias personales que habían acumulado en el país de Canaán. Así pues, Jacob y todos los miembros de su extensa familia fueron a Egipto, ");
INSERT INTO spavbl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","incluyendo todos sus hijos y nietos, hijas y nietas. ");
INSERT INTO spavbl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","La siguiente es la genealogía de Israel y sus hijos que fueron a Egipto: Rubén, el primogénito de Jacob. ");
INSERT INTO spavbl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Los hijos de Rubén: Janoc, Falú, Jezrón y Carmi. ");
INSERT INTO spavbl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Los hijos de Simeón: Jemuel, Jamín, Ohad, Jachín, Zojar y Saúl, hijo de una mujer cananea. ");
INSERT INTO spavbl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Los hijos de Leví: Gersón, Coat y Merari. ");
INSERT INTO spavbl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Los hijos de Judá: Onán, Selá, Fares y Zera. Sin embargo, Er y Onán murieron en Canaán. Los hijos de Fares: Hezrón y Hamul. ");
INSERT INTO spavbl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Los hijos de Isacar: Tola, Fuvá, Job, y Simrón. ");
INSERT INTO spavbl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Los hijos de Zabulón: Séred, Elón y Yalel. ");
INSERT INTO spavbl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Estos son los hijos que Lea tuvo para Jacob en Padán Harán, así como su hija Dina. El número total de hijos e hijas y nietos fue de treinta y tres. ");
INSERT INTO spavbl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Los hijos de Gad: Zefón, Jaguí, Suni, Esbón, Erí, Arodí y Arelí. ");
INSERT INTO spavbl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Los hijos de Aser: Imná, Isvá, Isví, Beriá, y su hermana Sera. Los hijos de Beriá: Heber y Malquiel. ");
INSERT INTO spavbl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Estos son los hijos que Jacob tuvo con Zilpá, la sierva dada por Labán a su hija Lea. Fue en total dieciséis hijos y nietos. ");
INSERT INTO spavbl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Los hijos de la esposa de Jacob, Raquel: José y Benjamín. ");
INSERT INTO spavbl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Los hijos que José tuvo en la tierra de Egipto con Asenat, hija de Potifera, sacerdote de On: Manasés y Efraín. ");
INSERT INTO spavbl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Los hijos de Benjamín: Bela, Béquer, Asbel, Guerá, Naamán, Ehí, Ros, Mupín, Jupín y Ard. ");
INSERT INTO spavbl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Estos son los hijos que Raquel tuvo con Jacob, y fueron en total catorce hijos y nietos. ");
INSERT INTO spavbl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","El hijo de Dan: Jusín. ");
INSERT INTO spavbl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Los hijos de Neftalí: Yasel, Guní, Jéser y Silén. ");
INSERT INTO spavbl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Estos son los hijos que Jacob tuvo con Bilhá, la sierva dada por Labán para su hija Raquel. Fue un total de siete hijos y nietos. ");
INSERT INTO spavbl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Todos los que formaban parte de la familia de Jacob que vinieron a Egipto (sus parientes de sangre, aparte de las esposas de los hijos de Jacob) sumaban un total de sesenta y seis. ");
INSERT INTO spavbl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Incluyendo los dos hijos que José tuvo en Egipto, el número total de la familia de Jacob que se encontraba en Egipto era de setenta. ");
INSERT INTO spavbl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob envió a Judá por delante para que se reuniera con José y averiguara el camino a Gosén. Cuando llegaron a Gosén, ");
INSERT INTO spavbl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José ordenó que prepararan su carro y fue a encontrarse allí con su padre Israel. Tan pronto como llegó, abrazó a su padre y lloró por mucho tiempo. ");
INSERT INTO spavbl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","“Ahora puedo morir en paz porque he visto tu rostro de nuevo y sé que sigues vivo”, le dijo Israel a José. ");
INSERT INTO spavbl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","José dijo a sus hermanos y a la familia de su padre: “Voy a ir a informar al Faraón y a decirle: ‘Mis hermanos y la familia de mi padre han llegado del país de Canaán para unirse a mí. ");
INSERT INTO spavbl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Son pastores y tienen ganado. Han traído con ellos sus rebaños y manadas y todas sus posesiones’. ");
INSERT INTO spavbl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","“Cuando el Faraón los llame y les pregunte: ‘¿Qué trabajo hacen ustedes?’ ");
INSERT INTO spavbl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","díganle: ‘Tus siervos han cuidado ganado desde que éramos niños, tanto nosotros como nuestros padres antes que nosotros’. Así podrán vivir aquí en Gosén, porque los egipcios desprecian a los pastores”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","José fue a informar al faraón y le dijo: “Mi padre y mis hermanos, junto con sus rebaños y manadas y todas sus posesiones, han llegado de la tierra de Canaán y ahora están aquí en Gosén”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","José tomó a cinco de sus hermanos para que lo acompañaran y se los presentó al Faraón. ");
INSERT INTO spavbl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","El faraón les preguntó a los hermanos: “¿Qué trabajo hacen ustedes?” “Nosotros, sus siervos, somos pastores, como nuestros padres antes que nosotros”, respondieron ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","“Hemos venido a vivir a Egipto porque no queda hierba en Canaán para que nuestros rebaños coman”, explicaron. “La hambruna es muy grave en Canaán. Así que nos gustaría pedir permiso para vivir en Gosén”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","El faraón le dijo a José: “Ahora que tu padre y tus hermanos han llegado para unirse a ti, ");
INSERT INTO spavbl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","puedes elegir el lugar que quieras en Egipto, el mejor lugar, para que ellos vivan. Déjalos vivir en Gosén. Si conoces a alguno de ellos que sea bueno en lo que hace, ponlo también a cargo de mi ganado”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Entonces José fue con su padre Jacob y le presentó al faraón. Después de que Jacob bendijera al faraón, ");
INSERT INTO spavbl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","el faraón le preguntó: “¿Cuánto tiempo has vivido?” ");
INSERT INTO spavbl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","“He estado andando de aquí para allá durante 130 años”, respondió Jacob. “Mi vida ha sido corta y difícil; no he vivido tanto como mis antepasados que también vagaban de un lugar a otro”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Entonces Jacob bendijo de nuevo al faraón antes de dejarlo. ");
INSERT INTO spavbl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Entonces José dispuso que su padre y sus hermanos vivieran en Egipto y les dio tierra en la mejor parte, cerca de Ramsés, como el Faraón lo había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","También les proporcionó alimentos a todos ellos: a su padre, a sus hermanos y a toda la familia de su padre, según el tamaño de cada familia. ");
INSERT INTO spavbl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","No quedaba comida en todo el país porque la hambruna se había vuelto muy grave. A lo largo de Egipto y Canaán la gente se moría de hambre. ");
INSERT INTO spavbl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Mediante la venta de grano, José recogió todo el dinero en Egipto y Canaán, y lo colocó en el tesoro del Faraón. ");
INSERT INTO spavbl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Una vez que el dinero de Egipto y Canaán se había acabado, todos los egipcios vinieron a José y le exigieron: “¡Danos comida! ¿Quieres que muramos delante de ti? ¡Hemos perdido todo nuestro dinero!” ");
INSERT INTO spavbl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","“Tráiganme su ganado”, les dijo José. “Si se han quedado sin dinero, les daré grano a cambio de su ganado”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Así que los egipcios le trajeron a José su ganado, y él les dio grano a cambio de sus caballos, ovejas, cabras, ganado y burros. Durante ese año, José les dio grano a cambio de su ganado. ");
INSERT INTO spavbl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pero cuando terminó ese año, vinieron a él al año siguiente y le dijeron: “Mi señor, no podemos ocultarte el hecho de que nuestro dinero ha desaparecido y que ahora eres dueño de nuestro ganado. Todo lo que nos queda por darte son nuestros cuerpos y nuestra tierra. ");
INSERT INTO spavbl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","¿Quieres que muramos delante de ti? Entonces cómpranos a nosotros y a nuestra tierra a cambio de comida. Entonces nuestra tierra pertenecerá al Faraón, y seremos sus esclavos. Danos grano para que podamos vivir y no muramos, y así la tierra no quedará abandonada”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Así que José compró toda la tierra de Egipto para el Faraón. Todos y cada uno de los egipcios vendieron sus campos, porque la hambruna les estaba haciendo mucho daño. La tierra terminó siendo propiedad del Faraón, ");
INSERT INTO spavbl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","y todo el pueblo se convirtió en esclavos suyos, de un extremo a otro de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","La única tierra que no compró fue la de los sacerdotes porque tenían una asignación de alimentos que les proporcionó el Faraón, así que no tuvieron que vender sus tierras. ");
INSERT INTO spavbl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Entonces José le dijo al pueblo: “¡Escúchenme! Ahora que los he comprado a ustedes y a su tierra para el Faraón, les daré semillas para que siembren los campos. ");
INSERT INTO spavbl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sin embargo, cuando recojan la cosecha, tienen que dar una quinta parte al Faraón. Las otras cuatro quintas partes las podrán guardar como semilla para los campos y como alimento para ustedes mismos, sus hogares y sus hijos”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","“Nos has salvado la vida”, declararon. “Ojalá sigas tratándonos bien, mi señor, y seremos esclavos del Faraón”. ");
INSERT INTO spavbl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Así que José hizo una ley para Egipto, que sigue vigente hoy en día: Que una quinta parte de todos los productos de la tierra pertenecen al Faraón. Sólo la tierra de los sacerdotes estaba exenta ya que no pertenecía al Faraón. ");
INSERT INTO spavbl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Los israelitas se establecieron en Gosén, en Egipto, donde se convirtieron en prósperos terratenientes y aumentaron rápidamente en número de habitantes. ");
INSERT INTO spavbl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob vivió en Egipto durante diecisiete años, por lo que vivió en total 147 años. ");
INSERT INTO spavbl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Cuando llegó el momento de su muerte, Israel llamó a su hijo José y le dijo: “Si me consideras, pon tu mano debajo de mi muslo y promete tratarme con amor y fidelidad. No me entierres aquí en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Cuando muera, entiérrame con mis antepasados. Deben llevar mi cuerpo desde Egipto hasta la tumba familiar y enterrarme con ellos”. “Haré lo que tú digas”, prometió José. ");
INSERT INTO spavbl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","“Júrame que lo harás”, dijo. Y José juró que lo haría. Entonces Israel se inclinó en actitud de adoración en la cabecera de su cama. ");
INSERT INTO spavbl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Algún tiempo después de esto, le dijeron a José: “Tu padre está enfermo”. Así que José fue a verlo, llevándose a sus dos hijos Manasés y Efraín. ");
INSERT INTO spavbl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Cuando le dijeron a Jacob: “Tu hijo José ha venido a verte”, reunió sus fuerzas y se sentó en la cama. ");
INSERT INTO spavbl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob le dijo a José: “El Dios Todopoderoso se me apareció en Luz, en el país de Canaán, y me bendijo allí. ");
INSERT INTO spavbl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Me dijo: ‘¡Escucha! Te haré próspero y haré que tu descendencia sea tan numerosa que te convertirás en el antepasado de muchas naciones, y daré esta tierra a tus descendientes para que la posean para siempre’. ");
INSERT INTO spavbl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Cuento como míos a tus dos hijos Efraín y Manasés que nacieron aquí en Egipto antes de que yo llegara, así como Rubén y Simeón son míos. ");
INSERT INTO spavbl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Cualquier otro hijo que tengas después de ellos será tuyo, y compartirás su herencia dentro de la tierra de sus hermanos mayores. ");
INSERT INTO spavbl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Hago esto porque trágicamente para mí, cuando regresaba de Padán Harán, Raquel murió en Canaán, a cierta distancia de Efrata. La enterré allí de camino a Efrata” (también conocida como Belén). ");
INSERT INTO spavbl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel vio a los hijos de José y dijo: “¿Son estos son tus hijos, entonces?” ");
INSERT INTO spavbl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","“Sí, estos son los hijos que Dios me dio aquí”, le dijo José a su padre. “Tráelos aquí para que pueda bendecirlos”, dijo. ");
INSERT INTO spavbl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","La vista de Israel estaba fallando debido a su edad y no podía ver bien, así que José los acercó a su padre, y él los besó y los abrazó. ");
INSERT INTO spavbl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Entonces Israel le dijo a José: “Nunca pensé que volvería a ver tu cara, y ahora Dios me ha dejado ver a tus hijos”. ");
INSERT INTO spavbl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","José tomó a sus hijos de entre las rodillas de Israel, y se inclinó con el rostro hacia el suelo. ");
INSERT INTO spavbl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Entonces José puso a Efraín a su derecha para que estuviera a la izquierda de Israel, y a Manasés a su izquierda para que estuviera a la derecha de Israel, y luego los trajo a Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pero cuando Israel extendió sus manos, las cruzó y colocó su mano derecha sobre Efraín, el hijo menor, y colocó la izquierda sobre Manasés, el primogénito. ");
INSERT INTO spavbl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Bendijo a José, diciendo: “Que el Dios que mi abuelo Abraham y mi padre adoraron, el Dios que me ha cuidado como un pastor a lo largo de mi vida hasta ahora, ");
INSERT INTO spavbl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","el Ángel que me ha salvado de todo tipo de problemas, bendiga a estos muchachos. Que mi nombre y los nombres de mi abuelo Abraham y de mi padre Isaac continúen a través de ellos, y que tengan muchos descendientes que se extiendan por toda la tierra”. ");
INSERT INTO spavbl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","José se sintió infeliz cuando vio que su padre había puesto su mano derecha sobre Efraín, así que tomó la mano de su padre para tratar de moverla de la cabeza de Efraín a la de Manasés. ");
INSERT INTO spavbl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“Así no, padre, este es el primogénito; pon tu mano derecha sobre su cabeza”, le dijo José. ");
INSERT INTO spavbl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pero su padre se negó, diciendo: “Yo sé lo que hago. Manasés también se convertirá en un pueblo importante, pero su hermano menor será más grande que él, y sus descendientes se convertirán en una gran nación”. ");
INSERT INTO spavbl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Así que Israel los bendijo ese día y dijo: “En el futuro, el pueblo de Israel usará sus nombres para dar una bendición, diciendo: ‘Que Dios los bendiga como lo hizo con Efraín y Manasés’”. Al decir esto, puso a Efraín antes que a Manasés. ");
INSERT INTO spavbl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Entonces Israel dijo a José: “Voy a morir pronto, pero Dios estará con ustedes y los devolverá a la tierra de sus padres. ");
INSERT INTO spavbl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","También te doy algo además de lo que le doy a tus hermanos: un trozo de tierra en la ladera de la montaña de Siquem que le quité a los amorreos con mi espada y mi arco”. ");
INSERT INTO spavbl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob entonces llamó a sus hijos y les dijo: “Reúnanse para que pueda decirles lo que les va a pasar en el futuro. ");
INSERT INTO spavbl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Vengan aquí, hijos de Jacob, y escuchen a su padre Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubén: Tú eres mi primogénito, concebido cuando era fuerte, nacido cuando era vigoroso. Estuviste por encima de todos los demás en posición y en poder. ");
INSERT INTO spavbl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Pero tú hierves como el agua, así que ya no estarás más por encima de nadie, porque fuiste y te acostaste con mi concubina; violaste mi lecho matrimonial. ");
INSERT INTO spavbl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeón y Levi son dos de la misma clase, usan sus armas para la violencia destructiva. ");
INSERT INTO spavbl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Me niego a ser parte de sus decisiones; me niego a participar en lo que hacen. Porque mataron a los hombres en su ira; lisiaron al ganado sólo por diversión. ");
INSERT INTO spavbl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maldigo su ira porque es demasiado dura; maldigo su furia porque es demasiado cruel. Separaré a sus descendientes a través de Jacob; los dispersaré por todo Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judá: tus hermanos te alabarán. Derrotarás a tus enemigos. Los hijos de tu padre se inclinarán ante ti en señal de respeto. ");
INSERT INTO spavbl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Mi hijo Judá es un joven león que vuelve después de comersea su presa. Se agacha y se acuesta como un león. Así como un león, ¿quién se atrevería a molestarlo? ");
INSERT INTO spavbl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judá siempre sostendrá el cetro, y el bastón de la autoridad estará siempre a sus pies hasta que venga Siloé; las naciones le obedecerán. ");
INSERT INTO spavbl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ata su asno a la vid, y el potro de su asno a la mejor vid. Lava sus ropas en vino, sus túnicas en el jugo rojo de las uvas. ");
INSERT INTO spavbl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Sus ojos brillan más que el vino, y sus dientes son más blancos que la leche. ");
INSERT INTO spavbl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabulón vivirá a la orilla del mar y será un puerto para los barcos; su territorio se extenderá hacia Sidón. ");
INSERT INTO spavbl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isacar es un asno fuerte, acostado entre dos alforjas. ");
INSERT INTO spavbl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ve que el lugar donde descansa es bueno, y la tierra es encantadora, por lo que está dispuesto a inclinar la espalda para aceptar la carga y trabajar como esclavo. ");
INSERT INTO spavbl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan juzgará a su pueblo como una de las tribus de Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan será tan peligroso como una serpiente al lado del camino, una víbora por el sendero que muerde el talón del caballo, haciendo caer a su jinete de espaldas. ");
INSERT INTO spavbl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Confío en ti para que me salves, Señor. ");
INSERT INTO spavbl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Los jinetes atacarán a Gad, pero él atacará sus talones. ");
INSERT INTO spavbl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aser tendrá una comida deliciosa, producirá comida de lujo para la realeza. ");
INSERT INTO spavbl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Neftalí es un ciervo que puede correr libremente; da a luz a hermosos cervatillos. ");
INSERT INTO spavbl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“José es un árbol fructífero, un árbol fructífero al lado de un manantial, cuyas ramas trepan por la pared. ");
INSERT INTO spavbl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Los arqueros lo atacaron vilmente; le dispararon sus flechas con odio. ");
INSERT INTO spavbl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pero él mantuvo su arco firme, y sus brazos y manos se movieron rápidamente con la fuerza del Poderoso de Jacob, que se llama el Pastor, la Roca de Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","El Dios de tu padre te ayudará y el Todopoderoso te bendecirá con bendiciones de los cielos de arriba, con bendiciones de las profundidades abajo, con bendiciones para muchos hijos. ");
INSERT INTO spavbl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Las bendiciones que recibió tu padre fueron mayores que las bendiciones de sus antepasados, más que las bendiciones de las montañas eternas. Que estén sobre la cabeza de José, en la frente del que se apartó como líder de sus hermanos. ");
INSERT INTO spavbl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamín es un lobo feroz. Por la mañana destruye a sus enemigos, por la tarde divide el botín”. ");
INSERT INTO spavbl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Estas son todas las doce tribus de Israel, y esto es lo que les dijo su padre al bendecirlas, cada una según sus respectivas bendiciones. ");
INSERT INTO spavbl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Luego les dio las siguientes instrucciones: “Voy a morir pronto. Entiérrenme con mis antepasados en la cueva que está en el campo de Efrón el hitita. ");
INSERT INTO spavbl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Esta es la cueva que está en el campo de Macpela, cerca de Mamré, en Canaán, y que Abraham compró junto con el campo de Efrón el Hitita para tenerlo como lugar de sepultura. ");
INSERT INTO spavbl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham y su esposa Sara fueron enterrados allí, Isaac y su esposa Rebeca fueron enterrados allí, y yo enterré a Lea allí. ");
INSERT INTO spavbl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","El campo y la cueva fueron comprados a los hititas”. ");
INSERT INTO spavbl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Cuando Jacob terminó de dar estas instrucciones levantó los pies en el lecho, respiró por última vez y se unió a sus antepasados en la muerte. ");
INSERT INTO spavbl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","José fue y abrazó a su padre, llorando sobre él y besándolo. ");
INSERT INTO spavbl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Luego José instruyó a los médicos que trabajaban para él que embalsamaran el cuerpo de su padre. Así que los médicos embalsamaron a Israel. ");
INSERT INTO spavbl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Esto tomó 40 días, el tiempo normal para el proceso, y los egipcios lloraron por él durante 70 días. ");
INSERT INTO spavbl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Una vez terminado el tiempo de luto, José dijo a los oficiales del Faraón: “Si son tan amables, por favor hablen con el Faraón en mi nombre y explíquenle que ");
INSERT INTO spavbl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","mi padre me hizo hacer un juramento, diciéndome: ‘Debes enterrarme en la tumba que he preparado para mí en Canaán’. Por favor, permíteme ir a enterrar a mi padre y luego volveré”. ");
INSERT INTO spavbl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","El Faraón respondió: “Ve y entierra a tu padre como te hizo jurar”. ");
INSERT INTO spavbl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","José fue a enterrar a su padre, y todos los oficiales del Faraón fueron con él, todos los consejeros principales del Faraón y todos los líderes de Egipto, ");
INSERT INTO spavbl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","así como la familia de José, sus hermanos y la familia de su padre. Sólo dejaron a los niños pequeños y sus rebaños y manadas en Gosén. ");
INSERT INTO spavbl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Fueron acompañados por carros y jinetes, una procesión muy grande. ");
INSERT INTO spavbl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Cuando llegaron a la era de Atad, al otro lado del Jordán, lloraron con gritos de dolor. José celebró una ceremonia de siete días de luto por su padre allí. ");
INSERT INTO spavbl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Los cananeos que vivían allí vieron la ceremonia de duelo en la era de Atad. Dijeron: “Este es un momento muy triste de luto para los egipcios”, así que rebautizaron el lugar como Abel-Mizraim, que está al otro lado del Jordán. ");
INSERT INTO spavbl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Los hijos de Jacob hicieron lo que él les había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Llevaron su cuerpo a Canaán y lo enterraron en la cueva de Macpela, en el campo cerca de Mamre, el cual Abraham le había comprado a Efrón el hitita como lugar de sepultura. ");
INSERT INTO spavbl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Después de enterrar a su padre, José y sus hermanos regresaron a Egipto junto con todos los que habían ido con ellos. ");
INSERT INTO spavbl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Sin embargo, ahora que su padre había muerto, los hermanos de José se preocuparon diciendo: “Tal vez José nos guarde rencor y nos pague por todas las cosas malas que le hicimos”. ");
INSERT INTO spavbl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Así que enviaron un mensaje a José para decirle: “Antes de que tu padre muriera, dio esta orden, ");
INSERT INTO spavbl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Esto es lo que debes decirle a José: Perdona a tus hermanos sus pecados, las cosas malas que te hicieron, tratándote de una manera tan desagradable’. Ahora, por favor, perdona nuestros pecados, nosotros que somos siervos del Dios de tu padre”. Cuando José recibió el mensaje, lloró. ");
INSERT INTO spavbl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Entonces sus hermanos vinieron y se postraron ante José y le dijeron: “¡Somos tus esclavos!” ");
INSERT INTO spavbl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","“¡No necesitan tener miedo!” les dijo. “No me pongo en el lugar de Dios, ¿verdad? ");
INSERT INTO spavbl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Aunque ustedes conspiraron cosas malas para mí, Dios planeó para el bien, a fin de que muchas vidas pudieran ser salvadas. ");
INSERT INTO spavbl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Así que no se preocupen. Seguiré cuidando de ustedes y de sus hijos”. Hablando amablemente así los calmó. ");
INSERT INTO spavbl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Y José permaneció en Egipto, junto con toda la familia de su padre. Vivió hasta los 110 años, ");
INSERT INTO spavbl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","y vio tres generaciones de su hijo Efraín, y los hijos de Maquir, el hijo de Manasés, fueron puestos en su regazo cuando nacieron. ");
INSERT INTO spavbl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","“Voy a morir pronto”, les dijo José a sus hermanos, “pero Dios estará con ustedes, y los llevará fuera de este país a la tierra que juró dar a Abraham, Isaac y Jacob”. ");
INSERT INTO spavbl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","José hizo jurar a los hijos de Israel, diciendo: “Cuando Dios venga a estar con ustedes, deben llevarse mis huesos cuando se vayan”. ");
INSERT INTO spavbl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","José murió cuando tenía 110 años. Después de que su cuerpo fue embalsamado, fue colocado en un ataúd en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Estos fueron los nombres de los hijos de Israel (Jacob) que vinieron con él y sus familias a Egipto: ");
INSERT INTO spavbl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví y Judá; ");
INSERT INTO spavbl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón y Benjamín; ");
INSERT INTO spavbl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan y Neftalí, Gad y Aser. ");
INSERT INTO spavbl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Allí Jacob tuvo 70 descendientes, incluyendo a José, que ya estaba en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Finalmente José, todos sus hermanos, y toda esa generación murieron. ");
INSERT INTO spavbl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Sin embargo, los israelitas tenían muchos hijos y su número aumentaba rápidamente. De hecho, eran tantos que se volvieron muy poderosos, y el país estaba lleno de ellos. ");
INSERT INTO spavbl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Entonces subió al poder un nuevo rey que no tenía ningún conocimiento acerca de José. ");
INSERT INTO spavbl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Este rey se reunió con sus compatriotas egipcios y les dijo: “Debemos tener cuidado con estos israelitas, pues son más numerosos y más poderosos que nosotros. ");
INSERT INTO spavbl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tenemos que hacer un plan para evitar que sigan multiplicándose, porque que si llega a haber una guerra, se pondrán del lado de nuestros enemigos, lucharán contra nosotros, y huirán del país”. ");
INSERT INTO spavbl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Entonceslos egipcios comenzaron a obligarlos a hacer trabajos forzados y asignaron capataces para que estuvieran a cargo de ellos. Los usaron para construir las ciudades de almacenamiento de Pitón y Ramsés. ");
INSERT INTO spavbl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero cuanto más maltrataban a los israelitas, más se multiplicaban y se extendían, y también los egipcios los detestaban aún más. ");
INSERT INTO spavbl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Los egipcios trataban a los israelitas con violencia, ");
INSERT INTO spavbl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","haciendo de sus vidas una miseria. Los obligaban a hacer trabajos duros, construyendo con mortero y ladrillos, y haciendo todo tipo de trabajo pesado en los campos. Y en medio de todo este trabajo duro los trataban con crueldad. ");
INSERT INTO spavbl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Entonces el rey les dio órdenes a las parteras hebreas Sifra y Fúa. ");
INSERT INTO spavbl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Y les dijo: “Cuando ayuden a las mujeres hebreas durante el parto, si ven que es un niño, mátenlo; pero si es una niña, déjenla vivir”. ");
INSERT INTO spavbl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pero como las parteras respetaban a Dios, no hicieron lo que el rey de Egipto les había ordenado, sino que dejaban vivir a los niños también. ");
INSERT INTO spavbl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Entonces el rey de Egipto llamó a las parteras y les preguntó: “¿Por qué han hecho esto, y han dejado vivir a los niños varones?” ");
INSERT INTO spavbl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","“Las mujeres hebreas no son como las egipcias”, le dijeron las parteras al Faraón. “Dan a luz más fácilmente, y tienen a sus hijos antes de que lleguen las parteras”. ");
INSERT INTO spavbl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Y Dios trató bien a las parteras, y el pueblo aumentó en número, así que había aún muchos más de ellos. ");
INSERT INTO spavbl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Y como las parteras reverenciaban a Dios, él les dio familias propias. ");
INSERT INTO spavbl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Entonces el Faraón emitió esta orden a todo su pueblo: “Arrojen al Nilo a todo niño hebreo que nazca, y por el contrario, dejen vivir a las niñas”. ");
INSERT INTO spavbl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Fue en esa época que un hombre de la tribu de Leví se casó con una mujer que también era levita. ");
INSERT INTO spavbl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ella quedó embarazada y tuvo un hijo. Y viendo que era un bebé precioso, lo escondió durante tres meses. ");
INSERT INTO spavbl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pero cuando ya no pudo esconderlo más, cogió una cesta de papiro y la cubrió con alquitrán. Luego puso a su bebé en la cesta y lo colocó entre los juncos, a lo largo de la orilla del Nilo. ");
INSERT INTO spavbl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Y la hermana del niño esperaba a cierta distancia, vigilándolo. ");
INSERT INTO spavbl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Entonces la hija del Faraón llegó para bañarse en el Nilo. Sus criadas caminaban por la orilla del río, y cuando ella vio la cesta entre los juncos, envió a su criada a buscarla y traérsela. ");
INSERT INTO spavbl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Al abrirla, vio al niño que lloraba y sintió pesar por él. “Este debe ser uno de los niños hebreos”, dijo. ");
INSERT INTO spavbl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Entoncesla hermana del niño le preguntó a la hija del Faraón: “¿Desea que vaya a buscar a una de las mujeres hebreas para que lo cuide por usted?” ");
INSERT INTO spavbl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Sí, ve y hazlo”, respondió ella. Así que la niña fue y llamó a la madre del bebé para que viniera. ");
INSERT INTO spavbl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","“Toma a este niño y amamántalo por mí”, le dijo la hija del Faraóna la madre del niño. “Yo misma te pagaré”. Así que su madre se lo llevó a casa y lo cuidó. ");
INSERT INTO spavbl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Cuando el niño creció, se lo llevó a la hija del Faraón, quien lo adoptó como su hijo. Ella lo llamó Moisés, porque dijo: “Yo lo saqué del agua”. ");
INSERT INTO spavbl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Más tarde, cuando Moisés había crecido, fue a visitar a su pueblo, los hebreos. Los vio haciendo trabajos forzados. También vio a un egipcio golpeando a un hebreo, uno de su propio pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Entonces miró a su alrededor para asegurarse de que nadie estuviera mirando, yluego mató al egipcio y enterró su cuerpo en la arena. ");
INSERT INTO spavbl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Al día siguiente, regresó y vio a dos hebreos peleando entre sí. Entonces le dijo al culpable: “¿Por qué golpeas a uno de los tuyos?” ");
INSERT INTO spavbl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","“¿Quién te ha encargado como juez sobre nosotros?” , respondió el hombre. “¿Acaso vas a matarme como lo hiciste con el egipcio?” Entonces Moisés se asustó por esto y pensó para sí: “¡La gente sabe lo que he hecho!” ");
INSERT INTO spavbl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Cuando el Faraón se enteró, trató de mandar a matar a Moisés, pero Moisés huyó del Faraón y se fue a vivir a Madián. Un día, mientras estaba sentado junto a un pozo, ");
INSERT INTO spavbl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","las siete hijas del sacerdote de Madiánvinieron a buscar agua para llenar los bebederos a fin de que el rebaño de su padre pudiera beber. ");
INSERT INTO spavbl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Entonces llegaron unos pastores y las echaron de allí, pero Moisés intervino y las puso a salvo, y le dio de beber a su rebaño. ");
INSERT INTO spavbl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Cuando llegaron a casa, su padre Reuel les preguntó: “¿Cómo es que hoy han regresado tan rápido?” ");
INSERT INTO spavbl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","“Un egipcio nos rescató de unos pastores que nos atacaron”, respondieron. “Incluso nos trajo agua para que el rebaño pudiera beber”. ");
INSERT INTO spavbl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","“¿Y dónde está?” le preguntó Reuel a su hija. “No lo dejaste allí, ¿verdad? ¡Ve e invítalo a comer con nosotros!” ");
INSERT INTO spavbl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Y Moisés aceptó quedarse con el hombre, quien arregló que su hija Séfora se casara con Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ella tuvo un hijo y Moisés le puso el nombre de Gersón, porque dijo: “Soy un exiliado que vive en un país extranjero”. ");
INSERT INTO spavbl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Años más tarde, el rey de Egipto murió. Pero los israelitas seguían quejándose por su duro trabajo. Su clamor pidiendo ayuda en medio de sus dificultades llegó hasta Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dios escuchó sus gemidos y se acordó de su pacto con Abraham, Isaac, y Jacob. ");
INSERT INTO spavbl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Además Dios miraba con compasión a los israelitas, y se preocupaba por ellos. ");
INSERT INTO spavbl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moisés era un pastor que cuidaba el rebaño de Jetro, su suegro, el sacerdote de Madián. Condujo el rebaño lejos en el desierto hasta que llegó al monte de Dios, el monte Horeb. ");
INSERT INTO spavbl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Allí el ángel del Señor se le apareció en una llama de fuego desde dentro de un arbusto. Moisés miró con atención y vio que, aunque la zarza estaba ardiendo, no se estaba quemando. ");
INSERT INTO spavbl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","“Iré a echar un vistazo”, se dijo a sí mismo Moisés. “Es muy extraño ver un arbusto que no se queme”. ");
INSERT INTO spavbl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Cuando el Señor vio que Moisés venía a echar un vistazo, Dios le llamó desde dentro de la zarza: “¡Moisés! ¡Moisés!” “Aquí estoy”, respondió Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“¡No te acerques más!” le dijo Dios. “Quítate las sandalias porque estás parado en tierra sagrada”. ");
INSERT INTO spavbl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Luego dijo: “Soy el Dios de tu padre, el Dios de Abraham, el Dios de Isaac y el Dios de Jacob”. Moisés se cubrió el rostro, porque tuvo miedo de mirar a Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","“Soyplenamente consciente de la miseria de mi pueblo en Egipto”, le dijo el Señor. “Los he escuchado gemir por culpa de sus capataces. Sé cuánto están sufriendo. ");
INSERT INTO spavbl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Por eso he descendido para rescatarlos de la opresión egipcia y para llevarlos desde ese país a una tierra fértil y amplia, una tierra donde fluye leche y miel, donde actualmente viven los cananeos, los hititas, los amorreos, los ferezeos, los heveos y los jebuseos. ");
INSERT INTO spavbl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Escucha ahora: El clamor de los israelitas ha llegado hasta mí, y he visto cómo los egipcios los maltratan. ");
INSERT INTO spavbl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ahora debes irte, porque yo te envío donde el Faraón para que saques a mi pueblo Israel de Egipto”. ");
INSERT INTO spavbl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Pero Moisés le dijo a Dios: “¿Por qué yo? ¡Yo soy un don nadie! ¡No podré ir ante el Faraón y sacar a los israelitas de Egipto!” ");
INSERT INTO spavbl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","“Yo estaré contigo”, respondió el Señor, “y esta será la señal de que soy yo quien te envía: cuando hayas sacado al pueblo de Egipto, adorarás a Dios en este mismo monte”. ");
INSERT INTO spavbl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Entonces Moisés dijo a Dios: “Mira, si yo fuera donde los israelitas y les dijera: ‘El Dios de sus padres me ha enviado a ustedes’, y ellos me preguntaran: ‘¿Cómo se llama?’, ¿qué les diré entonces?” . ");
INSERT INTO spavbl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Dios le respondió a Moisés: “‘Yo soy’ el que soy. Dile esto a los israelitas: ‘Yo soy’ me ha enviado a ustedes”. ");
INSERT INTO spavbl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Entonces Dios le dijo a Moisés: “Diles a los israelitas: ‘El Señor, el Dios de sus padres, el Dios de Abraham, el Dios de Isaac y el Dios de Jacob, me ha enviado a ustedes. Este es mi nombre para siempre, el nombre con el que me llamarás en todas las generaciones futuras’. ");
INSERT INTO spavbl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Ve y llama a todos los ancianos de Israel para que se reúnan contigo. Diles: ‘El Señor, el Dios de tus padres, se me ha aparecido, el Dios de Abraham, Isaac y Jacob. Él dijo: He prestado mucha atención a lo que te ha pasado en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","He decidido sacarlos de la miseria que están teniendo en Egipto y llevarlos a la tierra de los cananeos, hititas, amorreos, ferezeos, heveos y jebuseos, una tierra que fluye leche y miel’”. ");
INSERT INTO spavbl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Los ancianos de Israel aceptarán lo que tú digas. Entonces debes ir con ellos al rey de Egipto y decirle: ‘El Señor, el Dios de los hebreos se nos ha revelado. Así que, por favor, hagamos un viaje de tres días al desierto para poder ofrecer sacrificios al Señor nuestro Dios allí’. ");
INSERT INTO spavbl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pero sé que el rey de Egipto no te dejará ir a menos que se vea obligado a hacerlo por un poder más fuerte que él. ");
INSERT INTO spavbl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Así que usaré mi poder para infligir a Egipto todas las cosas aterradoras que estoy a punto de hacerles. Después de eso los dejará ir. ");
INSERT INTO spavbl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Haré que los egipcios los traten bien como pueblo, para que cuando se vayan, no se vayan con las manos vacías. ");
INSERT INTO spavbl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Toda mujer pedirá joyas y ropa de plata y oro a su vecina y a toda mujer que viva en su casa, y se las pondrá a sus hijos e hijas. De esta manera se llevarán la riqueza de los egipcios con ustedes”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","“Pero, ¿qué pasa si no me creen o no escuchan lo que digo?” Preguntó Moisés. “Podrían decir: ‘El Señor no se te apareció’”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","El Señor le preguntó: “¿Qué tienes en la mano?” “Un bastón”, respondió Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","“Tíralo al suelo”, le dijo a Moisés. Así lo hizo Moisés. Se transformó en una serpiente y Moisés huía de ella. ");
INSERT INTO spavbl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","“Ahora extiende la mano y agárrala por la cola”, le dijo el Señor a Moisés. Moisés lo hizo y se convirtió en un bastón en su mano. ");
INSERT INTO spavbl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Debes hacer esto para que crean que yo, el Señor, me aparecí delante de ti. E Dios de sus padres, el Dios de Abraham, Isaac y Jacob”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","El Señor le dijo: “Pon tu mano dentro de tus ropas cerca de tu pecho”. Así que Moisés hizo lo que se le dijo. Cuando sacó su mano, estaba blanca como la nieve, con una enfermedad de la piel. ");
INSERT INTO spavbl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“Vuelve a meter la mano dentro de tu ropa”, dijo el Señor. Y Moisés lo hizo. Cuando la sacó de nuevo, su mano había vuelto a la normalidad. ");
INSERT INTO spavbl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Si no te creen y no les convence la primera señal, creerán por la segunda señal”, explicó el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","“Pero si todavía no te creen o no te escuchan debido a estos dos signos, entonces debes tomar un poco de agua del Nilo y ponerla en el suelo. El agua del Nilo se convertirá en sangre en el suelo”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Entonces Moisés dijo al Señor: “Discúlpame, pero no soy bueno con las palabras, ni lo he sido en el pasado, ni desde que comenzaste a hablar conmigo, tu siervo. Soy de hablar lento y no digo las cosas bien”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","“¿Quién le dio la boca a la gente?” le preguntó el Señor. “¿Quién hace a la gente sorda o muda, capaz de ver o ciega? Soy yo, el Señor, quien lo hace. ");
INSERT INTO spavbl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ahora ve, y yo mismo seré tu boca, y te diré lo que debes decir”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","“Por favor, Señor, ¡envía a otra persona!” respondió Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","El Señor se enojó con Moisés y le dijo: “Ahí está tu hermano Aarón, el levita. Sé que habla bien. Viene camino para encontrarse contigo y se alegrará mucho de verte. ");
INSERT INTO spavbl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Habla con él y dile qué decir. Yo seré tu boca y la suya, y te diré lo que debes hacer. ");
INSERT INTO spavbl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aarón hablará en tu nombre al pueblo, como si fuera tu boca, y tú estarás en el lugar de Dios para él. ");
INSERT INTO spavbl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Asegúrate de llevar tu bastón contigo para que puedas usarlo para hacer la señales”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Entonces Moisés regresó donde Jetro su suegro y le dijo: “Por favor, permíteme volver con mi propio pueblo en Egipto para ver si alguno de ellos sigue vivo”. “Ve con mi bendición”, respondió Jetro. ");
INSERT INTO spavbl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mientras Moisés estaba en Madián, el Señor le dijo: “Vuelve a Egipto porque todos los que querían matarte han muerto”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moisés puso a su esposa e hijos sobre un asno y regresó a Egipto, llevando el bastón que Dios había usado para hacer milagros. ");
INSERT INTO spavbl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","El Señor le dijo a Moisés: “Cuando regreses a Egipto, asegúrate de ir al Faraón y realizar los milagros que te he enseñado para que los hagas. Lo volveré terco y no dejará ir al pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Pero esto es lo que debes decirle al Faraón: ‘Esto es lo que dice el Señor: Israel es mi hijo primogénito. ");
INSERT INTO spavbl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Te ordené que dejaras ir a mi hijo para que pueda adorarme. Pero te negaste a liberarlo, así que ahora mataré a tu hijo primogénito’”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Pero mientras iban de camino, el Señor llegó al lugar donde se encontraban, queriendo matar a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sin embargo, Séfora usó un cuchillo de pedernal para cortar el prepucio de su hijo. Le tocó los pies con él y le dijo: “Para mí eres un marido de sangre”. ");
INSERT INTO spavbl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","(Llamarlo marido de sangre se refiere a la circuncisión). Después de esto el Señor dejó a Moisés tranquilo. ");
INSERT INTO spavbl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","El Señor le había dicho a Aarón: “Ve a encontrarte con Moisés en el desierto”. Así que Aarón fue y se encontró con Moisés en el monte de Dios y lo saludó con un beso. ");
INSERT INTO spavbl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Entonces Moisés le explicó a Aarón todo lo que el Señor le había mandado a decir, y todos los milagros que le había ordenado hacer. ");
INSERT INTO spavbl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moisés y Aarón viajaron a Egipto. Allí reunieron a todos los ancianos israelitas. ");
INSERT INTO spavbl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aarón compartió con ellos todo lo que el Señor le había dicho a Moisés, y Moisés realizó los milagros para que pudieran verlos. ");
INSERT INTO spavbl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Los israelitas estaban convencidos. Cuando oyeron que el Señor había venido a ellos, y que había sido tocado por su sufrimiento, inclinaron sus cabezas y adoraron. ");
INSERT INTO spavbl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Después de esto, Moisés y Aarón fueron donde el Faraón y le dijeron: “Esto es lo que el Señor, el Dios de Israel dice: ‘deja ir a mi pueblo para que me haga una fiesta religiosa en el desierto’”. ");
INSERT INTO spavbl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","“¿Quién es este ‘Señor’ para que yo escuche su petición de dejar ir a Israel?” respondió El Faraón. “¡No conozco al Señor y ciertamente no dejaré que Israel se vaya!” ");
INSERT INTO spavbl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","“El Dios de los hebreos vino a nosotros”, añadieron. “Por favor, permítenos hacer un viaje de tres días al desierto y ofrecer sacrificios al Señor nuestro Dios. De lo contrario nos matará por enfermedad o por espada”. ");
INSERT INTO spavbl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","“Moisés y Aarón, ¿por qué intentan distraer al pueblo de su trabajo?” Preguntó el Faraón. “¡Vuelvan a su trabajo!” ordenó. ");
INSERT INTO spavbl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","“Mira aquí”, continuó. “Hay mucha gente tuya aquí en nuestro país y estás impidiendo que hagan el trabajo que se les ha asignado”. ");
INSERT INTO spavbl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ese mismo día ordenó a los capataces y a los encargados del pueblo: ");
INSERT INTO spavbl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“No les den más paja para hacer ladrillos como antes. Que vayan ellos mismos a recoger la paja. ");
INSERT INTO spavbl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pero que sigan produciendo la misma cantidad de ladrillos que antes. Son un pueblo perezoso, por eso gritan, pidiendo: ‘Por favor, déjanos ir y ofrecer sacrificios a nuestro Dios’. ");
INSERT INTO spavbl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","¡Hagan que su trabajo sea más duro, para que puedan seguir trabajando y no se distraigan con todas estas mentiras!” ");
INSERT INTO spavbl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Así que los capataces salieron y le dijeron al pueblo de Israel: “Esto es lo que el Faraón ha ordenado: ‘No les proveeré más paja. ");
INSERT INTO spavbl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Vayan y recojan la paja donde puedan encontrarla, porque su cuota de trabajo no se reducirá’”. ");
INSERT INTO spavbl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Así que la gente iba por todo Egipto recogiendo rastrojos para la paja. ");
INSERT INTO spavbl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Loscapataces seguían forzándolos, diciendo: “¡Todavía tienen que hacer el mismo trabajo que hacían cuando recibían la paja!” ");
INSERT INTO spavbl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Golpeaban a los supervisores israelitas que ellos habían puesto a cargo, gritándoles: “¿Por qué no han cumplido con su cuota de ladrillos como lo hicieron antes?” ");
INSERT INTO spavbl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Los supervisores israelitas fueron a quejarse al Faraón, diciendo: “¿Por qué nos tratas así a tus siervos? ");
INSERT INTO spavbl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","No nos das nada de paja, pero tus capataces exigen que hagamos ladrillos, ¡y nos golpean! ¡Tu pueblo nos trata mal!” ");
INSERT INTO spavbl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","“¡No, ustedes solo son unos vagos, unos perezosos!” respondió el Faraón. “Por eso siguenrogando: ‘Por favor, déjanos ir y ofrecer sacrificios al Señor’. ");
INSERT INTO spavbl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","¡Ahora salgan de aquí y vayan a trabajar! ¡No se les dará paja, pero aún así tendrán que producir la cuota completa de ladrillos!” ");
INSERT INTO spavbl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Los supervisores israelitas se dieron cuenta de que estaban en problemas cuando les dijeron: “No deben reducir la producción diaria de ladrillos”. ");
INSERT INTO spavbl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Se acercaron a Moisés y Aarón que los esperaban después de su encuentro con el Faraón, ");
INSERT INTO spavbl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","y dijeron: “¡Que el Señor vea lo que han hecho y los juzgue por ello! Han hecho que el Faraón y sus oficiales se enojen con nosotros. ¡Han puesto una espada en sus manos para matarnos!” ");
INSERT INTO spavbl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moisés volvió donde el Señor y se quejó: “¿Por qué le has causado todos estos problemas a tu propio pueblo, Señor? ¿Fue para esto que me enviaste? ");
INSERT INTO spavbl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","“Desde que fui a ver al Faraón para hablar en tu nombre, él ha sido aún más duro con tu pueblo, ¡y no has hecho nada para salvarlo!” ");
INSERT INTO spavbl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Pero el Señor le dijo a Moisés: “Ahora verás lo que le haré al Faraón. Con mi gran fuerza lo obligaré a dejarlos ir; por mi poder los enviará fuera de su país”. ");
INSERT INTO spavbl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dios habló a Moisés y le dijo: “¡Yo soy Yahvé! ");
INSERT INTO spavbl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Me revelé como Dios Todopoderoso a Abraham, a Isaac y a Jacob, pero ellos no conocían mi nombre, ‘Yahvé’. ");
INSERT INTO spavbl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","También confirmé mi acuerdo solemne con ellos de darles la tierra de Canaán, el país donde vivían como extranjeros. ");
INSERT INTO spavbl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Además he escuchado los gemidos de los israelitas que los egipcios tratan como esclavos, y no he olvidado el acuerdo que les prometí. ");
INSERT INTO spavbl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Así que di a los israelitas: ‘Yo soy el Señor y los salvaré del trabajo forzoso que les imponen los egipcios; yo los liberaré su esclavitud. Los rescataré usando mi poder e imponiendo fuertes castigos. ");
INSERT INTO spavbl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Yo los convertiré en mi propio pueblo. Entonces sabrán que soy el Señor su Dios, que los rescató de la esclavitud en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Los llevaré a la tierra que prometí solemnemente darles a Abraham, Isaac y Jacob. Se las daré y será de ellos. ¡Yo soy el Señor!’” ");
INSERT INTO spavbl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moisés le explicó esto a los israelitas, pero ellos no lo escucharon, porque estaban muy desanimados, y por el duro trabajo que se veían obligados a hacer. ");
INSERT INTO spavbl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ve y habla con el Faraón, rey de Egipto. Dile que deje a los israelitas salir de su país”. ");
INSERT INTO spavbl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pero Moisés respondió: “Ni siquiera mi propio pueblo me escucha. ¿Por qué me escucharía el Faraón, sobre todo si soy tan mal orador?” ");
INSERT INTO spavbl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Pero el Señor les habló a Moisés y a Aarón, y les dijo lo que debían hacer con respecto al pueblo de Israel y con Faraón, rey de Egipto, para sacar a los israelitas de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Estos eran los jefes de la familia de Israel: Los hijos de Rubén, el primogénito de Israel, eran Janoc y Falú, Jezrón y Carmi. Estas fueron las familias de Rubén. ");
INSERT INTO spavbl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Los hijos de Simeón fueron Jemuel, Jamín, Oad, Joaquín, Zojar y Saúl (hijo de una mujer cananea). Estas fueron las familias de Simeón. ");
INSERT INTO spavbl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Estos fueron los nombres de los hijos de Leví según sus registros genealógicos: Gersón, Coat y Merari. Leví vivió durante 137 años. ");
INSERT INTO spavbl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Los hijos de Gersón, por familias, fueron Libní y Simí. ");
INSERT INTO spavbl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Los hijos de Coat fueron Amram, Izar, Hebrón y Uziel. Coat vivió durante 133 años. ");
INSERT INTO spavbl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Los hijos de Merari fueron Majlí y Musí. Estas eran las familias de los levitas según sus registros genealógicos. ");
INSERT INTO spavbl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram se casó con la hermana de su padre, Jocabed, y ella tuvo sus hijos Aarón y Moisés. Amram vivió durante 137 años. ");
INSERT INTO spavbl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Los hijos de Izar fueron Coré, Neferón y Zicrí. ");
INSERT INTO spavbl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Los hijos de Uziel fueron Misael, Elzafán y Sitri. ");
INSERT INTO spavbl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarón se casó con Elisabet, hija de Aminadab y hermana de Nasón. Ella tuvo sus hijos Nadab y Abiú, Eleazar e Itamar. ");
INSERT INTO spavbl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Los hijos de Coré fueron Asir, Elcana y Abiasaf. Estas eran las familias de Coré. ");
INSERT INTO spavbl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, hijo de Aarón, se casó con una de las hijas de Futiel, y tuvo su hijo Finés. Estos son los ancestros de las familias levitas, listados según sus clanes. Eleazar hijo de Aarón se casó con una de las hijas de Futiel, y ella dio a luz a su hijo, Finés. Estos son los jefes de las familias levitas, listados por familia. ");
INSERT INTO spavbl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aarón y Moisés mencionados aquí son los que el Señor dijo, “Saquen a los israelitas de Egipto, divididos en sus respectivas tribus”. ");
INSERT INTO spavbl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moisés y Aarón también fueron los que fueron a hablar con el Faraón, rey de Egipto, sobre la salida de los israelitas de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Cuando el Señor habló a Moisés en Egipto, ");
INSERT INTO spavbl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","le dijo: “Yo soy el Señor. Dile al Faraón, rey de Egipto, todo lo que te digo” ");
INSERT INTO spavbl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Pero Moisés respondió: “No soy un buen orador, ¿por qué me escucharía el Faraón?” ");
INSERT INTO spavbl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Entonces el Señor le dijo a Moisés: “Mira, te haré parecer como Dios ante el Faraón, y tu hermano Aarón será tu profeta. ");
INSERT INTO spavbl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Debes repetir todo lo que te digo, y tu hermano Aarón debe repetirlo al Faraón para que deje salir a los israelitas de su país. ");
INSERT INTO spavbl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pero le daré al Faraón una actitud terca, y aunque haré muchas señales y milagros en Egipto, no te escuchará. ");
INSERT INTO spavbl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Entoncesatacaré a Egipto, imponiéndoles fuertes castigos, y sacaré a mi pueblo, los israelitas, tribu por tribu. ");
INSERT INTO spavbl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","De esta manera los egipcios sabrán que yo soy el Señor cuando actúe contra Egipto y saque a los israelitas del país”. ");
INSERT INTO spavbl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moisés y Aarón hicieron exactamente lo que el Señor había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moisés tenía ochenta y Aarón ochenta y tres años cuando fueron a hablar con el Faraón. ");
INSERT INTO spavbl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","El Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spavbl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Cuando el Faraón te pregunte: ‘¿Por qué no haces un milagro, entonces?’ dile a Aarón: ‘Toma tu bastón y tíralo delante del Faraón’, y se convertirá en una serpiente”. ");
INSERT INTO spavbl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moisés y Aarón fueron a ver al Faraón e hicieron lo que el Señor había ordenado. Aarón arrojó su bastón delante del Faraón y sus oficiales, y se convirtió en una serpiente. ");
INSERT INTO spavbl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pero el Faraón llamó a sabios y hechiceros, y estos magos egipcios hicieron lo mismo usando sus artes mágicas. ");
INSERT INTO spavbl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Cada uno de ellos arrojó su bastón y también se convirtieron en serpientes, pero el bastón de Aarón se tragó todos sus bastones. ");
INSERT INTO spavbl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Sin embargo, el Faraón tenía una actitud dura y terca, y no los escuchaba, como el Señor había predicho. ");
INSERT INTO spavbl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","El Señor le dijo a Moisés: “Faraón tiene una actitud obstinada, se niega a dejar ir al pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Así que mañana por la mañana ve a Faraón mientras camina hacia el río. Espera para encontrarte con él en la orilla del Nilo. Lleva contigo el bastón que se convirtió en una serpiente. ");
INSERT INTO spavbl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Dile: El Señor, el Dios de los hebreos, me ha enviado a decirte: ‘Deja ir a mi pueblo para que me adoren en el desierto. Pero no me has escuchado hasta ahora. ");
INSERT INTO spavbl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Esto es lo que el Señor te dice ahora: Así es como sabrán que yo soy el Señor’”. “¡Miren! Con el bastón que tengo en la mano, voy a golpear el agua del Nilo, y se convertirá en sangre. ");
INSERT INTO spavbl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Los peces del Nilo morirán, el río tendrá mal olor, y los egipcios no podrán beber nada de su agua”. ");
INSERT INTO spavbl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","El Señor le dijo a Moisés: “Dile a Aarón: ‘Toma tu bastón en tu mano y sostenlo sobre las aguas de Egipto, sobre sus ríos y canales y estanques y albercas, para que se conviertan en sangre. Habrá sangre por todo Egipto, incluso en los recipientes de madera y piedra’”. ");
INSERT INTO spavbl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Y Moisés y Aarón hicieron exactamente lo que el Señor les dijo. Mientras el Faraón y todos sus oficiales miraban, Aarón levantó su bastón y golpeó el agua del Nilo. ¡Inmediatamente todo el río se convirtió en sangre! ");
INSERT INTO spavbl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Los peces del Nilo murieron, y el río olía tan mal que los egipcios no podían beber su agua. ¡Había sangre por todo Egipto! ");
INSERT INTO spavbl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pero los magos egipcios hicieron lo mismo usando sus artes mágicas. El Faraón mantuvo su actitud terca y no quiso escuchar a Moisés y Aarón, tal como el Señor había predicho. ");
INSERT INTO spavbl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Entonces el Faraón volvió a su palacio y no prestó atención a lo que había sucedido ");
INSERT INTO spavbl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Todos los egipcios cavaron a lo largo del Nilo porque no podían beber su agua. ");
INSERT INTO spavbl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Siete días pasaron después de que el Señor llegara al Nilo. ");
INSERT INTO spavbl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","El Señor le dijo a Moisés: “Ve a ver al Faraón y dile: ‘Esto es lo que dice el Señor: Deja ir a mi pueblo, para que me adoren. ");
INSERT INTO spavbl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Si te niegas a dejarlos ir, enviaré una plaga de ranas por todo tu país. ");
INSERT INTO spavbl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Saldrán en enjambre del Nilo, y entrarán en tu palacio y se meterán en tu dormitorio y saltarán a tu cama. Entrarán en las casas de tus funcionarios y saltarán alrededor de tu gente, incluso en tus hornos y tazones de pan. ");
INSERT INTO spavbl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ranas saltarán sobre ti, tu pueblo y todos tus oficiales’”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","El Señor le dijo a Moisés: “Dile a Aarón: ‘Extiende tu bastón en tu mano sobre los ríos, canales y estanques, y haz que las ranas se extiendan por todo Egipto’”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aarón extendió su mano sobre las aguas de Egipto, y las ranas subieron y cubrieron la tierra. ");
INSERT INTO spavbl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pero los magos egipcios hicieron lo mismo usando sus artes mágicas. Criaron ranas en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","El Faraón llamó a Moisés y a Aarón y les suplicó: “Oren al Señor y pídanle que me quite las ranas a mí y a mi pueblo. Entonces dejaré ir a tu pueblo para que pueda ofrecer sacrificios al Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","“Ustedes tendrán el honor de decidir cuándo oraré por ustedes, sus funcionarios y su pueblo para que os quiten las ranas a ustedes y a sus casas. Permanecerán sólo en el Nilo”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“Hazlo mañana”, respondió el Faraón. Moisés dijo: “Sucederá como has pedido para que sepas que no hay nadie como el Señor nuestro Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Las ranas los dejarán y abandonarán sus casas, las casas de tus funcionarios y detodo tu pueblo, y sólo permanecerán en el Nilo”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moisés y Aarón dejaron al Faraón, y Moisés le suplicó al Señor por las ranas que había enviado contra el Faraón. ");
INSERT INTO spavbl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","El Señor hizo lo que Moisés le pidió. Las ranas de las casas, los patios y los campos murieron. ");
INSERT INTO spavbl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","El pueblo las recogió montón tras montón, y todo el país olía fatal. ");
INSERT INTO spavbl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero cuando el Faraón se dio cuenta de que la plaga había pasado, decidió volver a ser duro y terco, y no quiso escuchar a Moisés y Aarón, tal como el Señor había predicho. ");
INSERT INTO spavbl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Entonces el Señor le dijo a Moisés: “Dile a Aarón: ‘Recoge tu bastón y golpea el polvo del suelo. El polvo se convertirá en un enjambrede mosquitos por todo Egipto’”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Así que hicieron lo que el Señor dijo. Cuando Aarón levantó su bastón y golpeó el polvo de la tierra, los mosquitos pululaban sobre las personas y los animales. El polvo de todo Egipto se convirtió en mosquitos. ");
INSERT INTO spavbl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Los magos también trataron de hacer mosquitos usando sus artes mágicas, pero no pudieron. Los mosquitos se mantuvieron tanto sobre las personas como sobre los animales. ");
INSERT INTO spavbl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","“Este es un acto de Dios”, le dijeron los magos al Faraón. Pero el Faraón eligió ser obstinado y duro de corazón, y no quiso escuchar a Moisés y Aarón, como el Señor había predicho. ");
INSERT INTO spavbl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","El Señor le dijo a Moisés: “Mañana por la mañana levántate temprano y bloquea el camino del Faraón mientras baja al río. Dile: ‘Esto es lo que dice el Señor: Deja ir a mi pueblo, para que me adoren. ");
INSERT INTO spavbl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Si no dejas que mi pueblo se vaya, enviaré enjambres de moscas sobre ti y tus funcionarios, y sobre tu pueblo y tus casas. Todas las casas egipcias, e incluso el suelo sobre el que se levantan, se llenarán de enjambres de moscas. ");
INSERT INTO spavbl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Sin embargo, en esta ocasión trataré a la tierra de Gosén de manera diferente, que es donde vive mi pueblo, y no habrá allí ningún enjambre de moscas. Así es como sabrán que yo, el Señor, estoy aquí en su país. ");
INSERT INTO spavbl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Distinguiré a mi pueblo de su pueblo. Verás esta señal que lo confirma mañana’”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Y el Señor hizo lo que había dicho. Enormes enjambres de moscas entraron en el palacio del Faraón y en las casas de sus oficiales. Todo Egipto fue devastado por estos enjambres de moscas. ");
INSERT INTO spavbl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","El Faraón llamó a Moisés y a Aarón y les dijo: “Vayan y ofrezcan sacrificios a su Dios aquí dentro de este país”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","“No, eso no sería lo correcto”, respondió Moisés. “Los sacrificios que ofrecemos al Señor nuestro Dios serían ofensivos para los egipcios. ¡Si nos adelantáramos y ofreciéramos sacrificios ofensivos a los egipcios, nos apedrearían! ");
INSERT INTO spavbl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Debemos hacer un viaje de tres días al desierto y ofrecer allí los sacrificios al Señor nuestro Dios como nos ha dicho”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","“Los dejaré ir para que ofrezcan sacrificios al Señor su Dios en el desierto, pero no vayan muy lejos”, respondió el Faraón. “Ahora ora por mí para que esta plaga termine”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","“Tan pronto como te deje, oraré al Señor”, respondió Moisés, “y mañana las moscas dejarán al Faraón y a sus oficiales y a su pueblo. Pero el Faraón debe asegurarse de no volver a ser mentiroso, negándose después a dejar que el pueblo vaya a ofrecerle sacrificios al Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moisés dejó al Faraón y oró al Señor, ");
INSERT INTO spavbl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","y el Señor hizo lo que Moisés le pidió, y quitó los enjambres de moscas del Faraón y sus funcionarios y su pueblo. No quedó ni una sola mosca. ");
INSERT INTO spavbl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pero una vez más el Faraón eligió ser obstinado y duro de corazón y no dejó que el pueblo se fuera. ");
INSERT INTO spavbl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","El Señor le dijo a Moisés: “Ve y habla con el Faraón. Dile: ‘Esto es lo que dice el Señor: Deja ir a mi pueblo, para que me adoren. ");
INSERT INTO spavbl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Si te niegas a dejarlos ir y sigues deteniéndolos, ");
INSERT INTO spavbl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","te castigaré trayendo una plaga muy severa sobre tu ganado: en tus caballos, tus asnos, tus camellos, así como tus rebaños y manadas. ");
INSERT INTO spavbl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pero el Señor distinguirá entre el ganado de los israelitas y el de los egipcios, de modo que ninguno de los que pertenecen a los israelitas morirá. ");
INSERT INTO spavbl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","El Señor ha fijado un tiempo, diciendo: Mañana esto es lo que va a pasar aquí en el país’”. ");
INSERT INTO spavbl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Al día siguiente el Señor hizo lo que había dicho. Todo el ganado de los egipcios murió, pero no murió ni un solo animal de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","El Faraón envió a los oficiales y descubrió que no había muerto ni un solo animal de los israelitas. Pero el Faraón fue terco y no dejó que el pueblo se fuera. ");
INSERT INTO spavbl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","El Señor les dijo a Moisés y a Aarón: “Vayan y saquen unos puñados de hollín de un horno. Luego Moisés deberá arrojarlo al aire delante del Faraón. ");
INSERT INTO spavbl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Se esparcirá como polvo fino por todo el país de Egipto, y aparecerán llagas abiertas en la gente y en los animales de toda la tierra”. ");
INSERT INTO spavbl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Entonces sacaron hollín de un horno y fueron a ver al Faraón. Moisés lo arrojó al aire, y se comenzaron a abrir llagas en las personas y los animales. ");
INSERT INTO spavbl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Los magos no pudieron venir nicomparecer ante Moisés, porque ellos y todos los demás egipcios estaban cubiertos de llagas. ");
INSERT INTO spavbl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pero el Señor puso en el Faraón una actitud obstinada, y el Faraón no los escuchó, tal como el Señor le había dicho a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","El Señor le dijo a Moisés: “Mañana por la mañana levántate temprano y ve al Faraón, y dile que esto es lo que el Señor, el Dios de los hebreos, dice: ‘Deja ir a mi pueblo para que me adore’. ");
INSERT INTO spavbl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Esta vez dirigiré todas mis plagas contra ti y tus funcionarios y tu pueblo, para que te des cuenta de que no hay nadie como yo en toda la tierra. ");
INSERT INTO spavbl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","A estas alturas ya podría haber extendido mi mano para atacarte a ti y a tu pueblo con una plaga que te habría destruido por completo. ");
INSERT INTO spavbl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Sin embargo, te he dejado vivir para que veas mi poder, y para que mi reputación sea conocida por toda la tierra. ");
INSERT INTO spavbl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pero en tu orgullo sigues tiranizando a mi pueblo, y te niegas a dejar que se vaya. ");
INSERT INTO spavbl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","¡Así que ten cuidado! Mañana a esta hora enviaré la peor granizada que haya caído sobre Egipto, desde el principio de su historia hasta ahora. ");
INSERT INTO spavbl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Así que haz guardar a tu ganado y todo lo que tienes en el campo. Porque toda persona y todo animal que permanezcan fuera morirán cuando el granizo caiga sobre ellos”. ");
INSERT INTO spavbl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Aquellos oficiales del Faraón que tomaron en serio lo que el Señor dijo, se apresuraron a traer a sus sirvientes y a su ganado adentro. ");
INSERT INTO spavbl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pero aquellos a los que no les importó lo que el Señor decía, dejaron a sus sirvientes y ganado afuera. ");
INSERT INTO spavbl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","El Señor le dijo a Moisés: “Levanta tu mano hacia el cielo para que caiga una tormenta de granizo sobre todo Egipto, sobre la gente y sobre los animales, y sobre todo lo que crece en los campos de Egipto”. ");
INSERT INTO spavbl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moisés levantó su bastón hacia el cielo, y el Señor envió truenos y granizo, e hizo caer rayos al suelo. Así es como el Señor hizo llover granizo sobre Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Cuando el granizo cayó, vino acompañado de relámpagos por todas partes. El granizo que cayó fue tan severo como nunca se había visto en todo Egipto desde los comienzos de su historia. ");
INSERT INTO spavbl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","A lo largo de todo Egipto el granizo golpeó todo en los campos, tanto a las personas como a los animales. Derribó todo lo que crecía en los campos, y desnudó todos los árboles. ");
INSERT INTO spavbl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Sólo en la tierra de Gosén, donde vivían los israelitas, no había granizo. ");
INSERT INTO spavbl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","El Faraón llamó a Moisés y a Aarón y les dijo: “Admito que esta vez he pecado. ¡El Señor tiene razón, y yo y mi pueblo estamos equivocados! ");
INSERT INTO spavbl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Rueguen al Señor por nosotros, porque ya ha habido más que suficiente de los truenos y granizos de Dios. Dejaré que se vayan. No necesitan quedarse más tiempo aquí”. ");
INSERT INTO spavbl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","“Una vez que haya dejado la ciudad, oraré al Señor por ti”, le dijo Moisés. “Los truenos cesarán y no habrá más granizo, para que te des cuenta de que la tierra pertenece al Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero sé que tú y tus funcionarios aún no respetan realmente al Señor nuestro Dios”. ");
INSERT INTO spavbl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(El lino y la cebada fueron destruidos, porque la cebada estaba madura y el lino estaba floreciendo. ");
INSERT INTO spavbl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Sin embargo, el trigo y la escanda no fueron destruidos porque crecen más tarde). ");
INSERT INTO spavbl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisés dejó al Faraón y salió de la ciudad, y oró al Señor. Los truenos y el granizo se detuvieron, y la tormenta de lluvia terminó. ");
INSERT INTO spavbl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Cuando el Faraón vio que la lluvia, el granizo y los truenos habían cesado, volvió a pecar, y eligió volver a ser obstinado, junto con sus funcionarios. ");
INSERT INTO spavbl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Debido a su actitud terca, el Faraón no permitió que los israelitas se fueran, tal como el Señor había predicho a través de Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","El Señor le dijo a Moisés: “Ve a ver al Faraón, porque fui yo quien le dio a él y a sus oficiales una actitud obstinada para que yo pudiera hacer mis milagros ante ellos. ");
INSERT INTO spavbl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Esto es para que puedas contar a tus hijos y nietos cómo hice que los egipcios parecieran tontos haciendo estos milagros entre ellos, y para que sepas que yo soy el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moisés y Aarón fueron a ver al Faraón y le dijeron: “Esto es lo que dice el Señor, el Dios de los hebreos: ‘¿Hasta cuándo te negarás a humillarte ante mí? Deja ir a mi pueblo, para que me adore. ");
INSERT INTO spavbl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Sino dejas que mi pueblo se vaya, mañana enviaré una plaga de langostas a tu país. ");
INSERT INTO spavbl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Habrá tantas que cubrirán el suelo para que nadie pueda verlas. Comerán los cultivos que haya dejado el granizo, así como todos los árboles que crezcan en tus campos. ");
INSERT INTO spavbl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Entrarán en enjambres en tus casas y en las casas de todos tus funcionarios, de hecho en las casas de todos los egipcios. Esto es algo que ninguno de tus antepasados ha visto desde que llegaron a este país’”. Entonces Moisés y Aarón se volvieron y dejaron al Faraón. ");
INSERT INTO spavbl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Los oficiales del Faraón se acercaron a él y le preguntaron: “¿Cuánto tiempo vas a dejar que este hombre nos cause problemas? Deja que esta gente se vaya para que puedan adorar al Señor su Dios. ¿No te das cuenta de que Egipto ha quedado destruido?” ");
INSERT INTO spavbl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moisés y Aarón fueron traídos nuevamente ante el Faraón. “Vayan y adoren al Señor su Dios”, les dijo. “Pero ¿quién de ustedes irá?” ");
INSERT INTO spavbl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","“Todos iremos”, respondió Moisés. “Jóvenes y viejos, hijos e hijas, y llevaremos nuestros rebaños y manadas con nosotros, porque vamos a celebrar una fiesta para el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","“¡El Señor realmente tendrá que estar con ustedes si dejo que sus hijos se vayan!” respondió el Faraón. “¡Claramente estás planeando algún tipo de truco maligno! ");
INSERT INTO spavbl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","¡Así que no! Sólo los hombres pueden ir y adorar al Señor, porque eso es lo que has estado pidiendo”. Entonces hizo que echaran a Moisés y a Aarón. ");
INSERT INTO spavbl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","El Señor le dijo a Moisés, “Levanta tu mano sobre Egipto, para aparezcan las langostas y se coman todas las plantas del país, todo lo que haya dejado el granizo”. ");
INSERT INTO spavbl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moisés extendió su bastón sobre Egipto, y durante todo ese día y noche el Señor envió un viento del este que soplaba sobre la tierra. Cuando llegó la mañana, el viento del Este había traído las langostas. ");
INSERT INTO spavbl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Las langostas pululaban por toda la tierra y se asentaron en cada parte del país. Nunca había habido tal enjambre de langostas, y no lo habrá nunca más. ");
INSERT INTO spavbl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Cubrieron el suelo hasta que se vio negro, y se comieron todas las plantas de los campos y todos los frutos de los árboles que había dejado el granizo. No quedó ni una sola hoja verde en ningún árbol o planta en ningún lugar de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","El Faraón llamó urgentemente a Moisés y a Aarón y dijo: “He pecado contra el Señor tu Dios y contra ti. ");
INSERT INTO spavbl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Así que, por favor, perdona mi pecado sólo esta vez y suplica al Señor tu Dios, pidiéndole que al menos me quite esta plaga mortal”. ");
INSERT INTO spavbl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisés dejó al Faraón y rezó al Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","El Señor cambió la dirección del viento, de modo que un fuerte viento del Oeste arrastró a las langostas hasta el Mar Rojo. No quedó ni una sola langosta en ningún lugar de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero el Señor hizo que el Faraón se obstinara y no dejara ir a los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","El Señor le dijo a Moisés: “Levanta tu mano hacia el cielo para que caiga la oscuridad sobre Egipto, una oscuridad tan espesa que se pueda sentir”. ");
INSERT INTO spavbl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moisés levantó su mano hacia el cielo, y todo Egipto quedó completamente a oscuras durante tres días. ");
INSERT INTO spavbl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Nadie podía ver a nadie más, y nadie se movió de donde estaba durante tres días. Pero todavía había luz donde vivían todos los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Finalmente el Faraón llamó a Moisés. “Vayan y adoren al Señor”, dijo. “Dejen a sus rebaños y manadas aquí. Incluso puedes llevarte a tus hijos contigo”. ");
INSERT INTO spavbl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pero Moisés respondió: “También debes dejarnos animales para los sacrificios y los holocaustos, para que podamos ofrecerlos al Señor nuestro Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nuestro ganado tiene que ir con nosotros también.No se dejará ni un solo animal. Necesitaremos algunos para adorar al Señor nuestro Dios, y no sabremos cómo debemos adorar al Señor hasta que lleguemos allí”. ");
INSERT INTO spavbl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero el Señor hizo que el Faraón se obstinara, y no los dejó ir. ");
INSERT INTO spavbl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","El Faraón le gritó a Moisés: “¡Fuera de aquí! ¡No quiero volver a verte nunca más! ¡Si te vuelvo a ver, morirás!” ");
INSERT INTO spavbl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“Que sea como tú dices”, respondió Moisés. “No volveré a verte” ");
INSERT INTO spavbl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","El Señor le dijo a Moisés: “Hay una última plaga que derribaré sobre el Faraón y sobre Egipto. Después de eso os dejará marchar, pero cuando lo haga, os expulsará a todos del país. ");
INSERT INTO spavbl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ahora ve y dile a los israelitas, tanto hombres como mujeres, que pidan a sus vecinos egipcios objetos de plata y oro”. ");
INSERT INTO spavbl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","El Señor hizo que los egipcios miraran favorablemente a los israelitas. De hecho, el propio Moisés era muy respetado en Egipto tanto por los oficiales del Faraón como por la gente común. ");
INSERT INTO spavbl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moisés dijo: “Esto es lo que dice el Señor: Alrededor de la medianoche recorreré todo Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Todo primogénito en la tierra de Egipto morirá, desde el primogénito del Faraón sentado en su trono hasta el primogénito de la sirvienta que trabaja con un molino de mano, así como todo primogénito del ganado. ");
INSERT INTO spavbl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Habráfuertes gritos de luto en todo Egipto, como nunca antes se ha hecho, y nunca más se hará. ");
INSERT INTO spavbl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero entre todos los israelitas ni siquiera el ladrar de un perro molestará a las personas o a sus animales. Así sabrán que el Señor distingue entre Egipto e Israel. ");
INSERT INTO spavbl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Todos tus oficiales vendrán a mí, se inclinarán ante mí y me dirán: ‘¡Vete y llévate a todos tus seguidores!’ Después de eso me iré”. Moisés se enfadó mucho y se fue de la presencia del Faraón. ");
INSERT INTO spavbl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","El Señor le dijo a Moisés: “El Faraón se niega a escucharte para que pueda hacer más milagros en Egipto”. ");
INSERT INTO spavbl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moisés y Aarón hicieron estos milagros ante el Faraón, pero el Señor le dio al Faraón una actitud obstinada, y no dejó que los israelitas salieran de su país. ");
INSERT INTO spavbl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","El Señor le dijo a Moisés y a Aarón cuando aún estaban en Egipto: ");
INSERT INTO spavbl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Este mes será para ti el primer mes, el primer mes de tu año. ");
INSERT INTO spavbl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Diles a todos los israelitas que el décimo día de este mes, cada hombre debe elegir un cordero para su familia, uno para cada hogar. ");
INSERT INTO spavbl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Sin embargo, si la casa es demasiado pequeña para un cordero entero, entonces él y su vecino más cercano pueden elegir un cordero según el número total de personas. Dividirán el cordero según lo que cada uno pueda comer. ");
INSERT INTO spavbl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","El cordero debe ser un macho de un año sin ningún defecto, y puede ser tomado del rebaño de ovejas o del rebaño de cabras. ");
INSERT INTO spavbl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Guárdalo hasta el día catorce del mes, cuando todos los israelitas sacrificarán los animales después de la puesta del sol y antes de que oscurezca. ");
INSERT INTO spavbl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Tomarán un poco de sangre y la pondrán a los lados y en la parte superior de los marcos de las puertas de las casas en las que coman. ");
INSERT INTO spavbl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Asarán la carne en el fuego y la comerán esa noche, junto con pan sin levadura y hierbas amargas. ");
INSERT INTO spavbl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","No deben comer la carne cruda o hervida en agua. Todo debe ser asado sobre el fuego, incluyendo la cabeza, las piernas y los intestinos. ");
INSERT INTO spavbl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Asegúrense de que no quede nada hasta la mañana. Si sobra algo, deben quemarlo por la mañana. ");
INSERT INTO spavbl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“Así es como deben comer la comida. Deben estar vestidosy listos para viajar, con las sandalias en los pies y el bastón en la mano. Deben comer rápido, pues es la Pascua del Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Esa misma noche recorreré todo Egipto y mataré a todos los primogénitos de las personas y los animales, y traeré la condenación a todos los dioses de Egipto. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Marcaré las casas con sangre, y cuando vea la sangre, pasaré de largo. Ninguna plaga mortal caerá sobre ustedes ni los destruirá cuando ataque a Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Este será para ustedes un día para recordar. Lo celebrarán como un festival para el Señor por las generaciones futuras. Observarán esto por todos los tiempos venideros. ");
INSERT INTO spavbl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Durante siete días sólo comerán pan hecho sin levadura. El primer día deben deshacerse de la levadura de sus casas. Cualquiera que coma algo con levadura desde el primer día hasta el séptimo debe ser excluido de la comunidad israelita. ");
INSERT INTO spavbl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tanto el primer como el séptimo día deben tener una reunión sagrada. No deben trabajar en esos días, excepto para preparar la comida. Eso es lo único que pueden hacer. ");
INSERT INTO spavbl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Celebrarán la fiesta de los panes sin levadura porque en este mismo día yo saqué a sus tribus de Egipto. Deben observar este día de aquí en adelante. ");
INSERT INTO spavbl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","En el primer mes deberán comer pan sin levadura desde la tarde del día catorce hasta la tarde del día veintiuno. ");
INSERT INTO spavbl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Durante siete días no debe haber levadura en sus casas. Si alguien come algo con levadura, debe ser excluido de la comunidad israelita, sea extranjero o nativo de la tierra. ");
INSERT INTO spavbl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","No comerán nada que contenga levadura. Coman sólo pan sin levadura en todas sus casas”. ");
INSERT INTO spavbl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Entonces Moisés convocó a todos los ancianos de Israel y les dijo: “Vayan enseguida y elijan un cordero para cada una de sus familias y maten el cordero de la Pascua. ");
INSERT INTO spavbl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Cojan un manojo de hisopo, mójenlo en la sangre de la palangana y pónganlo en la parte superior y en los lados del marco de la puerta. Ninguno de ustedes saldrá por la puerta de la casa hasta la mañana. ");
INSERT INTO spavbl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","“Cuando el Señor pase a castigar a los egipcios, verá la sangre en la parte superior y en los lados del marco de la puerta. Pasará porencima de la puerta y no permitirá que el destructor entre en sus casas y los mate. ");
INSERT INTO spavbl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ustedes y sus descendientes deberán recordar estas instrucciones para el futuro. ");
INSERT INTO spavbl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Cuando entren en la tierra que el Señor prometió darles, celebrarán esta ceremonia. ");
INSERT INTO spavbl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Cuando sus hijos vengan y les pregunten: ‘¿Por qué es importante esta ceremonia para ustedes?’ ");
INSERT INTO spavbl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","deben decirles: ‘Este es el sacrificio de Pascua para el Señor. Él fue quien pasó por encima de las casas de los israelitas en Egipto cuando mató a los egipcios, pero perdonó a nuestras familias’”. El pueblo se inclinó en adoración. ");
INSERT INTO spavbl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Entonces los israelitas fueron e hicieron lo que el Señor les había dicho a Moisés y a Aarón. ");
INSERT INTO spavbl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A medianoche el Señor mató a todo primogénito varón en la tierra de Egipto, desde el primogénito del Faraón, que estaba sentado en su trono, hasta el primogénito del prisionero en la cárcel, y también todo el primogénito del ganado ");
INSERT INTO spavbl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","El Faraón se levantó durante la noche, así como todos sus oficiales y todos los egipcios. Hubo fuertes gritos de agonía en todo Egipto, porque no había una sola casa en la que no hubiera muerto alguien. ");
INSERT INTO spavbl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","El Faraón llamó a Moisés y a Aarón durante la noche y les dijo: “¡Fuera de aquí! ¡Dejen a mi pueblo, ustedes dos y los israelitas! Váyanse, para que puedan adorar al Señor como lo han pedido. ");
INSERT INTO spavbl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","¡Llévense también a sus rebaños y manadas, como lo dijeron antes y váyanse! Oh, y bendíceme a mí también”. ");
INSERT INTO spavbl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Los egipcios instaron a los israelitas a dejar su país lo más rápido posible, diciendo: “¡Si no, moriremos todos!” ");
INSERT INTO spavbl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Así que los israelitas recogieron su masa antes de que se levantara y la llevaron sobre sus hombros en tazones de amasar envueltos en ropa ");
INSERT INTO spavbl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Además, los israelitas hicieron lo que Moisés les había dicho y pidieron a los egipcios objetos de plata y oro, y ropa. ");
INSERT INTO spavbl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","El Señor había hecho que los egipcios miraran tan favorablemente a los israelitas que aceptaron su petición. De esta manera se llevaron las riquezas de los egipcios. ");
INSERT INTO spavbl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Los israelitas partieron a pie desde Ramsés hacia Sucot y fueron unos 600.000 hombres, así como mujeres y niños. ");
INSERT INTO spavbl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Además, muchos extranjeros se les unieron. También se llevaron consigo grandes rebaños y manadas de ganado. ");
INSERT INTO spavbl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Como su masa de pan no tenía levadura, los israelitas cocinaron lo que habían sacado de Egipto en panes sin levadura. Esto se debió a que cuando fueron expulsados de Egipto tuvieron que salir de prisa y no tuvieron tiempo de prepararse la comida. ");
INSERT INTO spavbl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Los israelitas habían vivido en Egipto durante 430 años. ");
INSERT INTO spavbl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","El mismo día en que terminaron los 430 años, todas las tribus del Señor, por sus respectivas divisiones, salieron de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Siendo que el Señor veló esa noche para sacarlos de la tierra de Egipto, ustedes deben velar esa misma noche como una observancia para honrar al Señor, que será guardada por todos los israelitas para las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","El Señor les dijo a Moisés y a Aarón: “Esta es la ceremonia de la Pascua. Ningún extranjero puede comerla. ");
INSERT INTO spavbl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Pero cualquier esclavo que haya sido comprado puede comerla cuando lo hayas circuncidado. ");
INSERT INTO spavbl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Los visitantes extranjeros o los contratados de otras naciones no podrán comer la Pascua. ");
INSERT INTO spavbl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Se debe comer dentro de la casa. No se permite sacar nada de la carne fuera de la casa, ni romper ningún hueso. ");
INSERT INTO spavbl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Todos los israelitas deben celebrarla. ");
INSERT INTO spavbl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Si hay un extranjero que vive con ustedes y quiere celebrar la Pascua del Señor, todos los varones de su casa tienen que ser circuncidados. Entonces podrán venir a celebrar y ser tratados como nativosdel país. Pero ningún hombre que no esté circuncidado puede comerla. ");
INSERT INTO spavbl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","La misma regla se aplica tanto al nativo como al extranjero que vive entre ustedes”. ");
INSERT INTO spavbl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Entonces todos los israelitas siguieron estas instrucciones. Hicieron exactamente lo que el Señor había ordenado a Moisés y Aarón. ");
INSERT INTO spavbl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ese mismo día el Señor sacó a las tribus israelitas de Egipto, una por una. ");
INSERT INTO spavbl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Todo varón primogénito será dedicado a mí. El primogénito de cada familia israelita me pertenece, y también cada animal primogénito”. ");
INSERT INTO spavbl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Así que Moisés le dijo al pueblo: “Recuerden que este es el día en que dejaron Egipto, la tierra de su esclavitud, porque el Señor los sacó de allí con su asombroso poder. (Nada con levadura en él será comido). ");
INSERT INTO spavbl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hoyustedes están en camino, este día en el mes de Abib. ");
INSERT INTO spavbl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","El Señor los llevará a la tierra de los cananeos, hititas, amorreos, heveos y jebuseos, la tierra que le prometió a sus antepasados, una tierra que fluye leche y miel. Así que deben observar esta ceremonia en este mes. ");
INSERT INTO spavbl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Durante siete días sólo comerán pan sin levadura, y el séptimo día celebrarán una fiesta religiosa para honrar al Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Durante esos siete días solo podrán comer pan sin levadura. No deben tener levadura; de hecho, no debe haber levadura en ningún lugar donde vivan. ");
INSERT INTO spavbl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Ese día digan a sus hijos: ‘Esto es por causa de lo que el Señor hizo por mí cuando salí de Egipto’. ");
INSERT INTO spavbl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Cuando celebren esta ceremonia será como una señal en su mano y un recordatorio en la frente de que esta enseñanza del Señor debe ser contada con regularidad. Porque el Señor los sacó de Egipto con su gran poder. ");
INSERT INTO spavbl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Es por eso que deben observar esta ceremonia año tras año, en esta fecha. ");
INSERT INTO spavbl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Una vez que el Señor los lleve a la tierra de los cananeos y se las entregue, como se los prometió a ustedes y a sus antepasados, ");
INSERT INTO spavbl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","deben presentar al Señor todos los primogénitos varones, humanos o animales. Todos los primogénitos de su ganado le pertenecen al Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Deben rescatara cada asno primogénito a cambio de un cordero, y si no lo hacen, deberán romperle el cuello. Deberán rescatar a cada primogénito de sus hijos. ");
INSERT INTO spavbl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Cuando en el futuro sus hijos vengan a ustedes y les pregunten: ‘¿Por qué es importante esta ceremonia’ deberán decirles: ‘El Señor nos sacó de Egipto, la tierra de nuestra esclavitud, mediante su asombroso poder. ");
INSERT INTO spavbl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","El Faraón se negó obstinadamente a dejarnos ir, así que el Señor mató a todos los primogénitos de la tierra de Egipto, tanto humanos como animales. Por eso sacrificamos al Señor el primogénito de cada animal, y compramos todos los primogénitos de nuestros hijos’. ");
INSERT INTO spavbl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","De esta manera, será como una señal en la mano y un recordatorio en la frente, porque el Señor nos sacó de Egipto por su asombroso poder”. ");
INSERT INTO spavbl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Cuando el Faraón dejó salir a los israelitas, Dios no los llevó por la tierra de los filisteos, aunque era un camino más corto. Porque Dios dijo, “Si se ven obligados a luchar, podrían cambiar de opinión y volver a Egipto”. ");
INSERT INTO spavbl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Así que Dios los llevó por el camino más largo a través del desierto hacia el Mar Rojo. Cuando los israelitas dejaron la tierra de Egipto eran como un ejército listo para la batalla. ");
INSERT INTO spavbl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moisés llevó los huesos de José con él porque José leshabía hecho a los hijos de Israel una promesa solemne, diciendo: “Dios definitivamente cuidará de ustedes, y entonces deben llevarse mis huesos cuando salgan de aquí”. ");
INSERT INTO spavbl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Viajaron desde Sucot y acamparon en Etam, a la entrada del desierto. ");
INSERT INTO spavbl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","El Señor iba delante de ellos como una columna de nubes para mostrarles el camino durante el día, y como una columna de fuego para proporcionarles luz por la noche. Así podían viajar de día o de noche. ");
INSERT INTO spavbl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","La columna de nubes durante el día y la columna de fuego por la noche iban siempre delante del pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Diles a los israelitas que vuelvan y acampen cerca de Pi-Ajirot, entre Migdol y el mar. Deben acampar junto al mar, frente a Baal-Zefón. ");
INSERT INTO spavbl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","El Faraónsacará su conclusión respecto a los israelitas: ‘Están vagando por el país con gran confusión, y el desierto les ha impedido salir’. ");
INSERT INTO spavbl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Daré a Faraón una actitud terca para que los persiga a fin derecuperarlos. Pero ganaré honra por lo que le sucederá al Faraón y a todo su ejército, y los egipcios sabrán que yo soy el Señor”. Así que los israelitas hicieron lo que se les ordenó. ");
INSERT INTO spavbl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Cuando el rey de Egipto se enteró de que los israelitas se habían marchado apresuradamente, el Faraón y sus oficiales cambiaron de opinión sobre lo que había sucedido y dijeron: “¿Qué hemos hecho? Hemos dejado ir a todos estos esclavos israelitas”. ");
INSERT INTO spavbl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Así que el Faraón hizo preparar su carro y se puso en marcha con su ejército. ");
INSERT INTO spavbl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Tomó 600 de sus mejores carros junto con todos los demás carros de Egipto, cada uno con su oficial a cargo. ");
INSERT INTO spavbl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","El Señor le dio al Faraón, rey de Egipto, una actitud terca, así que persiguió a los israelitas, que salían con los puños levantados en triunfo. ");
INSERT INTO spavbl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Los egipcios salieron en persecución, con todos los caballos y carros del Faraón, así como jinetes y soldados. Alcanzaron a los israelitas mientras estaban acampandojunto al mar cerca de Pi-Ajirot, frente a Baal-Zefón. ");
INSERT INTO spavbl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Los israelitas miraron hacia atrás y vieron al Faraón y al ejército egipcio acercándose. Estaban absolutamente aterrorizados y pidieron ayuda al Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Se quejaron a Moisés: “¿No había tumbas en Egipto que nos tuvieras que traer aquí en el desierto para morir? ¿Qué nos has hecho al hacernos salir de Egipto? ");
INSERT INTO spavbl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","¿Acaso no te dijimos en Egipto: ‘Déjanos en paz para que sigamos siendo esclavos de los egipcios’? ¡Hubiera sido mejor para nosotros ser esclavos de los egipcios que morir aquí en el desierto!” ");
INSERT INTO spavbl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Pero Moisés le dijo al pueblo: “No tengan miedo. Quédense donde están y verán cómo el Señor nos salvará hoy. Los egipcios que ven ahora, ¡no los volverán a ver nunca más! ");
INSERT INTO spavbl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","El Señor va a luchar por ustedes, así que no necesitan hacer nada”. ");
INSERT INTO spavbl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","El Señor le dijo a Moisés: “¿Por qué clamas a mi con gritos? Dile a los israelitas que sigan adelante. ");
INSERT INTO spavbl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Debes tomar tu bastón y sostenerlo en tu mano sobre el mar. Divídelo para que los israelitas puedan caminar por el mar en tierra seca. ");
INSERT INTO spavbl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Pondré en los egipcios una actitud obstinada y dura para que los persigan. Entonces me ganaré su honra por lo que le sucederá al Faraón y a todo su ejército, así como a sus carros y jinetes. ");
INSERT INTO spavbl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Los egipcios sabrán que soy el Señor cuando me gane su respeto a través del Faraón, sus carros y su caballería”. ");
INSERT INTO spavbl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","El ángel de Dios, que había estado guiando a los israelitas, se movía detrás de ellos, ");
INSERT INTO spavbl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","posicionándose entre los campos de los egipcios y de los israelitas. La nube estaba oscurapor un lado, pero iluminaba la noche por el otro. Nadie de ninguno de los dos campamentos se acercaba al otro durante la noche. ");
INSERT INTO spavbl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Entonces Moisés extendió su mano sobre el mar, y durante toda la noche el Señor hizo retroceder el mar con un fuerte viento del este, y convirtió el fondo del mar en tierra firme. Así que el agua se dividió, ");
INSERT INTO spavbl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","y los israelitas caminaron por el mar en tierra seca, con muros de agua a su derecha y a su izquierda. ");
INSERT INTO spavbl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Los egipcios los persiguieron, con todos los caballos, carros y jinetes del Faraón. Siguieron a los israelitas hasta el mar. ");
INSERT INTO spavbl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Pero al final de la noche el Señor miró al ejército egipcio desde la columna de fuego y nube, y les causó pánico. ");
INSERT INTO spavbl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Hizo que las ruedas de sus carros se atascaran, por lo que les resultaba difícil conducir. Los egipcios gritaron: “¡Retírense! ¡Debemos huir de los israelitas porque el Señor está luchando en favor de ellos contra nosotros!” ");
INSERT INTO spavbl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Entonces el Señor le dijo a Moisés: “Extiende tu mano sobre el mar, para que el agua caiga sobre los egipcios, sus carros y jinetes”. ");
INSERT INTO spavbl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Entonces Moisés extendió su mano sobre el mar, y al amanecer el mar volvió a la normalidad. Mientras los egipcios se retiraban, el Señor los arrastró al mar. ");
INSERT INTO spavbl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","El agua cayó sobre ellos y cubrió los carros y los jinetes, así como todo el ejército del Faraón que había perseguido a los israelitas hasta el mar. Ni uno solo de ellos sobrevivió. ");
INSERT INTO spavbl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pero los israelitas habían caminado por el mar en tierra seca, con muros de agua a su derecha y a su izquierda. ");
INSERT INTO spavbl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","El Señor salvó a los israelitas de la amenaza de los egipcios. Y los israelitas vieron a los egipcios muertos en la orilla. ");
INSERT INTO spavbl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Cuandovieron el gran poder que el Señor había usado contra los egipcios, los israelitas se quedaron asombrados del Señor y confiaron en él y en su siervo Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Entonces Moisés y los israelitas cantaron esta canción al Señor: ¡Cantaré al Señor, porque él es supremo! Ha arrojado al mar a los caballos y a sus jinetes. ");
INSERT INTO spavbl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","El Señor me da fuerza. Él es el tema de mi canción. Él me salva. Él es mi Dios, y yo lo alabaré. Él es el Dios de mi padre, y yo lo honraré.El Señor me da fuerza. Él es el tema de mi canción. Él me salva. Él es mi Dios, y yo lo alabaré. Él es el Dios de mi padre, y yo lo honraré. ");
INSERT INTO spavbl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","El Señor es como un guerrero. Su nombre es el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Arrojó los carros del Faraón y su ejército al mar. Los mejores oficiales del Faraón se ahogaron en el Mar Rojo. ");
INSERT INTO spavbl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","El agua los cubrió como una inundación. Cayeron a las profundidades como una piedra. ");
INSERT INTO spavbl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Tu poder, Señor, es verdaderamente asombroso. Tu poder, Señor, aplastó al enemigo. ");
INSERT INTO spavbl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Con tu majestuoso poder destruiste a los que se te oponían. Tu cólera ardió y los quemó como un rastrojo. ");
INSERT INTO spavbl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Túsoplaste y el mar se amontonó. Las olas se alzaron como un muro. Las profundidades del océano se volvieron sólidas. ");
INSERT INTO spavbl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","El enemigo se jactó: “Los perseguiré y los alcanzaré. Dividiré el botín. Los comeré vivos. Bailaré con laespada. Con mi mano los destruiré”. ");
INSERT INTO spavbl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pero tú soplaste con tu aliento y el mar los arrastró. Se hundieron como el plomo en las aguas revueltas. ");
INSERT INTO spavbl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","¿Quién es como tú entre los dioses, Señor? ¿Quién es como tú, glorioso en santidad, asombroso y maravilloso, que hace milagros? ");
INSERT INTO spavbl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tú actuaste, y la tierra se tragó a los egipcios. ");
INSERT INTO spavbl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Guiaste a las personas que salvaste con tu confiable amor. Los guiarás en tu fuerza a tu santo hogar. ");
INSERT INTO spavbl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Las naciones oirán lo que ha sucedido y temblarán de miedo. El pueblo que vive en Filistea experimentará una angustia agonizante. ");
INSERT INTO spavbl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Los jefes edomitas estarán aterrorizados. Los líderes moabitas temblarán. La gente que vive en Canaán se derretirá en pánico. ");
INSERT INTO spavbl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","El terror y el miedo caerán sobre ellos. Señor, debido a tu gran poder, estarán quietos como una piedra hasta que tu pueblo pase, hasta que pase el pueblo que compraste. ");
INSERT INTO spavbl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tomarás a tu pueblo y lo plantarás en el monte que tú posees, el lugar que tú, Señor, has preparado como tu casa, el ");
INSERT INTO spavbl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","¡El Señor reinará por siempre y para siempre! ");
INSERT INTO spavbl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Cuando los caballos, carros y jinetes del Faraón entraron en el mar, el Señor hizo que el agua se precipitara sobre ellos. Pero los israelitas caminaron por el mar en tierra seca. ");
INSERT INTO spavbl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","La profeta Miriam, hermana de Aarón, cogió una pandereta y todas las mujeres la siguieron bailando y tocando la pandereta. ");
INSERT INTO spavbl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam les cantó: “¡Canten al Señor, porque él es supremo! Ha arrojado al mar a los caballos y a sus jinetes”. ");
INSERT INTO spavbl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Entonces Moisés llevó a Israel lejos del Mar Rojo y al desierto de Sur. Durante tres días caminaron por el desierto pero no encontraron agua. ");
INSERT INTO spavbl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Cuando llegaron a Mara, el agua allí era demasiado amarga para beber. (Por eso el lugar se llama Mara). ");
INSERT INTO spavbl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Entonces el pueblo se quejó a Moisés, preguntando: “¿Qué vamos a beber?” ");
INSERT INTO spavbl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moisés le pidió ayuda al Señor, y el Señor le mostró un trozo de madera. Cuando lo arrojó al agua, se volvió dulce. Allí el Señor les dio reglas e instrucciones y también puso a prueba su lealtad hacia él. ");
INSERT INTO spavbl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Les dijo: “Si prestan atención a lo que dice el Señor su Dios, hagan lo que es correcto ante sus ojos, obedezcan sus órdenes y cumplan todos sus reglamentos, entonces no les haré sufrir ninguna de las enfermedades que les di a los egipcios porque yo soy el Señor que los sana”. ");
INSERT INTO spavbl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Luego viajaron a Elim, que tenía doce manantiales de agua y setenta palmeras. Allí acamparon junto al agua. ");
INSERT INTO spavbl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Toda la comunidad israelita dejó Elim y se fue al desierto de pecado, entre Elim y Sinaí. Esto fue el día quince del segundo mes después de que dejaran la tierra de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Allí, en el desierto, se quejaron a Moisés y a Aarón. ");
INSERT INTO spavbl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“¡El Señor debería habernos matado en Egipto!” les dijeron los israelitas. “Al menos allí podíamos sentarnos junto a ollas de carne y comer pan hasta que estuviéramos llenos. ¡Pero tenías que traernos a todos aquí en el desierto para matarnos de hambre!” ");
INSERT INTO spavbl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","El Señor le dijo a Moisés: “Ahora haré llover pan del cielo para ustedes. Cada día la gente debe salir y recoger lo suficiente para ese día. Voy a ponerlos a prueba con esto para saber si seguirán mis instrucciones o no. ");
INSERT INTO spavbl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","El sexto día deben recoger el doble de lo habitual y prepararlo”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Entonces Moisés y Aarón explicaron a todos los israelitas: “Esta tarde tendrán la prueba de que el Señor fue quien los sacó de Egipto ");
INSERT INTO spavbl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","y por la mañana verán la gloria del Señor desplegada al responder a las quejas que los ha oído hacer contra él. ¿Por qué debería quejarse con nosotros? ¡No somos nadie!” ");
INSERT INTO spavbl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Entonces Moisés continuó: “El Señor les dará esta tarde carne para comer y por la mañana todo el pan que quieran, porque ha oído sus quejas contra él. ¿Por qué se queja ante nosotros, nadie? Tus quejas no están dirigidas contra nosotros, sino contra el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Entonces Moisés dijo a Aarón: “Dile a toda la comunidad israelita: ‘Preséntense ante el Señor, porque ha oído sus quejas’”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mientras Aarón aún hablaba a todos los israelitas, miraron hacia el desierto y vieron aparecer la gloria del Señor en una nube. ");
INSERT INTO spavbl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“He oído las quejas de los israelitas. Diles: ‘Por la tarde comerás carne, y por la mañana tendrás todo el pan que quieras’. Entonces sabrán que yo soy el Señor su Dios”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Esa noche las codornices volaron y aterrizaron, llenando el campamento. Por la mañana, el rocío cubrió el suelo alrededor del campamento. ");
INSERT INTO spavbl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Una vez que el rocío se había ido, había una capa delgada y escamosa en el desierto, que parecía cristales de escarcha en el suelo. ");
INSERT INTO spavbl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Cuando los israelitas lo vieron, se preguntaron “¿Qué es?” porque no tenían ni idea de lo que era. Así que Moisés les explicó, “Es el pan que el Señor ha provisto para que coman. ");
INSERT INTO spavbl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Esto es lo que el Señor les ha ordenado hacer: ‘Todos ustedes recogerán lacantidad que les sea necesaria. Tomen un gómer por cada persona en su tienda’”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Los israelitas hicieron lo que se les dijo. Algunos recolectaron más, mientras que otros recolectaron menos. ");
INSERT INTO spavbl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Pero cuando lo midieron en gomeres, a los que habían recogido mucho no les sobraba nada, mientras que a los que sólo habían recogido un poco les sobraba. Cada persona recolectó tanto como necesitaba para comer. ");
INSERT INTO spavbl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Entonces Moisés les dijo: “Nadie debe dejar nada para mañana”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pero algunos no escucharon a Moisés. Dejaron un poco para el día siguiente, y estaba lleno de gusanos y olía mal. Y Moisés se enfadó con ellos. ");
INSERT INTO spavbl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Así que cada mañana todos recogían todo lo que necesitaban, y cuando el sol se calentaba, se desvanecía. ");
INSERT INTO spavbl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Sin embargo, en el sexto día, recogieron el doble de esta comida, dos gomeres por cada persona. Todos los líderes israelitas vinieron y le dijeron a Moisés lo que habían hecho. ");
INSERT INTO spavbl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moisés respondió: “Estas son las instrucciones del Señor: ‘Mañana es un día especial de descanso, un sábado santo para honrar al Señor. Así que horneen lo que quieran, y hiervan lo que quieran. Luego aparten lo que quede y guárdenlo hasta la mañana’”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Así que lo guardaron hasta la mañana como Moisés había ordenado, y no olía mal ni tenía gusanos. ");
INSERT INTO spavbl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moisés les dijo: “Coman hoy, porque hoy es un sábado para honrar al Señor. Hoy no encontrarán nada ahí fuera. ");
INSERT INTO spavbl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Pueden salir a recolectar durante seis días, pero el séptimo día, el sábado, no habrá nada que puedan recolectar”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Aún así, el séptimo día algunas personas todavía salieron a recolectar, pero no encontraron nada. ");
INSERT INTO spavbl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","El Señor le dijo a Moisés: “¿Cuánto tiempo te negarás a obedecer mis órdenes e instrucciones? ");
INSERT INTO spavbl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Debes entender que el Señor te ha dado el sábado, así que el sexto día te dará comida para dos días. El séptimo día, todos tienen que quedarse donde están, y nadie tiene que salir” ");
INSERT INTO spavbl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Así que el pueblo no hizo ningún trabajo en el séptimo día. ");
INSERT INTO spavbl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Los israelitas llamaron a esta comida maná. Era blanca como la semilla de cilantro y sabía a obleas con miel. ");
INSERT INTO spavbl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moisés dijo: “Esto es lo que el Señor ha ordenado: ‘Guarda un gomer de maná como recordatorio para las generaciones futuras, para que puedan ver la comida que usé para alimentarlos en el desierto cuando los saqué de Egipto’”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Así que Moisés le dijo a Aarón: “Toma un frasco y pon un gomer de maná en él. Luego ponlo ante el Señor para que lo guarde como un recordatorio para las generaciones futuras”. ");
INSERT INTO spavbl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aarón lo hizo y colocó la jarra delante del Testimonio, para que se conservara tal y como el Señor se lo había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Los israelitas comieron maná durante cuarenta años, hasta que llegaron a la tierra en la que se asentarían; comieron maná hasta que llegaron a la frontera de Canaán. ");
INSERT INTO spavbl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Un gómer es una décima parte de una efa). ");
INSERT INTO spavbl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Todos los israelitas dejaron el desierto de Sin, yendo de un lugar hacia otro, según las órdenes del Señor. Acamparon en Refidim, pero no había agua para que el pueblo la bebiera. ");
INSERT INTO spavbl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Algunos de ellos vinieron y se quejaron a Moisés, diciendo: “¡Danos agua para beber!” Moisés respondió, “¿Por qué se quejas conmigo?” Preguntó Moisés. “¿Por qué intentan desafiar al Señor?” ");
INSERT INTO spavbl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Pero el pueblo estaba tan sediento de agua que se quejó a Moisés, diciendo: “¿Por qué tuviste que sacarnos de Egipto? ¿Intentas matarnos a nosotros y a nuestros hijos y ganado de sed?” ");
INSERT INTO spavbl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moisés le gritó al Señor: “¿Qué voy a hacer con esta gente? ¡Un poco más de esto y me apedrearán!” ");
INSERT INTO spavbl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","El Señor le dijo a Moisés: “Ve delante del pueblo y llévate a algunos de los ancianos de Israel contigo. Lleva contigo el bastón que usaste para golpear el Nilo, y sigue adelante. ");
INSERT INTO spavbl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mira, me pararé a tu lado junto a la roca en Horeb. Cuando golpees la roca, el agua se derramará para que la gente beba”. Así que Moisés hizo esto mientras los ancianos de Israel observaban. ");
INSERT INTO spavbl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Llamó al lugar Masá y Meribá porque los israelitas discutieron allí, y porque desafiaron al Señor, diciendo: “¿Está el Señor con nosotros o no?” ");
INSERT INTO spavbl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Entonces vinieron unos amalecitas y atacaron a los israelitas en Refidim. ");
INSERT INTO spavbl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moisés le dijo a Josué: “Escoge algunos hombres y sal a combatir a los amalecitas. Mañana me pararé en la cima de esta colina con el bastón de Dios”. ");
INSERT INTO spavbl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josué hizo lo que le dijo Moisés y luchó contra los amalecitas, mientras que Moisés, Aarón y Hur subieron a la cima de la colina. ");
INSERT INTO spavbl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mientras Moisés sostenía el bastón con sus manos, los israelitas eran los que ganaban, pero cuando los bajaba, eran los amalecitas. ");
INSERT INTO spavbl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","A sí que cuando las manos de Moisés se volvieron pesadas, los otros tomaron una piedra y la pusieron debajo de él para que se sentara. Aarón y Hur se pararon a cada lado de Moisés y le levantaron las manos. De esta manera sus manos se mantuvieron firmes hasta que el sol se puso. ");
INSERT INTO spavbl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Como resultado, Josué derrotó al ejército amalecita. ");
INSERT INTO spavbl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","El Señor le dijo a Moisés: “Escribe todo esto en un pergamino como recordatorio y léeselo en voz alta a Josué, porque voy a eliminar por completo a los amalecitas para que nadie en la tierra se acuerde de ellos”. ");
INSERT INTO spavbl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moisés construyó un altar y lo llamó “el Señor es mi bandera de la victoria”. ");
INSERT INTO spavbl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“¡Levanten el estandarte de la victoria del Señor!”, declaró Moisés. “¡El Señor seguirá luchando contra los amalecitas por todas las generaciones!” ");
INSERT INTO spavbl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Entonces Jetro, el suegro de Moisés y sacerdote de Madián, escuchó todo lo que Dios había hecho por Moisés y su pueblo, los israelitas, y cómo el Señor los había sacado de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Cuando Moisés envió a casa a su esposa Séfora, su suegro Jetro la acogió, ");
INSERT INTO spavbl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","junto con sus dos hijos. Uno de los hijos se llamaba Gersón, ya que Moisés había dicho: “He sido un extranjero en tierra extranjera”. ");
INSERT INTO spavbl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","El otro hijo se llamaba Eliezer, porque Moisés había dicho: “El Dios de mi padre fue mi ayuda, y me salvó de la muerte de la mano del Faraón”. ");
INSERT INTO spavbl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","El suegro de Moisés, Jetro, junto con la esposa y los hijos de Moisés, fue a verlo en el desierto en el campamento cerca de la montaña de Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","A Moisés se le dijo de antemano: “Yo, tu suegro Jetro, vengo a verte junto con tu esposa y sus dos hijos”. ");
INSERT INTO spavbl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moisés salió al encuentro de su suegro y se inclinó y le besó. Se preguntaron cómo estaban y luego entraron en la tienda. ");
INSERT INTO spavbl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moisés le contó a su suegro todo lo que el Señor había hecho al Faraón y a los egipcios en favor de los israelitas, todos los problemas que habían experimentado en el camino y cómo el Señor los había salvado. ");
INSERT INTO spavbl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro se alegró de escuchar todas las cosas buenas que el Señor había hecho por Israel cuando los había salvado de los egipcios. ");
INSERT INTO spavbl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jetro anunció: “Bendito sea el Señor, que te salvó de los egipcios y del Faraón. ");
INSERT INTO spavbl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Esto me convence de que el Señor es más grande que todos los demás dioses, porque salvó al pueblo de los egipcios cuando actuaron tan arrogantemente con los israelitas”. ");
INSERT INTO spavbl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Entonces Jetro presentó un holocausto y sacrificios a Dios, y Aarón vino con todos los ancianos de Israel para comer con él en presencia de Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Al día siguiente Moisés se sentó como juez del pueblo, y le presentaron sus casos desde la mañana hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Cuando su suegro vio todo lo que Moisés estaba haciendo por el pueblo, preguntó: “¿Qué es todo esto que estás haciendo por el pueblo? ¿Por qué te sientas solo como juez, con todo el mundo presentándote sus casos de la mañana a la noche?” ");
INSERT INTO spavbl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","“Porque el pueblo viene a mí para consultar la decisión de Dios”, respondió Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","“Cuando discuten sobre algo, el caso se presenta ante mí para decidir entre uno de ellos, y les explico las leyes y reglamentos de Dios”. ");
INSERT INTO spavbl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Jetro le dijo: “Lo que estás haciendo no es lo mejor. ");
INSERT INTO spavbl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tú y los que vienen a ti se van a agotar, porque la carga de trabajo es demasiado pesada. No pueden manejarlo solos. ");
INSERT INTO spavbl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Así que, por favor, escúchame. Voy a darte un consejo, y Dios estará contigo. Sí, debes continuar siendo el representante del pueblo ante Dios, y llevarle sus casos a él. ");
INSERT INTO spavbl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Sigue enseñándoles las leyes y los reglamentos. Muéstrales cómo vivir y el trabajo que deben hacer. ");
INSERT INTO spavbl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Pero ahora debes elegir entre el pueblo hombres competentes, hombres que respeten a Dios y que sean dignos de confianza y no corruptos. Ponlos a cargo del pueblo como líderes de miles, cientos, cincuenta y decenas. ");
INSERT INTO spavbl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Estos hombres deben juzgar al pueblo de manera continua. Pueden traertelos asuntos más grandes, pero podrán decidirpor sí mismos respecto a todos los asuntos pequeños. De esta manera su carga se hará más ligera a medida que la compartan. ");
INSERT INTO spavbl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si sigues mi consejo, y si es lo que Dios te dice que hagas, entonces podrás sobrevivir, y toda esta gente podrá volver a casa satisfecha de que sus casos han sido escuchados”. ");
INSERT INTO spavbl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moisés escuchó lo que dijo su suegro y siguió todos sus consejos. ");
INSERT INTO spavbl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Así que Moisés eligió hombres competentes de todo Israel y los puso a cargo del pueblo como líderes de miles, cientos, cincuenta y decenas. ");
INSERT INTO spavbl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Y actuaron como jueces del pueblo de manera continua. Llevaban los casos difíciles a Moisés, pero juzgaban los pequeños asuntos por sí mismos. ");
INSERT INTO spavbl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Entonces Moisés envió a Jetrode camino, y regresó a su propio país. ");
INSERT INTO spavbl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Dos meses después del día en que habían salido de Egipto, los israelitas llegaron al desierto del Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Habían partido de Refidim, y después de entrar en el desierto del Sinaí acamparon allí frente a la montaña. ");
INSERT INTO spavbl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moisés subió al monte de Dios. Y el Señor habló con Moisés desde la montaña y le dijo: “Esto es lo que debes decirles a los descendientes de Jacob, los israelitas: ");
INSERT INTO spavbl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Vieron con sus propios ojos lo que hice con los egipcios, y cómo los llevé sobre alas de águila, y cómo los traje hacia mí. ");
INSERT INTO spavbl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ahora bien, si realmente obedecen lo que digo y cumplen el acuerdo conmigo, entonces, de todas las naciones, serán mi pueblo especial. Aunque que el mundo entero es mío, ");
INSERT INTO spavbl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","para mí serán un reino de sacerdotes, una nación santa’. Esto es lo que debes decirles a los israelitas”. ");
INSERT INTO spavbl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Entonces Moisés bajó, convocó a los ancianos del pueblo y les presentó todo lo que el Señor le había ordenado decir. ");
INSERT INTO spavbl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Todos respondieron: “Prometemos hacer todo lo que el Señor diga”. Entonces Moisés llevó la respuesta del pueblo al Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","El Señor le dijo a Moisés: “Voy a ir hacia ti en una nube espesa para que el pueblo me oiga hablar contigo y así siempre confiarán en ti”. Entonces Moisés le informó al Señor lo que el pueblo había dicho. ");
INSERT INTO spavbl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","El Señor le dijo a Moisés: “Baja y prepáralos espiritualmente hoy y mañana. Deben lavar sus ropas ");
INSERT INTO spavbl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","y estar listos al tercer día porque es cuando el Señor descenderá al Monte Sinaí a la vista de todos. ");
INSERT INTO spavbl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Establezcan un límite alrededor de la montaña y adviértanles: ‘Tengan cuidado y no intenten subir a la montaña, ¡ni siquiera la toquen! Porque cualquiera que toque la montaña seguramente morirá. No toquen a ninguna persona o animal que haya tocado la montaña. ");
INSERT INTO spavbl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Asegúrate de que sean apedreados o disparados con flechas, pues no se les debe permitir vivir’. Sólo cuando escuchen un fuerte sonido de cuerno de carnero, el pueblo podrá subir a la montaña”. ");
INSERT INTO spavbl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moisés bajó de la montaña y preparó al pueblo espiritualmente y lavó sus ropas. ");
INSERT INTO spavbl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Luego instruyó al pueblo: “Prepárense para el tercer día, y no tengan relación íntima con una mujer”. ");
INSERT INTO spavbl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Cuando llegó la mañana del tercer día hubo truenos y relámpagos, y una nube espesa cubrió la montaña. Hubo un fuerte sonido de cuerno de carnero, y todos en el campamento temblaron de miedo. ");
INSERT INTO spavbl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moisés condujo al pueblo fuera del campamento para encontrarse con Dios. Se pararon al pie de la montaña ");
INSERT INTO spavbl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","El humo se derramó sobre todo el Monte Sinaí porque la presencia del Señor había descendido como el fuego. El humo se elevó como el humo de un horno, y toda la montaña tembló furiosamente. ");
INSERT INTO spavbl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","A medida que el sonido del cuerno de carnero se hacía cada vez más fuerte, Moisés hablaba, y Dios le respondía con una voz fuerte y atronadora. ");
INSERT INTO spavbl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","El Señor descendió a la cima del Monte Sinaí, y llamó a Moisés para que subiera allí. Así que Moisés subió, ");
INSERT INTO spavbl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","y el Señor le dijo: “Vuelve a bajar, y adviértele al pueblo que no se esfuercen en cruzar el límite para intentar subir donde está el Señor o morirán. ");
INSERT INTO spavbl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Incluso los sacerdotes, que vienen ante el Señor, deben prepararse espiritualmente, para que el Señor no los castigue”. ");
INSERT INTO spavbl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Pero Moisés le dijo al Señor: “El pueblo no puede subir al monte Sinaí. Tu mismo nos advertiste diciendo: ‘Establezcan un límite alrededor de la montaña, y considérenla como sagrada’”. ");
INSERT INTO spavbl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","El Señor le dijo: “Baja y trae a Aarón contigo. Pero los sacerdotes y el pueblo no deben tratar de subir donde estáel Señor, o él los castigará” ");
INSERT INTO spavbl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Entonces Moisés bajó y le explicó al pueblo lo que el Señor había dicho. ");
INSERT INTO spavbl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Dios dijo todas las siguientes palabras: ");
INSERT INTO spavbl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Yo soy el Señor tu Dios, que te sacó de Egipto, de la tierra de tu esclavitud. ");
INSERT INTO spavbl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“No tendrás a otros dioses aparte de mi. ");
INSERT INTO spavbl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“No harás ningún tipo de ídolo, ya sea que se parezca a algo arriba en los cielos, o abajo en la tierra, ni debajo en las aguas. ");
INSERT INTO spavbl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","No debes inclinarte ante ellos ni adorarlos, porque yo soy el Señor tu Dios y soy celosamente exclusivo. Yo pongo las consecuencias del pecado de los que me odian sobre sus hijos, sus nietos y sus bisnietos; ");
INSERT INTO spavbl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","pero muestro mi amor fiel a las miles de generaciones que me aman y guardan mis mandamientos. ");
INSERT INTO spavbl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“No debes usar mal el nombre del Señor tu Dios, porque el Señor no perdonará a nadie que use su nombre de forma incorrecta. ");
INSERT INTO spavbl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Recuerda el sábado para santificarlo. ");
INSERT INTO spavbl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tienes seis días para trabajar y ganarte el sustento, ");
INSERT INTO spavbl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","pero el séptimo día es el sábado para honrar al Señor tu Dios. En este día no debes hacer ningún trabajo, ni tú, ni tu hijo o hija, ni tu esclavo o esclava, ni el ganado, ni el extranjero que esté contigo. ");
INSERT INTO spavbl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Porqueen seis días el Señor hizo los cielos y la tierra, el mar y todo lo que hay en ellos, y luego descansó en el séptimo día. Por eso el Señor bendijo el día de reposo y lo hizo santo. ");
INSERT INTO spavbl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Honra a tu padre y a tu madre, para que vivas mucho tiempo en la tierra que el Señor tu Dios te da. ");
INSERT INTO spavbl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“No cometerás asesinato. ");
INSERT INTO spavbl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“No cometerás adulterio. ");
INSERT INTO spavbl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“No robarás. ");
INSERT INTO spavbl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“No darás falso testimonio contra otros. ");
INSERT INTO spavbl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“No desearás tener la casa de otro. No desearás a su esposa, nia su esclavo o esclava, ni a su buey o asno, ni cualquier otra cosa que le pertenezca”. ");
INSERT INTO spavbl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Cuando todo el pueblo oyó el trueno y el sonido de la trompeta, y vio el relámpago y el humo de la montaña, temblaron de miedo y se alejaron. ");
INSERT INTO spavbl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","“Habla con nosotros y te escucharemos”, le dijeron a Moisés. “Pero no dejes que Dios nos hable, o moriremos”. ");
INSERT INTO spavbl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moisés les dijo: “No teman, porque Dios sólo ha venido a probarlos. Quiere que le tengan miedo para que no pequen”. ");
INSERT INTO spavbl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Entonces el pueblo se alejó mucho cuando Moisés se acercó a la espesa y oscura nube donde estaba Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","El Señor le dijo a Moisés: “Esto es lo que les debes decir a los israelitas: ‘Vieron con sus propios ojos que les hablé desde el cielo. ");
INSERT INTO spavbl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Noharán ningún ídolo de plata o de oro ni lo adorarán aparte de mí. ");
INSERT INTO spavbl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Háganme un altar de tierra y sacrifiquen sobre él sus holocaustos y ofrendas de paz, sus ovejas, sus cabras y su ganado. Dondequiera que decida que me adoren, vendé a ustedes y los bendeciré. ");
INSERT INTO spavbl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ahora bien, si me hacen un altar de piedras, no lo construyas con piedras cortadas, porque si usan un cincel para cortar la piedra, dejan de ser sagradas. ");
INSERT INTO spavbl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Además, no deben subir a mi altar con escalones, para que no se vean sus partes privadas’”. ");
INSERT INTO spavbl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Estos son los reglamentos que debe presentarles: ");
INSERT INTO spavbl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Si compran un esclavo hebreo, debe trabajar para ustedes durante seis años. Pero en el séptimo año, debe ser liberado sin tener que pagar nada. ");
INSERT INTO spavbl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Si era soltero cuando llegó, debe irse soltero. Si tenía una esposa cuando llegó, ella debe irse con él. ");
INSERT INTO spavbl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si su amo le da una esposa y ella tiene hijos con él, la mujer y sus hijos pertenecerán a su amo, y sólo el hombre será liberado. ");
INSERT INTO spavbl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Sin embargo, si el esclavo declara formalmente: ‘Amo a mi señor, a mi esposa y a mis hijos; no quiero ser liberado’ ");
INSERT INTO spavbl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","entonces su señor lo llevará ante los jueces. Luego lo pondrá de pie contra la puerta o el poste de la puerta y usará una herramienta de metal para hacerle un agujero en la oreja. Entonces trabajará para su amo de por vida. ");
INSERT INTO spavbl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Si un hombre vende a su hija como esclava, no será liberada de la misma manera que los esclavos. ");
INSERT INTO spavbl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si el hombre que la eligió para sí no está satisfecho con ella, debe dejar que sea comprada de nuevo. No podrá venderla a los extranjeros, ya que ha sido injusto con ella. ");
INSERT INTO spavbl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Si decide dársela a su hijo, debe tratarla como a una hija. ");
INSERT INTO spavbl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Si toma a otra mujer, no debe reducir los subsidios de comida y ropa, ni los derechos maritales de la primera. ");
INSERT INTO spavbl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Si no le da estas tres cosas, ella es libre de irse sin pagar nada. ");
INSERT INTO spavbl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Todo aquel que golpee y mate a otra persona debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Sin embargo, si no fue intencional y Dios permitió que sucediera, entonces arreglaré un lugar para ustedes donde puedan correr y estar seguros. ");
INSERT INTO spavbl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Pero si alguien planea deliberadamente y mata a propósito a otro, debe alejarlo de mi altar y ejecutarlo. ");
INSERT INTO spavbl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Cualquiera que golpee a su padre o madre debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Cualquiera que secuestre a alguien más debe ser ejecutado, ya sea que la víctima sea vendida o que aún esté en su posesión. ");
INSERT INTO spavbl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Cualquiera que desprecie a su padre o a su madre debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Si los hombres están peleando y uno golpea al otro con una piedra o con el puño, y el hombre herido no muere pero tiene que permanecer en cama, ");
INSERT INTO spavbl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","y luego se levanta y camina afuera con su bastón, entonces el que lo golpeó no será castigado. Aún así, debe compensar al hombre por el tiempo perdido de su trabajo y asegurarse de que esté completamente curado. ");
INSERT INTO spavbl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Cualquiera que golpee a su esclavo o esclava con una vara, y el esclavo muera como resultado, debe ser castigado. ");
INSERT INTO spavbl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Sin embargo, si después de un día o dos el esclavo mejora, el dueño no será castigado porque el esclavo es de su propiedad. ");
INSERT INTO spavbl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Si los hombres que están peleando golpean a una mujer embarazada para que dé a luz prematuramente, pero no se produce ninguna lesión grave, debe ser multado con la cantidad que el marido de la mujer demande y según lo permitan los jueces. ");
INSERT INTO spavbl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero si se produce una lesión grave, entonces debe pagar una vida por otra vida; ");
INSERT INTO spavbl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ojo por ojo, diente por diente, mano por mano, pie por pie, ");
INSERT INTO spavbl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","quemadura por quemadura, herida por herida y moretón por moretón. ");
INSERT INTO spavbl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“El que golpee a su esclavo o esclava en el ojo y lo ciegue, debe liberar al esclavo como compensación por el ojo. ");
INSERT INTO spavbl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","El que golpee el diente de su esclavo o esclava debe liberar al esclavo como compensación por el diente. ");
INSERT INTO spavbl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Si un buey usa sus cuernos para matar a un hombre o una mujer, el buey debe ser apedreado hasta morir, y su carne no debe ser comida. Pero el dueño del buey no será castigado. ");
INSERT INTO spavbl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero si el buey ha herido repetidamente a la gente con sus cuernos, y su dueño ha sido advertido pero aún no lo tiene bajo control, y mata a un hombre o una mujer, entonces el buey debe ser apedreado hasta morir y su dueño también debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Pero si en lugar de ello se exige el pago de una indemnización, el propietario puede compensar su vida pagando la totalidad de la indemnización exigida. ");
INSERT INTO spavbl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Pero si en lugar de ello se exige el pago de una indemnización, el propietario puede salvar su vida pagando la totalidad de la indemnización exigida. ");
INSERT INTO spavbl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Si el buey usa sus cuernos y mata a un esclavo o esclava, el propietario del buey debe pagar treinta siclos de plata al amo del esclavo, y el buey debe ser apedreado hasta la muerte. ");
INSERT INTO spavbl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Si alguien quita la tapa de una cisterna o cava una y no la cubre, y un buey o un asno cae en ella, ");
INSERT INTO spavbl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","el dueño de la fosa debe pagar una compensación al dueño del animal y quedarse con el animal muerto. ");
INSERT INTO spavbl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Si el buey de alguien hiere al de otro y éste muere, debe vender al buey vivo y compartir el dinero recibido; también debe compartir al animal muerto. ");
INSERT INTO spavbl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pero si se sabe que el buey ha herido repetidamente a personas con sus cuernos, y su dueño ha sido advertido pero aún no lo tiene bajo control, debe pagar una compensación completa, buey por buey; pero el dueño puede quedarse con el animal muerto”. ");
INSERT INTO spavbl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Quien robe un buey o una oveja y la mate o la venda, deberá devolver cinco bueyes por un buey y cuatro ovejas por una oveja. ");
INSERT INTO spavbl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Si se descubre a un ladrón entrando en la casa de alguien y es golpeado hasta la muerte, nadie será culpable de asesinato. ");
INSERT INTO spavbl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Pero si ocurre durante el día, entonces alguien es culpable de asesinato. El ladrón debe devolver todo lo robado. Si no tiene nada, entonces debe ser vendido para pagar lo que fue robado. ");
INSERT INTO spavbl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si lo que fue robado es un animal vivo que todavía tiene, ya sea un buey, un asno o una oveja, debe devolver el doble. ");
INSERT INTO spavbl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Si el ganado pasta en un campo o en un viñedo y su dueño lo deja vagar para que pasten en el campo de otro, el dueño debe pagar una compensación con lo mejor de sus propios campos o viñedos. ");
INSERT INTO spavbl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Si se inicia un incendio que se extiende a los arbustos espinosos y luego quema el grano apilado o en pie, o incluso todo el campo, la persona que inició el fuego debe pagar una compensación completa. ");
INSERT INTO spavbl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Si alguien le da a su vecino dinero o posesiones para que las guarde y se las roban de la casa del vecino, si el ladrón es atrapado debe pagar el doble. ");
INSERT INTO spavbl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Si el ladrón no es atrapado, el propietario de la casa debe comparecer ante los jueces para averiguar si se llevó la propiedad de su vecino. ");
INSERT INTO spavbl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Si hay una discusión sobre la propiedad de un buey, un asno, una oveja, una prenda de vestir, o cualquier cosa que se haya perdido y alguien dice: ‘Esto es mío’, ambas partes deben llevar su caso ante los jueces. Aquel al que los jueces encuentren culpable debe devolverle el doble al otro. ");
INSERT INTO spavbl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Si alguien pide a un vecino que cuide un asno, un buey, una oveja o cualquier otro animal, pero éste muere o se lesiona o es robado sin que nadie se dé cuenta, ");
INSERT INTO spavbl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","entonces se debe prestar un juramento ante el Señor para decidir si el vecino ha tomado la propiedad del dueño. El propietario debe aceptar el juramento y no exigir una compensación. ");
INSERT INTO spavbl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","“Sin embargo, si el animal fue realmente robado al vecino, debe compensar al propietario. ");
INSERT INTO spavbl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Si fue matado y despedazado por un animal salvaje, el vecino deberá presentar el cadáver como prueba y no necesita pagar indemnización. ");
INSERT INTO spavbl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Si alguien toma prestado un animal del vecino y éste resulta herido o muere mientras su dueño no está presente, debe pagar una indemnización en su totalidad. ");
INSERT INTO spavbl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Si el propietario estaba presente, no se pagará ninguna compensación. Si el animal fue alquilado, sólo se debe pagar el precio del alquiler. ");
INSERT INTO spavbl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Si un hombre seduce a una virgen no comprometida para casarse y se acuesta con ella, debe pagar el precio completo de la novia para que se convierta en su esposa. ");
INSERT INTO spavbl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Si el padre de ella se niega rotundamente a dársela, el hombre debe pagar la misma cantidad que el precio de la novia por una virgen. ");
INSERT INTO spavbl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“No se debe permitir que viva una mujer que practique la brujería. ");
INSERT INTO spavbl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Todo aquel que tenga relaciones sexuales con un animal debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Cualquiera que se sacrifique a cualquier otro dios que no sea el Señor debe ser apartado y ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“No se debe explotar o maltratar a un extranjero. Recuerden que ustedes mismos fueron una vez extranjeros en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“No se aprovechen de ninguna viuda o huérfano. ");
INSERT INTO spavbl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si los maltratan, y ellos me piden ayuda, responderé a su clamor. ");
INSERT INTO spavbl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Me enfadaré y mataré a quien se aproveche de ellos con espada. Entonces sus esposas se convertirán en viudas y sus hijos quedarán huérfanos. ");
INSERT INTO spavbl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Si le prestas dinero a mi pueblo porque son pobres, no te comportes como un prestamista con ellos. No debes cobrarles ningún interés. ");
INSERT INTO spavbl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","“Si necesitas la capa de tu vecino como garantía de un préstamo, debes devolvérsela antes de la puesta de sol, ");
INSERT INTO spavbl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","porque es la única ropa que tiene para su cuerpo. ¿De otro modo, con qué dormirá? Y si me pide ayuda, le escucharé, porque soy misericordioso. ");
INSERT INTO spavbl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“No desprecies a Dios ni maldigas al líder de tu pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“No retengas las ofrendas requeridas de tus productos, aceite de oliva y vino. Debes darme el primogénito de tus hijos. ");
INSERT INTO spavbl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","También debes darme el primogénito de tus vacas, ovejas y cabras. Podrás dejarlos con sus madres durante los primeros siete días, pero debes darmelos al octavo día. ");
INSERT INTO spavbl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Ustedes deben ser un pueblo santo para mí. No coman ningún cadáver de animal que encuentren en el campo y que haya sido asesinado por animales salvajes. Láncenlos a los perros para que se lo coman”. ");
INSERT INTO spavbl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“No ayudes a difundir historias que son mentiras. No ayudes a la gente mala dando mal testimonio. ");
INSERT INTO spavbl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“No sigas a la multitud haciendo el mal. Cuando testifiques en un juicio, no corrompas la justicia poniéndote del lado de la mayoría. ");
INSERT INTO spavbl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tampoco muestres favoritismo hacia los pobres en sus casos legales. ");
INSERT INTO spavbl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Si te encuentras con el buey o asno de tu enemigo que se ha extraviado, devuélveselo. ");
INSERT INTO spavbl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si ves el asno de alguien que te odia y que ha caído porel peso de su carga, no lo dejes ahí. Debes detenerte y ayudarle. ");
INSERT INTO spavbl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“No debes impedir que los pobres obtengan justicia en sus demandas. ");
INSERT INTO spavbl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","No tengas nada que ver con hacer falsas acusaciones. No maten a los inocentes ni a los que hacen el bien, porque no dejaré que los culpables queden impunes. ");
INSERT INTO spavbl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“No aceptes sobornos, porque un soborno ciega a los que pueden ver y socava las pruebas de los honestos. ");
INSERT INTO spavbl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“No abusen de los extranjeros que viven entre ustedes, pues ustedes saben muy bien lo que es ser extranjeros, ya que una vez fueron extranjeros en Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Seis años deben sembrar la tierra y cosechar los cultivos, ");
INSERT INTO spavbl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","pero en el séptimo año deben dejarla descansar y dejarla sin cultivar, para que los pobres puedan comer lo que crece naturalmente en el campo y los animales salvajes puedan terminar lo que queda. Sigan el mismo procedimiento para sus viñedos y olivares. ");
INSERT INTO spavbl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Tendrán seis días para hacer su trabajo, pero el séptimo día deben dejar de trabajar, para que su buey y su asno puedan descansar, y las familias de sus esclavos puedan recuperar el aliento, así como los extranjeros que viven entre ustedes. ");
INSERT INTO spavbl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Asegúrate de prestar atención a todo lo que te he dicho. Que no pase por tu mente invocar el nombre de otros dioses, ni siquiera debes mencionarlos. ");
INSERT INTO spavbl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Tres veces al año celebrarán una fiesta dedicada a mí. ");
INSERT INTO spavbl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Deben observar el Festival de los Panes sin Levadura como se los he instruído. Deben comer pan sin levadura durante siete días en el momento apropiado en el mes de Abib, porque ese fue el mes en que saliste de Egipto. Nadie puede venir delante mí sin traer una ofrenda. ");
INSERT INTO spavbl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Y también observarán el Festival de las Cosechas cuando presenten las primicias de los productos de lo que hayan sembrado en los campos. Por último, deben observar el Festival de la Cosecha al final del año, cuando recojan la cosecha del resto de tus cultivos en el campo. ");
INSERT INTO spavbl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Todo varón israelita debe presentarse ante el Señor Dios en estas tres ocasiones cada año. ");
INSERT INTO spavbl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“No ofrecerán la sangre de mis sacrificios junto con nada que contenga levadura, y la grasa de las ofrendas presentadas en mi festival no debe dejarse hasta la mañana. ");
INSERT INTO spavbl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Traigan las mejores primicias de sus cosechas a la casa del Señor su Dios. No cocinarán a un cabrito en la leche de su madre. ");
INSERT INTO spavbl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Yo envío un ángel delante de ti para que te proteja en el camino y te lleve al lugar que te he preparado. ");
INSERT INTO spavbl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Asegúrate de prestarle atención y hacer lo que te diga. No te opongas a él, porque no perdonará la rebelión, pues lleva mi autoridad. ");
INSERT INTO spavbl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Sin embargo, si le escuchas atentamente y haces todo lo que te digo, entonces seré enemigo de tus enemigos y lucharé contra los que luchan contra ti. ");
INSERT INTO spavbl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Porque mi ángel irá delante de ti y te llevará a la tierra de los amorreos, hititas, ferezeos, cananeos, heveos y jebuseos, y los aniquilaré. ");
INSERT INTO spavbl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","No debes inclinarte ante sus dioses ni adorarlos, ni seguir sus prácticas paganas. Más bien destruirás sus ídolos y derribarás sus altares. ");
INSERT INTO spavbl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Adorarás al Señor tu Dios, y él bendecirá tu comida y tu agua. Me aseguraré de que ninguno de ustedes se enferme. ");
INSERT INTO spavbl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ninguna mujer tendrá un aborto espontáneo ni se quedará sin hijos. Me aseguraré de que vivan una larga vida. ");
INSERT INTO spavbl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Enviaré un terror sobre mí delante de ustedes que hará que todas las naciones que los conozcan entren en pánico. Haré que todos sus enemigos se den la vuelta y huyan. ");
INSERT INTO spavbl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Y enviaré avispones delante de ti para expulsar a los heveos, cananeos e hititas. ");
INSERT INTO spavbl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","No los expulsaré en un año, porque la tierra se volvería desolada y tendrías que enfrentarte a un mayor número de animales salvajes. ");
INSERT INTO spavbl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Poco a poco los expulsaré delante de ti, hasta que haya suficientes para tomar posesión de la tierra. ");
INSERT INTO spavbl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Fijaré sus fronteras desde el Mar Rojo hasta el Mar de los Filisteos, y desde el desierto hasta el río Éufrates. Te entregaré los habitantes de la tierra y tú los expulsarás. ");
INSERT INTO spavbl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","No debes hacer ningún acuerdo con ellos ni con sus dioses. ");
INSERT INTO spavbl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","No se les debe permitir permanecer en tu tierra, de lo contrario te llevarán a pecar contra mí. Porque si adoras a sus dioses, definitivamente se convertirán en una trampa para ti”. ");
INSERT INTO spavbl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","El Señor le dijo a Moisés: “Subana la presencia del Señor, tú y Aarón, Nadab y Abiú, y setenta de los ancianos de Israel. Deben adorar a distancia. ");
INSERT INTO spavbl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Sólo Moisés puede acercarse al Señor, los demás no deben acercarse. El pueblo no puede subir al monte con él”. ");
INSERT INTO spavbl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moisés fue y le dijo al pueblo todas las instrucciones y reglamentos del Señor. Todos respondieron juntos: “¡Haremos todo lo que el Señor diga!” ");
INSERT INTO spavbl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moisés escribió todo lo que el Señor había dicho. Se levantó temprano a la mañana siguiente y construyó un altar al pie de la montaña, y levantó doce pilares para cada una de las doce tribus de Israel. ");
INSERT INTO spavbl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Luego envió a algunos jóvenes israelitas que fueron y ofrecieron holocaustos y sacrificaron toros jóvenes como ofrendas de paz al Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moisés puso la mitad de la sangre en tazones y roció la otra mitad en el altar. ");
INSERT INTO spavbl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Luego tomó el Libro del Acuerdo y se lo leyó al pueblo. Ellos respondieron: “Haremos todo lo que el Señor diga. Obedeceremos”. ");
INSERT INTO spavbl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Entonces Moisés tomó la sangre, la roció sobre el pueblo y dijo: “Mira, esta es la sangre del pacto que el Señor ha hecho contigo siguiendo estos términos”. ");
INSERT INTO spavbl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Entonces Moisés y Aarón, Nadab y Abiú, y setenta de los ancianos de Israel subieron al monte, ");
INSERT INTO spavbl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","y vieron al Dios de Israel. Bajo sus pies había algo así como un pavimento de azulejos hecho de lapislázuli, tan azul claro como el propio cielo. ");
INSERT INTO spavbl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Pero Dios no hirió a los líderes de Israel. Ellos lo vieron, y luego comieron y bebieron una comida sagrada. ");
INSERT INTO spavbl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Entonces el Señor le dijo a Moisés: “Sube a mí al monte y quédate aquí, para que te dé las tablas de piedra, con las instrucciones y órdenes que he escrito para que las aprendan”. ");
INSERT INTO spavbl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Así que Moisés se fue con Josué su ayudante y subió a la montaña de Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Les dijo a los ancianos: “Quédense aquí y esperen a que volvamos. Aarón y Hur están contigo. Si alguien tiene un problema, puede hablar con ellos”. ");
INSERT INTO spavbl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Cuando Moisés subió a la montaña, la nube la cubrió. ");
INSERT INTO spavbl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","La gloria del Señor descendió sobre el Monte Sinaí, cubriéndolo durante seis días. En el séptimo día, el Señor llamó a Moisés desde dentro de la nube. ");
INSERT INTO spavbl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Para los israelitas la gloria del Señor parecía un fuego ardiente en la cima de la montaña. ");
INSERT INTO spavbl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moisés subió a la nube cuando subió a la montaña, y permaneció en la montaña durante cuarenta días y noches. ");
INSERT INTO spavbl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ordena a los israelitas que me traigan una ofrenda. Recibirás mi ofrenda de todos los que quieran darla. ");
INSERT INTO spavbl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Estos son los artículos que debes aceptar de ellos como contribuciones: oro, plata y bronce; ");
INSERT INTO spavbl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","hilos azules, púrpura y carmesí; lino y pelo de cabra finamente hilados; ");
INSERT INTO spavbl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","pieles de carnero curtidas y cuero fino; madera de acacia; ");
INSERT INTO spavbl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","aceite de oliva para las lámparas; especias para el aceite de oliva usado en la unción y para el incienso fragante; ");
INSERT INTO spavbl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","y piedras de ónix y otras gemas para ser usadas en la fabricación del efod y el pectoral. ");
INSERT INTO spavbl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Me harán un santuario para que pueda vivir entre ellos. ");
INSERT INTO spavbl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Debes hacer el Tabernáculo y todos sus muebles según el diseño que te voy a mostrar. ");
INSERT INTO spavbl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Deben hacer un Arca de madera de acacia que mida dos codos y medio de largo por codo y medio de ancho por codo y medio de alto. ");
INSERT INTO spavbl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Cúbranla con oro puro por dentro y por fuera, y hagan un adorno de oro para rodearla. ");
INSERT INTO spavbl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Fundirán cuatro anillos de oro y fijarlos a sus cuatro pies, dos en un lado y dos en el otro. ");
INSERT INTO spavbl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Harán palos de madera de acacia y cubrirlos con oro. ");
INSERT INTO spavbl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Colocarán las varas en los anillos de los lados del Arca, para que pueda ser transportada. ");
INSERT INTO spavbl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Las varas deben permanecer en los anillos del Arca; no las saques. ");
INSERT INTO spavbl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Pongan dentro del Arca el testimonio que os voy a dar. ");
INSERT INTO spavbl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Harás una tapa de expiación de oro puro, de dos codos y medio de largo por codo y medio de ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Haz dos querubines de oro forjado para los extremos de la cubierta de la expiación, ");
INSERT INTO spavbl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","y pon un querubín en cada extremo. Todo esto debe ser hecho a partir de una sola pieza de oro. ");
INSERT INTO spavbl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Los querubines deben ser diseñados con alas extendidas apuntando hacia arriba, cubriendo la cubierta de expiación. Los querubines se colocarán uno frente al otro, mirando hacia abajo, hacia la cubierta de expiación. ");
INSERT INTO spavbl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Pondrán la cubiertade expiación encima del Arca, y también podrán el testimonio que les daré dentro del Arca. ");
INSERT INTO spavbl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Me reuniré contigo allí como está dispuesto sobre la tapa de la expiación, entre los dos querubines que están de pie sobre el Arca del Testimonio, y hablaré contigo sobre todas las órdenes que daré a los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Entonces harás una mesa de madera de acacia de dos codos de largo por un codo de ancho por un codo y medio de alto. ");
INSERT INTO spavbl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Cúbrela con oro puro y haz un adorno de oro para rodearla. ");
INSERT INTO spavbl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Haz un borde a su alrededor del ancho de una mano y pon un ribete de oro en el borde. ");
INSERT INTO spavbl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Haz cuatro anillos de oro para la mesa y sujétalos a las cuatro esquinas de la mesa por las patas. ");
INSERT INTO spavbl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Los anillos deben estar cerca del borde para sostener los palos usados para llevar la mesa. ");
INSERT INTO spavbl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Haránlas varas de madera de acacia para llevar la mesa y las cubrirán con oro. ");
INSERT INTO spavbl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Harán platos y fuentes para la mesa, así como jarras y tazones para verter las ofrendas de bebida. Todos serán de oro puro. ");
INSERT INTO spavbl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Pongan el Pan de la Presencia sobre la mesa para que esté siempre en mi presencia. ");
INSERT INTO spavbl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Haz un candelabro de oro puro, modelado con martillo. Todo debe ser hecho de una sola pieza: su base, su eje, sus copas, sus capullos y sus flores. ");
INSERT INTO spavbl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Debe tener seis ramas que salgan de los lados del candelabro, tres en cada lado. ");
INSERT INTO spavbl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tiene tres tazas en forma de flores de almendra en la primera rama, cada una con capullos y pétalos, tres en la siguiente rama. Cada una de las seis ramas que salen tendrá tres tazas en forma de flores de almendra, todas con brotes y pétalos. ");
INSERT INTO spavbl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","“En el eje principal del candelabro se harán cuatro tazas en forma de flores de almendra, con capullos y pétalos. ");
INSERT INTO spavbl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","En las seis ramas que salen del candelabro, colocarás un capullo bajo el primer par de ramas, un capullo bajo el segundo par y un capullo bajo el tercer par. ");
INSERT INTO spavbl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Los brotes y las ramas deben hacerse con el candelabro como una sola pieza, modelada con martillo en oro puro. ");
INSERT INTO spavbl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Hagan siete lámparas y colóquenlas en el candelabro para que iluminen el área que está delante de él. ");
INSERT INTO spavbl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Las pinzas de la mecha y sus bandejas deben ser de oro puro. ");
INSERT INTO spavbl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","El candelabro y todos estos utensilios requerirán un talento de oro puro. ");
INSERT INTO spavbl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Asegúrate de hacer todo de acuerdo con el diseño que te mostré en la montaña”. ");
INSERT INTO spavbl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Harás diez cortinas para el Tabernáculo de lino finamente hilado, usando hilos azules, púrpura y carmesí. Háganlas bordar con querubines por alguien que sea hábil en el bordado. ");
INSERT INTO spavbl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Cada cortina debe medir 28 codos de largo por 4 codos de ancho, y todas las cortinas deben ser del mismo tamaño. ");
INSERT INTO spavbl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Junta cinco de las cortinas y haz lo mismo con las otras cinco. ");
INSERT INTO spavbl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Usa material azul para hacer lazos en el borde de la última cortina de ambos juegos. ");
INSERT INTO spavbl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Haz cincuenta lazos en una cortina y cincuenta lazos en la última cortina del segundo juego, alineando los lazos entre sí. ");
INSERT INTO spavbl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Luego haz cincuenta ganchos de oro y une las cortinas con los ganchos, para que el Tabernáculo sea una sola estructura. ");
INSERT INTO spavbl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Haz once cortinas de pelo de cabra como una tienda de campaña para cubrir el Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Cada una de las once cortinas debe ser del mismo tamaño: 30 codos de largo por 4 codos de ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Unirás cinco de las cortinas como un conjunto y las otras seis como otro conjunto. Luego dobla la sexta cortina en dos en la parte delantera de la tienda. ");
INSERT INTO spavbl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Haz cincuenta lazos en el borde de la última cortina del primer juego, y cincuenta lazos a lo largo del borde de la última cortina del segundo juego. ");
INSERT INTO spavbl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Harás cincuenta ganchos de bronce y póngalos en los lazos para unir la tienda como una sola cubierta. ");
INSERT INTO spavbl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","La media cortina extra de esta cubierta de la tienda se dejará colgada en la parte trasera del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Las cortinas de la tienda serán un codo más largas en cada lado, y la longitud extra colgará sobre los lados del Tabernáculo para que quede todo cubierto. ");
INSERT INTO spavbl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Harás una cubierta para la tienda con pelo de cabra y pieles de carnero curtidas, y colocarás una cubierta extra de cuero fino sobre ella. ");
INSERT INTO spavbl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Hagan un marco vertical de madera de acacia para el Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Cada estructura debe tener diez codos de largo por uno y medio de ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Cada marco tendrá dos clavijas para que los marcos puedan ser conectados entre sí. Hagan todos los marcos del Tabernáculo así. ");
INSERT INTO spavbl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Haz veinte marcos para el lado sur del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Haz cuarenta soportes de plata como apoyo para los veinte marcos usando dos soportes por marco, uno debajo de cada clavija del marco. ");
INSERT INTO spavbl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","De manera similar para el lado norte del Tabernáculo, harás veinte marcos ");
INSERT INTO spavbl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","y cuarenta soportes de plata, dos soportes por marco. ");
INSERT INTO spavbl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Harás seis marcos para la parte trasera (lado oeste) del Tabernáculo, ");
INSERT INTO spavbl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","junto con dos marcos para sus dos esquinas traseras. ");
INSERT INTO spavbl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Unirás estos marcos de las esquinas en la parte inferior y en la parte superior cerca del primer anillo. Así es como debes hacer los dos marcos de las esquinas. ");
INSERT INTO spavbl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","En total habrá ocho marcos y dieciséis soportes de plata, dos debajo de cada marco. ");
INSERT INTO spavbl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Haz cinco barras transversales de madera de acacia para unir los marcos del lado sur del Tabernáculo, ");
INSERT INTO spavbl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","cinco para los del norte y cinco para los de la parte trasera del Tabernáculo, al oeste. ");
INSERT INTO spavbl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","El travesaño central que se coloca a mitad de camino de los marcos irá de un extremo al otro. ");
INSERT INTO spavbl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Cubrid los marcos con oro, y haced anillos de oro para sujetar los travesaños en su sitio. Cubrir los travesaños con oro también. ");
INSERT INTO spavbl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ensambla el Tabernáculo siguiendo el diseño que te mostré en la montaña. ");
INSERT INTO spavbl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Haz un velo de hilo azul, púrpura y carmesí, y de lino finamente hilado, bordado con querubines por alguien que sea hábil en el bordado. ");
INSERT INTO spavbl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Con ganchos de oro, cuélgalo de cuatro postes de madera de acacia cubiertos de oro, sostenidos por cuatro soportes de plata. ");
INSERT INTO spavbl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Coloca el velo bajo el gancho y pon el Arca del Testimonio dentro, detrás del velo. El velo separará el Lugar Santo del Lugar Santísimo. ");
INSERT INTO spavbl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Pon la cubierta de expiación en el Arca del Testimonio en el Lugar Santísimo. ");
INSERT INTO spavbl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Pon la mesa fuera del velo en el lado norte del Tabernáculo y pon el candelabro enfrente en el lado sur. ");
INSERT INTO spavbl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Haz una pantalla para la entrada de la tienda usando hilos azules, púrpura y carmesí, y lino finamente hilado y hazlo bordado. ");
INSERT INTO spavbl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Haz cinco postes de madera de acacia con ganchos de oro para colgar el biombo, y funde cinco soportes de bronce para sujetarlos. ");
INSERT INTO spavbl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Haz un altar de madera de acacia. Debe ser cuadrado y debe medir cinco codos de largo por cinco codos de ancho por tres codos de alto. ");
INSERT INTO spavbl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Haráscuernos para cada una de sus esquinas, todos de una sola pieza con el altar, y cubrirás todo el altar con bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Harás todos sus utensilios de bronce: cubos para quitar las cenizas, palas, tazones para rociar, tenedores para la carne y cacerolas. ");
INSERT INTO spavbl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Hagan una rejilla de malla de bronce para él con un anillo de bronce en cada una de sus esquinas. ");
INSERT INTO spavbl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Coloquen la rejilla bajo el saliente del altar, de modo que la malla llegue hasta la mitad del altar. ");
INSERT INTO spavbl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Haz postes de madera de acacia para el altar y cúbrelos con bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Las varas deben ser colocadas en los anillos para que las varas estén a cada lado del altar cuando sea llevado. ");
INSERT INTO spavbl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hagan el altar hueco, usando tablas, tal como te lo mostré en la montaña. ");
INSERT INTO spavbl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Haz un patio para el Tabernáculo. Para el lado sur del patio haz cortinas de lino finamente hilado, de cien codos de largo por un lado, ");
INSERT INTO spavbl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","con veinte postes y veinte soportes de bronce, con ganchos y bandas de plata en los postes. ");
INSERT INTO spavbl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Del mismo modo, en el lado norte se colocarán cortinas en una disposición idéntica. ");
INSERT INTO spavbl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Las cortinas del lado oeste del patio tendrán cincuenta codos de ancho, con diez postes y diez soportes. ");
INSERT INTO spavbl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","El lado este del patio que da al amanecer tendrá 50 codos de ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Las cortinas de un lado deben tener quince codos de largo, con tres postes y tres soportes, ");
INSERT INTO spavbl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","y las cortinas del otro lado deben ser iguales. ");
INSERT INTO spavbl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","La entrada al patio debe tener veinte codos de ancho, con una cortina bordada con hilos azules, púrpura y carmesí, y lino finamente hilado, sostenida por cuatro postes y cuatro soportes. ");
INSERT INTO spavbl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Todos los postes alrededor del patio tendrán bandas de plata, ganchos de plata y soportes de bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Todo el patio tendrá cien codos de largo y cincuenta de ancho, con cortinas de lino finamente hilado de cinco codos de alto, y con soportes de bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Todo el resto del equipo usado en el Tabernáculo, incluyendo las estacas de la tienda y las del patio, serán de bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Debes ordenar a los israelitas que te traigan aceite de oliva puro, prensado a mano, para las lámparas, para que puedan seguir encendidas, dando luz. ");
INSERT INTO spavbl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Enel Tabernáculo de Reunión, fuera del velo delante del Testimonio, Aarón y sus hijos mantendrán las lámparas encendidas en presencia del Señor desde la tarde hasta la mañana. Este requisito debe ser observado por los israelitas durante todas las generaciones. ");
INSERT INTO spavbl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Haz que tu hermano Aarón venga a ti, junto con sus hijos Nadab, Abiú, Eleazar e Itamar. Ellos, de todos los israelitas, me servirán como sacerdotes. ");
INSERT INTO spavbl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Harás que se hagan ropas sagradas para tu hermano Aarón para que se vea espléndido y digno. ");
INSERT INTO spavbl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Debes dar instrucciones a todos los obreros hábiles, a los que han recibido de mí sus habilidades, sobre cómo hacer la ropa para la dedicación de Aarón, para que pueda servirme como sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Estas son las ropas que deben hacer: un pectoral, un efod, una túnica, una túnica plisada, un turbante y una faja. Estos son los vestidos sagrados que harán para tu hermano Aarón y sus hijos para que puedan servirme como sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Los trabajadores usarán hilo de oro, junto con hilo azul, púrpura y carmesí, y lino finamente hilado. ");
INSERT INTO spavbl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Harán el efod de lino finamente tejido y bordado con oro, y con hilos azules, púrpura y carmesí, hábilmente trabajado. ");
INSERT INTO spavbl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Dos piezas de hombro deben ser unidas a las piezas delanteras y traseras. ");
INSERT INTO spavbl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","La cintura del efod será una pieza hecha de la misma manera, usando hilo de oro, con hilo azul, púrpura y carmesí, y con lino finamente tejido. ");
INSERT INTO spavbl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Escribe en dos piedras de ónice los nombres de las tribus de Israel, ");
INSERT INTO spavbl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","seis nombres en una piedra, y seis en la otra, en orden de nacimiento. ");
INSERT INTO spavbl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Escribe los nombres en las dos piedras de la misma manera que un joyero graba un sello personal. Luego coloque las piedras en un adorno de oro. ");
INSERT INTO spavbl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ata ambas piedras a las piezas del hombro del efod como recordatorio para las tribus israelitas. Aarón debe llevar sus nombres en sus dos hombros para recordar a los israelitas que los representa cuando va a la presencia del Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Hagan adornos de oro ");
INSERT INTO spavbl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","y dos cadenas trenzadas de oro puro, y sujetar estas cadenas a los adornos. ");
INSERT INTO spavbl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","También debe hacer un pectoral para las decisiones de la misma manera hábil que el efod, para ser usado en la determinación de la voluntad del Señor. Háganlo usando hilo de oro, con hilo azul, púrpura y carmesí, y con lino finamente tejido. ");
INSERT INTO spavbl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Tiene que ser cuadrado cuando se pliega, midiendo alrededor de nueve pulgadas de largo y ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Adjunta un arreglo de piedras preciosas en cuatro filas como sigue: En la primera fila cornalina, peridoto y esmeralda. ");
INSERT INTO spavbl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","En la segunda fila turquesa, lapislázuli y sardónice. ");
INSERT INTO spavbl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","En la tercera fila jacinto, ágata y amatista. ");
INSERT INTO spavbl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","En la cuarta fila topacio, berilo y jaspe. Coloca estas piedras en los adornos de oro. ");
INSERT INTO spavbl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Cada una de las doce piedras se grabará como un sello personal con el nombre de una de las doce tribus israelitas y las representará. ");
INSERT INTO spavbl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Haz cordones de cadenas trenzadas de oro puro para sujetar el pectoral. ");
INSERT INTO spavbl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Harás dos anillos de oro y sujételos a las dos esquinas superiores del pectoral. ");
INSERT INTO spavbl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ata las dos cadenas de oro a los dos anillos de oro de las esquinas del pectoral, ");
INSERT INTO spavbl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","y luego ata los extremos opuestos de las dos cadenas a los adornos de oro de los hombros de la parte delantera del efod. ");
INSERT INTO spavbl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Haz dos anillos de oro más y fíjelos a las dos esquinas inferiores del pectoral, en el borde interior junto al efod. ");
INSERT INTO spavbl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Haz dos anillos de oro más y póngalos en la parte inferior de las dos hombreras de la parte delantera del efod, cerca de donde se une a su cintura tejida. ");
INSERT INTO spavbl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ata los anillos del pectoral a los anillos del efod con un cordón de hilo azul, para que el pectoral no se suelte del efod. ");
INSERT INTO spavbl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Así, cada vez que Aarón entre en el Lugar Santo, llevará los nombres de las tribus israelitas sobre su corazón en el pectoral, como un recordatorio constante ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Coloca el Urim y Tumim en el pectoral de la decisión, para que ellos también estén sobre el corazón de Aarón siempre que venga a la presencia del Señor. Aarón llevará continuamente los medios de decisión sobre su corazón ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Haz la túnica que va con el efod exclusivamente de tela azul, ");
INSERT INTO spavbl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","con una abertura en el medio en la parte superior. Cose un cuello tejido alrededor de la abertura para fortalecerla y que no se rompa. ");
INSERT INTO spavbl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Haz las granadas con los hilos azul, púrpura y carmesí y pégalas alrededor de su dobladillo, con campanas de oro entre ellas, ");
INSERT INTO spavbl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","teniendo las campanas de oro y las granadas alternadas. ");
INSERT INTO spavbl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aarón debe llevar la túnica siempre que sirva, y el sonido que haga se oirá cuando entre o salga del santuario al entrar en la presencia del Señor, para que no muera. ");
INSERT INTO spavbl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Haz una placa de oro puro y grabad en ella como un sello, “Consagradoal Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Pónganlo en la parte delantera del turbante con un cordón azul. ");
INSERT INTO spavbl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aarón lo llevará en la frente, para que se responsabilice de la culpa de las ofrendas que hagan los israelitas, y esto se aplica a todas sus santas ofrendas. Debe permanecer siempre en su frente para que el pueblo sea aceptado en la presencia del Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Teje la túnica con lino finamente hilado y haz el turbante del mismo material, y también haz la faja y con bordado. ");
INSERT INTO spavbl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Haz túnicas, fajas y tocados para los hijos de Aarón, para que tengan un aspecto espléndido y digno. ");
INSERT INTO spavbl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Haz que tu hermano Aarón y sus hijos vistan esta ropa y luego úngelos y ordénalos. Dedícalos para que puedan servirme como sacerdotes. ");
INSERT INTO spavbl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Elabora calzoncillos de lino para cubrir sus cuerpos desnudos, desde la cintura hasta el muslo. ");
INSERT INTO spavbl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aarón y sus hijos deben usarlos cuando entren a el Tabernáculo de Reunión o cuando se acerquen al altar para servir en el Lugar Santo, para que no seanhallados culpables y mueran. Esta es una ley para Aarón y sus descendientes para siempre. ");
INSERT INTO spavbl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Así es como debes proceder para dedicarlos y que me sirvan como sacerdotes. Coge un novillo y dos carneros sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Luego, con la mejor harina de trigo, haced lo siguiente sin levadura: pan, pasteles mezclados con aceite de oliva y barquillos espolvoreados con aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ponlos todos en una cesta y tráelos como ofrenda, junto con el toro y los dos carneros. ");
INSERT INTO spavbl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Lleva a Aarón y a sus hijos a la entrada del Tabernáculo de Reunión y lávalos con agua. ");
INSERT INTO spavbl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Toma los vestidos y pónselos a Aarón: la túnica, el manto del efod, el efod mismo y el pectoral. Ata el efod sobre él con su cinturón. ");
INSERT INTO spavbl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Envuelve el turbante en la cabeza y ata la corona sagrada al turbante. ");
INSERT INTO spavbl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Luego usa el aceite de la unción para ungirlo, vertiéndolo sobre su cabeza. ");
INSERT INTO spavbl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Luego que vengan sus hijos y les pongan las túnicas. ");
INSERT INTO spavbl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ata las fajas alrededor de Aarón y sus hijos y ponles los tocados. El sacerdocio les pertenece para siempre. Así es como debes ordenar a Aarón y a sus hijos. ");
INSERT INTO spavbl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Lleva el toro al frente del Tabernáculo de Reunión, y Aarón y sus hijos deben poner sus manos sobre su cabeza. ");
INSERT INTO spavbl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Luego mata el toro en presencia del Señor a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Toma un poco de la sangre del toro y úntasela con el dedo en los cuernos del altar. Luego vierte el resto de la sangre en la base del altar. ");
INSERT INTO spavbl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tomen toda la grasa que cubre los intestinos, las mejores partes del hígado y los dos riñones con su grasa, y quemadlos en el altar. ");
INSERT INTO spavbl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero quema la carne del toro, su piel y sus excrementos fuera del campamento, pues es una ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","A continuación, que Aarón y sus hijos pongan sus manos en la cabeza de uno de los carneros. ");
INSERT INTO spavbl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sacrifiquen el carnero, tomen su sangre y salpicaalrededor del altar. ");
INSERT INTO spavbl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Corta el carnero en pedazos, lava los intestinos y las piernas, y ponlos con los otros pedazos y con la cabeza. ");
INSERT INTO spavbl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Luego quema todo el carnero en el altar. Es una ofrenda quemada al Señor para ser aceptada por él. ");
INSERT INTO spavbl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Entonces haz que Aarón y sus hijos coloquen sus manos sobre la cabeza del otro carnero. ");
INSERT INTO spavbl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Luegosacrifica el carnero y pon un poco de su sangre en los lóbulos de las orejas derechas de Aarón y sus hijos, en los pulgares de sus manos derechas y en los dedos gordos de sus pies derechos. Salpica el resto de su sangre alrededor del altar. ");
INSERT INTO spavbl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Toma un poco de la sangre del altar y un poco del aceite de la unción y rociadlo sobre Aarón y sus ropas, y sobre sus hijos y sus ropas. Entonces él y sus ropas serán sagradas, así como sus hijos y sus ropas. ");
INSERT INTO spavbl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Toma la grasa del carnero, incluyendo la grasa de su amplio rabo, la grasa que cubre los intestinos, las mejores partes del hígado, los dos riñones con su grasa, así como el muslo derecho (porque este es un carnero para la ordenación). ");
INSERT INTO spavbl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Toma también una barra de pan, una torta de pan hecha con aceite de oliva y una oblea de la cesta de pan hecho sin levadura que está en la presencia del Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Dáselos todos a Aarón y a sus hijos para que los mezan ante el Señor como ofrendamecida. ");
INSERT INTO spavbl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Luego toma los diferentes panes y quémalos en el altar sobre el holocausto, para que sean agradables para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Toma el pecho del carnero de la ordenación de Aarón y mécelo ante el Señor como ofrenda mecida. Esta es la parte que puedes guardar. ");
INSERT INTO spavbl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Separa para Aarón y sus hijos el pecho de la ofrenda mecida y el muslo de la ofrenda mecida, ambos tomados del carnero de la ordenación. ");
INSERT INTO spavbl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","De ahora en adelante, cuando los israelitas levanten las ofrendas de paz al Señor, estas partes pertenecerán a Aarón y a sus hijos para siempre como una parte regular de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Las vestiduras sagradas que tiene Aarón serán transmitidas a sus descendientes, para que las lleven cuando sean ungidos y ordenados. ");
INSERT INTO spavbl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","El descendiente que le suceda como sacerdote y entre al Tabernáculo de Reunión para servir en el Lugar Santo deberá llevarlas durante los siete días de su ordenación. ");
INSERT INTO spavbl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Toma el carnero de la ordenación y hierve su carne en un lugar sagrado. ");
INSERT INTO spavbl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aarón y sus hijos comerán la carne del carnero y el pan que está en la cesta, a la entrada del Tabernáculo de Reunión, ");
INSERT INTO spavbl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Comerán la carne y el pan que formaban parte de las ofrendas que simbolizaban el perdón requerido para su ordenación y dedicación. Nadie más puede comerlos, porque son sagrados. ");
INSERT INTO spavbl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Si alguna de las carnes de la ordenación o algún pan permanece hasta la mañana siguiente, quemen lo que sobre. No debe ser comido, porque es sagrado. ");
INSERT INTO spavbl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Este es el proceso que debes seguir para Aarón y sus hijos, observando todas las instrucciones que les he dado. La ordenación durará siete días. ");
INSERT INTO spavbl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Cada día debes sacrificar un toro como ofrenda para el perdón por el pecado. Al hacer esto, el altar necesita ser purificado. Úngelo para hacerlo sagrado. ");
INSERT INTO spavbl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Durante siete días purificarás el altar y lo consagrarás. Entonces el altar se volverá completamente santo, y todo lo que toque el altar se volverá santo. ");
INSERT INTO spavbl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ofrecerás dos corderos de un año en el altar, diaria y continuamente. ");
INSERT INTO spavbl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Por la mañana ofrece un cordero y por la tarde, antes de que oscurezca, ofrece el otro. ");
INSERT INTO spavbl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Con el primer cordero ofrece también una décima parte de una efa de harina de la mejor calidad, mezclada con un cuarto de hin de aceite de oliva, y una libación de un cuarto de hin de vino. ");
INSERT INTO spavbl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Entonces ofrece el segundo cordero por la tarde, con las mismas ofrendas de grano y bebida que por la mañana, un holocausto al Señor y aceptado por él. ");
INSERT INTO spavbl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Estos holocaustos se harán continuamente por todas las generaciones a la entrada del Tabernáculo de Reunión en presencia del Señor. Allí me reuniré para hablar con ustedes. ");
INSERT INTO spavbl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Me reuniré con los israelitas allí, y ese lugar será sagrado por mi gloria. ");
INSERT INTO spavbl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","De esta manera dedicaré el Tabernáculo de Reunión y el altar, y dedicaré a Aarón y sus hijos a servirme como sacerdotes. ");
INSERT INTO spavbl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Entonces viviré con los israelitas y seré su Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ellos sabrán que soy el Señor su Dios, que los sacó de Egipto, para poder vivir con ellos. Yo soy el Señor su Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Haz un altar de madera de acacia para quemar incienso. ");
INSERT INTO spavbl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Será cuadrado, medirá un codo por codo, de dos codos de alto, con cuernos en sus esquinas que son todos de una sola pieza con el altar. ");
INSERT INTO spavbl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Cubre su parte superior, su lado y sus cuernos con oro puro, y hace un adorno de oro para rodearlo. ");
INSERT INTO spavbl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Hagan dos anillos de oro para el altar y pónganlos debajo de la moldura, dos a ambos lados, para sostener las varas para llevarlo. ");
INSERT INTO spavbl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Haz las varas de madera de acacia y cúbrelas con oro. ");
INSERT INTO spavbl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Pon el altar delante del velo que cuelga delante del Arca del Testimonio y la tapa de expiación que está sobre el Testimonio donde me reuniré con ustedes. ");
INSERT INTO spavbl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aarón debe quemar incienso fragante en el altar cada mañana cuando cuida las lámparas. ");
INSERT INTO spavbl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Cuando enciendas las lámparas por la noche, se debe quemar incienso de nuevo para que hay incienso siempre en la presencia del Señor por las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","No ofrezcas en este altar ningún incienso no aprobado, ni ningún holocausto ni ofrenda de grano, y no derrames sobre él ninguna libación. ");
INSERT INTO spavbl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“Una vez al año, Aarón debe realizar el ritual de expiación poniendo en los cuernos del altar la sangre de la ofrenda por el pecado para la expiación. Este ritual anual de expiación debe ser llevado a cabo por las generaciones futuras. Este es el altar sagrado del Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Cuando hagas un censo de los israelitas, cada hombre debe pagarle al Señor el rescate por su vida cuando sea contado. Así no sufrirán la plaga cuando sean contados. ");
INSERT INTO spavbl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Cada uno que pase a esos condados debe dar medio siclo, (usando el estandarte del siclo del santuario, que pesa veinte geras). Este medio siclo es una ofrenda al Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Esta ofrenda al Señor se exige a todos los que tengan veinte años o más. ");
INSERT INTO spavbl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Cuando ofrezcan esta ofrenda como rescatepor sus vidas, los ricos no deben dar más de medio siclo y los pobres no deben dar menos. ");
INSERT INTO spavbl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tomen este dinero pagado por los israelitas y úsenlo para los gastos de los servicios del Tabernáculo de Reunión. Servirá como recordatorio para que los israelitas hagan expiación por sus vidas en presencia del Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Y el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Haz una palangana de bronce con un soporte de bronce para lavar. Colócalo entre el Tabernáculo de Reunión y el altar, y pon agua en él. ");
INSERT INTO spavbl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aarón y sus hijos la usarán para lavarse las manos y los pies. ");
INSERT INTO spavbl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Cada vez que entren en el Tabernáculo de Reunión, se lavarán con agua para no morir. Cuando se acerquen al altar para presentar los holocaustos al Señor, ");
INSERT INTO spavbl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","también deben lavarse para no morir. Este requisito debe ser observado por ellos y sus descendientes por todas las generaciones”. ");
INSERT INTO spavbl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Toma las especias de mejor calidad: 500 siclos de mirra líquida, 250 siclos de canela de olor dulce, 250 siclos de caña aromática, ");
INSERT INTO spavbl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","500 siclos de casia, (pesos usando el estándar del siclo del santuario), y un hin de aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Mezcla todo esto en el aceite de la unción sagrada, una mezcla aromática como el producto de un experto perfumista. Úsalo como aceite de la unción sagrada. ");
INSERT INTO spavbl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Úsalo para ungir el Tabernáculo de Reunión, el Arca del Testimonio, ");
INSERT INTO spavbl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","la mesa y todo su equipo, el candelabro y su equipo, el altar de incienso, ");
INSERT INTO spavbl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","el altar de los holocaustos y todos sus utensilios, y la vasija más su soporte. ");
INSERT INTO spavbl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Dedícalos para que sean especialmente santos. Todo lo que los toque será sagrado. ");
INSERT INTO spavbl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Unjan a Aarón y a sus hijos también y dedíquenlos para que sirvan como sacerdotes para mí. ");
INSERT INTO spavbl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Diles a los israelitas: ‘Este será mi aceite santo de unción para todas las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","No lo usen en la gente común y no hagan nada parecido usando la misma fórmula. Es santo, y debes tratarlo como si fuera santo. ");
INSERT INTO spavbl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Cualquiera que mezcle aceite de unción como éste, o lo ponga sobre alguien que no sea un sacerdote, será expulsado de su pueblo’”. ");
INSERT INTO spavbl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","El Señor le dijo a Moisés: “Toma cantidades iguales de estas especias aromáticas: resina de bálsamo, perfume, gálbano e incienso puro. ");
INSERT INTO spavbl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Añade un poco de sal y haz incienso puro y santo mezclado como el producto de un experto perfumista. ");
INSERT INTO spavbl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Muele un poco en polvo y colóquelo delante del Arca del Testimonio en el Terbenáculo de Reunión, donde me reuniré contigo. Será especialmente sagrado para ti. ");
INSERT INTO spavbl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Nopreparen ningún incienso como éste usando la misma fórmula. Deben considerar este incienso como sagrado para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Cualquiera que se haga un incienso como este para su propio deleite será expulsado de su pueblo”. ");
INSERT INTO spavbl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“He escogido por nombre a Bezalel, hijo de Uri, hijo de Hur, de la tribu de Judá. ");
INSERT INTO spavbl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Lo he llenado con el Espíritu de Dios dándole habilidad, creatividad y experiencia en todo tipo de artesanías. ");
INSERT INTO spavbl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Puede producir diseños en oro, plata y bronce, ");
INSERT INTO spavbl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","puede tallar piedras preciosas para colocarlas en los marcos, y puede tallar madera. Es un maestro de todas las artes. ");
INSERT INTO spavbl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","“También he elegido a Aholiab, hijo de Ahisamac, de la tribu de Dan, para que le ayude. También he dado a todos los artesanos las habilidades necesarias para hacer todo lo que te he ordenado hacer: ");
INSERT INTO spavbl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“El Tabernáculo de Reunión, el Arca del Testimonio y su tapa de expiación; y todos los demás muebles de la Tienda: ");
INSERT INTO spavbl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","la mesa con su equipamiento, el candelabro de oro puro con todo su equipo, el altar de incienso, ");
INSERT INTO spavbl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","el altar del holocausto con todos sus utensilios, y la palangana más su soporte; ");
INSERT INTO spavbl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","así como las ropas tejidas tanto para Aarón el sacerdote como para sus hijos para servir como sacerdotes, ");
INSERT INTO spavbl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","así como el aceite de unción y el incienso fragante para el Lugar Santo. Deben hacerlos siguiendo todas las instrucciones que les he dado”. ");
INSERT INTO spavbl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Dile a los israelitas, ‘Es absolutamente esencial que guarden mis sábados. El sábado será una señal entre ustedes y yo para las generaciones futuras, para que sepan que yo soy el Señor que los santifica. ");
INSERT INTO spavbl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Guardarán el sábado porque es santo para ustedes. Cualquiera que lo deshonre debe ser asesinado. Cualquiera que trabaje en ese día debe ser cortado de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Seis días podrán trabajar, pero el séptimo día será un día de descanso, santo para el Señor. Cualquiera que trabaje en el día de descanso debe ser asesinado. ");
INSERT INTO spavbl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Los israelitas deben guardar el sábado, observando el sábado como un acuerdo eterno para las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Es una señal entre los israelitas y yo para siempre, porque el Señor hizo los cielos y la tierra en seis días, pero en el séptimo día se detuvo y descansó’”. ");
INSERT INTO spavbl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Cuando el Señor terminó de hablar con Moisés en el Monte Sinaí, le dio las dos tablas del Testimonio, tablas de piedra escritas por el dedo de Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Cuando el pueblo se dio cuenta de cuánto tiempo tardaba Moisés en bajar de la montaña, fueron juntos a ver a Aarón. Le dijeron: “¡Levántate! Haznos unos dioses que nos guíen porque este hombre, Moisés, que nos sacó de la tierra de Egipto, no sabemos qué le ha pasado”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","“Tráiganme los pendientes de oro que llevan sus esposas, hijos e hijas”, respondió Aarón. ");
INSERT INTO spavbl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Así que todos se quitaron los pendientes de oro que llevaban puestos y se los llevaron a Aarón. ");
INSERT INTO spavbl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Él tomó lo que le dieron y usando una herramienta moldeó un ídolo con forma de becerro. Gritaron: “Israel, estos son los dioses que te sacaron de la tierra de Egipto”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Cuando Aarón vio esto, edificó un altar frente al becerro de oro y gritó: “¡Mañana será una fiesta para honrar al Señor!” ");
INSERT INTO spavbl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Al día siguiente, temprano, sacrificaron ofrendas quemadas y presentaron ofrendas de paz. Luego se sentaron a celebrar con comida y bebida. Luego se levantaron para bailar, y se convirtió en una orgía. ");
INSERT INTO spavbl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Entonces el Señor le dijo a Moisés, “Baja, porque tu pueblo, el que sacaste de Egipto está actuando inmoralmente. ");
INSERT INTO spavbl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Han abandonado rápidamente el camino que les ordené seguir. Se han hecho un ídolo de metal con forma de becerro, inclinándose ante él en adoración y ofreciéndole sacrificios. Dicen: ‘Estos son los dioses que los sacaron de la tierra de Egipto’”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“Sé cómo es este pueblo”, continuó diciendo el Señor a Moisés. “¡Son tan rebeldes! ");
INSERT INTO spavbl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","¡Ahora déjame! Estoy enfadado con ellos... ¡Déjame acabar con ellos! Te convertiré en una gran nación”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pero Moisés suplicó al Señor su Dios, diciendo: “¿Por qué estás enojado con el pueblo que sacaste de la tierra de Egipto con tremendo poder y gran fuerza? ");
INSERT INTO spavbl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","¿Por qué permitirás que los egipcios digan ‘los sacó con el malvado propósito de matarlos en las montañas, borrándolos de la faz de la tierra’? Apártate de tu feroz ira. Por favor, arrepiéntete de esta amenaza contra tu pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Recuerda que juraste una promesa a tus siervos Abraham, Isaac y Jacob, diciéndoles: ‘Haré que tu descendencia sea tan numerosa como las estrellas del cielo, y te daré toda la tierra que les prometí, y la poseerán para siempre’”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","El Señor se arrepintió sobre el desastre que amenazó con causar a su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moisés se volvió y bajó del monte, llevando las dos tablas de piedra de la Ley escritas a ambos lados. ");
INSERT INTO spavbl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Dios había hecho las tablas, y Dios mismo había grabado la escritura. ");
INSERT INTO spavbl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Cuando Josué escuchó todos los gritos del campamento, le dijo a Moisés: “¡Suena como una pelea en el campamento!” ");
INSERT INTO spavbl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pero Moisés respondió: “Estos no son los gritos de la victoria o de la derrota. ¡Lo que oigo es gente que está de fiesta!” ");
INSERT INTO spavbl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Al acercarse al campamento vio el ídolo del becerro y el baile. Se enfadó tanto que tiró las tablas de piedra y las rompió allí al pie de la montaña. ");
INSERT INTO spavbl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Tomó el becerro, lo quemó y lo molió en polvo. Luego mezcló esto con agua e hizo que los israelitas la bebieran. ");
INSERT INTO spavbl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Entonces Moisés le preguntó a Aarón: “¿Qué te hizo esta gente para que los hicieras pecar tan mal?” ");
INSERT INTO spavbl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","“Por favor, no te enfades conmigo, mi señor”, respondió Aarón. “Tú mismo sabes cuánto mal es capaz de hacer este pueblo. ");
INSERT INTO spavbl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Me dijeron: ‘Haznos unos dioses que nos guíen porque este hombre, Moisés, que nos sacó de la tierra de Egipto, no sabemos qué le ha pasado’. ");
INSERT INTO spavbl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Entonces les dije: ‘El que tenga joyas de oro, que se las quite y me las dé’. Eché el oro en el horno y salió este becerro”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moisés vio al pueblo enloqueciendo completamente porque Aarón lo había permitido, y que esto les había traído el ridículo de sus enemigos. ");
INSERT INTO spavbl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Así que fue y se paró a la entrada del campamento, y gritó: “¡Quien esté del lado del Señor, que venga y se una a mí!” Y todos los levitas se reunieron a su alrededor. ");
INSERT INTO spavbl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Moisés les dijo: “Esto es lo que dice el Señor, el Dios de Israel: Cada uno amárrese su espada. Luego recorran todo el campamento de un extremo a otro y maten a sus hermanos, amigos y vecinos”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Los levitas hicieron lo que Moisés les había dicho, y ese día alrededor de 3.000 hombres fueron asesinados. ");
INSERT INTO spavbl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moisés les dijo a los levitas: “Hoy han sido dedicados al Señor porque hanactuado contra sus hijos y hermanos. Hoy han ganado una bendición para ustedes mismos”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Al día siguiente Moisés habló al pueblo diciendo: “Han pecado muy mal. Pero ahora subiré al Señor. Tal vez pueda conseguir que perdone su pecado”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Así que Moisés volvió al Señor. Y dijo: “Por favor, el pueblo ha pecado muy mal al hacerse dioses de oro para sí mismos. ");
INSERT INTO spavbl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Pero ahora, si quieres, perdona sus pecados. Si no, bórrame del pergamino en el que guardas tus registros”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Pero el Señor respondió a Moisés: “Los que pecaron contra mí son los que serán borrados de mi pergamino. ");
INSERT INTO spavbl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ahora ve y conduce al pueblo al lugar del que te hablé. Mi ángel irá delante de ti, pero en el momento en que decida castigarlos, los castigaré por su pecado”. ");
INSERT INTO spavbl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","El Señor trajo una plaga sobre el pueblo porque hicieron que Aarón hiciera el becerro. ");
INSERT INTO spavbl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Entonces el Señor le dijo a Moisés: “Deja este lugar, tú y el pueblo que sacaste de Egipto, y ve a la tierra que prometí con juramento dar a Abraham, Isaac y Jacob, diciéndoles: ‘Daré esta tierra a tu descendencia’. ");
INSERT INTO spavbl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Enviaré un ángel delante de ti y expulsaré a los cananeos, amorreos, hititas, ferezeos, heveos y jebuseos. ");
INSERT INTO spavbl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Entra en una tierra que fluye leche y miel, pero no te acompañaré porque eres un pueblo rebelde. De lo contrario, te destruiría en el camino”. ");
INSERT INTO spavbl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Cuando el pueblo escuchó estas palabras de crítica, se pusieron de luto y no se pusieron sus joyas. ");
INSERT INTO spavbl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Porque el Señor ya le había dicho a Moisés: “Dile al pueblo de Israel: ‘Tú eres un pueblo rebelde. Si estuviera contigo un momento, te aniquilaría. Ahora quítate las joyas, y yo decidiré qué hacer contigo’”. ");
INSERT INTO spavbl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Así que los israelitas se quitaron las joyas desde que dejaron el Monte Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moisés solía montar el Tabernáculo de Reunión en las afueras del campamento. Cualquiera que quisiera preguntarle algo al Señor podía ir a el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Cada vez que Moisés salía a la tienda, todo el pueblo iba y se paraba a la entrada de sus tiendas. Lo observaban hasta que entraba. ");
INSERT INTO spavbl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tan pronto como Moisés entraba en la tienda, la columna de nubes descendía y se quedaba en la entrada mientras el Señor hablaba con Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Cuandoel pueblo veía la columna de nubes de pie en la puerta de la tienda, todos se levantaban y se inclinaban en adoración a la entrada de sus tiendas. ");
INSERT INTO spavbl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Moisés hablaba con el Señor cara a cara como si fuera un amigo, y luego regresaba al campamento. Sin embargo, su joven ayudante Josué, hijo de Nun, se quedó en la Tienda. ");
INSERT INTO spavbl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisés le dijo al Señor: “Mira, me has estado diciendo: ‘Ve y dirige a estepueblo’, pero no me has hecho saber a quién vas a enviar conmigo. Y sin embargo has declarado: ‘Te conozco personalmente, x y estoy feliz contigo’. ");
INSERT INTO spavbl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ahora bien, si es cierto que eres feliz conmigo, por favor, enséñame tus caminos para que pueda conocerte y seguir agradándote. Recuerda que la gente de esta nación es tuya”. ");
INSERT INTO spavbl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","El Señor respondió: “Yo mismo iré contigo y te apoyaré”. ");
INSERT INTO spavbl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","“Si no vas con nosotros, por favor no nos saques de aquí”, respondió Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","“¿Cómo sabrán los demás que eres feliz conmigo y con tu pueblo si no nos acompañas? ¿Cómo podría alguien separarnos a mí y a tu pueblo de todos los demás pueblos que viven en la tierra?” ");
INSERT INTO spavbl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","El Señor le dijo a Moisés: “Prometo hacer lo que me pidas, porque soy feliz contigo y te conozco personalmente”. ");
INSERT INTO spavbl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","“Ahora, por favor, revélame tu gloria”, pidió Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","“Haré pasar toda la bondad de mi carácter delante de ti, gritaré el nombre ‘Yahvé’, mostraré gracia a los que les quiero mostrar gracia, y mostraré misericordia a los que les quiero mostrar misericordia. ");
INSERT INTO spavbl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pero no podrás ver mi rostro, porque nadie puede ver mi rostro y vivir”. ");
INSERT INTO spavbl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“Ven aquí y quédate a mi lado en esta roca”, continuó el Señor, ");
INSERT INTO spavbl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","“y a medida que pase mi gloria te pondré en una grieta de la roca y te cubriré con mi mano hasta que haya pasado. ");
INSERT INTO spavbl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Entonces quitaré mi mano y verás mi espalda; pero no verás mi cara”. ");
INSERT INTO spavbl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","El Señor le dijo a Moisés: “Corta dos tablas de piedra como las primeras, y escribiré en ellas de nuevo las mismas palabras que estaban en las primeras tablas, las que tú rompiste. ");
INSERT INTO spavbl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Prepárate por la mañana, y luego sube al Monte Sinaí. Ponte delante de mí en la cima de la montaña. ");
INSERT INTO spavbl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nadie más puede subir contigo. No quiero ver a nadie en ningún lugar de la montaña, y ningún rebaño o manada debe pastar al pie de la montaña”. ");
INSERT INTO spavbl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Entonces Moisés cortó dos tablas de piedra como las anteriores y subió al monte Sinaí por la mañana temprano como el Señor le había ordenado, llevando consigo las dos tablas de piedra. ");
INSERT INTO spavbl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","El Señor descendió en una nube, se puso de pie con él, y llamó el nombre “Yahvé”. ");
INSERT INTO spavbl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","El Señor pasó por delante de él, gritando: “¡Yahvé! Yahvé! ¡Soy el Dios de la gracia y la misericordia! Soy lento para enojarme, lleno de amor eterno, siempre fiel. ");
INSERT INTO spavbl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Sigo mostrando mi amor fiel a miles de personas, perdonando la culpa, la rebelión y el pecado. Pero no dejaré a los culpables impunes, el impacto del pecado afectará no sólo a los padres, sino también a sus hijos y nietos, hasta la tercera y cuarta generación”. ");
INSERT INTO spavbl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moisés se inclinó rápidamente hasta el suelo y adoró. ");
INSERT INTO spavbl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Dijo: “Señor, si es verdad que eres feliz conmigo, por favor acompáñanos. Es cierto que este es un pueblo rebelde, pero por favor perdona nuestra culpa y nuestro pecado. Acéptanos como algo que te pertenece especialmente”. ");
INSERT INTO spavbl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","El Señor dijo: “Verás que estoy haciendo un pacto contigo. Frente a todos ustedes haré milagros que nunca se han hecho, ni entre nadie en ningún lugar de la tierra. Todos aquí y los que están alrededor verán al Señor trabajando, porque lo que voy a hacer por ustedes será increíble. ");
INSERT INTO spavbl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Pero deben seguir cuidadosamente lo que les digo que hagan hoy. ¡Presten atención! Voy a expulsar delante de ustedes a los amorreos, cananeos, hititas, ferezeos, heveos y jebuseos. ");
INSERT INTO spavbl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Asegúrense de no acordar un tratado de paz con el pueblo que habite en la tierra a la que van. De lo contrario, se convertirán en una trampa para ustedes. ");
INSERT INTO spavbl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Porque deben derribar sus altares, derribar sus pilares idólatras y cortar sus postes de Asera, ");
INSERT INTO spavbl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","porque no debes adorar a ningún otro dios que no sea el Señor. Su nombre significa exclusivo, porque es un Dios que exige una relación exclusiva. ");
INSERT INTO spavbl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Asegúrense de no hacer un acuerdode paz con el pueblo que habita enesa tierra, porque cuando se prostituyen adorando y sacrificándose a sus dioses, los invitarán a unirse a ellos, y comerás de sus sacrificios paganos. ");
INSERT INTO spavbl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Cuando hagas que sus hijas se casen con tus hijos y esas hijas se prostituyan con sus dioses, harán que tus hijos adoren a sus dioses de la misma manera. ");
INSERT INTO spavbl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Nohagan ningún ídolo. ");
INSERT INTO spavbl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Guardarán el Festival de los Panes sin Levadura. Durante siete días comerán panes sin levadura, como se los he ordenado. Lo harán en el momento indicado en el mes de Abib, porque ese fue el mes en que salieron de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Todo primogénito es mío. Eso incluye a todos los primogénitos de su ganado, de sus manadas y rebaños. ");
INSERT INTO spavbl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Pueden redimir el primogénito de un asnoa cambio de un cordero, pero si no lo hacen, deberán romperle el cuello. Todos tus primogénitos deben ser redimidos. Nadie debe presentarse ante mí sin una ofrenda. ");
INSERT INTO spavbl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Trabajarás durante seis días, pero descansarás el séptimo día. Incluso durante el tiempo de la siembra y la cosecha descansarás. ");
INSERT INTO spavbl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Guarden el Festival de las Semanas cuando ofrezcan las primicias de la cosecha de trigo, y el Festival de la Cosecha al final del año agrícola. ");
INSERT INTO spavbl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tres veces al año todos tus varones deben presentarse ante el Señor Yahvé, el Dios de Israel. ");
INSERT INTO spavbl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Expulsaré las naciones que están delante de ti y ampliaré tus fronteras, y nadie vendrá a tomar tu tierra cuando vayas tres veces al año a presentarte ante el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","No ofrezcas pan hecho con levadura cuando me presentes un sacrificio, ni guardes ningún sacrificio de la fiesta de la Pascua hasta la mañana siguiente. ");
INSERT INTO spavbl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Cuando oseches tus cosechas, llevalas primicias a la casa del Señor tu Dios. “No cocines un cabrito joven en la leche de su madre”. ");
INSERT INTO spavbl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Entonces el Señor le dijo a Moisés: “Escribe estas palabras, porque son la base del acuerdo que he hecho contigo y con Israel”. ");
INSERT INTO spavbl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moisés pasó allí cuarenta días y cuarenta noches con el Señor sin comer pan ni beber agua. Escribió en las tablas las palabras del acuerdo, los Diez Mandamientos. ");
INSERT INTO spavbl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Cuando Moisés bajó del Monte Sinaí llevando las dos tablas de la Ley, no se dio cuenta de que su rostro brillaba con fuerza porque había estado hablando con el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Cuando Aarón y los israelitas vieron a Moisés con su rostro tan brillante que se asustaron al acercarse a él. ");
INSERT INTO spavbl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pero Moisés los llamó, así que Aarón y todos los líderes de la comunidad se acercaron a él y él habló con ellos. ");
INSERT INTO spavbl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Después todos los israelitas se acercaron y él les dio todas las instrucciones del Señor que había recibido en el Monte Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Cuando Moisés terminó de hablar con ellos, se puso un velo sobre su rostro. ");
INSERT INTO spavbl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Sin embargo, cada vez que Moisés entraba a hablar con el Señor, se quitaba el velo hasta que volvía a salir. Entonces les decía a los israelitas las instrucciones del Señor, ");
INSERT INTO spavbl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","y los israelitas veían su rostro brillar con fuerza. Así que se ponía el velo en la cara hasta la próxima vez que fuera a hablar con el Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moisés convocó a todos los israelitas y les dijo: “Esto es lo que el Señor nos ha ordenado hacer: ");
INSERT INTO spavbl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Seis días pueden trabajar, pero el séptimo día debe ser un santo sábado de descanso para el Señor. Cualquiera que haga cualquier trabajo en el día de reposo debe ser asesinado. ");
INSERT INTO spavbl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Noenciendan fuego en ninguna de sus casas en el día de reposo”. ");
INSERT INTO spavbl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moisés también les dijo a todos los israelitas: “Esto es lo que el Señor ha ordenado: ");
INSERT INTO spavbl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Recojan una ofrenda al Señor de lo que poseen. Todo el que quiera debe traer una ofrenda al Señor: oro, plata y bronce; ");
INSERT INTO spavbl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","hilos azules, púrpura y carmesí; lino y pelo de cabra finamente tejidos; ");
INSERT INTO spavbl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","pieles de carnero curtidas y cuero fino; madera de acacia; ");
INSERT INTO spavbl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","aceite de oliva para las lámparas; especias para el aceite de la unción y para el incienso aromático ");
INSERT INTO spavbl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","y piedras de ónice y gemas para hacer el efod y el pectoral. ");
INSERT INTO spavbl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Todos tus artesanos vendrán a hacer todo lo que el Señor ha ordenado: ");
INSERT INTO spavbl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","el Tabernáculo con su tienda y su cubierta, sus pinzas y sus marcos, sus travesaños, postes y soportes; ");
INSERT INTO spavbl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","el Arca con sus varas y su cubierta de expiación, y el velo para colgarla; ");
INSERT INTO spavbl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","la mesa con sus varas, todo su equipo y el Pan de la Presencia; ");
INSERT INTO spavbl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","el candelabro de luz con su equipo y lámparas y aceite de oliva para alumbrar; ");
INSERT INTO spavbl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","el altar de incienso con sus varas; el aceite de la unción y el incienso aromático; la pantalla para la entrada del Tabernáculo y todos sus accesorios; ");
INSERT INTO spavbl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","el altar del holocausto con su reja de bronce, sus varas y todos sus utensilios; el lavabo más su soporte; ");
INSERT INTO spavbl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","las cortinas del patio con sus postes y bases, y la cortina para la entrada del patio; ");
INSERT INTO spavbl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","las estacas de la tienda para el Tabernáculo y para el patio, así como sus cuerdas; ");
INSERT INTO spavbl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","y las ropas tejidas para servir en el lugar santo: la ropa sagrada para el sacerdote Aarón y para sus hijos para servir como sacerdotes”. ");
INSERT INTO spavbl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Los israelitas se fueron y dejaron a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Y todos aquellos que se sintieron movidos a hacerlo y que tenían un espíritu dispuesto vinieron y trajeron una ofrenda al Señor por el trabajo de hacer el Tabernáculo de Reunión, por todo lo que se requería para sus servicios, y por las ropas sagradas. ");
INSERT INTO spavbl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Así que todos los que quisieron, tanto hombres como mujeres, vinieron y presentaron su oro como ofrenda de agradecimiento al Señor, incluyendo broches, pendientes, anillos y collares, todo tipo de joyas de oro. ");
INSERT INTO spavbl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Todos los que tenían hilos azules, púrpura y carmesí, lino finamente tejido, pelo de cabra, pieles de carnero curtidas y cuero fino, los trajeron. ");
INSERT INTO spavbl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Los que podían presentar una ofrenda de plata o bronce la traían como regalo al Señor. Todos los que tenían madera de acacia para cualquier parte del trabajo, la donaban. ");
INSERT INTO spavbl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Toda mujer hábil en el hilado con sus manos traía lo que había hilado: hilo azul, púrpura o carmesí, o lino finamente tejido. ");
INSERT INTO spavbl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Todas las mujeres que estaban dispuestas a usar sus habilidades hilaban el pelo de cabra. ");
INSERT INTO spavbl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Los jefes trajeron piedras de ónix y gemas para hacer el efod y el pectoral, ");
INSERT INTO spavbl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","así como especias y aceite de oliva para el alumbrado, para el aceite de la unción y para el incienso aromático. ");
INSERT INTO spavbl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Todos los hombres y mujeres israelitas que estaban dispuestos trajeron una ofrenda voluntaria al Señor por todo el trabajo de hacer lo que el Señor, a través de Moisés, les había ordenado hacer. ");
INSERT INTO spavbl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Entonces Moisés dijo a los israelitas: “El Señor escogió el nombre de Bezaleel, hijo de Uri, hijo de Hur, de la tribu de Judá. ");
INSERT INTO spavbl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Lo ha llenado del Espíritu de Dios dándole habilidad, creatividad y experiencia en todo tipo de artesanía. ");
INSERT INTO spavbl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Puede producir diseños en oro, plata y bronce, ");
INSERT INTO spavbl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","puede tallar piedras preciosas para colocarlas en los marcos, y puede tallar madera. Es un maestro de todas las artesanías. ");
INSERT INTO spavbl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","El Señor también le ha dado a él y a Aholiab, hijo de Ahisamac, de la tribu de Dan, la habilidad de enseñar a otros. ");
INSERT INTO spavbl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Los ha dotado de habilidad para hacer todo tipo de trabajos como grabadores, diseñadores, bordadores en hilo azul, púrpura y carmesí, y en lino finamente tejido, y como tejedores, de hecho como hábiles diseñadores en todo tipo de artesanía”. ");
INSERT INTO spavbl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Así que Bezalel, Aholiab, y todos los demás artesanos con la experiencia necesaria y con la habilidad y la capacidad dadas por el Señor, deben trabajar para llevar a cabo todo el trabajo de construcción del santuario como lo ordenó el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moisés convocó a Bezalel, a Aholiab y a todos los artesanos a los que el Señor les había dado habilidades especiales, para que vinieran a hacer el trabajo. ");
INSERT INTO spavbl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Moisés les dio todo lo que los israelitas habían contribuido para llevar a cabo el trabajo de construcción del santuario. Mientras tanto el pueblo siguió trayendo ofrendas voluntarias cada mañana, ");
INSERT INTO spavbl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","tanto que todos los artesanos que trabajaban en el santuario dejaron lo que estaban haciendo ");
INSERT INTO spavbl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","y fueron a decirle a Moisés: “El pueblo ya ha traído lo suficiente para completar el trabajo que el Señor nos ha ordenado hacer”. ");
INSERT INTO spavbl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moisés dio la orden, y se hizo un anuncio en todo el campamento: “Hombres y mujeres, no traigan nada más como ofrenda para el santuario”. Así que se impidió que el pueblo trajera nada más, ");
INSERT INTO spavbl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","puesto que ya había más que suficiente para hacer todo el trabajo necesario. ");
INSERT INTO spavbl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Los hábiles artesanos entre los trabajadores hicieron las diez cortinas para el Tabernáculo. Estaban hechas de lino finamente hilado junto con hilos azules, púrpura y carmesí, bordadas con querubines. ");
INSERT INTO spavbl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Cada cortina tenía 28 codos de largo por 4 codos de ancho, y todas eran del mismo tamaño. ");
INSERT INTO spavbl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Unieron cinco de las cortinas como un conjunto, y las otras cinco las unió como un segundo conjunto. ");
INSERT INTO spavbl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Utilizaron material azul para hacer lazos en el borde de la última cortina de ambos juegos. ");
INSERT INTO spavbl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Hicieron cincuenta lazos en una cortina y cincuenta lazos en la última cortina del segundo juego, alineando los lazos entre sí. ");
INSERT INTO spavbl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","También hicieron cincuenta ganchos de oro y unieron las cortinas con los ganchos, de modo que el Tabernáculo era una sola estructura. ");
INSERT INTO spavbl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Hicieron once cortinas de pelo de cabra como una tienda de campaña para cubrir el Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Cada una de las once cortinas era del mismo tamaño, 30 codos de largo por 4 codos de ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Unieron cinco de las cortinas como un conjunto y las otras seis como otro conjunto. ");
INSERT INTO spavbl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Confeccionaron cincuenta lazos en el borde de la última cortina del primer juego, y cincuenta lazos a lo largo del borde de la última cortina del segundo juego. ");
INSERT INTO spavbl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Hicieron cincuenta ganchos de bronce para unir la tienda como una sola cubierta. ");
INSERT INTO spavbl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Elaboraron una cubierta para la tienda con pelo de cabra y pieles de carnero curtidas, y colocaron una cubierta extra de cuero fino sobre ella. ");
INSERT INTO spavbl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Hicieron un marco vertical de madera de acacia para el Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Cada marco tenía diez codos de largo por un codo y medio de ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Cada marco tenía dos clavijas para que los marcos pudieran conectarse entre sí. Hicieron todos los marcos del Tabernáculo así. ");
INSERT INTO spavbl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Hicieron veinte marcos para el lado sur del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Hicieron cuarenta soportes de plata como apoyo para los veinte marcos usando dos soportes por marco, uno debajo de cada clavija del marco. ");
INSERT INTO spavbl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","De manera similar para el lado norte del Tabernáculo, hicieron veinte marcos ");
INSERT INTO spavbl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","y cuarenta soportes de plata, dos soportes por marco. ");
INSERT INTO spavbl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Hicieron seis marcos para la parte trasera (lado oeste) del Tabernáculo, ");
INSERT INTO spavbl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","junto con dos marcos para sus dos esquinas traseras. ");
INSERT INTO spavbl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Unieron estos marcos de las esquinas en la parte inferior y en la parte superior cerca del primer anillo. Así es como hicieron los dos marcos angulares. ");
INSERT INTO spavbl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","En total había ocho marcos y dieciséis soportes de plata, dos debajo de cada marco. ");
INSERT INTO spavbl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Fabicaron cinco barras transversales de madera de acacia para sostener los marcos en el lado sur del Tabernáculo, ");
INSERT INTO spavbl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","cinco para los del norte y cinco para los de la parte trasera del Tabernáculo, al oeste. ");
INSERT INTO spavbl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Hicieron el travesaño central que se colocó a la mitad de los marcos y corrió de un extremo al otro. ");
INSERT INTO spavbl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Cubrieron los marcos con oro, e hicieron anillos de oro para sostener las barras transversales en su lugar. También cubrieron los travesaños con oro. ");
INSERT INTO spavbl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Confeccionaron un velo de hilo azul, púrpura y carmesí, y de lino finamente hilado, bordado con querubines por alguien que era hábil en este arte. ");
INSERT INTO spavbl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Fabricaron cuatro postes de madera de acacia para ello y los cubrieron con oro. Hicieron ganchos de oro para los postes y fundieron sus cuatro soportes de plata. ");
INSERT INTO spavbl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hicieron un biombo para la entrada de la tienda usando hilos azules, púrpura y carmesí, y lino finamente hilado, y lo hicieron bordar. ");
INSERT INTO spavbl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","También hicieron cinco postes de madera de acacia con ganchos para colgar el biombo. Cubrieron la parte superior de los postes y sus bandas con oro, y sus cinco soportes eran de bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel hizo el Arca de madera de acacia que mide dos codos y medio de largo por un codo y medio de ancho por un codo y medio de alto. ");
INSERT INTO spavbl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","La cubrió con oro puro por dentro y por fuera, e hizo un adorno de oro para rodearla. ");
INSERT INTO spavbl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Fundió cuatro anillos de oro y los unió a sus cuatro pies, dos en un lado y dos en el otro. ");
INSERT INTO spavbl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Hizo palos de madera de acacia y los cubrió con oro. ");
INSERT INTO spavbl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Colocó las varas en los anillos de los lados del Arca, para que pudiera ser transportada. ");
INSERT INTO spavbl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Hizo la tapa de expiación de oro puro, de dos codos y medio de largo por un codo y medio de ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Hizo dos querubines de oro martillado para los extremos de la tapa de expiación, ");
INSERT INTO spavbl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","y puso un querubín en cada extremo. Todo esto fue hecho de una sola pieza de oro. ");
INSERT INTO spavbl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Los querubines fueron diseñados con alas extendidas apuntando hacia arriba, cubriendo la cubierta de expiación. Los querubines se colocaron uno frente al otro, mirando hacia la cubierta de expiación. ");
INSERT INTO spavbl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Luego hizo la mesa de madera de acacia de dos codos de largo por un codo de ancho por un codo y medio de alto. ");
INSERT INTO spavbl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","La cubrió con oro puro e hizo un adorno de oro para rodearla. ");
INSERT INTO spavbl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hizo un borde a su alrededor del ancho de una mano y puso un adorno de oro en el borde. ");
INSERT INTO spavbl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Fundió cuatro anillos de oro para la mesa y los sujetó a las cuatro esquinas de la mesa por las patas. ");
INSERT INTO spavbl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Los anillos estaban cerca del borde para sujetar los palos usados para llevar la mesa. ");
INSERT INTO spavbl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Fabricó las varas de madera de acacia para llevar la mesa y las cubrió con oro. ");
INSERT INTO spavbl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Elaboró utensilios para la mesa de oro puro: platos y fuentes, tazones y jarras para verter las ofrendas de bebida. ");
INSERT INTO spavbl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hizo el candelabro de oro puro, martillado. Todo el conjunto estaba hecho de una sola pieza: su base, el fuste, las tazas, los capullos y las flores. ");
INSERT INTO spavbl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Tenía seis ramas que salían de los lados del candelabro, tres en cada lado. Tenía tres tazas en forma de flores de almendra en la primera rama, cada una con brotes y pétalos, tres en la siguiente rama. ");
INSERT INTO spavbl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Cada una de las seis ramas que salían tenía tres copas en forma de flores de almendra, todas con brotes y pétalos. ");
INSERT INTO spavbl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","En el eje principal del candelabro hizo cuatro tazas en forma de flores de almendra, con capullos y pétalos. ");
INSERT INTO spavbl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","En las seis ramas que salían de él, colocó un brote bajo el primer par de ramas, un brote bajo el segundo par, y un brote bajo el tercer par. ");
INSERT INTO spavbl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Los brotes y las ramas deben ser hechos con el candelabro como una sola pieza, martillado en oro puro. ");
INSERT INTO spavbl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Hizo siete lámparas, así como pinzas de mecha y sus bandejas de oro puro. ");
INSERT INTO spavbl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","El candelabro y todos estos utensilios requerían un talento de oro puro. ");
INSERT INTO spavbl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hizo el altar para quemar incienso de madera de acacia. Era cuadrado, medía un codo por codo, por dos codo de alto, con cuernos en sus esquinas que eran todos de una sola pieza con el altar. ");
INSERT INTO spavbl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Cubrió su parte superior, su costado y sus cuernos con oro puro, e hizo un adorno de oro para rodearlo. ");
INSERT INTO spavbl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Hizo dos anillos de oro para el altar y los colocó debajo del adorno, dos a ambos lados, para sostener los palos para llevarlo. ");
INSERT INTO spavbl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Hizo las varas de madera de acacia y las cubrió con oro. ");
INSERT INTO spavbl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Hizo el aceite de la santa unción y el incienso puro y aromático como el producto de un experto perfumista. ");
INSERT INTO spavbl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezalelpresentó la ofrenda quemada en el altar hecho con madera de acacia. Era cuadrado y medía cinco codos de largo por cinco de ancho por tres de alto. ");
INSERT INTO spavbl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Hizo cuernos para cada una de sus esquinas, todos de una sola pieza con el altar, y cubrió todo el altar con bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Elaboró todos sus utensilios: cubos para quitar las cenizas, palas, tazones para rociar, tenedores para la carne y cacerolas. Todos sus utensilios los hizo de bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Fabricóuna rejilla de malla de bronce para el altar y la colocó bajo el saliente del altar, de modo que la malla llegara hasta la mitad del altar. ");
INSERT INTO spavbl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Fundió cuatro anillos de bronce para las cuatro esquinas de la rejilla como soportes para los postes. ");
INSERT INTO spavbl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Elaboró postes de madera de acacia para el altar y los cubrió con bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Puso las varas a través de los anillos a cada lado del altar para que pudiera ser transportado. Hizo el altar hueco, usando tablas. ");
INSERT INTO spavbl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Hizo la palangana de bronce con su soporte con bronce de los espejos de las mujeres que servían en la entrada del Tabernáculo de reunión. ");
INSERT INTO spavbl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Luego construyó un patio. Para el lado sur del patio hizo cortinas de lino finamente hilado, de cien codos de largo por un lado, ");
INSERT INTO spavbl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","con veinte postes y veinte soportes de bronce, con ganchos y bandas de plata en los postes. ");
INSERT INTO spavbl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","De manera similar hizo cortinas colocadas en el lado norte en una disposición idéntica. ");
INSERT INTO spavbl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Confeccionó cortinas para el lado oeste del patio de cincuenta codos de ancho, con diez postes y diez soportes. ");
INSERT INTO spavbl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","El lado este del patio que da al amanecer tenía cincuenta codos de ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Diseñó las cortinas de un lado de quince codos de largo, con tres postes y tres soportes, ");
INSERT INTO spavbl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","y las cortinas del otro lado de la misma manera. ");
INSERT INTO spavbl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Todas las cortinas que rodeaban el patio eran de lino finamente tejido. ");
INSERT INTO spavbl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Las gradas de los postes eran de bronce, los ganchos y las bandas eran de plata, y la parte superior de los postes estaba cubierta de plata. Todos los postes alrededor del patio tenían bandas de plata. ");
INSERT INTO spavbl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","La cortina de la entrada al patio estaba bordada con hilos azules, púrpura y carmesí, y con lino finamente hilado. Tenía 20 codos de largo por 5 codos de alto, la misma altura que las cortinas del patio. ");
INSERT INTO spavbl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Estaba sostenido por cuatro postes y cuatro soportes. Los postes tenían ganchos, tapas y bandas de plata. ");
INSERT INTO spavbl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Todas las estacas de la tienda para el Tabernáculo y para el patio circundante eran de bronce. ");
INSERT INTO spavbl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Lo siguiente es lo que se usó para el Tabernáculo del Testimonio, registrado bajo la dirección de Moisés por los levitas bajo la supervisión de Itamar, hijo del sacerdote Aarón. ");
INSERT INTO spavbl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleel, hijo de Uri, hijo de Hur, de la tribu de Judá, hizo todo lo que el Señor había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Fue asistido por Aholiab, hijo de Ahisamac, de la tribu de Dan, un grabador, diseñador y bordador que usaba hilos azules, púrpura y carmesí y lino finamente tejido. ");
INSERT INTO spavbl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","La cantidad total de oro de la ofrenda que se utilizó para el trabajo en el santuario fue de 29 talentos y 730 siclos, (usando el estándar de siclos del santuario). ");
INSERT INTO spavbl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","La cantidad total de plata de los que habían sido contados en el censo era de 100 talentos y 1.775 siclos (usando el estándar del siclo del santuario). ");
INSERT INTO spavbl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Esto representa un beka por persona, o medio siclo, (usando el estándar del siclo del santuario) de cada persona de veinte años o más que había sido censada, un total de 603.550 hombres. ");
INSERT INTO spavbl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Los cien talentos de plata se usaron para fundir los soportes del santuario y los soportes de las cortinas, 100 bases de los 100 talentos, o un talento por base. ");
INSERT INTO spavbl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Bezalel usó los 1.775 siclos de plata para hacer los ganchos de los postes, cubrir sus tapas y hacer bandas para ellos. ");
INSERT INTO spavbl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","La cantidad total de bronce de la ofrenda fue de 70 talentos y 2.400 siclos. ");
INSERT INTO spavbl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Bezalel lo usó para hacer las gradas para la entrada a el Tabernáculo de Reunión, el altar de bronce y su rejilla de bronce, todos los utensilios para el altar, ");
INSERT INTO spavbl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","las gradas para el patio y su entrada, y todas las estacas de la tienda para el Tabernáculo y el patio. ");
INSERT INTO spavbl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Estos hombres confeccionaron ropa tejida con hilos azules, púrpura y carmesí para servir en el santuario. También hicieron vestimentas sagradas para Aarón, como el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Hicieron el efod de lino finamente tejido bordado con oro, y con hilos azules, púrpura y carmesí. ");
INSERT INTO spavbl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Martillaron finas láminas de oro y cortaron hilos para tejerlos con los hilos azul, púrpura y escarlata, junto con lino fino, todo hábilmente trabajado. ");
INSERT INTO spavbl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Dos piezas de hombro fueron unidas a las piezas delanteras y traseras ");
INSERT INTO spavbl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","La cintura del efod era una pieza hecha de la misma manera, usando hilo de oro, con hilo azul, púrpura y carmesí, y con lino fino, como el Señor había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Colocaron las piedras de ónix en engastes de oro ornamental, grabando los nombres de las tribus israelitas de la misma manera que un joyero graba un sello personal. ");
INSERT INTO spavbl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Pusieron ambas piedras en los hombros del efod como recordatorio para las tribus israelitas, como el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","También hicieron un pectoral para las decisiones de la misma manera hábil que el efod, para ser usado en la determinación de la voluntad del Señor. Lo hicieron usando hilo de oro, con hilos azules, púrpura y carmesí, y con lino finamente tejido. ");
INSERT INTO spavbl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Era cuadrado cuando se doblaba, midiendo alrededor de nueve pulgadas de largo y ancho. ");
INSERT INTO spavbl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Adjuntaron un arreglo de piedras preciosas en cuatro filas como sigue. En la primera fila cornalina, peridoto y esmeralda. ");
INSERT INTO spavbl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","En la segunda fila turquesa, lapislázuli y sardónice. ");
INSERT INTO spavbl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","En la tercera fila jacinto, ágata y amatista. ");
INSERT INTO spavbl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","En la cuarta fila topacio, berilo y jaspe. Todos ellos fueron colocados en un marco de oro ornamental. ");
INSERT INTO spavbl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Cada una de las doce piedras estaba grabada como un sello personal con el nombre de una de las doce tribus israelitas y las representaba. ");
INSERT INTO spavbl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Confeccionaron cordones de cadenas trenzadas de oro puro para sujetar el pectoral. ");
INSERT INTO spavbl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Hicieron dos ajustes de oro y dos anillos de oro y sujetaron los anillos a las dos esquinas superiores del pectoral. ");
INSERT INTO spavbl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Fijaron las dos cadenas de oro a los dos anillos de oro de las esquinas del pectoral, ");
INSERT INTO spavbl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","y luego sujetaron los extremos opuestos de las dos cadenas a los adornos de oro de los hombros de la parte delantera del efod. ");
INSERT INTO spavbl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Hicieron dos anillos de oro más y los fijaron a las dos esquinas inferiores del pectoral, en el borde interior junto al efod. ");
INSERT INTO spavbl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Hicieron dos anillos de oro más y los fijaron en la parte inferior de las dos hombreras de la parte delantera del efod, cerca de donde se une a su cintura tejida. ");
INSERT INTO spavbl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ataron los anillos del pectoral a los anillos del efod con un cordón de hilo azul, para que el pectoral no se soltara del efod, como el Señor había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Hicieron la túnica que acompaña al efod exclusivamente de tela azul tejida, ");
INSERT INTO spavbl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","con una abertura en el centro en la parte superior. Cosieron un cuello tejido alrededor de la abertura para reforzarla y que no se rompiera. ");
INSERT INTO spavbl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Hicieron granadas usando hilos azules, púrpura y carmesí y lino finamente tejido y las unieron alrededor de su dobladillo. ");
INSERT INTO spavbl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Hicieron campanas de oro puro y las unieron entre las granadas alrededor de su dobladillo, ");
INSERT INTO spavbl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","haciendo que las campanas y las granadas se alternaran. La túnica debía ser usada para el servicio sacerdotal, como el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Confeccionaron túnicas con lino finamente hilado hechas por un tejedor para Aarón y sus hijos. ");
INSERT INTO spavbl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Tambiénelaboraron turbantes, tocados y diademas de lino fino, y calzoncillos de lino finamente tejidos, ");
INSERT INTO spavbl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","así como fajas de lino finamente tejidas bordadas con hilos azules, púrpura y carmesí, como el Señor había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Diseñaron la placa de la corona santa de oro puro y escribieron en ella, grabada como un sello, “Consagrado al Señor”. ");
INSERT INTO spavbl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Le ataron un cordón azul para atarlo a la parte delantera del turbante, como el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Así que todo el trabajo para el Tabernáculo, el Tarbernáculo de Reunión, estaba terminado. Los israelitas hicieron todo lo que el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Luego presentaron el Tabernáculo a Moisés: la tienda con todos sus muebles, sus pinzas, sus marcos, sus travesaños y sus postes y soportes; ");
INSERT INTO spavbl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","la cubierta de pieles de carnero curtidas, la cubierta de cuero fino y el velo; ");
INSERT INTO spavbl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","el Arca del Testimonio con sus varas y la cubierta de expiación; ");
INSERT INTO spavbl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","la mesa con todos sus equipos y el Pan de la Presencia; ");
INSERT INTO spavbl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","el candelabro de oro puro con sus lámparas puestas en fila, y todos sus equipos, así como el aceite de oliva para las lámparas; ");
INSERT INTO spavbl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","el altar de oro, el aceite de la unción, el incienso aromático y el biombo para la entrada de la tienda; ");
INSERT INTO spavbl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","el altar de bronce con su reja de bronce, sus postes y todos sus utensilios; la palangana más su soporte; ");
INSERT INTO spavbl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","las cortinas del patio y sus postes y soportes; la cortina para la entrada del patio, sus cuerdas y estacas de la tienda, y todo el equipo para los servicios del Tabernáculo, el Tabernáculo de Reunión; ");
INSERT INTO spavbl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","y las vestimentas tejidas para servir en el santuario, las ropas sagradas para el sacerdote Aarón y para sus hijos para servir como sacerdotes. ");
INSERT INTO spavbl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Los israelitas hicieron todo el trabajo que el Señor había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moisés inspeccionó todo el trabajo y se aseguró de que lo habían hecho como el Señor se los había indicado. Entonces Moisés los bendijo. ");
INSERT INTO spavbl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Levanta el Tabernáculo de Reunión, el primer día del primer mes del año. ");
INSERT INTO spavbl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Coloca el Arca del Testimonio dentro de ella. Asegúrate de que el Arca esté detrás del velo. ");
INSERT INTO spavbl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Trae la mesa y pon sobre ella lo que sea necesario. Trae también el candelabro y coloca sus lámparas. ");
INSERT INTO spavbl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Pon el altar de oro del incienso delante del Arca del Testimonio, y pon el velo a la entrada del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Coloca el altar de los holocaustos frente a la entrada del Tabernáculo, el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Coloca la palangana entre el Tabernáculo de Reunión y el altar, y pon agua en ella. ");
INSERT INTO spavbl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","“Prepara el patio que lo rodea y pon la cortina para la entrada del patio. ");
INSERT INTO spavbl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Usa el aceite de la unción para ungir el Tabernáculo y todo lo que hay en él. Dedícalo y todos sus muebles para hacerlo sagrado. ");
INSERT INTO spavbl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Unge el altar de los holocaustos y todos sus utensilios. Dedica el altar y será especialmente santo. ");
INSERT INTO spavbl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ungirás y dedicarás la pila con su soporte. ");
INSERT INTO spavbl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Lleva a Aarón y a sus hijos a la entrada del Tabernáculo de Reunión y lávalos allí con agua. ");
INSERT INTO spavbl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Luegovistea Aarón con los vestidos sagrados, úngelo y dedícalo, para que me sirva de sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Que sus hijos se acerquen y los vistan con túnicas. ");
INSERT INTO spavbl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Úngelos de la misma manera que ungiste a su padre, para que también me sirvan como sacerdotes. Su unción hará que su linaje de sacerdotes sea eterno, para las generaciones futuras”. ");
INSERT INTO spavbl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moisés llevó a cabo todas las instrucciones del Señor. ");
INSERT INTO spavbl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","El tabernáculo se levantó el primer día del primer mes del segundo año. ");
INSERT INTO spavbl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Cuando Moisés levantó el tabernáculo, colocó sus soportes, fijó sus marcos, conectó sus travesaños y erigió sus postes. ");
INSERT INTO spavbl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Luego extendió la tienda sobre el tabernáculo y colocó la cubierta sobre la tienda, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Moisés tomó el testimonio y lo puso en el arca. Ató los postes al Arca, y colocó la tapa de expiación en la parte superior del Arca. ");
INSERT INTO spavbl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Luego llevó el Arca al Tabernáculo. Levantó el velo y se aseguró de que el Arca del Testimonio estuviera detrás de ella, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Moisés colocó la mesa dentro del Tabernáculo de Reunión en el lado norte del Tabernáculo, fuera del velo. ");
INSERT INTO spavbl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Puso el pan sobre ella en presencia del Señor, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Colocó el candelabro en la tienda de la Reunión, frente a la mesa, en el lado sur del Tabernáculo ");
INSERT INTO spavbl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","y levantó las lámparas en presencia del Señor, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Moisés levantó el altar de oro en el Tabernáculo de Reunión, frente al velo, ");
INSERT INTO spavbl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","y quemó incienso aromático en él, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Luego levantó el velo a la entrada del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Levantó el altar del holocausto cerca de la entrada del Tabernáculo de Reunión, y presentó el holocausto y la ofrenda de grano, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Puso la palangana entre el Tabernáculo de Reunión y el altar y puso agua para lavar. ");
INSERT INTO spavbl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moisés, Aarón y sus hijos la usaron para lavarse las manos y los pies. ");
INSERT INTO spavbl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Se lavaban cada vez que entraban en el Tabernáculo de Reunión o se acercaban al altar, como el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moisés levantó el patio alrededor del Tabernáculo y del altar, y puso la cortina para la entrada del patio. Esto marcó el final del trabajo hecho por Moisés. ");
INSERT INTO spavbl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Entonces la nube cubrió la Tienda de la Reunión, y la gloria del Señor llenó el Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moisés no pudo entrar en el Tabernáculo de Reunión porque la nube permaneció sobre ella, y la gloria del Señor llenó el Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Cada vez que la nube se levantaba del Tabernáculo, los israelitas se ponían en marcha de nuevo en su viaje. ");
INSERT INTO spavbl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Si la nube no se levantaba, no se ponían en marcha hasta que la nube se levantara. ");
INSERT INTO spavbl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","La nube del Señor permanecía sobre el Tabernáculo durante el día, y el fuego ardía dentro de la nube durante la noche, de modo que podía ser visto por todos los israelitas dondequiera que viajaran. ");
INSERT INTO spavbl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","El Señor llamó a Moisés y le habló desde El Tabernáculo de Reunión, diciendo: ");
INSERT INTO spavbl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Ve y habla con los israelitas y diles: Cuando presenten una ofrenda al Señor, pueden traer como ofrenda un animal del rebaño de ganado o del rebaño de ovejas o cabras. ");
INSERT INTO spavbl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Si tu ofrenda es una ofrenda quemada de un rebaño de ganado, debe ofrecer un macho sin ningún defecto. Llévalo a la entrada del Tabernáculo de Reunión para que sea aceptado por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Pon tu mano en la cabeza de la ofrenda quemada, para que pueda ser aceptada en tu nombre para tu justificación. ");
INSERT INTO spavbl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Debes matar el toro en presencia del Señor, y los hijos de Aarón, los sacerdotes, deben tomar la sangre y rociarla por todos los lados del altar a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Entonces debes desollar la ofrenda quemada y cortarla en pedazos. ");
INSERT INTO spavbl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Los hijos del sacerdote Aarón encenderán un fuego en el altar y le pondrán leña. ");
INSERT INTO spavbl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Entonces los sacerdotes colocarán cuidadosamente las piezas, incluyendo la cabeza y la grasa, en la madera que se quema sobre el altar. ");
INSERT INTO spavbl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Lavarás las entrañas y las piernas con agua, y el sacerdote lo quemará todo en el altar como una ofrenda quemada, una ofrenda de comida, para ser aceptada por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Si tu ofrenda es una ofrenda quemada de un rebaño, ya sea de ovejas o de cabras, debes ofrecer un macho sin ningún defecto. ");
INSERT INTO spavbl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Debes matarlo en el lado norte del altar en presencia del Señor, y los hijos de Aarón, los sacerdotes, deben tomar la sangre y rociarla en todos los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Entonces lo cortarás en pedazos, y el sacerdote colocará cuidadosamente los pedazos, incluyendo la cabeza y la grasa, en la madera que se quema sobre el altar. ");
INSERT INTO spavbl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Lavarás las entrañas y las piernas con agua, y el sacerdote lo quemará todo en el altar como un holocausto, una ofrenda de comida, para ser aceptada por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Si tu ofrenda al Señor es un holocausto de pájaros, debes ofrecer una tórtola o una paloma joven. ");
INSERT INTO spavbl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","El sacerdote lo llevará al altar, le quitará la cabeza y lo quemará en el altar. Su sangre será drenada en el lado del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Debe quitar el buche y las plumas, y tirarlas al lado este del altar en el montón de cenizas. ");
INSERT INTO spavbl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Lo abrirá por las alas, pero no completamente. El sacerdote lo quemará en el altar, sobre la madera ardiente. Es una ofrenda quemada, una ofrenda de comida, agradable Señor”. ");
INSERT INTO spavbl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Cuando traigas una ofrenda de grano al Señor, tu ofrenda debe ser de la mejor harina. Vierte aceite de oliva y ponle incienso, ");
INSERT INTO spavbl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","y llévaselo a los hijos de Aarón, los sacerdotes. El sacerdote tomará un puñado de la mezcla de harina y aceite de oliva, así como todo el incienso, y lo quemará como un ‘recordatorio’ en el altar, una ofrenda de comida, agradable al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","El resto de la ofrenda de grano es para Aarón y sus hijos; es una parte muy sagrada de las ofrendas dadas al Señor como ofrendas de comida. ");
INSERT INTO spavbl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Si tu ofrenda es de grano cocido en un horno, debe ser hecha de harina fina sin usar levadura. Pueden ser pasteles mezclados con aceite de oliva o barquillos con aceite de oliva untado en ellos. ");
INSERT INTO spavbl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Si tu ofrenda es una ofrenda de grano cocido en una plancha, debe ser hecha de harina fina mezclada con aceite de oliva sin usar levadura. ");
INSERT INTO spavbl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Rómpelo y vierte aceite de oliva sobre él; es una ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Si tu ofrenda es una ofrenda de grano cocido en una sartén, debe ser de harina fina con aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Trae al Señor la ofrenda de grano hecha de cualquiera de estas maneras. Preséntala al sacerdote, quien la llevará al altar. ");
INSERT INTO spavbl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","El sacerdote debe tomar ‘el resto’ de la ofrenda de grano y quemarla en el altar como una ofrenda de comida, agradable para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","El resto de la ofrenda de grano es para Aarón y sus hijos; es la parte más sagrada de las ofrendas de comida dadas al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Ninguna ofrenda de grano que traigas ante el Señor puede hacerse con levadura. No quemes ninguna levadura o miel como ofrenda al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Puedes dárselas al Señor cuando presentes tus ofrendas de primicias, pero no deben ser ofrecidas en el altar para ser aceptadas por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Todas tus ofrendas de granos deben ser sazonadas con sal. No dejes la sal del pacto de Dios fuera de tu ofrenda de grano. Añade sal a todas tus ofrendas. ");
INSERT INTO spavbl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Cuando traigas al Señor una ofrenda de primicias de grano, ofrece cabezas aplastadas de grano nuevo asadas en el fuego. ");
INSERT INTO spavbl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Pon aceite de oliva e incienso en él; es una ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","El sacerdote quemará el ‘recordatorio’ del grano triturado y el aceite de oliva, así como todo su incienso, como ofrenda de alimento al Señor”. ");
INSERT INTO spavbl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Cuando quieras hacer una ofrenda de paz y ofrezcas un animal de una manada de ganado, ya sea macho o hembra, debes presentar uno sin ningún defecto ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Pon tu mano en la cabeza de la ofrenda y mátala a la entrada del Tabernáculo de Reunión. Entonces los hijos de Aarón los sacerdotes rociarán la sangre por todos los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","De la ofrenda de paz debes traer una ofrenda de comida al Señor: toda la grasa que cubre las entrañas, ");
INSERT INTO spavbl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ambos riñones con la grasa en ellos por los lomos, y la mejor parte del hígado, que debes quitar junto con los riñones. ");
INSERT INTO spavbl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Los hijos de Aarón deben quemar esto en el altar sobre la ofrenda quemada que está sobre la madera ardiente, como una ofrenda de comida, agradable al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Cuando quieras hacer una ofrenda de paz y ofrezcas un animal de un rebaño de ovejas o cabras, ya sea macho o hembra, debes presentar uno sin ningún defecto ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Si das un cordero como ofrenda, debes presentarlo ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Pon tu mano en la cabeza de la ofrenda y mátala delante del Tabernáculo de Reunión. Entonces los hijos de Aarón los sacerdotes rociarán la sangre a todos los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","De la ofrenda de paz debes traer una ofrenda de comida al Señor hecha de su grasa: la cola entera removida de la base de la rabadilla, toda la grasa que cubre el interior, ");
INSERT INTO spavbl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ambos riñones con la grasa en ellos por los lomos, y la mejor parte del hígado, que debes quitar junto con los riñones. ");
INSERT INTO spavbl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Entonces el sacerdote debe quemar esto en el altar como una ofrenda de comida, una ofrenda de comida al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Si tu ofrenda es una cabra, debes presentarla ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Pon tu mano en su cabeza y mátalo frente al Tabernáculo de Reunión. Entonces los hijos de Aarón, los sacerdotes, rociarán la sangre a todos los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","De tu ofrenda debes presentar una ofrenda de comida al Señor hecha de toda la grasa que cubre las entrañas, ");
INSERT INTO spavbl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ambos riñones con la grasa en ellos por los lomos, y la mejor parte del hígado, que debes quitar junto con los riñones. ");
INSERT INTO spavbl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Entonces el sacerdote debe quemar esto en el altar como una ofrenda de comida, una ofrenda al Señor usando fuego. Toda la grasa es para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","No debes comer ninguna grasa o sangre. Esta regulación es para todos los tiempos y para todas las generaciones futuras dondequiera que vivan”. ");
INSERT INTO spavbl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Dile a los israelitas que estas son las reglas para manejar los casos de aquellos que pecan involuntariamente contra alguno de los mandamientos del Señor y hacen lo que no está permitido. ");
INSERT INTO spavbl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Si es el Sumo Sacerdote quien peca y trae la culpa sobre todos, debe presentar al Señor un novillo sin defectos como ofrenda por su pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Debes llevar el toro a la entrada del Tabernáculo de Reunión ante el Señor, poner su mano sobre su cabeza y matarlo ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Entonces el sumo sacerdote llevará parte de la sangre del toro al Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","El sumo sacerdote mojará su dedo en la sangre y rociará un poco de ella siete veces delante el Señor, frente del velo del santuario. ");
INSERT INTO spavbl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","El sacerdote pondrá un poco de sangre sobre los cuernos del altar de incienso aromático que está ante el Señor en el Tabernáculo de Reunión. El resto de la sangre del toro la derramará en el fondo del altar de los holocaustos, a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Entonces quitará toda la grasa del toro de la ofrenda por el pecado: toda la grasa que cubre las entrañas, ");
INSERT INTO spavbl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ambos riñones con la grasa en ellos por los lomos, y la mejor parte del hígado, que debe eliminar junto con los riñones ");
INSERT INTO spavbl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","de la misma manera que la grasa se quita del toro de la ofrenda de paz. Entonces el sacerdote quemará esto en el altar de la ofrenda quemada. ");
INSERT INTO spavbl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","“Pero la piel del toro, toda su carne, cabeza, patas, interiores y desechos, ");
INSERT INTO spavbl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","y todo el resto, tiene que llevarlo fuera del campamento a un lugar que esté ceremonialmente limpio, donde se arrojen las cenizas, y debe quemarlo en un fuego de leña allí en el montón de cenizas. ");
INSERT INTO spavbl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Si todo el pueblo de Israel se extravía sin querer, y aunque no sean conscientes de hacer lo que no está permitido por ninguno de los mandamientos del Señor, siguen siendo todos culpables. ");
INSERT INTO spavbl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Cuando se den cuenta de su pecado, deben traer un toro joven como ofrenda por el pecado y presentarlo ante el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Los ancianos de Israel pondrán sus manos sobre su cabeza y lo matarán delante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Entonces el sumo sacerdote llevará parte de la sangre del toro al Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Mojará su dedo en la sangre y lo rociará siete veces ante el Señor delante del velo. ");
INSERT INTO spavbl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Pondrá un poco de sangre en los cuernos del altar que está delante del Señor en el Tabernáculo de Reunión. Luego derramará el resto de la sangre del toro en el fondo del altar de los holocaustos a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Luego le quitará toda la grasa al toro y lo quemará en el altar. ");
INSERT INTO spavbl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ofrecerá este toro de la misma manera que lo hizo para la ofrenda por el pecado. Así es como el sacerdote los expiará, y serán perdonados. ");
INSERT INTO spavbl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Entonces tomará el toro fuera del campamento y lo quemará, tal y como quemó el toro anteriormente mencionado. Es la ofrenda por el pecado de todo el pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Si un líder peca involuntariamente y hace lo que no está permitido por ninguno de los mandamientos del Señor su Dios, es culpable. ");
INSERT INTO spavbl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Cuando se dé cuenta de su pecado, debe traer un macho cabrío sin defectos como ofrenda. ");
INSERT INTO spavbl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Debe poner su mano en la cabeza del cabrito y matarlo en el lugar donde se presenta la ofrenda quemada ante el Señor. Es una ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Entonces el sacerdote debe tomar parte de la sangre de la ofrenda por el pecado con su dedo y ponerla en los cuernos del altar de la ofrenda quemada, y derramar el resto de la sangre en la base del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Quemará toda su grasa en el altar como la grasa de las ofrendas de paz. De esta manera el sacerdote expiará el pecado del hombre y será perdonado. ");
INSERT INTO spavbl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Si cualquier otro israelita peca involuntariamente y hace lo que no está permitido por ninguno de los mandamientos del Señor su Dios, es culpable. ");
INSERT INTO spavbl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Cuando se dé cuenta de su pecado, debe traer una cabra sin defectos como ofrenda por ese pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Debe poner su mano en la cabeza de la ofrenda por el pecado y matarla en el lugar del holocausto. ");
INSERT INTO spavbl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Entonces el sacerdote debe tomar un poco de su sangre con su dedo y ponerla en los cuernos del altar de la ofrenda quemada, y derramar el resto de la sangre en la base del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Le quitará toda su grasa como la grasa de las ofrendas de paz y la quemará en el altar y será aceptada por el Señor. De esta manera el sacerdote expiará el pecado del hombre y será perdonado. ");
INSERT INTO spavbl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Si trae un cordero como ofrenda por el pecado, debe traer una hembra sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Debe poner su mano en la cabeza de la ofrenda por el pecado y matarla como ofrenda por el pecado en el lugar donde se hace el holocausto. ");
INSERT INTO spavbl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Entonces el sacerdote debe tomar un poco de su sangre con su dedo y ponerla en los cuernos del altar de la ofrenda quemada, y derramar el resto de la sangre en la base del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Le quitará toda su grasa como la grasa del cordero se quita de las ofrendas de paz y la quemará en el altar y será aceptada por el Señor. De esta forma el sacerdote expiará el pecado del hombre, y será perdonado”. ");
INSERT INTO spavbl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Si tú pecas por no suministrar las pruebas necesarias en un caso legal, ya sea que tú mismo hayas visto o escuchado algo al respecto, eres responsable de tu culpabilidad. ");
INSERT INTO spavbl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Si tocas algo sucio como el cadáver de un animal salvaje impuro o animales de granja o bichos, incluso si no eres consciente de ello, serás impuro y culpable. ");
INSERT INTO spavbl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Si tocas algo sucio de alguien que es sucio, incluso si no eres consciente de ello, serás culpable. ");
INSERT INTO spavbl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Si juras imprudentemente hacer algo, (ya sea bueno o malo, y de cualquier manera que la gente pueda jurar impulsivamente), incluso si no eres consciente de que está mal, cuando finalmente te das cuenta, serás culpable. ");
INSERT INTO spavbl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Si te vuelves culpable de una de estas formas, debes confesar tu pecado, ");
INSERT INTO spavbl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","y debes llevar tu ofrenda de culpa de un cordero o cabra hembra al Señor como una ofrenda por tu pecado. El sacerdote expiará tu pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Si no te alcanza para comprar un cordero, puedes ofrecer al Señor como compensación por tu pecado dos tórtolas o dos palomas jóvenes, una como ofrenda por el pecado y otra como holocausto. ");
INSERT INTO spavbl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Debes llevarlos al sacerdote, quien presentará el primero como la ofrenda por el pecado. Él debe arrancarle la cabeza del cuello sin quitarla completamente. ");
INSERT INTO spavbl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Luego debe rociar parte de la sangre de la ofrenda por el pecado en el lado del altar mientras el resto de la sangre es derramada en la base del altar. Es una ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","El sacerdote debe entonces preparar la segunda tórtola como holocausto según las normas. De esta manera el sacerdote te justificará por tus pecados, y serás perdonado. ");
INSERT INTO spavbl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Si no te alcanza para comprar dos tórtolas o dos pichones, puedes traer un décimo de efa de la mejor harina como ofrenda por el pecado. No le pongas aceite de oliva o incienso, porque es una ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Llévala al sacerdote, que tomará un puñado como ‘recordatorio’ y lo quemará en el altar sobre las ofrendas quemadas al Señor. Es una ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Así es como el sacerdote expiará cualquiera de estos pecados que hayas cometido, y serás perdonado. El resto de la ofrenda pertenecerá al sacerdote, al igual que la ofrenda de grano”. ");
INSERT INTO spavbl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Si alguno de ustedes descuida involuntariamente todo lo que el Señor ha declarado que le pertenece y es santo, debes llevar tu ofrenda de culpabilidad al Señor: un carnero sin defectos de tu rebaño o sólo uno de valor equivalente en siclos de plata (según el estándar del siclo del santuario). Es una ofrenda por la culpa. ");
INSERT INTO spavbl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","En cuanto a cualquier requisito sagrado que no hayas aportado, debes pagar una compensación añadiéndole un quinto de su valor y luego dárselo al sacerdote, que lo arreglará con el carnero como ofrenda por la culpa, y serás perdonado. ");
INSERT INTO spavbl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Si pecas y quebrantas alguno de los mandamientos del Señor, aunque no seas consciente de ello, sigues siendo culpable y asumes la responsabilidad de tu culpa. ");
INSERT INTO spavbl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Debes llevar al sacerdote un carnero sin defectos y de valor apropiado como ofrenda de culpabilidad. Entonces expiará por ti el mal que hiciste en la ignorancia, y serás perdonado. ");
INSERT INTO spavbl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Es una ofrenda de culpa porque fuiste culpable en lo que concierne al Señor”. ");
INSERT INTO spavbl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Si pecas contra el Señor, rompiendo tu compromiso con él, entonces esto es lo que debe suceder. Puede que le hayas mentido a tu vecino sobre algo que cuidabas para ellos, o sobre algún depósito pagado, sobre algo que fue robado, o tal vez tratabas de engañarlos. ");
INSERT INTO spavbl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Puede que hayas encontrado una propiedad que alguien perdió, y mentiste e hiciste declaraciones falsas sobre ello, o has pecado de otras maneras en tales situaciones. ");
INSERT INTO spavbl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Si has pecado y te vuelves culpable debes devolver lo que has robado o engañado a tus víctimas, el depósito que tomaste, la propiedad perdida que encontraste, ");
INSERT INTO spavbl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","o cualquier otra cosa que deba ser devuelta y sobre la que hayas mentido. Debes pagar la compensación completa más una quinta parte del valor, y dársela al dueño tan pronto como aceptes que eres culpable de pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Luego debes llevar al sacerdote tu ofrenda de culpabilidad para el Señor: un carnero sin defectos del valor apropiado del rebaño. ");
INSERT INTO spavbl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Así es como el sacerdote te hará justicia ante el Señor, y se te perdonarán todos los pecados que hayas cometido y de los que seas culpable”. ");
INSERT INTO spavbl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Instruye a Aarón y a sus hijos respecto al holocausto: La ofrenda quemada debe dejarse ardiendo sobre altar durante toda la noche hasta la mañana, y el fuego en el altar debe mantenerse encendido. ");
INSERT INTO spavbl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","El sacerdote se pondrá sus ropas de lino y su ropa interior, y tomará del altar las cenizas grasosas del holocausto que el fuego ha quemado y las pondrá al lado del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Luego se cambiará de ropa y llevará las cenizas fuera del campamento a un lugar que esté ceremonialmente limpio. ");
INSERT INTO spavbl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","El fuego del altar debe mantenerse encendido, no dejarlo apagarse. Cada mañana el sacerdote debe añadir leña al fuego, colocar cuidadosamente la ofrenda quemada en él, y quemar las partes gordas de las ofrendas de paz en él. ");
INSERT INTO spavbl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","El fuego debe mantenerse encendido en el altar continuamente, no lo dejes apagar. ");
INSERT INTO spavbl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Estas son las regulaciones para la ofrenda de grano: Los hijos de Aarón deben presentarla ante el Señor, delante del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","El sacerdote quitará un puñado de la mejor harina mezclada con aceite de oliva, así como todo el incienso de la ofrenda de grano, y quemará la ‘parte recordatoria’ en el altar para ser aceptada por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","El resto es para que Aarón y sus hijos lo coman. Debe comerse sin levadura en un lugar santo, el patio del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","No debe ser horneado con levadura. Lo he proporcionado como su parte de mis ofrendas de comida. Es muy sagrado, como la ofrenda por el pecado y la ofrenda por la culpa. ");
INSERT INTO spavbl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Cualquiera de los descendientes masculinos de Aarón puede comerlo. Es una asignación permanente de las ofrendas de comida al Señor para las generaciones futuras. Todo lo que los toque se convertirá en sagrado”. ");
INSERT INTO spavbl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Esta es la ofrenda que Aarón y sus hijos deben presentar al Señor cuando sean ungidos: una décima parte de una efa de la mejor harina como ofrenda de grano habitual, la mitad por la mañana y la mitad por la tarde. ");
INSERT INTO spavbl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Cocínalo con aceite de oliva en una plancha. Llevarlo bien amasado y presentarlo como una ofrenda de grano partido en pedazos, para ser aceptado por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Debe ser cocinado por el sacerdote que es uno de los descendientes de Aarón y que debe ser ungido para tomar su lugar. En este caso, como está asignado permanentemente al Señor, debe ser quemado completamente. ");
INSERT INTO spavbl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Cada ofrenda de grano para un sacerdote debe ser quemada completamente. No debe ser comida”. ");
INSERT INTO spavbl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Dile a Aarón y a sus hijos que estas son las normas para la ofrenda por el pecado. La ofrenda por el pecado debe ser matada donde el holocausto es matado ante el Señor, y es muy sagrada. ");
INSERT INTO spavbl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","El sacerdote que ofrece la ofrenda por el pecado debe comerla. Debe comerse sin levadura en un lugar santo, el patio del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Todo lo que lo toque se convertirá en sagrado y si algo de la sangre se salpica en la ropa, debe lavarse en un lugar santo. ");
INSERT INTO spavbl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","La olla de barro que se usa para hervir la ofrenda por el pecado debe romperse. Si se hierve en una olla de bronce, la olla debe ser limpiada a fondo y lavada con agua. ");
INSERT INTO spavbl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Cualquier varón entre los sacerdotes puede comerla, es muy sagrada. ");
INSERT INTO spavbl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pero no se puede comer ninguna ofrenda por el pecado si su sangre ha sido llevada al Tabernáculo de Reunión como medio para arreglar las cosas en el Lugar Santo. En ese caso debe ser quemada”. ");
INSERT INTO spavbl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Estas son las regulaciones para la ofrenda de la culpa, es muy sagrada. ");
INSERT INTO spavbl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","La ofrenda de culpa debe ser matada donde se mata el holocausto, y el sacerdote rociará su sangre a todos los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Toda la grasa de ella será ofrecida: la cola gorda, la grasa que cubre las entrañas, ");
INSERT INTO spavbl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ambos riñones con la grasa sobre ellos por los lomos, y la mejor parte del hígado, que el sacerdote debe quitar junto con los riñones. ");
INSERT INTO spavbl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Los quemará en el altar como ofrenda al Señor; es una ofrenda por la culpa. ");
INSERT INTO spavbl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Cualquier varón entre los sacerdotes puede comerla. Debe comerse en un lugar santo, es muy sagrado. ");
INSERT INTO spavbl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","La ofrenda por la culpa es como la ofrenda por el pecado; las normas son las mismas para ambas. El sacerdote que presenta la ofrenda que ‘hace las cosas bien’ debe tenerla. ");
INSERT INTO spavbl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","En el caso de los holocaustos ordinarios, el sacerdote debe tener la piel del animal. ");
INSERT INTO spavbl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","De la misma manera, todas las ofrendas de grano que se cocinan en un horno o en una cacerola o en una plancha son para el sacerdote que las presenta, ");
INSERT INTO spavbl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","y todas las ofrendas de grano, ya sea mezcladas con aceite de oliva o secas, son para todos los descendientes de Aarón. ");
INSERT INTO spavbl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Estas son las reglas para la ofrenda de paz que puedes presentar al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Sila ofrecen con espíritu de agradecimiento, entonces junto con el sacrificio de acción de gracias, deben ofrecer pan, obleas y pasteles bien amasados de la mejor harina, todo ello hecho sin levadura y mezclado o cubierto con aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Además de tu ofrenda de paz de acción de gracias de los panes hechos sin levadura, presentarás una ofrenda de panes hechos con levadura. ");
INSERT INTO spavbl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Presentenuno de cada tipo de pan de la ofrenda como contribución al Señor. Es para el sacerdote que rocía la sangre de la ofrenda de paz. ");
INSERT INTO spavbl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","La carne del sacrificio de tu ofrenda de paz de acción de gracias debe comerse el mismo día que la ofrezcas. No dejes nada de eso hasta la mañana. ");
INSERT INTO spavbl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Si el sacrificio que ofreces es para pagar un voto o una ofrenda voluntaria, se comerá el día que presentes tu sacrificio, pero lo que quede puede comerse al día siguiente. ");
INSERT INTO spavbl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Sin embargo, cualquier carne del sacrificio que quede al tercer día debe ser quemada. ");
INSERT INTO spavbl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Si comes algo de la carne de tu ofrenda de paz al tercer día, no será aceptada. No recibirás crédito por ofrecerla. De hecho, será tratada como algo asqueroso, y cualquiera que la coma será responsable de su culpa. ");
INSERT INTO spavbl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Si esta carne toca algo impuro no debe ser comida; debe ser quemada. Esta carne puede ser consumida por aquellos que están ceremonialmente limpios. ");
INSERT INTO spavbl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Si alguien que es inmundo come carne de la ofrenda de paz dada al Señor, debe ser expulsado de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Cualquiera que toque algo impuro, ya sea de una persona, un animal impuro o una cosa inmunda repugnante, y luego coma carne de la ofrenda de paz dada al Señor, debe ser expulsado de su pueblo”. ");
INSERT INTO spavbl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Dales estas instrucciones a los israelitas. Diles: ‘No debes comer nada de la grasa de un toro, una oveja o una cabra. ");
INSERT INTO spavbl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Puedes usar la grasa de un animal encontrado muerto o muerto por bestias salvajes para cualquier propósito que desees, pero no debes comerla. ");
INSERT INTO spavbl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Cualquiera que coma la grasa de un animal de una ofrenda de comida presentada al Señor debe ser expulsado de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","No deben comer la sangre de ningún pájaro o animal en ninguno de sus hogares. ");
INSERT INTO spavbl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Cualquiera que coma sangre debe ser expulsado de su pueblo’”. ");
INSERT INTO spavbl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Dales estas instrucciones a los israelitas. Diles que si presentas una ofrenda de paz al Señor debes traer parte de ella como un regalo especial para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Debes traer personalmente las ofrendas de comida al Señor; deben traer la grasa así como el pecho, y mecer el pecho como ofrenda mecida ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","El sacerdote quemará la grasa en el altar, pero el pecho es para Aarón y sus hijos. ");
INSERT INTO spavbl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Dale el muslo derecho al sacerdote como contribución de tu ofrenda de paz. ");
INSERT INTO spavbl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","El sacerdote como descendiente de Aarón que ofrece la sangre y la grasa de la ofrenda de paz tiene el muslo derecho como su parte. ");
INSERT INTO spavbl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","He requerido de los israelitas el pecho de la ofrenda mecida y la contribución del muslo de sus ofrendas de paz, y se las he dado a Aarón el sacerdote y a sus hijos como su parte de los israelitas para siempre”. ");
INSERT INTO spavbl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Esta es la parte de las ofrendas de alimentos entregadas al Señor que pertenece a Aarón y sus hijos desde el día en que fueron designados para servir al Señor como sacerdotes. ");
INSERT INTO spavbl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Desde el día en que fueron ungidos, el Señor ordenó que esto les fuera dado por los hijos de Israel. Es su parte para las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Estas son las regulaciones con respecto al holocausto, la ofrenda de grano, la ofrenda por el pecado, la ofrenda por la culpa, la ofrenda de ordenación y la ofrenda de paz. ");
INSERT INTO spavbl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","El Señor se las dio a Moisés en el Monte Sinaí en el momento en que ordenó a los israelitas que le dieran sus ofrendas en el desierto del Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ve con Aarón y sus hijos, y toma sus vestidos sacerdotales, el aceite de la unción, el toro de la ofrenda por el pecado, dos carneros y la cesta de los panes sin levadura, ");
INSERT INTO spavbl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","y haz que todos se reúnan a la entrada del Tabernáculo de Reunión”. ");
INSERT INTO spavbl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moisés hizo lo que le ordenó el Señor, y todos se reunieron a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moisés les dijo: “Lo siguiente es lo que el Señor ha ordenado que se haga”. ");
INSERT INTO spavbl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moisés hizo pasar a Aarón y a sus hijos y los lavó con agua. ");
INSERT INTO spavbl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Vistió a Aarón con la túnica, le ató el cinto, le puso el manto y luego el efod. Ató la cintura del efod alrededor de él, sujetándolo. ");
INSERT INTO spavbl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Luego Moisés sujetó el pectoral a Aarón y puso el Urim y Tumim en el pectoral. ");
INSERT INTO spavbl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Puso el turbante en la cabeza de Aarón y colocó la placa de oro, la corona sagrada, en la parte delantera del turbante, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Entonces Moisés tomó el aceite de la unción y ungió el tabernáculo y todo lo que había en él para dedicarlo todo. ");
INSERT INTO spavbl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Roció siete veces el aceite sobre el altar para ungirlo y todos sus utensilios, así como la palangana con su soporte para dedicarlo. ");
INSERT INTO spavbl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Moisés derramó parte del aceite de la unción sobre la cabeza de Aarón para ungirlo y dedicarlo. ");
INSERT INTO spavbl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Entonces Moisés hizo que los hijos de Aarón se acercaran, les vistió con sus túnicas, les ató fajas y les envolvió con cintas para la cabeza, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Moisés trajo el toro para la ofrenda por el pecado, y Aarón y sus hijos pusieron sus manos sobre su cabeza. ");
INSERT INTO spavbl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moisés mató al toro y tomó parte de la sangre. Con su dedo puso la sangre en los cuatro cuernos del altar para consagrarlo y purificarlo. Derramó el resto de la sangre en el fondo del altar, y consagró el altar para que pudiera ser utilizado para expiar al pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moisés tomó toda la grasa que cubre las entrañas, la mejor parte del hígado, ambos riñones con la grasa en ellos, la quemó toda en el altar. ");
INSERT INTO spavbl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Pero el resto del toro - la piel, la carne y los desechos - lo quemó fuera del campamento, como el Señor le había indicado. ");
INSERT INTO spavbl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Moisés trajo el carnero para el holocausto, y Aarón y sus hijos pusieron sus manos sobre su cabeza. ");
INSERT INTO spavbl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moisés mató el carnero y roció la sangre a todos los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Dividió el carnero en pedazos y quemó la cabeza, los pedazos y la grasa. ");
INSERT INTO spavbl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Lavó las entrañas y las piernas con agua y quemó todo el carnero en el altar como una ofrenda quemada, una ofrenda de comida para ser aceptada por el Señor, como el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Moisés trajo el segundo carnero, el carnero de la ordenación, y Aarón y sus hijos pusieron sus manos sobre su cabeza. ");
INSERT INTO spavbl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moisés mató al carnero y tomó un poco de su sangre. La puso en el lóbulo de la oreja derecha de Aarón, en el pulgar de su mano derecha y en el dedo gordo de su pie derecho. ");
INSERT INTO spavbl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Entonces Moisés hizo que Aarón y sus hijos se acercaran y pusieran un poco de la sangre en el lóbulo de su oreja derecha, en los pulgares de su mano derecha y en los dedos gordos de su pie derecho. Luego roció la sangre a todos los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Moisés tomó la grasa, incluyendo la cola gorda, toda la grasa de las entrañas, la mejor parte del hígado, ambos riñones con la grasa encima Moisés tomó la grasa junto con el muslo derecho. ");
INSERT INTO spavbl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Tomó una barra de pan sin levadura, una barra hecha con aceite de oliva y una oblea de la cesta de pan sin levadura que estaba en la presencia del Señor. Los colocó encima de las porciones de grasa y en el muslo derecho. ");
INSERT INTO spavbl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Luego se los dio a Aarón y a sus hijos, y los agitó ante el Señor como ofrenda mecida. ");
INSERT INTO spavbl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Después de esto, Moisés los tomó y los quemó en el altar con el holocausto. Esta era una ofrenda de ordenación, una ofrenda de comida para ser aceptada por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moisés entonces tomó el pecho, su parte del carnero de ordenación, y lo agitó ante el Señor como ofrenda mecida, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moisés tomó entonces parte del aceite de la unción y parte de la sangre del altar. Roció ambos sobre las ropas de Aarón y sus hijos. Así es como dedicó las ropas de Aarón y sus hijos. ");
INSERT INTO spavbl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moisés dijo a Aarón y a sus hijos: “Deben hervir la carne a la entrada del Tabernáculo de Reunión, y luego cómansela allí con el pan que está en el cesto de las ofrendas para la ordenación, como ordené: ‘Es para que coman Aarón y sus hijos’. ");
INSERT INTO spavbl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Después debes quemar lo que queda de la carne y el pan. ");
INSERT INTO spavbl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","“No deben abandonar la entrada del Tabernáculo de Reunión durante siete días hasta que la ceremonia de ordenación haya terminado, porque la ordenación tardará siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Lo que se ha hecho hoy ha sido ordenado por el Señor como un medio para justificarte. ");
INSERT INTO spavbl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Deben permanecer a la entrada del Tabernáculo de Reunión durante siete días, día y noche, y seguir las órdenes del Señor para que no mueran, porque esto es lo que se me ha mandado a hacer”. ");
INSERT INTO spavbl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aarón y sus hijos hicieron todo lo que el Señor les ordenó a través de Moisés. ");
INSERT INTO spavbl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Al octavo día después de la ordenación, Moisés llamó a Aarón y a sus hijos, y a los ancianos de Israel, para reunirse con él. ");
INSERT INTO spavbl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Le dijo a Aarón: “Debes traer un novillo como ofrenda por el pecado y un carnero como holocausto, ambos sin defectos, y presentarlos ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Entonces les dijo a los israelitas: ‘Traigan las siguientes ofrendas: un macho cabrío como sacrificio por el pecado; un becerro y un cordero, (ambos de un año y sin defectos), para un holocausto; ");
INSERT INTO spavbl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","un toro y un carnero como sacrificio de paz para presentarlos ante el Señor; y una ofrenda de grano mezclado con aceite de oliva. Haced esto porque hoy el Señor se va a revelar a ustedes hoy’”. ");
INSERT INTO spavbl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Siguiendo las órdenes de Moisés trajeron lo que había dicho al frente del Tabernáculo de Reunión. Todos vinieron y se presentaron ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moisés dijo: “Esto es lo que el Señor me ordenó que te dijera, para que veas su gloria”. ");
INSERT INTO spavbl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Entonces Moisés le dijo a Aarón: “Ve al altar y sacrifica tu ofrenda por el pecado y tu holocausto para que tú y el pueblo estén bien. Luego sacrifica las ofrendas traídas por el pueblo para enderezarlas, como el Señor lo ordenó”. ");
INSERT INTO spavbl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Así que Aarón fue al altar y mató el becerro como ofrenda por el pecado para sí mismo. ");
INSERT INTO spavbl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Sus hijos le trajeron la sangre. Él mojó su dedo en la sangre y la puso en los cuernos del altar. Derramó el resto de la sangre en la parte inferior del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Quemó la grasa, los riñones y la mejor parte del hígado de la ofrenda por el pecado en el altar, como el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Sin embargo, quemó la carne y la piel fuera del campamento. ");
INSERT INTO spavbl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aarón mató la ofrenda quemada. Sus hijos le trajeron la sangre y él la roció a los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Le trajeron la cabeza y todos los demás pedazos del holocausto, y él los quemó en el altar. ");
INSERT INTO spavbl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Lavó las entrañas y las piernas y las quemó con el resto del holocausto en el altar. ");
INSERT INTO spavbl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Entonces Aarón presentó las ofrendas del pueblo. Mató al macho cabrío como ofrenda por el pecado del pueblo, y lo ofreció de la misma manera que su propia ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Presentó la ofrenda quemada, haciéndolo de acuerdo con las regulaciones. ");
INSERT INTO spavbl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Presentó la ofrenda de grano. Tomó un puñado de él y lo quemó en el altar, además de la ofrenda quemada presentada esa mañana. ");
INSERT INTO spavbl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aarón mató al toro y al carnero como ofrenda de paz para el pueblo. Sus hijos le trajeron la sangre, y él la roció a los lados del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","También le trajeron las porciones de grasa del toro y del carnero: el rabo gordo, la grasa que cubre las entrañas, los riñones y la mejor parte del hígado ");
INSERT INTO spavbl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","y las pusieron sobre los pechos. Aarón quemó las porciones de grasa en el altar, ");
INSERT INTO spavbl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","pero agitó los pechos y el muslo derecho como ofrenda ondulante ante el Señor, como Moisés le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Entonces Aarón levantó las manos hacia el pueblo y lo bendijo. Después bajó del altar, habiendo completado la ofrenda por el pecado, el holocausto y el sacrificio de paz. ");
INSERT INTO spavbl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moisés y Aarón entraron en el Tabernáculo de Reunión. Cuando salieron, bendijeron al pueblo, y la gloria del Señor se reveló a todos. ");
INSERT INTO spavbl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Un fuego salió de la presencia del Señor y quemó el holocausto y las porciones de grasa en el altar. Cuando todos vieron esto, gritaron de alegría y cayeron con el rostro en el suelo. ");
INSERT INTO spavbl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Los hijos de Aarón, Nadab y Abiú, encendieron sus quemadores de incienso usando fuego ordinario y encendieron sus quemadores de incienso usando fuego ordinario y pusieron incienso, y de esta manera ofrecieron fuego prohibido en la presencia del Señor, algo que él no había autorizado. ");
INSERT INTO spavbl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","El fuego salió de la presencia del Señor y los quemó. Murieron en la presencia del Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moisés explicó a Aarón: “Esto es lo que el Señor estaba hablando cuando dijo: ‘Mostraré mi santidad a los que se acerquen a mí; revelaré mi gloria para que todos la vean’”. Pero Aarón no respondió. ");
INSERT INTO spavbl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moisés llamó a Misael y a Elzafán, hijos del tío de Aarón, Uziel, y les dijo: “Vengan y lleven los cuerpos de sus primos y llévenlos fuera del campamento, lejos del frente del santuario”. ");
INSERT INTO spavbl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Vinieron, los recogieron por sus ropas y los llevaron fuera del campamento, como Moisés había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Entonces Moisés dijo a Aarón y a sus hijos Eleazar e Itamar: “No dejensus cabellos sin peinar, ni rasguen sus vestidos de luto, de lo contrario, morirán y el Señor se enfadará con todos. Pero tus parientes y todos los demás israelitas pueden llorar por los que el Señor mató con fuego. ");
INSERT INTO spavbl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","No salgas de la entrada del Tabernáculo de Reunión, o morirás, porque has sido ungido por el Señor”. Hicieron lo que dijo Moisés. ");
INSERT INTO spavbl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","El Señor le dijo a Aarón: ");
INSERT INTO spavbl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Tú y tu descendencia no deben beber vino ni ningún otro tipo de alcohol cuando entren al Tabernáculo de Reunión, de lo contrario morirán. Esta norma es para siempre y para todas las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Debes darte cuenta de la diferencia entre lo santo y lo ordinario, entre lo limpio y lo impuro, ");
INSERT INTO spavbl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","para que puedas enseñar a los israelitas todas las normas que el Señor les ha dado a través de Moisés”. ");
INSERT INTO spavbl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moisés dijo a Aarón y a sus dos hijos que quedaban, Eleazar e Itamar: “Tomen la ofrenda de grano que sobra de las ofrendas dadas al Señor y comedla sin levadura junto al altar, porque es muy santa. ");
INSERT INTO spavbl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Deben comerlo en un lugar santo, porque es la parte que os corresponde a ustedes y a sus descendientes de las ofrendas dadas al Señor. Esto es lo que me han ordenado. ");
INSERT INTO spavbl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“Tú y tus descendientes masculinos y femeninos pueden comer el pecho de la ofrenda ondulada y la contribución del muslo en cualquier lugar que esté ceremonialmente limpio, porque a ti y a tus descendientes se les ha dado esto como su parte de las ofrendas de paz de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","La contribución del muslo y el pecho de la ofrenda mecida, así como las porciones de grasa de las ofrendas de comida hechas, deben ser traídas y mecidas como ofrenda mecida ante el Señor. Te pertenecen a ti y a tus hijos para siempre, como el Señor ha ordenado”. ");
INSERT INTO spavbl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moisés comprobó lo que había sucedido con el macho cabrío de la ofrenda por el pecado, y descubrió que había sido quemado. Se enfadó con Eleazar e Itamar, los hijos que Aarón había dejado, y les preguntó, ");
INSERT INTO spavbl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“¿Por qué no tomaron la ofrenda por el pecado y la comieron en el lugar santo, porque es muy santa y se les dio para quitar la culpa del pueblo, haciéndolo justo ante el Señor? ");
INSERT INTO spavbl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Como su sangre no fue llevada al lugar santo, debieron comerla en el área del santuario, como yo ordené”. ");
INSERT INTO spavbl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Entonces Aarón le explicó a Moisés: “Mira, fue hoy cuando presentaron su ofrenda por el pecado y su holocausto ante el Señor. Después de todo lo que me acaba de pasar, ¿se habría complacido el Señor si yo hubiera comido la ofrenda por el pecado hoy?” ");
INSERT INTO spavbl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Cuando Moisés escuchó lo que Aarón tenía que decir, aceptó la explicación. ");
INSERT INTO spavbl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","El Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spavbl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Den estas instrucciones a los israelitas. Estos son los animales que se les permite comer: ");
INSERT INTO spavbl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","cualquier animal que tenga una pezuña dividida y que también mastique el bolo alimenticio. ");
INSERT INTO spavbl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Sin embargo, si mastica el bolo alimenticio, o tiene una pezuña dividida, entonces no puedes comerlo. Estos incluyen: el camello, que aunque mastica el bolo alimenticio no tiene una pezuña dividida, por lo que es inmune para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Eldamán de las rocas, que aunque mastica el bolo alimenticio no tiene una pezuña dividida, por lo que es inmune para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","La liebre, que aunque mastica el bolo alimenticio no tiene una pezuña dividida, así que es inmunda para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","El cerdo, que aunque tiene una pezuña dividida no mastica el bolo alimenticio, así que es inmundo para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","No debes comer su carne ni tocar sus cuerpos de cuentas. Son inmundos para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Puedes comer cualquier criatura con aletas y escamas que viva en el agua, ya sea en el mar o en agua dulce. ");
INSERT INTO spavbl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Pero no puedes comer ninguna de las muchas criaturas que no tienen aletas y escamas y que viven en el agua, ya sea en el mar o en agua dulce. ");
INSERT INTO spavbl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Son repulsivos. No debes comer su carne, y debes tratar sus cadáveres como impuros. ");
INSERT INTO spavbl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Todas esas criaturas marinas que no tienen aletas y escamas deben ser reprobables para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“En cuanto a las aves, estas no deben ser consumidas porque son impuras: águila, buitre leonado, quebrantahuesos, ");
INSERT INTO spavbl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ratonero, milano y aves de presa similares, ");
INSERT INTO spavbl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","cualquier cuervo o cuervo, ");
INSERT INTO spavbl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","cárabo, búho chico, gaviotas, cualquier tipo de halcón, ");
INSERT INTO spavbl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","mochuelo, búho pescador, búho real, ");
INSERT INTO spavbl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","lechuza de los establos, búho del desierto, buitre egipcio, ");
INSERT INTO spavbl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","cigüeñas y cualquier tipo de garza, abubilla y murciélagos. ");
INSERT INTO spavbl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Todos los insectos voladores que se arrastran serán impuros para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Pero puedes comer los siguientes tipos de insectos voladores que se arrastran: Los que tienen patas articuladas y que usan para saltar. ");
INSERT INTO spavbl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Así que en esta categoría puedes comer cualquier tipo de langosta, langosta calva, grillo o saltamontes. ");
INSERT INTO spavbl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Todos los demás insectos voladores que se arrastran serán reprobables para ti, ");
INSERT INTO spavbl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","y te harán impuro. Si tocas sus cadáveres serás impuro hasta la noche, ");
INSERT INTO spavbl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","y si recoges uno de sus cadáveres debes lavar tu ropa, y serás impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Todo animal con pezuñas que no estén divididas, o que no mastique la baba, es impuro para ti. Si tocas alguno de ellos serás impuro. ");
INSERT INTO spavbl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Cualquier animal de cuatro patas que camine sobre sus patas es impuro para ti. Si tocas sus cadáveres serás impuro hasta la noche, ");
INSERT INTO spavbl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","y si recoges uno de sus cadáveres debes lavar tu ropa, y serás impuro hasta la noche. Ellos son inmundos para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Los siguientes animales que corren por el suelo son inmundos para ti: ratas, ratones, cualquier tipo de lagarto grande, ");
INSERT INTO spavbl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geco, lagarto monitor, lagarto de pared, el eslizón y el camaleón. ");
INSERT INTO spavbl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Estos animales que corren por el suelo son inmundos para ti. Si tocas uno de ellos, estarás sucio hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“Cualquier cosa que uno de ellos muera y caiga sobre él se vuelve inmundo. Sea lo que sea, algo hecho de madera, ropa, cuero, tela de saco o cualquier herramienta de trabajo, debe ser lavado con agua y será impuro hasta la noche. Entonces se volverá limpio. ");
INSERT INTO spavbl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Si uno de ellos cae en una vasija de arcilla, todo lo que hay en ella se vuelve impuro. Debes romper la olla. ");
INSERT INTO spavbl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Si el agua de esa olla toca algún alimento, ese alimento se vuelve impuro, y cualquier bebida de una olla como esa también se vuelve impura. ");
INSERT INTO spavbl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Cualquier cosa sobre la que caiga uno de sus cadáveres se vuelve inmunda. Si se trata de un horno o una estufa, debe ser aplastado. Es permanentemente impuro para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Por otro lado, si es un manantial o una cisterna que contiene agua, entonces permanecerá limpia, pero si tocas uno de estos cadáveres en ella estarás sucio. ");
INSERT INTO spavbl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","De igual manera, si uno de sus cadáveres cae sobre cualquier semilla utilizada para la siembra, la semilla permanece limpia; ");
INSERT INTO spavbl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","pero si la semilla ha sido empapada en agua y uno de sus cadáveres cae sobre ella, es impura para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Si muere un animal que se te permite comer, cualquiera que toque el cadáver será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Si comes algo del cadáver debes lavar tu ropa y serás impuro hasta la noche. Si recoges el cadáver debes lavar tu ropa y estarás sucio hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Todo animal que se arrastra por el suelo es repulsivo, no debes comerlo. ");
INSERT INTO spavbl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","No comas ningún animal que se arrastre por el suelo, ya sea que se mueva sobre su vientre o camine sobre cuatro o muchos pies. Todos esos animales son repulsivos. ");
INSERT INTO spavbl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","No se contaminen con ningún animal que se arrastre. No se contaminen por causa de ellos, ");
INSERT INTO spavbl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","porque yo soy el Señor su Dios; así que dedíquense y sean santos, porque yo soy santo. No se contaminen con ningún animal que se arrastre por el suelo. ");
INSERT INTO spavbl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Yo soy el Señor que os sacó de Egipto para ser su Dios. Así que sed santos, porque yo soy santo. ");
INSERT INTO spavbl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Estas son las normas sobre los animales, las aves, todo lo que vive en el agua, y todos los animales que se arrastran por la tierra. ");
INSERT INTO spavbl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Debes reconocer la diferencia entre lo impuro y lo limpio, entre los animales que se pueden comer y los que no”. ");
INSERT INTO spavbl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","El Señor le dijo a Moisés: “Dales estas instrucciones a los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Toda mujer que quede embarazada y tenga un niño, será impura durante una semana, de la misma manera que es impura durante su período. ");
INSERT INTO spavbl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","El prepucio del niño debe ser circuncidado al octavo día. ");
INSERT INTO spavbl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","La mujer debe esperar otros treinta y tres días para la purificación de su sangrado. No se le permite tocar nada sagrado, y no se le permite entrar en el santuario hasta que termine el tiempo de purificación. ");
INSERT INTO spavbl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Si una mujer tiene una hija, estará impura durante dos semanas, de la misma manera que lo está durante su período menstrual. La mujer debe esperar otros sesenta y seis días para la purificación de su sangre. ");
INSERT INTO spavbl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Una vez que el tiempo de purificación haya terminado para un hijo o una hija, la mujer debe traer un cordero de un año como ofrenda quemada y una paloma joven o una tórtola como ofrenda de purificación. Debe llevar sus ofrendas al sacerdote a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","El sacerdote las presentará al Señor para purificarla y que quede limpia de su sangrado. Estas son las normas para una mujer después de haber tenido un hijo o una hija. ");
INSERT INTO spavbl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Si una mujer no puede permitirse traer un cordero, debe traer dos tórtolas o dos pichones. Una es para el holocausto y la otra para la ofrenda de purificación. El sacerdote las ofrecerá para purificarla, y ella quedará limpia”. ");
INSERT INTO spavbl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","El Señor le dijo a Moisés y a Aarón: ");
INSERT INTO spavbl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Cualquiera que tenga una hinchazón, un sarpullido o una mancha en la piel que pueda ser una enfermedad infecciosa de la piel debe ser llevado a Aarón el sacerdote o a uno de sus descendientes. ");
INSERT INTO spavbl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","El sacerdote inspeccionará lo que sea que esté en la piel. Si el pelo se ha vuelto blanco y si el problema parece ser más que algo en la superficie, es una enfermedad grave de la piel, y el sacerdote que lo inspeccione declarará a la persona impura. ");
INSERT INTO spavbl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“Pero si la mancha es sólo una decoloración blanca y no parece ser más que superficial, y si el pelo de la mancha no se ha vuelto blanco, el sacerdote pondrá a la persona en aislamiento durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Al séptimo día el sacerdote realizará otra inspección, y si descubre que la mancha no ha cambiado y no se ha extendido sobre la piel, el sacerdote debe poner a la persona en aislamiento durante otros siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Al séptimo día después de esto el sacerdote lo inspeccionará de nuevo. Si la mancha se ha desvanecido y no se ha extendido sobre la piel, el sacerdote declarará a la persona limpia ya que era un sarpullido. Deben lavar su ropa y estarán limpios. ");
INSERT INTO spavbl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Sin embargo, si el sarpullido se extiende después de que la persona ha sido inspeccionada por el sacerdote y ha sido declarada limpia, la persona debe volver para ser inspeccionada de nuevo. ");
INSERT INTO spavbl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Si el sacerdote descubre que el sarpullido se ha propagado, debe declarar a la persona impura porque es ciertamente una enfermedad de la piel. ");
INSERT INTO spavbl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Cualquier persona que desarrolle una enfermedad infecciosa de la piel debe ser llevada al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","El sacerdote los inspeccionará, y si hay una hinchazón blanca en la piel y el pelo se ha vuelto blanco, y hay una herida abierta en la hinchazón, ");
INSERT INTO spavbl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","es una enfermedad grave de la piel y el sacerdote debe declararlos inmundos. No necesita poner a la persona en aislamiento porque sea impura. ");
INSERT INTO spavbl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Sin embargo, si la enfermedad de la piel afecta a toda su piel de manera que cubre su piel de la cabeza a los pies, en todos los lugares que el sacerdote pueda ver, ");
INSERT INTO spavbl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","el sacerdote los inspeccionará, y si la enfermedad ha cubierto todo su cuerpo, declarará a la persona limpia. Como todo se ha vuelto blanco, están limpios. ");
INSERT INTO spavbl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Pero si al inspeccionar a alguien se encuentra una herida abierta, serán inmundos. ");
INSERT INTO spavbl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Cuando el sacerdote descubre una herida abierta, debe declarar a la persona impura. La herida abierta es impura; es una enfermedad infecciosa de la piel. ");
INSERT INTO spavbl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Pero si la herida abierta se cura y se vuelve blanca, la persona debe volver al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","El sacerdote los inspeccionará de nuevo, y si la herida se ha vuelto blanca, el sacerdote debe declarar a la persona limpia; entonces están limpios. ");
INSERT INTO spavbl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Cuando un forúnculo aparece en la piel de una persona y luego se cura, ");
INSERT INTO spavbl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","y en su lugar aparece una hinchazón blanca o una mancha blanca-rojiza, debe mostrarse al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","El sacerdote lo inspeccionará, y si parece ser más que algo en la superficie, y si el pelo allí se ha vuelto blanco, el sacerdote lo declarará impuro. Es una enfermedad grave de la piel que ha infectado el furúnculo. ");
INSERT INTO spavbl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Sin embargo, si cuando el sacerdote lo inspeccione, no tiene pelo blanco en él y no parece ser más que superficial, y se ha desvanecido, el sacerdote deberá poner a la persona en aislamiento durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Si entonces la mancha se ha extendido más en la piel, el sacerdote las declarará impuras; es una enfermedad. ");
INSERT INTO spavbl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pero si la mancha permanece igual y no se extiende, es sólo la cicatriz del furúnculo, y el sacerdote las declarará limpias. ");
INSERT INTO spavbl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Si alguien tiene una quemadura en la piel y donde está abierta se convierte en una mancha blanca o rojiza, ");
INSERT INTO spavbl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","el sacerdote debe revisarla. Si el vello que crecesobre la mancha se ha vuelto blanco y la mancha parece ser más profunda, es una enfermedad grave de la piel que ha infectado la quemadura, y el sacerdote que la inspeccione declarará a la persona impura. Es una enfermedad infecciosa de la piel. ");
INSERT INTO spavbl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Sin embargo, si cuando el sacerdote la inspeccione, no tiene pelo blanco en ella y no parece ser más que superficial, y se ha desvanecido, el sacerdote deberá poner a la persona en aislamiento durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Al séptimo día el sacerdote examinará a la persona de nuevo. Si entonces la mancha se ha extendido más en la piel, el sacerdote la declarará impura; es una enfermedad grave de la piel. ");
INSERT INTO spavbl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pero si la mancha permanece igual y no se ha extendido sobre la piel, sino que se ha desvanecido, es la hinchazón de la quemadura, y el sacerdote los declarará limpios porque es sólo la cicatriz de la quemadura. ");
INSERT INTO spavbl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Si alguien, hombre o mujer, tiene una llaga en la cabeza o en el mentón, ");
INSERT INTO spavbl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","el sacerdote la inspeccionará, y si parece ser más que superficial y el pelo en ella se ha vuelto pálido y fino, el sacerdote debe declararlos inmundos; es una infección que produce costras, una enfermedad grave de la cabeza o del mentón. ");
INSERT INTO spavbl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Sin embargo, si el sacerdote inspecciona la infección de la costra y no parece ser más que superficial y no tiene vello pálido, el sacerdote debe poner a la persona en aislamiento durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","El séptimo día el sacerdote inspeccionará a la persona de nuevo y si la infección de la costra no se ha extendido y no hay pelo pálido en ella, y no parece ser más que superficial, ");
INSERT INTO spavbl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","entonces la persona debe afeitarse excepto en la zona escamosa. El sacerdote debe poner a la persona en aislamiento por otros siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Al séptimo día el sacerdote inspeccionará la infección de la costra, y si no se ha extendido en la piel y no parece ser más que superficial, el sacerdote debe declarar a la persona limpia. Deben lavar su ropa y estarán limpios. ");
INSERT INTO spavbl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Sin embargo, si la infección de la costra se ha propagado en la piel después de haber sido declarada limpia, ");
INSERT INTO spavbl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","el sacerdote debe inspeccionarlos, y si la infección de la costra se ha propagado efectivamente en la piel, el sacerdote no necesita comprobar si hay pelo pálido; la persona está impura. ");
INSERT INTO spavbl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pero si el sacerdote ve que la infección de la costra no ha cambiado, y le ha crecido pelo negro, entonces se ha curado. La persona está limpia, y el sacerdote debe declararlo. ");
INSERT INTO spavbl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Si alguien, hombre o mujer, tiene manchas blancas en la piel, ");
INSERT INTO spavbl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","el sacerdote las inspeccionará, y si las manchas aparecen de un blanco apagado, es sólo un sarpullido que se ha desarrollado en la piel; la persona está limpia. ");
INSERT INTO spavbl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Si un hombre pierde el pelo y se queda calvo, sigue estando limpio. ");
INSERT INTO spavbl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Si tiene un retroceso del cabello y se queda calvo en la frente, sigue estando limpio. ");
INSERT INTO spavbl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pero si aparece una llaga rojiblanca en su cabeza o frente calva, es una enfermedad infecciosa que se está desarrollando. ");
INSERT INTO spavbl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","El sacerdote debe inspeccionarlo, y si la hinchazón de la llaga en su calva o frente se ve rojiblanca como una enfermedad de la piel, ");
INSERT INTO spavbl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","entonces tiene una enfermedad infecciosa; está sucio. El sacerdote debe declararlo impuro por la infección en su cabeza. ");
INSERT INTO spavbl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Cualquiera que tenga tales enfermedades debe usar desgarrada y dejar que su cabello permanezca despeinado. Debe cubrirse la cara y gritar: ‘¡Inmundo, inmundo!’ ");
INSERT INTO spavbl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Permanecen inmundos mientras dure la infección. Tienen que vivir solos en algún lugar fuera del campamento. ");
INSERT INTO spavbl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Las siguientes reglamentaciones se refieren a cualquier material que se vea afectado por el moho, como la ropa de lana o lino, ");
INSERT INTO spavbl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","cualquier cosa tejida o de punto hecha de lino o lana, o cualquier cosa hecha de cuero: ");
INSERT INTO spavbl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Si la mancha es verde o roja en el material, ya sea cuero, tejido o tejido de punto o algún otro artículo de cuero, entonces está infectado con moho y debe ser mostrado al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","El sacerdote debe inspeccionar el moho y poner el artículo en aislamiento durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Al séptimo día el sacerdote deberá inspeccionarlo de nuevo, y si la mancha de moho se ha extendido en el material, ya sea cuero, tejido o tejido de punto o algún otro artículo de cuero, entonces es un moho dañino; el artículo está sucio, sea cual sea el uso que se le dé. ");
INSERT INTO spavbl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","El sacerdote debe quemarlo, ya sea que el artículo afectado sea de lana, lino o cuero. Debido a que el moho es dañino, el artículo debe ser quemado. ");
INSERT INTO spavbl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Sin embargo, si cuando el sacerdote lo inspeccione de nuevo, el moho no se ha extendido, ");
INSERT INTO spavbl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","el sacerdote ordenará que el artículo afectado se lave y se ponga en aislamiento durante otros siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Una vez lavado, el sacerdote debe inspeccionarlo de nuevo, y si el objeto con el molde no ha cambiado su aspecto, está sucio. Aunque el moho no se haya extendido, debe quemar el artículo, tanto si el daño del moho está en el interior como en el exterior. ");
INSERT INTO spavbl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Si el sacerdote lo inspecciona y la mancha de moho se ha desvanecido después de lavarlo, debe cortar la parte afectada el material, ya sea cuero, tejido o tejido de punto. ");
INSERT INTO spavbl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Sin embargo, si el moho regresa, entonces se está extendiendo. En ese caso debe quemar la parte afectada. ");
INSERT INTO spavbl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Si el moho desaparece después de lavarlo, entonces hay que lavarlo de nuevo, y estará limpio. ");
INSERT INTO spavbl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Estas son las normas sobre lo que hay que hacer cuando el moho contamina la lana o el lino, ya sea tejido o tejido de punto, o cualquier artículo de cuero, para declararlo limpio o sucio”. ");
INSERT INTO spavbl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Estas son las normas relativas a los que han tenido una enfermedad de la piel cuando se declaran limpios habiendo sido llevados al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","El sacerdote debe salir del campamento e inspeccionar a la persona. Si la enfermedad de la piel se ha curado, ");
INSERT INTO spavbl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","el sacerdote hará que le traigan dos pájaros ceremoniales limpios, también algo de madera de cedro, hilo carmesí e hisopo, en nombre de la persona que se va a limpiar. ");
INSERT INTO spavbl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","“El sacerdote ordenará que se mate a uno de los pájaros sobre una vasija de arcilla llena de agua fresca. ");
INSERT INTO spavbl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Tomarás el pájaro vivo junto con la madera de cedro, el hilo carmesí y el hisopo, y los mojará en la sangre del pájaro que fue matado sobre el agua fresca. ");
INSERT INTO spavbl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Usará la sangre para rociar siete veces a la persona que está siendo limpiada de la enfermedad de la piel. Luego el sacerdote los declarará limpios y dejará que el pájaro vivo se vaya volando. ");
INSERT INTO spavbl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“El que se limpia debe lavar su ropa, afeitarse todo el pelo y lavarse con agua; entonces se limpiará ceremonialmente. Después de eso pueden entrar en el campamento, pero deben permanecer fuera de su tienda durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","El séptimo día se afeitarán todo el pelo: la cabeza, la barba, las cejas y el resto del cabello. Deben lavar su ropa y lavarse con agua, y estarán limpios. ");
INSERT INTO spavbl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“El octavo día traerán dos corderos machos y una hembra, todos de un año de edad y sin defectos; una ofrenda de grano que consiste en tres décimos de una efa de la mejor harina mezclada con aceite de oliva, y un ‘tronco’ de aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","El sacerdote que dirige la ceremonia presentará al Señor la persona a ser limpiada, junto con estas ofrendas, a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","El sacerdote tomará uno de los corderos machos y lo presentará como ofrenda por la culpa, junto con el tronco de aceite de oliva; y lo agitará ante el Señor como ofrenda mecida. ");
INSERT INTO spavbl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","“Luego degollará el cordero cerca del santuario donde se degüella la ofrenda por el pecado y el holocausto. La ofrenda por el pecado y la ofrenda por la culpa pertenecen al sacerdote; es muy sagrada. ");
INSERT INTO spavbl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","El sacerdote pondrá parte de la sangre de la ofrenda por la culpa en el lóbulo de la oreja derecha, en el pulgar derecho y en el dedo gordo del pie derecho de la persona que se está limpiando. ");
INSERT INTO spavbl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","El sacerdote echará un poco del tronco de aceite de oliva en su palma izquierda, ");
INSERT INTO spavbl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","mojará su dedo índice derecho en él, y con su dedo rociará un poco de aceite de oliva siete veces ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","El sacerdote usará entonces parte del resto del aceite de oliva que queda en su palma sobre la persona que se está limpiando, y lo pondrá sobre la sangre de la ofrenda de culpa. Esto estará en el lóbulo de su oreja derecha, en su pulgar derecho y en el dedo gordo de su pie derecho, sobre la sangre de la ofrenda de culpa. ");
INSERT INTO spavbl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Lo que quede del aceite de oliva en su palma, el sacerdote lo pondrá sobre la cabeza de la persona que se está limpiando y luego lo hará justo ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","El sacerdote sacrificará la ofrenda por el pecado para hacer a la persona correcta, de modo que ahora esté limpia de su impureza. Después de eso, el sacerdote matará el holocausto ");
INSERT INTO spavbl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","y lo ofrecerá en el altar, junto con la ofrenda de grano, para enderezarlos, y estarán limpios. ");
INSERT INTO spavbl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Pero los que son pobres y no pueden pagar estas ofrendas deben traer un cordero macho como ofrenda de culpa para ser agitado para hacerlos rectos, junto con una décima parte de la mejor harina mezclada con aceite de oliva para una ofrenda de grano, un tronco de aceite de oliva, ");
INSERT INTO spavbl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","y dos tórtolas o dos pichones de paloma, lo que puedan pagar. Una se usará como ofrenda por el pecado y la otra como holocausto. ");
INSERT INTO spavbl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Al octavo día deben llevarlos al sacerdote a la entrada del Tabernáculo de Reunión ante el Señor para que los limpie. ");
INSERT INTO spavbl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","El sacerdote tomará el cordero para la ofrenda por la culpa, junto con el tronco de aceite de oliva, y los agitará como ofrenda mecida ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Después de matar el cordero para la ofrenda por la culpa, el sacerdote tomará un poco de la sangre de la ofrenda por la culpa y la pondrá en el lóbulo de la oreja derecha del que se está limpiando, en el pulgar derecho y en el dedo gordo del pie derecho. ");
INSERT INTO spavbl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","“Entonces el sacerdote verterá un poco de aceite de oliva en su palma izquierda ");
INSERT INTO spavbl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","y con su dedo índice derecho, rociará un poco de aceite de su palma izquierda siete veces ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","El sacerdote pondrá también un poco de aceite de oliva en su palma, en el lóbulo de la oreja derecha de la persona que se está limpiando, en el pulgar derecho y en el dedo gordo del pie derecho, en los mismos lugares que la sangre de la ofrenda de culpa. ");
INSERT INTO spavbl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Lo que quede del aceite de oliva en su palma, el sacerdote lo pondrá en la cabeza de la persona que se está limpiando y luego lo pondrá delante del Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Luego deberán sacrificar una de las tórtolas o palomas jóvenes, según sus posibilidades, ");
INSERT INTO spavbl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","una como ofrenda por el pecado y la otra como holocausto, junto con la ofrenda de grano. Así es como el sacerdote hará a la persona correcta y limpia ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Estas son las normas para aquellos que tienen una enfermedad de la piel y no pueden permitirse las ofrendas habituales para hacer a la gente limpia”. ");
INSERT INTO spavbl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Entonces el Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spavbl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Cuando lleguen a Canaán, la tierra que yo les doy, si pongo un poco de moho en una casa y la contamino, ");
INSERT INTO spavbl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","el dueño de la casa debe venir y decirle al sacerdote: ‘Parece que mi casa tiene moho’. ");
INSERT INTO spavbl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","El sacerdote debe ordenar que se vacíe la casa antes de entrar a inspeccionar el moho, para que nada en la casa sea declarado impuro. Una vez hecho esto, el sacerdote debe entrar e inspeccionar la casa. ");
INSERT INTO spavbl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Examinará la casa y verá si el moho de las paredes está hecho de hendiduras verdes o rojas que van bajo la superficie, ");
INSERT INTO spavbl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","el sacerdote saldrá a la puerta y sellará la casa durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Al séptimo día el sacerdote volverá e inspeccionará la casa de nuevo. Si el moho se ha extendido en las paredes, ");
INSERT INTO spavbl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ordenará que las piedras afectadas se retiren y se eliminen en un área impura fuera de la ciudad. ");
INSERT INTO spavbl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Luego ordenará que todo el yeso del interior de la casa sea raspado y arrojado en una zona impura fuera de la ciudad. ");
INSERT INTO spavbl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Se deben usar diferentes piedras para reemplazar las que se han quitado, y se necesitará un nuevo yeso para volver a enlucir la casa. ");
INSERT INTO spavbl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Si el moho vuelve y afecta de nuevo a la casa, incluso después de haber quitado las piedras y de haber raspado y vuelto a enlucir la casa, ");
INSERT INTO spavbl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","el sacerdote debe venir a inspeccionarla. Si ve que el moho se ha extendido en la casa, es un moho dañino; la casa está sucia. ");
INSERT INTO spavbl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Debe ser demolida, y todas sus piedras, maderas y yeso deben ser tomadas y arrojadas en un área impura fuera de la ciudad. ");
INSERT INTO spavbl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Cualquiera que entre en la casa durante cualquier tiempo que esté sellada será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Quien duerma o coma en la casa debe lavar su ropa. ");
INSERT INTO spavbl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Sin embargo, si cuando el sacerdote venga a inspeccionarla y encuentra que el moho no ha reaparecido después de que la casa haya sido tapizada, declarará la casa limpia porque el moho ha desaparecido. ");
INSERT INTO spavbl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Traerá dos pájaros, madera de cedro, hilo carmesí e hisopo para limpiar la casa. ");
INSERT INTO spavbl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Matará a uno de los pájaros sobre una vasija de arcilla llena de agua fresca. ");
INSERT INTO spavbl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Sumergirá el pájaro vivo, la madera de cedro, el hilo carmesí y el hisopo en la sangre del pájaro muerto y en el agua fresca, y rociará la casa siete veces. ");
INSERT INTO spavbl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Limpiará la casa con la sangre del pájaro, el agua fresca, el pájaro vivo, la madera de cedro, el hisopo y el hilo carmesí. ");
INSERT INTO spavbl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Luego dejará que el pájaro vivo se vaya volando fuera de la ciudad. Así es como hará la casa bien, y estará limpia. ");
INSERT INTO spavbl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Estas son las regulaciones para cualquier enfermedad infecciosa de la piel, para una infección de costra, ");
INSERT INTO spavbl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","para el moho en la ropa y en una casa, ");
INSERT INTO spavbl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","así como para una hinchazón, sarpullido o mancha. ");
INSERT INTO spavbl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Se utilizan para decidir si algo está limpio o sucio. Estas son las normas relativas a las enfermedades de la piel y el moho”. ");
INSERT INTO spavbl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","El Señor dijo a Moisés y a Aarón: ");
INSERT INTO spavbl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Díganles a los israelitas: Cuando un hombre tiene una secreción de sus genitales, la secreción es impura. ");
INSERT INTO spavbl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","La impureza proviene de su flujo, ya sea que su cuerpo lo permita o lo bloquee. Lo hace impuro. ");
INSERT INTO spavbl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Cualquier cama en la que se acueste el hombre con la secreción será impura, y cualquier cosa en la que se siente será impura. ");
INSERT INTO spavbl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","El que toque su cama tiene que lavar su ropa y lavarse con agua, y será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","El que se siente sobre cualquier cosa en la que se haya sentado el hombre tiene que lavar su ropa y lavarse con agua, y será inmundo hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Cualquiera que toque el cuerpo del hombre tiene que lavar sus ropas y lavarse con agua, y serán inmundos hasta la tarde. ");
INSERT INTO spavbl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Si el hombre con la secreción escupe sobre alguien que está limpio, tiene que lavar su ropa y lavarse con agua, y será inmundo hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Todo aquello en lo que el hombre se siente cuando está montando será inmundo. ");
INSERT INTO spavbl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Todo el que toque lo que estaba debajo de él será impuro hasta la noche. Cualquiera que recoja estas cosas tiene que lavar su ropa y lavarse con agua, y serán inmundos hasta la tarde. ");
INSERT INTO spavbl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Si el hombre con la secreción toca a alguien sin lavarse las manos primero con agua, la persona que fue tocada tiene que lavar su ropa y lavarse con agua, y será impura hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Cualquier objeto de arcilla tocado por el hombre debe romperse, y cualquier objeto de madera debe lavarse con agua. ");
INSERT INTO spavbl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Una vez que la secreción se haya curado, el hombre debe asignar siete días para su proceso de limpieza, lavar sus ropas y lavarse con agua fresca, y estará limpio. ");
INSERT INTO spavbl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Al octavo día debe tomar dos tórtolas o dos pichones, presentarse ante el Señor a la entrada del Tabernáculo de Reunión y entregárselos al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","El sacerdote las sacrificará, una como ofrenda por el pecado y la otra como holocausto. Así es como el sacerdote pondrá al hombre delante del Señor por su descarga. ");
INSERT INTO spavbl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Cuando un hombre tiene una descarga de semen, debe lavar todo su cuerpo con agua, y será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Cualquier ropa o cuero sobre el que caiga la secreción de semen debe ser lavada con agua, y permanecerá impura hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Si un hombre se acuesta con una mujer y hay una liberación de semen, ambos deben lavarse con agua, y permanecerán inmundos hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Cuando una mujer tenga una secreción de sangre en su cuerpo, será impura por su período durante siete días, y cualquiera que la toque será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Todo aquello sobre lo que se acueste o se siente durante su período será impuro, ");
INSERT INTO spavbl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","y todo aquel que toque su cama deberá lavar su ropa y lavarse con agua, y será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Cualquiera que toque lo que estaba sentado tiene que lavar su ropa y lavarse con agua, y será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ya sea que se trate de una cama o de algo en lo que estaba sentada, cualquiera que lo toque será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Si un hombre duerme con ella y le toca la sangre de su período, será impuro durante siete días, y cualquier cama en la que se acueste será impura. ");
INSERT INTO spavbl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Cuando una mujer tenga secreción de sangre durante varios días, siendo que no es el momento de su período, o si continúa después de su período, será impura durante todo el tiempo que esté sangrando, y no sólo durante los días de su período. ");
INSERT INTO spavbl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Cualquier cama en la que se acueste o cualquier cosa en la que se siente mientras tenga la secreción será impura, al igual que su cama durante su período. ");
INSERT INTO spavbl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Quien los toque tiene que lavar su ropa y lavarse con agua, y serán inmundos hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Una vez que el flujo de la mujer se haya curado, deberá destinar siete días para su limpieza, lavar su ropa y lavarse con agua fresca, y estará limpia. ");
INSERT INTO spavbl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Al octavo día debe tomar dos tórtolas o dos pichones, presentarse ante el Señor a la entrada del Tabernáculo de Reunión y entregarlos al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","El sacerdote las sacrificará, una como ofrenda por el pecado y la otra como holocausto. Así es como el sacerdote la pondrá delante del Señor por su descarga. ");
INSERT INTO spavbl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Así es como debes evitar que los israelitas se vuelvan ceremonialmente inmundos, para que no mueran al hacer que mi Tabernáculo se vuelva impuro, el lugar donde vivo con ellos. ");
INSERT INTO spavbl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“Estas son las normas para el hombre que tiene una secreción, el hombre que tiene una secreción de semen que lo hace inmundo, ");
INSERT INTO spavbl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","la mujer durante su período, cualquier hombre o mujer que tiene una secreción, y el hombre que se acuesta con una mujer inmunda”. ");
INSERT INTO spavbl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","El Señor habló a Moisés después de la muerte de dos de los hijos de Aarón cuando fueron a la presencia del Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","El Señor le dijo a Moisés: “Adviértele a tu hermano Aarón que no venga al Lugar Santísimo en cualquier momento que lo desee, de lo contrario morirá. Porque ahí es donde aparezco en la nube sobre la cubierta de expiación del Arca, detrás del velo. ");
INSERT INTO spavbl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Estas son las instrucciones para que Aarón entre en el santuario. Debe venir con un toro joven para una ofrenda por el pecado y con un carnero para una ofrenda quemada. ");
INSERT INTO spavbl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Debe llevar la túnica de lino sagrada, con ropa interior de lino. Tiene que atar una faja de lino a su alrededor y ponerse el turbante de lino. Estas son ropas sagradas. Debe lavarse con agua antes de ponérsela. ");
INSERT INTO spavbl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Del pueblo de Israel debe traer dos machos cabríos para la ofrenda por el pecado, y un carnero para el holocausto. ");
INSERT INTO spavbl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aarón presentará el toro como su propia ofrenda por el pecado para hacerse a sí mismo y a su familia. ");
INSERT INTO spavbl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Luego traerá los dos machos cabríos y los presentará ante el Señor a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aarón echará suertes para elegir entre los cabritos, uno para el Señor y otro para el chivo expiatorio. ");
INSERT INTO spavbl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Presentará el macho cabrío elegido por sorteo para el Señor y lo sacrificará como ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","El macho cabrío elegido por sorteo como chivo expiatorio será presentado vivo ante el Señor para arreglar las cosas enviándolo al desierto como chivo expiatorio. ");
INSERT INTO spavbl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aarón debe presentar el toro para su ofrenda por el pecado para hacer las cosas bien para él y su casa matando el toro como su propia ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Luego llenará un quemador de incienso con carbones encendidos del altar que está ante el Señor, y con sus manos llenas de incienso de olor dulce finamente molido, los llevará detrás del velo. ");
INSERT INTO spavbl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Pondrá el incienso en presencia del Señor, sobre las brasas, y el humo del incienso cubrirá la tapa de la expiación sobre el Testimonio, para que no muera. ");
INSERT INTO spavbl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Tomará un poco de sangre del toro y con su dedo la rociará en el lado este de la tapa de expiación. También rociará un poco con su dedo siete veces delante de la tapa de la expiación. ");
INSERT INTO spavbl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Entonces Aarón sacrificará el macho cabrío para la ofrenda por el pecado del pueblo y traerá su sangre detrás del velo, y con su sangre deberá hacer lo mismo que hizo con la sangre del toro: La rociará contra el propiciatorio y delante de él. ");
INSERT INTO spavbl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Así es como corregirá el Lugar Santísimo y lo purificará de la inmundicia de los israelitas, de sus actos de rebelión y de todos sus pecados. Hará lo mismo con el Tabernáculo de Reunión que está en medio de su campamento, rodeado de sus vidas inmundas. ");
INSERT INTO spavbl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Nadie puede estar en el Tabernáculo de Reunión desde que Aarón entra para purificar el Lugar Santísimo hasta que sale, después de haber arreglado las cosas para él, su casa y todos los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Entonces irá al altar que está delante del Señor y lo purificará. Tomará la sangre del toro y del macho cabrío y la pondrá en todos los cuernos del altar. ");
INSERT INTO spavbl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Rociará con su dedo siete veces la sangre para dedicarla y purificarla de la inmundicia de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Una vez que Aarón haya terminado de purificar el Lugar Santísimo, el Tabernáculo de Reunión y el altar, presentará el macho cabrío vivo. ");
INSERT INTO spavbl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Luego pondrá ambas manos sobre la cabeza del macho cabrío vivo y confesará sobre él todas las faltas de los israelitas, todos sus actos de rebelión y todos sus pecados. Los pondrá sobre la cabeza del macho cabrío y lo enviará al desierto, llevado allí por un hombre elegido para hacerlo. ");
INSERT INTO spavbl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","El macho cabrío tomará sobre sí mismo todos sus pecados y se irá a un lugar lejano, y el hombre lo enviará al desierto. ");
INSERT INTO spavbl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Aarón volverá al Tabernáculo de Reunión, se quitará las ropas de lino que se puso antes de entrar en el Lugar Santísimo, y las dejará allí. ");
INSERT INTO spavbl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Se lavará con agua en el santuario y se pondrá su propia ropa. Luego saldrá a sacrificar su holocausto y el holocausto del pueblo que le da la razón a él y al pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","También debe quemar la grasa de la ofrenda por el pecado en el altar. ");
INSERT INTO spavbl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“El hombre que fue y envió al chivo expiatorio debe lavar sus ropas y lavarse con agua; entonces podrá volver al campamento. ");
INSERT INTO spavbl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“Los restos del toro usado para la ofrenda por el pecado y la cabra para la ofrenda por el pecado, cuya sangre fue traída al Lugar Santísimo para purificarla, deben ser llevados fuera del campamento. Su piel, carne y desechos deben ser quemados. ");
INSERT INTO spavbl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","La persona que los queme debe lavar sus ropas y lavarse con agua; luego puede volver al campamento. ");
INSERT INTO spavbl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Este reglamento se aplica a todos los tiempos. El décimo día del séptimo mes es un día de ayuno para ustedes. No debes hacer ningún trabajo. Esto se aplica a todos los nacidos en el país y también a cualquier extranjero que viva entre ustedes, ");
INSERT INTO spavbl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","porque en este día se hará el proceso de corregiros, para haceros limpios de todos sus pecados, limpios ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Es un sábado de los sábados, un día de descanso y de ayuno. Esta regulación se aplica para todo el tiempo. ");
INSERT INTO spavbl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","El sacerdote que es ungido y dedicado a suceder a su padre como sumo sacerdote llevará a cabo la ceremonia de hacer las cosas bien, y se pondrá las ropas de lino sagrado. ");
INSERT INTO spavbl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Llevará a cabo la purificación del Lugar Santísimo, el Tabernáculo de Reunión y el altar, corrigiendo también a los sacerdotes y a todo el pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Esta regla se aplica a ustedes para siempre: una vez al año los israelitas harán expiación por todos sus pecados”. Moisés hizo todo lo que el Señor le ordenó. ");
INSERT INTO spavbl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Dile a Aarón, a sus hijos y a todos los israelitas que esto es lo que el Señor ordena: ");
INSERT INTO spavbl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Cualquier israelita que mate un toro, un cordero o una cabra, ya sea dentro o fuera del campamento, ");
INSERT INTO spavbl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","en lugar de llevarlo a la entrada del Tabernáculo de Reunión para presentarlo como ofrenda al Señor allí, esa persona será considerada culpable de asesinato ilegal. Han derramado sangre y deben ser expulsados de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","“Por eso los israelitas tienen que llevar al Señor los sacrificios que actualmente ofrecen en los campos. Deben llevarlos al sacerdote a la entrada del Tabernáculo de Reunión y ofrecerlos como ofrendas de paz al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","El sacerdote rociará la sangre sobre el altar del Señor a la entrada del Tabernáculo de Reunión, y quemará la grasa, agradable al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","“No deben seguir ofreciendo sus sacrificios al diablo de las cabras con el que han actuado como prostitutas. Esta es una regulación para todos los tiempos y para todas las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Adviértanles que cualquier israelita o extranjero que viva entre ellos que ofrezca un holocausto o un sacrificio ");
INSERT INTO spavbl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","sin llevarlo a la entrada del Tabernáculo de Reunión para sacrificarlo al Señor debe ser expulsado de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Desconoceré a cualquier israelita o extranjero que viva entre ellos y coma sangre y los expulsaré de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","La vida está en la sangre del cuerpo. Os la he dado para que, poniéndola en el altar, sus vidas puedan ser rectificadas, porque es la sangre que rectifica la vida de la gente. ");
INSERT INTO spavbl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Por eso les advierto a los israelitas: Ninguno de ustedes puede comer sangre, y ningún extranjero que viva entre ustedes puede comer sangre. ");
INSERT INTO spavbl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Cualquier israelita o extranjero que viva entre ellos y que cace y mate un animal salvaje o un pájaro que esté permitido comer, debe drenar la sangre de su cuerpo y cubrirlo con tierra, ");
INSERT INTO spavbl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","porque la vida está en la sangre del cuerpo. Por eso he advertido a los israelitas: No se permite comer la sangre de nada viviente, porque la vida está en la sangre del cuerpo. Cualquiera que la coma debe ser expulsado. ");
INSERT INTO spavbl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Todo israelita o extranjero que coma algo que haya sido encontrado muerto o matado por animales salvajes debe lavar sus ropas y lavarlas con agua, y estarán inmundos hasta la noche. Entonces estarán limpios. ");
INSERT INTO spavbl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Pero si no lavan sus ropas y se lavan con agua, entonces son responsables de su culpa”. ");
INSERT INTO spavbl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Dile a los israelitas: Yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","No sigas los caminos de Egipto, donde vivías, y no sigas los caminos de Canaán, donde te llevaré. No adoptes sus prácticas. ");
INSERT INTO spavbl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Haz lo que te digo y guarda mis reglas. Yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Si guardas mis reglas y haces lo que te digo, vivirás. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“No tengas relaciones sexuales con un pariente cercano. ");
INSERT INTO spavbl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","No avergüences a tu padre teniendo sexo con tu madre. Ella es tu madre; no tengas sexo con ella. ");
INSERT INTO spavbl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","No tengas sexo con ninguna de las esposas de tu padre y avergüenza a tu padre. ");
INSERT INTO spavbl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","No tengas sexo con tu hermana, si es hija de tu padre o de tu madre, o si nació en la misma casa que tú o en otro lugar. ");
INSERT INTO spavbl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","No tengas sexo con tu nieta, la hija de tu hijo o la hija de tu hija, porque eso sería algo vergonzoso para ti. ");
INSERT INTO spavbl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","No tengas sexo con la hija de ninguna de las esposas de tu padre y tu padre, ella es tu hermana. ");
INSERT INTO spavbl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","No tengas sexo con la hermana de tu padre. Ella es un pariente cercano de tu padre. ");
INSERT INTO spavbl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","No tengas relaciones sexuales con la hermana de tu madre. Ella es un pariente cercano de tu madre. ");
INSERT INTO spavbl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","No avergüences a tu tío teniendo sexo con su esposa. Ella es tu tía. ");
INSERT INTO spavbl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","No tengas sexo con tu nuera. Ella es la esposa de tu hijo. No tengas sexo con ella. ");
INSERT INTO spavbl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","No te acuestes con la esposa de tu hermano y avergüénzate de él. ");
INSERT INTO spavbl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","No tengas sexo con una mujer y su hija. No tengas sexo con la hija de su hijo o la hija de su hija. Son sus parientes cercanos. Eso es algo que detesto. ");
INSERT INTO spavbl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","No te cases con la hermana de tu esposa y tengas sexo con ella mientras tu esposa esté viva. Serán esposas hostiles entre sí. ");
INSERT INTO spavbl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","No tengas sexo con una mujer durante el tiempo que esté sucia debido a su período. ");
INSERT INTO spavbl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","No cometas ningún acto sexual con la esposa de otro hombre. Esto te contaminaría y te haría sucio. ");
INSERT INTO spavbl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“No le des ninguno de tus hijos como sacrificio humano a Moloc, porque no debes deshonrar el carácter de tu Dios. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“No tengas sexo con un hombre como con una mujer. Eso es algo asqueroso. ");
INSERT INTO spavbl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","No tengas sexo con ningún animal. Esto te contaminaría y te ensuciaría. ");
INSERT INTO spavbl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Una mujer no debe entregarse a un animal para tener sexo con él. Eso es algo asqueroso. No se contaminen y se ensucien haciendo algo así. Esa es la razón por la que estoy expulsando a estas naciones de la tierra, se han contaminado a sí mismos por todas estas prácticas. ");
INSERT INTO spavbl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Incluso la tierra se ha contaminado, así que la estoy castigando por los pecados cometidos por la gente que vive allí, y la tierra los vomitará. ");
INSERT INTO spavbl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“Peroustedes deben hacer lo que yo os diga y guardar mis reglas. No deben hacer ninguno de estos actos repugnantes, ya sea un israelita o un extranjero que viva entre ustedes. ");
INSERT INTO spavbl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Las personas que vivían en la tierra antes de ti practicaban todas estas cosas repugnantes, y la tierra se contaminó. ");
INSERT INTO spavbl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Si contaminas la tierra, te vomitará como lo hizo con las naciones anteriores a ti. ");
INSERT INTO spavbl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“Por consiguiente, cualquiera que haga cualquiera de estas cosas repugnantes debe ser expulsado de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Debes aceptar mi demanda de que no sigas ninguna de estas prácticas repugnantes hechas antes de tu llegada. No se contaminen ni se hagan impuros. Yo soy el Señor su Dios”. ");
INSERT INTO spavbl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Dile a todos los israelitas: Sean santos porque yo soy santo; yo soy el Señor su Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Muestra respeto por tu madre y tu padre y guarda mis sábados. Yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“No acudas a los ídolos en busca de ayuda ni hagas imágenes metálicas de dioses. Yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Cuando sacrifiques una ofrenda de paz al Señor, asegúrate de hacerlo correctamente para que Dios te acepte. ");
INSERT INTO spavbl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Debe ser comida el día que la sacrificas, o al día siguiente. Lo que quede al tercer día debe ser quemado. ");
INSERT INTO spavbl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Si comes algo de ello al tercer día, el sacrificio se vuelve repulsivo y no será aceptado. ");
INSERT INTO spavbl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","El que lo coma se hará responsable de su culpa, porque ha ensuciado lo que es santo para el Señor. Deben ser expulsados de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Cuando cosechen los cultivos de su tierra, no lo hagan hasta los límites del campo, ni recojan lo que se ha perdido. ");
INSERT INTO spavbl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","No recojas hasta la última uva de tu viñedo ni recojas las que han caído. Déjalas para los pobres y los extranjeros. Yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“No robes. No mientas. No engañes. ");
INSERT INTO spavbl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“No hagas juramentos en mi nombre que no sean verdaderos, de lo contrario difamarás el carácter de tu Dios. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“No engañes a los demás ni les robes. No te niegues a pagar los salarios que se deben a los trabajadores hasta la mañana. ");
INSERT INTO spavbl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“No hables mal de los sordos. No pongas objetos en el camino de los ciegos para hacerlos tropezar. En vez de eso, muestra respeto a tu Dios. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“No seas un juez corrupto. No muestres favoritismo a los pobres o a los ricos. Juzga a los demás con justicia. ");
INSERT INTO spavbl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“No vayas por ahí difundiendo falsos rumores sobre la gente. No te quedes callado cuando las vidas de otros están en peligro. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“No te aferres a sentimientos de odio hacia los demás. Habla honestamente con tus vecinos, para no pecar por ellos. ");
INSERT INTO spavbl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","No busques venganza ni guardes rencor a nadie, sino ama a tu prójimo como a ti mismo. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“¡Haz lo que te digo! No hagas que diferentes tipos de ganado se reproduzcan juntos. No siembren sus campos con dos tipos diferentes de semillas. No uses ropa confeccionada con dos materiales distintos. ");
INSERT INTO spavbl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Si un hombre tiene relaciones sexuales con una sirvienta a la que se le ha prometido ser la esposa de otro hombre, pero que aún no ha sido comprada o liberada, entonces se debe pagar una compensación. Sin embargo, no deben ser asesinados, porque ella no ha sido liberada. ");
INSERT INTO spavbl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Pero el hombre debe llevar un carnero como ofrenda de culpa al Señor a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","El sacerdote arreglará las cosas para él ante el Señor usando el carnero de la ofrenda por el pecado que ha cometido, y su pecado será perdonado. ");
INSERT INTO spavbl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Cuando entres en la tierra y plantes cualquier tipo de árbol frutal, trata la fruta al principio como impura. Durante tres años tienes prohibido comerlo. ");
INSERT INTO spavbl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","El cuarto año todo el fruto debe ser dedicado al Señor como ofrenda de alabanza. ");
INSERT INTO spavbl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Sin embargo, el quinto año podrán comer el fruto y así tendrán una cosecha aún mayor. Yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“No comas carne con sangre. No uses la adivinación o la brujería. ");
INSERT INTO spavbl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“No se corten el cabello a los lados de la cabeza ni se corten la barba, ");
INSERT INTO spavbl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","no se corten el cuerpo en algún ritual pagano para los muertos y se hagan tatuajes. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“No causen vergüenza a su hija convirtiéndola en una prostituta, de lo contrario la tierra se volverá moral y espiritualmente depravada. ");
INSERT INTO spavbl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Guarden mis sábados y mostrad respeto por mi santuario. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“No intentes encontrar ayuda de médiums o espiritistas, ni siquiera vayas a buscarlos, de lo contrario te corromperán. Yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Levántate y respeta a los ancianos. Muestra reverencia por tu Dios. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“No maltrates a los extranjeros que viven en tu país. ");
INSERT INTO spavbl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Trátalos como a un conciudadano, y ámalos como a ti mismo, porque una vez fuisteis extranjeros viviendo en Egipto. Yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“No uses pesos y medidas deshonestas. ");
INSERT INTO spavbl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Asegúrate de que tus balanzas y pesos sean exactos, que tus medidas de efa y hin sean correctas. Yo soy el Señor tu Dios que te sacó de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Guarda todas mis reglas y regulaciones, y asegúrate de que las sigues. Yo soy el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Diles a los israelitas: estas normas son para los israelitas y los extranjeros que viven entre ellos. Cualquiera que sacrifique sus hijos a Moloc debe ser ejecutado. La comunidad debe apedrearlos hasta la muerte. ");
INSERT INTO spavbl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Los repudiaré y los expulsaré de su pueblo, porque al sacrificar sus hijos a Moloc, han contaminado mi santuario y deshonrado mi reputación. ");
INSERT INTO spavbl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Si la comunidad decide mirar hacia otro lado y no ejecutar a aquellos que sacrifican sus hijos a Moloch, entonces yo mismo tomaré medidas contra ellos. ");
INSERT INTO spavbl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Los repudiaré a ellos y a su familia, y los expulsaré de su pueblo, y no sólo a ellos, sino a todos los que los sigan en la prostitución espiritual con Moloc. ");
INSERT INTO spavbl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“También repudiaré y expulsaré de su gente a cualquiera que vaya a médiums o espiritistas y de esta manera cometa prostitución espiritual con ellos. ");
INSERT INTO spavbl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Así que dedíquense y sean santos, porque yo soy el Señor su Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Guarden mis reglas y pónganlas en práctica. Yo soy el Señor que los santifica. ");
INSERT INTO spavbl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Cualquiera que maldiga a su padre o madre debe ser ejecutado. Han maldecido a su padre o madre; ellos son los responsables de su castigo. ");
INSERT INTO spavbl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Cualquier hombre que cometa adulterio con la esposa de otro debe ser ejecutado, así como la mujer. ");
INSERT INTO spavbl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“Un hombre que tiene sexo con la esposa de su padre ha traído la vergüenza a su padre. Tanto el hombre como la mujer deben ser ejecutados. Ambos deben ser ejecutados; ellos son responsables de su castigo. ");
INSERT INTO spavbl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Un hombre que tiene relaciones sexuales con su nuera debe ser ejecutado, así como ella. Han hecho algo perverso; ellos son los responsables de su castigo. ");
INSERT INTO spavbl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Los hombres que tienen relaciones sexuales con otros hombres como con una mujer habrán hecho algo repugnante. Deben ser ejecutados; ellos son culpables de su castigo. ");
INSERT INTO spavbl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Un hombre que se casa con una mujer y con su madre ha actuado de manera perversa. Deben ser quemados hasta la muerte para que no haya tal maldad entre ustedes. ");
INSERT INTO spavbl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“El hombre que tenga relaciones sexuales con un animal debe ser ejecutado, y el animal debe ser matado también. ");
INSERT INTO spavbl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Una mujer que se entrega a un animal para tener sexo con él debe ser ejecutada, junto con el animal. Ambos deben ser asesinados; ellos son responsables de su castigo. ");
INSERT INTO spavbl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Un hombre que se casa con su hermana, ya sea hija de su padre o de su madre, y tienen relaciones sexuales, ha hecho algo vergonzoso. Deben ser expulsados de su pueblo delante de todos. Ha avergonzado a su hermana; él tiene la responsabilidad de su castigo. ");
INSERT INTO spavbl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Un hombre que tiene relaciones sexuales con una mujer que está teniendo su período ha expuesto de dónde proviene el flujo de sangre de ella, y ella también lo ha hecho. Ambos deben ser expulsados de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“No tengas relaciones sexuales con tu tía, ya sea por parte de tu padre o de tu madre, porque eso avergüenza a tu propia familia. Ambos serán responsables de su pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Un hombre que tiene sexo con la esposa de su tío trae vergüenza a su tío. Ellos serán responsables de su pecado; morirán sin tener hijos. ");
INSERT INTO spavbl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“Un hombre que se casa con la mujer de su hermano hace algo que es impuro. Ha avergonzado a su hermano; la pareja no tendrá hijos. ");
INSERT INTO spavbl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Así que guarda todas mis reglas y regulaciones, para que la tierra donde te llevo a vivir no te vomite. ");
INSERT INTO spavbl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","No sigas las prácticas de las naciones que estoy expulsando por ti. Las detesté porque hicieron todas estas cosas malvadas. ");
INSERT INTO spavbl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Pero te he prometido que te harás cargo de su tierra. Te la voy a dar en propiedad, una tierra que fluye con leche y miel. Yo soy el Señor tu Dios, que te ha hecho un pueblo distinto de todos los demás. ");
INSERT INTO spavbl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Así que asegúrate de observar la diferencia entre las aves y animales limpios e inmundos. No se vuelvan inmundos por causa de ningún animal o ave, ni por nada que corra por la tierra. He dejado clara la diferencia: son inmundos para ustedes. ");
INSERT INTO spavbl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ustedes serán santos para mí porque yo soy santo. Yo soy el Señor, y los he hecho un pueblo distinto de todas las demás naciones. Ustedes me pertenecen. ");
INSERT INTO spavbl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Todo hombre o mujer que sea médium o espiritista debe ser ejecutado. Deben ser apedreados hasta la muerte; ellos son responsables de su castigo”. ");
INSERT INTO spavbl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","El Señor le dijo a Moisés: “Dile a los hijos de Aarón, los sacerdotes: Un sacerdote no debe ensuciarse tocando el cadáver de ninguno de sus parientes. ");
INSERT INTO spavbl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Las únicas excepciones son para su familia inmediata. Esto incluye a su madre, padre, hijo, hija o hermano, ");
INSERT INTO spavbl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o a su hermana soltera ya que es un pariente cercano porque no tiene marido. ");
INSERT INTO spavbl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","No debe hacerse impuro por aquellos que sólo están relacionados con él por matrimonio; no debe hacerse ceremonialmente impuro. ");
INSERT INTO spavbl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Los sacerdotes no deben afeitarse las zonas calvas de la cabeza, ni recortar los lados de la barba, ni cortar el cuerpo. ");
INSERT INTO spavbl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Deben ser santos para su Dios y no deshonrar la reputación de su Dios. Ellos son los que presentan las ofrendas de comida al Señor, la comida de su Dios. Por consiguiente, deben ser santos. ");
INSERT INTO spavbl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“El sacerdote no debe casarse con una mujer que se ha vuelto impura por la prostitución o que se ha divorciado de su marido, porque el sacerdote debe ser santo para su Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Lo considerarán santo porque presenta las ofrendas de comida a su Dios. Él será santo para ti, porque yo soy santo. Yo soy el Señor, y te elegícomomi pueblo especial. ");
INSERT INTO spavbl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","La hija de un sacerdote que se hace impura por la prostitución hace impura a su padre. Ella debe ser ejecutada por medio del holocausto. ");
INSERT INTO spavbl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“El sumo sacerdote tiene el lugar más alto entre los otros sacerdotes. Ha sido ungido con aceite de oliva vertido en su cabeza y ha sido ordenado para llevar la ropa sacerdotal. No debe dejar su pelo despeinado ni rasgar su ropa. ");
INSERT INTO spavbl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","No debe acercarse a ningún cadáver. No debe hacerse impuro, aunque sea por su propio padre o madre. ");
INSERT INTO spavbl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","No debe salir para tratar asuntos de un difunto o hacer que el santuario de su Dios sea impuro porque ha sido dedicado por el aceite de la unción de su Dios. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Sólo puede casarse con una virgen. ");
INSERT INTO spavbl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","No debe casarse con una viuda, una mujer divorciada, o con una que se haya vuelto impura a través de la prostitución. Tiene que casarse con una virgen de su propio pueblo, ");
INSERT INTO spavbl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","para que no haga inmundos a sus hijos entre su pueblo, porque yo soy el Señor que lo hace santo”. ");
INSERT INTO spavbl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Dile a Aarón: Estas reglas se aplican a todas las generaciones futuras. Si alguno de sus descendientes tiene un defecto físico, no se le permite venir a presentar las ofrendas de su Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","No se permite a ningún hombre hacer esto si tiene algún defecto, incluyendo a cualquier persona ciega, lisiada, desfigurada en la cara o con deformidades, ");
INSERT INTO spavbl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","cualquier persona que tenga un pie o brazo roto, ");
INSERT INTO spavbl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","cualquier persona que sea jorobada o enana, o que tenga cataratas, llagas en la piel o costras, o un testículo dañado. ");
INSERT INTO spavbl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“A ningún descendiente del sacerdote Aarón que tenga un defecto se le permite venir y presentar las ofrendas de comida al Señor. Debido a que tiene un defecto, no debe venir y ofrecer la comida de su Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Se le permite comer la comida del Lugar Santísimo de su Dios y también del santuario, ");
INSERT INTO spavbl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","pero como tiene un defecto, no se le permite acercarse a la cortina o al altar, para que mi santuario y todo lo que hay en él no se vuelva impuro, porque yo soy el Señor que los hago santos”. ");
INSERT INTO spavbl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moisés repitió esto a Aarón y a sus hijos, y a todos los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Dile a Aarón y a sus hijos que trabajen con dedicación al tratar con las ofrendas sagradas que los israelitas me han ofrecido, para que no deshonren mi santo nombre. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Diles: Estas reglas se aplican a todas las generaciones futuras. Si alguno de sus descendientes en estado inmundo se acerca a las ofrendas sagradas que los israelitas dedican a honrar al Señor, esa persona debe ser expulsada de mi presencia. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Si uno de los descendientes de Aarón tiene una enfermedad de la piel o una secreción, no se le permite comer las ofrendas sagradas hasta que esté limpio. Cualquiera que toque algo que se haya vuelto impuro por un cadáver o por un hombre que haya tenido una liberación de semen, ");
INSERT INTO spavbl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o cualquiera que toque un animal o una persona impura, (cualquiera que sea la impureza), ");
INSERT INTO spavbl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","cualquiera que toque algo así permanecerá impuro hasta la noche. No se le permite comer de las ofrendas sagradas a menos que se haya lavado con agua. ");
INSERT INTO spavbl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Al atardecer se limpiará, y entonces se le permitirá comer de las ofrendas sagradas porque le proporcionan su comida. ");
INSERT INTO spavbl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","No debe comer nada que haya muerto o haya sido matado por animales salvajes, porque eso lo haría impuro. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Los sacerdotes deben hacer lo que yo les exija, para que no se hagan culpables y mueran por no haberlo hecho, tratando mis exigencias con desprecio. Yo soy el Señor que los hace santos. ");
INSERT INTO spavbl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Cualquiera que no sea parte de la familia de un sacerdote no puede comer las sagradas ofrendas. Esto también se aplica al huésped de un sacerdote o a su trabajador asalariado. ");
INSERT INTO spavbl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Sin embargo, si un sacerdote usa su propio dinero para comprar un esclavo, o si un esclavo nace en la casa del sacerdote, entonces a ese esclavo se le permite comer su comida. ");
INSERT INTO spavbl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si la hija del sacerdote se casa con un hombre que no es sacerdote, no se le permite comer las ofrendas sagradas. ");
INSERT INTO spavbl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pero si la hija de un sacerdote sin hijos es viuda o divorciada y regresa a la casa de su padre, se le permite comer la comida de su padre como lo hacía cuando era niña. Pero nadie fuera de la familia del sacerdote puede comerla. ");
INSERT INTO spavbl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Cualquiera que coma una ofrenda sagrada por error debe pagar una compensación añadiendo un quinto a su valor, y dárselo todo al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Los sacerdotes no deben hacer inmundas las ofrendas sagradas que los israelitas presentan al Señor ");
INSERT INTO spavbl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","permitiendo que el pueblo las coma y al hacerlo asuman el castigo por la culpa. Porque yo soy el Señor que las hace santas”. ");
INSERT INTO spavbl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Dile a Aarón, a sus hijos y a todos los israelitas: Si tú o un extranjero que vive contigo quiere hacer un regalo como holocausto al Señor, ya sea para cumplir una promesa o como una ofrenda voluntaria, esto es lo que debes hacer. ");
INSERT INTO spavbl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Si va a ser aceptado en tu nombre debes ofrecer un macho sin defectos de los rebaños de vacas, ovejas o cabras. ");
INSERT INTO spavbl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","No presente nada que tenga un defecto porque no será aceptado en su nombre. ");
INSERT INTO spavbl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Si quieres presentar una ofrenda de paz al Señor de la manada o rebaño para cumplir una promesa o como una ofrenda de libre albedrío, para ser aceptable el animal debe ser perfecto, completamente sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","No presente al Señor un animal que esté ciego, herido o dañado de alguna manera, o que tenga verrugas, llagas en la piel o costras. No coloques ningún animal que tenga esto en el altar como ofrenda de comida al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“Sin embargo, puedes presentar una ofrenda voluntaria de un toro o una oveja que tenga una pata demasiado larga o demasiado corta, pero no si se trata de un sacrificio para cumplir una promesa. ");
INSERT INTO spavbl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","No presente al Señor un animal con los testículos dañados accidental o deliberadamente. No se le permite sacrificar ninguno de estos animales dañados en su tierra. ");
INSERT INTO spavbl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Tampoco se le permite aceptar tales animales de un extranjero para ser dañados y defectuosos”. ");
INSERT INTO spavbl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Cuando nace un toro, una oveja o una cabra, debe permanecer con su madre durante siete días. Después de ocho días puede ser aceptado como una ofrenda de comida al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Sin embargo, no se debe matar un toro o una oveja y sus crías en el mismo día. ");
INSERT INTO spavbl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Cuando presente una ofrenda de agradecimiento al Señor, asegúrese de hacerlo de manera que sea aceptada en su nombre. ");
INSERT INTO spavbl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Debe ser comida el mismo día. No dejes nada de eso hasta la mañana. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Guarda mis reglas y ponlas en práctica. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","No deshonres mi santo nombre. Seré santo ante tus ojos. Yo soy el Señor que tesantifica. ");
INSERT INTO spavbl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Soy el que te sacó de Egipto para ser tu Dios. Yo soy el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Diles a los israelitas que estas son mis fiestas religiosas, las fiestas del Señor que debes llamar como tiempos sagrados en los que nos reuniremos. ");
INSERT INTO spavbl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Tienen seis días para trabajar, pero el séptimo día es un sábado de completo descanso, un día sagrado de reunión. No trabajarán. Es el Sábado del Señor en todos los lugares donde vivas. ");
INSERT INTO spavbl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Estas son las fiestas religiosas del Señor, las reuniones sagradas en las que comieron para anunciar, en su fecha señalada: ");
INSERT INTO spavbl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","La Pascua del Señor comienza en la tarde del día catorce del primer mes. ");
INSERT INTO spavbl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","La fiesta del Señor de los panes sin levadura comienza el día quince del primer mes. Durante siete días el pan que coman debe ser hecho sin levadura. ");
INSERT INTO spavbl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","El primer día se celebra una reunión sagrada. No debes hacer ninguno de sus trabajos habituales. ");
INSERT INTO spavbl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Durante siete días presentarás ofrendas de comida al Señor. Habrá una reunión sagrada el séptimo día. No debes hacer nada de tu trabajo habitual”. ");
INSERT INTO spavbl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Diles a los israelitas que cuando entren en la tierra que yo les doy y recojansus cosechas, deben llevarle al sacerdote gran parte del grano de las primicias de su cosecha. ");
INSERT INTO spavbl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Él agitará la pila de grano ante el Señor para que sea aceptada en su nombre. El sacerdote hará esto el día siguiente al sábado. ");
INSERT INTO spavbl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Cuando agites la pila de grano, presentarás al Señor un cordero de un año sin defectos como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","junto con su ofrenda de grano de dos décimas de efa de la mejor harina mezclada con aceite de oliva (una ofrenda de comida al Señor para ser aceptada por él) y su ofrenda de bebida de un cuarto de hin de vino. ");
INSERT INTO spavbl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","No comas pan, grano tostado o grano nuevo hasta el momento en que lleves esta ofrenda a tu Dios. Esta norma es para siempre y para las futuras generaciones en todos los lugares donde vivas. ");
INSERT INTO spavbl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Cuenta siete semanas completas desde el día después del sábado, el día que trajiste la pila de grano como ofrenda ondulada. ");
INSERT INTO spavbl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Cuenta cincuenta días hasta el día después del séptimo sábado, y en ese día presenta una ofrenda de grano nuevo al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Traigan dos panes de sus casas como ofrenda mecida. Hacedlos de dos décimas de efa de la mejor harina, cocidos con levadura, como primicias para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Además del pan, presenten siete corderos machos de un año sin defectos, un novillo y dos carneros. Serán un holocausto para el Señor, así como sus ofrendas de grano y sus ofrendas de bebida, una ofrenda de comida para el Señor para ser aceptada por él. ");
INSERT INTO spavbl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Presenten una cabra macho como ofrenda por el pecado y dos corderos macho de un año como ofrenda de paz. ");
INSERT INTO spavbl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","El sacerdote agitará los corderos como ofrenda mecida ante el Señor, junto con el pan de las primicias. El pan y los dos corderos son sagrados para el Señor y pertenecen al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ese mismo día anunciará una reunión santa, y no deberá hacer ningún trabajo habitual. Este reglamento es para todos los tiempos y para las generaciones futuras, dondequiera que vivan. ");
INSERT INTO spavbl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Cuando coseches los cultivos de tu tierra, no lo hagas hasta los bordes del campo, o recoge lo que se ha perdido. Déjalos para los pobres y los extranjeros. Yo soy el Señor tu Dios”. ");
INSERT INTO spavbl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Diles a los israelitas que el primer día del séptimo mes deben tener un sábado especial de completo descanso, una reunión santa que se anuncia con el sonido de las trompetas. ");
INSERT INTO spavbl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","No hagas nada de tu trabajo habitual, sino que debes presentar una ofrenda de comida al Señor”. ");
INSERT INTO spavbl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“El Día de la Expiación es el décimo día de este séptimo mes. Celebrarán una reunión sagrada, negándose a sí mismos, y presentarán una ofrenda de comida al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","En este día no debes hacer nada de tu trabajo habitual porque es el Día de la Expiación, cuando las cosas se arreglan para ti ante el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Cualquiera que no practique la el ayuno en este día debe ser expulsado de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Destruiré a cualquiera de ustedes que haga cualquier trabajo en este día. ");
INSERT INTO spavbl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","No hagan ningún tipo de trabajo. Este reglamento es para siempre y para las futuras generaciones dondequiera que vivan. ");
INSERT INTO spavbl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Será un sábado de completo descanso para ustedes, y ayunarán. Observaránsu sábado desde la tarde del noveno día del mes hasta la tarde del día siguiente”. ");
INSERT INTO spavbl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","El Señor dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Di a los israelitas que la fiesta de los tabernáculos para honrar al Señor comienza el día quince del séptimo mes y dura siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","El primer día tened una reunión sagrada. No debes hacer nada de tu trabajo habitual. ");
INSERT INTO spavbl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Durante siete días presentarás ofrendas de comida al Señor. El octavo día tendrás otra reunión santa y presentarás una ofrenda al Señor. Es una reunión para la adoración. No debes hacer nada de tu trabajo habitual. ");
INSERT INTO spavbl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Estas son las fiestas sagradas del Señor, que anunciarán como reuniones sagradas para presentar ofrendas de comida al Señor. Estas incluyen holocaustos, ofrendas de grano, sacrificios y ofrendas de bebida, cada una de ellas de acuerdo al día específico. ");
INSERT INTO spavbl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Todas estas ofrendas son adicionales a las de los sábados del Señor. También son adicionales a tus regalos, a todas tus ofrendas para cumplir promesas, y a todas las ofrendas voluntarias que presentas al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Celebrarán una fiesta en honor del Señor durante siete días, el día quince del séptimo mes, una vez que hayas cosechado sus cosechas. El primer día y el octavo día son sábados de completo descanso. ");
INSERT INTO spavbl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","El primer día recogerás ramas de árboles grandes, de palmeras, de árboles frondosos y de sauces de río, y celebrarás ante el Señor tu Dios durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Celebraránesta fiesta para honrar al Señor durante siete días cada año. Este reglamento es para todos los tiempos y para todas las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","“Vivirás en refugios temporales por siete días. Todo israelita nacido en el país debe vivir en refugios, ");
INSERT INTO spavbl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","para que sus descendientes recuerden que yo hice vivir a los israelitas en refugios cuando los saqué de Egipto. Yo soy el Señor tu Dios”. ");
INSERT INTO spavbl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Así que Moisés les contó a los israelitas todo sobre las fiestas del Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ordena a los israelitas que te traigan aceite de oliva puro y prensado para las lámparas, para que siempre estén encendidas. ");
INSERT INTO spavbl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Desde la tarde hasta la mañana Aarón debe cuidar las lámparas continuamente ante el Señor, fuera del velo del Testimonio en el Tabernáculo de Reunión. Esta regulación es para todos los tiempos y para todas las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Debe cuidar constantemente las lámparas puestas en el candelabro de oro puro ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Usando la mejor harina hornea doce panes, con dos décimas de un efa de harina por cada pan. ");
INSERT INTO spavbl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Colócalos en dos pilas, seis en cada pila, sobre la mesa de oro puro que está delante del Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Poner incienso puro al lado de cada pila para que vaya con el pan y sirva de recordatorio, una ofrenda al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Cada sábado se pondrá el pan delante del Señor, dado por los israelitas como una señal continua del acuerdo eterno. ");
INSERT INTO spavbl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Es para Aarón y sus descendientes. Deben comerlo en un lugar santo, pues deben tratarlo como una parte santísima de las ofrendas de alimentos dadas al Señor. Es su parte de las ofrendas de comida para siempre”. ");
INSERT INTO spavbl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Un día un hombre que tenía una madre israelita y un padre egipcio entró en el campamento israelita y tuvo una pelea con un israelita. ");
INSERT INTO spavbl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","El hijo de la mujer israelita maldijo el nombre del Señor. Así que lo llevaron ante Moisés. (Su madre se llamaba Selomit, hija de Dibri, de la tribu de Dan). ");
INSERT INTO spavbl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Lo detuvieron hasta que quedó claro lo que el Señor quería que hicieran al respecto. ");
INSERT INTO spavbl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Lleva al hombre que me maldijo fuera del campamento. Que todos los que le oyeron maldecir pongan sus manos sobre su cabeza; y que todos le apedreen hasta la muerte. ");
INSERT INTO spavbl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Diles a los israelitas que cualquiera que maldiga a su Dios será castigado por su pecado. ");
INSERT INTO spavbl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Cualquiera que maldiga el nombre del Señor debe ser ejecutado. Todos ustedeslo apedrearán hasta la muerte, tanto si es un extranjero que vive con ustedes como si es un israelita. Si maldicen mi nombre, deben ser ejecutados. ");
INSERT INTO spavbl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Cualquiera que mate a alguien más debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Cualquiera que mate a un animal tiene que reemplazarlo. Una vida por otra. ");
INSERT INTO spavbl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Si alguien hiere a otra persona, lo que haya hecho debe serle hecho: ");
INSERT INTO spavbl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","un hueso roto por un hueso roto, ojo por ojo, diente por diente. Sea cual sea la forma en que hayan herido a la víctima, se les debe hacer lo mismo. ");
INSERT INTO spavbl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Cualquiera que mate un animal tiene que reemplazarlo, pero cualquiera que mate a alguien más debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","A los extranjeros que viven con ustedes se les aplican las mismas leyes que a los israelitas, porque yo soy el Señor su Dios”. ");
INSERT INTO spavbl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moisés dijo esto a los israelitas, y ellos llevaron al hombre que maldijo al Señor fuera del campamento y lo apedrearon hasta la muerte. Los israelitas hicieron lo que el Señor le ordenó a Moisés que hiciera. ");
INSERT INTO spavbl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","El Señor le dijo a Moisés en el Monte Sinaí, ");
INSERT INTO spavbl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Dile a los israelitas: Cuando entren a la tierra que les daré, la tierra misma debe también observar un descanso sabático en honor al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Seis años puedes cultivar tus campos, cuidar tus viñedos y cosechar tus cultivos. ");
INSERT INTO spavbl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Pero el séptimo año ha de ser un sábado de completo descanso para la tierra, un sábado en honor al Señor. No planten sus campos ni cuiden sus viñedos. ");
INSERT INTO spavbl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","No cosechen lo que haya crecido en sus campos, ni recojan las uvas que no hayan cuidado. La tierra debe tener un año de completo descanso. ");
INSERT INTO spavbl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pueden comer lo que la tierra produzca durante el año sabático. Esto se aplica a ti mismo, a tus esclavos y esclavas, a los trabajadores asalariados y a los extranjeros que viven contigo, ");
INSERT INTO spavbl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","y a tu ganado y a los animales salvajes que viven en tu tierra. Todo lo que crezca puede ser usado como alimento. ");
INSERT INTO spavbl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Cuenta siete años sabáticos, es decir, siete veces siete años, para que los siete años sabáticos sumen cuarenta y nueve años. ");
INSERT INTO spavbl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Luegohaz sonar la trompeta por todo el país el décimo día del séptimo mes, que es el Día de la Expiación. Asegúrate de que esta señal se oiga en todo el país. ");
INSERT INTO spavbl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Dedicarás el año cincuenta y anunciarás la libertad en todo el país para todos los que viven allí. Este será su Jubileo, cuando cada uno de ustedes vuelva a reclamar su propiedad y a formar parte de su familia una vez más. ");
INSERT INTO spavbl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","El 50º año será un jubileo para ti. No siembren la tierra, no cosechen lo que haya podido crecer en sus campos, ni recojan las uvas de sus viñedos que no hayan cuidado. ");
INSERT INTO spavbl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Es un Jubileo y debe ser sagrado para ustedes. Podrán comer todo lo que produzca la tierra. ");
INSERT INTO spavbl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","En este año jubilar, cada uno de ustedes volverá a su propiedad. ");
INSERT INTO spavbl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“Si venden tierra a su vecino, o le compran tierra, no se exploten mutuamente. ");
INSERT INTO spavbl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Cuando compren a su prójimo, calculen cuántos años han pasado desde el último Jubileo, pues él les venderá según los años de cosecha que queden. ");
INSERT INTO spavbl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Cuantos más años queden, más pagarán; cuantos menos años queden, menos pagarán, porque en realidad les está vendiendo un número determinado de cosechas. ");
INSERT INTO spavbl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","No se exploten los unos a los otros, sino respeten a Dios, porque yo soy el Señor su Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Guarden mis reglas y observen mis mandamientos, para que puedan vivir con seguridad en la tierra. ");
INSERT INTO spavbl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Entonces la tierra producirá una buena cosecha, para que tengas suficiente comida y vivasseguro en ella. ");
INSERT INTO spavbl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Pero si preguntas: ‘¿A qué iremos en el séptimo año si no sembramos o cosechamos nuestros cultivos?’ ");
INSERT INTO spavbl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Yo te bendeciré en el sexto año, para que la tierra produzca una cosecha que sea suficiente para tres años. ");
INSERT INTO spavbl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Como sembrarán en el octavo año, seguirán comiendo de esa cosecha, que durará hasta su cosecha en el noveno año. ");
INSERT INTO spavbl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“La tierra no debe ser vendida permanentemente, porque realmente me pertenece. Para mí ustedes son sólo extranjeros y viajeros de paso. ");
INSERT INTO spavbl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Así que cualquier tierra que compren, deben hacer arreglos para devolverlo a su dueño original. ");
INSERT INTO spavbl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Si uno de los tuyos se vuelve pobre y te vende parte de su tierra, su familia cercana puede venir y comprar de nuevo lo que ha vendido. ");
INSERT INTO spavbl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Sin embargo, si no tienen a nadie que pueda volver a comprarla, pero mientras tanto su situación financiera mejora y tienen suficiente para volver a comprar la tierra, ");
INSERT INTO spavbl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","trabajarán cuántos años han pasado desde la venta, y devolverán el saldo a la persona que la compró, y volverán a su propiedad. ");
INSERT INTO spavbl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Si no pueden reunir lo suficiente para pagar a la persona por la tierra, el comprador seguirá siendo su propietario hasta el Año Jubilar. Pero en el Jubileo la tierra será devuelta para que el propietario original pueda volver a su propiedad. ");
INSERT INTO spavbl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Si alguien vende una casa situada en una ciudad amurallada, tiene derecho a comprarla de nuevo durante un año completo después de venderla. Puede ser comprada de nuevo en cualquier momento durante ese año. ");
INSERT INTO spavbl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Si no se recompra al final del año, la propiedad de la casa en la ciudad amurallada se transfiere de forma permanente al que la compró y a sus descendientes. No será devuelta en el Jubileo. ");
INSERT INTO spavbl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pero las casas de las aldeas que no tienen muros a su alrededor deben ser tratadas como si estuvieran en el campo. Pueden ser compradas de nuevo, y serán devueltas en el Jubileo. ");
INSERT INTO spavbl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Sin embargo, los levitas siempre tienen el derecho de volver a comprar sus casas en los pueblos que les pertenecen. ");
INSERT INTO spavbl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Todo lo que los levitas poseen puede ser comprado de nuevo, incluso las casas vendidas en sus ciudades, y debe ser devuelto en el Jubileo. Eso es porque las casas en las ciudades de los levitas son lo que se les dio en propiedad como su parte entre los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Sin embargo, los campos que rodean sus ciudades no deben ser vendidos porque pertenecen a los levitas permanentemente. ");
INSERT INTO spavbl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Si alguno de los tuyos se vuelve pobre y no puede subsistir, debes ayudarlos de la misma manera que ayudarías a un extranjero o a un extraño, para que puedan seguir viviendo en tu vecindario. ");
INSERT INTO spavbl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","No les hagas pagar ningún interés o exigir más de lo que pidieron prestado, pero respeta a tu Dios para que puedan seguir viviendo en tu zona. ");
INSERT INTO spavbl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","No les prestes plata con intereses ni les vendas comida a un precio exagerado. ");
INSERT INTO spavbl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Recuerda, yo soy el Señor tu Dios que te sacó de Egipto para darte la tierra de Canaán y ser tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Si alguno de los tuyos se hace pobre y tiene que venderse para trabajar para ti, no le obligues a trabajar como esclavo. ");
INSERT INTO spavbl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Haz que vivan contigo como un trabajador asalariado que se queda contigo por un tiempo. Trabajarán para usted hasta el año del Jubileo. ");
INSERT INTO spavbl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Entonces ellos y sus hijos deben ser liberados, y pueden volver a su familia y a la propiedad de su familia. ");
INSERT INTO spavbl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Los israelitas no deben ser vendidos como esclavos porque me pertenecen como mis esclavos - los saqué de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","No los traten con brutalidad. Tengan respeto por su Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Compra tus esclavos y esclavas de las naciones vecinas. ");
INSERT INTO spavbl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","También puedes comprarlos a los extranjeros que han venido a vivir entre ustedes, o a sus descendientes nacidos en tu tierra. Puedes tratarlos como tu propiedad. ");
INSERT INTO spavbl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Puedes pasarlos a tus hijos para que los hereden como propiedad después de tu muerte. Puedes convertirlos en esclavos de por vida, pero no debes tratar brutalmente como esclavo a ninguno de tu propio pueblo, los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Si un extranjero entre ustedes tiene éxito, y uno de los suyos que vive cerca se empobrece y se vende al extranjero o a un miembro de su familia, ");
INSERT INTO spavbl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","todavía tienen derecho a ser comprados de nuevo después de la venta. Un miembro de su familia puede volver a comprarlos. ");
INSERT INTO spavbl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Un tío, o primo, o cualquier pariente cercano de su familia puede volver a comprarlos. Si tienen éxito, pueden volver a comprarse a sí mismos. ");
INSERT INTO spavbl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","El interesado y su comprador calcularán el tiempo desde el año de la venta hasta el año del jubileo. El precio dependerá del número de años, calculado con la tarifa diaria de un trabajador asalariado. ");
INSERT INTO spavbl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Si quedan muchos años, deberán pagar un porcentaje mayor del precio de compra. ");
INSERT INTO spavbl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Si sólo quedan unos pocos años antes del Año Jubilar, entonces sólo tienen que pagar un porcentaje dependiendo del número de años que les queden. ");
INSERT INTO spavbl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Deben vivir con su propietario extranjero como un trabajador asalariado, contratado de año en año, pero procuren que el propietario no lo trate brutalmente. ");
INSERT INTO spavbl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Si no son recomprados de ninguna de las maneras descritas, ellos y sus hijos serán liberados en el Año Jubilar. ");
INSERT INTO spavbl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Porque los israelitas me pertenecen como mis esclavos. Son mis esclavos, yo los saqué de Egipto. Yo soy el Señor tu Dios”. ");
INSERT INTO spavbl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“No hagas ídolos en ninguna parte de la tierra ni te inclinespara adorarlos, ya sean imágenes o altares sagrados, o esculturas de piedra. Porque yo soy el Señor tu Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Guarda mis sábados y respeta mi santuario. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Si sigues mis reglas y guardas mis mandamientos, ");
INSERT INTO spavbl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","me aseguraré de que llueva en el tiempo adecuado para que la tierra crezca bien y los árboles den su fruto. ");
INSERT INTO spavbl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Tu tiempo de trilla durará hasta la cosecha de la uva, y la cosecha de la uva hasta el momento en que tengas que volver a sembrar. Tendrán más que suficiente para comer y vivirán seguros en su tierra. ");
INSERT INTO spavbl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Me aseguraré de que tu tierra esté en paz. Podrás dormir sin tener miedo de nada. Me desharé de los animales peligrosos de la tierra, y no sufrirás ningún ataque violento del enemigo. ");
INSERT INTO spavbl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Perseguirás a tus enemigos y los matarás con la espada. ");
INSERT INTO spavbl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinco de ustedes matarán a cien, y cien de ustedes matarán a diez mil. Destruirás a tus enemigos. ");
INSERT INTO spavbl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Vendré a ayudarte, para que te reproduzcas y aumentes en número, y confirmaré mi acuerdo contigo. ");
INSERT INTO spavbl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Seguirás comiendo tu viejo stock de grano cuando necesites deshacerte de él para poder almacenar el nuevo grano. ");
INSERT INTO spavbl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Vendré a vivir contigo, no te rechazaré. ");
INSERT INTO spavbl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Siempre estaré a tu lado. Seré tu Dios, y tú serás mi pueblo. ");
INSERT INTO spavbl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Yo soy el Señor tu Dios, que te sacó de Egipto para que no tuvieras que ser más esclavo de los egipcios. Rompí el yugo que te mantenía agachado y te ayudaba a mantenerte erguido. ");
INSERT INTO spavbl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Pero si no me prestas atención y haces lo que te digo; ");
INSERT INTO spavbl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","si rechazas mis leyes, odias mis reglamentos y te niegas a seguir mis mandamientos y, por consiguiente, rompes mi acuerdo, ");
INSERT INTO spavbl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","entonces esto es lo que te voy a hacer: Te haré entrar en pánico y sufrirás enfermedades como tuberculosis y fiebre, que te dejarán ciego y te consumirán. Será inútil para ti sembrar en tus campos porque tus enemigos se comerán la cosecha. ");
INSERT INTO spavbl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Me volveré contra ti y serás derrotado por tus enemigos. La gente que te odia gobernará sobre ti, ¡y huirás incluso cuando nadie te esté persiguiendo! ");
INSERT INTO spavbl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Si después de todo esto todavía te niegas a obedecerme, pasaré a castigarte siete veces por tus pecados. ");
INSERT INTO spavbl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Romperé tu fuerza autosuficiente de la que estás tan orgulloso, y haré que tu cielo sea duro como el hierro y tu tierra dura como el bronce. ");
INSERT INTO spavbl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Tu fuerza será en completamente en vano porque su tierra no producirá cultivos, y sus árboles no darán frutos. ");
INSERT INTO spavbl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Si continúas oponiéndote a mí y negándote a hacer lo que te digo, haré que tus castigos sean siete veces peores, basados en tus pecados. ");
INSERT INTO spavbl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Enviaré animales salvajes a matar a sus hijos, a eliminar su ganado y a haceros tan pocos que no habrá nadie en sus caminos. ");
INSERT INTO spavbl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Sin embargo, si a pesar de toda esta corrección no cambian sino que siguen en rebeldía contra a mí, ");
INSERT INTO spavbl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","entonces tomaré medidas contra ustedes. Te castigaré siete veces por tus pecados. ");
INSERT INTO spavbl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Enviaré a los enemigos con espadas para que te ataquen por quebrantar el pacto. Aunque te retires a tus ciudades para defenderte, te plagaré de enfermedades y serás entregado a tus enemigos. ");
INSERT INTO spavbl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Enviaré una hambruna para que haya escasez de pan. Un horno servirá para las necesidades de diez mujeres que hacen pan. Se distribuirá por peso para que coman, pero no tendrán suficiente. ");
INSERT INTO spavbl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Sin embargo, si a pesar de todo esto no me obedecen, sino que siguen en oposición a mí, ");
INSERT INTO spavbl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","entonces actuaré contra ustedes con furia, y yo mismo los castigaré siete veces por sus pecados. ");
INSERT INTO spavbl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Se comerán los cuerpos de sus propios hijos e hijas. ");
INSERT INTO spavbl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Destruiré sus lugares altos de adoración, destrozaré sus altares de incienso, y apilaré sus cadáveres sobre lo que queda de sus ídolos, que tampoco tienen vida alguna. Los despreciaré de verdad. ");
INSERT INTO spavbl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Demolerésus ciudades y destruiré sus santuarios paganos, y me negaré a aceptar sus sacrificios. ");
INSERT INTO spavbl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Yo mismo devastaré su tierra, para que sus enemigos que vengan a vivir en ella se horroricen de lo que ha sucedido. ");
INSERT INTO spavbl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Los dispersaré entre las naciones. Serán perseguidos por ejércitos con espadas mientras su tierra queda en ruinas y sus pueblos son destruidos. ");
INSERT INTO spavbl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Al menos entonces la tierra podrá disfrutar de sus sábados todo el tiempo que esté abandonada mientras ustedes estén exiliados en la tierra de sus enemigos. La tierra finalmente podrá descansar y disfrutar de sus sábados. ");
INSERT INTO spavbl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Todo el tiempo que la tierra esté abandonada, observará los sábados de descanso que no pudo guardar mientras ustedes vivían en ella. ");
INSERT INTO spavbl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Haré que aquellos de ustedes que sobrevivan se desanimen tanto que mientras vivan en las tierras de sus enemigos incluso el sonido de una hoja soplando en el viento les asustará para que huyan! Huirán como si fuerais perseguidos por alguien con una espada, y caerán aunque nadie los persiga. ");
INSERT INTO spavbl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Tropezarán unos con otros como si huyeran del ataque, aunque no venga nadie. No tendrás poder para resistir a tus enemigos. ");
INSERT INTO spavbl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Morirás en el exilio y serás enterrado en un país extranjero. ");
INSERT INTO spavbl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Aquellos que logren sobrevivir en los países de sus enemigos se marchitarán por su culpa, pudriéndose al compartir los pecados de sus padres. ");
INSERT INTO spavbl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Necesitan confesar sus pecados y los de sus padres, actuando de manera tan infiel hacia mí, oponiéndose a mí. ");
INSERT INTO spavbl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Por eso tomé medidas contra ellos y los exilié en los países de sus enemigos. Sin embargo, si humildemente abandonan su actitud obstinada y aceptan el castigo por sus pecados, ");
INSERT INTO spavbl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","entonces cumpliré el acuerdo que hice con Jacob, Isaac y Abraham, y no olvidaré mi promesa sobre la tierra. ");
INSERT INTO spavbl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Porque la tierra quedará vacía para ellos, y disfrutará de sus sábados siendo abandonada. Pagarán por sus pecados, porque rechazaron mis reglas y regulaciones. ");
INSERT INTO spavbl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Pero a pesar de todo esto, aunque vivan en la tierra de sus enemigos, no los rechazaré ni los odiaré tanto como para destruirlos y romper mi acuerdo con ellos, porque yo soy el Señor su Dios. ");
INSERT INTO spavbl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Por ellos renovaré el acuerdo que hice con sus padres, a los que saqué de Egipto como las otras naciones observaron, para ser su Dios. Yo soy el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Estas son las normas, reglamentos y leyes que el Señor estableció entre él y los israelitas a través de Moisés en el Monte Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Dile a los israelitas: Cuando haces una promesa especial de dedicar a alguien al Señor, estos son los valores que debes usar. ");
INSERT INTO spavbl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","El valor de un hombre de veinte a sesenta años es de cincuenta siclos de plata, (usando el estándar del siclo del santuario). ");
INSERT INTO spavbl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","El valor de una mujer es de treinta siclos. ");
INSERT INTO spavbl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","El valor de alguien de cinco a veinte años es de veinte siclos para un hombre y diez siclos para una mujer. ");
INSERT INTO spavbl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","El valor de alguien de un mes a cinco años es de cinco siclos de plata para un hombre y tres siclos de plata para una mujer. ");
INSERT INTO spavbl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","El valor de alguien de sesenta años o más es de quince siclos para un hombre y diez siclos de plata para una mujer. ");
INSERT INTO spavbl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Sin embargo, si al cumplir su promesa es más pobre que el valor fijado, debe presentar a la persona ante el sacerdote, quien entonces fijará el valor dependiendo de lo que pueda pagar. ");
INSERT INTO spavbl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Si al cumplir tu promesa traes un animal que esté permitido como ofrenda al Señor, el animal dado al Señor será considerado santo. ");
INSERT INTO spavbl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","No se le permite reemplazarlo o cambiarlo, ya sea por uno mejor o peor. Sin embargo, si lo reemplazas, ambos animales se convierten en sagrados. ");
INSERT INTO spavbl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“Si al cumplir tu promesa traes algún animal impuro que no esté permitido como ofrenda al Señor, entonces debes mostrar el animal al sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","El sacerdote decidirá su valor, ya sea alto o bajo. Cualquier valor que el sacerdote le dé es definitivo. ");
INSERT INTO spavbl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Si luego decide comprar el animal de nuevo, debe agregar un quinto a su valor en pago. ");
INSERT INTO spavbl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Si usted dedica su casa como santa al Señor, entonces el sacerdote decidirá su valor, ya sea alto o bajo. Cualquier valor que el sacerdote le ponga será definitivo. ");
INSERT INTO spavbl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Pero si quieres volver a comprar tu casa, tienes que añadir un quinto a su valor en pago. Entonces le pertenecerá de nuevo. ");
INSERT INTO spavbl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Si dedicas parte de tu tierra al Señor, entonces su valor se determinará por la cantidad de semilla necesaria para sembrarla: cincuenta siclos de plata por cada homer de semilla de cebada utilizada. ");
INSERT INTO spavbl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Si dedicas tu campo durante el año jubilar, el valor será la cantidad total calculada. ");
INSERT INTO spavbl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pero si dedicas tu campo después del Jubileo, el sacerdote calculará el valor dependiendo del número de años que queden hasta el siguiente Año Jubilar, reduciendo así el valor. ");
INSERT INTO spavbl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Pero si quieres volver a comprar tu campo, tienes que añadir un quinto a su valor en pago. Entonces le pertenecerá de nuevo. ");
INSERT INTO spavbl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Pero si no compras el campo de nuevo, o si ya lo has vendido a alguien más, no puede ser comprado de nuevo. ");
INSERT INTO spavbl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Cuando llegue el Jubileo, el campo se convertirá en sagrado, de la misma manera que un campo dedicado al Señor. Se convertirá en propiedad de los sacerdotes. ");
INSERT INTO spavbl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Si le dedicas al Señor un campo que has comprado y que no era de tu propiedad original, ");
INSERT INTO spavbl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","el sacerdote calculará el valor hasta el próximo año del Jubileo. Ese día pagará el valor exacto, dándoselo como una ofrenda sagrada al Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","En el Año Jubilar, la propiedad del campo volverá a la persona a la que se lo compraste, al propietario original del terreno. ");
INSERT INTO spavbl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","(Todos los valores usarán el estándar del siclo del santuario de veinte gerahs al siclo). ");
INSERT INTO spavbl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Nadie puede dedicar el primogénito del ganado, porque el primogénito pertenece al Señor. Ya sea que se trate de ganado vacuno, ovino o caprino, son del Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Pero si se trata de un animal impuro, se puede volver a comprar según su valor, añadiendo un quinto extra. Si no se vuelve a comprar, entonces se vende según su valor. ");
INSERT INTO spavbl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Todo lo que dediques deforma especialal Señor, ya sea una persona, animal o tu tierra, no podrá ser vendido o rescatado. Todo lo que sea dedicado especialmente será santo para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“Ninguno que sea especialmente dedicado para la destrucción podrá ser redimido. Debe ser asesinado. ");
INSERT INTO spavbl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“El diezmo de sus cosechas o de sus frutos le pertenece al Señor; es santo para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Si quieren volver a comprar parte de su diezmo, deben añadir un quinto a su valor. ");
INSERT INTO spavbl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“Cuando cuentes tus rebaños y manadas, cada décimo animal que pase bajo la vara del pastor es santo para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","No necesitarás examinarlo para ver si es bueno o malo, y no debes reemplazarlo. Sin embargo, si lo reemplazas, ambos animales serán sagrados; no podrán ser comprados de nuevo”. ");
INSERT INTO spavbl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Estas son las leyes que el Señor dio a Moisés para los israelitas en el Monte Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","El Señor le habló a Moisés en el Tabernáculo de Reunión mientras estaban en el desierto del Sinaí. Esto fue el primer día del segundo mes, dos años después de que los israelitas salieran de Egipto. Le dijo: ");
INSERT INTO spavbl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Censen a todos los israelitas según su tribu y su familia. Cuenten a cada hombre y mantengan un registro del nombre de cada uno. ");
INSERT INTO spavbl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Tú y Aarón deberán registrar a todos los mayores de veinte años que sean aptos para prestar el servicio militar según sus divisiones en el ejército israelita. ");
INSERT INTO spavbl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Para ayudarlos habrá estar con ustedes un representante de cada tribu, que es el jefe de cada familia: ");
INSERT INTO spavbl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Estos son los nombres de los hombres que trabajarán con ustedes: De la tribu de Rubén, Elisur, hijo de Sedeur; ");
INSERT INTO spavbl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","de la tribu de Simeón, Selumiel, hijo de Zurisadai; ");
INSERT INTO spavbl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","de la tribu de Judá, Naasón, hijo de Aminadab; ");
INSERT INTO spavbl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","de la tribu de Isacar, Nataanel, hijo de Zuar; ");
INSERT INTO spavbl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","de la tribu de Zabulón, Eliab, hijo de Helón; ");
INSERT INTO spavbl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","de los hijos de José: de la tribu de Efraín, Elisama, hijo de Amihud; y de la tribu de Manasés, Gamaliel, hijo de Pedasur; ");
INSERT INTO spavbl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","de la tribu de Benjamín, Abidán, hijo de Gedeoni; ");
INSERT INTO spavbl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","de la tribu de Dan, Ajiezer, hijo de Amisadai; ");
INSERT INTO spavbl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","de la tribu de Aser, Pagiel, hijo de Ocrán; ");
INSERT INTO spavbl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","de la tribu de Gad, Eliasaf, hijo de Deuel; ");
INSERT INTO spavbl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","y de la tribu de Neftalí, Ahira, hijo de Enán”. ");
INSERT INTO spavbl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Estos fueron los hombres elegidos de la comunidad israelita. Eran los jefes de las tribus de sus padres; los jefes de las familias de Israel. ");
INSERT INTO spavbl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moisés y Aarón convocaron a estos hombres que habían sido seleccionados por nombre. ");
INSERT INTO spavbl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Hicieron que todos los israelitas se reunieran el primer día del segundo mes, y registraron la genealogía del pueblo según su tribu y familia, y contaron los nombres de todos los que tenían veinte años o más, ");
INSERT INTO spavbl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","como el Señor le había dicho a Moisés que hiciera. Moisés llevó a cabo este censo en el desierto del Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Los descendientes de Rubén, (que era el hijo primogénito de Israel), hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y familias. Y todos los hombres registrados que estaban aptos para servir en el ejército ");
INSERT INTO spavbl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","n la tribu de Rubén sumaron 46.500. ");
INSERT INTO spavbl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Los descendientes de Simeón, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos hombres registrados que estaban aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","de la tribu de Simeón, sumaron 59.300. ");
INSERT INTO spavbl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Los descendientes de Gad, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres registrados que estaban aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","de la tribu de Gad, sumaron 45.650. ");
INSERT INTO spavbl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Los descendientes de Judá, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres inscritos, que estaban aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","de la tribu de Judá, sumaron 74.600. ");
INSERT INTO spavbl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Los descendientes de Isacar, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres inscritos que eran aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","de la tribu de Isacar, sumaron 54.400. ");
INSERT INTO spavbl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Los descendientes de Zabulón, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres inscritos que estaban aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","de la tribu de Zabulón, sumaron 57.400. ");
INSERT INTO spavbl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Los descendientes de José: los descendientes de Efraín, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres registrados que estaban aptos para servir en el ejército ");
INSERT INTO spavbl_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","de la tribu de Efraín, sumaron 40.500. ");
INSERT INTO spavbl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Y los descendientes de Manasés, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres registrados que estaban aptos para servir en el ejército ");
INSERT INTO spavbl_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","de la tribu de Manasés, sumaron 32.200. ");
INSERT INTO spavbl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Los descendientes de Benjamín, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres registrados que estaban aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","de la tribu de Benjamín, totalizaban 35.400. ");
INSERT INTO spavbl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Los descendientes de Dan, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres registrados que estaban aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","de la tribu de Dan, sumaron 62.700. ");
INSERT INTO spavbl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Los descendientes de Aser, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres inscritos que estaban aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","de la tribu de Aser, sumaron 41.500. ");
INSERT INTO spavbl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Los descendientes de Neftalí, hombres de veinte años o más, fueron registrados por nombre según los registros genealógicos de su tribu y sus familias. Todos los hombres inscritos que estaban aptos para servir en el ejército, ");
INSERT INTO spavbl_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","de la tribu de Neftalí, sumaron 53.400. ");
INSERT INTO spavbl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Estos fueron los totales de los hombres contados y registrados por Moisés y Aarón, con la ayuda de los doce líderes de Israel, que representaban cada uno a su familia. ");
INSERT INTO spavbl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","De esta manera, todos los hombres israelitas de veinte años o más que pudieron servir en el ejército de Israel fueron registrados según sus familias. ");
INSERT INTO spavbl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","La suma total de los registrados fue de 603.550. ");
INSERT INTO spavbl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Sin embargo, los levitas no estaban registrados con los demás según su tribu y sus familias. ");
INSERT INTO spavbl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Esto se debió a que el Señor le había dicho a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“No registres la tribu de Leví, ni los cuentes en el censo con los otros israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Pon a los levitas a cargo del Tabernáculo y del Testimonio, así como de todo su mobiliario y de todo lo que hay en él. Ellos serán los responsables de llevar el Tabernáculo y todos sus artículos. Deben cuidarlo, y hacer su campamento alrededor de él. ");
INSERT INTO spavbl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Cuando llegue el momento de trasladar el Tabernáculo, los levitas lo bajarán, y cuando llegue el momento de acampar, los levitas lo levantarán. Cualquier forastero que se acerque al Tabernáculo debe ser condenado a muerte. ");
INSERT INTO spavbl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Los israelitas acamparán por tribus, cada uno estará en su propio campamento, bajo su propia bandera. ");
INSERT INTO spavbl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Pero los levitas deben levantar su campamento alrededor del Tabernáculo del Testimonio para evitar que alguien me haga enojar con los israelitas. Los levitas son responsables de cuidar el Tabernáculo del Testimonio”. ");
INSERT INTO spavbl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Los israelitas hicieron todo lo que el Señor les ordenó a través de Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","El Señor les dijo a Moisés y Aarón: ");
INSERT INTO spavbl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Los israelitas deben establecer su campamento alrededor del Tabernáculo de Reunión pero a cierta distancia de él. Cada miembro de cada tribu acampará bajo su propia bandera y estandarte familiar. ");
INSERT INTO spavbl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","La tribu de Judá acampará bajo su bandera en el lado este. Su líder es Naasón, hijo de Aminadab, ");
INSERT INTO spavbl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","tiene 74.600 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","La tribu de Isacar acampará junto a ellos. Su líder es Natanael, hijo de Zuar, ");
INSERT INTO spavbl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","y tiene 54.400 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","La siguiente es la tribu de Zabulón. Su líder es Eliab, hijo de Helón, ");
INSERT INTO spavbl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","y tiene 57.400 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Así que el total de hombres en el territorio de Judá e de 186.400. Y cuando llegue la hora de marcharse, ellos irán a la cabeza. ");
INSERT INTO spavbl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“La tribu de Rubén acampará bajo su bandera en el lado sur. Su líder es Elisur, hijo de Sedeúr, ");
INSERT INTO spavbl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","cuenta con 46.500 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","La tribu de Simeón acampará junto a ellos. Su líder es Selumiel, hijo de Zurisadai, ");
INSERT INTO spavbl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","y cuenta con 59.300 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","La siguiente es la tribu de Gad. Su líder es Eliasaph, hijo de Deuel, ");
INSERT INTO spavbl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","y cuenta con 45.650 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Así que el número total de hombres en el área del campamento de Rubén es de 151.450. Ellos marcharán en segundo lugar. ");
INSERT INTO spavbl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“El Tabernáculo de Reunión que está en el centro del campamento acompañará a los levitas. Deben marchar en el mismo orden en que levantaron el campamento, cada uno en el lugar que le corresponde, bajo su bandera. ");
INSERT INTO spavbl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“La tribu de Efraín acampará bajo su bandera en el lado oeste. Su líder es Elisama, hijo de Amiud, ");
INSERT INTO spavbl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","y cuenta con 40.500 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","La tribu de Manasés acampará junto a ellos. Su líder es Gamaliel, hijo de Pedasur, ");
INSERT INTO spavbl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","y cuenta con 32.200 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","La siguiente es la tribu de Benjamín. Su líder es Abidán, hijo de Gedeoni, ");
INSERT INTO spavbl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","y cuenta con 35.400 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Así que el número total de hombres en el área del campamento de Efraín es de 108.100. Ellos marcharán en tercer lugar. ");
INSERT INTO spavbl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“La tribu de Dan acampará bajo su bandera en el lado norte. Su líder es Ajiezer, hijo de Amisadai, ");
INSERT INTO spavbl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","y cuenta con 62.700 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","La tribu de Aser acampará junto a ellos. Su líder es Pagiel, hijo de Ocrán, ");
INSERT INTO spavbl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","y cuenta con 41.500 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","A continuación estará la tribu de Neftalí. Su líder es Ajirá, hijo de Enán, ");
INSERT INTO spavbl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","y cuenta con 53.400 hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Así que el total de hombres en el área del campamento de Dan es de 157.600. Ellos marcharán en último lugar, con sus banderas”. ");
INSERT INTO spavbl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Este es un resumen del censo de los israelitas, hecho por familia. El total final de los contados en los campamentos por tribus fue de 603.550. ");
INSERT INTO spavbl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Sin embargo, los levitas no fueron contados entre los demás israelitas, siguiendo las instrucciones que el Señor le dio a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Los israelitas hicieron todo lo que el Señor le ordenó a Moisés. Establecieron sus campamentos bajo sus banderas en sus posiciones asignadas, y marchaban en el mismo orden, cada uno con su propia tribu y familia. ");
INSERT INTO spavbl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Este es el relato sobre Aarón y Moisés cuando el Señor le habló a Moisés en el Monte Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Los nombres de los hijos de Aarón eran: Nadab (primogénito), Abiú, Eleazar e Itamar. ");
INSERT INTO spavbl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Estos eran los nombres de los hijos de Aarón que fueron ungidos y ordenados para servir como sacerdotes. ");
INSERT INTO spavbl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab y Abiú murieron en la presencia del Señor cuando ofrecieron el fuego prohibido ante el Señor en el desierto del Sinaí. Como no tenían hijos, Eleazar e Itamar sirvieron como sacerdotes mientras su padre Aarón vivía. ");
INSERT INTO spavbl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Reúne a la tribu de Leví y preséntalos ante el sacerdote Aarón para que le ayuden en el ministerio. ");
INSERT INTO spavbl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Deben cumplir con sus deberes en su nombre y en nombre de todos los israelitas en el Tabernáculo de Reunión, cuidando el servicio del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Serán responsables de cuidar todo el mobiliario del Tabernáculo de Reunión, sirviendo a los israelitas a través de su trabajo en el Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Los levitas deben trabajar exclusivamente para Aarón y sus hijos de porque esta es su asignación entre los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Tú designarás a Aarón y a sus hijos para que tengan la responsabilidad del sacerdocio. Cualquier otro que intente actuar como sacerdote debe ser ejecutado”. ");
INSERT INTO spavbl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“He tomado a los levitas de entre los israelitas en lugar de cada uno de sus primogénitos. Los levitas me pertenecen ");
INSERT INTO spavbl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","porque todos los primogénitos son míos. Cuando maté a cada primogénito en Egipto, separé como sagrado para mí a todos los primogénitos de Israel, humanos y animales. Son míos. Yo soy el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","El Señor le habló a Moisés en el desierto del Sinaí, y le dijo: ");
INSERT INTO spavbl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Censa a los levitas según la genealogía de su padre y su familia. Cuenten cada varón de un mes o mayor”. ");
INSERT INTO spavbl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Entonces Moisés los registró, siguiendo las instrucciones del Señor, tal como se lo había dicho. ");
INSERT INTO spavbl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Estos eran los nombres de los hijos de Levi: Gersón, Coat y Merari. ");
INSERT INTO spavbl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Estos eran los nombres de los hijos de Gersón por familia: Libni y Simeí. ");
INSERT INTO spavbl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Los hijos de Coat por familia eran Amram, Izar, Hebrón y Uziel. ");
INSERT INTO spavbl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Los hijos de Merari, por familia, eran Majlí y Musí. Estas eran las familias de los levitas, según el linaje de su padre. ");
INSERT INTO spavbl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","La familia de Libni y la familia de Simeí procedían de Gersón. Estas eran las familias de Gersón. ");
INSERT INTO spavbl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","El total de todos los varones de un mes o más era de 7.500. ");
INSERT INTO spavbl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","El campamento de las familias de Gerson estaba al oeste, detrás del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","El líder de las familias de Gerson era Eliasaf, hijo de Lael. ");
INSERT INTO spavbl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Su responsabilidad asignada para el Tabernáculo de Reunión era cuidar del Tabernáculo y la tienda, su cubierta, la cortina de la entrada del Tabernáculo de Reunión, ");
INSERT INTO spavbl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","las cortinas del patio, la cortina de la entrada del patio que rodea el Tabernáculo y el altar, las cuerdas y todo lo relacionado con su uso. ");
INSERT INTO spavbl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Las familias de Amram, Izar, Hebrón y Uziel procedían de Coat. Estas eran las familias de Coat. ");
INSERT INTO spavbl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","El total de todos los varones de un mes o más era de 8.600. Su responsabilidad asignada era cuidar del santuario. ");
INSERT INTO spavbl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","El campamento de las familias de Coat estaba en el lado sur del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","El líder de las familias de Coat era Elisafán, hijo de Uziel. ");
INSERT INTO spavbl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Su responsabilidad asignada era cuidar el Arca, la mesa, el candelabro, los altares, los artículos del santuario usados con ellos, el velo, y todo lo relacionado con estos artículos. ");
INSERT INTO spavbl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","El jefe de los líderes de los levitas era Eleazar, hijo del sacerdote Aarón. Él estaba a cargo de los responsables de servir en el santuario. ");
INSERT INTO spavbl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","La familia de Majlí y la familia de Musíprocedían de Merari. Estas eran las familias de Merari. ");
INSERT INTO spavbl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","El total de todos los varones de un mes o más era de 6.200. ");
INSERT INTO spavbl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","El líder de las familias de Merari era Zuriel, hijo de Abijaíl. Su campamento estaba en el lado norte del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Su responsabilidad asignada era cuidar de los marcos del Tabernáculo, barras transversales, postes, soportes, todo su equipo y todo lo relacionado con su uso, ");
INSERT INTO spavbl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","así como los postes del patio circundante con sus soportes, estacas y cuerdas. ");
INSERT INTO spavbl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","El campamento de los hijos de Moisés, Aarón y Aarón estaba al Este del santuario, con vista al amanecer, frente al Tabernáculo de Reunión. Eran responsables del santuario en nombre de los israelitas. Cualquier otro que intentara actuar como sacerdote debía ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","La suma total de levitas registrados por Moisés y Aarón como el Señor ordenó fue de 22.000. Esto incluía a todos los varones de un mes o mayores. ");
INSERT INTO spavbl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","El Señor le dijo a Moisés: “Haz un censo de todos los primogénitos varones israelitas de un mes o más, y registra sus nombres. ");
INSERT INTO spavbl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Aparta a los levitas para mí. Yo soy el Señor. Ellos están en lugar de todos los primogénitos de los israelitas. El ganado de los levitas está en lugar de todo el ganado primogénito de los israelitas”. ");
INSERT INTO spavbl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moisés realizó un censo de todos los primogénitos de los israelitas, tal como el Señor le había instruido. ");
INSERT INTO spavbl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","La suma total de los primogénitos varones de un mes o más, registrados por nombre, fue de 22.273. ");
INSERT INTO spavbl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","El Señor habló con Moisés y le dijo: ");
INSERT INTO spavbl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Debes tomar a los levitas en lugar de todos los primogénitos de Israel, y el ganado de los levitas en lugar de su ganado, porque los levitas me pertenecen. Yo soy el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Para poder comprar los 273 primogénitos de Israel que son más que el número de levitas, ");
INSERT INTO spavbl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","se recaudan cinco siclos para cada uno de ellos, (usando la norma del siclo del santuario de veinte geras). ");
INSERT INTO spavbl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Entregarás el dinero a Aarón y a sus hijos como precio de redención para cubrir el exceso de los israelitas que sobran”. ");
INSERT INTO spavbl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moisés recaudó el dinero de redención para aquellos israelitas que excedían el número redimido por los levitas. ");
INSERT INTO spavbl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Recolectó el dinero dado en nombre de los primogénitos de los israelitas. Llegó a recolectar 1.365 siclos, (usando el estándar del siclo del santuario). ");
INSERT INTO spavbl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Moisés dio este dinero de redención a Aarón y sus hijos como el Señor se lo había dicho, siguiendo las instrucciones del Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","El Señor le dijo a Moisés y Aarón: ");
INSERT INTO spavbl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Registra a los descendientes de Coat de la tribu de Leví, de acuerdo a su familia y línea paterna. ");
INSERT INTO spavbl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Cuenta a los hombres de treinta a cincuenta años y que tengan derecho a hacer el trabajo de servir en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Este trabajo que deben hacer en el Tabernáculo de Reunión implica cuidar las cosas más sagradas. ");
INSERT INTO spavbl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Cada vez que muevan el campamento, Aarón y sus hijos entrarán, quitarán el velo y lo colocarán sobre el Arca del Testimonio. ");
INSERT INTO spavbl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Sobre esto pondrán una fina cubierta de cuero, extenderán un paño de color azul sólido sobre ella, y luego insertarán las varas para transportarlo. ");
INSERT INTO spavbl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Que extiendan también un paño azul sobre la mesa de la Presencia, y que pongan sobre ella los platos y las copas, así como los cuencos y las jarras para la ofrenda de bebida. La ofrenda permanente de pan debe permanecer sobre ella. ");
INSERT INTO spavbl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Sobre todas estas cosas deben extender un paño carmesí, luego una fina cubierta de cuero, y luego insertar las varas para transportarla. ");
INSERT INTO spavbl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Con un paño azul cubrirán el candelabro de luz, junto con sus lámparas, pinzas de mecha y bandejas, así como los frascos de aceite de oliva que se usan para llenarlos. ");
INSERT INTO spavbl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Luego deben envolverlo junto con todos sus utensilios dentro de una fina cubierta de cuero y colocarlo enel bastidor para transportarlo. ");
INSERT INTO spavbl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Deben extender un paño azul sobre el altar de oro, cubrirlo con cuero fino, y luego insertar sus varas para transportarlo. ");
INSERT INTO spavbl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Deben colocar todos los utensilios usados para el servicio en el santuario en un paño azul, cubrirlos con cuero fino y colocarlos en el bastidor para transportarlos. ");
INSERT INTO spavbl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Que limpien las cenizas del altar de bronce y extiendan un paño morado sobre él, ");
INSERT INTO spavbl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","y que pongan sobre él todo el equipo usado en los servicios del altar: los fogones, los tenedores para la carne, las palas y los aspersores. Extiendan sobre él una fina cubierta de cuero y luego inserten las varas para transportarlo. ");
INSERT INTO spavbl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Una vez que Aarón y sus hijos hayan terminado de cubrir estas cosas sagradas y todo el equipo relacionado con ellas, cuando el campamento esté listo para moverse, los sacerdotes de la familia Coat vendrán y las llevarán. Pero tienen prohibido tocar cualquier cosa sagrada, de lo contrario morirán. Estas son sus responsabilidades a la hora de trasladar el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazar, hijo del sacerdote Aarón, supervisará la obtención del aceite de oliva para las lámparas, el incienso aromático, la ofrenda de grano diaria y el aceite de la unción. Estará a cargo de todo el Tabernáculo y todo lo que hay en él, todas las cosas sagradas y el equipo”. ");
INSERT INTO spavbl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Entonces el Señor le dijo a Moisés y Aarón: ");
INSERT INTO spavbl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Asegúrense de que las familias de Coat no sean eliminadas entre los levitas. ");
INSERT INTO spavbl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Esto es lo que tienes que hacer para que vivan y no mueran por acercarse demasiado a un objeto sagrado: Aarón y sus hijos deben entrar y decirle a cada uno de ellos lo que tienen que hacer y lo que tienen que llevar. ");
INSERT INTO spavbl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Pero no deben entrar y mirar las cosas más sagradas, ni siquiera por un momento, de lo contrario morirán”. ");
INSERT INTO spavbl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Registra a los descendientes de Gersón, según su familia y el linaje paterno. ");
INSERT INTO spavbl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Cuenta a los hombres de treinta a cincuenta años que tengan derecho a hacer el trabajo de servir en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Así es como las familias de Gersón servirán en cuanto a trabajo y el traslado: ");
INSERT INTO spavbl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","levarán las cortinas del Tabernáculocon su fina cubierta de cuero, las cortinas de la entrada del Tabernáculo de Reunión, ");
INSERT INTO spavbl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","las cortinas del patio, la cortina de la entrada del patio que rodea el Tabernáculo y el altar, las cuerdas y todo lo relacionado con su uso. Las familias de Gersón son responsables de todo lo que se requiera en relación con estos artículos. ");
INSERT INTO spavbl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Todo lo que hagan estará bajo la supervisión de Aarón y sus hijos, así como todo el trabajo y las tareas que lleven a cabo. Debes decirles todo lo que deben llevar. ");
INSERT INTO spavbl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Estas son sus responsabilidades para el traslado del Tabernáculo de Reunión, realizado bajo la dirección de Itamar, hijo del sacerdote Aarón. ");
INSERT INTO spavbl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Registra los descendientes de Merari, según su familia y linaje paterno. ");
INSERT INTO spavbl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Cuenta a los hombres de treinta a cincuenta años que tengan derecho a realizar el trabajo de servir en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Así es como servirán en el manejo del Tabernáculo de Reunión: llevarán los marcos del Tabernáculo con sus travesaños, postes y soportes, ");
INSERT INTO spavbl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","los postes del patio circundante con sus soportes, estacas y cuerdas, todo su equipo y todo lo relacionado con su uso. Debes decirles por su nombre lo que cada uno debe llevar. ");
INSERT INTO spavbl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Estas son sus responsabilidades por todo su trabajo en el traslado del Tabernáculo de Reunión, realizado bajo la dirección de Itamar, hijo del sacerdote Aarón”. ");
INSERT INTO spavbl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moisés, Aarón y los líderes israelitas registraron a las familias de Coat según el linaje de su familia y de su padre. ");
INSERT INTO spavbl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Contaban a los hombres de treinta a cincuenta años que tenían derecho a hacer el trabajo de servir en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","El total por familias fue de 2.750. ");
INSERT INTO spavbl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Este fue el total de las familias de Coat, y eran todos los que tenían derecho a hacer el trabajo de servir en el Tabernáculo de Reunión. Moisés y Aarón los registraron de acuerdo con las instrucciones que el Señor le dio a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Las familias de Gersón fueron contadas, de acuerdo a su familia y linaje paterno, ");
INSERT INTO spavbl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","hombres de treinta a cincuenta años de edad todos ellos con derecho a hacer el trabajo de servir en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","El total por familias y linaje paterno fue de 2.630. ");
INSERT INTO spavbl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Este fue el total de las familias de Gersón, todos los que tenían derecho a hacer el trabajo de servir en el Tabernáculo de Reunión. Fueron registrados por Moisés y Aarón de acuerdo con las instrucciones del Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Las familias de Merari fueron contadas, según el linaje familiar y paterno, ");
INSERT INTO spavbl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","hombres de treinta a cincuenta años de edad, todos ellos con derecho a realizar el trabajo de servir en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","El total por familias fue de 3.200. ");
INSERT INTO spavbl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Este fue el total de las familias de Merari registradas por Moisés y Aarón de acuerdo con las instrucciones del Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Así es como Moisés, Aarón y los líderes israelitas registraron a todos los levitas de acuerdo a su familia y linaje paterno. ");
INSERT INTO spavbl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Contarona los hombres de treinta a cincuenta años que tenían derecho a hacer el trabajo de servir en el Tabernáculo de Reunión y llevarlo. ");
INSERT INTO spavbl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","La suma total fue de 8.580. ");
INSERT INTO spavbl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Fue en respuesta a las instrucciones del Señor que fueron registrados por Moisés. A cada uno de los inscritos se les dijo qué hacer y qué llevar, tal como el Señor se lo había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ordena a los israelitas que expulsen del campamento a cualquiera que tenga una enfermedad de la piel, o que tenga una secreción, o que esté sucio por tocar un cuerpo muerto. ");
INSERT INTO spavbl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ya sea hombre o mujer, debes expulsarlos para que no ensucien su campamento, porque ahí es donde yo habito con ellos”. ");
INSERT INTO spavbl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Los israelitas siguieron estas instrucciones y expulsaron a esas personas del campamento. Hicieron lo que el Señor le había dicho a Moisés que debían hacer. ");
INSERT INTO spavbl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Dile a los israelitas que cuando un hombre o una mujer es infiel al Señor pecando contra alguien más, son culpables ");
INSERT INTO spavbl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","y deben confesar su pecado. Tienen que pagar el monto total de la compensación más un quinto de su valor, y darlo a la persona a la que han agraviado. ");
INSERT INTO spavbl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Sin embargo, si esa persona no tiene un pariente que pueda recibir la compensación, ésta le pertenece al Señor y será entregada al sacerdote, junto con un carnero de sacrificio con el que se justifica al culpable. ");
INSERT INTO spavbl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Todas las ofrendas sagradas que los israelitas traigan al sacerdote, le pertenecen a él. ");
INSERT INTO spavbl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Sus santas ofrendas les pertenecen, pero una vez que se las dan al sacerdote, le pertenecen a él”. ");
INSERT INTO spavbl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Dile a los israelitas que estas son las instrucciones a seguir en caso de que la esposa de un hombre tenga una aventura amorosa, siéndole infiel a él ");
INSERT INTO spavbl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","por acostarse con otra persona. Puede ser que su marido no se entere y que su acto sucio no haya sido presenciado. No la atraparon. ");
INSERT INTO spavbl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Pero si su marido se pone celoso y sospecha de su mujer, sea culpable o no, ");
INSERT INTO spavbl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","debe llevarla ante el sacerdote. También debe llevar en su nombre una ofrenda de un décimo de efa de harina de cebada. También debe llevar para ella una ofrenda de un efa de harina de cebada. No debe verter aceite de oliva o poner incienso sobre ella, ya que es una ofrenda de grano por los celos, una ofrenda recordatoria para recordarle a las personas sobre el pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“El sacerdote debe guiar a la esposa hacia adelante y hacer que se presente ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Luego llenará una vasija de barro con agua sagrada y rociará sobre ella polvo del suelo del Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Una vez que el sacerdote haya hecho que la mujer se ponga de pie ante el Señor, le soltará el pelo y le hará sostener la ofrenda de grano recordatoria, la ofrenda de grano que se usa en casos de celos. El sacerdote sostendrá el agua amarga que maldice. ");
INSERT INTO spavbl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Pondrá a la mujer bajo juramento y le dirá: ‘Si nadie más ha dormido contigo y no has sido infiel ni te has vuelto impura mientras estabas casada con tu marido, que no te perjudique esta agua amarga que maldice. ");
INSERT INTO spavbl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pero si has sido infiel mientras estabas casada con tu marido y te has vuelto impura y has tenido relaciones sexuales con otra persona...’”. ");
INSERT INTO spavbl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(Aquí el sacerdote pondrá a la mujer bajo juramento de la maldición como sigue). “Que el Señor te envíe una maldición que todo el mundo conoce, haciendo que tus muslos se encojan y tu vientre se hinche. ");
INSERT INTO spavbl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Que esta agua que maldice entre en tu estómago y haga que tu vientre se hinche y tus muslos se encojan. “La mujer debe responder: ‘De acuerdo, estoy de acuerdo’. ");
INSERT INTO spavbl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“El sacerdote debe escribir estas maldiciones en un pergamino y luego lavarlas en el agua amarga. ");
INSERT INTO spavbl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Hará que la mujer beba el agua amarga que maldice, y le causará un dolor amargo si es culpable. ");
INSERT INTO spavbl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","El sacerdote le quitará la ofrenda de grano por los celos, la agitará ante el Señor y la llevará al altar. ");
INSERT INTO spavbl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Entonces el sacerdote tomará un puñado de la ofrenda de grano como porción de recuerdo y lo quemará en el altar, y hará que la mujer beba el agua. ");
INSERT INTO spavbl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","“Después de hacerla beber el agua, si ella se ha hecho impura y ha sido infiel a su marido, entonces el agua que maldice le causará un dolor amargo. Su vientre se hinchará y sus muslos se encogerán. Se convertirá en una mujer maldita entre su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pero si la mujer no se ha hecho impura por ser infiel y está limpia, no experimentará este castigo y aún podrá tener hijos. ");
INSERT INTO spavbl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Esta es la regla a seguir en casos de celos cuando una mujer tiene una aventura y se hace impura mientras está casada con su marido, ");
INSERT INTO spavbl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","o cuando el marido empieza a sentir celos y sospecha de su esposa. Su esposa deberá presentarse ante el Señor, y el sacerdote deberá cumplir cada parte de esta regla. ");
INSERT INTO spavbl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Si es hallada culpable, su marido no será responsable. Pero la mujer cargará con las consecuencias de su pecado”. ");
INSERT INTO spavbl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Dile a los israelitas: Si un hombre o una mujer hace una promesa especial de convertirse en nazareo, para dedicarse al Señor, ");
INSERT INTO spavbl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","no deben beber vino u otra bebida alcohólica. No deben ni siquiera beber vinagre de vino o cualquier otra bebida alcohólica, o cualquier jugo de uva o comer uvas o pasas. ");
INSERT INTO spavbl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Durante todo el tiempo que estén dedicados al Señor no deben comer nadaque sea fruto de una vid, ni siquiera las semillas o las cáscaras de uva. ");
INSERT INTO spavbl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“No deben usar una navaja de afeitar sobre sus cabezas durante todo el tiempo de esta promesa de dedicación. Deben permanecer santos hasta que su tiempo de dedicación al Señor haya terminado. Deben dejar crecer su cabello. ");
INSERT INTO spavbl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“Durante este tiempo de dedicación al Señor no deben acercarse a un cadáver. ");
INSERT INTO spavbl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Incluso si es su padre, madre, hermano o hermana los que han muerto, no deben ensuciarse, porque su pelo sin cortar anuncia su dedicación a Dios. ");
INSERT INTO spavbl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Durante todo el tiempo de su dedicación deben ser santos para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Sin embargo, si alguien muere repentinamente cerca de ellos, convirtiéndolos en inmundos, deben esperar siete días, y al séptimo día cuando se limpien de nuevo deben afeitarse la cabeza. ");
INSERT INTO spavbl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","El octavo día llevarán dos tórtolas o dos pichones al sacerdote que está a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","El sacerdote ofrecerá una como ofrenda por el pecado y la otra como holocausto para corregirlas, porque se hicieron culpables por estar cerca del cadáver. Ese día deben volver a dedicarse y dejar que les vuelva a crecer el cabello. ");
INSERT INTO spavbl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Deben volver a dedicarse al Señor por el tiempo completo que prometieron originalmente y traer un cordero macho de un año como ofrenda por la culpa. Los días anteriores no cuentan para el tiempo de dedicación porque se volvieron inmundos. ");
INSERT INTO spavbl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Estas son las reglas que se deben observar cuando el tiempo de dedicación del nazareo termine. Deben ser llevadas a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Allí deben presentar una ofrenda al Señor de un cordero macho sin defectos de un año como holocausto, un cordero hembra sin defectos de un año como ofrenda por el pecado y un carnero sin defectos como ofrenda de paz. ");
INSERT INTO spavbl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Además deben traer una cesta de pan sin levadura hecha de la mejor harina mezclada con aceite de oliva y obleas sin levadura recubiertas con aceite de oliva así como sus ofrendas de granos y bebidas. ");
INSERT INTO spavbl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","El sacerdote presentará todo esto ante el Señor, así como el sacrificio de la ofrenda por el pecado y el holocausto. ");
INSERT INTO spavbl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","También sacrificará un carnero como ofrenda de paz al Señor, junto con la cesta de pan sin levadura. Además el sacerdote presentará la ofrenda de grano y la ofrenda de bebida. ");
INSERT INTO spavbl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Luego los nazareos se afeitarán la cabeza a la entrada del Tabernáculo de Reunión. Se quitarán el cabello de sus cabezas que fueron dedicadas, y lo pondrán en el fuego bajo la ofrenda de paz. ");
INSERT INTO spavbl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Una vez que los nazareos se hayan afeitado, el sacerdote tomará la espaldilla hervida del carnero, un pan sin levadura de la cesta, y una oblea sin levadura, y los pondrá en sus manos. ");
INSERT INTO spavbl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","El sacerdote los agitará como ofrenda mecida ante el Señor. Estos artículos son sagrados y pertenecen al sacerdote, así como el pecho de la ofrenda mecida y el muslo que fue ofrecido. Una vez que esto termine, los nazareos podrán beber vino. ");
INSERT INTO spavbl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Estas son las reglas que deben observarse cuando un nazareo promete dar ofrendas al Señor en relación con su dedicación. También pueden traer ofrendas adicionales si tienen los medios para hacerlo. Cada nazareo debe cumplir las promesas que ha hecho cuando se dedica”. ");
INSERT INTO spavbl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Dile a Aarón y a sus hijos: Así es como debes bendecir a los israelitas. Esto es lo que deben decir: ");
INSERT INTO spavbl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“‘Que el Señor te bendiga y te cuide. ");
INSERT INTO spavbl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Que el Señor te sonría y sea misericordioso contigo. ");
INSERT INTO spavbl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Que el Señor te cuide y te dé la paz’. ");
INSERT INTO spavbl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Cuando los sacerdotes bendigan a los israelitas en mi nombre, yo los bendeciré”. ");
INSERT INTO spavbl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","El mismo día que Moisés terminó de montar el Tabernáculo, lo ungió y lo dedicó, junto con todo su mobiliario, el altar y todos sus utensilios. ");
INSERT INTO spavbl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Los líderes israelitas, que eran los jefes de sus familias, vinieron y dieron una ofrenda. Eran los mismos líderes de las tribus que habían trabajado en el registro de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Trajeron al Señor una ofrenda de seis carros cubiertos y doce bueyes. Cada líder dio un buey, y dos líderes compartieron la ofrenda de un carro. Los presentaron frente al Tabernáculo. ");
INSERT INTO spavbl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Acepta lo que te dan y úsalo para el trabajo del Tabernáculo de Reunión. Dáselo a los levitas para que los usen según sea necesario”. ");
INSERT INTO spavbl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moisés aceptó las carretas y los bueyes y los entregó a los levitas. ");
INSERT INTO spavbl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dio dos carros y cuatro bueyes a las familias de Gersón para que los usaran según sus necesidades. ");
INSERT INTO spavbl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Dio cuatro carros y ocho bueyes a las familias de Merari, para que los usaran según sus necesidades. Todo el trabajo debía hacerse bajo la dirección de Itamar, hijo del sacerdote Aarón. ");
INSERT INTO spavbl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","No dio carros ni bueyes a los coatitas porque su responsabilidad era llevar sobre sus hombros los objetos sagrados asignados bajo su cuidado. ");
INSERT INTO spavbl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","El día que el altar fue ungido, los líderes se presentaron con sus ofrendas dedicatorias, presentándolas delante de él. ");
INSERT INTO spavbl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Entonces el Señor le dijo a Moisés: “Haz que un líder venga cada día y presente su ofrenda para la dedicación del altar”. ");
INSERT INTO spavbl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","El primer día Naasón, hijo de Aminadab, de la tribu de Judá se adelantó con su ofrenda. ");
INSERT INTO spavbl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Su ofrenda era una placa de plata que pesaba ciento treinta siclos, y un tazón de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y cinco corderos macho de un año. Esta fue la ofrenda de Naasón, hijo de Aminadab. ");
INSERT INTO spavbl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","El segundo día se presentó Natanael, hijo de Zuar, el líder de la tribu de Isacar. ");
INSERT INTO spavbl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un tazón de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Natanael, hijo de Zuar. ");
INSERT INTO spavbl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","El tercer día se presentó Eliab, hijo de Helón, el líder de la tribu de Zabulón. ");
INSERT INTO spavbl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un cuenco de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Eliab, hijo de Helón. ");
INSERT INTO spavbl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","El cuarto día se presentó Elisur, hijo de Sedeúr, el líder de la tribu de Rubén. ");
INSERT INTO spavbl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un cuenco de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Elisur, hijo de Sedeúr. ");
INSERT INTO spavbl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","El quinto día se presentó Selumiel, hijo de Zurisadai, el líder de la tribu de Simeón. ");
INSERT INTO spavbl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un cuenco de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Selumiel, hijo de Zurisadai. ");
INSERT INTO spavbl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","El sexto día se presentó Eliasaf, hijo de Deuel, el líder de la tribu de Gad. ");
INSERT INTO spavbl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un cuenco de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Eliasaf, hijo de Deuel. ");
INSERT INTO spavbl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","El séptimo día se presentó Elisama, hijo de Ammihud, el líder de la tribu de Efraín. ");
INSERT INTO spavbl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un tazón de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Elishama, hijo de Amiúd. ");
INSERT INTO spavbl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","El octavo día se presentó Gamaliel, hijo de Pedasur, el líder de la tribu de Manasés. ");
INSERT INTO spavbl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un tazón de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Gamaliel, hijo de Pedasur. ");
INSERT INTO spavbl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","El noveno día se presentó Abidán, hijo de Gideoni, el líder de la tribu de Benjamín. ");
INSERT INTO spavbl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un tazón de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Abidán, hijo de Gedeoni. ");
INSERT INTO spavbl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","El décimo día se presentó Ahiezer, hijo de Amisadai, el líder de la tribu de Dan. ");
INSERT INTO spavbl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un tazón de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta era la ofrenda de Ahiezer, hijo de Amisadai. ");
INSERT INTO spavbl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","El undécimo día se presentó Pagiel, hijo de Ocrán, el líder de la tribu de Aser. ");
INSERT INTO spavbl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un cuenco de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta era la ofrenda de Pagiel, hijo de Ocran. ");
INSERT INTO spavbl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","El duodécimo día se presentó Ahira, hijo de Enán, el jefe de la tribu de Neftalí. ");
INSERT INTO spavbl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","La ofrenda que presentó fue una placa de plata que pesaba ciento treinta siclos, y un cuenco de plata que pesaba setenta siclos, (usando la tasación del siclo según el santuario). Ambos estaban llenos de la mejor harina mezclada con aceite de oliva como ofrenda de grano. ");
INSERT INTO spavbl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","También presentó un plato de oro que pesaba diez siclos llenos de incienso. Como sacrificios trajo ");
INSERT INTO spavbl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","un novillo, un carnero y un cordero macho de un año como holocausto, ");
INSERT INTO spavbl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","una cabra macho como ofrenda por el pecado, ");
INSERT INTO spavbl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","y una ofrenda de paz de dos bueyes, cinco carneros, cinco cabras macho, y corderos macho de cinco años. Esta fue la ofrenda de Ahira, hijo de Enan. ");
INSERT INTO spavbl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Así que el día en que el altar fue ungido, las ofrendas dedicatorias traídas por los líderes israelitas fueron doce platos de plata, doce cuencos de plata y doce platos de oro. ");
INSERT INTO spavbl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Cada plato de plata pesaba ciento treinta siclos, y cada cuenco pesaba setenta siclos. El peso total de la plata era de dos mil cuatrocientos siclos, (usando la tasación del siclo según el santuario). ");
INSERT INTO spavbl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Los doce platos de oro llenos de incienso pesaban diez siclos cada uno, (usando la tasación del siclo según el santuario). El peso total del oro era de ciento veinte siclos. ");
INSERT INTO spavbl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Los animales presentados como holocausto eran doce toros, doce carneros y doce corderos machos de un año, así como sus ofrendas de grano, y doce cabras machos como ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Los animales presentados como ofrenda de paz eran veinticuatro toros, sesenta carneros, sesenta machos cabríos y sesenta corderos machos de un año. Esta era la ofrenda de dedicación para el altar una vez que había sido ungido. ");
INSERT INTO spavbl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Cada vez que Moisés entraba en el Tabernáculo de Reunión para hablar con el Señor, oía la voz que le hablaba desde la tapa de expiación del Arca del Testimonio entre los dos querubines. Así es como el Señor le habló. ");
INSERT INTO spavbl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Dile a Aarón, ‘Cuando pongas las siete lámparas en el candelabro, asegúrate de que brillen hacia el frente’”. ");
INSERT INTO spavbl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Así que eso es lo que hizo Aarón. Colocó las lámparas hacia el frente del candelabro, como el Señor le había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","El candelabro estaba hecho de oro martillado desde su base hasta los adornos florales de la parte superior, de acuerdo con el diseño que el Señor había mostrado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Separa a los levitas de los demás israelitas y purifícalos. ");
INSERT INTO spavbl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Los purificarás así: Rocíalos con el agua de la purificación. Deben afeitarse todo el pelo de sus cuerpos y lavar su ropa para que estén limpios. ");
INSERT INTO spavbl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Haz que traigan un novillo con su ofrenda de grano de la mejor harina mezclada con aceite de oliva, y debes traer un segundo novillo como ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Toma a los levitas y haz que se paren frente al Tabernáculo de Reunión y llama a todos los israelitas para que se reúnan allí. ");
INSERT INTO spavbl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Cuando lleves a los levitas al Señor, los israelitas pondrán sus manos sobre ellos. ");
INSERT INTO spavbl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aarón presentará a los levitas a Jehová como ofrenda agitada de los israelitas para que hagan la obra de Jehová. ");
INSERT INTO spavbl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Los levitas pondrán sus manos sobre las cabezas de los toros. Uno será sacrificado como ofrenda por el pecado al Señor, y el otro como holocausto para reconciliar a los levitas con el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Que los levitas se pongan de pie delante de Aarón y sus hijos y los presenten al Señor como ofrenda de ofrenda. ");
INSERT INTO spavbl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Así separarás a los levitas del resto de los israelitas, y los levitas me pertenecerán a mí. ");
INSERT INTO spavbl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Pueden venir a servir en el Tabernáculo de Reunión una vez que los hayas purificado y presentado como ofrenda mecida. ");
INSERT INTO spavbl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","“Los levitas han sido completamente consagrados a mí por los israelitas. Los he aceptado como míos en lugar de todos los primogénitos de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Todo primogénito varón de Israel me pertenece, tanto humano como animal. Los reservé para mí cuando maté a todos los primogénitos de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","He tomado a los levitas en lugar de todos los primogénitos de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","De todos los israelitas, los levitas son un regalo mío para Aarón y sus hijos para servir a los israelitas en el Tabernáculo de Reunión, y en su nombre para enderezarlos, para que no les pase nada malo cuando vengan al santuario”. ");
INSERT INTO spavbl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moisés, Aarón y todos los israelitas hicieron todo lo que el Señor había ordenado a Moisés que hicieran con respecto a los levitas. ");
INSERT INTO spavbl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Los levitas se purificaron y lavaron sus ropas. Entonces Aarón los presentó como ofrenda mecida al Señor. Aarón también presentó el sacrificio para que estuvieran bien con el Señor para que estuvieran limpios. ");
INSERT INTO spavbl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Después los levitas vinieron a realizar su servicio en el Tabernáculo de Reunión bajo la dirección de Aarón y sus hijos. Siguieron todas las instrucciones sobre los levitas que el Señor había dado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Esta regla se aplica a los levitas. Los mayores de veinticinco años servirán en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Sin embargo, una vez que alcancen la edad de cincuenta años deben retirarse del trabajo y no servirán más. ");
INSERT INTO spavbl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Todavía pueden ayudar a sus compañeros levitas en sus tareas, pero no deben hacer el trabajo por sí mismos. Estos son los arreglos en el caso de los levitas”. ");
INSERT INTO spavbl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","El Señor le habló a Moisés en el desierto del Sinaí en el primer mes, dos años después de que Israel dejara Egipto. Le dijo: ");
INSERT INTO spavbl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Los israelitas deben celebrar la Pascua en el momento designado. ");
INSERT INTO spavbl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","La observarán a la hora requerida, en la tarde después de la puesta del sol del día catorce de este mes, y lo harán de acuerdo con sus reglas y normas”. ");
INSERT INTO spavbl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moisés hizo un llamado a los israelitas para que observaran la Pascua. ");
INSERT INTO spavbl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Así que celebraron la Pascua en el desierto del Sinaí, comenzando por la tarde después de la puesta del sol del día catorce del primer mes. Los israelitas siguieron todas las instrucciones que el Señor había dado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Sin embargo, había algunos hombres que eran impuros porque habían estado en contacto con un cadáver, por lo que no podían celebrar la Pascua ese día. Fueron a ver a Moisés y Aarón el mismo día ");
INSERT INTO spavbl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","y le explicaron a Moisés: “Somos inmundos por causa de un cadáver, ¿pero por qué eso significa que no podemos dar nuestra ofrenda al Señor con los demás israelitas en el momento oportuno?” ");
INSERT INTO spavbl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","“Quédense aquí mientras averiguo cuáles son las instrucciones del Señor respecto a ustedes”, respondió Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Dile a los israelitas: ‘Si tú o tus descendientes están sucios por causa de un cadáver, o están viajando, aún pueden celebrar la Pascua del Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","La observarán por la tarde, después de la puesta del sol, en el día catorce del segundo mes. Comerán el cordero con el pan sin levadura y las hierbas amargas. ");
INSERT INTO spavbl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","No deben dejar nada de él hasta la mañana siguiente y no deben romper ninguno de sus huesos. Deberán observar la Pascua de acuerdo con todas las normas. ");
INSERT INTO spavbl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Sin embargo, cualquiera que esté ceremonialmente limpio y no viaje lejos y que no observe la Pascua debe ser expulsado de su pueblo, porque no presentó la ofrenda del Señor en el momento apropiado. Ellos serán responsables de las consecuencias de su pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Cualquier extranjero que viva entre ustedes y que quiera observar la Pascua del Señor puede hacerlo siguiendo las normas y preceptos de la Pascua. Las mismas reglas se aplican a los extranjeros como a ustedes’”. ");
INSERT INTO spavbl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","La nube cubrió la Tienda del Testimonio (el Tabernáculo) el día en que fue erigida, y se vio como fuego sobre ella desde la noche hasta la mañana. ");
INSERT INTO spavbl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Siempre era así. La nube cubría el Tabernáculo durante el día y por la noche parecía fuego. ");
INSERT INTO spavbl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Cuando la nube se levantaba sobre la Tienda, los israelitas marchaban, y cuando la nube se detenía, los israelitas acampaban allí. ");
INSERT INTO spavbl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Los israelitas se movían cuando el Señor les decía, y levantaban el campamento cuando el Señor les decía. Mientras la nube permanecía sobre el Tabernáculo, ellos permanecían acampados allí. ");
INSERT INTO spavbl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Aunque la nube no se moviera durante mucho tiempo, los israelitas hicieron lo que el Señor les decía y no seguían adelante. ");
INSERT INTO spavbl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","A veces la nube sólo permanecía sobre el Tabernáculo durante unos pocos días. Como siempre, siguieron la orden del Señor de acampar o seguir adelante. ");
INSERT INTO spavbl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","A veces la nube sólo se quedaba durante la noche, así que cuando se levantaban por la mañana seguían avanzando. Cada vez que la nube se levantaba, de día o de noche, se marchaban. ");
INSERT INTO spavbl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Si la nube se quedaba en un lugar durante dos días, o un mes, o más tiempo, los israelitas se quedaban donde estaban y no se iban mientras la nube permaneciera sobre el Tabernáculo. Sin embargo, una vez que se levantaba, se iban. ");
INSERT INTO spavbl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Acampaban cuando el Señor les decía, y se iban cuando él les decía. Ellos seguían las instrucciones del Señor le daba a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Haz dos trompetas de plata martillada. Se usarán para convocar a los israelitas y para hacer que el campamento se mueva. ");
INSERT INTO spavbl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Cuando se toquen las dos trompetas, todos los israelitas se reunirán ante ti en la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Pero si sólo se toca una, sólo los líderes de la tribu se reunirán ante ti. ");
INSERT INTO spavbl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“Cuando se toque la trompeta, que es la señal de alarma para salir, los campamentos del lado este deben salir primero. ");
INSERT INTO spavbl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Cuando se toca la trompeta por segunda vez, los campamentos del lado sur deben marchar. Esa es su señal para empezar a moverse. ");
INSERT INTO spavbl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Para convocar a la gente, soplen las trompetas normalmente, no la señal de alarma fuerte. ");
INSERT INTO spavbl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Los descendientes de Aarón deben tocar las trompetas. Esta regulación seguirá vigente en todos los tiempos y para todas las generaciones futuras. ");
INSERT INTO spavbl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Cuando estés en tu propia tierra y tengas que ir a la batalla contra un enemigo que te haya atacado, toca la señal de alarma y el Señor tu Dios no te olvidará: te salvará de tus enemigos. ");
INSERT INTO spavbl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Toquen las trompetas cuando celebren también, en sus fiestas regulares y al principio de cada mes. Es decir, cuando traigas tus holocaustos y tus ofrendas de comunión que serán como un recordatorio para ti ante tu Dios. Yo soy el Señor tu Dios”. ");
INSERT INTO spavbl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Entonces la nube se levantó del Tabernáculo del Testimonio el vigésimo día del segundo mes del segundo año. ");
INSERT INTO spavbl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Los israelitas abandonaron el desierto del Sinaí y se desplazaron de un lugar a otro hasta que la nube se detuvo en el desierto de Parán. ");
INSERT INTO spavbl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Esta fue la primera vez que salieron siguiendo el mandato del Señor a través de Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Las divisiones de la tribu de Judá fueron las primeras en marchar bajo su bandera, con Naasón, hijo de Aminadab, al mando. ");
INSERT INTO spavbl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Natanael, hijo de Zuar, estaba a cargo de la tribu de Isacar, ");
INSERT INTO spavbl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","y Eliab, hijo de Helón, estaba a cargo de la división tribal de Zabulón. ");
INSERT INTO spavbl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Entonces el Tabernáculo fue desmontado, y los guersonitas y los meraritas que lo llevaban se pusieron en marcha. ");
INSERT INTO spavbl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Luego vinieron las divisiones de la tribu de Rubén, quienes marcharon bajo su bandera, con Elisur, hijo de Sedeur, a cargo. ");
INSERT INTO spavbl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Selumiel, hijo de Zurishaddai, estaba a cargo de la tribu de Simeón, ");
INSERT INTO spavbl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","y Eliasaf, hijo de Deuel, estaba a cargo de la tribu de Gad. ");
INSERT INTO spavbl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Entonces los coatitas se pusieron en marcha, llevando los objetos sagrados. El tabernáculo se colocaría antes de que llegaran. ");
INSERT INTO spavbl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Luego vinieron las divisiones de la tribu de Efraín, y marcharon bajo su bandera, con Elisama, hijo de Amihud a cargo. ");
INSERT INTO spavbl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel, hijo de Pedasur, estaba a cargo de la tribu de Manasés, ");
INSERT INTO spavbl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","y Abidán, hijo de Gedeón, estaba a cargo de la tribu de Benjamín. ");
INSERT INTO spavbl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Finalmente llegaron las divisiones de Dan que marcharon bajo su bandera, defendiendo la retaguardia de todos los grupos tribales, con Ahiezer, hijo de Amisadai, a cargo. ");
INSERT INTO spavbl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel, hijo de Ocrán, estaba a cargo de la tribu de Aser, ");
INSERT INTO spavbl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","y Ajirá, hijo de Enán, estaba a cargo de la tribu de Neftalí. ");
INSERT INTO spavbl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Este era el orden en el se desplazaban las tribus de Israel. ");
INSERT INTO spavbl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moisés le explicó a Hobab, el hijo del suegro de Moisés, Reuel, el madianita, “Nos vamos al lugar que el Señor prometió diciendo: ‘Te daré esta tierra’. Ven con nosotros y seremos buenos contigo, porque el Señor le ha prometido cosas buenas a Israel”. ");
INSERT INTO spavbl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","“No, no me iré, volveré a mi país y a mi pueblo”, respondió Hobab. ");
INSERT INTO spavbl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","“Por favor, no nos abandones ahora”, le dijo Moisés, “porque tú eres el único que sabe dónde debemos acampar en el desierto y puedes guiarnos. ");
INSERT INTO spavbl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Si vienes con nosotros, todo lo bueno que el Señor nos de como bendición lo compartiremos contigo”. ");
INSERT INTO spavbl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Se fueron de la montaña del Señor para hacer un viaje de tres días, y El Arca del Pacto del Señor les mostró el camino durante estos tres días para encontrar un lugar para acampar. ");
INSERT INTO spavbl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","La nube del Señor estuvo sobre ellos durante el día mientras se alejaban del campamento. ");
INSERT INTO spavbl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Cada vez que el Arca avanzaba, Moisés gritaba: “Levántate, Señor, y que tus enemigos se dispersen, y que los que te odian huyan de ti”. ");
INSERT INTO spavbl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Cada vez que se detenía, Moisés gritaba: “Vuelve, Señor, a los miles y miles del pueblo de Israel”. ");
INSERT INTO spavbl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","No pasó mucho tiempo antes de que la gente empezara a quejarse de lo mucho que estaban sufriendo. Cuando el Señor escuchó lo que decían, se enfadó. El fuego del Señor los quemó, destruyendo algunos que iban por los extremos del campamento. ");
INSERT INTO spavbl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","El pueblo clamó a Moisés por ayuda. Entones él oró al Señor y el fuego se apagó. ");
INSERT INTO spavbl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ese lugar se llamó Taberá, porque el fuego del Señor los quemó. ");
INSERT INTO spavbl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Entonces un grupo de alborotadores que estaba entre ellos tenían antojos de comida tan intensos que afectaron a los israelitas que empezaron a llorar de nuevo, preguntando “¿Quién va a conseguirnos algo de carne para comer? ");
INSERT INTO spavbl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Recuerden todo el pescado que comíamos en Egipto y que no nos costaba nada, así como los pepinos, los melones, los puerros, las cebollas y el ajo. ");
INSERT INTO spavbl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","¡Pero ahora nos estamos desvaneciendo aquí! ¡Lo único que vemos es este maná!” ");
INSERT INTO spavbl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","El maná tenía la apariencia de semillas de cilantro, de color claro como la resina. ");
INSERT INTO spavbl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","El pueblo salía a recogerlo, lo molíancon un molino o lo trituraban en un mortero; luego lo hervirían en una olla y lo convertirían en pan plano. EL sabor era como de pasteles hechos con el mejor aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Cuando el rocío descendíasobre el campamento por la noche, el maná bajaba con él. ");
INSERT INTO spavbl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moisés escuchó a todas las familias llorando a la entrada de sus tiendas. El Señor se enfadó mucho, y Moisés también se enfadó. ");
INSERT INTO spavbl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Le preguntó al Señor: “¿Por qué me has puesto las cosas tan difíciles a mí, tu siervo? ¿Por qué estás tan descontento conmigo que me has puesto la pesada responsabilidad de toda esta gente? ");
INSERT INTO spavbl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","¿Acaso son mis hijos? ¿Los di a luz para que me dijeras: ‘Sujétalos en tu pecho como una nodriza que lleva un bebé’ y luego tener que llevarlos a la tierra que les prometiste a sus antepasados? ");
INSERT INTO spavbl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","¿De dónde se supone que voy a sacar carne para todos ellos? Se siguen quejando de mí, ‘¡Consíguenos algo de carne para comer!’ ");
INSERT INTO spavbl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","No puedo seguir soportando a todo este pueblo yo solo. ¡Es demasiado! ");
INSERT INTO spavbl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Si esta es la forma en que me vas a tratar, entonces por favor mátame ahora para no tener que enfrentarme a esta depresión que me abruma. Por favor, concédeme esta petición”. ");
INSERT INTO spavbl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Entonces el Señor le dijo a Moisés: “Trae ante mí setenta ancianos israelitas que sepas que son respetados como líderes por el pueblo. Llévalos al Tabernáculo de Reunión. Se quedarán allí contigo. ");
INSERT INTO spavbl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Yo bajaré y hablaré contigo allí. Tomaré un poco del Espíritu que tienes y se lo daré. Ellos tomarán parte de la responsabilidad del pueblo para que no tengas que soportarlo todo tú solo. ");
INSERT INTO spavbl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Dile al pueblo: Purifíquense, porque mañana tendrán carne para comer, pues se han quejado y el Señor ha oído su petición: ‘¿Quién nos va a dar carne para comer? Estábamos mejor en Egipto’. Así que el Señor va a proveerles carne para comer. ");
INSERT INTO spavbl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","La comerán, no sólo por un día o dos, ni por cinco, diez o veinte días. ");
INSERT INTO spavbl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","La comerán durante un mes entero hasta que vomiten y les salga por las narices, porque han rechazado al Señor, que está aquí con ustedes, y se han quejado de él diciendo: ‘¿Por qué se nos ocurrió salir de Egipto?’” ");
INSERT INTO spavbl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Pero Moisés respondió: “Estoy aquí con 600.000 personas y me dices: ‘Les voy a dar carne y la comerán durante un mes’? ");
INSERT INTO spavbl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ún si todos nuestros rebaños y manadas fueran sacrificados, no sería suficiente para ellos. Incluso si todos los peces del mar fueran capturados, ¡no sería suficiente para todos ellos!” ");
INSERT INTO spavbl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","“¿No tiene el Señor el poder de hacer eso?” , respondió el Señor. “¡Ahora vas a ver con tus ojos si lo que he dicho sucederá o no!” ");
INSERT INTO spavbl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Entonces Moisés fue y compartió con el pueblo lo que el Señor dijo. Convocó a setenta ancianos del pueblo y los hizo ponerse de pie alrededor de la tienda. ");
INSERT INTO spavbl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Entonces el Señor descendió y le habló. El Señor tomó algo del Espíritu que Moisés tenía y se lo dio. Ellos profetizaron, pero esto no volvió a suceder. ");
INSERT INTO spavbl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Sin embargo, dos hombres llamados Eldad y Medad se habían quedado en el campamento, y el Espíritu vino sobre ellos también. (Habían sido puestos en la lista de los setenta ancianos, pero no habían ido a la tienda. Pero profetizaron donde estaban en el campamento de todos modos). ");
INSERT INTO spavbl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Un joven corrió y le dijo a Moisés: “Eldad y Medad están profetizando en el campamento”. ");
INSERT INTO spavbl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Josué, hijo de Nun, que había sido asistente de Moisés desde joven, reaccionó diciendo: “¡Moisés, mi señor, tienes que detenerlos!” ");
INSERT INTO spavbl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","“¿Estás celoso de mi reputación?” respondió Moisés. “¡Deseo que cada uno en el pueblo del Señor sea profeta y que el Señor les dé su espíritu a todos!” ");
INSERT INTO spavbl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Entonces Moisés volvió al campamento con los ancianos de Israel. ");
INSERT INTO spavbl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","El Señor envió un viento que sopló codornices desde el mar y las hizo caer cerca del campamento. Cubrieron el suelo hasta una profundidad de unos dos codos y se extendieron durante un día de viaje en todas direcciones del campamento. ");
INSERT INTO spavbl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Durante todo ese día y noche, y durante todo el día siguiente, el pueblo siguió recogiendo codornices. Todos recolectaron al menos diez homers, y las repartieron por todo el campamento. ");
INSERT INTO spavbl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Pero mientras la gente seguía mordiendo la carne, incluso antes de que la masticaran, el Señor mostró su ardiente ira contra ellos, matando a algunos de ellos con una grave enfermedad. ");
INSERT INTO spavbl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Llamaron a ese lugar Quibrot-Hatavá, porque allí enterraron a la gente que tenía estos intensos antojos de comida. ");
INSERT INTO spavbl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Luego se trasladaron de Quibrot-Hataváhacia Jazerot, donde permanecieron durante algún tiempo. ");
INSERT INTO spavbl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Pero Miriam y Aarón criticaban a Moisés por su esposa, pues Moisés se había casado con una mujer etíope. ");
INSERT INTO spavbl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“¿Acaso el Señor solo habla a través de Moisés?” , cuestionaban. “¿No habla también a través de nosotros?” Y el Señor escuchó todo esto. ");
INSERT INTO spavbl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Moisés era un hombre muy humilde, más que nadie en la tierra. ");
INSERT INTO spavbl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","De repente el Señor llamó a Moisés, Aarón y Miriam, diciéndoles: “Ustedes tres, vengan al Tabernáculo de Reunión”.Y los tres lo hicieron. ");
INSERT INTO spavbl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","El Señor bajó en una columna de nube y se paró en la entrada de la Tienda. Llamó a Aarón y a Miriam y ellos se adelantaron. ");
INSERT INTO spavbl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","“Escuchen mis palabras, les dijo. Si tuvieran profetas, yo, el Señor, me revelaría a ellos en visiones; me comunicaría con ellos en sueños. ");
INSERT INTO spavbl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Pero no es así con mi siervo Moisés, que de todo mi pueblo es el que me es fiel. ");
INSERT INTO spavbl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Yo hablo con él personalmente, cara a cara. Hablo claramente, y no con acertijos. Él ve la semejanza del Señor. Entonces, ¿por qué no tuvieron miedo al criticar a mi siervo Moisés?” ");
INSERT INTO spavbl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Entonces el Señor se enfadó con ellos, y se fue. ");
INSERT INTO spavbl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Cuando la nube se elevó sobre la Tienda, la piel de Miriam se volvió repentinamente blanca por la lepra. Aarón se volvió a mirar y vio que tenía lepra. ");
INSERT INTO spavbl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Le dijo a Moisés: “Señor mío, por favor no nos castigues por este pecado que hemos cometido tan estúpidamente. ");
INSERT INTO spavbl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Por favor, no dejes que me convierta en un moribundo cuya carne ya se está pudriendo cuando nace!” ");
INSERT INTO spavbl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moisés clamó al Señor: “¡Dios, por favor, cúrala!” ");
INSERT INTO spavbl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Pero el Señor le respondió a Moisés: “Si su padre le hubiera escupido en la cara, ¿no habría sido deshonrosa durante siete días? Mantenla aislada fuera del campamento durante siete días, y luego podrá regresar”. ");
INSERT INTO spavbl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam quedó en aislamiento fuera del campamento durante siete días, y el pueblo no avanzó hasta que fue llevada de vuelta. ");
INSERT INTO spavbl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Entonces el pueblo se fue de Jazerot y se instaló en el desierto de Parán. ");
INSERT INTO spavbl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Envía algunos hombres a explorar la tierra de Canaán, el país que le doy a los israelitas. Escoge a uno de los líderes de cada una de las tribus para que vaya y haga esto”. ");
INSERT INTO spavbl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moisés hizo lo que el Señor le había ordenado y envió a los hombres desde el desierto de Parán. Todos ellos eran líderes de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Sus nombres eran: Samúa hijo de Zacur, de la tribu de Rubén. ");
INSERT INTO spavbl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Safat, hijo de Hori, de la tribu de Simeón. ");
INSERT INTO spavbl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Caleb, hijo de Jefone, de la tribu de Judá. ");
INSERT INTO spavbl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igal, hijo de José, de la tribu de Isacar. ");
INSERT INTO spavbl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Oseas, hijo de Nun, de la tribu de Efraín. ");
INSERT INTO spavbl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti hijo de Raphu, de la tribu de Benjamín. ");
INSERT INTO spavbl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gaddiel, hijo de Sodi, de la tribu de Zabulón. ");
INSERT INTO spavbl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gaddi, hijo de Susi, de la tribu de Manasés (una tribu de José). ");
INSERT INTO spavbl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amiel, hijo de Gemalli, de la tribu de Dan. ");
INSERT INTO spavbl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Sethur, hijo de Miguel, de la tribu de Aser. ");
INSERT INTO spavbl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nahbi, hijo de Vophsi, de la tribu de Neftalí. ");
INSERT INTO spavbl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Geuel, hijo de Machi, de la tribu de Gad. ");
INSERT INTO spavbl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Estos eran los nombres de los hombres que Moisés envió a explorar el país. Moisés le puso por nombre Josué a Oseas. ");
INSERT INTO spavbl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moisés los envió a explorar la tierra de Canaán, diciéndoles: “Pasen por el Néguev y entren en las montañas. ");
INSERT INTO spavbl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Vean cómo es el lugar, y averigüen acercade la gente que vive allí, ¿son fuertes o débiles? ¿Son muchos o pocos? ");
INSERT INTO spavbl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","¿La tierra donde viven es buena o mala? ¿Son sus ciudades como campos abiertos, o tienen muros defensivos? ");
INSERT INTO spavbl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","¿Es el suelo productivo o no? ¿Es forestal? Sean valientes y traigan algunos de los frutos del país”. (Era el comienzo de la vendimia). ");
INSERT INTO spavbl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Así que los hombres fueron y exploraron la tierra desde el desierto de Zin hasta Rejob, cerca de Lebó Jamat. ");
INSERT INTO spavbl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Atravesaron el Néguev y llegaron a Hebrón donde vivían Ahiman, Seshai y Talmai, los descendientes de Anac. Esta ciudad fue construida siete años antes que la ciudad egipcia de Zoán. ");
INSERT INTO spavbl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Cuando llegaron al Valle de Escol cortaron una rama que tenía un solo racimo de uvas. Tenían que cargarla en un palo sostenido entre dos hombres. También recogieron algunas granadas e higos. ");
INSERT INTO spavbl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","(El lugar fue llamado el Valle de Escol por el racimo de uvas que tomaron de allí). ");
INSERT INTO spavbl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Cuarenta días después los hombres regresaron de explorar el país. ");
INSERT INTO spavbl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Fueron a ver a Moisés y Aarón, y todos los israelitas se reunieron allí en su campamento en Cades, en el desierto de Parán. Dieron un informe ante todos y les mostraron los frutos que habían traído del país. ");
INSERT INTO spavbl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Este es el informe que dieron a Moisés: “Fuimos y exploramos el país al que nos enviaste, y es definitivamente muy productivo, como si fluyera leche y miel. ¡Miren algunas de sus frutas! ");
INSERT INTO spavbl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Pero la gente que vive allí es fuerte, y sus pueblos son grandes y tienen muros defensivos. También vimos algunos descendientes de Anac allí. ");
INSERT INTO spavbl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Los amalecitas viven en el Néguev. Los hititas, jebuseos y amorreos viven en las colinas. Los cananeos viven en la costa del mar y también al lado del Jordán”. ");
INSERT INTO spavbl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Entonces Caleb pidió silencio mientras la gente se paraba delante de Moisés y les decía: “Vamos a tomar la tierra. Podemos conquistar el país, ¡sin duda!” ");
INSERT INTO spavbl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Pero los hombres que habían ido con él no estaban de acuerdo. “¡No podemos ir a luchar contra este pueblo! ¡Son mucho más fuertes que nosotros!” ");
INSERT INTO spavbl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","difundieron un informe negativo entre los israelitas sobre el país que habían explorado. Le dijeron al pueblo: “El país que exploramos destruye a la gente que vive allí. Además todas las personas que vimos eran muy grandes! ");
INSERT INTO spavbl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Incluso vimos gigantes allí, ¡son descendientes del gigante Anac! Comparados con ellos pareceríamos saltamontes, ¡y así debimos parecerles a ellos también!” ");
INSERT INTO spavbl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Entonces todos los que estaban allí gritaron toda la noche. ");
INSERT INTO spavbl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Todos los israelitas fueron y se quejaron a Moisés y Aarón, diciéndoles: “¡Ojalá hubiéramos muerto en Egipto, o aquí en este desierto! ");
INSERT INTO spavbl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¿Por qué el Señor nos lleva a este país sólo para que nos maten? ¡Nuestras esposas e hijos serán capturados y llevados como esclavos! ¿No sería mejor que volviéramos a Egipto?” ");
INSERT INTO spavbl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Se dijeron unos a otros: “Elijamos un nuevo líder y volvamos a Egipto”. ");
INSERT INTO spavbl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moisés y Aarón se postraron en el suelo frente a todos los israelitas reunidos. ");
INSERT INTO spavbl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Josué, hijo de Nun, y Caleb, hijo de Jefone, estaban allí. Habían sido parte del grupo que había ido a espiar la tierra. Se rasgaron la ropa, ");
INSERT INTO spavbl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","y les dijeron a los israelitas: “El país que viajamos y exploramos tiene muy buena tierra. ");
INSERT INTO spavbl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si el Señor está contento con nosotros, nos llevará allí y nos la dará, una tierra tan productiva que es como si fluyera leche y miel. ");
INSERT INTO spavbl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","No se rebelen ni luchen contra el Señor. No hay que tener miedo de la gente que vive en el campo, ¡podemos cogerlos fácilmente! Están indefensos y el Señor está con nosotros. ¡No les tengan miedo!” ");
INSERT INTO spavbl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","En respuesta, todo el pueblo gritó: “¡Apedréenlos!” Pero la gloria del Señor apareció de repente en el Tabernáculo de Reunión, justo en medio de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","El Señor le dijo a Moisés: “¿Hasta cuándo me va a rechazar este pueblo? ¿Cuánto tiempo va a rechazar esta gente la confianza en mí, a pesar de todos los milagros que he hecho delante de ellos? ");
INSERT INTO spavbl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Voy a enfermarlos con una enfermedad y matarlos. Entonces los convertiré en una nación más grande y fuerte que ellos”. ");
INSERT INTO spavbl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Pero Moisés le dijo al Señor: “¡Los egipcios se enterarán de esto! Fue por tu poder que sacaste a los israelitas de entre ellos. ");
INSERT INTO spavbl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ellos le contarán todo al pueblo que vive en este país. Ya han oído que tú, Señor, estás con nosotros los israelitas, que tú, Señor, te muestras cara a cara, que tu nube los vigila, y que los conduces por una columna de nube durante el día y una columna de fuego por la noche. ");
INSERT INTO spavbl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Si matas a toda esta gente de una sola vez, las naciones que han oído hablar de ti dirán: ");
INSERT INTO spavbl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘El Señor mató a este pueblo en el desierto porque no pudo llevarlos al país que prometió darles. Los ha matado a todos en el desierto’. ");
INSERT INTO spavbl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Ahora, Señor, por favor demuestra el alcance de tu poder tal como lo has dicho: ");
INSERT INTO spavbl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","El Señor es lento para enojarse y está lleno de amor confiable, perdonando el pecado y la rebelión. Sin embargo, no permitirá que los culpables queden impunes, trayendo las consecuencias del pecado de los padres a sus hijos, nietos y bisnietos. ");
INSERT INTO spavbl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Por favor, perdona el pecado de estas personas ya que tu amor digno de confianza es tan grande, de la misma manera que los has perdonado desde que salieron de Egipto hasta ahora”. ");
INSERT INTO spavbl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","“Los he perdonado como me lo pediste”, respondió el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","“Pero aún así, juro por mi vida y toda mi gloria en la tierra, ");
INSERT INTO spavbl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ni uno solo de los que vieron mi gloria y los milagros que hice en Egipto y en el desierto, sino que me provocaron y se negaron a obedecerme una y otra vez; ");
INSERT INTO spavbl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ni uno solo de ellos va a ver el país que prometí a sus antepasados. Ninguno de los que me rechazaron lo verá. ");
INSERT INTO spavbl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","“Pero como mi siervo Caleb tiene un espíritu totalmente diferente y está totalmente comprometido conmigo, lo llevaré al país que visitó, y sus descendientes serán los dueños. ");
INSERT INTO spavbl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Como los amalecitas y los cananeos viven en los valles, mañana deberán dar la vuelta y volver al desierto, tomando la ruta hacia el Mar Rojo”. ");
INSERT INTO spavbl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","El Señor le dijo a Moisés y Aarón, ");
INSERT INTO spavbl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“¿Cuánto tiempo más me van a criticar estos malvados? Ya he oído lo que dicen, haciendo quejas en mi contra. ");
INSERT INTO spavbl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ve y diles: Juro por mi propia vida, declara el Señor, que cumpliré sus deseos, ¡créanme! ");
INSERT INTO spavbl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Todos ustedes morirán en este desierto, todos los que fueron registrados en el censo que contó a los mayores de veinte años, y será porque se quejaron contra mi. ");
INSERT INTO spavbl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ninguno de ustedes entrará en el país que prometí darles, excepto Caleb, hijo de Jefone, y Josué, hijo de Nun. ");
INSERT INTO spavbl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Sin embargo, me llevaré a sus hijos, los que dijeron que serían llevados como botín, al país que ustedes rechazaron, y ellos sí lo apreciarán. ");
INSERT INTO spavbl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Pero todos ustedes van a morir en este desierto. ");
INSERT INTO spavbl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Tus hijos vagarán por el desierto durante cuarenta años, sufriendo por su falta de confianza, hasta que todos sus cuerpos estén enterrados en el desierto. ");
INSERT INTO spavbl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","“Así como han explorado el país durante cuarenta días, su castigo por sus pecados será de cuarenta años, un año por cada día, y verán lo que ocurre cuando me opongo a ustedes. ");
INSERT INTO spavbl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","¡Yo, el Señor, así lo he dicho! Verán por ustedes mismos que haré esto con estos malvados israelitas que se han unido para oponerse a mí. Sus vidas acabarán en el desierto, y morirán allí”. ");
INSERT INTO spavbl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Los hombres que Moisés había enviado a explorar el país – los que regresaron y porque dieron un mal informe hicieron que todos los israelitas se quejaran contra el Señor – ");
INSERT INTO spavbl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","los hombres que dieron el mal informe murieron ante el Señor de la peste. ");
INSERT INTO spavbl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Los únicos que vivieron fueron Josué hijo de Nun y Caleb hijo de Jefone de los que fueron a explorar el país. ");
INSERT INTO spavbl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Cuando Moisés dijo a los israelitas lo que el Señor había dicho estaban muy, muy tristes. ");
INSERT INTO spavbl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Se levantaron temprano a la mañana siguiente planeando ir a las colinas. “Sí, realmente pecamos”, dijeron, “pero ahora estamos aquí e iremos donde el Señor nos dijo”. ");
INSERT INTO spavbl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Pero Moisés se opuso. “¿Por qué desobedecen la orden del Señor? ¡No tendrán éxito en su plan! ");
INSERT INTO spavbl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","No intenten irse, porque sus enemigos los matarán, pues el Señor no está con ustedes. ");
INSERT INTO spavbl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Los amalecitas y cananeos que viven allí los atacarán, y morirán por espada. Porque rechazaron al Señor, y no les ayudará”. ");
INSERT INTO spavbl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Pero ellos fueron arrogantes y subieron a las colinas, aunque Moisés y el Arca del Pacto del Señor no se movieron del campamento. ");
INSERT INTO spavbl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Los amalecitas y cananeos que vivían allí en las colinas bajaron y atacaron a esos israelitas y los derrotaron, y los persiguieron hasta Jormá. ");
INSERT INTO spavbl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Dile a los israelitas, ‘Estas son la instrucciones sobre lo que deben hacer una vez que lleguen al país que les doy para vivir: ");
INSERT INTO spavbl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Cuando traiga una ofrenda al Señor de tu ganado o rebaño (ya sea un holocausto, un sacrificio para cumplir una promesa que hiciste, o una ofrenda de libre albedrío o de fiesta) que sea aceptable para el Señor, ");
INSERT INTO spavbl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","entonces también presentarás una ofrenda de grano de una décima parte de un efa de la mejor harina mezclada con un cuarto de hin de aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Añade un cuarto de hin de vino como ofrenda de bebida al holocausto o al sacrificio de un cordero. ");
INSERT INTO spavbl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Cuando se trate de un carnero, presenta una ofrenda de grano de dos décimas de efa de la mejor harina mezclada con un tercio de hin de aceite de oliva, ");
INSERT INTO spavbl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","junto con un tercio de hin de vino como ofrenda de bebida, todo ello para ser aceptable al Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Cuando traigas un novillo como holocausto o sacrificio para cumplir una promesa que hiciste o como ofrenda de paz al Señor, ");
INSERT INTO spavbl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","también llevarás con el novillo una ofrenda de grano de tres décimas de efa de la mejor harina mezclada con medio hin de aceite de oliva. ");
INSERT INTO spavbl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Añade medio hin de vino como ofrenda de bebida. Todo esto es una ofrenda para ser aceptable al Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Esto debe hacerse por cada toro, carnero, cordero o cabra que se traiga como ofrenda. ");
INSERT INTO spavbl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Esto es lo que tienes que hacer para cada uno, sin importar cuántos sean. ");
INSERT INTO spavbl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Todo israelita debe seguir estas instrucciones cuando presente una ofrenda que sea aceptable para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Esto también se aplica a todas las generaciones futuras que si un extranjero que vive entre ustedes o cualquier otra persona entre ustedes desea presentar una ofrenda aceptable para el Señor: deben hacer exactamente lo que ustedes hacen. ");
INSERT INTO spavbl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Toda la congregación debe tener las mismas reglas para ustedes y para el extranjero que vive entre ustedes. Esta es una ley permanente para todas las generaciones futuras. Tú y el extranjero deben ser tratados de la misma manera ante la ley. ");
INSERT INTO spavbl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Las mismas reglas y normas se aplican a ustedes y al extranjero que vive entre ustedes’”. ");
INSERT INTO spavbl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Diles a los israelitas: ‘Cuando lleguen al país al que yo los llevo ");
INSERT INTO spavbl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","y cománde los alimentos que allí se producen, darán parte de ellos como ofrenda al Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Darán como ofrenda una parte de la harina que usen para hacer los panes, y la presentarás como una ofrenda de la era. ");
INSERT INTO spavbl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Para todas las generaciones futuras, darás al Señor una ofrenda de la primera de tus harinas. ");
INSERT INTO spavbl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Ahora bien, si pecan colectivamente sin querer y no siguen todas estas instrucciones que el Señor ha dado a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","s decir, todo lo que el Señor les ha ordenado hacer a través de Moisés desde el momento en que el Señor les dio y para todas las generaciones futuras, ");
INSERT INTO spavbl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","y si se hizo sin querer y sin que todos lo supieran, entonces toda la congregación debe presentar un novillo como holocausto para ser aceptado por el Señor, junto con su ofrenda de grano y su libación presentada según las reglas, así como un macho cabrío como ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","De esta manera el sacerdote debe hacer que toda la congregación de Israel esté bien con el Señor para que puedan ser perdonados, porque el pecado fue involuntario y han presentado al Señor un holocausto y una ofrenda por el pecado, ofrecida ante el Señor por su pecado involuntario. ");
INSERT INTO spavbl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Entonces toda la congregación de Israel y los extranjeros que viven entre ellos serán perdonados, porque el pueblo pecó sin intención. ");
INSERT INTO spavbl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“En el caso de un individuo que peca sin intención, deben presentar una cabra hembra de un año como ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","El sacerdote hará que la persona que pecó sin querer esté en su derecho ante el Señor. Una vez que hayan sido expiados, serán perdonados. ");
INSERT INTO spavbl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Aplicarás la misma ley para el que peca por error a un israelita o a un extranjero que viva entre ustedes. ");
INSERT INTO spavbl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Pero la persona que peca a manera de desafío, ya sea un israelita o un extranjero, está blasfemando al Señor. Serán expulsados de su pueblo. ");
INSERT INTO spavbl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Deben ser expulsados, porque han tratado la palabra del Señor con desprecio y han quebrantado su mandamiento. Son responsables de las consecuencias de su propia culpa’”. ");
INSERT INTO spavbl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Durante el tiempo en que los israelitas vagaban por el desierto, un hombre fue sorprendido recogiendo leña en el día Sábado. ");
INSERT INTO spavbl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Las personas que lo encontraron recogiendo leña lo llevaron ante Moisés, Aarón y el resto de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Lo pusieron bajo vigilancia porque no estaba claro qué le iba a pasar. ");
INSERT INTO spavbl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","El Señor le dijo a Moisés: “Este hombre tiene que ser ejecutado. Todos los israelitas deben apedrearlo fuera del campamento”. ");
INSERT INTO spavbl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Así que todos tomaron al hombre fuera del campamento y lo apedrearon hasta la muerte como el Señor había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Poco después el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Diles a los israelitas que para todas las generaciones futuras harán borlas para los dobladillos de tu ropa y deberán atarlas con un cordón azul. ");
INSERT INTO spavbl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Cuando miren estas borlas recordarán que deben guardar todos los mandamientos del Señor y que no sean infieles, siguiendo sus propios pensamientos y deseos. ");
INSERT INTO spavbl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","De esta manera serecordarán que deben guardar todos mis mandamientos y serán santos para Dios. Yo soy el Señor su Dios que los sacó de Egipto para ser su Dios. ");
INSERT INTO spavbl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","¡Yo soy el Señor su Dios!” ");
INSERT INTO spavbl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Coré, hijo de Izhar, hijo de Coat, hijo de Levi, trató de asumir el liderazgo, junto con Datán y Abiram, hijos de Eliab, y On, hijo de Pelet, que eran de la tribu de Rubén. ");
INSERT INTO spavbl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Istos se rebelaron contra Moisés, y se les unieron 250 respetados líderes israelitas y miembros de la asamblea. ");
INSERT INTO spavbl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Se unieron en oposición a Moisés y Aarón, diciéndoles: “¡Ustedes se han adueñado del poder! Cada uno de los israelitas es santo, y el Señor está entre ellos. Entonces, ¿por qué se ponen ustedes por encima de la asamblea del Señor?” ");
INSERT INTO spavbl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Cuando Moisés oyó lo que decían, cayó al suelo boca abajo. ");
INSERT INTO spavbl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Entonces le dijo a Coré y a todos los que estaban con él: “Por la mañana el Señor va a demostrar quién es suyo y quién es santo, y permitirá que esa persona se acerque a él. Sólo permitirá que se acerque a él quien él elija. ");
INSERT INTO spavbl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Esto es lo que tú, Coré, y todos los que están contigo van a hacer. Toma unos quemadores de incienso, ");
INSERT INTO spavbl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","y mañana pon incienso en ellos y enciéndelo en la presencia del Señor. Entonces el hombre que el Señor elija es el que es santo. ¡Son ustedes, los levitas, los que están tomando demasiado poder para ustedes mismos!” ");
INSERT INTO spavbl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moisés también le dijo a Coré: “¡Escuchen, levitas! ");
INSERT INTO spavbl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","¿Les parece poco que el Dios de Israel los haya elegido entre todos los demás israelitas y les haya permitido acercarse a él y realizar la obra en el Tabernáculo del Señor, estar ante los israelitas y servirles? ");
INSERT INTO spavbl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","estedado el privilegio de acercarte a él, a ti, Coré, a y a todos los demás levitas, ¡pero ahora también quieren tener el sacerdocio! ");
INSERT INTO spavbl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Así que en realidad tú y los que se han unido a ti están luchando contra el Señor, porque ¿quién es Aarón para que murmurencontra él?” ");
INSERT INTO spavbl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Entonces Moisés convocó a Datán y a Abiram, los hijos de Eliab, pero ellos respondieron: “No vamos a comparecer ante ustedes! ");
INSERT INTO spavbl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","¿No has hecho suficiente alejándonos de una tierra que fluye leche y miel para matarnos aquí en el desierto? ¿También tienes que hacerte un dictador y gobernante? ");
INSERT INTO spavbl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Además, no nos has llevado a una tierra que fluye leche y miel ni nos has dado campos y viñedos para que los poseamos. ¿De verdad crees que puedes engañar a todo el mundo? ¡No, no asistiremos!” ");
INSERT INTO spavbl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moisés se enfadó mucho y le dijo al Señor: “No aceptes sus ofrendas. Nunca les he quitado ni un asno ni he tratado mal a ninguno de ellos”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moisés le dijo a Coré: “Tú y todos los que se han unido a ti deben presentarse ante el Señor mañana, todos ustedes y Aarón también. ");
INSERT INTO spavbl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Cada uno tomará su quemador de incienso, lo pondrá en él y lo ofrecerá ante el Señor. Los 250 usarán sus quemadores de incienso y Aarón también”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Entonces cada uno tomó su incensario, puso incienso en él, lo encendió, y se paró junto con Moisés y Aarón a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Cuando Coré reunió a todo su grupo rebelde a la entrada del Tabernáculo de Reunión, la gloria del Señor apareció ante toda la congregación. ");
INSERT INTO spavbl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","El Señor dijo a Moisés y Aarón, ");
INSERT INTO spavbl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Apártense de estos israelitas y los destruiré enseguida”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Pero Moisés y Aarón cayeron al suelo boca abajo y dijeron: “Dios – Diosde todo lo que vive – si es un solo hombre el que peca, ¿tienes que enfadarte con todos?” ");
INSERT INTO spavbl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Dile al pueblo que se aleje de las casas de Coré, Datán y Abiram”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Entonces Moisés se acercó a Dathan y Abiram, y los ancianos israelitas de Israel le siguieron. ");
INSERT INTO spavbl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ordenó al pueblo: “Apártense de las tiendas de estos malvados y no toquen nada que les pertenezca, de lo contrario serán destruidos junto con ellos en todos sus pecados”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","El pueblo se alejó de las casas de Coré, Datán y Abiram. Dathan y Abiram salieron y se pararon en las entradas de sus tiendas junto con sus esposas, hijos y pequeños. ");
INSERT INTO spavbl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moisés dijo: “Así es como sabrán que el Señor me envió para llevar a cabo todo lo que he hecho, porque no fue nada que surgiera de mi pernsamiento. ");
INSERT INTO spavbl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si estos hombres mueren de muerte natural, experimentando el destino de cada ser humano, entonces el Señor no me envió. ");
INSERT INTO spavbl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Pero si el Señor hace algo totalmente diferente, y la tierra se abre y se los traga junto con todo lo que les pertenece para que bajen vivos al Seol, entonces sabrán que estos hombres han actuado con desprecio ante Señor”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Tan pronto como Moisés terminó de decir todo esto, la tierra debajo de los rebeldes se abrió, ");
INSERT INTO spavbl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","y la tierra se los tragó así como a sus hogares, y a todos los que estaban allí con Coré y todo lo que les pertenecía. ");
INSERT INTO spavbl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Bajaron vivos al Seol con todo lo que tenían. La tierra se cerró sobre ellos, y ya no estaban. ");
INSERT INTO spavbl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Cuando oyeron sus gritos, todos los israelitas cercanos salieron corriendo, gritando: “¡Cuidado! La tierra podría tragarnos a nosotros también”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Entonces fuego salió del Señor y quemó a los 250 hombres que ofrecían incienso. ");
INSERT INTO spavbl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Entonces el Señor dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Dile a Eleazar, hijo del sacerdote Aarón, que recoja los incensarios sagrados de entre los que se han quemado, y que esparza las brasas usadas para el incienso bien lejos del campamento. ");
INSERT INTO spavbl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Haz que los incensarios de los que pecaron a costa de su propia vida sean martillados en láminas de metal como cobertura para el altar, porque fueron ofrecidos ante el Señor, y así se han hecho santos. Serán un recordatorio para los israelitas de lo que pasó”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Así que el sacerdote Eleazar recogió los incensarios de bronce que usaban los quemados y los hizo martillar como cubierta para el altar, ");
INSERT INTO spavbl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","siguiendo las instrucciones que le dio el Señor a través de Moisés. Esto era para recordar a los israelitas que nadie que no sea descendiente de Aarón debe venir a ofrecer incienso ante el Señor, de lo contrario podrían terminar como Coré y los que están con él. ");
INSERT INTO spavbl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Al día siguiente todos los israelitas se quejaron a Moisés y Aarón, diciendo: “¡Han matado al pueblo del Señor!” ");
INSERT INTO spavbl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Pero cuando el pueblo se reunió para enfrentarse a ellos, Moisés y Aarón se acercaron al Tabernáculo de Reunión, y de repente la nube lo cubrió y apareció la gloria del Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moisés y Aarón fueron y se pararon al frente del Tabernáculo de Reunión, ");
INSERT INTO spavbl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","y el Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Aléjate de este pueblo, pues acabaré con ellos inmediatamente”. Moisés y Aarón cayeron al suelo boca abajo. ");
INSERT INTO spavbl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moisés le dijo a Aarón: “Pon algunas brasas del altar y algo de incienso en tu incensario. Luego corre donde está el pueblo y ponlos delante del Señor, porque el Señor está enojado con ellos y una plaga ha comenzado”. ");
INSERT INTO spavbl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aarón tomó el incensario tal como le había dicho Moisés y corrió al centro de la asamblea. Vio que la peste había empezado a afectar al pueblo, así que ofreció el incienso e hizo que el pueblo se pusiera en pie ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Se interpuso entre los muertos y los vivos, y la peste se detuvo. ");
INSERT INTO spavbl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Sin embargo, 14.700 personas murieron por la plaga además de los que murieron por culpa de Coré. ");
INSERT INTO spavbl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Entonces Aarón regresó a Moisés a la entrada del Tabernáculo de Reunión porque la plaga había sido detenida. ");
INSERT INTO spavbl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Diles a los israelitas que traigan doce bastones, uno del líder de cada tribu. Escriban el nombre de cada hombre en el bastón, ");
INSERT INTO spavbl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","y escriban el nombre de Aarón en el bastón de la tribu de Leví, porque tiene que haber un bastón para el jefe de cada tribu. ");
INSERT INTO spavbl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Coloca los bastones en el Tabernáculo de Reunión frente al Testimonio donde me encuentro contigo. ");
INSERT INTO spavbl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","El bastón que pertenece al hombre que yo elija brotará ramas, y pondré fin a las constantes quejas de los israelitas contra ti”. ");
INSERT INTO spavbl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moisés explicó esto a los israelitas, y cada uno de sus líderes le dio un bastón, uno para cada uno de los líderes de sus tribus. Así que había doce bastones incluyendo el de Aarón. ");
INSERT INTO spavbl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moisés colocó los bastones ante el Señor en la Tienda del Testimonio. ");
INSERT INTO spavbl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Al día siguiente Moisés entró en la Tienda del Testimonio y vio que el bastón de Aarón que representaba a la tribu de Leví, había brotado y salieron ramas de él, y estaba florecido y había producido almendras. ");
INSERT INTO spavbl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moisés tomó todos los bastones de la presencia del Señor y los mostró a todos los israelitas. Ellos los vieron, y cada hombre recogió su propio bastón. ");
INSERT INTO spavbl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","El Señor le dijo a Moisés: “Pon el bastón de Aarón de nuevo delante del Testimonio, para que lo guardes allí como un recordatorio para advertir a cualquiera que quiera rebelarse, para que dejen de quejarse contra mí. De lo contrario, morirán”. ");
INSERT INTO spavbl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moisés hizo lo que el Señor le ordenó. ");
INSERT INTO spavbl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Entonces los israelitas vinieron y le dijeron a Moisés: “¿No ves que todos vamos a morir? ¡Nos van a destruir! ¡Nos van a matar a todos! ");
INSERT INTO spavbl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","El que se atreva a acercarse al Tabernáculo del Señor morirá. ¿Nos van a aniquilar a todos?” ");
INSERT INTO spavbl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","El Señor le dijo a Aarón: “Tú y tus hijos y los otros levitas son responsables de los pecados relacionados con el santuario. Sólo tú y tus hijos son responsables de los pecados relacionados con su sacerdocio. ");
INSERT INTO spavbl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Haz que tus hermanos de la tribu de Leví, la tribu de tu padre, se unan a ti para ayudarte a ti y a tus hijos con tu servicio en la Tienda del Testimonio. ");
INSERT INTO spavbl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ellos se encargarán de tus responsabilidades y de las relacionadas con la Tienda, pero no deben acercarse demasiado a los objetos sagrados del santuario o del altar, de lo contrario morirán, y tú también. ");
INSERT INTO spavbl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Deben ayudarte y cuidar de las responsabilidades del Tabernáculo de Reunión, haciendo todo el trabajo en la Tienda, pero no se les permite estar contigo durante tu ministerio sacerdotal. ");
INSERT INTO spavbl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Debes llevar a cabo las responsabilidades relacionadas con el santuario y el altar, para que mi ira no vuelva a caer sobre los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mira, yo mismo he elegido a tus hermanos los levitas de los israelitas como mi regalo para ti, dedicado al Señor para hacer el trabajo que relaciona el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Pero sólo tú y tus hijos son responsables de tu sacerdocio, haciendo todo lo que concierne al altar y está detrás del velo. Sólo tú debes realizar ese servicio. Te estoy dando el don de tu sacerdocio, pero cualquier otro que se acerque al santuario debe ser ejecutado”. ");
INSERT INTO spavbl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","El Señor le dijo a Aarón, “Escucha, te he puesto a cargo de oficiar mis ofrendas. Todas las santas contribuciones de los israelitas que traen están reservadas para ti, y esta es una regla permanente. ");
INSERT INTO spavbl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Parte de las ofrendas más sagradas tomadas de los holocaustos son tuyas. Parte de todas las ofrendas que me dan como ofrendas sagradas, ya sean ofrendas de grano o de pecado o de culpa, esa parte pertenece a ti y a tus hijos. ");
INSERT INTO spavbl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Lo comerás en un lugar santísimo. A todo macho se le permite comerlo. Deben considerarlo como algo sagrado. ");
INSERT INTO spavbl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“También te pertenecen los regalos voluntarios y las ofrendas de los israelitas. Te he dado esto a ti y a tus hijos e hijas como una regla permanente. Todos los de tu casa que estén ceremonialmente limpios pueden comerlo. ");
INSERT INTO spavbl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Les doy el mejor aceite de oliva y el mejor vino y grano que los israelitas dan como primicias al Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Las primicias de todas las cosechas que produzcan en su tierra y que traigan al Señor son tuyas. Todos los miembros de tu familia que estén ceremonialmente limpios pueden comerlas. ");
INSERT INTO spavbl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Todo lo que en Israel se dedica al Señor es tuyo. ");
INSERT INTO spavbl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Todo primogénito, ya sea humano o animal, que se ofrezca al Señor es tuyo. Pero debes redimir todo primogénito y todo primogénito de los animales inmundos. ");
INSERT INTO spavbl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Cuando tengan un mes de edad, pagarás el precio de redención de cinco siclos de plata (usando el estándar de siclos del santuario), equivalente a veinte gueras. ");
INSERT INTO spavbl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Pero no se te permitirá redimir al primogénito de un buey, una oveja o una cabra porque son sagrados. Esparcirás su sangre sobre el altar y quemarás su grasa como holocausto aceptado por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Su carne es tuya, de la misma manera que el pecho y el muslo derecho de la ofrenda ondulada son tuyos. ");
INSERT INTO spavbl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Te doy todas las ofrendas voluntarias que los israelitas presentan al Señor así como a tus hijos e hijas como una regla permanente. Es un acuerdo permanente de sal ante el Señor para ti y tus descendientes”. ");
INSERT INTO spavbl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","“No tendrás propiedades en su país, y no tendrás una parte de sus tierras. Yo soy tu parte y tu posesión entre los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","En cambio, he dado a los levitas todos los diezmos de Israel como compensación por el servicio que prestan al hacer el trabajo en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","“A los israelitas ya no se les permite acercarse al Tabernáculo de Reunión, de lo contrario cometerán una ofensa y morirán. ");
INSERT INTO spavbl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Los levitas deben realizar el trabajo en el Tabernáculo de Reunión, y deben asumir la responsabilidad de los pecados que se cometan. Esta es una regla permanente para todas las generaciones futuras. Los levitas no recibirán una parte de la tierra entre los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","En su lugar, he dado a los levitas como compensación el diezmo que los israelitas dan al Señor como contribución. Por eso les dije que no recibirían una parte de la tierra entre los israelitas”. ");
INSERT INTO spavbl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Habla con los levitas y explícales: ‘Cuando recibas de los israelitas el diezmo que te he dado como compensación, debes devolver parte de él como ofrenda al Señor: un diezmo del diezmo. ");
INSERT INTO spavbl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Tu ofrenda será considerada como si fueran las primicias del grano de tu era o del jugo de uva del lagar. ");
INSERT INTO spavbl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","De este modo, deberás contribuir con una ofrenda al Señor de cada diezmo que recibas de los israelitas, entregando la ofrenda del Señor al sacerdote Aarón. ");
INSERT INTO spavbl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","De todas las ofrendas que recibas debes contribuir como ofrenda del Señor con lo mejor, la parte más sagrada de cada ofrenda’. ");
INSERT INTO spavbl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Así que di a los levitas, ‘Cuando hayas presentado la mejor parte, será considerada como tu contribución producida por tu trilladora o lagar. ");
INSERT INTO spavbl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ustedes y sus familias pueden comerla en cualquier sitio porque es la compensación por su servicio en el Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","No se considerará que han pecado si han presentado la mejor parte. Pero si tratan las sagradas ofrendas de los israelitas con falta de respeto morirán’”. ");
INSERT INTO spavbl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","El Señor le dijo a Moisés y Aarón: ");
INSERT INTO spavbl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Esta es una norma que el Señor ha ordenado, diciendo, Dile a los israelitas que te traigan una vaca roja sin defectos, que nunca haya sido uncida. ");
INSERT INTO spavbl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Entrégasela al sacerdote Eleazar, y él la llevará fuera del campamento y lamandará a masacrar. ");
INSERT INTO spavbl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","El sacerdote Eleazar pondrá un poco de su sangre en su dedo y la rociará siete veces hacia la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Luego la vaca debe ser quemada mientras él observa. Todo debe ser quemado: su piel, carne y sangre, así como sus excrementos. ");
INSERT INTO spavbl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","El sacerdote arrojará madera de cedro, hisopo e hilo carmesí sobre la vaca en llamas. ");
INSERT INTO spavbl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","“Entonces el sacerdote lavará sus ropas y su cuerpo en agua, y después podrá entrar en el campamento, pero permanecerá impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","La persona que quemó la vaca también lavará sus ropas y su cuerpo en agua, y él también permanecerá impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“El que esté limpio recogerá las cenizas de la vaca y las guardará en un lugar limpio fuera del campamento. Las guardarán los israelitas para preparar el agua de purificación que sirve para purificar del pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","El hombre que recogió las cenizas de la vaca lavará también sus ropas, y permanecerá impuro hasta la noche. Esta es una regla permanente para los israelitas y para el extranjero que vive con ellos. ");
INSERT INTO spavbl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Si tocas un cadáver serás impuro durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Debes purificarte con el agua de la purificación al tercer día y al séptimo día, y entonces estarás limpio. Pero si no te purificas en el tercer y séptimo día, no estarás limpio. ");
INSERT INTO spavbl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Si tocas un cadáver y no te purificas, harás impuro el Tabernáculo del Señor y deberás ser expulsado de Israel. Sigues siendo impuro porque no se te ha rociado con el agua de la purificación y tu impureza permanece. ");
INSERT INTO spavbl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“La siguiente norma se aplica cuando una persona muere en una tienda. Todo el que entre en la tienda y todo el que ya esté en ella será impuro durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Cualquier recipiente abierto que no tenga una tapa cerrada es impuro. ");
INSERT INTO spavbl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Si estás al aire libre y tocas a alguien que ha muerto por la espada o que ha muerto de forma natural, o si tocas un hueso humano o una tumba, entonces serás impuro durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Este es el proceso para la purificación si eres impuro. Toma algunas de las cenizas del holocausto para la purificación y ponlas en un frasco con agua fresca. ");
INSERT INTO spavbl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","El hombre que esté limpio tomará un hisopo y lo mojará en el agua. Luego rociará la tienda y todo lo que haya dentro de ella, y a todos los que estuvieran allí. También deberá rociarlo a usted si ha tocado un hueso, o una tumba, o alguien que ha muerto o ha sido asesinado. ");
INSERT INTO spavbl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“El hombre que está limpio debe rociarte tanto al tercer día como al séptimo día. Después de que te purifiques al séptimo día, debes lavar tu ropa y a ti mismo en agua, y esa noche estarás limpio. ");
INSERT INTO spavbl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Pero si no te purificas, serás expulsado de los israelitas, porque has hecho impuro el Tabernáculo del Señor. El agua de la purificación no ha sido rociada sobre ti, y sigues siendo impuro. ");
INSERT INTO spavbl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Esta es una regla permanente para todos. El hombre que rocía el agua de purificación debe lavar su ropa, y cualquiera que toque el agua de purificación será impuro hasta la noche. ");
INSERT INTO spavbl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Todo lo que toque la persona impura será impuro, y cualquiera que lo toque será impuro hasta la noche”. ");
INSERT INTO spavbl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Fue durante el primer mes del año que todos los israelitas llegaron al desierto de Zin y establecieron un campamento en Cades. (Aquí fue donde Miriam murió y fue enterrada). ");
INSERT INTO spavbl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Sin embargo, allí no había agua para que nadie bebiera, así que la gente se reunió para enfrentarse a Moisés y Aarón. ");
INSERT INTO spavbl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Discutieron con Moisés, diciendo: “¡Si hubiéramos muerto con nuestros parientes en la presencia del Señor! ");
INSERT INTO spavbl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","¿Por qué has traído al pueblo del Señor a este desierto para que nosotros y nuestro ganado muramos aquí? ");
INSERT INTO spavbl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Por qué nos has sacado de Egipto para venir a este horrible lugar? Aquí no crece nada, ni grano, ni higos, ni viñas, ni granadas. Y no hay agua para beber”. ");
INSERT INTO spavbl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moisés y Aarón dejaron el pueblo y se fueron a la entrada del Tabernáculo de Reunión. Allí cayeron boca abajo en el suelo, y la gloria del Señor se les apareció. ");
INSERT INTO spavbl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Toma el bastón y haz que la gente se reúna a tu alrededor. Mientras miran, tú y tu hermano Aarón ordenarán a la roca y derramará agua. Traerán agua de la roca para que el pueblo y su ganado puedan beber”. ");
INSERT INTO spavbl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moisés recogió el bastón que estaba guardado en la presencia del Señor, como se le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moisés y Aarón hicieron que todos se reunieran frente a la roca. Moisés les dijo: “¡Escuchen, pandilla de rebeldes! ¿Tenemos que sacar agua de esta roca para ustedes?” ");
INSERT INTO spavbl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Entonces Moisés tomó el bastón y golpeó la roca dos veces. Salieron chorros de agua para que la gente y su ganado pudieran beber. ");
INSERT INTO spavbl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Pero el Señor les dijo a Moisés y a Aarón: “Como no confiaron en mí lo suficiente para demostrar lo santo que soy a los israelitas, no serán ustedes los que los lleven al país que les he dado”. ");
INSERT INTO spavbl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","El lugar donde los israelitas discutían con el Señor se llamaba las aguas de Meribá, y era donde les revelaba su santidad. ");
INSERT INTO spavbl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moisés envió mensajeros desde Cades al rey de Edom, diciéndole: “Esto es lo que dice tu hermano Israel. Tú sabes todo sobre las dificultades que hemos enfrentado. ");
INSERT INTO spavbl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nuestros antepasados fueron a Egipto y nosotros vivimos allí mucho tiempo. Los egipcios nos trataron mal a nosotros y a nuestros antepasados, ");
INSERT INTO spavbl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","así que pedimos ayuda al Señor, y él escuchó nuestros gritos. Envió un ángel y nos sacó de Egipto. “Escuchen, ahora estamos en Cades, un pueblo en la frontera de su territorio. ");
INSERT INTO spavbl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Por favor, permítanos viajar a través de su país. No cruzaremos ninguno de sus campos o viñedos, ni beberemos agua de ninguno de sus pozos. Nos quedaremos en la Carretera del Rey; no nos desviaremos ni a la derecha ni a la izquierda hasta que hayamos pasado por su país”. ");
INSERT INTO spavbl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Pero el rey de Edom respondió: “Se les prohíbe viajar por nuestro país, de lo contrario saldremos y los detendremos por la fuerza”. ");
INSERT INTO spavbl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","“Nos mantendremos en el camino principal”, insistieron los israelitas. “Si nosotros o nuestro ganado bebemos tu agua, te pagaremos por ella. Eso es todo lo que queremos, sólo pasar a pie”. ");
INSERT INTO spavbl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Pero el rey de Edom insistió: “¡Tienen prohibido viajar por nuestro país!” Salió con su gran y poderoso ejército para enfrentarse a los israelitas de frente. ");
INSERT INTO spavbl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Como el rey de Edom se negó a permitir que Israel viajara por su territorio, los israelitas tuvieron que volver. ");
INSERT INTO spavbl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Todos los israelitas dejaron Cades y viajaron al Monte Hor. ");
INSERT INTO spavbl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","En el monte Hor, cerca de la frontera con el país de Edom, el Señor dijo a Moisés y Aarón, ");
INSERT INTO spavbl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aarón pronto se unirá a sus antepasados en la muerte. No entrará en el país que he dado a los israelitas, porque ambos desobedecieron mi orden en las aguas de Meribá. ");
INSERT INTO spavbl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Que Aarón y su hijo Eleazar se unan a ustedes y suban juntos al monte Hor. ");
INSERT INTO spavbl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Quítale a Aarón la ropa de sacerdote y pónsela a su hijo Eleazar. Aarón va a morir allí y se unirá a sus antepasados en la muerte”. ");
INSERT INTO spavbl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moisés hizo lo que el Señor le ordenó: Subieron al monte Hor a la vista de todos los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moisés se quitó las ropas sacerdotales que llevaba Aarón y se las puso a su hijo Eleazar. Aarón murió allí, en la cima del monte. Entonces Moisés y Eleazar volvieron a bajar. ");
INSERT INTO spavbl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Cuando la gente se dio cuenta de que Aarón había muerto, todos lloraron por él durante treinta días. ");
INSERT INTO spavbl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","El rey cananeo de Arad, que vivía en el Néguev, se enteró de que los israelitas se acercaban por el camino de Atharim. Fue y atacó a Israel y tomó a algunos de ellos prisioneros. ");
INSERT INTO spavbl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Así que Israel hizo una promesa solemne al Señor: “Si nos entregas a esta gente, nos comprometemos a destruir completamente sus pueblos”. ");
INSERT INTO spavbl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","El Señor respondió a su invitación y les entregó a los cananeos. Los israelitas los destruyeron completamente a ellos y a sus pueblos, y llamaron al lugar Horma. ");
INSERT INTO spavbl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Los israelitas dejaron el Monte Hor por el camino que lleva al Mar Rojo para evitar viajar por el país de Edom. Pero el pueblo se puso de mal humor en el camino ");
INSERT INTO spavbl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","y se quejó contra Dios y contra Moisés, diciendo: “¿Por qué nos sacaste de Egipto para morir en el desierto? No tenemos ni pan ni agua, y odiamos esta horrible comida!” ");
INSERT INTO spavbl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Así que el Señor envió serpientes venenosas para atacarlos, y muchos israelitas fueron mordidos y murieron. ");
INSERT INTO spavbl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","El pueblo fue a ver a Moisés y le dijo: “Nos equivocamos al presentar quejas contra el Señor y contra ti. Por favor, ruega al Señor que nos quite las serpientes de encima”. Moisés rezó al Señor en su nombre. ");
INSERT INTO spavbl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","El Señor le dijo a Moisés: “Haz una maqueta de una serpiente y ponla en un palo. Cuando alguien que haya sido mordido la mire, vivirá”. ");
INSERT INTO spavbl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moisés hizo una serpiente de bronce y la puso en un poste. Aquellos que la miraron vivieron. ");
INSERT INTO spavbl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Los israelitas salieron y acamparon en Obot. ");
INSERT INTO spavbl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Luego se fueron de Obot y acamparon en Iye-abarim en el desierto en el lado este de Moab. ");
INSERT INTO spavbl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Se fueron de allí y acamparon en el Valle de Zered. ");
INSERT INTO spavbl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Luego se trasladaron de allí y acamparon en el lado más alejado del río Arnón, en el desierto cerca del territorio de Amorite. El río Arnón es la frontera entre Moab y los amorreos. ");
INSERT INTO spavbl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Por eso el Libro de las Guerras del Señor se refiere “al pueblo de Vaheb en Sufa y al barranco de Arnón, ");
INSERT INTO spavbl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","a las laderas del barranco que llegan al pueblo de Ar que está en la frontera con Moab”. ");
INSERT INTO spavbl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Desde allí se trasladaron a Beer, el pozo donde el Señor le dijo a Moisés, “Haz que el pueblo se reúna para que pueda darles agua”. ");
INSERT INTO spavbl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Entonces los israelitas cantaron esta canción: “¡Echen agua en el pozo! ¡Cada uno de ustedes, cante! ");
INSERT INTO spavbl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Los jefes de las tribus cavaron el pozo; sí, los jefes del pueblo cavaron el pozo con sus varas de autoridad y sus bastones”. Los israelitas dejaron el desierto y siguieron hasta Matanaá ");
INSERT INTO spavbl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Desde Mataná viajaron a Nahaliel, de Nahaliel a Bamot, ");
INSERT INTO spavbl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","y de Bamoth al valle en el territorio de Moab donde la cima del Monte Pisga mira hacia los páramos. ");
INSERT INTO spavbl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Entonces Israel envió mensajeros a Sehón, rey de los amorreos, con la siguiente petición: ");
INSERT INTO spavbl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Por favor, permítanos viajar a través de su país. No cruzaremos ninguno de sus campos o viñedos, ni beberemos agua de ninguno de sus pozos. Permaneceremos en la Carretera del Rey hasta que hayamos pasado por su país”. ");
INSERT INTO spavbl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Pero Sehón se negó a permitir que los israelitas viajaran por su territorio. En su lugar, llamó a todo su ejército y salió al encuentro de los israelitas de frente en el desierto. Cuando llegó a Jahaz, atacó a los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Los israelitas los derrotaron, matándolos con sus espadas. Se apoderaron de su tierra desde el río Arnón hasta el río Jaboc, pero sólo hasta la frontera de los amonitas, porque estaba bien defendida. ");
INSERT INTO spavbl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Los israelitas conquistaron todos los pueblos amorreos y se apoderaron de ellos, incluyendo Hesbón y sus pueblos vecinos. ");
INSERT INTO spavbl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesbón era la capital de Sehón, rey de los amorreos, que había luchado contra el anterior rey de Moab y le había quitado todas sus tierras hasta el río Arnón. ");
INSERT INTO spavbl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Por eso los antiguos compositores escribieron: “¡Vengan a Hesbón y hagan que la reconstruyan; restauren la ciudad de Sehón! ");
INSERT INTO spavbl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Porque un fuego salió de Hesbón, una llama de la ciudad de Sihón. Quemó a Ar en Moab, donde los gobernantes viven en las alturas de Arnón. ");
INSERT INTO spavbl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","¡Qué desastre enfrentas, Moab! ¡Vais a morir todos, pueblo de Quemos! Entregaste a tus hijos como exiliados y a tus hijas como prisioneras a Sehón, rey de los amorreos. ");
INSERT INTO spavbl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","¡Pero ahora hemos derrotado a los amorreos! El gobierno de Heshbon ha sido destruido hasta Dibon. Los aniquilamos hasta Nofa y hasta Medeba”. ");
INSERT INTO spavbl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Los israelitas ocuparon el país de los amorreos. ");
INSERT INTO spavbl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moisés envió hombres a explorar Jazer. Los israelitas conquistaron los pueblos de los alrededores y expulsaron a los amorreos que vivían allí. ");
INSERT INTO spavbl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Luego continuaron en el camino hacia Basán. Og, rey de Basán, dirigió a todo su ejército para enfrentarse a ellos de frente, y luchó contra ellos en Edrei. ");
INSERT INTO spavbl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","El Señor le dijo a Moisés: “No tienes que temerle, porque yo te lo he entregado, junto con todo su pueblo y su tierra. Hazle lo que hiciste con Sehón, rey de los amorreos, que gobernó desde Hesbón”. ");
INSERT INTO spavbl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Así que mataron a Og, a sus hijos y a todo su ejército. Nadie sobrevivió, y los israelitas se apoderaron de su país. ");
INSERT INTO spavbl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Los israelitas avanzaron y acamparon en las llanuras de Moab al este del Jordán, frente a Jericó. ");
INSERT INTO spavbl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balac, hijo de Zippor, había visto todo lo que los israelitas habían hecho a los amorreos. ");
INSERT INTO spavbl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Los moabitas estaban aterrorizados de los israelitas porque eran muchos. Los moabitas temían la llegada de los israelitas ");
INSERT INTO spavbl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","y dijeron a los líderes de Madián, “Esta horda se comerá todo lo que tenemos, como un buey se come la hierba del campo”. (Balac hijo de Zippor, era rey de Moab en ese momento). ");
INSERT INTO spavbl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Envió mensajeros para llamar a Balaam, hijo de Beor, que vivía en Petor, cerca del río Éufrates en su propio país. “Escuchen, ha llegado aquí un grupo de personas que vinieron de Egipto”, dijo Balac en su mensaje a Balaam. “Hay hordas de ellos y representan una verdadera amenaza para nosotros. ");
INSERT INTO spavbl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Por favor, ven inmediatamente y maldice a estas personas por mí, porque son más fuertes que yo. Tal vez entonces pueda atacarlos y expulsarlos de mi país porque sé que quienquiera que bendiga es bendecido, y quienquiera que maldiga es maldito”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Entonces los líderes moabitas y madianitas partieron, llevándose el pago de la adivinación con ellos. Cuando llegaron, le dieron a Balaam el mensaje de Balac. ");
INSERT INTO spavbl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","“Pasen la noche y les haré saber la respuesta que me da el Señor”, les dijo Balaam. Así que los líderes moabitas se quedaron allí con Balaam. ");
INSERT INTO spavbl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Dios vino a Balaam y le preguntó: “¿Quiénes son estos hombres que están contigo?” ");
INSERT INTO spavbl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam le dijo a Dios: “Balac, hijo de Zipor, el rey de Moab, me envió este mensaje: ");
INSERT INTO spavbl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Escucha, ha llegado aquí un grupo de gente que ha venido de Egipto. Hay hordas de ellos. Por favor, ven inmediatamente y maldice a esta gente por mí. Tal vez así pueda luchar contra ellos y expulsarlos de mi país’”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Pero Dios le dijo a Balaam, “No debes volver con ellos. No debes maldecir a este pueblo porque están bendecidos”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Por la mañana Balaam se levantó y dijo a los mensajeros de Balac, “Vuelve al lugar de donde viniste porque el Señor se ha negado a permitirme ir contigo”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Los líderes moabitas se fueron. Volvieron donde Balac y le dijeron: “Balaam se negó a volver con nosotros”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Entonces Balac envió más líderes, unos que eran más prestigiosos que los anteriores. ");
INSERT INTO spavbl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Cuando llegaron le dijeron a Balaam: “Esto es lo que dice Balac hijo de Zipor: ‘Por favor, no dejes que nada te impida venir a verme, ");
INSERT INTO spavbl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","porque te pagaré mucho y seguiré todos los consejos que me des. Por favor, ven y maldice a este pueblo por mí’”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Pero Balaam le dijo a los oficiales de Balac, “Aunque Balac me diera todo su palacio lleno de plata y oro, no podría desobedecer el mandato del Señor mi Dios de ninguna manera. ");
INSERT INTO spavbl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ahora también deberías pasar la noche para ver si el Señor tiene algo más que decirme”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Dios vino a Balaam durante la noche y le dijo, “Ya que estos hombres han venido por ti, levántate y ve con ellos. Pero sólo haz lo que yo te diga”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Por la mañana Balaam se levantó, puso una silla en su asno y se fue con los líderes moabitas. ");
INSERT INTO spavbl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Dios se enfadó porque Balaam había decidido irse. El ángel del Señor vino y se paró en el camino para enfrentarlo. Balaam iba montado en su asno, y estaba acompañado por sus dos sirvientes. ");
INSERT INTO spavbl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","El asno vio al ángel del Señor de pie en el camino con una espada desenvainada, así que se apartó del camino y se fue a un campo. Así que Balaam lo golpeó para que volviera al camino. ");
INSERT INTO spavbl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Entonces el ángel del Señor se paró en una parte estrecha del camino que pasaba entre dos viñedos, con muros a ambos lados. ");
INSERT INTO spavbl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","El asno vio al ángel del Señor e intentó pasar. Empujó contra la pared y aplastó el pie de Balaam contra ella. Así que lo golpeó de nuevo. ");
INSERT INTO spavbl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Entonces el ángel del Señor se adelantó y se paró en un lugar estrecho donde no había espacio para pasar, ni a la derecha ni a la izquierda. ");
INSERT INTO spavbl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","El asno vio al ángel del Señor y se acostó bajo Balaam. Se enfadó y lo golpeó con su bastón. ");
INSERT INTO spavbl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","El Señor le dio al asno la habilidad de hablar y le dijo a Balaam: “¿Qué te he hecho para que me golpees tres veces?” ");
INSERT INTO spavbl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","“¡Me has hecho quedar como un estúpido!” Balaam le dijo al asno. “¡Si tuviera una espada, te mataría ahora!” ");
INSERT INTO spavbl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Pero el asno le preguntó a Balaam, “¿No soy yo el asno que has montado toda tu vida hasta hoy? ¿Alguna vez te he tratado así antes?” “No”, admitió. ");
INSERT INTO spavbl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Entonces el Señor le dio a Balaam la habilidad de ver al ángel del Señor de pie en el camino con una espada desenvainada. Balaam se inclinó y cayó al suelo boca abajo. ");
INSERT INTO spavbl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","El ángel del Señor le preguntó: “¿Por qué golpeaste a tu asno tres veces? Escucha, he venido a enfrentarme a ti porque estás siendo obstinado. ");
INSERT INTO spavbl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","El asno me vio y me evitó tres veces. Si no me hubiera evitado, ya te habría matado y dejado vivir al asno”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","“He pecado porque no me di cuenta de que estabas parado en el camino para enfrentarme”, dijo Balaam al ángel del Señor, “Así que, si esto no es lo que quieres, volveré a casa”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","El ángel del Señor le dijo a Balaam, “No, puedes ir con los hombres, pero sólo di lo que yo te diga”. Así que Balaam continuó con los oficiales de Balac. ");
INSERT INTO spavbl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Cuando Balac se enteró de que Balaam estaba en camino, fue a reunirse con él en el pueblo moabita en la frontera del río Arnón, el punto más alejado de su territorio. ");
INSERT INTO spavbl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Le dijo a Balaam, “¿No pensaste que mi llamada para que vinieras era urgente? ¿Por qué no viniste a mí inmediatamente? ¿Pensaste que no podía pagarte lo suficiente?” ");
INSERT INTO spavbl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","“Mira, estoy aquí contigo ahora, ¿no?” Balaam respondió. “¿Pero crees que puedo decir cualquier cosa? Sólo puedo decir las palabras que Dios me da para que las diga”. ");
INSERT INTO spavbl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Así que Balaam se fue con Balac y llegaron a Quiriath-huzot. ");
INSERT INTO spavbl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balac sacrificó ganado y ovejas, y compartió la carne con Balaam y los líderes que estaban con él. ");
INSERT INTO spavbl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","A la mañana siguiente Balac llevó a Balaam hasta Bamot-baal. Desde allí pudo ver la extensión del campamento israelita. ");
INSERT INTO spavbl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Entonces Balaam le dijo a Balac, “Constrúyeme siete altares aquí, y prepárame siete toros y siete carneros para un sacrificio”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balac hizo lo que Balaam había dicho, y juntos ofrecieron un toro y un carnero en cada altar. ");
INSERT INTO spavbl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam le dijo a Balac, “Espera aquí junto a tu holocausto mientras voy a ver si quizás el Señor vendrá y se reunirá conmigo. Cualquier cosa que me revele, la compartiré contigo”. Entonces Balaam se fue a escalar un peñasco rocoso. ");
INSERT INTO spavbl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Dios se encontró con él allí, y Balaam dijo. “He construido siete altares y en cada uno de ellos he ofrecido un toro y un carnero”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","El Señor le dio a Balaam un mensaje para compartir. Le dijo, “Vuelve a Balac y esto es lo que debes decirle”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Así que volvió a Balac, que estaba esperando allí junto a su holocausto, junto con todos los líderes moabitas. ");
INSERT INTO spavbl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Esta es la declaración que Balaam dio: “Balac me trajo de Harán; el rey de Moab me trajo de las montañas del este. Dijo: ‘¡Ven a maldecir a Jacob por mí! Ven y condena a Israel’. ");
INSERT INTO spavbl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","“Pero ¿cómo puedo maldecir lo que Dios no ha maldito? ¿Cómo puedo condenar lo que el Señor no ha condenado? ");
INSERT INTO spavbl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Porque yo los miro desde lo alto de los peñascos; los observo desde las colinas. Veo un pueblo que vive por su cuenta, diferente de las otras naciones. ");
INSERT INTO spavbl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","“¿Quién puede contar los descendientes de Jacob? ¡Son tantos que son como el polvo! ¿Quién puede contar hasta una cuarta parte de los israelitas? “¡Me gustaría morir como muere una persona buena! ¡Que el fin de mi vida sea como el fin de ellos!” ");
INSERT INTO spavbl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Entonces Balac se quejó a Balaam, “¿Qué esesto que me has hecho? Te traje aquí para maldecir a mis enemigos, ¡y ahora mira! ¡Todo lo que has hecho es bendecirlos!” ");
INSERT INTO spavbl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Pero Balaam respondió: “¿No crees que debería decir precisamente lo que el Señor me dice?” ");
INSERT INTO spavbl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Entonces Balac le dijo: “Por favor, ven conmigo a otro lugar donde puedas verlos. Pero sólo verás una parte de su campamento, no los verás a todos. Puedes maldecirlos por mí desde allí”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Lo llevó al campo de Zofim en la cima del Monte Pisga. Allí construyó siete altares y ofreció un toro y un carnero en cada altar. ");
INSERT INTO spavbl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam le dijo a Balac, “Espera aquí junto a tu holocausto mientras me encuentro con el Señor allí”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","El Señor se encontró con Balaam y le dio un mensaje para compartir. Le dijo, “Vuelve a Balac y esto es lo que debes decirle”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Así que volvió a Balac, que estaba esperando allí junto a su holocausto, junto con todos los líderes moabitas. “¿Qué dijo el Señor?” Preguntó Balac. ");
INSERT INTO spavbl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Esta es la profecía que Balaam cumplió: “¡Levántate, Balac, y presta atención! ¡Escúchame, hijo de Zipor! ");
INSERT INTO spavbl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","“Dios no es un ser humano que mentiría. No es un simple mortal que cambia de opinión. ¿Acaso él dice que va a hacer algo, pero no lo hace? ¿Acaso hace promesas que no cumple? ");
INSERT INTO spavbl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","“Mira, se me ha ordenado dar una bendición. Dios ha bendecido, y no puedo cambiar eso. ");
INSERT INTO spavbl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","No esperes que le pase nada malo a Jacob; no se prevé ningún problema para Israel. El Señor su Dios está con ellos; lo celebran como su rey. ");
INSERT INTO spavbl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dios los sacó de Egipto con gran poder, tan fuerte como un buey. ");
INSERT INTO spavbl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","No se puede lanzar ningún hechizo contra Jacob; no se puede usar ninguna magia contra Israel. La gente hablará de Jacob e Israel, diciendo: ‘¡Qué cosas tan asombrosas ha hecho Dios por ellos!’ ");
INSERT INTO spavbl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","¡Miren! Los israelitas salen a cazar como una leona; persiguen como un león. No descansan hasta que comen su presa, y beben la sangre de su víctima muerta”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Entonces Balac le dijo a Balaam, “¡Si no puedes darles ninguna maldición, al menos no les des ninguna bendición!” ");
INSERT INTO spavbl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Pero Balaam respondió: “¿No te he explicado que tengo que hacer todo lo que el Señor me diga?” ");
INSERT INTO spavbl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","“Por favor, ven conmigo y te llevaré a otro lugar”, dijo Balac. “Tal vez Dios te permita maldecirlos por mí desde allí”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balac llevó a Balaam a la cima del Monte Peor, que mira hacia los páramos. ");
INSERT INTO spavbl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam le dijo a Balac, “Constrúyeme siete altares aquí, y prepárame siete toros y siete carneros para sacrificar”. ");
INSERT INTO spavbl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balac le dijo lo que Balaam le dijo, y ofreció un toro y un carnero en cada altar. ");
INSERT INTO spavbl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Cuando Balaam vio que el Señor quería bendecir a Israel, eligió no usar la adivinación como lo había hecho anteriormente. En su lugar se volvió hacia el desierto, ");
INSERT INTO spavbl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","y al mirar a Israel acampado allí según sus respectivas tribus, el Espíritu de Dios vino sobre él. ");
INSERT INTO spavbl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Hizo una declaración, diciendo: ");
INSERT INTO spavbl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","“Esta es la profecía de Balaam, hijo de Beor, la profecía de un hombre que ve con los ojos bien abiertos, la profecía de uno que oye las palabras de Dios, que ve la visión dada por el Todopoderoso, que se inclina con respeto con los ojos abiertos. ");
INSERT INTO spavbl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“¡Qué bien puestas tus tiendas, Jacob; los lugares donde vives, Israel! ");
INSERT INTO spavbl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Parecen valles boscosos, como jardines junto a un río, como árboles de áloe que el Señor ha plantado, como cedros a la orilla del agua. ");
INSERT INTO spavbl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Los israelitas derramarán cubos de agua; sus descendientes tendrán mucha agua. Su rey será más grande que el rey Agag; su reino será glorioso. ");
INSERT INTO spavbl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dios los sacó de Egipto con gran poder, tan fuerte como un buey, destruyendo a las naciones enemigas, rompiéndoles los huesos, atravesándolos con flechas. ");
INSERT INTO spavbl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Son como un león que se agacha y se acuesta. Son como una leona que nadie se atreve a molestar. Quienes los bendigan serán bendecidos; y quienes los maldigan serán malditos”. ");
INSERT INTO spavbl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balac se enfadó con Balaam, y se golpeó los puños. Le dijo a Balaam, “Te traje aquí para maldecir a mis enemigos, ¡y ahora mira! Sigues bendiciéndolos, haciéndolo tres veces. ");
INSERT INTO spavbl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","¡Vete ahora mismo! ¡Vete a casa! Prometí pagarte bien, pero el Señor se ha asegurado de que no recibirás ningún pago”. ");
INSERT INTO spavbl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Pero Balaam le dijo a Balac: “¿No le expliqué ya a los mensajeros que enviaste ");
INSERT INTO spavbl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","que aunque me dieras todo tu palacio lleno de plata y oro, no podría hacer nada de lo que quisiera ni desobedecer el mandato del Señor mi Dios de ninguna manera? Sólo puedo decir lo que el Señor me dice. ");
INSERT INTO spavbl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","¡Escucha! Ahora vuelvo a casa con mi propio pueblo, pero primero déjame advertirte lo que estos israelitas van a hacer con tu pueblo en el futuro”. ");
INSERT INTO spavbl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Entonces Balaam hizo una declaración, diciendo: “Esta es la profecía de Balaam, hijo de Beor, la profecía de un hombre con los ojos bien abiertos ");
INSERT INTO spavbl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","la profecía de uno que escucha las palabras de Dios, que recibe el conocimiento del Altísimo, que ve la visión dada por el Todopoderoso, que se inclina con respeto con los ojos abiertos. ");
INSERT INTO spavbl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Lo veo, pero esto no es ahora. Lo observo, pero esto no está cerca. En el futuro, un líder como una estrella vendrá de Jacob, un gobernante con un cetro llegará al poder desde Israel. Aplastará las cabezas de los moabitas, y destruirá a todo el pueblo de Set. ");
INSERT INTO spavbl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","El país de Edom será conquistado, su enemigo Seir serán conquistados, y los israelitas saldrán victoriosos. ");
INSERT INTO spavbl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Un gobernante de Jacob vendrá y destruirá a los que queden en la ciudad”. ");
INSERT INTO spavbl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balaam dirigió su atención a los amalecitas y dio esta declaración sobre ellos, diciendo, “Amalec fue el primero entre las naciones, pero terminarán siendo destruidos”. ");
INSERT INTO spavbl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Dirigió su atención a los ceneos y dio esta declaración sobre ellos, diciendo, “Donde vives está seguro y protegido, como un nido en la cara de un acantilado. ");
INSERT INTO spavbl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Pero Caín será quemado cuando Asiria los conquiste”. ");
INSERT INTO spavbl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Luego Balaam hizo otra declaración, diciendo: “¡Es una tragedia! ¿Quién puede sobrevivir cuando Dios hace esto? ");
INSERT INTO spavbl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Se enviarán barcos desde Chipre para atacar Asiria y Eber, pero también serán destruidos permanentemente”. ");
INSERT INTO spavbl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Entonces Balaam se marchó y volvió a su país, y Balac se marchó también. ");
INSERT INTO spavbl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Cuando los israelitas se alojaban en Sitím los hombres empezaron a tener sexo con mujeres moabitas ");
INSERT INTO spavbl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","que los invitaban a los sacrificios hechos a sus dioses. Los israelitas comían las comidas paganas y se inclinaban ante estos dioses. ");
INSERT INTO spavbl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","De esta manera los israelitas se dedicaban a la adoración de Baal de Peor, y el Señor estaba enojado con ellos. ");
INSERT INTO spavbl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","El Señor le dijo a Moisés, “Arresta a todos los líderes israelitas y mátalos ante el Señor donde todos puedan ver para alejar la furiosa ira del Señor del pueblo”. ");
INSERT INTO spavbl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Así que Moisés instruyó a los jueces de Israel, “Cada uno de ustedes tiene que matar a todos sus hombres que se han dedicado a adorar a Baal de Peor”. ");
INSERT INTO spavbl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","En ese momento un hombre israelita llevó a una mujer madianita a la tienda de su familia a la vista de Moisés y de todos los israelitas mientras lloraban a la entrada del Tabernáculo de Reunión. ");
INSERT INTO spavbl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Al ver esto, Finees, hijo de Eleazar, hijo del sacerdote Aarón, abandonó la asamblea, agarró una lanza ");
INSERT INTO spavbl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","y siguió al hombre a su tienda. Allí, Finees atravesó con la lanza a ambos, al israelita y al estómago de la mujer. Esta acción detuvo la plaga que había empezado a matar a los israelitas, ");
INSERT INTO spavbl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","pero ya habían muerto 24.000. ");
INSERT INTO spavbl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finees hijo de Eleazar, hijo del sacerdote Aarón, ha alejado mi ira de los israelitas, porque de todos ellos estaba fervorosamente dedicado a mí, así que no destruí a los israelitas en mi apasionada ira. ");
INSERT INTO spavbl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Así que anunciad que le concedo mi acuerdo de paz. ");
INSERT INTO spavbl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Será un acuerdo que asegura un sacerdocio permanente para él y sus descendientes, porque se dedicó apasionadamente a su Dios y enderezó a los israelitas”. ");
INSERT INTO spavbl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","El nombre del israelita que fue asesinado con la mujer madianita era Zimri, hijo de Salu, un líder de la familia de la tribu de Simeón. ");
INSERT INTO spavbl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","El nombre de la mujer madianita que fue asesinada era Cozbi, hija de Zur, un líder de familia de la tribu de Madián. ");
INSERT INTO spavbl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ataca a los madianitas y mátalos, ");
INSERT INTO spavbl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","porque te atacaron engañosamente, llevándote por mal camino al usar a Peor y a su mujer Cozbi, la hija del líder madianita – la mujer que fue asesinada el día que llegó la plaga por su devoción a Peor –”. ");
INSERT INTO spavbl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Después de que la plaga terminó, el Señor le dijo a Moisés y Eleazar, hijo del sacerdote Aarón, ");
INSERT INTO spavbl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Censen a todos los israelitas por familia, todos aquellos de veinte años o más que sean elegibles para el servicio militar en el ejército de Israel”. ");
INSERT INTO spavbl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Allí, en la llanura de Moab, junto al Jordán, frente a Jericó, Moisés y Eleazar el sacerdote dio la orden, ");
INSERT INTO spavbl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Censar a los hombres de veinte años o más, siguiendo las instrucciones que el Señor dio a Moisés”. El siguiente es el registro genealógico de los que dejaron la tierra de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Estos eran los descendientes de Rubén, el primogénito de Israel: Hanoc, antepasado de la familia hanocítica; Falú, antepasado de la familia faluita; ");
INSERT INTO spavbl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezrón, antepasado de la familia hezronita; y Carmi, antepasado de la familia carmita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Estas fueron las familias descendientes de Rubén y fueron 43.730. ");
INSERT INTO spavbl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","El hijo de Falú era Eliab, ");
INSERT INTO spavbl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","y los hijos de Eliab eran Nemuel, Datán y Abiram. (Fueron Datán y Abiram, líderes escogidos por los israelitas, los que se unieron a la rebelión contra Moisés y Aarón con los seguidores de Coré cuando se rebelaron contra el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","La tierra se abrió y se los tragó, junto con Coré. Sus seguidores murieron cuando el fuego quemó a 250 hombres. Lo que les sucedió fue una advertencia para los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Pero los hijos de Coré no murieron). ");
INSERT INTO spavbl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Estos fueron los descendientes de Simeón por familia: Nemuel, antepasado de la familia Nemuelita; Jamin, antepasado de la familia Jaminita; Jacín, antepasado de la familia Jaquinita; ");
INSERT INTO spavbl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera, ancestro de la familia Zeraita; y Saul, ancestro de la familia Saulita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Estas eran las familias descendientes de Simeón y eran 22.200. ");
INSERT INTO spavbl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Estos fueron los descendientes de Gad por familia: Sefón, ancestro de la familia sefonita; Haggi, ancestro de la familia Haggite; Shuni, ancestro de la familia Shunite; ");
INSERT INTO spavbl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, ancestro de la familia Oznite; Eri, ancestro de la familia Erite; ");
INSERT INTO spavbl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, antepasado de la familia Arodita; Areli, antepasado de la familia Arelite. ");
INSERT INTO spavbl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Estas eran las familias descendientes de Gad y eran 40.500. ");
INSERT INTO spavbl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Los hijos de Judá que murieron en Canaán fueron Er y Onan. Estos eran los descendientes de Judá por familia: ");
INSERT INTO spavbl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Sela, antepasado de la familia selaíta; Fares, antepasado de la familia faresita; Zera, antepasado de la familia zeraíta. ");
INSERT INTO spavbl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Estos fueron los descendientes de Fares: Hezrón, ancestro de la familia hezronita; y Hamul, ancestro de la familia hamulita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Estas eran las familias descendientes de Judá y sumaban 76.500. ");
INSERT INTO spavbl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Estos fueron los descendientes de Isacar por familia: Tola, antepasado de la familia tolaíta; Púa, antepasado de la familia punita; ");
INSERT INTO spavbl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jasub, antepasado de la familia jasubita; y Simrón, antepasado de la familia simronita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Estas eran las familias descendientes de Isacar y sumaban 64.300. ");
INSERT INTO spavbl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Estos eran los descendientes de Zabulón por familia: Sered, antepasado de la familia seredita; Elón, antepasado de la familia elonita; y Jahleel, antepasado de la familia jahleelita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Estas eran las familias descendientes de Zabulón, y eran 60.500. ");
INSERT INTO spavbl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Estos fueron los descendientes de José por familia a través de Manasés y Efraín: ");
INSERT INTO spavbl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Los descendientes de Manasés: Maquir (era el padre de Galaad), antepasado de la familia maquirita; y Galaad, antepasado de la familia galaadita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Los descendientes de Galaad: Izer, antepasado de la familia Iezerita; Heled, antepasado de la familia helequita; ");
INSERT INTO spavbl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, antepasado de la familia asrielita; Siquem, antepasado de la familia siquemita; ");
INSERT INTO spavbl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida, antepasado de la familia Semidita; y Hefer, antepasado de la familia heferita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Zelofehad, hijo de Hefer, no tuvo hijos, sólo hijas. Se llamaban Maala, Noa, Hogla, Milca y Tirsa). ");
INSERT INTO spavbl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Estas eran las familias que descendían de Manasés, y eran 52.700. ");
INSERT INTO spavbl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Estos eran los descendientes de Efraín por familia: Sutela, antepasado de la familia sutelaíta; Bequer, antepasado de la familia bequerita; y Tahán, antepasado de la familia tahanita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","El descendiente de Suthelah era Erán, ancestro de la familia eranita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Estas eran las familias descendientes de Efraín, y sumaban 32.500. Estas familias eran descendientes de José. ");
INSERT INTO spavbl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Estos eran los descendientes de Benjamín por familia: Bela, antepasado de la familia Belaite; Asbel, antepasado de la familia asbelita; Ahiram, antepasado de la familia ahiramita; ");
INSERT INTO spavbl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sufán, antepasado de la familia sufamita; y Hufam, antepasado de la familia hufamita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Los descendientes de Bela fueron Ard, ancestro de la familia de arditas; y Naamán, ancestro de la familia Naamita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Estas fueron las familias descendientes de Benjamín, y sumaban 45.600. ");
INSERT INTO spavbl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Estos fueron los descendientes de Dan por familia: Súham, antepasado de las familias Suhamitas. ");
INSERT INTO spavbl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Todas eran familias suhamitas, y eran 64.400. ");
INSERT INTO spavbl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Estos eran los descendientes de Aser por familia: Imnah, antepasado de la familia imnite; Isvi, antepasado de la familia isvita; y Bería, antepasado de la familia beriaita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Los descendientes de Bería fueron Heber, antepasado de la familia heberita; y Malquiel, antepasado de la familia malquielita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","El nombre de la hija de Aser era Sera. ");
INSERT INTO spavbl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Estas eran las familias descendientes de Aser, y sumaban 53.400. ");
INSERT INTO spavbl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Estos eran los descendientes de Neftalí por familia: Jahzeel, antepasado de la familia jahzeelita; Guni, antepasado de la familia gunita; ");
INSERT INTO spavbl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer, antepasado de la familia jezerita; y Silem, antepasado de la familia silemita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Estas eran las familias descendientes de Neftalí, y sumaban 45.400. ");
INSERT INTO spavbl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","El total de todos los contados fue de 601.730. ");
INSERT INTO spavbl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Divide la tierra que se va a poseer en función del número de los censados. ");
INSERT INTO spavbl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Dale una mayor superficie de tierra a las tribus grandes, y una menor superficie a las tribus más pequeña. Cada tribu recibirá su asignación de tierra dependiendo de su número contado en el censo. ");
INSERT INTO spavbl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","“La tierra debe ser dividida por sorteo. Cada uno recibirá su tierra asignada en función del nombre de la tribu de su antepasado. ");
INSERT INTO spavbl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Cada asignación de tierra se dividirá por sorteo entre las tribus, ya sean grandes o pequeñas”. ");
INSERT INTO spavbl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Estos fueron los levitas censados por familia: Gerson, antepasado de la familia gersonita; Coat, antepasado de la familia coatita; y Merari, antepasado de la familia merarita. ");
INSERT INTO spavbl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Las siguientes fueron las familias de los levitas: la familia libnita, la familia hebronita, la familia mahlita, la familia musita y la familia coraíta. Coat era el padre de Amram, ");
INSERT INTO spavbl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","y el nombre de la esposa de Amram era Jocabed. Era descendiente de Levi, nacida mientras los levitas estaban en Egipto. Tuvo hijos con Amram: Aarón, Moisés y su hermana Miriam. ");
INSERT INTO spavbl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Los hijos de Aarón fueron Nadab, Abiú, Eleazar e Itamar, ");
INSERT INTO spavbl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","pero Nadab y Abiú murieron cuando ofrecieron fuego prohibido en presencia del Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","El número de los levitas censados ascendía a 23.000. Esto incluía a todos los varones de un mes o más. Sin embargo, no fueron contados con los otros israelitas, porque no se les dio ninguna asignación de tierras con los otros israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Este es el registro de los que fueron censados por Moisés y Eleazar el sacerdote cuando contaron a los israelitas en las llanuras de Moab al lado del Jordán frente a Jericó. ");
INSERT INTO spavbl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Sin embargo, no incluyeron ni uno solo que hubiera sido censado previamente por Moisés y el sacerdote Aarón cuando contaron a los israelitas en el desierto del Sinaí, ");
INSERT INTO spavbl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","porque el Señor les había dicho que todos morirían en el desierto. No quedó nadie excepto Caleb, hijo de Jefone, y Josué, hijo de Nun. ");
INSERT INTO spavbl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Las hijas de Zelofead vinieron a presentar su caso. Su padre Zelofehad era hijo de Hefer, hijo de Galaad, hijo de Maquir, hijo de Manasés, y era de la tribu de Manasés, hijo de José. Los nombres de sus hijas eran Maala, Noa, Hogla, Milca y Tirsa. Vinieron ");
INSERT INTO spavbl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","y se presentaron ante Moisés, el sacerdote Eleazar, los líderes y todos los israelitas a la entrada del Tabernáculo de Reunión. Dijeron, ");
INSERT INTO spavbl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nuestro padre murió en el desierto, pero no era uno de los seguidores de Coré que se unieron para rebelarse contra el Señor. No, murió por sus propios pecados, y no tuvo hijos. ");
INSERT INTO spavbl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","¿Por qué debería perderse el nombre de nuestra familia simplemente porque no tuvo un hijo? Danos tierra para que la poseamos junto a nuestros tíos”. ");
INSERT INTO spavbl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moisés llevó su caso ante el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","El Señor le dio esta respuesta, ");
INSERT INTO spavbl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Lo que las hijas de Zelofehad están diciendo es correcto. Debes darles tierra para que la posean junto a sus tíos, dales lo que se le habría asignado a su padre. ");
INSERT INTO spavbl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Además, dile a los israelitas: “Si un hombre muere y no tiene un hijo, dale su propiedad a su hija. ");
INSERT INTO spavbl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Si no tiene una hija, da su propiedad a sus hermanos. ");
INSERT INTO spavbl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Si no tiene hermanos, dé su propiedad a los hermanos de su padre. ");
INSERT INTO spavbl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Si su padre no tiene hermanos, déle su propiedad a los parientes más cercanos de su familia para que puedan ser dueños de ella. Esta es una regulación legal para los israelitas, dada como una orden del Señor a Moisés”. ");
INSERT INTO spavbl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","El Señor le dijo a Moisés: “Sube a los montes de Abarim para que veas la tierra que he dado a los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Después que la hayas visto, también te unirás a tus antepasados en la muerte, como lo hizo tu hermano Aarón, ");
INSERT INTO spavbl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","porque cuando los israelitas se quejaron en el desierto de Zin, ambos se rebelaron contra mis instrucciones de mostrar mi santidad ante ellos en lo que respecta al suministro de agua”. (Estas fueron las aguas de Meribá en Cades, en el desierto de Zin). ");
INSERT INTO spavbl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Entonces Moisés suplicó al Señor, ");
INSERT INTO spavbl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Que el Señor, el Dios que da la vida a todos los seres vivos, elija un hombre que guíe a los israelitas ");
INSERT INTO spavbl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","que les diga qué hacer y les muestre dónde ir, para que el pueblo del Señor no sea como ovejas sin pastor”. ");
INSERT INTO spavbl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","El Señor le dijo a Moisés: “Llama a Josué, hijo de Nun, un hombre que tiene el Espíritu en él, y pon tus manos sobre él. ");
INSERT INTO spavbl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Haz que se ponga delante del sacerdote Eleazar y de todos los israelitas, y dedícalo mientras ellos velan. ");
INSERT INTO spavbl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Entrégale algo de tu autoridad para que todos los israelitas le obedezcan. ");
INSERT INTO spavbl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Cuando necesite instrucciones deberá ir ante Eleazar, el sacerdote, quien orará al Señor en su nombre y consultará la decisión usando el Urim. Josué les dará órdenes a todos los israelitas sobre todo lo que deben hacer”. ");
INSERT INTO spavbl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moisés siguió las instrucciones del Señor. Hizo que Josué viniera y se pusiera delante del sacerdote Eleazar y de todos los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Moisés puso sus manos sobre Josué y lo dedicó, tal como el Señor le había dicho que hiciera. ");
INSERT INTO spavbl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Dales las siguientes normas a los israelitas: Debes presentarme en el momento apropiado mis ofrendas de comida para que las acepte. ");
INSERT INTO spavbl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Diles que debes presentar al Señor cada día dos corderos machos de un año como holocausto continua. ");
INSERT INTO spavbl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ofrece un cordero por la mañana y otro por la tarde antes de que oscurezca, ");
INSERT INTO spavbl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","junto con una décima parte de una efa de la mejor harina para una ofrenda de grano, mezclada con un cuarto de hin de aceite de oliva prensado. ");
INSERT INTO spavbl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","“Este es un holocausto continuo que se inició en el Monte Sinaí como una ofrenda aceptable para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","La ofrenda de bebida que acompaña a cada cordero debe ser un cuarto de hin. Vierte la ofrenda de bebida fermentada al Señor en el santuario. ");
INSERT INTO spavbl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ofrecerás el segundo cordero por la tarde antes de que oscurezca, junto con las mismas ofrendas de grano y bebida que por la mañana. Es un holocausto aceptable para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“En el día de reposo, presentarás los corderos machos de dos años, sin defectos, junto con una ofrenda de grano de dos décimas de efa de la mejor harina mezclada con aceite de oliva, y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Este holocausto debe ser presentado cada sábado además del holocausto continuo y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Al comienzo de cada mes, presentarán al Señor un holocausto de dos novillos, un carnero y siete corderos machos de un año, todos ellos sin defectos, ");
INSERT INTO spavbl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","junto con ofrendas de grano que consisten en tres décimas de una efa de la mejor harina mezclada con aceite de oliva para cada toro, dos décimas de una efa de la mejor harina mezclada con aceite de oliva para el carnero, ");
INSERT INTO spavbl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","y una décima de una efa de la mejor harina mezclada con aceite de oliva para cada uno de los corderos. Este es un holocausto aceptable para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","“Sus respectivas libaciones serán medio hin de vino por cada toro, un tercio de hin por el carnero y un cuarto de hin por cada cordero. Este es el holocausto mensual que se presentará cada mes durante el año. ");
INSERT INTO spavbl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Además del holocausto continuo con su libación, presentar un macho cabrío al Señor como ofrenda por el pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“La Pascua del Señor es el día catorce del primer mes. ");
INSERT INTO spavbl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Habrá una fiesta a los quince días de este mes, y durante siete días sólo se comerá pan sin levadura. ");
INSERT INTO spavbl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Celebrarán una reunión sagrada el primer día de la fiesta. No hagan ninguna actividad de su trabajo normal. ");
INSERT INTO spavbl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Preséntense ante el Señor con las siguientes ofrendas: un holocausto de dos novillos, un carnero y siete corderos de un año, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Sus ofrendas de grano se harán con la mejor harina mezclada con aceite de oliva: tres décimas de efa para cada toro, dos décimas de efa para el carnero, ");
INSERT INTO spavbl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","y una décima de efa para cada uno de los siete corderos. ");
INSERT INTO spavbl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Presenten también una cabra macho como ofrenda por el pecado para hacerte justicia. ");
INSERT INTO spavbl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Deben presentar estas ofrendas además del continuo holocausto de la mañana. ");
INSERT INTO spavbl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Presenta las mismas ofrendas todos los días durante siete días como holocausto para ser aceptado por el Señor. Deben ser ofrecidas con su libación y el continuo holocausto. ");
INSERT INTO spavbl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Celebren una reunión sagrada el séptimo día del festival. Ese día no harán su trabajo usual. ");
INSERT INTO spavbl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Durante la celebración del Festival de las Semanas, celebrarán una reunión sagrada el día de las primicias cuando presenten una ofrenda de grano nuevo al Señor. No hagan ningún tipo de trabajo. ");
INSERT INTO spavbl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Presenten un holocausto de dos novillos, un carnero y siete corderos de un año para ser aceptados por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Deben ir acompañados de sus ofrendas de grano de la mejor harina mezclada con aceite de oliva: tres décimos de un efa para cada toro, dos décimos de un efa para el carnero, ");
INSERT INTO spavbl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","y un décimo de un efa para cada uno de los siete corderos. ");
INSERT INTO spavbl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Presenten también una cabra macho como ofrenda para que los justifique. ");
INSERT INTO spavbl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Presenten estas ofrendas junto con sus libaciones además del holocausto continuo y su ofrenda de grano. Asegúrate de que los animales sacrificados no tengan defectos”. ");
INSERT INTO spavbl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Celebren una reunión sagrada el primer día del séptimo mes. No hagas nada de tu trabajo normal. Este es el día en que tocarás las trompetas. ");
INSERT INTO spavbl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Presenten un holocausto de un novillo, un carnero y siete corderos machos de un año, todos ellos sin defectos, como sacrificio aceptable al Señor, ");
INSERT INTO spavbl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","junto con sus ofrendas de grano de la mejor harina mezclada con aceite de oliva: tres décimos de un efa para el toro, dos décimos de un efa para el carnero, ");
INSERT INTO spavbl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","y un décimo de un efa para cada uno de los siete corderos machos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Presenten también una cabra macho como ofrenda por el pecado para hacerte justicia. ");
INSERT INTO spavbl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Estas ofrendas se suman a los holocaustos mensuales y diarios junto con las ofrendas de grano y las ofrendas de bebida requeridas. Son ofrendas quemadas aceptables para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Celebrarás una reunión sagrada el décimo día de este séptimo mes, y practiquen la abnegación. No hagas nada de tu trabajo normal. ");
INSERT INTO spavbl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Presenta un holocausto de un novillo, un carnero y siete corderos machos de un año, todos ellos sin defectos, aceptables para el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Deben ir acompañados de sus ofrendas de grano de la mejor harina mezclada con aceite de oliva: tres décimas de efa para el toro, dos décimas de efa para el carnero, ");
INSERT INTO spavbl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","y una décima de efa para cada uno de los siete corderos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Presenta también un macho cabrío como ofrenda por el pecado, además de la ofrenda por el pecado para corregirte y el holocausto continuo con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Celebrea una reunión sagrada el día quince del séptimo mes. No hagas nada de tu trabajo normal. Debes celebrar un festival dedicado al Señor durante siete días. ");
INSERT INTO spavbl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Presenta como holocausto aceptable al Señor: trece novillos, dos carneros y catorce corderos machos de un año, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Se acompañarán con sus ofrendas de grano de la mejor harina mezclada con aceite de oliva: tres décimas de efa de la mejor harina mezclada con aceite de oliva por cada uno de los trece toros, dos décimas de efa por cada uno de los dos carneros, ");
INSERT INTO spavbl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","y una décima de efa por cada uno de los catorce corderos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","También presentarás un macho cabrío como ofrenda por el pecado además del holocausto continuo con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“El segundo día, presente doce novillos, dos carneros y catorce corderos machos de un año, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Deben ir acompañados por sus ofrendas de grano y bebidas para los toros, carneros y corderos, todo según el número requerido. ");
INSERT INTO spavbl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Presenta también un macho cabrío como ofrenda por el pecado, además del continuo holocausto con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Al tercer día, presenta once novillos, dos carneros y catorce corderos machos de un año de edad, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Deben estar acompañados por sus ofrendas de grano y libaciones para los toros, carneros y corderos, todo de acuerdo al número requerido. ");
INSERT INTO spavbl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Presenta también un macho cabrío como ofrenda por el pecado además del holocausto continuo con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Al cuarto día presentarás diez novillos, dos carneros y catorce corderos machos de un año, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Deben ir acompañados por sus ofrendas de grano y libaciones para los toros, carneros y corderos, todo de acuerdo al número requerido. ");
INSERT INTO spavbl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","También presentarás un macho cabrío como ofrenda por el pecado, además del continuo holocausto con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“El quinto día presentarás nueve novillos, dos carneros y catorce corderos machos de un año, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Deben ir acompañados por sus ofrendas de grano y libaciones para los toros, carneros y corderos, todo de acuerdo con el número requerido. ");
INSERT INTO spavbl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Presentarás también un macho cabrío como ofrenda por el pecado, además del continuo holocausto con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Al sexto día presentarás ocho novillos, dos carneros y catorce corderos machos de un año, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Deben estar acompañados por sus ofrendas de grano y libaciones para los toros, carneros y corderos, todo de acuerdo al número requerido. ");
INSERT INTO spavbl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","También se presentará un macho cabrío como ofrenda por el pecado, además del continuo holocausto con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Al séptimo día presentar siete novillos, dos carneros y catorce corderos machos de un año de edad, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Deben estar acompañados por sus ofrendas de grano y libaciones para los toros, carneros y corderos, todo de acuerdo al número requerido. ");
INSERT INTO spavbl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","También se presentará un macho cabrío como ofrenda por el pecado, además del continuo holocausto con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“En el octavo día todos ustedes se reunirán juntos. No hagan nada de su trabajo normal. ");
INSERT INTO spavbl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Presenta como holocausto aceptable al Señor: un toro, dos carneros y siete corderos machos de un año, todos ellos sin defectos. ");
INSERT INTO spavbl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Deben ir acompañados de sus ofrendas de grano y de las libaciones para los toros, carneros y corderos, todo según el número requerido. ");
INSERT INTO spavbl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","También se presentará un macho cabrío como ofrenda por el pecado, además del continuo holocausto con su ofrenda de grano y su libación. ");
INSERT INTO spavbl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Presenta estas ofrendas al Señor en los momentos en que se te requiera, además de tus ofrendas para cumplir una promesa y las ofrendas de libre albedrío, ya sean holocaustos, ofrendas de grano, libaciones o sacrificios de paz”. ");
INSERT INTO spavbl_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moisés repitió todo esto a los israelitas como el Señor se lo ordenó. ");
INSERT INTO spavbl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moisés dijo a los jefes de las tribus de Israel: “Esto es lo que nos ordena el Señor: ");
INSERT INTO spavbl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Si un hombre hace una promesa solemne al Señor, o promete hacer algo jurando, no debe romper su promesa. Debe hacer todo lo que dijo que haría. ");
INSERT INTO spavbl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Si una mujer joven que aún vive en la casa de su padre hace una promesa solemne al Señor o se compromete a hacer algo mediante un juramento ");
INSERT INTO spavbl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","y su padre se entera de su promesa o juramento pero no le dice nada, todas las promesas o juramentos que ha hecho se mantendrán. ");
INSERT INTO spavbl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Pero si su padre las rechaza tan pronto como se entere, entonces ninguna de sus promesas o juramentos serán válidos. El Señor la liberará de cumplirlas porque su padre las ha desautorizado. ");
INSERT INTO spavbl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Si una mujer se casa después de haber hecho una promesa solemne o un juramento sin pensarlo ");
INSERT INTO spavbl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","y su marido se entera de ello pero no le dice nada inmediatamente, todas las promesas o juramentos que haya hecho se mantendrán. ");
INSERT INTO spavbl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Pero si su marido las rechaza cuando se entera de ello, entonces ninguna de sus promesas o juramentos permanecen válidos y el Señor la liberará de cumplirlos. ");
INSERT INTO spavbl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Toda promesa solemne hecha por una viuda o una mujer divorciada debe cumplirse. ");
INSERT INTO spavbl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Si una mujer que vive con su marido hace una promesa solemne al Señor o se compromete a hacer algo mediante un juramento, ");
INSERT INTO spavbl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","y su marido se entera de su promesa o juramento pero no le dice nada y no lo desautoriza, entonces ninguna de sus promesas o juramentos permanecen válidos. ");
INSERT INTO spavbl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Pero si su marido las rechaza tan pronto como se entera de ello, entonces ninguna de sus promesas o juramentos siguen siendo válidos. El Señor la liberará de mantenerlas porque su marido las ha rechazado. ");
INSERT INTO spavbl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","“Su marido también puede confirmar o rechazar cualquier promesa o juramento solemne que la mujer haga para negarse a sí misma. ");
INSERT INTO spavbl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Pero si su marido no le dice nunca una palabra al respecto, se supone que ha confirmado todas las promesas y juramentos solemnes que ella ha hecho. ");
INSERT INTO spavbl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Sin embargo, si él las rechaza algún tiempo después de enterarse de ellas, entonces él tendrá la responsabilidad de que ella las rompa”. ");
INSERT INTO spavbl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Estos son los preceptos que el Señor dio a Moisés sobre la relación entre un hombre y su esposa, y entre un padre y una hija que es joven y todavía vive en casa. ");
INSERT INTO spavbl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Castiga a los madianitas por lo que le hicieron a los israelitas. Después de eso te unirás a tus antepasados en la muerte”. ");
INSERT INTO spavbl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moisés instruyó al pueblo: “Que algunos de tus hombres se preparen para la batalla, para que puedan ir a atacar a los madianitas y llevar a cabo el castigo del Señor sobre ellos. ");
INSERT INTO spavbl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Debes contribuir con mil hombres de cada tribu israelita”. ");
INSERT INTO spavbl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Así que se eligieron mil hombres de cada tribu israelita, haciendo doce mil tropas listas para la batalla. ");
INSERT INTO spavbl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moisés los envió a la batalla, mil de cada tribu, junto con Finees, hijo del sacerdote Eleazar. Llevó consigo los objetos sagrados del santuario y las trompetas usadas para dar señales. ");
INSERT INTO spavbl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Atacaron a los madianitas, como el Señor le había dicho a Moisés, y mataron a todos los hombres. ");
INSERT INTO spavbl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Entre los muertos estaban los cinco reyes de Madián, Evi, Rekem, Zur, Hur y Reba. También mataron a Balaam, hijo de Beor, con la espada. ");
INSERT INTO spavbl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Los israelitas capturaron a las mujeres y niños madianitas, y tomaron como botín todas sus manadas, rebaños y posesiones. ");
INSERT INTO spavbl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Prendieron fuego a todos los pueblos y campamentos madianitas donde habían vivido, ");
INSERT INTO spavbl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","y se llevaron todo el saqueo y el botín, incluyendo personas y animales. ");
INSERT INTO spavbl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Llevaron los prisioneros, el saqueo y el pillaje a Moisés, al sacerdote Eleazar y al resto de los israelitas donde estaban acampados en las llanuras de Moab, junto al Jordán, frente a Jericó. ");
INSERT INTO spavbl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moisés, Eleazar el sacerdote y todos los líderes israelitas salieron del campamento para encontrarse con ellos. ");
INSERT INTO spavbl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moisés estaba enfadado con los oficiales del ejército, los comandantes de miles y los comandantes de cientos, que volvieron de la batalla. ");
INSERT INTO spavbl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","“¿Por qué dejaste vivir a todas las mujeres?” les preguntó. ");
INSERT INTO spavbl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","“¡Noten que estas mujeres sedujeron a los hombres israelitas, llevándolos a ser infieles al Señor en Peor, siguiendo el consejo de Balaam! Por eso el pueblo del Señor sufrió la plaga. ");
INSERT INTO spavbl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Así que ve y mata a todos los niños y a todas las mujeres que se hayan acostado con un hombre. ");
INSERT INTO spavbl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Deja vivir a todas las chicas que son vírgenes. Son tuyas. ");
INSERT INTO spavbl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Y todos aquellos que mataron a alguien o tocaron un cadáver deben permanecer fuera del campamento durante siete días. Purifíquense y purifiquen a sus prisioneros al tercer y séptimo día. ");
INSERT INTO spavbl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","También purifiquen toda su ropa y cualquier cosa hecha de cuero, pelo de cabra o madera”. ");
INSERT INTO spavbl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","El sacerdote Eleazar dijo a los soldados que habían ido a la batalla: “Estos son los preceptos legales que el Señor ha ordenado llevar a cabo a Moisés: ");
INSERT INTO spavbl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Todo lo que esté hecho de oro, plata, bronce, hierro, estaño y plomo, ");
INSERT INTO spavbl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","todo lo que no se queme, debe ser puesto al fuego para que quede limpio. Pero todavía tiene que ser purificado usando agua de purificación. Todo lo que se quema debe ser pasado por el agua. ");
INSERT INTO spavbl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Lava tu ropa en el séptimo día y estarás limpio. Entonces podrás entrar en el campamento”. ");
INSERT INTO spavbl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Tú, el sacerdote Eleazar, y los líderes de la familia israelita deben tomar un registro de las personas y animales que fueron capturados. ");
INSERT INTO spavbl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Luego divídanlos entre las tropas que entraron en batalla y el resto de los israelitas. ");
INSERT INTO spavbl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Tomen como contribución al Señor de lo que se asigna a las tropas que fueron a la batalla una de cada quinientas personas, ganado, asnos u ovejas. ");
INSERT INTO spavbl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Tomen esto de su media parte y denlo al sacerdote Eleazar como ofrenda al Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","“De los israelitas; la mitad de la parte, toma una de cada cincuenta personas, ganado, asnos u ovejas, u otros animales, y dáselos a los levitas que cuidan del Tabernáculo del Señor”. ");
INSERT INTO spavbl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moisés y el sacerdote Eleazar hicieron lo que el Señor había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Esta era la lista de los botines que quedaban y que habían sido saqueados por las tropas: 675.000 ovejas, ");
INSERT INTO spavbl_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72.000 vacas, ");
INSERT INTO spavbl_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61.000 burros, ");
INSERT INTO spavbl_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","y 32.000 vírgenes. ");
INSERT INTO spavbl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Esta era la mitad de los que habían ido a luchar: 337.500 ovejas, ");
INSERT INTO spavbl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","con una contribución para el Señor de 675 ");
INSERT INTO spavbl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36.000 bovinos, con una contribución para el Señor de 72, ");
INSERT INTO spavbl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30.500 burros, con una contribución para el Señor de 61, ");
INSERT INTO spavbl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","y 16.000 personas, con una contribución para el Señor de 32. ");
INSERT INTO spavbl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moisés dio la contribución al sacerdote Eleazar como ofrenda al Señor, como el Señor había ordenado a Moisés. ");
INSERT INTO spavbl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","La mitad de la parte de los israelitas se fue después de que Moisés diera la mitad de la parte a las tropas que habían ido a luchar, ");
INSERT INTO spavbl_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","consistió en: 337.500 ovejas, ");
INSERT INTO spavbl_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36.000 vacas, ");
INSERT INTO spavbl_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30.500 burros, ");
INSERT INTO spavbl_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","y 16.000 personas. ");
INSERT INTO spavbl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Moisés tomó de la mitad de los israelitas una de cada cincuenta personas y animales y les dio los levitas que cuidan del Tabernáculo del Señor, como el Señor le había ordenado. ");
INSERT INTO spavbl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Los oficiales del ejército, los comandantes de millares y los comandantes de centenas, se acercaron a Moisés ");
INSERT INTO spavbl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","y le dijeron: “Nosotros, tus siervos, hemos comprobado las tropas que mandamos y no falta ni un solo hombre. ");
INSERT INTO spavbl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Así que hemos traído al Señor una ofrenda de los objetos de oro que cada hombre recibió: brazaletes, pulseras, anillos, pendientes y collares, para que podamos estar bien ante el Señor”. ");
INSERT INTO spavbl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","El sacerdote Moisés y Eleazar aceptaron de ellos todos los objetos de oro. ");
INSERT INTO spavbl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","El oro que los comandantes de miles y cientos de personas dieron como ofrenda al Señor pesaba en total 16.750 siclos. ");
INSERT INTO spavbl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(Los hombres que habían luchado en la batalla habían tomado cada uno un botín para sí mismos). ");
INSERT INTO spavbl_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moisés y el sacerdote Eleazar aceptaron el oro de los comandantes de miles y cientos y lo llevaron al Tabernáculo de Reunión como ofrenda conmemorativa para los israelitas en presencia del Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Las tribus de Rubén y Gad tenían grandes cantidades de ganado y vieron que la tierra de Jazer y Galaad era un buen lugar para criarlos. ");
INSERT INTO spavbl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Entonces vinieron a Moisés, al sacerdote Eleazar y a los líderes israelitas y dijeron, ");
INSERT INTO spavbl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Las ciudades de Atarot, Dibón, Jazer, Nimra, Hesbón, Eleale, Sebam, Nebo y Beón, ");
INSERT INTO spavbl_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","que el Señor conquistó a la vista de los israelitas, son adecuados para el ganado que poseemos tus siervos”. ");
INSERT INTO spavbl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Continuaron: “Por favor, responde favorablemente a nuestra petición: danos esta tierra. No nos hagas cruzar el Jordán”. ");
INSERT INTO spavbl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","En respuesta Moisés preguntó a las tribus de Gad y Rubén: “¿Esperas que tus hermanos vayan a luchar mientras tú te quedas aquí sentado? ");
INSERT INTO spavbl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","¿Por qué desanimar a los israelitas para que no crucen al país que el Señor les ha dado? ");
INSERT INTO spavbl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Esto es lo que hicieron sus padres cuando los envié desde Cades-barnea a explorar la tierra. ");
INSERT INTO spavbl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Después de que sus padres viajaron por el valle de Escol y exploraron la tierra, desalentaron a los israelitas, persuadiéndolos de que no entraran en el país que el Señor les había dado. ");
INSERT INTO spavbl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Como resultado, hicieron enojar mucho al Señor ese día, y él hizo este juramento, ");
INSERT INTO spavbl_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Ni uno solo de los que salvé de Egipto, que tenga veinte años o más, verá jamás la tierra que prometí con el juramento de dar a Abraham, Isaac y Jacob, porque no estaban completamente comprometidos conmigo, ");
INSERT INTO spavbl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","nadie excepto Caleb, hijo de Jefone, el cenesita, y Josué, hijo de Nun, porque estaban completamente comprometidos conmigo’. ");
INSERT INTO spavbl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","El Señor se enojó con Israel y los hizo vagar por el desierto durante cuarenta años, hasta que murió toda la generación que había hecho el mal ante sus ojos. ");
INSERT INTO spavbl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“¡Miraos ahora, hijos de pecadores que han venido a ocupar el lugar de sus padres para hacer que el Señor se enfade aún más con Israel! ");
INSERT INTO spavbl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Si dejas de seguirlo, él volverá a abandonar a esta gente en el desierto, y su muerte será culpa tuya!” ");
INSERT INTO spavbl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Entonces las tribus de Gad y Rubén vinieron a Moisés y le dijeron: “Planeamos construir muros de piedra para mantener a salvo nuestro ganado y pueblos para nuestros hijos. ");
INSERT INTO spavbl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Pero aún así nos prepararemos para la batalla, y estaremos preparados para liderar a los israelitas hasta que puedan ocupar su tierra con seguridad. Mientras tanto, nuestros hijos se quedarán atrás, viviendo en los pueblos fortificados para protegerlos de la población local. ");
INSERT INTO spavbl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","No regresaremos a nuestros hogares hasta que cada israelita esté en posesión de su tierra asignada. ");
INSERT INTO spavbl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Sin embargo, no poseeremos ninguna tierra al otro lado del Jordán porque hemos recibido esta tierra para poseerla en este lado oriental del Jordán”. ");
INSERT INTO spavbl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moisés respondió: “Si esto es lo que realmente harán, si se preparan para la batalla bajo la dirección del Señor, ");
INSERT INTO spavbl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","y si todas sus tropas cruzan el Jordán con el Señor hasta que haya expulsado a sus enemigos delante de él, ");
INSERT INTO spavbl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","entonces una vez que el país sea conquistado con la ayuda del Señor entonces podrán regresar, y habrán cumplido sus obligaciones con el Señor y con Israel. Serás dueño de esta tierra, que te ha sido concedida por el Señor. ");
INSERT INTO spavbl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Pero si no lo haces, claramente estarás pecando contra el Señor, y las consecuencias de tu pecado te alcanzarán. ");
INSERT INTO spavbl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Adelante, construye ciudades para tus hijos y muros de piedra para tus rebaños, pero asegúrate de hacer lo que has prometido”. ");
INSERT INTO spavbl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Las tribus de Gad y Rubén prometieron a Moisés, “Señor, nosotros, tus siervos, haremos lo que tú has ordenado. ");
INSERT INTO spavbl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nuestras esposas e hijos, nuestro ganado y todos nuestros animales, permanecerán aquí en los pueblos de Galaad. ");
INSERT INTO spavbl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Pero nosotros, tus siervos, estamos listos para la batalla, y todas nuestras tropas cruzarán para luchar con la ayuda del Señor, tal como tú has dicho, señor”. ");
INSERT INTO spavbl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Moisés les dio las siguientes instrucciones sobre ellos al sacerdote Eleazar, a Josué, hijo de Nun, y a los jefes de familia de las tribus de Israel. ");
INSERT INTO spavbl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moisés les dijo: “Si las tribus de Gaditas y Rubén cruzan el Jordán contigo, con todas sus tropas listas para la batalla con la ayuda del Señor, y la tierra es conquistada a medida que avanzas, entonces dales la tierra de Galaad para que la posean. ");
INSERT INTO spavbl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Pero si no se preparan para la batalla y cruzan contigo, entonces deben aceptar su tierra asignada entre ustedes en el país de Canaán”. ");
INSERT INTO spavbl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Las tribus de Gad y Rubén respondieron: “Haremos lo que el Señor nos ha dicho, como sus siervos. ");
INSERT INTO spavbl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Cruzaremos y entraremos en el país de Canaán listos para la batalla con la ayuda del Señor, para que podamos tener nuestra parte de tierra asignada a este lado del Jordán”. ");
INSERT INTO spavbl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moisés dio a las tribus de Gad y Rubén y a la media tribu de Manasés, hijo de José, el reino de Sehón, rey de los amorreos, y el reino de Og, rey de Basán. Esta tierra incluía sus ciudades y sus alrededores. ");
INSERT INTO spavbl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Los pueblos de Gad reconstruyeron Dibon, Ataroth, Aroer, ");
INSERT INTO spavbl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarot-sofán, Jazer, Jogbeha, ");
INSERT INTO spavbl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-nimra y Bet-arán como ciudades fortificadas, y construyeron muros de piedra para sus rebaños. ");
INSERT INTO spavbl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","El pueblo de Rubén reconstruyó Hesbón, Eleale, Quiriataim, ");
INSERT INTO spavbl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","así como Nebo y Baal-meón (cambiando sus nombres), y Sibma. De hecho, cambiaron el nombre de los pueblos que reconstruyeron. ");
INSERT INTO spavbl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Los descendientes de Maquir, hijo de Manasés, atacaron a Galaad y lo capturaron. Expulsaron a los amorreos que vivían allí. ");
INSERT INTO spavbl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Entonces Moisés entregó a Galaad a la familia de Maquir, hijo de Manasés, y se establecieron allí. ");
INSERT INTO spavbl_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair, un descendiente de Manasés, atacó sus pueblos y los capturó. Los llamó las Aldeas de Jair. ");
INSERT INTO spavbl_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba atacó a Kenat y la capturó, junto con sus aldeas. La nombró Nobah en su honor. ");
INSERT INTO spavbl_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Este es un registro de los viajes realizados por los israelitas al salir de Egipto en sus divisiones tribales lideradas por Moisés y Aarón. ");
INSERT INTO spavbl_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moisés registró las diferentes partes de su viaje según las instrucciones del Señor. Estos son los viajes que hicieron listados en orden desde donde comenzaron: ");
INSERT INTO spavbl_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Los israelitas dejaron Ramsés el día quince del primer mes, el día después de la Pascua. Salieron triunfantes mientras todos los egipcios observaban. ");
INSERT INTO spavbl_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Los egipcios enterraban a todos sus primogénitos que el Señor había matado, porque el Señor había hecho caer sus juicios sobre sus dioses. ");
INSERT INTO spavbl_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Los israelitas dejaron Ramsés e instalaron un campamento en Sucot. ");
INSERT INTO spavbl_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Se fueron de Sucot y acamparon en Etam, en la frontera con el desierto. ");
INSERT INTO spavbl_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Se alejaron de Etam, volviendo a Pi-hahiroth, frente a Baal-zefón, y acamparon cerca de Migdol. ");
INSERT INTO spavbl_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Se mudaron de Pi-hahirot y cruzó por el medio del mar hacia el desierto. Viajaron durante tres días al desierto de Etham y establecieron un campamento en Marah. ");
INSERT INTO spavbl_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Se desplazaron desde Mara y llegaron a Elim, donde había doce manantiales de agua y setenta palmeras, y acamparon allí. ");
INSERT INTO spavbl_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Se trasladaron de Elim y acamparon al lado del Mar Rojo. ");
INSERT INTO spavbl_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Se trasladaron desde el Mar Rojo y acamparon en el Desierto del Pecado. ");
INSERT INTO spavbl_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Se trasladaron del desierto de Sin y acamparon en Dofca. ");
INSERT INTO spavbl_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Se mudaron de Dofca y acamparon en Alús. ");
INSERT INTO spavbl_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Se mudaron de Alús y acamparon en Refidím. No había agua allí para que la gente bebiera. ");
INSERT INTO spavbl_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Se fueron de Refidim y acamparon en el desierto del Sinaí. ");
INSERT INTO spavbl_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Se fueron del desierto del Sinaí y acamparon en Kibroth-hataava. ");
INSERT INTO spavbl_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Se mudaron de Kibroth-hattaavah y acamparon en Hazerot. ");
INSERT INTO spavbl_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Se trasladaron de Hazerot y establecieron un campamento en Ritma. ");
INSERT INTO spavbl_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Se trasladaron de Ritma y establecieron un campamento en Rimón-fares. ");
INSERT INTO spavbl_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Se trasladaron de Rimmon-fares y acamparon en Libna. ");
INSERT INTO spavbl_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Se trasladaron de Libna y establecieron un campamento en Rissa. ");
INSERT INTO spavbl_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Se trasladaron de Rissa y establecieron un campamento en Ceelata. ");
INSERT INTO spavbl_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Se trasladaron de Ceelata y acamparon en el Monte Sefer. ");
INSERT INTO spavbl_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Se trasladaron del Monte Sefer y acamparon en Harada. ");
INSERT INTO spavbl_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Se trasladaron de Harada y acamparon en Macelot. ");
INSERT INTO spavbl_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Se trasladaron de Macelot y acamparon en Tahat. ");
INSERT INTO spavbl_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Se fueron de Tahat y acamparon en Tara. ");
INSERT INTO spavbl_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Se mudaron de Tara y acamparon en Mitca. ");
INSERT INTO spavbl_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Se mudaron de Mitca y acamparon en Hasmona. ");
INSERT INTO spavbl_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Se fueron de Hasmona y acamparon en Moserot. ");
INSERT INTO spavbl_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Se mudaron de Moserot y acamparon en Bene-jaacán. ");
INSERT INTO spavbl_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Se mudaron de Bene-jaacán y acamparon en Hor-haggidgad. ");
INSERT INTO spavbl_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Se trasladaron de Hor-haggidgad y acamparon en Jotbata. ");
INSERT INTO spavbl_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Se mudaron de Jotbata y establecieron un campamento en Abrona. ");
INSERT INTO spavbl_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Se mudaron de Abrona y acamparon en Ezión-geber. ");
INSERT INTO spavbl_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Se trasladaron de Ezion-geber y acamparon en Cades, en el desierto de Zin. ");
INSERT INTO spavbl_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Se trasladaron de Cades y acamparon en el monte Hor, en la orilla de Edom. ");
INSERT INTO spavbl_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","El sacerdote Aarón subió al monte Hor como el Señor le había ordenado, y murió allí el primer día del quinto mes, en el cuadragésimo año después de que los israelitas hubieran salido de Egipto. ");
INSERT INTO spavbl_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aarón tenía 123 años cuando murió en el Monte Hor. ");
INSERT INTO spavbl_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","(El rey cananeo de Arad, que vivía en el Néguev en el país de Canaán, se enteró de que los israelitas estaban en camino). ");
INSERT INTO spavbl_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Los israelitas se trasladaron del Monte Hor y establecieron un campamento en Zalmona. ");
INSERT INTO spavbl_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Se trasladaron de Zalmona y acamparon en Punón. ");
INSERT INTO spavbl_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Se trasladaron de Punón y acamparon en Obot. ");
INSERT INTO spavbl_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Se trasladaron de Oboth y acamparon en Iye-abarim, en la frontera de Moab. ");
INSERT INTO spavbl_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Se mudaron de Iye-abarim y acamparon en Dibon-gad. ");
INSERT INTO spavbl_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Se mudaron de Dibon-gad y acamparon en Almon-diblataim. ");
INSERT INTO spavbl_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Se mudaron de Almon-diblataim y acamparon en las montañas de Abarim, frente a Nebo. ");
INSERT INTO spavbl_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Se trasladaron de las montañas de Abarim y acamparon en las llanuras de Moab, junto al Jordán, frente a Jericó. ");
INSERT INTO spavbl_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Allí, en las llanuras de Moab, acamparon al lado del Jordán, desde Beth-jesimot hasta Abel-sitim. ");
INSERT INTO spavbl_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Aquí fue donde, en la llanura de Moab junto al Jordán, frente a Jericó, el Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Dile a los israelitas: Tan pronto crucen el Jordán y entren en el país de Canaán, ");
INSERT INTO spavbl_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","deben expulsar a todos los que viven en la tierra, destruir todas sus imágenes talladas e ídolos de metal, y derribar todos sus templos paganos. ");
INSERT INTO spavbl_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Debes tomar el país y establecerte allí, porque te he dado la tierra y te pertenece. ");
INSERT INTO spavbl_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Debes dividir la tierra y asignarla por sorteo a las diferentes familias tribales. Dale una porción más grande a una familia más grande, y una porción más pequeña a una familia más pequeña. La asignación de cada uno se decide por sorteo, y todos ustedes recibirán una asignación dependiendo de su tribu. ");
INSERT INTO spavbl_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“Pero si no expulsan a todos los que viven en la tierra, las personas que dejen permanecer serán como arena en sus ojos y espinas en sus costados. Les causarán problemas cuando se establezcan en el país. ");
INSERT INTO spavbl_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Eventualmente, el castigo que planeé para ellos se los infligiré a ustedes”. ");
INSERT INTO spavbl_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Dales esta orden a los israelitas: Cuando entren en el país de Canaán, se les asignarán las posesiones con los siguientes límites: ");
INSERT INTO spavbl_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“La extensión sur de su país será desde el desierto de Zin a lo largo de la frontera de Edom. Su frontera sur correrá hacia el este desde el final del Mar Muerto, ");
INSERT INTO spavbl_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","cruzará al sur del Paso del Escorpión, hasta Zin, y alcanzará su límite sur al sur de Cades-barnea. Luego irá a Hazar-addar y a Azmon. ");
INSERT INTO spavbl_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Allí la frontera girará desde Azmon hasta el Wadi de Egipto, terminando en el Mar Mediterráneo. ");
INSERT INTO spavbl_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Su frontera occidental será la costa del Mar Mediterráneo. Este será su límite al oeste. ");
INSERT INTO spavbl_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Tu frontera norte irá desde el Mar Mediterráneo hasta el Monte Hor. ");
INSERT INTO spavbl_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Desde el Monte Hor la frontera irá a Lebo-hamat, luego a Zedad, ");
INSERT INTO spavbl_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","a Zifrón, terminando en Hazar-enan. Este será su límite al norte. ");
INSERT INTO spavbl_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“Su frontera oriental irá directamente de Hazar-enan a Sefan. ");
INSERT INTO spavbl_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Luego la frontera bajará de Sefam a Ribla en el lado este de Aín. Pasará a lo largo de las laderas al este del Mar de Galilea. ");
INSERT INTO spavbl_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Luego el límite bajará a lo largo del Jordán, terminando en el Mar Muerto. Esta será su tierra con sus fronteras circundantes”. ");
INSERT INTO spavbl_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moisés dio la orden a los israelitas, “Asignen la propiedad de esta tierra por sorteo. El Señor ha ordenado que sea entregada a las nueve tribus y media. ");
INSERT INTO spavbl_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Las tribus de Rubén y Gad, junto con la media tribu de Manasés, ya han recibido su asignación. ");
INSERT INTO spavbl_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Estas dos tribus y media han recibido su asignación en el lado este del Jordán, frente a Jericó”. ");
INSERT INTO spavbl_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Estos son los nombres de los hombres que se encargarán de asignar la propiedad de la tierra para ustedes: Eleazar el sacerdote y Josué, hijo de Nun. ");
INSERT INTO spavbl_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Que un líder de cada tribu ayude en la distribución de la tierra. ");
INSERT INTO spavbl_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Estos son sus nombres: “De la tribu de Judá: Caleb, hijo de Jefone. ");
INSERT INTO spavbl_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","De la tribu de Simeón: Semuel, hijo de Amiud. ");
INSERT INTO spavbl_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","De la tribu de Benjamín: Elidad, hijo de Quislón. ");
INSERT INTO spavbl_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Un líder de la tribu de Dan: Buqui, hijo de Jogli. ");
INSERT INTO spavbl_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Un líder de la tribu de Manasés, hijo de José: Haniel, hijo de Efod. ");
INSERT INTO spavbl_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Un líder de la tribu de Efraín: Kemuel, hijo de Siftán. ");
INSERT INTO spavbl_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Un líder de la tribu de Zabulón: Eli-zafán, hijo de Parnac. ");
INSERT INTO spavbl_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Un líder de la tribu de Isacar: Paltiel, hijo de Azán. ");
INSERT INTO spavbl_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Un líder de la tribu de Aser: Ahiud, hijo de Selomi. ");
INSERT INTO spavbl_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Un líder de la tribu de Neftalí: Pedael, hijo de Amiud”. ");
INSERT INTO spavbl_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Estos son los nombres de los que el Señor puso a cargo de la asignación de la propiedad de la tierra en el país de Canaán. ");
INSERT INTO spavbl_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","El Señor le habló a Moisés en las llanuras de Moab junto al Jordán, frente a Jericó. Le dijo, ");
INSERT INTO spavbl_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Ordena a los israelitas que provean de sus ciudades de asignación de tierras para que los levitas vivan y pasten alrededor de las ciudades. ");
INSERT INTO spavbl_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Las ciudades son para que vivan en ellas, y los pastos serán para sus rebaños y para todo su ganado. ");
INSERT INTO spavbl_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Los pastos alrededor de las ciudades que le des a los levitas se extenderán desde el muro mil codos por todos lados. ");
INSERT INTO spavbl_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Mide dos mil codos fuera de la ciudad al Este, dos mil al Sur, dos mil al Oeste y dos mil al Norte, con la ciudad en el medio. Estas áreas serán sus pastos alrededor de las ciudades. ");
INSERT INTO spavbl_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Seis de los pueblos que le das a los levitas serán pueblos santuarios, donde una persona que mata a alguien puede correr para protegerse. Además de estas ciudades, dale a los levitas cuarenta y dos más . ");
INSERT INTO spavbl_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","El número total de pueblos que le darás a los levitas es de cuarenta y ocho, junto con sus pastos. ");
INSERT INTO spavbl_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Las ciudades que asignes para ser entregadas a los levitas serán tomadas del territorio de los israelitas, y tomarás más de las tribus más grandes y menos las más pequeñas. El número será proporcional al tamaño de la asignación de tierras de cada tribu”. ");
INSERT INTO spavbl_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","El Señor le dijo a Moisés, ");
INSERT INTO spavbl_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Dile a los israelitas: ‘Cuando cruces el Jordán hacia Canaán, ");
INSERT INTO spavbl_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","escoge pueblos como tus pueblos de santuario, para que una persona que mate a alguien por error pueda correr allí. ");
INSERT INTO spavbl_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Estas ciudades serán para ustedes santuario de los que buscan venganza, para que el asesino no muera hasta que sea juzgado en un tribunal. ");
INSERT INTO spavbl_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","“Las ciudades que elijan serán sus seis ciudades santuario. ");
INSERT INTO spavbl_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Elijan tres ciudades al otro lado del Jordán y tres en Canaán como ciudades de refugio. ");
INSERT INTO spavbl_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Estas seis ciudades serán lugares de santuario para los israelitas y para los extranjeros o colonos entre ellos, de modo que cualquiera que mate a una persona por error pueda correr allí. ");
INSERT INTO spavbl_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Pero si alguien golpea deliberadamente a alguien con algo hecho de hierro y lo mata, esa persona es un asesino y debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Si alguien tomaun trozo de piedra que pueda ser usado como arma y golpea a alguien con ella, y lo mata, esa persona es un asesino y debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Si alguien tomaun trozo de madera que pueda ser usado como arma y golpea a alguien con ella, y lo mata, esa persona es un asesino y debe ser ejecutado. ");
INSERT INTO spavbl_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","“El vengador debe ejecutar al asesino. Cuando encuentre al asesino, lo matará. ");
INSERT INTO spavbl_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","De la misma manera, si uno odia al otro y lo derriba o le tira algo deliberadamente, y lo mata; ");
INSERT INTO spavbl_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","o si alguien golpea a otro con su mano y mueren, el que lo golpeó debe ser ejecutado porque es un asesino. Cuando el vengador encuentra al asesino, debe matarlo. ");
INSERT INTO spavbl_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Pero si alguien derriba a otro sin querer y sin odiarlo, o le tira algo sin querer hacerle daño, ");
INSERT INTO spavbl_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","o deja caer descuidadamente una piedra pesada que lo mata, pero no como enemigo o con intención de hacerle daño, ");
INSERT INTO spavbl_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","entonces la comunidad debe juzgar entre el asesino y el vengador siguiendo este reglamento. ");
INSERT INTO spavbl_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","El tribunal debe proteger al asesino de ser atacado por el vengador y debe devolverlo a la ciudad santuario a la que corrió, y debe permanecer allí hasta la muerte del sumo sacerdote, que fue ungido con el óleo santo. ");
INSERT INTO spavbl_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“Pero si el asesino sale de los límites de la ciudad santuario a la que huyó, ");
INSERT INTO spavbl_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","y el vengador lo encuentra fuera de su ciudad santuario y lo mata, entonces el vengador no será culpable de asesinato, ");
INSERT INTO spavbl_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","porque el asesino tiene que permanecer en su ciudad santuario hasta la muerte del sumo sacerdote. Sólo después de la muerte del sumo sacerdote se les permite volver a la tierra que poseen. ");
INSERT INTO spavbl_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Estas normas se aplican a todas las generaciones futuras dondequiera que vivan. ");
INSERT INTO spavbl_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Si alguien mata a una persona, el asesino debe ser ejecutado basándose en las pruebas aportadas por los testigos, en plural. Nadie debe ser ejecutado basándose en la evidencia dada por un solo testigo. ");
INSERT INTO spavbl_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“No se aceptará el pago en lugar de ejecutar a un asesino que ha sido declarado culpable. ");
INSERT INTO spavbl_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Tampoco se le permite aceptar el pago de una persona que huye a una ciudad santuario y le permite regresar y vivir en su propia tierra antes de la muerte del sumo sacerdote. ");
INSERT INTO spavbl_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“No contaminen la tierra donde viven porque el derramamiento de sangre contamina la tierra, y la tierra donde se derrama la sangre no puede ser purificada excepto por la sangre de quien la derrama. ");
INSERT INTO spavbl_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","No hagas impura la tierra donde vives porque yo también vivo allí. Yo soy el Señor, y vivo con los israelitas’”. ");
INSERT INTO spavbl_vpl